# Arduino wolfSSL Library

This library is restructured from [wolfSSL](https://github.com/wolfSSL/wolfssl/) Release 5.8.4 for the Arduino platform.

The Official wolfSSL Arduino Library is found in [The Library Manager index](http://downloads.arduino.cc/libraries/library_index.json).

See the [Arduino-wolfSSL logs](https://downloads.arduino.cc/libraries/logs/github.com/wolfSSL/Arduino-wolfSSL/) for publishing status.

Instructions for installing and using libraries can be found in the [Arduino docs](https://docs.arduino.cc/software/ide-v1/tutorials/installing-libraries/).

## wolfSSL Configuration

As described in the [Getting Started with wolfSSL on Arduino](https://www.wolfssl.com/getting-started-with-wolfssl-on-arduino/), wolfSSL features are enabled and disabled in the `user_settings.h` file.

The `user_settings.h` file is found in the `<Arduino>/libraries/wolfssl/src` directory.

For Windows this is typically `C:\Users\%USERNAME%\Documents\Arduino\libraries\wolfssl\src`

For Mac: `~/Documents/Arduino/libraries/wolfssl/src`

For Linux: `~/Arduino/libraries/wolfssl/src`

Tips for success:

- The `WOLFSSL_USER_SETTINGS` macro must be defined project-wide. (see [wolfssl.h](https://github.com/wolfSSL/wolfssl/blob/master/IDE/ARDUINO/wolfssl.h))
- Apply any customizations only to `user_settings.h`;  Do not edit wolfSSL `settings.h` or `configh.h` files.
- Do not explicitly include `user_settings.h` in any source file.
- For every source file that uses wolfssl, include `wolfssl/wolfcrypt/settings.h` before any other wolfSSL include, typically via `#include "wolfssl.h"`.
- See the [wolfSSL docs](https://www.wolfssl.com/documentation/manuals/wolfssl/chapter02.html) for details on build configuration macros.

## wolfSSL Examples

Additional wolfSSL examples can be found at:

- https://github.com/wolfSSL/wolfssl/tree/master/IDE/ARDUINO

- https://github.com/wolfSSL/wolfssl/tree/master/examples

- https://github.com/wolfSSL/wolfssl-examples/

## Arduino Releases

See GitHub for [all Arduino wolfSSL releases](https://github.com/wolfSSL/Arduino-wolfSSL/releases).

The `./wolfssl-arduino.sh INSTALL` [script](https://github.com/wolfSSL/wolfssl/tree/master/IDE/ARDUINO) can be used to install specific GitHub versions as needed.

# wolfSSL Embedded SSL/TLS Library

The [wolfSSL embedded SSL library](https://www.wolfssl.com/products/wolfssl/)
(formerly CyaSSL) is a lightweight SSL/TLS library written in ANSI C and
targeted for embedded, RTOS, and resource-constrained environments - primarily
because of its small size, speed, and feature set.  It is commonly used in
standard operating environments as well because of its royalty-free pricing
and excellent cross platform support. wolfSSL supports industry standards up
to the current [TLS 1.3](https://www.wolfssl.com/tls13) and DTLS 1.3, is up to
20 times smaller than OpenSSL, and offers progressive ciphers such as ChaCha20,
Curve25519, Blake2b and Post-Quantum TLS 1.3 groups. User benchmarking and
feedback reports dramatically better performance when using wolfSSL over
OpenSSL.

wolfSSL is powered by the wolfCrypt cryptography library. Two versions of
wolfCrypt have been FIPS 140-2 validated (Certificate #2425 and
certificate #3389). FIPS 140-3 validated (Certificate #4718). For additional
information, visit the [wolfCrypt FIPS FAQ](https://www.wolfssl.com/license/fips/)
or contact fips@wolfssl.com.

## Why Choose wolfSSL?

There are many reasons to choose wolfSSL as your embedded, desktop, mobile, or
enterprise SSL/TLS solution. Some of the top reasons include size (typical
footprint sizes range from 20-100 kB), support for the newest standards
(SSL 3.0, TLS 1.0, TLS 1.1, TLS 1.2, TLS 1.3, DTLS 1.0, DTLS 1.2, and DTLS 1.3),
current and progressive cipher support (including stream ciphers), multi-platform,
royalty free, and an OpenSSL compatibility API to ease porting into existing
applications which have previously used the OpenSSL package. For a complete
feature list, see [Chapter 4](https://www.wolfssl.com/docs/wolfssl-manual/ch4/)
of the wolfSSL manual.

## Notes, Please Read

### Note 1
wolfSSL as of 3.6.6 no longer enables SSLv3 by default. By default, wolfSSL
disables static key cipher suites that use PSK, RSA, or ECDH without ephemeral
key exchange. Instead, wolfSSL enables cipher suites that provide perfect
forward secrecy (PFS) using ephemeral Diffie-Hellman (DH) or Elliptic Curve
(ECC) key exchange, both of which are enabled by default.

If you need to support legacy systems that require static key cipher suites,
you can enable them using one or more of these defines:

* `WOLFSSL_STATIC_DH`
* `WOLFSSL_STATIC_RSA`
* `WOLFSSL_STATIC_PSK`

**Important:** Static key cipher suites reduce security by eliminating perfect
forward secrecy. These cipher suites reuse the same long-term private key for
all session key exchanges. In contrast, PFS-enabled cipher suites (the wolfSSL
default) generate a new ephemeral key for each session, ensuring that
compromising a long-term key cannot decrypt past sessions.

When compiling `ssl.c`, wolfSSL will now issue a compiler error if no cipher
suites are available. You can remove this error by defining
`WOLFSSL_ALLOW_NO_SUITES` in the event that you desire that, i.e., you're
not using TLS cipher suites.

### Note 2
wolfSSL takes a different approach to certificate verification than OpenSSL
does. The default policy for the client is to verify the server, this means
that if you don't load CAs to verify the server you'll get a connect error,
no signer error to confirm failure (-188).

If you want to mimic OpenSSL behavior of having `SSL_connect` succeed even if
verifying the server fails and reducing security you can do this by calling:

```c
wolfSSL_CTX_set_verify(ctx, WOLFSSL_VERIFY_NONE, NULL);
```

before calling `wolfSSL_new();`. Though it's not recommended.

### Note 3
The enum values SHA, SHA256, SHA384, SHA512 are no longer available when
wolfSSL is built with `--enable-opensslextra` (`OPENSSL_EXTRA`) or with the
macro `NO_OLD_SHA_NAMES`. These names get mapped to the OpenSSL API for a
single call hash function. Instead the name `WC_SHA`, `WC_SHA256`, `WC_SHA384` and
`WC_SHA512` should be used for the enum name.


# wolfSSL Release 5.8.4 (Nov. 20, 2025)

Release 5.8.4 has been developed according to wolfSSL's development and QA
process (see link below) and successfully passed the quality criteria.
https://www.wolfssl.com/about/wolfssl-software-development-process-quality-assurance

NOTE: * --enable-heapmath is deprecated
            * MD5 is now disabled by default

PR stands for Pull Request, and PR <NUMBER> references a GitHub pull request number where the code change was added.

## Vulnerabilities
* [Low CVE-2025-12888] Vulnerability in X25519 constant-time cryptographic implementations due to timing side channels introduced by compiler optimizations and CPU architecture limitations, specifically with the Xtensa-based ESP32 chips. If targeting Xtensa it is recommended to use the low memory implementations of X25519, which is now turned on as the default for Xtensa. Thanks to Adrian Cinal for the report. Fixed in PR 9275.


* [Med. CVE-2025-11936] Potential DoS vulnerability due to a memory leak through multiple KeyShareEntry with the same group in malicious TLS 1.3 ClientHello messages. This affects users who are running wolfSSL on the server side with TLS 1.3. Thanks to Jaehun Lee and Kyungmin Bae, Pohang University of Science and Technology (POSTECH) for the report. Fixed in PR 9117.

* [Low CVE-2025-11935] PSK with PFS (Perfect Forward Secrecy) downgrades to PSK without PFS during TLS 1.3 handshake. If the client sends a ClientHello that has a key share extension and the server responds with a ServerHello that does not have a key share extension the connection would previously continue on without using PFS. Thanks to Jaehun Lee from Pohang University of Science and Technology (POSTECH) for the report. Fixed in PR 9112.

* [Low CVE-2025-11934] Signature Algorithm downgrade from ECDSA P521 to P256 during TLS 1.3 handshake. When a client sends ECDSA P521 as the supported signature algorithm the server previously could respond as ECDSA P256 being the accepted signature algorithm and the connection would continue with using ECDSA P256. Thanks to Jaehun Lee from Pohang University of Science and Technology (POSTECH) for the report. Fixed in PR 9113.


* [Low CVE-2025-11933] DoS Vulnerability in wolfSSL TLS 1.3 CKS extension parsing. Previously duplicate CKS extensions were not rejected leading to a potential memory leak when processing a ClientHello. Thanks to Jaehun Lee from Pohang University of Science and Technology (POSTECH) for the report. Fixed in PR 9132.


* [Low CVE-2025-11931] Integer Underflow Leads to Out-of-Bounds Access in XChaCha20-Poly1305 Decrypt. This issue is hit specifically with a call to the function wc_XChaCha20Poly1305_Decrypt() which is not used with TLS connections, only from direct calls from an application. Thanks to Luigino Camastra from Aisle Research for the report. Fixed in PR 9223.

* [Low CVE-2025-11932] Timing Side-Channel in PSK Binder Verification. The server previously verified the TLS 1.3 PSK binder using a non-constant time method which could potentially leak information about the PSK binder. Thanks to Luigino Camastra from Aisle Research for the report. Fixed in PR 9223.

* [Low CVE-2025-12889] With TLS 1.2 connections a client can use any digest, specifically a weaker digest, rather than those in the CertificateRequest. Thanks to Jaehun Lee from Pohang University of Science and Technology (POSTECH) for the report. Fixed in PR 9395

## New Features
* New ML-KEM / ML-DSA APIs and seed/import PKCS8 support; added _new/_delete APIs for ML-KEM/ML-DSA. (PR 9039, 9000, 9049)
* Initial wolfCrypt FreeBSD kernel module support (PR 9392)
* Expanded PKCS7/CMS capabilities: decode SymmetricKeyPackage / OneSymmetricKey, add wc_PKCS7_GetEnvelopedDataKariRid, and allow PKCS7 builds with AES keywrap unset. (PR 9018, 9029, 9032)
* Add custom AES key wrap/unwrap callbacks and crypto callback copy/free operations. (PR 9002, 9309)
* Add support for certificate_authorities extension in ClientHello and certificate manager CA-type selection/unloading. (PR 9209, 9046)
* Large expansion of Rust wrapper modules: random, aes, rsa, ecc, dh, sha, hmac, cmac, ed25519/ed448, pbkdf2/PKCS#12, kdf/prf, SRTP KDFs, and conditional compilation options. (PR 9191, 9212, 9273, 9306, 9320, 9328, 9368, 9389, 9357, 9433)
* Rust: support optional heap and dev_id parameters and enable conditional compilation based on C build options. (PR 9407, 9433)
* STM32 fixes (benchmarking and platform fixes) and PSoC6 hardware acceleration additions. (PR 9228, 9256, 9185)
* STM32U5 added support for SAES and DHUK. (PR 9087)
* Add --enable-curl=tiny option for a smaller build when used with cURL. (PR 9174)

## Improvements / Optimizations
* Regression test fixes and expansion: TLS 1.3/1.2 tests, ARDUINO examples, libssh2 tests, hostap workflows, and nightly test improvements. (PR 9096, 9141, 9091, 9122, 9388)
* Improved test ordering and CI test stability (random tests run order changes, FIPS test fixes). (PR 9204, 9257)
* Docs and readme fixes, docstring updates, AsconAEAD comment placement, and example certificate renewals. (PR 9131, 9293, 9262, 9429)
* Updated GPL exception lists (GPLv2 and GPLv3 exception updates: add Fetchmail and OpenVPN). (PR 9398, 9413)
* Introduced WOLFSSL_DEBUG_CERTS and additional debug/logging refinements. (PR 8902, 9055)
* Expanded crypto-callback support (SHA family, HKDF, SHA-224, sha512_family digest selection) and improved crypto-only build cases. (PR 9070, 9252, 9271, 9100, 9194)
* AES & HW offload improvements including AES-CTR support in PKCS11 driver and AES ECB offload sizing fix. (PR 9277, 9364)
* ESP32: PSRAM allocator support and SHA HW fixes for ESP-IDF v6/v5. (PR 8987, 9225, 9264)
* Renesas FSP / RA examples updated and security-module TLS context improvements. (PR 9047, 9010, 9158, 9150)
* Broad configure/CMake/Autotools workflow improvements (Apple options tracking, Watcom pinning, Debian packaging, ESP-IDF pinning). (PR 9037, 9167, 9161, 9264)
* New assembly introspection / performance helpers for RISC-V and PPC32; benchmarking enhancements (cycle counts). (PR 9101, 9317)
* Update to SGX build for using assembly optimizations. (PR 8463, 9138)
* Testing with Fil-C compiler version to 0.674 (PR 9396)
* Refactors and compressing of small stack code (PR 9153)

## Bug Fixes
* Removed the test feature using popen when defining the macro WOLFSSL_USE_POPEN_HOST and not having HAVE_GETADDRINFO defined, along with having the macro HAVE_HTTP_CLIENT set. There was the potential for vulnerable behavior with the use of popen when the API wolfSSL_BIO_new_connect() was called with this specific build. This exact build configuration is only intended for testing with QEMU and is not enabled with any autoconf/cmake flags. Thanks to linraymond2006 for the report. (PR 9038)
* Fix for C# wrapper Ed25519 potential crash and heap overwrite with raw public key import when using the API Ed25519ImportPublic.This was a broken API with the C# wrapper that would crash on use. Thanks to Luigino Camastra from Aisle Research for the bug report. (PR 9291)
* Coverity, cppcheck, MISRA, clang-tidy, ZeroPath and other static-analysis driven fixes across the codebase. (PR 9006, 9078, 9068, 9265, 9324)
* TLS 1.2/DTLS improvements: client message order checks, DTLS cookie/exchange and replay protections, better DTLS early-data handling. (PR 9387, 9253, 9205, 9367)
* Improved X.509 & cert handling: allow larger pathLen in Basic Constraints, restore inner server name for ECH, retrying cert candidate chains. (PR 8890, 9234, 8692)
* Sniffer robustness: fix infinite recursion, better handling of OOO appData and partial overlaps, and improved retransmission detection. (PR 9051, 9106, 9140, 9094)
* Numerous linuxkm (kernel-mode) fixes, relocation/PIE normalization, and FIPS-related build tweaks across many iterations. (PR 9025, 9035, 9067, 9111, 9121)
* ML-KEM/Kyber and ML-DSA fixes for out-of-bounds and seed-import correctness; multiple ML-related safety fixes. (PR 9142, 9105, 9439)
* Avoid uninitialized-variable and GCC warnings; several fixes for undefined-shift/overflow issues. (PR 9020, 9372, 9195)
* Memory & leak fixes in X509 verification and various struct sizing fixes for WOLFSSL_NO_MALLOC usage. (PR 9258, 9036)
* Fixed RSA / signing / verify-only warnings allowing WOLFSSL_NO_CT_OPS when WOLFSSL_RSA_VERIFY_ONLY is used and API cleanups for using const. (PR 9031, 9263)

For additional vulnerability information visit the vulnerability page at:
https://www.wolfssl.com/docs/security-vulnerabilities/

See INSTALL file for build instructions.
More info can be found on-line at: https://wolfssl.com/wolfSSL/Docs.html

# Resources

[wolfSSL Website](https://www.wolfssl.com/)

[wolfSSL Wiki](https://github.com/wolfSSL/wolfssl/wiki)

[FIPS 140-2/140-3 FAQ](https://wolfssl.com/license/fips)

[wolfSSL Documentation](https://wolfssl.com/wolfSSL/Docs.html)

[wolfSSL Manual](https://wolfssl.com/wolfSSL/Docs-wolfssl-manual-toc.html)

[wolfSSL API Reference](https://wolfssl.com/wolfSSL/Docs-wolfssl-manual-17-wolfssl-api-reference.html)

[wolfCrypt API Reference](https://wolfssl.com/wolfSSL/Docs-wolfssl-manual-18-wolfcrypt-api-reference.html)

[TLS 1.3](https://www.wolfssl.com/docs/tls13/)

[wolfSSL Vulnerabilities](https://www.wolfssl.com/docs/security-vulnerabilities/)

[Additional wolfSSL Examples](https://github.com/wolfssl/wolfssl-examples)

# Directory structure

```
<wolfssl_root>
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ certs   [Certificates used in tests and examples]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ cmake   [Cmake build utilities]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ debian  [Debian packaging files]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ doc     [Documentation for wolfSSL (Doxygen)]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ Docker  [Prebuilt Docker environments]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ examples    [wolfSSL examples]
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ asn1    [ASN.1 printing example]
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ async   [Asynchronous Cryptography example]
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ benchmark   [TLS benchmark example]
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ client  [Client example]
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ configs [Example build configurations]
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ echoclient  [Echoclient example]
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ echoserver  [Echoserver example]
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ pem [Example for convert between PEM and DER]
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ sctp    [Servers and clients that demonstrate wolfSSL's DTLS-SCTP support]
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€â€Ã¢â€â‚¬Ã¢â€â‚¬ server  [Server example]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ IDE     [Contains example projects for various development environments]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ linuxkm [Linux Kernel Module implementation]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ m4      [Autotools utilities]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ mcapi   [wolfSSL MPLAB X Project Files]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ mplabx  [wolfSSL MPLAB X Project Files]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ mqx     [wolfSSL Freescale CodeWarrior Project Files]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ rpm     [RPM packaging metadata]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ RTOS
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€â€Ã¢â€â‚¬Ã¢â€â‚¬ nuttx   [Port of wolfSSL for NuttX]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ scripts [Testing scripts]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ src     [wolfSSL source code]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ sslSniffer  [wolfSSL sniffer can be used to passively sniff SSL traffic]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ support [Contains the pkg-config file]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ tests   [Unit and configuration testing]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ testsuite   [Test application that orchestrates tests]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ tirtos  [Port of wolfSSL for TI RTOS]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ wolfcrypt   [The wolfCrypt component]
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ benchmark   [Cryptography benchmarking application]
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ src         [wolfCrypt source code]
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€â€Ã¢â€â‚¬Ã¢â€â‚¬ port    [Supported hardware acceleration ports]
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€â€Ã¢â€â‚¬Ã¢â€â‚¬ test        [Cryptography testing application]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ wolfssl [Header files]
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ openssl [Compatibility layer headers]
Ã¢â€â€šÃ‚Â Ã‚Â  Ã¢â€â€Ã¢â€â‚¬Ã¢â€â‚¬ wolfcrypt   [Header files]
Ã¢â€Å“Ã¢â€â‚¬Ã¢â€â‚¬ wrapper [wolfSSL language wrappers]
Ã¢â€â€Ã¢â€â‚¬Ã¢â€â‚¬ zephyr  [Port of wolfSSL for Zephyr RTOS]
```
