/*************************************************

Copyright © 2025 Jan K. S.
MIT License
https://github.com/wallysalami/QRCodeGFX

*************************************************/

#pragma once

// Using diff matrices to use less memory

const uint8_t QR_NUMERIC_DIFF[39][4] = {
    {36, 29, 21, 17},    // V2-V1
    {50, 38, 29, 24},    // V3-V2
    {60, 48, 34, 24},    // V4-V3
    {68, 53, 33, 24},    // V5-V4
    {67, 53, 34, 33},    // V6-V5
    {48, 38, 29, 15},    // V7-V6
    {91, 72, 52, 48},    // V8-V7
    {91, 67, 53, 33},    // V9-V8
    {100, 81, 52, 53},   // V10-V9
    {120, 91, 63, 43},   // V11-V10
    {111, 87, 62, 43},   // V12-V11
    {139, 105, 91, 53},  // V13-V12
    {79, 75, 41, 41},    // V14-V13
    {149, 120, 82, 62},  // V15-V14
    {158, 91, 72, 72},   // V16-V15
    {140, 130, 101, 72}, // V17-V16
    {177, 134, 72, 72},  // V18-V17
    {178, 154, 115, 67}, // V19-V18
    {158, 100, 96, 106}, // V20-V19
    {171, 108, 65, 50},  // V21-V20
    {177, 164, 134, 87}, // V22-V21
    {211, 187, 110, 52}, // V23-V22
    {192, 129, 120, 120},// V24-V23
    {245, 207, 130, 58}, // V25-V24
    {226, 149, 86, 139}, // V26-V25
    {234, 157, 129, 76}, // V27-V26
    {152, 156, 152, 80}, // V28-V27
    {240, 178, 96, 96},  // V29-V28
    {249, 254, 177, 105},// V30-V29
    // I subtracted 100 from the first two columns of the rows below
    // I had to do this hack to keep the values as 8-bit integers and use less memory
    {159, 97, 115, 115},// V31-V30
    {169, 107, 197, 125},// V32-V31
    {179, 116, 135, 135},// V33-V32
    {188, 125, 144, 144},// V34-V33
    {176, 109, 132, 60}, // V35-V34
    {207, 145, 163, 163},// V36-V35
    {217, 87, 173, 101},// V37-V36
    {226, 164, 182, 110},// V38-V37
    {164, 174, 192, 192},// V39-V38
    {246, 183, 202, 130} // V40-V39
};

const uint8_t QR_NUMERIC_BASE[4] = {41, 34, 27, 17}; // V1 base values

const uint8_t QR_ALPHANUMERIC_DIFF[39][4] = {
    {22, 18, 13, 10},    // Diff V2-V1
    {30, 23, 18, 15},    // Diff V3-V2
    {37, 29, 20, 15},    // Diff V4-V3
    {40, 32, 20, 14},    // Diff V5-V4
    {41, 32, 21, 20},    // Diff V6-V5
    {29, 24, 17, 9},     // Diff V7-V6
    {55, 43, 32, 29},    // Diff V8-V7
    {56, 41, 32, 21},    // Diff V9-V8
    {60, 49, 32, 31},    // Diff V10-V9
    {73, 55, 38, 26},    // Diff V11-V10
    {67, 53, 37, 27},    // Diff V12-V11
    {84, 64, 56, 32},    // Diff V13-V12
    {48, 45, 24, 24},    // Diff V14-V13
    {91, 72, 50, 38},    // Diff V15-V14
    {96, 56, 44, 44},    // Diff V16-V15
    {84, 78, 61, 43},    // Diff V17-V16
    {108, 82, 43, 44},   // Diff V18-V17
    {107, 93, 70, 41},   // Diff V19-V18
    {96, 61, 58, 64},    // Diff V20-V19
    {103, 65, 40, 30},   // Diff V21-V20
    {108, 99, 81, 53},   // Diff V22-V21
    {128, 114, 67, 32},  // Diff V23-V22
    {116, 78, 73, 72},   // Diff V24-V23
    {149, 125, 78, 35},  // Diff V25-V24
    {137, 91, 53, 85},   // Diff V26-V25
    {142, 95, 78, 46},   // Diff V27-V26
    {91, 95, 91, 48},    // Diff V28-V27
    {146, 107, 59, 58},  // Diff V29-V28
    {151, 155, 107, 64}, // Diff V30-V29
    {157, 119, 70, 70},  // Diff V31-V30
    {163, 125, 119, 76}, // Diff V32-V31
    {169, 131, 82, 81},  // Diff V33-V32
    {174, 137, 87, 87},  // Diff V34-V33
    {168, 126, 80, 37},  // Diff V35-V34
    {186, 148, 99, 99},  // Diff V36-V35
    {192, 114, 105, 61}, // Diff V37-V36
    {198, 160, 110, 67}, // Diff V38-V37
    {160, 166, 117, 116},// Diff V39-V38
    {209, 171, 122, 78}  // Diff V40-V39
};

const uint8_t QR_ALPHANUMERIC_BASE[4] = {25, 20, 16, 10}; // V1 base values

// Differential matrix
const uint8_t QR_BYTE_DIFF[39][4] = {
    {15, 12, 9, 7},     // V2-V1
    {21, 16, 12, 10},   // V3-V2
    {25, 20, 14, 10},   // V4-V3
    {28, 22, 14, 10},   // V5-V4
    {28, 22, 14, 14},   // V6-V5
    {20, 16, 12, 6},    // V7-V6
    {38, 30, 22, 20},   // V8-V7
    {38, 28, 22, 14},   // V9-V8
    {41, 33, 21, 21},   // V10-V9
    {50, 38, 26, 18},   // V11-V10
    {46, 36, 26, 18},   // V12-V11
    {58, 44, 38, 22},   // V13-V12
    {33, 31, 17, 17},   // V14-V13
    {62, 50, 34, 26},   // V15-V14
    {66, 38, 30, 30},   // V16-V15
    {58, 54, 42, 30},   // V17-V16
    {74, 56, 30, 30},   // V18-V17
    {74, 64, 48, 28},   // V19-V18
    {66, 42, 40, 44},   // V20-V19
    {71, 45, 27, 21},   // V21-V20
    {74, 68, 56, 36},   // V22-V21
    {88, 78, 46, 22},   // V23-V22
    {80, 54, 50, 50},   // V24-V23
    {102, 86, 54, 24},  // V25-V24
    {94, 62, 36, 58},   // V26-V25
    {98, 66, 54, 32},   // V27-V26
    {63, 65, 63, 33},   // V28-V27
    {100, 74, 40, 40},  // V29-V28
    {104, 106, 74, 44}, // V30-V29
    {108, 82, 48, 48},  // V31-V30
    {112, 86, 82, 52},  // V32-V31
    {116, 90, 56, 56},  // V33-V32
    {120, 94, 60, 60},  // V34-V33
    {115, 87, 55, 25},  // V35-V34
    {128, 102, 68, 68}, // V36-V35
    {132, 78, 72, 42},  // V37-V36
    {136, 110, 76, 46}, // V38-V37
    {110, 114, 80, 80}, // V39-V38
    {144, 118, 84, 54}  // V40-V39
};

const uint8_t QR_BYTE_BASE[4] = {17, 14, 11, 7}; // V1 base values