// 3D model [suzanne]
//
// - vertices   : 8177
// - textures   : 9906
// - normals    : 8177
// - triangles  : 15744
//
// - memory size: 382kb
//
// - model bounding box: [-1.0,1.0]x[-0.72,0.72]x[-0.6,0.6]
//
// object [suzanne] (tagged [ | o Suzanne]) with 15744 triangles (1520 chains)

#pragma once

#include <tgx.h>


// vertex array: 95kb.
const tgx::fVec3 suzanne_vert_array[8177] PROGMEM = {
{0.3630869537771552,0.17505320571976513,0.5382765555158099},
{0.35750861962719926,0.15666040923314628,0.5396066985099393},
{0.3686697968864133,0.1516900330957613,0.5262616819620586},
{0.37503569592780855,0.1724680690532087,0.5247451686501078},
{0.38127384112231005,0.14618008482855435,0.510721553727256},
{0.36969182766156355,0.12457615782559948,0.5133705673172594},
{0.3584261928451834,0.13257430013436697,0.5286100982652531},
{0.3484786771314602,0.13978112008561008,0.5416702988838824},
{0.3490490604831801,0.16045620147232548,0.5503049559474678},
{0.3540051582494417,0.17703714781270385,0.5491243601035258},
{0.35570278142669487,0.1944725419408364,0.5486997664359081},
{0.36501378238560017,0.1943290067363852,0.5377948483636987},
{0.377248843451939,0.19417194465402754,0.5241950756152475},
{0.3884979454175447,0.1696184067742605,0.5090126581517476},
{0.39405899522350907,0.14076783067956028,0.4934349552560939},
{0.3811588626601057,0.11671027832302787,0.4963537549110082},
{0.36382116265018594,0.09562262716016726,0.5001608195484428},
{0.35409684042191836,0.10565581310063096,0.5168101517715701},
{0.34457692434868087,0.11585883650814165,0.5316543972874102},
{0.336197023485666,0.1250465925794554,0.5443538811618687},
{0.3409675024273231,0.1452737840088255,0.5521513747816913},
{0.34455062208608506,0.1624401435652642,0.5579078128240815},
{0.3491437486285249,0.17808097189114772,0.5568068752611439},
{0.350703097053846,0.19455896366079403,0.5564168502815094},
{0.3540051582494417,0.21221755127438216,0.5491243601035258},
{0.3630869537771552,0.21385730947392464,0.5382765555158099},
{0.37503569592780855,0.21606444505231898,0.5247451686501078},
{0.3884979454175447,0.21860449212585406,0.5090126581517476},
{0.3910207081470883,0.19404268782069975,0.5083934277409213},
{0.4021202629625065,0.16684314232379738,0.49156073117284044},
{0.4057672595447153,0.13608903391037994,0.47485278247878543},
{0.3917083244406636,0.10989874380393838,0.4779609584243893},
{0.37281127600542274,0.08694212901034358,0.4820430695792541},
{-0.36969182766156355,0.12457615782559948,0.5133705673172594},
{-0.3584261928451834,0.13257430013436697,0.5286100982652531},
{-0.3686697968864133,0.1516900330957613,0.5262616819620586},
{-0.38127384112231005,0.14618008482855435,0.510721553727256},
{-0.37503569592780855,0.1724680690532087,0.5247451686501078},
{-0.3630869537771552,0.17505320571976513,0.5382765555158099},
{-0.35750861962719926,0.15666040923314628,0.5396066985099393},
{-0.3484786771314602,0.13978112008561008,0.5416702988838824},
{-0.34457692434868087,0.11585883650814165,0.5316543972874102},
{-0.35409684042191836,0.10565581310063096,0.5168101517715701},
{-0.36382116265018594,0.09562262716016726,0.5001608195484428},
{-0.3811588626601057,0.11671027832302787,0.4963537549110082},
{-0.39405899522350907,0.14076783067956028,0.4934349552560939},
{-0.3917083244406636,0.10989874380393838,0.4779609584243893},
{-0.4057672595447153,0.13608903391037994,0.47485278247878543},
{-0.3490490604831801,0.16045620147232548,0.5503049559474678},
{-0.3409675024273231,0.1452737840088255,0.5521513747816913},
{-0.336197023485666,0.1250465925794554,0.5443538811618687},
{-0.3273962864211188,0.10227935407655006,0.5352608132358998},
{-0.33483306329677065,0.09026748649566683,0.5208922629264349},
{-0.3424464410784228,0.07845626760372858,0.504701341565691},
{-0.3495104773184317,0.06825098971656685,0.4869503202864091},
{-0.37281127600542274,0.08694212901034358,0.4820430695792541},
{-0.38125054483258236,0.07927614670349986,0.4628243820471277},
{-0.40157016992764627,0.10387853164237336,0.4585356102575818},
{-0.3893230849698351,0.07228725978519313,0.44287223713518764},
{-0.4109728530590283,0.09838586771915793,0.43842264579719903},
{-0.3972122607621344,0.06563654481454652,0.42255261204012373},
{-0.42014633075921853,0.09315697791511736,0.41796624893663714},
{-0.36501378238560017,0.1943290067363852,0.5377948483636987},
{-0.377248843451939,0.19417194465402754,0.5241950756152475},
{-0.35570278142669487,0.1944725419408364,0.5486997664359081},
{-0.3540051582494417,0.17703714781270385,0.5491243601035258},
{-0.350703097053846,0.19455896366079403,0.5564168502815094},
{-0.3491437486285249,0.17808097189114772,0.5568068752611439},
{-0.34455062208608506,0.1624401435652642,0.5579078128240815},
{-0.3463451878883341,0.17860626564984625,0.5623912213568361},
{-0.3420398832480138,0.16346142284719742,0.5634215185573734},
{-0.3370116421329181,0.14812945823350998,0.559650525594356},
{-0.3347789557851451,0.14964071109294166,0.5651454439972224},
{-0.33953966531498087,0.1643699781465772,0.5678553285378046},
{-0.33244030889377196,0.15110311689326691,0.5696115681859856},
{-0.3884979454175447,0.1696184067742605,0.5090126581517476},
{-0.4021202629625065,0.16684314232379738,0.49156073117284044},
{-0.3910207081470883,0.19404268782069975,0.5083934277409213},
{0.4145507122652711,0.16448119914269652,0.47286959187906374},
{0.4166661656711887,0.1319610816692768,0.4552989289718671},
{0.42608613314656224,0.1624288711670088,0.4532496069690475},
{0.427026251161057,0.12819985811808063,0.4350972883118758},
{0.4109728530590283,0.09838586771915793,0.43842264579719903},
{0.40157016992764627,0.10387853164237336,0.4585356102575818},
{0.38125054483258236,0.07927614670349986,0.4628243820471277},
{0.417623568029675,0.19404268782069975,0.4721586792957606},
{0.42937692194390253,0.19418622302515096,0.45252141004175295},
{0.43702561990675476,0.16058245233278526,0.43301039164820504},
{0.43711730207923144,0.12462199891183783,0.4145717540753477},
{0.42014633075921853,0.09315697791511736,0.41796624893663714},
{0.3972122607621344,0.06563654481454652,0.42255261204012373},
{0.3893230849698351,0.07228725978519313,0.44287223713518764},
{0.404941368499208,0.193985574336206,0.4908836357843034},
{0.4145507122652711,0.22374169975741803,0.47286959187906374},
{0.42608613314656224,0.22613821162650188,0.4532496069690475},
{0.43702561990675476,0.2284663376128367,0.43301039164820504},
{0.4405117969405208,0.1943868717140959,0.43227693426839126},
{0.4476667638597894,0.15883973956251066,0.4124615611219493},
{-0.4166661656711887,0.1319610816692768,0.4552989289718671},
{-0.427026251161057,0.12819985811808063,0.4350972883118758},
{-0.42608613314656224,0.1624288711670088,0.4532496069690475},
{-0.4145507122652711,0.16448119914269652,0.47286959187906374},
{-0.43711730207923144,0.12462199891183783,0.4145717540753477},
{-0.43702561990675476,0.16058245233278526,0.43301039164820504},
{-0.42937692194390253,0.19418622302515096,0.45252141004175295},
{-0.417623568029675,0.19404268782069975,0.4721586792957606},
{-0.404941368499208,0.193985574336206,0.4908836357843034},
{-0.4476667638597894,0.15883973956251066,0.4124615611219493},
{-0.4405117969405208,0.1943868717140959,0.43227693426839126},
{-0.4513363052385089,0.1946160771452877,0.4117281037421356},
{-0.4476667638597894,0.23075989491118856,0.4124615611219493},
{-0.43702561990675476,0.2284663376128367,0.43301039164820504},
{0.3495104773184317,0.06825098971656685,0.4869503202864091},
{0.3229128778883642,0.05429576067646413,0.4923918826708671},
{0.3274954835257657,0.04429939790363449,0.47383375767650315},
{0.35616119228907844,0.05924960396307462,0.4680299755614406},
{0.3318969792978649,0.0352033240047975,0.4544534991027172},
{0.29868924553086984,0.025273092635065882,0.46089755343868277},
{0.2964475412644926,0.03492827748736738,0.47991559228186415},
{0.2941254272238939,0.04554687664389138,0.4980731713915551},
{0.31805973469283466,0.0656425567602827,0.5097153043096633},
{0.3424464410784228,0.07845626760372858,0.504701341565691},
{0.36253686074229496,0.05105081296536218,0.4483303323704201},
{0.33620904737713836,0.02655739454295683,0.43466142224600285},
{0.30089112065674495,0.016099614934875585,0.4414504119685816},
{0.2641964583627668,0.012430073556156052,0.4482386501979434},
{0.2641964583627668,0.021786915601299785,0.4673190629781375},
{0.26421148822710727,0.031637488690027055,0.4859560947602887},
{0.2642543233404775,0.042473269386270496,0.5037041100667026},
{0.29168307426857165,0.05760984576353211,0.5149411881408359},
{0.3128451232599175,0.07878917909886948,0.525393707296398},
{0.33483306329677065,0.09026748649566683,0.5208922629264349},
{0.36877500593679646,0.043253319345539554,0.42823991270654793},
{-0.29868924553086984,0.025273092635065882,0.46089755343868277},
{-0.2964475412644926,0.03492827748736738,0.47991559228186415},
{-0.3274954835257657,0.04429939790363449,0.47383375767650315},
{-0.3318969792978649,0.0352033240047975,0.4544534991027172},
{-0.35616119228907844,0.05924960396307462,0.4680299755614406},
{-0.3229128778883642,0.05429576067646413,0.4923918826708671},
{-0.2941254272238939,0.04554687664389138,0.4980731713915551},
{-0.26421148822710727,0.031637488690027055,0.4859560947602887},
{-0.2641964583627668,0.021786915601299785,0.4673190629781375},
{-0.2641964583627668,0.012430073556156052,0.4482386501979434},
{-0.30089112065674495,0.016099614934875585,0.4414504119685816},
{-0.33620904737713836,0.02655739454295683,0.43466142224600285},
{-0.36253686074229496,0.05105081296536218,0.4483303323704201},
{-0.31805973469283466,0.0656425567602827,0.5097153043096633},
{-0.29168307426857165,0.05760984576353211,0.5149411881408359},
{-0.2642543233404775,0.042473269386270496,0.5037041100667026},
{-0.23198069564224114,0.03492827748736738,0.4916351290013257},
{-0.22970442268788083,0.025273092635065882,0.4733738438276857},
{-0.22750254756200572,0.016099614934875585,0.45466015973739815},
{-0.3128451232599175,0.07878917909886948,0.525393707296398},
{-0.2890799017648067,0.07159964349161779,0.5300890369163528},
{-0.26433999356721805,0.05478874022683066,0.520118976406119},
{-0.23440576425357182,0.04554687664389138,0.5089901133552369},
{-0.20094552876565736,0.04429939790363449,0.4967693306600215},
{-0.19649668892088581,0.0352033240047975,0.4788777801491564},
{-0.19218462084161228,0.02655739454295683,0.4605308247487759},
{-0.36877500593679646,0.043253319345539554,0.42823991270654793},
{0.3208658103651956,0.11308657803054671,0.5475417153884768},
{0.3033101773223395,0.10418213490205039,0.5510737335084814},
{0.3077635261264132,0.0921612494025629,0.5392407213132495},
{0.3273962864211188,0.10227935407655006,0.5352608132358998},
{0.2890799017648067,0.07159964349161779,0.5300890369163528},
{0.2865571390352631,0.08582991904915066,0.5434077512016376},
{0.2843552639093879,0.0986150731503497,0.5547883644802222},
{0.299979559384497,0.11327896029410435,0.5607056220710551},
{0.31596983205629586,0.12128536902825915,0.5574719467582085},
{0.3298965043541517,0.13203547949776206,0.5545711829405028},
{0.2646556207183674,0.08361075957928404,0.5475732781035919},
{0.2648277126650655,0.09666569974539406,0.5585270432349078},
{0.2827155057098455,0.10827025800265129,0.5641226617288553},
{0.2982646518632523,0.11787358982297827,0.5679530226560174},
{0.31343579692849693,0.12547043475385586,0.5647877332259199},
{0.32661097600933053,0.13564189544625171,0.5619666276892185},
{0.2644835287716693,0.06907688076207423,0.5347558097940609},
{0.2400013827475193,0.07159964349161779,0.5391708324440663},
{0.24293746674642513,0.08582991904915066,0.5515494287148565},
{0.24555191164844545,0.0986150731503497,0.5621274472376612},
{0.2649704963762997,0.10651627283412138,0.5675742700746383},
{0.2818790937592997,0.11310912282705736,0.5713009249378516},
{0.29733580624701283,0.12009049481319382,0.5734727403350458},
{0.3119981904043334,0.12757085829543305,0.5702901665609567},
{0.3247149586227835,0.13754467627175196,0.567466055051387},
{0.26433999356721805,0.05478874022683066,0.520118976406119},
{0.23705477784357518,0.05760984576353211,0.5249863979727719},
{0.21080737425263998,0.0656425567602827,0.5293608399890583},
{0.21649467491906418,0.07878917909886948,0.543149989028199},
{0.2221421464449862,0.0921612494025629,0.555154341676912},
{0.22715911516182657,0.10418213490205039,0.5654129755824824},
{0.2475351022481671,0.10827025800265129,0.5709108999582171},
{0.26505691809625725,0.11143554743274889,0.5746721235094132},
{0.2814334582816056,0.11547181750137525,0.5768717441556372},
{0.29635961655810095,0.1220496376299707,0.5779253376459025},
{0.31039300089277394,0.12951497124786945,0.5747795870394474},
{0.3225822208728744,0.13942190632787346,0.571993050190729},
{-0.2865571390352631,0.08582991904915066,0.5434077512016376},
{-0.3077635261264132,0.0921612494025629,0.5392407213132495},
{-0.3208658103651956,0.11308657803054671,0.5475417153884768},
{-0.3033101773223395,0.10418213490205039,0.5510737335084814},
{-0.2843552639093879,0.0986150731503497,0.5547883644802222},
{-0.2646556207183674,0.08361075957928404,0.5475732781035919},
{-0.2644835287716693,0.06907688076207423,0.5347558097940609},
{-0.23705477784357518,0.05760984576353211,0.5249863979727719},
{-0.20567016662107607,0.05429576067646413,0.5137485684054216},
{-0.17229560135990213,0.05924960396307462,0.5011753353914228},
{-0.16585680747645573,0.05105081296536218,0.4836482590908135},
{-0.15961866228195426,0.043253319345539554,0.46566803238033966},
{-0.299979559384497,0.11327896029410435,0.5607056220710551},
{-0.2827155057098455,0.10827025800265129,0.5641226617288553},
{-0.2648277126650655,0.09666569974539406,0.5585270432349078},
{-0.24293746674642513,0.08582991904915066,0.5515494287148565},
{-0.2400013827475193,0.07159964349161779,0.5391708324440663},
{-0.21080737425263998,0.0656425567602827,0.5293608399890583},
{-0.1791356926212384,0.06825098971656685,0.5177968623655204},
{-0.1472205271875216,0.07927614670349986,0.5046697788505762},
{-0.1390705832489156,0.07228725978519313,0.4875011648144863},
{-0.1311814074566163,0.06563654481454652,0.4698876667939196},
{-0.31596983205629586,0.12128536902825915,0.5574719467582085},
{-0.31343579692849693,0.12547043475385586,0.5647877332259199},
{-0.2982646518632523,0.11787358982297827,0.5679530226560174},
{-0.2818790937592997,0.11310912282705736,0.5713009249378516},
{-0.2649704963762997,0.10651627283412138,0.5675742700746383},
{-0.24555191164844545,0.0986150731503497,0.5621274472376612},
{-0.2221421464449862,0.0921612494025629,0.555154341676912},
{-0.21649467491906418,0.07878917909886948,0.543149989028199},
{-0.18657772994940947,0.07845626760372858,0.5330589381100246},
{-0.15589200741874104,0.08694212901034358,0.5209501279041455},
{-0.126909920011062,0.10387853164237336,0.5070692966925281},
{-0.13702952767148324,0.10989874380393838,0.523025752169561},
{-0.16534654358209763,0.09562262716016726,0.5358973279907175},
{-0.14809451379891844,0.11671027832302787,0.5376918937929666},
{-0.17584490382389809,0.10565581310063096,0.549066495125815},
{-0.16042125703773397,0.12457615782559948,0.5506378674426086},
{-0.18627938714225165,0.11585883650814165,0.5605222577261018},
{-0.17269088679205583,0.13257430013436697,0.5619207866029801},
{-0.14892641679016205,0.14618008482855435,0.5514577465423798},
{-0.1625690246519835,0.1516900330957613,0.5626294447066321},
{-0.18358453246600998,0.13978112008561008,0.5715992677450094},
{-0.17468084083073068,0.15666040923314628,0.5722357824998272},
{-0.3298965043541517,0.13203547949776206,0.5545711829405028},
{-0.32661097600933053,0.13564189544625171,0.5619666276892185},
{-0.3247149586227835,0.13754467627175196,0.567466055051387},
{-0.3119981904043334,0.12757085829543305,0.5702901665609567},
{-0.29733580624701283,0.12009049481319382,0.5734727403350458},
{-0.2814334582816056,0.11547181750137525,0.5768717441556372},
{-0.26505691809625725,0.11143554743274889,0.5746721235094132},
{-0.2475351022481671,0.10827025800265129,0.5709108999582171},
{-0.22715911516182657,0.10418213490205039,0.5654129755824824},
{-0.2030098806328174,0.10227935407655006,0.5582061556312393},
{-0.19482236203336029,0.09026748649566683,0.5465099152015055},
{0.23095415590778878,0.11327896029410435,0.5739642168989783},
{0.248578926326611,0.11310912282705736,0.5779057988222598},
{0.26508998379780624,0.1138779003880711,0.5802745054423138},
{0.28096903547348584,0.11769623742376101,0.5813844609238557},
{0.2945049312984901,0.12587398661139682,0.5819668681670479},
{0.3073547138163531,0.13323035371282738,0.5790563349375208},
{0.31858577994475024,0.14295392444787794,0.5764704467777475},
{0.2030098806328174,0.10227935407655006,0.5582061556312393},
{0.2102798260142904,0.11308657803054671,0.5682047728837198},
{0.21577248993750583,0.12128536902825915,0.5765643834298753},
{0.23293809800072746,0.11787358982297827,0.5808471432736848},
{0.24910422008530952,0.11547181750137525,0.5834691031078754},
{0.2650757054266828,0.1162969570536656,0.5848360692696388},
{0.2800747585452294,0.12212253247202187,0.585386162304499},
{0.2909398474769367,0.13368500710912581,0.5862578944362449},
{0.30161706310438846,0.14064533728518563,0.5839222535177397},
{0.31110015600999186,0.14981881498537597,0.5818240844558137},
{0.3201173231210415,0.15905316363614502,0.579365950142934},
{0.32816280950248145,0.1538092439677639,0.5740265908359912},
{0.18627938714225165,0.11585883650814165,0.5605222577261018},
{0.19554454701491863,0.1250465925794554,0.5703262382353737},
{0.20253343393322534,0.13203547949776206,0.5785423135770776},
{0.21862741266897326,0.12547043475385586,0.5833413492609816},
{0.23395937728266064,0.12009049481319382,0.5863383042104662},
{0.24953482569866325,0.11769623742376101,0.587958523586366},
{0.26501859194218913,0.12114784576954404,0.5888092139080353},
{0.27833956070712507,0.13108934953753107,0.5894261898392106},
{0.2871944052832979,0.14207317439752787,0.5894201778934743},
{0.2925600668528366,0.14997738005416764,0.589175942597942},
{0.3002996954949485,0.1599068599306823,0.5877458510059488},
{0.3101194573617779,0.16751422576659825,0.5848262998578175},
{0.31790342410369404,0.17270554090978776,0.5818766889810053},
{0.3266741014395604,0.16924716912505142,0.5775105133901061},
{0.3287782824472226,0.18129886584643687,0.5772181825286845},
{0.31570981540320614,0.18188202458284614,0.5834330314334583},
{0.29998857730310124,0.17986952574766055,0.5896020392519938},
{0.31393027946529756,0.19435155153289585,0.5843543621175274},
{0.2948896958256055,0.19435981795828308,0.5918189442422094},
{0.29998857730310124,0.2092251052841997,0.5896020392519938},
{0.31570981540320614,0.2071089003850651,0.5834330314334583},
{0.19482236203336029,0.09026748649566683,0.5465099152015055},
{0.17584490382389809,0.10565581310063096,0.549066495125815},
{0.16042125703773397,0.12457615782559948,0.5506378674426086},
{0.17269088679205583,0.13257430013436697,0.5619207866029801},
{0.18358453246600998,0.13978112008561008,0.5715992677450094},
{0.19178332346372243,0.1452737840088255,0.5797289213667558},
{0.206139849881715,0.13564189544625171,0.5852336091814435},
{0.22013941702162196,0.12757085829543305,0.5887633728217969},
{0.23486868407525752,0.1220496376299707,0.5907127462267525},
{0.2502915793682046,0.12212253247202187,0.5917310195358176},
{0.2649231523036273,0.13088344039606697,0.5926485927538019},
{0.2775670256800262,0.1437963483441598,0.5927538018041849},
{0.2795622401712202,0.1594431886157795,0.5946167534891831},
{0.2863587448259692,0.17310834127411168,0.5939291371956077},
{0.18657772994940947,0.07845626760372858,0.5330589381100246},
{0.16534654358209763,0.09562262716016726,0.5358973279907175},
{0.14809451379891844,0.11671027832302787,0.5376918937929666},
{0.13523721634888525,0.14076783067956028,0.5386748469208318},
{0.14892641679016205,0.14618008482855435,0.5514577465423798},
{0.1625690246519835,0.1516900330957613,0.5626294447066321},
{0.17468084083073068,0.15666040923314628,0.5722357824998272},
{0.18377691472956764,0.16045620147232548,0.5803226010082033},
{0.19596914068253618,0.14812945823350998,0.586368363939147},
{0.20804263070721524,0.13754467627175196,0.5905970162713311},
{0.2216010713287302,0.12951497124786945,0.5930574050638618},
{0.23651370272731917,0.12587398661139682,0.5942470188264082},
{0.25179757177511713,0.13108934953753107,0.5951443017275326},
{0.25237096109970514,0.1437963483441598,0.5981886007496897},
{0.2648277126650655,0.14530384373750643,0.596108467524972},
{0.2647698476873548,0.16420991009135152,0.5989438514327969},
{0.2646270639761205,0.19434403660072566,0.6016537359733791},
{-0.23095415590778878,0.11327896029410435,0.5739642168989783},
{-0.2102798260142904,0.11308657803054671,0.5682047728837198},
{-0.21577248993750583,0.12128536902825915,0.5765643834298753},
{-0.19554454701491863,0.1250465925794554,0.5703262382353737},
{0.23440576425357182,0.04554687664389138,0.5089901133552369},
{0.20567016662107607,0.05429576067646413,0.5137485684054216},
{0.20094552876565736,0.04429939790363449,0.4967693306600215},
{0.23198069564224114,0.03492827748736738,0.4916351290013257},
{0.19649668892088581,0.0352033240047975,0.4788777801491564},
{0.16585680747645573,0.05105081296536218,0.4836482590908135},
{0.17229560135990213,0.05924960396307462,0.5011753353914228},
{0.1791356926212384,0.06825098971656685,0.5177968623655204},
{0.22970442268788083,0.025273092635065882,0.4733738438276857},
{0.19218462084161228,0.02655739454295683,0.4605308247487759},
{0.15961866228195426,0.043253319345539554,0.46566803238033966},
{0.1311814074566163,0.06563654481454652,0.4698876667939196},
{0.1390705832489156,0.07228725978519313,0.4875011648144863},
{0.1472205271875216,0.07927614670349986,0.5046697788505762},
{0.15589200741874104,0.08694212901034358,0.5209501279041455},
{0.22750254756200572,0.016099614934875585,0.45466015973739815},
{0.13702952767148324,0.10989874380393838,0.523025752169561},
{0.122987876911423,0.13608903391037994,0.5242349047557497},
{0.11181768173360468,0.1319610816692768,0.5085527443029298},
{0.126909920011062,0.10387853164237336,0.5070692966925281},
{0.10136741705769364,0.12819985811808063,0.49204168683173466},
{0.11742081515972237,0.09838586771915793,0.4902531329752217},
{0.09127636613951923,0.12462199891183783,0.4751165565979602},
{0.10824733745953209,0.09315697791511736,0.4730071151377788},
{0.11421043613660344,0.16448119914269652,0.5247910097363462},
{0.10239921724466515,0.1624288711670088,0.50929972856065},
{0.1271902269810113,0.16684314232379738,0.5390791502715896},
{0.14173086923717426,0.1696184067742605,0.5517613498020568},
{0.15623619131213723,0.1724680690532087,0.5628729285089473},
{0.16911377907903002,0.17505320571976513,0.5724477035870273},
{0.17876896393133157,0.17703714781270385,0.5805202437242801},
{0.18837229575165854,0.1624401435652642,0.5869357413179989},
{0.11113682887898253,0.19404268782069975,0.5249059881985506},
{0.09910842844732484,0.19418622302515096,0.5094891048513397},
{0.12436987293752687,0.193985574336206,0.5391362637560833},
{0.13920810650763066,0.19404268782069975,0.5517846460917843},
{0.15401703184227059,0.19417194465402754,0.5628789404546836},
{0.1671644056740744,0.1943290067363852,0.5724477035870273},
{0.17701422726958468,0.1944725419408364,0.5805202437242801},
{0.16911377907903002,0.21385730947392464,0.5724477035870273},
{0.17876896393133157,0.21221755127438216,0.5805202437242801},
{0.09136804831199594,0.16058245233278526,0.49300510113595714},
{0.08788187127822984,0.1943868717140959,0.49328014765338735},
{0.10239921724466515,0.22613821162650188,0.50929972856065},
{0.11421043613660344,0.22374169975741803,0.5247910097363462},
{0.1271902269810113,0.22124223331760207,0.5390791502715896},
{0.08072690435896127,0.15883973956251066,0.4763091763333745},
{0.07705736298024174,0.1946160771452877,0.4766766565164983},
{0.09136804831199594,0.2284663376128367,0.49300510113595714},
{0.11181768173360468,0.2570448731629748,0.5085527443029298},
{0.10136741705769364,0.26146816223836766,0.49204168683173466},
{0.08072690435896127,0.23075989491118856,0.4763091763333745},
{0.09127636613951923,0.2658020236209348,0.4751165565979602},
{-0.10239921724466515,0.1624288711670088,0.50929972856065},
{-0.11181768173360468,0.1319610816692768,0.5085527443029298},
{-0.10136741705769364,0.12819985811808063,0.49204168683173466},
{-0.09136804831199594,0.16058245233278526,0.49300510113595714},
{-0.08072690435896127,0.15883973956251066,0.4763091763333745},
{-0.09127636613951923,0.12462199891183783,0.4751165565979602},
{-0.11742081515972237,0.09838586771915793,0.4902531329752217},
{-0.122987876911423,0.13608903391037994,0.5242349047557497},
{-0.11421043613660344,0.16448119914269652,0.5247910097363462},
{-0.11113682887898253,0.19404268782069975,0.5249059881985506},
{-0.09910842844732484,0.19418622302515096,0.5094891048513397},
{-0.08788187127822984,0.1943868717140959,0.49328014765338735},
{-0.07705736298024174,0.1946160771452877,0.4766766565164983},
{-0.09136804831199594,0.2284663376128367,0.49300510113595714},
{-0.08072690435896127,0.23075989491118856,0.4763091763333745},
{-0.10136741705769364,0.26146816223836766,0.49204168683173466},
{-0.09127636613951923,0.2658020236209348,0.4751165565979602},
{-0.11742081515972237,0.29203890630683166,0.4902531329752217},
{-0.10824733745953209,0.29827630000811617,0.4730071151377788},
{-0.1390705832489156,0.3188251305343718,0.4875011648144863},
{-0.1311814074566163,0.3267143063266711,0.4698876667939196},
{-0.1271902269810113,0.16684314232379738,0.5390791502715896},
{-0.13523721634888525,0.14076783067956028,0.5386748469208318},
{-0.12436987293752687,0.193985574336206,0.5391362637560833},
{-0.11421043613660344,0.22374169975741803,0.5247910097363462},
{-0.10239921724466515,0.22613821162650188,0.50929972856065},
{-0.11181768173360468,0.2570448731629748,0.5085527443029298},
{-0.126909920011062,0.28566323785361514,0.5070692966925281},
{-0.1472205271875216,0.3107525903971191,0.5046697788505762},
{-0.14173086923717426,0.1696184067742605,0.5517613498020568},
{-0.13920810650763066,0.19404268782069975,0.5517846460917843},
{-0.1271902269810113,0.22124223331760207,0.5390791502715896},
{-0.13523721634888525,0.24757605862849483,0.5386748469208318},
{-0.122987876911423,0.25244348019514773,0.5242349047557497},
{-0.13702952767148324,0.27901252288296846,0.523025752169561},
{-0.15589200741874104,0.30231257007674245,0.5209501279041455},
{-0.10824733745953209,0.09315697791511736,0.4730071151377788},
{-0.15623619131213723,0.1724680690532087,0.5628729285089473},
{-0.15401703184227059,0.19417194465402754,0.5628789404546836},
{-0.14173086923717426,0.21860449212585406,0.5517613498020568},
{-0.14892641679016205,0.2423524292769733,0.5514577465423798},
{-0.16042125703773397,0.2643343573680904,0.5506378674426086},
{-0.14809451379891844,0.27194848664295956,0.5376918937929666},
{-0.16534654358209763,0.2933232082147227,0.5358973279907175},
{-0.16911377907903002,0.17505320571976513,0.5724477035870273},
{-0.1671644056740744,0.1943290067363852,0.5724477035870273},
{-0.15623619131213723,0.21606444505231898,0.5628729285089473},
{-0.1625690246519835,0.23726857766381795,0.5626294447066321},
{-0.17269088679205583,0.25690434393139167,0.5619207866029801},
{-0.17468084083073068,0.23281823483261238,0.5722357824998272},
{-0.18358453246600998,0.25039115221946007,0.5715992677450094},
{-0.19178332346372243,0.24552899110532625,0.5797289213667558},
{-0.20253343393322534,0.25954133362992265,0.5785423135770776},
{-0.19554454701491863,0.26575618253469646,0.5703262382353737},
{-0.18377691472956764,0.16045620147232548,0.5803226010082033},
{-0.17876896393133157,0.17703714781270385,0.5805202437242801},
{-0.17701422726958468,0.1944725419408364,0.5805202437242801},
{-0.16911377907903002,0.21385730947392464,0.5724477035870273},
{-0.17876896393133157,0.21221755127438216,0.5805202437242801},
{-0.18377691472956764,0.22949513182694015,0.5803226010082033},
{-0.19596914068253618,0.24305206946202101,0.586368363939147},
{-0.206139849881715,0.25639934048955276,0.5852336091814435},
{-0.20253343393322534,0.13203547949776206,0.5785423135770776},
{-0.19178332346372243,0.1452737840088255,0.5797289213667558},
{-0.206139849881715,0.13564189544625171,0.5852336091814435},
{-0.19596914068253618,0.14812945823350998,0.586368363939147},
{-0.18837229575165854,0.1624401435652642,0.5869357413179989},
{-0.18360782875573767,0.17808097189114772,0.5871251176086885},
{-0.18193350186821214,0.19455896366079403,0.5871251176086885},
{0.17468084083073068,0.23281823483261238,0.5722357824998272},
{0.1625690246519835,0.23726857766381795,0.5626294447066321},
{0.15623619131213723,0.21606444505231898,0.5628729285089473},
{0.14892641679016205,0.2423524292769733,0.5514577465423798},
{0.16042125703773397,0.2643343573680904,0.5506378674426086},
{0.17269088679205583,0.25690434393139167,0.5619207866029801},
{0.18358453246600998,0.25039115221946007,0.5715992677450094},
{0.19178332346372243,0.24552899110532625,0.5797289213667558},
{0.18377691472956764,0.22949513182694015,0.5803226010082033},
{0.14173086923717426,0.21860449212585406,0.5517613498020568},
{0.19554454701491863,0.26575618253469646,0.5703262382353737},
{0.18627938714225165,0.27409324828434095,0.5605222577261018},
{0.20253343393322534,0.25954133362992265,0.5785423135770776},
{0.206139849881715,0.25639934048955276,0.5852336091814435},
{0.19596914068253618,0.24305206946202101,0.586368363939147},
{0.18837229575165854,0.22779525417003582,0.5869357413179989},
{0.13523721634888525,0.24757605862849483,0.5386748469208318},
{0.14809451379891844,0.27194848664295956,0.5376918937929666},
{0.17584490382389809,0.28359888598645505,0.549066495125815},
{0.122987876911423,0.25244348019514773,0.5242349047557497},
{0.13702952767148324,0.27901252288296846,0.523025752169561},
{0.16534654358209763,0.2933232082147227,0.5358973279907175},
{0.19482236203336029,0.29919387322610025,0.5465099152015055},
{0.2030098806328174,0.28795604365874994,0.5582061556312393},
{0.2102798260142904,0.27809494966498427,0.5682047728837198},
{0.21577248993750583,0.27075586690754533,0.5765643834298753},
{0.21862741266897326,0.2670863255288257,0.5833413492609816},
{0.22013941702162196,0.2651790357440234,0.5887633728217969},
{0.20804263070721524,0.25466639713109945,0.5905970162713311},
{0.19806956422411334,0.24167984284773844,0.5916911903953156},
{0.20992061225655376,0.25267644309242465,0.5948309290560343},
{0.2000129256833328,0.2401317668206727,0.5958709956683931},
{0.19058844924865706,0.22688218991135384,0.5922360229776565},
{0.19254834355865103,0.22592027859356542,0.5963827625491853},
{0.20372830814829065,0.23712729693901782,0.599081374691512},
{0.19637194104686012,0.22407461125255884,0.5995360280878105},
{0.18819419185922429,0.2104710810380225,0.5965736418263089},
{0.19262048690748518,0.20957680410976612,0.5997389312564064},
{-0.18627938714225165,0.27409324828434095,0.5605222577261018},
{-0.17584490382389809,0.28359888598645505,0.549066495125815},
{-0.2030098806328174,0.28795604365874994,0.5582061556312393},
{-0.19482236203336029,0.29919387322610025,0.5465099152015055},
{-0.18657772994940947,0.3106609082246423,0.5330589381100246},
{-0.1791356926212384,0.3212103700052003,0.5177968623655204},
{-0.17229560135990213,0.33107221549218296,0.5011753353914228},
{-0.16585680747645573,0.34047489862356506,0.4836482590908135},
{-0.15961866228195426,0.3496483763237553,0.46566803238033966},
{-0.19649668892088581,0.3565282967255938,0.4788777801491564},
{-0.19218462084161228,0.3666193476437682,0.4605308247487759},
{-0.22970442268788083,0.36652766547129145,0.4733738438276857},
{-0.22750254756200572,0.3771688094243262,0.45466015973739815},
{-0.2641964583627668,0.37001309101184054,0.4673190629781375},
{-0.2641964583627668,0.3808383508030457,0.4482386501979434},
{-0.29868924553086984,0.36652766547129145,0.46089755343868277},
{-0.30089112065674495,0.3771688094243262,0.4414504119685816},
{-0.3318969792978649,0.3565282967255938,0.4544534991027172},
{-0.33620904737713836,0.3666193476437682,0.43466142224600285},
{-0.36253686074229496,0.34047489862356506,0.4483303323704201},
{-0.36877500593679646,0.3496483763237553,0.42823991270654793},
{-0.3893230849698351,0.3188251305343718,0.44287223713518764},
{-0.3972122607621344,0.3267143063266711,0.42255261204012373},
{-0.4109728530590283,0.29203890630683166,0.43842264579719903},
{-0.42014633075921853,0.29827630000811617,0.41796624893663714},
{-0.2102798260142904,0.27809494966498427,0.5682047728837198},
{-0.22715911516182657,0.2871880175909532,0.5654129755824824},
{-0.2221421464449862,0.29821618055075433,0.555154341676912},
{-0.21649467491906418,0.31077513519362976,0.543149989028199},
{-0.21080737425263998,0.3235610407880458,0.5293608399890583},
{-0.20567016662107607,0.3352685536160351,0.5137485684054216},
{-0.20094552876565736,0.34616821123572533,0.4967693306600215},
{-0.23198069564224114,0.355588178711099,0.4916351290013257},
{-0.26421148822710727,0.35887896750843923,0.4859560947602887},
{-0.2964475412644926,0.355588178711099,0.47991559228186415},
{-0.3274954835257657,0.34616821123572533,0.47383375767650315},
{-0.35616119228907844,0.33107221549218296,0.4680299755614406},
{-0.38125054483258236,0.3107525903971191,0.4628243820471277},
{-0.40157016992764627,0.28566323785361514,0.4585356102575818},
{0.126909920011062,0.28566323785361514,0.5070692966925281},
{0.15589200741874104,0.30231257007674245,0.5209501279041455},
{0.1472205271875216,0.3107525903971191,0.5046697788505762},
{0.18657772994940947,0.3106609082246423,0.5330589381100246},
{0.21649467491906418,0.31077513519362976,0.543149989028199},
{0.2221421464449862,0.29821618055075433,0.555154341676912},
{0.22715911516182657,0.2871880175909532,0.5654129755824824},
{0.23095415590778878,0.27899523853897695,0.5739642168989783},
{0.23293809800072746,0.27494168412635905,0.5808471432736848},
{0.23395937728266064,0.27293219126404167,0.5863383042104662},
{0.23486868407525752,0.2708708453697497,0.5907127462267525},
{0.2216010713287302,0.26312670776833563,0.5930574050638618},
{0.22430719840322724,0.25902130032374326,0.5964518999251514},
{0.2134518788833412,0.24876642388425804,0.598133741744847},
{0.2203167694208392,0.24127103053767837,0.600702345560629},
{0.21114329172064894,0.2313866402541851,0.6014974253842384},
{0.2041829615445891,0.22050802444457135,0.6018566391419751},
{0.11742081515972237,0.29203890630683166,0.4902531329752217},
{0.1390705832489156,0.3188251305343718,0.4875011648144863},
{0.17229560135990213,0.33107221549218296,0.5011753353914228},
{0.1791356926212384,0.3212103700052003,0.5177968623655204},
{0.21080737425263998,0.3235610407880458,0.5293608399890583},
{0.2400013827475193,0.3179999909820814,0.5391708324440663},
{0.24293746674642513,0.30459485497683897,0.5515494287148565},
{0.24555191164844545,0.29281820477288373,0.5621274472376612},
{0.2475351022481671,0.2840805931385663,0.5709108999582171},
{0.248578926326611,0.2797918213490205,0.5779057988222598},
{0.24910422008530952,0.27763653880260075,0.5834691031078754},
{0.24953482569866325,0.2752971404180106,0.587958523586366},
{0.2502915793682046,0.27045827559360447,0.5917310195358176},
{0.23651370272731917,0.2666624833544253,0.5942470188264082},
{0.23974587505373174,0.2582111906357933,0.5972184230065141},
{0.2295518695648253,0.2509562751186608,0.5991730568639887},
{0.2380024107902402,0.24088326003769492,0.6007865128009355},
{0.2303905359950221,0.230402935633103,0.6023263224026141},
{0.22046631657102664,0.22229131784856507,0.6030492588773894},
{0.10824733745953209,0.29827630000811617,0.4730071151377788},
{0.1311814074566163,0.3267143063266711,0.4698876667939196},
{0.16585680747645573,0.34047489862356506,0.4836482590908135},
{0.20094552876565736,0.34616821123572533,0.4967693306600215},
{0.20567016662107607,0.3352685536160351,0.5137485684054216},
{0.23705477784357518,0.3316223085270433,0.5249863979727719},
{0.2644835287716693,0.32052200221840793,0.5347558097940609},
{0.2646556207183674,0.3068140144467056,0.5475732781035919},
{0.2648277126650655,0.2947675781778394,0.5585270432349078},
{0.2649704963762997,0.2858353298003132,0.5675742700746383},
{0.26505691809625725,0.281466148236546,0.5746721235094132},
{0.26508998379780624,0.27922594695660274,0.5802745054423138},
{0.2650757054266828,0.2766806394305485,0.5848360692696388},
{0.26501859194218913,0.2713946361420142,0.5888092139080353},
{0.2649231523036273,0.2609330990678478,0.5926485927538019},
{0.25179757177511713,0.260803090741303,0.5951443017275326},
{0.24319973787916593,0.24921130786873516,0.59884465432815},
{0.25237096109970514,0.24725817699769437,0.5981886007496897},
{0.2503299055222728,0.23075162848580125,0.6008548986836845},
{0.2648277126650655,0.24559286802877314,0.596108467524972},
{0.2647698476873548,0.22567228583194807,0.5989438514327969},
{0.2795622401712202,0.23075162848580125,0.5946167534891831},
{0.2775670256800262,0.24725817699769437,0.5927538018041849},
{0.2925600668528366,0.24088326003769492,0.589175942597942},
{0.2871944052832979,0.24921130786873516,0.5894201778934743},
{0.30161706310438846,0.2509562751186608,0.5839222535177397},
{0.2909398474769367,0.2582111906357933,0.5862578944362449},
{0.2945049312984901,0.2666624833544253,0.5819668681670479},
{0.3073547138163531,0.25902130032374326,0.5790563349375208},
{0.29635961655810095,0.2708708453697497,0.5779253376459025},
{0.31039300089277394,0.26312670776833563,0.5747795870394474},
{0.29733580624701283,0.27293219126404167,0.5734727403350458},
{0.3119981904043334,0.2651790357440234,0.5702901665609567},
{0.2982646518632523,0.27494168412635905,0.5679530226560174},
{0.31343579692849693,0.2670863255288257,0.5647877332259199},
{0.299979559384497,0.27899523853897695,0.5607056220710551},
{0.31596983205629586,0.27075586690754533,0.5574719467582085},
{0.3033101773223395,0.2871880175909532,0.5510737335084814},
{0.3208658103651956,0.27809494966498427,0.5475417153884768},
{0.3077635261264132,0.29821618055075433,0.5392407213132495},
{0.3273962864211188,0.28795604365874994,0.5352608132358998},
{0.3128451232599175,0.31077513519362976,0.525393707296398},
{0.33483306329677065,0.29919387322610025,0.5208922629264349},
{0.31805973469283466,0.3235610407880458,0.5097153043096633},
{0.3424464410784228,0.3106609082246423,0.504701341565691},
{0.3229128778883642,0.3352685536160351,0.4923918826708671},
{0.3495104773184317,0.3212103700052003,0.4869503202864091},
{0.3274954835257657,0.34616821123572533,0.47383375767650315},
{0.35616119228907844,0.33107221549218296,0.4680299755614406},
{0.3318969792978649,0.3565282967255938,0.4544534991027172},
{0.36253686074229496,0.34047489862356506,0.4483303323704201},
{0.33620904737713836,0.3666193476437682,0.43466142224600285},
{0.36877500593679646,0.3496483763237553,0.42823991270654793},
{0.23440576425357182,0.34405200633659083,0.5089901133552369},
{0.23198069564224114,0.355588178711099,0.4916351290013257},
{0.26433999356721805,0.3344434140637446,0.520118976406119},
{0.2890799017648067,0.3179999909820814,0.5300890369163528},
{0.2865571390352631,0.30459485497683897,0.5434077512016376},
{0.2843552639093879,0.29281820477288373,0.5547883644802222},
{0.2827155057098455,0.2840805931385663,0.5641226617288553},
{0.2818790937592997,0.2797918213490205,0.5713009249378516},
{0.2814334582816056,0.27763653880260075,0.5768717441556372},
{0.28096903547348584,0.2752971404180106,0.5813844609238557},
{0.2800747585452294,0.27045827559360447,0.585386162304499},
{0.27833956070712507,0.260803090741303,0.5894261898392106},
{0.2642543233404775,0.3471256135942117,0.5037041100667026},
{0.26421148822710727,0.35887896750843923,0.4859560947602887},
{0.29168307426857165,0.3316223085270433,0.5149411881408359},
{0.19649668892088581,0.3565282967255938,0.4788777801491564},
{0.22970442268788083,0.36652766547129145,0.4733738438276857},
{0.2641964583627668,0.37001309101184054,0.4673190629781375},
{0.2964475412644926,0.355588178711099,0.47991559228186415},
{0.2941254272238939,0.34405200633659083,0.4980731713915551},
{0.19218462084161228,0.3666193476437682,0.4605308247487759},
{0.22750254756200572,0.3771688094243262,0.45466015973739815},
{0.2641964583627668,0.3808383508030457,0.4482386501979434},
{0.29868924553086984,0.36652766547129145,0.46089755343868277},
{0.15961866228195426,0.3496483763237553,0.46566803238033966},
{-0.23440576425357182,0.34405200633659083,0.5089901133552369},
{-0.2642543233404775,0.3471256135942117,0.5037041100667026},
{-0.2941254272238939,0.34405200633659083,0.4980731713915551},
{-0.3229128778883642,0.3352685536160351,0.4923918826708671},
{-0.3495104773184317,0.3212103700052003,0.4869503202864091},
{-0.37281127600542274,0.30231257007674245,0.4820430695792541},
{-0.3917083244406636,0.27901252288296846,0.4779609584243893},
{-0.4057672595447153,0.25244348019514773,0.47485278247878543},
{-0.4166661656711887,0.2570448731629748,0.4552989289718671},
{-0.23705477784357518,0.3316223085270433,0.5249863979727719},
{-0.26433999356721805,0.3344434140637446,0.520118976406119},
{-0.29168307426857165,0.3316223085270433,0.5149411881408359},
{-0.31805973469283466,0.3235610407880458,0.5097153043096633},
{-0.3424464410784228,0.3106609082246423,0.504701341565691},
{-0.36382116265018594,0.2933232082147227,0.5001608195484428},
{-0.3811588626601057,0.27194848664295956,0.4963537549110082},
{-0.39405899522350907,0.24757605862849483,0.4934349552560939},
{-0.24293746674642513,0.30459485497683897,0.5515494287148565},
{-0.2400013827475193,0.3179999909820814,0.5391708324440663},
{-0.2644835287716693,0.32052200221840793,0.5347558097940609},
{-0.2890799017648067,0.3179999909820814,0.5300890369163528},
{-0.3128451232599175,0.31077513519362976,0.525393707296398},
{-0.33483306329677065,0.29919387322610025,0.5208922629264349},
{-0.35409684042191836,0.28359888598645505,0.5168101517715701},
{-0.36969182766156355,0.2643343573680904,0.5133705673172594},
{-0.38127384112231005,0.2423524292769733,0.510721553727256},
{-0.2646556207183674,0.3068140144467056,0.5475732781035919},
{-0.2865571390352631,0.30459485497683897,0.5434077512016376},
{-0.3077635261264132,0.29821618055075433,0.5392407213132495},
{-0.3273962864211188,0.28795604365874994,0.5352608132358998},
{-0.34457692434868087,0.27409324828434095,0.5316543972874102},
{-0.3584261928451834,0.25690434393139167,0.5286100982652531},
{-0.3686697968864133,0.23726857766381795,0.5262616819620586},
{-0.37503569592780855,0.21606444505231898,0.5247451686501078},
{-0.3884979454175447,0.21860449212585406,0.5090126581517476},
{-0.24555191164844545,0.29281820477288373,0.5621274472376612},
{-0.2648277126650655,0.2947675781778394,0.5585270432349078},
{-0.2843552639093879,0.29281820477288373,0.5547883644802222},
{-0.3033101773223395,0.2871880175909532,0.5510737335084814},
{-0.3208658103651956,0.27809494966498427,0.5475417153884768},
{-0.336197023485666,0.26575618253469646,0.5443538811618687},
{-0.3484786771314602,0.25039115221946007,0.5416702988838824},
{-0.35750861962719926,0.23281823483261238,0.5396066985099393},
{-0.3630869537771552,0.21385730947392464,0.5382765555158099},
{-0.2475351022481671,0.2840805931385663,0.5709108999582171},
{-0.23095415590778878,0.27899523853897695,0.5739642168989783},
{-0.2649704963762997,0.2858353298003132,0.5675742700746383},
{-0.2827155057098455,0.2840805931385663,0.5641226617288553},
{-0.299979559384497,0.27899523853897695,0.5607056220710551},
{-0.31596983205629586,0.27075586690754533,0.5574719467582085},
{-0.3298965043541517,0.25954133362992265,0.5545711829405028},
{-0.3409675024273231,0.24552899110532625,0.5521513747816913},
{-0.3490490604831801,0.22949513182694015,0.5503049559474678},
{-0.21577248993750583,0.27075586690754533,0.5765643834298753},
{-0.23293809800072746,0.27494168412635905,0.5808471432736848},
{-0.248578926326611,0.2797918213490205,0.5779057988222598},
{-0.26505691809625725,0.281466148236546,0.5746721235094132},
{-0.2818790937592997,0.2797918213490205,0.5713009249378516},
{-0.2982646518632523,0.27494168412635905,0.5679530226560174},
{-0.31343579692849693,0.2670863255288257,0.5647877332259199},
{-0.32661097600933053,0.25639934048955276,0.5619666276892185},
{-0.3370116421329181,0.24305206946202101,0.559650525594356},
{-0.34455062208608506,0.22779525417003582,0.5579078128240815},
{-0.21862741266897326,0.2670863255288257,0.5833413492609816},
{-0.23395937728266064,0.27293219126404167,0.5863383042104662},
{-0.24910422008530952,0.27763653880260075,0.5834691031078754},
{-0.26508998379780624,0.27922594695660274,0.5802745054423138},
{-0.2814334582816056,0.27763653880260075,0.5768717441556372},
{-0.29733580624701283,0.27293219126404167,0.5734727403350458},
{-0.3119981904043334,0.2651790357440234,0.5702901665609567},
{-0.3247149586227835,0.25466639713109945,0.567466055051387},
{-0.3347789557851451,0.24167984284773844,0.5651454439972224},
{0.336197023485666,0.26575618253469646,0.5443538811618687},
{0.34457692434868087,0.27409324828434095,0.5316543972874102},
{0.3298965043541517,0.25954133362992265,0.5545711829405028},
{0.32661097600933053,0.25639934048955276,0.5619666276892185},
{0.3247149586227835,0.25466639713109945,0.567466055051387},
{0.3225822208728744,0.25267644309242465,0.571993050190729},
{0.31858577994475024,0.24876642388425804,0.5764704467777475},
{0.31110015600999186,0.24127103053767837,0.5818240844558137},
{0.3002996954949485,0.230402935633103,0.5877458510059488},
{0.3101194573617779,0.22229131784856507,0.5848262998578175},
{0.3201173231210415,0.2313866402541851,0.579365950142934},
{0.31790342410369404,0.21679790243213265,0.5818766889810053},
{0.35409684042191836,0.28359888598645505,0.5168101517715701},
{0.3584261928451834,0.25690434393139167,0.5286100982652531},
{0.3484786771314602,0.25039115221946007,0.5416702988838824},
{0.3409675024273231,0.24552899110532625,0.5521513747816913},
{0.3370116421329181,0.24305206946202101,0.559650525594356},
{0.3347789557851451,0.24167984284773844,0.5651454439972224},
{0.33244030889377196,0.2401317668206727,0.5696115681859856},
{0.32816280950248145,0.23712729693901782,0.5740265908359912},
{0.36382116265018594,0.2933232082147227,0.5001608195484428},
{0.36969182766156355,0.2643343573680904,0.5133705673172594},
{0.3686697968864133,0.23726857766381795,0.5262616819620586},
{0.35750861962719926,0.23281823483261238,0.5396066985099393},
{0.3490490604831801,0.22949513182694015,0.5503049559474678},
{0.34455062208608506,0.22779525417003582,0.5579078128240815},
{0.3420398832480138,0.22688218991135384,0.5634215185573734},
{0.33953966531498087,0.22592027859356542,0.5678553285378046},
{0.3350765470990859,0.22407461125255884,0.5722154921829676},
{0.3266741014395604,0.22050802444457135,0.5775105133901061},
{0.3287782824472226,0.20784085477844477,0.5772181825286845},
{0.32871741149664385,0.19442519786816406,0.5774624178242168},
{0.33902188648845255,0.19452063750672588,0.5714692594184645},
{0.33831848883731974,0.17979287343952433,0.5715301303690433},
{0.3350765470990859,0.1660157482918559,0.5722154921829676},
{0.37281127600542274,0.30231257007674245,0.4820430695792541},
{0.38125054483258236,0.3107525903971191,0.4628243820471277},
{0.3893230849698351,0.3188251305343718,0.44287223713518764},
{0.40157016992764627,0.28566323785361514,0.4585356102575818},
{0.3917083244406636,0.27901252288296846,0.4779609584243893},
{0.3811588626601057,0.27194848664295956,0.4963537549110082},
{0.38127384112231005,0.2423524292769733,0.510721553727256},
{0.3491437486285249,0.21138038783061944,0.5568068752611439},
{0.3463451878883341,0.21093550384614226,0.5623912213568361},
{0.3434556964688837,0.2104710810380225,0.5669437672655567},
{0.33831848883731974,0.20957680410976612,0.5715301303690433},
{0.3972122607621344,0.3267143063266711,0.42255261204012373},
{0.4109728530590283,0.29203890630683166,0.43842264579719903},
{0.4166661656711887,0.2570448731629748,0.4552989289718671},
{0.4057672595447153,0.25244348019514773,0.47485278247878543},
{0.39405899522350907,0.24757605862849483,0.4934349552560939},
{0.30089112065674495,0.3771688094243262,0.4414504119685816},
{0.4021202629625065,0.22124223331760207,0.49156073117284044},
{0.427026251161057,0.26146816223836766,0.4350972883118758},
{0.43711730207923144,0.2658020236209348,0.4145717540753477},
{0.4476667638597894,0.23075989491118856,0.4124615611219493},
{0.4513363052385089,0.1946160771452877,0.4117281037421356},
{0.42014633075921853,0.29827630000811617,0.41796624893663714},
{-0.42608613314656224,0.22613821162650188,0.4532496069690475},
{-0.427026251161057,0.26146816223836766,0.4350972883118758},
{-0.43711730207923144,0.2658020236209348,0.4145717540753477},
{-0.4145507122652711,0.22374169975741803,0.47286959187906374},
{-0.4021202629625065,0.22124223331760207,0.49156073117284044},
{-0.3540051582494417,0.21221755127438216,0.5491243601035258},
{0.34775949812276996,0.19459202936234296,0.562049291943091},
{0.3463451878883341,0.17860626564984625,0.5623912213568361},
{0.34461750498240007,0.19457775099121954,0.5666987804768074},
{0.3434556964688837,0.179036119769983,0.5669437672655567},
{0.33953966531498087,0.1643699781465772,0.5678553285378046},
{0.33244030889377196,0.15110311689326691,0.5696115681859856},
{-0.3420398832480138,0.22688218991135384,0.5634215185573734},
{-0.33953966531498087,0.22592027859356542,0.5678553285378046},
{-0.33244030889377196,0.2401317668206727,0.5696115681859856},
{-0.3225822208728744,0.25267644309242465,0.571993050190729},
{-0.32816280950248145,0.23712729693901782,0.5740265908359912},
{-0.3350765470990859,0.22407461125255884,0.5722154921829676},
{-0.3434556964688837,0.2104710810380225,0.5669437672655567},
{-0.33831848883731974,0.20957680410976612,0.5715301303690433},
{-0.3463451878883341,0.21093550384614226,0.5623912213568361},
{-0.3491437486285249,0.21138038783061944,0.5568068752611439},
{-0.34775949812276996,0.19459202936234296,0.562049291943091},
{-0.34461750498240007,0.19457775099121954,0.5666987804768074},
{-0.3434556964688837,0.179036119769983,0.5669437672655567},
{-0.33902188648845255,0.19452063750672588,0.5714692594184645},
{-0.33831848883731974,0.17979287343952433,0.5715301303690433},
{-0.3350765470990859,0.1660157482918559,0.5722154921829676},
{-0.32816280950248145,0.1538092439677639,0.5740265908359912},
{-0.3225822208728744,0.13942190632787346,0.571993050190729},
{-0.29635961655810095,0.2708708453697497,0.5779253376459025},
{-0.28096903547348584,0.2752971404180106,0.5813844609238557},
{-0.2945049312984901,0.2666624833544253,0.5819668681670479},
{-0.3073547138163531,0.25902130032374326,0.5790563349375208},
{-0.31039300089277394,0.26312670776833563,0.5747795870394474},
{-0.2650757054266828,0.2766806394305485,0.5848360692696388},
{-0.2800747585452294,0.27045827559360447,0.585386162304499},
{-0.2909398474769367,0.2582111906357933,0.5862578944362449},
{-0.30161706310438846,0.2509562751186608,0.5839222535177397},
{-0.31110015600999186,0.24127103053767837,0.5818240844558137},
{-0.31858577994475024,0.24876642388425804,0.5764704467777475},
{-0.3201173231210415,0.2313866402541851,0.579365950142934},
{-0.3266741014395604,0.22050802444457135,0.5775105133901061},
{-0.22013941702162196,0.2651790357440234,0.5887633728217969},
{-0.23486868407525752,0.2708708453697497,0.5907127462267525},
{-0.2216010713287302,0.26312670776833563,0.5930574050638618},
{-0.23651370272731917,0.2666624833544253,0.5942470188264082},
{-0.2502915793682046,0.27045827559360447,0.5917310195358176},
{-0.24953482569866325,0.2752971404180106,0.587958523586366},
{-0.20804263070721524,0.25466639713109945,0.5905970162713311},
{-0.20992061225655376,0.25267644309242465,0.5948309290560343},
{-0.22430719840322724,0.25902130032374326,0.5964518999251514},
{-0.23974587505373174,0.2582111906357933,0.5972184230065141},
{-0.25179757177511713,0.260803090741303,0.5951443017275326},
{-0.2649231523036273,0.2609330990678478,0.5926485927538019},
{-0.26501859194218913,0.2713946361420142,0.5888092139080353},
{-0.27833956070712507,0.260803090741303,0.5894261898392106},
{-0.2871944052832979,0.24921130786873516,0.5894201778934743},
{-0.2925600668528366,0.24088326003769492,0.589175942597942},
{-0.3002996954949485,0.230402935633103,0.5877458510059488},
{-0.3101194573617779,0.22229131784856507,0.5848262998578175},
{-0.19806956422411334,0.24167984284773844,0.5916911903953156},
{-0.2000129256833328,0.2401317668206727,0.5958709956683931},
{-0.19058844924865706,0.22688218991135384,0.5922360229776565},
{-0.19254834355865103,0.22592027859356542,0.5963827625491853},
{-0.20372830814829065,0.23712729693901782,0.599081374691512},
{-0.19637194104686012,0.22407461125255884,0.5995360280878105},
{-0.18819419185922429,0.2104710810380225,0.5965743933195259},
{-0.19262048690748518,0.20957680410976612,0.5997389312564064},
{-0.18679566298234593,0.19457775099121954,0.5965894231838663},
{-0.19164580020500738,0.19452063750672588,0.5997772574104746},
{-0.19262048690748518,0.17979287343952433,0.5997389312564064},
{-0.18819419185922429,0.179036119769983,0.5965736418263089},
{-0.19637194104686012,0.1660157482918559,0.5995360280878105},
{-0.19254834355865103,0.1643699781465772,0.5963827625491853},
{-0.1859697719368385,0.17860626564984625,0.5924231447886951},
{-0.19058844924865706,0.16346142284719742,0.5922360229776565},
{-0.2000129256833328,0.15110311689326691,0.5958709956683931},
{-0.19806956422411334,0.14964071109294166,0.5916911903953156},
{-0.20992061225655376,0.13942190632787346,0.5948309290560343},
{-0.20804263070721524,0.13754467627175196,0.5905970162713311},
{0.18360782875573767,0.21138038783061944,0.5871251176086885},
{0.1859697719368385,0.21093550384614226,0.5924231447886951},
{0.18193350186821214,0.19455896366079403,0.5871251176086885},
{0.18360782875573767,0.17808097189114772,0.5871251176086885},
{0.18437585482353439,0.19459202936234296,0.5924269022547802},
{0.1859697719368385,0.17860626564984625,0.5924231447886951},
{0.19058844924865706,0.16346142284719742,0.5922360229776565},
{0.19806956422411334,0.14964071109294166,0.5916911903953156},
{0.18679566298234593,0.19457775099121954,0.5965894231838663},
{0.18819419185922429,0.179036119769983,0.5965743933195259},
{0.19254834355865103,0.1643699781465772,0.5963827625491853},
{0.19164580020500738,0.19452063750672588,0.5997772574104746},
{0.19262048690748518,0.17979287343952433,0.5997389312564064},
{0.19637194104686012,0.1660157482918559,0.5995360280878105},
{0.20372830814829065,0.1538092439677639,0.599081374691512},
{0.2000129256833328,0.15110311689326691,0.5958709956683931},
{0.20992061225655376,0.13942190632787346,0.5948309290560343},
{-0.1859697719368385,0.21093550384614226,0.5924231447886951},
{-0.18437585482353439,0.19459202936234296,0.5924269022547802},
{-0.18360782875573767,0.21138038783061944,0.5871251176086885},
{-0.18837229575165854,0.22779525417003582,0.5869357413179989},
{-0.2134518788833412,0.24876642388425804,0.598133741744847},
{-0.2295518695648253,0.2509562751186608,0.5991730568639887},
{-0.24319973787916593,0.24921130786873516,0.59884465432815},
{-0.25237096109970514,0.24725817699769437,0.5981886007496897},
{-0.2648277126650655,0.24559286802877314,0.596108467524972},
{-0.2775670256800262,0.24725817699769437,0.5927538018041849},
{0.2134518788833412,0.14295392444787794,0.598133741744847},
{0.22430719840322724,0.13323035371282738,0.5964518999251514},
{-0.20372830814829065,0.1538092439677639,0.599081374691512},
{-0.2041829615445891,0.16924716912505142,0.6018566391419751},
{-0.20158805546621136,0.18129886584643687,0.6020783296409967},
{-0.20138139483153028,0.19442519786816406,0.6021542304559159},
{-0.20158805546621136,0.20784085477844477,0.6020783296409967},
{-0.2041829615445891,0.22050802444457135,0.6018566391419751},
{-0.2134518788833412,0.14295392444787794,0.598133741744847},
{-0.21114329172064894,0.15905316363614502,0.6014974253842384},
{-0.21256737136690604,0.17270554090978776,0.602903469193287},
{-0.21428528486101886,0.18188202458284614,0.6034385323638068},
{-0.21578751980184627,0.19435155153289585,0.6035384809616708},
{-0.21428528486101886,0.2071089003850651,0.6034385323638068},
{-0.21256737136690604,0.21679790243213265,0.602903469193287},
{-0.21114329172064894,0.2313866402541851,0.6014974253842384},
{-0.22046631657102664,0.22229131784856507,0.6030492588773894},
{-0.22990356839039172,0.2092251052841997,0.6036684892882158},
{-0.2303905359950221,0.230402935633103,0.6023263224026141},
{-0.24354918222508126,0.21637631473738317,0.60279675715647},
{-0.2503299055222728,0.23075162848580125,0.6008548986836845},
{-0.2380024107902402,0.24088326003769492,0.6007865128009355},
{-0.24953482569866325,0.11769623742376101,0.587958523586366},
{-0.24910422008530952,0.11547181750137525,0.5834691031078754},
{-0.23395937728266064,0.12009049481319382,0.5863383042104662},
{-0.23486868407525752,0.1220496376299707,0.5907127462267525},
{-0.22013941702162196,0.12757085829543305,0.5887633728217969},
{-0.21862741266897326,0.12547043475385586,0.5833413492609816},
{-0.23293809800072746,0.11787358982297827,0.5808471432736848},
{-0.248578926326611,0.11310912282705736,0.5779057988222598},
{-0.26508998379780624,0.1138779003880711,0.5802745054423138},
{-0.2650757054266828,0.1162969570536656,0.5848360692696388},
{-0.26501859194218913,0.12114784576954404,0.5888092139080353},
{-0.2502915793682046,0.12212253247202187,0.5917310195358176},
{-0.23651370272731917,0.12587398661139682,0.5942470188264082},
{-0.2216010713287302,0.12951497124786945,0.5930574050638618},
{-0.28096903547348584,0.11769623742376101,0.5813844609238557},
{-0.2800747585452294,0.12212253247202187,0.585386162304499},
{-0.27833956070712507,0.13108934953753107,0.5894261898392106},
{-0.2649231523036273,0.13088344039606697,0.5926485927538019},
{-0.25179757177511713,0.13108934953753107,0.5951443017275326},
{-0.23974587505373174,0.13368500710912581,0.5972184230065141},
{-0.22430719840322724,0.13323035371282738,0.5964518999251514},
{-0.31039300089277394,0.12951497124786945,0.5747795870394474},
{-0.29635961655810095,0.1220496376299707,0.5779253376459025},
{-0.2945049312984901,0.12587398661139682,0.5819668681670479},
{-0.2909398474769367,0.13368500710912581,0.5862578944362449},
{-0.2871944052832979,0.14207317439752787,0.5894201778934743},
{-0.2775670256800262,0.1437963483441598,0.5927538018041849},
{-0.2648277126650655,0.14530384373750643,0.596108467524972},
{-0.25237096109970514,0.1437963483441598,0.5981886007496897},
{-0.24319973787916593,0.14207317439752787,0.59884465432815},
{-0.2295518695648253,0.14064533728518563,0.5991730568639887},
{-0.31858577994475024,0.14295392444787794,0.5764704467777475},
{-0.3073547138163531,0.13323035371282738,0.5790563349375208},
{-0.30161706310438846,0.14064533728518563,0.5839222535177397},
{-0.2925600668528366,0.14997738005416764,0.589175942597942},
{-0.2795622401712202,0.1594431886157795,0.5946167534891831},
{-0.2647698476873548,0.16420991009135152,0.5989438514327969},
{-0.2503299055222728,0.1594431886157795,0.6008548986836845},
{-0.2380024107902402,0.14997738005416764,0.6007865128009355},
{-0.2203167694208392,0.14981881498537597,0.600702345560629},
{-0.22046631657102664,0.16751422576659825,0.6030492588773894},
{-0.22990356839039172,0.17986952574766055,0.6036684892882158},
{-0.2346507510423211,0.19435981795828308,0.603744390103135},
{0.3370116421329181,0.14812945823350998,0.559650525594356},
{0.3420398832480138,0.16346142284719742,0.5634215185573734},
{0.3347789557851451,0.14964071109294166,0.5651454439972224},
{-0.3287782824472226,0.18129886584643687,0.5772181825286845},
{-0.3266741014395604,0.16924716912505142,0.5775105133901061},
{-0.31790342410369404,0.17270554090978776,0.5818766889810053},
{-0.31570981540320614,0.18188202458284614,0.5834330314334583},
{-0.3101194573617779,0.16751422576659825,0.5848262998578175},
{-0.3201173231210415,0.15905316363614502,0.579365950142934},
{-0.32871741149664385,0.19442519786816406,0.5774624178242168},
{-0.31393027946529756,0.19435155153289585,0.5843543621175274},
{-0.29998857730310124,0.17986952574766055,0.5896020392519938},
{-0.3002996954949485,0.1599068599306823,0.5877458510059488},
{-0.31110015600999186,0.14981881498537597,0.5818240844558137},
{-0.2948896958256055,0.19435981795828308,0.5918189442422094},
{-0.2863587448259692,0.17310834127411168,0.5939291371956077},
{-0.2646270639761205,0.19434403660072566,0.6016537359733791},
{0.2380024107902402,0.14997738005416764,0.6007865128009355},
{0.24319973787916593,0.14207317439752787,0.59884465432815},
{0.2503299055222728,0.1594431886157795,0.6008548986836845},
{0.24354918222508126,0.17310834127411168,0.60279675715647},
{0.2346507510423211,0.19435981795828308,0.603744390103135},
{0.24354918222508126,0.21637631473738317,0.60279675715647},
{0.2863587448259692,0.21637631473738317,0.5939291371956077},
{0.2303905359950221,0.1599068599306823,0.6023263224026141},
{0.22990356839039172,0.17986952574766055,0.6036684892882158},
{0.21578751980184627,0.19435155153289585,0.6035384809616708},
{0.22990356839039172,0.2092251052841997,0.6036684892882158},
{0.2295518695648253,0.14064533728518563,0.5991730568639887},
{0.23974587505373174,0.13368500710912581,0.5972184230065141},
{0.2203167694208392,0.14981881498537597,0.600702345560629},
{0.22046631657102664,0.16751422576659825,0.6030492588773894},
{0.21428528486101886,0.18188202458284614,0.6034385323638068},
{0.20138139483153028,0.19442519786816406,0.6021542304559159},
{0.21428528486101886,0.2071089003850651,0.6034385323638068},
{0.21114329172064894,0.15905316363614502,0.6014974253842384},
{0.21256737136690604,0.17270554090978776,0.602903469193287},
{0.20158805546621136,0.18129886584643687,0.6020783296409967},
{0.20158805546621136,0.20784085477844477,0.6020783296409967},
{0.21256737136690604,0.21679790243213265,0.602903469193287},
{-0.2303905359950221,0.1599068599306823,0.6023263224026141},
{-0.24354918222508126,0.17310834127411168,0.60279675715647},
{0.2041829615445891,0.16924716912505142,0.6018566391419751},
{-0.2203167694208392,0.24127103053767837,0.600702345560629},
{-0.2647698476873548,0.22567228583194807,0.5989438514327969},
{-0.2795622401712202,0.23075162848580125,0.5946167534891831},
{-0.2863587448259692,0.21637631473738317,0.5939291371956077},
{-0.31790342410369404,0.21679790243213265,0.5818766889810053},
{-0.3287782824472226,0.20784085477844477,0.5772181825286845},
{-0.31570981540320614,0.2071089003850651,0.5834330314334583},
{-0.29998857730310124,0.2092251052841997,0.5896020392519938},
{0.09299052216754693,-0.7035611009075031,0.4337844296617378},
{0.0631810407279264,-0.7063048026428513,0.43631696180310275},
{0.06474189213968155,-0.7118290292811817,0.4215260723056714},
{0.09567936489805243,-0.708928265463476,0.4183555224230547},
{0.06525816797977581,-0.7152746256812286,0.40491957519591437},
{0.032841005077088176,-0.7174592164631122,0.40746262824231744},
{0.03265764073213476,-0.7138355161706311,0.423745231775538},
{0.03194672814883173,-0.7082053289887006,0.43812505448325817},
{0.06028704034917381,-0.6992039432352083,0.449649202966294},
{0.08840941951657945,-0.6965436572469498,0.4478253289285811},
{0.11410673007265437,-0.6933558230203414,0.44583011443738707},
{0.12066275689795625,-0.7002936083998907,0.4308859203236831},
{0.12489742117587647,-0.7054646332262205,0.41462886755984135},
{0.09682614354722834,-0.7121160996900842,0.40123575544607143},
{0.08158661259923468,-0.688401979733731,0.4607833264696953},
{0.05577206910130429,-0.6910284485272237,0.46187825208689665},
{0.10491596802847258,-0.6851803283123566,0.45969366130501305},
{0.12493198986385949,-0.6816137415043692,0.45885649786125027},
{0.13657036531588265,-0.6899387833625414,0.44397317469812525},
{0.1454860808426343,-0.6968187037643798,0.42798215053310934},
{0.15182116866213166,-0.7017725470509905,0.4107421446414024},
{0.12712184109826224,-0.7083428522474157,0.396826744741802},
{0.0,-0.7089447983142505,0.4388472394648165},
{0.030547447778736348,-0.7010390896711767,0.45099061835867865},
{0.0,-0.7017500022544798,0.4515407113935391},
{0.0283004830598399,-0.6928057299854812,0.4627326998746509},
{0.0,-0.7146155661299001,0.4246169639072838},
{-0.03194672814883173,-0.7082053289887006,0.43812505448325817},
{-0.030547447778736348,-0.7010390896711767,0.45099061835867865},
{-0.0283004830598399,-0.6928057299854812,0.4627326998746509},
{0.0,-0.6934820738808011,0.46309942856455777},
{0.025043511457265587,-0.6839764361786871,0.47374057251759244},
{0.04934755358898131,-0.6822788130014339,0.4733625714294303},
{0.07217265706959729,-0.6796643680994136,0.4729612740515404},
{0.09277860108034665,-0.6762931695278519,0.47270877233062103},
{0.11042591629567951,-0.6723260368351915,0.47277790970658706},
{0.12525813792004714,-0.6670565663974317,0.4733738438276857},
{0.14183081783503823,-0.67697251939604,0.4585468826558372},
{0.15587472307474953,-0.6856101824324934,0.4425964391245405},
{0.16727863264306175,-0.6925231685358808,0.4254796781204253},
{0.17593057405063864,-0.6972658422285081,0.4071530130369044},
{0.18586080542037026,-0.6867915297696524,0.42378506091604023},
{0.1967025980623499,-0.6913606085291475,0.4043206351019475},
{0.2010514893092575,-0.6790083145209531,0.4233063597367971},
{0.21361645589786907,-0.6834714327368482,0.40270342169891576},
{0.2126703259376381,-0.6685588013382592,0.4244501324131049},
{0.2261498597713657,-0.6730136531287668,0.40276053518340943},
{0.0,-0.7183076523051304,0.40844858734305073},
{-0.03265764073213476,-0.7138355161706311,0.423745231775538},
{-0.0631810407279264,-0.7063048026428513,0.43631696180310275},
{-0.06028704034917381,-0.6992039432352083,0.449649202966294},
{-0.05577206910130429,-0.6910284485272237,0.46187825208689665},
{-0.04934755358898131,-0.6822788130014339,0.4733625714294303},
{-0.025043511457265587,-0.6839764361786871,0.47374057251759244},
{0.0,-0.6845949150962964,0.4739239368625459},
{0.021282287906069362,-0.6751238460821652,0.4835453045200814},
{0.04198141707572947,-0.6735171535841717,0.48359340008597085},
{0.0615142287725711,-0.6708981997228493,0.48380907863925615},
{0.07929606127375094,-0.6673120740912193,0.4842900342981504},
{0.0947452588292938,-0.662802363295869,0.4851392216333855},
{0.10783702216303796,-0.6567453279666698,0.4864904064375915},
{0.11855030946490677,-0.6485149742538424,0.4884818634627004},
{0.13741880115790076,-0.6597806090702225,0.4747039868218149},
{0.15581159764451966,-0.6705254590872063,0.45904061369942073},
{0.1720949526709572,-0.6796876643891413,0.44204634608968024},
{0.18530470043977382,-0.6714888733914288,0.44266557650050653},
{0.19557911570290165,-0.6603314535982999,0.4447983142504155},
{0.22103519693631246,-0.6551912399938679,0.4269443384004016},
{0.20311884714928563,-0.6463303834719588,0.44810638739174735},
{0.17581033513591507,-0.6492890122673753,0.4635352946304307},
{0.1822055424127742,-0.6342959710945649,0.4674257750149547},
{0.20812379197465364,-0.629599889981393,0.452251623976842},
{0.18644020669069442,-0.6170897823976241,0.47189490517658583},
{0.15943003748448167,-0.6204609809691858,0.4845485479648061},
{0.1627148143360858,-0.6029053479263297,0.48903796844329683},
{0.18869318335532703,-0.5981979944149024,0.4765556661085577},
{0.16442370991159433,-0.5846155060104429,0.49345223960008533},
{0.1891463337651914,-0.5781481553847495,0.4810225417905377},
{0.1648250072894842,-0.5664864836429987,0.49738555509797977},
{0.13882860243303446,-0.5706835732600678,0.5077208413116864},
{0.13914272659774973,-0.554595606470056,0.5109492561720138},
{0.1638848892749894,-0.5466260209035353,0.5009859591007332},
{0.13866703139137465,-0.5375096566878388,0.5136869459616257},
{0.1615680356869099,-0.5231418578715908,0.5044029987585331},
{0.13692582160753416,-0.5168233029028679,0.5163231841669397},
{0.1578413808236967,-0.4941417346267033,0.5077862212215672},
{0.13374399932666206,-0.49026027216078355,0.5190781583005432},
{0.15267035599736678,-0.4577348942348447,0.5112836706535888},
{0.12894496364275815,-0.4555442915072249,0.5221713043818066},
{0.1094512295932017,-0.4865276053518341,0.5274745920143326},
{0.10515118540540053,-0.4532394618106177,0.5301123332060804},
{0.12324188161877651,-0.41595938630057927,0.5252441601462104},
{0.09993356799961522,-0.4146074500031563,0.5328522774753435},
{0.11734641733123718,-0.3747888304060168,0.5279390148224522},
{0.09460172362484257,-0.37398022370450085,0.5352953819238828},
{0.1119709863498772,-0.33531740067514154,0.5298966546527951},
{0.08995749554364522,-0.33470643668970246,0.5370380946941573},
{0.10782875573765072,-0.3008276194799066,0.5307601203591537},
{0.08680423000501998,-0.3001339912405951,0.5376798699014942},
{0.10487689038118742,-0.27089489315269444,0.5309427332108901},
{0.08502920302641348,-0.2696857405665057,0.5378106297212562},
{0.10307255516711707,-0.24509462802588747,0.5308615719434517},
{0.08452119361170646,-0.24278378638354414,0.5380180418491542},
{0.10256604873884408,-0.2232915553204217,0.5308059614453919},
{0.08593625533935931,-0.22001429340098777,0.5383930369644484},
{0.10350842123298995,-0.20535040625723314,0.5310682325781328},
{0.08993344776070052,-0.20196192334167995,0.5390265457463981},
{0.07951474579990442,-0.19808947879436442,0.5458238018943641},
{0.09434020398531884,-0.18677950587817996,0.5401094474721271},
{0.08663063507188784,-0.18387122712830395,0.5470344574669869},
{-0.08840941951657945,-0.6965436572469498,0.4478253289285811},
{-0.09299052216754693,-0.7035611009075031,0.4337844296617378},
{-0.08158661259923468,-0.688401979733731,0.4607833264696953},
{-0.07217265706959729,-0.6796643680994136,0.4729612740515404},
{-0.0615142287725711,-0.6708981997228493,0.48380907863925615},
{-0.04198141707572947,-0.6735171535841717,0.48359340008597085},
{-0.021282287906069362,-0.6751238460821652,0.4835453045200814},
{0.0,-0.6756739391170256,0.48356183737085584},
{0.017521064354873134,-0.6668213490205037,0.49167495814182777},
{0.03464158282507342,-0.6653025812289018,0.49206498312146246},
{0.05095875504627695,-0.66267085198289,0.4927758957047654},
{0.06607203513381088,-0.6588525149472001,0.4938535369779752},
{0.07958012570978534,-0.6537724208001299,0.49534449952054727},
{0.09124780939727238,-0.6469210571405383,0.4973111572694945},
{0.10083986881934404,-0.6377874085808501,0.4998166356550466},
{0.12686107295195553,-0.6374868112940413,0.49124810999455926},
{0.1470514412136916,-0.6497932642159971,0.4769742478304392},
{0.16707272350159766,-0.6615413576777056,0.4606112345229971},
{-0.11410673007265437,-0.6933558230203414,0.44583011443738707},
{-0.12066275689795625,-0.7002936083998907,0.4308859203236831},
{-0.10491596802847258,-0.6851803283123566,0.45969366130501305},
{-0.09277860108034665,-0.6762931695278519,0.47270877233062103},
{-0.07929606127375094,-0.6673120740912193,0.4842900342981504},
{-0.06607203513381088,-0.6588525149472001,0.4938535369779752},
{-0.05095875504627695,-0.66267085198289,0.4927758957047654},
{-0.03464158282507342,-0.6653025812289018,0.49206498312146246},
{-0.017521064354873134,-0.6668213490205037,0.49167495814182777},
{0.0,-0.6673030561726151,0.49156073117284044},
{0.014264844245515839,-0.6596430858115074,0.4976606016154098},
{0.02829447111410372,-0.6581957098755228,0.49826855962798083},
{0.04185441472205272,-0.6555497022583874,0.4993116322132076},
{0.054708706199217846,-0.6515307165337526,0.5008138671540351},
{0.06662287966188817,-0.645963654782052,0.5027978092469738},
{0.07716933546957805,-0.6384667584490382,0.5052491801209001},
{0.08592122547501886,-0.6286597719668983,0.5081529499114741},
{0.10812108659907237,-0.6258619627199246,0.5029240601074334},
{0.13274601633445657,-0.6230355967307039,0.49492591779866596},
{0.1542980903054369,-0.6363888797039718,0.4803912874882391},
{-0.06474189213968155,-0.7118290292811817,0.4215260723056714},
{-0.09567936489805243,-0.708928265463476,0.4183555224230547},
{-0.12489742117587647,-0.7054646332262205,0.41462886755984135},
{-0.1454860808426343,-0.6968187037643798,0.42798215053310934},
{-0.13657036531588265,-0.6899387833625414,0.44397317469812525},
{-0.12493198986385949,-0.6816137415043692,0.45885649786125027},
{-0.11042591629567951,-0.6723260368351915,0.47277790970658706},
{-0.0947452588292938,-0.662802363295869,0.4851392216333855},
{-0.07958012570978534,-0.6537724208001299,0.49534449952054727},
{-0.06662287966188817,-0.645963654782052,0.5027978092469738},
{-0.054708706199217846,-0.6515307165337526,0.5008138671540351},
{-0.04185441472205272,-0.6555497022583874,0.4993116322132076},
{-0.02829447111410372,-0.6581957098755228,0.49826855962798083},
{-0.014264844245515839,-0.6596430858115074,0.4976606016154098},
{0.0,-0.660067679479125,0.497465964872201},
{0.01201712803340237,-0.6541624457797643,0.5010318001869715},
{0.023908756699562033,-0.6527571534639329,0.5016968716840362},
{0.0355471321515852,-0.6501028794214104,0.5028669466229397},
{0.04680750651544619,-0.645963654782052,0.5045863631034867},
{0.05756362893068527,-0.6401035106757127,0.5069032166915661},
{0.06728193921321667,-0.6322661879153879,0.5097183102825315},
{0.07542887717895459,-0.622192421341205,0.5129347012513866},
{0.09245170153094198,-0.6161609367813846,0.511495591740789},
{0.11285699685274642,-0.6106337041701861,0.506696556056885},
{0.136446368935074,-0.6062893218825807,0.49916358804945427},
{-0.06525816797977581,-0.7152746256812286,0.40491957519591437},
{-0.09682614354722834,-0.7121160996900842,0.40123575544607143},
{-0.12712184109826224,-0.7083428522474157,0.396826744741802},
{-0.15182116866213166,-0.7017725470509905,0.4107421446414024},
{-0.16727863264306175,-0.6925231685358808,0.4254796781204253},
{-0.15587472307474953,-0.6856101824324934,0.4425964391245405},
{-0.14183081783503823,-0.67697251939604,0.4585468826558372},
{-0.12525813792004714,-0.6670565663974317,0.4733738438276857},
{-0.10783702216303796,-0.6567453279666698,0.4864904064375915},
{-0.09124780939727238,-0.6469210571405383,0.4973111572694945},
{-0.07716933546957805,-0.6384667584490382,0.5052491801209001},
{-0.06728193921321667,-0.6322661879153879,0.5097183102825315},
{-0.05756362893068527,-0.6401035106757127,0.5069032166915661},
{-0.04680750651544619,-0.645963654782052,0.5045863631034867},
{-0.0355471321515852,-0.6501028794214104,0.5028669466229397},
{-0.023908756699562033,-0.6527571534639329,0.5016968716840362},
{-0.01201712803340237,-0.6541624457797643,0.5010318001869715},
{0.0,-0.6545517192661819,0.5008258910455075},
{0.010572758070285657,-0.64995408376444,0.5018343949427513},
{0.02108314220355847,-0.6485720877383361,0.5024453589281903},
{0.031471032942456664,-0.6459178136958136,0.5035891316044981},
{0.041673304856750366,-0.6417267360244806,0.5053604011170195},
{0.051629838489077796,-0.6357350806051625,0.5078546071043163},
{0.060762735555548876,-0.6277970577537568,0.5108989061264734},
{0.0684971037451416,-0.6177661262929441,0.5143219577300094},
{0.0814723856302473,-0.6096252002729424,0.5164546954799186},
{0.09633316399686176,-0.6005892458314671,0.5152620757445043},
{0.1149130822945192,-0.593244902621509,0.5109605285702691},
{0.13820260858325495,-0.588376729561639,0.5036101734145747},
{-0.032841005077088176,-0.7174592164631122,0.40746262824231744},
{0.1817185748081438,-0.699393319525898,0.3875728572673904},
{0.204213772766487,-0.6929199569544685,0.38371469109119816},
{0.18453066242624094,-0.6984584619639224,0.36669787868494697},
{0.15732585647681946,-0.7039744221768655,0.37193804088724297},
{0.15571991547204295,-0.7043186060702616,0.3921081188321194},
{0.22230296599342894,-0.6842514826961172,0.3810250968674756},
{0.2079862687159386,-0.6909938798392405,0.362030354314022},
{0.18469298496111775,-0.693442996233516,0.3459499024561804},
{0.1570102293256701,-0.6995082979881023,0.35136065361874047},
{0.12676939077947882,-0.7044012703241341,0.35691343699931766},
{0.12764938933661185,-0.7084007172251263,0.377247340465505},
{0.09678030246099,-0.7125970553489784,0.3821207739778942},
{0.06501693865711168,-0.7161403458672382,0.38613975970252895},
{0.03265764073213476,-0.7186059951122882,0.3888857159175282},
{0.0,-0.7195694094165107,0.38994081239422734},
{-0.03265764073213476,-0.7186059951122882,0.3888857159175282},
{-0.06501693865711168,-0.7161403458672382,0.38613975970252895},
{-0.09678030246099,-0.7125970553489784,0.3821207739778942},
{-0.12764938933661185,-0.7084007172251263,0.377247340465505},
{-0.15571991547204295,-0.7043186060702616,0.3921081188321194},
{-0.15732585647681946,-0.7039744221768655,0.37193804088724297},
{-0.1817185748081438,-0.699393319525898,0.3875728572673904},
{-0.18453066242624094,-0.6984584619639224,0.36669787868494697},
{-0.204213772766487,-0.6929199569544685,0.38371469109119816},
{-0.2079862687159386,-0.6909938798392405,0.362030354314022},
{-0.22230296599342894,-0.6842514826961172,0.3810250968674756},
{-0.22641363389054053,-0.6807194645761128,0.35844122270952383},
{-0.20803286129539397,-0.6852118910274716,0.34135752740695763},
{-0.22570948474619068,-0.6735374439010313,0.3375519657559571},
{-0.20436557439632552,-0.6752050073496036,0.32378461002010994},
{-0.21995004073093236,-0.6633659832086356,0.32095598955123833},
{-0.19999789581899233,-0.6598572613783589,0.3093055902077428},
{-0.212362965211876,-0.6539054350995428,0.3109829230681364},
{-0.22858319480808367,-0.6458501793062815,0.31662964310084135},
{-0.2155928830586375,-0.6378407645992588,0.3040308593174638},
{-0.1979440648568706,-0.638052685686459,0.29791520751733697},
{-0.2162744874064767,-0.6126424455392865,0.2976499304117281},
{-0.19588347045579566,-0.6101271977419132,0.2894872110884327},
{-0.17142386922815636,-0.6128776629162145,0.28630914627364573},
{-0.19149700454803695,-0.5764167150127303,0.2838953500605704},
{-0.16643019680104368,-0.5780166440717706,0.27880999546098095},
{-0.13920810650763066,-0.5837325014804416,0.27685461011028917},
{-0.13450676494193964,-0.5459489255149983,0.26998596210670606},
{-0.16106378373828797,-0.5402473464774507,0.273738167739298},
{-0.1720949526709572,-0.6796876643891413,0.44204634608968024},
{-0.18586080542037026,-0.6867915297696524,0.42378506091604023},
{-0.15581159764451966,-0.6705254590872063,0.45904061369942073},
{-0.13741880115790076,-0.6597806090702225,0.4747039868218149},
{-0.11855030946490677,-0.6485149742538424,0.4884818634627004},
{-0.10083986881934404,-0.6377874085808501,0.4998166356550466},
{-0.08592122547501886,-0.6286597719668983,0.5081529499114741},
{-0.07542887717895459,-0.622192421341205,0.5129347012513866},
{-0.0684971037451416,-0.6177661262929441,0.5143219577300094},
{-0.060762735555548876,-0.6277970577537568,0.5108989061264734},
{-0.051629838489077796,-0.6357350806051625,0.5078546071043163},
{-0.041673304856750366,-0.6417267360244806,0.5053604011170195},
{-0.031471032942456664,-0.6459178136958136,0.5035891316044981},
{-0.02108314220355847,-0.6485720877383361,0.5024453589281903},
{-0.010572758070285657,-0.64995408376444,0.5018343949427513},
{0.0,-0.6503268244000829,0.5016623029960532},
{-0.18530470043977382,-0.6714888733914288,0.44266557650050653},
{-0.2010514893092575,-0.6790083145209531,0.4233063597367971},
{-0.16707272350159766,-0.6615413576777056,0.4606112345229971},
{-0.1470514412136916,-0.6497932642159971,0.4769742478304392},
{-0.12686107295195553,-0.6374868112940413,0.49124810999455926},
{-0.10812108659907237,-0.6258619627199246,0.5029240601074334},
{-0.09245170153094198,-0.6161609367813846,0.511495591740789},
{-0.0814723856302473,-0.6096252002729424,0.5164546954799186},
{-0.07425654776039992,-0.6054964965386223,0.5179516699682268},
{-0.0642601849875703,-0.6147616564112892,0.512476290389003},
{-0.06987909977124547,-0.603019574895317,0.5161338078762502},
{-0.07746467230386779,-0.5908423788066889,0.5216151994012102},
{-0.07306693399785373,-0.58925973409164,0.5197229394807482},
{-0.0775901716711105,-0.5758034965476402,0.5250833405977677},
{-0.0733021513747817,-0.575459312654244,0.5229799110833225},
{-0.07410249165091036,-0.5623818276916233,0.5281268881267078},
{-0.07006246411619889,-0.5635969922235482,0.5256401970715813},
{-0.06630650101752182,-0.5531166678189562,0.5303903856963786},
{-0.06282708742270893,-0.5556499514535381,0.5274400233263495},
{-0.0611354761911919,-0.5577774287509281,0.5220337811230916},
{-0.06805597722674955,-0.565007544991899,0.5203767385795577},
{-0.17593057405063864,-0.6972658422285081,0.4071530130369044},
{-0.1967025980623499,-0.6913606085291475,0.4043206351019475},
{-0.21361645589786907,-0.6834714327368482,0.40270342169891576},
{-0.2126703259376381,-0.6685588013382592,0.4244501324131049},
{-0.19557911570290165,-0.6603314535982999,0.4447983142504155},
{-0.17581033513591507,-0.6492890122673753,0.4635352946304307},
{-0.1542980903054369,-0.6363888797039718,0.4803912874882391},
{-0.13274601633445657,-0.6230355967307039,0.49492591779866596},
{-0.11285699685274642,-0.6106337041701861,0.506696556056885},
{-0.09633316399686176,-0.6005892458314671,0.5152620757445043},
{-0.08487815288979202,-0.5943052595507273,0.5201813503431317},
{-0.07746467230386779,-0.5908423788066889,0.5216151994012102},
{-0.0850532508093582,-0.5778558245233278,0.52401020828386},
{-0.0775901716711105,-0.5758034965476402,0.5250833405977677},
{-0.08140550273393232,-0.5619008720327291,0.5278353087585032},
{-0.07268592693682348,-0.5502166554944675,0.5310539542070094},
{-0.05764629318455772,-0.546580931310514,0.5330641985625438},
{-0.05350782003841634,-0.5505480640031744,0.5315206314947802},
{-0.05107373350848135,-0.5535976234778505,0.5281171187148865},
{-0.0611354761911919,-0.5577774287509281,0.5220337811230916},
{-0.049754862912607355,-0.5559715905504238,0.5225320211259773},
{-0.0601209603482119,-0.5594570160909728,0.514001070126341},
{-0.04896354055508295,-0.557908940063907,0.5144482085904694},
{-0.05920639310309585,-0.5616874479590948,0.5044616152294609},
{-0.048212798831277756,-0.5604662714814337,0.5049170201189764},
{-0.05781613065160474,-0.5654659558542825,0.4945343898325974},
{-0.06584884164835528,-0.5676219898939193,0.5027542226403864},
{-0.06444354933252372,-0.5704769126253867,0.4928525480129017},
{-0.05537377769628252,-0.5717897712755245,0.4853376158426794},
{-0.062035765065184524,-0.5754653245999802,0.4838624346576649},
{-0.05130293893967313,-0.5816568772150262,0.4779910181530702},
{-0.05802203979306883,-0.5834116138767731,0.47701257398450714},
{-0.06506127675691599,-0.5817402929621157,0.48223470034959465},
{-0.06130080469893679,-0.587736457340736,0.47601534248551874},
{-0.0535506551517866,-0.5931299241593045,0.47258101848372724},
{-0.0571555681138422,-0.5936229037096712,0.47327464672303876},
{-0.055934391636181094,-0.6001721670960197,0.47217972110583734},
{-0.049766135310862686,-0.6034328961646792,0.4708435661659718},
{-0.04658957348250975,-0.5934883864238242,0.4729312143228595},
{-0.04222114341195956,-0.6057031571733034,0.4705948219111374},
{-0.037129776866634004,-0.5951709797367369,0.4728485500689872},
{-0.033070210508279956,-0.6082026236131193,0.4702626619092137},
{-0.038723693979938134,-0.6164938482765254,0.4715717630932663},
{-0.029744853022956614,-0.6196471138151508,0.47099236182294213},
{-0.022716136964147763,-0.6105194772011988,0.4699244899615536},
{-0.020164817492357313,-0.6220323532859793,0.4706173667076482},
{-0.011558717171018815,-0.6122396451749628,0.46965846136272776},
{-0.010182733090651123,-0.623545860625062,0.47041521503226913},
{0.0,-0.6129505577582657,0.46954423439374027},
{0.0,-0.6240846812616669,0.47035810154777546},
{0.010182733090651123,-0.623545860625062,0.47041521503226913},
{0.011558717171018815,-0.6122396451749628,0.46965846136272776},
{0.020164817492357313,-0.6220323532859793,0.4706173667076482},
{0.022716136964147763,-0.6105194772011988,0.4699244899615536},
{0.029744853022956614,-0.6196471138151508,0.47099236182294213},
{0.033070210508279956,-0.6082026236131193,0.4702626619092137},
{0.038723693979938134,-0.6164938482765254,0.4715717630932663},
{0.04222114341195956,-0.6057031571733034,0.4705948219111374},
{0.037129776866634004,-0.5951709797367369,0.4728485500689872},
{0.04658957348250975,-0.5934883864238242,0.4729312143228595},
{0.049766135310862686,-0.6034328961646792,0.4708435661659718},
{0.0535506551517866,-0.5931299241593045,0.47258101848372724},
{0.055934391636181094,-0.6001721670960197,0.47217972110583734},
{0.0571555681138422,-0.5936229037096712,0.47327464672303876},
{0.0609528633394555,-0.5947027994625321,0.4757763676425057},
{0.06130080469893679,-0.587736457340736,0.47601534248551874},
{0.05802203979306883,-0.5834116138767731,0.47701257398450714},
{0.06506127675691599,-0.5817402929621157,0.48223470034959465},
{0.062035765065184524,-0.5754653245999802,0.4838624346576649},
{0.05130293893967313,-0.5816568772150262,0.4779910181530702},
{0.05537377769628252,-0.5717897712755245,0.4853376158426794},
{0.06444354933252372,-0.5704769126253867,0.4928525480129017},
{0.05781613065160474,-0.5654659558542825,0.4945343898325974},
{0.06584884164835528,-0.5676219898939193,0.5027542226403864},
{0.05920639310309585,-0.5616874479590948,0.5044616152294609},
{0.06685208509307995,-0.5660739138668535,0.5123380156370708},
{0.0601209603482119,-0.5594570160909728,0.514001070126341},
{0.06805597722674955,-0.565007544991899,0.5203767385795577},
{0.0611354761911919,-0.5577774287509281,0.5220337811230916},
{0.07006246411619889,-0.5635969922235482,0.5256401970715813},
{0.06282708742270893,-0.5556499514535381,0.5274400233263495},
{0.06630650101752182,-0.5531166678189562,0.5303903856963786},
{0.07410249165091036,-0.5623818276916233,0.5281268881267078},
{0.0733021513747817,-0.575459312654244,0.5229799110833225},
{0.0775901716711105,-0.5758034965476402,0.5250833405977677},
{0.07306693399785373,-0.58925973409164,0.5197229394807482},
{0.07746467230386779,-0.5908423788066889,0.5216151994012102},
{0.06987909977124547,-0.603019574895317,0.5161338078762502},
{0.07425654776039992,-0.6054964965386223,0.5179516699682268},
{0.0642601849875703,-0.6147616564112892,0.512476290389003},
{0.05678959091715238,-0.6245378316715313,0.5089728290112453},
{-0.2261498597713657,-0.6730136531287668,0.40276053518340943},
{-0.22103519693631246,-0.6551912399938679,0.4269443384004016},
{-0.20311884714928563,-0.6463303834719588,0.44810638739174735},
{-0.1822055424127742,-0.6342959710945649,0.4674257750149547},
{-0.15943003748448167,-0.6204609809691858,0.4845485479648061},
{-0.136446368935074,-0.6062893218825807,0.49916358804945427},
{-0.1149130822945192,-0.593244902621509,0.5109605285702691},
{-0.09704332508694777,-0.5831568576762026,0.5194170817414201},
{-0.09406064850858656,-0.565077433861082,0.5239215320842514},
{-0.0851885195884222,-0.5464576864229224,0.529248867499722},
{-0.0617238953801203,-0.5409973367080388,0.5336225580227913},
{-0.040830129467251425,-0.541847275536491,0.5352608132358998},
{-0.03906562339368325,-0.5477788114984475,0.5340606785683153},
{-0.03725677922031076,-0.5520300086271421,0.531852040003487},
{-0.03593114518548356,-0.5551171427626694,0.5280765380811674},
{-0.03502860183183987,-0.5574422627761362,0.522317094065909},
{-0.034486775222366844,-0.5594059145522152,0.5141558777290477},
{-0.03395471802471511,-0.5620489161964825,0.5046119138728653},
{-0.04701416715012731,-0.5646979297864858,0.49499280069498097},
{-0.044881429400218234,-0.5716582599625456,0.48572764082231396},
{-0.041326866483703116,-0.5824023584863123,0.4781743824980235},
{0.24016220229596205,-0.6424662053500305,0.40709514805919356},
{0.22646473542929801,-0.6386531287668598,0.4305161856609082},
{0.23482434597545324,-0.6595055625527925,0.4042913268664837},
{0.24268496502550566,-0.6214131228751529,0.4109713500725942},
{0.22927757454061218,-0.6186919659363155,0.4348936336500626},
{0.2479138548295463,-0.6392550748336946,0.38239582049532417},
{0.24335304249543843,-0.6579003730412329,0.3805005546019942},
{0.23508210814889186,-0.6727386066113368,0.37999930862624043},
{0.21079535036116762,-0.610255703082024,0.4568958520580394},
{0.2297908444078384,-0.5950560012745325,0.4398046418233028},
{0.24291417045669744,-0.5958646079760485,0.4157185327245237},
{0.24956488542734415,-0.6163217563298273,0.3855490860339495},
{0.24841810677816825,-0.6272379468002922,0.35682476079970904},
{0.2454887862182156,-0.6490019418584728,0.3559244719257164},
{0.23853371649467492,-0.6667755079342654,0.3564347358200745},
{0.21133417099777257,-0.588411298249622,0.4617008996876795},
{0.22830814829065355,-0.5674814606623361,0.44489751135506245},
{0.24118273008467825,-0.5660160488891428,0.4208384560120961},
{0.24910647456496057,-0.5886172073910861,0.38982658542524},
{0.2484639478644066,-0.6013227032112808,0.3590491807220948},
{0.24235280502358184,-0.6106795452564245,0.3322855012910654},
{0.24148933931722336,-0.6361468988880906,0.332610146360819},
{0.2364017302379829,-0.6571413648920406,0.33450015180162984},
{-0.22646473542929801,-0.6386531287668598,0.4305161856609082},
{-0.20812379197465364,-0.629599889981393,0.452251623976842},
{-0.18644020669069442,-0.6170897823976241,0.47189490517658583},
{-0.1627148143360858,-0.6029053479263297,0.48903796844329683},
{-0.13820260858325495,-0.588376729561639,0.5036101734145747},
{-0.1141548256385438,-0.5748355732841155,0.5155423827144536},
{-0.1127517878023633,-0.5575782830484173,0.5194952370359905},
{-0.1128705237306528,-0.5436455988048252,0.5218722100814318},
{-0.08736409245170153,-0.5357684469039983,0.52972381121288},
{-0.0639761205515359,-0.5330961370242673,0.5340734539530045},
{-0.04202350069588272,-0.5337198763943957,0.5360100519732709},
{-0.020823877043685803,-0.5357323752295813,0.5366255249180121},
{-0.02031962509506389,-0.5443783046914218,0.5357304964965386},
{-0.01972293948074825,-0.5505931535961957,0.5342402854471835},
{-0.019103709069921936,-0.5549164940737246,0.5317175227176401},
{-0.01853031974533398,-0.5578863952673964,0.5277270937352518},
{-0.018071908882950422,-0.5600424293070331,0.5218331324341468},
{-0.01779686236552029,-0.5619226653360228,0.5135997727484511},
{-0.017521064354873134,-0.5645258378397876,0.5040362700686265},
{-0.03308223439975231,-0.5664120858145134,0.4947064817792955},
{-0.03151687402869501,-0.5735354900186671,0.48545785475740294},
{-0.02890768957919386,-0.5844606984077362,0.4778880635823381},
{-0.22927757454061218,-0.6186919659363155,0.4348936336500626},
{-0.21079535036116762,-0.610255703082024,0.4568958520580394},
{-0.18869318335532703,-0.5981979944149024,0.4765556661085577},
{-0.16442370991159433,-0.5846155060104429,0.49345223960008533},
{-0.13882860243303446,-0.5706835732600678,0.5077208413116864},
{-0.13914272659774973,-0.554595606470056,0.5109492561720138},
{-0.13866703139137465,-0.5375096566878388,0.5136869459616257},
{-0.11310123214827864,-0.5293800030660923,0.5235337615842679},
{-0.08815691779565997,-0.5236122926254467,0.5305136305839703},
{-0.06480276309026035,-0.5215825094462697,0.5346107716031755},
{-0.04260290196620685,-0.5219176754210617,0.5366007256418504},
{-0.021122219850843626,-0.5232448124423229,0.5372560277270937},
{0.0,-0.5241563737145709,0.5372500157813576},
{0.0,-0.5370850630202212,0.5366022286282844},
{0.0,-0.5460639039772027,0.5356733830120449},
{0.0,-0.5524050037424363,0.5341253069849792},
{0.0,-0.5567110598759736,0.5315341583726865},
{0.0,-0.5595832669514326,0.5274745920143326},
{0.0,-0.561624322528865,0.5215235172287335},
{0.0,-0.5634361726751055,0.5132555888550551},
{0.0,-0.5659874921468959,0.5036808137769748},
{-0.017062653492489577,-0.5688484268240994,0.49415187978513303},
{-0.016236762446982154,-0.5758891667743807,0.48495510579521506},
{-0.014860778366614464,-0.5866452891896198,0.47745595498255033},
{-0.025795004674287813,-0.5973878847269526,0.4725314199314037},
{-0.013209747768816638,-0.5993507850098144,0.4721812240922714},
{0.0,-0.6002676067345817,0.4719978597473179},
{0.013209747768816638,-0.5993507850098144,0.4721812240922714},
{0.025795004674287813,-0.5973878847269526,0.4725314199314037},
{0.02890768957919386,-0.5844606984077362,0.4778880635823381},
{0.041326866483703116,-0.5824023584863123,0.4781743824980235},
{-0.24016220229596205,-0.6424662053500305,0.40709514805919356},
{-0.23482434597545324,-0.6595055625527925,0.4042913268664837},
{-0.24268496502550566,-0.6214131228751529,0.4109713500725942},
{-0.24291417045669744,-0.5958646079760485,0.4157185327245237},
{-0.2297908444078384,-0.5950560012745325,0.4398046418233028},
{-0.24118273008467825,-0.5660160488891428,0.4208384560120961},
{-0.22830814829065355,-0.5674814606623361,0.44489751135506245},
{-0.21133417099777257,-0.588411298249622,0.4617008996876795},
{-0.20998148320713256,-0.5632753531266628,0.4664939234258472},
{-0.22513459243516867,-0.5357038184873344,0.44982129491299216},
{-0.20697701332547774,-0.5340580483420556,0.47110358281906145},
{-0.2205737801010608,-0.4994600521235696,0.4542242936715254},
{-0.20256274216868916,-0.49996731004505957,0.47535778592062433},
{-0.2149293145480069,-0.4584856359586499,0.4577563117915298},
{-0.19697764457978,-0.4602118158781499,0.4790844407838375},
{-0.2084364131529349,-0.4154603948044765,0.4604090828476183},
{-0.19055087458780595,-0.417675045315041,0.4821693204397138},
{-0.2013295417995557,-0.37306340197973376,0.4621765948940545},
{-0.18360782875573767,-0.37524198081588117,0.4844966949328315},
{-0.1938446693580144,-0.33397222781667174,0.46305058150545136},
{-0.17647540663297973,-0.3357961018543847,0.48595308878742055},
{-0.18621626171202177,-0.30086744862040876,0.46302503073607254},
{-0.1694805077689369,-0.3022208879042658,0.4864235235412765},
{-0.1787539340669911,-0.2729832928027992,0.46241857570993555},
{-0.16284106519654554,-0.2738061778754385,0.48622287485233157},
{-0.17176805312155252,-0.2495532372824803,0.461551352537492},
{-0.15677501194874216,-0.24984030769138277,0.4856660183785182},
{-0.1655674825879022,-0.22981301345774055,0.4607434973291932},
{-0.15150028105846317,-0.22961236476879562,0.48507008425741954},
{-0.13957483519753752,-0.24896857555963703,0.505848120214867},
{-0.13560695101166018,-0.22830551806439398,0.5055039363214707},
{-0.14723480555864504,-0.21241218801759096,0.48474919665375105},
{-0.13260323262322235,-0.21080699850603152,0.5053897093524834},
{-0.143479593953185,-0.1969547240366609,0.48539698380682417},
{-0.13000306609232545,-0.1950857604059266,0.5062524235656249},
{-0.11787922602210593,-0.2083759179489646,0.5203421698915747},
{-0.11689927886710895,-0.192597566364366,0.5212882998518056},
{-0.127248091958722,-0.1797545472854562,0.5088405662050495},
{-0.1156089650134818,-0.17736930781462767,0.5237592095493746},
{-0.1237791992689474,-0.16342610266599736,0.5139033760081282},
{-0.11334997640311298,-0.1612700686263606,0.5283801413408442},
{-0.11903727706953716,-0.14471166708249295,0.5221885887257982},
{-0.10946250199145703,-0.1428772721397417,0.535776337582777},
{-0.11439079450868876,-0.12278910695552064,0.5328500229956924},
{-0.10436963245969742,-0.12192038079664295,0.5449250160068055},
{-0.24335304249543843,-0.6579003730412329,0.3805005546019942},
{-0.2479138548295463,-0.6392550748336946,0.38239582049532417},
{-0.24956488542734415,-0.6163217563298273,0.3855490860339495},
{-0.24910647456496057,-0.5886172073910861,0.38982658542524},
{-0.2468760426968386,-0.5566877635862459,0.3946451599327864},
{-0.2378228039113719,-0.5320628338508617,0.42583212843920876},
{-0.23316730343191922,-0.494199599604414,0.43020131000297596},
{-0.22754838864824406,-0.45262023139979135,0.4334462577140779},
{-0.22112161865627,-0.40974604038223955,0.43565339329247216},
{-0.2140410495654866,-0.36799458023091886,0.4369091384581163},
{-0.20646073748538343,-0.329787162091075,0.43729916343775077},
{-0.19853774449831818,-0.29754209113508545,0.4369091384581163},
{-0.19064856870601887,-0.2704687964986428,0.43606070261609825},
{-0.18317196268986474,-0.24777595582422277,0.4350747435153651},
{-0.17648667903123508,-0.2286722467543008,0.4342721487595853},
{-0.17097147031150897,-0.21236634693135262,0.4339738059524275},
{-0.16046183767145317,-0.21299684974043429,0.46031289171583933},
{-0.1559881985505199,-0.1979714943592919,0.46078482945612936},
{-0.15168364540341658,-0.183601441063393,0.46268084684267646},
{-0.13973565474598026,-0.18195642241133134,0.48770782544916746},
{-0.13550399644092812,-0.16613222974049438,0.49237459832687547},
{-0.13028637903514284,-0.14819784411625903,0.5000916821724768},
{-0.12652365249751257,-0.12795261684968035,0.509469566027697},
{-0.12665516381049144,-0.10519439626537931,0.5191187389342623},
{-0.11120596625494858,-0.09683403422600709,0.5450414974554441},
{-0.23508210814889186,-0.6727386066113368,0.37999930862624043},
{-0.23853371649467492,-0.6667755079342654,0.3564347358200745},
{-0.2454887862182156,-0.6490019418584728,0.3559244719257164},
{-0.24841810677816825,-0.6272379468002922,0.35682476079970904},
{-0.2484639478644066,-0.6013227032112808,0.3590491807220948},
{-0.24676707618037041,-0.571096143036213,0.36251206146613324},
{-0.2436596517279835,-0.5373029960531577,0.36664602565297244},
{-0.2432125132638553,-0.5210775060044308,0.39942390529983074},
{-0.23845405821367058,-0.482331267227982,0.4035804142831806},
{-0.23293809800072746,-0.44099312834602356,0.4065337826260781},
{-0.22674278791959626,-0.3991559979679624,0.40842829702619116},
{-0.21994628326484728,-0.35891278470320526,0.4094120016472732},
{-0.21262448485139976,-0.3223563971611592,0.40962918318699265},
{-0.204855547973824,-0.2915797439512311,0.40922788580910274},
{-0.1970467819557461,-0.2657847392769433,0.4085169732257996},
{-0.18960474462757498,-0.24417555182146927,0.4078060606424967},
{-0.18293674531293683,-0.22595484728154844,0.4074047632646068},
{-0.17745009333545755,-0.21032529135392025,0.40762269629754316},
{-0.17274273982403035,-0.19651059154540074,0.4085402695155274},
{-0.16618971897159657,-0.19790085399689183,0.4344780579010493},
{-0.16170555894562497,-0.1843183655924322,0.4360832474126089},
{-0.1570846271541553,-0.1706614793594873,0.4390877172942637},
{-0.14708525840845763,-0.16875494106790195,0.46652548614096206},
{-0.14173086923717426,-0.15229723961511527,0.4728410351368169},
{-0.13887218903962173,-0.1348498215955103,0.47972170703187234},
{-0.14176318344550623,-0.1170356748859985,0.4852632180141942},
{0.2378228039113719,-0.5320628338508617,0.42583212843920876},
{0.22513459243516867,-0.5357038184873344,0.44982129491299216},
{0.2468760426968386,-0.5566877635862459,0.3946451599327864},
{0.24676707618037041,-0.571096143036213,0.36251206146613324},
{0.24046580555563904,-0.5812676037286088,0.33338643885400293},
{0.2303927904746732,-0.5938460971951267,0.31068157428811044},
{0.2316139669523343,-0.6226718740136652,0.31260464543047034},
{0.2205737801010608,-0.4994600521235696,0.4542242936715254},
{0.23316730343191922,-0.494199599604414,0.43020131000297596},
{0.2432125132638553,-0.5210775060044308,0.39942390529983074},
{0.2436596517279835,-0.5373029960531577,0.36664602565297244},
{0.23730727956449463,-0.548437871049776,0.33577167832483146},
{0.22665411171998762,-0.5610050921180386,0.3104756651466464},
{0.20998148320713256,-0.5632753531266628,0.4664939234258472},
{0.20697701332547774,-0.5340580483420556,0.47110358281906145},
{0.20256274216868916,-0.49996731004505957,0.47535778592062433},
{0.2149293145480069,-0.4584856359586499,0.4577563117915298},
{0.22754838864824406,-0.45262023139979135,0.4334462577140779},
{0.23845405821367058,-0.482331267227982,0.4035804142831806},
{0.23947458600238672,-0.5006894950266179,0.37088294441054376},
{0.23320187211990223,-0.513036528582293,0.33892494386345673},
{0.22213613449925002,-0.5257788475701218,0.31159914750609463},
{0.1879304177400495,-0.5555928379690445,0.4852992896886113},
{0.1851784495793141,-0.5291846148296666,0.4893934247349483},
{0.1810219405959642,-0.4975760586284948,0.4933087043956342},
{0.19697764457978,-0.4602118158781499,0.4790844407838375},
{0.2084364131529349,-0.4154603948044765,0.4604090828476183},
{0.22112161865627,-0.40974604038223955,0.43565339329247216},
{0.23293809800072746,-0.44099312834602356,0.4065337826260781},
{0.23454328751228692,-0.46200036973466285,0.3746554403599954},
{0.22847723426448352,-0.47590975768852717,0.3423307111230014},
{0.2171710188143842,-0.4890623919728501,0.31356580525504174},
{0.17559240210297863,-0.45942049352062553,0.4970526436028388},
{0.19055087458780595,-0.417675045315041,0.4821693204397138},
{0.2013295417995557,-0.37306340197973376,0.4621765948940545},
{0.2140410495654866,-0.36799458023091886,0.4369091384581163},
{0.22674278791959626,-0.3991559979679624,0.40842829702619116},
{0.2292001707392589,-0.42198110144857837,0.3773961361224753},
{0.2234610170408602,-0.4379029882376282,0.3454727042633713},
{0.21209167616053098,-0.45174925076126266,0.3158879192956405},
{-0.1891463337651914,-0.5781481553847495,0.4810225417905377},
{-0.1879304177400495,-0.5555928379690445,0.4852992896886113},
{-0.1851784495793141,-0.5291846148296666,0.4893934247349483},
{-0.1638848892749894,-0.5466260209035353,0.5009859591007332},
{-0.1648250072894842,-0.5664864836429987,0.49738555509797977},
{-0.1810219405959642,-0.4975760586284948,0.4933087043956342},
{-0.1615680356869099,-0.5231418578715908,0.5044029987585331},
{0.1938446693580144,-0.33397222781667174,0.46305058150545136},
{0.20646073748538343,-0.329787162091075,0.43729916343775077},
{0.21994628326484728,-0.35891278470320526,0.4094120016472732},
{0.2234377207511325,-0.3823172894541454,0.37925983930069046},
{0.21847861701200283,-0.39986089860552915,0.3478346474444722},
{0.20722951504639717,-0.41473370086361605,0.3180777705300432},
{0.1693287061390984,-0.41776372151464963,0.500407309323626},
{0.18360782875573767,-0.37524198081588117,0.4844966949328315},
{0.16266897324984744,-0.3756545505920264,0.5031532655386253},
{0.17647540663297973,-0.3357961018543847,0.48595308878742055},
{-0.17559240210297863,-0.45942049352062553,0.4970526436028388},
{-0.1693287061390984,-0.41776372151464963,0.500407309323626},
{-0.16266897324984744,-0.3756545505920264,0.5031532655386253},
{-0.1560528269671838,-0.33613953425456383,0.505074082201334},
{-0.14991763634341437,-0.30226672899050416,0.5059510747855991},
{-0.14438514327969676,-0.27341615289580395,0.5061028764154374},
{-0.12911705558945624,-0.30167004337618847,0.520457148353779},
{-0.12486285248789344,-0.2722919190431387,0.5206916142374899},
{-0.12154876740082544,-0.24727170387560082,0.520525534236528},
{-0.11920936901623526,-0.22612693922824653,0.5202963288053363},
{0.19372142447042273,-0.10031194483438595,0.44665600548289447},
{0.22968713834388932,-0.08885693372731619,0.4386405788301356},
{0.22137637485684056,-0.07592749292844883,0.46820582497422386},
{0.18327341427416277,-0.08749748249772299,0.47943764259583793},
{0.21273720883395308,-0.05917971509389158,0.4965175804323191},
{0.25727069687469,-0.048321389601137486,0.4808504498438398},
{0.2641964583627668,-0.06430038987468101,0.4559038810115701},
{0.27112297134406066,-0.07705698723363326,0.4294099876454516},
{0.23644982580387228,-0.09706098517754781,0.4114816139669524},
{0.20130098505730887,-0.10829280279916194,0.4174958141827812},
{0.17509341060687586,-0.11969145191495502,0.4213314355624626},
{0.16703815481361464,-0.11242075504026502,0.4516211211677603},
{0.15502328125986334,-0.100652371261697,0.4862424136759742},
{0.17022974650630804,-0.07015151606241604,0.5126062987155479},
{0.20663884137781774,-0.039324512806947404,0.5186107295195553},
{0.25156009991853817,-0.03051325483736185,0.5010092553904608},
{0.29512265872288235,-0.02011860065951045,0.4858381103252163},
{0.3016478743262863,-0.03624639659002439,0.46706731275043506},
{0.30826402060895,-0.051437080478911615,0.4445721147920919},
{0.314215095394549,-0.06391637684078266,0.4207986268715938},
{0.2768335683002125,-0.08519866474685203,0.40460695401763314},
{0.13858887609680434,-0.0844268812129702,0.522383225469007},
{0.16145380871792253,-0.04780135629495809,0.537703166191222},
{0.11211527304754547,-0.059502105683994125,0.5593401588957259},
{0.12641092851495922,-0.016244653125760917,0.5581828593415115},
{0.16380823696685315,-0.01997281097540816,0.5462724433449264},
{0.20594897060459133,-0.0170735501441364,0.52951940505785},
{-0.25727069687469,-0.048321389601137486,0.4808504498438398},
{-0.2641964583627668,-0.06430038987468101,0.4559038810115701},
{-0.22137637485684056,-0.07592749292844883,0.46820582497422386},
{-0.21273720883395308,-0.05917971509389158,0.4965175804323191},
{-0.18327341427416277,-0.08749748249772299,0.47943764259583793},
{-0.19372142447042273,-0.10031194483438595,0.44665600548289447},
{-0.22968713834388932,-0.08885693372731619,0.4386405788301356},
{-0.27112297134406066,-0.07705698723363326,0.4294099876454516},
{-0.30826402060895,-0.051437080478911615,0.4445721147920919},
{-0.3016478743262863,-0.03624639659002439,0.46706731275043506},
{-0.29512265872288235,-0.02011860065951045,0.4858381103252163},
{-0.25156009991853817,-0.03051325483736185,0.5010092553904608},
{-0.20663884137781774,-0.039324512806947404,0.5186107295195553},
{-0.17022974650630804,-0.07015151606241604,0.5126062987155479},
{-0.15502328125986334,-0.100652371261697,0.4862424136759742},
{-0.16703815481361464,-0.11242075504026502,0.4516211211677603},
{-0.17509341060687586,-0.11969145191495502,0.4213314355624626},
{-0.20130098505730887,-0.10829280279916194,0.4174958141827812},
{-0.23644982580387228,-0.09706098517754781,0.4114816139669524},
{-0.2768335683002125,-0.08519866474685203,0.40460695401763314},
{-0.314215095394549,-0.06391637684078266,0.4207986268715938},
{-0.35010641143953036,-0.03616072636328385,0.4362500789067878},
{-0.34368490190007545,-0.021626096052857036,0.4566320779388646},
{-0.336231592173649,-0.006891568546702317,0.47403891532475023},
{-0.3280899146604303,0.005986019220190488,0.48672111485521735},
{-0.2894466304547135,-0.00482721667954227,0.49844065157467893},
{-0.24828058351945315,-0.012269254007713342,0.5131413618860675},
{-0.20594897060459133,-0.0170735501441364,0.52951940505785},
{-0.16145380871792253,-0.04780135629495809,0.537703166191222},
{-0.13858887609680434,-0.0844268812129702,0.522383225469007},
{-0.15344965446341882,-0.12618134733715897,0.4517015309419818},
{-0.1615342184921439,-0.13205201234853656,0.42166960751012267},
{-0.16583426267994505,-0.13407052312945825,0.3984033775111146},
{-0.17965121696811565,-0.12242012378596272,0.3981854444781782},
{-0.20573855250382508,-0.11113645313237404,0.3951929984879956},
{-0.2404432607591284,-0.09963560093906594,0.3903879508583555},
{-0.2801130846992975,-0.08733140249676107,0.38473521887991446},
{-0.3187450965067589,-0.071908507203814,0.3981914564239144},
{-0.35515193689861757,-0.04843561657012486,0.4146408914513137},
{-0.3896627599039291,-0.018290969155712412,0.42974515362024346},
{-0.3831773734410273,-0.004380078215414038,0.44851369671537344},
{-0.374645670948174,0.009139284758815761,0.4647850278503386},
{-0.3640962091676161,0.02002165803451455,0.47736427281007365},
{-0.35278849073108265,0.028985469127155664,0.4872358877088776},
{-0.31996627298442004,0.017338075756528196,0.49599829861935674},
{-0.28469644182991605,0.009437627565973569,0.5066792717128936},
{-0.2468760426968386,0.0055501531543176216,0.519711667082493},
{-0.20854913713548823,0.005333723107815213,0.5333362391071058},
{-0.1717605381893823,0.008446408012721245,0.5457967481385513},
{-0.16380823696685315,-0.01997281097540816,0.5462724433449264},
{-0.12641092851495922,-0.016244653125760917,0.5581828593415115},
{-0.11211527304754547,-0.059502105683994125,0.5593401588957259},
{0.35515193689861757,-0.04843561657012486,0.4146408914513137},
{0.3940762795675007,-0.03034717483639996,0.4096750242732309},
{0.3896627599039291,-0.018290969155712412,0.42974515362024346},
{0.35010641143953036,-0.03616072636328385,0.4362500789067878},
{0.3831773734410273,-0.004380078215414038,0.44851369671537344},
{0.4199171253280268,0.015572066696526,0.4416796173997734},
{0.42687144355835044,0.002351046529454009,0.42386547069026154},
{0.43113165860564945,-0.009379762588262903,0.40464152270561615},
{0.39639012718271205,-0.03830173053858016,0.3894996858758352},
{0.3584772943839409,-0.05639392973839019,0.3935532402884532},
{0.3187450965067589,-0.071908507203814,0.3981914564239144},
{0.34368490190007545,-0.021626096052857036,0.4566320779388646},
{0.374645670948174,0.009139284758815761,0.4647850278503386},
{0.41012441721701015,0.027944651021579867,0.45725130834969085},
{0.4424266016574934,0.04949672499256021,0.45061186577729956},
{0.45369824841960976,0.03831074845718439,0.4350972883118758},
{0.4616708399589986,0.02594417607786671,0.41741841038142796},
{0.46646085772429824,0.014734903252763241,0.3982771266506549},
{0.46818703764379827,0.007023831352898194,0.3783768347706894},
{0.43284055418115797,-0.017280210778817532,0.3848381734506464},
{0.336231592173649,-0.006891568546702317,0.47403891532475023},
{0.3280899146604303,0.005986019220190488,0.48672111485521735},
{0.3640962091676161,0.02002165803451455,0.47736427281007365},
{-0.4199171253280268,0.015572066696526,0.4416796173997734},
{-0.42687144355835044,0.002351046529454009,0.42386547069026154},
{-0.41012441721701015,0.027944651021579867,0.45725130834969085},
{-0.39735053551406646,0.03713015261324249,0.46975014353520445},
{-0.383269055613504,0.044113027585813,0.4799614333681024},
{-0.3695543044028484,0.04988073802645856,0.48867048826017295},
{-0.34198201827030306,0.036751400031863286,0.49538432866104953},
{-0.31256406479675114,0.027497512557451635,0.5031878342266083},
{-0.2809502481430603,0.022486555786347444,0.5123613119267986},
{-0.2467903724700981,0.022085258408457594,0.5231858202247865},
{-0.21232088159172277,0.025657105668964227,0.5341538637272261},
{-0.17977746782857537,0.03256633430626653,0.5437579470407701},
{-0.15139732648773113,0.04217567807232969,0.550488320292421},
{-0.13935389619173297,0.01590873565775196,0.5543555043872175},
{-0.0983095911576302,-0.0011666932194270107,0.5600330356418204},
{-0.0834097351437306,-0.029844425874212068,0.5621274472376612},
{-0.0710642045744895,-0.05125446762717522,0.5605831286766806},
{-0.08850110168905616,-0.07380828205644617,0.5613706935681199},
{-0.09849295550258365,-0.09813111151858744,0.5548041458377797},
{-0.45369824841960976,0.03831074845718439,0.4350972883118758},
{-0.4616708399589986,0.02594417607786671,0.41741841038142796},
{-0.4424266016574934,0.04949672499256021,0.45061186577729956},
{-0.42773716374436005,0.057162707299403884,0.4632602481130005},
{-0.4115116736956332,0.06245472253367437,0.4737435784904606},
{-0.3956303675403026,0.06651954934454757,0.48276525456081243},
{-0.38197348130735775,0.07050396638119942,0.4910271709887547},
{-0.3578813602628423,0.05541924303591233,0.4966633701164214},
{-0.33293779740344065,0.044038629757327794,0.5027948032741056},
{-0.30658969372142447,0.03679724111810166,0.5096093437660631},
{-0.27828395020906543,0.03413169467732382,0.5172918589236815},
{-0.2474667163654181,0.036476353514433166,0.5260294705579986},
{-0.21631131057411077,0.04270022033781123,0.5348046568531672},
{-0.18699029972555467,0.05167004337618849,0.5425991445001218},
{-0.1616770022033781,0.062254073844729425,0.5483961631762313},
{-0.14254473639120932,0.07331905997216469,0.5511766880792134},
{-0.1294153983966141,0.0538486222123359,0.5528389910752666},
{-0.11417361296896936,0.028742736818057474,0.5562778240363602},
{-0.3940762795675007,-0.03034717483639996,0.4096750242732309},
{-0.43113165860564945,-0.009379762588262903,0.40464152270561615},
{-0.46646085772429824,0.014734903252763241,0.3982771266506549},
{-0.4939985751688606,0.05266727487517695,0.4092113529583283},
{-0.48431483357431215,0.06391637684078266,0.42773566075792596},
{-0.47131174644017665,0.07376694992950988,0.44404156058087413},
{-0.4551433698759435,0.07997052643602834,0.4572746046394185},
{-0.4376215540278533,0.08374302238547993,0.4681509659693812},
{-0.42055890053536377,0.08629960230978954,0.47738756909980123},
{-0.4057672595447153,0.08885693372731619,0.4857005870665012},
{-0.39505697821571467,0.0926294296767677,0.49380769589173695},
{-0.3724212510257882,0.07555550378602281,0.4992319739322033},
{-0.34992304709457694,0.061715253208124515,0.5047246378554188},
{-0.3269145792690075,0.05156708880545644,0.510451767662345},
{-0.3027488118892239,0.04556942144040207,0.5165809463403783},
{-0.2767757033225018,0.044182164961779034,0.5232775023972634},
{-0.2483497208954192,0.04786297873875389,0.5307082673271791},
{-0.21956753068346807,0.055265186926422766,0.5381217479131033},
{-0.19252880473500847,0.06504061069344787,0.5447664509380138},
{-0.1693317121119665,0.07584182270170825,0.5498923861713224},
{-0.1520736703830511,0.08632289859951724,0.5527473089027899},
{-0.12838284671642552,0.08499275560538785,0.5519537320656143},
{-0.1127653146802697,0.06731087170207203,0.5523745682671468},
{-0.09454235566069781,0.04514482777278452,0.5541097661052511},
{-0.39639012718271205,-0.03830173053858016,0.3894996858758352},
{-0.43284055418115797,-0.017280210778817532,0.3848381734506464},
{-0.46818703764379827,0.007023831352898194,0.3783768347706894},
{-0.5002081636211151,0.042267360244806415,0.3893215819834011},
{-0.5229581177800289,0.0824166368574357,0.40153259526679513},
{-0.5111822190692907,0.09217703076012032,0.4212683101322328},
{-0.4963612698431784,0.10040738447294777,0.4386405788301356},
{-0.4790746713720162,0.1050425946355408,0.4525041256977614},
{-0.4608855295472103,0.10730308623234365,0.4636570365315883},
{-0.4433554472737329,0.1084077812613663,0.4728981486213106},
{-0.42804677894977317,0.10957785620026993,0.48102479627018896},
{-0.4165226304667374,0.11203148155384746,0.48883731975435185},
{-0.4079300570233053,0.1153553360527368,0.4958149342744032},
{-0.3874653937373561,0.0971534188432415,0.5011182219069291},
{-0.36597719668982265,0.08118869694082144,0.5067168463737446},
{-0.34476329466650235,0.068325387545052,0.5121493908395982},
{-0.32315936766354747,0.05900987762684456,0.5176089890612647},
{-0.3005010956771104,0.05368780266389315,0.5232895262887358},
{-0.27612265571690947,0.05280479813389201,0.5293841362787859},
{-0.24935897628588005,0.05680725100775241,0.53608595278819},
{-0.22222781667172672,0.06433345557622998,0.5427516976231773},
{-0.19674843914858825,0.07402471210294857,0.5487343351238911},
{-0.17493860300416927,0.08451931487866393,0.5533898356033438},
{-0.1588160675261745,0.09445856416699983,0.5560726663881131},
{-0.14716566818267898,0.10420693417821209,0.5573900339975533},
{-0.13950569782157146,0.09680322300410917,0.5540488951546723},
{-0.117982932086055,0.09739990861842478,0.551738805005546},
{-0.10038070646374346,0.08228662853089086,0.5506604122391192},
{-0.07878354289974179,0.06331142480107972,0.5503996440928124},
{-0.3584772943839409,-0.05639392973839019,0.3935532402884532},
{-0.3597390514953212,-0.05797657445343899,0.37473585013421673},
{-0.3965764975005336,-0.03990992602300774,0.37041250965668787},
{-0.43214091399611027,-0.019011651150836716,0.36528732591659624},
{-0.46696586116613714,0.0051488557764277285,0.3584186779130132},
{0.5002081636211151,0.042267360244806415,0.3893215819834011},
{0.531111067691503,0.07319356060492196,0.38057795840334746},
{0.5229581177800289,0.0824166368574357,0.40153259526679513},
{0.4939985751688606,0.05266727487517695,0.4092113529583283},
{0.5111822190692907,0.09217703076012032,0.4212683101322328},
{0.533714240195268,0.12287928614156331,0.4173695633223215},
{0.5476521848913791,0.11508780446747686,0.3966719371390953},
{0.5579093158105155,0.10749095953659919,0.37485082859642105},
{0.5350616675333889,0.06657140237652209,0.3595511781910657},
{0.5027880398351524,0.0349628461753504,0.36892229860733283},
{0.5793411508667723,0.1451362607501104,0.37494251076889784},
{0.5671834936017868,0.1505748171617003,0.3969184269142787},
{0.586295469097096,0.1409339106805222,0.3533618800556706},
{0.5634252760234586,0.10188331715117939,0.3533385837659429},
{0.5342305160353622,0.06461601702583028,0.33959527581304055},
{0.5631382056145561,0.10006019460668344,0.33356980319895635},
{0.5865419588722792,0.13940311899744787,0.33375316754390977},
{0.5831166527890919,0.14020270778035956,0.31321861538877754},
{0.5600706103026714,0.10117841651361255,0.3124761400903595},
{0.5572442443134508,0.10439480748246763,0.2869915021147019},
{0.5790540804578698,0.142992250601946,0.28886046574543617},
{0.5576801103793237,0.1088669436169669,0.25404679097366467},
{0.5773917774618166,0.14742981804846228,0.2577794577826141},
{0.5643999627259364,0.11375164952761131,0.21057591434179718},
{0.5406227173393533,0.07620329093909599,0.21089680194546567},
{0.5318137138494188,0.07312141725608784,0.25636289306852716},
{0.5112160362640567,0.041441469199298975,0.21612569174950627},
{0.5014120557547848,0.04060430575553622,0.2627844026079821},
{0.5171558386514004,0.12907159024982637,0.43551060958123783},
{0.4963612698431784,0.10040738447294777,0.4386405788301356},
{0.533278374129395,0.15941237739388162,0.435751087410685},
{0.5513277382158349,0.15581197339112815,0.4177137472157176},
{0.5806540095169102,0.18877396887615688,0.4045611129313947},
{0.594144815748893,0.18610767094216205,0.38365682611348756},
{0.6020911050256861,0.1837570001593166,0.36269542581108666},
{0.6026757667485293,0.18271317608087265,0.34311000958905347},
{0.48431483357431215,0.06391637684078266,0.42773566075792596},
{0.47131174644017665,0.07376694992950988,0.44404156058087413},
{0.4551433698759435,0.07997052643602834,0.4572746046394185},
{0.4790746713720162,0.1050425946355408,0.4525041256977614},
{-0.533714240195268,0.12287928614156331,0.4173695633223215},
{-0.5476521848913791,0.11508780446747686,0.3966719371390953},
{-0.5171558386514004,0.12907159024982637,0.43551060958123783},
{-0.4990380886822116,0.13186939949680013,0.44966047536454945},
{-0.480588178711099,0.13246007316537955,0.460737485383457},
{-0.4630325456682428,0.13202946755202588,0.46965846136272776},
{-0.4475983779770404,0.13176644492606804,0.477341728013563},
{-0.4355121125676719,0.13285535859753328,0.48470335556751265},
{-0.42606884880257073,0.1349309828629487,0.49126764881820173},
{-0.41856368604416977,0.13762583753919036,0.4965596640524722},
{-0.4014153623249397,0.11913534693435857,0.5014391095105976},
{-0.3820305947918514,0.10196372692540073,0.5070407399502813},
{-0.3616425838140385,0.08691883272061589,0.5128197227891821},
{-0.3414837782674174,0.07481002251473677,0.5182319769381761},
{-0.32091766339717015,0.06604385413817251,0.5235187317199276},
{-0.29930847594169613,0.06102688542133214,0.5289197134706661},
{-0.2760189496529604,0.060167177181058774,0.5346761515130564},
{-0.2504133212693622,0.06387053575454424,0.5410285236765453},
{-0.22442969179760183,0.07088873090831477,0.547341066699532},
{-0.20000541075116254,0.07997052643602834,0.5529772658271986},
{-0.17907857913674471,0.08986618911777704,0.5572998548115105},
{-0.16358654646783158,0.09932598573365273,0.5596738218840838},
{-0.1523945579867196,0.10866629492802196,0.5607056220710551},
{-0.14436785893570525,0.11820048937238291,0.5610039648782129},
{-0.13877224044175776,0.11412965061577351,0.5579476419645837},
{-0.13037806120761955,0.1076051865055866,0.554513317962792},
{-0.11013358543425786,0.11066676987173515,0.5515434167691202},
{-0.09119595636529786,0.09850084618136237,0.5492618833622407},
{-0.06709556889539516,0.08316211812872172,0.5474650630803406},
{-0.03829910031232058,0.06526230119246945,0.5456073718478618},
{-0.05439909099380469,0.04152037598708633,0.5500742475298418},
{-0.03414860327470685,0.016137941088943737,0.5497586203786924},
{0.0,0.0418299911924995,0.5435242326502762},
{0.0,-0.005626053969236879,0.546226602258688},
{-0.02495182928478888,-0.013612172386532043,0.5495241544949816},
{-0.05929506930270448,-0.006247538859714274,0.556810632727229},
{-0.04895602562291272,-0.03100848886737951,0.5555864502766997},
{-0.07560472659173778,0.0198811288029314,0.5559531789666067},
{-0.5513277382158349,0.15581197339112815,0.4177137472157176},
{-0.5671834936017868,0.1505748171617003,0.3969184269142787},
{-0.533278374129395,0.15941237739388162,0.435751087410685},
{-0.51454139374938,0.1599399256322312,0.44945381472986834},
{-0.4960170859497822,0.15853839078248474,0.4598657532517112},
{-0.47860423661816026,0.15635079402773308,0.4680299755614406},
{-0.4632046376149409,0.15452241103071798,0.4749910572307175},
{-0.45071707482768264,0.15419551148131336,0.4817905678583345},
{-0.44058318879613795,0.15501539058108463,0.4879400368532274},
{-0.4322438685668423,0.15662659203838022,0.49294798765146347},
{-0.4251400031863312,0.15867290806833176,0.49632519816876136},
{-0.41229172365490224,0.14057244244313447,0.500102954570732},
{-0.3961263530635373,0.12295668994291657,0.5051913151431895},
{-0.377787664088544,0.10659593111512576,0.5109853278464308},
{-0.3584201808994472,0.0922627009868609,0.5168792891475361},
{-0.33916692467933784,0.08072728010556979,0.5222689985000195},
{-0.31943571877320237,0.07234211879003583,0.5274347628738303},
{-0.2986321320463761,0.06745966735904238,0.5326576407321347},
{-0.2761624848574117,0.06643387911780708,0.5382194420313162},
{-0.2514338490580784,0.06961570139867915,0.544399722248107},
{-0.22630992782659143,0.07591096007767437,0.5505371673515275},
{-0.2026544243411659,0.08422472953759116,0.5559697118173811},
{-0.18232878730036584,0.09346133266801135,0.5600345386282543},
{-0.1671982228688404,0.10252584385173343,0.5620703337531675},
{-0.15622491891388188,0.11164446254708106,0.5627241328519769},
{-0.1483695603163486,0.12104489119881205,0.5626437230777556},
{-0.1383709430638679,0.12824569920431897,0.5611760568249111},
{-0.13241911678505192,0.12459344216959099,0.5583519453153416},
{-0.1234410273212874,0.11904967670761799,0.5548575018561882},
{-0.10362640566806243,0.12492034171899563,0.552380580212883},
{-0.0841439440167613,0.11567772664283935,0.5497435905143521},
{-0.05967908233660283,0.10461499499505512,0.5476243796423493},
{-0.030914927961860218,0.09261665429207837,0.5457629309437853},
{0.0,0.08638376955009602,0.5448964592645587},
{0.03829910031232058,0.06526230119246945,0.5456073718478618},
{0.03414860327470685,0.016137941088943737,0.5497586203786924},
{0.02495182928478888,-0.013612172386532043,0.5495241544949816},
{0.0,-0.03859330990678478,0.5470750381007061},
{-0.02213072374808745,-0.04273028006649215,0.5492333266199939},
{-0.04325519807858214,-0.05305354238872643,0.553392090082995},
{-0.531111067691503,0.07319356060492196,0.38057795840334746},
{-0.5579093158105155,0.10749095953659919,0.37485082859642105},
{-0.5793411508667723,0.1451362607501104,0.37494251076889784},
{-0.594144815748893,0.18610767094216205,0.38365682611348756},
{-0.5806540095169102,0.18877396887615688,0.4045611129313947},
{-0.563436548421714,0.19076317142161475,0.4239744372067298},
{-0.5443095430620642,0.19108405902528322,0.4404637013746313},
{-0.525090855529938,0.1887446606406931,0.45259580787023823},
{-0.506457581213872,0.18486319817477323,0.461516783849509},
{-0.48908531251596926,0.18055789353445292,0.46837415945483685},
{-0.4736511448247668,0.17694546564022712,0.47431396184218044},
{-0.4608306705423677,0.17514563938545893,0.4804837211539329},
{-0.4501722422453415,0.174743590514352,0.4862912607350806},
{-0.4412227095238238,0.1753290037304123,0.4911474099034782},
{-0.4335281704747333,0.17648705477784354,0.4944614949905462},
{-0.4266369776746395,0.1778059253737176,0.4956428423277051},
{-0.41871323319435716,0.1608003853657217,0.4975801918411885},
{-0.40654655801076744,0.14340482037809124,0.5014218251666062},
{-0.3912093329445609,0.12640529231583153,0.5065530208524337},
{-0.37377393881642823,0.11058711159073076,0.5123613119267986},
{-0.3553127564470603,0.09673483712136009,0.5182319769381761},
{-0.3368966636707137,0.08563453081272486,0.5235533004079106},
{-0.3179590346017537,0.0775792750194637,0.5286100982652531},
{-0.2979324918613284,0.07286064910978114,0.5336894409191063},
{-0.27624815508415224,0.07177173543831591,0.5390791502715896},
{-0.25234014987780723,0.07460336188005565,0.5450647937451717},
{-0.22800755100384465,0.08038309621217356,0.5509873117885238},
{-0.20505093621024975,0.08813474874575784,0.5561876448503176},
{-0.18527013175179083,0.09688363277833052,0.5600059818860075},
{-0.17046646686967004,0.10565581310063096,0.5617832633442651},
{-0.1671982228688404,0.10252584385173343,0.5620703337531675},
{-0.1596877996579203,0.11460609731536563,0.5621732883238997},
{-0.1519819882105744,0.12388854153202415,0.5618291044305034},
{-0.5350616675333889,0.06657140237652209,0.3595511781910657},
{-0.5634252760234586,0.10188331715117939,0.3533385837659429},
{-0.586295469097096,0.1409339106805222,0.3533618800556706},
{-0.6020911050256861,0.1837570001593166,0.36269542581108666},
{-0.6107430464332629,0.2269783810431327,0.3779950762164422},
{-0.6022977656603671,0.2272797298231586,0.3979960681874885},
{-0.6121821559438605,0.2672246002807579,0.39591518346955396},
{-0.6037767043114669,0.26552697710350465,0.4149617790549823},
{-0.5881215976144599,0.22692126755863903,0.4171659086605084},
{-0.589644122872147,0.26225347265015586,0.4322994790649019},
{-0.5985598383988987,0.29772620697325586,0.431553997793616},
{-0.5852779472812478,0.2920073435917167,0.44752773761464026},
{-0.5866223686465006,0.32075195914281673,0.44477576945390485},
{-0.5750809358194733,0.313418888331114,0.4604165977797884},
{-0.5027880398351524,0.0349628461753504,0.36892229860733283},
{0.6022977656603671,0.2272797298231586,0.3979960681874885},
{0.5881215976144599,0.22692126755863903,0.4171659086605084},
{0.6107430464332629,0.2269783810431327,0.3779950762164422},
{0.6114712433605575,0.22652297615361724,0.35829768750507257},
{0.6071494058694626,0.22638470140168518,0.3373971581532505},
{0.598806328174082,0.1830746443182604,0.3225904872982616},
{0.5933880620793517,0.18493834749647545,0.2988252658031509},
{0.5893284957209977,0.1884012282405139,0.2695042549545948},
{0.5895351563556788,0.1935609806685885,0.23231736460346708},
{0.5811642734112682,0.1531749836925972,0.21707783365547342},
{0.574903583420256,0.11951935996825695,0.16149814681772684},
{0.5533800661915226,0.07917995557172101,0.15935263368312838},
{0.5250450144436997,0.040792179059791794,0.16232028039714913},
{0.49070177442578405,0.0062963859188206635,0.16922199410228125},
{0.47756116403293347,0.010377745580468372,0.22434777903694644},
{0.6037767043114669,0.26552697710350465,0.4149617790549823},
{0.589644122872147,0.26225347265015586,0.4322994790649019},
{0.6121821559438605,0.2672246002807579,0.39591518346955396},
{0.6128584998391805,0.2673621235394729,0.37597431095586925},
{0.6081571582734895,0.2667256087846551,0.35444553327461664},
{0.6004288020296329,0.2661003664280926,0.33063447069326757},
{0.6004460863736244,0.22703850050049446,0.31378373828797823},
{0.5940268313138206,0.22895631119033516,0.28595068400912615},
{0.5905616960901311,0.23261157419793124,0.2523897484301307},
{0.5896944729176874,0.23860999305620267,0.21532309699372656},
{0.5928372175512744,0.20075051627584012,0.19066961051609552},
{0.5884454911909965,0.1604847582145724,0.17114130777855602},
{0.5973093536857736,0.1696184067742605,0.12435634605962048},
{0.5866915060224667,0.12664050969275947,0.11173126001364712},
{0.5673059869961614,0.08273226400858509,0.1064993642367384},
{0.5402492252104932,0.03925687841741538,0.10506852115152811},
{0.5051492315230363,3.795040745962894e-05,0.10867493710001776},
{0.5985598383988987,0.29772620697325586,0.431553997793616},
{0.5852779472812478,0.2920073435917167,0.44752773761464026},
{0.6063400476747297,0.3011207018345452,0.41310934827502244},
{0.6067699017948665,0.3017624770418822,0.3927964866189118},
{0.6018393547979836,0.3006878417415404,0.37054176649001563},
{0.5935368577363221,0.2989300991069254,0.34627529901915105},
{0.5838531161417737,0.2975255582843109,0.3199241893642668},
{0.5920233503972394,0.2662724583747907,0.3038474949725104},
{0.5852922256523713,0.2680271950365376,0.2733917293662508},
{0.5806307132271824,0.27235579596658555,0.24034406365448147},
{0.5784348500470435,0.28025098370462104,0.20578289060362942},
{0.5910719599844891,0.24755877428450332,0.1769721436494314},
{0.5980661073553151,0.21030274655740952,0.14796675995202468},
{0.6040517508288971,0.22254908002200374,0.10761458017079938},
{0.6058297837803716,0.18083294005188305,0.08110941440642556},
{0.5972635125995353,0.13558478196175797,0.06619678300783659},
{0.5797048735838111,0.08840754078353684,0.058182859341511586},
{0.5545020455645367,0.04090565453556216,0.05237231378749576},
{0.5188887820098536,-0.008934127110568717,0.04069561218140445},
{0.570202241854565,0.22539874230095194,0.43436909138458124},
{0.5717841350763968,0.25738605108350293,0.44711441634527804},
{0.5683445506220861,0.28439020834397954,0.46042787017804376},
{0.5750809358194733,0.313418888331114,0.4604165977797884},
{0.5866223686465006,0.32075195914281673,0.44477576945390485},
{0.5931468327566876,0.32529248116006504,0.42623342581709867},
{0.5931355603584322,0.3262558954642875,0.40542082117166817},
{0.5882050133615494,0.3248626270399283,0.38249351461353703},
{0.5521987188543636,0.2509066765663373,0.4585927237420755},
{0.5505243919668381,0.22220790210147562,0.44847086160200317},
{0.549607570242071,0.27530240087052976,0.46965320091020857},
{0.5600420535604246,0.30407857913674474,0.4725254079856675},
{0.5589614063143467,0.32946928046027457,0.4717416005603134},
{0.5683558230203415,0.33774021480682115,0.45572051666661656},
{0.5733727917371818,0.3429488142940022,0.4366138016238265},
{0.5728963450375897,0.3440467458840716,0.41524283751814856},
{0.563436548421714,0.19076317142161475,0.4239744372067298},
{0.5443095430620642,0.19108405902528322,0.4404637013746313},
{0.525090855529938,0.1887446606406931,0.45259580787023823},
{0.51454139374938,0.1599399256322312,0.44945381472986834},
{0.4990380886822116,0.13186939949680013,0.44966047536454945},
{-0.570202241854565,0.22539874230095194,0.43436909138458124},
{-0.5717841350763968,0.25738605108350293,0.44711441634527804},
{-0.5521987188543636,0.2509066765663373,0.4585927237420755},
{-0.5505243919668381,0.22220790210147562,0.44847086160200317},
{-0.5683445506220861,0.28439020834397954,0.46042787017804376},
{-0.549607570242071,0.27530240087052976,0.46965320091020857},
{-0.5309164309482943,0.26517152081185313,0.47460103225108297},
{-0.5328883491497606,0.24279956774110156,0.4659205341012592},
{-0.531077250496737,0.21684449501158803,0.45833496156863685},
{-0.6063400476747297,0.3011207018345452,0.41310934827502244},
{-0.5931468327566876,0.32529248116006504,0.42623342581709867},
{0.5441494750068386,0.3518269551599027,0.4654846680353863},
{0.536827676593391,0.3431404450643429,0.482278286956182},
{0.5477844476975751,0.35729632279339046,0.44557836420968466},
{0.5143925980924097,0.36614891288991225,0.4751623976841985},
{0.5085873129909129,0.35741430722846296,0.4928014464741442},
{0.5171505781988812,0.3715438826949148,0.4544534991027172},
{0.5463047575532584,0.3191865987717595,0.4838549197254946},
{0.5265592732759994,0.3324481995725507,0.4948627923684361},
{0.5002307084176258,0.3465980653558621,0.5059969158718374},
{0.47414938482765256,0.37527128905134505,0.5040881231006009},
{0.4667479281332007,0.3643716314316547,0.5177051801930436},
{0.48981876989578294,0.3349589384106219,0.5133758277697785},
{0.4577578147779638,0.3523312071085246,0.525123921231487},
{0.42903874999624253,0.384702528924974,0.5295329319357565},
{0.42107217040258993,0.37194518007280464,0.5369201102590848},
{0.3900339975531381,0.40652363746764825,0.5410285236765453},
{0.3829361441183632,0.3926721144914946,0.5482984690580183},
{0.352663742857057,0.42876933967794,0.551738805005546},
{0.3591340994556183,0.4413974316967815,0.5378489558753243},
{0.39687408881447434,0.41815675246715217,0.5270793065821788},
{0.3650363271821109,0.45038453907915027,0.5189774582094623},
{0.40267110749058377,0.426636601928031,0.5082559044822061},
{0.3694738946286271,0.45485141476113033,0.4969782457743537},
{0.4066382401832441,0.43102832828830884,0.4863656585635659},
{0.5315010926711375,0.3079405027790219,0.4912390920759549},
{0.5140829828869965,0.32095786828428086,0.5021440101481645},
{0.5430252411541734,0.29351784495793143,0.48047169726246053},
{-0.536827676593391,0.3431404450643429,0.482278286956182},
{-0.5589614063143467,0.32946928046027457,0.4717416005603134},
{-0.5463047575532584,0.3191865987717595,0.4838549197254946},
{-0.5265592732759994,0.3324481995725507,0.4948627923684361},
{-0.5085873129909129,0.35741430722846296,0.4928014464741442},
{-0.5002307084176258,0.3465980653558621,0.5059969158718374},
{-0.5140829828869965,0.32095786828428086,0.5021440101481645},
{-0.48981876989578294,0.3349589384106219,0.5133758277697785},
{-0.4667479281332007,0.3643716314316547,0.5177051801930436},
{-0.4577578147779638,0.3523312071085246,0.525123921231487},
{-0.42903874999624253,0.384702528924974,0.5295329319357565},
{-0.42107217040258993,0.37194518007280464,0.5369201102590848},
{-0.3900339975531381,0.40652363746764825,0.5410285236765453},
{-0.3829361441183632,0.3926721144914946,0.5482984690580183},
{-0.352663742857057,0.42876933967794,0.551738805005546},
{-0.3465232917807684,0.41338101307297603,0.5587908173540825},
{-0.3150064177520734,0.43294388449849863,0.5679297263662899},
{-0.3198573064679518,0.45037326668089506,0.5612098740196771},
{-0.28734545541991935,0.45025603373903955,0.5758076297603338},
{-0.2906339897376086,0.46988428507444296,0.569489074791611},
{-0.26249958667873063,0.46421351725879323,0.5825154582154742},
{-0.2640130940178134,0.4858520129497311,0.5766214969143688},
{-0.23942874491614838,0.47371389450838824,0.5881456453974048},
{-0.23901542364678616,0.4968253169046896,0.5826529814741893},
{-0.2170906090401628,0.4776532219520187,0.592789873478602},
{-0.21466027997631293,0.5013553180168996,0.5876301210505274},
{-0.19548142158468879,0.47566627388621185,0.5964481424590662},
{-0.1910957071701471,0.4991248861487777,0.5915288678604388},
{-0.16847125237847602,0.4898191456423915,0.5943266771074125},
{-0.1745944191107731,0.4673900790871462,0.5991197008455802},
{-0.14693646275148722,0.4731232208398088,0.5960010039949379},
{-0.15442434116589665,0.4524601633445656,0.600805300131361},
{-0.126640133946151,0.4487222360830972,0.5965278007400705},
{-0.13496517580432318,0.43051280394143165,0.6015049403164088},
{-0.10742144641402467,0.4199054771831629,0.5960633779319507},
{-0.11618235433806974,0.40438563926522003,0.6012952737088595},
{-0.08912033209988247,0.3899659874169976,0.5947625431732854},
{-0.0980420595723703,0.37691630770340667,0.6002552070965008},
{-0.07157597145528165,0.36219305259550727,0.5927786010803467},
{-0.08050897132602482,0.3509439506299016,0.5984606412942517},
{-0.5315010926711375,0.3079405027790219,0.4912390920759549},
{-0.5156656276020453,0.29678007701302483,0.49307423851192317},
{-0.5255500178855386,0.28252124471324525,0.4836249628010857},
{-0.5430252411541734,0.29351784495793143,0.48047169726246053},
{-0.5600420535604246,0.30407857913674474,0.4725254079856675},
{-0.5441494750068386,0.3518269551599027,0.4654846680353863},
{-0.5683558230203415,0.33774021480682115,0.45572051666661656},
{-0.5143925980924097,0.36614891288991225,0.4751623976841985},
{-0.47947596874990606,0.38384206919148356,0.48585013421668866},
{-0.47414938482765256,0.37527128905134505,0.5040881231006009},
{-0.4360622056025323,0.39581636211151555,0.5156693850681304},
{-0.39687408881447434,0.41815675246715217,0.5270793065821788},
{-0.3591340994556183,0.4413974316967815,0.5378489558753243},
{-0.32538979953166947,0.46464412287214696,0.5475131586462301},
{-0.2947822322955713,0.48607971539448885,0.5560756723609813},
{-0.26645018652061647,0.5038893531446986,0.5635440119517482},
{-0.23953470545974853,0.5162559255240163,0.5699219348846157},
{-0.21317532937947703,0.5213645764133333,0.5752169560917544},
{-0.18768543095130025,0.5189883548611091,0.5793824829937085},
{-0.16337988583315047,0.5089003099158027,0.5823719230110229},
{-0.140572066696526,0.49087424211909064,0.5841409380438932},
{-0.11957684919935914,0.46468395201264917,0.5846429355128642},
{-0.5477844476975751,0.35729632279339046,0.44557836420968466},
{-0.5733727917371818,0.3429488142940022,0.4366138016238265},
{-0.5171505781988812,0.3715438826949148,0.4544534991027172},
{-0.48223920930889674,0.388899618542043,0.4645670948174022},
{-0.44481484710119007,0.4088863321419661,0.475383336690003},
{-0.44152631278350085,0.4042308316625135,0.4970473831503197},
{-0.40267110749058377,0.426636601928031,0.5082559044822061},
{-0.3650363271821109,0.45038453907915027,0.5189774582094623},
{-0.330750952141906,0.47479754772733423,0.528713052835985},
{-0.2990965548544959,0.4977316177244185,0.5374393920720473},
{-0.2693569622840584,0.5170419874290215,0.5451339311211377},
{-0.2408160013947714,0.5305838951997619,0.551772622200312},
{-0.21275674765759564,0.5362140823816924,0.5573344234994935},
{-0.18564287238743382,0.5338002861686171,0.5617494461494991},
{-0.15994030137883974,0.523210995247557,0.5649485527743626},
{-0.1361119544534991,0.5043131953190991,0.5668633574913353},
{-0.5728963450375897,0.3440467458840716,0.41524283751814856},
{-0.5469931253400507,0.3583401468718343,0.42365354960306134},
{-0.516365267787093,0.3723412169981754,0.4320469773439825},
{-0.4819528903932113,0.3892550748336945,0.4418171406584885},
{-0.4453100811312077,0.40872551259352324,0.4523951591812933},
{-0.4079916794671011,0.43039782547922717,0.4632144070267622},
{-0.4066382401832441,0.43102832828830884,0.4863656585635659},
{-0.3694738946286271,0.45485141476113033,0.4969782457743537},
{-0.33508481352447317,0.4798776418744045,0.5066852836586297},
{-0.3028833291750709,0.5037285335962557,0.5154514520351939},
{-0.2722810223914919,0.5240248624015921,0.5232436852024974},
{-0.24269097697124184,0.5383874007653208,0.530025911486123},
{-0.21352477372539236,0.5444361696691327,0.5357650651845216},
{-0.18535955944461646,0.5421050377099298,0.5403694641252168},
{-0.15877022643993616,0.531329376471048,0.5437459231492977},
{0.44152631278350085,0.4042308316625135,0.4970473831503197},
{0.4360622056025323,0.39581636211151555,0.5156693850681304},
{0.47947596874990606,0.38384206919148356,0.48585013421668866},
{0.48223920930889674,0.388899618542043,0.4645670948174022},
{0.44481484710119007,0.4088863321419661,0.475383336690003},
{0.2990965548544959,0.4977316177244185,0.5374393920720473},
{0.2947822322955713,0.48607971539448885,0.5560756723609813},
{0.32538979953166947,0.46464412287214696,0.5475131586462301},
{0.330750952141906,0.47479754772733423,0.528713052835985},
{0.3198573064679518,0.45037326668089506,0.5612098740196771},
{0.2906339897376086,0.46988428507444296,0.569489074791611},
{0.3028833291750709,0.5037285335962557,0.5154514520351939},
{0.33508481352447317,0.4798776418744045,0.5066852836586297},
{0.2693569622840584,0.5170419874290215,0.5451339311211377},
{0.26645018652061647,0.5038893531446986,0.5635440119517482},
{0.2722810223914919,0.5240248624015921,0.5232436852024974},
{0.27476921643305247,0.5235551791409531,0.4997249534825699},
{0.3054489270179847,0.5029605075284591,0.491984573347241},
{0.3375391903712677,0.4789254999684373,0.48330407519741725},
{0.23953470545974853,0.5162559255240163,0.5699219348846157},
{0.2408160013947714,0.5305838951997619,0.551772622200312},
{0.24269097697124184,0.5383874007653208,0.530025911486123},
{0.2640130940178134,0.4858520129497311,0.5766214969143688},
{0.23901542364678616,0.4968253169046896,0.5826529814741893},
{0.21466027997631293,0.5013553180168996,0.5876301210505274},
{0.21317532937947703,0.5213645764133333,0.5752169560917544},
{0.21275674765759564,0.5362140823816924,0.5573344234994935},
{0.21352477372539236,0.5444361696691327,0.5357650651845216},
{0.21560039799080774,0.5445624205295924,0.5122921745508325},
{0.24498979472211285,0.5382438655608694,0.5065019193136763},
{0.26249958667873063,0.46421351725879323,0.5825154582154742},
{0.28734545541991935,0.45025603373903955,0.5758076297603338},
{0.23942874491614838,0.47371389450838824,0.5881456453974048},
{0.2170906090401628,0.4776532219520187,0.592789873478602},
{0.19548142158468879,0.47566627388621185,0.5964481424590662},
{0.1910957071701471,0.4991248861487777,0.5915288678604388},
{0.18768543095130025,0.5189883548611091,0.5793824829937085},
{0.18564287238743382,0.5338002861686171,0.5617494461494991},
{0.18535955944461646,0.5421050377099298,0.5403694641252168},
{0.18722551710248264,0.5424462156304578,0.5169822437182682},
{0.3150064177520734,0.43294388449849863,0.5679297263662899},
{0.3465232917807684,0.41338101307297603,0.5587908173540825},
{0.15994030137883974,0.523210995247557,0.5649485527743626},
{0.16337988583315047,0.5089003099158027,0.5823719230110229},
{0.15877022643993616,0.531329376471048,0.5437459231492977},
{0.16049039441370003,0.53183362841967,0.520457148353779},
{0.1361119544534991,0.5043131953190991,0.5668633574913353},
{0.140572066696526,0.49087424211909064,0.5841409380438932},
{0.13433467299524154,0.5120423030561726,0.5458042630707216},
{0.1360202722810224,0.512661533466999,0.5226011585019433},
{0.16847125237847602,0.4898191456423915,0.5943266771074125},
{0.14693646275148722,0.4731232208398088,0.5960010039949379},
{0.11957684919935914,0.46468395201264917,0.5846429355128642},
{0.11462300591274863,0.47697612656348165,0.5674254744176679},
{0.11262779142155463,0.4841776860622057,0.5464520502237947},
{0.1745944191107731,0.4673900790871462,0.5991197008455802},
{0.15442434116589665,0.4524601633445656,0.600805300131361},
{0.126640133946151,0.4487222360830972,0.5965278007400705},
{0.10012144130387078,0.43394261898392106,0.5841011089033912},
{0.09510071512094531,0.44502413796213075,0.5669152105233098},
{-0.13433467299524154,0.5120423030561726,0.5458042630707216},
{-0.11262779142155463,0.4841776860622057,0.5464520502237947},
{-0.11462300591274863,0.47697612656348165,0.5674254744176679},
{-0.09510071512094531,0.44502413796213075,0.5669152105233098},
{-0.10012144130387078,0.43394261898392106,0.5841011089033912},
{-0.08193680843836704,0.4022641739135663,0.5827394031941467},
{-0.06475091005828582,0.3732610446958106,0.580781011870587},
{-0.048292457112282104,0.35054866519774797,0.578450631404601},
{-0.05462829642499646,0.33987821300924936,0.5902671107490584},
{-0.06354927240426728,0.3293062064321807,0.5959889801034656},
{0.09317689248536842,0.4516778589056456,0.5460139296782708},
{0.09516910100369434,0.4524316066023188,0.5229047617616204},
{0.11443964156779521,0.484865302355781,0.5233007986869911},
{0.12053575454427949,0.4810965638724146,0.5003952854321536},
{0.14087642144942,0.507690405836397,0.5000375746608511},
{0.14861078963901272,0.4986484394491856,0.480896290930078},
{0.1313948315302506,0.47492755605387904,0.4801620820570473},
{0.11561798293208604,0.4460078425832128,0.4773003958866267},
{0.10225643353343093,0.44972773400747285,0.4993980539331652},
{0.09807061631461715,0.4145939231252499,0.47421777071040166},
{0.08474739307003015,0.41725045164742336,0.4977913614351718},
{0.07852653221952019,0.38588763372821794,0.47197982391010934},
{0.06746304907851902,0.3879572460478971,0.49611402857477815},
{0.05675953118847149,0.36508780446747685,0.47164916689461955},
{0.049857817483339395,0.36613914347809096,0.4949018700157212},
{0.06124444270766012,0.38958723483561836,0.5202271914293702},
{0.0454315224350785,0.3671468958821178,0.5186452982075384},
{0.03252162045985373,0.35124980836922964,0.4939722729062648},
{0.030049207775850618,0.3516263064709578,0.5172347454391878},
{0.04363169618031028,0.3657821842000054,0.5414185486561798},
{0.028738603605363858,0.3499151564157982,0.5398186195971396},
{0.07717234144244614,0.4122800755100385,0.5656136242714274},
{0.08193680843836704,0.4022641739135663,0.5827394031941467},
{0.06046514424160808,0.3825697911750648,0.5638017741251868},
{0.06475091005828582,0.3732610446958106,0.580781011870587},
{0.07550928695317596,0.41848365201655685,0.5448122920242523},
{0.0776307523048297,0.41934411175004743,0.5217639950581807},
{0.05915153409825323,0.3885381503046554,0.5431725338247096},
{0.10742144641402467,0.4199054771831629,0.5960633779319507},
{0.08912033209988247,0.3899659874169976,0.5947625431732854},
{0.07157597145528165,0.36219305259550727,0.5927786010803467},
{0.048292457112282104,0.35054866519774797,0.578450631404601},
{0.0446063828827881,0.359716130952202,0.5617607185477543},
{0.11618235433806974,0.40438563926522003,0.6012952737088595},
{0.0980420595723703,0.37691630770340667,0.6002552070965008},
{0.08050897132602482,0.3509439506299016,0.5984606412942517},
{0.05462829642499646,0.33987821300924936,0.5902671107490584},
{0.03219772688331715,0.3339414165947738,0.5762141875907428},
{0.029384136278785947,0.34357631113021575,0.5598459138307817},
{0.13496517580432318,0.43051280394143165,0.6015049403164088},
{-0.07717234144244614,0.4122800755100385,0.5656136242714274},
{-0.06046514424160808,0.3825697911750648,0.5638017741251868},
{-0.0446063828827881,0.359716130952202,0.5617607185477543},
{-0.029384136278785947,0.34357631113021575,0.5598459138307817},
{-0.03219772688331715,0.3339414165947738,0.5762141875907428},
{-0.0373935509858088,0.3223406158036018,0.5878240063005191},
{-0.07550928695317596,0.41848365201655685,0.5448122920242523},
{-0.09317689248536842,0.4516778589056456,0.5460139296782708},
{-0.05915153409825323,0.3885381503046554,0.5431725338247096},
{-0.04363169618031028,0.3657821842000054,0.5414185486561798},
{-0.028738603605363858,0.3499151564157982,0.5398186195971396},
{-0.09516910100369434,0.4524316066023188,0.5229047617616204},
{-0.0776307523048297,0.41934411175004743,0.5217639950581807},
{-0.06124444270766012,0.38958723483561836,0.5202271914293702},
{-0.0454315224350785,0.3671468958821178,0.5186452982075384},
{-0.030049207775850618,0.3516263064709578,0.5172347454391878},
{0.014585731849184328,0.3340075479978718,0.5584120647727033},
{0.016099239188267087,0.3232574375283689,0.5745398607032174},
{0.014264844245515839,0.34063496667879073,0.5386432842057167},
{0.014952460539091175,0.3426301811699848,0.5162142176504715},
{0.01604588316985851,0.34274515963218916,0.49314262439467227},
{0.016940160098114953,0.3437311187329223,0.4714477667124577},
{0.03536527079306582,0.3513257091841489,0.4719106865341433},
{0.03660824057402058,0.35448047770920815,0.4532278136657538},
{0.06127299944990696,0.36667646112826185,0.45154522035284117},
{0.0,0.3308655548575018,0.5578161306516048},
{0.0,0.31939626537930865,0.5738432264910377},
{0.0,0.3376425206886083,0.5381615770536056},
{0.0,0.33976398604026203,0.5158016478743263},
{0.0,0.34008863111001564,0.4927525994150378},
{0.0,0.34147588758863867,0.4710344454430954},
{0.0,0.34678518716690065,0.45266494524620426},
{0.017031842270591666,0.34834077812613656,0.4531466523983154},
{0.015717480634019797,0.3593261059725675,0.44025779223316736},
{0.03428011458768573,0.3633428372175513,0.44010148164402674},
{0.06127299944990696,0.36667646112826185,0.45154522035284117},
{0.05853305518064394,0.3735886957384323,0.4372488133922103},
{0.09854556002777519,0.3859958487514691,0.4467634690129287},
{0.09390734389231403,0.38653767536094225,0.4305379789642019},
{0.1458340222021156,0.3986630184175958,0.4188101758193531},
{0.15441457175407536,0.4034778354590571,0.4298962037568648},
{0.0373935509858088,0.3223406158036018,0.5878240063005191},
{0.018989482100934558,0.3088971536442912,0.5860452218558275},
{0.0,0.30319933207282873,0.5853215338878351},
{-0.018989482100934558,0.3088971536442912,0.5860452218558275},
{-0.016099239188267087,0.3232574375283689,0.5745398607032174},
{-0.014585731849184328,0.3340075479978718,0.5584120647727033},
{-0.014264844245515839,0.34063496667879073,0.5386432842057167},
{-0.014952460539091175,0.3426301811699848,0.5162142176504715},
{-0.01604588316985851,0.34274515963218916,0.49314262439467227},
{-0.016940160098114953,0.3437311187329223,0.4714477667124577},
{-0.017031842270591666,0.34834077812613656,0.4531466523983154},
{-0.015717480634019797,0.3593261059725675,0.44025779223316736},
{0.0,0.3588752100423542,0.4396611066188517},
{0.04602820804939414,0.31087658677792773,0.5934541934824497},
{0.026809520517267812,0.2945308578144773,0.5914672454166429},
{0.0,0.27700753897995317,0.5906992193488461},
{-0.026809520517267812,0.2945308578144773,0.5914672454166429},
{-0.04602820804939414,0.31087658677792773,0.5934541934824497},
{0.06354927240426728,0.3293062064321807,0.5959889801034656},
{0.14472932717309295,0.35965901746770834,0.5801933441748754},
{0.13523345888280014,0.37378633845450904,0.5902009793459605},
{0.11853302512091526,0.35319166684201514,0.5903820892112628},
{0.1290712145032179,0.34258434008374633,0.5810477919626297},
{0.10268027570783146,0.33236177785259313,0.5897515864021811},
{0.09111554659107647,0.34109412903439135,0.5964939835453045},
{0.10801813202834032,0.36464667794908484,0.5977895578514508},
{0.12558503746945182,0.38885377745580463,0.5982885493475536},
{0.1525155483946602,0.39256840842754553,0.5892924240465806},
{0.16106378373828797,0.37473772886725926,0.578685848781529},
{0.16901007301508095,0.35893608099293295,0.5694665299951002},
{0.15367585392174252,0.34694750970177746,0.5714241698254432},
{0.13911642433515395,0.33286076934869585,0.5728031598786789},
{0.12581424290064358,0.3171282588503356,0.5734284022352415},
{0.11448548265403358,0.32446659011455764,0.5811049054471233},
{0.10136741705769364,0.3062579094661092,0.5802219009171223},
{0.08793973625594055,0.31287405574877275,0.588226055171626},
{0.0749930111130817,0.32043032004593125,0.5943950629901615},
{0.08050897132602482,0.3509439506299016,0.5984606412942517},
{0.1437027874386406,0.41147748075425866,0.5979962184861319},
{0.17011401655088662,0.4079627469782457,0.5877390875669957},
{0.17767929876664934,0.38686983536286595,0.5766673380006073},
{0.18463361699697298,0.368373332812298,0.5671038353207825},
{0.1906598411042742,0.35384471444760734,0.5624483348413296},
{0.17601624427737916,0.3461163582037508,0.5649252564846351},
{0.1616770022033781,0.3361290133495255,0.5670527337820248},
{0.14815237877662918,0.3240540203384124,0.5686639352393206},
{0.13595113490505636,0.31006422261032673,0.5695927808555601},
{0.12558503746945182,0.29433171211196646,0.5696724391365644},
{0.11425627722284179,0.30020312861656107,0.5731240474823475},
{0.1046123647687956,0.28239499385278544,0.5720666965259971},
{0.09008374640410495,0.2878643614862732,0.578519768780567},
{0.0745774353640684,0.2941558626991833,0.585957297149436},
{0.05915754604398941,0.301654262018631,0.5918835726588731},
{0.04311542034021601,0.2837619600145489,0.5893472830514233},
{0.03066242624094075,0.26444182089812457,0.5856424214915036},
{0.0,0.24448892449296752,0.5821104033714992},
{-0.03066242624094075,0.26444182089812457,0.5856424214915036},
{-0.04311542034021601,0.2837619600145489,0.5893472830514233},
{-0.05915754604398941,0.301654262018631,0.5918835726588731},
{-0.0749930111130817,0.32043032004593125,0.5943950629901615},
{-0.09111554659107647,0.34109412903439135,0.5964939835453045},
{-0.08050897132602482,0.3509439506299016,0.5984606412942517},
{-0.10801813202834032,0.36464667794908484,0.5977895578514508},
{-0.12558503746945182,0.38885377745580463,0.5982885493475536},
{-0.1437027874386406,0.41147748075425866,0.5979962184861319},
{-0.16225640347370224,0.43028359851023984,0.596917825719705},
{-0.1811309071124324,0.4430341839234559,0.5950601344872261},
{-0.2004525492152908,0.450069663421218,0.5923998484989674},
{-0.22034758064273713,0.451726705964752,0.5889144229584184},
{-0.24094225225523117,0.448343483501718,0.5845798100826343},
{-0.2623620634200156,0.4402596709662098,0.5793734650751043},
{-0.2856110090750321,0.42830491686982025,0.5731586161703305},
{-0.3116923326650054,0.413312627190227,0.5657969886163807},
{-0.3416100291278771,0.39611169894580534,0.5571510591545401},
{-0.3763658389219379,0.3775355381142329,0.5470833045260933},
{-0.4127786912595327,0.35860392099100913,0.536115261023654},
{-0.4476667638597894,0.34033737536485,0.5247684649398355},
{-0.4778474829486189,0.3237556775312546,0.5135652040604681},
{-0.500139026245149,0.3098808582653733,0.5030270146781656},
{-0.4995987026221101,0.28619078609196474,0.4915674946117936},
{-0.5082867157041041,0.27178841858773384,0.48386018017801363},
{0.16225640347370224,0.43028359851023984,0.596917825719705},
{0.1811309071124324,0.4430341839234559,0.5950601344872261},
{0.18776433773908757,0.41839196984408017,0.5856228826678611},
{-0.1525155483946602,0.39256840842754553,0.5892924240465806},
{-0.13523345888280014,0.37378633845450904,0.5902009793459605},
{-0.17011401655088662,0.4079627469782457,0.5877390875669957},
{-0.18776433773908757,0.41839196984408017,0.5856228826678611},
{-0.20568143901933142,0.42412135413065766,0.5829099921544107},
{-0.2240802474516865,0.4254154254503699,0.5795628413657938},
{-0.24317493860300418,0.4225402124020428,0.575546861614027},
{-0.2631819425197868,0.41576024059806843,0.5708252297314764},
{-0.28500229956924406,0.40570150388822596,0.5651995515088482},
{-0.3095370501185856,0.3929869901494269,0.5584699297504141},
{-0.3376879860282381,0.37824344472466787,0.5504372187536636},
{-0.3703568991586282,0.3620953584772944,0.5409022728160856},
{-0.40451376885872226,0.3453468291495201,0.5304820678688555},
{-0.43712857447748676,0.3288012029903418,0.5197920768567142},
{-0.46517129536388807,0.31326408072840733,0.5094485242176204},
{-0.4856104078804585,0.29953805711949644,0.5000691373759661},
{-0.4841029124871119,0.2766558401543867,0.48892900192682853},
{-0.4919064180526707,0.26201825527322786,0.48305157347649785},
{-0.5128242317484842,0.25489710554872536,0.47686302683431986},
{-0.5143640413501628,0.2340852523965119,0.4704896128607544},
{-0.512407153013037,0.2103929257434522,0.4652163849569094},
{-0.16106378373828797,0.37473772886725926,0.578685848781529},
{-0.14472932717309295,0.35965901746770834,0.5801933441748754},
{-0.17767929876664934,0.38686983536286595,0.5766673380006073},
{-0.1941798353328063,0.3951031950485614,0.5742820985297787},
{-0.210841191447406,0.39960914837782674,0.5715015736267965},
{-0.2279384136278786,0.40056129028379384,0.5682964550561967},
{-0.24574654839165422,0.398130209726727,0.5646389375689495},
{-0.26454064225616297,0.3924887501465413,0.560498961436374},
{-0.28508947278241864,0.3841118552563945,0.5555856987834827},
{-0.30816106603821797,0.3734767232490959,0.54960531576242},
{-0.33452344809135753,0.3610575463445867,0.542266984498198},
{-0.36494464500963414,0.34733152273567575,0.5332768711429612},
{-0.39663361098502725,0.33284348500470434,0.5233864689137315},
{-0.42679704572986527,0.31813751424079645,0.5133472710275317},
{-0.45264315194291055,0.3037576915330762,0.5039100192081666},
{-0.47138013232292564,0.2902496009571017,0.4958262066726586},
{-0.4699785974731792,0.26866070381848733,0.4873666475286394},
{-0.4770794568808222,0.2539111464479921,0.48307486976622543},
{-0.4958848231435863,0.2453801954483559,0.47802934430713834},
{-0.4971353078567113,0.22578275533485034,0.47369473143135415},
{-0.49506494404381507,0.20393835050244835,0.47036937394603073},
{-0.16901007301508095,0.35893608099293295,0.5694665299951002},
{-0.15367585392174252,0.34694750970177746,0.5714241698254432},
{-0.18463361699697298,0.368373332812298,0.5671038353207825},
{-0.20006252423565626,0.3748068662432253,0.5645126867084898},
{-0.2156056584433269,0.37832084852602127,0.5617005990903927},
{-0.2315733863186151,0.3790032043670774,0.5586758388918782},
{-0.248275323066934,0.3769396039931344,0.5554481755247677},
{-0.26602033240047973,0.37221496613771565,0.5520251239212316},
{-0.28544492907407015,0.3652057889025494,0.5479745754814818},
{-0.3071863793357401,0.3562878188961466,0.5428629186192966},
{-0.3318804464470904,0.3458352997405845,0.5362580447348881},
{-0.36016289366972176,0.3342254810308082,0.5277270937352518},
{-0.389492170943665,0.32176346901292874,0.518195153770542},
{-0.4173252252225172,0.30875737590592506,0.508588815977347},
{-0.4411190034598748,0.2955130594491254,0.49983391999903815},
{-0.4583312041025518,0.28233788036829177,0.49285630547898684},
{-0.45802684934965776,0.26268933871602873,0.4890890699820543},
{-0.46447766712457655,0.2481659808038572,0.48580429313045026},
{-0.48065130414132884,0.23751957639830343,0.4796923987964085},
{-0.48171166107054714,0.21891410733126718,0.47692840674420073},
{-0.4795992136374977,0.19856667698717348,0.47504817071521116},
{-0.11853302512091526,0.35319166684201514,0.5903820892112628},
{-0.1290712145032179,0.34258434008374633,0.5810477919626297},
{-0.13911642433515395,0.33286076934869585,0.5728031598786789},
{-0.1616770022033781,0.3361290133495255,0.5670527337820248},
{-0.17601624427737916,0.3461163582037508,0.5649252564846351},
{-0.1906598411042742,0.35384471444760734,0.5624483348413296},
{-0.20509677729648815,0.359142741627614,0.5597880488530711},
{-0.21964794045768943,0.3620442569385368,0.5570308202398166},
{-0.2346349696847636,0.3625830775751418,0.5542615677350896},
{-0.25037950407459625,0.36079377222541187,0.551566713058848},
{-0.26720092824442165,0.35671166107054714,0.5490326779310489},
{-0.28563956581727895,0.35065161976847997,0.546022196103658},
{-0.30623423742977296,0.3429285239771426,0.541900255808291},
{-0.32952376371850867,0.33385800084768436,0.5360288393036964},
{-0.356046213826874,0.3237556775312546,0.5277729348214903},
{-0.3834464080127213,0.3127763616305599,0.5182725575718954},
{-0.4093676635474688,0.30107486074830686,0.5086692257515685},
{-0.43145254620931794,0.28880523099398503,0.500102954570732},
{-0.44734587625612093,0.276122279970301,0.4937160137192601},
{-0.44788619987915995,0.25828709145071255,0.4926766986001184},
{-0.45375611339732047,0.2442274048534438,0.4899608021138001},
{-0.46767677374944017,0.23221628876577763,0.4834415984561323},
{-0.46860561936567957,0.2144998361744787,0.48158390722365335},
{-0.4665585518425111,0.19536155841657374,0.48050626595044355},
{-0.10268027570783146,0.33236177785259313,0.5897515864021811},
{-0.11448548265403358,0.32446659011455764,0.5811049054471233},
{-0.12581424290064358,0.3171282588503356,0.5734284022352415},
{-0.13595113490505636,0.31006422261032673,0.5695927808555601},
{-0.14815237877662918,0.3240540203384124,0.5686639352393206},
{-0.15617306588190735,0.3161994132340961,0.567258642923489},
{-0.1687380324705189,0.32700137673557356,0.5656564593847976},
{-0.18211085426742937,0.33580737425263996,0.5635898530379865},
{-0.19580531516122535,0.3425670557397548,0.5611843232502983},
{-0.2093336960540594,0.34722856816494374,0.55856687237541},
{-0.22301087260386387,0.34980168094002784,0.5559223677447087},
{-0.23715247196178807,0.3502961634768285,0.5534356766895822},
{-0.25207336978576433,0.34872253668038394,0.5512916665414178},
{-0.26808994472015896,0.3450898184692985,0.549674453138386},
{-0.08793973625594055,0.31287405574877275,0.588226055171626},
{-0.10136741705769364,0.3062579094661092,0.5802219009171223},
{-0.11425627722284179,0.30020312861656107,0.5731240474823475},
{-0.12558503746945182,0.29433171211196646,0.5696724391365644},
{-0.1354183262141876,0.28881650339224035,0.5685662411211078},
{-0.1449044250926591,0.30345408827339926,0.5682709042868179},
{-0.1526816283956221,0.29747370525233635,0.568136387000971},
{-0.16317397669168637,0.30933076523051306,0.5672188137829868},
{-0.1748642051756841,0.31936395117097677,0.5658142729603723},
{-0.1873232112206955,0.32754019737217854,0.5639851384701402},
{0.1941798353328063,0.3951031950485614,0.5742820985297787},
{0.210841191447406,0.39960914837782674,0.5715015736267965},
{0.20568143901933142,0.42412135413065766,0.5829099921544107},
{0.2004525492152908,0.450069663421218,0.5923998484989674},
{0.22034758064273713,0.451726705964752,0.5889144229584184},
{0.2240802474516865,0.4254154254503699,0.5795628413657938},
{0.2279384136278786,0.40056129028379384,0.5682964550561967},
{0.2156056584433269,0.37832084852602127,0.5617005990903927},
{0.20006252423565626,0.3748068662432253,0.5645126867084898},
{0.24317493860300418,0.4225402124020428,0.575546861614027},
{0.24574654839165422,0.398130209726727,0.5646389375689495},
{0.2315733863186151,0.3790032043670774,0.5586758388918782},
{0.21964794045768943,0.3620442569385368,0.5570308202398166},
{0.20509677729648815,0.359142741627614,0.5597880488530711},
{0.24094225225523117,0.448343483501718,0.5845798100826343},
{0.2623620634200156,0.4402596709662098,0.5793734650751043},
{0.2631819425197868,0.41576024059806843,0.5708252297314764},
{0.26454064225616297,0.3924887501465413,0.560498961436374},
{0.248275323066934,0.3769396039931344,0.5554481755247677},
{0.2346349696847636,0.3625830775751418,0.5542615677350896},
{0.22301087260386387,0.34980168094002784,0.5559223677447087},
{0.2093336960540594,0.34722856816494374,0.55856687237541},
{0.19580531516122535,0.3425670557397548,0.5611843232502983},
{0.18211085426742937,0.33580737425263996,0.5635898530379865},
{0.1687380324705189,0.32700137673557356,0.5656564593847976},
{0.15617306588190735,0.3161994132340961,0.567258642923489},
{0.1449044250926591,0.30345408827339926,0.5682709042868179},
{0.1354183262141876,0.28881650339224035,0.5685662411211078},
{0.11709992755605388,0.27736074079195355,0.5690937893594573},
{0.11054089475788392,0.25965631209212703,0.5680447048284943},
{0.09705534897842011,0.2640134697644219,0.5704291928061057},
{0.0810019508763914,0.26919651848222415,0.5761172449657469},
{0.06286165611069194,0.2756360638588876,0.5830941079925812},
{0.05412930492889371,0.2564151218471102,0.5794042762970022},
{0.025594355985342876,0.2413807485473636,0.5796237123163727},
{0.0,0.21826481719176,0.5742099551809445},
{-0.025594355985342876,0.2413807485473636,0.5796237123163727},
{-0.05412930492889371,0.2564151218471102,0.5794042762970022},
{-0.06286165611069194,0.2756360638588876,0.5830941079925812},
{-0.0745774353640684,0.2941558626991833,0.585957297149436},
{0.3095370501185856,0.3929869901494269,0.5584699297504141},
{0.28500229956924406,0.40570150388822596,0.5651995515088482},
{0.28508947278241864,0.3841118552563945,0.5555856987834827},
{0.30816106603821797,0.3734767232490959,0.54960531576242},
{0.28544492907407015,0.3652057889025494,0.5479745754814818},
{0.26602033240047973,0.37221496613771565,0.5520251239212316},
{0.2856110090750321,0.42830491686982025,0.5731586161703305},
{0.3116923326650054,0.413312627190227,0.5657969886163807},
{0.3416100291278771,0.39611169894580534,0.5571510591545401},
{0.3376879860282381,0.37824344472466787,0.5504372187536636},
{0.33452344809135753,0.3610575463445867,0.542266984498198},
{0.3071863793357401,0.3562878188961466,0.5428629186192966},
{0.28563956581727895,0.35065161976847997,0.546022196103658},
{0.26720092824442165,0.35671166107054714,0.5490326779310489},
{0.25037950407459625,0.36079377222541187,0.551566713058848},
{0.3763658389219379,0.3775355381142329,0.5470833045260933},
{0.3703568991586282,0.3620953584772944,0.5409022728160856},
{0.36494464500963414,0.34733152273567575,0.5332768711429612},
{0.3318804464470904,0.3458352997405845,0.5362580447348881},
{0.30623423742977296,0.3429285239771426,0.541900255808291},
{0.42679704572986527,0.31813751424079645,0.5133472710275317},
{0.43712857447748676,0.3288012029903418,0.5197920768567142},
{0.40451376885872226,0.3453468291495201,0.5304820678688555},
{0.39663361098502725,0.33284348500470434,0.5233864689137315},
{0.4127786912595327,0.35860392099100913,0.536115261023654},
{0.4476667638597894,0.34033737536485,0.5247684649398355},
{0.46517129536388807,0.31326408072840733,0.5094485242176204},
{0.45264315194291055,0.3037576915330762,0.5039100192081666},
{0.4411190034598748,0.2955130594491254,0.49983391999903815},
{0.4173252252225172,0.30875737590592506,0.508588815977347},
{0.389492170943665,0.32176346901292874,0.518195153770542},
{0.36016289366972176,0.3342254810308082,0.5277270937352518},
{0.32952376371850867,0.33385800084768436,0.5360288393036964},
{0.4778474829486189,0.3237556775312546,0.5135652040604681},
{0.4856104078804585,0.29953805711949644,0.5000691373759661},
{0.47138013232292564,0.2902496009571017,0.4958262066726586},
{0.4583312041025518,0.28233788036829177,0.49285630547898684},
{0.44734587625612093,0.276122279970301,0.4937160137192601},
{0.43145254620931794,0.28880523099398503,0.500102954570732},
{0.4093676635474688,0.30107486074830686,0.5086692257515685},
{0.3834464080127213,0.3127763616305599,0.5182725575718954},
{0.356046213826874,0.3237556775312546,0.5277729348214903},
{0.5082867157041041,0.27178841858773384,0.48386018017801363},
{0.4995987026221101,0.28619078609196474,0.4915674946117936},
{0.4841029124871119,0.2766558401543867,0.48892900192682853},
{0.4919064180526707,0.26201825527322786,0.48305157347649785},
{0.4699785974731792,0.26866070381848733,0.4873666475286394},
{0.500139026245149,0.3098808582653733,0.5030270146781656},
{0.5156656276020453,0.29678007701302483,0.49307423851192317},
{0.5255500178855386,0.28252124471324525,0.4836249628010857},
{0.5309164309482943,0.26517152081185313,0.47460103225108297},
{0.5128242317484842,0.25489710554872536,0.47686302683431986},
{0.4958848231435863,0.2453801954483559,0.47802934430713834},
{0.4770794568808222,0.2539111464479921,0.48307486976622543},
{0.46447766712457655,0.2481659808038572,0.48580429313045026},
{0.45802684934965776,0.26268933871602873,0.4890890699820543},
{0.5328883491497606,0.24279956774110156,0.4659205341012592},
{0.5143640413501628,0.2340852523965119,0.4704896128607544},
{0.4971353078567113,0.22578275533485034,0.47369473143135415},
{0.48065130414132884,0.23751957639830343,0.4796923987964085},
{0.46767677374944017,0.23221628876577763,0.4834415984561323},
{0.45375611339732047,0.2442274048534438,0.4899608021138001},
{0.44788619987915995,0.25828709145071255,0.4926766986001184},
{0.506457581213872,0.18486319817477323,0.461516783849509},
{0.512407153013037,0.2103929257434522,0.4652163849569094},
{0.49506494404381507,0.20393835050244835,0.47036937394603073},
{0.48908531251596926,0.18055789353445292,0.46837415945483685},
{0.4795992136374977,0.19856667698717348,0.47504817071521116},
{0.48171166107054714,0.21891410733126718,0.47692840674420073},
{0.531077250496737,0.21684449501158803,0.45833496156863685},
{0.4960170859497822,0.15853839078248474,0.4598657532517112},
{0.47860423661816026,0.15635079402773308,0.4680299755614406},
{0.4736511448247668,0.17694546564022712,0.47431396184218044},
{0.4665585518425111,0.19536155841657374,0.48050626595044355},
{0.46860561936567957,0.2144998361744787,0.48158390722365335},
{0.4376215540278533,0.08374302238547993,0.4681509659693812},
{0.4608855295472103,0.10730308623234365,0.4636570365315883},
{0.4433554472737329,0.1084077812613663,0.4728981486213106},
{0.42055890053536377,0.08629960230978954,0.47738756909980123},
{0.42804677894977317,0.10957785620026993,0.48102479627018896},
{0.4475983779770404,0.13176644492606804,0.477341728013563},
{0.4630325456682428,0.13202946755202588,0.46965846136272776},
{0.480588178711099,0.13246007316537955,0.460737485383457},
{0.42773716374436005,0.057162707299403884,0.4632602481130005},
{0.4115116736956332,0.06245472253367437,0.4737435784904606},
{0.3956303675403026,0.06651954934454757,0.48276525456081243},
{0.4057672595447153,0.08885693372731619,0.4857005870665012},
{0.4165226304667374,0.11203148155384746,0.48883731975435185},
{0.4355121125676719,0.13285535859753328,0.48470335556751265},
{0.45071707482768264,0.15419551148131336,0.4817905678583345},
{0.4632046376149409,0.15452241103071798,0.4749910572307175},
{0.31996627298442004,0.017338075756528196,0.49599829861935674},
{0.35278849073108265,0.028985469127155664,0.4872358877088776},
{0.34198201827030306,0.036751400031863286,0.49538432866104953},
{0.31256406479675114,0.027497512557451635,0.5031878342266083},
{0.33293779740344065,0.044038629757327794,0.5027948032741056},
{0.3578813602628423,0.05541924303591233,0.4966633701164214},
{0.3695543044028484,0.04988073802645856,0.48867048826017295},
{0.383269055613504,0.044113027585813,0.4799614333681024},
{0.2894466304547135,-0.00482721667954227,0.49844065157467893},
{0.28469644182991605,0.009437627565973569,0.5066792717128936},
{0.2809502481430603,0.022486555786347444,0.5123613119267986},
{0.30658969372142447,0.03679724111810166,0.5096093437660631},
{0.3269145792690075,0.05156708880545644,0.510451767662345},
{0.34992304709457694,0.061715253208124515,0.5047246378554188},
{0.3724212510257882,0.07555550378602281,0.4992319739322033},
{0.38197348130735775,0.07050396638119942,0.4910271709887547},
{0.39735053551406646,0.03713015261324249,0.46975014353520445},
{0.17977746782857537,0.03256633430626653,0.5437579470407701},
{0.1717605381893823,0.008446408012721245,0.5457967481385513},
{0.20854913713548823,0.005333723107815213,0.5333362391071058},
{0.21232088159172277,0.025657105668964227,0.5341538637272261},
{0.2467903724700981,0.022085258408457594,0.5231858202247865},
{0.2468760426968386,0.0055501531543176216,0.519711667082493},
{0.13935389619173297,0.01590873565775196,0.5543555043872175},
{0.15139732648773113,0.04217567807232969,0.550488320292421},
{0.1616770022033781,0.062254073844729425,0.5483961631762313},
{0.18699029972555467,0.05167004337618849,0.5425991445001218},
{0.21631131057411077,0.04270022033781123,0.5348046568531672},
{0.2474667163654181,0.036476353514433166,0.5260294705579986},
{0.27828395020906543,0.03413169467732382,0.5172918589236815},
{0.24828058351945315,-0.012269254007713342,0.5131413618860675},
{0.1294153983966141,0.0538486222123359,0.5528389910752666},
{0.1127653146802697,0.06731087170207203,0.5523745682671468},
{0.09454235566069781,0.04514482777278452,0.5541097661052511},
{0.11417361296896936,0.028742736818057474,0.5562778240363602},
{0.0983095911576302,-0.0011666932194270107,0.5600330356418204},
{0.0834097351437306,-0.029844425874212068,0.5621274472376612},
{0.05929506930270448,-0.006247538859714274,0.556810632727229},
{0.07560472659173778,0.0198811288029314,0.5559531789666067},
{0.14254473639120932,0.07331905997216469,0.5511766880792134},
{0.12838284671642552,0.08499275560538785,0.5519537320656143},
{0.07878354289974179,0.06331142480107972,0.5503996440928124},
{0.10038070646374346,0.08228662853089086,0.5506604122391192},
{0.117982932086055,0.09739990861842478,0.551738805005546},
{0.13950569782157146,0.09680322300410917,0.5540488951546723},
{0.1520736703830511,0.08632289859951724,0.5527473089027899},
{0.06709556889539516,0.08316211812872172,0.5474650630803406},
{0.09119595636529786,0.09850084618136237,0.5492618833622407},
{0.11013358543425786,0.11066676987173515,0.5515434167691202},
{0.13037806120761955,0.1076051865055866,0.554513317962792},
{0.14716566818267898,0.10420693417821209,0.5573900339975533},
{0.1588160675261745,0.09445856416699983,0.5560726663881131},
{0.1693317121119665,0.07584182270170825,0.5498923861713224},
{0.19252880473500847,0.06504061069344787,0.5447664509380138},
{0.21956753068346807,0.055265186926422766,0.5381217479131033},
{0.2483497208954192,0.04786297873875389,0.5307082673271791},
{0.2767757033225018,0.044182164961779034,0.5232775023972634},
{0.3027488118892239,0.04556942144040207,0.5165809463403783},
{0.05439909099380469,0.04152037598708633,0.5500742475298418},
{0.030914927961860218,0.09261665429207837,0.5457629309437853},
{0.05967908233660283,0.10461499499505512,0.5476243796423493},
{0.0841439440167613,0.11567772664283935,0.5497435905143521},
{0.10362640566806243,0.12492034171899563,0.552380580212883},
{0.1234410273212874,0.11904967670761799,0.5548575018561882},
{0.13877224044175776,0.11412965061577351,0.5579476419645837},
{0.14436785893570525,0.11820048937238291,0.5610039648782129},
{0.1523945579867196,0.10866629492802196,0.5607056220710551},
{0.16358654646783158,0.09932598573365273,0.5596738218840838},
{0.17493860300416927,0.08451931487866393,0.5533898356033438},
{0.19674843914858825,0.07402471210294857,0.5487343351238911},
{0.22222781667172672,0.06433345557622998,0.5427516976231773},
{0.24935897628588005,0.05680725100775241,0.53608595278819},
{0.27612265571690947,0.05280479813389201,0.5293841362787859},
{0.3005010956771104,0.05368780266389315,0.5232895262887358},
{0.32315936766354747,0.05900987762684456,0.5176089890612647},
{0.07448875916445978,0.2501619467882683,0.5731360713738198},
{0.04972029422462433,0.2355934992830755,0.5746540876722047},
{0.024722623853597095,0.21683397410654967,0.5726130320947723},
{0.0,0.19346929849611175,0.5668979261793183},
{-0.024722623853597095,0.21683397410654967,0.5726130320947723},
{-0.04972029422462433,0.2355934992830755,0.5746540876722047},
{-0.07448875916445978,0.2501619467882683,0.5731360713738198},
{-0.0810019508763914,0.26919651848222415,0.5761172449657469},
{-0.09008374640410495,0.2878643614862732,0.578519768780567},
{-0.1046123647687956,0.28239499385278544,0.5720666965259971},
{-0.11709992755605388,0.27736074079195355,0.5690937893594573},
{-0.1276952304228502,0.27283600013226283,0.5683167453730563},
{-0.14381776590084497,0.2838280914176468,0.5685031156908779},
{0.09175807329163047,0.24536817155688354,0.5683881372286734},
{0.07091089995821698,0.2306682127387118,0.5696957354262919},
{0.04833454073243535,0.21392644684989068,0.5693545575057639},
{0.024860147112312166,0.19305672871996654,0.5659345118750958},
{0.0,0.16918254070838756,0.5601322327464673},
{-0.024860147112312166,0.19305672871996654,0.5659345118750958},
{-0.04833454073243535,0.21392644684989068,0.5693545575057639},
{-0.07091089995821698,0.2306682127387118,0.5696957354262919},
{-0.09175807329163047,0.24536817155688354,0.5683881372286734},
{-0.09705534897842011,0.2640134697644219,0.5704291928061057},
{-0.11054089475788392,0.25965631209212703,0.5680447048284943},
{-0.12171484740178735,0.2560611685418927,0.5676945089893619},
{-0.136547820519372,0.2688929152225472,0.5684512626589032},
{-0.15084648195965383,0.279540071121318,0.5681822280872092},
{-0.15929176273254958,0.29230268042600643,0.5678605889903239},
{-0.16914759627379605,0.3034826450156461,0.5671729726967485},
{-0.1800615322646098,0.31301759095322407,0.5661035978489259},
{-0.1740901671621512,0.29868962127747833,0.5657511475301424},
{-0.1843360256830322,0.30775939291371956,0.5651033603770692},
{-0.1916803688929904,0.3208436413152935,0.5646389375689495},
{-0.19521238701299481,0.31524727132812896,0.5640768206426169},
{-0.2036516558401544,0.3268976706716245,0.562763961992479},
{-0.2064494650871281,0.3210728467464853,0.5625745857017895},
{-0.21562294278731842,0.3311180565784213,0.5604651442416081},
{-0.21777897682695518,0.32515495790135,0.560498961436374},
{-0.2278700277451296,0.3335168229271563,0.5581144734587626},
{-0.22945192096696135,0.32752291302818703,0.5582745415139884},
{-0.240666454244584,0.3341105025686038,0.5560846902795855},
{-0.2417215507212832,0.32820526886924317,0.5563251681090328},
{-0.25428952328276283,0.3329126223806704,0.55474853533972},
{-0.25483961631762314,0.3272305821667653,0.5550754348891246},
{-0.26901277839066223,0.3299367092412624,0.554478749274809},
{-0.26905861947690063,0.32462740966300035,0.5549491840286649},
{-0.28520445124462307,0.3253871693054099,0.5540661794986639},
{-0.2846994478027841,0.3205280141641441,0.5546966823077455},
{-0.26889855142167485,0.3202296713569863,0.5539917816701786},
{-0.2840576725954472,0.3166194979424115,0.5535559156043057},
{-0.30208374039215924,0.3150639069831756,0.5530689479996753},
{-0.30086782436701726,0.31162432252886485,0.5517560893495376},
{-0.31960480474703234,0.30528322276363135,0.5473778898671662},
{-0.3215308818622603,0.3083673509262906,0.5488147448981125},
{-0.34054366025292254,0.2976345248007792,0.5392106615845685},
{-0.34336401429640695,0.30056985730646796,0.540684339783149},
{-0.361895837028175,0.28891645199010435,0.5289738209822918},
{-0.365684114335184,0.29182097327389517,0.5304219484114937},
{-0.3462535057158574,0.3043310808576642,0.539870472629114},
{-0.3234577104707053,0.3123810761984062,0.5479715695086136},
{-0.3215308818622603,0.3083673509262906,0.5488147448981125},
{-0.3032297675481181,0.3194676572349258,0.5523001704386616},
{0.08889112666869069,0.2267694659288005,0.5661178762200493},
{0.06972429216853888,0.21092798891397208,0.5659630686173426},
{0.08808026548752372,0.20837892392183263,0.5636898016358504},
{0.07038335171986738,0.19115319640124923,0.5621049024411505},
{0.04867120969366131,0.1921677122442293,0.564013695212387},
{0.02564019707158123,0.16952672460178372,0.559650525594356},
{0.02669454205506341,0.14572092247295376,0.5538257016692167},
{0.0,0.14448321314451817,0.5538715427554551},
{-0.02669454205506341,0.14572092247295376,0.5538257016692167},
{-0.02564019707158123,0.16952672460178372,0.559650525594356},
{-0.04867120969366131,0.1921677122442293,0.564013695212387},
{-0.06972429216853888,0.21092798891397208,0.5659630686173426},
{-0.08889112666869069,0.2267694659288005,0.5661178762200493},
{-0.10595378016118027,0.24172192646789165,0.566714561834365},
{0.050135869973637615,0.17037816641666995,0.5588276405217166},
{0.05213409043769971,0.14861642583814036,0.5539917816701786},
{0.055152838690477976,0.12674271277027452,0.5500689870773227},
{0.028346324146078256,0.12047375635387517,0.5490116361209724},
{0.0,0.11750535814663739,0.5486231141277719},
{-0.028346324146078256,0.12047375635387517,0.5490116361209724},
{-0.055152838690477976,0.12674271277027452,0.5500689870773227},
{-0.05213409043769971,0.14861642583814036,0.5539917816701786},
{-0.050135869973637615,0.17037816641666995,0.5588276405217166},
{-0.07038335171986738,0.19115319640124923,0.5621049024411505},
{-0.08808026548752372,0.20837892392183263,0.5636898016358504},
{-0.1033851763453983,0.22406333885430352,0.5652927366677589},
{-0.11745838982057348,0.2390413501627734,0.5668716239167225},
{0.07234474901629538,0.1715565077809608,0.5582858139122436},
{0.07506214848904774,0.1523490926470898,0.5546741375112348},
{0.07888048552473766,0.13367523769730458,0.5516869519735715},
{-0.07888048552473766,0.13367523769730458,0.5516869519735715},
{-0.07506214848904774,0.1523490926470898,0.5546741375112348},
{-0.07234474901629538,0.1715565077809608,0.5582858139122436},
{-0.08894824015318438,0.19036187404372487,0.5611760568249111},
{-0.10258859353535475,0.20682258146937965,0.5637844897811952},
{-0.11490406437591495,0.22232588653654808,0.5660201821018362},
{-0.12395730316138168,0.22133391549007875,0.5671038353207825},
{-0.12665140634440633,0.23714683576266038,0.5676201111608766},
{-0.13083722356322014,0.2531656651767061,0.5681130907112432},
{-0.14380574200937263,0.26560438090485794,0.5682137908023243},
{-0.14962004502947357,0.26304479500768024,0.5663185249089941},
{-0.15656910280727807,0.276122279970301,0.5663012405650026},
{-0.16474459751526283,0.28811686320719265,0.5661178762200493},
{-0.1693287061390984,0.28467126680714583,0.5632742258868372},
{-0.17825870003697347,0.294687168403618,0.5632967706833478},
{-0.1879176423553601,0.30331881949433526,0.563135199641688},
{-0.19812442322895596,0.3104775438796889,0.5626031424440363},
{-0.2086971812992416,0.3160731623736364,0.5615172347454391},
{-0.21945330371448066,0.320017750269786,0.5596911062280752},
{-0.23062199590586496,0.32235865164081023,0.5575749013289406},
{-0.24243246330458623,0.32314245906616446,0.5556202674714658},
{-0.2551154143282703,0.322417268111738,0.554275846106213},
{-0.255207096500747,0.3181833553270348,0.5527247641062792},
{-0.26860020861451706,0.3164398910635432,0.5520822374057253},
{-0.28332346372241646,0.31334373900941165,0.5512338015637072},
{-0.299606818748854,0.3088257617886741,0.5490552227275596},
{-0.3176779761385874,0.3028175735185814,0.5444230185378347},
{-0.3377683958024595,0.2952492853299506,0.53621220364865},
{-0.3582022478665108,0.28646583260939484,0.5260753116442372},
{-0.37730595693643276,0.27681064775709335,0.5156633731223942},
{-0.3818757871891449,0.2793679791746199,0.5183867845408828},
{-0.38659441309882736,0.2822687429923258,0.5197687805669866},
{-0.36961442386021026,0.29540409293265724,0.5296937514841992},
{0.08894824015318438,0.19036187404372487,0.5611760568249111},
{0.09112155853681266,0.1728806388293539,0.5586472821496312},
{0.09422297104346336,0.15609904380003065,0.5561763724520622},
{0.09835693523030262,0.14008848081137215,0.554006060041302},
{-0.09835693523030262,0.14008848081137215,0.554006060041302},
{-0.09422297104346336,0.15609904380003065,0.5561763724520622},
{-0.09112155853681266,0.1728806388293539,0.5586472821496312},
{-0.10331679046264929,0.1901439410107884,0.5621965846136272},
{-0.1138948089854541,0.20605831286766801,0.5651071178431544},
{-0.12264369301802683,0.205887723907404,0.566519173597939},
{-0.12948077830649501,0.20611166888607663,0.5668806418353268},
{-0.13105515659615655,0.22086348073622292,0.5673450646434466},
{-0.13391609127336015,0.23585652190903322,0.5677178052790895},
{-0.1381642824291868,0.2509066765663373,0.568032680937022},
{-0.14395528915956005,0.24922107728055648,0.5661870135960153},
{-0.1485935052950212,0.24796533211491234,0.5630164637133986},
{-0.15434994333741142,0.2610307931860607,0.5631810407279264},
{-0.16131027351347127,0.2733590394113103,0.5632509295971094},
{-0.16539839661407219,0.27103166491819247,0.5594213201631643},
{-0.1733334134926098,0.28171864995746543,0.5596963666805944},
{-0.18191020557848445,0.29121301526132426,0.5601555290361949},
{-0.19103784219243639,0.299423078657292,0.5605222577261018},
{-0.20062464116198886,0.3062579094661092,0.5605222577261018},
{-0.2105774173282312,0.31162432252886485,0.5598797310255478},
{-0.22080599150512067,0.3154313871662994,0.5583203826002267},
{-0.2315162728341214,0.3177474892611619,0.5563026233125221},
{-0.24291417045669744,0.3186417661894183,0.5542841125316003},
{-0.2432808991466043,0.3144221317758386,0.5526330819338025},
{-0.255207096500747,0.31423876743088514,0.5507979354978343},
{-0.26823347992461016,0.3129544655229942,0.5496977494281137},
{-0.2825441652563644,0.3103858617072122,0.548321765347746},
{-0.298322516840963,0.3063495916385859,0.5456607278662703},
{-0.31575189902335943,0.30066153947894464,0.5407076360728769},
{-0.3350164276417241,0.29313909237655217,0.5324509800974536},
{-0.3545560027775189,0.2842414126870091,0.522452362844973},
{-0.37281127600542274,0.2744254082862648,0.5122696297543219},
{-0.3882228989001145,0.26415099302313694,0.5034628807440384},
{-0.39340594761791686,0.2666279146664422,0.506628170174136},
{-0.3986949568793192,0.269225075224471,0.5091704717273222},
{-0.40419588722792194,0.27206346510516394,0.5104690520063366},
{-0.3915362324939655,0.2856857826501258,0.519138277757905},
{-0.11744411144945006,0.13145682972065492,0.5557976198706831},
{-0.11240985838861818,0.14479808880245046,0.5571683434985315},
{-0.10836231592173648,0.15904564870397483,0.5588020897523379},
{-0.10532327735209862,0.17417095268298102,0.560533530124357},
{-0.11427281007361628,0.19038441884023552,0.5641001169323446},
{-0.12260386387752463,0.1909698320562959,0.5658195334128914},
{-0.12909375929972855,0.19178369921033092,0.5662899681667473},
{-0.13452930973845031,0.19271254482657038,0.5644435493325237},
{-0.13505084603106374,0.20653025060795804,0.5650515073450948},
{-0.13670788857459773,0.2206913887895248,0.5655444868954613},
{-0.1396319486820312,0.2349908017230236,0.5659232394768405},
{-0.14418750056361992,0.23444371466103145,0.5627091029876364},
{-0.14796826293845872,0.23410779719302255,0.5585495880314184},
{-0.15246369536268567,0.24699665735817072,0.5589629093007806},
{-0.15835765666379095,0.25938126557469693,0.559214659528483},
{-0.1620039017527828,0.2579128478286355,0.5548342055664607},
{-0.1691596201652684,0.26892147196479405,0.5552016857495845},
{-0.1770487959575677,0.27901252288296846,0.5557517787844447},
{-0.18530470043977382,0.28800263623820527,0.5566693520024288},
{-0.19392808510510384,0.29579937836481085,0.557586925220413},
{-0.20291819846034068,0.30231257007674245,0.5581370182552733},
{-0.21227504050548443,0.3074497777083064,0.5579536539103197},
{-0.22199861124053494,0.3111193190870259,0.5566693520024288},
{-0.2322730265036628,0.3134128763853778,0.5547425233939838},
{0.09704332508694777,-0.5831568576762026,0.5194170817414201},
{0.1141548256385438,-0.5748355732841155,0.5155423827144536},
{0.09406064850858656,-0.565077433861082,0.5239215320842514},
{0.1127517878023633,-0.5575782830484173,0.5194952370359905},
{0.14030904407056824,-0.3754253451608346,0.5174293821823963},
{0.1466328594918102,-0.417101655990453,0.5145970042474397},
{0.13427680801753084,-0.3358877840268614,0.5194824616513012},
{0.1560528269671838,-0.33613953425456383,0.505074082201334},
{0.07748721710037845,-0.41331788764274613,0.5379263596766776},
{0.07289484205115565,-0.37323549392643185,0.5401109504585612},
{0.06905922067147423,-0.33433369605405944,0.5416244577976439},
{0.06679422011536924,-0.29998444409040764,0.5420377790670062},
{0.0659269969429256,-0.26955723522639485,0.5421069164429723},
{0.06628245323457711,-0.24242081515972239,0.5425901265815175},
{0.06815667731783052,-0.2162583303023107,0.5448799264137842},
{0.06341550661163732,-0.20519935612061166,0.5521303329716147},
{0.07461350703848547,-0.19361358519378005,0.5530621845607222},
{0.0620823576446399,-0.19934597545322558,0.5591004325594957},
{0.07306392802498565,-0.18947436055442166,0.5604230606214549},
{0.061806559633992744,-0.1956133086442762,0.5659803529613342},
{0.07270020530794688,-0.18661192289078402,0.5675855424728936},
{0.06156533031132861,-0.1927290776773449,0.5724477035870273},
{0.0723560214145507,-0.18423795581821079,0.5742820985297787},
{0.06033889338114835,-0.18942100453601304,0.57818084533969},
{0.07086505887197862,-0.1815663974316968,0.5802451972068501},
{0.08060065349850153,-0.17521101929533986,0.5763148876818238},
{0.078891757922993,-0.17330448100375448,0.582544014957721},
{0.06797707043896221,-0.1790000480955659,0.5853493391368649},
{0.07544691301616312,-0.1714791039796075,0.5879051675679575},
{0.06978892058520281,-0.16998062650486517,0.5922578162809503},
{0.07444291807822143,-0.1620035260061743,0.5946708610008087},
{0.08061192589675686,-0.1630015089983798,0.5900950188023604},
{0.08202247866510758,-0.45120967863144074,0.5355012910653468},
{0.060293052294909985,-0.4498457184425454,0.5387349663781934},
{0.056680624400684165,-0.41236048528425984,0.5409714101920516},
{0.05304565170994766,-0.3727876039690866,0.5430004418780116},
{0.05009904680600353,-0.3344772312585107,0.5443764259583793},
{0.048550970778937746,-0.3007757664479321,0.5446522239690266},
{0.048175224170426634,-0.27140515704705254,0.5446447090368562},
{0.048744104535712464,-0.2460865990723568,0.5451730087684228},
{0.0493340267110749,-0.22666500837163447,0.5473140129437192},
{0.04901915105314259,-0.21498830676554312,0.5521446113427381},
{0.048501372226614284,-0.20841800156911788,0.5584511424199886},
{0.04848183340297171,-0.20431635159061057,0.5650169386571118},
{0.04832176534774597,-0.2011630860519853,0.5713467660240898},
{0.047380895840034146,-0.19743643118877213,0.5769423845180374},
{0.0458914362838961,-0.19333327822383078,0.5818406173065882},
{0.05814453318744345,-0.186104664969294,0.5831023744179685},
{0.06343955439458204,-0.17694170817414204,0.5894697764457978},
{0.06127525392955803,-0.1691359481289322,0.5954321236296521},
{0.06529273666775884,-0.16110924907791782,0.5980533319706256},
{0.06803268093702186,-0.15174113463451883,0.5995608273639722},
{0.07717234144244614,-0.1525324569920432,0.596034821189704},
{0.06914489089821475,-0.14074453438983262,0.5992917927922783},
{0.0777457307670341,-0.14108796679001176,0.5956793648980525},
{0.0856860080980909,-0.48354117130738783,0.5332655987447058},
{0.0631712713161051,-0.48189540116210916,0.5367397518869995},
{0.04159289508252899,-0.48121003934818485,0.5384772042047548},
{0.03961195896245841,-0.44902583934277407,0.5403521797812254},
{0.03710422609725525,-0.4117096921583186,0.5424931839565216},
{0.034589729793098885,-0.372564410483631,0.5444455633343454},
{0.032591509329036795,-0.33489280700752394,0.545753161531964},
{0.0316311009976824,-0.30199694292559315,0.5459590706734281},
{0.031480050861060926,-0.273991045206826,0.545888430311028},
{0.03190915348798062,-0.25098858932699275,0.5463648770106201},
{0.032515608514117555,-0.23363435646629857,0.5482759242615076},
{0.032895112588713776,-0.2225738792981655,0.5525105885394278},
{0.03313859639102897,-0.21591414640891451,0.5582151735498435},
{0.03333398462745475,-0.2117644008645178,0.5645352315050004},
{0.03323704200245889,-0.2085104352348116,0.5707966729892295},
{0.032600527247641065,-0.20454029656928316,0.576323154107211},
{0.03174081900736764,-0.19978484749196654,0.5812634705159152},
{0.030973544432787953,-0.1941764536133297,0.5857619089130102},
{0.044084095096957654,-0.18905051838002113,0.5860752815845085},
{0.05500254004707354,-0.18319488323298394,0.5871326325408587},
{0.05633268304120287,-0.1761083021964644,0.5923615223448994},
{0.049262634855457794,-0.16926971392156215,0.5972575006537991},
{0.05260978564407478,-0.16035249540837646,0.6000831151498027},
{0.055430891180776196,-0.1504222640386448,0.6016770322631069},
{0.05738026458573185,-0.13943693619221395,0.6014590992301703},
{-0.10515118540540053,-0.4532394618106177,0.5301123332060804},
{-0.09993356799961522,-0.4146074500031563,0.5328522774753435},
{-0.12324188161877651,-0.41595938630057927,0.5252441601462104},
{-0.12894496364275815,-0.4555442915072249,0.5221713043818066},
{-0.1466328594918102,-0.417101655990453,0.5145970042474397},
{-0.14030904407056824,-0.3754253451608346,0.5174293821823963},
{-0.11734641733123718,-0.3747888304060168,0.5279390148224522},
{-0.09460172362484257,-0.37398022370450085,0.5352953819238828},
{-0.07748721710037845,-0.41331788764274613,0.5379263596766776},
{-0.08202247866510758,-0.45120967863144074,0.5355012910653468},
{-0.0856860080980909,-0.48354117130738783,0.5332655987447058},
{-0.1094512295932017,-0.4865276053518341,0.5274745920143326},
{-0.13374399932666206,-0.49026027216078355,0.5190781583005432},
{-0.15267035599736678,-0.4577348942348447,0.5112836706535888},
{-0.13427680801753084,-0.3358877840268614,0.5194824616513012},
{-0.1119709863498772,-0.33531740067514154,0.5298966546527951},
{-0.08995749554364522,-0.33470643668970246,0.5370380946941573},
{-0.07289484205115565,-0.37323549392643185,0.5401109504585612},
{-0.056680624400684165,-0.41236048528425984,0.5409714101920516},
{-0.060293052294909985,-0.4498457184425454,0.5387349663781934},
{-0.0631712713161051,-0.48189540116210916,0.5367397518869995},
{-0.06460436888096649,-0.5051616311611172,0.5354329051825978},
{-0.08766393824529341,-0.5069389126193747,0.531648385341674},
{-0.11203110580723898,-0.5111247298381886,0.5253418542644234},
{-0.13692582160753416,-0.5168233029028679,0.5163231841669397},
{-0.1578413808236967,-0.4941417346267033,0.5077862212215672},
{0.1128705237306528,-0.5436455988048252,0.5218722100814318},
{0.11310123214827864,-0.5293800030660923,0.5235337615842679},
{0.11203110580723898,-0.5111247298381886,0.5253418542644234},
{0.08766393824529341,-0.5069389126193747,0.531648385341674},
{0.06460436888096649,-0.5051616311611172,0.5354329051825978},
{0.04252474667163654,-0.5049609824721722,0.5373244136098427},
{0.021098923561115937,-0.5055058150545133,0.5379556679121414},
{0.02064051269873238,-0.4811040788045847,0.5390558539818621},
{0.019631257308271536,-0.4486298024174034,0.5408910004178302},
{0.018346955400380557,-0.41133995749554364,0.5430004418780116},
{0.017062653492489577,-0.3724900126551458,0.5449272704864565},
{0.01605339810202873,-0.33533693949878407,0.5462115723943475},
{0.015594987239645175,-0.3031384611222499,0.5463949367393011},
{0.01554914615340682,-0.2760764388840627,0.5463032545668244},
{0.015778351584598598,-0.2543349886223927,0.5467616654292079},
{0.016145080274505442,-0.23809822617541054,0.5485968118651761},
{0.01651256045762931,-0.22754876439485258,0.5526330819338025},
{0.01681015177157011,-0.22105811747943163,0.5581370182552733},
{0.016970971320012865,-0.21699930261429462,0.5643751634497747},
{0.01692513023377451,-0.21374233101172033,0.5706133086442762},
{0.01660424263010602,-0.20966021985685562,0.5761172449657469},
{0.01621421765047149,-0.20455758091327467,0.5810710882523575},
{0.01596171592955202,-0.19823902594455184,0.5856574513558441},
{0.01605339810202873,-0.19051066970069533,0.5900612016075943},
{0.030944987690541104,-0.18742579004481907,0.5900341478517815},
{0.04351296025202077,-0.18390579581628697,0.5899537380775601},
{0.051792912517171615,-0.1810696604152451,0.5898297416967515},
{0.045735125694755484,-0.17721675469157216,0.5937810930318543},
{0.03450405956635836,-0.16983408532754585,0.5981224693465916},
{0.03700352600617427,-0.15938832961093696,0.6011028914453019},
{0.039927586113607735,-0.14835039723931454,0.602696057065389},
{0.0434024907491185,-0.13716517219715577,0.602363897063465},
{0.0851885195884222,-0.5464576864229224,0.529248867499722},
{0.08736409245170153,-0.5357684469039983,0.52972381121288},
{0.08815691779565997,-0.5236122926254467,0.5305136305839703},
{0.06480276309026035,-0.5215825094462697,0.5346107716031755},
{0.04260290196620685,-0.5219176754210617,0.5366007256418504},
{0.021122219850843626,-0.5232448124423229,0.5372560277270937},
{0.0,-0.5059642259168969,0.5379556679121414},
{0.0,-0.48119576097706146,0.5390558539818621},
{0.0,-0.44853812024492673,0.5408910004178302},
{0.0,-0.41122497903333927,0.5430004418780116},
{0.0,-0.3724900126551458,0.5449272704864565},
{0.0,-0.3355661449299759,0.5462115723943475},
{0.0,-0.3036885541571102,0.5463949367393011},
{0.0,-0.27699401210204677,0.5463032545668244},
{0.0,-0.2556192905302837,0.5467616654292079},
{0.0,-0.23970341568697004,0.5485968118651761},
{0.0,-0.22938315933760384,0.5526330819338025},
{0.0,-0.22304205957237033,0.5581370182552733},
{0.0,-0.21906290298823766,0.5643751634497747},
{0.0,-0.21582922767539103,0.5706133086442762},
{0.0,-0.21172457172401563,0.5761172449657469},
{0.0,-0.20652423866222186,0.5810710882523575},
{0.0,-0.20000503500455402,0.5856574513558441},
{0.0,-0.1919437672655567,0.5900612016075943},
{0.0,-0.18211649046655706,0.5944642003661276},
{0.016695924802582734,-0.18117637245206225,0.5944642003661276},
{0.03230368742691729,-0.1792465378707492,0.5942936114058636},
{-0.04252474667163654,-0.5049609824721722,0.5373244136098427},
{-0.021098923561115937,-0.5055058150545133,0.5379556679121414},
{0.020823877043685803,-0.5357323752295813,0.5366255249180121},
{0.02031962509506389,-0.5443783046914218,0.5357304964965386},
{0.01972293948074825,-0.5505931535961957,0.5342402854471835},
{0.019103709069921936,-0.5549164940737246,0.5317175227176401},
{0.01853031974533398,-0.5578863952673964,0.5277270937352518},
{0.018071908882950422,-0.5600424293070331,0.5218331324341468},
{0.01779686236552029,-0.5619226653360228,0.5135997727484511},
{0.017521064354873134,-0.5645258378397876,0.5040362700686265},
{0.017062653492489577,-0.5688484268240994,0.49415187978513303},
{0.0,-0.5702477071941948,0.49380769589173695},
{0.0,-0.577184741080527,0.484645490589802},
{0.0,-0.5877687715490679,0.47720345326163094},
{-0.01554914615340682,-0.2760764388840627,0.5463032545668244},
{-0.031480050861060926,-0.273991045206826,0.545888430311028},
{-0.0316311009976824,-0.30199694292559315,0.5459590706734281},
{-0.015594987239645175,-0.3031384611222499,0.5463949367393011},
{-0.032591509329036795,-0.33489280700752394,0.545753161531964},
{-0.05009904680600353,-0.3344772312585107,0.5443764259583793},
{-0.048550970778937746,-0.3007757664479321,0.5446522239690266},
{-0.048175224170426634,-0.27140515704705254,0.5446447090368562},
{-0.03190915348798062,-0.25098858932699275,0.5463648770106201},
{-0.015778351584598598,-0.2543349886223927,0.5467616654292079},
{-0.01605339810202873,-0.33533693949878407,0.5462115723943475},
{-0.017062653492489577,-0.3724900126551458,0.5449272704864565},
{-0.034589729793098885,-0.372564410483631,0.5444455633343454},
{-0.05304565170994766,-0.3727876039690866,0.5430004418780116},
{-0.06905922067147423,-0.33433369605405944,0.5416244577976439},
{-0.06679422011536924,-0.29998444409040764,0.5420377790670062},
{-0.0659269969429256,-0.26955723522639485,0.5421069164429723},
{-0.048744104535712464,-0.2460865990723568,0.5451730087684228},
{-0.032515608514117555,-0.23363435646629857,0.5482759242615076},
{-0.016145080274505442,-0.23809822617541054,0.5485968118651761},
{-0.06628245323457711,-0.24242081515972239,0.5425901265815175},
{-0.0493340267110749,-0.22666500837163447,0.5473140129437192},
{-0.06815667731783052,-0.2162583303023107,0.5448799264137842},
{-0.04901915105314259,-0.21498830676554312,0.5521446113427381},
{-0.032895112588713776,-0.2225738792981655,0.5525105885394278},
{-0.03710422609725525,-0.4117096921583186,0.5424931839565216},
{-0.018346955400380557,-0.41133995749554364,0.5430004418780116},
{-0.019631257308271536,-0.4486298024174034,0.5408910004178302},
{-0.03961195896245841,-0.44902583934277407,0.5403521797812254},
{-0.08680423000501998,-0.3001339912405951,0.5376798699014942},
{-0.08502920302641348,-0.2696857405665057,0.5378106297212562},
{-0.08452119361170646,-0.24278378638354414,0.5380180418491542},
{-0.04159289508252899,-0.48121003934818485,0.5384772042047548},
{-0.02064051269873238,-0.4811040788045847,0.5390558539818621},
{0.04202350069588272,-0.5337198763943957,0.5360100519732709},
{0.040830129467251425,-0.541847275536491,0.5352608132358998},
{0.03906562339368325,-0.5477788114984475,0.5340606785683153},
{0.03725677922031076,-0.5520300086271421,0.531852040003487},
{0.03593114518548356,-0.5551171427626694,0.5280765380811674},
{0.03502860183183987,-0.5574422627761362,0.522317094065909},
{0.034486775222366844,-0.5594059145522152,0.5141558777290477},
{0.03395471802471511,-0.5620489161964825,0.5046119138728653},
{0.03308223439975231,-0.5664120858145134,0.4947064817792955},
{0.03151687402869501,-0.5735354900186671,0.48545785475740294},
{0.016236762446982154,-0.5758891667743807,0.48495510579521506},
{0.014860778366614464,-0.5866452891896198,0.47745595498255033},
{0.0639761205515359,-0.5330961370242673,0.5340734539530045},
{0.0617238953801203,-0.5409973367080388,0.5336225580227913},
{0.05764629318455772,-0.546580931310514,0.5330641985625438},
{0.05350782003841634,-0.5505480640031744,0.5315206314947802},
{0.05107373350848135,-0.5535976234778505,0.5281171187148865},
{0.049754862912607355,-0.5559715905504238,0.5225320211259773},
{0.04896354055508295,-0.557908940063907,0.5144482085904694},
{0.048212798831277756,-0.5604662714814337,0.5049170201189764},
{0.04701416715012731,-0.5646979297864858,0.49499280069498097},
{0.044881429400218234,-0.5716582599625456,0.48572764082231396},
{0.07268592693682348,-0.5502166554944675,0.5310539542070094},
{0.0611354761911919,-0.5577774287509281,0.5220337811230916},
{0.0601209603482119,-0.5594570160909728,0.514001070126341},
{0.08808853191291095,-0.16886090161150208,0.5556833929016957},
{0.08700487869396491,-0.1674676331871429,0.5632629534885818},
{0.08138972137637486,-0.1788377255606891,0.5619621187299164},
{0.08278223830751705,-0.1811838873842325,0.5544201328038812},
{0.08104779196262975,-0.1769507260927463,0.5693575634786321},
{0.08673509262905393,-0.16626975299920946,0.5708192177857402},
{0.08981696631206207,-0.15497781592023352,0.5639332854381657},
{0.09055418115796086,-0.1559149279618602,0.5565889422282075},
{0.09281843022084883,-0.15698730878255093,0.549909670515314},
{0.09105843310658278,-0.17054650089728293,0.5484247199184781},
{0.08620829588392136,-0.1651688154362719,0.5780095048862088},
{0.08964788033823207,-0.1542060323863517,0.5714963131742773},
{0.08973430205818962,-0.14097900027354354,0.5635838410922502},
{0.09019872486630935,-0.14161551502836137,0.55687601263711},
{0.09193016523832856,-0.1420626534924896,0.5514058935104051},
{0.09579434336025683,-0.14207467738396196,0.5477942171093965},
{0.09757162481851439,-0.15816264417397372,0.5443426087636133},
{0.0969869630956711,-0.1726221251626983,0.5418311184323251},
{0.10534582214860928,-0.17494423920329696,0.5341824204694728},
{0.10480098956626817,-0.18974414661933264,0.532056446158517},
{0.11689927886710895,-0.192597566364366,0.5212882998518056},
{0.11787922602210593,-0.2083759179489646,0.5203421698915747},
{0.11920936901623526,-0.22612693922824653,0.5202963288053363},
{0.12154876740082544,-0.24727170387560082,0.520525534236528},
{0.12486285248789344,-0.2722919190431387,0.5206916142374899},
{0.12911705558945624,-0.30167004337618847,0.520457148353779},
{0.14991763634341437,-0.30226672899050416,0.5059510747855991},
{0.1694805077689369,-0.3022208879042658,0.4864235235412765},
{-0.07270020530794688,-0.18661192289078402,0.5675855424728936},
{-0.08104779196262975,-0.1769507260927463,0.5693575634786321},
{-0.08138972137637486,-0.1788377255606891,0.5619621187299164},
{-0.07306392802498565,-0.18947436055442166,0.5604230606214549},
{-0.0723560214145507,-0.18423795581821079,0.5742820985297787},
{-0.08060065349850153,-0.17521101929533986,0.5763148876818238},
{-0.061806559633992744,-0.1956133086442762,0.5659803529613342},
{-0.0620823576446399,-0.19934597545322558,0.5591004325594957},
{-0.07461350703848547,-0.19361358519378005,0.5530621845607222},
{-0.08278223830751705,-0.1811838873842325,0.5544201328038812},
{-0.06156533031132861,-0.1927290776773449,0.5724477035870273},
{-0.04832176534774597,-0.2011630860519853,0.5713467660240898},
{-0.04848183340297171,-0.20431635159061057,0.5650169386571118},
{-0.048501372226614284,-0.20841800156911788,0.5584511424199886},
{-0.06341550661163732,-0.20519935612061166,0.5521303329716147},
{-0.07951474579990442,-0.19808947879436442,0.5458238018943641},
{-0.08663063507188784,-0.18387122712830395,0.5470344574669869},
{-0.08700487869396491,-0.1674676331871429,0.5632629534885818},
{-0.08673509262905393,-0.16626975299920946,0.5708192177857402},
{-0.08620829588392136,-0.1651688154362719,0.5780095048862088},
{-0.078891757922993,-0.17330448100375448,0.582544014957721},
{-0.08435060465144241,-0.16406787787333435,0.5844881279101575},
{-0.08908651490511647,-0.15363339455498076,0.5788293839859803},
{-0.08717095869492682,-0.15328921066158457,0.585485359409146},
{-0.08061192589675686,-0.1630015089983798,0.5900950188023604},
{-0.0833759179489646,-0.1529848559086906,0.5912823780852554},
{-0.08363969206813938,-0.14084748896056465,0.590829227675391},
{-0.08728593715713122,-0.14040035049643643,0.584946538772541},
{-0.08159187305175383,-0.12804204454250598,0.5893104598837892},
{-0.08485485660006432,-0.12684040688848744,0.5834330314334583},
{-0.08914362838961017,-0.1401253039790063,0.5782387103174006},
{-0.08650588719786216,-0.12607538679355884,0.576759020173084},
{-0.0800385365721689,-0.11404924084155216,0.5815062028250133},
{-0.08130029368354921,-0.11291448608384864,0.5749133528320773},
{-0.0729977966218877,-0.10346521037301118,0.5797289213667558},
{-0.07365159572069703,-0.102071941948652,0.5732217416005604},
{-0.08132283848005989,-0.11303998545109133,0.5678380441938132},
{-0.07309023028758142,-0.10222674955135858,0.5662899681667473},
{-0.08084714327368481,-0.11356227323692178,0.5612504546533963},
{-0.07202611589227796,-0.1026941783323464,0.5599804311166288},
{-0.08061192589675686,-0.1136133747756793,0.5561185074743515},
{-0.07117467407739178,-0.10223877344283094,0.5553392090082996},
{-0.08981696631206207,-0.15497781592023352,0.5639332854381657},
{-0.08964788033823207,-0.1542060323863517,0.5714963131742773},
{-0.08967117662795976,-0.14040035049643643,0.5709108999582171},
{-0.08808853191291095,-0.16886090161150208,0.5556833929016957},
{-0.09055418115796086,-0.1559149279618602,0.5565889422282075},
{-0.09019872486630935,-0.14161551502836137,0.55687601263711},
{-0.08973430205818962,-0.14097900027354354,0.5635838410922502},
{-0.08687336738098601,-0.12622117647766112,0.5695349158778492},
{-0.09105843310658278,-0.17054650089728293,0.5484247199184781},
{-0.09281843022084883,-0.15698730878255093,0.549909670515314},
{-0.09193016523832856,-0.1420626534924896,0.5514058935104051},
{-0.08818021408538766,-0.12682612851736402,0.5526586327031813},
{-0.08691920846722438,-0.1271274772973899,0.556675363948165},
{-0.08674711652052629,-0.1267487247160107,0.5625700767424873},
{0.08084714327368481,-0.11356227323692178,0.5612504546533963},
{0.08674711652052629,-0.1267487247160107,0.5625700767424873},
{0.08691920846722438,-0.1271274772973899,0.556675363948165},
{0.08061192589675686,-0.1136133747756793,0.5561185074743515},
{0.08818021408538766,-0.12682612851736402,0.5526586327031813},
{0.08687336738098601,-0.12622117647766112,0.5695349158778492},
{0.08132283848005989,-0.11303998545109133,0.5678380441938132},
{0.07309023028758142,-0.10222674955135858,0.5662899681667473},
{0.07202611589227796,-0.1026941783323464,0.5599804311166288},
{0.07117467407739178,-0.10223877344283094,0.5553392090082996},
{0.07117467407739178,-0.10223877344283094,0.5553392090082996},
{0.0813574071680429,-0.1123290728677883,0.5534123803998546},
{0.07124907190587698,-0.09962432854081062,0.5534123803998546},
{0.08130029368354921,-0.11291448608384864,0.5749133528320773},
{0.08650588719786216,-0.12607538679355884,0.576759020173084},
{0.07365159572069703,-0.102071941948652,0.5732217416005604},
{0.08967117662795976,-0.14040035049643643,0.5709108999582171},
{0.08914362838961017,-0.1401253039790063,0.5782387103174006},
{0.08485485660006432,-0.12684040688848744,0.5834330314334583},
{0.0800385365721689,-0.11404924084155216,0.5815062028250133},
{0.0729977966218877,-0.10346521037301118,0.5797289213667558},
{0.06389345629766346,-0.09652817648667905,0.5786625524918012},
{0.06368679566298235,-0.09498010045961326,0.5722072257575804},
{0.08908651490511647,-0.15363339455498076,0.5788293839859803},
{0.08728593715713122,-0.14040035049643643,0.584946538772541},
{0.08159187305175383,-0.12804204454250598,0.5893104598837892},
{0.07742334017693157,-0.11602115904301849,0.5873002155282547},
{0.07120773977894077,-0.10611347246979752,0.5854673235719374},
{-0.0813574071680429,-0.1123290728677883,0.5534123803998546},
{-0.07117467407739178,-0.10223877344283094,0.5553392090082996},
{-0.07124907190587698,-0.09962432854081062,0.5534123803998546},
{-0.058503746945180075,-0.09416548181236119,0.5544674768765537},
{-0.05764403870490665,-0.08976248305382799,0.5524038765026107},
{-0.04356857075008041,-0.0898616801584749,0.5537032082748421},
{-0.04116905290812845,-0.08371371415001609,0.5509414707022854},
{-0.02733706875561741,-0.08979329427572587,0.5532447974124586},
{-0.022452362844972963,-0.08244669658611666,0.5495827709659094},
{-0.013828978179642952,-0.09375291203621598,0.553664882120774},
{0.0,-0.0879784381566172,0.5488613374775679},
{-0.007063284746791875,-0.10153537579169811,0.5555376032175933},
{-0.013284145597301837,-0.10184499099711128,0.561105416462511},
{-0.021337146910911983,-0.09512363566406451,0.5595618493947473},
{-0.02733706875561741,-0.08979329427572587,0.5532447974124586},
{-0.03323704200245889,-0.09170809899269852,0.5588118591641593},
{-0.04356857075008041,-0.0898616801584749,0.5537032082748421},
{-0.04690820660652717,-0.09175544306537091,0.5587111590730782},
{-0.058503746945180075,-0.09416548181236119,0.5544674768765537},
{-0.06027576795091848,-0.09542122697800531,0.5591177169034872},
{0.03323704200245889,-0.09170809899269852,0.5588118591641593},
{0.04690820660652717,-0.09175544306537091,0.5587111590730782},
{0.04356857075008041,-0.0898616801584749,0.5537032082748421},
{0.02733706875561741,-0.08979329427572587,0.5532447974124586},
{0.021337146910911983,-0.09512363566406451,0.5595618493947473},
{0.013828978179642952,-0.09375291203621598,0.553664882120774},
{0.013284145597301837,-0.10184499099711128,0.561105416462511},
{0.007063284746791875,-0.10153537579169811,0.5555376032175933},
{0.022452362844972963,-0.08244669658611666,0.5495827709659094},
{0.02733706875561741,-0.08979329427572587,0.5532447974124586},
{0.04116905290812845,-0.08371371415001609,0.5509414707022854},
{0.04356857075008041,-0.0898616801584749,0.5537032082748421},
{0.05764403870490665,-0.08976248305382799,0.5524038765026107},
{0.058503746945180075,-0.09416548181236119,0.5544674768765537},
{0.03772571098773263,-0.0916434705760346,0.5653611225505077},
{0.050035921375773666,-0.09167202731828142,0.5650515073450948},
{0.026569042687820697,-0.09492298697511956,0.5662899681667473},
{0.017819407162030957,-0.10136704131108512,0.5678380441938132},
{0.010876361329962636,-0.10878578234952854,0.5695409278235855},
{0.0077929846605204545,-0.10931257909466109,0.5629465748442155},
{0.004059566358354049,-0.10940125529426971,0.5581753444093414},
{0.0,-0.10118367696613173,0.5530456517099477},
{-0.004059566358354049,-0.10940125529426971,0.5581753444093414},
{0.0,-0.10933662687760583,0.5562447583348112},
{0.0,-0.11260487087843546,0.5596963666805944},
{-0.0018343949427512467,-0.1136133747756793,0.5608889864160087},
{0.040879728019574894,-0.09148265102759184,0.5722072257575804},
{0.05242341532625327,-0.09149692939871526,0.5718683023167034},
{0.030071752572361284,-0.09479673611465983,0.5732217416005604},
{0.02101851378689456,-0.10129790393511909,0.5749133528320773},
{0.01328113962443375,-0.10878052189700936,0.5767732985442073},
{0.006421509539454897,-0.11503519994228535,0.5782958238018943},
{0.005137207631563918,-0.11498935885604697,0.5709341962479446},
{0.003577859206242804,-0.11496681405953632,0.5645930964827112},
{0.0018343949427512467,-0.1136133747756793,0.5608889864160087},
{0.06027576795091848,-0.09542122697800531,0.5591177169034872},
{0.06224242569986563,-0.09515219240631134,0.5653611225505077},
{0.058503746945180075,-0.09416548181236119,0.5544674768765537},
{-0.050035921375773666,-0.09167202731828142,0.5650515073450948},
{-0.06224242569986563,-0.09515219240631134,0.5653611225505077},
{-0.05242341532625327,-0.09149692939871526,0.5718683023167034},
{-0.06368679566298235,-0.09498010045961326,0.5722072257575804},
{-0.06389345629766346,-0.09652817648667905,0.5786625524918012},
{-0.06302097267270067,-0.09964612184410426,0.5844798614847702},
{-0.07120773977894077,-0.10611347246979752,0.5854673235719374},
{-0.07742334017693157,-0.11602115904301849,0.5873002155282547},
{-0.0733367200627647,-0.11840414403419598,0.5919767578177839},
{-0.07639078849674304,-0.12920235006958827,0.5941463187353271},
{-0.0777457307670341,-0.14108796679001176,0.5956793648980525},
{-0.06914489089821475,-0.14074453438983262,0.5992917927922783},
{-0.06883978465210373,-0.1295946295288739,0.5977196689822678},
{-0.05738026458573185,-0.13943693619221395,0.6014590992301703},
{-0.05852554024847372,-0.12849143748628525,0.5998110746052406},
{-0.04676617438850997,-0.1263895109582741,0.600531756600365},
{-0.0434024907491185,-0.13716517219715577,0.602363897063465},
{-0.03487680020200138,-0.1237863384545091,0.5999936874569771},
{-0.028162959801124838,-0.13392773941822403,0.602190302130333},
{-0.025087849557069896,-0.12058723182964554,0.5979999759522171},
{-0.01573251049836024,-0.12968255423526548,0.6004115176856414},
{-0.022084882661849096,-0.14530008627142132,0.602934280415185},
{0.0,-0.13987355375130386,0.602665997336708},
{0.0,-0.12830657015489783,0.5975220262661909},
{0.01573251049836024,-0.12968255423526548,0.6004115176856414},
{0.022084882661849096,-0.14530008627142132,0.602934280415185},
{0.028162959801124838,-0.13392773941822403,0.602190302130333},
{0.025087849557069896,-0.12058723182964554,0.5979999759522171},
{0.03487680020200138,-0.1237863384545091,0.5999936874569771},
{0.04676617438850997,-0.1263895109582741,0.600531756600365},
{0.05852554024847372,-0.12849143748628525,0.5998110746052406},
{0.06883978465210373,-0.1295946295288739,0.5977196689822678},
{-0.03772571098773263,-0.0916434705760346,0.5653611225505077},
{-0.040879728019574894,-0.09148265102759184,0.5722072257575804},
{-0.042771236446819835,-0.09311113682887898,0.5786625524918012},
{-0.05354464320605042,-0.09311639728139816,0.5783070962001498},
{-0.053601756690544115,-0.09645678463106193,0.5841973000351699},
{-0.05279841044154736,-0.10144369361922143,0.5893675733682828},
{-0.061227909856885636,-0.10418514087491848,0.589408154002002},
{-0.06835807749999248,-0.10972289439115526,0.5900912613362752},
{-0.0652611739526439,-0.11315872137938084,0.5930506416249087},
{-0.06732552581980396,-0.11976735272987428,0.5953201511403159},
{-0.05893435255853381,-0.1186791905516261,0.5971139654493479},
{-0.04935882598723664,-0.11657951850326599,0.5976242293437061},
{-0.03979231733454374,-0.11490819758860857,0.5971139654493479},
{-0.03196175801317217,-0.11278072029121868,0.5953201511403159},
{-0.019625996855752382,-0.11669975741798955,0.5943522278767911},
{-0.010182733090651123,-0.1243875330281269,0.5965030014639088},
{0.0,-0.12255013211250758,0.5919549645144904},
{0.010182733090651123,-0.1243875330281269,0.5965030014639088},
{0.019625996855752382,-0.11669975741798955,0.5943522278767911},
{0.03196175801317217,-0.11278072029121868,0.5953201511403159},
{0.03979231733454374,-0.11490819758860857,0.5971139654493479},
{0.04935882598723664,-0.11657951850326599,0.5976242293437061},
{0.05893435255853381,-0.1186791905516261,0.5971139654493479},
{0.06732552581980396,-0.11976735272987428,0.5953201511403159},
{0.07639078849674304,-0.12920235006958827,0.5941463187353271},
{0.0733367200627647,-0.11840414403419598,0.5919767578177839},
{0.0652611739526439,-0.11315872137938084,0.5930506416249087},
{0.06835807749999248,-0.10972289439115526,0.5900912613362752},
{0.059528032199981366,-0.11043380697445829,0.5935774383700412},
{0.061227909856885636,-0.10418514087491848,0.589408154002002},
{0.06302097267270067,-0.09964612184410426,0.5844798614847702},
{0.053601756690544115,-0.09645678463106193,0.5841973000351699},
{0.05354464320605042,-0.09311639728139816,0.5783070962001498},
{0.042771236446819835,-0.09311113682887898,0.5786625524918012},
{0.032393866612959954,-0.09639065322796399,0.5797289213667558},
{0.02323166131102501,-0.10283470756392955,0.5815062028250133},
{0.014981768774555041,-0.11025420009558994,0.5834615881757051},
{0.007339082757439032,-0.1164577766021084,0.5850615172347454},
{0.0,-0.11785630547898676,0.5789721676972144},
{0.0,-0.11778791959623773,0.571553426658771},
{0.0,-0.11734002963889249,0.565367134496244},
{0.0,-0.11480599451109356,0.5622649704963764},
{0.0,-0.1151734746942174,0.5600638468637182},
{-0.026569042687820697,-0.09492298697511956,0.5662899681667473},
{-0.030071752572361284,-0.09479673611465983,0.5732217416005604},
{-0.032393866612959954,-0.09639065322796399,0.5797289213667558},
{-0.04368956115802099,-0.09638163530935971,0.5844798614847702},
{-0.04392102106886383,-0.10114760529171467,0.589408154002002},
{-0.05132172627009869,-0.10813273474393623,0.593837455023131},
{-0.059528032199981366,-0.11043380697445829,0.5935774383700412},
{-0.010876361329962636,-0.10878578234952854,0.5695409278235855},
{-0.0077929846605204545,-0.10931257909466109,0.5629465748442155},
{-0.017819407162030957,-0.10136704131108512,0.5678380441938132},
{-0.01328113962443375,-0.10878052189700936,0.5767732985442073},
{-0.02101851378689456,-0.10129790393511909,0.5749133528320773},
{-0.02323166131102501,-0.10283470756392955,0.5815062028250133},
{-0.014981768774555041,-0.11025420009558994,0.5834615881757051},
{-0.006421509539454897,-0.11503519994228535,0.5782958238018943},
{-0.007339082757439032,-0.1164577766021084,0.5850615172347454},
{-0.03398327476696195,-0.09943269777046995,0.5854673235719374},
{-0.03528711549849551,-0.10365308367726676,0.5900912613362752},
{-0.04283285889061565,-0.10734516985249694,0.5935774383700412},
{-0.005137207631563918,-0.11498935885604697,0.5709341962479446},
{-0.003577859206242804,-0.11496681405953632,0.5645930964827112},
{0.0,-0.11734002963889249,0.565367134496244},
{0.0,-0.11778791959623773,0.571553426658771},
{0.0,-0.11785630547898676,0.5789721676972144},
{0.0,-0.11480599451109356,0.5622649704963764},
{0.0,-0.1151734746942174,0.5600638468637182},
{-0.03313859639102897,-0.21591414640891451,0.5582151735498435},
{-0.03333398462745475,-0.2117644008645178,0.5645352315050004},
{-0.03323704200245889,-0.2085104352348116,0.5707966729892295},
{-0.01692513023377451,-0.21374233101172033,0.5706133086442762},
{-0.016970971320012865,-0.21699930261429462,0.5643751634497747},
{-0.01681015177157011,-0.22105811747943163,0.5581370182552733},
{-0.08593625533935931,-0.22001429340098777,0.5383930369644484},
{-0.08993344776070052,-0.20196192334167995,0.5390265457463981},
{-0.09434020398531884,-0.18677950587817996,0.5401094474721271},
{-0.0969869630956711,-0.1726221251626983,0.5418311184323251},
{-0.09757162481851439,-0.15816264417397372,0.5443426087636133},
{-0.09579434336025683,-0.14207467738396196,0.5477942171093965},
{-0.09132220722575758,-0.12531562715114933,0.5513314956819201},
{-0.08818021408538766,-0.12682612851736402,0.5526586327031813},
{-0.0813574071680429,-0.1123290728677883,0.5534123803998546},
{-0.08382305641309282,-0.10884364732723925,0.5541007481866469},
{-0.07124907190587698,-0.09962432854081062,0.5534123803998546},
{-0.07296397942712168,-0.09361538877750092,0.5552475268358228},
{-0.05764403870490665,-0.08976248305382799,0.5524038765026107},
{-0.058412064772703366,-0.0805890053536377,0.5539173838416935},
{-0.040862443675583386,-0.0710330176059831,0.5513412650937412},
{-0.021007241388639228,-0.06621744907130471,0.5487493649882317},
{0.0,-0.06499401811399252,0.5474500332160002},
{0.021007241388639228,-0.06621744907130471,0.5487493649882317},
{0.040862443675583386,-0.0710330176059831,0.5513412650937412},
{0.058412064772703366,-0.0805890053536377,0.5539173838416935},
{0.05764403870490665,-0.08976248305382799,0.5524038765026107},
{0.07296397942712168,-0.09361538877750092,0.5552475268358228},
{0.07124907190587698,-0.09962432854081062,0.5534123803998546},
{0.08382305641309282,-0.10884364732723925,0.5541007481866469},
{0.0813574071680429,-0.1123290728677883,0.5534123803998546},
{0.09132220722575758,-0.12531562715114933,0.5513314956819201},
{0.08818021408538766,-0.12682612851736402,0.5526586327031813},
{-0.01651256045762931,-0.22754876439485258,0.5526330819338025},
{-0.0458914362838961,-0.19333327822383078,0.5818406173065882},
{-0.03174081900736764,-0.19978484749196654,0.5812634705159152},
{-0.030973544432787953,-0.1941764536133297,0.5857619089130102},
{-0.044084095096957654,-0.18905051838002113,0.5860752815845085},
{-0.030944987690541104,-0.18742579004481907,0.5900341478517815},
{-0.01605339810202873,-0.19051066970069533,0.5900612016075943},
{-0.01596171592955202,-0.19823902594455184,0.5856574513558441},
{-0.01621421765047149,-0.20455758091327467,0.5810710882523575},
{-0.032600527247641065,-0.20454029656928316,0.576323154107211},
{-0.047380895840034146,-0.19743643118877213,0.5769423845180374},
{-0.06033889338114835,-0.18942100453601304,0.57818084533969},
{-0.05814453318744345,-0.186104664969294,0.5831023744179685},
{-0.05500254004707354,-0.18319488323298394,0.5871326325408587},
{-0.051792912517171615,-0.1810696604152451,0.5898297416967515},
{-0.04351296025202077,-0.18390579581628697,0.5899537380775601},
{-0.03230368742691729,-0.1792465378707492,0.5942936114058636},
{-0.016695924802582734,-0.18117637245206225,0.5944642003661276},
{-0.01660424263010602,-0.20966021985685562,0.5761172449657469},
{-0.07086505887197862,-0.1815663974316968,0.5802451972068501},
{-0.06797707043896221,-0.1790000480955659,0.5853493391368649},
{-0.06343955439458204,-0.17694170817414204,0.5894697764457978},
{-0.05633268304120287,-0.1761083021964644,0.5923615223448994},
{-0.045735125694755484,-0.17721675469157216,0.5937810930318543},
{-0.03450405956635836,-0.16983408532754585,0.5981224693465916},
{-0.017751021279281933,-0.1702819752848911,0.5984140487147963},
{0.0,-0.1704758605348828,0.5984163031944474},
{0.017751021279281933,-0.1702819752848911,0.5984140487147963},
{0.008416724030648899,-0.11949456069209521,0.5911553757315786},
{0.01681616371730629,-0.1129715995683423,0.5893923726444444},
{0.025181786209197674,-0.105623498892299,0.5873002155282547},
{0.027591824956187946,-0.10931257909466109,0.5919767578177839},
{0.0,-0.11925558584908216,0.5857724298180486},
{0.03528711549849551,-0.10365308367726676,0.5900912613362752},
{0.03398327476696195,-0.09943269777046995,0.5854673235719374},
{0.036557890528480096,-0.10774947320325488,0.5930506416249087},
{0.04368956115802099,-0.09638163530935971,0.5844798614847702},
{0.04392102106886383,-0.10114760529171467,0.589408154002002},
{0.04283285889061565,-0.10734516985249694,0.5935774383700412},
{-0.027591824956187946,-0.10931257909466109,0.5919767578177839},
{-0.01681616371730629,-0.1129715995683423,0.5893923726444444},
{-0.025181786209197674,-0.105623498892299,0.5873002155282547},
{-0.008416724030648899,-0.11949456069209521,0.5911553757315786},
{0.0,-0.11925558584908216,0.5857724298180486},
{-0.036557890528480096,-0.10774947320325488,0.5930506416249087},
{0.05279841044154736,-0.10144369361922143,0.5893675733682828},
{0.05132172627009869,-0.10813273474393623,0.593837455023131},
{0.08363969206813938,-0.14084748896056465,0.590829227675391},
{0.0833759179489646,-0.1529848559086906,0.5912823780852554},
{0.08717095869492682,-0.15328921066158457,0.585485359409146},
{0.08435060465144241,-0.16406787787333435,0.5844881279101575},
{-0.07717234144244614,-0.1525324569920432,0.596034821189704},
{-0.07444291807822143,-0.1620035260061743,0.5946708610008087},
{-0.07544691301616312,-0.1714791039796075,0.5879051675679575},
{-0.06803268093702186,-0.15174113463451883,0.5995608273639722},
{-0.06529273666775884,-0.16110924907791782,0.5980533319706256},
{-0.06978892058520281,-0.16998062650486517,0.5922578162809503},
{-0.06127525392955803,-0.1691359481289322,0.5954321236296521},
{-0.049262634855457794,-0.16926971392156215,0.5972575006537991},
{-0.03700352600617427,-0.15938832961093696,0.6011028914453019},
{-0.01908116427341127,-0.15787031331255205,0.6014560932573023},
{0.0,-0.15697378190464456,0.6014666141623406},
{0.01908116427341127,-0.15787031331255205,0.6014560932573023},
{-0.055430891180776196,-0.1504222640386448,0.6016770322631069},
{-0.039927586113607735,-0.14835039723931454,0.602696057065389},
{-0.05260978564407478,-0.16035249540837646,0.6000831151498027},
{0.04325519807858214,-0.05305354238872643,0.553392090082995},
{0.02213072374808745,-0.04273028006649215,0.5492333266199939},
{0.04895602562291272,-0.03100848886737951,0.5555864502766997},
{0.0710642045744895,-0.05125446762717522,0.5605831286766806},
{0.0623664220806743,-0.06747620020981693,0.5572352263948466},
{0.07811546542980903,-0.08481089424686855,0.5586360097513761},
{0.08915339780143144,-0.10387176820342021,0.5554692173348444},
{0.09662549485828341,-0.12340908885956399,0.5497383300618328},
{0.08850110168905616,-0.07380828205644617,0.5613706935681199},
{0.09849295550258365,-0.09813111151858744,0.5548041458377797},
{0.10436963245969742,-0.12192038079664295,0.5449250160068055},
{-0.0623664220806743,-0.06747620020981693,0.5572352263948466},
{-0.07811546542980903,-0.08481089424686855,0.5586360097513761},
{-0.08915339780143144,-0.10387176820342021,0.5554692173348444},
{-0.09662549485828341,-0.12340908885956399,0.5497383300618328},
{-0.1016770322631068,-0.1421716200089578,0.5434483318353568},
{-0.10451467065058272,-0.1595529066254648,0.5378467013956733},
{-0.10534582214860928,-0.17494423920329696,0.5341824204694728},
{-0.10480098956626817,-0.18974414661933264,0.532056446158517},
{-0.10350842123298995,-0.20535040625723314,0.5310682325781328},
{-0.10256604873884408,-0.2232915553204217,0.5308059614453919},
{-0.10307255516711707,-0.24509462802588747,0.5308615719434517},
{-0.10487689038118742,-0.27089489315269444,0.5309427332108901},
{-0.10782875573765072,-0.3008276194799066,0.5307601203591537},
{0.1016770322631068,-0.1421716200089578,0.5434483318353568},
{0.10451467065058272,-0.1595529066254648,0.5378467013956733},
{0.10946250199145703,-0.1428772721397417,0.535776337582777},
{0.11334997640311298,-0.1612700686263606,0.5283801413408442},
{0.11439079450868876,-0.12278910695552064,0.5328500229956924},
{0.11903727706953716,-0.14471166708249295,0.5221885887257982},
{0.1237791992689474,-0.16342610266599736,0.5139033760081282},
{0.1156089650134818,-0.17736930781462767,0.5237592095493746},
{0.127248091958722,-0.1797545472854562,0.5088405662050495},
{0.13000306609232545,-0.1950857604059266,0.5062524235656249},
{0.13260323262322235,-0.21080699850603152,0.5053897093524834},
{0.13560695101166018,-0.22830551806439398,0.5055039363214707},
{0.13957483519753752,-0.24896857555963703,0.505848120214867},
{0.14438514327969676,-0.27341615289580395,0.5061028764154374},
{0.16284106519654554,-0.2738061778754385,0.48622287485233157},
{0.1787539340669911,-0.2729832928027992,0.46241857570993555},
{0.18621626171202177,-0.30086744862040876,0.46302503073607254},
{0.19853774449831818,-0.29754209113508545,0.4369091384581163},
{0.21262448485139976,-0.3223563971611592,0.40962918318699265},
{0.21725142858860555,-0.34469378154392777,0.3804006060041303},
{0.21343008558004756,-0.3630354764917892,0.34956458483005737},
{0.20291819846034068,-0.3789115221946007,0.31964914284683665},
{0.1878733042555558,-0.3971893402190152,0.29451920966961354},
{0.18466292523243685,-0.3634082171274322,0.2946394485843371},
{0.1989443023287272,-0.34511837521154537,0.32076135280802953},
{0.1822055424127742,-0.33237305025084846,0.2942667079486941},
{0.1950974085507904,-0.3141921748514298,0.3215752199620646},
{0.18015622040995458,-0.30458283108536666,0.2936309446870933},
{0.16543822575457434,-0.32860581475391604,0.2714994694457888},
{0.16565014684177462,-0.3031843022084883,0.26791033784129065},
{0.17816626637127972,-0.2805373026203066,0.2929598612442924},
{0.16598305833691546,-0.28164951258149945,0.2642295240643158},
{0.15302806676866934,-0.288397170177142,0.23782430689780595},
{0.15040535544126177,-0.30794275725867304,0.24530316739361113},
{0.11120596625494858,-0.09683403422600709,0.5450414974554441},
{0.12665516381049144,-0.10519439626537931,0.5191187389342623},
{0.12652365249751257,-0.12795261684968035,0.509469566027697},
{0.13028637903514284,-0.14819784411625903,0.5000916821724768},
{0.13550399644092812,-0.16613222974049438,0.49237459832687547},
{0.19064856870601887,-0.2704687964986428,0.43606070261609825},
{0.204855547973824,-0.2915797439512311,0.40922788580910274},
{0.1970467819557461,-0.2657847392769433,0.4085169732257996},
{0.21063528230594192,-0.31079767999014046,0.3809739953287181},
{0.20821547414713035,-0.3286749521298821,0.3508098090906631},
{0.18317196268986474,-0.24777595582422277,0.4350747435153651},
{0.17176805312155252,-0.2495532372824803,0.461551352537492},
{0.18960474462757498,-0.24417555182146927,0.4078060606424967},
{0.19647339263115812,-0.2584516684652404,0.38115735967367165},
{0.20358326995740536,-0.28231458407856413,0.3811340633839439},
{0.20273408262217024,-0.29802981023293285,0.35171911588326005},
{0.17648667903123508,-0.2286722467543008,0.4342721487595853},
{0.1655674825879022,-0.22981301345774055,0.4607434973291932},
{0.18293674531293683,-0.22595484728154844,0.4074047632646068},
{0.18968515440179637,-0.23841911377907904,0.38131817922211436},
{0.19112802137847903,-0.2506556778318519,0.35308833652467453},
{0.1968859624073033,-0.2723497840208494,0.35243829489195033},
{0.1911640930528961,-0.28697008455801676,0.3222515638573846},
{0.18693318624106098,-0.26428851628185207,0.3229512040424323},
{0.17589074491013645,-0.26073395336533695,0.2924841660379173},
{0.16592594485242176,-0.26428851628185207,0.2608470530944988},
{0.15510669700695282,-0.27308324140066315,0.23064904966167776},
{0.16689837707524852,-0.24903019800343285,0.25697085108109813},
{0.1583043006453824,-0.26003431318028924,0.22253292291783777},
{0.14150091231276546,-0.2852499165842529,0.20449858869573845},
{0.14674483198114655,-0.27372125914191503,0.1911701049986323},
{0.16428468366644522,-0.2472837277670732,0.21223220539211413},
{0.15559516759801728,-0.26207010830520244,0.17301628335502645},
{0.17519110472508875,-0.23283551917660392,0.1992388876697999},
{0.17035524587355075,-0.24678849373705555,0.1544160747405094},
{0.19316607098304334,-0.21469447291768745,0.183044960336188},
{0.1933283935179201,-0.2243669421139805,0.13974692714423562},
{0.2106991592293888,-0.19875905925073123,0.16797226088237327},
{0.21949388434819986,-0.19803988024204097,0.13410847353691785},
{0.24383024068824755,-0.1710394804476495,0.1425980924096179},
{0.2312013971761891,-0.19604842321693206,0.082780735321083},
{0.2644549720294225,-0.16349448854874638,0.08881372286733741},
{0.15677501194874216,-0.24984030769138277,0.4856660183785182},
{0.15150028105846317,-0.22961236476879562,0.48507008425741954},
{0.16046183767145317,-0.21299684974043429,0.46031289171583933},
{0.17097147031150897,-0.21236634693135262,0.4339738059524275},
{0.17745009333545755,-0.21032529135392025,0.40762269629754316},
{0.1835958048642653,-0.2214248461693385,0.38189081705348527},
{0.18591791890486398,-0.23196754451094323,0.3537872252165052},
{0.18321179183036695,-0.2445813581586613,0.3234171298369861},
{0.14723480555864504,-0.21241218801759096,0.48474919665375105},
{0.1559881985505199,-0.1979714943592919,0.46078482945612936},
{0.16618971897159657,-0.19790085399689183,0.4344780579010493},
{0.17274273982403035,-0.19651059154540074,0.4085402695155274},
{0.1785848480931611,-0.20667904626492842,0.38315257416486553},
{0.18143676485176047,-0.21572176414535685,0.35535934902651567},
{0.18080851652232988,-0.22628249832417016,0.3233930820540414},
{0.17453204517376028,-0.24308738964322113,0.2915695987928013},
{0.16170555894562497,-0.1843183655924322,0.4360832474126089},
{0.15168364540341658,-0.183601441063393,0.46268084684267646},
{0.16841413889398235,-0.1837337038695889,0.4102371411995635},
{0.17042062578343167,-0.1814747152592201,0.38746389075092214},
{0.17430810019508763,-0.19356624112110765,0.38503281019385516},
{0.17475148119313075,-0.18851620670271832,0.36279838038181866},
{0.17786792356412193,-0.20135095935624087,0.35862609004091134},
{0.1787900057414082,-0.1942673842925894,0.33210814889184814},
{0.17943178094874518,-0.20948136447120427,0.32543714360434184},
{0.17529631377547186,-0.22551221777672237,0.2895841537134286},
{0.1570846271541553,-0.1706614793594873,0.4390877172942637},
{0.14708525840845763,-0.16875494106790195,0.46652548614096206},
{0.16406224167420666,-0.17121758434008377,0.4127944726170901},
{0.16657899245801408,-0.16978974722774154,0.39037667846010027},
{0.16833297762654395,-0.16586244367558342,0.37134962169831454},
{0.17162677239675236,-0.17687632826426108,0.36708339470527934},
{0.1759328285302897,-0.1692742228808643,0.34841555170123034},
{0.177938563926522,-0.18080814077572138,0.34067667455233547},
{0.18823402099972644,-0.16943278794965597,0.31797105849322604},
{0.186831734656763,-0.1835202797959546,0.3035048140655483},
{0.18131502295060284,-0.20313951321275375,0.28504588617583143},
{0.17031992569235072,-0.2338049454265626,0.2518095956665895},
{0.17937090999816638,-0.21771472415689977,0.24063639451590313},
{0.19722939480748247,-0.19986300278653685,0.21872360380075212},
{0.22001016018829417,-0.1832910743647628,0.1860509332042769},
{0.2629873057765781,-0.14650097243222285,0.1653893786954679},
{0.23060020260257133,-0.16417759588301958,0.21033017605983087},
{0.2736134198652723,-0.12755733141752665,0.2026544243411659},
{0.2374786200179757,-0.1477439422131776,0.23927318582022478},
{0.20287761782662148,-0.18299273155760498,0.24815809012507856},
{0.2074729988487124,-0.16720536205440212,0.272725154882752},
{0.24066194528528187,-0.13414416946472643,0.269545587081531},
{0.21000027053755815,-0.15337938984762725,0.2939841464990937},
{0.2401659597620472,-0.12353533972002369,0.29781375593303894},
{0.20944642003661273,-0.14239556498763045,0.3134951648926417},
{0.187239043980389,-0.15800182462553095,0.33077950888415286},
{0.20598353929257435,-0.13392172747248784,0.32975522362935156},
{0.18433752866946623,-0.14844433389144232,0.34152360740791954},
{0.199783720252141,-0.12762646879349268,0.3412598332887447},
{0.1800224546173246,-0.13997575682881888,0.34979905071376827},
{0.17302004082111155,-0.15891939784351508,0.3552270862203198},
{0.16944969654703895,-0.14900043887203876,0.3610135839913909},
{0.16875155934842534,-0.13932947266217977,0.36557439632549876},
{0.1786246772336633,-0.13195957868284283,0.35592372043249937},
{0.17445313838597293,-0.12971787441646554,0.36870737154726446},
{0.18447655491461534,-0.12375778171226227,0.3602162496881303},
{0.143479593953185,-0.1969547240366609,0.48539698380682417},
{0.13973565474598026,-0.18195642241133134,0.48770782544916746},
{0.14173086923717426,-0.15229723961511527,0.4728410351368169},
{0.1518903060380977,-0.15597204144635393,0.4437890588599548},
{0.15928650228003044,-0.15818518897048436,0.41629192204911153},
{0.16243976781865566,-0.15789887005479888,0.3937020359454235},
{0.16470852584084578,-0.1549056725713994,0.3754617925818602},
{-0.16841413889398235,-0.1837337038695889,0.4102371411995635},
{-0.16406224167420666,-0.17121758434008377,0.4127944726170901},
{-0.15928650228003044,-0.15818518897048436,0.41629192204911153},
{-0.1518903060380977,-0.15597204144635393,0.4437890588599548},
{-0.14953963525525218,-0.14092188678904985,0.4485422534576203},
{0.15344965446341882,-0.12618134733715897,0.4517015309419818},
{0.14176318344550623,-0.1170356748859985,0.4852632180141942},
{0.13887218903962173,-0.1348498215955103,0.47972170703187234},
{0.14953963525525218,-0.14092188678904985,0.4485422534576203},
{0.1615342184921439,-0.13205201234853656,0.42166960751012267},
{0.1573544132190663,-0.14500700391678265,0.41962028550730296},
{-0.1573544132190663,-0.14500700391678265,0.41962028550730296},
{-0.16114419351250936,-0.1459448674516264,0.3966433803968485},
{0.0850532508093582,-0.5778558245233278,0.52401020828386},
{0.0775901716711105,-0.5758034965476402,0.5250833405977677},
{0.07746467230386779,-0.5908423788066889,0.5216151994012102},
{0.08487815288979202,-0.5943052595507273,0.5201813503431317},
{0.08140550273393232,-0.5619008720327291,0.5278353087585032},
{0.07105142918980013,-0.5758809003489935,0.5178306795602863},
{0.0733021513747817,-0.575459312654244,0.5229799110833225},
{0.07306693399785373,-0.58925973409164,0.5197229394807482},
{0.07065914973051453,-0.5886172073910861,0.5146661416234057},
{0.06970174737202822,-0.5761243841513087,0.5097694118212889},
{0.06987909977124547,-0.603019574895317,0.5161338078762502},
{0.06741345052619555,-0.6014376816734852,0.5111514078473928},
{0.0692140282741808,-0.5879754321837491,0.5066048738844083},
{0.06865341433428222,-0.5767601474129095,0.5002397263362302},
{0.06584884164835528,-0.5676219898939193,0.5027542226403864},
{-0.0733021513747817,-0.575459312654244,0.5229799110833225},
{-0.07105142918980013,-0.5758809003489935,0.5178306795602863},
{-0.07306693399785373,-0.58925973409164,0.5197229394807482},
{-0.07065914973051453,-0.5886172073910861,0.5146661416234057},
{-0.06987909977124547,-0.603019574895317,0.5161338078762502},
{-0.06741345052619555,-0.6014376816734852,0.5111514078473928},
{-0.0642601849875703,-0.6147616564112892,0.512476290389003},
{-0.061852400720231106,-0.6125605327786312,0.5075570157903755},
{-0.05678959091715238,-0.6245378316715313,0.5089728290112453},
{-0.054539620225387844,-0.6219662218828813,0.5041196858157159},
{-0.04804596733709882,-0.6323976992283667,0.505848120214867},
{-0.04603948044764948,-0.6296344586693761,0.5010776412732099},
{-0.03860871551773373,-0.6383953665934212,0.5033253574853234},
{-0.03691785577943374,-0.6355457043144729,0.4986698570058707},
{-0.04483558831397988,-0.6269854450793727,0.49373931000898785},
{-0.03590258844323671,-0.6327539070132353,0.4915832759693511},
{-0.035744774867662046,-0.629195586630635,0.4836490105840304},
{-0.044519961162830544,-0.623746509314007,0.48543906742697746},
{-0.05265712971674717,-0.6167921910836832,0.48788442635516766},
{-0.045179772207376054,-0.6192112477492778,0.47778510901160604},
{-0.0528607843785602,-0.613130164637134,0.47992385870725135},
{-0.0468991886879229,-0.6126747597476185,0.4723841272608674},
{-0.05391512936204238,-0.6078358949232125,0.4741764385834653},
{-0.05911846839670425,-0.6058023542779503,0.48317632135052346},
{-0.05941380523099399,-0.6016210460184387,0.4776956813187804},
{-0.0609528633394555,-0.5947027994625321,0.4757763676425057},
{-0.06464269503503461,-0.5896723038677854,0.4813877674940107},
{-0.0668235283508331,-0.5877304453949999,0.488771939844471},
{-0.06730899296902945,-0.5783563190058647,0.49068524157500953},
{-0.06444354933252372,-0.5704769126253867,0.4928525480129017},
{-0.06865341433428222,-0.5767601474129095,0.5002397263362302},
{-0.06584884164835528,-0.5676219898939193,0.5027542226403864},
{-0.06970174737202822,-0.5761243841513087,0.5097694118212889},
{-0.06685208509307995,-0.5660739138668535,0.5123380156370708},
{-0.0601209603482119,-0.5594570160909728,0.514001070126341},
{0.061852400720231106,-0.6125605327786312,0.5075570157903755},
{0.054539620225387844,-0.6219662218828813,0.5041196858157159},
{0.05678959091715238,-0.6245378316715313,0.5089728290112453},
{0.0642601849875703,-0.6147616564112892,0.512476290389003},
{0.051629838489077796,-0.6357350806051625,0.5078546071043163},
{0.04804596733709882,-0.6323976992283667,0.505848120214867},
{0.041673304856750366,-0.6417267360244806,0.5053604011170195},
{0.03860871551773373,-0.6383953665934212,0.5033253574853234},
{0.031471032942456664,-0.6459178136958136,0.5035891316044981},
{0.02905723672938128,-0.6425804323190178,0.501628485801287},
{0.02108314220355847,-0.6485720877383361,0.5024453589281903},
{0.019419336221071268,-0.6452234339632851,0.500607958012571},
{0.02773836613350728,-0.6396796685013121,0.4971330533770602},
{0.03691785577943374,-0.6355457043144729,0.4986698570058707},
{0.03860871551773373,-0.6383953665934212,0.5033253574853234},
{0.04603948044764948,-0.6296344586693761,0.5010776412732099},
{0.04804596733709882,-0.6323976992283667,0.505848120214867},
{-0.05678959091715238,-0.6245378316715313,0.5089728290112453},
{-0.051629838489077796,-0.6357350806051625,0.5078546071043163},
{-0.04804596733709882,-0.6323976992283667,0.505848120214867},
{-0.041673304856750366,-0.6417267360244806,0.5053604011170195},
{-0.03860871551773373,-0.6383953665934212,0.5033253574853234},
{-0.031471032942456664,-0.6459178136958136,0.5035891316044981},
{-0.02905723672938128,-0.6425804323190178,0.501628485801287},
{-0.02108314220355847,-0.6485720877383361,0.5024453589281903},
{-0.019419336221071268,-0.6452234339632851,0.500607958012571},
{-0.010572758070285657,-0.64995408376444,0.5018343949427513},
{-0.009723570735050546,-0.6465941575911336,0.5001149784622043},
{0.0,-0.6503268244000829,0.5016623029960532},
{0.0,-0.6469608862810405,0.5000000000000001},
{0.009723570735050546,-0.6465941575911336,0.5001149784622043},
{0.010572758070285657,-0.64995408376444,0.5018343949427513},
{0.01851604137421056,-0.6422971193762005,0.496278605589306},
{0.02694704377598288,-0.636801449480117,0.4902531329752217},
{0.03590258844323671,-0.6327539070132353,0.4915832759693511},
{0.04483558831397988,-0.6269854450793727,0.49373931000898785},
{0.05318918691439891,-0.6195606920951932,0.4965198349119701},
{0.00926515987266699,-0.6436588250854448,0.49591788884513527},
{0.017974214764737532,-0.6393753137484182,0.489553492790174},
{0.017958433407180067,-0.6355990603328814,0.4819934710269305},
{0.026883918345753013,-0.6330800550694229,0.4825570909396972},
{0.035744774867662046,-0.629195586630635,0.4836490105840304},
{0.044519961162830544,-0.623746509314007,0.48543906742697746},
{0.05265712971674717,-0.6167921910836832,0.48788442635516766},
{0.0,-0.6440255537753516,0.4958607753606416},
{0.008990113355236855,-0.6407227410865389,0.48928971867099924},
{0.008990113355236855,-0.6369502451370874,0.4817905678583345},
{0.0093568420451437,-0.6315034223001104,0.4749790333392451},
{0.018634025809283045,-0.630104893423232,0.47516089469776457},
{0.027749638531762613,-0.6276505165764374,0.4756140451076289},
{0.03662552491801209,-0.6240501125736839,0.47645120855139167},
{0.045179772207376054,-0.6192112477492778,0.47778510901160604},
{0.0528607843785602,-0.613130164637134,0.47992385870725135},
{0.0468991886879229,-0.6126747597476185,0.4723841272608674},
{0.05391512936204238,-0.6078358949232125,0.4741764385834653},
{0.05911846839670425,-0.6058023542779503,0.48317632135052346},
{0.05941380523099399,-0.6016210460184387,0.4776956813187804},
{-0.02773836613350728,-0.6396796685013121,0.4971330533770602},
{-0.01851604137421056,-0.6422971193762005,0.496278605589306},
{-0.00926515987266699,-0.6436588250854448,0.49591788884513527},
{-0.008990113355236855,-0.6407227410865389,0.48928971867099924},
{0.0,-0.6410902212696629,0.4892671738744886},
{0.0,-0.6373342581709858,0.48177929546007925},
{0.0,-0.6319392883659832,0.4749564885427345},
{0.038723693979938134,-0.6164938482765254,0.4715717630932663},
{-0.02694704377598288,-0.636801449480117,0.4902531329752217},
{-0.017974214764737532,-0.6393753137484182,0.489553492790174},
{-0.008990113355236855,-0.6369502451370874,0.4817905678583345},
{-0.026883918345753013,-0.6330800550694229,0.4825570909396972},
{-0.017958433407180067,-0.6355990603328814,0.4819934710269305},
{-0.018634025809283045,-0.630104893423232,0.47516089469776457},
{-0.027749638531762613,-0.6276505165764374,0.4756140451076289},
{-0.0093568420451437,-0.6315034223001104,0.4749790333392451},
{-0.03662552491801209,-0.6240501125736839,0.47645120855139167},
{0.05960318152168358,-0.60839425438346,0.4909437552416652},
{0.060407279263897364,-0.6105420219977095,0.4997249534825699},
{0.06593451187509582,-0.5999925602171515,0.5031532655386253},
{0.06813488401453688,-0.5875929221362848,0.49736526478112014},
{0.06730899296902945,-0.5783563190058647,0.49068524157500953},
{0.06444354933252372,-0.5704769126253867,0.4928525480129017},
{0.06491172960672857,-0.5986338604807754,0.4942315380661375},
{0.0668235283508331,-0.5877304453949999,0.488771939844471},
{0.06381680398952719,-0.5973097294323821,0.48647913403933624},
{0.06464269503503461,-0.5896723038677854,0.4813877674940107},
{0.06273315077058114,-0.5962418575709937,0.48161396695233427},
{-0.05960318152168358,-0.60839425438346,0.4909437552416652},
{-0.06381680398952719,-0.5973097294323821,0.48647913403933624},
{-0.06491172960672857,-0.5986338604807754,0.4942315380661375},
{-0.06273315077058114,-0.5962418575709937,0.48161396695233427},
{-0.06813488401453688,-0.5875929221362848,0.49736526478112014},
{-0.0692140282741808,-0.5879754321837491,0.5066048738844083},
{-0.05318918691439891,-0.6195606920951932,0.4965198349119701},
{-0.060407279263897364,-0.6105420219977095,0.4997249534825699},
{-0.06593451187509582,-0.5999925602171515,0.5031532655386253},
{-0.038723693979938134,-0.6164938482765254,0.4715717630932663},
{0.0468991886879229,-0.6126747597476185,0.4723841272608674},
{-0.0468991886879229,-0.6126747597476185,0.4723841272608674},
{0.10836231592173648,0.15904564870397483,0.5588020897523379},
{0.11240985838861818,0.14479808880245046,0.5571683434985315},
{0.12225291654517526,0.148232412804242,0.5603659471369612},
{0.1185615818631621,0.16139631948682026,0.5616690363752777},
{0.12909977124546473,0.15081830096401547,0.5627925187347259},
{0.133268304120287,0.1391160485885454,0.5618291044305034},
{0.12689263566707049,0.13596278304992016,0.559209399075964},
{0.11744411144945006,0.13145682972065492,0.5557976198706831},
{0.10532327735209862,0.17417095268298102,0.560533530124357},
{0.11588175705126086,0.1754492426451359,0.562964610681424},
{0.1259066765663373,0.16335696529003133,0.5638934562976635},
{0.13416558702141154,0.15298260142903947,0.5636409545767439},
{0.13786593962202898,0.1415929702318507,0.5628729285089473},
{0.14259658942318387,0.13095182627881596,0.5624768915835766},
{0.1383709430638679,0.12824569920431897,0.5611760568249111},
{0.13241911678505192,0.12459344216959099,0.5583519453153416},
{0.12372734623697287,0.17673880500554598,0.5649598251726181},
{0.1314789987705571,0.16513499824150588,0.5645930964827112},
{0.12979339948477625,0.1780636875471562,0.5655392264429421},
{0.13636445617441859,0.16693482449627406,0.5628842009072026},
{0.13866327392528954,0.15515291383979965,0.5621049024411505},
{-0.133268304120287,0.1391160485885454,0.5618291044305034},
{-0.12689263566707049,0.13596278304992016,0.559209399075964},
{-0.12225291654517526,0.148232412804242,0.5603659471369612},
{-0.12909977124546473,0.15081830096401547,0.5627925187347259},
{-0.1185615818631621,0.16139631948682026,0.5616690363752777},
{-0.14259658942318387,0.13095182627881596,0.5624768915835766},
{-0.13786593962202898,0.1415929702318507,0.5628729285089473},
{-0.13416558702141154,0.15298260142903947,0.5636409545767439},
{-0.1259066765663373,0.16335696529003133,0.5638934562976635},
{-0.11588175705126086,0.1754492426451359,0.562964610681424},
{-0.1314789987705571,0.16513499824150588,0.5645930964827112},
{-0.12372734623697287,0.17673880500554598,0.5649598251726181},
{-0.12979339948477625,0.1780636875471562,0.5655392264429421},
{0.10258859353535475,0.20682258146937965,0.5637844897811952},
{0.1138948089854541,0.20605831286766801,0.5651071178431544},
{0.11490406437591495,0.22232588653654808,0.5660201821018362},
{0.1033851763453983,0.22406333885430352,0.5652927366677589},
{0.11745838982057348,0.2390413501627734,0.5668716239167225},
{0.12395730316138168,0.22133391549007875,0.5671038353207825},
{0.12264369301802683,0.205887723907404,0.566519173597939},
{0.12260386387752463,0.1909698320562959,0.5658195334128914},
{0.11427281007361628,0.19038441884023552,0.5641001169323446},
{0.10331679046264929,0.1901439410107884,0.5621965846136272},
{0.10595378016118027,0.24172192646789165,0.566714561834365},
{0.12171484740178735,0.2560611685418927,0.5676945089893619},
{0.13083722356322014,0.2531656651767061,0.5681130907112432},
{0.12665140634440633,0.23714683576266038,0.5676201111608766},
{0.13105515659615655,0.22086348073622292,0.5673450646434466},
{0.12948077830649501,0.20611166888607663,0.5668806418353268},
{0.12909375929972855,0.19178369921033092,0.5662899681667473},
{0.1276952304228502,0.27283600013226283,0.5683167453730563},
{0.136547820519372,0.2688929152225472,0.5684512626589032},
{0.14380574200937263,0.26560438090485794,0.5682137908023243},
{0.1381642824291868,0.2509066765663373,0.568032680937022},
{0.13391609127336015,0.23585652190903322,0.5677178052790895},
{0.13670788857459773,0.2206913887895248,0.5655444868954613},
{0.13505084603106374,0.20653025060795804,0.5650515073450948},
{0.13452930973845031,0.19271254482657038,0.5644435493325237},
{0.13501101689056155,0.17944568357326002,0.5637213643509654},
{0.14381776590084497,0.2838280914176468,0.5685031156908779},
{0.15084648195965383,0.279540071121318,0.5681822280872092},
{0.14962004502947357,0.26304479500768024,0.5663185249089941},
{0.14395528915956005,0.24922107728055648,0.5661870135960153},
{0.1396319486820312,0.2349908017230236,0.5659232394768405},
{0.1526816283956221,0.29747370525233635,0.568136387000971},
{0.15929176273254958,0.29230268042600643,0.5678605889903239},
{0.16474459751526283,0.28811686320719265,0.5661178762200493},
{0.15656910280727807,0.276122279970301,0.5663012405650026},
{0.15434994333741142,0.2610307931860607,0.5631810407279264},
{0.1485935052950212,0.24796533211491234,0.5630164637133986},
{0.15622491891388188,0.11164446254708106,0.5627241328519769},
{0.1671982228688404,0.10252584385173343,0.5620703337531675},
{0.17907857913674471,0.08986618911777704,0.5572998548115105},
{0.20000541075116254,0.07997052643602834,0.5529772658271986},
{0.22442969179760183,0.07088873090831477,0.547341066699532},
{0.2504133212693622,0.06387053575454424,0.5410285236765453},
{0.2760189496529604,0.060167177181058774,0.5346761515130564},
{0.29930847594169613,0.06102688542133214,0.5289197134706661},
{0.32091766339717015,0.06604385413817251,0.5235187317199276},
{0.3414837782674174,0.07481002251473677,0.5182319769381761},
{0.34476329466650235,0.068325387545052,0.5121493908395982},
{0.36597719668982265,0.08118869694082144,0.5067168463737446},
{0.3874653937373561,0.0971534188432415,0.5011182219069291},
{0.39505697821571467,0.0926294296767677,0.49380769589173695},
{0.1483695603163486,0.12104489119881205,0.5626437230777556},
{0.1519819882105744,0.12388854153202415,0.5618291044305034},
{0.1596877996579203,0.11460609731536563,0.5621732883238997},
{0.1671982228688404,0.10252584385173343,0.5620703337531675},
{0.17046646686967004,0.10565581310063096,0.5617832633442651},
{0.18232878730036584,0.09346133266801135,0.5600345386282543},
{0.18527013175179083,0.09688363277833052,0.5600059818860075},
{0.2026544243411659,0.08422472953759116,0.5559697118173811},
{0.2514338490580784,0.06961570139867915,0.544399722248107},
{0.22630992782659143,0.07591096007767437,0.5505371673515275},
{0.2761624848574117,0.06643387911780708,0.5382194420313162},
{0.2986321320463761,0.06745966735904238,0.5326576407321347},
{0.31943571877320237,0.07234211879003583,0.5274347628738303},
{0.33916692467933784,0.08072728010556979,0.5222689985000195},
{0.3584201808994472,0.0922627009868609,0.5168792891475361},
{0.3616425838140385,0.08691883272061589,0.5128197227891821},
{0.3820305947918514,0.10196372692540073,0.5070407399502813},
{0.4014153623249397,0.11913534693435857,0.5014391095105976},
{0.4079300570233053,0.1153553360527368,0.4958149342744032},
{0.20505093621024975,0.08813474874575784,0.5561876448503176},
{0.22800755100384465,0.08038309621217356,0.5509873117885238},
{0.25234014987780723,0.07460336188005565,0.5450647937451717},
{0.27624815508415224,0.07177173543831591,0.5390791502715896},
{0.2979324918613284,0.07286064910978114,0.5336894409191063},
{0.3179590346017537,0.0775792750194637,0.5286100982652531},
{0.3368966636707137,0.08563453081272486,0.5235533004079106},
{0.3553127564470603,0.09673483712136009,0.5182319769381761},
{0.37377393881642823,0.11058711159073076,0.5123613119267986},
{0.377787664088544,0.10659593111512576,0.5109853278464308},
{0.3961263530635373,0.12295668994291657,0.5051913151431895},
{0.41229172365490224,0.14057244244313447,0.500102954570732},
{0.41856368604416977,0.13762583753919036,0.4965596640524722},
{0.42606884880257073,0.1349309828629487,0.49126764881820173},
{0.44058318879613795,0.15501539058108463,0.4879400368532274},
{0.4501722422453415,0.174743590514352,0.4862912607350806},
{0.4608306705423677,0.17514563938545893,0.4804837211539329},
{0.4322438685668423,0.15662659203838022,0.49294798765146347},
{0.4412227095238238,0.1753290037304123,0.4911474099034782},
{0.4251400031863312,0.15867290806833176,0.49632519816876136},
{0.4335281704747333,0.17648705477784354,0.4944614949905462},
{0.4381611261576753,0.19374735098640997,0.4940774819566479},
{0.4462223938966727,0.19345201415212024,0.4907694088153161},
{0.43974301937950705,0.21018776809520517,0.4947365415079764},
{0.4479651066669472,0.21071531633355475,0.4914224564209084},
{0.4389810052574466,0.22554227750540323,0.49600355907187577},
{0.44717378430942284,0.2268378518115495,0.4927187822202717},
{0.4445706118056578,0.24153856212293828,0.49426685824733746},
{0.4365784814426265,0.23954334763174423,0.49744266858247344},
{0.43919292634464685,0.2550008116126744,0.49670921120265965},
{0.4315848090155138,0.2523743428191817,0.4997647826230721},
{0.43007656212895023,0.2674079646257113,0.5006876162935754},
{0.42304784607014134,0.26422013039910297,0.5036808137769748},
{0.4246988766679392,0.2499552861535872,0.5004245936676176},
{0.4165917678427034,0.2613531837761632,0.5042654754998183},
{0.41001545070054196,0.2752625717300275,0.5099016746274848},
{0.40419588722792194,0.27206346510516394,0.5104690520063366},
{0.3915362324939655,0.2856857826501258,0.519138277757905},
{0.38659441309882736,0.2822687429923258,0.5197687805669866},
{0.36961442386021026,0.29540409293265724,0.5296937514841992},
{0.365684114335184,0.29182097327389517,0.5304219484114937},
{0.3462535057158574,0.3043310808576642,0.539870472629114},
{0.34336401429640695,0.30056985730646796,0.540684339783149},
{0.3234577104707053,0.3123810761984062,0.5479715695086136},
{0.3215308818622603,0.3083673509262906,0.5488147448981125},
{0.3032297675481181,0.3194676572349258,0.5523001704386616},
{0.30208374039215924,0.3150639069831756,0.5530689479996753},
{0.4555604486113909,0.19382325180132923,0.4859959239007908},
{0.4574707443690613,0.21195978910094354,0.48672712680095354},
{0.4566283204727794,0.2288586170721223,0.4881572183929468},
{0.4380521596412071,0.27126087034938423,0.4968467344613748},
{0.42328531792672036,0.2833696805552633,0.503009730334174},
{0.4162588563475626,0.27894338550700243,0.5068453517138554},
{0.40261925445860924,0.2948367155538054,0.5117075128279893},
{0.3967771461894785,0.2897911900947182,0.5158241926708369},
{0.37826937124065524,0.30558532303687425,0.5215761217539251},
{-0.4479651066669472,0.21071531633355475,0.4914224564209084},
{-0.4574707443690613,0.21195978910094354,0.48672712680095354},
{-0.4555604486113909,0.19382325180132923,0.4859959239007908},
{-0.4462223938966727,0.19345201415212024,0.4907694088153161},
{-0.4566283204727794,0.2288586170721223,0.4881572183929468},
{-0.44717378430942284,0.2268378518115495,0.4927187822202717},
{-0.4389810052574466,0.22554227750540323,0.49600355907187577},
{-0.43974301937950705,0.21018776809520517,0.4947365415079764},
{-0.4381611261576753,0.19374735098640997,0.4940774819566479},
{0.3737341096759261,0.29989351341114795,0.5260640392459817},
{0.3524518217698567,0.3155396021895507,0.5312530999095203},
{-0.4380521596412071,0.27126087034938423,0.4968467344613748},
{-0.43919292634464685,0.2550008116126744,0.49670921120265965},
{-0.43007656212895023,0.2674079646257113,0.5006876162935754},
{-0.4315848090155138,0.2523743428191817,0.4997647826230721},
{-0.4365784814426265,0.23954334763174423,0.49744266858247344},
{-0.4445706118056578,0.24153856212293828,0.49426685824733746},
{-0.42328531792672036,0.2833696805552633,0.503009730334174},
{-0.4162588563475626,0.27894338550700243,0.5068453517138554},
{-0.42304784607014134,0.26422013039910297,0.5036808137769748},
{-0.4246988766679392,0.2499552861535872,0.5004245936676176},
{-0.42943478692161324,0.23768565639926537,0.49821144614348717},
{-0.40261925445860924,0.2948367155538054,0.5117075128279893},
{-0.37826937124065524,0.30558532303687425,0.5215761217539251},
{0.32738200804999534,0.32462440369013223,0.5393744871058794},
{0.3492354308010016,0.309193241971798,0.5360062945071857},
{0.3253837875859333,0.3176325107989575,0.5440901070426939},
{0.3042848640248173,0.32515495790135,0.5487568799204018},
{0.30527683507128667,0.33276307523048293,0.5445778261405413},
{0.2856688740527428,0.33967756432030444,0.5477235767469963},
{0.28520445124462307,0.3253871693054099,0.5540661794986639},
{0.28552533884829157,0.331513342010575,0.5510737335084814},
{0.26869189078699374,0.3364611733514493,0.5521055336954528},
{0.26808994472015896,0.3450898184692985,0.549674453138386},
{0.25337195006477875,0.33975196214878967,0.552919400849488},
{0.25207336978576433,0.34872253668038394,0.5512916665414178},
{0.23915294690550123,0.34113997012062963,0.554582455338758},
{0.23715247196178807,0.3502961634768285,0.5534356766895822},
{0.22573728999522052,0.3406176823347992,0.5568068752611439},
{0.21282513354034466,0.3381813413252132,0.5593063417009597},
{0.20011963772014993,0.3338241836529184,0.5617952872357374},
{0.1873232112206955,0.32754019737217854,0.5639851384701402},
{-0.3524518217698567,0.3155396021895507,0.5312530999095203},
{-0.3737341096759261,0.29989351341114795,0.5260640392459817},
{-0.3492354308010016,0.309193241971798,0.5360062945071857},
{-0.3967771461894785,0.2897911900947182,0.5158241926708369},
{-0.32738200804999534,0.32462440369013223,0.5393744871058794},
{-0.3253837875859333,0.3176325107989575,0.5440901070426939},
{-0.30527683507128667,0.33276307523048293,0.5445778261405413},
{-0.3042848640248173,0.32515495790135,0.5487568799204018},
{-0.41001545070054196,0.2752625717300275,0.5099016746274848},
{-0.4165917678427034,0.2613531837761632,0.5042654754998183},
{-0.41835477092983764,0.24769028559748216,0.49928608144382897},
{-0.4229268556622008,0.2359309197375184,0.4971736340107794},
{-0.4317163203284928,0.2243609301682443,0.4968925755476132},
{-0.4324618015997788,0.20979849460878763,0.49573452450018196},
{-0.4309941353469344,0.1942087678216616,0.49517240757384934},
{0.26901277839066223,0.3299367092412624,0.554478749274809},
{0.25428952328276283,0.3329126223806704,0.55474853533972},
{0.240666454244584,0.3341105025686038,0.5560846902795855},
{0.2278700277451296,0.3335168229271563,0.5581144734587626},
{0.21562294278731842,0.3311180565784213,0.5604651442416081},
{0.2036516558401544,0.3268976706716245,0.562763961992479},
{0.1916803688929904,0.3208436413152935,0.5646389375689495},
{-0.26869189078699374,0.3364611733514493,0.5521055336954528},
{-0.2856688740527428,0.33967756432030444,0.5477235767469963},
{-0.28552533884829157,0.331513342010575,0.5510737335084814},
{-0.25337195006477875,0.33975196214878967,0.552919400849488},
{-0.21282513354034466,0.3381813413252132,0.5593063417009597},
{-0.22573728999522052,0.3406176823347992,0.5568068752611439},
{-0.23915294690550123,0.34113997012062963,0.554582455338758},
{-0.20011963772014993,0.3338241836529184,0.5617952872357374},
{0.16317397669168637,0.30933076523051306,0.5672188137829868},
{0.1748642051756841,0.31936395117097677,0.5658142729603723},
{0.16914759627379605,0.3034826450156461,0.5671729726967485},
{0.1800615322646098,0.31301759095322407,0.5661035978489259},
{0.1843360256830322,0.30775939291371956,0.5651033603770692},
{0.1740901671621512,0.29868962127747833,0.5657511475301424},
{0.19521238701299481,0.31524727132812896,0.5640768206426169},
{0.1879176423553601,0.30331881949433526,0.563135199641688},
{0.19812442322895596,0.3104775438796889,0.5626031424440363},
{0.20062464116198886,0.3062579094661092,0.5605222577261018},
{0.19103784219243639,0.299423078657292,0.5605222577261018},
{0.18191020557848445,0.29121301526132426,0.5601555290361949},
{0.17825870003697347,0.294687168403618,0.5632967706833478},
{0.1693287061390984,0.28467126680714583,0.5632742258868372},
{0.16131027351347127,0.2733590394113103,0.5632509295971094},
{0.2064494650871281,0.3210728467464853,0.5625745857017895},
{0.2086971812992416,0.3160731623736364,0.5615172347454391},
{0.2105774173282312,0.31162432252886485,0.5598797310255478},
{0.21227504050548443,0.3074497777083064,0.5579536539103197},
{0.20291819846034068,0.30231257007674245,0.5581370182552733},
{0.19392808510510384,0.29579937836481085,0.557586925220413},
{0.18530470043977382,0.28800263623820527,0.5566693520024288},
{0.1733334134926098,0.28171864995746543,0.5596963666805944},
{0.16539839661407219,0.27103166491819247,0.5594213201631643},
{0.21777897682695518,0.32515495790135,0.560498961436374},
{0.21945330371448066,0.320017750269786,0.5596911062280752},
{0.22080599150512067,0.3154313871662994,0.5583203826002267},
{0.22199861124053494,0.3111193190870259,0.5566693520024288},
{0.2315162728341214,0.3177474892611619,0.5563026233125221},
{0.2322730265036628,0.3134128763853778,0.5547425233939838},
{0.24291417045669744,0.3186417661894183,0.5542841125316003},
{0.2432808991466043,0.3144221317758386,0.5526330819338025},
{0.255207096500747,0.3181833553270348,0.5527247641062792},
{0.255207096500747,0.31423876743088514,0.5507979354978343},
{0.26860020861451706,0.3164398910635432,0.5520822374057253},
{0.26823347992461016,0.3129544655229942,0.5496977494281137},
{0.28332346372241646,0.31334373900941165,0.5512338015637072},
{0.2825441652563644,0.3103858617072122,0.548321765347746},
{0.299606818748854,0.3088257617886741,0.5490552227275596},
{0.298322516840963,0.3063495916385859,0.5456607278662703},
{0.3176779761385874,0.3028175735185814,0.5444230185378347},
{0.31575189902335943,0.30066153947894464,0.5407076360728769},
{0.3377683958024595,0.2952492853299506,0.53621220364865},
{0.3350164276417241,0.29313909237655217,0.5324509800974536},
{0.3545560027775189,0.2842414126870091,0.522452362844973},
{0.3582022478665108,0.28646583260939484,0.5260753116442372},
{0.37281127600542274,0.2744254082862648,0.5122696297543219},
{0.37730595693643276,0.27681064775709335,0.5156633731223942},
{0.3882228989001145,0.26415099302313694,0.5034628807440384},
{0.39340594761791686,0.2666279146664422,0.506628170174136},
{0.3992307715430561,0.2538765777600091,0.4975922157326609},
{0.4048263900370035,0.25626181723083763,0.5006192304108263},
{0.40656985430049514,0.2434187981519279,0.49401435652641806},
{0.4123721334291237,0.24552899110532625,0.49694968903210684},
{0.4168442695636229,0.23424532045173757,0.49493192974440214},
{0.4109728530590283,0.23259428985393973,0.4920875279179731},
{0.41904539319628104,0.22222819241833522,0.493876833267703},
{0.4131747281849034,0.22121893702787437,0.49117070619320596},
{0.41977960206931175,0.2092934911669487,0.4930967833084338},
{0.4139081855647171,0.20911012682199526,0.4906198616651286},
{0.4184494590751824,0.19546451298730572,0.4929367152532081},
{0.4126238836568261,0.19617542557060874,0.4907115438376053},
{0.2417215507212832,0.32820526886924317,0.5563251681090328},
{0.22945192096696135,0.32752291302818703,0.5582745415139884},
{0.23062199590586496,0.32235865164081023,0.5575749013289406},
{0.24243246330458623,0.32314245906616446,0.5556202674714658},
{0.25483961631762314,0.3272305821667653,0.5550754348891246},
{0.2551154143282703,0.322417268111738,0.554275846106213},
{0.2846994478027841,0.3205280141641441,0.5546966823077455},
{0.2840576725954472,0.3166194979424115,0.5535559156043057},
{0.30086782436701726,0.31162432252886485,0.5517560893495376},
{0.26889855142167485,0.3202296713569863,0.5539917816701786},
{0.26905861947690063,0.32462740966300035,0.5549491840286649},
{0.31960480474703234,0.30528322276363135,0.5473778898671662},
{0.3215308818622603,0.3083673509262906,0.5488147448981125},
{0.34054366025292254,0.2976345248007792,0.5392106615845685},
{0.361895837028175,0.28891645199010435,0.5289738209822918},
{0.3818757871891449,0.2793679791746199,0.5183867845408828},
{0.3986949568793192,0.269225075224471,0.5091704717273222},
{0.41835477092983764,0.24769028559748216,0.49928608144382897},
{0.4229268556622008,0.2359309197375184,0.4971736340107794},
{0.42943478692161324,0.23768565639926537,0.49821144614348717},
{0.4317163203284928,0.2243609301682443,0.4968925755476132},
{0.4251490211049355,0.22326600455104287,0.4959840202482333},
{0.4105655437354022,0.25872746647588757,0.503044299022157},
{0.4324618015997788,0.20979849460878763,0.49573452450018196},
{0.42588548445761726,0.20951142419988517,0.494995055174632},
{-0.4105655437354022,0.25872746647588757,0.503044299022157},
{-0.4123721334291237,0.24552899110532625,0.49694968903210684},
{-0.4048263900370035,0.25626181723083763,0.5006192304108263},
{-0.40656985430049514,0.2434187981519279,0.49401435652641806},
{-0.4168442695636229,0.23424532045173757,0.49493192974440214},
{-0.4251490211049355,0.22326600455104287,0.4959840202482333},
{-0.42588548445761726,0.20951142419988517,0.494995055174632},
{-0.4244982279789942,0.19479493253093894,0.49460803616786553},
{-0.3992307715430561,0.2538765777600091,0.4975922157326609},
{-0.4109728530590283,0.23259428985393973,0.4920875279179731},
{-0.41904539319628104,0.22222819241833522,0.493876833267703},
{-0.4131747281849034,0.22121893702787437,0.49117070619320596},
{-0.41977960206931175,0.2092934911669487,0.4930967833084338},
{0.4266369776746395,0.1778059253737176,0.4956428423277051},
{0.4309941353469344,0.1942087678216616,0.49517240757384934},
{0.4244982279789942,0.19479493253093894,0.49460803616786553},
{0.4203469794481635,0.17924503488431515,0.49522426060582375},
{0.41871323319435716,0.1608003853657217,0.4975801918411885},
{0.40654655801076744,0.14340482037809124,0.5014218251666062},
{0.3912093329445609,0.12640529231583153,0.5065530208524337},
{0.41279296963065615,0.16298723062725634,0.49724502586639646},
{0.41445903009279433,0.18076380267591702,0.49373931000898785},
{0.4087709779331532,0.18232390259445513,0.4917207992280662},
{0.407211629507832,0.1652146565225102,0.49584875146916924},
{0.40179937535883803,0.16746237273462372,0.4939226743539412},
{0.39611207469241383,0.148840370816813,0.4996099750203654},
{0.3911582314058033,0.15150065680507166,0.4975922157326609},
{0.38212227696432816,0.13255701579037546,0.50449468093101},
{0.37776511929203327,0.13544725870304294,0.5022702610086242},
{0.36620640212101446,0.11728366764761579,0.50997607245597},
{0.36253686074229496,0.12031068232578133,0.5074991508126648},
{0.3463917804677895,0.1071009345569647,0.5128197227891821},
{0.3493271129734783,0.10393564512686711,0.5155258498636791},
{0.330245948700067,0.09682651929383686,0.5177735660757926},
{0.3324478238259422,0.09343202443254749,0.5206172164090047},
{0.3135500238974843,0.08957911870887454,0.5225440450174497},
{0.3150176901503287,0.08593287361988267,0.5254793775231384},
{0.295753913025181,0.08545116646777141,0.5273137724658898},
{0.29648737040499473,0.08159826074409848,0.5303415386372722},
{0.27630602006186294,0.08453434474300431,0.5322676157525003},
{0.27630602006186294,0.0805897568468547,0.5354329051825978},
{0.25465625197266967,0.08691883272061589,0.5375881877290176},
{0.253922794592856,0.08306592699694296,0.540982682590307},
{0.2324563908486162,0.09187267600722633,0.5427253953605815},
{0.23103456568201014,0.08822643091823452,0.5463949367393011},
{0.21135746728750027,0.09866091423658813,0.5471291456123317},
{0.20933895650657855,0.0952671708685157,0.5510737335084814},
{0.1930105118871197,0.10655009002888743,0.5502478424629739},
{0.19053359024381444,0.10338555209200678,0.5544216357903153},
{0.17906655524527235,0.11480674600431057,0.551532144370865},
{0.17631458708453698,0.11177897983292799,0.5558434609569214},
{0.16879213998214454,0.12342937917642355,0.551532144370865},
{0.16588010376618342,0.12049404667073477,0.5559351431293981},
{0.17347694869706107,0.10873468081077102,0.559484445593394},
{0.16287563388452858,0.1175542052057438,0.5596963666805944},
{0.15530133375016159,0.12673219186523624,0.559174830387981},
{-0.4184494590751824,0.19546451298730572,0.4929367152532081},
{-0.4203469794481635,0.17924503488431515,0.49522426060582375},
{-0.4139081855647171,0.20911012682199526,0.4906198616651286},
{-0.4126238836568261,0.19617542557060874,0.4907115438376053},
{-0.41279296963065615,0.16298723062725634,0.49724502586639646},
{-0.41445903009279433,0.18076380267591702,0.49373931000898785},
{-0.4087709779331532,0.18232390259445513,0.4917207992280662},
{-0.407211629507832,0.1652146565225102,0.49584875146916924},
{0.38657261979553376,0.12957433921201425,0.5061216637458631},
{0.3699330569842276,0.11409583342100754,0.5118112188919384},
{0.4011974292920032,0.14615152808630752,0.5010723808206907},
{0.35229100222141396,0.10055317415705001,0.5175556330428562},
{-0.39611207469241383,0.148840370816813,0.4996099750203654},
{-0.4011974292920032,0.14615152808630752,0.5010723808206907},
{-0.38657261979553376,0.12957433921201425,0.5061216637458631},
{-0.38212227696432816,0.13255701579037546,0.50449468093101},
{-0.3699330569842276,0.11409583342100754,0.5118112188919384},
{-0.40179937535883803,0.16746237273462372,0.4939226743539412},
{-0.3911582314058033,0.15150065680507166,0.4975922157326609},
{-0.37776511929203327,0.13544725870304294,0.5022702610086242},
{-0.36620640212101446,0.11728366764761579,0.50997607245597},
{-0.35229100222141396,0.10055317415705001,0.5175556330428562},
{-0.3463917804677895,0.1071009345569647,0.5128197227891821},
{-0.36253686074229496,0.12031068232578133,0.5074991508126648},
{-0.3493271129734783,0.10393564512686711,0.5155258498636791},
{-0.3324478238259422,0.09343202443254749,0.5206172164090047},
{-0.3346609713500726,0.0897857793435556,0.5227732504486414},
{-0.3164868593896072,0.08202135142528207,0.52773009970812},
{-0.29721556733228927,0.07748759284698693,0.5326922094201177},
{-0.2762917416907395,0.07641295754664522,0.5379263596766776},
{-0.25316002897757844,0.07902439647579736,0.5437000820630593},
{-0.22956689942916575,0.08444191107731058,0.5493776133176621},
{-0.20725807178864405,0.09178700578048583,0.5543239416721025},
{-0.18797926479915592,0.10017742754853894,0.5579048068512134},
{-0.17347694869706107,0.10873468081077102,0.559484445593394},
{-0.16287563388452858,0.1175542052057438,0.5596963666805944},
{-0.15530133375016159,0.12673219186523624,0.559174830387981},
{-0.1463976421148823,0.13365795335331307,0.5614052622561029},
{0.3164868593896072,0.08202135142528207,0.52773009970812},
{0.29721556733228927,0.07748759284698693,0.5326922094201177},
{0.2762917416907395,0.07641295754664522,0.5379263596766776},
{0.3346609713500726,0.0897857793435556,0.5227732504486414},
{-0.3150176901503287,0.08593287361988267,0.5254793775231384},
{-0.3135500238974843,0.08957911870887454,0.5225440450174497},
{-0.295753913025181,0.08545116646777141,0.5273137724658898},
{-0.29648737040499473,0.08159826074409848,0.5303415386372722},
{-0.27630602006186294,0.0805897568468547,0.5354329051825978},
{-0.253922794592856,0.08306592699694296,0.540982682590307},
{-0.23103456568201014,0.08822643091823452,0.5463949367393011},
{-0.20933895650657855,0.0952671708685157,0.5510737335084814},
{-0.19053359024381444,0.10338555209200678,0.5544216357903153},
{-0.17631458708453698,0.11177897983292799,0.5558434609569214},
{-0.16588010376618342,0.12049404667073477,0.5559351431293981},
{-0.15842604254653997,0.12957584219844834,0.5552933679220612},
{-0.14988081317578028,0.13636408042781006,0.5585525940042866},
{-0.1419826194648767,0.14406989187515593,0.5615540579130733},
{-0.1457385825635538,0.14654681351846113,0.5584639178046779},
{-0.13866327392528954,0.15515291383979965,0.5621049024411505},
{-0.14273561566833298,0.15732698371664497,0.5587795449558273},
{-0.14925256484634972,0.14902373516176645,0.5541924303591236},
{-0.14652389297534202,0.15950481105957534,0.5542615677350896},
{-0.330245948700067,0.09682651929383686,0.5177735660757926},
{-0.27630602006186294,0.08453434474300431,0.5322676157525003},
{-0.25465625197266967,0.08691883272061589,0.5375881877290176},
{-0.2324563908486162,0.09187267600722633,0.5427253953605815},
{-0.21135746728750027,0.09866091423658813,0.5471291456123317},
{-0.1930105118871197,0.10655009002888743,0.5502478424629739},
{-0.17906655524527235,0.11480674600431057,0.551532144370865},
{-0.16879213998214454,0.12342937917642355,0.551532144370865},
{-0.16145380871792253,0.13241949253166035,0.5507979354978343},
{-0.153151311656261,0.13907020750230706,0.554513317962792},
{-0.1563166010863586,0.14177633457680414,0.5498811137730671},
{-0.1526470597076391,0.15150065680507166,0.5493302692449898},
{0.22956689942916575,0.08444191107731058,0.5493776133176621},
{0.20725807178864405,0.09178700578048583,0.5543239416721025},
{0.18797926479915592,0.10017742754853894,0.5579048068512134},
{0.25316002897757844,0.07902439647579736,0.5437000820630593},
{0.1463976421148823,0.13365795335331307,0.5614052622561029},
{0.14988081317578028,0.13636408042781006,0.5585525940042866},
{0.15842604254653997,0.12957584219844834,0.5552933679220612},
{0.16145380871792253,0.13241949253166035,0.5507979354978343},
{0.153151311656261,0.13907020750230706,0.554513317962792},
{0.1563166010863586,0.14177633457680414,0.5498811137730671},
{0.14925256484634972,0.14902373516176645,0.5541924303591236},
{0.1526470597076391,0.15150065680507166,0.5493302692449898},
{0.14652389297534202,0.15950481105957534,0.5542615677350896},
{0.15017013806433385,0.16168338989572276,0.5491469049000365},
{0.14475788391533978,0.17058182107848288,0.5546508412215071},
{0.14861078963901272,0.17241621602123416,0.5493302692449898},
{0.14374862852487894,0.18232390259445513,0.5552933679220612},
{0.1476932164210286,0.1837915688472996,0.5498811137730671},
{0.1432902176624954,0.19479944149024112,0.5561185074743515},
{0.14714312338616833,0.19590037905317864,0.5507979354978343},
{0.14365694635240223,0.20775743903135532,0.557013535895825},
{0.14732648773112175,0.20846835161465835,0.5518988730607717},
{0.14512461260524664,0.22094389051044425,0.557861971737843},
{0.14861078963901272,0.22121893702787437,0.5529998106237093},
{0.14796826293845872,0.23410779719302255,0.5585495880314184},
{0.15136275779974812,0.23387859176183076,0.5539173838416935},
{0.15246369536268567,0.24699665735817072,0.5589629093007806},
{0.15594987239645175,0.24617076631266324,0.5544674768765537},
{0.15835765666379095,0.25938126557469693,0.559214659528483},
{0.1620039017527828,0.2579128478286355,0.5548342055664607},
{0.1691596201652684,0.26892147196479405,0.5552016857495845},
{0.14418750056361992,0.23444371466103145,0.5627091029876364},
{0.14127771882730986,0.22074324182149932,0.5622138689576188},
{0.13967102632931636,0.2070946220139417,0.561579608682452},
{0.13917353781964764,0.19372706066955037,0.5608604296737618},
{0.13959211954152903,0.1808697632195172,0.5601066819770885},
{0.14073288624496874,0.16875268658825085,0.5593694671311897},
{0.14273561566833298,0.15732698371664497,0.5587795449558273},
{0.1457385825635538,0.14654681351846113,0.5584639178046779},
{0.1419826194648767,0.14406989187515593,0.5615540579130733},
{0.1770487959575677,0.27901252288296846,0.5557517787844447},
{-0.15594987239645175,0.24617076631266324,0.5544674768765537},
{-0.15136275779974812,0.23387859176183076,0.5539173838416935},
{-0.1432902176624954,0.19479944149024112,0.5561185074743515},
{-0.13917353781964764,0.19372706066955037,0.5608604296737618},
{-0.13967102632931636,0.2070946220139417,0.561579608682452},
{-0.14365694635240223,0.20775743903135532,0.557013535895825},
{-0.14127771882730986,0.22074324182149932,0.5622138689576188},
{-0.14512461260524664,0.22094389051044425,0.557861971737843},
{-0.14732648773112175,0.20846835161465835,0.5518988730607717},
{-0.14861078963901272,0.22121893702787437,0.5529998106237093},
{-0.14374862852487894,0.18232390259445513,0.5552933679220612},
{-0.13959211954152903,0.1808697632195172,0.5601066819770885},
{-0.1476932164210286,0.1837915688472996,0.5498811137730671},
{-0.14714312338616833,0.19590037905317864,0.5507979354978343},
{-0.13501101689056155,0.17944568357326002,0.5637213643509654},
{-0.14073288624496874,0.16875268658825085,0.5593694671311897},
{-0.13636445617441859,0.16693482449627406,0.5628842009072026},
{-0.15017013806433385,0.16168338989572276,0.5491469049000365},
{-0.14475788391533978,0.17058182107848288,0.5546508412215071},
{-0.14861078963901272,0.17241621602123416,0.5493302692449898},
{0.09854556002777519,0.3859958487514691,0.4467634690129287},
{0.12265872288236727,0.4152582431290975,0.4533803667888093},
{0.13775997907842885,0.44481672583423265,0.45829588392135173},
{0.14895497353240889,0.47133466698329585,0.46351274983392005},
{0.1570500584661723,0.48953432971314015,0.4683997102242155},
{0.17047398180184026,0.5144651171878524,0.4775934782412654},
{0.16456874810247962,0.5258404700139178,0.4975749313886693},
{-0.049857817483339395,0.36613914347809096,0.4949018700157212},
{-0.03252162045985373,0.35124980836922964,0.4939722729062648},
{-0.03536527079306582,0.3513257091841489,0.4719106865341433},
{-0.05675953118847149,0.36508780446747685,0.47164916689461955},
{-0.03660824057402058,0.35448047770920815,0.4532278136657538},
{-0.06127299944990696,0.36667646112826185,0.45154522035284117},
{-0.07852653221952019,0.38588763372821794,0.47197982391010934},
{-0.09854556002777519,0.3859958487514691,0.4467634690129287},
{-0.09807061631461715,0.4145939231252499,0.47421777071040166},
{-0.12265872288236727,0.4152582431290975,0.4533803667888093},
{-0.15441457175407536,0.4034778354590571,0.4298962037568648},
{-0.1635700136170571,0.4231256256181032,0.4376155420821171},
{-0.2127883103727106,0.41579931824535354,0.4176032777128154},
{-0.21303855761397897,0.43403129518352973,0.4270044578577634},
{-0.26330142994129335,0.4438089734302058,0.42162827538318637},
{-0.2734721391404721,0.42447305295622395,0.4088040436347022},
{-0.3044329081885707,0.4534611523096393,0.42460569150902844},
{-0.3379134339933448,0.42787130528359857,0.4050375596309868},
{-0.2723832254690069,0.4137191850206359,0.39199764932921716},
{-0.2127883103727106,0.41579931824535354,0.4176032777128154},
{-0.20757294744657637,0.4082836345819143,0.40498796107866325},
{-0.15441457175407536,0.4034778354590571,0.4298962037568648},
{-0.1458340222021156,0.3986630184175958,0.4188101758193531},
{-0.09854556002777519,0.3859958487514691,0.4467634690129287},
{-0.09390734389231403,0.38653767536094225,0.4305379789642019},
{-0.06746304907851902,0.3879572460478971,0.49611402857477815},
{-0.08474739307003015,0.41725045164742336,0.4977913614351718},
{-0.10225643353343093,0.44972773400747285,0.4993980539331652},
{-0.11561798293208604,0.4460078425832128,0.4773003958866267},
{-0.13775997907842885,0.44481672583423265,0.45829588392135173},
{-0.17118639737157731,0.4496999287584431,0.44406936582990403},
{-0.2100258213069369,0.45796860862533856,0.4351852130182673},
{-0.24840382840704478,0.4669339227044137,0.4322108028652934},
{-0.27962010514893093,0.4767394062001196,0.43664461284572453},
{-0.2969773439824932,0.4875285943169078,0.4499843689410859},
{-0.3265072699453815,0.46399032377333765,0.4390576575655828},
{-0.3602996654352198,0.4399297654439372,0.42708261315233365},
{-0.3909162505899222,0.41041411785217224,0.389218627412669},
{-0.333558530800701,0.4126618340642857,0.3783257332319319},
{-0.3276713329385489,0.4096866724180947,0.3533964487436536},
{-0.2654694878724025,0.4131848733433332,0.37162091074965964},
{-0.11443964156779521,0.484865302355781,0.5233007986869911},
{-0.12053575454427949,0.4810965638724146,0.5003952854321536},
{-0.1313948315302506,0.47492755605387904,0.4801620820570473},
{-0.14895497353240889,0.47133466698329585,0.46351274983392005},
{-0.17515277857102063,0.47529428474378593,0.45135734704858554},
{-0.2054507306017056,0.4826025562793271,0.44413850320587006},
{-0.23531056208686663,0.48905487704067985,0.44229584183773163},
{-0.2590517357990327,0.4966073838717533,0.44696186322222253},
{-0.2709952174971669,0.507218468096107,0.45926681315774454},
{-0.30430891180776204,0.49702671708685153,0.46938116036564653},
{-0.3355379639343375,0.4732081395733322,0.4602136946111924},
{-0.3691845697400735,0.44860274866159067,0.4500963414304222},
{-0.4057837923954898,0.42589562961604716,0.4391839084260425},
{-0.3990692005013963,0.41867302830724656,0.41465592131565426},
{-0.4385736959338205,0.39952197516465215,0.40247271328128986},
{-0.4326677107412429,0.3933950509662699,0.37535207457217495},
{-0.3843917864797352,0.40280299455017127,0.3624587054477246},
{-0.3788081918772601,0.4004568327266278,0.3342619284518338},
{-0.14861078963901272,0.4986484394491856,0.480896290930078},
{-0.14087642144942,0.507690405836397,0.5000375746608511},
{-0.1570500584661723,0.48953432971314015,0.4683997102242155},
{-0.1750535814663737,0.4976399355519418,0.4617692855704284},
{-0.2001925325622011,0.5052420409353386,0.4560323863516808},
{-0.22556895551460754,0.5090145368847901,0.4541401264312188},
{-0.24408274240916703,0.5092670386057095,0.4552854020939608},
{-0.24632369518232727,0.520710777314524,0.4661805507543489},
{-0.27496084720339314,0.5173726444445113,0.47744393109107797},
{-0.3054489270179847,0.5029605075284591,0.491984573347241},
{-0.3375391903712677,0.4789254999684373,0.48330407519741725},
{-0.3715495188940425,0.4539165571991547,0.4737067553228265},
{-0.44317584039486463,0.4051401384551103,0.4280896140631435},
{-0.47920092223247596,0.3863881282107548,0.41742667680681517},
{-0.47456796654953387,0.3817784688175404,0.3912251143021183},
{-0.46863943656044565,0.3769050353051514,0.3630396097044828},
{-0.4266249537831671,0.3882841455973019,0.3465368186586748},
{-0.1360202722810224,0.512661533466999,0.5226011585019433},
{-0.16049039441370003,0.53183362841967,0.520457148353779},
{-0.16456874810247962,0.5258404700139178,0.4975749313886693},
{-0.17047398180184026,0.5144651171878524,0.4775934782412654},
{-0.19513047425233943,0.5231959653832164,0.47303492038680856},
{-0.22072483023768227,0.5256571056689644,0.4700003907764728},
{0.19067261648896355,0.5358135364970197,0.4938001809595667},
{0.21824565411472596,0.5378748823913115,0.48950690021071863},
{0.24657920287611484,0.531802065704555,0.48421488497644816},
{0.19513047425233943,0.5231959653832164,0.47303492038680856},
{0.22072483023768227,0.5256571056689644,0.4700003907764728},
{0.24632369518232727,0.520710777314524,0.4661805507543489},
{0.27496084720339314,0.5173726444445113,0.47744393109107797},
{0.2001925325622011,0.5052420409353386,0.4560323863516808},
{0.22556895551460754,0.5090145368847901,0.4541401264312188},
{0.24408274240916703,0.5092670386057095,0.4552854020939608},
{0.2709952174971669,0.507218468096107,0.45926681315774454},
{0.30430891180776204,0.49702671708685153,0.46938116036564653},
{0.1750535814663737,0.4976399355519418,0.4617692855704284},
{0.2054507306017056,0.4826025562793271,0.44413850320587006},
{0.23531056208686663,0.48905487704067985,0.44229584183773163},
{0.2590517357990327,0.4966073838717533,0.44696186322222253},
{0.2969773439824932,0.4875285943169078,0.4499843689410859},
{0.3355379639343375,0.4732081395733322,0.4602136946111924},
{-0.21824565411472596,0.5378748823913115,0.48950690021071863},
{-0.19067261648896355,0.5358135364970197,0.4938001809595667},
{-0.24657920287611484,0.531802065704555,0.48421488497644816},
{-0.27476921643305247,0.5235551791409531,0.4997249534825699},
{-0.21560039799080774,0.5445624205295924,0.5122921745508325},
{-0.18722551710248264,0.5424462156304578,0.5169822437182682},
{-0.24498979472211285,0.5382438655608694,0.5065019193136763},
{0.3715495188940425,0.4539165571991547,0.4737067553228265},
{0.3691845697400735,0.44860274866159067,0.4500963414304222},
{0.3044329081885707,0.4534611523096393,0.42460569150902844},
{0.27962010514893093,0.4767394062001196,0.43664461284572453},
{0.3265072699453815,0.46399032377333765,0.4390576575655828},
{0.3602996654352198,0.4399297654439372,0.42708261315233365},
{0.4057837923954898,0.42589562961604716,0.4391839084260425},
{0.4079916794671011,0.43039782547922717,0.4632144070267622},
{0.3379134339933448,0.42787130528359857,0.4050375596309868},
{0.3909162505899222,0.41041411785217224,0.389218627412669},
{0.3990692005013963,0.41867302830724656,0.41465592131565426},
{0.44317584039486463,0.4051401384551103,0.4280896140631435},
{0.4453100811312077,0.40872551259352324,0.4523951591812933},
{0.4819528903932113,0.3892550748336945,0.4418171406584885},
{0.47920092223247596,0.3863881282107548,0.41742667680681517},
{0.516365267787093,0.3723412169981754,0.4320469773439825},
{0.5127528398928671,0.37001309101184054,0.4077662315019945},
{0.4385736959338205,0.39952197516465215,0.40247271328128986},
{0.47456796654953387,0.3817784688175404,0.3912251143021183},
{0.5070309705384599,0.36603468592092486,0.3814324061911017},
{0.5427268983470155,0.3563907734668787,0.3996764070207503},
{0.5469931253400507,0.3583401468718343,0.42365354960306134},
{0.4326677107412429,0.3933950509662699,0.37535207457217495},
{0.46863943656044565,0.3769050353051514,0.3630396097044828},
{0.49991583275969353,0.3618774254443579,0.352868149012087},
{0.5359386601176538,0.3528820516366019,0.3736123677747685},
{0.5681897430193795,0.3423851943812355,0.39172861475752313},
{0.3843917864797352,0.40280299455017127,0.3624587054477246},
{0.4266249537831671,0.3882841455973019,0.3465368186586748},
{0.4620007454812713,0.3732467663246871,0.33269807106721055},
{0.4921235995923901,0.3590164907671543,0.3218961075657331},
{0.5275798010647157,0.34924707894586543,0.34542611168391596},
{0.5605124883142805,0.3393168475761338,0.36619287524310806},
{-0.5127528398928671,0.37001309101184054,0.4077662315019945},
{-0.5070309705384599,0.36603468592092486,0.3814324061911017},
{-0.49991583275969353,0.3618774254443579,0.352868149012087},
{-0.4620007454812713,0.3732467663246871,0.33269807106721055},
{-0.5427268983470155,0.3563907734668787,0.3996764070207503},
{-0.5359386601176538,0.3528820516366019,0.3736123677747685},
{-0.5275798010647157,0.34924707894586543,0.34542611168391596},
{-0.4921235995923901,0.3590164907671543,0.3218961075657331},
{0.5511270895268899,0.3361921387797554,0.33875886386249476},
{0.5799716536758539,0.32233385236464857,0.35760405926576105},
{0.5700526947043776,0.3198914994093263,0.33090951721069767},
{-0.5882050133615494,0.3248626270399283,0.38249351461353703},
{-0.5681897430193795,0.3423851943812355,0.39172861475752313},
{-0.5605124883142805,0.3393168475761338,0.36619287524310806},
{-0.5799716536758539,0.32233385236464857,0.35760405926576105},
{-0.5511270895268899,0.3361921387797554,0.33875886386249476},
{-0.5931355603584322,0.3262558954642875,0.40542082117166817},
{-0.6018393547979836,0.3006878417415404,0.37054176649001563},
{-0.5935368577363221,0.2989300991069254,0.34627529901915105},
{-0.5700526947043776,0.3198914994093263,0.33090951721069767},
{-0.5838531161417737,0.2975255582843109,0.3199241893642668},
{-0.5600653498501522,0.3187567446516228,0.30256319306461943},
{-0.5747773325597964,0.29750827394031937,0.2914177971629628},
{-0.5512067478078942,0.3206768098211145,0.27245161135175594},
{-0.5672631518827911,0.3002805324179144,0.2609733039549585},
{-0.5446762717519712,0.32740267411346347,0.24045904211668587},
{-0.5622664734828103,0.3072438685668423,0.22880864277319035},
{-0.5416725533635334,0.3406808077650291,0.20647050689720475},
{-0.5607416937454722,0.3197998172368496,0.19514174665059475},
{-0.5784348500470435,0.28025098370462104,0.20578289060362942},
{-0.5790999215441082,0.29270397780389634,0.1707858514869045},
{-0.5636432090563951,0.33935066477089976,0.16019054862010818},
{-0.5830219646437471,0.31070674931088066,0.13643133907073357},
{-0.5691959924369723,0.3628122830063336,0.12388065085324541},
{-0.5886919809661798,0.33169069440979226,0.10211064384932862},
{-0.5756257684018145,0.3870990407940577,0.08613765552152126},
{-0.5946032266112766,0.353087960778066,0.06721731079655276},
{-0.581158261465532,0.40912680997141315,0.04688641330323353},
{-0.599247454692474,0.37232994459992,0.031142630406617956},
{-0.5840191961427356,0.4258114623757406,0.006052526369896992},
{-0.5592965722891385,0.44058055856987843,0.051140616404796335},
{-0.5623123145690487,0.4591341746049401,0.008323538871738149},
{-0.5848623715322346,0.43707183673960165,-0.03611075206435187},
{-0.5635853440786843,0.47158716870421524,-0.035617772513985284},
{-0.5843408352396211,0.4428282747819919,-0.0793524232650276},
{-0.5636890501426334,0.4780312230401808,-0.08038422345199912},
{-0.5379857276408223,0.5018851207349003,-0.03969011425702871},
{-0.5383178876427461,0.5087913433993344,-0.08553871542755455},
{-0.5631953190990497,0.4785587712785304,-0.12567897412157958},
{-0.5381946427551545,0.5095225462994971,-0.13177583859128086},
{-0.5093125039453393,0.5371316555996767,-0.090085249390539},
{-0.5093125039453393,0.5380605012159161,-0.13727150848736439},
{-0.5380661374150437,0.504410889437312,-0.17807683867845409},
{-0.5093125039453393,0.533187067703527,-0.18448106387391747},
{-0.4777558007761422,0.5618197107652907,-0.18621250424593666},
{-0.4777558007761422,0.5663436999317645,-0.1377246588972288},
{-0.4447314313541006,0.5925392504907251,-0.17906880972492342},
{-0.4447314313541006,0.5965417033645856,-0.12869471640148974},
{-0.6067699017948665,0.3017624770418822,0.3927964866189118},
{-0.6128584998391805,0.2673621235394729,0.37597431095586925},
{-0.6081571582734895,0.2667256087846551,0.35444553327461664},
{-0.6004288020296329,0.2661003664280926,0.33063447069326757},
{-0.5920233503972394,0.2662724583747907,0.3038474949725104},
{-0.5852922256523713,0.2680271950365376,0.2733917293662508},
{-0.5806307132271824,0.27235579596658555,0.24034406365448147},
{-0.5896944729176874,0.23860999305620267,0.21532309699372656},
{-0.5910719599844891,0.24755877428450332,0.1769721436494314},
{-0.5943394524921017,0.2600628699225361,0.13955905383998005},
{-0.5991445001217419,0.276730237982872,0.10530449002167307},
{-0.6045139191573657,0.29545143700532955,0.07273928295523205},
{-0.6094767803625805,0.31412003150259565,0.04039426340137855},
{-0.6128832991153422,0.3309850422790084,0.007443540314605126},
{-0.6011164183232083,0.3868465390731384,-0.006721355333046758},
{-0.600875940493761,0.39650172392543986,-0.04621307538078161},
{-0.5991903412079802,0.4011572244048925,-0.08717321317457788},
{-0.5831076348704877,0.44300036672869,-0.12341998551121076},
{-0.5626797947521726,0.47326149559174086,-0.1712021787291348},
{-0.5612497031601793,0.4622716587860079,-0.21439800884357219},
{-0.5375077779547962,0.49242532411902457,-0.22264714988682513},
{-0.5090607537176369,0.520911426003469,-0.23030787174114967},
{-0.4775378677432058,0.5496507811020499,-0.23357310976911122},
{-0.4445706118056578,0.580562703091042,-0.22863429634684118},
{-0.6114712433605575,0.22652297615361724,0.35829768750507257},
{-0.6071494058694626,0.22638470140168518,0.3373971581532505},
{-0.6004460863736244,0.22703850050049446,0.31378373828797823},
{-0.5940268313138206,0.22895631119033516,0.28595068400912615},
{-0.5905616960901311,0.23261157419793124,0.2523897484301307},
{-0.5895351563556788,0.1935609806685885,0.23231736460346708},
{-0.5928372175512744,0.20075051627584012,0.19066961051609552},
{-0.5980661073553151,0.21030274655740952,0.14796675995202468},
{-0.6040517508288971,0.22254908002200374,0.10761458017079938},
{-0.6096248245263338,0.2378231796579804,0.07301958992518134},
{-0.6146087275416252,0.25438909613401833,0.041477916620324594},
{-0.618826107475554,0.270510128625579,0.010287942141034241},
{-0.6213856933727316,0.2858901888051559,-0.02067583287993242},
{-0.6135821878071729,0.3443007505914252,-0.02693952884381265},
{-0.6122535477994776,0.35326230720441515,-0.06300970027444532},
{-0.6095759774672274,0.3570671173621987,-0.1010247361507315},
{-0.5967246919629303,0.40067551725278133,-0.12943944617955877},
{-0.5818180725100776,0.4375077028054746,-0.16806018558876487},
{-0.5791164543948827,0.4277833805772069,-0.21020693117223924},
{-0.5580137733676815,0.44572528113361254,-0.2527083815541481},
{-0.5360972251864455,0.4725348016508804,-0.26369370940057896},
{-0.5083040000480956,0.4996351500431357,-0.27334889425288045},
{-0.47688482013761346,0.5279807226959969,-0.27862362514315947},
{-0.598806328174082,0.1830746443182604,0.3225904872982616},
{-0.5933880620793517,0.18493834749647545,0.2988252658031509},
{-0.5893284957209977,0.1884012282405139,0.2695042549545948},
{-0.5773917774618166,0.14742981804846228,0.2577794577826141},
{-0.5811642734112682,0.1531749836925972,0.21707783365547342},
{-0.5884454911909965,0.1604847582145724,0.17114130777855602},
{-0.5973093536857736,0.1696184067742605,0.12435634605962048},
{-0.6058297837803716,0.18083294005188305,0.08110941440642556},
{-0.6120792013731284,0.1943868717140959,0.045785475740295976},
{-0.6165844032091766,0.2087313742406161,0.014796149949950555},
{-0.6198721860336488,0.2223183716043779,-0.015446943075891792},
{-0.6229615746488272,0.23352163248374522,-0.05224305695416793},
{-0.6244360043406249,0.2606866092926645,-0.07807939375539195},
{-0.6213947112913358,0.30023243685202494,-0.05154116228946917},
{-0.6196226902855975,0.3107368090395616,-0.08358483306329677},
{-0.6168369049300961,0.314605496120792,-0.11808588665678703},
{-0.6060259235100144,0.3561037030579762,-0.14093503792034773},
{-0.594144815748893,0.3949190792103911,-0.17285320932693263},
{-0.5899394597064367,0.38629268857219295,-0.21471889644724068},
{-0.5736493412410459,0.4152620005951826,-0.2467918754565321},
{-0.5549814982369969,0.42058257257169995,-0.28483922554115026},
{-0.5341350763968005,0.4429139450087324,-0.2997398330482669},
{-0.5067897412157958,0.46775680777705303,-0.31219883909327834},
{-0.5831166527890919,0.14020270778035956,0.31321861538877754},
{-0.5790540804578698,0.142992250601946,0.28886046574543617},
{-0.5576801103793237,0.1088669436169669,0.25404679097366467},
{-0.5643999627259364,0.11375164952761131,0.21057591434179718},
{-0.574903583420256,0.11951935996825695,0.16149814681772684},
{-0.5866915060224667,0.12664050969275947,0.11173126001364712},
{-0.5972635125995353,0.13558478196175797,0.06619678300783659},
{-0.6041208882048631,0.14682186003589134,0.02981248741248862},
{-0.6080496947434553,0.15870897974274886,-0.0008349089641116854},
{-0.6098359941203171,0.16960187392348594,-0.029157936820462256},
{-0.6087718797250136,0.17411158471883634,-0.05688878802179931},
{-0.6170052394107091,0.20660840590252835,-0.09021150025099874},
{-0.6225873310267501,0.23170602487141953,-0.10410510684730559},
{-0.6234515482263258,0.27354240375626365,-0.10481677092382563},
{-0.6026757667485293,0.18271317608087265,0.34311000958905347},
{-0.5865419588722792,0.13940311899744787,0.33375316754390977},
{-0.5631382056145561,0.10006019460668344,0.33356980319895635},
{-0.5600706103026714,0.10117841651361255,0.3124761400903595},
{-0.5572442443134508,0.10439480748246763,0.2869915021147019},
{-0.5318137138494188,0.07312141725608784,0.25636289306852716},
{-0.5406227173393533,0.07620329093909599,0.21089680194546567},
{-0.5533800661915226,0.07917995557172101,0.15935263368312838},
{-0.5673059869961614,0.08273226400858509,0.1064993642367384},
{-0.5797048735838111,0.08840754078353684,0.058182859341511586},
{-0.5878781138121447,0.09775386192364224,0.02024597875979572},
{-0.5922375259640906,0.10824996768579169,-0.010387890738898184},
{-0.5931956798157939,0.11737459832687551,-0.036796865371493154},
{-0.5914221558236216,0.12267638297296724,-0.061480411577805094},
{-0.6041486934538929,0.1668499057627506,-0.08575815144692504},
{-0.6111000057113485,0.1876580014488789,-0.11850296539223437},
{-0.6187193954387368,0.21064843343723977,-0.1281115576650805},
{-0.6234725900364023,0.22647112312164272,-0.14041425312095132},
{-0.6242090533890841,0.2462932597070379,-0.12358155655287054},
{-0.6217734638727151,0.27876002116204895,-0.13409269217936037},
{-0.5342305160353622,0.06461601702583028,0.33959527581304055},
{-0.5314943292321843,0.06596494735038516,0.31773283514343},
{-0.5297298231586162,0.06925423316129149,0.2909819310970899},
{-0.5014120557547848,0.04060430575553622,0.2627844026079821},
{-0.5112160362640567,0.041441469199298975,0.21612569174950627},
{-0.5250450144436997,0.040792179059791794,0.16232028039714913},
{-0.5402492252104932,0.03925687841741538,0.10506852115152811},
{-0.5545020455645367,0.04090565453556216,0.05237231378749576},
{-0.5654768525059293,0.04980709169119039,0.012232806586687755},
{-0.5723823236771465,0.061281641621902735,-0.018835425991444995},
{-0.574429391200315,0.07065125905173576,-0.044317057994234535},
{-0.5733517499271051,0.07725613293614411,-0.06706776364636532},
{-0.5875850314575061,0.12170169627048942,-0.08693799579764994},
{-0.5983997703436729,0.154689994018114,-0.11357166690213454},
{-0.606586537449913,0.1731384010027925,-0.14239744372067298},
{-0.6157021501723925,0.19486857886620715,-0.14858974782893608},
{-0.622817287951159,0.21155849172305374,-0.15584766931893673},
{-0.6294394461795588,0.22507184275154732,-0.16331300293683548},
{-0.6275734885216926,0.23793815812018485,-0.15342786116012516},
{-0.625185243077996,0.25451910446056314,-0.14478042871185046},
{-0.6283783377571235,0.260298087299464,-0.1638608414920447},
{-0.6208070435956246,0.2776545746398093,-0.16942865473696234},
{-0.6129900111521593,0.31380290136501227,-0.15509993356799961},
{-0.6020768266545626,0.35076058628494816,-0.18269175852418756},
{-0.5962317124125638,0.34300442479206183,-0.2243199737879166},
{-0.5825988739625636,0.3771996206462241,-0.25234165286424126},
{-0.5670993263614803,0.403710798356334,-0.2721667954225045},
{-0.5541608676440086,0.38380449453063237,-0.3094927120187813},
{-0.5319226803658871,0.40173812866165076,-0.32930733367200626},
{-0.5042677299794692,0.4236787246258316,-0.34545316543972876},
{0.5314943292321843,0.06596494735038516,0.31773283514343},
{0.5297298231586162,0.06925423316129149,0.2909819310970899},
{0.49828133501267013,0.03768024564810276,0.29859606037195907},
{0.49921018062890965,0.03452698010947753,0.32635697130197705},
{0.5015841477014829,0.03300220037213944,0.3488664476314437},
{0.46696586116613714,0.0051488557764277285,0.3584186779130132},
{0.43214091399611027,-0.019011651150836716,0.36528732591659624},
{0.3965764975005336,-0.03990992602300774,0.37041250965668787},
{0.3597390514953212,-0.05797657445343899,0.37473585013421673},
{0.3210957672896045,-0.07363994757583318,0.3791967138704606},
{0.2801130846992975,-0.08733140249676107,0.38473521887991446},
{0.2404432607591284,-0.09963560093906594,0.3903879508583555},
{0.20573855250382508,-0.11113645313237404,0.3951929984879956},
{0.17965121696811565,-0.12242012378596272,0.3981854444781782},
{0.16583426267994505,-0.13407052312945825,0.3984033775111146},
{0.4650450445034284,0.006828443116472429,0.33571982529285693},
{0.4308220434002363,-0.017165983809830164,0.3431904193632749},
{0.3958099744191709,-0.03801766610254577,0.3495164892641679},
{0.3592761316736355,-0.05628796919479006,0.35544426776003923},
{0.32095373507158725,-0.07230604711561876,0.3614697403741234},
{0.28057525302776615,-0.08640030240087053,0.3680881411364381},
{0.24180722094802376,-0.09906747206699716,0.3742210772805564},
{0.20831767722464536,-0.11080579611688426,0.3787901560400517},
{0.18311109173928597,-0.12199778459799622,0.3812452843800632},
{0.16919268586681738,-0.13302820203744842,0.3810378722521651},
{0.4680953554713215,0.011725172918589209,0.2713679581328099},
{0.4646723038677853,0.009781059966152713,0.30759744612545126},
{0.4306732477432659,-0.01433360587487339,0.31575039603692534},
{0.3952651418368298,-0.03547010409684043,0.3239101093873527},
{0.357430464332629,-0.05443328393517923,0.3329325369509215},
{0.31800713016764315,-0.07110065199551513,0.3426666285910104},
{0.2778345572652861,-0.08534821189703941,0.3529613341709978},
{0.24068298709535846,-0.09784554409611901,0.3618417295165494},
{0.2103211581412266,-0.10926147755590361,0.36733138746689675},
{0.1878710497759047,-0.11981319381611262,0.369573091733274},
{-0.49828133501267013,0.03768024564810276,0.29859606037195907},
{-0.49921018062890965,0.03452698010947753,0.32635697130197705},
{-0.4680953554713215,0.011725172918589209,0.2713679581328099},
{-0.47756116403293347,0.010377745580468372,0.22434777903694644},
{-0.49070177442578405,0.0062963859188206635,0.16922199410228125},
{-0.5051492315230363,3.795040745962894e-05,0.10867493710001776},
{-0.5188887820098536,-0.008934127110568717,0.04069561218140445},
{-0.5415215032269118,0.008958926386730414,-0.0021410041752963093},
{-0.5519281812962357,0.02213861442686616,-0.03117795058781799},
{-0.5563807786070923,0.032718887429322045,-0.05472899651607745},
{-0.557148804674889,0.040860564942540825,-0.07525528224582245},
{-0.5708823432159702,0.08043645223058217,-0.08994021119965372},
{-0.5832421521563347,0.11729418855265407,-0.11209347974425182},
{-0.5939614514039396,0.14450575794102882,-0.13813196822085483},
{-0.6046657207872042,0.16225076727457458,-0.16251040818105575},
{-0.6148424419321191,0.1829544054035368,-0.16611081218380921},
{-0.6236401730237984,0.19999075663343058,-0.1699810022514737},
{-0.6321230284575452,0.21456822205722767,-0.17388576100712114},
{-0.4646723038677853,0.009781059966152713,0.30759744612545126},
{-0.4650450445034284,0.006828443116472429,0.33571982529285693},
{-0.43348232938849496,-0.013106417451476102,0.28016869519735715},
{-0.4306732477432659,-0.01433360587487339,0.31575039603692534},
{-0.4308220434002363,-0.017165983809830164,0.3431904193632749},
{-0.5015841477014829,0.03300220037213944,0.3488664476314437},
{0.3568029674964154,-0.054932275431281985,0.3022723651896318},
{0.39668245804413366,-0.034966603641435536,0.2901492766126293},
{0.30911020197131706,-0.07532404387517999,0.3187045158730397},
{0.2684093293373934,-0.08818660177773237,0.3416190470464814},
{0.23546010923705404,-0.09899683170459704,0.35303573199948296},
{0.2091300413922464,-0.10956207484271246,0.359597019277304},
{0.193223184467537,-0.11764288140535244,0.36301556192153805},
{0.43348232938849496,-0.013106417451476102,0.28016869519735715},
{0.40180087834527206,-0.03920803135830899,0.2447883945399509},
{0.3599990681484109,-0.06030470043977383,0.25853545995893845},
{0.3177087873604853,-0.08089336010653168,0.2726725503575605},
{0.2770094177129957,-0.10250254756200573,0.2849857667184696},
{0.2684777152201424,-0.09715341884324154,0.3167363551376585},
{0.4410393451788704,-0.016076318645147938,0.23364750759759642},
{0.40813671765798637,-0.047095704164174246,0.19111750047344075},
{0.3633928115164833,-0.0697847873725092,0.20576635775285493},
{0.31915165433716797,-0.0914781420682897,0.223623339575737},
{0.2776436779881625,-0.11322109531639368,0.24548728323178157},
{-0.357430464332629,-0.05443328393517923,0.3329325369509215},
{-0.3592761316736355,-0.05628796919479006,0.35544426776003923},
{-0.3958099744191709,-0.03801766610254577,0.3495164892641679},
{-0.3952651418368298,-0.03547010409684043,0.3239101093873527},
{-0.32095373507158725,-0.07230604711561876,0.3614697403741234},
{-0.31800713016764315,-0.07110065199551513,0.3426666285910104},
{-0.3568029674964154,-0.054932275431281985,0.3022723651896318},
{-0.39668245804413366,-0.034966603641435536,0.2901492766126293},
{-0.4018016298384891,-0.03920803135830899,0.2447883945399509},
{-0.4410393451788704,-0.016076318645147938,0.23364750759759642},
{-0.45115218940033847,-0.02236706836484094,0.1788786819410168},
{-0.4616325138049304,-0.03110317701272428,0.1185540669309919},
{-0.4660926260479573,-0.04248153581165777,0.05808291074364764},
{-0.49661752903018297,-0.03583082084101112,-0.010810229926864675},
{-0.4581463367711643,-0.05669753299806718,0.0028759645415440535},
{-0.4798945504717875,-0.05238771939844474,-0.055720967562546776},
{-0.5044736391209332,-0.03678296274697825,-0.06570380345746998},
{-0.5206179679022217,-0.01881100246189181,-0.030790931581051548},
{-0.30911020197131706,-0.07532404387517999,0.3187045158730397},
{-0.3177087873604853,-0.08089336010653168,0.2726725503575605},
{-0.3599990681484109,-0.06030470043977383,0.25853545995893845},
{-0.3633928115164833,-0.0697847873725092,0.20576635775285493},
{-0.40813671765798637,-0.047095704164174246,0.19111750047344075},
{-0.41320253343393326,-0.057530187482527806,0.13242588022400512},
{-0.41498808131757803,-0.06899271352176778,0.07198177779247365},
{-0.4114823654601693,-0.07996000553099011,0.013055691659327087},
{-0.4456490045720848,-0.06930308022039797,-0.04889365168589988},
{-0.46891598606430973,-0.06244645610828718,-0.09854781450742624},
{-0.4947966609653381,-0.048235719374396954,-0.09886945360431176},
{-0.3210957672896045,-0.07363994757583318,0.3791967138704606},
{0.028758893922223458,-0.3726959217966099,0.21268610729519555},
{0.05677080358672683,-0.36669750293833847,0.21455957988523197},
{0.053303413883386296,-0.38994795157978906,0.22595898049424207},
{0.026878657893233855,-0.3951941257278212,0.22321227278602582},
{0.05088135124492367,-0.418382951925476,0.23518130525353878},
{0.0757843334706061,-0.4116954137871952,0.24030949496649845},
{0.07882337204024396,-0.38255776728359253,0.23071217509190764},
{0.08328949622900704,-0.35828829383985983,0.2187574209955181},
{0.060762735555548876,-0.34819123097594923,0.20135659555536853},
{0.030914927961860218,-0.355014037893294,0.20037063645463538},
{0.0,-0.3577434612575187,0.2005540007995888},
{0.0,-0.37509318515891077,0.21233065100354404},
{0.0,-0.39728102239149193,0.2223412921474971},
{0.02554851489910452,-0.4231045838080265,0.2317898163651175},
{0.050023897484301305,-0.45244287900057417,0.24185155904782804},
{0.07487878414409432,-0.445946971632634,0.24694893753888977},
{0.09954429451319773,-0.4383899558422586,0.25287746752797813},
{0.10004253451608346,-0.4039264769096194,0.2467828575379279},
{0.10298387896750844,-0.37403808868221156,0.2376033678920014},
{0.10756798759134399,-0.34865865975693705,0.2260874858343529},
{0.08847855689254548,-0.3386397521875968,0.2050486817305987},
{0.06475917648367306,-0.33398951216066325,0.18672502261994586},
{0.033070210508279956,-0.3415525398967749,0.18642667981278802},
{0.0,-0.3445682821766851,0.187069206513342},
{-0.030914927961860218,-0.355014037893294,0.20037063645463538},
{-0.028758893922223458,-0.3726959217966099,0.21268610729519555},
{-0.026878657893233855,-0.3951941257278212,0.22321227278602582},
{-0.02554851489910452,-0.4231045838080265,0.2317898163651175},
{0.0,-0.4249735474387608,0.2305280592537372},
{0.025043511457265587,-0.4570239816515417,0.23825716699081076},
{0.05038386273525495,-0.4901798623865621,0.24751406043809052},
{0.07562952586789952,-0.48356972804963466,0.25218909974118575},
{0.10093981741720799,-0.475903745742791,0.25737816040472417},
{0.12633653068647405,-0.4680664229824662,0.2623259917455985},
{0.12395730316138168,-0.43062703091041904,0.2589660655722922},
{0.1234410273212874,-0.39596290328883493,0.25420761052210744},
{0.12533328724174936,-0.3654034316186262,0.24676557319393638},
{0.12885929341601765,-0.33900046893176744,0.2373568781168181},
{0.11299452011146147,-0.3277228102239149,0.21298369860913635},
{0.09368415040685843,-0.3233656525516201,0.19018790336398425},
{0.06823934157170297,-0.32365272296052255,0.17103835320782396},
{0.03495119803048658,-0.33171399069951996,0.17101505691809626},
{0.0,-0.3349010734329112,0.1719326301360804},
{-0.033070210508279956,-0.3415525398967749,0.18642667981278802},
{-0.060762735555548876,-0.34819123097594923,0.20135659555536853},
{-0.05677080358672683,-0.36669750293833847,0.21455957988523197},
{-0.053303413883386296,-0.38994795157978906,0.22595898049424207},
{-0.05088135124492367,-0.418382951925476,0.23518130525353878},
{-0.050023897484301305,-0.45244287900057417,0.24185155904782804},
{-0.025043511457265587,-0.4570239816515417,0.23825716699081076},
{0.0,-0.45883508030456516,0.2368353418242047},
{0.025181034715980655,-0.4948526472100063,0.2441052872056777},
{0.05161255414508629,-0.5296490376377863,0.25370861902600467},
{0.07756161492886365,-0.5228202187747054,0.25759008149192447},
{0.10368351915255614,-0.5149430668738784,0.26177589871073825},
{0.13003462880744038,-0.50695018501763,0.26557093945670046},
{-0.08328949622900704,-0.35828829383985983,0.2187574209955181},
{-0.08847855689254548,-0.3386397521875968,0.2050486817305987},
{-0.10756798759134399,-0.34865865975693705,0.2260874858343529},
{-0.10298387896750844,-0.37403808868221156,0.2376033678920014},
{-0.07882337204024396,-0.38255776728359253,0.23071217509190764},
{-0.0757843334706061,-0.4116954137871952,0.24030949496649845},
{-0.07487878414409432,-0.445946971632634,0.24694893753888977},
{-0.07562952586789952,-0.48356972804963466,0.25218909974118575},
{-0.05038386273525495,-0.4901798623865621,0.24751406043809052},
{-0.025181034715980655,-0.4948526472100063,0.2441052872056777},
{0.0,-0.49670507798996616,0.24271803072705467},
{0.025777720330296298,-0.5344939144079286,0.25082438805907337},
{0.053361278861097004,-0.5689032858289421,0.26197880187933426},
{0.08019935612061166,-0.5619572340240058,0.2647112312164271},
{0.10722680967081592,-0.5539816365117489,0.2675608934953753},
{0.13450676494193964,-0.5459489255149983,0.26998596210670606},
{-0.06475917648367306,-0.33398951216066325,0.18672502261994586},
{-0.09368415040685843,-0.3233656525516201,0.19018790336398425},
{-0.11299452011146147,-0.3277228102239149,0.21298369860913635},
{-0.10004253451608346,-0.4039264769096194,0.2467828575379279},
{-0.09954429451319773,-0.4383899558422586,0.25287746752797813},
{-0.10093981741720799,-0.475903745742791,0.25737816040472417},
{0.0,-0.5364199915231566,0.24963251981687617},
{0.026648700968825056,-0.5738481111969483,0.25990618358678697},
{0.0,-0.5758207808916317,0.2590352029482582},
{0.027612115273047546,-0.6108170685151396,0.2728408848381735},
{0.05528209552380581,-0.605995488034725,0.2738674245726258},
{-0.05161255414508629,-0.5296490376377863,0.25370861902600467},
{-0.025777720330296298,-0.5344939144079286,0.25082438805907337},
{-0.053361278861097004,-0.5689032858289421,0.26197880187933426},
{-0.026648700968825056,-0.5738481111969483,0.25990618358678697},
{-0.027612115273047546,-0.6108170685151396,0.2728408848381735},
{0.0,-0.6127438971235846,0.2723824739757899},
{0.028621370663508394,-0.6440713948615899,0.2888717381436915},
{0.05728106748108491,-0.639539139269729,0.28876427461365733},
{0.08601891959323175,-0.6331890215858912,0.28839604293731647},
{0.08306630274355144,-0.5992358065476102,0.2751118973400146},
{0.11102260190999516,-0.5914954264122813,0.27622410730120756},
{0.13920810650763066,-0.5837325014804416,0.27685461011028917},
{0.16643019680104368,-0.5780166440717706,0.27880999546098095},
{0.16106378373828797,-0.5402473464774507,0.273738167739298},
{0.18592393085060013,-0.5392643933495856,0.280569992575247},
{0.19149700454803695,-0.5764167150127303,0.2838953500605704},
{0.17142386922815636,-0.6128776629162145,0.28630914627364573},
{0.19588347045579566,-0.6101271977419132,0.2894872110884327},
{0.2132151585199792,-0.581003829609434,0.2939172636027787},
{0.2162744874064767,-0.6126424455392865,0.2976499304117281},
{0.2155928830586375,-0.6378407645992588,0.3040308593174638},
{0.22858319480808367,-0.6458501793062815,0.31662964310084135},
{0.21995004073093236,-0.6633659832086356,0.32095598955123833},
{0.22570948474619068,-0.6735374439010313,0.3375519657559571},
{0.22641363389054053,-0.6807194645761128,0.35844122270952383},
{0.20803286129539397,-0.6852118910274716,0.34135752740695763},
{0.18253018748252778,-0.6833256430527458,0.3267545112137818},
{0.155146526147455,-0.6896862816416219,0.33150545133179626},
{0.12477117031541675,-0.6951105596820883,0.3368493195980413},
{0.09395994841750559,-0.7004198592603503,0.3415965022499707},
{0.09575451421975466,-0.7091168902609485,0.3619334116890261},
{0.06415873340327231,-0.7131433909177537,0.3660252922557121},
{0.032175933580023505,-0.7159690054137572,0.368796047746873},
{0.0,-0.7170812153749501,0.36985114422357224},
{-0.032175933580023505,-0.7159690054137572,0.368796047746873},
{-0.06415873340327231,-0.7131433909177537,0.3660252922557121},
{-0.09575451421975466,-0.7091168902609485,0.3619334116890261},
{-0.12676939077947882,-0.7044012703241341,0.35691343699931766},
{-0.1570102293256701,-0.6995082979881023,0.35136065361874047},
{-0.18469298496111775,-0.693442996233516,0.3459499024561804},
{-0.18253018748252778,-0.6833256430527458,0.3267545112137818},
{-0.17911915977046391,-0.6669010073015081,0.31001124233852667},
{-0.17553528861848494,-0.6429621908732651,0.29661963321119067},
{-0.07756161492886365,-0.5228202187747054,0.25759008149192447},
{-0.08019935612061166,-0.5619572340240058,0.2647112312164271},
{-0.08306630274355144,-0.5992358065476102,0.2751118973400146},
{-0.05528209552380581,-0.605995488034725,0.2738674245726258},
{-0.05728106748108491,-0.639539139269729,0.28876427461365733},
{-0.028621370663508394,-0.6440713948615899,0.2888717381436915},
{0.0,-0.6458832450078306,0.28886046574543617},
{0.029630626053969236,-0.6722801957489531,0.30724198983379974},
{0.05926651256045763,-0.668146231562114,0.30606064249664083},
{0.08891442295841838,-0.6623492128860046,0.3041683825761789},
{0.1185788662071536,-0.6557105218068302,0.30162307505012464},
{0.11487250166080001,-0.6259250881501544,0.28762501089665166},
{0.14388089133107484,-0.6186491308229453,0.28630914627364573},
{-0.10368351915255614,-0.5149430668738784,0.26177589871073825},
{-0.10722680967081592,-0.5539816365117489,0.2675608934953753},
{-0.11102260190999516,-0.5914954264122813,0.27622410730120756},
{-0.11487250166080001,-0.6259250881501544,0.28762501089665166},
{-0.08601891959323175,-0.6331890215858912,0.28839604293731647},
{-0.08891442295841838,-0.6623492128860046,0.3041683825761789},
{-0.05926651256045763,-0.668146231562114,0.30606064249664083},
{-0.029630626053969236,-0.6722801957489531,0.30724198983379974},
{0.0,-0.6739312263467511,0.307654559609945},
{0.030593288864974706,-0.6941125766898828,0.3271941347457398},
{0.06114449410979617,-0.6904287569400399,0.32514706722257125},
{0.09160852614144305,-0.6852487141951057,0.32203438231766524},
{0.12194480432619616,-0.6792916274637705,0.3180777705300432},
{0.15210823907103416,-0.6732774272479417,0.3135026798248119},
{0.14826660574561654,-0.6490477829447112,0.2984810819097547},
{0.17553528861848494,-0.6429621908732651,0.29661963321119067},
{0.1979440648568706,-0.638052685686459,0.29791520751733697},
{0.212362965211876,-0.6539054350995428,0.3109829230681364},
{0.19999789581899233,-0.6598572613783589,0.3093055902077428},
{0.20436557439632552,-0.6752050073496036,0.32378461002010994},
{-0.06114449410979617,-0.6904287569400399,0.32514706722257125},
{-0.030593288864974706,-0.6941125766898828,0.3271941347457398},
{0.0,-0.6955802429427272,0.32795088841528114},
{0.03146502099672048,-0.7082398976766836,0.3479721707031872},
{0.06282107547697274,-0.7050002104181008,0.3454148392856606},
{0.17911915977046391,-0.6669010073015081,0.31001124233852667},
{-0.1185788662071536,-0.6557105218068302,0.30162307505012464},
{-0.12194480432619616,-0.6792916274637705,0.3180777705300432},
{-0.09160852614144305,-0.6852487141951057,0.32203438231766524},
{-0.09395994841750559,-0.7004198592603503,0.3415965022499707},
{-0.06282107547697274,-0.7050002104181008,0.3454148392856606},
{-0.03146502099672048,-0.7082398976766836,0.3479721707031872},
{0.0,-0.7095241995845746,0.34893558500740973},
{-0.12477117031541675,-0.6951105596820883,0.3368493195980413},
{-0.155146526147455,-0.6896862816416219,0.33150545133179626},
{-0.15210823907103416,-0.6732774272479417,0.3135026798248119},
{-0.14826660574561654,-0.6490477829447112,0.2984810819097547},
{-0.14388089133107484,-0.6186491308229453,0.28630914627364573},
{0.2081125195763983,-0.5453875600818827,0.2922316643169979},
{0.20266569673942122,-0.5082577832152487,0.2919911864875508},
{0.18030501606692498,-0.5010103826302864,0.27894150677395985},
{0.15583489393424735,-0.501440236750423,0.2707141590340006},
{-0.2364017302379829,-0.6571413648920406,0.33450015180162984},
{-0.24148933931722336,-0.6361468988880906,0.332610146360819},
{-0.2316139669523343,-0.6226718740136652,0.31260464543047034},
{-0.24235280502358184,-0.6106795452564245,0.3322855012910654},
{-0.2303927904746732,-0.5938460971951267,0.31068157428811044},
{-0.24046580555563904,-0.5812676037286088,0.33338643885400293},
{-0.2132151585199792,-0.581003829609434,0.2939172636027787},
{-0.22665411171998762,-0.5610050921180386,0.3104756651466464},
{-0.2081125195763983,-0.5453875600818827,0.2922316643169979},
{-0.22213613449925002,-0.5257788475701218,0.31159914750609463},
{-0.23730727956449463,-0.548437871049776,0.33577167832483146},
{0.19723615824643567,-0.47055461702402673,0.29265325201174736},
{0.19218462084161228,-0.4332181795227117,0.2936767857733316},
{0.17506485386462903,-0.4626879860282382,0.27827042333115903},
{0.17062728641811278,-0.4253290037304124,0.27781802441451164},
{0.15123800992572242,-0.4627601293770723,0.26872570798175976},
{-0.23320187211990223,-0.513036528582293,0.33892494386345673},
{-0.2171710188143842,-0.4890623919728501,0.31356580525504174},
{-0.22847723426448352,-0.47590975768852717,0.3423307111230014},
{-0.23947458600238672,-0.5006894950266179,0.37088294441054376},
{-0.20266569673942122,-0.5082577832152487,0.2919911864875508},
{-0.19723615824643567,-0.47055461702402673,0.29265325201174736},
{-0.21209167616053098,-0.45174925076126266,0.3158879192956405},
{-0.2234610170408602,-0.4379029882376282,0.3454727042633713},
{-0.23454328751228692,-0.46200036973466285,0.3746554403599954},
{-0.19218462084161228,-0.4332181795227117,0.2936767857733316},
{-0.20722951504639717,-0.41473370086361605,0.3180777705300432},
{-0.1878733042555558,-0.3971893402190152,0.29451920966961354},
{-0.20291819846034068,-0.3789115221946007,0.31964914284683665},
{-0.21847861701200283,-0.39986089860552915,0.3478346474444722},
{0.1477676142495138,-0.4253695843641316,0.26676355919211475},
{0.14591894093563912,-0.3904326647047684,0.2638169542881706},
{0.16741615590177683,-0.3899652359237806,0.27684333771203384},
{-0.12395730316138168,-0.43062703091041904,0.2589660655722922},
{-0.12633653068647405,-0.4680664229824662,0.2623259917455985},
{-0.15123800992572242,-0.4627601293770723,0.26872570798175976},
{-0.1477676142495138,-0.4253695843641316,0.26676355919211475},
{-0.17062728641811278,-0.4253290037304124,0.27781802441451164},
{-0.17506485386462903,-0.4626879860282382,0.27827042333115903},
{-0.15583489393424735,-0.501440236750423,0.2707141590340006},
{-0.13003462880744038,-0.50695018501763,0.26557093945670046},
{-0.1234410273212874,-0.39596290328883493,0.25420761052210744},
{-0.14591894093563912,-0.3904326647047684,0.2638169542881706},
{-0.16741615590177683,-0.3899652359237806,0.27684333771203384},
{-0.12533328724174936,-0.3654034316186262,0.24676557319393638},
{-0.12885929341601765,-0.33900046893176744,0.2373568781168181},
{-0.18030501606692498,-0.5010103826302864,0.27894150677395985},
{-0.18592393085060013,-0.5392643933495856,0.280569992575247},
{0.14790288302857776,-0.3315659465357666,0.2525114903312883},
{0.14618572102768201,-0.35911343339215024,0.25887438339981544},
{0.16585680747645573,-0.3576284827953143,0.27460689389817566},
{0.13324500783055931,-0.31680661975345015,0.22669844981979193},
{0.11846463923816623,-0.3111651601732643,0.199040493460506},
{0.09820212762759603,-0.3122202566499635,0.1747762804692925},
{0.07189159860643098,-0.3154584409221123,0.1499860222261634},
{0.03678559297323782,-0.32395031427446336,0.1497560653017546},
{0.0,-0.3272245702210292,0.15073075200423242},
{-0.03495119803048658,-0.33171399069951996,0.17101505691809626},
{0.13771714396505857,-0.29887223412921476,0.21550646133867996},
{0.1231772532021126,-0.2989180752154531,0.18500485464618197},
{0.10363692657310075,-0.30307683867845414,0.15457539130251813},
{0.07640281238821538,-0.3076864980716684,0.11925746458212469},
{0.03880410375415952,-0.3167149375809734,0.11826774801530643},
{0.0,-0.32001775026978607,0.11904704648135846},
{-0.03678559297323782,-0.32395031427446336,0.1497560653017546},
{-0.06823934157170297,-0.32365272296052255,0.17103835320782396},
{-0.09820212762759603,-0.3122202566499635,0.1747762804692925},
{-0.11846463923816623,-0.3111651601732643,0.199040493460506},
{-0.14618572102768201,-0.35911343339215024,0.25887438339981544},
{-0.14790288302857776,-0.3315659465357666,0.2525114903312883},
{-0.16543822575457434,-0.32860581475391604,0.2714994694457888},
{-0.16585680747645573,-0.3576284827953143,0.27460689389817566},
{-0.18466292523243685,-0.3634082171274322,0.2946394485843371},
{-0.1989443023287272,-0.34511837521154537,0.32076135280802953},
{-0.21343008558004756,-0.3630354764917892,0.34956458483005737},
{-0.2234377207511325,-0.3823172894541454,0.37925983930069046},
{-0.2292001707392589,-0.42198110144857837,0.3773961361224753},
{-0.1822055424127742,-0.33237305025084846,0.2942667079486941},
{-0.1950974085507904,-0.3141921748514298,0.3215752199620646},
{-0.20821547414713035,-0.3286749521298821,0.3508098090906631},
{-0.21725142858860555,-0.34469378154392777,0.3804006060041303},
{-0.15040535544126177,-0.30794275725867304,0.24530316739361113},
{-0.16565014684177462,-0.3031843022084883,0.26791033784129065},
{-0.18015622040995458,-0.30458283108536666,0.2936309446870933},
{-0.1911640930528961,-0.28697008455801676,0.3222515638573846},
{-0.20273408262217024,-0.29802981023293285,0.35171911588326005},
{-0.21063528230594192,-0.31079767999014046,0.3809739953287181},
{-0.15302806676866934,-0.288397170177142,0.23782430689780595},
{-0.16598305833691546,-0.28164951258149945,0.2642295240643158},
{-0.17816626637127972,-0.2805373026203066,0.2929598612442924},
{-0.18693318624106098,-0.26428851628185207,0.3229512040424323},
{-0.1968859624073033,-0.2723497840208494,0.35243829489195033},
{-0.20358326995740536,-0.28231458407856413,0.3811340633839439},
{-0.13324500783055931,-0.31680661975345015,0.22669844981979193},
{-0.13771714396505857,-0.29887223412921476,0.21550646133867996},
{-0.15510669700695282,-0.27308324140066315,0.23064904966167776},
{-0.16592594485242176,-0.26428851628185207,0.2608470530944988},
{-0.17589074491013645,-0.26073395336533695,0.2924841660379173},
{-0.18321179183036695,-0.2445813581586613,0.3234171298369861},
{-0.19112802137847903,-0.2506556778318519,0.35308833652467453},
{-0.19647339263115812,-0.2584516684652404,0.38115735967367165},
{-0.1231772532021126,-0.2989180752154531,0.18500485464618197},
{-0.14150091231276546,-0.2852499165842529,0.20449858869573845},
{-0.1583043006453824,-0.26003431318028924,0.22253292291783777},
{-0.16689837707524852,-0.24903019800343285,0.25697085108109813},
{-0.17453204517376028,-0.24308738964322113,0.2915695987928013},
{-0.18080851652232988,-0.22628249832417016,0.3233930820540414},
{-0.18591791890486398,-0.23196754451094323,0.3537872252165052},
{-0.18968515440179637,-0.23841911377907904,0.38131817922211436},
{-0.1759328285302897,-0.1692742228808643,0.34841555170123034},
{-0.177938563926522,-0.18080814077572138,0.34067667455233547},
{-0.17475148119313075,-0.18851620670271832,0.36279838038181866},
{-0.17162677239675236,-0.17687632826426108,0.36708339470527934},
{-0.17430810019508763,-0.19356624112110765,0.38503281019385516},
{-0.1785848480931611,-0.20667904626492842,0.38315257416486553},
{-0.17786792356412193,-0.20135095935624087,0.35862609004091134},
{-0.1787900057414082,-0.1942673842925894,0.33210814889184814},
{-0.18823402099972644,-0.16943278794965597,0.31797105849322604},
{-0.187239043980389,-0.15800182462553095,0.33077950888415286},
{-0.18433752866946623,-0.14844433389144232,0.34152360740791954},
{-0.17302004082111155,-0.15891939784351508,0.3552270862203198},
{-0.16833297762654395,-0.16586244367558342,0.37134962169831454},
{-0.17042062578343167,-0.1814747152592201,0.38746389075092214},
{-0.1835958048642653,-0.2214248461693385,0.38189081705348527},
{-0.18143676485176047,-0.21572176414535685,0.35535934902651567},
{-0.17943178094874518,-0.20948136447120427,0.32543714360434184},
{-0.186831734656763,-0.1835202797959546,0.3035048140655483},
{-0.21000027053755815,-0.15337938984762725,0.2939841464990937},
{-0.2074729988487124,-0.16720536205440212,0.272725154882752},
{-0.18131502295060284,-0.20313951321275375,0.28504588617583143},
{-0.20287761782662148,-0.18299273155760498,0.24815809012507856},
{-0.2374786200179757,-0.1477439422131776,0.23927318582022478},
{-0.23060020260257133,-0.16417759588301958,0.21033017605983087},
{-0.19722939480748247,-0.19986300278653685,0.21872360380075212},
{-0.22001016018829417,-0.1832910743647628,0.1860509332042769},
{-0.2629873057765781,-0.14650097243222285,0.1653893786954679},
{-0.24383024068824755,-0.1710394804476495,0.1425980924096179},
{-0.2106991592293888,-0.19875905925073123,0.16797226088237327},
{-0.21949388434819986,-0.19803988024204097,0.13410847353691785},
{-0.2312013971761891,-0.19604842321693206,0.082780735321083},
{-0.2644549720294225,-0.16349448854874638,0.08881372286733741},
{-0.24200711814375164,-0.1928568315242387,0.020991460031081766},
{-0.2776504414271157,-0.16104086319516883,0.025146466027997635},
{-0.2521492706006836,-0.18684714026771196,-0.0467368661530461},
{-0.286520315867629,-0.15864435132608495,-0.04313120169777347},
{-0.31682052237796504,-0.13072186935440724,0.02772559074881791},
{-0.32288507263933436,-0.131863387551064,-0.0408293779740344},
{-0.29417126831013224,-0.15127069988066288,-0.11074905837899908},
{-0.32725350270988457,-0.12767230987973105,-0.10650612767569159},
{-0.3016591467245417,-0.136937469752398,-0.1765918880816182},
{-0.3318225814693797,-0.1158723633860481,-0.16990660442298847},
{-0.31004130206720754,-0.11365921586191763,-0.2395444748715698},
{-0.33849058078401784,-0.09418877810208888,-0.23163275428275984},
{-0.31828743713759244,-0.08332970111611775,-0.2986186051684697},
{-0.34639704092030865,-0.06356618100165029,-0.29077076150310666},
{-0.32536725473515876,-0.04783968244902624,-0.3528223079258487},
{-0.35468300513119566,-0.024951453538180384,-0.346408313318564},
{-0.32674173582909244,-0.014585356102575815,-0.39871299271652777},
{-0.3620934797442518,0.026080196350147723,-0.40148449970090566},
{-0.3178756188546642,0.009036330188083717,-0.43284581463367716},
{-0.33965389228396825,0.04951400933655172,-0.4398790396517881},
{-0.38968004424792063,0.08882236503933319,-0.4236031995575208},
{-0.36233621205335004,0.10104615370741658,-0.4499693390767455},
{-0.4130484773244437,0.1472351813052535,-0.43409254188071694},
{-0.44247018826408074,0.1369953347301087,-0.4099635976685674},
{-0.4198848111196948,0.08187405875474564,-0.398077980948144},
{-0.16657899245801408,-0.16978974722774154,0.39037667846010027},
{-0.16243976781865566,-0.15789887005479888,0.3937020359454235},
{-0.16393448782731287,-0.14397219775694306,0.3788743232803581},
{-0.16919268586681738,-0.13302820203744842,0.3810378722521651},
{-0.18311109173928597,-0.12199778459799622,0.3812452843800632},
{-0.17445313838597293,-0.12971787441646554,0.36870737154726446},
{-0.1878710497759047,-0.11981319381611262,0.369573091733274},
{-0.17529631377547186,-0.22551221777672237,0.2895841537134286},
{0.16114419351250936,-0.1459448674516264,0.3966433803968485},
{0.16393448782731287,-0.14397219775694306,0.3788743232803581},
{-0.16470852584084578,-0.1549056725713994,0.3754617925818602},
{-0.16875155934842534,-0.13932947266217977,0.36557439632549876},
{-0.16944969654703895,-0.14900043887203876,0.3610135839913909},
{-0.1800224546173246,-0.13997575682881888,0.34979905071376827},
{-0.1786246772336633,-0.13195957868284283,0.35592372043249937},
{-0.18447655491461534,-0.12375778171226227,0.3602162496881303},
{-0.193223184467537,-0.11764288140535244,0.36301556192153805},
{-0.2103211581412266,-0.10926147755590361,0.36733138746689675},
{-0.2091300413922464,-0.10956207484271246,0.359597019277304},
{-0.20212612460959928,-0.11476541387737436,0.3543666264868294},
{-0.22452964039546577,-0.10555060405024787,0.347591915135374},
{-0.23546010923705404,-0.09899683170459704,0.35303573199948296},
{-0.24881564668997297,-0.09892468835576292,0.3363270318122109},
{-0.2684093293373934,-0.08818660177773237,0.3416190470464814},
{-0.2684777152201424,-0.09715341884324154,0.3167363551376585},
{-0.2770094177129957,-0.10250254756200573,0.2849857667184696},
{-0.2776436779881625,-0.11322109531639368,0.24548728323178157},
{-0.31915165433716797,-0.0914781420682897,0.223623339575737},
{-0.3156504474390614,-0.10604583808026549,0.16989232605186505},
{-0.36336124880136833,-0.0826075161345594,0.14801034655861198},
{-0.36237453820741816,-0.09524387457878805,0.08651265063681536},
{-0.36290283793898476,-0.10416485055805888,0.022516991261636882},
{-0.36363178635949633,-0.10851073583209839,-0.041495200964316095},
{-0.4056049370098386,-0.08788976195700861,-0.04441926107174956},
{-0.4364529820753838,-0.07584783464744448,-0.09905281794926518},
{-0.24068298709535846,-0.09784554409611901,0.3618417295165494},
{-0.24180722094802376,-0.09906747206699716,0.3742210772805564},
{-0.28057525302776615,-0.08640030240087053,0.3680881411364381},
{-0.2778345572652861,-0.08534821189703941,0.3529613341709978},
{-0.20831767722464536,-0.11080579611688426,0.3787901560400517},
{0.12738185775135194,0.0242871335343327,-0.5411998641300264},
{0.12538664326015794,-0.025582707840479054,-0.5171716200089578},
{0.06407682064261688,-0.02766960450414975,-0.5332340360295907},
{0.06504023494683937,0.024447201589558445,-0.5581866168075966},
{0.0,-0.028339936453733575,-0.5401605490108846},
{0.0,-0.07474088513877074,-0.508419730003517},
{0.06357256869399497,-0.07338819734813076,-0.5018606972053471},
{0.12449236633190149,-0.06928278990353837,-0.4868240694259494},
{0.1811617183343303,-0.02200484863423624,-0.49668591491293207},
{0.1843262562712109,0.024355519417081726,-0.5190458440922112},
{0.1905486201081549,0.07838788172097959,-0.5360934677203604},
{0.13140309795563787,0.08202285441171607,-0.5595776307523048},
{0.06701215314830569,0.0846718680017194,-0.5772211885015527},
{0.0,0.02458547634149055,-0.5653874248131036},
{-0.06504023494683937,0.024447201589558445,-0.5581866168075966},
{-0.06407682064261688,-0.02766960450414975,-0.5332340360295907},
{-0.06357256869399497,-0.07338819734813076,-0.5018606972053471},
{0.0,-0.11633152574164866,-0.4696847636253236},
{0.06297588307967933,-0.11441596953145904,-0.46356159689302645},
{0.12349062587361087,-0.10864825909081345,-0.4495988529207535},
{0.1801066218576311,-0.0623795732119722,-0.4679495657872192},
{0.22863429634684118,-0.016861629056936132,-0.47649254067832786},
{0.23317481836408946,0.024906363945159004,-0.4963417310195358},
{0.24182901425131736,0.07435161165235321,-0.5112100243183205},
{0.25503876202013404,0.13315370140469107,-0.5228837199515436},
{0.20077719428504437,0.14177633457680414,-0.5488906457130318},
{0.13837470052995302,0.14932207796892424,-0.5729707428660749},
{0.07054417126831013,0.15471103582819057,-0.5908442575397315},
{0.0,0.0857495092749293,-0.5845828160555023},
{-0.06701215314830569,0.0846718680017194,-0.5772211885015527},
{-0.13140309795563787,0.08202285441171607,-0.5595776307523048},
{-0.12738185775135194,0.0242871335343327,-0.5411998641300264},
{-0.12538664326015794,-0.025582707840479054,-0.5171716200089578},
{-0.12449236633190149,-0.06928278990353837,-0.4868240694259494},
{-0.06297588307967933,-0.11441596953145904,-0.46356159689302645},
{0.0,-0.154825262797178,-0.423473191230976},
{0.061737422258026704,-0.15246331961607718,-0.41783173165079},
{0.12117452377874838,-0.14551426183827265,-0.4049353565534717},
{0.17908233660282982,-0.09900509812998431,-0.4322032879331231},
{0.22776256421509541,-0.05263270618719398,-0.44987765690426884},
{0.2650373792726147,-0.010079402773310564,-0.46130636574874273},
{0.27122968338087783,0.026190665853049997,-0.47770394774416763},
{0.28262006607128365,0.07049870592868028,-0.48937012844522065},
{0.2984442587421206,0.12453031673936106,-0.4992312224389862},
{0.31621857631113026,0.18625646659913245,-0.5042023500695882},
{0.27039251993711505,0.1991513387100168,-0.5283275368156527},
{0.21295514186688952,0.21198834584319037,-0.5545268448406985},
{0.14680870890459344,0.2231886007496896,-0.5786167114055629},
{0.07485548785436663,0.23117246468733368,-0.5964165797439512},
{-0.1811617183343303,-0.02200484863423624,-0.49668591491293207},
{-0.1801066218576311,-0.0623795732119722,-0.4679495657872192},
{-0.12349062587361087,-0.10864825909081345,-0.4495988529207535},
{-0.061737422258026704,-0.15246331961607718,-0.41783173165079},
{0.0,-0.1897997571173923,-0.36931532955983537},
{0.059903027315275456,-0.18709363004289525,-0.36423523541276515},
{0.11766279597560352,-0.1793344625771408,-0.35252772258477594},
{0.17600872934520895,-0.13411636421569662,-0.388812821075477},
{0.2272891234883714,-0.08546243886602682,-0.41578316114118763},
{0.2656490947512708,-0.06799848799564737,-0.40474447727634805},
{0.2648081738414229,-0.039996347742965274,-0.4372488133922103},
{0.2865443636505737,-0.00304768074163366,-0.45055024333350363},
{0.2992197997420875,0.022727785109011592,-0.4581876688981004},
{0.3146524644468559,0.06337154425844148,-0.4668373558260263},
{0.3334067291708625,0.11434758364870998,-0.4756786735242928},
{0.3532837247611003,0.1731616972925202,-0.48103907464131235},
{0.3720830790781282,0.23731892770935847,-0.4792482663051484},
{0.333457079216403,0.25364737232881734,-0.5011956257082824},
{0.2854794977620532,0.2701824775829573,-0.5245084482867458},
{-0.22863429634684118,-0.016861629056936132,-0.47649254067832786},
{-0.22776256421509541,-0.05263270618719398,-0.44987765690426884},
{-0.17908233660282982,-0.09900509812998431,-0.4322032879331231},
{-0.12117452377874838,-0.14551426183827265,-0.4049353565534717},
{-0.059903027315275456,-0.18709363004289525,-0.36423523541276515},
{0.0,-0.22082891204823984,-0.30674074385804595},
{0.057517787844446916,-0.21787028325282337,-0.3023369936062957},
{0.11307492988568285,-0.20956252573864267,-0.29206859028890403},
{0.17113529583281983,-0.1668829714642996,-0.3377225547162211},
{0.21817801972519393,-0.15009837046210822,-0.32335174992710514},
{0.22394046971332035,-0.11840715000706403,-0.3734928803532619},
{0.2626679211593436,-0.09852339097787306,-0.3630050410164998},
{0.2954052201724827,-0.07486713599923048,-0.35642271192860214},
{0.2976409124931238,-0.04493290668558426,-0.3990624370624431},
{0.29394506885180854,-0.02069725043661756,-0.43119478403587935},
{0.3178756188546642,0.009036330188083717,-0.43284581463367716},
{0.33965389228396825,0.04951400933655172,-0.4398790396517881},
{0.36233621205335004,0.10104615370741658,-0.4499693390767455},
{0.3844398820456247,0.15972199259929476,-0.4577270035560658},
{0.4044829576368244,0.22163225829723665,-0.4577593177643978},
{-0.1843262562712109,0.024355519417081726,-0.5190458440922112},
{-0.23317481836408946,0.024906363945159004,-0.4963417310195358},
{-0.2650373792726147,-0.010079402773310564,-0.46130636574874273},
{-0.2648081738414229,-0.039996347742965274,-0.4372488133922103},
{-0.2656490947512708,-0.06799848799564737,-0.40474447727634805},
{-0.2272891234883714,-0.08546243886602682,-0.41578316114118763},
{-0.17600872934520895,-0.13411636421569662,-0.388812821075477},
{-0.11766279597560352,-0.1793344625771408,-0.35252772258477594},
{-0.057517787844446916,-0.21787028325282337,-0.3023369936062957},
{0.0,-0.24748963690853729,-0.23527899937175165},
{0.05462829642499646,-0.2443589161664227,-0.23170114016550888},
{0.10753041293049288,-0.23565286724722023,-0.22325285341974502},
{0.1647100288272798,-0.19647301688454963,-0.2788761268640789},
{0.2104631903592438,-0.17916988556261293,-0.2657009477832453},
{0.24837226569192986,-0.15821975765846738,-0.25548364600461115},
{0.2566477089977786,-0.1293406248215204,-0.3129458233509984},
{0.2891490391407727,-0.1064651712953639,-0.305152838690478},
{0.31828743713759244,-0.08332970111611775,-0.2986186051684697},
{0.32536725473515876,-0.04783968244902624,-0.3528223079258487},
{0.32674173582909244,-0.014585356102575815,-0.39871299271652777},
{0.3620934797442518,0.026080196350147723,-0.40148449970090566},
{0.38968004424792063,0.08882236503933319,-0.4236031995575208},
{0.4130484773244437,0.1472351813052535,-0.43409254188071694},
{0.43378067219565275,0.2070232301583246,-0.43582323075951923},
{0.4505389709352483,0.26842849241442746,-0.42863895560478676},
{0.42075428877178955,0.28619078609196474,-0.448528726579714},
{-0.1905486201081549,0.07838788172097959,-0.5360934677203604},
{-0.24182901425131736,0.07435161165235321,-0.5112100243183205},
{-0.27122968338087783,0.026190665853049997,-0.47770394774416763},
{-0.2865443636505737,-0.00304768074163366,-0.45055024333350363},
{-0.29394506885180854,-0.02069725043661756,-0.43119478403587935},
{-0.2976409124931238,-0.04493290668558426,-0.3990624370624431},
{-0.2954052201724827,-0.07486713599923048,-0.35642271192860214},
{-0.2626679211593436,-0.09852339097787306,-0.3630050410164998},
{-0.22394046971332035,-0.11840715000706403,-0.3734928803532619},
{-0.21817801972519393,-0.15009837046210822,-0.32335174992710514},
{-0.17113529583281983,-0.1668829714642996,-0.3377225547162211},
{-0.11307492988568285,-0.20956252573864267,-0.29206859028890403},
{-0.05462829642499646,-0.2443589161664227,-0.23170114016550888},
{0.0,-0.2693565865374499,-0.1544604128403137},
{0.051279642649945445,-0.2661229112246033,-0.15189180902453175},
{0.1011494840247572,-0.25705840004088126,-0.14577465423797084},
{0.15698167258342327,-0.22205610047163712,-0.21221943000742477},
{0.20125514397107053,-0.2042532261603807,-0.20088390632186157},
{0.23862539866715166,-0.18293110911380916,-0.191533076222454},
{0.27134391034986516,-0.15989107857312482,-0.18361759816755893},
{0.28078341664888135,-0.13569299698500922,-0.24713004740419212},
{0.31004130206720754,-0.11365921586191763,-0.2395444748715698},
{0.33849058078401784,-0.09418877810208888,-0.23163275428275984},
{0.34639704092030865,-0.06356618100165029,-0.29077076150310666},
{0.35468300513119566,-0.024951453538180384,-0.346408313318564},
{0.3995035635808351,0.03086871112901332,-0.3731336665955253},
{0.4198848111196948,0.08187405875474564,-0.398077980948144},
{0.44247018826408074,0.1369953347301087,-0.4099635976685674},
{0.46310093155099186,0.19392770935849532,-0.41253370447078336},
{0.48015231264522606,0.25252388996936914,-0.4066517670611506},
{-0.2104631903592438,-0.17916988556261293,-0.2657009477832453},
{-0.1647100288272798,-0.19647301688454963,-0.2788761268640789},
{-0.10753041293049288,-0.23565286724722023,-0.22325285341974502},
{-0.051279642649945445,-0.2661229112246033,-0.15189180902453175},
{0.0,-0.28698736890200827,-0.07145197507447298},
{0.04774837602315801,-0.2837018405571871,-0.06994974013364555},
{0.0944236197324083,-0.27435702240351584,-0.06596006264447456},
{0.1389548532934942,-0.25946242684213533,-0.05999846695383727},
{0.14819821986286752,-0.2427995677411016,-0.13769610215498196},
{0.1910152973959257,-0.22398217758686512,-0.12924480943635003},
{0.22819091534879804,-0.20124349582620668,-0.12200943274286007},
{0.26186307192391284,-0.17640063305788603,-0.11588025406482681},
{0.29417126831013224,-0.15127069988066288,-0.11074905837899908},
{0.3016591467245417,-0.136937469752398,-0.1765918880816182},
{0.3318225814693797,-0.1158723633860481,-0.16990660442298847},
{0.36408493676936077,-0.09850009468814537,-0.16301466012967766},
{0.36847666312963856,-0.07935054453198508,-0.22229845703412682},
{0.37581273991420955,-0.05080958364269803,-0.2790407038786068},
{0.3854837061240685,-0.013714375464047085,-0.3313867154035068},
{0.4313691304622284,0.030083400717225126,-0.35015150103255166},
{0.45066897926179317,0.07697732895262886,-0.37395730316138165},
{0.4718588335021688,0.12851172780314482,-0.3859639102897457},
{0.49235280502358186,0.1830543540014008,-0.38817480333422505},
{0.5095988228610249,0.23955011107069746,-0.38242813470365616},
{-0.20125514397107053,-0.2042532261603807,-0.20088390632186157},
{-0.15698167258342327,-0.22205610047163712,-0.21221943000742477},
{-0.1011494840247572,-0.25705840004088126,-0.14577465423797084},
{-0.0944236197324083,-0.27435702240351584,-0.06596006264447456},
{-0.04774837602315801,-0.2837018405571871,-0.06994974013364555},
{-0.04430804007563028,-0.29763377330756213,0.007085078050085524},
{0.0,-0.3009365859963748,0.006580074608246591},
{0.04430804007563028,-0.29763377330756213,0.007085078050085524},
{0.08784730259024683,-0.2881236266461459,0.009863348473416682},
{0.12984750699640185,-0.27280293443071385,0.016180400455705492},
{0.16962855193269027,-0.2514665390130189,0.021545310532027143},
{0.18029073769580156,-0.23937877061721644,-0.05402184139885953},
{0.21738068542193337,-0.21446677047292972,-0.04998406834379912},
{0.2521492706006836,-0.18684714026771196,-0.0467368661530461},
{0.286520315867629,-0.15864435132608495,-0.04313120169777347},
{0.32288507263933436,-0.131863387551064,-0.0408293779740344},
{0.32725350270988457,-0.12767230987973105,-0.10650612767569159},
{0.363247773325598,-0.1074218221606332,-0.10304324693165319},
{0.3975744804927391,-0.0846876493592769,-0.15607161429760935},
{0.39958622783470754,-0.06891155225432939,-0.2119669282865053},
{0.4060099918538135,-0.04387405274279995,-0.2651410853365638},
{0.41654367227681405,-0.010537813635694119,-0.31254076850702345},
{0.4612778090064959,0.025892323045892188,-0.32941103973595537},
{0.4797510152673362,0.0709112757048255,-0.3518055376032176},
{0.5003682316763409,0.12129363545364638,-0.3627187221008143},
{0.5214438589477292,0.17510956771104183,-0.3630290887994445},
{0.5388845135283808,0.2305795365391032,-0.3558327897532397},
{0.5483330377460013,0.16987391446804795,-0.3400085970824028},
{0.5705539406801314,0.22817024928532992,-0.3244421665850044},
{0.5709807888274,0.16712870974626584,-0.3220238614126269},
{0.5889256953566737,0.21532873319285417,-0.30888700848586137},
{0.12076420848225425,-0.2838949743139619,0.08118080626204269},
{0.08173465676298806,-0.299015017840449,0.07412503644742102},
{0.15973664671702673,-0.2612802889341121,0.09960591695699354},
{0.19776070051191716,-0.22779901163612098,0.08662387163293465},
{0.20650808155805586,-0.22390853125159696,0.02147016121032492},
{0.24200711814375164,-0.1928568315242387,0.020991460031081766},
{0.2776504414271157,-0.16104086319516883,0.025146466027997635},
{0.31682052237796504,-0.13072186935440724,0.02772559074881791},
{0.36290283793898476,-0.10416485055805888,0.022516991261636882},
{0.36363178635949633,-0.10851073583209839,-0.041495200964316095},
{0.4002745956214999,-0.0902396812466371,-0.10050921180385425},
{0.43141948050776896,-0.07430351608646382,-0.14923152303627307},
{0.4314074566162966,-0.06263808687862785,-0.2010620102142958},
{0.4364642544736391,-0.04157448349871194,-0.2507883163846563},
{0.4466349636728179,-0.011833387941840435,-0.29465447844867754},
{0.4898818953260128,0.01895528915956001,-0.31041554568928464},
{0.5073751544318561,0.06419142335821278,-0.3315663222823751},
{0.5272979911083323,0.11555297876881365,-0.3413537699408725},
{0.5519462171334442,0.11150092734262979,-0.32299704512867067},
{0.5761420442419086,0.10968306525065306,-0.30924997970968315},
{0.5922751006249418,0.16806131282859038,-0.30957537627265375},
{0.6017131039375239,0.11064422507522442,-0.30171250274295025},
{0.6151062160512939,0.1738613374775679,-0.30316288465180313},
{0.04123518431122641,-0.30845903309876727,0.07217115408316326},
{0.111592233768498,-0.2938109273125701,0.12534455964000468},
{0.1395853561025758,-0.2777259664954264,0.14158057059376983},
{0.304680900950188,-0.12678705087007885,0.10636935591019356},
{0.36237453820741816,-0.09524387457878805,0.08651265063681536},
{0.41498808131757803,-0.06899271352176778,0.07198177779247365},
{0.4114823654601693,-0.07996000553099011,0.013055691659327087},
{0.4056049370098386,-0.08788976195700861,-0.04441926107174956},
{0.4364529820753838,-0.07584783464744448,-0.09905281794926518},
{0.46773989917967,-0.0670222983067355,-0.1419112276092596},
{0.46325198168761333,-0.06074958442425101,-0.19126930210327922},
{0.46698314551012865,-0.04358472785424641,-0.2368015246294387},
{0.4761393388663274,-0.01699389186313205,-0.2776722347304093},
{0.5178329340399374,0.00993060711634014,-0.2926705363557388},
{0.5337833775712341,0.057334799246102,-0.3131847981940115},
{0.5603749650555654,0.05133187142852848,-0.298897409151985},
{0.5885491972549456,0.047174610951961515,-0.29093909598371964},
{0.619704603046253,0.04585649184930455,-0.2915470539962906},
{0.6300707004818574,0.11407854907701603,-0.3021851919764572},
{0.0,-0.31176109429436294,0.07246874539710405},
{-0.12984750699640185,-0.27280293443071385,0.016180400455705492},
{-0.1389548532934942,-0.25946242684213533,-0.05999846695383727},
{-0.08784730259024683,-0.2881236266461459,0.009863348473416682},
{-0.08173465676298806,-0.299015017840449,0.07412503644742102},
{-0.04123518431122641,-0.30845903309876727,0.07217115408316326},
{-0.03880410375415952,-0.3167149375809734,0.11826774801530643},
{-0.16962855193269027,-0.2514665390130189,0.021545310532027143},
{-0.18029073769580156,-0.23937877061721644,-0.05402184139885953},
{-0.12076420848225425,-0.2838949743139619,0.08118080626204269},
{-0.111592233768498,-0.2938109273125701,0.12534455964000468},
{-0.07640281238821538,-0.3076864980716684,0.11925746458212469},
{-0.07189159860643098,-0.3154584409221123,0.1499860222261634},
{-0.14819821986286752,-0.2427995677411016,-0.13769610215498196},
{-0.1910152973959257,-0.22398217758686512,-0.12924480943635003},
{-0.22819091534879804,-0.20124349582620668,-0.12200943274286007},
{-0.23862539866715166,-0.18293110911380916,-0.191533076222454},
{-0.24837226569192986,-0.15821975765846738,-0.25548364600461115},
{-0.2566477089977786,-0.1293406248215204,-0.3129458233509984},
{0.12944620961851197,-0.28857452257635924,0.16710804368279772},
{-0.10363692657310075,-0.30307683867845414,0.15457539130251813},
{-0.12944620961851197,-0.28857452257635924,0.16710804368279772},
{-0.1395853561025758,-0.2777259664954264,0.14158057059376983},
{-0.15973664671702673,-0.2612802889341121,0.09960591695699354},
{-0.14674483198114655,-0.27372125914191503,0.1911701049986323},
{-0.16428468366644522,-0.2472837277670732,0.21223220539211413},
{-0.15559516759801728,-0.26207010830520244,0.17301628335502645},
{-0.17519110472508875,-0.23283551917660392,0.1992388876697999},
{-0.17937090999816638,-0.21771472415689977,0.24063639451590313},
{-0.17031992569235072,-0.2338049454265626,0.2518095956665895},
{-0.17035524587355075,-0.24678849373705555,0.1544160747405094},
{-0.19316607098304334,-0.21469447291768745,0.183044960336188},
{0.45115218940033847,-0.02236706836484094,0.1788786819410168},
{0.41320253343393326,-0.057530187482527806,0.13242588022400512},
{0.36336124880136833,-0.0826075161345594,0.14801034655861198},
{0.3156504474390614,-0.10604583808026549,0.16989232605186505},
{0.15521566352342103,0.3006269707909616,-0.573752295811778},
{0.07916755593364014,0.3106609082246423,-0.591302668402115},
{0.0,0.23436029891394203,-0.603744390103135},
{0.0,0.15686706986782734,-0.5982284298901918},
{0.16210760781673184,0.3786424876229067,-0.5556150070189466},
{0.08269882256042757,0.3897826230720441,-0.5728640308292576},
{0.0,0.31465133720703037,-0.5985500689870773},
{-0.07916755593364014,0.3106609082246423,-0.591302668402115},
{-0.07485548785436663,0.23117246468733368,-0.5964165797439512},
{-0.07054417126831013,0.15471103582819057,-0.5908442575397315},
{-0.14680870890459344,0.2231886007496896,-0.5786167114055629},
{-0.13837470052995302,0.14932207796892424,-0.5729707428660749},
{0.22502562591870046,0.2864883774059055,-0.5500907803806163},
{0.23493331249192145,0.3627431456303676,-0.5326726705964753},
{0.24062061315834563,0.4382186153887775,-0.4993612307655312},
{0.16599433073517078,0.4542374448028233,-0.521440852974861},
{0.0846714922551109,0.46514236287503274,-0.5384629258336314},
{0.0,0.4693161562023742,-0.5457103264185937},
{0.0,0.39416232554084973,-0.5800648388347648},
{-0.08269882256042757,0.3897826230720441,-0.5728640308292576},
{-0.16210760781673184,0.3786424876229067,-0.5556150070189466},
{-0.15521566352342103,0.3006269707909616,-0.573752295811778},
{-0.22502562591870046,0.2864883774059055,-0.5500907803806163},
{-0.21295514186688952,0.21198834584319037,-0.5545268448406985},
{-0.2854794977620532,0.2701824775829573,-0.5245084482867458},
{-0.27039251993711505,0.1991513387100168,-0.5283275368156527},
{-0.333457079216403,0.25364737232881734,-0.5011956257082824},
{-0.31621857631113026,0.18625646659913245,-0.5042023500695882},
{0.2978866507750901,0.34408657502457385,-0.50839117326127},
{0.30520243724280144,0.4187015850494934,-0.4769434366085411},
{0.30872017699168247,0.48991082781486817,-0.4335582302034142},
{0.24318395652160846,0.5092903348954372,-0.45350511466283505},
{0.16766715463626225,0.5243893366118477,-0.474331997679389},
{0.08549738330061833,0.5342301402887538,-0.49092196193837156},
{0.0,0.5378365562372435,-0.4981573386318615},
{-0.0846714922551109,0.46514236287503274,-0.5384629258336314},
{-0.20077719428504437,0.14177633457680414,-0.5488906457130318},
{-0.25503876202013404,0.13315370140469107,-0.5228837199515436},
{-0.28262006607128365,0.07049870592868028,-0.48937012844522065},
{-0.3146524644468559,0.06337154425844148,-0.4668373558260263},
{-0.2992197997420875,0.022727785109011592,-0.4581876688981004},
{-0.2984442587421206,0.12453031673936106,-0.4992312224389862},
{-0.3334067291708625,0.11434758364870998,-0.4756786735242928},
{-0.23493331249192145,0.3627431456303676,-0.5326726705964753},
{-0.2978866507750901,0.34408657502457385,-0.50839117326127},
{-0.34767533088246344,0.32467325074923875,-0.48712616969919237},
{-0.3875488094844456,0.3051569719031716,-0.46759786696165284},
{-0.3720830790781282,0.23731892770935847,-0.4792482663051484},
{0.1673071893853086,0.6707261077761512,0.11196121693805593},
{0.16718244151128292,0.6928463106192004,0.05197327088925696},
{0.08515319940722214,0.7000876992584265,0.056105732089662165},
{0.08522158528997117,0.6777382909841857,0.11813022475659135},
{0.0,0.7024556543852637,0.057154816620625194},
{0.0,0.7153039339166926,-0.009610846752497206},
{0.08512990311749447,0.712918694445864,-0.009702528924973917},
{0.1671411093843467,0.7055510549461782,-0.01153166341520601},
{0.242966023488672,0.6805939652088699,0.043772976905110464},
{0.24312083109137858,0.6589554695179322,0.10106757126410176},
{0.24343044629679175,0.6269516278846068,0.15452579275019465},
{0.16755668513335997,0.6381345984471144,0.1679189048639647},
{0.08535910854868625,0.6448747411105867,0.1760380375806728},
{0.0,0.6800551445722651,0.12003375707530865},
{-0.08522158528997117,0.6777382909841857,0.11813022475659135},
{-0.08515319940722214,0.7000876992584265,0.056105732089662165},
{-0.08512990311749447,0.712918694445864,-0.009702528924973917},
{-0.08512990311749447,0.7172307625251375,-0.07896239828539307},
{0.0,0.7195694094165107,-0.08001749476209227},
{0.08512990311749447,0.7172307625251375,-0.07896239828539307},
{0.1671411093843467,0.7098999461930857,-0.07804257058775788},
{0.24291417045669744,0.6929890943304345,-0.016651586702778415},
{0.30937923654301097,0.6631923882755034,0.030520394022923558},
{0.3095250262271133,0.6423632507792985,0.08499087687234536},
{0.30981810858175196,0.6113626525906977,0.13596090431687763},
{0.31030507618638237,0.5690212702640147,0.18259707037884276},
{0.24394597064366896,0.5834574549630116,0.20344349221903923},
{0.16797226088237327,0.5940129286893057,0.21933682226584225},
{0.08558906547309504,0.6004975636589904,0.22949625906676568},
{0.0,0.6471337297209556,0.17877873334315283},
{-0.08535910854868625,0.6448747411105867,0.1760380375806728},
{-0.16755668513335997,0.6381345984471144,0.1679189048639647},
{-0.1673071893853086,0.6707261077761512,0.11196121693805593},
{-0.16718244151128292,0.6928463106192004,0.05197327088925696},
{-0.1671411093843467,0.7055510549461782,-0.01153166341520601},
{-0.1671411093843467,0.7098999461930857,-0.07804257058775788},
{-0.1671411093843467,0.7069503353162734,-0.14704693225438947},
{-0.08512990311749447,0.7140196320088016,-0.15134171598967147},
{0.0,0.7162215071346766,-0.15381863763297673},
{0.24291417045669744,0.6972665937217251,-0.079501218921998},
{0.3093303894839045,0.6750208915114333,-0.026616386760493094},
{0.3093303894839045,0.6790173324395574,-0.0855845565137929},
{0.36327031812210864,0.6514337739087567,-0.042979400067934985},
{0.3632996263575725,0.6405055595468195,0.011230314635180108},
{-0.242966023488672,0.6805939652088699,0.043772976905110464},
{-0.24291417045669744,0.6929890943304345,-0.016651586702778415},
{-0.24291417045669744,0.6972665937217251,-0.079501218921998},
{-0.24291417045669744,0.6945491942489729,-0.14407177060819848},
{-0.30937923654301097,0.6631923882755034,0.030520394022923558},
{-0.3093303894839045,0.6750208915114333,-0.026616386760493094},
{-0.3093303894839045,0.6790173324395574,-0.0855845565137929},
{-0.3093303894839045,0.6763510345055627,-0.14555070925929822},
{-0.36327031812210864,0.6548387896750845,-0.09853654210917091},
{-0.36327031812210864,0.6518921847711403,-0.15462123238875644},
{-0.40748667602526223,0.6266938657111681,-0.11426905260753116},
{-0.40748667602526223,0.6232595417093766,-0.16716590866050843},
{-0.24312083109137858,0.6589554695179322,0.10106757126410176},
{-0.3095250262271133,0.6423632507792985,0.08499087687234536},
{-0.36338529658431307,0.6208855746368033,0.0632727229004031},
{-0.3632996263575725,0.6405055595468195,0.011230314635180108},
{-0.36327031812210864,0.6514337739087567,-0.042979400067934985},
{-0.40748667602526223,0.6240388401754287,-0.06162469827547336},
{-0.4447314313541006,0.5946494434441236,-0.07843485004704347},
{-0.4777558007761422,0.565076682367865,-0.0892939270330146},
{-0.477578448376925,0.5571814946298295,-0.041353920239515916},
{-0.5090028887399263,0.5298045967337098,-0.04328375482082898},
{-0.5080740431236868,0.5154818875104834,0.002773009970812008},
{-0.5367472668191697,0.48847171830427066,0.005445319850543033},
{-0.534153112234009,0.4682182246123046,0.04954068734575603},
{-0.5297523679551269,0.44079247965707863,0.09227209465207367},
{-0.5539647279143659,0.4158346384265535,0.09253586877124848},
{-0.5480767785589967,0.38852086596066376,0.13233720402439647},
{-0.5433919698440802,0.3622614384782563,0.17037328171075927},
{-0.24343044629679175,0.6269516278846068,0.15452579275019465},
{-0.30981810858175196,0.6113626525906977,0.13596090431687763},
{-0.3635573885310111,0.5914044957330216,0.11232794562796276},
{-0.4073581706851514,0.5683614592194691,0.0876571748063402},
{-0.4074355744865047,0.5959908588365082,0.040052333987633436},
{-0.4074739006405728,0.614177746181663,-0.009946012727289118},
{-0.4446510215798793,0.5858547183253124,-0.028858091026870383},
{0.08512990311749447,0.7140196320088016,-0.15134171598967147},
{0.1671411093843467,0.7069503353162734,-0.14704693225438947},
{0.16718018703163184,0.694897135608454,-0.2170154597184606},
{0.08515319940722214,0.7017154335664968,-0.22489035713963643},
{0.1672959169870533,0.6719360118555571,-0.2864158583104629},
{0.24307499000514024,0.6598504979394058,-0.2741514890086602},
{0.24295475109041664,0.6827665320992814,-0.20930664229824664},
{0.24291417045669744,0.6945491942489729,-0.14407177060819848},
{0.0,0.7037970697776482,-0.2288687622305521},
{0.08522158528997117,0.6787475463746464,-0.29765894833033235},
{0.16752812839111314,0.636262628843512,-0.3537173363473221},
{0.24331546783458732,0.6237292249700154,-0.3375519657559571},
{0.30941079925812587,0.641938657111681,-0.26572349257975597},
{0.30935067980076414,0.6647494822211736,-0.20582647721021669},
{0.3093303894839045,0.6763510345055627,-0.14555070925929822},
{0.0,0.6808344430383172,-0.30302536139308806},
{0.08535910854868625,0.6435445981164575,-0.3676988676500206},
{0.0,0.6458719726095753,-0.37414292198598614},
{0.08558906547309504,0.5945344649819191,-0.43305999020052843},
{0.16791514739787958,0.5860718998650319,-0.41739060513239806},
{-0.24307499000514024,0.6598504979394058,-0.2741514890086602},
{-0.24295475109041664,0.6827665320992814,-0.20930664229824664},
{-0.16718018703163184,0.694897135608454,-0.2170154597184606},
{-0.1672959169870533,0.6719360118555571,-0.2864158583104629},
{-0.08515319940722214,0.7017154335664968,-0.22489035713963643},
{-0.30935067980076414,0.6647494822211736,-0.20582647721021669},
{-0.30941079925812587,0.641938657111681,-0.26572349257975597},
{-0.24331546783458732,0.6237292249700154,-0.3375519657559571},
{-0.16752812839111314,0.636262628843512,-0.3537173363473221},
{-0.08522158528997117,0.6787475463746464,-0.29765894833033235},
{-0.08535910854868625,0.6435445981164575,-0.3676988676500206},
{-0.08558906547309504,0.5945344649819191,-0.43305999020052843},
{0.0,0.5974472526910972,-0.440077433861082},
{0.24371676521247718,0.5723346038578656,-0.39845297606343816},
{0.30953103817284944,0.6056460436888097,-0.3245541390743407},
{0.36315609115312125,0.6176518993239567,-0.2659872666989308},
{0.3632417613798618,0.6402703421698915,-0.21063678529237598},
{0.36327031812210864,0.6518921847711403,-0.15462123238875644},
{0.36327031812210864,0.6548387896750845,-0.09853654210917091},
{0.30973168686179436,0.5535983749710676,-0.3816308004003956},
{0.36298399920642316,0.5817147421927371,-0.3200767424873223},
{0.40711393538961915,0.5891342347243975,-0.27091255324329444},
{0.40739349086635146,0.6114889034511576,-0.2196141232629234},
{0.40748667602526223,0.6232595417093766,-0.16716590866050843},
{0.40748667602526223,0.6266938657111681,-0.11426905260753116},
{0.40748667602526223,0.6240388401754287,-0.06162469827547336},
{-0.24062061315834563,0.4382186153887775,-0.4993612307655312},
{-0.24318395652160846,0.5092903348954372,-0.45350511466283505},
{-0.16766715463626225,0.5243893366118477,-0.474331997679389},
{-0.16599433073517078,0.4542374448028233,-0.521440852974861},
{-0.08549738330061833,0.5342301402887538,-0.49092196193837156},
{-0.16791514739787958,0.5860718998650319,-0.41739060513239806},
{-0.24371676521247718,0.5723346038578656,-0.39845297606343816},
{-0.30973168686179436,0.5535983749710676,-0.3816308004003956},
{-0.30872017699168247,0.48991082781486817,-0.4335582302034142},
{-0.30520243724280144,0.4187015850494934,-0.4769434366085411},
{-0.30953103817284944,0.6056460436888097,-0.3245541390743407},
{-0.36298399920642316,0.5817147421927371,-0.3200767424873223},
{-0.3626969287975207,0.5301367567356338,-0.3723085270432349},
{-0.360948955574727,0.4672292595387035,-0.41960901310904775},
{-0.3563903977202702,0.3973043186812196,-0.4589060964135738},
{0.518600960107734,0.3469189529595306,0.3150853245398607},
{0.5412938007821542,0.33436300428952326,0.30954681953040697},
{0.532226283625564,0.3358847780539933,0.2784515331964614},
{0.5100865419588723,0.34824383550114074,0.2826456168406624},
{0.4845530569241082,0.3600918775607131,0.28870565814272964},
{0.45538985965112677,0.37376905411051753,0.3003042044542506},
{0.4207557917582236,0.38773630704209255,0.3159773469884661},
{0.3788081918772601,0.4004568327266278,0.3342619284518338},
{0.3276713329385489,0.4096866724180947,0.3533964487436536},
{0.333558530800701,0.4126618340642857,0.3783257332319319},
{0.2723832254690069,0.4137191850206359,0.39199764932921716},
{0.2654694878724025,0.4131848733433332,0.37162091074965964},
{0.5600653498501522,0.3187567446516228,0.30256319306461943},
{0.5512067478078942,0.3206768098211145,0.27245161135175594},
{0.5747773325597964,0.29750827394031937,0.2914177971629628},
{0.5672631518827911,0.3002805324179144,0.2609733039549585},
{0.5446762717519712,0.32740267411346347,0.24045904211668587},
{0.5251374481093933,0.3428142970081552,0.24536629282384098},
{0.5622664734828103,0.3072438685668423,0.22880864277319035},
{0.5416725533635334,0.3406808077650291,0.20647050689720475},
{0.5212387012994821,0.3572046406209137,0.21018588936216265},
{0.5607416937454722,0.3197998172368496,0.19514174665059475},
{0.5031209513302932,0.3555648824213713,0.24816410207081474},
{0.4987863384545091,0.3712290070369825,0.21169939670124538},
{0.5217429532481039,0.3811133973204757,0.1728043622678262},
{0.4981671080436828,0.39758011669186677,0.1733086142164481},
{0.5250983704621083,0.4103667737794999,0.1334298751619468},
{0.5000247992761617,0.42989883398312445,0.1331059815854102},
{0.5297523679551269,0.44079247965707863,0.09227209465207367},
{0.5031209513302932,0.4634687874807243,0.09120572577711913},
{0.47809998466953835,0.36774283000321634,0.2534854255405491},
{0.4736624172230222,0.3846108467524973,0.21642403455666412},
{0.472136885992467,0.41333517198673764,0.1777116129749813},
{0.47261859314457827,0.4486673770782546,0.13731434360073466},
{-0.532226283625564,0.3358847780539933,0.2784515331964614},
{-0.5251374481093933,0.3428142970081552,0.24536629282384098},
{-0.5100865419588723,0.34824383550114074,0.2826456168406624},
{-0.518600960107734,0.3469189529595306,0.3150853245398607},
{-0.5412938007821542,0.33436300428952326,0.30954681953040697},
{-0.5212387012994821,0.3572046406209137,0.21018588936216265},
{-0.5031209513302932,0.3555648824213713,0.24816410207081474},
{-0.4845530569241082,0.3600918775607131,0.28870565814272964},
{-0.4987863384545091,0.3712290070369825,0.21169939670124538},
{-0.47809998466953835,0.36774283000321634,0.2534854255405491},
{-0.4736624172230222,0.3846108467524973,0.21642403455666412},
{-0.44521313850621186,0.39920785099993683,0.2297713055841958},
{-0.44954775138199604,0.38143428492414433,0.265960964436335},
{0.5480767785589967,0.38852086596066376,0.13233720402439647},
{0.5433919698440802,0.3622614384782563,0.17037328171075927},
{0.5636432090563951,0.33935066477089976,0.16019054862010818},
{0.5790999215441082,0.29270397780389634,0.1707858514869045},
{0.5943394524921017,0.2600628699225361,0.13955905383998005},
{0.5991445001217419,0.276730237982872,0.10530449002167307},
{0.6096248245263338,0.2378231796579804,0.07301958992518134},
{0.6120792013731284,0.1943868717140959,0.045785475740295976},
{0.6041208882048631,0.14682186003589134,0.02981248741248862},
{0.5878781138121447,0.09775386192364224,0.02024597875979572},
{0.5654768525059293,0.04980709169119039,0.012232806586687755},
{0.5415215032269118,0.008958926386730414,-0.0021410041752963093},
{0.5691959924369723,0.3628122830063336,0.12388065085324541},
{0.5830219646437471,0.31070674931088066,0.13643133907073357},
{0.5886919809661798,0.33169069440979226,0.10211064384932862},
{0.6045139191573657,0.29545143700532955,0.07273928295523205},
{0.6146087275416252,0.25438909613401833,0.041477916620324594},
{0.6165844032091766,0.2087313742406161,0.014796149949950555},
{0.6080496947434553,0.15870897974274886,-0.0008349089641116854},
{0.5922375259640906,0.10824996768579169,-0.010387890738898184},
{0.5723823236771465,0.061281641621902735,-0.018835425991444995},
{0.5519281812962357,0.02213861442686616,-0.03117795058781799},
{0.5206179679022217,-0.01881100246189181,-0.030790931581051548},
{0.5343199437281879,-0.004843749530316734,-0.05241815487373411},
{0.5418942438625549,0.006865266284106492,-0.07104316276441289},
{0.5213521767752525,-0.022506094609990084,-0.07771116207905107},
{0.5324945667040409,-0.009575902317905713,-0.0906097916560205},
{0.5148186947464612,-0.03368681069284668,-0.10221434991327769},
{0.5297057753756715,-0.019268661831058322,-0.11078212408054805},
{0.5169822437182682,-0.041277643677988175,-0.12075669355008402},
{0.5342688421894304,-0.02611251055847973,-0.12617270516516318},
{0.5395052469256413,-0.005892834061279764,-0.12104301246576948},
{0.5494031640870409,-0.009862221233591154,-0.13988595338938473},
{0.5442614474961749,0.0055306143306750235,-0.12946574844215455},
{0.5519815373146442,0.004542400750290834,-0.14652238998890796},
{0.5695634726200962,-0.004486038759014174,-0.1594037352218859},
{0.5660329574865257,0.005224756591346986,-0.16389691316646174},
{0.5864743244827473,-0.001304967971359113,-0.17647991559228185},
{0.5825357485323338,0.006385813611646335,-0.18095731217930025},
{0.600841371805778,0.0006421509539454749,-0.19264528618364687},
{0.5976076964929314,0.006834455062208613,-0.19707158123190782},
{0.6117921309642259,0.001788929603121408,-0.20724229043108658},
{0.6096481208160616,0.00692613723468529,-0.21158817570512609},
{0.618454869826345,0.002568979562390463,-0.21961562624935746},
{0.6170555894562496,0.00701781940716201,-0.22385780545944792},
{0.6228428387205377,0.003473025902468205,-0.2292129461239483},
{0.6219342834211579,0.007440910088345548,-0.23339500587667694},
{0.5539647279143659,0.4158346384265535,0.09253586877124848},
{0.5756257684018145,0.3870990407940577,0.08613765552152126},
{0.5592965722891385,0.44058055856987843,0.051140616404796335},
{0.534153112234009,0.4682182246123046,0.04954068734575603},
{0.581158261465532,0.40912680997141315,0.04688641330323353},
{0.5946032266112766,0.353087960778066,0.06721731079655276},
{0.6094767803625805,0.31412003150259565,0.04039426340137855},
{0.618826107475554,0.270510128625579,0.010287942141034241},
{0.6198721860336488,0.2223183716043779,-0.015446943075891792},
{0.6098359941203171,0.16960187392348594,-0.029157936820462256},
{0.593196431309011,0.11737459832687551,-0.036796865371493154},
{0.574429391200315,0.07065125905173576,-0.044317057994234535},
{0.5563807786070923,0.032718887429322045,-0.05472899651607745},
{0.557148804674889,0.040860564942540825,-0.07525528224582245},
{0.5454029656928316,0.016497154846680344,-0.08764665390130189},
{0.5391700809508494,0.0017265556661085635,-0.10324314412738111},
{0.5426464885727942,0.011117966399235272,-0.11445316844570161},
{0.5453939477742274,0.018898927168283352,-0.12278196776995891},
{0.5468480871491654,0.017275701819515352,-0.13504408259211054},
{0.5538031568727061,0.016919494034646838,-0.1513868055826928},
{0.5666251341415393,0.01609811194844154,-0.168030877353301},
{0.5822839983046313,0.015063305788601926,-0.18442019292333867},
{0.5977512316973826,0.014064571303179415,-0.20000090179186042},
{0.6106829269759011,0.01324694668305921,-0.21411995635327397},
{0.6170555894562496,0.00701781940716201,-0.22385780545944792},
{0.6187351767962942,0.012756973105560732,-0.2261228060155529},
{0.6219342834211579,0.007440910088345548,-0.23339500587667694},
{0.6240189256051775,0.01282535898830976,-0.23572989530196503},
{0.6263868807320145,0.00852606629372564,-0.23971280935218278},
{0.6286421118762983,0.013684315735366165,-0.24266016574934393},
{0.6272781516874029,0.019734587625612064,-0.23667226779611086},
{0.6321463247472728,0.020617592155613203,-0.24403990729579672},
{0.6345217948062801,0.015395465790525748,-0.24674603437029377},
{0.6317405184100808,0.009923092184169952,-0.24277815018441642},
{0.6263868807320145,0.00852606629372564,-0.23971280935218278},
{0.4742012378596271,0.4853590333993646,0.09519615475950716},
{0.5062171033844248,0.4935690967953324,0.04772357674699629},
{-0.5250983704621083,0.4103667737794999,0.1334298751619468},
{-0.5000247992761617,0.42989883398312445,0.1331059815854102},
{-0.4981671080436828,0.39758011669186677,0.1733086142164481},
{-0.5217429532481039,0.3811133973204757,0.1728043622678262},
{-0.472136885992467,0.41333517198673764,0.1777116129749813},
{-0.47261859314457827,0.4486673770782546,0.13731434360073466},
{-0.5031209513302932,0.4634687874807243,0.09120572577711913},
{-0.5062171033844248,0.4935690967953324,0.04772357674699629},
{-0.4742012378596271,0.4853590333993646,0.09519615475950716},
{0.5080740431236868,0.5154818875104834,0.002773009970812008},
{0.5367472668191697,0.48847171830427066,0.005445319850543033},
{0.5379857276408223,0.5018851207349003,-0.03969011425702871},
{0.5090028887399263,0.5298045967337098,-0.04328375482082898},
{0.5383178876427461,0.5087913433993344,-0.08553871542755455},
{0.5636890501426334,0.4780312230401808,-0.08038422345199912},
{0.5635853440786843,0.47158716870421524,-0.035617772513985284},
{0.5623123145690487,0.4591341746049401,0.008323538871738149},
{0.4759785193178846,0.5181594578427335,0.05132398074974976},
{0.4770448881928392,0.5418217247671123,0.005663252883479479},
{0.477578448376925,0.5571814946298295,-0.041353920239515916},
{0.5093125039453393,0.5371316555996767,-0.090085249390539},
{0.5381946427551545,0.5095225462994971,-0.13177583859128086},
{0.5631953190990497,0.4785587712785304,-0.12567897412157958},
{0.5831076348704877,0.44300036672869,-0.12341998551121076},
{0.5843408352396211,0.4428282747819919,-0.0793524232650276},
{0.5848623715322346,0.43707183673960165,-0.03611075206435187},
{0.5840191961427356,0.4258114623757406,0.006052526369896992},
{0.4777558007761422,0.565076682367865,-0.0892939270330146},
{0.5093125039453393,0.5380605012159161,-0.13727150848736439},
{0.4777558007761422,0.5663436999317645,-0.1377246588972288},
{0.4777558007761422,0.5618197107652907,-0.18621250424593666},
{0.5093125039453393,0.533187067703527,-0.18448106387391747},
{0.5380661374150437,0.504410889437312,-0.17807683867845409},
{-0.4770448881928392,0.5418217247671123,0.005663252883479479},
{-0.4759785193178846,0.5181594578427335,0.05132398074974976},
{0.5375077779547962,0.49242532411902457,-0.22264714988682513},
{0.5090607537176369,0.520911426003469,-0.23030787174114967},
{0.4775378677432058,0.5496507811020499,-0.23357310976911122},
{0.47688482013761346,0.5279807226959969,-0.27862362514315947},
{0.5083040000480956,0.4996351500431357,-0.27334889425288045},
{0.5360972251864455,0.4725348016508804,-0.26369370940057896},
{0.5067897412157958,0.46775680777705303,-0.31219883909327834},
{0.5341350763968005,0.4429139450087324,-0.2997398330482669},
{0.5580137733676815,0.44572528113361254,-0.2527083815541481},
{0.5549814982369969,0.42058257257169995,-0.28483922554115026},
{0.5319226803658871,0.40173812866165076,-0.32930733367200626},
{0.5541608676440086,0.38380449453063237,-0.3094927120187813},
{0.528034454461014,0.35206292403004774,-0.35278473326499754},
{0.5529126374105348,0.3380363031343279,-0.32863324425633733},
{0.5210433130630563,0.2969431510411187,-0.37056205680687526},
{0.5485975633583932,0.2859255089863558,-0.3442237225366804},
{0.5720922472953759,0.28293757195547553,-0.3130149607269645},
{0.5612497031601793,0.4622716587860079,-0.21439800884357219},
{0.5626797947521726,0.47326149559174086,-0.1712021787291348},
{0.5818180725100776,0.4375077028054746,-0.16806018558876487},
{0.5967246919629303,0.40067551725278133,-0.12943944617955877},
{0.5991903412079802,0.4011572244048925,-0.08717321317457788},
{0.600875940493761,0.39650172392543986,-0.04621307538078161},
{0.6011164183232083,0.3868465390731384,-0.006721355333046758},
{0.599247454692474,0.37232994459992,0.031142630406617956},
{0.5791164543948827,0.4277833805772069,-0.21020693117223924},
{0.5736493412410459,0.4152620005951826,-0.2467918754565321},
{0.5899394597064367,0.38629268857219295,-0.21471889644724068},
{0.594144815748893,0.3949190792103911,-0.17285320932693263},
{0.6060259235100144,0.3561037030579762,-0.14093503792034773},
{0.6095759774672274,0.3570671173621987,-0.1010247361507315},
{0.6122535477994776,0.35326230720441515,-0.06300970027444532},
{0.6135821878071729,0.3443007505914252,-0.02693952884381265},
{0.6128832991153422,0.3309850422790084,0.007443540314605126},
{0.5670993263614803,0.403710798356334,-0.2721667954225045},
{0.5825988739625636,0.3771996206462241,-0.25234165286424126},
{0.5962317124125638,0.34300442479206183,-0.2243199737879166},
{0.6020768266545626,0.35076058628494816,-0.18269175852418756},
{0.6129900111521593,0.31380290136501227,-0.15509993356799961},
{0.6168369049300961,0.314605496120792,-0.11808588665678703},
{0.6196226902855975,0.3107368090395616,-0.08358483306329677},
{0.6213947112913358,0.30023243685202494,-0.05154116228946917},
{0.6213856933727316,0.2858901888051559,-0.02067583287993242},
{0.4755772219399948,0.49495635327395543,-0.3201796970580544},
{0.4733986431038473,0.4487222360830972,-0.3570569722037689},
{0.5042677299794692,0.4236787246258316,-0.34545316543972876},
{0.4996866273285017,0.3708277096590926,-0.3726121303029119},
{0.4919981002251474,0.3126328264261086,-0.3931782451731591},
{-0.4755772219399948,0.49495635327395543,-0.3201796970580544},
{-0.4431262418425411,0.5243577738967329,-0.3216473633108987},
{-0.44408890465354656,0.5585289219679503,-0.27646834259673975},
{-0.40711393538961915,0.5891342347243975,-0.27091255324329444},
{-0.40739349086635146,0.6114889034511576,-0.2196141232629234},
{-0.3632417613798618,0.6402703421698915,-0.21063678529237598},
{0.573004560060841,0.33139986653480463,-0.2992791677062323},
{0.5710348963390256,0.37418763583239895,-0.2843800631855497},
{0.4619887215897989,0.33169069440979226,-0.412384908813813},
{0.46923912814762936,0.39304485512713766,-0.3881582704834506},
{0.4380634320394624,0.41742855553985764,-0.3994674919064181},
{0.4315442283817946,0.3528129142606359,-0.42849617189355244},
{-0.4996866273285017,0.3708277096590926,-0.3726121303029119},
{-0.528034454461014,0.35206292403004774,-0.35278473326499754},
{-0.46923912814762936,0.39304485512713766,-0.3881582704834506},
{-0.4733986431038473,0.4487222360830972,-0.3570569722037689},
{-0.44152030083776467,0.4759676226662379,-0.36324927631203197},
{-0.40562372434026417,0.5036826925100175,-0.3672569896384115},
{-0.40655557592937164,0.5539478193169829,-0.3203608069233567},
{-0.36315609115312125,0.6176518993239567,-0.2659872666989308},
{-0.4919981002251474,0.3126328264261086,-0.3931782451731591},
{-0.5210433130630563,0.2969431510411187,-0.37056205680687526},
{-0.4619887215897989,0.33169069440979226,-0.412384908813813},
{-0.48015231264522606,0.25252388996936914,-0.4066517670611506},
{-0.5095988228610249,0.23955011107069746,-0.38242813470365616},
{-0.4505389709352483,0.26842849241442746,-0.42863895560478676},
{-0.42075428877178955,0.28619078609196474,-0.448528726579714},
{-0.4315442283817946,0.3528129142606359,-0.42849617189355244},
{-0.5529126374105348,0.33803705462754496,-0.32863324425633733},
{-0.5485975633583932,0.2859255089863558,-0.3442237225366804},
{-0.5388845135283808,0.2305795365391032,-0.3558327897532397},
{-0.5214438589477292,0.17510956771104183,-0.3630290887994445},
{-0.49235280502358186,0.1830543540014008,-0.38817480333422505},
{-0.46310093155099186,0.19392770935849532,-0.41253370447078336},
{-0.43378067219565275,0.2070232301583246,-0.43582323075951923},
{-0.4044829576368244,0.22163225829723665,-0.4577593177643978},
{-0.5720922472953759,0.28293757195547553,-0.3130149607269645},
{-0.573004560060841,0.33139986653480463,-0.2992791677062323},
{-0.5705539406801314,0.22817024928532992,-0.3244421665850044},
{-0.5483330377460013,0.16987391446804795,-0.3400085970824028},
{-0.5272979911083323,0.11555297876881365,-0.3413537699408725},
{-0.5003682316763409,0.12129363545364638,-0.3627187221008143},
{-0.4718588335021688,0.12851172780314482,-0.3859639102897457},
{-0.3844398820456247,0.15972199259929476,-0.4577270035560658},
{-0.3532837247611003,0.1731616972925202,-0.48103907464131235},
{-0.5710348963390256,0.37418763583239895,-0.2843800631855497},
{-0.5869921033092755,0.33480262782148124,-0.2638455110304174},
{-0.5889610155378737,0.2913377631353499,-0.2757889927285516},
{-0.5930543990909938,0.2583066302743551,-0.28347676833868896},
{-0.5889256953566737,0.21532873319285417,-0.30888700848586137},
{-0.5709807888274,0.16712870974626584,-0.3220238614126269},
{-0.5519462171334442,0.11150092734262979,-0.32299704512867067},
{0.3563903977202702,0.3973043186812196,-0.4589060964135738},
{0.360948955574727,0.4672292595387035,-0.41960901310904775},
{0.40301453989076297,0.4426133477219235,-0.40909862897577487},
{0.39742493334255163,0.3750127753846894,-0.4433802465498946},
{0.44152030083776467,0.4759676226662379,-0.36324927631203197},
{0.40562372434026417,0.5036826925100175,-0.3672569896384115},
{0.3626969287975207,0.5301367567356338,-0.3723085270432349},
{0.34767533088246344,0.32467325074923875,-0.48712616969919237},
{0.3875488094844456,0.3051569719031716,-0.46759786696165284},
{0.40655557592937164,0.5539478193169829,-0.3203608069233567},
{0.4431262418425411,0.5243577738967329,-0.3216473633108987},
{0.44408890465354656,0.5585289219679503,-0.27646834259673975},
{0.4445706118056578,0.580562703091042,-0.22863429634684118},
{0.4447314313541006,0.5925392504907251,-0.17906880972492342},
{0.4447314313541006,0.5965417033645856,-0.12869471640148974},
{-0.40301453989076297,0.4426133477219235,-0.40909862897577487},
{-0.4380634320394624,0.41742855553985764,-0.3994674919064181},
{-0.39742493334255163,0.3750127753846894,-0.4433802465498946},
{0.4447314313541006,0.5946494434441236,-0.07843485004704347},
{0.4446510215798793,0.5858547183253124,-0.028858091026870383},
{0.4074739006405728,0.614177746181663,-0.009946012727289118},
{0.4074355744865047,0.5959908588365082,0.040052333987633436},
{0.36338529658431307,0.6208855746368033,0.0632727229004031},
{0.4073581706851514,0.5683614592194691,0.0876571748063402},
{0.3635573885310111,0.5914044957330216,0.11232794562796276},
{0.4072289138518235,0.5301713254236168,0.13215383967944305},
{0.3638437074466966,0.5508922478965705,0.15757610371808786},
{0.40750696634212186,0.4875947257200056,0.17377153403813378},
{0.3646124850077103,0.5058214422056626,0.19921784585972327},
{0.4086507390184296,0.44680667987290745,0.21273720883395308},
{0.36622894691752517,0.46266544123172754,0.23745457223503103},
{0.4111193942363476,0.4139829591398107,0.2492793180048757},
{0.3690613248524819,0.4278983590394113,0.27248542854652197},
{0.3113661846088177,0.5219349597650531,0.22494145867839396},
{0.24517315906706624,0.5349703611075207,0.24753961120746923},
{0.16911077310616196,0.5443647778135156,0.2659857637124967},
{0.08625413697015971,0.5495568444499219,0.279251121979373},
{0.0,0.6027219835813762,0.2331425041557575},
{-0.08558906547309504,0.6004975636589904,0.22949625906676568},
{-0.16797226088237327,0.5940129286893057,0.21933682226584225},
{-0.24394597064366896,0.5834574549630116,0.20344349221903923},
{-0.31030507618638237,0.5690212702640147,0.18259707037884276},
{-0.3638437074466966,0.5508922478965705,0.15757610371808786},
{-0.4072289138518235,0.5301713254236168,0.13215383967944305},
{-0.4431262418425411,0.507960191901308,0.110103525705577},
{-0.44392883659832083,0.5435185964511484,0.06597884997490014},
{-0.4444105437504321,0.5691475211244744,0.01946893477339474},
{0.4444105437504321,0.5691475211244744,0.01946893477339474},
{0.44392883659832083,0.5435185964511484,0.06597884997490014},
{0.4431262418425411,0.507960191901308,0.110103525705577},
{0.44264453469042986,0.4682212305851728,0.15200303002065105},
{0.4431262418425411,0.430053641585831,0.1918389339617821},
{0.44521313850621186,0.39920785099993683,0.2297713055841958},
{0.3133779319507862,0.4767010800460516,0.26303690432890153},
{0.2476155120223885,0.4879847506996403,0.28653233975910136},
{0.1715275752921054,0.49519232214410036,0.30763727526595347},
{0.08769850693327642,0.49700191781068986,0.3260473560965639},
{0.0,0.5511026659973367,0.2845889782998819},
{-0.08625413697015971,0.5495568444499219,0.279251121979373},
{-0.16911077310616196,0.5443647778135156,0.2659857637124967},
{-0.24517315906706624,0.5349703611075207,0.24753961120746923},
{-0.3113661846088177,0.5219349597650531,0.22494145867839396},
{-0.3646124850077103,0.5058214422056626,0.19921784585972327},
{-0.40750696634212186,0.4875947257200056,0.17377153403813378},
{-0.44264453469042986,0.4682212305851728,0.15200303002065105},
{0.3167205737801011,0.43991548707281375,0.29692699393695277},
{0.25177803295147455,0.44899728260052724,0.32014212239720324},
{0.17698041007481866,0.45347543068076274,0.3424997970968314},
{0.09507591584478357,0.45168311935816463,0.36436975269861216},
{0.0,0.49655703382621275,0.3345790585894172},
{-0.08769850693327642,0.49700191781068986,0.3260473560965639},
{-0.1715275752921054,0.49519232214410036,0.30763727526595347},
{-0.2476155120223885,0.4879847506996403,0.28653233975910136},
{-0.3133779319507862,0.4767010800460516,0.26303690432890153},
{-0.36622894691752517,0.46266544123172754,0.23745457223503103},
{-0.4086507390184296,0.44680667987290745,0.21273720883395308},
{-0.4431262418425411,0.430053641585831,0.1918389339617821},
{-0.4111193942363476,0.4139829591398107,0.2492793180048757},
{-0.3690613248524819,0.4278983590394113,0.27248542854652197},
{-0.41537059136504234,0.3952978317917702,0.2836255639956594},
{-0.3167205737801011,0.43991548707281375,0.29692699393695277},
{-0.3734763475024874,0.4079913037204925,0.3045125664695751},
{-0.4207557917582236,0.38773630704209255,0.3159773469884661},
{-0.45538985965112677,0.37376905411051753,0.3003042044542506},
{0.2734721391404721,0.42447305295622395,0.4088040436347022},
{0.2127883103727106,0.41579931824535354,0.4176032777128154},
{0.20757294744657637,0.4082836345819143,0.40498796107866325},
{0.41537059136504234,0.3952978317917702,0.2836255639956594},
{0.44954775138199604,0.38143428492414433,0.265960964436335},
{0.3734763475024874,0.4079913037204925,0.3045125664695751},
{0.32177211118492444,0.4181740368111438,0.3266553141091349},
{-0.32177211118492444,0.4181740368111438,0.3266553141091349},
{-0.25816497380294645,0.42450386417812186,0.34808714916539163},
{-0.1986384445893991,0.41168263840250574,0.38882484496694936},
{-0.20757294744657637,0.4082836345819143,0.40498796107866325},
{-0.25177803295147455,0.44899728260052724,0.32014212239720324},
{-0.17698041007481866,0.45347543068076274,0.3424997970968314},
{-0.09507591584478357,0.45168311935816463,0.36436975269861216},
{-0.11353709821415152,0.4224515362024343,0.38870235157257466},
{-0.18722927456856775,0.42619246943677086,0.3687787634028815},
{0.0,0.4373897183704021,0.3897521875967548},
{-0.054139074340715,0.41229811134724703,0.40608589266873285},
{-0.07995887829116455,0.3963965148750567,0.4181849334627906},
{-0.1336132395069002,0.40591117049577513,0.40489853338583764},
{0.17118639737157731,0.4496999287584431,0.44406936582990403},
{0.2100258213069369,0.45796860862533856,0.4351852130182673},
{0.21303855761397897,0.43403129518352973,0.4270044578577634},
{0.1635700136170571,0.4231256256181032,0.4376155420821171},
{0.2127883103727106,0.41579931824535354,0.4176032777128154},
{0.26330142994129335,0.4438089734302058,0.42162827538318637},
{0.24840382840704478,0.4669339227044137,0.4322108028652934},
{0.17515277857102063,0.47529428474378593,0.45135734704858554},
{0.15441457175407536,0.4034778354590571,0.4298962037568648},
{0.1458340222021156,0.3986630184175958,0.4188101758193531},
{0.20757294744657637,0.4082836345819143,0.40498796107866325},
{0.1986384445893991,0.41168263840250574,0.38882484496694936},
{0.1336132395069002,0.40591117049577513,0.40489853338583764},
{0.18722927456856775,0.42619246943677086,0.3687787634028815},
{0.25816497380294645,0.42450386417812186,0.34808714916539163},
{0.09390734389231403,0.38653767536094225,0.4305379789642019},
{0.07995887829116455,0.3963965148750567,0.4181849334627906},
{0.11353709821415152,0.4224515362024343,0.38870235157257466},
{0.054139074340715,0.41229811134724703,0.40608589266873285},
{-0.1458340222021156,0.3986630184175958,0.4188101758193531},
{-0.09390734389231403,0.38653767536094225,0.4305379789642019},
{0.03277036471468808,0.3734932560998704,0.4323806403323403},
{0.017299373855851577,0.3752682830784769,0.42989169479756273},
{0.02608357806962434,0.39474773875690994,0.4191588686720514},
{0.047237360635582905,0.3836654682854833,0.4270292571339251},
{0.0,0.37703203765882803,0.4285382555137057},
{0.0,0.4005409999669342,0.4158102148970004},
{-0.02608357806962434,0.39474773875690994,0.4191588686720514},
{-0.047237360635582905,0.3836654682854833,0.4270292571339251},
{-0.03277036471468808,0.3734932560998704,0.4323806403323403},
{-0.017299373855851577,0.3752682830784769,0.42989169479756273},
{-0.03428011458768573,0.3633428372175513,0.44010148164402674},
{-0.05853305518064394,0.3735886957384323,0.4372488133922103},
{-0.06127299944990696,0.36667646112826185,0.45154522035284117},
{0.6229615746488272,0.23352163248374522,-0.05224305695416793},
{0.6087718797250136,0.17411158471883634,-0.05688878802179931},
{0.5914221558236216,0.12267638297296724,-0.061480411577805094},
{0.5733517499271051,0.07725613293614411,-0.06706776364636532},
{0.6244360043406249,0.2606866092926645,-0.07807939375539195},
{0.6234515482263258,0.27354240375626365,-0.10481677092382563},
{0.6225873310267501,0.23170602487141953,-0.10410510684730559},
{0.6170052394107091,0.20660840590252835,-0.09021150025099874},
{0.6041486934538929,0.1668499057627506,-0.08575815144692504},
{0.5875850314575061,0.12170169627048942,-0.08693799579764994},
{0.5708823432159702,0.08043645223058217,-0.08994021119965372},
{0.5565025205082499,0.046723715021748186,-0.0952149420899327},
{0.5469089580997443,0.02423377751592413,-0.10321158141226616},
{0.5479685635357455,0.029473188225003055,-0.11912369878949472},
{0.5501396274397228,0.03161644687995045,-0.13677176549804462},
{0.5560516245780365,0.0310573359264859,-0.15475199220851832},
{0.5683340297170477,0.028191892289980196,-0.17166134108473535},
{0.5839192475448717,0.024724502586639652,-0.18750281809956382},
{0.5997404342428405,0.02236030492588771,-0.20227717474622073},
{0.6131914113343213,0.020835525188549617,-0.2156131733754971},
{0.6216652488494638,0.01988338328258249,-0.22713732185853291},
{0.6240159196323094,0.028495495549657145,-0.2276303014088995},
{0.6297693517018316,0.028191140796763152,-0.23691575159842607},
{0.6348066107355315,0.029137270756994137,-0.244521614447908},
{0.6383837184485572,0.022761602303777603,-0.24906213646515624},
{0.6217734638727151,0.27876002116204895,-0.13409269217936037},
{0.6242090533890841,0.2462932597070379,-0.12358155655287054},
{0.6208070435956246,0.2776545746398093,-0.16942865473696234},
{0.6283783377571235,0.260298087299464,-0.1638608414920447},
{0.625185243077996,0.25451910446056314,-0.14478042871185046},
{0.6234725900364023,0.22647112312164272,-0.14041425312095132},
{0.6187193954387368,0.21064843343723977,-0.1281115576650805},
{0.6111000057113485,0.1876580014488789,-0.11850296539223437},
{0.5983997703436729,0.154689994018114,-0.11357166690213454},
{0.5832421521563347,0.11729418855265407,-0.11209347974425182},
{0.5682498624767413,0.08102111395342543,-0.11284722744092511},
{0.5557247250286319,0.05027827793826331,-0.11535120284004316},
{0.556097465664275,0.05149118799053719,-0.13640503680813776},
{0.5596896032416412,0.0508824784847492,-0.15994105287205676},
{0.5712716167023877,0.04055996765573192,-0.17712770274535503},
{0.5864224714507728,0.035117653778057006,-0.1914579269007518},
{0.6020452639394477,0.03175171565901446,-0.20474282399127064},
{0.6154676842886816,0.02977378551181195,-0.21684637374463056},
{0.6239588061478157,0.0386895010385636,-0.22832994159394715},
{0.629548412696027,0.03821906628470771,-0.23715397494822213},
{0.6345308127248843,0.039056229728470476,-0.24477336467561045},
{0.6412048239852587,0.03160893194778022,-0.2502660285988259},
{0.5869921033092755,0.3348033793146983,-0.2638455110304174},
{0.6005054543377691,0.3031241827511265,-0.2353954808203901},
{0.5889610155378737,0.2913377631353499,-0.2757889927285516},
{0.6058989211563376,0.27467264955466514,-0.2446734160777465},
{0.6145035184912422,0.2818103321299422,-0.20649455468014946},
{0.6080309074130297,0.31029417953473554,-0.19468483877464518},
{0.5930543990909938,0.2583066302743551,-0.28347676833868896},
{-0.6005054543377691,0.3031241827511265,-0.2353954808203901},
{-0.6058989211563376,0.27467264955466514,-0.2446734160777465},
{-0.6080309074130297,0.31029417953473554,-0.19468483877464518},
{-0.6145035184912422,0.2818103321299422,-0.20649455468014946},
{-0.26186307192391284,-0.17640063305788603,-0.11588025406482681},
{-0.27134391034986516,-0.15989107857312482,-0.18361759816755893},
{-0.28078341664888135,-0.13569299698500922,-0.24713004740419212},
{-0.2891490391407727,-0.1064651712953639,-0.305152838690478},
{-0.21738068542193337,-0.21446677047292972,-0.04998406834379912},
{-0.20650808155805586,-0.22390853125159696,0.02147016121032492},
{-0.19776070051191716,-0.22779901163612098,0.08662387163293465},
{-0.1933283935179201,-0.2243669421139805,0.13974692714423562},
{-0.304680900950188,-0.12678705087007885,0.10636935591019356},
{0.4456490045720848,-0.06930308022039797,-0.04889365168589988},
{0.4581463367711643,-0.05669753299806718,0.0028759645415440535},
{0.4798945504717875,-0.05238771939844474,-0.055720967562546776},
{0.46891598606430973,-0.06244645610828718,-0.09854781450742624},
{0.4660926260479573,-0.04248153581165777,0.05808291074364764},
{0.49661752903018297,-0.03583082084101112,-0.010810229926864675},
{0.5044736391209332,-0.03678296274697825,-0.06570380345746998},
{0.4947966609653381,-0.048235719374396954,-0.09886945360431176},
{0.4959554635059864,-0.05542901244773365,-0.12370630442689623},
{-0.4002745956214999,-0.0902396812466371,-0.10050921180385425},
{-0.363247773325598,-0.1074218221606332,-0.10304324693165319},
{-0.3975744804927391,-0.0846876493592769,-0.15607161429760935},
{-0.43141948050776896,-0.07430351608646382,-0.14923152303627307},
{-0.46773989917967,-0.0670222983067355,-0.1419112276092596},
{-0.36408493676936077,-0.09850009468814537,-0.16301466012967766},
{-0.36847666312963856,-0.07935054453198508,-0.22229845703412682},
{-0.39958622783470754,-0.06891155225432939,-0.2119669282865053},
{-0.2736134198652723,-0.12755733141752665,0.2026544243411659},
{-0.24066194528528187,-0.13414416946472643,0.269545587081531},
{-0.2401659597620472,-0.12353533972002369,0.29781375593303894},
{-0.20944642003661273,-0.14239556498763045,0.3134951648926417},
{-0.20598353929257435,-0.13392172747248784,0.32975522362935156},
{-0.199783720252141,-0.12762646879349268,0.3412598332887447},
{-0.19658536512049443,-0.1218076568140896,0.3491009135151546},
{0.4616325138049304,-0.03110317701272428,0.1185540669309919},
{0.23501146778649176,-0.11645627361567436,0.32109952475568954},
{0.2242192736968356,-0.11344428880184927,0.3364262289168578},
{0.24881564668997297,-0.09892468835576292,0.3363270318122109},
{-0.23501146778649176,-0.11645627361567436,0.32109952475568954},
{-0.2242192736968356,-0.11344428880184927,0.3364262289168578},
{-0.21451223581255954,-0.11354423739971327,0.34450252652019564},
{0.22452964039546577,-0.10555060405024787,0.347591915135374},
{0.21451223581255954,-0.11354423739971327,0.34450252652019564},
{0.20212612460959928,-0.11476541387737436,0.3543666264868294},
{0.19658536512049443,-0.1218076568140896,0.3491009135151546},
{-0.45066897926179317,0.07697732895262886,-0.37395730316138165},
{-0.3995035635808351,0.03086871112901332,-0.3731336665955253},
{-0.3854837061240685,-0.013714375464047085,-0.3313867154035068},
{-0.37581273991420955,-0.05080958364269803,-0.2790407038786068},
{-0.4313691304622284,0.030083400717225126,-0.35015150103255166},
{-0.41654367227681405,-0.010537813635694119,-0.31254076850702345},
{-0.4060099918538135,-0.04387405274279995,-0.2651410853365638},
{-0.4364642544736391,-0.04157448349871194,-0.2507883163846563},
{-0.4314074566162966,-0.06263808687862785,-0.2010620102142958},
{-0.46325198168761333,-0.06074958442425101,-0.19126930210327922},
{-0.4944299322754313,-0.06346397792413529,-0.18427440323923636},
{-0.4987074316667218,-0.06712525287746755,-0.15120419273095642},
{-0.526410477619029,-0.0685102548764395,-0.1802321212248738},
{-0.5293743668669647,-0.07028528185504601,-0.15211875997607247},
{-0.5606612839712509,-0.07361740277932254,-0.1792980151561152},
{-0.5629202725816197,-0.07357156169308417,-0.15385245482774274},
{-0.6000102203077515,-0.07517675120464365,-0.1616559603933015},
{-0.5981923582157748,-0.07669025854372642,-0.18573079709382542},
{-0.6413077785559907,-0.073295763682437,-0.18077695380721492},
{-0.6400122042498445,-0.07563516206702721,-0.20379068208530352},
{-0.5995510579521509,-0.06929706827466178,-0.2152066155450881},
{-0.6409643461558117,-0.06915052709734244,-0.2316898677672535},
{-0.6849454866820373,-0.0701883392300501,-0.22931665218789735},
{-0.6856774410754168,-0.0641410733126723,-0.2557316387662285},
{-0.7318161186277133,-0.06008601591362037,-0.25814393199286984},
{-0.7326014290395015,-0.054215350902242776,-0.28306720453541184},
{-0.7794495161886669,-0.04506441799856317,-0.2861115035575689},
{-0.7806451418969492,-0.039320003847645266,-0.30943259256141953},
{-0.8266703439734753,-0.024859771365703665,-0.30905684595290844},
{-0.8287166600034268,-0.01940167613047124,-0.3305630788376504},
{-0.8714255225132338,0.0004760709529835852,-0.327100198093612},
{-0.8745352014452717,0.005458470981840902,-0.34671191657824096},
{-0.4797510152673362,0.0709112757048255,-0.3518055376032176},
{-0.4612778090064959,0.025892323045892188,-0.32941103973595537},
{-0.4466349636728179,-0.011833387941840435,-0.29465447844867754},
{-0.4761393388663274,-0.01699389186313205,-0.2776722347304093},
{-0.46698314551012865,-0.04358472785424641,-0.2368015246294387},
{-0.4973757856861584,-0.04957863775321565,-0.22400134066389915},
{-0.5288295342846235,-0.05733479924610204,-0.2145340291158532},
{-0.5625302476019852,-0.06463254987660483,-0.21054510311989924},
{-0.5680920489011666,-0.0435509106594804,-0.24277815018441642},
{-0.6037887282029393,-0.049043574582695836,-0.2456338244091009},
{-0.6439567921459941,-0.049330644991598324,-0.2602999660325066},
{-0.687611033122815,-0.04455415410420505,-0.2825050876090793},
{-0.7337654920326689,-0.03485914011140135,-0.3079792046796986},
{-0.7814334582816056,-0.020387635231204425,-0.33244932681237616},
{-0.8287166600034268,-0.01940167613047124,-0.3305630788376504},
{-0.8296282212756748,-0.0012839261612824695,-0.3516447180547749},
{-0.8745352014452717,0.005458470981840902,-0.34671191657824096},
{-0.875860835480099,0.022274634699147176,-0.36590580483420554},
{-0.9158177298291705,0.035180779208286855,-0.35813160750411066},
{-0.9176408523736665,0.050110694950867375,-0.3755722620847624},
{-0.9502812087618098,0.0696840872814282,-0.365074653336179},
{-0.9524770719419487,0.08204539920822672,-0.3809845162337564},
{-0.5073751544318561,0.06419142335821278,-0.3315663222823751},
{-0.4898818953260128,0.01895528915956001,-0.31041554568928464},
{-0.5178329340399374,0.00993060711634014,-0.2926705363557388},
{-0.5054370534251558,-0.02541061589378094,-0.2615384268541592},
{-0.5356981822882066,-0.03496810662786958,-0.24899375058240725},
{0.7226997544120167,0.3285201445271755,-0.22408175043812056},
{0.7249820393121131,0.32120285507303015,-0.21651947419522594},
{0.7485864412587813,0.3317771161297498,-0.23092184169945681},
{0.747869516729742,0.3395347806090703,-0.23883356228826677},
{0.7753929558031809,0.34097614459931885,-0.24703235328597925},
{0.7763308193380246,0.34913210048366106,-0.2552198718854364},
{0.8058517273823086,0.34854142681508155,-0.26454289673581405},
{0.8084150707455714,0.3570558449639434,-0.27286718710076924},
{0.8379480026813277,0.3525994901870016,-0.2819580005470871},
{0.8421045116646778,0.36133860480775304,-0.29026275208839963},
{0.8696647739057507,0.3512768621250425,-0.2977851991907921},
{0.8753813828076387,0.36001447375935985,-0.30589230801602785},
{0.8989887907271749,0.3426993185459508,-0.310530524151489},
{0.906227173393533,0.3511160425765997,-0.31824159605135405},
{0.880495294149475,0.3650141581322087,-0.31879244057943135},
{0.9126599553312431,0.3559323626044951,-0.33028803232022025},
{0.8843714961628757,0.36515168139092374,-0.33680648448467104},
{0.9175108440471217,0.3560698858632102,-0.3469088078011008},
{0.720309254488669,0.33269694382738496,-0.23767250526796743},
{0.747869516729742,0.3395347806090703,-0.23883356228826677},
{0.7470210808877239,0.34394905176585877,-0.2527429502421311},
{0.7763308193380246,0.34913210048366106,-0.2552198718854364},
{0.7770755491160937,0.3537477718226115,-0.26930736373173497},
{0.8084150707455714,0.3570558449639434,-0.27286718710076924},
{0.8106853317541955,0.3618834373900941,-0.28682241614087195},
{0.8421045116646778,0.36133860480775304,-0.29026275208839963},
{0.8458311665278909,0.3663179988637422,-0.30381067180487625},
{0.8486177033766094,0.3664066750633509,-0.32301207499301116},
{0.7004886208897079,0.3163482088910665,-0.21133642547742362},
{0.7041296055261805,0.3095141295754664,-0.2041348659786997},
{0.6967273973385116,0.3202011146147395,-0.22463785541871698},
{0.692782809442362,0.3202011146147395,-0.24472752358937205},
{0.7177000700391678,0.3328089163167213,-0.25790871461594184},
{0.7458517574420374,0.3440294615400801,-0.2732346672838931},
{0.7773393232352684,0.35376505616660303,-0.28985018231225446},
{0.8122679764692444,0.3619180060780771,-0.3069008119132717},
{0.6809032046676746,0.3032759843809649,-0.2009703280418191},
{0.6855789954639869,0.2969694533037145,-0.19407838374850825},
{0.6760643398432685,0.3066704792422543,-0.21418007581063572},
{0.6709955180944537,0.30630375055234754,-0.23454554199193797},
{0.7272635727189927,0.3116701636151032,-0.21436945210132535},
{0.7249820393121131,0.32120285507303015,-0.21651947419522594},
{0.7041296055261805,0.3095141295754664,-0.2041348659786997},
{0.7077127251849424,0.30056985730646796,-0.20234631212218682},
{0.6855789954639869,0.2969694533037145,-0.19407838374850825},
{0.6901570921420863,0.2885985703593039,-0.19266783098015758},
{0.6688800646885361,0.2838280914176468,-0.1866596427100649},
{0.6740458290623469,0.27598475671158595,-0.18565038731960404},
{0.6543311560069859,0.2708535610257582,-0.18036438403106975},
{0.6596494735038522,0.26302751066368874,-0.18024940556886532},
{0.7296548241355574,0.30084490382389806,-0.2170154597184606},
{0.7113018567894406,0.29038712421581686,-0.2052816446278756},
{0.6947036261050707,0.27901252288296846,-0.1959015062930042},
{0.6792401501784046,0.26690296118387236,-0.18922824652584685},
{0.6845952908429048,0.2574544369662519,-0.19629153127263874},
{0.6992847287560383,0.2690589952235091,-0.2029422462432854},
{0.6897896119589625,0.2482005494918403,-0.20584376155420822},
{0.6768008031959504,0.23628261856308483,-0.20112513564452567},
{0.6709556889539515,0.24513896612569175,-0.19171644056740741},
{0.6584282970261911,0.23222756116403295,-0.18863156091153122},
{0.6646889870172032,0.22366730192893278,-0.198092109020624},
{0.6470754889966362,0.21883369755704582,-0.1864529820753838},
{0.641353619642229,0.22789294828824877,-0.17758911958060666},
{0.6523968124663707,0.24117183343303142,-0.1808573635814363},
{0.6370768717441556,0.23727308662312013,-0.17012453745592493},
{0.6472363085450791,0.2500236720363362,-0.17542181314271457},
{0.6331247689158358,0.24779925211395043,-0.16517595462183357},
{0.642228357746843,0.258807876250109,-0.173678348879223},
{0.6283783377571235,0.260298087299464,-0.1638608414920447},
{0.6366522780765381,0.26754548788442634,-0.17697965858160164},
{0.6208070435956246,0.2776545746398093,-0.16942865473696234},
{0.6305569165932708,0.27341615289580395,-0.1895919692428856},
{0.7493604792723141,0.3216687808675839,-0.22842162376642386},
{0.7485864412587813,0.3317771161297498,-0.23092184169945681},
{0.7503810070610303,0.3102024973622588,-0.23074974975275872},
{0.7322632570918415,0.2896536668360031,-0.2238405211154564},
{0.7149593742766878,0.27983766243525887,-0.21225324720219074},
{0.7745527863865501,0.33033800661915225,-0.24418870295276715},
{0.7753929558031809,0.34097614459931885,-0.24703235328597925},
{0.7741003874699027,0.3182750374995115,-0.24613281590520364},
{0.7518374009156193,0.29836798218059285,-0.237320054949184},
{0.7349881714967641,0.27873822785875535,-0.23362345981465174},
{0.7185485058811859,0.26952942997736495,-0.22208052400119035},
{0.7036937394603076,0.2593181401444671,-0.2126838528155445},
{0.6945029774161259,0.23970341568696998,-0.21688620288513277},
{0.6821469259418464,0.2281965515479257,-0.2118519498243009},
{0.6705371072320702,0.21596750242732307,-0.20858445731668823},
{0.6534173402550869,0.21046056013298423,-0.19630881561663024},
{0.6369618932819512,0.20507385675336898,-0.18459529084290485},
{0.6321230284575452,0.21456822205722767,-0.17388576100712114},
{0.6294394461795588,0.22507184275154732,-0.16331300293683548},
{0.6275734885216926,0.23793815812018485,-0.15342786116012516},
{-0.7041296055261805,0.3095141295754664,-0.2041348659786997},
{-0.7249820393121131,0.32120285507303015,-0.21651947419522594},
{-0.7272635727189927,0.3116701636151032,-0.21436945210132535},
{-0.7077127251849424,0.30056985730646796,-0.20234631212218682},
{-0.6855789954639869,0.2969694533037145,-0.19407838374850825},
{-0.6901570921420863,0.2885985703593039,-0.19266783098015758},
{-0.6688800646885361,0.2838280914176468,-0.1866596427100649},
{-0.6740458290623469,0.27598475671158595,-0.18565038731960404},
{-0.6543311560069859,0.2708535610257582,-0.18036438403106975},
{-0.6596494735038522,0.26302751066368874,-0.18024940556886532},
{-0.642228357746843,0.258807876250109,-0.173678348879223},
{-0.6472363085450791,0.2500236720363362,-0.17542181314271457},
{-0.7296548241355574,0.30084490382389806,-0.2170154597184606},
{-0.7113018567894406,0.29038712421581686,-0.2052816446278756},
{-0.7149593742766878,0.27983766243525887,-0.21225324720219074},
{-0.7322632570918415,0.2896536668360031,-0.2238405211154564},
{-0.7503810070610303,0.3102024973622588,-0.23074974975275872},
{-0.7493604792723141,0.3216687808675839,-0.22842162376642386},
{-0.7741003874699027,0.3182750374995115,-0.24613281590520364},
{-0.7745527863865501,0.33033800661915225,-0.24418870295276715},
{-0.8014314442797839,0.3248799113839198,-0.26281070487057784},
{-0.803392090082995,0.3374471324521825,-0.2613550625092058},
{-0.8303849749452162,0.3283653369244689,-0.27943824379041154},
{-0.8338711519789822,0.3412316522931064,-0.2784861018844444},
{-0.8589725284139585,0.3270810350165779,-0.29466575084693286},
{-0.8639834851850627,0.3399240540954877,-0.2941502265000556},
{-0.8379480026813277,0.3525994901870016,-0.2819580005470871},
{-0.8696647739057507,0.3512768621250425,-0.2977851991907921},
{-0.8917218513185701,0.3317598317857583,-0.30691283580474404},
{-0.8989887907271749,0.3426993185459508,-0.310530524151489},
{-0.9150797634900547,0.3149722248106988,-0.3153408322336483},
{-0.9239037968443298,0.3249941383529072,-0.3187007584069546},
{-0.9436380087233333,0.29962222435980296,-0.3234081119183818},
{-0.9334094345464438,0.2909379687438941,-0.32042618683323765},
{-0.9574211458167379,0.2680444793805291,-0.3257640431537465},
{-0.9460630773346639,0.26103229617249474,-0.3231608706499815},
{-0.9644821760838787,0.23172030324254295,-0.3268822650606756},
{-0.9763475024874425,0.2354266677888965,-0.3322659624674228},
{-0.9685612812658753,0.27330192592681657,-0.33155504988411977},
{-0.6947036261050707,0.27901252288296846,-0.1959015062930042},
{-0.6992847287560383,0.2690589952235091,-0.2029422462432854},
{-0.7036937394603076,0.2593181401444671,-0.2126838528155445},
{-0.7185485058811859,0.26952942997736495,-0.22208052400119035},
{-0.7349881714967641,0.27873822785875535,-0.23362345981465174},
{-0.7518374009156193,0.29836798218059285,-0.237320054949184},
{-0.7743235809553584,0.3058445881967469,-0.25230708417625825},
{-0.8003650754048294,0.3119452101325333,-0.26841834725599767},
{-0.8280004869676046,0.31513304435914163,-0.28440335947527734},
{-0.8552684183472561,0.3138712872477613,-0.29901163612097237},
{-0.8852026476609023,0.319375975062449,-0.307148053181672},
{-0.9070876331270235,0.3035968719846335,-0.315535468976857},
{-0.9240954276146703,0.28103028217067316,-0.32072753561326356},
{-0.9356969798990594,0.252959756035242,-0.3236200330055821},
{-0.9523929047016422,0.22663119117686845,-0.3245376062235662},
{-0.9640493159908738,0.19211059875973555,-0.3278742361071449},
{-0.9761754105407444,0.19413436999317643,-0.3332060804819176},
{-0.9868511231817623,0.19487985126446247,-0.34166864559880483},
{-0.986707587977311,0.23724377838765626,-0.3408089373585314},
{-0.7004886208897079,0.3163482088910665,-0.21133642547742362},
{-0.7226997544120167,0.3285201445271755,-0.22408175043812056},
{-0.7249820393121131,0.32120285507303015,-0.21651947419522594},
{-0.7041296055261805,0.3095141295754664,-0.2041348659786997},
{-0.6809032046676746,0.3032759843809649,-0.2009703280418191},
{-0.6855789954639869,0.2969694533037145,-0.19407838374850825},
{-0.6636113457439933,0.2895619846635264,-0.1933561987669499},
{-0.6688800646885361,0.2838280914176468,-0.1866596427100649},
{-0.6487986629432683,0.2770398531882851,-0.18614336686997063},
{-0.6543311560069859,0.2708535610257582,-0.18036438403106975},
{-0.6366522780765381,0.26754548788442634,-0.17697965858160164},
{-0.642228357746843,0.258807876250109,-0.173678348879223},
{-0.6967273973385116,0.3202011146147395,-0.22463785541871698},
{-0.720309254488669,0.33269694382738496,-0.23767250526796743},
{-0.6760643398432685,0.3066704792422543,-0.21418007581063572},
{-0.6581066579293056,0.2923139528242618,-0.2068409930531967},
{-0.6429174770268523,0.2802051426183827,-0.19963943355447278},
{-0.6305569165932708,0.27341615289580395,-0.1895919692428856},
{-0.6366522780765381,0.26754548788442634,-0.17697965858160164},
{-0.7485864412587813,0.3317771161297498,-0.23092184169945681},
{-0.747869516729742,0.3395347806090703,-0.23883356228826677},
{-0.7753929558031809,0.34097614459931885,-0.24703235328597925},
{-0.7763308193380246,0.34913210048366106,-0.2552198718854364},
{-0.8058517273823086,0.34854142681508155,-0.26454289673581405},
{-0.8084150707455714,0.3570558449639434,-0.27286718710076924},
{-0.8421045116646778,0.36133860480775304,-0.29026275208839963},
{-0.8753813828076387,0.36001447375935985,-0.30589230801602785},
{-0.906227173393533,0.3511160425765997,-0.31824159605135405},
{-0.880495294149475,0.3650141581322087,-0.31879244057943135},
{-0.8458311665278909,0.3663179988637422,-0.30381067180487625},
{-0.8421045116646778,0.36133860480775304,-0.29026275208839963},
{-0.8106853317541955,0.3618834373900941,-0.28682241614087195},
{-0.8084150707455714,0.3570558449639434,-0.27286718710076924},
{-0.7770755491160937,0.3537477718226115,-0.26930736373173497},
{-0.7763308193380246,0.34913210048366106,-0.2552198718854364},
{-0.7470210808877239,0.34394905176585877,-0.2527429502421311},
{-0.747869516729742,0.3395347806090703,-0.23883356228826677},
{-0.7485864412587813,0.3317771161297498,-0.23092184169945681},
{-0.7753929558031809,0.34097614459931885,-0.24703235328597925},
{0.8338711519789822,0.3412316522931064,-0.2784861018844444},
{0.803392090082995,0.3374471324521825,-0.2613550625092058},
{0.8014314442797839,0.3248799113839198,-0.26281070487057784},
{0.8303849749452162,0.3283653369244689,-0.27943824379041154},
{0.8639834851850627,0.3399240540954877,-0.2941502265000556},
{0.8917218513185701,0.3317598317857583,-0.30691283580474404},
{0.8589725284139585,0.3270810350165779,-0.29466575084693286},
{0.8280004869676046,0.31513304435914163,-0.28440335947527734},
{0.8003650754048294,0.3119452101325333,-0.26841834725599767},
{0.7743235809553584,0.3058445881967469,-0.25230708417625825},
{0.8852026476609023,0.319375975062449,-0.307148053181672},
{0.8552684183472561,0.3138712872477613,-0.29901163612097237},
{0.8266703439734753,0.3023043036513552,-0.29228802630827455},
{0.8001298580279015,0.2993945219150452,-0.2770124236858638},
{0.7751464660279976,0.2937673407059828,-0.2615008521933081},
{0.9326241241346556,0.33267740500374243,-0.32579861184172954},
{0.9239037968443298,0.3249941383529072,-0.3187007584069546},
{0.9436380087233333,0.29962222435980296,-0.3234081119183818},
{0.9536944909535247,0.3062286012306453,-0.32981759756636436},
{0.9685612812658753,0.27330192592681657,-0.33155504988411977},
{0.9574211458167379,0.2680444793805291,-0.3257640431537465},
{0.9763475024874425,0.2354266677888965,-0.3322659624674228},
{0.9644821760838787,0.23172030324254295,-0.3268822650606756},
{0.9403066392922736,0.33703456267603726,-0.3368185083761434},
{0.9624922220452038,0.3099011485822329,-0.33980268794093865},
{0.9782735796026706,0.27611100757204565,-0.34065939020834396},
{0.986707587977311,0.23724377838765626,-0.3408089373585314},
{0.9868511231817623,0.19487985126446247,-0.34166864559880483},
{0.9761754105407444,0.19413436999317643,-0.3332060804819176},
{0.9787582927276499,0.1511339281151648,-0.3418640338352306},
{0.9681539719422493,0.15150065680507166,-0.3330918535129302},
{0.9624839556198166,0.10812146234568086,-0.34001761500100697},
{0.9523929047016422,0.10960040099678058,-0.3306374766661356},
{0.938082219369888,0.06795865885514513,-0.3347541565089834},
{0.9290004238421744,0.0705099783269356,-0.32456015102007685},
{0.9412069281662663,0.11106280679710583,-0.324697674278792},
{0.9190499021555832,0.0736376930961821,-0.318138641480622},
{0.8980854958803142,0.03630426156773509,-0.31357482317364604},
{0.8899039892265932,0.04095450159466859,-0.30667160648207986},
{0.8612886305088211,0.0070118074614258265,-0.29781375593303894},
{0.8552526369896986,0.013013983785782338,-0.2905092418635829},
{0.8818712782298427,0.046142810764990036,-0.3036678880936421},
{0.8494142861866528,0.01981499739983346,-0.2875280682716558},
{0.8165792930553009,-0.010182357344042606,-0.2698634687123314},
{0.8131847981940116,-0.002018135034313186,-0.26708820426186836},
{0.7745415139882947,-0.019379131333960593,-0.24260605823771836},
{0.774346877245086,-0.010033561687072225,-0.24474480793336356},
{0.8105019674092422,0.006215224651382265,-0.26852130182672973},
{0.9150797634900547,0.3149722248106988,-0.3153408322336483},
{0.9334094345464438,0.2909379687438941,-0.32042618683323765},
{0.9070876331270235,0.3035968719846335,-0.315535468976857},
{0.8802089752337896,0.306624638156016,-0.3109949469596087},
{0.8528433497359253,0.3010688488025707,-0.3061786269317133},
{0.8263487048765898,0.29065089833499164,-0.3019988216586357},
{0.8006634182119873,0.28797933994847763,-0.2874303741534429},
{0.7764908873932503,0.28276172254269233,-0.2725004584108624},
{0.7557128514358029,0.2763289406049821,-0.2582589104550742},
{0.7536432391161237,0.28684984564329324,-0.24690084197300033},
{0.9240954276146703,0.28103028217067316,-0.32072753561326356},
{0.9460630773346639,0.26103229617249474,-0.3231608706499815},
{0.9356969798990594,0.252959756035242,-0.3236200330055821},
{0.9167826471198272,0.27075586690754533,-0.3241648655879232},
{0.9008607603307772,0.29185479046866125,-0.3191020557848445},
{0.8767258041728915,0.2942603202563494,-0.3175366954137872},
{0.8516680143445025,0.289447006201322,-0.31515746788869486},
{0.8269912315771438,0.28094461194393255,-0.31244232289559354},
{0.8019018790336399,0.27845040595663584,-0.29850738417235045},
{0.7782801927429802,0.27354841570199984,-0.2840937442698642},
{0.7579605676479163,0.26748837439993267,-0.2701610600262722},
{0.9523929047016422,0.22663119117686845,-0.3245376062235662},
{0.941361735768973,0.22066884399301415,-0.32511024405493716},
{0.9275327575893301,0.2445197357148654,-0.3270137763736544},
{0.9114688385822629,0.26074522576359227,-0.32999570145879864},
{0.8963946361420142,0.280451632393566,-0.3252139501188862},
{0.8747388561070848,0.28303676906012243,-0.3258557253262232},
{0.8517138554307409,0.27978054895076515,-0.32493890360145605},
{0.8285505800024648,0.2739549735324089,-0.3225251073883807},
{0.8037821150626294,0.27155846166332503,-0.30908014224263614},
{0.7804354752894,0.26684584769937864,-0.2950670482248227},
{0.7602999660325066,0.26100899988276705,-0.28137559330389483},
{0.7428412756146463,0.2540892503404264,-0.2684874846319637},
{0.7403786323424645,0.2603123656705874,-0.257169245290392},
{-0.9326241241346556,0.33267740500374243,-0.32579861184172954},
{-0.9536944909535247,0.3062286012306453,-0.32981759756636436},
{-0.9403066392922736,0.33703456267603726,-0.3368185083761434},
{-0.9624922220452038,0.3099011485822329,-0.33980268794093865},
{-0.9126599553312431,0.3559323626044951,-0.33028803232022025},
{-0.8843714961628757,0.36515168139092374,-0.33680648448467104},
{-0.8486177033766094,0.3664066750633509,-0.32301207499301116},
{-0.8122679764692444,0.3619180060780771,-0.3069008119132717},
{-0.9782735796026706,0.27611100757204565,-0.34065939020834396},
{0.9640493159908738,0.19211059875973555,-0.3278742361071449},
{0.9562488163981832,0.15122260431477347,-0.32754433058487215},
{0.9517503780010881,0.18911214082381692,-0.32554611012081003},
{0.9442572391341596,0.15038844684387875,-0.3250764268601712},
{0.9405591410131933,0.18544259944509744,-0.3260969546488873},
{0.9333951561753203,0.1490868605919963,-0.3255408496682909},
{0.9300322240291459,0.11237566544724369,-0.3220148434940226},
{0.9199757417989545,0.11340746563421517,-0.32240411698044014},
{0.9091970745872048,0.07698860135088419,-0.31524915006117155},
{0.900407609920913,0.08021100426547545,-0.3156504474390614},
{0.9121444309843659,0.11402669604504151,-0.3256836333795251},
{0.9248784835468075,0.14740727325195163,-0.328791809325129},
{-0.9442572391341596,0.15038844684387875,-0.3250764268601712},
{-0.9562488163981832,0.15122260431477347,-0.32754433058487215},
{-0.9412069281662663,0.11106280679710583,-0.324697674278792},
{-0.9300322240291459,0.11237566544724369,-0.3220148434940226},
{-0.9190499021555832,0.0736376930961821,-0.318138641480622},
{-0.9290004238421744,0.0705099783269356,-0.32456015102007685},
{-0.9523929047016422,0.10960040099678058,-0.3306374766661356},
{-0.9681539719422493,0.15150065680507166,-0.3330918535129302},
{-0.9517503780010881,0.18911214082381692,-0.32554611012081003},
{-0.9405591410131933,0.18544259944509744,-0.3260969546488873},
{-0.9333951561753203,0.1490868605919963,-0.3255408496682909},
{-0.9199757417989545,0.11340746563421517,-0.32240411698044014},
{-0.9091970745872048,0.07698860135088419,-0.31524915006117155},
{-0.900407609920913,0.08021100426547545,-0.3156504474390614},
{-0.8818712782298427,0.046142810764990036,-0.3036678880936421},
{-0.8747967210847954,0.05130331468628161,-0.304240525925013},
{-0.8494142861866528,0.01981499739983346,-0.2875280682716558},
{-0.8444063353884167,0.02664907671543355,-0.28844263551677185},
{-0.8105019674092422,0.006215224651382265,-0.26852130182672973},
{-0.8131847981940116,-0.002018135034313186,-0.26708820426186836},
{-0.774346877245086,-0.010033561687072225,-0.24474480793336356},
{-0.7745415139882947,-0.019379131333960593,-0.24260605823771836},
{-0.7372058279801966,-0.022131099494695973,-0.21737918243549934},
{-0.7348431333058788,-0.03229053629561941,-0.21434089535907846},
{-0.7003969387172312,-0.03032688451954036,-0.18987002173318385},
{-0.69542055063411,-0.041068728563655996,-0.18583375166455748},
{-0.941361735768973,0.22066884399301415,-0.32511024405493716},
{-0.932669965220894,0.2143390166260359,-0.32848219411971585},
{-0.9317523920029098,0.18140632937647105,-0.329399015844483},
{-0.9787582927276499,0.1511339281151648,-0.3418640338352306},
{-0.9624839556198166,0.10812146234568086,-0.34001761500100697},
{-0.938082219369888,0.06795865885514513,-0.3347541565089834},
{0.8668902609485046,0.002577245987777695,-0.30986845862729245},
{0.9056079429827067,0.03276097104947529,-0.324697674278792},
{0.8714255225132338,0.0004760709529835852,-0.327100198093612},
{0.9116627238322548,0.030892007418741013,-0.34036179889440316},
{0.9453296199548503,0.06633618499959422,-0.3489618872700055},
{0.9703731314121159,0.10675675066356848,-0.35302070213514253},
{0.9502812087618098,0.0696840872814282,-0.365074653336179},
{0.9756441048363097,0.10888948841347755,-0.3677943072885824},
{0.986845111236026,0.15003299055222727,-0.3540074127290927},
{0.991986076333675,0.15074766060161535,-0.367780780410676},
{0.977879797156951,0.11790289805844215,-0.38248299370849875},
{0.9937528368868942,0.1558270032554686,-0.38144443008257406},
{0.999389036014561,0.19320853034980506,-0.3665257867382489},
{1.0,0.19396378103291242,-0.37924556092956707},
{0.9919770584150708,0.1688143090320467,-0.3933834028214061},
{0.9970473831503196,0.20187099266242017,-0.3902173618980915},
{0.998377526144449,0.23067572767088207,-0.3781536412852338},
{0.9957848745457224,0.22730753507218845,-0.38678378938951696},
{0.9909490156941844,0.22249346952394408,-0.3981117981429099},
{0.9904883503521498,0.24909106895401165,-0.39134084425753973},
{0.9906431579548564,0.26432458795626906,-0.3804381806649813},
{0.9983955619816576,0.23427913764650363,-0.36574273080611175},
{0.989550486817306,0.27196351650729994,-0.3671450171490752},
{0.9760484081870677,0.2933314746401099,-0.38357115588674695},
{0.9733610684429963,0.30466474384602205,-0.36880732014512835},
{0.9853488882409348,0.2757788475701219,-0.35320406648009595},
{0.9689452942997737,0.3097839156403774,-0.35350842123299},
{0.9503368192598695,0.33078514508328044,-0.36880356267904324},
{0.9460172362484257,0.3370804037622756,-0.35194306086193267},
{0.8747967210847954,0.05130331468628161,-0.304240525925013},
{0.8444063353884167,0.02664907671543355,-0.28844263551677185},
{0.7753674050338021,-0.02863226731515524,-0.24494545662230852},
{0.7348431333058788,-0.03229053629561941,-0.21434089535907846},
{0.7372058279801966,-0.022131099494695973,-0.21737918243549934},
{0.8089651637804317,0.013576852205331984,-0.27360139597379995},
{0.8408600388972889,0.03274969865121997,-0.29282534395844545},
{0.8694874215065336,0.05586713299325761,-0.30807088685217526},
{0.8936479284337979,0.08295170002795554,-0.3191020557848445},
{0.9065255162006908,0.11425064102371407,-0.33115375250622986},
{0.918703463782536,0.14549171704176198,-0.33417550673187624},
{0.9253308824634549,0.17728363758788715,-0.3348232938849494},
{0.9317523920029098,0.18140632937647105,-0.329399015844483},
{0.8202488344340203,-0.017338075756528237,-0.27740846061123453},
{0.7766058658554548,-0.03671683134388031,-0.25249120001442865},
{0.8237575562642971,-0.022543669270841192,-0.2902860483781273},
{0.7780389634203161,-0.042553679160491895,-0.2659699823549393},
{0.7315636169067938,-0.05740318512885102,-0.23694205386102185},
{0.7319994829726667,-0.05109590255838352,-0.22319273396238326},
{0.7331004205356042,-0.04233574612755548,-0.2159686296671486},
{0.6877199996392833,-0.06092317935738313,-0.1933561987669499},
{0.6910987131430152,-0.051688079213397034,-0.18661380162382654},
{0.6506819049451259,-0.05708755797770171,-0.1605610347761001},
{0.6450577297089317,-0.06664504871179035,-0.16682172476711224},
{0.6131711210174617,-0.05893097083905721,-0.14149114290094417},
{0.6227203453261632,-0.04748422615737473,-0.14227119286021322},
{0.6576024059806836,-0.04602783230278566,-0.16062942065884914},
{-0.8552526369896986,0.013013983785782338,-0.2905092418635829},
{-0.8165792930553009,-0.010182357344042606,-0.2698634687123314},
{-0.7753674050338021,-0.02863226731515524,-0.24494545662230852},
{-0.7766058658554548,-0.03671683134388031,-0.25249120001442865},
{-0.8202488344340203,-0.017338075756528237,-0.27740846061123453},
{-0.8612886305088211,0.0070118074614258265,-0.29781375593303894},
{-0.8899039892265932,0.04095450159466859,-0.30667160648207986},
{-0.8668902609485046,0.002577245987777695,-0.30986845862729245},
{-0.8980854958803142,0.03630426156773509,-0.31357482317364604},
{-0.9056079429827067,0.03276097104947529,-0.324697674278792},
{-0.8237575562642971,-0.022543669270841192,-0.2902860483781273},
{-0.9116627238322548,0.030892007418741013,-0.34036179889440316},
{-0.7780389634203161,-0.042553679160491895,-0.2659699823549393},
{0.6855729835182508,-0.06751076889779994,-0.20720847323632058},
{0.69542055063411,-0.041068728563655996,-0.18583375166455748},
{0.7003969387172312,-0.03032688451954036,-0.18987002173318385},
{0.7057400554902591,-0.02072655867208143,-0.1975758331805297},
{0.7401637052823962,-0.013026007677254706,-0.22415614826660576},
{0.6652390800520634,-0.034870412509656716,-0.16566367371968102},
{0.6730140288753753,-0.025020590914146414,-0.17429833078326634},
{0.6330518740737846,-0.03601117921309643,-0.14820498330182072},
{0.6413077785559907,-0.073295763682437,-0.18077695380721492},
{0.6000102203077515,-0.07517675120464365,-0.1616559603933015},
{0.605302235542022,-0.06870940057895039,-0.14743169678150486},
{0.5798859834491135,-0.057615106216051294,-0.13308644276176765},
{0.5921037601714607,-0.04575278578535551,-0.13430160729369256},
{-0.6576024059806836,-0.04602783230278566,-0.16062942065884914},
{-0.6910987131430152,-0.051688079213397034,-0.18661380162382654},
{-0.6506819049451259,-0.05708755797770171,-0.1605610347761001},
{-0.6877199996392833,-0.06092317935738313,-0.1933561987669499},
{-0.7331004205356042,-0.04233574612755548,-0.2159686296671486},
{-0.6652390800520634,-0.034870412509656716,-0.16566367371968102},
{-0.6330518740737846,-0.03601117921309643,-0.14820498330182072},
{-0.6227203453261632,-0.04748422615737473,-0.14227119286021322},
{-0.6131711210174617,-0.05893097083905721,-0.14149114290094417},
{-0.6450577297089317,-0.06664504871179035,-0.16682172476711224},
{-0.6855729835182508,-0.06751076889779994,-0.20720847323632058},
{-0.7319994829726667,-0.05109590255838352,-0.22319273396238326},
{-0.7315636169067938,-0.05740318512885102,-0.23694205386102185},
{-0.605302235542022,-0.06870940057895039,-0.14743169678150486},
{0.7434033925409789,-0.0051601281746830934,-0.23359340008597082},
{0.7110395856566999,-0.01243157654259014,-0.20784573948435542},
{0.6804214975155634,-0.016586582539506015,-0.18539262514616545},
{0.6869579855172228,-0.009678105395420713,-0.1978050386117215},
{0.715882959440408,-0.0056072666388113255,-0.21957504561563826},
{0.7466085111115788,0.0012846776544994717,-0.2446132966203847},
{0.776275960333182,0.005515584466334606,-0.2592275852118159},
{0.7750006763438952,-0.0016739511409169972,-0.25063350878194973},
{0.7198591100516727,-0.00041820597527287873,-0.23165830505213858},
{0.7494634338430461,0.006123542478905588,-0.25613744510342046},
{0.7779472812478394,0.01135243228294619,-0.2694847161309522},
{0.8084203311980906,0.01988338328258249,-0.28134177610912886},
{0.6610194456384836,-0.0112832949069802,-0.1827375996104259},
{0.6527860859527882,-0.017913719560767254,-0.1696398243309456},
{0.6673838416934449,-0.006261065737620646,-0.19582184801199984},
{0.6921177379452973,-0.0044033745051417295,-0.2103963074629288},
{0.6953972543443823,-0.0008713563851372944,-0.2220234105166967},
{0.7225562192075654,0.0029702769402803145,-0.24299082276483375},
{0.7516540365706659,0.009173853446798776,-0.26708820426186836},
{0.7797876881363269,0.015652476470747353,-0.2803610774609149},
{0.8087126620595123,0.024952205031397386,-0.2907557316387662},
{0.8386769511018394,0.03794251678084351,-0.2997631293379946},
{0.6432691758524187,-0.026156097165067022,-0.15772865684114334},
{0.6293710602968098,-0.016701561001710427,-0.16399535877789168},
{0.6392554505803031,-0.010779042958358265,-0.1778070526135431},
{0.6468004424792062,-0.0064211337928463934,-0.19140682536199427},
{0.6513642607861821,-0.003439960200919236,-0.2034930907713627},
{0.6712938609016115,-0.0028432745866035776,-0.20768942889521477},
{0.673776794490653,0.00022356923206411598,-0.21848613194417307},
{0.6974954234063083,0.002351046529454009,-0.23260744098523767},
{0.7242696237423761,0.006145335782199233,-0.2531915916926934},
{0.7530127363070421,0.012137742694734426,-0.27676067345816135},
{0.7815709815403207,0.01823235268478466,-0.2908128451232599},
{0.80968734876199,0.028598450120389186,-0.30085805495519596},
{0.8377586263906383,0.04205468766438914,-0.30833992142386923},
{0.86588701750378,0.05969073048146666,-0.3143203044449321},
{0.6177897983292803,-0.024378064213592416,-0.15127257861370544},
{0.6103500154807603,-0.013286775823561449,-0.16528943009760394},
{0.6218486131944173,-0.008439644573768102,-0.1798939492772138},
{0.6305524076339687,-0.005033877314223359,-0.19396415677952095},
{0.6357925698362646,-0.0027057513278885195,-0.20622176264237038},
{0.6390330085880644,-0.0005850374694518122,-0.21680804759056246},
{0.6541966387211389,-0.0007684018144052512,-0.21430632667109545},
{0.6565473095039844,0.0026606617348671827,-0.22408776238385675},
{0.6758576792085874,0.0041967138704606,-0.22835323788367484},
{0.6991126368093401,0.006696931803493513,-0.2420672376011134},
{0.7252916545175264,0.01069337273161773,-0.2618818592543384},
{0.7533734530512127,0.01671884534570189,-0.28444920056151574},
{0.7826403563881432,0.0208610759579284,-0.2998345211936117},
{0.8111895837028175,0.03063950569782154,-0.3106620354644679},
{0.8380051161658214,0.04491336786194166,-0.31764265595738733},
{0.8639376440988245,0.06263207493289162,-0.3221523667527377},
{0.8888894733836132,0.08512727289123487,-0.3248412094832432},
{-0.6869579855172228,-0.009678105395420713,-0.1978050386117215},
{-0.715882959440408,-0.0056072666388113255,-0.21957504561563826},
{-0.7110395856566999,-0.01243157654259014,-0.20784573948435542},
{-0.6804214975155634,-0.016586582539506015,-0.18539262514616545},
{-0.7057400554902591,-0.02072655867208143,-0.1975758331805297},
{-0.7401637052823962,-0.013026007677254706,-0.22415614826660576},
{-0.7434033925409789,-0.0051601281746830934,-0.23359340008597082},
{-0.7466085111115788,0.0012846776544994717,-0.2446132966203847},
{-0.7198591100516727,-0.00041820597527287873,-0.23165830505213858},
{-0.6921177379452973,-0.0044033745051417295,-0.2103963074629288},
{-0.6673838416934449,-0.006261065737620646,-0.19582184801199984},
{-0.6610194456384836,-0.0112832949069802,-0.1827375996104259},
{-0.6527860859527882,-0.017913719560767254,-0.1696398243309456},
{-0.6730140288753753,-0.025020590914146414,-0.17429833078326634},
{-0.7750006763438952,-0.0016739511409169972,-0.25063350878194973},
{-0.776275960333182,0.005515584466334606,-0.2592275852118159},
{-0.7779472812478394,0.01135243228294619,-0.2694847161309522},
{-0.7494634338430461,0.006123542478905588,-0.25613744510342046},
{-0.7225562192075654,0.0029702769402803145,-0.24299082276483375},
{-0.6953972543443823,-0.0008713563851372944,-0.2220234105166967},
{-0.6712938609016115,-0.0028432745866035776,-0.20768942889521477},
{-0.6513642607861821,-0.003439960200919236,-0.2034930907713627},
{-0.6468004424792062,-0.0064211337928463934,-0.19140682536199427},
{-0.6392554505803031,-0.010779042958358265,-0.1778070526135431},
{-0.6293710602968098,-0.016701561001710427,-0.16399535877789168},
{-0.6432691758524187,-0.026156097165067022,-0.15772865684114334},
{0.8635821878071728,0.06454687964986425,-0.3307291588386123},
{0.8861029365348948,0.08665505860144102,-0.33210514291898},
{0.885259761145396,0.08745239290470165,-0.3401318419699944},
{-0.8087126620595123,0.024952205031397386,-0.2907557316387662},
{-0.8377586263906383,0.04205468766438914,-0.30833992142386923},
{-0.8386769511018394,0.03794251678084351,-0.2997631293379946},
{-0.8084203311980906,0.01988338328258249,-0.28134177610912886},
{-0.8408600388972889,0.03274969865121997,-0.29282534395844545},
{-0.8694874215065336,0.05586713299325761,-0.30807088685217526},
{-0.86588701750378,0.05969073048146666,-0.3143203044449321},
{-0.8639376440988245,0.06263207493289162,-0.3221523667527377},
{-0.8380051161658214,0.04491336786194166,-0.31764265595738733},
{-0.80968734876199,0.028598450120389186,-0.30085805495519596},
{-0.7797876881363269,0.015652476470747353,-0.2803610774609149},
{-0.8089651637804317,0.013576852205331984,-0.27360139597379995},
{-0.8936479284337979,0.08295170002795554,-0.3191020557848445},
{-0.8888894733836132,0.08512727289123487,-0.3248412094832432},
{-0.8861029365348948,0.08665505860144102,-0.33210514291898},
{-0.8635821878071728,0.06454687964986425,-0.3307291588386123},
{-0.885259761145396,0.08745239290470165,-0.3401318419699944},
{-0.8647627836511147,0.06529236092115029,-0.33921502024522726},
{-0.8393179748159594,0.04634345945393494,-0.3267560142002158},
{0.926316841564188,0.2080580363181642,-0.33401468718343347},
{0.932669965220894,0.2143390166260359,-0.32848219411971585},
{0.9212946123948285,0.17335633403572898,-0.34173778297477087},
{0.9148678424028546,0.14348523015231268,-0.34103814278972316},
{0.9223038677852894,0.2022414788184122,-0.3410727114777062},
{0.9178084353610625,0.22867299824751783,-0.3399026365388026},
{0.9215696589122587,0.2362465468886678,-0.33266725984531265},
{0.9196435817970307,0.1699047256899459,-0.3495119803048658},
{0.9133686134348952,0.14152984480162076,-0.34872666989307755},
{0.9206295408977638,0.19730491987579318,-0.3490190007544992},
{0.9162490869357414,0.2223311469890673,-0.34804431405202135},
{0.9068351314061041,0.24403802856275417,-0.345868741188742},
{0.9081540020019779,0.2516296130411127,-0.33747756792747186},
{0.9031084765428907,0.11409583342100754,-0.3381140826822897},
{0.9018812881194934,0.11357955758091329,-0.34586573521587394},
{0.9142027709057898,0.13976984768735476,-0.35658728894313},
{0.9203770391768444,0.16720987101370424,-0.3575161345593694},
{0.9212946123948285,0.19366393523932052,-0.35721779175221163},
{0.9168916136362955,0.217756056283836,-0.35641519699643187},
{0.907511475301424,0.23860322961724945,-0.35442599445097406},
{0.8863321419660866,0.08743510856071014,-0.3481592925142258},
{0.9028326785322436,0.11271984934063983,-0.3537090699219349},
{0.9034293641465593,0.1124102341352267,-0.35996449946042786},
{0.9147558699135182,0.13865763772616183,-0.3628870565814273},
{0.9208933150169386,0.1652725215002209,-0.3639834851850627},
{0.921782331492676,0.19090670662606596,-0.363891803012586},
{0.9173612968969342,0.2142127657655762,-0.36324927631203197},
{0.9080164787432629,0.23436029891394203,-0.3614306627268382},
{-0.9148678424028546,0.14348523015231268,-0.34103814278972316},
{-0.918703463782536,0.14549171704176198,-0.33417550673187624},
{-0.9065255162006908,0.11425064102371407,-0.33115375250622986},
{-0.9031084765428907,0.11409583342100754,-0.3381140826822897},
{-0.9121444309843659,0.11402669604504151,-0.3256836333795251},
{-0.9248784835468075,0.14740727325195163,-0.328791809325129},
{-0.9253308824634549,0.17728363758788715,-0.3348232938849494},
{-0.9212946123948285,0.17335633403572898,-0.34173778297477087},
{-0.9196435817970307,0.1699047256899459,-0.3495119803048658},
{-0.9133686134348952,0.14152984480162076,-0.34872666989307755},
{-0.9018812881194934,0.11357955758091329,-0.34586573521587394},
{-0.9223038677852894,0.2022414788184122,-0.3410727114777062},
{-0.926316841564188,0.2080580363181642,-0.33401468718343347},
{-0.9206295408977638,0.19730491987579318,-0.3490190007544992},
{-0.9212946123948285,0.19366393523932052,-0.35721779175221163},
{-0.9203770391768444,0.16720987101370424,-0.3575161345593694},
{-0.9142027709057898,0.13976984768735476,-0.35658728894313},
{-0.9028326785322436,0.11271984934063983,-0.3537090699219349},
{-0.8863321419660866,0.08743510856071014,-0.3481592925142258},
{-0.8654511514379072,0.06640457088234321,-0.3460889287013295},
{-0.8400762314719348,0.048044840097273285,-0.33428146727547636},
{-0.9215696589122587,0.2362465468886678,-0.33266725984531265},
{-0.9178084353610625,0.22867299824751783,-0.3399026365388026},
{-0.9162490869357414,0.2223311469890673,-0.34804431405202135},
{-0.9168916136362955,0.217756056283836,-0.35641519699643187},
{-0.9173612968969342,0.2142127657655762,-0.36324927631203197},
{-0.921782331492676,0.19090670662606596,-0.363891803012586},
{-0.9208933150169386,0.1652725215002209,-0.3639834851850627},
{-0.9147558699135182,0.13865763772616183,-0.3628870565814273},
{-0.9034293641465593,0.1124102341352267,-0.35996449946042786},
{-0.8869746686666407,0.0878762350791022,-0.3545777960808126},
{0.8936824971217809,0.27009079541048064,-0.33304601242669185},
{0.8742346041584629,0.2737084837572256,-0.33503521497214966},
{0.8529523162523935,0.27284276357121595,-0.33451367867953624},
{0.8303752055333949,0.2686584493388363,-0.33124693766514063},
{0.8060508730848196,0.26628222778661204,-0.3183107334273201},
{0.783037896299948,0.261616206402121,-0.3047169726246051},
{0.7630654610711484,0.2558627743325989,-0.2913403933616095},
{0.7456458483005732,0.24906401519819882,-0.2786709692158319},
{0.8927190828175585,0.261479434636623,-0.34177160016953684},
{0.8751980184626853,0.26702921204433205,-0.3441568396403654},
{0.8542802047668717,0.26754323340477526,-0.3426493442470188},
{0.8318113090711243,0.2640284996287623,-0.3376098307336678},
{0.8084533968996396,0.26159817056491247,-0.3253627457758566},
{0.7861656110691945,0.2568201766910852,-0.3123363623519934},
{0.7665914672454167,0.2510178975624566,-0.2994933432730836},
{-0.9081540020019779,0.2516296130411127,-0.33747756792747186},
{-0.9114688385822629,0.26074522576359227,-0.32999570145879864},
{-0.9068351314061041,0.24403802856275417,-0.345868741188742},
{-0.907511475301424,0.23860322961724945,-0.35442599445097406},
{-0.9080164787432629,0.23436029891394203,-0.3614306627268382},
{-0.8936824971217809,0.27009079541048064,-0.33304601242669185},
{-0.8963946361420142,0.280451632393566,-0.3252139501188862},
{-0.8927190828175585,0.261479434636623,-0.34177160016953684},
{-0.8747388561070848,0.28303676906012243,-0.3258557253262232},
{-0.8767258041728915,0.2942603202563494,-0.3175366954137872},
{-0.8742346041584629,0.2737084837572256,-0.33503521497214966},
{-0.8751980184626853,0.26702921204433205,-0.3441568396403654},
{-0.8934991327768276,0.25532169921634285,-0.350567076781565},
{-0.8760915438977248,0.2618566842315681,-0.35175669054411113},
{-0.8941318900655604,0.25051890606635385,-0.3578084654207911},
{-0.8753776253415537,0.25704938212227696,-0.3563693559101936},
{-0.8927265977497287,0.24597237210336942,-0.3618732922316643},
{-0.9061835867869457,0.23034882812147733,-0.36516408102900466},
{-0.9167826471198272,0.27075586690754533,-0.3241648655879232},
{-0.9008607603307772,0.29185479046866125,-0.3191020557848445},
{-0.8802089752337896,0.306624638156016,-0.3109949469596087},
{-0.8528433497359253,0.3010688488025707,-0.3061786269317133},
{-0.8516680143445025,0.289447006201322,-0.31515746788869486},
{-0.8517138554307409,0.27978054895076515,-0.32493890360145605},
{-0.8529523162523935,0.27284276357121595,-0.33451367867953624},
{-0.8542802047668717,0.26754323340477526,-0.3426493442470188},
{-0.8545958319180211,0.26279079030032676,-0.34811345142798744},
{-0.8266703439734753,0.3023043036513552,-0.29228802630827455},
{-0.8263487048765898,0.29065089833499164,-0.3019988216586357},
{-0.8269912315771438,0.28094461194393255,-0.31244232289559354},
{-0.8285505800024648,0.2739549735324089,-0.3225251073883807},
{-0.8303752055333949,0.2686584493388363,-0.33124693766514063},
{-0.8318113090711243,0.2640284996287623,-0.3376098307336678},
{-0.832206594503278,0.2590408391473858,-0.3406135491221056},
{-0.8527952541700359,0.25749276312032005,-0.3496727998533085},
{-0.8715187076721446,0.25146503602658477,-0.3565301754586363},
{-0.8753776253415537,0.25704938212227696,-0.3563693559101936},
{-0.887394753374956,0.240582662750886,-0.36113983485185064},
{-0.8927265977497287,0.24597237210336942,-0.3618732922316643},
{-0.8998447415013632,0.22560465144241604,-0.3639090873565775},
{-0.9061835867869457,0.23034882812147733,-0.36516408102900466},
{-0.9152864241247358,0.21096781805447423,-0.36678129443203644},
{-0.9082915252606931,0.2072870042774994,-0.365244490803226},
{-0.9195744444210646,0.18861916127345035,-0.3672630015841477},
{-0.9121557033826213,0.1863887294053284,-0.3655541060086392},
{-0.9185884853203314,0.16409117416306204,-0.3671480231219433},
{-0.910860129076475,0.16366658049544444,-0.365244490803226},
{-0.91241346555606,0.13864636532790653,-0.3658922779562992},
{-0.9045618644246117,0.14018842940923615,-0.36387151269572643},
{-0.9011358068482075,0.11354498889293027,-0.3629509335048742},
{-0.8934187230026062,0.117019893528441,-0.36099028770166325},
{-0.8848411794235145,0.09004955346273047,-0.3577799086785443},
{-0.8775885183860331,0.0952265902347965,-0.3561574348229933},
{-0.8636160050019389,0.06942031316225342,-0.3498328679085343},
{-0.857229064150467,0.07587639138969127,-0.34892731858202247},
{-0.8628712752238699,0.10468112639815315,-0.3481014275365151},
{-0.8442605457043145,0.08730885770025038,-0.34185200994375825},
{-0.8334443038317136,0.059054967219865855,-0.33897153644291206},
{-0.8228114263040662,0.07175971154684355,-0.3333383432881135},
{-0.8073366779791447,0.04484723645884372,-0.32595943139017225},
{-0.7994249573903346,0.05818323508812012,-0.3222440489252144},
{-0.7800116331149995,0.033340372319799444,-0.30956184939474735},
{-0.7750006763438952,0.04672747248783332,-0.3082542511971287},
{-0.7888634717183043,0.07483331880446446,-0.3151800126852055},
{-0.7680689029100823,0.06334298751619465,-0.3039542070093275},
{-0.7470781943722177,0.05350443831893971,-0.2901823423141783},
{-0.750438120545524,0.0375427223893877,-0.29105407444592407},
{-0.9275327575893301,0.2445197357148654,-0.3270137763736544},
{-0.8006634182119873,0.28797933994847763,-0.2874303741534429},
{-0.8001298580279015,0.2993945219150452,-0.2770124236858638},
{-0.8019018790336399,0.27845040595663584,-0.29850738417235045},
{-0.8037821150626294,0.27155846166332503,-0.30908014224263614},
{-0.8060508730848196,0.26628222778661204,-0.3183107334273201},
{-0.8084533968996396,0.26159817056491247,-0.3253627457758566},
{-0.8107349303065191,0.25648350772985923,-0.329399015844483},
{-0.7764908873932503,0.28276172254269233,-0.2725004584108624},
{-0.7751464660279976,0.2937673407059828,-0.2615008521933081},
{-0.7782801927429802,0.27354841570199984,-0.2840937442698642},
{-0.7804354752894,0.26684584769937864,-0.2950670482248227},
{-0.783037896299948,0.261616206402121,-0.3047169726246051},
{-0.7861656110691945,0.2568201766910852,-0.3123363623519934},
{-0.7898975263849269,0.2514191949403464,-0.31722106826263785},
{-0.7536432391161237,0.28684984564329324,-0.24690084197300033},
{-0.7557128514358029,0.2763289406049821,-0.2582589104550742},
{-0.7579605676479163,0.26748837439993267,-0.2701610600262722},
{-0.7602999660325066,0.26100899988276705,-0.28137559330389483},
{-0.7630654610711484,0.2558627743325989,-0.2913403933616095},
{-0.7665914672454167,0.2510178975624566,-0.2994933432730836},
{-0.7712123990368863,0.24544482386501976,-0.3052730776052015},
{0.72193172834422,0.26006888186827226,-0.2335821276877155},
{0.7377273642728102,0.26874336807235977,-0.24514084485873427},
{0.7077239975831978,0.2503678559297324,-0.22401862500789066},
{0.6984129966242926,0.2325251524779737,-0.22842162376642386},
{0.686525125424218,0.22141733123716828,-0.22304995025114902},
{0.6753301309702379,0.20960310637236182,-0.21945480670091472},
{0.6595517793856392,0.20313575574666867,-0.20674931088071996},
{0.6429475367555333,0.19676609923918828,-0.1953401408598886},
{0.6273352651718965,0.19020706644101826,-0.182909691557124},
{0.6236401730237984,0.19999075663343058,-0.1699810022514737},
{0.622817287951159,0.21155849172305374,-0.15584766931893673},
{0.7249700154206408,0.2520647276137686,-0.24557595943139018},
{0.7111695939832448,0.24278829534284624,-0.2358411162980843},
{0.7011995334730109,0.22722787679118409,-0.2394527926990931},
{0.6894634639027748,0.21647776632168117,-0.23386844660340098},
{0.6784262830243695,0.20505056046364128,-0.23005010956771105},
{0.6678993660403221,0.19309129740794956,-0.22775655226935923},
{0.6646544183292202,0.19722451010157183,-0.217367910037244},
{0.6490707034878304,0.18982305340711994,-0.20601585350090632},
{0.6327324894565501,0.18215707110027624,-0.1948366404044837},
{0.6174456144358842,0.17349385729444405,-0.18124738856107084},
{0.6148424419321191,0.1829544054035368,-0.16611081218380921},
{0.6157021501723925,0.19486857886620715,-0.14858974782893608},
{-0.72193172834422,0.26006888186827226,-0.2335821276877155},
{-0.7377273642728102,0.26874336807235977,-0.24514084485873427},
{-0.7077239975831978,0.2503678559297324,-0.22401862500789066},
{-0.7111695939832448,0.24278829534284624,-0.2358411162980843},
{-0.7249700154206408,0.2520647276137686,-0.24557595943139018},
{-0.7403786323424645,0.2603123656705874,-0.257169245290392},
{-0.5148186947464612,-0.03368681069284668,-0.10221434991327769},
{-0.5213521767752525,-0.022506094609990084,-0.07771116207905107},
{-0.5324945667040409,-0.009575902317905713,-0.0906097916560205},
{-0.5297057753756715,-0.019268661831058322,-0.11078212408054805},
{-0.5391700809508494,0.0017265556661085635,-0.10324314412738111},
{-0.5454029656928316,0.016497154846680344,-0.08764665390130189},
{-0.5418942438625549,0.006865266284106492,-0.07104316276441289},
{-0.5343199437281879,-0.004843749530316734,-0.05241815487373411},
{-0.5169822437182682,-0.041277643677988175,-0.12075669355008402},
{-0.5342688421894304,-0.02611251055847973,-0.12617270516516318},
{-0.5395052469256413,-0.005892834061279764,-0.12104301246576948},
{-0.5494031640870409,-0.009862221233591154,-0.13988595338938473},
{-0.5442614474961749,0.0055306143306750235,-0.12946574844215455},
{-0.5426464885727942,0.011117966399235272,-0.11445316844570161},
{-0.4959554635059864,-0.05542901244773365,-0.12370630442689623},
{-0.5123177253202112,-0.06062032759092319,-0.1336365357966279},
{-0.5386568110836232,-0.06445068851808543,-0.13622242395640136},
{-0.5697430794989645,-0.06756262192977446,-0.13902624514911127},
{-0.5798859834491135,-0.057615106216051294,-0.13308644276176765},
{-0.5518545349609675,-0.0538065385921827,-0.1303201962299088},
{-0.5386568110836232,-0.06445068851808543,-0.13622242395640136},
{-0.5301078242467784,-0.048172593944167064,-0.12816791965635718},
{-0.5123177253202112,-0.06062032759092319,-0.1336365357966279},
{-0.5169822437182682,-0.041277643677988175,-0.12075669355008402},
{-0.4959554635059864,-0.05542901244773365,-0.12370630442689623},
{-0.5565025205082499,0.046723715021748186,-0.0952149420899327},
{-0.5682498624767413,0.08102111395342543,-0.11284722744092511},
{-0.5799521148522113,0.11229675865945633,-0.13587297961048603},
{-0.592046646686967,0.13667369563322318,-0.1594142561269242},
{-0.6065406963636746,0.15419551148131336,-0.17945808321134094},
{-0.6174456144358842,0.17349385729444405,-0.18124738856107084},
{-0.6273352651718965,0.19020706644101826,-0.182909691557124},
{0.5386568110836232,-0.06445068851808543,-0.13622242395640136},
{0.5518545349609675,-0.0538065385921827,-0.1303201962299088},
{0.5301078242467784,-0.048172593944167064,-0.12816791965635718},
{0.5123177253202112,-0.06062032759092319,-0.1336365357966279},
{0.5169822437182682,-0.041277643677988175,-0.12075669355008402},
{0.5342688421894304,-0.02611251055847973,-0.12617270516516318},
{0.5469217334844335,-0.034006946803298174,-0.13139257705059953},
{0.5518545349609675,-0.0538065385921827,-0.1303201962299088},
{0.5665665176706115,-0.04115364729717949,-0.13218690538099204},
{0.5293743668669647,-0.07028528185504601,-0.15211875997607247},
{0.5386568110836232,-0.06445068851808543,-0.13622242395640136},
{0.5123177253202112,-0.06062032759092319,-0.1336365357966279},
{0.4987074316667218,-0.06712525287746755,-0.15120419273095642},
{0.5697430794989645,-0.06756262192977446,-0.13902624514911127},
{0.5629202725816197,-0.07357156169308417,-0.15385245482774274},
{0.5818398658133711,-0.029021540801572727,-0.13987317800469531},
{0.6051526883918346,-0.033999431871127944,-0.1409410498660839},
{0.5967239404697133,-0.01993974527385919,-0.151428137709629},
{0.595898800917423,-0.00800828746719733,-0.17035449438033373},
{0.6089830493189968,-0.004540897763856788,-0.18587959275079582},
{0.6188215985162517,-0.0022473404655049636,-0.20030525654475442},
{0.6247614009035954,-0.0006879920401838555,-0.21266656847155296},
{0.6285617021020768,0.0008127399142095024,-0.22273056563391458},
{0.6417376326761275,0.002200747886049581,-0.22586128637602917},
{0.6450306759531188,0.006494028634897518,-0.2338804704948733},
{0.6596667578478437,0.007912096335418473,-0.23307712424587654},
{0.6785638062830845,0.010331904494230033,-0.2374350334113884},
{0.7009470317520914,0.013600148495059675,-0.2503238935765366},
{0.7259161453808718,0.01820078996966974,-0.26868212137517244},
{0.752570858295433,0.02461929353625652,-0.28944888493436455},
{0.7823390076081173,0.0253076613230489,-0.30641985625437745},
{0.8120673277802994,0.03284739276943283,-0.31893597578388255},
{0.8393179748159594,0.04634345945393494,-0.3267560142002158},
{0.5634094946659012,-0.021266130801903385,-0.14100267230987973},
{0.5802219009171223,-0.013091387587135643,-0.15469262424437358},
{-0.5518545349609675,-0.0538065385921827,-0.1303201962299088},
{-0.5665665176706115,-0.04115364729717949,-0.13218690538099204},
{-0.5921037601714607,-0.04575278578535551,-0.13430160729369256},
{-0.5818398658133711,-0.029021540801572727,-0.13987317800469531},
{-0.6051526883918346,-0.033999431871127944,-0.1409410498660839},
{-0.5967239404697133,-0.01993974527385919,-0.151428137709629},
{-0.5802219009171223,-0.013091387587135643,-0.15469262424437358},
{-0.5634094946659012,-0.021266130801903385,-0.14100267230987973},
{-0.5469217334844335,-0.034006946803298174,-0.13139257705059953},
{-0.5342688421894304,-0.02611251055847973,-0.12617270516516318},
{-0.6177897983292803,-0.024378064213592416,-0.15127257861370544},
{-0.6103500154807603,-0.013286775823561449,-0.16528943009760394},
{-0.595898800917423,-0.00800828746719733,-0.17035449438033373},
{-0.5864743244827473,-0.001304967971359113,-0.17647991559228185},
{-0.5695634726200962,-0.004486038759014174,-0.1594037352218859},
{-0.5519815373146442,0.004542400750290834,-0.14652238998890796},
{-0.5660329574865257,0.005224756591346986,-0.16389691316646174},
{-0.5825357485323338,0.006385813611646335,-0.18095731217930025},
{-0.5666251341415393,0.01609811194844154,-0.168030877353301},
{-0.5822839983046313,0.015063305788601926,-0.18442019292333867},
{-0.5976076964929314,0.006834455062208613,-0.19707158123190782},
{-0.5977512316973826,0.014064571303179415,-0.20000090179186042},
{-0.5839192475448717,0.024724502586639652,-0.18750281809956382},
{-0.5997404342428405,0.02236030492588771,-0.20227717474622073},
{-0.5864224714507728,0.035117653778057006,-0.1914579269007518},
{-0.5712716167023877,0.04055996765573192,-0.17712770274535503},
{-0.5683340297170477,0.028191892289980196,-0.17166134108473535},
{0.6366522780765381,0.26754548788442634,-0.17697965858160164},
{0.642228357746843,0.258807876250109,-0.173678348879223},
{0.6543311560069859,0.2708535610257582,-0.18036438403106975},
{0.6487986629432683,0.2770398531882851,-0.18614336686997063},
{0.6688800646885361,0.2838280914176468,-0.1866596427100649},
{0.6636113457439933,0.2895619846635264,-0.1933561987669499},
{0.6581066579293056,0.2923139528242618,-0.2068409930531967},
{0.652235992917928,0.29121301526132426,-0.2282157146249598},
{0.6653112234008975,0.29792986163506885,-0.25789143027195033},
{0.6454988562273237,0.28253852905723675,-0.2530067243613059},
{0.6365523294786741,0.2789666817967301,-0.2229056635534808},
{0.6289269278055496,0.27025236645214035,-0.2507484872441541},
{0.6305569165932708,0.27341615289580395,-0.1895919692428856},
{0.6366522780765381,0.26754548788442634,-0.17697965858160164},
{0.6429174770268523,0.2802051426183827,-0.19963943355447278},
{0.6650820179697058,0.25423203405166067,-0.1844750519281813},
{-0.6792401501784046,0.26690296118387236,-0.18922824652584685},
{-0.6650820179697058,0.25423203405166067,-0.1844750519281813},
{-0.6331247689158358,0.24779925211395043,-0.16517595462183357},
{-0.6370768717441556,0.23727308662312013,-0.17012453745592493},
{-0.6523968124663707,0.24117183343303142,-0.1808573635814363},
{-0.6283783377571235,0.260298087299464,-0.1638608414920447},
{-0.6366522780765381,0.26754548788442634,-0.17697965858160164},
{-0.6208070435956246,0.2776545746398093,-0.16942865473696234},
{-0.6305569165932708,0.27341615289580395,-0.1895919692428856},
{0.618454869826345,0.002568979562390463,-0.21961562624935746},
{0.6228428387205377,0.003473025902468205,-0.2292129461239483},
{0.631983250719179,0.0029304477997781596,-0.23026428513456237},
{0.635433356078528,0.006230254515722725,-0.23647161910716594},
{0.639321581983401,0.011278785947678022,-0.24255645968539488},
{0.650039378244572,0.013140234646242074,-0.24136383994998062},
{0.6648039654794076,0.016053773848637248,-0.24151714456625312},
{0.6829209639553794,0.01988338328258249,-0.245874302238548},
{0.7036989999128268,0.02449379416901383,-0.25729549615085173},
{0.6875967547516916,0.03166003348653774,-0.2532735044533488},
{0.706376570245077,0.03788690628278389,-0.2628738303008077},
{0.6912580297050239,0.044468483877464514,-0.25923359715755206},
{0.7079877717023726,0.05228927378701479,-0.2669506810031533},
{0.6925708883551617,0.05711686621316554,-0.26335553745291895},
{0.7075406332382445,0.06620993413913444,-0.26941633024820316},
{0.6902029332283247,0.06841180926500955,-0.26524178542764476},
{0.704043183806223,0.07815867628978782,-0.2701610600262722},
{-0.6089830493189968,-0.004540897763856788,-0.18587959275079582},
{-0.6218486131944173,-0.008439644573768102,-0.1798939492772138},
{-0.600841371805778,0.0006421509539454749,-0.19264528618364687},
{-0.6117921309642259,0.001788929603121408,-0.20724229043108658},
{-0.6096481208160616,0.00692613723468529,-0.21158817570512609},
{-0.6106829269759011,0.01324694668305921,-0.21411995635327397},
{-0.6188215985162517,-0.0022473404655049636,-0.20030525654475442},
{-0.6305524076339687,-0.005033877314223359,-0.19396415677952095},
{-0.6247614009035954,-0.0006879920401838555,-0.21266656847155296},
{-0.618454869826345,0.002568979562390463,-0.21961562624935746},
{-0.6285617021020768,0.0008127399142095024,-0.22273056563391458},
{-0.6228428387205377,0.003473025902468205,-0.2292129461239483},
{-0.631983250719179,0.0029304477997781596,-0.23026428513456237},
{-0.6269707909616408,0.004991793694070114,-0.23548566000643278},
{-0.6309875222066246,0.00687202972305972,-0.23849012988808763},
{-0.6263868807320145,0.00852606629372564,-0.23971280935218278},
{-0.6219342834211579,0.007440910088345548,-0.23339500587667694},
{-0.6228428387205377,0.003473025902468205,-0.2292129461239483},
{-0.6170555894562496,0.00701781940716201,-0.22385780545944792},
{-0.618454869826345,0.002568979562390463,-0.21961562624935746},
{-0.6357925698362646,-0.0027057513278885195,-0.20622176264237038},
{-0.6390330085880644,-0.0005850374694518122,-0.21680804759056246},
{-0.6417376326761275,0.002200747886049581,-0.22586128637602917},
{-0.635433356078528,0.006230254515722725,-0.23647161910716594},
{-0.6317405184100808,0.009923092184169952,-0.24277815018441642},
{-0.5538031568727061,0.016919494034646838,-0.1513868055826928},
{-0.5468480871491654,0.017275701819515352,-0.13504408259211054},
{-0.5560516245780365,0.0310573359264859,-0.15475199220851832},
{-0.5501396274397228,0.03161644687995045,-0.13677176549804462},
{-0.5453939477742274,0.018898927168283352,-0.12278196776995891},
{-0.5469089580997443,0.02423377751592413,-0.10321158141226616},
{-0.5557247250286319,0.05027827793826331,-0.11535120284004316},
{-0.5666829991192499,0.07983826362983247,-0.13570163915700495},
{-0.5789631497786101,0.10843107755109399,-0.15741002371712592},
{-0.593869769231463,0.1315710566896423,-0.1773944828373979},
{-0.6108662913208546,0.14848792049802956,-0.19383489994619307},
{-0.6222213538300604,0.16620662756897953,-0.19445112438415132},
{-0.5596896032416412,0.0508824784847492,-0.15994105287205676},
{-0.556097465664275,0.05149118799053719,-0.13640503680813776},
{-0.5479685635357455,0.029473188225003055,-0.11912369878949472},
{-0.6131914113343213,0.020835525188549617,-0.2156131733754971},
{-0.6020452639394477,0.03175171565901446,-0.20474282399127064},
{-0.6154676842886816,0.02977378551181195,-0.21684637374463056},
{0.5836178987648458,0.07114048113601727,-0.20881366274788002},
{0.580041542545037,0.0626583771954874,-0.19814170757294747},
{0.5907909015213229,0.056366875982577405,-0.20492243087013898},
{0.5922923849689333,0.0652645556721205,-0.2127800439473233},
{0.6032258597833896,0.05254177550793426,-0.21263650874287207},
{0.6031349291041299,0.042267360244806415,-0.2082402734232921},
{0.5887738937268352,0.045991760628368565,-0.1975397615061126},
{0.5755506190801122,0.05225695957868282,-0.18676710624009907},
{0.574429391200315,0.07297487607876846,-0.19332238157218393},
{0.5794899465237426,0.08008475340501575,-0.20617592155613204},
{0.5864623005912749,0.07733278524428033,-0.21888141737632674},
{0.5936706235289521,0.07194157290536297,-0.22096079910782723},
{0.5887551063964097,0.08086480336428481,-0.22844492005615155},
{0.5953193996470988,0.07565319790423568,-0.2293151492014633},
{0.5915431462315621,0.08297950527698533,-0.23689846725443456},
{0.5977970727836212,0.07778894162701284,-0.23729149820693718},
{0.5958702441751761,0.08492136374977079,-0.24363710693147284},
{0.6016627538919833,0.07973455756588342,-0.24434050458260562},
{0.6017206188696941,0.0882572421401324,-0.24861875546711315},
{0.607502607681463,0.08294794256187041,-0.24995491040697868},
{0.5682370870920519,0.0638449849851655,-0.1785645577763015},
{0.5716060311839626,0.08353861623044992,-0.1755751177589871},
{0.577404552846506,0.08887196359165657,-0.19149099260230076},
{0.5794899465237426,0.08008475340501575,-0.20617592155613204},
{0.582884441385032,0.09334034226007072,-0.20514412136916052},
{0.5834803755061307,0.08513027886410296,-0.21756254678045278},
{0.5875624866609954,0.09668899603512175,-0.21704702243357551},
{0.5864623005912749,0.08806561136979174,-0.22791737181780197},
{0.5909569815222848,0.09866091423658813,-0.22771071118312083},
{0.5896576497500534,0.08979930622146205,-0.23665348046568532},
{0.5942034322198207,0.09960629270360206,-0.2367151029094811},
{0.5942898539397783,0.09123841573205961,-0.24318395652160843},
{0.598438096497741,0.09987382428886199,-0.24363710693147284},
{0.5993894869104912,0.09251820868064846,-0.24695645247106},
{0.5896576497500534,0.08979930622146205,-0.23665348046568532},
{0.5864623005912749,0.08806561136979174,-0.22791737181780197},
{0.5834803755061307,0.08513027886410296,-0.21756254678045278},
{0.6158058562363417,0.040145894893152664,-0.2185950984606413},
{0.6145035184912422,0.050375220563259174,-0.22088940725221012},
{0.6025359890101631,0.06121325573915367,-0.21779851565059774},
{0.6022707119045544,0.06760094808384261,-0.22375860835480102},
{0.6036369265731008,0.07102850864668092,-0.2305498525570308},
{0.6088485320331499,0.06423651295123407,-0.2262445479167105},
{0.6117658287016301,0.06565157467888698,-0.23125775916746574},
{0.6063565805255041,0.07286741254873437,-0.23767400825440146},
{0.6151280093545876,0.06689604744627577,-0.23787465694334642},
{0.6101523727646834,0.07448913491106832,-0.2446358414168954},
{0.619131213721665,0.06809017016812405,-0.24472752358937205},
{0.615920083205329,0.07721780678207596,-0.2505530990077284},
{0.624881639818319,0.07034915877849282,-0.25078230443892013},
{0.6245547402689143,0.08237831070336762,-0.25454352799011637},
{0.6334877401396576,0.07478747771822612,-0.2550019388524999},
{0.6322951204042433,0.06162281954243079,-0.25101150987011195},
{0.6411589828990204,0.06586575024573829,-0.2554611012081005},
{0.6377562216123437,0.05176999197405244,-0.25109793159006943},
{0.6470131150596234,0.056090326478713204,-0.25563244166158156},
{0.6118575108741069,0.058886632739252875,-0.22375860835480102},
{0.6177642475599016,0.05818548956777117,-0.2305498525570308},
{0.6217794758184513,0.049056349967385164,-0.22928659245921645},
{0.6220199536478984,0.058556727216980145,-0.23772060083385685},
{0.626878357295947,0.04870991159433793,-0.23741324010809478},
{0.6316240369614424,0.0494629077977942,-0.2448537744498318},
{0.6408606400918625,0.041521878973520374,-0.2508972829011245},
{-0.6031349291041299,0.042267360244806415,-0.2082402734232921},
{-0.5887738937268352,0.045991760628368565,-0.1975397615061126},
{-0.5907909015213229,0.056366875982577405,-0.20492243087013898},
{-0.6032258597833896,0.05254177550793426,-0.21263650874287207},
{-0.5922923849689333,0.0652645556721205,-0.2127800439473233},
{-0.5836178987648458,0.07114048113601727,-0.20881366274788002},
{-0.580041542545037,0.0626583771954874,-0.19814170757294747},
{-0.5755506190801122,0.05225695957868282,-0.18676710624009907},
{-0.6158058562363417,0.040145894893152664,-0.2185950984606413},
{-0.6145035184912422,0.050375220563259174,-0.22088940725221012},
{-0.6118575108741069,0.058886632739252875,-0.22375860835480102},
{-0.6025359890101631,0.06121325573915367,-0.21779851565059774},
{-0.5936706235289521,0.07194157290536297,-0.22096079910782723},
{-0.5864623005912749,0.07733278524428033,-0.21888141737632674},
{-0.574429391200315,0.07297487607876846,-0.19332238157218393},
{-0.5682370870920519,0.0638449849851655,-0.1785645577763015},
{-0.567396166182204,0.07973080009979829,-0.1570838756609383},
{-0.5794899465237426,0.08008475340501575,-0.20617592155613204},
{-0.5834803755061307,0.08513027886410296,-0.21756254678045278},
{-0.5887551063964097,0.08086480336428481,-0.22844492005615155},
{-0.5864623005912749,0.08806561136979174,-0.22791737181780197},
{-0.5915431462315621,0.08297950527698533,-0.23689846725443456},
{-0.5896576497500534,0.08979930622146205,-0.23665348046568532},
{-0.5958702441751761,0.08492136374977079,-0.24363710693147284},
{-0.5942898539397783,0.09123841573205961,-0.24318395652160843},
{-0.6088485320331499,0.06423651295123407,-0.2262445479167105},
{-0.6022707119045544,0.06760094808384261,-0.22375860835480102},
{-0.5953193996470988,0.07565319790423568,-0.2293151492014633},
{0.5981179603872896,0.12857259875372362,-0.1926392742379107},
{0.5862173138025256,0.10814100116932342,-0.19160972853059027},
{0.5916107806210942,0.10947415013632088,-0.20517267811140735},
{0.6034791129975261,0.1270530794689047,-0.2057175106937485},
{0.5966390217361899,0.11083360136591404,-0.21702673211671591},
{0.5815264931418729,0.10741956768098211,-0.1758388918781619},
{0.593869769231463,0.1315710566896423,-0.1773944828373979},
{0.6108662913208546,0.14848792049802956,-0.19383489994619307},
{0.6162988357867082,0.14464328119974385,-0.20623378653384275},
{0.6086388654256006,0.12638800797184002,-0.2171958180905459},
{0.6002334137932072,0.11163018417595764,-0.22767088204261868},
{0.5789631497786101,0.10843107755109399,-0.15741002371712592},
{0.592046646686967,0.13667369563322318,-0.1594142561269242},
{0.6065406963636746,0.15419551148131336,-0.17945808321134094},
{0.6222213538300604,0.16620662756897953,-0.19445112438415132},
{0.6278800977542377,0.16081165776397702,-0.20617592155613204},
{0.6214931569027659,0.14217763195469396,-0.21724767112252047},
{0.6122851105145924,0.1259521419059671,-0.22764232530037182},
{0.6033671405081898,0.11163845060134488,-0.23685337766141323},
{0.567396166182204,0.07973080009979829,-0.1570838756609383},
{0.5666829991192499,0.07983826362983247,-0.13570163915700495},
{0.5799521148522113,0.11229675865945633,-0.13587297961048603},
{0.5939614514039396,0.14450575794102882,-0.13813196822085483},
{0.6046657207872042,0.16225076727457458,-0.16251040818105575},
{0.6386595164592045,0.17579342653853203,-0.2059640004689318},
{0.6439455197477387,0.17106578271024528,-0.21649317193263015},
{0.633132283848006,0.15702788941627013,-0.21687493048687745},
{0.6251055847969916,0.14060701113111757,-0.22747023335367375},
{0.6153354214824858,0.1251322628061959,-0.23683834779707277},
{0.6070118826107476,0.11063220118375214,-0.24432322023861414},
{0.606586537449913,0.1731384010027925,-0.14239744372067298},
{-0.5815264931418729,0.10741956768098211,-0.1758388918781619},
{-0.5862173138025256,0.10814100116932342,-0.19160972853059027},
{-0.577404552846506,0.08887196359165657,-0.19149099260230076},
{-0.5716060311839626,0.08353861623044992,-0.1755751177589871},
{-0.5794899465237426,0.08008475340501575,-0.20617592155613204},
{-0.582884441385032,0.09334034226007072,-0.20514412136916052},
{-0.5916107806210942,0.10947415013632088,-0.20517267811140735},
{-0.5981179603872896,0.12857259875372362,-0.1926392742379107},
{-0.5966390217361899,0.11083360136591404,-0.21702673211671591},
{-0.6034791129975261,0.1270530794689047,-0.2057175106937485},
{-0.6086388654256006,0.12638800797184002,-0.2171958180905459},
{-0.6002334137932072,0.11163018417595764,-0.22767088204261868},
{-0.6122851105145924,0.1259521419059671,-0.22764232530037182},
{-0.6033671405081898,0.11163845060134488,-0.23685337766141323},
{-0.6153354214824858,0.1251322628061959,-0.23683834779707277},
{-0.6162988357867082,0.14464328119974385,-0.20623378653384275},
{-0.6278800977542377,0.16081165776397702,-0.20617592155613204},
{-0.6386595164592045,0.17579342653853203,-0.2059640004689318},
{-0.6327324894565501,0.18215707110027624,-0.1948366404044837},
{-0.6429475367555333,0.19676609923918828,-0.1953401408598886},
{-0.6369618932819512,0.20507385675336898,-0.18459529084290485},
{-0.6470754889966362,0.21883369755704582,-0.1864529820753838},
{-0.641353619642229,0.22789294828824877,-0.17758911958060666},
{-0.6584282970261911,0.23222756116403295,-0.18863156091153122},
{-0.6709556889539515,0.24513896612569175,-0.19171644056740741},
{-0.6845952908429048,0.2574544369662519,-0.19629153127263874},
{-0.6897896119589625,0.2482005494918403,-0.20584376155420822},
{-0.6945029774161259,0.23970341568696998,-0.21688620288513277},
{-0.6984129966242926,0.2325251524779737,-0.22842162376642386},
{-0.7011995334730109,0.22722787679118409,-0.2394527926990931},
{-0.7138246195189842,0.2371581081609157,-0.2470443771774516},
{-0.7275273468381674,0.2461249252264249,-0.2568829263747065},
{-0.7428412756146463,0.2540892503404264,-0.2684874846319637},
{-0.6214931569027659,0.14217763195469396,-0.21724767112252047},
{-0.633132283848006,0.15702788941627013,-0.21687493048687745},
{-0.6439455197477387,0.17106578271024528,-0.21649317193263015},
{-0.6543228895815987,0.1844220716563812,-0.21651947419522594},
{-0.6490707034878304,0.18982305340711994,-0.20601585350090632},
{-0.6595517793856392,0.20313575574666867,-0.20674931088071996},
{-0.6534173402550869,0.21046056013298423,-0.19630881561663024},
{-0.6646889870172032,0.22366730192893278,-0.198092109020624},
{-0.5875624866609954,0.09668899603512175,-0.21704702243357551},
{-0.5909569815222848,0.09866091423658813,-0.22771071118312083},
{-0.5942034322198207,0.09960629270360206,-0.2367151029094811},
{-0.5834803755061307,0.08513027886410296,-0.21756254678045278},
{-0.5864623005912749,0.08806561136979174,-0.22791737181780197},
{-0.5896576497500534,0.08979930622146205,-0.23665348046568532},
{-0.598438096497741,0.09987382428886199,-0.24363710693147284},
{0.6543228895815987,0.1844220716563812,-0.21651947419522594},
{0.6576940881531603,0.18074125787940637,-0.2267480483721154},
{0.6474196728900325,0.16792679554274345,-0.2266270579641748},
{0.6366868467645211,0.15457351256947555,-0.2269997985998178},
{0.6280754859906634,0.13907321347517515,-0.23665498345211936},
{0.6187066200540474,0.12331515220743614,-0.24456745553414636},
{-0.6646544183292202,0.19722451010157183,-0.217367910037244},
{-0.6753301309702379,0.20960310637236182,-0.21945480670091472},
{-0.6705371072320702,0.21596750242732307,-0.20858445731668823},
{-0.6768008031959504,0.23628261856308483,-0.20112513564452567},
{-0.6821469259418464,0.2281965515479257,-0.2118519498243009},
{-0.686525125424218,0.22141733123716828,-0.22304995025114902},
{-0.6894634639027748,0.21647776632168117,-0.23386844660340098},
{-0.6920463460896802,0.21236709842456963,-0.24411580811071598},
{-0.7038252507732865,0.2228248780326509,-0.24979033339245077},
{-0.7165134622494898,0.23250260768146305,-0.25740746864018804},
{-0.7302905873971582,0.2412635156055081,-0.26719717077833655},
{-0.7456458483005732,0.24906401519819882,-0.2786709692158319},
{-0.6784262830243695,0.20505056046364128,-0.23005010956771105},
{-0.6809948868401514,0.20126679211593437,-0.2401524328841408},
{-0.6842052658632704,0.19720722575758032,-0.2495438436172675},
{-0.6953574252038801,0.2080723146892876,-0.25359739802988535},
{-0.7072543143225589,0.21832944560842393,-0.2592448695558074},
{-0.7200627647134857,0.22784710720201043,-0.26670945168048915},
{-0.7339488563776224,0.2364930366638511,-0.27621584087582024},
{-0.7493221531182459,0.24422965933309485,-0.28729886284046396},
{0.6920463460896802,0.21236709842456963,-0.24411580811071598},
{0.7038252507732865,0.2228248780326509,-0.24979033339245077},
{0.6953574252038801,0.2080723146892876,-0.25359739802988535},
{0.6842052658632704,0.19720722575758032,-0.2495438436172675},
{0.6809948868401514,0.20126679211593437,-0.2401524328841408},
{0.6704912661458318,0.18966223385867717,-0.23767025078831638},
{0.7138246195189842,0.2371581081609157,-0.2470443771774516},
{0.7165134622494898,0.23250260768146305,-0.25740746864018804},
{0.7072543143225589,0.21832944560842393,-0.2592448695558074},
{0.7004796029711036,0.20258265673894024,-0.2621200826041344},
{0.6892282465258469,0.19182954029656926,-0.25800640873415476},
{0.6785292375951015,0.18063229136293818,-0.2550823486267213},
{0.6736332592862017,0.18586644161949797,-0.24686026133928113},
{0.6634738224852783,0.17418222508123643,-0.24532420920368772},
{0.6603543741414191,0.17769094691151313,-0.23643705041918292},
{0.6501776529965041,0.16530258122890182,-0.23609587249865482},
{0.6395537933874609,0.15244678676530266,-0.23628825476221252},
{0.6313429784982761,0.13671953671946152,-0.244555431642674},
{0.7200627647134857,0.22784710720201043,-0.26670945168048915},
{0.7124486354386166,0.21275637191098715,-0.26762702489847323},
{0.7252969149700456,0.2222169200200799,-0.27473089027898434},
{0.7203723799188989,0.20511969783960732,-0.27474817462297585},
{0.7084980355967307,0.19488586321019866,-0.2694907280766884},
{-0.6736332592862017,0.18586644161949797,-0.24686026133928113},
{-0.6704912661458318,0.18966223385867717,-0.23767025078831638},
{-0.6785292375951015,0.18063229136293818,-0.2550823486267213},
{-0.6892282465258469,0.19182954029656926,-0.25800640873415476},
{-0.7004796029711036,0.20258265673894024,-0.2621200826041344},
{-0.7124486354386166,0.21275637191098715,-0.26762702489847323},
{-0.7252969149700456,0.2222169200200799,-0.27473089027898434},
{-0.7391890185799184,0.23082828079393755,-0.28363458191426366},
{-0.7544022472653161,0.2385761758614367,-0.2939465718382426},
{-0.6678993660403221,0.19309129740794956,-0.22775655226935923},
{-0.6576940881531603,0.18074125787940637,-0.2267480483721154},
{-0.6603543741414191,0.17769094691151313,-0.23643705041918292},
{-0.6634738224852783,0.17418222508123643,-0.24532420920368772},
{-0.6682210051372076,0.16912542722389384,-0.253144247620021},
{-0.6757659970361107,0.16143088817480328,-0.2596348945354419},
{-0.6863845961926348,0.17288665077509008,-0.2620885198890195},
{-0.6972316492871335,0.18408916016124036,-0.2653221952018661},
{-0.7084980355967307,0.19488586321019866,-0.2694907280766884},
{-0.7203723799188989,0.20511969783960732,-0.27474817462297585},
{-0.7330433070511105,0.2146373594331937,-0.2812500939366521},
{-0.7467001932840555,0.22328328889503446,-0.28915054212720676},
{-0.7614159334597846,0.23109581237919746,-0.29819175702120115},
{-0.6474196728900325,0.16792679554274345,-0.2266270579641748},
{-0.6501776529965041,0.16530258122890182,-0.23609587249865482},
{-0.6533136341911377,0.16211925596159565,-0.2446305809643762},
{-0.6579232935843522,0.15730293593370023,-0.251960645803211},
{-0.6651015567933485,0.14978048883130782,-0.25781703244346516},
{-0.6740172723201001,0.14039884751000234,-0.2624755388957859},
{-0.6851634197149736,0.15193652287094458,-0.26499529565246144},
{-0.696163025932528,0.16342610266599736,-0.26801404390523975},
{-0.707156620204346,0.17473231811609669,-0.27157762474035907},
{-0.7183726564684028,0.18566729591698702,-0.2757784718235133},
{-0.7300388371694557,0.19604391425762993,-0.2807105218068302},
{-0.7423828647522628,0.20567279684733564,-0.28646695984922044},
{-0.7556324416615816,0.21436757336828274,-0.29314097110959475},
{-0.7523987663487349,0.19588910665492332,-0.29058363969206813},
{-0.7651388308569126,0.20459214960125774,-0.29598462144280685},
{-0.762174941608977,0.18584990876872343,-0.29380003066092325},
{-0.7743694220415966,0.19446728148831727,-0.2980602457082222},
{-0.770792314328571,0.17612032608793676,-0.2963175329379477},
{-0.7824765308668323,0.18450248143060263,-0.2997458449940031},
{-0.7874581794024726,0.2023865170092975,-0.30304865768281575},
{-0.7951151437907121,0.192124125637642,-0.30389709352483385},
{-0.7910653468441795,0.17454294182540706,-0.30222877858304453},
{-0.8031959503533521,0.182048856077025,-0.3058021288299852},
{-0.8017410594851971,0.16443535805645818,-0.30669490277180755},
{-0.8132223728548625,0.17243425185844272,-0.3098662041476414},
{-0.8166303945940583,0.1892804753044299,-0.3110761082270471},
{-0.8252379979018309,0.18010173715172043,-0.31451794716100895},
{-0.8321667653627758,0.19653989978086459,-0.3190967953323253},
{-0.8392683762636358,0.18690275076577154,-0.3217089857546946},
{-0.8372273206862035,0.17277542977897076,-0.3210439142576299},
{-0.8450360867042814,0.1799454265625798,-0.3250335917468009},
{-0.8567947010710282,0.19230222953007622,-0.33249817387148267},
{-0.8590604531203502,0.18032042167787393,-0.3332444066359857},
{-0.8757345846196393,0.19718543245428663,-0.344885788060877},
{-0.8780146150400847,0.1815506160741393,-0.345055625527924},
{-0.8970078546071044,0.18380284124555493,-0.3569885863210199},
{-0.8940033847254494,0.20243611556162097,-0.35687360785881544},
{0.6533136341911377,0.16211925596159565,-0.2446305809643762},
{0.6427416276140692,0.1496429655725927,-0.24447577336166965},
{0.6579232935843522,0.15730293593370023,-0.251960645803211},
{0.6472596048348068,0.1451595570398381,-0.2512985802790144},
{0.6358496833207583,0.13268927859657134,-0.2509258396433714},
{0.6233162794472618,0.11988608865816375,-0.25061021249222204},
{0.6118056578421323,0.10805758542223397,-0.2499691887781021},
{0.6682210051372076,0.16912542722389384,-0.253144247620021},
{-0.6395537933874609,0.15244678676530266,-0.23628825476221252},
{-0.6427416276140692,0.1496429655725927,-0.24447577336166965},
{-0.6472596048348068,0.1451595570398381,-0.2512985802790144},
{-0.6541162289469176,0.13799256622909722,-0.25649290139507197},
{-0.662584806009541,0.1289505998418858,-0.2604089325489748},
{-0.6719363876021656,0.11884301607293694,-0.26339611808663815},
{-0.6838385371733635,0.130005696318585,-0.26621121167760337},
{-0.6954663917203483,0.1414787432628633,-0.2694276026464585},
{-0.7068297206549414,0.1530487328321374,-0.27299343796122894},
{-0.7179412993618319,0.16450374393920716,-0.27685761608315723},
{-0.7290641504669779,0.1756153226460978,-0.28105470570022634},
{-0.740462048089554,0.18615351202840047,-0.28561852400720233},
{-0.7506560535784604,0.17607373350848138,-0.2895743843016073},
{-0.759634894535442,0.16643057254765214,-0.2926825602472112},
{-0.7686821213751724,0.15649432923218434,-0.2960590192712921},
{-0.7797305746518332,0.16620963354184762,-0.2993242572992536},
{-0.7904694127230808,0.15562860904617473,-0.30401132049382124},
{-0.8044870157001963,0.14388652753020248,-0.3115683362841967},
{-0.816108858301445,0.15402341953461524,-0.3143315768431874},
{-0.8270130248804374,0.16355009904680598,-0.31721355333046763},
{-0.8463850170288363,0.15566918967989393,-0.3289699132175633},
{-0.8548686239558001,0.16808385762510103,-0.3316722828259752},
{-0.8751611952950513,0.16537622756417003,-0.3442207165638123},
{-0.895104322288387,0.16399949199058528,-0.3565068791689086},
{-0.6313429784982761,0.13671953671946152,-0.244555431642674},
{-0.6280754859906634,0.13907321347517515,-0.23665498345211936},
{-0.6358496833207583,0.13268927859657134,-0.2509258396433714},
{-0.6425349669793881,0.12612423385266522,-0.25551821469259417},
{-0.6507254915517132,0.11772780013887593,-0.25874888403257273},
{-0.659746416128848,0.10820187211990222,-0.2610334234123203},
{-0.6689259057747744,0.09824834446044291,-0.2627881600740672},
{-0.6814420253042797,0.10847691863733233,-0.26580390235397733},
{-0.6937341998551121,0.11944796811263979,-0.26929834581313067},
{-0.7057287830920038,0.1308947127943223,-0.273130961219944},
{-0.7173506256932526,0.142550372590337,-0.27716197083605126},
{-0.728525329830373,0.15414967039507502,-0.2812500939366521},
{-0.7395332024733144,0.16541530521145514,-0.2853893185760106},
{-0.7487412488614877,0.15575485990663449,-0.28885219932004896},
{-0.7577185868320352,0.14575398817450275,-0.2924210406076875},
{-0.7674955135854943,0.13453569743079496,-0.2970742866074891},
{-0.77908278749876,0.14553755812800032,-0.30082348626721295},
{-0.7921204433208786,0.13283281380102263,-0.3080934316486859},
{-0.8090801422426361,0.11765039633752267,-0.3189870773226401},
{-0.8232645767139306,0.13049341541643242,-0.3231841669397092},
{-0.8357746842976995,0.14315231865717176,-0.3263261600800791},
{-0.8574244523868927,0.1327463920810651,-0.3399311932810494},
{-0.868015997787604,0.14899668140595362,-0.34248025827318884},
{-0.8885851186307192,0.14373773187323213,-0.35509106594803874},
{-0.6366868467645211,0.15457351256947555,-0.2269997985998178},
{-0.6251055847969916,0.14060701113111757,-0.22747023335367375},
{-0.6187066200540474,0.12331515220743614,-0.24456745553414636},
{-0.6233162794472618,0.11988608865816375,-0.25061021249222204},
{-0.6300819728801128,0.11423335667972256,-0.2547501886247975},
{-0.6382980482218168,0.10686571718003675,-0.2574503037535583},
{-0.6472596048348068,0.09829418554668125,-0.25917573217984136},
{-0.656260990588299,0.08902902567401423,-0.2603916482049833},
{-0.6645973048447265,0.07958050145639387,-0.2615609716506699},
{-0.6775891195806067,0.08857061481163067,-0.2644279182736097},
{-0.6903750251750228,0.09866091423658813,-0.26798248119012474},
{-0.7028738603605363,0.10957184425453374,-0.272013490806232},
{-0.7150059668561431,0.12102159490908436,-0.276307523048297},
{-0.7266901833944047,0.13272910773707358,-0.2806534083223365},
{-0.7378476031875336,0.14441407576855206,-0.28483922554115026},
{-0.7466370678538256,0.13434632114010536,-0.28839904891018453},
{-0.7556211692633262,0.12299426460376768,-0.2927051050437219},
{-0.7655288558365473,0.1094057642535718,-0.29853068046207815},
{-0.7791023263224027,0.12121923762516121,-0.3037881270083656},
{-0.7935708252297315,0.10492761617333643,-0.31354025448566303},
{-0.8088306464945847,0.08774622675255729,-0.32412578794063807},
{-0.8273354154705399,0.10185476040893256,-0.331056058388017},
{-0.8437442698642202,0.11693046583561537,-0.33623610113295116},
{-0.8777433259887396,0.12372772198358135,-0.35240147172431624},
{0.6034633316399687,0.09850836111353256,-0.24861875546711315},
{0.6090799919439928,0.09455325231234459,-0.25180132924120224},
{-0.6070118826107476,0.11063220118375214,-0.24432322023861414},
{-0.6118056578421323,0.10805758542223397,-0.2499691887781021},
{-0.618387235436813,0.1033622558022791,-0.25368006228375783},
{-0.6263440456186443,0.09703017395564989,-0.25593604492125854},
{-0.6352650215979151,0.08954530151410849,-0.2572150863766303},
{-0.6441980214686582,0.08111129313946809,-0.2580003967884186},
{-0.6521901518316896,0.07193180349354165,-0.2587744348019515},
{-0.6585357605562253,0.06218643945519748,-0.25910283733779016},
{-0.6714659528483096,0.06982236203336027,-0.26215164531924934},
{-0.6849454866820373,0.07876062235662257,-0.2654228952929471},
{-0.6981146538171347,0.08876525155483944,-0.26955911395943744},
{-0.7109216012216274,0.09958149342744028,-0.27424317118113695},
{-0.7233137243703238,0.11095384028063764,-0.2791571853272452},
{-0.7352361642583815,0.12262678442064384,-0.2839817717805279},
{-0.6034633316399687,0.09850836111353256,-0.24861875546711315},
{-0.6090799919439928,0.09455325231234459,-0.25180132924120224},
{-0.6159043018477716,0.08888473897634598,-0.2536289607450003},
{-0.6245547402689143,0.08237831070336762,-0.25454352799011637},
{-0.5993894869104912,0.09251820868064846,-0.24695645247106},
{-0.6017206188696941,0.0882572421401324,-0.24861875546711315},
{0.6159043018477716,0.08888473897634598,-0.2536289607450003},
{-0.6063565805255041,0.07286741254873437,-0.23767400825440146},
{-0.5977970727836212,0.07778894162701284,-0.23729149820693718},
{-0.6016627538919833,0.07973455756588342,-0.24434050458260562},
{-0.6101523727646834,0.07448913491106832,-0.2446358414168954},
{-0.607502607681463,0.08294794256187041,-0.24995491040697868},
{-0.6036369265731008,0.07102850864668092,-0.2305498525570308},
{-0.6117658287016301,0.06565157467888698,-0.23125775916746574},
{-0.6151280093545876,0.06689604744627577,-0.23787465694334642},
{-0.619131213721665,0.06809017016812405,-0.24472752358937205},
{-0.615920083205329,0.07721780678207596,-0.2505530990077284},
{-0.6177642475599016,0.05818548956777117,-0.2305498525570308},
{-0.6220199536478984,0.058556727216980145,-0.23772060083385685},
{-0.6263898867048826,0.05944424070628338,-0.2448192057618488},
{-0.624881639818319,0.07034915877849282,-0.25078230443892013},
{0.6504932801476534,0.045936150130308905,-0.2552311442836917},
{0.6263898867048826,0.05944424070628338,-0.2448192057618488},
{-0.629548412696027,0.03821906628470771,-0.23715397494822213},
{-0.626878357295947,0.04870991159433793,-0.23741324010809478},
{-0.6316240369614424,0.0494629077977942,-0.2448537744498318},
{-0.6345308127248843,0.039056229728470476,-0.24477336467561045},
{-0.6348066107355315,0.029137270756994137,-0.244521614447908},
{-0.6297693517018316,0.028191140796763152,-0.23691575159842607},
{-0.6321463247472728,0.020617592155613203,-0.24403990729579672},
{-0.6272781516874029,0.019734587625612064,-0.23667226779611086},
{-0.6286421118762983,0.013684315735366165,-0.24266016574934393},
{-0.6240189256051775,0.01282535898830976,-0.23572989530196503},
{-0.6263868807320145,0.00852606629372564,-0.23971280935218278},
{-0.6219342834211579,0.007440910088345548,-0.23339500587667694},
{-0.6187351767962942,0.012756973105560732,-0.2261228060155529},
{-0.6170555894562496,0.00701781940716201,-0.22385780545944792},
{-0.6408606400918625,0.041521878973520374,-0.2508972829011245},
{-0.6377562216123437,0.05176999197405244,-0.25109793159006943},
{-0.6322951204042433,0.06162281954243079,-0.25101150987011195},
{-0.6217794758184513,0.049056349967385164,-0.22928659245921645},
{-0.6239588061478157,0.0386895010385636,-0.22832994159394715},
{-0.6412048239852587,0.03160893194778022,-0.2502660285988259},
{-0.6240159196323094,0.028495495549657145,-0.2276303014088995},
{-0.6216652488494638,0.01988338328258249,-0.22713732185853291},
{-0.6334877401396576,0.07478747771822612,-0.2550019388524999},
{-0.6411589828990204,0.06586575024573829,-0.2554611012081005},
{-0.6470131150596234,0.056090326478713204,-0.25563244166158156},
{-0.6625276925250473,0.05205405641008683,-0.2585512413164959},
{-0.6760643398432685,0.05962760505123682,-0.2616301090266359},
{-0.6902029332283247,0.06841180926500955,-0.26524178542764476},
{-0.704043183806223,0.07815867628978782,-0.2701610600262722},
{0.6269707909616408,0.004991793694070114,-0.23548566000643278},
{0.6263868807320145,0.00852606629372564,-0.23971280935218278},
{0.6309875222066246,0.00687202972305972,-0.23849012988808763},
{0.6317405184100808,0.009923092184169952,-0.24277815018441642},
{-0.6317405184100808,0.009923092184169952,-0.24277815018441642},
{-0.6263868807320145,0.00852606629372564,-0.23971280935218278},
{-0.6345217948062801,0.015395465790525748,-0.24674603437029377},
{-0.6383837184485572,0.022761602303777603,-0.24906213646515624},
{-0.6541966387211389,-0.0007684018144052512,-0.21430632667109545},
{-0.6565473095039844,0.0026606617348671827,-0.22408776238385675},
{-0.6450306759531188,0.006494028634897518,-0.2338804704948733},
{-0.639321581983401,0.011278785947678022,-0.24255645968539488},
{-0.6345217948062801,0.015395465790525748,-0.24674603437029377},
{-0.6435720276188788,0.018018928611150346,-0.24781991817741855},
{-0.6383837184485572,0.022761602303777603,-0.24906213646515624},
{-0.6481080406768249,0.02639657499451408,-0.2515623543981892},
{-0.6510433731825137,0.03587966790011751,-0.25397013866552837},
{-0.6504932801476534,0.045936150130308905,-0.2552311442836917},
{-0.673776794490653,0.00022356923206411598,-0.21848613194417307},
{-0.6758576792085874,0.0041967138704606,-0.22835323788367484},
{-0.6596667578478437,0.007912096335418473,-0.23307712424587654},
{-0.650039378244572,0.013140234646242074,-0.24136383994998062},
{-0.6556184638877449,0.0216020482699123,-0.24789882496520585},
{-0.66062416020633,0.031345157828605426,-0.2530698497915358},
{-0.6634587926209379,0.041713509743861045,-0.25668453216541265},
{-0.6974954234063083,0.002351046529454009,-0.23260744098523767},
{-0.6991126368093401,0.006696931803493513,-0.2420672376011134},
{-0.6785638062830845,0.010331904494230033,-0.2374350334113884},
{-0.6648039654794076,0.016053773848637248,-0.24151714456625312},
{-0.6704852542000956,0.026190665853049997,-0.2489990110349264},
{-0.6752384487977612,0.037427743927183295,-0.2551169173147043},
{-0.6775891195806067,0.04887223412921472,-0.2594628025887438},
{-0.6925708883551617,0.05711686621316554,-0.26335553745291895},
{-0.7075406332382445,0.06620993413913444,-0.26941633024820316},
{-0.7224104295234631,0.07606877365324897,-0.27680350857153163},
{-0.7175452624364612,0.08867958132809894,-0.27587766892816024},
{0.7302905873971582,0.2412635156055081,-0.26719717077833655},
{0.7275273468381674,0.2461249252264249,-0.2568829263747065},
{0.7339488563776224,0.2364930366638511,-0.27621584087582024},
{0.7493221531182459,0.24422965933309485,-0.28729886284046396},
{0.7391890185799184,0.23082828079393755,-0.28363458191426366},
{0.7544022472653161,0.2385761758614367,-0.2939465718382426},
{0.7712123990368863,0.24544482386501976,-0.3052730776052015},
{0.7614159334597846,0.23109581237919746,-0.29819175702120115},
{0.7467001932840555,0.22328328889503446,-0.28915054212720676},
{0.7330433070511105,0.2146373594331937,-0.2812500939366521},
{0.7300388371694557,0.19604391425762993,-0.2807105218068302},
{0.7183726564684028,0.18566729591698702,-0.2757784718235133},
{0.7898975263849269,0.2514191949403464,-0.31722106826263785},
{0.7772634224203493,0.238114007532968,-0.3081167279384136},
{0.7697281999332674,0.22226651857240337,-0.3007047503389234},
{0.7556324416615816,0.21436757336828274,-0.29314097110959475},
{0.7423828647522628,0.20567279684733564,-0.28646695984922044},
{0.8107349303065191,0.25648350772985923,-0.329399015844483},
{0.832206594503278,0.2590408391473858,-0.3406135491221056},
{0.8760915438977248,0.2618566842315681,-0.35175669054411113},
{0.8545958319180211,0.26279079030032676,-0.34811345142798744},
{0.8753776253415537,0.25704938212227696,-0.3563693559101936},
{0.8941318900655604,0.25051890606635385,-0.3578084654207911},
{0.8927265977497287,0.24597237210336942,-0.3618732922316643},
{0.9061835867869457,0.23034882812147733,-0.36516408102900466},
{0.9173612968969342,0.2142127657655762,-0.36324927631203197},
{0.9152864241247358,0.21096781805447423,-0.36678129443203644},
{0.8527952541700359,0.25749276312032005,-0.3496727998533085},
{0.8715187076721446,0.25146503602658477,-0.3565301754586363},
{0.8753776253415537,0.25704938212227696,-0.3563693559101936},
{0.887394753374956,0.240582662750886,-0.36113983485185064},
{0.8927265977497287,0.24597237210336942,-0.3618732922316643},
{0.8998447415013632,0.22560465144241604,-0.3639090873565775},
{0.9061835867869457,0.23034882812147733,-0.36516408102900466},
{0.9152864241247358,0.21096781805447423,-0.36678129443203644},
{0.9082915252606931,0.2072870042774994,-0.365244490803226},
{0.9195744444210646,0.18861916127345035,-0.3672630015841477},
{0.9121557033826213,0.1863887294053284,-0.3655541060086392},
{0.9185884853203314,0.16409117416306204,-0.3671480231219433},
{0.910860129076475,0.16366658049544444,-0.365244490803226},
{0.91241346555606,0.13864636532790653,-0.3658922779562992},
{0.9045618644246117,0.14018842940923615,-0.36387151269572643},
{0.9011358068482075,0.11354498889293027,-0.3629509335048742},
{0.8934187230026062,0.117019893528441,-0.36099028770166325},
{0.8885851186307192,0.14373773187323213,-0.35509106594803874},
{0.8777433259887396,0.12372772198358135,-0.35240147172431624},
{0.868015997787604,0.14899668140595362,-0.34248025827318884},
{0.8574244523868927,0.1327463920810651,-0.3399311932810494},
{0.8463850170288363,0.15566918967989393,-0.3289699132175633},
{0.8357746842976995,0.14315231865717176,-0.3263261600800791},
{0.8270130248804374,0.16355009904680598,-0.31721355333046763},
{0.8372273206862035,0.17277542977897076,-0.3210439142576299},
{0.8548686239558001,0.16808385762510103,-0.3316722828259752},
{0.8934991327768276,0.25532169921634285,-0.350567076781565},
{0.921782331492676,0.19090670662606596,-0.363891803012586},
{0.9195744444210646,0.18861916127345035,-0.3672630015841477},
{0.9208933150169386,0.1652725215002209,-0.3639834851850627},
{0.9185884853203314,0.16409117416306204,-0.3671480231219433},
{0.9147558699135182,0.13865763772616183,-0.3628870565814273},
{0.91241346555606,0.13864636532790653,-0.3658922779562992},
{-0.9173612968969342,0.2142127657655762,-0.36324927631203197},
{-0.9152864241247358,0.21096781805447423,-0.36678129443203644},
{-0.921782331492676,0.19090670662606596,-0.363891803012586},
{-0.9195744444210646,0.18861916127345035,-0.3672630015841477},
{-0.9208933150169386,0.1652725215002209,-0.3639834851850627},
{-0.9185884853203314,0.16409117416306204,-0.3671480231219433},
{-0.9147558699135182,0.13865763772616183,-0.3628870565814273},
{-0.91241346555606,0.13864636532790653,-0.3658922779562992},
{-0.9034293641465593,0.1124102341352267,-0.35996449946042786},
{-0.9011358068482075,0.11354498889293027,-0.3629509335048742},
{-0.8848411794235145,0.09004955346273047,-0.3577799086785443},
{-0.8869746686666407,0.0878762350791022,-0.3545777960808126},
{0.8869746686666407,0.0878762350791022,-0.3545777960808126},
{0.8654511514379072,0.06640457088234321,-0.3460889287013295},
{0.8647627836511147,0.06529236092115029,-0.33921502024522726},
{0.9034293641465593,0.1124102341352267,-0.35996449946042786},
{0.9011358068482075,0.11354498889293027,-0.3629509335048742},
{0.8848411794235145,0.09004955346273047,-0.3577799086785443},
{0.8869746686666407,0.0878762350791022,-0.3545777960808126},
{0.8636160050019389,0.06942031316225342,-0.3498328679085343},
{0.8654511514379072,0.06640457088234321,-0.3460889287013295},
{0.8386589152646309,0.05171588446242682,-0.33881898331985655},
{0.8400762314719348,0.048044840097273285,-0.33428146727547636},
{0.8111670389063068,0.03699262935452743,-0.32444517255787253},
{0.8848411794235145,0.09004955346273047,-0.3577799086785443},
{0.8775885183860331,0.0952265902347965,-0.3561574348229933},
{0.8628712752238699,0.10468112639815315,-0.3481014275365151},
{0.8437442698642202,0.11693046583561537,-0.33623610113295116},
{0.8232645767139306,0.13049341541643242,-0.3231841669397092},
{0.816108858301445,0.15402341953461524,-0.3143315768431874},
{0.8132223728548625,0.17243425185844272,-0.3098662041476414},
{0.8252379979018309,0.18010173715172043,-0.31451794716100895},
{0.8400762314719348,0.048044840097273285,-0.33428146727547636},
{0.857229064150467,0.07587639138969127,-0.34892731858202247},
{0.8334443038317136,0.059054967219865855,-0.33897153644291206},
{0.8386589152646309,0.05171588446242682,-0.33881898331985655},
{0.8636160050019389,0.06942031316225342,-0.3498328679085343},
{0.8073366779791447,0.04484723645884372,-0.32595943139017225},
{0.8111670389063068,0.03699262935452743,-0.32444517255787253},
{0.7800116331149995,0.033340372319799444,-0.30956184939474735},
{-0.8654511514379072,0.06640457088234321,-0.3460889287013295},
{-0.8400762314719348,0.048044840097273285,-0.33428146727547636},
{-0.8386589152646309,0.05171588446242682,-0.33881898331985655},
{-0.8636160050019389,0.06942031316225342,-0.3498328679085343},
{-0.8386589152646309,0.05171588446242682,-0.33881898331985655},
{-0.8111670389063068,0.03699262935452743,-0.32444517255787253},
{-0.7823390076081173,0.0253076613230489,-0.30641985625437745},
{-0.752570858295433,0.02461929353625652,-0.28944888493436455},
{-0.7533734530512127,0.01671884534570189,-0.28444920056151574},
{-0.7826403563881432,0.0208610759579284,-0.2998345211936117},
{-0.8120673277802994,0.03284739276943283,-0.31893597578388255},
{-0.8111670389063068,0.03699262935452743,-0.32444517255787253},
{-0.8111895837028175,0.03063950569782154,-0.3106620354644679},
{-0.7815709815403207,0.01823235268478466,-0.2908128451232599},
{-0.7516540365706659,0.009173853446798776,-0.26708820426186836},
{-0.7530127363070421,0.012137742694734426,-0.27676067345816135},
{-0.7242696237423761,0.006145335782199233,-0.2531915916926934},
{-0.7252916545175264,0.01069337273161773,-0.2618818592543384},
{-0.7259161453808718,0.01820078996966974,-0.26868212137517244},
{-0.7009470317520914,0.013600148495059675,-0.2503238935765366},
{-0.6829209639553794,0.01988338328258249,-0.245874302238548},
{-0.6875967547516916,0.03166003348653774,-0.2532735044533488},
{-0.6912580297050239,0.044468483877464514,-0.25923359715755206},
{-0.7079877717023726,0.05228927378701479,-0.2669506810031533},
{-0.7251826880010581,0.060952487592846966,-0.27690946911513176},
{0.6585357605562253,0.06218643945519748,-0.25910283733779016},
{0.6521901518316896,0.07193180349354165,-0.2587744348019515},
{0.6441980214686582,0.08111129313946809,-0.2580003967884186},
{0.656260990588299,0.08902902567401423,-0.2603916482049833},
{0.6645973048447265,0.07958050145639387,-0.2615609716506699},
{0.6714659528483096,0.06982236203336027,-0.26215164531924934},
{0.6760643398432685,0.05962760505123682,-0.2616301090266359},
{0.6625276925250473,0.05205405641008683,-0.2585512413164959},
{0.6634587926209379,0.041713509743861045,-0.25668453216541265},
{0.6510433731825137,0.03587966790011751,-0.25397013866552837},
{0.66062416020633,0.031345157828605426,-0.2530698497915358},
{0.6481080406768249,0.02639657499451408,-0.2515623543981892},
{0.6556184638877449,0.0216020482699123,-0.24789882496520585},
{0.6435720276188788,0.018018928611150346,-0.24781991817741855},
{0.6383837184485572,0.022761602303777603,-0.24906213646515624},
{0.6345217948062801,0.015395465790525748,-0.24674603437029377},
{0.6849454866820373,0.07876062235662257,-0.2654228952929471},
{0.6775891195806067,0.04887223412921472,-0.2594628025887438},
{0.6752384487977612,0.037427743927183295,-0.2551169173147043},
{0.6704852542000956,0.026190665853049997,-0.2489990110349264},
{0.6775891195806067,0.08857061481163067,-0.2644279182736097},
{0.6903750251750228,0.09866091423658813,-0.26798248119012474},
{0.6981146538171347,0.08876525155483944,-0.26955911395943744},
{0.6689259057747744,0.09824834446044291,-0.2627881600740672},
{0.6814420253042797,0.10847691863733233,-0.26580390235397733},
{0.6937341998551121,0.11944796811263979,-0.26929834581313067},
{0.7028738603605363,0.10957184425453374,-0.272013490806232},
{0.7109216012216274,0.09958149342744028,-0.27424317118113695},
{0.7175452624364612,0.08867958132809894,-0.27587766892816024},
{0.7224104295234631,0.07606877365324897,-0.27680350857153163},
{0.7251826880010581,0.060952487592846966,-0.27690946911513176},
{0.726359526378915,0.04509372623402701,-0.275833330828356},
{0.7264384331667022,0.0302554926639232,-0.2732113709941654},
{0.7306693399785373,0.09978514808925333,-0.2818805967457338},
{0.7233137243703238,0.11095384028063764,-0.2791571853272452},
{0.7433748357987321,0.11128600028256141,-0.2876595795846347},
{0.7352361642583815,0.12262678442064384,-0.2839817717805279},
{0.7370908495179923,0.08660921751520267,-0.28467840599270755},
{0.742594785839463,0.07052125072519093,-0.28775126175711135},
{0.7470781943722177,0.05350443831893971,-0.2901823423141783},
{0.750438120545524,0.0375427223893877,-0.29105407444592407},
{0.7514932170222232,0.09774935296434015,-0.29220085309509997},
{0.7599790784288382,0.08105944010749357,-0.2981173591927159},
{0.7680689029100823,0.06334298751619465,-0.3039542070093275},
{0.7750006763438952,0.04672747248783332,-0.3082542511971287},
{0.7150059668561431,0.12102159490908436,-0.276307523048297},
{0.7266901833944047,0.13272910773707358,-0.2806534083223365},
{0.7466370678538256,0.13434632114010536,-0.28839904891018453},
{0.7556211692633262,0.12299426460376768,-0.2927051050437219},
{0.7057287830920038,0.1308947127943223,-0.273130961219944},
{0.7173506256932526,0.142550372590337,-0.27716197083605126},
{0.728525329830373,0.15414967039507502,-0.2812500939366521},
{0.7378476031875336,0.14441407576855206,-0.28483922554115026},
{0.7577185868320352,0.14575398817450275,-0.2924210406076875},
{0.7674955135854943,0.13453569743079496,-0.2970742866074891},
{0.7655288558365473,0.1094057642535718,-0.29853068046207815},
{0.7791023263224027,0.12121923762516121,-0.3037881270083656},
{0.777087573007566,0.0926294296767677,-0.3066490616855692},
{0.7935708252297315,0.10492761617333643,-0.31354025448566303},
{0.7888634717183043,0.07483331880446446,-0.3151800126852055},
{0.8088306464945847,0.08774622675255729,-0.32412578794063807},
{0.8090801422426361,0.11765039633752267,-0.3189870773226401},
{0.8273354154705399,0.10185476040893256,-0.331056058388017},
{0.8228114263040662,0.07175971154684355,-0.3333383432881135},
{0.8442605457043145,0.08730885770025038,-0.34185200994375825},
{-0.7306693399785373,0.09978514808925333,-0.2818805967457338},
{-0.7433748357987321,0.11128600028256141,-0.2876595795846347},
{-0.7370908495179923,0.08660921751520267,-0.28467840599270755},
{-0.7514932170222232,0.09774935296434015,-0.29220085309509997},
{0.7487412488614877,0.15575485990663449,-0.28885219932004896},
{0.7395332024733144,0.16541530521145514,-0.2853893185760106},
{0.7290641504669779,0.1756153226460978,-0.28105470570022634},
{0.740462048089554,0.18615351202840047,-0.28561852400720233},
{0.7506560535784604,0.17607373350848138,-0.2895743843016073},
{0.759634894535442,0.16643057254765214,-0.2926825602472112},
{0.7994249573903346,0.05818323508812012,-0.3222440489252144},
{0.7686821213751724,0.15649432923218434,-0.2960590192712921},
{0.77908278749876,0.14553755812800032,-0.30082348626721295},
{0.7921204433208786,0.13283281380102263,-0.3080934316486859},
{0.8044870157001963,0.14388652753020248,-0.3115683362841967},
{0.7797305746518332,0.16620963354184762,-0.2993242572992536},
{0.7904694127230808,0.15562860904617473,-0.30401132049382124},
{0.8017410594851971,0.16443535805645818,-0.30669490277180755},
{0.770792314328571,0.17612032608793676,-0.2963175329379477},
{0.7824765308668323,0.18450248143060263,-0.2997458449940031},
{0.7910653468441795,0.17454294182540706,-0.30222877858304453},
{0.8031959503533521,0.182048856077025,-0.3058021288299852},
{0.762174941608977,0.18584990876872343,-0.29380003066092325},
{0.7743694220415966,0.19446728148831727,-0.2980602457082222},
{0.7874581794024726,0.2023865170092975,-0.30304865768281575},
{0.7951151437907121,0.192124125637642,-0.30389709352483385},
{0.8091334982610446,0.19953159427783007,-0.3096993726534624},
{0.8166303945940583,0.1892804753044299,-0.3110761082270471},
{0.8321667653627758,0.19653989978086459,-0.3190967953323253},
{0.8392683762636358,0.18690275076577154,-0.3217089857546946},
{0.8450360867042814,0.1799454265625798,-0.3250335917468009},
{0.8590604531203502,0.18032042167787393,-0.3332444066359857},
{0.8751611952950513,0.16537622756417003,-0.3442207165638123},
{0.8016568922448906,0.2100697836601327,-0.3094581433307983},
{0.8171834936017868,0.21797624379642352,-0.31798383387791546},
{0.8249576909318816,0.20727197441315895,-0.3180815279961283},
{0.8430145699504916,0.2158908501191868,-0.32997240516907095},
{0.850602396962765,0.2041262238067039,-0.3309132746767828},
{0.8567947010710282,0.19230222953007622,-0.33249817387148267},
{0.8757345846196393,0.19718543245428663,-0.344885788060877},
{0.8780146150400847,0.1815506160741393,-0.345055625527924},
{0.895104322288387,0.16399949199058528,-0.3565068791689086},
{-0.8091334982610446,0.19953159427783007,-0.3096993726534624},
{-0.8016568922448906,0.2100697836601327,-0.3094581433307983},
{-0.793110159887697,0.2201104845327666,-0.3094235746428153},
{-0.7787025319309469,0.21256549263386343,-0.3021536292613423},
{-0.7697281999332674,0.22226651857240337,-0.3007047503389234},
{-0.8249576909318816,0.20727197441315895,-0.3180815279961283},
{-0.8171834936017868,0.21797624379642352,-0.31798383387791546},
{-0.8083842595236735,0.227529977064427,-0.31812736908236666},
{-0.8002110192953399,0.23623001403789326,-0.31839414917440956},
{-0.7846077656303074,0.22950790721162947,-0.3091312437813936},
{-0.7772634224203493,0.238114007532968,-0.3081167279384136},
{0.7943148035145836,0.2443746975239801,-0.3186661897189716},
{0.7846077656303074,0.22950790721162947,-0.3091312437813936},
{0.8002110192953399,0.23623001403789326,-0.31839414917440956},
{0.793110159887697,0.2201104845327666,-0.3094235746428153},
{0.7787025319309469,0.21256549263386343,-0.3021536292613423},
{0.7651388308569126,0.20459214960125774,-0.29598462144280685},
{0.7523987663487349,0.19588910665492332,-0.29058363969206813},
{0.7179412993618319,0.16450374393920716,-0.27685761608315723},
{0.707156620204346,0.17473231811609669,-0.27157762474035907},
{0.6972316492871335,0.18408916016124036,-0.2653221952018661},
{0.696163025932528,0.16342610266599736,-0.26801404390523975},
{0.6863845961926348,0.17288665077509008,-0.2620885198890195},
{0.6757659970361107,0.16143088817480328,-0.2596348945354419},
{0.6651015567933485,0.14978048883130782,-0.25781703244346516},
{0.6541162289469176,0.13799256622909722,-0.25649290139507197},
{0.6425349669793881,0.12612423385266522,-0.25551821469259417},
{0.6300819728801128,0.11423335667972256,-0.2547501886247975},
{0.618387235436813,0.1033622558022791,-0.25368006228375783},
{0.8083842595236735,0.227529977064427,-0.31812736908236666},
{0.8245451211557365,0.23512456751565355,-0.32859642108870324},
{0.8342536620264466,0.22656656276020454,-0.3293186060702616},
{0.8386551577985457,0.24282436701726334,-0.33864689137315845},
{0.8503559071875818,0.2353815781958752,-0.3410524211608466},
{0.8477767824667615,0.250558735206856,-0.3460949406470657},
{0.862977987260687,0.2439621277478349,-0.35077373741624607},
{-0.7943148035145836,0.2443746975239801,-0.3186661897189716},
{0.7068297206549414,0.1530487328321374,-0.27299343796122894},
{0.6954663917203483,0.1414787432628633,-0.2694276026464585},
{0.6851634197149736,0.15193652287094458,-0.26499529565246144},
{0.6740172723201001,0.14039884751000234,-0.2624755388957859},
{0.662584806009541,0.1289505998418858,-0.2604089325489748},
{0.6507254915517132,0.11772780013887593,-0.25874888403257273},
{0.6382980482218168,0.10686571718003675,-0.2574503037535583},
{0.6263440456186443,0.09703017395564989,-0.25593604492125854},
{0.6838385371733635,0.130005696318585,-0.26621121167760337},
{0.6719363876021656,0.11884301607293694,-0.26339611808663815},
{0.659746416128848,0.10820187211990222,-0.2610334234123203},
{0.6472596048348068,0.09829418554668125,-0.25917573217984136},
{0.6352650215979151,0.08954530151410849,-0.2572150863766303},
{-0.726359526378915,0.04509372623402701,-0.275833330828356},
{-0.706376570245077,0.03788690628278389,-0.2628738303008077},
{-0.7264384331667022,0.0302554926639232,-0.2732113709941654},
{-0.7036989999128268,0.02449379416901383,-0.25729549615085173},
{-0.742594785839463,0.07052125072519093,-0.28775126175711135},
{-0.7599790784288382,0.08105944010749357,-0.2981173591927159},
{-0.777087573007566,0.0926294296767677,-0.3066490616855692},
{0.8970078546071044,0.18380284124555493,-0.3569885863210199},
{0.8940033847254494,0.20243611556162097,-0.35687360785881544},
{0.8868348909282745,0.2191643545725356,-0.35594476224257604},
{0.8762448485139973,0.23325184641883423,-0.353984116439365},
{0.832206594503278,0.2590408391473858,-0.3406135491221056},
{0.8309087657174806,0.25266892816025444,-0.3392608613314656},
{0.8126422200913215,0.24991695999951904,-0.3295823801894364},
{0.8609083749410078,0.2247607245597001,-0.3427981399039892},
{0.8696039029551719,0.21176139489164972,-0.3440283343002546},
{-0.850602396962765,0.2041262238067039,-0.3309132746767828},
{-0.8696039029551719,0.21176139489164972,-0.3440283343002546},
{-0.8868348909282745,0.2191643545725356,-0.35594476224257604},
{-0.8762448485139973,0.23325184641883423,-0.353984116439365},
{-0.8609083749410078,0.2247607245597001,-0.3427981399039892},
{-0.8430145699504916,0.2158908501191868,-0.32997240516907095},
{-0.8503559071875818,0.2353815781958752,-0.3410524211608466},
{-0.8342536620264466,0.22656656276020454,-0.3293186060702616},
{-0.862977987260687,0.2439621277478349,-0.35077373741624607},
{-0.8477767824667615,0.250558735206856,-0.3460949406470657},
{-0.8386551577985457,0.24282436701726334,-0.33864689137315845},
{-0.8245451211557365,0.23512456751565355,-0.32859642108870324},
{0.8164778414710029,0.24257261678956082,-0.32846490977572435},
{0.8288008272437334,0.24629626567990598,-0.33569051705739306},
{-0.8288008272437334,0.24629626567990598,-0.33569051705739306},
{-0.8309087657174806,0.25266892816025444,-0.3392608613314656},
{-0.832206594503278,0.2590408391473858,-0.3406135491221056},
{-0.8126422200913215,0.24991695999951904,-0.3295823801894364},
{-0.8164778414710029,0.24257261678956082,-0.32846490977572435},
{0.7318161186277133,-0.06008601591362037,-0.25814393199286984},
{0.6849454866820373,-0.0701883392300501,-0.22931665218789735},
{0.6856774410754168,-0.0641410733126723,-0.2557316387662285},
{0.7326014290395015,-0.054215350902242776,-0.28306720453541184},
{0.687611033122815,-0.04455415410420505,-0.2825050876090793},
{0.6439567921459941,-0.049330644991598324,-0.2602999660325066},
{0.6409643461558117,-0.06915052709734244,-0.2316898677672535},
{0.6400122042498445,-0.07563516206702721,-0.20379068208530352},
{0.7794495161886669,-0.04506441799856317,-0.2861115035575689},
{0.7806451418969492,-0.039320003847645266,-0.30943259256141953},
{0.7337654920326689,-0.03485914011140135,-0.3079792046796986},
{0.6905869462622231,-0.006613516056404109,-0.3056886533542148},
{0.6487843845721448,-0.011661295995142361,-0.28544643206050424},
{0.6106055231745479,-0.011976923146291677,-0.27256358384109225},
{0.6037887282029393,-0.049043574582695836,-0.2456338244091009},
{0.5995510579521509,-0.06929706827466178,-0.2152066155450881},
{0.5981923582157748,-0.07669025854372642,-0.18573079709382542},
{0.7814334582816056,-0.020387635231204425,-0.33244932681237616},
{0.735152748511292,0.002912411962569608,-0.32914726561678054},
{0.7816220830790781,0.016661731861208187,-0.3516792867427579},
{0.736609142365881,0.06403135530298702,-0.3428387205377084},
{0.6944458639316322,0.05449640936540904,-0.3213324876529664},
{-0.6487843845721448,-0.011661295995142361,-0.28544643206050424},
{-0.6905869462622231,-0.006613516056404109,-0.3056886533542148},
{-0.735152748511292,0.002912411962569608,-0.32914726561678054},
{-0.7816220830790781,0.016661731861208187,-0.3516792867427579},
{-0.8291352417253083,0.03437818445250711,-0.36914323761313733},
{-0.8750439623531958,0.05567475072969989,-0.3818848051077491},
{-0.9167007343591717,0.08016516317923711,-0.39025042759964046},
{-0.9524770719419487,0.08204539920822672,-0.3809845162337564},
{-0.9514565441532326,0.10746240279435236,-0.3945842889822076},
{-0.977879797156951,0.11790289805844215,-0.38248299370849875},
{-0.9766646326250259,0.13717869907506214,-0.3952343306149319},
{-0.9467589600536267,0.1499751255745166,-0.4037660331077852},
{-0.9715807810118706,0.17010011392637173,-0.40419363274827086},
{-0.6106055231745479,-0.011976923146291677,-0.27256358384109225},
{-0.619704603046253,0.04585649184930455,-0.2915470539962906},
{-0.6552404627995828,0.048367230687375785,-0.302956224017122},
{-0.6944458639316322,0.05449640936540904,-0.3213324876529664},
{-0.736609142365881,0.06403135530298702,-0.3428387205377084},
{-0.7810201370122433,0.07675939591969241,-0.36363930129166655},
{-0.8269679352874161,0.09246936162154203,-0.3798993600283763},
{-0.8717253683068257,0.11040900769829655,-0.3918518596451148},
{-0.9125645156926814,0.12982834391936773,-0.3997297630391588},
{0.8745352014452717,0.005458470981840902,-0.34671191657824096},
{0.9158177298291705,0.035180779208286855,-0.35813160750411066},
{0.8287166600034268,-0.01940167613047124,-0.3305630788376504},
{0.8266703439734753,-0.024859771365703665,-0.30905684595290844},
{0.8296282212756748,-0.0012839261612824695,-0.3516447180547749},
{0.875860835480099,0.022274634699147176,-0.36590580483420554},
{0.8745352014452717,0.005458470981840902,-0.34671191657824096},
{0.8287166600034268,-0.01940167613047124,-0.3305630788376504},
{0.8291352417253083,0.03437818445250711,-0.36914323761313733},
{0.8750439623531958,0.05567475072969989,-0.3818848051077491},
{0.9158177298291705,0.035180779208286855,-0.35813160750411066},
{0.9176408523736665,0.050110694950867375,-0.3755722620847624},
{0.9167007343591717,0.08016516317923711,-0.39025042759964046},
{0.8717253683068257,0.11040900769829655,-0.3918518596451148},
{0.8269679352874161,0.09246936162154203,-0.3798993600283763},
{0.7810201370122433,0.07675939591969241,-0.36363930129166655},
{0.9524770719419487,0.08204539920822672,-0.3809845162337564},
{0.9524770719419487,0.08204539920822672,-0.3809845162337564},
{0.9514565441532326,0.10746240279435236,-0.3945842889822076},
{0.9125645156926814,0.12982834391936773,-0.3997297630391588},
{-0.9158177298291705,0.035180779208286855,-0.35813160750411066},
{-0.9453296199548503,0.06633618499959422,-0.3489618872700055},
{0.9947974124585551,0.19404268782069975,-0.3533881823182664},
{0.994281136618461,0.2366651286105491,-0.35263142864872504},
{0.9766646326250259,0.13717869907506214,-0.3952343306149319},
{-0.9756441048363097,0.10888948841347755,-0.3677943072885824},
{-0.991986076333675,0.15074766060161535,-0.367780780410676},
{-0.9937528368868942,0.1558270032554686,-0.38144443008257406},
{-0.999389036014561,0.19320853034980506,-0.3665257867382489},
{-0.9947974124585551,0.19404268782069975,-0.3533881823182664},
{-0.986845111236026,0.15003299055222727,-0.3540074127290927},
{-0.9703731314121159,0.10675675066356848,-0.35302070213514253},
{-0.9919770584150708,0.1688143090320467,-0.3933834028214061},
{-1.0,0.19396378103291242,-0.37924556092956707},
{-0.998377526144449,0.23067572767088207,-0.3781536412852338},
{-0.9983955619816576,0.23427913764650363,-0.36574273080611175},
{-0.994281136618461,0.2366651286105491,-0.35263142864872504},
{-0.9970473831503196,0.20187099266242017,-0.3902173618980915},
{-0.9957848745457224,0.22730753507218845,-0.38678378938951696},
{-0.9904883503521498,0.24909106895401165,-0.39134084425753973},
{-0.9906431579548564,0.26432458795626906,-0.3804381806649813},
{-0.989550486817306,0.27196351650729994,-0.3671450171490752},
{-0.9853488882409348,0.2757788475701219,-0.35320406648009595},
{0.9214479170111011,0.3487826561377457,-0.3654301096278305},
{0.8876660424263011,0.35711295844843705,-0.35698482885493477},
{0.8910372409978627,0.33758540720411456,-0.3763748568405422},
{0.9251400031863313,0.33132396571988537,-0.3831751189613762},
{0.9538455410901461,0.31611900345987476,-0.38502905272777005},
{0.957125057489231,0.29105219571288143,-0.398250072894842},
{0.9778384650300146,0.2737167501826128,-0.395749103468592},
{0.9795646449495147,0.24374870367420062,-0.40328658043532506},
{0.9780443741714788,0.21613433392150197,-0.4050548439749782},
{0.9864904064375916,0.1932543714360434,-0.4019857456766595},
{0.9653659321070968,0.21083555524827835,-0.4082013460746504},
{0.9715807810118706,0.17010011392637173,-0.40419363274827086},
{0.940417860288393,0.20173948134944136,-0.4077188874293221},
{0.9467589600536267,0.1499751255745166,-0.4037660331077852},
{0.9067163954778145,0.18980576906312843,-0.4034849746446188},
{0.8669496289126495,0.17620148735537516,-0.39549058980193647},
{0.8238033973505355,0.16209595967186796,-0.38372896946232166},
{0.7799657920287612,0.14865700647185956,-0.36819184720038717},
{0.7381226497049638,0.13705244821460244,-0.3488702050975288},
{0.6988255664004377,0.12736570064718591,-0.329163046974338},
{0.6626246351500431,0.11968017951669965,-0.3124686251581893},
{0.6552404627995828,0.048367230687375785,-0.302956224017122},
{0.9292566830291791,0.30094860988784716,-0.3974685199491389},
{0.9344660340095771,0.2549091294401976,-0.4056349967385194},
{0.9607562727138824,0.25355569015634066,-0.40609716506698806},
{-0.9733610684429963,0.30466474384602205,-0.36880732014512835},
{-0.9760484081870677,0.2933314746401099,-0.38357115588674695},
{-0.9778384650300146,0.2737167501826128,-0.395749103468592},
{-0.9795646449495147,0.24374870367420062,-0.40328658043532506},
{-0.9909490156941844,0.22249346952394408,-0.3981117981429099},
{-0.9864904064375916,0.1932543714360434,-0.4019857456766595},
{-0.9689452942997737,0.3097839156403774,-0.35350842123299},
{-0.9503368192598695,0.33078514508328044,-0.36880356267904324},
{-0.9460172362484257,0.3370804037622756,-0.35194306086193267},
{-0.9214479170111011,0.3487826561377457,-0.3654301096278305},
{-0.9175108440471217,0.3560698858632102,-0.3469088078011008},
{-0.8876660424263011,0.35711295844843705,-0.35698482885493477},
{-0.8510337540693358,0.35785167628076986,-0.3446738669736767},
{-0.8135921075176377,0.3530714279272915,-0.329703370597377},
{-0.7773829098418558,0.3448463346669833,-0.31327948633935626},
{-0.7773393232352684,0.35376505616660303,-0.28985018231225446},
{-0.7458517574420374,0.3440294615400801,-0.2732346672838931},
{-0.9538455410901461,0.31611900345987476,-0.38502905272777005},
{-0.957125057489231,0.29105219571288143,-0.398250072894842},
{-0.9292566830291791,0.30094860988784716,-0.3974685199491389},
{-0.9251400031863313,0.33132396571988537,-0.3831751189613762},
{-0.8910372409978627,0.33758540720411456,-0.3763748568405422},
{-0.8536497019577901,0.33689703941732224,-0.3656022015745286},
{-0.8150883305127288,0.3312555798371364,-0.35182808239972824},
{-0.7774655740957283,0.32265549146153405,-0.336027186018619},
{-0.7428931286466208,0.31309198878170924,-0.3191704416675935},
{-0.7444464651262058,0.3352512692720436,-0.2966098637993693},
{-0.7147880338232068,0.32425466902735733,-0.2809705384599198},
{-0.7177000700391678,0.3328089163167213,-0.25790871461594184},
{-0.6884083674260757,0.3118249712178098,-0.2676382972967286},
{-0.692782809442362,0.3202011146147395,-0.24472752358937205},
{-0.6653112234008975,0.29792986163506885,-0.25789143027195033},
{-0.6709955180944537,0.30630375055234754,-0.23454554199193797},
{-0.652235992917928,0.29121301526132426,-0.2282157146249598},
{-0.6454988562273237,0.28253852905723675,-0.2530067243613059},
{-0.6365523294786741,0.2789666817967301,-0.2229056635534808},
{-0.6289269278055496,0.27025236645214035,-0.2507484872441541},
{-0.6239926233425818,0.27359951724075743,-0.21578376233576116},
{-0.6155503485425541,0.265672766787607,-0.2488802751066369},
{-0.61926873698038,0.25098934082020974,-0.27797283201721823},
{-0.6038217939044882,0.24721308740467307,-0.28221050226800654},
{0.8510337540693358,0.35785167628076986,-0.3446738669736767},
{0.8135921075176377,0.3530714279272915,-0.329703370597377},
{0.7773829098418558,0.3448463346669833,-0.31327948633935626},
{0.7774655740957283,0.32265549146153405,-0.336027186018619},
{0.8150883305127288,0.3312555798371364,-0.35182808239972824},
{0.8536497019577901,0.33689703941732224,-0.3656022015745286},
{0.8570351789004753,0.29979055884041594,-0.38260473560965635},
{0.8951426484424552,0.3032534395844543,-0.3920277090578981},
{0.9006390698317558,0.25080372199560524,-0.40099076865732214},
{0.8171872510678718,0.2923823387070108,-0.36987744648616805},
{0.861760568249111,0.24277702294459091,-0.39248837439993267},
{0.7778495871296266,0.282853404715169,-0.35452293707597},
{0.8203172203167695,0.23236508442274795,-0.38044945306323663},
{-0.8570351789004753,0.29979055884041594,-0.38260473560965635},
{-0.8951426484424552,0.3032534395844543,-0.3920277090578981},
{-0.9006390698317558,0.25080372199560524,-0.40099076865732214},
{-0.861760568249111,0.24277702294459091,-0.39248837439993267},
{-0.8171872510678718,0.2923823387070108,-0.36987744648616805},
{-0.7778495871296266,0.282853404715169,-0.35452293707597},
{-0.7412759152435889,0.27302687940938647,-0.33721980575403326},
{-0.711485221134394,0.30243356048468306,-0.3030366337913434},
{-0.6833568300212522,0.2905479437642596,-0.2894030438481262},
{-0.6586229337693997,0.27730362730745994,-0.2800454503097655},
{-0.6373977593478242,0.26256909980130516,-0.27674338911416985},
{-0.9344660340095771,0.2549091294401976,-0.4056349967385194},
{-0.940417860288393,0.20173948134944136,-0.4077188874293221},
{-0.9067163954778145,0.18980576906312843,-0.4034849746446188},
{-0.8669496289126495,0.17620148735537516,-0.39549058980193647},
{-0.8203172203167695,0.23236508442274795,-0.38044945306323663},
{-0.7787957170898575,0.22110471005888696,-0.3651986497169877},
{-0.7396819981302849,0.2105319519886013,-0.34705835495128823},
{-0.7077067132392063,0.26274344622765433,-0.32028866357452257},
{-0.6773824589459255,0.25184754607404913,-0.3060523760712536},
{-0.6505443816864109,0.24017986238656208,-0.29683305728482495},
{-0.6274329592901094,0.22758333308283554,-0.29495282125583533},
{-0.61926873698038,0.25098934082020974,-0.27797283201721823},
{-0.6071824715710116,0.21798901918111285,-0.2993310207382068},
{-0.6038217939044882,0.24721308740467307,-0.28221050226800654},
{0.7147880338232068,0.32425466902735733,-0.2809705384599198},
{0.6884083674260757,0.3118249712178098,-0.2676382972967286},
{0.6833568300212522,0.2905479437642596,-0.2894030438481262},
{0.711485221134394,0.30243356048468306,-0.3030366337913434},
{0.7444464651262058,0.3352512692720436,-0.2966098637993693},
{0.7412759152435889,0.27302687940938647,-0.33721980575403326},
{0.7077067132392063,0.26274344622765433,-0.32028866357452257},
{0.7428931286466208,0.31309198878170924,-0.3191704416675935},
{0.7787957170898575,0.22110471005888696,-0.3651986497169877},
{0.6773824589459255,0.25184754607404913,-0.3060523760712536},
{0.703366839910903,0.20058443627487818,-0.3289060362941164},
{0.7396819981302849,0.2105319519886013,-0.34705835495128823},
{0.6586229337693997,0.27730362730745994,-0.2800454503097655},
{0.6505443816864109,0.24017986238656208,-0.29683305728482495},
{0.6702387644249123,0.19119903748748765,-0.3136206642598844},
{0.5769100703097053,-0.007304138322847492,-0.27118158781498836},
{0.5680920489011666,-0.0435509106594804,-0.24277815018441642},
{0.5625302476019852,-0.06463254987660483,-0.21054510311989924},
{0.5606612839712509,-0.07361740277932254,-0.1792980151561152},
{0.6406885481451645,0.18231187870298285,-0.30408045786978727},
{-0.6988255664004377,0.12736570064718591,-0.329163046974338},
{-0.6626246351500431,0.11968017951669965,-0.3124686251581893},
{-0.6300707004818574,0.11407854907701603,-0.3021851919764572},
{-0.6017131039375239,0.11064422507522442,-0.30171250274295025},
{-0.5885491972549456,0.047174610951961515,-0.29093909598371964},
{-0.5761420442419086,0.10968306525065306,-0.30924997970968315},
{-0.5603749650555654,0.05133187142852848,-0.298897409151985},
{-0.5337833775712341,0.057334799246102,-0.3131847981940115},
{-0.5464137240697265,0.0005880434423198624,-0.27873860360536384},
{-0.5769100703097053,-0.007304138322847492,-0.27118158781498836},
{-0.7381226497049638,0.13705244821460244,-0.3488702050975288},
{-0.7799657920287612,0.14865700647185956,-0.36819184720038717},
{-0.703366839910903,0.20058443627487818,-0.3289060362941164},
{-0.8238033973505355,0.16209595967186796,-0.38372896946232166},
{-0.6702387644249123,0.19119903748748765,-0.3136206642598844},
{-0.6406885481451645,0.18231187870298285,-0.30408045786978727},
{-0.6151062160512939,0.1738613374775679,-0.30316288465180313},
{-0.6071824715710116,0.21798901918111285,-0.2993310207382068},
{-0.5922751006249418,0.16806131282859038,-0.30957537627265375},
{-0.9780443741714788,0.21613433392150197,-0.4050548439749782},
{-0.9653659321070968,0.21083555524827835,-0.4082013460746504},
{-0.9607562727138824,0.25355569015634066,-0.40609716506698806},
{0.6155503485425541,0.265672766787607,-0.2488802751066369},
{0.61926873698038,0.25098934082020974,-0.27797283201721823},
{0.6038217939044882,0.24721308740467307,-0.28221050226800654},
{0.6058989211563376,0.27467264955466514,-0.2446734160777465},
{0.6155503485425541,0.265672766787607,-0.2488802751066369},
{0.6038217939044882,0.24721308740467307,-0.28221050226800654},
{0.6071824715710116,0.21798901918111285,-0.2993310207382068},
{0.61926873698038,0.25098934082020974,-0.27797283201721823},
{0.6274329592901094,0.22758333308283554,-0.29495282125583533},
{0.6373977593478242,0.26256909980130516,-0.27674338911416985},
{0.6239926233425818,0.27359951724075743,-0.21578376233576116},
{0.6239926233425818,0.27359951724075743,-0.21578376233576116},
{0.6145035184912422,0.2818103321299422,-0.20649455468014946},
{-0.6058989211563376,0.27467264955466514,-0.2446734160777465},
{-0.6155503485425541,0.265672766787607,-0.2488802751066369},
{-0.6239926233425818,0.27359951724075743,-0.21578376233576116},
{-0.6145035184912422,0.2818103321299422,-0.20649455468014946},
{0.6071824715710116,0.21798901918111285,-0.2993310207382068},
{0.5464137240697265,0.0005880434423198624,-0.27873860360536384},
{0.5356981822882066,-0.03496810662786958,-0.24899375058240725},
{0.5288295342846235,-0.05733479924610204,-0.2145340291158532},
{0.526410477619029,-0.0685102548764395,-0.1802321212248738},
{0.5054370534251558,-0.02541061589378094,-0.2615384268541592},
{0.4973757856861584,-0.04957863775321565,-0.22400134066389915},
{0.4944299322754313,-0.06346397792413529,-0.18427440323923636},
{0.4959554635059864,-0.05542901244773365,-0.12370630442689623}
};


// texture array: 77kb.
const tgx::fVec2 suzanne_tex_array[9906] PROGMEM = {
{0.9821,0.7577},
{0.9845,0.763},
{0.98,0.766},
{0.9773,0.76},
{0.9748,0.7695},
{0.9784,0.7753},
{0.9832,0.7712},
{0.9873,0.7675},
{0.9881,0.7606},
{0.9859,0.7558},
{0.9842,0.7506},
{0.9802,0.7519},
{0.9751,0.7535},
{0.9717,0.7627},
{0.969,0.773},
{0.973,0.7796},
{0.9774,0.7849},
{0.9824,0.7801},
{0.9867,0.7754},
{0.9905,0.7713},
{0.9906,0.7647},
{0.9906,0.7592},
{0.9885,0.7547},
{0.9869,0.7497},
{0.983,0.745},
{0.9789,0.7457},
{0.9736,0.7466},
{0.9676,0.7477},
{0.9692,0.7554},
{0.9655,0.7655},
{0.9629,0.7764},
{0.9672,0.7835},
{0.972,0.7893},
{0.5731,0.9205},
{0.5696,0.9258},
{0.5643,0.9236},
{0.567,0.918},
{0.5587,0.9228},
{0.557,0.9278},
{0.5619,0.9285},
{0.5666,0.9304},
{0.5747,0.9293},
{0.5788,0.9244},
{0.5831,0.9193},
{0.5768,0.915},
{0.57,0.9123},
{0.5806,0.9097},
{0.5732,0.9067},
{0.5599,0.9323},
{0.5642,0.934},
{0.571,0.9335},
{0.5791,0.934},
{0.5838,0.9297},
{0.5888,0.9252},
{0.5937,0.9208},
{0.5875,0.9144},
{0.5919,0.9097},
{0.5844,0.9046},
{0.5962,0.905},
{0.5883,0.8996},
{0.6006,0.9003},
{0.5922,0.8946},
{0.1885,0.951},
{0.1845,0.9511},
{0.1846,0.9441},
{0.1886,0.9448},
{0.1917,0.951},
{0.1918,0.9454},
{0.194,0.9509},
{0.194,0.9456},
{0.192,0.94},
{0.1943,0.9406},
{0.1957,0.9458},
{0.1959,0.9409},
{0.1946,0.936},
{0.1963,0.9364},
{0.1973,0.9412},
{0.1976,0.9369},
{0.5555,0.9316},
{0.1753,0.9342},
{0.1804,0.9358},
{0.1801,0.9433},
{0.1749,0.9426},
{0.1799,0.9512},
{0.9591,0.7682},
{0.9565,0.7796},
{0.9525,0.7709},
{0.9499,0.7828},
{0.9548,0.7909},
{0.9611,0.7873},
{0.9663,0.7935},
{0.9562,0.7594},
{0.9493,0.7613},
{0.9457,0.7734},
{0.9433,0.7858},
{0.9484,0.7944},
{0.9541,0.8014},
{0.9602,0.7975},
{0.9628,0.7574},
{0.9542,0.75},
{0.9472,0.7513},
{0.94,0.7526},
{0.9423,0.7633},
{0.9388,0.776},
{0.1583,0.9208},
{0.1644,0.9225},
{0.1639,0.9316},
{0.1578,0.9305},
{0.1635,0.9414},
{0.1694,0.9419},
{0.1697,0.9328},
{0.1703,0.9243},
{0.1521,0.9192},
{0.1515,0.9294},
{0.1574,0.9409},
{0.1634,0.9516},
{0.1692,0.9514},
{0.1748,0.9513},
{0.1512,0.9405},
{0.1573,0.9518},
{0.1511,0.952},
{0.1512,0.9635},
{0.1574,0.9627},
{0.9343,0.9206},
{0.926,0.9207},
{0.9252,0.9145},
{0.9341,0.9143},
{0.9242,0.9084},
{0.9143,0.9103},
{0.9159,0.9163},
{0.9174,0.9223},
{0.9268,0.927},
{0.9344,0.9269},
{0.9413,0.9283},
{0.9419,0.922},
{0.9423,0.9159},
{0.9337,0.9082},
{0.9232,0.9024},
{0.9127,0.9044},
{0.9021,0.9083},
{0.9043,0.914},
{0.9066,0.9197},
{0.9088,0.9255},
{0.9189,0.9285},
{0.9274,0.9335},
{0.9342,0.9334},
{0.9405,0.9346},
{0.9425,0.9099},
{0.9333,0.9022},
{0.9426,0.9039},
{0.614,0.9311},
{0.6085,0.9342},
{0.6041,0.9248},
{0.6093,0.9211},
{0.5985,0.9165},
{0.5989,0.9285},
{0.603,0.9372},
{0.6116,0.9442},
{0.6173,0.9419},
{0.6229,0.9396},
{0.6194,0.9281},
{0.6144,0.9175},
{0.6033,0.9123},
{0.5936,0.9322},
{0.5974,0.9402},
{0.6058,0.9465},
{0.6131,0.9546},
{0.6189,0.953},
{0.6246,0.9514},
{0.5882,0.936},
{0.5915,0.9432},
{0.6,0.9487},
{0.6072,0.9561},
{0.613,0.965},
{0.6188,0.9641},
{0.6246,0.9632},
{0.608,0.9081},
{0.9337,0.9451},
{0.9283,0.9453},
{0.9279,0.9398},
{0.934,0.9397},
{0.9203,0.9349},
{0.9215,0.941},
{0.9226,0.9464},
{0.9287,0.9496},
{0.9336,0.9494},
{0.9381,0.9502},
{0.9387,0.946},
{0.9396,0.9407},
{0.9152,0.9434},
{0.917,0.9485},
{0.9235,0.9506},
{0.9291,0.9521},
{0.9338,0.952},
{0.938,0.9527},
{0.9132,0.9375},
{0.9064,0.9413},
{0.9092,0.9468},
{0.9116,0.9515},
{0.9184,0.9525},
{0.9242,0.9532},
{0.9294,0.9537},
{0.934,0.9536},
{0.9381,0.9543},
{0.911,0.9314},
{0.9034,0.9357},
{0.8964,0.941},
{0.9001,0.9462},
{0.9036,0.951},
{0.9067,0.9553},
{0.9136,0.9553},
{0.9194,0.955},
{0.9247,0.9548},
{0.9296,0.9551},
{0.934,0.955},
{0.9379,0.9558},
{0.586,0.946},
{0.583,0.9396},
{0.575,0.9377},
{0.5784,0.9428},
{0.5811,0.9485},
{0.588,0.9529},
{0.5939,0.9509},
{0.6012,0.9575},
{0.6071,0.9657},
{0.6115,0.9749},
{0.6172,0.9747},
{0.6229,0.9744},
{0.5748,0.9452},
{0.5772,0.9504},
{0.5829,0.9546},
{0.589,0.9599},
{0.595,0.9588},
{0.6011,0.9663},
{0.6057,0.9749},
{0.6085,0.9839},
{0.614,0.9844},
{0.6195,0.9847},
{0.5718,0.9406},
{0.5697,0.9423},
{0.5726,0.9467},
{0.5749,0.9516},
{0.5789,0.956},
{0.5838,0.9609},
{0.5889,0.9669},
{0.5949,0.9667},
{0.5998,0.9747},
{0.6029,0.9833},
{0.604,0.9917},
{0.5987,0.9905},
{0.5972,0.9823},
{0.5934,0.9889},
{0.5914,0.981},
{0.588,0.9869},
{0.5858,0.9795},
{0.5828,0.9847},
{0.5836,0.9917},
{0.579,0.9889},
{0.5782,0.9828},
{0.5748,0.9865},
{0.5682,0.9368},
{0.5664,0.9386},
{0.5651,0.9398},
{0.5684,0.9433},
{0.5712,0.9476},
{0.5734,0.9524},
{0.5764,0.9569},
{0.5796,0.9616},
{0.5837,0.967},
{0.5879,0.9735},
{0.5937,0.9742},
{0.9092,0.9587},
{0.9148,0.9576},
{0.92,0.9566},
{0.9251,0.9561},
{0.9297,0.9569},
{0.9337,0.957},
{0.9373,0.9579},
{0.8987,0.956},
{0.9024,0.9597},
{0.9053,0.9627},
{0.9106,0.9609},
{0.9156,0.9591},
{0.9206,0.958},
{0.9254,0.958},
{0.9294,0.96},
{0.9328,0.9603},
{0.936,0.9613},
{0.939,0.9622},
{0.9406,0.9592},
{0.8947,0.9614},
{0.8988,0.9645},
{0.9021,0.967},
{0.907,0.9646},
{0.9116,0.9623},
{0.9163,0.9604},
{0.9212,0.9599},
{0.9258,0.9612},
{0.9291,0.963},
{0.9311,0.9644},
{0.9338,0.9659},
{0.9369,0.9663},
{0.9393,0.9663},
{0.9413,0.9638},
{0.9426,0.9666},
{0.9393,0.9691},
{0.935,0.9712},
{0.9395,0.9725},
{0.9345,0.9757},
{0.9366,0.9785},
{0.9407,0.9754},
{0.8945,0.9518},
{0.8899,0.9579},
{0.8865,0.9645},
{0.8916,0.9672},
{0.8962,0.9696},
{0.8997,0.9716},
{0.904,0.9687},
{0.9081,0.9659},
{0.9123,0.9634},
{0.9171,0.9621},
{0.922,0.963},
{0.9266,0.965},
{0.9282,0.969},
{0.9309,0.9716},
{0.8902,0.9473},
{0.885,0.9542},
{0.8812,0.9615},
{0.8787,0.9689},
{0.8843,0.9711},
{0.8897,0.9731},
{0.8945,0.9748},
{0.8982,0.9763},
{0.9017,0.973},
{0.9051,0.9699},
{0.909,0.967},
{0.9134,0.9648},
{0.9183,0.9648},
{0.9195,0.9684},
{0.9231,0.9672},
{0.9244,0.9724},
{0.9263,0.9804},
{0.5796,0.9672},
{0.5827,0.9729},
{0.5787,0.9725},
{0.5809,0.9782},
{0.9005,0.9301},
{0.8928,0.936},
{0.8893,0.931},
{0.8976,0.9247},
{0.8858,0.9261},
{0.8779,0.9339},
{0.8819,0.9384},
{0.886,0.9428},
{0.8947,0.9193},
{0.8823,0.9211},
{0.874,0.9294},
{0.8671,0.9386},
{0.8714,0.9425},
{0.8758,0.9465},
{0.8803,0.9503},
{0.8918,0.914},
{0.8761,0.9583},
{0.8735,0.9664},
{0.8685,0.9638},
{0.8713,0.955},
{0.8636,0.961},
{0.8666,0.9517},
{0.8588,0.9582},
{0.862,0.9483},
{0.8725,0.9745},
{0.8674,0.9725},
{0.8778,0.9763},
{0.8835,0.9778},
{0.889,0.979},
{0.8939,0.98},
{0.8976,0.9809},
{0.9003,0.9775},
{0.8806,0.3426},
{0.8851,0.3424},
{0.8853,0.3526},
{0.8807,0.3521},
{0.8785,0.9834},
{0.8732,0.9822},
{0.8841,0.9841},
{0.8895,0.9846},
{0.8944,0.985},
{0.8981,0.9855},
{0.896,0.9897},
{0.8996,0.9897},
{0.8907,0.3635},
{0.8858,0.3624},
{0.8901,0.3531},
{0.8899,0.3422},
{0.8853,0.3322},
{0.8807,0.3331},
{0.8765,0.3427},
{0.8766,0.334},
{0.8951,0.3535},
{0.8958,0.3646},
{0.8949,0.3421},
{0.8901,0.3314},
{0.8858,0.3224},
{0.8907,0.3209},
{0.8951,0.3305},
{0.8958,0.3194},
{0.9439,0.8547},
{0.9448,0.8641},
{0.9388,0.8656},
{0.9379,0.8555},
{0.9318,0.8563},
{0.9327,0.867},
{0.9401,0.8746},
{0.9461,0.8727},
{0.9519,0.8705},
{0.9507,0.8625},
{0.9498,0.8537},
{0.9493,0.8444},
{0.9434,0.8446},
{0.9374,0.8448},
{0.9313,0.845},
{0.9374,0.8339},
{0.9313,0.8334},
{0.9379,0.8231},
{0.9317,0.8219},
{0.9387,0.8129},
{0.9326,0.8111},
{0.9399,0.8037},
{0.9337,0.8014},
{0.9554,0.8526},
{0.9562,0.8607},
{0.9549,0.844},
{0.9493,0.8348},
{0.9435,0.8343},
{0.944,0.8242},
{0.9448,0.8147},
{0.9459,0.8061},
{0.9574,0.868},
{0.9624,0.8652},
{0.9614,0.8586},
{0.9606,0.8514},
{0.9602,0.8436},
{0.955,0.8353},
{0.9555,0.8267},
{0.9499,0.8254},
{0.9507,0.8166},
{0.9518,0.8086},
{0.9475,0.8799},
{0.9416,0.8824},
{0.934,0.8765},
{0.9355,0.8847},
{0.9654,0.8501},
{0.9661,0.8565},
{0.965,0.8432},
{0.9603,0.8357},
{0.9607,0.828},
{0.9615,0.8206},
{0.9563,0.8185},
{0.9573,0.8112},
{0.9702,0.8546},
{0.9696,0.8489},
{0.9692,0.8428},
{0.9651,0.8362},
{0.9655,0.8292},
{0.9662,0.8227},
{0.9697,0.8303},
{0.9702,0.8245},
{0.9735,0.8258},
{0.9741,0.8211},
{0.9709,0.8193},
{0.9735,0.8532},
{0.9729,0.848},
{0.9727,0.8425},
{0.9693,0.8365},
{0.9727,0.8368},
{0.973,0.8312},
{0.976,0.8265},
{0.9765,0.822},
{0.577,0.9773},
{0.5746,0.9814},
{0.5746,0.977},
{0.5723,0.9809},
{0.9742,0.8578},
{0.971,0.8598},
{0.9766,0.8568},
{0.9759,0.8524},
{0.9754,0.8476},
{0.9751,0.8424},
{0.7744,0.9805},
{0.7778,0.9773},
{0.7817,0.9806},
{0.7779,0.9843},
{0.7863,0.9843},
{0.7901,0.979},
{0.7852,0.9759},
{0.7809,0.9731},
{0.7775,0.971},
{0.7747,0.9748},
{0.7716,0.9777},
{0.8914,0.9898},
{0.8862,0.99},
{0.7835,0.9681},
{0.7881,0.9702},
{0.7799,0.9665},
{0.7774,0.9657},
{0.7751,0.9699},
{0.7725,0.9735},
{0.7912,0.9881},
{0.7954,0.9821},
{0.7933,0.9726},
{0.782,0.9885},
{0.7864,0.9927},
{0.7912,0.9964},
{0.7964,0.9914},
{0.801,0.9848},
{0.799,0.975},
{0.7959,0.9655},
{0.7904,0.9639},
{0.7856,0.9625},
{0.7818,0.9615},
{0.7793,0.961},
{0.7775,0.9607},
{0.7757,0.9653},
{0.7734,0.9694},
{0.7741,0.9649},
{0.772,0.969},
{0.7709,0.973},
{0.7695,0.9725},
{0.7704,0.9681},
{0.7682,0.9714},
{0.7667,0.9751},
{0.7655,0.9738},
{0.7774,0.9913},
{0.7813,0.9958},
{0.7379,0.9917},
{0.7409,0.996},
{0.7358,0.9987},
{0.7325,0.9938},
{0.7357,0.9863},
{0.73,0.9877},
{0.7267,0.9957},
{0.724,0.9889},
{0.7208,0.9972},
{0.7177,0.9898},
{0.7146,0.9984},
{0.7114,0.9903},
{0.7084,0.9992},
{0.7049,0.9906},
{0.7022,1.0},
{0.6984,0.9908},
{0.7026,0.9807},
{0.696,0.9803},
{0.7017,0.97},
{0.695,0.9689},
{0.702,0.9589},
{0.6954,0.9571},
{0.7037,0.9477},
{0.6972,0.9452},
{0.7067,0.937},
{0.7004,0.9338},
{0.7109,0.9271},
{0.7048,0.9233},
{0.7161,0.9184},
{0.7103,0.9141},
{0.7222,0.9115},
{0.7169,0.9067},
{0.9624,0.8141},
{0.7426,0.9898},
{0.7452,0.9936},
{0.7405,0.985},
{0.7392,0.9796},
{0.7342,0.9801},
{0.7284,0.9807},
{0.7221,0.9811},
{0.7157,0.9812},
{0.7092,0.9811},
{0.7083,0.971},
{0.7086,0.9606},
{0.7102,0.9502},
{0.713,0.9401},
{0.7169,0.9309},
{0.7217,0.9228},
{0.7275,0.9162},
{0.8018,0.9943},
{0.7961,0.9998},
{0.8068,0.9873},
{0.805,0.9771},
{0.8111,0.979},
{0.8019,0.967},
{0.7978,0.9578},
{0.792,0.9572},
{0.7871,0.9566},
{0.7832,0.9561},
{0.7806,0.9559},
{0.7788,0.9558},
{0.7773,0.9557},
{0.7759,0.9604},
{0.7741,0.9599},
{0.7724,0.9641},
{0.7699,0.9626},
{0.7683,0.9663},
{0.7665,0.9693},
{0.8073,0.9971},
{0.8127,0.9896},
{0.8174,0.9808},
{0.8145,0.9696},
{0.8081,0.9684},
{0.804,0.9584},
{0.7988,0.9499},
{0.793,0.9502},
{0.788,0.9504},
{0.784,0.9505},
{0.7814,0.9506},
{0.7796,0.9507},
{0.778,0.9507},
{0.7761,0.9509},
{0.7755,0.9555},
{0.7729,0.9552},
{0.7716,0.959},
{0.7688,0.9572},
{0.7668,0.9604},
{0.7656,0.9641},
{0.8129,0.9998},
{0.8187,0.9919},
{0.8237,0.9824},
{0.821,0.9707},
{0.8169,0.9594},
{0.8104,0.959},
{0.8051,0.9496},
{0.799,0.9421},
{0.7932,0.9432},
{0.7882,0.9442},
{0.7842,0.945},
{0.7816,0.9454},
{0.7798,0.9456},
{0.7781,0.9458},
{0.7761,0.9463},
{0.7732,0.9472},
{0.7733,0.9513},
{0.7706,0.9549},
{0.7699,0.9522},
{0.7661,0.9542},
{0.7694,0.9485},
{0.7648,0.9501},
{0.766,0.9451},
{0.7698,0.9444},
{0.7686,0.9402},
{0.7705,0.9412},
{0.7713,0.9366},
{0.7728,0.9393},
{0.7753,0.9375},
{0.7738,0.9341},
{0.777,0.9365},
{0.7755,0.9328},
{0.7784,0.936},
{0.7769,0.9321},
{0.7801,0.9356},
{0.7785,0.9315},
{0.7826,0.9346},
{0.7809,0.9303},
{0.7864,0.9329},
{0.7845,0.9282},
{0.7912,0.9305},
{0.7891,0.9253},
{0.7967,0.9278},
{0.7944,0.9219},
{0.8028,0.9251},
{0.8002,0.9186},
{0.8091,0.9225},
{0.8062,0.9154},
{0.8155,0.9201},
{0.8124,0.9124},
{0.8221,0.9178},
{0.8187,0.9095},
{0.8287,0.9155},
{0.8251,0.9067},
{0.8116,0.9493},
{0.8183,0.949},
{0.8053,0.9409},
{0.7983,0.9347},
{0.7926,0.9366},
{0.7876,0.9383},
{0.7837,0.9396},
{0.7811,0.9403},
{0.7794,0.9406},
{0.7778,0.941},
{0.776,0.9417},
{0.7732,0.943},
{0.8119,0.9398},
{0.8185,0.9387},
{0.8045,0.9326},
{0.8236,0.9599},
{0.825,0.9487},
{0.8253,0.9377},
{0.8176,0.929},
{0.811,0.9308},
{0.8303,0.9603},
{0.8318,0.9484},
{0.8321,0.9367},
{0.8243,0.9273},
{0.8276,0.9717},
{0.7149,0.9719},
{0.7151,0.9623},
{0.7166,0.9526},
{0.7192,0.9433},
{0.7228,0.9347},
{0.7273,0.9272},
{0.7326,0.9211},
{0.7385,0.9165},
{0.7338,0.9114},
{0.7213,0.9726},
{0.7216,0.9638},
{0.7229,0.955},
{0.7253,0.9464},
{0.7286,0.9385},
{0.7327,0.9316},
{0.7376,0.926},
{0.7429,0.9219},
{0.7335,0.9734},
{0.7276,0.9731},
{0.7279,0.9652},
{0.7291,0.9572},
{0.7312,0.9495},
{0.7342,0.9424},
{0.7379,0.9362},
{0.7422,0.9311},
{0.7471,0.9274},
{0.7337,0.9664},
{0.7348,0.9593},
{0.7366,0.9524},
{0.7393,0.946},
{0.7426,0.9405},
{0.7465,0.936},
{0.7508,0.9327},
{0.7553,0.9307},
{0.7522,0.9251},
{0.7386,0.9736},
{0.7387,0.9674},
{0.7397,0.961},
{0.7414,0.9549},
{0.7437,0.9492},
{0.7467,0.9443},
{0.7501,0.9403},
{0.754,0.9374},
{0.7581,0.9356},
{0.7426,0.9738},
{0.7432,0.9792},
{0.7427,0.9682},
{0.7435,0.9624},
{0.745,0.9568},
{0.7472,0.9517},
{0.7498,0.9472},
{0.753,0.9436},
{0.7565,0.941},
{0.7444,0.9841},
{0.7457,0.9793},
{0.7451,0.9742},
{0.7452,0.9688},
{0.746,0.9634},
{0.7474,0.958},
{0.7494,0.9531},
{0.752,0.9489},
{0.755,0.9455},
{0.7583,0.9431},
{0.7463,0.9884},
{0.7469,0.9839},
{0.7475,0.9795},
{0.7469,0.9745},
{0.747,0.9693},
{0.7477,0.964},
{0.749,0.9588},
{0.751,0.9541},
{0.7535,0.95},
{0.7564,0.9467},
{0.9787,0.7279},
{0.9735,0.7267},
{0.975,0.7213},
{0.98,0.7231},
{0.9828,0.7288},
{0.984,0.7244},
{0.9855,0.7291},
{0.9867,0.7249},
{0.9875,0.7291},
{0.9886,0.725},
{0.9892,0.7293},
{0.9902,0.7253},
{0.9912,0.73},
{0.9921,0.7261},
{0.994,0.7315},
{0.9947,0.7279},
{0.9979,0.7302},
{0.9977,0.7339},
{0.9966,0.7371},
{0.9933,0.7352},
{0.9955,0.7394},
{0.997,0.7422},
{1.0,0.7403},
{0.9691,0.7193},
{0.9675,0.7253},
{0.9728,0.7329},
{0.9781,0.7335},
{0.9823,0.7339},
{0.985,0.7339},
{0.987,0.7338},
{0.9886,0.7338},
{0.9906,0.7342},
{0.9627,0.7173},
{0.9609,0.724},
{0.9667,0.7323},
{0.9729,0.7397},
{0.9782,0.7395},
{0.9823,0.7393},
{0.9851,0.7391},
{0.987,0.7388},
{0.9887,0.7387},
{0.9905,0.7387},
{0.9931,0.739},
{0.9939,0.743},
{0.9951,0.7471},
{0.9984,0.7459},
{0.9991,0.7499},
{0.9961,0.7512},
{0.9924,0.7481},
{0.9937,0.7526},
{0.9974,0.7548},
{0.9953,0.7566},
{0.9975,0.7599},
{0.9994,0.7575},
{0.954,0.723},
{0.9469,0.7222},
{0.949,0.7143},
{0.956,0.7157},
{0.9419,0.7132},
{0.9397,0.7216},
{0.9459,0.7313},
{0.9531,0.7315},
{0.96,0.7318},
{0.9667,0.7399},
{0.9858,0.7445},
{0.9877,0.744},
{0.9893,0.7437},
{0.9912,0.7434},
{0.9346,0.7121},
{0.9323,0.721},
{0.9386,0.7313},
{0.946,0.7411},
{0.9531,0.7406},
{0.9601,0.7401},
{0.831,0.9256},
{0.961,0.7488},
{0.9388,0.7417},
{0.9315,0.7424},
{0.9328,0.7539},
{0.9353,0.7652},
{0.9313,0.7313},
{0.1635,0.9618},
{0.1639,0.9716},
{0.1578,0.9731},
{0.1515,0.9746},
{0.1521,0.9849},
{0.1583,0.9828},
{0.1644,0.9806},
{0.1694,0.9609},
{0.1749,0.96},
{0.1697,0.97},
{0.1753,0.9683},
{0.1846,0.9581},
{0.1801,0.959},
{0.1804,0.9665},
{0.1918,0.9566},
{0.192,0.9621},
{0.1888,0.9633},
{0.1886,0.9572},
{0.9888,0.7492},
{0.9904,0.754},
{0.9905,0.7487},
{0.992,0.7534},
{0.9938,0.7576},
{0.9961,0.7612},
{0.9986,0.7642},
{1.0,0.7625},
{0.1963,0.9659},
{0.1959,0.9612},
{0.1973,0.9609},
{0.1976,0.9653},
{0.7575,0.9478},
{0.7548,0.951},
{0.7589,0.9496},
{0.7617,0.9473},
{0.7606,0.9455},
{0.7639,0.9443},
{0.7648,0.9463},
{0.1946,0.9663},
{0.1943,0.9615},
{0.1957,0.9561},
{0.194,0.9563},
{0.1957,0.9509},
{0.197,0.9509},
{0.1971,0.9459},
{0.1971,0.956},
{0.5452,0.9403},
{0.5452,0.9384},
{0.5491,0.9371},
{0.5489,0.9392},
{0.553,0.9366},
{0.5526,0.9386},
{0.5569,0.937},
{0.5562,0.9388},
{0.5606,0.9385},
{0.5596,0.9404},
{0.5641,0.941},
{0.5615,0.9373},
{0.5626,0.936},
{0.5586,0.9344},
{0.7504,0.9596},
{0.7492,0.9646},
{0.7521,0.9605},
{0.754,0.9563},
{0.7523,0.955},
{0.7486,0.9698},
{0.7511,0.9652},
{0.7546,0.962},
{0.7564,0.9586},
{0.7586,0.9555},
{0.7563,0.9527},
{0.7607,0.9525},
{0.7631,0.9504},
{0.7487,0.9839},
{0.749,0.9796},
{0.7502,0.9839},
{0.7508,0.9794},
{0.7504,0.975},
{0.7485,0.9748},
{0.7504,0.9878},
{0.752,0.9877},
{0.752,0.9834},
{0.7535,0.9787},
{0.7533,0.9748},
{0.7536,0.9706},
{0.7506,0.9702},
{0.7539,0.9662},
{0.757,0.9635},
{0.759,0.9619},
{0.7614,0.9594},
{0.7632,0.9561},
{0.9771,0.8182},
{0.9789,0.8188},
{0.9784,0.8225},
{0.9778,0.8269},
{0.9799,0.8231},
{0.9793,0.8273},
{0.9773,0.8318},
{0.9788,0.8321},
{0.9806,0.8282},
{0.9801,0.8326},
{0.9785,0.8371},
{0.9799,0.8373},
{0.9785,0.8422},
{0.9799,0.8421},
{0.9801,0.8468},
{0.9787,0.8472},
{0.9805,0.8511},
{0.9792,0.8517},
{0.9773,0.8474},
{0.9778,0.8521},
{0.9799,0.8557},
{0.9784,0.8563},
{0.9806,0.8592},
{0.9792,0.8598},
{0.9774,0.8605},
{0.4151,0.4913},
{0.4135,0.4916},
{0.4138,0.4869},
{0.4155,0.4865},
{0.415,0.4965},
{0.4134,0.4967},
{0.4171,0.4907},
{0.4169,0.4962},
{0.415,0.5019},
{0.4169,0.5018},
{0.4151,0.5072},
{0.4171,0.5074},
{0.4134,0.5019},
{0.4135,0.507},
{0.4138,0.5119},
{0.4154,0.5122},
{0.4142,0.5164},
{0.4158,0.5168},
{0.4122,0.492},
{0.4121,0.4969},
{0.4121,0.5019},
{0.4122,0.5069},
{0.4125,0.5117},
{0.9054,0.991},
{0.9038,0.9912},
{0.9025,0.9873},
{0.9042,0.9874},
{0.9037,0.9836},
{0.902,0.9833},
{0.904,0.9798},
{0.9025,0.9792},
{0.9055,0.9759},
{0.904,0.975},
{0.9015,0.9784},
{0.9029,0.9741},
{0.9062,0.971},
{0.977,0.837},
{0.977,0.8423},
{0.9752,0.837},
{0.9755,0.8316},
{0.7538,0.9869},
{0.7557,0.99},
{0.7541,0.9908},
{0.7547,0.9821},
{0.756,0.9779},
{0.7569,0.975},
{0.7576,0.971},
{0.7574,0.9668},
{0.9078,0.9721},
{0.9103,0.9683},
{0.568,0.9801},
{0.5696,0.9808},
{0.5669,0.9838},
{0.5656,0.9831},
{0.5636,0.9811},
{0.5625,0.985},
{0.5608,0.9826},
{0.559,0.9862},
{0.5576,0.9835},
{0.5543,0.9842},
{0.5551,0.9868},
{0.5509,0.9841},
{0.5512,0.9865},
{0.5698,0.9765},
{0.5716,0.977},
{0.5655,0.9784},
{0.5617,0.9789},
{0.5592,0.979},
{0.5559,0.9793},
{0.5529,0.9805},
{0.5508,0.9815},
{0.5476,0.9826},
{0.5486,0.9794},
{0.5508,0.9759},
{0.5457,0.9769},
{0.5477,0.9721},
{0.5438,0.9708},
{0.5426,0.975},
{0.5742,0.9632},
{0.5755,0.9628},
{0.5754,0.9679},
{0.5741,0.9681},
{0.5746,0.9727},
{0.5762,0.9725},
{0.577,0.9675},
{0.5771,0.9623},
{0.5749,0.9576},
{0.5735,0.9581},
{0.5716,0.9588},
{0.5723,0.9636},
{0.5724,0.9682},
{0.5732,0.9728},
{0.573,0.9771},
{0.5721,0.9531},
{0.5704,0.954},
{0.5677,0.9555},
{0.5685,0.9598},
{0.5694,0.964},
{0.5696,0.9679},
{0.5714,0.9725},
{0.5673,0.9444},
{0.57,0.9484},
{0.5686,0.9496},
{0.5663,0.9515},
{0.564,0.9534},
{0.564,0.9567},
{0.5644,0.961},
{0.5656,0.9648},
{0.5669,0.9675},
{0.5686,0.9716},
{0.5629,0.9428},
{0.566,0.9459},
{0.5639,0.9485},
{0.5616,0.9523},
{0.5596,0.9572},
{0.5592,0.9624},
{0.5615,0.9666},
{0.5651,0.9697},
{0.567,0.975},
{0.5622,0.9762},
{0.558,0.9742},
{0.5539,0.9736},
{0.993,0.7631},
{0.9923,0.7584},
{0.9947,0.7621},
{0.9956,0.7662},
{0.9973,0.7652},
{0.9935,0.7681},
{0.5522,0.9421},
{0.5553,0.942},
{0.5546,0.9453},
{0.5523,0.9466},
{0.5562,0.9476},
{0.5582,0.9436},
{0.5489,0.9429},
{0.5492,0.948},
{0.5533,0.9518},
{0.5586,0.9504},
{0.561,0.946},
{0.5499,0.9544},
{0.5556,0.9559},
{0.5513,0.9644},
{0.9158,0.9718},
{0.9167,0.969},
{0.92,0.973},
{0.9189,0.9774},
{0.9175,0.9838},
{0.9213,0.9882},
{0.9278,0.9878},
{0.9333,0.9824},
{0.9377,0.9835},
{0.94,0.98},
{0.9142,0.9753},
{0.9153,0.9806},
{0.9118,0.9856},
{0.9169,0.9879},
{0.9181,0.9929},
{0.924,0.9908},
{0.9126,0.9701},
{0.9151,0.967},
{0.9104,0.9735},
{0.9117,0.9784},
{0.9107,0.9826},
{0.9074,0.9868},
{0.9121,0.9889},
{0.9147,0.992},
{0.9083,0.9769},
{0.9096,0.9804},
{0.9067,0.9835},
{0.9082,0.9901},
{0.912,0.9914},
{0.9123,0.995},
{0.9096,0.993},
{0.9073,0.9943},
{0.5632,0.9728},
{0.5585,0.9696},
{0.9068,0.9802},
{0.7564,0.9851},
{0.7598,0.9822},
{0.761,0.9853},
{0.758,0.988},
{0.7581,0.9923},
{0.7599,0.9902},
{0.9208,0.9945},
{0.7578,0.9797},
{0.7608,0.9759},
{0.7625,0.9713},
{0.7615,0.9664},
{0.5439,0.9659},
{0.5449,0.9584},
{0.5419,0.9614},
{0.9361,0.9871},
{0.9322,0.9868},
{0.7648,0.9643},
{0.7642,0.9535},
{0.5456,0.9436},
{0.546,0.9481},
{0.5437,0.9479},
{0.5426,0.945},
{0.5418,0.9422},
{0.5426,0.9508},
{0.5461,0.9535},
{0.5411,0.9545},
{0.6588,0.352},
{0.6667,0.3472},
{0.6689,0.3509},
{0.6607,0.3559},
{0.6713,0.3542},
{0.6799,0.3489},
{0.6774,0.3456},
{0.6751,0.3421},
{0.665,0.3431},
{0.6574,0.3475},
{0.6504,0.3514},
{0.6514,0.3563},
{0.6529,0.3606},
{0.663,0.3594},
{0.6566,0.3426},
{0.6637,0.3387},
{0.6501,0.346},
{0.6445,0.3487},
{0.6442,0.3547},
{0.6447,0.3602},
{0.6458,0.3649},
{0.655,0.3643},
{0.6836,0.3368},
{0.673,0.3384},
{0.6812,0.3333},
{0.6711,0.3344},
{0.6861,0.3402},
{0.6922,0.3314},
{0.6893,0.3281},
{0.6863,0.3248},
{0.6787,0.3297},
{0.6695,0.3302},
{0.6629,0.3339},
{0.6565,0.3372},
{0.6507,0.34},
{0.6455,0.342},
{0.6408,0.3432},
{0.6394,0.3505},
{0.6387,0.3572},
{0.6387,0.3632},
{0.6393,0.3685},
{0.6333,0.3653},
{0.6334,0.371},
{0.6284,0.3661},
{0.6282,0.3723},
{0.624,0.3655},
{0.6237,0.372},
{0.6887,0.3434},
{0.6949,0.3346},
{0.7006,0.3259},
{0.6973,0.3228},
{0.6935,0.3199},
{0.6893,0.3173},
{0.683,0.3217},
{0.6763,0.3261},
{0.6683,0.3261},
{0.6625,0.3292},
{0.657,0.3318},
{0.6517,0.3339},
{0.647,0.3354},
{0.6426,0.336},
{0.6386,0.3356},
{0.6366,0.3434},
{0.6349,0.3513},
{0.6338,0.3586},
{0.6292,0.3589},
{0.625,0.3578},
{0.6199,0.3635},
{0.6209,0.3553},
{0.6266,0.3492},
{0.6226,0.3462},
{0.6171,0.3518},
{0.619,0.3423},
{0.6249,0.3367},
{0.6215,0.3326},
{0.6156,0.3377},
{0.6184,0.328},
{0.6126,0.3325},
{0.6157,0.3234},
{0.6218,0.3184},
{0.6195,0.3143},
{0.6132,0.3181},
{0.6173,0.3099},
{0.6107,0.3119},
{0.6151,0.3045},
{0.608,0.3041},
{0.6125,0.2975},
{0.6048,0.2944},
{0.6095,0.2883},
{0.6175,0.2913},
{0.6146,0.2826},
{0.6061,0.2778},
{0.6112,0.2724},
{0.6027,0.267},
{0.6077,0.2619},
{0.5994,0.2567},
{0.6043,0.2518},
{0.5964,0.248},
{0.6011,0.2433},
{0.5938,0.2406},
{0.5981,0.236},
{0.5914,0.2344},
{0.5952,0.2297},
{0.589,0.2294},
{0.5921,0.2247},
{0.5867,0.2254},
{0.5889,0.2212},
{0.5904,0.2175},
{0.5859,0.2183},
{0.5867,0.2153},
{0.7047,0.3177},
{0.7086,0.3206},
{0.7003,0.3151},
{0.6952,0.3129},
{0.6899,0.3111},
{0.685,0.315},
{0.6797,0.3189},
{0.674,0.3226},
{0.6673,0.3223},
{0.6625,0.3248},
{0.6577,0.3269},
{0.6531,0.3284},
{0.6487,0.3293},
{0.6445,0.3294},
{0.6406,0.3285},
{0.6347,0.3341},
{0.6326,0.3424},
{0.6307,0.3509},
{0.7115,0.313},
{0.716,0.3156},
{0.7063,0.3106},
{0.7004,0.3087},
{0.6942,0.3072},
{0.6885,0.3061},
{0.685,0.3097},
{0.681,0.3131},
{0.6767,0.3164},
{0.672,0.3195},
{0.6666,0.3193},
{0.6626,0.3212},
{0.6585,0.3227},
{0.6544,0.3238},
{0.6503,0.3242},
{0.6463,0.3239},
{0.6425,0.3227},
{0.6369,0.3266},
{0.631,0.3313},
{0.6287,0.3401},
{0.7036,0.3291},
{0.7119,0.3237},
{0.7198,0.3185},
{0.7226,0.3111},
{0.7174,0.3087},
{0.7114,0.3065},
{0.7046,0.3048},
{0.6977,0.3034},
{0.6913,0.3024},
{0.686,0.3017},
{0.6837,0.3053},
{0.6809,0.3086},
{0.6777,0.3117},
{0.6742,0.3145},
{0.6704,0.317},
{0.6661,0.3171},
{0.6627,0.3187},
{0.6591,0.3199},
{0.6554,0.3206},
{0.6515,0.3207},
{0.6477,0.3202},
{0.6439,0.3188},
{0.6389,0.3205},
{0.6334,0.3233},
{0.6276,0.3274},
{0.7062,0.3322},
{0.7148,0.3267},
{0.7231,0.3214},
{0.7271,0.3137},
{0.7283,0.3068},
{0.7222,0.3046},
{0.7154,0.3027},
{0.7079,0.301},
{0.7004,0.2997},
{0.6934,0.2986},
{0.6877,0.2979},
{0.6837,0.2975},
{0.6824,0.3013},
{0.6805,0.3048},
{0.6781,0.3079},
{0.6755,0.3107},
{0.6725,0.3131},
{0.6694,0.3152},
{0.6659,0.3158},
{0.6628,0.3172},
{0.6596,0.3181},
{0.6562,0.3186},
{0.6525,0.3186},
{0.6488,0.3179},
{0.6451,0.3164},
{0.6404,0.3164},
{0.6356,0.317},
{0.6303,0.3191},
{0.6245,0.323},
{0.6975,0.3378},
{0.288,0.0028},
{0.2948,0.0013},
{0.2938,0.0059},
{0.2865,0.0077},
{0.2935,0.0115},
{0.3022,0.0096},
{0.302,0.0043},
{0.3024,0.0},
{0.2823,0.0044},
{0.2804,0.0097},
{0.2859,0.0137},
{0.2938,0.0178},
{0.3026,0.0158},
{0.3121,0.014},
{0.3115,0.0079},
{0.311,0.0028},
{0.3211,0.0064},
{0.3204,0.0015},
{0.331,0.0053},
{0.3303,0.0006},
{0.3411,0.0047},
{0.3403,0.0001},
{0.3512,0.0048},
{0.3505,0.0003},
{0.3605,0.0013},
{0.3612,0.0059},
{0.3704,0.0029},
{0.3711,0.0076},
{0.38,0.005},
{0.3807,0.0099},
{0.3892,0.0074},
{0.39,0.0125},
{0.3979,0.0099},
{0.399,0.0153},
{0.4057,0.0125},
{0.4071,0.0182},
{0.4122,0.0151},
{0.4139,0.0212},
{0.4172,0.0178},
{0.4189,0.0244},
{0.4142,0.0276},
{0.4189,0.0311},
{0.4129,0.034},
{0.4169,0.0372},
{0.4109,0.0405},
{0.4141,0.0414},
{0.4183,0.0418},
{0.4142,0.0463},
{0.4089,0.0475},
{0.4127,0.0526},
{0.4065,0.0549},
{0.3992,0.0547},
{0.4027,0.0625},
{0.3953,0.0631},
{0.3874,0.062},
{0.3833,0.0708},
{0.391,0.0713},
{0.6475,0.3689},
{0.726,0.3006},
{0.7329,0.3026},
{0.7184,0.2988},
{0.7102,0.2971},
{0.7021,0.2957},
{0.6946,0.2945},
{0.6885,0.2937},
{0.6843,0.2933},
{0.6818,0.2933},
{0.6813,0.2974},
{0.6802,0.3012},
{0.6785,0.3046},
{0.6765,0.3075},
{0.6741,0.3101},
{0.6716,0.3122},
{0.6688,0.3141},
{0.7285,0.2964},
{0.7361,0.2983},
{0.7202,0.2946},
{0.7113,0.2929},
{0.7027,0.2913},
{0.6948,0.2901},
{0.6884,0.2893},
{0.6841,0.2889},
{0.6815,0.289},
{0.6806,0.2936},
{0.6803,0.2894},
{0.6802,0.2845},
{0.6791,0.2852},
{0.6781,0.2805},
{0.6772,0.2815},
{0.6752,0.2776},
{0.6746,0.2789},
{0.6718,0.2765},
{0.6715,0.2781},
{0.672,0.2796},
{0.6749,0.2804},
{0.7336,0.3091},
{0.7388,0.3047},
{0.7427,0.3003},
{0.7379,0.2938},
{0.7297,0.2918},
{0.7207,0.2899},
{0.7113,0.2881},
{0.7021,0.2865},
{0.6939,0.2853},
{0.6872,0.2845},
{0.6828,0.2843},
{0.6802,0.2845},
{0.6804,0.2799},
{0.6781,0.2805},
{0.6772,0.2763},
{0.6731,0.2746},
{0.6684,0.276},
{0.6679,0.2779},
{0.668,0.2795},
{0.672,0.2796},
{0.6687,0.2811},
{0.673,0.2814},
{0.6698,0.2828},
{0.6742,0.2834},
{0.6711,0.285},
{0.6756,0.286},
{0.6769,0.2839},
{0.6781,0.2863},
{0.6768,0.2892},
{0.6792,0.2892},
{0.6778,0.2932},
{0.6799,0.2927},
{0.681,0.2903},
{0.6814,0.2932},
{0.6804,0.2963},
{0.6814,0.2957},
{0.6819,0.2976},
{0.6808,0.2995},
{0.6786,0.2975},
{0.6791,0.3014},
{0.6762,0.2995},
{0.677,0.3035},
{0.6792,0.3043},
{0.6773,0.3066},
{0.6745,0.3059},
{0.675,0.3088},
{0.6717,0.3082},
{0.6726,0.3109},
{0.6687,0.3103},
{0.6699,0.3127},
{0.6671,0.3143},
{0.6655,0.3121},
{0.6642,0.3156},
{0.6623,0.3135},
{0.6613,0.3166},
{0.6592,0.3147},
{0.6585,0.3173},
{0.6565,0.3156},
{0.6563,0.312},
{0.6536,0.3132},
{0.6542,0.3163},
{0.6517,0.3144},
{0.652,0.3164},
{0.6507,0.315},
{0.6495,0.3155},
{0.6486,0.3139},
{0.6489,0.3122},
{0.6461,0.3123},
{0.646,0.3101},
{0.6503,0.3105},
{0.6472,0.3079},
{0.6436,0.308},
{0.6446,0.3055},
{0.6416,0.3061},
{0.6425,0.3034},
{0.6399,0.3045},
{0.6408,0.3017},
{0.6384,0.3033},
{0.6393,0.3003},
{0.6371,0.3026},
{0.6379,0.2993},
{0.6363,0.2988},
{0.6355,0.3026},
{0.6379,0.3062},
{0.6365,0.3067},
{0.6399,0.3098},
{0.6387,0.3106},
{0.6428,0.313},
{0.6417,0.314},
{0.6461,0.3152},
{0.6497,0.3167},
{0.7379,0.3115},
{0.7437,0.3068},
{0.7479,0.3022},
{0.7448,0.2958},
{0.7383,0.289},
{0.7297,0.2869},
{0.7202,0.2848},
{0.7103,0.2829},
{0.7007,0.2814},
{0.6919,0.2803},
{0.6849,0.2798},
{0.6814,0.2755},
{0.6762,0.2719},
{0.6688,0.274},
{0.663,0.2775},
{0.6634,0.2793},
{0.6637,0.2809},
{0.6642,0.2824},
{0.6649,0.2839},
{0.6661,0.2857},
{0.6675,0.2878},
{0.6725,0.2876},
{0.674,0.2909},
{0.6752,0.2951},
{0.7309,0.3164},
{0.8374,0.7238},
{0.8292,0.7211},
{0.832,0.7168},
{0.84,0.7192},
{0.8415,0.7154},
{0.8337,0.7132},
{0.8336,0.7293},
{0.8255,0.7263},
{0.8443,0.7284},
{0.847,0.7233},
{0.8484,0.719},
{0.8485,0.7152},
{0.8417,0.7121},
{0.8233,0.7159},
{0.8203,0.7202},
{0.8165,0.7251},
{0.8208,0.7323},
{0.8287,0.7358},
{0.8403,0.7345},
{0.8494,0.7356},
{0.8525,0.7294},
{0.8542,0.7241},
{0.8111,0.7204},
{0.8073,0.7251},
{0.8122,0.7306},
{0.8154,0.7394},
{0.8228,0.7436},
{0.8351,0.7418},
{0.8451,0.7426},
{0.8529,0.7437},
{0.8564,0.7364},
{0.8584,0.73},
{0.7374,0.2838},
{0.7286,0.2816},
{0.7188,0.2795},
{0.7086,0.2777},
{0.6985,0.2764},
{0.689,0.2756},
{0.6861,0.2713},
{0.6843,0.2677},
{0.6755,0.269},
{0.6684,0.2717},
{0.6623,0.2753},
{0.6568,0.2792},
{0.6578,0.2814},
{0.6585,0.2832},
{0.6592,0.2846},
{0.6599,0.286},
{0.6608,0.2875},
{0.662,0.2891},
{0.6634,0.2912},
{0.669,0.2904},
{0.6706,0.2936},
{0.6722,0.2977},
{0.7353,0.2781},
{0.7265,0.276},
{0.7167,0.2741},
{0.7064,0.2726},
{0.6961,0.2716},
{0.694,0.2674},
{0.6916,0.2632},
{0.6825,0.2642},
{0.6743,0.266},
{0.6672,0.2689},
{0.6611,0.2724},
{0.6554,0.2762},
{0.6498,0.28},
{0.6514,0.2831},
{0.6525,0.2853},
{0.6535,0.2869},
{0.6543,0.2883},
{0.6551,0.2896},
{0.6561,0.2909},
{0.6574,0.2925},
{0.659,0.2945},
{0.6651,0.2937},
{0.6669,0.2968},
{0.6687,0.3006},
{0.6735,0.302},
{0.6704,0.3046},
{0.667,0.307},
{0.6633,0.309},
{0.6597,0.3107},
{0.6567,0.3074},
{0.6531,0.309},
{0.6718,0.7787},
{0.6767,0.7814},
{0.6714,0.7859},
{0.6665,0.7834},
{0.6659,0.7754},
{0.6607,0.7804},
{0.6586,0.7713},
{0.6539,0.7768},
{0.6504,0.7664},
{0.6462,0.7723},
{0.6483,0.7805},
{0.6412,0.7765},
{0.6375,0.767},
{0.6332,0.7715},
{0.6279,0.7605},
{0.6242,0.7655},
{0.6173,0.7529},
{0.6138,0.7581},
{0.6064,0.7445},
{0.603,0.75},
{0.5959,0.7361},
{0.5923,0.7417},
{0.5864,0.7282},
{0.5826,0.7339},
{0.5785,0.7212},
{0.5745,0.727},
{0.572,0.7152},
{0.5678,0.7209},
{0.5666,0.7101},
{0.5622,0.7158},
{0.5621,0.7057},
{0.5575,0.7114},
{0.5583,0.7202},
{0.5535,0.7158},
{0.5535,0.7077},
{0.5493,0.7122},
{0.5497,0.7046},
{0.5453,0.7091},
{0.546,0.7151},
{0.542,0.712},
{0.5411,0.7065},
{0.5378,0.7095},
{0.5362,0.7043},
{0.533,0.7073},
{0.5301,0.7024},
{0.5271,0.7052},
{0.5227,0.7005},
{0.5203,0.7031},
{0.6809,0.7754},
{0.6759,0.7721},
{0.6696,0.7682},
{0.662,0.7636},
{0.6533,0.7581},
{0.6411,0.7606},
{0.6311,0.7538},
{0.6205,0.7459},
{0.6097,0.7375},
{0.5995,0.7291},
{0.5902,0.7212},
{0.5827,0.7144},
{0.5764,0.7085},
{0.5713,0.7034},
{0.567,0.6992},
{0.5632,0.6957},
{0.5583,0.7021},
{0.5546,0.699},
{0.5508,0.6964},
{0.5456,0.702},
{0.5409,0.6998},
{0.5351,0.6979},
{0.5284,0.696},
{0.5209,0.6937},
{0.514,0.6981},
{0.6849,0.7782},
{0.6805,0.7837},
{0.6881,0.7713},
{0.6837,0.7676},
{0.6781,0.7634},
{0.6714,0.7586},
{0.6633,0.7532},
{0.6543,0.7473},
{0.6437,0.7519},
{0.6335,0.7449},
{0.623,0.737},
{0.6125,0.7288},
{0.6027,0.7206},
{0.5939,0.713},
{0.5867,0.7065},
{0.5807,0.7009},
{0.5758,0.6961},
{0.5716,0.6922},
{0.5679,0.6889},
{0.5644,0.6862},
{0.5597,0.6927},
{0.5561,0.6903},
{0.5523,0.6881},
{0.5465,0.6942},
{0.5414,0.6923},
{0.5358,0.6904},
{0.5302,0.6881},
{0.8163,0.7524},
{0.8092,0.7476},
{0.8291,0.7501},
{0.8397,0.7507},
{0.8482,0.7519},
{0.8551,0.7513},
{0.8588,0.7429},
{0.8023,0.7572},
{0.8092,0.7625},
{0.8223,0.7595},
{0.8334,0.7596},
{0.8426,0.7608},
{0.8501,0.7606},
{0.8072,0.737},
{0.8014,0.7446},
{0.795,0.7536},
{0.795,0.7682},
{0.8019,0.7737},
{0.8152,0.7698},
{0.8266,0.7693},
{0.8363,0.7703},
{0.8443,0.7704},
{0.7988,0.736},
{0.7937,0.7429},
{0.7877,0.7512},
{0.7877,0.7643},
{0.7874,0.78},
{0.7945,0.7855},
{0.8079,0.781},
{0.8196,0.7797},
{0.8296,0.7803},
{0.838,0.7804},
{0.8033,0.7302},
{0.7948,0.7306},
{0.7909,0.7357},
{0.7864,0.7419},
{0.781,0.7496},
{0.7807,0.7614},
{0.7802,0.7758},
{0.7802,0.7916},
{0.7874,0.797},
{0.8008,0.7925},
{0.8126,0.7906},
{0.8228,0.7905},
{0.8315,0.7906},
{0.7139,0.2688},
{0.7105,0.2632},
{0.7197,0.264},
{0.7236,0.2702},
{0.7321,0.2718},
{0.715,0.2571},
{0.7062,0.257},
{0.701,0.2629},
{0.704,0.2678},
{0.7094,0.2494},
{0.701,0.2499},
{0.6973,0.2574},
{0.7736,0.8024},
{0.7811,0.8076},
{0.7941,0.8037},
{0.8058,0.8015},
{0.8162,0.8009},
{0.8251,0.8007},
{0.7732,0.7726},
{0.7728,0.7874},
{0.7657,0.7841},
{0.766,0.7982},
{0.6948,0.2415},
{0.6879,0.2325},
{0.696,0.2316},
{0.7029,0.2407},
{0.9306,0.3563},
{0.9302,0.3655},
{0.9216,0.3658},
{0.922,0.3568},
{0.9309,0.3476},
{0.9223,0.3482},
{0.931,0.3398},
{0.9227,0.3406},
{0.931,0.3331},
{0.9229,0.334},
{0.9148,0.3401},
{0.9154,0.3335},
{0.9232,0.3283},
{0.9161,0.328},
{0.9234,0.3234},
{0.9169,0.3233},
{0.9237,0.3194},
{0.9176,0.3195},
{0.5616,0.229},
{0.5517,0.2336},
{0.5486,0.2249},
{0.5587,0.2195},
{0.5454,0.2154},
{0.5342,0.2228},
{0.5375,0.2313},
{0.5405,0.2392},
{0.5544,0.2406},
{0.5643,0.2364},
{0.5721,0.234},
{0.5695,0.2265},
{0.5669,0.2167},
{0.5559,0.2084},
{0.5419,0.2066},
{0.5311,0.2148},
{0.5203,0.222},
{0.5228,0.2295},
{0.5257,0.2374},
{0.5286,0.2448},
{0.5431,0.2457},
{0.5647,0.2049},
{0.5524,0.1981},
{0.5642,0.1893},
{0.5556,0.182},
{0.5475,0.1909},
{0.5381,0.1998},
{0.6721,0.136},
{0.679,0.1422},
{0.6672,0.1502},
{0.6593,0.1437},
{0.6569,0.1577},
{0.6654,0.1637},
{0.6748,0.1562},
{0.6857,0.1478},
{0.6908,0.1335},
{0.6844,0.1278},
{0.6783,0.1224},
{0.6659,0.1299},
{0.6526,0.1369},
{0.6471,0.151},
{0.6499,0.1644},
{0.659,0.1702},
{0.6659,0.175},
{0.6721,0.1685},
{0.681,0.1609},
{0.6914,0.1524},
{0.6969,0.1388},
{0.7014,0.1241},
{0.6953,0.1189},
{0.6894,0.1142},
{0.6841,0.1108},
{0.6734,0.118},
{0.6614,0.1245},
{0.6484,0.1303},
{0.6389,0.1437},
{0.639,0.1582},
{0.6386,0.1654},
{0.6484,0.1706},
{0.6569,0.1756},
{0.6636,0.18},
{0.668,0.1832},
{0.6704,0.1782},
{0.6765,0.1717},
{0.6852,0.1639},
{0.6951,0.1552},
{0.702,0.1432},
{0.7069,0.1293},
{0.7108,0.1143},
{0.705,0.1095},
{0.6991,0.1054},
{0.6934,0.1029},
{0.688,0.1013},
{0.6794,0.1082},
{0.6695,0.1144},
{0.6581,0.1197},
{0.6461,0.1242},
{0.6343,0.1279},
{0.6353,0.1356},
{0.6233,0.1393},
{0.6242,0.1515},
{0.6301,0.1623},
{0.5167,0.249},
{0.5048,0.2522},
{0.502,0.2457},
{0.5138,0.2422},
{0.4997,0.2387},
{0.4885,0.2413},
{0.4905,0.2481},
{0.4932,0.2544},
{0.5077,0.2574},
{0.5194,0.2545},
{0.5312,0.2507},
{0.5112,0.2348},
{0.4984,0.2318},
{0.4877,0.2345},
{0.4775,0.236},
{0.4778,0.2428},
{0.4793,0.2496},
{0.4818,0.2557},
{0.4848,0.2607},
{0.4962,0.2594},
{0.5093,0.2276},
{0.5083,0.2214},
{0.4983,0.2256},
{0.7135,0.0997},
{0.7192,0.1042},
{0.7074,0.0963},
{0.7013,0.0945},
{0.6954,0.0937},
{0.69,0.0934},
{0.6832,0.1001},
{0.6754,0.106},
{0.6663,0.1112},
{0.6557,0.1154},
{0.6447,0.1188},
{0.6339,0.1213},
{0.6244,0.1229},
{0.6236,0.1304},
{0.6138,0.1404},
{0.6128,0.1491},
{0.6121,0.1563},
{0.6193,0.1584},
{0.6256,0.1633},
{0.6311,0.1692},
{0.6355,0.1695},
{0.7208,0.0898},
{0.7266,0.0939},
{0.7145,0.0869},
{0.708,0.0857},
{0.7017,0.0857},
{0.6958,0.0861},
{0.6906,0.0863},
{0.6852,0.093},
{0.679,0.0989},
{0.6719,0.104},
{0.6636,0.1082},
{0.6539,0.1116},
{0.6437,0.1141},
{0.6338,0.1159},
{0.6251,0.1169},
{0.6184,0.1172},
{0.6168,0.1236},
{0.6152,0.1314},
{0.7159,0.1193},
{0.7241,0.109},
{0.7317,0.0985},
{0.7333,0.0835},
{0.727,0.0799},
{0.7203,0.0774},
{0.7136,0.0767},
{0.707,0.0772},
{0.701,0.0782},
{0.6956,0.0789},
{0.6913,0.0786},
{0.6864,0.0855},
{0.6813,0.0917},
{0.6755,0.097},
{0.6689,0.1016},
{0.6613,0.1053},
{0.6523,0.1082},
{0.6427,0.1102},
{0.6335,0.1116},
{0.6254,0.1122},
{0.6192,0.1123},
{0.6131,0.1168},
{0.6109,0.1234},
{0.6083,0.1313},
{0.7201,0.1237},
{0.7281,0.1134},
{0.7356,0.1029},
{0.7388,0.0878},
{0.7387,0.073},
{0.7319,0.0698},
{0.7247,0.0679},
{0.7177,0.0677},
{0.7112,0.0686},
{0.7051,0.0699},
{0.6998,0.071},
{0.6955,0.0713},
{0.6919,0.0709},
{0.6878,0.0778},
{0.6831,0.0842},
{0.6782,0.0899},
{0.6727,0.0949},
{0.6665,0.0991},
{0.6593,0.1025},
{0.6508,0.1051},
{0.6418,0.107},
{0.6331,0.1082},
{0.6255,0.1088},
{0.6197,0.1089},
{0.6153,0.1084},
{0.6145,0.1119},
{0.609,0.1157},
{0.6061,0.1223},
{0.6025,0.1303},
{0.7114,0.1336},
{0.7144,0.1366},
{0.7228,0.1269},
{0.7306,0.1168},
{0.7381,0.1064},
{0.8083,0.2744},
{0.8159,0.2667},
{0.8204,0.273},
{0.8131,0.2802},
{0.8252,0.2793},
{0.8334,0.2738},
{0.829,0.2669},
{0.8248,0.26},
{0.8123,0.2606},
{0.8047,0.2687},
{0.7983,0.2767},
{0.802,0.2822},
{0.8068,0.2876},
{0.8354,0.2553},
{0.8391,0.2626},
{0.8325,0.2486},
{0.8215,0.2535},
{0.8105,0.2549},
{0.8197,0.2478},
{0.8308,0.2428},
{0.8299,0.237},
{0.8189,0.2417},
{0.8185,0.2342},
{0.8295,0.2299},
{0.8178,0.224},
{0.829,0.2204},
{0.8163,0.2101},
{0.8058,0.2151},
{0.8081,0.2297},
{0.7968,0.2219},
{0.7999,0.2368},
{0.8372,0.2802},
{0.8295,0.2852},
{0.8458,0.2766},
{0.8427,0.2698},
{0.8507,0.2608},
{0.8479,0.2535},
{0.8455,0.2467},
{0.844,0.2409},
{0.4687,0.2501},
{0.4676,0.2432},
{0.4679,0.2363},
{0.4698,0.2302},
{0.4611,0.2292},
{0.4588,0.2352},
{0.8181,0.2857},
{0.8228,0.2911},
{0.7349,0.0596},
{0.7422,0.062},
{0.7274,0.0583},
{0.7204,0.0586},
{0.714,0.0599},
{0.7081,0.0617},
{0.703,0.0632},
{0.6987,0.0639},
{0.6951,0.0641},
{0.6921,0.0639},
{0.689,0.0703},
{0.685,0.0767},
{0.6805,0.0827},
{0.6758,0.0881},
{0.6706,0.0928},
{0.6646,0.0968},
{0.6578,0.1001},
{0.6496,0.1026},
{0.6411,0.1045},
{0.6328,0.1057},
{0.6255,0.1063},
{0.6199,0.1064},
{0.6157,0.106},
{0.6125,0.1051},
{0.6118,0.1075},
{0.6108,0.1109},
{0.6054,0.114},
{0.602,0.1203},
{0.5975,0.1282},
{0.5921,0.1374},
{0.5985,0.1395},
{0.596,0.1487},
{0.5848,0.1495},
{0.5898,0.16},
{0.597,0.1571},
{0.6044,0.1486},
{0.6046,0.1562},
{0.6059,0.14},
{0.7359,0.049},
{0.7434,0.0506},
{0.7283,0.0486},
{0.7214,0.0496},
{0.7152,0.0515},
{0.7098,0.0537},
{0.7049,0.0557},
{0.7008,0.0569},
{0.6971,0.0575},
{0.6941,0.0578},
{0.6915,0.058},
{0.6896,0.0638},
{0.6866,0.0698},
{0.6828,0.0758},
{0.6785,0.0815},
{0.6739,0.0866},
{0.6689,0.091},
{0.6632,0.0949},
{0.6566,0.0981},
{0.6488,0.1006},
{0.6406,0.1025},
{0.6326,0.1038},
{0.6256,0.1045},
{0.6202,0.1047},
{0.6162,0.1044},
{0.613,0.1036},
{0.6097,0.1038},
{0.6089,0.1061},
{0.6076,0.1094},
{0.6019,0.1117},
{0.5981,0.1175},
{0.5931,0.1245},
{0.587,0.1324},
{0.5795,0.1391},
{0.5716,0.1503},
{0.5777,0.1602},
{0.5836,0.1655},
{0.5934,0.1674},
{0.5995,0.1643},
{0.6058,0.1625},
{0.7447,0.0768},
{0.7487,0.0653},
{0.7501,0.053},
{0.7483,0.0399},
{0.7417,0.0384},
{0.7343,0.038},
{0.727,0.0388},
{0.7206,0.0407},
{0.7148,0.0435},
{0.7098,0.0464},
{0.7053,0.0489},
{0.7013,0.0506},
{0.6977,0.0516},
{0.6946,0.0523},
{0.692,0.0528},
{0.6898,0.0535},
{0.6894,0.0585},
{0.6876,0.0639},
{0.6847,0.0696},
{0.6811,0.0754},
{0.677,0.0808},
{0.6726,0.0856},
{0.6678,0.0899},
{0.6623,0.0936},
{0.6559,0.0967},
{0.6484,0.0992},
{0.6405,0.1012},
{0.6328,0.1025},
{0.626,0.1033},
{0.6208,0.1035},
{0.6202,0.1047},
{0.6168,0.1032},
{0.6138,0.1024},
{0.5008,0.6264},
{0.495,0.6301},
{0.4871,0.6221},
{0.4927,0.6181},
{0.4825,0.6105},
{0.4773,0.6148},
{0.4698,0.6042},
{0.4651,0.6087},
{0.4559,0.5992},
{0.452,0.6039},
{0.4424,0.5954},
{0.4391,0.6002},
{0.4485,0.6084},
{0.4368,0.6049},
{0.428,0.5976},
{0.4265,0.6024},
{0.42,0.5959},
{0.4189,0.601},
{0.7429,0.092},
{0.7492,0.0807},
{0.8612,0.254},
{0.8629,0.261},
{0.8594,0.2473},
{0.858,0.2414},
{0.8569,0.2356},
{0.843,0.2351},
{0.8424,0.2284},
{0.8418,0.2198},
{0.8411,0.2083},
{0.8281,0.2076},
{0.8145,0.1941},
{0.803,0.1984},
{0.7926,0.2047},
{0.784,0.2124},
{0.7893,0.2298},
{0.874,0.2561},
{0.8747,0.2628},
{0.8729,0.2495},
{0.8717,0.2435},
{0.8704,0.2376},
{0.8691,0.2313},
{0.856,0.2291},
{0.8551,0.2213},
{0.8544,0.2113},
{0.854,0.1999},
{0.8406,0.1951},
{0.8271,0.1927},
{0.8266,0.1773},
{0.8131,0.1776},
{0.8001,0.1811},
{0.7879,0.1864},
{0.7777,0.1936},
{0.8852,0.2592},
{0.885,0.2655},
{0.8847,0.2527},
{0.8836,0.2466},
{0.8822,0.2405},
{0.8805,0.2341},
{0.8789,0.2273},
{0.8679,0.2241},
{0.8668,0.2155},
{0.8664,0.2057},
{0.8668,0.1951},
{0.8543,0.1877},
{0.8406,0.1812},
{0.8416,0.1677},
{0.827,0.1628},
{0.8125,0.1625},
{0.7983,0.1652},
{0.7845,0.1692},
{0.77,0.1727},
{0.8644,0.2679},
{0.875,0.2692},
{0.8843,0.2715},
{0.8929,0.2687},
{0.8937,0.2625},
{0.8936,0.256},
{0.8926,0.2498},
{0.891,0.2435},
{0.8746,0.2749},
{0.8652,0.2742},
{0.8829,0.2766},
{0.8915,0.2744},
{0.8994,0.2724},
{0.9005,0.2662},
{0.9007,0.2596},
{0.8997,0.2532},
{0.8533,0.268},
{0.8554,0.2746},
{0.8563,0.2802},
{0.8477,0.2824},
{0.8398,0.2859},
{0.8326,0.2906},
{0.7321,0.016},
{0.7377,0.0266},
{0.7308,0.0274},
{0.726,0.018},
{0.72,0.0211},
{0.7241,0.0294},
{0.744,0.0269},
{0.7256,0.0077},
{0.7203,0.0104},
{0.7151,0.0143},
{0.7106,0.019},
{0.7148,0.0251},
{0.7182,0.0325},
{0.4308,0.5925},
{0.4225,0.5905},
{0.9066,0.2703},
{0.9053,0.2766},
{0.9069,0.2636},
{0.9083,0.3278},
{0.902,0.3285},
{0.9027,0.3207},
{0.9088,0.3194},
{0.9144,0.3282},
{0.9148,0.3195},
{0.8975,0.2779},
{0.9033,0.282},
{0.9117,0.2812},
{0.9096,0.2867},
{0.9196,0.2864},
{0.9174,0.292},
{0.9069,0.2907},
{0.9146,0.2959},
{0.9262,0.2975},
{0.9231,0.3013},
{0.9355,0.3029},
{0.932,0.3067},
{0.9448,0.3078},
{0.9476,0.3022},
{0.9379,0.2972},
{0.9489,0.2953},
{0.9391,0.2905},
{0.9487,0.2881},
{0.9389,0.2832},
{0.8952,0.2823},
{0.9008,0.2862},
{0.8896,0.2791},
{0.5326,0.809},
{0.5338,0.8011},
{0.5383,0.8056},
{0.5374,0.8128},
{0.5311,0.8188},
{0.5361,0.8221},
{0.5411,0.817},
{0.5399,0.8256},
{0.5339,0.8337},
{0.5378,0.8367},
{0.531,0.8466},
{0.5351,0.8494},
{0.5277,0.86},
{0.5321,0.8625},
{0.5242,0.8728},
{0.5288,0.8749},
{0.5257,0.8858},
{0.5207,0.8841},
{0.5229,0.8953},
{0.5174,0.8942},
{0.5206,0.9038},
{0.5148,0.9033},
{0.5191,0.9115},
{0.513,0.9118},
{0.5185,0.9189},
{0.5123,0.9198},
{0.519,0.9259},
{0.5128,0.9274},
{0.5145,0.9344},
{0.5206,0.9324},
{0.5176,0.941},
{0.5233,0.9385},
{0.522,0.9469},
{0.5273,0.9442},
{0.5272,0.9523},
{0.532,0.9496},
{0.5324,0.9573},
{0.5368,0.9546},
{0.537,0.9621},
{0.5411,0.9595},
{0.6991,0.0014},
{0.7074,0.0027},
{0.7037,0.0067},
{0.6961,0.005},
{0.7005,0.0116},
{0.706,0.0146},
{0.7098,0.0096},
{0.7142,0.0055},
{0.7112,0.0},
{0.7188,0.0026},
{0.5271,0.8057},
{0.5286,0.7972},
{0.5253,0.8159},
{0.5228,0.8279},
{0.5287,0.8306},
{0.5257,0.8437},
{0.5222,0.8572},
{0.5185,0.8701},
{0.5146,0.8818},
{0.511,0.8923},
{0.508,0.902},
{0.5059,0.9111},
{0.5051,0.9198},
{0.5056,0.928},
{0.5075,0.9356},
{0.5108,0.9425},
{0.5156,0.9486},
{0.5214,0.8033},
{0.5232,0.7945},
{0.5193,0.8138},
{0.5168,0.8257},
{0.5137,0.8385},
{0.5197,0.8409},
{0.5162,0.8542},
{0.5124,0.8672},
{0.5083,0.879},
{0.5043,0.89},
{0.501,0.9001},
{0.4986,0.9098},
{0.4977,0.919},
{0.4982,0.9277},
{0.5002,0.9358},
{0.5037,0.943},
{0.5351,0.795},
{0.5303,0.7904},
{0.5252,0.7872},
{0.5179,0.7932},
{0.5159,0.8021},
{0.5138,0.8125},
{0.5113,0.8243},
{0.5083,0.8368},
{0.5049,0.8496},
{0.5102,0.8516},
{0.5064,0.8644},
{0.5021,0.8763},
{0.498,0.8874},
{0.4944,0.8979},
{0.4919,0.9079},
{0.4909,0.9175},
{0.4914,0.9265},
{0.4934,0.9349},
{0.9081,0.3483},
{0.9017,0.3489},
{0.9017,0.3382},
{0.908,0.3376},
{0.9142,0.3381},
{0.9143,0.3487},
{0.9085,0.3593},
{0.9021,0.3599},
{0.9148,0.3594},
{0.8958,0.3503},
{0.896,0.3613},
{0.8959,0.3397},
{0.9678,0.3034},
{0.9656,0.3102},
{0.9569,0.3064},
{0.9587,0.2996},
{0.9537,0.3121},
{0.9616,0.3158},
{0.9681,0.2961},
{0.9587,0.2923},
{0.9757,0.307},
{0.9729,0.3137},
{0.9763,0.2997},
{0.9746,0.2925},
{0.9663,0.2889},
{0.9568,0.2851},
{0.0422,0.5196},
{0.0402,0.5122},
{0.0472,0.5104},
{0.0495,0.5183},
{0.0563,0.5172},
{0.0539,0.5091},
{0.0335,0.5142},
{0.031,0.507},
{0.0374,0.5046},
{0.0353,0.5211},
{0.0359,0.5284},
{0.043,0.5275},
{0.0504,0.5266},
{0.0573,0.5259},
{0.063,0.5253},
{0.062,0.5166},
{0.0279,0.5162},
{0.0257,0.5095},
{0.0293,0.5227},
{0.0299,0.5293},
{0.0295,0.5362},
{0.0355,0.5359},
{0.0426,0.5356},
{0.0499,0.5352},
{0.0569,0.5348},
{0.0626,0.5343},
{0.9561,0.3194},
{0.9489,0.3158},
{0.9408,0.3116},
{0.0481,0.544},
{0.0409,0.5439},
{0.055,0.5439},
{0.0608,0.5434},
{0.0449,0.5528},
{0.0378,0.5523},
{0.0517,0.5529},
{0.0575,0.5524},
{0.034,0.5436},
{0.0312,0.5515},
{0.0334,0.5607},
{0.0403,0.5614},
{0.047,0.5616},
{0.0281,0.5433},
{0.0256,0.5506},
{0.0271,0.5596},
{0.0283,0.569},
{0.035,0.5698},
{0.9581,0.5561},
{0.9578,0.5632},
{0.9509,0.562},
{0.9512,0.5551},
{0.958,0.5465},
{0.951,0.5456},
{0.9447,0.5521},
{0.9446,0.543},
{0.9507,0.5347},
{0.9444,0.5325},
{0.9393,0.5391},
{0.9392,0.5292},
{0.9442,0.5217},
{0.9391,0.5189},
{0.9443,0.5118},
{0.9393,0.5094},
{0.9449,0.5038},
{0.9401,0.5015},
{0.936,0.5066},
{0.9368,0.4989},
{0.797,0.3384},
{0.7904,0.3405},
{0.7909,0.3305},
{0.7976,0.3282},
{0.8044,0.3383},
{0.805,0.3281},
{0.7985,0.3195},
{0.8059,0.3194},
{0.8124,0.3294},
{0.8132,0.3211},
{0.8195,0.3242},
{0.8191,0.3316},
{0.8194,0.3407},
{0.812,0.3393},
{0.8197,0.3506},
{0.8119,0.3495},
{0.8197,0.3596},
{0.8117,0.3588},
{0.8191,0.3661},
{0.8115,0.3656},
{0.8039,0.3581},
{0.8038,0.3651},
{0.8112,0.3702},
{0.8038,0.37},
{0.7966,0.3655},
{0.7966,0.3704},
{0.0296,0.5778},
{0.0232,0.577},
{0.0249,0.5852},
{0.0187,0.5844},
{0.7967,0.3489},
{0.7901,0.3508},
{0.8041,0.3487},
{0.7966,0.3583},
{0.79,0.3602},
{0.0223,0.5677},
{0.0175,0.5755},
{0.0133,0.583},
{0.0155,0.5912},
{0.0216,0.5918},
{0.0176,0.566},
{0.0132,0.5737},
{0.0093,0.581},
{0.0102,0.5899},
{0.0134,0.5974},
{0.0195,0.5977},
{0.0257,0.5975},
{0.0278,0.5917},
{0.0219,0.5583},
{0.9504,0.5236},
{0.9504,0.5135},
{0.9509,0.5055},
{0.9517,0.4996},
{0.9459,0.4977},
{0.9411,0.4951},
{0.9572,0.5242},
{0.9576,0.5354},
{0.9571,0.514},
{0.9574,0.5061},
{0.9581,0.5004},
{0.9643,0.5344},
{0.9639,0.5232},
{0.9638,0.5131},
{0.9641,0.5053},
{0.9648,0.4996},
{0.7901,0.3674},
{0.0186,0.603},
{0.0124,0.6032},
{0.0248,0.6027},
{0.0307,0.6024},
{0.0316,0.5971},
{0.0364,0.6022},
{0.0372,0.5964},
{0.0419,0.6019},
{0.0425,0.5957},
{0.0391,0.59},
{0.0444,0.588},
{0.0477,0.5951},
{0.0495,0.5866},
{0.0187,0.6078},
{0.0125,0.6085},
{0.0249,0.6074},
{0.0309,0.6073},
{0.0366,0.6074},
{0.0423,0.6074},
{0.0478,0.6071},
{0.0473,0.6017},
{0.0527,0.6013},
{0.0528,0.5953},
{0.0495,0.5866},
{0.0545,0.587},
{0.0529,0.5736},
{0.0572,0.575},
{0.0603,0.558},
{0.0582,0.555},
{0.0081,0.5966},
{0.0066,0.6033},
{0.0065,0.6096},
{0.0082,0.6151},
{0.0138,0.6133},
{0.0198,0.6121},
{0.026,0.6116},
{0.032,0.6118},
{0.0377,0.6122},
{0.0433,0.6125},
{0.0487,0.6123},
{0.054,0.6112},
{0.0534,0.6063},
{0.0041,0.5947},
{0.0021,0.6019},
{0.0,0.6115},
{0.0044,0.6186},
{0.0079,0.6234},
{0.0112,0.6199},
{0.0161,0.6175},
{0.022,0.616},
{0.0281,0.6154},
{0.0063,0.5879},
{0.0117,0.6275},
{0.0148,0.624},
{0.5051,0.0958},
{0.5048,0.0895},
{0.5116,0.0913},
{0.5112,0.0969},
{0.5183,0.0935},
{0.5195,0.0886},
{0.5121,0.0858},
{0.5046,0.0832},
{0.4981,0.0882},
{0.4992,0.0953},
{0.5001,0.1016},
{0.5053,0.1015},
{0.5106,0.102},
{0.5159,0.1033},
{0.5171,0.0986},
{0.5228,0.1007},
{0.5246,0.0957},
{0.5264,0.0909},
{0.5283,0.0867},
{0.5209,0.0842},
{0.5131,0.081},
{0.505,0.0776},
{0.4972,0.0811},
{0.4919,0.0879},
{0.4937,0.0956},
{0.4952,0.1024},
{0.4958,0.1075},
{0.5003,0.1064},
{0.505,0.1059},
{0.5098,0.1062},
{0.5145,0.1072},
{0.519,0.109},
{0.521,0.1053},
{0.5257,0.1079},
{0.5281,0.1032},
{0.5306,0.0981},
{0.5331,0.0929},
{0.5354,0.0883},
{0.5398,0.0947},
{0.5426,0.0891},
{0.5458,0.0975},
{0.5519,0.0887},
{0.5567,0.0974},
{0.5622,0.0872},
{0.557,0.0801},
{0.5629,0.0801},
{0.56,0.0728},
{0.5648,0.0729},
{0.5623,0.0653},
{0.5666,0.0656},
{0.5683,0.0579},
{0.5641,0.0571},
{0.57,0.0494},
{0.5656,0.0479},
{0.5719,0.0408},
{0.5672,0.0384},
{0.5742,0.0327},
{0.5692,0.0293},
{0.5772,0.0254},
{0.572,0.0211},
{0.581,0.0196},
{0.576,0.0145},
{0.5857,0.0151},
{0.581,0.0095},
{0.587,0.0059},
{0.5913,0.0119},
{0.594,0.0037},
{0.5978,0.0098},
{0.602,0.0028},
{0.6051,0.0088},
{0.6111,0.0028},
{0.6135,0.0085},
{0.6215,0.0033},
{0.6232,0.0087},
{0.6334,0.0038},
{0.6343,0.0088},
{0.6469,0.0039},
{0.647,0.0087},
{0.6609,0.0039},
{0.6603,0.0085},
{0.6732,0.0085},
{0.6745,0.004},
{0.6846,0.0088},
{0.6866,0.0043},
{0.6936,0.0098},
{0.6976,0.017},
{0.7026,0.02},
{0.4969,0.0748},
{0.4902,0.0801},
{0.4893,0.0731},
{0.484,0.0806},
{0.4862,0.0888},
{0.5798,0.0368},
{0.5772,0.0439},
{0.583,0.0305},
{0.5868,0.0255},
{0.5913,0.0215},
{0.5965,0.0186},
{0.6025,0.0167},
{0.6092,0.0155},
{0.617,0.015},
{0.6258,0.0147},
{0.6361,0.0146},
{0.6479,0.0141},
{0.6603,0.0138},
{0.6723,0.0136},
{0.683,0.014},
{0.6912,0.015},
{0.6949,0.0222},
{0.6994,0.0251},
{0.7066,0.0241},
{0.7102,0.0295},
{0.7131,0.0361},
{0.5855,0.041},
{0.5827,0.047},
{0.5889,0.0357},
{0.5927,0.0314},
{0.597,0.028},
{0.6019,0.0253},
{0.6074,0.0234},
{0.6136,0.0221},
{0.6207,0.0213},
{0.6288,0.0207},
{0.6383,0.0202},
{0.6491,0.0196},
{0.6606,0.019},
{0.6716,0.0188},
{0.6814,0.0191},
{0.689,0.0202},
{0.6922,0.0266},
{0.6963,0.0294},
{0.703,0.029},
{0.7061,0.0339},
{0.7085,0.0397},
{0.5906,0.0446},
{0.5876,0.0497},
{0.5941,0.0402},
{0.5978,0.0365},
{0.6019,0.0335},
{0.6065,0.0311},
{0.6117,0.0292},
{0.6174,0.0278},
{0.6239,0.0267},
{0.6314,0.0258},
{0.6401,0.025},
{0.6501,0.0242},
{0.6606,0.0235},
{0.6708,0.0232},
{0.6798,0.0235},
{0.6868,0.0246},
{0.6894,0.0298},
{0.6932,0.0325},
{0.6996,0.0331},
{0.7023,0.0376},
{0.7043,0.0429},
{0.5751,0.0514},
{0.5803,0.0534},
{0.5852,0.0551},
{0.5916,0.0514},
{0.5946,0.047},
{0.5979,0.0432},
{0.6015,0.0399},
{0.6055,0.0372},
{0.6098,0.035},
{0.6146,0.0331},
{0.6199,0.0316},
{0.6259,0.0303},
{0.6328,0.0292},
{0.6408,0.0282},
{0.6502,0.0273},
{0.66,0.0266},
{0.6695,0.0263},
{0.6779,0.0266},
{0.6845,0.0278},
{0.6868,0.0319},
{0.6903,0.0346},
{0.6962,0.0359},
{0.6987,0.0401},
{0.7005,0.045},
{0.5733,0.0589},
{0.5784,0.06},
{0.5833,0.0609},
{0.5873,0.0614},
{0.5891,0.0562},
{0.5923,0.0569},
{0.5947,0.0525},
{0.5975,0.0486},
{0.6008,0.0451},
{0.6042,0.0421},
{0.6079,0.0396},
{0.612,0.0375},
{0.6164,0.0356},
{0.6213,0.034},
{0.5717,0.0661},
{0.5771,0.0665},
{0.5822,0.0668},
{0.5863,0.0667},
{0.5897,0.0665},
{0.5906,0.0616},
{0.5934,0.0616},
{0.595,0.0573},
{0.5972,0.0532},
{0.5998,0.0495},
{0.4886,0.0969},
{0.484,0.099},
{0.4811,0.0909},
{0.4784,0.0827},
{0.4733,0.0862},
{0.4765,0.0942},
{0.4798,0.1022},
{0.4864,0.1062},
{0.4906,0.1039},
{0.4722,0.0987},
{0.4757,0.1063},
{0.4825,0.1091},
{0.4878,0.1113},
{0.4917,0.1091},
{0.4707,0.0791},
{0.4763,0.0754},
{0.4658,0.0845},
{0.4687,0.091},
{0.4646,0.0973},
{0.4683,0.1043},
{0.4719,0.1113},
{0.4787,0.1129},
{0.4841,0.1141},
{0.4884,0.1148},
{0.4921,0.1127},
{0.4959,0.1111},
{0.5,0.11},
{0.5043,0.1094},
{0.5087,0.1095},
{0.513,0.1104},
{0.5172,0.1121},
{0.5233,0.1116},
{0.5272,0.1147},
{0.53,0.1111},
{0.533,0.1063},
{0.5362,0.1008},
{0.5412,0.1042},
{0.5505,0.1028},
{0.5607,0.1046},
{0.5643,0.0942},
{0.5702,0.086},
{0.5699,0.0796},
{0.5706,0.0729},
{0.4824,0.0734},
{0.46,0.1191},
{0.4643,0.1111},
{0.468,0.1175},
{0.4638,0.1247},
{0.471,0.123},
{0.4749,0.1175},
{0.4605,0.1048},
{0.4562,0.1138},
{0.4513,0.124},
{0.4552,0.1284},
{0.4591,0.133},
{0.4669,0.1294},
{0.4729,0.1266},
{0.4767,0.1217},
{0.4804,0.1175},
{0.4528,0.1095},
{0.4572,0.0997},
{0.4478,0.1206},
{0.4417,0.1331},
{0.4454,0.1356},
{0.4495,0.139},
{0.4537,0.1426},
{0.4623,0.137},
{0.4688,0.1325},
{0.4614,0.0913},
{0.443,0.1627},
{0.4382,0.161},
{0.4437,0.1502},
{0.4481,0.1527},
{0.4392,0.1477},
{0.4334,0.1594},
{0.4338,0.1708},
{0.4389,0.1717},
{0.4435,0.1723},
{0.4472,0.1639},
{0.452,0.1548},
{0.4572,0.1456},
{0.4643,0.1393},
{0.4354,0.1459},
{0.4293,0.1583},
{0.4287,0.17},
{0.4311,0.1788},
{0.4365,0.1791},
{0.4413,0.1792},
{0.4448,0.1786},
{0.4468,0.1721},
{0.4502,0.1643},
{0.4546,0.1559},
{0.4594,0.1473},
{0.4303,0.1914},
{0.43,0.1855},
{0.4355,0.1854},
{0.4359,0.191},
{0.4404,0.1851},
{0.4256,0.1784},
{0.4243,0.1855},
{0.4245,0.1918},
{0.4262,0.1981},
{0.4319,0.197},
{0.4374,0.1962},
{0.4408,0.1903},
{0.4444,0.1891},
{0.4441,0.1842},
{0.419,0.1859},
{0.4189,0.1927},
{0.4207,0.1996},
{0.4242,0.2073},
{0.4293,0.2048},
{0.4347,0.203},
{0.4398,0.2015},
{0.4421,0.1952},
{0.4457,0.1936},
{0.4472,0.1876},
{0.4468,0.183},
{0.4208,0.1784},
{0.4242,0.1694},
{0.4435,0.2142},
{0.4386,0.2089},
{0.4433,0.2066},
{0.4478,0.2113},
{0.4474,0.2046},
{0.4443,0.2},
{0.4337,0.2115},
{0.4393,0.2178},
{0.4458,0.2231},
{0.4495,0.2187},
{0.4534,0.2151},
{0.4516,0.2086},
{0.4506,0.2023},
{0.4477,0.1981},
{0.4354,0.2223},
{0.4292,0.215},
{0.4726,0.2248},
{0.4643,0.224},
{0.4676,0.2194},
{0.4757,0.22},
{0.4706,0.2154},
{0.4633,0.2141},
{0.4601,0.2178},
{0.4565,0.222},
{0.4789,0.2299},
{0.4813,0.2245},
{0.4839,0.2195},
{0.4783,0.2157},
{0.4723,0.2117},
{0.4654,0.2108},
{0.4593,0.2089},
{0.4568,0.2119},
{0.4531,0.2269},
{0.508,0.2161},
{0.4991,0.2202},
{0.5,0.2154},
{0.5079,0.2114},
{0.5006,0.2111},
{0.4935,0.2136},
{0.492,0.2181},
{0.4901,0.223},
{0.5184,0.2156},
{0.517,0.2104},
{0.5158,0.2059},
{0.5076,0.2074},
{0.5004,0.2073},
{0.4938,0.2097},
{0.4869,0.2111},
{0.486,0.2151},
{0.4885,0.2284},
{0.5376,0.1819},
{0.5422,0.1858},
{0.5344,0.1945},
{0.5309,0.1904},
{0.5235,0.1986},
{0.5259,0.203},
{0.549,0.1774},
{0.5433,0.1739},
{0.5385,0.1714},
{0.5337,0.1789},
{0.5279,0.1871},
{0.5214,0.195},
{0.5145,0.2021},
{0.5284,0.2082},
{0.5475,0.1672},
{0.5505,0.1614},
{0.5577,0.1631},
{0.554,0.1699},
{0.5612,0.1735},
{0.5681,0.1773},
{0.5726,0.1686},
{0.5654,0.1655},
{0.542,0.1652},
{0.5444,0.16},
{0.5603,0.1569},
{0.5523,0.1561},
{0.5458,0.1555},
{0.5398,0.1589},
{0.5378,0.1636},
{0.5616,0.1508},
{0.5532,0.1511},
{0.5464,0.1512},
{0.5409,0.1548},
{0.5365,0.158},
{0.5346,0.1624},
{0.5347,0.1693},
{0.5304,0.1765},
{0.5251,0.1843},
{0.5192,0.1919},
{0.513,0.1986},
{0.5068,0.2037},
{0.2197,0.9215},
{0.2202,0.9298},
{0.2114,0.9314},
{0.2107,0.9251},
{0.2285,0.9192},
{0.2285,0.9288},
{0.5694,0.1578},
{0.5704,0.1428},
{0.5611,0.1446},
{0.553,0.1459},
{0.5464,0.1467},
{0.5415,0.151},
{0.5375,0.1542},
{0.5351,0.1538},
{0.5341,0.1574},
{0.5323,0.1616},
{0.5318,0.1678},
{0.5277,0.1746},
{0.5228,0.182},
{0.5172,0.1892},
{0.5114,0.1956},
{0.5056,0.2004},
{0.4996,0.2039},
{0.2107,0.9381},
{0.2201,0.9381},
{0.0787,0.9212},
{0.0861,0.9243},
{0.0854,0.9315},
{0.078,0.9307},
{0.0861,0.9394},
{0.0781,0.9403},
{0.0715,0.9198},
{0.0712,0.9306},
{0.5373,0.11},
{0.5454,0.109},
{0.5545,0.1093},
{0.5645,0.1114},
{0.5677,0.101},
{0.572,0.0922},
{0.5772,0.0849},
{0.5764,0.079},
{0.5764,0.0729},
{0.5817,0.0726},
{0.586,0.0721},
{0.5895,0.0715},
{0.5925,0.0662},
{0.5338,0.1147},
{0.5409,0.1144},
{0.5489,0.1145},
{0.558,0.1158},
{0.5681,0.1179},
{0.5713,0.1074},
{0.5748,0.0982},
{0.5789,0.0905},
{0.583,0.0838},
{0.582,0.0783},
{0.5864,0.0774},
{0.5899,0.0764},
{0.5923,0.0709},
{0.595,0.066},
{0.5958,0.0617},
{0.5973,0.0576},
{0.5993,0.0538},
{0.5993,0.0581},
{0.6011,0.0544},
{0.6017,0.0502},
{0.6033,0.051},
{0.6044,0.0471},
{0.6059,0.048},
{0.6075,0.0444},
{0.6087,0.0454},
{0.6108,0.0422},
{0.6119,0.0433},
{0.6144,0.0402},
{0.6153,0.0413},
{0.6184,0.0384},
{0.6191,0.0395},
{0.6227,0.0366},
{0.6232,0.0377},
{0.6276,0.035},
{0.6279,0.0361},
{0.6238,0.0389},
{0.6283,0.0372},
{0.6334,0.0346},
{0.6336,0.0358},
{0.6399,0.0348},
{0.6399,0.0335},
{0.6475,0.0342},
{0.6477,0.0328},
{0.6555,0.0341},
{0.656,0.0326},
{0.6482,0.0316},
{0.6401,0.0324},
{0.6399,0.0335},
{0.6333,0.0335},
{0.537,0.1188},
{0.544,0.1193},
{0.5396,0.1233},
{0.5465,0.1245},
{0.552,0.1203},
{0.5613,0.1222},
{0.5645,0.1287},
{0.5718,0.1245},
{0.5788,0.1197},
{0.575,0.1136},
{0.5781,0.1039},
{0.5813,0.0958},
{0.5846,0.0889},
{0.5874,0.0825},
{0.5547,0.1263},
{0.5573,0.1323},
{0.5595,0.1384},
{0.5675,0.1355},
{0.5755,0.1314},
{0.5827,0.1259},
{0.589,0.1198},
{0.5852,0.1147},
{0.5816,0.1094},
{0.5842,0.1007},
{0.5868,0.0936},
{0.5889,0.0872},
{0.5908,0.0811},
{0.5487,0.1298},
{0.5507,0.1352},
{0.5521,0.1406},
{0.5944,0.114},
{0.5909,0.1099},
{0.5875,0.1055},
{0.5894,0.0979},
{0.5909,0.0915},
{0.5921,0.0855},
{0.5945,0.0841},
{0.5934,0.0799},
{0.5926,0.0755},
{0.5947,0.0704},
{0.5967,0.0703},
{0.5971,0.0661},
{0.598,0.062},
{0.6,0.0625},
{0.6012,0.0587},
{0.6028,0.0551},
{0.6048,0.0518},
{0.6072,0.0489},
{0.6098,0.0465},
{0.6128,0.0444},
{0.6162,0.0425},
{0.6198,0.0407},
{0.6205,0.0419},
{0.6244,0.0401},
{0.6288,0.0385},
{0.634,0.0371},
{0.6401,0.0361},
{0.6474,0.0356},
{0.6552,0.0357},
{0.6628,0.0362},
{0.6633,0.0345},
{0.6641,0.0328},
{0.6568,0.0312},
{0.5418,0.1279},
{0.5435,0.1327},
{0.5449,0.1374},
{0.5459,0.1421},
{0.5986,0.1089},
{0.5954,0.1056},
{0.5923,0.1019},
{0.5932,0.0954},
{0.5938,0.0895},
{0.596,0.0879},
{0.5977,0.0866},
{0.5964,0.0829},
{0.5954,0.079},
{0.5948,0.0748},
{0.5968,0.0744},
{0.5986,0.0744},
{0.5987,0.0704},
{0.5991,0.0664},
{0.601,0.0668},
{0.6018,0.063},
{0.603,0.0593},
{0.6045,0.0558},
{0.6063,0.0527},
{0.6084,0.0498},
{0.6109,0.0475},
{0.6138,0.0454},
{0.617,0.0436},
{0.6178,0.0448},
{0.6212,0.0431},
{0.625,0.0413},
{0.6293,0.0397},
{0.6343,0.0384},
{0.6403,0.0374},
{0.6474,0.0371},
{0.6549,0.0374},
{0.6623,0.038},
{0.6687,0.0391},
{0.6694,0.0372},
{0.6702,0.0353},
{0.6712,0.0335},
{0.6651,0.0313},
{0.6044,0.1074},
{0.6014,0.105},
{0.5985,0.1022},
{0.5957,0.099},
{0.5958,0.0932},
{0.5978,0.0914},
{0.5993,0.0901},
{0.6009,0.0892},
{0.5994,0.0859},
{0.5982,0.0823},
{0.5973,0.0785},
{0.599,0.0783},
{0.6006,0.0783},
{0.6003,0.0746},
{0.6004,0.0707},
{0.6021,0.0711},
{0.6028,0.0673},
{0.6037,0.0636},
{0.6047,0.06},
{0.606,0.0566},
{0.6076,0.0535},
{0.6096,0.0508},
{0.6119,0.0485},
{0.6147,0.0465},
{0.6329,0.3125},
{0.6278,0.3141},
{0.631,0.3072},
{0.6257,0.3093},
{0.7597,0.7816},
{0.7545,0.7797},
{0.7617,0.7685},
{0.767,0.7702},
{0.7687,0.7578},
{0.7743,0.7593},
{0.7528,0.7924},
{0.7477,0.7905},
{0.7589,0.7949},
{0.6164,0.2676},
{0.6128,0.2573},
{0.6092,0.2476},
{0.6059,0.2393},
{0.6026,0.2321},
{0.5994,0.2259},
{0.5956,0.2199},
{0.5947,0.2155},
{0.5903,0.2146},
{0.5935,0.2129},
{0.5893,0.2123},
{0.5922,0.211},
{0.5881,0.2105},
{0.5911,0.2093},
{0.587,0.2089},
{0.5903,0.2075},
{0.5864,0.2072},
{0.5835,0.208},
{0.583,0.2063},
{0.5862,0.2054},
{0.583,0.2045},
{0.5838,0.2026},
{0.5813,0.2012},
{0.5804,0.2031},
{0.6198,0.2774},
{0.6251,0.2729},
{0.6215,0.2634},
{0.6177,0.2535},
{0.614,0.244},
{0.6105,0.236},
{0.6073,0.2292},
{0.6042,0.2234},
{0.6015,0.2187},
{0.5997,0.2153},
{0.5982,0.2128},
{0.5969,0.2109},
{0.5958,0.2092},
{0.5949,0.2074},
{0.5942,0.2055},
{0.5899,0.2057},
{0.5866,0.2035},
{0.5855,0.2005},
{0.5832,0.199},
{0.5812,0.1971},
{0.5793,0.1993},
{0.5797,0.1948},
{0.5779,0.1968},
{0.6228,0.2857},
{0.6282,0.2811},
{0.6337,0.277},
{0.6303,0.269},
{0.6264,0.2598},
{0.6224,0.2501},
{0.6185,0.2409},
{0.615,0.2332},
{0.6119,0.2268},
{0.6091,0.2215},
{0.6067,0.2174},
{0.6048,0.2143},
{0.6032,0.212},
{0.6019,0.2101},
{0.6007,0.2084},
{0.5997,0.2066},
{0.5988,0.2046},
{0.5978,0.2026},
{0.5936,0.2035},
{0.5899,0.2039},
{0.5881,0.2017},
{0.5885,0.1982},
{0.5863,0.1964},
{0.5842,0.1943},
{0.5824,0.1922},
{0.6709,0.2471},
{0.6647,0.2387},
{0.6721,0.2362},
{0.6785,0.2448},
{0.6799,0.2341},
{0.6731,0.2252},
{0.6655,0.2274},
{0.6584,0.23},
{0.6579,0.2415},
{0.6638,0.2497},
{0.6687,0.2569},
{0.6762,0.2544},
{0.6842,0.2524},
{0.6866,0.2429},
{0.681,0.2236},
{0.6745,0.2154},
{0.6667,0.2169},
{0.6593,0.219},
{0.6524,0.2215},
{0.6519,0.2328},
{0.6518,0.2443},
{0.6574,0.2526},
{0.662,0.2598},
{0.6652,0.265},
{0.6721,0.2621},
{0.6799,0.2599},
{0.6884,0.2583},
{0.6925,0.2509},
{0.6238,0.3058},
{0.6219,0.3023},
{0.6199,0.2977},
{0.6251,0.2917},
{0.6306,0.2868},
{0.6363,0.2828},
{0.642,0.2792},
{0.6392,0.2734},
{0.6355,0.2655},
{0.6314,0.2564},
{0.627,0.247},
{0.6229,0.2382},
{0.6194,0.2307},
{0.6163,0.2245},
{0.6137,0.2195},
{0.6116,0.2156},
{0.6097,0.2126},
{0.6082,0.2104},
{0.6069,0.2086},
{0.6057,0.2069},
{0.6046,0.2051},
{0.6035,0.2031},
{0.6023,0.201},
{0.6008,0.1986},
{0.5964,0.2004},
{0.5927,0.2017},
{0.5902,0.2025},
{0.5908,0.2},
{0.5924,0.1958},
{0.5902,0.1933},
{0.588,0.1911},
{0.5858,0.1892},
{0.6306,0.3007},
{0.6287,0.2985},
{0.627,0.2957},
{0.6325,0.2907},
{0.6383,0.2868},
{0.6441,0.2834},
{0.6477,0.2757},
{0.6447,0.2699},
{0.6408,0.2622},
{0.6363,0.2533},
{0.6316,0.2442},
{0.6273,0.2355},
{0.6236,0.2282},
{0.6206,0.2221},
{0.6181,0.2171},
{0.6161,0.2132},
{0.6144,0.2103},
{0.6129,0.208},
{0.6117,0.2062},
{0.6105,0.2045},
{0.6093,0.2028},
{0.6081,0.2008},
{0.6067,0.1987},
{0.6052,0.1962},
{0.6036,0.1933},
{0.599,0.1959},
{0.5946,0.1981},
{0.659,0.2684},
{0.6533,0.2721},
{0.6457,0.2863},
{0.6469,0.2883},
{0.6479,0.2898},
{0.6489,0.2911},
{0.6499,0.2923},
{0.6511,0.2935},
{0.6524,0.2951},
{0.6541,0.2971},
{0.656,0.2995},
{0.6607,0.297},
{0.6627,0.2999},
{0.6649,0.3034},
{0.6247,0.2193},
{0.6287,0.2162},
{0.632,0.2225},
{0.6277,0.2254},
{0.636,0.2299},
{0.6408,0.2271},
{0.6365,0.2196},
{0.6331,0.2129},
{0.6262,0.2108},
{0.6222,0.2142},
{0.6315,0.2328},
{0.6362,0.2413},
{0.641,0.2384},
{0.6461,0.2356},
{0.6462,0.2243},
{0.6417,0.2167},
{0.638,0.2099},
{0.6303,0.207},
{0.6241,0.2064},
{0.6202,0.2101},
{0.6349,0.2036},
{0.628,0.2021},
{0.6321,0.1969},
{0.6259,0.1988},
{0.6224,0.2032},
{0.6463,0.2472},
{0.6412,0.2502},
{0.646,0.2589},
{0.6515,0.2557},
{0.6476,0.214},
{0.6436,0.2073},
{0.6404,0.2012},
{0.6559,0.263},
{0.6502,0.2664},
{0.6398,0.2895},
{0.6412,0.2912},
{0.6425,0.2925},
{0.6437,0.2935},
{0.6449,0.2945},
{0.6462,0.2957},
{0.6476,0.2973},
{0.6493,0.2992},
{0.6513,0.3015},
{0.6537,0.3043},
{0.6582,0.3023},
{0.6607,0.3056},
{0.6341,0.2933},
{0.6357,0.2948},
{0.6375,0.2955},
{0.6392,0.2959},
{0.6407,0.2967},
{0.642,0.2979},
{0.6435,0.2994},
{0.6453,0.3012},
{0.6474,0.3034},
{0.6499,0.306},
{0.6341,0.2991},
{0.6393,0.3003},
{0.6408,0.3017},
{0.7146,0.8336},
{0.7123,0.8329},
{0.7137,0.8297},
{0.7162,0.8302},
{0.7148,0.8267},
{0.7124,0.8265},
{0.7114,0.8292},
{0.7101,0.8322},
{0.7106,0.8364},
{0.7128,0.8373},
{0.7149,0.838},
{0.7171,0.8343},
{0.7189,0.8306},
{0.7175,0.8267},
{0.7093,0.8287},
{0.7079,0.8314},
{0.7084,0.8356},
{0.7087,0.8405},
{0.7106,0.8413},
{0.7123,0.842},
{0.7136,0.8426},
{0.717,0.8385},
{0.7197,0.8348},
{0.7219,0.8309},
{0.7229,0.8354},
{0.7256,0.8315},
{0.724,0.8267},
{0.7279,0.8272},
{0.7301,0.8325},
{0.7327,0.8282},
{0.7305,0.8221},
{0.7354,0.8232},
{0.7337,0.8159},
{0.7386,0.8172},
{0.7375,0.8086},
{0.7424,0.8101},
{0.7421,0.8001},
{0.7472,0.8019},
{0.7532,0.8043},
{0.7604,0.8075},
{0.7103,0.8262},
{0.2045,0.9463},
{0.204,0.9431},
{0.2063,0.9439},
{0.2067,0.9474},
{0.2025,0.9454},
{0.2018,0.9424},
{0.6253,0.1902},
{0.627,0.186},
{0.6284,0.1877},
{0.6267,0.192},
{0.6302,0.1894},
{0.6308,0.185},
{0.6292,0.1836},
{0.6241,0.1886},
{0.6258,0.1845},
{0.6217,0.1929},
{0.6229,0.1945},
{0.6242,0.1964},
{0.6287,0.1941},
{0.633,0.1907},
{0.6331,0.1861},
{0.206,0.9402},
{0.2036,0.9396},
{0.2014,0.9391},
{0.2,0.9416},
{0.1994,0.9386},
{0.2014,0.9353},
{0.1993,0.9351},
{0.1978,0.9381},
{0.1976,0.9349},
{0.1981,0.931},
{0.1998,0.931},
{0.1989,0.927},
{0.2007,0.9267},
{0.2019,0.9311},
{0.2028,0.9266},
{0.2018,0.9228},
{0.2039,0.9225},
{0.2029,0.9195},
{0.2049,0.9192},
{0.2061,0.9228},
{0.2071,0.9194},
{0.2082,0.9231},
{0.2091,0.9198},
{0.2098,0.9233},
{0.2107,0.9198},
{0.206,0.9361},
{0.2037,0.9357},
{0.2042,0.9313},
{0.2083,0.9408},
{0.2086,0.9448},
{0.2083,0.9366},
{0.2086,0.9321},
{0.2065,0.9317},
{0.2051,0.9269},
{0.2105,0.9415},
{0.2107,0.9458},
{0.2103,0.9371},
{0.2103,0.9323},
{0.2104,0.9275},
{0.2091,0.9275},
{0.2073,0.9272},
{0.7045,0.8484},
{0.7066,0.8446},
{0.7082,0.8454},
{0.7058,0.8491},
{0.7094,0.8461},
{0.7047,0.8438},
{0.7027,0.8476},
{0.7007,0.8507},
{0.7024,0.8515},
{0.7034,0.8523},
{0.7034,0.8523},
{0.7064,0.8499},
{0.7036,0.8533},
{0.7008,0.8466},
{0.7027,0.8427},
{0.6989,0.8498},
{0.7066,0.8396},
{0.7046,0.8386},
{0.7009,0.8415},
{0.6991,0.8453},
{0.6973,0.8484},
{0.6957,0.8504},
{0.6972,0.8517},
{0.7064,0.8347},
{0.7027,0.8375},
{0.6991,0.8403},
{0.6975,0.8439},
{0.696,0.8468},
{0.2107,0.9229},
{0.8268,0.32},
{0.8277,0.3203},
{0.8252,0.3238},
{0.8242,0.3238},
{0.8233,0.3281},
{0.8219,0.3285},
{0.8222,0.3329},
{0.8203,0.3339},
{0.8221,0.338},
{0.8197,0.3398},
{0.823,0.3421},
{0.8207,0.3466},
{0.8251,0.344},
{0.8265,0.3422},
{0.8248,0.3399},
{0.8221,0.338},
{0.8239,0.3363},
{0.8222,0.3329},
{0.8239,0.332},
{0.8233,0.3281},
{0.8247,0.3276},
{0.8252,0.3238},
{0.8264,0.3236},
{0.8239,0.3572},
{0.8239,0.3615},
{0.8222,0.3604},
{0.8221,0.3552},
{0.8248,0.3534},
{0.823,0.3508},
{0.8265,0.3506},
{0.8251,0.3484},
{0.8197,0.3539},
{0.8221,0.3552},
{0.8203,0.3598},
{0.8222,0.3604},
{0.8219,0.3647},
{0.8233,0.3649},
{0.8242,0.3686},
{0.8252,0.3686},
{0.8255,0.3589},
{0.8254,0.3627},
{0.8264,0.3553},
{0.8281,0.3523},
{0.83,0.3498},
{0.8285,0.3486},
{0.8273,0.3472},
{0.8244,0.3461},
{0.8273,0.3447},
{0.8269,0.3459},
{0.8284,0.3459},
{0.8289,0.3453},
{0.8271,0.3601},
{0.827,0.3638},
{0.828,0.3566},
{0.8298,0.3536},
{0.8318,0.3509},
{0.8334,0.3485},
{0.8316,0.3478},
{0.8301,0.3471},
{0.8289,0.3464},
{0.6235,0.7901},
{0.6244,0.7944},
{0.6226,0.7938},
{0.6218,0.7899},
{0.6208,0.7935},
{0.6202,0.7898},
{0.6218,0.786},
{0.6202,0.7862},
{0.6234,0.7859},
{0.8233,0.3649},
{0.8247,0.3656},
{0.6244,0.7859},
{0.6244,0.7905},
{0.4167,0.6141},
{0.4183,0.6137},
{0.4179,0.6179},
{0.4164,0.6179},
{0.4183,0.6217},
{0.4168,0.6214},
{0.827,0.3308},
{0.8254,0.3313},
{0.8262,0.3273},
{0.8278,0.3271},
{0.8279,0.3236},
{0.8295,0.3237},
{0.8297,0.3272},
{0.8314,0.324},
{0.8318,0.3275},
{0.8333,0.3247},
{0.834,0.3214},
{0.8358,0.3224},
{0.8371,0.3194},
{0.8388,0.3206},
{0.8374,0.3237},
{0.8402,0.3224},
{0.8418,0.3194},
{0.843,0.3215},
{0.8438,0.3243},
{0.8411,0.3249},
{0.8441,0.3282},
{0.8414,0.3282},
{0.8412,0.3321},
{0.8438,0.3327},
{0.8405,0.3359},
{0.8431,0.3376},
{0.8394,0.339},
{0.8418,0.3417},
{0.8456,0.3391},
{0.8444,0.3462},
{0.8408,0.3466},
{0.8418,0.3516},
{0.8456,0.353},
{0.8431,0.3554},
{0.8394,0.3548},
{0.8405,0.3578},
{0.8438,0.36},
{0.8412,0.3615},
{0.8441,0.3643},
{0.8414,0.3651},
{0.8411,0.3682},
{0.8438,0.3678},
{0.8255,0.3351},
{0.8271,0.3344},
{0.829,0.334},
{0.8289,0.3306},
{0.831,0.3306},
{0.8333,0.3309},
{0.8339,0.3281},
{0.8352,0.3256},
{0.8366,0.3265},
{0.8385,0.3257},
{0.8388,0.3284},
{0.8384,0.3316},
{0.838,0.3346},
{0.8371,0.3371},
{0.8377,0.3408},
{0.8398,0.3435},
{0.8383,0.3466},
{0.8398,0.3499},
{0.8377,0.3532},
{0.8371,0.3573},
{0.838,0.3597},
{0.8384,0.3626},
{0.8388,0.3655},
{0.8385,0.3681},
{0.8402,0.3705},
{0.8374,0.3699},
{0.8366,0.3676},
{0.8352,0.3686},
{0.8362,0.366},
{0.8339,0.3666},
{0.8333,0.3695},
{0.8318,0.3672},
{0.8314,0.37},
{0.8297,0.3674},
{0.831,0.3644},
{0.8289,0.3643},
{0.8278,0.3672},
{0.829,0.3609},
{0.8299,0.3575},
{0.8317,0.3544},
{0.8337,0.3516},
{0.8354,0.3489},
{0.8342,0.3463},
{0.8323,0.3461},
{0.8307,0.3459},
{0.8294,0.3459},
{0.829,0.3458},
{0.8264,0.3385},
{0.828,0.3377},
{0.8299,0.3371},
{0.8311,0.3338},
{0.8333,0.3337},
{0.8358,0.3312},
{0.8362,0.3285},
{0.2679,0.8001},
{0.2683,0.8024},
{0.2658,0.8026},
{0.2654,0.8001},
{0.2677,0.7976},
{0.2651,0.7977},
{0.2654,0.7954},
{0.268,0.7954},
{0.2699,0.7977},
{0.2702,0.7955},
{0.8281,0.3411},
{0.8298,0.3403},
{0.8317,0.3398},
{0.832,0.3367},
{0.834,0.3363},
{0.8356,0.3339},
{0.2701,0.8001},
{0.2702,0.8021},
{0.4184,0.5122},
{0.4174,0.513},
{0.4171,0.5115},
{0.4185,0.5106},
{0.4171,0.5165},
{0.4172,0.5147},
{0.4187,0.5141},
{0.4187,0.5163},
{0.2699,0.8035},
{0.2686,0.8042},
{0.4185,0.5135},
{0.418,0.5141},
{0.4181,0.5215},
{0.4181,0.5207},
{0.4186,0.5211},
{0.4188,0.5215},
{0.266,0.8049},
{0.621,0.2008},
{0.6197,0.1989},
{0.6185,0.1972},
{0.6148,0.2012},
{0.616,0.2028},
{0.6172,0.2047},
{0.6382,0.1957},
{0.6371,0.1908},
{0.6364,0.1865},
{0.6353,0.1825},
{0.6326,0.1821},
{0.6335,0.1787},
{0.6314,0.1784},
{0.6307,0.1748},
{0.6292,0.175},
{0.6272,0.1712},
{0.6263,0.1719},
{0.6228,0.1696},
{0.6229,0.1683},
{0.6186,0.1684},
{0.6182,0.1665},
{0.614,0.1686},
{0.6129,0.1662},
{0.6091,0.1702},
{0.6075,0.1673},
{0.6041,0.1733},
{0.602,0.1699},
{0.5964,0.1734},
{0.5988,0.1785},
{0.5921,0.1809},
{0.5907,0.177},
{0.5856,0.1811},
{0.587,0.1841},
{0.5817,0.1859},
{0.5831,0.1881},
{0.5791,0.1911},
{0.5804,0.1925},
{0.578,0.1966},
{0.5792,0.1971},
{0.5783,0.202},
{0.5791,0.2017},
{0.6186,0.2071},
{0.6188,0.19},
{0.6158,0.1939},
{0.6144,0.1921},
{0.6172,0.1887},
{0.613,0.1899},
{0.6094,0.1932},
{0.6108,0.1956},
{0.6122,0.1977},
{0.6172,0.1956},
{0.6203,0.1914},
{0.6227,0.1872},
{0.6211,0.1861},
{0.6194,0.1853},
{0.6179,0.185},
{0.616,0.187},
{0.6119,0.1872},
{0.6079,0.1903},
{0.6135,0.1995},
{0.6243,0.1833},
{0.6226,0.1825},
{0.6206,0.1821},
{0.6182,0.1827},
{0.6153,0.1846},
{0.6109,0.1841},
{0.6064,0.187},
{0.6017,0.19},
{0.5969,0.193},
{0.8375,0.3494},
{0.8357,0.3523},
{0.8337,0.3551},
{0.8356,0.3559},
{0.8361,0.3465},
{0.834,0.3585},
{0.832,0.3581},
{0.8355,0.3588},
{0.8311,0.3613},
{0.8333,0.3613},
{0.8356,0.3609},
{0.8356,0.3385},
{0.8357,0.3417},
{0.8337,0.3393},
{0.8337,0.3421},
{0.8354,0.3443},
{0.8375,0.3441},
{0.8361,0.3465},
{0.8342,0.3463},
{0.8334,0.3444},
{0.8355,0.3358},
{0.8333,0.3641},
{0.8358,0.3635},
{0.6962,0.8424},
{0.6975,0.8391},
{0.695,0.8451},
{0.7008,0.8364},
{0.6989,0.8355},
{0.6971,0.8349},
{0.6958,0.8383},
{0.7024,0.8329},
{0.7004,0.8322},
{0.7038,0.8302},
{0.7019,0.8296},
{0.7043,0.8337},
{0.7059,0.8308},
{0.7051,0.8279},
{0.7072,0.8283},
{0.6196,0.1706},
{0.6217,0.1703},
{0.623,0.173},
{0.6207,0.1733},
{0.6235,0.176},
{0.6212,0.1761},
{0.6234,0.1791},
{0.6254,0.1764},
{0.6252,0.1797},
{0.6267,0.1808},
{0.6167,0.1715},
{0.6177,0.1741},
{0.6182,0.1769},
{0.6212,0.1791},
{0.6184,0.1798},
{0.6149,0.1816},
{0.61,0.1809},
{0.605,0.1835},
{0.5998,0.1865},
{0.5948,0.1899},
{0.5924,0.1873},
{0.5895,0.1859},
{0.6139,0.1756},
{0.6093,0.1776},
{0.609,0.1745},
{0.6132,0.1728},
{0.6046,0.1764},
{0.6042,0.1799},
{0.6144,0.1786},
{0.5977,0.1824},
{0.5827,0.1771},
{0.5877,0.1718},
{0.5783,0.1727},
{0.5741,0.1803},
{0.5787,0.183},
{0.5762,0.1895},
{0.5759,0.1961},
{0.5768,0.2027},
{0.5719,0.1883},
{0.5728,0.1965},
{0.5752,0.2044},
{0.6121,0.162},
{0.6181,0.1631},
{0.6236,0.1661},
{0.6286,0.1701},
{0.6329,0.1745},
{0.6361,0.1745},
{0.6364,0.1788},
{0.6401,0.1791},
{0.6388,0.1828},
{0.6432,0.1831},
{0.6406,0.1866},
{0.6456,0.1868},
{0.6422,0.1905},
{0.6478,0.1903},
{0.644,0.1948},
{0.6501,0.1942},
{0.6466,0.1997},
{0.6531,0.1986},
{0.65,0.2053},
{0.6568,0.2037},
{0.6542,0.2117},
{0.6613,0.2098},
{0.6689,0.2085},
{0.7154,0.8433},
{0.7105,0.8476},
{0.7098,0.8467},
{0.7094,0.8461},
{0.7197,0.8392},
{0.7124,0.8489},
{0.7183,0.8444},
{0.7233,0.8403},
{0.7167,0.8507},
{0.7232,0.8461},
{0.7285,0.842},
{0.7271,0.8365},
{0.7326,0.8382},
{0.7357,0.8343},
{0.7385,0.83},
{0.7413,0.8251},
{0.7445,0.8192},
{0.7485,0.8123},
{0.7557,0.8155},
{0.7635,0.8196},
{0.7681,0.8117},
{0.7758,0.8167},
{0.788,0.8139},
{0.7995,0.8119},
{0.8099,0.811},
{0.8191,0.8106},
{0.8269,0.8087},
{0.8217,0.8182},
{0.8136,0.82},
{0.8171,0.8271},
{0.8085,0.8286},
{0.8131,0.835},
{0.821,0.831},
{0.8183,0.8388},
{0.8096,0.8419},
{0.8162,0.8455},
{0.8229,0.8471},
{0.8235,0.8404},
{0.7094,0.8562},
{0.7057,0.8541},
{0.7191,0.8579},
{0.7249,0.8528},
{0.7307,0.8485},
{0.7358,0.8447},
{0.5705,0.1998},
{0.7713,0.8244},
{0.7829,0.8225},
{0.7786,0.8298},
{0.7938,0.8213},
{0.8042,0.8205},
{0.7676,0.8308},
{0.7597,0.8262},
{0.775,0.8359},
{0.7848,0.8358},
{0.789,0.8292},
{0.799,0.829},
{0.7644,0.8362},
{0.7564,0.8318},
{0.7718,0.841},
{0.7812,0.8414},
{0.7906,0.842},
{0.7945,0.8361},
{0.8041,0.8361},
{0.8002,0.8424},
{0.8067,0.8476},
{0.8146,0.8509},
{0.8228,0.8525},
{0.8136,0.8558},
{0.8235,0.8575},
{0.8302,0.8525},
{0.8326,0.8579},
{0.825,0.8627},
{0.8367,0.864},
{0.8275,0.869},
{0.8409,0.8714},
{0.831,0.8769},
{0.8439,0.8804},
{0.8345,0.884},
{0.8443,0.8893},
{0.8406,0.8963},
{0.8588,0.8976},
{0.8559,0.9067},
{0.7518,0.8223},
{0.7485,0.828},
{0.7536,0.8365},
{0.7616,0.8407},
{0.769,0.8453},
{0.778,0.846},
{0.7873,0.8471},
{0.7969,0.8479},
{0.7457,0.8329},
{0.7509,0.8406},
{0.7589,0.8447},
{0.7663,0.849},
{0.7751,0.8499},
{0.7841,0.8514},
{0.794,0.853},
{0.8043,0.8527},
{0.9309,0.3272},
{0.7561,0.8482},
{0.7479,0.8443},
{0.7635,0.8523},
{0.7695,0.8563},
{0.7723,0.8533},
{0.7775,0.8579},
{0.7808,0.8549},
{0.7869,0.8608},
{0.7909,0.8575},
{0.8024,0.858},
{0.7528,0.8516},
{0.7443,0.8479},
{0.7606,0.8554},
{0.7667,0.8591},
{0.7713,0.863},
{0.7744,0.8605},
{0.7787,0.8655},
{0.7826,0.8634},
{0.7881,0.8701},
{0.7938,0.8682},
{0.801,0.8652},
{0.8131,0.861},
{0.8147,0.8674},
{0.8198,0.8761},
{0.8284,0.886},
{0.8329,0.9004},
{0.8202,0.8882},
{0.8213,0.9007},
{0.8109,0.8888},
{0.8101,0.8767},
{0.8017,0.8778},
{0.8012,0.8884},
{0.7943,0.8787},
{0.7921,0.8873},
{0.7875,0.879},
{0.7829,0.8715},
{0.7816,0.879},
{0.7784,0.8726},
{0.777,0.8789},
{0.7745,0.8737},
{0.7751,0.8674},
{0.7718,0.8693},
{0.7691,0.8714},
{0.7716,0.8751},
{0.7675,0.8738},
{0.7699,0.877},
{0.7429,0.8371},
{0.7398,0.8409},
{0.7397,0.8516},
{0.749,0.855},
{0.7574,0.8585},
{0.7636,0.8619},
{0.7683,0.8654},
{0.5611,0.6839},
{0.5576,0.6819},
{0.5539,0.68},
{0.5479,0.6861},
{0.5433,0.6842},
{0.539,0.682},
{0.7427,0.8623},
{0.7313,0.8598},
{0.7351,0.8555},
{0.7453,0.8585},
{0.73,0.8646},
{0.7422,0.8666},
{0.7524,0.8652},
{0.7544,0.8617},
{0.7164,0.8636},
{0.7004,0.8648},
{0.5463,0.676},
{0.55,0.6781},
{0.5548,0.6727},
{0.5514,0.6708},
{0.6349,0.3086},
{0.6365,0.3067},
{0.6387,0.3106},
{0.6373,0.3129},
{0.6335,0.3038},
{0.0979,0.9386},
{0.0978,0.9349},
{0.0993,0.9354},
{0.0993,0.9393},
{0.0993,0.9309},
{0.0978,0.9307},
{0.0954,0.9343},
{0.0955,0.9376},
{0.0993,0.9264},
{0.0978,0.9265},
{0.0953,0.9304},
{0.0925,0.9334},
{0.0927,0.9365},
{0.4009,0.9194},
{0.4023,0.9182},
{0.4034,0.9217},
{0.4019,0.9226},
{0.4044,0.9261},
{0.4027,0.9267},
{0.405,0.9307},
{0.4032,0.931},
{0.4052,0.9349},
{0.4033,0.9351},
{0.405,0.9387},
{0.4031,0.9387},
{0.4045,0.9419},
{0.4026,0.9418},
{0.4038,0.9446},
{0.402,0.9444},
{0.4001,0.942},
{0.3996,0.9446},
{0.3969,0.9445},
{0.3974,0.9421},
{0.3977,0.9393},
{0.3947,0.9417},
{0.395,0.9392},
{0.3924,0.9404},
{0.3928,0.9383},
{0.3954,0.9363},
{0.3934,0.9357},
{0.3914,0.9362},
{0.392,0.9339},
{0.3909,0.9341},
{0.3912,0.9318},
{0.3932,0.9315},
{0.3924,0.9291},
{0.3951,0.9299},
{0.3944,0.9269},
{0.3917,0.9273},
{0.3937,0.9246},
{0.397,0.9252},
{0.3962,0.9224},
{0.3996,0.9238},
{0.3987,0.9207},
{0.3977,0.9191},
{0.3998,0.9175},
{0.837,0.9074},
{0.8362,0.9104},
{0.8344,0.9097},
{0.8353,0.9067},
{0.0976,0.9229},
{0.0992,0.9225},
{0.8326,0.9121},
{0.8332,0.9087},
{0.8344,0.9097},
{0.8338,0.913},
{0.8322,0.9156},
{0.8335,0.9164},
{0.8321,0.9191},
{0.8333,0.9197},
{0.8321,0.9225},
{0.8333,0.9229},
{0.835,0.92},
{0.8352,0.9168},
{0.8335,0.9164},
{0.8356,0.9136},
{0.8338,0.913},
{0.4186,0.6343},
{0.4173,0.6341},
{0.4171,0.6303},
{0.4185,0.6306},
{0.4173,0.627},
{0.4186,0.6273},
{0.8363,0.9432},
{0.8352,0.9445},
{0.8344,0.9417},
{0.8355,0.9406},
{0.8337,0.9388},
{0.8348,0.9379},
{0.8332,0.9358},
{0.8343,0.9351},
{0.8328,0.9326},
{0.8339,0.9321},
{0.8325,0.9293},
{0.8336,0.9291},
{0.8334,0.926},
{0.8322,0.9259},
{0.8349,0.9231},
{0.8373,0.9202},
{0.8376,0.9171},
{0.838,0.9139},
{0.8386,0.9108},
{0.835,0.926},
{0.8372,0.9232},
{0.8398,0.9231},
{0.84,0.9201},
{0.8402,0.9171},
{0.8407,0.9139},
{0.8413,0.9109},
{0.8352,0.929},
{0.8372,0.9261},
{0.8398,0.926},
{0.8426,0.9256},
{0.8426,0.9226},
{0.8427,0.9196},
{0.843,0.9166},
{0.8434,0.9136},
{0.8439,0.9108},
{0.846,0.9127},
{0.8464,0.9102},
{0.8444,0.9083},
{0.8466,0.908},
{0.8484,0.9091},
{0.8484,0.9072},
{0.8364,0.9374},
{0.8359,0.9347},
{0.8355,0.9319},
{0.8377,0.9317},
{0.8374,0.9289},
{0.84,0.9288},
{0.8428,0.9286},
{0.8455,0.9282},
{0.8453,0.925},
{0.8453,0.9217},
{0.8454,0.9186},
{0.8457,0.9156},
{0.8371,0.94},
{0.8355,0.9406},
{0.8394,0.9396},
{0.8387,0.9371},
{0.8381,0.9344},
{0.8403,0.9316},
{0.8413,0.937},
{0.8407,0.9343},
{0.8435,0.9343},
{0.8442,0.937},
{0.8463,0.9344},
{0.8458,0.9314},
{0.8431,0.9315},
{0.8421,0.9395},
{0.8449,0.9396},
{0.847,0.9372},
{0.0922,0.923},
{0.0921,0.9203},
{0.095,0.9201},
{0.0951,0.923},
{0.0975,0.9198},
{0.0952,0.9264},
{0.0925,0.9298},
{0.0897,0.9322},
{0.0899,0.9349},
{0.0924,0.9262},
{0.0898,0.9292},
{0.0874,0.9306},
{0.0875,0.9327},
{0.0897,0.9233},
{0.0894,0.9208},
{0.0899,0.9261},
{0.0878,0.9281},
{0.0861,0.9283},
{0.0865,0.9261},
{0.0884,0.9261},
{0.0877,0.9242},
{0.398,0.936},
{0.3956,0.9331},
{0.398,0.9325},
{0.394,0.9335},
{0.3976,0.9287},
{0.4003,0.9276},
{0.4005,0.939},
{0.4008,0.9355},
{0.4007,0.9317},
{0.8458,0.9419},
{0.843,0.9419},
{0.8477,0.9399},
{0.8484,0.9422},
{0.4154,0.5273},
{0.4175,0.5276},
{0.4175,0.5302},
{0.4155,0.53},
{0.8482,0.9113},
{0.846,0.9127},
{0.848,0.9138},
{0.8457,0.9156},
{0.4165,0.6234},
{0.4166,0.6217},
{0.4185,0.6225},
{0.4186,0.6245},
{0.4164,0.6257},
{0.4186,0.627},
{0.5404,0.1387},
{0.5412,0.1429},
{0.5377,0.1433},
{0.5371,0.1395},
{0.5353,0.1435},
{0.5356,0.147},
{0.538,0.1471},
{0.5415,0.147},
{0.5393,0.1345},
{0.536,0.1356},
{0.5346,0.1399},
{0.5336,0.1437},
{0.534,0.1471},
{0.534,0.1504},
{0.5356,0.1505},
{0.538,0.1507},
{0.5335,0.1363},
{0.5328,0.1404},
{0.5317,0.137},
{0.5315,0.141},
{0.5323,0.1442},
{0.607,0.1021},
{0.606,0.1043},
{0.6032,0.1021},
{0.6045,0.1},
{0.6006,0.0995},
{0.6104,0.1023},
{0.6078,0.1006},
{0.6055,0.0985},
{0.602,0.0975},
{0.5981,0.0965},
{0.6032,0.096},
{0.5998,0.0946},
{0.6012,0.0932},
{0.5359,0.1261},
{0.5328,0.128},
{0.5306,0.1243},
{0.5335,0.122},
{0.5279,0.1207},
{0.5281,0.1259},
{0.5303,0.1293},
{0.5321,0.1328},
{0.5346,0.1318},
{0.5378,0.1302},
{0.5307,0.1182},
{0.5247,0.1174},
{0.5225,0.1196},
{0.5255,0.1226},
{0.5262,0.1271},
{0.5284,0.1303},
{0.5302,0.1336},
{0.5211,0.1145},
{0.5192,0.1169},
{0.5176,0.1189},
{0.5208,0.1213},
{0.5237,0.1241},
{0.525,0.1284},
{0.5271,0.1314},
{0.5289,0.1346},
{0.5303,0.1378},
{0.5155,0.1147},
{0.5142,0.1169},
{0.5166,0.1208},
{0.5197,0.123},
{0.5225,0.1255},
{0.5116,0.1131},
{0.5105,0.1155},
{0.5097,0.1176},
{0.5133,0.1189},
{0.516,0.1225},
{0.519,0.1245},
{0.5325,0.1571},
{0.5307,0.1611},
{0.5295,0.1667},
{0.5256,0.1731},
{0.5209,0.1801},
{0.5155,0.1871},
{0.5099,0.1932},
{0.5043,0.1977},
{0.4987,0.201},
{0.4928,0.2033},
{0.4935,0.2062},
{0.4871,0.2076},
{0.4802,0.2084},
{0.4797,0.2118},
{0.5335,0.1536},
{0.5324,0.1537},
{0.5313,0.157},
{0.5307,0.1611},
{0.5295,0.161},
{0.5279,0.166},
{0.5267,0.1657},
{0.524,0.1722},
{0.5141,0.1854},
{0.5194,0.1788},
{0.5087,0.1912},
{0.5033,0.1956},
{0.4978,0.1988},
{0.4923,0.2009},
{0.4865,0.2023},
{0.4868,0.2047},
{0.4804,0.2055},
{0.4739,0.2057},
{0.4734,0.2085},
{0.5229,0.1716},
{0.5183,0.178},
{0.5133,0.1843},
{0.5079,0.1899},
{0.5027,0.1941},
{0.4975,0.1971},
{0.4922,0.1992},
{0.4867,0.2006},
{0.4809,0.2014},
{0.4805,0.2032},
{0.4744,0.2034},
{0.4688,0.2028},
{0.4679,0.2051},
{0.4669,0.2077},
{0.4611,0.2061},
{0.4565,0.2034},
{0.4544,0.206},
{0.4625,0.2036},
{0.4582,0.2011},
{0.4638,0.2014},
{0.4597,0.199},
{0.4566,0.1959},
{0.4549,0.1978},
{0.4542,0.1923},
{0.4524,0.1941},
{0.4525,0.1885},
{0.4506,0.19},
{0.4494,0.186},
{0.4514,0.1846},
{0.449,0.1817},
{0.451,0.1805},
{0.4495,0.1767},
{0.4514,0.1758},
{0.453,0.1798},
{0.4534,0.1753},
{0.4528,0.1702},
{0.4547,0.1698},
{0.4554,0.1633},
{0.457,0.1632},
{0.4588,0.1558},
{0.4601,0.1559},
{0.4627,0.1483},
{0.4638,0.1486},
{0.4668,0.1415},
{0.4677,0.1419},
{0.4709,0.1358},
{0.4716,0.1365},
{0.453,0.2},
{0.4503,0.1961},
{0.4484,0.1918},
{0.4125,0.6827},
{0.4151,0.6875},
{0.4131,0.6887},
{0.4103,0.6837},
{0.4103,0.678},
{0.4081,0.6788},
{0.4087,0.6735},
{0.4064,0.674},
{0.4054,0.6693},
{0.4076,0.669},
{0.4052,0.6644},
{0.4074,0.6644},
{0.4061,0.6591},
{0.4083,0.6593},
{0.4081,0.6532},
{0.4105,0.6536},
{0.4109,0.6471},
{0.4085,0.6459},
{0.4059,0.6524},
{0.4165,0.6936},
{0.4184,0.6921},
{0.6923,0.043},
{0.6954,0.0418},
{0.697,0.0464},
{0.6939,0.0473},
{0.693,0.0379},
{0.6901,0.0393},
{0.6877,0.0404},
{0.6898,0.044},
{0.6913,0.0481},
{0.4475,0.1777},
{0.4492,0.1716},
{0.4523,0.1642},
{0.4092,0.6643},
{0.4102,0.6595},
{0.4124,0.6539},
{0.4134,0.6477},
{0.4139,0.6411},
{0.4114,0.6396},
{0.6821,0.03},
{0.6843,0.0336},
{0.6799,0.0317},
{0.6821,0.035},
{0.6852,0.0374},
{0.6876,0.0361},
{0.676,0.0288},
{0.6741,0.0305},
{0.678,0.0332},
{0.6805,0.0366},
{0.6834,0.039},
{0.668,0.0284},
{0.659,0.0286},
{0.407,0.9414},
{0.4096,0.9403},
{0.4099,0.9475},
{0.4074,0.949},
{0.4153,0.6482},
{0.4164,0.642},
{0.4184,0.6426},
{0.4123,0.9462},
{0.4122,0.9394},
{0.4115,0.9333},
{0.4089,0.9339},
{0.4062,0.9347},
{0.408,0.9282},
{0.4054,0.9288},
{0.4141,0.9451},
{0.4142,0.9386},
{0.4135,0.9328},
{0.4124,0.9275},
{0.4105,0.9278},
{0.4095,0.9228},
{0.4071,0.9231},
{0.4088,0.9182},
{0.4065,0.9183},
{0.4087,0.9139},
{0.4065,0.9137},
{0.4091,0.9097},
{0.407,0.9093},
{0.41,0.9056},
{0.408,0.9049},
{0.4114,0.9014},
{0.4094,0.9005},
{0.413,0.8971},
{0.4111,0.8959},
{0.4132,0.5559},
{0.4136,0.5469},
{0.4157,0.5485},
{0.4155,0.557},
{0.4174,0.5498},
{0.4175,0.5421},
{0.416,0.5404},
{0.4141,0.5384},
{0.4166,0.5334},
{0.4149,0.5311},
{0.4126,0.5644},
{0.4151,0.5652},
{0.4174,0.558},
{0.4107,0.5548},
{0.4114,0.5453},
{0.4099,0.5638},
{0.4115,0.5719},
{0.4141,0.5723},
{0.4171,0.5658},
{0.6724,0.0319},
{0.6665,0.0299},
{0.6765,0.0348},
{0.6792,0.0384},
{0.682,0.0406},
{0.6857,0.0418},
{0.6877,0.0452},
{0.6892,0.0491},
{0.4777,0.1244},
{0.4739,0.1289},
{0.4814,0.1206},
{0.4849,0.1174},
{0.4114,0.9226},
{0.4106,0.9182},
{0.4105,0.914},
{0.4109,0.91},
{0.4118,0.9061},
{0.413,0.9021},
{0.4145,0.8981},
{0.4116,0.5839},
{0.4092,0.5842},
{0.4103,0.5784},
{0.4128,0.5784},
{0.4088,0.5717},
{0.4077,0.5786},
{0.4066,0.5848},
{0.4107,0.5889},
{0.4084,0.5894},
{0.4126,0.5885},
{0.4135,0.5838},
{0.4148,0.5786},
{0.4161,0.5726},
{0.416,0.5786},
{0.4172,0.5729},
{0.4115,0.6019},
{0.4094,0.6032},
{0.4085,0.5988},
{0.4107,0.5978},
{0.4082,0.5943},
{0.4105,0.5935},
{0.4123,0.5929},
{0.4127,0.6059},
{0.4106,0.6075},
{0.4144,0.6047},
{0.4133,0.6009},
{0.4126,0.597},
{0.5076,0.1123},
{0.5035,0.1122},
{0.5067,0.1147},
{0.5028,0.1145},
{0.4995,0.1127},
{0.499,0.1149},
{0.5024,0.1165},
{0.5061,0.1168},
{0.4175,0.6119},
{0.416,0.6137},
{0.4142,0.6099},
{0.4158,0.6084},
{0.4122,0.6117},
{0.4988,0.1168},
{0.5022,0.1185},
{0.4987,0.1186},
{0.4988,0.1203},
{0.5021,0.1203},
{0.5056,0.1207},
{0.5057,0.1188},
{0.5093,0.1196},
{0.5127,0.1208},
{0.4953,0.1176},
{0.4954,0.1193},
{0.4956,0.1209},
{0.4959,0.1224},
{0.4989,0.122},
{0.5022,0.122},
{0.5055,0.1225},
{0.509,0.1214},
{0.5124,0.1226},
{0.4953,0.1158},
{0.492,0.1172},
{0.492,0.1189},
{0.4923,0.1205},
{0.4926,0.1219},
{0.493,0.1234},
{0.4898,0.1235},
{0.4903,0.1249},
{0.4869,0.1255},
{0.4875,0.1268},
{0.4838,0.1279},
{0.4845,0.1291},
{0.4805,0.1307},
{0.4813,0.1318},
{0.477,0.134},
{0.478,0.135},
{0.4735,0.1381},
{0.4745,0.1389},
{0.4699,0.1432},
{0.4712,0.1439},
{0.4665,0.1495},
{0.4679,0.1501},
{0.465,0.1569},
{0.4633,0.1565},
{0.4626,0.1637},
{0.4606,0.1634},
{0.4608,0.17},
{0.4587,0.1698},
{0.4597,0.175},
{0.4576,0.175},
{0.4594,0.1792},
{0.4572,0.1793},
{0.4576,0.1829},
{0.4597,0.1827},
{0.4585,0.1862},
{0.4605,0.1858},
{0.4599,0.1894},
{0.4618,0.1888},
{0.4618,0.1923},
{0.4636,0.1915},
{0.4858,0.1228},
{0.4889,0.1206},
{0.4893,0.1221},
{0.4863,0.1242},
{0.4887,0.119},
{0.4855,0.1213},
{0.4821,0.1241},
{0.4826,0.1255},
{0.4832,0.1267},
{0.4754,0.1321},
{0.4762,0.133},
{0.4725,0.1373},
{0.4798,0.1296},
{0.4791,0.1285},
{0.4748,0.1311},
{0.4786,0.1273},
{0.4136,0.9271},
{0.4145,0.9322},
{0.4687,0.1425},
{0.4677,0.1419},
{0.4651,0.149},
{0.4617,0.1561},
{0.4588,0.1632},
{0.4566,0.1697},
{0.4551,0.1794},
{0.4555,0.1832},
{0.4534,0.1838},
{0.4545,0.1874},
{0.4565,0.1867},
{0.4554,0.175},
{0.4561,0.191},
{0.458,0.1901},
{0.6754,0.0366},
{0.6781,0.0402},
{0.6744,0.0385},
{0.6772,0.0421},
{0.6809,0.0423},
{0.6842,0.0433},
{0.6861,0.0465},
{0.6875,0.0501},
{0.6736,0.0404},
{0.6799,0.0441},
{0.683,0.0449},
{0.6819,0.0465},
{0.6847,0.0478},
{0.4613,0.1974},
{0.4583,0.1944},
{0.4601,0.1933},
{0.4629,0.196},
{0.4651,0.1996},
{0.4698,0.201},
{0.4752,0.2016},
{0.3967,0.6454},
{0.3992,0.641},
{0.4003,0.6426},
{0.3978,0.6468},
{0.4016,0.6441},
{0.4039,0.6412},
{0.4027,0.6396},
{0.4052,0.6427},
{0.403,0.6455},
{0.3991,0.6481},
{0.4006,0.6494},
{0.3966,0.6535},
{0.3981,0.6545},
{0.3941,0.6597},
{0.3956,0.6606},
{0.3919,0.6665},
{0.3934,0.6671},
{0.3916,0.6736},
{0.3901,0.6733},
{0.3904,0.6798},
{0.3889,0.6797},
{0.3899,0.6858},
{0.3884,0.6859},
{0.39,0.6918},
{0.3885,0.6921},
{0.3908,0.6978},
{0.3893,0.6985},
{0.3923,0.7042},
{0.3909,0.705},
{0.3944,0.7104},
{0.3931,0.7115},
{0.3969,0.7161},
{0.3956,0.7173},
{0.3996,0.7207},
{0.3983,0.722},
{0.4023,0.724},
{0.401,0.7253},
{0.405,0.726},
{0.4037,0.7274},
{0.3999,0.7267},
{0.4026,0.7288},
{0.3992,0.7281},
{0.4019,0.7302},
{0.4044,0.7314},
{0.4052,0.73},
{0.686,0.0512},
{0.688,0.0543},
{0.6835,0.0492},
{0.6846,0.0524},
{0.4024,0.5283},
{0.4034,0.5266},
{0.4066,0.5293},
{0.4057,0.5311},
{0.4118,0.5276},
{0.4107,0.5291},
{0.4078,0.5276},
{0.409,0.5261},
{0.4046,0.5251},
{0.3893,0.6651},
{0.3915,0.6579},
{0.3927,0.6589},
{0.3905,0.6658},
{0.3952,0.6524},
{0.394,0.6511},
{0.3875,0.6725},
{0.3887,0.6729},
{0.4013,0.5211},
{0.4,0.5225},
{0.3966,0.5174},
{0.3979,0.5162},
{0.3934,0.5116},
{0.3922,0.5126},
{0.3954,0.5187},
{0.3989,0.5241},
{0.406,0.5236},
{0.4027,0.5199},
{0.3994,0.5152},
{0.3948,0.5107},
{0.3907,0.5055},
{0.3895,0.5063},
{0.3937,0.5042},
{0.3963,0.5098},
{0.3922,0.5048},
{0.3902,0.4991},
{0.3888,0.4995},
{0.3875,0.5},
{0.3875,0.4934},
{0.3863,0.4937},
{0.3871,0.487},
{0.3858,0.4871},
{0.3874,0.4801},
{0.3862,0.4799},
{0.3885,0.4725},
{0.3874,0.4721},
{0.3904,0.4648},
{0.3893,0.4642},
{0.3926,0.4576},
{0.3916,0.4568},
{0.3952,0.4515},
{0.3942,0.4505},
{0.3978,0.4471},
{0.3969,0.4459},
{0.4005,0.4439},
{0.3996,0.4427},
{0.4022,0.4405},
{0.4031,0.4418},
{0.4048,0.4389},
{0.4043,0.4376},
{0.4017,0.4393},
{0.3858,0.6862},
{0.387,0.6861},
{0.3871,0.6925},
{0.386,0.6929},
{0.388,0.6991},
{0.3875,0.6796},
{0.3863,0.6794},
{0.389,0.4932},
{0.3905,0.4931},
{0.3901,0.4872},
{0.3885,0.4871},
{0.3888,0.4804},
{0.3899,0.4731},
{0.3917,0.4656},
{0.3939,0.4586},
{0.3964,0.4527},
{0.399,0.4483},
{0.4017,0.4452},
{0.4043,0.4431},
{0.4057,0.4403},
{0.4073,0.4377},
{0.4082,0.4392},
{0.4098,0.4367},
{0.4107,0.4383},
{0.4094,0.4407},
{0.4118,0.44},
{0.3917,0.4987},
{0.3904,0.4808},
{0.3915,0.4737},
{0.3932,0.4665},
{0.3953,0.4597},
{0.3978,0.4539},
{0.4004,0.4496},
{0.4031,0.4466},
{0.4057,0.4445},
{0.4069,0.4417},
{0.4083,0.4432},
{0.4108,0.4422},
{0.3909,0.7135},
{0.3919,0.7125},
{0.3944,0.7185},
{0.3936,0.7196},
{0.3972,0.7234},
{0.3896,0.7059},
{0.3886,0.7067},
{0.3869,0.6997},
{0.4138,0.4423},
{0.4142,0.4391},
{0.4153,0.4399},
{0.415,0.4431},
{0.4168,0.4407},
{0.4173,0.4376},
{0.4158,0.4367},
{0.4121,0.5298},
{0.4122,0.5273},
{0.4136,0.5273},
{0.4136,0.5298},
{0.3964,0.7246},
{0.4189,0.4385},
{0.4185,0.4415},
{0.4166,0.4439},
{0.4183,0.4447},
{0.4164,0.4472},
{0.4182,0.4479},
{0.4162,0.4506},
{0.4181,0.4512},
{0.416,0.4542},
{0.418,0.4546},
{0.4158,0.4579},
{0.4178,0.4583},
{0.4156,0.4619},
{0.4176,0.4622},
{0.4154,0.466},
{0.4173,0.4662},
{0.4154,0.4702},
{0.4172,0.4702},
{0.4156,0.4743},
{0.4173,0.4742},
{0.416,0.4783},
{0.4177,0.478},
{0.4166,0.4821},
{0.4183,0.4815},
{0.4173,0.4856},
{0.4189,0.4848},
{0.4139,0.4745},
{0.4144,0.4787},
{0.413,0.4792},
{0.4125,0.4748},
{0.4137,0.4702},
{0.4122,0.4703},
{0.4136,0.4659},
{0.4121,0.4659},
{0.4137,0.4617},
{0.4121,0.4615},
{0.4139,0.4576},
{0.4123,0.4572},
{0.4141,0.4537},
{0.4126,0.4532},
{0.4144,0.45},
{0.413,0.4494},
{0.4147,0.4465},
{0.4134,0.4458},
{0.415,0.4827},
{0.4158,0.4865},
{0.5121,0.1243},
{0.5088,0.1233},
{0.6019,0.0748},
{0.6021,0.0785},
{0.4148,0.7888},
{0.4162,0.7885},
{0.4163,0.7928},
{0.4149,0.793},
{0.4163,0.7972},
{0.415,0.7972},
{0.4134,0.7932},
{0.4136,0.7973},
{0.4151,0.8015},
{0.4137,0.8014},
{0.4148,0.7848},
{0.4162,0.7844},
{0.4132,0.7852},
{0.4132,0.7891},
{0.6011,0.0855},
{0.6025,0.0887},
{0.6042,0.0917},
{0.6027,0.0923},
{0.606,0.0944},
{0.6046,0.095},
{0.6079,0.0968},
{0.6066,0.0975},
{0.6088,0.0995},
{0.6112,0.1012},
{0.5998,0.082},
{0.6014,0.0819},
{0.5328,0.1474},
{0.5328,0.1506},
{0.4137,0.775},
{0.4152,0.7742},
{0.4149,0.7775},
{0.4134,0.7782},
{0.4148,0.7811},
{0.4162,0.7805},
{0.4163,0.7769},
{0.4132,0.7816},
{0.0712,0.9589},
{0.0676,0.961},
{0.061,0.9565},
{0.0645,0.9493},
{0.0525,0.9534},
{0.0545,0.9452},
{0.0435,0.9513},
{0.0457,0.9437},
{0.0353,0.9495},
{0.0379,0.9431},
{0.0322,0.9426},
{0.0284,0.9466},
{0.0237,0.9414},
{0.0175,0.9452},
{0.0231,0.9507},
{0.0116,0.948},
{0.0176,0.9536},
{0.9188,0.7258},
{0.9237,0.721},
{0.9281,0.7236},
{0.9234,0.7298},
{0.9311,0.7253},
{0.9269,0.7327},
{0.9169,0.7359},
{0.9206,0.744},
{0.9084,0.7409},
{0.9107,0.7501},
{0.9159,0.7621},
{0.9091,0.7637},
{0.9113,0.7807},
{0.9051,0.7795},
{0.9002,0.7952},
{0.9065,0.7999},
{0.8943,0.8074},
{0.9017,0.82},
{0.9126,0.8012},
{0.9113,0.7807},
{0.916,0.7804},
{0.9159,0.7621},
{0.92,0.7605},
{0.9206,0.744},
{0.9242,0.7439},
{0.9122,0.7305},
{0.9039,0.7348},
{0.8948,0.7391},
{0.8992,0.7451},
{0.9018,0.7535},
{0.9011,0.7648},
{0.8982,0.7772},
{0.8938,0.7891},
{0.8883,0.7981},
{0.8818,0.802},
{0.8872,0.8127},
{0.8926,0.8248},
{0.905,0.8382},
{0.9111,0.8212},
{0.9174,0.8215},
{0.9175,0.8007},
{0.9139,0.7225},
{0.9189,0.7184},
{0.9707,0.5038},
{0.9702,0.5114},
{0.9702,0.5215},
{0.9704,0.5325},
{0.9647,0.5454},
{0.9707,0.5432},
{0.9271,0.7162},
{0.9223,0.714},
{0.9147,0.7162},
{0.9182,0.7121},
{0.9313,0.7182},
{0.0508,0.618},
{0.0455,0.6177},
{0.886,0.7438},
{0.8908,0.7489},
{0.8938,0.7557},
{0.8935,0.7647},
{0.891,0.7744},
{0.8877,0.7836},
{0.8832,0.7903},
{0.8773,0.7927},
{0.875,0.8025},
{0.88,0.8136},
{0.8852,0.8255},
{0.8899,0.8383},
{0.8972,0.8384},
{0.9011,0.8522},
{0.9086,0.8527},
{0.9128,0.8385},
{0.9197,0.839},
{0.884,0.7535},
{0.8785,0.7493},
{0.888,0.7573},
{0.8862,0.7632},
{0.8837,0.7711},
{0.8814,0.779},
{0.8797,0.7846},
{0.8746,0.7841},
{0.8709,0.7922},
{0.8688,0.8009},
{0.8737,0.8122},
{0.8789,0.8242},
{0.8837,0.837},
{0.8881,0.85},
{0.8941,0.8514},
{0.8979,0.8639},
{0.9048,0.8647},
{0.9123,0.8652},
{0.9163,0.8532},
{0.873,0.7459},
{0.8808,0.74},
{0.8672,0.753},
{0.873,0.7563},
{0.8794,0.76},
{0.8765,0.7677},
{0.8746,0.7758},
{0.9649,0.555},
{0.9646,0.562},
{0.0075,0.9408},
{0.0136,0.9381},
{0.0053,0.9323},
{0.0114,0.9298},
{0.0049,0.9225},
{0.011,0.9204},
{0.0204,0.9346},
{0.018,0.927},
{0.0173,0.9186},
{0.0127,0.9101},
{0.0065,0.9118},
{0.0015,0.9136},
{0.0,0.9243},
{0.0273,0.9306},
{0.0244,0.9232},
{0.0223,0.9177},
{0.0192,0.9095},
{0.0158,0.899},
{0.0095,0.9002},
{0.0302,0.9377},
{0.0342,0.9263},
{0.0302,0.9178},
{0.0253,0.9116},
{0.0227,0.8994},
{0.0197,0.8868},
{0.0132,0.8878},
{0.8679,0.7731},
{0.8696,0.7643},
{0.8683,0.7825},
{0.8648,0.7902},
{0.8618,0.7703},
{0.8635,0.7612},
{0.8623,0.78},
{0.4858,0.9244},
{0.4854,0.9152},
{0.4864,0.9056},
{0.489,0.8955},
{0.4927,0.885},
{0.4969,0.8739},
{0.5011,0.8622},
{0.8588,0.7588},
{0.8626,0.7507},
{0.0172,0.8747},
{0.0237,0.8738},
{0.9469,0.281},
{0.0347,0.8927},
{0.0296,0.903},
{0.0271,0.8877},
{0.0314,0.8746},
{0.0272,0.8601},
{0.0208,0.8609},
{0.0157,0.8624},
{0.0121,0.8764},
{0.041,0.8792},
{0.0428,0.8608},
{0.0347,0.8603},
{0.0302,0.8463},
{0.024,0.8471},
{0.0189,0.8483},
{0.0267,0.8337},
{0.0329,0.8331},
{0.0218,0.8346},
{0.029,0.8212},
{0.0351,0.821},
{0.0241,0.8219},
{0.0375,0.846},
{0.0401,0.8329},
{0.0423,0.8211},
{0.0367,0.8102},
{0.0307,0.8102},
{0.026,0.8109},
{0.0453,0.846},
{0.0478,0.833},
{0.0501,0.8216},
{0.0439,0.8108},
{0.0389,0.8008},
{0.0329,0.8006},
{0.0284,0.8013},
{0.0509,0.8609},
{0.0532,0.846},
{0.0559,0.8333},
{0.0582,0.8223},
{0.0516,0.8117},
{0.0459,0.8017},
{0.0426,0.7927},
{0.0368,0.7924},
{0.9012,0.8755},
{0.908,0.876},
{0.9155,0.8761},
{0.9199,0.8657},
{0.892,0.8628},
{0.8953,0.8747},
{0.8979,0.8852},
{0.9037,0.8858},
{0.9105,0.8859},
{0.9178,0.8856},
{0.9232,0.8763},
{0.0535,0.803},
{0.0494,0.7938},
{0.0567,0.7954},
{0.0554,0.787},
{0.0489,0.7857},
{0.9111,0.9022},
{0.9067,0.8947},
{0.9133,0.8945},
{0.9175,0.9017},
{0.9204,0.8938},
{0.901,0.8943},
{0.9056,0.9018},
{0.4396,0.5821},
{0.4317,0.5798},
{0.4375,0.5741},
{0.4452,0.5764},
{0.4438,0.5679},
{0.4512,0.57},
{0.4501,0.561},
{0.4572,0.5629},
{0.456,0.5531},
{0.4629,0.5548},
{0.461,0.5438},
{0.4679,0.5454},
{0.4648,0.5327},
{0.4717,0.5345},
{0.4787,0.5456},
{0.4828,0.5344},
{0.4739,0.522},
{0.4852,0.5224},
{0.4754,0.5084},
{0.487,0.5098},
{0.477,0.4943},
{0.4887,0.4969},
{0.4795,0.4802},
{0.4912,0.4842},
{0.4836,0.4668},
{0.4715,0.4744},
{0.4756,0.4602},
{0.4894,0.4542},
{0.4814,0.4469},
{0.4968,0.4424},
{0.489,0.4346},
{0.4755,0.4392},
{0.4832,0.4266},
{0.4981,0.4234},
{0.4924,0.4151},
{0.4779,0.4191},
{0.4873,0.4074},
{0.503,0.4048},
{0.4981,0.3968},
{0.4923,0.39},
{0.4813,0.4009},
{0.4842,0.3848},
{0.4729,0.3963},
{0.4347,0.5874},
{0.4265,0.5852},
{0.4464,0.5905},
{0.451,0.5852},
{0.4562,0.5794},
{0.4618,0.5727},
{0.4678,0.5647},
{0.4736,0.5557},
{0.4866,0.5567},
{0.4922,0.5454},
{0.4967,0.5338},
{0.4995,0.522},
{0.5014,0.5103},
{0.5032,0.4986},
{0.5057,0.4872},
{0.4953,0.472},
{0.501,0.4604},
{0.5082,0.4493},
{0.5058,0.4316},
{0.5086,0.4133},
{0.5201,0.405},
{0.515,0.3964},
{0.5104,0.3881},
{0.5049,0.3809},
{0.4972,0.3752},
{0.46,0.5945},
{0.4644,0.5893},
{0.4692,0.5833},
{0.4745,0.576},
{0.4806,0.567},
{0.4942,0.5701},
{0.5008,0.5585},
{0.507,0.5461},
{0.5121,0.5338},
{0.5152,0.5223},
{0.5175,0.5113},
{0.5198,0.5004},
{0.5222,0.4897},
{0.5095,0.476},
{0.5146,0.4653},
{0.5215,0.4552},
{0.517,0.4391},
{0.5162,0.4218},
{0.5272,0.4134},
{0.532,0.399},
{0.5283,0.3904},
{0.5243,0.382},
{0.5193,0.3743},
{0.4782,0.5945},
{0.4827,0.5882},
{0.4879,0.5802},
{0.5006,0.5856},
{0.5074,0.5745},
{0.5147,0.5619},
{0.5218,0.5487},
{0.5276,0.536},
{0.5313,0.5246},
{0.534,0.5142},
{0.5367,0.504},
{0.5414,0.4928},
{0.54,0.4809},
{0.525,0.4792},
{0.529,0.4692},
{0.5351,0.4599},
{0.5299,0.4456},
{0.5273,0.4296},
{0.538,0.421},
{0.5379,0.4069},
{0.5448,0.3962},
{0.5429,0.3876},
{0.5401,0.379},
{0.4909,0.6007},
{0.4953,0.5941},
{0.5113,0.5923},
{0.5187,0.5807},
{0.527,0.5677},
{0.5351,0.5543},
{0.5419,0.5415},
{0.5464,0.5304},
{0.5496,0.5205},
{0.5527,0.5113},
{0.5572,0.5036},
{0.5558,0.4889},
{0.5524,0.4804},
{0.5423,0.4717},
{0.474,0.5997},
{0.4869,0.606},
{0.4971,0.6136},
{0.5012,0.6082},
{0.5057,0.6012},
{0.5202,0.5997},
{0.5285,0.5881},
{0.5379,0.5751},
{0.5474,0.5617},
{0.5555,0.5489},
{0.5607,0.5378},
{0.5643,0.5283},
{0.5674,0.5199},
{0.5712,0.5128},
{0.565,0.498},
{0.5664,0.4858},
{0.5625,0.4788},
{0.561,0.4727},
{0.5527,0.4727},
{0.547,0.4634},
{0.5053,0.6219},
{0.5095,0.6162},
{0.5142,0.609},
{0.5276,0.6075},
{0.5367,0.596},
{0.5474,0.5832},
{0.559,0.5698},
{0.5689,0.5568},
{0.5746,0.5453},
{0.578,0.5355},
{0.5808,0.5274},
{0.5839,0.5204},
{0.5767,0.5067},
{0.5737,0.4936},
{0.5749,0.4828},
{0.5706,0.477},
{0.5678,0.4719},
{0.5659,0.4674},
{0.5608,0.4672},
{0.555,0.4658},
{0.5574,0.46},
{0.5545,0.455},
{0.543,0.4509},
{0.5398,0.4364},
{0.5503,0.4277},
{0.548,0.4136},
{0.546,0.403},
{0.5588,0.3977},
{0.559,0.3888},
{0.5577,0.3799},
{0.1175,0.1618},
{0.1289,0.1541},
{0.1303,0.1601},
{0.119,0.1675},
{0.1315,0.1677},
{0.1433,0.1604},
{0.1424,0.1526},
{0.141,0.1464},
{0.1278,0.1493},
{0.1398,0.1415},
{0.1535,0.1394},
{0.1523,0.1345},
{0.1658,0.1337},
{0.1648,0.129},
{0.1782,0.1292},
{0.1775,0.1245},
{0.1907,0.1253},
{0.1904,0.1208},
{0.2037,0.122},
{0.2036,0.1174},
{0.2171,0.1187},
{0.2173,0.114},
{0.2301,0.1157},
{0.2304,0.1107},
{0.2415,0.1129},
{0.2419,0.1077},
{0.2503,0.1105},
{0.2507,0.1051},
{0.2554,0.1085},
{0.2558,0.1029},
{0.1547,0.1456},
{0.1668,0.1398},
{0.1789,0.135},
{0.1914,0.1307},
{0.2042,0.1268},
{0.2175,0.1232},
{0.2302,0.12},
{0.2412,0.1172},
{0.2497,0.1149},
{0.2549,0.1132},
{0.1433,0.1702},
{0.1317,0.1774},
{0.1555,0.1632},
{0.1555,0.1535},
{0.1675,0.1475},
{0.1797,0.1421},
{0.1925,0.1369},
{0.2056,0.132},
{0.2187,0.1274},
{0.2308,0.1234},
{0.2408,0.1204},
{0.2485,0.1183},
{0.2534,0.1169},
{0.1205,0.1748},
{0.1211,0.1842},
{0.5211,0.6168},
{0.5163,0.6242},
{0.5338,0.6149},
{0.5434,0.6039},
{0.5553,0.5914},
{0.5688,0.5781},
{0.5844,0.5636},
{0.5882,0.5498},
{0.5906,0.5402},
{0.5927,0.5323},
{0.5948,0.5256},
{0.5878,0.5141},
{0.583,0.5013},
{0.5813,0.4896},
{0.5817,0.4801},
{0.5771,0.4752},
{0.5735,0.4709},
{0.5705,0.4671},
{0.527,0.6241},
{0.522,0.6316},
{0.539,0.6216},
{0.5321,0.6305},
{0.5272,0.6378},
{0.5177,0.6376},
{0.5232,0.6436},
{0.512,0.6301},
{0.5074,0.6346},
{0.5132,0.6421},
{0.1938,0.1448},
{0.1804,0.1509},
{0.2095,0.1376},
{0.2222,0.13},
{0.2328,0.1256},
{0.2415,0.1224},
{0.2469,0.1203},
{0.2501,0.1201},
{0.1677,0.1569},
{0.1806,0.1618},
{0.1946,0.1551},
{0.2088,0.1484},
{0.2225,0.1419},
{0.2237,0.1348},
{0.1672,0.1683},
{0.181,0.1742},
{0.1961,0.167},
{0.2107,0.1591},
{0.2244,0.1501},
{0.2366,0.1407},
{0.235,0.1353},
{0.3951,0.8938},
{0.4007,0.8913},
{0.3996,0.9028},
{0.3933,0.9061},
{0.3977,0.9139},
{0.4032,0.9113},
{0.4047,0.9002},
{0.4054,0.8888},
{0.4011,0.8792},
{0.3963,0.8809},
{0.289,0.6687},
{0.283,0.67},
{0.2788,0.6576},
{0.285,0.6554},
{0.2739,0.6459},
{0.2803,0.6433},
{0.2946,0.6515},
{0.2897,0.6385},
{0.2746,0.6318},
{0.2836,0.6265},
{0.3013,0.6326},
{0.2947,0.6196},
{0.3147,0.6263},
{0.3074,0.612},
{0.3289,0.6218},
{0.3222,0.6042},
{0.3394,0.6087},
{0.3432,0.6216},
{0.3526,0.6118},
{0.3498,0.6035},
{0.3382,0.6001},
{0.2924,0.6846},
{0.2865,0.683},
{0.3023,0.6796},
{0.2985,0.6655},
{0.3108,0.6618},
{0.3066,0.6469},
{0.3202,0.6423},
{0.3345,0.6387},
{0.3486,0.6369},
{0.3566,0.623},
{0.3636,0.6131},
{0.3593,0.6049},
{0.7053,0.146},
{0.3218,0.1149},
{0.3127,0.115},
{0.3151,0.1078},
{0.3238,0.108},
{0.3177,0.1002},
{0.3094,0.0996},
{0.3066,0.1075},
{0.3037,0.115},
{0.3105,0.1218},
{0.3202,0.1214},
{0.3299,0.1214},
{0.3309,0.1151},
{0.3322,0.1084},
{0.326,0.1006},
{0.3204,0.0921},
{0.3121,0.0916},
{0.3037,0.091},
{0.3011,0.099},
{0.2983,0.1068},
{0.2953,0.1145},
{0.3011,0.1222},
{0.3087,0.1282},
{0.319,0.1275},
{0.3294,0.1273},
{0.3392,0.1225},
{0.3395,0.116},
{0.3403,0.109},
{0.3417,0.1016},
{0.3341,0.1011},
{0.3285,0.0927},
{0.3229,0.0836},
{0.3145,0.0832},
{0.306,0.0828},
{0.2974,0.0825},
{0.2954,0.0904},
{0.2931,0.0981},
{0.2904,0.1057},
{0.2876,0.113},
{0.2925,0.1217},
{0.2988,0.1288},
{0.3073,0.1342},
{0.3182,0.1333},
{0.3291,0.1331},
{0.3393,0.1287},
{0.3479,0.124},
{0.3476,0.1171},
{0.3479,0.1097},
{0.3491,0.102},
{0.3512,0.0939},
{0.3439,0.0936},
{0.3364,0.0931},
{0.3312,0.0841},
{0.3254,0.0746},
{0.3167,0.0744},
{0.3079,0.0743},
{0.2991,0.0744},
{0.355,0.118},
{0.3556,0.1254},
{0.3615,0.1184},
{0.3616,0.1106},
{0.3551,0.1103},
{0.356,0.1024},
{0.3582,0.0943},
{0.3611,0.0859},
{0.354,0.0854},
{0.3467,0.085},
{0.3391,0.0846},
{0.3338,0.075},
{0.3275,0.0652},
{0.3186,0.0653},
{0.3096,0.0655},
{0.3005,0.0659},
{0.3485,0.1306},
{0.3565,0.1322},
{0.362,0.1258},
{0.3627,0.1026},
{0.365,0.0946},
{0.3681,0.0865},
{0.3419,0.0754},
{0.3362,0.0653},
{0.3446,0.0656},
{0.3383,0.055},
{0.3294,0.0551},
{0.3571,0.0765},
{0.3496,0.0759},
{0.3604,0.0671},
{0.3526,0.0662},
{0.3553,0.056},
{0.3469,0.0553},
{0.34,0.0446},
{0.3308,0.045},
{0.3215,0.0458},
{0.3203,0.0556},
{0.311,0.0562},
{0.3017,0.057},
{0.2929,0.0571},
{0.2918,0.0655},
{0.2839,0.0634},
{0.2849,0.0556},
{0.2937,0.0485},
{0.2859,0.0478},
{0.2782,0.0517},
{0.2795,0.0448},
{0.2733,0.0447},
{0.2751,0.0388},
{0.2814,0.0385},
{0.2776,0.0335},
{0.2724,0.0309},
{0.2755,0.0266},
{0.2815,0.0293},
{0.2799,0.0229},
{0.2749,0.0191},
{0.2796,0.0162},
{0.2756,0.0119},
{0.2861,0.0201},
{0.2943,0.0247},
{0.3031,0.0228},
{0.3127,0.0209},
{0.3224,0.0193},
{0.3218,0.0123},
{0.3317,0.0111},
{0.3417,0.0104},
{0.3516,0.0105},
{0.3615,0.0116},
{0.3712,0.0134},
{0.3808,0.0158},
{0.3901,0.0185},
{0.3992,0.0214},
{0.4075,0.0245},
{0.4067,0.0313},
{0.4049,0.0387},
{0.4025,0.0465},
{0.3645,0.0772},
{0.368,0.0682},
{0.3714,0.0586},
{0.3634,0.0571},
{0.3661,0.0471},
{0.3576,0.0457},
{0.3489,0.0448},
{0.3412,0.0346},
{0.3318,0.0351},
{0.3223,0.0362},
{0.3127,0.0375},
{0.3121,0.0468},
{0.3026,0.048},
{0.7587,0.3374},
{0.7597,0.3454},
{0.7514,0.3432},
{0.7501,0.3355},
{0.3756,0.0694},
{0.3718,0.0781},
{0.3794,0.0602},
{0.3828,0.0509},
{0.3744,0.0489},
{0.377,0.0394},
{0.3683,0.0373},
{0.3594,0.0357},
{0.3504,0.0347},
{0.3419,0.0253},
{0.3323,0.026},
{0.3226,0.0272},
{0.3129,0.0288},
{0.3034,0.0306},
{0.3032,0.0391},
{0.2944,0.0402},
{0.2871,0.0403},
{0.2834,0.0337},
{0.2877,0.0333},
{0.2871,0.0266},
{0.3699,0.0282},
{0.3607,0.0264},
{0.3514,0.0254},
{0.342,0.0173},
{0.3322,0.018},
{0.2947,0.0322},
{0.3857,0.0418},
{0.388,0.0332},
{0.379,0.0305},
{0.3802,0.0227},
{0.3709,0.0203},
{0.3614,0.0184},
{0.3518,0.0174},
{0.3895,0.0255},
{0.3986,0.0284},
{0.397,0.0361},
{0.3945,0.0444},
{0.3912,0.0532},
{0.9674,0.6086},
{0.9673,0.6164},
{0.9612,0.6155},
{0.9607,0.6073},
{0.9538,0.6147},
{0.9532,0.6064},
{0.9604,0.5984},
{0.9527,0.5975},
{0.945,0.606},
{0.9446,0.5973},
{0.936,0.5974},
{0.9364,0.6058},
{0.6914,0.7571},
{0.6903,0.7639},
{0.6854,0.7592},
{0.6864,0.7514},
{0.6792,0.7539},
{0.6939,0.7678},
{0.695,0.7616},
{0.6923,0.7521},
{0.6874,0.7454},
{0.6798,0.745},
{0.6719,0.7481},
{0.6914,0.7744},
{0.6878,0.7806},
{0.6805,0.7379},
{0.6719,0.7381},
{0.6723,0.7301},
{0.6632,0.731},
{0.6635,0.7419},
{0.9602,0.5892},
{0.9673,0.5907},
{0.9674,0.6},
{0.9673,0.5813},
{0.9601,0.58},
{0.9525,0.5885},
{0.9674,0.5719},
{0.9601,0.5712},
{0.9524,0.5796},
{0.9444,0.5884},
{0.6543,0.7353},
{0.654,0.7239},
{0.6447,0.7284},
{0.6446,0.7407},
{0.6634,0.7223},
{0.6543,0.7146},
{0.6446,0.7167},
{0.6349,0.7213},
{0.6345,0.7336},
{0.6451,0.7071},
{0.6352,0.7095},
{0.6362,0.6998},
{0.6262,0.7025},
{0.6252,0.714},
{0.9361,0.5889},
{0.9364,0.5808},
{0.9445,0.58},
{0.2854,0.0962},
{0.2874,0.0889},
{0.9526,0.5715},
{0.945,0.5725},
{0.769,0.3554},
{0.768,0.3476},
{0.7761,0.3495},
{0.7767,0.3576},
{0.7839,0.3595},
{0.7835,0.351},
{0.7757,0.341},
{0.7674,0.3394},
{0.761,0.3529},
{0.7705,0.3622},
{0.7778,0.3649},
{0.7845,0.3674},
{0.3717,0.0949},
{0.3691,0.1026},
{0.3676,0.1102},
{0.367,0.1176},
{0.7756,0.3327},
{0.7669,0.3314},
{0.3791,0.0791},
{0.6558,0.7091},
{0.6649,0.7172},
{0.7834,0.3423},
{0.7834,0.3338},
{0.7755,0.3251},
{0.7834,0.3259},
{0.79,0.3344},
{0.79,0.3265},
{0.7832,0.3194},
{0.7895,0.3201},
{0.79,0.3429},
{0.6469,0.7012},
{0.6386,0.6937},
{0.2745,0.1054},
{0.2807,0.1101},
{0.2784,0.1163},
{0.2726,0.111},
{0.2831,0.1033},
{0.2764,0.0991},
{0.2688,0.0984},
{0.2704,0.0925},
{0.2783,0.0925},
{0.9531,0.5644},
{0.9604,0.5632},
{0.285,0.1198},
{0.29,0.1283},
{0.2971,0.1348},
{0.3063,0.1411},
{0.3177,0.1402},
{0.3293,0.14},
{0.3397,0.1345},
{0.2826,0.1259},
{0.2763,0.1218},
{0.2881,0.1341},
{0.2954,0.1416},
{0.3053,0.1504},
{0.3176,0.1497},
{0.3297,0.1496},
{0.3404,0.1415},
{0.3493,0.1366},
{0.3575,0.1383},
{0.3629,0.1326},
{0.6352,0.6825},
{0.6298,0.6754},
{0.6351,0.6728},
{0.6398,0.6805},
{0.6419,0.6902},
{0.6458,0.6886},
{0.6247,0.6797},
{0.6312,0.6864},
{0.628,0.6928},
{0.6179,0.6957},
{0.616,0.7067},
{0.6144,0.7181},
{0.6243,0.7259},
{0.6206,0.6863},
{0.6103,0.6895},
{0.6075,0.6999},
{0.6052,0.7106},
{0.6254,0.6688},
{0.6192,0.6736},
{0.614,0.6804},
{0.6036,0.684},
{0.6,0.6937},
{0.597,0.7036},
{0.6221,0.663},
{0.6147,0.6683},
{0.6083,0.6753},
{0.598,0.6794},
{0.5937,0.6885},
{0.5901,0.6977},
{0.6318,0.6657},
{0.6296,0.6594},
{0.6197,0.6581},
{0.6112,0.6639},
{0.6036,0.6711},
{0.5932,0.6754},
{0.5884,0.6841},
{0.5845,0.6927},
{0.6378,0.6643},
{0.6404,0.6717},
{0.6364,0.6576},
{0.6362,0.6517},
{0.6284,0.654},
{0.6181,0.6535},
{0.6082,0.6598},
{0.5995,0.6672},
{0.5888,0.6716},
{0.5839,0.6803},
{0.5798,0.6885},
{0.5699,0.6659},
{0.5743,0.6665},
{0.5717,0.6734},
{0.5681,0.672},
{0.5685,0.6799},
{0.5719,0.6822},
{0.5756,0.6751},
{0.5793,0.6671},
{0.5758,0.6587},
{0.5705,0.6595},
{0.566,0.6601},
{0.5661,0.6654},
{0.5646,0.6707},
{0.5651,0.6779},
{0.5756,0.685},
{0.5797,0.6773},
{0.5843,0.6686},
{0.5822,0.6581},
{0.5762,0.6499},
{0.584,0.6475},
{0.5909,0.6575},
{0.5929,0.6447},
{0.5852,0.6359},
{0.5953,0.632},
{0.6032,0.6409},
{0.6052,0.6298},
{0.5993,0.618},
{0.6104,0.6171},
{0.6129,0.6284},
{0.6194,0.6202},
{0.629,0.6074},
{0.619,0.6027},
{0.6405,0.5918},
{0.631,0.5869},
{0.6525,0.5741},
{0.644,0.5698},
{0.622,0.582},
{0.6361,0.5655},
{0.6558,0.5519},
{0.6483,0.5486},
{0.6655,0.533},
{0.6582,0.5308},
{0.6724,0.5129},
{0.6653,0.5113},
{0.6767,0.4924},
{0.6696,0.4907},
{0.6789,0.4719},
{0.6713,0.4693},
{0.6801,0.4539},
{0.6698,0.4454},
{0.6815,0.4405},
{0.6725,0.4308},
{0.6583,0.4276},
{0.6613,0.4182},
{0.6455,0.4134},
{0.6424,0.4219},
{0.654,0.4358},
{0.5618,0.6762},
{0.5583,0.6745},
{0.5579,0.668},
{0.5546,0.6664},
{0.5483,0.6686},
{0.5515,0.6644},
{0.5562,0.6628},
{0.5532,0.6612},
{0.5956,0.6631},
{0.761,0.8648},
{0.7657,0.868},
{0.7641,0.871},
{0.7593,0.8681},
{0.5612,0.6694},
{0.5593,0.6639},
{0.5626,0.6647},
{0.5624,0.6603},
{0.5592,0.6602},
{0.3035,0.7278},
{0.3039,0.7315},
{0.3007,0.7298},
{0.3005,0.7262},
{0.2976,0.7256},
{0.2981,0.7236},
{0.2947,0.7184},
{0.2963,0.7183},
{0.2988,0.7203},
{0.2971,0.7129},
{0.294,0.7097},
{0.2968,0.7046},
{0.2925,0.6987},
{0.2995,0.6974},
{0.3066,0.6931},
{0.3168,0.691},
{0.3143,0.6767},
{0.3282,0.6751},
{0.3251,0.6589},
{0.34,0.6562},
{0.3543,0.6528},
{0.3676,0.6494},
{0.3617,0.6359},
{0.3681,0.6234},
{0.3977,0.8558},
{0.4009,0.8544},
{0.4011,0.8666},
{0.3972,0.8678},
{0.4054,0.8769},
{0.405,0.8642},
{0.4044,0.8518},
{0.4006,0.844},
{0.398,0.8461},
{0.3954,0.8554},
{0.3942,0.8666},
{0.3909,0.8815},
{0.3982,0.8393},
{0.4007,0.8363},
{0.6793,0.1736},
{0.6735,0.18},
{0.2861,0.3829},
{0.2897,0.3675},
{0.3093,0.3724},
{0.3059,0.3885},
{0.3293,0.3752},
{0.3318,0.3583},
{0.3119,0.3557},
{0.2923,0.3515},
{0.2716,0.3618},
{0.2679,0.3762},
{0.2624,0.3905},
{0.2811,0.3984},
{0.3013,0.4046},
{0.3261,0.3916},
{0.3459,0.3909},
{0.3487,0.3747},
{0.351,0.358},
{0.3336,0.3405},
{0.3139,0.3381},
{0.2944,0.3345},
{0.2741,0.3468},
{0.256,0.3566},
{0.252,0.3695},
{0.2461,0.3824},
{0.238,0.3961},
{0.2549,0.4055},
{0.2743,0.4143},
{0.2953,0.4211},
{0.3221,0.408},
{0.3426,0.4071},
{0.362,0.4031},
{0.3645,0.3876},
{0.3669,0.372},
{0.369,0.356},
{0.3527,0.3404},
{0.3351,0.3213},
{0.3157,0.3192},
{0.2964,0.3161},
{0.276,0.3307},
{0.2581,0.3431},
{0.2437,0.3533},
{0.2396,0.3642},
{0.2331,0.3753},
{0.2245,0.3876},
{0.2145,0.4},
{0.2284,0.4095},
{0.246,0.4198},
{0.2663,0.4293},
{0.2884,0.4367},
{0.3831,0.3684},
{0.3849,0.3534},
{0.3704,0.339},
{0.3537,0.3214},
{0.3359,0.3008},
{0.3171,0.2989},
{0.2984,0.2962},
{0.2782,0.313},
{0.2596,0.3281},
{0.2461,0.3278},
{0.2453,0.3415},
{0.2362,0.3514},
{0.2306,0.358},
{0.2231,0.3675},
{0.2137,0.3789},
{0.2033,0.3909},
{0.1926,0.402},
{0.204,0.4115},
{0.2182,0.4215},
{0.3967,0.3649},
{0.3983,0.3513},
{0.3862,0.3372},
{0.371,0.3204},
{0.354,0.301},
{0.3362,0.2787},
{0.3182,0.2771},
{0.3001,0.2749},
{0.2805,0.2937},
{0.2642,0.2922},
{0.2617,0.3111},
{0.2479,0.3113},
{0.2359,0.3134},
{0.2343,0.33},
{0.2347,0.343},
{0.2251,0.3485},
{0.2155,0.3575},
{0.205,0.3693},
{0.194,0.3818},
{0.1831,0.3929},
{0.3813,0.3828},
{0.3956,0.3779},
{0.4069,0.3629},
{0.4083,0.3511},
{0.4096,0.3374},
{0.3995,0.3364},
{0.3865,0.3194},
{0.3708,0.3005},
{0.3536,0.2792},
{0.3359,0.2552},
{0.3187,0.2538},
{0.3015,0.2523},
{0.2828,0.273},
{0.2669,0.272},
{0.2533,0.2725},
{0.2505,0.2927},
{0.2385,0.2943},
{0.2276,0.2964},
{0.2245,0.317},
{0.223,0.3351},
{0.2091,0.3427},
{0.1966,0.3596},
{0.1853,0.3728},
{0.1745,0.384},
{0.1644,0.3932},
{0.1729,0.4023},
{0.3797,0.3974},
{0.395,0.3911},
{0.4066,0.374},
{0.4126,0.3618},
{0.4156,0.3536},
{0.4175,0.3408},
{0.4177,0.3241},
{0.4096,0.3208},
{0.3996,0.3192},
{0.3986,0.3001},
{0.3858,0.2999},
{0.3697,0.279},
{0.3524,0.2558},
{0.3349,0.2301},
{0.3188,0.2291},
{0.3025,0.2283},
{0.2849,0.2511},
{0.2695,0.2506},
{0.2561,0.2515},
{0.244,0.2531},
{0.2414,0.274},
{0.2305,0.2756},
{0.22,0.2766},
{0.2171,0.2975},
{0.2135,0.319},
{0.1963,0.3356},
{0.187,0.3512},
{0.1763,0.3641},
{0.1657,0.375},
{0.1558,0.384},
{0.3965,0.2796},
{0.3842,0.279},
{0.3677,0.2562},
{0.3504,0.231},
{0.3335,0.2052},
{0.3185,0.2046},
{0.3033,0.2045},
{0.2883,0.2049},
{0.2867,0.228},
{0.2718,0.2285},
{0.2584,0.2302},
{0.246,0.2326},
{0.234,0.2354},
{0.2327,0.255},
{0.2216,0.2567},
{0.2101,0.2575},
{0.2093,0.2764},
{0.2067,0.2963},
{0.2027,0.3167},
{0.1858,0.3289},
{0.1771,0.3434},
{0.1671,0.3557},
{0.1567,0.3661},
{0.1469,0.3748},
{0.3934,0.2579},
{0.3815,0.2568},
{0.3648,0.232},
{0.3614,0.2079},
{0.3479,0.2063},
{0.3454,0.1837},
{0.332,0.1824},
{0.3181,0.182},
{0.3039,0.1823},
{0.2896,0.1828},
{0.2755,0.1846},
{0.2738,0.2063},
{0.2604,0.2092},
{0.2475,0.2129},
{0.2346,0.2166},
{0.2213,0.2203},
{0.2218,0.2381},
{0.2091,0.2403},
{0.1986,0.2577},
{0.1986,0.2751},
{0.1965,0.2935},
{0.1922,0.3118},
{0.1763,0.3221},
{0.1679,0.336},
{0.1581,0.3478},
{0.1475,0.3576},
{0.1377,0.3657},
{0.1389,0.3501},
{0.1271,0.3565},
{0.1315,0.3445},
{0.1219,0.3497},
{0.2911,0.164},
{0.3045,0.1637},
{0.2768,0.1627},
{0.2629,0.1716},
{0.2621,0.1891},
{0.2488,0.1943},
{0.2353,0.1985},
{0.2209,0.2028},
{0.2048,0.2083},
{0.2071,0.2241},
{0.1963,0.2421},
{0.1871,0.2572},
{0.188,0.2729},
{0.1864,0.2896},
{0.1825,0.3064},
{0.1674,0.3154},
{0.1592,0.329},
{0.1495,0.3407},
{0.1416,0.3348},
{0.1339,0.3304},
{0.1245,0.3411},
{0.1257,0.3282},
{0.1168,0.3401},
{0.3177,0.1632},
{0.2932,0.1508},
{0.2828,0.1491},
{0.2706,0.1509},
{0.2623,0.1585},
{0.2524,0.1644},
{0.2504,0.1779},
{0.2375,0.1818},
{0.2217,0.1833},
{0.2022,0.1933},
{0.1845,0.201},
{0.1884,0.2143},
{0.1927,0.2279},
{0.1841,0.2438},
{0.1752,0.256},
{0.1777,0.2701},
{0.1767,0.285},
{0.1732,0.3005},
{0.1589,0.3086},
{0.151,0.3225},
{0.1428,0.3172},
{0.1342,0.3138},
{0.1247,0.3131},
{0.1167,0.3284},
{0.3307,0.1632},
{0.3695,0.1875},
{0.3738,0.2099},
{0.358,0.1855},
{0.3548,0.1666},
{0.3431,0.1647},
{0.3415,0.1511},
{0.38,0.1907},
{0.3848,0.2128},
{0.3654,0.1683},
{0.3619,0.1548},
{0.3523,0.1532},
{0.3505,0.1437},
{0.3779,0.2334},
{0.3894,0.2354},
{0.3989,0.2385},
{0.403,0.2601},
{0.4062,0.2815},
{0.4085,0.302},
{0.2859,0.1406},
{0.2757,0.1435},
{0.3592,0.1454},
{0.3639,0.1386},
{0.3656,0.1453},
{0.3688,0.1541},
{0.3751,0.1685},
{0.2787,0.1368},
{0.2807,0.1313},
{0.2748,0.1265},
{0.6281,0.6484},
{0.6169,0.6484},
{0.6288,0.6417},
{0.6158,0.6425},
{0.6036,0.6496},
{0.6055,0.6555},
{0.6371,0.6453},
{0.6394,0.637},
{0.6284,0.6343},
{0.6142,0.6351},
{0.1542,0.175},
{0.1418,0.1823},
{0.1663,0.1812},
{0.1822,0.1874},
{0.1989,0.1796},
{0.2147,0.1704},
{0.2282,0.1587},
{0.2396,0.1461},
{0.7255,0.5564},
{0.7074,0.551},
{0.711,0.5276},
{0.7299,0.5318},
{0.7159,0.5041},
{0.6993,0.5021},
{0.695,0.5244},
{0.7466,0.5623},
{0.7515,0.5367},
{0.7353,0.5069},
{0.7419,0.4829},
{0.7224,0.4814},
{0.7057,0.4809},
{0.7297,0.4604},
{0.7134,0.4612},
{0.7218,0.5794},
{0.7048,0.573},
{0.7422,0.5861},
{0.7659,0.5928},
{0.7707,0.5685},
{0.7758,0.5424},
{0.7817,0.5158},
{0.7573,0.5108},
{0.7641,0.4857},
{0.7712,0.4622},
{0.7491,0.4605},
{0.7561,0.4404},
{0.7372,0.4415},
{0.7623,0.4233},
{0.7441,0.4255},
{0.7671,0.4098},
{0.7497,0.4129},
{0.7189,0.5995},
{0.703,0.5924},
{0.7382,0.6069},
{0.7612,0.6139},
{0.7863,0.6206},
{0.7915,0.5994},
{0.7964,0.5749},
{0.8015,0.5485},
{0.8073,0.5216},
{0.7887,0.4901},
{0.3171,0.4247},
{0.3388,0.4237},
{0.3595,0.4193},
{0.3785,0.4127},
{0.395,0.4054},
{0.4071,0.3855},
{0.4168,0.3789},
{0.4148,0.3688},
{0.3771,0.4275},
{0.3566,0.4346},
{0.3948,0.4193},
{0.4091,0.4115},
{0.4082,0.3984},
{0.4189,0.391},
{0.7779,0.4411},
{0.7835,0.423},
{0.7873,0.4087},
{0.79,0.3974},
{0.7708,0.3992},
{0.1888,0.5331},
{0.208,0.5318},
{0.2118,0.5569},
{0.1921,0.5582},
{0.2156,0.5832},
{0.2346,0.5826},
{0.2306,0.5562},
{0.2262,0.5312},
{0.2044,0.5091},
{0.186,0.5104},
{0.1665,0.5123},
{0.1685,0.5351},
{0.1713,0.5602},
{0.1957,0.5846},
{0.1992,0.6113},
{0.219,0.61},
{0.2377,0.6093},
{0.2557,0.6094},
{0.2529,0.5826},
{0.2486,0.5562},
{0.2435,0.5312},
{0.2218,0.5085},
{0.2015,0.4897},
{0.1839,0.4909},
{0.1652,0.4928},
{0.1453,0.4955},
{0.1458,0.5151},
{0.1471,0.5379},
{0.1494,0.5631},
{0.1747,0.5867},
{0.1785,0.6135},
{0.1826,0.6396},
{0.2028,0.6375},
{0.222,0.6361},
{0.2402,0.6355},
{0.2575,0.6355},
{0.2739,0.636},
{0.273,0.6099},
{0.2704,0.5832},
{0.2382,0.5085},
{0.2179,0.4891},
{0.2333,0.4891},
{0.2151,0.4741},
{0.1995,0.4746},
{0.2248,0.6607},
{0.2422,0.66},
{0.2585,0.66},
{0.2739,0.6605},
{0.2274,0.6827},
{0.2439,0.6821},
{0.2592,0.6821},
{0.2735,0.6825},
{0.2599,0.7007},
{0.2732,0.7012},
{0.2601,0.7166},
{0.2725,0.7171},
{0.2593,0.7304},
{0.271,0.731},
{0.2064,0.662},
{0.2099,0.684},
{0.2133,0.7024},
{0.23,0.7012},
{0.2455,0.7007},
{0.2466,0.7165},
{0.2465,0.7303},
{0.2448,0.7428},
{0.257,0.743},
{0.2526,0.7548},
{0.2408,0.7547},
{0.2314,0.7431},
{0.2278,0.7549},
{0.2353,0.7658},
{0.2226,0.7659},
{0.2135,0.7554},
{0.2087,0.7663},
{0.2167,0.7761},
{0.2033,0.7764},
{0.1938,0.7668},
{0.189,0.7766},
{0.1776,0.7672},
{0.1736,0.7765},
{0.1847,0.7857},
{0.1705,0.7854},
{0.1582,0.7765},
{0.1561,0.785},
{0.1434,0.7767},
{0.1423,0.7848},
{0.1302,0.7776},
{0.1297,0.7851},
{0.1869,0.6642},
{0.1912,0.6861},
{0.1953,0.7044},
{0.1987,0.7198},
{0.2159,0.7181},
{0.2319,0.717},
{0.2325,0.7307},
{0.9134,0.5808},
{0.9065,0.6062},
{0.8891,0.6003},
{0.8953,0.5746},
{0.8694,0.5942},
{0.8634,0.6182},
{0.8822,0.624},
{0.8985,0.6295},
{0.9215,0.6118},
{0.9293,0.5866},
{0.936,0.5604},
{0.9199,0.5544},
{0.9014,0.5481},
{0.8748,0.5681},
{0.8472,0.5878},
{0.8419,0.6121},
{0.856,0.6388},
{0.8737,0.6442},
{0.8889,0.6493},
{0.9021,0.6542},
{0.9126,0.6347},
{0.8807,0.5415},
{0.8522,0.5616},
{0.8578,0.5348},
{0.8273,0.555},
{0.8224,0.5814},
{0.9004,0.4681},
{0.9192,0.474},
{0.9146,0.4971},
{0.8948,0.4909},
{0.9082,0.522},
{0.9264,0.5283},
{0.9319,0.5031},
{0.9355,0.4795},
{0.936,0.4584},
{0.9208,0.4532},
{0.9031,0.4478},
{0.8789,0.4619},
{0.8727,0.4844},
{0.8878,0.5155},
{0.8652,0.5089},
{0.8403,0.5021},
{0.833,0.5281},
{0.8174,0.6058},
{0.8354,0.633},
{0.8463,0.6546},
{0.863,0.6597},
{0.8774,0.6645},
{0.8897,0.6691},
{0.8116,0.627},
{0.8268,0.6492},
{0.8354,0.6669},
{0.8512,0.6717},
{0.8648,0.6763},
{0.8766,0.6806},
{0.887,0.6847},
{0.9005,0.6734},
{0.8026,0.4443},
{0.8286,0.4493},
{0.8219,0.4714},
{0.7959,0.466},
{0.8145,0.4957},
{0.8479,0.4777},
{0.8545,0.4554},
{0.8588,0.4358},
{0.8333,0.43},
{0.8077,0.4255},
{0.8826,0.4419},
{0.8821,0.4251},
{0.8594,0.4195},
{0.835,0.4143},
{0.8105,0.4105},
{0.0596,0.8128},
{0.0612,0.8045},
{0.0686,0.806},
{0.0673,0.8141},
{0.066,0.8232},
{0.0635,0.8339},
{0.0606,0.8464},
{0.0581,0.8611},
{0.0571,0.8783},
{0.0504,0.8779},
{0.0533,0.8971},
{0.0586,0.8982},
{0.0641,0.797},
{0.0712,0.7985},
{0.8776,0.2196},
{0.8769,0.211},
{0.8847,0.2144},
{0.8855,0.2227},
{0.0624,0.7886},
{0.0696,0.79},
{0.8851,0.205},
{0.8911,0.2071},
{0.8907,0.2168},
{0.8773,0.2014},
{0.8872,0.1942},
{0.8935,0.196},
{0.8792,0.1906},
{0.0687,0.4487},
{0.0664,0.4427},
{0.0763,0.4445},
{0.079,0.4505},
{0.0879,0.4449},
{0.0913,0.4509},
{0.1019,0.4432},
{0.106,0.4493},
{0.1172,0.4402},
{0.1222,0.4466},
{0.1332,0.4367},
{0.139,0.4434},
{0.0707,0.4558},
{0.0811,0.4574},
{0.0938,0.4577},
{0.1091,0.4563},
{0.126,0.4538},
{0.1193,0.7793},
{0.1103,0.7817},
{0.1111,0.7747},
{0.1203,0.7721},
{0.1115,0.7669},
{0.1036,0.7695},
{0.1035,0.7775},
{0.1029,0.7845},
{0.1317,0.77},
{0.1212,0.7643},
{0.1113,0.758},
{0.1032,0.7603},
{0.9244,0.9008},
{0.9277,0.8932},
{0.9313,0.9},
{0.9254,0.8853},
{0.1331,0.762},
{0.1212,0.7556},
{0.1335,0.7532},
{0.1319,0.7432},
{0.1196,0.7457},
{0.8971,0.168},
{0.905,0.1688},
{0.8986,0.183},
{0.8916,0.1817},
{0.8829,0.1785},
{0.8684,0.1837},
{0.8557,0.1754},
{0.8585,0.1635},
{0.844,0.1558},
{0.8287,0.1507},
{0.8134,0.1502},
{0.7985,0.1524},
{0.7842,0.1556},
{0.7718,0.1566},
{0.8877,0.1654},
{0.8717,0.1718},
{0.8758,0.1595},
{0.862,0.1519},
{0.8469,0.1447},
{0.831,0.14},
{0.815,0.1398},
{0.7996,0.1421},
{0.7855,0.1449},
{0.7736,0.146},
{0.7625,0.152},
{0.7648,0.1433},
{0.7669,0.1362},
{0.7584,0.1382},
{0.7611,0.1324},
{0.7537,0.1324},
{0.757,0.1274},
{0.7501,0.1272},
{0.7537,0.1229},
{0.76,0.1224},
{0.7571,0.1162},
{0.7628,0.1187},
{0.761,0.1129},
{0.7566,0.1082},
{0.7595,0.1064},
{0.7557,0.1013},
{0.758,0.0998},
{0.7547,0.095},
{0.7564,0.0935},
{0.7536,0.0896},
{0.755,0.0881},
{0.7527,0.0852},
{0.7539,0.0838},
{0.7522,0.0819},
{0.7532,0.0805},
{0.9028,0.1536},
{0.9117,0.1539},
{0.8925,0.1518},
{0.9077,0.139},
{0.9173,0.1388},
{0.8966,0.138},
{0.8799,0.147},
{0.8655,0.1405},
{0.8497,0.1339},
{0.8332,0.1297},
{0.8165,0.1304},
{0.8007,0.1335},
{0.7867,0.1364},
{0.7752,0.1378},
{0.7764,0.131},
{0.7687,0.1302},
{0.7635,0.1272},
{0.7655,0.1229},
{0.7673,0.1196},
{0.7659,0.1159},
{0.7645,0.1104},
{0.7626,0.1043},
{0.7605,0.0981},
{0.7585,0.0921},
{0.7568,0.0868},
{0.7539,0.0838},
{0.7555,0.0825},
{0.7532,0.0805},
{0.7546,0.0792},
{0.753,0.0781},
{0.7543,0.0766},
{0.7566,0.0781},
{0.7562,0.0754},
{0.7543,0.0747},
{0.7529,0.0766},
{0.753,0.0781},
{0.9196,0.172},
{0.9123,0.1696},
{0.9199,0.1544},
{0.9283,0.1566},
{0.9263,0.1389},
{0.1613,0.7677},
{0.1641,0.7585},
{0.1478,0.7601},
{0.1456,0.7686},
{0.1487,0.7508},
{0.1656,0.7486},
{0.1812,0.7572},
{0.198,0.7562},
{0.1833,0.7466},
{0.9302,0.1237},
{0.9207,0.1239},
{0.922,0.1094},
{0.9318,0.1089},
{0.9213,0.0952},
{0.9109,0.0966},
{0.9117,0.1104},
{0.9106,0.1246},
{0.9356,0.1409},
{0.94,0.1255},
{0.9419,0.1103},
{0.9311,0.0944},
{0.9186,0.0814},
{0.9083,0.0832},
{0.8965,0.0846},
{0.8991,0.0976},
{0.9,0.1109},
{0.8991,0.1244},
{0.9413,0.0954},
{0.9285,0.0803},
{0.9387,0.0809},
{0.9343,0.0668},
{0.9241,0.0666},
{0.9142,0.068},
{0.2167,0.7439},
{0.2007,0.745},
{0.8254,0.7121},
{0.8134,0.708},
{0.8205,0.6995},
{0.8329,0.7036},
{0.8288,0.6904},
{0.8145,0.686},
{0.8067,0.6952},
{0.8004,0.7038},
{0.7915,0.6907},
{0.7863,0.6994},
{0.7949,0.7106},
{0.7827,0.7063},
{0.7709,0.6951},
{0.7692,0.703},
{0.7549,0.6905},
{0.7549,0.6997},
{0.7391,0.6853},
{0.74,0.6956},
{0.7257,0.69},
{0.7293,0.7021},
{0.7441,0.7052},
{0.8978,0.0581},
{0.9078,0.0556},
{0.9038,0.07},
{0.8921,0.0719},
{0.8824,0.0847},
{0.885,0.097},
{0.886,0.1094},
{0.8855,0.1219},
{0.8834,0.1344},
{0.8866,0.0603},
{0.8992,0.045},
{0.8905,0.0482},
{0.8807,0.0508},
{0.873,0.061},
{0.878,0.0724},
{0.8674,0.0837},
{0.87,0.0952},
{0.8711,0.1066},
{0.8705,0.1178},
{0.8685,0.1291},
{0.8809,0.0408},
{0.8759,0.0447},
{0.8682,0.0511},
{0.8587,0.0608},
{0.8634,0.072},
{0.8532,0.082},
{0.8555,0.0926},
{0.8563,0.1029},
{0.855,0.113},
{0.8525,0.1233},
{0.7984,0.6813},
{0.7803,0.6763},
{0.7746,0.686},
{0.7572,0.6808},
{0.7402,0.675},
{0.7246,0.6685},
{0.7244,0.6791},
{0.8708,0.3877},
{0.8686,0.3779},
{0.8841,0.3814},
{0.8871,0.3916},
{0.8748,0.3985},
{0.8921,0.4028},
{0.9015,0.3956},
{0.9071,0.4071},
{0.8974,0.4156},
{0.9132,0.4202},
{0.9202,0.4114},
{0.9269,0.4247},
{0.9183,0.4355},
{0.9327,0.4403},
{0.8358,0.041},
{0.8359,0.0336},
{0.8528,0.034},
{0.8516,0.0414},
{0.868,0.0363},
{0.8658,0.0429},
{0.7429,0.6648},
{0.7614,0.6708},
{0.7259,0.6581},
{0.767,0.661},
{0.7467,0.6548},
{0.7281,0.6478},
{0.5762,0.384},
{0.576,0.3932},
{0.8328,0.3811},
{0.8333,0.3723},
{0.8514,0.3747},
{0.8524,0.384},
{0.8549,0.3942},
{0.8577,0.4058},
{0.879,0.4108},
{0.9016,0.4304},
{0.5948,0.3908},
{0.5933,0.4001},
{0.5948,0.3817},
{0.5747,0.3751},
{0.6125,0.3996},
{0.61,0.4088},
{0.6139,0.3905},
{0.6143,0.3814},
{0.5937,0.3728},
{0.5739,0.4024},
{0.5899,0.4092},
{0.606,0.4176},
{0.6215,0.427},
{0.6254,0.4187},
{0.6284,0.41},
{0.6307,0.4011},
{0.6324,0.3922},
{0.6338,0.3831},
{0.6144,0.3723},
{0.5837,0.4179},
{0.569,0.4113},
{0.5994,0.4263},
{0.6174,0.4341},
{0.6314,0.4446},
{0.6351,0.4377},
{0.6388,0.4301},
{0.648,0.4046},
{0.6503,0.3956},
{0.6528,0.3866},
{0.6353,0.3737},
{0.5556,0.4061},
{0.5606,0.4195},
{0.5736,0.4256},
{0.5831,0.4306},
{0.5989,0.4331},
{0.6138,0.4395},
{0.6281,0.4504},
{0.7562,0.6305},
{0.78,0.6372},
{0.7734,0.6502},
{0.7512,0.6437},
{0.7877,0.6668},
{0.7959,0.6562},
{0.8042,0.6434},
{0.7344,0.6234},
{0.7309,0.6366},
{0.8171,0.6617},
{0.8073,0.672},
{0.8244,0.6769},
{0.8394,0.6816},
{0.8525,0.6859},
{0.8639,0.69},
{0.8348,0.4014},
{0.8337,0.3906},
{0.8117,0.3984},
{0.8124,0.3884},
{0.8415,0.6946},
{0.9458,0.0697},
{0.9502,0.0844},
{0.9527,0.0995},
{0.9622,0.0899},
{0.9646,0.1058},
{0.9531,0.1149},
{0.9648,0.1219},
{0.9763,0.1134},
{0.9763,0.1303},
{0.9622,0.1381},
{0.9735,0.1472},
{0.9566,0.1543},
{0.9674,0.164},
{0.9476,0.1704},
{0.9576,0.1804},
{0.937,0.1859},
{0.9463,0.1961},
{0.9268,0.2004},
{0.9352,0.2105},
{0.9188,0.2135},
{0.9265,0.2233},
{0.1828,0.4758},
{0.1649,0.4776},
{0.1457,0.4802},
{0.1265,0.4831},
{0.1255,0.4984},
{0.1253,0.518},
{0.1258,0.541},
{0.127,0.5664},
{0.1525,0.5896},
{0.1565,0.6165},
{0.1612,0.6427},
{0.1663,0.6672},
{0.1713,0.6891},
{0.1762,0.7072},
{0.1802,0.7223},
{0.1828,0.7352},
{0.2007,0.7331},
{0.2173,0.7316},
{0.9509,0.1306},
{0.9459,0.1464},
{0.9377,0.1622},
{0.928,0.1777},
{0.9186,0.1923},
{0.9114,0.2057},
{0.9112,0.1867},
{0.9047,0.2002},
{0.1085,0.4855},
{0.1071,0.5009},
{0.1063,0.5204},
{0.1057,0.5436},
{0.105,0.5695},
{0.1296,0.5931},
{0.1342,0.6202},
{0.14,0.6464},
{0.1459,0.6709},
{0.1517,0.6926},
{0.1571,0.7105},
{0.1616,0.7253},
{0.1646,0.7378},
{0.0929,0.487},
{0.0914,0.5023},
{0.0902,0.5218},
{0.0887,0.5447},
{0.0863,0.5703},
{0.1065,0.5968},
{0.1124,0.6242},
{0.1201,0.6506},
{0.1271,0.6749},
{0.1334,0.6963},
{0.1392,0.7139},
{0.144,0.7284},
{0.1473,0.7405},
{0.1286,0.7314},
{0.1238,0.7172},
{0.1166,0.7339},
{0.1179,0.6999},
{0.1122,0.7198},
{0.1073,0.736},
{0.1099,0.7479},
{0.1021,0.7498},
{0.1001,0.7376},
{0.1036,0.7219},
{0.0973,0.7234},
{0.0473,0.8985},
{0.0532,0.9164},
{0.0581,0.9167},
{0.0589,0.9334},
{0.0632,0.935},
{0.0817,0.4748},
{0.072,0.4735},
{0.0717,0.4638},
{0.0819,0.4652},
{0.0946,0.4655},
{0.0941,0.475},
{0.0808,0.4869},
{0.0718,0.4856},
{0.0795,0.5022},
{0.071,0.5008},
{0.1065,0.7029},
{0.0985,0.7052},
{0.0998,0.6825},
{0.0921,0.6855},
{0.0847,0.6647},
{0.0804,0.6676},
{0.0874,0.6875},
{0.1113,0.6789},
{0.1035,0.6551},
{0.0943,0.6296},
{0.0833,0.6373},
{0.0921,0.6601},
{0.0812,0.6009},
{0.0745,0.6195},
{0.0695,0.6286},
{0.0769,0.6447},
{0.0445,0.9334},
{0.0408,0.9221},
{0.0473,0.9185},
{0.0522,0.9329},
{0.0532,0.9164},
{0.0415,0.904},
{0.0358,0.9113},
{0.0371,0.935},
{0.0589,0.9334},
{0.0603,0.558},
{0.063,0.5381},
{0.0681,0.5408},
{0.0657,0.5614},
{0.0764,0.5434},
{0.0782,0.5214},
{0.0698,0.5199},
{0.0646,0.5176},
{0.0572,0.575},
{0.0628,0.5787},
{0.0738,0.5665},
{0.07,0.5857},
{0.0725,0.649},
{0.0651,0.6336},
{0.0567,0.595},
{0.0584,0.5998},
{0.0645,0.5957},
{0.0595,0.5898},
{0.0598,0.605},
{0.0675,0.6034},
{0.0667,0.6119},
{0.0634,0.6193},
{0.0595,0.6155},
{0.0598,0.6105},
{0.0556,0.6167},
{0.0594,0.6235},
{0.0546,0.6248},
{0.0612,0.635},
{0.0651,0.6336},
{0.8342,0.1176},
{0.8163,0.1219},
{0.8009,0.1259},
{0.7874,0.1293},
{0.841,0.1078},
{0.8433,0.099},
{0.8305,0.1023},
{0.8239,0.1088},
{0.8125,0.1143},
{0.7992,0.1188},
{0.7871,0.1225},
{0.777,0.1247},
{0.77,0.1249},
{0.7706,0.1196},
{0.7701,0.114},
{0.7685,0.1082},
{0.766,0.1022},
{0.7632,0.0963},
{0.7608,0.0907},
{0.7589,0.0856},
{0.7575,0.0814},
{0.76,0.0804},
{0.759,0.0772},
{0.7586,0.0744},
{0.7562,0.0731},
{0.8432,0.09},
{0.8337,0.0953},
{0.8407,0.0797},
{0.8354,0.0819},
{0.8349,0.0883},
{0.8266,0.0918},
{0.8227,0.0971},
{0.8165,0.1024},
{0.8073,0.1074},
{0.7965,0.112},
{0.786,0.1158},
{0.7769,0.1185},
{0.776,0.1121},
{0.7742,0.1048},
{0.7694,0.0994},
{0.7661,0.0942},
{0.7635,0.089},
{0.7615,0.0843},
{0.7631,0.0795},
{0.7621,0.0764},
{0.7617,0.0736},
{0.7587,0.0719},
{0.8542,0.0504},
{0.8455,0.06},
{0.8399,0.0499},
{0.8359,0.0589},
{0.84,0.0689},
{0.8499,0.0709},
{0.829,0.0497},
{0.5622,0.4332},
{0.5709,0.4369},
{0.552,0.4419},
{0.5612,0.4449},
{0.6638,0.5552},
{0.6733,0.5354},
{0.68,0.5151},
{0.6845,0.495},
{0.687,0.4761},
{0.6883,0.4595},
{0.689,0.4466},
{0.6888,0.4381},
{0.6838,0.4312},
{0.6752,0.4209},
{0.6641,0.4086},
{0.672,0.5583},
{0.6608,0.5784},
{0.6814,0.5377},
{0.6881,0.5171},
{0.6925,0.4972},
{0.695,0.4788},
{0.68,0.5605},
{0.6687,0.5819},
{0.6489,0.5977},
{0.6566,0.6027},
{0.6368,0.6143},
{0.6434,0.6237},
{0.6253,0.6265},
{0.3614,0.6677},
{0.3708,0.68},
{0.3597,0.6873},
{0.3459,0.6754},
{0.3409,0.6916},
{0.352,0.6966},
{0.1791,0.2318},
{0.1726,0.2205},
{0.1675,0.2361},
{0.173,0.2456},
{0.1672,0.2086},
{0.1596,0.2272},
{0.1591,0.2412},
{0.164,0.2478},
{0.165,0.2529},
{0.39,0.732},
{0.3909,0.7446},
{0.3788,0.7518},
{0.3768,0.7414},
{0.3657,0.7598},
{0.3696,0.7684},
{0.3811,0.762},
{0.3746,0.7776},
{0.3829,0.7713},
{0.3858,0.6576},
{0.3746,0.6623},
{0.379,0.6464},
{0.3752,0.7315},
{0.3625,0.7512},
{0.3602,0.7429},
{0.3438,0.7548},
{0.3468,0.7621},
{0.3511,0.7694},
{0.3287,0.6901},
{0.3378,0.7041},
{0.328,0.7034},
{0.3187,0.7039},
{0.3274,0.7146},
{0.3198,0.7148},
{0.3106,0.7054},
{0.3133,0.716},
{0.32,0.723},
{0.3147,0.7239},
{0.3082,0.7179},
{0.3103,0.7253},
{0.3046,0.7204},
{0.3067,0.7271},
{0.3017,0.7218},
{0.373,0.6348},
{0.2341,0.165},
{0.1523,0.1883},
{0.1657,0.1951},
{0.1503,0.2027},
{0.6333,0.9323},
{0.6353,0.9217},
{0.6417,0.9215},
{0.641,0.9326},
{0.6417,0.9125},
{0.6363,0.9128},
{0.6311,0.9195},
{0.6289,0.9275},
{0.6265,0.9343},
{0.6299,0.9456},
{0.3046,0.7082},
{0.3012,0.7124},
{0.3,0.7159},
{0.2426,0.1668},
{0.627,0.9206},
{0.629,0.917},
{0.6251,0.9245},
{0.6267,0.9138},
{0.6291,0.9116},
{0.6249,0.9165},
{0.6268,0.9085},
{0.6293,0.9062},
{0.2442,0.1229},
{0.6323,0.9119},
{0.6326,0.906},
{0.2949,0.8123},
{0.285,0.8213},
{0.2743,0.817},
{0.2847,0.8075},
{0.2974,0.7968},
{0.2739,0.8032},
{0.2874,0.7906},
{0.3081,0.7788},
{0.3131,0.7853},
{0.3302,0.7736},
{0.3263,0.7669},
{0.3066,0.8021},
{0.3206,0.7911},
{0.3358,0.78},
{0.3424,0.7864},
{0.3564,0.7767},
{0.3623,0.7841},
{0.3685,0.7917},
{0.3768,0.7877},
{0.3747,0.7999},
{0.3813,0.7963},
{0.3805,0.8092},
{0.3861,0.8058},
{0.3897,0.8174},
{0.3847,0.8206},
{0.3909,0.8319},
{0.3863,0.8351},
{0.3773,0.8257},
{0.3793,0.8398},
{0.3859,0.8517},
{0.3792,0.8561},
{0.3841,0.8695},
{0.3778,0.8737},
{0.3816,0.8875},
{0.3757,0.8916},
{0.3791,0.9047},
{0.3738,0.9087},
{0.3763,0.9206},
{0.3716,0.9246},
{0.3046,0.8168},
{0.2951,0.8254},
{0.3158,0.8071},
{0.3287,0.7967},
{0.3372,0.8022},
{0.3499,0.7927},
{0.3578,0.799},
{0.3656,0.8061},
{0.3724,0.8147},
{0.3621,0.8218},
{0.3674,0.8321},
{0.3698,0.8456},
{0.37,0.8613},
{0.3689,0.8784},
{0.3672,0.8958},
{0.3738,0.9087},
{0.3659,0.9127},
{0.3716,0.9246},
{0.3644,0.9283},
{0.3688,0.9386},
{0.3624,0.9422},
{0.3651,0.9501},
{0.3596,0.9535},
{0.3139,0.8212},
{0.3043,0.8295},
{0.325,0.812},
{0.3343,0.8168},
{0.3462,0.8077},
{0.3548,0.8139},
{0.7142,0.6289},
{0.7163,0.6157},
{0.7126,0.6401},
{0.6673,0.4002},
{0.4041,0.7682},
{0.4073,0.767},
{0.4064,0.7763},
{0.4034,0.778},
{0.406,0.7864},
{0.4031,0.7886},
{0.406,0.7973},
{0.4033,0.8001},
{0.4069,0.8082},
{0.4044,0.8114},
{0.4089,0.818},
{0.4067,0.8216},
{0.4122,0.8258},
{0.4105,0.8297},
{0.4039,0.825},
{0.4081,0.8333},
{0.4005,0.8279},
{0.4052,0.8363},
{0.4,0.7696},
{0.4034,0.778},
{0.3994,0.7798},
{0.4031,0.7886},
{0.3993,0.7909},
{0.4033,0.8001},
{0.3998,0.8028},
{0.4044,0.8114},
{0.4013,0.8145},
{0.3974,0.8172},
{0.405,0.7592},
{0.4083,0.7585},
{0.4008,0.7602},
{0.3956,0.7611},
{0.395,0.7709},
{0.3946,0.7816},
{0.3947,0.7931},
{0.3956,0.8053},
{0.406,0.7511},
{0.4093,0.7507},
{0.4017,0.7516},
{0.3963,0.7523},
{0.4163,0.6949},
{0.4185,0.6936},
{0.4185,0.7022},
{0.4162,0.703},
{0.4184,0.71},
{0.4161,0.7105},
{0.4185,0.7172},
{0.4162,0.7174},
{0.4184,0.7237},
{0.4163,0.7237},
{0.8398,0.0538},
{0.8434,0.054},
{0.8416,0.0602},
{0.8381,0.0597},
{0.8394,0.0656},
{0.836,0.0649},
{0.8367,0.0701},
{0.8334,0.0692},
{0.8298,0.0673},
{0.8323,0.0631},
{0.8261,0.0647},
{0.8233,0.0681},
{0.8269,0.0708},
{0.8237,0.0738},
{0.8202,0.0711},
{0.8203,0.0765},
{0.8239,0.079},
{0.8272,0.0761},
{0.8274,0.0809},
{0.8306,0.0775},
{0.8312,0.082},
{0.8336,0.0778},
{0.8354,0.0819},
{0.8364,0.0767},
{0.8407,0.0797},
{0.8377,0.0731},
{0.8446,0.0471},
{0.8476,0.0456},
{0.8463,0.0529},
{0.8408,0.0471},
{0.8358,0.0524},
{0.8343,0.0581},
{0.8451,0.0394},
{0.8481,0.0377},
{0.8412,0.0398},
{0.8367,0.0459},
{0.8317,0.05},
{0.8303,0.0556},
{0.8284,0.0605},
{0.8226,0.0616},
{0.8199,0.0651},
{0.8169,0.068},
{0.8168,0.0736},
{0.8166,0.079},
{0.8204,0.082},
{0.8245,0.0846},
{0.8291,0.0867},
{0.9603,0.4707},
{0.9571,0.4628},
{0.9598,0.4626},
{0.9629,0.47},
{0.9634,0.4776},
{0.9659,0.4766},
{0.9661,0.4837},
{0.9685,0.4824},
{0.9688,0.489},
{0.971,0.4876},
{0.9717,0.4936},
{0.9736,0.4921},
{0.284,0.5318},
{0.2829,0.525},
{0.2861,0.5241},
{0.287,0.5305},
{0.2909,0.5291},
{0.2901,0.523},
{0.2857,0.5169},
{0.2824,0.5173},
{0.2859,0.5086},
{0.2824,0.5085},
{0.2866,0.4991},
{0.283,0.4985},
{0.288,0.4891},
{0.2844,0.488},
{0.2904,0.4793},
{0.2869,0.4777},
{0.2821,0.4866},
{0.2845,0.4757},
{0.2906,0.4683},
{0.2883,0.4658},
{0.2958,0.4606},
{0.2936,0.4576},
{0.3004,0.4511},
{0.3023,0.4545},
{0.3085,0.4467},
{0.3101,0.4504},
{0.3177,0.4445},
{0.3175,0.4405},
{0.3079,0.4429},
{0.2857,0.5379},
{0.2886,0.5363},
{0.2924,0.5345},
{0.2966,0.5326},
{0.2953,0.5274},
{0.2947,0.5217},
{0.2899,0.5161},
{0.2902,0.5082},
{0.291,0.4992},
{0.2924,0.4896},
{0.2947,0.4803},
{0.294,0.4704},
{0.2989,0.4631},
{0.3052,0.4575},
{0.3125,0.4537},
{0.3189,0.4484},
{0.328,0.4446},
{0.3282,0.4405},
{0.3293,0.4367},
{0.3183,0.4368},
{0.9569,0.4708},
{0.9537,0.4625},
{0.9571,0.4628},
{0.9603,0.4707},
{0.9601,0.4781},
{0.9634,0.4776},
{0.963,0.4844},
{0.9661,0.4837},
{0.9657,0.4899},
{0.9688,0.489},
{0.9686,0.4948},
{0.9717,0.4936},
{0.9528,0.4704},
{0.9496,0.4616},
{0.956,0.478},
{0.9589,0.4845},
{0.9615,0.4901},
{0.964,0.4951},
{0.9686,0.4948},
{0.954,0.4539},
{0.9506,0.4531},
{0.9511,0.4439},
{0.9477,0.4426},
{0.9486,0.4327},
{0.9452,0.4308},
{0.947,0.4211},
{0.9437,0.4187},
{0.9468,0.4098},
{0.9437,0.407},
{0.9486,0.3998},
{0.9458,0.3966},
{0.9403,0.404},
{0.94,0.416},
{0.9437,0.4187},
{0.9413,0.4285},
{0.9452,0.4308},
{0.9437,0.4407},
{0.9477,0.4426},
{0.9465,0.4517},
{0.9506,0.4531},
{0.9567,0.4542},
{0.954,0.4539},
{0.9539,0.4447},
{0.9511,0.4439},
{0.9514,0.434},
{0.9497,0.4229},
{0.8435,0.023},
{0.8466,0.0207},
{0.8479,0.0291},
{0.8448,0.0311},
{0.8409,0.0318},
{0.8396,0.0239},
{0.8407,0.0156},
{0.8437,0.0132},
{0.836,0.0099},
{0.8388,0.0073},
{0.5456,0.8446},
{0.542,0.8449},
{0.5411,0.8353},
{0.5446,0.8354},
{0.5489,0.8359},
{0.5446,0.8265},
{0.5489,0.8275},
{0.5493,0.8197},
{0.5452,0.8184},
{0.5477,0.8535},
{0.5441,0.8544},
{0.5499,0.8447},
{0.5537,0.8368},
{0.5535,0.8287},
{0.5539,0.8212},
{0.4766,0.7953},
{0.4778,0.7988},
{0.4703,0.8041},
{0.4689,0.8009},
{0.4612,0.8088},
{0.4628,0.8116},
{0.4536,0.8185},
{0.4555,0.8208},
{0.4842,0.7926},
{0.4854,0.7964},
{0.4815,0.789},
{0.4739,0.7919},
{0.4662,0.7978},
{0.4585,0.8061},
{0.4508,0.8161},
{0.4432,0.8272},
{0.4462,0.8293},
{0.4362,0.8391},
{0.4395,0.8409},
{0.4307,0.8514},
{0.4343,0.853},
{0.4273,0.8639},
{0.4312,0.8653},
{0.4371,0.8541},
{0.4343,0.8659},
{0.4309,0.8774},
{0.4342,0.8776},
{0.4332,0.8892},
{0.4367,0.8891},
{0.4367,0.877},
{0.4392,0.888},
{0.4415,0.9002},
{0.4439,0.8986},
{0.4507,0.9088},
{0.4518,0.906},
{0.4453,0.8963},
{0.5479,0.8632},
{0.5531,0.8711},
{0.5508,0.8735},
{0.5454,0.8651},
{0.5417,0.8557},
{0.5513,0.8618},
{0.5519,0.8532},
{0.5545,0.8452},
{0.5583,0.838},
{0.5583,0.8301},
{0.5586,0.8228},
{0.559,0.8168},
{0.5545,0.815},
{0.5563,0.8692},
{0.5576,0.8807},
{0.5597,0.8778},
{0.5626,0.8753},
{0.56,0.8679},
{0.5553,0.861},
{0.5564,0.8534},
{0.5591,0.8461},
{0.5626,0.8392},
{0.5626,0.8315},
{0.5629,0.8244},
{0.5633,0.8185},
{0.5659,0.8861},
{0.5677,0.8828},
{0.5701,0.88},
{0.5659,0.8736},
{0.564,0.8673},
{0.5596,0.8608},
{0.5608,0.854},
{0.5633,0.8472},
{0.5662,0.8405},
{0.5661,0.8329},
{0.5664,0.8259},
{0.5668,0.82},
{0.5674,0.815},
{0.5639,0.8135},
{0.9505,0.3882},
{0.9572,0.382},
{0.959,0.3859},
{0.9529,0.3918},
{0.9479,0.3846},
{0.9551,0.3782},
{0.9428,0.3933},
{0.9367,0.4008},
{0.936,0.413},
{0.9371,0.4258},
{0.9651,0.378},
{0.9664,0.3821},
{0.9634,0.3741},
{0.9723,0.3723},
{0.9736,0.3764},
{0.5756,0.8896},
{0.5859,0.8909},
{0.5859,0.8946},
{0.5751,0.8932},
{0.5651,0.8895},
{0.5768,0.886},
{0.5866,0.8872},
{0.5787,0.8829},
{0.5879,0.884},
{0.5961,0.8898},
{0.5962,0.8862},
{0.5969,0.883},
{0.6056,0.8863},
{0.605,0.8829},
{0.6135,0.8801},
{0.6124,0.8771},
{0.2609,0.919},
{0.2583,0.9306},
{0.2562,0.9282},
{0.2588,0.9173},
{0.254,0.9267},
{0.2509,0.9355},
{0.2529,0.9376},
{0.5967,0.8935},
{0.3387,0.4511},
{0.3386,0.4472},
{0.3487,0.4522},
{0.3482,0.4558},
{0.3576,0.4596},
{0.3594,0.4561},
{0.3499,0.4483},
{0.3392,0.4431},
{0.3287,0.4486},
{0.3301,0.4522},
{0.3394,0.4545},
{0.3483,0.459},
{0.6672,0.7919},
{0.6689,0.7892},
{0.6745,0.7978},
{0.6726,0.8001},
{0.6794,0.8088},
{0.6772,0.8104},
{0.6835,0.8216},
{0.6812,0.8225},
{0.6847,0.8359},
{0.687,0.8358},
{0.6877,0.8504},
{0.6901,0.8511},
{0.6906,0.8654},
{0.6929,0.867},
{0.6927,0.8801},
{0.695,0.8826},
{0.3209,0.4519},
{0.3234,0.4545},
{0.332,0.4548},
{0.3407,0.4394},
{0.3518,0.4447},
{0.3617,0.4527},
{0.4289,0.8881},
{0.4268,0.8761},
{0.4239,0.8854},
{0.422,0.8737},
{0.4228,0.8616},
{0.4265,0.8493},
{0.4189,0.8577},
{0.4227,0.8459},
{0.4322,0.837},
{0.4285,0.8342},
{0.4204,0.8409},
{0.4258,0.8304},
{0.4355,0.8229},
{0.4324,0.8205},
{0.4253,0.8249},
{0.4314,0.8165},
{0.4393,0.811},
{0.4368,0.8104},
{0.4336,0.8099},
{0.44,0.804},
{0.4454,0.8019},
{0.443,0.8122},
{0.4501,0.8022},
{0.4511,0.7941},
{0.457,0.7938},
{0.4547,0.8038},
{0.4622,0.7952},
{0.4639,0.7876},
{0.4696,0.789},
{0.4769,0.7859},
{0.2607,0.9049},
{0.2621,0.8915},
{0.2642,0.8916},
{0.2628,0.9059},
{0.4484,0.9109},
{0.4593,0.9186},
{0.4601,0.9153},
{0.2632,0.8774},
{0.2651,0.8767},
{0.2607,0.8787},
{0.2596,0.8921},
{0.2582,0.9047},
{0.2564,0.9164},
{0.2517,0.9259},
{0.2489,0.9342},
{0.2455,0.941},
{0.2473,0.9427},
{0.438,0.9006},
{0.445,0.9117},
{0.6383,0.8943},
{0.6334,0.906},
{0.6303,0.9038},
{0.6347,0.8927},
{0.6413,0.8814},
{0.6373,0.8804},
{0.6421,0.8679},
{0.6378,0.8674},
{0.6339,0.8794},
{0.6342,0.8671},
{0.6371,0.8542},
{0.6333,0.8545},
{0.632,0.8422},
{0.6359,0.8412},
{0.631,0.8305},
{0.6278,0.8327},
{0.6289,0.8435},
{0.3675,0.4832},
{0.3697,0.4812},
{0.3728,0.4945},
{0.3703,0.4957},
{0.3712,0.5092},
{0.3739,0.5088},
{0.3774,0.5081},
{0.3759,0.493},
{0.3724,0.4789},
{0.3646,0.4694},
{0.363,0.4721},
{0.3565,0.4628},
{0.3757,0.4766},
{0.3669,0.4665},
{0.3697,0.4635},
{0.3796,0.4912},
{0.3837,0.4894},
{0.3793,0.4743},
{0.3729,0.4608},
{0.3814,0.5069},
{0.3858,0.5055},
{0.6415,0.8541},
{0.4687,0.9273},
{0.467,0.9301},
{0.4573,0.921},
{0.4691,0.9235},
{0.4683,0.9194},
{0.4597,0.9116},
{0.4777,0.9343},
{0.4764,0.9375},
{0.4777,0.9302},
{0.4765,0.9258},
{0.4849,0.9346},
{0.4854,0.9391},
{0.6405,0.8406},
{0.6397,0.8278},
{0.6351,0.8289},
{0.6311,0.82},
{0.6277,0.823},
{0.3658,0.5503},
{0.3682,0.5371},
{0.3712,0.5384},
{0.3688,0.5525},
{0.3749,0.5392},
{0.3732,0.5237},
{0.3702,0.5232},
{0.3637,0.5476},
{0.3661,0.5353},
{0.3616,0.5587},
{0.3637,0.5623},
{0.3667,0.5654},
{0.3726,0.554},
{0.377,0.5545},
{0.3793,0.5392},
{0.3768,0.5237},
{0.381,0.5231},
{0.3857,0.522},
{0.375,0.5685},
{0.3706,0.5676},
{0.2628,0.8514},
{0.2602,0.8545},
{0.261,0.8422},
{0.2635,0.8384},
{0.261,0.8312},
{0.2585,0.8354},
{0.2584,0.8459},
{0.2575,0.8576},
{0.2591,0.8675},
{0.2618,0.8651},
{0.2641,0.863},
{0.2651,0.8485},
{0.2557,0.849},
{0.2548,0.8604},
{0.2563,0.87},
{0.2581,0.8805},
{0.2573,0.8268},
{0.2596,0.8222},
{0.2549,0.8307},
{0.2559,0.8389},
{0.2534,0.8416},
{0.2532,0.8515},
{0.2524,0.8627},
{0.2536,0.8724},
{0.2553,0.8824},
{0.257,0.8931},
{0.2633,0.8268},
{0.2617,0.8171},
{0.2564,0.8158},
{0.2543,0.8208},
{0.2521,0.8249},
{0.2499,0.8279},
{0.2525,0.8336},
{0.2501,0.8359},
{0.251,0.8439},
{0.2508,0.8536},
{0.25,0.8646},
{0.2513,0.8744},
{0.2528,0.8843},
{0.2543,0.8945},
{0.2557,0.9051},
{0.2651,0.8223},
{0.2633,0.8119},
{0.2582,0.8102},
{0.2522,0.8116},
{0.2504,0.8169},
{0.2484,0.8212},
{0.2463,0.8243},
{0.2443,0.8267},
{0.2476,0.8302},
{0.2454,0.8325},
{0.2478,0.8381},
{0.2486,0.846},
{0.2485,0.8556},
{0.2478,0.8662},
{0.2491,0.8761},
{0.2506,0.8861},
{0.2519,0.896},
{0.2532,0.9059},
{0.254,0.9161},
{0.685,0.8817},
{0.6838,0.8702},
{0.6869,0.8736},
{0.688,0.8857},
{0.6899,0.877},
{0.6878,0.8631},
{0.6847,0.8604},
{0.6816,0.8576},
{0.6808,0.8671},
{0.6821,0.8782},
{0.682,0.8873},
{0.6848,0.8912},
{0.6876,0.8958},
{0.6909,0.8898},
{0.6849,0.8489},
{0.6819,0.847},
{0.6789,0.8447},
{0.6787,0.8549},
{0.6782,0.8646},
{0.6795,0.8754},
{0.6794,0.8843},
{0.6776,0.8906},
{0.68,0.8938},
{0.6826,0.898},
{0.6853,0.9031},
{0.6904,0.9006},
{0.6936,0.8937},
{0.2509,0.9071},
{0.2516,0.9165},
{0.2496,0.9173},
{0.6761,0.8323},
{0.6731,0.8207},
{0.6758,0.8219},
{0.679,0.834},
{0.6786,0.8226},
{0.6748,0.8111},
{0.6722,0.8111},
{0.6698,0.8103},
{0.6707,0.8192},
{0.6735,0.8304},
{0.6761,0.8424},
{0.6819,0.8353},
{0.6704,0.8014},
{0.6681,0.8018},
{0.9476,0.9163},
{0.9467,0.9075},
{0.9493,0.9085},
{0.95,0.9168},
{0.9519,0.9092},
{0.9525,0.9171},
{0.9544,0.9096},
{0.9532,0.9027},
{0.9505,0.9022},
{0.5761,0.8767},
{0.5836,0.8792},
{0.5811,0.8807},
{0.573,0.878},
{0.5896,0.8816},
{0.4125,0.8708},
{0.4125,0.8613},
{0.4146,0.8618},
{0.4146,0.8719},
{0.4131,0.88},
{0.4153,0.8818},
{0.414,0.8885},
{0.4162,0.8908},
{0.4101,0.8698},
{0.4101,0.8608},
{0.4106,0.8786},
{0.4113,0.8866},
{0.4126,0.8936},
{0.4153,0.8959},
{0.4155,0.8519},
{0.4134,0.852},
{0.411,0.8519},
{0.4076,0.8604},
{0.4075,0.8691},
{0.4079,0.8775},
{0.4086,0.8853},
{0.4098,0.892},
{0.2496,0.9258},
{0.4129,0.8436},
{0.4154,0.8432},
{0.4104,0.8437},
{0.4084,0.8517},
{0.4064,0.8517},
{0.4055,0.8601},
{0.4054,0.8686},
{0.4057,0.8768},
{0.4064,0.8842},
{0.4075,0.8907},
{0.9498,0.9358},
{0.9473,0.9364},
{0.9477,0.9261},
{0.9501,0.9261},
{0.9453,0.9157},
{0.9454,0.9261},
{0.9451,0.9371},
{0.9468,0.9467},
{0.9493,0.9455},
{0.9518,0.9444},
{0.9522,0.9352},
{0.9526,0.9259},
{0.9489,0.9547},
{0.9464,0.9566},
{0.9515,0.9532},
{0.9539,0.9521},
{0.9542,0.9436},
{0.9545,0.9347},
{0.9549,0.9258},
{0.9549,0.9172},
{0.9564,0.91},
{0.9554,0.9034},
{0.9432,0.9379},
{0.9445,0.9482},
{0.9426,0.9496},
{0.9441,0.9587},
{0.9464,0.9654},
{0.949,0.963},
{0.9516,0.961},
{0.9541,0.9597},
{0.9561,0.9586},
{0.9559,0.9513},
{0.9561,0.9431},
{0.9564,0.9344},
{0.9567,0.9257},
{0.9567,0.9175},
{0.6653,0.7936},
{0.6597,0.7879},
{0.6612,0.7859},
{0.5638,0.8611},
{0.5679,0.8672},
{0.5649,0.8548},
{0.5668,0.8484},
{0.569,0.8417},
{0.569,0.8343},
{0.5694,0.8274},
{0.5698,0.8215},
{0.5703,0.8165},
{0.5676,0.8617},
{0.5714,0.8677},
{0.5682,0.8559},
{0.5695,0.8494},
{0.5712,0.8427},
{0.5713,0.8355},
{0.5717,0.8289},
{0.5722,0.8232},
{0.5695,0.8727},
{0.573,0.8723},
{0.9492,0.9701},
{0.9466,0.973},
{0.9519,0.9677},
{0.9544,0.9661},
{0.9565,0.9648},
{0.3112,0.4665},
{0.307,0.466},
{0.3125,0.461},
{0.3163,0.4617},
{0.3151,0.4664},
{0.3199,0.4617},
{0.3071,0.4728},
{0.3026,0.4726},
{0.3112,0.4725},
{0.3146,0.4718},
{0.3183,0.4657},
{0.3173,0.4711},
{0.3208,0.4651},
{0.3194,0.4711},
{0.3228,0.4654},
{0.3252,0.4606},
{0.327,0.461},
{0.3087,0.4596},
{0.3028,0.4649},
{0.2981,0.4718},
{0.2994,0.4807},
{0.3041,0.4807},
{0.3084,0.4802},
{0.3119,0.4793},
{0.3148,0.4785},
{0.317,0.4781},
{0.2972,0.4897},
{0.302,0.4893},
{0.3064,0.4886},
{0.3101,0.4876},
{0.313,0.4866},
{0.3154,0.4858},
{0.3172,0.4856},
{0.3187,0.4786},
{0.321,0.4724},
{0.3194,0.4711},
{0.3242,0.4671},
{0.3228,0.4654},
{0.3282,0.4631},
{0.327,0.461},
{0.332,0.4581},
{0.3329,0.4604},
{0.3377,0.4567},
{0.3381,0.4592},
{0.3439,0.4571},
{0.3439,0.4596},
{0.3503,0.4591},
{0.3498,0.4617},
{0.3565,0.4629},
{0.3555,0.4654},
{0.362,0.4683},
{0.3605,0.4707},
{0.3663,0.4755},
{0.3647,0.4775},
{0.357,0.4758},
{0.3608,0.482},
{0.3678,0.4856},
{0.3638,0.4892},
{0.3697,0.4945},
{0.3658,0.4972},
{0.3703,0.504},
{0.3668,0.5056},
{0.3605,0.5009},
{0.3619,0.508},
{0.3624,0.5154},
{0.3665,0.5143},
{0.3156,0.4561},
{0.3189,0.4578},
{0.3007,0.4982},
{0.2958,0.4988},
{0.3051,0.4972},
{0.3088,0.4961},
{0.3119,0.495},
{0.3143,0.4938},
{0.3163,0.4929},
{0.2998,0.5066},
{0.295,0.5075},
{0.3043,0.5054},
{0.3081,0.5042},
{0.3111,0.5029},
{0.3137,0.5016},
{0.3159,0.5001},
{0.2946,0.5151},
{0.2994,0.5139},
{0.3038,0.5126},
{0.3075,0.5113},
{0.3107,0.5099},
{0.3133,0.5084},
{0.3157,0.5067},
{0.837,0.0388},
{0.8325,0.0437},
{0.8327,0.0369},
{0.8265,0.0526},
{0.8277,0.0471},
{0.8248,0.0575},
{0.8194,0.0583},
{0.8169,0.0618},
{0.814,0.0648},
{0.8136,0.0705},
{0.8131,0.0759},
{0.8126,0.0815},
{0.8166,0.085},
{0.8211,0.0884},
{0.8232,0.0493},
{0.8242,0.0439},
{0.8215,0.0542},
{0.817,0.0552},
{0.8146,0.0587},
{0.8118,0.0617},
{0.8088,0.0642},
{0.8108,0.0673},
{0.81,0.0727},
{0.8091,0.0781},
{0.808,0.0841},
{0.812,0.0882},
{0.8167,0.0924},
{0.8284,0.0409},
{0.8248,0.0378},
{0.2998,0.5258},
{0.2993,0.5202},
{0.3009,0.5308},
{0.305,0.5291},
{0.304,0.5243},
{0.3037,0.5188},
{0.1532,0.2466},
{0.147,0.2431},
{0.1516,0.2351},
{0.1421,0.2325},
{0.149,0.2184},
{0.1568,0.251},
{0.4175,0.5245},
{0.4128,0.5273},
{0.4121,0.5207},
{0.4175,0.5168},
{0.6196,0.5336},
{0.6117,0.5374},
{0.6109,0.5318},
{0.6174,0.5288},
{0.6105,0.5265},
{0.6036,0.5274},
{0.6027,0.5334},
{0.6019,0.5402},
{0.6132,0.543},
{0.623,0.5371},
{0.3611,0.5968},
{0.3557,0.5984},
{0.3532,0.5932},
{0.3577,0.591},
{0.6221,0.5265},
{0.616,0.5237},
{0.6205,0.5201},
{0.6148,0.5194},
{0.6104,0.5219},
{0.3658,0.6033},
{0.373,0.6113},
{0.3739,0.6011},
{0.3686,0.5976},
{0.374,0.5913},
{0.3693,0.5892},
{0.3742,0.5806},
{0.3697,0.5792},
{0.3657,0.5763},
{0.3651,0.5853},
{0.3693,0.5892},
{0.3638,0.5923},
{0.3686,0.5976},
{0.3611,0.5968},
{0.3658,0.6033},
{0.6013,0.5481},
{0.602,0.5561},
{0.5975,0.5195},
{0.5924,0.5084},
{0.5891,0.4965},
{0.5876,0.4859},
{0.587,0.4777},
{0.5824,0.4734},
{0.5784,0.4698},
{0.6359,0.8077},
{0.6314,0.811},
{0.6309,0.8038},
{0.6361,0.7992},
{0.6286,0.7992},
{0.6249,0.8035},
{0.6271,0.808},
{0.6314,0.811},
{0.6277,0.8147},
{0.641,0.8054},
{0.6359,0.8077},
{0.6361,0.7992},
{0.642,0.7956},
{0.6339,0.7937},
{0.6421,0.7859},
{0.6353,0.8176},
{0.6401,0.8161},
{0.2548,0.799},
{0.2554,0.7923},
{0.2602,0.7984},
{0.2595,0.8043},
{0.2643,0.8068},
{0.2537,0.8055},
{0.2477,0.8093},
{0.2462,0.8149},
{0.2445,0.8194},
{0.2426,0.8225},
{0.2409,0.8249},
{0.2424,0.8288},
{0.2406,0.8312},
{0.2433,0.8351},
{0.2454,0.8408},
{0.2462,0.8485},
{0.246,0.8577},
{0.2454,0.8678},
{0.247,0.8774},
{0.2486,0.8876},
{0.25,0.8976},
{0.2501,0.7956},
{0.251,0.7883},
{0.249,0.8027},
{0.2462,0.7937},
{0.2487,0.7857},
{0.2448,0.8018},
{0.2437,0.8086},
{0.3651,0.5853},
{0.3618,0.5805},
{0.3626,0.5724},
{0.692,0.9193},
{0.6879,0.9266},
{0.686,0.9206},
{0.6901,0.9141},
{0.6839,0.9143},
{0.6796,0.9181},
{0.6817,0.9252},
{0.6839,0.9319},
{0.6776,0.9288},
{0.6816,0.9358},
{0.695,0.9097},
{0.6929,0.9053},
{0.6878,0.9086},
{0.6817,0.9081},
{0.6775,0.9112},
{0.6736,0.9126},
{0.6754,0.92},
{0.6737,0.9263},
{0.672,0.9199},
{0.6706,0.9127},
{0.669,0.9186},
{0.6681,0.9119},
{0.6694,0.9061},
{0.6673,0.9053},
{0.6658,0.9105},
{0.6654,0.904},
{0.6632,0.9087},
{0.6629,0.9147},
{0.6661,0.9169},
{0.3604,0.5868},
{0.3577,0.591},
{0.4093,0.7316},
{0.4122,0.7315},
{0.411,0.7371},
{0.4078,0.7372},
{0.4101,0.7435},
{0.4068,0.7437},
{0.4025,0.744},
{0.3968,0.7444},
{0.3913,0.7519},
{0.3913,0.7438},
{0.3972,0.7379},
{0.3909,0.7374},
{0.4045,0.7321},
{0.4093,0.7316},
{0.4033,0.7374},
{0.8598,0.3604},
{0.8605,0.3578},
{0.8643,0.3577},
{0.864,0.3608},
{0.8597,0.364},
{0.8641,0.3645},
{0.8599,0.3681},
{0.8643,0.3688},
{0.8551,0.3639},
{0.8552,0.3604},
{0.8554,0.368},
{0.2909,0.5415},
{0.2936,0.5463},
{0.2907,0.5482},
{0.2881,0.5433},
{0.2925,0.5573},
{0.2911,0.554},
{0.2935,0.5524},
{0.296,0.5559},
{0.2966,0.5505},
{0.4133,0.7467},
{0.4175,0.7432},
{0.4185,0.7464},
{0.4146,0.7496},
{0.4122,0.7411},
{0.4174,0.7386},
{0.2425,0.8144},
{0.2411,0.819},
{0.2395,0.8222},
{0.238,0.8246},
{0.2395,0.8269},
{0.2383,0.829},
{0.237,0.8315},
{0.2389,0.8344},
{0.2412,0.8386},
{0.243,0.8444},
{0.2436,0.8517},
{0.2406,0.8482},
{0.241,0.8551},
{0.2381,0.8518},
{0.2384,0.8582},
{0.2357,0.8546},
{0.2358,0.8605},
{0.2332,0.856},
{0.2333,0.8616},
{0.6755,0.9051},
{0.6793,0.9025},
{0.672,0.9062},
{0.6703,0.901},
{0.6681,0.9007},
{0.6664,0.8997},
{0.6735,0.9002},
{0.677,0.8979},
{0.6715,0.8966},
{0.6686,0.8973},
{0.6697,0.8941},
{0.6671,0.8946},
{0.6682,0.8919},
{0.6661,0.8925},
{0.6656,0.8908},
{0.6644,0.8919},
{0.6653,0.8941},
{0.6671,0.8946},
{0.6666,0.8968},
{0.6686,0.8973},
{0.6748,0.8946},
{0.6726,0.892},
{0.6706,0.8898},
{0.6668,0.8899},
{0.6642,0.8898},
{0.6162,0.5119},
{0.6195,0.5082},
{0.6213,0.5114},
{0.6183,0.5156},
{0.613,0.5157},
{0.6172,0.5048},
{0.6209,0.5019},
{0.6227,0.5046},
{0.6134,0.5082},
{0.6098,0.5123},
{0.6101,0.5183},
{0.6048,0.522},
{0.6007,0.5138},
{0.5973,0.503},
{0.5945,0.492},
{0.5925,0.4826},
{0.5912,0.4754},
{0.5868,0.4718},
{0.6095,0.5029},
{0.6152,0.501},
{0.6047,0.5084},
{0.6068,0.5171},
{0.6202,0.8},
{0.6203,0.7946},
{0.6222,0.7945},
{0.6221,0.8001},
{0.6243,0.7944},
{0.6243,0.7998},
{0.7763,0.0866},
{0.7745,0.0907},
{0.7716,0.0882},
{0.7738,0.085},
{0.7693,0.085},
{0.7664,0.0871},
{0.7689,0.0913},
{0.7722,0.0953},
{0.7782,0.0919},
{0.7794,0.0871},
{0.7774,0.0829},
{0.7753,0.082},
{0.7778,0.0796},
{0.7758,0.0791},
{0.7778,0.0766},
{0.7759,0.0763},
{0.7778,0.0741},
{0.7759,0.0737},
{0.7782,0.0718},
{0.7762,0.0713},
{0.7766,0.0975},
{0.7827,0.0967},
{0.7831,0.091},
{0.7794,0.0871},
{0.7834,0.0861},
{0.78,0.083},
{0.7835,0.0819},
{0.7802,0.0794},
{0.7832,0.0783},
{0.78,0.0764},
{0.7828,0.0752},
{0.7798,0.0739},
{0.7823,0.0727},
{0.7798,0.0722},
{0.78,0.0764},
{0.7802,0.0794},
{0.78,0.083},
{0.7645,0.083},
{0.7676,0.0817},
{0.4126,0.6159},
{0.4152,0.6137},
{0.4164,0.6163},
{0.4141,0.6178},
{0.4105,0.6178},
{0.4123,0.6194},
{0.4151,0.6193},
{0.4143,0.6208},
{0.4109,0.6211},
{0.4132,0.6225},
{0.4098,0.6231},
{0.4122,0.6245},
{0.409,0.6256},
{0.4115,0.6269},
{0.4089,0.6291},
{0.4114,0.6303},
{0.414,0.6276},
{0.4139,0.631},
{0.4164,0.6275},
{0.4163,0.6311},
{0.7702,0.0804},
{0.7717,0.0829},
{0.7693,0.0779},
{0.7663,0.0786},
{0.7718,0.0796},
{0.7734,0.0807},
{0.7718,0.0777},
{0.7716,0.0754},
{0.7688,0.0754},
{0.7655,0.0758},
{0.765,0.0731},
{0.7618,0.071},
{0.6607,0.9012},
{0.6601,0.9066},
{0.6568,0.9044},
{0.6577,0.9},
{0.6536,0.9024},
{0.652,0.9051},
{0.6553,0.9081},
{0.6591,0.9115},
{0.6634,0.9025},
{0.6632,0.8971},
{0.6608,0.8962},
{0.658,0.8958},
{0.6554,0.8957},
{0.6548,0.899},
{0.6507,0.9005},
{0.6491,0.9026},
{0.6105,0.4904},
{0.6139,0.4915},
{0.6142,0.4963},
{0.6099,0.4958},
{0.6017,0.4978},
{0.6139,0.4872},
{0.6113,0.4859},
{0.6143,0.4835},
{0.6123,0.4821},
{0.6154,0.4804},
{0.6136,0.4791},
{0.6165,0.478},
{0.6148,0.4766},
{0.6173,0.476},
{0.6157,0.4748},
{0.6534,0.8959},
{0.6523,0.8979},
{0.6485,0.8987},
{0.6467,0.9004},
{0.7943,0.0858},
{0.7886,0.0887},
{0.7879,0.0841},
{0.7928,0.0816},
{0.7874,0.08},
{0.7896,0.0939},
{0.7964,0.0905},
{0.7998,0.0828},
{0.7976,0.0789},
{0.7916,0.0777},
{0.7868,0.0765},
{0.7912,0.0996},
{0.7992,0.0957},
{0.8026,0.0871},
{0.8047,0.0803},
{0.802,0.0767},
{0.7959,0.0754},
{0.7907,0.0743},
{0.7861,0.0734},
{0.7829,0.1028},
{0.7843,0.1093},
{0.7937,0.1056},
{0.8028,0.1013},
{0.8063,0.0917},
{0.8061,0.0747},
{0.8038,0.0714},
{0.7999,0.0733},
{0.7946,0.0721},
{0.7897,0.0713},
{0.7851,0.071},
{0.8108,0.0967},
{0.5984,0.4877},
{0.6013,0.4838},
{0.6062,0.4876},
{0.6044,0.4925},
{0.6113,0.4859},
{0.6077,0.4835},
{0.6036,0.4803},
{0.5962,0.4796},
{0.6055,0.4772},
{0.5991,0.4768},
{0.6015,0.4742},
{0.6074,0.4745},
{0.6036,0.4718},
{0.6092,0.4723},
{0.6056,0.4697},
{0.3318,0.5649},
{0.3291,0.5672},
{0.3239,0.5631},
{0.3271,0.5608},
{0.3226,0.5571},
{0.3192,0.5595},
{0.3184,0.5537},
{0.3149,0.5561},
{0.3149,0.5616},
{0.3107,0.5584},
{0.311,0.5528},
{0.307,0.5552},
{0.3059,0.5602},
{0.3027,0.5573},
{0.3035,0.5519},
{0.2997,0.5542},
{0.2981,0.5586},
{0.3002,0.5482},
{0.2972,0.5441},
{0.2945,0.5395},
{0.2985,0.5374},
{0.3026,0.5354},
{0.3065,0.5336},
{0.3099,0.5321},
{0.3084,0.5277},
{0.3076,0.5229},
{0.3074,0.5175},
{0.334,0.5627},
{0.3296,0.5586},
{0.3254,0.5549},
{0.3215,0.5515},
{0.3178,0.5482},
{0.3146,0.5504},
{0.311,0.547},
{0.3074,0.5494},
{0.304,0.5458},
{0.6092,0.48},
{0.6108,0.477},
{0.6123,0.4747},
{0.6123,0.4821},
{0.6136,0.4791},
{0.6148,0.4766},
{0.6136,0.473},
{0.8074,0.0694},
{0.8055,0.0664},
{0.802,0.0683},
{0.7984,0.0701},
{0.7934,0.0692},
{0.7885,0.0689},
{0.3144,0.5448},
{0.3113,0.5413},
{0.3078,0.5434},
{0.301,0.5418},
{0.305,0.5395},
{0.3087,0.5376},
{0.3119,0.5361},
{0.3148,0.5348},
{0.3129,0.5308},
{0.3115,0.5264},
{0.3107,0.5215},
{0.3105,0.5161},
{0.3144,0.5398},
{0.3172,0.5385},
{0.3199,0.537},
{0.3176,0.5333},
{0.3157,0.5292},
{0.3144,0.5248},
{0.3136,0.5199},
{0.3132,0.5145},
{0.5641,0.4634},
{0.5606,0.4624},
{0.8125,0.0557},
{0.8149,0.0522},
{0.8105,0.0529},
{0.8079,0.0559},
{0.8099,0.0587},
{0.807,0.0613},
{0.819,0.051},
{0.8168,0.048},
{0.8127,0.0494},
{0.808,0.0503},
{0.8055,0.0533},
{0.8027,0.056},
{0.8051,0.0585},
{0.802,0.0608},
{0.8038,0.0635},
{0.8005,0.0654},
{0.797,0.0673},
{0.792,0.0667},
{0.8146,0.0453},
{0.8102,0.0468},
{0.8121,0.0428},
{0.8071,0.0445},
{0.8048,0.0479},
{0.3226,0.5405},
{0.32,0.542},
{0.3254,0.5386},
{0.3228,0.535},
{0.3205,0.5313},
{0.3186,0.5272},
{0.3172,0.5227},
{0.3163,0.5179},
{0.3158,0.5126},
{0.3173,0.5433},
{0.3206,0.5466},
{0.3231,0.5453},
{0.3256,0.5439},
{0.3282,0.542},
{0.3312,0.5393},
{0.3284,0.5358},
{0.3259,0.5322},
{0.3236,0.5284},
{0.3217,0.5243},
{0.3201,0.52},
{0.319,0.5153},
{0.3183,0.5101},
{0.3241,0.5499},
{0.3265,0.5485},
{0.3288,0.5471},
{0.3313,0.5453},
{0.3341,0.5427},
{0.3371,0.5397},
{0.3344,0.536},
{0.3317,0.5324},
{0.3292,0.5287},
{0.3269,0.5249},
{0.3248,0.521},
{0.3231,0.5168},
{0.3218,0.5122},
{0.3261,0.5134},
{0.3245,0.5091},
{0.329,0.5102},
{0.3272,0.5061},
{0.3317,0.5074},
{0.3299,0.5035},
{0.3258,0.5017},
{0.3283,0.4993},
{0.3326,0.5007},
{0.331,0.4966},
{0.3357,0.4971},
{0.334,0.4933},
{0.3298,0.4921},
{0.3325,0.4892},
{0.329,0.4868},
{0.3318,0.4844},
{0.3353,0.4851},
{0.334,0.4824},
{0.3319,0.4783},
{0.3351,0.4776},
{0.3325,0.4717},
{0.3364,0.471},
{0.3376,0.4644},
{0.3329,0.4653},
{0.7988,0.0628},
{0.7955,0.0648},
{0.5942,0.7974},
{0.592,0.7954},
{0.5958,0.7933},
{0.5978,0.7952},
{0.5998,0.791},
{0.6017,0.7928},
{0.6057,0.7901},
{0.6041,0.7883},
{0.6093,0.7877},
{0.608,0.7859},
{0.7998,0.0584},
{0.7967,0.0606},
{0.3301,0.5519},
{0.3323,0.5505},
{0.3346,0.5487},
{0.3372,0.5463},
{0.34,0.5434},
{0.3429,0.5404},
{0.3402,0.5364},
{0.3376,0.5326},
{0.335,0.5288},
{0.3325,0.5251},
{0.3301,0.5213},
{0.328,0.5175},
{0.331,0.5141},
{0.3338,0.5111},
{0.3367,0.5081},
{0.3345,0.5044},
{0.3378,0.5008},
{0.3418,0.496},
{0.3394,0.4922},
{0.3372,0.4886},
{0.3409,0.4818},
{0.338,0.479},
{0.3405,0.472},
{0.3426,0.465},
{0.3359,0.5541},
{0.3339,0.5555},
{0.338,0.5524},
{0.3404,0.55},
{0.3429,0.5473},
{0.3455,0.5443},
{0.3481,0.5414},
{0.3457,0.5372},
{0.3432,0.5332},
{0.3407,0.5292},
{0.3381,0.5253},
{0.3356,0.5215},
{0.3332,0.5178},
{0.3361,0.5147},
{0.339,0.5117},
{0.3425,0.5084},
{0.3401,0.5046},
{0.3443,0.5001},
{0.3498,0.4942},
{0.3469,0.4895},
{0.3439,0.4854},
{0.3485,0.4778},
{0.3445,0.4743},
{0.3477,0.4672},
{0.3279,0.5533},
{0.3319,0.5569},
{0.3379,0.5596},
{0.3397,0.5581},
{0.3416,0.5564},
{0.3436,0.554},
{0.3458,0.5513},
{0.348,0.5484},
{0.3503,0.5455},
{0.3527,0.5428},
{0.3506,0.5386},
{0.3483,0.5343},
{0.346,0.5302},
{0.3435,0.5261},
{0.341,0.5222},
{0.3385,0.5184},
{0.3415,0.5155},
{0.345,0.5124},
{0.3492,0.509},
{0.3468,0.5044},
{0.3524,0.4994},
{0.3584,0.4941},
{0.3555,0.4879},
{0.3522,0.4824},
{0.3526,0.4708},
{0.336,0.561},
{0.7813,0.0709},
{0.7838,0.069},
{0.7796,0.0697},
{0.3461,0.5646},
{0.3449,0.5663},
{0.3416,0.5634},
{0.3432,0.5619},
{0.3448,0.5601},
{0.3465,0.5578},
{0.3483,0.5552},
{0.3502,0.5523},
{0.3522,0.5495},
{0.3545,0.5469},
{0.3569,0.5449},
{0.3551,0.5407},
{0.3531,0.5362},
{0.3509,0.5318},
{0.3487,0.5275},
{0.3464,0.5233},
{0.344,0.5193},
{0.3472,0.5628},
{0.3487,0.5609},
{0.3503,0.5586},
{0.3518,0.5558},
{0.3485,0.5642},
{0.3483,0.566},
{0.3499,0.5634},
{0.3499,0.5655},
{0.4088,0.6196},
{0.4076,0.6216},
{0.4069,0.6242},
{0.4066,0.6277},
{0.6489,0.8945},
{0.6468,0.8967},
{0.6455,0.8945},
{0.6477,0.8924},
{0.6446,0.8919},
{0.643,0.8935},
{0.6438,0.896},
{0.645,0.8983},
{0.6504,0.8964},
{0.6525,0.8943},
{0.6513,0.8923},
{0.6503,0.8902},
{0.6468,0.8898},
{0.6438,0.8887},
{0.6421,0.8906},
{0.655,0.8931},
{0.654,0.8908},
{0.653,0.8885},
{0.6494,0.8876},
{0.6461,0.8865},
{0.7651,0.0705},
{0.7624,0.0685},
{0.7657,0.0679},
{0.7684,0.0728},
{0.7684,0.0703},
{0.7714,0.0729},
{0.7715,0.0704},
{0.8528,0.3614},
{0.8529,0.3581},
{0.8551,0.3577},
{0.8551,0.361},
{0.8551,0.3642},
{0.8528,0.3646},
{0.8551,0.367},
{0.8529,0.3674},
{0.8548,0.3692},
{0.8528,0.3696},
{0.854,0.3709},
{0.8522,0.3714},
{0.8499,0.3698},
{0.8493,0.3716},
{0.8463,0.3698},
{0.8456,0.3719},
{0.6574,0.8845},
{0.6583,0.8873},
{0.6558,0.8876},
{0.6549,0.8848},
{0.6521,0.8859},
{0.6568,0.89},
{0.6576,0.8926},
{0.6602,0.8926},
{0.2702,0.8001},
{0.2725,0.7996},
{0.2733,0.802},
{0.271,0.8023},
{0.8502,0.3614},
{0.8505,0.3581},
{0.8501,0.3647},
{0.8501,0.3675},
{0.8467,0.3673},
{0.8469,0.3645},
{0.8473,0.3611},
{0.6488,0.8843},
{0.6456,0.8827},
{0.6484,0.8805},
{0.6516,0.8825},
{0.6512,0.8786},
{0.6544,0.8813},
{0.654,0.8773},
{0.6568,0.8768},
{0.6565,0.8721},
{0.6537,0.8728},
{0.6559,0.8672},
{0.6531,0.8681},
{0.6549,0.8621},
{0.652,0.8633},
{0.2372,0.8265},
{0.2356,0.8274},
{0.2364,0.8254},
{0.238,0.8246},
{0.237,0.8282},
{0.2357,0.8294},
{0.4175,0.5189},
{0.4177,0.5168},
{0.4188,0.5183},
{0.4188,0.5207},
{0.2713,0.7959},
{0.2733,0.7954},
{0.2727,0.7973},
{0.2705,0.7978},
{0.6753,0.8881},
{0.6729,0.8859},
{0.6686,0.8875},
{0.6651,0.8877},
{0.6627,0.8882},
{0.6632,0.8854},
{0.6613,0.8864},
{0.6614,0.8831},
{0.6596,0.885},
{0.6594,0.8815},
{0.657,0.8809},
{0.677,0.8819},
{0.6745,0.8797},
{0.6705,0.8835},
{0.6664,0.8847},
{0.6642,0.8818},
{0.6618,0.8791},
{0.6594,0.8773},
{0.677,0.8731},
{0.6744,0.8711},
{0.6717,0.8774},
{0.6678,0.8804},
{0.6651,0.8772},
{0.6622,0.8744},
{0.6593,0.8725},
{0.6589,0.8673},
{0.658,0.8618},
{0.6565,0.856},
{0.6535,0.8569},
{0.8182,0.0432},
{0.8192,0.0378},
{0.8215,0.0407},
{0.8205,0.0462},
{0.816,0.0405},
{0.817,0.0352},
{0.8136,0.0383},
{0.8146,0.0332},
{0.8197,0.0319},
{0.8175,0.0295},
{0.8152,0.0278},
{0.8117,0.0319},
{0.8105,0.0365},
{0.809,0.0407},
{0.8034,0.0425},
{0.8011,0.0458},
{0.8176,0.0235},
{0.8154,0.0221},
{0.8125,0.0269},
{0.8084,0.031},
{0.8071,0.0351},
{0.8055,0.039},
{0.5731,0.8368},
{0.5729,0.8434},
{0.5737,0.8306},
{0.5708,0.8568},
{0.5717,0.85},
{0.5729,0.8571},
{0.5732,0.8634},
{0.5752,0.8635},
{0.5767,0.8692},
{0.5785,0.8691},
{0.581,0.8739},
{0.5827,0.8737},
{0.5734,0.85},
{0.5746,0.8564},
{0.5729,0.8571},
{0.5768,0.8623},
{0.5752,0.8635},
{0.5799,0.8675},
{0.5785,0.8691},
{0.5827,0.8737},
{0.5838,0.8718},
{0.5877,0.877},
{0.5886,0.8749},
{0.5936,0.8789},
{0.594,0.8765},
{0.6,0.8793},
{0.5999,0.8767},
{0.6063,0.878},
{0.6057,0.8753},
{0.5986,0.8713},
{0.6037,0.8697},
{0.5966,0.8643},
{0.6008,0.8625},
{0.5941,0.8568},
{0.5975,0.8546},
{0.5915,0.8499},
{0.5893,0.8523},
{0.591,0.8583},
{0.5743,0.8685},
{0.5707,0.8627},
{0.4181,0.5031},
{0.4185,0.5106},
{0.4174,0.5096},
{0.4171,0.5024},
{0.418,0.4949},
{0.4171,0.4946},
{0.4185,0.4865},
{0.4176,0.4865},
{0.9567,0.9696},
{0.9546,0.971},
{0.952,0.9729},
{0.4185,0.7956},
{0.4172,0.7969},
{0.4169,0.7907},
{0.4181,0.7896},
{0.4166,0.7834},
{0.4179,0.7826},
{0.4168,0.7752},
{0.4179,0.7748},
{0.4171,0.7665},
{0.4182,0.7665},
{0.4173,0.7578},
{0.4185,0.7582},
{0.4185,0.7502},
{0.4174,0.7496},
{0.4083,0.8439},
{0.4114,0.8371},
{0.4135,0.8367},
{0.4162,0.8363},
{0.245,0.928},
{0.2428,0.9354},
{0.2417,0.9351},
{0.2438,0.928},
{0.2453,0.9195},
{0.2467,0.9194},
{0.2461,0.91},
{0.2476,0.9096},
{0.2464,0.8996},
{0.2482,0.8989},
{0.2466,0.8887},
{0.6122,0.875},
{0.6113,0.8723},
{0.6087,0.8668},
{0.605,0.8596},
{0.6009,0.8519},
{0.5942,0.8474},
{0.5891,0.8448},
{0.5872,0.8478},
{0.2482,0.8989},
{0.2492,0.9085},
{0.2476,0.9096},
{0.2442,0.9093},
{0.2444,0.8994},
{0.2464,0.8996},
{0.2461,0.91},
{0.6161,0.8677},
{0.6173,0.8702},
{0.2445,0.8891},
{0.2466,0.8887},
{0.2448,0.8785},
{0.6644,0.8063},
{0.667,0.8161},
{0.6651,0.8156},
{0.6627,0.8061},
{0.6613,0.7979},
{0.6599,0.798},
{0.6607,0.8077},
{0.6627,0.8061},
{0.6651,0.8156},
{0.6629,0.8167},
{0.6647,0.8267},
{0.6672,0.8262},
{0.6666,0.8373},
{0.6692,0.8375},
{0.6686,0.8484},
{0.6714,0.8492},
{0.6715,0.8386},
{0.6693,0.8269},
{0.6672,0.8262},
{0.667,0.8161},
{0.6687,0.8175},
{0.6713,0.8285},
{0.6737,0.8403},
{0.6762,0.8526},
{0.6738,0.8507},
{0.6758,0.8625},
{0.6732,0.8607},
{0.6704,0.8592},
{0.6716,0.8691},
{0.6687,0.8745},
{0.6655,0.8715},
{0.6622,0.8689},
{0.6613,0.8627},
{0.66,0.856},
{0.6199,0.8033},
{0.6182,0.8063},
{0.6163,0.8035},
{0.618,0.8006},
{0.6146,0.8002},
{0.6122,0.8032},
{0.614,0.8066},
{0.6159,0.8096},
{0.6179,0.812},
{0.6202,0.8084},
{0.232,0.8456},
{0.2297,0.8462},
{0.2292,0.8419},
{0.2314,0.8412},
{0.234,0.844},
{0.2331,0.8396},
{0.2357,0.8413},
{0.2345,0.8371},
{0.2373,0.8379},
{0.2356,0.8342},
{0.2338,0.8338},
{0.2346,0.8314},
{0.4104,0.6364},
{0.4101,0.6388},
{0.4073,0.6388},
{0.4075,0.6363},
{0.4096,0.6345},
{0.4066,0.6344},
{0.6153,0.8156},
{0.6133,0.813},
{0.235,0.849},
{0.2327,0.8506},
{0.2371,0.8462},
{0.2391,0.8425},
{0.6114,0.8099},
{0.6086,0.8129},
{0.6106,0.8162},
{0.6128,0.819},
{0.6095,0.8063},
{0.6066,0.8093},
{0.6036,0.8121},
{0.6058,0.8159},
{0.6079,0.8193},
{0.6103,0.8223},
{0.8729,0.3364},
{0.8762,0.3338},
{0.8765,0.3382},
{0.8738,0.341},
{0.8694,0.3398},
{0.8713,0.3448},
{0.8661,0.3437},
{0.8692,0.3491},
{0.8635,0.3477},
{0.8678,0.3536},
{0.862,0.3516},
{0.8672,0.3577},
{0.6078,0.8255},
{0.6052,0.8222},
{0.6051,0.8284},
{0.6023,0.8248},
{0.8721,0.3315},
{0.8761,0.3293},
{0.8675,0.3344},
{0.8629,0.3377},
{0.859,0.3411},
{0.8564,0.3444},
{0.8715,0.3266},
{0.8762,0.3248},
{0.8659,0.3289},
{0.8601,0.3314},
{0.855,0.3341},
{0.8514,0.3367},
{0.6029,0.8186},
{0.6,0.8213},
{0.5995,0.8274},
{0.6023,0.8312},
{0.6007,0.8148},
{0.5977,0.8174},
{0.5949,0.8199},
{0.5971,0.8237},
{0.5966,0.8298},
{0.5994,0.8339},
{0.6058,0.8356},
{0.6029,0.8388},
{0.6105,0.8408},
{0.6075,0.8449},
{0.6154,0.8462},
{0.6125,0.8513},
{0.6043,0.8486},
{0.6089,0.8558},
{0.6169,0.8572},
{0.6131,0.8625},
{0.6202,0.8617},
{0.3495,0.5209},
{0.3516,0.5254},
{0.3473,0.5166},
{0.3532,0.5187},
{0.3548,0.5238},
{0.3514,0.5138},
{0.3536,0.5299},
{0.5943,0.8261},
{0.5921,0.8223},
{0.5897,0.8181},
{0.5871,0.8208},
{0.5894,0.8249},
{0.5916,0.8285},
{0.8714,0.3218},
{0.8765,0.3203},
{0.865,0.3235},
{0.8582,0.3253},
{0.8522,0.3272},
{0.8478,0.3292},
{0.8505,0.3205},
{0.8456,0.3218},
{0.5939,0.8323},
{0.5966,0.8365},
{0.6,0.8418},
{0.597,0.8447},
{0.5913,0.8348},
{0.5939,0.8392},
{0.5914,0.8419},
{0.5891,0.8312},
{0.5868,0.8341},
{0.589,0.8376},
{0.5869,0.8407},
{0.587,0.8276},
{0.5848,0.8306},
{0.5828,0.834},
{0.5848,0.8373},
{0.583,0.8411},
{0.5851,0.8443},
{0.7963,0.0217},
{0.7953,0.026},
{0.7919,0.0249},
{0.7929,0.021},
{0.7886,0.0224},
{0.7902,0.02},
{0.7857,0.018},
{0.7892,0.0162},
{0.7831,0.0126},
{0.7785,0.015},
{0.7824,0.0205},
{0.4134,0.7053},
{0.4132,0.6997},
{0.4159,0.7002},
{0.4161,0.7056},
{0.4132,0.7115},
{0.4161,0.7118},
{0.8001,0.0219},
{0.7989,0.0264},
{0.8011,0.016},
{0.7971,0.0159},
{0.793,0.0158},
{0.7929,0.01},
{0.7879,0.0109},
{0.781,0.0072},
{0.7751,0.0097},
{0.9411,0.635},
{0.9381,0.6365},
{0.9378,0.6316},
{0.9407,0.6298},
{0.9443,0.6336},
{0.9439,0.6283},
{0.9477,0.632},
{0.9471,0.6264},
{0.9434,0.6234},
{0.9465,0.6212},
{0.9502,0.6244},
{0.9494,0.6189},
{0.9528,0.6223},
{0.9519,0.6164},
{0.9417,0.6411},
{0.9386,0.6425},
{0.9451,0.6397},
{0.9484,0.638},
{0.9515,0.6364},
{0.9509,0.6302},
{0.9536,0.6287},
{0.4052,0.7099},
{0.4052,0.7033},
{0.4076,0.704},
{0.4075,0.7101},
{0.4104,0.7047},
{0.4104,0.699},
{0.4077,0.6981},
{0.8035,0.0341},
{0.8049,0.0305},
{0.8017,0.0376},
{0.413,0.6946},
{0.4103,0.6936},
{0.5827,0.8269},
{0.5848,0.8236},
{0.5825,0.8196},
{0.5846,0.8166},
{0.5871,0.8138},
{0.5924,0.8156},
{0.5898,0.8113},
{0.5845,0.8099},
{0.5872,0.8073},
{0.5927,0.8089},
{0.5901,0.8049},
{0.5846,0.804},
{0.5875,0.8017},
{0.5932,0.8027},
{0.5907,0.7995},
{0.5965,0.8004},
{0.6,0.7981},
{0.6036,0.7956},
{0.6073,0.7928},
{0.6106,0.7902},
{0.6131,0.7881},
{0.612,0.7859},
{0.4103,0.7107},
{0.4099,0.7172},
{0.4127,0.7184},
{0.4092,0.7232},
{0.4119,0.7253},
{0.4082,0.7276},
{0.4109,0.7309},
{0.9541,0.6354},
{0.9559,0.6344},
{0.9554,0.6271},
{0.3179,0.5046},
{0.8022,0.051},
{0.5953,0.8132},
{0.5983,0.8107},
{0.5958,0.8065},
{0.5989,0.8041},
{0.6022,0.8016},
{0.6055,0.7989},
{0.6089,0.796},
{0.6119,0.7932},
{0.6143,0.7907},
{0.6156,0.7886},
{0.6146,0.7863},
{0.6013,0.8081},
{0.6044,0.8054},
{0.6075,0.8026},
{0.6105,0.7996},
{0.6132,0.7967},
{0.6153,0.794},
{0.4117,0.6344},
{0.4091,0.6332},
{0.6636,0.8566},
{0.6649,0.8645},
{0.6671,0.8578},
{0.6654,0.8481},
{0.6618,0.8483},
{0.6684,0.8667},
{0.6634,0.8382},
{0.3624,0.5226},
{0.3586,0.5229},
{0.3578,0.5169},
{0.3565,0.5108},
{0.3547,0.505},
{0.8572,0.3194},
{0.7727,0.0059},
{0.7796,0.0032},
{0.787,0.0054},
{0.7865,0.0013},
{0.7929,0.0043},
{0.7932,0.0002},
{0.7993,0.0},
{0.7984,0.004},
{0.8047,0.0009},
{0.8034,0.0046},
{0.8091,0.0029},
{0.8076,0.0059},
{0.8123,0.0062},
{0.8106,0.0082},
{0.8143,0.0107},
{0.8125,0.0117},
{0.8152,0.0162},
{0.8131,0.0164},
{0.8129,0.0218},
{0.8022,0.0099},
{0.7977,0.0097},
{0.8061,0.0106},
{0.8049,0.0162},
{0.8037,0.0218},
{0.9364,0.651},
{0.9394,0.6499},
{0.9404,0.6576},
{0.9367,0.6584},
{0.9414,0.6646},
{0.9455,0.6624},
{0.9441,0.6559},
{0.9428,0.6484},
{0.936,0.6442},
{0.9476,0.6535},
{0.9462,0.6467},
{0.9466,0.667},
{0.9421,0.6698},
{0.9504,0.6627},
{0.9492,0.659},
{0.952,0.6546},
{0.9505,0.6504},
{0.9493,0.6445},
{0.9371,0.6656},
{0.9374,0.6711},
{0.4054,0.7167},
{0.4074,0.7163},
{0.4076,0.7209},
{0.4063,0.7228},
{0.9522,0.6475},
{0.9538,0.6491},
{0.9551,0.65},
{0.9559,0.6423},
{0.9543,0.6424},
{0.9521,0.6428},
{0.9533,0.6569},
{0.0972,0.2827},
{0.1114,0.2742},
{0.1116,0.2822},
{0.0973,0.2903},
{0.1104,0.2928},
{0.1235,0.2869},
{0.125,0.2758},
{0.1248,0.2674},
{0.1103,0.2689},
{0.0964,0.2777},
{0.0819,0.2872},
{0.0823,0.2919},
{0.0823,0.299},
{0.0963,0.3003},
{0.1074,0.3058},
{0.12,0.3003},
{0.1313,0.2976},
{0.1353,0.2839},
{0.1372,0.2723},
{0.1372,0.2632},
{0.1235,0.2618},
{0.0813,0.3085},
{0.0937,0.3128},
{0.0791,0.3204},
{0.0891,0.3277},
{0.1021,0.3211},
{0.3576,0.8517},
{0.358,0.8666},
{0.3571,0.8829},
{0.3559,0.8997},
{0.355,0.9161},
{0.3543,0.9314},
{0.3532,0.9449},
{0.3596,0.9535},
{0.3515,0.9559},
{0.3556,0.9617},
{0.3489,0.9638},
{0.3405,0.957},
{0.3398,0.9645},
{0.3553,0.839},
{0.341,0.8459},
{0.3429,0.8576},
{0.3431,0.8716},
{0.3423,0.8869},
{0.3413,0.9028},
{0.3409,0.9185},
{0.3409,0.9333},
{0.3408,0.9464},
{0.3842,0.5383},
{0.382,0.5538},
{0.0376,0.3178},
{0.0519,0.3094},
{0.0512,0.3154},
{0.0366,0.3231},
{0.0249,0.326},
{0.0236,0.3307},
{0.0666,0.3074},
{0.067,0.3008},
{0.0525,0.3054},
{0.0671,0.2964},
{0.0657,0.3162},
{0.0501,0.3235},
{0.0512,0.3154},
{0.0666,0.3074},
{0.0637,0.3274},
{0.0484,0.3338},
{0.0366,0.3231},
{0.0355,0.3304},
{0.034,0.3398},
{0.0456,0.3467},
{0.0603,0.341},
{0.0751,0.3347},
{0.0225,0.3371},
{0.0129,0.3383},
{0.012,0.3437},
{0.0225,0.3371},
{0.0213,0.3454},
{0.0318,0.3516},
{0.4037,0.5413},
{0.3982,0.5427},
{0.4005,0.5328},
{0.4066,0.5311},
{0.4022,0.5529},
{0.3972,0.5541},
{0.3646,0.4497},
{0.4394,0.8251},
{0.4471,0.814},
{0.0114,0.3506},
{0.0042,0.3558},
{0.0042,0.3502},
{0.3927,0.5699},
{0.3972,0.5669},
{0.3979,0.5804},
{0.3936,0.5821},
{0.3987,0.5941},
{0.4027,0.5942},
{0.4021,0.5801},
{0.4018,0.5661},
{0.3923,0.5582},
{0.3887,0.5761},
{0.3898,0.5863},
{0.3947,0.5944},
{0.3951,0.6061},
{0.3991,0.6072},
{0.4031,0.6079},
{0.4062,0.5944},
{0.4057,0.5803},
{0.4057,0.5664},
{0.3911,0.5969},
{0.3923,0.605},
{0.3908,0.612},
{0.3943,0.6168},
{0.3985,0.6192},
{0.4028,0.6203},
{0.4066,0.6079},
{0.2222,0.8955},
{0.2173,0.8976},
{0.2202,0.8872},
{0.2257,0.8851},
{0.2218,0.876},
{0.2134,0.8787},
{0.2126,0.8899},
{0.2107,0.9},
{0.213,0.9066},
{0.2074,0.9085},
{0.2025,0.903},
{0.2005,0.9107},
{0.2027,0.9151},
{0.1969,0.9163},
{0.1924,0.9135},
{0.1896,0.9185},
{0.1858,0.915},
{0.182,0.9192},
{0.1832,0.9115},
{0.1755,0.9163},
{0.1797,0.9044},
{0.1696,0.9099},
{0.1759,0.8946},
{0.1639,0.9006},
{0.1722,0.8831},
{0.1589,0.8892},
{0.169,0.8704},
{0.1548,0.8763},
{0.1667,0.8574},
{0.152,0.8628},
{0.1658,0.8448},
{0.1511,0.8495},
{0.1656,0.8329},
{0.1511,0.8366},
{0.1654,0.8219},
{0.1514,0.8245},
{0.1644,0.812},
{0.1511,0.8134},
{0.2031,0.8936},
{0.1915,0.8987},
{0.1927,0.907},
{0.3976,0.6295},
{0.393,0.626},
{0.3891,0.6198},
{0.3866,0.6102},
{0.3885,0.6035},
{0.387,0.5941},
{0.3858,0.5866},
{0.4023,0.6311},
{0.4066,0.6203},
{0.4065,0.631},
{0.397,0.6377},
{0.4023,0.6396},
{0.0824,0.8921},
{0.085,0.9018},
{0.0804,0.899},
{0.0771,0.8892},
{0.0812,0.8808},
{0.0754,0.8779},
{0.0812,0.8685},
{0.0749,0.8658},
{0.082,0.8559},
{0.0753,0.8534},
{0.0831,0.8436},
{0.0762,0.8415},
{0.0712,0.8513},
{0.0719,0.8398},
{0.0773,0.8308},
{0.0729,0.8295},
{0.9451,0.3812},
{0.9527,0.3747},
{0.9395,0.39},
{0.3919,0.6331},
{0.0998,0.9074},
{0.1017,0.9141},
{0.0948,0.912},
{0.0915,0.9046},
{0.0994,0.8984},
{0.0898,0.8952},
{0.0895,0.8839},
{0.0902,0.8715},
{0.0915,0.8587},
{0.0929,0.8461},
{0.0942,0.8344},
{0.0843,0.8324},
{0.0857,0.8223},
{0.0787,0.8212},
{0.0878,0.8135},
{0.0807,0.8128},
{0.0906,0.806},
{0.0834,0.8057},
{0.0869,0.7999},
{0.0946,0.8},
{0.0898,0.7949},
{0.0982,0.795},
{0.0905,0.7907},
{0.0998,0.7909},
{0.109,0.7947},
{0.1119,0.7904},
{0.2289,0.8625},
{0.2224,0.8643},
{0.2223,0.8527},
{0.2292,0.8512},
{0.2218,0.8417},
{0.2119,0.8437},
{0.2127,0.8551},
{0.2133,0.8669},
{0.2278,0.874},
{0.2016,0.871},
{0.2026,0.8828},
{0.1895,0.8884},
{0.2003,0.8588},
{0.1871,0.8767},
{0.1991,0.847},
{0.1849,0.8643},
{0.102,0.875},
{0.1003,0.8874},
{0.1138,0.8913},
{0.1167,0.8789},
{0.104,0.8619},
{0.1059,0.8488},
{0.1072,0.8364},
{0.0956,0.8237},
{0.0975,0.8143},
{0.1005,0.8063},
{0.1047,0.7999},
{0.1113,0.902},
{0.1234,0.9056},
{0.1278,0.8952},
{0.1322,0.8827},
{0.1197,0.8654},
{0.1222,0.8517},
{0.1237,0.8385},
{0.1085,0.825},
{0.1103,0.8149},
{0.1131,0.8062},
{0.1173,0.7993},
{0.109,0.7947},
{0.1219,0.7936},
{0.1119,0.7904},
{0.1259,0.7888},
{0.2277,0.8229},
{0.2206,0.823},
{0.2191,0.8155},
{0.2263,0.8158},
{0.2168,0.8091},
{0.2093,0.8158},
{0.2107,0.824},
{0.2214,0.8318},
{0.2286,0.8312},
{0.229,0.8406},
{0.1985,0.836},
{0.1979,0.8259},
{0.2114,0.8333},
{0.1832,0.8518},
{0.1967,0.817},
{0.182,0.8291},
{0.1825,0.8401},
{0.2069,0.8089},
{0.1945,0.8093},
{0.1813,0.8192},
{0.9449,0.4602},
{0.9418,0.4498},
{0.948,0.4694},
{0.9511,0.4773},
{0.114,0.3159},
{0.1413,0.2987},
{0.1458,0.2848},
{0.1481,0.2726},
{0.1483,0.2628},
{0.1357,0.2572},
{0.1796,0.8105},
{0.1763,0.8031},
{0.1619,0.8034},
{0.3275,0.8757},
{0.3277,0.8629},
{0.3266,0.8521},
{0.3236,0.844},
{0.3367,0.8371},
{0.3188,0.838},
{0.3305,0.8306},
{0.3123,0.8334},
{0.3227,0.8256},
{0.3429,0.8224},
{0.3501,0.8295},
{0.3267,0.89},
{0.3259,0.905},
{0.1249,0.8262},
{0.142,0.8269},
{0.141,0.8403},
{0.1393,0.8544},
{0.1362,0.8688},
{0.1461,0.8858},
{0.1511,0.8715},
{0.1263,0.815},
{0.1286,0.8054},
{0.1322,0.7977},
{0.1219,0.7936},
{0.1366,0.7913},
{0.141,0.7857},
{0.143,0.8147},
{0.1446,0.804},
{0.1403,0.8984},
{0.134,0.9087},
{0.3259,0.9199},
{0.0,0.361},
{0.0043,0.3626},
{0.0006,0.367},
{0.0107,0.3592},
{0.0199,0.3558},
{0.1207,0.9196},
{0.1168,0.9166},
{0.1196,0.9131},
{0.1276,0.9159},
{0.1097,0.9102},
{0.11,0.9161},
{0.1129,0.9198},
{0.2086,0.7957},
{0.21,0.7996},
{0.1991,0.7984},
{0.1964,0.794},
{0.1979,0.7898},
{0.2109,0.792},
{0.2086,0.7957},
{0.1964,0.794},
{0.1825,0.7921},
{0.1864,0.7974},
{0.1991,0.7984},
{0.1907,0.8029},
{0.2031,0.8032},
{0.2133,0.8039},
{0.2182,0.7972},
{0.2186,0.8008},
{0.3974,0.7331},
{0.2182,0.7972},
{0.2215,0.7934},
{0.2244,0.7987},
{0.2292,0.795},
{0.2724,0.7911},
{0.2728,0.7954},
{0.2651,0.7954},
{0.2653,0.791},
{0.2722,0.7859},
{0.2655,0.7857},
{0.4158,0.7599},
{0.4122,0.7621},
{0.4124,0.7527},
{0.4163,0.7496},
{0.9575,0.4941},
{0.956,0.4895},
{0.4149,0.7315},
{0.4185,0.7322},
{0.4163,0.7727},
{0.4128,0.7742},
{0.5853,0.4333},
{0.1864,0.7974},
{0.1722,0.7965},
{0.1679,0.7901},
{0.1503,0.3027},
{0.1553,0.2886},
{0.158,0.2756},
{0.1585,0.2646},
{0.1568,0.2569},
{0.1468,0.2562},
{0.1643,0.2942},
{0.1674,0.2801},
{0.1681,0.2672},
{0.1659,0.2578},
{0.1511,0.788},
{0.1474,0.7953},
{0.6251,0.4545},
{0.6105,0.4427},
{0.5608,0.9171},
{0.7487,0.9879},
{0.8997,0.9819},
{0.7454,0.291},
{0.7501,0.2975},
{0.7206,0.8266},
{0.7521,0.8691},
{0.6865,0.0552},
{0.52,0.7859},
{0.391,0.9175},
{0.3962,0.8468},
{0.4041,0.8411},
{0.8132,0.3796},
{0.7921,0.3881},
{0.2295,0.4741},
{0.8182,0.0418},
{0.6676,0.8091},
{0.9441,0.9682},
{0.6339,0.7937},
{0.6164,0.7974},
{0.8094,0.0266},
{0.4065,0.5533},
{0.2242,0.8098},
{0.1807,0.7857}
};


// normal array: 95kb.
const tgx::fVec3 suzanne_norm_array[8177] PROGMEM = {
{0.7417716463207187,-0.11639555086510063,0.6604747538350426},
{0.711420314897142,-0.23070658792067844,0.6638189556209204},
{0.708503011144196,-0.23050097963124516,0.6670028347680717},
{0.7389130234568086,-0.11730206746715884,0.6635116944966741},
{0.727148073348246,-0.24191599359502233,0.6424424732759088},
{0.6733343779642729,-0.3548181157013575,0.6486331168091896},
{0.6556150891549174,-0.3394078115606756,0.6745155241534346},
{0.6576075428017741,-0.3419039216604723,0.6713076999434777},
{0.7576227555411992,-0.25310760220099987,0.6016180698700969},
{0.7897145545733624,-0.12640232961640246,0.6003110638348607},
{0.7999999000000186,-0.0004999999375000116,0.599999925000014},
{0.7517956057675264,-0.00029999824651537365,0.6593961458407913},
{0.7491282389212092,-0.0002000075394263007,0.6624249705799079},
{0.7586847164503292,-0.12379750612435843,0.6395871156473316},
{0.7618506342757869,-0.2628174674293473,0.5920393482426698},
{0.70500375062993,-0.3850020482163448,0.5956031686172857},
{0.6222997915296048,-0.5006998322655843,0.6016997984306014},
{0.5947208096452006,-0.4607161207391019,0.6588230526219239},
{0.5778981796236012,-0.44099861085656367,0.6866978369052206},
{0.5776030439760627,-0.44570234885756776,0.6839036041814911},
{0.6993146368085242,-0.37860792434678575,0.606312690257412},
{0.8210990228927442,-0.2848996609696051,0.49459941142705055},
{0.8539176848183808,-0.14040290777433032,0.5011103781033969},
{0.8630016008694544,-0.0005000009275025808,0.5052009371486076},
{0.7922926079444516,0.12309885149307331,0.5975944244700294},
{0.7440236119639945,0.1142036243095271,0.6583208921450235},
{0.7405964414426484,0.11579944358501036,0.6618968195934228},
{0.7596964522258521,0.12269942699501389,0.6385970177588906},
{0.7694330517066192,-0.00020000859155357923,0.6387274371263554},
{0.7956526659930008,-0.13490892991761663,0.5905390890760017},
{0.7953350392569988,-0.28381250363527755,0.5356235974173877},
{0.7347111199369509,-0.41580629327587343,0.5360081125441755},
{0.6467260150771953,-0.5415217831518497,0.5371216061511699},
{-0.6733343779642729,-0.3548181157013575,0.6486331168091896},
{-0.6556150891549174,-0.3394078115606756,0.6745155241534346},
{-0.708503011144196,-0.23050097963124516,0.6670028347680717},
{-0.727148073348246,-0.24191599359502233,0.6424424732759088},
{-0.7389130234568086,-0.11730206746715884,0.6635116944966741},
{-0.7417716463207187,-0.11639555086510063,0.6604747538350426},
{-0.711420314897142,-0.23070658792067844,0.6638189556209204},
{-0.6576075428017741,-0.3419039216604723,0.6713076999434777},
{-0.5778981796236012,-0.44099861085656367,0.6866978369052206},
{-0.5947208096452006,-0.4607161207391019,0.6588230526219239},
{-0.6222997915296048,-0.5006998322655843,0.6016997984306014},
{-0.70500375062993,-0.3850020482163448,0.5956031686172857},
{-0.7618506342757869,-0.2628174674293473,0.5920393482426698},
{-0.7347111199369509,-0.41580629327587343,0.5360081125441755},
{-0.7953350392569988,-0.28381250363527755,0.5356235974173877},
{-0.7576227555411992,-0.25310760220099987,0.6016180698700969},
{-0.6993146368085242,-0.37860792434678575,0.606312690257412},
{-0.5776030439760627,-0.44570234885756776,0.6839036041814911},
{-0.48192733087392275,-0.5244297412539637,0.701939808135311},
{-0.496521820130839,-0.5495241493693777,0.6719295285919653},
{-0.5180881592304297,-0.599686294326363,0.6098860612133546},
{-0.5353828011037673,-0.6502791101191258,0.53898268545934},
{-0.6467260150771953,-0.5415217831518497,0.5371216061511699},
{-0.6601592024310861,-0.5692510498769493,0.49004394666146367},
{-0.7525367510296267,-0.4368213326906857,0.49282406765103},
{-0.6659047612360643,-0.5860041899449372,0.4617033011904053},
{-0.7614524316123301,-0.44973096729191603,0.4668321448340369},
{-0.6730183399996509,-0.5841159173756256,0.45371236383037383},
{-0.7671301257915714,-0.44791759006914983,0.4592180338462907},
{-0.7517956057675264,-0.00029999824651537365,0.6593961458407913},
{-0.7491282389212092,-0.0002000075394263007,0.6624249705799079},
{-0.7999999000000186,-0.0004999999375000116,0.599999925000014},
{-0.7897145545733624,-0.12640232961640246,0.6003110638348607},
{-0.8630016008694544,-0.0005000009275025808,0.5052009371486076},
{-0.8539176848183808,-0.14040290777433032,0.5011103781033969},
{-0.8210990228927442,-0.2848996609696051,0.49459941142705055},
{-0.8575237237219797,-0.13610376536275384,0.49611372517606306},
{-0.8309992521010096,-0.28519974332034653,0.4775995701605803},
{-0.7554246121348015,-0.43021401660099506,0.4942161018229003},
{-0.7612915877744324,-0.435495187804762,0.48039469166798543},
{-0.7436342600195568,-0.23231070280062271,0.6269288832789943},
{-0.6802428430434247,-0.3590226119561739,0.6390402480222706},
{-0.7586847164503292,-0.12379750612435843,0.6395871156473316},
{-0.7956526659930008,-0.13490892991761663,0.5905390890760017},
{-0.7694330517066192,-0.00020000859155357923,0.6387274371263554},
{0.8317178738091643,-0.14580313334300368,0.5357115125641088},
{0.8163498886660912,-0.2980182124494612,0.4947302338884176},
{0.8547268858570486,-0.15300481284208312,0.4960156024161648},
{0.8275944716873936,-0.3065979519325216,0.4701968590954718},
{0.7614524316123301,-0.44973096729191603,0.4668321448340369},
{0.7525367510296267,-0.4368213326906857,0.49282406765103},
{0.6601592024310861,-0.5692510498769493,0.49004394666146367},
{0.8440935258274852,-0.00029999769902647265,0.5361958873933155},
{0.8676948545847684,-0.0003999976280210987,0.49709705222322037},
{0.8673596156751484,-0.15711079859629404,0.47223245765226},
{0.8324789468736469,-0.30479229190040547,0.4626882987608846},
{0.7671301257915714,-0.44791759006914983,0.4592180338462907},
{0.6730183399996509,-0.5841159173756256,0.45371236383037383},
{0.6659047612360643,-0.5860041899449372,0.4617033011904053},
{0.8071895187121488,-0.00019999740305058197,0.5902923351037928},
{0.8311370570718027,0.14390641621060332,0.537123948205108},
{0.8537315459634458,0.15040555758803123,0.49851842059596785},
{0.8662031140057923,0.15390055327348354,0.4754017090722162},
{0.8807309978729647,-0.0004000140787432564,0.47361666923201556},
{0.8717189426584382,-0.15570338347128465,0.46461009608708315},
{-0.8163498886660912,-0.2980182124494612,0.4947302338884176},
{-0.8275944716873936,-0.3065979519325216,0.4701968590954718},
{-0.8547268858570486,-0.15300481284208312,0.4960156024161648},
{-0.8317178738091643,-0.14580313334300368,0.5357115125641088},
{-0.8324789468736469,-0.30479229190040547,0.4626882987608846},
{-0.8673596156751484,-0.15711079859629404,0.47223245765226},
{-0.8676948545847684,-0.0003999976280210987,0.49709705222322037},
{-0.8440935258274852,-0.00029999769902647265,0.5361958873933155},
{-0.8071895187121488,-0.00019999740305058197,0.5902923351037928},
{-0.8717189426584382,-0.15570338347128465,0.46461009608708315},
{-0.8807309978729647,-0.0004000140787432564,0.47361666923201556},
{-0.884766315720638,0.00010000749584273065,0.4660349306271248},
{-0.8703887024279632,0.15359800631081702,0.46779392807422016},
{-0.8662031140057923,0.15390055327348354,0.4754017090722162},
{0.5353828011037673,-0.6502791101191258,0.53898268545934},
{0.408217753776176,-0.7343319367904115,0.5423235861656547},
{0.4099200312317512,-0.772537750979575,0.4849236963753992},
{0.5432986064408617,-0.6839982455467504,0.48679875136280415},
{0.4084190736161172,-0.7940370823976421,0.4502210258128696},
{0.2544132031157724,-0.856744461907556,0.4486232819093377},
{0.25899629637944244,-0.8345880654759948,0.48619304748913095},
{0.2640118055518338,-0.7936354882043003,0.5481245099354549},
{0.400126387204685,-0.6751445238737387,0.6197408701593184},
{0.5180881592304297,-0.599686294326363,0.6098860612133546},
{0.5454128337149677,-0.7037165586454397,0.45531071358713754},
{0.4163126102999519,-0.795824105877256,0.4397133191181572},
{0.26190905435251616,-0.860629752484824,0.4367150975018854},
{0.0884060745900848,-0.8941614399433803,0.43893015992746853},
{0.08130025325068331,-0.8882027667559277,0.45220140860958175},
{0.08859912996081566,-0.8661914940412926,0.49179517059513705},
{0.10059707166186525,-0.8244759998529614,0.5568837893488346},
{0.26731789619561125,-0.7281487475496616,0.6311422532325114},
{0.3876025097343758,-0.6152039834586893,0.6865044451306734},
{0.496521820130839,-0.5495241493693777,0.6719295285919653},
{0.5531203828616696,-0.7035259254080357,0.44621644337891336},
{-0.2544132031157724,-0.856744461907556,0.4486232819093377},
{-0.25899629637944244,-0.8345880654759948,0.48619304748913095},
{-0.4099200312317512,-0.772537750979575,0.4849236963753992},
{-0.4084190736161172,-0.7940370823976421,0.4502210258128696},
{-0.5432986064408617,-0.6839982455467504,0.48679875136280415},
{-0.408217753776176,-0.7343319367904115,0.5423235861656547},
{-0.2640118055518338,-0.7936354882043003,0.5481245099354549},
{-0.08859912996081566,-0.8661914940412926,0.49179517059513705},
{-0.08130025325068331,-0.8882027667559277,0.45220140860958175},
{-0.0884060745900848,-0.8941614399433803,0.43893015992746853},
{-0.26190905435251616,-0.860629752484824,0.4367150975018854},
{-0.4163126102999519,-0.795824105877256,0.4397133191181572},
{-0.5454128337149677,-0.7037165586454397,0.45531071358713754},
{-0.400126387204685,-0.6751445238737387,0.6197408701593184},
{-0.26731789619561125,-0.7281487475496616,0.6311422532325114},
{-0.10059707166186525,-0.8244759998529614,0.5568837893488346},
{0.08690426449689087,-0.8609422474726507,0.5012245956943809},
{0.09630099479441437,-0.8822091132672103,0.46090476117077445},
{0.09160261941435377,-0.8899254477820242,0.4468127767940312},
{-0.3876025097343758,-0.6152039834586893,0.6865044451306734},
{-0.2668996450237082,-0.660699121270753,0.7015990668738616},
{-0.11660247899505544,-0.7564160815768434,0.6436136833723642},
{0.06879965806654911,-0.8204959221454003,0.5674971795460264},
{0.25190630403413866,-0.8195205087573506,0.514712880851017},
{0.2630077456921676,-0.8399247361477247,0.47471398053259306},
{0.2607980844451046,-0.848593767101671,0.4602966191337487},
{-0.5531203828616696,-0.7035259254080357,0.44621644337891336},
{0.4798108294526324,-0.5301119647620685,0.6991157792212075},
{0.37571341508698275,-0.5899210635076155,0.7147255197302811},
{0.3778364743153835,-0.5843564106471111,0.7181693282315428},
{0.48192733087392275,-0.5244297412539637,0.701939808135311},
{0.2668996450237082,-0.660699121270753,0.7015990668738616},
{0.264717771100481,-0.6251419671889333,0.7342492918094943},
{0.2639148073556617,-0.6307353884017273,0.729740943264215},
{0.3897063581110993,-0.6668108791082397,0.6352103635416225},
{0.504134731037973,-0.5955410282347013,0.6254430882585763},
{0.6115204557013706,-0.4974166388648597,0.6153205828177486},
{0.13830254893946567,-0.6476119355979606,0.7493138099807781},
{0.13951006950266265,-0.6538471931243071,0.7436536751410748},
{0.26580325610983113,-0.716908782186373,0.6445078952700759},
{0.40589459149060225,-0.77598966000667,0.4827935668185829},
{0.5370193867497989,-0.6862247731614748,0.4906177116190899},
{0.6565508616825766,-0.5681440129807644,0.49613843485259146},
{0.13090000916300096,-0.6853000479710051,0.7164000501480053},
{-0.01200006984060971,-0.6844039832427739,0.7290042428170399},
{0.004400042548617168,-0.6479062652838781,0.7617073657458403},
{0.0061998582418619315,-0.6554850125065316,0.7551827329442146},
{0.12620057484492764,-0.745803397142211,0.654102979445857},
{0.2598021641610412,-0.8367069697980877,0.48210401594317925},
{0.4135889717970986,-0.8070784795392608,0.42138876381841717},
{0.5491288135447899,-0.7011367896125518,0.45482386523432966},
{0.6621979604334228,-0.5733982339361592,0.4823985142148643},
{0.11660247899505544,-0.7564160815768434,0.6436136833723642},
{-0.040500655913433825,-0.7540122113266444,0.6556106176999311},
{-0.1907940387333882,-0.7196775140273559,0.6675791418155659},
{-0.15110148306833454,-0.6554064328457078,0.7400072632069328},
{-0.12839956793618085,-0.6223979056345713,0.772097401896614},
{-0.12790484384815654,-0.6309238935402811,0.7652289797702062},
{-0.02439980956022957,-0.7476941642698217,0.6635948206626369},
{0.09580569294341706,-0.8684516049275928,0.48642890446428044},
{0.2548076392475387,-0.8706261017618021,0.4208126161513511},
{0.4128021383206148,-0.6966036084160374,0.5868030396476182},
{0.5233211583021539,-0.5840236125519929,0.6205250883364924},
{0.6010519932462209,-0.4674404353465618,0.6482560765760406},
{-0.264717771100481,-0.6251419671889333,0.7342492918094943},
{-0.3778364743153835,-0.5843564106471111,0.7181693282315428},
{-0.4798108294526324,-0.5301119647620685,0.6991157792212075},
{-0.37571341508698275,-0.5899210635076155,0.7147255197302811},
{-0.2639148073556617,-0.6307353884017273,0.729740943264215},
{-0.13830254893946567,-0.6476119355979606,0.7493138099807781},
{-0.13090000916300096,-0.6853000479710051,0.7164000501480053},
{0.040500655913433825,-0.7540122113266444,0.6556106176999311},
{0.22880044730531174,-0.781601528032481,0.5803011344898269},
{0.4060013235664723,-0.7432024228438476,0.5318017336764778},
{0.41901725129536105,-0.7625313940637537,0.4929202939462613},
{0.41911780869404514,-0.7715327831244472,0.4786203370101886},
{-0.3897063581110993,-0.6668108791082397,0.6352103635416225},
{-0.26580325610983113,-0.716908782186373,0.6445078952700759},
{-0.13941200667904505,-0.6538563125305572,0.7436640471057239},
{-0.004400042548617168,-0.6479062652838781,0.7617073657458403},
{0.01200006984060971,-0.6844039832427739,0.7290042428170399},
{0.1907940387333882,-0.7196775140273559,0.6675791418155659},
{0.3786174395209057,-0.7084326311585041,0.5956274352315147},
{0.5479423849827811,-0.6295486974751974,0.5508426093238106},
{0.563429935827757,-0.6473343937900374,0.513327273802605},
{0.5658096499658709,-0.6560111883662272,0.49950851919044276},
{-0.504134731037973,-0.5955410282347013,0.6254430882585763},
{-0.5370193867497989,-0.6862247731614748,0.4906177116190899},
{-0.40589459149060225,-0.77598966000667,0.4827935668185829},
{-0.2598021641610412,-0.8367069697980877,0.48210401594317925},
{-0.12620057484492764,-0.745803397142211,0.654102979445857},
{-0.0061998582418619315,-0.6554850125065316,0.7551827329442146},
{0.12839956793618085,-0.6223979056345713,0.772097401896614},
{0.15110148306833454,-0.6554064328457078,0.7400072632069328},
{0.3327146630583086,-0.652928775205199,0.6804299872103191},
{0.5162907739663031,-0.5988892979438678,0.6121890602792384},
{0.6635559865804813,-0.48754113558098666,0.5674478775972346},
{0.6275959677088612,-0.46219703039361953,0.6264959747762929},
{0.463815971777987,-0.5510189746650945,0.693723888793423},
{0.5692162285860188,-0.42351207450136846,0.7047200918562323},
{0.4095256575861968,-0.5026314908493835,0.7613476999276475},
{0.5099080413132178,-0.38470606686251196,0.7694121337250239},
{0.38111644362369784,-0.4787206548482397,0.7909341255890386},
{0.4805003988154965,-0.3655003033653777,0.7972006616768238},
{0.5768325227344735,-0.2586145811011353,0.7748436869186375},
{0.5461236312807993,-0.2448105931835555,0.801134665847003},
{0.4903273193476674,-0.3718207165683515,0.7882439182333907},
{0.5591419064605784,-0.24911867089846193,0.7907592656740821},
{-0.6115204557013706,-0.4974166388648597,0.6153205828177486},
{-0.6565508616825766,-0.5681440129807644,0.49613843485259146},
{-0.6621979604334228,-0.5733982339361592,0.4823985142148643},
{-0.5491288135447899,-0.7011367896125518,0.45482386523432966},
{-0.4135889717970986,-0.8070784795392608,0.42138876381841717},
{-0.2548076392475387,-0.8706261017618021,0.4208126161513511},
{-0.09580569294341706,-0.8684516049275928,0.48642890446428044},
{0.02439980956022957,-0.7476941642698217,0.6635948206626369},
{0.12790484384815654,-0.6309238935402811,0.7652289797702062},
{0.25831641782166853,-0.5674360645451597,0.7818496920363163},
{0.28479605844982636,-0.5959917515312377,0.7507896091437136},
{-0.17509589755118002,-0.7178831801941298,0.6737842134208172},
{-0.07930086160854209,-0.8677094277141485,0.49070533154239104},
{0.08450263567831086,-0.8984280224070352,0.43091344039981244},
{0.26811198755495136,-0.7536336957158201,0.6001268322705196},
{0.37373194610344806,-0.4606393748334177,0.8050688161982225},
{0.4450981817776411,-0.3753984665003965,0.8129966789153498},
{0.48620809786330543,-0.2984049699761627,0.8213136790932388},
{-0.25831641782166853,-0.5674360645451597,0.7818496920363163},
{-0.260511521376805,-0.5761254797127728,0.7747342633804638},
{-0.32232259882963366,-0.6540458567625828,0.6843479813190144},
{-0.2517132933300404,-0.8290437829582976,0.49932637012192765},
{-0.09650055487978584,-0.9005051779196596,0.42400243802102794},
{0.12290114913111659,-0.7733072304564074,0.6220058157815666},
{0.2695002358128095,-0.4964004343505701,0.8252007220509477},
{0.3268033513855528,-0.27660283657663376,0.9037092675860589},
{0.37660336308304854,-0.2263020208860698,0.8983080219264539},
{0.3999146251452672,-0.18380672193473396,0.8979328380043398},
{0.43189191074026706,-0.14869721492724639,0.88958333826011},
{0.5361002198011352,-0.23460009618605918,0.8109003324692045},
{-0.38111644362369784,-0.4787206548482397,0.7909341255890386},
{-0.38700952055130977,-0.48661197080172436,0.7832192674309711},
{-0.46210409888153564,-0.5531049060622752,0.6932061487658094},
{-0.4146305324434261,-0.7494551881647455,0.5161380072215441},
{-0.2805063254889605,-0.8613194229719845,0.4236095525031146},
{-0.03380007199423002,-0.7899016824923756,0.6123013042031669},
{0.17400242474068325,-0.504307027567394,0.8458117864693673},
{0.25760603706821883,-0.2956069276295244,0.9199215586143421},
{0.3026114374154198,-0.19980755186913707,0.9319352231574015},
{0.32731611416896056,-0.1536075622864416,0.9323459005185516},
{0.3473915775933006,-0.11869712222315712,0.9301774481211521},
{0.3765980944184633,-0.09399952436361007,0.921595336739394},
{0.410702764038903,-0.07220048591090526,0.9089061169587507},
{0.46288974941999733,-0.09619786972176224,0.8811804864741881},
{0.4693174636277384,-0.037501395452887686,0.8822328284943337},
{0.3986980503713005,-0.03279983960917647,0.9164955183478728},
{0.3462168265466652,-0.04560221632157115,0.9370455415200037},
{0.3916974657255951,-0.00019999870601255815,0.9200940470107738},
{0.3327991680031199,-0.00039999900000375,0.9429976425088404},
{0.34639729637965255,0.04319966282794743,0.9370926860201283},
{0.398597815689955,0.03119982902540541,0.9165949770732884},
{-0.28479605844982636,-0.5959917515312377,0.7507896091437136},
{-0.4095256575861968,-0.5026314908493835,0.7613476999276475},
{-0.5099080413132178,-0.38470606686251196,0.7694121337250239},
{-0.4805003988154965,-0.3655003033653777,0.7972006616768238},
{-0.4903273193476674,-0.3718207165683515,0.7882439182333907},
{-0.5777043616843961,-0.42560321331639084,0.6965052586345541},
{-0.5644155047068744,-0.6331173919736396,0.5297145514585956},
{-0.4460047232150284,-0.7689081427803484,0.45810485135606394},
{-0.20980246204633823,-0.7657089856476702,0.6080071350055941},
{0.07000421543075207,-0.5254316398188161,0.8479510609104953},
{0.1986060565840447,-0.29720906352859056,0.9339284805832796},
{0.2571055663957693,-0.18900409198288762,0.9477205183713364},
{0.27181073537699474,-0.11760464488717653,0.9551377239093733},
{0.3016921877819448,-0.07209813304301696,0.9506753825796981},
{-0.3327146630583086,-0.652928775205199,0.6804299872103191},
{-0.463815971777987,-0.5510189746650945,0.693723888793423},
{-0.5692162285860188,-0.42351207450136846,0.7047200918562323},
{-0.6403435672566979,-0.2860194599959638,0.7128485002976328},
{-0.5768325227344735,-0.2586145811011353,0.7748436869186375},
{-0.5461236312807993,-0.2448105931835555,0.801134665847003},
{-0.5592106418797735,-0.24910474050831824,0.7907150474505309},
{-0.6573051335731399,-0.2878022477443324,0.6965054397287266},
{-0.6920261279396999,-0.4935186331477484,0.5268198904604536},
{-0.5876235612390412,-0.6462259109473595,0.4869195234296957},
{-0.3585125660856658,-0.6662233515377143,0.6539229204000471},
{-0.062500171875709,-0.5165014203808591,0.8540023485096877},
{0.1336043368671632,-0.30961005010534226,0.941430559331942},
{0.14799869391728926,-0.19189830650491763,0.9701914380983381},
{0.20630751591970994,-0.1824066451951289,0.9613350220727928},
{0.2037983451641559,-0.10659913441854278,0.9731920977122498},
{0.1945002898056477,-0.0014000020860046622,0.9809014615442665},
{0.17509589755118002,-0.7178831801941298,0.6737842134208172},
{0.260511521376805,-0.5761254797127728,0.7747342633804638},
{0.32232259882963366,-0.6540458567625828,0.6843479813190144},
{0.38700952055130977,-0.48661197080172436,0.7832192674309711},
{-0.06879965806654911,-0.8204959221454003,0.5674971795460264},
{-0.22880044730531174,-0.781601528032481,0.5803011344898269},
{-0.25190630403413866,-0.8195205087573506,0.514712880851017},
{-0.08690426449689087,-0.8609422474726507,0.5012245956943809},
{-0.2630077456921676,-0.8399247361477247,0.47471398053259306},
{-0.41901725129536105,-0.7625313940637537,0.4929202939462613},
{-0.4060013235664723,-0.7432024228438476,0.5318017336764778},
{-0.3786174395209057,-0.7084326311585041,0.5956274352315147},
{-0.09630099479441437,-0.8822091132672103,0.46090476117077445},
{-0.2607980844451046,-0.848593767101671,0.4602966191337487},
{-0.41911780869404514,-0.7715327831244472,0.4786203370101886},
{-0.5658096499658709,-0.6560111883662272,0.49950851919044276},
{-0.563429935827757,-0.6473343937900374,0.513327273802605},
{-0.5479423849827811,-0.6295486974751974,0.5508426093238106},
{-0.5162907739663031,-0.5988892979438678,0.6121890602792384},
{-0.09160261941435377,-0.8899254477820242,0.4468127767940312},
{-0.6275959677088612,-0.46219703039361953,0.6264959747762929},
{-0.7038886463677003,-0.31389493691550097,0.6371897222126703},
{-0.7438201801152335,-0.33230901566589416,0.5799157333272706},
{-0.6635559865804813,-0.48754113558098666,0.5674478775972346},
{-0.7647040032359355,-0.343801799807133,0.545002853097404},
{-0.6819429432992519,-0.5026316517116939,0.5313334591214145},
{-0.7712140593604544,-0.34910636426703145,0.5323097040943593},
{-0.6867060052702743,-0.5099044591339928,0.5181045308439335},
{-0.7477793914839521,-0.16079556853519592,0.6441822465819229},
{-0.7906978097701004,-0.1707995268859658,0.5878983715237663},
{-0.680508047055235,-0.1457017229330606,0.7181084916831215},
{-0.6139968409943797,-0.13019933012616977,0.7784959946484113},
{-0.582802506056164,-0.12200052460338369,0.8034034546422825},
{-0.5977194471185732,-0.12420404104421413,0.7920257689775974},
{-0.7038311065031431,-0.14490640428005885,0.695430735240531},
{-0.7860255934099889,-0.33921104489143544,0.5168168278298757},
{-0.762311671081027,-0.0005000076551758015,0.6472099088595575},
{-0.8063507976685491,-0.000600037800571908,0.5914372587637107},
{-0.6938338113454604,-0.00030001462006866257,0.7201350930381465},
{-0.6260112432628944,-0.00020000359209677138,0.7798140055853116},
{-0.5947228050831997,-0.00010000383472056495,0.8039308273186215},
{-0.6104451135608998,-0.0002000147816385648,0.7920585352887167},
{-0.7195942864440483,-0.0005999952360567384,0.6943944865296653},
{-0.6010393573457207,0.12200798934472201,0.7898517211841102},
{-0.7079079179943444,0.14090157599294126,0.6921077412683794},
{-0.813964346424978,-0.17621393026180257,0.5535437593638349},
{-0.8303075267718454,-0.0007000063455862842,0.5573050519931946},
{-0.7891604756844663,0.16771285232832972,0.5908452782085701},
{-0.7468843043912632,0.15809667763322893,0.6458864268393585},
{-0.6805192385508145,0.14360405974415427,0.7185203128563707},
{-0.8215506049680675,-0.17801096492308704,0.5416333629345166},
{-0.83778959471785,0.0,0.5459932188063333},
{-0.8121857503260147,0.1728969665493326,0.5571902241832742},
{-0.740334400437143,0.3263151625863025,0.5877273093839105},
{-0.7611959314186197,0.33549820676687725,0.5549970335487835},
{-0.8190945489439151,0.1762988267352121,0.5458963670717657},
{-0.7666305853373152,0.3412136129886407,0.5439217001891022},
{0.7906978097701004,-0.1707995268859658,0.5878983715237663},
{0.7438201801152335,-0.33230901566589416,0.5799157333272706},
{0.7647040032359355,-0.343801799807133,0.545002853097404},
{0.813964346424978,-0.17621393026180257,0.5535437593638349},
{0.8215506049680675,-0.17801096492308704,0.5416333629345166},
{0.7712140593604544,-0.34910636426703145,0.5323097040943593},
{0.6819429432992519,-0.5026316517116939,0.5313334591214145},
{0.7038886463677003,-0.31389493691550097,0.6371897222126703},
{0.7477793914839521,-0.16079556853519592,0.6441822465819229},
{0.762311671081027,-0.0005000076551758015,0.6472099088595575},
{0.8063507976685491,-0.000600037800571908,0.5914372587637107},
{0.8303075267718454,-0.0007000063455862842,0.5573050519931946},
{0.83778959471785,0.0,0.5459932188063333},
{0.8121857503260147,0.1728969665493326,0.5571902241832742},
{0.8190945489439151,0.1762988267352121,0.5458963670717657},
{0.7611959314186197,0.33549820676687725,0.5549970335487835},
{0.7666305853373152,0.3412136129886407,0.5439217001891022},
{0.6769207784021943,0.4880149798497132,0.5510169137237542},
{0.679985523262313,0.49568944688401245,0.5402884973803348},
{0.55550067215622,0.6287007607283808,0.5442006584831952},
{0.5557115311339078,0.6376132306118042,0.5335110704695696},
{0.680508047055235,-0.1457017229330606,0.7181084916831215},
{0.6403435672566979,-0.2860194599959638,0.7128485002976328},
{0.6938338113454604,-0.00030001462006866257,0.7201350930381465},
{0.7468843043912632,0.15809667763322893,0.6458864268393585},
{0.7891604756844663,0.16771285232832972,0.5908452782085701},
{0.740334400437143,0.3263151625863025,0.5877273093839105},
{0.6589523558445904,0.47583780681568694,0.5825462851411047},
{0.5409365955985802,0.6142415548468255,0.574538868869263},
{0.6139968409943797,-0.13019933012616977,0.7784959946484113},
{0.6260112432628944,-0.00020000359209677138,0.7798140055853116},
{0.6805192385508145,0.14360405974415427,0.7185203128563707},
{0.6412288014384394,0.282812702817827,0.713332040028133},
{0.7019099461344056,0.30970438854227866,0.6414090888311835},
{0.6255023081077754,0.4539016749002706,0.6346023416869613},
{0.5129222330960508,0.5883255015215572,0.6251270967212738},
{0.6867060052702743,-0.5099044591339928,0.5181045308439335},
{0.582802506056164,-0.12200052460338369,0.8034034546422825},
{0.5947228050831997,-0.00010000383472056495,0.8039308273186215},
{0.6152058537115472,0.129201229355546,0.7777073999211155},
{0.5808200473499073,0.2557088259424437,0.7728266745730173},
{0.5187476906674053,0.38233514968604015,0.7646702993720803},
{0.572133067386222,0.41902421820455693,0.7050407490076673},
{0.4674914496595779,0.547189991986569,0.6942873016013795},
{0.5977194471185732,-0.12420404104421413,0.7920257689775974},
{0.6104451135608998,-0.0002000147816385648,0.7920585352887167},
{0.5850922124744776,0.12099838952215312,0.8018893269240875},
{0.5535066808659573,0.24200292099288467,0.7969096187571479},
{0.4953178986356567,0.3630131177160173,0.789228519287826},
{0.569487909900008,0.24389482216788752,0.7849833349806957},
{0.5098974046288157,0.3678981274032973,0.777596042046219},
{0.6006003423422926,0.4165002374052029,0.6825003890253326},
{0.49269480209725663,0.5540941543375074,0.6709929210620239},
{0.4123149075149767,0.49221779645615216,0.7666277179262215},
{0.6573051335731399,-0.2878022477443324,0.6965054397287266},
{0.7038311065031431,-0.14490640428005885,0.695430735240531},
{0.7195942864440483,-0.0005999952360567384,0.6943944865296653},
{0.6010393573457207,0.12200798934472201,0.7898517211841102},
{0.7079079179943444,0.14090157599294126,0.6921077412683794},
{0.6694762574455371,0.27819013416183486,0.6887755730074473},
{0.7140304683301393,0.4765203335564585,0.5129218868438774},
{0.5932120719884987,0.6241127008226939,0.5085103482908826},
{0.46210409888153564,-0.5531049060622752,0.6932061487658094},
{0.5777043616843961,-0.42560321331639084,0.6965052586345541},
{0.5644155047068744,-0.6331173919736396,0.5297145514585956},
{0.6920261279396999,-0.4935186331477484,0.5268198904604536},
{0.7860255934099889,-0.33921104489143544,0.5168168278298757},
{0.8408988101290255,-0.17209975647901687,0.5130992739650411},
{0.8581362913511581,-0.0005000211463414276,0.5134217130633779},
{-0.569487909900008,0.24389482216788752,0.7849833349806957},
{-0.5535066808659573,0.24200292099288467,0.7969096187571479},
{-0.5850922124744776,0.12099838952215312,0.8018893269240875},
{-0.5808200473499073,0.2557088259424437,0.7728266745730173},
{-0.5187476906674053,0.38233514968604015,0.7646702993720803},
{-0.4953178986356567,0.3630131177160173,0.789228519287826},
{-0.5098974046288157,0.3678981274032973,0.777596042046219},
{-0.6006003423422926,0.4165002374052029,0.6825003890253326},
{-0.6694762574455371,0.27819013416183486,0.6887755730074473},
{-0.6152058537115472,0.129201229355546,0.7777073999211155},
{-0.4123149075149767,0.49221779645615216,0.7666277179262215},
{-0.3999187746275727,0.48432273706459983,0.778136530476905},
{-0.49269480209725663,0.5540941543375074,0.6709929210620239},
{-0.5932120719884987,0.6241127008226939,0.5085103482908826},
{-0.7140304683301393,0.4765203335564585,0.5129218868438774},
{-0.7969162373337552,0.3250066220773879,0.5092103752670951},
{-0.6412288014384394,0.282812702817827,0.713332040028133},
{-0.572133067386222,0.41902421820455693,0.7050407490076673},
{-0.42140745687092457,0.505208939751284,0.7531133264582185},
{-0.7019099461344056,0.30970438854227866,0.6414090888311835},
{-0.6255023081077754,0.4539016749002706,0.6346023416869613},
{-0.4674914496595779,0.547189991986569,0.6942873016013795},
{-0.29649923651544896,0.6040984444485084,0.7396980952798571},
{-0.27710434225906505,0.5820091201543698,0.7645119799965905},
{-0.28570055568812125,0.5939011551388701,0.7521014628387679},
{-0.35242498605511097,0.6691474408895425,0.6542463844416958},
{-0.44191111641395187,0.7532189474609381,0.4872122559784507},
{-0.46291479267855384,0.7608243125293666,0.4548145338306465},
{-0.6076423875731694,0.6287438595576885,0.4852338486677119},
{-0.7337982498932611,0.49169882729969544,0.468798881916},
{-0.4761115291802704,0.5256127278663097,0.7050170721951073},
{-0.5954965759045328,0.42489755684607217,0.6817960796838126},
{-0.830560010128676,0.34112464714616664,0.4402318078972223},
{-0.7018222165339021,0.29930947479138914,0.6464204627636283},
{-0.3207080771346352,0.2685067624279687,0.9083228763997169},
{-0.40379625884499265,0.1871982656161036,0.8954917033078031},
{-0.7378155311803987,0.13910292814745656,0.6605139039640191},
{-0.41909830265531134,0.07549969422685757,0.9047963355822614},
{0.3999187746275727,0.48432273706459983,0.778136530476905},
{0.42140745687092457,0.505208939751284,0.7531133264582185},
{0.27710434225906505,0.5820091201543698,0.7645119799965905},
{0.29649923651544896,0.6040984444485084,0.7396980952798571},
{0.3355221535815595,0.6507429667228637,0.6811449740816697},
{0.3734078640524263,0.696614670859454,0.6126129017635682},
{0.39627716320510775,0.725358198811469,0.5628675628770001},
{0.4075985061542125,0.7413972827839379,0.5330980461992412},
{0.405587197842147,0.7500763242144833,0.5223835112246982},
{0.24981008128924972,0.8162329397449385,0.5209210221920344},
{0.2457026818594088,0.824208996290292,0.5102055689241773},
{0.08390660958396565,0.8561674429658283,0.509840161691367},
{0.07799968449191434,0.8627965099951755,0.49949797953475916},
{-0.09009893188349374,0.8606897965829419,0.5010940595651355},
{-0.09730210661341253,0.8654187365184707,0.49151064132057815},
{-0.25861262965616144,0.8294405067162424,0.4951241799797584},
{-0.2655046503546768,0.8324145798690508,0.4864085195198298},
{-0.40959535931086843,0.768291295308936,0.49189442686771523},
{-0.41622925986426945,0.7696541047370056,0.4841340333981086},
{-0.5447930784479073,0.6805913531417872,0.4898937759391149},
{-0.551296904476572,0.6804961790246821,0.4826972896623278},
{-0.6647056267569458,0.5663047937903692,0.48730412504687787},
{-0.6708269375965296,0.5652226969731046,0.4801192795767649},
{-0.760105373963991,0.4349030747756081,0.4828034134321995},
{-0.7652048628923556,0.4340027580962916,0.47550302183130566},
{0.28570055568812125,0.5939011551388701,0.7521014628387679},
{0.14790433513959536,0.6579192838968208,0.7384216434555592},
{0.14350191935100706,0.6438086109977585,0.7516100528516858},
{0.16040520844167852,0.6677216812749922,0.7269236035926192},
{0.192095492532151,0.7185831386444753,0.6683843165460163},
{0.22259743791823425,0.7684911547177135,0.5998930952702098},
{0.24091765268314183,0.7993585711483406,0.550440332240769},
{0.07679798139158833,0.8386779556396502,0.5391858276867765},
{-0.09559840877772874,0.8427859719442445,0.5296911833636287},
{-0.262017150893936,0.8115531219482026,0.522234183957303},
{-0.4102278287486768,0.7510509492692742,0.5173350946165053},
{-0.5422106979226061,0.6649131188652542,0.5137101356009641},
{-0.6586352840372741,0.5533296426629575,0.5099273175381204},
{-0.751023263305877,0.42511316808432525,0.5052156492971092},
{-0.6589523558445904,0.47583780681568694,0.5825462851411047},
{-0.5129222330960508,0.5883255015215572,0.6251270967212738},
{-0.5409365955985802,0.6142415548468255,0.574538868869263},
{-0.3355221535815595,0.6507429667228637,0.6811449740816697},
{-0.16040520844167852,0.6677216812749922,0.7269236035926192},
{-0.14350191935100706,0.6438086109977585,0.7516100528516858},
{-0.14790433513959536,0.6579192838968208,0.7384216434555592},
{-0.1988047067571494,0.743917612457965,0.6380151051864251},
{-0.272513848143049,0.8426428199828737,0.4644236002848879},
{-0.2905125140960728,0.8606370727403796,0.4182180151290109},
{-0.20670848969201105,0.7476307058236452,0.6311259208738663},
{-0.36081414058325967,0.645325290793729,0.6733263881782392},
{-0.1642965415941988,0.4079914118711692,0.8980810955919046},
{-0.23660711015049166,0.3253097757056421,0.9155275120151103},
{-0.07040415502381672,0.1810106826606651,0.9809578929383781},
{-0.12290621060773697,0.14780746890011004,0.9813495888476184},
{-0.17060999291993656,0.09490555878137151,0.9807574446458487},
{-0.6769207784021943,0.4880149798497132,0.5510169137237542},
{-0.55550067215622,0.6287007607283808,0.5442006584831952},
{-0.39627716320510775,0.725358198811469,0.5628675628770001},
{-0.3734078640524263,0.696614670859454,0.6126129017635682},
{-0.192095492532151,0.7185831386444753,0.6683843165460163},
{-0.01789994075129417,0.6988976866524856,0.7149976333617503},
{-0.0052000930824992716,0.6730120470234635,0.7396132391954734},
{-0.006400211402473994,0.6873227026438087,0.7263239908776346},
{-0.039700451595205355,0.7796088681013122,0.625007109496306},
{-0.0923014265295706,0.8866137027206642,0.4532070043683792},
{-0.10000436428568822,0.9026393920426219,0.4186182688998909},
{-0.027300126536379747,0.771203574536852,0.6360029478804952},
{0.07780290443663493,0.4965185353828952,0.8645322735921711},
{-0.05410079150036952,0.48880715130093566,0.8707127386205497},
{0.05070269897650169,0.28071494285412274,0.9584510197057046},
{-0.024201426232073022,0.22971353741765177,0.972957338065448},
{0.05650203100200721,0.14690528060521874,0.9875354976014534},
{0.019799509671214414,0.10499739977159157,0.9942753770751762},
{-0.02940057905010664,0.07800153625538497,0.9965196266473222},
{-0.679985523262313,0.49568944688401245,0.5402884973803348},
{-0.5557115311339078,0.6376132306118042,0.5335110704695696},
{-0.4075985061542125,0.7413972827839379,0.5330980461992412},
{-0.24091765268314183,0.7993585711483406,0.550440332240769},
{-0.22259743791823425,0.7684911547177135,0.5998930952702098},
{-0.04070044078816062,0.753308158371533,0.6564071089274848},
{0.12840049241683263,0.7001026848989449,0.7024026937194957},
{0.13420789903835373,0.6732396246842005,0.7271427972487852},
{0.13389987078668703,0.686599337431959,0.7145993104119981},
{0.11860186562201946,0.7793122586782443,0.6153096788973741},
{0.08820145136682346,0.8892146321471589,0.448907386831826},
{0.08310738649722699,0.9008800692743933,0.42603786579805897},
{0.12749998852500155,0.7532999322030092,0.6451999419320079},
{0.17770400727054642,0.4756107251427793,0.8615194274821371},
{0.20001385643987393,0.279219343590064,0.939165062913428},
{0.13749879757827277,0.2909974552383809,0.9467917203426083},
{0.089302572844186,0.19500561819279139,0.9767281399430735},
{0.1498011205165722,0.18100135389519073,0.9720072706415768},
{0.13020242374067711,0.10680198813751395,0.9857183493178604},
{0.2067062694962322,0.17220522306362449,0.9631292121520136},
{0.20390934537945302,0.10120463831486338,0.9737446277389573},
{0.27160462682422726,0.1116019011545794,0.9559162841726024},
{0.25631769293940376,0.1785123222383284,0.9499655736369086},
{0.3244122549043979,0.1450054776853813,0.934735310293282},
{0.3013089881811782,0.18840562022347818,0.9347278833486466},
{0.375107046452052,0.21410402198182976,0.9019169426689035},
{0.3249148343253994,0.260211880244595,0.9092415123688924},
{0.37219927049014473,0.43519914701050777,0.819798393196724},
{0.4440071352519957,0.3531056744537831,0.8235132339640056},
{0.41650002082500154,0.6778000338900025,0.6059000302950023},
{0.5288244930736082,0.5633260910521246,0.6348294028047021},
{0.4204062199560367,0.8068119368709097,0.4151061415407965},
{0.5619487624097632,0.6941602348969864,0.44983903422657323},
{0.41342570347500235,0.7919492370146454,0.44932793558616},
{0.5531174953830729,0.6927219111405795,0.46281463905855375},
{0.39930850935500245,0.6925147576467299,0.600812803457264},
{0.5214244240920501,0.6106286025136284,0.5960279186015762},
{0.38470743646662103,0.6151118902277583,0.6882133032917302},
{0.49464195483667467,0.5461463233649576,0.6760573422353257},
{0.3847009021246732,0.6041014166194829,0.6979016365812567},
{0.4929226281326286,0.5373246664549834,0.6843314149546719},
{0.3917968793502839,0.626495009987118,0.6737946332471192},
{0.5033190912552038,0.5565211092460182,0.6610250731565464},
{0.40161693252682057,0.6736284007720774,0.6204261577182257},
{0.5205214953789866,0.5970246546421807,0.6104252080294592},
{0.408311959632449,0.7207211102304825,0.560216408978932},
{0.5349087672265429,0.638010457077088,0.553909078644199},
{0.4102278287486768,0.7510509492692742,0.5173350946165053},
{0.5422106979226061,0.6649131188652542,0.5137101356009641},
{0.40959535931086843,0.768291295308936,0.49189442686771523},
{0.5447930784479073,0.6805913531417872,0.4898937759391149},
{0.41622925986426945,0.7696541047370056,0.4841340333981086},
{0.551296904476572,0.6804961790246821,0.4826972896623278},
{-0.06290470198768167,0.806160258700639,0.5883439774141992},
{-0.07679798139158833,0.8386779556396502,0.5391858276867765},
{0.11690133151374896,0.7556086064310411,0.6445073409804208},
{0.2677060421935592,0.6746152262374862,0.6879155264286492},
{0.266090871909206,0.6491777303399344,0.7125755555148449},
{0.2656059390151953,0.6614147894000383,0.7014156838300376},
{0.26620582464716563,0.7486163799055905,0.6072132859720472},
{0.2583015769359408,0.857105232643418,0.4457027210234178},
{0.2557113666228752,0.8731388118828014,0.4150184479800281},
{0.2705111195881107,0.7345301934841675,0.6223255812187848},
{0.2691035064415335,0.4688061085833925,0.8413109623532596},
{0.2564141211144854,0.27791530521729907,0.925750982510449},
{0.10450272807932523,0.8095211328250123,0.5777150814490544},
{0.09559840877772874,0.8427859719442445,0.5296911833636287},
{0.2679150224164722,0.7272407775336265,0.631935433613172},
{-0.24981008128924972,0.8162329397449385,0.5209210221920344},
{-0.08390660958396565,0.8561674429658283,0.509840161691367},
{0.09009893188349374,0.8606897965829419,0.5010940595651355},
{0.262017150893936,0.8115531219482026,0.522234183957303},
{0.26559888979896096,0.7789967438004164,0.5679976257748863},
{-0.2457026818594088,0.824208996290292,0.5102055689241773},
{-0.07799968449191434,0.8627965099951755,0.49949797953475916},
{0.09730210661341253,0.8654187365184707,0.49151064132057815},
{0.25861262965616144,0.8294405067162424,0.4951241799797584},
{-0.405587197842147,0.7500763242144833,0.5223835112246982},
{0.06290470198768167,0.806160258700639,0.5883439774141992},
{-0.10450272807932523,0.8095211328250123,0.5777150814490544},
{-0.26559888979896096,0.7789967438004164,0.5679976257748863},
{-0.408311959632449,0.7207211102304825,0.560216408978932},
{-0.5349087672265429,0.638010457077088,0.553909078644199},
{-0.646307894699151,0.5308064838408004,0.5482066963856947},
{-0.7341866379247836,0.40759258188251407,0.5429901176697869},
{-0.7946353580869047,0.2789124104838129,0.5392239933053851},
{-0.814817856929004,0.29130638404936043,0.501210984159078},
{0.04070044078816062,0.753308158371533,0.6564071089274848},
{-0.11690133151374896,0.7556086064310411,0.6445073409804208},
{-0.2679150224164722,0.7272407775336265,0.631935433613172},
{-0.40161693252682057,0.6736284007720774,0.6204261577182257},
{-0.5205214953789866,0.5970246546421807,0.6104252080294592},
{-0.6251356399987834,0.4966283135872594,0.602134328656643},
{-0.7071968529810063,0.3804983067863022,0.5958973482627002},
{-0.7627548364163558,0.25971867184650266,0.5922425778494373},
{0.0052000930824992716,0.6730120470234635,0.7396132391954734},
{0.01789994075129417,0.6988976866524856,0.7149976333617503},
{-0.12840049241683263,0.7001026848989449,0.7024026937194957},
{-0.2677060421935592,0.6746152262374862,0.6879155264286492},
{-0.3917968793502839,0.626495009987118,0.6737946332471192},
{-0.5033190912552038,0.5565211092460182,0.6610250731565464},
{-0.6023258102139634,0.4626198236841764,0.6505278757167244},
{-0.679312570795435,0.35310653429687633,0.6433119045969429},
{-0.7302670817638346,0.2396220114908447,0.6397587677407903},
{-0.13420789903835373,0.6732396246842005,0.7271427972487852},
{-0.266090871909206,0.6491777303399344,0.7125755555148449},
{-0.3847009021246732,0.6041014166194829,0.6979016365812567},
{-0.4929226281326286,0.5373246664549834,0.6843314149546719},
{-0.5902383962565553,0.44552898260300816,0.6731437894277998},
{-0.6651917915839375,0.33799582915720217,0.6657917841800745},
{-0.7135914191147773,0.227797260754409,0.6624920335811939},
{-0.7405964414426484,0.11579944358501036,0.6618968195934228},
{-0.7596964522258521,0.12269942699501389,0.6385970177588906},
{0.006400211402473994,0.6873227026438087,0.7263239908776346},
{-0.13389987078668703,0.686599337431959,0.7145993104119981},
{-0.2656059390151953,0.6614147894000383,0.7014156838300376},
{-0.38470743646662103,0.6151118902277583,0.6882133032917302},
{-0.49464195483667467,0.5461463233649576,0.6760573422353257},
{-0.5944017950961318,0.4504013602141617,0.666202011933114},
{-0.6705926067572655,0.33869626589425267,0.6599927236203329},
{-0.7183166148554546,0.22620523218753144,0.6579152177549821},
{-0.7440236119639945,0.1142036243095271,0.6583208921450235},
{0.039700451595205355,0.7796088681013122,0.625007109496306},
{0.1988047067571494,0.743917612457965,0.6380151051864251},
{-0.11860186562201946,0.7793122586782443,0.6153096788973741},
{-0.26620582464716563,0.7486163799055905,0.6072132859720472},
{-0.39930850935500245,0.6925147576467299,0.600812803457264},
{-0.5214244240920501,0.6106286025136284,0.5960279186015762},
{-0.6319165532709222,0.4990130718186267,0.593015534245382},
{-0.7153172715440348,0.3711089605340295,0.5921142967722954},
{-0.7658335519028794,0.24551075606183972,0.5943260379940992},
{0.35242498605511097,0.6691474408895425,0.6542463844416958},
{0.272513848143049,0.8426428199828737,0.4644236002848879},
{0.0923014265295706,0.8866137027206642,0.4532070043683792},
{-0.08820145136682346,0.8892146321471589,0.448907386831826},
{-0.2583015769359408,0.857105232643418,0.4457027210234178},
{-0.41342570347500235,0.7919492370146454,0.44932793558616},
{-0.5531174953830729,0.6927219111405795,0.46281463905855375},
{-0.6767069193636258,0.5621057475606533,0.47550486206207193},
{-0.77140485215178,0.4165026198097179,0.48110302614755174},
{-0.8289493198069665,0.2736162792848185,0.4878290242512225},
{0.44191111641395187,0.7532189474609381,0.4872122559784507},
{0.2905125140960728,0.8606370727403796,0.4182180151290109},
{0.10000436428568822,0.9026393920426219,0.4186182688998909},
{-0.08310738649722699,0.9008800692743933,0.42603786579805897},
{-0.2557113666228752,0.8731388118828014,0.4150184479800281},
{-0.4204062199560367,0.8068119368709097,0.4151061415407965},
{-0.5619487624097632,0.6941602348969864,0.44983903422657323},
{-0.6779154193615721,0.5579126898684482,0.4787108884029866},
{-0.7736524515459892,0.41632822592889773,0.47763238218506265},
{0.5944017950961318,0.4504013602141617,0.666202011933114},
{0.5902383962565553,0.44552898260300816,0.6731437894277998},
{0.6319165532709222,0.4990130718186267,0.593015534245382},
{0.6767069193636258,0.5621057475606533,0.47550486206207193},
{0.6779154193615721,0.5579126898684482,0.4787108884029866},
{0.6078106094267821,0.4445077589506493,0.658011485690725},
{0.48621856417917736,0.2786106375572168,0.8282316224870314},
{0.4008185964101807,0.17160796193609532,0.8999417537662715},
{0.3468979775906859,0.11029935695662339,0.9313945699854854},
{0.37662682055087116,0.08810627427119423,0.9221656697555982},
{0.4317199739866554,0.13830639889357063,0.8913412388563955},
{0.4104304776467185,0.06780503504982338,0.9093675275929852},
{0.6023258102139634,0.4626198236841764,0.6505278757167244},
{0.6652142723253208,0.33790724987782,0.6658142851987351},
{0.6705926067572655,0.33869626589425267,0.6599927236203329},
{0.7153172715440348,0.3711089605340295,0.5921142967722954},
{0.77140485215178,0.4165026198097179,0.48110302614755174},
{0.7736524515459892,0.41632822592889773,0.47763238218506265},
{0.6854339538118739,0.33761672425866446,0.6451319574030345},
{0.5361204078117424,0.2179082948371175,0.8155310437800335},
{0.6251356399987834,0.4966283135872594,0.602134328656643},
{0.679312570795435,0.35310653429687633,0.6433119045969429},
{0.7135914191147773,0.227797260754409,0.6624920335811939},
{0.7183166148554546,0.22620523218753144,0.6579152177549821},
{0.7658335519028794,0.24551075606183972,0.5943260379940992},
{0.8289493198069665,0.2736162792848185,0.4878290242512225},
{0.8365312408425447,0.27151013973550614,0.4759177734811321},
{0.7454997428026331,0.22099992375503943,0.6287997830641122},
{0.5811160797043912,0.14320396250846468,0.8011221673570604},
{0.4623967239308163,0.08999936235677654,0.8820937503879176},
{0.46891220359890007,0.03570092912877103,0.8825229679591156},
{0.46448893368298094,-0.00019999523517028243,0.8855789013340106},
{0.5823999504960063,-0.0019999998300000215,0.8128999309035088},
{0.5909385747744936,-0.06300411272769182,0.8042524992953931},
{0.5839957660460442,-0.15149890163694468,0.7974942181878771},
{0.646307894699151,0.5308064838408004,0.5482066963856947},
{0.6586352840372741,0.5533296426629575,0.5099273175381204},
{0.6647056267569458,0.5663047937903692,0.48730412504687787},
{0.751023263305877,0.42511316808432525,0.5052156492971092},
{0.7341866379247836,0.40759258188251407,0.5429901176697869},
{0.7071968529810063,0.3804983067863022,0.5958973482627002},
{0.7302670817638346,0.2396220114908447,0.6397587677407903},
{0.856051651434631,0.1358081942346062,0.4987300917879094},
{0.8585997724710905,0.1310999652585138,0.4955998686660522},
{0.7579145483093835,0.10020192339437951,0.6446123734532637},
{0.587752262315959,0.05920526447014595,0.8068717461911107},
{0.6708269375965296,0.5652226969731046,0.4801192795767649},
{0.760105373963991,0.4349030747756081,0.4828034134321995},
{0.814817856929004,0.29130638404936043,0.501210984159078},
{0.7946353580869047,0.2789124104838129,0.5392239933053851},
{0.7627548364163558,0.25971867184650266,0.5922425778494373},
{0.2655046503546768,0.8324145798690508,0.4864085195198298},
{0.7958285508614024,0.1335047895702403,0.5906211889152353},
{0.8260071615131357,0.2979025828265897,0.4785041486489533},
{0.8305419060490813,0.29721499636097165,0.4710237661036933},
{0.8703887024279632,0.15359800631081702,0.46779392807422016},
{0.884766315720638,0.00010000749584273065,0.4660349306271248},
{0.7652048628923556,0.4340027580962916,0.47550302183130566},
{-0.8537315459634458,0.15040555758803123,0.49851842059596785},
{-0.8260071615131357,0.2979025828265897,0.4785041486489533},
{-0.8305419060490813,0.29721499636097165,0.4710237661036933},
{-0.8311370570718027,0.14390641621060332,0.537123948205108},
{-0.7958285508614024,0.1335047895702403,0.5906211889152353},
{-0.7922926079444516,0.12309885149307331,0.5975944244700294},
{0.8606356095350319,-0.0005000206887840065,0.5092210694576321},
{0.8575237237219797,-0.13610376536275384,0.49611372517606306},
{0.7514219380837281,-0.00190005547292931,0.6598192637046099},
{0.7564876050521361,-0.10459828617112153,0.6455894221039776},
{0.7436342600195568,-0.23231070280062271,0.6269288832789943},
{0.6802428430434247,-0.3590226119561739,0.6390402480222706},
{-0.8365312408425447,0.27151013973550614,0.4759177734811321},
{-0.7454997428026331,0.22099992375503943,0.6287997830641122},
{-0.6854339538118739,0.33761672425866446,0.6451319574030345},
{-0.6078106094267821,0.4445077589506493,0.658011485690725},
{-0.5361320884657708,0.2178130365003635,0.8155488120571461},
{-0.5811160797043912,0.14320396250846468,0.8011221673570604},
{-0.7579145483093835,0.10020192339437951,0.6446123734532637},
{-0.587752262315959,0.05920526447014595,0.8068717461911107},
{-0.8585997724710905,0.1310999652585138,0.4955998686660522},
{-0.856051651434631,0.1358081942346062,0.4987300917879094},
{-0.8606356095350319,-0.0005000206887840065,0.5092210694576321},
{-0.7514219380837281,-0.00190005547292931,0.6598192637046099},
{-0.7564876050521361,-0.10459828617112153,0.6455894221039776},
{-0.5823999504960063,-0.0019999998300000215,0.8128999309035088},
{-0.5909385747744936,-0.06300411272769182,0.8042524992953931},
{-0.5839957660460442,-0.15149890163694468,0.7974942181878771},
{-0.5361002198011352,-0.23460009618605918,0.8109003324692045},
{-0.6010519932462209,-0.4674404353465618,0.6482560765760406},
{-0.41650002082500154,0.6778000338900025,0.6059000302950023},
{-0.2705111195881107,0.7345301934841675,0.6223255812187848},
{-0.37219927049014473,0.43519914701050777,0.819798393196724},
{-0.4440071352519957,0.3531056744537831,0.8235132339640056},
{-0.5288244930736082,0.5633260910521246,0.6348294028047021},
{-0.12749998852500155,0.7532999322030092,0.6451999419320079},
{-0.2691035064415335,0.4688061085833925,0.8413109623532596},
{-0.3249148343253994,0.260211880244595,0.9092415123688924},
{-0.375107046452052,0.21410402198182976,0.9019169426689035},
{-0.4008185964101807,0.17160796193609532,0.8999417537662715},
{-0.48621856417917736,0.2786106375572168,0.8282316224870314},
{-0.4317199739866554,0.13830639889357063,0.8913412388563955},
{-0.4623181001079358,0.09000352370693104,0.8821345362431541},
{0.46291479267855384,0.7608243125293666,0.4548145338306465},
{0.20670848969201105,0.7476307058236452,0.6311259208738663},
{0.36081414058325967,0.645325290793729,0.6733263881782392},
{0.05410079150036952,0.48880715130093566,0.8707127386205497},
{-0.07780290443663493,0.4965185353828952,0.8645322735921711},
{0.027300126536379747,0.771203574536852,0.6360029478804952},
{0.6076423875731694,0.6287438595576885,0.4852338486677119},
{0.4761115291802704,0.5256127278663097,0.7050170721951073},
{0.1642965415941988,0.4079914118711692,0.8980810955919046},
{-0.05070269897650169,0.28071494285412274,0.9584510197057046},
{-0.13749879757827277,0.2909974552383809,0.9467917203426083},
{-0.19991784746290006,0.2792249275219695,0.9391838446843894},
{-0.17770400727054642,0.4756107251427793,0.8615194274821371},
{-0.2564141211144854,0.27791530521729907,0.925750982510449},
{-0.3013089881811782,0.18840562022347818,0.9347278833486466},
{-0.3244122549043979,0.1450054776853813,0.934735310293282},
{-0.3468979775906859,0.11029935695662339,0.9313945699854854},
{-0.37662682055087116,0.08810627427119423,0.9221656697555982},
{0.7337982498932611,0.49169882729969544,0.468798881916},
{0.5954965759045328,0.42489755684607217,0.6817960796838126},
{0.830560010128676,0.34112464714616664,0.4402318078972223},
{0.7018222165339021,0.29930947479138914,0.6464204627636283},
{0.3207080771346352,0.2685067624279687,0.9083228763997169},
{0.40379625884499265,0.1871982656161036,0.8954917033078031},
{0.7378155311803987,0.13910292814745656,0.6605139039640191},
{0.41909830265531134,0.07549969422685757,0.9047963355822614},
{0.7353186993922913,-0.0024000610343281642,0.6777172345684155},
{0.4070104358813657,-0.0004000102563944627,0.9134234204767555},
{0.42062138914147057,-0.07950404288337355,0.9037459566503732},
{0.7395405797049432,-0.14350787449311608,0.6576360854820428},
{0.4076086964243083,-0.19940425433514983,0.8911190122269409},
{0.6993910583424783,-0.3159959600174766,0.6410918036936843},
{0.8770209610514567,-0.1756041969904627,0.4472106884631829},
{0.8226959482324324,-0.3579982368630252,0.4415978251360668},
{0.5889032566440139,-0.4493024846496102,0.6718037150848166},
{0.7174222189101848,-0.5139159162223919,0.47031456586766085},
{0.46958531864451525,-0.5500828019300423,0.6905784094035397},
{0.5876235612390412,-0.6462259109473595,0.4869195234296957},
{-0.8438155727600942,0.1657030580781555,0.5104094196927614},
{-0.8789893423188362,0.1702979351500544,0.4453945996232192},
{-0.8581362913511581,-0.0005000211463414276,0.5134217130633779},
{-0.8408988101290255,-0.17209975647901687,0.5130992739650411},
{-0.8886941435248912,-0.0017999881381172544,0.4584969785148673},
{-0.8770209610514567,-0.1756041969904627,0.4472106884631829},
{-0.8226959482324324,-0.3579982368630252,0.4415978251360668},
{-0.7174222189101848,-0.5139159162223919,0.47031456586766085},
{-0.7353186993922913,-0.0024000610343281642,0.6777172345684155},
{-0.7395405797049432,-0.14350787449311608,0.6576360854820428},
{-0.6993910583424783,-0.3159959600174766,0.6410918036936843},
{-0.4070104358813657,-0.0004000102563944627,0.9134234204767555},
{-0.42062138914147057,-0.07950404288337355,0.9037459566503732},
{-0.40761682269341604,-0.19930822562021053,0.8911367779737561},
{-0.3236081922450813,-0.2904073517551657,0.9005227970231635},
{-0.5889032566440139,-0.4493024846496102,0.6718037150848166},
{-0.46958531864451525,-0.5500828019300423,0.6905784094035397},
{0.8789893423188362,0.1702979351500544,0.4453945996232192},
{0.8886941435248912,-0.0017999881381172544,0.4584969785148673},
{0.8438155727600942,0.1657030580781555,0.5104094196927614},
{0.7969162373337552,0.3250066220773879,0.5092103752670951},
{0.23660711015049166,0.3253097757056421,0.9155275120151103},
{0.024201426232073022,0.22971353741765177,0.972957338065448},
{-0.089302572844186,0.19500561819279139,0.9767281399430735},
{-0.1498011205165722,0.18100135389519073,0.9720072706415768},
{-0.2067062694962322,0.17220522306362449,0.9631292121520136},
{-0.25631769293940376,0.1785123222383284,0.9499655736369086},
{-0.23881529302694915,-0.34932236957417645,0.9060580212831487},
{-0.17019659865496345,-0.43279135075128194,0.8852823078098657},
{0.3236081922450813,-0.2904073517551657,0.9005227970231635},
{0.17100587073231513,-0.09850338167914058,0.9803336554320965},
{0.1791141989453479,-0.03290260829314319,0.9832779475324738},
{0.17010449251897192,-0.00010000264110462781,0.9854260254450025},
{0.17850736358062466,0.031301291204893854,0.9834405677601474},
{0.17060999291993656,0.09490555878137151,0.9807574446458487},
{0.23881529302694915,-0.34932236957417645,0.9060580212831487},
{0.12109782146978745,-0.15739716845040913,0.9800823684767852},
{0.08050592827230053,-0.061204506959811084,0.9948732601898704},
{0.06199774425311228,-0.020599250509905048,0.997863693390012},
{0.05139887823172375,0.0,0.998678204086041},
{0.061799999691,0.019399999903000002,0.9978999950105001},
{0.08020243257667063,0.057301737988070166,0.9951301827561715},
{0.12290621060773697,0.14780746890011004,0.9813495888476184},
{0.02940057905010664,0.07800153625538497,0.9965196266473222},
{-0.015100631144068276,0.029801245569088385,0.9994417725418433},
{-0.019799509671214414,0.10499739977159157,0.9942753770751762},
{-0.08350476408269025,0.06070346323136884,0.9946567467861525},
{-0.13020242374067711,0.10680198813751395,0.9857183493178604},
{-0.05650203100200721,0.14690528060521874,0.9875354976014534},
{0.03380007199423002,-0.7899016824923756,0.6123013042031669},
{0.09650464632804888,-0.90054335770371,0.42392041013948106},
{0.2805063254889605,-0.8613194229719845,0.4236095525031146},
{0.20980246204633823,-0.7657089856476702,0.6080071350055941},
{0.4460047232150284,-0.7689081427803484,0.45810485135606394},
{0.4146305324434261,-0.7494551881647455,0.5161380072215441},
{0.2517132933300404,-0.8290437829582976,0.49932637012192765},
{0.07930086160854209,-0.8677094277141485,0.49070533154239104},
{-0.08450263567831086,-0.8984280224070352,0.43091344039981244},
{-0.12290114913111659,-0.7733072304564074,0.6220058157815666},
{-0.17400242474068325,-0.504307027567394,0.8458117864693673},
{-0.07000421543075207,-0.5254316398188161,0.8479510609104953},
{0.062500171875709,-0.5165014203808591,0.8540023485096877},
{0.3585125660856658,-0.6662233515377143,0.6539229204000471},
{-0.26811198755495136,-0.7536336957158201,0.6001268322705196},
{-0.2695002358128095,-0.4964004343505701,0.8252007220509477},
{-0.25760603706821883,-0.2956069276295244,0.9199215586143421},
{-0.1986060565840447,-0.29720906352859056,0.9339284805832796},
{-0.1336043368671632,-0.30961005010534226,0.941430559331942},
{-0.04600165769960334,-0.29871076423633736,0.953234350418737},
{0.17019659865496345,-0.43279135075128194,0.8852823078098657},
{-0.5233211583021539,-0.5840236125519929,0.6205250883364924},
{-0.4128021383206148,-0.6966036084160374,0.5868030396476182},
{-0.37373194610344806,-0.4606393748334177,0.8050688161982225},
{-0.3268033513855528,-0.27660283657663376,0.9037092675860589},
{-0.3026114374154198,-0.19980755186913707,0.9319352231574015},
{-0.2571055663957693,-0.18900409198288762,0.9477205183713364},
{-0.20630751591970994,-0.1824066451951289,0.9613350220727928},
{-0.14799869391728926,-0.19189830650491763,0.9701914380983381},
{-0.0867010946082292,-0.20690261216196792,0.9745123032954942},
{0.02790126632770908,-0.24491111554322414,0.9691439855979522},
{-0.48620809786330543,-0.2984049699761627,0.8213136790932388},
{-0.4450981817776411,-0.3753984665003965,0.8129966789153498},
{-0.37660336308304854,-0.2263020208860698,0.8983080219264539},
{-0.32731611416896056,-0.1536075622864416,0.9323459005185516},
{-0.27181073537699474,-0.11760464488717653,0.9551377239093733},
{-0.2037983451641559,-0.10659913441854278,0.9731920977122498},
{-0.12980478339440374,-0.1125041458541635,0.9851363029416574},
{-0.054803641274893476,-0.15581035238372998,0.9862655296587581},
{0.0700000612500804,-0.1940001697502228,0.9785008561886238},
{0.029499394973613566,-0.08339828951862277,0.9960795706175076},
{-0.015299747479751751,-0.031599478454912115,0.999383505311366},
{-0.03350129568766657,-0.00020000773544875564,0.9994386540374318},
{0.7554246121348015,-0.43021401660099506,0.4942161018229003},
{0.8309992521010096,-0.28519974332034653,0.4775995701605803},
{0.7612915877744324,-0.435495187804762,0.48039469166798543},
{-0.4693174636277384,-0.037501395452887686,0.8822328284943337},
{-0.46288974941999733,-0.09619786972176224,0.8811804864741881},
{-0.410702764038903,-0.07220048591090526,0.9089061169587507},
{-0.3986980503713005,-0.03279983960917647,0.9164955183478728},
{-0.3765980944184633,-0.09399952436361007,0.921595336739394},
{-0.43189191074026706,-0.14869721492724639,0.88958333826011},
{-0.46448893368298094,-0.00019999523517028243,0.8855789013340106},
{-0.3916974657255951,-0.00019999870601255815,0.9200940470107738},
{-0.3462168265466652,-0.04560221632157115,0.9370455415200037},
{-0.3473915775933006,-0.11869712222315712,0.9301774481211521},
{-0.3999146251452672,-0.18380672193473396,0.8979328380043398},
{-0.3327991680031199,-0.00039999900000375,0.9429976425088404},
{-0.3016921877819448,-0.07209813304301696,0.9506753825796981},
{-0.1945002898056477,-0.0014000020860046622,0.9809014615442665},
{0.054803641274893476,-0.15581035238372998,0.9862655296587581},
{0.0867010946082292,-0.20690261216196792,0.9745123032954942},
{0.12980478339440374,-0.1125041458541635,0.9851363029416574},
{0.08320010608020287,-0.0636000810901551,0.9945012679899251},
{0.03350129568766657,-0.00020000773544875564,0.9994386540374318},
{0.08350476408269025,0.06070346323136884,0.9946567467861525},
{0.30149446913469513,0.06879873789872977,0.9509825543850583},
{0.018999463082759814,-0.11159684631768396,0.9935719220542185},
{0.015299747479751751,-0.031599478454912115,0.999383505311366},
{-0.05139887823172375,0.0,0.998678204086041},
{0.015100631144068276,0.029801245569088385,0.9994417725418433},
{-0.02790126632770908,-0.24491111554322414,0.9691439855979522},
{0.04600165769960334,-0.29871076423633736,0.953234350418737},
{-0.0700000612500804,-0.1940001697502228,0.9785008561886238},
{-0.029499394973613566,-0.08339828951862277,0.9960795706175076},
{-0.06199774425311228,-0.020599250509905048,0.997863693390012},
{-0.17010449251897192,-0.00010000264110462781,0.9854260254450025},
{-0.061799999691,0.019399999903000002,0.9978999950105001},
{-0.12109782146978745,-0.15739716845040913,0.9800823684767852},
{-0.08050592827230053,-0.061204506959811084,0.9948732601898704},
{-0.1791141989453479,-0.03290260829314319,0.9832779475324738},
{-0.17850736358062466,0.031301291204893854,0.9834405677601474},
{-0.08020243257667063,0.057301737988070166,0.9951301827561715},
{-0.018999463082759814,-0.11159684631768396,0.9935719220542185},
{-0.08320010608020287,-0.0636000810901551,0.9945012679899251},
{-0.17100587073231513,-0.09850338167914058,0.9803336554320965},
{0.07040415502381672,0.1810106826606651,0.9809578929383781},
{-0.20390934537945302,0.10120463831486338,0.9737446277389573},
{-0.27160462682422726,0.1116019011545794,0.9559162841726024},
{-0.30149446913469513,0.06879873789872977,0.9509825543850583},
{-0.4104304776467185,0.06780503504982338,0.9093675275929852},
{-0.46891220359890007,0.03570092912877103,0.8825229679591156},
{-0.398597815689955,0.03119982902540541,0.9165949770732884},
{-0.34639729637965255,0.04319966282794743,0.9370926860201283},
{0.1343044495801231,-0.9006298383608256,0.4133136933094928},
{0.09910089884922886,-0.9012081739952074,0.4219038266850621},
{0.09890522876313151,-0.9541504424964992,0.28251493554686197},
{0.13279638533158625,-0.9537740386239981,0.26959266178761787},
{0.09510456607982887,-0.9874474084881495,0.12610605449701806},
{0.05319888230322409,-0.9886792280676252,0.14029705238989362},
{0.054900223169860776,-0.9545038800661587,0.29310119145876495},
{0.05479989642829363,-0.9014982961698303,0.42929918862530025},
{0.09519847255276176,-0.8418864920396021,0.5311914771011244},
{0.13020078316006609,-0.8397050508410713,0.5272031711366116},
{0.15900500873666404,-0.8352263100431561,0.5264165823835216},
{0.16210954042718945,-0.8990529108207485,0.40672393640800714},
{0.1577984740961332,-0.9530907836566829,0.25829750227522946},
{0.12560098848366905,-0.9861077606986152,0.10870085547909895},
{0.12260539107757112,-0.7849345143294093,0.6073267047423241},
{0.088599866214303,-0.7908988057437049,0.6054990856970708},
{0.15179703012015824,-0.7741848532215185,0.6144879776603245},
{0.19019913459590637,-0.7494965897982746,0.634097114864691},
{0.1975121424321955,-0.8198504018527284,0.5374330397117056},
{0.19941628300428807,-0.8897726529032854,0.4105335214305931},
{0.19250785929378678,-0.947338675890931,0.2559104477572989},
{0.14609973482922192,-0.9848982124113667,0.09289983138695904},
{0.0,-0.9016275857179841,0.43251323294479604},
{0.05240035579962383,-0.8429057233492924,0.5355036360820336},
{0.0,-0.8431710949681848,0.5376453334775187},
{0.04830350672036017,-0.7936576176662076,0.6064440264022031},
{0.0,-0.9547198870223722,0.29750619711862963},
{-0.05479989642829363,-0.9014982961698303,0.42929918862530025},
{-0.05240035579962383,-0.8429057233492924,0.5355036360820336},
{-0.04830350672036017,-0.7936576176662076,0.6064440264022031},
{0.0,-0.794142050934925,0.6077321802709406},
{0.04279897690268557,-0.7540819738858688,0.6553843332247692},
{0.0804040006005773,-0.7497373041076218,0.656832681523124},
{0.11399754451933632,-0.7391840781464334,0.66378570220996},
{0.14429573395968728,-0.7207786904930186,0.6779799558189049},
{0.18271160895087374,-0.6860435891642003,0.7042447456114138},
{0.23791420271225902,-0.6262373843565221,0.7424443215367007},
{0.24919663462217398,-0.6993905547943358,0.6698909531837655},
{0.2595992614411518,-0.7807977786334797,0.5682983831933998},
{0.2636894144009341,-0.8611654292077529,0.4345825540335455},
{0.25899024402125814,-0.9274650630491,0.2696898409750321},
{0.3554207198548135,-0.8024467799985997,0.4793279432369502},
{0.3652013348133181,-0.880203217148638,0.3031011078365737},
{0.4663236128939734,-0.7052357105143257,0.5340270411438598},
{0.5136401040167428,-0.7833611633105815,0.35002732945066195},
{0.576214042507326,-0.5759140351960587,0.5799141326796222},
{0.6767235740763116,-0.6238217312085166,0.3910136211967457},
{0.0,-0.9892538762331894,0.14620796270247907},
{-0.054900223169860776,-0.9545038800661587,0.29310119145876495},
{-0.09910089884922886,-0.9012081739952074,0.4219038266850621},
{-0.09519847255276176,-0.8418864920396021,0.5311914771011244},
{-0.088599866214303,-0.7908988057437049,0.6054990856970708},
{-0.0804040006005773,-0.7497373041076218,0.656832681523124},
{-0.04279897690268557,-0.7540819738858688,0.6553843332247692},
{0.0,-0.754500022635001,0.6563000196890009},
{0.035900672964422134,-0.7139133824317817,0.6993131087470864},
{0.07070280731069752,-0.7089281485509684,0.7017278626579413},
{0.10400359026590503,-0.6950239926423462,0.7114245587996619},
{0.1359039990340082,-0.6703197244480921,0.7295214664849816},
{0.17449768792095247,-0.6284916725405079,0.7579899566996102},
{0.22540075622080566,-0.5643018932360278,0.7942026645544094},
{0.2800983600289031,-0.4872971468835576,0.8270951573720304},
{0.29950228371362,-0.5453041579600567,0.7829059696807783},
{0.320198427829579,-0.6222969445295035,0.7142964928128305},
{0.34021552608980776,-0.7113324623976492,0.6150280674463015},
{0.42432201864083574,-0.6142318733188812,0.6653345251042847},
{0.4936063552227355,-0.509506559939189,0.7048090744752512},
{0.6739342468389018,-0.4296218317880875,0.6010305421430182},
{0.5561286663909327,-0.4021207278471391,0.7273374915772799},
{0.43272838142162384,-0.44232901109957073,0.7855515220861695},
{0.4659242426690355,-0.36231885194031244,0.8072420018940663},
{0.6059048048441537,-0.3063024289878929,0.734205822275256},
{0.49601783216160505,-0.293710559084402,0.8171293763291281},
{0.4011839048246012,-0.32138710620794325,0.8577655871349524},
{0.4145226045339546,-0.2710147788388461,0.8687473740859987},
{0.5259217893911111,-0.2268093969079749,0.8197339622816006},
{0.4294103617970468,-0.2223053642931614,0.875321121753505},
{0.5539082560640853,-0.15870236547638628,0.8173121821288626},
{0.44901176875269055,-0.1673043851054012,0.8777230054214621},
{0.3560988070709945,-0.20449931492844248,0.911796945485349},
{0.36361442487035756,-0.1621064308896726,0.9173363914564879},
{0.46678751593482726,-0.10859709560951636,0.8776765268551797},
{0.37331864586541325,-0.11010549935650148,0.9211460077863171},
{0.47480204165316864,-0.060600260581680755,0.8780037754243515},
{0.3753121584343119,-0.06760219000841855,0.9244299473932266},
{0.475088878299537,-0.02839933517934509,0.8794794116279578},
{0.37122084649196857,-0.04070228570103212,0.9276520937660292},
{0.4734035292364657,-0.008300061877191943,0.8808065664374294},
{0.36590532213161586,-0.025100365087465316,0.9303135315087244},
{0.27680048024924986,-0.046500080677709964,0.9598016652573338},
{0.2691999878860008,-0.03629999836650011,0.9623999566920028},
{0.3627017736160095,-0.013700066993491399,0.9318045565354222},
{0.26431159692572825,-0.027601211029701474,0.9640422982837762},
{0.36311638781238126,-0.0018000812394995493,0.9317420504676278},
{0.2620032357599426,-0.01730021365895804,0.9649119167357579},
{0.36759320326450684,0.013899742996127978,0.9298828066258567},
{0.2618049036517685,-0.002300043080210342,0.9651180768308701},
{0.37722602760769314,0.02910200796231143,0.9256638683819746},
{0.26441398654773746,0.01060056073149023,0.9643510106958517},
{0.3963236731200143,0.03470207281671586,0.9174548012119634},
{0.27640227065398015,0.008100066542319968,0.9610078947122827},
{0.4289065687544011,0.024600376757655088,0.9030138297627051},
{0.30410773203738184,-0.0147003737617544,0.952524218236127},
{0.47512940904493745,-0.010400643767769625,0.8798544602772805},
{0.3760109608792668,-0.10070293553335681,0.9211268512390761},
{0.5381010062498226,-0.07080013239637137,0.8399015706174056},
{0.4957925210262301,-0.156697636233986,0.8541871146845618},
{0.5098135688687055,-0.3233086049730335,0.7972212183250923},
{0.5722897503823552,-0.21929607244251348,0.790185847898195},
{0.6618316065230724,-0.3454164957586418,0.665331773677546},
{-0.13020078316006609,-0.8397050508410713,0.5272031711366116},
{-0.1343044495801231,-0.9006298383608256,0.4133136933094928},
{-0.12260539107757112,-0.7849345143294093,0.6073267047423241},
{-0.11399754451933632,-0.7391840781464334,0.66378570220996},
{-0.10400359026590503,-0.6950239926423462,0.7114245587996619},
{-0.07070280731069752,-0.7089281485509684,0.7017278626579413},
{-0.035900672964422134,-0.7139133824317817,0.6993131087470864},
{0.0,-0.7137257481208036,0.700425268297339},
{0.027101734430994142,-0.6644425223598711,0.7468477960541117},
{0.0578016808973211,-0.6600191936372306,0.7490217818701298},
{0.08990108736022748,-0.6446077965784497,0.7592091826905973},
{0.12219971283101229,-0.6168985502901103,0.7774981728814407},
{0.15960286569518056,-0.5732102920831924,0.8037144308221592},
{0.20570761646550206,-0.5111189245285275,0.8345308990785683},
{0.2510962561827303,-0.4393934486925197,0.862487140412604},
{0.32331375244294647,-0.4050172277741829,0.85523637825304},
{0.347522330764818,-0.46182967581926027,0.8160524371340762},
{0.38651014602450146,-0.5325139786754127,0.7530197670283302},
{-0.15900500873666404,-0.8352263100431561,0.5264165823835216},
{-0.16210954042718945,-0.8990529108207485,0.40672393640800714},
{-0.15179703012015824,-0.7741848532215185,0.6144879776603245},
{-0.14429573395968728,-0.7207786904930186,0.6779799558189049},
{-0.1359039990340082,-0.6703197244480921,0.7295214664849816},
{-0.12219971283101229,-0.6168985502901103,0.7774981728814407},
{-0.08990108736022748,-0.6446077965784497,0.7592091826905973},
{-0.0578016808973211,-0.6600191936372306,0.7490217818701298},
{-0.027101734430994142,-0.6644425223598711,0.7468477960541117},
{0.0,-0.6633826030193508,0.748280376604432},
{0.015099372030175626,-0.5805758543523157,0.8140661436931111},
{0.036800197249585886,-0.5780030981049087,0.8152043695071308},
{0.06259934865716581,-0.566194108780947,0.8218914482639709},
{0.09060633994741694,-0.5443380886686429,0.8339583541076268},
{0.12420425903706482,-0.5097174785120124,0.8513291925785288},
{0.16590434177343705,-0.4601120412896829,0.8722228263700531},
{0.20990703305296562,-0.3987133591148994,0.8927299114167814},
{0.2939090834005859,-0.3593111046812879,0.8857273738274888},
{0.3486085741333225,-0.3314081510837151,0.8767215632320249},
{0.3832166607064942,-0.38051654331633883,0.8416365909462044},
{-0.09890522876313151,-0.9541504424964992,0.28251493554686197},
{-0.13279638533158625,-0.9537740386239981,0.26959266178761787},
{-0.1577984740961332,-0.9530907836566829,0.25829750227522946},
{-0.19941628300428807,-0.8897726529032854,0.4105335214305931},
{-0.1975121424321955,-0.8198504018527284,0.5374330397117056},
{-0.19019913459590637,-0.7494965897982746,0.634097114864691},
{-0.18271160895087374,-0.6860435891642003,0.7042447456114138},
{-0.17449768792095247,-0.6284916725405079,0.7579899566996102},
{-0.15960286569518056,-0.5732102920831924,0.8037144308221592},
{-0.12420425903706482,-0.5097174785120124,0.8513291925785288},
{-0.09060633994741694,-0.5443380886686429,0.8339583541076268},
{-0.06259934865716581,-0.566194108780947,0.8218914482639709},
{-0.036800197249585886,-0.5780030981049087,0.8152043695071308},
{-0.015099372030175626,-0.5805758543523157,0.8140661436931111},
{0.0,-0.5791266838767035,0.8152375629360884},
{-0.007000266995274897,-0.368414051579896,0.9296354569725063},
{-0.010400289860117658,-0.3741104266028861,0.9273258449314524},
{-0.00789990666315416,-0.3820954855685068,0.9240890819519947},
{0.0017000809767854321,-0.38921853892052366,0.9211438751276834},
{0.023300255605205992,-0.388604263012148,0.9211101046332721},
{0.056799532825763756,-0.37299693211284995,0.9260923829214756},
{0.09939516702750206,-0.33918350760290444,0.9354545146300621},
{0.25239602984167564,-0.32869482967099356,0.9100856844647742},
{0.3189130342420697,-0.2912119020736616,0.9019368629128962},
{0.35740345074697555,-0.27930269668055474,0.8912086046606172},
{-0.09510456607982887,-0.9874474084881495,0.12610605449701806},
{-0.12560098848366905,-0.9861077606986152,0.10870085547909895},
{-0.14609973482922192,-0.9848982124113667,0.09289983138695904},
{-0.19250785929378678,-0.947338675890931,0.2559104477572989},
{-0.2636894144009341,-0.8611654292077529,0.4345825540335455},
{-0.2595992614411518,-0.7807977786334797,0.5682983831933998},
{-0.24919663462217398,-0.6993905547943358,0.6698909531837655},
{-0.23791420271225902,-0.6262373843565221,0.7424443215367007},
{-0.22540075622080566,-0.5643018932360278,0.7942026645544094},
{-0.20570761646550206,-0.5111189245285275,0.8345308990785683},
{-0.16590434177343705,-0.4601120412896829,0.8722228263700531},
{-0.056799532825763756,-0.37299693211284995,0.9260923829214756},
{-0.023300255605205992,-0.388604263012148,0.9211101046332721},
{-0.0017000809767854321,-0.38921853892052366,0.9211438751276834},
{0.00789990666315416,-0.3820954855685068,0.9240890819519947},
{0.010400289860117658,-0.3741104266028861,0.9273258449314524},
{0.007000266995274897,-0.368414051579896,0.9296354569725063},
{0.0,-0.3662123250832045,0.9305313175584974},
{-0.019099921117488677,-0.1940991983719661,0.980795949321094},
{-0.03990202168714446,-0.20211024017473425,0.9785495794704476},
{-0.05780405394045925,-0.22271561959412245,0.9731682506827145},
{-0.0675016217459439,-0.2537060953621625,0.9649231825579447},
{-0.06160320529815967,-0.28431479328355186,0.9567497809861908},
{-0.21740889111840714,-0.14440590560026675,0.9653394783652182},
{-0.19980525095099338,-0.17640463597475092,0.9638253296624997},
{0.14069834117633623,-0.29529651847457067,0.9449888586470344},
{0.2813014149496758,-0.2636013259180041,0.922704641216018},
{0.32490750220083975,-0.23910552101022092,0.9150211280817739},
{0.357220881957,-0.2385139427400462,0.9030527894937599},
{-0.05319888230322409,-0.9886792280676252,0.14029705238989362},
{0.24660629223982078,-0.9654246331237752,0.0845021561000197},
{0.37029815221683066,-0.9241953882765187,0.09349953343849221},
{0.22671237543277872,-0.9663527498045614,-0.12150663262056732},
{0.15309870632139738,-0.9822916996702066,-0.10799908741156705},
{0.17720405979151527,-0.9805224640269793,0.08470194054368703},
{0.5642134115121894,-0.8181194469303831,0.11110264094116312},
{0.36989336787137056,-0.9187835263590572,-0.13789752751949716},
{0.19120545899378252,-0.9155261386443928,-0.35391010427771774},
{0.1164090010919601,-0.9362723953805244,-0.33142562682023685},
{0.09630168818339091,-0.9455165750508422,-0.31100545197336005},
{0.12620750136577213,-0.9875586972955624,-0.09380557550007468},
{0.11279949804335054,-0.9908955905244332,-0.07349967292718321},
{0.08779916064403634,-0.9947904898483753,-0.05179950479910116},
{0.04990341201292297,-0.9981682470961607,-0.034202338493826964},
{0.0,-0.9996434604441847,-0.026701160858203014},
{-0.04990341201292297,-0.9981682470961607,-0.034202338493826964},
{-0.08779916064403634,-0.9947904898483753,-0.05179950479910116},
{-0.11279949804335054,-0.9908955905244332,-0.07349967292718321},
{-0.12620750136577213,-0.9875586972955624,-0.09380557550007468},
{-0.17720405979151527,-0.9805224640269793,0.08470194054368703},
{-0.15309870632139738,-0.9822916996702066,-0.10799908741156705},
{-0.24660629223982078,-0.9654246331237752,0.0845021561000197},
{-0.22671237543277872,-0.9663527498045614,-0.12150663262056732},
{-0.37029815221683066,-0.9241953882765187,0.09349953343849221},
{-0.36989336787137056,-0.9187835263590572,-0.13789752751949716},
{-0.5642134115121894,-0.8181194469303831,0.11110264094116312},
{-0.6054382043560803,-0.7808492731437521,-0.15400971831984864},
{-0.3459046161279035,-0.8545114035307707,-0.3875051712910166},
{-0.5916756530478053,-0.6853717975307855,-0.42448253290314913},
{-0.29071163160507546,-0.7185287489103773,-0.6318252798351794},
{-0.4972160255307584,-0.558317994878967,-0.6641214049778292},
{-0.24272488300320036,-0.5280541336039959,-0.8137834252150974},
{-0.3889083207825357,-0.45580975215397207,-0.8006171293867268},
{-0.6702351480527701,-0.32981729607252097,-0.6648348648544934},
{-0.4486072114188858,-0.313305036418941,-0.8370134550994369},
{-0.22991250068250238,-0.34751889511600514,-0.9090494263610034},
{-0.5180947931734928,-0.12799871361939216,-0.8456915008431246},
{-0.25709901531265705,-0.1824993010290156,-0.9489963653508812},
{-0.11379884039572452,-0.2462974902413616,-0.9624901922749108},
{-0.31009193616404873,-0.07459806010267021,-0.9477753534223973},
{-0.16859666097619372,-0.14419714420383828,-0.975080688718188},
{-0.09629963261760235,-0.20649921220700815,-0.9736962853557571},
{-0.14400182523470234,-0.12530158820769585,-0.9816124420165543},
{-0.22329775698529658,-0.07059929083368534,-0.9721902343981429},
{-0.34021552608980776,-0.7113324623976492,0.6150280674463015},
{-0.3554207198548135,-0.8024467799985997,0.4793279432369502},
{-0.320198427829579,-0.6222969445295035,0.7142964928128305},
{-0.29950228371362,-0.5453041579600567,0.7829059696807783},
{-0.2800983600289031,-0.4872971468835576,0.8270951573720304},
{-0.2510962561827303,-0.4393934486925197,0.862487140412604},
{-0.20990703305296562,-0.3987133591148994,0.8927299114167814},
{-0.09939516702750206,-0.33918350760290444,0.9354545146300621},
{0.19980525095099338,-0.17640463597475092,0.9638253296624997},
{0.21740889111840714,-0.14440590560026675,0.9653394783652182},
{0.06160320529815967,-0.28431479328355186,0.9567497809861908},
{0.0675016217459439,-0.2537060953621625,0.9649231825579447},
{0.05780405394045925,-0.22271561959412245,0.9731682506827145},
{0.03990202168714446,-0.20211024017473425,0.9785495794704476},
{0.019099921117488677,-0.1940991983719661,0.980795949321094},
{0.0,-0.19430803480336212,0.9809405627309207},
{-0.42432201864083574,-0.6142318733188812,0.6653345251042847},
{-0.4663236128939734,-0.7052357105143257,0.5340270411438598},
{-0.38651014602450146,-0.5325139786754127,0.7530197670283302},
{-0.347522330764818,-0.46182967581926027,0.8160524371340762},
{-0.32331375244294647,-0.4050172277741829,0.85523637825304},
{-0.2939090834005859,-0.3593111046812879,0.8857273738274888},
{-0.25239602984167564,-0.32869482967099356,0.9100856844647742},
{-0.14069834117633623,-0.29529651847457067,0.9449888586470344},
{0.18249432998924944,-0.19699387949524463,0.9632700716638029},
{0.42029839866615165,-0.03269987541371201,0.9067965451117448},
{0.43021147819535943,-0.10480279617590346,0.8966239222453725},
{0.4398073690342028,-0.16170270935159298,0.8834148017390057},
{0.4396144701484313,-0.16750551353471851,0.8824290456300632},
{0.4428138071497638,-0.2494077766557161,0.8612268534719434},
{0.4414096912561585,-0.25530560529609714,0.8602188863129757},
{0.14920036404933243,-0.30620074713073453,0.9402022940963964},
{0.5591245852485319,-0.47982109819754176,0.6761297300778616},
{0.07860489684457815,-0.4216262660263886,0.9033562763321558},
{0.2764018228760328,-0.7188047405328958,0.6379042069921177},
{0.6412198749180393,-0.6824211519714131,0.3509108766511853},
{0.7885284427339033,-0.5240189017026827,0.3219116115612473},
{-0.25899024402125814,-0.9274650630491,0.2696898409750321},
{-0.3652013348133181,-0.880203217148638,0.3031011078365737},
{-0.5136401040167428,-0.7833611633105815,0.35002732945066195},
{-0.576214042507326,-0.5759140351960587,0.5799141326796222},
{-0.4936063552227355,-0.509506559939189,0.7048090744752512},
{-0.43272838142162384,-0.44232901109957073,0.7855515220861695},
{-0.3832166607064942,-0.38051654331633883,0.8416365909462044},
{-0.3486085741333225,-0.3314081510837151,0.8767215632320249},
{-0.3189130342420697,-0.2912119020736616,0.9019368629128962},
{-0.2813014149496758,-0.2636013259180041,0.922704641216018},
{-0.17211018836415926,-0.24681461062332657,0.9536564533646849},
{-0.07529755061051732,-0.23789226149059853,0.9683684994850594},
{-0.18020372845371294,-0.208304309860757,0.9613198899142855},
{-0.07550263848580364,-0.2175076009359244,0.9731340067620599},
{-0.15960434688358185,-0.18110493246000425,0.9704264299237334},
{-0.1096017448736677,-0.16600264278310983,0.9800156019725761},
{-0.061303714811151884,-0.26441602277436477,0.9624583219290795},
{-0.019100508366795364,-0.5740152776199234,0.8186217879088317},
{0.0035002134320212246,-0.8412512968617869,0.5406329661001925},
{0.13820703146159294,-0.9374476938646689,0.3195162558030315},
{0.01440112642815709,-0.9489742269221015,0.3150246406159364},
{0.13000606557448738,-0.9637449645702575,0.23301087137581197},
{0.010300712370396816,-0.9698670734767797,0.24341683407326065},
{0.36950959628882507,-0.87912283111639,0.30100781727452325},
{-0.00600019077909878,-0.947530127199349,0.31961016216666166},
{0.2778069383149277,-0.8389209523124292,0.4680116887378912},
{0.5848093043900499,-0.7633121443928267,0.2745043673992283},
{0.434889382305345,-0.7728811303375516,0.4620887182416646},
{0.13030260998741733,-0.7136142938374597,0.6883137870632337},
{0.4738209220247282,-0.5995264726758645,0.6450284818614388},
{-0.011700709377009623,-0.5215316188128648,0.8531517238911889},
{0.19060392552826977,-0.49741024426947217,0.8463174300869608},
{0.7987964693274083,-0.2655988260557833,0.5397976140998184},
{0.5689154007483501,-0.21710587713564217,0.7932214727959068},
{0.06600381183020297,-0.2687155187693263,0.9609554967824551},
{0.36721653062419746,-0.13530609094077864,0.9202414256001811},
{0.49453525667521736,0.14211013139241332,0.8574611305830766},
{0.1679086601124737,0.06200319789739946,0.9838507434106709},
{-0.051700207318247024,-0.3070012310774049,0.9503038107259215},
{0.04120008363625467,-0.022300045269137845,0.9989020277731746},
{-0.03690088839958246,-0.30000722276083297,0.9532229491187534},
{0.02840071556504311,-0.05040126987599199,0.9983251531191033},
{0.10569827026196063,0.11099818352958969,0.9881838285039687},
{0.15739947271264962,0.32849889953052985,0.9312968801606772},
{0.02000103197986819,-0.0591030495005105,0.9980514957954226},
{0.0946996960144637,0.304799021596711,0.9476969578976477},
{0.011200470877693755,-0.05820244688230148,0.9982419669744559},
{0.044501125670210924,0.2996075786695549,0.9530241070496857},
{0.0,-0.05509894596724537,0.9984808992430945},
{0.0,0.3020022816358567,0.9533072022631198},
{-0.044501125670210924,0.2996075786695549,0.9530241070496857},
{-0.011200470877693755,-0.05820244688230148,0.9982419669744559},
{-0.0946996960144637,0.304799021596711,0.9476969578976477},
{-0.02000103197986819,-0.0591030495005105,0.9980514957954226},
{-0.15739947271264962,0.32849889953052985,0.9312968801606772},
{-0.02840071556504311,-0.05040126987599199,0.9983251531191033},
{-0.10569827026196063,0.11099818352958969,0.9881838285039687},
{-0.04120008363625467,-0.022300045269137845,0.9989020277731746},
{0.03690088839958246,-0.30000722276083297,0.9532229491187534},
{0.051700207318247024,-0.3070012310774049,0.9503038107259215},
{-0.1679086601124737,0.06200319789739946,0.9838507434106709},
{-0.06600381183020297,-0.2687155187693263,0.9609554967824551},
{-0.49453525667521736,0.14211013139241332,0.8574611305830766},
{-0.36721653062419746,-0.13530609094077864,0.9202414256001811},
{-0.7726259568050357,0.1461049084768518,0.6178207560369545},
{-0.5689154007483501,-0.21710587713564217,0.7932214727959068},
{-0.19060392552826977,-0.49741024426947217,0.8463174300869608},
{-0.7987964693274083,-0.2655988260557833,0.5397976140998184},
{-0.4738209220247282,-0.5995264726758645,0.6450284818614388},
{0.011700709377009623,-0.5215316188128648,0.8531517238911889},
{-0.13030260998741733,-0.7136142938374597,0.6883137870632337},
{-0.434889382305345,-0.7728811303375516,0.4620887182416646},
{-0.2778069383149277,-0.8389209523124292,0.4680116887378912},
{-0.5848093043900499,-0.7633121443928267,0.2745043673992283},
{-0.36950959628882507,-0.87912283111639,0.30100781727452325},
{-0.820253597121111,-0.5392352347813986,0.1908124680940112},
{-0.6627322957316757,-0.7150348444969792,0.22251084321759143},
{-0.7885284427339033,-0.5240189017026827,0.3219116115612473},
{-0.6412198749180393,-0.6824211519714131,0.3509108766511853},
{-0.5591245852485319,-0.47982109819754176,0.6761297300778616},
{-0.2764018228760328,-0.7188047405328958,0.6379042069921177},
{-0.07860489684457815,-0.4216262660263886,0.9033562763321558},
{-0.14920036404933243,-0.30620074713073453,0.9402022940963964},
{-0.4414096912561585,-0.25530560529609714,0.8602188863129757},
{-0.4428138071497638,-0.2494077766557161,0.8612268534719434},
{-0.4396144701484313,-0.16750551353471851,0.8824290456300632},
{-0.4398073690342028,-0.16170270935159298,0.8834148017390057},
{-0.43021598497188795,-0.10470389034532002,0.8966333150297413},
{-0.18249432998924944,-0.19699387949524463,0.9632700716638029},
{-0.42029839866615165,-0.03269987541371201,0.9067965451117448},
{-0.40811672904759255,0.050402066023030295,0.9115373646823832},
{-0.6767235740763116,-0.6238217312085166,0.3910136211967457},
{-0.6739342468389018,-0.4296218317880875,0.6010305421430182},
{-0.5561286663909327,-0.4021207278471391,0.7273374915772799},
{-0.4659242426690355,-0.36231885194031244,0.8072420018940663},
{-0.4011839048246012,-0.32138710620794325,0.8577655871349524},
{-0.35740345074697555,-0.27930269668055474,0.8912086046606172},
{-0.32481805226489585,-0.23911328909032206,0.9150508553644696},
{-0.28940480994791234,-0.21120351023151032,0.9336155168188354},
{-0.27670260931790885,-0.16600156540214264,0.9465089256212531},
{-0.2212091040480195,-0.11400469195964838,0.9685398610782409},
{-0.11150284224367364,-0.11890303087688607,0.9866251493955912},
{-0.058997355502808047,-0.15369311086070506,0.9863557875927096},
{-0.06230395113034537,-0.34682199441418576,0.9358593494025232},
{-0.08509835166089234,-0.6452875009021601,0.7591852947232605},
{-0.10830037526145042,-0.8657029996660908,0.48870169335430125},
{-0.11689990121962522,-0.9497991974200173,0.2901997547813108},
{-0.11790137061140007,-0.9635112008828157,0.24030279353621237},
{-0.11540253830674539,-0.9389206517868565,0.32420713101427084},
{-0.030701043699721157,-0.8726296655497291,0.48741657000795086},
{-0.05400093611434138,-0.7103123133706793,0.7018121660193478},
{-0.05900442844853883,-0.49973750670737044,0.8641648580064815},
{0.8781437194733881,-0.2579128405104052,0.4029200598745337},
{0.7426162597610133,-0.29910654900958666,0.5992131199148923},
{0.8049262973717097,-0.4293140259183439,0.40961338228780264},
{0.9150355726993464,-0.13010505793244256,0.3818148433405578},
{0.787367114096327,-0.18821604327820238,0.5870500393427459},
{0.9784462962817888,-0.16840796841154254,0.11950565454382027},
{0.9201502139673017,-0.37012019801032314,0.12780697461691246},
{0.7783883515054789,-0.6150907952351234,0.12559812043819135},
{0.647221057679673,-0.21780708646883926,0.730523767977443},
{0.8128177440050295,-0.1009022027191283,0.5737125242811091},
{0.9304147332339521,-0.0436006904223993,0.363905762493374},
{0.9934607966937373,-0.04190256430588645,0.10620649950561195},
{0.9886028224650872,-0.05830016644721281,-0.13880039627569704},
{0.9574556489395215,-0.24761439176668634,-0.14820861413498754},
{0.8390247641813777,-0.520615366189303,-0.1581046665280999},
{0.6776328490485557,-0.13800669003645322,0.7223350160386243},
{0.823892605597047,-0.03449969036666844,0.5656949229108502},
{0.93442786505441,0.015600465212809072,0.3558106104306069},
{0.9948910957645392,0.028999740453484406,0.09669913454661869},
{0.989356523552832,0.04170238252517244,-0.13940796460453328},
{0.9340195772555111,0.017200360523334894,-0.3568074787631331},
{0.9088271334391094,-0.14780441276661568,-0.39011164695708245},
{0.807971254086951,-0.40713590486297535,-0.4259375629603075},
{-0.7426162597610133,-0.29910654900958666,0.5992131199148923},
{-0.6059048048441537,-0.3063024289878929,0.734205822275256},
{-0.49601783216160505,-0.293710559084402,0.8171293763291281},
{-0.4145226045339546,-0.2710147788388461,0.8687473740859987},
{-0.357220881957,-0.2385139427400462,0.9030527894937599},
{-0.3173066365377056,-0.20080419986376072,0.9268193846301465},
{-0.3025005293763896,-0.1720003010007901,0.9375016406293066},
{-0.2946177866126829,-0.13690826540148096,0.9457570970794781},
{-0.21849849018064924,-0.08539940989211646,0.972093282858623},
{-0.13060185390647439,-0.07340104193518546,0.9887140348953387},
{-0.06169879719367295,-0.0748985398671978,0.9952805971938847},
{-0.01960044846339132,-0.07720176639662296,0.9968228075667587},
{-0.025801036061404985,-0.1698068187297119,0.9851395590732578},
{-0.045300805908505735,-0.3777067194623094,0.9248164526310397},
{-0.0779049288112368,-0.6725425497504075,0.7359465611320816},
{-0.10129792797207479,-0.8800819981068413,0.4638905112166386},
{-0.1086062667623935,-0.9550551082696666,0.2758159150374597},
{-0.1079081009652206,-0.965272465724105,0.23791786116428157},
{-0.10160650099190684,-0.9392600957834538,0.32782097465695925},
{-0.10680157586887801,-0.862012719091506,0.49550731126431696},
{-0.08540495832878785,-0.6977405085011157,0.7112412923118726},
{-0.05550256844078327,-0.4884226022788928,0.8708402990672807},
{-0.787367114096327,-0.18821604327820238,0.5870500393427459},
{-0.647221057679673,-0.21780708646883926,0.730523767977443},
{-0.5259217893911111,-0.2268093969079749,0.8197339622816006},
{-0.4294103617970468,-0.2223053642931614,0.875321121753505},
{-0.3560988070709945,-0.20449931492844248,0.911796945485349},
{-0.36361442487035756,-0.1621064308896726,0.9173363914564879},
{-0.37331864586541325,-0.11010549935650148,0.9211460077863171},
{-0.29169181232574043,-0.09509733065539223,0.9517732840988677},
{-0.2101013341477078,-0.06950044132920367,0.9752061925789844},
{-0.12830094814751022,-0.0532003931523581,0.9903073183981245},
{-0.06089991930766038,-0.04779993666512588,0.9969986789776255},
{-0.0175005101473063,-0.04510131472248652,0.9988291162931161},
{0.0,-0.04460021943361942,0.9990049151162735},
{0.0,-0.07759880653953305,0.996984666493743},
{0.0,-0.17369976289998545,0.9847986557507523},
{0.0,-0.38781556529007566,0.9217369946566857},
{0.0,-0.6865647976105561,0.7270686203392196},
{0.0,-0.8916500006757211,0.45272538728790823},
{0.0,-0.9631113551498163,0.26910317274511014},
{0.0,-0.9715321290987727,0.23690783467164103},
{0.0,-0.9439409584868024,0.33011432397128243},
{-0.08760708726199767,-0.8598695619619362,0.5029406870326328},
{-0.06260300470331784,-0.6917332005317084,0.7194345300889273},
{-0.034801369634853495,-0.48171895842267043,0.8756344612723485},
{-0.02420139972843111,-0.2938169933972339,0.9555552661370218},
{-0.012300365264769887,-0.28840856441948254,0.9574284312594057},
{0.0,-0.28491563374974754,0.9585525972240542},
{0.012300365264769887,-0.28840856441948254,0.9574284312594057},
{0.02420139972843111,-0.2938169933972339,0.9555552661370218},
{0.05550256844078327,-0.4884226022788928,0.8708402990672807},
{0.05900442844853883,-0.49973750670737044,0.8641648580064815},
{-0.8781437194733881,-0.2579128405104052,0.4029200598745337},
{-0.8049262973717097,-0.4293140259183439,0.40961338228780264},
{-0.9150355726993464,-0.13010505793244256,0.3818148433405578},
{-0.9304147332339521,-0.0436006904223993,0.363905762493374},
{-0.8128177440050295,-0.1009022027191283,0.5737125242811091},
{-0.93442786505441,0.015600465212809072,0.3558106104306069},
{-0.823892605597047,-0.03449969036666844,0.5656949229108502},
{-0.6776328490485557,-0.13800669003645322,0.7223350160386243},
{-0.6952602399568979,-0.07080613490930433,0.715261972982125},
{-0.8256393963237157,0.013900663285973412,0.5640269131862593},
{-0.7019042605717926,-0.019500118366077724,0.7120043218793507},
{-0.8233407357906298,0.04900242445492635,0.5654279752411298},
{-0.7030890389273241,0.01739972874034339,0.7108889173281677},
{-0.8217928791955526,0.07599934146855926,0.5646951069380975},
{-0.7053584731142937,0.04440368099571053,0.707458647215442},
{-0.8222304847603442,0.10100374478325805,0.5601207668624043},
{-0.7111070791062089,0.06780067495907884,0.6998069666130291},
{-0.8245948009461701,0.12909918603219808,0.5507965272388436},
{-0.7208375277785697,0.09300484195811179,0.6868357576003352},
{-0.8274937648579725,0.16689874242271371,0.536095960532156},
{-0.7338293904556434,0.1261050506084173,0.6675267349811147},
{-0.8307387008638406,0.21050980682778192,0.5153240069280571},
{-0.7496146138793478,0.1633031836265975,0.6414125044586628},
{-0.8364948221130766,0.25179844137247187,0.48669698735497235},
{-0.7680064628015768,0.19540164431175533,0.6099051323732835},
{-0.8464045367404754,0.27440147079582516,0.4564024463236684},
{-0.7886489371848756,0.2163134226643274,0.5755357130990312},
{-0.8584843843110728,0.27669496696432594,0.43179214577230196},
{-0.8114336224487336,0.21710899609763382,0.5426224840284481},
{-0.6972272969830259,0.1455056966595385,0.7019274809988322},
{-0.7312775281868329,0.1398957010711581,0.6675794855976065},
{-0.8355631584283348,0.19731491461150266,0.5127387568237072},
{-0.7670674731934342,0.11279521702023124,0.6315732187054792},
{-0.8589466549546302,0.16300885406636947,0.48542636664917627},
{-0.8003081071621885,0.0707007162018827,0.5954060314936487},
{-0.6577058207222701,0.02010017788736146,0.7530066641384666},
{-0.7050508571525558,-0.02930211363768778,0.7085511096348734},
{-0.827409109824449,0.027900307184073155,0.5609061756109903},
{-0.7418820355440112,-0.06789835586121898,0.6670838467602236},
{-0.8469222785835611,-0.0017000447202645574,0.5317139869203913},
{-0.7623973430498893,-0.08799969332160318,0.6410977657781796},
{-0.8507916963135658,-0.0491995198150299,0.523194893642757},
{-0.7498278191281441,-0.1100040812271217,0.6524242053870382},
{-0.8114784027897108,-0.13869630864686738,0.5676848912676756},
{-0.6510133393999878,-0.16410336251234717,0.7411151856057312},
{-0.9201502139673017,-0.37012019801032314,0.12780697461691246},
{-0.9784462962817888,-0.16840796841154254,0.11950565454382027},
{-0.9934607966937373,-0.04190256430588645,0.10620649950561195},
{-0.9948910957645392,0.028999740453484406,0.09669913454661869},
{-0.9928202338825519,0.07320149186160636,0.09460192800693938},
{-0.9328668469689652,0.05610402027761465,0.35582549758957743},
{-0.9291702623816211,0.084397298907672,0.3598884819534497},
{-0.9255064137816713,0.10700074151770808,0.36330251769517147},
{-0.9217216284517704,0.1303030575971202,0.36530857206621653},
{-0.9174035732938769,0.15880061852961375,0.3649014212938039},
{-0.9109875878786722,0.19909728731794032,0.3611950787505778},
{-0.9026566841062735,0.24671549298583834,0.35262214360278316},
{-0.8935132866413592,0.29050431983135405,0.34240509160156846},
{-0.8899724780266689,0.31389029309277683,0.3307897704845192},
{-0.8943315972935084,0.3153111401393752,0.31741121433630726},
{-0.903637655365665,0.2979124142689593,0.30771282266048594},
{-0.8735341820613292,0.2595101548310417,0.4118161146798573},
{-0.8890795958574099,0.23219467119344345,0.3944909465366643},
{-0.9040238439433301,0.20150531477276662,0.3770099437684021},
{-0.8795833312742694,0.12421176775925442,0.4592435084947635},
{-0.8962469959433808,0.0938049187898785,0.4335227323604726},
{-0.9060946223443745,0.022099868837667673,0.4224974924848231},
{-0.882758603875192,-0.1263083852604925,0.4525300422040607},
{-0.774861212579327,-0.34992764362610546,0.5264415878959187},
{-0.6558972124427707,-0.23049902038124503,0.7187969451194748},
{-0.7783883515054789,-0.6150907952351234,0.12559812043819135},
{-0.8390247641813777,-0.520615366189303,-0.1581046665280999},
{-0.9574556489395215,-0.24761439176668634,-0.14820861413498754},
{-0.9886028224650872,-0.05830016644721281,-0.13880039627569704},
{-0.989356523552832,0.04170238252517244,-0.13940796460453328},
{-0.9855266243613905,0.09040244225496671,-0.14340387410798924},
{-0.9824507645425398,0.11890614403919786,-0.14370742555452257},
{-0.9901455427916352,0.1010046458155289,0.09700446182283468},
{-0.9877756219984698,0.11839707799617213,0.10139749754064066},
{-0.9854039810401252,0.13240053489924147,0.10700043228261963},
{-0.9817323486138391,0.15050495922011078,0.11640383556957407},
{-0.9759467148075331,0.17610842963173132,0.1285061510941367},
{-0.9660121090376806,0.21580270510386282,0.14230178376403932},
{-0.9521213753648181,0.26380592250944124,0.15450346864180695},
{-0.9384674970096647,0.3052219523522482,0.161611623525961},
{-0.9288217625488477,0.33190777669031285,0.1647038590566271},
{-0.9284591168740169,0.33232115956186536,0.16591056386191233},
{-0.9340753782540949,0.31502542200218403,0.16811356647164172},
{-0.9385272082981585,0.29790863649655985,0.1744050560758645},
{-0.9126328006122916,0.2770099559167267,0.30061080414645497},
{-0.9208345641740616,0.2573096582992898,0.29301099837423983},
{-0.9277945213895267,0.24439855683078288,0.2818983353952442},
{-0.9170865601949397,0.17689740758748754,0.3572947638836026},
{-0.9321071865741128,0.08690067000674864,0.35160271086735123},
{-0.9139951695482933,-0.13359929392959735,0.38309797533255047},
{-0.7875934787529938,-0.42539647773174655,0.44579630882184434},
{0.9328668469689652,0.05610402027761465,0.35582549758957743},
{0.8256393963237157,0.013900663285973412,0.5640269131862593},
{0.9928202338825519,0.07320149186160636,0.09460192800693938},
{0.9855266243613905,0.09040244225496671,-0.14340387410798924},
{0.9340095176054768,0.09310094870350095,-0.34490351458472046},
{0.8059562012854418,0.03820266396464062,-0.5907411938197177},
{0.7664132360708814,-0.10970189456807893,-0.6329109304661545},
{0.8233407357906298,0.04900242445492635,0.5654279752411298},
{0.9291702623816211,0.084397298907672,0.3598884819534497},
{0.9901455427916352,0.1010046458155289,0.09700446182283468},
{0.9824507645425398,0.11890614403919786,-0.14370742555452257},
{0.9316102384527812,0.12550137926773727,-0.3411037487507983},
{0.8196966474475679,0.10279957955057946,-0.5634976952991393},
{0.6952602399568979,-0.07080613490930433,0.715261972982125},
{0.7019042605717926,-0.019500118366077724,0.7120043218793507},
{0.7030890389273241,0.01739972874034339,0.7108889173281677},
{0.8217928791955526,0.07599934146855926,0.5646951069380975},
{0.9255064137816713,0.10700074151770808,0.36330251769517147},
{0.9877756219984698,0.11839707799617213,0.10139749754064066},
{0.9806116987673499,0.13430160222767193,-0.14270170244146524},
{0.9308253932630971,0.14280389574341457,-0.3364091773675396},
{0.8287681096167011,0.12959501327983164,-0.5443790526970705},
{0.5742091960339123,-0.09470151665693399,0.8132130237108629},
{0.5836203074219013,-0.044101534539591924,0.810828213258529},
{0.5860300406698468,-0.00880045112268712,0.8102415340455801},
{0.7053584731142937,0.04440368099571053,0.707458647215442},
{0.8222304847603442,0.10100374478325805,0.5601207668624043},
{0.9217216284517704,0.1303030575971202,0.36530857206621653},
{0.9854039810401252,0.13240053489924147,0.10700043228261963},
{0.9799439269710618,0.14030628937038472,-0.14150634316400165},
{0.9313260868090424,0.14900417366535737,-0.3323093081140822},
{0.8376262809368531,0.14180444918439084,-0.5275165510914398},
{0.5881215815174079,0.015200557794702602,0.8086296732102977},
{0.7111070791062089,0.06780067495907884,0.6998069666130291},
{0.8245948009461701,0.12909918603219808,0.5507965272388436},
{0.9174035732938769,0.15880061852961375,0.3649014212938039},
{0.9817323486138391,0.15050495922011078,0.11640383556957407},
{0.9799569812553108,0.14470841431538267,-0.13690796074482298},
{0.9328699574067748,0.14579530473781518,-0.3293893921854343},
{0.8467312534273567,0.14200524151019797,-0.5127189248047783},
{-0.5539082560640853,-0.15870236547638628,0.8173121821288626},
{-0.5742091960339123,-0.09470151665693399,0.8132130237108629},
{-0.5836203074219013,-0.044101534539591924,0.810828213258529},
{-0.46678751593482726,-0.10859709560951636,0.8776765268551797},
{-0.44901176875269055,-0.1673043851054012,0.8777230054214621},
{-0.5860300406698468,-0.00880045112268712,0.8102415340455801},
{-0.47480204165316864,-0.060600260581680755,0.8780037754243515},
{0.8274937648579725,0.16689874242271371,0.536095960532156},
{0.9109875878786722,0.19909728731794032,0.3611950787505778},
{0.9759467148075331,0.17610842963173132,0.1285061510941367},
{0.9799469699839339,0.15620748720429686,-0.12370592936729527},
{0.9362750267239576,0.1419113718138534,-0.321325748863926},
{0.8568560402176053,0.13100856824055357,-0.49863261163923667},
{0.5934972372767906,0.03449983940362136,0.8040962569406358},
{0.7208375277785697,0.09300484195811179,0.6868357576003352},
{0.6036488703725316,0.054804436872787826,0.7953643913308057},
{0.7338293904556434,0.1261050506084173,0.6675267349811147},
{-0.5881224725890246,0.0151005770040712,0.8086308983769518},
{-0.5934972372767906,0.03449983940362136,0.8040962569406358},
{-0.6036488703725316,0.054804436872787826,0.7953643913308057},
{-0.6190114270564162,0.08080149160930279,0.7812144213513285},
{-0.6400228460232406,0.10940390524209767,0.7605271475010537},
{-0.6663397583478081,0.132707918254171,0.7337437801287511},
{-0.5077032010787743,0.0619003902831911,0.8593054179377402},
{-0.5330508021622845,0.07580722477279768,0.8426803112606771},
{-0.5671219990890254,0.07800302579605708,0.8199318057716308},
{-0.6090286585178057,0.06050284702845197,0.7908372137206581},
{0.39911414286023283,-0.8296293984386097,0.39041383455934575},
{0.3462022485909069,-0.8469055006690903,0.4036026214075391},
{0.37101948645515637,-0.7786408952937593,0.5060265772137712},
{0.42232137422563804,-0.7593384310905208,0.4950250538519792},
{0.3933064129133442,-0.6853111740897911,0.6129099935789186},
{0.3797276565723789,-0.6865500032576722,0.6200451595335131},
{0.3593978184618629,-0.7712953182516273,0.5252968114580316},
{0.3381121401343412,-0.8413302085034643,0.42171514195401266},
{0.3265188782346835,-0.9074524658810161,0.2644152876117927},
{0.37778142683271343,-0.8869563938608174,0.265686937822795},
{0.5408033611033339,-0.7967049515366608,0.2698016768226322},
{0.56104611988666,-0.7344603751243548,0.38183138783017245},
{0.5792305262531215,-0.6514343314939284,0.49002582504148745},
{0.43992523043546894,-0.6548375560107867,0.6145352446069463},
{0.40330708011793776,-0.517009076173999,0.7550132543740219},
{0.3893103908329988,-0.554214792190208,0.7357196366191555},
{0.38651374274043904,-0.5690202318740227,0.7258258071953704},
{0.3830076889565345,-0.6734135189120896,0.6323126938047434},
{0.37010643065509946,-0.7510130489650897,0.5468095008976178},
{0.35862266387538805,-0.8238520649764213,0.43892773891496883},
{0.3234122559396627,-0.9096344712514445,0.2607098797880954},
{0.5835262884514554,-0.5289238285552267,0.6162277616860099},
{0.40670899040160036,-0.43170954304492465,0.8051177973256171},
{0.31010502064092654,-0.20600333522099604,0.9281150263039147},
{0.21930342664281213,-0.03250050782440217,0.9751152362946015},
{0.3176967690402882,-0.18639810434091827,0.9296905450952344},
{0.3644099339502011,-0.2854077803221388,0.8864241642520808},
{-0.3797276565723789,-0.6865500032576722,0.6200451595335131},
{-0.3593978184618629,-0.7712953182516273,0.5252968114580316},
{-0.37101948645515637,-0.7786408952937593,0.5060265772137712},
{-0.3933064129133442,-0.6853111740897911,0.6129099935789186},
{-0.42232137422563804,-0.7593384310905208,0.4950250538519792},
{-0.39911414286023283,-0.8296293984386097,0.39041383455934575},
{-0.3462022485909069,-0.8469055006690903,0.4036026214075391},
{-0.3381121401343412,-0.8413302085034643,0.42171514195401266},
{-0.37010643065509946,-0.7510130489650897,0.5468095008976178},
{-0.3830076889565345,-0.6734135189120896,0.6323126938047434},
{-0.38651374274043904,-0.5690202318740227,0.7258258071953704},
{-0.3893103908329988,-0.554214792190208,0.7357196366191555},
{-0.40330708011793776,-0.517009076173999,0.7550132543740219},
{-0.43992523043546894,-0.6548375560107867,0.6145352446069463},
{-0.5792305262531215,-0.6514343314939284,0.49002582504148745},
{-0.56104611988666,-0.7344603751243548,0.38183138783017245},
{-0.5408033611033339,-0.7967049515366608,0.2698016768226322},
{-0.37778142683271343,-0.8869563938608174,0.265686937822795},
{-0.3265188782346835,-0.9074524658810161,0.2644152876117927},
{-0.3234122559396627,-0.9096344712514445,0.2607098797880954},
{-0.35862266387538805,-0.8238520649764213,0.43892773891496883},
{-0.3969197551878358,-0.7218359266681277,0.5669282167195366},
{-0.399514620505061,-0.648023714861776,0.6484237295005795},
{-0.39650256537989703,-0.5620036361752891,0.7259046966185807},
{-0.3802142031668439,-0.4646173561055121,0.7997298744674515},
{-0.3714125873858834,-0.44011491574724626,0.8175277064834671},
{-0.3729199983711334,-0.38252051321254626,0.8453453328589945},
{-0.3644099339502011,-0.2854077803221388,0.8864241642520808},
{-0.40670899040160036,-0.43170954304492465,0.8051177973256171},
{-0.5835262884514554,-0.5289238285552267,0.6162277616860099},
{-0.7964405159595965,-0.4871247806679049,0.3583182281119079},
{-0.8076165724621021,-0.5274108225811202,0.2638054133426232},
{-0.8060184016101656,-0.569713006696416,0.16050366434048582},
{-0.5278981338833951,-0.8370970408671907,0.14349949273018978},
{-0.3674952722037345,-0.9227881284070917,0.11579851026174817},
{-0.3164030058428334,-0.9448089757279043,0.08500080751150707},
{-0.31350852598029766,-0.9480257819117134,0.054401479468351485},
{-0.35491155078438347,-0.8999292886753076,0.25330824405095614},
{-0.3995070193999969,-0.798114022986577,0.451007924278845},
{-0.4384015738644753,-0.6865024645482717,0.5801020825702147},
{-0.4288233779436903,-0.6128334095240051,0.6637361845644292},
{-0.41801942790437824,-0.5356248937454187,0.7337341010847903},
{-0.3994221925135412,-0.45542530413286597,0.7956442072202639},
{-0.3801192535277991,-0.39502000827014117,0.8363423618134659},
{-0.3565076239970596,-0.38930832544756044,0.8493181628631213},
{-0.3419025403453122,-0.33680250245188986,0.8773065184116479},
{-0.335710303107306,-0.24580754394928747,0.9093279077017377},
{-0.30539223550111727,-0.14399633893962308,0.941276068360189},
{-0.2910022567312514,-0.04820037379534818,0.9555074099886968},
{-0.3176967690402882,-0.18639810434091827,0.9296905450952344},
{-0.21930342664281213,-0.03250050782440217,0.9751152362946015},
{-0.31010502064092654,-0.20600333522099604,0.9281150263039147},
{0.3995070193999969,-0.798114022986577,0.451007924278845},
{0.4549190205618829,-0.7669320661000395,0.45261892439285156},
{0.4384015738644753,-0.6865024645482717,0.5801020825702147},
{0.3969197551878358,-0.7218359266681277,0.5669282167195366},
{0.4288233779436903,-0.6128334095240051,0.6637361845644292},
{0.47271193849076176,-0.5686143605370153,0.6732170023100927},
{0.4960898377037608,-0.6439868080653537,0.5823880699025807},
{0.524401295272799,-0.7277017974256595,0.44210109199104586},
{0.4745943974462071,-0.8501899635667198,0.22789730968813862},
{0.40969757050061034,-0.8790947869833696,0.2435985554648491},
{0.35491155078438347,-0.8999292886753076,0.25330824405095614},
{0.399514620505061,-0.648023714861776,0.6484237295005795},
{0.41801942790437824,-0.5356248937454187,0.7337341010847903},
{0.4493934995700427,-0.4938928558915089,0.7443892324876275},
{0.49190715976081584,-0.4408064159840773,0.750810928132589},
{0.5321121030274266,-0.514111693603458,0.6727153010835367},
{0.5682071480908847,-0.5902074248561072,0.5734072135081192},
{0.6002074306139867,-0.6772083838916892,0.425605269025846},
{0.6140846542162343,-0.765880860876427,0.19059523708453713},
{0.5453211070619312,-0.8119314264140508,0.20830806271960436},
{0.39650256537989703,-0.5620036361752891,0.7259046966185807},
{0.3802142031668439,-0.4646173561055121,0.7997298744674515},
{0.3994221925135412,-0.45542530413286597,0.7956442072202639},
{-0.47271193849076176,-0.5686143605370153,0.6732170023100927},
{-0.4960898377037608,-0.6439868080653537,0.5823880699025807},
{-0.4493934995700427,-0.4938928558915089,0.7443892324876275},
{-0.422500376025502,-0.4211003747795003,0.8026007143149536},
{-0.40140958376822006,-0.36730876960156267,0.8390200318423933},
{-0.39711102196937426,-0.3562098867426117,0.8458234761563755},
{-0.3694924827519068,-0.38399218775840926,0.8461827845863695},
{-0.3332998833450612,-0.3729998694500685,0.8658996969351591},
{-0.3049973312850268,-0.30529732866006126,0.902092106728599},
{-0.29069193777090735,-0.19529458357983556,0.9366740217062569},
{-0.26629640635424423,-0.09409873014620497,0.9592870545085487},
{-0.2575077420866505,-0.02590077871861844,0.9659290410931872},
{-0.1891073403438759,0.025000970431501315,0.9816381030224676},
{-0.19321328483611408,0.03400233791111738,0.9805674212308998},
{-0.010399832512046079,0.08779858601515825,0.9960839581970287},
{0.044902695365186374,0.021501290653708392,0.9987599523655152},
{0.13759820985893453,-0.034499551163759024,0.9898871216523204},
{-0.07100207187068622,-0.12800373520349065,0.9892288661194761},
{-0.4123969956988294,-0.11199918408891585,0.9040934137034716},
{-0.5321121030274266,-0.514111693603458,0.6727153010835367},
{-0.5682071480908847,-0.5902074248561072,0.5734072135081192},
{-0.49190715976081584,-0.4408064159840773,0.750810928132589},
{-0.4496995570461545,-0.37379963180754405,0.8111992009691806},
{-0.41952361564900603,-0.3266183858664252,0.8469476760265631},
{-0.4136097571692588,-0.31690747593553703,0.8535201347774719},
{-0.4412261478363041,-0.36402157255760353,0.8202486093729299},
{-0.4159990161634901,-0.40879903319142974,0.8122980789173151},
{-0.3710147203010477,-0.44431762865163205,0.8154323529204159},
{-0.3116125629137159,-0.4441179049742659,0.8400338666480147},
{-0.2581099245174002,-0.3890149579127032,0.8843340032961526},
{-0.22700423366843725,-0.2887053844056292,0.9301173468502797},
{-0.20581640833813514,-0.1964156588805138,0.9586764287314691},
{-0.19280264430640012,-0.1283017596707009,0.9728133422264836},
{-0.14890669350631305,-0.08080363220490325,0.9855443012120316},
{-0.04989858739098616,-0.05059856757482765,0.9974717619741222},
{-0.06930031704967575,0.06300028822697797,0.9956045549012581},
{-0.04450134284828098,0.09760294521330841,0.9942300013429427},
{-0.4549190205618829,-0.7669320661000395,0.45261892439285156},
{-0.524401295272799,-0.7277017974256595,0.44210109199104586},
{-0.6002074306139867,-0.6772083838916892,0.425605269025846},
{-0.6355800780546752,-0.5317833315127065,0.5596824570283223},
{-0.591112706104178,-0.4602098923179542,0.6624142387470944},
{-0.5372344888750555,-0.3936252695852976,0.745947887661772},
{-0.4805941415931208,-0.3338959298334228,0.8108901153097412},
{-0.4394121191533717,-0.29280807575809564,0.8492234219049686},
{-0.42703410003438597,-0.2831226082429384,0.858768575408729},
{-0.45501564143151596,-0.3225110865091514,0.8300285327212268},
{-0.4937279235723488,-0.37282108549275195,0.78564443337743},
{-0.4751329611168087,-0.42302934656369195,0.7715535245245587},
{-0.4367199782123654,-0.47312164344463037,0.7651350019012613},
{-0.37181651273800426,-0.5165229392931123,0.7713342557149614},
{-0.2876990016861963,-0.5341981463356483,0.794897241711357},
{-0.20490040467869886,-0.5110010092279899,0.8348016487348844},
{-0.1482979275509436,-0.44949371836917834,0.8808876896805544},
{-0.11790287332803494,-0.3781092146338423,0.9182223773520074},
{-0.08630194656235732,-0.3172071546880619,0.9444213016626912},
{-0.043898195382280986,-0.26748900375307894,0.9625604299540701},
{0.03600107248792436,-0.22310664644599792,0.9741290197357533},
{0.033599663837044956,-0.04569954277836174,0.9983900111579073},
{0.01769980583419499,0.06559928037984132,0.9976890554110929},
{0.05269985586609131,0.11729967918581614,0.9916972877116271},
{-0.4745943974462071,-0.8501899635667198,0.22789730968813862},
{-0.5453211070619312,-0.8119314264140508,0.20830806271960436},
{-0.6140846542162343,-0.765880860876427,0.19059523708453713},
{-0.6707191526588601,-0.6166176077671883,0.4122117708751784},
{-0.6837084677818105,-0.4765059015621365,0.5527068453166691},
{-0.6331389740691101,-0.41522555999604255,0.6532402114388608},
{-0.5717925210027376,-0.35959529652428196,0.7373903549972346},
{-0.5061149331414068,-0.30870910859662565,0.8053237614281266},
{-0.4562173069318139,-0.27121028855744833,0.847532151742026},
{-0.4365065280039398,-0.25700384352122,0.8622128944902564},
{-0.46139150124681977,-0.2831947836001287,0.8407845128919074},
{-0.5002207070647623,-0.31991324308280183,0.8046333084852214},
{-0.5143141284031635,-0.31810873856707433,0.7964218780094876},
{-0.5100902599194794,-0.38069273074170906,0.7712852724483326},
{-0.4889971027007497,-0.43739740842803254,0.754695528442241},
{-0.4425143974401349,-0.4888159038841535,0.7518244610067647},
{-0.3675079474452962,-0.5333115329866026,0.7619164766219624},
{-0.272221106120568,-0.5607434761271215,0.7819606277577963},
{-0.17351015931725072,-0.564133030955972,0.8072472657111516},
{-0.09479856191672349,-0.5470917006818505,0.83168738339809},
{-0.038999910300309464,-0.5197988044641246,0.8533980371867718},
{0.010700034079662815,-0.48670155014690586,0.8735027821107916},
{0.07270026971850098,-0.44050163426409467,0.8948033197264743},
{0.14550332769915714,-0.37600859941500403,0.9151209290549739},
{0.21900499775107368,-0.297006777772004,0.9294212096340085},
{0.11830566875193063,-0.18680895116534776,0.9752467300666335},
{0.09910102619643942,-0.05020051982907426,0.9938102909588447},
{0.07490405354253915,0.047602576083109,0.9960539029154739},
{0.0967054654638254,0.1002056632830952,0.9902559658974138},
{-0.40969757050061034,-0.8790947869833696,0.2435985554648491},
{-0.40822585580339193,-0.9128578176808823,0.0065004117166145205},
{-0.47150619091693036,-0.8818115782620345,-0.009500124737456709},
{-0.5347130525049194,-0.8447206198820001,-0.023000561450557594},
{-0.5935134283932277,-0.8041181933799401,-0.03370076248837704},
{0.6707191526588601,-0.6166176077671883,0.4122117708751784},
{0.7264318329403946,-0.5518241814654593,0.4096179498518524},
{0.6837084677818105,-0.4765059015621365,0.5527068453166691},
{0.6355800780546752,-0.5317833315127065,0.5596824570283223},
{0.6331389740691101,-0.41522555999604255,0.6532402114388608},
{0.658079580107439,-0.37818826500020275,0.6510797973073296},
{0.7127530129768336,-0.4270317616684551,0.5564413868672796},
{0.7677981956763602,-0.48649885672903,0.41689902028845344},
{0.7497028976072989,-0.6373024631787803,0.17830068913349525},
{0.6819384521837202,-0.7091399859854465,0.1791100994076907},
{0.801357046631869,-0.4163296374801536,0.4295305772224981},
{0.7261084592128251,-0.38820452260903276,0.567506611490536},
{0.8812091249677338,-0.433604489997741,0.1883019498767865},
{0.8152822881846817,-0.5493880646739411,0.18299602445455262},
{0.7309222971247659,-0.6807207657036914,-0.0487014856614805},
{0.8166153933452481,-0.5743108258611022,-0.05750108390564753},
{0.904129990489185,-0.4217139884850009,-0.06860227557522186},
{0.8998344913170909,-0.39731522938461905,-0.18010690362992673},
{0.8084137593192765,-0.5688096812231623,-0.1514025768937883},
{0.8257061845624837,-0.5537041472595945,-0.10780080743107151},
{0.9154214714624227,-0.37480879124329913,-0.1467034409695624},
{0.8530586660437309,-0.5216747228636907,0.012099413737110707},
{0.9374517862670497,-0.3470191698684299,-0.02760152475034198},
{0.8764860026303061,-0.46869251504030174,0.10999824334208064},
{0.8031126852650464,-0.5786091392035311,0.1422022461022159},
{0.7739592836818374,-0.6316483829609103,0.04480343185029889},
{0.7278581399909904,-0.665053123239913,0.1671133487118638},
{0.6995321162567029,-0.7112326534406964,0.0693031817821151},
{0.593092180131157,-0.333995596297094,0.7325903408600332},
{0.5717925210027376,-0.35959529652428196,0.7373903549972346},
{0.5963852187755266,-0.3180921161845993,0.7369817341340763},
{0.6612071377695785,-0.35590384200271175,0.6604071291334387},
{0.7276200753148208,-0.35410977002333427,0.5875162097958455},
{0.8219104958640487,-0.3514044874639576,0.44830572490066073},
{0.9285438375893833,-0.3138148155471712,0.198309362406004},
{0.9653136061911696,-0.2496035181863834,-0.0766010796998276},
{0.591112706104178,-0.4602098923179542,0.6624142387470944},
{0.5372344888750555,-0.3936252695852976,0.745947887661772},
{0.4805941415931208,-0.3338959298334228,0.8108901153097412},
{0.5061149331414068,-0.30870910859662565,0.8053237614281266},
{-0.658079580107439,-0.37818826500020275,0.6510797973073296},
{-0.7127530129768336,-0.4270317616684551,0.5564413868672796},
{-0.593092180131157,-0.333995596297094,0.7325903408600332},
{-0.5226367923120377,-0.29072046598758017,0.8014564205106527},
{-0.46602453217707773,-0.2536133505581693,0.8476446211873199},
{-0.4392191306058594,-0.23151008364129427,0.8680378082101228},
{-0.45958546583946064,-0.24219234078833196,0.8544729777193628},
{-0.49649213314447493,-0.26379582018834336,0.8269868964964366},
{-0.5055067485601402,-0.2536033856277974,0.8247110099654751},
{-0.4700101288274155,-0.19470419592063365,0.8609185529947277},
{-0.4897111312605218,-0.25870588045149473,0.8326189256432722},
{-0.49430212303217763,-0.3266014027560373,0.8056034600742915},
{-0.4772036172171278,-0.38900294865352625,0.7880059731079143},
{-0.43131317466213315,-0.44091346790756897,0.787124043071099},
{-0.35909932309841397,-0.4829990895475743,0.7985984946432565},
{-0.2697065984526477,-0.5133125583453617,0.814719932366971},
{-0.17539996404301106,-0.5328998907555337,0.8277998303010522},
{-0.09140562527527449,-0.5486337639607831,0.8310511444611935},
{-0.018900271315342113,-0.5592080274888523,0.8288118976801874},
{0.0508024807457037,-0.5567271856522293,0.8291404879185618},
{0.13049992104757166,-0.5185996862472847,0.8449994887754639},
{0.205701478998951,-0.4328031118655615,0.8777063107310613},
{0.26299865213536167,-0.3210983543751507,0.9097953373108444},
{0.2807017361456071,-0.23050142565572654,0.9317057626179627},
{0.2675155618328609,-0.23461364787285668,0.93455436460863},
{0.18021358771568805,-0.15911199670125398,0.9706731866639667},
{0.12329837062279826,-0.08769884106747289,0.9884869372314362},
{0.08119778170690523,-0.01579956836168846,0.9965727740037162},
{0.07920337017510296,0.025101068073170252,0.9965424037814405},
{0.07840187029892424,0.03730088982334023,0.9962237652013818},
{0.12860222869593513,0.11230194620959187,0.985317075692884},
{0.1516087313982691,0.08050463639551887,0.9851567368102564},
{0.0,0.04220038719032872,0.9991091668686592},
{0.0,0.03690069927487696,0.9993189372732937},
{0.16750406202275667,0.029700720251199242,0.9854238968192502},
{0.1641046721265241,0.08080230047424221,0.9831279900523208},
{0.21591480578586655,0.009400644624303593,0.9763669517774038},
{0.10130230262750839,0.12380281406994607,0.9871224375480111},
{-0.6612071377695785,-0.35590384200271175,0.6604071291334387},
{-0.7261084592128251,-0.38820452260903276,0.567506611490536},
{-0.5963852187755266,-0.3180921161845993,0.7369817341340763},
{-0.5230220719971673,-0.2782117407831968,0.8056339984721184},
{-0.4609081005310509,-0.23700416538481028,0.8552150305362437},
{-0.42772623325435294,-0.20371249407040376,0.8806540121669002},
{-0.44579821458172586,-0.1973992094177494,0.8730965032555066},
{-0.48342525237760414,-0.20541072990972256,0.8509444502443181},
{-0.4894997993051234,-0.19289992091104863,0.8503996513362144},
{-0.4455183490510663,-0.14570600102523087,0.88333638095804},
{-0.311696131875005,-0.04119948871751751,0.9492882194062955},
{-0.34738934746898725,-0.05559829510442053,0.9360712958138141},
{-0.38050762925445064,-0.09660193688825212,0.9197184405396012},
{-0.4009029446429426,-0.15150111277976006,0.9035066362806153},
{-0.39960587225143945,-0.20870306691410262,0.8926131170461332},
{-0.3724069845584937,-0.25720482392170935,0.891716724303998},
{-0.3259071602589672,-0.2934064462104356,0.8987197450897018},
{-0.26889590474655584,-0.3184951493558127,0.9089861562462599},
{-0.21041111736508675,-0.3371178120901651,0.9176484852386102},
{-0.1570050148202613,-0.3554113520198781,0.9214294309260431},
{-0.10439878480521726,-0.3693957002590733,0.923389251811663},
{-0.05140230750137677,-0.3651163904426587,0.9295417280647803},
{0.012300075092187657,-0.31950195056536235,0.947505784540472},
{0.20471499182779743,-0.4317316168639968,0.8784643322986676},
{0.09250091900119543,-0.12520124388053697,0.9878098139392524},
{0.06940370070398494,-0.05160275153206949,0.9962531216327059},
{0.2651130292999953,-0.17530861575363701,0.9481465978096022},
{0.2813076769912591,-0.20380556192967864,0.9377255908805675},
{0.20599990730006257,-0.16169992723504914,0.9650995657052932},
{0.12110683364588815,-0.1325074769453359,0.9837555099707693},
{0.062299775098217845,-0.09319966354982188,0.9936964127624249},
{0.039600924692387476,-0.07330171161494954,0.9965232690900031},
{0.024800394825428455,-0.06440102527248356,0.9976158821712672},
{0.0,-0.065198192405173,0.997872334373039},
{-0.07840187029892424,0.03730088982334023,0.9962237652013818},
{-0.1516087313982691,0.08050463639551887,0.9851567368102564},
{-0.16750406202275667,0.029700720251199242,0.9854238968192502},
{0.0,0.012500273383968395,0.9999218685303998},
{0.15119819016849548,-0.005499934166182044,0.9884881678674456},
{0.2193016809538268,-0.05130039321902104,0.9743074680953646},
{-0.7264318329403946,-0.5518241814654593,0.4096179498518524},
{-0.7677981956763602,-0.48649885672903,0.41689902028845344},
{-0.801357046631869,-0.4163296374801536,0.4295305772224981},
{-0.8219104958640487,-0.3514044874639576,0.44830572490066073},
{-0.7276200753148208,-0.35410977002333427,0.5875162097958455},
{-0.6470154315020642,-0.33870807828400173,0.6831162925178671},
{-0.5766036643279303,-0.3103019719752979,0.7558048031547862},
{-0.49801962983057224,-0.2719107175721538,0.823432456229906},
{-0.4301972639541019,-0.22519856774166375,0.874194440141041},
{-0.39339094031096583,-0.18049584322859513,0.9014792391721801},
{-0.41551991634689717,-0.15750754951777693,0.8958429387811083},
{-0.4619214844678755,-0.15290711187516381,0.873640633970851},
{-0.47331982778288745,-0.142205957132319,0.8693364172652948},
{-0.4285951719025827,-0.11309872595002825,0.8963899022246269},
{-0.2848930871531093,-0.04759884502803792,0.9573767695345274},
{-0.06829839022591333,0.04439895352899784,0.9966765086115348},
{-0.11049912595537052,0.09739922957514108,0.9890921763118279},
{-0.15250328419358805,0.12920278241187919,0.9798211006746069},
{-0.18700520816757218,0.13290370141962748,0.9733271075374226},
{-0.21271196857562735,0.11970673548896377,0.9697545647756739},
{-0.22769941936722096,0.09589975545593539,0.9689975290594515},
{-0.23400784758475535,0.06830229055572133,0.9698325238790416},
{-0.23720311093920005,0.04720061904017809,0.9703127257348475},
{-0.238703557903046,0.03350049932866377,0.970514465625916},
{-0.24190466154774248,0.027200524159150866,0.9699186905132511},
{-0.24379234016500612,0.029799063728126265,0.9693695428874363},
{-0.23849654421011143,0.04079940882084925,0.9702859406585792},
{-0.22891123867315077,0.06540321104947165,0.9712476845756401},
{-0.21220506221213933,0.1108026432285817,0.970923161648285},
{-0.2011008949009735,0.1683007489399992,0.9650042942786643},
{-0.08940664226619009,0.006500482938816953,0.9959739936565852},
{-0.21521532387660947,0.20841483966489505,0.9540679320552297},
{-0.2663072090337241,0.2149058175792239,0.9396254360048336},
{-0.7497028976072989,-0.6373024631787803,0.17830068913349525},
{-0.8152822881846817,-0.5493880646739411,0.18299602445455262},
{-0.8812091249677338,-0.433604489997741,0.1883019498767865},
{-0.9285438375893833,-0.3138148155471712,0.198309362406004},
{-0.9602262289376701,-0.18870515455169584,0.2058056216573344},
{-0.8387534764326393,-0.2786177638418187,0.46782982744150314},
{-0.9770219343886433,-0.027900626376093293,0.21130474384474954},
{-0.8559244712304537,-0.17240492912738664,0.4875139382227435},
{-0.7244900564422124,-0.3155956684791749,0.6127915894931508},
{-0.7243081883503542,-0.25670290204271146,0.639907234192174},
{-0.8600269536670985,0.025400796073423607,0.5096159716148296},
{-0.7282751480346028,-0.134395413834753,0.6719770691737651},
{-0.7978948695524832,0.3097980080052128,0.5170966750790689},
{-0.7104637101374601,0.07650686067780926,0.6995627326029749},
{-0.6819384521837202,-0.7091399859854465,0.1791100994076907},
{0.8387534764326393,-0.2786177638418187,0.46782982744150314},
{0.7244900564422124,-0.3155956684791749,0.6127915894931508},
{0.9602262289376701,-0.18870515455169584,0.2058056216573344},
{0.9931441313399859,-0.0796035372617691,-0.08560380388954063},
{0.9705676412159566,-0.010100703942587493,-0.24061676916698524},
{0.9560561556074978,-0.20271190663351443,-0.21181244116910883},
{0.9634685724985439,-0.18131290449863607,-0.19711402910469483},
{0.9825252020946548,-0.16390420419675716,-0.08820226241704687},
{0.9922307745147148,-0.12230379331097523,0.022800707174899716},
{0.9516272359612454,-0.29780852340191144,0.07560216376489087},
{0.9050266896306217,-0.39991179357269124,0.14490427329002992},
{0.8327786728112805,-0.5232865988018048,0.18069537245076656},
{0.7547274952234856,-0.6224226752710976,0.20730755235170076},
{0.6581293762603286,-0.72143220184501,0.21540961502275457},
{0.646399376224903,-0.742399283585037,0.17609983006374602},
{0.8559244712304537,-0.17240492912738664,0.4875139382227435},
{0.7243081883503542,-0.25670290204271146,0.639907234192174},
{0.9770219343886433,-0.027900626376093293,0.21130474384474954},
{0.9892038677946846,0.11350044378760282,-0.09270036245912583},
{0.9452967198260734,0.19339932890549305,-0.2626990884357447},
{0.9244373618909866,0.2341094617250973,-0.30101216565251726},
{0.9674834223135869,0.022899607618585158,-0.2518956838044367},
{0.9853273382862564,0.04690130129465688,-0.16410455314399136},
{0.9947284794840573,0.08930255676880096,-0.05040144301397053},
{0.989047376504029,0.1424068214501251,0.038801858653545324},
{0.9939214838450624,-0.06340137043543309,0.09000194541307538},
{0.9631370381469666,-0.24280933741260874,0.11580445334588177},
{0.970153078526929,-0.19391060913964697,0.14560796642977103},
{0.9275089273163885,-0.33730324655937227,0.16110155060988698},
{0.8636119092903443,-0.4705064883292113,0.18110249742065926},
{0.7849270412023622,-0.5830200853879183,0.20970722453833016},
{0.6655173768855688,-0.7128186119369397,0.22130577836931084},
{0.8600269536670985,0.025400796073423607,0.5096159716148296},
{0.7282751480346028,-0.134395413834753,0.6719770691737651},
{0.9500547009741582,0.22311284609193127,0.21821256395006458},
{0.9245458817278495,0.37011836757974803,-0.09070450132256998},
{0.8601121878760539,0.43580617541725886,-0.2651037565468456},
{0.8248129620375484,0.46530731236187106,-0.321205047776989},
{0.8194912069065247,0.4919947209249666,-0.2938968465037554},
{0.9317923686517511,0.2682978026499944,-0.24449799756959983},
{0.9396132862258015,0.31300442591387384,-0.13840195701750843},
{0.9346566372349518,0.35462148894020323,-0.025701557433060414},
{0.9279425239405117,0.36131655771064436,0.0915041932757375},
{0.9778514167792769,0.17380913912480908,0.11660613131158078},
{0.9906474333346893,-0.013200632061395011,0.13580650257101837},
{0.9861929734000966,0.01409989953857368,0.16499882438756433},
{0.9788667044153143,-0.1460950306620466,0.1430951327018403},
{0.9471946862527152,-0.2936983523568649,0.12869927799907566},
{0.8961210322074418,-0.422809923465357,0.13490316621446702},
{0.826294972010393,-0.5391967189979473,0.16279900937104197},
{0.6832517309468991,-0.709753737489775,0.17151298573974413},
{0.6263372462518054,-0.323319226749495,0.7093421822870919},
{0.6083894354091804,-0.3008947750075976,0.7343872474761705},
{0.6023115976214694,-0.24660474842014668,0.7592146188182294},
{0.7104637101374601,0.07650686067780926,0.6995627326029749},
{0.7978948695524832,0.3097980080052128,0.5170966750790689},
{0.8220581626725864,0.5261372255256055,0.2177154039097592},
{0.7595982339361591,0.6456984987527356,-0.07799981865063245},
{0.6932940272976823,0.6796941444601682,-0.23949793673416253},
{0.5042909757937315,-0.3122944115415077,0.8050855931222154},
{0.5426277154183655,-0.30781572208951885,0.781539918170757},
{0.4764131777707482,-0.31560872985820343,0.8206226987377749},
{0.5988931696623497,-0.12639855843266157,0.7907909810802908},
{0.6404062343850377,0.31290304612598113,0.7014068282287094},
{0.6628941466705273,0.5634950243609023,0.4929956468676571},
{0.6311035184119227,0.7492041768249287,0.2010011205843709},
{0.5606153022035133,0.825622535674671,-0.06370173876268963},
{0.6470154315020642,-0.33870807828400173,0.6831162925178671},
{0.5766036643279303,-0.3103019719752979,0.7558048031547862},
{0.49801962983057224,-0.2719107175721538,0.823432456229906},
{0.5230220719971673,-0.2782117407831968,0.8056339984721184},
{0.5226367923120377,-0.29072046598758017,0.8014564205106527},
{-0.6263372462518054,-0.323319226749495,0.7093421822870919},
{-0.6083894354091804,-0.3008947750075976,0.7343872474761705},
{-0.5042909757937315,-0.3122944115415077,0.8050855931222154},
{-0.5426277154183655,-0.30781572208951885,0.781539918170757},
{-0.6023115976214694,-0.24660474842014668,0.7592146188182294},
{-0.4764131777707482,-0.31560872985820343,0.8206226987377749},
{-0.3519917634891004,-0.32819232038955326,0.8765794882799586},
{-0.39992325021399644,-0.2924170001564705,0.8686505004648095},
{-0.45340659257978455,-0.2744039898630191,0.8480123301889221},
{-0.9500547009741582,0.22311284609193127,0.21821256395006458},
{-0.7890100796681521,0.5896075322843377,0.172702206284778},
{0.5458060748554199,0.708907890188727,0.44670497185400526},
{0.5605875382775346,0.48928912322368473,0.668085148632217},
{0.4972990103759541,0.8494983095000462,0.17619964936304666},
{0.5091256860388074,0.7602383549925384,0.4035203581156134},
{0.5232169263413552,0.5809187930269365,0.623520171203813},
{0.46678476206015973,0.8710715643329159,0.15279501208824423},
{0.5684007474474744,0.04350005720261283,0.8216010804061311},
{0.5217253095086613,0.20530995982773273,0.8280401692029355},
{0.48791427414088806,0.3182093093495195,0.8128237795075093},
{0.5173039987753659,0.6154047570971586,0.5947045970843033},
{0.4693082387784483,0.37720662192037224,0.7984140162810848},
{0.3571204939475846,-0.04110235872653522,0.9331535505530418},
{0.3284873304879899,0.009199645176528179,0.9444635727424853},
{0.46171331138665367,0.39721145177123424,0.7931228660618476},
{0.31501706651187994,0.03470188002527694,0.9484513837456093},
{0.4605874698883202,0.39338929798972033,0.7956783538648206},
{0.3069892171931158,0.04669835974892022,0.9505666119341234},
{0.4655284469849061,0.37352282480958626,0.8023490290354246},
{0.5512061900802722,0.5801065146327391,0.599706734744447},
{0.5323128262320739,0.6086146647470227,0.5884141780104308},
{0.5877387832232087,0.7107469001816138,0.3865255057270209},
{0.5564164117441002,0.7426219039560905,0.3727109932728722},
{0.5865405606822053,0.7963550698571867,0.1476102075987954},
{0.5444263399835081,0.8278400518705877,0.1352065414507169},
{0.43841609016576905,-0.2052075312545981,0.8750321142679013},
{0.3971092547390238,-0.11670271978857738,0.9103212152831363},
{0.46430247473878555,-0.2846015169301279,0.8387044703067401},
{-0.5605875382775346,0.48928912322368473,0.668085148632217},
{-0.6404062343850377,0.31290304612598113,0.7014068282287094},
{-0.5684007474474744,0.04350005720261283,0.8216010804061311},
{-0.5217253095086613,0.20530995982773273,0.8280401692029355},
{-0.5232169263413552,0.5809187930269365,0.623520171203813},
{-0.48791427414088806,0.3182093093495195,0.8128237795075093},
{-0.3971092547390238,-0.11670271978857738,0.9103212152831363},
{-0.3571204939475846,-0.04110235872653522,0.9331535505530418},
{-0.4693082387784483,0.37720662192037224,0.7984140162810848},
{-0.3284873304879899,0.009199645176528179,0.9444635727424853},
{-0.46171331138665367,0.39721145177123424,0.7931228660618476},
{-0.31501706651187994,0.03470188002527694,0.9484513837456093},
{-0.4605874698883202,0.39338929798972033,0.7956783538648206},
{-0.3069892171931158,0.04669835974892022,0.9505666119341234},
{-0.4655284469849061,0.37352282480958626,0.8023490290354246},
{-0.3046159181207129,0.04830252411434812,0.9512497088523382},
{-0.305611397989636,0.048201797719569554,0.9509354657995578},
{-0.4668146021891383,0.3576111862528617,0.8088253004511033},
{-0.29740617421626575,0.05040104633658303,0.9534197932003624},
{-0.4504179450084008,0.3540141042028727,0.8196326548154647},
{-0.27761682964233486,0.05600339502871308,0.9590581398667114},
{-0.40241026762896953,0.3639092852638718,0.8400214334203141},
{-0.24140765998657898,0.06370202129720416,0.9683307256213938},
{-0.31212491948771065,0.3824305325603991,0.8696694328308657},
{-0.18929678766076988,0.06769885116024363,0.9795833766111472},
{-0.18300950484545764,0.3948205055354463,0.9003467607233088},
{-0.12840302970522927,0.06600155732511785,0.9895233480788502},
{-0.03330128312315858,0.3878149427976245,0.9211354920342754},
{0.11960938192982191,0.3576280516563906,0.9261726472007366},
{-0.06740377303179614,0.05770323002870382,0.9960557557814385},
{0.26179998298300167,0.311999979720002,0.9132999406355058},
{-0.008000403150472384,0.04510227276078807,0.9989503383758581},
{0.3677250190227828,0.2720185074087488,0.8892605028965419},
{0.03909909955810565,0.033399230824571066,0.9986770007335067},
{0.43861761304388475,0.25331017187418153,0.8622346237264875},
{0.0812999272365977,0.02789997502953353,0.9962991083126972},
{0.48370744189624076,0.2535039001875068,0.8377128883119307},
{0.11930514574190616,0.0250010783197624,0.9925428092945672},
{0.4977131547325216,0.2731072183191715,0.8232217580386012},
{0.362020400424362,0.17730999169955633,0.9151515702440157},
{-0.43841609016576905,-0.2052075312545981,0.8750321142679013},
{-0.27211430950720805,-0.37791987343908096,0.8849465361371863},
{-0.3116107538726774,-0.365912627862685,0.8769302633855931},
{-0.46430247473878555,-0.2846015169301279,0.8387044703067401},
{-0.5988931696623497,-0.12639855843266157,0.7907909810802908},
{-0.5458060748554199,0.708907890188727,0.44670497185400526},
{-0.6628941466705273,0.5634950243609023,0.4929956468676571},
{-0.5091256860388074,0.7602383549925384,0.4035203581156134},
{-0.5176173792952696,0.7678257801833618,0.3775126752008584},
{-0.5173039987753659,0.6154047570971586,0.5947045970843033},
{-0.5212943335613911,0.6216932422311852,0.5845936455016099},
{-0.5323128262320739,0.6086146647470227,0.5884141780104308},
{-0.5512061900802722,0.5801065146327391,0.599706734744447},
{-0.5588360656492826,0.5570359494750365,0.6143396476885367},
{-0.5395001240850428,0.5560001278800442,0.6323001454290501},
{-0.47612641146458623,0.5832323527959393,0.6581365078446633},
{-0.3511008654647001,0.6269015453142138,0.695501714413839},
{-0.1620108348368817,0.6600441419280365,0.7335490577336587},
{0.058301382050642454,0.653915501250688,0.7543178813173175},
{0.28059905017382275,0.5995979703643055,0.7494974629553819},
{0.4734935344899295,0.5108930238033896,0.717490202738172},
{0.6030529986263813,0.4300377933819966,0.6718590455675006},
{-0.4972990103759541,0.8494983095000462,0.17619964936304666},
{-0.6311035184119227,0.7492041768249287,0.2010011205843709},
{-0.46678476206015973,0.8710715643329159,0.15279501208824423},
{-0.4865800117036703,0.8627645583598988,0.13739435595578361},
{-0.5117916860115906,0.8489862083310676,0.1314978638345529},
{-0.5335007735766825,0.7614011040324012,0.36830053403616153},
{-0.5564164117441002,0.7426219039560905,0.3727109932728722},
{-0.5877387832232087,0.7107469001816138,0.3865255057270209},
{-0.6055216508136942,0.6868245578511067,0.40201437428093323},
{-0.5860386505235451,0.6939457672325733,0.41832758961433264},
{-0.5140325984108751,0.7359466715380604,0.44062794330706534},
{-0.362715841960354,0.8050351606784807,0.46942050238817246},
{-0.13081027882150345,0.8589674960228542,0.49503889920981814},
{0.13910920168247798,0.8517563412866032,0.5051334131547062},
{0.4031133553666986,0.7718255710047581,0.49171629083057733},
{0.6177754470027788,0.6415745011281689,0.45468192902583926},
{-0.5606153022035133,0.825622535674671,-0.06370173876268963},
{-0.4368213501652468,0.8976438734164961,-0.05850285939713127},
{-0.41331351763964524,0.9083297074088792,-0.06410209649334929},
{-0.4363947196558381,0.8967891489169468,-0.07299911671603157},
{-0.46163160899843925,0.882960458372448,-0.08530584109091609},
{-0.49409536046634783,0.8633918927881901,-0.10209904129450337},
{-0.5444263399835081,0.8278400518705877,0.1352065414507169},
{-0.5865405606822053,0.7963550698571867,0.1476102075987954},
{-0.6123162082245504,0.7739204859463981,0.16160427772184768},
{-0.5942155270545856,0.7857205311457217,0.1719044919230617},
{-0.5169003023867653,0.8371004897039297,0.17910010477359195},
{-0.34591681023585,0.9200447106590981,0.18400894213181962},
{-0.08860691116556504,0.9786763348377195,0.1853144541645508},
{0.2044065165836247,0.9622306764029535,0.17980573229811994},
{0.4809278681727553,0.8611499007767927,0.1647095443710809},
{0.5335007735766825,0.7614011040324012,0.36830053403616153},
{0.5212943335613911,0.6216932422311852,0.5845936455016099},
{0.5176173792952696,0.7678257801833618,0.3775126752008584},
{0.4865800117036703,0.8627645583598988,0.13739435595578361},
{0.5117916860115906,0.8489862083310676,0.1314978638345529},
{0.5860386505235451,0.6939457672325733,0.41832758961433264},
{0.5395001240850428,0.5560001278800442,0.6323001454290501},
{0.5588360656492826,0.5570359494750365,0.6143396476885367},
{0.6055216508136942,0.6868245578511067,0.40201437428093323},
{0.4668146021891383,0.3576111862528617,0.8088253004511033},
{0.4504179450084008,0.3540141042028727,0.8196326548154647},
{0.5942155270545856,0.7857205311457217,0.1719044919230617},
{0.6123162082245504,0.7739204859463981,0.16160427772184768},
{0.5140325984108751,0.7359466715380604,0.44062794330706534},
{0.47612641146458623,0.5832323527959393,0.6581365078446633},
{0.5169003023867653,0.8371004897039297,0.17910010477359195},
{0.48090952691209315,0.8711172570037936,-0.09940196917251416},
{0.558894195913913,0.8229914532781363,-0.10159894490043578},
{0.5726997852376209,0.8124996953126715,-0.10889995916252299},
{0.3511008654647001,0.6269015453142138,0.695501714413839},
{0.362715841960354,0.8050351606784807,0.46942050238817246},
{0.34591681023585,0.9200447106590981,0.18400894213181962},
{0.40241026762896953,0.3639092852638718,0.8400214334203141},
{0.31212491948771065,0.3824305325603991,0.8696694328308657},
{0.18300950484545764,0.3948205055354463,0.9003467607233088},
{0.1620108348368817,0.6600441419280365,0.7335490577336587},
{0.13081027882150345,0.8589674960228542,0.49503889920981814},
{0.08860691116556504,0.9786763348377195,0.1853144541645508},
{0.043202258457092815,0.9900517563083769,-0.13390700017140572},
{0.30371097327570024,0.9461341844456371,-0.11220405400570814},
{0.27761682964233486,0.05600339502871308,0.9590581398667114},
{0.29740617421626575,0.05040104633658303,0.9534197932003624},
{0.24140765998657898,0.06370202129720416,0.9683307256213938},
{0.18929678766076988,0.06769885116024363,0.9795833766111472},
{0.12840302970522927,0.06600155732511785,0.9895233480788502},
{0.03330128312315858,0.3878149427976245,0.9211354920342754},
{-0.058301382050642454,0.653915501250688,0.7543178813173175},
{-0.13910920168247798,0.8517563412866032,0.5051334131547062},
{-0.2044065165836247,0.9622306764029535,0.17980573229811994},
{-0.24069307656322755,0.9589724155551941,-0.14979569118891353},
{0.305611397989636,0.048201797719569554,0.9509354657995578},
{0.3046159181207129,0.04830252411434812,0.9512497088523382},
{-0.4031133553666986,0.7718255710047581,0.49171629083057733},
{-0.28059905017382275,0.5995979703643055,0.7494974629553819},
{-0.4809278681727553,0.8611499007767927,0.1647095443710809},
{-0.501916495756704,0.8505279530605235,-0.15710516334604144},
{-0.6177754470027788,0.6415745011281689,0.45468192902583926},
{-0.4734935344899295,0.5108930238033896,0.717490202738172},
{-0.6954974510065131,0.7047974169222004,0.13979948763581673},
{-0.7028860900219163,0.6925862938528656,-0.1620967921362251},
{-0.11960938192982191,0.3576280516563906,0.9261726472007366},
{-0.26179998298300167,0.311999979720002,0.9132999406355058},
{-0.6030529986263813,0.4300377933819966,0.6718590455675006},
{-0.7485170289561154,0.5228118941058879,0.4079092800416826},
{-0.8178867585205684,0.56459085934798,0.11089820457260183},
{0.06740377303179614,0.05770323002870382,0.9960557557814385},
{0.008000403150472384,0.04510227276078807,0.9989503383758581},
{-0.3677250190227828,0.2720185074087488,0.8892605028965419},
{-0.6733997441081458,0.387799852636084,0.6293997608281363},
{-0.8081242723770368,0.45941379870066906,0.3686110713997967},
{0.6954974510065131,0.7047974169222004,0.13979948763581673},
{0.8178867585205684,0.56459085934798,0.11089820457260183},
{0.7485170289561154,0.5228118941058879,0.4079092800416826},
{0.8081242723770368,0.45941379870066906,0.3686110713997967},
{0.6733997441081458,0.387799852636084,0.6293997608281363},
{0.7072958764770602,0.38109777820642954,0.5953965288483553},
{0.7024898490950203,0.41469400771488246,0.5783916423011527},
{0.6536350292398505,0.4819258270971297,0.5835312722788446},
{0.47452451219678266,0.31001601429083797,0.8238425566864268},
{0.16191164915266248,0.021501546984448693,0.9865709814027273},
{-0.8668517699335968,0.4906293012568327,0.08860529166603216},
{-0.8546851884340254,0.4870915587764289,-0.17959688761290626},
{-0.8138890085031598,0.5547925075777774,-0.17259766908421845},
{-0.7554259568818253,0.5114175726096974,-0.40961407458140814},
{-0.6589414981475599,0.632039803960021,-0.40782568363116545},
{-0.5806300280583716,0.5386278558598673,-0.6105315744568307},
{-0.6491019830095872,0.448801371090283,-0.6142018763895986},
{-0.6623327829724099,0.42842120523234245,-0.6146304218856155},
{-0.7865257591404247,0.4640151967465443,-0.40751334628063957},
{-0.669939601300284,0.49012897237986136,-0.5576329626586629},
{-0.7936125669544973,0.478407575643941,-0.37590595251788755},
{-0.6577059917288771,0.6425058532549849,-0.3932035821009495},
{-0.7663203307480657,0.5665150298431153,-0.30300803890990985},
{-0.6083939039236239,0.780792176501587,-0.14219857517741505},
{-0.6908029151944531,0.6986029481106615,-0.18640078661297926},
{-0.8313353408165232,0.5373228420795355,-0.1420060368049396},
{-0.7555424513452267,0.6493364839953087,-0.08670487165007433},
{-0.5532011838518002,0.8302017766337031,-0.06880014723247262},
{-0.6126211327304666,0.7900272524601185,-0.02350081067444656},
{-0.7791852813290522,0.6184883168660406,0.10169807894143301},
{-0.6404002561601537,0.7548003019201812,0.14200005680003408},
{-0.8287736371298976,0.44468585476793615,0.3396891946585741},
{-0.7072958764770602,0.38109777820642954,0.5953965288483553},
{-0.8103448497768507,0.4849268390186288,0.32891820448180453},
{-0.7024898490950203,0.41469400771488246,0.5783916423011527},
{-0.8779358468524555,0.4728193056063799,0.07530307468731051},
{-0.8612176163865167,0.47820978188113367,-0.17210352041351548},
{-0.8513933378731967,0.51869594122014,0.0779993896571639},
{-0.43861761304388475,0.25331017187418153,0.8622346237264875},
{-0.48370744189624076,0.2535039001875068,0.8377128883119307},
{-0.4977131547325216,0.2731072183191715,0.8232217580386012},
{-0.6536350292398505,0.4819258270971297,0.5835312722788446},
{-0.746223756411434,0.5717182009386449,0.34101085625341604},
{-0.0812999272365977,0.02789997502953353,0.9962991083126972},
{-0.11930514574190616,0.0250010783197624,0.9925428092945672},
{-0.362020400424362,0.17730999169955633,0.9151515702440157},
{-0.47452451219678266,0.31001601429083797,0.8238425566864268},
{-0.5464299970980586,0.5723314189956423,0.611433565566898},
{-0.6171226303017874,0.6920253770358723,0.3745137336704252},
{-0.03909909955810565,0.033399230824571066,0.9986770007335067},
{0.8287736371298976,0.44468585476793615,0.3396891946585741},
{0.8103448497768507,0.4849268390186288,0.32891820448180453},
{0.746223756411434,0.5717182009386449,0.34101085625341604},
{0.6171226303017874,0.6920253770358723,0.3745137336704252},
{0.5464299970980586,0.5723314189956423,0.611433565566898},
{0.4031004333331987,0.3590003859256223,0.8418009049364592},
{0.8779358468524555,0.4728193056063799,0.07530307468731051},
{0.8668517699335968,0.4906293012568327,0.08860529166603216},
{0.8513933378731967,0.51869594122014,0.0779993896571639},
{0.7791852813290522,0.6184883168660406,0.10169807894143301},
{0.6404002561601537,0.7548003019201812,0.14200005680003408},
{0.8546851884340254,0.4870915587764289,-0.17959688761290626},
{0.8612176163865167,0.47820978188113367,-0.17210352041351548},
{0.8313353408165232,0.5373228420795355,-0.1420060368049396},
{0.7555424513452267,0.6493364839953087,-0.08670487165007433},
{0.6126211327304666,0.7900272524601185,-0.02350081067444656},
{-0.3738056127334131,0.8232123606263929,0.42730641605400593},
{-0.3397169573951531,0.6598329363830499,0.6702334555379206},
{-0.3826004648598472,0.9045010989695028,0.1884002289064172},
{-0.36020890807644645,0.9325230615804728,0.025500630638393626},
{-0.31951200429150606,0.9475355995812269,0.009400353177903465},
{-0.2642125688908603,0.9559454754079234,0.12790608463717273},
{-0.4678057236380433,0.8835108098208877,0.02380029119834423},
{-0.35219259698941613,0.8701817089727141,0.34459275673637935},
{-0.5430284418594831,0.8273433332418976,-0.14360752164092408},
{0.0,0.8883259705893809,0.45921342530073594},
{0.0,0.7009297726244018,0.7132302951001903},
{0.0,0.977507302006819,0.21090157544065283},
{0.0,0.9990093657567062,0.04450041719336679},
{0.0,0.9992313363860713,0.03920122936982986},
{0.0,0.9863100110974192,0.16490167376048304},
{0.0,0.8805192615695225,0.474010369090237},
{-0.19661099676058183,0.8773490715058924,0.4377244826149881},
{-0.1045064195039831,0.6669409681072376,0.7377453173979744},
{-0.1990989238732247,0.7073961765339988,0.6781963343587192},
{-0.33430129207699083,0.8103031318276568,0.48130186023528476},
{-0.2263049221855869,0.7680167045449877,0.599113030850133},
{-0.28119992548202966,0.9504997481176002,0.13219996496701394},
{-0.26630237809085455,0.9578085532685712,0.10810096534593083},
{-0.278810659135252,0.9467361944165821,-0.16110615920620194},
{-0.25721254584789305,0.9390458030760949,-0.22811112639154127},
{-0.4031004333331987,0.3590003859256223,0.8418009049364592},
{-0.24920995738277482,0.39811590703885497,0.8828352743880964},
{0.0,0.3847147944918887,0.9230354960125119},
{0.24920995738277482,0.39811590703885497,0.8828352743880964},
{0.3397169573951531,0.6598329363830499,0.6702334555379206},
{0.3738056127334131,0.8232123606263929,0.42730641605400593},
{0.3826004648598472,0.9045010989695028,0.1884002289064172},
{0.36020890807644645,0.9325230615804728,0.025500630638393626},
{0.31951200429150606,0.9475355995812269,0.009400353177903465},
{0.2642125688908603,0.9559454754079234,0.12790608463717273},
{0.19661099676058183,0.8773490715058924,0.4377244826149881},
{0.1045064195039831,0.6669409681072376,0.7377453173979744},
{0.0,0.6393873498464238,0.7688847877649597},
{-0.14349548068100282,0.027499133928415173,0.9892688434684047},
{-0.07790470169062481,0.020001207109274666,0.996760156290703},
{0.0,-0.08780333439493668,0.996137829052351},
{0.07790470169062481,0.020001207109274666,0.996760156290703},
{0.14349548068100282,0.027499133928415173,0.9892688434684047},
{-0.16191164915266248,0.021501546984448693,0.9865709814027273},
{0.3934285009929553,-0.3290238353499804,0.858462189253566},
{0.37050994091507394,-0.2980079956617868,0.8797236033009191},
{0.37189035700806256,-0.3048920942504928,0.8767772654602561},
{0.4036100883602395,-0.32510812617917206,0.8552213765254627},
{0.3541029550014893,-0.3095025828098304,0.8825073645546859},
{0.18630434280484676,-0.2112049232441419,0.9595223667270556},
{0.21830238605811947,-0.1969021521522846,0.95581044706528},
{0.23469855778179366,-0.18759884720862585,0.9537941389530242},
{0.3518028971087866,-0.29700244582521207,0.8877073102998007},
{0.3678183159690769,-0.3319165281950424,0.8686432551678634},
{0.31381104477408467,-0.26610936588395134,0.9114320784165097},
{0.32931551277260235,-0.25991224345459873,0.9077427602298547},
{0.3358024211441847,-0.2487017931463929,0.9085065503558422},
{0.3235074504623772,-0.23600543526776205,0.9163211031180101},
{0.39490263400935327,-0.3148020997370079,0.8631057569345982},
{0.3594136076567837,-0.30061138136235166,0.8834334474234912},
{0.3079114760745739,-0.31191162516290877,0.8988335001488374},
{0.14289724711105134,-0.22259571173491974,0.9643814213708742},
{0.06520061549671545,-0.13120123854553786,0.9892093381802288},
{0.23809941665714376,-0.18479954724166386,0.953497663933585},
{0.3154126151798212,-0.30461218320790595,0.8987359456629845},
{0.32758559637798396,-0.3406850204089717,0.8812612517946191},
{0.28809303543505155,-0.27429336903795426,0.9174778202417901},
{0.2223001934012524,-0.11560010057213124,0.9681008422480991},
{0.22161216130103625,-0.11050606418666294,0.9688531672763715},
{0.21540039849110582,-0.10830020035555599,0.9705017954299824},
{0.2054955716181469,-0.10619771146397666,0.9728790346827014},
{0.18419664765151886,-0.10759804173346053,0.9769822190854176},
{0.15361211586538628,-0.10830854263164932,0.9821774673919003},
{0.29280215210372695,-0.21750159864262503,0.9311068436604514},
{0.251518213093239,-0.193714027340598,0.9482686666203151},
{0.312706926535135,-0.2735060582262853,0.90962014830943},
{0.25861662958394055,-0.2980191632483151,0.9188590845387649},
{0.11100588513300463,-0.22441189751212828,0.9681513279032593},
{0.08920517895700089,-0.22461304028859191,0.9703563356723988},
{0.10019843240778736,-0.24869610917980758,0.9633849279607022},
{0.0,-0.27269976820529557,0.9620991822160427},
{-0.10019843240778736,-0.24869610917980758,0.9633849279607022},
{-0.08920517895700089,-0.22461304028859191,0.9703563356723988},
{-0.11100588513300463,-0.22441189751212828,0.9681513279032593},
{-0.14289724711105134,-0.22259571173491974,0.9643814213708742},
{-0.18630434280484676,-0.2112049232441419,0.9595223667270556},
{-0.06520061549671545,-0.13120123854553786,0.9892093381802288},
{-0.21830238605811947,-0.1969021521522846,0.95581044706528},
{-0.23469855778179366,-0.18759884720862585,0.9537941389530242},
{-0.23809941665714376,-0.18479954724166386,0.953497663933585},
{-0.22751220066890007,-0.18751005549634622,0.9555512428093803},
{-0.21119914464519626,-0.1944992122797854,0.9578961205285678},
{-0.19391065956194223,-0.20221111585056586,0.9599527700541948},
{-0.17800462373015286,-0.20970544716973627,0.9614249733380279},
{-0.1619030931881433,-0.21670414017214734,0.9627183929105965},
{-0.1479045008024402,-0.22430682576056346,0.9632293115139309},
{-0.13940362732957529,-0.23220604207982337,0.962625047829621},
{-0.13590789511894785,-0.24261409386208058,0.9605558003072069},
{-0.13469767042393485,-0.25809553627629983,0.9566834543027356},
{-0.13510214949229776,-0.2801044564973546,0.9504151212248689},
{-0.1386045088780119,-0.3077100099694391,0.9413306219832078},
{-0.14500660665150197,-0.32981502671493346,0.932842501272559},
{-0.17451301392069019,-0.34942605767271717,0.9205686493638701},
{-0.22351371857547928,-0.36282226890015157,0.9046555249368168},
{-0.15579802683048521,-0.42119466560334007,0.8934886840374746},
{-0.19879784007320137,-0.3497961994849388,0.9154900532546069},
{0.22751220066890007,-0.18751005549634622,0.9555512428093803},
{0.21119914464519626,-0.1944992122797854,0.9578961205285678},
{0.2678164899689467,-0.3189196364865463,0.9091559784569434},
{-0.3518028971087866,-0.29700244582521207,0.8877073102998007},
{-0.37050994091507394,-0.2980079956617868,0.8797236033009191},
{-0.3154126151798212,-0.30461218320790595,0.8987359456629845},
{-0.2678164899689467,-0.3189196364865463,0.9091559784569434},
{-0.2170017208304693,-0.3333026431004397,0.9175072758615465},
{-0.1670003406810425,-0.3456007050261574,0.9234018837417642},
{-0.11990173978686657,-0.3556051598683049,0.9269134496117315},
{-0.0833061840475713,-0.3632269633382701,0.9279688856871718},
{-0.06400028864195267,-0.37030167006429804,0.9267041794452741},
{-0.05820315935323687,-0.3812206932208573,0.9226500828057789},
{-0.0592027553603532,-0.40081865453428317,0.9142425498384273},
{-0.05730265632620243,-0.43202002675252094,0.9000417224010853},
{-0.05260124219300176,-0.46751104040358027,0.8824208386141588},
{-0.042901856403490736,-0.4861210349122808,0.8728377685073827},
{-0.05750494276225476,-0.4836415707795896,0.8733750698135144},
{-0.09730187502519777,-0.4541087507599415,0.8856170660052944},
{-0.09650191316939308,-0.3781074960554147,0.920718253420313},
{-0.14210471369153102,-0.28300938757708144,0.9485314633104656},
{-0.25240417479957705,-0.29040480333517105,0.9230152667987703},
{-0.3139194840174321,-0.2455152383761694,0.9171569251111403},
{-0.3776140739388084,-0.22530839740045958,0.8981334740583788},
{-0.3678183159690769,-0.3319165281950424,0.8686432551678634},
{-0.3934285009929553,-0.3290238353499804,0.858462189253566},
{-0.32758559637798396,-0.3406850204089717,0.8812612517946191},
{-0.27651525023658746,-0.3552195909006722,0.8929492475090377},
{-0.2194014294049689,-0.37060241448259557,0.9025058798449609},
{-0.16220413301396447,-0.3834097694053883,0.909223167301458},
{-0.10790296197695996,-0.39151074711751466,0.9138250848428732},
{-0.06880204448312818,-0.3933116874304406,0.9168272439263359},
{-0.05480159118730052,-0.39201138221572635,0.9183266640017895},
{-0.05839974537766523,-0.3945982795552517,0.9169960019061475},
{-0.06890373709552482,-0.4096222164633812,0.909649336169657},
{-0.06920012110031788,-0.44450077787704195,0.8931015629291027},
{-0.05890113385774025,-0.48770938849609374,0.8710167672341554},
{-0.03230206045264106,-0.5083324250178777,0.8605548922445087},
{-0.02480143988939038,-0.49462871650372914,0.8687504367707026},
{-0.04479877253044877,-0.4389879718943529,0.8973754122505518},
{-0.15400686731932406,-0.2499111437863577,0.9559426264320902},
{-0.20411524083345647,-0.18151355321544513,0.961971828308191},
{-0.20449854704298487,-0.22099842981173426,0.9535932247442073},
{-0.2723086459367649,-0.1836058295776351,0.9445299893032482},
{-0.3385961129389351,-0.17139803236188267,0.9251893788868952},
{-0.31381104477408467,-0.26610936588395134,0.9114320784165097},
{-0.32931551277260235,-0.25991224345459873,0.9077427602298547},
{-0.28809303543505155,-0.27429336903795426,0.9174778202417901},
{-0.2542010460394567,-0.286301178131772,0.9238038014604646},
{-0.2119063371537703,-0.29930895096802007,0.9303278218695257},
{-0.16550190245530316,-0.30760353592296824,0.9370107710007194},
{-0.12050049043799413,-0.3056012437995934,0.9445038441384686},
{-0.09570608997226357,-0.2879183208256498,0.9528606324511257},
{-0.10519878706497766,-0.259897003404826,0.9598889325444112},
{-0.13580812156851196,-0.23501405426067973,0.9624575566828859},
{-0.16960489656404676,-0.23070666059743858,0.958127661544889},
{-0.18510518024095457,-0.2699075534685772,0.9449264441365639},
{-0.1719110946405005,-0.32642106626328893,0.9294599846357252},
{-0.14000846236720596,-0.3674222076693676,0.919455573574351},
{-0.11289861530697484,-0.3693954693923517,0.9223886869721311},
{-0.1127988285902476,-0.31819669554447505,0.9412902247517737},
{-0.27731361781956276,-0.10570519078084308,0.9549468938186098},
{-0.3184235944703808,-0.09100674339448697,0.9435699164032798},
{-0.25619758534913706,-0.13959868428860084,0.9564909851149478},
{-0.3153129580522722,-0.12560516185019152,0.9406386563398897},
{-0.3702039426929846,-0.13210140688747507,0.9195097928314407},
{-0.37189035700806256,-0.3048920942504928,0.8767772654602561},
{-0.4036100883602395,-0.32510812617917206,0.8552213765254627},
{-0.3358024211441847,-0.2487017931463929,0.9085065503558422},
{-0.21540039849110582,-0.10830020035555599,0.9705017954299824},
{-0.22161216130103625,-0.11050606418666294,0.9688531672763715},
{-0.2223001934012524,-0.11560010057213124,0.9681008422480991},
{-0.21650448926712793,-0.12520259610274556,0.9682200762514237},
{-0.19769773242001365,-0.1337984653404038,0.9710888616746346},
{-0.16900694210272324,-0.13270545098835132,0.9766401163166835},
{-0.13900371005853285,-0.112102992068788,0.9839262613423775},
{-0.13519687360844626,-0.06199856629973128,0.988877132480714},
{-0.17620695855019242,0.0053002093093985235,0.9843388723096164},
{-0.23828938920974252,0.06439713245953595,0.9690568488592591},
{-0.29740467821238276,0.08770137955355066,0.950714954863861},
{-0.3348998208286438,0.050499972982521686,0.9408994966189039},
{-0.331719447622692,-0.020501201918194715,0.9431552940999725},
{-0.30871860703118553,-0.10210615412336911,0.9456569964648172},
{-0.2764147374446007,-0.14750786459145662,0.9496506319732014},
{-0.2646908868496459,-0.13689528677641302,0.9545671348193124},
{-0.3800099848935314,-0.01710044932020891,0.924824300077731},
{-0.40030218965896613,-0.0296001619133285,0.9159050100141072},
{-0.3605084053514573,-0.07640178132829774,0.9296216743820103},
{-0.39869337775799274,-0.08869852672970643,0.912784838769741},
{-0.43282045557810733,-0.11400538802195988,0.8942422628880397},
{-0.3541029550014893,-0.3095025828098304,0.8825073645546859},
{-0.39490263400935327,-0.3148020997370079,0.8631057569345982},
{-0.3235074504623772,-0.23600543526776205,0.9163211031180101},
{-0.18419664765151886,-0.10759804173346053,0.9769822190854176},
{-0.2054955716181469,-0.10619771146397666,0.9728790346827014},
{-0.10120451736445109,0.006500290146926206,0.9948444058711062},
{-0.12060218231623371,0.023700428863140454,0.9924179579654255},
{-0.13929913425857085,0.03869975948174222,0.9894938503148303},
{-0.15959448131825235,0.0489983056678845,0.9859659058884512},
{-0.17619452572112743,0.050298437251831495,0.983069456506472},
{-0.1766029519430128,0.04990083409941302,0.9830164312569738},
{-0.16169544186973966,0.06069828893935186,0.9849722340240789},
{-0.14060046046726207,0.0970003176765606,0.985303226873352},
{-0.15030323230576645,0.1711036796241959,0.9737209400939775},
{-0.3079114760745739,-0.31191162516290877,0.8988335001488374},
{-0.3594136076567837,-0.30061138136235166,0.8834334474234912},
{-0.29280215210372695,-0.21750159864262503,0.9311068436604514},
{-0.15361211586538628,-0.10830854263164932,0.9821774673919003},
{-0.045601231933921266,-0.029400794273186075,0.9985269755706224},
{-0.07750078663697657,-0.012800129921978065,0.9969101186890572},
{-0.04149894469525443,0.018099539734556754,0.9989745963990163},
{-0.05549835644051066,0.04869855781356521,0.9972704662724555},
{-0.06740048595925566,0.08490061213562027,0.994107167538517},
{-0.08490151932628265,0.12260219398589224,0.9888176950509808},
{0.27651525023658746,-0.3552195909006722,0.8929492475090377},
{0.2194014294049689,-0.37060241448259557,0.9025058798449609},
{0.2170017208304693,-0.3333026431004397,0.9175072758615465},
{0.19391065956194223,-0.20221111585056586,0.9599527700541948},
{0.17800462373015286,-0.20970544716973627,0.9614249733380279},
{0.1670003406810425,-0.3456007050261574,0.9234018837417642},
{0.16220413301396447,-0.3834097694053883,0.909223167301458},
{0.2119063371537703,-0.29930895096802007,0.9303278218695257},
{0.2542010460394567,-0.286301178131772,0.9238038014604646},
{0.11990173978686657,-0.3556051598683049,0.9269134496117315},
{0.10790296197695996,-0.39151074711751466,0.9138250848428732},
{0.16550190245530316,-0.30760353592296824,0.9370107710007194},
{0.19769773242001365,-0.1337984653404038,0.9710888616746346},
{0.21650448926712793,-0.12520259610274556,0.9682200762514237},
{0.1619030931881433,-0.21670414017214734,0.9627183929105965},
{0.1479045008024402,-0.22430682576056346,0.9632293115139309},
{0.0833061840475713,-0.3632269633382701,0.9279688856871718},
{0.06880204448312818,-0.3933116874304406,0.9168272439263359},
{0.12050049043799413,-0.3056012437995934,0.9445038441384686},
{0.16900694210272324,-0.13270545098835132,0.9766401163166835},
{0.1766029519430128,0.04990083409941302,0.9830164312569738},
{0.17619452572112743,0.050298437251831495,0.983069456506472},
{0.15959448131825235,0.0489983056678845,0.9859659058884512},
{0.13929913425857085,0.03869975948174222,0.9894938503148303},
{0.12060218231623371,0.023700428863140454,0.9924179579654255},
{0.10120451736445109,0.006500290146926206,0.9948444058711062},
{0.07750078663697657,-0.012800129921978065,0.9969101186890572},
{0.045601231933921266,-0.029400794273186075,0.9985269755706224},
{0.12110323773834197,-0.1016027163849343,0.9874263991976785},
{0.07570328218695037,-0.09860427508102121,0.9922430196286942},
{0.1979065765448097,-0.18170603819197537,0.9632320087314841},
{0.26671267848851504,-0.2520119796741875,0.9302442202100365},
{0.21639764452445898,-0.27799697401940665,0.9358898128948296},
{0.18159863710734275,-0.26819798718165927,0.9460928995994327},
{0.09600501447286229,-0.272514233790156,0.9573500036965736},
{0.0,-0.2825182385536037,0.9592619271526255},
{-0.09600501447286229,-0.272514233790156,0.9573500036965736},
{-0.18159863710734275,-0.26819798718165927,0.9460928995994327},
{-0.21639764452445898,-0.27799697401940665,0.9358898128948296},
{-0.25861662958394055,-0.2980191632483151,0.9188590845387649},
{0.05820315935323687,-0.3812206932208573,0.9226500828057789},
{0.06400028864195267,-0.37030167006429804,0.9267041794452741},
{0.05480159118730052,-0.39201138221572635,0.9183266640017895},
{0.05839974537766523,-0.3945982795552517,0.9169960019061475},
{0.10519878706497766,-0.259897003404826,0.9598889325444112},
{0.09570608997226357,-0.2879183208256498,0.9528606324511257},
{0.13940362732957529,-0.23220604207982337,0.962625047829621},
{0.13590789511894785,-0.24261409386208058,0.9605558003072069},
{0.13469767042393485,-0.25809553627629983,0.9566834543027356},
{0.0592027553603532,-0.40081865453428317,0.9142425498384273},
{0.06890373709552482,-0.4096222164633812,0.909649336169657},
{0.13580812156851196,-0.23501405426067973,0.9624575566828859},
{0.17620695855019242,0.0053002093093985235,0.9843388723096164},
{0.13519687360844626,-0.06199856629973128,0.988877132480714},
{0.13900371005853285,-0.112102992068788,0.9839262613423775},
{0.13510214949229776,-0.2801044564973546,0.9504151212248689},
{0.05730265632620243,-0.43202002675252094,0.9000417224010853},
{0.06920012110031788,-0.44450077787704195,0.8931015629291027},
{0.16960489656404676,-0.23070666059743858,0.958127661544889},
{0.23828938920974252,0.06439713245953595,0.9690568488592591},
{0.03230206045264106,-0.5083324250178777,0.8605548922445087},
{0.042901856403490736,-0.4861210349122808,0.8728377685073827},
{0.05260124219300176,-0.46751104040358027,0.8824208386141588},
{0.05890113385774025,-0.48770938849609374,0.8710167672341554},
{0.1386045088780119,-0.3077100099694391,0.9413306219832078},
{0.14500660665150197,-0.32981502671493346,0.932842501272559},
{0.05750494276225476,-0.4836415707795896,0.8733750698135144},
{0.02480143988939038,-0.49462871650372914,0.8687504367707026},
{0.11289861530697484,-0.3693954693923517,0.9223886869721311},
{0.14000846236720596,-0.3674222076693676,0.919455573574351},
{0.1719110946405005,-0.32642106626328893,0.9294599846357252},
{0.18510518024095457,-0.2699075534685772,0.9449264441365639},
{0.29740467821238276,0.08770137955355066,0.950714954863861},
{0.17451301392069019,-0.34942605767271717,0.9205686493638701},
{0.09730187502519777,-0.4541087507599415,0.8856170660052944},
{0.04479877253044877,-0.4389879718943529,0.8973754122505518},
{0.1127988285902476,-0.31819669554447505,0.9412902247517737},
{0.2646908868496459,-0.13689528677641302,0.9545671348193124},
{0.2764147374446007,-0.14750786459145662,0.9496506319732014},
{0.30871860703118553,-0.10210615412336911,0.9456569964648172},
{0.331719447622692,-0.020501201918194715,0.9431552940999725},
{0.3348998208286438,0.050499972982521686,0.9408994966189039},
{0.19879784007320137,-0.3497961994849388,0.9154900532546069},
{0.15579802683048521,-0.42119466560334007,0.8934886840374746},
{0.09650191316939308,-0.3781074960554147,0.920718253420313},
{0.14210471369153102,-0.28300938757708144,0.9485314633104656},
{0.15400686731932406,-0.2499111437863577,0.9559426264320902},
{0.22351371857547928,-0.36282226890015157,0.9046555249368168},
{0.27211430950720805,-0.37791987343908096,0.8849465361371863},
{0.3116107538726774,-0.365912627862685,0.8769302633855931},
{0.3519917634891004,-0.32819232038955326,0.8765794882799586},
{0.25240417479957705,-0.29040480333517105,0.9230152667987703},
{0.20449854704298487,-0.22099842981173426,0.9535932247442073},
{0.20411524083345647,-0.18151355321544513,0.961971828308191},
{0.31839354941203274,-0.09099815639602694,0.9435808832449563},
{0.27731361781956276,-0.10570519078084308,0.9549468938186098},
{0.39992325021399644,-0.2924170001564705,0.8686505004648095},
{0.3139194840174321,-0.2455152383761694,0.9171569251111403},
{0.2723086459367649,-0.1836058295776351,0.9445299893032482},
{0.25619758534913706,-0.13959868428860084,0.9564909851149478},
{0.3605084053514573,-0.07640178132829774,0.9296216743820103},
{0.40030218965896613,-0.0296001619133285,0.9159050100141072},
{0.3800099848935314,-0.01710044932020891,0.924824300077731},
{0.4301972639541019,-0.22519856774166375,0.874194440141041},
{0.3776140739388084,-0.22530839740045958,0.8981334740583788},
{0.3385961129389351,-0.17139803236188267,0.9251893788868952},
{0.39339094031096583,-0.18049584322859513,0.9014792391721801},
{0.3702039426929846,-0.13210140688747507,0.9195097928314407},
{0.3153129580522722,-0.12560516185019152,0.9406386563398897},
{0.45340659257978455,-0.2744039898630191,0.8480123301889221},
{0.4609081005310509,-0.23700416538481028,0.8552150305362437},
{0.42772623325435294,-0.20371249407040376,0.8806540121669002},
{0.41551991634689717,-0.15750754951777693,0.8958429387811083},
{0.43282045557810733,-0.11400538802195988,0.8942422628880397},
{0.39869337775799274,-0.08869852672970643,0.912784838769741},
{0.4394121191533717,-0.29280807575809564,0.8492234219049686},
{0.4562173069318139,-0.27121028855744833,0.847532151742026},
{0.4365065280039398,-0.25700384352122,0.8622128944902564},
{0.42703410003438597,-0.2831226082429384,0.858768575408729},
{0.46139150124681977,-0.2831947836001287,0.8407845128919074},
{0.45958546583946064,-0.24219234078833196,0.8544729777193628},
{0.4392191306058594,-0.23151008364129427,0.8680378082101228},
{0.46602453217707773,-0.2536133505581693,0.8476446211873199},
{0.4496995570461545,-0.37379963180754405,0.8111992009691806},
{0.41952361564900603,-0.3266183858664252,0.8469476760265631},
{0.4136097571692588,-0.31690747593553703,0.8535201347774719},
{0.45501564143151596,-0.3225110865091514,0.8300285327212268},
{0.5002207070647623,-0.31991324308280183,0.8046333084852214},
{0.49649213314447493,-0.26379582018834336,0.8269868964964366},
{0.48342525237760414,-0.20541072990972256,0.8509444502443181},
{0.44579821458172586,-0.1973992094177494,0.8730965032555066},
{0.3565076239970596,-0.38930832544756044,0.8493181628631213},
{0.3801192535277991,-0.39502000827014117,0.8363423618134659},
{0.3694924827519068,-0.38399218775840926,0.8461827845863695},
{0.3332998833450612,-0.3729998694500685,0.8658996969351591},
{0.3710147203010477,-0.44431762865163205,0.8154323529204159},
{0.4159990161634901,-0.40879903319142974,0.8122980789173151},
{0.39711102196937426,-0.3562098867426117,0.8458234761563755},
{0.40140958376822006,-0.36730876960156267,0.8390200318423933},
{0.3714125873858834,-0.44011491574724626,0.8175277064834671},
{0.3419025403453122,-0.33680250245188986,0.8773065184116479},
{0.3049973312850268,-0.30529732866006126,0.902092106728599},
{0.3116125629137159,-0.4441179049742659,0.8400338666480147},
{0.37181651273800426,-0.5165229392931123,0.7713342557149614},
{0.4367199782123654,-0.47312164344463037,0.7651350019012613},
{0.4751329611168087,-0.42302934656369195,0.7715535245245587},
{0.4412261478363041,-0.36402157255760353,0.8202486093729299},
{0.422500376025502,-0.4211003747795003,0.8026007143149536},
{0.2575077420866505,-0.02590077871861844,0.9659290410931872},
{0.2910022567312514,-0.04820037379534818,0.9555074099886968},
{0.30539223550111727,-0.14399633893962308,0.941276068360189},
{0.26629640635424423,-0.09409873014620497,0.9592870545085487},
{0.29069193777090735,-0.19529458357983556,0.9366740217062569},
{0.335710303107306,-0.24580754394928747,0.9093279077017377},
{0.19321328483611408,0.03400233791111738,0.9805674212308998},
{0.1891073403438759,0.025000970431501315,0.9816381030224676},
{0.14890669350631305,-0.08080363220490325,0.9855443012120316},
{0.19280264430640012,-0.1283017596707009,0.9728133422264836},
{0.20581640833813514,-0.1964156588805138,0.9586764287314691},
{0.22700423366843725,-0.2887053844056292,0.9301173468502797},
{0.2581099245174002,-0.3890149579127032,0.8843340032961526},
{0.3729199983711334,-0.38252051321254626,0.8453453328589945},
{0.06930031704967575,0.06300028822697797,0.9956045549012581},
{-0.01769980583419499,0.06559928037984132,0.9976890554110929},
{-0.05269985586609131,0.11729967918581614,0.9916972877116271},
{0.04450134284828098,0.09760294521330841,0.9942300013429427},
{0.010399832512046079,0.08779858601515825,0.9960839581970287},
{-0.044902695365186374,0.021501290653708392,0.9987599523655152},
{-0.1641046721265241,0.08080230047424221,0.9831279900523208},
{-0.10130230262750839,0.12380281406994607,0.9871224375480111},
{0.04989858739098616,-0.05059856757482765,0.9974717619741222},
{-0.033599663837044956,-0.04569954277836174,0.9983900111579073},
{-0.0967054654638254,0.1002056632830952,0.9902559658974138},
{-0.07490405354253915,0.047602576083109,0.9960539029154739},
{-0.09910102619643942,-0.05020051982907426,0.9938102909588447},
{-0.11830566875193063,-0.18680895116534776,0.9752467300666335},
{-0.03600107248792436,-0.22310664644599792,0.9741290197357533},
{-0.07920337017510296,0.025101068073170252,0.9965424037814405},
{-0.08119778170690523,-0.01579956836168846,0.9965727740037162},
{-0.12329837062279826,-0.08769884106747289,0.9884869372314362},
{-0.18021358771568805,-0.15911199670125398,0.9706731866639667},
{-0.21900499775107368,-0.297006777772004,0.9294212096340085},
{-0.14550332769915714,-0.37600859941500403,0.9151209290549739},
{0.043898195382280986,-0.26748900375307894,0.9625604299540701},
{0.08630194656235732,-0.3172071546880619,0.9444213016626912},
{0.11790287332803494,-0.3781092146338423,0.9182223773520074},
{0.1482979275509436,-0.44949371836917834,0.8808876896805544},
{0.20490040467869886,-0.5110010092279899,0.8348016487348844},
{0.2876990016861963,-0.5341981463356483,0.794897241711357},
{-0.12860222869593513,0.11230194620959187,0.985317075692884},
{-0.024800394825428455,-0.06440102527248356,0.9976158821712672},
{-0.039600924692387476,-0.07330171161494954,0.9965232690900031},
{-0.062299775098217845,-0.09319966354982188,0.9936964127624249},
{-0.12110683364588815,-0.1325074769453359,0.9837555099707693},
{-0.20599990730006257,-0.16169992723504914,0.9650995657052932},
{-0.2675155618328609,-0.23461364787285668,0.93455436460863},
{-0.2807017361456071,-0.23050142565572654,0.9317057626179627},
{-0.26299865213536167,-0.3210983543751507,0.9097953373108444},
{-0.205701478998951,-0.4328031118655615,0.8777063107310613},
{-0.07270026971850098,-0.44050163426409467,0.8948033197264743},
{-0.010700034079662815,-0.48670155014690586,0.8735027821107916},
{0.038999910300309464,-0.5197988044641246,0.8533980371867718},
{0.09479856191672349,-0.5470917006818505,0.83168738339809},
{0.17351015931725072,-0.564133030955972,0.8072472657111516},
{0.272221106120568,-0.5607434761271215,0.7819606277577963},
{0.3675079474452962,-0.5333115329866026,0.7619164766219624},
{0.2183053561876219,-0.2240054960422689,0.9498233042006563},
{0.15330940045409208,-0.24681513393391996,0.9568586715882278},
{0.0754045432606013,-0.2705162990980458,0.9597578271511813},
{0.0,-0.272514626252497,0.9621516400643205},
{-0.0754045432606013,-0.2705162990980458,0.9597578271511813},
{-0.15330940045409208,-0.24681513393391996,0.9568586715882278},
{-0.2183053561876219,-0.2240054960422689,0.9498233042006563},
{-0.26671267848851504,-0.2520119796741875,0.9302442202100365},
{-0.312706926535135,-0.2735060582262853,0.90962014830943},
{-0.251518213093239,-0.193714027340598,0.9482686666203151},
{-0.12110323773834197,-0.1016027163849343,0.9874263991976785},
{-0.013900063523435454,-0.03460015812308393,0.9993045668323056},
{-0.021299289787022883,-0.0035998799640038675,0.9997666633364075},
{0.15020826393496683,-0.14970823642519665,0.9772537650948707},
{0.16501541315941728,-0.19761845842606576,0.9662902557250239},
{0.1138054121450649,-0.2377113046298939,0.9646458748253919},
{0.05330146447785507,-0.2604071547848679,0.9640264869916001},
{0.0,-0.2521002899155001,0.9677011128569197},
{-0.05330146447785507,-0.2604071547848679,0.9640264869916001},
{-0.1138054121450649,-0.2377113046298939,0.9646458748253919},
{-0.16501541315941728,-0.19761845842606576,0.9662902557250239},
{-0.15020826393496683,-0.14970823642519665,0.9772537650948707},
{-0.1979065765448097,-0.18170603819197537,0.9632320087314841},
{-0.07570328218695037,-0.09860427508102121,0.9922430196286942},
{0.02010090003794925,-0.03880173738668811,0.999044733229418},
{0.00029999757152948767,-0.014699881004944897,0.9998919059077825},
{-0.13399500207963191,-0.06919741898440693,0.9885631272830158},
{-0.1282046321170391,-0.0529019113805879,0.9903357814781888},
{-0.11260417262492636,-0.02830104871479055,0.9932368050717305},
{-0.10070169482378594,0.014100237308990881,0.9948167429066759},
{-0.23309430091401312,-0.18249553803864174,0.9551766462164964},
{-0.19139862959071816,-0.14599895465122703,0.9705930505786367},
{-0.10120340352769192,0.06510218942344609,0.9927333861851755},
{-0.16740901689248128,-0.0934050309304525,0.9814528624747977},
{-0.12159898708465637,0.11329905622279249,0.9860917858896352},
{-0.17109688093229064,-0.03899928904944088,0.9844820530557576},
{-0.14890070057944435,0.141300664821192,0.9787046048159985},
{-0.18480683613130508,-0.008700321830856896,0.9827363520900082},
{-0.15480230270137912,0.15050223873745194,0.9764145242740736},
{-0.17309611317041765,-0.007299836084021079,0.9848778848153918},
{-0.13380118414571954,0.15690138858343347,0.9785086598399595},
{-0.12810018254289018,-0.022700032347569146,0.9915014128905201},
{-0.09150356642100323,0.17760692236470135,0.9798381899376937},
{-0.05190355811086693,-0.04200287939607728,0.9977683993682454},
{-0.0833042232146465,0.22561143766175573,0.9706492083089544},
{-0.0074999330258971155,-0.054399514214507075,0.998491083514436},
{-0.14670825257131723,0.2775156106921645,0.9494534082563638},
{-0.039802232768872514,-0.07410415698928274,0.9964558977614214},
{0.037601998035249815,-0.32591731807680624,0.944650195321728},
{0.046499702867848006,-0.4202973143087423,0.9061942094375024},
{-0.11970113118103452,-0.12500118126674448,0.9849093074369332},
{0.011999902441189727,-0.5264957196071992,0.8500930887712822},
{-0.02329990330560192,-0.6145974494258772,0.7884967277453696},
{-0.09999843903654987,-0.4738926025942098,0.8748863431307747},
{-0.060597680971123,-0.6646745633911791,0.7446715019669191},
{-0.25630052029058426,-0.31450063843694404,0.9140018554256498},
{-0.06859856321813994,-0.6731859002689767,0.7362845786809976},
{-0.2534200703972442,-0.3931311352531834,0.8838700008566865},
{-0.41289238014143603,0.15389715985412208,0.8976834334051033},
{-0.3513021833498543,0.25380157738170517,0.9012056010102154},
{-0.2928036717810663,0.061200767462435995,0.9542119658930789},
{-0.24350916220459515,0.29691117149299506,0.9233347411232145},
{0.0969985498825188,-0.13789793844123033,0.9856852641154513},
{0.11230166488452295,-0.1891028034698423,0.975514462109102},
{0.04059920243650213,-0.13669731460763154,0.9897805559519658},
{0.06079945402335429,-0.1863983261505467,0.980591194330612},
{0.0745038497133746,-0.22951185918415398,0.9704501444544794},
{0.031900000319000005,-0.24060000240600005,0.9701000097010001},
{0.014099784486441173,-0.21099677493894237,0.977385060783518},
{0.0,-0.21659163430968403,0.9762622925971585},
{-0.014099784486441173,-0.21099677493894237,0.977385060783518},
{-0.031900000319000005,-0.24060000240600005,0.9701000097010001},
{-0.0745038497133746,-0.22951185918415398,0.9704501444544794},
{-0.11230166488452295,-0.1891028034698423,0.975514462109102},
{-0.0969985498825188,-0.13789793844123033,0.9856852641154513},
{-0.029900865792103694,-0.08620249602940931,0.9958288346413666},
{0.04289977906670671,-0.21579888863858523,0.9754949762138088},
{0.013100374610568061,-0.19240550191399194,0.98122805861751},
{-0.012899960590680595,-0.14669955183355374,0.989096978313347},
{-0.001000024440896007,-0.15040367591075945,0.9886241622697924},
{0.0,-0.1518993794923022,0.9883959624107405},
{0.001000024440896007,-0.15040367591075945,0.9886241622697924},
{0.012899960590680595,-0.14669955183355374,0.989096978313347},
{-0.013100374610568061,-0.19240550191399194,0.98122805861751},
{-0.04289977906670671,-0.21579888863858523,0.9754949762138088},
{-0.06079945402335429,-0.1863983261505467,0.980591194330612},
{-0.04059920243650213,-0.13669731460763154,0.9897805559519658},
{0.01830054563890246,-0.08480252842507806,0.9962297030314005},
{0.05940308250592892,-0.03690191489004676,0.9975517643041094},
{0.015700782782038885,-0.18480921389304367,0.9826489911867139},
{-0.02079963455363131,-0.16849703953302286,0.9854826852213295},
{-0.043700817649947425,-0.14600273173666642,0.9883184916119687},
{0.043700817649947425,-0.14600273173666642,0.9883184916119687},
{0.02079963455363131,-0.16849703953302286,0.9854826852213295},
{-0.015700782782038885,-0.18480921389304367,0.9826489911867139},
{0.014299864938413481,-0.14319864749516156,0.9895906533604183},
{0.06990000489300052,-0.09310000651700069,0.9932000695240073},
{0.10389914699150478,-0.04449963465949915,0.9935918426444577},
{0.0779977646160987,-0.027599209018004153,0.9965714386718457},
{0.052901205896732785,-0.018800428560653618,0.9984227593062005},
{0.026799382281357538,-0.01809958280942431,0.9994769623215246},
{-0.1382006599097266,-0.06890032899985647,0.9880047177337908},
{-0.36430750299028697,-0.17640363307023502,0.9144188326497896},
{-0.3271138404793922,-0.19360819173589217,0.9249391350027205},
{-0.2849035242783931,-0.19500241219475836,0.9385116094604139},
{-0.40151290282445173,-0.32081030940494176,0.8578275667317925},
{-0.328696959567186,-0.32049703541613356,0.8883917824140188},
{-0.2576037584662542,-0.2925042676683981,0.9209134362250525},
{-0.22370582313836543,-0.23450610427334237,0.9460246253415006},
{-0.21120989963999962,-0.18410862937369288,0.959944993676305},
{-0.21471209077825718,-0.15150853168563558,0.9648543324772357},
{-0.19170219883683107,-0.15640179393886477,0.9689111134742077},
{-0.13220119113809828,-0.1917017272403437,0.9725087623434233},
{-0.03550159672021954,-0.24981123551298148,0.9676435207460404},
{-0.045903080429571815,-0.39072622056282585,0.9193616958367182},
{0.03920186977776964,-0.5029239875316417,0.8634411828093446},
{0.07610023933562907,-0.6255019672067803,0.7765024421040206},
{0.0819033798127034,-0.7281300469063412,0.6805280825707529},
{0.07910243520595231,-0.7891242935653219,0.6091187520094253},
{0.0598010357629092,-0.8034139152495192,0.5924102606345721},
{0.0455021579910153,-0.7833371506453249,0.6199294008490194},
{0.047602278775628795,-0.7385353545336526,0.6725321948867723},
{-0.055601098132532285,-0.649512828005031,0.7583149768686912},
{-0.2224988374466115,-0.4315977449076742,0.8741954323407989},
{-0.4236071907930961,0.031000526238399384,0.9053153678588053},
{-0.014299864938413481,-0.14319864749516156,0.9895906533604183},
{-0.061501056289712745,-0.1536026381479655,0.9862169384213774},
{-0.0954056667878733,-0.15460918328516993,0.9833584083072936},
{-0.11230403234867353,-0.156105605072377,0.981335235474206},
{0.11230403234867353,-0.156105605072377,0.981335235474206},
{0.0954056667878733,-0.15460918328516993,0.9833584083072936},
{0.061501056289712745,-0.1536026381479655,0.9862169384213774},
{0.12010579104032587,-0.11000530403360405,0.9866475723595797},
{0.14759705841993825,-0.05909882217221105,0.9872803236992211},
{0.10510467410878874,-0.04030179226055363,0.9936441883396051},
{-0.13159844714748542,-0.04699944540981623,0.9901883158468091},
{-0.1323056025993656,-0.0501021216192609,0.989941919978171},
{-0.13390642029723543,-0.05710273785640137,0.9893474353999627},
{-0.13730584729401318,-0.06270267025007012,0.9885420979616317},
{-0.39611594992984234,-0.15550626158568664,0.9049364379992788},
{-0.590011888859342,-0.23930482204074668,0.7711155381346417},
{-0.5337738323792857,-0.2755864897035053,0.7994608073946026},
{-0.4710318616727217,-0.30242045641153087,0.8286560521911194},
{-0.5465193088682795,-0.38301353210713823,0.7447263116453939},
{-0.4577997848341516,-0.4110998067831362,0.7882996294992611},
{-0.3727070013667816,-0.4115077302453196,0.8317156239247445},
{-0.29371705223846595,-0.39722306145426856,0.8694504774127418},
{-0.2523052467421596,-0.3414070996344561,0.9054188283803063},
{-0.2338142631050874,-0.28341728898195795,0.9300567351913228},
{-0.23189241492315976,-0.25409168879678695,0.9389692868169341},
{-0.2076026189235567,-0.2615032988849233,0.9426118911240103},
{-0.14631011842612174,-0.3086213434470346,0.9398649986115462},
{-0.15550539224296567,-0.3576124004249808,0.9208319304007896},
{-0.05639692955275347,-0.4511754364220278,0.8906515097985376},
{0.02870142620930339,-0.5747285589716605,0.817840639511091},
{0.07559978189494385,-0.6979979862787143,0.7120979456003903},
{0.10210252502666625,-0.7887195052745511,0.6062149918821261},
{0.10649998615500271,-0.8348998914630212,0.5399999298000138},
{0.09880236288676299,-0.8353199769161248,0.5408129336959658},
{0.0855965415416071,-0.8107672416113907,0.5790766028825312},
{0.0843000754486013,-0.7634006832439173,0.6404005731587695},
{0.12090248396704992,-0.6809139895216235,0.7223148401108368},
{0.08910305673279273,-0.6557224949460403,0.7497257197819833},
{-0.008400395835977906,-0.5796273126824756,0.814838396089857},
{-0.16731259994977668,-0.40613058481532766,0.8983676541236365},
{-0.3996058982265871,-0.07740114244929389,0.9134134820824941},
{0.20729590076409318,-0.17509653750020607,0.9624809671270608},
{0.2027004084417345,-0.17320034899905484,0.9638019420628698},
{0.19249664866251992,-0.15559729107474335,0.9688831318915093},
{0.16540447425154356,-0.13070353557845674,0.9775264424479071},
{0.18939578314983174,-0.08309814984029047,0.9783782166515067},
{0.1310995890034327,-0.0608998090793978,0.9894968979320874},
{-0.13059831921044757,-0.047699386112851065,0.99028725508504},
{-0.4751377060488046,-0.04280339679833474,0.8788697454760882},
{-0.46330683614280127,-0.07020103582392542,0.8834130348554946},
{-0.4460162241352348,-0.09900360132149831,0.8895323573280074},
{-0.42309853819707577,-0.12869955534380442,0.8968969012265594},
{-0.6358925410242404,-0.19169775139856407,0.7475912308062937},
{-0.743647557782029,-0.23331492096630896,0.6265400685186135},
{-0.6897279379959542,-0.2997121400861063,0.6591266984676432},
{-0.621805658457238,-0.3480031668432274,0.7016063846471505},
{-0.6374212105436771,-0.37871260187149436,0.6710223286394844},
{-0.5576111606990732,-0.41500830647438197,0.7189143892155017},
{-0.4693300991044143,-0.4570293102295277,0.7555484548761666},
{-0.39422840912277896,-0.4640334394545141,0.7932571641709495},
{-0.31330737690903504,-0.44691052263213454,0.8379197290522835},
{-0.25511781677487344,-0.3996279089895705,0.8804614891752198},
{-0.24319828667410556,-0.3283976864464485,0.9126935700964479},
{-0.23510957973499344,-0.2905118371459617,0.9275377932973475},
{-0.21501636336790214,-0.3022230000454885,0.9286706745275997},
{0.28940480994791234,-0.21120351023151032,0.9336155168188354},
{0.3173066365377056,-0.20080419986376072,0.9268193846301465},
{0.27670260931790885,-0.16600156540214264,0.9465089256212531},
{0.3025005293763896,-0.1720003010007901,0.9375016406293066},
{0.47948677833437864,0.021899396132477354,0.8772758094530768},
{0.47423826782980905,0.006700540688443106,0.8803710400054426},
{0.49032983747844344,0.04140251941996239,0.8705529747603203},
{0.6190114270564162,0.08080149160930279,0.7812144213513285},
{0.18060938832001364,-0.03720193380678021,0.9828510899275161},
{0.17930420921571757,-0.027000633847319436,0.9834230861279235},
{0.1784971699498055,-0.010499833526459147,0.983884400636491},
{0.1776968556819578,0.002299959302580208,0.9840825868126881},
{0.18361373757568433,-0.007000523763778814,0.9829735439168852},
{0.2117059934815144,-0.05600158542732549,0.9757276232400264},
{0.3156108871853335,-0.24530846206135073,0.9166316197530946},
{0.4395132954782853,-0.5170156399596667,0.734522219633221},
{0.606508748951806,-0.5407077997662678,0.5829084085144396},
{0.5090852621949861,-0.6877800890546286,0.5174850190255457},
{0.6518288962154681,-0.6503288297160461,0.39011729428299186},
{0.5261404143974044,-0.7566581211425132,0.3881298133959944},
{0.6469216754738613,-0.7037235786535108,0.29370984091308244},
{0.4877121197967673,-0.7555187748748363,0.43741086979517335},
{0.5949050061466902,-0.7146060134349047,0.3680030967590889},
{0.40900403893482684,-0.7130070409792947,0.5695056238958042},
{0.49850242771273445,-0.6951033851617286,0.5180025226784282},
{0.750246126549834,-0.5948365716766746,0.28861774476443897},
{0.6489385545848259,-0.5966354471649054,0.472128049960697},
{0.39720927494485625,-0.661115437225691,0.6365148627955715},
{0.5063129896263755,-0.5728146957495316,0.6446165378494205},
{0.3420164684894462,-0.5169248905327332,0.7847377860341181},
{0.41310450079805444,-0.3546038634301382,0.8388091388753524},
{0.6366201939128314,-0.3884123206342189,0.6662211328695072},
{0.18400820510880278,-0.04390195763193719,0.9819437858496384},
{0.11020502491266895,-0.050102284465741505,0.9926452606925155},
{0.10930035085468937,-0.04470014348769089,0.9930031875453481},
{0.11020265922225095,-0.03410082286278364,0.9933239691965686},
{0.11060535951254592,-0.015200736569536147,0.9937481532334257},
{0.10890569755060493,-0.00040002092764225875,0.994052005191013},
{0.10899804840741473,-0.010899804840741474,0.9939822029079839},
{0.12460489395331692,-0.0685026904960049,0.9898388766853378},
{0.19610985869040076,-0.2336117439575605,0.9523478757310997},
{0.3107260570260637,-0.5062424527408865,0.8044674614475882},
{0.3954271885310533,-0.705748525408104,0.587840418357494},
{0.4299266777780599,-0.7858487634287031,0.44452758379238805},
{0.4091906112291368,-0.7748822205314226,0.48178894547946755},
{0.35040806648653683,-0.7112163723893408,0.6094140288724188},
{0.28771434723364614,-0.654332629110096,0.6993348732029501},
{0.3370225998081706,-0.6733451526731195,0.6580441266284162},
{0.29540159369589697,-0.6034032553693441,0.7407039961088385},
{0.20280728294029793,-0.45031617114406386,0.8695312254269677},
{0.2205980719812763,-0.3075973116112447,0.925591910362055},
{0.2562062246058411,-0.11360276001258217,0.9599233216204016},
{0.48162387950393337,-0.12620625746137126,0.8672429989738601},
{0.29260167222333516,0.07350042005610093,0.9534054487277093},
{0.5156188281652719,0.08560312585521195,0.852531130742619},
{0.1907083331826816,-0.04860212371619468,0.980442841385952},
{0.11439838470621186,-0.04979929683889292,0.992185990432722},
{0.053300041840549275,-0.050500039642546686,0.9973007828814219},
{0.05100136481478391,-0.05420145045022133,0.9972266861431865},
{0.051002352282732165,-0.05000230615954135,0.9974460032705307},
{0.052303427555915286,-0.039102562474881225,0.9978653922618026},
{0.05320085946682709,-0.018300295643664206,0.9984161295428603},
{0.05190268914798894,-0.0009000466326240857,0.9986517414871244},
{0.05160111769231395,-0.009600207942756083,0.9986216303787735},
{0.06399734896472756,-0.06609726197763269,0.9957587515480579},
{0.11540289087862522,-0.23250582434385064,0.9657241916940067},
{0.20690162832222236,-0.5004039381944904,0.8407066163871065},
{0.28700034870563546,-0.7224008777175996,0.629100764357893},
{0.3228163074776687,-0.8173412890381,0.4772241075847073},
{0.3125067533439104,-0.8022173361039519,0.5087109933633512},
{0.27089679530986704,-0.7217914612575196,0.6368924656066975},
{0.223610553549118,-0.6388301503004319,0.7361347426990418},
{0.1738109260982326,-0.5640354563832173,0.8072507453768317},
{0.2208171669938691,-0.6008467116391148,0.7682597268328363},
{0.26912359509991896,-0.6253548272611643,0.7324642179531053},
{0.20290235063734827,-0.5411062687524355,0.816109454682799},
{0.10489636750168903,-0.38658661273739736,0.916268270179196},
{0.09380279677207926,-0.25930773137526814,0.9612286594597291},
{0.10579711177827215,-0.09359744482463396,0.9899729741067054},
{0.1328086667123287,0.06860447693121798,0.9887645239343327},
{-0.2691999878860008,-0.03629999836650011,0.9623999566920028},
{-0.26431159692572825,-0.027601211029701474,0.9640422982837762},
{-0.3627017736160095,-0.013700066993491399,0.9318045565354222},
{-0.36590532213161586,-0.025100365087465316,0.9303135315087244},
{-0.47423826782980905,0.006700540688443106,0.8803710400054426},
{-0.47948677833437864,0.021899396132477354,0.8772758094530768},
{-0.36311638781238126,-0.0018000812394995493,0.9317420504676278},
{-0.2620032357599426,-0.01730021365895804,0.9649119167357579},
{-0.18060938832001364,-0.03720193380678021,0.9828510899275161},
{-0.18400820510880278,-0.04390195763193719,0.9819437858496384},
{-0.1907083331826816,-0.04860212371619468,0.980442841385952},
{-0.27680048024924986,-0.046500080677709964,0.9598016652573338},
{-0.37122084649196857,-0.04070228570103212,0.9276520937660292},
{-0.4734035292364657,-0.008300061877191943,0.8808065664374294},
{-0.49032983747844344,0.04140251941996239,0.8705529747603203},
{-0.36759320326450684,0.013899742996127978,0.9298828066258567},
{-0.2618049036517685,-0.002300043080210342,0.9651180768308701},
{-0.17930420921571757,-0.027000633847319436,0.9834230861279235},
{-0.10930035085468937,-0.04470014348769089,0.9930031875453481},
{-0.11020502491266895,-0.050102284465741505,0.9926452606925155},
{-0.11439838470621186,-0.04979929683889292,0.992185990432722},
{-0.12159804167930802,-0.04869921570544655,0.9913840338887003},
{-0.20021380121299281,-0.05570383979802048,0.9781674274047366},
{-0.2851987194606244,-0.06449971039695047,0.9562957062419184},
{-0.3753121584343119,-0.06760219000841855,0.9244299473932266},
{-0.475088878299537,-0.02839933517934509,0.8794794116279578},
{0.2946177866126829,-0.13690826540148096,0.9457570970794781},
{0.29169181232574043,-0.09509733065539223,0.9517732840988677},
{0.2851987194606244,-0.06449971039695047,0.9562957062419184},
{0.20021380121299281,-0.05570383979802048,0.9781674274047366},
{0.12159804167930802,-0.04869921570544655,0.9913840338887003},
{0.057302418786146524,-0.04500189957027214,0.9973420986984979},
{0.015699444406493505,-0.042698488927214825,0.9989646472666888},
{0.01370041170355763,-0.05050151759340586,0.9986300092826751},
{0.012800694200470248,-0.05590303170361616,0.9983541422132381},
{0.01290055202643207,-0.05240224233992561,0.998542728557552},
{0.01370061010175205,-0.04150184811844599,0.9990444884416275},
{0.014200016046027199,-0.019900022487038115,0.9997011296629148},
{0.013600093976974072,-0.0011000076010787853,0.9999069093806158},
{0.013900898791668,-0.008800569019185498,0.999864648338825},
{0.021600262660790945,-0.06560079771055027,0.9976121310372705},
{0.05159969659467603,-0.2317986370280214,0.9713942882183778},
{0.10690773986600154,-0.502636389678694,0.8578621071754549},
{0.15930455856516595,-0.7402211817321772,0.6532186921203164},
{0.18470806730101288,-0.8484370562976683,0.49602166421928745},
{0.18129808368938302,-0.8323912016714973,0.523694464578764},
{0.15900094923850044,-0.7395044148545351,0.6541039050119695},
{0.13140196315999453,-0.6360095020529416,0.7604113606305923},
{0.10140393809840556,-0.5406209954240438,0.8351324329978154},
{0.07180398451365406,-0.46432576615166543,0.8827489851003125},
{0.12590070693445418,-0.5014028153847125,0.8560048064804826},
{0.16821294532533043,-0.5474421300302371,0.8197630872959177},
{0.2134034571640093,-0.5802093994684077,0.7860127335094251},
{0.13250427333172354,-0.4830155775035657,0.8655279137253337},
{0.04610264037382348,-0.3348191756432993,0.9411539014274464},
{0.026300435275805754,-0.21610357654378795,0.9760161532010043},
{0.027699220831876842,-0.06389820256884225,0.9975719386960412},
{0.03960284734906892,0.08980645686733306,0.9951715504307698},
{0.2212091040480195,-0.11400469195964838,0.9685398610782409},
{0.21849849018064924,-0.08539940989211646,0.972093282858623},
{0.2101013341477078,-0.06950044132920367,0.9752061925789844},
{0.12830094814751022,-0.0532003931523581,0.9903073183981245},
{0.06089991930766038,-0.04779993666512588,0.9969986789776255},
{0.0175005101473063,-0.04510131472248652,0.9988291162931161},
{0.0,-0.041701257311862215,0.999130124227375},
{0.0,-0.0505012135587429,0.99872399962607},
{0.0,-0.05630078117875832,0.998413853088318},
{0.0,-0.05299970956238739,0.9985945277169821},
{0.0,-0.042100563730322546,0.9991133782177022},
{0.0,-0.020399834762007636,0.9997919017183938},
{0.0,-0.0011999991360009332,0.9999992800007776},
{0.0,-0.008500542947017593,0.9999638697321048},
{0.0,-0.06550343607286116,0.9978523437175705},
{0.0,-0.23320652987425597,0.9724272283435957},
{0.0,-0.5074789045403981,0.8616641813644554},
{0.0,-0.7515659866325717,0.6596579172093737},
{0.0,-0.8649877864586821,0.5017929147340655},
{0.0,-0.8490416507597921,0.528325917663602},
{0.0,-0.7510506826101515,0.6602445548058882},
{0.0,-0.6381855612150145,0.7698825816036347},
{0.0,-0.5327018697868444,0.8463029705286399},
{0.0,-0.4490127409172879,0.8935253541416407},
{0.0,-0.3707181322672846,0.9287454260497093},
{0.04270021051255674,-0.38910191827718565,0.9202045366195484},
{0.08170394598735949,-0.4314208359724221,0.8984433913714047},
{-0.057302418786146524,-0.04500189957027214,0.9973420986984979},
{-0.015699444406493505,-0.042698488927214825,0.9989646472666888},
{0.01960044846339132,-0.07720176639662296,0.9968228075667587},
{0.025801036061404985,-0.1698068187297119,0.9851395590732578},
{0.045300805908505735,-0.3777067194623094,0.9248164526310397},
{0.0779049288112368,-0.6725425497504075,0.7359465611320816},
{0.10129792797207479,-0.8800819981068413,0.4638905112166386},
{0.1086062667623935,-0.9550551082696666,0.2758159150374597},
{0.1079081009652206,-0.965272465724105,0.23791786116428157},
{0.10160650099190684,-0.9392600957834538,0.32782097465695925},
{0.08760708726199767,-0.8598695619619362,0.5029406870326328},
{0.0,-0.861525182749143,0.5077148407216946},
{0.0,-0.6893904451146455,0.7243899600247306},
{0.0,-0.4782985340172399,0.8781973083293749},
{-0.013900898791668,-0.008800569019185498,0.999864648338825},
{-0.05160111769231395,-0.009600207942756083,0.9986216303787735},
{-0.05190268914798894,-0.0009000466326240857,0.9986517414871244},
{-0.013600093976974072,-0.0011000076010787853,0.9999069093806158},
{-0.05320085946682709,-0.018300295643664206,0.9984161295428603},
{-0.11060535951254592,-0.015200736569536147,0.9937481532334257},
{-0.10890569755060493,-0.00040002092764225875,0.994052005191013},
{-0.10899804840741473,-0.010899804840741474,0.9939822029079839},
{-0.06399734896472756,-0.06609726197763269,0.9957587515480579},
{-0.021600262660790945,-0.06560079771055027,0.9976121310372705},
{-0.014200016046027199,-0.019900022487038115,0.9997011296629148},
{-0.01370061010175205,-0.04150184811844599,0.9990444884416275},
{-0.052303427555915286,-0.039102562474881225,0.9978653922618026},
{-0.11020265922225095,-0.03410082286278364,0.9933239691965686},
{-0.1784971699498055,-0.010499833526459147,0.983884400636491},
{-0.1776968556819578,0.002299959302580208,0.9840825868126881},
{-0.18361373757568433,-0.007000523763778814,0.9829735439168852},
{-0.12460489395331692,-0.0685026904960049,0.9898388766853378},
{-0.11540289087862522,-0.23250582434385064,0.9657241916940067},
{-0.05159969659467603,-0.2317986370280214,0.9713942882183778},
{-0.2117059934815144,-0.05600158542732549,0.9757276232400264},
{-0.19610985869040076,-0.2336117439575605,0.9523478757310997},
{-0.3156108871853335,-0.24530846206135073,0.9166316197530946},
{-0.3107260570260637,-0.5062424527408865,0.8044674614475882},
{-0.20690162832222236,-0.5004039381944904,0.8407066163871065},
{-0.051002352282732165,-0.05000230615954135,0.9974460032705307},
{-0.01290055202643207,-0.05240224233992561,0.998542728557552},
{-0.012800694200470248,-0.05590303170361616,0.9983541422132381},
{-0.05100136481478391,-0.05420145045022133,0.9972266861431865},
{-0.26441398654773746,0.01060056073149023,0.9643510106958517},
{-0.27640227065398015,0.008100066542319968,0.9610078947122827},
{-0.30410773203738184,-0.0147003737617544,0.952524218236127},
{-0.053300041840549275,-0.050500039642546686,0.9973007828814219},
{-0.01370041170355763,-0.05050151759340586,0.9986300092826751},
{0.06169879719367295,-0.0748985398671978,0.9952805971938847},
{0.058997355502808047,-0.15369311086070506,0.9863557875927096},
{0.06230395113034537,-0.34682199441418576,0.9358593494025232},
{0.08509835166089234,-0.6452875009021601,0.7591852947232605},
{0.10830037526145042,-0.8657029996660908,0.48870169335430125},
{0.11689990121962522,-0.9497991974200173,0.2901997547813108},
{0.11790137061140007,-0.9635112008828157,0.24030279353621237},
{0.11540253830674539,-0.9389206517868565,0.32420713101427084},
{0.10680157586887801,-0.862012719091506,0.49550731126431696},
{0.08540495832878785,-0.6977405085011157,0.7112412923118726},
{0.06260300470331784,-0.6917332005317084,0.7194345300889273},
{0.034801369634853495,-0.48171895842267043,0.8756344612723485},
{0.13060185390647439,-0.07340104193518546,0.9887140348953387},
{0.11150284224367364,-0.11890303087688607,0.9866251493955912},
{0.061303714811151884,-0.26441602277436477,0.9624583219290795},
{0.019100508366795364,-0.5740152776199234,0.8186217879088317},
{-0.0035002134320212246,-0.8412512968617869,0.5406329661001925},
{-0.01440112642815709,-0.9489742269221015,0.3150246406159364},
{-0.010300712370396816,-0.9698670734767797,0.24341683407326065},
{0.00600019077909878,-0.947530127199349,0.31961016216666166},
{0.030701043699721157,-0.8726296655497291,0.48741657000795086},
{0.05400093611434138,-0.7103123133706793,0.7018121660193478},
{0.1096017448736677,-0.16600264278310983,0.9800156019725761},
{-0.13820703146159294,-0.9374476938646689,0.3195162558030315},
{-0.13000606557448738,-0.9637449645702575,0.23301087137581197},
{0.8996221804582921,-0.305807539777841,0.3117076852477208},
{0.9291997305321171,-0.34149990096504307,0.1412999590230178},
{0.8058286195116421,-0.5387191329497661,0.2458087300520745},
{0.7724194497666207,-0.4672117645403485,0.43021083284515826},
{0.7965178023718267,-0.5744128382704047,0.1887042175863951},
{0.9254877419960355,-0.36299519216051956,0.10819856691947168},
{0.9915073619694941,-0.10810080265143954,0.07230053683347899},
{0.9693833606774198,-0.0933983968302775,0.2270961019288653},
{0.8477254533388605,-0.10210306569057172,0.5205156287163818},
{0.7796047322150869,-0.25070152176285565,0.5739034836047183},
{0.8964073819451855,-0.38240314910289935,0.22410184548629639},
{0.9910737864450182,-0.11879685786466367,0.06049839983848612},
{0.9939242222284471,0.10690260524823524,0.026200638517341095},
{0.976862736139437,0.11640747592816386,0.17941152217794326},
{0.8352135556260126,0.05150083586534919,0.5475088861413336},
{0.6306016994738702,-0.062300167899178735,0.773602084860428},
{0.6939108355022952,-0.129002014382182,0.7084110619250987},
{0.6565212388056186,-0.1929062406178276,0.729223590764748},
{0.6629334823010569,-0.14070710659188218,0.7353371391400921},
{0.6079239678749095,-0.12350486927545867,0.7843309228562124},
{0.7050508571525558,-0.02930211363768778,0.7085511096348734},
{0.6577058207222701,0.02010017788736146,0.7530066641384666},
{0.6090286585178057,0.06050284702845197,0.7908372137206581},
{0.5671219990890254,0.07800302579605708,0.8199318057716308},
{0.5330508021622845,0.07580722477279768,0.8426803112606771},
{0.5077032010787743,0.0619003902831911,0.8593054179377402},
{0.6400228460232406,0.10940390524209767,0.7605271475010537},
{0.7496146138793478,0.1633031836265975,0.6414125044586628},
{-0.6469216754738613,-0.7037235786535108,0.29370984091308244},
{-0.7965178023718267,-0.5744128382704047,0.1887042175863951},
{-0.8058286195116421,-0.5387191329497661,0.2458087300520745},
{-0.6518288962154681,-0.6503288297160461,0.39011729428299186},
{-0.5949050061466902,-0.7146060134349047,0.3680030967590889},
{-0.750246126549834,-0.5948365716766746,0.28861774476443897},
{-0.5261404143974044,-0.7566581211425132,0.3881298133959944},
{-0.5090852621949861,-0.6877800890546286,0.5174850190255457},
{-0.606508748951806,-0.5407077997662678,0.5829084085144396},
{-0.7724194497666207,-0.4672117645403485,0.43021083284515826},
{-0.4877121197967673,-0.7555187748748363,0.43741086979517335},
{-0.4091906112291368,-0.7748822205314226,0.48178894547946755},
{-0.4299266777780599,-0.7858487634287031,0.44452758379238805},
{-0.3954271885310533,-0.705748525408104,0.587840418357494},
{-0.4395132954782853,-0.5170156399596667,0.734522219633221},
{-0.5098135688687055,-0.3233086049730335,0.7972212183250923},
{-0.6618316065230724,-0.3454164957586418,0.665331773677546},
{-0.9291997305321171,-0.34149990096504307,0.1412999590230178},
{-0.9254877419960355,-0.36299519216051956,0.10819856691947168},
{-0.8964073819451855,-0.38240314910289935,0.22410184548629639},
{-0.6489385545848259,-0.5966354471649054,0.472128049960697},
{-0.8055259625201648,-0.39521273791181766,0.4415142302329643},
{-0.9742853955713798,-0.12569811579936616,0.1869971969330268},
{-0.8973326006855852,-0.13370485758571576,0.4206152812307557},
{-0.6366201939128314,-0.3884123206342189,0.6662211328695072},
{-0.7255252088113279,-0.13450467344606976,0.674923450622695},
{-0.7485090008748536,0.09890118929395193,0.6557078849347248},
{-0.9094785592956939,0.10569750821061556,0.4020905208277059},
{-0.7314235010146375,0.2697086658786542,0.6263201239888808},
{-0.876112414600873,0.2891040966340742,0.3858054669021993},
{-0.9802161099841525,0.10220167969840889,0.16950278580117717},
{-0.9441047866234024,0.2923014819722704,0.1524007726738762},
{-0.8035725745360387,0.46868400408790606,0.36688747834404256},
{-0.8650341825010956,0.48741926075264047,0.11890469861200031},
{-0.6549096108690599,0.6708098442066961,0.3480051070124184},
{-0.6991496029281821,0.7113504685493004,0.07190510148839406},
{-0.8681377604731055,0.4932214531336662,-0.05540240978022122},
{-0.6855317168585876,0.7179332159486215,-0.12090559382670057},
{-0.8553450821506134,0.5125270134481344,-0.07550397954211542},
{-0.6690133770562127,0.7349146947662342,-0.11100221951156891},
{-0.8339053119937562,0.5157032850403886,0.19660125235396625},
{-0.6386144711678768,0.7686174170680083,-0.037400847512807076},
{-0.9915073619694941,-0.10810080265143954,0.07230053683347899},
{-0.9910737864450182,-0.11879685786466367,0.06049839983848612},
{-0.9946476795793083,0.09760467879241956,0.033901625113350646},
{-0.8996221804582921,-0.305807539777841,0.3117076852477208},
{-0.9693833606774198,-0.0933983968302775,0.2270961019288653},
{-0.976862736139437,0.11640747592816386,0.17941152217794326},
{-0.9939242222284471,0.10690260524823524,0.026200638517341095},
{-0.9565088477477627,0.29170269826243844,0.0006000055500770074},
{-0.7796047322150869,-0.25070152176285565,0.5739034836047183},
{-0.8477254533388605,-0.10210306569057172,0.5205156287163818},
{-0.8352135556260126,0.05150083586534919,0.5475088861413336},
{-0.9002692243620941,0.3063235541236497,0.3093237848202574},
{-0.9351630040539461,0.3165213247599978,0.15901071291260552},
{-0.9527881235700592,0.30299622317561703,-0.019699754444091274},
{0.8553450821506134,0.5125270134481344,-0.07550397954211542},
{0.9527881235700592,0.30299622317561703,-0.019699754444091274},
{0.9351630040539461,0.3165213247599978,0.15901071291260552},
{0.8339053119937562,0.5157032850403886,0.19660125235396625},
{0.9002692243620941,0.3063235541236497,0.3093237848202574},
{0.9565088477477627,0.29170269826243844,0.0006000055500770074},
{0.8681377604731055,0.4932214531336662,-0.05540240978022122},
{0.6855317168585876,0.7179332159486215,-0.12090559382670057},
{0.6690133770562127,0.7349146947662342,-0.11100221951156891},
{0.6386144711678768,0.7686174170680083,-0.037400847512807076},
{0.5070298826867302,0.5127302186459302,0.6928408337778434},
{0.7433022076108349,0.4914014594645019,0.4539013480890058},
{0.39131863895067037,0.5288251885436098,0.7531358727159465},
{0.8650341825010956,0.48741926075264047,0.11890469861200031},
{0.9441047866234024,0.2923014819722704,0.1524007726738762},
{0.6991496029281821,0.7113504685493004,0.07190510148839406},
{0.9946476795793083,0.09760467879241956,0.033901625113350646},
{0.9802161099841525,0.10220167969840889,0.16950278580117717},
{0.876112414600873,0.2891040966340742,0.3858054669021993},
{0.8035725745360387,0.46868400408790606,0.36688747834404256},
{0.6549096108690599,0.6708098442066961,0.3480051070124184},
{0.4194113452303348,0.8427227959599503,0.3375091297454411},
{0.43891377771972734,0.8975281738515727,0.042401330998670404},
{0.9742853955713798,-0.12569811579936616,0.1869971969330268},
{0.9094785592956939,0.10569750821061556,0.4020905208277059},
{0.7314235010146375,0.2697086658786542,0.6263201239888808},
{0.6744304680846092,0.4270192910322184,0.6023272107463821},
{0.5499305604903933,0.5902328001480817,0.5909328390503243},
{-0.7433022076108349,0.4914014594645019,0.4539013480890058},
{-0.5070298826867302,0.5127302186459302,0.6928408337778434},
{-0.39131863895067037,0.5288251885436098,0.7531358727159465},
{-0.20650312957864334,0.45500689568175656,0.866213127559423},
{-0.13149682701984555,0.4414893469905841,0.8875785829871856},
{-0.04270139080694824,0.4234137908117538,0.9049294740329618},
{0.06600294742742753,0.16700745788455149,0.9837439300660675},
{0.05460455912496997,0.4119343938383723,0.9095759436659374},
{0.08190236742214599,0.20970606164131886,0.9743281633625988},
{0.2499100040977001,0.538321549442945,0.8048322180785474},
{0.0,0.24390009146255145,0.9698003636752046},
{0.4049258128186834,0.45872924262763665,0.7909504207416564},
{0.5687035885309655,0.6512041091108928,0.5025031708050117},
{0.36458927211849956,0.8187759078733611,0.44348695058846566},
{0.16350536469902513,0.871828605165811,0.46171514912256817},
{0.12070407443479998,0.95803233892741,0.26000877674439105},
{-0.08000197087282898,0.9503234115056173,0.30080741048183696},
{-0.14270777921307312,0.9855537239977825,0.09120497171851626},
{-0.35870134333904624,0.9261034682639829,0.1169004377929593},
{-0.4133912444661623,0.9093807395199033,-0.046199021515086355},
{-0.12070407443479998,0.95803233892741,0.26000877674439105},
{0.14270777921307312,0.9855537239977825,0.09120497171851626},
{0.08000197087282898,0.9503234115056173,0.30080741048183696},
{-0.16350536469902513,0.871828605165811,0.46171514912256817},
{-0.36458927211849956,0.8187759078733611,0.44348695058846566},
{-0.2499100040977001,0.538321549442945,0.8048322180785474},
{-0.5687035885309655,0.6512041091108928,0.5025031708050117},
{-0.4049258128186834,0.45872924262763665,0.7909504207416564},
{-0.08190236742214599,0.20970606164131886,0.9743281633625988},
{-0.05460455912496997,0.4119343938383723,0.9095759436659374},
{-0.06600294742742753,0.16700745788455149,0.9837439300660675},
{0.04270139080694824,0.4234137908117538,0.9049294740329618},
{0.13149682701984555,0.4414893469905841,0.8875785829871856},
{0.20650312957864334,0.45500689568175656,0.866213127559423},
{-0.1298993492058907,0.9899950401372734,0.05509972395107451},
{0.14270616646668238,0.9865426294280462,-0.07980344838150845},
{-0.39470340630509465,0.8908076877035175,0.22510194263814748},
{-0.5941270987549754,0.7434339087938877,0.30711400778935016},
{-0.6823111797602713,0.6865112485789627,0.2513041176517019},
{-0.6832671206260507,0.6039593298390983,0.41034030970853125},
{-0.5021107302209584,0.5382115017026884,0.6769144658167033},
{0.0,0.34782241961660787,0.9375604324053188},
{0.5021107302209584,0.5382115017026884,0.6769144658167033},
{0.0,0.5315262447562682,0.8470418237225948},
{0.0,0.5220929987798292,0.8528885628410579},
{0.48401505310223086,0.6646206700242616,0.5692177029458467},
{-0.12560363753401524,0.9804283936174247,0.15160439052672542},
{0.15300638049910298,0.9858411104314753,0.0686028607989442},
{-0.38591578234863533,0.8858362270132707,0.25761053519825977},
{-0.5659197905611199,0.7634266974984254,0.31131088673206686},
{-0.6242922244887656,0.7300909067743838,0.27789653882016335},
{-0.5276011132395234,0.8289017489845356,0.1859003922502415},
{-0.6093365064436843,0.7812468058982541,0.13550811853457942},
{-0.574538179330567,0.7422493241064347,0.344922920889665},
{-0.48401505310223086,0.6646206700242616,0.5692177029458467},
{0.4133912444661623,0.9093807395199033,-0.046199021515086355},
{0.41931770816073133,0.8968378742631621,-0.1409059505839424},
{0.35870134333904624,0.9261034682639829,0.1169004377929593},
{-0.14270616646668238,0.9865426294280462,-0.07980344838150845},
{-0.41931770816073133,0.8968378742631621,-0.1409059505839424},
{-0.15300638049910298,0.9858411104314753,0.0686028607989442},
{-0.43891377771972734,0.8975281738515727,0.042401330998670404},
{-0.4194113452303348,0.8427227959599503,0.3375091297454411},
{-0.3553049547621415,0.725910122887246,0.588908212382283},
{-0.5499305604903933,0.5902328001480817,0.5909328390503243},
{-0.6744304680846092,0.4270192910322184,0.6023272107463821},
{-0.49821420927187554,0.36941053573872107,0.7844223720450807},
{-0.5233254080653573,0.23201126442033806,0.819939809044117},
{-0.5156188281652719,0.08560312585521195,0.852531130742619},
{-0.29260167222333516,0.07350042005610093,0.9534054487277093},
{-0.3143049519135264,0.20000315107446795,0.9280146209855313},
{-0.1328086667123287,0.06860447693121798,0.9887645239343327},
{-0.1575999141080702,0.19379989437908635,0.9682994722769315},
{-0.04950273980495386,0.21411185034829538,0.9755539935299493},
{-0.03960284734906892,0.08980645686733306,0.9951715504307698},
{0.03679904286934229,0.27869275129580695,0.9596750391768423},
{0.03280066438418572,0.1597032348217823,0.9866199841901717},
{0.1471052179146208,0.3984141319998975,0.9053321126995664},
{0.09010041401235358,0.32560149614231215,0.941204324843809},
{0.008600486242234947,-0.0036002035432611402,0.9999565341407817},
{0.0,0.14630582820875238,0.9892394071366906},
{0.0,0.5432015209663881,0.8396023508898737},
{-0.09010041401235358,0.32560149614231215,0.941204324843809},
{-0.008600486242234947,-0.0036002035432611402,0.9999565341407817},
{-0.03280066438418572,0.1597032348217823,0.9866199841901717},
{-0.1471052179146208,0.3984141319998975,0.9053321126995664},
{-0.03679904286934229,0.27869275129580695,0.9596750391768423},
{0.04950273980495386,0.21411185034829538,0.9755539935299493},
{0.1575999141080702,0.19379989437908635,0.9682994722769315},
{0.3143049519135264,0.20000315107446795,0.9280146209855313},
{0.1298993492058907,0.9899950401372734,0.05509972395107451},
{0.12560363753401524,0.9804283936174247,0.15160439052672542},
{0.10670391930693554,0.9174336979586004,0.3833140793847084},
{-0.15350048275977743,0.9245029075662164,0.3489010972956765},
{-0.13640079044487094,0.794904606485542,0.5912034260337807},
{-0.11000466759707132,0.6305267538177588,0.7683326010439082},
{-0.27180779555936657,0.5796166236431526,0.7682220329238609},
{-0.41301340250237034,0.48771582663536567,0.7691249585098621},
{-0.30499117215828103,0.4074882054245885,0.8607750852257321},
{-0.3164067379532278,0.325806938132622,0.8909189723215254},
{-0.17909580831165914,0.3145926370454939,0.9321781826249506},
{-0.06500096949669011,0.334604990670654,0.9401140219052059},
{0.03920136579937709,0.3798132329235566,0.9242322008108241},
{0.14770208335257864,0.4661065744795999,0.8723123040518236},
{0.29199608581870423,0.5583925147985084,0.776489591226794},
{0.19600813450637652,0.5740238224829598,0.7950329945539252},
{0.0,0.7832340205085372,0.6217270052989755},
{-0.19600813450637652,0.5740238224829598,0.7950329945539252},
{-0.29199608581870423,0.5583925147985084,0.776489591226794},
{-0.14770208335257864,0.4661065744795999,0.8723123040518236},
{-0.03920136579937709,0.3798132329235566,0.9242322008108241},
{0.06500096949669011,0.334604990670654,0.9401140219052059},
{0.17909580831165914,0.3145926370454939,0.9321781826249506},
{0.3164067379532278,0.325806938132622,0.8909189723215254},
{0.5233254080653573,0.23201126442033806,0.819939809044117},
{0.49821420927187554,0.36941053573872107,0.7844223720450807},
{0.30499117215828103,0.4074882054245885,0.8607750852257321},
{0.41301340250237034,0.48771582663536567,0.7691249585098621},
{0.21089755676595726,0.43699493744297446,0.8743898702520294},
{0.27180779555936657,0.5796166236431526,0.7682220329238609},
{0.3553049547621415,0.725910122887246,0.588908212382283},
{0.13640079044487094,0.794904606485542,0.5912034260337807},
{0.15350048275977743,0.9245029075662164,0.3489010972956765},
{-0.10670391930693554,0.9174336979586004,0.3833140793847084},
{-0.34621159482046904,0.8377280559824001,0.42231414353750457},
{-0.507524085126953,0.7472354609002154,0.42902035964426183},
{-0.5483901263246624,0.7360867468774325,0.3967928558089461},
{-0.4301913682967919,0.8279833866800177,0.3596927828367179},
{-0.3757135822915042,0.9189332200363673,0.12000433823524222},
{-0.45290035099790804,0.8898006895958016,0.05600004340005045},
{-0.46191789273611944,0.836632407583974,0.29441140424661955},
{-0.41820542625060864,0.8484110082042476,0.32450421046944644},
{-0.6908382942280029,0.5965330667443599,0.408522645037839},
{0.39470340630509465,0.8908076877035175,0.22510194263814748},
{0.38591578234863533,0.8858362270132707,0.25761053519825977},
{0.34621159482046904,0.8377280559824001,0.42231414353750457},
{0.0788049829966173,0.7997505698273458,0.5951376317422202},
{0.04860281491354094,0.6486375669325648,0.7595439902640811},
{-0.08540137668128825,0.4702075798072803,0.8784141601503934},
{-0.21089755676595726,0.43699493744297446,0.8743898702520294},
{0.6823111797602713,0.6865112485789627,0.2513041176517019},
{0.6832671206260507,0.6039593298390983,0.41034030970853125},
{0.5941270987549754,0.7434339087938877,0.30711400778935016},
{0.6242922244887656,0.7300909067743838,0.27789653882016335},
{0.5659197905611199,0.7634266974984254,0.31131088673206686},
{0.507524085126953,0.7472354609002154,0.42902035964426183},
{0.5483901263246624,0.7360867468774325,0.3967928558089461},
{0.5276011132395234,0.8289017489845356,0.1859003922502415},
{0.4301913682967919,0.8279833866800177,0.3596927828367179},
{0.2810926762257302,0.7506804412759006,0.5978844223243119},
{0.19950116708524118,0.627403670322207,0.7527044033336393},
{0.03670163803065878,0.4993222852508972,0.8656386343143934},
{0.6093365064436843,0.7812468058982541,0.13550811853457942},
{0.574538179330567,0.7422493241064347,0.344922920889665},
{0.46191789273611944,0.836632407583974,0.29441140424661955},
{0.45290035099790804,0.8898006895958016,0.05600004340005045},
{0.3757135822915042,0.9189332200363673,0.12000433823524222},
{0.41820542625060864,0.8484110082042476,0.32450421046944644},
{0.6908382942280029,0.5965330667443599,0.408522645037839},
{-0.28700034870563546,-0.7224008777175996,0.629100764357893},
{-0.3228163074776687,-0.8173412890381,0.4772241075847073},
{-0.3125067533439104,-0.8022173361039519,0.5087109933633512},
{-0.18129808368938302,-0.8323912016714973,0.523694464578764},
{-0.18470806730101288,-0.8484370562976683,0.49602166421928745},
{-0.15930455856516595,-0.7402211817321772,0.6532186921203164},
{-0.3760109608792668,-0.10070293553335681,0.9211268512390761},
{-0.4957925210262301,-0.156697636233986,0.8541871146845618},
{-0.5722897503823552,-0.21929607244251348,0.790185847898195},
{-0.6565212388056186,-0.1929062406178276,0.729223590764748},
{-0.6939108355022952,-0.129002014382182,0.7084110619250987},
{-0.6306016994738702,-0.062300167899178735,0.773602084860428},
{-0.3386996799289537,-0.01339998733701795,0.9407991109452601},
{-0.3626112248041984,0.0627019409686245,0.9298287832954872},
{0.04040046703209835,-0.13060150976217932,0.99061145153457},
{0.05640049519852177,-0.17580154354432853,0.9828086290976454},
{0.21669942249680857,-0.21619942382930327,0.951997462930142},
{0.21599694906464154,-0.21869691092794954,0.9515865589347818},
{0.18880612497004265,-0.15420500249142255,0.9698314618429416},
{0.21469553223246085,-0.14879690356865474,0.9652799127340217},
{0.1659999834000025,-0.06159999384000093,0.9841999015800148},
{0.10540259504383535,0.003200078786909613,0.9944244830321621},
{0.0,0.025399425344502298,0.9996773825550767},
{-0.10540259504383535,0.003200078786909613,0.9944244830321621},
{-0.1659999834000025,-0.06159999384000093,0.9841999015800148},
{-0.21469553223246085,-0.14879690356865474,0.9652799127340217},
{-0.18880612497004265,-0.15420500249142255,0.9698314618429416},
{-0.21599694906464154,-0.21869691092794954,0.9515865589347818},
{-0.21669942249680857,-0.21619942382930327,0.951997462930142},
{-0.05640049519852177,-0.17580154354432853,0.9828086290976454},
{-0.04040046703209835,-0.13060150976217932,0.99061145153457},
{0.3386996799289537,-0.01339998733701795,0.9407991109452601},
{0.3626112248041984,0.0627019409686245,0.9298287832954872},
{-0.10690773986600154,-0.502636389678694,0.8578621071754549},
{-0.28771434723364614,-0.654332629110096,0.6993348732029501},
{-0.223610553549118,-0.6388301503004319,0.7361347426990418},
{-0.1738109260982326,-0.5640354563832173,0.8072507453768317},
{-0.2208171669938691,-0.6008467116391148,0.7682597268328363},
{-0.12590070693445418,-0.5014028153847125,0.8560048064804826},
{-0.07180398451365406,-0.46432576615166543,0.8827489851003125},
{-0.10140393809840556,-0.5406209954240438,0.8351324329978154},
{-0.13140196315999453,-0.6360095020529416,0.7604113606305923},
{-0.27089679530986704,-0.7217914612575196,0.6368924656066975},
{-0.35040806648653683,-0.7112163723893408,0.6094140288724188},
{-0.40900403893482684,-0.7130070409792947,0.5695056238958042},
{-0.3370225998081706,-0.6733451526731195,0.6580441266284162},
{-0.26912359509991896,-0.6253548272611643,0.7324642179531053},
{-0.2134034571640093,-0.5802093994684077,0.7860127335094251},
{-0.16821294532533043,-0.5474421300302371,0.8197630872959177},
{-0.08170394598735949,-0.4314208359724221,0.8984433913714047},
{-0.04270021051255674,-0.38910191827718565,0.9202045366195484},
{-0.15900094923850044,-0.7395044148545351,0.6541039050119695},
{-0.49850242771273445,-0.6951033851617286,0.5180025226784282},
{-0.39720927494485625,-0.661115437225691,0.6365148627955715},
{-0.29540159369589697,-0.6034032553693441,0.7407039961088385},
{-0.20290235063734827,-0.5411062687524355,0.816109454682799},
{-0.13250427333172354,-0.4830155775035657,0.8655279137253337},
{-0.04610264037382348,-0.3348191756432993,0.9411539014274464},
{-0.01640028823759869,-0.2935051583984887,0.9558167986278552},
{0.0,-0.27550028376543845,0.9613009901405298},
{0.01640028823759869,-0.2935051583984887,0.9558167986278552},
{-0.32350362649597963,0.7367082585458676,0.593806656609931},
{-0.4333086879262903,0.6835137045871669,0.5874117777242163},
{-0.4113230470760096,0.6900386639495419,0.595533368669496},
{-0.28491036665228936,0.5881213991864211,0.7569275413096449},
{-0.30059666189260437,0.889090126708964,0.34519616661785446},
{-0.19950116708524118,0.627403670322207,0.7527044033336393},
{-0.2810926762257302,0.7506804412759006,0.5978844223243119},
{-0.13019969468207396,0.5176987859977702,0.8455980170749748},
{-0.0788049829966173,0.7997505698273458,0.5951376317422202},
{-0.04860281491354094,0.6486375669325648,0.7595439902640811},
{-0.03670163803065878,0.4993222852508972,0.8656386343143934},
{0.28491036665228936,0.5881213991864211,0.7569275413096449},
{0.4333086879262903,0.6835137045871669,0.5874117777242163},
{0.4113230470760096,0.6900386639495419,0.595533368669496},
{0.32350362649597963,0.7367082585458676,0.593806656609931},
{0.30059666189260437,0.889090126708964,0.34519616661785446},
{0.13019969468207396,0.5176987859977702,0.8455980170749748},
{0.11000466759707132,0.6305267538177588,0.7683326010439082},
{0.08540137668128825,0.4702075798072803,0.8784141601503934},
{0.7485090008748536,0.09890118929395193,0.6557078849347248},
{0.7255252088113279,-0.13450467344606976,0.674923450622695},
{0.8973326006855852,-0.13370485758571576,0.4206152812307557},
{0.8055259625201648,-0.39521273791181766,0.4415142302329643},
{-0.48162387950393337,-0.12620625746137126,0.8672429989738601},
{-0.41310450079805444,-0.3546038634301382,0.8388091388753524},
{-0.5062386173546539,-0.5728436981840098,0.6446491757147568},
{-0.2562062246058411,-0.11360276001258217,0.9599233216204016},
{-0.2205980719812763,-0.3075973116112447,0.925591910362055},
{-0.3420164684894462,-0.5169248905327332,0.7847377860341181},
{-0.20280728294029793,-0.45031617114406386,0.8695312254269677},
{-0.10489636750168903,-0.38658661273739736,0.916268270179196},
{-0.026300435275805754,-0.21610357654378795,0.9760161532010043},
{-0.0015000547604985663,-0.18070659681472728,0.98353590463356},
{0.0,-0.15440128462403213,0.988008220262589},
{0.0015000547604985663,-0.18070659681472728,0.98353590463356},
{-0.10579711177827215,-0.09359744482463396,0.9899729741067054},
{-0.027699220831876842,-0.06389820256884225,0.9975719386960412},
{-0.09380279677207926,-0.25930773137526814,0.9612286594597291},
{-0.2193016809538268,-0.05130039321902104,0.9743074680953646},
{-0.15119827256960375,-0.005399938306057278,0.9884887065810405},
{-0.21591480578586655,0.009400644624303593,0.9763669517774038},
{-0.13759820985893453,-0.034499551163759024,0.9898871216523204},
{-0.2273045120393464,-0.11150221334090243,0.967419203461785},
{-0.13840527264929428,-0.18450702892915313,0.9730370685532033},
{0.05060322327496301,-0.18591184203192934,0.9812625035058046},
{0.4122187192770732,-0.13950633512652041,0.9003408854079307},
{0.07100207187068622,-0.12800373520349065,0.9892288661194761},
{0.4123969956988294,-0.11199918408891585,0.9040934137034716},
{0.6510133393999878,-0.16410336251234717,0.7411151856057312},
{0.2273045120393464,-0.11150221334090243,0.967419203461785},
{0.13840527264929428,-0.18450702892915313,0.9730370685532033},
{-0.05060322327496301,-0.18591184203192934,0.9812625035058046},
{-0.4122187192770732,-0.13950633512652041,0.9003408854079307},
{-0.6382301602788528,-0.12250578914785251,0.7600359163458604},
{-0.6849379089376343,-0.13310736703109816,0.7163396469149182},
{-0.6629334823010569,-0.14070710659188218,0.7353371391400921},
{-0.6079239678749095,-0.12350486927545867,0.7843309228562124},
{-0.5381010062498226,-0.07080013239637137,0.8399015706174056},
{-0.47512940904493745,-0.010400643767769625,0.8798544602772805},
{-0.4289065687544011,0.024600376757655088,0.9030138297627051},
{-0.3963236731200143,0.03470207281671586,0.9174548012119634},
{-0.37722602760769314,0.02910200796231143,0.9256638683819746},
{0.6382301602788528,-0.12250578914785251,0.7600359163458604},
{0.6849379089376343,-0.13310736703109816,0.7163396469149182},
{0.7498278191281441,-0.1100040812271217,0.6524242053870382},
{0.7623973430498893,-0.08799969332160318,0.6410977657781796},
{0.8114784027897108,-0.13869630864686738,0.5676848912676756},
{0.8507916963135658,-0.0491995198150299,0.523194893642757},
{0.8469222785835611,-0.0017000447202645574,0.5317139869203913},
{0.7418820355440112,-0.06789835586121898,0.6670838467602236},
{0.827409109824449,0.027900307184073155,0.5609061756109903},
{0.8003081071621885,0.0707007162018827,0.5954060314936487},
{0.7670674731934342,0.11279521702023124,0.6315732187054792},
{0.7312775281868329,0.1398957010711581,0.6675794855976065},
{0.6972272969830259,0.1455056966595385,0.7019274809988322},
{0.6663397583478081,0.132707918254171,0.7337437801287511},
{0.7680064628015768,0.19540164431175533,0.6099051323732835},
{0.8364948221130766,0.25179844137247187,0.48669698735497235},
{0.8307387008638406,0.21050980682778192,0.5153240069280571},
{0.9026566841062735,0.24671549298583834,0.35262214360278316},
{0.9660121090376806,0.21580270510386282,0.14230178376403932},
{0.9787051137475791,0.17750092744476886,-0.10310053870172207},
{0.9418776542177274,0.14719650780427804,-0.30199283530497256},
{0.8708939647257367,0.11879917672455793,-0.4768966951173542},
{0.7389597620925384,0.08430681816808903,-0.6684540600658447},
{0.7825209914071455,0.06010161224737309,-0.619716624121416},
{0.8895297018926275,0.11710391016484169,-0.4416147457625456},
{0.8320477733944035,0.047902750415374916,-0.5526317302617156},
{0.9093142445192114,0.12870201613287421,-0.39570619878615637},
{0.8790959429815847,0.0510997641751325,-0.47389781296663974},
{0.7865415383554898,-0.09470500150319758,-0.6102322272149013},
{0.8738355570922418,-0.0873035524538255,-0.4783194632149454},
{0.916429614901516,0.07600245605905195,-0.3929126971789673},
{0.9193585925902181,-0.06060386240723074,-0.3887247742193166},
{0.8752492166472171,-0.2525141992726489,-0.4125231968315551},
{0.8012093181185549,-0.2791032459896264,-0.5293061558663893},
{0.6558972124427707,-0.23049902038124503,0.7187969451194748},
{0.774861212579327,-0.34992764362610546,0.5264415878959187},
{0.882758603875192,-0.1263083852604925,0.4525300422040607},
{0.9060946223443745,0.022099868837667673,0.4224974924848231},
{0.8962469959433808,0.0938049187898785,0.4335227323604726},
{0.8935132866413592,0.29050431983135405,0.34240509160156846},
{0.9521213753648181,0.26380592250944124,0.15450346864180695},
{0.9384674970096647,0.3052219523522482,0.161611623525961},
{0.9737053261827013,0.2149011755126451,-0.07560041353539307},
{0.9479028342337115,0.16400049036219927,-0.27310081657266233},
{0.8899724780266689,0.31389029309277683,0.3307897704845192},
{0.8464045367404754,0.27440147079582516,0.4564024463236684},
{0.9288217625488477,0.33190777669031285,0.1647038590566271},
{0.9534366651119489,0.3008115679312715,-0.021700834521637603},
{0.9640820778807567,0.26139514070950093,-0.04709912443541504},
{0.9513080576133721,0.19840168046935036,-0.23590199809838586},
{0.8943315972935084,0.3153111401393752,0.31741121433630726},
{0.8584843843110728,0.27669496696432594,0.43179214577230196},
{0.9284591168740169,0.33232115956186536,0.16591056386191233},
{0.9458803731858824,0.324493266834569,0.003799921152454121},
{0.9521837701659551,0.2629955172796116,-0.15549734957026465},
{0.9506586187309702,0.2395895708929636,-0.19709142079717498},
{0.9257902375934165,0.15959831704462007,-0.3426963862856598},
{0.938830634543416,0.184306014003357,-0.2909094925316145},
{0.9452691536945004,0.07680561892058571,-0.31712319999632466},
{0.9499633361670038,-0.09760650764280407,-0.2967197829674177},
{0.9092252677212899,-0.31830884592574415,-0.2683074563678201},
{0.9654245172669279,-0.19220488110493428,-0.17610447222985914},
{0.9053711378050558,-0.4071319896171857,-0.12060947665888626},
{0.8187328359388412,-0.51732074756463,-0.24910999075652293},
{0.7933099402358271,-0.6014075356836335,-0.09470118661330246},
{0.8580900719553008,-0.5131940623790472,0.017699795214554045},
{0.7581585813860235,-0.6519503748918992,0.01250096592444967},
{0.794037729599104,-0.5976283969879402,0.11110527929277136},
{0.7324264813581589,-0.676724467415437,0.07480270454067489},
{0.7483066824085111,-0.6445057554620945,0.1570014020287802},
{0.7172259568770776,-0.6867248530221545,0.11830428150942315},
{0.7251201658722233,-0.6661185250137746,0.17460485582856183},
{0.7100263247139922,-0.6891255498033972,0.14480536875857195},
{0.6970298857970441,-0.69712989008482,0.16780719488772455},
{0.6870169695287237,-0.7192177648981921,0.10360255901481188},
{0.6539140887308142,-0.7441160321526209,0.13670294529668495},
{0.7886489371848756,0.2163134226643274,0.5755357130990312},
{0.8114336224487336,0.21710899609763382,0.5426224840284481},
{0.8735341820613292,0.2595101548310417,0.4118161146798573},
{0.903637655365665,0.2979124142689593,0.30771282266048594},
{0.9340753782540949,0.31502542200218403,0.16811356647164172},
{0.946083699118295,0.32259444174565266,0.029299495174047188},
{0.9591544767255524,0.26521506331729383,-0.09840558910415427},
{0.9597505465935896,0.15870835859581398,-0.23171220344455007},
{0.8355631584283348,0.19731491461150266,0.5127387568237072},
{0.8890795958574099,0.23219467119344345,0.3944909465366643},
{0.9126328006122916,0.2770099559167267,0.30061080414645497},
{0.9385272082981585,0.29790863649655985,0.1744050560758645},
{0.9529626402930874,0.29671950401401936,0.061804062514548015},
{0.9732098489335071,0.22940232156324142,-0.015400155850365815},
{0.982656887653887,0.11050639740052363,-0.14890862056957438},
{0.9730216548378954,-0.0020000445114859104,-0.23070513439989976},
{0.9208345641740616,0.2573096582992898,0.29301099837423983},
{0.9040238439433301,0.20150531477276662,0.3770099437684021},
{0.9396376755279156,0.28981162022987433,0.18190729371916542},
{0.952448342742485,0.28121427339267824,0.11730595401479786},
{0.9531242334917087,0.2865072845403153,0.09730247394685056},
{0.971141444345475,0.1938082709444476,0.13900593220473798},
{0.9769215218181911,0.20120443258247522,0.07170157960319819},
{0.9885962383984693,-0.036099862640283975,0.146199443712175},
{0.9998487638133458,-0.0169008242733002,-0.004100199971629043},
{0.9815922650834268,-0.15979874079088385,-0.10459917576174249},
{0.9277945213895267,0.24439855683078288,0.2818983353952442},
{0.9170865601949397,0.17689740758748754,0.3572947638836026},
{0.9391888612861574,0.28879657489293253,0.18579779645120106},
{0.9491376340533002,0.28421126920024015,0.13550537289455503},
{0.9485953424083031,0.2068989841284819,0.23949882406366077},
{0.960645747039737,0.19460926751398377,0.19820943895823012},
{0.9300994326395191,-0.03639997779602032,0.365499777045204},
{0.9658303855018995,-0.05620176813543876,0.25300795975562285},
{0.8605473572241379,-0.3788208470848384,0.34051873926184656},
{0.8988029076321092,-0.38030123027646995,0.21800070523342213},
{0.9125726369197169,-0.3988880395214498,0.08999730147137247},
{0.9341380482175716,-0.356214508912428,-0.022300908334495072},
{0.8394461875998975,-0.5308292070264781,0.11640640485659766},
{0.7635567725566378,-0.619646072398288,0.181713510901822},
{0.7203145108819841,-0.6651133988443809,0.19690396667036325},
{0.6439933991014887,-0.7412924017918222,0.18909806175480048},
{0.7005908748632819,-0.6799911431730398,0.2162971827475419},
{0.6007422847338688,-0.7715543077612449,0.20931473313600593},
{0.6699670436067456,-0.7035704062954853,0.23692370895721457},
{0.7706871334857088,-0.6026899381754726,0.2068965458909993},
{0.7608087037013559,-0.5932067863244536,0.26320301105966987},
{0.6299041132872898,-0.7283047558455835,0.269801761811257},
{0.7220195742159891,-0.6077164754169759,0.33070896564158947},
{0.5822166953031102,-0.7470214211463815,0.3209092022033117},
{0.6696166033495226,-0.6184153337983046,0.4113101985628116},
{0.8089856770353809,-0.3664935112898233,0.45959186299809773},
{0.6032070816927089,-0.5908069361141453,0.5358062904027743},
{0.7417145043689508,-0.318606230405754,0.5902115416995479},
{0.5481937396632393,-0.5525936894161,0.6277928306468107},
{0.6940237498990892,-0.31161066349936056,0.6490222099200418},
{0.8897183728741016,0.0006000123903837934,0.4565094270170028},
{0.8836526451745512,-0.04650277048507993,0.46582775251505876},
{0.8725860910885612,-0.3283947654291583,0.36159423623381126},
{0.6752444021555436,-0.5079334002588871,0.5348351692428683},
{0.7036420051632847,-0.6814406798156086,0.20131201767960377},
{0.583302365295887,-0.748603035591464,0.3152012781437743},
{0.8589466549546302,0.16300885406636947,0.48542636664917627},
{0.8795833312742694,0.12421176775925442,0.4592435084947635},
{0.9321071865741128,0.08690067000674864,0.35160271086735123},
{0.9476952378433948,0.14759925831559045,0.2829985779357188},
{0.9616385769052844,0.19150768248477743,0.1964078790601059},
{0.9720798441333957,0.1840961828052239,0.14549698315133122},
{0.963942515622248,0.11430504153503782,0.2403105991327173},
{-0.9396376755279156,0.28981162022987433,0.18190729371916542},
{-0.9391888612861574,0.28879657489293253,0.18579779645120106},
{-0.9616385769052844,0.19150768248477743,0.1964078790601059},
{-0.9476952378433948,0.14759925831559045,0.2829985779357188},
{-0.9394699609282412,-0.13029583385731752,0.3168898676084722},
{0.7964405159595965,-0.4871247806679049,0.3583182281119079},
{0.7875934787529938,-0.42539647773174655,0.44579630882184434},
{0.9139951695482933,-0.13359929392959735,0.38309797533255047},
{0.9394699609282412,-0.13029583385731752,0.3168898676084722},
{0.8076165724621021,-0.5274108225811202,0.2638054133426232},
{0.9650951455836266,-0.12489937175774009,0.23019884210273633},
{-0.9650951455836266,-0.12489937175774009,0.23019884210273633},
{-0.9760261090476302,-0.1537041116399803,0.15410412234040965},
{0.18020372845371294,-0.208304309860757,0.9613198899142855},
{0.07550263848580364,-0.2175076009359244,0.9731340067620599},
{0.07529755061051732,-0.23789226149059853,0.9683684994850594},
{0.17211018836415926,-0.24681461062332657,0.9536564533646849},
{0.15960434688358185,-0.18110493246000425,0.9704264299237334},
{-0.9367285753410428,-0.1867056955441152,0.296109032943827},
{-0.8852365211860379,-0.2246092664464348,0.40731680420139316},
{-0.9039165825018104,-0.0009000165109543416,0.4277078463724132},
{-0.9482240188185989,0.04830122348548653,0.3139079513891143},
{-0.9758032103978433,-0.16030052738960268,0.14870048922541435},
{-0.8639393878945617,0.16550754566101397,0.4756216840868776},
{-0.9049460357757896,0.22811160433247607,0.35921827389840166},
{-0.9823429833576257,0.10680467334072528,0.15360672120913296},
{-0.9727593693160194,-0.1744106446064704,0.15270932013422037},
{-0.9306936247705054,-0.32389778130779706,0.16999883551196512},
{0.8852365211860379,-0.2246092664464348,0.40731680420139316},
{0.9367285753410428,-0.1867056955441152,0.296109032943827},
{0.9039165825018104,-0.0009000165109543416,0.4277078463724132},
{0.9482240188185989,0.04830122348548653,0.3139079513891143},
{0.8639393878945617,0.16550754566101397,0.4756216840868776},
{0.9049460357757896,0.22811160433247607,0.35921827389840166},
{0.7943137774919569,0.30890535800990243,0.523109073405568},
{0.8289410087260776,0.384819037468687,0.40592008136314983},
{0.7072248593907191,0.4355153086321523,0.5569195760671541},
{0.7323564412240482,0.5173398703334701,0.44273412061980905},
{0.6065188327021376,0.5499170751902811,0.5742178297404245},
{0.6211193481690479,0.6295196098412745,0.4668145414994551},
{0.4878305049952459,0.6533408546810048,0.5789362020126031},
{0.4934126290578632,0.725018557087456,0.4805122988696864},
{0.6223263342960154,0.7092300117029313,0.33121401561761254},
{0.4938000666630135,0.7848001059480215,0.37450005055751023},
{0.468494823160806,0.7735914518616851,0.4266952850431503},
{0.5983082148281847,0.7214099050259944,0.3487047877496039},
{0.7285158308210075,0.6302136946923801,0.2685058346951826},
{0.5404032937681132,0.6739041074580524,0.5038030706890738},
{0.7006554906089552,0.6149487027911027,0.3618286561551813},
{0.5217025015694926,0.6344030419698794,0.5704027350876721},
{0.623522004479814,0.461416283667981,0.6311222726980122},
{0.8381364178185485,0.47852079218014015,0.261811375951433},
{0.8296898654001909,0.3844953034185529,0.4046950566800738},
{0.7726259568050357,0.1461049084768518,0.6178207560369545},
{0.919852281290153,0.11980680941352503,0.3735212296824007},
{0.9717912344825973,0.1213989049868155,0.20219817618067623},
{0.9353146424653426,-0.22360350054020164,0.27420429270180363},
{0.879000711990865,-0.38130030885337524,0.28630023190328174},
{0.9727593693160194,-0.1744106446064704,0.15270932013422037},
{0.9306936247705054,-0.32389778130779706,0.16999883551196512},
{0.9758032103978433,-0.16030052738960268,0.14870048922541435},
{0.820253597121111,-0.5392352347813986,0.1908124680940112},
{0.6627322957316757,-0.7150348444969792,0.22251084321759143},
{-0.8289410087260776,0.384819037468687,0.40592008136314983},
{-0.7323564412240482,0.5173398703334701,0.44273412061980905},
{-0.7072248593907191,0.4355153086321523,0.5569195760671541},
{-0.7943137774919569,0.30890535800990243,0.523109073405568},
{-0.3796896384111497,0.1331963651207931,0.9154750170276733},
{-0.3775112443398715,0.15270454837271094,0.9133272038559063},
{-0.333493473596582,0.24079528768232963,0.911482162468619},
{-0.3216071622712566,0.2647058950659254,0.9091202463333313},
{-0.25681361661893926,0.3406180600483284,0.904447955101903},
{-0.30379775494288647,0.5614958505609966,0.7696943119800518},
{-0.1639031035346484,0.4096077559962904,0.8974169927516381},
{-0.18560186159600775,0.6183062016423039,0.7637076600262453},
{-0.351413733517064,0.7982311954846912,0.4892191190567664},
{-0.4934126290578632,0.725018557087456,0.4805122988696864},
{-0.4878305049952459,0.6533408546810048,0.5789362020126031},
{-0.6211193481690479,0.6295196098412745,0.4668145414994551},
{-0.6065188327021376,0.5499170751902811,0.5742178297404245},
{0.40811672904759255,0.050402066023030295,0.9115373646823832},
{0.3796896384111497,0.1331963651207931,0.9154750170276733},
{0.3775112443398715,0.15270454837271094,0.9133272038559063},
{0.333493473596582,0.24079528768232963,0.911482162468619},
{0.3216071622712566,0.2647058950659254,0.9091202463333313},
{0.25681361661893926,0.3406180600483284,0.904447955101903},
{0.30379775494288647,0.5614958505609966,0.7696943119800518},
{0.1639031035346484,0.4096077559962904,0.8974169927516381},
{0.18560186159600775,0.6183062016423039,0.7637076600262453},
{0.07289920904787274,0.4404952206527838,0.8947902915780044},
{0.08040019135268313,0.6428015298694616,0.7618018130904727},
{0.0,0.44453139836153854,0.8957632699942184},
{0.0,0.6469950666814249,0.7624941860039975},
{-0.08040019135268313,0.6428015298694616,0.7618018130904727},
{-0.07289920904787274,0.4404952206527838,0.8947902915780044},
{-0.21179641855284312,0.8436857333948714,0.4932916585085813},
{-0.3513208093478247,0.8444500182559158,0.4043239488167536},
{-0.4938000666630135,0.7848001059480215,0.37450005055751023},
{-0.6223263342960154,0.7092300117029313,0.33121401561761254},
{-0.7433306444374883,0.6065250045087269,0.2821116302916931},
{-0.09110031794066442,0.8641030157247872,0.49500172755904376},
{-0.2122070814684649,0.8819294304761507,0.4209140461360833},
{-0.19990690390414154,0.8294286448128815,0.5216180143891957},
{-0.3308088442926798,0.8083216107671496,0.48701302046715556},
{-0.468494823160806,0.7735914518616851,0.4266952850431503},
{-0.5983290765079765,0.721435058988558,0.3486169414519148},
{-0.7285158308210075,0.6302136946923801,0.2685058346951826},
{0.0,0.868495336192567,0.4956973381124415},
{-0.09180616774553069,0.8996604412187298,0.42682867531364377},
{-0.087400738539361,0.840507102315022,0.5347045182722692},
{-0.07360212381992468,0.6558189239280788,0.7513216796998561},
{-0.16439668250842013,0.6553867744283367,0.7371851237543025},
{-0.2731117795650844,0.6617285409674711,0.6982301153143243},
{-0.39841889147961984,0.6730319125647194,0.6231295463879295},
{-0.5404032937681132,0.6739041074580524,0.5038030706890738},
{-0.7006554906089552,0.6149487027911027,0.3618286561551813},
{-0.5217025015694926,0.6344030419698794,0.5704027350876721},
{-0.623522004479814,0.461416283667981,0.6311222726980122},
{-0.8381364178185485,0.47852079218014015,0.261811375951433},
{-0.8296898654001909,0.3844953034185529,0.4046950566800738},
{0.351413733517064,0.7982311954846912,0.4892191190567664},
{0.21179641855284312,0.8436857333948714,0.4932916585085813},
{0.09110031794066442,0.8641030157247872,0.49500172755904376},
{0.09180616774553069,0.8996604412187298,0.42682867531364377},
{0.0,0.9040511888275081,0.42742420144344795},
{0.0,0.844138822837214,0.5361246569399721},
{0.0,0.6583275910875258,0.7527315476402563},
{-0.3523000528450119,0.5979000896850202,0.7200001080000243},
{0.3513208093478247,0.8444500182559158,0.4043239488167536},
{0.2122070814684649,0.8819294304761507,0.4209140461360833},
{0.087400738539361,0.840507102315022,0.5347045182722692},
{0.3308088442926798,0.8083216107671496,0.48701302046715556},
{0.19990690390414154,0.8294286448128815,0.5216180143891957},
{0.16439668250842013,0.6553867744283367,0.7371851237543025},
{0.2731117795650844,0.6617285409674711,0.6982301153143243},
{0.07360212381992468,0.6558189239280788,0.7513216796998561},
{0.39841889147961984,0.6730319125647194,0.6231295463879295},
{-0.8422494035876936,0.49632911303796295,0.21041234209789925},
{-0.8479332141945127,0.47421857550541097,0.23690927991824517},
{-0.932146207632797,0.30741523895110157,0.19130948344614745},
{-0.9829919542437816,0.12439898179850094,0.13509889422007618},
{-0.9353146424653426,-0.22360350054020164,0.27420429270180363},
{-0.879000711990865,-0.38130030885337524,0.28630023190328174},
{-0.9277071480111133,0.3323025604010919,0.1701013106356477},
{-0.9717912344825973,0.1213989049868155,0.20219817618067623},
{-0.9170408780082261,0.33121476422718044,0.22210990076949508},
{-0.919852281290153,0.11980680941352503,0.3735212296824007},
{-0.9015225969470921,0.31290784313338343,0.29890749221018953},
{0.8422494035876936,0.49632911303796295,0.21041234209789925},
{0.9170408780082261,0.33121476422718044,0.22210990076949508},
{0.9277071480111133,0.3323025604010919,0.1701013106356477},
{0.9015225969470921,0.31290784313338343,0.29890749221018953},
{0.9829919542437816,0.12439898179850094,0.13509889422007618},
{0.9823429833576257,0.10680467334072528,0.15360672120913296},
{0.7433306444374883,0.6065250045087269,0.2821116302916931},
{0.8479332141945127,0.47421857550541097,0.23690927991824517},
{0.932146207632797,0.30741523895110157,0.19130948344614745},
{0.3523000528450119,0.5979000896850202,0.7200001080000243},
{-0.20540748004958148,0.19010692286964673,0.9600349603096311},
{0.20540748004958148,0.19010692286964673,0.9600349603096311},
{-0.19249664866251992,-0.15559729107474335,0.9688831318915093},
{-0.2027004084417345,-0.17320034899905484,0.9638019420628698},
{-0.2581986870630144,-0.1766991014873534,0.9497951703038385},
{-0.24151594299361287,-0.14980988927719754,0.9587632900537336},
{-0.19740207075858343,-0.14250149484852148,0.9699101744110946},
{-0.22669620627073184,-0.1602973174468386,0.9606839230890696},
{-0.2700946764863892,-0.19499615666362788,0.9428814159904345},
{-0.20729590076409318,-0.17509653750020607,0.9624809671270608},
{-0.16540447425154356,-0.13070353557845674,0.9775264424479071},
{-0.22129734223487954,-0.11169865850716694,0.9687883649216055},
{-0.1747094572788907,-0.11940646364682055,0.9773529055447044},
{0.09440227889851925,-0.047001134621084795,0.9944240056852494},
{0.05140218823773091,-0.032701392127894954,0.9981424918303351},
{-0.013500607878554905,-0.018100815007543986,0.9997450145326918},
{-0.2651130292999953,-0.17530861575363701,0.9481465978096022},
{-0.2813076769912591,-0.20380556192967864,0.9377255908805675},
{-0.1542062562747282,-0.08990364746496798,0.9839399192523026},
{0.11780152612865656,-0.05500071253884644,0.9915128451321136},
{0.1276010897179593,-0.053000452625798146,0.9904084581243487},
{0.4778205515038898,0.014500623685237342,0.8783377781202729},
{0.457480724455754,0.06189739200833042,0.8870626244037144},
{0.22669620627073184,-0.1602973174468386,0.9606839230890696},
{0.2700946764863892,-0.19499615666362788,0.9428814159904345},
{0.2581986870630144,-0.1766991014873534,0.9497951703038385},
{0.19740207075858343,-0.14250149484852148,0.9699101744110946},
{0.24151594299361287,-0.14980988927719754,0.9587632900537336},
{0.013500607878554905,-0.018100815007543986,0.9997450145326918},
{-0.05140218823773091,-0.032701392127894954,0.9981424918303351},
{-0.09440227889851925,-0.047001134621084795,0.9944240056852494},
{0.1747094572788907,-0.11940646364682055,0.9773529055447044},
{0.22129734223487954,-0.11169865850716694,0.9687883649216055},
{-0.11780152612865656,-0.05500071253884644,0.9915128451321136},
{0.1542062562747282,-0.08990364746496798,0.9839399192523026},
{-0.1276010897179593,-0.053000452625798146,0.9904084581243487},
{-0.06990000489300052,-0.09310000651700069,0.9932000695240073},
{-0.14759705841993825,-0.05909882217221105,0.9872803236992211},
{-0.10389914699150478,-0.04449963465949915,0.9935918426444577},
{-0.01830054563890246,-0.08480252842507806,0.9962297030314005},
{-0.05940308250592892,-0.03690191489004676,0.9975517643041094},
{-0.0779977646160987,-0.027599209018004153,0.9965714386718457},
{-0.10510467410878874,-0.04030179226055363,0.9936441883396051},
{-0.1310995890034327,-0.0608998090793978,0.9894968979320874},
{-0.18939578314983174,-0.08309814984029047,0.9783782166515067},
{-0.12010579104032587,-0.11000530403360405,0.9866475723595797},
{0.029900865792103694,-0.08620249602940931,0.9958288346413666},
{-0.02010090003794925,-0.03880173738668811,0.999044733229418},
{-0.026799382281357538,-0.01809958280942431,0.9994769623215246},
{-0.052901205896732785,-0.018800428560653618,0.9984227593062005},
{0.1323056025993656,-0.0501021216192609,0.989941919978171},
{0.13159844714748542,-0.04699944540981623,0.9901883158468091},
{0.13059831921044757,-0.047699386112851065,0.99028725508504},
{0.013900063523435454,-0.03460015812308393,0.9993045668323056},
{-0.00029999757152948767,-0.014699881004944897,0.9998919059077825},
{0.1382006599097266,-0.06890032899985647,0.9880047177337908},
{0.13730584729401318,-0.06270267025007012,0.9885420979616317},
{0.13390642029723543,-0.05710273785640137,0.9893474353999627},
{0.4460162241352348,-0.09900360132149831,0.8895323573280074},
{0.46330683614280127,-0.07020103582392542,0.8834130348554946},
{0.4751377060488046,-0.04280339679833474,0.8788697454760882},
{0.4813325704703586,-0.017701197792074273,0.8763593008584567},
{0.021299289787022883,-0.0035998799640038675,0.9997666633364075},
{0.13399500207963191,-0.06919741898440693,0.9885631272830158},
{0.36430750299028697,-0.17640363307023502,0.9144188326497896},
{0.39611594992984234,-0.15550626158568664,0.9049364379992788},
{0.42309853819707577,-0.12869955534380442,0.8968969012265594},
{0.04149894469525443,0.018099539734556754,0.9989745963990163},
{0.1282046321170391,-0.0529019113805879,0.9903357814781888},
{0.2849035242783931,-0.19500241219475836,0.9385116094604139},
{0.3271138404793922,-0.19360819173589217,0.9249391350027205},
{0.5337738323792857,-0.2755864897035053,0.7994608073946026},
{0.590011888859342,-0.23930482204074668,0.7711155381346417},
{-0.09250091900119543,-0.12520124388053697,0.9878098139392524},
{-0.20471499182779743,-0.4317316168639968,0.8784643322986676},
{-0.13049992104757166,-0.5185996862472847,0.8449994887754639},
{-0.0508024807457037,-0.5567271856522293,0.8291404879185618},
{0.018900271315342113,-0.5592080274888523,0.8288118976801874},
{0.09140562527527449,-0.5486337639607831,0.8310511444611935},
{0.17539996404301106,-0.5328998907555337,0.8277998303010522},
{0.2697065984526477,-0.5133125583453617,0.814719932366971},
{0.35909932309841397,-0.4829990895475743,0.7985984946432565},
{0.43131317466213315,-0.44091346790756897,0.787124043071099},
{0.4425143974401349,-0.4888159038841535,0.7518244610067647},
{0.4889971027007497,-0.43739740842803254,0.754695528442241},
{0.5100902599194794,-0.38069273074170906,0.7712852724483326},
{0.4937279235723488,-0.37282108549275195,0.78564443337743},
{-0.06940370070398494,-0.05160275153206949,0.9962531216327059},
{0.2663072090337241,0.2149058175792239,0.9396254360048336},
{0.21521532387660947,0.20841483966489505,0.9540679320552297},
{0.08940664226619009,0.006500482938816953,0.9959739936565852},
{0.2011008949009735,0.1683007489399992,0.9650042942786643},
{-0.012300075092187657,-0.31950195056536235,0.947505784540472},
{0.21220506221213933,0.1108026432285817,0.970923161648285},
{0.05140230750137677,-0.3651163904426587,0.9295417280647803},
{0.1570050148202613,-0.3554113520198781,0.9214294309260431},
{0.10439878480521726,-0.3693957002590733,0.923389251811663},
{0.21041111736508675,-0.3371178120901651,0.9176484852386102},
{0.26889590474655584,-0.3184951493558127,0.9089861562462599},
{0.3259071602589672,-0.2934064462104356,0.8987197450897018},
{0.3724069845584937,-0.25720482392170935,0.891716724303998},
{0.39960587225143945,-0.20870306691410262,0.8926131170461332},
{0.4772036172171278,-0.38900294865352625,0.7880059731079143},
{0.49430212303217763,-0.3266014027560373,0.8056034600742915},
{0.4897111312605218,-0.25870588045149473,0.8326189256432722},
{0.5143141284031635,-0.31810873856707433,0.7964218780094876},
{0.22891123867315077,0.06540321104947165,0.9712476845756401},
{0.23849654421011143,0.04079940882084925,0.9702859406585792},
{0.24379234016500612,0.029799063728126265,0.9693695428874363},
{0.24190466154774248,0.027200524159150866,0.9699186905132511},
{0.238703557903046,0.03350049932866377,0.970514465625916},
{0.23720311093920005,0.04720061904017809,0.9703127257348475},
{0.23400784758475535,0.06830229055572133,0.9698325238790416},
{0.22769941936722096,0.09589975545593539,0.9689975290594515},
{0.21271196857562735,0.11970673548896377,0.9697545647756739},
{0.4009029446429426,-0.15150111277976006,0.9035066362806153},
{0.38050762925445064,-0.09660193688825212,0.9197184405396012},
{0.34738934746898725,-0.05559829510442053,0.9360712958138141},
{0.4700101288274155,-0.19470419592063365,0.8609185529947277},
{0.5055067485601402,-0.2536033856277974,0.8247110099654751},
{0.4894997993051234,-0.19289992091104863,0.8503996513362144},
{0.47331982778288745,-0.142205957132319,0.8693364172652948},
{0.4619214844678755,-0.15290711187516381,0.873640633970851},
{0.4455183490510663,-0.14570600102523087,0.88333638095804},
{0.4285951719025827,-0.11309872595002825,0.8963899022246269},
{0.311696131875005,-0.04119948871751751,0.9492882194062955},
{0.2848930871531093,-0.04759884502803792,0.9573767695345274},
{0.27059697203682426,-0.05889934092006263,0.9608892477094768},
{0.41980862295767424,-0.08920183222445102,0.9032185522995982},
{0.2648972940879613,-0.06489933705665793,0.9620901722990847},
{0.4157014757428583,-0.06600023430124766,0.9071032202221477},
{0.26151707893052756,-0.05950388602816974,0.9633629144695113},
{0.4109986745314119,-0.03909987390311,0.9107970626842093},
{0.4030999556590073,-0.016899998141000305,0.9149998993500166},
{0.2642061653228025,-0.061201428151989076,0.9625224607236845},
{0.39980036781650763,-0.0016000014720020316,0.9166008432731637},
{0.27761159746673136,-0.08370349678661891,0.9570399811803382},
{0.41048637618325795,0.013299558594975227,0.9117697388645424},
{0.30660066532416563,-0.11470024889981018,0.9449020504396742},
{0.04910160810399854,-0.2188071660520342,0.9745319164429038},
{0.10200303055505734,-0.32170955813296026,0.9413279672693675},
{0.3521005527983018,-0.12630019829146696,0.9274014560214289},
{0.16731259994977668,-0.40613058481532766,0.8983676541236365},
{0.3996058982265871,-0.07740114244929389,0.9134134820824941},
{0.2224988374466115,-0.4315977449076742,0.8741954323407989},
{0.4236071907930961,0.031000526238399384,0.9053153678588053},
{0.2534200703972442,-0.3931311352531834,0.8838700008566865},
{0.41289238014143603,0.15389715985412208,0.8976834334051033},
{0.25630052029058426,-0.31450063843694404,0.9140018554256498},
{0.3513021833498543,0.25380157738170517,0.9012056010102154},
{0.2928036717810663,0.061200767462435995,0.9542119658930789},
{0.24350916220459515,0.29691117149299506,0.9233347411232145},
{0.11970113118103452,-0.12500118126674448,0.9849093074369332},
{0.45770826170868645,-0.103001859200338,0.8831159403865873},
{0.44191354706743124,-0.07120218273636819,0.894227412961523},
{0.4237948021886266,-0.04399946034992819,0.9046889040586371},
{0.37889499672460214,-0.009799870593563211,0.9253877803350404},
{0.39630195971803617,0.019900098406229926,0.9179045390491684},
{0.4359102396517956,0.05140120742854392,0.8985211065086908},
{0.42322050129763633,0.1022049509277373,0.9002436088566451},
{0.4647122058263811,0.1437037744292037,0.8737229486346227},
{0.4315006256763608,0.20970030406566134,0.8774012722327671},
{-0.4157014757428583,-0.06600023430124766,0.9071032202221477},
{-0.44191354706743124,-0.07120218273636819,0.894227412961523},
{-0.45770826170868645,-0.103001859200338,0.8831159403865873},
{-0.41980862295767424,-0.08920183222445102,0.9032185522995982},
{-0.4237948021886266,-0.04399946034992819,0.9046889040586371},
{-0.4109986745314119,-0.03909987390311,0.9107970626842093},
{-0.26151707893052756,-0.05950388602816974,0.9633629144695113},
{-0.2648972940879613,-0.06489933705665793,0.9620901722990847},
{-0.27059697203682426,-0.05889934092006263,0.9608892477094768},
{0.4691248877354591,0.2678142079206053,0.8415446451276675},
{0.4158224467015258,0.2968160225613585,0.8596464049654439},
{-0.37889499672460214,-0.009799870593563211,0.9253877803350404},
{-0.39980036781650763,-0.0016000014720020316,0.9166008432731637},
{-0.41048637618325795,0.013299558594975227,0.9117697388645424},
{-0.27761159746673136,-0.08370349678661891,0.9570399811803382},
{-0.2642061653228025,-0.061201428151989076,0.9625224607236845},
{-0.4030999556590073,-0.016899998141000305,0.9149998993500166},
{-0.39630195971803617,0.019900098406229926,0.9179045390491684},
{-0.4359102396517956,0.05140120742854392,0.8985211065086908},
{-0.30660066532416563,-0.11470024889981018,0.9449020504396742},
{-0.04910160810399854,-0.2188071660520342,0.9745319164429038},
{-0.018800202197261955,-0.1332014325891113,0.9909106573014292},
{-0.42322050129763633,0.1022049509277373,0.9002436088566451},
{-0.4315006256763608,0.20970030406566134,0.8774012722327671},
{0.36661400492248714,0.3430131033508268,0.8648330372530467},
{0.44500958338456836,0.37480807157873314,0.8133175149812797},
{0.38732096625137014,0.4426239598834403,0.8087437784856262},
{0.29730641742828107,0.447309655283115,0.8435182075370167},
{0.292289789034577,0.32428867117315535,0.8996685706274681},
{0.21220330509221544,0.2585040262315631,0.9424146782229209},
{0.14670825257131723,0.2775156106921645,0.9494534082563638},
{0.20800238684108358,0.39480453040797975,0.8949102691542582},
{0.13720742861128293,0.3128169363674148,0.9398508849044003},
{0.15030323230576645,0.1711036796241959,0.9737209400939775},
{0.12530221849541787,0.23650418734370568,0.9635170592205516},
{0.14060046046726207,0.0970003176765606,0.985303226873352},
{0.1464994425706815,0.1969992504192782,0.9693963114540524},
{0.16169544186973966,0.06069828893935186,0.9849722340240789},
{0.1551002186914625,0.18140025577454097,0.971101369253896},
{0.1431008800731187,0.1728010627298037,0.9745059932302876},
{0.1129011623234492,0.1552015978086742,0.9814101036690261},
{0.08490151932628265,0.12260219398589224,0.9888176950509808},
{-0.4158224467015258,0.2968160225613585,0.8596464049654439},
{-0.4691248877354591,0.2678142079206053,0.8415446451276675},
{-0.44500958338456836,0.37480807157873314,0.8133175149812797},
{-0.4647122058263811,0.1437037744292037,0.8737229486346227},
{-0.3667005628857961,0.3430005265062123,0.8648013274710565},
{-0.38732096625137014,0.4426239598834403,0.8087437784856262},
{-0.292289789034577,0.32428867117315535,0.8996685706274681},
{-0.29730641742828107,0.447309655283115,0.8435182075370167},
{-0.3521005527983018,-0.12630019829146696,0.9274014560214289},
{-0.10200303055505734,-0.32170955813296026,0.9413279672693675},
{0.14440049312852604,-0.3166010811945384,0.9375032015789001},
{0.19470148168391346,-0.18630141775918374,0.9630073285136551},
{-0.011199722866286467,-0.08779782746963856,0.9960753524203526},
{-0.02010016854061982,-0.05810048717462745,0.9981083691737634},
{-0.0378009359627618,-0.011000272370115867,0.9992247411108887},
{0.0833042232146465,0.22561143766175573,0.9706492083089544},
{0.09150356642100323,0.17760692236470135,0.9798381899376937},
{0.13380118414571954,0.15690138858343347,0.9785086598399595},
{0.15480230270137912,0.15050223873745194,0.9764145242740736},
{0.14890070057944435,0.141300664821192,0.9787046048159985},
{0.12159898708465637,0.11329905622279249,0.9860917858896352},
{0.10120340352769192,0.06510218942344609,0.9927333861851755},
{-0.13720742861128293,0.3128169363674148,0.9398508849044003},
{-0.21220330509221544,0.2585040262315631,0.9424146782229209},
{-0.20800238684108358,0.39480453040797975,0.8949102691542582},
{-0.12530221849541787,0.23650418734370568,0.9635170592205516},
{-0.1431008800731187,0.1728010627298037,0.9745059932302876},
{-0.1551002186914625,0.18140025577454097,0.971101369253896},
{-0.1464994425706815,0.1969992504192782,0.9693963114540524},
{-0.1129011623234492,0.1552015978086742,0.9814101036690261},
{0.05549835644051066,0.04869855781356521,0.9972704662724555},
{0.06740048595925566,0.08490061213562027,0.994107167538517},
{0.11260417262492636,-0.02830104871479055,0.9932368050717305},
{0.10070169482378594,0.014100237308990881,0.9948167429066759},
{0.19139862959071816,-0.14599895465122703,0.9705930505786367},
{0.23309430091401312,-0.18249553803864174,0.9551766462164964},
{0.16740901689248128,-0.0934050309304525,0.9814528624747977},
{0.2576037584662542,-0.2925042676683981,0.9209134362250525},
{0.22370582313836543,-0.23450610427334237,0.9460246253415006},
{0.2523052467421596,-0.3414070996344561,0.9054188283803063},
{0.29371705223846595,-0.39722306145426856,0.8694504774127418},
{0.3727070013667816,-0.4115077302453196,0.8317156239247445},
{0.328696959567186,-0.32049703541613356,0.8883917824140188},
{0.40151290282445173,-0.32081030940494176,0.8578275667317925},
{0.4710318616727217,-0.30242045641153087,0.8286560521911194},
{0.17109688093229064,-0.03899928904944088,0.9844820530557576},
{0.21120989963999962,-0.18410862937369288,0.959944993676305},
{0.2338142631050874,-0.28341728898195795,0.9300567351913228},
{0.24319828667410556,-0.3283976864464485,0.9126935700964479},
{0.25511781677487344,-0.3996279089895705,0.8804614891752198},
{0.31330737690903504,-0.44691052263213454,0.8379197290522835},
{0.39422840912277896,-0.4640334394545141,0.7932571641709495},
{0.4577997848341516,-0.4110998067831362,0.7882996294992611},
{0.5465193088682795,-0.38301353210713823,0.7447263116453939},
{0.18480683613130508,-0.008700321830856896,0.9827363520900082},
{0.21471209077825718,-0.15150853168563558,0.9648543324772357},
{0.23189241492315976,-0.25409168879678695,0.9389692868169341},
{0.23510957973499344,-0.2905118371459617,0.9275377932973475},
{0.2076026189235567,-0.2615032988849233,0.9426118911240103},
{0.21501636336790214,-0.3022230000454885,0.9286706745275997},
{0.14631011842612174,-0.3086213434470346,0.9398649986115462},
{0.15550539224296567,-0.3576124004249808,0.9208319304007896},
{0.045903080429571815,-0.39072622056282585,0.9193616958367182},
{0.05639692955275347,-0.4511754364220278,0.8906515097985376},
{-0.03920186977776964,-0.5029239875316417,0.8634411828093446},
{-0.02870142620930339,-0.5747285589716605,0.817840639511091},
{-0.07610023933562907,-0.6255019672067803,0.7765024421040206},
{-0.07559978189494385,-0.6979979862787143,0.7120979456003903},
{-0.0819033798127034,-0.7281300469063412,0.6805280825707529},
{-0.10210252502666625,-0.7887195052745511,0.6062149918821261},
{-0.07910243520595231,-0.7891242935653219,0.6091187520094253},
{-0.10649998615500271,-0.8348998914630212,0.5399999298000138},
{-0.0598010357629092,-0.8034139152495192,0.5924102606345721},
{-0.09880236288676299,-0.8353199769161248,0.5408129336959658},
{-0.0855965415416071,-0.8107672416113907,0.5790766028825312},
{-0.04549933707948809,-0.783288587568418,0.6199909667974202},
{-0.0843000754486013,-0.7634006832439173,0.6404005731587695},
{-0.047602278775628795,-0.7385353545336526,0.6725321948867723},
{-0.12090248396704992,-0.6809139895216235,0.7223148401108368},
{-0.08910305673279273,-0.6557224949460403,0.7497257197819833},
{-0.20490831739740817,-0.5516223908072735,0.8085328190131991},
{-0.17260532927181316,-0.5275162873168102,0.8318256830144507},
{-0.3011203157674279,-0.3869261048502753,0.8715588016981517},
{-0.26221426877766385,-0.36882006989016947,0.8917485258163343},
{-0.32721114990990297,-0.21600736057621958,0.9199313471947426},
{-0.3724031784746925,-0.22410191271798763,0.9006076867194094},
{-0.3512972423274715,-0.1123991176703894,0.929492703510916},
{-0.3970241596551949,-0.11030671236767757,0.9111554454958389},
{-0.33982486759456265,-0.028102056443223104,0.9400687920508796},
{-0.38321130873258347,-0.015700463327509292,0.9235272536913905},
{-0.3014124772277476,0.07500310481778723,0.9505393483907568},
{-0.3398088878176928,0.09460247436007575,0.935724474193688},
{0.12810018254289018,-0.022700032347569146,0.9915014128905201},
{0.17309611317041765,-0.007299836084021079,0.9848778848153918},
{0.19170219883683107,-0.15640179393886477,0.9689111134742077},
{0.13220119113809828,-0.1917017272403437,0.9725087623434233},
{0.05190355811086693,-0.04200287939607728,0.9977683993682454},
{0.03550159672021954,-0.24981123551298148,0.9676435207460404},
{0.03980252754075081,-0.07400469944762712,0.9964632774272387},
{-0.046499702867848006,-0.4202973143087423,0.9061942094375024},
{-0.011999902441189727,-0.5264957196071992,0.8500930887712822},
{-0.037601998035249815,-0.32591731807680624,0.944650195321728},
{0.0074999330258971155,-0.054399514214507075,0.998491083514436},
{0.02329990330560192,-0.6145974494258772,0.7884967277453696},
{0.09999843903654987,-0.4738926025942098,0.8748863431307747},
{0.060597680971123,-0.6646745633911791,0.7446715019669191},
{0.06859856321813994,-0.6731859002689767,0.7362845786809976},
{0.055601098132532285,-0.649512828005031,0.7583149768686912},
{0.008400395835977906,-0.5796273126824756,0.814838396089857},
{-0.14440049312852604,-0.3166010811945384,0.9375032015789001},
{-0.19470148168391346,-0.18630141775918374,0.9630073285136551},
{0.018800202197261955,-0.1332014325891113,0.9909106573014292},
{0.011199722866286467,-0.08779782746963856,0.9960753524203526},
{-0.21070398023578032,-0.10570199672957752,0.9718183578221705},
{-0.06900500235393753,-0.46013335627603846,0.8851641678763783},
{0.02010016854061982,-0.05810048717462745,0.9981083691737634},
{-0.19930538630084815,-0.0445012026612531,0.9789264558449586},
{0.06900500235393753,-0.46013335627603846,0.8851641678763783},
{0.26221426877766385,-0.36882006989016947,0.8917485258163343},
{0.17260532927181316,-0.5275162873168102,0.8318256830144507},
{0.3011203157674279,-0.3869261048502753,0.8715588016981517},
{0.32721114990990297,-0.21600736057621958,0.9199313471947426},
{0.21070398023578032,-0.10570199672957752,0.9718183578221705},
{0.19930538630084815,-0.0445012026612531,0.9789264558449586},
{0.169410648640991,0.03670230699601163,0.9848619054406609},
{0.20490831739740817,-0.5516223908072735,0.8085328190131991},
{0.3724031784746925,-0.22410191271798763,0.9006076867194094},
{0.3512972423274715,-0.1123991176703894,0.929492703510916},
{0.3970241596551949,-0.11030671236767757,0.9111554454958389},
{0.33982486759456265,-0.028102056443223104,0.9400687920508796},
{0.06829839022591333,0.04439895352899784,0.9966765086115348},
{0.0378009359627618,-0.011000272370115867,0.9992247411108887},
{-0.169410648640991,0.03670230699601163,0.9848619054406609},
{-0.1212017592563035,0.1243018042537832,0.9848142946832317},
{0.11049912595537052,0.09739922957514108,0.9890921763118279},
{0.15250328419358805,0.12920278241187919,0.9798211006746069},
{0.18700520816757218,0.13290370141962748,0.9733271075374226},
{-0.06450307203196003,0.20730987336783432,0.9761464900836617},
{-0.24030185153289912,0.17870137689941354,0.9541073514254641},
{-0.2747057936062814,0.2013042455513085,0.9402198294453067},
{-0.17471034752675746,0.2725161402463733,0.9461560377508028},
{-0.20951114524181458,0.2956157256968038,0.9320495816962826},
{-0.13459924826529768,0.3484980536438056,0.9275948193974005},
{-0.1739980921213798,0.37319590792930424,0.9112900077598471},
{-0.11960007833807697,0.4098002684192637,0.9043005923170819},
{-0.16429825680474291,0.43929533910117813,0.8831906293971329},
{-0.11630297390506461,0.4669119390909257,0.876622415521751},
{-0.16330158893219052,0.498604851448807,0.8513082832698945},
{-0.14129624298284796,0.5609850836049377,0.8156783114020457},
{-0.09929786263650987,0.5199888073613811,0.8483817387796071},
{-0.0877999345890731,0.6046995494990035,0.7915994102586591},
{-0.047502388005069035,0.5540278516801737,0.8311417825476394},
{0.0025001305727288302,0.6283328155382095,0.7779406290103028},
{0.03460021209995026,0.5703034959711455,0.8207050309372595},
{0.10770359412890514,0.628120960746196,0.770625716209232},
{0.12920772039194703,0.5675339111643183,0.8131485870796603},
{0.20450576203101897,0.6134172832754379,0.7628214927983438},
{0.21691305747450385,0.5550334112418148,0.803048340949869},
{0.2764996668181023,0.6045992714583169,0.746999099866627},
{0.2824112444275498,0.5506219234483318,0.7855312765504262},
{0.32412579981984585,0.6040480811206013,0.7280579520791354},
{0.3256105418119395,0.554517952809338,0.7658247939790641},
{0.3619001266650665,0.6055002119251113,0.7088002480801302},
{0.3593876282938403,0.5606806988991548,0.7459743202760291},
{0.3974227630406484,0.6005343965926255,0.6938397408092648},
{0.38951436945013845,0.5614207111920609,0.7301269348794507},
{0.4411021393505638,0.5765027960453413,0.6878033358542683},
{0.42647872137503223,0.5444728342056391,0.7222639635385365},
{0.5061936878040694,0.524893454619431,0.6842914669386105},
{0.48420393659400685,0.5013040756187022,0.717105830094098},
{0.3619116627912532,0.4315139057596733,0.8263266288046768},
{0.4057228164641438,0.41402328325401905,0.8148458241434172},
{0.47041473126796807,0.3700115870942776,0.8011250876249346},
{0.3014124772277476,0.07500310481778723,0.9505393483907568},
{0.1212017592563035,0.1243018042537832,0.9848142946832317},
{0.38321130873258347,-0.015700463327509292,0.9235272536913905},
{0.3398088878176928,0.09460247436007575,0.935724474193688},
{0.06450307203196003,0.20730987336783432,0.9761464900836617},
{0.24030185153289912,0.17870137689941354,0.9541073514254641},
{0.2747057936062814,0.2013042455513085,0.9402198294453067},
{0.17471034752675746,0.2725161402463733,0.9461560377508028},
{0.0020999718395664454,0.31349579604956224,0.9495872661201413},
{0.017500134139042268,0.34590265135398396,0.9381071906191742},
{-0.022299846243090227,0.2710981307848323,0.9622933650101223},
{0.03330101020146693,0.36901119412436323,0.9288281764301045},
{0.13459924826529768,0.3484980536438056,0.9275948193974005},
{0.022299846243090227,0.2710981307848323,0.9622933650101223},
{-0.0020999718395664454,0.31349579604956224,0.9495872661201413},
{0.11960007833807697,0.4098002684192637,0.9043005923170819},
{-0.017500134139042268,0.34590265135398396,0.9381071906191742},
{0.20951114524181458,0.2956157256968038,0.9320495816962826},
{0.1739980921213798,0.37319590792930424,0.9112900077598471},
{0.16429825680474291,0.43929533910117813,0.8831906293971329},
{0.11630297390506461,0.4669119390909257,0.876622415521751},
{-0.03330101020146693,0.36901119412436323,0.9288281764301045},
{0.14129624298284796,0.5609850836049377,0.8156783114020457},
{0.16330158893219052,0.498604851448807,0.8513082832698945},
{0.09929786263650987,0.5199888073613811,0.8483817387796071},
{0.047502388005069035,0.5540278516801737,0.8311417825476394},
{-0.06720506342022431,0.37822849680846476,0.9232695617492721},
{-0.11960331245960848,0.3778104636056864,0.9181254278358407},
{-0.17900651774596885,0.37071349792419356,0.9113331822452593},
{-0.23638747652323192,0.36338074859789543,0.9011522582180059},
{-0.28030489276460513,0.36740641313491235,0.8868154794992931},
{-0.3082220741142848,0.3808272739218679,0.871762433502343},
{-0.3284982211869484,0.40069783022712396,0.8552953685881185},
{-0.3427965154911299,0.42199571043540496,0.8392914686455816},
{-0.3619116627912532,0.4315139057596733,0.8263266288046768},
{-0.4057228164641438,0.41402328325401905,0.8148458241434172},
{-0.47041473126796807,0.3700115870942776,0.8011250876249346},
{-0.3440200827585136,0.18251065437043237,0.9210537680831136},
{0.11960331245960848,0.3778104636056864,0.9181254278358407},
{0.17900651774596885,0.37071349792419356,0.9113331822452593},
{0.23638747652323192,0.36338074859789543,0.9011522582180059},
{0.06720506342022431,0.37822849680846476,0.9232695617492721},
{-0.03460021209995026,0.5703034959711455,0.8207050309372595},
{-0.0025001305727288302,0.6283328155382095,0.7779406290103028},
{-0.10770359412890514,0.628120960746196,0.770625716209232},
{-0.12920772039194703,0.5675339111643183,0.8131485870796603},
{-0.21691305747450385,0.5550334112418148,0.803048340949869},
{-0.2824112444275498,0.5506219234483318,0.7855312765504262},
{-0.3256105418119395,0.554517952809338,0.7658247939790641},
{-0.3593876282938403,0.5606806988991548,0.7459743202760291},
{-0.38951436945013845,0.5614207111920609,0.7301269348794507},
{-0.42647872137503223,0.5444728342056391,0.7222639635385365},
{-0.48420393659400685,0.5013040756187022,0.717105830094098},
{-0.5585420877320256,0.4327326076305237,0.7076533236869854},
{-0.5511296901561346,0.2931157905729687,0.7812420866448417},
{-0.41379912274678965,0.12019974517681033,0.9023980869180835},
{-0.6188402197328632,0.20331321375515687,0.7587493127203027},
{-0.457480724455754,0.06189739200833042,0.8870626244037144},
{-0.6617347651491047,0.12020631520465828,0.7400388789637864},
{-0.7066109772867989,0.23790369586262305,0.666410352765246},
{-0.749509601279489,0.14370184083237164,0.6462082779810617},
{0.0877999345890731,0.6046995494990035,0.7915994102586591},
{-0.20450576203101897,0.6134172832754379,0.7628214927983438},
{-0.2764996668181023,0.6045992714583169,0.746999099866627},
{-0.32412579981984585,0.6040480811206013,0.7280579520791354},
{-0.3619001266650665,0.6055002119251113,0.7088002480801302},
{-0.3974227630406484,0.6005343965926255,0.6938397408092648},
{-0.4411021393505638,0.5765027960453413,0.6878033358542683},
{-0.5061936878040694,0.524893454619431,0.6842914669386105},
{-0.5871555064336588,0.44624218526775433,0.6753638451620675},
{-0.639817735993466,0.33960941410344025,0.6894191109626375},
{-0.6699070307111812,0.3454036250300671,0.6572068974225828},
{-0.7349123062096021,0.23990401722640298,0.6343106216202893},
{0.3082220741142848,0.3808272739218679,0.871762433502343},
{0.3284982211869484,0.40069783022712396,0.8552953685881185},
{0.3427965154911299,0.42199571043540496,0.8392914686455816},
{0.28030489276460513,0.36740641313491235,0.8868154794992931},
{0.3440200827585136,0.18251065437043237,0.9210537680831136},
{0.5511296901561346,0.2931157905729687,0.7812420866448417},
{0.5585420877320256,0.4327326076305237,0.7076533236869854},
{0.5871555064336588,0.44624218526775433,0.6753638451620675},
{0.639817735993466,0.33960941410344025,0.6894191109626375},
{0.6699070307111812,0.3454036250300671,0.6572068974225828},
{0.7066109772867989,0.23790369586262305,0.666410352765246},
{0.7349123062096021,0.23990401722640298,0.6343106216202893},
{0.749509601279489,0.14370184083237164,0.6462082779810617},
{0.7757591383732633,0.143710955503723,0.61444684106811},
{0.7718838446401958,0.06639861029162974,0.6322867663764682},
{0.7970087472190014,0.0664007287519971,0.6003065884009617},
{0.7813726055566653,0.010399635395174456,0.6239781237104673},
{0.8068032393215088,0.011800047377285329,0.5907023716747835},
{0.7859045543300885,-0.03760021789389405,0.6172035767050905},
{0.8130500488361816,-0.03670225927710685,0.581035766757468},
{0.7856179044360655,-0.09410214461231385,0.6115139365614232},
{0.8143073206557192,-0.09680087024373525,0.5723051450463811},
{0.7742675627399244,-0.1600932930319797,0.6122743493034427},
{0.8032445451614122,-0.16980941704234037,0.5709316618932397},
{0.743647557782029,-0.23331492096630896,0.6265400685186135},
{0.7699515653830584,-0.2529169384145674,0.5858392349673927},
{0.6897279379959542,-0.2997121400861063,0.6591266984676432},
{0.710502536498583,-0.3270011673962514,0.6231022244789121},
{0.621805658457238,-0.3480031668432274,0.7016063846471505},
{0.6374212105436771,-0.37871260187149436,0.6710223286394844},
{0.5576111606990732,-0.41500830647438197,0.7189143892155017},
{0.6358925410242404,-0.19169775139856407,0.7475912308062937},
{0.666248644589377,-0.13851011299253785,0.7327535002861552},
{0.6824114304871918,-0.08750146566182485,0.7257121557804148},
{0.6890031797570119,-0.04090018875480666,0.7236033394371173},
{0.6896971239689895,0.0011999949960312998,0.7240969805218868},
{0.6830500352476899,0.051503772789540304,0.7285533684889343},
{0.6617347651491047,0.12020631520465828,0.7400388789637864},
{0.6188402197328632,0.20331321375515687,0.7587493127203027},
{0.41379912274678965,0.12019974517681033,0.9023980869180835},
{0.4693300991044143,-0.4570293102295277,0.7555484548761666},
{-0.710502536498583,-0.3270011673962514,0.6231022244789121},
{-0.7699515653830584,-0.2529169384145674,0.5858392349673927},
{-0.7859045543300885,-0.03760021789389405,0.6172035767050905},
{-0.6890031797570119,-0.04090018875480666,0.7236033394371173},
{-0.6824114304871918,-0.08750146566182485,0.7257121557804148},
{-0.7856179044360655,-0.09410214461231385,0.6115139365614232},
{-0.666248644589377,-0.13851011299253785,0.7327535002861552},
{-0.7742675627399244,-0.1600932930319797,0.6122743493034427},
{-0.8143073206557192,-0.09680087024373525,0.5723051450463811},
{-0.803280022674251,-0.16979577723152975,0.570885802246645},
{-0.7813726055566653,0.010399635395174456,0.6239781237104673},
{-0.6896971239689895,0.0011999949960312998,0.7240969805218868},
{-0.8068032393215088,0.011800047377285329,0.5907023716747835},
{-0.8130500488361816,-0.03670225927710685,0.581035766757468},
{-0.4813325704703586,-0.017701197792074273,0.8763593008584567},
{-0.6830500352476899,0.051503772789540304,0.7285533684889343},
{-0.4778205515038898,0.014500623685237342,0.8783377781202729},
{-0.7757591383732633,0.143710955503723,0.61444684106811},
{-0.7718838446401958,0.06639861029162974,0.6322867663764682},
{-0.7970087472190014,0.0664007287519971,0.6003065884009617},
{-0.5406306519237408,0.6127347399809028,-0.5764326817773663},
{-0.48128695970648777,0.4652873932088692,-0.7428798719425509},
{-0.4957984208845442,0.37079881900764217,-0.7852974988314493},
{-0.505713467328955,0.38801033285274766,-0.7705205192346445},
{-0.5011035728812121,0.4498032071083001,-0.7393052712653763},
{-0.4385987806970845,0.6445982080194725,-0.6261982591712593},
{-0.4805092114498761,0.7710147804950145,-0.41790801137336775},
{0.6908029151944531,0.6986029481106615,-0.18640078661297926},
{0.5532011838518002,0.8302017766337031,-0.06880014723247262},
{0.4678057236380433,0.8835108098208877,0.02380029119834423},
{0.6083939039236239,0.780792176501587,-0.14219857517741505},
{0.35219259698941613,0.8701817089727141,0.34459275673637935},
{0.5430284418594831,0.8273433332418976,-0.14360752164092408},
{0.6577059917288771,0.6425058532549849,-0.3932035821009495},
{0.5406306519237408,0.6127347399809028,-0.5764326817773663},
{0.669939601300284,0.49012897237986136,-0.5576329626586629},
{0.48128695970648777,0.4652873932088692,-0.7428798719425509},
{0.3539221084350267,0.4819301047042649,-0.8015500703890192},
{0.3357956111800426,0.39849479170710833,-0.8534888449736937},
{0.2346106163705916,0.45252047701488796,-0.8603389312174764},
{0.21981124143433778,0.37581921988637007,-0.90024603975974},
{0.10660573500977642,0.44262381158843384,-0.890347897553508},
{0.12850849854802276,0.6930458326364184,-0.7093469106623544},
{-0.0535000080250018,0.5844000876600197,-0.8097001214550272},
{-0.0724020877443006,0.7909228065879467,-0.6076175209038265},
{0.08010274717082215,0.9546327396912212,-0.28680983631200735},
{0.21150426714163478,0.8716175850621697,-0.4422089216549925},
{0.22031417326666403,0.8814567059338977,-0.4177268732341605},
{0.25721254584789305,0.9390458030760949,-0.22811112639154127},
{0.278810659135252,0.9467361944165821,-0.16110615920620194},
{0.28119992548202966,0.9504997481176002,0.13219996496701394},
{0.26630237809085455,0.9578085532685712,0.10810096534593083},
{0.7663203307480657,0.5665150298431153,-0.30300803890990985},
{0.7936125669544973,0.478407575643941,-0.37590595251788755},
{0.7865257591404247,0.4640151967465443,-0.40751334628063957},
{0.6623327829724099,0.42842120523234245,-0.6146304218856155},
{0.4957984208845442,0.37079881900764217,-0.7852974988314493},
{0.34150206780128084,0.3108018819110925,-0.8870053708337806},
{0.20731631954641494,0.30082368026802514,-0.9308732765740618},
{0.07580233285269088,0.3784116457976019,-0.9225283912481177},
{-0.09440140989558525,0.5289078992984645,-0.8434125964611929},
{-0.31101119038394864,0.6952250146460486,-0.6480233162983882},
{-0.303904772861937,0.7253113911048467,-0.6177097012070368},
{-0.3007967980351272,0.8040914404921735,-0.5127945413311611},
{-0.2288110598498732,0.8990434563157169,-0.37331804476380104},
{-0.043801437367751224,0.9493311528129278,-0.31121021253068903},
{-0.14860452581975184,0.98633003913877,0.07120216849506279},
{-0.0575973076767775,0.9777542959436292,0.20169057219454897},
{0.8138890085031598,0.5547925075777774,-0.17259766908421845},
{0.7554259568818253,0.5114175726096974,-0.40961407458140814},
{0.6491019830095872,0.448801371090283,-0.6142018763895986},
{0.505713467328955,0.38801033285274766,-0.7705205192346445},
{0.3634246755560488,0.34732358233521116,-0.8644586944156537},
{0.21511109356515012,0.35991856147883555,-0.9078468188677047},
{0.06200196859375478,0.43451379603203955,-0.8985285287336882},
{-0.09670529524341555,0.5678310924427233,-0.8174447604133183},
{-0.27560262237142785,0.7256069041825401,-0.630505999293125},
{-0.4704100762917524,0.7944170165947452,-0.38420822982842534},
{-0.47700952836049443,0.7921158226715884,-0.38080760670791675},
{-0.4461029219837085,0.8237053952880087,-0.350002292522524},
{-0.4134242025612477,0.8644506064197931,-0.28601674391029713},
{-0.3450939367527965,0.8662847795101349,-0.3611936538832515},
{-0.3445871574759568,0.897666544591313,-0.27468976250332366},
{-0.30519864339504515,0.9175959212951946,-0.25469886786604845},
{-0.19260655258638038,0.9582325996275685,-0.2114071921950198},
{-0.26211931759494145,0.9642710645747522,0.03840283020086132},
{0.5806300280583716,0.5386278558598673,-0.6105315744568307},
{0.6589414981475599,0.632039803960021,-0.40782568363116545},
{0.5011035728812121,0.4498032071083001,-0.7393052712653763},
{0.39850824522089134,0.4774098777125559,-0.783116202841857},
{0.2369017128055754,0.5268038088053066,-0.8163059019130063},
{0.061198573783856756,0.5840863880253387,-0.8093811375923801},
{-0.07330381373011655,0.6265325962062485,-0.7759403693478504},
{-0.15470490886463864,0.7694244142240011,-0.6197196640169139},
{-0.40420813072832523,0.833716770381506,-0.3762075674913309},
{-0.558894195913913,0.8229914532781363,-0.10159894490043578},
{-0.5726997852376209,0.8124996953126715,-0.10889995916252299},
{-0.5400946908952827,0.8340918009178953,-0.11219889709026237},
{-0.4010254478772182,0.8885563851344348,-0.22281413911981102},
{-0.39292754715132344,0.8993630520569741,-0.1917134405418903},
{-0.3641334253412385,0.901982796801052,-0.23202129821248926},
{-0.3517186169591065,0.9115482495258048,-0.21301127498518535},
{-0.3020997492573122,0.9409992189709724,-0.1524998734251576},
{0.7028860900219163,0.6925862938528656,-0.1620967921362251},
{0.501916495756704,0.8505279530605235,-0.15710516334604144},
{0.4805092114498761,0.7710147804950145,-0.41790801137336775},
{0.4385987806970845,0.6445982080194725,-0.6261982591712593},
{0.25361693964111687,0.723948354125412,-0.6415428500779828},
{0.04610019408222563,0.773103254771554,-0.6326026632628186},
{-0.25411542654521685,0.8713528970832249,-0.4197254802086876},
{-0.0025001053816628024,0.9144385443969866,-0.4047170591835745},
{0.2387160255447103,0.8926599262723436,-0.3823256663835054},
{-0.25361693964111687,0.723948354125412,-0.6415428500779828},
{-0.04610019408222563,0.773103254771554,-0.6326026632628186},
{0.15470490886463864,0.7694244142240011,-0.6197196640169139},
{0.40420813072832523,0.833716770381506,-0.3762075674913309},
{-0.2369017128055754,0.5268038088053066,-0.8163059019130063},
{-0.061198573783856756,0.5840863880253387,-0.8093811375923801},
{0.07330381373011655,0.6265325962062485,-0.7759403693478504},
{0.27560262237142785,0.7256069041825401,-0.630505999293125},
{0.4704100762917524,0.7944170165947452,-0.38420822982842534},
{-0.39850824522089134,0.4774098777125559,-0.783116202841857},
{-0.21511109356515012,0.35991856147883555,-0.9078468188677047},
{-0.06200196859375478,0.43451379603203955,-0.8985285287336882},
{0.09670529524341555,0.5678310924427233,-0.8174447604133183},
{0.31101119038394864,0.6952250146460486,-0.6480233162983882},
{0.47700952836049443,0.7921158226715884,-0.38080760670791675},
{0.0025001053816628024,0.9144385443969866,-0.4047170591835745},
{0.25411542654521685,0.8713528970832249,-0.4197254802086876},
{-0.2387160255447103,0.8926599262723436,-0.3823256663835054},
{-0.48090952691209315,0.8711172570037936,-0.09940196917251416},
{-0.043202258457092815,0.9900517563083769,-0.13390700017140572},
{0.24069307656322755,0.9589724155551941,-0.14979569118891353},
{-0.30371097327570024,0.9461341844456371,-0.11220405400570814},
{0.5400946908952827,0.8340918009178953,-0.11219889709026237},
{0.4461029219837085,0.8237053952880087,-0.350002292522524},
{0.0535000080250018,0.5844000876600197,-0.8097001214550272},
{0.09440140989558525,0.5289078992984645,-0.8434125964611929},
{0.303904772861937,0.7253113911048467,-0.6177097012070368},
{0.3007967980351272,0.8040914404921735,-0.5127945413311611},
{0.4134242025612477,0.8644506064197931,-0.28601674391029713},
{0.49409536046634783,0.8633918927881901,-0.10209904129450337},
{0.0724020877443006,0.7909228065879467,-0.6076175209038265},
{0.2288110598498732,0.8990434563157169,-0.37331804476380104},
{0.3450939367527965,0.8662847795101349,-0.3611936538832515},
{0.4010254478772182,0.8885563851344348,-0.22281413911981102},
{0.46163160899843925,0.882960458372448,-0.08530584109091609},
{0.4363947196558381,0.8967891489169468,-0.07299911671603157},
{0.39292754715132344,0.8993630520569741,-0.1917134405418903},
{0.41331351763964524,0.9083297074088792,-0.06410209649334929},
{0.37662112715470825,0.9084509609860248,-0.1813101708793112},
{0.3445871574759568,0.897666544591313,-0.27468976250332366},
{0.3641334253412385,0.901982796801052,-0.23202129821248926},
{0.3613160951839479,0.9061403649216031,-0.21990979610005576},
{0.39800978718100166,0.8989221047663377,-0.1831045025950789},
{0.4368213501652468,0.8976438734164961,-0.05850285939713127},
{0.30519864339504515,0.9175959212951946,-0.25469886786604845},
{0.3517186169591065,0.9115482495258048,-0.21301127498518535},
{0.3642053465737318,0.9094133502859739,-0.20080294780891092},
{0.3853138156745459,0.89483208477961,-0.2254080821516809},
{0.5098247882838242,0.8356406298351579,-0.20440993865283183},
{0.19260655258638038,0.9582325996275685,-0.2114071921950198},
{0.3020997492573122,0.9409992189709724,-0.1524998734251576},
{0.36510537073950566,0.9224135688033964,-0.12590185202986515},
{0.3876203486643187,0.9139479789585162,-0.1202063103959007},
{0.39399940112136544,0.8947986399071011,-0.20999968080072776},
{0.4913198349821154,0.8329336262092487,-0.2546102788244384},
{-0.37662112715470825,0.9084509609860248,-0.1813101708793112},
{-0.3613160951839479,0.9061403649216031,-0.21990979610005576},
{-0.3642053465737318,0.9094133502859739,-0.20080294780891092},
{-0.36510537073950566,0.9224135688033964,-0.12590185202986515},
{-0.39800978718100166,0.8989221047663377,-0.1831045025950789},
{-0.3853138156745459,0.89483208477961,-0.2254080821516809},
{-0.39399940112136544,0.8947986399071011,-0.20999968080072776},
{-0.3876203486643187,0.9139479789585162,-0.1202063103959007},
{0.4971126143926374,0.8330211381795753,-0.2428061612845149},
{0.6621233700567766,0.6880242842456762,-0.2970104831700085},
{0.6596667635274084,0.6961649246138879,-0.28318573204632724},
{-0.6932940272976823,0.6796941444601682,-0.23949793673416253},
{-0.5098247882838242,0.8356406298351579,-0.20440993865283183},
{-0.4913198349821154,0.8329336262092487,-0.2546102788244384},
{-0.6621233700567766,0.6880242842456762,-0.2970104831700085},
{-0.4971126143926374,0.8330211381795753,-0.2428061612845149},
{-0.7595982339361591,0.6456984987527356,-0.07799981865063245},
{-0.8601121878760539,0.43580617541725886,-0.2651037565468456},
{-0.8248129620375484,0.46530731236187106,-0.321205047776989},
{-0.6596667635274084,0.6961649246138879,-0.28318573204632724},
{-0.8194912069065247,0.4919947209249666,-0.2938968465037554},
{-0.6737400685133471,0.7096422036768164,-0.2061122578604733},
{-0.8256719191563742,0.5260458205865466,-0.20381775329950225},
{-0.6954947490344672,0.7148946025661259,-0.0721994548961733},
{-0.8310320743018734,0.5510212670762122,-0.07590292953009892},
{-0.7125033131481092,0.6943032285175189,0.1014004715132888},
{-0.8378025804359216,0.5404016644396897,0.07780023962510707},
{-0.7109991752414352,0.638599259225289,0.2943996584965943},
{-0.8416371969778988,0.4844214094772982,0.23871055004589406},
{-0.9279425239405117,0.36131655771064436,0.0915041932757375},
{-0.923889292185155,0.3220962669258993,0.20659760554762746},
{-0.8346234824620232,0.4244119409979423,0.35110987861540427},
{-0.9185008909462964,0.2741002658773869,0.2850002764504022},
{-0.8283033380691787,0.40070161483076167,0.39160157815753993},
{-0.9168901618213451,0.25289728642667486,0.3087966866293286},
{-0.8334912942288973,0.40579576148540675,0.3749960831863665},
{-0.9232183122168361,0.25720510171378924,0.2855056630609908},
{-0.8523064008451056,0.428803220324277,0.29950224927033803},
{-0.9360442853027313,0.2803132619341406,0.21271006355116553},
{-0.8739316980775442,0.446516195436118,0.1920069642188906},
{-0.732506398471336,0.5722049982324894,0.3688032215102099},
{-0.769714586229615,0.587611135336523,0.24950472815939836},
{-0.8901095865318708,0.4459048024205833,0.0942010145503901},
{-0.7969701802992255,0.5878517655664258,0.13881222364855378},
{-0.9017328867980832,0.4321157595491314,0.012400452252740637},
{-0.8158803742336439,0.5766861279820351,0.042098987321039845},
{-0.708414519104355,0.6862140641013671,0.16510338382852768},
{-0.7298064515175472,0.6812060218878503,0.057800510958775315},
{-0.8274732482223204,0.560381883146572,-0.03549885234065543},
{-0.7438208644678765,0.6675187241628228,-0.033900950935010776},
{-0.6774405460300562,0.7327438560322146,0.06450386067159525},
{-0.6872032710953556,0.7258034548326675,-0.031000147561053584},
{-0.75411950555327,0.6445166706392819,-0.12610326170304645},
{-0.6931044844005211,0.7084045833924818,-0.13330086245937017},
{-0.6649245029194073,0.7350270862472015,-0.1327048902653111},
{-0.6701023654655252,0.7418026185678653,-0.026300092839491584},
{-0.6341302265376391,0.7631363757622968,-0.12450593471682078},
{-0.6486763529345729,0.7608722629072244,-0.017099376653585935},
{-0.9245458817278495,0.37011836757974803,-0.09070450132256998},
{-0.9892038677946846,0.11350044378760282,-0.09270036245912583},
{-0.9452967198260734,0.19339932890549305,-0.2626990884357447},
{-0.9244373618909866,0.2341094617250973,-0.30101216565251726},
{-0.9317923686517511,0.2682978026499944,-0.24449799756959983},
{-0.9396132862258015,0.31300442591387384,-0.13840195701750843},
{-0.9346566372349518,0.35462148894020323,-0.025701557433060414},
{-0.989047376504029,0.1424068214501251,0.038801858653545324},
{-0.9778514167792769,0.17380913912480908,0.11660613131158078},
{-0.9679534421848552,0.16860930917694658,0.18611027543196773},
{-0.9618860960369721,0.14929784191529258,0.22909668843130293},
{-0.9619663875911905,0.13940962098992823,0.23491621212721764},
{-0.9679217881646801,0.1461032888220475,0.20440460119936008},
{-0.9756279960470255,0.17100490705621296,0.137503945732335},
{-0.9465022952708491,0.3007007292001525,0.11710028396853293},
{-0.9522447375086769,0.30341425473653916,0.03420160682923414},
{-0.9559847617243462,0.29179534881920943,-0.030799509059738352},
{-0.9115551234050189,0.40842469818827176,-0.047502872585560504},
{-0.8353199769161247,0.5372128475988773,-0.11680279337220563},
{-0.8372318949565691,0.5021191285925625,-0.21660825184853422},
{-0.756104907136771,0.6075039427133824,-0.24340157968137824},
{-0.6904070559961686,0.6736068842975365,-0.2638026960773309},
{-0.6502096589362258,0.7103105517416198,-0.2696040049972416},
{-0.6078882496337007,0.7482855357803886,-0.2655948661008569},
{-0.9931441313399859,-0.0796035372617691,-0.08560380388954063},
{-0.9705676412159566,-0.010100703942587493,-0.24061676916698524},
{-0.9674834223135869,0.022899607618585158,-0.2518956838044367},
{-0.9853273382862564,0.04690130129465688,-0.16410455314399136},
{-0.9947284794840573,0.08930255676880096,-0.05040144301397053},
{-0.9922307745147148,-0.12230379331097523,0.022800707174899716},
{-0.9939214838450624,-0.06340137043543309,0.09000194541307538},
{-0.9906474333346893,-0.013200632061395011,0.13580650257101837},
{-0.9861929734000966,0.01409989953857368,0.16499882438756433},
{-0.984640858520154,0.024901033289814984,0.17280717078233052},
{-0.986577777585837,0.028999346797070013,0.1606963803547983},
{-0.9913945820434137,0.03689979834315309,0.12559931360162674},
{-0.9947979905100888,0.06479986910439661,0.07859984122848108},
{-0.9782561681903913,0.19921143805308314,0.05770331313083785},
{-0.9764399323275655,0.21550881341314046,-0.011000449872596497},
{-0.9736619852950387,0.21841390467177121,-0.06540416376160181},
{-0.9596899664938502,0.2708971677849161,-0.07489921693278043},
{-0.9185448031154345,0.3798185261004269,-0.10960534613113951},
{-0.9154233252834961,0.352208974399003,-0.19480496369371317},
{-0.8283200911474692,0.44741085208182746,-0.3372081790835767},
{-0.7473395577297136,0.5434287644457733,-0.3823202367457106},
{-0.675853942055759,0.6095486500192145,-0.41433306924193697},
{-0.6222041034495934,0.6551043204272399,-0.4286028266449626},
{-0.9560561556074978,-0.20271190663351443,-0.21181244116910883},
{-0.9634685724985439,-0.18131290449863607,-0.19711402910469483},
{-0.9825252020946548,-0.16390420419675716,-0.08820226241704687},
{-0.9374517862670497,-0.3470191698684299,-0.02760152475034198},
{-0.9516272359612454,-0.29780852340191144,0.07560216376489087},
{-0.9631370381469666,-0.24280933741260874,0.11580445334588177},
{-0.970153078526929,-0.19391060913964697,0.14560796642977103},
{-0.9788667044153143,-0.1460950306620466,0.1430951327018403},
{-0.9872527404501299,-0.11540616516201883,0.10960585530118946},
{-0.9913676829821547,-0.10760734660433759,0.07490511394669967},
{-0.9927581326544863,-0.11080648846390356,0.04640271719065998},
{-0.9928223586112767,-0.11540259889579102,0.031400707151887676},
{-0.9999238484681823,0.012300293365495192,0.0010000238508532677},
{-0.99304535838264,0.11620530779865333,0.018900863316648434},
{-0.9882405384583485,0.14960613696961034,-0.03160129631176262},
{-0.9810522326113335,0.1776094561791772,-0.07740412110511438},
{-0.9725458906605517,0.20930987651954086,-0.10170479905416772},
{-0.9618720772588898,0.24659284151371477,-0.11829656590053714},
{-0.9544233550252498,0.22790557691770158,-0.19270471554208468},
{-0.8976186975922082,0.32170670122038036,-0.3013062762751029},
{-0.8144969252799106,0.36209863308024015,-0.45329828880218964},
{-0.7301953048592845,0.4418971586104052,-0.5210966493593169},
{-0.6505072141650079,0.5071056238325526,-0.5654062703903082},
{-0.8998344913170909,-0.39731522938461905,-0.18010690362992673},
{-0.9154214714624227,-0.37480879124329913,-0.1467034409695624},
{-0.8530586660437309,-0.5216747228636907,0.012099413737110707},
{-0.8764860026303061,-0.46869251504030174,0.10999824334208064},
{-0.9050266896306217,-0.39991179357269124,0.14490427329002992},
{-0.9275089273163885,-0.33730324655937227,0.16110155060988698},
{-0.9471946862527152,-0.2936983523568649,0.12869927799907566},
{-0.9642599354389887,-0.2578160250530712,0.061103798024603},
{-0.9716296060051494,-0.236507206484374,-0.000500015235696351},
{-0.9710988055492037,-0.23289971353352854,-0.05219993579411846},
{-0.9608837563973961,-0.2713954120993374,-0.05519906686766184},
{-0.9667521141773601,-0.2557137846231002,0.0009000485184231137},
{-0.991770896910039,-0.12669628215214956,0.018399460075765997},
{-0.9971407091004405,0.07250295999376385,-0.02130086962575407},
{-0.9653136061911696,-0.2496035181863834,-0.0766010796998276},
{-0.9041237832889332,-0.4217110932562141,-0.06870180722480888},
{-0.8166153933452481,-0.5743108258611022,-0.05750108390564753},
{-0.8084137593192765,-0.5688096812231623,-0.1514025768937883},
{-0.8257061845624837,-0.5537041472595945,-0.10780080743107151},
{-0.7739592836818374,-0.6316483829609103,0.04480343185029889},
{-0.8031126852650464,-0.5786091392035311,0.1422022461022159},
{-0.8327786728112805,-0.5232865988018048,0.18069537245076656},
{-0.8636119092903443,-0.4705064883292113,0.18110249742065926},
{-0.8961210322074418,-0.422809923465357,0.13490316621446702},
{-0.9244976471564819,-0.37719904002966465,0.05499986002553435},
{-0.9403982602648278,-0.3384993737767378,-0.03269993950516787},
{-0.941786532548876,-0.3193954326779688,-0.10499849853220639},
{-0.9358548988585977,-0.33021937123649175,-0.12300721581492577},
{-0.9429475917659649,-0.3284165756028666,-0.054702760918017054},
{-0.9437315730679243,-0.32981103401271744,0.024400816342966362},
{-0.9624463862214028,-0.2627126617418563,0.06840329677633411},
{-0.9788216860346839,-0.14550322365963067,0.14400319042602622},
{-0.999286279893565,-0.010099861329855905,0.036399500238292574},
{-0.9870235407921751,0.16010381852160813,-0.012300293365495192},
{-0.7309222971247659,-0.6807207657036914,-0.0487014856614805},
{-0.7191468683286633,-0.6826444893911077,-0.1297084533753687},
{-0.7408046152271293,-0.6673041573178501,-0.0769004790914771},
{-0.6995321162567029,-0.7112326534406964,0.0693031817821151},
{-0.7278581399909904,-0.665053123239913,0.1671133487118638},
{-0.7547274952234856,-0.6224226752710976,0.20730755235170076},
{-0.7849270412023622,-0.5830200853879183,0.20970722453833016},
{-0.826294972010393,-0.5391967189979473,0.16279900937104197},
{-0.8737894534249454,-0.4798942077118692,0.07869905010819776},
{-0.9059996285402284,-0.4228998266111066,-0.01789999266100451},
{-0.9192865181255228,-0.3783356068395184,-0.10851021237665276},
{-0.9200353116329038,-0.36321394041855504,-0.14700564218482265},
{-0.9280182589388687,-0.35680702024718575,-0.10710210725469056},
{-0.9294019703342656,-0.3684007810104836,-0.022200047064149665},
{-0.9214396365784694,-0.3785162822280776,0.08760376835714556},
{-0.9282901184042841,-0.3381963999184842,0.1545983543092775},
{-0.920011072399885,-0.29080349984118103,0.2627031616515758},
{-0.8700625423433963,-0.2318166635806888,0.43503127117169815},
{-0.9329395854664349,-0.058702490799528065,0.3552150720952703},
{-0.9827120530372462,0.05330065373652714,0.17730217462450776},
{-0.9480972410410428,0.2885991601776658,0.1334996115166957},
{-0.9527256953585105,0.29340791331813476,-0.0789021280190894},
{-0.971886291640534,0.20859705775925033,-0.10919845976658743},
{-0.970704217718989,0.193900842500991,-0.1419006165595184},
{-0.9602922312672734,0.17719856646939586,-0.2154982566261558},
{-0.9297263813603619,0.22040625411619208,-0.29500837098129157},
{-0.8724480034097577,0.2934161442003931,-0.3908215035907076},
{-0.7993476665225745,0.26751595245188126,-0.5380320838097649},
{-0.7118645548048773,0.3206290759629723,-0.6248566645716316},
{-0.6302082746889703,0.38030499343734603,-0.676908887872047},
{0.7191468683286633,-0.6826444893911077,-0.1297084533753687},
{0.7408046152271293,-0.6673041573178501,-0.0769004790914771},
{0.6656085431404771,-0.7444095545579495,-0.053100681551621606},
{0.643330690822676,-0.7573361295818631,-0.11210534811320066},
{0.6554038079071859,-0.7541043813591836,-0.04210024460313172},
{0.5935134283932277,-0.8041181933799401,-0.03370076248837704},
{0.5347130525049194,-0.8447206198820001,-0.023000561450557594},
{0.47150619091693036,-0.8818115782620345,-0.009500124737456709},
{0.40822585580339193,-0.9128578176808823,0.0065004117166145205},
{0.3496051304929353,-0.9365137434400282,0.026800393298657507},
{0.31350852598029766,-0.9480257819117134,0.054401479468351485},
{0.3164030058428334,-0.9448089757279043,0.08500080751150707},
{0.3674952722037345,-0.9227881284070917,0.11579851026174817},
{0.5278981338833951,-0.8370970408671907,0.14349949273018978},
{0.8060184016101656,-0.569713006696416,0.16050366434048582},
{0.5825925282987366,-0.8064896568364762,-0.10079870726486895},
{0.5255153189948263,-0.8452246386573304,-0.0971028305887681},
{0.46282987663283603,-0.8809568676012647,-0.09850635879069652},
{0.4003122217186964,-0.9109278110506135,-0.09980304703353961},
{0.34170172559807144,-0.9350047217857677,-0.0949004792486303},
{0.30470043572193467,-0.94870135664391,-0.08440012069225888},
{0.311414242856103,-0.9481433643284239,-0.06360290894556246},
{0.36911614733905573,-0.9293406548961921,-0.008900389356048756},
{0.5176033489045011,-0.8533055209045805,0.06290040696694962},
{0.7778078792337252,-0.6173062533440197,0.1181011963711789},
{0.627620479590379,-0.7743252666456827,0.08070263336989097},
{0.6005137459169678,-0.7986182805816661,-0.03990091334235973},
{0.5379048330966382,-0.8421075663704758,-0.03890034952121067},
{0.4724229225163142,-0.8802427104124889,-0.04460216414950807},
{0.4105161130736634,-0.9105357392291609,-0.049001923363238754},
{0.3557110805727425,-0.9336290829989101,-0.04250132393686127},
{0.306304027924451,-0.949912491431394,-0.06200081531608215},
{0.3117928210529419,-0.9458782214046753,-0.08999792782156758},
{0.3820270007124467,-0.9229652328730814,-0.04680330794068719},
{0.5010974393986269,-0.8625955921477861,0.06949964485772217},
{-0.6656085431404771,-0.7444095545579495,-0.053100681551621606},
{-0.643330690822676,-0.7573361295818631,-0.11210534811320066},
{-0.627620479590379,-0.7743252666456827,0.08070263336989097},
{-0.646399376224903,-0.742399283585037,0.17609983006374602},
{-0.6581293762603286,-0.72143220184501,0.21540961502275457},
{-0.6655173768855688,-0.7128186119369397,0.22130577836931084},
{-0.6832517309468991,-0.709753737489775,0.17151298573974413},
{-0.7864266563832848,-0.6111207142876721,0.08980304392576167},
{-0.8544269105993306,-0.519416359275857,0.012700400005397352},
{-0.8973139129600815,-0.43330671847275526,-0.08410130400082787},
{-0.912115551702736,-0.3890066326196297,-0.12930220462138334},
{-0.9196061567838295,-0.37060248119191735,-0.13030087236726073},
{-0.9223821566897665,-0.3801926452444159,-0.06829867877483853},
{-0.9162341211940218,-0.39921486703847797,0.03380125878231602},
{-0.8869444991218095,-0.40862050100481606,0.21531080241394246},
{-0.8740229477737447,-0.3818100245537937,0.30050788993822686},
{-0.8391505771294713,-0.3541213435365818,0.4128248817054532},
{-0.7692520262738648,-0.32292183994257795,0.5513372882017442},
{-0.6005137459169678,-0.7986182805816661,-0.03990091334235973},
{-0.5825925282987366,-0.8064896568364762,-0.10079870726486895},
{-0.5590024121006124,-0.8254035616240526,0.0789003404557036},
{-0.5379048330966382,-0.8421075663704758,-0.03890034952121067},
{-0.5255153189948263,-0.8452246386573304,-0.0971028305887681},
{-0.6554038079071859,-0.7541043813591836,-0.04210024460313172},
{0.44764107742998394,-0.8904817143513354,0.08160748864675312},
{0.49578329982081354,-0.8652708538421741,0.0741975006992827},
{0.41842005116928954,-0.8988430735921545,0.1304062492171973},
{0.36081067654588084,-0.9223272920683644,0.13830409247864556},
{0.360410351133929,-0.9264266073542503,0.10880312487062006},
{0.42861917685096806,-0.8966401165762434,0.1110049664733025},
{0.48039191987586094,-0.8651854477031534,0.14379758134502252},
{0.5590024121006124,-0.8254035616240526,0.0789003404557036},
{0.5115035958829186,-0.8440059333825676,0.16130113395095755},
{0.48240975442385264,-0.8604173978156775,0.16420332022470277},
{0.48950131920783285,-0.8506022923762669,0.19200051744209176},
{0.5241999030230269,-0.8151998491880419,0.24629995443451264},
{0.4691082423042266,-0.8261145149595429,0.31220548549857075},
{0.569817980890085,-0.8042253777321978,0.16890532989177842},
{0.5118051487856954,-0.8380084304072151,0.18920190338072207},
{0.4935070325253206,-0.8493121027836976,0.18740267050708223},
{0.5162978367165962,-0.8337965063999573,0.1954991808601483},
{0.5660086826397881,-0.7946121894444799,0.21960336874151495},
{-0.4105161130736634,-0.9105357392291609,-0.049001923363238754},
{-0.4003122217186964,-0.9109278110506135,-0.09980304703353961},
{-0.46282987663283603,-0.8809568676012647,-0.09850635879069652},
{-0.4724229225163142,-0.8802427104124889,-0.04460216414950807},
{-0.34170172559807144,-0.9350047217857677,-0.0949004792486303},
{-0.3557110805727425,-0.9336290829989101,-0.04250132393686127},
{-0.44764107742998394,-0.8904817143513354,0.08160748864675312},
{-0.49578329982081354,-0.8652708538421741,0.0741975006992827},
{-0.5115035958829186,-0.8440059333825676,0.16130113395095755},
{-0.569817980890085,-0.8042253777321978,0.16890532989177842},
{-0.5672093817207612,-0.7982132025555564,0.2028033543952228},
{-0.5567358855680438,-0.8058519428610196,0.20161299538443977},
{-0.5291351965981915,-0.8296551863501412,0.17801184085140445},
{-0.5873886576345306,-0.7984845814115981,0.13189745308477116},
{-0.48258257908333696,-0.865968739092768,0.1311952639364563},
{-0.5058254310128323,-0.856643068812954,0.10150510329735563},
{-0.6281945347313216,-0.7709932923875342,0.10459908999187559},
{-0.7073306068575523,-0.6991302520205215,0.1044045176812222},
{-0.41842005116928954,-0.8988430735921545,0.1304062492171973},
{-0.48950131920783285,-0.8506022923762669,0.19200051744209176},
{-0.48240975442385264,-0.8604173978156775,0.16420332022470277},
{-0.4935070325253206,-0.8493121027836976,0.18740267050708223},
{-0.5118051487856954,-0.8380084304072151,0.18920190338072207},
{-0.5007005883235369,-0.8454009933467508,0.1860002185503852},
{-0.4831961924290054,-0.8613932122482311,0.15659876600658576},
{-0.4596200904332388,-0.881138515406281,0.1111048564994187},
{-0.4375045653839598,-0.8958093478193171,0.07820081602977294},
{-0.41371776128474613,-0.9046388369789251,0.10230439202182627},
{-0.5307322748109766,-0.8258502214789987,0.1905115853617695},
{-0.3496051304929353,-0.9365137434400282,0.026800393298657507},
{0.11030352811477102,-0.504516137206727,-0.856327390069614},
{0.22931429933896683,-0.5268328516867323,-0.8184510361055841},
{0.22031323351181828,-0.3847231090875919,-0.896353841110498},
{0.11340434290246876,-0.362813894224124,-0.9249354210801883},
{0.2131065659144453,-0.25140774599198285,-0.9441290890653581},
{0.2874000847830375,-0.2537000748415331,-0.9236002724621205},
{0.3226032244353424,-0.3923039210972871,-0.861408609822083},
{0.3587081965759387,-0.5285120766389283,-0.7694175813926045},
{0.24699986415011208,-0.6646996344153016,-0.7050996121953199},
{0.11510412195241199,-0.6529233816049504,-0.7486268088060436},
{0.0,-0.6409119947802246,-0.7676143660372918},
{0.0,-0.48879824032950225,-0.8723968593769593},
{0.0,-0.349215777925278,-0.9370423365291681},
{0.11790137061140007,-0.24030279353621237,-0.9635112008828157},
{0.20139612517582706,-0.1645968331873939,-0.9655814223921481},
{0.25280197944724864,-0.15570121914531887,-0.9549074769548168},
{0.27261729811636565,-0.13530858560214334,-0.9525604418776166},
{0.33850199547514503,-0.23400137944219773,-0.9114053727505086},
{0.4163968333141239,-0.3656972188832256,-0.8323936696702132},
{0.4945770002313939,-0.4862773861959702,-0.7203665001348488},
{0.39730184944441377,-0.6496030239091144,-0.648203017392069},
{0.2709988889068332,-0.7811967970996978,-0.5623976941741807},
{0.12750587496853688,-0.7862362266687349,-0.604627858870411},
{0.0,-0.7815902301831836,-0.6237922026462001},
{-0.11510412195241199,-0.6529233816049504,-0.7486268088060436},
{-0.11030352811477102,-0.504516137206727,-0.856327390069614},
{-0.11340434290246876,-0.362813894224124,-0.9249354210801883},
{-0.11790137061140007,-0.24030279353621237,-0.9635112008828157},
{0.0,-0.23330109068514843,-0.9724045460018789},
{0.11740095036453982,-0.16720135350043488,-0.9789079242917208},
{0.18441186083025624,-0.14250916577175438,-0.9724625459400279},
{0.22069812517738988,-0.12349895088086837,-0.967491781192228},
{0.22251569569816362,-0.09920699781239474,-0.9698684120812543},
{0.23650176194468972,-0.06570048947046983,-0.9694072221107072},
{0.3010047077504441,-0.09760152649981178,-0.948614836452064},
{0.3918015809225685,-0.18380074163748875,-0.9015036375745163},
{0.5039946450853438,-0.2929968869246145,-0.8124913673250829},
{0.6157832755533509,-0.38618951123531037,-0.6867813472719088},
{0.5639057687855221,-0.5832059662275519,-0.5847059815727873},
{0.4334847524419946,-0.744273820628781,-0.5080821285254382},
{0.29429250593675327,-0.8711778157393797,-0.39298999263725465},
{0.1435017550371962,-0.8923109130291998,-0.42800523453602773},
{0.0,-0.8954846604791479,-0.44509237563290754},
{-0.12750587496853688,-0.7862362266687349,-0.604627858870411},
{-0.24699986415011208,-0.6646996344153016,-0.7050996121953199},
{-0.22931429933896683,-0.5268328516867323,-0.8184510361055841},
{-0.22031323351181828,-0.3847231090875919,-0.896353841110498},
{-0.2131065659144453,-0.25140774599198285,-0.9441290890653581},
{-0.20139612517582706,-0.1645968331873939,-0.9655814223921481},
{-0.11740095036453982,-0.16720135350043488,-0.9789079242917208},
{0.0,-0.16739819462020647,-0.9858893672405112},
{0.1109047301876159,-0.15580664529513577,-0.9815418636532462},
{0.1620058323149469,-0.17000612033049983,-0.9720349938896814},
{0.1881055633043033,-0.14200419983631615,-0.9718287422600849},
{0.1809107219916677,-0.11150660863499694,-0.97715791297987},
{0.18760158899218818,-0.07590064288116781,-0.9793082947763853},
{-0.3587081965759387,-0.5285120766389283,-0.7694175813926045},
{-0.39730184944441377,-0.6496030239091144,-0.648203017392069},
{-0.4945770002313939,-0.4862773861959702,-0.7203665001348488},
{-0.4163968333141239,-0.3656972188832256,-0.8323936696702132},
{-0.3226032244353424,-0.3923039210972871,-0.861408609822083},
{-0.2874000847830375,-0.2537000748415331,-0.9236002724621205},
{-0.25280197944724864,-0.15570121914531887,-0.9549074769548168},
{-0.22069812517738988,-0.12349895088086837,-0.967491781192228},
{-0.18441186083025624,-0.14250916577175438,-0.9724625459400279},
{-0.1109047301876159,-0.15580664529513577,-0.9815418636532462},
{0.0,-0.1611060560904748,-0.9869370996628777},
{0.09909965216083136,-0.19139932818953706,-0.9764965725030458},
{0.13700238523229052,-0.24530427078453185,-0.9597167088133519},
{0.15490841717752724,-0.20861133520485592,-0.9656524701524873},
{0.14260636038551297,-0.16900753790428957,-0.9752434968299596},
{0.14400182523470234,-0.12530158820769585,-0.9816124420165543},
{-0.2709988889068332,-0.7811967970996978,-0.5623976941741807},
{-0.4334847524419946,-0.744273820628781,-0.5080821285254382},
{-0.5639057687855221,-0.5832059662275519,-0.5847059815727873},
{-0.33850199547514503,-0.23400137944219773,-0.9114053727505086},
{-0.27261729811636565,-0.13530858560214334,-0.9525604418776166},
{-0.22251569569816362,-0.09920699781239474,-0.9698684120812543},
{0.0,-0.2003067925185034,-0.9797332233169135},
{0.08469939778942255,-0.2732980568577235,-0.9581931872706576},
{0.0,-0.2850075171723994,-0.9585252814377012},
{0.06730064407024564,-0.37860362325401187,-0.9231088341938151},
{0.10730696122836965,-0.347122518568193,-0.9316604387730584},
{-0.1620058323149469,-0.17000612033049983,-0.9720349938896814},
{-0.09909965216083136,-0.19139932818953706,-0.9764965725030458},
{-0.13700238523229052,-0.24530427078453185,-0.9597167088133519},
{-0.08469939778942255,-0.2732980568577235,-0.9581931872706576},
{-0.06730064407024564,-0.37860362325401187,-0.9231088341938151},
{0.0,-0.39140743681194984,-0.9202174842983041},
{0.04910074952866237,-0.4879074479640402,-0.8715133037521234},
{0.07640251483016414,-0.45651502643939695,-0.886429177296564},
{0.07809571305349466,-0.41327731376452426,-0.9072501978672945},
{0.11690165475463467,-0.30480431453560863,-0.9452133795900829},
{0.09989932967774678,-0.2578982695084174,-0.9609935517549015},
{0.09629963261760235,-0.20649921220700815,-0.9736962853557571},
{0.16859666097619372,-0.14419714420383828,-0.975080688718188},
{0.22329775698529658,-0.07059929083368534,-0.9721902343981429},
{0.3696236696095494,-0.006400409863368821,-0.9291595006337456},
{0.31009193616404873,-0.07459806010267021,-0.9477753534223973},
{0.11379884039572452,-0.2462974902413616,-0.9624901922749108},
{0.25709901531265705,-0.1824993010290156,-0.9489963653508812},
{0.5706131784635367,-0.00010000230958000994,-0.8212189662710416},
{0.5180947931734928,-0.12799871361939216,-0.8456915008431246},
{0.4486072114188858,-0.313305036418941,-0.8370134550994369},
{0.6702351480527701,-0.32981729607252097,-0.6648348648544934},
{0.4972160255307584,-0.558317994878967,-0.6641214049778292},
{0.5916756530478053,-0.6853717975307855,-0.42448253290314913},
{0.6054382043560803,-0.7808492731437521,-0.15400971831984864},
{0.3459046161279035,-0.8545114035307707,-0.3875051712910166},
{0.14350887271034146,-0.7893488029984147,-0.5969369067651764},
{0.07130054937284938,-0.8211063266486203,-0.5663043633919299},
{0.06070041670979107,-0.8403057687189035,-0.5387036982135823},
{0.06770108424154626,-0.8582137444031758,-0.508808148627751},
{0.09239949134220024,-0.953794749374357,-0.2858984261334962},
{0.07559734620174156,-0.962566209706302,-0.2602908626496472},
{0.044201773852777786,-0.9697389164035887,-0.24010963579303046},
{0.0,-0.9728330331064682,-0.23150786098288179},
{-0.044201773852777786,-0.9697389164035887,-0.24010963579303046},
{-0.07559734620174156,-0.962566209706302,-0.2602908626496472},
{-0.09239949134220024,-0.953794749374357,-0.2858984261334962},
{-0.09630168818339091,-0.9455165750508422,-0.31100545197336005},
{-0.1164090010919601,-0.9362723953805244,-0.33142562682023685},
{-0.19120545899378252,-0.9155261386443928,-0.35391010427771774},
{-0.14350887271034146,-0.7893488029984147,-0.5969369067651764},
{-0.10289579730698675,-0.5927757885673639,-0.7987673750128378},
{-0.08750329806145705,-0.39861502408339183,-0.9129344091463333},
{-0.1881055633043033,-0.14200419983631615,-0.9718287422600849},
{-0.15490841717752724,-0.20861133520485592,-0.9656524701524873},
{-0.11690165475463467,-0.30480431453560863,-0.9452133795900829},
{-0.10730696122836965,-0.347122518568193,-0.9316604387730584},
{-0.07640251483016414,-0.45651502643939695,-0.886429177296564},
{-0.04910074952866237,-0.4879074479640402,-0.8715133037521234},
{0.0,-0.5005158315661326,-0.8657273833902119},
{0.035501210256886837,-0.6106208164184537,-0.7911269699781177},
{0.05370048894517778,-0.5827053055559608,-0.8109073833453382},
{0.05080024282574106,-0.5436025984266307,-0.8378040047127139},
{0.029500381589903816,-0.49880645210318725,-0.8662112045143961},
{0.05770169703186493,-0.3642107115945444,-0.929527337801013},
{0.051598709790392334,-0.3107922287374794,-0.9490762686446002},
{-0.1809107219916677,-0.11150660863499694,-0.97715791297987},
{-0.14260636038551297,-0.16900753790428957,-0.9752434968299596},
{-0.09989932967774678,-0.2578982695084174,-0.9609935517549015},
{-0.05770169703186493,-0.3642107115945444,-0.929527337801013},
{-0.07809571305349466,-0.41327731376452426,-0.9072501978672945},
{-0.05080024282574106,-0.5436025984266307,-0.8378040047127139},
{-0.05370048894517778,-0.5827053055559608,-0.8109073833453382},
{-0.035501210256886837,-0.6106208164184537,-0.7911269699781177},
{0.0,-0.6217883477955424,-0.7831853232445622},
{0.03180094545616283,-0.7557224679629637,-0.6541194472602548},
{0.04909985810161513,-0.7348978761482069,-0.6763980452124739},
{0.04820237426641818,-0.7060347765994032,-0.7065348012287229},
{0.031400463788275254,-0.6735099478153943,-0.7385109078866648},
{0.033099756717682186,-0.6377953122216827,-0.7694943442373547},
{0.02520167546307903,-0.44962989238890205,-0.8928593592633713},
{0.08750329806145705,-0.39861502408339183,-0.9129344091463333},
{0.22991250068250238,-0.34751889511600514,-0.9090494263610034},
{0.3889083207825357,-0.45580975215397207,-0.8006171293867268},
{0.24272488300320036,-0.5280541336039959,-0.8137834252150974},
{0.29071163160507546,-0.7185287489103773,-0.6318252798351794},
{-0.04909985810161513,-0.7348978761482069,-0.6763980452124739},
{-0.03180094545616283,-0.7557224679629637,-0.6541194472602548},
{0.0,-0.7642391109372788,-0.6449330052910902},
{0.0370011992283008,-0.8883287912026919,-0.4577148347781967},
{0.06049944401266427,-0.8752919561038849,-0.47979559069878214},
{0.10289579730698675,-0.5927757885673639,-0.7987673750128378},
{-0.029500381589903816,-0.49880645210318725,-0.8662112045143961},
{-0.031400463788275254,-0.6735099478153943,-0.7385109078866648},
{-0.04820237426641818,-0.7060347765994032,-0.7065348012287229},
{-0.06770108424154626,-0.8582137444031758,-0.508808148627751},
{-0.06049944401266427,-0.8752919561038849,-0.47979559069878214},
{-0.0370011992283008,-0.8883287912026919,-0.4577148347781967},
{0.0,-0.8938263682668016,-0.44841322838535896},
{-0.06070041670979107,-0.8403057687189035,-0.5387036982135823},
{-0.07130054937284938,-0.8211063266486203,-0.5663043633919299},
{-0.033099756717682186,-0.6377953122216827,-0.7694943442373547},
{-0.02520167546307903,-0.44962989238890205,-0.8928593592633713},
{-0.051598709790392334,-0.3107922287374794,-0.9490762686446002},
{0.6110018177331117,0.06320018802083906,-0.7891023475829761},
{0.6441277302956967,0.0947040770982805,-0.7590326770601363},
{0.42090112170298405,0.033100088211852625,-0.9065024158321573},
{0.2724961333073024,-0.026699621135064123,-0.9617863523484896},
{-0.807971254086951,-0.40713590486297535,-0.4259375629603075},
{-0.9088271334391094,-0.14780441276661568,-0.39011164695708245},
{-0.7664132360708814,-0.10970189456807893,-0.6329109304661545},
{-0.9340195772555111,0.017200360523334894,-0.3568074787631331},
{-0.8059562012854418,0.03820266396464062,-0.5907411938197177},
{-0.9340095176054768,0.09310094870350095,-0.34490351458472046},
{-0.5706131784635367,-0.00010000230958000994,-0.8212189662710416},
{-0.8196966474475679,0.10279957955057946,-0.5634976952991393},
{-0.6110018177331117,0.06320018802083906,-0.7891023475829761},
{-0.8287681096167011,0.12959501327983164,-0.5443790526970705},
{-0.9316102384527812,0.12550137926773727,-0.3411037487507983},
{0.6739570562497476,0.10780912696798158,-0.7308618737309919},
{0.7044339510124232,0.10450503674162155,-0.7020338353360606},
{0.470300110520539,0.04800001128000398,-0.881200207082073},
{0.5260319284768777,0.03940239160073951,-0.8495515650971628},
{0.326826353071315,-0.014301153148469416,-0.9449761965027099},
{-0.9308253932630971,0.14280389574341457,-0.3364091773675396},
{-0.8376262809368531,0.14180444918439084,-0.5275165510914398},
{-0.9313260868090424,0.14900417366535737,-0.3323093081140822},
{-0.9806116987673499,0.13430160222767193,-0.14270170244146524},
{-0.6441277302956967,0.0947040770982805,-0.7590326770601363},
{-0.6739570562497476,0.10780912696798158,-0.7308618737309919},
{-0.8467312534273567,0.14200524151019797,-0.5127189248047783},
{-0.9328699574067748,0.14579530473781518,-0.3293893921854343},
{-0.9799439269710618,0.14030628937038472,-0.14150634316400165},
{-0.7044339510124232,0.10450503674162155,-0.7020338353360606},
{-0.8568560402176053,0.13100856824055357,-0.49863261163923667},
{-0.7389597620925384,0.08430681816808903,-0.6684540600658447},
{-0.8708939647257367,0.11879917672455793,-0.4768966951173542},
{-0.9362750267239576,0.1419113718138534,-0.321325748863926},
{0.3971042033702391,-0.03490036942236551,-0.9171097076576337},
{0.49402414849058174,-0.096804731930948,-0.864042235416726},
{0.5951852128070794,0.0036999080769257293,-0.8035800353020313},
{-0.3010047077504441,-0.09760152649981178,-0.948614836452064},
{-0.23650176194468972,-0.06570048947046983,-0.9694072221107072},
{-0.326826353071315,-0.014301153148469416,-0.9449761965027099},
{-0.3971042033702391,-0.03490036942236551,-0.9171097076576337},
{-0.5260319284768777,0.03940239160073951,-0.8495515650971628},
{-0.470300110520539,0.04800001128000398,-0.881200207082073},
{-0.2724961333073024,-0.026699621135064123,-0.9617863523484896},
{-0.18760158899218818,-0.07590064288116781,-0.9793082947763853},
{-0.3918015809225685,-0.18380074163748875,-0.9015036375745163},
{-0.49402414849058174,-0.096804731930948,-0.864042235416726},
{-0.5951852128070794,0.0036999080769257293,-0.8035800353020313},
{-0.5039946450853438,-0.2929968869246145,-0.8124913673250829},
{-0.6157832755533509,-0.38618951123531037,-0.6867813472719088},
{-0.42090112170298405,0.033100088211852625,-0.9065024158321573},
{-0.3696236696095494,-0.006400409863368821,-0.9291595006337456},
{0.7144089980379958,-0.258803259647583,-0.6501081881641952},
{0.6138163584239309,-0.174504650610909,-0.7699205186552369},
{0.6817421772844869,-0.04270264188066246,-0.7303451842025244},
{0.7085241398286729,-0.4520154004270433,-0.5419184634765813},
{0.6164437197389607,-0.6498460887189759,-0.4446315343866677},
{0.45781554539077013,-0.8185277935831048,-0.3470117829851403},
{0.30640949884169844,-0.9198285151259602,-0.24500759535318575},
{0.15389739992539223,-0.9502839450883706,-0.27069542663940005},
{0.0,-0.9591183145390758,-0.2830054040397857},
{-0.1435017550371962,-0.8923109130291998,-0.42800523453602773},
{0.7902360790518025,-0.46492122646315226,-0.39921822672422114},
{0.6530321560950686,-0.6994344409998331,-0.29041430035223265},
{0.46409076932639626,-0.8618828573204501,-0.20439593460529065},
{0.3103139116844983,-0.9357419502519658,-0.1676075140132836},
{0.15699498801501016,-0.9692690565792952,-0.18939395369454093},
{0.0,-0.9801825284021454,-0.19809646896191085},
{-0.15389739992539223,-0.9502839450883706,-0.27069542663940005},
{-0.29429250593675327,-0.8711778157393797,-0.39298999263725465},
{-0.45781554539077013,-0.8185277935831048,-0.3470117829851403},
{-0.6164437197389607,-0.6498460887189759,-0.4446315343866677},
{-0.6138163584239309,-0.174504650610909,-0.7699205186552369},
{-0.7144089980379958,-0.258803259647583,-0.6501081881641952},
{-0.7865415383554898,-0.09470500150319758,-0.6102322272149013},
{-0.6817421772844869,-0.04270264188066246,-0.7303451842025244},
{-0.7825209914071455,0.06010161224737309,-0.619716624121416},
{-0.8895297018926275,0.11710391016484169,-0.4416147457625456},
{-0.9418776542177274,0.14719650780427804,-0.30199283530497256},
{-0.9799469699839339,0.15620748720429686,-0.12370592936729527},
{-0.9799569812553108,0.14470841431538267,-0.13690796074482298},
{-0.8320477733944035,0.047902750415374916,-0.5526317302617156},
{-0.9093142445192114,0.12870201613287421,-0.39570619878615637},
{-0.9479028342337115,0.16400049036219927,-0.27310081657266233},
{-0.9787051137475791,0.17750092744476886,-0.10310053870172207},
{-0.8012093181185549,-0.2791032459896264,-0.5293061558663893},
{-0.8738355570922418,-0.0873035524538255,-0.4783194632149454},
{-0.8790959429815847,0.0510997641751325,-0.47389781296663974},
{-0.9257902375934165,0.15959831704462007,-0.3426963862856598},
{-0.9513080576133721,0.19840168046935036,-0.23590199809838586},
{-0.9737053261827013,0.2149011755126451,-0.07560041353539307},
{-0.8752492166472171,-0.2525141992726489,-0.4125231968315551},
{-0.9193585925902181,-0.06060386240723074,-0.3887247742193166},
{-0.916429614901516,0.07600245605905195,-0.3929126971789673},
{-0.938830634543416,0.184306014003357,-0.2909094925316145},
{-0.9506586187309702,0.2395895708929636,-0.19709142079717498},
{-0.9640820778807567,0.26139514070950093,-0.04709912443541504},
{-0.7085241398286729,-0.4520154004270433,-0.5419184634765813},
{-0.7902360790518025,-0.46492122646315226,-0.39921822672422114},
{-0.9092252677212899,-0.31830884592574415,-0.2683074563678201},
{-0.9499633361670038,-0.09760650764280407,-0.2967197829674177},
{-0.9452691536945004,0.07680561892058571,-0.31712319999632466},
{-0.9597505465935896,0.15870835859581398,-0.23171220344455007},
{-0.9521837701659551,0.2629955172796116,-0.15549734957026465},
{-0.9534366651119489,0.3008115679312715,-0.021700834521637603},
{-0.6530321560950686,-0.6994344409998331,-0.29041430035223265},
{-0.8187328359388412,-0.51732074756463,-0.24910999075652293},
{-0.9053711378050558,-0.4071319896171857,-0.12060947665888626},
{-0.9654245172669279,-0.19220488110493428,-0.17610447222985914},
{-0.9730216548378954,-0.0020000445114859104,-0.23070513439989976},
{-0.982656887653887,0.11050639740052363,-0.14890862056957438},
{-0.9591544767255524,0.26521506331729383,-0.09840558910415427},
{-0.9458803731858824,0.324493266834569,0.003799921152454121},
{-0.9300994326395191,-0.03639997779602032,0.365499777045204},
{-0.9658303855018995,-0.05620176813543876,0.25300795975562285},
{-0.971141444345475,0.1938082709444476,0.13900593220473798},
{-0.960645747039737,0.19460926751398377,0.19820943895823012},
{-0.9531242334917087,0.2865072845403153,0.09730247394685056},
{-0.9529626402930874,0.29671950401401936,0.061804062514548015},
{-0.9769215218181911,0.20120443258247522,0.07170157960319819},
{-0.9885962383984693,-0.036099862640283975,0.146199443712175},
{-0.8605473572241379,-0.3788208470848384,0.34051873926184656},
{-0.8089856770353809,-0.3664935112898233,0.45959186299809773},
{-0.7417145043689508,-0.318606230405754,0.5902115416995479},
{-0.8897183728741016,0.0006000123903837934,0.4565094270170028},
{-0.9485953424083031,0.2068989841284819,0.23949882406366077},
{-0.952448342742485,0.28121427339267824,0.11730595401479786},
{-0.946083699118295,0.32259444174565266,0.029299495174047188},
{-0.9732098489335071,0.22940232156324142,-0.015400155850365815},
{-0.9998487638133458,-0.0169008242733002,-0.004100199971629043},
{-0.8988029076321092,-0.38030123027646995,0.21800070523342213},
{-0.7220195742159891,-0.6077164754169759,0.33070896564158947},
{-0.7608087037013559,-0.5932067863244536,0.26320301105966987},
{-0.9125726369197169,-0.3988880395214498,0.08999730147137247},
{-0.7706871334857088,-0.6026899381754726,0.2068965458909993},
{-0.6699670436067456,-0.7035704062954853,0.23692370895721457},
{-0.7005908748632819,-0.6799911431730398,0.2162971827475419},
{-0.7635567725566378,-0.619646072398288,0.181713510901822},
{-0.7203145108819841,-0.6651133988443809,0.19690396667036325},
{-0.6439933991014887,-0.7412924017918222,0.18909806175480048},
{-0.6970298857970441,-0.69712989008482,0.16780719488772455},
{-0.7251201658722233,-0.6661185250137746,0.17460485582856183},
{-0.7100263247139922,-0.6891255498033972,0.14480536875857195},
{-0.6870169695287237,-0.7192177648981921,0.10360255901481188},
{-0.6539140887308142,-0.7441160321526209,0.13670294529668495},
{-0.6589371848745433,-0.750342343013158,0.05280297975622384},
{-0.6302131905001171,-0.7729161773048883,0.07370154258942976},
{-0.6291117204605293,-0.7773144815036869,-0.0008000149044165053},
{-0.6133217579753031,-0.7896280125506266,0.018000638583980853},
{-0.5586334352116761,-0.8245493507555083,0.08970536902700921},
{-0.5455002918427342,-0.8378004482233598,0.02280001219800979},
{-0.6029202886090733,-0.7955267699262196,-0.06020202583225445},
{-0.541326682649798,-0.8382413179328665,-0.0657032385924473},
{-0.6044539166717536,-0.7816697241407058,-0.15371371110597043},
{-0.5449187155546842,-0.8209281952630577,-0.17070586299354848},
{-0.609620910355844,-0.7532258360892744,-0.24700847253591446},
{-0.5484205497030032,-0.7899295992166344,-0.2743102785987122},
{-0.6190781035947069,-0.7127747896015298,-0.32968833912966383},
{-0.5531193014347913,-0.7462260400120072,-0.3704129257845718},
{-0.6286347613202173,-0.6632366746859181,-0.4061224571621703},
{-0.565131368487186,-0.6823378742148416,-0.4637257398115522},
{-0.6340675555932491,-0.5942695920029459,-0.49477468302718763},
{-0.5880203929008447,-0.5470189709468743,-0.5958206634189173},
{-0.6056230353102303,-0.4964188816512522,-0.6219236553161034},
{-0.5871869880805146,-0.4251905778811901,-0.6887847366993501},
{-0.5453469836665514,-0.4195361445958524,-0.7256625185190716},
{-0.5479030189539517,-0.3476019152918299,-0.7609041925936517},
{-0.5454299121965998,-0.2810154113077458,-0.7896433052263204},
{-0.5469025868553538,-0.30870146016135985,-0.7782036809121161},
{-0.5049901098655465,-0.4603909833308863,-0.7300857014115554},
{-0.9491376340533002,0.28421126920024015,0.13550537289455503},
{-0.9720798441333957,0.1840961828052239,0.14549698315133122},
{-0.9597489052514825,-0.21061073194327623,0.18580946816268148},
{-0.7778078792337252,-0.6173062533440197,0.1181011963711789},
{-0.5176033489045011,-0.8533055209045805,0.06290040696694962},
{-0.7036420051632847,-0.6814406798156086,0.20131201767960377},
{-0.5010974393986269,-0.8625955921477861,0.06949964485772217},
{-0.9815922650834268,-0.15979874079088385,-0.10459917576174249},
{0.9760261090476302,-0.1537041116399803,0.15410412234040965},
{0.9597489052514825,-0.21061073194327623,0.18580946816268148},
{-0.963942515622248,0.11430504153503782,0.2403105991327173},
{-0.8725860910885612,-0.3283947654291583,0.36159423623381126},
{-0.8836526451745512,-0.04650277048507993,0.46582775251505876},
{-0.6940237498990892,-0.31161066349936056,0.6490222099200418},
{-0.6752444021555436,-0.5079334002588871,0.5348351692428683},
{-0.583302365295887,-0.748603035591464,0.3152012781437743},
{-0.48039191987586094,-0.8651854477031534,0.14379758134502252},
{-0.3820270007124467,-0.9229652328730814,-0.04680330794068719},
{-0.42861917685096806,-0.8966401165762434,0.1110049664733025},
{-0.4794946033186093,-0.8024909680149823,0.35509600341697223},
{-0.42630209101688465,-0.822504034392183,0.37650184674608744},
{-0.360410351133929,-0.9264266073542503,0.10880312487062006},
{-0.42801272072709284,-0.8230244606504612,0.3734110979427488},
{-0.36081067654588084,-0.9223272920683644,0.13830409247864556},
{-0.4691082423042266,-0.8261145149595429,0.31220548549857075},
{-0.5241999030230269,-0.8151998491880419,0.24629995443451264},
{-0.5660086826397881,-0.7946121894444799,0.21960336874151495},
{-0.5162978367165962,-0.8337965063999573,0.1954991808601483},
{-0.5374898281012539,-0.8221844403066996,0.1873964535556744},
{-0.49670756491382084,-0.8488129275193299,0.1811027582160116},
{-0.49431104550371907,-0.8569191480722979,0.14610326471392546},
{-0.4830176087278951,-0.8703317285215054,0.09600349987138289},
{-0.4696287585975761,-0.8824540387276429,0.026901647372816858},
{-0.42890402957228685,-0.9022084762884522,0.04540042653901102},
{-0.3623085994966648,-0.9320221218075948,0.008200194633929483},
{-0.3117928210529419,-0.9458782214046753,-0.08999792782156758},
{-0.311414242856103,-0.9481433643284239,-0.06360290894556246},
{-0.30470043572193467,-0.94870135664391,-0.08440012069225888},
{-0.306304027924451,-0.949912491431394,-0.06200081531608215},
{-0.36911614733905573,-0.9293406548961921,-0.008900389356048756},
{0.28929996817700526,-0.36769995955300666,-0.883799902782016},
{0.28170690331224957,-0.48971200053961167,-0.825120219818733},
{0.16660052312646392,-0.49460155305131487,-0.8530026784326155},
{0.17160266329400167,-0.36560567424409673,-0.914814198026531},
{0.0,-0.4977212581289117,-0.8673370447562893},
{0.0,-0.6235113823041769,-0.7818142721498084},
{0.16011257733694412,-0.6185485889000621,-0.7692604277799964},
{0.27431314128580747,-0.6103292385225239,-0.7431356007637023},
{0.35692281166586365,-0.48813119746177647,-0.7964509028038492},
{0.3649043040716499,-0.37220439017667334,-0.8534100660310937},
{0.36841353944636657,-0.280510308943284,-0.8863325733206153},
{0.2913947126909069,-0.2631952243659804,-0.9196833124976908},
{0.17210032182790272,-0.25010046768831184,-0.9528017817409977},
{0.0,-0.36520988819158606,-0.9309252051411484},
{-0.17160266329400167,-0.36560567424409673,-0.914814198026531},
{-0.16660052312646392,-0.49460155305131487,-0.8530026784326155},
{-0.16011257733694412,-0.6185485889000621,-0.7692604277799964},
{0.0,-0.7254137648567834,-0.688313060864246},
{0.15460560532783357,-0.7197260941425734,-0.6768245387184849},
{0.27030568458832094,-0.7092149149464937,-0.6511136930649493},
{0.35401357845120723,-0.6060232444673208,-0.7123273218384037},
{0.4002072258066935,-0.4919088814950338,-0.7732139605040865},
{0.4068051969695871,-0.3785048354301591,-0.8314106213385318},
{0.41460634145248915,-0.2960045274238707,-0.8605131616494619},
{0.4138956934377145,-0.21979771301669399,-0.883390808366458},
{0.365620135255288,-0.1891104145973057,-0.9113501894369366},
{0.2874961863883811,-0.16079786703044063,-0.9441874754362068},
{0.16879999324800044,-0.13899999444000036,-0.9757999609680025},
{0.0,-0.2447937333