// 3D model [dragon]
//
// - vertices   : 11392
// - textures   : 0
// - normals    : 11392
// - triangles  : 23000
//
// - memory size: 369kb
//
// - model bounding box: [-0.45,0.45]x[-0.7,0.7]x[-1.0,1.0]
//
// object [dragon] (tagged [ | g root | usemtl Acier_-_Satiné]) with 23000 triangles (1302 chains)

#pragma once

#include <tgx.h>

// vertex array: 133kb.
const tgx::fVec3 dragon_vert_array[11392] PROGMEM = {
{-0.4464531246683203,-0.5164104613937818,-0.5520137890651127},
{-0.44349008575510424,-0.5360553132638646,-0.553723203782821},
{-0.4464719490571985,-0.519139797521669,-0.5368130950459415},
{-0.441443233853781,-0.5028691172282809,-0.5447353591312905},
{-0.4395589926308524,-0.5057452435375273,-0.5318524680576153},
{-0.4404845918371842,-0.5174594204251027,-0.5241526922280506},
{-0.4394454455192147,-0.53336382617319,-0.5254183319909274},
{-0.44119791601999536,-0.5404860537312141,-0.5377499087818176},
{-0.43211454760788076,-0.5563988703764596,-0.5545074198131098},
{-0.4178342460491813,-0.5714607845925181,-0.5702908688496816},
{-0.44089191957099616,-0.5321686777388785,-0.562370407099438},
{-0.44281300853385636,-0.5157275766483055,-0.5589263449725465},
{-0.4376633366189234,-0.5016891885126369,-0.5517688717502396},
{-0.42842737050122126,-0.4949055996949647,-0.5438730419131025},
{-0.42778473790643146,-0.4980995377611232,-0.5297489427302012},
{-0.42670273606484566,-0.5083376021974069,-0.5179670781464465},
{-0.4179381807069238,-0.5215517224115563,-0.5063522299491221},
{-0.4321119442349508,-0.5261655000218282,-0.5161044649447825},
{-0.4216547959536376,-0.5422030783082561,-0.5130649269193166},
{-0.4302677549032526,-0.5544391313385622,-0.5360026450268968},
{-0.41270480033931956,-0.5784258084774634,-0.5335022054573905},
{-0.4148397664013495,-0.5810954672874176,-0.5666723807364821},
{-0.3936769478536391,-0.6031734715497399,-0.5755172401363207},
{-0.4125534041904691,-0.5663792008926765,-0.5743509290636949},
{-0.42882068007310264,-0.5478229594262326,-0.5686960025408919},
{-0.4337624826725506,-0.5165430331537539,-0.5642067863123462},
{-0.4257593137669164,-0.49974026348537165,-0.5574009686950412},
{-0.4106639562216808,-0.49782117711707286,-0.557163861498958},
{-0.410555816115359,-0.49160672567378294,-0.5408475220495674},
{-0.4093422438110817,-0.49232185219169955,-0.5285806290630141},
{-0.4027981653029664,-0.49150739698353185,-0.5114544403729471},
{-0.41134944434008697,-0.5033623562687818,-0.5053373150253468},
{-0.40260871985744723,-0.509109001622502,-0.48076327690155357},
{-0.3975097135849206,-0.5197163444959289,-0.4768139601667921},
{-0.398196803778976,-0.538149826915752,-0.48413444458640614},
{-0.4221396240969801,-0.5258879404156024,-0.5706136870929976},
{-0.4117413520957752,-0.5121992052903742,-0.5672773645535154},
{-0.39051405000318407,-0.5067739763637769,-0.5610302708188729},
{-0.3999869230575133,-0.49570343336827183,-0.5508410696898902},
{-0.3871408797237701,-0.495184961636296,-0.5371547376781358},
{-0.38136559726782016,-0.49066350363530986,-0.5152657783424204},
{-0.38876598521043865,-0.48108909903671193,-0.4897086665483801},
{-0.3988021881149217,-0.48843741952073094,-0.491511602432111},
{-0.39985795596775175,-0.49428679797545694,-0.4792997807959993},
{-0.38738960196831007,-0.5002132763208011,-0.4554853267893883},
{-0.37541088233915854,-0.5261206419036503,-0.4446861353569685},
{-0.3773489933557917,-0.5513811694431304,-0.4368337618218164},
{-0.3915145462461164,-0.5489374032997151,-0.46088492250559826},
{-0.4041461117023215,-0.5524761881493663,-0.4904021650450323},
{-0.41939947395846056,-0.5551879014451123,-0.5196540638050658},
{-0.4134513675918519,-0.5655897781165277,-0.5161300981551699},
{-0.41046990480867,-0.577447941553076,-0.4934923687129044},
{-0.4122381958064869,-0.6125976815562243,-0.508295347452159},
{-0.4079302143857581,-0.5975834290907299,-0.5444379738389056},
{-0.40482699385323623,-0.6019224507271621,-0.5606906307812402},
{-0.3936232783193906,-0.6141819341138379,-0.5693832929944035},
{-0.3640199242138114,-0.6423862756587434,-0.583683420239262},
{-0.36061391138358856,-0.6251885943428305,-0.5893131140705898},
{-0.373850460656827,-0.5887866319603678,-0.581847441545266},
{-0.3892690369642909,-0.5814629433894553,-0.5750806745219106},
{-0.40758256396987924,-0.540450007029107,-0.5719730482813533},
{-0.38806127218424186,-0.5228498042063296,-0.5668007470478752},
{-0.378062317538603,-0.5141401199393935,-0.5605472450106357},
{-0.3798550401900702,-0.5028933486224753,-0.5496685505741238},
{-0.36840300293059686,-0.5062819388800129,-0.5391661436557202},
{-0.355712160675371,-0.5003270236918952,-0.5236318173826009},
{-0.3455337735570205,-0.4869550990262984,-0.5009952894970724},
{-0.35973397133325935,-0.4779730618989963,-0.4900004445759926},
{-0.3605187881419166,-0.47291691115008594,-0.4749873936672352},
{-0.37744251452181443,-0.474935526468092,-0.4749994092346044},
{-0.3919557178280179,-0.48595600459955907,-0.4691380152125093},
{-0.3779778080481071,-0.4838823179311115,-0.4510922350997953},
{-0.36986389566322125,-0.49977190447944353,-0.4332985816423759},
{-0.35622622669931164,-0.48906943836434486,-0.41008470574476297},
{-0.3665774377283208,-0.5296774501043552,-0.42430673180172224},
{-0.364986376349198,-0.5553707383285784,-0.41549571624997345},
{-0.3793277570420236,-0.5853623955196352,-0.4224471224919005},
{-0.392278536071334,-0.5786941561487062,-0.44277125443724885},
{-0.4036186282948188,-0.5783577202623718,-0.4654640552299559},
{-0.4117381479444769,-0.6068734652615928,-0.4833227930106246},
{-0.40481698088042867,-0.6410970052800408,-0.48093810340677384},
{-0.40375240161152776,-0.6398147439823034,-0.5265840422851846},
{-0.41025062070418433,-0.6137922292121673,-0.5297355253466391},
{-0.40261192400874574,-0.6250504153180861,-0.5457596862495048},
{-0.3805295140383881,-0.6437194028583432,-0.5676198082235343},
{-0.3546784213627175,-0.6699153423175065,-0.5809152337768813},
{-0.34272733753851486,-0.6610498561936845,-0.5910097121831044},
{-0.3349843056664214,-0.6286000141783694,-0.5997328138336028},
{-0.3457130057702759,-0.6011796884042966,-0.5969460032418},
{-0.35202057786067625,-0.5684066276267532,-0.589699614820962},
{-0.37393997663372663,-0.5549265628548347,-0.5712895627575085},
{-0.378277996972878,-0.5402221117680066,-0.5637013314450201},
{-0.39142082482063756,-0.559846537173562,-0.5690965214531947},
{-0.3956769390422231,-0.5405665580325869,-0.5677812173451924},
{-0.37421973909397016,-0.5280000768996311,-0.5608292103248969},
{-0.3663181017326047,-0.5189105004443757,-0.5546203661463792},
{-0.40911314699324447,-0.5985699071717318,-0.4695249164817938},
{-0.4013809291317831,-0.6329682736953997,-0.4575760355116088},
{-0.3936877618642713,-0.6594311590096128,-0.4666089385407734},
{-0.39383415152671797,-0.6632479039844021,-0.49830019773618695},
{-0.3997416052237278,-0.6535070837777425,-0.5130553144654213},
{-0.3883544520280475,-0.6636620405397232,-0.5285063328047819},
{-0.3920198008539864,-0.6445979410924794,-0.5502050456571533},
{-0.3984889823255009,-0.6163445359808166,-0.443088865934705},
{-0.3876351200615517,-0.6320482817538402,-0.4304280625979019},
{-0.37881509283427606,-0.6516036176470233,-0.43150365613689085},
{-0.37821471498473425,-0.6683875629265276,-0.4469650879679713},
{-0.3814585176554744,-0.6734146760542958,-0.4632734170391159},
{-0.3759033203418348,-0.6790431683288869,-0.48391876515213106},
{-0.3687212152064214,-0.6796645734213246,-0.5343098518440491},
{-0.3870525653036073,-0.6134175437697079,-0.42414452164223965},
{-0.374596627390447,-0.6320679071805431,-0.40953319120252196},
{-0.36200531408492836,-0.6716003253815643,-0.4261401071227882},
{-0.36247051680156805,-0.6843997082620241,-0.4490497889065072},
{-0.35315444690140546,-0.691935471597001,-0.46859030559993525},
{-0.341080604030582,-0.6962786986820123,-0.5163621988648492},
{-0.3540279786491378,-0.6891891134153407,-0.5396579808800281},
{-0.3506672244560052,-0.6831098371049531,-0.5710528560803376},
{-0.3710322093304084,-0.6683733445051409,-0.5576524945719674},
{-0.35200415658527184,-0.5226185045344749,-0.5586900388142877},
{-0.372781675939347,-0.6105914823244996,-0.40580155649659705},
{-0.36969227330929944,-0.6063103356708952,-0.38855481161392696},
{-0.3786474756694773,-0.6221606713658214,-0.3925730176016046},
{-0.37599844358350676,-0.643438639100819,-0.3976195558966196},
{-0.3633003919878594,-0.669045415239985,-0.40772604987021177},
{-0.35318448581982814,-0.685353143532761,-0.42607862746974984},
{-0.331863262042302,-0.6980786306739011,-0.47462532457051354},
{-0.2989488180887157,-0.6995267068013318,-0.49455834979799823},
{-0.2961541973781231,-0.6989173172762629,-0.5394060544841897},
{-0.31503445864462,-0.6962044024237801,-0.5571876923742399},
{-0.3392794704819564,-0.6938431431762991,-0.558509204525383},
{-0.3381464024790518,-0.6867295267748894,-0.5772907378799973},
{-0.339478728640827,-0.6791967673317549,-0.5844055558381439},
{-0.37758590029241884,-0.4764883382910899,-0.4616801528059754},
{-0.35763825612463507,-0.47736507419012064,-0.4297045251828268},
{-0.34364532688551286,-0.4633557236755941,-0.40558047005700587},
{-0.3403616725829985,-0.46785234950401733,-0.3838150708057359},
{-0.3453403229223782,-0.5024365568029939,-0.37946583593704},
{-0.35599412598963215,-0.5148682633219598,-0.39018952955449077},
{-0.3642313981995073,-0.5502483016996821,-0.3994208897047014},
{-0.3637754074178505,-0.5869608664986357,-0.39934699396538154},
{-0.3663797816450993,-0.5883112160114643,-0.4079827824929979},
{-0.3649619446955475,-0.5859459515748603,-0.3777165695875576},
{-0.36925751002999485,-0.607782442933064,-0.3656545420246471},
{-0.3790439893926571,-0.6169803597540973,-0.37201938831950676},
{-0.38478963344909667,-0.6348455058373629,-0.3778301166991955},
{-0.3770147603234751,-0.6571105524317306,-0.3889387089913692},
{-0.37448288001935304,-0.6703657258343909,-0.3797904565154614},
{-0.35673989220433994,-0.6859344967339684,-0.40520658565237117},
{-0.337288090449987,-0.6925939246888269,-0.4310294417447244},
{-0.3087673389643622,-0.6988091771699412,-0.45132473632838704},
{-0.264942559580192,-0.6985536461038921,-0.4770246331146633},
{-0.25969756416413103,-0.6966151345683468,-0.5220673905111463},
{-0.2844492324255305,-0.6932181334136506,-0.5571804830338186},
{-0.29428277276038833,-0.6824638000994088,-0.5767121883111759},
{-0.3272675077830838,-0.6919164469486666,-0.570878630353486},
{-0.3237757839056281,-0.680376696047399,-0.584963879201894},
{-0.3237569595167499,-0.6602958793412745,-0.5940664725217991},
{-0.3850377549152682,-0.6333029072466286,-0.3642699481448164},
{-0.38285512710267416,-0.6578284825820333,-0.36069651840925104},
{-0.3824582128605821,-0.6427114970155332,-0.3533764345085493},
{-0.37963795893960217,-0.6245679902882174,-0.35750238008363633},
{-0.37533618556201415,-0.6301043632129787,-0.3477936013899608},
{-0.37310409366375075,-0.6517880566061388,-0.34508328991040793},
{-0.3763356805076657,-0.6639398004054052,-0.354104978410028},
{-0.37225979979661644,-0.6732130147819514,-0.3653759811211405},
{-0.38296987577104896,-0.6558423092959237,-0.3771820770990895},
{-0.3562935138765785,-0.6061118785498492,-0.3542747984288444},
{-0.35512900513905815,-0.6203307004555102,-0.3429066698814984},
{-0.36668637887246713,-0.6290634145599038,-0.3419147847951806},
{-0.3609982092799431,-0.6381379715559479,-0.3390763072636908},
{-0.3545394413001485,-0.6484999965955891,-0.34055842749866727},
{-0.3676207894948695,-0.6678576764055509,-0.3514331167460562},
{-0.3612567442378345,-0.6805497202175138,-0.3724757796200757},
{-0.3648415887624005,-0.6808186686671249,-0.38329940270614604},
{-0.35046215877290615,-0.6873925858342067,-0.3922678221904299},
{-0.3366961234976035,-0.6874390460280339,-0.41541401039186365},
{-0.3125650592908172,-0.6781117615983268,-0.41404563752798124},
{-0.311739389553105,-0.692661612385006,-0.4332054609952654},
{-0.2816864529684659,-0.693733200734872,-0.4395356624042108},
{-0.2665538471643862,-0.6954972862841096,-0.45346711199029455},
{-0.2372370643405596,-0.6920722488055524,-0.4865810143622076},
{-0.24065469221923924,-0.6910621401087249,-0.5183720027667846},
{-0.2548883333246554,-0.6866322006791999,-0.5525703100937575},
{-0.26575060648576293,-0.6781003468093262,-0.5717479566526391},
{-0.256652418873893,-0.6593422438110815,-0.5792969371117219},
{-0.28657338447692826,-0.6630192076854772,-0.58854091360767},
{-0.35361484339109744,-0.47020199370304167,-0.4511002454780413},
{-0.32755327802701173,-0.45725481934394197,-0.4284472963171084},
{-0.3445859455510559,-0.46559722776829654,-0.4285646483584131},
{-0.35291333451619916,-0.5453557629264474,-0.5785772046263138},
{-0.32968143526753263,-0.5222187866599967,-0.5684797223282485},
{-0.33577292740474557,-0.5020126075343214,-0.5372112108447704},
{-0.3168518132091938,-0.4901774739352305,-0.5131025756970731},
{-0.3224560740895904,-0.47126176674499476,-0.47272526285054917},
{-0.3051652721265672,-0.455275855398254,-0.4458818845696484},
{-0.2792831392351931,-0.44610677593890635,-0.4409853406072908},
{-0.31464195011056323,-0.45108202186753155,-0.4006925372512627},
{-0.3345879922026978,-0.4573004784999445,-0.39538566166325084},
{-0.3648922544048068,-0.5630695128608625,-0.3809365413830158},
{-0.35918526042340454,-0.57568325522547,-0.3661760176484653},
{-0.35320831669511016,-0.5925372913146271,-0.36036128407965357},
{-0.32979658445481963,-0.5901429892568811,-0.35473479439962413},
{-0.3388407020135287,-0.606906708331314,-0.3487079860667481},
{-0.34365974556635576,-0.6253742348586828,-0.3398635271858219},
{-0.3567394916854276,-0.5422112889459584,-0.3725136286572884},
{-0.3454781014282104,-0.5344454274958637,-0.36673474153112773},
{-0.34284649191492494,-0.571652633151511,-0.36016422877480064},
{-0.3284896912439757,-0.5524016916316778,-0.35941625970607516},
{-0.3236464162969543,-0.5909282065844508,-0.3601387958238694},
{-0.33183162104823005,-0.6102582505894636,-0.3488245370702282},
{-0.3381864543702821,-0.6288965984329297,-0.3445680223297304},
{-0.3261644786986019,-0.5759924558257677,-0.5999835386727043},
{-0.3197205299185625,-0.548537685425237,-0.5928352773853804},
{-0.30799133357177555,-0.5238795383298601,-0.5764017861541413},
{-0.3006688465576,-0.501388999587866,-0.54697285803487},
{-0.2903757107708747,-0.48589192157359073,-0.5101403378216818},
{-0.3066093430648748,-0.47785030285237545,-0.4880781540563954},
{-0.28854313648763336,-0.47125776155587173,-0.49076944088761393},
{-0.27520445489175777,-0.45511604835224506,-0.4850984936083189},
{-0.2673410670865173,-0.4476497750485529,-0.4785742407863628},
{-0.2509716588812465,-0.44145875396163264,-0.4815192563485251},
{-0.2600556280717297,-0.4432220384730456,-0.4325440040115974},
{-0.28815963962910346,-0.4479305388060771,-0.4004836666384968},
{-0.28830022176732173,-0.4548577136538098,-0.3749341647037902},
{-0.32657461006479993,-0.459011495293302,-0.379037280700876},
{-0.3561244948955867,-0.6716433811646368,-0.35365559619042425},
{-0.3532836142506231,-0.6646431116154088,-0.3477447380826599},
{-0.3486440031705077,-0.6762928049581036,-0.36985318178231713},
{-0.3429534304645098,-0.6584829304847359,-0.34872200422867866},
{-0.3306975517480447,-0.6619446154437689,-0.3612598482594049},
{-0.3478565829889204,-0.3343531879903603,0.4550988260390161},
{-0.34037348789091143,-0.30176036072335316,0.4700752294672978},
{-0.346214455448479,-0.3055518730066674,0.4462277326504218},
{-0.34813774726535696,-0.3514869865397609,0.43145218945666},
{-0.3361678390522761,-0.3205140580135623,0.4286691837945242},
{-0.33415723411251613,-0.28093377780252093,0.4404174047896455},
{-0.3402176860340257,-0.2734887320011807,0.4534104385642037},
{-0.3270139793115961,-0.2741686128548147,0.4793472422871071},
{-0.3197451618316691,-0.2938723410050061,0.5035724284382846},
{-0.3345477400520114,-0.32189204333134,0.4908058881086335},
{-0.34106518405245834,-0.3453225999605088,0.47768989502799825},
{-0.34482485508224453,-0.37204141685968334,0.4538720366106327},
{-0.3449113671673019,-0.39148941368436946,0.4222951255646816},
{-0.3454781014282104,-0.3779288446110781,0.4184289165042228},
{-0.34084389735341103,-0.3757520243227125,0.4127898104784558},
{-0.32089304903432886,-0.34816748579459544,0.40706479314599997},
{-0.30375444425798065,-0.32616337727159306,0.403716855558061},
{-0.30289372911544193,-0.28015336670189894,0.42097381367299463},
{-0.31634255341220086,-0.26734076669733303,0.43138089709027005},
{-0.3278046036444818,-0.24636078503308884,0.45048604972602496},
{-0.31888504746749885,-0.24683139475504462,0.4714428012933556},
{-0.30140079486983334,-0.2614477316811661,0.5085144312971885},
{-0.30512962594337223,-0.2898052717100275,0.517600002563321},
{-0.3214203321823755,-0.32018202783526334,0.5083858647263394},
{-0.33312950258354723,-0.361441283326678,0.49033868279743226},
{-0.33503517156828383,-0.39333740794573446,0.4719899101275612},
{-0.3316505864998692,-0.4223495961367547,0.45345689875803086},
{-0.33536139422235445,-0.4241483265719065,0.42745861538208896},
{-0.3398898613043058,-0.4058145733612467,0.40848843761978015},
{-0.33383802053941086,-0.38348584425982296,0.40689737624065736},
{-0.3205237705971857,-0.37206224384312314,0.4054182598975231},
{-0.3039669195409573,-0.37094119140758763,0.3918789183265839},
{-0.2969558359810971,-0.3610353574090591,0.3862057681932711},
{-0.27877648281113004,-0.3481516652975595,0.38549144271317914},
{-0.2869268424170355,-0.31225475726351054,0.40979352849551876},
{-0.2841880940947091,-0.28968791966872276,0.4191162069577344},
{-0.28205533088669676,-0.25851553272419747,0.42505209749751777},
{-0.29398298435452974,-0.24733504728726532,0.42738972612917286},
{-0.2962891722515691,-0.22640913567618204,0.43645707378479554},
{-0.31323572820946816,-0.23230777795712124,0.44454294984582016},
{-0.3020394222755001,-0.2134809859654168,0.44664787698942743},
{-0.3118773683183933,-0.22269932925097757,0.4575514035985022},
{-0.30161947819595064,-0.2290471534920643,0.47951225607897585},
{-0.2898209920773354,-0.24494074522951934,0.5103438014291315},
{-0.2887846493917519,-0.2677819382792346,0.5227666965320268},
{-0.29677640350838547,-0.31195617041438883,0.5269617316194861},
{-0.317465808701754,-0.34245949051591235,0.5120303865688385},
{-0.3194113293182647,-0.3780075465773456,0.5019703527890735},
{-0.3240509403983801,-0.41585838612506354,0.47387415135048966},
{-0.3161471001829971,-0.46608365798728824,0.44027261720284794},
{-0.32171951980986563,-0.4616869616274845,0.43007921062528603},
{-0.31693852555370733,-0.4800329306649695,0.4081580095171303},
{-0.33246644352422994,-0.42981386684588546,0.4062343171813401},
{-0.33150960384273864,-0.4163269932524578,0.40086255752953526},
{-0.31842905668584215,-0.4088983687265221,0.39973569756977134},
{-0.30106936546990276,-0.39201950046480216,0.39764699144211235},
{-0.3074027710301466,-0.3786744105663297,0.4001007705583353},
{-0.28874059231139865,-0.38673885886554615,0.3879836716449832},
{-0.2709785798480511,-0.38529138351648395,0.37562666190316174},
{-0.2779992758618065,-0.3684575736323981,0.3754250006308173},
{-0.24493103264589602,-0.37269406242728076,0.3639106826804808},
{-0.2658265048196443,-0.33608523202661367,0.39352404975886757},
{-0.26468863058979214,-0.3071641618881422,0.40684510852260186},
{-0.2727266446407966,-0.27143346920269895,0.41935111129979996},
{-0.2724476832183777,-0.23125901918525638,0.4232824046835079},
{-0.27231150678819477,-0.20348743832509397,0.4295311004937997},
{-0.332343484218153,-0.5099691159866723,-0.3652804573605563},
{-0.31942354514508997,-0.6107615026027722,-0.6036004247102545},
{-0.2908577352818311,-0.5870664032320274,-0.6037111681895063},
{-0.2734213446941858,-0.5628748606694833,-0.5992583991819801},
{-0.29820585550639406,-0.5495287694737301,-0.5958273539197384},
{-0.2860212691563189,-0.5325958311588493,-0.5860210488709171},
{-0.28707363259839447,-0.5115315402635654,-0.5646091075597544},
{-0.2696360404540122,-0.49612638133966364,-0.5459671550460776},
{-0.2749371085177956,-0.4764843331019669,-0.5120992758217546},
{-0.3337444993733881,-0.6399322962830643,-0.3508685853391654},
{-0.32056302145059135,-0.6501613490438212,-0.3637556818614196},
{-0.3157668074757656,-0.65207522866626,-0.37550670648892703},
{-0.33348436233984746,-0.6663086695122199,-0.37892273229195744},
{-0.339276266330658,-0.6820736946788258,-0.39890562212402386},
{-0.3269048379079936,-0.665923770837497,-0.39738845648422094},
{-0.31234477388905063,-0.6571778396089973,-0.39702498557130617},
{-0.29004748552224263,-0.675912311991416,-0.4150819802135647},
{-0.28488119207244905,-0.6864409528985753,-0.42680536903612315},
{-0.2591272252330119,-0.6871340508763152,-0.44023256531161775},
{-0.24135479927794448,-0.6888092212270217,-0.46059975304003864},
{-0.22605317449287296,-0.6849037613131572,-0.4802397986831739},
{-0.21688830048210458,-0.6799625594920778,-0.4999036752015911},
{-0.21993104265886884,-0.6775402211104706,-0.522909681783719},
{-0.2298673160947323,-0.6773313504977048,-0.5413211356633654},
{-0.23521304201723753,-0.6684490425795659,-0.5602594721721462},
{-0.22793441182395907,-0.6362889759973022,-0.574097200332751},
{-0.2396624066140091,-0.61500239710569,-0.5884978578245975},
{-0.26522352359717244,-0.6311262872177192,-0.594176014444314},
{-0.2852500699906799,-0.633570453880047,-0.5985927367497329},
{-0.3051905048180422,-0.6474091833379326,-0.597366548099718},
{-0.32891524258829735,-0.47638099922259275,-0.3624764244555246},
{-0.32167325987549467,-0.46477936814937426,-0.3649508302957311},
{-0.31077173586098145,-0.4805528042131385,-0.34136647440423806},
{-0.3202055583213611,-0.49993311334164536,-0.34096996068105834},
{-0.3151029473786237,-0.6416987849457756,-0.3719288710453263},
{-0.3097488105589602,-0.6325847768368699,-0.3811742493574675},
{-0.32249432364571534,-0.6578234760956293,-0.3844172509903831},
{-0.28005333710355135,-0.605635461303665,-0.6028168094583342},
{-0.2529760557778658,-0.5913843976255636,-0.5990649485473378},
{-0.25182135975369685,-0.5627719273090216,-0.5999767298511952},
{-0.2677363792529601,-0.5417683150289515,-0.5897312558150339},
{-0.26624524734245686,-0.5112567842897258,-0.566918299348636},
{-0.25172623651202497,-0.5066640339223498,-0.5850814315026548},
{-0.2538790256656524,-0.4860559340681787,-0.5762874380046789},
{-0.25520294093026924,-0.48082335473839904,-0.555512922542446},
{-0.26287888588455205,-0.48295511664913066,-0.5347870701280578},
{-0.26137914281743424,-0.4657414145767255,-0.5189062949957965},
{-0.2948432989781561,-0.4636905574862792,-0.357417269814772},
{-0.27984907245827695,-0.49073519652061204,-0.3121674441406286},
{-0.2936721816785828,-0.4977386702211385,-0.30885154806567383},
{-0.3020970969988717,-0.5153781238973214,-0.2976318117753361},
{-0.3101359120877008,-0.519631835005433,-0.30971967280809015},
{-0.31118647319467097,-0.5350223749890357,-0.323680360274772},
{-0.31805877695141826,-0.5238679232814034,-0.34697494073321394},
{-0.3149667709484408,-0.5392772876538843,-0.3529891327203524},
{-0.3095731830159154,-0.5522655152014949,-0.356082540539523},
{-0.3169112902676708,-0.5639566622516132,-0.3621636191850161},
{-0.3119218259176589,-0.5855396251383292,-0.3703668472873454},
{-0.3053509126424195,-0.6063688114320914,-0.38120909450283785},
{-0.29763611735364337,-0.6242323554397076,-0.39067796236804403},
{-0.28429262953082013,-0.6274411127056214,-0.3953317918695462},
{-0.2812482852784067,-0.6551255807023579,-0.40532654106660587},
{-0.25917248387010206,-0.6762315255645213,-0.42721710247797046},
{-0.23696270888563223,-0.6773655948647066,-0.4460735328691853},
{-0.22074850175887878,-0.6696538034677729,-0.4574216354709161},
{-0.212884713434726,-0.6707372071255517,-0.47680655056691446},
{-0.20413978350350714,-0.6634139190735516,-0.5026942907230608},
{-0.20936555401177767,-0.670552167388068,-0.5153933436159889},
{-0.20845217063227117,-0.6589224999909883,-0.5377282807605533},
{-0.20698286700248839,-0.6474069804839149,-0.5485553082573782},
{-0.21861373595630496,-0.6442863373787078,-0.5623239469056109},
{-0.21314605202500359,-0.609148813202385,-0.5763883687705791},
{-0.21465801091894657,-0.5636132172843136,-0.5991168157464811},
{-0.23009901628549947,-0.5676572567418348,-0.6026051352131822},
{-0.3218404765213811,-0.43283377944464846,0.3990972704235607},
{-0.30604901710656324,-0.4255929982885826,0.3914443553067354},
{-0.28449669391663834,-0.4179715239063731,0.3803637993384228},
{-0.26625445927743985,-0.40236310163447764,0.37940055135433465},
{-0.32074145262602227,-0.4635687997369391,0.39781060341778807},
{-0.3157892365348545,-0.4557993336166336,0.38996984493109266},
{-0.2985016387231296,-0.4730284556671623,0.3721245245339862},
{-0.2898386149094767,-0.4461822737538755,0.3726179638339432},
{-0.2751630011843344,-0.44750198356991316,0.36588724351269497},
{-0.24176973687109016,-0.43009883605198884,0.3661662049351139},
{-0.24567900171462143,-0.41011614647937866,0.3722404747590979},
{-0.24742446313443697,-0.3985836049185324,0.3701844109227915},
{-0.31007903840215384,-0.41830635771705815,0.48839636633221994},
{-0.30390423833118185,-0.47075350824528256,0.45395854869569013},
{-0.300994268173846,-0.5097338111256944,0.418577308761231},
{-0.3050443154150517,-0.508238674026068,0.3893248092228291},
{-0.301114624106993,-0.5089810358300213,0.3756484901838822},
{-0.3069630012644382,-0.48653835909804743,0.37882080022877634},
{-0.2779926672997535,-0.486438629888884,0.3560498982481703},
{-0.26378626148037393,-0.46697721568063577,0.3562940145252188},
{-0.25315588876948975,-0.45410273550411906,0.36068670569589956},
{-0.22955771497552227,-0.4684753566721044,0.3578906831691139},
{-0.2233014093058967,-0.46778666440239974,0.3551587436682966},
{-0.22606438902241743,-0.4380343172614439,0.345682666462669},
{-0.23693527334013947,-0.41083227429457597,0.3564239829122611},
{-0.25602100080864765,-0.38410304390368155,0.36849041618320694},
{-0.30705732346828546,-0.37456528678555934,0.5132391526461683},
{-0.30036805685446066,-0.4157244125488983,0.4963666926870453},
{-0.29743986308661496,-0.45722818483627387,0.4720802271422854},
{-0.28029424922930146,-0.49336620525552904,0.455754876017368},
{-0.2898422195796874,-0.5106868458775188,0.43456962841056873},
{-0.27565684100320376,-0.5527501430853813,0.4069123956998687},
{-0.29029240283711577,-0.5382393428926516,0.3959371762054918},
{-0.27911772492441206,-0.5604945767736679,0.36006870501421634},
{-0.2828087069607383,-0.5415772675077831,0.35505601056729097},
{-0.2807059826711487,-0.5314355278699082,0.352190898528133},
{-0.2677620124633475,-0.529103105984113,0.34411243206698594},
{-0.25209811832209805,-0.5080910828068845,0.3432026533576902},
{-0.23509528945702052,-0.4964976623713683,0.348317680386709},
{-0.2148494589590273,-0.5002707507847166,0.35221813381416955},
{-0.2077544666870397,-0.5016715656804955,0.34799826655414756},
{-0.21580870175399247,-0.4587141100009172,0.3316506866295973},
{-0.21721972988203514,-0.42803956806438415,0.3255139358552941},
{-0.21950689313074018,-0.3982547788915318,0.3334640360050481},
{-0.21563647862170224,-0.37650760325077165,0.3380637954533894},
{-0.23188212648307144,-0.3439001570434655,0.36989043004116123},
{-0.2506618575025803,-0.33606200192970004,0.3863958144171588},
{-0.23185949716452633,-0.3112474521990691,0.3858741385338844},
{-0.26077696263278705,-0.2905101849956804,0.40762311650974997},
{-0.26377684928593487,-0.27586901589699614,0.40459058756524946},
{-0.2701757396883402,-0.2585952359877457,0.41153037875871973},
{-0.2624319067784221,-0.2446393547480115,0.4041566253237694},
{-0.26242509795691293,-0.2132282585317537,0.41957940707981256},
{-0.24934134664871807,-0.20886460498221493,0.40324464376045605},
{-0.2473880159134174,-0.1928506573116129,0.41057233752049155},
{-0.2754075179802953,-0.19414433339835088,0.436859795551116},
{-0.2880398844743249,-0.20031012179379604,0.45120357935741545},
{-0.2820164805522034,-0.20627484969526516,0.47023443573493817},
{-0.2812018250845795,-0.22620406999308298,0.500029237880598},
{-0.2720549744248648,-0.2434149684331019,0.5205744562655376},
{-0.2749877741602019,-0.2699948052697074,0.529788393843063},
{-0.2821011903021554,-0.3065015033477373,0.5328966208619887},
{-0.2878318148993836,-0.3368243896792684,0.5290117876721079},
{-0.3032009271211782,-0.3479892548786207,0.5222574367350339},
{-0.29384360377304836,-0.36146511420196004,0.5225994798861404},
{-0.2891391086291399,-0.39777936294262844,0.5079997644948795},
{-0.28037174963883205,-0.45741582794668767,0.48056642185615683},
{-0.31797927394732617,-0.6776049049148075,0.40619686866303983},
{-0.3138196847836056,-0.6671283314662476,0.40658557226742964},
{-0.30799794213382853,-0.6596542480437655,0.3924758917653711},
{-0.3097704385802245,-0.6754396996748988,0.39088983687265216},
{-0.2990293223900886,-0.6647444429002215,0.37861072805927354},
{-0.28080991732889127,-0.6442116406015632,0.36053170487683844},
{-0.28471237335091343,-0.6337977483627787,0.37267083233036713},
{-0.3003918877297426,-0.6466007359134494,0.39291886568237805},
{-0.2979443166566603,-0.6491011754829557,0.401693033494195},
{-0.30521273361767504,-0.668119615774197,0.41267846622083565},
{-0.3070811543435675,-0.6799405309519013,0.41623687649718977},
{-0.30816355670406576,-0.6856761620355332,0.4102627364012814},
{-0.3133905287690732,-0.6836170943073845,0.40163956421940267},
{-0.30153817285675316,-0.6815404037470946,0.3913099812116578},
{-0.2824740734095093,-0.6709404704735454,0.3631637149090361},
{-0.27330359213396876,-0.6570955329725192,0.34635313512186383},
{-0.2630040480446466,-0.6492691931666666,0.3275916277128647},
{-0.26790720056905726,-0.6146076857176157,0.3558121902737186},
{-0.2794978173721874,-0.6261119906951446,0.37796128664297457},
{-0.28120522949533416,-0.6296477716529536,0.38829767847222857},
{-0.2688888724231113,-0.6324077474776321,0.3954445379433593},
{-0.29027958623192207,-0.6596668643895031,0.40893902139612076},
{-0.2907708226778614,-0.6807938364945623,0.4120268219505191},
{-0.29322199842115443,-0.6838433874928356,0.4011671521623415},
{-0.3046013414980448,-0.5561137009109001,-0.2820161801630192},
{-0.2978007306265998,-0.5643473684505645,-0.31903053596239284},
{-0.2963852967905218,-0.5573759362630223,-0.34426843418332786},
{-0.30063440193114194,-0.5409017923621845,-0.2728088511475467},
{-0.28507824737730203,-0.5349574909252427,-0.253914171200207},
{-0.28529352629266475,-0.5636768997913697,-0.2168789884173936},
{-0.29625492788456725,-0.5675897693051117,-0.23781691559584595},
{-0.29898746816375293,-0.5905204783317265,-0.23932226592773595},
{-0.29555221745293203,-0.6190342207363859,-0.23536814296602676},
{-0.289825798304283,-0.6211417512529231,-0.2534906224504468},
{-0.28446044695507494,-0.58817303698672,-0.31097950504673855},
{-0.27596203641437844,-0.5799329611444588,-0.34065555333490066},
{-0.2919795887551912,-0.564674592401916,-0.36389326010779566},
{-0.2920632972078625,-0.5750916887919988,-0.3762230345635805},
{-0.2967762032489293,-0.5883540715350808,-0.3818679481135759},
{-0.2618551595447061,-0.5916595541183156,-0.3897419496699924},
{-0.2531731110827187,-0.6204568639128853,-0.4001189941688451},
{-0.24725224000214677,-0.6475643844164499,-0.4140732733329301},
{-0.21752772892559596,-0.6435373670127015,-0.43253439155770207},
{-0.1988781665525855,-0.6477570340132675,-0.4610212991952373},
{-0.19819007506124933,-0.655865138873925,-0.48604772343047653},
{-0.18662449069013815,-0.6519574761060428,-0.5119266521705521},
{-0.1981281948892986,-0.6521080712170688,-0.527452367287057},
{-0.19083154134496652,-0.642774578744221,-0.5422219026971344},
{-0.18834732279140853,-0.6296249420749523,-0.5630885375091969},
{-0.20212357129897493,-0.6180339247529099,-0.5690310366110332},
{-0.20492860550128747,-0.5869204140884929,-0.5912574331303636},
{-0.20716410181030542,-0.5416904141005086,-0.606778342019921},
{-0.22139033331584398,-0.5301092094918175,-0.6110054186203645},
{-0.23212764457631305,-0.5296984773472511,-0.611654259258295},
{-0.239552464172582,-0.5589722043880051,-0.6051924873866581},
{-0.24290100253888938,-0.5419020883456607,-0.605115587755496},
{-0.2560546443972811,-0.5342429651856945,-0.5865667558889297},
{-0.25061920223842005,-0.529031613358267,-0.5893101101787476},
{-0.24089540408553317,-0.5087299104720074,-0.6046323616878027},
{-0.24905637744261463,-0.48656839801647006,-0.5928541017742587},
{-0.2404962869894235,-0.46757378860051074,-0.5907547818954236},
{-0.2394725606495776,-0.46431777010294534,-0.5708888435857497},
{-0.24131755101910032,-0.46556158158510164,-0.5462385066091628},
{-0.302123931765996,-0.617712708585243,0.16897111898175274},
{-0.30594928789739984,-0.6204754880423076,0.15640664044335842},
{-0.306231253211661,-0.6360835097952907,0.1656910693494491},
{-0.296826067853511,-0.6418061240142728,0.18614436864401518},
{-0.29791848318681685,-0.6555281022092222,0.17307984224361078},
{-0.3050106718264183,-0.6512501597069161,0.15675569267543024},
{-0.3071724726555725,-0.6375780461165487,0.15309615137371976},
{-0.3041964168777067,-0.6267153724365286,0.14745764612632123},
{-0.29427936834963375,-0.6115363064386219,0.1459643113618003},
{-0.29057957489723685,-0.5957670758234368,0.1609589384005918},
{-0.2897492991920332,-0.6134610000716928,0.18781112809756315},
{-0.27584949060002134,-0.6395572103216927,0.23613994291003423},
{-0.27518943543254637,-0.654612515975698,0.23430356369712596},
{-0.28613341445176366,-0.6558663404306619,0.19180109750192345},
{-0.28970864652243444,-0.6624965305049221,0.15194225638737546},
{-0.29464864678677694,-0.6606269082222926,0.14378809185180316},
{-0.2940250388403215,-0.6544729351347606,0.1293748180142192},
{-0.29801220461229566,-0.6361255642810825,0.14000559124401574},
{-0.2836910501245413,-0.6154760107194882,0.1329704765494174},
{-0.2848912050452566,-0.5948080332879279,0.1420890906258148},
{-0.2878214014076637,-0.5915604256875207,0.14954394914050642},
{-0.2785169465559579,-0.5851076654914106,0.14990061123191203},
{-0.2768105357300919,-0.5851507212744831,0.16247350066746474},
{-0.2802471882571059,-0.5977404325043525,0.18838587273671767},
{-0.27912633608102655,-0.6081365016515398,0.21527110524395407},
{-0.27539570267238234,-0.6177501571035434,0.23389984063352476},
{-0.2613715329581005,-0.6188662030526749,0.2691539158133277},
{-0.2625426502576738,-0.6476384804152259,0.2786788563262563},
{-0.2609371701977081,-0.6658785122004067,0.2704393812623635},
{-0.26150590705317805,-0.6640859898083957,0.2390637309698445},
{-0.27234995660377587,-0.6586607608817985,0.2291290596096302},
{-0.2681352960896137,-0.6573220264174264,0.19227411033735303},
{-0.27649172267589883,-0.6702351566689804,0.12611379303024997},
{-0.28705120353930547,-0.6693205717327368,0.11032013076141448},
{-0.28554485191013473,-0.6651677913905255,0.09731508141948707},
{-0.2841312204091621,-0.6381527907557031,0.11155873549771082},
{-0.2629365606079236,-0.46101709374665817,-0.35926085836810173},
{-0.2656570853197402,-0.48337686306378536,-0.32164151875169467},
{-0.26161364664058756,-0.5163027218063723,-0.2685985963414199},
{-0.2824965024685983,-0.5198727471311831,-0.272161011806897},
{-0.2596374863272856,-0.5368575526452071,-0.23295301392484102},
{-0.2741801277735434,-0.5478273651342679,-0.224487045416041},
{-0.2734303563697126,-0.5697419576803706,-0.1924106872864483},
{-0.2866915375560576,-0.5995099250589063,-0.18078702767305319},
{-0.29728546304592224,-0.6057448029667236,-0.20568608689418008},
{-0.29741623247078913,-0.6369376163757764,-0.20038261571692284},
{-0.287615334427284,-0.6646310960480398,-0.20673043995800958},
{-0.275181024535388,-0.6585444101377744,-0.2360259952794841},
{-0.27942752630307827,-0.6184845085292504,-0.27576708383381504},
{-0.26241528524356156,-0.6118967734596943,-0.3043403032969515},
{-0.24976249228500444,-0.6059666904441394,-0.32052687461875606},
{-0.2537983211048234,-0.5896195110385014,-0.3419896818317812},
{-0.27622697967486676,-0.5726403127892498,-0.3608230823855387},
{-0.2655595589645945,-0.5766647268200681,-0.36766174255365247},
{-0.27293751784812403,-0.5787498282775162,-0.3785628660492534},
{-0.29717351800993363,-0.6639996779827945,-0.10908152602511816},
{-0.2966031790788145,-0.655010631774527,-0.11945857052397085},
{-0.30047219177165935,-0.6782557481472996,-0.12552943593720026},
{-0.2922717673017161,-0.6755466382244837,-0.10055087371198125},
{-0.29709802019496456,-0.6868799216264592,-0.12593095614678376},
{-0.29589566242023163,-0.6793349463564994,-0.16162339927610211},
{-0.2991170360318829,-0.6699716152246851,-0.13946128604219626},
{-0.29452909189145454,-0.6491572481306781,-0.14126702555831336},
{-0.29535956785611434,-0.6327259597534566,-0.14014196793365483},
{-0.289620732621184,-0.6247584370310173,-0.1092761782164973},
{-0.28868732329606234,-0.6407848007879008,-0.09298226782619563},
{-0.2814050884325732,-0.6581486974524193,-0.07546717527228278},
{-0.2807079852657102,-0.6706428849217044,-0.07886017123785577},
{-0.2848928071209058,-0.6853657598784985,-0.0994276184224281},
{-0.28853772948231726,-0.6934456281558385,-0.12268074517344672},
{-0.2917442838942133,-0.6924477352858364,-0.1492289410159803},
{-0.28439055640487815,-0.6914702688803613,-0.17663004188226267},
{-0.2973090936617481,-0.6575709489214225,-0.16636634423559163},
{-0.2944790270274167,-0.6260246775722625,-0.16875684136367078},
{-0.2916986247382108,-0.6190121921962094,-0.13662781499711024},
{-0.27918941780971424,-0.6032982331909221,-0.11607759012576695},
{-0.2733148066635132,-0.6067945630358692,-0.08640975247530701},
{-0.26929599989746716,-0.6137405622724803,-0.07017812277586842},
{-0.2694898510510217,-0.6382366994678305,-0.060303729511955693},
{-0.26885763194795176,-0.6581196598312774,-0.05973959862397723},
{-0.2674339874741715,-0.6731521359072814,-0.06921367323504332},
{-0.2643271622714389,-0.6923536133414452,-0.09237387959840769},
{-0.2697830308948273,-0.6978040749595175,-0.11227346149671513},
{-0.27679651756816126,-0.6992185074983148,-0.15114201960059453},
{-0.27220597005480296,-0.6983898338687603,-0.1781986742022965},
{-0.2678282983433336,-0.6912892343320005,-0.2012120903843019},
{-0.2762942668521336,-0.683496137595869,-0.20180265552049237},
{-0.24542687505932684,-0.6852199709944203,-0.22479204056775962},
{-0.2604241054710483,-0.6501843788812786,-0.25979418935172405},
{-0.24088659266946252,-0.643072164296062,-0.278839864929002},
{-0.22240484772070693,-0.6334438899037592,-0.2922193994539325},
{-0.23298956127558865,-0.6087354776848886,-0.3217342388798928},
{-0.23008880305323573,-0.5849360431374889,-0.3493506186615379},
{-0.2712170888603274,-0.36643955909276055,0.5197762220733182},
{-0.2700858231925282,-0.40924702043968164,0.5026362154807769},
{-0.26696878475753183,-0.4406647252179924,0.48884935322203443},
{-0.26042570754669747,-0.4797830068636926,0.46825366945414476},
{-0.2462056840842996,-0.5051412610177746,0.4537364609588182},
{-0.259057334682815,-0.5241118392989957,0.44074743237338293},
{-0.2606253662244804,-0.5491586899987624,0.42292293895971617},
{-0.25578169075854673,-0.5697443607938444,0.40821588449995805},
{-0.25307638576539765,-0.594387688689466,0.39139449070215365},
{-0.26501004701691505,-0.5852532541160328,0.38248695009253986},
{-0.2693847148365422,-0.5877004246702026,0.35643840159310397},
{-0.2621349220049496,-0.5781170083960779,0.3339676885372689},
{-0.24852468858653268,-0.570509752435255,0.3239721383023845},
{-0.2265247855121095,-0.5409298286860457,0.3308756825342914},
{-0.21419461053741226,-0.5230296371979537,0.34529055844752454},
{-0.19297672063926022,-0.5328920148944972,0.343838677390427},
{-0.186527765372817,-0.5334427283989136,0.3373160266441201},
{-0.20581675618931886,-0.4884211985047827,0.3316727151697739},
{-0.20064926118278842,-0.48544674480256617,0.31468310342880235},
{-0.19773788920925947,-0.4697173658191553,0.3002764381532713},
{-0.19643500118753857,-0.44596419120612657,0.2975118563611014},
{-0.1910297982065564,-0.42404479243307625,0.2985003370366647},
{-0.19121784183588256,-0.40533995845016796,0.3049677161730738},
{-0.18849030804310063,-0.38071665650016157,0.31674597608661775},
{-0.20719534228546505,-0.35343150585899086,0.3484556591519973},
{-0.2132886367577834,-0.3316753185427039,0.37034722186064256},
{-0.29321178518889074,-0.5478031337400736,0.6299810033879893},
{-0.2950551734827642,-0.5281815119669043,0.6699091342743658},
{-0.29121479789214905,-0.5223253246906692,0.6365453081011758},
{-0.2904550135155107,-0.543501961140854,0.6082188082880179},
{-0.28358090742365805,-0.5199550537676614,0.6067635228201658},
{-0.2729347142157379,-0.4933826265309334,0.6025406516683014},
{-0.27081116294270857,-0.47814228113944424,0.6201548726530092},
{-0.28261826021793834,-0.48845303975831084,0.6393573513844536},
{-0.28995156124274607,-0.5043978979165405,0.6583271286278501},
{-0.2851144943388654,-0.46780028204541796,0.6817018128687528},
{-0.28851229653138605,-0.4802514137316306,0.6968494381320438},
{-0.2901990819305492,-0.5133396828931563,0.7043942131425475},
{-0.2925555349510826,-0.5503282052226866,0.6816517480047148},
{-0.29300892235980935,-0.5748273463098791,0.6557013266387931},
{-0.29028939894527345,-0.5736085672597417,0.603549358548936},
{-0.2860953651550949,-0.5628668502912373,0.5856275390395796},
{-0.2782580110791541,-0.5316734361038161,0.5814258953900674},
{-0.2695154842614091,-0.50482304874195,0.5816387711919563},
{-0.25695501091213774,-0.470062212602648,0.5988060130705342},
{-0.2604441314166634,-0.45470972191571396,0.6259065244931332},
{-0.27409301491011756,-0.46149991929543915,0.6409347951205581},
{-0.2805379649874377,-0.4652059207909767,0.661467196900304},
{-0.2698643362340248,-0.43706826564496953,0.6680743571371067},
{-0.27686881123183193,-0.430856818093522,0.70066738466357},
{-0.2838035959388984,-0.4513549755062659,0.708309085250851},
{-0.2819804338500962,-0.46538335066912684,0.7273441470769528},
{-0.27992997727856206,-0.47129000332831217,0.7465684540891179},
{-0.2892536570380585,-0.5058321561414969,0.7356551147666917},
{-0.29269912098114315,-0.5356970490968098,0.7143721405452904},
{-0.29336177952154807,-0.5584637456288366,0.7015589397623561},
{-0.2898928852220937,-0.5766631247444188,0.7020511775055761},
{-0.2889674862752182,-0.5972954559927842,0.676887175023961},
{-0.28662084596803616,-0.6020736466165564,0.633202977778009},
{-0.2835078127221628,-0.6052952204876637,0.5990196899102477},
{-0.2818424550848079,-0.598632588381507,0.5745077322178614},
{-0.27959514346787695,-0.5880546836481345,0.5611061691527542},
{-0.2752449073019003,-0.5512854454230902,0.5622091982372361},
{-0.26450959863599277,-0.5284182186440752,0.5500093921684934},
{-0.2555103391954616,-0.5136879340874037,0.5491590905176746},
{-0.2582220524912076,-0.491313145311065,0.5789268576367541},
{-0.24463124424003738,-0.4778306774256727,0.5775991374424704},
{-0.23953003511349302,-0.4627239050914364,0.5926816783825124},
{-0.23982241391947404,-0.44851749927205686,0.6095799718114788},
{-0.24614840987984032,-0.4352731398800285,0.6310752210564007},
{-0.2603177676998319,-0.432702208981957,0.6496789240139524},
{-0.2878181972563653,-0.5457124250178531,0.7369015296217779},
{-0.28379518504174006,-0.5159773001901263,0.7591785917835147},
{-0.27680392716803887,-0.5543353969402758,0.7570592459590644},
{-0.28561053701175243,-0.5684733140256515,0.7288306730199645},
{-0.2703347456965244,-0.6003618287853743,0.7280993254860997},
{-0.2840745469830712,-0.5995023151995725,0.6980572029120928},
{-0.27995641152677403,-0.6153023857710048,0.6668309461738628},
{-0.2731285653692924,-0.6331901611728155,0.5979376880686618},
{-0.26979304386763486,-0.6280324788796364,0.5535243461428626},
{-0.26646232859292496,-0.617957625900116,0.5326957606274689},
{-0.26606681616702593,-0.5765918323780289,0.5269122675338168},
{-0.27437137555416796,-0.5709300970337169,0.549032526541387},
{-0.2550553497110856,-0.5418664421624657,0.52012787767832},
{-0.24316935021013222,-0.517815681997596,0.5186247302004476},
{-0.24047045351957994,-0.49738961798906656,0.5385036853747714},
{-0.24804386563231323,-0.4921828721291305,0.560165350227755},
{-0.2312813481146173,-0.4761987631174949,0.5605967090963051},
{-0.2050495622128029,-0.44405071210260005,0.6003233789697932},
{-0.23195622248184747,-0.4233542978282662,0.6336533612948936},
{-0.24818765192182993,-0.41141903450109957,0.6577872291340661},
{-0.26173179971971683,-0.4144727909479521,0.679868838066599},
{-0.2588206280056441,-0.40088598788590496,0.6958227079003556},
{-0.26372918753537083,-0.39693186492419574,0.7260694956385492},
{-0.27503183124055525,-0.42570554410293976,0.7227165515642066},
{-0.2724498860723954,-0.4376762533538452,0.7600192809804381},
{-0.277125543854618,-0.46180691704171917,0.7725875644484993},
{-0.2843156593682775,-0.48197805076256794,0.7508616163100913},
{-0.27936003886635524,-0.4881272176231525,0.7759617360251942},
{-0.2856063315631732,-0.6078421202509972,-0.14402359697223724},
{-0.2689892024106432,-0.5952826481990066,-0.1077357824797808},
{-0.2584118984556391,-0.589509168078162,-0.07810819698000729},
{-0.249781717192795,-0.5891312784844044,-0.05589081213620367},
{-0.2528296661154191,-0.6166483295757983,-0.045255833457827965},
{-0.24950475836493757,-0.6334332761525833,-0.04034547159299589},
{-0.25830495990605423,-0.6548462187610267,-0.050842872024995586},
{-0.25030339307606936,-0.6675893287343081,-0.05695198699434988},
{-0.24954941622365936,-0.6891732929183049,-0.07940848162879827},
{-0.23827721195580992,-0.6984499117056058,-0.09229778100507018},
{-0.227743764821703,-0.7010929360078918,-0.12027062261866474},
{-0.22427707337626626,-0.7009453447887082,-0.16781922658996995},
{-0.2351283322672855,-0.701060293716539,-0.19645953297091712},
{-0.24050429736766954,-0.6988770651255766,-0.20536907617509242},
{-0.2137372179395625,-0.6921187089993794,-0.22692200014338576},
{-0.22056766746997405,-0.6727698406054885,-0.2498050474194366},
{-0.2795564933928397,-0.600558483571315,-0.15910233298261228},
{-0.2616789312232929,-0.592715722490058,-0.14180452193862367},
{-0.25458894543770905,-0.5928428872447141,-0.12339126572387185},
{-0.255877214519131,-0.5901950567154806,-0.09883745380514995},
{-0.24198481552699677,-0.5797843686279943,-0.0760599432624909},
{-0.23559994328652198,-0.5717006954209873,-0.05233941094081492},
{-0.23813082229336327,-0.5962759351015174,-0.035870874304749244},
{-0.2311617932192949,-0.6037408065890166,-0.02914896539957169},
{-0.21996308417185303,-0.6119862894365939,-0.02851133929118567},
{-0.24402245549333718,-0.643905644152564,-0.041239429805255697},
{-0.22668279022301294,-0.64717828418499,-0.0410165410305592},
{-0.20349114312503275,-0.6704242015955871,-0.055083766527913566},
{-0.23169067844299074,-0.6798870616771089,-0.063627035186788},
{-0.2030075165384272,-0.6979654840811754,-0.08067692502406118},
{-0.18748320323811526,-0.7021426960770374,-0.09228636621606955},
{-0.15835206093014106,-0.7005578427410551,-0.10142600753536282},
{-0.15698749299592551,-0.7022864823665541,-0.13140324604557665},
{-0.17905728662054557,-0.7014846435041239,-0.19726137183334727},
{-0.1905968372623571,-0.6987587117869911,-0.214216739207317},
{-0.18437337414354035,-0.692529441143946,-0.2215350207729134},
{-0.19511689344715008,-0.6765293113758184,-0.23980228784413085},
{-0.19188270323030518,-0.6566966161358656,-0.25621054638389495},
{-0.2232709698685617,-0.6579574496717947,-0.2636774204659557},
{-0.2190346813331352,-0.6493380824195828,-0.27608069014214814},
{-0.2005090795634824,-0.6333435599162274,-0.2854734594140168},
{-0.21399274900561163,-0.6168565994101959,-0.31007052737526736},
{-0.21364169417897827,-0.6009902429587772,-0.3244255257111113},
{-0.2046302189116219,-0.5896207125952383,-0.33734145959505135},
{-0.20748611901579683,-0.5806244570465494,-0.3555848957909868},
{-0.22820195845737734,-0.5777383177644956,-0.3645084571570927},
{-0.2440432824767769,-0.581089459503733,-0.3840938319686986},
{-0.23100919551370755,-0.6019218499487935,-0.4000623207427543},
{-0.2192026990168462,-0.6199920617151582,-0.4148981420328177},
{-0.21121895527845877,-0.6071708505539776,-0.4101992541536815},
{-0.199627537437504,-0.635286076640896,-0.44090543708428637},
{-0.18797904565154613,-0.6357114277257614,-0.4379049496527701},
{-0.18137268645256796,-0.6481006792400232,-0.45906216093570823},
{-0.18378601315864831,-0.6529185212361134,-0.4864664659532891},
{-0.1617514651983109,-0.6600469568372783,-0.5039198785947073},
{-0.2627593309892296,-0.5791391326602745,-0.16831566978176923},
{-0.24872474778322792,-0.5763196797771192,-0.1598318781813718},
{-0.24518255852282214,-0.5866440560390042,-0.13140685071578737},
{-0.24264907614305092,-0.5867069375082355,-0.10329022281267611},
{-0.23760474070205354,-0.577795792228411,-0.09008911946317649},
{-0.23214747026247204,-0.5626003049550998,-0.06240565276372068},
{-0.2240495786340783,-0.5386913284851854,-0.057621254096807836},
{-0.2141405404842514,-0.5429592580146838,-0.04020729256825144},
{-0.2190671233650317,-0.5724412548898352,-0.028146666821533984},
{-0.213427016041984,-0.584075127735494,-0.02403033370034217},
{-0.1956866315999008,-0.5925352887200657,-0.027215260090973872},
{-0.18032753235091384,-0.6170374336991006,-0.03571246907493349},
{-0.20607108569863114,-0.6278300165694674,-0.03420151147827125},
{-0.2719260073351033,-0.66812362096332,0.403920519424967},
{-0.2667711286743104,-0.6491514406064497,0.40154043578860765},
{-0.24198661786210213,-0.6323092198252055,0.3921911228187239},
{-0.23674602815407642,-0.6531390068973362,0.38617072278844466},
{-0.25694479767987405,-0.6728134971669293,0.393859284088465},
{-0.2766683515162244,-0.6787473851121512,0.3976455896259193},
{-0.26419999751678275,-0.678899181779914,0.36761107691124617},
{-0.2546516266474844,-0.6770513877780051,0.34005056951786733},
{-0.25825509530147256,-0.6701744780537663,0.32278720310033676},
{-0.2602192400474054,-0.6416773571839675,0.31309324360641644},
{-0.2593825560396049,-0.6061933841485029,0.32689953103240554},
{-0.26504489216228544,-0.5998241321456078,0.37077317372387664},
{-0.2667170586211495,-0.6147118206348143,0.3804471072721818},
{-0.2548328614553015,-0.6102858863944125,0.388451677994009},
{-0.2396582011654299,-0.6076464667623372,0.39100798995178143},
{-0.2828862073702689,-0.6770039262868972,0.08575610561042886},
{-0.2799756364345646,-0.6588107552144559,0.08977130770626422},
{-0.2766637455487329,-0.6346134051276833,0.10380248650151133},
{-0.27317983179006716,-0.6088902782444935,0.1276263527025614},
{-0.27250115249317014,-0.5883008025197446,0.14099667529250895},
{-0.27870158577452947,-0.6811719263477761,0.09877136818461997},
{-0.2778747144800804,-0.6811096456569131,0.0832458533275712},
{-0.2749062685615483,-0.6741946866360056,0.07863908479826462},
{-0.27272604386242816,-0.6574447854640472,0.08964334191378348},
{-0.26760400775244403,-0.6265141116830966,0.11191860174041486},
{-0.25446097964522835,-0.6120649914028614,0.13032404783637677},
{-0.25997992999730446,-0.5917887214675334,0.1387697901401055},
{-0.25501129263073236,-0.5869093998184046,0.14712161075889924},
{-0.2668778669644391,-0.5833680115958235,0.15434296674771833},
{-0.2550189024900661,-0.5883336450705534,0.1745385321222175},
{-0.2651666499116255,-0.5919271007517339,0.1951622522139684},
{-0.27045049566217993,-0.5971883171837431,0.2165725914494819},
{-0.26759239270398727,-0.6027777588643847,0.23738395465164663},
{-0.25660035141529364,-0.6008602745717352,0.25187432837984886},
{-0.2514340579655001,-0.6116963137440867,0.284375837334851},
{-0.2577238069643029,-0.6257571309388443,0.30250051967328867},
{-0.25598655618218963,-0.6677271072401403,0.3013007652714857},
{-0.2510381450206888,-0.6732460575922163,0.2827643494912008},
{-0.2479565525094312,-0.6729464694458139,0.26898990331873973},
{-0.24263946368915565,-0.6644434529376259,0.24254404005829952},
{-0.20094784803191013,-0.6527839468815797,0.21999302296054762},
{-0.26986113208272633,-0.18891295562530813,0.4401875069339836},
{-0.25096144564898276,-0.185165300162891,0.4244919717986623},
{-0.24850866783004055,-0.183085805970215,0.44096431336439484},
{-0.2515047495535215,-0.18682164612471916,0.4595097408202066},
{-0.24697648273102632,-0.1924044792433076,0.48491505594648426},
{-0.23212143653317238,-0.18984015690728906,0.4938288045992387},
{-0.25396373541560446,-0.2283158059581994,0.5165570513156845},
{-0.25705253726728344,-0.2525618190928166,0.5286481164997371},
{-0.2653819288269882,-0.280096493016352,0.5333081540443798},
{-0.2619665038023263,-0.30689060747103947,0.5317018729465895},
{-0.2557993135906881,-0.3318713725502761,0.526060764326261},
{-0.2509025693688743,-0.35533397069242906,0.5165196027973842},
{-0.25793648250673573,-0.38747000613995486,0.5067379296616695},
{-0.24867368162190934,-0.425861946738194,0.4901420280114916},
{-0.24502956029832249,-0.4425371511330079,0.48445105478658146},
{-0.24614460495017343,-0.4531507020495754,0.47712636491838817},
{-0.23973470027767974,-0.4625210422623551,0.46743941450543325},
{-0.2404183860609806,-0.4696965388357155,0.4683327719393245},
{-0.2338783127419885,-0.4720529918562489,0.46807724087327535},
{-0.24800221166543374,-0.4877451225808156,0.46555757639597856},
{-0.23710769673188584,-0.5257555689150863,0.4370768768015841},
{-0.24832502990874977,-0.5563097549184723,0.42073430336343765},
{-0.2428493355992023,-0.5852318263542244,0.4004388085203189},
{-0.2578982329506108,-0.44440877601019885,-0.4084419774259531},
{-0.24910524074991555,-0.4329128819298283,-0.4534010263697646},
{-0.2518970578281221,-0.4355152535625156,-0.4124587815974376},
{-0.25495682205865916,-0.4486306458647824,-0.37377886790125286},
{-0.2731990566978577,-0.5192100885907781,0.7785729190739522},
{-0.2640359850221947,-0.5532079362021435,0.7757612763095866},
{-0.2592601975118964,-0.5816756189318881,0.7613445980612481},
{-0.2745652267077225,-0.5816491846836761,0.7409840188948802},
{-0.24973185258821326,-0.6121176596398293,0.7452733761861868},
{-0.26662333719567066,-0.6183823762066133,0.7142561903201787},
{-0.2639100218242755,-0.6298207958230684,0.6821900454228498},
{-0.26688587734268515,-0.6340392612668974,0.6600417500914183},
{-0.2607757610760501,-0.6529383469222725,0.6203321022717032},
{-0.25714005064962164,-0.6555054728906771,0.5727324321390793},
{-0.2559677317933114,-0.6448546737152654,0.5309090457596862},
{-0.24786583497579462,-0.6170800889632607,0.49317395617762366},
{-0.25196614734049433,-0.590118958122143,0.49569161806035894},
{-0.2559783455444874,-0.566308309045199,0.510497800950912},
{-0.2635723843812043,-0.49279646710277836,0.7999207773591464},
{-0.25754377371322285,-0.525073885726347,0.795954438570612},
{-0.24123564490153443,-0.5557712572408812,0.7945550254910261},
{-0.241789362297793,-0.5837334851032998,0.7746470326955603},
{-0.2296668563791248,-0.6170540552339612,0.755969834517601},
{-0.24262644682450582,-0.6278374261693449,0.7357512393056443},
{-0.24970281496707133,-0.6394696969393545,0.7016814985495207},
{-0.25138379284200607,-0.6563411556011968,0.6575000570739449},
{-0.2322880524006903,-0.6840514570677769,0.6316751983870302},
{-0.23953764497282676,-0.6786454530489702,0.5898772449585682},
{-0.23996800254409614,-0.6691285229142876,0.5406204278262916},
{-0.23379620636496642,-0.6595435045645137,0.5016625540049687},
{-0.2346467082752414,-0.6452317622711985,0.4849374850055731},
{-0.22104688834854436,-0.6368030420212427,0.45121259103294226},
{-0.21758600442733603,-0.6096909155501867,0.43619233078376335},
{-0.2354367318297586,-0.6017820688483999,0.46954514268686504},
{-0.24038934843983864,-0.5700968174366708,0.478353554865684},
{-0.24548495030161074,-0.5553208737239967,0.4971527110524395},
{-0.2369639104423691,-0.5351611547921487,0.49128671106285293},
{-0.22680054278322995,-0.5123878496980687,0.4984553988147043},
{-0.22735365940112007,-0.49855612932114846,0.521786626753622},
{-0.22240384642342614,-0.48399045803743324,0.5406831090360671},
{-0.2679510573899544,-0.6696179570251217,0.12287399554863279},
{-0.2683529781184502,-0.6812183865416032,0.09641291256952507},
{-0.27180825477488635,-0.6826686655230516,0.08486655310620438},
{-0.2671315956953829,-0.6746036164454667,0.08866927991906312},
{-0.2678499263645979,-0.6612405031959405,0.09275437256509533},
{-0.2601940073559303,-0.6409073595750654,0.11015952267758104},
{-0.2537086048684676,-0.633888065377503,0.12109989702658763},
{-0.23967882788941353,-0.6274383090732353,0.13146252284459745},
{-0.24156587274472807,-0.605270388315101,0.14075736524240803},
{-0.2401278095901049,-0.5949706439663227,0.1524384993197186},
{-0.2522352960495618,-0.5865243008842256,0.15979462992252763},
{-0.23910808843938205,-0.5961289446607024,0.1925388533383852},
{-0.25380593096415716,-0.5946872768358685,0.23558141928682796},
{-0.2407742471145616,-0.6010128722773225,0.26148457942109793},
{-0.24135860420761135,-0.6055803899532233,0.2865658747473226},
{-0.2522863622108804,-0.6050366855297724,0.31083832213015183},
{-0.26962502618392387,-0.46928100046420135,0.7914339818669067},
{-0.26765747702723647,-0.43363962349620166,0.7843007400387941},
{-0.2612772107542532,-0.44538884578860366,0.8030778676853731},
{-0.2538499880445104,-0.4709463581015564,0.8151769432476715},
{-0.2662696789961074,0.19647795684088304,-0.837827889814043},
{-0.2723097044530894,0.17659780010982226,-0.8276683270845707},
{-0.27073566512773944,0.18429016633950948,-0.8178079519825886},
{-0.2651402156634135,0.1983433736749332,-0.8217955182734752},
{-0.2645388365165909,0.18785198102661807,-0.805300146870285},
{-0.26657427362891356,0.17627918731508543,-0.8002413927484449},
{-0.2697950464621964,0.1708016906704326,-0.8124824522651546},
{-0.2669191204124063,0.16401810185276045,-0.818410532686148},
{-0.26510537051804317,0.1699778232678258,-0.8346091195753216},
{-0.268011335486256,0.1841858311628546,-0.8406637639726028},
{-0.25848559393550286,0.18497485342009104,-0.8571539286299329},
{-0.25459475296193745,0.207518060399053,-0.8529128338675587},
{-0.2547046954033646,0.21130857138508652,-0.8345926982999173},
{-0.25755959421025876,0.20209783795885947,-0.8160200355580689},
{-0.24998357872459556,0.19602036398357708,-0.7999858616823957},
{-0.2575631988804695,0.17339965659508458,-0.7885686695682926},
{-0.2640646221244244,0.16327794290282488,-0.7989513213319176},
{-0.2602348602849852,0.1572301073270529,-0.8069552912753764},
{-0.25980790712447044,0.16045368379272182,-0.8215257687860391},
{-0.2506836857833008,0.17338824180608395,-0.8495066207778796},
{-0.26345022611295194,-0.40816481833863943,0.767589488941873},
{-0.254467187688369,-0.39953323525960227,0.7963024895054032},
{-0.2564709838066198,-0.41766532719791755,0.8045694001147887},
{-0.24356786652787352,-0.42503367362755184,0.825472682407327},
{-0.2419081161552908,-0.44393396083966385,0.8271965158058778},
{-0.2318218483867699,-0.4699632844313092,0.8320111536506699},
{-0.25150314747787234,-0.4987774160201957,0.8107694328772358},
{-0.23420934162300677,-0.5143812323245996,0.8178988697756814},
{-0.20088897175180162,-0.5506199832502989,0.8144085477144188},
{-0.2181509363531391,-0.5801660631514188,0.790124685542589},
{-0.2050753956826464,-0.6012173371820531,0.7790911905464718},
{-0.20081807990432402,-0.6290131494364097,0.757141752854999},
{-0.21186419124617853,-0.6397112098434731,0.740272096528262},
{-0.22899999239014066,-0.643549783098983,0.721987006365447},
{-0.23432429055083764,-0.6604713066248632,0.686079484580222},
{-0.2301969431595575,-0.672122401783751,0.6670153851329782},
{-0.21656828587117466,-0.6918407488742414,0.6440171886696403},
{-0.22124995143708187,-0.6952131181158308,0.6090987483383471},
{-0.22621558491181176,-0.6922895303154767,0.5617415924071226},
{-0.21725137087610707,-0.6900858752599868,0.5203770004417723},
{-0.2059917829539952,-0.6816283176483451,0.47901220821696583},
{-0.21122416202431868,-0.6635140488016272,0.4601681939120324},
{-0.20461640100914744,-0.6531051630492465,0.44004892739032686},
{-0.20229279053942284,-0.6313565855922934,0.4190691459855388},
{-0.20441974622320674,-0.6033797387895757,0.4120444447826604},
{-0.21577005167895522,-0.5797527276339224,0.43309591907275063},
{-0.22971451812968882,-0.5659622607049694,0.4613857714054328},
{-0.23428884462709887,-0.67576432025332,0.3732139359754498},
{-0.20540762612040156,-0.6705051064158722,0.36405046378087447},
{-0.21350071152184769,-0.6766738987031599,0.3559830115898157},
{-0.22940311467537342,-0.6787812289602408,0.33666778678455805},
{-0.23195141625489982,-0.675188574316885,0.2916328395068651},
{-0.2622310465439023,-0.38932000299588143,0.7458739542951849},
{-0.25202402232332205,-0.6596586537518008,0.15474508773567033},
{-0.2480610879455422,-0.6552767765917522,0.13154042377304032},
{-0.26041809768736374,-0.6640311187174102,0.11218554759546466},
{-0.264554857273083,-0.6737903627940359,0.10744120081978209},
{-0.261832530226161,-0.26374010167573103,0.39547677971579975},
{-0.25717870072465887,-0.273744463326686,0.39356750606085245},
{-0.24242638762781057,-0.2641418221447708,0.38533604137520566},
{-0.24696707053658717,-0.2427260759039411,0.3893159978067584},
{-0.2510349408693904,-0.22841193049715208,0.40083652380023554},
{-0.2298216569387298,-0.21134341653045682,0.3888860407544014},
{-0.23086160429452396,-0.19676072319296878,0.3978668763249666},
{-0.23626880987006765,-0.18326764155640046,0.42183112440477877},
{-0.2531546872127528,-0.5160315705027433,-0.25972930528793103},
{-0.24829238761739705,-0.5532005266022659,-0.1941549471495269},
{-0.2613665264716967,-0.650145328287329,0.10829630869754851},
{-0.25631398039299713,-0.652769728460193,0.12054377651685522},
{-0.2406304608250449,-0.6420336187564608,0.13133996405743278},
{-0.22159239510710074,-0.636762389351644,0.13213719695237147},
{-0.22228008607952462,-0.6262093167908341,0.13001124256586832},
{-0.22624342097621677,-0.6089034953685996,0.14298985765958375},
{-0.22108273479119545,-0.6013873574603255,0.16717098673040787},
{-0.26751989878086047,-0.663903953962754,0.09798675163541883},
{-0.23276426938741832,-0.6503870414509036,0.14366433150790162},
{-0.208465187496921,-0.6512291324640204,0.1401676011440422},
{-0.2036705755977444,-0.6364073293358876,0.1244250050365253},
{-0.21220363102435513,-0.6178699122583218,0.13068391407908084},
{-0.2106950765411667,-0.5974218197096157,0.14605743200891075},
{-0.2117928988797886,-0.5991596712700975,0.17191072753859896},
{-0.22195246160926094,-0.6026489920340793,0.19625787169857267},
{-0.23189013686131751,-0.5986956701101948,0.2384473323638105},
{-0.2203225498956448,-0.6031446341880539,0.2714182494840315},
{-0.20816339649650087,-0.6006694273100229,0.2799226678084125},
{-0.2387622403586086,-0.6001874027990663,0.29636056474768707},
{-0.2362752181726645,-0.5722764413574227,0.3169740716071742},
{-0.22600330988829126,-0.653666690564295,0.16186751555315065},
{-0.2577578510718487,-0.38604395855270085,0.7642942195909019},
{-0.2447860447996424,-0.3627371622674337,0.7836545027737936},
{-0.23370689064752292,-0.35524325315879246,0.8045003106024162},
{-0.24400823707195038,-0.40013401362805645,0.8170231351739311},
{-0.2276386286072235,-0.40902032673531824,0.8370879311235635},
{-0.20455552213447742,-0.4293760996747385,0.8532636884347359},
{-0.20543365984970124,-0.46193468257474385,0.8471117179417654},
{-0.21460594346034723,-0.5051558799580737,0.8310416976234408},
{-0.24994993513596214,0.15694333578584413,-0.7768659074697177},
{-0.2541225411643325,0.15563604205608786,-0.7920726092725735},
{-0.24529270122370542,0.15485422913927285,-0.7916374454743565},
{-0.24099613459197736,0.16917998959451866,-0.8294410237904228},
{-0.220505386779111,0.19484564201379306,-0.8839109950852323},
{-0.24400883785031882,0.18890214161467594,-0.8835026660541396},
{-0.25284448531517434,0.1846772678682501,-0.8702607097755851},
{-0.25202362180440974,0.19440847562101457,-0.8806279415610864},
{-0.2558555864978666,0.2026777893438739,-0.8734169990639874},
{-0.24430622314270367,0.22200382815976377,-0.8729922487574902},
{-0.24024696396651501,0.22452609600999052,-0.8365664554997453},
{-0.24227619303569703,0.21161797224484039,-0.814756798908666},
{-0.2406276571926588,0.1946435802225363,-0.7781315472325945},
{-0.2501319709816038,0.17940403586887171,-0.7748585066812562},
{-0.2485917755043434,0.15932121656818574,-0.7637863616101019},
{-0.2386332732688471,0.1488236158767299,-0.7480750059777447},
{-0.23514855847235674,0.14722033867078183,-0.7577100891915565},
{-0.24806349105901604,-0.2638758775870017,0.5318412535280709},
{-0.22950064103051912,-0.26347075270720743,0.5272012419290433},
{-0.22263875076549175,-0.2844675561657683,0.5217998438777279},
{-0.2313216002653037,-0.309699646862475,0.5192549467089561},
{-0.23249632223508773,-0.3201646052625782,0.5137926697829708},
{-0.23635692403077427,-0.35630623035204406,0.5052039422275499},
{-0.23338547422039993,-0.3834632149412779,0.49289940046324016},
{-0.22564564649960486,-0.40667649006052237,0.4897282919750829},
{-0.2383585172950074,-0.44110048979457783,0.47801832053608645},
{-0.24189129436097406,-0.43923106777140464,0.48639677566254835},
{-0.24043220396345502,-0.4449446703148599,0.484869797309394},
{-0.2434595261620956,-0.4423949669191404,0.48436093803131336},
{-0.24170705566131478,-0.4446817296489331,0.4832819400815696},
{-0.2417769462115116,-0.44500534893007376,0.4846018501570634},
{-0.22770151007645506,-0.44960090292983584,0.46649939661825857},
{-0.22916220254962327,-0.4587115066279872,0.46299125146539855},
{-0.22928456107733175,-0.4578668122419406,0.47012469355296715},
{-0.21912279549384178,-0.4461810721971386,0.47355133310717357},
{-0.20914086290197578,-0.45985178397131327,0.4688732722114771},
{-0.21131487955795528,-0.49187607464230654,0.44904117774989266},
{-0.22469741797472806,-0.5427361689805311,0.41863978971155025},
{-0.23790252651335067,-0.5630552944394758,0.4113755781991147},
{-0.2341148191597033,-0.5844377976105841,0.39756128039487953},
{-0.2242732684465994,-0.5934935302177501,0.3876193996942438},
{-0.21907773711620776,-0.6016414867101817,0.3886283068343346},
{-0.2223587880457921,-0.6168001262435611,0.38421078349109106},
{-0.2133705428753493,-0.6269526798920682,0.3757696471548538},
{-0.18639799724523093,-0.6476737260795086,0.3590143389775793},
{-0.20226195058317553,-0.6612921701356277,0.36397096077678237},
{-0.24885932213776166,-0.3707743752806135,0.7153035472758505},
{-0.24651248157112352,-0.3572684770388515,0.7514712060946162},
{-0.23447328358621428,-0.3362426359591486,0.7719801775179923},
{-0.2203455797331022,-0.3148817608093045,0.7894840555423606},
{-0.21366772790827795,-0.3326225457703,0.8237991141322697},
{-0.21548728532686948,-0.3603044103941066,0.8367512949777731},
{-0.23123508818024632,-0.3714204122861579,0.8231018107059506},
{-0.22298960533266898,-0.3878633157118362,0.8389757770167028},
{-0.20808349297349646,-0.40089900475055473,0.8520925711351628},
{-0.18659645436627695,-0.37593385990889794,0.8616591656149707},
{-0.18082617839673076,-0.4297267539824597,0.8619697680314613},
{-0.18742352592018216,-0.4860176845120538,0.8459528164690173},
{-0.19967519918806806,-0.5240779954509062,0.828881699129392},
{-0.24777511744215802,-0.4557162259423308,-0.5161875726190852},
{-0.2319746463518134,-0.45478642128741986,-0.5301879114580851},
{-0.2368415519146606,-0.4361662970544637,-0.49954360869943093},
{-0.2565887363668368,-0.4644379257766362,-0.3410490631662381},
{-0.25353397862270355,-0.43591757480992366,-0.3446913821547196},
{-0.2544711928774921,-0.4490503896848757,-0.31856753609977084},
{-0.25392448456219874,-0.48121346015898186,-0.2992194687437043},
{-0.25820783406982084,-0.495122881204889,-0.29991236646198816},
{-0.2516709649021272,-0.4976952139191536,-0.26786965192102885},
{-0.24618125243064914,-0.49240415882817773,-0.2405929121770165},
{-0.24656875447830204,-0.5273382193970508,-0.21921641678959258},
{-0.23588611404936236,-0.5432406225505766,-0.17470074228170016},
{-0.230732036426394,-0.5561908008015185,-0.14995808569582753},
{-0.24021872738319763,-0.5754303275323509,-0.14425870157375895},
{-0.2510848054739721,0.20515980504341422,-0.8842612488740411},
{-0.241363410434559,0.22644297952427164,-0.8852935863705016},
{-0.2267302517141208,0.24120450455610287,-0.8699236731108824},
{-0.2320026826756746,0.24025787810687524,-0.850753035632966},
{-0.23331298029727313,0.24020260649697747,-0.8312988307651392},
{-0.23281934073785995,0.2286336177151117,-0.8048998282174384},
{-0.2306457246007928,0.21363638730339024,-0.790758306461852},
{-0.22199491661396503,0.18350354719574677,-0.7434658343349643},
{-0.24232225271061184,0.17873597032315067,-0.759983434537787},
{-0.2461367948313835,0.16688000974061992,-0.7568675976595276},
{-0.2367858797858505,0.15851857666793095,-0.7444789469236343},
{-0.2306899819406022,0.14765830610138495,-0.7387791622826533},
{-0.22178063899588302,0.14915484501720425,-0.744829200712443},
{-0.22183791320034232,0.1607036075939988,-0.7762777454470011},
{-0.2174027670249575,0.17818285370526055,-0.8111317022334136},
{-0.21883442187698382,0.1894860981888134,-0.8543607097355331},
{-0.19496329444428198,0.2002566525190036,-0.8699569161806034},
{-0.18499598079271504,0.21140109125382844,-0.9066015930239216},
{-0.21326861081216825,0.20278052244487957,-0.9005066964759543},
{-0.23183967147836737,0.19495238030392176,-0.8929246732066063},
{-0.2342411828765348,0.2055475073505233,-0.897632172242357},
{-0.24791389724527094,-0.2821141070370772,0.3920741712963315},
{-0.2346693375937865,-0.2851690650406667,0.38851616153888974},
{-0.22575999464906732,-0.2731074379966684,0.3849637590462202},
{-0.219301627188185,-0.2452279172896404,0.3826463566196364},
{-0.23120865393203432,-0.23630095151277994,0.38354371924265074},
{-0.2187767471536122,-0.22399981415922468,0.3841693297836677},
{-0.21186298968944162,-0.2086987901525216,0.3912250712022496},
{-0.20400921433809643,-0.20108652770529495,0.4025142975238719},
{-0.22369011291028654,-0.18829014871667732,0.40844738443126916},
{-0.2074554793190057,-0.18594491022568838,0.4179895472574267},
{-0.22833493073626188,-0.17864365071386487,0.4401528620480694},
{-0.20957742851638583,-0.28420341394310467,0.39167485394076557},
{-0.20816219493976393,-0.2575450753996878,0.38703904779031706},
{-0.2045481125345998,-0.23089014126702553,0.3878567071497832},
{-0.23022297688885715,-0.24569071689280633,0.5257701878553854},
{-0.2035091664760864,-0.2524827166076368,0.5137800534372332},
{-0.20440793091529386,-0.2798281453451091,0.5142628789860142},
{-0.2068893458364657,-0.2923133211388675,0.5110425066716437},
{-0.22536308040697525,-0.3037741698144115,0.5142869101207523},
{-0.22307171170969106,-0.32519231916871494,0.5002957832167355},
{-0.22621057842540793,-0.34787050102112294,0.49794974368792205},
{-0.2216326472577872,-0.3647077153159633,0.48332299327008066},
{-0.22302985748335544,-0.3922059420184791,0.4867688577320776},
{-0.21657369287649075,-0.38594783401374816,0.4902517701934626},
{-0.2164323097004479,-0.387208267030765,0.4930892464276716},
{-0.20989704260840344,-0.39790192172979305,0.48820391699485854},
{-0.22237621061847726,-0.42146344804328484,0.4860439185008096},
{-0.22901821600065045,-0.43097396987537046,0.47823700386220386},
{-0.2224705328223246,-0.4320822057057123,0.4804747030252395},
{-0.22419797089108648,-0.43657943231250407,0.47893550884525987},
{-0.2239272201063698,-0.44102619353634565,0.4744390832762927},
{-0.22457045347952806,-0.44805389863106637,0.4709071072481506},
{-0.22204998796440667,-0.436195735194518,0.47853619148969395},
{-0.22574958115734742,-0.432841189044526,0.4835130394939683},
{-0.2251768391127545,-0.43182727541803156,0.4837521492846131},
{-0.23603490682528283,-0.3977535294727849,0.6635404830498393},
{-0.2429470622138042,-0.37739415186315384,0.6917346113624812},
{-0.22940031104298725,-0.3449645360529101,0.7124580606633955},
{-0.2397715480176116,-0.3464416498014828,0.7383710335110168},
{-0.22572234587131085,-0.3246840606690027,0.7408202066597482},
{-0.20737297242307132,-0.2967722981895344,0.7481402905604502},
{-0.19826316976274458,-0.2782210632094942,0.7823796510759339},
{-0.20552637997789935,-0.2994938241986317,0.8081522420447933},
{-0.18659345047443465,-0.28820379683918484,0.83206161903362},
{-0.19862443782164171,-0.3274095918672231,0.8396891011995141},
{-0.20135257239279208,-0.3643424420679432,0.8511543555830935},
{-0.25306697357095853,-0.42863794331936445,-0.38108092845090097},
{-0.2509272012819809,-0.4012568683986973,-0.36190348215147544},
{-0.25055612050973236,-0.39816706524973755,-0.41496062298313696},
{-0.24790688816430564,-0.41215078255387677,-0.44515073729523974},
{-0.2456121150562669,-0.3690743727573444,-0.4494154626734396},
{-0.24613719535029582,-0.36704874835837303,-0.39983642807621556},
{-0.24654332152737082,-0.3799284352807497,-0.36933611186653426},
{-0.245440292442889,-0.39905721853233045,-0.339696911318304},
{-0.24876419889608975,-0.42789017451009526,-0.3085585684813244},
{-0.24980314495460315,-0.45464904330050004,-0.281990747212088},
{-0.25165654622128425,-0.46338476129673595,-0.29310214313664784},
{-0.25232501228591764,-0.47798007097996154,-0.2708715411687382},
{-0.24241297024424843,-0.4506348425019455,-0.2669600734711893},
{-0.23919379948661482,-0.4952027847278935,-0.22132414756558594},
{-0.23180382503571625,-0.5244789148821213,-0.18303894525747558},
{-0.22065718344687374,-0.533717083853841,-0.15838560438904645},
{-0.2157005616476707,-0.5340356966485779,-0.14712441439128535},
{-0.23326852269800752,-0.5652857842620899,-0.12584624639683173},
{-0.24094306583609726,0.2199495666585628,-0.892438643506527},
{-0.2182194250871429,0.21840156106251254,-0.9067956444369326},
{-0.21183695596014196,0.23822224073509637,-0.9034921644482592},
{-0.2332092458989867,0.2323005686166998,-0.8926060604118695},
{-0.21893595342125258,0.2440561992116987,-0.8909002503643719},
{-0.200062701235721,0.25999945529427926,-0.8817233607862347},
{-0.22047174319047758,0.25494330454536895,-0.8559996331246761},
{-0.22593201752190137,0.2463301453362977,-0.8286233644309565},
{-0.22725613304597436,0.23579629768327842,-0.801397690848263},
{-0.21764147629668998,0.22299651428390618,-0.766586789844923},
{-0.21078319070187332,0.2133680396321474,-0.7482726620609661},
{-0.20020368389285154,0.20457885236111903,-0.7224980684975454},
{-0.2015818694700854,0.19375342693994335,-0.7097333305029996},
{-0.20789645064145107,0.17835768021048068,-0.710757657621214},
{-0.20679181948131997,0.16494330054017983,-0.7138805035804388},
{-0.22415111017834705,0.16274625404674298,-0.73836983195428},
{-0.2318661057265793,0.1735466470358997,-0.7489479369471086},
{-0.22273087011532142,-0.21617547694793374,0.5121229064375805},
{-0.20829957292668377,-0.22759226854312445,0.5118457473502669},
{-0.1789627641572421,-0.23885345854088555,0.4956968248062189},
{-0.19237874590319218,-0.2522237811308331,0.5060236041815775},
{-0.1971076727007511,-0.26267452110954953,0.5092980465491089},
{-0.19096751751569332,-0.2658278065061093,0.5053160875229947},
{-0.19349419107395538,-0.2842737050122138,0.499273859211995},
{-0.20885108746892472,-0.303217849045223,0.5022565235519139},
{-0.21185517957065172,-0.3092460591942921,0.49648784965801684},
{-0.21546765990016664,-0.329334085240838,0.49326307163561106},
{-0.21251783811105668,-0.3360207484817329,0.49338943535244256},
{-0.21881399541245636,-0.3484152067418547,0.4876211619774579},
{-0.20983856684720725,-0.35028342720829103,0.47617793613405524},
{-0.21098324989856854,-0.38011007060747903,0.47370693470460323},
{-0.2160071588750385,-0.3892579225644745,0.48330817407032545},
{-0.20863620907247427,-0.3913738639781701,0.4855228433959036},
{-0.2079807598724908,-0.37655886967154645,0.49227459096004783},
{-0.21126421391554895,-0.371207536484269,0.4946989319362165},
{-0.20610893473584377,-0.3752918280924766,0.49397058829419394},
{-0.1966815205780609,-0.4022377392149268,0.47971151423784647},
{-0.20241354699148215,-0.400186281346112,0.48217230243503484},
{-0.2055277817940924,-0.402354290218407,0.4800928082423587},
{-0.20440993350985534,-0.4116048752764081,0.47852357514395644},
{-0.2059319053766059,-0.41718470450315426,0.47982165693872975},
{-0.18673683624503906,-0.42381389328013375,0.473382514385638},
{-0.18875064533609742,-0.45188265917322473,0.4690016385228702},
{-0.20017724964463957,-0.4713795193052118,0.46432457892445445},
{-0.20354881784840437,-0.4848960312981498,0.45655731565816665},
{-0.20797555312663085,-0.4976894063949252,0.44659841290375807},
{-0.2088268560747304,-0.5217926345373065,0.4305400076338904},
{-0.21549890037532626,-0.5584272984078171,0.40441215638981864},
{-0.22542476031946987,-0.573214857168948,0.39695429398328463},
{-0.21402318844294668,-0.5810093557212724,0.38935885333037473},
{-0.21447277092200653,-0.5921836331150637,0.3846777885428361},
{-0.21204822968638168,-0.5899427298007297,0.39241160847994655},
{-0.21415676150019966,-0.5997396226551118,0.3927131992209105},
{-0.21143223159925997,-0.6180623615956833,0.38571573330406866},
{-0.21009950491857246,-0.6214585617125546,0.37836681204168116},
{-0.19232948207697895,-0.6396587418659614,0.36874434517360694},
{-0.16998473221906302,-0.6543635934717018,0.352481875517921},
{-0.17106613328228054,-0.6660901864455588,0.3472757304363533},
{-0.1623822824851878,-0.6670658505159284,0.33997246832996825},
{-0.17424204799738538,-0.6720290808771845,0.3293747379104367},
{-0.19900533130724163,-0.6709182416739127,0.30395019787636857},
{-0.23068177130290002,-0.6695272394914851,0.26563936235787083},
{-0.23288362402328455,-0.48951040968679016,-0.6105175865851797},
{-0.23944392354734792,-0.47608641756259407,-0.6034165865295076},
{-0.23029927574165088,-0.4623988839941027,-0.5994057901417075},
{-0.2254091400818901,-0.45556362823674346,-0.5865755673050003},
{-0.22070344338124473,-0.4520284480573031,-0.5545118255211451},
{-0.2149882387621402,-0.4446512902115981,-0.5544891962026001},
{-0.21888688985449548,-0.42723312323446244,-0.5426730872518434},
{-0.2324971232729124,-0.40170645087775725,-0.516126293225503},
{-0.24210637301688068,-0.39655237325478887,-0.480434450874553},
{-0.23807414886727243,-0.3570035337783632,-0.48782522636327624},
{-0.23939666231569623,-0.33919966708868005,-0.4605655086730368},
{-0.2404005629693831,-0.34327114209169396,-0.42571896148650185},
{-0.23156271265050998,-0.3370424722270173,-0.40130232729524373},
{-0.23619651620639698,-0.3563542926215204,-0.3750280863887252},
{-0.2347262112793335,-0.3783143440641695,-0.34230609177250043},
{-0.23691805102691046,-0.39436714206926493,-0.3221135302898435},
{-0.24241537335772223,-0.4137624706569832,-0.30772108343569926},
{-0.24769501365969748,-0.5356345681464906,-0.1011554570101023},
{-0.2452346259814215,-0.5380861444086958,-0.11250576246585076},
{-0.24737339697311836,-0.5506758556385654,-0.09898284217031586},
{-0.24518996812269978,-0.5482332910518868,-0.08236691457452275},
{-0.2400218723378008,-0.5638839680690302,-0.08640855091857011},
{-0.23791674493473744,-0.5664342722431182,-0.10644050431739363},
{-0.23113656052781983,-0.5440745029259908,-0.1259237468063623},
{-0.22994081131513985,-0.5280403290503175,-0.12578036103575793},
{-0.23581622349916548,-0.516946555957899,-0.11685379577780973},
{-0.2409823166895029,-0.5172611635635128,-0.1103876181981375},
{-0.23631426876661402,-0.5121375253778795,-0.09313506579123913},
{-0.24302796703408935,-0.5296626309046,-0.08701413551397191},
{-0.24039415466678626,-0.5308481668850161,-0.07421855756317886},
{-0.2383362884953746,-0.5409272253131157,-0.06914238086865343},
{-0.2372242477353659,-0.5566678188260711,-0.07267776130755008},
{-0.20620566005316487,-0.5248363780113515,-0.14646776363456493},
{-0.20384720443806995,-0.5169998249732353,-0.13928225408839692},
{-0.22270583768330246,-0.5053611459006287,-0.11579822818443575},
{-0.2320779802311875,-0.502557112995597,-0.10251141378770334},
{-0.22844507343714512,-0.49857014748307904,-0.09039431487435122},
{-0.21561865553010479,-0.49762912829862366,-0.06948482453867232},
{-0.21968973001420639,-0.5104188987251883,-0.06658727046761785},
{-0.23303061446409967,-0.5180954444578395,-0.07617409115249718},
{-0.22833713359027957,-0.527500029037621,-0.06458747953849008},
{-0.2345670050116931,-0.17473558742707052,0.460237884202773},
{-0.212076466269699,-0.1471204092021623,0.4575504023012214},
{-0.19768041474534404,-0.138415931681086,0.4638119147167069},
{-0.1854982315087427,-0.14282043815967965,0.4744899491781552},
{-0.2161962038016454,-0.186257915755653,0.49590549515952864},
{-0.1846883822680665,-0.17983919966708867,0.4893177600899725},
{-0.20162412421533335,-0.20149305440128226,0.5005376966397664},
{-0.15988384551024307,-0.19181611696113482,0.4746715845048845},
{-0.15673877075138548,-0.21375333882578268,0.4736574706189338},
{-0.17219479557714976,-0.24419477875535542,0.48734460366851284},
{-0.21788819594666847,-0.1638398709367857,0.4417365138273146},
{-0.21286889293769004,-0.1460570314899984,0.44680468014359404},
{-0.1730176616824758,-0.08644379658285274,0.43667495607308826},
{-0.16631798157693106,-0.08396538555352313,0.4485445342986373},
{-0.16911700799555907,-0.11530759251686483,0.4646449940542967},
{-0.1613215081459539,-0.12881309023971457,0.4704607289203892},
{-0.18238439722504474,-0.15623621964617357,0.48171270698316737},
{-0.16464421304241775,-0.16389634410342038,0.4773610690009976},
{-0.202732159786219,-0.3908802244187569,0.6546273351754532},
{-0.2247911394002069,-0.3817690199422371,0.6711743735183303},
{-0.22490248365782706,-0.3534519323235183,0.6958617584943051},
{-0.20261080255579128,-0.3232355840226597,0.7040087136894561},
{-0.20786921535541444,-0.3098987047618895,0.7216051115825663},
{-0.22715440124224942,-0.583773336735074,0.3075158174931441},
{-0.21191846155879557,-0.560038385732555,0.32440710184114535},
{-0.1973407747077113,-0.5465769450900587,0.34134364482623686},
{-0.18342294276464588,-0.5594267933534688,0.33918324581327564},
{-0.1759376448126192,-0.5558818004606767,0.3384743273384997},
{-0.1633289089344154,-0.5649127008952798,0.32609609009432616},
{-0.1817235410197452,-0.5345183219379027,0.3210251201456607},
{-0.18262230545895258,-0.5202730657840298,0.30343032432819955},
{-0.17706690788585694,-0.5046734549282049,0.27894960711097294},
{-0.18229508150760124,-0.4768397936366356,0.2799052452357274},
{-0.1694129914717508,-0.4616382985796398,0.2700354579393061},
{-0.1559769837801856,-0.44943268498666866,0.2618132051886424},
{-0.16681442476873035,-0.40220750003704797,0.28874329581405667},
{-0.16804521938623682,-0.3816686899547053,0.3045760086768417},
{-0.17959778689269817,-0.361260048518861,0.32995669189001264},
{-0.18013528327300848,-0.3477829876387848,0.3508016986808108},
{-0.18873061939048227,-0.3262408776811236,0.37290813978590653},
{-0.21021325228966647,-0.31076883209886724,0.38031633784731494},
{-0.19914691474274065,-0.30557930855216014,0.38499219588899375},
{-0.1955965148446327,-0.29306289228324217,0.3947610524195147},
{-0.1825770468218624,-0.28153055098185203,0.40441395872492397},
{-0.18964880899693642,-0.2584033874287527,0.39697271785325067},
{-0.1864434561417773,-0.21721582482264015,0.4010632175045989},
{-0.18405716446227732,-0.6559732789802467,0.26110628930842794},
{-0.1447952967865166,-0.6457091808146634,0.25859443494992107},
{-0.14982321095210954,-0.6448773030338105,0.21715234257504018},
{-0.16097465876789968,-0.6451857025962837,0.18166957109631235},
{-0.19031607350483287,-0.6536284410081701,0.18136717931752377},
{-0.23095712805510818,-0.32343344036533733,-0.4425571770786231},
{-0.22180006416312972,-0.3200828994044684,-0.41950451004321193},
{-0.22378663796815154,-0.3399884890864604,-0.3804290839211282},
{-0.22129280696069828,-0.3605491274495236,-0.35194237654304916},
{-0.22220418774564324,-0.38112037956376277,-0.32312784443525033},
{-0.2251988676529311,-0.40330612341349453,-0.2988796284466154},
{-0.2305417899430502,-0.42155756998767596,-0.28044133979984465},
{-0.2309599316874943,-0.45494702937125336,-0.2467765236640591},
{-0.23097775477909177,-0.4925467435609575,-0.21074644309166957},
{-0.22187235782680037,-0.5134614406424964,-0.18236226855514004},
{-0.19296049962331197,-0.5147925652475347,-0.16281274018618522},
{-0.18997623320774396,-0.5055916445346591,-0.13398959692177187},
{-0.2160968751113943,-0.4939641799915971,-0.10190322581937158},
{-0.2197163645218745,-0.49230843480813735,-0.08506300763268891},
{-0.20787241950671287,-0.4893764361106248,-0.07924947562061406},
{-0.19653012442921047,-0.49419027291759193,-0.06382429075109712},
{-0.20678741377328466,-0.5080147839540908,-0.05484285440216345},
{-0.2271305703669674,-0.3531879903603108,-0.5198437095100412},
{-0.23029106510394864,-0.3268684908167021,-0.49026678965267395},
{-0.22028850578809905,-0.3200272272756583,-0.5140395896924054},
{-0.214453546014216,-0.305059234744535,-0.5052123531247084},
{-0.2240277503533578,-0.3103034291227714,-0.4715421299836067},
{-0.2282878697640663,-0.47161782805803193,-0.6102358215303747},
{-0.21302990154043577,-0.46795348052937386,-0.6126415383771214},
{-0.21563968277300066,-0.45314028855785554,-0.5953783722190469},
{-0.205115848092789,-0.44769122875597617,-0.6028061957071582},
{-0.20599538762420594,-0.42356016454918993,-0.5736666425020256},
{-0.21849938780684253,-0.38637358561752605,-0.5490555563788444},
{-0.2175655779628086,-0.5898069538894591,0.30212723604702246},
{-0.19949456515861946,-0.5716255981249306,0.3217130113775407},
{-0.17744379618233383,-0.5727284269499563,0.32788620937286345},
{-0.1730032430016329,-0.5670775056162763,0.3354968697444409},
{-0.16503491924136912,-0.5748347559097566,0.3248224399532033},
{-0.15935275743252958,-0.5732446958279147,0.3282200418862678},
{-0.15481467789668293,-0.5794283073149572,0.32540098952202473},
{-0.15106982606665195,-0.5790127689434431,0.3184295573344825},
{-0.15605969093557612,-0.563514689631887,0.30092207463990345},
{-0.1559209111324632,-0.5556434917078567,0.28404240534035896},
{-0.15981796014916924,-0.5400879379323851,0.2733986152459126},
{-0.1538392140857695,-0.5276219870464174,0.25600788381426975},
{-0.16595831559368315,-0.5005599254393993,0.2644293947238041},
{-0.1534503102219235,-0.49963132234122526,0.24927415960117927},
{-0.1358110568051968,-0.4948925828303149,0.23626710766469036},
{-0.13136109143005678,-0.4610647554972222,0.24157959051747438},
{-0.12261475968264482,-0.43441743122389365,0.24736989243263569},
{-0.14660163708100216,-0.4237087570656542,0.2659585759309761},
{-0.1472172346492115,-0.3989751121553084,0.2793647449635748},
{-0.14491324960618976,-0.3827446840126067,0.29656122472275076},
{-0.14842980565620817,-0.3684537687027312,0.3167199423573181},
{-0.14894367142069265,-0.35961892227570036,0.33821298874822214},
{-0.16713944586606405,-0.34208560611127775,0.3664341520874445},
{-0.17349407892865998,-0.32569076495507576,0.3870252298878426},
{-0.21886766494670493,-0.5753516255660834,-0.3722584981101515},
{-0.20197958475000208,-0.5837865538591799,-0.36534574194326164},
{-0.20484709990263383,-0.5830283715581908,-0.38051699782237863},
{-0.21919969512500395,-0.5780863686992868,-0.38500120756452055},
{-0.21908694905119072,-0.5856443608338963,-0.3932490935255717},
{-0.22239703760191704,0.15091893056644187,-0.735479487223647},
{-0.2120554390268031,0.15923670707768986,-0.7319555215737509},
{-0.20314349270915394,0.16195222530310271,-0.7324127139121446},
{-0.19568943523228696,0.1754937697280597,-0.7768096345625392},
{-0.20262361916098492,0.18924999229001094,-0.8284497394824734},
{-0.17115945418884704,0.18954537498783422,-0.8419031697467239},
{-0.17034099379155632,0.19327280424518004,-0.8585229022721838},
{-0.167526947913717,0.20362681890657536,-0.8834520004117336},
{-0.14702618712804308,0.21292466519622824,-0.9228426349177995},
{-0.18272984478690588,0.21952021038457423,-0.9204659556921949},
{-0.2118625891705293,0.20957852994339465,-0.907852013068131},
{-0.1832509198918118,0.229103626658699,-0.923332669807002},
{-0.17203358671494787,0.24729419435821048,-0.9191140041037166},
{-0.19012242261073445,0.2543795741763028,-0.9002277350535354},
{-0.21330505803318778,-0.4574090191251785,-0.23049723221405655},
{-0.21857248250833777,-0.48105104974004315,-0.21068476317917492},
{-0.19400585398442222,-0.4937474992600412,-0.18866403312131197},
{-0.19422954379694332,-0.5892940894222554,0.3047544398522726},
{-0.1748912891542282,-0.589492146024389,0.30322205449380213},
{-0.21434840979973652,-0.3021975271161316,-0.4536233143660927},
{-0.19857156932521774,-0.2953983180608796,-0.4425477648841839},
{-0.2056597527756962,-0.3143676947853639,-0.40825813924520604},
{-0.20350856569771797,-0.3424795164615275,-0.3617120341113947},
{-0.19467732394089782,-0.37000137377986914,-0.32011694351201414},
{-0.2064926318538298,-0.38536588003417227,-0.3063483048637815},
{-0.18803071259123316,-0.40097930879247146,-0.27797454381897185},
{-0.20693700758702976,-0.42368853086058295,-0.26150400458834466},
{-0.19293546719129304,-0.4522054774165408,-0.2274146384055182},
{-0.16959482705793627,-0.46692154355182575,-0.20975736163773784},
{-0.16061719563866944,-0.5000975263551457,-0.17758868389885935},
{-0.1847947200392829,-0.5093509150455329,-0.16789712751841285},
{-0.22516582484266612,-0.4275671560073231,0.48659182837283976},
{-0.22375800086592187,-0.4258745630839315,0.4847774777001082},
{-0.22348244385425756,-0.42710575822035024,0.4851157159215479},
{-0.22517323444254375,-0.428797349846461,0.48590353662204744},
{-0.22531201424565667,-0.42960439545475115,0.4853161756371554},
{-0.22542415954110143,-0.4319706611886359,0.48388211767165534},
{-0.221748797742355,-0.47841002803231863,-0.6142504228478416},
{-0.21665860288589894,-0.49428219200796547,-0.6144432727041155},
{-0.20298308488477673,-0.5024449677001522,-0.6207550502430949},
{-0.2030890221370808,-0.46812029665634797,-0.6211461569609587},
{-0.2192785973507276,-0.5276297971652072,0.4721405052385871},
{-0.20736816619612367,-0.5058055216338287,0.4793933019620219},
{-0.2108348576415604,-0.49594654834803964,0.501211769969172},
{-0.2042729560418478,-0.48831085554444337,0.5146804199520899},
{-0.17701083523813452,-0.4743095154081628,0.5334447309934751},
{-0.20856551748445282,-0.4722021851510817,0.5540137802536966},
{-0.1879267779334906,-0.46558701453603285,0.5621893725510771},
{-0.15882767713850063,-0.447639361556833,0.5866893146760943},
{-0.164760964305354,-0.42363265847231674,0.6196802577419304},
{-0.2079403074623482,-0.4205582753014806,0.6280909546408325},
{-0.17425927031061442,-0.40090100734511636,0.6435808233146864},
{-0.15213720896793884,-0.38156175140512044,0.6580705962645202},
{-0.16634401530623075,-0.3602577499408233,0.6722445600520033},
{-0.19168985337403138,-0.34561818291778823,0.6852383948643862},
{-0.2138681876238855,-0.3649410175823797,0.6808272798237396},
{-0.16247099742426288,-0.2972322941603141,0.7022568439670436},
{-0.17978563026256816,-0.2849355625147942,0.7175348381362893},
{-0.1875943472362793,-0.28224407542411944,0.7269107856138413},
{-0.2059295022631321,-0.6765795764993124,0.6880083836618723},
{-0.1991114688190019,-0.6941635583061413,0.6614439668033903},
{-0.20591308098772768,-0.6992601614651942,0.6072317294286477},
{-0.21252785108386424,-0.6995927924218618,0.5543205777405206},
{-0.2093907867032527,-0.6982236185201547,0.5268844314694118},
{-0.19514613132774825,-0.6919961502122149,0.4780267314332448},
{-0.18944154045981976,-0.6759547669961201,0.4413688374658207},
{-0.19032388362362276,-0.6534436015301424,0.41530426820989264},
{-0.19271538204898264,-0.6243186672653089,0.39669215435518246},
{-0.19809314948447207,-0.5908340846400596,0.40491781151660083},
{-0.20334775735442837,-0.554789385127371,0.423283806499701},
{-0.2139236594932394,-0.5632437385877141,0.4403443100881501},
{-0.22195526524164708,-0.5566652154531411,0.4558690239073743},
{-0.2118764070730038,-0.5330420092271546,0.45280485396880193},
{-0.19761573094100712,-0.5111981082690733,0.44791792246033957},
{-0.17162205353255677,-0.4917595236388264,0.45190348615666454},
{-0.1900200900286411,-0.4951649356906808,0.4802175698835411},
{-0.17396168475877347,-0.48174414771778307,0.4998449991809388},
{-0.15408533295737958,-0.47318205467003044,0.5177081426696427},
{-0.122863682186641,-0.4622985540065709,0.5453113053271819},
{-0.1991138719324757,-0.5421798482113425,-0.6171834228426348},
{-0.18934101021283176,-0.5383268562749898,-0.6431196257871697},
{-0.19310008046424945,-0.5027527664842569,-0.6444735799702093},
{-0.19193416991053608,-0.45754139062569454,-0.6507116620293252},
{-0.199060002138771,-0.4257253697890987,-0.6204426454914987},
{-0.1997162523765791,-0.3844280650010153,-0.5954116152887681},
{-0.20390808331274,-0.3656229010305752,-0.5760174882577868},
{-0.20959845575928168,-0.35002869718006646,-0.5547006701882958},
{-0.2097947100263101,-0.3199597398389353,-0.5355072031323782},
{-0.19632545926502373,-0.30383284583506387,-0.538155033661612},
{-0.19844901053805308,-0.2895305157361878,-0.5075463770861528},
{-0.21015858145813715,-0.29502643625080655,-0.48173032981530867},
{-0.1911705806042308,-0.2841547508952599,-0.4703860321432447},
{-0.1656517183663154,-0.28155237926257254,-0.4483965425605414},
{-0.1787502888742655,-0.29858324445151135,-0.42258850566794337},
{-0.18847628988117004,-0.3255782191407187,-0.38062493766924427},
{-0.17204159709319392,-0.34430327932869825,-0.3497347162984362},
{-0.1706704205969254,-0.3746047378984212,-0.30471779237179686},
{-0.21332328164369757,-0.6002296575443143,0.21121484995960763},
{-0.19985523243914816,-0.5920400470850032,0.2004919573799815},
{-0.20794391213255892,-0.5991064022547612,0.24751508053834542},
{-0.16718810891390884,-0.5948627041194572,0.243490466248071},
{-0.1718583596908154,-0.5956513258577812,0.2736741722575769},
{-0.1730340829578802,-0.6796125059627252,0.7048642220861348},
{-0.18074767668991942,-0.6930605292216595,0.6804075360036462},
{-0.16703450991104074,-0.6990757225060789,0.665532263600721},
{-0.18256563203286177,-0.6979963240374227,0.632626030284837},
{-0.18587672188086882,-0.6961202934521967,0.6034510311559655},
{-0.19386387003001085,-0.7013050107719561,0.5306679333744799},
{-0.17057409579851654,-0.7017049289058904,0.46928460513441206},
{-0.18868435945611134,-0.698930534400369,0.4841386500349853},
{-0.1639893646208027,-0.6973675093451074,0.4378741096965228},
{-0.1590387506052842,-0.6853363217384443,0.4078738413488515},
{-0.16677817780716694,-0.6721388230591554,0.40133657166224557},
{-0.17823862596379866,-0.649174470443907,0.39561195484870193},
{-0.1829651496478838,-0.63864883342859,0.3832925938846369},
{-0.2005178909795531,-0.6224862932415237,0.3874301545081808},
{-0.19708244000927602,-0.6042162225379201,0.3921314455007908},
{-0.19733216355109678,-0.5898760434018314,0.3991913923679518},
{-0.20224012230245506,-0.5757281133436479,0.4043284479371473},
{-0.19877102774354452,-0.5643365544399322,0.40928306714178886},
{-0.20001644130135002,-0.5627711262711969,0.41351174581788164},
{-0.20018646157962255,-0.5593955528783091,0.4126039697031474},
{-0.19964836442094375,-0.560771135082613,0.41091958741745804},
{-0.20562390633304506,-0.5542596988658505,0.4150631558246864},
{-0.20281246382813573,-0.5431837488650294,0.42481879523110133},
{-0.20106520007321482,-0.5250736854668908,0.4371854174268181},
{-0.207838175139711,0.26331655292597084,-0.8261233253803628},
{-0.21381131393833852,0.2519093737846754,-0.8178716344896447},
{-0.21347127338179345,0.23569216276607968,-0.7808985321382382},
{-0.19274922589707222,0.22741463840551815,-0.7314354477661258},
{-0.17277414618379575,0.2265749505058754,-0.6861525792817174},
{-0.19023416738726692,0.1639770486642494,-0.6968027776787606},
{-0.18224261353008958,0.1678730963836747,-0.7163326806210125},
{-0.17387417137643532,0.1710880616927291,-0.7419855164350933},
{-0.17477173425890583,0.1751070687182313,-0.7817858817884451},
{-0.18408840493743694,0.1840943125913934,-0.8152989012564679},
{-0.15732272732552294,0.1787964486789084,-0.8098832847837658},
{-0.1158750276858698,0.17867869611869136,-0.8418324781587023},
{-0.1173441310561964,0.18558424294515974,-0.8615718524920886},
{-0.13216873781671534,0.19329743615828668,-0.8801741536334473},
{-0.14269777924278695,0.20474546822863704,-0.8947482358143211},
{-0.11921495489556269,0.2030494708944909,-0.9068306898417589},
{-0.11813655772418745,0.20811323150273492,-0.9270224502865911},
{-0.1154650965791279,0.2089621313373607,-0.9474362984682956},
{-0.15537320151988915,0.21814883362884951,-0.932452485440136},
{-0.18809820002795619,-0.6405661174617834,-0.04119937791402542},
{-0.16461597645910042,-0.6530282634180844,-0.05155559542943839},
{-0.17782669226249526,-0.6793425562158331,-0.06426526207354248},
{-0.1878134310813089,-0.6919120412406313,-0.0726771605291816},
{-0.16722936236187605,-0.6966986427615618,-0.0838131883668481},
{-0.15023634621014986,-0.6913346932285468,-0.08803365640523862},
{-0.14314796250021528,-0.6946161446770436,-0.10896857969184877},
{-0.14232729924890689,-0.6974862632026052,-0.13237870985649006},
{-0.15108464526640716,-0.7002999085615322,-0.1639412022215983},
{-0.1530465871583223,-0.6976308505299464,-0.18555120013489476},
{-0.1654802962718498,-0.6968540440995353,-0.20193282416699074},
{-0.16582414175806173,-0.6839711530258602,-0.21672418785778852},
{-0.15433725935321801,-0.660286066627923,-0.23614875432610488},
{-0.17663394694165763,-0.6468584698335161,-0.2594913970540232},
{-0.19339366082696738,-0.6585606311537227,0.14382614114847192},
{-0.18950362089122663,-0.654607108970382,0.1211683857605914},
{-0.18569588759196415,-0.6317669172179474,0.11023081504397095},
{-0.19420471162438055,-0.6202227606086445,0.1180024840182941},
{-0.2046478417437632,-0.6073262518919511,0.12732115729138668},
{-0.20281586823889028,-0.5949319938912854,0.13059940458858493},
{-0.1982006888124254,-0.5849901131906496,0.1348366944212922},
{-0.20251107334662785,-0.5849140145973122,0.15139594859099445},
{-0.20398938865193741,-0.5903766920422098,0.16888721026962533},
{-0.18755629793961057,-0.5804153861743273,0.16213085673798971},
{-0.18052739128815293,-0.5876055016879869,0.1931927004627195},
{-0.19555966710470085,-0.5937624786673613,0.23770276770583965},
{-0.16398435813439893,-0.5943732700086232,0.22319697399951374},
{-0.1440875798684776,-0.5910611788633352,0.2051215554872893},
{-0.1336330349600943,-0.582696741898804,0.22697526915872202},
{-0.15053293046471006,-0.5877298628102569,0.2513366317400824},
{-0.15874116505344324,-0.5891753355647575,0.294790330352004},
{-0.15458377874374038,-0.586363492540936,0.3126112190954601},
{-0.20832039991012355,-0.17477684087503767,0.42847312978695196},
{-0.19010379848131237,-0.1933735347516242,0.40909242013953273},
{-0.17454383899780557,-0.1696201598791394,0.40650386640931985},
{-0.1976491742701844,-0.1447537429493652,0.4286655791243134},
{-0.19054857473342462,-0.11627845036028678,0.4340393413706798},
{-0.1554953597881415,-0.08076103399564474,0.4217954782215838},
{-0.14508347014391845,-0.05380611119766769,0.4285706561420976},
{-0.1451421461645708,-0.04650745505877414,0.4405700024952328},
{-0.14319322113730548,-0.06095557404172846,0.45426354384740864},
{-0.1484338108453312,-0.08873836943143536,0.46191906233716395},
{-0.14504502032833738,-0.10783511117003187,0.46312662685775685},
{-0.20752236597736026,-0.5567016626741605,-0.02857902698736484},
{-0.18079814207286962,-0.5561761818612193,-0.025877727183338743},
{-0.18329938268020046,-0.570831168862378,-0.026359150915926683},
{-0.16652805374643387,-0.589618910260133,-0.033245272575148366},
{-0.14908124966706865,-0.6220387133570252,-0.04696805180792235},
{-0.2100232060657788,-0.5668093582044897,0.40510385255136555},
{-0.173515306431012,-0.6654056996244334,0.2945576288639561},
{-0.15114472310325258,-0.6561887581550656,0.28754854789865747},
{-0.1372232864899764,-0.6523071291164834,0.2994451611507869},
{-0.12309317952339051,-0.6369258010678635,0.2835824093695792},
{-0.11130070118845978,-0.631274078696359,0.2520425463230161},
{-0.1064550231279646,-0.6332091858211498,0.23372461360939228},
{-0.10627939558491982,-0.6384495752697195,0.19558960589339544},
{-0.13027208050750552,-0.636433162805731,0.17628459432040147},
{-0.1426547234597144,-0.6357008139745854,0.15092774198251252},
{-0.15274239304442835,-0.644385666068959,0.15084283197310433},
{-0.17259691656510176,-0.6536592809644174,0.16393098898933456},
{-0.17299803625577298,-0.6681378393847068,0.12592675069820458},
{-0.2080708766277589,0.264020464914343,-0.8624866376877882},
{-0.18270321027923775,0.28040889776794814,-0.8586662880427883},
{-0.19847304167279128,0.2730557710569814,-0.8483747543317122},
{-0.19787566771509163,0.2749488236959805,-0.8308690739722384},
{-0.18943693449232824,0.2715748523787419,-0.8131621328593325},
{-0.19633607301619976,0.26914590543508166,-0.7983337211691467},
{-0.20004788203596577,0.2567654653368905,-0.7899518616319302},
{-0.19690581116895048,0.23911319505551393,-0.7619461774675268},
{-0.17822641013697346,0.24715281118216761,-0.7456282359424871},
{-0.17198772729948922,0.23868784397064838,-0.7083627547850995},
{-0.15784420294934115,0.23837724155415754,-0.6905340559228536},
{-0.15071116138068483,0.23662196742099062,-0.6700220806076351},
{-0.15585662784703863,0.2366125552265515,-0.6499755082685127},
{-0.1550904351678034,0.23479219677013535,-0.6348046529083079},
{-0.16960804418204223,0.21835149619847474,-0.6606745699728568},
{-0.1756839160816754,0.20841562328152355,-0.6586108962772168},
{-0.1914042833895595,0.1902775235595237,-0.6716752224181649},
{-0.1869423024470504,0.17613239713372644,-0.6555905831595414},
{-0.19491523217480564,0.16940648303942588,-0.6869401997227608},
{-0.18009102593319903,0.16846025710911056,-0.662596860492454},
{-0.1725530597442046,0.1690195817701414,-0.6666190716692546},
{-0.15984960114324118,0.1717709464382053,-0.6942921248769907},
{-0.12193948479650235,0.16109511483077474,-0.7213099291441991},
{-0.14655717948173652,0.16438117224676288,-0.7424232836062402},
{-0.14565661270742372,0.16634331439813418,-0.7618502531880303},
{-0.12909415438642305,0.16429065497258247,-0.777751254525363},
{-0.13533243670499498,0.17182561726973464,-0.8011830127112687},
{-0.16613194054216643,-0.19686786200200979,0.3992234338809361},
{-0.15796796329324272,-0.17417826536060116,0.39631826995054786},
{-0.13690287136013418,-0.1324744338765304,0.3934956129160941},
{-0.14767843217672816,-0.11846227972961768,0.40315532804301246},
{-0.17222082930644944,-0.12002510452542313,0.41759183197751},
{-0.13316743172454232,-0.06543497755692275,0.40871152665393273},
{-0.12010290532413795,-0.03215425905803559,0.4067191453246826},
{-0.1315533405079621,-0.030177097447452915,0.42713599739822905},
{-0.12757718900607626,-0.025615587555236567,0.43556732102111495},
{-0.1353843039041382,-0.03954383299002187,0.44550259315969765},
{-0.1304336898886197,-0.050688271724846704,0.45370662229985165},
{-0.1319814952252138,-0.0725185550399097,0.45744546634619804},
{-0.1315158919896618,-0.09450804462261306,0.453883050880721},
{-0.14282234062451313,-0.1469976501555415,0.46078198914513635},
{-0.12967550758763052,-0.1623715686042837,0.4488561380124088},
{-0.14546456388897455,-0.20669138936406006,0.45906696716265594},
{-0.1605721372610354,-0.22973484446448816,0.4714788479954629},
{-0.16479400711561898,-0.2440561992116987,0.476712028103611},
{-0.1778693475266555,-0.25975433771994993,0.4752130860743178},
{-0.18519243531919952,-0.26977992687325697,0.4762996938833953},
{-0.2105192487386658,-0.3257404293002013,0.49777792107454416},
{-0.2044459802119626,-0.3197076131836407,0.4975209881923019},
{-0.20473775823957518,-0.330205814653465,0.4867492323053748},
{-0.20044139186730325,-0.32859552836655165,0.47021741368116526},
{-0.19381801061455217,-0.34222979291970673,0.4555668323880419},
{-0.1965353311750704,-0.3804264805481982,0.46149230943610536},
{-0.2074516743893388,-0.4026500734351425,0.46670185892842764},
{-0.21186939799203847,-0.39543492548946413,0.4738689446046297},
{-0.1948725769106454,-0.40735256598448955,0.4757788190379455},
{-0.1939429725151907,-0.4134044067493845,0.4748293889563318},
{-0.19978934707807436,-0.403140108324345,0.47984809118694177},
{-0.20209233082381534,-0.40799700091438457,0.47750645736616354},
{-0.20173206406219896,-0.4102583306932461,0.47331062124087964},
{-0.19855614934709406,-0.4124591821163499,0.47148065033056824},
{-0.18978498542711936,-0.4137688789595799,0.47203296591063376},
{-0.18465634075508228,-0.41564050383677087,0.4699360491452726},
{-0.1874437521252535,-0.4150933950025653,0.47202195164054545},
{-0.18817049369162686,-0.41548850690955197,0.4710256608461923},
{-0.18782364431357262,-0.41737034501900655,0.46933707311192374},
{-0.19245244138305587,-0.4151084144617767,0.46714583414271527},
{-0.18794079609542122,-0.4210048538886982,0.4692535649187086},
{-0.2020578861973573,-0.41132471229725226,0.47474648154148513},
{-0.20565074110016937,-0.40790988805095885,0.4731816541511181},
{-0.20269831593812945,-0.41386900868765575,0.4726631824191422},
{-0.21019803257099898,0.4721393036818501,-0.7927773222987702},
{-0.20939178800053346,0.45973122777871,-0.7863840391611371},
{-0.20727804944085557,0.44366441161168413,-0.7539335963674536},
{-0.2042473228314604,0.4667529250897462,-0.7686646819619499},
{-0.19747034257584126,0.45470892087788933,-0.7378553654114269},
{-0.2017983499421851,0.442221141711201,-0.7207952623418901},
{-0.199778332807986,0.4250440871192718,-0.7153472038372916},
{-0.19965637479918982,0.41611872341806044,-0.7272498248731055},
{-0.20509341903370004,0.4283802093992977,-0.7498765400452826},
{-0.20543205777405205,0.446346887026832,-0.7787627650383836},
{-0.20401822601362327,0.46585576272618795,-0.8026549197139813},
{-0.20405567453192355,0.48611320827263804,-0.8178794446084346},
{-0.20742804377351295,0.48894627879881164,-0.8049010297741753},
{-0.19942026890038733,0.49297790217005144,-0.7949725664571018},
{-0.17782108499772303,0.4898802889023017,-0.7822032224950646},
{-0.1890594454174829,0.46788659387101916,-0.7581318356062113},
{-0.1813744887876733,0.46882060397450925,-0.7492441206827565},
{-0.19027962628381329,0.4644289141011094,-0.7228987876693043},
{-0.1984572211757553,0.45543506166589437,-0.7191008670833932},
{-0.20196196191786076,0.4440923660694795,-0.6963682146589121},
{-0.2025463190109105,0.430223397433715,-0.6933410927197275},
{-0.19090343448972485,0.40446202099440026,-0.6745375308249367},
{-0.19011301041629536,0.3992959278040629,-0.7044334639959531},
{-0.19487918547269842,0.4112247828286328,-0.7324443549062164},
{-0.19954162613081508,0.4243882374003759,-0.7543675586089337},
{-0.20005429033856262,0.43437057051115413,-0.7677048383886163},
{-0.18948719961582225,0.4396606243048493,-0.779232773981971},
{-0.18665913557605232,0.4698237035903716,-0.8147758235570004},
{-0.19927648261087064,0.4789413163694883,-0.8179373195912625},
{-0.1901023966651193,0.4903525006999067,-0.8302476688798006},
{-0.19789989910928596,0.5022222791849119,-0.8259999655553735},
{-0.1965309254670351,0.5068578850759042,-0.8208262625057023},
{-0.19429522889856096,0.5078291434382385,-0.8138147784269298},
{-0.17371176095749652,0.5168606446512102,-0.808032887408927},
{-0.1548783604037391,0.5135451490951676,-0.7995218605224929},
{-0.14288101664516548,0.49162374772755574,-0.779801510837441},
{-0.14226561933641224,0.4828471768022649,-0.7671014566472322},
{-0.14148600927361488,0.48073904550735924,-0.7565057288222621},
{-0.15877801279337508,0.4794760091174125,-0.7457479910972655},
{-0.17734166385969663,0.47299300974342345,-0.7396731204949131},
{-0.17131745889975053,0.4744861442484883,-0.7312415966125712},
{-0.1834643964720692,0.4610553433027831,-0.7091073194430704},
{-0.19585244642959415,0.4551056348605252,-0.7057213325584627},
{-0.19234309971999722,0.4429997504767176,-0.6810311439501017},
{-0.1969440607250754,0.4313164135453893,-0.6659504053451651},
{-0.1980382783934866,0.4235319279658725,-0.6611137389601968},
{-0.19939703880347376,0.4188306369732626,-0.6742141118032523},
{-0.19043222398940063,0.4042491451925115,-0.6458006993861246},
{-0.1732990262183685,0.38505988358517296,-0.6213750535193396},
{-0.18422378032979525,0.38899598319582845,-0.6790836207390294},
{-0.17213792189160276,0.3828784573293158,-0.6924204999997997},
{-0.18464973219302927,0.40525204454891744,-0.7316517279787693},
{-0.18842442268202683,0.4220235737421402,-0.7571759972220008},
{-0.17846592044653053,0.4269629732281144,-0.7860009428215196},
{-0.18142795806246573,0.4472564654766716,-0.7952246931123964},
{-0.158031846059755,0.45950633640945204,-0.8211887321213363},
{-0.1590617804427416,0.47595424632153405,-0.8262094369465078},
{-0.1710973737574401,0.48625459144868094,-0.8324483200434483},
{-0.20764352294833185,-0.31013781455253425,0.5056701462414703},
{-0.2104273296482923,-0.31581537039388224,0.5004549894843758},
{-0.20743625441121513,-0.3684403513191691,0.4942527538679112},
{-0.1813316332640569,-0.3418418903531415,0.8576766058104879},
{-0.1522581656794543,-0.3412140769581069,0.8728977262941866},
{-0.15234447750505553,-0.37602978418839444,0.8736757342813348},
{-0.15137882640749353,-0.4097028109618822,0.8695954478622504},
{-0.16347509833740592,-0.44121323586839106,0.8616823957118843},
{-0.15560750508358628,-0.4831737999752479,0.8469721371008277},
{-0.18092310397350808,-0.5164198735882208,0.8345448362898971},
{-0.1479650034584808,-0.5481846280040419,0.8161708309285508},
{-0.177159628014055,-0.5723381212699172,0.8029236679041364},
{-0.1840848002672262,-0.5964413494122984,0.7863277662539585},
{-0.17712017690119317,-0.6213287935849686,0.7678702526993973},
{-0.15777511343696893,-0.6471742789958669,0.745089738264896},
{-0.17799851487587318,-0.6554698267074821,0.7328030195921835},
{-0.14746675793157615,-0.6844239396562185,0.7063345270131982},
{-0.1549993171152545,-0.6941579510413692,0.6906704326124927},
{-0.12692194006554894,-0.6968987019582571,0.6888981364255529},
{-0.12258832543443285,-0.7012869874209025,0.6581238652798566},
{-0.1637652742893693,-0.6908138183830971,0.6219866458984259},
{-0.17068624109396133,-0.6899442918244877,0.5748055180291585},
{-0.1856111778420121,-0.6974041568255832,0.5629693831327868},
{-0.16764169658209174,-0.6999438472484951,0.5002469199094346},
{-0.11861337548928391,-0.7017263566676986,0.417862983281139},
{-0.13500401119690672,-0.7032112805350612,0.4244050591946926},
{-0.12040970281096187,-0.701949045182939,0.3859480342732043},
{-0.19852570990975907,-0.48776675060207997,-0.09872250487731905},
{-0.1904678701725956,-0.4836275879028869,-0.06916501018719853},
{-0.17898118802720803,-0.4843086703132578,-0.05558401464937974},
{-0.19326168984536363,-0.5199652669999251,-0.04231282049022714},
{-0.18317902674705344,-0.5351655605001839,-0.03256799509444437},
{-0.15133156517584181,-0.5258587025350043,-0.031867287257370654},
{-0.15128190083071627,-0.5467856154433685,-0.027310783851558086},
{-0.15586003225779319,-0.5604064626129613,-0.02883315623722095},
{-0.1492548746155519,-0.578705771197163,-0.03726447986010676},
{-0.12752371973128385,-0.5921539947155535,-0.05374743517701534},
{-0.137093117843478,-0.6339357271280671,-0.05829873183696798},
{-0.14801787195490476,-0.6608596097103407,-0.06345180816265554},
{-0.1599042719747705,-0.6818003405211792,-0.07150544245123983},
{-0.20453970163744142,-0.5634179643145659,0.4091841389704501},
{-0.20418163772984277,-0.5133685202548421,0.4421152044588969},
{-0.20077762749418143,-0.497159920392861,0.4518608308925043},
{-0.1975125973210892,-0.49086856931840894,0.4532424208804927},
{-0.18598045627915524,-0.5005098605753614,0.4468194993433492},
{-0.17422382438687564,-0.49344310488669113,0.4330001950527102},
{-0.16415217555865377,-0.49239434611482635,0.42759599336900883},
{-0.14998221696029373,-0.4830386248423457,0.4395254491719471},
{-0.13772313409253029,-0.4739925046890751,0.4547752067578754},
{-0.13793460807822613,-0.47416733119429527,0.481628998530496},
{-0.12072731430841799,-0.4673907514575884,0.5153775231189528},
{-0.08020200972379814,-0.4569670465054525,0.5354391149172868},
{-0.11679241625449932,-0.4536022871231968,0.5687594847884919},
{-0.09218833921228343,-0.4330660804137841,0.6030591234002773},
{-0.0967308244561654,-0.40593933500242907,0.6361654159128566},
{-0.21188001174321452,-0.5774539493367608,0.40171686436947707},
{-0.20977027837265957,-0.5855924936347532,0.39890642316184843},
{-0.2046890951917304,-0.596367854191891,-0.39675563660278257},
{-0.19643500118753857,-0.6061927833701343,-0.40207452775816344},
{-0.19368183418436924,-0.6200407247630028,-0.42079237860572155},
{-0.18208741245157226,-0.635639334321547,-0.4206782307157153},
{-0.1712621872898527,-0.6513997535206614,-0.4202971369706591},
{-0.16155981689877402,-0.6657735762453835,-0.43206818754378173},
{-0.14893325792897277,-0.6737653303620169,-0.45754619685264225},
{-0.1622038513097569,-0.6613264145026296,-0.4769869843369069},
{-0.14384927111565743,-0.6727578250381193,-0.4899167361233214},
{-0.13805616556811004,-0.6798822554501611,-0.5045681184542693},
{-0.1449539022757885,-0.671963796294479,-0.521543311514398},
{-0.16056773155300005,-0.654341364672069,-0.5457430647146442},
{-0.1745650665001576,-0.6403238035198403,-0.5638571333019059},
{-0.1746313523801437,-0.6155743381124583,-0.6041241031880905},
{-0.1901901103069136,-0.5956343038040085,-0.6028047938909651},
{-0.19578996547927494,-0.6360486646499203,0.3800858392132847},
{-0.18684017012441317,-0.2792179547822158,-0.4982024711215851},
{-0.17975559134414548,-0.274629409863419,-0.5189022898066734},
{-0.17198372211036617,-0.2706039945353199,-0.48712471878565866},
{-0.20314769815773315,-0.4131048186029819,0.46680178839704717},
{-0.20281987342801333,-0.41392508133537803,0.4713640993270881},
{-0.2028759460757357,-0.41715526636309996,0.4701745581575489},
{-0.2029640602364423,-0.4195047103026681,0.4689253396700765},
{-0.19981558106683014,-0.4074430832586699,0.46148489983622776},
{-0.18856099963112208,-0.4158904276380478,0.4633725454699108},
{-0.20571462386668166,-0.4556961999967156,0.4456758175892686},
{-0.20515890387586155,-0.4522687594046847,0.44794976371386763},
{-0.20516290906498455,-0.4522777710802115,0.44794235411398997},
{-0.2055994746793946,-0.45485210638903767,0.44623554276921173},
{-0.20518093241603821,-0.4524429851315364,0.4478336132292998},
{-0.20454010215635376,-0.4488623460555496,0.4502046851901323},
{-0.20448402950863134,-0.4485859880060606,0.45038692129523},
{-0.2047253421532938,-0.44995075619973235,0.44948174855342576},
{-0.20584979899958383,-0.4565943636575547,0.4450800457072182},
{-0.20617121542670683,-0.45951915301464574,0.44313152119886523},
{-0.2061652076430223,-0.45952616209561103,0.44312651471246145},
{-0.20588384310712957,-0.4568266646266903,0.44492584592598167},
{-0.2062793555330286,-0.46103471657879946,0.4421196101669322},
{-0.20644256698979196,-0.46387579748321917,0.44022335337663476},
{-0.20636646839645442,-0.46216357913312484,0.4413672353901715},
{-0.2064926318538298,-0.4656601092375281,0.439033211428727},
{-0.20652667596137553,-0.46685966337987495,0.43823317490140223},
{-0.20651966688041024,-0.4666473883563544,0.43837335652070814},
{-0.20656072006892126,-0.46964326982037924,0.4363767697428788},
{-0.20656172136620202,-0.46964226852309854,0.4363767697428788},
{-0.20657373693357114,-0.471201288389237,0.4353414283545762},
{-0.20659576547374775,-0.47409804142246686,0.4334199388728036},
{-0.2066228005003282,-0.476948734780782,0.4315485142550688},
{-0.20660077196015159,-0.4748620312476845,0.43291628634058277},
{-0.20658274860909792,-0.47235678545123055,0.43457243204295476},
{-0.2066228005003282,-0.4770468619142962,0.4314824286345389},
{-0.20667286536436605,-0.47959416219654183,0.4298443062832205},
{-0.20669689649910422,-0.48078470466336176,0.4290793151607222},
{-0.20666585628340076,-0.4795581154944345,0.42986032703971255},
{-0.20661679271664365,-0.476882649160252,0.431584560957176},
{-0.20677399638972252,-0.4827031902532921,0.4278927778830252},
{-0.20676898990331874,-0.48274224084724165,0.42785973507276026},
{-0.20680804049726825,-0.4835633046174624,0.4273600877296625},
{-0.20702432070991175,-0.48648308748814956,0.4256759057034293},
{-0.2069271948736783,-0.48532158264247155,0.4263297528277636},
{-0.207335523904771,-0.48933598370048226,0.42414572319897653},
{-0.20708539984403793,-0.48739627060819996,0.4251362064691013},
{-0.20354981914568512,-0.4917326888717022,0.45447601913038527},
{-0.20155022847601353,-0.48824336810772034,0.45679121870295153},
{-0.2022979972852828,-0.48756929477831473,0.457970546640227},
{-0.18815227008111707,-0.2650355800975744,0.7998466813603705},
{-0.17775820352849148,-0.24926434688782784,0.7741217521420752},
{-0.1553940285033289,-0.22127808789067113,0.790329951485144},
{-0.15723741679720246,-0.22750495542024243,0.8086176450208891},
{-0.17262695548352444,-0.25758192313961964,0.8232089495149915},
{-0.1580062128493676,-0.25264212313473333,0.8397794182142384},
{-0.16950591185940503,-0.284258084774634,0.848702979580344},
{-0.15951656966766142,-0.30002791616818747,0.8609798855397052},
{-0.1799053854173467,-0.3155191866582344,0.8521836891877115},
{-0.19382922514409667,-0.31384842201556334,0.4766189074565006},
{-0.18369469484664327,-0.2880473942039306,0.47054784178381504},
{-0.1801641206346943,-0.31056657004815436,0.4498940827736415},
{-0.19109147811905103,-0.3248662967741005,0.45407930514774936},
{-0.1776440556384852,-0.3310513100773362,0.4292184954827474},
{-0.17559199699130193,-0.3382344165100304,0.4341490835526508},
{-0.18444186287754413,-0.34899716072143067,0.4469394547575839},
{-0.17727517772025436,-0.37530724807060023,0.44064730264530716},
{-0.18661247512276907,-0.41609769617516446,0.454221689621073},
{-0.19659200460116127,-0.3255794206974556,-0.5602875084960074},
{-0.19336662580038697,-0.32747327437427926,-0.588083120490908},
{-0.184522367178917,-0.29155393728114143,-0.5592798029126536},
{-0.20303314974881453,-0.42063137000297585,0.46831955481521853},
{-0.20303415104609532,-0.42117247105349687,0.468027776787606},
{-0.20310624445030978,-0.4243345678661273,0.4662114235203129},
{-0.20309623147750225,-0.42343540290800763,0.4667521240519216},
{-0.20312426780136345,-0.42538993520004514,0.46559762828720885},
{-0.20314629634154005,-0.4272984078171679,0.4644291143605655},
{-0.20315831190890918,-0.4288664393588333,0.46343783005261613},
{-0.20315230412522464,-0.4281114612091425,0.46391044236913337},
{-0.20313027558504798,-0.42561622838549623,0.4654644557488682},
{-0.2031623170980322,-0.4293140192433316,0.4631554642194427},
{-0.20320076691361325,-0.43299839271760493,0.4607653676102758},
{-0.20317933915180508,-0.4312084736985237,0.4619328802396384},
{-0.20317833785452433,-0.43125353207615785,0.4619078478076195},
{-0.20321037936750852,-0.4337587778726117,0.4602637176726166},
{-0.20325643904242333,-0.43592258129632755,0.4588298599665726},
{-0.20325643904242333,-0.43582345286553253,0.4588939429925411},
{-0.20324442347505425,-0.43576738021781014,0.4589339948837714},
{-0.20334355190584918,-0.4383777622287435,0.4571947415070965},
{-0.20335456617593753,-0.4384067998498855,0.4571757168587621},
{-0.20340262844541387,-0.43956429950644055,0.4564027153580178},
{-0.20353580098375454,-0.4413926683411027,0.4551811326754943},
{-0.20359387622603847,-0.4422167360031656,0.45463041917107805},
{-0.20352879190278925,-0.4414347228268945,0.4551530963516331},
{-0.20406348465071344,-0.44600564491355,0.45210314483444747},
{-0.20377511103385545,-0.44384184148983413,0.4535450129187375},
{-0.2039182965450037,-0.4449292503367363,0.4528190723901887},
{-0.20400741200299108,-0.44573629594502634,0.4522793731558607},
{-0.20435886734853675,-0.4479000993687421,0.45084050896341293},
{-0.19698531417304257,-0.48553045325523747,0.4569880737483483},
{-0.197766326052033,-0.5545576849366038,0.45431060481960417},
{-0.1972987202219195,-0.5444838332543643,0.45587262857758504},
{-0.19992992921629263,-0.5498569947223623,0.46185017308424786},
{-0.19228482421825716,-0.5598685657137386,0.46007747637839574},
{-0.18615588356274387,-0.5542082321856197,0.4664489312353084},
{-0.19458480407215586,-0.5441115509253789,0.4634075908747372},
{-0.19228021825076566,-0.5381652468938756,0.45749513069132364},
{-0.18575736724500264,-0.539987207425941,0.45061481655633034},
{-0.19017308825314075,-0.5508004170202915,0.4485028803317577},
{-0.1891515647673125,-0.5616953324727517,0.44977332632158223},
{-0.17942516324149566,-0.5717018969777243,0.45547531381658074},
{-0.16394630883773015,-0.5822065067501454,0.4660107635452492},
{-0.1390730830864468,-0.5986730407916495,0.47815049177714647},
{-0.15579795182638626,-0.5743631448905202,0.4738351007565401},
{-0.18524830770746578,-0.5407435873918248,0.4622202525592157},
{-0.18586310423785055,-0.5341927000622005,0.4561193482275636},
{-0.1774171616746657,-0.5400330668413996,0.4534338689205734},
{-0.17786674415372555,-0.5471933436960925,0.4475320224883358},
{-0.1807779158677983,-0.5611394122224754,0.4476704017725365},
{-0.15186325403192374,-0.593269840405229,0.4592798429645448},
{-0.14623816616808738,-0.601696157541711,0.46404681905877254},
{-0.1332757720903202,-0.60979845487814,0.4756897035799581},
{-0.09079373235964516,-0.6477492238944775,0.4894325087583473},
{-0.09920042406942435,-0.6279631891078081,0.4891225071202249},
{-0.123661315600492,-0.5943129919123216,0.47798667954201457},
{-0.15628378126700954,-0.5653106164346527,0.4697139614084007},
{-0.16736073256511136,-0.5510689649509906,0.4611871140249306},
{-0.17132506875908426,-0.5494652872261301,0.4527357644564297},
{-0.17183452881553338,-0.5605854945667607,0.4514356800670949},
{-0.14204513367518956,-0.5860304610653563,0.46050903550640204},
{-0.11959304474877652,-0.6127094263327567,0.4653070518163332},
{-0.12230375674724173,-0.6229819353954983,0.46818598175796555},
{-0.10334879870360038,-0.641110422663603,0.4746175144517236},
{-0.09294051372958805,-0.657832087252244,0.4805948586989303},
{-0.0866725930115057,-0.6673137717226437,0.4823607465832732},
{-0.0752371772868929,-0.6623413294264048,0.4950503872817622},
{-0.06440514330366423,-0.6602778559902209,0.49909843192840636},
{-0.08859908897968208,-0.6265615731742045,0.487657008420109},
{-0.12214535151742598,-0.5919965907830184,0.4729034937665239},
{-0.15133717244061407,-0.5688467979113739,0.4612161516460726},
{-0.12255207847286943,-0.5948100358824893,0.4679214390163896},
{-0.08143000070891847,-0.6340895263903913,0.47644408095128044},
{-0.08813689015488467,-0.644995656372396,0.4718403163138162},
{-0.09609900587200777,-0.6569191043916497,0.4695131011738808},
{-0.10055578006865695,-0.667766358093546,0.4624273208368762},
{-0.0901298722625033,-0.6718614637123858,0.4805982631096848},
{-0.08879574376562274,-0.6745751796026932,0.4969182072292862},
{-0.07065343859504374,-0.6701360282381854,0.5007681952737967},
{-0.04460949606309935,-0.673465141437246,0.5050405305113305},
{-0.045302193521927006,-0.6686152579281718,0.4999499351359621},
{-0.06151620038922428,-0.6499745069712319,0.4944676322643617},
{-0.07881441195212517,-0.630047890046344,0.48426301115725534},
{-0.07830234852274606,-0.6319775901658188,0.48051715802994355},
{-0.19977893358635448,-0.5613811253860501,0.4110940134037659},
{-0.1960026410217077,-0.6111908588767606,-0.3099541766312434},
{-0.1930586267568261,-0.596083485764156,-0.3375178881759207},
{-0.18739108388828565,-0.6030913651727177,-0.3548479409923497},
{-0.19688738729898456,-0.5952946637663756,-0.3887174222923219},
{-0.18733421020273866,-0.6151315644549077,-0.39255659632620016},
{-0.1892817334138109,-0.6174996325238978,-0.4117927186462781},
{-0.17878733687365347,-0.6334282696661795,-0.41317811356393347},
{-0.17065820477010013,-0.6451933124556174,-0.3952582966491386},
{-0.1650765732082486,-0.6551610266260968,-0.39102741511902817},
{-0.15427577970017953,-0.6703727349153563,-0.3934625701058291},
{-0.14403491163150978,-0.6803340407832387,-0.3957301079278313},
{-0.13630349480787307,-0.6856256966525831,-0.4299368261519625},
{-0.12871686557103382,-0.6887803838653359,-0.4688682657250734},
{-0.16911079995241834,0.26563996313623933,-0.8980040540524304},
{-0.17334628745002023,0.2811861047172716,-0.8803798200949149},
{-0.16548390094206053,0.2875199107964278,-0.8603164259614755},
{-0.17872425514496582,0.2862478627309542,-0.8441757140551298},
{-0.18820954428557637,0.28432437065462013,-0.8330533038604815},
{-0.18511633672586203,0.27956520467918233,-0.8247689706784107},
{-0.17831091962746934,0.28254846979746956,-0.8277802721205593},
{-0.17565527897944577,0.26813159128967484,-0.8062423676114774},
{-0.18779400591406226,0.2723057993936945,-0.80050493419274},
{-0.1841002202453499,0.26420029790596694,-0.7911798526170506},
{-0.18765382429475627,0.2566635332737094,-0.7772239713773164},
{-0.18723067606390836,0.2502722527306378,-0.7599708181920496},
{-0.18309932348350522,0.25842701804457857,-0.7634254940701172},
{-0.1760439825838356,0.2599854371323487,-0.7650127505195731},
{-0.16374364626810495,0.25568867024116443,-0.7634959853986825},
{-0.1627996231918073,0.2485992852339491,-0.7491353797980663},
{-0.16905372600741517,0.25406396527340824,-0.7378982209350434},
{-0.17477794230204652,0.25264953273461094,-0.7251012411680573},
{-0.16559544545913685,0.2628307234853476,-0.7136510062436893},
{-0.15951196370016993,0.25703621612160715,-0.7047224383911795},
{-0.14928531405288692,0.25655979887542296,-0.7039175956369071},
{-0.13589997200372803,0.24091032341501645,-0.6984040522901471},
{-0.13174378725076208,0.23523056471965073,-0.6904745788643767},
{-0.13575398286019366,0.23831255774982063,-0.6603667711887521},
{-0.143479592159602,0.24365648133722048,-0.6322841873931866},
{-0.13830829222340463,0.2501853401266681,-0.5947087045976767},
{-0.15183121251893952,0.22567939021796637,-0.6100319574040126},
{-0.16991724478234,0.20663711905144302,-0.6286644977232502},
{-0.18362560533427108,0.1998817668170882,-0.6516448710949906},
{-0.18600468767334957,0.18931587765108476,-0.6413481306380546},
{-0.18016892686164196,0.17784000951632933,-0.6245519695317253},
{-0.17425246148910528,0.1706352750623708,-0.6223561245950253},
{-0.1969120192120912,-0.3847538871361736,-0.6252282457151486},
{-0.1914655627831418,-0.37408346253405905,-0.6481082890993571},
{-0.19477945626353502,-0.3567375892205942,-0.6098607355690031},
{-0.18258505720010848,-0.31796495539621134,-0.6350465663313388},
{-0.17960159182236504,-0.293318022830379,-0.6063870350426012},
{-0.1792277074177304,-0.2748184547900259,-0.5545843194442719},
{-0.18994859740279507,-0.4922397458146774,-0.11329378342580648},
{-0.16728303189612462,-0.503546394708985,-0.13870931178434778},
{-0.1742951167532655,-0.48841539098055436,-0.12112913490718576},
{-0.1907169929360479,-0.47925952864531285,-0.09531909542002617},
{-0.18710591442272606,-0.4607076928869042,-0.08702074407602489},
{-0.18078872987843048,-0.4518055592826065,-0.07400848539367605},
{-0.1659074496918207,-0.4435502637216777,-0.06507210742237643},
{-0.15799579935764776,-0.47160200756099596,-0.05290113871531957},
{-0.19679306509513722,-0.5634990693943072,-0.610711237479278},
{-0.19018870849072056,-0.5630310630452814,-0.6266663088697716},
{-0.17321431646841648,-0.5600079462952201,-0.661401111279774},
{-0.1779234175798164,-0.5143213547472104,-0.6750890453671776},
{-0.17975358874958394,-0.48161097517944246,-0.6830531636788623},
{-0.17983629590497446,-0.4293738968207209,-0.6889375875384147},
{-0.1867524564826189,-0.41507176698130094,-0.6713269712239176},
{-0.18494271177737875,-0.3806910232897742,-0.6713453950938836},
{-0.1810214313664784,-0.34970327556382047,-0.6783354514108478},
{-0.1855148530436033,-0.3322606769330344,-0.6477438168891616},
{-0.17289209900346889,-0.326917354124003,-0.6829700560045595},
{-0.17253683872825634,-0.29323791904791846,-0.6654073017000826},
{-0.16806905026151883,-0.27208951918105095,-0.6525812843119545},
{-0.1631270474026148,-0.24666257603350897,-0.6329324272527487},
{-0.16689893425922625,-0.23971978094819643,-0.5828128923833719},
{-0.16708497529399088,-0.24434437256910052,-0.53725026143872},
{-0.1644207234893528,-0.25424119489210223,-0.4942084965281017},
{-0.15927085131496366,-0.2610914701086728,-0.47155634840499344},
{-0.16143485499813556,-0.2743200090036651,-0.4593481314390925},
{-0.14849368842272048,-0.2954990485673238,-0.41726200465322866},
{-0.15761150146129324,-0.3280193819112041,-0.3710971935239296},
{-0.15608472336759505,-0.378908914389483,-0.2923027073876915},
{-0.16232120335106162,-0.4095069572137662,-0.2594747755191626},
{-0.1798044546514464,-0.425532519932825,-0.24829829527135355},
{-0.1600764951070607,-0.4489632768214498,-0.22258137643130435},
{-0.15711986449644158,-0.4734998664269427,-0.20168189906843306},
{-0.15001225587871647,-0.4988230751761983,-0.17335459821745053},
{-0.15847562101458648,-0.506525454378693,-0.16529715899919936},
{-0.1501304089578458,-0.5040935035431905,-0.15747642645811913},
{-0.17181330131318134,-0.5847540072918472,-0.6486479883336851},
{-0.16141262619850277,-0.5759103494487458,-0.6748565441385859},
{-0.15691239569986873,-0.5523536293622016,-0.6954688494413361},
{-0.1657792836398838,-0.5185784702660767,-0.7004823449260862},
{-0.16777987560683622,-0.47497818173225226,-0.7037756116824958},
{-0.1689063350476878,-0.40654471933837477,-0.7066375195703553},
{-0.17721630144014586,-0.37799192633976575,-0.6926225617910565},
{-0.16902969487267702,-0.35594235892021703,-0.703602587512381},
{-0.19365259630377113,-0.5788265276492223,0.14825968524820754},
{-0.1673270889764779,-0.5771363378393045,0.14003182523277155},
{-0.15807129717261684,-0.5822421529333404,0.16336585680407534},
{-0.16047020519785435,-0.5930020935123546,0.20176921219131505},
{-0.1821969543740871,-0.5902903802166085,0.21525047851997042},
{-0.14472340364175826,-0.5886428456708511,0.18171723284687638},
{-0.12748466913733433,-0.5789933437761964,0.18079924349987841},
{-0.12303971024859808,-0.5775374575299758,0.19932384397225042},
{-0.11417302256803916,-0.5765119288550246,0.22162253415525152},
{-0.1358803465770252,-0.5754381376511408,0.2563721557650091},
{-0.14325850572001084,-0.582691334893488,0.2731817342549006},
{-0.14906723150513806,-0.583437501627108,0.30537444312851725},
{-0.1928773919490091,-0.6027022610494156,0.11690005571218066},
{-0.19061325853776148,-0.5907059185881228,0.1209653226720539},
{-0.18012366822455173,-0.5852670720185071,0.12177036568578246},
{-0.18481855091456492,-0.5781522540603605,0.13453770705325818},
{-0.18198648168567194,-0.6354020268660076,-0.2777254210555195},
{-0.184478710617476,-0.6186969838122269,-0.3087478136673874},
{-0.1782101891210252,-0.6220627444917634,-0.3214803098894928},
{-0.16521775612483533,-0.6439266713954598,-0.3356476651149229},
{-0.1786333373518731,-0.6228627810190883,-0.36392410006404297},
{-0.18004857092849497,-0.6284390055756238,-0.38396766851132325},
{-0.18005117430142492,-0.628902405957158,-0.4011905825187112},
{-0.16433160803136543,-0.6515831911824959,-0.37169556877890997},
{-0.1491687630494068,-0.671905520792739,-0.3537350991945164},
{-0.13120408801643407,-0.6854110185155888,-0.32478739454837685},
{-0.11709781192513019,-0.6963223552434534,-0.32653966478970153},
{-0.12326420109894377,-0.6939172391750752,-0.40440354523320404},
{-0.10905018542023044,-0.6974628328462354,-0.46715784971008434},
{-0.11776848084378119,-0.6917578414593948,-0.49493303524045745},
{-0.12778025209461377,-0.6791400939056642,-0.537899702855019},
{-0.15258238573896338,-0.6611229508951798,-0.5572037131307321},
{-0.15725283677532612,-0.6526848184507849,-0.5781220148824817},
{-0.1584153429182849,-0.6314773420443526,-0.6146801796407425},
{-0.16881341466003352,-0.6045234205436564,-0.6342973957058765},
{-0.18953906681496546,-0.270520686601561,0.7465636478621702},
{-0.17062916714895818,-0.2454594172209514,0.7559411974153712},
{-0.15172527526663546,-0.2196427691717389,0.7591167116115639},
{-0.14565280777775685,-0.20815808962091284,0.7771510769352773},
{-0.13968047001695394,-0.20273005706192943,0.8039576074762462},
{-0.13961238180186247,-0.21496490853549857,0.8253703498252333},
{-0.19459722015843725,-0.5154728466200809,0.40635447285503096},
{-0.19455796930503158,-0.5171994836510182,0.40539342772496045},
{-0.19405892274030231,-0.5024003098414305,0.4151524715421299},
{-0.1945813996614013,-0.5130889580540549,0.4082224930620111},
{-0.19387288170553768,-0.5014819199755202,0.41583014954174624},
{-0.19312331056116303,-0.49804807108089244,0.4181711825841559},
{-0.19346575423118192,-0.4994939443543054,0.4171979216272602},
{-0.19645702972771523,-0.5332650982613073,0.39794537803177793},
{-0.19493986408791228,-0.5282203623013977,0.398446827709981},
{-0.17895755741138217,-0.6174361502762978,0.10588758795895961},
{-0.1788882676395538,-0.5973611410944017,0.1143078973117571},
{-0.16024431253131557,-0.5889516457522365,0.12222775828363226},
{-0.16606004739740807,-0.5807400067527487,0.12742889687879616},
{-0.1855655186860096,0.5064285288019158,-0.837047478713421},
{-0.18069661052860087,0.5206307291727161,-0.8361741472251448},
{-0.16402701339855916,0.5294729851996246,-0.8278721912109328},
{-0.17973296202560035,0.5184182627011557,-0.8162174913818342},
{-0.14311792358179257,0.5304640692481177,-0.8122869990359509},
{-0.12404140804826733,0.5233959117432545,-0.803240478363768},
{-0.13329299440354925,0.510644591132271,-0.7934513956281758},
{-0.1323299466789172,0.49111148403872057,-0.7693687942097781},
{-0.12703588769609905,0.4867968940559389,-0.7475547319106635},
{-0.13202034555970715,0.4791125382044976,-0.7323019704328928},
{-0.17372978430855016,0.44042581568680383,-0.6733916462168384},
{-0.18690705678276776,0.4275495331751818,-0.6488274208063967},
{-0.18621235672937855,0.41413875817509166,-0.6244440296848597},
{-0.18781703575151965,0.40621949798158485,-0.6267047586853527},
{-0.16722555743220915,0.38693110794345154,-0.5821338125675625},
{-0.1556465556775358,0.374170575397485,-0.5747864933808241},
{-0.16218462640196638,0.36926381820286364,-0.6055793886559425},
{-0.173746806362323,0.3775325311473545,-0.6439545074598649},
{-0.16976424655784034,0.3755073072672955,-0.6593194142330804},
{-0.15166840158108846,0.373112404431181,-0.682669066041964},
{-0.16299767979394103,0.3703640436549594,-0.6983309575886518},
{-0.1734576317076404,0.38521308206912874,-0.7180034452636835},
{-0.18044107946255167,0.4104361610903085,-0.7512751520870439},
{-0.17642347425324248,0.4077108301515443,-0.7741606024765686},
{-0.1678211290548034,0.4167847863692199,-0.788563863341345},
{-0.1707138768989102,0.41871849167781783,-0.8012408876940963},
{-0.173340680185248,0.4312971886375989,-0.8052432731847381},
{-0.16937554295345048,0.4392635098033011,-0.8089440679344158},
{-0.15325846166293047,0.4448857940347514,-0.8118229978760481},
{-0.1465231353741908,0.4456445771141091,-0.8215447934343735},
{-0.14333059912422533,0.4573417319479116,-0.8275127254871412},
{-0.12537012953983181,0.4692767950156222,-0.8346932285469052},
{-0.13676849726505658,0.490309244657378,-0.8386263242657186},
{-0.14822433945419686,0.511792878853843,-0.847233075172193},
{-0.16552775776295767,-0.25596963425814484,0.7321621893324991},
{-0.15357667393875504,-0.23416798804531147,0.7408979073287351},
{-0.13110335750998994,-0.20232292958757367,0.7492671505202139},
{-0.12809425892185913,-0.19095900648880687,0.7739753624796286},
{-0.11449103458440754,-0.17480968342584652,0.7971920420096277},
{-0.12481541084629244,-0.18829215131123883,0.8057389153387127},
{-0.10913789906202476,-0.18945706056767148,0.8335719758519136},
{-0.12458671454736757,-0.21376795776608173,0.8423197094155186},
{-0.1444019872146353,-0.2586404946248359,0.8540567158810956},
{-0.13155734569708513,-0.2660647134427364,0.8650273294079809},
{-0.12725817569242712,-0.2936314288792559,0.8750881642255705},
{-0.1876776551700383,-0.42563905796349744,0.4649269593685578},
{-0.18583967388148084,-0.42554233264617636,0.46205724136190846},
{-0.18764361106249253,-0.42389559913824343,0.46596069868121137},
{-0.1873768654668989,-0.4298350943482375,0.4607429385511869},
{-0.18868155582372523,-0.43493830606934336,0.45919032698764517},
{-0.18832409269449496,-0.43402011646288935,0.45943364222686905},
{-0.18349183201756195,-0.4296216177679801,0.45704815158519374},
{-0.18150886288275087,-0.4208116035135121,0.4615585953160915},
{-0.18935262526128852,-0.46309158145293033,0.4404063905195571},
{-0.18888441865280656,-0.4595696183975958,0.4433119549688576},
{-0.19020212587428273,-0.4711426123685847,0.43564562246847005},
{-0.19008197020059187,-0.48320524070986365,0.42823161688283334},
{-0.19053315475530094,-0.47983467380337963,0.4305370037420482},
{-0.1903555246176947,-0.4770650855248058,0.43212085578074944},
{-0.18202873643091988,-0.46585676402346876,0.43853116097215544},
{-0.18152668597434835,-0.4545200762107386,0.4419676132397133},
{-0.18998023839686695,-0.4541291697523311,0.44724184653637244},
{-0.19033069244513193,-0.45349735116817336,0.44785724384512565},
{-0.18999265448314834,-0.4553227161109934,0.4463282628974098},
{-0.1765610524996185,-0.4639689181303296,0.42870963620466673},
{-0.1892949505379169,-0.48459444055718576,0.42776180819870224},
{-0.18906204879041283,-0.4893317782519031,0.4242610726457198},
{-0.19051653322044038,-0.49138944416385866,0.42329121609957854},
{-0.18289185468693236,-0.46435401706450874,0.4627925940848963},
{-0.16996971275985165,-0.43545998195261776,0.46833677712844757},
{-0.16421205313604303,-0.4523923194891301,0.4596052645807909},
{-0.16816036857352387,-0.46257951802355124,0.45365435458179615},
{-0.18126494686515848,-0.48196603519519887,0.4482737835139206},
{-0.19222714949488556,-0.4949490559969496,0.4202953346355538},
{-0.1908954241114788,-0.49260401776541685,0.42207323808726577},
{-0.19289000829474667,-0.4971609216901417,0.41877496484445237},
{-0.19261264894797697,-0.4962577515428989,0.41941479380685615},
{-0.19213803403689816,-0.49502815848212944,0.4202719042791841},
{-0.18389335222714548,-0.4919754033325576,0.4204661559516509},
{-0.1836482346528162,-0.49735937881118775,0.42044392715201806},
{-0.1813492560961982,-0.4933087307916135,0.4272373286830417},
{-0.1810558759929364,-0.48120084381324435,0.4265103868572122},
{-0.19306523531887915,-0.4976345353039398,0.4184575536064524},
{-0.1847624782668425,-0.6444655695919633,0.3763548052857281},
{-0.16827732009591626,-0.6522734855278498,0.3618009493099259},
{-0.15193855158743666,-0.6585043582465441,0.35088680894967517},
{-0.18705104333174058,-0.28100867483912156,0.4519185056158759},
{-0.1869451060794365,-0.29484880611320025,0.4274614190144751},
{-0.18425061509691956,-0.27830697451618314,0.44186287754414616},
{-0.16736233464076056,-0.2556902723168136,0.4582412974249437},
{-0.17074591841189443,-0.26777092400914626,0.43356312438395184},
{-0.18170371533358617,-0.28367272638430346,0.4125294731854591},
{-0.1882790343168609,-0.297394904838709,0.4101001257228865},
{-0.18548120945496985,-0.30389592756375156,0.41190586523900363},
{-0.1712333499281669,-0.3162837772618204,0.4152063413358346},
{-0.17328400675915717,-0.30680129175359594,0.4350140041437686},
{-0.1780774171015968,-0.30116899454933804,0.4457453076205532},
{-0.18583146324377864,-0.3053197722969879,0.39812420972612117},
{-0.17410667260502707,-0.2698255860292595,0.4138087305913541},
{-0.17750827972721456,-0.26107444805489993,0.4046336433483221},
{-0.17808222332854445,-0.23572820946818696,0.4036257375055121},
{-0.1733665136550915,-0.22252550404303814,0.4090906178044274},
{-0.1605218721375414,-0.20091210171898707,0.4013283610245434},
{-0.1414023008209436,-0.1826412299775589,0.39622134437377055},
{-0.1368784397064837,-0.1674313240234047,0.39284236657012817},
{-0.13465395766755406,-0.15163325604653388,0.39104323561606413},
{-0.12357019754794311,-0.12433428750288873,0.39320623800195525},
{-0.11798335924023162,-0.05775262430004313,0.4005855987016778},
{-0.11043037359202582,-0.017812678105753817,0.40358888976558027},
{-0.12061877368318392,-0.017051491912922375,0.4167925964880098},
{-0.11658815160922491,-0.017281389768584177,0.4308578193908027},
{-0.11689955506354031,-0.027819042351270307,0.4410816654056996},
{-0.12094900152637757,-0.0443472563052691,0.44982439248290074},
{-0.1129628546745163,-0.04467087558640975,0.4435124146844651},
{-0.11260459050746145,-0.07422256275230188,0.4371243382926919},
{-0.12681700411052557,-0.11690125726891759,0.44602026385384896},
{-0.11311064615315602,-0.12349319778705288,0.4332316949840213},
{-0.11803042021242723,-0.16121707283957093,0.4325233772876138},
{-0.1284505204943525,-0.18440811915918262,0.44363257035815595},
{-0.1330536843534483,-0.19845872312167642,0.43960054646800384},
{-0.14977695101773858,-0.21719239446627048,0.44199645060139914},
{-0.1629243848329896,-0.24003078388359955,0.4484646307756329},
{-0.18912753363257437,-0.43674865155295195,0.4583742697038282},
{-0.18949260662113834,-0.43849291141603064,0.45750614496141195},
{-0.18931838089428663,-0.43770989694247864,0.45789464830634563},
{-0.1899281709382676,-0.4404754800319294,0.45649643678349666},
{-0.19041279882215395,-0.44329913836366397,0.4548547097619675},
{-0.19017008436129845,-0.4415326497009525,0.4559212916254299},
{-0.19076665728117348,-0.4453313713246883,0.4536583597709191},
{-0.19059603622453247,-0.4453277666544775,0.4535910725936523},
{-0.1908103138426145,-0.4466677026755865,0.4527259517430783},
{-0.19077306558377033,-0.44909044157610595,0.45104897905726654},
{-0.19054316772810853,-0.45126826316175234,0.44942347305168573},
{-0.19068555220143216,-0.44947013350496895,0.450778428532006},
{-0.18552786990825312,-0.4593461288445309,-0.10538073127544047},
{-0.1821873419201918,-0.4376095669549468,-0.10457368566715036},
{-0.1743305626770043,-0.42238183790919515,-0.09616399006552889},
{-0.16367395597736425,-0.40402365304488497,-0.09269930121465371},
{-0.15958185425036678,-0.4130327251987675,-0.07867973746786336},
{-0.1440134838697016,-0.401722071115337,-0.06873244976191153},
{-0.12878054807808997,-0.40685091604683027,-0.06086325443244267},
{-0.12576283833334467,-0.450097145862179,-0.05193648891503833},
{-0.10494646864477616,-0.48048992274390695,-0.045873433620598855},
{-0.17235300054750932,0.25867413821346935,-0.773063180656859},
{-0.1625252677368799,0.2545045360769413,-0.7771140289358893},
{-0.15866606775738645,0.2471041481343228,-0.7693988331282009},
{-0.15245762409778107,0.24224705528482698,-0.7534848149262183},
{-0.1432228595368159,0.24319007706384388,-0.7375667915351128},
{-0.15602604734694267,0.25075587931724336,-0.7400385940023895},
{-0.1507672340284072,0.2683378585295108,-0.7303374251680477},
{-0.1609412154387224,0.2744109267967578,-0.7283101986934272},
{-0.17112280670837132,0.26039937342821357,-0.7300604663401903},
{-0.16446678316426763,0.274786813795954,-0.7213453750679379},
{-0.1573537675412264,0.2785667110308115,-0.717521220493271},
{-0.14888359358384723,0.27487833236741516,-0.7159089316117961},
{-0.13962479788814386,0.26223254848982336,-0.7143368948810078},
{-0.12326199824492612,0.25277529567307405,-0.7172977309402061},
{-0.12042832694038395,0.24234077671030585,-0.7075070461289646},
{-0.11391128345884928,0.23560665197830305,-0.6934992976900872},
{-0.12263278303369846,0.232527062061607,-0.6825012486177091},
{-0.12020383609003825,0.2339911589455298,-0.6607767022954939},
{-0.12170638278954211,0.23856828907532596,-0.6406768609410352},
{-0.1253062467733195,0.24543398427002025,-0.628639064772319},
{-0.1270467017067312,0.2548495831198901,-0.6063479844486516},
{-0.12934948519301606,0.25863508761951987,-0.5918259697263775},
{-0.12555276616384187,0.26551339915995165,-0.5674904406148605},
{-0.11511704564433681,0.27670229549404207,-0.5260080960892932},
{-0.12673690032806503,0.2519912799022413,-0.5436864000999695},
{-0.14173052606957573,0.2325603051313281,-0.5628259973621824},
{-0.15572125245468027,0.21448368506236679,-0.5795262341890153},
{-0.1655457811140113,0.20430549820347244,-0.6025708908461803},
{-0.17664936691978125,0.19109798655137597,-0.6192050420524832},
{-0.1710038525914174,0.17928468123300548,-0.6094970643966322},
{-0.15704797135168325,0.1698652774534687,-0.6018351376042801},
{-0.16781231763873275,0.16857740889095912,-0.6245525703100937},
{-0.15548694889098316,0.1736694060825205,-0.6393233072769079},
{-0.13558556465757032,0.17894944690340805,-0.6447156936526964},
{-0.14541630136004208,0.17235990949874658,-0.6842016516598906},
{-0.12504130351283121,0.1640327207930595,-0.6965959096605562},
{-0.08238704064986595,0.15408703516275685,-0.7079508210837961},
{-0.07455889850890814,0.15148426301115725,-0.7249584561758213},
{-0.08750026534377939,0.15367810535329574,-0.7557143034515518},
{-0.07896801095499327,0.1538034677728465,-0.7759721495169141},
{-0.06212639095211757,0.15874627166957508,-0.8083270685500132},
{-0.08775119044233709,0.16404073117130555,-0.8127039392236581},
{-0.11931588566146298,0.1751841686088496,-0.8182531287536131},
{-0.08427468628354896,0.17064648959191528,-0.8330797381086936},
{-0.05310930841998893,0.17220570971750998,-0.8628068525581745},
{-0.07670027287353494,0.18136157205275152,-0.8776805228854502},
{-0.0924138313599099,0.19013734194021772,-0.8987780568504554},
{-0.17386395814417158,-0.35472197779443043,0.43540230722924617},
{-0.16056632973680698,-0.35940464465761834,0.41413275039140707},
{-0.15139905261256484,-0.40593913474297294,0.4262856957474103},
{-0.17275772490839128,-0.4124719987215436,0.43931898167265504},
{-0.17809904512286118,-0.4409296684784807,0.4420298939305764},
{-0.1706475910189241,-0.4464089674582389,0.4518704433463996},
{-0.17592623002361857,-0.42808562773929903,0.46024529380265067},
{-0.17661071684474405,-0.4222843115540494,0.4611078112802947},
{-0.17719567471616227,-0.4217792572056355,0.4616475105146227},
{-0.17061354691137837,-0.426450709539279,0.4662096211852075},
{-0.1767380818588563,-0.42056107893386674,0.4622146452944434},
{-0.17842626907421252,-0.4131460720509492,0.46456869520150296},
{-0.17762282813613317,-0.4775567224896575,0.44038215912536277},
{-0.17843107530116015,-0.5026952920203415,0.4140714709978247},
{-0.15785121203030647,-0.48739627060819996,0.4192211429127577},
{-0.1401797168411394,-0.4791666082576586,0.42423764228935007},
{-0.1134795240713869,-0.46539476545812747,0.42917363736456954},
{-0.09451435279548182,-0.45483688667037014,0.4280343613185242},
{-0.08029693270601392,-0.45746409047562014,0.4813582477457794},
{-0.16058535438514138,-0.6516450713544468,-0.25573312784043006},
{-0.17296098825638495,-0.6389616386990984,-0.2806367930290484},
{-0.16855528022105437,-0.6421455637924494,-0.301683461092191},
{-0.15341566533600934,-0.6592319008507422,-0.3092911175719262},
{-0.14510910335430582,-0.6721778736531049,-0.31924160942917645},
{-0.17872185203149196,0.40493623538656687,-0.6001048959031321},
{-0.17174341076298452,0.3955719029574717,-0.5828493396043914},
{-0.15057378339376495,0.39006156376201007,-0.5310466240060622},
{-0.1493273685386787,0.38234076068954936,-0.5363729247613208},
{-0.12668583416674642,0.3723486148654196,-0.4992133808562373},
{-0.14699054094484815,0.3603478666960914,-0.5622312267774128},
{-0.1540386725040963,0.3617410717325366,-0.5928971575573312},
{-0.15752398807895507,0.3673425289805472,-0.6322745749392913},
{-0.13848952703122167,0.36976526788106673,-0.6481393293150606},
{-0.13203696709456772,0.3764655487649799,-0.6790573867502736},
{-0.1376163958024016,0.3684970247452599,-0.6978611489045207},
{-0.15330031588926613,0.35891040431983673,-0.7092699301214653},
{-0.16068107840518175,0.3508091082806884,-0.7236964210831552},
{-0.1669946582792666,0.36143687761864274,-0.7165994262166062},
{-0.1724981886532191,0.37169897318966444,-0.7278904548733338},
{-0.1710150671209619,0.3744395238470963,-0.736048424338573},
{-0.16709939397483378,0.3892819536992127,-0.7464979627605526},
{-0.1758969921430205,0.39812240739101573,-0.764054909540801},
{-0.16926519999311107,0.3910408325025903,-0.7732151775840779},
{-0.16636884747879352,0.3968189185909264,-0.7777270231311687},
{-0.16920992838321325,0.41003444062126887,-0.7803259903531014},
{-0.15720938047334124,0.40235268814275776,-0.779916860284184},
{-0.1490686333213311,0.41637946122996955,-0.7892529561299619},
{-0.16017642457568024,0.4158175331960086,-0.7986913845578331},
{-0.1582465241967493,0.42200074416413896,-0.8035642979043647},
{-0.15505318690895925,0.43637576844559817,-0.8060467141228175},
{-0.1432857410060474,0.4323010892912858,-0.7994565759397875},
{-0.1382263861058387,0.4420951785132818,-0.8133826185205552},
{-0.1369601455645935,0.4536006850475475,-0.82477838287285},
{-0.12077757943191199,0.45936034726591773,-0.830453135081812},
{-0.10680127172765033,0.458344831563774,-0.835982498925608},
{-0.10650368617580938,0.46347748142493406,-0.8406046874330382},
{-0.10034450634241723,0.4792827587422265,-0.8442674328860471},
{-0.1165659228095921,0.5053321082794868,-0.8508699871553584},
{-0.08370634994699132,0.5201983690068853,-0.8717039796760684},
{-0.09397164966931155,0.5306284822616181,-0.8666784686239491},
{-0.164221265071026,0.5216087963565594,-0.8445686231080988},
{-0.14710168494301215,0.5318718932248621,-0.846775282055431},
{-0.15221751300985556,0.5336742283302247,-0.8402428185957728},
{-0.1370977238109695,0.5373531947991818,-0.831516713053432},
{-0.11909640129752107,0.5347185813940541,-0.8210902044689099},
{-0.0998140190430722,0.5248624117406511,-0.8041889071481009},
{-0.10481810233338312,0.5195533332986217,-0.7926054996853923},
{-0.12660452882754897,0.5104982014698243,-0.786608730270939},
{-0.13044870934783104,0.5027950212295048,-0.7708599261202813},
{-0.12358061103966297,0.49701673488171266,-0.7502139772288977},
{-0.11679461910851699,0.49099693562980196,-0.7290928126480668},
{-0.09502901959779089,0.49032426411658947,-0.7148657801047036},
{-0.10102498797441965,0.4715499401023967,-0.6984148663007792},
{-0.13615370073467184,0.46807543853817,-0.7178001819156898},
{-0.1498860924213411,0.46624366529275335,-0.7178139998181644},
{-0.16617619788197588,0.46540938439842655,-0.7158474519587578},
{-0.16794268654468728,0.4529091891454569,-0.6979166207738746},
{-0.13912434950722155,0.45716750622105995,-0.6972463523741358},
{-0.1393454359468127,0.4414060857246648,-0.6667886914286149},
{-0.16385539104463742,0.42145243377319647,-0.6221330355608726},
{-0.16932667964614953,0.4088138592360261,-0.5891470989814402},
{-0.1519117168203124,0.40069393906745565,-0.542500463600641},
{-0.1263670211125534,0.4008197020059189,-0.47986491298125844},
{-0.11691898023078699,0.3939389873520132,-0.4552253900153038},
{-0.10431885550919771,0.382873450842912,-0.4460256708591651},
{-0.08262234551084384,0.3842137873829333,-0.39822614178930216},
{-0.08407783123815216,0.3708302476688798,-0.4042231114632117},
{-0.10933495436687772,0.3594839474022543,-0.4650357002532481},
{-0.12529763561670498,0.3548052857281894,-0.5083874668019887},
{-0.13605517308224535,0.3531709683065379,-0.5448807474964564},
{-0.14120424421880987,0.3551769672788064,-0.5818969056309354},
{-0.13135988987331987,0.3572182119153575,-0.6005260415394185},
{-0.0892242990017867,0.37575823236585315,-0.6401103269395828},
{-0.11271793735964315,0.3786898305444534,-0.6594784202412646},
{-0.11504895742924533,0.3844366761576298,-0.6826542468422087},
{-0.12307555669124917,0.37942378145124817,-0.7029431331232745},
{-0.13836456513058318,0.3642697478853602,-0.710221763316553},
{-0.1539225220195285,0.3492404759606546,-0.7265475149603826},
{-0.1594280549880425,0.3477120957913072,-0.731574628088151},
{-0.16661917179898275,0.35365619696879275,-0.7304443637176324},
{-0.16530587028554192,0.359486150256272,-0.737268004426535},
{-0.1577002164003683,0.3783077355021165,-0.7425953064790742},
{-0.14769044774409723,0.38924730881329844,-0.7530622674737389},
{-0.15930789931435166,0.3864524878432497,-0.7647265797567327},
{-0.1699324645010075,0.3902317842997387,-0.7603877583797568},
{-0.15710424425886177,0.38960737531545864,-0.7734086282187201},
{-0.16864399516012943,0.2836597095196537,-0.842301686064465},
{-0.16645716189895626,0.2733749846300867,-0.8237420401872666},
{-0.15771463508121122,0.25509750432660555,-0.805300146870285},
{-0.1670082759222849,0.2543379202094233,-0.7892515543137689},
{-0.17351991239850348,-0.32162429643846563,0.42699040877360706},
{-0.16898523727341144,-0.328975620814327,0.40950295202464304},
{-0.16493458925383728,-0.3401284704463102,0.41222047284461744},
{-0.16918249283772055,-0.33753671256479895,0.4229587854023673},
{-0.16878657989290924,-0.34270981483610163,0.4292473328444332},
{-0.16942340496347064,-0.3402071724125777,0.4298853594717315},
{-0.16910979865513756,-0.3381471033871484,0.4338885460001978},
{-0.17326698470538426,-0.34269719849036406,0.43908648044406323},
{-0.16706995583477954,-0.34129898696751504,0.4313756903444102},
{-0.1666387972256856,-0.3441012175374415,0.42622842154295104},
{-0.15619706892249596,-0.34684737545964545,0.3963795493441302},
{-0.1438448654076221,-0.3624317665968028,0.39097274428749884},
{-0.13551827748030346,-0.38060451120471683,0.40083412068676166},
{-0.13437399494785443,-0.39173513203706717,0.4083662793515278},
{-0.13803553884412645,-0.40334957971547936,0.41577307559674315},
{-0.12592104330370427,-0.42652360398131817,0.4110781929067299},
{-0.14837293197066118,-0.44107665891929576,0.42221261866874715},
{-0.15957905061798064,-0.4245618623488591,0.4316166024701603},
{-0.15738480775692987,-0.46755736732510633,0.4166405995607909},
{-0.17039987007166485,-0.4638447572675158,0.4445355402459426},
{-0.15751918185200744,-0.4527591948127994,0.4538462031407891},
{-0.1585875660505751,-0.45062002330219025,0.45509361929315617},
{-0.15894442840143688,-0.4477316811661187,0.4577624770652857},
{-0.16252246410449375,-0.4418776967439014,0.46004603564378005},
{-0.17622061142416115,-0.4184126954882746,0.4634302201932824},
{-0.1753679066598685,-0.420390858396138,0.4701617415523552},
{-0.15870031212438834,-0.4460831453230806,0.4584790053993954},
{-0.15902293010824822,-0.45263623550672244,0.4557166264612431},
{-0.17207103523324818,-0.46101909634121957,-0.12533518426473336},
{-0.17399212419610846,-0.4307422696846034,-0.1209422928345965},
{-0.17378445514007948,-0.4171434510551871,-0.11550985456757777},
{-0.1474529400291017,-0.3687605661895551,-0.11026686174607823},
{-0.13980983762562776,-0.35322764173262877,-0.0969772437169597},
{-0.1434259226253534,-0.3729299680666271,-0.0878207806033497},
{-0.13052080275204553,-0.3571671457540389,-0.0746583273288873},
{-0.10823893436336117,-0.346772678682501,-0.06217655594588349},
{-0.1113924200193771,-0.38329219336572457,-0.058816202271663176},
{-0.10986864581752118,-0.4262434410021623,-0.05121415305670027},
{-0.09637616495932129,-0.4620364143784687,-0.04368359646758341},
{-0.08638602172975306,-0.49899930349761146,-0.042574960118329314},
{-0.10030044926206393,-0.5131013741403362,-0.049797517663885335},
{-0.11535775751063077,-0.5007920261490787,-0.04330370427926422},
{-0.14129916720102564,-0.5233923070730438,-0.03347757354428398},
{-0.14117300374365027,-0.5457188333204499,-0.035142730922182785},
{-0.12092837480239396,-0.55874871483494,-0.050109722156025355},
{-0.10678024448475444,-0.5844207755568114,-0.07802769267863445},
{-0.12199675900096164,-0.6162540187066362,-0.07043125072844378},
{-0.1330274503646925,-0.6448220314239128,-0.06795884748279872},
{-0.14674722570562418,-0.6766022058178576,-0.07692466359415259},
{-0.13665735326689257,-0.6662574030914453,-0.08176092946020865},
{-0.13661129359197777,-0.6803440537560462,-0.10177906495655771},
{-0.13292131285293224,-0.6839671478367372,-0.1234479391499627},
{-0.13044750779109412,-0.6828000357262869,-0.16254939900134613},
{-0.1385033449336961,-0.6891660835778836,-0.175615927996312},
{-0.13875527132953455,-0.6796387399514812,-0.19047177523199055},
{-0.1433039646165572,-0.6683376983219459,-0.211706086405547},
{-0.13686301972836004,-0.6639872618965131,-0.2273433460391283},
{-0.1778689470077432,-0.494532916847067,0.4149498089725048},
{-0.17236822026617687,-0.6350960304170082,0.09529286143127033},
{-0.17152532821523564,-0.6157649851147147,0.11034576397180186},
{-0.1648993435895546,-0.6029451757697272,0.12259383256947698},
{-0.1518049785301837,-0.5959050545887251,0.1283733204740061},
{-0.14413704395414698,-0.5912666450653467,0.1299944207715516},
{-0.1461394382562047,-0.5857266674703746,0.13526124446833315},
{-0.13689646305753733,-0.5866542692712678,0.14867502336026553},
{-0.17468562269276072,-0.6496040269773519,0.09522076802705584},
{-0.1777545988582808,-0.6647049917873598,0.10294817966156951},
{-0.16798393999265449,-0.6734733520749483,0.09211153971084936},
{-0.1637166112415245,-0.6658080208718415,0.08556425705143582},
{-0.16530627080445423,-0.6527424931741563,0.08995354381136197},
{-0.1777285651289811,-0.6682457792315724,0.10880216408378693},
{-0.16711201032057132,-0.6787439807013966,0.09918089877244957},
{-0.15661160599672935,-0.6789720762219532,0.09563029861488542},
{-0.15930970164945704,-0.6654251247916801,0.0848273022527987},
{-0.15759668226153803,-0.6583265278494816,0.09159006408703113},
{-0.1635077406287586,-0.6401335570364963,0.09567996296001098},
{-0.16519312421172871,-0.6287391945003947,0.10288289507886417},
{-0.16076678945241454,-0.6266625039401048,0.11241083948363499},
{-0.1583182170820515,-0.6181793131180757,0.12740266289004032},
{-0.14807314356480253,-0.5995786140523662,0.136364273552815},
{-0.13718283407983384,-0.6006890527367256,0.13929286783957293},
{-0.12880217609935432,-0.5996931624612848,0.1391949409655149},
{-0.1095414218661698,-0.5900284408479626,0.14471128794466107},
{-0.11551856585392033,-0.5786458936197737,0.15729238801791598},
{-0.13065477632821082,-0.5833549947311736,0.16110833195488072},
{-0.11439010381850725,-0.5714659913383778,0.1753257520443486},
{-0.10459961926672195,-0.5695298829163064,0.18534473263560264},
{-0.09633431073298566,-0.5727606687223967,0.19916583926134696},
{-0.0858585383222503,-0.5704921296031138,0.21086739980318497},
{-0.10784001752670759,-0.5702732460175403,0.22387425148021775},
{-0.13421038297217874,-0.5638851696257671,0.24978902666294445},
{-0.14582683324515242,-0.5768491657791834,0.29334285500294177},
{-0.1671813000923997,-0.6484333101966908,0.3743590195457234},
{-0.16215659007810518,-0.676080329675127,0.11474946941257091},
{-0.1520084421376335,-0.6797739150843833,0.10591121857478547},
{-0.15174950666082976,-0.6732450562949356,0.09633681397618753},
{-0.15663303375853754,-0.6532191106797967,0.10096000378089852},
{-0.1574522951936529,-0.6381664083987213,0.10615873926258859},
{-0.15988664914262918,-0.6346228173221224,0.11579081858455813},
{-0.15385643639899854,-0.6377939258102797,0.13543306708171104},
{-0.14794097232374262,-0.6277064564850219,0.14213535056018575},
{-0.14003793314618418,-0.6120489706463694,0.1420864872528848},
{-0.11574786293121368,-0.6183729640121741,0.1406402134605595},
{-0.10730592555715184,-0.6089301298762677,0.13841332830815603},
{-0.08891609969876972,-0.6136760787275994,0.1293950442192905},
{-0.09043146300346729,-0.5869869002279352,0.14753654835204488},
{-0.09484958712507925,-0.5782111303404691,0.15566287682321214},
{-0.10214263599920055,-0.5727108041178149,0.16509509720794258},
{-0.1513908419748626,0.2591521575353027,-0.916865490930049},
{-0.15225656360380507,0.2714230557109791,-0.9111821275644725},
{-0.16552635594676463,0.276469393746538,-0.8949943546859311},
{-0.16881281388166508,0.29231632503070976,-0.890195136819263},
{-0.16763869269024947,0.3064274073489613,-0.8949204589466111},
{-0.1564107457622095,0.3001266440800701,-0.8646352213928364},
{-0.16021667672636666,0.28326579916940386,-0.8423761825821534},
{-0.1541840608692622,-0.268605405162929,0.7144007776475201},
{-0.13809321356749804,-0.24118027316190854,0.7219769933926394},
{-0.13221219411870017,-0.2210483902944655,0.733996766210302},
{-0.11355822603765438,-0.1998132780830844,0.7318982473692915},
{-0.10724244330955184,-0.18129228228092314,0.7416520844406012},
{-0.11200261058227039,-0.17547214170679531,0.7599403787547144},
{-0.09713514829813506,-0.15467239355308735,0.7769778525057063},
{-0.0869906050278741,-0.15207703100136535,0.8078997148705862},
{-0.096386378191585,-0.18342624704567234,0.8403914111122368},
{-0.0891365853599924,-0.19521492045093622,0.8535484573813831},
{-0.10316816467415182,-0.22346351933565123,0.8614374783970112},
{-0.10300134854717773,-0.25654858434587846,0.8739136425152425},
{-0.10079048415126637,-0.29232954215481577,0.8792341357462728},
{-0.13154833402155833,-0.34170271003111624,0.8784353007756849},
{-0.11998715535848245,-0.3864831275400409,0.8727517371506524},
{-0.12552733321291062,-0.42685082793266954,0.8634799245902992},
{-0.12194168765052,-0.48334301921569583,0.8428614112444083},
{-0.14813682607185868,-0.5203101137834177,0.8308234148162359},
{-0.10068775105026072,-0.5635433267341168,0.8027712704580053},
{-0.09852875385349258,-0.5972479945016762,0.7836887471407955},
{-0.1083014153136804,-0.622048926589289,0.7673788159940018},
{-0.10927687912459381,-0.6476927507278429,0.7429908189049732},
{-0.12534189295651446,-0.6581797376681229,0.7340898868574124},
{-0.12052505225770507,-0.6834212405592685,0.7079696454726743},
{-0.170644787386538,-0.31174329461249994,0.4410312000227494},
{-0.1700329947479955,-0.31957784505605463,0.43423118992967286},
{-0.16761526233387974,-0.3208605068727043,0.43018434683976553},
{-0.16511221939144355,-0.32753355247058086,0.4204817761892307},
{-0.16832317951137493,-0.32098987448137806,0.41393128937851875},
{-0.15846640907960352,-0.3380678006425124,0.3927770819874229},
{-0.13950223910097923,-0.3118618482105415,0.6923646276115334},
{-0.10855254067169424,-0.2773194951379006,0.6993322548694088},
{-0.10128812889980257,-0.22153562155128184,0.7143605254968336},
{-0.16812392135250429,-0.49001165910553707,0.41505414414915964},
{-0.1454551516945354,-0.4749881947050598,0.4148290525204454},
{-0.12236783977321017,-0.46634880150723274,0.40906338251839075},
{-0.11313647962299955,-0.4649527928384014,0.4129203796438665},
{-0.08826525646627771,-0.45098990251770193,0.4031833643668737},
{-0.0671102480373572,-0.4379824500623007,0.3950874753330415},
{-0.06281207932997993,-0.43789914212854164,0.422291721153927},
{-0.07754616881631841,-0.44947614128865354,0.4422387645433423},
{-0.040355184176619235,-0.45171283915440846,0.49612057381543523},
{-0.04827164073773982,-0.4509454449184363,0.5267690820226685},
{-0.06680465210727017,-0.4446651081140725,0.5732012395259297},
{-0.06771823574623281,-0.4356730580139629,0.594254115632213},
{-0.07049943907326331,-0.42229893049434847,0.623615155795849},
{-0.07546186839669475,-0.4116146879897594,0.6305257091087212},
{-0.07950730967040898,-0.40137301888326515,0.6395554079865874},
{-0.08449016545836785,-0.38674646872487994,0.6547372776168804},
{-0.1191947286904914,-0.3947119888527576,0.6478095019907791},
{-0.10624795485030405,-0.3750499146694457,0.6626743609019846},
{-0.1218746007327093,-0.3471764017461022,0.6774801432736253},
{-0.07685226980075385,-0.3182761585910706,0.6828509016281494},
{-0.07860614211772772,-0.273610890269433,0.6962634789633448},
{-0.07595150276698491,-0.24493874263495782,0.7026709805223647},
{-0.05808335279187716,-0.21842018519193465,0.7081418686049645},
{-0.07426631944347095,-0.19932844993974191,0.7120449254053551},
{-0.07824487405883063,-0.17827537357400244,0.7214086570560818},
{-0.1634188254302274,-0.6914842870422919,0.5318742963383359},
{-0.1392917664125641,-0.6843073886527384,0.5206383390320499},
{-0.13865313900689732,-0.6910248918498807,0.4862039258062746},
{-0.16951191964308956,0.33290350978728034,-0.9764593006699479},
{-0.1748113856312238,0.32560405261056224,-0.9775663349435527},
{-0.17018579271303902,0.32883163426535417,-0.951126279207341},
{-0.1568557222737779,0.33489769345163595,-0.969636661258326},
{-0.16168497905886864,0.33006182810449214,-0.9399223634140393},
{-0.1665847271725247,0.32369077376649186,-0.9235135040959065},
{-0.17321191335494263,0.3161696293718141,-0.9271339948036675},
{-0.17426868250505356,0.3141239790272276,-0.9437651421181281},
{-0.1717772546110741,0.31793031051029713,-0.9864075896731807},
{-0.17104470552047232,0.32245877759224845,-0.9955061778039629},
{-0.1691913042537912,0.33036502092110537,-0.9943092270345457},
{-0.1565677491758322,0.33456105730584546,-0.9887714522935915},
{-0.14436453869633495,0.33269644150961986,-0.9795008412899752},
{-0.13257366243705343,0.3296074393984847,-0.950643653918016},
{-0.14539747697116384,0.32647017475841694,-0.924028771676584},
{-0.16233041528604458,0.3149540544729752,-0.8974595485911546},
{-0.1698197184271943,0.2996382112665169,-0.9050922375029087},
{-0.17151070927493658,0.3084093751864916,-0.9439337605802077},
{-0.1602453138285963,0.31162393997663373,-0.9732795810251763},
{-0.15954740962390873,0.31443237858970086,-0.9905755897340592},
{-0.16318472212598642,0.3222797456384492,-1.0},
{-0.15847241686328806,0.3301615573136556,-0.9973645855570475},
{-0.14097074169293736,0.32427152618933086,-0.9864708716613244},
{-0.13075790994812878,0.32712902836915503,-0.9689183305891111},
{-0.11192991639968744,0.31809952975074507,-0.9393061650674612},
{-0.11307259685648727,0.31827635885052674,-0.9174204098830443},
{-0.13004899147335286,0.3240091863017725,-0.9201427369299665},
{-0.1274039645765053,0.31738220037881076,-0.8991837825086183},
{-0.13527816639237797,0.29406859527203444,-0.8441765150929543},
{-0.14972228018620926,0.30159114148290517,-0.8612230005194728},
{-0.16701808863563633,-0.24635918295743964,0.42749506260310854},
{-0.16175967583601314,-0.21566781922658995,0.4198675804372144},
{-0.14091667163977648,-0.19243191478880034,0.408336040173649},
{-0.1235615863913286,-0.16228205262738404,0.39948437195230135},
{-0.12087690812216306,-0.14201519488649494,0.3950858732573922},
{-0.11033525035035391,-0.10293716539148119,0.4060789158433666},
{-0.11561569169015376,-0.08436290057398364,0.3997296897860868},
{-0.10598321184927191,-0.03792273269247636,0.4015326256698178},
{-0.09951723452905584,-0.014093459486110202,0.4048188833452621},
{-0.1015945258677142,-0.009128226530292648,0.4088010426308325},
{-0.11201642848474483,-0.01114523977264944,0.40901532024891446},
{-0.10843859304114409,-0.00886588664273432,0.41650121897930953},
{-0.10762433809243253,-0.01359080825117021,0.42579085463126015},
{-0.10023376286316552,-0.0225812562756307,0.4281919655105154},
{-0.12919448437395487,-0.1929523891153378,0.42586595192731697},
{-0.12374762742609323,-0.17603967700552836,0.4112792534007059},
{-0.11611173436304074,-0.16147500701909392,0.4191093981362253},
{-0.1131993610922311,-0.1356841924397249,0.4055930864027434},
{-0.1077316771609297,-0.12096311981803624,0.41756259409691193},
{-0.10467071137365572,-0.07857099658317315,0.41598294750678977},
{-0.10015646271309107,-0.03581380035974609,0.4056163164996569},
{-0.09176018449503177,-0.019188260310057718,0.4128144423915625},
{-0.09375857360796648,-0.011440822729928898,0.4103700754697786},
{-0.0959694380038778,-0.011461249194456326,0.41978487328182384},
{-0.16098627381635647,-0.23380631946750205,-0.6071706502945216},
{-0.15057698754506338,-0.20125054019988292,-0.6254102815607901},
{-0.14357691825529156,-0.1742976199964674,-0.582876574890428},
{-0.15396217339184648,-0.19872306560379627,-0.5500438367949515},
{-0.15771283274610584,-0.2217248667373449,-0.5411258826936178},
{-0.1563472635146095,-0.22437610167733316,-0.5127785558970201},
{-0.14496531706478913,-0.22741864359464117,-0.4776961030711389},
{-0.14288842624504305,-0.2533087868642613,-0.4519026851188399},
{-0.13548923985916153,-0.27376168563991504,-0.4296448478648937},
{-0.13929477030440637,-0.30831985920959193,-0.39498814664279036},
{-0.1406665475790434,-0.336561849532254,-0.3505325499717433},
{-0.1369427229919083,-0.3463222951656165,-0.3275505745243537},
{-0.14637554415500723,-0.3683123855266883,-0.29735965917442636},
{-0.13828926757507026,-0.3783081360210288,-0.24076213141746444},
{-0.15322241496082323,-0.40393633992200284,-0.2538262572989565},
{-0.16331889596160784,-0.431425755208448,-0.13173267285094567},
{-0.15554902932239006,-0.4026773087211792,-0.12873558983018396},
{-0.15364616397003958,-0.38477891956819255,-0.1201212290643758},
{-0.13441584917419006,-0.3502792217597119,-0.1103926246845413},
{-0.12974599891619581,-0.33268222308823303,-0.09498346057151646},
{-0.11931929007221756,-0.313280486197918,-0.07506064857629545},
{-0.158156207182025,-0.4788882476136081,-0.1356503485916353},
{-0.1494411159097727,-0.49694704459097205,-0.1459941500207669},
{-0.14411261230049652,-0.47281397778962414,-0.15396507715396068},
{-0.15450207288563061,-0.45564493357594094,-0.14121515835917015},
{-0.14293608799560711,-0.43006759557682933,-0.14828391664240187},
{-0.12717747113159808,-0.3851990639071981,-0.1427737777063964},
{-0.1296044154806968,-0.37408606590698906,-0.13081708661742153},
{-0.12599273618900647,-0.3511465454643035,-0.11626783660911076},
{-0.11204446480860603,-0.32991363610694013,-0.10430293488243368},
{-0.11693319865217376,-0.3129426484953906,-0.08626336281286034},
{-0.11182137577445338,-0.2992066521385106,-0.07058424895294343},
{-0.10260323274834876,-0.2975216690744528,-0.05688950604403065},
{-0.11385240717874076,-0.31881665886322313,-0.06572595454671072},
{-0.097723710839764,-0.31238412487218437,-0.054679843204856214},
{-0.0920417492903806,-0.3044596579328177,-0.04771121464970016},
{-0.09891425330658402,-0.34871739826118714,-0.05229775697393543},
{-0.10374471164841167,-0.379135207574934,-0.052584328255688075},
{-0.09888181127468748,-0.42682899965194904,-0.04140464385658059},
{-0.08003098814824487,-0.4675671800384578,-0.027809029378462743},
{-0.06955060977001805,-0.513820706106832,-0.03705781210135853},
{-0.08811005538776037,-0.5341474414251103,-0.05576204530589833},
{-0.1108811576278226,-0.5348563598998862,-0.05220924229431652},
{-0.1287775441862477,-0.5177620124633474,-0.0391647418395273},
{-0.08173860053084776,-0.5719279899037192,-0.07226302397386053},
{-0.09500518872250889,-0.5852550564511381,-0.08552019997108254},
{-0.10303819628710957,-0.6182548109330448,-0.11008923160847194},
{-0.11814276576732814,-0.6270468018364593,-0.08967077745927625},
{-0.12926016947557253,-0.460600353818407,0.4066887058873476},
{-0.1092172018066607,-0.4508246884663771,0.39709227274857306},
{-0.08862091726040258,-0.44678685705199656,0.38981704696604913},
{-0.07230537884883656,-0.43502862308406764,0.37981368661237497},
{-0.061780743130800266,-0.42852980321304274,0.38771131878461734},
{-0.054496105153837314,-0.42089411040944646,0.39747096338015525},
{-0.049697287806081555,-0.42525435954823065,0.4204599479085102},
{-0.03590782217440917,-0.43351105692535247,0.4498504262122005},
{-0.042272067690900327,-0.4481245902190878,0.47262252974954344},
{-0.018264964087471733,-0.44938462271719226,0.5032335894384764},
{-0.02915106812386128,-0.4496053086378712,0.5413465686142966},
{-0.04610543420055023,-0.4471531315972974,0.5778782991243454},
{-0.06114191546567733,-0.4344618888231592,0.603441018183158},
{-0.06222091341542102,-0.43360017238333987,0.6136979070083199},
{-0.06389187831754822,-0.4425079132524098,0.62153425978698},
{-0.0662459282246078,-0.4351742117086898,0.6368759364632818},
{-0.06975086922616944,-0.4108418867484713,0.6432165513639471},
{-0.07458072678962864,-0.3941526641917268,0.6508854872372645},
{-0.07457091407627721,-0.37324117126148637,0.6667762753423335},
{-0.16349612558030183,0.3025698094451171,-0.946693736404886},
{-0.14805151554353818,0.28962283534547356,-0.9356498279170493},
{-0.13338611505065961,0.30475784426302716,-0.9632926419469064},
{-0.15211057446027074,0.318816458603767,-0.9934437056650595},
{-0.1348161678270367,0.31459458874918345,-0.9771057381944045},
{-0.12093618492118387,0.3189185909264042,-0.9616360957256221},
{-0.10395698667193216,0.3048283355915924,-0.9326295147993741},
{-0.09489444524325716,0.3022105439807815,-0.9079925952063493},
{-0.10178997909691795,0.3092186236487994,-0.899259080064131},
{-0.11012017169444731,0.31032385558729886,-0.8892559199699129},
{-0.162528071369266,0.2855787958879524,-0.904177252047753},
{-0.159493539830204,0.28844490922439114,-0.9215886102033792},
{-0.126732895138942,0.2763790767318137,-0.9207541290495966},
{-0.12757218251967248,0.2897744317537802,-0.938447052000572},
{-0.1083953369986154,0.2838629728676473,-0.9270849312369105},
{-0.1167810014654987,0.3043701419559181,-0.9529848872198821},
{-0.15276141769276275,0.23662076586425368,-0.9359996811869458},
{-0.12519029654820785,0.22234627182978262,-0.9490311647770852},
{-0.12084646868482804,0.2311178362686697,-0.9469861152108673},
{-0.1480074584631849,0.24771153506482996,-0.9303555686747751},
{-0.12657809457933697,0.24774217476162114,-0.9328616155090534},
{-0.12273131068612494,0.2550872910943418,-0.9224276973246538},
{-0.11732791004024813,0.2681470112677985,-0.9161435555906231},
{-0.1612556227848801,0.19716624859167534,-0.5737223146308357},
{-0.16057474063396535,0.17745230720922026,-0.5707298375775655},
{-0.16697002636615998,0.17812557950080124,-0.5909392208545391},
{-0.1601894414403301,0.16907745675296915,-0.5858920817811556},
{-0.14699634846907653,0.16884315318927198,-0.575554888914077},
{-0.13133065199272176,0.18206508352221137,-0.5772470813185563},
{-0.1631242437702287,-0.3123308558568481,-0.6960514041992805},
{-0.14845824249898165,-0.3441392668341102,-0.7281045322319597},
{-0.1514020565044071,-0.3122743826902134,-0.7192492593404014},
{-0.15984980140269733,-0.2869714001460292,-0.6925700938135447},
{-0.16238548663648622,-0.2752267838211186,-0.6799413319897258},
{-0.15624272807849848,-0.24880535221432884,-0.6664112023537695},
{-0.1490794473319633,-0.2090160011310654,-0.6558194797179225},
{-0.1382972779533163,-0.1741159846697381,-0.6375998743972691},
{-0.1347132344665749,-0.1415003278247297,-0.5834767524805137},
{-0.14303461564803358,-0.16315738671022173,-0.5577632380512191},
{-0.14823675554047824,-0.1858575971028064,-0.5284120106009346},
{-0.1674985110709435,-0.317717234448952,0.4359067607992915},
{-0.16824627988021282,-0.3204055173883283,0.43500218883585573},
{-0.1650431298790713,-0.3278405502168609,0.42309816598384864},
{-0.16695380535021173,-0.32176187468484163,0.431823871007277},
{-0.16585037574681757,-0.3177644956806038,0.430043364182635},
{-0.16501088810663095,-0.3394952500459595,0.4233468882283887},
{-0.1640930990190891,-0.3305218240752719,0.4182885346254607},
{-0.1482768074317085,-0.6627470550845674,-0.28837561945256274},
{-0.12611489445725882,-0.6864659853305942,-0.2918713485191414},
{-0.15389708906859725,-0.6703304801701083,0.3825820733342118},
{-0.15277703793034256,-0.6594573929983686,0.36913785500494434},
{-0.15404387924995622,-0.6663264926038174,0.3125589513774045},
{-0.13550686269130283,-0.6563487654605306,0.323406605598213},
{-0.12505692375041103,-0.6395940580616245,0.3058829018876857},
{-0.12081843236096687,-0.6267229822958624,0.2933344441057834},
{-0.12204562230826256,-0.6175432890853388,0.28991541441091073},
{-0.11820444567982279,-0.6154896283625064,0.275896651701945},
{-0.11338319927297806,-0.6300643113217483,0.26382200779329695},
{-0.10939863687393388,-0.6309112085618127,0.25672801681859014},
{-0.11100551875009261,-0.6234002773993985,0.257016190175992},
{-0.10814040671093468,-0.6231761870679651,0.24924432094221272},
{-0.10745692118709,-0.6187037926337362,0.2489949979193042},
{-0.10706521369085788,-0.6249344650929745,0.2472611515479455},
{-0.10093386992187078,-0.6214125020376399,0.23656449295707516},
{-0.08558858857535824,-0.6251307193600026,0.218572782897522},
{-0.09757411702601891,-0.6349588526895446,0.2125744114074194},
{-0.08321851791180654,-0.6400047902061909,0.18919832535032385},
{-0.08644209437747546,-0.6450343064474332,0.16543734061850532},
{-0.1128643270220898,-0.6366292168133032,0.15990457236395472},
{-0.12425127995831399,-0.6268373304453249,0.1483189620472284},
{-0.13885239716576794,-0.6294266852133623,0.14663377872371441},
{-0.15422671613342245,-0.6544705320212867,0.13014000939617365},
{-0.1601996546725938,-0.6614147289227923,0.13718754017705337},
{-0.15128991120896232,-0.67464246677996,0.11806196107677105},
{-0.14719740896305253,-0.6721045786921536,0.10987114906072304},
{-0.15222952857722466,-0.6662149480867411,0.10577123721493566},
{-0.15442076754643316,-0.6496835299814439,0.12187149671113894},
{-0.1573834059407368,0.28192346003482105,-0.7250796131467929},
{-0.15328409487331787,0.2801671846043734,-0.7224165628988918},
{-0.1463364935610577,0.2704517973486449,-0.7228054667627378},
{-0.13328678636040855,0.25891304774465795,-0.7225140892540375},
{-0.1314780429524492,0.2502864711520245,-0.7260526738442326},
{-0.1300572021110551,0.24655483644609955,-0.7300404403945752},
{-0.10602847048636212,0.2534707967642878,-0.706674167050831},
{-0.11448102161159998,0.24662733036922632,-0.7112681189749439},
{-0.1095336117473799,0.2410330824616373,-0.6975201070506948},
{-0.10716093771089824,0.23681381597998366,-0.6735957106026568},
{-0.1116593658744269,0.23533650197195483,-0.6506381668089175},
{-0.10368923977905774,0.243313236629377,-0.6239453836390427},
{-0.11164274433956634,0.25595721817186345,-0.6015265377823508},
{-0.11297366868514848,0.2712768663079886,-0.5677882264261577},
{-0.11274757575915355,0.2772317814961064,-0.550530066754487},
{-0.10795316411943313,0.28586336457514355,-0.5237307455539396},
{-0.09859564051184715,0.29724891569517464,-0.47420497997205174},
{-0.09203574150669606,0.29851355416077063,-0.4388401613129971},
{-0.10823492917423815,0.2683921288421278,-0.48859982993966977},
{-0.11787521913390987,0.24688085884071398,-0.48276907561436594},
{-0.13510173781150858,0.2306678532706975,-0.5212154867846782},
{-0.14402589995598297,0.22538560959579226,-0.5392586635244623},
{-0.15194395859275275,0.2067566739467654,-0.5476114854405367},
{-0.15140045442875788,0.24750366574934485,-0.7777832960383473},
{-0.15725584066716838,0.24917903635950736,-0.7772728346846173},
{-0.14451413251008005,0.24084463831339883,-0.7484458864905371},
{-0.1398548960032618,0.2503221173352195,-0.7293495452708528},
{-0.14590032846555998,-0.3521888959335715,0.3845422128910216},
{-0.13072646921351302,-0.368830456739752,0.3795865923890993},
{-0.1147141236185602,-0.3808025678068505,0.3745612815964363},
{-0.11284570289266772,-0.39683053363938314,0.3922874476171327},
{-0.10697269382211592,-0.4164247198670597,0.3936393992056108},
{-0.1114805341800837,-0.43866533480777686,0.39940687154277077},
{-0.15831461241184078,-0.38429008623572697,-0.7276455375584606},
{-0.15532513925041283,-0.3658936518152918,-0.727610291894178},
{-0.13645088576760048,-0.3745710943097877,-0.7476174131204387},
{-0.1266880370207641,-0.34876365819555816,-0.7518539019153214},
{-0.13795523480220975,-0.33176022855211207,-0.7423439808616042},
{-0.1391549892040127,-0.30910968250465304,-0.7334818991485368},
{-0.13149826915752047,-0.288479153591393,-0.7301047236799998},
{-0.14848047129861447,-0.2739847746740677,-0.7036929045271052},
{-0.14319982969935846,-0.23379810882979987,-0.6897226046065282},
{-0.13224984289645664,-0.2068081406269963,-0.6867962131737879},
{-0.1288195986720395,-0.17934335725365783,-0.6702423660094017},
{-0.11622307862066092,-0.14599154664783692,-0.6571065472426075},
{-0.11874234257904541,-0.11867515553150661,-0.6161554910542099},
{-0.12579748321925888,-0.11274106732682863,-0.5763469150631558},
{-0.13259949590689699,-0.12416526852189695,-0.5614870626383542},
{-0.1317894464067646,-0.12562796358962672,-0.5371967921639276},
{-0.1400753816644845,-0.16254158888255624,-0.530071560714061},
{-0.14129315941734108,-0.19810226128972694,-0.4923769235421412},
{-0.13186774785411978,-0.1978058772946229,-0.46644072059760616},
{-0.1326966217431304,-0.2268579171174173,-0.44997759096685663},
{-0.12696840025937606,-0.23743462029405296,-0.4384382405845013},
{-0.11038371313874255,-0.2495314930023338,-0.4239134222298409},
{-0.10508364637223985,-0.2735283833734987,-0.40752538989514814},
{-0.12281281628477855,-0.3036189687358942,-0.3860659870928775},
{-0.11986639890642316,-0.32124820917981334,-0.35343571130757007},
{-0.117069775601269,-0.3303371848567003,-0.3217019971074524},
{-0.13081938960116726,-0.34588112358371503,-0.30829102184790613},
{-0.13184531879503084,-0.3532574803915953,-0.290386624911235},
{-0.12470286503193538,-0.3541832798573832,-0.24242047997385413},
{-0.12185157089525187,-0.3636673674412569,-0.2108377614036746},
{-0.1325061750003304,-0.3836124082361107,-0.1945168159867925},
{-0.1390166099198121,-0.40151820698897495,-0.19699742987013974},
{-0.14951781528147867,-0.4319554414699684,-0.2081905316528094},
{-0.15283210928078417,-0.4426408855312943,-0.21790611916799404},
{-0.1508525445567277,-0.4731928686806626,-0.1949197380125691},
{-0.14349601343500637,-0.49109265964984233,-0.16764700345767977},
{-0.1631488756833353,-0.43251937209849073,-0.7200402841921993},
{-0.15167480988368529,-0.40983578324076664,-0.7352848350322677},
{-0.13586612815563845,-0.4019451601494896,-0.7555150452926811},
{-0.16390084994118378,-0.45497947140314987,-0.7184776596558501},
{-0.15323583234438537,-0.4657324029011987,-0.7341846095801721},
{-0.1475714936271433,-0.4325744434489324,-0.7356364906372697},
{-0.13870080075746136,-0.42036923037487367,-0.7476646743520905},
{-0.11484809719472547,-0.4094426739283415,-0.7688753549098212},
{-0.11291078721591694,-0.388165907750081,-0.7689850970917921},
{-0.09996341259736113,-0.36395534053920253,-0.7684522066789733},
{-0.08398671318560326,-0.3475562939344214,-0.7743770829486682},
{-0.09752765683219178,-0.3384156513178474,-0.7717000145388364},
{-0.11797715119709093,-0.32761185391793607,-0.7592086307019373},
{-0.1449286695843134,0.4129416071462187,-0.5602903121283935},
{-0.14698373212333898,0.42567149999539405,-0.5952375898213725},
{-0.14160576442839343,0.42416394680948627,-0.57563018646959},
{-0.130528012092467,0.42518707237096376,-0.5653024057969505},
{-0.12358001026129453,0.4133577462961011,-0.5335797058669212},
{-0.15577031602143737,0.36151117387687487,-0.738951986193312},
{-0.1557833328860872,0.35064129085643353,-0.7343311995020748},
{-0.14365061373515525,0.369879415771073,-0.7367679565645249},
{-0.1295837887567132,0.41099027900547946,-0.7475551324295757},
{-0.14411641723016339,0.4050856289408557,-0.7682014818398717},
{-0.15539382824387274,0.2706238202214789,-0.8243033674428589},
{-0.15078645893619771,0.2541028156079016,-0.8033986833341277},
{-0.14065333045493741,0.2561212306664514,-0.7910074292253042},
{-0.13779662931293785,0.24449817183142478,-0.7609196474952948},
{-0.1328564287891392,0.2435060864856508,-0.7402038080537143},
{-0.11431060081441516,0.2630209699686914,-0.7579532041713243},
{-0.09618651925434593,0.2621774771393818,-0.7018152718662298},
{-0.0979642224466018,0.2574429430770506,-0.6899148536844335},
{-0.1523657050074076,0.1675014148330577,-0.5655477236307359},
{-0.1431982276237093,0.16927991906313816,-0.5587575262510107},
{-0.12962964817217187,0.17476302297256327,-0.5391044637432256},
{-0.11189206736247483,0.1891108119679857,-0.5305213434525772},
{-0.10985622973123979,0.19461834753106125,-0.5641106617733936},
{-0.12351152152729077,0.18609650663399496,-0.6054378052204435},
{-0.11561829506308371,0.18443855859651762,-0.6167218247962059},
{-0.0884066396423206,0.17467470855240047,-0.6375419994144413},
{-0.11016723266664291,0.17534297435757767,-0.6449644158972364},
{-0.13419876792372196,0.1753441759143146,-0.6632493058005952},
{-0.10248928511779862,0.16339108949555045,-0.6822713507620473},
{-0.04121609957861406,0.1524595265626145,-0.7104462541668985},
{-0.04008663624592021,0.14820821856797667,-0.7415042929619614},
{-0.010321071980858403,0.1486417802905444,-0.7613534094773188},
{-0.03228552913154283,0.15255204643135648,-0.8004394493505785},
{-0.028502027226474616,0.16228886144889315,-0.8409419243571972},
{-0.1555101789878967,-0.49768880561655676,-0.7188797806438021},
{-0.1533992440606049,-0.48185409015921027,-0.7312520101042911},
{-0.14290424674207902,-0.504524061373916,-0.7306121811418874},
{-0.13497877850543163,-0.49397959996972074,-0.7437441949790148},
{-0.15880144314974481,-0.5265121491404263,-0.709295963850765},
{-0.14837032859773122,-0.536747810463236,-0.7178470426284294},
{-0.1317568041154119,-0.5364572339923604,-0.7300254209353638},
{-0.10058401665197429,-0.5174572175710851,-0.752625902118785},
{-0.10236952996302008,-0.49503376574690167,-0.7599253592955032},
{-0.11868466785567379,-0.4859910500043857,-0.7575632990101976},
{-0.13255563908599982,-0.45866084098558085,-0.7489659602981623},
{-0.11121198624938469,-0.42839362678285975,-0.7625908126568782},
{-0.09277289656478935,-0.4209125342794124,-0.7732225871839555},
{-0.07314887167814621,-0.4100082066325131,-0.7866521865729238},
{-0.07623106496777224,-0.3891565912796619,-0.7869411609681503},
{-0.056794282672630654,-0.36220587393026404,-0.7872349415903244},
{-0.042741275596663034,-0.3499123464360425,-0.789521504060661},
{-0.05427882364391305,-0.3330390854390949,-0.7889988268801058},
{-0.08992240346593044,-0.3254672754020108,-0.7759651404359488},
{-0.09469999331133415,-0.3123646997049377,-0.7684341833279196},
{-0.10703317217787364,-0.29355613132374303,-0.7509703571947814},
{-0.12358581778552291,-0.27760866979258325,-0.7352632070110033},
{-0.132536013659297,-0.2573330006356235,-0.7219413472094445},
{-0.13007642701884561,-0.23467184083698836,-0.7115825263211015},
{-0.11045080005655326,-0.20980542390721418,-0.7118811131702233},
{-0.10487818017022854,-0.18846958118938897,-0.7100589523787019},
{-0.1133789938243989,-0.17738842444270797,-0.6941136937015597},
{-0.09851313361591278,-0.14695679722648664,-0.683696997830389},
{-0.10264108178556137,-0.13417203328632576,-0.6711359237027492},
{-0.10349679044169625,-0.12222875958091302,-0.6598555087971976},
{-0.1088333044292185,-0.10903606712857176,-0.6330593917479486},
{-0.10456677671591313,-0.08833204299490419,-0.6057986727604284},
{-0.10617225677587881,-0.07088684099118818,-0.5681551017498271},
{-0.11300490916030807,-0.07223418661217472,-0.5392146064441089},
{-0.1219400855748708,-0.10071969243351686,-0.5568574645310465},
{-0.11855489972808769,-0.09225812963275219,-0.5088712936480504},
{-0.12979025625600527,-0.13462101498701717,-0.5106780344614482},
{-0.13439321985564498,-0.16297815449696626,-0.5074370354230942},
{-0.12603218730186827,-0.14977865322311584,-0.4816842701403939},
{-0.11894740826214444,-0.16297354852947477,-0.45455432057774053},
{-0.11747049477302793,-0.20544797840081608,-0.4433327819522973},
{-0.08431974466118303,-0.22197919624665713,-0.4184567525686279},
{-0.05208758467470454,-0.23378088651657083,-0.4031861679992598},
{-0.042356977700308523,-0.2648345196035984,-0.39084577979229884},
{-0.058730991873070744,-0.2811288305128124,-0.3819578646093879},
{-0.09896011272204266,-0.28850759043416646,-0.3912597160881638},
{-0.10449408253333017,-0.2984490706158899,-0.3787443011165265},
{-0.09367426437692675,-0.3096940395977027,-0.34497975577157763},
{-0.08067642437542079,-0.31314471028664737,-0.3132991103273401},
{-0.10712168685749257,-0.33027590546311797,-0.2849682048061468},
{-0.10966658402626442,-0.3377740200203383,-0.25144777573824645},
{-0.10228401917524343,-0.32505894637091814,-0.20886340342547802},
{-0.11189467073540478,-0.3434774093315299,-0.19223926519198273},
{-0.12669604739901016,-0.3717368222268771,-0.19140979052460366},
{-0.12515985711087285,-0.3706271845803423,-0.16693528135051774},
{-0.1296434660746463,-0.39355909516369403,-0.16636654449504779},
{-0.13922648182985875,-0.4234209842271646,-0.16941349212039117},
{-0.14486358526106424,-0.4251031636588363,-0.1905482743442404},
{-0.14382844413221768,-0.4413039534020277,-0.16098797602173376},
{-0.14771007317080007,-0.4686289556749724,-0.18301711697675507},
{-0.15144391073074273,-0.5963726604188385,-0.6746588880553646},
{-0.14806693552166186,-0.621103301437342,-0.6459072374167971},
{-0.13573595950914003,-0.6156095837767411,-0.6692344601665917},
{-0.12189622875397364,-0.6094878524616494,-0.6915936287053506},
{-0.135282171581501,-0.592255326000366,-0.6942208325106007},
{-0.1352096776583742,-0.573271530595039,-0.7040872153962673},
{-0.1367132256551588,-0.5541407447488966,-0.7194106684620594},
{-0.1388481917171888,-0.6573899143730616,-0.6004341224490449},
{-0.11945726883750586,-0.6545782716086962,-0.6365384992796667},
{-0.10656055986135636,-0.6397224243730175,-0.6662742248857619},
{-0.08739673120494913,-0.6327772261742313,-0.6843712714192507},
{-0.09777077181195958,-0.6083071227081805,-0.7070820955630114},
{-0.10555886206168712,-0.5929956852097577,-0.7140717513610634},
{-0.08928017139005294,-0.5813213599539562,-0.7274711115721528},
{-0.13078093978558622,-0.5671996638845287,-0.7121374452740971},
{-0.11894079970009143,-0.557880990611436,-0.7297190239674521},
{-0.11396234962016788,0.4519088931619807,-0.6791469027271733},
{-0.134309911921886,0.43751684682674874,-0.654615119348628},
{-0.14733438643106006,0.4282099888615691,-0.6216574193525131},
{-0.13685601064739475,0.437046437364249,-0.6343668857371609},
{-0.13375359115269744,0.4359858632844713,-0.5945506998867732},
{-0.11799737740216222,0.4314956457586449,-0.5769991601118408},
{-0.10613040254954319,0.42865696796769887,-0.5579524832372822},
{-0.10290782738115503,0.4265662592454783,-0.5343260728599974},
{-0.11747970670801089,0.4161671862064491,-0.5102498797441966},
{-0.12498202671381041,0.4053804108603107,-0.49079006761159755},
{-0.15387045456092913,0.1887803838653359,-0.541749290380617},
{-0.1520689204933912,0.17723142102908526,-0.5435530273021726},
{-0.14620191920652398,0.17003569825065354,-0.5392394386166717},
{-0.1382626330674021,0.16807916336405446,-0.5346791302811923},
{-0.13196627550654627,0.16971147819114443,-0.5165051841165413},
{-0.1099875999344751,0.18189386168720192,-0.48764959882023146},
{-0.09833770633232415,0.19805880498774212,-0.49573026813539617},
{-0.09923486869588238,0.20165786793369486,-0.5293326033208625},
{-0.0976878643971129,0.201372297949223,-0.5490467449627737},
{-0.09471100758142248,0.19548266734381065,-0.5719339976874037},
{-0.10195399159150595,0.19326819827768857,-0.5868216861766103},
{-0.09921043704223192,0.1891536674916021,-0.599521540107363},
{-0.06950094542489249,0.17597659527684067,-0.6168972520797945},
{-0.048433450378310136,0.16537946563567757,-0.6483544079709671},
{-0.07316989892104209,0.16460185816744174,-0.6517127590506259},
{-0.08732864298985765,0.1642085485955604,-0.659320415530361},
{-0.0524194145935474,0.15764324258509324,-0.6752670760236963},
{0.00759393870698877,0.15745379713957403,-0.6869043532801097},
{0.036074237782470965,0.1483934585649167,-0.7240484772070694},
{-0.14275805733908853,-0.6664278238886301,-0.26116656740472954},
{-0.10866188233475291,-0.6957329916639998,-0.2678257951001317},
{-0.1183023725538808,-0.6780186409512163,-0.23554096687668544},
{-0.09616709408709924,-0.6936649122603243,-0.2259982032721594},
{-0.09658904076121022,-0.6993899295927803,-0.26504899748113653},
{-0.10079929556733705,-0.6999438472484951,-0.31790127288915515},
{-0.11154822187626287,-0.6974400032682342,-0.39550721915313475},
{-0.08888105429394322,-0.6991984815526997,-0.4811391639007498},
{-0.09235555585816983,-0.697138012008358,-0.5198413063965673},
{-0.09817469513501692,-0.6877182077099088,-0.5509488092772996},
{-0.10600163571923783,-0.6838712235572407,-0.5732414916766162},
{-0.1386483327799497,-0.6694138926393034,-0.5702456102125913},
{-0.15484231370163182,-0.6846490312849326,0.5865819756075972},
{-0.14692165169193205,-0.6859122679343357,0.6150887089312913},
{-0.11855930543612304,-0.6792844809735492,0.5410632014838423},
{-0.11430018732269527,-0.6800544785824514,0.49996315226006804},
{-0.1050650222428178,-0.6800330508206431,0.4645472674396948},
{-0.12664878616735842,-0.6970661188635996,0.446304632281584},
{-0.0975873341501249,-0.6920352008061644,0.41133652760516526},
{-0.08134709329407179,-0.6967110588478431,0.3855232839667072},
{-0.05406654862039258,-0.702458304979932,0.34955628512300535},
{-0.07047100223048981,-0.704236208431644,0.3489328774360061},
{-0.07961685159292378,-0.6987711278732724,0.3358917813919714},
{-0.11591407827981934,-0.6928092036041896,0.36296385597179703},
{-0.13975556731301073,-0.6952866133362384,0.3960461173496382},
{-0.14713352619654024,0.18567496047879634,-0.5229901860850917},
{-0.1387640827456052,0.17403668192510216,-0.5118050946806683},
{-0.12394648506605158,0.1722872153161636,-0.4951296900263981},
{-0.11614417639493727,0.17167081671012965,-0.4643171693245769},
{-0.10450489654396235,0.17547214170679534,-0.44878865057568584},
{-0.09867934896451844,0.18494040879363302,-0.4505755657029247},
{-0.08450037869063158,0.20081016965580606,-0.45950253147978515},
{-0.08715882297104129,0.20768607808276401,-0.49760249379095556},
{-0.08483861691207129,0.20599268412154786,-0.5348651713159569},
{-0.08336550835262166,0.1986601841345647,-0.5592611787832316},
{-0.06606949964373843,0.1901848034313256,-0.5858235930471518},
{-0.07349031405088433,0.18330649189089385,-0.6026169505210951},
{-0.03355517408354263,0.170710973136796,-0.6173175966782563},
{-0.010029093693789678,0.1633916902739189,-0.6361145500109942},
{0.003854093363361565,0.16074325896631675,-0.6612887657248732},
{-0.13430290284092067,-0.5363619104912323,0.2385773007508528},
{-0.11547651136812855,-0.5325836153320241,0.22315071406514275},
{-0.11755520452297996,-0.49992229933101323,0.2245104757724107},
{-0.10940584621435531,-0.47829187495318926,0.22391830856057107},
{-0.10328912138566726,-0.45480905060596505,0.22932671569285165},
{-0.08670123011373536,-0.42687786295924995,0.2367020712034512},
{-0.1198365602474566,-0.4131148315757895,0.25898093570029324},
{-0.10916393279132443,-0.39177838807959586,0.2798675964579709},
{-0.08225046370077072,-0.39272181037752507,0.2822234487001359},
{-0.1142831652689224,-0.37469765828607543,0.3172193894409597},
{-0.13157096334010343,-0.3623959201541517,0.358312830102681},
{-0.1482467685132858,-0.3523288772934213,0.3667101096180211},
{-0.11870629587693815,-0.3703792633736268,0.36201542718746405},
{-0.09767484753246305,-0.3833877171263088,0.3485738122311266},
{-0.10021674080939263,-0.3922650185580438,0.37112803348017687},
{-0.08924112079610344,-0.40626635869432426,0.3712996558340986},
{-0.07909337337454404,-0.42685843779200333,0.3733785492484062},
{-0.09099539363198961,-0.4392288649173869,0.3854910421942669},
{-0.14244004532272012,-0.49005391385078506,-0.15524833974897878},
{-0.13280215847652216,-0.411241003844581,-0.15408062686016002},
{-0.1074865595866004,-0.3412048650231239,-0.1402657282775564},
{-0.11011997143499118,-0.34617810835718754,-0.12340568440471474},
{-0.09962096892734226,-0.3263648382844813,-0.11699658077004566},
{-0.09730817246824985,-0.30606233436039726,-0.09262240158349157},
{-0.09493389635611899,-0.2916610760901824,-0.07516698634751184},
{-0.1023513063525103,-0.28943038600811205,-0.06641684967043301},
{-0.10060464337595787,-0.289368105317249,-0.058334978798531376},
{-0.1505373361727454,-0.6675769126480268,0.12053035913329307},
{-0.13520527195033885,0.42639503741046897,-0.7766976895265505},
{-0.127172064126282,0.44140248105445407,-0.7956760779265616},
{-0.12910376684031832,0.44991751313001127,-0.8167193415789495},
{-0.10948434792116667,0.4516789953063188,-0.8206039745093743},
{-0.10383703125769747,0.4516349382259655,-0.8266337867340926},
{-0.0961755049842576,0.45754379373916837,-0.8304705576544971},
{-0.08952488844546995,0.4626666308869772,-0.8380333560160542},
{-0.07989601327479882,0.4633471125189796,-0.8500845695683327},
{-0.07301029213448944,0.48605212913851187,-0.8597701181650946},
{-0.08613089118261619,0.4991188583929338,-0.8595085793153611},
{-0.06915469682520674,0.5112551822140765,-0.8786874274309796},
{-0.046795328026991774,0.5097664534170472,-0.8993287703548719},
{-0.04252599668130029,0.5209369258811716,-0.8982790102857261},
{-0.07013316452796242,0.5337945842633716,-0.8725640940402384},
{-0.09425581783759038,0.5367456076092185,-0.8541950951652961},
{-0.1217954982475295,0.53730593356753,-0.8508529651015857},
{-0.14551563005029314,0.35715753330014366,-0.7263252269640545},
{-0.12872287335471835,0.3837517888175921,-0.7224556134928413},
{-0.1150832017962472,0.405855826809214,-0.7226134179442886},
{-0.11772141987158562,0.4273542802054341,-0.7536177872051029},
{-0.14325349923360706,0.27480363559027077,-0.8178456007603452},
{-0.12844291063501873,0.2644618367557006,-0.7827891816637635},
{-0.12909916087282683,0.25157674282800796,-0.7632793046671267},
{-0.1288534425201291,0.2491339779818733,-0.7472783738611745},
{-0.12612931313810172,0.27345228478016115,-0.7977707918379051},
{-0.09644465369332507,0.2661978859810771,-0.7766800666944093},
{-0.08532765050399296,0.26434468497385205,-0.7415273227994189},
{-0.10056038603614843,0.2630137606282699,-0.7377604424292112},
{-0.08294095830558071,0.26476182542101545,-0.6920081657795839},
{-0.07941599135840395,0.2658434267436891,-0.6635833385734557},
{-0.07554197217915531,0.2642059051707392,-0.6323138257926969},
{-0.08870122130231928,0.24919846152675404,-0.6414024009506716},
{-0.0960968030179901,0.24259070051158277,-0.63583118288054},
{-0.08195728385696507,0.25331399361012125,-0.6022907278670244},
{-0.0847214651302227,0.2565750185940905,-0.5880274483620979},
{-0.0762488880593697,0.2723392427228717,-0.547627706456485},
{-0.09584327454650245,0.2777436446660293,-0.5502769388019116},
{-0.09459345528066161,0.2917620068560827,-0.5185348137046357},
{-0.0957523567534097,0.29998325830946576,-0.4844903056399872},
{-0.08537090654652167,0.30814222907198563,-0.4559022669770955},
{-0.0788134106548444,0.31215663012999634,-0.41381273578047717},
{-0.076614361566846,0.30991472551838156,-0.3818160809144327},
{-0.08049679164325299,0.29191079963200317,-0.3895711283538953},
{-0.08947061813285292,0.282783173880079,-0.4319448277187925},
{-0.0992825304464464,0.26830321364359666,-0.45842052963819924},
{-0.10804908839892964,0.24878392445252065,-0.4561021259143346},
{-0.112140989866471,0.2269896878395649,-0.4410215875688542},
{-0.12469946062118079,0.2251759379452018,-0.47306630470437494},
{-0.1306029091290676,0.22122962510228253,-0.49183702404835705},
{-0.1382812571968242,0.20063294003711207,-0.48850510721691015},
{-0.14484255801816834,0.21300837364889952,-0.5185205952832489},
{-0.1459323699785442,0.1981839671478367,-0.5085312530915054},
{-0.1412000387702307,0.18363171324768365,-0.4964011373135033},
{-0.1278181011318264,0.17166200529405895,-0.4842624103788869},
{-0.1322832862256339,0.1741624448635652,-0.4724356876769542},
{-0.12360644450950652,0.17417345913365356,-0.45538900199097954},
{-0.11351356817893263,0.17332135514772937,-0.4483472787343282},
{-0.1054901730682272,0.17678404140404308,-0.43457002892948104},
{-0.09990453631725263,0.18418783375741607,-0.4264064521994696},
{-0.09029148164361746,0.18709940599040115,-0.41788140715110494},
{-0.06466628163448564,0.2009795891557101,-0.4262150041593889},
{-0.07363249826475181,0.20461049335519096,-0.4500246519390522},
{-0.07526501335129794,0.20964221245045078,-0.46785174872564894},
{-0.07720152229228187,0.21070759275717618,-0.5022310906009826},
{-0.061804173487169975,0.20563141606265078,-0.5214229555812511},
{-0.04321208557807496,0.20071224278174804,-0.5402719763725883},
{-0.0729259829034497,0.20249675479551305,-0.551315884860425},
{-0.05345295364674472,0.19941896721392233,-0.5521165221661184},
{-0.040841213876698645,0.18913624491891692,-0.5691880400246558},
{-0.02305997650556061,0.1794707222677701,-0.5977230099316674},
{-0.049404508481188235,0.18392589438877008,-0.598508227259237},
{-0.02095885429162023,0.1750688191621064,-0.614236404685911},
{0.004818943423098964,0.16803530654315732,-0.6307942570394203},
{0.0292135490741805,0.1655240529630189,-0.6498841899565075},
{0.051990458838471115,0.1664570617692282,-0.666387972256856},
{0.05679348163480605,0.16074706389598362,-0.6842735448046489},
{0.06605808485473778,0.1562776733535969,-0.6896070549003288},
{0.06717353002550103,0.14859632139399806,-0.7179225404433984},
{0.05705722333855742,0.1452105347688465,-0.7442402376519017},
{0.0488541954956842,0.13978891051245995,-0.7662471498072903},
{0.030308367520960146,0.1407980179120068,-0.7753158992791059},
{0.006347724111358674,0.14953473720552346,-0.8229528176705739},
{-0.0018090437971435846,0.15378023767593293,-0.815549225576657},
{-0.1467722581376431,-0.6646891712903237,0.3283810504890135},
{-0.14034553167083272,-0.6587658970962779,0.3384727252628505},
{-0.13246231817943327,-0.657054279524552,0.3371087581070034},
{-0.12335832304333494,-0.6454790826995453,0.3179727655150012},
{-0.11991005546786417,-0.630203892162686,0.30877044298593254},
{-0.12158502555911438,-0.608545631720457,0.29717682229096015},
{-0.12095721216407977,-0.6053096391685067,0.2883271566641741},
{-0.11143287242951969,-0.6063175450113166,0.26984741430998},
{-0.13898336685009097,-0.6915119228472408,0.634658062986405},
{-0.1144327590826675,-0.6867936098008579,0.6162952721546034},
{-0.11000642432335334,-0.6810860150410871,0.5748690002767585},
{-0.07277218364112545,-0.6756091191748027,0.5138038843125153},
{-0.09728013614438866,-0.6729032134032853,0.4628488669920749},
{-0.10440676941044817,-0.6754621287339877,0.4428119071068476},
{-0.10208175712453053,-0.6836495363392812,0.43139551603056914},
{-0.09852274606980804,-0.6757386870429328,0.42201836699628037},
{-0.08205961643905844,-0.6842467100375247,0.390652929936025},
{-0.07181854811093251,-0.6873028695978509,0.3816684896952491},
{-0.05492125597924671,-0.6943185591252025,0.3650952173636163},
{-0.01399983819035943,-0.6937782591125061,0.34091649140626595},
{0.0014323557601228106,-0.7018362991091258,0.32112324727917485},
{0.020850914444754617,-0.7047080197103367,0.3047019718747609},
{-0.03806641885226499,-0.7030290444299634,0.3120667136341844},
{-0.047833673307136726,-0.698052196425689,0.30759912542690304},
{-0.08177664982751653,-0.687743440401384,0.3236389065673486},
{-0.12411670560378026,-0.6715666817929308,0.34658283271806944},
{-0.11483988655702328,-0.556645189507526,0.22798637915283038},
{-0.0793296795328027,-0.5323915665135749,0.20813906497257845},
{-0.09092109737375743,-0.504029420517222,0.21371308667509623},
{-0.06628457829964501,-0.474828387659051,0.20811623539457716},
{-0.0717564676795256,-0.45264664899844237,0.2174469242350389},
{-0.048004294363777705,-0.4395480784904922,0.21941467365118242},
{-0.06185303679447092,-0.4202342555014276,0.2377368118133854},
{-0.09534542953851009,-0.4064491955777905,0.25739728392104805},
{-0.05805691854366517,-0.40850145448443004,0.254994971485056},
{-0.04139392997567649,-0.40403086238530633,0.2773321114836382},
{-0.08074030714193307,-0.38761799787805074,0.30258923461236376},
{-0.09358074321090404,-0.3813761108892681,0.32869645913245193},
{-0.11426033569092116,-0.37099385964455545,0.3439548278749948},
{-0.0720748802148063,-0.39023118352137026,0.3215389859101452},
{-0.07471730373872389,-0.39664409208570617,0.3431888354552158},
{-0.06490859557642882,-0.4165358638652238,0.3593305486588424},
{-0.1182575144357029,0.44515434196545045,-0.6398285618847779},
{-0.13112398423397353,0.44143412204852595,-0.614662356549145},
{-0.1176098753545093,0.442287227331731,-0.6146559482465481},
{-0.09471761614347547,0.44193216731597457,-0.6268791846716606},
{-0.10341428354576189,0.43395102695051707,-0.5854146632376908},
{-0.10001207564520592,0.43615488226546306,-0.5572091201360483},
{-0.09170190899329171,0.4374896115407121,-0.5252395002965842},
{-0.10407173534030689,0.429141195332673,-0.5182123959802319},
{-0.09709769977983475,0.4412476804948491,-0.48421014266083134},
{-0.0947706848993556,0.4384740870271524,-0.45610512980617685},
{-0.10452051678154216,0.41195352698956766,-0.435753962834248},
{-0.0880061207300178,0.4019207284958391,-0.3825960914961424},
{-0.09532159866322806,0.39335182662657736,-0.4108845420126315},
{-0.07423167455755676,0.38793440781877,-0.35717475561337264},
{-0.07251965646691852,0.3839824877110784,-0.36890375170070344},
{-0.061002134365283664,0.3696286909319714,-0.34959072974946337},
{-0.06828276715312358,0.3561225924307532,-0.3581029581926343},
{-0.08648855457130258,0.3575776776391492,-0.4171354406769411},
{-0.103856256165488,0.35155066904681703,-0.4673388842584452},
{-0.11475677888272046,0.3470970990014663,-0.5074562603308846},
{-0.12474912496630634,0.34783525535684034,-0.5404786441313365},
{-0.11700008531052832,0.34787851139936904,-0.5603041300308679},
{-0.09981722319437063,0.35662284055221943,-0.5838824781386764},
{-0.07633560040388326,0.36575347019598586,-0.6005654926522803},
{-0.03522433665056447,0.3733242789357892,-0.6077035407073405},
{-0.05092087308316655,0.383086326644801,-0.6423808686534274},
{-0.07723656769710838,0.38893410302387776,-0.6661799026819146},
{-0.07569436962528651,0.3961664732827851,-0.6856266979498638},
{-0.09948399145933472,0.3998638636217082,-0.6992447414870706},
{-0.11930987787777844,0.21413523360866335,-0.9508006573316389},
{-0.09429166428024147,0.2093083799370464,-0.9618890234187414},
{-0.08663874916341611,0.21840897066239018,-0.9602460948404752},
{-0.09449813177953355,0.2362594978053566,-0.9418788983006383},
{-0.13889184827862977,0.18454269351371635,-0.476868030219953},
{-0.10037895096887527,-0.6652593099619867,0.3205446977103535},
{-0.11958603566781122,-0.6535473359284288,0.32690954400521316},
{-0.11437888928896277,-0.6344854393352026,0.3135944930251634},
{-0.12039388231392592,-0.6153520501161304,0.31048145977929},
{-0.11699608012140528,-0.610574860789639,0.3068673773741259},
{-0.11384780121124928,-0.6031218046100527,0.2904032464460955},
{-0.10831923840527788,-0.6024445271293488,0.27756741634461607},
{-0.09109452206278452,-0.6038958074080778,0.24283021082113984},
{-0.09292289089744674,-0.6090054274317807,0.23100929564343559},
{-0.10786224632634041,-0.6206304888613687,0.24796366172012455},
{-0.10837731364756178,-0.6213588325033914,0.24989115898558167},
{-0.12156740272697306,-0.6978697600611352,0.6448260366130357},
{-0.08969951469123397,-0.6941583515602814,0.6220058708062165},
{-0.07171541449101457,-0.6850403382622525,0.5796453885654252},
{-0.04433754372164576,-0.6790299512047808,0.5275230588750786},
{-0.11137279459267425,-0.6334048393098097,0.1444759830836832},
{-0.10201827487693055,-0.6292720849132135,0.13237830933757774},
{-0.09142154575467977,-0.6313920315160321,0.125051616874823},
{-0.08268382516388233,-0.6248179140894943,0.12325548981260119},
{-0.0820660247416553,-0.6081485172189087,0.13410614792525194},
{-0.07945884688202035,-0.6018411453879646,0.14909656951546418},
{-0.07928502167408093,-0.5881778432136675,0.15707090105941252},
{-0.07562507985345814,-0.5821788709451966,0.16762036895001162},
{-0.08817994593795721,-0.5729310895195815,0.17376392854582395},
{-0.13685200545827172,-0.668336496765209,-0.10735589029146161},
{-0.13881074319888848,-0.6728285166261408,-0.10479016613925002},
{-0.13818052669038006,-0.6728411329718783,-0.10780907744073223},
{-0.13233555394368943,-0.6666154669990438,-0.11038361300901449},
{-0.132946145025495,-0.6615695294823974,-0.10192805799193434},
{-0.13801871704980972,-0.673282504813236,-0.10413251408524886},
{-0.1360079118505936,-0.6784053419610446,-0.11680893765963181},
{-0.13267619527860294,-0.6752041945544648,-0.11440702574255203},
{-0.13792359380813782,-0.6789794858218308,-0.11959314487850459},
{-0.13271464509418401,-0.6529339412142371,-0.09868946206705408},
{-0.1329523530686357,-0.6630226120962319,-0.11793199268972882},
{-0.1342970953166923,-0.6754957723226213,-0.125064833998929},
{-0.12913901250460094,-0.6718708759068248,-0.12514253466791575},
{-0.12750749871533557,-0.665206841984475,-0.10949386024533385},
{-0.1268882964769155,-0.6662810337072711,-0.11761838638139575},
{-0.12920509812513092,-0.6667536460237884,-0.12552943593720026},
{-0.1293456802633492,-0.6609349072658535,-0.11254160890850184},
{-0.12802637096622382,-0.6645197517904196,-0.10549668150055211},
{-0.12672708761471363,-0.6589627521416747,-0.10065701122374149},
{-0.12842829169471967,-0.6569781809312144,-0.10843228486827533},
{-0.1283325676746793,-0.6469894395178394,-0.0982522956742756},
{-0.1334393840659959,-0.6477958843477609,-0.08684171212222556},
{-0.1320041245437589,-0.637234801408705,-0.08615041647959097},
{-0.12740596717106684,-0.6460700483546482,-0.1081745509482085},
{-0.12695578391363851,-0.6491338177743082,-0.1170236157966261},
{-0.12612250431659258,-0.6560708053353925,-0.11664272231102617},
{-0.126806991137718,-0.6588323832357202,-0.12488800489914734},
{-0.1252964340599681,-0.651559360307214,-0.12686696884483536},
{-0.12735029504225676,-0.661993679010526,-0.1311052599748234},
{-0.12952931818464,-0.6671563677901088,-0.13596575723507376},
{-0.12566911690786584,-0.6679401833014853,-0.1274535287919028},
{-0.12235942887605182,-0.6665565907189352,-0.1384782123719491},
{-0.12874930760293035,-0.678512881288998,-0.14643091589463308},
{-0.09174136010615352,0.5356429790436489,-0.830514214215938},
{-0.07916005977344247,0.5370439941988839,-0.8160761082057914},
{-0.09240441916547078,0.5292819376784561,-0.8009198717858858},
{-0.09667655414354838,0.5263431301594346,-0.7870903542629831},
{-0.10992551950306817,0.5254441654607709,-0.7752001493134505},
{-0.11946648077248882,0.5174754411815947,-0.7813675397845448},
{-0.1246558040597398,0.5174335869552591,-0.7706500542102347},
{-0.12270047072987764,0.5165374258889818,-0.7591659754377771},
{-0.11841331629258867,0.50803721301318,-0.7469599613258937},
{-0.10474620918862478,0.5091043956550106,-0.7338083220620636},
{-0.07813853628761422,0.523049863403025,-0.7339765400052307},
{-0.07932847797606578,0.4662947314540718,-0.6782217040397539},
{-0.10262566180743772,0.44861142095699186,-0.6600181194755925},
{-0.11496564949548634,0.3047221980798322,-0.8729395805205222},
{-0.10989768343866312,0.29175199388327516,-0.8449835607012445},
{-0.11039713052230468,0.2776489219432697,-0.8107494069316206},
{-0.09501920688443946,0.2741696141520954,-0.8101872786382036},
{-0.07326321982760865,0.2707055260795887,-0.8159629616130658},
{-0.06412658240015764,0.2623006367049149,-0.7897453941326382},
{-0.07345626994333858,0.2611837897179586,-0.7629969388339533},
{-0.06261742713860076,0.262380139709007,-0.749773806944277},
{-0.06390930089023339,0.26345653428582066,-0.7149492882979187},
{-0.0882776725525591,0.19704108643158075,-0.962047428648557},
{-0.06572245000622806,0.18760065540914805,-0.9676168443835833},
{-0.06782477377690535,0.20781644698871857,-0.9661553508725903},
{-0.0739320864111543,0.2233936287854544,-0.9560334369208747},
{-0.07722234927572162,0.23829072946910015,-0.9332723476536199},
{-0.13197388536588003,0.19916423718569778,-0.4650204805345806},
{-0.12915303066653155,0.18153679907688403,-0.45673294320121144},
{-0.11539620732621184,0.17812818287373117,-0.4352174677512185},
{-0.10719798571028624,0.1844954322820646,-0.42638922988624056},
{-0.10521882150514207,0.19569374081059418,-0.4180700515587995},
{-0.10120081577692057,0.19150851843648628,-0.4016401649977711},
{-0.08749846300867402,0.18248863227197157,-0.3943154751295778},
{-0.07925658483130743,0.18383057088764201,-0.40041517790449305},
{-0.06838229610283084,0.19181010917745028,-0.4001244011741612},
{-0.050907655959060556,0.20035638172816697,-0.3982529765564265},
{-0.04246932325520945,0.20723128885784417,-0.42199733975338444},
{-0.06006071466191598,0.21000588362282172,-0.4427600399077044},
{-0.053175193781062745,0.21283655103552163,-0.4473203482431839},
{-0.060868961826942986,0.2115384692407483,-0.46668503713411086},
{-0.051969231336119075,0.20894070357555247,-0.5032165673847036},
{-0.04014611330439717,0.2034361719043192,-0.5146495799958426},
{-0.01281089779918863,0.19524235599642895,-0.5388265036180876},
{-0.025972349776370265,0.19487908534297033,-0.5576256598048431},
{-0.08909753476604287,-0.513630259364032,0.8208699190671432},
{-0.07548710108816985,-0.537817796737453,0.8100306757434931},
{-0.05926528410208265,-0.5600267706840982,0.7961444847944997},
{-0.05804249986282227,-0.597895833842326,0.7792816372892719},
{-0.0629971190674638,-0.6348176697729578,0.7562231627296325},
{-0.0795904173447118,-0.6451993202393019,0.7486493500979868},
{-0.0840043360177446,-0.6585207795219487,0.7320222079726493},
{-0.09861746879256765,-0.6718492478855604,0.7146887507454658},
{-0.08063737378147126,-0.6903370006180005,0.6876491181975366},
{-0.08939311772332233,-0.6969515704546809,0.6832358003028723},
{-0.13323251604779152,-0.6389157792836397,-0.08111509271412042},
{-0.12740015964683843,-0.6308543348762655,-0.08584341873331089},
{-0.12417217747313418,-0.6446986715989236,-0.11056865274649837},
{-0.12564808966496993,-0.6328763546050261,-0.09844534579000554},
{-0.12443992436600859,-0.6274327018084629,-0.09369579226846303},
{-0.12448358092744959,-0.6530468875475064,-0.12650349793192062},
{-0.12410929600390264,-0.6528760662314093,-0.1265982206546802},
{-0.12430575053038716,0.2060864055470267,-0.4493760115605778},
{-0.12694597120028708,0.19577845056054624,-0.44583242048397903},
{-0.11994950658072599,0.18569258331093763,-0.43445007351524634},
{-0.11584599006472786,0.20149305440128226,-0.43622857774532675},
{-0.10652611523489833,0.20359838206380182,-0.41255410509856566},
{-0.09631468530628282,0.19099985941786177,-0.3912577134936023},
{-0.08283982728022427,0.1862773409228997,-0.38272966455339535},
{-0.0682567334238239,0.1849506220258967,-0.3831608231624893},
{-0.05138086905394629,0.19263177372603943,-0.38149987123316964},
{-0.03522073198035375,0.19754193533141534,-0.3916438137250622},
{-0.026067673277498322,0.19851239265592502,-0.40624192704067386},
{-0.014784454739560577,0.19767170345900145,-0.4376241858952459},
{-0.01605009450243736,0.20345059058516213,-0.4603632466223239},
{-0.03822462382262459,0.20835494466630963,-0.4607066915896235},
{-0.12136834482755857,-0.1816579560478556,0.42579465956092705},
{-0.10924583890889035,-0.12585325547779702,0.4256793101141839},
{-0.10327009673733288,-0.0777925880771127,0.4255901946561965},
{-0.09536205107337066,-0.03936720414969634,0.42245713546470803},
{-0.09716378540036472,-0.03818747569350851,0.41175386831178473},
{-0.09364242312339867,-0.026709004185823136,0.4223978586656872},
{-0.09074506931180036,-0.012561875165464375,0.4170088767006533},
{-0.11429237720390537,-0.6704620506327997,-0.20844966738906928},
{-0.0983593343535885,-0.6852085562054198,-0.20672323061758816},
{-0.07096163789806073,-0.6941227053770864,-0.1835564156921708},
{-0.06870551486505917,-0.6984276829059729,-0.2000219484363942},
{-0.08022564033962401,-0.6998693507308067,-0.25301120131242033},
{-0.08117527068069391,-0.6984368948409558,-0.29739570587653363},
{-0.09921404171244264,-0.696922532833539,-0.38752447671202805},
{-0.08719527019206084,-0.6953807352806296,-0.44447366007399186},
{-0.06989665811024763,-0.69665138152991,-0.48656839801647006},
{-0.03285206313299511,-0.6978012713271314,-0.5211578120613065},
{-0.0587814572560209,-0.6990625053819728,-0.5384548220674705},
{-0.06552199029062053,-0.6915197329660308,-0.566726450789643},
{-0.08068924098061447,-0.6879603213923959,-0.5885505260615653},
{-0.10602546659451985,-0.67965856563764,-0.5936261019777223},
{-0.11232502830667412,-0.669444932855007,-0.6090386705015017},
{-0.08938250397214631,-0.6674813888874426,-0.6365298881230522},
{-0.0953354165657025,-0.6565135789929433,-0.6543485740124906},
{-0.06770862329233755,-0.6558605329064335,-0.6684360257149162},
{-0.03434239400567375,-0.6489103282212434,-0.6871791092539493},
{-0.06682708116635913,-0.6236926562053797,-0.7022061783246374},
{-0.0508786183379186,-0.6182980669755735,-0.7155098145156864},
{-0.06619225869035922,-0.6043507968924539,-0.7245092742156738},
{-0.11709661036839328,-0.6663359047982566,-0.18437127141925078},
{-0.11925700938135447,0.43955729042547514,-0.7726854913225575},
{-0.11063383719947563,0.44899732092899564,-0.7844401206202756},
{-0.11508920957993177,0.45291219303729907,-0.8095067970062011},
{-0.1025461588033456,0.45368018805163973,-0.80910567731553},
{-0.092888846789901,0.45204867426237433,-0.8173289313634745},
{-0.077549573227073,0.45023953033550274,-0.8359466524829567},
{-0.07914403901695036,0.45357264872368636,-0.8453169926957366},
{-0.07039049792911696,0.4563939039419471,-0.8527315990597417},
{-0.07179852216531737,0.4746938133045173,-0.855417278626188},
{-0.05636712925265974,0.4595509942681738,-0.8573900345287355},
{-0.04050678058492582,0.46526860200075215,-0.8710943898915433},
{-0.055909736654809965,0.49349917753441347,-0.880809777147272},
{-0.040275480913070975,0.49087197372916347,-0.9017432986176889},
{-0.02587922912925987,0.493960174802474,-0.9150265083442107},
{-0.023812351282321374,0.5106882476937119,-0.9110685804528346},
{-0.02740300333111579,0.5183627908318016,-0.900496082724778},
{-0.044420250877036285,0.526810735989548,-0.8899996835900593},
{-0.05937903147317664,0.5339529894931873,-0.8658483931782014},
{-0.06596135953741668,0.5343300780491204,-0.8330422895903933},
{-0.05127052609360688,0.5312170448032472,-0.832225831787664},
{-0.056458647824120925,0.5447109274776399,-0.8180208277844775},
{-0.0701521891762968,0.550010193206318,-0.8049408814059495},
{-0.08868500028637102,0.5396944281010476,-0.7960944199304618},
{-0.09951362985884513,0.5320963840752078,-0.779272425354289},
{-0.08571495229218976,0.5499378995426475,-0.7772013420587712},
{-0.10352923247359279,0.5370782385658859,-0.7643813324543278},
{-0.11565093735443639,-0.10614552213848259,-0.47674467039496365},
{-0.11378652181766695,-0.1341327824329201,-0.45683807941569093},
{-0.10318959243596001,-0.13405668383958255,-0.4327508720298017},
{-0.10819207365062174,-0.17479686682065282,-0.4354972302114619},
{-0.09037158542607801,-0.17923381533114302,-0.42196269486747023},
{-0.06789606614329526,-0.18342584652676006,-0.410402317242219},
{-0.0056207822855291354,-0.19532466263290715,-0.38810582991323556},
{-0.012461445048204456,-0.24991779349324983,-0.3881442797288166},
{0.002085401846632495,-0.2741748208979554,-0.37109699326447343},
{-0.014372721297713319,-0.2860630232529265,-0.36395814417158867},
{-0.05208958726926606,-0.29562701435980454,-0.3600803200626732},
{-0.0765196388440864,-0.3026459080384546,-0.3532430617107524},
{-0.03145465264797071,-0.30202430268656066,-0.3235912448167846},
{-0.03196911919082363,-0.3055965308653892,-0.2936860997107853},
{-0.07470849232265324,-0.3126851148347799,-0.2835762013264385},
{-0.08537931744368002,-0.3150247460609966,-0.26164839165622983},
{-0.07951431875137428,-0.31060842427449,-0.24043610902284998},
{-0.09152608119079078,-0.3156127078242571,-0.22718774444169862},
{-0.08221862244724264,-0.3029028409206968,-0.20174498079712072},
{-0.09331299631802963,-0.3130315636939218,-0.17008636389305984},
{-0.10530913851986634,-0.3283215734305366,-0.15755052245689516},
{-0.11579131923319853,-0.24791960463977125,-0.734049634706726},
{-0.10284915136050266,-0.23374363825772668,-0.7338371594237494},
{-0.08123034203113552,-0.2036734793598586,-0.7298105425389134},
{-0.08214392567009818,-0.18576387567732752,-0.7264545945727283},
{-0.09041524198751902,-0.1691100990443218,-0.7091419643289846},
{-0.07869325498115358,-0.14940637089413042,-0.6998026643319084},
{-0.06691199117576732,-0.13404767216405575,-0.6990941463760447},
{-0.07404823689572208,-0.1221328353014165,-0.6900362109148612},
{-0.08451679996603599,-0.11198068217182179,-0.6712478687387379},
{-0.09564381612817567,-0.087814572560209,-0.628793865331924},
{-0.08792301305571497,-0.04798557010462755,-0.5811004737738213},
{-0.09331319657748578,-0.04640612377396154,-0.5565656865034337},
{-0.0985760150851443,-0.04058938761058827,-0.531812215906929},
{-0.1001086007030709,-0.03937281141446858,-0.4994366701498461},
{-0.12683903265070223,-0.6640114932907074,-0.1231775888841583},
{-0.12448358092744959,-0.6641606865855401,-0.12383423964087872},
{-0.12090033847853278,-0.6547973554537259,-0.11543716038499478},
{-0.09585188570311694,-0.6627025974853019,-0.1607434592257729},
{-0.0950668686350035,-0.675239039699835,-0.1836753698091247},
{-0.08255285547955932,-0.687554395474777,-0.18354419986534554},
{-0.06716371731214961,-0.682158404428778,-0.1590815059991725},
{-0.045224092334027965,-0.6868256513138422,-0.14981329810903007},
{-0.027572022312107567,-0.6969347486603642,-0.16569146986836145},
{-0.02586541122678543,-0.7003884232411511,-0.1820274347444549},
{-0.0419009869186518,-0.699767819186538,-0.19961301862693306},
{-0.04865513759626973,-0.6968580492886584,-0.22651287007446846},
{-0.050732629194384246,-0.689552984847168,-0.2753827859374605},
{-0.07495260859970178,-0.6917388168110604,-0.3263918733110618},
{-0.07681842595266428,-0.6886141685167302,-0.4142444951679396},
{-0.06512267293505465,-0.6869600254089197,-0.45240473557541144},
{-0.051195428797550104,-0.686817640935596,-0.4762636471812881},
{-0.042780726709524854,-0.6897936967134618,-0.49560851038605613},
{-0.020692709474395027,-0.6871148259685248,-0.5008897527636805},
{0.01190973024650737,-0.686845076481089,-0.49720738188396885},
{0.03285286417081971,-0.697952667475982,-0.517795656051981},
{0.026784401871064147,-0.6999937118530769,-0.5358230122947291},
{0.007318982473692912,-0.6976676982698783,-0.5676973086330649},
{-0.04339572349936578,-0.690740923941058,-0.5838454301392885},
{-0.03133269463917451,-0.6919084365704204,-0.6049758066551023},
{-0.05861283879394143,-0.6874388457685777,-0.6120938287645473},
{-0.07603160654944545,-0.6814637043753887,-0.6193117803426119},
{-0.09883174641064962,0.4275773692395868,-0.7432535593114439},
{-0.09706665956413128,0.45377090558527616,-0.788685420831229},
{-0.07488912635210178,0.45644376854652885,-0.7992451019540917},
{-0.07608447504586943,0.45010856065117955,-0.8251959238389256},
{-0.06590048066274665,0.44529572514149335,-0.8353652992817493},
{-0.06707039640558307,0.44787046096923167,-0.846050342824163},
{-0.10322724121371647,0.29445569680077505,-0.9305394068555218},
{-0.08916802609460817,0.2803790591089816,-0.9085409055972916},
{-0.07705433159201061,0.2831818904572765,-0.8849587525598163},
{-0.09107549741445016,0.29919784072244,-0.886769098043425},
{-0.09674183872625372,0.29838478733046536,-0.8686990865365167},
{-0.12147067740965194,-0.2632708937699683,-0.7366500037448518},
{-0.09751183633515584,-0.2575454759186001,-0.7504152379823299},
{-0.0724259350414397,-0.22036190087877852,-0.7426758107804471},
{-0.04386833581588306,-0.22163595153881366,-0.7553155868743544},
{-0.04142797408322223,-0.1985358230122947,-0.7438669540256356},
{-0.04560017959268027,-0.18320536086553738,-0.742940353522023},
{-0.03917946090955442,-0.17281730209659635,-0.741667704678181},
{-0.06301013593211365,-0.1646641388583048,-0.7252880832406465},
{-0.04671242061214509,-0.1434658743868556,-0.7142295558125106},
{-0.02195935053455257,-0.12743470440302454,-0.7142868300169699},
{-0.04549304078363928,-0.1186182818459596,-0.7045964751932603},
{-0.057500798033932765,-0.10507493508589728,-0.6862687297662852},
{-0.07764229335527108,-0.09389845483808822,-0.65608602505406},
{-0.08325536565173838,-0.07500717930150302,-0.63362492445212},
{-0.07968734292148907,-0.04953097232774783,-0.6039128294618508},
{-0.07767593694390452,-0.024920486982935093,-0.567273960142761},
{-0.07970436497526194,-0.014971396941877883,-0.5357953764897802},
{-0.07086751595366957,0.009391968234044031,-0.5001788316943432},
{-0.07527362450791246,0.011983525856099162,-0.469812288801371},
{-0.08772996293998504,-0.014709657832688027,-0.4694572287856146},
{-0.10096410909974964,-0.04957002292169735,-0.4697534125212625},
{-0.11062462526449267,-0.08331554361831187,-0.4835356688125135},
{-0.09590555523736552,-0.40310746603299236,0.8653507484296652},
{-0.10498451794144494,-0.43948239338887457,0.856246753293567},
{-0.08740113691298446,-0.4344052153970684,0.8504934993777936},
{-0.10343190637790321,-0.47665996064501165,0.8388520166728013},
{-0.061250856609823684,-0.44219851239265595,0.8319356558357007},
{-0.05617628199094747,-0.5047028930682592,0.8156323332509597},
{-0.04773834980600866,-0.5079326775770688,0.8102795982474893},
{-0.04449915310275993,-0.5316646246877454,0.7962792594084895},
{-0.047423341681482524,-0.5734775975754187,0.7828476574249597},
{-0.04536767836408852,-0.5937020003116037,0.7792746282083065},
{-0.044408035050211056,-0.6183086807267496,0.774388697997125},
{-0.04732441351014374,-0.652460327600439,0.7473374504007391},
{-0.061661188235477886,-0.6691879999727647,0.721515996124579},
{-0.06576290241637064,-0.6871708986162472,0.6857410460993262},
{-0.047630810478055376,-0.6961086784037399,0.6639063570762279},
{-0.09121668033103687,-0.7010841245918211,0.6716417790889876},
{-0.06990947471544132,-0.7030392576622271,0.6315127879680914},
{-0.03339316418351616,-0.7011225744074021,0.5901443910730743},
{-0.0452004617182021,-0.6898049112430065,0.5740929948841719},
{-0.00413005089393819,-0.6784021378097463,0.5012299935796818},
{-0.02247742174761621,-0.6742605719970793,0.49836888672964685},
{-0.04677329948681512,-0.6591361768307018,0.49368141363951124},
{-0.11104036389546294,-0.6436939699074119,-0.12768242535028382},
{-0.10343791416158775,0.2575042224706329,-0.9189810318248324},
{-0.07708256817532795,0.25728934407418247,-0.9223037367212961},
{-0.09545477120156874,0.27028418018384615,-0.916921163058859},
{-0.10773468105277197,-0.6552933981266128,-0.15309014359003523},
{-0.09558994633447093,-0.6437870905545223,-0.13952516880870855},
{-0.08169274111538909,-0.6473084528314884,-0.13196397252280054},
{-0.07611531500211674,-0.662291464821823,-0.13774666457862805},
{-0.11277380974790938,0.5252917680146397,-0.7534878188180606},
{-0.0975070301082082,0.5360569153395138,-0.7546827669929159},
{-0.06481467389149383,0.5454999497348765,-0.750115049057559},
{-0.047328618958722916,0.530531756944297,-0.7324191222147414},
{-0.05346617077085071,0.5055922453130275,-0.7116868614977564},
{-0.03803698071221074,0.48560414873510116,-0.6951780727110043},
{-0.05803689259805003,0.47242247055284825,-0.6782951992601614},
{-0.057723887068085414,0.4632049283051121,-0.6516482755057452},
{-0.07340740663603763,0.44743830106285704,-0.6334883475030249},
{-0.07894257800406206,0.4375757231068573,-0.6149399161553708},
{-0.08442928658369783,0.4357313335157029,-0.6031740723281083},
{-0.08429331041297104,0.4404904994911407,-0.5931937418118914},
{-0.09643604253671056,0.4425912211861687,-0.5782730105124199},
{-0.09360136993488763,0.45611314018442295,-0.5589109249944227},
{-0.08812847925772631,0.453158111649453,-0.5332292518186562},
{-0.08296639125651194,0.4529372254693181,-0.5176492663895342},
{-0.08758697768829295,0.44659080304442433,-0.5052996662475904},
{-0.0984071963636087,0.43900317251030435,-0.5015838520387013},
{-0.08574318887550711,0.4576635488939469,-0.49710024307492784},
{-0.08685102418693659,0.4606251859909699,-0.47000333632253943},
{-0.07920972411856801,0.4620304065947842,-0.4411719824204239},
{-0.08278195229739652,0.4516046990480867,-0.42801093096215453},
{-0.08843687882019945,0.43477128968291306,-0.43118464282324176},
{-0.08829549564415658,0.4211528456267941,-0.4186307780360235},
{-0.08279096397292332,0.4182292578264399,-0.39418951193165863},
{-0.08053784483176403,0.4098351824623983,-0.37232778788197984},
{-0.06670992938451056,0.38640702894670326,-0.32947947360600394},
{-0.10600544064890471,0.34444265991017964,-0.5196288311135908},
{-0.09870558295327427,0.3477923998332239,-0.552072264826309},
{-0.07904591188343618,0.3550419924053604,-0.5569788217614742},
{-0.04689545775506747,0.36343146180191055,-0.567436771080612},
{0.006211948200088029,0.36982434442063133,-0.5732627191789682},
{-0.009150955978565835,0.37214214736612755,-0.5948955466702659},
{-0.008712588029050443,0.38257186010194805,-0.6409299888936105},
{-0.03131947751506853,0.39157252135867227,-0.6628860351471365},
{-0.048095412416326595,0.3920513417183302,-0.664721212803308},
{-0.10074202136287774,0.20128378326960408,-0.39868473594388887},
{-0.09332340980974951,0.21091466103483672,-0.3974895875095774},
{-0.08449877661498237,0.19899081249667067,-0.3812855936150877},
{-0.07644333999129273,0.19204341144386666,-0.364679478732646},
{-0.0676733776280549,0.1823270228908574,-0.3627862258341908},
{-0.04833211909349753,0.1824744138505848,-0.3612408236110705},
{-0.036386242015154835,0.18276418928363586,-0.3626975108951157},
{-0.022539502179023146,0.18424811185371767,-0.38432593267837806},
{-0.011424301324796412,0.18933470203996294,-0.41124781266609023},
{-0.0014127303334199827,0.1782821823955116,-0.4212393577118515},
{0.018957461286843228,0.17744169345804423,-0.44133018739078345},
{0.008839752783706566,0.1891558703456198,-0.4474603296030337},
{0.03132668685548996,0.19283443629566463,-0.47102626162456074},
{0.0174406961659526,0.19842087408446385,-0.4854717772345851},
{-0.014596411110234422,0.2004218665703285,-0.47965183691991337},
{-0.038229029530659916,0.20622398379340273,-0.48407476726847304},
{-0.10193817109447,-0.050657832287511695,0.43182347048836467},
{-0.08769431675679008,-0.2788402654479143,-0.7562055398974912},
{-0.0570025525070281,-0.2962960812028063,-0.7777150075637996},
{-0.030595539581081247,-0.2770429368289556,-0.7762851550468787},
{-0.06167700873251385,-0.26407133081620543,-0.7647151649677321},
{-0.08333987514223427,-0.5557636473815474,0.21123187201338053},
{-0.05946814693116402,-0.5396697961879411,0.20597165687865196},
{-0.05391595350936674,-0.5172169062237034,0.19947784349403086},
{-0.06093244407454298,-0.5094378276495026,0.20072726224095935},
{-0.05013986120417613,-0.5034100180193458,0.19859129488164864},
{-0.03542559740399662,-0.48570007301459767,0.2007332700246439},
{-0.039042082922634565,-0.47736968015761216,0.19903867450669083},
{-0.03195530128834919,-0.46580509708378165,0.20314459413616281},
{-0.02925680511670921,-0.4362508065449597,0.22216163261121108},
{-0.03500264943260488,-0.4219865257427523,0.237324878112082},
{-0.11204987181392212,-0.6229911473304813,0.3101257989851651},
{-0.10281891218262382,-0.6102796783512718,0.2955903668793288},
{-0.09562459122038512,-0.604249265348185,0.2757244285696548},
{-0.06874476571846484,-0.5994097953308305,0.2476228201257549},
{-0.07504713106300524,-0.5936929886360768,0.22457956528478293},
{-0.07316309009953295,-0.6162097613668268,0.21264690533054625},
{-0.10057961094393897,-0.6430419251181831,0.14121455758080168},
{-0.0905546225690004,-0.6490899609534112,0.12694947574076973},
{-0.07887829471863746,-0.6452886359567455,0.11913334916718098},
{-0.07446297422941162,-0.6395902531319576,0.12107726770804253},
{-0.07666763058218228,-0.618173105074935,0.13103136423550352},
{-0.06791709338619115,-0.6398245566956549,0.13633904086133994},
{-0.0729400010653803,-0.6133352371332298,0.16162480109229518},
{-0.0776166601448837,-0.5937827048724328,0.16301960820438957},
{-0.06390169103089963,-0.5898712371748837,0.17842696998230906},
{-0.06602504204447282,-0.5837360884762298,0.1858565958055256},
{-0.08965125216230146,-0.5715685241799275,0.18446979907167727},
{-0.07627632360486246,-0.5789807274304589,0.20131962971225517},
{-0.07727521777214559,-0.5835013843936203,0.21396361125474164},
{-0.07280642800812734,-0.5726551319890049,0.21638254522559425},
{-0.0795826072259219,0.3456466197605617,-0.45862960051042123},
{-0.06532233161283758,0.34606916721304115,-0.48587870444948467},
{-0.09031811615128561,0.34460827448041675,-0.5206407421455237},
{-0.07708457076988946,0.34893508029002374,-0.5231331713367839},
{-0.05770686501431255,0.3550417921459042,-0.5245295805245276},
{-0.034716278410308395,0.358836708839973,-0.5290027759965811},
{0.006306070144479182,0.3606630750800737,-0.5185998980278849},
{0.018926421071139763,0.3667243280394078,-0.5580670316462008},
{0.03718487672628657,0.36767696227232,-0.556446932645936},
{0.03034020877448822,0.3712077367437252,-0.6074399992630451},
{0.0036440211938587584,0.37041851422703254,-0.5908194656997606},
{-0.004236989443523033,0.37160084605615035,-0.6081118697384331},
{0.002910270546520066,0.3730857699235129,-0.6066125271902276},
{0.02410312801265319,0.3743409961946698,-0.6520900478660151},
{0.0002572332714264589,0.3890194135521982,-0.6826404289397343},
{-0.014985314974080422,0.39467674318847495,-0.688184011204917},
{-0.025892646512822012,0.39404111967465044,-0.6854042096940796},
{-0.05361396224949044,0.39434291067507055,-0.6821912469795868},
{-0.05503740646381452,0.40248646145946687,-0.7001657347259108},
{-0.08155316027445157,-0.43763219627349187,-0.7768352677729266},
{-0.027859795150597118,-0.426143711792999,-0.7926862042462214},
{-0.03989598924366409,-0.404626834526813,-0.7981622990746812},
{-0.03170057126012462,-0.385152603713371,-0.7976276063267569},
{0.0005944701955853974,-0.3556079256284442,-0.7948321845783397},
{-0.034483977441172785,-0.341018423469447,-0.7944456838279674},
{-0.008687555597031516,-0.3320381886772502,-0.7971339667673437},
{-0.024849695265185576,-0.31449465928056386,-0.7924995624330883},
{-0.06133836999216184,-0.3187962323986957,-0.7862144194017768},
{0.008484492508493998,-0.28704489536643674,-0.7831672715169774},
{-0.009981031424313341,-0.26470254862199466,-0.7808404568959544},
{-0.03555296241810891,-0.25229727635124066,-0.7737556778562305},
{-0.06724181850004866,-0.24501904667687455,-0.7589679188356434},
{-0.020269561243547146,-0.23726099534556971,-0.7692948984704583},
{-0.002169110299303782,-0.20610983590339643,-0.7558426697629448},
{-0.0029076671735901068,-0.18957000690094084,-0.7549541185560011},
{-0.0034826120722007492,-0.17668611452998503,-0.7501000295983475},
{-0.030072061362701515,-0.15996424968188783,-0.7354252169110299},
{-0.001796227191949894,-0.14313324343018813,-0.7238738509613054},
{0.015566467915831746,-0.12829361721045787,-0.720747600591326},
{-0.023161307790373203,-0.11171894306263194,-0.7074569812649267},
{-0.03397952387112744,-0.08605609427574364,-0.6780673039990611},
{-0.06230762575993457,-0.07681732452565543,-0.6553961312276184},
{-0.05947495575267316,-0.056685842177124676,-0.6358259761346801},
{-0.05085018149514511,-0.034641281243979694,-0.6157331438611865},
{-0.06092964044215685,-0.029171194199204484,-0.6017936838968567},
{-0.067527989262889,-0.01585554244078628,-0.5720675707446566},
{-0.058349097090190045,0.010452942832734098,-0.5390355744903097},
{-0.052266816887960046,0.030119222464625166,-0.5126886394012082},
{-0.03905710238184591,0.05847516041783736,-0.4822039434291067},
{-0.05122787082944663,0.0557019674690529,-0.4515670502703302},
{-0.06825312875361318,0.029915158078806903,-0.443233052743134},
{-0.07997591679780323,0.001968350194512005,-0.43861346760863373},
{-0.08798709608168341,-0.022180537103871762,-0.4506086085131896},
{-0.0976235811116883,-0.0631960768371502,-0.4425617830461145},
{-0.10354385141389183,-0.1063824290751097,-0.43835172849944387},
{-0.09503322504637006,-0.07617128752011106,-0.4340359369599252},
{-0.08408043461108211,-0.09495982995569058,-0.40854431000804636},
{-0.07221345975846308,-0.13124223744283092,-0.4054771361776317},
{-0.09056223242833415,-0.14586498267154926,-0.4192251481018808},
{-0.0332175366404714,-0.15764103973107557,-0.38933161804433825},
{0.027003886235006068,-0.16241262179279473,-0.3668843353448728},
{0.01684111935423534,-0.2126000446178068,-0.38099782077659816},
{0.019153915813327742,-0.24215593723227813,-0.37672648683634513},
{0.010699962871896824,-0.2625669817815962,-0.37363468109282383},
{0.021625317761692044,-0.275444265590499,-0.3527203845301973},
{0.006532763848842554,-0.28827789283796085,-0.3515282399877281},
{0.015752508950596388,-0.2936246200577468,-0.3323441851262496},
{-0.08877231340925303,-0.4724082521314615,-0.7752071583944158},
{-0.06750315709032623,-0.4874795785419589,-0.7797558516814384},
{-0.05955445875676526,-0.47135388609482437,-0.7863083410867119},
{-0.08808562373410991,-0.5602696854044099,-0.7430092427749392},
{-0.09502100921954483,-0.5461978539395641,-0.7499726645842353},
{-0.06891859092640425,-0.5318218283608241,-0.7636728144984641},
{-0.058317055577205824,-0.5088646850859974,-0.7704654149916631},
{-0.05455638325013888,-0.49712807913933293,-0.7780638595364153},
{-0.08070125654798357,-0.6536813095045941,0.2994169245674696},
{-0.09117082091557822,-0.6234094893343816,0.29410884742272086},
{-0.07921052515639262,-0.6107617028622282,0.2771819168915246},
{-0.06627296325118823,-0.606084042485444,0.26319960140357845},
{-0.03928239427001624,-0.5904151418577909,0.24149127609731164},
{-0.06233225767304119,-0.5848357131499571,0.228755775983364},
{-0.07488031493603112,-0.5970229028729621,0.2082468045599879},
{-0.06529349425115179,-0.616892646112303,0.20258446843730735},
{-0.0642066861826182,-0.6299081089459503,0.20486342104831015},
{-0.07722254953517778,-0.633999209375667,0.20786190588526493},
{-0.06770982484907447,-0.6338558236050628,0.19395969417977932},
{-0.0707771989389453,-0.6409171722884167,0.17141448460625583},
{-0.0668733411007301,-0.6497802552987649,0.15710714802097597},
{-0.06981895744126089,-0.6637473510680437,0.13791227914886525},
{-0.08774958836668788,-0.6516845224673086,0.14705832877075534},
{-0.08317726446383934,-0.6592949825794299,0.13229500140381875},
{-0.07659393510231856,-0.6630176056098281,0.1247710533767549},
{-0.07443714075956809,-0.6588594182623005,0.1212186508840854},
{-0.06846380170148443,-0.6540425775634913,0.12292085626137221},
{-0.07035805589722043,-0.6374761140533676,0.12672698748498554},
{-0.061367607872759945,-0.6580826118318893,0.13681225395622568},
{-0.06507461066557832,-0.6447431291981891,0.15296858610015135},
{-0.0698646165972634,-0.6322455373181493,0.16289504682266343},
{-0.07060137113644438,-0.6259643994759609,0.17634166826540462},
{-0.06576069956235299,-0.6227690595936094,0.19122014481962826},
{-0.06649124605839325,-0.5992083343179423,0.18138039644162976},
{-0.061457324109115766,-0.5960586535915932,0.18685669152954568},
{-0.06119117929189057,-0.5917694965597428,0.18365033737710576},
{-0.0666730816445787,-0.5885851709474794,0.1986157265352991},
{-0.09898814904590386,0.28473550331809894,-0.8366261328176786},
{-0.08675590094526468,0.2784914134752986,-0.8265250458494025},
{-0.08674088148605331,0.28623945183379584,-0.846543982383576},
{-0.06648103282612954,0.2704515970891887,-0.8345590547112839},
{-0.05416687860792443,0.25954827073957015,-0.8057845744947153},
{-0.045690696866860704,0.25695431000404123,-0.777777688773575},
{-0.059288914717908515,0.25864690292743275,-0.7710303469174662},
{-0.05210080179881054,0.2583112680789231,-0.7580483274129962},
{-0.03816835091544605,0.25804812715354014,-0.7541723056391861},
{-0.04196847435537482,0.259950191468066,-0.7326772566537205},
{-0.05114956938209144,0.26416485198222817,-0.6874730901355796},
{-0.0505095401602316,0.270754789905802,-0.6389528272830279},
{-0.0670677930326531,0.27099590229100823,-0.6282932166915455},
{-0.06369482301269525,0.2666416609359085,-0.5881195677119275},
{-0.0956832672410375,0.19979665654822387,-0.9504644217047605},
{-0.09447289908805849,0.19908333236541262,-0.9213667227259638},
{-0.073459474094637,0.19212591833980103,-0.919693955488731},
{-0.07844253014205203,0.18776106323352534,-0.9482601658709023},
{-0.0470011947479154,-0.6855956577341602,0.29448974090832075},
{-0.04431952037059214,-0.6671032990342287,0.2805600936573424},
{-0.06313129290308524,-0.6466722285392955,0.27955078599833943},
{-0.06788865654341765,-0.6277523159004805,0.2750970156935325},
{-0.04554190409094022,-0.6123635782519833,0.2556466157553726},
{-0.008341507256801915,-0.5888238802192121,0.2282981831260581},
{-0.02303834848429625,-0.5677718051507533,0.2269374201215094},
{-0.05244304520937327,-0.5731653930832786,0.22273137076396177},
{-0.05959851583711857,-0.5567685493325152,0.21186869708394193},
{-0.08069324616973751,0.5484866192639183,-0.7622029100903129},
{-0.056049317495747486,0.5514969194087859,-0.7587358181259639},
{-0.03725536805485187,0.5375087963966114,-0.7427010434719221},
{-0.02009873992745,0.5129908309205407,-0.7264253566921303},
{-0.032714885405531406,0.5076256798307888,-0.7156409844594657},
{-0.019832194591312507,0.489879287605021,-0.708028722012239},
{-0.005295160409826973,0.48401068424250454,-0.7124418396474471},
{-0.01704578451842207,0.4825838356174258,-0.6781011478471507},
{-0.0346952511674125,0.4807019975079712,-0.6702866233492112},
{-0.04598728112142091,0.47837838703824664,-0.6759565693312255},
{-0.03531905937332408,0.47504486813115065,-0.6554049426436891},
{-0.04705646635781318,0.45850083368011585,-0.6313902291809268},
{-0.05756167690860278,0.44652872261301746,-0.6168127425892986},
{-0.05826358630241341,0.44638033035600916,-0.6073012194599322},
{-0.05540828697660689,0.45277281245581774,-0.6000085711047233},
{-0.06512607734580923,0.4576046726138385,-0.5908625214828331},
{-0.07776104721276884,0.4631542626627057,-0.578799692882098},
{-0.08696276896346906,0.44958027620585234,-0.5855752713215241},
{-0.08903044784823216,0.46091195753217873,-0.5688075470579682},
{-0.08402596403900894,0.4794551821339727,-0.5686255112123266},
{-0.08944999140886932,0.47003557809497987,-0.5410149389549099},
{-0.08583751107935442,0.46435962432928096,-0.5158689598243484},
{-0.0431974666377759,0.17814440388967945,-0.8855330966800586},
{-0.05936561408961451,0.18391147570792718,-0.922906918203224},
{-0.052988952486841955,0.17596798412022616,-0.9298713413098009},
{-0.03488029090489639,0.16546397512617347,-0.9212181302094994},
{-0.04154692820017615,0.16367025117742545,-0.941935571726729},
{-0.049260121413303076,0.1679876447925933,-0.9543272263544648},
{-0.06382379010245674,0.17828038006040625,-0.9615529880513193},
{-0.045818862918797595,0.17831983117326808,-0.9643860585774929},
{-0.05045687192326378,0.1949806168872391,-0.9683137472909901},
{-0.051691671729893245,0.20650354599419005,-0.9635800142664834},
{-0.06043379802872602,0.22116714415196326,-0.9520957352345697},
{-0.046178128383133184,0.2222050889131959,-0.9349060642969029},
{-0.05956607380522204,0.23877615839081112,-0.9298577236667825},
{-0.06565255945603123,0.2552787391344225,-0.9203251732945201},
{-0.08206942915240985,0.269827588623821,-0.9090069093517562},
{-0.0786297727335536,0.27354420387053463,-0.8962575913353339},
{-0.06788024564625929,0.2767105061317443,-0.8807515016455318},
{-0.07460255507034916,0.2821497532202722,-0.8661301582330065},
{-0.10321722824090891,-0.6656492151231135,0.4400297024825363},
{-0.10472177753497429,-0.6665567909783915,0.4489102080655697},
{-0.09957631106862048,-0.6603331276001186,0.4554034206718224},
{-0.09627002744756107,-0.6648415687364548,0.437580729593261},
{-0.09949901091854606,0.22523841889552101,-0.4167251090512868},
{-0.09648931155204682,0.2596708295267348,-0.43340211578120613},
{-0.09578299645020089,0.24406160621701475,-0.41687490312448805},
{-0.08566869235781878,0.2202994199284593,-0.3863070994780838},
{-0.08394245584579381,-0.15639322305979625,0.7406255544683691},
{-0.09130920019977884,-0.1527454970659987,0.7594841877136017},
{-0.06875337687507936,-0.1218164253606973,0.7636531890717614},
{-0.06809892897237661,-0.12000808247165026,0.778121734519243},
{-0.03996467823712402,-0.09207188833853139,0.777451065600592},
{-0.04681875838336148,-0.11624200313926722,0.8088223101850757},
{-0.07098046228693895,-0.14873029497016332,0.8259388864212475},
{-0.06716892405800956,-0.16500057474463914,0.8447035979815447},
{-0.05674161443566284,-0.18681804145450842,0.859819582250764},
{-0.0745673094060665,-0.24100524639723223,0.8756188517843718},
{-0.060668902630247754,-0.2501787315646151,0.8754742644570306},
{-0.08256687364148992,-0.32839506865094414,0.8762652893088285},
{-0.0785831122802703,-0.3637122255594348,0.870978840185344},
{-0.06145452047672965,-0.36448642861691605,0.8639313094044643},
{-0.06886412035433107,-0.3995538619835859,0.8549636909580052},
{-0.09949120079975617,0.48666312073922974,-0.5060199995113669},
{-0.09989973009030499,0.49682428554435115,-0.5305559883384913},
{-0.10011200511382548,0.4926010138735745,-0.5420210424626145},
{-0.09841560726076705,0.48222416963417797,-0.5367544190252891},
{-0.09297415731822148,0.4872909341342643,-0.5599172287615835},
{-0.0874059431399321,0.4986352318063282,-0.5700475536104577},
{-0.09000651243751405,0.5028090393914355,-0.5567995895482186},
{-0.09525491226432967,0.5005076577213438,-0.5329182488832531},
{-0.08766688121129736,0.4873458052252498,-0.47822538881374704},
{-0.09062271078409187,0.4759338198570066,-0.47259809809589304},
{-0.09795961647911032,0.4779770670881194,-0.5046594367662743},
{-0.09410221883472225,0.47200813373807093,-0.5105821101819517},
{-0.08023365071787009,0.49341767193576,-0.5823559003044344},
{-0.0711755149972304,0.5021603990129612,-0.5907868234084079},
{-0.07166354729187135,0.5097344119040629,-0.5726563335457419},
{-0.07671769544622012,0.5104823809727883,-0.5361342154895883},
{-0.0827885608594495,0.4988979722127989,-0.5080518319534788},
{-0.07806664314285587,0.49309004746549623,-0.486883005622084},
{-0.07036446419981728,0.4946316447589497,-0.4654730669054827},
{-0.0625419293236317,0.4943973411952526,-0.4360843909368978},
{-0.08003579437519248,0.47549905657770203,-0.4492450418762548},
{-0.08681157307407476,0.4442613850504714,-0.7671395059439009},
{-0.06347493812984102,0.4511328877693939,-0.7858024857004735},
{-0.051927577369239586,0.451771915693973,-0.8022043359376407},
{-0.06320779201533507,0.4536391348631286,-0.8129468539439697},
{-0.0628887787016859,0.4477871530354728,-0.8256559198097053},
{-0.05199726765998027,0.44259843052659015,-0.8469030475884557},
{-0.0502289766621635,0.44202408640634805,-0.85938582026874},
{-0.03885484033113302,0.4498131779533564,-0.868978648737304},
{-0.019070007101200322,0.42790499370985036,-0.8688570912474199},
{-0.00844183724433376,0.44217187788498785,-0.8799424534426803},
{-0.0372745929626424,0.47234436936494917,-0.8856640663643816},
{-0.0135698811380024,0.4579369030515935,-0.9063090139584846},
{-0.025821354146432125,0.47878471347477786,-0.911100621965819},
{-0.006219758318877941,0.4671346196131707,-0.9184553507524349},
{-0.010359521796439468,0.4831910222884769,-0.9205795028038324},
{-0.008084374115103533,0.4966869075574313,-0.9175033172978911},
{-0.00910449578473871,0.5053359132091536,-0.9068124662312491},
{-0.030415906848913456,0.5223337355878276,-0.8857842220380724},
{-0.04223261657803851,0.5276924783749826,-0.8566322527466584},
{-0.03368173805983032,0.5167180599184303,-0.8344763475558934},
{-0.03276414923174466,0.5180439777776087,-0.8247589577056033},
{-0.03368093702200571,0.5294087019142001,-0.8214652904302814},
{-0.04769449298511151,0.5412987066042765,-0.8217378435501033},
{-0.04465875988931259,0.5521083115284162,-0.8056698258263405},
{-0.06024415232375065,0.5568212175694829,-0.7870991656790537},
{-0.07665321190133936,0.5531250287872967,-0.7922009755839665},
{-0.0897129320747961,-0.29495494362496044,-0.12641137858209095},
{-0.07772359869446856,-0.2692862873138438,-0.1406113760988737},
{-0.0702164724617214,-0.24249617804827936,-0.11139692585714052},
{-0.07867903655976682,-0.25244526808933654,-0.09432440670132224},
{-0.08598630385527488,-0.2767952158816963,-0.08365878832615536},
{-0.09241543343555911,-0.2987949186966634,-0.10757497413649124},
{-0.08768129989214025,-0.3846205143383768,-0.017476041959963336},
{-0.0857143515138213,-0.41151616033733307,-0.018983394886414845},
{-0.08563164435843078,-0.4324360641647318,-0.02098198425880572},
{-0.056839541309720874,-0.4723217400464041,-0.0072940501714020755},
{-0.04614628712960512,-0.5059705354256976,-0.010843248512773159},
{-0.05521924204999997,-0.5323184718120797,-0.033618956720326866},
{-0.06847421519320432,-0.5462212842959338,-0.05139078189702579},
{-0.06015984309271091,-0.5712607253958228,-0.054532852764041094},
{-0.06273938514739696,-0.5970693630667894,-0.07190395876898109},
{-0.08077054631981194,-0.612992993722667,-0.09883905588079916},
{-0.08773597072366958,-0.601532145047123,-0.09705033841845495},
{-0.08430332338577862,-0.6311082638666656,-0.11642363846599653},
{-0.08813008133337552,0.34935702696413473,-0.44725766703340847},
{-0.06608872455152896,0.35056959797113135,-0.39679668979129357},
{-0.0575847067460602,0.34679610903887076,-0.4216601028292255},
{-0.059982212955104634,0.3449435088100143,-0.45294723844212564},
{-0.03345724720948461,0.3495330550260918,-0.4574458668651104},
{-0.018665683259230657,0.35725966562278083,-0.5087004723319533},
{-0.08481979252319305,-0.06644508625375035,-0.41065504467588204},
{-0.07085349779173897,-0.06660709615377683,-0.3891842270846108},
{-0.07151695736996852,-0.10153574971733376,-0.39563878961582627},
{-0.05624276813038973,-0.12485175793758391,-0.390767878863856},
{-0.025832368416520445,-0.12623414896339696,-0.37262076746632933},
{-0.0021604991426892694,-0.14852703162216968,-0.372387465199913},
{0.01808533135530393,-0.13015242548245506,-0.3552462570506348},
{0.04404836906696315,-0.12472899889096312,-0.3391776385485034},
{0.05095091200158925,-0.13320337829692147,-0.3377950472632342},
{0.0373981530470878,-0.1674309235044924,-0.3609532510320371},
{0.03391664240189589,-0.2061631049187327,-0.3631985600544065},
{0.02676077125523828,-0.21432087412451573,-0.375616448670898},
{0.03681800140261722,-0.23342502546298982,-0.3623176187067965},
{0.03113644037214615,-0.2512172771042162,-0.36136798836572664},
{0.04326735718797273,-0.26392233778082885,-0.3367953520581265},
{0.039865149287416766,-0.2770205077698666,-0.3250895860677093},
{0.03191985536461039,-0.2866023219683421,-0.3256717403067414},
{-0.08845209853886694,-0.27819122455052764,-0.05404361891266325},
{-0.08476952739969905,-0.3100186601761242,-0.02274046254327107},
{-0.09542373098586528,-0.35626257379060305,-0.03701876150740901},
{-0.08949525004595954,-0.35105863156305306,-0.021198865249817674},
{-0.07841589563438392,-0.3486855570076591,-0.003900453427460633},
{-0.06941923956678271,-0.3727903872256896,0.01120992357698633},
{-0.07207187632296404,-0.4181631722059099,-0.0031560890289459125},
{-0.04537008147756232,-0.42503147077353415,0.016423277998975465},
{-0.03557679329339092,-0.45480644723303504,0.014048801627388436},
{-0.021234611562740684,-0.49586704534394765,0.011094774389699283},
{-0.041254148875282816,-0.5477262341089115,-0.0276588347863492},
{-0.036633762702957956,-0.5781057938665334,-0.03951639744452914},
{-0.044358370705085505,-0.6040073519251541,-0.06464195011056326},
{-0.05939525248912491,-0.6277679361380604,-0.09065765605919028},
{-0.0669586516290506,-0.654903492965486,0.47637899662803124},
{-0.08559619843469199,-0.658455294679787,0.46342501344742243},
{-0.056639081594113336,-0.6640765776139566,0.4681867827957902},
{-0.06581677221007538,-0.6735142050040032,0.42523253126751015},
{-0.075430427662079,-0.6773563829297237,0.41237887807443313},
{-0.0917884210783491,-0.6754435046045657,0.40969700343765375},
{-0.08964965008665225,-0.6765823801316986,0.40418746528001676},
{-0.08982527762969703,-0.676506281538361,0.40478984572412013},
{-0.08939832446918226,-0.6780092287567772,0.4027880522004308},
{-0.080785165260111,-0.6766070120448051,0.392268022449886},
{-0.06618565012830623,-0.677494361695012,0.37990380336764307},
{-0.046731645519935625,-0.6758490300032722,0.3733256807519822},
{-0.03112502558314552,-0.6831977510062036,0.36611593981161994},
{0.0056604336578471,-0.6862789429985487,0.35340807550262116},
{0.01961751645431821,-0.6948913011697955,0.32928602297136167},
{0.05560173761124912,-0.6993701039066215,0.3256885621010581},
{0.1027920774154995,-0.7043860025048453,0.3261894110008927},
{0.06409333933043651,-0.7043034956089109,0.2931029441744724},
{0.0470023963046523,-0.701404139202751,0.2812367703596779},
{0.012319661353249264,-0.7015859747889365,0.2880974590679684},
{-0.023913081788765528,-0.6945468549052152,0.28891351635178536},
{-0.08111479232493618,0.305995848220955,-0.47981384681993994},
{-0.06504697486062944,0.31603946072531575,-0.43608258860179244},
{-0.06443998844903456,0.32087312321844175,-0.36812694527029216},
{-0.06773005105414574,0.3128573379670701,-0.34511893609360283},
{-0.07114307296533388,0.296697801671846,-0.34843443164964527},
{-0.07084008040817684,0.2846239588010226,-0.3565445391048642},
{-0.07448700536414979,0.26477964851261293,-0.3726351861471722},
{-0.08237802897433914,0.25142054045220985,-0.39045347151769827},
{-0.0885952840500152,0.26484733620879203,-0.4212313473336054},
{-0.07248861625121508,0.23857269478336132,-0.35560231836367195},
{-0.0751869121633989,0.19228712720200292,-0.34383647453640936},
{-0.07579269701825685,-0.2833352892006884,-0.1689350722796455},
{-0.07084188274328218,-0.2857041583075032,-0.19239586808669312},
{-0.05221334761316762,-0.2647301844269435,-0.18793208480907864},
{-0.05841057674322852,-0.2604346190924962,-0.16733039325750443},
{-0.07593988771852812,-0.3400930245225714,0.6774893552086082},
{-0.07003984362139588,-0.3355815794943929,0.6833149027880521},
{-0.062256559598615965,-0.31988183891049243,0.6853579497597085},
{-0.06278884923306637,-0.2927957461687362,0.6891252306488286},
{-0.04582527122139444,-0.26920358015845325,0.6899649185484714},
{-0.047670461850373345,-0.242183573037227,0.6993010143942492},
{-0.027942502305987642,-0.20443786970398845,0.705044455596671},
{-0.03499083412469196,-0.18941040011438817,0.7074147265196788},
{-0.0597541174345482,-0.2061729176320841,0.7105415776680266},
{-0.05395900929243928,-0.18049665146163366,0.7106282900125401},
{-0.050158685593054364,-0.1524825564000719,0.7159273554817621},
{-0.07351554674235938,-0.15689287040289399,0.7285697349485993},
{-0.06978451281480286,-0.13328868882524197,0.7459544585965576},
{-0.04375839337445594,-0.10668221748096833,0.7396338696415075},
{-0.044075804612455895,-0.09516089044966658,0.7619543881052291},
{-0.007008980835570568,-0.05346326700873651,0.7566505164090596},
{-0.005312582982512144,-0.06093755069067483,0.7809131510785373},
{-0.019267262665509433,-0.08832343183828967,0.8021951240026578},
{-0.03318529486803102,-0.11774154594692882,0.8261950182656648},
{-0.030211441944182887,-0.1418385660461694,0.84539329154853},
{-0.005719309937955618,-0.13803023196853842,0.8480164901646572},
{-0.04877869768071513,-0.19532426211399487,0.8643132041873451},
{-0.03834738286924539,-0.19972596496020242,0.8649049708802725},
{-0.01472557845945207,-0.2047813146712881,0.8608240836828194},
{-0.011037199796055771,-0.2345362651851739,0.8616555609447598},
{-0.047516862847505226,-0.29794061185672155,0.8712005274033034},
{-0.04734043426663585,-0.3287130806673126,0.8668020287083946},
{-0.042400834521205674,-0.35454094324606955,0.8553666129837819},
{-0.05465451038365306,-0.38995722858535514,0.8463515330462145},
{-0.0746171740106482,-0.44016948358292995,0.8396640687674951},
{-0.06075561497476129,0.41828673229035535,-0.7279735625476367},
{-0.05821432247620016,0.43699416964619364,-0.7631174950265563},
{-0.03683722631040777,0.4359606305929963,-0.7817502356052501},
{-0.04134726952239321,0.4462199225316319,-0.8088048876123906},
{-0.04437919768852526,0.4368439750540801,-0.8342262234951603},
{-0.04535466149943867,0.42966867874017567,-0.8506424924131705},
{-0.042368993267677596,0.43385770604395046,-0.8647924250659154},
{-0.03171118501130064,0.43055582813092635,-0.8640678863535597},
{-0.03394007275826561,0.42340195957883026,-0.8532751032237367},
{-0.023223588481236287,0.4069264138617994,-0.8610770113759385},
{-0.015014552854678526,0.4157256141056353,-0.8686998875743414},
{-0.004411815948743193,0.41529966224240117,-0.8657863127467947},
{0.00046910777603462433,0.4289377317252232,-0.8712533958997277},
{0.018023651442809298,0.410295178433178,-0.8618800517951057},
{0.021546415535968394,0.4139735441237668,-0.8797810443210221},
{-0.009787781049127251,0.4473327643294652,-0.8930039759512423},
{0.017145513727585455,0.42927256553590837,-0.9011607438597448},
{0.0049857595500730715,0.44860200876255263,-0.9129742494375711},
{-0.07100028797309796,0.30389072081789165,-0.48428383814069503},
{-0.05999402826301756,0.3128583392643508,-0.4600612553624475},
{-0.0413881224514481,0.3132254148474764,-0.45054792989797576},
{-0.04246611910391102,0.32465021682091316,-0.41964729503544795},
{-0.05276025618791706,0.3241377528726217,-0.4008457357352185},
{-0.05576074361943334,0.3382836803362436,-0.3818202863630119},
{-0.06530230566722245,0.33855623345606567,-0.354808690138944},
{-0.061735284234253895,0.34463611054482185,-0.3361567246524597},
{-0.060586195474857225,0.31926924523412525,-0.3294155908394916},
{-0.06104278703488239,0.29005859992205896,-0.33394005273231997},
{-0.059605524918083866,0.2754863200762908,-0.33658588066699213},
{-0.06050909558423894,0.2585842217176574,-0.32804561589995995},
{-0.07916146158963552,0.24822620186713903,-0.37230155389322406},
{-0.06455493737686548,-0.35535880286499183,0.6788549244401045},
{-0.059281905636943216,-0.33361883656465313,0.6847519646453946},
{-0.04861708829960096,-0.31883928818176827,0.6836981993871258},
{-0.04508130734179202,-0.30120003476504154,0.6874372436929285},
{-0.031836947949763716,-0.29043108251050054,0.6905224408743967},
{-0.01772145992347686,-0.2615528678956456,0.684703702116462},
{-0.01943568086813276,-0.24054244679406633,0.6903013544348057},
{-0.016345076681348356,-0.2205956036641072,0.693707968043397},
{-0.007981440754641717,-0.1965312258562193,0.6973432779509131},
{-0.008606250257834054,-0.1768655470026967,0.7022492341077099},
{-0.008981736738117908,-0.15701022244419868,0.7029831850145046},
{-0.02860055487890111,-0.15698819390402202,0.7068910480418429},
{-0.054114811149325065,-0.6700797553310068,-0.6489353606532623},
{-0.020744977192450543,-0.6647724792240828,-0.6711172995733271},
{-0.0041354578992542764,-0.6585305922353001,-0.6826790790147714},
{-0.01791350874192604,-0.6371166483295757,-0.7024687184716518},
{-0.030449350178090733,-0.6159249924201795,-0.7251745361290087},
{-0.040528208346734027,-0.5957893046230697,-0.7368524660550209},
{-0.06972103056720286,-0.5747686702892266,-0.7386079404476439},
{-0.040975988490688536,-0.5719420080656498,-0.7483798008700071},
{-0.06036490877580994,-0.5503244002930197,-0.7603935659039852},
{-0.03156319327320477,-0.5451098443142937,-0.7683867218368118},
{-0.018645457054159376,-0.5071997279675547,-0.7800151876771545},
{-0.03312962273922093,-0.4928545423450622,-0.7879578782270309},
{-0.018226314012434512,-0.47016955167114505,-0.7934734241683524},
{-0.04662570826763155,-0.4478442269804759,-0.7887475012626358},
{0.009573503431045259,-0.4488234957210561,-0.792724053283434},
{0.028030215947781937,-0.43778579527636,-0.7901941755738734},
{-0.013059219524816357,-0.41946946463838547,-0.7971481851887305},
{0.008715591920892702,-0.39533139135063383,-0.7997201173840828},
{0.04076651709955417,-0.36753197442606633,-0.7931464004764572},
{0.0489118702190558,-0.34338549024115644,-0.7855059014459133},
{0.011808999740063221,-0.3469555155659672,-0.7954125364822663},
{-0.08114142683260431,-0.6759687851580507,0.4028335110969772},
{-0.05953543410843089,-0.6741624448635651,0.3827048323808326},
{-0.0535078247377302,-0.6657048872519236,0.38064035764736787},
{-0.056051119830852855,-0.6736019186457974,0.3793168429016634},
{-0.05138827865382389,-0.6719123296142482,0.38169252082998734},
{-0.04541574063356484,-0.6490621248890062,0.3815261052219255},
{-0.0425275987569495,-0.649141427633642,0.38016093650934146},
{-0.03692313761709671,-0.6690476180940026,0.3776665047235197},
{-0.015681416843662654,-0.6726122364134973,0.37407645345309376},
{-0.011385450990303041,-0.6809894899832222,0.3699633244832004},
{0.011909930505963522,-0.6780717097070964,0.38181387806041506},
{0.03949066410441367,-0.6836913905656168,0.37276054856672297},
{0.04289447408061884,-0.6915183311498376,0.337524897256886},
{0.0833162445264084,-0.6982114026933294,0.3491301330003152},
{0.10370506027609369,-0.7026387387499243,0.396183495336558},
{0.1393530458061464,-0.7042053684753967,0.36248303301757756},
{0.12898981920976815,-0.7019620620475888,0.3236841652044388},
{0.135889358252552,-0.6941118913664543,0.30979577140142767},
{0.08772335437793204,-0.7005444253574932,0.2886491738696655},
{0.06459358745190268,-0.691369338114461,0.2649871173091857},
{0.034340191151656076,-0.6901725876045004,0.26553122225154907},
{0.0037313343167407627,-0.6937285947673806,0.2793387112342751},
{-0.014658291282185203,-0.6709070271443682,0.26610196170158057},
{-0.03937451361984587,-0.6392185715813407,0.2635186147172276},
{-0.0008710285045304708,-0.6070755270528495,0.2316032651903806},
{0.02650984615668059,-0.5790704436668146,0.2119391884125072},
{0.005241691135034548,-0.5576382761505806,0.21576754843575333},
{-0.0008257698674402615,-0.5319241609429176,0.21391234483396687},
{-0.0262230746154718,-0.5394927668287033,0.21240218827512924},
{-0.018509480883432572,-0.516076228361465,0.20581485372448544},
{-0.0330519220702342,-0.5033553471878165,0.19985433127159544},
{-0.0737622663923379,0.28335711748140885,-0.5243663690677641},
{-0.063759306557576,0.26858297610384013,-0.5533379045891856},
{-0.04260409786919933,0.28664978345945,-0.5025925589193359},
{-0.05180702117663645,0.2930767101857166,-0.48918879300021106},
{-0.07925037678816674,0.294238615550307,-0.5031604947369812},
{-0.03304170883797048,0.3033980825557592,-0.4657005616476707},
{-0.07660094418328386,-0.31444159052468373,0.0039068617300574504},
{-0.06757344815943536,-0.34564221405252643,0.01437963024895053},
{-0.055270107951862435,-0.3467706760879395,0.030219552452156996},
{-0.05751641827151257,-0.3917886013118596,0.018034165064257243},
{-0.015494975289985707,-0.3714862976472317,0.05482042534307448},
{-0.002809339780619776,-0.4012594717716273,0.052340211978639514},
{-0.002808939261707473,-0.4318266746396631,0.04174989115898557},
{-0.005639005896038914,-0.4665254303475582,0.031700871649308834},
{-0.006498118962928373,-0.4937893534863769,0.018951753892342906},
{-0.0033995043978979228,-0.5265608121882711,0.005811529417513317},
{-0.01282691855568074,-0.5546780408697507,-0.01526718015861351},
{-0.013284511412986668,-0.5801782789782441,-0.030306465056126726},
{-0.013606528618478103,-0.6010577303955003,-0.048170409582655296},
{-0.014808886393211049,-0.6184738947780745,-0.06017095749252732},
{-0.036632160627308744,-0.6220525312594997,-0.07163881524903666},
{-0.0330086660277055,-0.6404665885120763,-0.0871064551232577},
{-0.06041317130474242,-0.6444259182196453,-0.10969071529073068},
{-0.06543167327589625,0.5553212742429091,-0.7712235972926523},
{-0.04297718123600937,0.5524565627226634,-0.7672953078007867},
{-0.025962336803562698,0.5428553233569411,-0.7591615697297418},
{-0.014205104132914604,0.5284186191629876,-0.7490638871722203},
{-0.0009206928496560206,0.4980130256760658,-0.7299899750116251},
{-0.07469567571745954,0.4290308523723336,-0.4073107117581539},
{-0.06770782225451294,0.42014514004344033,-0.37022326125728494},
{-0.06314551132447198,0.40982897441925764,-0.34742171957988766},
{-0.06563593792117066,0.398617448766622,-0.33570874424904906},
{-0.058349097090190045,0.38499920496995904,-0.3119609766413365},
{-0.04701741576386366,0.3580066333942255,-0.2756633494355286},
{-0.05769545022531191,0.3702857422076042,-0.3103480869814932},
{-0.05434110433477614,0.3671312552543075,-0.32558382640549094},
{-0.04278112722843716,0.41444775851593324,-0.727733251200255},
{-0.025537185978153302,0.41193229948721566,-0.7394598441741119},
{-0.004087595889234096,0.39980538786051206,-0.7427513085954162},
{-0.022406329640682465,0.4267358790048386,-0.7862955244815182},
{-0.02411454280165383,0.4319213973624227,-0.8068056974616313},
{-0.028377065325836157,0.4303231266428785,-0.8231368561107771},
{-0.03214194310148228,0.421785064729864,-0.8421715174179665},
{-0.07487370637397812,-0.011810902204896659,-0.40437010190402684},
{-0.06689977534894209,-0.0290442297040045,-0.37989158754081787},
{-0.0518430678787437,-0.034548160596869305,-0.3576810115185234},
{-0.04655982290655774,-0.0800547188937988,-0.3664067165419517},
{-0.004956922188387276,-0.11940790488156454,-0.36016202592078295},
{0.00738626965095978,-0.07575034214328083,-0.32626510907531797},
{0.03647976318117752,-0.0970879871962114,-0.32554337399534833},
{0.061540632042874736,-0.08111168830336583,-0.30356289608817183},
{0.06400702750483525,-0.11259688051839961,-0.3158898669115706},
{0.07275936703593174,-0.13525503642519246,-0.31314851521631426},
{0.07137417237773258,-0.14591544805449938,-0.3205653244343371},
{0.05957708807531036,-0.15473827891416117,-0.3284863869629492},
{0.05204152499978972,-0.1559398356510695,-0.3372024795324823},
{0.051278536471852924,-0.1864994286597716,-0.34553247187055547},
{0.04038362101939272,-0.19487187600254888,-0.3543883455404822},
{0.043891766172252766,-0.2246624726996296,-0.35014264481061663},
{-0.07775443865071587,-0.24067902374316164,-0.05204342746462317},
{-0.08355715665215853,-0.25818129969188075,-0.0750175927932229},
{-0.07913182319012513,-0.2707974451699622,-0.018050786599117824},
{-0.07372822228479217,-0.2797474407842801,0.006031214040911394},
{-0.0686876917734617,-0.29430530194920534,0.02070903062007136},
{-0.06050008390871212,-0.3140809232441551,0.03213583518806965},
{-0.02545427856330662,-0.3197312437994666,0.06129080837132587},
{-0.0723332149132416,-0.20541813974184953,-0.05378788758715792},
{-0.07415657726149999,-0.21775812742989817,-0.024005902046691705},
{-0.06877901008546673,-0.2195670710973137,0.005169097082179661},
{-0.07069589359974783,-0.2516398245566956,0.015047095016303106},
{-0.06110947343378081,-0.2579658205170619,0.03370326595136658},
{-0.05034072143869597,-0.27330469356097753,0.04534534943472763},
{-0.03022185543590276,-0.2826447945958784,0.06550086291799653},
{0.004636106539632746,-0.25663529669039203,0.0991408468812193},
{0.005105915223763903,-0.3260972916510631,0.08267291102352206},
{0.01945931148395861,-0.3502137369175503,0.08456636418143346},
{0.02404144810015856,-0.3822111928214194,0.07010142340416242},
{0.021612701415954505,-0.4130431386904874,0.05712080571588549},
{0.016252356553150257,-0.4526324305770556,0.04441294140688676},
{0.013176972085033364,-0.4760193306447833,0.035740104879882356},
{0.013684029028008683,-0.48454677880662184,0.030276225878247846},
{0.016548540288798163,-0.5146577906335448,0.015425985907341537},
{0.03103310649277203,-0.5416906143599648,0.0026426237833737246},
{0.005050243094953817,-0.5500348251194246,-0.00839107147219939},
{0.017988606037982805,-0.573046839485237,-0.02008342007905443},
{0.028144964616156686,-0.6018797954630017,-0.03933436159888753},
{0.0025926590490639614,-0.5968392649516714,-0.03841036446820501},
{0.014937252704604078,-0.6178156419457048,-0.05582913222370904},
{-0.008291642652220217,-0.6348473081724683,-0.07173734290146314},
{-0.01355466141933489,-0.6580063129790957,-0.09950571961032714},
{-0.03754053752041144,-0.6601711177000923,-0.10783571194840035},
{-0.054510323575224055,-0.6629485160974559,-0.12025259926761112},
{-0.020927814075916762,-0.6739155249541304,-0.11472383620218354},
{-0.023288472545029335,-0.6832099668330288,-0.1301596348228765},
{0.0033812807873881334,-0.6902318644035211,-0.13734674644469375},
{0.03555035904517893,-0.6971588389917976,-0.160346745243137},
{0.06241576586625631,-0.7013052110314123,-0.20994620630488858},
{0.024062275083598303,-0.6973094341028235,-0.20947980203151198},
{-0.006252400610230617,-0.6924651578585215,-0.21293527894740422},
{-0.026612979776598565,-0.6937704489937162,-0.21270858524304087},
{-0.015030773870626788,-0.6866948818889753,-0.236455752072385},
{-0.014360705730344234,-0.6796920089668174,-0.26911186132753595},
{-0.03014295321017911,-0.6782505414014397,-0.27948109570759877},
{-0.05234591937313984,-0.6822331012059223,-0.2988285622852968},
{-0.05760853762134221,-0.678515684921384,-0.31330171370027005},
{-0.06450787640466989,-0.6805162768883365,-0.3416848869395188},
{-0.0683350348711791,-0.6842348947296116,-0.3650828012773349},
{-0.05447848232169599,-0.6818299789206896,-0.40988004058057614},
{-0.03287489271099637,-0.6816962056039805,-0.4664491314947646},
{-0.06961289046088112,0.46997630129595896,-0.5816339649650086},
{-0.06631742085045383,0.4780075065254544,-0.5872079866675264},
{-0.06002967444621251,0.4976988185893643,-0.6022508762352504},
{-0.05444624054925561,0.5071282353417087,-0.6007263009955698},
{-0.049187026711807816,0.5148742711056445,-0.5886404425573774},
{-0.04948921823114026,0.5184807436514747,-0.5606137311500781},
{-0.055132729964942576,0.5196800975343655,-0.5371931874937168},
{-0.06681847000974461,0.5107719561463832,-0.5125584707547097},
{-0.0527864901766729,0.5118325302261609,-0.49478003701595785},
{-0.06456775398205915,0.5019779626484072,-0.48328013774646433},
{-0.06007933879133806,0.5112615905166734,-0.46720410964445536},
{-0.05963195916629585,0.5098872098691064,-0.4530878205803438},
{-0.044796338135688604,0.5201577163372866,-0.4446042292394025},
{-0.05017570764682723,0.5078247377302033,-0.4256935285355706},
{-0.05933076894424416,0.48699194676623025,-0.4194324166389975},
{-0.07398515516703441,0.4632547929096937,-0.40840192553472277},
{-0.07022548413724822,0.44586586381315635,-0.40118857992414975},
{-0.0670183289469837,0.4312943850052128,-0.38915198531217043},
{-0.06234667635388409,0.44621291345066666,-0.3631314731365957},
{-0.05507245186864101,0.43636455391605355,-0.34251396108798554},
{-0.052391178010230056,0.4211878910316205,-0.34168729005299264},
{-0.05356409764490874,0.4108673196994026,-0.33650797973854923},
{-0.04867035731493724,0.39157152006139145,-0.30725287682721736},
{-0.04261531239874381,0.3721487559281805,-0.282317570644527},
{-0.03381671293327636,0.36913465085364594,-0.2659317411638519},
{-0.025676566559634663,0.3355082845334415,-0.20606738089869236},
{-0.03713140745149416,0.3338513377932449,-0.24091593067978873},
{-0.04607279190919756,0.3493051597649915,-0.2844503338525393},
{-0.03878755315386615,0.34154410454184436,-0.290340364976864},
{-0.046777304675938144,0.35217227439871096,-0.3201179448092949},
{-0.07054289537524816,-0.30652994019051083,-0.25961215350608247},
{-0.04523430556629169,-0.29926592893753146,-0.2605938253601366},
{-0.03819338334746498,-0.28956876529231274,-0.23350492898599423},
{-0.055918147551968334,-0.2880381822689476,-0.2139055360124577},
{-0.06905837202679792,0.35339325630286594,-0.37447837418158963},
{-0.060970293111755586,0.2606176562354186,-0.8431880344173911},
{-0.049570323310881584,0.2484520945336778,-0.820977858914009},
{-0.03616215168372143,0.2378892092595166,-0.7966166965921047},
{-0.036283308654693015,0.24702804954098528,-0.7827729606478152},
{-0.022548714114006108,0.246753894345514,-0.769580268195474},
{-0.020435376073240495,0.24416093490726581,-0.7531091281864783},
{-0.025802529757553885,0.25558113091321116,-0.7414009590825874},
{-0.07002061871360535,0.26172829517923424,-0.908399522421249},
{-0.06583259270711134,0.273413634705124,-0.8911049155285587},
{-0.05388571433148787,0.28042031255694877,-0.8822374268101751},
{-0.05266072723820983,0.27487492795666063,-0.8720500280162979},
{-0.06282269308115594,0.26548175816587966,-0.859355180571949},
{-0.05346216558172768,0.24567449587685805,-0.8458398701357478},
{-0.044936920273906875,0.24195808088960055,-0.8312019051883619},
{-0.03150031180397323,0.23667423513904612,-0.8067792632134192},
{-0.024925994117979258,0.22793571351042408,-0.7874416093490726},
{-0.03040389128154437,0.23363189348119423,-0.7824581527827452},
{-0.024076293245528912,0.23615336029359638,-0.7753839874941975},
{-0.019338755291355477,0.24573437345424728,-0.7785655094740745},
{-0.016962676844119243,0.2484929474627327,-0.7754484710390781},
{0.00223339358472837,0.25112335541928116,-0.7705216878988417},
{-0.0018230619590741792,0.24272807849850261,-0.769314523897161},
{-0.0014385638032635099,0.24005501527779388,-0.7689872999458097},
{-0.00036116792916903405,0.22997215192002757,-0.751485624775459},
{-0.019653563156425465,0.24134588773214574,-0.762237354716771},
{-0.00709729525573333,0.23140600962607152,-0.7439198225220596},
{-0.002448472240634972,0.2329163664443653,-0.7273141081585301},
{-0.012711168590025239,0.24964824426527005,-0.7285292825384567},
{-0.02848560595107021,0.25859844013904415,-0.7123260896817917},
{-0.04966104084451816,0.27517551740034385,-0.5460170196506594},
{-0.0417559990723982,0.28189922864062683,-0.5159090117155787},
{-0.0342412629803173,0.2890909462299355,-0.5025124551368754},
{-0.024453181542005827,0.29386433062676004,-0.4973585777733631},
{-0.07276637611689704,0.17674619236683048,-0.3360297601572597},
{-0.06675498776214464,0.16613664663938596,-0.32405985194417886},
{-0.057097275229787706,0.1688411505947105,-0.3369872006171195},
{-0.0378867861200972,0.16830826018189166,-0.33147986531350015},
{-0.030515836317532994,0.17150159746968172,-0.3510880697031073},
{-0.026566719842227596,0.1727688393082077,-0.3658293685298673},
{-0.017776531273918494,0.17573588341054666,-0.38808039696230434},
{-0.06434065975878347,-0.3739943470760717,0.6786037990820907},
{-0.06174549746651762,-0.3571443161760376,0.6834991414877114},
{-0.05433850096184617,-0.3495670991336375,0.6960455966750521},
{-0.05090144791591986,-0.3340219588498859,0.684912772988684},
{-0.040875057724788236,-0.31498669676432783,0.6883081720677309},
{-0.03898080352905224,-0.3168489094470796,0.7042528299665045},
{-0.028899942765847432,-0.30365261232452767,0.7102806395966613},
{-0.019755294960150376,-0.2822304577811012,0.6905576865386794},
{-0.008636889954625214,-0.2599339704521177,0.6869840565436579},
{-0.006255404502072891,-0.23976684192039205,0.685881027459176},
{0.0047007903439696425,-0.21970945557063729,0.6816978076796296},
{0.008135640535878279,-0.20105728982469687,0.6818578149850947},
{0.008423012855455525,-0.18239010461954505,0.6895421708365358},
{0.015572275440060138,-0.15760739614244212,0.6945478562024958},
{0.03442610245834503,-0.12375173274494433,0.6921561575176798},
{-0.008935476803746935,-0.12636111345859694,0.7052827643494911},
{-0.03392184914775583,-0.13765454522879841,0.7117485414102511},
{-0.048316498855917725,-0.39951861631930324,0.3121868693078752},
{-0.056156656564244636,-0.4044560132107158,0.3370598947997025},
{-0.04413207751963444,-0.40288758115013806,0.3430368385279968},
{-0.053032609048282955,-0.41333391542081915,0.35871054538259767},
{-0.061002534884195964,-0.42252362160415025,0.3746656167730912},
{-0.04687523154999618,-0.4055726599382159,0.3711632791444595},
{-0.03761022781115213,-0.4004115732342823,0.3927488454041055},
{-0.03647916240280908,-0.4201175042384913,0.4275176919216536},
{-0.015751307393859486,-0.4097510734908147,0.44023116349542457},
{0.007584927031461957,-0.4140798818949831,0.4650627352798285},
{0.008802905043774711,-0.42338453700614515,0.4727759284929554},
{-0.0003966138529078321,-0.4349753540687314,0.47758816322427333},
{-0.023586859134694917,-0.4415807119704288,0.4691814715144941},
{-0.006835355887087312,-0.4429953447686823,0.4895200221406854},
{0.002100821824756151,-0.4426326748935921,0.5287542540114972},
{-0.011867074982347132,-0.45186864101129415,0.5447227427855529},
{-0.029937887527080084,-0.4539375214527942,0.5692240867267631},
{-0.03081602524230393,-0.46087711238680834,0.5743072725022539},
{-0.042734066256241585,-0.4620412206054163,0.5843663049847382},
{-0.05146678036063524,-0.4487516025762978,0.5958443759735113},
{-0.05554125925549141,-0.45359808167461757,0.611699117376473},
{-0.05444203510067644,-0.47223082225331137,0.6180970064815975},
{-0.06874436519955253,-0.4555255789400747,0.645776067473018},
{-0.06973144405892275,-0.43298117040437584,0.6543431670071744},
{-0.07202020938327697,-0.4140458377874374,0.6607014047399811},
{-0.07309860655465221,-0.39828561884777913,0.6597609863338941},
{-0.07204644337203281,-0.3832713663822849,0.6653223916906744},
{-0.06916771368985658,-0.39974510976421046,0.6788459127645776},
{-0.06619686465785071,-0.38556353611739363,0.6920938768268167},
{-0.06663623390464686,-0.37438485301556695,0.6976028142060854},
{-0.062491463940681544,-0.36812153826497607,0.7076151862352863},
{-0.047473206286064225,-0.34152267678003617,0.7053208136461598},
{-0.04296977163613177,-0.329908229101624,0.6920145740821808},
{-0.05362557729794722,-0.36131672194495185,0.7218808688536869},
{-0.0422684630206896,-0.325729415030113,0.7198720662490322},
{-0.027817340145893026,-0.30952221698432486,0.728008407693007},
{-0.01667991049203348,-0.2877644275923887,0.7104140123944581},
{-0.010864776404309424,-0.27492098763157546,0.6938703784623357},
{-0.006761059628855149,-0.26593714816916797,0.7025608378214814},
{-0.0006156976979374493,-0.24098301759759944,0.6875908426957966},
{0.020492850537155934,-0.20378302128237344,0.6814619020402833},
{0.016508888916480186,-0.19700263661599968,0.6784716278410308},
{0.029197127798776087,-0.18000681683188738,0.6740128510498201},
{0.03417417606250658,-0.16481012800183917,0.6739071140569721},
{0.03539395640992469,-0.14871127032182893,0.6778101708573627},
{0.032433520869638695,-0.13861338750485128,0.6883870742934545},
{0.048020114860813666,-0.11915517744790148,0.6813255253506442},
{0.053077266907004705,-0.0929019637842789,0.6872069453183544},
{0.06196257871698571,-0.06398269598091286,0.6899236651005041},
{0.020627424891689665,-0.07540169043012125,0.7031349816822675},
{0.0008940583419878759,-0.09705454386703412,0.7068744265069823},
{-0.024086105958880326,-0.10875169870083679,0.7175875063732572},
{-0.05002371071960832,-0.12340348155069705,0.7336300911460888},
{-0.056603235151462226,-0.13848522145291436,0.7268038470642564},
{-0.01953140488817312,-0.08924782948788448,0.7272330030787888},
{-0.019522393212646302,-0.07589953543811362,0.738000954036049},
{0.0030087981989465485,-0.04631019949446502,0.7363628316847307},
{0.020955850399777945,-0.019318629216012264,0.7426477744565859},
{0.013254672754020104,-0.030359333552550674,0.7601686745347271},
{0.02458335018850422,-0.028896237965908636,0.7819923492877372},
{-0.0004448763818403153,-0.06509133233016695,0.796547006301364},
{0.014954875536745403,-0.07026363356364505,0.812211701480438},
{-0.014792064598894332,-0.11297076492303428,0.8321062768923417},
{0.015374619356838716,-0.10795706917882807,0.8363127267688014},
{0.025132461617271333,-0.11906866536284409,0.8390018107460026},
{-0.004216562978995593,-0.15058730090705516,0.8511797885340245},
{0.019134090127168754,-0.17867549196739294,0.8469206704205969},
{0.012405973178850513,-0.20847930578857965,0.852078753232688},
{0.013285112191355114,-0.232000579951385,0.8490934855198394},
{-0.018045479723529812,-0.2737392565808261,0.8624509915045933},
{-0.029461870799808238,-0.29870820635214984,0.8613491639768484},
{-0.027439250292679202,-0.3250899865866216,0.8532999353962994},
{-0.02040473637644933,-0.33309095263823807,0.8399760730001787},
{-0.038554651406362085,-0.37950728964446334,0.8384008321180919},
{-0.0312944450830496,-0.3963763451928318,0.8279204537398651},
{-0.04761699257558092,-0.45075339609998716,0.8250769697219716},
{-0.04040264566772711,-0.46800454669069247,0.8163048045047162},
{-0.03363968357403853,-0.4574450658272858,0.8094066672781256},
{-0.03438905445895702,-0.497592480818148,0.7882598694869072},
{-0.042559440010477574,-0.5464043214388561,0.7821171109289193},
{-0.036483167591932104,-0.5644338805356219,0.7782823426030765},
{-0.019481940802503726,-0.6009752234995659,0.7865668760446034},
{-0.030575313376009956,-0.607241341882543,0.7844305081663802},
{-0.009309961986750036,-0.6294647345100313,0.7865069984672141},
{-0.027195734793999102,-0.6373028896237966,0.7770056885701113},
{-0.032905932926699834,-0.6511922847240885,0.7621182003403609},
{-0.02537677815377604,-0.6788493171753323,0.7449872054233464},
{-0.04466997441885707,-0.6766564761304745,0.7169336592489228},
{-0.030034612844401207,-0.6883774618395592,0.6898960292955553},
{-0.008983939592135575,-0.6909141483706289,0.6610308315453501},
{0.0064402439801006135,-0.6956919384754887,0.6122668529346621},
{-0.04772733553592034,-0.7025988871181502,0.6439444944870574},
{0.00458824452961256,-0.704391008991249,0.5840795334435294},
{0.030378658590069288,-0.7043485539865448,0.5422537439506624},
{0.032975222698528206,-0.7017217507002071,0.5265269683401814},
{-0.006492111179243831,-0.6921958088899979,0.5438389978055569},
{0.009815817372988438,-0.675729675367406,0.4870199830900914},
{0.0003119041029557874,-0.6757402891185819,0.48773290675399045},
{-0.007640599160272049,-0.6768046681280266,0.49704497146503007},
{-0.010738412687477899,-0.6769588679092632,0.4983660830972607},
{-0.011083259470970592,-0.6757158574649316,0.49547994381520694},
{-0.012538945457735044,-0.6766184268338058,0.4994124387556518},
{-0.011720084541532009,-0.6767125487781969,0.4983180208277844},
{-0.016235534758833547,-0.6735802906245331,0.497515781446442},
{-0.02342084404554541,-0.6727446079140134,0.4839688300161689},
{-0.041810469644471375,-0.6628191484887821,0.4868031020990795},
{-0.0727361369390182,-0.4152123491195192,0.6997197569170617},
{-0.07714204523380491,-0.43692307753925985,0.671345795612796},
{-0.0749710324696677,-0.4516711851875289,0.6676908602785768},
{-0.07274334627943964,-0.43673863858014433,0.6971237935869712},
{-0.06069553713791589,-0.4356438201333648,0.7283302246390423},
{-0.06826995054792989,-0.3900633660971154,0.7115651037484164},
{-0.07196253465990538,-0.5897100283126818,0.2027418723698423},
{-0.06647742815591881,-0.6018831998737564,0.1930364980869214},
{-0.06010997848812921,-0.6292640745349674,0.19951389019613808},
{-0.05984082977906176,-0.6302161079895111,0.19995766515096955},
{-0.06020369991360807,-0.6290277683767088,0.19993042986493298},
{-0.06044020633132286,-0.630131197980103,0.19941676435990469},
{-0.05994296210169896,-0.6299669852260589,0.1999624713779172},
{-0.03359923116389594,0.5520203976271657,-0.7778557899614741},
{-0.013130712150662404,0.535447325554989,-0.7674723371600245},
{0.0022688395084671685,0.5116244606512198,-0.7559926640956023},
{0.017832804181097024,0.4735825735823332,-0.735508725104245},
{0.02038871561995721,0.45945927543725645,-0.716440420208422},
{0.001585554244078627,0.4793650653787046,-0.7023541700627332},
{0.008438232574123029,0.47632913202344956,-0.6860822882126082},
{0.0010823022307701814,0.47731841373683737,-0.6741280002371072},
{-0.011628565970070828,0.4792561242345583,-0.6608025357653375},
{-0.0702074607861946,0.47376641176308026,-0.40878422083651583},
{-0.057696251263136517,0.4884986989143133,-0.4027744345574126},
{-0.06017205891953615,0.4840345151177865,-0.3915190520838799},
{-0.05632647658306101,0.25626161254521357,-0.9080618849781779},
{-0.057300538577781376,0.2692938971731776,-0.8984320085102258},
{-0.04890546191645896,0.28045395614558216,-0.890865805737914},
{-0.046069387498442985,0.28147007262609436,-0.8833052102303746},
{-0.04509872991447719,0.2785613040254954,-0.8768035867269632},
{-0.03893955008108505,0.2659569738553269,-0.8787392946301228},
{-0.048038738990235745,0.24963302454660255,-0.8562733878012351},
{-0.03665118527564312,0.23956377883185453,-0.8407610900682924},
{-0.03279819333929038,0.23761585510186994,-0.8333947462332197},
{-0.022483429531300756,0.244222014041392,-0.8314131789146019},
{-0.030954404526504543,0.24360681699209494,-0.8212836551035522},
{-0.020906987092477018,0.23821322905956957,-0.8074635497750886},
{-0.023807144536461444,0.23378869663536075,-0.8084656480936702},
{-0.022003808133818182,0.2298373773060377,-0.7996265962180601},
{-0.016830705862515477,0.23129005940095987,-0.788323151475051},
{-0.019572057557771853,0.22821727830577293,-0.7786722477642033},
{-0.021525989071440967,0.23043615307993032,-0.7747505668343906},
{-0.01749656855421885,0.23623666822735534,-0.7792225607497073},
{-0.012181682587960962,0.2399280507825939,-0.7950014038187876},
{-0.007112915493313138,0.2494407754686972,-0.7811698837013233},
{-0.011899116495331354,0.2487793184850292,-0.7771046167414501},
{-0.008476682389704103,0.24588817271657157,-0.7752558214422605},
{-0.010164869605060318,0.24867338123272512,-0.7755163589947135},
{-0.007746536412576135,0.2470386632921613,-0.7758509925459425},
{0.005259714486088169,0.2558294526388389,-0.7840894663125545},
{0.013035989427902787,0.25929293993297714,-0.7807909928102849},
{0.019584673903509382,0.25264132209690876,-0.7675954967255576},
{0.01357128295419545,0.2452667676241338,-0.760963504316192},
{0.004404606608321736,0.2373779468679621,-0.7646915343519063},
{0.023889851691851954,0.22499750676977087,-0.7580775652935944},
{0.028741737795487825,0.22176331655292594,-0.7444240758326487},
{0.009070051158280664,0.22607290004930386,-0.7226734957811339},
{-0.06907479330220233,0.024044552121728915,-0.40931891358444},
{-0.046873429214890815,0.09182536894800902,-0.39103242160543195},
{-0.057738305748928305,0.05321915073168796,-0.3878238645989744},
{-0.05234892326498211,0.040836708038935236,-0.3541950951652961},
{-0.06235008076463867,0.009688953007516545,-0.37475773612292085},
{-0.07027995470932138,-0.22687293657662866,-0.09633841605183677},
{-0.05651371917456256,-0.21683913678561945,-0.1256584030269617},
{-0.06361451897077854,-0.20128077937776184,-0.09664261016573072},
{-0.06084873562187169,-0.17954702112056378,-0.07218972901290913},
{-0.06103537743500479,-0.15835336261660607,-0.05160185536380935},
{-0.06907259044818467,-0.18376288319146283,-0.0052077471572169005},
{-0.06358468031181198,-0.20192741716167464,0.018462119522052765},
{-0.05887077297346442,-0.21451953150501787,0.040534917038515084},
{-0.06346352334084039,-0.4707204654350175,0.6425178461214348},
{-0.06420908929609201,-0.4730931394714993,0.6735945090459198},
{-0.06023253727529387,-0.4720744196180571,0.7112046367273439},
{-0.05017811076030104,-0.44221633548425343,0.7512509206928496},
{-0.05769985593334725,-0.40664725217992426,0.7326834646968612},
{-0.06508322182219282,-0.6629074629089448,0.12893805214035303},
{-0.055741718971098954,-0.6788743496073512,0.39210741436605256},
{-0.05744993213207031,-0.6830791974081619,0.40298130257561693},
{-0.03906811665193425,-0.6870695673314345,0.39474463114411024},
{-0.03789219312541329,-0.6794514973599796,0.3926447104869068},
{-0.04751486025294372,-0.6722874155756198,0.39173853644782175},
{-0.056980523966851444,0.4841809047802332,-0.5999567039055801},
{-0.04605116388793321,0.4901314142603156,-0.6099730811239041},
{-0.0353292726055878,0.5094390292062395,-0.6061313037170959},
{-0.014579389056461554,0.5245920614748468,-0.597195927043077},
{-0.025290466328174787,0.5225321927088736,-0.5633709033423703},
{-0.03736791386920895,0.5226157009020888,-0.5359445697846129},
{-0.04793880952161621,0.517605209309181,-0.51535269094639},
{-0.029838759096285153,0.5185229983967227,-0.5121485396479678},
{-0.022035048608977797,0.5257197224724353,-0.4830468354800479},
{-0.037312041480942706,0.5206018918110304,-0.48920941972419457},
{-0.04907468115690689,0.5196442510917143,-0.4728622403185567},
{-0.05062148519622023,0.4656563043078612,-0.5948290605308237},
{-0.048250613494843914,0.47540773826569704,-0.5990535337583373},
{-0.03971575573312784,0.47560098864088307,-0.6105193889202851},
{-0.029434635513771644,0.49890458077485195,-0.6216816507467073},
{-0.023075997262052717,0.5176114173523216,-0.6190782778167393},
{-0.01268513486072556,0.5273043755489611,-0.6152280895127726},
{0.01500954636827473,0.5325263411275649,-0.6077802400790464},
{0.0008628178668282612,0.5330540247945238,-0.5865633514781751},
{-0.01084955668564192,0.5285149439613963,-0.5529508030604451},
{-0.06536198298515557,0.20584829705366273,-0.33268702931518074},
{-0.06834985407093432,0.1806552569509056,-0.3178528101007665},
{-0.06931850906033858,0.16846286048204054,-0.31370363442876587},
{-0.06348274824863093,0.16131840412438353,-0.30618529366647423},
{-0.05769805359824188,0.16162239797882133,-0.32146388861408837},
{-0.05087461314879558,0.15994142010388657,-0.308636068890855},
{-0.03218159447380025,0.16651914220063513,-0.3088855921732196},
{-0.03001518767715452,0.1632242733685763,-0.3251426548235894},
{-0.030275124451239026,0.15950725760295037,-0.3492384733660931},
{-0.030916956008204235,0.1521773609888972,-0.3678473830695048},
{-0.022049467289820688,0.16177519594386486,-0.3902950662878825},
{-0.010770854719374423,0.16441181194355406,-0.41544064489953186},
{0.005394288840621904,0.15677011135627317,-0.4387808845139763},
{0.016983904346471283,0.16773551813729867,-0.4425693929054482},
{0.03152053800904451,0.15097780684655038,-0.45886770900378526},
{0.0517936037930743,0.17119419920448933,-0.4576843758773867},
{0.03762644882710039,0.18173986216542148,-0.45235447045191746},
{0.038010746723454905,0.18719693234554685,-0.45812895187004277},
{0.07393348822734734,0.18291979088106547,-0.46702768106358594},
{0.05554586522298289,0.19369875610841403,-0.49542747583769525},
{0.053130736181797124,0.19253184425741987,-0.5131558447124094},
{0.015100664420823615,0.1974283882197775,-0.5039429084321646},
{-0.012544152203594979,0.2031762351302347,-0.5107875763839631},
{-0.06549135059382936,-0.16343815046774599,-0.018231620888022528},
{-0.06010977822867307,-0.13792509575405895,-0.0268373704972162},
{-0.06417544570745858,-0.15320329018276077,0.0026163897946178943},
{-0.0643801108716453,-0.16016591095423227,0.019578966509009064},
{-0.06129831810093157,-0.17907300698785344,0.03612320121949997},
{-0.05021055279219756,-0.2026080990531332,0.05898341891754957},
{-0.038840221390833964,-0.2577557483475591,0.06421960291753995},
{-0.03753613181237612,-0.2712233970331962,-0.21042062095651123},
{-0.032095082388742854,-0.24984770268359682,-0.18904352479071884},
{-0.022801641807125315,-0.2301788196787758,-0.17635067994093145},
{-0.05437534870177802,-0.23904891177008933,-0.15140976649346893},
{-0.06167420510012772,-0.6574662132258553,0.1474228009809509},
{-0.062226921199105556,-0.6621318580352705,0.13939439938384168},
{-0.02832379631049989,-0.6853050812632847,-0.6291601398772249},
{0.0005660333528118995,-0.6774761380845021,-0.6461589635531794},
{0.011265896094980653,-0.6659153599403386,-0.6699862341649842},
{0.016807075246689607,-0.6526131255654826,-0.6887411330119302},
{0.018525101121012376,-0.6303624976519578,-0.7097705787618438},
{-0.008339104143328101,-0.616263030382163,-0.7275888641323698},
{0.001986073156381401,-0.5966083657987288,-0.7408886953937521},
{0.0010712879606818552,-0.5748533800391786,-0.7510064038968888},
{-0.05873219342980766,0.47462452353268886,-0.38416712692965005},
{-0.06101455045156505,0.4641393389275144,-0.362637032539358},
{-0.056793681894262205,0.21343732940397578,-0.32108880265271683},
{-0.0538901200395232,0.20225023540499068,-0.31849864684685475},
{-0.06103537743500479,0.18575506426125687,-0.3132282184798625},
{-0.06346492515703345,0.17018549232385477,-0.3031601743218514},
{-0.0602435515453822,0.1639642320590557,-0.3001136272154203},
{-0.05536843534483276,0.15999448885976672,-0.3015492872565696},
{-0.005368255111322231,-0.30084096956016215,-0.28043152708649327},
{0.005845072876418683,-0.29146602337989097,-0.2592100325181305},
{-0.015332364611590783,-0.28403459522156904,-0.24296658751077896},
{-0.0160198553245585,-0.27092180629223217,-0.22192352411784705},
{-0.061709651023866524,0.23336094243702138,-0.32117271136484427},
{-0.05438516141512944,0.2098000169018981,-0.29959155081323363},
{-0.044895867085395835,0.18904492660691188,-0.29950984495512384},
{-0.05087461314879558,0.18946787457830364,-0.3095586642053444},
{-0.04686261520425864,0.1774322812636051,-0.2996251944018671},
{-0.04942934065375099,0.16567384703622012,-0.30066133682799434},
{-0.04045511364523877,0.17219028973938635,-0.3000561527515048},
{-0.03551591441872089,0.18036808489078446,-0.2884931717533236},
{-0.021683793522888253,0.17182661856701542,-0.29558415883618816},
{-0.02162671957788511,0.16321466091468104,-0.30372831039895287},
{-0.02285931653049692,0.15282860474030152,-0.31189008479385893},
{-0.036870669639585046,0.12468974803755745,-0.35126389750560827},
{-0.030809216420794778,0.1365298881230522,-0.3854121399685432},
{-0.025233792902083937,0.13195716370129137,-0.41018984195924235},
{-0.012191895820224688,0.126996136194053,-0.4405762105383735},
{0.009970818192049615,0.13103236553278425,-0.4554176390932091},
{-0.04633953750479121,0.08316114357761917,-0.4169361825180703},
{-0.02279042727758084,0.08953259843453179,-0.46462176395738314},
{-0.025982563008633993,0.108521800845175,-0.43612003712009273},
{-0.05082214517128391,0.004543086022250424,-0.35252673363609893},
{-0.0361717641376167,-0.012877283808902813,-0.3298557611241124},
{-0.022715930759892523,-0.03061526513751215,-0.32412333419177886},
{-0.02556702463711986,-0.05571498433370274,-0.33825544375292627},
{-0.025657742170756434,-0.08782418501410426,-0.35420991436505134},
{0.010292234619172596,-0.04049766877967094,-0.3012609136397116},
{0.041151215514820996,-0.04590547513358306,-0.29209543885057476},
{0.06707900756219758,-0.049372967616844385,-0.2844080791072914},
{0.07590364075696471,-0.06025326412900553,-0.28464078059533926},
{0.08379346281041716,-0.08616283256587233,-0.28931023033442127},
{0.07744844220171654,-0.11214729803933976,-0.29688764763627756},
{0.06868769177346168,-0.10806921447427285,-0.3045736055633679},
{0.08166550582935249,-0.14010111500459993,-0.30161517261764337},
{0.08251881137201357,-0.15463814918608548,-0.310719568272654},
{0.07355439707685277,-0.1691479480815344,-0.3244459521756387},
{0.06073278539676004,-0.18218724179046372,-0.3344643319885243},
{0.06677080825918058,-0.21180060886885047,-0.3403417467671115},
{0.054016483756354726,-0.2305104493381625,-0.34407538406759797},
{-0.0444218529526855,-0.48778877914225666,0.6255056050619182},
{-0.04626624254383979,-0.49832583094657434,0.6626561372914748},
{-0.049905557640479,-0.5009187903848226,0.7180076507122627},
{-0.04845688073467985,-0.5044545713426315,0.7445388245010235},
{-0.041665882317130074,-0.5037150131710644,0.7582606024365166},
{-0.0410721130296412,-0.46433399111889356,0.7571806031894922},
{-0.03795387303790791,-0.43337588179245023,0.7697578983330803},
{-0.039379319846793506,-0.4107493668797293,0.7724381708942105},
{-0.03752411624500703,-0.3839196062418469,0.7610039567263345},
{-0.04258667529651416,-0.34945595513547345,0.737175484557793},
{-0.023751672667107503,-0.33145963910842885,0.7536173866861905},
{-0.010161465194305747,-0.28827448842720627,0.7385304400381133},
{-0.002326113712926473,-0.25960654624131024,0.7168123020184951},
{-0.059518612314114164,-0.6704966955187139,-0.3457247209484608},
{-0.05935239696550851,-0.6732264321655136,-0.3314828692053424},
{-0.054613857714054324,-0.6708341327023291,-0.3159889953423655},
{-0.049021812660482916,-0.6720983706490127,-0.33884180344053755},
{-0.05633088229109635,-0.6757236675837214,-0.35650909318112545},
{-0.042706630710748844,-0.6756363544608394,-0.3853564678397331},
{-0.01866948818889754,-0.6774126558369022,-0.4134604793971069},
{0.018989102280915146,-0.6772456394504719,-0.4319870824640404},
{0.02134235115015013,-0.6815199772825672,-0.46993304525343027},
{0.044207174815691204,-0.6944449228420341,-0.4969750809148332},
{0.09054240674217515,-0.699316634631829,-0.45662400205706516},
{0.07519191864980268,-0.6989135123465962,-0.5268329647891808},
{0.03897179185352542,-0.6927425172052911,-0.5868509240572085},
{0.010693955088212283,-0.6925694930351763,-0.6077684247711335},
{-0.060942857566262845,0.5306396967911625,-0.31088698517799657},
{-0.05738004158187347,0.5460776982658732,-0.292888065778022},
{-0.06077804403385025,0.5394717395858072,-0.30840757285138626},
{-0.05751681879042487,0.5267424475150004,-0.3300806524933704},
{-0.05058523823465682,0.5359792146705271,-0.329414789801667},
{-0.055503009699366494,0.5515019258951896,-0.3000956038643667},
{-0.05205293978879036,0.5575653817085414,-0.28232778387679075},
{-0.0461504925781843,0.5541097045331932,-0.2772580154848622},
{-0.05448208699190671,0.5369286447521409,-0.2956442366730336},
{-0.05040140005390985,0.5177820384089626,-0.31578372939981036},
{-0.056533945379633854,0.5138459387983071,-0.32521134381704936},
{-0.05793716338888664,0.5112808154244639,-0.3363828175784546},
{-0.055929762600425106,0.5050825849971223,-0.3533157558933354},
{-0.05064892074171297,0.5033957995979591,-0.3701934225983184},
{-0.036710662334120084,0.5198080633268461,-0.364118551995966},
{-0.038678411750263646,0.5494396540157427,-0.3192434117642818},
{-0.045247322430941525,0.5624533145142846,-0.29138071285157047},
{-0.04239983322392492,0.5700433481618784,-0.2703859119875711},
{-0.0423035084255161,0.565415552389676,-0.26711187013895205},
{-0.03678816274365068,0.5441652204596275,-0.2862917195518514},
{-0.035888196747706325,0.5086922616942511,-0.32356060511999346},
{-0.04340833984510332,0.49646161566926095,-0.33677492559359906},
{-0.05315556835435991,0.49295186844075184,-0.35740184983664836},
{-0.04209684066676786,0.5028408806449636,-0.3911319505551392},
{-0.0013460439345215698,0.5197583989817206,-0.373796290473938},
{-0.024101926455916283,0.5393888321709607,-0.3403271278268124},
{-0.01818045459697585,0.5656905086229719,-0.29867015705548106},
{-0.02774044051473088,0.5804680544112952,-0.2672981114331728},
{-0.02904132594189031,0.5827247782226653,-0.25570148684635813},
{-0.033753030426220215,0.5701448797061472,-0.25920762940465664},
{-0.019994404750795128,0.5663159189045327,-0.2595797114741859},
{-0.019861432471910606,0.5488753228683082,-0.2755570116643123},
{-0.027111025044047072,0.5211027407108649,-0.30767442298241604},
{-0.027636906375900615,0.5072840371985945,-0.31904054893520045},
{-0.028682661255923173,0.4971601206523172,-0.3205945623149352},
{-0.041236325783685336,0.4883699320840079,-0.33394686155382913},
{-0.04919323475494851,0.48402330058824206,-0.35138966044407133},
{-0.056051920868677454,0.4727032343103724,-0.35914070269441084},
{-0.05084497474928517,0.47645729807538645,-0.3214016079232253},
{-0.051353633767909704,0.4669884302101802,-0.3196747706328319},
{-0.045348253196841826,0.4606297919584613,-0.3139107027064264},
{-0.04120768868145569,0.446529523650842,-0.31324604157145997},
{-0.049289960072269635,0.4210477094123145,-0.3220097958915571},
{-0.04040564955956938,0.3965597828546665,-0.2987148149142028},
{-0.034022579654199976,0.3869837761804193,-0.2853581099672736},
{-0.028426729670961697,0.37052164784695046,-0.247798848187712},
{-0.020501461693770453,0.35440937278337814,-0.20439140951016138},
{-0.005223267265068624,0.3402324051040528,-0.15943616549601664},
{-0.011762739805692259,0.3259234664431237,-0.15516122688555292},
{-0.023069588959455878,0.3186071874720888,-0.19576283032296643},
{-0.032901126699752196,0.31492782048421936,-0.23964027794410436},
{-0.03561123791984896,0.3273306896414995,-0.2817780716696552},
{-0.037336673394049336,0.33930460304370336,-0.3017335259562289},
{-0.050101010869682765,0.33421480870615966,-0.3196473350873391},
{-0.048498734961015484,0.29836335956865717,-0.31555743621435933},
{-0.044833986913445055,0.27133253843679866,-0.3100933569532687},
{-0.046507955707414526,0.2590588366287362,-0.30957308288618735},
{-0.053170187294658965,0.2495835604609332,-0.3092462594537483},
{-0.0567215884900477,0.23030658521180042,-0.30249130773830574},
{-0.04959054951595286,0.2092775399807991,-0.2843379882976384},
{-0.046981569321212564,0.19682520673784953,-0.2837680498854316},
{-0.051594946412572125,0.2771883251941215,-0.6002943413486512},
{-0.03737492295017425,0.2854716570789114,-0.5516627342384793},
{-0.031569601575801604,0.28734708688576915,-0.5229599469072129},
{-0.05286218825109812,-0.008487997048976655,-0.5803016388032335},
{-0.039212904238731694,0.013227938116623908,-0.559804282428314},
{-0.03617196439707284,0.02967644880707445,-0.5433765987213033},
{-0.03655325840158509,0.047631311126695754,-0.5055247578763045},
{-0.03770615209064865,-0.012542650257673845,-0.6052808018068209},
{-0.02731969539735682,0.000608388227787919,-0.5910027031021391},
{-0.015847431932812156,0.02082217721279689,-0.57041843412325},
{-0.011621556889105527,0.03478226390111028,-0.5598449350979128},
{-0.02369860391122739,0.03913009695361311,-0.5382531607951261},
{-0.004290058199403149,0.04616521164821143,-0.5396942278415915},
{-0.016812081733093398,0.07362639035133921,-0.49223213595534376},
{0.01113732952413146,0.09020667176393737,-0.4910702305907534},
{0.0014824206241606582,0.10862553524346143,-0.4704665364446176},
{-0.0570375979118546,-0.11047733443449333,0.02796282864078699},
{-0.05228504049846981,-0.11197727776106724,-0.03933636419344904},
{-0.048371570206359356,-0.1261392259811812,-0.06914918969016258},
{-0.03490472255854685,-0.08452170632271169,-0.06764644273120254},
{-0.040093445067429366,-0.07554006971432187,-0.04379333864955437},
{-0.048188332803980834,-0.09321356749805046,-0.027373264801877323},
{-0.05023518470530419,-0.078845952816469,0.020583868459976732},
{-0.047769790540624434,-0.06556294334940349,0.05774181028941094},
{-0.0432765691229557,-0.09671230045647139,0.08012981618985557},
{-0.05108148116699997,-0.13031343408520077,0.05210771075004774},
{-0.058691340500752774,-0.13406689707184627,0.03273861615108533},
{-0.05605772839290584,-0.1516116280252695,0.044232908155806654},
{-0.04857723666782683,-0.1601745221108468,0.06509393570309693},
{-0.035568582655688706,-0.1878341579350206,0.078463657514676},
{-0.03521312212102,-0.23306776259321574,0.07359635143291647},
{-0.031067551119230073,-0.3998091927901789,0.29987551872205626},
{-0.040978391604162355,-0.39988729397807793,0.3198081434306287},
{-0.03086288595504336,-0.3911479713116313,0.31493402852736},
{-0.032301549888034936,-0.38249736358425973,0.33719466941369236},
{-0.03387058272698107,-0.38454962249089913,0.36508961009884405},
{-0.052894830542450796,-0.6688755952211685,0.38159419343701695},
{-0.04358036271793736,-0.654802962718498,0.3804388966344796},
{-0.04082559363911884,-0.6377534734001372,0.3818595372164175},
{-0.04337109158625915,-0.634237317869031,0.38334245848921855},
{-0.04488865774497439,-0.6264992924833414,0.3843055062138506},
{-0.05060606521809656,-0.1663280946794667,-0.09715667618967135},
{-0.0448692325777277,-0.14580971106165147,-0.08820327616459886},
{-0.03618337918607348,-0.11749722941042412,-0.08400623848257803},
{-0.02152859244437093,-0.08917092985672236,-0.08918514827810912},
{-0.012934057364721736,-0.06270724350468465,-0.08254194133919908},
{-0.026284554268510278,-0.057792876450729565,-0.055983932783314067},
{-0.032628173061017854,-0.0322575929374097,-0.029656623120915465},
{-0.046900864760383555,-0.06580946273992584,-0.011401171357610927},
{-0.04254702392419619,-0.04140804826733516,0.012135122264405754},
{-0.042178146005965325,-0.023297984869196525,0.037092657246728854},
{-0.041106757915555396,-0.022299090701913393,0.06382589282674633},
{-0.0403585885873738,-0.05727140082691133,0.08047866816247128},
{-0.02866343634813264,-0.08557567184043646,0.1103183284263091},
{-0.036590106141516955,-0.1268153019051483,0.08718776046245513},
{-0.051862092527078074,-0.1899759328185597,-0.10962442941074456},
{-0.04026566819971956,-0.15162724826284935,-0.10638503244803968},
{-0.020639840977971065,-0.1265261272504657,-0.11325353127512003},
{-0.014388942313661581,-0.1053929471022657,-0.10507994157230108},
{0.009169580107987905,-0.08018388624301644,-0.11119406302805915},
{0.0018533011369530304,-0.06774697297819053,-0.09761106489567885},
{0.011698456520267655,-0.04293783025287561,-0.09370680653855135},
{0.025807536243957662,-0.02007000269549227,-0.08944588609001823},
{0.000858011639880623,-0.02473204283469662,-0.06909572041537015},
{-0.02242655584575376,-0.03978134070501741,-0.04861498557531138},
{-0.012511309652786151,-0.018647159259536642,-0.05312042281980534},
{-0.021293087323936893,-0.001539995217804182,-0.03277486311264875},
{-0.03225709228876933,-0.0013303235672136727,0.002852095174508088},
{-0.040119278537272894,-0.039243243546338624,-0.011543956349846871},
{-0.03362386307700257,0.017219709856089557,0.03814101549968137},
{-0.037128203300195735,0.005421223737474262,0.08824032416398685},
{-0.03544402127396254,-0.022407030548778982,0.10812929231111826},
{-0.028020603493886683,-0.03568923897801992,0.1241951071808635},
{-0.013170964301348828,-0.0394987746123878,0.14430275865411224},
{-0.004372765354793672,-0.05609287392746041,0.1500111544517076},
{-0.0025265734285340145,-0.08353983420920143,0.1386868827252588},
{-0.015694834227224792,-0.1053458861300701,0.11945576689158471},
{-0.022597577421307052,-0.15118046941617558,0.10326539064011331},
{-0.03475873341501249,-0.15678753392895833,0.08880966179782523},
{-0.010321672759226857,-0.17121622774466597,0.10717785963494302},
{-0.005107517299413122,-0.22825252397005558,0.0969153635450089},
{0.028145565394525143,-0.20652437297762977,0.1262892203138386},
{0.022040455614293873,-0.2639119242891089,0.10923913021710926},
{0.01299493623939175,-0.31398259585118476,0.08943907726850905},
{0.036591908476622304,-0.33343099319478314,0.09492418377249562},
{0.039250352757032,-0.3615974857024761,0.08665426927126783},
{0.04748982782092478,-0.3801601354715169,0.07764519711738527},
{0.07022888854800279,-0.3966454939018993,0.07364321214565589},
{0.06054954799438152,-0.42381889976653747,0.062309127705855685},
{0.04816470218815497,-0.4456361662169506,0.052096095701590954},
{0.03977703512671016,-0.4581896304852567,0.04843134765402053},
{0.029240383841304788,-0.4703990490078946,0.04183359961165685},
{0.05272681285873978,-0.4860303008577913,0.035760731603865954},
{0.048283255786196584,-0.5129015152030971,0.019109558343790203},
{0.05174594204251027,-0.5523922794372389,-0.004766775834771544},
{-0.03640166199327849,-0.19639424838821173,-0.13532572801321394},
{-0.03483643408399923,-0.17802865392402395,-0.12675362199265366},
{-0.030201829490287622,-0.15724172237550968,-0.12331316453597281},
{-0.0018176549537580917,-0.1346780889320203,-0.13300572221370008},
{-0.0033226047667357845,-0.11115321009900425,-0.1224382309720474},
{0.016813283289830297,-0.09886288675608117,-0.1285575591736654},
{0.03034000851503207,-0.062036574586033656,-0.11634553727809752},
{0.04453740265888484,-0.030723405243833896,-0.10717725885657459},
{0.05477746968973,-0.00010653803067253472,-0.09802540171045607},
{0.02978028333508893,0.009574604858054104,-0.0744911106830009},
{0.004556403276084491,0.023496842509154858,-0.047594463386763895},
{-0.04563582577587522,-0.6138509052328196,0.3871437834858843},
{-0.05081994231726625,-0.6162195740801781,0.38800770277972135},
{-0.05031328589320323,-0.6123161167608754,0.3882209791005226},
{-0.04135447886281467,-0.6123313364795429,0.38542155216298235},
{-0.04348003273040551,-0.6033464957198547,0.38751346244193974},
{-0.051068864821262425,-0.6715406480636312,-0.3037857848628683},
{-0.038134707326812615,-0.6697291010232856,-0.3024600672631461},
{-0.03159483426727668,-0.6737148649790669,-0.3375977916989251},
{-0.027989563278183215,-0.6760244572868608,-0.36602922746710637},
{-0.04833772635826977,-0.6709034224741574,-0.36801439945593506},
{-0.039554346611469816,-0.6657365282459955,-0.38563502874323974},
{-0.024774798228584957,-0.6719766128996727,-0.40007313475338646},
{0.006208744048789609,-0.6741177870048434,-0.4120162081993431},
{0.025895249885751977,-0.6687918867684972,-0.4067099333896997},
{0.036858053293847504,-0.6662159493840218,-0.39960392684762375},
{0.058724383311017744,-0.6806642686264324,-0.4193320866514656},
{0.05257962215846851,-0.6874762942868781,-0.46481521459202535},
{0.07301910355056009,-0.6927599397779762,-0.4485195018666183},
{0.09438218155442189,-0.6934015710754853,-0.3954605586998515},
{0.12632396532948087,-0.6992473448600005,-0.3537981809232041},
{0.12339617208054754,-0.6992683721028965,-0.40605087951950547},
{0.11428957357151924,-0.6978613491639767,-0.47529899738100684},
{0.09015490469452221,-0.6943497996003621,-0.5310812688919765},
{0.07408668671130315,-0.691375946676514,-0.5658385003610678},
{0.08377864361066195,-0.6803021995297106,-0.5939120724811064},
{0.056549565617213644,-0.6824611967264789,-0.6142307974211388},
{0.03909495141905853,-0.687537173161548,-0.6172234747338652},
{0.029350726801644203,-0.6847888123853263,-0.6301283943477168},
{0.035986924659588956,-0.6695200301510638,-0.6520590076503117},
{0.03730583343780201,-0.656728857908306,-0.6773067185845981},
{0.04093413426435289,-0.643732419722993,-0.6931967056518424},
{0.0657494850328085,-0.6205870325593839,-0.70336327746228},
{0.03990099573006787,-0.615814449200384,-0.7190157568145289},
{0.01509585819387598,-0.6135963754640512,-0.7290215202816769},
{0.025513355102871272,-0.5995860236522438,-0.736314368896342},
{0.028451161324612163,-0.5616703000407326,-0.7558741104975606},
{0.004704795533092669,-0.5536414979247112,-0.7657290785942267},
{-0.02560547445270092,-0.5598191016280692,-0.7617429141195332},
{0.007229466496793241,-0.533062435691682,-0.7729504345830458},
{0.015279496115166805,-0.501948724767809,-0.7791925218312845},
{-0.0001547004298769504,-0.4860479236899326,-0.7903297512256879},
{0.021850209130950052,-0.4711796603679727,-0.7910528881218506},
{-0.027650323759462764,-0.6886163713707479,0.39722103957887833},
{-0.01161414728922793,-0.6869071569124958,0.3947294114254427},
{-0.01204210174702345,-0.6784566083818194,0.39183786513807284},
{-0.02092440966516219,-0.6678056089469516,0.39125731297469},
{-0.02914646215636979,-0.6524158700011734,0.4039024960739133},
{-0.04338050378069827,-0.6568888652137709,0.40160832374424305},
{-0.04888443467356307,-0.6661102123911739,0.39528052544877135},
{-0.028752551806120005,-0.6678644852270602,0.38343597965524123},
{-0.006663333014253268,-0.6718378330965598,0.38556173378228825},
{0.004122841553516732,-0.6722543727653547,0.3875933659649441},
{0.030968823207347434,-0.6787231537179569,0.4011879791457812},
{0.06254973944242159,-0.6885110348968122,0.4265175961976336},
{0.08212009479481615,-0.6940776469994525,0.3692708272838289},
{0.0819694996837903,-0.6934992976900871,0.4030602048013406},
{0.06986561789454417,-0.695586401742097,0.45344728630413556},
{0.07779128639064771,-0.7027735133639142,0.46711980041341555},
{0.10733556395666224,-0.7049981956623,0.43490966896711375},
{0.1491255070068781,-0.7012325168488293,0.38694432506755744},
{0.15435428140699087,-0.6996905190364636,0.35264769034761434},
{0.15331092964044216,-0.697377522317915,0.33629770730959024},
{0.17850056533244468,-0.6760675130699333,0.3140386684989071},
{0.147496997109455,-0.6793936223771517,0.28404981494023657},
{0.11264864758781476,-0.6911852996742579,0.28482221566261245},
{0.0911634113157006,-0.6838742274490829,0.26269434679570847},
{0.06043039361797144,-0.6714349110707832,0.248661365665356},
{0.0352077151157039,-0.6799569522273057,0.2565782227453889},
{0.003860701925414562,-0.6831661100121317,0.2672194094669053},
{0.005727720835113968,-0.6595641312884973,0.25124311057405974},
{0.0017972284892306407,-0.6253792413450866,0.23855346987557077},
{0.014931044661463388,-0.6292098042223504,0.23202300901047396},
{0.037142621981038626,-0.6021477426153324,0.2125798184127355},
{0.045181036550955414,-0.554080466652595,0.19786615539092445},
{0.021883452200671186,-0.4958654432682984,0.20684959433441966},
{-0.00015870561899998222,-0.49157067897167567,0.21089423457030926},
{-0.004872012178979091,-0.4957254619084486,0.2094481610374401},
{-0.04422059219925335,0.45941161368669253,-0.6076604849242678},
{-0.04321068376188189,0.3423024871022897,-0.41448480651532127},
{-0.030556689246587884,0.34833149828918347,-0.440371945893099},
{-0.04372755341820863,0.2722016644764957,-0.8949571064270867},
{-0.036687432237206524,0.2590460200235425,-0.8968059017262765},
{-0.048467294226399726,0.225170931458798,-0.28858929629227625},
{-0.036943363822168,0.23574963722999517,-0.28475352666915255},
{-0.03997188757754547,0.21533679034557168,-0.27787201097742237},
{-0.03957737644892723,0.20666135044563735,-0.9497703224297399},
{-0.01681488536547952,0.1945909119855685,-0.930555427612014},
{-0.02706216173674613,0.21360174241747604,-0.9247855521613801},
{-0.0417930470717862,0.23275475706325113,-0.9271852612244423},
{-0.037731785301036026,0.24046674871964116,-0.9135489940767255},
{-0.02262561374516824,0.24946961283038305,-0.8911599868790004},
{-0.03050842671765539,0.25833209506236277,-0.8806734004576329},
{-0.027436847179205383,0.25374895714888207,-0.8676004631600702},
{-0.028986855369817134,0.24252661748561435,-0.8515931240515211},
{-0.02515789456820257,0.2397658406231113,-0.8415264817097029},
{-0.015146724095738442,0.24668921054117715,-0.8505940296247818},
{-0.005382473532708982,0.2574627687632096,-0.843424941354018},
{-0.009327184299979056,0.25119404700730263,-0.8344238795783818},
{-0.011066037157741572,0.24634055882801756,-0.8245148414285549},
{-0.007429125174576187,0.23899804586822687,-0.8135962953602687},
{-0.035600423909216784,0.1898527732530266,-0.9612413843375476},
{-0.015819595868407112,0.18104756522550616,-0.9490157447989617},
{0.0003491523617999442,0.17562073422325963,-0.9260137434059567},
{0.006158078406383307,0.17865546602177781,-0.8981496426770523},
{-0.012233750046560327,0.2003677965171676,-0.9121457760674728},
{-0.020040664685166108,0.2196764127603723,-0.912526869812529},
{-0.018285590811455327,0.22781595835564555,-0.89845363653149},
{-0.013630960272128574,0.24609984696172357,-0.881301814631036},
{-0.02152278492014254,0.2564138097318886,-0.8801178807262688},
{-0.01738121910747565,0.2550236085872857,-0.8718047101825125},
{-0.01222013240354203,0.24879654079825822,-0.8633245232523258},
{-0.04780603750218783,0.07563639451273067,-0.3582789862545914},
{-0.04040785241358704,0.07258484091989582,-0.33535308345492415},
{-0.02663821246807364,0.054799798619090886,-0.30263289117380476},
{-0.0275397805396672,0.02789814483645011,-0.30970345179214187},
{-0.04481235889218071,0.012579297738149559,-0.33602495393031206},
{-0.03193928053185707,-0.05941237467262584,-0.660275452876747},
{-0.024050660035141534,-0.0395194013363714,-0.6384473724157017},
{-0.01881207292167733,-0.027847679453499957,-0.6255186219265679},
{-0.02801439545074599,-0.019233318687691764,-0.6169947784349402},
{-0.02927843313797356,-0.19988937667642193,-0.1499602885498452},
{-0.00779880413063165,-0.20259748530195718,-0.16732438547381986},
{-0.004232383476031552,-0.17136381896384956,-0.15260110999811355},
{-0.04463292641946906,-0.46814092338033153,0.5986319876031385},
{-0.03321032730004994,-0.4838268460617576,0.5949474138694092},
{-0.03987215836838207,0.5544441378249659,-0.7925928833396548},
{-0.019648356410565525,0.5416525650632961,-0.8009769457308888},
{-0.014277598056041408,0.540091742862052,-0.7883537911718422},
{0.00523948828101688,0.5173432699405348,-0.7891512243262371},
{0.015349787184275944,0.49613579353410264,-0.7857518200580671},
{0.016304223752293463,0.4883232716307247,-0.759102292930721},
{0.02516710650318552,0.4659462800003684,-0.7616519963264405},
{0.034730096312782836,0.444708163897145,-0.7419040108364396},
{0.03954413337920609,0.43650673812992113,-0.7102742312940645},
{0.030991853044804844,0.45048364661255125,-0.6969325458063467},
{0.02539440098591735,0.4608450708738241,-0.6909165514841027},
{0.013476359971979691,0.4712076966918338,-0.7012751721129895},
{0.01816683695395754,0.4722238131723461,-0.6712464669225447},
{0.009512824815831385,0.4843803631985601,-0.6613999097230371},
{-2.212866990473124e-05,0.4961143657722945,-0.65037162147278},
{-0.026145774465397367,0.4830668614256631,-0.6454820865913877},
{-0.03986334695231142,0.46683122653710146,-0.6332117891940798},
{-0.044022936116031926,0.4858498670877989,-0.3208344731434046},
{-0.04130301218258376,0.48644824234277934,-0.3053401987615154},
{-0.041111363883046884,0.47986010675431084,-0.2994131196378027},
{-0.034562679407440275,0.46242011149645473,-0.29805636182237705},
{-0.03083364807444525,0.44905439487399873,-0.2833551148868474},
{-0.04444828720089748,0.43624820317202967,-0.3045924299522461},
{-0.044569644431325224,0.42259090878141725,-0.2868810831313049},
{-0.03865077594531475,0.40590228700304104,-0.28314344064169533},
{-0.030424518005527968,0.3969875370530059,-0.26897788775137066},
{-0.02523699705338236,0.38223842810745595,-0.23257993055803095},
{-0.01917754642915361,0.3719555055529944,-0.20657624017677303},
{-0.013033185795516673,0.3582187081582899,-0.1863790727266246},
{-0.000780310970893895,0.35100396073152373,-0.16534542152813184},
{0.009473974481338016,0.35155347267920317,-0.14707975653256358},
{0.004243998524488321,0.3426665587935729,-0.13728867120240984},
{0.0021396721592495207,0.33893292149308646,-0.12341089115057467},
{0.0028201537912519396,0.32768755199236127,-0.12936660737651703},
{-0.006533765146123323,0.31717393054441334,-0.15360761402473044},
{-0.019350570599268417,0.3121610358380317,-0.19403999822169601},
{-0.01834026164298465,0.2942422202205177,-0.19539235032908636},
{-0.02896362527290357,0.2851726697108774,-0.21127532831536536},
{-0.03723854626053515,0.29341174425585786,-0.25333221722063104},
{-0.03872006571714313,0.3065001015315443,-0.278763165557296},
{-0.04055484285440216,0.32162349540064106,-0.3056512016969185},
{-0.04251678474631733,0.26650127905714643,-0.2824713699068513},
{-0.03540236730708306,0.23991042795045261,-0.27629636957642323},
{-0.035267592693093174,0.33400313446100766,-0.42234338809361405},
{-0.022158808952879357,0.34287763226035656,-0.44005874010367824},
{-0.00768085131095848,0.3504115932602279,-0.4609488052721105},
{0.020118565613608988,0.35246905891272723,-0.47457686178212494},
{-0.03935829260389761,0.28234861086023044,-0.5812446605822503},
{-0.017943948179261048,0.29606157737965305,-0.5224847312177657},
{-0.008658517975889565,0.3049048347038423,-0.4862605992323654},
{-0.02170602232252106,0.3029302764661896,-0.46854845137359963},
{-0.024895955199556542,0.317951337753193,-0.44597700781132027},
{-0.01592933805037807,0.3276667250089215,-0.4482509539359193},
{-0.00139771087420863,0.3419904828696058,-0.4567237312662285},
{0.02301972435487417,0.34777818141183714,-0.4705979066478529},
{0.06170164064562046,0.3462059444215925,-0.4874727697204498},
{0.06573506635196559,0.3523819460493014,-0.4937358842115845},
{0.03968731889035434,0.3586430579458747,-0.49111248533600127},
{0.034579100682844685,0.3631633143901238,-0.5152711853477365},
{0.06469231536378532,0.3591513164455869,-0.5140756363945127},
{0.07048782402480652,0.36057516117882327,-0.542005822743947},
{0.05798682773401217,0.3624527938396987,-0.6271473320834472},
{0.020364684485219046,0.37761764141621884,-0.688429929817071},
{-0.03490872774766988,0.4013882386019327,-0.7056884900076539},
{-0.043305206225185355,0.3933057669516626,-0.6990094366260927},
{-0.04496635841396113,0.3974180948837313,-0.7025322007192518},
{-0.022119558099473677,0.26098393078071946,-0.6881625834431089},
{-0.020131982997171134,0.2729422239453435,-0.6246122476280268},
{-0.0027374466358614275,0.27573384076409396,-0.6091281864784014},
{-0.02528626087959561,0.27919913039333755,-0.5859413456073689},
{-0.024071887537493578,0.2867072579233655,-0.5668992747003017},
{0.021239017270776008,0.2940479685480508,-0.545946528322094},
{0.006383570554009769,0.30194159553117017,-0.513681726044263},
{0.013650785958287552,0.3109636845497025,-0.48569466600928163},
{-0.01230324007784486,0.31094946612831587,-0.46541138699298806},
{0.003990470053000664,0.3319753072080187,-0.46200457312494064},
{0.04282898923845734,0.33728458590950433,-0.47763502393701274},
{0.0875945875476267,0.3317800542382711,-0.49462323386179124},
{0.09685118038931238,0.3425077530448449,-0.5015277793909789},
{0.09319043753086498,0.3484624679735065,-0.5069656246633137},
{0.06789907003513751,0.35637852401571474,-0.5013467448426181},
{-0.027061160439465378,0.17114433459990763,-0.8792797949022754},
{-0.02504394693765243,0.16787790261062233,-0.893059047301684},
{-0.018803261505606673,0.1592841685687977,-0.9417977932208969},
{-0.025076188710092796,0.1736487793585369,-0.9547493732880319},
{-0.042907490945268696,-0.07257382664980748,-0.6645425813684209},
{-0.007325991554658218,-0.06487585315534806,-0.6735083974797748},
{-0.006141256612066596,-0.04677720454621006,-0.6567951437882921},
{0.015506189819530178,-0.03064049782898724,-0.6375856559758822},
{0.015893091088814662,-0.017709744745292,-0.6294322924781346},
{-0.002846588039463933,-0.0049784500799235475,-0.6124813308122002},
{-0.004573024810945061,0.007801107114377379,-0.5903384424860849},
{0.02024132466022979,0.02223280482192729,-0.5846578827528947},
{0.013305338396426405,0.03145415199933032,-0.5763417083172959},
{0.01879745398137827,0.041206987773359176,-0.5659612594076886},
{0.016433591360967264,-0.07977976266050295,-0.6828999651949065},
{0.02111525692687445,-0.06340214381752998,-0.6767005332108279},
{0.018470430289483048,-0.05111923007448449,-0.6648774151791059},
{0.04330260285225538,-0.038166648710068765,-0.6464677636345649},
{0.03771596480400006,-0.02118644916353627,-0.6358904596795608},
{0.02457954525883734,-0.003214364530685964,-0.6168251586755801},
{0.02643354730388691,0.01113762991331569,-0.5941716087362787},
{0.060151832714464844,0.010673428493956761,-0.5958185425036677},
{0.048933097721407845,0.029557094171208217,-0.5825773872629378},
{0.03928760101587616,0.04171604731089599,-0.5679043769107255},
{0.02566134684096715,0.04909680982681161,-0.5498634030249591},
{0.0046687488309854214,0.05905931725143095,-0.5295014220423981},
{0.010764646676233725,0.07718099569802636,-0.5118519553934077},
{0.029404596595348928,0.08175652375217331,-0.5148714674732583},
{0.05237776062666791,0.08881046283564989,-0.5105094159993687},
{0.05491124300643913,0.10019821680969865,-0.503546594968441},
{0.03136313407650952,0.10757116920682434,-0.48983242689228157},
{0.03711398487880898,0.11823378369014895,-0.48228204461700575},
{-0.047088107351885095,-0.49349076663725516,0.49559349092684474},
{-0.04281957704401823,-0.48590393714095975,0.5136985478385796},
{-0.04357034974512979,-0.5003919077556883,0.5091246218600819},
{-0.042480938303666234,-0.5053583422682427,0.5006570512756326},
{-0.044232006988253976,-0.5073757560295118,0.5061403554445139},
{-0.033440225155711746,-0.5134141794108447,0.5061872161572533},
{-0.03351692452741772,-0.4986452447791358,0.5235188710493315},
{-0.03145365135068995,-0.482724217496188,0.5349588927414358},
{-0.032970216212124426,-0.4781919454845698,0.531088678491854},
{-0.04209644014785555,-0.47997385412540483,0.5110282882502569},
{-0.0446537534029088,-0.4823633499562033,0.4985016587490752},
{-0.04415030113014422,-0.49094086298207956,0.4879335667290541},
{-0.043715137331927244,-0.5004345630198485,0.4875698955566832},
{-0.038056405879457425,-0.5104471353085057,0.48734740730089904},
{-0.04205418540260762,-0.5077288134507066,0.6859338959556},
{-0.033218337678296,-0.505893035016167,0.7049104820205057},
{-0.03892132647057528,-0.5089860423164251,0.7263356404557745},
{-0.04391199237732406,-0.5136510863474718,0.7438923869765668},
{-0.03679977779210745,-0.5256298059766232,0.7606042388518565},
{-0.039085739484075566,-0.5372460559901407,0.7736731709602961},
{-0.03457089004514249,-0.504464584315439,0.7718417982337915},
{-0.03299865305489793,-0.4636342845791006,0.7673497783728599},
{-0.02996552333202898,-0.4193204716030088,0.7888029731319897},
{-0.025901858447804973,-0.3777383978682781,0.8067668471271379},
{-0.03160905268866343,-0.38514058814600194,0.783869381170244},
{-0.0161636416140752,-0.35066371991552253,0.7868220065917402},
{-0.03724655663878121,-0.6487925756610264,0.40074700782333583},
{-0.04558355805781971,-0.6423534331079346,0.41065284182186435},
{-0.04593281054934774,-0.6489662006095096,0.40628197893190415},
{-0.03634158415643308,-0.6259892316485238,0.4213861478932104},
{-0.04209043236417102,-0.6279299460380869,0.41827611853917934},
{-0.03255067265148727,-0.5941728102930156,0.4352781463664323},
{-0.019584874162965542,-0.6328721491564471,0.4096679658165118},
{-0.020532301650017765,-0.6531746530805311,0.3955064181153101},
{-0.04077052228867721,-0.6684842882438488,-0.37192126118599256},
{-0.05488100382856028,-0.6667656615911574,-0.36813054994050287},
{-0.036968997032555385,-0.6722271374793181,-0.2920932359965571},
{-0.019679997404637453,-0.6665335608814781,-0.29579543256242785},
{0.0025173614935510413,-0.6714391165193624,-0.34060328561684516},
{-0.006969529722708744,-0.6768104756522549,-0.3715866276347636},
{-0.01388889445165156,-0.6769652762118601,-0.3785740805787979},
{-0.026459981552098905,-0.6738440323282845,-0.3737179890265828},
{-0.02938056546061077,0.4939808015264576,-0.3036564172541945},
{-0.029610062797360257,0.4855150332771138,-0.28485886314308817},
{-0.031139244004532277,0.47129961578220736,-0.2776907761696053},
{-0.025152487562886478,0.4584199288598308,-0.24548244705840885},
{-0.029300862197062513,0.43636014820801833,-0.24858426577473774},
{-0.03774540294405431,0.4334115279756452,-0.26780997460309575},
{-0.035846542780826836,0.42230694087259457,-0.2540661681274259},
{-0.028427330449330157,0.41252286462340615,-0.2502069681479324},
{-0.022036850944083156,0.40141547388796917,-0.24494855534830923},
{-0.0159625811200992,0.39407516378219615,-0.2238938769069206},
{-0.002093211965422407,0.37210409806945877,-0.17847563303015387},
{0.00662728631214601,0.3696030577215841,-0.1476601084364903},
{0.014148230447367604,0.3591887649638872,-0.12849067251531082},
{0.010798891043235613,0.34983464576705575,-0.1218128206904866},
{0.017907901477153793,0.3587081422691238,-0.09028577424911716},
{0.01979795022431061,0.35276684472402436,-0.07889221275083999},
{0.012891802619473784,0.3375443224241327,-0.10200455710418418},
{0.033158860619819035,0.33273749469813085,-0.09914505232979849},
{0.018657472621528448,0.3201033258689958,-0.129449915310276},
{0.011606136910981862,0.31170204116453276,-0.1377098168386962},
{0.007028606262273396,0.29531420908929606,-0.1496825286841632},
{-0.002478711418513829,0.3026933695295625,-0.17299413119637802},
{-0.009524640123744323,0.309140121941988,-0.1770343657242323},
{-0.007626781257797606,0.2986761648391656,-0.1849870692469163},
{-0.00018193571591353886,0.27494521902576974,-0.16522466507607256},
{-0.012038096557900417,0.27531650005747443,-0.17628619639605073},
{-0.021043163522659954,0.27531109305215834,-0.18727723638746357},
{-0.01895105298424639,0.25829945277101013,-0.19379808479866514},
{-0.029487103491283303,0.2719383232916566,-0.22656593883034862},
{-0.037670906426366,0.27387563327046516,-0.25962937581931145},
{-0.03787216717979814,0.2456330421694347,-0.2548145377150636},
{-0.03329243367707201,0.22911444066933118,-0.2507654917711387},
{-0.0237863175530217,0.21779397387254926,-0.2573536273596071},
{-0.02634122769460113,0.22043099039115074,-0.27029539471339065},
{-0.024483620979340835,0.2086270972672194,-0.26847623781371144},
{-0.032524038143819135,0.19576843758773865,-0.26815942735407994},
{-0.04128418779370553,0.19753732936392387,-0.2740058019169636},
{-0.0343640220269381,0.18572923079141335,-0.2715239864768794},
{-0.02701129583488368,0.1803857077229258,-0.27384739668714786},
{-0.02090678683302086,0.17750016921924044,-0.28241149232946205},
{-0.00365303286938558,0.17323744643560193,-0.2663318595572423},
{-0.010564186960626188,0.15476571445965392,-0.27951974578263594},
{-0.02437307775954527,0.13583398651292614,-0.3087976782719692},
{-0.034900116591055366,0.1071029625983424,-0.3294396219742298},
{-0.03923693537346987,0.47109975684496824,-0.6201206282860072},
{-0.032981831260581206,0.4831812095751255,-0.6367543789733979},
{-0.023204964351814218,0.49784000150595104,-0.6337322635206173},
{-0.016949659979469407,0.5197299621389472,-0.629883877551756},
{-0.004914867702595487,0.5287676713950593,-0.6261740711265515},
{0.018128387138376476,0.5288459728424146,-0.6320907367585443},
{0.043087924715261086,0.5289048491225232,-0.6142123735511729},
{0.024853700454308597,0.5378580488881395,-0.5788046993685019},
{0.009246479739150038,0.5398986927463221,-0.5439417309065625},
{-0.0008976630121986101,0.5356768228917386,-0.536484269018941},
{-0.0072216563780033455,0.5312108367601063,-0.5048823255409709},
{-0.01688277332111484,0.5232369057350703,-0.5053605451222604},
{-0.0002700498766201551,0.5316295792829189,-0.4623930764698743},
{-0.033282020185352146,0.5260327280024,-0.4576339104944365},
{-0.03286688233275031,-0.5096681260240767,0.48013045702011525},
{-0.028489811399649387,-0.495788143118224,0.48956387896158254},
{-0.011450134794639938,-0.5067221091646337,0.4921416186811633},
{-0.01224696717066632,-0.5133128481260321,0.48462487999452086},
{-0.013477761788172758,-0.531356024865816,0.47527817039756703},
{-0.019203379898997147,-0.5442295037450521,0.4630321043944534},
{-0.0284844043943333,-0.5318815056787572,0.4695391349031805},
{-0.0325925268778229,-0.5281558787565168,0.47889525669457345},
{-0.015495776327810313,0.5245704334535825,-0.430351563485652},
{-0.034721084637256025,0.5171826618567016,-0.4226511868777187},
{-0.036501391202441884,0.5073893736725301,-0.40651908612798743},
{-0.01816563539722064,0.5138152991015159,-0.3983505029115722},
{0.007626180479429143,0.51994524105431,-0.3917761852255782},
{0.03490792670984527,0.5198417069154797,-0.34965441225651955},
{0.014700946546345439,0.5252565223503571,-0.3546689090385503},
{-0.0037117088900379346,0.5381902793258947,-0.34242644770564745},
{0.01109147010867279,0.5416461567606992,-0.32962786586301207},
{0.0004909360567551254,0.5673800976545211,-0.29263193393360437},
{-0.01102117903956366,0.582854145831339,-0.26752901058611533},
{-0.014532728603178278,0.591870227066187,-0.24541896481080888},
{-0.02561028067964856,0.5818770799447764,-0.24857024761280713},
{-0.015466538447212208,0.5823446857748898,-0.23998792835998317},
{-0.010572197338872246,0.5731045142086086,-0.24566628523915582},
{-0.012000447780143957,0.5504998275766082,-0.26086137199355486},
{-0.019724254744446907,0.5256031714689551,-0.29238561480253816},
{-0.022844697590197856,0.5031618965531742,-0.3085079028389181},
{-0.025009101792282086,0.09639388792119066,-0.3005588039864448},
{-0.005867702194963796,0.08149037893494812,-0.2676363496546125},
{-0.02071473801457168,0.012998440779874398,-0.3032677136498047},
{-0.02757362438775678,-0.41172342887444974,0.26329492490470646},
{-0.015555253386287275,-0.40952518082427586,0.26569223085429483},
{-0.028222264766231128,-0.409646938573616,0.4195075139350542},
{-0.023979167409295486,-0.39843641421826115,0.41400117992871566},
{-0.006811124492892997,-0.3928543821374973,0.4431787824305169},
{0.014005845974043968,-0.3987516226022434,0.465228750368978},
{0.022459398396562583,-0.39941968814796447,0.47551567811256257},
{0.024563123983432928,-0.39965879793860926,0.48387010210428627},
{0.01233488107191677,-0.4233701183253022,0.4892180308808092},
{0.0019540316433971803,-0.4380851831633063,0.5044856115583349},
{-0.0333847532863578,-0.4774848293448992,0.5159704913686171},
{-0.04032454447982807,-0.4805728301587537,0.4931537299725524},
{-0.032997451498161016,-0.483537671407075,0.49549636509061135},
{-0.018682104534635077,-0.4842936508540465,0.5021742169154356},
{-0.009753536682125363,-0.48915575018994606,0.4998291786839028},
{-0.011091870627585099,-0.4948134803451351,0.5020873043114659},
{-0.009607948057503302,-0.5071126151041289,0.497104448523507},
{-0.012467452831888999,-0.5156252440662121,0.5006989055019683},
{-0.013216823716807498,-0.5163950414156581,0.4890105620842363},
{-0.005762165461572014,-0.5476413240995032,0.4854940060342179},
{-0.012467452831888999,-0.5407159515868759,0.46882060397450936},
{-0.010837741377728987,-0.5534224140796815,0.4627022770701721},
{-0.011987631174950266,-0.558527628395349,0.4571903357990612},
{-0.021701616614485726,-0.5755312582982512,0.4445119096301167},
{-0.03207105125400469,-0.5567729550405505,0.4599230763377031},
{-0.033646091876635364,-0.5446913020509372,0.4713408692301746},
{-0.02474736268309222,-0.5515113380896288,0.4816736563892178},
{-0.021867030925266772,-0.4996599594434549,0.6099856974696416},
{-0.017576472077223255,-0.5227504755160786,0.64461195925441},
{-0.03225248632127785,-0.5150749310807081,0.6635218589204173},
{-0.026878123296543002,-0.5175535423694938,0.6702525792416655},
{-0.031167881106761927,-0.5102592919386356,0.6854913225575054},
{-0.00971228323415818,-0.5087905890872213,0.6881261362220893},
{-0.012878986014280105,-0.5048959431839891,0.7099424013752216},
{-0.01766839116759674,-0.5069478015717163,0.7234687260815111},
{-0.03498102141134053,-0.5158653551541377,0.7424280898331878},
{-0.021907683594865508,-0.5141599456255525,0.7414842670163463},
{-0.022834484357934143,-0.5276103719979606,0.7572030322485811},
{-0.02643174496878156,-0.5409166115619396,0.7680484836153719},
{-0.024258128831714368,-0.5666353327370942,0.7785989528032518},
{-0.028799813037771738,-0.43972090240115097,0.7925868755559703},
{-0.025416029007181706,-0.3886563431581957,0.8203294187949907},
{-0.019043572852988334,-0.35556286725081016,0.8092352451836599},
{-0.04348864388702002,-0.5983460170997543,0.3882524198351383},
{-0.04224443188595144,-0.5912113734554487,0.38890426436491116},
{-0.04688083881476842,-0.5941698064011732,0.39007998763197593},
{-0.034892907250633924,0.5426849025597563,-0.8159062881869751},
{-0.015323352936063966,0.5318945225434072,-0.8079145340703415},
{-0.026324405900284405,0.1576602646388661,-0.9376756525754768},
{-0.0030414404902992355,0.14264861554630176,-0.9210765467740003},
{0.0005850580011462838,0.1501455285467852,-0.9274940613058279},
{-0.0017261363822969097,0.16463770461009283,-0.9349595335716956},
{-0.025086802461268824,-0.37872327387363064,0.39615385693704763},
{-0.027199539723665987,-0.3878096461775877,0.404136198859242},
{-0.0072617082692336245,-0.4850135835989107,0.2083114883643248},
{-0.010356918423509503,-0.47631190971022047,0.20799447764523712},
{-0.04177682605583794,-0.594076685754063,0.44052454359868637},
{-0.03516445907317521,-0.579515219918927,0.4488687543581463},
{-0.036808589208178116,-0.5976276864305393,0.43873202120667537},
{-0.02703813060200796,-0.5819581850245177,0.45042857526210955},
{-0.0334626542148007,-0.5693578600434722,0.45556142538272576},
{-0.02389425739988729,-0.6246024349146755,0.4141990362713932},
{-0.013568879840721642,-0.6253920579502803,0.41561987711278725},
{-0.015676009838346567,-0.6170903021955244,0.4202717040197279},
{-0.023993185571226087,-0.61826442338694,0.4242901102668617},
{-0.01700232821643722,-0.6283839342251821,0.4134266355490173},
{-0.015003338325134048,-0.6247516282095081,0.4152347781786082},
{-0.01365659348251595,-0.6286180375294231,0.4131294505160886},
{-0.017969381130192284,-0.640909362169627,0.4059455430455698},
{-0.017686013999738064,-0.6553654915308272,0.39580760833736184},
{0.001911376379236936,-0.6770966464150953,0.3982221366001792},
{0.004029320387494034,-0.662787307235254,0.40726345052650204},
{0.009435324406300797,-0.662021314815475,0.40421670316061487},
{0.02713946188682056,-0.6721852832529824,0.4159140582538737},
{0.04177442294236412,-0.6819102829626064,0.43126154245440385},
{0.03815953949937538,-0.6853933956834474,0.4703882349972624},
{-0.03925776235690961,-0.6074522150898704,0.43087844611478626},
{-0.030613362672678723,-0.6773762086158828,0.44294107445606523},
{-0.0018290697427587213,-0.6804920454941421,0.4572880624136631},
{-0.009675836013138624,-0.6880656578663314,0.40898027484408794},
{-0.020939829643285845,-0.6665710093997783,-0.2817101837140199},
{-0.00043886859815577315,-0.6650926940944687,-0.2788452719343181},
{0.01893463170884197,-0.6622938679352969,-0.2833256767467931},
{0.027274236500810442,-0.6619718507298054,-0.2873462858479446},
{0.05569946422585101,-0.6672108383621819,-0.311898095172105},
{0.0622485492203699,-0.6684955027733932,-0.33414932386399815},
{0.0532132430777315,-0.6712648907925106,-0.35633887264339675},
{0.02003886235006073,-0.6747818473614415,-0.37929040865345137},
{-0.004425033072849187,-0.6720495073417119,-0.3827428816775013},
{-0.018920413287455223,-0.6643599447444108,-0.384628724976079},
{-0.014369717405871051,-0.6577800197936446,-0.3993207599766257},
{-0.028863495544827877,-0.6602564282284128,-0.39635351561483056},
{-0.024120150066426062,-0.6631475739968702,-0.40096769374401475},
{-0.0007578819118049392,-0.6678270367087598,-0.40680545715028393},
{0.007747537709856887,-0.6610376403668593,-0.4065076713389868},
{0.024572736437328196,-0.6637549609273774,-0.39699334457723423},
{0.058625054620766656,-0.6665255505032319,-0.37617116736443734},
{0.06320298578838743,-0.6676720358896987,-0.3816658863223192},
{0.0697130201889568,-0.6718975104144929,-0.3788948962275524},
{0.08087468123701066,-0.6759924157738765,-0.3633954150998033},
{-0.011101683340936521,0.499037152534824,-0.8492088349665827},
{-0.007545676178056296,0.5072221570266436,-0.8813861238620756},
{0.0035615142979243865,0.49988845548292354,-0.8720119787196292},
{0.012720180265552043,0.48580641078581405,-0.8701087128483661},
{0.01397180186649823,0.4730338626724784,-0.8519612009319273},
{0.005826649006452753,0.47575118323299664,-0.8336220407159516},
{-0.009827832940357531,0.49807911129659577,-0.829800890033127},
{-0.0227131271275064,0.5060232036626653,-0.8239044506062053},
{-0.02313767717454735,0.5171762535541047,-0.8145675537226028},
{-0.005231477902770834,0.5144427119776382,-0.8093764281002466},
{0.009142144562495165,0.5057530536563172,-0.805315967367321},
{0.015940152061010238,0.4933730140770382,-0.8028788097859586},
{0.020540712547176116,0.47697176461823937,-0.7885418348011684},
{-0.009878298323307682,0.515666096995267,-0.6377538739190495},
{0.004949112069597365,0.5244889278549288,-0.6388360760200916},
{0.0240186185221573,0.5215413089198364,-0.6448793056283721},
{0.03929701321031528,0.5204118455871427,-0.6413965934264433},
{0.04405898281813917,0.5236179994801263,-0.6287474051380969},
{0.05514654786741702,0.5138543496954654,-0.6367435649627657},
{0.06773045157305804,0.524108234628785,-0.6125257884114658},
{0.04907908686494221,0.5373053327891616,-0.5815059991725279},
{0.038092052062652364,0.5435297972052591,-0.5516731477301993},
{0.036740701252542786,0.5465140636208271,-0.5209815837398933},
{0.009346409207769581,0.5398606434496533,-0.4983750947727875},
{0.022464605142422517,0.5357112675181965,-0.4380255058453732},
{0.009906735166081171,0.5257081074239786,-0.4210384974773316},
{-0.031765855842829975,0.23724617614581447,-0.23342462494407756},
{-0.02586701330243464,0.21580319461894829,-0.22188126937259917},
{-0.022202064995408055,0.20975736163773784,-0.2299781597037121},
{-0.01351821419831534,0.20290548434551803,-0.2302356933643228},
{-0.009932768895380858,0.1988109795050467,-0.2576213742524815},
{-0.0076754443056423925,0.20155573561105766,-0.5223223207988269},
{0.015543237818918185,0.19342680376696045,-0.5457628904008033},
{0.00724248336144308,0.1884419453844401,-0.5654049386384999},
{-0.008885411939709088,0.18507978937511435,-0.5752308691140241},
{-0.03330364820661649,0.029977438769669976,0.10799832262679526},
{-0.0322176411759075,0.04329869779286042,0.08321040740383238},
{-0.030943189996960063,0.004990665906748778,0.11869177706636716},
{-0.025455880638955833,0.0017524705007808243,0.14354798076387765},
{-0.009162370767566465,-0.00384618311484358,0.16792836799357247},
{0.005085288499780312,-0.017764215317365165,0.17557908025638014},
{0.013617142369654117,-0.04857112875441422,0.16609999915891024},
{0.03034461448252355,-0.07927490857154527,0.16692727097227167},
{0.0278804218745807,-0.11662169506813026,0.14956697897796384},
{0.0016143916057644225,-0.12950478640126145,0.12728671266492866},
{0.016020656362383097,-0.16067977671871675,0.12892183112440475},
{0.042542017437792394,-0.14998872539261865,0.14833518306317664},
{0.0492871564398835,-0.19285466250073593,0.14007848568605483},
{0.04137810947864052,-0.23960162786906714,0.12558110287688729},
{0.05600065444790269,-0.2648605533328981,0.12254617081891296},
{0.04092051662133459,-0.2956240104679623,0.1089637734649011},
{0.07088573956417935,-0.30694447726474416,0.11416310972495963},
{0.07478879636456992,-0.3431834284498997,0.10062897489988026},
{0.05865669561483858,-0.351651199293805,0.0954318414938394},
{0.07455469306032896,-0.3784963799098111,0.08419067744169345},
{0.100174886583057,-0.3774480216568586,0.08583360601995944},
{0.11311425082336675,-0.4088264755817637,0.06804175489764537},
{0.07954415741034083,-0.4248997000513865,0.06361181546812048},
{0.06879623239869574,-0.46309498586368497,0.04724080518720052},
{0.09525070681575047,-0.4765033577503013,0.03889899754121438},
{0.072386684188034,-0.5041990402765824,0.02288464935170005},
{0.08488427606807378,-0.5345749953639936,0.002883936428036152},
{0.08107133602295133,-0.5713900930044966,-0.024843587351772965},
{0.04046632817478324,-0.5866120145260199,-0.027966032792085434},
{0.0666414406505068,-0.605326060443911,-0.04595674155435783},
{0.05110911697194886,-0.6216127614937913,-0.059674514300728024},
{-0.012817306101785476,-0.3047704606087647,0.8471213303956606},
{0.009450744384424456,-0.29270162422434504,0.8229125655198876},
{-0.006738029791397739,-0.3316566944132818,0.8114224789637455},
{-0.019316125972810377,-0.34884856820496635,0.8276707301980445},
{-0.018268368498226304,-0.4299007794498552,0.23338196967991726},
{-0.006526756065158023,-0.42596648217430505,0.24118888431852303},
{0.003957226983279534,-0.4277513947069823,0.23574022503555603},
{0.01044843699497068,-0.39974490950475433,0.2453741066926309},
{0.004937697280596735,-0.3834429887362066,0.25853435711307565},
{-0.0063331051710596295,-0.38549684971849524,0.2760528540777431},
{-0.009907536203905786,-0.3614739256180307,0.3039275685578235},
{-0.011714677536215922,-0.346021305203021,0.3258906238923148},
{-0.02350315068202363,-0.36614838184351645,0.3548038839119963},
{-0.017280288341575346,-0.34676506882316727,0.39902597805717077},
{-0.012683132266164044,-0.35602766944853753,0.4254127647780464},
{-0.024459389585146523,-0.47454962649608823,0.5749957645125023},
{-0.008578414193429012,-0.49068393009983735,0.5815993200790944},
{-0.002602271502959238,-0.5067114954134576,0.6029267518997612},
{0.0019035662604470294,-0.5215256886822567,0.6200299107523707},
{0.01658418647199311,-0.5380797361060989,0.6226132577367237},
{0.015189579619354831,-0.5473058895104497,0.6389528272830278},
{-0.006604256474688611,-0.5320046652442905,0.6521623415296858},
{-0.011860065901381832,-0.5192156958555504,0.6666202732259915},
{0.0015402956069884121,-0.5175427283588617,0.6736539861043969},
{0.011334585088440579,-0.5088040064707835,0.6994914611370491},
{0.006645509922655788,-0.5074256206340935,0.722510885102739},
{-0.01403107866551905,-0.4643552186212456,0.5587593285861161},
{-0.008623672830519227,-0.4779247993700638,0.565100744524606},
{0.013818803641998568,-0.4796700605304231,0.5551768871750239},
{0.015637359763309336,-0.494083134108551,0.5720225123670226},
{0.02036688733923671,-0.5204707218672512,0.6002032232961024},
{0.04615609984295652,-0.5407235614462097,0.5997021741368116},
{0.031952697915419215,-0.5494084135405832,0.6217188990055516},
{0.03616495531610754,-0.5589469716965301,0.6472804165076272},
{0.02980291265363404,-0.5567108746091436,0.6558835627438909},
{0.023756879412967433,-0.5430878245855331,0.6639367965135629},
{0.002951523994487255,-0.530001269644952,0.6582922834824798},
{0.016840718835323037,-0.525724728958839,0.6748385207875323},
{0.028248098236074652,-0.5172389347638799,0.6977798435653232},
{0.03230595559607026,-0.5155237125219433,0.70895592329422},
{0.024140576530953497,-0.5129387634619413,0.7192226248327332},
{0.010901023365872821,-0.5171916735322283,0.7339166624278415},
{-0.006416413104818608,-0.5144589329935865,0.7401631553841156},
{-0.0077405286288915924,-0.5275316700316931,0.7534597824941994},
{0.001125758532755032,-0.5370574115824462,0.7529689465671724},
{-0.011014370218054513,-0.5717990228139578,0.7761521827679941},
{-0.004067770203075106,-0.6039658982177308,0.7841159005607665},
{-0.03344923683123855,-0.5578775862006815,0.4630487259293139},
{-0.015988614849398883,-0.5947211206839581,0.44987726097932473},
{0.001312600605344282,-0.6247806658306502,0.4608556846250001},
{-0.009337197272786625,-0.5629850033703665,0.4990748013125806},
{-0.021052976236011378,-0.5121889920581104,0.5266178861332742},
{-0.02557163060461134,-0.4866414927179654,0.5389955225990792},
{-0.02590786623148952,-0.48159235105002035,0.540103758429421},
{-0.023311502382486752,-0.48176217106883673,0.5321276245503674},
{-0.021088622419206327,-0.4856271785725586,0.515631652368809},
{-0.01850026894844961,-0.6003095610673187,0.4383811666394981},
{0.03485325587831594,-0.6725928112462506,-0.10879195085152323},
{0.010861371993554844,-0.6830635771705821,-0.11969127201201879},
{0.04891307177579271,-0.6898976313712045,-0.13470432292077616},
{0.08424664995968777,-0.6974055586417761,-0.16842801533667018},
{0.08916221857037977,-0.7025207859302512,-0.20465435017608813},
{0.1361146501407223,-0.7023609788842423,-0.2520918101492293},
{0.11056494794655955,-0.6945576689158474,-0.24849675239239957},
{0.09163782596732326,-0.6912988467858958,-0.24231153882970777},
{0.037291815275871415,-0.6878267483351429,-0.23359584677908696},
{-0.031307261688243285,-0.6855792364587558,0.7191080764238147},
{-0.01655414755357041,-0.6941363230201049,0.7257106306931259},
{-0.016128596209248704,-0.6939394679747078,0.7060455526179718},
{-0.023406625624158663,0.42309676416765557,-0.23578848756448856},
{-0.013157146398874385,0.4126037694436912,-0.22992048498034048},
{-0.002751665057248174,0.4106752708809534,-0.1944244963775067},
{0.0008049428840005072,0.3951010929760598,-0.1574588036259778},
{0.01300354739600626,0.3787386938517543,-0.11422659197255965},
{-0.025277649722981094,0.2591914083887084,-0.2277114229195345},
{-0.011014570477510664,0.23570718222529105,-0.19374121111311815},
{-0.014186480003492529,0.23146468564672387,-0.20595683767889678},
{-0.026472197378924135,0.2490650887289572,-0.22844517356687322},
{-0.023621904539521406,0.22731711205037244,-0.21534940669130925},
{-0.02009693759234464,0.21165722309824608,-0.2078094379077533},
{-0.014665300363150504,0.20054462561694933,-0.210069766389334},
{0.0034219334569868675,0.1910799632003223,-0.21355928741277197},
{0.0029539271079610683,0.19277055352915234,-0.23068747869740036},
{-0.0074103007856979545,0.20168029699278384,-0.250431258738822},
{0.0031419707372872226,0.1899178575762758,-0.24641024911875825},
{-0.01067673277498327,0.1830679828786175,-0.2657685297070885},
{-0.02043457503541589,0.18725580862565538,-0.2644638393502622},
{-0.009611953246626333,0.2628187079179785,-0.6678408546112343},
{0.010910836079224237,0.2636425753205853,-0.6565071706903464},
{0.034452536706557006,0.2726642638202054,-0.6096795007611862},
{0.009889312593396,0.28273471109169035,-0.5816840298290464},
{-0.006777681163715715,0.2767000926400244,-0.5937967230343633},
{-0.016831506900340083,0.28175364001600467,-0.5778126140227278},
{0.028392485303959804,0.29168430618709595,-0.5588977078703168},
{0.03718347491009351,0.29243207499636525,-0.5564265061814087},
{0.03736390868008591,0.28924835016247047,-0.5622604646580109},
{0.03831754421027883,0.29208061965081955,-0.5575900136216482},
{0.04521508065850115,0.2917858377313648,-0.5541627732890733},
{0.04737608044983079,0.29601111199670294,-0.5317235009678539},
{0.03593325512534038,0.30378037785755224,-0.5130451012331576},
{0.06567498851512019,0.30750199959066965,-0.5044153204892258},
{0.03903907903079228,0.3133275471701136,-0.4883979684078692},
{0.023593868215660205,0.3224794043162321,-0.4752387192847052},
{-0.02695582396552974,0.06990857354788862,0.12781379555351913},
{-0.026884731858596,0.041821584044287784,0.14896900424189577},
{-0.026213662421032694,0.053990950675695426,0.0458117537081042},
{-0.020009824728918785,0.05141641510741316,0.025234493810180454},
{-0.016702139291666286,0.08037893895330792,0.035365819956335406},
{-0.02545367778493817,0.0809408669872687,0.0773566232410711},
{-0.02767175152127096,0.06254723619921969,0.08798339128174461},
{-0.01864345445959786,0.12019011831729186,0.1162478106634956},
{-0.023534391157183244,0.07697252560417274,0.17228861713235663},
{-0.017543629526414427,0.041943542053083975,0.18019506072066968},
{-0.014808886393211049,0.015220319445874082,0.16632368897143138},
{-0.000609489654796761,0.0205634419954493,0.19308856554552076},
{0.027899446522915084,-6.648613944226118e-05,0.2101320470801971},
{0.028354836526203343,-0.03464048020615509,0.18755619780988247},
{0.05345535676021853,-0.04983696877674714,0.19758078566590873},
{0.05657439778977642,-0.0738743115580546,0.1862134581563874},
{0.05729072586442995,-0.11787952471221713,0.1663873714784875},
{-0.027246400436405402,0.025667655013835937,0.01217437311781142},
{-0.02129048395100693,0.030240579695052908,-0.001628710156879264},
{-0.009836444096972038,0.06596866900756618,0.00566774312799662},
{-0.007969425187272632,-0.09308159651644671,-0.6929962459362349},
{0.006312478447076027,-0.10927858132997109,-0.7095262622253391},
{0.04015913016904701,-0.0940628678515885,-0.6900233943096675},
{-0.0010102088265556868,-0.6867437451962762,0.4046532687750249},
{-0.005531867086997919,0.17840073599355324,-0.5883891169399074},
{0.013955981369462269,0.1750688191621064,-0.6018890073979848},
{0.011226845501031132,0.17369463877399557,-0.6224450397935565},
{-0.013682026433447174,0.15035299734335802,-0.9108130493867856},
{0.0015152631749694855,0.13444678926016546,-0.9057074345522057},
{0.011063834303723898,0.1299788005339718,-0.9044466010162767},
{0.015548845083690423,0.13447923129206196,-0.906944837731765},
{0.0164387981068272,0.143585429282178,-0.9112183745260357},
{0.01671595719414072,0.15586994510087268,-0.90668129628747},
{-0.011775756670342096,0.11828965607841517,-0.2775664150473353},
{0.008421410779806312,0.11003375973911798,-0.24637460293556332},
{0.016253758369343316,0.07809538037481362,-0.24470043388213766},
{0.004588044270156409,0.05293277970939149,-0.2652538629047794},
{0.014898802889023012,0.029807418491397446,-0.265042989697452},
{0.014380331157047066,0.00044037054407691843,-0.2788895292741275},
{-0.009681843796823165,-0.014499585663185226,-0.30317379196486965},
{-0.02794090023033843,-0.03862844701595386,0.48553205533088667},
{-0.02859174346283044,-0.0282886507759453,0.5161539290304518},
{-0.028609766813884073,-0.0032710379567767916,0.48532859172343684},
{-0.025906864934208757,-0.03742709053850168,0.4611817070196146},
{-0.023151895595934096,0.004531470973793643,0.44928549428639736},
{-0.02745847520046973,0.02019416355830615,0.4714169678235121},
{-0.02833721369406203,0.020326334799366064,0.5025555109199479},
{-0.026036432802338708,0.00246259053229364,0.5306503105423386},
{-0.019394827939077867,-0.030011282617759556,0.5621284936764072},
{-0.024031435127351,-0.05659312204892658,0.5473509478880838},
{-0.027159487832435703,-0.07365662952921805,0.5199766817889258},
{-0.02947749103738804,-0.0673594709305376,0.47227207570127855},
{-0.02418964009771059,-0.06918643794900672,0.4451595487113103},
{-0.01767099454052671,-0.01433997887663256,0.4393858683310096},
{-0.013507600447139317,0.02468538238141336,0.42657567143991754},
{-0.019234420114700605,0.04264364911178922,0.4329301042430573},
{-0.02434744454915789,0.04493181365777501,0.4542321031127929},
{-0.026984661327215536,0.06974355975601988,0.48712391774783403},
{-0.02426373609648661,0.04778811428086229,0.5219766729775096},
{-0.01696507995759306,0.02576718396354317,0.5590805447537829},
{-0.016211103105183075,-0.0036048704701811753,0.5704596875712171},
{-0.013819604679823183,-0.0490811895892318,0.5806178484844965},
{-0.01896687348128235,-0.09848900235144653,0.5563766415768269},
{-0.024184633611306808,-0.11374877291018241,0.5296337935429141},
{-0.029287845332412677,-0.09501990779253601,0.48475364682482613},
{-0.02818301391282546,-0.10041850221146516,0.4575662227982573},
{-0.01502076089781922,-0.14125541050985657,0.4100871088582366},
{-0.01771184746958159,-0.07473803059243556,0.4306523531887914},
{-0.015488767246845014,-0.04745588384310713,0.42834836814576965},
{-0.007842460692072652,-0.010478175524209167,0.42269143902840517},
{0.013635566239620048,0.008609354279404395,0.3981912966439318},
{0.0136868326603948,0.04151158240616543,0.38384490946470246},
{-0.009913143468678024,0.05717247265557255,0.4071777394792693},
{-0.02065466017772626,0.06752408420349404,0.4383216895810211},
{-0.025220375518521795,0.08225356772234108,0.4643436035727888},
{-0.02281125426102058,0.10885082713163174,0.48223097845568713},
{-0.022553920859866048,0.09600177990604626,0.5066834590895964},
{-0.019958958827056335,0.0753414123338197,0.5293101742617735},
{-0.01865106431893161,0.04615179426464928,0.5502360858728568},
{-0.008072959326102904,0.024638321409217786,0.5845547491329767},
{-0.006309074036321461,-0.012950779029310374,0.5939733518746887},
{-0.0011906425965480917,-0.044887155799053245,0.6052101102187993},
{-0.00798764879778241,-0.08261603733797507,0.587866239499896},
{-0.0042572156485943214,-0.12014025371271017,0.5801167993252057},
{-0.014926638953428066,-0.1481849884710631,0.5399261282918149},
{-0.0212069757577918,-0.15307592516864849,0.5125035996637243},
{-0.02774805037406464,-0.12207776395097486,0.48657600787580385},
{-0.026522863021330438,-0.15685161695492678,0.46235763054613555},
{-0.025993577278722313,-0.1627975204675177,0.44584964279720807},
{-0.020739770446590602,-0.13794852611042865,0.42579365826364635},
{-0.018333853340387812,-0.17869391583735886,0.4159156603295228},
{-0.002479712715794587,-0.19967750217181376,0.3754139863607289},
{0.0033366229286663734,-0.14067706120049137,0.38258247385312405},
{-0.008200124080759036,-0.09683906469221522,0.40836207390294865},
{0.0010698861444887941,-0.037164149872574895,0.4102959794710026},
{0.03539635952339851,-0.034625661006399876,0.3883593583847232},
{0.047938809521616194,-0.025643023100729297,0.38126797078294633},
{0.043136988282018174,0.009771660162907068,0.3705745163433744},
{0.03836640751757977,0.029606758516333764,0.36128327861577453},
{0.014067726145994745,0.06107713153161235,0.36171083255465775},
{0.002277851183993979,0.06724251940814518,0.3807482974942335},
{-0.00332580891803421,0.08225336746288489,0.3673361206779503},
{-0.016636253930592478,0.080615845889935,0.4074460871505121},
{-0.02278081482368557,0.101333687926077,0.42161524471104755},
{-0.02539239839135584,0.10988716981721518,0.4547219377425392},
{-0.021418049224575363,0.14764749209075279,0.45937116127654987},
{-0.0174535127711463,0.13714969113984077,0.4813604505997971},
{-0.014350893016992819,0.13282528844370764,0.5105598813823189},
{-0.013786962388470507,0.1054275919881799,0.530588630629844},
{-0.007321385587166737,0.09804482687770276,0.5575579721086639},
{-0.008279026306482685,0.07236615759377849,0.5698370809220425},
{-0.005211652216611843,0.04798897451538213,0.586897985029404},
{0.006841764189684151,-0.009970317543409246,0.6119524455885044},
{0.01933254724821478,-0.04480284656801351,0.6268541522396416},
{0.006915059150635561,-0.07062710447655983,0.6107208499331733},
{0.008463665525054256,-0.11118304875797082,0.603200306316864},
{0.0029803613561730563,-0.13325364342041549,0.585990609433582},
{-0.0028798311091850636,-0.175854036489676,0.5495898486078563},
{-0.01003369966128116,-0.19014915724813067,0.5239027684267736},
{-0.016466433911776098,-0.20145660718026273,0.491798774492232},
{-0.02357564460515044,-0.16410741757020395,0.4824855082244555},
{-0.0233121031608552,-0.19149850546367872,0.468535835027862},
{-0.02185261224442388,-0.21740587104652784,0.43995800959723413},
{-0.019995806566988194,-0.20222440193514715,0.42215514420483174},
{0.015046394108206587,0.4907834590495446,-0.9034190697467639},
{0.019628330464950383,0.49127469549548397,-0.8870889123948987},
{0.0313533213631581,0.4730508847262513,-0.8938508731913066},
{0.03278197232334211,0.4631516592897757,-0.8843661848290645},
{0.02911121649208714,0.4624305249881746,-0.86679081417885},
{0.030955005304872985,0.45482086591387794,-0.8416951001717825},
{0.017932132871348115,0.46181172326866676,-0.8367911466095472},
{0.017482350132832093,0.4627349193615248,-0.8225268658073398},
{0.01543149304238571,0.4718501290271676,-0.8094649427798655},
{0.012896008068052965,0.4841278360243531,-0.815903684814045},
{0.0009108801363045928,0.4877236948190074,-0.8332479560518609},
{0.0005720411364964416,0.4998680290183961,-0.820091510561083},
{-0.014737994545733452,0.5072644117718916,-0.8151671305343203},
{0.02571241300228576,0.4601740014362607,-0.7916700877657092},
{0.027835764015858938,0.4550071072080988,-0.770043268058096},
{0.03230435352042105,0.4505475293790634,-0.7827054732110922},
{0.04819974759298146,0.4307679028949908,-0.7484358735177296},
{0.050490315252441055,0.42505970735685145,-0.7270914196432897},
{0.05079871481491419,0.4273939315777521,-0.7029004778591142},
{0.04664993966182585,0.4350510521431567,-0.6839949839011423},
{0.0380684214468265,0.4550493619533468,-0.6661616790714049},
{0.03207245307019774,0.47655642650618135,-0.6635338744877863},
{0.02876757126533136,0.49218847939390276,-0.6560335570765483},
{0.02893238479774395,0.5064509578610047,-0.652093852795682},
{0.013281707780600541,0.5148888900459434,-0.6477370080676523},
{0.043853116097215546,0.5060504389487019,-0.6480243803872296},
{-0.022969659490836326,0.4796081803584724,-0.2318898364721333},
{-0.01703316817268453,0.4729103025880329,-0.20524831972303315},
{-0.010697359498966863,0.45771201168233555,-0.20820434955528383},
{-0.018203484434433256,0.43723768514487366,-0.22930088222300812},
{-0.010883400533731505,0.42684622196517796,-0.21922683028131248},
{0.0013378332968193548,0.44041780530855773,-0.17608613719935548},
{0.01174371515735787,0.43135646543661965,-0.15095858193875986},
{0.014278799612778309,0.41303973427973273,-0.15384011525332222},
{0.012567582559964685,0.39709868105116986,-0.12193137428852821},
{0.020222700530807707,0.3859322137761684,-0.08950836704033747},
{0.03599553581620347,0.371633488347503,-0.045462501216576204},
{0.030750940919054722,0.3545946127803182,-0.057740007954305596},
{0.03303089482733829,0.3460705690292342,-0.0692957796120654},
{0.027256813928125276,0.33902804473475834,-0.08718655890571826},
{0.05090685492123595,0.34863449084634046,-0.05093198748298296},
{0.056132425170050314,0.3337780428322935,-0.08812457419833136},
{0.04083460531464565,0.3279232573722515,-0.10745782235464268},
{0.04319986975124971,0.32264862355668,-0.1206547202555631},
{0.031080367724423758,0.31135098633789937,-0.12556388056365828},
{0.020739369927678292,0.29976858017247143,-0.12411900858752599},
{0.018030460264318444,0.2742745501071187,-0.10892572416823236},
{0.011936565013631656,0.26327329688344214,-0.13003747655462417},
{-0.01878343581944768,0.4857357191977925,-0.2566779519545523},
{-0.011033194606932745,0.495066007519342,-0.2571002991475756},
{0.0034685939102701434,0.49468551455265436,-0.25108490560370017},
{0.009520234415708989,0.4923250563429979,-0.2217420890505739},
{-0.0026937900744204253,0.49305039609317824,-0.20660007105205505},
{-0.015063816680891767,0.4883230713712685,-0.2169312561354491},
{-0.014418180194259686,0.4864278158782519,-0.1996218300430037},
{-0.006092193045309506,0.47901541236826434,-0.1815087627530228},
{-0.0017890178515284423,0.4607675704642935,-0.1891622786482166},
{0.005745143407799139,0.4651418377650082,-0.16968684627803782},
{0.006034918840850201,0.4572113630419572,-0.15475409941119717},
{0.015825403392635495,0.4585282692256087,-0.11787411770690107},
{0.025521966259485784,0.447751707111734,-0.10363146492595808},
{0.027682765791359278,0.43818551315083815,-0.11603813901290512},
{0.0249047666156272,0.4245218104576289,-0.13903773729243607},
{0.040133697218115785,0.41760865377182677,-0.1330027183218578},
{0.023775503542389515,0.40614379990715976,-0.13192352011265795},
{0.019178147207522058,0.39963696965788875,-0.11548101720589193},
{0.03485986444036894,0.39150483366249306,-0.06996785034690946},
{0.03483743538127998,0.384209381674898,-0.0548298375375136},
{0.045196857047991375,0.3830310550349032,-0.04357525610180551},
{0.05150863458697087,0.3702715237862174,-0.031322181017726575},
{0.04251718526522962,0.36410132968273695,-0.03537843630207298},
{0.0459432240410676,0.3562447506990056,-0.03747335047287267},
{0.060238344799522246,0.3479634214087772,-0.049569822662241206},
{0.06622289838715038,0.3469999731652328,-0.0611984887620401},
{0.06569100927161228,0.33950786639169706,-0.09571841277559207},
{0.062333659489234236,0.3312365500742762,-0.1175879469440607},
{0.05105885184845486,0.32938314880759506,-0.11176620429428369},
{0.05875742612128273,0.31821848386769896,-0.12647766446207706},
{0.04956832071632006,0.308266990713168,-0.12087780928971577},
{0.044161715919144834,0.3015711155372901,-0.11551285845942001},
{0.03508275321506543,0.28207385488639075,-0.09269649758226758},
{0.02227636125364021,0.28317167722501274,-0.10551770874344801},
{0.02643454860116767,0.2593574234778579,-0.08203127972601301},
{0.021255438546180422,0.2507839156411046,-0.0990188888724231},
{0.014707555108398435,0.24893752345538878,-0.13607189474683398},
{0.007325791295202058,0.24405119272529485,-0.1522069993884076},
{-0.002322308783259593,0.2463882205785816,-0.16516658983378865},
{-0.014178870144158775,0.26481068872831637,-0.17741105376125307},
{-0.00241502891145769,0.23307437115526874,-0.16830245265766325},
{0.0003429443186592505,0.22466948178059495,-0.17690639993175156},
{-0.0030432428254046,0.22242076834747096,-0.19376263887492634},
{-0.009290136300591051,0.21406093735043122,-0.1994752401211009},
{-0.02386141484907846,0.40841614395610953,-0.8473358082731987},
{-0.013183580647086367,0.40147695354100765,-0.8381675298516759},
{-0.020656061993919325,0.39708205951630926,-0.8521656658366578},
{0.009560686825851568,-0.15317545411835573,-0.14894417206933303},
{0.028879716560776137,-0.13788764723575864,-0.1525396303450751},
{0.007379661088906783,-0.23552795001203558,-0.769381811074428},
{0.026650228035442716,-0.21519160223986197,-0.757483195227737},
{0.025216170069942614,-0.19622823329906225,-0.7556586313227417},
{0.03037625547659547,-0.17823011493691224,-0.7474161523670066},
{0.022342647133626322,-0.16032992344882027,-0.7362637032539358},
{-0.006109815877450829,-0.1545458295767997,-0.7343648430907083},
{0.044764697141616676,-0.14664158884250433,-0.7255984853976812},
{0.04520506768569357,-0.13070173717067832,-0.7190009376147736},
{0.045665464175385626,-0.11420316161618993,-0.7064220403955365},
{-0.0030772869329503366,-0.44651390341326214,0.2250918289736182},
{0.008151060514001935,-0.44439816225902273,0.2268170641883624},
{0.028599753841076492,-0.4309421286218424,0.2159650042595186},
{0.022965053523344842,-0.41270029450155615,0.22687674150629553},
{0.033696557259585515,-0.36894120021900373,0.23630215306951685},
{0.02948850530747636,-0.33887424547243405,0.2562511990534937},
{0.006876208816142192,-0.3465431813457515,0.28463016684416326},
{0.0031411696994626216,-0.31966956388697193,0.31614880238837434},
{-0.012261786370421522,-0.32523377287613825,0.35439996058893897},
{-0.013292722050688873,-0.3103943469158642,0.38618213757744524},
{-0.014442411588454006,-0.3293863529588935,0.41788921726989486},
{-0.019081021371288642,-0.34402051297661246,0.42095478902466027},
{-0.003645623269507977,-0.317578254386383,0.45294403429082714},
{0.004043338549424629,-0.3436133855022567,0.4617730731936296},
{0.0011027286952976214,-0.3750967753821851,0.4539463328688649},
{0.018076319679777113,-0.36957241802479285,0.47314160225988783},
{0.029133044772807645,-0.3793022239613643,0.4826341007409199},
{0.0365404417963914,-0.3568957941909538,0.5014971396941877},
{0.029901440306060525,-0.383848313875457,0.5039046588760397},
{0.024390099813318127,-0.4007612262447226,0.5010131125886699},
{0.015161943814405941,-0.4133869841766993,0.49649606029571913},
{0.011887301187418415,-0.4210853581900711,0.511796884042966},
{-0.018890374369032518,-0.48155109760205317,0.5072980553605251},
{-0.013132314226311611,-0.48274604577690855,0.5062543030750639},
{-0.01586725761897114,-0.6088944836930728,0.425880570867616},
{-0.011230049652329563,-0.6113178233719606,0.4247551127240452},
{-0.00556390859998214,-0.6177984196324758,0.42535629161141164},
{-0.012091966351605145,-0.6093763079445729,0.4276062066012725},
{-0.016428584874563484,-0.6131247644448146,0.4240417885412339},
{-0.008662322905556444,-0.61569549508343,0.4314980488721186},
{-0.00678609206087407,-0.7022532392968329,0.6107054299550496},
{0.040836808168663315,-0.7026972145111205,0.5565062094449568},
{0.07700947347383268,-0.7016009942481477,0.521776213261902},
{0.10517836909499947,-0.7036600619762964,0.47159880340969756},
{0.040087637543200966,-0.6953611098539266,0.5016064813572464},
{0.02212256199131594,-0.6801135551220161,0.4812957667954601},
{0.02295464003162497,-0.6750083408063488,0.47193984526352334},
{0.016462628982109213,-0.6776597760057931,0.45904433784411075},
{0.029116022719034775,0.529587333349087,-0.3945495784338188},
{0.05248950540320038,0.5330203812058902,-0.3777145669929961},
{0.06990687134251135,0.5287073932987578,-0.3455663157186451},
{0.05212082774442566,0.512802186512846,-0.3202200771319321},
{0.03299504838468719,0.49938620476689594,-0.29323591645335695},
{0.03390002086703532,0.5119757157373093,-0.31363174128400756},
{0.031617463585821785,0.5199258158870632,-0.33184513856152026},
{-0.015414871507525154,0.4190645400180474,-0.8169914941798594},
{-0.009281124625064235,0.41391386680583353,-0.793832689632688},
{-0.007122127428296105,0.39833968890094007,-0.8165150769336752},
{0.00045428857627942334,0.1449077424711456,-0.8783337692314163},
{0.013064826789588585,0.1282555679137891,-0.8896892814330246},
{0.021138687283244167,0.12835970283098783,-0.8875453036954677},
{0.024367871013685323,0.1346608666187913,-0.8913286053410799},
{0.020768007029907942,0.14795789424778744,-0.8873798893846867},
{-0.01949095247803054,0.15657626020271864,0.4356390139064171},
{-0.0225549221571468,0.1387239307246468,0.4161747960657828},
{-0.017093446268986102,0.17910985472778532,0.4193298837974479},
{-0.01008596737933667,0.19472208192934762,0.4484085581279105},
{-0.009881502474606101,0.17006613768798853,0.48144375853355603},
{-0.00932317911085603,0.1549004890736438,0.5030135042961661},
{-0.00012826618166496834,0.15043370190418703,0.5359123280121725},
{-0.0035531034007660364,0.1250726441177189,0.549745650464742},
{0.008789287400756416,0.12742008546272549,0.5724648855056611},
{0.004455472510184189,0.08368121738524431,0.5887237504911362},
{0.01733956514059615,0.0519979685680768,0.6146863876838832},
{0.024862511870379255,0.008326187408406325,0.6289781040315833},
{0.036846638504846874,-0.02724069304190509,0.6381179456103326},
{0.054145450846116217,-0.046469606021561534,0.6520061391538877},
{0.04585831403165941,-0.07121106105069727,0.644549878823003},
{0.03021064090635827,-0.09661477410132567,0.6272366478008908},
{0.021801546083105264,-0.13749834285300033,0.6051716604032183},
{0.01558429100742922,-0.1791048482413815,0.5742552050436545},
{0.009282726700713438,-0.19104171364419742,0.5567785623053226},
{0.01454274157598584,-0.21805691453847603,0.5470599708982957},
{-0.0018156523591965814,-0.2154208993171553,0.5176971283995544},
{-0.006913457074986354,-0.24629950563950653,0.48636653648466943},
{-0.014761424902103167,-0.2306410185035732,0.4652309532229957},
{-0.01653292005121836,0.11809580492486066,0.38291410351251076},
{-0.008098192017577976,0.09652005137856606,0.3574543178141599},
{-0.013974605498884358,0.12125229447271882,0.33358258960308973},
{-0.019157921002450777,0.14316127975404935,0.3694700854426995},
{-0.016596802817730655,0.18635163718113185,0.38671843240101866},
{-0.010117007595040138,0.20259408089120262,0.4100833039285698},
{0.0011001253223676564,0.229267639153287,0.42295938618073575},
{0.006093394602046404,0.2206076192314763,0.4568322718914625},
{-0.003187029114921297,0.191877196095261,0.4691556380446506},
{0.008941084068519168,0.20543496153616622,0.4908072899248266},
{0.0022586262762034426,0.17910004201443386,0.5142318387703108},
{0.013253471197283194,0.17744389631206187,0.5411633312119181},
{0.025563820485821422,0.16519622823329905,0.5691475876145133},
{-0.024628608825594443,0.09885167222653671,0.15370433934205152},
{-0.02150356001235201,0.11203595378171961,0.19185997378203198},
{-0.01877702751685083,0.1286342585453714,0.16470959775485117},
{-0.014619641207147985,0.15019939834048993,0.14107237336693418},
{-0.006037321954324026,0.17254214560384434,0.15312518899486174},
{0.0005676354284611121,0.19074132445997033,0.1620383368692478},
{-0.01710466079853058,0.1511165866496633,0.1942636880342171},
{-0.01702555831335078,0.11843764781651106,0.22449465527537477},
{-0.01981296968352198,0.10122674937649219,0.21246146507415},
{-0.018463220949061606,0.11138130561956068,0.09265824802614266},
{-0.020113759386661365,0.09551434838977377,0.07140591350153257},
{-0.009506616772690702,0.13119898140030223,0.07685216967102576},
{-0.009655009029698881,0.14838965363524984,0.10245634243726169},
{-0.0012324968228837295,0.17636549914068664,0.12622914247699318},
{0.008483090692300941,0.20014130307226038,0.13302674945659596},
{0.023905071410519466,0.22251769392424825,0.14474052582525918},
{0.007366844483713096,0.21386868827252586,0.17177154721657378},
{-0.005083285905218807,0.19330684835272577,0.1900694539845824},
{-0.013375429206079401,0.1744311930537204,0.2191593428445894},
{-0.018434784106288113,0.13860597790497367,0.2474307713073057},
{-0.019009528745442598,0.12891442152452717,0.23922353801585328},
{-0.015286304936675961,0.111294393015591,0.2528411810341478},
{-0.015974196168555985,0.08814740377633262,0.22366738346201334},
{-0.009883104550255314,0.06489627961987549,0.2181422250667965},
{-0.001937810627448929,0.04707679269261255,0.21949277483908147},
{-0.01014224028651521,0.09314307616948517,0.03474882057193298},
{-0.008008475781222154,0.11543335545532792,0.048922984618872185},
{0.004424632553936878,0.14638745959264823,0.05922913727024732},
{0.0009006669040408728,0.1623365231994572,0.08600002162802124},
{0.004745848721603706,0.17760150050405304,0.10692312960671845},
{0.030591334132502066,0.21488760838542412,0.11296055169077054},
{0.039146217839833276,0.23891894338304706,0.14175545837186657},
{0.03347987652802971,0.24939771968562469,0.17042360081721877},
{0.02185621691463459,0.23787839524888443,0.17956744758509122},
{0.007000569938412201,0.220701140397499,0.19767610916703676},
{-0.0074547583849635625,0.2003728030035714,0.22362873338697614},
{-0.009805604140724726,0.1948302220356694,0.24421440418205825},
{-0.014574983348426225,0.1696423886787722,0.25892746642550085},
{-0.015361001713820426,0.1416701478435461,0.26210418217843034},
{-0.013870070062773333,0.01672086355081644,-0.025848489302740637},
{-0.0030376355606323607,0.042078917445442315,-0.024994382722254963},
{0.0008922560068825116,0.07189694968801578,-0.008642397089669386},
{0.007817828778966023,0.10957877025474205,0.017618426433286954},
{-0.0173884284478971,-0.2604262081953379,0.40755923374323766},
{-0.015771133080018478,-0.23159044858518696,0.3961492509695561},
{-0.0048842280058043214,-0.26116636714527336,0.3633413450466424},
{0.008863183140076277,-0.22562992613229696,0.34770408541306114},
{0.015908110548026017,-0.19280139348539968,0.34925709749551515},
{0.030352024082401154,-0.1519252343336026,0.35156628928439687},
{0.0191338898677126,-0.11239662106224822,0.37440387766390126},
{0.0065750185940905,-0.08248426661582746,0.395708680166023},
{0.019066402430989584,-0.05478017319238806,0.3927977087114064},
{0.035424596106715854,-0.09369038526314692,0.3709802420015371},
{0.059001942917243574,-0.0678076515934044,0.37047398609638643},
{0.10544631624733003,-0.03801685463686751,0.36014920931558925},
{0.0775746056590919,-0.02048474002918181,0.3632480241400758},
{0.049389689281433016,-0.01136232102311754,0.37441709478800733},
{0.0698407857219814,-0.003431245521697908,0.35688618173705844},
{0.04701501265038984,0.022953338345159988,0.34935242099664315},
{0.03382111864131168,0.04595033325176099,0.32304553779877204},
{0.013977208871814318,0.06601933464997249,0.3198203592574539},
{-0.010241168457854001,-0.256336309322358,-0.2088403735880206},
{0.004613276961631487,-0.22331072137060776,-0.189851972215202},
{0.011757733319288467,-0.20643906244930932,-0.18027556502204256},
{0.023313304717592107,-0.17632064102250875,-0.16934019715943976},
{0.05021996498663668,-0.14859532009671728,-0.1662539986806907},
{0.06442556976819167,-0.10938131443097676,-0.1566014928941937},
{0.044076205131368194,-0.08520819573839866,-0.1366951021743771},
{0.06391590945228637,-0.05678857527813033,-0.13211877308240555},
{0.058381739381542716,-0.03741747808460642,-0.11792378205202662},
{0.07658031745930026,-0.0013821907663568846,-0.1085127891696482},
{0.05311050997672583,0.034278611368889524,-0.0756932681982777},
{0.021691803901134305,0.033051020902681506,-0.05774321210560402},
{0.027708599261202806,0.05649639673160547,-0.0430409638727936},
{0.00477368478600875,-0.3081318155802658,0.7874754531971623},
{-0.002821555607445012,-0.3100589123268106,0.7692872886111245},
{0.017486155062498968,-0.27174527317592667,0.7644970824199832},
{0.011445929346060752,-0.2597487304551777,0.7422412477605986},
{0.015174159641231174,-0.2364173022568039,0.7217046405322736},
{0.018305416497614302,-0.223532008069655,0.7046719730082294},
{0.011730297773795724,-0.2357173954575548,0.6983139355348789},
{0.0048511851955393365,-0.23948467634667475,0.6918485589930313},
{0.01765517404349074,-0.21993214408587763,0.6888276450969876},
{0.03176285195098769,-0.19956816050875512,0.6985612559632258},
{0.05413223372201023,-0.17539043584868552,0.6945054011977918},
{0.038792559640269925,-0.18058917133037564,0.6738872883708131},
{0.04694872677040372,-0.16240401063618023,0.6685101217136922},
{0.05565180247528698,-0.11867014904510281,0.6683997787533528},
{-0.012472259058836631,-0.4614055970915918,0.2103643480493327},
{0.01460161785609435,-0.46427871950899585,0.215940372346412},
{0.045167418907937115,-0.4500973461216351,0.1995036769638744},
{0.0450562749097731,-0.42455765690027997,0.2063449405049181},
{0.04210204741262779,-0.3983483000575545,0.2160256828747325},
{0.058026278846873995,-0.37232979047654136,0.21299195237349508},
{0.05521643841761385,-0.340096428933326,0.2311775135866028},
{0.04637518368798615,-0.30257281333695935,0.25695070533383046},
{0.028360443790975583,-0.3070067579556073,0.27707978456888743},
{0.0038819294277666083,-0.2906661871120223,0.3286253670255182},
{-0.012424797567728754,-0.2812956466397865,0.3768728764987918},
{-0.013168360928418863,-0.2809826411098219,0.4361731058759728},
{-0.011752126054516235,-0.2559193691346508,0.45548572730830056},
{0.004191931065888964,-0.2922926944148839,0.48373112204171725},
{0.019279678751790815,-0.3248530796499945,0.4906502865112039},
{-0.01718436406207883,-0.5123506014392246,0.528254005890031},
{-0.02089116659544106,-0.4869362746374202,0.5374997847210846},
{-0.015115083101666524,-0.5071859100650803,0.5256396186899747},
{0.006330702057585805,-0.5825970126896406,0.4878041991203803},
{0.02116812542329842,-0.640084092950827,0.4468857852233353},
{0.006896034502301177,-0.608979593961937,0.4452893168388964},
{-0.010536951674589599,-0.5989249671874881,0.4324042229112037},
{-0.009086071914772781,-0.6248179140894943,0.41763108283091566},
{-0.0058502796222786296,-0.626379737588019,0.4232033021983281},
{-0.010361324131544832,-0.6591445877278601,-0.4061558154745287},
{-0.012020673985215245,-0.6700675395041815,-0.277035527229078},
{0.014680520081818,-0.6666493108471335,-0.2758501915081179},
{0.02166817328530844,-0.6623092879134205,-0.2773327122620066},
{0.01656095637507955,-0.6627800978948324,-0.277830557269999},
{0.018301010789578975,-0.664594448567564,-0.2770471422775348},
{0.03366511652496974,-0.6620735825335303,-0.2806688345420326},
{0.03134691306056126,-0.6627294322524262,-0.28084846727420043},
{0.028392885822872107,-0.6629797565726153,-0.2793959854387344},
{0.032435723723656364,-0.668916047631311,-0.2795591968954978},
{0.03699242738892509,-0.6633796747065497,-0.28301207043846005},
{0.05200547829768247,-0.6688275329516922,-0.2952939828842248},
{0.0746912700094242,-0.6779781885410738,-0.28838603294428256},
{0.07932547408422351,-0.6709424730681071,-0.3341457191937875},
{0.0748284477368879,-0.664968733491111,-0.33354594212261407},
{0.07455509357924126,-0.6636336036969498,-0.3521712731014302},
{0.0401361003315896,-0.6721159934811543,-0.37697500882142904},
{0.017965375941069246,-0.6680206876028583,-0.38956492031075457},
{-0.011213227858012846,0.5897584911010705,-0.23474533605739595},
{0.0031982436444657637,0.5926302117022814,-0.22511926451911096},
{0.0013736797394704558,0.5835192074852178,-0.22707259525441156},
{0.00221296712020093,0.5655711539871057,-0.23148731496526903},
{-0.011679431871933281,0.533465758236371,-0.25545396615855503},
{-0.018121177797955034,0.5074412408716733,-0.2797606579083861},
{-0.013511004857893888,0.5115201254745649,-0.2575256502324411},
{-0.0016626541346969168,0.5176905198375014,-0.24352571191235367},
{-0.0006915960318188296,0.4975283977921795,-0.2520862028844571},
{0.007247289588390715,0.5138239102581303,-0.2491233642306973},
{0.022611996102149937,0.5044637832776144,-0.2830114696600916},
{0.015034178281381351,0.49552199830099875,-0.2657438977939819},
{0.024680676284193796,0.489014166754447,-0.2510612749878743},
{0.03996527901549247,0.4811387633818375,-0.21955966149743605},
{0.01923622244980596,0.4940200523798633,-0.19199374709874112},
{0.01541707436154281,0.4956465596827249,-0.1714291035465549},
{0.004792509174886977,0.49518676397140127,-0.17509044718337077},
{-0.006809722676699936,0.4922002947018156,-0.1896617257318582},
{-0.0011630067915992,0.4899858256356935,-0.17354063925221516},
{0.009821424637760676,0.4814635842197151,-0.16298155890772084},
{0.015620738228448772,0.4758094587347367,-0.15408903775731836},
{0.014779448253156784,0.4691474274069485,-0.12905960963023694},
{0.02424411066978377,0.47151008847062253,-0.08956443968805984},
{0.032580311050997665,0.46528622483289345,-0.07335423775042946},
{0.04055544363277061,0.4618161289767022,-0.06589937923573783},
{0.05035514011953887,0.4524393804613257,-0.07266374314561946},
{0.04796223987798591,0.4325552185411419,-0.11591197555552976},
{0.041137798131258854,0.4269775921684133,-0.12766580381542325},
{0.05891863498348459,0.42390601262996336,-0.1277220767226018},
{0.06018908097330901,0.41366955026932883,-0.12885394316876944},
{0.041574163486212734,0.40961850173084247,-0.1285275202552427},
{0.046286468748911076,0.40403446705551704,-0.11109132992705349},
{0.05036935854092561,0.39508767559249763,-0.07286780753143773},
{-0.015868058656795747,0.3984826741526321,-0.8625108690819826},
{-0.0011019276574730263,0.39995077622567793,-0.8585307123909736},
{0.008620869198133095,0.41236485991250266,-0.86083549847182},
{0.014944862563937834,0.3924188178203681,-0.8451752090007814},
{0.03619919968310943,0.3757668435224677,-0.8242312740386444},
{0.04560999230603169,0.37414734530057137,-0.8294944930652152},
{0.03715003158091623,0.3905287690732112,-0.8584802470080235},
{0.03521912990470453,0.4057224540114172,-0.8873542561742993},
{-0.01654012939163981,0.3928603899211819,-0.8561346079981221},
{-0.0005814533309355663,0.39364821062168137,-0.8510031596936992},
{-0.009912342430853418,0.20281136240112688,-0.20113979672063123},
{-0.004485110909694602,0.19519088931619805,-0.20551005883222306},
{0.009388263434105221,0.1926806370333404,-0.20511494692523635},
{0.031120619875110184,0.18963348914854083,-0.20606197389337624},
{0.015613929406939626,0.178995706837779,-0.23002241704352158},
{0.028068265244450705,0.17939161978259033,-0.5928400836123281},
{0.0526813539621934,0.1771138687283244,-0.6098919760441628},
{0.05739766441401478,0.17446784053419606,-0.627197196688029},
{0.04754169502006799,0.1733291652665193,-0.6380104062823794},
{-0.015968588903783745,0.1851056228449579,0.3659779610463316},
{-0.016643062752101628,0.15109696122296049,0.3453718637867221},
{-0.01400344286057016,0.19429152409862216,0.3408351860670685},
{-0.0055667122323682615,0.2274294576052734,0.3378977803642399},
{-0.00726691501509356,0.2188895933571535,0.3920741712963315},
{-0.003088301203038663,0.23047039744693223,0.3780161577339601},
{0.005364650441111502,0.24169734307769142,0.4008347214651302},
{0.017664385978473706,0.25421516116280246,0.41650782754136256},
{0.017193375737605637,0.23838224804056132,0.4484612263648783},
{0.037482061759215236,0.24822920575898133,0.47569511058527425},
{0.0331907018733471,0.2306580405573461,0.5065699119779585},
{-0.017847222861939935,-0.2515813487954994,0.4310036082748808},
{0.0032170680333439964,-0.2646757138548703,0.5007467675119885},
{0.02574665736928764,-0.28871906441986234,0.5166161278552491},
{0.04234496213293943,-0.29016613925001233,0.5338953147698157},
{0.03742618937094899,-0.3316963457855998,0.5063087736471372},
{0.03066683194747114,-0.3571016609118774,0.48836092040848117},
{0.04470682215878892,-0.3214678938032114,0.5263559467646282},
{0.041492057109190655,-0.33881797256525553,0.527883525896151},
{0.03603678926417065,-0.35934016111273764,0.5229443266696331},
{0.03309858252351746,-0.3658558027780792,0.5079264695339281},
{0.027054151358500065,-0.3766047290870051,0.5173837223506775},
{0.025796922492781642,-0.3944111991496182,0.5148079852256583},
{0.02383417956304187,-0.4091645135437473,0.5197914417919857},
{0.004894641497524188,-0.2631132895779772,0.848682953634729},
{0.0064889070279454,-0.2792798349541666,0.836681003908664},
{0.023677576668331483,-0.25367045544207073,0.8296428853222233},
{0.02783836738878891,-0.2648819810947063,0.8082109180654455},
{0.007647808500693493,-0.30308687936089995,0.8081238052020198},
{0.021016328755535666,-0.2796318910780808,0.7904240734295351},
{0.03251702906285383,-0.2588691909237608,0.7784453538003837},
{0.030374252882033957,-0.24643027506437334,0.7547927094343431},
{0.040009936874214225,-0.22026016907505364,0.740732493017954},
{0.05358512488780463,-0.18706596266122386,0.7193353709065464},
{0.0001987575102302502,-0.46356459428836,0.5494086138000392},
{0.016224921007657517,-0.4694562274883339,0.5436341323819139},
{0.04522629518804563,-0.4844400405164932,0.5462677444897608},
{0.05287800874813407,-0.5096531065648654,0.567256938088988},
{0.04232753956025426,-0.5233834956569731,0.5852728795427354},
{0.05756428028153275,-0.5282451944739605,0.5814437184816649},
{0.06432724237522133,-0.5372893120326695,0.5954338440884008},
{0.04203796438665935,-0.5522472915909853,0.621197022862821},
{0.04985549277644115,-0.5577480183325516,0.6392878613531692},
{0.05759011375137627,-0.565288587894476,0.6580838133886262},
{0.05312913410614791,-0.568207970246251,0.6729252419434618},
{0.03678435781398379,-0.5555089173533229,0.6702101242369614},
{0.04359658373388561,-0.5386889253717116,0.6906672284611943},
{0.010279818532891208,-0.6315812767020952,0.7853272700110262},
{0.022003207355449715,-0.6500369879215512,0.7831782857870657},
{-0.0020687803117719356,-0.6500029438140053,0.7828326379657483},
{-0.00813503975750983,-0.6755190024195347,0.7648114897661409},
{-0.006601452842302488,-0.6935818045860215,0.741443013568379},
{0.009038009645296441,-0.6972910102328577,0.7334364402519904},
{-0.002298678167433733,-0.6949964373842751,0.6978469304831338},
{0.040600101491492374,-0.6923912621192015,0.6342837780628582},
{0.056375940668730404,-0.686992066921904,0.60039066614706},
{0.030635591472311523,-0.688445950573563,0.6068536395754338},
{0.05449670593220576,-0.6941785777653526,0.5612661764582192},
{-0.004322099712387375,0.534222338461711,-0.24055025691285625},
{0.003113133375601427,0.5382817978973559,-0.2335527909960144},
{0.011374636979670855,0.549827556582308,-0.22864262939063854},
{0.008371746434680768,0.3843531679644147,-0.7654907698414064},
{0.003520861628325653,0.37581170164064553,-0.8026326909143484},
{-0.005690272316813665,0.37272990886993185,-0.8260356117385683},
{-0.0058867268432981805,0.3885023436364153,-0.8397077253289361},
{-0.011481575529255704,0.18996872347813826,0.298555007868194},
{-0.016166645505917468,0.17376012361615706,0.3196148930554426},
{-0.004392591040952663,0.2256954109744585,0.299994272579554},
{-0.012369926476743273,0.18984316079913133,0.2814632638045852},
{-0.0028039327753036887,0.2207069479217274,0.2698145717591711},
{0.004557805092277552,0.23968854047303684,0.26463966715276305},
{0.0076874598730114685,0.25335885172829914,0.29801811226625213},
{0.006504527265525207,0.24898758831942663,0.31868128347086483},
{-0.015356596005785096,0.1434160097822739,0.303704679783127},
{-0.017282691455049168,0.15628167854271996,0.27899166159676475},
{0.002359156523191441,0.22347974035159948,0.2310867960529662},
{0.013390849184203048,0.2526669553072961,0.257291346668744},
{0.021043764301028407,0.2649761030390974,0.27814616617289356},
{0.021488540553140645,0.27166937484204534,0.3025826260503108},
{0.022687493917119016,0.27050386480724425,0.343309591907275},
{0.011410082903409653,0.2576037514203402,0.3530532157463209},
{0.010104591508758741,0.2490178274973055,0.3735047127057816},
{-0.015662392195328268,0.13220348283235758,0.28263197799068474},
{-0.010303649408173231,0.10462435130955663,0.2659515668500108},
{-0.007015188878711262,0.07951081421089161,0.2440840352761037},
{0.010642288148525225,0.06304928665579122,0.2635847003377576},
{0.020625021778215853,0.04133815771713833,0.24417254995572263},
{0.029404196076436625,0.015492672306239954,0.2292712438234977},
{0.007067056077854462,0.030105204302694567,0.21724566348160676},
{0.05254818142385274,-0.018522597877810475,0.22056536448622832},
{0.07644233869401196,-0.03611018435485013,0.22132675093851592},
{0.09820833872365035,-0.06008484592638221,0.2132464821422635},
{0.08161343837075313,-0.09722556544258741,0.1835932634321026},
{0.10726086717951777,-0.12570105829112196,0.1783378545243217},
{0.0975382705833678,-0.14259714886607086,0.17106182770397324},
{0.07317450488853357,-0.16474764705151992,0.15631191772059877},
{0.09880511190298148,-0.19920428907692805,0.1528656527396895},
{0.07030018091439268,-0.227973963066549,0.13729527976446282},
{0.08901662994575771,-0.26016506986451643,0.13298509548971646},
{0.0889136965852959,-0.28509376748515375,0.12449629740291521},
{-0.01001647734805214,0.10870443746918507,0.30288461731018707},
{-0.0035785363516972605,0.089641339319222,0.3064165933383291},
{0.037737592825264406,0.04057797282158765,0.30051955313303913},
{0.03227751875329676,0.04226776211259308,0.2751258530552183},
{0.04358356686923577,0.026305281122221955,0.27477559926640954},
{0.04801470785549758,0.010850658112650746,0.2488221740086456},
{0.08775599666928471,-0.005424427888772688,0.26146094880527204},
{0.07595851184795019,-0.020319525977856898,0.23374423903609512},
{0.10909964950589983,-0.029243087343962835,0.24110817975769402},
{0.12360724554733112,-0.04927744385626017,0.23354938658525984},
{0.13718643875004455,-0.06101805499204769,0.22909601679936523},
{0.13866675664991562,-0.0904087335551941,0.20722528107415963},
{0.11589164922073035,-0.09073535672817701,0.19875370530058742},
{0.12779386973763204,-0.11167368442554171,0.18989883292794144},
{0.138648733298862,-0.12744712048930593,0.18438188517042678},
{0.12794546614593869,-0.15430051174301423,0.17178236122720594},
{0.10240217225437274,-0.17041579069842888,0.16203953842598467},
{0.12493156133086025,-0.1980365761881093,0.15632653666089782},
{0.11883085725866431,-0.21364499846000476,0.14964207627402062},
{0.10246044775611281,-0.22635086017444198,0.14333490470253257},
{0.09931417144051832,-0.240188788594503,0.14082144826837648},
{0.10333778443351205,-0.2478669364028034,0.13694462545674174},
{0.11116732839066293,-0.26775350143646104,0.1308887795027237},
{0.10111410343240701,-0.27777168098989047,0.12685995976387004},
{0.09552305967611636,-0.2970096056450737,0.1191587821181122},
{0.08318066887459391,-0.30444163458176415,0.11809680622214139},
{0.08934625701058291,-0.3207493628745402,0.11230089704220787},
{0.08378725476727647,-0.33780445945767335,0.10294397421299034},
{0.09486000061679911,-0.35310288009144647,0.09722135999400822},
{0.07785697149226536,-0.36574305670426605,0.0927581774947622},
{0.11639309889893344,-0.3723720452217893,0.08689938684559713},
{0.15223433480417226,-0.3851215634976676,0.07078470866855095},
{0.12999712427420965,-0.42269664577426513,0.058872274919385535},
{0.10434288664393586,-0.44400425190877296,0.053353124307853245},
{0.12471928630733978,-0.46973218501891045,0.037286107881371086},
{0.11301111720344878,-0.5055860372698868,0.015796866420133913},
{0.12534569788618133,-0.5337006625784366,-0.006637799933593976},
{0.09515177864441168,-0.5495047383389919,-0.010153154426875468},
{0.12699583580486878,-0.5621797600971818,-0.03153705941417701},
{0.12439807013967295,-0.5875784666614065,-0.04942723792946141},
{0.0843762178278177,-0.5940919054727305,-0.04045100832638767},
{0.11294242820998886,-0.6174143219955773,-0.07192318367677164},
{0.09938085783941673,-0.6236325783685343,-0.0739584205296382},
{0.07714444834727872,-0.649700752294673,-0.08753561113779011},
{0.05322746149911825,-0.6556804996553535,-0.0864447978801335},
{0.02882724858326447,-0.636176430182945,-0.06864914182815256},
{0.03358301014794767,-0.6537449920116503,-0.08360872346211752},
{0.013875276808633262,-0.6564759302151867,-0.08957565421760434},
{0.08495656973174444,-0.6727952735564197,-0.11805355017961272},
{0.05337445193993337,-0.6840658757486199,-0.12472038773434863},
{0.09109231920876687,-0.6882611110955353,-0.14152455921892404},
{0.12174323052947397,-0.6896419000456993,-0.15923850941279521},
{0.1429661269140298,-0.6971912810236942,-0.19632956458387485},
{0.12422784960194427,-0.702049575429927,-0.20399749915991158},
{0.1504372064446697,-0.7022538400752013,-0.2335982498925608},
{0.1562088842304089,-0.7006083081240054,-0.28240608532414596},
{0.12151453423054909,-0.696570476709625,-0.3260025689283035},
{0.11980451873447236,-0.693612844801725,-0.2749884750682985},
{0.08894073161187632,-0.6843896952892167,-0.26039857239038894},
{0.05100157764399556,-0.6797330621553285,-0.26745151017658475},
{0.012078949486955294,-0.6790245441994647,-0.26345993869657525},
{0.012186889333820894,0.14668604644176994,-0.23906933823461676},
{0.0331396357120285,0.13142227069391102,-0.21896829532342102},
{0.04381226316816066,0.09204164916065251,-0.22272115753169805},
{0.041041673592306184,0.05617998679088627,-0.23909376988826725},
{0.038897695854749406,0.01630392336310924,-0.25648750521175234},
{0.04103947073828852,-0.015436599658517576,-0.2731316693908628},
{0.01104500991484567,-0.2693411584048293,-0.2278329804094184},
{0.009033003158892657,-0.2443537847635396,-0.20909990984319285},
{0.029343917980135057,-0.24337631835806467,-0.21157611801850476},
{0.043110754293262346,-0.20779582026473498,-0.1938517543329137},
{0.03620060149930249,-0.19047037341579748,-0.18087494157430367},
{0.06139924886683186,-0.18242615132165232,-0.1879569169816414},
{0.06708982157282975,-0.13596755957017911,-0.16780841257933776},
{0.07569116547398809,-0.11903922722278983,-0.16993797163605165},
{0.081248165122733,-0.09795611193862767,-0.1626112791732969},
{0.08392663534875784,-0.07405734870097698,-0.1519084125392859},
{0.005637403820389689,-0.2639601868180414,0.33967227940519734},
{0.01885012221834608,-0.25828923953874633,0.31880424277694175},
{0.028940395175990008,-0.22034427804663717,0.3233759659014218},
{0.04264134612804348,-0.1784349803605551,0.3298581642375862},
{0.055578908033247866,-0.12769404039874058,0.34597764864158004},
{-0.005547887843490029,-0.47626024277053347,0.21066213386062982},
{-0.001542097942093782,-0.4819007506124935,0.2098542872145151},
{0.04335106564064401,-0.4758076563996313,0.1960177606106471},
{0.07583495176350478,-0.4406434977156404,0.18260558379436395},
{0.05490483470384229,-0.4214452244327751,0.1983277534373534},
{0.06529489606734484,-0.3969438804915648,0.2001206763482768},
{0.07575665031614959,-0.35821790712046525,0.20877148433510453},
{0.07018362991091256,-0.3242587095841372,0.22812135402627642},
{0.07630215707470597,-0.29753708905257653,0.2392978342740855},
{0.05329014270889364,-0.27067128171258675,0.2710193326473779},
{0.029617472397237856,-0.2837908794634328,0.28822161993078227},
{0.024829268800658125,-0.27504695082949465,0.3035038195486071},
{-0.00875564381212299,-0.5358622631481347,0.5167671234851874},
{-0.0018334754507940507,-0.5630933437361445,0.5033028792103048},
{0.006286044198864045,-0.5895063644457759,0.4904504275739648},
{0.012280811018755894,-0.615920386452688,0.47989134722947047},
{0.020988492691130622,-0.6379144820028828,0.46657008820628004},
{0.029541173544444178,-0.6666763458737138,0.4540396537754314},
{0.03537973798853794,-0.6733241587801154,0.4402525912572329},
{0.006474688606558654,-0.6359206988574396,0.42043231210356136},
{-0.010275012305943581,-0.5733067762593216,0.4493936343927191},
{-0.0017227319715423326,0.595321698792956,-0.2338631931530491},
{0.0008323784294932473,0.5920480574632494,-0.24523793026244803},
{0.013861458906158813,0.5918690255094501,-0.23498424558858458},
{0.014915224164427426,0.5928675191578209,-0.22302194723483745},
{0.01118058556666016,0.578823323497924,-0.26055497502564323},
{0.019220401952770003,0.5742860449999018,-0.24796826768761604},
{0.021061987911538183,0.5855580490082951,-0.22354342285865564},
{0.013747911794520975,0.5778919167673638,-0.2210307674623242},
{0.004006691068948926,0.25727312305823424,-0.6838425864550111},
{0.005695679322129747,0.2458072678962864,-0.6999166119624585},
{0.037774640824652414,0.26538583388638315,-0.6237317067993292},
{-0.005337214895618767,0.23919550169199214,-0.8673978005904448},
{-0.003930592475611405,0.2504132353877684,-0.8517409155301608},
{0.0006411306488686678,0.25657722144810813,-0.8432238808600421},
{0.005874110497560636,0.2458925784246069,-0.8399993030970926},
{0.00869937090494444,0.23329385551921067,-0.8305588720746597},
{0.0013618644315575232,0.23886387203260542,-0.8134581163355241},
{0.002939308167662019,0.25121407295291776,-0.7971023257732718},
{0.014645074158079203,0.2654114670967706,-0.7966545456293173},
{0.014716967302837553,0.26583581688435537,-0.7908243920823819},
{0.024987073252105422,0.25996741378129506,-0.7902368308380336},
{0.02005728622002666,0.25377919632676094,-0.7767289300017102},
{0.022260941275516553,0.23781691559584595,-0.7674216715176181},
{0.02472453310509095,0.24606920726493245,-0.7583753511048915},
{0.02623468966392858,0.2418261099079968,-0.7528632095743244},
{0.0202433272547913,0.24017336861637936,-0.7583334968785558},
{0.016584987509817715,0.2342721229625102,-0.759099689557791},
{0.03134350864980668,0.2372605948266574,-0.7810799672055114},
{0.03983430933116945,0.21573831055515524,-0.766287802476889},
{0.051996666881611815,0.21891562708645318,-0.7334344376574289},
{0.03781269012132117,0.22465786673213814,-0.7258882608307322},
{0.0226352261990635,0.22495124683539994,-0.7166154469730983},
{0.0315407642141158,0.22675278090293782,-0.6822775588051879},
{0.015374619356838716,0.2339426961571412,-0.6935802025103724},
{0.005636402523108938,0.21619630393137346,-0.8608377013258377},
{0.003709906554932565,0.24211468378431095,-0.8522037151333267},
{0.019293096135352957,0.2186665043230009,-0.8246446095561409},
{0.01683350949490159,0.23843171212623074,-0.8173065023043855},
{0.011406878752111231,0.25070721626939857,-0.8074076773868223},
{0.018425572171305138,0.2557781862180641,-0.8068127065425965},
{0.021129875867173506,0.2670489886697205,-0.7952921805491194},
{0.027935893743934632,0.2539734479992278,-0.7990600622166079},
{0.00413405608306121,-0.5993200790944747,0.4860268964470367},
{0.018486851564887462,-0.6445636967254775,0.4659767194377034},
{0.023737253986264598,-0.6703020433273348,0.4594420531240274},
{0.0019608404649063284,-0.6542119970633954,0.42798850190306553},
{0.007750141082786855,-0.6806502504645018,0.4192954391709898},
{0.013844036333473643,-0.6719171358411958,0.44098894527750143},
{0.0018414858290400978,0.20597466077049426,-0.8821415025306785},
{0.028064660574239977,0.19505651522112047,-0.8264946064120675},
{0.025399207212864983,0.23960943798785705,-0.8086384720043287},
{0.023751272148195193,0.25371811719263476,-0.8065441586118975},
{-0.0028489911529377522,-0.07405855025771389,0.7169675030970124},
{0.007834250054370436,-0.053249790428479125,0.7209849080468654},
{0.031546371478888044,-0.032758241577788186,0.710732625189195},
{0.04026606871863185,-0.006528858789447612,0.7190241677116871},
{0.040007333501284256,0.00438688364645234,0.7315315723050784},
{0.053621772368280335,0.026969741997732253,0.7373575204034346},
{0.04047734244487157,0.0054586722557745816,0.7629841222287594},
{0.04495414258713589,9.031701472427259e-05,0.7825200329546961},
{0.033085565658867624,-0.03275924287506893,0.7966136927002624},
{0.03949346773679979,-0.05363849403286898,0.8101788677410452},
{0.03715984429426765,-0.08454373486288834,0.8257598544674479},
{0.012709566514376021,-0.300020706827766,-0.3054813816781021},
{0.02154601501705609,-0.29698357191577407,-0.28086008232265725},
{0.02754098209640409,-0.291446197693732,-0.26691040912606373},
{0.026771785525326608,-0.2788056205620001,-0.24181449485953999},
{-0.00026183923891794547,-0.2819957536984917,-0.24444029684859703},
{-0.005286348993756314,-0.48295171223837596,0.21146197012849843},
{-0.0050059857551443656,-0.48422656393623575,0.2122481887533488},
{-0.005412512451131688,-0.4819646333790058,0.21235913249205668},
{-0.003751560521812062,-0.48749660059573185,0.2107852934261629},
{-0.004814137196151337,-0.4870528256409003,0.2101652901499182},
{-0.0019500264542741594,-0.49023094321002286,0.21004353240057816},
{0.031883808662503135,-0.6059056113100133,0.7611703723343964},
{0.02875635673578688,-0.6256529960216456,0.7726352261990634},
{0.0026309086051888764,0.4817079007562198,-0.9210559200500168},
{0.014039489562677398,0.4613823669946783,-0.9205909175928334},
{0.01607732978847394,0.4722648663608571,-0.9185472698428082},
{0.015203397521829278,0.4837773819760881,-0.9124880194780355},
{-0.002656541815576263,0.36829175880270476,-0.8391283747222901},
{-0.0005357941749330482,0.3635375993136708,-0.8300077580513313},
{0.007636794230605166,0.36887411330119296,-0.8385113753378877},
{0.004534975514276293,0.37799933593964335,-0.8438807318762187},
{0.023206366168007263,0.37557920041205384,-0.8303201628029274},
{0.018946046497842598,0.3659190847662231,-0.8206926894484493},
{0.030031008174190472,0.35327770659666663,-0.8093590055275615},
{0.051050240691840346,0.3520895672433204,-0.7954700109461817},
{0.059420284921143825,0.3667990248165523,-0.8244275283056728},
{0.050393389675663786,0.38070764482463476,-0.8538146021986085},
{0.04539291105556358,0.39126432205565526,-0.8716705363468908},
{0.04553609656671182,0.40760629471543325,-0.8863896063740182},
{0.029404196076436625,0.42607502279953896,-0.9037807383245733},
{0.015880474743077126,0.4487253685875419,-0.9161141174505688},
{0.029406799449366593,0.4478017719757717,-0.9112622313469332},
{0.028865297879933235,0.4657780620572012,-0.9097708991769736},
{0.026068474315322925,0.48340850405785724,-0.8992030074164087},
{0.04184391297364865,0.44099595435846684,-0.8954519475432369},
{0.04880713452348862,0.43173055010071043,-0.8698549841174226},
{0.044935117938801505,0.4400721574872405,-0.855717667810415},
{0.04758254794912288,0.443025383687105,-0.8460283142839863},
{0.05240980213965213,0.44680367884631333,-0.8389537484765263},
{0.041886768497265046,0.45567317015925823,-0.8251218278401498},
{0.03068185140668249,0.2468690435328011,-0.6558605329064335},
{0.046272851105892784,0.2570231992569573,-0.6207061869357939},
{0.06523261537648176,0.26892922470352587,-0.5813826393475386},
{0.06470913715810203,0.2792640144571306,-0.5694273500747568},
{0.01852670319666159,0.239649089360175,0.20481075281134234},
{0.022622009074957507,0.2541578869583432,0.22076382160727434},
{0.037845532672130006,0.2747729958934796,0.24141177309321954},
{0.04211105908815461,0.28428992602816205,0.2791082126002448},
{0.05684134364482623,0.2954375689142853,0.3130149421590612},
{0.03668282626971504,0.2841817859218403,0.3133690008775369},
{0.04088707329215731,0.28413592650638164,0.3422347994061105},
{0.033071747756393176,0.2738011367527769,0.38890726825675337},
{0.021613902972691414,0.26219710256608464,0.39023058274300176},
{0.0046268946046497785,0.19443390857194578,-0.8824611166226963},
{0.02254991567074301,0.1679385812258362,-0.8597342717224434},
{0.04956631812175854,0.1742874067642037,-0.7964552874704467},
{0.05389853093668156,0.20205318010013773,-0.762697751206463},
{0.03339236314569155,0.22597277032122817,-0.7897526034730596},
{0.003666249993491563,0.12901915722009435,0.037554455552613955},
{0.02311324552089687,0.12645944085156727,0.014556058829819907},
{0.026229082399156337,0.15443108090842494,0.03731774887544301},
{0.020204476920297934,-0.05892534367526567,0.7074301464978024},
{0.041865741254369156,-0.04831820106129501,0.6993522808150239},
{0.05338786932349551,-0.008078065942234756,0.7061508890919074},
{0.05966319964145546,0.017572967536740605,0.7172422590708522},
{0.06827475677487752,0.050226873937873916,0.7271537003341528},
{0.06325865791719751,0.06445550855688631,0.7394237974720047},
{0.05396041110863234,0.031816621614964354,0.7613309804182297},
{0.05496250942721389,0.024413029521047465,0.7848452455000698},
{0.05825117021613201,-0.01013352900017263,0.8016376016767324},
{0.06290279686361648,-0.02946297222681707,0.8065203277366154},
{0.06478523575143956,-0.05389562717456737,0.8126524725434271},
{0.06451208185324907,-0.08391672250567835,0.8182140781596636},
{0.030820230690883098,-0.29346240989826416,-0.30512552062452114},
{0.04211125934761076,-0.2865911074387977,-0.2801435539885475},
{0.044989989029786986,-0.28025349642997466,-0.25926790750095824},
{0.04325734421516516,-0.27090578553574013,-0.2424431092923992},
{0.034934761476969556,-0.26331895603944466,-0.22830959791505873},
{0.008960909754678156,-0.41578449038574367,-0.797586753397702},
{0.03832295121559492,-0.39850149854151035,-0.7954443777357944},
{0.04563482447859446,-0.380903698832207,-0.7940635887856307},
{0.06352740610735268,-0.36696223627331565,-0.784410281961309},
{0.07040371505322295,-0.3074050740138924,-0.7744704038552348},
{0.044970163343627995,-0.3288612726648646,-0.7889437555296642},
{0.03395308962291544,-0.32884525190837244,-0.7922119898540548},
{0.028744140908961643,-0.3126991329967105,-0.7896624867177915},
{0.050922274899359604,-0.29261451136091915,-0.7791254349134739},
{0.02472212999161713,-0.2636081306941273,-0.7802382767113071},
{0.04286683827566995,-0.24400733590439772,-0.7711533062235432},
{0.0539473942439825,-0.21501257028606258,-0.7540521499654952},
{0.05227542804457454,-0.19171558671414682,-0.7478935709104716},
{0.06381638050257914,-0.1639688380265472,-0.7298177518793348},
{0.07806584210503127,-0.1306046113344449,-0.7077709880921722},
{0.06876599322081688,-0.1195036289016049,-0.704634524489929},
{0.0087942938871602,-0.5633108255055249,0.7571715915139654},
{0.04375899415282439,-0.5964519631634746,0.7459538578181892},
{0.09457543192960799,-0.6135637331726984,0.717423293619213},
{0.07316449191572601,-0.6469888387394708,0.751426147716982},
{0.048333120390778285,-0.655457610880657,0.7708951717845639},
{0.05357491165554091,-0.6686875515918423,0.7685679566446286},
{0.024176022454692293,-0.6683627307539648,0.7765833413770881},
{0.006503525968244455,-0.6750415838760697,0.7715732503030925},
{0.013550656230211856,-0.6926185566019333,0.7545061381525905},
{0.05301198232429935,-0.6955457490724982,0.7413062363598277},
{0.057545656152110665,-0.6957225781722799,0.7063141005486707},
{0.057825218352898,-0.6938904044079509,0.6646150752915476},
{0.09335304820925991,-0.6896737412992273,0.607449010938572},
{0.10067753781799699,-0.6843516459925478,0.5820863510764547},
{0.08452981683068582,-0.6797436759065043,0.5717497589877445},
{0.0757204033545862,-0.6812444202709029,0.5633520789534922},
{0.09657882752894649,-0.6753087299905758,0.5417374750727042},
{0.08923931846099806,-0.6914043835192876,0.5270208081590508},
{-0.0009481283951487607,-0.6343274346242992,0.41847838058989223},
{0.003339626820508647,-0.6428570856401553,0.4138850294441478},
{0.01519538714358322,0.4897571293367686,-0.15987974019139195},
{0.024282760744820987,0.48356530721202384,-0.15372056035799983},
{0.025943712674140612,0.4782003563817281,-0.14090515672104778},
{0.02763971000828673,0.48039199586984893,-0.10149990327468267},
{0.03339076107004234,0.48256360941235454,-0.07101380548638817},
{0.037294418648801377,0.47946900003644716,-0.05579729097018098},
{0.049741344886434856,0.4728664457671359,-0.04552177801559701},
{0.061650774743758005,0.4616429045471312,-0.05214395771161117},
{0.06452690105300427,0.45040414360845904,-0.0693192099684351},
{0.05901976600884105,0.44029825041323534,-0.08962892323294061},
{0.06478343341633419,0.44110249238913934,-0.09365974556635577},
{0.06207252115841283,0.43198187571818053,-0.11716960494016046},
{0.00467555765249457,0.3663668649101776,-0.8164872408692702},
{0.014389342832573879,0.3660206163104918,-0.8281982136055474},
{0.001470805575703877,0.22622069152794358,0.9749970061211306},
{-0.00028346726018229495,0.2341119153975891,0.9672325464872289},
{-0.0018681203367082425,0.2265579284521025,0.9593623498604792},
{0.00027265324955011466,0.21739746014936953,0.963590027239291},
{0.002578640887133367,0.1965420398668515,0.9425850131430279},
{0.00032672330271098834,0.2141961124833334,0.9375677127286112},
{0.004574226367681965,0.2224149608232426,0.9344588849313168},
{0.006635296690392068,0.2337280180201469,0.9554999457296872},
{0.01128291814875352,0.23740137722433186,0.9707541090236508},
{0.004199340665766562,0.23184457783504306,0.9766052898134822},
{0.01823812932034744,0.23081964993846027,0.9796468304335095},
{0.018106759117112126,0.21855395850864376,0.9765574278034622},
{0.007334402451816568,0.2078226550318593,0.9650695441013376},
{0.004952916999264244,0.19574781086375506,0.950814074715201},
{0.01538102765943556,0.1608876460342019,0.9220133605098765},
{0.011217633566048168,0.16494810676712746,0.917382961364744},
{0.004101614051164686,0.19158742066220993,0.9262122005270028},
{0.0038288606718864925,0.20539370808819907,0.9120748842199953},
{0.013171565079717278,0.21317318718131206,0.9086911001894052},
{0.032401479356654474,0.21704380194980613,0.9113179034757433},
{0.027980551602656393,0.2288494974088429,0.9411389396101588},
{0.030927569759380245,0.23174985511228346,0.9535209817839994},
{0.020918001362565334,0.23658051371356728,0.9738517222914006},
{0.016490264787058107,0.21137786115691487,-0.18832619541878456},
{0.005707294370586528,0.20259027596153573,-0.1975821874821018},
{0.024717724283581804,0.20103065531702874,-0.19815713238071245},
{0.04977679081017365,0.20736766554748332,-0.1863221990410776},
{0.03535750918890514,0.1724257948598204,-0.20962519039667796},
{0.005946804680143591,-0.2418231060161545,0.5176420570491128},
{0.022788224423563163,-0.25505384776516454,0.5295755180411741},
{0.028901144322584334,-0.24221221013945665,0.545808950075718},
{0.04246351573098105,-0.24715581507400985,0.5582626851348607},
{0.04865553811518202,-0.27485910745962466,0.5548484616669356},
{0.02941080463848962,-0.41635683191142436,-0.7930308507702579},
{0.052431229901460326,-0.40213260300044734,-0.7872820025625199},
{0.07396753233489307,-0.3991887889950219,-0.7804169081461941},
{0.08923651482861193,-0.36593810941455746,-0.7730926187969132},
{0.09042625625760735,-0.33430652753707696,-0.771542009827933},
{0.1050249703515875,-0.3120002274947422,-0.7563313028359542},
{0.09116060768331449,-0.28652422078044315,-0.763552258305861},
{0.07118072174309034,-0.26397780965018275,-0.7650237647896614},
{0.015562662986164868,-0.44498051675751094,0.5333676311028568},
{0.01936118435044443,-0.45392810925835514,0.5345549694183784},
{0.03509657111753988,-0.46262157250934305,0.5304983136151198},
{0.0780636392510136,-0.4801234479391499,0.5319704208772886},
{0.07406746180351262,-0.503110029354031,0.5511076150260277},
{0.07485007575815225,-0.5171902717160353,0.56791298806734},
{0.00820192641586439,-0.6837320432352155,0.43220336267668386},
{0.014506294354966288,0.5508114312903798,-0.31177974183351953},
{0.01531794593074787,0.5599222352479872,-0.29286703853512613},
{0.023984774674067715,0.5395636586761807,-0.30433249317816163},
{0.021932315507972124,0.5450161228888146,-0.2779394984141454},
{0.022033446533328574,0.5602692848854977,-0.2473374504007392},
{0.023738055024089207,0.5661014410269944,-0.22883027250105237},
{0.0206899058420089,0.5684066276267532,-0.22237851360222302},
{0.01603387348648909,0.5450705934608879,-0.23351954792629329},
{0.01401786154141305,0.5245105558761932,-0.2583196789760814},
{0.02645918051427429,0.5194471957868614,-0.29415550787600414},
{0.022096728521472413,0.4950533911736045,-0.2789347879112178},
{0.036761728495438684,0.4895258296649138,-0.2726492443609941},
{0.0620895432121857,0.4765129702041965,-0.24829829527135355},
{0.07357382224409945,0.45067369283643877,-0.2278179609502071},
{0.06311887681680385,0.4609734371852171,-0.20940049928687607},
{0.04329098780379859,0.4766853935959429,-0.18565393323590043},
{0.031810713961007875,0.48624698158934715,-0.1705467603827519},
{0.02615959236787181,0.4912732936792909,-0.16156412247708132},
{0.012563176851929356,0.36395514027974646,-0.8094218869967931},
{0.017919516525610576,0.3524750666964118,-0.8069030235573208},
{0.019264258773667157,0.33285124206922484,-0.7975493048794017},
{0.0325702980781901,0.33788936946708154,-0.7969483262514914},
{0.04647210926476342,0.34033674028070765,-0.7808839131979392},
{0.0567500253328212,0.3439251894754844,-0.766503481911164},
{0.06667868890935096,0.34257564100048016,-0.7688403095049946},
{0.0726458199242939,0.3446589401228231,-0.7811364403721461},
{0.07787960081081048,0.34646988638480014,-0.7829089368185421},
{0.08230593557012464,0.3639773690793792,-0.8033221842218778},
{0.06447122892419418,0.37229234195824107,-0.8309335575171191},
{0.05895468168559184,0.38931519676893384,-0.8567654252849992},
{0.05779077372643997,0.4048893746738273,-0.8651849335999722},
{0.04323050944804087,0.4280347618374365,-0.8957567424354995},
{0.03621301758558387,0.4277608069014215,-0.9025020816970467},
{0.006796505552593936,0.2255496220903803,-0.15762201508274118},
{0.013129510593925486,0.21692344601665917,-0.16799966035996236},
{0.02927322639211362,0.21072501532986135,-0.17413540983698478},
{0.041030058543849404,0.20876807992434998,-0.18457233191322678},
{0.02101532745825491,0.15269002519664476,-0.8649850746627329},
{0.026473198676204887,0.14479099120820935,-0.8393782985235672},
{0.04655441590124164,0.15796505953112852,-0.8054949993211203},
{0.060069726337442786,0.1632837504270533,-0.773801337012233},
{0.07409109241933849,0.16763719074432834,-0.7507883213491399},
{0.0738487784773953,0.19276494626438012,-0.7346524156697416},
{0.08549666948498473,0.20757092889547696,-0.7032431217885893},
{0.021973368696483156,-0.4285233949104459,0.5282824427328046},
{0.03568533391862496,-0.4318985677844215,0.5239760633877251},
{0.049536879981704286,-0.4450510080860763,0.517531313569861},
{0.06561951664576625,-0.4561760216536544,0.5182738756332704},
{0.11019586976887254,-0.45082008249888544,0.5097105810287809},
{0.09702520585670793,-0.4802522147694553,0.5298845183820157},
{0.10004972442296238,-0.49087437684263724,0.5434510952389916},
{0.09658143090187646,-0.5075305565891168,0.5676846922873274},
{0.018294001708613672,-0.6700811571472,0.4521590172227137},
{0.024554112307906117,-0.6588694312351082,0.2453849207032631},
{0.05384526192134529,-0.6584859343765782,0.2355539837413352},
{0.02973943040603405,-0.6381790247444588,0.22883968469549143},
{0.014900204705216073,0.38109074116425234,-0.7363410034040101},
{0.023523777406007217,0.3589913091401219,-0.757100899925944},
{0.019014935750758678,0.3499744268674494,-0.767602706065979},
{0.01110128282202421,0.3477527484609059,-0.7821998180843099},
{0.005960822842074185,0.3636643635494146,-0.7926269274472005},
{0.008264607625639776,0.3380571868913364,-0.7934684176819486},
{0.011338189758651305,0.33779584830105885,-0.7990604627355201},
{0.01882809367816943,0.33172217925544334,-0.7837310018860435},
{0.029777479702702815,0.33131485152163137,-0.7861569449378615},
{0.03456147785070336,0.3337906591780311,-0.7766436194733897},
{0.045978870224262544,0.34396884603692535,-0.7634817669772958},
{0.0467288418875495,0.3558884891265123,-0.7483934185130254},
{0.06813858034469458,0.3392985952600189,-0.7423421785264989},
{0.07780810818496442,0.3338335147016474,-0.7544368483807621},
{0.09349282930965357,0.3232872509623468,-0.7306880794757687},
{0.09466514816596382,0.3439183806539753,-0.7638720726573348},
{0.10597840562232427,0.3516001331324864,-0.767573468185381},
{0.1072636708119039,0.36684908968059016,-0.7885512469956075},
{0.0996359883865536,0.3784266896190704,-0.8072274438762861},
{0.08381729368569918,0.3831544148598925,-0.8228370677049185},
{0.07373362929010825,0.3891351635178537,-0.8351882699225116},
{0.06617623793386711,0.412204051569213,-0.8477469409366775},
{0.058586204286273286,0.423482263620747,-0.852757032010673},
{0.018737976922901307,0.22828917145053126,-0.14552654419065342},
{0.020286583297320002,0.21848406795844694,-0.15241326662824356},
{0.02951113462602147,0.21310910415534365,-0.15706228990279805},
{0.04001113843095114,0.21275865010707873,-0.16892005282043415},
{0.010840144491202798,0.1814987497802152,0.08913668548972048},
{0.01643779680954644,0.1668451645952496,0.06475569748165722},
{0.023418040413159282,0.19075354028679553,0.08217766938845968},
{0.04144619769373199,0.18358745590787426,0.05666801908552719},
{0.054207531277523154,0.19968371021495449,0.06748743672301832},
{0.05754125044407534,0.2236363432463099,0.09446458832062819},
{0.06287015457226382,0.24895955199556544,0.1256770271563838},
{0.050936092801834046,0.2561372514229435,0.15231533975418549},
{0.05103101578404981,0.26822391089896064,0.17840634325832547},
{0.03515684921384145,0.2623677236227256,0.2025105726979875},
{0.014704551216556165,0.14189503921280408,-0.8349449546832877},
{0.014693336687011687,0.1363512566881652,-0.8655207687079378},
{0.021069798030328088,0.13066288683618496,-0.8733415012490182},
{0.026239495890876215,0.1337999512167965,-0.877103174873366},
{0.020567747573756553,0.1404163233885822,-0.8657328434720021},
{0.02247201474230012,0.13981714709577728,-0.829868577729306},
{0.034836634343455374,0.13979551907451293,-0.8011836134896372},
{0.0446038887983271,0.14776584542933827,-0.7977185241198496},
{0.05542891370059047,0.14773861014330164,-0.7770421357911309},
{0.061558855653384516,0.15172717773146885,-0.7574533565687704},
{0.07178089933317605,0.15618094803627577,-0.74213190609754},
{0.0797424142719307,0.1650510401275893,-0.7317158110047377},
{0.08454103136023029,0.17774829068541204,-0.7281634085120682},
{0.10735418808608431,0.17311588894571805,-0.6944573389283155},
{0.10208816542712738,0.18603903217007953,-0.6954418144147557},
{0.11560327560387237,0.1892001276854292,-0.671588109554739},
{0.1298939906542917,0.21199145613056272,-0.6403139908064889},
{0.11424010948584987,0.2207459985156769,-0.6609403142711696},
{0.07301910355056009,0.22051349728708514,-0.704488935865307},
{0.057343794620310064,0.2261662209558704,-0.6914714704370982},
{0.038422079646389856,0.22340924902303422,-0.709348832347189},
{0.031474678593585846,0.22332674212709983,-0.707039240039395},
{0.04085122684950621,0.2236031001765888,-0.6971163839870936},
{0.04850554378252463,0.226565137792524,-0.671171369626488},
{0.04532302050536675,0.23150553857577877,-0.6562358191272611},
{0.035826917354124,0.23808806689947493,-0.6560784151947262},
{0.06875998543713234,0.2548736142546283,-0.5895059639268636},
{0.08580526930691403,0.2685096811428887,-0.5535966398065333},
{0.08696417077966212,0.2836527004386884,-0.5404299810834917},
{0.08319428651761221,0.2924282700666984,-0.5313498168226753},
{0.037698341971858736,0.2924905507575615,-0.5589123268106158},
{0.02165255304772863,0.10187358741986115,0.6033621159574344},
{0.04390037732886727,0.056778762564778935,0.6351651199293805},
{0.0560026570424642,0.014750911280655222,0.6507358934235195},
{0.050982753255117315,-0.010085066211783978,0.6473623226251931},
{0.07989421093969346,0.01144883310817496,0.6662459883024445},
{0.06569100927161228,-0.06435057260186297,0.6590130172651687},
{0.05864568134475025,-0.10388078794886656,0.6498351263897505},
{0.05194359812573169,-0.1342855803979636,0.6336071013605226},
{0.04882175346378767,-0.17391272132174443,0.6120742033378445},
{0.027829956491630548,-0.16611922406670082,0.5944383543318723},
{0.041031860878954766,-0.20459827752836574,0.5848751642628188},
{0.013583098262108384,0.0675749501053565,-0.5272685291063101},
{0.039731976749076095,0.06119007786488173,-0.5418406086926222},
{0.053575712693365515,0.0766749400523318,-0.5266995919913839},
{0.09912913170303445,0.08177674995724463,-0.518602701660271},
{0.0798012905520392,0.09738577300750854,-0.5088943234855078},
{0.058597619075273916,0.11567566939727109,-0.4915548584746397},
{0.01699231524362964,0.06974656364786218,-0.02494531915549787},
{0.017194577294342546,0.09455290274079094,-0.007343514257071474},
{0.04063394533958196,0.0908034449432685,-0.02763720676508485},
{0.04911753668052327,0.12075865491330566,-0.009721194779956923},
{0.05570266837714943,0.13875196704850803,-0.00017002027827253872},
{0.04939029005980147,0.16434312295009412,0.02723208188529057},
{0.0761022981374669,0.17357888880834008,0.020967165059050497},
{0.075823336715048,0.20087325138449375,0.0523167816222698},
{0.08310977702711632,0.22699289199086334,0.07742190782377646},
{0.09715397268701328,0.2439332399056217,0.0956683479115542},
{0.0778387478817556,0.24792501164508735,0.11318964850860773},
{0.07082726380298314,0.27010294537602914,0.15872924961580223},
{0.07602279513337479,0.2862760993142715,0.1891732929183049},
{0.05533639383184854,0.27886970358796853,0.20137690391671445},
{0.015298520763501185,-0.5506233876610537,0.74400252967745},
{0.028332006948202083,-0.567197461030511,0.7413929487043412},
{0.05852172074139254,-0.5804007672340283,0.7164622484891424},
{0.07574022904074518,-0.6002618993167548,0.7230593957531377},
{0.0990069734347821,-0.5964653805470366,0.6986199319838782},
{0.14713352619654022,-0.6039102260889208,0.6617932192949184},
{0.12295319816354068,-0.6239337685905859,0.6928210189121025},
{0.09609600198016549,-0.6362741567975468,0.7214278819638723},
{0.09947317744870253,-0.6471632647257787,0.728323215558077},
{0.10492003439656418,-0.662857598304363,0.7322633203578556},
{0.08238964402279592,-0.6690662422234246,0.7519632435783801},
{0.07883383711937185,-0.678008828237865,0.7530234171392455},
{0.049134959253208446,-0.6790762111391518,0.7644025599566798},
{0.02813375008661221,-0.6885416745936034,0.7607412163198639},
{0.07439208238193402,-0.6877828915142459,0.7465201915601853},
{0.09733380567863723,-0.6917962912749759,0.7284866272742965},
{0.10538723970776535,-0.6950817479125956,0.7122085373810308},
{0.146981128750409,-0.6930767502376077,0.6825290846821142},
{0.14181083011149245,-0.6910885743569368,0.6274873726399923},
{0.13619915963121818,-0.6863684589754485,0.5944623854666105},
{0.153666590434567,-0.6787059314047279,0.5789793256142658},
{0.11432742260873184,-0.6769548627201402,0.5673320353850447},
{0.1176126789868954,-0.6675308529731119,0.5518075218252767},
{0.13336368599157067,-0.6572146873489292,0.5305716085760711},
{0.12252984967323663,-0.6670514318350855,0.5177223610910295},
{0.10979615189439436,-0.6779697776439153,0.5211724310016056},
{0.11434724829489085,-0.6868643013888793,0.4987824225065995},
{0.10685594255917966,-0.699623632378109,0.48562457519962865},
{0.12924114482723817,-0.7007124430412042,0.4345942603236753},
{0.15173348590433763,-0.6973785236151958,0.40049448064912896},
{0.16982332309740497,-0.6906091532189105,0.3671536843133964},
{0.17924773336334554,-0.6819319109838707,0.3381176652470941},
{0.20061141214557582,-0.6564146508216044,0.3133209386080606},
{0.19227781513729184,-0.6536400560566269,0.28909415038123387},
{0.17490971302419414,-0.6668335495467927,0.2880578076956505},
{0.15226317216585808,-0.6694497390819545,0.2707523867923281},
{0.11989643782484585,-0.677180955646135,0.26050611171834226},
{0.09602130520302102,-0.6706917482290055,0.24538732381673695},
{0.0797790617524064,-0.6398563979491829,0.22020830187591042},
{0.04643205737353315,-0.6437766770628025,0.22612156309714865},
{0.016472441695460634,0.33524093815947936,-0.780556889506044},
{0.029730618989963386,0.339096333209306,-0.7687385777012697},
{0.019231215963402177,0.1952475627422889,0.960809024171717},
{0.03052304565795444,0.17784902119185617,0.9502154992007645},
{0.01685053154867446,0.173422686432542,0.9409318713324981},
{0.025405214996549526,0.145164875612844,0.9151732985255697},
{0.02537697841323218,0.13063244739884997,0.8896448238337589},
{0.016311232833258766,0.15109916407697813,0.8923437205243112},
{0.015732282745525097,0.16038899998838496,0.8743395943784765},
{0.009971819489330371,0.19046977263742904,0.8864236504815637},
{0.013386443476167716,0.20009404184060867,0.88981023814454},
{0.03870664833358098,0.20562180360875548,0.8872595334515397},
{0.06661140173208409,0.2035070637517968,0.8879502283158058},
{0.049451969972296096,0.21938263213819822,0.9244346975942029},
{0.04629507990552559,0.22043559635864227,0.9427892777883025},
{0.029789295010615748,0.23149312248949738,0.9716538747601391},
{0.02739879788253661,0.22319957737244372,0.9772725543213787},
{0.03981628598011583,0.20425643463671533,0.9651164048140772},
{0.058728989278509225,0.17675840819365568,0.9420747520487543},
{0.046132469227130664,0.16609098748338347,0.940026498331238},
{0.03576003069576943,0.15807259885908181,0.9347216253377875},
{0.03366411522768899,0.14515065719145723,0.9295345049045541},
{0.028621381862340842,0.13588925812282393,0.927836905494759},
{0.027141063962469767,0.12321443662409018,0.9198481552699678},
{0.03204041155721352,0.10507032911840582,0.8989152345779189},
{0.04023502850292839,0.09273634921404172,0.8757219854042898},
{0.02859114268446198,0.12420031392672347,0.8288458526867407},
{0.03361445088256344,0.19691912842278453,-0.5372062043583666},
{0.07200539018352176,0.19299524463895423,-0.5594946813091041},
{0.05855576484893828,0.18777387983871904,-0.5699806669521031},
{0.04422379635055177,0.18607007238578302,-0.5844488118806725},
{0.037267183362764786,0.1834652976396219,-0.5914737133430071},
{0.0865003698792155,0.1824818234504624,-0.612783922850445},
{0.07480822153181661,0.17189450652265076,-0.6530020294293286},
{0.06112949937939594,0.17097111017033667,-0.6589297093314097},
{0.020031853269095436,0.19348367745250744,0.5352232352235555},
{0.0382632738976618,0.19846513142427324,0.5559572982756459},
{0.04860587377005648,0.18116691986137237,0.5795072095406808},
{0.05275685177716248,0.15903304321078388,0.6004881925022058},
{0.02791927220907407,0.13491119093898055,0.5926276083293515},
{0.043258345512445916,0.1249825273624508,0.6133172137821761},
{0.05397482978947524,0.10953130876363416,0.627074237381952},
{0.07379550946205904,0.09026114233601051,0.6447751707111733},
{0.07366053458861299,0.05638044650649381,0.6541609309020766},
{0.012735600243675703,-0.4274355855446315,0.5247702923908214},
{0.03650559665102106,-0.4135121463367939,0.5221883472226616},
{0.057890302676147205,-0.4197910813249646,0.5137806542156017},
{0.07716787870364843,-0.4372416903339967,0.5078886204967156},
{0.107072022512367,-0.42484042325236576,0.5028052344617686},
{0.13272485832644773,-0.4284901518407248,0.5017514692035},
{0.12727259437327,-0.44654854829917634,0.5108818985878103},
{0.11520375798885034,-0.4642915361141895,0.5206103027081886},
{0.13350006268120976,-0.46394388569831074,0.5344376173770736},
{0.12384835793253739,-0.5039164741839527,0.5774189039319341},
{0.10043582465442227,-0.533207824056848,0.607984704983777},
{0.08704147092973655,-0.546914782792586,0.6253564117670853},
{0.0638346041130889,-0.5526387988277612,0.6241035886094023},
{0.07429755991863057,-0.5583239645284429,0.6440239974911495},
{0.0763263884689003,-0.5699986903031568,0.6701983089290484},
{0.06771563237330284,-0.578261395463963,0.6959206347744137},
{0.053943389054859466,-0.5650803180600786,0.6870485400885387},
{0.05779217554263302,-0.5586772222090941,0.7015981906157617},
{0.04737287629853237,-0.5316385909584457,0.7040860138395304},
{0.02303474381408552,0.23797672264185477,-0.13431001205161408},
{0.035881387926197175,0.22398499495946947,-0.143388373977325},
{0.030069858508683843,0.21965718785258176,-0.14687228773599076},
{0.04031453150702049,0.21780518840209373,-0.15714339498253937},
{0.04476289480651131,0.21976372588325435,-0.163501632715346},
{0.04340253232087492,0.21909706215372635,-0.17290781937077676},
{0.05547477311604915,0.2267405650761126,-0.17259221046788217},
{0.07482284047211565,0.21970605115988273,-0.17747834093851994},
{0.0661886540201485,0.19316306206320907,-0.18543464913141464},
{0.05370768367496929,0.15698519001217975,-0.1989297333625445},
{0.024945419285225933,0.21272560729681372,0.5175992015254963},
{0.049043040162834964,0.22770080916835853,0.5341626611437778},
{0.05330616346538574,0.21040439994056298,0.5579933361663371},
{0.07032541360586775,0.19579387053866987,0.58578674530722},
{0.06713768358284992,0.18216240961790092,0.5952728354856551},
{0.07942520329338691,0.15280517438393182,0.6222481847481596},
{0.015940752839378694,0.1803354425994318,0.8659753576734017},
{0.01681348354928645,0.17777192130123787,0.8464626770443785},
{0.019444492284203408,0.22158828978824963,0.8527566314917607},
{0.02032663518855028,0.19806401173360202,0.8710064759902929},
{0.03500304995151718,0.20312456819054767,0.8786169361024141},
{0.0366499837189062,0.20851314963666925,0.8717636569940013},
{0.06987402879170253,0.2051437842869221,0.8720169852060328},
{0.08761160960139956,0.18537437103511306,0.8848201730161597},
{0.0772640032426011,0.19788037381231124,0.8956441966211424},
{0.062495669389260725,0.21101539154128085,0.9094070277451464},
{0.08104209814235322,0.18590145392370355,0.9085286897704666},
{0.07583875669317165,0.18329507710189322,0.9267356787453824},
{0.04688264114987377,0.21358532114207165,0.9563624632073314},
{0.04217354003847384,0.2126194697850535,0.9652559856550145},
{0.07346267824593543,0.17562233629890883,0.9315767508383862},
{0.07939856878571876,0.15529219656987592,0.925973090736358},
{0.06287335872356223,0.15563504075880708,0.9349048627401663},
{0.04418794990790067,0.14927800458273738,0.9382121476585065},
{0.030235072560008742,0.13425834511192702,0.9491244856836516},
{0.02839789230927589,0.11698816987288732,0.9763497587474332},
{0.030249891759763944,0.10628189882812171,0.9394383363085211},
{0.041459815336750284,0.08134479031032603,0.9118543985587726},
{0.04581425695130611,0.05783192704467907,0.9049410416135145},
{0.05184487021384905,0.06148045407630126,0.8659937815433674},
{0.04041726460802615,0.09466885296590262,0.8259140542486844},
{0.028688869299063863,0.12593255822243296,0.8100148552464572},
{0.021672378733887616,0.14466863268050087,0.8289720161441163},
{0.019536211115120744,0.19632475835692723,0.8332425490465445},
{0.020578361324932577,0.2393454960246495,0.8398048511651695},
{0.02489435312390733,0.25382805963406185,0.8495022150698445},
{0.029127637767491554,0.23806784069440368,0.8609144006975435},
{0.024529880913711798,0.2208212960711898,0.8623402480253416},
{0.036947769530203324,-0.1517712348118222,0.8391279742033777},
{0.05258863383399531,-0.14698583484762856,0.8298365362163219},
{0.03518688813226416,-0.19676552941991643,0.8361999806949882},
{0.033434617890939496,-0.2251040448004434,0.8291436384980381},
{0.03895737317268252,-0.2376152543235015,0.8145831739601826},
{0.04521187650720272,-0.23768854928445293,0.7887182633820377},
{0.019902285400965485,-0.6635925505084387,-0.2768162431245922},
{0.02215820817451089,0.5362279369150672,-0.32504833261974214},
{0.030545074198131093,0.3730284957190536,-0.7180208678363688},
{0.03911537788358597,0.3656787734188415,-0.7346149671514414},
{0.03186037830613342,0.2624676530913452,0.4288676409155702},
{0.045677880261667005,0.26707001591261637,0.4472011938667737},
{0.0771182143585229,0.26899030383765204,0.4820531480586247},
{0.05815965164467083,0.24805197614028734,0.5076707382084228},
{0.04995341965049918,0.06837558741104974,-0.049071376875880396},
{0.03599733815130883,-0.5328838042567952,-0.767749496247338},
{0.04263914327402582,-0.4928148909727442,-0.7747671883692511},
{0.033714981129551444,-0.4785556166569407,-0.7844271037556257},
{0.10201547124454441,-0.6841167416504823,-0.306433615392102},
{0.09605234541872448,-0.6860642648615546,-0.35388048755968227},
{0.07880199586584379,-0.6658210377364914,-0.35650709058656394},
{0.0191338898677126,0.5483019800453467,-0.24444690541065003},
{0.04666636093723027,0.5417356727375987,-0.41281123824026406},
{0.0685392995164535,0.5448164642110317,-0.3988493492168453},
{0.08479996683703406,0.5482919670725391,-0.384993797964643},
{0.08086366696692232,0.5445885689499315,-0.3597787293217092},
{0.08092574739832926,0.5349755142762963,-0.3393482596051444},
{0.08767709444356106,0.5186443556271505,-0.30644983640805024},
{0.06937878715664013,0.5121439336804763,-0.30750039751502045},
{0.056427407348961296,0.4962699673697242,-0.2849954400921834},
{0.06375970707648829,0.3229017515092554,-0.48919580208117636},
{0.10613080306845549,0.3135330133721249,-0.5040794853812599},
{0.12378026971744592,0.32486809910920583,-0.5067791831096369},
{0.12841146990040295,0.3315475530096793,-0.5148218031281327},
{0.11339881951055786,0.3431281568400019,-0.5203199264967692},
{0.0847997665775779,0.3528607664089594,-0.5222976888857204},
{0.10020632731767276,0.34936844175313536,-0.5498593978358362},
{0.09242164147869979,0.35040057899013966,-0.5697982305875492},
{0.07792846411811141,0.35142530662726623,-0.6255334411263233},
{0.07118572822949412,0.35057680731155283,-0.6547294674980905},
{0.05103361915697978,0.35968340582058117,-0.6857021957648329},
{0.06324243690124925,0.34840118857992414,-0.7058456936807327},
{0.0603250571440358,0.34901898900215117,-0.7311973392727618},
{0.07610610306713377,0.332862056079857,-0.7133818575346218},
{0.08258189310070126,0.3263416081875678,-0.7286318153800063},
{0.09600948989510809,0.3170507709788802,-0.7061062312331856},
{0.10627358806069141,0.32070710812929226,-0.719841426552241},
{0.10298813142307173,0.3280159775004496,-0.7345965432814754},
{0.12280881109565552,0.336456112539406,-0.7240857254659135},
{0.12359603101778663,0.3533493994819688,-0.7509783675730276},
{0.11130991312344274,0.37727259437326993,-0.7893999465707771},
{0.09739628662895645,0.39404192071247507,-0.8187507735021493},
{0.07987738914537675,0.40483390280447346,-0.8378969793264153},
{0.07858171046407725,0.4219374621759952,-0.8374838440683748},
{0.06909902469639663,0.42875169069045854,-0.8427887170618253},
{0.025463290238833425,0.24384152107470436,-0.09941640389288361},
{0.036237449239234346,0.23686488214130225,-0.09892556796585657},
{0.045002004597156066,0.23176587586877553,-0.12414704491138719},
{0.04581906317825373,0.23108018749091322,-0.13699569161806036},
{0.04514498984884816,0.22869529762760632,-0.15527797814848918},
{0.04482197134607597,0.22675358194076242,-0.16748058784961795},
{0.05136004207050653,0.23261958193034896,-0.16722025055662115},
{0.06537720270382306,0.2420900518712043,-0.16905482743442402},
{0.08826505620682154,0.24112640336820382,-0.17230383685102418},
{0.11949271476124465,0.22827094784002153,-0.16677567456396505},
{0.1026116436455071,0.18787921631265467,-0.17266630646665818},
{0.0871269817175132,0.16577477780212044,-0.1799990067130975},
{0.08623642791600797,0.14201379307030187,-0.1886155703329233},
{0.06955161106729879,0.10861011526533774,-0.20338110055387762},
{0.0722288797365867,0.07817308104380032,-0.2149520919303049},
{0.06957404012638774,0.0348567604187986,-0.2359454909781112},
{0.07055230756968728,-0.004750554818823271,-0.2558486775466294},
{0.07757120124833734,0.15449496367493723,-0.7164500326623173},
{0.09096575523247918,0.15463254192131326,-0.7027118334514196},
{0.10365920086063501,0.16182626210518347,-0.6975483436340122},
{0.12348809117092102,0.1611990494885173,-0.674758817523984},
{0.12512120703583562,0.1712576814520893,-0.6680931815259851},
{0.14307727091219383,0.19554314569956832,-0.6291725559635062},
{0.15743427184259925,0.2099442037103271,-0.5969892592843288},
{0.1673909717429902,0.2273761885899371,-0.5727166116420433},
{0.16284968805584515,0.23799955221985603,-0.5913311286102274},
{0.1595395995051188,0.24170875786669208,-0.5983446152835613},
{0.1561714357121086,0.2482976944929851,-0.6004142967628859},
{0.11359587481541084,0.23077158766898392,-0.6558815601493294},
{0.0862556528237985,0.22885450389524664,-0.6776203248929312},
{0.07429075109712142,0.23272792229612682,-0.6708199142809423},
{0.05143814325840558,-0.4394994154426475,-0.783647093173916},
{0.07631737679337347,-0.43168489094470797,-0.7786257875703761},
{0.10363717232045837,-0.3892937690071256,-0.7628289211502423},
{0.11357464731305877,-0.3519047277652927,-0.7576069555716385},
{0.1264795669269105,-0.3308107984704984,-0.741774843487222},
{0.13532442632674893,-0.2869465679734664,-0.7219679817171126},
{0.10697990316253737,-0.28351352011666314,-0.7512457139469896},
{0.10596598953604289,-0.25090106742295315,-0.74249978271849},
{0.08970932740458537,-0.22981154383619418,-0.7454830478367773},
{0.06395876497590278,-0.23696541238829025,-0.7610496158823371},
{0.05291866141773281,-0.26438173297324014,-0.7741866362058683},
{0.07838205178629432,-0.20371192917543968,-0.7398529534865371},
{0.08699380917917253,-0.1785066732458573,-0.7257833248757088},
{0.0895629377421387,-0.14814213294744671,-0.7080403370606958},
{0.10607252756671542,-0.12326790589888258,-0.6837522694402868},
{0.09090988284421295,-0.09841430557430206,-0.6773892254805325},
{0.047503645723399227,-0.07375976314913602,-0.6795892758658116},
{0.047905966970807366,-0.058409675575675835,-0.6684376277905655},
{0.0763634364682883,-0.04533393464572699,-0.6440073759562889},
{0.061017754602863454,-0.028273431057277802,-0.6369302067758988},
{0.04524872424713458,-0.005504731930689392,-0.6198252455881841},
{0.034884896872387855,-0.540401343981262,0.7253617787205102},
{0.04046052065055485,-0.5273484326293145,0.7144814822083491},
{0.054456253522063174,-0.549429440783479,0.7107628643670739},
{0.043453999001105824,-0.5523830675022559,0.725942330883893},
{0.0406197269181952,-0.5678028453664568,0.7340740663603764},
{0.03687707794218188,0.5437272530290244,-0.46542540515491865},
{0.06837068105437404,0.5467701954652447,-0.4606786552657623},
{0.10543930716636472,0.5464233460871905,-0.4310052103505301},
{0.09411964140740742,0.5471546936210554,-0.4022437469986114},
{0.10871314875552765,0.5527743744795756,-0.39451453302899236},
{0.09747538911413627,0.5690602744916313,-0.3730675463130031},
{0.08552971229524972,0.5534067938421017,-0.3677873052326594},
{0.0934659945425293,0.5741334472943145,-0.34309491377028073},
{0.09274345842473508,0.5431268751794824,-0.3139361356573577},
{0.10303379057907423,0.5270135988186294,-0.286360008026399},
{0.10171227842793121,0.5151990919435219,-0.2882262258982738},
{0.11122820726533295,0.4983929178643851,-0.2771352564382414},
{0.10338023943821613,0.49139044546113947,-0.2731118437047038},
{0.08388297878731685,0.5029822638210064,-0.2891704492340276},
{0.08379586592389099,0.4772675478349749,-0.25826881307421895},
{0.04517062305923554,0.4771792334148122,-0.14882201380108068},
{0.03820139372571102,0.482986156864834,-0.11206118647319467},
{0.04649213521037855,0.4886126465448635,-0.061741792666578824},
{0.0458995674796266,0.48496031458357447,-0.0458295767997017},
{0.055174784450734364,0.47973033862672476,-0.03946533128321054},
{0.06315993000531489,0.4737964506815029,-0.04180376095269031},
{0.0680342451680397,0.4605759221647567,-0.06422941563089138},
{0.042686404505677546,0.45565855121895926,-0.8169652601911036},
{0.048355749709323395,0.4445181176732575,-0.8011627865061974},
{0.024119549288057603,0.25147461050537073,0.838875647288627},
{0.03269005323296863,0.2592300584637456,0.8430508566899273},
{0.032410090513268985,0.2565111358275782,0.8525035035391852},
{0.038031773966350796,0.24892650918530046,0.8594304781274618},
{0.04632491856449215,0.22404807668815716,0.8686650424289708},
{0.024130163039233623,0.2346107617028622,0.8276222674096558},
{0.02135536801479997,0.19865517764816093,0.8166166084779439},
{0.02447981604967395,0.21355768533712277,0.8165044631824991},
{0.0405608506380867,0.21659722336258855,0.8105861954748571},
{0.03415034518722456,0.25338308312249347,0.8331896805501207},
{0.044319920889504434,0.25609299408313413,0.8416416308969902},
{0.04496655867341727,0.25404734373854765,0.850860174442007},
{0.04827324281338902,0.244536821906462,0.8599571604971399},
{0.05989530035113492,0.2264521914592546,0.8657931215683038},
{0.024533285324466372,0.16103163258317474,0.8071789810878974},
{0.028821841577948384,0.18350014278499222,0.8010772757184207},
{0.03448337666280432,0.19811788152730678,0.8041224210086586},
{0.051588337850519125,0.20395644597140053,0.8000761786971199},
{0.05989009360527499,0.22056576500514063,0.8101400174065517},
{0.04895893119125138,0.23531847862090122,0.8183232195632663},
{0.0528165290950956,0.24370494412560914,0.8264725778718905},
{0.06694403268875154,0.2310465439022798,0.841211473585177},
{0.0753331015663894,0.2175518601900622,0.8578900823907452},
{0.08517965876589709,0.19883881556945177,0.864030237575803},
{0.10190192413290658,0.16945054011977917,0.8637138276350841},
{0.03403299314591984,0.12550840869430435,0.7929611604795173},
{0.028960621381061296,0.16209380873860174,0.7880359794149299},
{0.032708477102934556,0.18188905546025427,0.7919572598258303},
{0.04163143769067203,0.19536371322685672,0.7950106157537705},
{0.05565640844277846,0.22027318593970346,0.7776823652724469},
{0.07239609638247312,0.20615929998906582,0.7975066496152413},
{0.07407387010610947,0.206586853927949,0.805915343919582},
{0.06669871485496609,0.22589246627931145,0.8166081975807854},
{0.06269332547248213,0.23686848681151298,0.82778387679077},
{0.0860814270969468,0.2057361517582179,0.8161492029072867},
{0.09078291834901296,0.20277070973152814,0.8339971266773232},
{0.10427499868830055,0.17762813501172117,0.8424286505596649},
{0.12211691467465247,0.13812074924271883,0.8443515418576307},
{0.09835953461304466,0.1596312182063081,0.8948998322226276},
{0.04677269870844666,-0.28288370412706704,-0.3051421421593817},
{0.0596037225829785,-0.26561192681237805,-0.27647780464369637},
{0.057901717465147835,-0.2667227660156498,-0.2533820818252127},
{0.052025704502753754,-0.25806915439643596,-0.23522976368182616},
{0.051312380319942515,-0.2266081935755965,-0.209156983788196},
{0.05378638564123678,-0.5562306524332925,-0.7485013583598911},
{0.06248846004883926,-0.5032442031896525,-0.7659721935739945},
{0.037818297386093415,0.19597810923832915,-0.5263182979868718},
{0.0815657766201891,0.1934125853455737,-0.5273300087593485},
{0.09049474499161113,0.19395969417977932,-0.5613344649327668},
{0.08575560496178848,0.18750372983237082,-0.5827133634336646},
{0.05387309798575033,0.13072156285683728,-0.47572975547118845},
{0.09647689546576543,0.12451131686212656,-0.48669115706309085},
{0.08041488552568707,0.14530345515650075,-0.4775421035493585},
{0.0568579651796868,0.14301549086997112,-0.47317544610797746},
{0.05320683477513465,0.15401774539092847,-0.4667601344301677},
{0.08231094205652843,0.15993501180128974,-0.4681781716391757},
{0.07872169182392708,0.17312950658873633,-0.46118531168982524},
{0.09784707066475323,0.17835327450244537,-0.46185738242466934},
{0.11535695647280615,0.18632820682476214,-0.4687174703545914},
{0.07742601314262758,0.18687311280495006,-0.47967226338444086},
{0.08548285158251029,0.19626828519029252,-0.5090763593311494},
{0.04403334960775179,0.030985144353023776,0.32363249826475177},
{0.07000419743820092,0.0154550235284835,0.3197827104796974},
{0.06480145676738781,0.01668641892435841,0.2955685385986083},
{0.02677418863880042,-0.3822943004957222,0.5248726249729149},
{0.02848019894575411,-0.39258763654190365,0.5272190650206408},
{0.04215231253612179,-0.39190014582893595,0.5289350883004019},
{0.054786481365256816,-0.3973934629706247,0.5236067849505819},
{0.07298906463213739,-0.3883531503415825,0.5208558208014303},
{0.0979910572137261,-0.38532082165653814,0.5102921344894444},
{0.09633751488428406,-0.4106524413029521,0.5043039762316056},
{0.14983562703839093,-0.40941283526937494,0.49947552048433946},
{0.14992894794495748,-0.422264085348978,0.5053022696205203},
{0.07666382565251538,0.5463754840771703,-0.4831295426354384},
{0.12876913328908932,0.5371252995380814,-0.4810286206809542},
{0.14790312328653002,0.5357801567711127,-0.4304631080027283},
{0.1353971205093319,0.5420050217061224,-0.4113016824597948},
{0.13106450717549656,0.5477967254374767,-0.40259420104687627},
{0.13613747971872356,0.5660952329838538,-0.38967386145490096},
{0.11166997962560292,0.576999360371297,-0.3781236970619134},
{0.11382857630345876,0.6072167099694363,-0.3591643333102367},
{0.10221613121960811,0.5969409967553962,-0.34881792850817517},
{0.1067914590142989,0.6064060596909354,-0.32792706230191837},
{0.09656761299940202,0.5710446454426356,-0.3257726710726417},
{0.10898670317263044,0.575454358667089,-0.2884312915813728},
{0.11661138170613847,0.5618176910004602,-0.25846066163321196},
{0.10594736540662081,0.5408817664165692,-0.278610968370621},
{0.12489911929896373,0.5421245766014449,-0.241305235062547},
{0.1186554299750757,0.5165023804841552,-0.26441978226990887},
{0.1155808465447834,0.5058445722277783,-0.2753319200355981},
{0.12892874007564198,0.49480967541546833,-0.2668745626834126},
{0.11943824418917148,0.47542155616817144,-0.2565988494693725},
{0.03345003786906315,0.2449301314783433,-0.07325230568724841},
{0.03750248822374267,0.25144837651661495,-0.06754090599781076},
{0.04802091589863827,0.24632834300119233,-0.06465276412119543},
{0.046387199255355234,0.23867582840327925,-0.071321804529949},
{0.035666109010834425,0.2399296528582431,-0.07815325535764137},
{0.026702095234585922,0.17958647223342558,0.7799573126943268},
{0.03077377049705598,0.19750408629420274,0.777198338166929},
{0.030427321637914072,0.2048385888757474,0.7668961907046769},
{0.03023467204109644,0.1949806168872391,0.763720275989572},
{0.037156840402425374,0.21810918225653153,0.7563409152898495},
{0.0389179220598207,0.22381978090814458,0.7632891173804781},
{0.04104828215435918,0.20787051704187945,0.7796048560515003},
{0.029050137357960967,0.16630326250690391,0.7724207483215252},
{0.035111991095663535,0.18307118702991593,0.7592933404518895},
{0.04707809437907752,0.20335867149478865,0.7527244297712115},
{0.05143914455568634,0.22395515630050292,0.7523663658636127},
{0.05018051387377486,0.2308380738084262,0.7593540190671032},
{0.03935548897151148,0.1074209746147108,0.7791568756480897},
{0.03818176829900819,0.1278550490014863,0.77002744756106},
{0.047754370562500766,0.12901415073369057,0.7616511952886159},
{0.045769999611496644,0.16767503978154094,0.7575020196166153},
{0.0723121876703457,0.18298908065289385,0.7509599437030616},
{0.06453370987451341,0.20837497061192478,0.7495288896294037},
{0.06485412500435564,0.22350417200525,0.7544228302188314},
{0.062402548742150316,0.23015058309545847,0.7591733850376547},
{0.06888174318647237,0.22533914940196514,0.7709650623347608},
{0.06726504859696221,0.22038813486753436,0.7799581137321513},
{0.08498540709343023,0.2087963165076673,0.7899450528104212},
{0.09597684760375541,0.19194107886177328,0.8049829358917413},
{0.030641799515452216,0.12299415122232363,0.9789034673322755},
{0.036138721327351714,0.11984266816086923,0.9952292189761054},
{0.0353296731245001,0.10752530979136567,0.995159728944821},
{0.03193968105076937,0.10663275339529893,0.9771093428646154},
{0.036416681452489844,0.09631017946851943,0.9385419749827875},
{0.04537809185580838,0.08212540167040419,0.9377279202935322},
{0.041482444655295395,0.06562662585645965,0.9347292351971213},
{0.042098442742417065,0.04599859578069346,0.9507816326833045},
{0.04742274090311407,0.039712251192645195,0.9356688525653837},
{0.054115211668237365,0.04098289744192575,0.908419548366864},
{0.06349216044307003,0.03862023637825166,0.8985507623677237},
{0.05908645240773946,0.04489576695566777,0.8702721245645857},
{0.06064366993877266,0.030484896231557604,0.8365442267001124},
{0.05360154616320904,0.05024689988348905,0.8170419595628095},
{0.049764174464436116,0.06440524343339231,0.7753787807483374},
{0.05128854944466049,0.04732191026694185,-0.06408282570898857},
{0.0740155946043694,0.05449560450519694,-0.07127214018482346},
{0.0629328357820392,0.07612062187770474,-0.048658041358383926},
{0.03590121361235616,-0.2454139583244051,0.3034323269227611},
{0.05554506418515828,-0.21116118042535909,0.3031457556410085},
{0.07283025888340934,-0.1598082475655459,0.32304353520421053},
{0.070029430129676,-0.10813389827860974,0.3501842987774961},
{0.11177731869410007,-0.09544906380706844,0.3464220243747799},
{0.10011621056240465,-0.055099186506037214,0.3621696269687006},
{0.1389461185912468,-0.06243248753084495,0.35525747158017923},
{0.14419311660186934,-0.03493145719594306,0.35320901760320667},
{0.12179449695024873,-0.02607298015308633,0.3501069986274216},
{0.11285912027622988,-0.01681138082499687,0.34119445153140404},
{0.0481624993341373,-0.22526385184645223,0.7637675372212238},
{0.06857254258617464,-0.1828438925471841,0.7384815767308124},
{0.08106052201231916,-0.14829833532324477,0.7122307661806636},
{0.03742438703584363,-0.3696389041642351,0.5351515423382533},
{0.03874249477623208,-0.3476670374136731,0.5386588864532887},
{0.039481251909974556,-0.3581878682020425,0.5448114577246279},
{0.04628066122468269,-0.359438488505708,0.5490743807677226},
{0.04395364634420354,-0.3780578117008396,0.5349282530446446},
{0.06722279385171427,-0.3666648509809308,0.5350163672053512},
{0.04639120444447826,0.28442249778813433,0.3773703209878718},
{0.07785977512465149,0.3028808123805201,0.34279452458605364},
{0.084195383538913,0.30097914858490654,0.37734348622074754},
{0.061067819466901305,0.2848822934994579,0.41231459478900856},
{0.03219601315464315,0.2634180844702396,-0.07562958569122155},
{0.04028869803717696,0.2634268958863103,-0.07065614209770178},
{0.05071821051354133,0.2587316126773848,-0.06757995659176029},
{0.05655737573600356,0.24858506681256232,-0.06924791760204521},
{0.05274663854489876,0.23765931140385482,-0.07707946415375762},
{0.04858244341368676,0.23226492243350486,-0.09814635842197152},
{0.0696927939838855,-0.02130139809136716,0.6980804330090064},
{0.05993114679378603,-0.014875873181293681,0.700642151972095},
{0.07350092780206034,0.00805323376967198,0.7050416519642848},
{0.0847202635734858,0.01567470815188158,0.7029463372745728},
{0.07726780817226797,0.036531129731680365,0.7154897885700714},
{0.08794163718513705,0.05780649409374785,0.72112308707161},
{0.08092815051180308,0.07511391759163172,0.7273211172394954},
{0.07969935848885815,0.10176204290278484,0.7251046455788118},
{0.06460219860851718,0.10402297216273404,0.7410026430243022},
{0.05238296737252784,0.09402561959274436,0.7616850391367054},
{0.06525864910578144,0.004142967628859959,0.8115714719991219},
{0.07545225594279947,-0.015351289130197078,0.8097801511638477},
{0.09650773542201276,-0.02607137807743712,0.8080723385217886},
{0.08731722820085702,-0.06030372951195569,0.8087902686720916},
{0.09331740202606495,-0.09411874023985474,0.8025750161909769},
{0.06590228299785202,-0.10934306487485185,0.8207165203237314},
{0.07615156196368014,-0.13903092847092693,0.8075122128229333},
{0.05672919834938145,-0.158234208240196,0.8241469648076047},
{0.0533211829245971,-0.1880570467097171,0.8189694568282666},
{0.05132359484948699,-0.2186108321941908,0.8014577686851082},
{0.06130712951700222,-0.2080058924342378,0.7826518036768436},
{0.07333971893985847,-0.18579191200118872,0.7590620407800346},
{0.0947286304135638,-0.14150052808418584,0.7382733068964149},
{0.10106423882782531,-0.11362481230682471,0.7119592143581224},
{0.09450594189832345,-0.12574371355528222,0.6957115639021916},
{0.075773071591554,-0.15348145056735504,0.683013312047088},
{0.051283142439344405,-0.17730031028200136,0.6737258792491552},
{0.054109203884552814,-0.17429381506680053,0.6586863940921858},
{0.052493110073411106,-0.15743176859939736,0.6597619876311749},
{0.06464465361322128,-0.09060598911950321,0.660456487425108},
{0.06835746393026804,-0.07210401796567632,0.6758864785215725},
{0.06235008076463865,-0.5015650276498231,0.18432180733358136},
{0.06608471936240592,-0.5375416389474201,0.18479842483922168},
{0.09045749673276696,-0.52124973115168,0.17562814382313724},
{0.09415368551495316,-0.4926200385219089,0.17478485125328375},
{0.07521354667106703,-0.4761270702321928,0.17801864095121636},
{0.05772588966264692,-0.5924704046562727,-0.7268789443603132},
{0.07506715700862035,-0.5458041438487704,-0.7466401469744199},
{0.08263215822419526,-0.4973739977514868,-0.7615712917656114},
{0.08650757921963695,-0.454965052722307,-0.7695522318716128},
{0.10615062875461447,-0.4285912828660812,-0.7585195379133204},
{0.1281537359803361,-0.3928151312840916,-0.7433843287363107},
{0.14167024797327415,-0.371543571851691,-0.727725240822009},
{0.15027359446899402,-0.3252718221728071,-0.7144532456250318},
{0.16385639234191818,-0.3127291719151332,-0.6861818171623155},
{0.14759772761589915,-0.2596800414617178,-0.6945194193597224},
{0.1364474813568459,-0.24723832196994422,-0.7091267446103171},
{0.12324878112082012,-0.21063409753676862,-0.7127382236425512},
{0.08220640662041741,-0.5822567718736393,-0.7238123713082669},
{0.09017533115904966,-0.5524058970802571,-0.7372357626540946},
{0.09244306924050799,-0.5135397420898515,-0.7518100450944243},
{0.10275723227012916,-0.4661048854896403,-0.7554039012945172},
{0.1276022214380952,-0.44400325061149215,-0.7364086911001894},
{0.14837553534359113,-0.44270536907617497,-0.7134899976409436},
{0.15765095257415507,-0.39428924114082203,-0.7092198652574274},
{0.15722099552179802,-0.35743349083072024,-0.7108215403877263},
{0.16906093534783664,-0.3508517635448487,-0.689916856278995},
{0.17673067225897873,-0.30645063744587486,-0.6650558463545369},
{0.16357823195732388,-0.2656543818170822,-0.66530597041527},
{0.1411856200893878,-0.21015127198798764,-0.6866560315544818},
{0.13520947739891803,-0.17746352173876473,-0.6856419176685312},
{0.11458655834499178,-0.1537069427149815,-0.6957746456308793},
{0.10262946673710457,-0.18141263821407014,-0.7191603441418701},
{0.10702976776711906,-0.20559476858217507,-0.7274124355515005},
{0.04793300199738781,0.46777364753774986,-0.654833201896377},
{0.05644422914327802,0.500437767171147,-0.6463207731937498},
{0.07798313494964075,0.5036373125020775,-0.6480694387648638},
{0.08781226957646326,0.5088660869021904,-0.6401381630039878},
{0.09313877059117791,0.5105046097724212,-0.6162554205228293},
{0.09082777646719088,0.5168776667049829,-0.6049319498342052},
{0.08292453703017628,0.5268587982590243,-0.5914651021863927},
{0.07264401758918854,0.5333061514498184,-0.584343675666193},
{0.08373819120051938,0.5363052370651415,-0.5600716288022762},
{0.06840853009158664,0.5447163344829561,-0.5362451592282961},
{0.10323725418652405,0.5428100647198509,-0.493999826174792},
{0.10771745873954293,0.5386823168096586,-0.5211207640619187},
{0.14175455720431387,0.5260591622506119,-0.5161252919282222},
{0.1610515583990618,0.5246036765233036,-0.45252429047073384},
{0.1892072368961226,0.5118507538366708,-0.4083164147469461},
{0.16200138899958785,0.5314749789827701,-0.3962115316604192},
{0.1507782482984955,0.5451569052864892,-0.3975482635302297},
{0.15144511228747964,0.5829432612893264,-0.3793805254087195},
{0.14262107987108097,0.6091061579382248,-0.3683554413097609},
{0.13304947890486912,0.6240711465775057,-0.3588076712188311},
{0.1318152798766081,0.6474978982770077,-0.3425822495625332},
{0.12297863111447191,0.6419581209414916,-0.3362340248025341},
{0.1221369406202676,0.6405200577868687,-0.3209059657692506},
{0.1166021697711555,0.6153614623105695,-0.3110075413705997},
{0.049326207033833024,0.44093087003521764,-0.7813857633950546},
{0.06606068822766775,0.43224341456791415,-0.7962386067388908},
{0.06162193738207221,0.43143096195430786,-0.7724694113693701},
{0.03736030400987519,0.12982059556361222,0.9770118165094694},
{0.04889244505180911,0.13596916164582834,0.9676234529456363},
{0.04401692833234738,0.12496009830336181,0.9942239165062254},
{0.04061732380472139,0.11386772702713632,1.0},
{0.04866495030962114,0.10895055634079512,0.9981107522906677},
{0.05261967404969878,0.09986718792868038,0.9805776363857011},
{0.043032252586451,0.0978782110101848,0.9683574038524311},
{0.05737904028459271,0.08996575963818723,0.9523668865381989},
{0.05337345064265261,0.07987348408598177,0.9478534389154587},
{0.051891530667132334,0.07105786256674147,0.9547175320345038},
{0.043853917135040145,0.06106811985608554,0.9582220725171531},
{0.04472905095842172,0.049765275891444964,0.9702798946314846},
{0.04616110632936031,0.041281684550503635,0.9654556443327974},
{0.052666334502982054,0.036316051075773764,0.9520873243374116},
{0.06101394967319658,0.03365800731427637,0.9243868355841827},
{0.07402981302575616,0.036580393557893595,0.9121157371490501},
{0.0726161815247835,0.028870404496065098,0.8941086071113733},
{0.06528508335399343,0.03399644579517221,0.892176904397337},
{0.059920332783153854,0.030198324949804973,0.879163043639339},
{0.0585293306007263,0.025539288702442896,0.8660494536721774},
{0.0612474521990691,0.012654995812574782,0.8427074117226279},
{0.06266108370004177,0.04447422080046909,-0.5577888712616065},
{0.06981114732247098,0.06233155676494464,-0.5420154351978422},
{0.10858257959011695,0.06899879483859286,-0.5303687457469898},
{0.12808424594905157,0.08368922776349039,-0.5099174490469852},
{0.10183023124760439,0.10595968136317413,-0.5022777510542659},
{0.05880008138544297,0.4363329129219816,-0.658016125692447},
{0.060886384399628145,0.46159644435330416,-0.6506235478686185},
{0.07689272221089642,0.48024520568848994,-0.6552825841159806},
{0.07476456497037562,0.48939526049950316,-0.6545422249065889},
{0.11182538096357639,0.49712006876108683,-0.6573106116284257},
{0.10701374701062696,0.5043636535495388,-0.6421239357711851},
{0.10707522666366542,0.5042811466536044,-0.628022666166285},
{0.12072611275168105,0.5018740279906646,-0.6216141633099843},
{0.11444717776351039,0.5097237981528868,-0.6022564835000226},
{0.11476879445008953,0.5132431578352913,-0.5828377245559346},
{0.10535079248674582,0.5250220185272038,-0.5728219481159791},
{0.1117502836675196,0.5315701022244419,-0.5420280515435798},
{0.052538969488869776,0.48529614969154033,-0.09489334381624834},
{0.055661815448094544,0.47742495176751004,-0.12604610533407082},
{0.063300311884077,0.48110291693918633,-0.0838358176853932},
{0.06144070257425519,0.48823415617273735,-0.05903568663560509},
{0.05850750232000579,0.3000739758431023,-0.5215152751905369},
{0.08873025892346123,0.3047858805868883,-0.5091476516975393},
{0.043609800857991605,0.2922127908918795,-0.5607959672551758},
{0.058809093060969785,0.29202474726255334,0.2610187759260898},
{0.054449044181641724,0.2837744581880284,0.22875357312934635},
{0.08522671973809266,0.29853418088475425,0.2360063698527812},
{0.08734486400580592,0.3056147544758989,0.2840916691665722},
{0.11909379792459109,0.3172155845112928,0.3286403864847296},
{0.04853157751182431,0.2828134130579579,-0.08938080176676903},
{0.05168826731913866,0.2686438549785101,-0.07387391103914233},
{0.05796499945329167,0.27551055147048514,-0.0874871483494015},
{0.05980838774716522,0.2592086307019374,-0.07637274853299936},
{0.06315292092434958,0.26842336931728744,-0.09681803744931934},
{0.057299737539956756,0.24152632150213815,-0.09017783440225156},
{0.05475423959281644,0.23260716584406757,-0.11019556937968833},
{0.057182585758108195,0.10608364196653182,-0.0252949721659382},
{0.08146344403809574,0.09000240711866295,-0.05093619293156214},
{0.07661936805324979,0.14376966798183724,-0.00797573336014141},
{0.10935137564228212,0.17676361493951562,0.0047405418460156916},
{0.11327345709100708,0.20019757597943896,0.028888027328206414},
{0.09378620941291536,0.19480278649017665,0.03291484447249855},
{0.10497270263353198,0.21540367700392626,0.050734731918673816},
{0.12019923012254675,0.2236940179696815,0.05154678401336771},
{0.11982554597736825,0.2440746230816646,0.07480712010480778},
{0.12059394151062115,0.25427203484834954,0.0956200853826217},
{0.10674559959884022,0.26495888072586843,0.11974313921116195},
{0.09305366032231357,0.27228657448590393,0.14047940511726992},
{0.10520600489994836,0.28752351546663857,0.16797102325773272},
{0.10117458178816473,0.29703003210960116,0.1953236613356264},
{0.05840356766226321,0.012394258000665667,0.341236706276652},
{0.08328480379179264,0.00014959381374509876,0.33811566265253257},
{0.10120782485788586,-0.0006270123572100002,0.3280079671222035},
{0.11627955178729561,-0.005479098720302011,0.30856417574609657},
{0.12115306591219581,-0.006030212743630653,0.2907202571651831},
{0.07483145162873017,0.008640795014020156,0.2783926855634159},
{0.12692834836814576,-0.011218134214688551,0.2776833665697277},
{0.12247958454974263,-0.021441179191760848,0.2570692589318721},
{0.144781278624586,-0.04103156048977054,0.2454285772647041},
{0.1532200118473494,-0.05433259330788969,0.23415116625099475},
{0.16005346526960326,-0.058772946229134454,0.2294414643612264},
{0.1518115870922367,-0.09569037645173085,0.20406098140751155},
{0.04320467597819734,-0.3389703700113867,0.5507369347726915},
{0.04928074813728666,-0.343238099281429,0.5563448003232988},
{0.06145912644422113,-0.34346699583981,0.5555105194289721},
{0.06051830751922189,-0.3621407896070148,0.5435636410533486},
{0.07960844069576543,-0.34468877878178966,0.545792929319226},
{0.08765126097371753,-0.3513604225634732,0.5297533484382365},
{0.0946000638427146,-0.36311985808813896,0.5197806277813535},
{0.11804924460130543,-0.3434025122949293,0.5212913851185595},
{0.14374793983084483,-0.3569694896708175,0.5113356865154494},
{0.13737868782794987,-0.38167089280872296,0.5041271471318239},
{0.18759735112812156,-0.38245951454704713,0.4998878547045552},
{0.19865147284822213,-0.39346817737060136,0.5075810219720669},
{0.16167977231300873,-0.4191031900930845,0.5121903938743034},
{0.16540139404612614,-0.431170424401855,0.5230985264508697},
{0.176532615656845,-0.4443717280108108,0.535836429678291},
{0.1647337290193174,-0.48123949388828163,0.560601915842165},
{0.1351518026755464,-0.5193933259931567,0.5988326475782022},
{0.11024192944378737,-0.555462657418952,0.6431178234520644},
{0.04525813644157369,-0.32670788273286866,0.5443540651267782},
{0.048193539549840764,-0.31558807591115046,0.5518079223441891},
{0.05432067787024868,-0.32428934928092834,0.5658945730087901},
{0.0678456007603451,-0.313904895182198,0.5745005228774399},
{0.07385058081250068,-0.31942965305850257,0.5657173433900962},
{0.09374715881896585,-0.31289859141503734,0.5548855096663237},
{0.053447146122516324,-0.565309815396828,0.7197689326291142},
{0.10622192112100436,-0.5742027370661429,0.6655596991462138},
{0.1198954365275651,-0.5926117878323155,0.6753800223569656},
{0.14619050441752332,-0.5864712321283454,0.6446522114050963},
{0.17872685851789577,-0.5884552025604372,0.6239171470557253},
{0.18117162595859193,-0.6112247027248503,0.6408324625384647},
{0.16237347106911715,-0.6300230578737812,0.6650936953917495},
{0.15533855663397494,-0.657755387880538,0.6809942962101698},
{0.11912824255104912,-0.6508274119949805,0.7042806660309096},
{0.10686535475361877,-0.6291889772389107,0.7070368369259211},
{0.12155458612177936,-0.6645537958979653,0.7132737174283},
{0.12960221262667912,-0.6769204180936821,0.7097137050762968},
{0.11361870439341208,-0.6789448409359164,0.7277298467895005},
{0.10186848080372929,-0.6839411141074376,0.7341679880453115},
{0.057637975761396454,-0.6212793294992992,0.21195601020682392},
{0.06684750763088657,-0.5843322608771924,0.19731444058922737},
{0.09098477988081356,-0.5524074991559064,0.1833064918908938},
{0.13053802506527454,-0.5508246484144859,0.18235946492275387},
{0.13554671432307697,-0.5234563900990121,0.17787845933191038},
{0.12687327701770412,-0.4846324898538546,0.17488217734897332},
{0.09746457510350409,-0.4607561556752929,0.1759277319695397},
{0.07969194888898055,-0.4719154136098729,0.1763524822760368},
{0.07834240041397633,-0.4700720253159994,0.17652730878125694},
{0.07847236880101859,-0.47024805337795644,0.17671635370786387},
{0.07834199989506405,-0.4684729535586305,0.17748314716546756},
{0.08202997803954803,-0.46037766530316665,0.17808773046358858},
{0.08655423967292022,-0.4302169891311182,0.18031781976729047},
{0.08450678699322842,-0.40945128508495604,0.18673633559639868},
{0.07444575191618259,-0.39801266520904477,0.19653182663458774},
{0.08853901114283665,-0.3744595497927114,0.19332206807139327},
{0.10398101780667031,-0.34759894919858164,0.19859770318424547},
{0.11028498522685991,-0.3107103563376711,0.2151451420460348},
{0.11095725622116011,-0.26370225263851843,0.2438417213341605},
{0.08966627162151282,-0.26687396190504414,0.2516768725560836},
{0.07162049150879879,-0.25727332331769037,0.2660647134427364},
{0.07613554120718802,-0.2354202104246261,0.27713565695715364},
{0.07951772316212884,-0.2197905606503786,0.28599153062708044},
{0.07801637801936187,-0.19432376587106254,0.3008133337552132},
{0.09735403188370853,-0.17716573592746762,0.3028645913645719},
{0.10020031953398822,-0.15932301890329106,0.31336499568841386},
{0.10501335530313072,-0.1294811557854356,0.3312713952196465},
{0.12972076622472073,-0.12856356695734994,0.3264539537424687},
{0.1299202246430475,-0.0842123054629578,0.34902439600746726},
{0.1718950071712911,-0.09608128291013836,0.35197081338582265},
{0.17957035134720542,-0.06414450562148319,0.36497706428448695},
{0.16179912694887494,-0.04847200032361927,0.36000402120987945},
{0.17063557545155503,-0.023159605584995913,0.35479627405266256},
{0.13496836501371173,-0.0207434752465294,0.3404110365389398},
{0.12566971768623428,-0.013091361167528646,0.3241924237041511},
{0.11484829745418162,-0.00768655870545878,0.32626991530226557},
{0.05769925515497878,0.4691057734400689,-0.16783164267625134},
{0.06442316665471784,0.461313277482306,-0.15359519793844906},
{0.06739882191367133,0.4763149136020628,-0.06828446935850088},
{0.06738220037881078,0.47812846323696984,-0.046197453420651804},
{0.06201805058633965,0.48623676835708346,-0.042666478689790496},
{0.05502739349100694,0.48690183001096216,-0.041660174922629765},
{0.06793731959126244,0.4508375050715708,-0.10387878535430503},
{0.06536738999047165,0.4309994028263018,-0.12800664540979292},
{0.0672053712790291,0.43561478251222285,-0.1412796419040509},
{0.0714502709710701,0.4013433804837547,-0.12771106245251349},
{0.06254853788568468,0.4056850054931168,-0.1152961777278642},
{0.052617070676768816,0.4341677076820729,-0.6645119416716297},
{0.06963291640649626,0.4166303863285273,-0.6673139719821},
{0.08208284653597199,0.42337852922246066,-0.6656626325066756},
{0.07482804721797559,0.4387071890341125,-0.6594147377342083},
{0.07050764971096551,0.4541201580768043,-0.6511141835361894},
{0.09696452724149407,0.46672508902534116,-0.6531293944434409},
{0.125441822425134,0.4790849023995488,-0.6626281009676136},
{0.1272639832166555,0.4880288902301821,-0.6624650897703064},
{0.1346068966953585,0.4919754033325576,-0.6547304687953712},
{0.15426796958138964,0.4829507109410952,-0.6357342573037627},
{0.144593435254716,0.49212339507065356,-0.6232184418132132},
{0.14258263005549987,0.5012003551801713,-0.6099318276759369},
{0.13628627249464406,0.5054430520181947,-0.5887435761772952},
{0.15197539932736853,0.49938440243179066,-0.5736558284913934},
{0.13327396975521486,0.510086468027977,-0.5648782562688218},
{0.12679457505143663,0.5201915601853762,-0.553466671419491},
{0.05379379524111438,0.2966277108621931,-0.10806881395536055},
{0.060445012558270485,0.29728115746761496,-0.11635034350504515},
{0.06192292734466774,0.14561525912972847,0.9455834979799829},
{0.06018687811929135,0.13080406975277167,0.9771253636211072},
{0.055194610136893356,0.12428262056320168,0.9924598309569876},
{0.05190094286157144,0.11794020332743102,0.9984718200901087},
{0.04985849666828342,-0.23137076396178885,0.5796834378620941},
{0.052250796131467915,-0.22905015738390658,0.5900202302102604},
{0.050614676374711065,-0.26772626615042444,0.5824672445620546},
{0.04911613486433022,-0.29164185118239183,0.5696320152389435},
{0.04738689446046297,-0.3098953003511349,0.5613312607814684},
{0.05568784917739423,0.2398193098979037,-0.1267494165440745},
{0.057885496449199575,0.25099458858897583,-0.14218561568367977},
{0.06768238930358171,0.29683698199387126,-0.13482928482141462},
{0.06808350899425294,0.2760398372130933,-0.15886963149456435},
{0.06520558034990133,0.25468276699291603,-0.16510731303476783},
{0.05388951926115474,0.23991823806924248,-0.6289332459134054},
{0.07480281452650052,0.2470218414978446,-0.599484492107975},
{0.08409345147573194,0.2560613530890622,-0.5739423997731461},
{0.09626301836659575,0.2645743825700577,-0.5493719663195636},
{0.09714576204931107,0.2719044794435671,-0.5368333212510128},
{0.10817605289412963,0.2799146574301665,-0.5215613348654516},
{0.10851369033720087,0.2935118739839336,-0.5131706639121646},
{0.06043179543416449,0.10825485499012519,0.9898314255950009},
{0.06644438534565382,0.09948609418362428,0.9706994381921215},
{0.0711396685545793,0.09122819524976561,0.9482962125730096},
{0.06390689777675956,0.13278243292009126,0.7471924625544855},
{0.06335358089941326,0.14272371284235855,0.7541456711315179},
{0.07094061065516483,0.16089525589353565,0.7540912005594448},
{0.10359571861303504,0.15257647808500693,0.7515270784828824},
{0.08863593671961392,0.1888470702642343,0.7556354012258281},
{0.09016491766732979,0.20092351650798776,0.7619129343978057},
{0.07943041003924683,0.2171235052133544,0.7664406004419325},
{0.09218693739609035,0.20384690404888572,0.7820888743456021},
{0.050735232567314194,0.06292592683080198,0.9672549755463178},
{0.05480430445685429,0.048037437303770754,0.9707310791861936},
{0.06277703392515342,0.04072276040838511,0.9569620400190485},
{0.06208834165544879,0.033624163466186796,0.9400799676060302},
{0.07445856852137629,0.039616326913148675,0.9353914932186138},
{0.08652640360851518,0.04636266747197668,0.908108545431461},
{0.08464376446123598,0.03987566290886471,0.8926206793521686},
{0.0893891125341993,0.03152584488463253,0.8823177308520919},
{0.07938635295889353,0.016684416329796885,0.890176512689841},
{0.07043755890131254,0.00886548612382203,0.891055050923977},
{0.06313649964894516,0.017500473613613808,0.8890116034334082},
{0.05894286637767891,0.008040817683390593,0.8816528694576691},
{0.059981011398367715,0.0007443643985147097,0.8677758904436589},
{0.06689256600852063,-0.0011767245643455645,0.8490666507527149},
{0.0758591831576991,0.0017476642738331863,0.834110874048417},
{0.07861955950128986,-0.003037535430904271,0.8202178742779146},
{0.10058481768979888,-0.00872109905593686,0.8140026217967999},
{0.12718227735854573,-0.007732818639829771,0.8049186526063168},
{0.10244763115091914,-0.0611338049577032,0.8038422580295029},
{0.11402723368396094,-0.07256521549319297,0.790339163420127},
{0.1055316267756505,-0.10399753921180281,0.7868704693801288},
{0.09324050239490282,-0.1175719261875686,0.7964386659355861},
{0.0529038422179776,-0.18385179838999405,0.6192284724088528},
{0.05276506241486469,-0.21590032045518173,0.6208912266732778},
{0.05205974861029949,-0.23964047820356052,0.6030631285894004},
{0.04793480433249317,-0.2723993205597171,0.5975620013289217},
{0.05111652657182645,-0.28102089066594677,0.590857114477517},
{0.050908657256341305,-0.30166423618440047,0.5770201873547367},
{0.05342591862016427,-0.25610901483962617,-0.33991899905517586},
{0.05967181079806997,-0.23867843177620923,-0.34345998675884476},
{0.06454412336623329,-0.26015185274041047,-0.3439239879187475},
{0.06009836343967242,-0.26531734515237937,-0.3238688044230104},
{0.0603893404294604,-0.267177955759482,-0.31138823459674353},
{0.05749058480166903,-0.6465490689737624,-0.6776103119201237},
{0.06700150715266698,-0.6593328316166424,-0.6500970657583965},
{0.09746217199003027,-0.6278067864725537,-0.678117368863099},
{0.08249077504815237,-0.6204214179891466,-0.6941341201660871},
{0.09387532487090273,-0.6640905957758871,-0.6190099893421916},
{0.09065294996197071,-0.6487885704719034,-0.6523185439054838},
{0.11873613453590472,-0.6370091090016226,-0.6509657912791812},
{0.11708619687667339,-0.6286506798207757,-0.675175557452235},
{0.11627114089013724,-0.6136416341011414,-0.6980021315616511},
{0.1123218241553757,-0.6042362484835353,-0.7017513890997176},
{0.10769422864262936,-0.5946167855073032,-0.7058298731836967},
{0.09968204806146842,-0.5778296360765006,-0.7181986982334312},
{0.108131595294864,-0.5341880940947091,-0.730352444627259},
{0.11302874003559009,-0.4918508419508315,-0.741564571058263},
{0.14353566480732435,-0.4818118354139623,-0.7076578414994465},
{0.1538844727228597,-0.5054424512398263,-0.6791823486509121},
{0.1706644128132408,-0.44149960689068757,-0.6744370005779488},
{0.15925443003955925,-0.42727778109318426,-0.6969619839464009},
{0.1651510697259369,-0.41266805272911583,-0.6878668002263733},
{0.1744727468908718,-0.39324628989318555,-0.683375581403266},
{0.0705765389638816,0.4341022228399113,-0.8166486499909281},
{0.06700310922831619,0.44013343688082285,-0.8319106234036817},
{0.08562183164507936,0.42086046682081296,-0.8253569324416713},
{0.09907926709845274,0.4028757658422252,-0.8019496059094161},
{0.08616553606853038,0.4123552474586073,-0.7958957625499596},
{0.08840143289646064,0.4078167674038484,-0.7798453676583381},
{0.07560645572403606,0.4163764573381272,-0.763644778174603},
{0.08957214967712167,0.3971972087035963,-0.7443153349479585},
{0.07382815175341172,0.41621705081103066,-0.7184948819690791},
{0.06942845150176567,0.41777947508792396,-0.6957516157934219},
{0.061917320079895505,0.4198703840696005,-0.6745833902403954},
{0.0806371735220151,0.41185279648312345,-0.6742493574675349},
{0.09435434549001685,0.4116529375458844,-0.6688677851023787},
{0.10043922906517683,0.42173419882800156,-0.6651249358669091},
{0.09777758063346871,0.439250092419739,-0.6609717550057854},
{0.09499337341459593,0.4538582187081583,-0.653501276253514},
{0.1125821614483725,0.450339259544666,-0.6513034287222526},
{0.12759941780570905,0.46241951071808635,-0.652533021783022},
{0.1433175822595755,0.46771136684688674,-0.6563463623470568},
{0.14746335352082157,0.47609242534627866,-0.6585273880840016},
{0.14692045013519514,0.4834864049863002,-0.6574698178960661},
{0.1591783314462217,0.4783930059785458,-0.6468390446662696},
{0.17661792618516547,0.4694930752282657,-0.6173748708827156},
{0.16529745938838358,0.47909731848583015,-0.6086093142275131},
{0.15638331021671675,0.49122463063144606,-0.609950451805359},
{0.15409073996269565,0.4973649860759601,-0.5923238147343698},
{0.16464341200459315,0.48610940334297115,-0.5886388404817281},
{0.17364146988838738,0.48819310298422625,-0.5710732825448651},
{0.16525460386476717,0.5060338174138413,-0.5616186331010457},
{0.15187707193439817,0.512878885884552,-0.5550713504416321},
{0.1553589830985024,0.5173835220912214,-0.5419129023562927},
{0.17163346832155738,0.5174500082306636,-0.5200029157776815},
{0.1780119322594353,0.5147551167292344,-0.474529400291017},
{0.20665624382950548,0.5008422912725727,-0.46406864733949305},
{0.20916128936650324,0.5062863445880483,-0.43564522194955785},
{0.20978910276153784,0.5051885222494262,-0.40316253738343394},
{0.2006022002105928,0.5041792145904233,-0.3666033713278924},
{0.18085020953146896,0.5176937239887999,-0.36655090335038076},
{0.17677633141498125,0.5296293878348788,-0.3588092732944803},
{0.17180288782146147,0.5472353981818844,-0.3682859512784764},
{0.161031932972359,0.5694637972957763,-0.37808144231666546},
{0.16608928527800618,0.6011248173133111,-0.35869031917752636},
{0.16017962872697866,0.6314511080555969,-0.35488839340249223},
{0.15366298576435627,0.6432714224549325,-0.35167042420159556},
{0.14269817976169924,0.6588614208568622,-0.3396824926374611},
{0.13793020237019082,0.6713053432026533,-0.3217999239815104},
{0.1361150506596346,0.6719117288358797,-0.3140006192022384},
{0.1408399722680705,0.6750335734978238,-0.29593641521955844},
{0.13602573494219108,0.6540666086982294,-0.2972545229599469},
{0.13045972361791935,0.6133162124848954,-0.2972901691431418},
{0.11748471319441467,0.5958465788275289,-0.29381867147075746},
{0.1261289126191894,0.5804608450708738,-0.24771013324863694},
{0.14606774537090253,0.587145305457751,-0.19450239730594956},
{0.14227342945520213,0.5635651550148371,-0.1978315105050103},
{0.059309941960804406,0.3808133818174827,-0.038703143793098346},
{0.06396897820816648,0.3702659165214452,-0.031395876497590285},
{0.05789050293560336,0.35935417927466823,-0.03159913984558395},
{0.06563794051573218,0.3558492382731066,-0.03889379079535447},
{0.0694737101388559,0.35699652469739795,-0.06064296903067615},
{0.07172442616654137,0.3552132142403698,-0.11323590844297873},
{0.0667159371681951,0.32463159269149106,-0.13882486149054712},
{0.07538356694933955,0.28555917046124957,0.43563140404708334},
{0.0901396849758547,0.27989302940890215,0.4664953914291355},
{0.10557928852621455,0.2725006518445298,0.5007305464960402},
{0.07636043257644604,0.2517273379390338,0.5183677973182054},
{0.07427673293519083,0.2369578025289565,0.5420108292303508},
{0.07582013256374959,0.21240679424262074,0.5715314761805395},
{0.08959938496315825,0.1845705295781214,0.606884279272225},
{0.1044856716361718,0.17351120111216092,0.6291639448068918},
{0.09194161956230491,0.12375453637733047,0.6443702460908353},
{0.05412662645723799,0.23293839498454197,-0.12475102743113978},
{0.0616067176634047,0.07364201058891902,0.9555600235665329},
{0.058161453979776186,0.061587192366429934,0.9679254442055125},
{0.06257817628519509,0.05225610300705594,0.965936667546473},
{0.07738235658118657,0.050185219970994406,0.9401210207945412},
{0.06393733721409457,-0.17228921791072513,0.8120084381324442},
{0.060280199025857885,-0.19329663512046205,0.8044965056727493},
{0.07837864737553973,-0.16517640254714006,0.7917367741646076},
{0.07785797278954613,-0.17626196500185637,0.7787885985082271},
{0.08970191780470778,-0.15602975214688147,0.7658686594351642},
{0.10768121177797953,-0.11780262508105499,0.7620685359952354},
{0.11571381882366792,-0.09880721462727109,0.7387779607259164},
{0.12347867897648192,-0.06327037309538237,0.7070614688390278},
{0.11735093987770553,-0.08829900018463921,0.7005846775081795},
{0.11337438785690739,-0.10375762838333344,0.692299343028828},
{0.12243532720993318,-0.09283848153667891,0.6841091317911485},
{0.10533837640046444,-0.1192795385701715,0.682814654666586},
{0.11018605705552112,-0.13124263796174324,0.673297123753535},
{0.09735463266207697,-0.15504567717935355,0.6721852832529824},
{0.0828338194965397,-0.15413529769168932,0.6768953856616632},
{0.06377152238440123,-0.17582780250092017,0.6660303088681695},
{0.06292162125249473,-0.18790064407446286,0.6556877089957749},
{0.05547937908354063,-0.1933993682214677,0.6470379023062279},
{0.0540841714525339,-0.16282936172104578,0.6404363493341974},
{0.07559764430796538,-0.04432743061911011,0.6713323782292338},
{0.07530346316687901,-0.04943965401574279,0.6839144795997694},
{0.07356420979020417,-0.05186639810538533,0.6864217279907847},
{0.07313064806763642,-0.05273632518290696,0.6865809342584251},
{0.06832622345510843,-0.0621435131356185,0.6869738433113942},
{0.07372021190654611,-0.05170999547013109,0.6867227179533802},
{0.07503711809019764,-0.0441824427728565,0.6888570832370419},
{0.0777179914296963,-0.029577921154647958,0.6923560164549188},
{0.08439804610853821,-0.008882708437051032,0.695276800622887},
{0.05544313212197722,-0.2364185038135408,-0.22282328985433525},
{0.06337881359088834,-0.21265952167628377,-0.20758594835468833},
{0.07324599751437963,-0.18919712379358697,-0.20574976940123624},
{0.071558611336848,-0.1624160262035493,-0.18691857170149645},
{0.07608767919716784,-0.14191426412059463,-0.17741385739363918},
{0.08478935308585803,-0.13181137481721317,-0.18851564086430378},
{0.08905648157753183,-0.0954594772987883,-0.18484508529250496},
{0.08873967111790035,-0.08744048789611819,-0.17202347361241224},
{0.09708107824497418,-0.06270423961284238,-0.16590935215665417},
{0.09236076260402977,-0.05256590438572213,-0.156095236989043},
{0.08573377668106798,-0.042916202231611265,-0.13973684305386058},
{0.09861386412235691,-0.020317523383295392,-0.13526084394942087},
{0.052303464368435734,-0.2579612145495704,0.6089894066752884},
{0.051182612192356404,-0.2790994011841742,0.6015649875979319},
{0.05995177351776961,-0.2908820668057535,0.5913171104482967},
{0.05546936611073306,-0.307718079543857,0.5786114489933156},
{0.07372461761458145,-0.2999578253585345,0.5815586674094957},
{0.0907947336569259,-0.30220814086730763,0.5691602039602508},
{0.1053850368537477,-0.3176357288502984,0.54220027467587},
{0.10383963463062743,-0.3367090402325252,0.5280677645958103},
{0.12324617774789016,-0.3100114508357027,0.54320037039989},
{0.14485837851520428,-0.3266618230579539,0.5302578020082819},
{0.18594921580399565,-0.3623979227487132,0.5037728881538921},
{0.2246309318352858,-0.36010314964067447,0.49414301168594027},
{0.22837958859498364,-0.3788878871465871,0.5009448241141222},
{0.2136639229786111,-0.4202414648418491,0.5259962807813803},
{0.07605744001928898,-0.27662940105200295,-0.31418165375059925},
{0.07418020787732585,-0.26034129818592966,-0.29284541051386176},
{0.06708721819989978,-0.25742852439620767,-0.2859941340000104},
{0.05935219670605235,-0.26956364666061344,-0.30036955880038174},
{0.0749429961458065,-0.2378163148174775,-0.26551780486798693},
{0.06862761393661627,-0.250939316979078,-0.2591149092764586},
{0.06834745095746046,-0.24471605411971747,-0.24591660955934508},
{0.07041512984222358,-0.2249440374949785,-0.23973680300196937},
{0.06332734691065743,-0.2172112188551487,-0.22204227797534484},
{0.07851282121116117,-0.19147427406948442,-0.21853893904943245},
{0.08379846929682094,-0.1608950556340795,-0.2123545265245652},
{0.0827901629350987,-0.1425987509417201,-0.19669023186440351},
{0.07001380989209618,-0.004495824790598693,-0.611139792715442},
{0.061672603024478495,-0.014005745844315883,-0.626144232467585},
{0.08695555962304762,-0.018551635498952442,-0.619519649658097},
{0.1125170771251233,0.004950614015518504,-0.583084243946457},
{0.052783286025374465,-0.22806728397311557,0.6336211195224531},
{0.061731078785674715,-0.24685522563032664,0.625957790913908},
{0.057357011744416056,-0.24668039912510645,0.6198588891768174},
{0.056774256727015505,-0.27067628819899053,0.6116430447287505},
{0.05758230363258637,-0.2807217030384566,0.6058641576025898},
{0.07162770084922024,-0.27606627146130525,0.6047364966050014},
{0.08349047025326012,-0.279363743666294,0.5891186621386668},
{0.08940052732319992,-0.295166017091744,0.5778392485303959},
{0.10148858861541012,-0.2807277108221411,0.5761068039752303},
{0.11732730926187966,-0.25980740647583006,0.5828972016144116},
{0.13449595295665062,-0.270897775157494,0.5707845084090948},
{0.15209915967127008,-0.3033414091296684,0.5459977947428688},
{0.19937821441459552,-0.32755457971347673,0.5182870927573764},
{0.21784493990413978,-0.3467001847593742,0.5002202854017664},
{0.2448250953935919,-0.3268704934112636,0.491421685936299},
{0.25159746968171964,-0.346363949132496,0.47639461686561096},
{0.25074776880926924,-0.3567321822152781,0.4809373023689492},
{0.2541916306767047,-0.3681567839292587,0.48681631922318547},
{0.24989406274769588,-0.39275565422561465,0.5028220562560853},
{0.23270038662090603,-0.4202660967549557,0.5231814338657164},
{0.2189509728804639,-0.45075039220814483,0.5405124879794261},
{0.19620109814275372,-0.44758509124421597,0.5411395003366362},
{0.05479789615425745,-0.22306420198008536,0.6413737638484419},
{0.05877264583995023,-0.23486549173108678,0.6404699929228308},
{0.06254773684786008,-0.24188678852321066,0.6350760044713931},
{0.0765656985190012,-0.23948587790341164,0.6318003605471247},
{0.0864442972314931,-0.2397878691632879,0.6236916549080989},
{0.07541781131634144,-0.2658582459434443,0.6128201698120084},
{0.06750876435509845,0.4461165886522579,-0.19827047923289412},
{0.06534436015301424,0.40138363263444105,-0.10435320000592768},
{0.0607992715362023,0.39378759120316276,-0.06830069037444914},
{0.06578953692403879,0.3854117394496309,-0.05647637078599033},
{0.06795153801264918,0.3694232247299601,-0.03807492987915143},
{0.0723578468263482,0.3788720666495511,-0.09045178933826666},
{0.07477137379188475,0.3481196237845753,-0.15727396414795008},
{0.07571139167905938,0.31053252594060865,-0.1705471609016642},
{0.07827351116106025,0.2687828350410792,-0.17356907609498867},
{0.06474117867108625,0.2360304009875194,-0.6322597557395361},
{0.06746871246386818,0.23277398197104168,-0.6548197845128148},
{0.08686203845702492,0.2391922975406937,-0.6532831937057652},
{0.09081936557003252,0.24667258900631656,-0.6203859720654079},
{0.08723852623458953,0.24792501164508735,-0.5997744678004823},
{0.07547188136950232,0.13576549777892236,0.9525571330215427},
{0.06393733721409457,0.11814566952944233,0.9895921155448998},
{0.07387981869309877,0.10524795925601207,0.9672181278063858},
{0.1020687402598807,0.09074056347403694,0.9030784284118503},
{0.0797856703144594,0.07997801952209282,0.938148064632538},
{0.07581011959094201,0.03301056849253892,-0.5716582404162833},
{0.08937970033976018,0.018674795064485553,-0.5831769640746551},
{0.11646859671390251,0.030090184843483227,-0.5585889077889313},
{0.09552185811937945,0.048997481136560536,-0.5492119590140986},
{0.11580834128697139,0.05643792097040925,-0.5377098568905874},
{0.13498358473237926,0.04835524906068301,-0.5332524819155697},
{0.15432604482367354,0.0625646587719049,-0.5102408680686698},
{0.1406429169632175,0.09581553861182546,-0.49549656535006753},
{0.12130085739083557,0.11246991602319963,-0.4935159993287303},
{0.12410188640402504,0.13985579717081448,-0.4762442220140414},
{0.10120121629583288,0.14243854337679898,-0.4790800961726012},
{0.062120383168433005,-0.2131050989662206,0.6475345457574833},
{0.07501108436089797,-0.2240985420711073,0.643159477418944},
{0.09418172183881435,-0.2176075323188723,0.6369956916180602},
{0.1068779710993563,-0.21434350344306083,0.6246695218324861},
{0.10050191027495221,-0.24860809665001976,0.6070012307946174},
{0.08912256719806179,-0.5958059261579303,0.1960207645024894},
{0.11133394425818088,-0.5891076478685786,0.19276895145350315},
{0.14782922754721015,-0.5630460825044927,0.18932148491585699},
{0.1744224817673778,-0.5334677608309325,0.19055428212792488},
{0.15585983199833703,-0.4962016788951766,0.18118073776384683},
{0.14372230662045743,-0.44943428706231786,0.17951738272105336},
{0.12965888605276996,-0.415164487109499,0.18173405464119308},
{0.07907334742892891,-0.4692587716645686,0.17688256905646954},
{0.0921286618943503,0.4071072481507039,-0.826058841835482},
{0.10654694221833808,0.39078670325273424,-0.7956650636564733},
{0.070167008376052,0.3451057189694969,-0.6812614423246758},
{0.07438527356042487,0.1269652962378057,0.7302190718294621},
{0.07903629942954091,0.1370345419525537,0.7334494571166402},
{0.08316484837755796,0.14844092005602458,0.743596403500375},
{0.10704658956143577,0.14131668990343887,0.7328669023586959},
{0.11450164833558356,0.14242252262030686,0.7392239385347655},
{0.1233164688169993,0.1383957054760147,0.7509809709459575},
{0.1224054885509666,0.14336794751279755,0.7639942309255872},
{0.10808974106852837,0.17425176058100875,0.7651543339550722},
{0.07958741345286953,-0.19013654090239313,0.6532601638683077},
{0.09730877324661831,-0.20231812336062602,0.6431768999916291},
{0.12070268239531134,-0.19005643711993256,0.6315608502375677},
{0.11751415133446892,-0.23774181829978916,0.6003674360501465},
{0.09872520837997709,-0.26040237732005583,0.5945500991084048},
{0.09006919364728941,0.2359955558421491,-0.6630392336310924},
{0.10132037067224293,0.24868199238933963,-0.6314991703250732},
{0.12036564573060857,0.26142370054642794,-0.5994282192007965},
{0.10031466768345067,0.25795921195500887,-0.587514383635438},
{0.06934614486528747,0.06373157062289904,0.9559865762081352},
{0.08505870205438164,0.06566387411530376,0.9302520345359447},
{0.10131155925617229,0.06624903224617815,0.8949244641357343},
{0.06405128484464472,-0.0015782447739291078,0.8791438187315486},
{0.07169438724811865,-0.0066075607557151035,0.8708747052681454},
{0.08185655335052092,-0.004287955475113554,0.8538123993445909},
{0.102327074958316,0.002943413486513124,0.8306045312306622},
{0.09536425392738831,-0.001914280141351131,0.8225803350821324},
{0.11807507807114898,0.013958084093751861,0.8277540381318034},
{0.14256961319085004,0.012547055965709169,0.8025337627430097},
{0.14437615374479174,-0.006503626097972523,0.7842905268065303},
{0.12134972069813649,-0.043984185911266634,0.7953877043097036},
{0.1322392291452806,-0.04604185182322216,0.7800836764111582},
{0.1217920938367749,-0.07841439368846276,0.7749802644305962},
{0.07692836839409137,-0.07449511587212392,-0.6712688959816338},
{0.09907305905531205,-0.07433490830720281,-0.6578833536730188},
{0.09082457231589246,-0.06011128017459419,-0.6526195338680794},
{0.07088493852635473,-0.18726962652812984,-0.3301409305896719},
{0.07659974262654694,-0.19052824839862526,-0.3314420162762875},
{0.07565371695568779,-0.21930112653954464,-0.35020011927453204},
{0.07452845907157311,-0.23484746838003312,-0.353615544299194},
{0.06544929610803757,-0.24759778769373594,-0.34904221909906474},
{0.07455849798999582,-0.260570595263223,-0.35969261775556405},
{0.07670888403014946,-0.2758996555937873,-0.35297351248277264},
{0.0772199461622478,-0.28138756573015994,-0.33320349845259517},
{0.08619116927891776,-0.3050267927126385,-0.33908291582574385},
{0.09654438290248846,-0.3035444722182059,-0.31158869431235103},
{0.08729519966068036,-0.2788460729721427,-0.3010796788318946},
{0.08942515923630655,-0.26984641301269924,-0.2833873566592877},
{0.0799528869603458,-0.24874447333965882,-0.27711262711969625},
{0.0800728423745805,-0.2342428850819121,-0.2683260432215979},
{0.08383731963131433,-0.21825517140006592,-0.2538941452545918},
{0.08154555041511782,-0.21164000078501705,-0.24615772194455135},
{0.076839252936104,-0.23148330977614598,-0.25051596848877405},
{0.07077119115526075,-0.20730318200260253,-0.23370518844214566},
{0.07924096459372762,-0.19138475809258473,-0.22926543629926935},
{0.09017473038068119,-0.17741005246397232,-0.22647001455085208},
{0.09456121350822123,-0.15449075822635805,-0.21705721933336833},
{0.0938210545582857,-0.13998816867133057,-0.21349220049496126},
{0.09028407204373987,-0.13211456763382637,-0.20758935276544288},
{0.09937284746117067,-0.11160940114011711,-0.2036302233173299},
{0.09837435381279985,-0.07723326341608187,-0.1907010723092839},
{0.0990233947101865,-0.061889784404674686,-0.1775354148835231},
{0.1046298584446008,-0.04493561858744188,-0.16889602168569598},
{0.10754523560725275,-0.022641534371932268,-0.16242523813853227},
{0.09611843103925445,-0.0329406779423421,-0.1538030672539342},
{0.10013924039986205,-0.022302495112667974,-0.14897240865265038},
{0.11600099088378903,0.001530983542277377,-0.1420462351021984},
{0.10388709612173531,0.0021039258463265036,-0.1289724967668111},
{0.09437096702487742,0.013551156878852251,-0.10760260994144015},
{0.09229988372935974,0.04338520987791782,-0.08573387681079607},
{0.07791364491835621,0.03196501387197253,-0.08919115606179366},
{0.09793638638219676,0.07981560910315402,-0.06809662598863088},
{0.10189451453302899,0.4063612816765401,-0.6768048683874828},
{0.11167999259841047,0.40401704448283193,-0.661239702158116},
{0.11306198310531122,0.4199048286960585,-0.6590718935452772},
{0.11121499014122696,0.4341342643528956,-0.6590354463242576},
{0.08365708612077807,0.40903314334051194,-0.7243508689858581},
{0.10765678012432907,0.3831023474012931,-0.7360440186305377},
{0.10415143860385515,0.3958428540016445,-0.7187572218566374},
{0.10618587441889712,0.40431703314814665,-0.703475623017181},
{0.10359972380215805,0.40704857213005174,-0.6932960343420935},
{0.12041971578376943,0.39740007153267765,-0.6741932848198124},
{0.12445814797651837,0.3912090504457575,-0.6578074553391373},
{0.1200388222981695,0.4000268748190155,-0.6466447929938027},
{0.12120613466807595,0.4136883746582072,-0.6494450209691677},
{0.12344062967981315,0.43362019832895493,-0.6490651287808484},
{0.13404957462888917,0.44424836818582153,-0.635713430320323},
{0.1476630121986045,0.4539341170420396,-0.6415283641485908},
{0.16321215767147915,0.4670443025984464,-0.6450771619710497},
{0.06899569081702253,0.39219332567274157,-0.08567760390361752},
{0.07472251048458381,0.11469259572702395,0.9662386588063495},
{0.10496509277419823,0.10648616347339612,0.908772806047515},
{0.12463697967086156,0.09293841100529848,0.8654380615525473},
{0.12573019604199198,0.06741414176206695,0.8546791222708139},
{0.07096744542228911,-0.0026073781190911003,0.8822734735122824},
{0.08726355866660845,0.00031741123799996444,0.8704451487347005},
{0.0881869550189225,-0.002262731595054542,0.8581922739100777},
{0.09901298121846663,0.006492211308971899,0.847902342274651},
{0.10208456075691665,0.02827182898162859,0.8619773778907951},
{0.1159058676421171,0.037913921276405714,0.8464626770443785},
{0.13545479523270346,0.03854173467144032,0.8276829460248698},
{0.14813462321784102,0.03825756650316149,0.808517114773901},
{0.15340605288211406,0.029852677128487673,0.7821473501067984},
{0.14854775847588134,-0.006124735206934092,0.7671088662471097},
{0.1309193190697868,-0.06508031806007863,0.7615768990303836},
{0.08788115882937933,-0.026887835880166334,-0.2584324250498946},
{0.0828836841011214,-0.05141000680481631,-0.2683022123463159},
{0.08792181149897806,-0.07358133197370512,-0.2734152367807731},
{0.10114394209137358,-0.09273654947349785,-0.27253329413588245},
{0.09709970237439625,-0.10858348075766962,-0.2879154232223268},
{0.08727036748811759,-0.12721742289310028,-0.29379203696308936},
{0.11050266725569646,-0.6774356856743596,-0.5761494592393905},
{0.11409371982340319,-0.6550390686173005,-0.6162251813449505},
{0.1339822874516223,-0.6396124819315906,-0.6174609824488607},
{0.1481961028708795,-0.6361700218803481,-0.6362339046468605},
{0.13286784357813983,-0.6383368291959061,-0.6664468485369645},
{0.13849753740946769,-0.6419166672340684,-0.7012665609563751},
{0.12608365398209917,-0.6261252078192506,-0.7017706140075081},
{0.12562886475717938,-0.605189683754272,-0.7199337461615268},
{0.12155979286763931,-0.5740549455875031,-0.710774879934443},
{0.11701170035898509,-0.5602965201715342,-0.7131918113107342},
{0.12629753108126887,-0.5134634432370578,-0.7196916324790398},
{0.13191240571284155,-0.5462385066091628,-0.7014175565863131},
{0.15128390342527775,-0.5406018036968695,-0.6709456772194055},
{0.16307878487368233,-0.5151516304524142,-0.6515585592693894},
{0.17321131257657418,-0.49640954821066163,-0.6377897203617006},
{0.165481898347499,-0.473989701056689,-0.6707800626491682},
{0.17686064064602094,-0.4832763328167974,-0.6409952734763158},
{0.17970172155044073,-0.46051724614410433,-0.6541791545125865},
{0.1960911557013266,-0.4334209401700843,-0.6633037763726685},
{0.1907694609135596,-0.4065897777160088,-0.6735586626032688},
{0.07509038710553391,0.4168196315145903,-0.20097077773963945},
{0.07441050625189995,0.4059249163215863,-0.1666016490965695},
{0.08162265030573611,0.39170689545374987,-0.195678921610839},
{0.08512618949110466,0.3449785542148407,-0.18281906037462134},
{0.08389319201958055,0.31061102764742,-0.17939422315552028},
{0.08974977981472795,0.26651790059200703,-0.17496748787729383},
{0.08877291418762147,0.29972312127592504,0.4071869514142523},
{0.1120156274469202,0.30513753619189016,0.41983994463226554},
{0.11736756141256612,0.29955169918145946,0.4549812737382552},
{0.11432281664124039,0.28886204967155443,0.4700475936623489},
{0.11850443434513754,0.2850408989887298,0.4900577187804519},
{0.11593170111196063,0.2738554070653939,0.5180355668804502},
{0.1143486501110839,0.26222934433852496,0.5332444715373237},
{0.10210638903763715,0.24071587148309348,0.5541970176560752},
{0.10157109551134448,0.20713556483780382,0.596682662056961},
{0.11296866219874468,0.20058207413524962,0.6210604459137258},
{0.12150932748468915,0.18760085566860424,0.650016961975936},
{0.11351677233023104,0.17260022084612822,0.6553196321153686},
{0.10981217265088648,0.16005917266410358,0.6476593073986656},
{0.10629000933609584,0.13920375238158555,0.6574067361673784},
{0.10798380381622429,0.11913054553479487,0.6718949070415631},
{0.10332116289865148,0.0937819038346081,0.6724564345566115},
{0.08967888796725036,0.0636702912293167,0.6631301514241851},
{0.0808432405023949,0.14880759512023778,-0.6929359678399334},
{0.10938662130656478,0.148538045892258,-0.6778265921327672},
{0.1291790643958312,0.14653064510379646,-0.6538242947562862},
{0.14175996420962997,0.16033573097304868,-0.6402695332072232},
{0.14828882299907759,0.17736018785939064,-0.6274172818303393},
{0.17105191486089374,0.17763654590887953,-0.5877566975773812},
{0.17579265696636562,0.1922476760891411,-0.5692685443260288},
{0.19193457042944836,0.2033702865432454,-0.5339197464234662},
{0.20676178056289726,0.20811202994599803,-0.5068302492709554},
{0.19583041788941752,0.2354158047165908,-0.5213490598419311},
{0.1832637364970055,0.24120430429664672,-0.5468216621454757},
{0.19093147081358605,0.25238198610119267,-0.5455263839830885},
{0.18462710287448417,0.25629866054460154,-0.5600968614937513},
{0.17495977788823197,0.2651248958150179,-0.5649487475973871},
{0.143017994113173,0.24996245135197162,-0.6116848989550862},
{0.11892918465163464,0.24449416664230175,-0.6360426568662358},
{0.14230547096818638,0.017483651819297074,-0.5530853774149788},
{0.07896841147390558,0.004820245109563958,0.8858511086964271},
{0.0904841312404351,0.015165648614344737,0.8781234968024572},
{0.08212870595143065,-0.172611835894585,0.6663210855985013},
{0.09676106363404426,-0.17632224309815794,0.6566105045697205},
{0.10993292910294576,-0.15962801405500965,0.6596736732110121},
{0.1410546504050648,-0.15123213635586263,0.6436483107514094},
{0.15567899770943233,-0.17866507847567306,0.6258392373158663},
{0.15553020493351183,-0.2349856474047776,0.5935025418932768},
{0.07279381166238978,-0.6638014211212047,-0.3701603797880534},
{0.1000607386930507,0.4472144109908798,-0.2349498009621265},
{0.08591861615909571,0.43154831399561266,-0.22353381040476036},
{0.08683219979805835,0.17035250871028504,-0.646483784391057},
{0.0907947336569259,0.15673246257851672,-0.6586745787842728},
{0.08744979996082923,0.14870706487324978,-0.6705175225021538},
{0.08531863882846615,0.14584936243396943,-0.6812766620433433},
{0.10534798885435968,0.14265983007584626,-0.669254486112207},
{0.11903532216339487,0.14133611507068555,-0.6426962772968657},
{0.12785194497991598,0.13941983233477293,-0.641012696049001},
{0.13795883947242046,0.13908860319429853,-0.6250496142802614},
{0.15985420711073264,0.15016855838424262,-0.6051884821975351},
{0.16670247973274172,0.1575819631915109,-0.5961203335040879},
{0.18419294037354794,0.16178721151123393,-0.5682432159105336},
{0.1889765380026362,0.16853935959429034,-0.549725624519127},
{0.19406252741051302,0.18289996519490653,-0.5378540436990165},
{0.21258112009920052,0.17578755035023375,-0.49765255865499336},
{0.22102546058673614,0.18556722089138686,-0.48510670424602115},
{0.22173097465075753,0.2077755940596637,-0.47514099267010335},
{0.2277629897294935,0.2465666517540125,-0.45979210665338005},
{0.2095383779224363,0.25003634709129147,-0.5022783518326344},
{0.2195281206330922,0.2615945218625251,-0.49611576758848763},
{0.20496325038720165,0.264545545208372,-0.5257183206562422},
{0.2025210863194354,0.27213858274780806,-0.5261769148108288},
{0.19158491741900804,0.2757146158563034,-0.5344468293120567},
{0.1767777332311743,0.27894920659206063,-0.5397440924461733},
{0.14264210711397685,0.2618712804309263,-0.5937931183641526},
{0.09999725644545071,0.12225339149401966,-0.1889902557753826},
{0.10289961674345281,0.09919511719383634,-0.19542739573391285},
{0.09662428642549285,0.06238122111007019,-0.2142119329803694},
{0.1022866225481734,0.01674709753957227,-0.22879562761513814},
{0.0911325713594533,0.010068644936379581,-0.240348795899968},
{0.10008336801159581,-0.021591974562242846,-0.24624303247287185},
{0.10773127664201738,-0.0465166669937571,-0.246428472729268},
{0.09454058678423764,-0.054160770694511806,-0.2565856323452665},
{0.0982962526249008,-0.0783899620348123,-0.25924688025806236},
{0.0945774345241695,-0.08274039846024508,-0.26684692687846373},
{0.11173346187320289,-0.0902291008230263,-0.2626611037259874},
{0.10802445648582301,-0.09808127409872229,-0.27946547547001893},
{0.11513506899539042,-0.10460692873687147,-0.29226005212353123},
{0.10942126619247897,-0.12796439066454499,-0.29900879579583306},
{0.09458965035099473,-0.13359468527424131,-0.29408862121764956},
{0.0918394872396677,-0.14575864490033286,-0.29970209403302916},
{0.09062891882723255,-0.15689166884615707,-0.31354102375037096},
{0.08903965978321512,-0.16688581726484833,-0.3257075867493925},
{0.08809123099888214,-0.19038726574149464,-0.339171831024275},
{0.09631929127377428,-0.18999135279668336,-0.3498148200808968},
{0.08895975626021072,-0.2167910745161431,-0.35948514895899125},
{0.08435699292002717,-0.23758421410779806,-0.3628040489257882},
{0.08634797243308429,-0.25104225033953986,-0.3815843807236656},
{0.08448636052870098,-0.2746628531925963,-0.38110235621270916},
{0.08816192258690358,-0.3028583833214312,-0.37056870881914605},
{0.09236837246336352,-0.31966075247090125,-0.35819287468844635},
{0.10040318236306957,-0.32547608681808143,-0.3332884084620033},
{0.10912047648933958,-0.32052046631615916,-0.3078474471525308},
{0.10146756137251421,-0.29726133178145603,-0.29358156427467424},
{0.10742467941464962,-0.28836780933377276,-0.2765529019397531},
{0.10543670379343477,-0.257496412351843,-0.2622880203591773},
{0.09133803756146462,-0.23901666999764892,-0.26689258603446625},
{0.08915821338125675,-0.2171972006932181,-0.25219434299077886},
{0.08933183832974,-0.19241329065937826,-0.23611611203475222},
{0.08634276568722436,-0.0011526934296073959,0.6791877556562281},
{0.08140076282832037,-0.03089322526265029,0.6840326326788987},
{0.07875853956385892,-0.041290896485486596,0.6871596840867027},
{0.0796188541874853,-0.04100512624155856,0.6875594019611808},
{0.08036321858600001,-0.03907102041404844,0.6881433585353183},
{0.0796114445876077,-0.039575674243549935,0.6877013859155922},
{0.08065920206219176,-0.031755141961925866,0.6890617484012286},
{0.08900521515675709,0.0045613096327602135,0.6904549534376737},
{0.09301821439857477,0.32448760614251826,-0.6720461029309572},
{0.09597364345245699,0.3171292726856916,-0.6880045787322054},
{0.0867380778536672,0.1868446759621766,-0.4937434940709182},
{0.09072964933367669,0.19551330704060177,-0.5025707306386153},
{0.1162300877016262,0.19811708048948212,-0.49990607831506495},
{0.11087014335773426,0.19808043300900646,-0.5292683200354379},
{0.11846157882152115,0.1954638429549324,-0.5600339800245198},
{0.10701835297811844,0.19370876908122162,-0.557821313293503},
{0.10275322708100613,0.18863719835418769,-0.5916347219457528},
{0.10540326046425748,0.18306437820840682,-0.6042422562672197},
{0.10776772386303693,0.15971392536169862,-0.6345144769563446},
{0.10327690555884203,0.14305213835044683,-0.6590766997722248},
{0.1310552952405136,0.1503704199160432,-0.609406747381908},
{0.1372427116572231,0.1395888513157647,-0.6146084867554403},
{0.1546368474996205,0.14135634127575689,-0.5955726238915138},
{0.1685062166542973,0.14076757847467175,-0.5778148168767454},
{0.185197041286691,0.14799394094989468,-0.5615681677180956},
{0.08671745112968361,0.12343011605836522,0.7215284122108604},
{0.0986196716465853,0.13463543366786004,0.7254707198646565},
{0.11852966703661263,0.13015162444463046,0.7245006630590592},
{0.12982850581213018,0.12625657802248594,0.7379681114852402},
{0.1375264793065896,0.11871941287131604,0.7550878918727103},
{0.13714778867500732,0.11939508827637088,0.7714140440354523},
{0.12566010523233903,0.14858210297261132,0.7774754972542425},
{0.1143073966631167,0.17066711631589887,0.7876626957886637},
{0.10987184996881959,0.17375171271899875,0.8132510480578639},
{0.10868170802091187,0.048143574815531,0.8649614440469069},
{0.14173993826401485,0.06256566006918565,0.8298809938155873},
{0.14729533583711055,0.07999924702444486,0.8120322690077262},
{0.15259980831164857,0.05734309371221355,0.7880303721501576},
{0.15323062559852543,0.03950097746640547,0.7543064794748076},
{0.15170424802373955,0.012712470276490216,0.755803218650083},
{0.14381462622974325,-0.025666653716555174,0.7474423863557624},
{0.13064856828507013,-0.06332944963494704,0.7437151573578727},
{0.08918124321871415,0.40455574241987924,-0.20986389966841038},
{0.09372232664640306,0.36616740649185087,-0.1936478902065516},
{0.100238368830657,0.339565941633981,-0.1874214231958926},
{0.12253245304616658,0.3195285812298414,-0.18275657942430212},
{0.11082909016922322,0.3007146058433306,-0.1782068848399987},
{0.11104957583044592,0.2885071899152542,-0.17749556325174895},
{0.1162346936691177,0.2686756962320382,-0.170914637003702},
{0.13865394004472192,0.24455644733316484,-0.1638406719746103},
{0.1485145154061602,0.21754465084964078,-0.15825904041275876},
{0.1212223556840242,0.16670478271648745,-0.17183142479396304},
{0.122361030951701,0.1153061907006718,-0.18610051182311801},
{0.13180927209292356,0.10502927592989478,-0.18536716169469164},
{0.11245820084501479,0.06474948943851655,-0.2080687739034693},
{0.12119752351146143,0.05404281787483863,-0.20478451882258653},
{0.128932745264765,0.008019590181038557,-0.2068297686482607},
{0.11558144732315184,-0.0016393239080552816,-0.21782080863967354},
{0.10140808431403725,-0.00695921636071694,-0.2312948656279075},
{0.09604834022960146,0.33526176514291917,-0.6292744880266873},
{0.09388133265458727,0.34301761362020633,-0.6021725747878952},
{0.11000121757749338,0.34021037656387615,-0.5695657293589574},
{0.12274052262110788,0.33133447694833423,-0.5668540160632115},
{0.11193992937249499,0.3219667401084846,-0.6216942670924449},
{0.10037294318519073,0.12524286465544757,-0.03515154233825345},
{0.11541863638530078,0.15393043226804648,-0.020764903008337613},
{0.12436803122125023,0.17533196008748933,-0.009566794739264202},
{0.12544242320350243,0.2062422074039125,0.020691608047386185},
{0.1291524298881631,0.2165573717308144,0.03564658371385966},
{0.1040164637304091,-0.03195099571004193,-0.6203571347037221},
{0.12699303217248267,-0.024718425191678335,-0.5979733342518567},
{0.1505054949192173,-0.015341476416845665,-0.567961851374641},
{0.15902212907042362,0.026691781872594134,-0.5311179163724521},
{0.08886503353745111,0.031549275241002234,0.6775109832298726},
{0.09167607552344817,0.03475943432310903,0.7035042601194106},
{0.0994201086928224,0.060382231218767034,0.7145187304671933},
{0.09565943636575545,0.07015268982493718,0.7213231462683052},
{0.10003230185027721,0.08087878655586175,0.716330678026451},
{0.09378320552107308,0.10121193017673696,0.7157751582950871},
{0.10272859516789952,0.1053014285308045,0.7124662713010976},
{0.10887075294751879,0.11971950859533612,0.7174335068514768},
{0.12393867494726166,0.11717721479949421,0.7217256677751694},
{0.13395044619809424,0.11087044374691848,0.7327385360473028},
{0.1476123465561982,0.09034284819412032,0.7527324401494576},
{0.14941147751026226,0.08521059885187246,0.7785999541005325},
{0.14070379583788753,0.11129759716688939,0.8045796133470523},
{0.12714122417003468,0.14233240586503873,0.8090926604508801},
{0.09744795356864352,-0.37863696204802944,0.18906695514708854},
{0.11540341666663327,-0.3890858996916405,0.1857630746395029},
{0.13597526955924094,-0.34458163997274865,0.19987495799557903},
{0.13107031469972494,-0.3051074972734675,0.21595679362181638},
{0.12638244109067706,-0.27137599473878354,0.23587900483866897},
{0.11945386442675128,-0.21857178160024124,0.27194753522663956},
{0.10011921445424692,-0.23164672149236548,0.27035687436642913},
{0.12196912319601273,-0.17059462239277204,0.3015150428895677},
{0.1092884941730506,0.3432869625887299,-0.5585522603084556},
{0.11398818309001142,0.33987954794231406,-0.5632623627171363},
{0.1168434824158179,0.3417746031758746,-0.5602408480427241},
{0.11079224242929138,0.344793714736813,-0.5591304093583647},
{0.11271913891638005,0.3416145958704097,-0.566647148045007},
{0.11980511951284083,0.3386251227089817,-0.5578086969477655},
{0.1219308736398878,0.3393210243191078,-0.5534294231606468},
{0.12169116307087462,0.33901042190261704,-0.5544739764839326},
{0.12077397476170125,0.3394385766198687,-0.5519703327631279},
{0.13810963484290245,0.32611611603994134,-0.5390996575162781},
{0.14709047041346768,0.311335966878688,-0.5558809994228522},
{0.13485742127500389,0.3074955912880728,-0.59212035112692},
{0.12810947864052663,0.30517358289399743,-0.6259728103731194},
{0.11201502666855176,0.31249887354055905,-0.6465865174920626},
{0.11087855425489263,0.309998634230509,-0.6748823776084294},
{0.11562390232785597,0.31286474756694765,-0.6914530465671324},
{0.12532487090274158,0.3192500203263348,-0.693706566227204},
{0.08807861465314461,0.18607187472088837,-0.49228600574904846},
{0.0947438501322313,0.18590505859391424,-0.4819333929038462},
{0.09690024395606947,0.19089332138718923,-0.49364696901305327},
{0.0934473704131072,0.1850487491594109,-0.49128090353862464},
{0.09520925310832715,0.18571681470513196,-0.48892605259374045},
{0.10004792208785701,0.18156463514128904,-0.48871017290000923},
{0.11211775976955742,0.18975284378440707,-0.4813350176488659},
{0.13882155720952064,0.19888287264980506,-0.48313474938129836},
{0.12927458815641546,0.1987138536688133,-0.4975364081704256},
{0.12476114053367542,0.1953855415075772,-0.5178317027540882},
{0.1401386636526283,0.1943964600536455,-0.5279984748239819},
{0.1305019783631673,0.1972864042653662,-0.5475620213548673},
{0.12457389794217386,0.19282222046883943,-0.5638096718107981},
{0.09312595398598422,0.1433493233833755,0.9205704911283056},
{0.08866617589749279,0.1280591133873046,0.9365642125938366},
{0.10336141504933789,0.125211624180288,0.912533478374582},
{0.12273070990775647,0.11243507087782931,0.8723327943683837},
{0.13836716850351313,0.09851623763748311,0.8356330461746236},
{0.13201153414363648,-0.08542087128083144,0.6756179305908735},
{0.1441917147856763,-0.10571356249156406,0.66066035155147},
{0.1718163052050236,-0.13270212887817454,0.6421605832516608},
{0.19294868431539902,-0.1653616425440801,0.6212705180832285},
{0.18356392542177644,-0.2038370913355343,0.6043816368487012},
{0.190936677559446,-0.2512172771042162,0.573877515709353},
{0.16369918866883934,-0.27078723193769844,0.566665571914973},
{0.18591256832351993,-0.31426996817076197,0.5313091641530766},
{0.20057937063259154,-0.2787285206713818,0.5509009472672795},
{0.2232321195340683,-0.3040713548473402,0.5214836341964649},
{0.25568937114926094,-0.2916258304258998,0.49839011423199897},
{0.26515403356588796,-0.32821082995128487,0.4642749145793289},
{0.274875428605301,-0.3460267122083371,0.44230424938550383},
{0.26618677158126064,-0.35463005870405695,0.46592445171964797},
{0.27551285445423085,-0.36045941121316777,0.46181212378757913},
{0.27395623770156613,-0.37878355196993224,0.4805129525813644},
{0.2658655554135938,-0.3986767255656428,0.49558668210533563},
{0.25250063982896237,-0.42069224887764584,0.5130096553094189},
{0.24291462018190765,-0.4411433453181942,0.5271657960053043},
{0.24318957641520353,-0.4627269089832787,0.5296157701918606},
{0.2106506189419011,-0.47950284388453684,0.5548963236769558},
{0.19894104802181706,-0.47162463687954115,0.5547753669654404},
{0.1212203530894627,-0.6226863524382188,0.2120228968651785},
{0.1275072984558794,-0.5977410332827211,0.19914260916443344},
{0.14820070883837097,-0.6177537617737541,0.2185038936446059},
{0.16431658857215406,-0.5870343617190431,0.2045736456152591},
{0.17042530302259606,-0.5692989837633637,0.2001405020344358},
{0.2009256192322773,-0.5509275817749476,0.20886120057146038},
{0.19839433970652376,-0.5272519075714495,0.20158997997805952},
{0.19344052153970684,-0.4878786956380687,0.19389641219163548},
{0.1761316962256299,-0.44658199162835366,0.18921915233376357},
{0.1603142030815124,-0.4020494953261445,0.18993908507862783},
{0.14553865988775055,-0.3721485556687244,0.1926035371427221},
{0.11752937105313642,-0.6732634801649017,-0.1310129403655376},
{0.13740091662758266,-0.67871934878829,-0.15037282302951704},
{0.14369827548571928,-0.6888698998422355,-0.1731405208588247},
{0.16320534884997,-0.6850343304785681,-0.19145564994006234},
{0.16428274472406448,-0.6945714868183218,-0.22663422730489619},
{0.15631361992597606,-0.6961307069439164,-0.3460086888572835},
{0.15462262907823374,-0.6920197808280407,-0.40430341550512844},
{0.14802287844130854,-0.6914768774424144,-0.43094052654619325},
{0.133800652124893,-0.6918655810468042,-0.4723553836350375},
{0.13222901591301692,-0.6865867417826537,-0.5079484980741048},
{0.11742603717376231,-0.6883213891918368,-0.5232421124809302},
{0.09500619001978963,-0.6868586941241072,-0.5518061200090837},
{0.11885548917177093,-0.6830471558951777,-0.5450539719260273},
{0.12801035020973173,-0.6683995784938966,-0.5676696728281161},
{0.13486122620467075,-0.6536502692888906,-0.5777431239914432},
{0.14724386915687965,-0.6372498208679165,-0.589130877965492},
{0.15787884783525535,-0.6263022371784884,-0.5958171406874747},
{0.15632843912573127,-0.6280685255817436,-0.6122942884801548},
{0.17991439709287352,-0.623674632854326,-0.6119945000742961},
{0.20831939861284277,-0.6326803005974541,-0.6418533852459246},
{0.18542313421268594,-0.6443704463502914,-0.6788332964188403},
{0.14931194856055505,-0.6429570151087748,-0.6639159695301231},
{0.15552179403635347,-0.6479260529942592,-0.7011119606562262},
{0.15218246760502904,-0.6455804139843581,-0.7370262912629602},
{0.1392703386507559,-0.634278170798086,-0.7357264071330816},
{0.13589736863079804,-0.6155869544581961,-0.7485336001323314},
{0.13466817608894083,-0.593640320399109,-0.7489209019205282},
{0.1289035073841669,-0.5941599936878219,-0.7297925191878597},
{0.12826848464871085,-0.5742149528929681,-0.7145305457751061},
{0.12150171762535539,0.4382297704906477,-0.22865023924997227},
{0.11354981514049603,0.4144852070342334,-0.21585486155863537},
{0.11016042384513375,0.3716853555466462,-0.1998068697804876},
{0.12411250015520106,0.3486771461105007,-0.19129764522915887},
{0.1468785959088595,0.3397145341504453,-0.1846430235012482},
{0.14046869123636582,0.29401833014854045,-0.1723132490454633},
{0.1557100379251358,0.2557599626075543,-0.15580826518837806},
{0.17161003796518767,0.22774927195674713,-0.1420224042269164},
{0.1755132950250344,0.21001709815236616,-0.14315807560275093},
{0.1680484235375352,0.18195434004295963,-0.1488985129133305},
{0.14589912690882306,0.16081415081379433,-0.16447769730462786},
{0.14593156894071957,0.12688699479045049,-0.16963037311140314},
{0.1462990450427574,0.0804049726826076,-0.1713245681104439},
{0.13643306267600303,0.08423573581932751,-0.18454810051903245},
{0.11868086292600692,0.37423606023964645,-0.7621402288805376},
{0.12329123612552421,0.31794472919114003,0.37236123121115716},
{0.1240159750973361,0.3147958495026155,0.4074871403390232},
{0.10064769915903043,0.18458835266971887,-0.4872200422867867},
{0.09507327693760034,0.05121615565126177,0.6807301539875061},
{0.09759814816075706,0.04566296093218373,0.6980513953878644},
{0.1020336948550542,0.06373117010398673,0.7057826119520451},
{0.12688849673637162,-0.15632273173123096,-0.6834076229162502},
{0.12136634223299707,-0.10129123292137293,-0.6579125915536168},
{0.12317528590041256,-0.06459028317087619,-0.6313621928570656},
{0.09770949241837723,-0.19532726600583714,-0.23472450907395623},
{0.09901338173737893,-0.17698470137910677,-0.22250487731905455},
{0.10823733228771194,-0.1502764982311082,-0.21101078557378938},
{0.10389550701889368,-0.12064711039622936,-0.20953066793337444},
{0.0909249023034243,-0.2683180328433518,-0.39566882853424895},
{0.09500779209543884,-0.2995504976247225,-0.39705542500864116},
{0.09910710316285778,-0.31818684287362703,-0.38776558909723435},
{0.09889763177172343,-0.32501689188512634,-0.373739416788391},
{0.10305722093544395,-0.33136331431002003,-0.35708243600408685},
{0.10904117374470361,-0.3312615825062951,-0.32889731936697186},
{0.12796288871862382,-0.3266391937394087,-0.30233790899489377},
{0.11799136961847768,-0.3133365588456404,-0.2919770855119893},
{0.12117829860367091,-0.2847082680320623,-0.2632682903970384},
{0.11233984750642931,-0.2489074845369661,-0.2466073044236112},
{0.09697193684137168,-0.22889535682430157,-0.254285852750824},
{0.10532676135200764,-0.21894426418868282,-0.2378032979528277},
{0.09130299215663813,-0.3114174724773416,0.11549683770292789},
{0.10073981850886006,-0.3168805504411515,0.11193962898331075},
{0.09428365390199542,-0.3299132355880278,0.10663455573040428},
{0.1252463691959302,-0.33885101537552054,0.10263817802344716},
{0.142410807442122,-0.33648835431184637,0.09916788190779974},
{0.17444611238320365,-0.350711982444455,0.07982922674617231},
{0.16850922054613957,-0.4115880534820913,0.050849881105960865},
{0.14541329746819978,-0.4472837007627081,0.04078323876414281},
{0.14066314316828882,-0.4972744688017795,0.011327075358834895},
{0.14909646938573615,-0.5312334660786514,-0.017590790628338085},
{0.13577080465451039,-0.5509009472672795,0.6299633805558481},
{0.13165827646298545,-0.5719189782281923,0.6474244030566},
{0.17160182732748547,-0.5668814516087042,0.6096490613238511},
{0.1919253584944654,-0.5795849102096676,0.606672605027073},
{0.2212054938378163,-0.5824878712860382,0.5928202579261691},
{0.2009540560750508,-0.6167017988505907,0.6284508208835367},
{0.19851449538021457,-0.6358692321772087,0.6378371818528085},
{0.17516744694426095,-0.6635306703364878,0.6655314625628964},
{0.1491154940340705,-0.6797975457002091,0.6916675244446704},
{0.12018320936605464,0.3751438363543807,-0.7204490137422043},
{0.12693956289769023,0.3809008951998209,-0.6983824242688828},
{0.11958763774346041,0.39679969368313583,-0.6914212053136043},
{0.13387835279387972,0.3843461588834494,-0.6724051681358367},
{0.1417787885985082,0.3736278722713147,-0.6506325595441453},
{0.12699964073453565,0.3891483806419597,-0.6396309058015565},
{0.1319398412583343,0.3981286154341564,-0.6267245843715117},
{0.13270903782941176,0.4097582828312361,-0.6243957671559272},
{0.13034777858193072,0.41852684337828083,-0.6343768987099686},
{0.13773715225446084,0.43311354190489193,-0.6246376805789581},
{0.16899585102458742,0.43651855343783397,-0.5974298300878618},
{0.17031235668932668,0.4439882311522808,-0.6097015293013628},
{0.16519032057934258,0.45603523925598,-0.6354220528116227},
{0.17906589777716006,0.45393391678258344,-0.6183931902172455},
{0.1757233671945372,0.46683122653710146,-0.6270994700734271},
{0.18849711686460977,0.4549686573925177,-0.6035303339006016},
{0.19396700364992883,0.4568524980965339,-0.5858742586895581},
{0.18171773349551676,0.46711439340809946,-0.5833668100390865},
{0.12847034618051145,0.30325229367168105,-0.5063828696459133},
{0.16908636829876786,0.29907307908125763,-0.5030725808357307},
{0.14648248270459205,0.3126272398519522,-0.5081099071957628},
{0.1536003045545809,0.31454532492297016,-0.5223771918898125},
{0.1391257513234146,0.3274392302667335,-0.5257119123536453},
{0.11489435712909643,0.34314938434235387,-0.5466226042460611},
{0.11558405069608182,0.3444186287754415,-0.5484707987668823},
{0.10923963086574966,0.3466543253439156,-0.5509978728440567},
{0.10877582996530304,0.3460415314080923,-0.5558167161374276},
{0.10925925629245249,0.3452555130426981,-0.5567258940683549},
{0.11233303868492017,0.34546278157981475,-0.5624134628825105},
{0.11208611877548552,0.30583443909929703,0.21943069440767454},
{0.12867100615557514,0.3127808388548203,0.23181574047335723},
{0.12246216197705745,0.31564314726159215,0.2718087554235267},
{0.131635246625528,0.3204766094952621,0.2939276126149038},
{0.12994405551832952,0.3247443387653043,0.31844257419913236},
{0.13520146702067196,0.32879638860107147,0.34557893206438256},
{0.13742614931905778,0.32945744506582725,0.3603158251831072},
{0.1289563758805909,0.32438967926846013,0.400288213409293},
{0.1361158516974592,0.32484166486099386,0.4306681736858273},
{0.12479678671687036,0.31221130096152566,0.4400327063743786},
{0.12690712086579373,0.3190137141680761,0.4690164577226254},
{0.13039483955412629,0.3092086106759918,0.48150804181898066},
{0.1292966166965921,0.3000555519731364,0.4867310086948651},
{0.12868081886892654,0.3002443966402871,0.5149005050944002},
{0.1206436058557467,0.28744120883016033,0.5153763215622159},
{0.12406043269660169,0.2895521437574521,0.5326907541410651},
{0.13091130869154075,0.27752155692915736,0.5529540072117435},
{0.11399078646294138,0.25104765734485596,0.5588204077202423},
{0.11565334046791019,0.23533189600446336,0.5862729752667555},
{0.11732851081861659,0.21876282912140968,0.6163847881315031},
{0.12480900254369559,0.2050294361374597,0.6441575705484025},
{0.1369669543861026,0.20674545941722094,0.6491169959799916},
{0.1431103137224588,0.1875359716048112,0.6538455222586382},
{0.1273723235824334,0.18555640688075467,0.6613762791072112},
{0.12010390662141869,0.1753696088652458,0.6712620871601246},
{0.12265541235224356,0.16351444932053968,0.6760727198157932},
{0.12468263882686406,0.14655367494125388,0.6793417551780085},
{0.1199753400505695,0.1427815878251863,0.678151813489557},
{0.11692578905229614,0.13110866438557797,0.6910176825094592},
{0.11278061856941853,0.12666971328052623,0.6849610355176166},
{0.11609411153089942,0.1080624056527637,0.6900348090986682},
{0.10695607228725537,0.08722020249435165,0.6890431242718065},
{0.1019273570838378,0.07161878930342153,0.6881133196168956},
{0.11432101430613502,0.27015681516973383,-0.5533961800909258},
{0.11040193674925232,0.2749514270689105,-0.5265427888372175},
{0.13010406282379447,0.2824010788377422,-0.5188488205318811},
{0.1289677906695915,0.28790901491973,-0.5131928927117974},
{0.1633261053020293,0.29211286142326,-0.5123614154498568},
{0.20155903989208412,0.2905514384436476,-0.500488232554097},
{0.17308454834083034,0.30407395822027017,-0.5009296043954548},
{0.18410542699120977,0.3087712440237571,-0.5002723528603659},
{0.16319473509879398,0.3124750426652771,-0.5131826794795337},
{0.17572096408106339,0.3090558127109483,-0.5320977858914009},
{0.10024297479814848,0.14859892476692801,0.8972086234925969},
{0.10942286826812818,0.1335624435018009,0.892055346907453},
{0.10128993123490794,0.05096743340672175,-0.08608633345362253},
{0.10558269293696913,0.025669657608397442,-0.10767430282674231},
{0.11301251901964184,0.04282888910872927,-0.10045695202704624},
{0.11548191837344461,0.07166965520528398,-0.09330068036147633},
{0.11413136860115965,0.08746271669575101,-0.08373048121145757},
{0.11715528638904563,0.09625450733970933,-0.07071161396705573},
{0.11198398645284831,0.10447996424167148,-0.05795368479401914},
{0.0957581642776381,-0.24538692329782463,-0.39509528545183137},
{0.10211880512391852,-0.21196341980670153,-0.37619479798026323},
{0.1217690639993175,-0.2768615017616824,-0.42892751849295946},
{0.09776916973631035,-0.2798211362641438,-0.405757899935156},
{0.1093135266050695,-0.2974453702216592,-0.41462258502115334},
{0.11850703771806752,-0.3217090061884177,-0.40974826985842855},
{0.11707498234712893,-0.33136311405056385,-0.39314756198130296},
{0.1369995966774553,-0.3462714292637541,-0.3891994468032783},
{0.12341619802616267,-0.3419670525132361,-0.35902375117201846},
{0.12824665636799035,-0.3415613268550734,-0.33632113766596},
{0.14102701460011588,-0.3358593393600749,-0.31198240440314473},
{0.14778717306141836,-0.3219152734282536,-0.28638063475038256},
{0.1327356723370799,-0.3013432202761898,-0.2745467027080285},
{0.14259404484450053,-0.2837780628582391,-0.2517671895708079},
{0.1419708374169574,-0.26714531346812925,-0.23903769724054483},
{0.12631154924319948,-0.24431153001829167,-0.23204303495608908},
{0.11954057677126484,-0.21365040546532083,-0.21997780324188013},
{0.14800265223623724,0.27754498728552707,-0.5508348616467494},
{0.13017094948214905,0.27849101295638623,-0.5287622643897433},
{0.14558592111940227,0.05916865891448962,0.7419178287389141},
{0.14598603951279276,0.0241949469732986,0.7392279437238886},
{0.1394535760531344,-0.019841106137111233,0.728970053601446},
{0.12786015561761818,-0.05095501732044035,0.7188335207094311},
{0.13218535935157588,-0.02067578755035024,0.7076730612181141},
{0.13349225256241984,-0.021074504127547647,0.6982039930934518},
{0.14231308082752012,-0.035978013113790216,0.6829650495181556},
{0.10100356021261145,0.0538711955209169,0.8854153441198416},
{0.10411739449630941,-0.1491498385308005,-0.31983437741938453},
{0.10556026387788016,-0.14367354344288458,-0.3062724065299001},
{0.121137445674616,-0.12587228012613141,-0.3134579160760681},
{0.13066298696591302,-0.12065031454752775,-0.32961745237129225},
{0.10661483017397337,-0.15742616133462511,-0.3364675273284067},
{0.10088740972804364,-0.17220991516608916,-0.3373791083728078},
{0.12110440286435102,-0.14923574983748944,-0.3478356558757526},
{0.10788046993685017,-0.6551592242909913,0.23390805127122696},
{0.13544177836805363,-0.6414901145924659,0.2304649904416161},
{0.12769213793390716,-0.6907100839848106,0.7083503386988181},
{0.1633301104911523,-0.6872624171877084,0.6752037940355524},
{0.16868184419734206,-0.6903077627374025,0.6578487087871044},
{0.1619731524162705,-0.6930322926383421,0.6511211926171547},
{0.16122898827721194,-0.6892341717929749,0.6176169845652025},
{0.17861951944939863,-0.6798638315801953,0.5976935717916131},
{0.19547135268453805,-0.6651351490991729,0.569812649268392},
{0.17444851549667748,-0.666071962835049,0.5604795573144565},
{0.15988544758589227,-0.6574201535509404,0.5422575488803293},
{0.19398823115228087,-0.6268992106172757,0.49835206493533013},
{0.18217973206085802,-0.6304405988398569,0.4863272856312638},
{0.14315176742988214,-0.6530204532992945,0.5128931043059387},
{0.13956852498096534,-0.6631185363757283,0.4987848256200733},
{0.12568293481034026,-0.6783242368813034,0.4926701033859468},
{0.15100854667306962,-0.018730667452751773,0.2788735085176354},
{0.1611594982459274,-0.044512470356593996,0.238582908015625},
{0.15116675164342921,-0.04879001233998768,0.23519591983373656},
{0.154223511982124,-0.05060676612619309,0.23562587688609357},
{0.15377152638959032,-0.05281943285720979,0.2343890744849026},
{0.1515240145132033,-0.05413513748412442,0.2289233931481627},
{0.15435107725569244,-0.05159284368828253,0.233905447898297},
{0.2012766740589107,-0.040650867263626746,0.23139960132347467},
{0.1852691346909055,-0.06508892921669314,0.22027198438296655},
{0.18349263305538654,-0.08957645525542893,0.20165506430130875},
{0.163301873907835,-0.11554209634001811,0.18991905913301269},
{0.1069488629468339,-0.06538010646593725,-0.24910534087964364},
{0.11502672862961251,-0.0708830360615213,-0.2507845164194731},
{0.12086349073860092,-0.08131635346755256,-0.25888461090188447},
{0.12380950759804402,-0.08733475090327027,-0.2727583857645966},
{0.13391940598239077,-0.07987288330761334,-0.285176074121632},
{0.1338937727720034,-0.08970482156682197,-0.30185688578121816},
{0.12238466156752688,-0.11246671187190123,-0.3024620698577076},
{0.10535880286499187,-0.0888959736234265,-0.1950547128860151},
{0.10963414199436787,-0.06708231184322407,-0.18987360023646635},
{0.10510887906371492,-0.0563570161501241,-0.18604043398627262},
{0.11172264786257072,-0.044306203116758064,-0.17644620370151567},
{0.11856451218198295,-0.020588874946380526,-0.16451995204987582},
{0.11598557090566537,-0.008595135858017638,-0.15794343150986417},
{0.11053771266052295,-0.009569798631106465,-0.15422381237130825},
{0.10650448721363397,-0.23444775050555497,-0.4020376800182316},
{0.12235682550312181,-0.19977482826750334,-0.3916668435625196},
{0.1331389948817688,-0.2067150199798859,-0.40742706250217775},
{0.12445794771706221,-0.2509078762444623,-0.42618556601933466},
{0.1469404760808103,-0.27444176675300513,-0.4614544603988927},
{0.12923814093539587,-0.30495089437875705,-0.4324294556026788},
{0.10432626510907529,-0.6547198550441953,-0.1023459994769223},
{0.12001979764983513,-0.648760333888586,-0.10334729675767924},
{0.14585847423922432,-0.6503229584249353,-0.12338886261039803},
{0.14886476919496897,-0.6661903161736344,-0.14558702254641112},
{0.1633701623823826,-0.6735126029283539,-0.16944733596848077},
{0.19428781929868336,-0.651637461495113,-0.18289055300046742},
{0.17939792795545909,-0.677942742617335,-0.20820695292821378},
{0.1856754611274367,-0.6804041315928916,-0.2334248252035337},
{0.18008261503604067,-0.6888715019178847,-0.2665891929583969},
{0.1651881177253249,-0.6990621048630605,-0.2633241627853046},
{0.17203558930950938,-0.6941727702411243,-0.29692870082478856},
{0.17166711191019082,-0.6891977245719554,-0.3460593544996898},
{0.176921519520691,-0.6806662712209938,-0.3931009015280197},
{0.16721694627559464,-0.6805012574291252,-0.4292271066393619},
{0.1700758502716119,-0.6734499217185784,-0.4550631798558212},
{0.15386284470159536,-0.6846614473712141,-0.4632327643695171},
{0.16348451053184504,-0.6718612634529296,-0.47906307411882837},
{0.14625378640566716,-0.6743268578770655,-0.51279157276167},
{0.12756817733054945,0.1685239396161667,-0.45888773494940044},
{0.12776883730561314,0.1514822604165957,-0.46935069075494207},
{0.14854855951370594,0.15429430369987354,-0.45922437109519093},
{0.1565981886131672,0.16096154177352176,-0.45052309772541305},
{0.14376556266298615,0.17316355069628206,-0.45339001209967633},
{0.11432782312764415,0.038420577700468715,-0.12121644803006774},
{0.12379849332795569,0.06071205854304836,-0.10860731163295166},
{0.13251738952987488,0.08279627084851134,-0.10764826909744264},
{0.1263880483554493,0.10569393706486122,-0.09364592766388131},
{0.12596850479481214,0.11064975782623968,-0.08457016911110034},
{0.12916825038519905,0.11596424327358525,-0.07288462932575444},
{0.12131888074188918,0.13703634428765907,-0.050624989736702874},
{0.12037766129797765,0.15441245677900284,-0.0342079197808681},
{0.13225044367482508,0.1722749994893384,-0.023038048095112038},
{0.14286319355356797,0.1991522216183287,-0.014839826479186444},
{0.13175780541269266,0.20989333780846461,0.0018233623482583983},
{0.13255924375621053,0.22323362147998946,0.01399493183368371},
{0.14333500483226067,0.2451970773333931,0.019968270891767365},
{0.1422584099959908,0.23950530307065832,0.03288080036495283},
{0.13441504813636546,0.2387979866715316,0.04612395820024423},
{0.1321857598704882,0.2603505101209126,0.06565366088304006},
{0.13274588556934364,0.259081065428369,0.08325266214908034},
{0.12958458979453777,0.26268954056876087,0.09806144841256331},
{0.12306073749149396,0.27201462214445027,0.11549042940033105},
{0.1181087216597824,0.27829956491630553,0.13699969680718335},
{0.12779366947817591,0.2975651253764377,0.1753523865520168},
{0.13617673057212923,0.3136511664512542,0.21340108244241238},
{0.14091807345596954,0.32296383194066225,0.2316589373191907},
{0.13287505291856128,0.3232179611905184,0.2579415891228675},
{0.13827564993205196,0.3249732353236853,0.2794306303246486},
{0.14261607338467716,0.33277193932458893,0.29675988210325294},
{0.14595279644307163,0.34561117383682294,0.3104932750872029},
{0.14017931632222708,0.347644408095128,0.33415853579898114},
{0.14356169853662404,0.3533886503353745,0.34675946155839504},
{0.14767502776597358,0.347681456094516,0.3586915207342633},
{0.1469959479501642,0.3461460668442033,0.3712131437490412},
{0.1355036585400044,0.33597248595280044,0.38546080301638797},
{0.1349869891431338,0.33986893419113795,0.414382674192684},
{0.14329515320048652,0.3396582612432667,0.4357739887798632},
{0.14377617641416218,0.3359923116389594,0.4548130557950881},
{0.13397107292207783,0.33074090792030153,0.46767892481499024},
{0.13419135832384435,0.3317153704339341,0.4853315956152791},
{0.13676749596777582,0.3227479522469311,0.49518896682541896},
{0.13837898381142608,0.31138342836979593,0.5220113178634238},
{0.13031073058254275,0.30218651284604336,0.5424229631911103},
{0.10432566433070684,-0.021263749313610705,-0.23456410124957897},
{0.11261580503700594,-0.039375815306310846,-0.23656188958414523},
{0.11403864847296155,-0.05188562301317586,-0.23652964781170482},
{0.11137239407376194,0.0938890426436491,0.7007220554950994},
{0.11652707247509873,0.10659650643373554,0.7061344678165029},
{0.12592865316303803,0.10898419992942858,0.7109815476931912},
{0.12696219221623534,0.09780571708705797,0.7203578956896555},
{0.13170934262430403,0.07947937347627584,0.7284097276431344},
{0.1437443351606341,0.08824252701800453,0.7414219863254832},
{0.1358336861237419,0.029749944027482014,0.7271370787992922},
{0.13871862384905884,0.0100640389688881,0.7160809544846302},
{0.10584042685703597,-0.1086441593728835,-0.20367147676529707},
{0.11625451935527668,-0.10358620628886786,-0.18594771385807451},
{0.12074794103240158,-0.06101304850564391,-0.17942846752252217},
{0.11573564710438843,-0.05218240752719222,-0.18189866791414958},
{0.12296741658492742,-0.039872258498110144,-0.16649030483894933},
{0.1292323334111675,-0.01767009337297402,-0.1573582733789898},
{0.12263718874173378,-0.004754960526858595,-0.1512814001820759},
{0.11087935529271722,-0.1195869368353639,-0.20405517388328315},
{0.11957622295445978,-0.12495389026022112,-0.18967794674780644},
{0.12406143399388246,-0.126170666715797,-0.1765417274620999},
{0.13628006445150334,-0.09712403389831864,-0.15841964849659218},
{0.12766290005330905,-0.08226217887895557,-0.17234168588823678},
{0.1298991974001516,-0.06673826609755598,-0.16046990480867013},
{0.13279975536304833,-0.047393202633331744,-0.1558258880205194},
{0.13902301822240892,-0.02630608216004656,-0.1464827830937763},
{0.1310751209266726,-0.0068524780705882474,-0.14375564981990668},
{0.12894616264832715,0.019673088453400232,-0.137573239889601},
{0.126739503700995,0.0450397535046406,-0.13307541250444074},
{0.11452888362162016,0.027160589259444545,-0.1305819820158998},
{0.12386017324045033,0.055324478394207545,-0.12745493060809585},
{0.12944420791577566,0.06652879470642165,-0.12390212759651403},
{0.13578322074079174,0.07016911110034162,-0.12203651050300769},
{0.1404472634745576,0.07267435689679547,-0.1161312596600155},
{0.1428059193491087,0.0795098129136109,-0.10572017105361707},
{0.13856322251108535,0.10898099577813015,-0.0993859644555486},
{0.1315529399890498,0.11078813711044028,-0.09656671183184935},
{0.13741793868135554,0.12200186561709349,-0.09320695893599748},
{0.1398120404796454,0.12826618166496512,-0.08267831802883817},
{0.13747441184799022,0.13805566491946966,-0.06835856535727688},
{0.1329577600739518,0.17100134934821554,-0.04804284430908686},
{0.1375689343112937,0.18289856337871344,-0.03306103387548909},
{0.14596361045370382,0.1933673267084835,-0.02842202357374215},
{0.1539850029698477,0.1934944914631396,-0.028412811638759188},
{0.15600381854730988,0.20694932354358306,-0.016439699274379896},
{0.15104619545082607,0.21960792402636853,-0.011652697234537074},
{0.1431103137224588,0.22035369024107632,-0.0043248032150454245},
{0.1439964618159287,0.2432070991176168,0.009225152107069907},
{0.15512688238882294,0.2660689188913155,0.030720401351991628},
{0.14442041108460119,0.26830761935163194,0.05051144262506502},
{0.1445529828445734,0.2899562673399656,0.06717923742000133},
{0.1403431285573589,0.27269390221971584,0.07961254601461652},
{0.15035009358124385,0.28661413727625507,0.09101031296147286},
{0.13628467041899484,0.2808066130478648,0.10407343754568417},
{0.13659747568950328,0.30241320655040665,0.12020974374399471},
{0.1326195218525121,0.29214970916319183,0.1336641753055258},
{0.13219997829187494,0.289645865182931,0.149788065417555},
{0.14195541743883375,0.30643982343524273,0.16447409263441712},
{0.13495374607341268,0.3118606466538047,0.19339616407016927},
{0.145190008174591,0.3306788274888946,0.20995001123455545},
{0.15431242718065522,0.3403723864639026,0.22540903995216202},
{0.15241817298491922,0.3524484321887437,0.2516698634751183},
{0.1425772230501838,0.3393378461134245,0.25203974269062995},
{0.14570427445798775,0.3536189487099486,0.2687992563164836},
{0.14653695327666524,0.34369649317655954,0.27745467027080284},
{0.1563752998384707,0.3505507735822531,0.29635776111530093},
{0.15048186430339147,0.3574100604743506,0.32480221374813206},
{0.15089640137762483,0.3642010588919003,0.34346439246688004},
{0.15247484641101008,0.3607463830138327,0.3590782217440916},
{0.16447038783447834,0.357228224888165,0.36457534381544726},
{0.16156902883375698,0.3504480404812475,0.37482682563529307},
{0.14892004080486676,0.35061806075952,0.38257366243705343},
{0.14077388664754054,0.3519463817321722,0.40852007861385203},
{0.14276166200929924,0.3528050942801493,0.4287204502152989},
{0.15090080708566017,0.3502882334352386,0.4438951105051705},
{0.1586156023744363,0.34450193670920043,0.4499257237677134},
{0.15220029069662652,0.3387316607396543,0.46612110650558863},
{0.14322386083409663,0.3374926554844456,0.4895907137287069},
{0.1424058009557182,0.33124616252817146,0.5020192160963745},
{0.14654035768741983,0.3196965989135524,0.5136608990608231},
{0.14909947327757841,0.3132991103273401,0.5284572692380247},
{0.14309449322542284,0.3094375072343728,0.5498612001709414},
{0.13626003850588822,0.3064165933383291,0.5519238725693008},
{0.13429649453832382,0.2938787493076029,0.5562178358280988},
{0.14576535359211393,0.2875789873359925,0.568636525482415},
{0.14176657277168297,0.27583817594074883,0.5751389500236506},
{0.13025826260503107,0.26962011982724815,0.5826823232179611},
{0.11953777313887873,0.25577798595860796,0.5816051276033228},
{0.12744521802447248,0.24873065543718442,0.6073821242802174},
{0.1298086801259712,0.2352299639412823,0.6145668327885607},
{0.12684964640187826,0.21978275053158872,0.6393791796651741},
{0.13197749003609072,0.21285217127310144,0.6487967811096055},
{0.14062349179597083,0.22048045447682016,0.641000680481632},
{0.15033647593822555,0.2142031215642987,0.639045547411226},
{0.14729293272363672,0.1988456243909609,0.6395600139540788},
{0.15870031212438834,0.18090838490348093,0.6403558450328245},
{0.1499605889390294,0.16992595606868258,0.6595330910727939},
{0.13484961115621397,0.17465067741766233,0.6722109164633698},
{0.12676113172225936,0.1724410145784879,0.6768305015978701},
{0.13216373133031153,0.16146659612193556,0.6762385346454867},
{0.13215391861696013,0.15095858193875983,0.6759840048767183},
{0.14416648209420124,0.13256374959397396,0.6867673758121021},
{0.12358401545041756,0.12281031304157666,0.7012048810438803},
{0.11083109276378475,-0.20387273751872925,-0.22704976567641033},
{0.11013078544562332,-0.18189706583850035,-0.21350181294885653},
{0.12840886652747296,-0.17596457970947157,-0.19573439348019292},
{0.12200877456833072,-0.1545922897706268,-0.19891251104931548},
{0.12852501701204078,-0.14408227299288956,-0.18649422191391166},
{0.11773323517949853,-0.13351217837830692,-0.20195965893411505},
{0.12653563957463287,-0.29606057608237224,0.11965342297480613},
{0.14728251923191685,-0.31875217531834243,0.106577281525945},
{0.1542815872244079,-0.3210048939405894,0.1028316286580894},
{0.15497288286704253,-0.32153618227775904,0.10217577893919359},
{0.16595991766933238,-0.31183341136776804,0.1029750144286938},
{0.1851263496986696,-0.2902562560052804,0.10218018464722894},
{0.20431340845199036,-0.294467512108688,0.08934535584303022},
{0.19740085254455672,-0.34566644544672076,0.06989655798051954},
{0.19260003260223946,-0.3788794762494287,0.05665860689108807},
{0.18759394671736698,-0.41518351175783347,0.03831584200490154},
{0.17025568326323584,-0.4549173909717429,0.02339631226216685},
{0.16289334461728613,-0.4834101061335065,0.00865000694900312},
{0.17234719302328094,-0.5115655843711112,-0.01939152365805138},
{0.15974366389093708,-0.5527651625445927,-0.04117654833602416},
{0.1492755013395355,-0.6022989385047267,-0.07823736432922494},
{0.14664569416135542,-0.3207243304425213,-0.4441474374199212},
{0.14800064964167575,-0.3371882611110955,-0.42928337954654044},
{0.16425030269216795,-0.35356748202971766,-0.4159971659281765},
{0.16552415309274696,-0.3599964113505457,-0.3842145884207579},
{0.1554887512260885,-0.3543282677036368,-0.35476222994511686},
{0.1772683688987452,-0.36073917367341124,-0.3244227220787252},
{0.16816737765448914,-0.3496293798245006,-0.312144214043715},
{0.1871906241726781,-0.3411157495651365,-0.28555156060191583},
{0.17608543629125895,-0.32034103384344753,-0.26785703557529134},
{0.16408328630573768,-0.30320683477513466,-0.25956228890150074},
{0.17240366618991565,-0.2790020750884846,-0.23226912788208404},
{0.15740703655656266,-0.2498014427492259,-0.22378493576277422},
{0.14223838405037567,-0.22928726457998982,-0.21608295707919178},
{0.14422615941213435,-0.19217598320383888,-0.19363587463918253},
{0.11847619776182021,0.16502060069025426,-0.6113308402366106},
{0.13890666747838498,0.15859727863419848,-0.5858682509058737},
{0.14281212739224938,0.14268366095112825,-0.5985965416793998},
{0.16439288742494776,0.14023448780239678,-0.5673893095895041},
{0.1779234175798164,0.14058153743990712,-0.5576414803018791},
{0.18832649580796879,0.14532488291830897,-0.5459415218356902},
{0.19138766185469894,0.15371415205540298,-0.5455418039612121},
{0.19455516567264547,0.16198847226466612,-0.5271311511193902},
{0.20287214114606883,0.16722926223214798,-0.513971501477314},
{0.21054668428415851,0.16535142931181634,-0.4861428466721484},
{0.2278517046685686,0.17569402918421104,-0.46461335306022483},
{0.22794983180208275,0.19242410467001045,-0.4652365604877679},
{0.2323951912097313,0.18475757191016678,-0.4452783025688081},
{0.23567884551224563,0.20420156354572983,-0.447516402250756},
{0.22913616882032362,0.22171885895366036,-0.4621245285391753},
{0.2418804803503419,0.2213730108728869,-0.4331567979474206},
{0.23877685929890766,0.24507331698949156,-0.43649412178418356},
{0.24314291596192023,0.2818151196690432,-0.4296342341137177},
{0.240559168458655,0.2876016166545376,-0.4458816843101922},
{0.22994321442861365,0.2650966592317006,-0.4687184716518721},
{0.22492811686821446,0.2772081508802805,-0.4876736299549696},
{0.22201494255958018,0.28939634190056635,-0.4837735770464213},
{0.1329347302364944,-0.010962002370270918,0.30487119111520883},
{0.16266805272911583,-0.012896308457237186,0.290438291850922},
{0.1816824878312341,-0.020786330770145803,0.26536020067599575},
{0.2020162322304778,-0.021447787753813834,0.2532853565078916},
{0.2315709232882122,-0.03398523126562775,0.2177921715374439},
{0.21558921739005055,-0.049352941671229236,0.2180228704309303},
{0.21345645418203824,-0.08325005877615037,0.1945528626888997},
{0.20383058290320935,-0.10656546621803206,0.18443855859651762},
{0.18467997137090814,-0.12468193791876754,0.1792474329741613},
{0.15035610136492839,-0.13458396698762914,0.17999359970778137},
{0.14915734826040616,-0.15328459552195822,0.1729026126249168},
{0.14174394345313787,-0.18620284440521137,0.16065955051364547},
{0.1249165418716489,-0.1681939120324292,0.1649579194804789},
{0.12228032639087201,-0.18373104193793477,0.1598024400413175},
{0.14676825294852008,-0.20781504517252553,0.15537750709819642},
{0.14120104006751144,-0.22234026404609808,0.14659332631357183},
{0.1179310915221761,-0.23700145909039752,0.14011313057196903},
{0.13597406800250403,-0.2528680158012721,0.13537939754746248},
{0.11345709501229792,-0.02608259260698161,-0.22310285205512265},
{0.11938117024416832,-0.03845902751604978,-0.22389427742583293},
{0.12183394806311056,-0.17378735890219366,-0.3706131664184117},
{0.142937289552344,-0.15100043616509548,-0.37263438510934765},
{0.11502332421885794,0.34102062632346464,-0.5595743845726523},
{0.15522460900342483,0.18698625939767563,-0.45976066591876436},
{0.1443635373990542,0.19580548558712668,-0.4716915235378957},
{0.15403666990953477,0.19664597452459406,-0.4821799122943686},
{0.15398740608332154,0.18873051926075424,-0.5152799967638072},
{0.14728051663735534,0.18351456146583514,-0.5434148482774283},
{0.13607800266024658,0.1823001881237331,-0.5631802563401143},
{0.12171959991364811,0.30606674006843265,-0.642744139306886},
{0.13148965800090598,0.3094999881846921,-0.6653850729004497},
{0.14390894843359053,0.3233134849511026,-0.669236062242241},
{0.14423056512016968,0.3356416573312383,-0.6948576575811621},
{0.15245041475735963,0.34214227953736853,-0.688162783702565},
{0.13126296429654258,0.3615902763620546,-0.7394960911356754},
{0.13552088085323344,0.36235526748455293,-0.72200142504629},
{0.11761848651112379,0.11799787805080263,0.7002918981832862},
{0.13408602184990873,0.1058863864022227,0.7066967963693761},
{0.13050137758479885,0.09035786765333163,0.7133982788100263},
{0.1321943710271027,0.06793882153718356,0.7167672436408611},
{0.13102285320861706,0.046154197378123096,0.7175915115623801},
{0.1358803465770252,0.03130175455319913,0.7116177719853841},
{0.15093284859864436,0.028265220419575604,0.6895824229872222},
{0.14278549288458126,-0.0008098492406762073,0.6959216360716944},
{0.15516453116657938,-0.003000086912603974,0.6802086783636879},
{0.1564247639241401,-0.04776528470286102,0.672052310974098},
{0.14371109209091298,-0.06995303114715425,0.672257376657197},
{0.16193290026558407,-0.0823382774722931,0.6614409629115481},
{0.19146616356151028,-0.09150976004511445,0.647247173437906},
{0.19633787535130512,-0.11568207769986794,0.6362377095765273},
{0.21688149166059548,-0.12674220720365303,0.6226426958767779},
{0.2239564579869679,-0.14898101980926487,0.6091652344777894},
{0.21624286425492867,-0.17153944650689432,0.604332573281944},
{0.2133573257512433,-0.18987119712299252,0.5989111492850137},
{0.2136024433255726,-0.21497111657863927,0.5836964371039117},
{0.21365511156254044,-0.25241282605744,0.5621056640984059},
{0.11985338204177332,-0.04868948209299969,-0.22788845227877236},
{0.12878235041319533,-0.033088068902069515,-0.21832786558264886},
{0.12869323495520793,-0.046030437034221536,-0.2274841284368027},
{0.11937295960646613,-0.0549892440646101,-0.23873991142924772},
{0.13123913342126056,-0.06301023606184172,-0.2576440035710266},
{0.13572674757415706,-0.06711835854533132,-0.26823432439068057},
{0.14821172310845931,-0.059117392493714845,-0.2884761496995507},
{0.1566901077035407,-0.07366484016692025,-0.31196057612242417},
{0.14046328423104973,-0.6621406694513411,0.253375873782072},
{0.16871889219673006,-0.64649559969897,0.25285219530423614},
{0.17675530417208535,-0.6106451518587481,0.22776809634562536},
{0.20291239329675523,-0.5721088241926239,0.22067290381418161},
{0.22280476585464123,-0.524899259480583,0.21667532455048757},
{0.21915023103933454,-0.48741689733218346,0.20641362949837805},
{0.21848617068273657,-0.4139397002756771,0.21047529178804056},
{0.19217247866335624,-0.3932615096118531,0.20168990944667908},
{0.1799206051360142,-0.3609718751614592,0.20576999560630752},
{0.14719901103870173,0.13345890936297067,-0.4699306421399565},
{0.16949549836768515,0.12344573629594503,-0.4633853620751045},
{0.1849931771603289,0.14697161642624182,-0.4397517423573982},
{0.1733456866716518,0.1648137326720499,-0.44494927628235137},
{0.16807265493172954,0.18003044744771327,-0.45501792121873097},
{0.16380652773733648,0.19163908760189702,-0.46654745888773497},
{0.16347289548338825,0.1931117956424343,-0.4834267276683671},
{0.17637981769180147,0.18097046533488786,-0.4862523885946632},
{0.1704196957578238,0.1689955506354032,-0.5184208660740856},
{0.16606124895414498,0.16178841306797087,-0.5322730129155333},
{0.16511942873186497,0.15632954055274012,-0.54427696523616},
{0.15304438430430464,0.16579680634229704,-0.5571456378884483},
{0.15927165235278826,0.14637564428473532,-0.5652154931929808},
{0.1711081877680723,0.1442248577256694,-0.5435486215941373},
{0.18253319000096524,0.1421439617168003,-0.5397076452251537},
{0.18250275056363022,0.1445362611799848,-0.5310432195953076},
{0.1889250713224053,0.15301384473724156,-0.5245632241131609},
{0.1981131754300872,0.15954410534288221,-0.49745830698252647},
{0.13111597385572746,-0.12792413851385856,-0.17012621552483398},
{0.14348219553253194,-0.11520826382661375,-0.15983768570560017},
{0.16931226096530663,-0.11199289799864705,-0.14518990804486293},
{0.15697427587181953,-0.08577673233441245,-0.13962129334766124},
{0.1487448137807343,-0.0641687370156775,-0.13666626481269134},
{0.1422253671857258,-0.052417512128713956,-0.14395891316790035},
{0.1407039960973437,-0.13490878782550672,-0.35331475459605466},
{0.16783374540054094,-0.11965742816392919,-0.3712469875971308},
{0.1649632263560669,-0.14059615638020617,-0.3940110807562277},
{0.14910007405594686,-0.16551964725498353,-0.3908780215647393},
{0.17367711607158232,-0.14681361171533838,-0.4131502774995284},
{0.16247520287284203,-0.17879805075455757,-0.4240864463999557},
{0.14400146830233249,-0.2193251576742828,-0.4329375138429349},
{0.14926428680999101,-0.24262874980825153,-0.45514568675175554},
{0.15771763897305346,-0.25540189869995567,-0.47991297525073484},
{0.16723496962664827,-0.27753076886414035,-0.49904836706436856},
{0.1549190130733378,-0.2959167897928556,-0.4728672468049605},
{0.17070586652066416,-0.3189958910764787,-0.4858722961468878},
{0.18430949137702804,-0.3445429898977114,-0.4724066500558123},
{0.17358139205154197,-0.3500264943260488,-0.44302638498438573},
{0.19029284340791927,-0.3683005702187754,-0.42076694565479034},
{0.19024277854388144,-0.37560643569809044,-0.3788570471903398},
{0.17748384807356407,-0.3656337150412074,-0.3511737807503401},
{0.20481966435714108,-0.3898170469660492,-0.3489052416310572},
{0.213182298986567,-0.3790919515324053,-0.3049907460105312},
{0.19499072998977474,-0.3591729444668512,-0.30190995453709824},
{0.21318029639200545,-0.35895966814604996,-0.27438048735942283},
{0.2088865333926635,-0.3403057000650042,-0.2620040524503547},
{0.19474040566958548,-0.321473901586896,-0.25224240526025515},
{0.20725662167904732,-0.3011868176409355,-0.2262313052791196},
{0.2179739069939013,-0.29150166956308593,-0.2079412086299009},
{0.19038736587122274,-0.2731452870338811,-0.21614243413766876},
{0.17447374818815256,-0.24288047594463383,-0.2091549811936345},
{0.1666494109768616,-0.20810081541645353,-0.19175063211897334},
{0.17790579474767507,-0.18933630411561217,-0.17687475893767965},
{0.15526986764051504,-0.16145397977619805,-0.1747285783461052},
{0.13756773275455678,-0.14255829853157748,-0.1730552103305042},
{0.1534927652266276,-0.5158933914779988,0.594288560258671},
{0.15951676992711755,-0.5266601408785222,0.6029099301054446},
{0.15503996978485324,-0.5542677092440966,0.6212536962889118},
{0.18431149397158958,-0.5384085621330996,0.5917979334025163},
{0.20481365657345654,-0.5396796089012924,0.5705704310504689},
{0.2200155521493647,-0.5471256559999135,0.5574165889326211},
{0.2127715668420005,-0.5684310592804036,0.5847846469886384},
{0.25724819075594335,-0.5604537238446131,0.5523159805844451},
{0.2430812360494256,-0.5819553813921315,0.5763282909337337},
{0.23550341822865703,-0.6073715105290414,0.5923720772633022},
{0.20577109703331634,-0.6479420737507514,0.6312898991933948},
{0.18699937639205352,-0.6720340873635882,0.6494846723414855},
{0.16892896436623286,-0.6774194646584114,0.6714212934277649},
{0.12967630862545512,0.5936547390799519,-0.2714246577866284},
{0.13441584917419006,0.6020566245627834,-0.28644291544124567},
{0.14427802661127756,0.5970693630667894,-0.267617124746822},
{0.14200388022722238,0.5923866962036014,-0.22862640837469023},
{0.162665649615642,0.6036989523626811,-0.1707910769192566},
{0.16505854985719495,0.6021393317181739,-0.14718569378486768},
{0.1641483706289869,0.5959889633008526,-0.1420796784313757},
{0.15897767147115802,0.5709244897689446,-0.1538311035777954},
{0.15817242819797328,0.5531718895000362,-0.17224676290602103},
{0.1368207649831121,0.5341596572519356,-0.22494864346246995},
{0.12960661833471443,0.5090447183370775,-0.25721705041051185},
{0.14395040214101387,0.5054330390453872,-0.2491049403607314},
{0.1502135166321486,0.49601303448748196,-0.2580649489478568},
{0.1404678901985412,0.4835332656990396,-0.25879569570335326},
{0.14201209086492458,0.45649163055654896,-0.2353489180582362},
{0.14586908799040035,0.4229377581594714,-0.20769108456916782},
{0.14332158744869852,0.40461722207291756,-0.20497716841940417},
{0.13165286945766935,0.3853991231038934,-0.20306649294826373},
{0.14216288623540657,0.3812785845341224,-0.1989655798051956},
{0.1523396712781079,0.36423790663183214,-0.18399278104712463},
{0.1608500973861735,0.3353002149585002,-0.17155226311208802},
{0.15966916737324877,0.312135002108732,-0.1657521484835753},
{0.16143825940889014,0.27417001467100777,-0.15720667697068322},
{0.17628509496904188,0.24579565284782964,-0.14268225913493524},
{0.18379742794764897,0.23744323145066745,-0.13765955171520222},
{0.1859365994582581,0.22257717098272523,-0.1371540968478761},
{0.18763359808968497,0.20915758456656441,-0.14034222738980623},
{0.18043827583016553,0.18969116387191243,-0.1469271588269762},
{0.1736797194445123,0.15270404335857538,-0.14362107546537295},
{0.16376086858133396,0.1554620165886923,-0.14829933662052555},
{0.1538354091561026,0.14099687555196513,-0.15508332595711002},
{0.16198296512962193,0.12118100210632897,-0.14885105142222263},
{0.1561994720359698,0.10905048580941466,-0.1613676679505968},
{0.15779814327442632,0.0795014020164525,-0.16078751630612623},
{0.14901356197088947,0.04569460192625564,-0.17632124180087722},
{0.14303882109661276,0.05524657746576463,-0.1812129795362872},
{0.1311199790448505,0.03722042277975346,-0.19214253987466162},
{0.12714262598622775,0.029809020567046658,-0.20138150988420597},
{0.14019693915436837,0.015206501543399639,-0.18924919125218634},
{0.13968287313042776,-0.004332813593291466,-0.19976081010557276},
{0.12929181046964444,-0.012714873389964035,-0.20989273703009617},
{0.14131999418446536,-0.011898015068322505,-0.2152963379354291},
{0.13940110807562275,-0.030467874177784734,-0.22199401544641237},
{0.13931019028253003,-0.03839494449008134,-0.2283554573305174},
{0.13598147760238163,-0.044404330250272246,-0.24445912123747526},
{0.14331237551371556,-0.042824283141237776,-0.2646961403193978},
{0.16231279245390326,-0.004694682430557028,-0.2539782542261754},
{0.16403702637136672,-0.0363360770213889,-0.28573680059885587},
{0.18124391962226258,-0.04985819627909919,-0.31498369287248557},
{0.16972099051531161,-0.08221291505274232,-0.33394786285110983},
{0.1617116135665368,-0.10604278903747694,-0.34811261470360993},
{0.1796376385244723,-0.0972325745235527,-0.36193432210772275},
{0.1837613812455417,-0.11043387813250846,-0.39125871479088303},
{0.1513846339317219,0.35946271989990225,-0.6668932268647259},
{0.14352885598581522,0.30574632493859044,-0.6365294876041399},
{0.16165614169718284,0.31564294700213597,-0.621535661603173},
{0.17836579071845482,0.32482904851525635,-0.5960041830195201},
{0.17772956642626186,0.333080338887062,-0.6263068431459798},
{0.1839534300639909,0.34339770606798165,-0.6242824203037455},
{0.15752198548439356,0.34970587893675037,-0.6744215805998252},
{0.17293014830013764,0.34990633865235793,-0.6395169581710063},
{0.15828437323396188,0.3597883417756045,-0.6400770838698617},
{0.13863811954768596,0.0582578789079131,-0.12743931037051603},
{0.14565861530198523,0.05449440294846002,-0.12021775412224078},
{0.15135940124024685,0.0387536091760485,-0.10274211268118975},
{0.1532364331227538,0.07986887811849032,-0.09418742923331469},
{0.14471959871209136,0.10080039699434587,-0.09899926344572027},
{0.14380200988400568,0.12481971642459969,-0.08926425076328892},
{0.15709883725354568,-0.03943108691620863,-0.5740078846153076},
{0.17252802731218564,0.013692740314351266,-0.5191718390346532},
{0.1761869678355277,0.05693296234601549,-0.490072337720751},
{0.175315638941813,0.09442393565102947,-0.47195526524164705},
{0.15514029977238508,0.10528761062833007,-0.48214987337594584},
{0.13459928683602473,-0.6888919283824122,0.46143203133980376},
{0.16440149858156225,-0.6826738722689116,0.412923583795165},
{0.18236136738758735,-0.6725193160258431,0.39249531693261785},
{0.18924588697115982,-0.6732234282736712,0.3503831564174544},
{0.20045781314270766,-0.6579930958549897,0.3414293558734696},
{0.21462877303834846,-0.6365595265225625,0.34162701195669104},
{0.21555697561761014,-0.6355804580414384,0.30258703175834606},
{0.2111578761443326,-0.6234491407066995,0.27377069731544185},
{0.1963520937726919,-0.6227642533666617,0.2543477329227747},
{0.1264515306030493,0.26187548587950543,0.6012343592358258},
{0.13722288597106408,0.2680675082637064,0.5994953061186072},
{0.1350304454451187,0.2603781459258615,0.612011321868613},
{0.13897155154217802,0.2465588416352226,0.6172471053496911},
{0.13756873405183753,0.2296567432765891,0.628803077266907},
{0.13898096373661714,-0.15398850751033036,-0.6633205981669851},
{0.15138303185607271,-0.17792932523377286,-0.6556903123687049},
{0.15154143708588846,-0.12714833338072806,-0.6321462086278983},
{0.1386231000884746,-0.11439260706170915,-0.6464130928030356},
{0.14787668903831802,-0.08795495443897113,-0.6152579281717392},
{0.1398743211705085,-0.0624400973901787,-0.610183353552863},
{0.16196213814618218,-0.091026333717965,-0.5913199140806829},
{0.16241552555490893,-0.05679498358072718,-0.5700022949733675},
{0.17703406533504806,-0.04919774059271191,-0.5336013338881855},
{0.18280614363969958,-0.004057456841083302,-0.5100289935640616},
{0.18984486300450862,0.03389171009960505,-0.47794082012655587},
{0.1872821427441393,0.0722992709354239,-0.4653276785403168},
{0.19865788115081898,0.09862537904108563,-0.4399892500723938},
{0.18730337024649132,0.12422875076949694,-0.44522443277510343},
{0.15848222957663946,-0.22376911526573828,-0.657711731319097},
{0.1639913672153642,-0.20220557754626892,-0.6296888248414646},
{0.15865224985491203,-0.15407061388735244,-0.6282870086484048},
{0.16193410182232099,-0.1357953364378889,-0.6035727889053056},
{0.13924049999178933,-0.6740186585740484,0.47887402919222144},
{0.15805267304319476,-0.6684206057367926,0.4572301874308354},
{0.17202297296377184,-0.6651495677800157,0.4318366876124707},
{0.18621776373469465,-0.6533811205798232,0.42018819582651273},
{0.1958678664077178,-0.6551472087236223,0.38516662187530154},
{0.21562926928128082,-0.6308068733851578,0.3727533392263016},
{0.22589857419272408,-0.6229314700125482,0.3347729318104536},
{0.23300458073480002,-0.6110745081327368,0.3129640762571988},
{0.22627846638104324,-0.6169290933333227,0.29077052228867717},
{0.23715836237429208,-0.5862327231160691,0.2717620949702434},
{0.22275089606093657,-0.5901622141646717,0.2529791597994361},
{0.20165896936070368,-0.5925352887200657,0.23200478539996416},
{0.1409507157473222,0.6432716227143886,-0.293474024946721},
{0.14809156743476845,0.6263925541932127,-0.29650675415067757},
{0.15148796781109605,0.6048294169926556,-0.2906251339235113},
{0.144881808871574,0.5169789979897956,-0.23186840871032513},
{0.16501028732826248,0.536007050734932,-0.18578270006620576},
{0.15981695885188849,0.5170492890589046,-0.22195075940388367},
{0.14042823882622324,0.3036738398268797,-0.6034874783769851},
{0.15650727082007448,0.30590212679547624,-0.6128291814875353},
{0.17614431257136745,0.3137148489583103,-0.5860881357887279},
{0.19813300111624618,0.33246994806471264,-0.5522076402186673},
{0.19238375238959593,0.33346944301036424,-0.5858702535004352},
{0.19723183356356494,0.33911655941437724,-0.5933976059382536},
{0.21196412071479806,0.35231005290454304,-0.5692927757202231},
{0.20917370545278458,0.3579583708652931,-0.5725357773531388},
{0.13682176628039286,0.29387995086433977,0.1445068230399305},
{0.14798723225811358,0.3159529486402583,0.14915003879025662},
{0.13507430226601583,0.12256459468887888,0.6990446822903754},
{0.15118918070251816,0.12250031140345428,0.6857350383156418},
{0.1544361875245568,0.11545678581169762,0.6783869180910788},
{0.14258122823930683,0.09275957931095528,0.6980271639936702},
{0.14168586821085397,0.0619931182840488,0.707675664591044},
{0.1445093262831324,0.0524803935979455,0.6985414302770669},
{0.15721278488409582,0.06409283868179613,0.680010421502098},
{0.1698393438538971,0.07685056759537658,0.6651619838662971},
{0.18514457330917936,0.011320266537325763,0.6636652446910216},
{0.1423823705993485,-0.22764393548281148,0.2672128009048523},
{0.1443733501124056,-0.18270471222515888,0.29703003210960116},
{0.16480041541821583,-0.2171637573640408,0.28049000284768943},
{0.18243806675929333,-0.19680458001386594,0.29961838558035786},
{0.16154820185031726,-0.17189070159298386,0.31062104062022755},
{0.15755783192704467,-0.13920615549505938,0.3262799282750732},
{0.16784896511920844,-0.2765651177665784,0.24092694494987704},
{0.19942988135428258,-0.2266832908716533,0.28628511098979836},
{0.20977989082655485,-0.19631554642194426,0.311657383305811},
{0.20973643452457003,-0.15746080622053932,0.3369435440556785},
{0.13857343574334907,-0.6156962961212548,-0.08553622072757465},
{0.15087897880493967,-0.6293469819498141,-0.10491232440750237},
{0.17221041581472954,-0.6366364261537247,-0.1303548877926241},
{0.18429387113944826,-0.648769545823569,-0.1607761015171256},
{0.21081503195540138,-0.6303759150355199,-0.18283528139056962},
{0.19809835623033198,-0.6597691969715963,-0.21555427211495212},
{0.18891025212265009,-0.6795454190449145,-0.2567322222671693},
{0.20167318778209045,-0.6696041391226473,-0.26276463786481763},
{0.19441017782639186,-0.6778896738614548,-0.2963473476235811},
{0.13970770530299054,0.38156555633478734,-0.632588982285449},
{0.13931279365545998,0.4041548229886641,-0.6190952998705122},
{0.14759071853493383,0.4271960752350744,-0.6111894570605676},
{0.17016476547014311,0.3596008989246467,-0.6239606033577102},
{0.1634348461867195,0.380027964230457,-0.6199848523747367},
{0.16664921071740546,0.39720281596836865,-0.6113933211869297},
{0.15221711249094325,0.4149425996320833,-0.6087839404732772},
{0.18594300776085496,0.4298843581744508,-0.5785850147451037},
{0.1499107243344477,0.14686928384414846,0.6670159859113467},
{0.15848122827935873,0.1346534570189137,0.6715722890577032},
{0.1409895660818156,0.011643685559010264,-0.12838433474409444},
{0.14263990425995918,-0.020113659256933286,-0.12960611768607408},
{0.15558087057591816,-0.006700080624457038,-0.11049275441261701},
{0.1505467483671845,0.02069020623119313,-0.11424962181001705},
{0.1653917815922309,-0.1453773508958206,-0.16212304661919985},
{0.1634278371057542,-0.12370747540513487,-0.15434837375303442},
{0.20255773379991115,-0.12650189585627136,-0.13217744910305793},
{0.2014613132774823,-0.09498245927423568,-0.11979620796704211},
{0.1767715251880336,-0.08275882233021102,-0.12884693408780415},
{0.16756760058331574,-0.04474857625539649,-0.11705585756906649},
{0.1362366081495185,-0.5618341122758646,-0.7099724402936444},
{0.15693041905092234,-0.5484405595890034,-0.6722111167228261},
{0.17725354969899,-0.5459056753930391,-0.648046008408494},
{0.17754873213735714,-0.535599322482208,-0.6233922670211526},
{0.1715018978588659,-0.5275292669182192,-0.626226338844607},
{0.18338869839764396,-0.5084335264769034,-0.6119145965512918},
{0.19386006510034398,-0.5014492776841676,-0.6146104893500018},
{0.1343832068828374,-0.5779830348199126,-0.738576299453572},
{0.14214846755456367,-0.5799481808631263,-0.7570013709762368},
{0.1420865873826129,-0.5683625705463998,-0.7473534711572313},
{0.14417869792102647,-0.5628678515885179,-0.7287183274650637},
{0.1512236253289762,-0.6496801255706893,-0.5576372748533},
{0.15941243475046268,-0.6543233413210154,-0.5293532300448461},
{0.17505490112990388,-0.6308875779459867,-0.5342351550669046},
{0.1670823719210609,-0.6261977017423773,-0.5739057522926703},
{0.1554661219075434,-0.6537105473851923,0.4853582301229472},
{0.15039375014268486,-0.6669142541076217,0.473639247008424},
{0.16982552595142264,-0.6462659021027642,0.47006161182427947},
{0.1850130028464879,-0.6408232506034818,0.445316552124933},
{0.20033585513391147,-0.6406195867365758,0.40321861003115633},
{0.21439266713954597,-0.6227788723069609,0.40201465018077415},
{0.22421659502050856,-0.6139670557173875,0.37520251237503305},
{0.2317990188087686,-0.6067226698911109,0.35771585666389366},
{0.23162138867116236,-0.6095993969787256,0.33038244349379053},
{0.24330252274847292,-0.5917769061596204,0.33196209008391264},
{0.24003448868353836,-0.5943804793490446,0.2978929501061575},
{0.2560025769386817,-0.5710933084904801,0.30163499830380236},
{0.2561864151194287,-0.5544817866027225,0.2768030260004862},
{0.2431549315292893,-0.554915148065834,0.2535126509906234},
{0.22593281855972594,-0.5630368705695099,0.2356605217720078},
{0.15443678830292526,0.3845680463608651,-0.19131687013694942},
{0.1684743754007692,0.36238050017602796,-0.1639357952162822},
{0.1671540648063631,0.3462029405297503,-0.16082055911639118},
{0.18125353207615785,0.3316338648352806,-0.1489744112472119},
{0.1789409358765216,0.3107626240557265,-0.14769194969001836},
{0.16697683518766912,0.2909886048364261,-0.1520628125799786},
{0.17774758977731547,0.27953096031218044,-0.1434502541492758},
{0.18153029064455908,0.26675620934482713,-0.14328984632489855},
{0.1937393086482847,0.26397780965018275,-0.14125000350454048},
{0.1912550900947267,0.24182490835125986,-0.14091737254787304},
{0.19535079649193493,0.21965758837149407,-0.14804981333816092},
{0.18813344569223886,0.19384033954391308,-0.1500245718352698},
{0.19136102734703078,0.1645131432283667,-0.15582849139344934},
{0.1811948560555055,0.13975807055621264,-0.14507355730083896},
{0.1726493845426134,0.12525588152009742,-0.1405989600125923},
{0.13974935926987003,0.3135270055884404,0.13452909589664366},
{0.14510970413267427,0.32640929588374695,0.1321548197845128},
{0.14747657064492756,0.3301611567947432,0.14264981710303867},
{0.148563178454005,0.2658688596946203,0.5989854455432457},
{0.14700195573384878,0.2549985761552668,0.6108185765477752},
{0.15394955704610894,0.23802999165719105,0.6014484365944517},
{0.1490043500359065,0.23116329516521605,0.6191754036529727},
{0.15649745810672305,0.21942568792127076,0.6278810827307859},
{0.16306436619283943,0.20521347457766279,0.6241616638516861},
{0.1675924327558785,0.19121894326289138,0.6197311236437928},
{0.17063577571101116,0.16718079944375933,0.6345092702104846},
{0.15956222882366394,0.15372676840114052,0.6508963012478967},
{0.16716668115210065,0.13106040185664544,0.6567142389680068},
{0.1530317679585671,0.08186846878816192,0.688752748060387},
{0.14223958560711256,0.17047186334615128,-0.05700065004219467},
{0.1456740352801089,0.14704811553849167,-0.06723771318119758},
{0.15168762648887896,0.16602009563590583,-0.05794967960489611},
{0.15244841216279809,0.1870629587693816,-0.048159195053110816},
{0.1427382316529295,0.18870668838547222,-0.04743926230824657},
{0.14761294733456665,0.19430554226055277,-0.040491060217617954},
{0.15911024323113024,0.18342184133763703,-0.04198539627941962},
{0.1619166792496358,0.18085771926107463,-0.031149557366524076},
{0.162112733257208,0.18987560283102786,-0.01675470739890603},
{0.16111263753318797,0.2215987032799695,-0.0058061224121972515},
{0.15314851922150335,0.23936752456482616,-0.0014654987001158793},
{0.15628378126700954,0.26079328377846334,0.015865755673049996},
{0.16315528398593215,0.26397901120691963,0.020810161645427806},
{0.15917773066785326,0.27236447541434683,0.04366697493272283},
{0.15092103329073145,0.29127777949110867,0.060505591043756274},
{0.1547215572495725,0.3046713321779697,0.0732539077628976},
{0.1504800619682861,0.29233054345209647,0.08046324818434761},
{0.15949774527878316,0.2987542660270646,0.08670573595149875},
{0.16014578487888909,0.30297994081131513,0.10538193283217735},
{0.1464732707696091,0.3040130793456002,0.10993983805418299},
{0.15366639017511086,0.3214947285703357,0.12179279474487142},
{0.15475760395167978,0.33497819775300874,0.14049001886844592},
{0.15330632367295066,0.3339376496188462,0.14957538987512217},
{0.1538430190154364,0.3263560268684107,0.15990156847211243},
{0.14810778845071673,0.32952453198363796,0.17603246766510688},
{0.14239458642617375,0.3335052894530153,0.19463016283897414},
{0.15066710430033148,0.34903781339102935,0.21129755711499815},
{0.16451063998516474,0.3512600925759414,0.23181393813825188},
{0.16747968668206525,0.3512939364240309,0.24313780934578835},
{0.15918273715425701,0.3639439257502019,0.2699293204275459},
{0.14767262465249975,-0.011894210138655631,0.3250883845109724},
{0.18050175807776553,-0.0018415859587681764,0.3261439521043463},
{0.1759640790608312,-0.006220459226974474,0.29956231293263547},
{0.21514544243521902,-0.0026033729299680688,0.2689714794487738},
{0.22856542937029214,0.006501823762867175,0.2690011178482842},
{0.24802023501648734,-0.011458645821526373,0.22105940456455378},
{0.25540800661336827,-0.03177636946427792,0.19183333927436386},
{0.24550637806341893,-0.06447793761597524,0.17720078133229408},
{0.23039760313462118,-0.0864530085178357,0.17845540682508257},
{0.21902867354945066,-0.12953883050880718,0.1592969851739914},
{0.20148254077983432,-0.15632353276905558,0.15557135825175095},
{0.17483501624704964,-0.16149182881341065,0.16425080334080833},
{0.14579519225108048,-0.00451945540642457,-0.205975662067775},
{0.16144687056550464,0.015576781277823555,-0.22041096444553562},
{0.15677381615621197,0.0028552993258065132,-0.23333911415630088},
{0.1467434207759573,-0.02147842745060501,-0.2267533816813063},
{0.1492939252095014,-0.028573219463136425,-0.24220279794501756},
{0.16785937861092828,-0.3061031872894522,0.2237492895795793},
{0.20447601913038532,-0.302701980686177,0.2384853816604793},
{0.20882845815037962,-0.2565844307885296,0.26939602949581476},
{0.23417469673709254,-0.22899989226041256,0.30335422573486204},
{0.22985349819225787,-0.19537953372389266,0.32515827506116923},
{0.23040180858320036,-0.1584883374900521,0.3493428085427479},
{0.21851841245517692,-0.12236713886511363,0.36006970631149715},
{0.20260920048014205,-0.10070487323376165,0.3621904539521404},
{0.2201395127527224,-0.07813903693625461,0.3793022239613643},
{0.2029822838469521,-0.044031447142918366,0.3741104975606396},
{0.22189398584806472,-0.010024387596570119,0.3720271984382966},
{0.21238646790782137,0.0023470408260943005,0.3586859134694911},
{0.18219354996333248,-0.009801098302961324,0.345624591220385},
{0.14310110178747584,0.3031135138685681,0.5639154088036459},
{0.15271395620165484,0.3043234815026348,0.5596216458043041},
{0.15209976044963852,0.29499639733238375,0.5666211143157074},
{0.14532618460477392,0.006269322534275418,-0.18897103086759204},
{0.15061543736064442,0.02260288429689505,-0.1843690685652331},
{0.15354983917163076,0.0062282693457643805,-0.19285686535475363},
{0.14650831617443558,0.0003648727291078301,-0.1925590795434565},
{0.16158324725514375,0.011870579522829777,-0.20677489755727524},
{0.1722278383874147,0.032032901827607846,-0.21515895994850925},
{0.17729580444423795,0.03908964454347052,-0.23404843314998908},
{0.1465695955680179,-0.596688069062277,-0.7672192092074491},
{0.16533170375538547,-0.591534191698765,-0.7672432403421873},
{0.14993355391244895,-0.5744114074194526,-0.7590514270288585},
{0.15721418670028886,-0.5670554770760996,-0.7533123915344719},
{0.1542663675057404,-0.5623974421260184,-0.7408222092543097},
{0.15325225361978978,-0.5597165687865198,-0.7080585606712057},
{0.17722611415349726,-0.557460245494062,-0.6838732261518022},
{0.2050779990555764,-0.5487295339842299,-0.6466401870263112},
{0.186772482428234,-0.5417560992021262,-0.6310632054890316},
{0.19147577601540555,-0.5339810258170485,-0.6110925314837904},
{0.18462510027992265,-0.5283791680501257,-0.6080529934583245},
{0.18027906956252518,-0.5176658879243948,-0.6098152766724568},
{0.19197782647197706,-0.52013568779711,-0.600286130710949},
{0.2038716360917204,-0.5122080167064448,-0.5997326135741466},
{0.21468304335096547,-0.49923520913695785,-0.6122950895179794},
{0.20073977845696883,-0.4852683136271353,-0.6304027498026443},
{0.1946917426217407,-0.45818702711232673,-0.6508498410540696},
{0.21284866673261874,-0.45634063492661087,-0.6451302307269298},
{0.21572699589588265,-0.41160387397912734,-0.6632352876386646},
{0.21234321186529267,-0.385851108696427,-0.6702121268315229},
{0.19302438238982425,-0.35560372017986497,-0.676765617534077},
{0.17479336228017017,-0.36391408709123535,-0.6852792477934411},
{0.18103104382037366,-0.3293122569601175,-0.6742425486460257},
{0.19639995578271205,-0.3129188176201086,-0.659878538634655},
{0.18369028913860797,-0.2882112064390624,-0.6405304712785885},
{0.17563785640676058,-0.273807945574286,-0.6327559986718793},
{0.17116205756177702,-0.24092774598770167,-0.6298131859637345},
{0.1481774787414574,0.6917027701089531,-0.2958256717403067},
{0.15376171367623892,0.6970769328742318,-0.2782484987549869},
{0.1529782986837747,0.6826009778268725,-0.2758606049998378},
{0.1596463377952475,0.6629731480105625,-0.27945406068101836},
{0.17062556247874744,0.6441335394136644,-0.29575397885500454},
{0.16879058508203226,0.6175643163282348,-0.3056487985834447},
{0.15710925074526555,0.6128700344165902,-0.29899277503934096},
{0.1752579642184414,0.5988274408323423,-0.310906009826331},
{0.17036021869934687,0.5946478257230067,-0.2883139395400681},
{0.14869014294920496,0.6831512908123766,-0.3158940723601498},
{0.15677842212370344,0.6727518172544348,-0.32989801586936035},
{0.1610846012093268,0.6875565983287948,-0.31341546107136403},
{0.16430136885348656,0.6992473448600005,-0.2960185215965805},
{0.15082751212470877,0.3036608229622298,-0.5714265402255161},
{0.16395932570238,0.3049382780330196,-0.5686861898275405},
{0.14865710013893998,0.1243467035891701,-0.08433866917978934},
{0.1602234855478758,0.1402010444732195,-0.05546566131079428},
{0.1535636570741052,-0.2259168979329619,0.14313604706257424},
{0.1695731990366719,-0.2537217218628455,0.12562936540581976},
{0.15475099538962678,-0.28874790178154813,0.11610602696854042},
{0.1561648271500556,-0.32042634437176803,0.10244592894554183},
{0.1559781853369225,-0.3192510216236155,0.1029271524186736},
{0.1577851264097765,-0.3176271176936839,0.1031764754415821},
{0.18154290699029663,-0.3292515783449036,0.21584404754800318},
{0.21091936713205625,-0.34177640551098,0.2225441281724602},
{0.2247136389906763,-0.33327679341354655,0.23258954301192622},
{0.24107323448259563,-0.32867142670043303,0.2455375184088505},
{0.23191496903388023,-0.286095465284823,0.2625067036852946},
{0.24763073037427288,-0.27661438159279156,0.2815197369712199},
{0.2478307895709681,-0.23544103740806588,0.3109873151655284},
{0.24657015629449514,-0.1924791760204521,0.3411810341478419},
{0.24463585020752884,-0.16397064036165254,0.3588359078021484},
{0.25073675453918093,-0.14532288032374743,0.3808600422707659},
{0.23700236025795018,-0.11781123623766951,0.37722753599563585},
{0.14589492146024385,-0.61876967799481,-0.783836138100523},
{0.14911869818536894,-0.6133057989931755,-0.7869251402116582},
{0.15795454590968055,-0.6040283791680501,-0.7827637487128323},
{0.16829294033349607,-0.6060303729511956,-0.780297753769784},
{0.18382586479042246,-0.606984609259757,-0.7684660245814476},
{0.16619362045466105,-0.5767989006556895,-0.7590287977103135},
{0.17475471220513294,-0.5659464402079334,-0.7448552344417426},
{0.1754870610362786,-0.5626371526950317,-0.721072821948116},
{0.19353764737594026,-0.5644775370970628,-0.7182874131725062},
{0.1986965312258562,-0.5644663225675184,-0.6939572910663054},
{0.20778250301090093,-0.5561717761531841,-0.6711405296702406},
{0.2213849263105279,-0.5431967657296793,-0.641340721038177},
{0.21283685142470585,-0.5366402711352828,-0.619014395050227},
{0.20979891547488924,-0.5259271912690081,-0.5985244482751854},
{0.14352425001832372,-0.633517785643079,-0.7758069354655891},
{0.14507626080349698,-0.640799619987656,-0.7995202584468436},
{0.15064046979266338,-0.6312077928163728,-0.8032072352940469},
{0.15956262934257623,-0.6289136204867026,-0.8016618330709266},
{0.17197130602408478,-0.6284386050567115,-0.7869013093363761},
{0.18418893518442492,-0.6317076404189267,-0.7719571476805348},
{0.19705320212867788,-0.599964714283826,-0.7687786295925},
{0.18647629869258608,-0.5759620163884328,-0.7552368849080868},
{0.1902998524888846,-0.5685213762951278,-0.746946944461244},
{0.2001309897102686,-0.5617986663521258,-0.7483351430112853},
{0.2054474777521757,-0.5612936120037119,-0.7050969235741826},
{0.21417278225669173,-0.5537398253176816,-0.6973532909237207},
{0.21661274347044027,-0.5482290856033075,-0.6752073987057631},
{0.22252680572950312,-0.542160623303552,-0.65828186999076},
{0.23289343673663596,-0.5393117322803423,-0.6486535955984574},
{0.24350878998830883,-0.5364650441111503,-0.6278129945156945},
{0.2215233055947285,-0.5282383856524512,-0.6090897366628203},
{0.21205123357822392,-0.5192581508602545,-0.5960592543699617},
{0.23201329642685062,-0.5112752081596916,-0.5957081995433283},
{0.2346280841458193,-0.49218787861553426,-0.6111401932343543},
{0.23789071120543773,-0.4628314444193897,-0.6276203449188769},
{0.1464806803694867,-0.6443690445340984,-0.7773723636343246},
{0.14939585727268245,-0.6495115071086099,-0.804629477951634},
{0.15565716942871183,-0.6453961752846988,-0.809673212614263},
{0.16230838674586792,-0.6368739338687203,-0.8037267083233036},
{0.1689696170358316,-0.6394995355983212,-0.800356742195188},
{0.17509214938874804,-0.6370557694549057,-0.7850791485448547},
{0.17446013054513426,-0.6409347951205582,-0.7735602246270267},
{0.17077315369793103,-0.6454430359974382,-0.7598750941720092},
{0.19363016724468218,-0.6450877757222256,-0.7554051028512541},
{0.19689820130961672,-0.6312776833665698,-0.7727135276464187},
{0.20748651953470915,-0.601238564684405,-0.7830819609886569},
{0.19915552589935517,-0.5785357509188905,-0.7695796674171056},
{0.20212837752592255,-0.5608950956859707,-0.7673265482759463},
{0.20780473181053372,-0.5501700002523269,-0.7551017097751846},
{0.2134758793492849,-0.5511879190679444,-0.7270381506279535},
{0.22452940029101698,-0.5451480938704185,-0.7030831144831243},
{0.22791518691616858,-0.5408579355412872,-0.6789057903419671},
{0.24703275563820484,-0.5434803331195897,-0.6754957723226211},
{0.2538515901201596,-0.547602674024466,-0.6586159027636205},
{0.2588987291935431,-0.5400707156191562,-0.6189953704018927},
{0.25947247253541683,-0.5330333980705402,-0.5946972898086761},
{0.23802468478160302,-0.5237475673482563,-0.6009069350250184},
{0.2509085771525588,-0.5141166895830237,-0.5824740533835636},
{0.25386861217393253,-0.49208995174147624,-0.5953206974956754},
{0.2627923737994946,-0.44402608018949347,-0.6138779402594},
{0.23641079382447897,-0.4345373866381283,-0.642745541123079},
{0.23484676747193664,-0.3986597035118699,-0.6552371252194342},
{0.2373612252033735,-0.37014656188557893,-0.6555485286737497},
{0.22188397287525713,-0.35878624345702287,-0.6647029891927981},
{0.2068671170368329,-0.3350589023138378,-0.6658366579740712},
{0.15522621107907403,0.5985520840801343,-0.22153441999454493},
{0.1641479701100746,0.5958443759735111,-0.25615287166052336},
{0.17281519937230674,0.6075996060495977,-0.18133153313432882},
{0.1500432960944199,0.3571873719591102,0.4280143353729091},
{0.15934374575700275,0.3551130845122941,0.4115117546292977},
{0.16029497817372185,0.35528250401219824,0.43649852749221885},
{0.16503511950082525,0.3484774874327178,0.4411405416858081},
{0.1723173543643144,0.3271901075032812,0.44176455015117577},
{0.16695240353401863,0.332798573832257,0.46949267470935335},
{0.15474699020050375,0.33669121714092776,0.49450808467450424},
{0.1522355363609092,0.3282891313986401,0.5113715329581004},
{0.16128826507623276,0.30776353844040333,0.5292793343055261},
{0.15349636989683832,0.11038681716031287,-0.08573307577297146},
{0.1590193254380375,0.10202117863904472,-0.06849434126854753},
{0.17236401481759767,0.10259892717004149,-0.04911903862644443},
{0.1781479084301621,0.12937601957095612,-0.02901759519633638},
{0.1708708803125329,0.14680840496947842,-0.03383603797079497},
{0.15949774527878316,0.043803351622361916,-0.17623272712125831},
{0.16393649612437872,0.03713130732176608,-0.19090093124652296},
{0.1628609025853896,0.01705810047497538,-0.19774319608484753},
{0.16766352486281225,0.030412402308430807,-0.19996126982118032},
{0.17774218277199938,0.06102446329464453,-0.20903021955245216},
{0.1991052607758612,0.07526771685395596,-0.23175506185814343},
{0.19825015289809475,0.05163409713624973,-0.24683079397667618},
{0.1917943888101424,0.01992601614651944,-0.26563976287678315},
{0.1774437961823338,-0.008990448024460487,-0.27547971151423783},
{0.18330198605313042,-0.02834412264529925,-0.30072461881613816},
{0.20268329647891803,-0.0033845850684146262,-0.2989559272994091},
{0.18887400516108668,-0.05634019435580737,-0.33196329164064964},
{0.19005954114150292,-0.06690928767310927,-0.35055698162539384},
{0.19289201088930816,-0.07859062200987599,-0.3710967930050173},
{0.20405967972104655,-0.05357641360146204,-0.3719993623738916},
{0.19003490922839628,-0.10452602391658632,-0.4080969303830042},
{0.1827470671001349,-0.141376367221372,-0.4416133542617815},
{0.1712157270960256,-0.16881331453030543,-0.4474607301219459},
{0.16766652875465451,-0.19122334897092672,-0.4553519539915915},
{0.1612588269361785,-0.22016104064425865,-0.4713234466574894},
{0.16489173373022087,-0.24179987591924093,-0.4989039799964834},
{0.1731466287722373,-0.2443337588179245,-0.5220253360253544},
{0.17191423207908163,-0.29675407457902453,-0.5077772762390953},
{0.18149464446136412,-0.30344354145230557,-0.5241450823687168},
{0.188096597952307,-0.3232335814280982,-0.508448746195571},
{0.19505561405356778,-0.34671360214293634,-0.48168847558897304},
{0.20773844593054758,-0.3718467646683042,-0.4452438579423501},
{0.21689591034143835,-0.3941038008844258,-0.41839066694809784},
{0.20679682596772375,-0.3872969819698401,-0.40008615161803635},
{0.22057067136181635,-0.4079046813050989,-0.35276384083218215},
{0.15399441516428683,-0.6484138850294441,-0.7829846348929673},
{0.16045859014939753,-0.6488478472709241,-0.7960281340504758},
{0.16130068116251414,-0.6489890301875109,-0.8049783299242498},
{0.15791249142388877,0.48312633848414,-0.2587682601578605},
{0.155862435371267,0.47361821976552815,-0.24617113932811352},
{0.16082606625143533,0.44259782974822176,-0.20935023416338208},
{0.16791264762626457,0.4179378803177396,-0.1809151937249901},
{0.16347349626175672,0.400142624784671,-0.18337578166272223},
{0.17802374756734823,0.382848218151437,-0.16909588062293507},
{0.1864342442067943,0.36515889987067246,-0.1531402084540731},
{0.18045990385142988,0.3498949238633573,-0.1467555364730545},
{0.19013483869701583,0.3337808464646796,-0.14164030918457954},
{0.19528571216868573,0.3113978470506388,-0.14029516641761067},
{0.19285255977644633,0.2999758487095881,-0.13404687112623115},
{0.18270080716576395,0.2998873340299692,-0.13994431185043343},
{0.19261565283981927,0.2873326682049263,-0.13262082353897708},
{0.1948920020778921,0.27650423889190834,-0.1325471280591134},
{0.20162192136131568,0.27815217395657815,-0.13912525067477424},
{0.20316552124933063,0.27370601351110496,-0.15954370482396993},
{0.1976810155237125,0.25315498760193705,-0.15238362822873314},
{0.20387023427552736,0.23749269553633687,-0.1680337044675081},
{0.19900653286397854,0.19838382608507582,-0.16935041039170348},
{0.21529583728678875,0.16493168549172307,-0.20170332683024128},
{0.19640576330694046,0.1434296274252922,-0.16386930907683994},
{0.19032508518035965,0.13147033296338737,-0.15177383818475215},
{0.18217472557445424,0.11139552404094746,-0.15087447296717627},
{0.17369353734698675,0.11441743923427189,-0.14338416852874583},
{0.16747928616315297,0.10097602453739064,-0.14934889643021498},
{0.16964689451653558,0.09336516390635707,-0.15335428581269894},
{0.16491436304876594,0.0689509328285727,-0.1612703418549072},
{0.1627896102189997,0.057535342790118876,-0.16458403507584426},
{0.15668650303332995,0.05038387735149658,-0.16979118145469269},
{0.1688546681080007,0.05493737686546689,-0.16997742274891348},
{0.16611932419642889,0.04807849049228179,-0.18190667829239562},
{0.17682579550065064,0.06710393986448844,-0.1885422753719719},
{0.17008986843354248,0.349377253169206,0.39906522891057655},
{0.17111619814631834,0.3509781272616802,0.4254153681509764},
{0.17446974299902954,0.34421436413016704,0.4279244188770971},
{0.1749131174349487,0.3346061156834795,0.4293516680210881},
{0.19260924453722242,0.3153139207156792,0.3967378135111851},
{0.19313632742581285,0.3068020927914205,0.4274035440316474},
{0.18862588369491512,0.3033676431184242,0.45169101087368796},
{0.18127856450817675,0.31137261435916375,0.46239047309694437},
{0.17411648531837848,0.32144326189010475,0.48281793892166686},
{0.1658299492822901,0.33127459937094494,0.4923953474121071},
{0.15807410080500295,0.33305330386048165,0.5035816403732676},
{0.16136776808032485,0.3219134710931482,0.5072165497618715},
{0.16757941589122866,0.30542150410071284,0.5035005352935262},
{0.17418917950096144,0.2875026884831989,0.5203489641179111},
{0.16034624459449662,0.29977538899398054,0.5552345618983955},
{0.16224850916847866,0.2873713182799635,0.5507643703181841},
{0.15700211193622457,0.2788983406901982,0.5571582542341857},
{0.15731091201761,0.26982979147783864,0.5680261346600655},
{0.1617548696090655,0.25729935704699003,0.5870441744323945},
{0.16450323038528716,0.24217175772931407,0.5893641802319084},
{0.17171677625531637,0.2263792970172155,0.5858640454572944},
{0.16603761833831912,0.22060721871256397,0.6014161948220113},
{0.17116365963742625,0.20947259269109056,0.6095008693262991},
{0.18940589427662477,0.19538734384268255,0.5970897895313166},
{0.18354189688159978,0.17841475415548386,0.6121717296929902},
{0.18485059242754912,0.1460221863446281,0.6318700508378654},
{0.18844304681144888,0.10368112927108358,0.6471450411152688},
{0.19071979656843405,0.06947200793347862,0.6553298453476323},
{0.20567857716457438,0.040616422637168706,0.6483990658296889},
{0.2292777522558226,0.018777327906035056,0.6346302269220001},
{0.22001415033317162,0.00041633940933874985,0.6413699589187751},
{0.2031917552380864,-0.014613333034279218,0.6546655847315781},
{0.17019660672367115,-0.018488553770264763,0.6700533210827948},
{0.18678369695777847,-0.0480146077257695,0.6585616324510035},
{0.15208313891477798,0.357851232056252,0.28155538315441486},
{0.158534497294695,0.36248283275812143,0.28672107582583994},
{0.16686929585971583,0.3558324164787899,0.29758334898694744},
{0.17019200075617968,0.35296810547745655,0.31078525337427165},
{0.16022949333156036,0.3620494712950098,0.33136411534784466},
{0.16143605655487248,0.3659835683111038,0.35644080470657774},
{0.17501765287105972,0.3588901781147654,0.3533407883253543},
{0.1805864678277176,0.3475072303676643,0.34824718905814367},
{0.1781483089490744,0.3374067441777566,0.3573585937941196},
{0.1752497535807392,0.3380063209894739,0.3720586391729123},
{0.18629766725769906,0.32464941578308854,0.38120508931371483},
{0.18063092542698317,0.3369131046183435,0.40560430093228783},
{0.19096090895364032,0.32118532771058184,0.3494451411248413},
{0.21507935681468907,0.30147258788486364,0.3755691874392463},
{0.21845432942920848,0.29515800671349796,0.4092508253693485},
{0.22009525541291294,0.28685845381275976,0.4292849816221897},
{0.2088026246805361,0.28722713147153456,0.4566488342296278},
{0.20146351613149996,0.27694821410619597,0.48533580106385826},
{0.18257604552458162,0.2968131511185892,0.4768464021986885},
{0.17081981415121428,0.31119718707557503,0.4920180585967179},
{0.1531809612533999,0.3557643282636984,0.20480654736276316},
{0.15769781328689447,0.35662944911427247,0.21727830577295942},
{0.1696889490023274,0.3568953936720415,0.21821872417904634},
{0.1722781035109087,0.3503645322880323,0.22326846662535976},
{0.18026405010331384,0.3295405527401301,0.2325715196608726},
{0.17981907359174545,0.3451335550339019,0.25367826556086065},
{0.1735149059120997,0.35835127991826204,0.26488678732165394},
{0.17151531524242808,0.36376489379640264,0.28257890923480455},
{0.16392307874081657,0.36600059036487675,0.2852265395045821},
{0.15318937215055825,0.34842061374717087,0.19243251556716878},
{0.16207188032815315,0.35338404436788295,0.1981335017648866},
{0.16661656842605277,0.35799922379434795,0.20970529417913844},
{0.1774808441817218,0.344948515296418,0.20509291838505966},
{0.17674829509112003,0.3366850090977871,0.2175474544820269},
{0.18227645737817916,0.317176133398431,0.21313934333322251},
{0.19313472535016366,0.3076517936638709,0.2307361417452451},
{0.19054717291723156,0.32170840541004925,0.25412824855883276},
{0.18466334983604757,0.34145899427298004,0.2708791510280719},
{0.1793426563455613,0.35504379474046577,0.27098288542635834},
{0.1783011069141179,0.3499095428036564,0.28302829145440833},
{0.1605056511215931,0.33620638899758526,0.17410877532931665},
{0.17013492681117653,0.3463363133275471,0.19181852007460862},
{0.1711147963301253,0.32975583165549277,0.17339545114650537},
{0.17936428436682564,0.33169534448831905,0.19203019431976065},
{0.18656841804241572,0.3089318521075906,0.19985072660138475},
{0.2002599568000301,0.29165006182009406,0.18606346382372999},
{0.2156084422978411,0.293565343258726,0.22563993910510455},
{0.19461964921752622,0.3118968936153681,0.2668549372567098},
{0.1875572992368913,0.3222036470451116,0.27150416079072043},
{0.16432199557747015,0.0005803519039267186,-0.0991833018859234},
{0.16215759137538593,0.04058738501602677,-0.08762813100653206},
{0.16285169065040664,0.07918799596757557,-0.07829443827422809},
{0.14836852626262584,-0.051857386429858515,0.22918172784659802},
{0.14890642316184846,-0.06140555703970063,0.22092523072893236},
{0.19374631772925,-0.17144171989229245,-0.1591928502567927},
{0.22681496146407282,-0.15503326109307217,-0.1294437072671353},
{0.23387610988797083,-0.14385197461831548,-0.11633151911616692},
{0.24305059635263443,-0.12846844371567803,-0.10085006133947143},
{0.2217277704994591,-0.09837525498035253,-0.10717625755929383},
{0.19356227928904687,-0.06453180740967998,-0.11010965807299938},
{0.20258276623193003,-0.03692764345486011,-0.09198397443728094},
{0.15412858899990825,-0.19636881543728052,0.15522130472239834},
{0.185894144453554,-0.1884195163253511,0.1468300329907428},
{0.17779224763603724,-0.21941527442955092,0.13530730414324796},
{0.16292318327625271,0.6605672309043595,-0.3379742794764897},
{0.17094958227880042,0.6866664450462018,-0.3108086837306414},
{0.17485944790070013,0.7014810388339132,-0.28611128578185896},
{0.17069505251003197,0.7049981956623,-0.27457493929134585},
{0.15747011828525034,0.7018258856174059,-0.28505952311815186},
{0.16102832830214825,0.7013801080680129,-0.27005488310655285},
{0.16354739200107657,0.6877905013735797,-0.2653291604602923},
{0.1697786652386832,0.6747948642260914,-0.26795135777913864},
{0.17157639437655425,0.6627510602736905,-0.280435131756704},
{0.17815551828949586,0.6730992674108575,-0.27887130566361773},
{0.17487967410577143,0.6327622067150199,-0.3075412504440753},
{0.17689288241846135,0.6147418595532372,-0.32561286402663286},
{0.17225967964094277,-0.579819814551733,-0.07433811245850123},
{0.1910364067686094,-0.5886412435952019,-0.10372038012448928},
{0.20053831744408057,-0.6033148547257827,-0.13309523819059974},
{0.2036161050256712,-0.6204838989394659,-0.15519006424723872},
{0.22197408963052528,-0.5982308679124674,-0.1561773433660651},
{0.22027448762616844,-0.6200283086767214,-0.18346129245049886},
{0.2213236469169456,-0.6354016263470953,-0.20595363352759835},
{0.20663221269476734,-0.6541002522868627,-0.22852007060347382},
{0.21232098306565983,-0.6619279939089083,-0.24791700126684132},
{0.20733191923456026,-0.6768883765806979,-0.2829658105040891},
{0.20487113103737203,-0.6807447729278053,-0.3266970687222365},
{0.18890023914984252,-0.6791352876787164,-0.3390556805397072},
{0.18196044795637226,-0.6858976489940366,-0.3142012791773021},
{0.19251291973881357,-0.6741271991992825,-0.37055449039775934},
{0.20745487854063724,-0.6592919786875875,-0.4183057569386897},
{0.19205692895715687,-0.6651591802339111,-0.4182430757289143},
{0.18406497458106721,-0.6584586990905416,-0.4505465280817827},
{0.1966246468925139,-0.6508991048802828,-0.7376162556207823},
{0.1700424069424346,-0.6592517265369011,-0.4977148393458564},
{0.1722955260835939,-0.6464225049974747,-0.5135833986512925},
{0.18715658006513236,-0.6339958049649125,-0.5031677040774026},
{0.18642483201235518,-0.6152058607131399,-0.5354823709598154},
{0.17757376456937607,-0.615213871091386,-0.5591358163636808},
{0.17482239990131213,-0.6225513775647727,-0.5547895853868272},
{0.18408840493743692,-0.6123675834411062,-0.5807602329578201},
{0.1827937275534182,-0.6815484141253407,0.6472772123563288},
{0.18483397089268855,-0.6819078798491326,0.6239217530232168},
{0.2056931961048735,-0.6674595606067221,0.595025314797852},
{0.2299526266230528,-0.6417462464368836,0.5485156568850602},
{0.2078740215823621,-0.6459212555787277,0.5391541280883512},
{0.23968824008385262,-0.6107973490454232,0.4908445381836707},
{0.21626809694640375,-0.6089159114548809,0.4738953788528417},
{0.22494954463002262,-0.5996843510452141,0.44983240286114684},
{0.2074694974809363,-0.620043528395389,0.4383246934728634},
{0.22937107316238917,-0.5989387850899626,0.4162751260533147},
{0.2307935160794325,-0.6016112475323027,0.3937591543603892},
{0.24940723200979187,-0.5838900879980102,0.354447622339503},
{0.1862994695928044,0.5876085055798292,-0.2649434607477448},
{0.19098554086674693,0.5981667848864989,-0.22203847304567798},
{0.19381000023630615,0.6135603287619439,-0.16160597670341692},
{0.18954026837170235,0.6219069426348777,-0.11513777249804846},
{0.18818851704268047,0.6197305228654243,-0.09601259391667845},
{0.17934866412924583,0.6009455851000557,-0.10510377244758308},
{0.1836554439932376,0.5924087247437779,-0.09809929744977593},
{0.17426447705647435,0.5673350392768871,-0.13020429268159828},
{0.17304349515231932,0.5530877805284525,-0.1487336993809179},
{0.16422727285471053,0.5020258246584275,-0.25544575552085286},
{0.17515803474982186,0.5084697734384669,-0.24204319115846493},
{0.16438748041963167,0.49154724861530585,-0.2649096168996552},
{0.17462133940733612,0.47982526160894046,-0.2725152707848288},
{0.1706121450951853,0.46754455071991263,-0.24893632189865192},
{0.17114843991875872,0.44999381198280497,-0.21564498964858866},
{0.17458769581870268,0.4352220737187099,-0.19274712317278267},
{0.1762380339968463,0.42053925065314623,-0.17479806837738973},
{0.18398326872295745,0.40926864846094596,-0.1674339273963347},
{0.1773264441410291,0.4045737657709327,-0.16939586928824985},
{0.18025543894669932,0.397938969729181,-0.16989231248004913},
{0.186239391755959,0.3951844009098187,-0.1728363267449307},
{0.1889204653549138,0.3881012239457441,-0.17720859145108403},
{0.19454995892678553,0.3748190155165032,-0.17165459569418137},
{0.19977833280798601,0.35135321322305174,-0.14790062004332813},
{0.1896500105536733,0.35118239190695466,-0.1410299183622301},
{0.19556787774240303,0.3429501261834833,-0.14010992642067063},
{0.19688117925584386,0.3259272713727906,-0.14821082194090662},
{0.20299429941432118,0.304844957126453,-0.14717207614184935},
{0.20084191077960603,0.2910068284469358,-0.13495444698150924},
{0.16208710004682064,0.33011129219016155,0.1563435587146707},
{0.16202702220997522,0.32479079895913143,0.12667692262094768},
{0.1655589982381173,0.33185314893976636,0.1410970052800408},
{0.16792706630710746,0.32857670397767347,0.14683183532584812},
{0.16711481395295744,0.29571432748268656,0.10759980630905398},
{0.1712738023383095,0.3207323408207674,0.1322527466585708},
{0.1751352051718206,0.30943810801274124,0.1480760473269167},
{0.17858227119055448,0.30673881080327675,0.16891244296110036},
{0.18343716118603262,0.29543877047102224,0.16597163284751723},
{0.18753406913997775,0.28291194071038434,0.1444709765972794},
{0.21157341451584671,0.26620970128898996,0.14773019924614325},
{0.21976022134277165,0.2746033761341194,0.17950556741314042},
{0.23793396724796642,0.27378932144486395,0.20618973942640081},
{0.23423477457393796,0.281275220175259,0.2310435400104375},
{0.21434540590789428,0.3027748751282161,0.28334690424914516},
{0.19145294643740426,0.3164812330855856,0.29717822410715317},
{0.17893052238480173,0.3336893278932184,0.2901753511849952},
{0.18553628080541149,0.3280235873597833,0.3141920672423191},
{0.17732384076809912,0.3535062026361353,0.3291236125524229},
{0.17284123310160643,0.3621299755963826,0.3441318572342326},
{0.18278571717517214,0.3429839700315728,0.32920812204291877},
{0.16324359840609493,0.30466772750775906,0.07774692892111018},
{0.16742962181802742,0.29977318613996295,0.0816551924673607},
{0.17138074088789435,0.2849145352718982,0.08204389607175054},
{0.1701128982709999,0.27649943266496074,0.09036888192341996},
{0.15783318867925283,0.29925511492689927,0.06384732058855452},
{0.16470429087926317,0.2982540179055984,0.06403055799093305},
{0.17225827782474973,0.2904404947049397,0.07060948164441849},
{0.18038140214461856,0.25480292266660687,0.07449231223973779},
{0.17579445930147095,0.2649038093754268,0.09396494097753047},
{0.1777804323281243,0.27644636390908056,0.11227666564801354},
{0.17805098285338483,0.30338646750730247,0.13202945736496202},
{0.18158055576805307,0.2916556690848663,0.14621844061165645},
{0.18575216049914267,-0.5470117083693633,-0.05928520991796972},
{0.2159943422698448,-0.5313117675260066,-0.08068573644013184},
{0.21087531005170299,-0.5701615012410078,-0.11132663478803138},
{0.22090850906434376,-0.5729895652807777,-0.12979416131540025},
{0.1675722065508072,0.6444485475381904,-0.34179082419182294},
{0.17163366858101353,0.6643567405931126,-0.32587580469255967},
{0.1777351736910341,0.6888338531401283,-0.2958571124749225},
{0.18049995574266017,0.6947112679187154,-0.2736519434579441},
{0.17690529850474274,0.6950807466153148,-0.26480888639321104},
{0.16794068395012576,0.7015124795685289,-0.2657927611012828},
{0.1690186806025887,0.5264755016599506,-0.20435856695935253},
{0.18210583632153818,0.5426917113812655,-0.16216189695369318},
{0.18209241893797604,0.5346685165300162,-0.18754258016686418},
{0.17465498299596954,0.524182330627561,-0.210130645264004},
{0.16965650697043086,0.5199508483190821,-0.21672178474431472},
{0.169143442243771,0.5192279116823756,-0.21757849469773038},
{0.17022544408535698,0.5199923020265056,-0.21640917973326237},
{0.17043591677377207,0.5186611774214672,-0.2179585871455057},
{0.16958201045274254,0.5140315793141594,-0.22575088284381245},
{0.18807356811484957,0.5249184843883735,-0.2034960494817085},
{0.19431725743873762,0.5223201179448093,-0.2197829507910449},
{0.18252377780652612,0.5075269519189062,-0.25382225210983345},
{0.17886203365079795,0.5016104865463694,-0.27419504710302667},
{0.18269660171718474,0.4938542375501699,-0.2900153438795303},
{0.19204991987619158,0.47969809685428433,-0.2902732780590533},
{0.18923006647412385,0.4595662139868413,-0.2655346266623037},
{0.18005197533924952,0.44817565638040635,-0.23335974088028452},
{0.18301341217681627,0.43438599048927784,-0.20523049663143567},
{0.18200530607455018,0.43118924879073317,-0.1888184331620047},
{0.18467576592232895,0.4193300840569041,-0.1731491320154392},
{0.18947017756204937,0.413169702666775,-0.17984881212098394},
{0.17032817718636262,0.3073129546640627,-0.583915120430029},
{0.18522367579435914,0.3120579022181138,-0.5603638073488011},
{0.2142468782554678,0.31872173588100744,-0.5101765847832451},
{0.2177598296352754,0.33484162080391355,-0.5074670743415168},
{0.2112373791484247,0.34103804889614986,-0.5312352684137568},
{0.21585295909380187,0.34589874641585633,-0.550109321637113},
{0.24394835949456112,0.3640318396514524,-0.5033014773941118},
{0.22320548502640017,0.37608165138753763,-0.5294357369407805},
{0.20143047332123498,0.3673963987742519,-0.574403997819575},
{0.16626911826963012,0.2819693194502797,0.05534550563710342},
{0.17518226614401616,0.25020576659119553,0.059129808579996224},
{0.1868940399181179,0.25090767598500613,0.08964234061650274},
{0.19129914717508,0.2639547798127253,0.11744556247073706},
{0.16111063493862646,0.24705788819995184,0.004911763681025129},
{0.1667947993420275,0.2616610080019673,0.025913974144902124},
{0.1656611305607545,0.25977336236828436,0.043779921265992214},
{0.17038064516387427,0.2357107868955018,0.045122260400574966},
{0.18323670147042506,0.2288132504472795,0.05946504290959366},
{0.21936631099252185,0.22106300923476452,0.08503136663861698},
{0.20513086755200036,0.24582469046897157,0.1032163270733562},
{0.2137324117126148,0.2520858023655448,0.12651671505602657},
{0.17291052287343478,0.22743166045929106,0.012838032955497135},
{0.17007484897433112,0.24701583371416005,0.02891165794403228},
{0.17376182582153435,0.22352580002651434,0.031369241989922136},
{0.17878032779268818,0.21232188423321255,0.03487298143474684},
{0.18603973307817606,0.20511775055762244,0.037337574561602},
{0.20313187766069715,0.20679111857322344,0.05456849894723603},
{0.2307700857230628,0.19529682656850214,0.07131099051931682},
{0.2460128342280258,0.19693675125492588,0.08921118200740878},
{0.23343674064117467,0.22627436106219218,0.11461769869042328},
{0.2443719082443213,0.2390403006134748,0.14883623222246742},
{0.24332775543994797,0.24802674344881223,0.16537826407894066},
{0.2479449374609744,0.25654337760001855,0.18800738236459152},
{0.2578681940321881,0.25890764073934186,0.2147954890355945},
{0.2589239618850182,0.2682982071571929,0.2576171688039023},
{0.2453089222396537,0.28391343825059745,0.2830036595413017},
{0.21790241436805521,0.3031671834028166,0.32567434367967135},
{0.20163573926379016,0.3133858226718536,0.33698900295222484},
{0.17413170503704598,0.07283656705627813,-0.06084583185975751},
{0.18983324795605183,0.09010153554945786,-0.04015662692584513},
{0.20253710707592754,0.11495113068491537,-0.016809979008803815},
{0.1935238294734658,0.141695180275565,-0.007103202909689805},
{0.18644105302830347,0.16382765510996045,0.004308982718009443},
{0.1694606532223148,0.16674102967805085,-0.01538152830807595},
{0.1950584176859539,-0.24397028790500974,0.11778039628142219},
{0.2102382847216854,-0.25153428782330384,0.1050430938323692},
{0.17001897658606488,-0.533181389808636,0.6014306135028542},
{0.18756731220969886,-0.5044039057002252,0.5769268664481702},
{0.1859596292957155,-0.6485823032320674,-0.47941513024274246},
{0.18401450919811707,0.42100505414815437,-0.5824338012328774},
{0.20644296750870422,0.4164966130118181,-0.5602438519345664},
{0.2030355528622884,0.43719563065908185,-0.5635182943020978},
{0.1926412860502066,0.444750418642393,-0.5863306499901272},
{0.1723942539954765,0.2667988646089874,0.5395252088605997},
{0.17866277549192733,0.24466458743948657,0.5653761012768141},
{0.20589105244755104,0.2307880089443883,0.5507501518967974},
{0.20700569658048967,0.21966439719300324,0.5616450673492577},
{0.2042503267233027,0.2031177593690385,0.5771597681956743},
{0.1792140897747121,0.1907661566325331,0.010121313173347378},
{0.16604022171124908,0.1516364601978323,-0.5245770420156354},
{0.16834560857046385,0.1498307206817152,-0.5244142310777843},
{0.1737802496915003,0.15202215991037987,-0.5229509352316861},
{0.17830911729236396,0.15297018817580055,-0.5189429424762723},
{0.17775499937719308,0.15410485825435433,-0.5177702231010497},
{0.1853466351004361,0.16615346843370268,-0.501522572645119},
{0.19502237098384664,0.16038279194524424,-0.4876175573072472},
{0.2061429788433895,0.16091247820676466,-0.46519050081285307},
{0.22169572898647485,0.16572331112188948,-0.4572007492907811},
{0.22826143551585434,0.1681704816760595,-0.4417527348432629},
{0.16913282849259498,0.15258969520911292,-0.5182073894938282},
{0.17096920770550322,0.15258589027944602,-0.5186535675621334},
{0.1736524841584757,0.1529349425115179,-0.5177834402251557},
{0.17036121999662762,0.15261993438699176,-0.5180567943828023},
{0.1721825797503245,-0.11581705257331398,-0.5655889770787031},
{0.17261654199180457,-0.080558972204388,-0.5548863107041483},
{0.18837796248819969,-0.07946034882794148,-0.49578073351834634},
{0.1882107458423133,-0.050534472462522434,-0.49644980036134817},
{0.20360849516633747,-0.004962629582887577,-0.4558181580055119},
{0.19954863521178037,0.017318037249059892,-0.4622440834344977},
{0.20270011827323478,0.05295981473597192,-0.4489536643675546},
{0.21060556056426707,0.0689252996181853,-0.4294029344418628},
{0.21060756315882853,0.08982858191072353,-0.4172590007613865},
{0.21908434567826074,0.11684318202663369,-0.39874801793203274},
{0.20452748581061622,0.1462062247848312,-0.4201383312219311},
{0.16735232166795297,-0.1714204923899404,-0.6027206849193815},
{0.1712367543389215,-0.2032307057023079,-0.5838236018585679},
{0.17217837430174532,-0.18255411711413305,-0.5712655316227704},
{0.1750705213674837,-0.14399375831327066,-0.5542298602068839},
{0.17493013948872155,-0.12695788663792806,-0.541769116066776},
{0.17767769922711865,-0.10831353101077755,-0.532935270937026},
{0.1836604504796414,-0.11436176710546182,-0.5071664848978336},
{0.1882996610408445,-0.11625121507425018,-0.46700785537742695},
{0.20287314244334959,-0.04355042392924272,-0.43557513113990487},
{0.20123181594073283,-0.026063567958647213,-0.4531220649473457},
{0.21455748067195857,0.00017863143488704042,-0.41285028883421354},
{0.20996392926675797,0.029311776337422758,-0.43030670536747406},
{0.21684904962869894,0.04221990010257288,-0.4141744043582866},
{0.2213799198241241,0.06451198172352098,-0.3962159373684545},
{0.23195742403858435,0.0893105106976599,-0.3638866515457427},
{0.23054859876455935,0.11831308643478491,-0.36828414894337097},
{0.23035995435686468,0.15470703843900155,-0.37691172683328517},
{0.21637843990674316,0.1562636551916663,-0.40505318690895925},
{0.21381531912746152,0.15923049903454914,-0.4235361334144518},
{0.19638773995588682,0.15498399726685894,-0.43308830921341684},
{0.18341092719727678,0.1648091267045584,-0.4459413616281253},
{0.17657827481284752,0.17359931527286754,-0.45508380657980485},
{0.17718946667302155,0.18184479812044482,-0.46568153699933634},
{0.19061105568374384,0.16931516472742084,-0.4669453744271077},
{0.19442139235593633,0.16310151432195552,-0.47345540882767706},
{0.17467681127669005,0.6831627056013772,-0.26526647925051694},
{0.17559980711009182,0.602245268970478,-0.34200450103153646},
{0.17720328457549597,0.6604016163341223,-0.3133952348662927},
{0.17881477241914623,0.6628327661318003,-0.29916099298250814},
{0.1829683537991822,0.40567339044466,-0.5937660833375721},
{0.1898977315009326,0.3940439233070365,-0.590232705493237},
{0.19664186920574295,0.38776679065397124,-0.5758849164978146},
{0.21627750914084284,0.3956840482529165,-0.5333676311028568},
{0.22255704490738196,0.42224906588976674,-0.5305077258095588},
{0.22218856750806343,0.437543681593873,-0.535135121062849},
{0.20838368189826736,0.4486374546862916,-0.5550897743115981},
{0.18004476599882804,0.2881519296400416,0.49674918824829445},
{0.1819948925828303,0.2708621289742991,0.5227666965320268},
{0.195006951005723,0.24935826857276286,0.5357234833450217},
{0.21699123384256638,0.23652604314149409,0.5305419701765607},
{0.23122968117493023,0.21821912469795865,0.5408479225684797},
{0.2277671951780727,0.19829090569742155,0.5587849617965035},
{0.2281819325117622,0.1801920568288274,0.5748357572070374},
{0.20950713744727664,0.17466389454176828,0.598289944452032},
{0.2117934996581571,0.15842064979387294,0.6045362371488501},
{0.2062014546045857,0.14079541453907682,0.6151457828762944},
{0.20620806316663867,0.12498152606517003,0.6268311224021842},
{0.21114325720403354,0.11095034726992291,0.6271503359752896},
{0.2127345188426125,0.09148332579690248,0.6313397637979766},
{0.21432117451369995,0.07176838311716659,0.6379060711057245},
{0.22124053924264275,0.05263038793060289,0.6340544809855648},
{0.23862566340951333,0.04992928838603293,0.6224308213721697},
{0.25029558295727944,0.03558069835278586,0.6117117337222104},
{0.24748293889563316,-0.0069906570953327,0.6182005406204277},
{0.23528153075124128,-0.006543878248658953,0.6276433747563342},
{0.21916284738507208,-0.016152927733171087,0.6405607104564673},
{0.22411586451406437,-0.040308423593607874,0.6374194406272766},
{0.20802381565556333,-0.04635886254230981,0.6495311325353127},
{0.17311699037272688,0.0799802223761105,-0.16436995771721843},
{0.18643564602298737,0.11214449440695362,-0.17175432490334477},
{0.18163342426447704,0.07894448046889552,-0.18000741761025585},
{0.1865043350164473,-0.23412473200278278,-0.1938006881715951},
{0.19915652719663593,-0.22211437137955933,-0.179635936319095},
{0.21153256158679185,-0.1901675811180966,-0.15476591471911008},
{0.2242175963177893,-0.1785665508232466,-0.1414893135546414},
{0.24519197071726126,-0.16357292508173588,-0.11578801495217202},
{0.26547905466322164,-0.15564024750466704,-0.08638351848655117},
{0.257276827858173,-0.1123423507496312,-0.0821430245025455},
{0.24094707102522026,-0.08511527535074441,-0.08656615511056125},
{0.22110155918007368,-0.06693211725111053,-0.0936271032750031},
{0.24271736461759855,-0.038994721561254754,-0.06524393003575434},
{0.2440727206168311,-0.02044268554339001,-0.054433924592702305},
{0.22415892029713697,-0.004878120092391706,-0.06401894294247629},
{0.18929655261356612,0.0039571268535514605,-0.08110327740620749},
{0.18137709216060324,0.04884528394988546,-0.06631211397486585},
{0.17480738044210076,-0.22942424204799736,-0.5983179807758932},
{0.1763089258443239,-0.22092563124784467,-0.5649201104951574},
{0.17469102969807682,-0.19369475091929103,-0.5306515120990756},
{0.1814057292628329,-0.14982291056292532,-0.510604939759953},
{0.22313299110327336,-0.37650720273185934,0.2201814671087861},
{0.24231724622420808,-0.36460177806365923,0.23443193000851903},
{0.2572277642914159,-0.3650413475699116,0.2474550027015},
{0.25492778443751724,-0.3223262058322763,0.2617325006278134},
{0.26366650632559546,-0.25611422158548613,0.3163654831199301},
{0.26061735584623436,-0.19274612187550189,0.35905999813358186},
{0.27169070247412547,-0.16100780170789272,0.3984418212235772},
{0.2546370077071854,-0.11425983504228078,0.400052708288859},
{0.2380779537969393,-0.07573992865156094,0.391338017535519},
{0.2300551594646023,-0.03879526314292797,0.38650175166946293},
{0.24560070026726624,-0.013968898104384035,0.393502221478147},
{0.239073643812924,0.019830492385935216,0.3704960146365631},
{0.24373608447104067,0.03971485456557515,0.3566076208335519},
{0.22067240316554126,0.019904388125255093,0.3355835820889544},
{0.20996072511545955,0.008326187408406325,0.34174977100331183},
{0.20686631599900832,0.01080079350806906,0.30880288501782904},
{0.2398222136600179,0.03173872068652145,0.297164806723591},
{0.23796140279345918,0.019674490269593288,0.2773831776449568},
{0.26145864582152634,0.025878528221163342,0.24687304872192412},
{0.27375717980215164,0.0039056601733205632,0.20083319949326342},
{0.27592278556097277,-0.03818767595296465,0.16098196823804917},
{0.2656809161950222,-0.05110681398820311,0.16695190288537826},
{0.258436930887658,-0.09058816602790574,0.14947866455780104},
{0.24177734673042392,-0.10472828596729922,0.15444910425947855},
{0.23269738272906373,-0.14929823078780866,0.13581035589710028},
{0.21347567908982878,-0.20213909140682668,0.12494768221708043},
{0.20517592592963443,-0.5082783253983861,0.5682822665044832},
{0.22194725486340103,-0.5017248346958318,0.5513523320814446},
{0.2365415632493458,-0.5176664887027632,0.5310732585137303},
{0.2419319470305728,-0.5281148255680059,0.5255967631663583},
{0.24312649468651584,-0.5385066892666138,0.5332066225001111},
{0.25430838193964095,-0.549188728917185,0.5432740658797538},
{0.28503979756172093,-0.549244401045995,0.5270764802878609},
{0.27002133964764746,-0.5770293992897196,0.5501894254195736},
{0.2716023880539627,-0.5949946751010609,0.5484974332745505},
{0.2493083038384531,-0.6182079502203054,0.5731613878941556},
{0.2346441049023114,-0.6238440523542301,0.5958615982867402},
{0.22786512205213072,-0.6425012245865743,0.5998347458967838},
{0.20355462537263277,-0.6627680823274634,0.6277066567444781},
{0.18678990500091916,0.5497935124747623,-0.3271110050181014},
{0.19159713324583327,0.5659005807924746,-0.3017751799231083},
{0.18283958696887687,0.5822065067501454,-0.3173523617198442},
{0.18639158894263405,0.5092127360207885,-0.5315310516304924},
{0.17953810957476504,0.5053038716961695,-0.5537292115665055},
{0.1965910033038805,0.5001391803220251,-0.5347786592308995},
{0.19526989167164976,0.5082971497872643,-0.4938031713888513},
{0.20825050935992667,0.4939862085317738,-0.49534797283360316},
{0.21850619662835166,0.49545411034536335,-0.4685116036336678},
{0.23520463112007917,0.5013896003662345,-0.4539002731939501},
{0.23480210961321485,0.5171341990683129,-0.423203101938872},
{0.22526295067889957,0.5134928813771121,-0.4116106828006365},
{0.2209403503178718,0.5013611635234609,-0.3912086499268452},
{0.22285863564834593,0.49034569187839766,-0.3607347679653759},
{0.19448567564136093,0.5001247616411824,-0.3315151109777828},
{0.18825039721463124,0.5083245853327572,-0.3238329579803593},
{0.18282636984477088,0.471125790574268,-0.5709447159740159},
{0.21170698757309972,0.46112243022059374,-0.529174598609959},
{0.19259021988888803,0.47609002223280483,-0.5565730961033114},
{0.18824138553910444,0.49299792811566656,-0.557522325925469},
{0.17642447555052324,0.4972360189861985,-0.5647905426270275},
{0.1978314103752822,0.49038874766147017,-0.5452726552521446},
{0.20553098594539082,0.48584365904465826,-0.5281839150803781},
{0.17649516713854468,0.3857838215191602,-0.6096682862316417},
{0.18051737831534534,0.3704817962151763,-0.6069303389471399},
{0.20108542627828616,0.31357907304703975,-0.5219974999609494},
{0.2110609505675553,0.3101876791571159,-0.4887021625217632},
{0.23215007363540202,0.3092146184596763,-0.47332924537030174},
{0.2355693035897308,0.3193014870065657,-0.4735519338855421},
{0.2318699106562462,0.3313887472609513,-0.4792775519963665},
{0.23138388095616677,0.3445912524266439,-0.47975957650732287},
{0.23336664983152167,0.35144733516744286,-0.5050126944469254},
{0.25504213258697966,0.35684572932691594,-0.4745712545173526},
{0.2740757925968885,0.35544130976092625,-0.4344388589857019},
{0.2502128758018889,0.37364629614128064,-0.4797639822153582},
{0.25236626573388476,0.38643085982198533,-0.46605762425798863},
{0.20567637431055671,0.3796488730799623,-0.5550028617076284},
{0.1724631432483926,0.15278114324919362,-0.517975689303061},
{0.17655744782940777,0.153269776322203,-0.5182860914600956},
{0.16993426683611285,-0.21196101669322773,-0.4939898132019845},
{0.17413030322085293,-0.17838952146400877,-0.5127318954437369},
{0.17550208049548996,-0.2426846221965178,-0.5606593903060805},
{0.1723774322011598,-0.25402331260380945,-0.5478660152093052},
{0.17508053434029128,-0.27575126333677913,-0.5355580690342407},
{0.1814601998349061,-0.28013253971845925,-0.5544157009821925},
{0.1912745152619734,-0.29110695817501153,-0.5483208044342249},
{0.18955108238233453,-0.30422895903933134,-0.5318232301770173},
{0.20611714537354592,-0.31307522025536283,-0.5262638274147986},
{0.20001343740950775,-0.3370304566596482,-0.49762131817983374},
{0.21606223022548013,-0.348881210496319,-0.482220164445055},
{0.23667353423094958,-0.3811137710017098,-0.4449060202398227},
{0.2269403238836236,-0.39530295450786035,-0.4244136703513071},
{0.23999904275979958,-0.42052663430740866,-0.40571364259534654},
{0.22534185290462322,-0.4161189236775165,-0.39470057406375697},
{0.22676930230807033,-0.42201015635857814,-0.3719148528833957},
{0.23354267789347877,-0.45265746300907445,-0.3318899966796982},
{0.2380038577981633,-0.4334201391322597,-0.2995328747925812},
{0.22958995674796262,-0.4033896316067096,-0.3022117455375184},
{0.23870897134327232,-0.3980449069814852,-0.2708282851262095},
{0.2266944052714697,-0.3797129561059308,-0.27443335585584683},
{0.20342946321253813,-0.6094970643966322,-0.5850900426592693},
{0.21548007598644803,-0.6176506281538361,-0.6080762235552382},
{0.2555407786327966,-0.61921405372801,-0.6244318138580344},
{0.25717709864900967,-0.6358043481134156,-0.6678765007944293},
{0.2377573384076409,-0.6446556158158511,-0.6992221121685255},
{0.20365355354397155,-0.651109577568698,-0.7260871184706906},
{0.2762518118474295,-0.6473052486801899,-0.7184646427912003},
{0.24048327012477363,-0.645894020292691,-0.7637937712099796},
{0.22169212431626414,-0.6455415636498646,-0.771321123647798},
{0.18919021484234974,0.5379243347681256,-0.17628279198529614},
{0.19727308701153212,0.5339283575800807,-0.18062441699465828},
{0.21157201269965367,0.5453653753803427,-0.16106387435561514},
{0.22180767402246346,0.5536120597846569,-0.16431228299384681},
{0.1985052834452316,0.5246791743382726,-0.24265898898613042},
{0.18949741284808597,0.5107771628922431,-0.2665313179755691},
{0.18675505985554883,0.5044665869100006,-0.29806557375736},
{0.20747710734027006,0.48177679000913587,-0.31121100497804954},
{0.21908034048913771,0.452636836285091,-0.28366751963844355},
{0.2197193684137168,0.4325109612013325,-0.266742791961265},
{0.20526363957142874,0.43748520583267686,-0.2582770237119211},
{0.1981424133106853,0.41831957484116417,-0.23446757619171396},
{0.19231185924483757,0.4170028689169688,-0.2120415209946006},
{0.19434269038966884,0.10306813507580419,-0.20162102019376302},
{0.21362587368194233,0.10359682004004385,-0.22920435716514317},
{0.21008548675664188,0.05298424638962239,-0.2621508426317136},
{0.21111682295582151,0.029191220144819622,-0.28546144384664773},
{0.2181229000292779,-0.09010093477108942,0.634272964052226},
{0.2279896834338569,-0.09494240738300541,0.6249639032330286},
{0.23710409206167507,-0.125554268109763,0.6094706301484202},
{0.24799380076827537,-0.15267180158613497,0.5859373404182459},
{0.23767643358735577,-0.18057214927660276,0.5841414136154802},
{0.2433355655587379,-0.19750989381843115,0.5652587492355095},
{0.24508883709734328,-0.22003808133818173,0.5528180310410167},
{0.2310714762045706,-0.225767504378673,0.5664959521556128},
{0.24120200131290095,-0.24231934894849763,0.5460977242114884},
{0.22609823287050698,-0.26277084590795835,0.543151306833133},
{0.23653435390892438,-0.2793040663483609,0.5251682079301943},
{0.2659152197587194,-0.2590316013426996,0.5047495535215424},
{0.27798225380803365,-0.3039209599957705,0.4598313575067857},
{0.2869967329672323,-0.32316128776442754,0.42906589777716003},
{0.2904718353098274,-0.34839197664494115,0.393817029343217},
{0.28574751447975993,-0.3699485052834452,0.4060540836708038},
{0.28529893329798084,-0.36628495879261164,0.43008501814951444},
{0.1779889024219779,-0.15399892100205023,-0.45543205777405205},
{0.17803015586994508,-0.1668591827571802,-0.4763335377314849},
{0.175088144199625,-0.1806007863788324,-0.49605729182729136},
{0.2041385819467702,-0.5112848206135869,-0.05042493054000764},
{0.22789195681925498,-0.4767486755840867,-0.053238776158390816},
{0.23406074910654243,-0.5003378377025273,-0.08249007414005587},
{0.22816931616602468,-0.5265513999938319,-0.0960139957328715},
{0.22988814307817207,-0.5648432108639954,-0.13077863680184046},
{0.23336424671804787,-0.6014754716210321,-0.16700717449527608},
{0.22704485931973464,-0.6399437110720648,-0.211044629421879},
{0.18293891565912795,0.5542715141737635,-0.1370301362445184},
{0.19761272704916488,0.5768179253040239,-0.09338779322490218},
{0.19558950576366738,0.5613651046295579,-0.11907327133033557},
{0.21733027310183073,0.2520553629282098,0.510475371891823},
{0.2335544932013917,0.23582793867735038,0.5141623487390262},
{0.24390310085747094,0.21213123723095642,0.5254818142385274},
{0.24422271494948852,0.19693895410894355,0.542878753713311},
{0.2489452334444506,0.17311248453496347,0.5546960642208044},
{0.23080312853332777,0.15950084930035352,0.5865713618564211},
{0.22754010095479701,0.13910943017773827,0.5984946096162187},
{0.2425349282530446,0.12422915128840926,0.5930325329496895},
{0.23782462558490777,0.11007481292762902,0.6046109339259944},
{0.23369627689634687,0.09307899314351675,0.6124032296243012},
{0.23890482509138836,0.0742347785791271,0.6174621840055976},
{0.17667159571941404,-0.2600487191204925,-0.5971925226323224},
{0.18470520406238322,-0.2738335787846734,-0.5845725722245741},
{0.21230876723883463,-0.2888886841792226,-0.5810612229204156},
{0.2043464512622553,-0.2886812153826498,-0.5616446668303453},
{0.22070584649471853,-0.30909666564000315,-0.539447508191613},
{0.18653617626997535,-0.2779895632781832,-0.6110568853005954},
{0.22362282573301964,-0.295470211205638,-0.5996971676504078},
{0.2574704787522714,-0.3207629805175585,-0.5825948098356231},
{0.25653686916769364,-0.32202882053989146,-0.5613667067052072},
{0.23490103778455365,-0.30625538447612727,-0.5613657054079265},
{0.253976351761342,-0.33693172874776556,-0.527749952838898},
{0.23977995891476997,-0.3463527346029515,-0.4972334156132685},
{0.18938827144448345,-0.47302685359151314,-0.0031510825425421283},
{0.20913645719394047,-0.4740013161051458,-0.025119945401261883},
{0.23420012968802376,-0.4373197915218958,-0.030723805762746224},
{0.24359590285173466,-0.4454589365982567,-0.05383494855935351},
{0.24536118995770917,-0.45856011047913675,-0.07553786686030421},
{0.24632624027690275,-0.4768003425237738,-0.09385680087120873},
{0.239479769989999,-0.5194339786627553,-0.10850217541847218},
{0.2438396186098709,-0.5498718139221174,-0.12566781522140086},
{0.2508396878996428,-0.6052934181525584,-0.16224540514690833},
{0.24616683374980625,-0.6590720938047333,-0.2105431797436759},
{0.23658562032969915,-0.6679461910851698,-0.2276835868551295},
{0.21997990596616976,-0.6692793182847697,-0.25211644206233597},
{0.22083481358448,-0.6914188022001304,-0.27790785742007346},
{0.2142450759203624,-0.6916270720345279,-0.30677205387299783},
{0.21327942482280038,-0.6881419567191251,-0.3431581957584246},
{0.20413497727655952,-0.6758996956456784,-0.3582601618657132},
{0.21712080171069634,-0.6670067739763638,-0.4101183493333963},
{0.21426870653618824,-0.6442400774443368,-0.4666275626701955},
{0.20060400254569818,-0.6484415208343929,-0.4436399799580336},
{0.1964690452950843,-0.6285327270011026,-0.49549836768517286},
{0.18489825417811315,0.5833587996608405,-0.2893755149171266},
{0.19955904870350022,0.575765161343036,-0.2604312146817417},
{0.2101049119238886,0.5955269647355113,-0.20226305201018438},
{0.2144761753327611,0.606937147768649,-0.17199083132105955},
{0.21883782628773837,0.6216700356982506,-0.12733036922636967},
{0.20533973816476622,0.6270425963878801,-0.10973857730075083},
{0.2079971811478952,0.6366091908676881,-0.07261968606526617},
{0.20031122322080486,0.6281832742501184,-0.06680695509101593},
{0.2051579025785808,0.6229673164551994,-0.05216919040308625},
{0.2171826818826471,0.6222329650294922,-0.03271098034613646},
{0.19409536996132187,0.5860198473141802,-0.08732453767100655},
{0.21968792767910103,0.6053995556643186,-0.04163153782040011},
{0.2226685894244583,0.5947868057855759,-0.0537558460741737},
{0.21662816344856395,0.58558848844563,-0.06959857190976629},
{0.21468684828063236,0.5725908487035802,-0.09513005049341929},
{0.21209909558824408,0.5529421919038306,-0.14006887323215958},
{0.1967652290307322,0.5508376652791355,-0.14398775052958612},
{0.22658326127330564,0.2983745740982016,0.3571451172138622},
{0.24037492975899571,0.28629632551934286,0.36668948289403747},
{0.24618946306835135,0.27488213729708205,0.4079711674445411},
{0.23191116410421336,0.27030881209695273,0.45410293576357524},
{0.21554455953132876,0.27458234889122346,0.47420097478292866},
{0.22902382326542267,0.257046629613327,0.48222817482330105},
{0.24039695829917238,0.24024506150168157,0.4961970729276851},
{0.2576505120033515,0.21993234434533376,0.4943282516828803},
{0.2640471995517392,0.19655285387748367,0.510571896949688},
{0.25947006942194306,0.18430378398252775,0.5281122221950759},
{0.26516044186848475,0.15501403618528162,0.5360202678590381},
{0.2596683262835329,0.14672189288442103,0.5542989497192562},
{0.24727366776395493,0.14908535498591974,0.5716530336704233},
{0.2566812562355788,0.12655516487160764,0.573579930157512},
{0.255395790786543,0.10178807663208451,0.5839463609051887},
{0.2522499149898608,0.06802813725462711,0.6025847087486547},
{0.26636840690798996,0.04204667567300195,0.5857374814810067},
{0.2613795433363465,0.011044108747292992,0.5976024537390643},
{0.2566532199117176,-0.03214264400957881,0.603433007804912},
{0.2461261810802075,-0.0428270867736239,0.6189034513115191},
{0.20856772033847054,0.18236487192807002,0.039116679570050945},
{0.2063150017162235,-0.39858060102669013,0.03448307627362009},
{0.2046638625002553,-0.44856195687132244,0.00037969192886302554},
{0.22311536827113207,-0.4234370049836568,-0.0039853634368688185},
{0.22759497204578247,-0.3919424005741839,0.01311158737259993},
{0.2474274670262792,-0.3909148693046711,-0.014975602390457083},
{0.25182796831574983,-0.4085593294672577,-0.04215741915225366},
{0.25587300907055177,-0.436013298829964,-0.08246684404314229},
{0.26153674700942536,-0.44100316369888826,-0.10417036312246147},
{0.25945164555197714,-0.4795158607491866,-0.10997688605357099},
{0.25285730192036804,-0.5229411225183347,-0.1169651400354299},
{0.27095054352418996,-0.5637848396382353,-0.13156145101593625},
{0.2662588649854752,-0.5927251346844973,-0.14832537034982524},
{0.27775395802802105,-0.6371072361351366,-0.1766154229419636},
{0.26422823410010005,-0.6573028015096358,-0.19658910083904707},
{0.25514086049886225,-0.6934762678526297,-0.2345392690770162},
{0.23673261077051427,-0.6927192871083775,-0.2534603832725679},
{0.22688505227372582,-0.6831667107905001,-0.2559978708414622},
{0.23480130857539028,-0.6994325848569407,-0.27185241198496773},
{0.2213314570357355,-0.6982406405739274,-0.3129300321496531},
{0.22947160340937717,-0.6980049351940373,-0.34168929264755415},
{0.2205766791455009,-0.6842188739731194,-0.37140339023238506},
{0.23571088702522985,-0.6706296677975986,-0.4221150923136015},
{0.2385619809024572,-0.653926026560011,-0.46629753508645794},
{0.21552593540190665,-0.6337072310885983,-0.49390089800345327},
{0.21658891259515825,0.29971090544909984,-0.4811674004840671},
{0.23474823981951012,0.28943278912158593,-0.46395750334132896},
{0.24144892122233563,0.3079581906317825,-0.4464323978146086},
{0.23673901907311112,0.32784996241130004,-0.44916013186684667},
{0.24082130808675717,0.3325140051450659,-0.43265474749084915},
{0.24492342278656223,0.3388694392454864,-0.43660065981485613},
{0.24179997604896902,0.3487169977422749,-0.47013050107719556},
{0.2630795458596157,0.3426615523071691,-0.43683195948671094},
{0.27536125804592426,0.3456374078255788,-0.43035737100988036},
{0.2921934658543609,0.33245853327571195,-0.3985509626271797},
{0.2998828281922058,0.33387957437656224,-0.3825388172916831},
{0.2878288110075414,0.35042300804922855,-0.3912747355473752},
{0.26720609221307123,0.3668516930535201,-0.440234367646723},
{0.2700615917983339,0.3766549942104991,-0.427987700865241},
{0.27271603088962054,0.4065467219329363,-0.4423589202170332},
{0.2580041702029149,0.41018563651066314,-0.45776227680582965},
{0.24475400328665817,0.4033674028070767,-0.4824030013285212},
{0.24936938297257927,0.4196346786897104,-0.47815149307442717},
{0.22661550304574604,0.4174983108114874,-0.5116088404136399},
{0.2296077798395601,0.43947197989715464,-0.5059495081828016},
{0.22753869913860394,0.44097392581829015,-0.518928123276517},
{0.22467619047237603,0.44911006700280875,-0.5235234770168229},
{0.1904410354054713,0.1653702537006946,-0.45423991323158286},
{0.2071084296814953,0.15926294106644567,-0.4394421412381882},
{0.21166313075220253,-0.29360539514995626,-0.6191457652534623},
{0.23935981457576433,-0.3101290031364636,-0.6112012723684805},
{0.2589327733010889,-0.3291556540654071,-0.604009755038628},
{0.2710388579443527,-0.3423323257612562,-0.587647956692691},
{0.2806651297420938,-0.35300174906609,-0.5550875714575804},
{0.26872986641492713,-0.3460645612455497,-0.5374601333487666},
{0.18848349922159147,-0.6077726302197125,-0.5622278223666582},
{0.2036525522466908,-0.6087911498136985,-0.5607603210719808},
{0.2290929127777949,-0.6115276952820073,-0.5897685040738782},
{0.2619647014672209,-0.6097570011707167,-0.590771002911372},
{0.27965201715342397,-0.6061186873713582,-0.60930101038906},
{0.291903890680766,-0.6208307483175202,-0.6521296992383331},
{0.31065478433858906,-0.640139765079637,-0.6912632006027007},
{0.19677524200353977,0.13388045551816935,-0.18329167269113864},
{0.2071308587405843,0.14529063855130706,-0.1962400486069752},
{0.22423101370135143,0.13319937310779847,-0.2247960457568826},
{0.22736367237392766,0.10048498835090741,-0.2525405915904646},
{0.22612266452415747,0.06225085220411564,-0.2846309678819879},
{0.22557335283593422,0.03489500997492351,-0.31861079214229954},
{0.21513723179751681,0.017120381165838455,-0.303363437669845},
{0.20509381955261238,-0.022524983368452163,-0.3248897271304702},
{0.2067089120664733,0.05606643967924843,-0.046378888487924964},
{0.22168090978671967,0.08801703487037807,-0.018343365664555005},
{0.22052140753560312,0.11969207304984338,0.0005384976775910752},
{0.20562370607358893,0.16220455221785343,0.01996907192959197},
{0.22489567483631795,0.16765561461429426,0.039720862349259686},
{0.24754902451616312,0.15634556130923224,0.05704230400907414},
{0.2057386550014198,0.027700488753228676,-0.061162642319389005},
{0.23285478666159873,0.019758999760089182,-0.046554115512057424},
{0.2362511870379263,0.05394388970349985,-0.024934705404321845},
{0.24620948901396647,0.07562818387502847,-0.0046466201610807015},
{0.2448297013610834,0.1108732473793046,0.017020651956675053},
{0.22471664288251855,0.1386626513310645,0.01852840540203887},
{0.22825763058618748,0.1513258577813415,0.029033215433916168},
{0.2569974659168418,0.13084912813040572,0.04655972277682965},
{0.27224061494071716,0.13455112443682032,0.07437616175516998},
{0.2542839502859905,0.17416404693921442,0.07733539573871907},
{0.26874668820924386,0.17687836360789036,0.10478716224740772},
{0.24966957189735017,0.20241925438598246,0.10626768040673494},
{0.25861536206308894,0.20420797184832667,0.12490783058530629},
{0.2711750343745356,0.22214040510885905,0.17442198111873738},
{0.26992381329250176,0.23927860936629497,0.20393321587448698},
{0.2700920312356689,0.254955320112738,0.2428720650474755},
{0.2801330403670996,0.24027570119847272,0.24552550284148142},
{0.2772805446736792,0.25208299873315865,0.282630976693404},
{0.2665586533913338,0.26592353052614964,0.2954203466010563},
{0.2619168394572007,0.2707626000245918,0.3257955006506429},
{0.24246684003795313,0.288120689164882,0.32298205555117204},
{0.2488629268079724,0.017677903491763926,-0.03133439684455181},
{0.2584837916003974,0.03857758111409141,-0.009741821503940514},
{0.2661138771392215,0.05663958224275372,0.010506011588614198},
{0.25621585325948293,0.08355205003602667,0.014239248370188404},
{0.26153113974465314,0.10433117146575102,0.0320651436000482},
{0.1908003008698069,-0.11183309095263821,-0.43318523479019416},
{0.19413782496602597,-0.09158746071410118,-0.4298010502406918},
{0.203750679380205,-0.05802858183061974,-0.4148348600446739},
{0.21054668428415851,-0.018264263179375205,-0.4033023184838277},
{0.193038600811211,0.5268469829511114,-0.2992773437265321},
{0.20204226595977748,0.5609547730039038,-0.2630864548108529},
{0.1939816225902279,0.5209277139461885,-0.2816318822666647},
{0.20882104855050201,0.5419980126251571,-0.22476580657900375},
{0.1943963599239174,0.3945792168333292,-0.2042928818577349},
{0.20020007922264083,0.3761102884897673,-0.20109513886190952},
{0.20229739650691433,0.35793534102783564,-0.1828438925471841},
{0.2020370592139175,0.3490129812184666,-0.1641212354726784},
{0.19240798378379026,0.1245984297255524,-0.16102101883199874},
{0.23367945510203017,0.1743615027629797,-0.2318275557812702},
{0.24160792723051983,0.1475389514655187,-0.2625834030570007},
{0.23717858857936341,0.12282773561426182,-0.2646462757148161},
{0.2412110129884278,0.11328577304756042,-0.2961797304587824},
{0.23122667728308793,0.0671237655506474,-0.30440518736074457},
{0.22891568315910088,0.0428040569361665,-0.34013567978673165},
{0.21973258553782282,0.003162897850455044,-0.3550359846216758},
{0.2152704043358575,0.0037692834836814586,-0.3304689555788479},
{0.20953917896026092,-0.033547464094480804,-0.3807176577974423},
{0.19711848671138324,-0.08256477091720033,-0.40326146555477277},
{0.19929851115104727,-0.30168085771926106,-0.6476498952042266},
{0.21610949145713182,-0.30222696525618586,-0.6326492603817505},
{0.21984453057381143,-0.31800420624961695,-0.6469127401461333},
{0.2435258120420817,-0.32825008080469054,-0.6280573110521992},
{0.26849536259177387,-0.3646698662787507,-0.6167999259841049},
{0.2803184806234958,-0.37047799128550946,-0.5986389966841039},
{0.2944946472649965,-0.388763882486149,-0.5726240917733014},
{0.28886315109856325,-0.3671416687460273,-0.5689829743415569},
{0.29304456854300426,-0.3750423048101119,-0.5469592403918516},
{0.2867900652084841,-0.36913685370766364,-0.5255741338478132},
{0.27932539398044104,-0.37131387425548534,-0.5067843898554967},
{0.2607937844271037,-0.35785904217504194,-0.5023466403071819},
{0.2545903472539021,-0.3727675576476883,-0.4697874566288082},
{0.2366989671818808,-0.3648458943407078,-0.4673114487129525},
{0.2606071426139706,-0.4014979807839036,-0.4404222110165931},
{0.24462483593744053,-0.4097943295333434,-0.4188096097303666},
{0.27268739378739093,-0.42260913239192693,-0.43180164220764417},
{0.25853385646443533,-0.4496415555994346,-0.39436053350721195},
{0.2371267213802202,-0.4446769234219855,-0.38555132029056843},
{0.23127233643909043,-0.4485651610226208,-0.3741747808460641},
{0.23136165215653398,-0.4519697720366507,-0.3576958307182786},
{0.23606154133295093,-0.49192313561450207,-0.3333995524601674},
{0.23747977880141508,-0.5011917440235568,-0.31329089968963786},
{0.2413089398624858,-0.4810953070798526,-0.29588775217171365},
{0.2453589871036915,-0.4700772320618593,-0.266266574974537},
{0.24904716550763167,-0.43205196652783345,-0.2528155478237604},
{0.24591350553777472,-0.4053321483313781,-0.2503996177447501},
{0.19699352481074478,-0.6133680796840385,-0.5343681273457891},
{0.21380550641411006,-0.6229528977743564,-0.5258791289995318},
{0.23315397428908893,-0.6156270063494262,-0.565304408391512},
{0.2552996662475903,-0.6142572316693506,-0.5716810699942846},
{0.27472383219699437,-0.6063073317790529,-0.5709312985904537},
{0.28085577674434997,-0.595378372219047,-0.5907027144368243},
{0.2988004258317075,-0.5980986966714075,-0.6277519153815683},
{0.31408983478995384,-0.6064677396034301,-0.6594337623825428},
{0.3129701841706114,-0.6299173208809333,-0.6784447930739065},
{0.32815485743329054,-0.639672559768436,-0.6978487328182393},
{0.33089040160431854,-0.6445568879039683,-0.7133037563467228},
{0.3225365783909633,-0.6474488347102506,-0.7249838891267526},
{0.2972636347652018,-0.6490597217755324,-0.7479186033424905},
{0.26600613755181207,-0.6439541069409527,-0.7516444305241871},
{0.253246205784214,-0.638950424169554,-0.7682607586388925},
{0.2340192953991191,-0.6489786166957909,-0.799245502473004},
{0.22251238704866022,-0.6480492125597924,-0.8052759154760907},
{0.21407425460426527,-0.6390084994118378,-0.8002219675811981},
{0.2058940563393933,-0.6365006502424541,-0.7827937876312551},
{0.2069778605160846,-0.6234994058301935,-0.7904989704661358},
{0.2169319570435456,-0.6032866181424653,-0.8000030839956246},
{0.2177890675158735,-0.5809320555711979,-0.7881146813811974},
{0.20906376301135748,-0.5658050570318904,-0.7776979855100268},
{0.21604300531768955,-0.5462807613544108,-0.767111870138952},
{0.221896989739907,-0.5447209404504475,-0.7439913151479055},
{0.23907764900204703,-0.5479753568723639,-0.7590398119804017},
{0.2437721311731479,-0.5504679863230801,-0.715059430998802},
{0.2391277138660849,-0.5435776592152793,-0.6990546952631829},
{0.2502399108284693,-0.5493008742126299,-0.6927204886651145},
{0.2615379485661623,-0.5575481593953125,-0.6803128132808867},
{0.27199930229605473,-0.5491709058255876,-0.6369406202676187},
{0.2859187363147694,-0.5546393907947136,-0.6161627003946312},
{0.29215621759551674,-0.5659228095921075,-0.6069633817574048},
{0.2796385997698618,-0.5516280893525651,-0.5732799414921973},
{0.262229444468253,-0.5262840536198699,-0.5631388026326909},
{0.24723361587272466,-0.41396753634008215,0.22729468299128347},
{0.2582090356265577,-0.4280089283675931,0.23605643471681909},
{0.26831492882178143,-0.39073063060501184,0.2582515907609899},
{0.27168068950131785,-0.3579379444007656,0.271299896145446},
{0.2758617064268466,-0.32953955144284935,0.29227627313947946},
{0.273071090905377,-0.2982059556361221,0.3030045727244217},
{0.2846130446606623,-0.27906175240641773,0.3411019316626621},
{0.2767382420664212,-0.23119914160786714,0.35510427309622344},
{0.27030150262680325,-0.19234319984972528,0.37292095639110023},
{0.28603929250737253,-0.21834689023098322,0.38972372605948263},
{0.2818356462632987,-0.15408463204928305,0.42675510391262916},
{0.25850521936220566,-0.09505375164062559,0.41227834782744516},
{0.24806248976173528,-0.05127042596387879,0.40054013980513153},
{0.2636532892014894,-0.018103054317173323,0.4210186717911726},
{0.25663519656066397,0.006492011049515764,0.406037061617031},
{0.24815541014938952,0.023973259755339017,0.379914216859363},
{0.2615073088693711,0.051715202215991046,0.37456688886120854},
{0.26246955555617857,0.05856587795147392,0.34656801351831434},
{0.26082162049150875,0.054869288650375415,0.3191134433772395},
{0.23945393652015548,0.03584243746197574,0.3237418399278104},
{0.2675869856986712,0.04888213168981733,0.27297566727452083},
{0.2781290439893926,0.04871171089263249,0.2448606414470588},
{0.2868819842988576,0.04314289593597465,0.21488640682868723},
{0.28556868278541675,0.017759208830961395,0.1838804354922237},
{0.2914799414120935,-0.0039429084321647035,0.14150873872188804},
{0.2874525234894329,-0.02562479949021953,0.13751616594459778},
{0.2844636511063734,-0.05610188560298723,0.13052691066545816},
{0.27082898603430605,-0.07292207784405474,0.14498103743209698},
{0.26999090021031247,-0.09627152939348219,0.13327386962548676},
{0.2549253813240434,-0.1342333126799081,0.12674841524679373},
{0.23871237575402687,-0.20512956586553535,0.10350690354423189},
{0.23006617373469063,0.5672515310836719,-0.11769909094222475},
{0.23888419836740477,0.577114309299128,-0.12291304614258232},
{0.23132380311932138,0.5697427587181954,-0.1551736429718343},
{0.21914882922314147,0.5607605213314368,-0.20233354333874964},
{0.20687773078800895,0.4719414473391726,-0.5286276900352096},
{0.21685806130422572,0.47952126775450266,-0.4980574832753315},
{0.24204429258547372,0.48032170480073977,-0.4812222715750526},
{0.26884241222928423,0.5086321838574056,-0.44658960148768745},
{0.26102928954753774,0.5286395053431225,-0.41754356944857757},
{0.262205613592971,0.5391879719364407,-0.3943000551514542},
{0.2517264367714811,0.529820235096591,-0.3865608282090276},
{0.23389193038500677,0.5072828356418575,-0.3873019884562439},
{0.23332079041606305,0.49420609341462796,-0.37634439179400825},
{0.23827500910179225,0.48467454433964635,-0.35685353944570586},
{0.22540613619004782,0.470074228170017,-0.3130922423091357},
{0.2357889882131289,0.4607036876977812,-0.3017793853716875},
{0.24343429347062048,0.4485465368931988,-0.28596609767614917},
{0.24495145911042343,0.4112782521034252,-0.2613295786020368},
{0.23619891931987078,0.3873494499473517,-0.24593663550496017},
{0.21203300996771413,0.3979828265500783,-0.2335503878825406},
{0.20880102260488687,0.3724116965941073,-0.21593636715728898},
{0.21161747159619998,-0.3418693258986343,0.06084543134084518},
{0.2156428869242991,-0.3131851626967899,0.07198346177307317},
{0.22029431331232746,-0.3362238115702704,0.05315566848408797},
{0.21249520879251158,-0.3717570484319484,0.04346831755222065},
{0.22734344616885635,0.46001679776318194,-0.5038503885634228},
{0.26157659864119953,0.4751698300317892,-0.4768724359279883},
{0.28899732493418473,0.5072069373079762,-0.4459015099963513},
{0.28966859463120415,0.5366945414478999,-0.41584376718476457},
{0.3025290566457902,0.5477805044215285,-0.4042889968242855},
{0.30389883132586576,0.5693460447355593,-0.3796997389818248},
{0.3018920313157727,0.5744096050843472,-0.36959344526768884},
{0.2860320831669511,0.5610943538448413,-0.36380794957947515},
{0.2753420331381337,0.5460254305478177,-0.36160669763745906},
{0.26945280305163366,0.5282506014792766,-0.35680647847351027},
{0.24884370190018185,0.5107359094442759,-0.372917952499258},
{0.2489214025691686,0.49590449386224783,-0.36927763610533804},
{0.2542064498764599,0.4860371096793005,-0.3567776411118244},
{0.24566958952018234,0.47765044391513634,-0.33633335349278526},
{0.24935095910261335,0.4682608787945661,-0.3080451032357522},
{0.2678160825165084,0.4665046033641184,-0.2824565507070961},
{0.25660395608550435,0.44524425846126237,-0.27691156662572025},
{0.26624544760191304,0.4162502938807518,-0.2548129356394144},
{0.25989862465810704,0.37182533690649605,-0.2420538049096409},
{0.2460701084324851,0.3517343069681078,-0.23456770591978965},
{0.2291457812742189,0.3518953155708535,-0.22580395159969252},
{0.22229470501982368,0.3819654744687216,-0.23590383701123174},
{0.20444457839576952,0.3449158730050653,-0.19717826415904446},
{0.20047843986669128,0.3325015890587846,-0.17323063761409283},
{0.20438550185620488,0.3105283204920295,-0.16256702183348745},
{0.20699828698061207,0.28802616670157855,-0.15348225160517967},
{0.21447897896514723,-0.6596945001944519,0.6054708480307086},
{0.23038378523214675,-0.6482302471081531,0.584872761149345},
{0.23063751396309054,-0.647343698495771,0.5715691249582959},
{0.2548635011520926,-0.6225193360517887,0.536821706202556},
{0.25165153973488047,-0.6195745207490825,0.5172593612284074},
{0.2657734360637642,-0.6030975732158583,0.4812366902558955},
{0.24697167650407867,-0.5902669498602388,0.45087996007627473},
{0.2405966169769553,-0.5878364008409295,0.440247584770829},
{0.24731612276865905,-0.5807303942988535,0.411837576764456},
{0.2477438769669984,-0.6285904017244742,0.5614107637855605},
{0.2711986649903615,-0.6066954346050742,0.5363112448488261},
{0.28271198164341715,-0.6025001992581588,0.5118463481286354},
{0.2826330794176935,-0.6044196861453698,0.47738349806008656},
{0.29214259995249847,-0.6063279585030366,0.45032243775034936},
{0.2745562150321957,-0.583547243809079,0.4178185256818734},
{0.26042330443322365,-0.5866064072612476,0.44031827635885046},
{0.26188259509019884,-0.572000483826846,0.3920367227780312},
{0.25959983754952914,-0.5712469074933484,0.36241174065118764},
{0.21012974409645133,0.3095071975251136,-0.19235000867123445},
{0.2116723426871855,0.3277892837960862,-0.20316201670884795},
{0.22777620685359948,0.3162106825603252,-0.21547256625684233},
{0.2171416286941361,0.2675336165536068,-0.19875070140874518},
{0.20806326676842515,0.2901727478120653,-0.1756221360394527},
{0.208254915067962,0.2643464873089575,-0.18379132003423634},
{0.2112772307801988,0.21398063330851447,-0.19302348122227156},
{0.21292296299085092,-0.23678317628319248,-0.17912427340862822},
{0.2309821604871271,-0.2129142517045083,-0.15039505182914983},
{0.24828037205002798,-0.21545734653817483,-0.13477140983858688},
{0.2562484955508357,-0.18331570382587678,-0.10871204732851882},
{0.26667700672991923,-0.2014131508782779,-0.10007405594688479},
{0.27508069454785616,-0.15581207011804493,-0.06241045899066831},
{0.2690520838798747,-0.12545694201407342,-0.06305669625566886},
{0.2613124564185358,-0.09565092533886903,-0.06652498977675476},
{0.25206627706857,-0.08211779181107041,-0.06986451646753535},
{0.2557071942408584,-0.06804075360036463,-0.058079447732482206},
{0.22767046986075157,-0.25471200487351414,0.08921398563979491},
{0.23887318409731645,-0.27066987989639374,0.0705892554393472},
{0.2197135608894884,-0.2616095413217364,-0.18806966305545464},
{0.23570928494958063,-0.28265881275780896,-0.1831138422940762},
{0.23945373626069935,-0.2518815377202704,-0.15970771731855793},
{0.23325230168205927,-0.35132517689919057,0.02934261629367007},
{0.2488096577926361,-0.35042240727086005,0.01131045382397433},
{0.2596438946298824,-0.3639971947655382,-0.024500342643929484},
{0.25940778873108,-0.39974330742910513,-0.06447553450250144},
{0.26563485652010743,-0.3918172384140893,-0.09944223736272716},
{0.2703816064092638,-0.4226794234610361,-0.12089162719219021},
{0.28521762795878336,-0.4388681976368583,-0.13132554537658991},
{0.2846122436228377,-0.46661514658391406,-0.12482852784067038},
{0.28498793036257775,-0.4884504363853808,-0.12393557092569132},
{0.2799808431804245,-0.5126213522239412,-0.12249270154412056},
{0.2660996587178348,-0.5338600691055331,-0.12089242823001481},
{0.2879896193508309,-0.5518323539978396,-0.1333327459055953},
{0.2904309823807725,-0.5739419992542338,-0.14137156099442438},
{0.29258457257222453,-0.6075827842552811,-0.15834735483292153},
{0.2987351412490022,-0.6595613276561112,-0.18950211894530555},
{0.28600484788091446,-0.6814004223872447,-0.2073017801864095},
{0.27535885493245044,-0.6978731644718897,-0.22605067124967107},
{0.2643437838062994,-0.7029737728200657,-0.247976077806406},
{0.23994997919304248,-0.6350780070659545,-0.5163489817407433},
{0.2557130017650868,-0.634554929366487,-0.524617494425778},
{0.27631148916536263,-0.6434746858029263,-0.5043107850531148},
{0.2817206973354678,-0.6317148497593481,-0.5225796541999815},
{0.2935117738542055,-0.6261161961437237,-0.515971692925354},
{0.29070273446276995,-0.6005206345341024,-0.5504912164199937},
{0.2842221382022548,-0.5892642507632888,-0.5788976197561561},
{0.2870001373779869,-0.5718344687376965,-0.5839293388514158},
{0.2992131605708356,-0.5836766114177528,-0.6162918677438488},
{0.31766706945518614,-0.5879906006221659,-0.6598244685814941},
{0.32938605256970926,-0.6045041956358658,-0.6861597886221388},
{0.3303721301317987,-0.6264239949278284,-0.688152169951389},
{0.3364792425065915,-0.6320763180777014,-0.6995198979798226},
{0.3397813206790718,-0.6346144064249643,-0.7138342436460678},
{0.3302175298316498,-0.6422919534548961,-0.7360348066955548},
{0.3092902164043735,-0.6507729414229074,-0.7666334502982063},
{0.2971238536648081,-0.6545962949597499,-0.7850931667067853},
{0.28306543958352437,-0.6453735459661536,-0.7684117542688306},
{0.2726791831496887,-0.6374282520433473,-0.7648419292034759},
{0.26088690507421414,-0.6228487628571577,-0.7697240544849907},
{0.25157884555229754,-0.6289330456539491,-0.7806972713848062},
{0.24708702595082185,-0.6376313151318849,-0.7899252271242622},
{0.238510113703314,-0.6487909735853772,-0.8067848704781916},
{0.230909266045088,-0.6563033065639842,-0.8159110944139226},
{0.22821978154897482,-0.65619736931168,-0.8236314969674708},
{0.22152811182167614,-0.6538641463880603,-0.8248256441045017},
{0.21802917860379906,-0.6460686465384551,-0.8185132657871538},
{0.21489151344481908,-0.6357300518551835,-0.8108413260219941},
{0.22072547192142136,-0.6244952961056345,-0.8192193806295436},
{0.22845648822614575,-0.5866833068924098,-0.7954722138001995},
{0.2212381361291689,-0.5623790182560525,-0.7833338873844953},
{0.22244850428214794,-0.5511320466796781,-0.7762673319552812},
{0.2358558748714835,-0.5485234670038501,-0.7709947007342713},
{0.2210532966511412,0.6465364526280248,-0.024981966635973577},
{0.23184988471063106,0.6537872467568981,-0.0015708351740515156},
{0.24265868859694617,0.6554734313776929,0.016898493688422705},
{0.22691549171106082,0.623030398183887,-0.019727959544385713},
{0.21723615115743952,0.5796554015382329,-0.20579442725995803},
{0.23317039556449332,0.5857807375235354,-0.1565620417813319},
{0.22917501915481697,0.6005692975819471,-0.15606039184367265},
{0.2376836429277772,0.6236880502378881,-0.10226008817023335},
{0.23776875319664156,0.6390513549354544,-0.07233371556188198},
{0.22039083837019238,0.6414130147018476,-0.06836697625443525},
{0.2202680793235716,0.6490022473116169,-0.036683527177811585},
{0.23030628482261617,0.6572577431320017,-0.027800818740760538},
{0.241494380118882,0.6706741253968642,0.011487082664299854},
{0.2465629469540737,0.672257176397741,0.026883430172131},
{0.25163271534600223,0.6696141520954548,0.03343271542610605},
{0.25684707106527216,0.6610724855122295,0.02977397516222016},
{0.24757005175905902,0.6476440876799981,0.01666819531384861},
{0.2448585387227692,0.6355293918801199,0.00443875084559554},
{0.23443303143552782,0.6204282268106558,-0.016311933741355308},
{0.23661085302117418,0.6057654296907072,-0.035284915136050275},
{0.23159936013098564,0.5912832666002072,-0.05796069387498444},
{0.2294375593018314,0.5763228839284177,-0.08887935208856594},
{0.2394895827033504,0.5784236056234457,-0.10251321612280871},
{0.25202081817202365,0.600279522148896,-0.07560855844832565},
{0.2462571507645305,0.5962004372865485,-0.1060417877401962},
{0.22682897962600343,0.19252884036557763,-0.21689721202790332},
{0.24117536680523283,0.2138905165532464,-0.23190565696916923},
{0.251673368015601,0.203655456008805,-0.262683132266164},
{0.24731572224974674,0.1778023607385729,-0.2744870253900954},
{0.2533193004857092,0.15197610023546507,-0.31530390774287165},
{0.22549845579933356,-0.43456942815111255,0.21079330380440894},
{0.24222312427981693,-0.45797875727792925,0.2195656692811206},
{0.24858917213141343,-0.483556295536497,0.22929727755279736},
{0.2602566885657057,-0.48975572752057556,0.24811205397713273},
{0.26778844671155944,-0.4224056687844771,0.25322888334125687},
{0.28497471323847173,-0.39774632013236344,0.2916867093005698},
{0.2862223296502949,-0.36845517051892424,0.29460448957669555},
{0.28684133162925884,-0.31070014310540733,0.3232516047791518},
{0.2932702609500869,-0.29280996459012293,0.3651178466821613},
{0.21688529659026234,0.3438787292816573,-0.21154908299192432},
{0.21398233551389179,-0.006791799455374388,-0.3871437834858843},
{0.22154953958348436,-0.3325238178584173,-0.238150347590338},
{0.23392717604928942,-0.32699885972265663,-0.21204792929719746},
{0.23878466941769755,-0.3084764621043023,-0.19673328764747605},
{0.25094161996282377,-0.3030354126806691,-0.17172889195241356},
{0.24812917616063368,-0.27468708458679064,-0.15771693806495696},
{0.25736854668909037,-0.23836021950038466,-0.13035528831153642},
{0.23614885445583297,-0.23446156840802942,-0.15269423064522397},
{0.23299436750253627,-0.36130030066954744,-0.248364981670252},
{0.254496225309511,-0.3560721270478031,-0.2008676441197215},
{0.2537993224021041,-0.3238846249200464,-0.18147411786710863},
{0.2645031903333959,-0.317910284564682,-0.156899478964947},
{0.2594053856176061,-0.299514050403703,-0.14590323222767418},
{0.262365620898436,-0.2756447253061065,-0.13642655424367808},
{0.26543419654504374,-0.2578330484976335,-0.11578741417380357},
{0.27067078106394643,-0.23420203215285723,-0.09631238232253708},
{0.27687021304802495,-0.19917164678557536,-0.07651373119012994},
{0.2818562729872823,-0.18269509977126364,-0.044136583357397854},
{0.2821987166573012,-0.1471933036442014,-0.03140649024876631},
{0.27795341644634786,-0.1078090774407322,-0.039225220195285015},
{0.27623218642072667,-0.08608292904286793,-0.032291036266587},
{0.21875672120799705,0.000941019184455382,-0.37300266224921},
{0.2420743315038964,-0.48980699394135035,0.5283000655649459},
{0.25849380457320503,-0.49573126943267687,0.5033847853278707},
{0.2571080091366374,-0.510562685014705,0.5025320805635781},
{0.2616753265530822,-0.5191213736517031,0.5062240638971851},
{0.264906713137541,-0.532206526776091,0.5200539819390001},
{0.2893199429180446,-0.5301174201295198,0.5122909241212914},
{0.30921051314082526,-0.5344001688587734,0.5054782976824773},
{0.30777745647260585,-0.5631179756492511,0.5140960628590401},
{0.28833466639377975,-0.5812805070249015,0.5313874656004318},
{0.2948230727730848,-0.5913872012579497,0.5184094512850849},
{0.2319692393464973,0.23492336671391453,-0.21508946991722475},
{0.2234634192059232,0.21118340922499187,-0.206609282987038},
{0.2284114298485117,0.17094687877614234,-0.4148082255370058},
{0.22754931288977998,0.16577257494810277,-0.3913001684983064},
{0.24549095808529528,0.18192750527583534,-0.39961093592858904},
{0.2362668072755061,0.1853581500191648,-0.42622541765110866},
{0.22366267736479378,0.023775403412661447,-0.3679625322567919},
{0.23509088374898515,-0.3434852194503198,-0.6502104126105782},
{0.24936597856182466,-0.3549821148279711,-0.6392077575707086},
{0.2551710996767411,-0.3784417090782818,-0.6397564684805633},
{0.27442204119657426,-0.39924005541579666,-0.6145734413506138},
{0.2873910438363944,-0.39230507044927404,-0.5914600956999889},
{0.2993725670979321,-0.41514165753149773,-0.5601531344009298},
{0.3004275339129375,-0.4005545584859744,-0.5423915224564946},
{0.24485152964180387,0.6602370030611661,-0.027415920066037568},
{0.24343409321116435,0.6707640418926761,-0.0003194138325614803},
{0.2557574593643524,0.6785611438179305,0.014376826616564408},
{0.25532569997689003,0.6806993140312589,0.027349033407682986},
{0.25907535803386866,0.6765765726074702,0.03444983320389896},
{0.26263897505608264,0.6701422362813261,0.034965701562944936},
{0.265902803672438,0.6550981451568652,0.019241329065937816},
{0.2562334760916243,0.6447118887230294,0.014183576241378318},
{0.25236646599334095,0.623207627802581,-0.010965607040481658},
{0.24463184501840582,0.6210175903901094,-0.012346195731189336},
{0.24810574580426398,0.6084370910952228,-0.0341860915001476},
{0.2388371373952092,0.5874813408251731,-0.07206416633390221},
{0.2466925148222036,0.5922174769631535,-0.0754501532185099},
{0.2528484905042973,0.6070721226420951,-0.04590447383630232},
{0.25787660492934644,0.6178404741182677,-0.0585899090862121},
{0.24980314495460315,0.6187085988606837,-0.08534437216858161},
{0.23487059834721863,0.27672492481258715,-0.21693566184348442},
{0.2498281773866221,0.26628399754722215,-0.22890356746200374},
{0.25638667457558006,0.2317476522582658,-0.2500349452750984},
{0.25903310328862067,0.21323446657489442,-0.2678213893920964},
{0.26012852251376883,0.19137314304412797,-0.294142090492442},
{0.2581910122755041,0.18357143515138213,-0.307805392666739},
{0.2563820686080886,0.17309946767031364,-0.31105700545626913},
{0.26797448774632415,0.1805220844125649,-0.3498869134851113},
{0.2657099538161642,0.16061969888187133,-0.33953550219664597},
{0.26342098823235377,0.15495596094299774,-0.3456662451872646},
{0.2508973626230144,0.14546466401870262,-0.33485964415496716},
{0.24336940940682744,0.13919974719246256,-0.34150585498571945},
{0.23568745666886015,0.0915361942933264,-0.3144526047947721},
{0.2344410418137739,0.0852184089706624,-0.33497859827192106},
{0.22914137556618355,0.06728096922372624,-0.36144028202939726},
{0.2229277251607182,0.04841953234610761,-0.374664014697442},
{0.24745470231231578,0.15345361450294998,-0.3556543858222713},
{0.23798483314982888,0.16709849280728112,-0.3810384734461969},
{0.23940467269394225,-0.07968423889991873,0.617616183527378},
{0.24956663853688837,-0.11342635518577869,0.5980954925201091},
{0.26010829630869753,-0.1307932557421395,0.576209737335692},
{0.26769492554553675,-0.14140920977218083,0.561966884295293},
{0.25776566119063854,-0.1838700220005038,0.5591456290770321},
{0.2662933096119332,-0.20767246043974574,0.5351567490841134},
{0.26734066656760497,-0.23220804874795786,0.5160419839944632},
{0.256438141255811,-0.41609389124549756,-0.6324914559303032},
{0.28062828200216194,-0.432166514936752,-0.5938527956820856},
{0.29888313298709807,-0.43863910081902113,-0.5526255817036553},
{0.30547166909447876,-0.43428285686935986,-0.5210735028302669},
{0.3042729159899566,-0.42054125324770764,-0.5035870473785837},
{0.29553419410187837,-0.39211202033354414,-0.5144765558257277},
{0.29274558117497024,-0.39772609392729213,-0.4928927919011871},
{0.2832945364013616,-0.3956343839077909,-0.4766139009700968},
{0.26988716581202604,-0.3803407695009654,-0.4786489375635073},
{0.2668846757859482,-0.39146698462528046,-0.46198975392518543},
{0.284396964707475,-0.4150583495977388,-0.45162332317750875},
{0.24383701523694093,-0.2899200203784022,0.05343122549575229},
{0.25464041211794,-0.3043967764635862,0.032227954537899284},
{0.2628995126085356,-0.3257147960898139,0.00359746087030355},
{0.26841926399843635,-0.3313362792834396,-0.018145709581333585},
{0.26712438635496144,-0.3377493881072317,-0.041053188511034906},
{0.2660776301776581,-0.3568259036407569,-0.05393447750906074},
{0.2703892162685976,-0.36354300631898684,-0.07966781762451432},
{0.27175718861356774,-0.3511437418319174,-0.10375842942115805},
{0.2673410670865173,-0.37283464456549903,-0.12456698899093666},
{0.27595502733341315,-0.38156876048608573,-0.1378664197334066},
{0.29913566016130494,-0.4313116073184417,-0.14844993173155138},
{0.2976701614611891,-0.4876670213929167,-0.13562431486233564},
{0.3007066955948126,-0.5246377206308493,-0.13778631595094604},
{0.23935040238132524,-0.5331741804682146,0.23509418803001167},
{0.22613568138880732,-0.6487565289589191,-0.8300363951535609},
{0.22619696078238966,-0.6371440838750686,-0.8281833944057921},
{0.22509232962225856,-0.6150021968462339,-0.8166350323479099},
{0.23270399129111674,-0.6136194053015086,-0.8133690008775369},
{0.24022653750198755,-0.6062376414883123,-0.7944036293421757},
{0.24260241568976762,-0.5760961902240542,-0.7867072579233655},
{0.23193119004982854,-0.5610987595528767,-0.7839781220549343},
{0.23979317603887595,-0.5579873283826525,-0.7799851487587317},
{0.2502557313255053,-0.5620495914506833,-0.7749778613171224},
{0.2556381047284862,-0.5643856180066895,-0.7606745299209655},
{0.24282370238881493,-0.5516258864985475,-0.7323175906704726},
{0.2591354358707141,-0.566006718304235,-0.7104224232916165},
{0.23560955574041725,-0.652752506146964,-0.8232510040007834},
{0.2332833418977627,-0.6370623780169588,-0.825315278474792},
{0.2452836895481786,0.2506325194922541,0.46489832226632816},
{0.2541371601046315,0.2549242798970346,0.4441884906084322},
{0.2682792826385865,0.22821607674903602,0.45002104726884146},
{0.2628808884791135,0.22490959286852044,0.47617793613405524},
{0.25971799062865847,-0.08420189197123792,0.5935776391893336},
{0.2680033251080099,-0.07304824130143012,0.580716376136923},
{0.27592498841499047,-0.11009784276508644,0.5538772033046013},
{0.280015888585251,-0.14097124234157773,0.5343475006218056},
{0.274153092746963,-0.16710269825586027,0.5354293022039354},
{0.27468217823011487,-0.20387053466471158,0.5220363502954427},
{0.2830452133784531,-0.21577035206813944,0.4900509099589428},
{0.2835062106465136,-0.23378409066786926,0.4845301572717613},
{0.2790047785911427,-0.25560075633991397,0.47957433651038284},
{0.26163827855369415,-0.21815203778014794,0.07546757579119506},
{0.26670544357269277,-0.24629469941255888,0.051825945695242744},
{0.23834910510056825,-0.6892628088952046,-0.37432677777328305},
{0.26021703719338773,-0.699627637567232,-0.3541005727019927},
{0.27951283683139877,-0.6899450928623123,-0.3934972149917433},
{0.26133047976958945,-0.6714815715240665,-0.4369425027065065},
{0.23744853832625545,-0.7018178752391598,-0.2940856173258073},
{0.2737569795426955,-0.7026397400472051,-0.30727871029706083},
{0.2980382383415953,-0.70110915702384,-0.362319621301358},
{0.2956942014073433,-0.6841607987308356,-0.4100714886206569},
{0.27355852242164946,-0.6623986036308641,-0.4646774360861933},
{0.26076534758433023,0.4667785583001336,-0.47919164068967757},
{0.29224112760492493,0.49417144852871375,-0.45107981901351385},
{0.30409949130092945,0.5167729310094158,-0.43371391975443385},
{0.23991192989637372,-0.3736062442500503,-0.24491811591097423},
{0.2465377142625986,-0.3766243545137079,-0.2257012184986869},
{0.26282741920432107,-0.39406414951210783,-0.20959475095934293},
{0.2777084991314747,-0.37268945645978924,-0.19267042380107668},
{0.2744953361575257,-0.3390989365822359,-0.17098412703498653},
{0.2660259632379711,-0.331010056629369,-0.16752084000030437},
{0.28186007791694917,-0.32522015523312,-0.1517115574938891},
{0.27054261501200955,-0.3194793174036281,-0.140585342369574},
{0.2704953537803578,-0.3314137796929702,-0.12297692890909463},
{0.27141174105170657,-0.3260584413165697,-0.1010557278009389},
{0.26972635746873647,-0.29315260851959796,-0.11483037423285608},
{0.2742372017185465,-0.2600349012180181,-0.08700572461681355},
{0.2798264431397318,-0.25795000002002594,-0.053066753285556774},
{0.2818496644252293,-0.22347693671921337,-0.05709056653800664},
{0.28423074935886933,-0.22278103510908734,-0.021047869619879526},
{0.2866811240643377,-0.17360071708906055,-0.009264002441563298},
{0.2856003237794887,-0.1408482830355008,-0.0016313135298092292},
{0.2850758442638282,-0.12114876033388858,-0.016264472250247426},
{0.2883765206201154,-0.09527523859912902,0.007227964550872095},
{0.2816365883638842,-0.06100343605174864,-0.005922072637308906},
{0.2726635629121089,-0.04456734144757948,-0.025597363944726795},
{0.2649431603585605,-0.053541368196635554,-0.04410814651462435},
{0.2613953638333825,-0.029120929075710487,-0.038722568960345025},
{0.2606612126671315,0.00027816038459427505,-0.024522170924649988},
{0.3027100911941511,-0.6732556700461116,-0.43033534246970373},
{0.3006700481143369,-0.6511874784971408,-0.47298459884626515},
{0.3106900300028717,-0.6417628679717442,-0.4674780645804704},
{0.3053240778752952,-0.6122129831409574,-0.5065510875890804},
{0.2951803356428589,-0.5819247416953404,-0.5489732497423662},
{0.2890143469879576,-0.5623780169587717,-0.5499677382016139},
{0.3086888372575508,-0.5736227856811283,-0.6436951714641489},
{0.3192062636351657,-0.5826088279975536,-0.6739575794399223},
{0.32042544320421534,-0.5804197918823627,-0.6970158537401057},
{0.3413237190103498,-0.6084290807169769,-0.709593549402606},
{0.3337278778385276,-0.6157083116886237,-0.6888849193014469},
{0.3413569620800709,-0.620001273650141,-0.7021238716881592},
{0.34349993852034694,-0.6222367699591591,-0.716361117463786},
{0.33812857938745433,-0.631226416945795,-0.7320226084915616},
{0.3205005405002721,-0.6463373947286103,-0.7714220544136984},
{0.3093753266732378,-0.657981681065989,-0.7872531652008342},
{0.3103475863328528,-0.6562322144570505,-0.7977836084430988},
{0.3016819591462699,-0.654394032909037,-0.7997611705725938},
{0.29101333687926073,-0.6473611210684561,-0.7863948531717693},
{0.29324723111262946,-0.6258604648182184,-0.7778720109774223},
{0.28972626935457574,-0.6058517415163085,-0.763861659165615},
{0.277480003092006,-0.6253924584691927,-0.7664760463656713},
{0.2740679824780986,-0.6091343945215419,-0.7656431672875377},
{0.2605879177061801,-0.6025418532250383,-0.7738283720388135},
{0.2501067382901287,-0.6091438067159812,-0.7798387590962851},
{0.24031104699248343,-0.6311833611627223,-0.8067562333759618},
{0.23909206768288993,-0.6448496672288616,-0.8152444306843946},
{0.2399333576581819,0.4363495344568422,-0.48116780100297946},
{0.2487109298807535,0.45202744676002216,-0.487216437616576},
{0.2472093844785304,0.44645402583587285,-0.4793346259413696},
{0.2657860524095017,0.46149311047393005,-0.465707570728636},
{0.27962277927282586,0.47504486813115065,-0.4604147133025548},
{0.24807009962106905,0.43202052579321765,-0.4727320716720583},
{0.2576609254950714,0.45091140081089065,-0.4489684835673098},
{0.25741640869911053,0.4562867651329061,-0.45312246546625806},
{0.26981827655910995,0.4696498783824323,-0.4452833090552119},
{0.2856225525791215,0.4796682581953179,-0.448218712163479},
{0.242866157393519,0.30681350758042114,-0.22499770702922706},
{0.2930886256233576,-0.7033901122294043,-0.23335493465333684},
{0.30954274357858036,-0.7039858841114547,-0.27861457304083165},
{0.32429505667542863,-0.7020121269116266,-0.34246750089415845},
{0.3171978615494234,-0.699189870396085,-0.36124422802182504},
{0.25587761503804324,0.3089332539237837,-0.22811294312911806},
{0.2549375971508686,0.2769648356410565,0.3617883329641884},
{0.2643375757631587,0.25932638326215446,0.4001900862757789},
{0.2639236394672938,0.2489217029583528,0.42567530492506084},
{0.24572065568150092,0.19517386726242517,-0.422019168034105},
{0.2582903409657552,0.1977399919335491,-0.40284953185346933},
{0.2602765142518647,0.2129775336926522,-0.4044361875245568},
{0.2516585488158458,0.22684670258787284,-0.41886928704829973},
{0.2539222817081811,0.2437520050978047,-0.4088817471916615},
{0.2578681940321881,0.2652262270998305,-0.40967938060551246},
{0.2615621799603566,0.28685044343451377,-0.40973865740453325},
{0.2590521279369551,0.3178245735174492,-0.4108288698838215},
{0.2412991271491344,0.3217270295394713,-0.4284793378300926},
{0.24199823291055889,-0.4705075896331287,-0.3684197245951855},
{0.23620973333050296,-0.47603274802834555,-0.3581265888084602},
{0.24273378589300293,-0.5041039170349103,-0.33189800705794426},
{0.24568541001721828,-0.5180918397876287,-0.3104173767533216},
{0.24508082671909726,-0.5100289935640615,-0.28280279930678187},
{0.2454396916645205,-0.4977865322311586,-0.27274777201342054},
{0.2566474123874892,-0.4898208118438248,-0.23058915130442997},
{0.2530727810951869,-0.46360684903360794,-0.23984814725958953},
{0.2602072244800363,-0.45052469980106225,-0.21958950015640266},
{0.2552670239562377,-0.4093737846754254,-0.2255215857665191},
{0.26181350557782657,0.6418421707163802,-0.035085056198811186},
{0.2547827965912636,0.6540169443531039,-0.032904831499691006},
{0.2618199138804234,0.44301677253049054,-0.4487944580999142},
{0.267943848049533,0.4681237010671025,-0.42408945029179806},
{0.26873066745275176,0.4767128291414356,-0.42529761559075935},
{0.279739330276306,0.49418146150152126,-0.41340741064122677},
{0.2953547616291667,0.49642436741041696,-0.42668381154623924},
{0.29843935803226657,0.49254033525836066,-0.4410354054713287},
{0.30379549744649165,0.50312464829433,-0.436826752740851},
{0.31199612217589107,0.5217045203765999,-0.4242825004075279},
{0.3149197099762452,0.5441185600063442,-0.4076189110611708},
{0.3222474037362807,0.5656108053594237,-0.38335627639169306},
{0.3190242277895241,0.5806472866245507,-0.368830456739752},
{0.31759757942390154,0.5873591825569208,-0.35037394448247144},
{0.30716205916385264,0.5826829239963297,-0.3503533177584879},
{0.309552756551388,0.5809472752898655,-0.3392825745035267},
{0.2978109438588635,0.5656967166661125,-0.3400137217779355},
{0.2899115093515158,0.5453771906882557,-0.33947582487871286},
{0.28534419193507105,0.5243385330033591,-0.3383439584325452},
{0.26696718268188263,0.5035698250653545,-0.35358570564022745},
{0.2658020731659938,0.4901085846823144,-0.3529004177812774},
{0.27495212797700697,0.4825391777587042,-0.33566668976325725},
{0.27094013003247003,0.4797711915557797,-0.3143743033474169},
{0.2833031475579761,0.47694432907274653,-0.28217959187923874},
{0.28432046559522517,0.46674110978183336,-0.26351741316049077},
{0.28755986255793003,0.44441878898300635,-0.2475865731641915},
{0.3048032030298454,0.4269040969480058,-0.22599800301270323},
{0.3219049600662618,0.4081141526962332,-0.1997574056948182},
{0.33225717239255176,0.3911261430309108,-0.18170141234984044},
{0.2727905274073089,0.3846211151167452,-0.23995748892264818},
{0.28255137355958376,0.34515558357407855,-0.2246963165477192},
{0.26369474290891276,0.3340063386123061,-0.23149152041384816},
{0.2769899682028035,0.2919424406260751,-0.22231342927897382},
{0.26277835563756397,0.26814641048943005,-0.23085689819730443},
{0.26319149089560434,0.24050299568120456,-0.24536509501710418},
{0.2740733894834147,0.2313257055841548,-0.25672441214837943},
{0.27516560455726435,0.2125345597756453,-0.273572440453852},
{0.2701999710825345,0.19821180321224177,-0.2875821914872909},
{0.2713742925334063,0.19212671937762565,-0.3099081169563286},
{0.26543459706395606,0.1877214118612074,-0.3362898971908004},
{0.2658299092303989,0.21094790410455788,-0.37099586223911696},
{0.26633396228153194,0.2018403042982488,-0.3788892889627802},
{0.2678719549047746,0.19166692366630203,-0.3809799976850007},
{0.2684350844954723,0.16705804039713854,-0.35746693415989755},
{0.26137734048232886,0.15879633653361294,-0.35989748317920695},
{0.263049506941193,0.3296693195704354,-0.41393669638383485},
{0.27238560278697077,0.25765361602492187,0.34745696524417025},
{0.26947623340800336,0.2614188943194803,0.3787587197973694},
{0.28036974704427053,0.2379180466212024,0.40131093845185817},
{0.2812468834622136,0.21384625921343692,0.43148282915345115},
{0.25248562036975103,0.16512974209385678,-0.37113564333951066},
{0.2596699283591821,0.17828578706572235,-0.384980580840537},
{0.2677924519006825,-0.5134007620272825,0.2677238630369506},
{0.2667364837883962,0.18007190115513655,-0.3781277022510364},
{0.2586978689590233,0.22618324300964326,-0.39686157385508664},
{0.27101622862580754,0.2304986340302496,-0.38239663307781563},
{0.27920944375532936,0.24134348461867194,-0.3806774056467559},
{0.2748461907247029,0.26764996729763074,-0.3929639240600121},
{0.28022535997638537,0.28249720337669487,-0.3915599050129347},
{0.28371307866471795,0.30991052006980246,-0.3869967930450692},
{0.2946204102034596,0.3185525166405595,-0.3851720288806177},
{0.3052531860278176,0.3204247422961188,-0.3747311016152527},
{0.3230710708794314,0.31694463346712,-0.33927776827657913},
{0.3041313325544575,0.33697438401192586,-0.3637891251905969},
{0.2825227364573541,0.36193532340500345,-0.39830083856644666},
{0.28632886768096744,0.3785726787626048,-0.4003637112242621},
{0.29186864501648335,0.3947840822569721,-0.4008757746536412},
{0.27990874977621005,0.39383284984025296,-0.4261703463006671},
{0.29142146565089727,0.41928522593872614,-0.41901247255944807},
{0.29306439422916325,0.43058126108185757,-0.41588161622197717},
{0.2729633513179675,0.41762046907973976,-0.43988331282008963},
{0.2692132927420766,0.4367736839849709,-0.4293981282149152},
{0.2658981977049465,0.44016267476142096,-0.4405696019763205},
{0.24778192626366718,-0.4540080127813595,-0.38362702717640973},
{0.2653420771952141,-0.4886056374638982,-0.36559085951759096},
{0.249461702581865,-0.48825978938312475,-0.35626477664462075},
{0.2606706248615706,-0.5134231910863715,-0.335516895690056},
{0.265939851671826,-0.528228773198556,-0.31726064288892686},
{0.2512722483249297,-0.5236446339877945,-0.29496415555994343},
{0.26039606914718705,-0.5173853244263267,-0.2703076105402159},
{0.25931386704614495,-0.5043866833869962,-0.24137292275872618},
{0.2640608171947575,-0.49011499298491124,-0.21718418382856827},
{0.26597509733610863,-0.5806326676842517,-0.7714737213533854},
{0.2722696525618591,-0.5795602782965609,-0.7609763209213857},
{0.26540195477260337,-0.570961938287245,-0.7332223628933646},
{0.2559839528092596,-0.5864714323878015,-0.7796987777364353},
{0.27906085123886504,-0.5941055231157487,-0.7647401973997511},
{0.2602522828576704,0.630996318830677,-0.0062146517027460895},
{0.26066401629951763,0.6204354361510772,-0.03230946013655292},
{0.26505951110258447,0.6344588048275345,-0.02355752112436874},
{0.26028071970044386,-0.04943404675097056,0.41882422867066565},
{0.27504945407269654,-0.0822537679817972,0.4393472182559724},
{0.26043491948168046,-0.1942859168338499,0.09074917463065145},
{0.2739990932251825,-0.18259236667025797,0.07877486070953525},
{0.27412485616364557,-0.2085978593866213,0.058539243443805775},
{0.2820941812211901,-0.21092387296981968,0.03113714128024267},
{0.2736077862478627,-0.25696051804718195,0.030551782889912157},
{0.25858592392303464,-0.4346689571008198,0.5136384700017341},
{0.2768549933293575,-0.40872474377803875,0.486790485753342},
{0.27586931628618033,-0.44074242588697915,0.493647970310334},
{0.2569179629127497,-0.5757235073761565,0.3235103399964994},
{0.2665021802246991,-0.5604306940071557,0.3252694190593332},
{0.27473084127795966,-0.5434354750014119,0.3089078209728524},
{0.2705954835084335,-0.5305325579821216,0.2856863352159057},
{0.2621947995823389,0.6770469820699698,0.01444972105860352},
{0.26402817490340486,0.6785270997103848,0.029535666409400002},
{0.2679494553143052,0.6611846308076743,0.01761402072525162},
{0.2662606673205805,0.6391969435600763,-0.005584034675325366},
{0.2591530587028554,0.02737166272622811,0.3989863266848529},
{0.27182327423409763,0.043579461550384675,0.4043568847799208},
{0.2781290439893926,0.07651513300632298,0.37775441862477016},
{0.27728855505192523,0.08052452757792997,0.3509422808190291},
{0.28577515028470885,0.10237864176827498,0.3214704971761414},
{0.27879010045414837,0.07108649966897113,0.2914712301257509},
{0.28869453263648376,0.08300033523432958,0.26121002370671437},
{0.29303455557019675,0.05694397661610382,0.19988837537914117},
{0.29512666610861027,0.03386167118118234,0.15099002267337558},
{0.29637007707185425,0.003002890544990085,0.11336667786784556},
{0.29392270625822814,-0.008583120290648566,0.09015860949446101},
{0.29247062494167436,-0.04900348892024506,0.09073555698763316},
{0.2856221520602092,-0.07033652800568416,0.11466876485174189},
{0.26374140336219604,-0.16255020003917073,0.09953135282071449},
{0.28440437430735255,-0.1446814492856945,0.07277668947888884},
{0.2814479439561896,-0.18425091548610378,0.057487480780098674},
{0.2878432296883842,-0.15136430759692254,0.036231942104190173},
{0.2882725859623728,-0.17714871387369474,0.025845485410898348},
{0.2842029132944643,-0.20032734410702502,0.0018153519700123348},
{0.28248809157143995,-0.2465988935264528,-0.0053110810365910215},
{0.2781194315354974,-0.2604448323247599,0.0023957038739390642},
{0.265054905135093,-0.2940996354877379,0.017102758333697128},
{0.27361779922067025,-0.29223782332389847,-0.011870779782285939},
{0.2749226898369527,-0.30591994988707366,-0.04281967717374631},
{0.2716897011768447,-0.3311566465512718,-0.06864974260652101},
{0.27239441420304145,-0.3532180292787335,-0.13617923381533115},
{0.2869919267402847,-0.37049020711233466,-0.14873309860254944},
{0.30354597416412704,-0.4037296721632547,-0.15631432083407262},
{0.3093184529876908,-0.449921117800222,-0.15902383127580091},
{0.30687648917938076,-0.4975510271107246,-0.1485064048981861},
{0.3061547540994112,-0.5587893675045388,-0.15150769336752695},
{0.30579168370540866,-0.5883304409192549,-0.15862511469860352},
{0.31338231813137096,-0.620486702571852,-0.17309085651369913},
{0.3129771932515767,-0.6493088445389846,-0.18546188441745123},
{0.3149433405920711,-0.6757579119507233,-0.20408361072605666},
{0.2988953488139233,-0.6886712424617333,-0.21195020268259557},
{0.29467147636477814,-0.6978074793702721,-0.2217583100665222},
{0.2596000378089853,-0.47764944261785564,0.5129525813644157},
{0.2765914518850623,-0.46993424681016716,0.4873005465881595},
{0.2819650138719725,-0.4725876846041731,0.47209184219074224},
{0.2797990075942391,-0.483388277852786,0.4578890410415734},
{0.2671526229382788,-0.5017400544144993,0.48205755376666004},
{0.27543455300687564,-0.5073711500620203,0.4805868483206842},
{0.29054332793567345,-0.510429111957452,0.489252275247811},
{0.2943981222071315,-0.5167472977990284,0.49825353728290367},
{0.30966009561988506,-0.5158399222032065,0.4878925135405431},
{0.3202349964614154,-0.5268880361396224,0.4930531997255644},
{0.3246631335558349,-0.5415770672483269,0.4967722180857519},
{0.3351270906586573,-0.5682554317373588,0.4897236860075914},
{0.3477981072277242,-0.5914382674192683,0.47666436635304693},
{0.323462177597295,-0.5875848749640032,0.49568921494688517},
{0.30670066137687985,-0.5934554809210814,0.5003290262864567},
{0.27546218881182455,-0.5576080369727018,0.34110393425722363},
{0.2873952492849736,-0.5477490636869128,0.32436524761480967},
{0.28612800744644756,-0.5255146567893363,0.2966957990772845},
{0.2771908284373234,-0.5178218900407366,0.2859068208771284},
{0.28645903632746583,-0.51103489681231,0.2783790679203976},
{0.28321062768923416,-0.5043051777883425,0.2708376973206486},
{0.2751449778332808,-0.4926194377435405,0.2715522230601968},
{0.27573334011545353,-0.45946308036692335,0.2709888932100429},
{0.27802891426131693,-0.43870638799628797,0.2704021330035193},
{0.28916394080170266,-0.4216438818132773,0.30815324334207395},
{0.29308301835858536,-0.3888413828956796,0.33693373134232707},
{0.2927798255419721,-0.36780092287567767,0.3195716370129139},
{0.2937735129633953,-0.3366565722550136,0.3476856615430952},
{0.2942092775399808,-0.29825401790559847,0.39343313196577484},
{0.29530389572730426,-0.2612815163325604,0.41069589760493697},
{0.2907786327966513,-0.24633114663357844,0.38677710842167107},
{0.29223151515102963,-0.23323297664454065,0.416832448119784},
{0.2906614810148027,-0.18151336872051427,0.45067409335535114},
{0.2871647506509433,-0.12773709618181314,0.4716460646413493},
{0.28432667363836583,-0.12448668494901992,0.4493107269778725},
{0.2707462788789155,0.11800328505611872,0.5497180146597932},
{0.2724699120180105,0.08446142822641012,0.5557668515328459},
{0.26593905063400136,0.07396102390256817,0.5813195576188509},
{0.2748399826815622,0.054813616521565335,0.565799249507662},
{0.27583166750842386,-0.0006071866710510205,0.5750167917553982},
{0.2697299621389472,-0.01619818637026131,0.5819673969595006},
{0.27510752931498045,-0.04723159325221757,0.5722576169685444},
{0.27656722049086796,0.023833879173857646,0.4259088074509334},
{0.2816766402551145,0.06480015508092286,0.4102557273203161},
{0.2853459942701764,0.08441937374061835,0.4072850785477664},
{0.2901223825588432,0.10914580931054275,0.3904038071725727},
{0.2869140258118418,0.09873672329870581,0.3625210823142463},
{0.2933139175115279,0.12051894434429247,0.3449533215233656},
{0.29931369081782355,0.160628510297942,0.3320768387522874},
{0.29791808266790454,0.13996714142843464,0.30350842551609863},
{0.29250206567629017,0.11087424867658537,0.27968435905559236},
{0.2820525272543106,-0.4162026321301879,-0.2056906928616716},
{0.2995187565009226,-0.3903038777039532,-0.1921928049981556},
{0.30151273990582195,-0.362516676606211,-0.1751921789870957},
{0.2880486958903956,-0.3509835342669963,-0.17571145175689623},
{0.2945477160208766,-0.3382738676228922,-0.16246869444051715},
{0.27614006707089706,-0.46437244093447466,-0.5842837980888038},
{0.28650069029434533,-0.47928576263406864,-0.5566890463284231},
{0.2960941195412776,-0.4724841504653428,-0.5418043617310587},
{0.30235102598927166,-0.4713771161917379,-0.5215174780445545},
{0.3076212540968078,-0.4650921734198828,-0.5037674811485761},
{0.3090008414902347,-0.45178272970460526,-0.4904960867299673},
{0.3040099753240298,-0.4419305652403253,-0.46948105966089665},
{0.29721597301463776,-0.41493158536199504,-0.4789212904238731},
{0.2731521959851183,-0.46348669335991705,0.49644659621004966},
{0.29406048476406027,-0.44834367406411746,0.4589105645274016},
{0.2928070608280087,-0.4625610941535853,0.44843959834361397},
{0.2861922907318722,-0.47569731343929184,0.421951680597382},
{0.28391413915869396,-0.48518981192032395,0.4166828543060389},
{0.28112152104266286,-0.49829298839576547,0.4487872487594928},
{0.2877060519609206,-0.5047167109707337,0.4662358551739633},
{0.30207026223174743,-0.5087485346014295,0.4682863117454974},
{0.2730166203333038,-0.4996611610001918,-0.5650388643526553},
{0.28774089710629086,-0.5036425192479376,-0.5315022142688066},
{0.2998968463541364,-0.5017783039706243,-0.5008533055426609},
{0.30604020569049256,-0.49825694169365825,-0.47498078510518227},
{0.30812911207760774,-0.4810740795775006,-0.46409107639858194},
{0.30622164075776576,-0.4597786892698179,-0.4563486453048569},
{0.29481506239483873,-0.44323064962966013,-0.44200305916345206},
{0.2641056753129354,0.6609771620111015,-0.010161365064577679},
{0.2667058440916051,0.6718846938092994,0.015671704260039297},
{0.26773497743676705,0.6557323668544967,-0.0033389259124121306},
{0.2718823507736623,0.19806481277142665,0.4870125734902139},
{0.27149705158002707,0.17579115502044448,0.5162806932661956},
{0.2757153167643999,0.1480073583334568,0.5226801844469694},
{0.25987379248554426,-0.527576728409327,-0.292265058609935},
{0.286688133145303,-0.5316133582669706,-0.289374713879302},
{0.28301116927090736,-0.5159480623095282,-0.26388068381394936},
{0.2853978614693196,-0.5082010252483117,-0.2356593202152709},
{0.2856215512818407,-0.5061635855414274,-0.21768242935547294},
{0.276501134870338,-0.4992137813751496,-0.21221654775927692},
{0.2723425470038982,-0.4797681876639373,-0.2107005836762109},
{0.29362031447943954,-0.45816559935051854,-0.2034700157524088},
{0.299115834475146,-0.4214031699469833,-0.20078253385085718},
{0.3081605528122235,-0.4122475078711979,-0.1891801017398141},
{0.3055992343680472,-0.37521572949913906,-0.17469533527638406},
{0.30063360089331737,-0.3468039191576606,-0.1591519973277378},
{0.27182087112062386,0.458536680122767,-0.41575425120786486},
{0.2786515209104916,0.4692557677727262,-0.39638936205748165},
{0.2811505586638048,0.4956741954876737,-0.3931337440788285},
{0.2822293563540923,0.5022495144709486,-0.39897210826346613},
{0.30222786642373856,0.5147328879296016,-0.40696786756922265},
{0.31088888764283,0.51479176420971,-0.41855928541017745},
{0.2749677482145868,0.18999075201831492,0.13777710401596308},
{0.2741576987144544,0.20429969067924403,0.16101320871320882},
{0.2857358994313032,0.19551010288930334,0.1813054994050291},
{0.2827097787893995,0.22252049755663436,0.21007377157845702},
{0.2699482449461522,0.016888080196702855,-0.0011080355708856524},
{0.27753907963157065,0.025116340731051158,0.026188930378197986},
{0.27906745980091807,0.048228284565483025,0.035576893423118976},
{0.27376418888311693,0.07716297234697275,0.03595278042231514},
{0.2741474854821907,-0.02077191208930289,-0.007445446320252527},
{0.28073421925446607,-0.016556450537316133,0.010540856733984541},
{0.285403668993548,-0.010093677368398491,0.035994834908106926},
{0.29056155154618324,0.021336844015105976,0.06080477867124645},
{0.2810830712270818,0.09243195484069161,0.0668061540531913},
{0.2862087120072766,0.11531520237619858,0.09491056612947733},
{0.2761570891246699,0.16102642583731483,0.10867780296151693},
{0.2733184113337239,-0.1395806406780625,0.09882143304865783},
{0.2773548409319114,-0.11159738557274804,0.11198388632312022},
{0.28799682869125237,-0.09775725429866934,0.08581718474455503},
{0.27469319250020324,-0.45361570450675887,-0.4036015061113178},
{0.2856533925353688,-0.49473918408690293,-0.3779136248924106},
{0.2925299017406952,-0.5153078328282122,-0.3618438048335423},
{0.2672199101155457,-0.5194475963057738,-0.551959919271408},
{0.27764001039747094,-0.5362381501473308,-0.3008577913544788},
{0.2900054310364508,-0.5455305894316677,-0.31516873260996947},
{0.29988062533818816,-0.5503952921404972,-0.30278989458742744},
{0.281812215906929,-0.5570258827336696,-0.6722371504521257},
{0.29310164248800746,-0.5574282039810778,-0.6570851194807993},
{0.3073270729557214,-0.5689427221908704,-0.6571868512845243},
{0.3053755445555261,-0.5658288879071725,-0.6972908099734014},
{0.32130137806542153,-0.5723529404696723,-0.7213289537925335},
{0.3356810083143721,-0.5882663578932865,-0.7194955784714676},
{0.34246980387790416,-0.6004759766753807,-0.728216076749036},
{0.2727386602081657,0.24666317681187747,-0.23755237285426997},
{0.28041660775701,0.23459914665440543,-0.24589818568937916},
{0.27804934072584436,0.23399977010214432,-0.2543559435604769},
{0.27725811561459024,0.23302951303709082,-0.25422837828690853},
{0.2755148570487924,0.23459013497887862,-0.25216470459126844},
{0.2868575526452071,0.23201259551875408,-0.25977135977372284},
{0.2985084475446388,0.22910542899380434,-0.2685803727309101},
{0.2947631951956955,0.20417092384893867,-0.2779529157977075},
{0.28713130732176606,0.19642889327412594,-0.2872818023030638},
{0.29244379017455013,0.19458610575862087,-0.30323507135845196},
{0.26990318656851814,0.1960654223612112,-0.33456606379224924},
{0.27349303757948795,0.2134725750682584,-0.3608691420604535},
{0.2911056564885465,0.22242617535278705,-0.3562972186765173},
{0.30486588423962085,0.22502193842342139,-0.34043226404129184},
{0.2937436743044288,0.25915696376225034,-0.3686830657800246},
{0.2989540248345756,0.27088135388208967,-0.367002288164546},
{0.2991478759881302,0.2885666669737311,-0.3647904224713539},
{0.3070749463004268,0.3037499384202172,-0.35798400407568043},
{0.33038935244502776,0.30893065055085367,-0.3241009051326899},
{0.3314116769686806,0.3372481386884848,-0.31620928074413207},
{0.3205055469866759,0.3324324995464123,-0.33631673195792466},
{0.3060398051715803,0.354393352026886,-0.35531774967648083},
{0.2949276082091958,0.3674584792056588,-0.38222200683205154},
{0.31772654651366306,0.3833342478515164,-0.3612408236110705},
{0.30974360381310023,0.40134297996484236,-0.3726878543841401},
{0.3047587454305798,0.4140880925326854,-0.3797467999540204},
{0.30491074235779875,0.42084744995616324,-0.39360195068731046},
{0.294257139550001,0.40621829642484797,-0.4103246165732322},
{0.3077892717805188,0.44439796199956655,-0.3901849235869993},
{0.2960995265465937,0.44314874351209427,-0.4061876567280568},
{0.27817630522104436,0.4359982793707527,-0.4224969870964821},
{0.27611563541724654,0.4554264505092797,-0.4045889854896003},
{0.2832120295054272,0.02013849142949606,0.45060720669699655},
{0.2885331235148258,0.06085804768658274,0.4573523456990877},
{0.28897910132367494,0.08000625610541016,0.4398088163024013},
{0.2925280994055899,0.10094698691624868,0.42115945418884704},
{0.2967675920923148,0.13629037781349515,0.3946959680962655},
{0.2922765735286637,0.12051473889571328,0.3647693952284579},
{0.29765674407762693,0.14668644696068225,0.3571379078734408},
{0.29936916268717745,0.1855728281561591,0.35012862664868594},
{0.2975732358844118,0.2010088270363082,0.31402965682338035},
{0.30002501240607327,0.19353774750566832,0.28624185494726967},
{0.30074474489148134,0.16901177165135145,0.2927060299323803},
{0.3005434841380492,0.1650736694461344,0.2632022047765084},
{0.30015518105257166,0.14174284202612905,0.26716714174884976},
{0.2972273878036384,0.10138495434685176,0.22882366393899933},
{0.2957152286502392,0.0783755433539694,0.18990283811706443},
{0.29794191354318655,0.06997265657385708,0.1435724124175281},
{0.29670911633111857,0.030641899645180295,0.1089699815080418},
{0.293804753438555,0.04723860233318286,0.0893721906101545},
{0.2911761478171118,-0.02281696165552088,0.059549752659545686},
{0.29009835142410506,-0.04570000893157173,0.04498067696507593},
{0.2920939369046537,-0.09030499915690768,0.058798979958434125},
{0.28961752846988553,-0.058303738323371754,0.024202356573176192},
{0.26953430865028727,-0.5673558662603267,-0.7039274083502586},
{0.28662004493021154,-0.564517388728837,-0.7053915052341813},
{0.2731568019526098,-0.571217269093838,-0.7242227029339211},
{0.27893608959768273,-0.5665285944469656,-0.7173914523656849},
{0.2995622128029074,-0.5677101252382586,-0.7421238957192938},
{0.310932544204271,-0.5663543687201137,-0.7268587181552418},
{0.3268639849789387,-0.5755871306865175,-0.7341069089111852},
{0.3306016274685482,-0.5806124414791805,-0.7427300810930642},
{0.335764316248131,-0.5911827363532192,-0.7463475679089828},
{0.3395121719700043,-0.6108696427090939,-0.7408574549185925},
{0.3258368542283382,-0.6180657660064379,-0.761165966626361},
{0.3228926397040005,-0.6370447551848174,-0.7726358269774319},
{0.31635076404990303,-0.6529779982945904,-0.793213687653724},
{0.3123952392720008,-0.6477077701870543,-0.798988970109674},
{0.3046309798975552,-0.6450607406956452,-0.799988865574238},
{0.29893700278080276,-0.6377430599084173,-0.79311035377435},
{0.3028468684027025,-0.6013416983043229,-0.7700330548258323},
{0.301077576107605,-0.5795580754425432,-0.758155065703125},
{0.2872566697413168,-0.5805447537830012,-0.7550174005441449},
{0.2747398529534865,-0.5676556546661855,0.37408045864221684},
{0.28047308092364465,0.24698419272008815,0.31850004866304776},
{0.2857272882746887,0.23934609680301794,0.35697850134634423},
{0.28554725502360856,0.23412593355951972,0.3779308472056396},
{0.2929584569768592,0.20639861003916674,0.3871293648050414},
{0.28891601959498725,0.21315356175460926,0.4129720465835536},
{0.2921780458762372,0.18792507572811332,0.4092692492393144},
{0.2877893598946795,0.18770238721287297,0.429928415254804},
{0.2798672960687867,0.1995969978704409,0.4536491478359362},
{0.27972210796307695,0.04798897451538213,0.5457192338393622},
{0.283149548555108,0.005066564240630158,0.5444758228761183},
{0.28164099407191956,-0.028471888178323822,0.5457432649741004},
{0.2868367256617673,-0.049410215875688536,0.5274461592439164},
{0.28076646102690644,-0.0708459880621333,0.5540718554959805},
{0.2827942882798954,-0.09589584265374218,0.532871788689426},
{0.28667531654010936,-0.10488308652690424,0.5114756678752992},
{0.28624916441741916,-0.14035244062206992,0.49636829476269445},
{0.281960407904481,-0.18374666217551458,0.5088044069896958},
{0.28660802936284246,-0.18777207750361366,0.4821715013972102},
{0.2894545172725783,-0.2111281376150941,0.4560232236886109},
{0.29078203720740586,-0.23960803617166399,0.4516111073506835},
{0.2881706538991918,-0.27405987197012444,0.4398720982905452},
{0.2841204063985299,-0.2966359214998952,0.44879205498644037},
{0.2883282580911829,-0.39188732922374225,0.4663668248582863},
{0.29505236985037814,-0.4239883192664415,0.4620904844316296},
{0.29914687469084944,-0.409074196529023,0.439445946167855},
{0.29862199465627665,-0.43681553821130653,0.428035362615805},
{0.29535836629937745,-0.45241815295897364,0.4087121274323012},
{0.2880815384412044,-0.4648250273053767,0.3721221214205124},
{0.29014801576923055,-0.4742496378307735,0.3668256593242204},
{0.28713411095415214,-0.4894735619468583,0.41080784264092557},
{0.29305017580777654,-0.4931074700381814,0.4099192914339818},
{0.3054938978941116,-0.5064723856228128,0.43743954667667423},
{0.3153642859689013,-0.5177345769178547,0.4686449764314646},
{0.3255530865789717,-0.5280945993629346,0.46352854758625267},
{0.33086456813447496,-0.5415294054977627,0.48811099660720425},
{0.33784841640829855,-0.5542999510165371,0.4768259757341611},
{0.3510555275414827,-0.5767358189270018,0.472222411356153},
{0.37833306832331964,-0.5941559884986988,0.4567539704441073},
{0.35855364209870305,-0.6048776795215882,0.4646011372333996},
{0.3255987457349742,-0.6071378077437126,0.47707950420564876},
{0.29364594768982694,-0.6043199569362065,0.4867480307486379},
{0.3081223032560986,-0.6132495260859969,0.4620938888423841},
{0.3282573902748401,-0.6239976513570982,0.43266996720951656},
{0.32194881688715893,-0.6173462337804859,0.4193318863920094},
{0.29813676599402184,-0.5967080950078922,0.4088326836249044},
{0.2849673036385941,-0.5918644195419585,0.4206375780461165},
{0.29613837688108713,-0.5821089803949998,0.3841865520968967},
{0.2978758279226566,-0.5681645139442661,0.3532624868779991},
{0.31220379123192005,-0.5587999812557148,0.3279466877286211},
{0.3028188320788413,-0.5439783783870382,0.31255294359372},
{0.30213534655499663,-0.5242305931564936,0.2913598858681307},
{0.28439576315073806,-0.4388641924477353,-0.43048553706181725},
{0.29241114788319744,-0.4791758201926416,-0.4016075227064184},
{0.30116348741429394,-0.5190192413290659,-0.3738601732404503},
{0.3056581106481557,-0.5476709624990137,-0.3507572410815452},
{0.28847965424003336,-0.530343913574427,-0.33891930385006813},
{0.30182574543578655,-0.5520688604155544,-0.3256959717009357},
{0.31938529558896506,-0.5798522565836297,-0.3069917384963959},
{0.3218202503163098,-0.5717209216260587,-0.29576359130889984},
{0.3230969043492749,-0.5584755609367495,-0.2921793475627022},
{0.31680014626950675,-0.5472189769064799,-0.2925908807450933},
{0.3143437637803538,-0.5362561734983845,-0.28564448098957007},
{0.3015301624785071,-0.5241689132439988,-0.27642273329325473},
{0.31125796582051707,-0.5165908951637741,-0.2575102302543175},
{0.32163080487079054,-0.5163992468642372,-0.24477793429166828},
{0.31837218300029513,-0.514068226794635,-0.22309364012013963},
{0.30941437726718735,-0.5184228686686471,-0.1981877720775036},
{0.29736176189871594,-0.5092726135981778,-0.20131121881509684},
{0.29666505925076525,-0.5025485018389826,-0.19635559831317456},
{0.29816500257733913,-0.486232362649048,-0.19658829980122247},
{0.30421323867202343,-0.4477360868741541,-0.19726858117376872},
{0.30944401566669777,-0.4520526794514974,-0.17895345209253108},
{0.30564929923208506,-0.3834145518934331,-0.16408919395969418},
{0.29449304518934727,-0.35403068215179584,-0.15298140270534505},
{0.2903881268571561,-0.333826305361226,-0.1494324046234301},
{0.28056720286803577,-0.3366067076504319,-0.14310100165774778},
{0.3082008049629099,-0.5062244644160974,-0.15940712787487468},
{0.30877474856423975,-0.5241328665418917,-0.16851392664335912},
{0.3171389852693149,-0.5520664573020806,-0.17040197279595443},
{0.33135560432095823,-0.5629860046676475,-0.17706500542102346},
{0.33720578381350874,-0.6073757159776205,-0.18083008345612575},
{0.3447501583051001,-0.6293503863605686,-0.18943363021130175},
{0.3398738405478137,-0.6501581448925227,-0.1971862745372905},
{0.3270862729752667,-0.6643917859979389,-0.19904648462548075},
{0.33687074974336745,-0.6754076581619145,-0.214898021877144},
{0.3171714273012114,-0.6872784379442004,-0.21616386189947698},
{0.31527997673786157,-0.6998929813466327,-0.23404843314998908},
{0.3336641953314714,-0.7009167076864785,-0.2569410928799352},
{0.3289991513004248,-0.7033001957335924,-0.3090816461807918},
{0.34055892814730765,-0.7001949726065089,-0.2974399632163431},
{0.3378568273054569,-0.6967871574411807,-0.3385670474666978},
{0.324085184765382,-0.6910294978173721,-0.37010350610250636},
{0.31407201169835636,-0.6714999953940325,-0.42021422955581245},
{0.32494930431867525,-0.659198657781021,-0.41467305040410357},
{0.3277591447479354,-0.6423290014542841,-0.4214746625728294},
{0.32040081129110876,-0.6181434666754245,-0.4588042267561853},
{0.3098507426221412,-0.5955678176645662,-0.49909682985275716},
{0.30285407774312395,-0.5771585666389374,-0.5128130005234782},
{0.300697884178742,-0.566744874659609,-0.485229663552098},
{0.2769953752081196,-0.5406232314586779,-0.5259187803718498},
{0.28324266920221836,-0.525948218511904,-0.50990523322016},
{0.277450965470864,-0.5739540148216028,-0.746650760725596},
{0.2878282102291729,-0.5726377094163198,-0.7488660308295427},
{0.31019739174073924,-0.5705740357206796,-0.7497107252155892},
{0.317533296138477,-0.5738554871691764,-0.7524390600461958},
{0.3253642419118209,-0.5857100459355141,-0.7566160717826015},
{0.32939526450469225,-0.5984036918231259,-0.7573219863655352},
{0.3145902831708762,-0.5941263500991886,-0.7666704982975943},
{0.3164965529339812,-0.6268120977538498,-0.7837109759404284},
{0.3075233272227498,-0.6270297797826864,-0.7903135302097397},
{0.28337544122164676,0.503988367328711,-0.3405604300932287},
{0.286278001779105,0.4867748655157622,-0.343425942651299},
{0.30560744500574943,0.48068577649202304,-0.3379208102016973},
{0.2978900463440433,0.48349681847802006,-0.3231929287584995},
{0.29770000012015563,0.481505838964963,-0.29050818240111886},
{0.31404277381775825,0.48259625170370735,-0.2544532696561665},
{0.3104312947855241,0.4774007203733157,-0.23971737783472263},
{0.30919709575726306,0.464293538708751,-0.230266333061114},
{0.3180952241724378,0.44714592225687605,-0.21724306010867683},
{0.3292532805502809,0.4363323121436133,-0.21615705307796781},
{0.32332199597798905,0.42226148197604807,-0.2113155804660518},
{0.33990287816895565,0.41113166218152236,-0.18915847371854974},
{0.35147427006429527,0.4009462659822065,-0.16699515892790698},
{0.36607438597446845,0.3929362882550632,-0.15176963273617297},
{0.3432728442970713,0.3685965536949672,-0.16725369388579844},
{0.3138483218858353,0.3671683032536954,-0.19741857550642614},
{0.2916133142098903,0.2711529057046309,-0.21810938251598772},
{0.28933756575018593,0.24846631295506458,-0.22626414782992846},
{0.2842926295308201,0.23850741020065597,-0.22895082869365546},
{0.29795893559695935,0.23351854662901253,-0.22827154861838997},
{0.31478353354606226,0.233586634844104,-0.24940813317734453},
{0.2842573838665374,0.1513591008510626,0.4891917968920533},
{0.2831803885113553,0.1286246460914761,0.500214277618082},
{0.2825445647380746,0.10869462475583366,0.5266833709754357},
{0.27709750753075685,0.09315569251522274,0.5420572894241779},
{0.2846621082274194,0.0582076137844191,0.5305497802953506},
{0.28935378676613416,0.037612330535441725,0.4926897288126496},
{0.28904458616583645,0.00043336146311161834,0.5186323400597814},
{0.28934817950136194,-0.047788314540318434,0.494502477409732},
{0.2873794287879376,-0.07247449795955639,0.5094744751299783},
{0.27947438701581767,-0.26992050901147524,-0.028033720488264604},
{0.27825260407383806,-0.2907328735109207,-0.07354888994180861},
{0.289349581317555,0.46029395685049546,-0.38918843253318997},
{0.29406509073155174,0.4790294305301949,-0.36939759151957274},
{0.29929226305601536,0.5053096792203979,-0.3574262814902988},
{0.29574366549301273,0.5218334874663614,-0.37335251551910653},
{0.2983083883479436,0.5257864088713337,-0.3872339002411524},
{0.31052081076242377,0.5347542275772491,-0.3905548028025109},
{0.3174505889830864,0.5289252755870506,-0.4092346043534003},
{0.29565475029448146,0.451762503499534,-0.3981780795198258},
{0.307169068244818,0.4696524817553623,-0.36087835399543644},
{0.2972436088195866,0.4816053679146701,-0.34815026348136646},
{0.29471773629914916,0.4957426842216775,-0.3455472910703107},
{0.3066604092261934,0.5340216784866472,-0.3412272940822129},
{0.30476275061970287,0.5396471668693961,-0.3684523668865382},
{0.31614649940462863,0.5510573499025337,-0.3753997679393422},
{0.3222179655962264,0.5524265238042407,-0.3825239980919279},
{0.31902462830843636,0.539972588485642,-0.4068803541868845},
{0.2930663968237248,0.3045201362885755,-0.2133808562373411},
{0.3086886369980947,0.27627954778210645,-0.20432131870050838},
{0.3098459363951936,0.2630137606282699,-0.20849792991800176},
{0.31826764756418413,0.24552289946855144,-0.20953367182521676},
{0.3049363755681861,0.2440658116655939,-0.21838554030602048},
{0.2902128998330236,0.24316925008040416,-0.21611059288414067},
{0.2834595501932303,0.2419134230308788,-0.22193934461488304},
{0.2830568284269099,0.24194546454386298,-0.21109429376700453},
{0.29251047657344853,0.23943521226100534,-0.2108283492092355},
{0.3050166796101028,0.23755157181644534,-0.21942448636453388},
{0.31734264913622084,0.23476295888953724,-0.21875642081881283},
{0.3318137979566326,0.23231879222720953,-0.21428562846023308},
{0.3449662382582874,0.23345306178685102,-0.21575473183055968},
{0.3260893814025451,0.24176402947658987,-0.268068309301531},
{0.31075751743959473,0.23679399029382467,-0.28363107241742397},
{0.28666029708089796,0.22899168162271036,0.27012116898653893},
{0.289675002933801,0.23265983408103535,0.29431110947343375},
{0.2875280213044019,0.20432532388963137,-0.33404058297930794},
{0.3065662872818023,0.21145676338263852,-0.3276667250089215},
{0.3181080407776315,0.21294429062293105,-0.3097783488287425},
{0.3134191658713028,0.22931670272004406,-0.31982015899799776},
{0.3058115093915677,0.24284362820470198,-0.3415887624005662},
{0.31136089918097887,0.264120995161331,-0.3427925219914922},
{0.3145666525550503,0.2727177330949978,-0.33261473565151006},
{0.31223643352327274,0.2868105918027396,-0.3336272474618115},
{0.3181659157604592,0.2958677262260985,-0.33159561527915565},
{0.33728568733651315,0.30240419487487985,-0.3037717667009377},
{0.34898524528378966,0.3170740010757938,-0.2785909424250058},
{0.3398223738675828,0.3402235936879821,-0.2964939375454839},
{0.32888079796183933,0.35238715279516136,-0.31391671049011094},
{0.3214439627982013,0.3694126109787841,-0.3246339958049649},
{0.30688690267110064,0.20018515989315758,-0.30948236535255075},
{0.31685001087408843,0.2022171925947257,-0.2969162847385072},
{0.31442887404921815,0.21136344247607197,-0.28627770138992076},
{0.31513398759432715,0.2202113057677527,-0.2970604715469362},
{0.31087526999981174,0.23610910295378693,-0.30246447297118145},
{0.31687844771686197,0.2566010523233902,-0.32355659993087044},
{0.319276754963731,0.2718764431197059,-0.3073604161551706},
{0.3254145070353149,0.29052260108196176,-0.30480110030555585},
{0.34232000980470295,0.30329655101149045,-0.2805384656360781},
{0.3512954383699521,0.31594253514853843,-0.25573973640248304},
{0.3591610290292102,0.3304244979795823,-0.2462214044516075},
{0.35572637909675775,0.335420370632191,-0.2519958858697328},
{0.3471704940921458,0.3345804824730921,-0.27422969198894087},
{0.3294661563521698,0.35780517238133724,-0.30218571180821874},
{0.3434044147597627,0.3708604868467586,-0.25786909519974077},
{0.34522477321617884,0.38953948735982336,-0.2717394656516983},
{0.333560460933185,0.380770125774954,-0.3211360638843686},
{0.3174475850912442,0.3738453540406951,-0.35367842576842556},
{0.3370988452639239,0.38833913217965194,-0.3275782103293026},
{0.3390573827450845,0.3990045502953627,-0.32627712464268704},
{0.3311022761089267,0.40729048555308245,-0.33952769207785605},
{0.31759777968335773,0.4107155230316398,-0.3558950976885653},
{0.3077862678886766,0.41863298089004114,-0.3601271807754126},
{0.31513979511855555,0.4352793479231692,-0.3701864135173531},
{0.31791599195918224,0.4460817435068875,-0.3678069306593622},
{0.3101697559357904,0.45664883422962793,-0.3777804523540699},
{0.32078390763072634,0.4744939543672782,-0.34173234843062666},
{0.2990050909958943,0.5219554454751576,-0.3361525192038805},
{0.3063253751560522,0.5545074198131099,-0.33351289931234906},
{0.31788735485695263,0.5770884758292844,-0.3393060048598964},
{0.3163389487419901,0.5608510386056174,-0.35356928436482304},
{0.3252540992109376,0.5728828269906491,-0.36873353116297475},
{0.32255740537440303,0.551395187605061,-0.39161417532555176},
{0.2811765923931045,-0.039161137169316566,0.45073377067328424},
{0.28595558405470123,-0.0928376804988543,0.47101925254359545},
{0.28760692353012557,-0.030625878888688188,0.46895237469665696},
{0.2834323149071937,-0.4618565813868447,0.30202189957308684},
{0.2894579216833329,-0.434178521692705,0.3350450844113633},
{0.2934082397153752,-0.37391444355306735,0.358737580409178},
{0.2941287732386079,-0.3250577448141812,0.39718459235785886},
{0.2913513748412443,-0.3023385097732622,0.4243013247964062},
{0.2836936534974713,0.1798678367693183,0.4647222942043711},
{0.2900464842249619,0.15144401086047082,0.4604051008486595},
{0.28305442531343605,-0.36266586990104377,0.45128868962627977},
{0.28395218845536274,-0.3719973597793301,0.4642130344073781},
{0.293933119749948,-0.38400972299711505,0.44965957895048814},
{0.28153065111158015,-0.47795563932631113,0.2896632877556161},
{0.28269616114638124,-0.4882357582483866,0.2831382338958354},
{0.2913918272513869,-0.47313158928708027,0.3135330133721249},
{0.28957507346518147,-0.466325371150863,0.33092614791724156},
{0.28632065704326526,-0.46265661791416957,0.3506146563487654},
{0.2895031803204231,-0.43284859864440356,0.3659731548193839},
{0.2880865449276082,-0.3887262337083926,0.398071140970241},
{0.29565174640263925,-0.3888906467218929,0.4163856692731102},
{0.2966216029487804,-0.3816690904736176,0.43612364179030344},
{0.290975287582592,-0.36970098459564205,0.44276724924812577},
{0.2993054801801213,-0.40596036224532506,0.4155153416766763},
{0.29394493505786096,-0.44251732544684885,0.3829491489173373},
{0.2925303022596075,-0.41445957382384613,0.3902590195857753},
{0.29442856164446657,-0.490569782209831,0.2786147733002878},
{0.291798153687918,-0.4806198911309493,0.29793360277575626},
{0.30537173962585923,-0.47194264889590953,0.3180312412761974},
{0.3014792965766447,-0.4717628159042855,0.3458651028272229},
{0.2964095281847161,0.5366198446707554,-0.33270785629862043},
{0.3055754034927652,0.5662908864725137,-0.3346499725043766},
{0.32409820163003183,0.5820509051527157,-0.348934078992743},
{0.3238795183039145,0.5824626385945632,-0.36402463031103094},
{0.2869827148053017,0.24265278094298973,-0.20661348843561714},
{0.34026154285492277,0.24100564691614454,-0.19097082179671981},
{0.348602148944172,0.23445315751087106,-0.18998975072103416},
{0.3466041603501496,0.23203902976696608,-0.1988782666823136},
{0.3584625240461542,0.2347495415059751,-0.19909554819223785},
{0.35092676071117734,0.24057048311792759,-0.22835425577378052},
{0.3230840877440812,0.2535066432069389,-0.29227607288002333},
{0.3029023402720564,0.2211579322169803,-0.2762408977070693},
{0.31149807690844256,0.202569448978096,-0.28390562813180753},
{0.3036070532982532,0.19677454109544326,-0.2846710197732181},
{0.3088047874826625,0.19622122421809696,-0.29227066587470724},
{0.29005990160852396,0.17380518199379116,0.16494650469147826},
{0.2860336852426003,0.1400312244544031,0.12108447704846396},
{0.29501392003479704,0.16051436240793568,0.17578775060968987},
{0.28915232575324584,0.20213448543933518,0.20698997621318177},
{0.2927660076394977,0.09132572160491131,0.1158721239237556},
{0.297266638657044,0.09856149627457335,0.14311381826294145},
{0.2976186947809582,0.12115476811757311,0.160068985377455},
{0.29739079951985786,0.13901911316301402,0.18346109219104267},
{0.29991647178083924,0.17387306994942645,0.23305815013932046},
{0.29456914378268484,0.19365189539567465,0.22736917950897179},
{0.2838468519814271,0.08722621027803625,0.5242624344100216},
{0.28622533354213714,0.09496743981502433,0.49613459197736587},
{0.28705100327984934,0.06488726794434871,0.5050447359599095},
{0.29158267451309916,-0.5394296851000154,-0.46687708595256017},
{0.2975115559719172,-0.5174251760581008,-0.48070159698905895},
{0.2914090495646159,-0.5506356034878788,-0.4630242942756635},
{0.30081042999309904,-0.5458213661619995,-0.42333206902863346},
{0.30474793141994766,-0.5227518773322717,-0.44275863809151134},
{0.2941876495187164,0.21378217618746845,0.2513039894487297},
{0.2943256282840047,0.22152120287043892,0.3216707566322927},
{0.2967942265999829,0.216722185263227,0.3456225886258236},
{0.2913525763979812,0.11402052499217985,0.470717061024263},
{0.29022491540039275,0.07663889335022454,0.4816340050168999},
{0.28946613232103513,0.07431007613464005,0.081850044918196},
{0.29525903760912636,0.0688796404621828,0.10166191317470914},
{0.2999517174451219,0.10634097536768636,0.18966452936424427},
{0.2995874454943825,0.13834604113088916,0.2247902382326542},
{0.2892025908767399,-0.019268364092518264,0.49234508228861307},
{0.2907091427653668,0.009969716765040796,0.47678992903205386},
{0.28991611531900724,0.09299508443138929,0.4563814878556658},
{0.2918235866388492,0.11939008178996706,0.443943373034103},
{0.2943118103815303,0.14881460420120307,0.4205570737447436},
{0.29771461906045465,0.16598545074999166,0.39273422646380646},
{0.287448718559766,-0.13940661521066694,0.05214896419801493},
{0.29065487245274974,-0.12156710233778883,0.01901463536157444},
{0.2903484754848381,-0.5049732433340636,0.2629034176679305},
{0.29859275677567854,-0.4999975968865261,0.25465733404198476},
{0.32291987499003705,-0.4812447006341416,0.2737190303757548},
{0.31693852555370733,-0.4734115520067799,0.29613587363788524},
{0.29102314959261216,-0.5550100710480497,-0.4807522626314653},
{0.306191601839343,-0.5652919923052305,-0.40674718164854384},
{0.3086165435938802,-0.5544980076186707,-0.3830729092612388},
{0.30594307985425917,-0.5301226268753797,-0.41726621010180787},
{0.30879717762332876,-0.5080672519316025,-0.42696898101179886},
{0.29693320666255196,-0.5075878307935762,0.2483027009793889},
{0.30897440724202274,-0.5055375744814982,0.23592005802718},
{0.32913572824952003,-0.4872528848375955,0.25902759615357657},
{0.34226553923262976,-0.4726003009499106,0.29834773933107733},
{0.33681147294434666,-0.46427351276313594,0.3123749129372014},
{0.32092829469861145,-0.4650096665239483,0.32174665496617416},
{0.3282413695183479,-0.46313263464144133,0.3314950850321676},
{0.3313548032831336,-0.4687543180945232,0.3474785932654346},
{0.3114720431791429,-0.48584766423378123,0.3772842094217267},
{0.2964457751462795,-0.4788467939061848,0.3660780907744073},
{0.2999312909805944,-0.5134916798203752,0.26288939950599993},
{0.29894661523469807,-0.5145876998238919,0.2794977172424593},
{0.31493913514349187,-0.5270868937795807,0.27272414139759465},
{0.31350527743744794,-0.5215485182602579,0.24061794460903543},
{0.3050481203447186,-0.5152365404618223,0.23742660991580689},
{0.30861954748572246,-0.5165280136945426,0.22701592182832073},
{0.31280096493016346,-0.5122116213766555,0.2242275091608688},
{0.3208910464397673,-0.5059969696739095,0.23154398839135984},
{0.3328859870848671,-0.4936972341365473,0.25035756325895825},
{0.34131711044829677,-0.48175335965276606,0.27884467115594963},
{0.34994428781929865,-0.48288041987198604,0.2988247573556299},
{0.3592887945622348,-0.4719452522688395,0.31796435461784284},
{0.35312080331277196,-0.46437364249121155,0.3186095905855626},
{0.3474310316445987,-0.4613080707364461,0.32634981882527},
{0.31418215439923963,0.4804522739661506,-0.30538605817697406},
{0.31805877695141826,0.48234512634569343,-0.32611030851571293},
{0.3253974849815421,0.4754816340050169,-0.32150554258096786},
{0.3236117714110401,0.4664545385000807,-0.30880288501782904},
{0.32415427427775423,0.47450496863736646,-0.2923966290726265},
{0.32276447365206357,0.4809020567046665,-0.27161730738344597},
{0.35846052145159263,0.4904354081147534,-0.2163495024153293},
{0.3479394904037671,0.48974190961810116,-0.21623275115239302},
{0.342367671555267,0.4880228824464976,-0.20972371804910442},
{0.3376139125851453,0.48165803615163805,-0.2027725120666335},
{0.33038514699644855,0.466984024502145,-0.20561899997636937},
{0.3409788722268571,0.45743044688698664,-0.19747564945142926},
{0.34173725478730244,0.4507774272347253,-0.20746799553501513},
{0.34068889653434986,0.4413257816827482,-0.22321579838839198},
{0.34192509815717237,0.42828408486034497,-0.2253509647098781},
{0.3383692912537483,0.41921954083710855,-0.2119632195472454},
{0.3537606322751757,0.4112063589586668,-0.19472748893466374},
{0.3619572518154521,0.4021133780926568,-0.16401209406907588},
{0.37295890555804095,0.39915434436856384,-0.16230247909191148},
{0.38269812368905154,0.38259368838266855,-0.153965477672873},
{0.372624272006812,0.37994665889125945,-0.14617979053661925},
{0.363421548958831,0.3733935687076176,-0.14889931395115513},
{0.3574972734675045,0.3611703322825052,-0.15641344926486755},
{0.3526437852882194,0.35594756566607694,-0.16970266677507376},
{0.33272878341178824,0.34881051890829756,-0.18092520669779766},
{0.31511636476218585,0.3422339983682859,-0.19273250423248361},
{0.3011228347446952,0.34227425051897237,-0.20823238587914503},
{0.30082264581992424,0.32419442629871253,-0.2065964663818443},
{0.3084915816932417,0.3178664277437848,-0.20499399021372092},
{0.3078251182231699,0.2983070866614786,-0.21025760975920404},
{0.30661575136747166,0.28841166615466995,-0.20634594180219892},
{0.32224379906607,0.27958282751132363,-0.19939393478190343},
{0.3302611863930909,0.26401385635228997,-0.18949991609128786},
{0.3348082776044643,0.252244808373729,-0.19144183203758788},
{0.3470617532074555,0.2515332865260231,-0.17770643645907638},
{0.3578823724016836,0.24112019532506315,-0.17514071230686476},
{0.36373395371042716,0.2374324174400353,-0.18608429080716976},
{0.29928765708852384,-0.4658958146174183,-0.4317535799381679},
{0.3049509945084852,-0.4961147662912068,-0.4153284996040871},
{0.30734509630677503,-0.5347762561174257,-0.3798395200822185},
{0.3179157916997261,-0.578019281781476,-0.34743493670399367},
{0.3189933878332768,-0.5374184793818871,0.29606157737965305},
{0.32796641328505205,-0.5290758706980764,0.26216426001527576},
{0.31908811055603636,-0.5211327796292876,0.23441110302507925},
{0.30681801341818454,-0.5201535108887074,0.23056071446165652},
{0.3257939987047218,-0.5147745418964811,0.23251024026729025},
{0.3363841192649196,-0.4997642946201098,0.2494293606796966},
{0.3436273035344592,-0.49095087595488707,0.2712031708281249},
{0.343857201390121,-0.510430313514189,0.27816438978340335},
{0.3599464466162359,-0.4949420469159843,0.31240154744486953},
{0.36681534596222864,-0.49657516278089886,0.3300912662445464},
{0.3642960820038441,-0.4764913421829321,0.33511938066959546},
{0.3607713153161235,-0.4679362582161447,0.33115063876758727},
{0.35268423769836194,-0.46787738193603634,0.34071162598262306},
{0.3375326072459478,-0.6057023479620195,0.38499379796464295},
{0.3411603072941302,-0.5907515777441253,0.34929795042457},
{0.32902558554863676,-0.5733518346369555,0.3415607260767049},
{0.3361117664045537,-0.5519344863204767,0.31053913450266163},
{0.3026922681025536,-0.49268552336407045,0.40009836744486155},
{0.3158783519928419,-0.5003278247297197,0.4040871352924849},
{0.3280891723316729,-0.5028751250119654,0.387874930760293},
{0.31646931764794467,-0.5195441213636387,0.43082958280748535},
{0.3226006614169317,-0.5267814981089499,0.4284154550635803},
{0.3427747990296227,-0.5372704876437912,0.42013913225975563},
{0.3381644258301055,-0.5434829364925197,0.4444494286797975},
{0.33394996557539947,-0.5454514869464878,0.46136574545981773},
{0.3395418103695147,-0.55674071326811,0.4591236405887468},
{0.3493322949213,-0.5650502791416558,0.4585837410949626},
{0.3686008592732744,-0.5783633275271441,0.4556477372083271},
{0.41227584458424327,-0.6025348441440731,0.4385177435885933},
{0.40816752184129756,-0.6176221913110626,0.44545953737662514},
{0.39051244792753487,-0.6181040155625627,0.45103996738173974},
{0.36385691301650414,-0.6186443155752592,0.4558497989995838},
{0.3574173699445001,-0.6288861849412097,0.44664787698942743},
{0.342880936541383,-0.6280493006739531,0.44092846692174376},
{0.3178925616028126,-0.6128834518001522,0.4689545775506746},
{0.3707143975734962,-0.6466289724967668,0.42580046708515545},
{0.3685531975227104,-0.6446219722272175,0.4030413804124623},
{0.35161144779175896,-0.6216756429630229,0.3940849764955476},
{0.3065588776819247,-0.4868357443904322,-0.1862138586752997},
{0.31078615454182434,-0.5227971359693618,-0.18317792532004465},
{0.32364861915097193,0.33286085452312014,-0.19261775556410884},
{0.3174197490268391,0.3135382201179848,-0.2112500956238903},
{0.31656644348417806,0.29625402671701456,-0.21840256235979333},
{0.32727732049643515,0.28437543681593874,-0.21441799996074914},
{0.32760514522615497,-0.5323447058008355,-0.19167693663910962},
{0.3105840927505676,0.4401885082312643,-0.3417786083649977},
{0.31392361944134817,0.44767460722111563,-0.323188322791008},
{0.3112305302750243,0.43721285297231094,-0.32442652700839203},
{0.30736331991728477,0.4292979984868396,-0.3511817911285862},
{0.31348384967563975,0.4283169274111539,-0.3288364404923018},
{0.3347796405022347,0.4430580259784576,-0.28406543517781635},
{0.3252036338279875,0.4506056046213474,-0.2991986417602646},
{0.3213171985624575,0.45618363151298813,-0.33257688661429746},
{0.3161366866912772,0.4399147535547054,-0.35344652531820225},
{0.32896250381994907,0.4181479524872424,-0.32928522193353704},
{0.33255435742548045,0.4269709836063603,-0.3031565696516406},
{0.34408489639176515,0.4374369433037444,-0.26835167643198526},
{0.3584625240461542,0.45780433129162146,-0.24106612527190227},
{0.3432321916274725,0.4654962970023963,-0.27083669602336785},
{0.34066546617798016,0.47415671744311927,-0.26990368721715857},
{0.35641947707449767,0.4848864188442546,-0.23494199084333664},
{0.37106745499469107,0.4903695227536796,-0.20832570678571155},
{0.3756545980972948,0.49545010515624033,-0.1856549345331812},
{0.36559676717154743,0.4931455193348501,-0.1772514469747004},
{0.364147689746836,0.48446827709981055,-0.16931216083557857},
{0.3535581699650066,0.4704537198394239,-0.18006549285253975},
{0.351444831924241,0.45766394941285926,-0.18990744408455593},
{0.3554504215661811,0.45358866948017856,-0.20395464363629515},
{0.3473471229324713,0.4402824299161993,-0.2388832971998521},
{0.3537778545884047,0.42289370107911817,-0.24911735644701272},
{0.3553560993623338,0.4128440807910729,-0.23803579918141943},
{0.3520944735999961,0.411750263641574,-0.21437955014516805},
{0.3665027409511763,0.4061608219609325,-0.18915346723214596},
{0.37967440616062165,0.3957249011819713,-0.16615687284445727},
{0.3862989889701096,0.3795879942052923,-0.16637635720839922},
{0.3881119378266482,0.3685833365708611,-0.1575495211596144},
{0.38371163679663367,0.36773603881188466,-0.14725037758920456},
{0.37105103371928666,0.3647589817367381,-0.14613393112116058},
{0.37086118775485516,0.3604001344141469,-0.1550637005304072},
{0.36164024109636445,0.3512182383496057,-0.1799709703892363},
{0.3445182578548768,0.3437749948833709,-0.18740259880701435},
{0.31840041958361254,-0.5250438468079244,-0.26815061593800926},
{0.3254916069259332,-0.5362745973683504,-0.2722369101407784},
{0.33016646367033126,-0.5276530272621207,-0.24965545360569152},
{0.31477392109216695,-0.5788779943294533,-0.4215421500095524},
{0.3189693566985386,-0.5969730382683803,-0.4542797648633569},
{0.32509549372166574,-0.594820249114753,-0.39450452005618475},
{0.3234367446463638,0.46350051126239145,-0.3486489095271834},
{0.3250087813771522,0.45921195500890943,-0.33996766210302065},
{0.3477614597472485,0.41450723557441016,-0.30427822286554457},
{0.3504956021020834,0.4214678537513202,-0.2877321858199483},
{0.35009668526542986,0.42757917157469205,-0.2644103700754698},
{0.36161941411292464,0.4553741827912242,-0.22751096320392697},
{0.3756339713733112,0.47321389592355856,-0.20615249116755668},
{0.3701773017120982,0.47729758675339773,-0.2211897734705084},
{0.3638959636104537,0.4821901255266323,-0.23051525556511016},
{0.3802245188866695,0.4878536632060497,-0.18965191301850678},
{0.38194695046902766,0.4868063062503779,-0.17405070008703274},
{0.3759231460279938,0.49375490885991896,-0.173630355488571},
{0.37467833324855676,0.48763678221503787,-0.1673522215382249},
{0.3676502276349238,0.47101204320317397,-0.16926970583087447},
{0.35877773243013644,0.46673430096032414,-0.17537281301654423},
{0.3748681792129883,0.47004418925159436,-0.182019624625665},
{0.3645189707785407,0.4573271130076127,-0.2131048987067645},
{0.37908003609476437,0.4737495899687635,-0.18799496627831017},
{0.3320825461467878,-0.6230650430698013,-0.4076383362284175},
{0.3365096819439265,-0.6223126682930404,-0.3675097456264336},
{0.3352416390675759,-0.6111840500552516,-0.3476325927872151},
{0.3323360746182754,-0.5976501154896282,-0.3432358964274113},
{0.33953059583997025,-0.6018779931278965,-0.2896038106971392},
{0.3282770157015429,0.2826471977093522,-0.28818917789888576},
{0.33434227385,0.29075630386729046,-0.2711721306124214},
{0.3303847464775363,0.3007658722641053,-0.24670843544896764},
{0.33364356860748784,0.3102661808639273,-0.23588781625473962},
{0.35194147537549647,0.3296821361756291,-0.2179694011561379},
{0.3639155890371565,0.33608262865368366,-0.22599920456944017},
{0.37159613995893076,0.35356868358645455,-0.21488660708814336},
{0.35770974875048106,0.35057901016557047,-0.23191126423394146},
{0.3477999095628296,0.34236677038771424,-0.2534563780834449},
{0.3390219368213457,0.34884075808617643,-0.26842577243076127},
{0.33689638295375485,0.3597304667927767,-0.2620421017470234},
{0.34887630413964327,0.36458715912336015,-0.23338917902033873},
{0.3628794466110292,0.3842706610684803,-0.2183232596151574},
{0.35118429437178805,0.3916191818119555,-0.25148041802959914},
{0.3598048631807369,0.4074615071286358,-0.2643540971682912},
{0.3488264395350616,0.3933149788866455,-0.2955074594644822},
{0.34243956470002535,0.38712916454558516,-0.29148725088224303},
{0.3415442046715724,-0.47750725840398817,0.35439595539981594},
{0.34700227614897855,-0.4966344395799197,0.3619096901946161},
{0.3502901359000721,-0.5156054183800531,0.36312246146106897},
{0.32954886350756035,-0.5197415771874039,0.39292227009313263},
{0.33190411497135686,-0.5282201620419414,0.3951463516131499},
{0.34019185256418216,-0.5313924720868356,0.38799989266093143},
{0.35203139187130844,-0.5339279570611684,0.3897703865127659},
{0.3668742222423371,-0.5432956939010181,0.3922161552507429},
{0.3530523145787682,-0.551418818220887,0.4223770316822475},
{0.34794369585234625,-0.5604332973800856,0.43578039708246},
{0.3656304107601809,-0.5761386452287582,0.428769513782056},
{0.36829426204590665,-0.5739910628209908,0.4438108012741307},
{0.40801051842767483,-0.591592467200505,0.42940113210675745},
{0.43449643357934536,-0.6062891081685431,0.4256502724930419},
{0.43152197987712876,-0.6206783508713889,0.43394622072356936},
{0.42761291529305356,-0.6401680016629544,0.43224021041661576},
{0.4134822075480993,-0.6395862479428346,0.43868996672088356},
{0.3936607268376909,-0.6485564697622239,0.4368275537786756},
{0.3783933464196212,-0.6353689840557426,0.44253274542497256},
{0.33073179611504666,0.3256515141016701,-0.203002009403383},
{0.33125567485233864,0.2903445704254432,-0.24860529301763365},
{0.3390441656209785,0.27898965900220324,-0.2304183299883329},
{0.3523512062227822,0.26832083647573796,-0.21375714375544955},
{0.3536126405370798,0.26517576171688034,-0.1927266967082552},
{0.3398574192724093,0.2727754078183695,-0.19545202764701947},
{0.34507477888352145,0.26071418129328355,-0.18233503326910344},
{0.33490199902994316,-0.6790469732585538,-0.36656772514469743},
{0.34861516580882185,-0.6855796369776682,-0.32917207534081155},
{0.3431947431091722,-0.6602348002071484,-0.35439655617818444},
{0.33934395402683715,-0.5474124275411222,-0.18789003032328686},
{0.34727583056608136,-0.568393210243191,-0.18630037076035713},
{0.34636264744603107,-0.5828457349341808,-0.18145329088366888},
{0.35003901054205827,-0.6110210388579443,-0.1876843638618194},
{0.35151712558791165,-0.6430669575502019,-0.20193482676155228},
{0.3491268287192887,-0.6656363985179198,-0.21671577696063016},
{0.3297959836764512,-0.5598183005902447,-0.27891796611690106},
{0.3289076327289636,-0.5524315302906445,-0.25099198521604593},
{0.33429521287780445,-0.5457662948115578,-0.23528343321607473},
{0.33716633270064694,-0.5322493822997074,-0.22413659136777608},
{0.331491580491685,-0.5198539227423048,-0.22746950949650366},
{0.3356281398179481,-0.5265764324258508,-0.20817691400979108},
{0.33992330463348314,-0.5380773329926252,-0.1966668015080338},
{0.3481812035673418,-0.5739746415455864,-0.19955974961159675},
{0.35291273373783066,-0.6078607443804191,-0.19367572627095667},
{0.3557211723508978,-0.6446890591450282,-0.21887457389794213},
{0.35537472349175586,-0.6613103937461374,-0.22677841411332525},
{0.3492279597446451,-0.6831450827692357,-0.24341396713582114},
{0.3375542352672122,-0.6882789341871328,-0.23365372176191476},
{0.3468116291467225,-0.6959226373689752,-0.26954241915826144},
{0.32944192495797553,-0.578943879690527,-0.27912443361619316},
{0.3331889796420242,-0.5902729576439234,-0.27203264549550393},
{0.33105681721238034,-0.5681979572734435,-0.25595922076642497},
{0.33799540684911367,-0.537430094430344,0.29535906720747396},
{0.34056994241739597,-0.5265782347609562,0.2776487216838135},
{0.33407112254637106,-0.5216620653718957,0.2509401180169027},
{0.33761671621753137,-0.5082619041229817,0.2507859182356661},
{0.3484809919732004,-0.5238733302867195,0.29879111376699646},
{0.3613506659227695,-0.517909603682531,0.32193810300625486},
{0.3641296663957823,-0.508913147874386,0.3430300297064877},
{0.36191299447564257,-0.4859233623082065,0.34426502977257334},
{0.34305596330605925,-0.591941919951489,-0.23896660513361107},
{0.33716633270064694,-0.5706481317194556,-0.23381152621336201},
{0.3598745534714776,-0.6062033971213103,0.3545014921332077},
{0.3668880401448116,-0.6030735420811202,0.3367897447933542},
{0.35859469528721405,-0.5785926246044375,0.318512264489873},
{0.3608484152067418,-0.5667130334060809,0.3036738398268797},
{0.369040829298439,-0.5602642783990938,0.29916079272305196},
{0.35408004610773713,-0.5402457423838324,0.3126348497112859},
{0.3420985228461995,0.26964375044307404,-0.2585924323553596},
{0.35009788682216675,0.2536300030319282,-0.24162424837619617},
{0.3612767701834496,0.2589246627931147,-0.2090210076174692},
{0.34246239427802655,0.27629937346826544,-0.24766587590882747},
{0.34446839325029505,-0.6427499468311143,-0.3285512710267422},
{0.3468244457519161,-0.6284534242564666,-0.31796475513675515},
{0.34372482988960495,-0.6142518246640347,-0.3263448123388662},
{0.3492289610419259,-0.6168726201666879,-0.3017227119455967},
{0.35425967883990495,-0.6282451544220692,-0.2632971277587242},
{0.3511394362536101,-0.6108580276606371,-0.2106577281525945},
{0.3563369701785633,0.4044289781841353,-0.28390723020745673},
{0.35902745597195723,0.41619241889792413,-0.27300510541457507},
{0.34330248269658165,-0.5236920954789024,0.3715623962405692},
{0.35659890954720935,-0.5273350152457523,0.365678172640473},
{0.38254412416727107,-0.5287907012325167,0.36007691565191857},
{0.38765033978021923,-0.5461664132049482,0.37951930521183236},
{0.370874204619505,-0.5633158319919286,0.40408232906553726},
{0.363971861944335,-0.5744943148342994,0.42155917206332516},
{0.3816235314473431,-0.5855214015278194,0.40623792185155083},
{0.3916302962117719,-0.5887505852582605,0.40580556168572},
{0.3874620958914369,-0.5832849039215205,0.42760160063378105},
{0.4122578212331896,-0.5911991576286236,0.40769861432471904},
{0.43087494157430367,-0.5982256611666074,0.4182815255444954},
{0.43777828554675435,-0.6080327672532533,0.41301910755574917},
{0.43936654329349106,-0.6177385420550866,0.4249772004609171},
{0.44038306029291546,-0.6364125360817475,0.41984855578888003},
{0.4279851976220391,-0.6563617823251804,0.4237548167405691},
{0.4085908703316016,-0.6619578325678748,0.433202256843967},
{0.3917716793878148,-0.6610516585287899,0.42819036343486616},
{0.3955597872603745,-0.6666511131822388,0.4043939327793088},
{0.39105194690240674,-0.6549319298082595,0.3847783187898241},
{0.380430185348137,-0.6366240100674433,0.3775773892655324},
{0.371728711718903,-0.6167005972938538,0.367842376583101},
{0.3847916360436581,-0.614250823366754,0.3532765050399297},
{0.38233244992211907,-0.607106567268553,0.3320089507966521},
{0.3790097450256552,-0.5989415887223486,0.31253091505354336},
{0.3760070547401213,-0.5889802828544662,0.290776930591274},
{0.37286117894343906,-0.5727634723547829,0.29025024822159584},
{0.3820036238951185,-0.581630560554254,0.2750066986788082},
{0.3889175816187452,-0.574613068691797,0.27892397390058554},
{0.3918421707163801,-0.5600397875487482,0.298353947374218},
{0.3653690721699033,-0.5478177526803727,0.31280847465976913},
{0.3693009663319797,-0.5371248990191693,0.32728683282060234},
{0.3663281147054123,-0.5279309873872589,0.3346842168713785},
{0.34193451035161154,0.3520140694283514,-0.24656985590531091},
{0.36347962420111496,0.36915367550198036,-0.21199085535219434},
{0.3727330128915022,0.3989340589667973,-0.18950071712911246},
{0.360389620792699,0.40258158470113875,-0.22295405927920212},
{0.3666379160840785,0.25211383868940596,-0.18708999379596203},
{0.3592659649842335,0.2540849925163041,-0.17965315863232403},
{0.35916663629398243,0.246367593854598,-0.17151501485324386},
{0.36634093131060597,0.24376081651387535,-0.17929869939493606},
{0.3683541396232959,0.24496017039676604,-0.19255507435433347},
{0.3655903588689506,0.244311930537204,-0.20391098707485417},
{0.36454920995641954,-0.5214337695918833,0.34800147070544596},
{0.3784482175106067,-0.5274081099472476,0.3486396975922004},
{0.4071031428318529,-0.5296796529583728,0.3447400452025644},
{0.4006920366026223,-0.5345309382836402,0.3624179486943283},
{0.41393199028661537,-0.5484239380541428,0.36402483057048707},
{0.4041485148157953,-0.5598523446977903,0.37611309212215344},
{0.39499565637239603,-0.5759990643878208,0.38735605850940474},
{0.37517417566198763,-0.5776053454856112,0.4052362240518816},
{0.39294299694684426,-0.5859473533910534,0.39573371259804196},
{0.40782187401998016,-0.5900228335831903,0.3937074874207023},
{0.3853281311266877,-0.5349422712065752,0.3318207069078698},
{0.40540874757335604,-0.5354010656206181,0.3337556137732045},
{0.4181724842706209,-0.5371036715168171,0.34198467534537746},
{0.4158270455201759,-0.5359463721197183,0.3531713688254502},
{0.4207774592762382,-0.5486498307206817,0.34696132309019556},
{0.41684356251960036,-0.5612317318317611,0.3639226982478499},
{0.4106859847618574,-0.5780150763328968,0.37356459028317085},
{0.35572377572382774,-0.6486475878147727,-0.3027806826524445},
{0.3584242744900292,-0.6607779038522309,-0.2970270282177589},
{0.3599696767131495,-0.6696509998353867,-0.26460982849379655},
{0.353225338748883,-0.6303647005059755,-0.23503250811751702},
{0.351304650304935,-0.6592461192721288,-0.3271003912669254},
{0.3550048442762443,-0.6730183625905722,-0.3152097857984805},
{0.3552145159268348,-0.6812079730498835,-0.3033372036810892},
{0.3496190664625088,-0.6918173185178716,-0.2989515215913737},
{0.35726977872531646,-0.6786718872971822,-0.2571105123798393},
{0.3788421278608565,0.37606182570137864,-0.18621325789693124},
{0.3825469277996572,0.3649025677667986,-0.18720233935086297},
{0.38400061119186013,0.3625899715671624,-0.16973450802860185},
{0.37369505931885344,0.3511571592154795,-0.19846272831079945},
{0.377445918932569,0.477802040323443,-0.16807676025058063},
{0.40750306096578726,-0.55405523396112,0.3124177684608178},
{0.4126933855503189,-0.5551983149368321,0.3198584085541227},
{0.41950721354586995,-0.5526988766646067,0.33615191842551206},
{0.3770488044310208,-0.5860484844164099,0.2785074342317907},
{0.37652993218013253,-0.5946354096367252,0.27348672940661917},
{0.3803350621064651,-0.5991346388380786,0.2646931364275555},
{0.3837633037363207,-0.6039825197525914,0.26979754970539827},
{0.3775806935465589,-0.6043532000059276,0.2647680334641561},
{0.3812848927069911,-0.6043886459296665,0.26153945051208344},
{0.3859062801765968,-0.602645988142237,0.29496295400320655},
{0.3937696679818372,-0.5888130662085798,0.26845961627885084},
{0.39943781162874614,-0.5768409551414811,0.28015336670189894},
{0.4111792238023583,-0.5683739853354004,0.3000373283626266},
{0.41669476974367986,-0.5697233335509486,0.3324577322378874},
{0.412059764631056,-0.5804750634922606,0.36399559268988896},
{0.40723531407291275,-0.5933791820682877,0.37875531538661483},
{0.41202972571263324,-0.5983432134673683,0.38784889703099334},
{0.4310898199707541,-0.5975710130044486,0.410419539555448},
{0.4262954083310337,-0.6013597216553767,0.4003322704896463},
{0.4361950342864214,-0.6294419049320298,0.389803629582487},
{0.44336011736806197,-0.6360726957846586,0.39801446754415015},
{0.44482501528980944,-0.6534842541997412,0.39097514740097267},
{0.4350932067586765,-0.6599107804070954,0.4041121677245038},
{0.4181412437954614,-0.6670414188622779,0.4246545824770572},
{0.4016703040459219,-0.6700346969533727,0.4224525294972165},
{0.4099312068716229,-0.6722790046784612,0.40711505826949396},
{0.4092535288720065,-0.6685790109666082,0.3835511288425284},
{0.4035771745873954,-0.6518407248431066,0.3727849802203735},
{0.39145847359839403,-0.624328079459748,0.3649460240687835},
{0.3989431707720522,-0.6091388002295774,0.3631743286602121},
{0.3997902682715726,-0.598354628256369,0.35014985415103805},
{0.3935353644181401,-0.6045630719159744,0.33349828037205},
{0.39400016661586745,-0.6061321047549205,0.2890406811064415},
{0.3975279371954304,-0.6040450007029107,0.2713785981117135},
{0.39207286960986654,-0.5991873070750463,0.2651377124202116},
{0.40255244695026876,-0.5974130082935452,0.2696892093396204},
{0.4059358304619464,-0.5833205501047155,0.28162327111005014},
{0.4103926046585956,-0.5864928601496097,0.2933086106359399},
{0.40996244734678244,-0.5846883221902297,0.32370298959331706},
{0.41220355092057265,-0.6076340506760558,0.38439742530422405},
{0.4006145361930917,-0.6226430963956902,0.36724900781452446},
{0.40373017281189505,-0.6372786582296023,0.3649470253660642},
{0.4163018606907108,-0.6382573261918141,0.3641101410988075},
{0.40349546872928554,-0.6003700394230765,0.3011201312420371},
{0.4054816420153951,-0.5997792740274298,0.2793609400339079},
{0.4138809241252967,-0.6527476999200162,0.36000562328552865},
{0.4174691730606173,-0.6704962949998016,0.41495000923196085},
{0.43160188340013317,-0.6744964776364257,0.3888640122142247},
{0.4196788358997917,-0.6621254497326736,0.3536696143523549},
{0.4176618226574349,-0.6704628516706245,0.366834470740291},
{0.42140967837930815,-0.6773461696974599,0.3535186187224167},
{0.42882849019189256,-0.6697951866438155,0.35045685189731807},
{0.4318261739910227,-0.6458581738500402,0.367055356920426},
{0.44420821616486317,-0.6612831584601009,0.36648862265951765},
{0.4464719490571985,-0.6677551435640016,0.3716623257091887},
{0.44043853216226936,-0.6682686088095736,0.38596926177555635},
{0.44349208834966586,-0.6768711542674689,0.3664818138380085},
{0.4343640620788293,-0.6833197090149997,0.3634911391198436},
{0.42317676782038804,-0.6782863878440907,0.3832225030749839},
{0.4237445033785773,-0.6823087992803475,0.36363592670664113},
{0.43212796499144285,-0.6820576739223337,0.35320481215462746},
{0.4396176686515048,-0.6763600921353705,0.35351000756580225},
{0.43896982931085504,-0.6653862744571867,0.3571687478296881}
};


// normal array: 133kb.
const tgx::fVec3 dragon_norm_array[11392] PROGMEM = {
{-0.9715658439488069,0.12650722478202678,-0.2001392838749865},
{-0.9215528619277097,-0.34346727153282763,-0.18102639602732745},
{-0.9827031733549796,-0.0029220329914646905,0.18516461541355492},
{-0.8150394408081016,0.5761619179612127,0.061222170971582446},
{-0.6874406198334995,0.5993636689772286,0.41010801810387604},
{-0.7238582025001318,0.2039840407790574,0.659105313118265},
{-0.7709398789369848,-0.363390721729788,0.5230668087590066},
{-0.8883583373629138,-0.4307589470147084,0.15895343344696605},
{-0.8306913042552363,-0.5567234699098786,0.0033068241923266844},
{-0.7339102478142623,-0.36098995086218666,-0.5753798775849953},
{-0.7429034632679445,-0.15391250912514592,-0.6514640310863645},
{-0.6572987120530254,0.30874910519301374,-0.6874826493635658},
{-0.5442660056173215,0.6444899775732366,-0.5370355518371337},
{-0.31782167185547644,0.9464722855931932,-0.0563879198320604},
{-0.49545951933711974,0.7800921246799732,0.382068242216643},
{-0.6065160690696926,0.4180231004228678,0.6763097999238965},
{-0.7587781870025312,0.014979652278211292,0.65117683692433},
{-0.6192988162750372,-0.12385597903228437,0.7753248819806391},
{-0.6995987354146,-0.31081933567675085,0.6433917546687675},
{-0.7567070209686529,-0.5385989305685,0.3705478058324119},
{-0.9481077947549856,-0.3073443732745284,0.08143123320523579},
{-0.8494548239279728,-0.5072380586039249,-0.14538244051197513},
{-0.44261649012371207,-0.1303537826211379,-0.8871857381782731},
{-0.1534780158970751,0.005093139009130479,-0.9881389368764549},
{-0.435730122987379,-0.02351836745266515,-0.8997700519098005},
{-0.361478290524639,0.2972370605700889,-0.883732751063939},
{-0.2319940640574225,0.6578479667179915,-0.7165296971704138},
{0.008162262038163299,0.7972481465398137,-0.6035965294112055},
{0.015339927281123605,0.9863131878096585,-0.16416754302772193},
{-0.08910546156908294,0.9959967245591572,-0.007123298813834601},
{-0.39597572663975467,0.9178275019770925,0.028211709033813034},
{-0.793349188686652,0.43922123129042073,0.42152316044786625},
{-0.8788553020632899,0.056479935137935505,0.47373344294239766},
{-0.8172945519059194,-0.17702233893784008,0.5483545449268009},
{-0.8474651485634735,0.012179789395652476,0.5307112912879914},
{-0.18155747701291483,0.12440718210883679,-0.9754792338027721},
{0.016758356107540236,0.36460191768925887,-0.9310126739834897},
{0.232243782202322,0.5828557971077151,-0.7786796166629062},
{0.23263229182448256,0.8780655604276715,-0.4181902538215447},
{0.2688807847854801,0.936639156676976,-0.22452218988907902},
{0.06610617809258058,0.9192896141214025,-0.3879904362049596},
{-0.26807450542054234,0.9352880424326746,-0.23102453814689738},
{-0.741817256132891,0.662166256033383,0.10603305085774571},
{-0.887214210350798,0.2745744366114365,0.3707557467000643},
{-0.8236197902326083,0.01626612544184555,0.5669090352960555},
{-0.8648041015976712,0.021553883771732188,0.5016465847129822},
{-0.8160049496285066,0.2805193443242794,0.5054154920871095},
{-0.8481533793413738,0.3222029978626342,0.4205009789288709},
{-0.9239685172003941,0.18179545845723896,0.33650050595330105},
{-0.8124165474362911,-0.3150020928234219,0.49066590972734275},
{-0.9640031856748377,-0.09470892109723726,0.2484513599748687},
{-0.9877821108637214,0.08248538964169673,0.13222201765692526},
{-0.9929651225425861,-0.11644258598531212,-0.021479980983231662},
{-0.974992396976973,-0.1268951250859555,-0.18244849428404838},
{-0.9205806002930965,-0.35296423934327886,-0.16717536932461818},
{-0.7330219964624997,-0.37948579585240916,-0.5645080012261959},
{-0.5776348279114776,-0.271006481799197,-0.7699957742783391},
{-0.42045063889553824,-0.07097170523953078,-0.9045353930652613},
{-0.4184808717409713,0.12949518891738038,-0.8989464700604639},
{-0.08048660489339071,0.18770945393644373,-0.9789213795477231},
{0.1521962096398839,0.13469596845264747,-0.9791288525285402},
{0.23702742268127092,0.15653989350626532,-0.9588082512359399},
{0.49340082514478256,0.4872760077797026,-0.7204982428769156},
{0.43683533305707356,0.7765822022821498,-0.4539768440036583},
{0.40653684722840644,0.8044881917530748,-0.4330433479173364},
{-0.021885724614284917,0.8674765459223033,-0.4969964359357294},
{0.02009941210257191,0.8654300596531246,-0.5006264330635372},
{0.03791196737793721,0.8883264058074565,-0.45764492729051465},
{-0.10722410492929274,0.9572952475859041,-0.2684935758478301},
{-0.3347795671180062,0.9422014833470586,-0.01337932056880673},
{-0.7329829504986864,0.6034011867529602,0.31407483519594437},
{-0.7327478167018245,0.3986004896625243,0.5515417361900231},
{-0.8195570845522999,0.15647057131322023,0.55121968893813},
{-0.9092216353300424,0.22465078542934372,0.3504968508471114},
{-0.9543813104091378,0.11661723100093446,0.27487585520633073},
{-0.9049943897702498,0.13756780566643892,0.40256707929051283},
{-0.7700234377623173,0.23105973089522133,0.5947060669400731},
{-0.8333301354958945,0.22663840173212335,0.5041784606017027},
{-0.9145413625984449,0.20967896606050043,0.3459029159871008},
{-0.9883739092632774,-0.0464399546385843,0.14477688386200716},
{-0.9478496335918887,-0.31065874194116583,0.07121950684506574},
{-0.9238331512070727,-0.3481173022344518,-0.1592063209040942},
{-0.9659638495645361,-0.17578778528866934,-0.1897695862823316},
{-0.8704152083085579,-0.31034475959489627,-0.38218254190524686},
{-0.7278486747015307,-0.3852145747286054,-0.5673147610911294},
{-0.6372573015726375,-0.42274608745738057,-0.644351516745198},
{-0.34995418398497746,-0.2355664263326849,-0.9066645068029608},
{-0.25433035263388937,-0.1265552998800961,-0.9588012452022475},
{-0.3566256681226523,0.0509137513415761,-0.9328590047592401},
{-0.4052050012457519,0.24554704536421007,-0.8806336102365937},
{-0.4283607287845739,0.30581006894933127,-0.8502865915468466},
{-0.1552660609882933,0.39607769022447387,-0.9049944273925808},
{0.26411980895463744,0.20942525556150232,-0.9414785121556228},
{0.29482147327030805,0.04123658885525628,-0.9546621615201408},
{0.3964758393973743,0.05459397862406254,-0.9164204309552154},
{0.22476323153745595,0.6711035145186842,-0.7064712043314364},
{-0.9493515891854649,0.006475865793520984,0.3141490462714417},
{-0.9038727096392665,-0.26267493319645135,0.33766255972436465},
{-0.8238288570219673,-0.5111035778530271,0.24511047926131924},
{-0.736075191533406,-0.6765766161384663,-0.020913988229944627},
{-0.8789098092810431,-0.4700240919601005,-0.08120899042989854},
{-0.7413258037225068,-0.6216026359572187,-0.25307353813904887},
{-0.7884569284231739,-0.4681143034816007,-0.39900460009557476},
{-0.8944155900461934,0.023213696045980985,0.4466339402667517},
{-0.8318544835892543,-0.2787111865480565,0.47993561299973325},
{-0.7794846625788737,-0.41735591501533087,0.46713777518630967},
{-0.7191867087123521,-0.560806066419273,0.4102036492753768},
{-0.6712700544586413,-0.7223177464484588,0.1662936774285559},
{-0.5603848087537558,-0.8281557529387209,-0.011265655441056423},
{-0.6267101091218154,-0.7639294661897528,-0.15377324153298466},
{-0.8277450788082067,0.061410018218873035,0.5577337126005143},
{-0.9528685113713221,-0.20941606857797812,0.21951425980638273},
{-0.8096700854323393,-0.4932790395334303,0.31797820980841557},
{-0.6000624222983146,-0.7721498586068016,0.2090686136151844},
{-0.3880687945968917,-0.9203819098070981,0.0479557166556191},
{-0.22436197481595602,-0.9739784387621985,-0.03205783965014775},
{-0.4979967659364798,-0.8624183700912436,-0.09074015674424496},
{-0.5998803760711202,-0.7248656233347003,-0.3386936115611979},
{-0.7151295587634032,-0.5819144287057921,-0.3872535498182964},
{-0.23100004077976102,0.7226832486382386,-0.6514352640880219},
{-0.870303690532233,0.17679963531621654,0.4596883457278725},
{-0.9291275641327763,0.3674180084781843,-0.04154487470938724},
{-0.9246073333351621,0.2618315770390432,-0.2766685822569819},
{-0.914574165026197,-0.16425053377146298,-0.36956171179171676},
{-0.9007393590374272,-0.3545270766698112,-0.2509564882381062},
{-0.5349948970970504,-0.8408096149002834,0.08258118170233254},
{-0.16560968821684893,-0.9851744730535581,0.04477375137691922},
{-0.005769172640227985,-0.9999142150696234,-0.011759215481748101},
{0.010329983165478642,-0.9974566185445813,-0.0705236525529596},
{-0.003789576835170865,-0.9750265679797122,-0.22205591827536153},
{-0.27099953845628394,-0.9493010927664521,-0.15933199750489854},
{-0.24616100899811874,-0.8171666513156082,-0.5211942263942144},
{-0.27162941468468654,-0.4938536941575611,-0.8260302596424569},
{-0.4802650496659762,0.8369130105959341,0.26253017876919804},
{-0.732747963521073,0.6033532351623873,0.31471462561311236},
{-0.7485029413624967,0.6536713238981767,0.11161159028029112},
{-0.8320421744631521,0.36705689804886427,0.41590269716530487},
{-0.8017106536647614,0.22436683702771557,0.5540032041808057},
{-0.9350871679653681,0.22113937498719807,0.276964555740945},
{-0.9912669496363963,0.08527212013085193,0.1005907554745657},
{-0.9937754077847548,0.1053753390722203,0.036145218185245104},
{-0.8039974950264223,0.21108787412347874,0.5559046117719014},
{-0.9578464773382857,0.1766127587878628,0.22657903540260974},
{-0.7727607442597652,0.5100509735281661,0.37774175905513013},
{-0.8673074124048727,0.49762784502668583,0.012015832957417335},
{-0.9781515824082648,0.021916911112395673,-0.206734445217769},
{-0.8775613849047637,-0.2603054387983313,-0.4026500891047228},
{-0.8383837376605378,-0.5004423794867847,-0.21603271335599036},
{-0.5918919075223449,-0.7992379017274313,-0.10432040189671825},
{-0.10111372949163606,-0.9681844131317143,0.2288994449034123},
{-0.001874081320277237,-0.9932370175879777,0.11608925321555165},
{0.10559086121826114,-0.9939618053594007,0.029841238477427555},
{0.16272556536910487,-0.9818387076723096,-0.09753533970655964},
{0.18013094440192842,-0.9182153043936695,-0.3527513255058158},
{0.20212422271115105,-0.732299515035447,-0.650294716933993},
{0.048718739170332766,-0.8778023215790893,-0.47653915755582343},
{0.09090653111795663,-0.5817329460204707,-0.8082838499651247},
{-0.01831917627546639,-0.29719353375457536,-0.9546415092981535},
{-0.9837470325596567,0.1361902824160956,0.11702129253043562},
{-0.9424406141518787,-0.2956409731339257,0.1562117274773411},
{-0.8567083737701796,0.01304871921329479,0.5156360084778284},
{-0.7271700865625382,0.5087944282464499,0.4608165524305727},
{-0.5794868415843655,0.346809546256851,0.7375080603326947},
{-0.4983795767266485,-0.2125019077919187,0.8405121871136441},
{-0.6670763725646253,-0.5259892801820107,0.5275835386928134},
{-0.6422750252824169,-0.7415202517986742,0.19398584502716057},
{-0.9435529410100169,-0.26264961082608124,-0.20179947830521208},
{-0.4192577875856653,0.5393301616591182,0.7303053363309915},
{-0.24866344420798586,0.4824555183650099,0.8398828277288276},
{-0.3619592695123245,0.30851626964941703,0.8796608429251087},
{-0.22675844223397829,0.026194329273489317,0.9735987191803057},
{0.1951554860529948,-0.2857369436304688,0.9382263774314478},
{-0.24290289692379582,-0.6414482804669038,0.7276965618663318},
{-0.10291043002125212,-0.9248455147324004,0.36615600127841985},
{-0.562729372335052,-0.8259342923042154,0.03417891612285121},
{0.11983867181794756,-0.9657375953322364,0.2301946778247058},
{0.3122763538967252,-0.867052873723498,0.38820457617703474},
{0.15801561408365628,-0.7460808120557672,0.6468342040955873},
{0.04465396708205123,-0.8709155560198859,0.48939975225413435},
{0.12800387300446228,-0.9154392318633537,0.3815573630023282},
{0.2061772495922726,-0.9559650859965165,0.2088580764687798},
{0.3345640016031731,-0.9417216066445226,0.03503347556453542},
{0.42423494168016357,-0.8860931379433684,-0.18671814359430275},
{0.34588116168409877,-0.8455353935288473,-0.4067383929285205},
{0.3431876126602302,-0.6457826817381749,-0.6820461791430422},
{0.38268956055636,-0.4202543109846665,-0.8227606057292627},
{0.2131473152890978,-0.4287320234045945,-0.8779277157559455},
{-0.39889765644592184,0.9134641716873265,0.08039817613315475},
{-0.26952484416902905,0.9469862860507756,-0.17485231599100778},
{-0.5556251325986735,0.831426145891633,-0.0033579685066585574},
{-0.32744457273279254,0.4892797068991305,-0.8083225966187881},
{-0.22928708771315257,0.7214250312443639,-0.6534319824603704},
{-0.1929863882212886,0.8575474943905391,-0.47683178252483394},
{-0.1020860679982843,0.911200729822342,-0.39911359873083874},
{-0.1098431599756651,0.9100988409147356,-0.3995679916762795},
{-0.36394455183104824,0.8703295983536325,-0.33176912668616726},
{-0.22689863794616102,0.9709368689891545,-0.07614856883562657},
{-0.1943988515621851,0.9787124944397508,0.06580987569373123},
{-0.4342389908055563,0.8971786348287663,0.08066595360474617},
{-0.9774834277853631,0.11688981954587456,0.17567845198404256},
{-0.6579606142351806,0.12153841574299938,0.7431798191648815},
{-0.5081643714385831,0.27440970530034325,0.8163750885698365},
{-0.03316289623379398,0.24293065627760077,0.9694766209424138},
{-0.09517577968720735,0.46337115531785844,0.8810384460285062},
{0.1848168948928083,0.13114630646976388,0.973983245062008},
{-0.7944749259100858,0.25106254752201307,0.5529712373459587},
{-0.43885091041706187,0.1915903322024393,0.8778969318961508},
{-0.2913794685864763,0.1390325168997139,0.9464501912572016},
{-0.17132219472189714,0.041477186049517854,0.984341581278108},
{0.7092345242628691,-0.03625397747275342,0.7040397990959225},
{0.6671284308024353,0.050976693614713214,0.7431964972490059},
{0.5958865805361999,-0.18491324139373239,0.7814897800317917},
{-0.17099484070727844,0.2035259111350641,-0.9640217673621974},
{-0.2346630513255619,0.486919357977009,-0.8413339355867169},
{-0.13284882672553003,0.6945171242805105,-0.707104768276088},
{-0.13942981380077782,0.8730171673402993,-0.46733323501822566},
{-0.2461663132556273,0.871372503631962,-0.4243961664910501},
{-0.18293893119515012,0.8522504110989415,-0.49010466661200175},
{-0.420072885081095,0.767739079649609,-0.48385480962621075},
{-0.5512780246027956,0.7073697428736954,-0.44240319444692255},
{-0.3859016404423793,0.8832631581301195,-0.2663195775640392},
{-0.4749782200594794,0.8590354806708471,-0.19092860817000507},
{-0.3068491820351146,0.9517375090270611,0.006268444411958187},
{-0.10840796750910864,0.987833288405232,0.11150384253042447},
{-0.0648352197352196,0.9442746453860538,0.32271006858003093},
{-0.23573713085978576,0.905914743272072,0.35177618318512144},
{0.11668857513273614,-0.8519996254452373,0.5103728192945497},
{0.2921356945347229,-0.6561484869664406,0.6957915629197913},
{0.4824322147549985,-0.7949133894256865,0.36792915279759225},
{0.5182253642707491,-0.3089507457922239,0.7974910084138116},
{0.5908066118849628,-0.6511268859852447,0.47642557204685093},
{-0.9850584407705082,0.011941827022850966,0.1718058818379965},
{-0.9154618549396732,0.1709919384636032,0.36426823788366725},
{-0.9600624218043262,0.17633141183707027,-0.21722656246131022},
{-0.9718992942032986,0.060718868881138026,-0.22743126629583113},
{-0.6073813965989902,0.2651825990105338,-0.7488431265942678},
{-0.6940025924939349,0.27550741922725835,-0.6651737093139154},
{-0.9309170583935247,0.31989836766203505,0.17623411916854323},
{-0.8129144608124418,0.3292845394310244,0.48035588004490515},
{-0.7969119702177829,0.2615408871616081,0.544543548365354},
{-0.8625246703942602,0.08758864183558521,0.49837678796536083},
{-0.9397567690360396,-0.028578186450621212,0.3406471815678758},
{-0.9651417792469766,-0.17488222834320266,0.19472429782052394},
{-0.9822068835909211,-0.18255065148594007,0.04410099169711939},
{-0.9284837341446477,0.01587220390923342,-0.37103372969566384},
{-0.6572191617106272,0.22102280044257963,-0.7205635955034781},
{-0.5516719105893435,0.21974433597409046,-0.8045933941277478},
{-0.3944969789063314,0.35957827932240755,-0.8456214251503531},
{-0.29876607106962305,0.28703251502575433,-0.9101379950840482},
{-0.5186654134100623,0.2886424878689385,-0.8047805310325286},
{-0.8382997247587014,0.4539643845003168,-0.30194355279544227},
{-0.7809988451708579,0.42338291529407823,0.459116228071796},
{-0.7293061276289486,0.38501746228283323,0.5655741560044577},
{-0.6356378020154883,0.2030209393839383,0.7448134550480288},
{-0.7269465169366858,0.05230396036522184,0.6846992458326021},
{-0.8379245605765885,-0.15702348358605517,0.5227102987172063},
{-0.8914993983823415,-0.25029432857438844,0.3775997507512676},
{-0.9085263476993509,-0.32580539969954825,0.2615926548332268},
{-0.9537185799168285,-0.29044614736773955,0.07785824170031737},
{-0.9090622173917317,-0.14196096252690263,-0.39173073664095254},
{-0.35222725354371875,0.1354720277524107,-0.9260579309944379},
{-0.3544815313071763,0.05148208578455457,-0.9336447069444517},
{-0.5844443446422112,-0.17311989069049172,-0.7927511030979703},
{-0.46411084685238735,0.2632633626283175,-0.845750272676037},
{-0.17419365478205462,0.4973993096925858,-0.8498532210629137},
{-0.07521346135854501,0.44793152536915676,-0.8908985822252313},
{-0.15266014564681965,0.2833928479764532,-0.9467752498068837},
{-0.16211098355405984,0.14033472319474438,-0.9767426449566897},
{-0.3125558537139003,0.2431957992097993,-0.918239969482859},
{-0.47227215639814046,0.31159126668999093,-0.8245422322801769},
{-0.560117950290373,0.3602064463907033,-0.7460021432550262},
{-0.6567726755687134,0.5342181532649621,-0.5322223382652093},
{-0.7061078468430528,0.6274805323988633,0.3281461413564191},
{-0.6597514952230173,0.5598963716572513,0.5012424738148575},
{-0.6012318388417307,0.4880300485084823,0.6327297588353178},
{-0.508808933273013,0.2775959426792819,0.8148950619739815},
{-0.5050908828093016,0.06988510169589823,0.8602321039486229},
{-0.6725302633858598,-0.08112303382921622,0.735610017748868},
{-0.6887982896572463,-0.2972007912109556,0.6612326412608758},
{-0.7527631323453341,-0.3897317254356756,0.5305250689369657},
{-0.8120392981146931,-0.44380287115053596,0.3789870576628406},
{-0.9145077124540785,-0.3669797552191741,0.17029827691812854},
{-0.9247352723533185,-0.3762119220596974,0.057699789997730275},
{-0.9264991606904035,-0.2623511257184215,-0.26976136134416084},
{-0.414918551938111,0.024181007960123176,-0.9095371757721691},
{-0.2641322228684955,0.14079577273952165,-0.9541544524977223},
{-0.40526840870195485,0.15507364392360504,-0.9009493225861487},
{-0.5596314917999661,-0.289434858289521,-0.7765565376665561},
{-0.5463254939861572,-0.30113305305933974,-0.7815672325372541},
{-0.4652337198102676,-0.27525877863389303,-0.8413026748658765},
{-0.38909635391444103,0.10442123326143872,-0.9152596535490071},
{-0.5208462005099788,0.28478338389176955,-0.8047469538143477},
{-0.19867016966752987,0.5018575947662899,-0.8418248738660965},
{-0.39129358753883275,0.31668408844318097,-0.8640604819559227},
{-0.6228377350101884,0.08924010822660484,-0.7772447226781809},
{-0.5893948835584982,0.18486689516385707,-0.7864082287893102},
{-0.5906612046967139,0.27177317114532973,-0.7597754172858174},
{-0.714836713263337,0.020214168875989688,0.6989991850835899},
{-0.06521939286289528,-0.06157993986839811,-0.995969046607574},
{0.022080800250856094,0.08638921608585565,-0.9960167376125528},
{0.015210890187547165,0.19756731469057398,-0.9801713038982819},
{-0.04092529026065186,0.39400561024222513,-0.9181964385221352},
{-0.008188699648612739,0.6231850662767384,-0.7820315328474433},
{-0.09301111348045059,0.7717079261313364,-0.6291389429332749},
{-0.5068485389817757,0.7218633636462847,-0.4711876937668378},
{-0.5787649352602398,0.6489653467846306,-0.4938371476366624},
{0.7015237555894268,-0.10621400634861086,0.7046864587879375},
{0.7314281244511236,-0.22397458721512378,0.644087170376593},
{0.7959148674303317,-0.5578221795687898,0.23527418002084804},
{0.6585267629237389,-0.7248659195670398,0.20226690575428175},
{0.6661338609668349,-0.6750539959384163,0.3171242372336026},
{0.518281163243069,-0.6911486658832668,0.5036845813355733},
{0.4151185884446502,-0.49820975482861557,0.7612250637763656},
{0.22328903889343416,-0.5824723565178839,0.7815804238864671},
{0.16655550214466336,-0.7695777056852534,0.6164490405682863},
{0.35333644797072394,-0.7925827100268559,0.4969567408758198},
{0.4634471360163419,-0.8289860703277666,0.31304767579520154},
{0.6075728247640756,-0.7616285187179426,0.22533810615098948},
{0.62327076487198,-0.7816965825202936,-0.02200014845383913},
{0.5814663822365786,-0.771667507958733,-0.25773262015015447},
{0.5657983536167321,-0.7023189429070139,-0.4319957470607434},
{0.5225872926065261,-0.5594438816234484,-0.6433700839487877},
{0.48404762435815013,-0.378209436716836,-0.7890852421199911},
{0.3572182235712881,-0.3109195311805695,-0.88075205698257},
{0.31139192364457613,-0.2777676494798424,-0.9087795127484849},
{0.18038536712827546,-0.2567130084101379,-0.9495048976382447},
{0.05147691395859962,-0.22090413692297253,-0.9739360808695894},
{-0.7855803294767092,0.22133253071788514,0.5778195711338283},
{-0.40424247026042004,0.7145081775306217,0.5710219693493614},
{-0.48598341620459606,0.6421196066457309,0.5928764879258092},
{-0.8950308949479857,0.09923515658383067,0.4348241952633159},
{0.779570206299138,-0.0384370822415236,0.625134292899916},
{0.8433092360851929,-0.2551932215150919,0.4729756357637861},
{0.5460583124372815,-0.8051018382665617,0.23158443263300657},
{0.14470685609548253,-0.13776591107108566,-0.9798369657987572},
{0.1014873222845162,-0.11257949059334901,-0.988446347412575},
{-0.2842942340378088,0.1753705881349718,-0.9425613748239686},
{0.024040118327082072,0.488523091963137,-0.8722197322519116},
{-0.3184979023981957,0.5897716816061241,-0.7421108069172918},
{-0.8708407581825947,0.11551588361079936,-0.47779959661094307},
{-0.8859293668723699,0.3814486875206744,-0.263867496486166},
{-0.7471179410277463,0.620348395011084,-0.23871039148230053},
{-0.7389797205927083,0.5488277004109534,-0.3907647985864995},
{-0.6245059670104358,0.6584098358025899,-0.42010568347353655},
{-0.13510521993530358,0.8490214672356685,0.5107926465007359},
{-0.19837389810884348,0.8103572573828407,0.5513337573158953},
{-0.41237060879317416,0.7094233214817143,0.5715496758300184},
{-0.6957939677305895,0.503394467108598,0.5123131512602169},
{-0.9582686337339348,0.06352325682929014,0.27872212227144494},
{-0.949538165515751,-0.3111432453305982,0.039587284753130704},
{-0.875965491431779,-0.35644952186506634,0.325004917167183},
{-0.5802845371014514,-0.13784683968466296,0.8026631328209269},
{-0.3268503217944302,-0.5953186222450376,0.7340058617961762},
{0.328739907291844,-0.26936961177929475,0.9051906349513464},
{0.5596771937518439,-0.23890863790929745,0.7935263710339973},
{0.7012890270353443,-0.11755344632303201,0.7031179757461745},
{0.4870775799705553,-0.2774207628126769,0.8281262895539906},
{0.22360172818191454,-0.2818378405040941,0.9330432459506097},
{0.2816831730711103,-0.4153152823332882,0.8649669394080978},
{0.40722998332760085,-0.5702050037143602,0.7134633798718113},
{0.5449037877935878,-0.6307908688354993,0.5524334727747374},
{0.6481549783029519,-0.6364307307554974,0.41815194493284813},
{0.7310535579343936,-0.6527011029613321,0.19885161710311683},
{0.7077808252542597,-0.7064310479136395,-0.0012157080390352442},
{0.7424323765128614,-0.647383737741376,-0.17230340221095428},
{0.6723561458238138,-0.6294040461505611,-0.3895994864758533},
{0.4543544331763586,-0.6510515703860018,-0.608024589758433},
{0.5619455652977259,-0.4908330592425127,-0.6658078473530147},
{0.4180085358782508,-0.3812923987320525,-0.8245513753563685},
{0.2103941181987929,-0.3858261019945636,-0.898260838535797},
{0.180668354515826,-0.27989516333997666,-0.9428773214026477},
{-0.5263104346172116,0.050360876857426164,-0.8487998047214627},
{-0.5195914153906032,0.22421274312143827,-0.824471592521143},
{-0.4196802721781844,0.30902635700046444,-0.8534466473210066},
{-0.32551982804765284,0.14947603096289525,-0.9336454132674814},
{-0.90424795723266,-0.19318245335580864,-0.3808098889944852},
{-0.6678488165670784,0.1248856488993418,-0.7337448690852586},
{-0.6001021737269948,0.15843141228063284,-0.7840770808351051},
{-0.5011570065168681,0.250394184594644,-0.8283383409816516},
{-0.24875495323259844,0.3047684341316566,-0.9193678125751333},
{-0.4156372819240286,0.1340944648514161,-0.8995911984735165},
{-0.618731949468148,-0.010863009298524373,-0.7855270649292266},
{-0.5567928480259341,-0.21639911477192128,-0.8019682958278949},
{-0.6373816636987718,-0.43180814520997074,0.6381898937705849},
{-0.6728499526769328,-0.48690478612309607,0.5569530235424448},
{-0.8059950249395953,-0.48623127404954797,0.33756653849096846},
{-0.9224393905267705,-0.37503158261760644,-0.09196131166927621},
{-0.8893535629423266,-0.22153839036058764,-0.3999637254529828},
{-0.7106842741531757,0.013512612883359693,-0.7033813132038967},
{-0.47058375513224043,0.16155830074674063,-0.8674386692242081},
{-0.18924098805666223,0.28029890192970036,-0.9410740534178712},
{0.007202324929504468,0.29704913776988784,-0.9548350309167422},
{0.005797871616477224,0.22767446306789177,-0.9737200437248203},
{-0.7982356271921118,-0.20942208889788616,-0.5647674496311395},
{-0.8594819777597007,-0.17352889474202318,-0.4808102043383496},
{-0.8273023876061444,-0.050173544382331924,-0.5595117290149395},
{-0.3319243098959332,-0.17564536656630084,-0.9268090190022421},
{-0.4606020276437827,-0.31606349074517454,0.829427297566466},
{-0.39321251535019713,-0.44934363320928644,0.8021684468154113},
{-0.5080973815464691,-0.5050298335105535,0.6976975835775299},
{-0.34521275194778517,-0.5441819864433823,0.7646529418783213},
{-0.5902514365998718,-0.5474753874480595,0.5931896338696292},
{-0.6657571381496402,-0.5571416874683754,0.4963472303616612},
{-0.8761193574281442,-0.4640427687828197,0.13068733787199965},
{-0.9172904835732115,-0.338121336560049,-0.21036190365384524},
{-0.8498457291137717,-0.18066844873829868,-0.49509711000729834},
{-0.6434548509959104,0.058882888042312315,-0.763215998407808},
{-0.42974266470316635,0.18646901323161974,-0.8834877187817882},
{-0.14701924018352328,0.2797501907232432,-0.9487492681452611},
{0.1621439869861804,0.33415447577551827,-0.9284665388711721},
{-0.02466959292260008,0.18657736908032785,-0.9821304885462503},
{-0.8088534184366721,-0.3010388983240881,-0.5051056614007895},
{-0.885966928790938,-0.22371911594809096,-0.40621713189888703},
{-0.8223435950912681,0.0033766947599863204,-0.5689812031560151},
{-0.7238476846638189,0.1431170174820826,-0.6749533678068892},
{-0.5550497758514588,0.3963200820212083,-0.7313344918120218},
{-0.46952961058904846,0.44757806147787854,-0.7610622994629288},
{-0.46507698810529585,0.384624958692531,-0.7973500086446825},
{-0.38328419024286076,0.2550512797905712,-0.8877173391271943},
{-0.6556710671296483,-0.07357374507492974,-0.7514534954105393},
{-0.8082034398198226,-0.2665622053817566,-0.5251207389976333},
{-0.8918437201833881,0.04409767911523714,-0.4501890419213959},
{-0.7377319176425068,0.2743048025630568,-0.6168537046839809},
{-0.722848664308855,0.20351121954581097,-0.6603582300735572},
{-0.6463523478498415,0.27661590208736625,-0.7111345056607717},
{-0.5083003935739532,0.5750849563464255,-0.6410210627402146},
{-0.5999896843572274,0.5996563791216436,-0.5295513248436211},
{-0.5205484516461232,0.8222201618773695,0.23018104807124348},
{-0.5064161563682842,0.7515875162727883,0.4226805909337152},
{-0.46873521912757715,0.6586061538012902,0.5886639351314922},
{-0.3659952733799745,0.47518972993226205,0.8001513484525423},
{-0.333023891752459,0.21807212249597663,0.9173546952581353},
{-0.16801058079210673,0.0025388412282353443,0.985781922651819},
{-0.031634816027618945,-0.17657704834908927,0.9837783207670425},
{-0.48161376293092706,-0.1107934069591741,0.8693520600596123},
{-0.11363510760384989,-0.31771863865213973,0.9413511188567698},
{-0.08771113134543751,-0.4029101486394577,0.9110269861872552},
{-0.17716338034074164,-0.48429278130015835,0.8567809747227109},
{-0.9917526371666526,0.037182216993583816,0.1226547569906354},
{-0.7543864290913657,0.5576287962371328,0.3463397771118763},
{-0.8397129205869521,0.30258955247242275,-0.45091215744740104},
{-0.7419319653069317,-0.23155511399098444,-0.6292210963090925},
{-0.7782399065790708,0.03627280491627441,-0.6269186003232836},
{-0.8184204390735974,0.23228298918516327,-0.5255783460548821},
{-0.8160829795936695,0.42944789313503856,-0.3867597154557267},
{-0.7529853959939968,0.6576873312407889,0.021456181979390032},
{-0.3120132609658772,0.6328069361752737,0.7086629004751851},
{-0.31065929560230443,0.43419473655636254,0.8455564634030248},
{-0.07139959331894785,-0.005311089172829637,0.9974336521321542},
{-0.09055940521469154,-0.9808616558978263,0.17236416714774427},
{-0.5167301511926056,-0.7739349781824031,-0.36608004643010805},
{-0.21040629718515544,-0.8935729487457615,-0.396555891867258},
{-0.5749412582145924,-0.6449108182049926,-0.5035201943962012},
{-0.831612788517807,-0.03268009511084322,-0.5543935257172323},
{-0.9102990263557718,0.08294997591528759,-0.4055551554491536},
{-0.9475752922309921,0.1974463575685909,-0.25122898207859334},
{-0.7130297991657277,0.7011298913371429,-0.0023196929210767105},
{-0.4551580041245736,0.7398428914032381,0.49544292034646253},
{-0.09984600708150491,0.4324409825602287,0.8961169407349824},
{0.13488529617073688,0.2890914645866955,0.9477510654069727},
{0.39302226249541394,-0.43975255545232805,0.8075587849538466},
{0.14458535729201374,-0.9894627070723951,-0.007656746679130328},
{-0.9862488839720053,-0.16521938975947106,0.003961326984979833},
{-0.8959648280151262,-0.40543212460560424,-0.18130587220939945},
{-0.7990724781647591,-0.5999850100844936,-0.03874483595965826},
{-0.8625416189237192,0.3353506944835632,0.3788955889606546},
{-0.5846424274609602,0.6422038354692104,0.495749398104719},
{-0.7459582741556608,0.5078916672830045,0.43080425662149374},
{-0.9312302125343632,0.24042848598639907,0.27386937468342953},
{-0.9981983767460525,-0.008530502203147595,0.05939049750345495},
{-0.9564831107038367,-0.24243154369354705,-0.1623792029807866},
{-0.8633356661656595,-0.41148392098719394,-0.29211728859364344},
{-0.6875602250995303,-0.6168084025745912,-0.3831557534142796},
{-0.5410849375097343,-0.7579069694513235,-0.36442299057166727},
{-0.4698304235657127,-0.8534566494792801,0.2255462714204426},
{0.1652082901437511,-0.5415490167614495,0.8242759752124803},
{0.2978861360593114,-0.3026791104308443,0.9053447995390742},
{0.16467725030747427,-0.3794183511345559,0.9104521503371302},
{0.2539435003974753,-0.325167088442868,0.9109220950221075},
{0.39976349362135083,-0.4536982592842063,0.7964590627836018},
{0.5506132477815031,-0.5521084087459565,0.6261001168818872},
{0.4486963300250897,-0.7933554007901145,0.41141075758804935},
{0.5550064839110465,-0.8186824727692491,0.1474001750240639},
{0.10605866651355864,-0.9842486752167812,-0.14144293758041454},
{0.6049201325778553,-0.7420327750948397,-0.288892703069913},
{-0.1757351454710893,-0.932938695784516,-0.3142332709216856},
{-0.4866367473729959,-0.6639618829428267,-0.5677493232979209},
{0.06989068522365086,-0.5412384309409303,-0.8379595771823175},
{-0.5862539731353674,-0.45422616537940386,-0.6708091156713052},
{-0.4312563263137292,-0.25182325508158415,-0.8663734929085156},
{0.13593867388408454,-0.21257078484917055,-0.9676437042482342},
{-0.24679544726666702,-0.07174072467166213,-0.9664084414118238},
{-0.18580574413729292,-0.13477239361077917,-0.9732998650806483},
{-0.6980630281560337,0.08392496838280872,-0.7111009832671961},
{-0.4682445432212441,0.39636864158452884,-0.7897081408418961},
{-0.8176118980490408,0.12073126686369313,-0.562969577659515},
{-0.777531932749413,0.03093553542066338,-0.628082069639947},
{-0.8875813719239286,0.1430791545927159,-0.43786717590460034},
{-0.7692814455200241,0.6045490722227608,-0.20670383850625798},
{-0.68125947625469,0.7296168839363601,-0.05953762413954425},
{-0.5640811422077454,0.7926299295535045,-0.23140929061213533},
{-0.8641684991165699,0.3190461547586921,0.38913025617177055},
{-0.9180000626437245,0.38196413412901403,-0.10667373259237958},
{-0.9512944382143743,-0.059600896816318534,0.30246756011362314},
{-0.9166182837182353,0.017741684510901138,0.3993696966272633},
{-0.7553972518640861,-0.5986666856822102,0.2664079415679345},
{-0.9009617733978882,-0.4308771783994012,-0.051114968554261966},
{-0.9504457335939773,-0.045197471107099436,-0.3075875421705649},
{-0.7767297197018489,0.22326768402089908,-0.5889333441093579},
{-0.7667099928482982,0.36219828345300464,-0.530064326596555},
{-0.7866827400758504,0.5960959353239934,0.16062348009231217},
{-0.8924710243417919,0.2723871632857825,0.3595840708199367},
{-0.9358118663600671,0.07711717801127357,0.3439608867811361},
{-0.8818166355179099,-0.3766284847794244,0.28381403379084097},
{-0.19662740931205056,-0.9749824919068432,0.10366678533818684},
{-0.21495452076428856,-0.961111426799506,0.1733764092326654},
{-0.6360874492008062,-0.7715517624115136,0.010031694218781587},
{-0.9288096484593573,0.04646665274984038,-0.36763227158538553},
{-0.7177534918375036,0.20576314480308586,-0.665200310580065},
{-0.7651697738142162,0.3164196686494292,-0.5607083114533673},
{-0.580809248422541,0.436262175775699,-0.6872670011969846},
{-0.8226782461199811,0.5236304809521375,-0.2213856878363759},
{-0.4212505942811602,0.8921287669786794,-0.16326114034536965},
{-0.31022231479370177,0.9198562222505583,0.2400555056460258},
{-0.6767436001339242,0.6829311396628589,0.2749966511733621},
{-0.843688693966319,0.45650027563925505,0.28248342608848964},
{-0.9243568806652417,0.17264357804013988,0.3402330849995665},
{-0.9129110297921531,0.27196193991846795,0.30435202466816946},
{-0.9787402477877134,-0.023380422274954085,0.20376673726270966},
{-0.8462198202864194,-0.516474086603392,0.13102111899083999},
{-0.07277976199472802,-0.9830779063446655,-0.16810989352497874},
{-0.3269948846118575,-0.9450068092134769,0.006039534571558747},
{0.06030504631795306,-0.9981085586970138,0.011941794017625204},
{-0.05407340548802717,-0.9768900922250731,0.20678929984749161},
{-0.7929281143654021,-0.6073461818668761,0.048945079636826636},
{-0.9409940049761155,0.1265669049499474,-0.3138647816662472},
{-0.8499926883844705,0.34688363471927086,-0.39646459319450933},
{-0.19883083568121224,0.8946597897538345,0.40006269431169844},
{-0.17368088851037558,0.8374828068474833,0.51812884227874},
{-0.25173781113827554,0.8155332356329019,0.5210888753575916},
{-0.35106622804176163,0.7622296038746754,0.5438368638714971},
{-0.373094172436141,0.7907257422439203,0.4853385818652712},
{-0.45825980244087494,0.7436052849262804,0.48687691842657294},
{-0.6701773059642195,0.5921011224254467,0.44752501538245554},
{-0.8483137155020224,0.4030103569045357,0.34343338847414423},
{-0.9698851654987367,0.16739024144990375,0.17692730940369503},
{-0.9912851456470287,-0.10800539771915503,-0.07542276899634555},
{-0.861015744892884,-0.3981366622708878,-0.3164476026174779},
{-0.605324064646964,-0.6165552022980229,-0.5034306896470677},
{-0.6367630070128754,-0.6010506062285936,-0.4829814092200247},
{-0.4877930328496211,-0.7005232459869326,-0.5208887970913754},
{-0.25056094628392656,-0.7688127187707979,-0.5883419207005034},
{-0.20602888833464306,-0.8436454261344555,-0.49579682545777193},
{-0.41595070691413244,-0.8697738603185002,-0.26547776050789557},
{-0.12512151248088824,-0.9847540105194729,-0.12084761429299551},
{-0.07342292320356637,-0.8102288432675033,0.5814966000637033},
{-0.9460331484988899,0.039999042486237084,0.3215919130535805},
{-0.9837106919209143,0.15892682595478075,0.08399725348137833},
{-0.9930230999638736,-0.09223663173832397,0.07346786170637723},
{-0.8627917984322424,-0.2811723524456143,0.4201576142095437},
{-0.8379243085000637,-0.5302068988256906,0.12947392657339887},
{-0.9401983351762325,-0.28069102306297933,-0.19297575004051346},
{-0.9942674755790556,0.09832818843915217,-0.04199707565922362},
{-0.9953252917838581,0.0965336932917438,0.002968096163068563},
{-0.9908525328322466,0.12618844183744934,0.04783027625425471},
{-0.9205180860408866,0.3132420616149113,0.2335077388586149},
{-0.9049315006967179,0.1872311742429695,0.3821563376922915},
{-0.8675159598792431,-0.0039361628335771275,0.4973937735606901},
{-0.6970029153880825,-0.4236642153399731,0.5785287966738375},
{-0.5360701006924714,-0.7141580705914413,0.45011898132901873},
{-0.43014765203280275,-0.8883204883145635,0.160809537936163},
{-0.6442369413373737,-0.7576976421989008,-0.10417795554958598},
{-0.7302370217545617,-0.6033512647231424,-0.3205013937816995},
{-0.9982583177408136,0.056415944740814634,0.017250282324714955},
{-0.9705265141924627,0.22149036442457967,0.0949752795020597},
{-0.9114322360323496,0.40243326023461035,0.08566650557839967},
{-0.8066317214640092,0.5675663977152976,0.16496560281613232},
{-0.8280126055502033,0.47798588521576063,0.2931290135494421},
{-0.8381172487639142,0.2944496232430905,0.4591937463603019},
{-0.8046949567212014,0.12737281676244638,0.5798639428154366},
{-0.6890614815919839,-0.17653595195678123,0.7028722019350123},
{-0.40484252552188804,-0.6621485229334292,0.630604363373849},
{-0.33337039032475924,-0.8249566453290976,0.45641068806731405},
{-0.1763969231156658,-0.9734207778695723,0.1460688698084664},
{-0.10763740570612801,-0.9941528456746075,0.008620227951414218},
{-0.28754511643425956,-0.9409702901480077,-0.17858532715086764},
{-0.42053467282046597,-0.7696094689870591,-0.4804704509137273},
{-0.6781132081728073,-0.5931619741220912,-0.43396007806844006},
{-0.3141032991878112,-0.7566489770288253,-0.5734295449316898},
{-0.452591431933383,-0.6895690287023928,-0.5653808896619418},
{-0.23764086688200445,-0.7449823060810223,-0.6233202884663482},
{0.001817049739303117,-0.7538008753403663,-0.6571004022722421},
{0.008410253670604178,-0.7633013301478607,-0.6459878845827547},
{0.058970829889467676,-0.8404434337792757,-0.5386810520516271},
{0.15873139039674264,-0.318354355585785,0.9345880643268863},
{0.1739932932680156,-0.364618698632524,0.914756546030295},
{0.10092301442019251,-0.4189825199962382,0.9023681028814924},
{0.03057191361135748,-0.46811614866836276,0.8831379447481797},
{0.04639982632256863,-0.5424716259357959,0.8387917448162026},
{-0.067016298549288,-0.5416754911766417,0.8379119750828821},
{-0.4144238993524827,-0.5778368876768918,0.7031055133373415},
{-0.3801168776607958,-0.5717886794137965,0.7270274172351646},
{-0.6062729291648843,-0.3777761682019394,0.6997987582873317},
{-0.8206318407153007,-0.48307641512952443,0.3052876662261754},
{-0.9621442347028195,-0.26009775777678,-0.08141024522513828},
{-0.833793333896589,-0.025459771478196325,-0.5514893257225287},
{-0.41289244698352184,0.26281082515489973,-0.8720380137387133},
{0.09112739600713396,0.41815792734959534,-0.9037918706713672},
{0.264485043974541,0.34410183972731867,-0.9009115302903276},
{-0.24801118123840063,0.05234678377540831,-0.9673418569508424},
{-0.8237832998757604,-0.41661969000067156,-0.384459502092935},
{-0.873301621180139,-0.3693121645213145,-0.3177307092188644},
{-0.8717456487105,-0.288370087549707,-0.396108844335599},
{-0.8555220640296657,-0.17143122713249276,-0.4885625162886203},
{-0.732431753770301,0.09785122119770323,-0.673772116207757},
{-0.6439434707391029,0.22390275273737048,-0.7315766288018679},
{-0.5888164400347136,0.32689965257328235,-0.7392102658190793},
{-0.4805088665434997,0.4816029129940646,-0.7329187290339307},
{-0.3237545801375789,0.6302014421253295,-0.7057117784075131},
{-0.171933100041285,0.5790082931328241,-0.7969870799414549},
{-0.9976329658349287,0.005199120019104047,-0.06856700832347196},
{-0.9979315550595848,0.06428256666168454,0.0006025277960445504},
{-0.9524850662102111,0.2406436041470166,-0.18671597261526351},
{-0.9625892027514913,0.14790969554430528,-0.22703468613901132},
{-0.9165815402147001,0.2921619404746118,-0.2729829311069791},
{-0.8804163358119645,0.38658652366665003,-0.27462326076785387},
{-0.8609962976591198,0.37763005787973797,-0.3407064936320327},
{-0.9254522541661159,0.27054841766631454,-0.2652200576070902},
{-0.9676070257185628,0.2162688649670301,-0.1302475405754334},
{-0.9579144710048855,0.2539477798454993,-0.13382971027007537},
{-0.9893038792640979,0.1392343239325715,0.043492959338802414},
{-0.9917506337510812,0.10263666892767492,0.07678798503515813},
{-0.9992360331351563,0.011459824976853241,0.03736338442668804},
{-0.9943883556344147,-0.10552826343038195,-0.007455454114444361},
{-0.9882659586216381,-0.1076215341705373,-0.10838819314129251},
{-0.951783321022307,0.08112452270576936,-0.2958501675502471},
{-0.9087974989665984,0.24042075709017324,-0.3410058143672093},
{-0.8306608500812487,0.39445790429735295,-0.39294467025223495},
{-0.6833089371425972,0.5694968073864817,-0.4569051135604182},
{-0.6872255635113463,0.5513457928333788,-0.4730104032486445},
{-0.8450326496154317,0.41003623763075,-0.34320563065535803},
{-0.9328035697498389,0.3068564463690277,-0.18898841653320875},
{-0.8760437735152247,0.40928485103789114,-0.2550161124244839},
{-0.9121127998530077,0.3740964827075632,-0.16763669637086248},
{-0.9756072227184887,0.19729544362514348,0.09625515520882649},
{-0.9807911780262113,0.11052134614919357,0.16072864446428606},
{-0.9769723986800022,0.2089119968740422,0.04336715092720372},
{-0.9874284522101588,0.1073090786670916,0.11605952525092465},
{-0.995170651545636,0.01935200707571604,0.09623343558439326},
{-0.9906166543457481,-0.09242080244338927,0.10068286551621708},
{-0.9485147839414309,-0.2511051235114629,0.1930438333406006},
{-0.9576875916498706,-0.28329982179142965,0.05075123419991554},
{-0.954011135554578,-0.29823887996057497,-0.030270839395806867},
{-0.9590173526459527,-0.26738869988223113,-0.09374966932868901},
{-0.9611218090250345,-0.20424094846030008,-0.1858238498914546},
{-0.9455701949206236,-0.004580867636426164,-0.32538595871590975},
{-0.9211804484196775,0.17364702507896618,-0.34824315087384927},
{-0.8662663486164439,0.3062684307714754,-0.3946926165606744},
{-0.772714219090573,0.47790481280668334,-0.4177555810655973},
{-0.7021127317422126,0.5355957922637562,-0.46922793952923053},
{-0.6041419220381647,0.6405285030046516,-0.47406304947195804},
{-0.4030173223219642,0.7574592066658814,-0.5136463648713263},
{-0.4120004345952591,0.6953590815826168,-0.5888390183691102},
{-0.5523353130118343,0.6141991731758183,-0.5636355894283648},
{-0.7337585874501101,0.5299637396065883,-0.42513147383535305},
{-0.9508193248378344,-0.12999809407146679,0.28114605999855485},
{-0.9421744341430482,-0.08973415985485744,0.32288560854019116},
{-0.8333610067325932,-0.27640136305582075,0.4786561594281674},
{-0.9049055249827725,-0.29843196242618186,0.3034540404379396},
{-0.7957561124678416,-0.444543024970107,0.4112830028344164},
{-0.8587197049343447,-0.4390495459138741,0.2642649514980998},
{-0.8473747404787069,-0.5225281687292918,0.09444766848925908},
{-0.9005536697266968,-0.43252931203789563,-0.0438347142092206},
{-0.9098574777567002,-0.37960435365341316,-0.16751090966737137},
{-0.9173474384555157,-0.15583945814919728,-0.366316448501659},
{-0.9143410421857976,0.022425369652151556,-0.40432358497935045},
{-0.9132231533285455,0.18071836065297908,-0.36519083551968795},
{-0.8668420691336324,0.2644006397471517,-0.4227021751557707},
{-0.7677736318369631,0.47413105649758863,-0.4309563684647902},
{-0.6548319747397899,0.6143089675969117,-0.4402494488223735},
{-0.7014122795152817,0.5851956477808076,-0.40689908818228804},
{-0.3650311148854779,0.8035007388834373,-0.47025402473475464},
{-0.18245900075806007,0.794348290808463,-0.5794130702116097},
{-0.31812899884078844,0.6938125778997085,-0.6460789787980401},
{-0.5883262293303666,0.6325663719398956,-0.5037182079027028},
{-0.7738623076720726,0.5441719848269487,-0.3240586053385308},
{-0.8156745898031817,0.48481822751831327,-0.31563626188290245},
{-0.8932507809853857,0.4291409521665726,-0.13394433710525458},
{-0.9546360804943496,0.2829354630629437,0.09283036981367399},
{-0.9666653504721837,0.2150004408655835,0.1390428373706997},
{-0.9625960522214609,0.17184799509033993,0.20946862970642816},
{-0.9662088509252819,0.25755574301238826,0.010271106804197391},
{-0.9255042377741897,-0.0012248076530764246,0.37873527127563533},
{-0.7083303789026548,0.7058310526932647,0.008402343574213916},
{-0.44698459090272574,0.8942090863960496,-0.024390270647640603},
{-0.6757568823651287,0.7282407235682776,0.1140968206082592},
{-0.7824510699980168,0.4186199137996486,0.4610072568076704},
{-0.7597049604342334,0.2206887722077501,0.6116738010680657},
{-0.5416912931973098,-0.05725080974609338,0.83862559444465},
{-0.39025693816248747,-0.42720234496371784,0.8155965170803153},
{-0.1516343652543477,-0.598789557189616,0.7864210611845125},
{-0.2059018184057191,-0.7824329629374208,0.5877100472904873},
{-0.11099366659908894,-0.9702458742788953,0.21518213080939672},
{-0.03131740349761202,-0.9993284946713487,0.01902051461091414},
{-0.02061291475138466,-0.9997866503479034,-0.0013272270232789621},
{-0.03897818860878671,-0.9977695026719438,-0.05419151548498911},
{-0.18191547326487142,-0.9082073340359854,-0.37691670033319785},
{-0.048096291042052056,-0.8177517846107537,-0.5735579879610482},
{-0.039545534230496025,-0.7393035856727528,-0.6722100556625402},
{-0.742481774476438,0.6014829171946084,0.2948543960896355},
{-0.5032776545037653,0.8402895519238467,0.20155662084091835},
{-0.32402507836637506,0.9460484819681435,-0.00013548223431984627},
{-0.3498458997416906,0.9280605453194283,-0.127716368000865},
{-0.6230100666383838,0.7723047496573788,-0.12411216912088145},
{-0.798802234829055,0.4952567208804729,0.3415197945285578},
{-0.7184831177682561,0.30782320839436234,0.6237201951643118},
{-0.40562271940195505,0.002015914708805905,0.9140383720571307},
{-0.01023332073308005,-0.24326058919724594,0.9699069877520126},
{-0.16521647164198827,-0.37402224879331597,0.9125847220427061},
{-0.008376294026909608,-0.4528676953531013,0.8915383829112157},
{0.04022928495341249,-0.5355000814576336,0.8435764739435334},
{-0.09470710941503806,-0.6944735016650061,0.713258101188758},
{-0.06994770117813029,-0.8531570461451345,0.5169432983537011},
{-0.00510101917059508,-0.9936559356135519,0.11234705703033691},
{0.12708904183791325,-0.988153488827506,0.08602940173422705},
{0.024416982925546015,-0.9996850287267063,0.00580123129153092},
{0.03282796420072188,-0.9980633875760472,-0.05283747861756155},
{0.03138089354068239,-0.9496601320836277,-0.31170638917336185},
{0.2833067922732654,-0.7051366269021382,-0.650015075865866},
{0.2576130581317989,-0.6600585094460125,-0.705661587723103},
{0.2753047142030159,-0.6881781857640725,-0.6712809389339649},
{0.09713067103267524,-0.7456208879415982,-0.6592534597633334},
{0.12258849630434342,-0.7516185361179609,-0.6481061924852544},
{0.23489380744803173,-0.7312551222069128,-0.6403833582071914},
{0.1773991123462636,-0.725328713362744,-0.6651524731295106},
{0.1629794425568657,-0.7375542388510767,-0.6553254504875131},
{-0.08086398282831703,-0.8404305472862862,-0.5358521358259338},
{-0.21700120849852667,-0.9241286006487655,-0.3144786240321171},
{0.030906760973350926,-0.9851269040574786,-0.1690259004657675},
{0.09497998141507615,-0.8362710702514075,0.5400273143008206},
{0.2743338414032082,-0.4330513388945645,0.8586078740278267},
{0.43495316171839776,-0.46212178100319423,0.7728254697107264},
{0.14381806682455076,-0.6501391890631496,0.7460800215118746},
{0.24244464243825134,-0.7233376330978318,0.6465317191734794},
{-0.5445683424816932,-0.7528784910479018,0.369620478442653},
{-0.559204120678877,-0.8217574267114063,0.10956953527514661},
{-0.183315583544081,-0.9789003672095484,0.09027440338714118},
{-0.4576686497162867,-0.8840185677541192,-0.09513453070692349},
{-0.49858656531545886,0.7241888784644481,0.4764051901431582},
{-0.5512643225716942,0.7267059045966819,0.40988556315621716},
{-0.7072628058758444,0.6840455178428766,0.1784966468696221},
{-0.7022898118881289,0.711389098744847,-0.02673144786820733},
{-0.9789572456084333,0.2036033891256485,-0.013724839062780405},
{-0.9583683057160284,0.2222098804928598,0.17931246362241005},
{-0.7896267078088557,0.2516726115821865,0.559598569417712},
{-0.621586882330469,0.4020742396166584,0.6722842059362792},
{-0.5563468990781679,0.287335846891061,0.7796898351123371},
{-0.05761179380128097,0.00333725212042724,0.9983334833427573},
{0.16263260403509977,-0.18726687914815338,0.9687526784886188},
{0.2257700559221115,-0.2497192192658652,0.9416306034630423},
{0.09544819767403262,-0.3130782097377478,0.9449188727865401},
{0.4245975765839671,-0.06557755761043452,0.9030041427905369},
{0.2129710533596472,0.20842521494923621,0.9545691489903949},
{0.3730567353038369,-0.02204022295789178,0.9275467108541808},
{0.49381807850874,-0.14929479365032153,0.8566532378546432},
{0.4729286627694707,-0.46834940182948176,0.7463158297510827},
{0.2322665434417182,-0.9576866259443917,0.1699664063422045},
{-0.019123926650119655,-0.9978327620135008,-0.06296073762265862},
{-0.22953748864635362,-0.9655729062320558,-0.12239895447472898},
{-0.8758730909955684,-0.35973954597111146,-0.3216112366419544},
{-0.9933092289867554,0.00215577473793714,-0.11546483553453282},
{-0.9568986723107072,0.06892941267014933,-0.2821234960065431},
{-0.9559688482040509,-0.006016934088968746,0.29340647192519304},
{-0.7588662414343933,0.5055251063892203,0.4105683797145179},
{-0.4096546347444081,0.2634109701138791,0.8733829292218223},
{0.12170740718151726,-0.08704674467604337,0.9887417111048041},
{-0.9255325694302826,-0.1929546852020327,-0.325818895066513},
{-0.6735068246945336,0.3848048199344089,-0.6311210720972118},
{-0.3451330565375491,0.5930918365282679,-0.7274099578151066},
{-0.24089922822930002,0.5833099429943642,-0.7757042427642376},
{-0.11827077876638611,0.7387300811928138,-0.6635434349240834},
{-0.3038884122342526,-0.9152269606279595,0.26459675630939355},
{-0.44670577916693427,-0.8159465165371247,-0.3669948623752027},
{0.11487879212607931,0.23192178605642116,-0.965927092627623},
{0.4425058236747046,0.4472953083870067,-0.7772486752056538},
{0.42537375717690273,0.5213996230618678,-0.7397294098358855},
{0.4144459901032296,0.47337223034160103,-0.7772729590232583},
{0.3267614037769867,0.5241110181202168,-0.7864697233121457},
{0.3126882594152927,0.8781324118123404,-0.3620904855812655},
{0.061080677990338346,0.9977744924016239,-0.02674346815434899},
{0.12380881471586795,0.9705979514931241,0.20642430563284722},
{-0.07364915313969514,0.9838061616997548,0.1634051359150068},
{-0.5430407230484292,0.8112073889347818,0.21690861036079853},
{-0.7355683418155905,0.5814789263570826,0.3475938329735972},
{-0.5142584986548727,0.7816535965772832,0.3529247108365096},
{-0.6973712891027904,0.7032252191681775,0.13837476742882407},
{-0.9713825671938279,0.23722355738924253,-0.011869792395880789},
{-0.9647953337488308,-0.2599877715384837,0.03970292970217169},
{-0.3981118026465742,-0.9150730334683771,-0.06440757729085468},
{0.007340713269005293,-0.9772304333472902,-0.2120537527811509},
{0.1629733929008137,-0.953941460124049,-0.2518637803710457},
{0.13838967842507907,-0.9870555211585116,-0.08105365541357508},
{-0.37562817448262115,0.9251405676715586,0.05494000894794016},
{-0.3480673696751999,0.875676970997328,-0.33472219620505084},
{-0.22700693084903603,0.9738761022111683,0.00576115339867316},
{-0.4257281102228939,0.8795555359987061,0.2124561960971541},
{-0.5335236014773481,0.7456155451154842,0.39926185085577515},
{-0.39998719458854176,0.6476375089198979,0.6485182350599074},
{-0.20229833659757568,0.5429952323998153,0.815004024898604},
{-0.11272557981559085,0.3486876102388479,0.9304353250608878},
{-0.039221239378460865,0.06724125582601463,0.9969655500048926},
{0.20450173473474853,-0.12082973406551918,0.9713800573699949},
{0.3451956993240959,-0.23027309532212958,0.9098429703739617},
{0.44193770851528896,-0.3095928214508353,0.8419283500977782},
{0.3917768141885149,-0.2860953339295079,0.8744486192842099},
{0.29247715816109454,-0.33112831692160205,0.8971126739081758},
{0.09393720039878915,-0.40186432968951213,0.9108681918392127},
{0.3203309292456854,-0.4821662101350897,0.8154163608688264},
{0.4283111107439056,-0.3542685695210238,0.8312901858333522},
{-0.14634168213551882,0.19539822970779896,0.9697441125868231},
{0.23495470342677865,-0.4352127466937402,0.8691295372111828},
{0.13268273000164668,-0.43535280933520715,0.8904286746074908},
{0.2819965893117499,-0.5247620142090967,0.8031828883011339},
{0.06591486398940095,-0.5530898447814275,0.8305099965111288},
{0.0020978580892697793,-0.5139357349522521,0.857826124182824},
{-0.3087152855568207,0.9295066135603733,0.2017729610505271},
{-0.889324908800434,0.4373941255431334,-0.13337010732340865},
{-0.9887956289017906,0.14142926189819843,-0.047759482238012206},
{-0.9500440144768573,0.30605691109336963,0.06120079843173686},
{-0.8209710489511884,-0.19644219871517735,0.5361128606440366},
{-0.7007885870290527,-0.3471288541405589,0.6232149829014756},
{-0.6597261686138408,-0.46133478654667526,0.5932382296919473},
{-0.7836207481981471,-0.4060007616815843,0.47021474297107013},
{-0.6119145898126999,-0.5420728696066602,0.575949250204179},
{-0.7305397458082044,-0.6093426738572816,0.3082420892917495},
{-0.7373541153574874,-0.6480245554221361,0.1907172885066273},
{-0.7808522298897737,-0.5918835474330684,0.19985910375615829},
{-0.8022959812373501,-0.5940460421218221,0.05857011464728195},
{-0.8137750463475235,-0.5722747199619833,-0.10134998191671886},
{-0.8421504983256042,-0.44564656505125705,-0.30361435609659865},
{-0.8834741065219197,-0.17040091096104057,-0.4363909172392836},
{-0.8844218632281127,0.01107789031467082,-0.46655680060448107},
{-0.8742479858112776,0.18249263710204155,-0.4498743121233605},
{-0.7942216549195442,-0.12505275216484338,0.5946206959338523},
{-0.658237546014354,-0.291094260787101,0.6942531702151691},
{-0.4745726271580026,-0.42905331856676765,0.7685662439758821},
{-0.4771918559994519,-0.5299015101958918,0.7010651339639646},
{-0.37441354232033025,-0.6146801860241701,0.6942497880708599},
{-0.5116077688705392,-0.7076760195731013,0.4872906136511152},
{-0.6599149083559303,-0.6853868242764143,0.3078265986523513},
{-0.71734763883034,-0.6580449462094236,0.22888690183750734},
{-0.7002908595644489,-0.703291414291471,0.12236788220112228},
{-0.7512235162119627,-0.6595283440854753,-0.02618381251853953},
{-0.7717600776457978,-0.6074594107801037,-0.18809424979738643},
{-0.7616524583073444,-0.5638026962438979,-0.3193932567580131},
{-0.8329677650316409,-0.37867826886801326,-0.40344450808669763},
{-0.8313144441083934,-0.2920403626538499,-0.472893985580025},
{-0.8676905267074113,-0.09382709440103287,-0.48816966949870483},
{-0.8708730077041144,0.0012020958027116491,-0.49150662194732514},
{-0.8629991808247774,0.14291144217995314,-0.4845706693453589},
{-0.8550450740607469,0.23773766094891274,-0.46084566385178416},
{-0.8019627653716187,0.351605608479837,-0.4829381109863143},
{-0.6857563056624779,0.5720469776187477,-0.4500006051567109},
{-0.5686449556076711,0.705966402086715,-0.4222017924958257},
{-0.3489624689460749,0.8318507021528275,-0.4315664544365186},
{0.44375908406758624,-0.8798972633246916,0.16987843094759},
{0.46648720305348246,-0.8602914794031736,0.20564109475889736},
{0.4142796803221987,-0.8513238303328329,-0.3219007337356825},
{0.9222168709804194,-0.00379417081885699,-0.3866544285882184},
{0.8784050617045879,0.09577054426847992,-0.46822275726653695},
{0.7090743721029067,0.30258994931466227,-0.6369088297398764},
{0.6634686530308688,0.16325306667660555,-0.7301765421225805},
{0.2546541418410684,0.290100877694392,-0.9224926822496383},
{0.30043510625687664,0.5205163612622705,-0.7992505643330536},
{0.4815199609192496,0.8153234020058115,-0.3215373654460616},
{0.4122065911426722,0.9105016287303755,0.03274920301123704},
{0.284326775013777,0.9573935972492736,0.05055477184560026},
{-0.012867943966638757,0.9924611427720942,0.12188230431682878},
{-0.07449317880764246,0.9751653391177761,0.20857451353040551},
{-0.28396342097657973,0.9544345307568556,-0.09175784460316541},
{-0.7664709879395937,0.40930062201537826,-0.49496992379813126},
{-0.8734256562370407,0.061421331150073116,0.48306836276726706},
{-0.9357548445480656,0.21366850999694997,0.2805505992517372},
{-0.8431127931815511,0.07640777945562431,0.5322806301306331},
{-0.7327067618401393,-0.053503523716543266,0.678438039988657},
{-0.8959240656208223,0.3857067554900507,-0.22034147909731977},
{-0.9822217345135855,-0.10902607593094787,-0.1528194327179067},
{-0.9548786322004181,0.2535187800932591,0.154709488742883},
{-0.7968931430904769,0.5751691900613842,0.18477478534559896},
{-0.6799413308532659,0.5187658357060805,0.518229480347907},
{-0.8932620852415947,0.09876898866923872,0.4385516320196449},
{-0.9664861724678578,-0.18329933568854706,0.17973823178324488},
{-0.7776471392651497,-0.6191257689387585,-0.10930786352646395},
{-0.6034150450081481,-0.6324302275740473,-0.4857183244519948},
{-0.8910658013523651,-0.0931060717597727,-0.44422178814386326},
{-0.9038146380647064,-0.15254557974491859,-0.39981113806427454},
{-0.857281814130468,0.5017410686024691,-0.1154287279615705},
{-0.6762080028273294,0.7274901225631404,0.11619319466019261},
{-0.5512335489961979,0.7240076657023063,0.4146739375284561},
{-0.6760584249228965,0.5913628325361038,0.43958503885556505},
{-0.8492317499795133,0.2062790188597209,0.486060079830677},
{-0.8631802521200985,-0.35257932026901434,0.36139683904058},
{-0.3960658978232557,-0.9167266061436415,-0.052384484056053525},
{0.0701673036830417,-0.9364350946624603,-0.3437526188676398},
{0.049129036929715146,-0.9134751469283183,-0.40391768180490184},
{-0.9454562259464996,0.27102568237166175,0.18071415084042647},
{-0.8997144727814849,0.30844180885123046,0.30883250803650164},
{-0.8678050617974812,0.18465784551486936,0.4613196882948706},
{-0.7643998123901868,0.10948443695139043,0.6353786940740807},
{-0.635892034978862,-0.016889010560712008,0.7715932096465868},
{-0.5151353410856496,-0.1697616011256833,0.8401289062684464},
{-0.610245927149336,-0.2210745086897541,0.7607404090787021},
{-0.45894925724322555,-0.3405913677878166,0.820587045635206},
{-0.20328412168259466,-0.47897850830036875,0.8539643754033828},
{-0.2786188546271099,-0.5426879841903539,0.7923769845608134},
{-0.22039879481539423,-0.6035308915512321,0.7662733416916554},
{-0.18806204530932644,-0.6896915027650699,0.6992555313529758},
{-0.3146852600879512,-0.7629563265274117,0.5646864890319017},
{-0.45352734967438935,-0.7672518262070108,0.45347279772807864},
{-0.5567358127296516,-0.7423012921343679,0.3728726679711217},
{-0.5599866487260236,-0.7598243936064811,0.3302754064854665},
{-0.4838417088428541,-0.833103060315468,0.268023304354357},
{-0.5110314769289437,-0.8579938641214757,0.05189757911233679},
{-0.6902823020347676,-0.7176192227148902,-0.09237421007867166},
{-0.7181610134337795,-0.6431971641219096,-0.2655977538483715},
{-0.7100224151369233,-0.6114320804867183,-0.3493121540324839},
{-0.751631398904987,-0.5149912364480135,-0.41210953223855257},
{-0.7583588320766562,-0.4475857327219939,-0.4738764540205026},
{-0.8271157205553312,-0.2770559458517807,-0.4889985559062629},
{-0.8549090143094382,-0.06036616031136078,-0.5152538247715661},
{-0.8603074150305577,0.09786785758371225,-0.500292948276721},
{-0.8323707635514596,0.21010272318586515,-0.5128506192787954},
{0.1856831717386175,-0.9520364036570012,0.24320453500074923},
{0.44279001116544525,-0.5316158536878804,0.7220260314696493},
{0.154059054609702,-0.9770701558576841,0.1469684259458673},
{0.06503396944119877,-0.9961290652017044,-0.05913939701332539},
{0.055028946272163086,-0.9925969690362413,-0.10827313670639907},
{-0.9284105698438875,0.3707780166297145,0.024030734201919163},
{0.29199593883064257,-0.9545731487603755,0.05940097113779824},
{0.644352970140188,-0.7195469419071344,-0.25896225258444255},
{0.9264014583678017,-0.27794570528675705,-0.25402071342049515},
{0.8694522490567427,-0.4854525695602571,0.09158924236784319},
{-0.7019606874451388,0.07146392371752659,-0.708621267595352},
{-0.555783020901282,-0.2757832294544418,-0.7842504982653974},
{-0.266685487814756,-0.06104616015786895,-0.9618483336363304},
{-0.5608250340023918,0.21848733922052285,-0.798585351629087},
{-0.7382172794819829,0.2541971513834669,-0.6248352234811596},
{-0.344100839189111,0.3401490171293729,-0.8751532772122098},
{-0.13984379080416762,0.6742711448406192,-0.7251221534395711},
{-0.10669399168822132,0.9360738835043928,-0.3352343609456499},
{-0.8763246846076483,0.3799432776813905,0.29613873926257506},
{-0.6699354631658017,0.6110706183022843,0.4216386778279323},
{0.9146720580749123,-0.08842908360285569,-0.3944050244991352},
{0.7917540060838913,-0.10437645070321488,-0.6018564200776698},
{0.4913917249378131,-0.2870314031703122,-0.8222816708748423},
{-0.1062341330069837,-0.4773451290527782,-0.8722705639615732},
{-0.22097096126862886,0.27827057014342904,-0.9347391743518986},
{-0.06432987575432911,0.7772981056021522,-0.6258349000437241},
{0.2734609955805211,0.9583255537836416,-0.08265117580160009},
{0.9351802586133212,0.05971225579956054,-0.3491021776031331},
{0.20979665029033343,-0.8695581425973914,-0.4470503351632007},
{-0.3434326577375554,-0.7893628819841157,-0.5088813713873306},
{-0.5253974994349949,-0.2282601564842154,-0.8196674743755884},
{-0.47872652248766234,0.3394064562848204,-0.8097062270348735},
{-0.735914832059143,0.6227715536401619,-0.265678286527112},
{-0.5086259613881026,0.8609258860172772,0.010307773154014701},
{0.10305964599116998,0.9946457463297854,-0.00765171067401478},
{0.10919174833747153,0.9932476491289592,0.03919527515915759},
{-0.056841738344695275,0.9931675771385755,0.10191751813424871},
{-0.13752827284733096,0.9734113505682203,-0.18318383321839132},
{-0.38223050020601596,0.7126772079759754,-0.5882100321686354},
{-0.438941322201959,0.4755434413922591,-0.7623574955441856},
{0.03468379946201803,-0.9993765629594227,-0.006596928246499046},
{-0.9174337498185634,0.3593870781865429,0.1707519918665354},
{-0.9009117953198079,0.37195027413268805,0.22363123803766527},
{-0.8416928507375984,0.36140770017325563,0.4011703120529898},
{-0.8107662840646701,0.24272185122376866,0.5326763891543097},
{-0.6351686821077546,0.04981929950930602,0.7707650632105093},
{-0.4735025134550427,-0.06170436247866672,0.8786284433154088},
{-0.35652569375789145,-0.21835414120061097,0.9084111947301166},
{-0.37542363738561885,-0.31132281407566487,0.8730035497798163},
{-0.7513471492457704,-0.6307513689239634,0.193984978595767},
{-0.45182681977975064,-0.8800688753255894,0.14605238652917962},
{0.23881942479681484,-0.9365430851879315,-0.2566170920386819},
{0.42572954277861735,-0.8596027662408743,-0.2825551993443869},
{0.31155041427204627,-0.9115217561087187,-0.2684481840269999},
{-0.05451446813350465,-0.8473154625064144,-0.5282846578897233},
{-0.5996182089582922,-0.674921793103636,-0.4300448542645552},
{-0.7660641329947024,-0.28076459746240945,-0.5782015089489528},
{-0.9535181532924245,0.26087046033762573,-0.15083015038459494},
{-0.7994868921505645,0.6006173309737829,-0.00891801622341307},
{-0.8371372303739083,0.5384856743623434,0.09609597300841492},
{-0.6515072648160773,0.6745378875434968,0.34718427694846826},
{-0.6621045252256024,0.6187836603716743,0.4227580624101827},
{-0.8488214120144001,0.3825213914822551,0.3649377968426394},
{-0.9403756322337676,-0.11637762149599823,0.31960901037967626},
{-0.6988272673754486,-0.6463900541303588,0.30630107458824707},
{0.11917987220651739,-0.9692040832653028,-0.21549849893375658},
{0.13574068366060996,0.05054769906800552,0.9894540903540096},
{0.3497234996857061,-0.045928460179047094,0.9357264826396459},
{0.3819706559347123,-0.191103799136445,0.9042000641232132},
{0.5887741874654259,-0.32827009541679836,0.7386363791673638},
{0.6442218063604084,-0.287201579217346,0.7088677712414319},
{0.6010790225048825,-0.2627078067291852,0.7547771969184788},
{0.6064636787970343,-0.14127575718496097,0.7824595623620325},
{0.2928713823418186,-0.2347777944203312,0.9268795718173517},
{0.5135421339576186,-0.3919268830170969,0.763326794380204},
{0.7040388282779565,0.001217676170923141,0.7101604364801976},
{0.6473197561290117,-0.5158399297382864,0.5611473070528599},
{0.589371889172612,-0.8055507059259438,0.061064199293203086},
{0.9856388230757435,-0.16475059458863617,0.037058764530862424},
{-0.34610046405653216,-0.4753194043876728,0.8088794301948846},
{0.19499127492135274,-0.4643823671304655,0.8639024365070694},
{-0.48518885291585345,0.33248381549513195,0.8087312838267093},
{-0.6243032342541005,0.18846602836656767,0.7581068709961689},
{0.15581560757720384,-0.2655498298109394,0.9514225056843715},
{0.10297387499328416,-0.4080512595347504,0.9071331493562405},
{0.18628641063476825,-0.5334028565697225,0.8250931861408591},
{0.34923948804835664,-0.5368507078707229,0.7679994123997919},
{0.38345007699817485,-0.5121160306058723,0.7685721889624806},
{0.44952207785446596,-0.3745439443772842,0.8109542127960797},
{0.36855460347489666,-0.2375324337983544,0.898746820384524},
{-0.12521606224916046,-0.08135477952784857,0.9887883178935668},
{0.2909977353220232,-0.24661984701158285,0.9243911342594309},
{0.4249123677556099,-0.20661946903782372,0.8813386833351008},
{0.3982621170260161,-0.25646791347954456,0.8806880807058789},
{0.4694433573845321,-0.20122520011522416,0.8597274876646243},
{-0.8509037707907816,0.4811832965404982,-0.2107733569131734},
{-0.8908816670561303,0.45410031948185975,0.011079492306206511},
{-0.8600739579658102,0.5100302851855921,0.011911969716609717},
{-0.8543694149121558,0.4470036438946927,0.2650295176155425},
{-0.8052802437316696,0.36776764203119056,0.4650491270073312},
{-0.7347794063069631,0.30388829895787844,0.6064248723656328},
{-0.7907157570103203,0.3026297174301373,0.5321502097563725},
{-0.6890323054879557,0.16908802540048384,0.7047295379506368},
{-0.5419118816542018,0.05215795387943729,0.8388152718978792},
{-0.38977446429132645,0.039999270148151744,0.9200412628648916},
{-0.26251452081655074,-0.13265280360085144,0.9557663731567934},
{-0.15478817041379808,-0.303254728630435,0.9402537911985412},
{-0.223253339363461,-0.38972798574930856,0.8934595925876279},
{-0.4860178555734089,0.776253643869722,-0.40151827410817065},
{-0.646585035888402,0.6641414211254981,-0.3752918385877817},
{-0.9228698531665956,0.19689052639326599,-0.33097636582216633},
{-0.9366967671075832,0.3045821347778209,0.17271042141222204},
{-0.9920182541132913,0.11947354746822374,0.04032189183775232},
{-0.9886133573861127,0.11466866814462733,0.09744088538029247},
{-0.9843436967854761,0.12135405734823598,0.12783066675811255},
{-0.7225091511742324,0.5685658200057373,0.3933362871522201},
{-0.9877645240130845,0.06327555736296786,0.1425392891157044},
{-0.9386510223101063,0.20139010471975066,0.2799576468631643},
{-0.9272877930482258,0.24527593072990944,0.2828021687829276},
{-0.855181506065683,0.3582091569166409,0.37463421037633404},
{-0.8292467226194893,0.4786425835701512,0.2885327541512863},
{-0.8081524529043292,0.5239666421054122,0.2689768964530125},
{-0.8443942673866791,0.2009534497268456,-0.4966045028464739},
{-0.7591569800870404,0.6371772080216375,-0.13298828957045833},
{-0.7245691530002321,0.6765843100224782,-0.13127533641904593},
{-0.8679947632509522,0.4777179435766205,-0.13553839807909845},
{-0.8305690849294458,0.5465107280675594,0.10714951827483547},
{-0.9124765991181252,0.2941014719755941,0.28441304513613463},
{-0.8170646166267248,0.41395599960426976,0.4013051739614789},
{-0.7770193383154502,0.4068173972224905,0.4803546119284567},
{-0.6510535046706576,0.49482175029479847,0.575569951866188},
{-0.8541524083786721,0.1321272356396506,0.5029573111737601},
{-0.607166503489574,0.2362415887517354,0.7586427016615274},
{-0.4013046524594669,-0.6665824099115798,0.6281898333392998},
{0.48213103884756503,-0.8647617736322241,-0.14048749497452812},
{0.48889529908437107,-0.8243333480544321,-0.28540483145625534},
{0.4547542149028825,-0.8416471615740185,-0.291253599878973},
{0.4150397226186955,-0.8850991228368796,-0.21057438448677107},
{0.094620887471769,-0.9621383137524099,-0.2556105492027356},
{0.056510800430883766,-0.9373958968128284,-0.343650203074484},
{0.1658836433746549,-0.8654652236582027,-0.4727076935052013},
{-0.030043017731212474,-0.7702523139069013,-0.6370312315786931},
{-0.5003033629397078,-0.19942227986601832,-0.8425718362989938},
{-0.5357154639780954,-0.22682596414746586,-0.8133627257523586},
{-0.04600090133664358,-0.07794171625593403,-0.9958960818997612},
{0.09892516855956192,-0.17620461822005729,-0.9793700748661796},
{0.1026821118352718,-0.03099388855812519,-0.9942312421067321},
{-0.23616942328136445,0.11224889967478874,-0.9652068110144824},
{0.10967253272684585,0.2042171995753892,-0.9727627002321093},
{0.2915106183695514,0.4784579252329609,-0.8283112779381747},
{0.28286139926419657,0.5660669642517573,-0.7743110620345679},
{0.11085867731503819,0.8158883173517649,-0.5674826933685873},
{-0.026251391805757383,0.8368235051568339,-0.5468430173690535},
{-0.38897688524450186,0.8529263123364458,-0.3481575627063663},
{0.24472829252598605,0.0635543892112937,-0.9675065387113903},
{0.3715277266371752,-0.11301029365120606,-0.9215182157009597},
{0.4562871399809085,0.1425003102972656,-0.8783482836854786},
{0.18454698130353414,0.29830932370013524,0.9364581993262279},
{0.48462661921184547,0.0893591905797985,0.8701448011740461},
{0.4965141357588946,-0.0916424608703344,0.8631774860115544},
{0.5860260812177696,-0.4101943104013562,0.6987947193896789},
{0.6051937259093821,-0.4331366314315901,0.6679320419264332},
{0.6953659886592433,-0.25218146456956425,0.672956648487481},
{0.7049217001990814,-0.2389509440025224,0.6678232123464559},
{0.7119010785516143,-0.11370360719056943,0.6930139566191299},
{0.5073598967106422,0.1808059490567299,0.842552754428743},
{-0.6219632181239556,0.677497854124792,-0.3926301223253189},
{0.011165328999145366,-0.1732397335785642,0.9848163941253054},
{0.46260721899993273,-0.23523584892312638,0.8547857370771721},
{0.24908121008204778,-0.31956209605516234,0.9142421000746433},
{0.0634920294653734,-0.47905867285774684,0.875483609300678},
{-0.45240102204180477,-0.4536671359196668,0.7678016964307756},
{-0.4633758463644155,-0.18805559643308523,0.865978012224478},
{-0.46387536407490865,-0.5921221717946775,0.6589468721175669},
{-0.7937143266064288,0.5485720123113372,-0.2628427572682826},
{-0.09220191610032936,-0.539086780006902,0.8371883003776497},
{0.3026625090223598,-0.640246288183478,0.7060312288415924},
{0.6486287448279723,0.25063353939857114,0.7186540059802312},
{-0.5250820786325268,0.6314094445293572,-0.5706232768281309},
{-0.6981027577172189,0.5305618177628912,-0.4807875801221895},
{-0.7318937964168197,0.5611612468946269,-0.38656115395916635},
{-0.8278770040919478,0.52496442209029,-0.1975652338726347},
{-0.8165695174610046,0.5550617780083771,-0.1584949391863387},
{-0.8164107601548848,0.5579463162540271,-0.14889385105465},
{-0.8401337383917885,0.5423223123252059,0.007862008018299253},
{-0.8221726033134347,0.4601113006428736,0.3351563834712581},
{-0.7260858557910512,0.3892836778017752,0.5667958611504679},
{-0.6664887626361958,0.2964864710511479,0.6840237581862998},
{-0.5787174994659533,0.20378688333279535,0.7896562302631317},
{-0.9974304594417924,0.0697243244462845,-0.016461991320738348},
{-0.9869132596277658,0.1498593294309583,0.05953485830504305},
{-0.9955686687164983,0.0848428183155128,-0.04055517291715239},
{-0.9884939859772744,0.03990177605756748,-0.14590232333383743},
{-0.9889982396637143,0.11778578630467507,-0.08949296333603071},
{-0.9637844328426788,0.25995988109916196,0.0595014893009019},
{-0.8924449256778029,0.384275275592859,0.236378017590412},
{-0.8829212051628151,0.39078243922176814,0.2602676135629005},
{-0.9472477705580927,0.257669987137148,0.19059863299998947},
{-0.9411353757041382,0.2340307727998892,0.243913513321663},
{-0.9910525902215563,0.08959108445759602,0.09893533747279588},
{-0.985319633460239,0.09134122178529833,0.14422898848896168},
{-0.8069986737985715,0.4151079616320466,0.4200458554456098},
{-0.844836119204549,0.34554874264790314,0.40847031488450947},
{-0.7343571160655938,0.4544871985067934,0.504143841058552},
{-0.7506273308908101,0.472151582491497,0.46220287025343487},
{-0.7910858906062159,0.6036356600927553,0.09903082120306758},
{-0.9318145729770011,0.3575764430569294,-0.06213444260990441},
{-0.5953666308607637,0.22089971901763625,-0.7724907047954899},
{-0.47515330338474876,0.13044581680096373,-0.8701799969901},
{-0.45914478340810394,0.47697612014603036,-0.7494530330044471},
{-0.5837871211817895,0.5698500182908124,-0.5783282405314817},
{-0.5460847165282515,0.77047382927518,-0.3288792495374251},
{-0.5363368617302713,0.7477605138567223,-0.39140386388748716},
{-0.6976171736386476,0.707617997841589,-0.11228111228112264},
{-0.6262078410394037,0.7436270001326029,0.23427040891788883},
{-0.6652418582614343,0.6675855670862885,0.3343393196065221},
{-0.7951049536632501,0.43981226983397154,0.41758026768951945},
{-0.8938126164709811,0.15820668173266483,0.4196065448636828},
{-0.8300250968482751,0.4023796142547217,0.38619811578286206},
{-0.8353089101009682,0.457587471152516,0.3047502763742434},
{-0.92892557433751,0.04479450502791209,0.36754690810974244},
{-0.7495272934467644,-0.4699730258915708,0.4661911531900716},
{-0.6886616564952975,0.10185394972693494,0.7178933735577838},
{-0.5939587767936029,0.3217209163154615,0.7373660037423659},
{0.09148937493766995,0.4173431100058173,0.9041318614030737},
{0.44141706181229734,0.22938428727315358,0.8674870755770289},
{0.5722327305003787,0.12526425680505984,0.8104681166530594},
{0.5778193061070261,0.025644440240090043,0.8157617373809384},
{0.5612094396125281,0.0024818277223490276,0.8276701066372693},
{0.7296570033737022,-0.1827112135344346,0.6589516445661877},
{0.8686322456167599,-0.29508564378154556,0.39799809636330635},
{0.3351494189637125,-0.5077473735655331,0.7936419038871303},
{0.44338079123938257,-0.4055283254067142,0.7993498928834388},
{0.2165422700720835,-0.13993686395273072,0.9661920716809387},
{0.5900451064592885,-0.44901404006605194,0.6709941610528434},
{0.7128144625090468,-0.42977646121874286,0.5542451943140627},
{0.7630176404685723,-0.1533588385748379,0.6279212904216174},
{0.674750550621757,-0.039253790044672075,0.7370012445055737},
{0.7124210950610936,0.700745288984846,-0.03757955930418484},
{0.47908089431159395,0.6192246391735718,-0.6221272723052439},
{0.24816382048974459,0.30780792063224544,-0.9185145628654927},
{-0.7552736196589976,0.47152542421864135,0.4552203134336451},
{0.33993895978933697,-0.20936054157566442,0.9168476794149004},
{0.6887805780694286,0.17336526092055426,0.7039359357074277},
{-0.315517312103017,-0.7758419031015814,-0.546368160817414},
{0.9108061845363895,0.4127427969459576,-0.008687794857853573},
{0.8429908458787314,-0.048371552536466335,0.5357486599795401},
{0.3601773065920798,-0.24460034765342845,0.9002460651088106},
{0.19247811863015518,-0.13670234474340548,0.9717328042163911},
{0.16054027670107346,-0.2307148631578325,0.9596861317507955},
{0.020244593384709363,-0.3979078917430475,0.9172019767353813},
{-0.3814412187999435,-0.49307261100868566,0.781909199890557},
{-0.5669191805171033,-0.4019530698151668,0.7190524128517889},
{-0.5818282244994601,-0.42048146762450744,0.6961833469425607},
{-0.04889336308561234,-0.5522569419336193,0.8322389735720777},
{0.37949422500281277,-0.4709290901432627,0.7963729812382846},
{-0.24946812214592867,-0.4560813226905831,0.8542572698700269},
{-0.37942039903012476,0.06026108608074833,0.9232598563265866},
{-0.954227023848691,0.069209496565118,0.2909653459470265},
{-0.2572734767317494,-0.2903489771696672,0.9216874902193727},
{-0.49397652207721765,-0.6001732714930427,0.6291098789733274},
{-0.19469720394874196,-0.7121449196335324,0.6744943381635545},
{-0.46112190542432707,-0.8358863813586218,0.29775920774516196},
{-0.05297198547717994,-0.780142683762144,0.6233549243625214},
{0.4193566986233818,-0.2990949862794793,0.8571360151703907},
{0.269227925441461,-0.8937304279568196,0.35883456676664705},
{0.15409721394486897,-0.9864341613003496,-0.05658351415478903},
{0.16648444864142703,-0.9677956936187216,-0.18882379027447085},
{0.21824506707060345,-0.9423500775484913,-0.2536639943777989},
{-0.4433388520828265,0.03842490325857859,-0.8955301162124311},
{-0.731104137663433,0.261023792168624,-0.63035967495813},
{-0.46124506193755394,0.7275987248016783,-0.5077923675137245},
{-0.5025117065469367,0.8593248292600131,-0.09509375689568261},
{-0.5832469699189459,0.8073883622044832,-0.08914597386943808},
{-0.8908289487516055,0.3369896128842918,-0.3047323167539086},
{-0.9187061970925509,-0.03168512856444975,-0.39366861197153824},
{-0.9417505839452139,0.015358862054694947,-0.335961222457642},
{-0.9787939658858404,0.01986986659877814,-0.20388124177278982},
{-0.9640734664563144,0.11822110171367418,-0.2378783772950175},
{-0.9477824738282499,0.3100642025254809,-0.07462286925762449},
{-0.9367515662970797,0.34429910355865967,0.06288585157784911},
{-0.8051016325300502,0.5493536314168828,0.2236558717014423},
{-0.7757436089421116,0.5395655658210362,0.3272473886308232},
{-0.7176675527138211,0.570338032842056,0.3995845493454529},
{-0.6934978600101506,0.5753254656417414,0.433660381802921},
{-0.7708335853434539,0.4943234272834409,0.40182077216752826},
{-0.9712966199633751,0.22959225590855872,0.062211510788131044},
{-0.8236557470066813,-0.0652791079814819,-0.5633203781898963},
{-0.9532649604357328,-0.2892656352809068,-0.08724280744562382},
{-0.9525241013766335,-0.07100501606055087,0.29606776925372646},
{-0.931291280338253,-0.32533897973003667,0.1638630508508743},
{-0.9070718103280441,-0.2626960465425728,-0.3289551915369435},
{-0.8307969460353788,-0.024049365707453276,-0.556055808770448},
{-0.6688306611816099,0.32491739839453393,-0.6686510531539587},
{-0.5919924904626492,0.4141690783651632,-0.691381852352216},
{-0.8557626102315261,0.4664185037086998,-0.22388419847738836},
{-0.8476546160046389,0.44592738619043853,0.2874550716397117},
{-0.9144131414394052,0.33421745068739084,0.22835783853185315},
{-0.8409338473795029,0.29469817720807456,0.4538537745593235},
{-0.7343321636166017,-0.0029666352875320104,0.6787838187178825},
{-0.8238053843329887,-0.14133828952162975,0.5489701054329613},
{-0.6456869401031838,0.6405845078457677,-0.41561985478100444},
{-0.5322676094297392,0.6341191107227521,-0.5608780129120204},
{-0.40271480833512174,0.7141680158930193,-0.5725249586027097},
{-0.6632314834730699,0.706850597752334,-0.24593948806013047},
{-0.72940845568924,0.6600346996334892,0.17977068740138846},
{-0.6131051163020738,0.5769052401703886,0.5397059016058348},
{-0.7084287631637146,0.40072360649748495,0.5809899127506245},
{-0.7422408542641389,0.5114879466187883,0.43296488855903426},
{-0.6192586901996147,0.34001902127375894,0.7077469461497469},
{-0.7409360641943852,0.6652803365596668,-0.09173779244777215},
{-0.6648121929401233,0.6513673338739545,0.3657121060070076},
{-0.5366669211097622,0.5854981109148074,0.6076023188745745},
{-0.24197777439484164,0.5385719132358909,0.80708552890778},
{-0.046311532995051134,0.4796183197360069,0.8762542492252221},
{0.3213623784838873,0.2246111525060096,0.9199326344168364},
{0.478110226819276,0.17966524787557248,0.8597272879911569},
{0.5971278966151266,0.04984790868225333,0.8005956913973498},
{0.7726759542914049,-0.05350604144096294,0.6325416770373194},
{0.8436581078082795,-0.32098260526985245,0.4303616667914694},
{-0.7195430173626844,0.36707457970799545,-0.5895032647041086},
{-0.8359734098059582,0.5133356302279451,-0.19399739388939713},
{-0.8140653313449268,0.5805752802078407,-0.015165101841461795},
{-0.6016910654492627,0.47722377126335197,0.6404883557877653},
{-0.3469761478726458,0.426510977176214,0.8352819518914861},
{0.08231777700380022,0.25321518681513844,0.9639013708649486},
{0.13728908672402085,0.32048258493328774,0.9372526977400291},
{0.47366566345573047,0.07607221811979681,0.8774131620242409},
{-0.18055757952618307,0.6250135455995279,-0.7594452108564206},
{-0.42267536622193635,0.597863544590447,-0.6811055107976285},
{-0.5435631008381683,0.5726196033731563,-0.6137148729173542},
{-0.4529546035994397,0.5318943499539415,-0.715486217592728},
{-0.7017281852324704,0.5709793953565719,-0.4260986788627574},
{0.049783712417328374,0.5406229679055573,-0.8397906813908663},
{0.29515307946181557,0.502482165296324,-0.812647730104087},
{0.30930195876332434,0.449120660217415,-0.8382260619135175},
{0.17959587164460872,0.48442698339002727,-0.8561984703629478},
{-0.6068801782003699,-0.17450880684075049,-0.7753986881872478},
{-0.808129221878545,-0.4605938165487226,-0.36712463401828405},
{-0.8416566386660052,-0.46991473101565706,-0.2660718853316227},
{-0.8581727280769245,-0.3634062805090589,-0.3625954275381589},
{-0.8338134918405136,-0.25376769162768653,-0.49026219465780274},
{-0.742669745419207,-0.014129938054098977,-0.669508770733855},
{-0.6653322646265845,0.1295126464079173,-0.735227483209978},
{-0.5722472796686714,0.25118007876341764,-0.780667418907827},
{-0.524014988659411,0.37583222315031345,-0.764302578631114},
{-0.31703587428469704,0.63699766020723,-0.7026537093811234},
{-0.13419364727107286,0.7847685885297575,-0.6050870412503467},
{0.04262417287541873,0.8155593754496399,-0.5771014512222956},
{0.21479307435945982,0.671935106131541,-0.7087786314183057},
{-0.075023359725156,0.43787752035499716,-0.8958988629657416},
{0.4371174132031592,0.5395755766571133,-0.7195738767838381},
{0.7143549511796417,0.19378622833143788,-0.6724164642795473},
{0.5896957462508391,-0.14903450457843712,-0.7937554052091399},
{0.4890487480569524,-0.05729113707602333,-0.8703729359512875},
{0.3121911913381024,0.13662040792889896,-0.9401444166659916},
{0.21758883239623136,-0.9457879315664717,-0.24112297385288656},
{0.3001444601331981,-0.9480927921179362,-0.10503980476641742},
{0.18483669191933505,-0.9821493200360061,-0.03490143941340654},
{0.27821736873141245,-0.9604034350151086,0.014843778068579718},
{0.05637222976085209,-0.988419079724681,0.1408896538004274},
{-0.8146214017415984,0.5687022955908471,0.11388446256735092},
{-0.6067455267208601,0.7398366836160615,0.2906914986376688},
{-0.5090363363010945,0.7333249770245919,0.450684464339565},
{-0.4688560650698619,0.7087280160807151,0.5271419063871693},
{-0.4596360623301454,0.7154005636149653,0.5262477779383287},
{-0.4583680705180132,0.682800072656966,0.5689312548183969},
{-0.5754042884363378,0.6093017681669846,0.5455834126489348},
{-0.5801579744518075,0.5757578583367338,0.5761246507861589},
{-0.6443892472087795,0.5240728897325269,0.5568753041113433},
{-0.4439764082850093,0.6668532494022986,0.5984911800920196},
{-0.36391164995252123,0.9148559398995114,0.17494833597212447},
{-0.2960723369547396,0.8352892052836871,-0.46328513339703187},
{-0.3198098175730124,0.8696852659303591,-0.3759909823487222},
{-0.45329402303858296,0.8849479805037618,0.10673144091508392},
{-0.34610718435301513,0.9246969825396943,0.15857271966265854},
{-0.43693415946341835,0.6198492886248014,0.6518246694359793},
{-0.4561159765178291,0.49522785342223374,0.7393967738366145},
{-0.9153035760171171,0.16702829450269127,-0.36649817539218355},
{-0.9158802066907314,0.3351025533769078,-0.22106498074643055},
{-0.8761871418942989,0.3358708808232304,-0.3456686907923931},
{-0.7691675513143945,0.5837179228980804,-0.2601051027807195},
{-0.8179509139868207,0.5725079846393286,-0.056488138864180686},
{-0.4431462355717377,0.4101836664389529,-0.7971014826766387},
{-0.4425644443656026,0.38060144580320665,-0.8119601295851133},
{-0.5331868625671335,0.7901347819342897,-0.30232233785062795},
{-0.9237613679270434,0.26232423088885415,-0.2790178005327415},
{-0.9566529037337186,0.06314156775770742,-0.28430329614505595},
{-0.9110620742791179,0.04387459429485526,-0.4099279409673035},
{-0.04638607457393755,0.7866673393389072,-0.6156320567539233},
{0.22420280669910533,0.6304560940050774,-0.7431407773767396},
{0.10975669250712418,0.7681810437087614,-0.6307545897862452},
{-0.33367222288715015,0.44494385271215964,-0.8310762995099836},
{0.06197062199581233,0.7146244371033594,-0.6967578890146555},
{0.10488399150648127,0.10885659904214216,-0.9885087704065385},
{-0.06283492773099603,0.7063756169159753,-0.7050427360689676},
{-0.8955418639611534,-0.33510848894980577,-0.29275769934667956},
{-0.8103923245067368,-0.5292013059489907,-0.2514165033613554},
{-0.8304487471057355,-0.45146472844839936,-0.32639619697160593},
{-0.8174577075476278,-0.3782328818439766,-0.434399336397948},
{-0.7590916200758554,-0.24311007795508738,-0.6038852559280484},
{-0.7439997987449277,-0.05461590811893524,-0.6659439931764916},
{-0.6697468411532486,0.01796686337078553,-0.7423721173278673},
{-0.5744982455787958,0.08892330650426013,-0.8136611158137246},
{-0.4986305484008942,0.2688871310861649,-0.8240553906975399},
{-0.4175614822924829,0.3935856526389521,-0.8189827486232384},
{-0.4577887344874771,0.3863798675750291,-0.8007122282749634},
{-0.3217321914398309,0.5744224315096386,-0.7526800563120286},
{-0.12656408719207685,0.754215761755468,-0.6443136786945123},
{0.07458483236033954,0.8855177273779871,-0.45857982650908796},
{0.2819910692455341,0.912671023558729,-0.29582535324414355},
{0.44787412106031294,0.8122423203968775,-0.3737260823661472},
{0.6144011511051118,0.670596149992726,-0.4157066623662012},
{-0.12653353625352012,-0.9915427747420665,0.028847704587756783},
{-0.7238224348319218,-0.6892580748420375,0.031692098369096186},
{-0.5104538516045342,-0.7799187850426573,0.3621650923538621},
{-0.08433735599032552,-0.8943187198836476,0.4394101018982551},
{-0.01447081333014176,-0.6431879227409508,0.7655716110212974},
{-0.23164111884460456,-0.21747406479001316,0.9481811130813189},
{-0.004571987856306125,-0.8419412352332222,0.5395498617746074},
{0.422823711833481,-0.8965131457406927,-0.1322281672923167},
{0.23200814362159483,-0.9459439351777967,-0.22663250603919477},
{0.11272064562115174,-0.960043398195529,-0.2561459147281714},
{-0.1523376793153543,-0.9541717851130282,-0.2575838425736931},
{-0.1598252130654639,-0.9381006592933154,-0.307283345305316},
{-0.1110188242034048,-0.9325311920473309,-0.34359918005035683},
{-0.16090948591994744,-0.9488520688494513,-0.2716392622230713},
{-0.19285171162956666,-0.7466166817978003,-0.6366881087179096},
{-0.18769951533151874,-0.5222537775403372,-0.8318773249639403},
{-0.43492209574319995,0.10860215097015347,-0.8938950405047558},
{-0.38421898530128124,0.6072957877687183,-0.6953902483443565},
{-0.39505258054749903,0.7359588005990535,-0.5498164261129023},
{-0.35071188727991054,0.656908714422395,0.6674369730817135},
{-0.41033646764302956,0.6275921058372776,0.6616283942009837},
{-0.2134099680798257,0.6900144805941931,0.6916185379922184},
{0.05266763386451754,0.8230216608633715,-0.5655629638623896},
{-0.045798608145927545,0.9240960670909677,-0.3794060440727079},
{-0.6327779881023546,0.7538587628177554,0.1768869229084483},
{-0.40172185434853275,0.8521345255083823,0.3353897764920394},
{-0.35782355763943036,0.8208864632227042,0.445092929730389},
{-0.2958309836059196,0.7820402386690071,0.5485408774569827},
{-0.27815379475095675,0.7747644892808321,0.5677767630108281},
{-0.36813307736984313,0.7157728701144684,0.593419948901539},
{-0.2852480926066959,0.7318905164818332,0.6188455360978191},
{-0.36356029900712317,0.6844624097683122,0.6319296785244435},
{-0.21668039466753727,0.6710279093660286,0.709063573608585},
{-0.13866025131791634,0.6642119034852788,0.7345719038820604},
{-0.13947579595585743,0.7293325112306484,0.6697914529198447},
{-0.09700167273044911,0.8037440404712991,0.5870146445314337},
{-0.8393008554943503,0.28733511455404487,-0.4615328871387885},
{-0.7305917034322797,-0.32718774283479407,0.5993195673550068},
{0.6969463532427114,-0.401118298328421,0.5944492337010768},
{0.6563258721051982,-0.34445525208035604,0.6712577216834154},
{-0.6670367146192384,0.41697782044603865,-0.6174070930966408},
{-0.5970016920056247,0.4874905919562094,-0.6371357017909179},
{-0.19371667034870757,0.08208893480915527,-0.9776171328341727},
{-0.18709764779071614,-0.071425014437238,-0.9797412604886157},
{-0.8172316570344814,-0.09129200640232557,-0.569032677715185},
{-0.8973191138173537,0.07065949845014374,-0.43568984754847484},
{-0.7685658905267783,0.43748998597779487,-0.4668072236886758},
{-0.6149604539125008,0.7001051970994848,-0.36287236477585705},
{-0.47104873793081525,0.8053521933406714,-0.3598901654326721},
{-0.3437788690730801,0.8842579553333988,-0.31607587318305524},
{-0.20716081496609495,0.9301798635098503,-0.30306734938521485},
{-0.22858479972353804,0.8897996708820387,-0.3949753600334653},
{-0.1336624925796189,0.8900223664058022,-0.43588361448306245},
{-0.06945021779028161,0.8224391555009947,-0.5645976467783878},
{-0.06685955310615423,0.7623016897676951,-0.6437592204665981},
{-0.12377790461147072,0.7125839020537554,-0.6905817930294987},
{-0.039791434704751445,0.6833948778346848,-0.7289637046338135},
{-0.022894058293761274,0.5853331321903705,-0.8104696085943334},
{-0.046707965003859,0.5386528203816763,-0.8412321350852354},
{-0.18161442006528006,0.48266019105971897,-0.8567702973321073},
{-0.35040073241343794,0.5672828934271769,-0.7452579724826945},
{-0.2543440012180248,0.39696424006564524,-0.8818891773649964},
{-0.46253617566534844,0.5279542452334681,-0.7122672259347842},
{-0.6860783415204892,0.5815836633220561,-0.4371006198272799},
{-0.4080442502506472,-0.7865078643969958,0.4635787625410208},
{-0.27775755713475464,-0.9329451332972373,0.22905046979112173},
{-0.07048657128161745,-0.996046090541829,0.05407244016409702},
{-0.26693441584719174,-0.9636852342545886,-0.007535709389105787},
{-0.39879417146923873,-0.9052359541250945,-0.14666654751985225},
{-0.6163576174613878,-0.7072435242871259,-0.3462800669274036},
{-0.682985391031848,-0.593188120070916,-0.4262145115359236},
{-0.7387019476981194,-0.4822953576018268,-0.4708615725483775},
{-0.9015910001592741,-0.3146895674377168,-0.2968234232294726},
{-0.8801698829555683,0.07298447669530087,-0.46901411844367147},
{-0.8826975039532831,0.21168163163513187,-0.419566446874547},
{-0.8312391779885518,0.2786019773947287,-0.4810637870061137},
{-0.8141372903623989,0.31379398803455705,-0.48858346831911875},
{-0.8198090296400454,0.33322137847881816,-0.4657001909440486},
{-0.808843808476808,0.5442580997222468,-0.22260910667684128},
{-0.45275580066037313,0.8812504858366763,-0.13568259350781336},
{-0.3894091721015995,0.8855626379108291,-0.25325740072021746},
{-0.30861025761585736,0.9155972974268034,-0.2577620954271744},
{-0.2013511567600425,0.9655773405163907,-0.16467577585269538},
{-0.1566740837560617,0.9528500421208075,-0.2598654049879934},
{-0.8831020364084453,-0.17140441437141826,-0.43675086722895956},
{-0.893530539410917,-0.17417974241192657,-0.41384126482668565},
{-0.924616832206756,-0.06788590496943782,-0.3748002368014516},
{-0.9516315227570858,0.0012884269644958138,-0.3072389702674245},
{-0.9777963927913659,0.0459097240643836,-0.20446640672864919},
{-0.9849246678310574,0.06102153163724985,-0.1618634343343968},
{-0.9419395418501114,0.12921624109795687,-0.30992428516609777},
{-0.870896636911816,0.23255195530558997,-0.43296493610826664},
{-0.817981358186511,0.3731862355827279,-0.43776538377416685},
{-0.7742229131032631,0.5448595036578702,-0.3220357155652093},
{-0.6961106075175872,0.6834767179985926,-0.21974894324061708},
{-0.6322989215589466,0.7747101666327125,0.004715030361272572},
{-0.45932577737822755,0.8650227883585602,0.20187968163306713},
{-0.27563925541787765,0.8720680635346847,0.4043764254201064},
{-0.19531771351614674,0.8481886687315359,0.492368736844907},
{-0.16950013842404874,0.8313536896021967,0.5292643440276726},
{-0.15645092694660165,0.8118225981033277,0.5625541544298751},
{-0.20926226366926753,0.7878153372075263,0.5792722153397359},
{-0.26222384219448297,0.9648422008201565,-0.017837715696792295},
{-0.39177919996243626,0.914528409518312,0.10073155742218927},
{-0.15714180232907554,0.9840345363912566,0.08356126584736812},
{-0.20333143583828495,0.9790862839652459,0.006809974380825855},
{-0.23294149669435102,0.9675904551581586,-0.09750369328709059},
{-0.27249487456200566,-0.7817905476239159,0.5608476468554848},
{-0.28122925565697643,-0.862243792529452,0.4212430984681529},
{-0.08327660469799461,-0.9903224775943348,0.11102431031711987},
{0.09501587905940423,-0.9837486537214014,-0.15235015270060906},
{0.2542234991942828,-0.9670833342948822,-0.010965262719492289},
{0.04181900847834635,-0.9988740269784394,0.022401981112479676},
{-0.09708845315555785,-0.994442330489043,-0.040722028380004736},
{-0.426441700331201,-0.8758419846553441,-0.2259386955207589},
{-0.483463207290245,-0.8218528453530941,-0.30136560484178104},
{-0.6421950381020777,-0.6394846526638803,-0.4226640652390825},
{-0.6887801566261551,-0.5325137058063164,-0.49194618503091686},
{-0.7233288489757181,-0.5233471646509412,-0.45044769007209207},
{-0.5729752881911852,-0.7822539883838308,0.24449543304490978},
{-0.4051466453777524,-0.4316474673245754,0.8059383721423328},
{-0.4024897985204285,-0.2823757814232312,0.8707846347706214},
{-0.7994266265565719,-0.33794461590629277,0.49669961277650254},
{-0.40593152962468265,-0.34805089390292876,0.8450326434581907},
{-0.7728701545712582,-0.21298848327148776,0.5977521477725618},
{-0.9554787494586942,-0.005473259030087896,-0.2950091570925206},
{0.6978597937191436,0.5462087826691947,0.46330084615216355},
{-0.7752133997691207,-0.6126899034875528,0.1538026884772005},
{-0.6380993140337002,-0.44309518714047363,0.6296792203675374},
{-0.7334368454013915,-0.3285349928290242,0.5950925577542441},
{-0.7968085806830949,-0.2632945052529851,0.5438493258737916},
{-0.6646649616688701,0.7380526773308602,0.1161840531848861},
{-0.7379364096735204,0.6061939565872552,0.29661210743198463},
{-0.6351424309191555,0.6841300610722562,0.35855285800475367},
{-0.6302094269835725,0.7061677395564013,0.32274324431479534},
{-0.7448194223219018,0.5910473633883477,0.30968862162461014},
{0.05155509777129715,-0.9958481971954444,0.07502293007058286},
{0.24979090635323511,-0.9636558333349642,-0.0947203145197745},
{-0.12933172565223497,-0.99137308151504,-0.021277170563519396},
{-0.16601329493023834,-0.9699479728809564,-0.17787781146205156},
{-0.11080222339680611,-0.9641331892717578,-0.24118470232374445},
{-0.16477172714640964,-0.9570614428421834,-0.23850298228329816},
{-0.1840240415763201,-0.9507987940699365,-0.24923243231383727},
{-0.18227520130986086,-0.9459046033863044,-0.2684031152577176},
{-0.21769358619405987,-0.9033382233933956,-0.3695802439071021},
{-0.18381289828240147,-0.9157492710766597,-0.3572339442824409},
{-0.2640807504149655,-0.9039714751771515,-0.3362988690529796},
{-0.2870886796335074,-0.9493565493440712,-0.1276801951901998},
{-0.3500060097264048,-0.9105980598908198,-0.21978845847422174},
{-0.38836519878846937,-0.642927821141518,-0.660163835098692},
{0.13425976632833833,-0.4019749022695149,0.905754101890173},
{0.2548462068930303,-0.4095304614549398,0.8759784312257574},
{0.17616837622499212,-0.5706000654646116,0.8021098855581014},
{0.03758125444122799,-0.69397951787315,0.7190132669757728},
{0.23097818266678757,-0.8070704057629046,0.5434026493067997},
{0.6231861142494656,-0.6541184710936709,0.4286818083155972},
{0.6781553253032425,-0.7009338171797574,0.22090074399301587},
{0.5900575713775243,-0.8072321115641108,0.014435391224512721},
{0.3767668677111266,-0.9228553702170501,-0.0799042743330926},
{0.46614560042814057,-0.8337665379948827,-0.29587436408299445},
{0.46530315509916353,-0.7477752340859914,-0.4736297848978721},
{0.45287832635946385,-0.651135775612185,-0.6090348292435902},
{0.2611689930642448,-0.7787483595793311,-0.5703873679477038},
{0.15315895323379844,-0.788225321192385,-0.596022799962794},
{-0.28284116419385524,-0.9589717307501716,-0.01934154749457868},
{-0.7424554635719781,-0.4936708022316872,-0.45282339122006654},
{-0.7162506651037417,-0.04123703231226797,-0.6966236371991152},
{-0.6123253008344015,0.04092436072045042,-0.7895460231409455},
{-0.736110716165302,0.22165342925465498,-0.6395394990508857},
{-0.7530588906007137,0.3832837520872834,-0.5347858194390686},
{-0.5973925927798404,0.7077363996819954,-0.37713562369119513},
{-0.666047212744436,0.7433936110493602,0.06121314765930946},
{-0.6320805469081854,0.7656924780625214,0.11911847572364491},
{-0.14248624077194813,0.9691960192963065,0.20088988867255658},
{0.0012426755040438092,0.9815333921137149,0.19128684200262192},
{-0.09528988294697557,0.9853130251017146,0.1416971445473044},
{0.024771862625018376,0.9961307287542852,0.08432037745138356},
{-0.38424381782373634,0.9231051608199855,-0.015282360149793279},
{-0.42830515740122016,0.895036462117559,-0.12435603573449626},
{-0.4563827961074051,0.8870196203350422,-0.07007807473000409},
{-0.3416468612195334,0.9356108858024804,-0.08893645251941934},
{-0.22895328908815007,0.9323066773617513,-0.27997258930546975},
{-0.5433935082298631,0.327262370450328,-0.7730606936721554},
{-0.33025412103185103,0.31163712182170666,-0.8909626927341919},
{-0.5211353352473473,0.21268876736510933,-0.826547911855898},
{-0.6012924577012827,0.23786065262632877,-0.7628038347070156},
{-0.6877153614867507,0.37070667456679063,-0.6241988008693861},
{-0.605805322323947,0.3410499311782246,-0.7188079408905461},
{-0.7421104200660283,0.4102793713696814,-0.5300405285050588},
{-0.7937013254738743,0.5772083323926955,0.19201236147044945},
{-0.5085832523923821,0.40994273898324374,0.7571591815073647},
{-0.11450514315670142,0.2522502689943468,0.9608633482358161},
{0.4860385560904067,0.05113008912620341,0.8724403910752293},
{-0.23125356222189805,0.3277087864627164,0.916039705053671},
{-0.029248963651807684,0.14905005535163923,0.9883969744616625},
{0.15121947879875577,-0.13063153627341195,0.9798306338151919},
{0.2667789499694178,-0.21063911236541052,0.9404574185975285},
{0.40635727374813896,-0.2513464861509525,0.878463835323657},
{-0.7104841580445095,-0.30811175487201986,0.6326763846370976},
{0.1742128086588422,-0.9473781325453776,-0.26856018184762764},
{0.3048669429545346,-0.9042383216473644,-0.2990137200161794},
{0.5847532298528281,-0.7874100775885031,-0.19506160536802966},
{0.7405608448559662,-0.6719679421120965,0.005359089461061758},
{0.5446393434684591,-0.8298584084788398,0.12125595829984126},
{0.34242399912846155,-0.930100702805609,0.1328852416989322},
{0.02451221046421146,-0.9989950175057607,0.03752474565967437},
{0.1250877836778428,-0.9800558284200784,-0.1544137932776697},
{0.45363624738706826,-0.8619704011780216,-0.2263209724033081},
{0.7117016126787149,-0.6839366874603005,0.16034781587644925},
{0.38042024728872653,-0.8701171426261642,0.3133314436197931},
{-0.20826842144835947,-0.9506661348089385,0.22990903582687255},
{-0.588606430752243,0.7889367436784143,-0.17641225623863271},
{-0.4993921884022849,0.83218403706339,-0.24099205509654284},
{-0.6210236570473904,0.7746679859639011,-0.11924398898946045},
{-0.6495364868972427,0.7241523761770183,0.2317448775407265},
{-0.3146444036277365,0.9084387007125738,0.2752054256612627},
{-0.6216347467195334,0.7234019239542624,0.300432851216729},
{-0.649190078925177,0.6365437798149435,0.41637033732487133},
{-0.6201231491733101,0.6692482699055404,0.40933364519401233},
{-0.5832749733298184,0.7397249556909263,0.33555520472070904},
{-0.7528546760455211,0.5316947401169245,0.38795687916106},
{-0.32344526995657924,0.7815250789966576,0.5334807477706986},
{-0.17008990563430684,0.9853563315244175,0.011929959180773907},
{-0.48343740413528674,0.8752565019636034,-0.014640083789791014},
{-0.8347358268318625,0.5186940199571864,0.18485835946470155},
{-0.8312051737382312,0.495513078579723,0.252120503147289},
{-0.7873518063868066,0.5820177165940719,0.2033039855734642},
{-0.9125646743073685,0.3246873047053124,0.24860384021467996},
{-0.9010648917059246,-0.3333150668184891,0.2774583341094234},
{-0.7109473678830838,-0.6137948374114728,0.34323423149088556},
{-0.34215983333675487,-0.9269598111155913,0.1538575868376708},
{0.23546965470709955,-0.9718310564537836,-0.009921664378632676},
{0.006457162152735859,-0.9981733329486421,0.06006914721495953},
{-0.20204839272223468,-0.9772460755536085,0.06454885601954781},
{-0.1991598969217192,-0.9799124322150525,-0.01034217813181606},
{-0.2131642721984466,-0.9721645692997373,-0.09724733033026067},
{-0.19821900236336507,-0.9592957050520725,-0.20114914210783771},
{-0.20721369751705201,-0.9360232118098674,-0.28446973567402917},
{-0.11910921117123638,-0.09986763124020798,-0.9878458645176563},
{-0.3592034157704673,0.08389233761895325,-0.9294810282021126},
{-0.4029495950746601,0.19259159016804478,-0.8947290669390994},
{-0.48407506991785887,0.22268688732371203,-0.8462162116729367},
{-0.5456415935401947,0.25941728628481014,-0.7968550200479018},
{-0.6318677183464723,0.26611087150252166,-0.7279616683451072},
{-0.7145532317133929,0.2843227148820317,-0.6391981483468621},
{-0.817906790659636,0.47552463366940345,-0.32389011186887784},
{-0.5904244568261613,0.7326933468325065,0.3384662764425919},
{-0.40250372808523505,0.5730192022360406,0.7138905677666982},
{-0.05358797368414251,0.347393899845946,0.9361868442924481},
{0.4739166453478526,-0.023989549793371295,0.8802428725999144},
{0.6566758964859047,-0.07452015874089188,0.7504821869409463},
{0.6451448145591894,-0.01467373658542482,0.7639194000036985},
{0.7156988638714822,-0.05327473082744561,0.6963741374493547},
{0.8099024764532399,-0.2553612045512672,0.5280612027455105},
{0.9133362698363848,-0.3851722527828004,0.13213324293144793},
{0.85066059732871,-0.40456997423563984,0.3357077361326901},
{0.7279368279565874,-0.627708964620603,0.27584312614134865},
{0.9387829816685167,-0.32177896999653094,0.12306424256274011},
{-0.07994011229229431,-0.3998801673136781,0.9130747122967978},
{0.8218072693131364,-0.33792613205892813,0.45873602580980943},
{0.8272564224557839,-0.4387471021443582,0.35092419675135805},
{0.8698598792932104,-0.3173994561799029,0.37762597317015084},
{0.7940755545579468,0.022645110393351948,0.6073970798651918},
{0.6902286459416982,0.003446941778515388,0.7235831223251863},
{0.7255480322315554,0.011484814900553026,0.6880756876620608},
{0.9409710485604499,0.27997050418244007,0.19023670139822565},
{0.059816186922865805,0.677642730120219,-0.7329545375377826},
{0.41398988199704306,0.010788904310976457,0.9102175438585235},
{-0.11497471649617375,-0.34396520772606176,0.9319167078878839},
{-0.033245741239109824,0.3701585248552909,-0.9283735170535711},
{0.18504588406204434,0.7714389154807028,-0.6088021193077876},
{0.04986649747235303,0.8583746280626141,-0.5105940954693939},
{-0.1012388865218383,0.12161222716149153,-0.9874012123046235},
{0.16440298200225098,0.7864766228491559,0.5953370316220502},
{0.18558611262935276,-0.05996265022881808,0.9807967553864877},
{0.25457251638527717,0.9656033779667955,-0.05294289716649027},
{-0.9110610811425245,-0.36022447665080537,0.20051442055141003},
{0.5601966650461725,0.7907923691202133,0.2466315580220564},
{0.5068193789875982,0.8597409960707378,-0.06308356963521361},
{-0.11058263277703156,0.2821120852341524,0.9529870160148766},
{0.9029820701590433,0.415043473556017,-0.11118586254485996},
{-0.19042573250076703,0.9758114883880982,-0.10737774225299472},
{-0.9575113557519626,0.21419192207294976,0.1931160897614022},
{-0.9414474618639129,-0.23776387672639768,-0.2390502362977928},
{-0.9866682386487646,0.06371078450516522,0.1497555434015075},
{-0.6419170212638332,0.6070402179508375,0.4684492625695628},
{-0.7630849658913406,0.6202844992579118,0.18151714742958397},
{-0.9903679890716424,0.13116217677322164,0.044359098348607316},
{-0.9752232563809458,-0.21173477189094006,0.064093576792342},
{-0.945746795482448,-0.31844542684846516,0.06446323722851346},
{-0.9053373358000505,-0.40601611055846026,-0.1245601315567982},
{-0.7123528876173184,-0.5647183732136067,-0.4167091581166003},
{-0.45728886799571267,-0.648538121802264,-0.6085106373568102},
{-0.8633472177739787,-0.1605624408709237,-0.4783840341644997},
{-0.9249447675720393,0.36994636398588754,0.08727465104328583},
{-0.44667461779746814,0.6937208568446261,0.5650072199487751},
{-0.20118531644149198,0.7248565099410083,0.658868354411166},
{-0.27256771703808264,0.829912038934395,0.4867780266819806},
{-0.44280074851279916,0.8965676678387335,-0.009690928888360878},
{-0.5665156239647171,0.8179636160381549,0.0999778507553214},
{-0.8868330854348436,0.4618107699730606,0.016058994831691854},
{-0.9111267879939354,0.3636783972834007,0.19387109002951147},
{-0.9782464813230765,-0.20742977190250184,-0.002590657734212757},
{-0.8934168444993307,-0.44697349457901764,0.0449559463105798},
{-0.7366284754705729,-0.664615631475475,-0.12515810610725606},
{-0.6262695350288315,-0.737975882466556,-0.25135247441089376},
{-0.49468503625814625,-0.7536426305263143,-0.4327926759496445},
{-0.3199234094141356,-0.7441477701627015,-0.5864240004218062},
{-0.4710970404193328,-0.6608619796951162,-0.5842337052084527},
{-0.31555759099494496,-0.6226983169801157,-0.7160099250678013},
{-0.40760426144470063,-0.5710680628398245,-0.7125587931227083},
{-0.37594128334349536,-0.4242779963278232,-0.8238060046577065},
{-0.8215559314066553,0.1450958370020666,-0.5513556471599914},
{-0.7063314577058796,0.7049363337505781,-0.06450300158427538},
{-0.5834470959416141,0.7273317966112011,0.3613557027025024},
{-0.30672754241084565,0.7516330628528197,0.5839229003499451},
{-0.13717314112855017,0.6569483567254046,0.7413517289038432},
{-0.18343233423331423,0.6943671193312818,0.695849755586143},
{-0.23663054824148042,0.8560984280643883,0.4594577946935057},
{-0.2807503633248331,0.9582590323648482,0.05402647854671942},
{-0.19072285343275486,0.9815961023163317,-0.009689432173965916},
{-0.4486976718910999,0.8931656115741546,-0.030423503099956225},
{-0.16760535120157943,0.9156093538176033,0.3654695027636453},
{-0.10306288002629888,0.8689123212937986,0.4841171559287147},
{-0.508686515112797,0.7824648793294132,0.3591472427269976},
{-0.2694976484235836,0.8411636199690878,0.46884409128692084},
{-0.654209132661018,0.6349599389912872,0.4108969294349857},
{-0.9697972383772324,0.0637314336761278,0.2354392082841741},
{-0.936892094828357,-0.34390505072656197,0.06294854035554408},
{-0.8392525040195212,-0.5343367356671013,0.10069502179149542},
{-0.8526194981902624,-0.502487617911676,0.143339405437704},
{-0.8091074893242545,-0.5873744657992719,0.018338692603928973},
{-0.6250927725362944,-0.7751375075205056,-0.09176529931181304},
{-0.6197026192097834,-0.7316886915917379,-0.2839019590304104},
{-0.5674619013872709,-0.6929204787449492,-0.444801304640413},
{-0.8319687899094477,-0.43355675954765405,-0.346202930182786},
{-0.6635715210338997,-0.4122314258227439,-0.6242900672258883},
{-0.44014298195265716,-0.4226277380324908,-0.7922499293047386},
{-0.25209951685950366,-0.38894282826228344,-0.8860977993102911},
{-0.1595569188080049,-0.4785446771635025,-0.8634446025188731},
{0.359676467136776,-0.17503380356730172,0.91651296040851},
{-0.8458910536203013,-0.009315053308812467,0.533274371395242},
{0.32601060106178836,0.5487714756274765,-0.7697837069807164},
{-0.5077677289103061,0.19695202925651403,0.8386786223870327},
{-0.3806035936879076,0.12052697513101723,0.9168501255590344},
{-0.1992804245639116,-0.06084471373494687,0.9780517538433942},
{-0.024570661417951556,-0.18920851732986368,0.9816294716273137},
{-0.009493476735553707,-0.2874346198471346,0.9577532110167027},
{0.06585374953284844,-0.34711284607775095,0.9355083942756839},
{-0.0018042252038455863,-0.4373042321656397,0.8993118220625336},
{0.04322158075788219,-0.4932046732449232,0.8688389063837775},
{-0.02045785705042153,-0.5384837834180038,0.8423874946132195},
{-0.027937591811525532,-0.5699228176017843,0.821223156602769},
{-0.04595792490557454,-0.6402400127817576,0.7667989274715951},
{-0.03164153138567744,-0.7003831147585357,0.7130654290124442},
{-0.16454572352160926,-0.7459673851280618,0.6453350797810018},
{-0.08444237434870396,-0.763980123191504,0.6396904382454437},
{-0.14174505329931972,-0.8956247333200108,0.421621485375962},
{-0.014303561340618373,-0.9452834687828982,0.32593645358987794},
{-0.012142442091882245,-0.9970935274358625,-0.07521342064787426},
{0.2395636136472436,-0.9448086362000786,-0.22348582947923473},
{0.33185710813319774,-0.9428756025840249,0.0292653008404668},
{0.34163443347403444,-0.9350923297980889,0.09427750854608956},
{0.25864552974428057,-0.9553201138273822,0.14305932356941234},
{0.24968714219351684,-0.9458727521539153,0.2073187588136016},
{-0.015824290623483346,-0.9998438377804888,0.007867139165356583},
{-0.28646508623349654,-0.9311647259814598,-0.2255438038543916},
{-0.6124973333026261,0.7810143940026195,-0.12191609023378562},
{-0.7873374678385411,0.5079542450415467,0.3494026283270729},
{-0.46795320878766106,0.4053063260948346,0.7853321440084057},
{-0.3584952055144904,0.45593883792882883,0.8146170656764026},
{-0.2125661005254321,0.3746989599376067,0.9024501882813742},
{-0.04442107024795674,0.3035465872073397,0.9517805618485824},
{0.20764611873526614,0.039054653952767186,0.977424075506026},
{0.28683349131462144,-0.19115299816036851,0.9387156542609519},
{0.4755705178521787,-0.19730200855200744,0.8572657697418894},
{0.664377048105912,-0.21665031787106326,0.7153081697537376},
{0.5889259215331755,-0.28261620585229613,0.7571620296448789},
{0.4854203679776895,-0.41850748130016113,0.7676057285144502},
{0.33581943710068046,-0.5778754234589528,0.7438315001581463},
{-0.20665961352252446,-0.46646907525647036,0.8600572108691922},
{-0.6347693205149462,-0.38764680572894233,0.6684294007156936},
{-0.18773632838718063,-0.4064825496388971,0.8941627412517044},
{0.2720088447632096,-0.2847557891971684,0.9191981989153819},
{0.2956675455114733,0.1821491803995434,0.9377645645955041},
{0.3780135494848232,0.9252774565186002,-0.031102811196984007},
{-0.43166223683248833,0.8964286539389141,-0.10041604299134348},
{-0.45869782501247736,0.8792017829881024,-0.12884304451294426},
{-0.44826081513473626,0.891153404066004,-0.07005606352283353},
{-0.3061600788144458,0.9511508703332672,-0.03972440061978101},
{-0.1803995818305114,0.9737522077399833,-0.13878987281817456},
{-0.2125309361181403,0.9685704017301764,-0.12923613304719203},
{-0.12133691819469423,0.911360153799478,-0.39331923719747786},
{-0.03225033358784014,0.8414283301037968,-0.5394054887394168},
{-0.02610494946977655,0.7544666658639416,-0.6558190159741693},
{-0.5647407608529804,-0.2654307939800335,0.7814181765471839},
{-0.25154328160831946,-0.37363168982124345,0.8928187597934084},
{-0.3862394500184379,-0.6811465666698064,0.6219794546151745},
{-0.5415690687313498,-0.6925502242327499,0.4765261070588119},
{-0.43054023525612667,-0.7226609094109117,0.5407368267789735},
{-0.7686919098273394,-0.5442579261322305,0.3360000857265386},
{-0.8041788614702106,-0.576032905555809,0.14656892740757912},
{-0.6787544598970676,-0.7342544982565457,0.012755977417206212},
{-0.6149329286737206,-0.7845727572210566,-0.07939195084710986},
{-0.516402164840393,-0.8560322684339522,-0.023185330447882693},
{-0.601268886071873,-0.7971483541939823,-0.05504750718892098},
{-0.5510580644131783,-0.832794532536127,-0.052804130739320394},
{-0.5996208204687754,-0.7843858265505455,-0.1587253816091502},
{-0.5347245121829606,-0.8302677385619656,-0.15724241913012674},
{-0.6001197807043898,-0.7172850213249233,-0.35405994830002896},
{-0.7334743847074706,-0.56360441179398,-0.3799544630404531},
{-0.772586148099613,-0.445767354031691,-0.4521085155625671},
{-0.5344578707590291,-0.6999075746827744,0.4737976058248941},
{-0.5624301913667088,0.8268292873883832,0.005060568745295841},
{-0.8459505244325481,0.5325038595645701,-0.028413900843308967},
{-0.6557527635236978,0.7263274055795208,0.20600197337684809},
{0.575291709370201,0.7309489451653108,0.3670873039096171},
{0.9705177395692823,-0.0027199864212777525,0.24101435404390048},
{0.9967287419605463,0.005732927737257205,-0.08061605602673795},
{-0.9966622595652965,-0.0028161999337749624,0.08158682109342402},
{0.540659319509895,0.20768620659788065,0.8152017785898653},
{0.2813983991015731,0.9546873414503245,0.09688664024303527},
{-0.012020058437486103,-0.5512577300525212,0.8342484241834089},
{-0.056287598308381655,-0.5446205457788859,0.8367915913727759},
{0.0513437962294437,-0.5586464771741501,0.8278151533583213},
{0.033250151334736355,0.5486569262990723,-0.835386141051114},
{0.008410971292773925,0.5517215706255044,-0.833985949562964},
{-0.19741747290984674,0.5633050502613136,-0.8023177436277905},
{0.13750063225816492,-0.5640966714968809,0.8141796615825925},
{-0.2490566049457457,-0.502458428637354,0.8279530995317185},
{-0.030239358810359097,0.5556023725331842,-0.8308980592192011},
{-0.04277410768680994,0.5572252528999433,-0.8292589422141865},
{-0.0080440860208836,0.5406166875036471,-0.8412305806808693},
{0.051881794916168206,-0.5574354664232365,0.8285975984335132},
{0.07596227698686736,-0.5562238939015166,0.8275534498314927},
{-0.04092926668330471,0.5559787967849776,-0.8301881549710858},
{-0.011207685491295773,-0.5546662207170668,0.8319974587589642},
{0.03614248290892425,-0.5554958426872357,0.8307334648889354},
{-0.16827701942136977,-0.5445594032511027,0.8216677558876597},
{-0.00617582853805072,0.5548622808323987,-0.8319192920297839},
{0.34923140915642403,-0.5252662041808078,0.7759721886795328},
{0.37318232704418897,0.512748707772562,-0.7731906061634815},
{-0.9978047834748808,-0.03229577182481115,0.057815198666837986},
{0.9356392165661761,-0.19966216181976337,0.2910571723233956},
{-0.604059725809858,0.44124232183836776,-0.6636392552232016},
{-0.9567642858617321,0.16571305788754395,-0.23904243084659504},
{-0.928927325235457,-0.1997386611612463,0.31176672636510205},
{0.7143893532152705,-0.3885684597164689,0.5819470801767443},
{-0.7359401511436147,0.37927732111761703,-0.560839377737118},
{-0.6359707285970894,0.42526982619137677,-0.6439618057764324},
{0.6912446949830285,-0.4005012978899553,0.6014810737224249},
{-0.8056327119151219,0.33092343299056765,-0.49137115807709264},
{-0.7651481670163589,0.3623490827441485,-0.5322137021403905},
{-0.7029214652729768,0.39440208226061657,-0.5919023662454653},
{0.8142418770084051,-0.3352656912691004,0.47392729609475087},
{-0.7166278945590446,0.3880718710780968,-0.5795210812540091},
{0.7007215431023991,-0.3954857787030659,0.5937847403527833},
{0.7836769891761517,-0.353184073738166,0.5109905935470002},
{0.6584333796170809,-0.4102630880223173,0.6309910325927154},
{-0.7640058777843386,-0.14790465024781024,0.6280280512413878},
{0.9547188550852005,-0.16275076747407657,-0.249046372050273},
{-0.14914147322162497,-0.400991473165335,0.9038598671331624},
{-0.8073657133682425,0.5601397159613346,0.1854834318211314},
{-0.7972691076019864,0.6011909581967081,-0.054142421870990894},
{-0.7891382799761965,0.6097376825680324,0.07403197642083578},
{-0.7599292765377393,0.5724426164097733,0.30792360347781267},
{-0.7590298850607438,0.5123487366970403,0.4017118439747836},
{-0.6701898545174529,0.4867765412387485,0.5602625793335803},
{-0.610790764961629,0.33950052898784727,0.7153139396478724},
{-0.4956233937177949,0.24088426022864373,0.8344652328130602},
{-0.6072462978584378,0.2930916268314325,0.7384776449009989},
{0.8702046623732489,-0.34421406099892615,0.352506064904545},
{0.9805644875747535,-0.0021118731288276645,0.19618569188182206},
{0.812999222441635,-0.37607379593192464,0.44452307512957073},
{0.8344880381550159,-0.3283697287138559,0.4424963677145625},
{0.8623155817280044,0.11102064623230323,0.4940508613688021},
{0.5857797563626483,0.5478474480768621,0.597264807829313},
{0.7067461949675445,0.06867852151571859,0.7041257533859364},
{0.7112286173305664,0.10776049878895953,0.6946520919070246},
{0.7581140953423973,0.0838323637651354,0.6467110276071754},
{-0.8895217242294897,0.33269243466645476,-0.3131562645701063},
{-0.953300955538407,0.2604057116720363,-0.1529906974235381},
{-0.9205661602896182,0.3660341538794492,-0.13629725867890555},
{0.9979675821552094,-0.003740753650510237,-0.06361376996697685},
{-0.6112205313323179,0.395634102005413,-0.6854802108071462},
{0.37913787309558217,-0.46178859691802177,0.8018764025341081},
{0.5004258316677065,0.4228851467358268,-0.755474777653035},
{-0.8812110371585564,0.25167970553825375,-0.40015551203265876},
{-0.9735893009041006,0.1272827991632914,-0.1895335384627796},
{-0.9687222484517191,0.13903970347706096,-0.20553628928161807},
{0.9733925245548849,-0.12717642644844912,0.1906125643720002},
{0.9736183543600584,-0.12691532064048588,0.18963069751475994},
{0.7570797645825806,-0.3560181205536694,0.5477967943471531},
{-0.729767964936218,-0.36845084698498154,0.5759189966556937},
{0.8595257268471154,0.2734319919411363,-0.4317991091596186},
{-0.773496186160652,-0.3397393298891215,0.5350521822415236},
{0.7562812806924196,0.35125765057813363,-0.5519571427063551},
{-0.16666623287222387,-0.5426345923755757,0.823267918710291},
{-0.018321776981993214,0.553257235057826,-0.8328089482854946},
{0.46357712106975507,0.4810396750761782,-0.7441082473829211},
{0.21444127467123703,-0.5489066513473759,0.8079086754231478},
{-0.8212290738412352,-0.29106954167079885,0.49077625267469716},
{-0.08506667281645917,0.5552597580612043,-0.827315092485173},
{0.030422423695069745,0.553900741125188,-0.8320267093774605},
{-0.015086203653022674,-0.5542315230067348,0.8322258259420784},
{-0.010789986296591988,0.5561255734316428,-0.8310282322346491},
{0.07333814929927586,-0.5604486362044312,0.8249356593298353},
{0.1561201636811231,0.5357180156942851,-0.829838961577942},
{-0.15384163350036806,0.5631979991399159,-0.8118748459995134},
{0.12133473023090666,0.538316056665881,-0.8339626528661155},
{-0.05424980864808137,0.5586184502302898,-0.8276487088879895},
{0.38904960046934944,-0.49404281381455106,0.7775359197444454},
{0.8322489850553103,0.3146471055438074,0.4564633893833216},
{0.7501210151305997,-0.41798540186965516,0.5124516235541666},
{0.767930505722352,0.19470703879334703,-0.6102228342379026},
{0.6331386940806565,0.6412601622348774,-0.433498325704194},
{0.36728805618988697,0.15420424573136285,-0.9172352666457367},
{0.3638290737037176,-0.4437289596729455,-0.8189829152524858},
{0.5747295246325296,-0.8146875041055985,-0.07726735513693213},
{0.2344581859019614,-0.502282443788296,0.8323110630801555},
{0.3546095533652635,-0.09531193126512708,0.9301439138222644},
{0.5622153466066263,0.5862194103264589,0.583318701051569},
{0.5966687274262389,0.7608298848856665,0.25519466290738907},
{0.6364305542239846,0.5752789519111221,-0.5138193039758164},
{0.46700308055789835,0.26253155287190455,-0.8443845726303267},
{0.03444868828328747,-0.2519243709717357,-0.9671335994504876},
{-0.12450115900209048,-0.4934258838360445,-0.8608312021341666},
{-0.3235040162198945,-0.9009691283429078,-0.28913626763624634},
{-0.6118782088711925,-0.6965963684256097,0.3746445742364802},
{-0.2503892449093257,-0.1783998855636189,0.9515664490011329},
{-0.06216620216376134,0.2270260124809435,0.9719025429360378},
{0.03617025357101468,0.3263995646753147,0.9445395899253634},
{0.6811721198082374,0.7259858977600474,-0.09459925712969437},
{0.6820133012269693,0.6261169920357745,-0.3779356681150441},
{0.5921900184903538,0.36794407403088003,-0.7168878157605643},
{0.13458053726889443,-0.14029679989979982,-0.980920428437644},
{-0.23655959891210138,-0.5009897365088968,-0.8324955495828742},
{-0.35463564881084464,-0.6095505374693372,-0.7090004928512769},
{-0.6441898294071549,-0.7409064138751618,-0.1899398577629992},
{-0.6816688310575059,-0.37378663524233124,0.6289762762449074},
{-0.4671866683083192,-0.1396213489281768,0.873065000946922},
{-0.3449725446223426,-0.08863922635946903,0.9344180172744855},
{-0.24178389819941928,-0.02480603449374762,0.9700129933275058},
{0.41640027351769615,0.6254549343499161,0.6598613015715729},
{0.7824760336763167,0.6225995452324692,-0.010053009425154698},
{0.8339534019073895,0.31107048920197955,-0.4558035478084097},
{0.753647091612108,-0.07831505520182254,-0.6525969762673945},
{0.5755129094444642,0.10724228191316296,-0.8107305249173893},
{0.09430908060050344,-0.2511749987922647,-0.9633363469204272},
{-0.25899322149327314,-0.5318559328352139,-0.8062578854985051},
{-0.6454415144175197,-0.7567700794839535,-0.10346157868633801},
{-0.6001795013892427,-0.4325849631281349,0.6727962661813679},
{-0.5151671863915609,-0.3706487394160963,0.772801579989755},
{-0.41028919393471125,-0.24668894859865478,0.8779563428666001},
{-0.12576231958097,-0.10882516929094628,0.9860734868671863},
{0.8388645273856294,-0.4211947698820737,0.34482063528459456},
{0.8985912810763538,0.1479206428529895,-0.41310191598625595},
{0.7713808221020848,-0.5672981826125788,-0.2883477055528222},
{0.21946871918314864,-0.972910064153166,-0.07266008787216305},
{0.2662407692884771,-0.7319296412074816,-0.6272119682296943},
{-0.057237876943087566,-0.8894651372370649,-0.45340444978285926},
{-0.23107070946541167,-0.5716972885634826,-0.7872537948313196},
{-0.36585775715200936,-0.6017012849580833,-0.7100025811301622},
{-0.5998868140510898,-0.7402417884532159,-0.30360814375641754},
{-0.6471118004718832,-0.640522963519938,0.4134932295620735},
{-0.5274572891691839,-0.7032386371506691,0.47670140268386607},
{-0.0636957001659248,-0.7942442327797963,-0.6042507397400563},
{-0.6902704622600508,-0.6866366004477814,-0.22815974197217517},
{-0.8614184410096378,-0.5065379031168531,0.03711633325783557},
{-0.8256972370066306,-0.5275898294516618,0.19968235940809217},
{-0.8623135326086977,-0.47972929849775375,0.1620961802226123},
{-0.7677987820628356,-0.5893592602781855,0.25127811800309324},
{-0.8331377208717894,-0.4933531745520914,0.24996836443825018},
{-0.8753354888219695,-0.4744772367643487,0.09305446685287092},
{-0.8362250683910424,-0.5357109710210276,0.1172236773101081},
{-0.7776746079475698,-0.6234177075702642,0.08107136388041197},
{-0.6092653394620158,-0.792375085561177,0.030618130448350024},
{-0.5832052986163011,-0.8117475069459865,-0.030619677216563407},
{-0.5220563818751021,-0.8496153620043335,-0.07490574603942556},
{-0.46428091590882486,0.6428354034610833,-0.6092666700057446},
{-0.7249022192262369,0.619235764428466,-0.30176785881463625},
{-0.6207196689611465,0.7607639188221226,0.1895925958026095},
{-0.25948235880113196,0.9627165588521679,-0.0764573919437559},
{-0.4650655797372624,0.8830587773877063,0.0626195035286407},
{-0.3823358307731117,0.7884764768170982,0.4817926504349466},
{0.19656490552478634,0.8775968080305387,0.437248305257598},
{0.3900646455842663,0.8146910691820124,0.4291014263088512},
{0.15374553012596018,0.9474537919386449,0.28052383875059633},
{0.1471887755783809,0.81733735412407,0.5570413933427224},
{-0.33539527183855017,0.9013931036250544,0.27386216307759104},
{-0.735905001026778,0.5556917616781221,0.3868468630696685},
{-0.5010999192747488,0.7759750643936522,0.38309472763548685},
{0.0732689076311849,0.9536298490603464,0.29192769336887797},
{0.4348311729420903,0.8470020480274164,0.3057930373229055},
{0.3826009756887814,0.9161172245203831,-0.1197736379136186},
{-0.24653203284447264,0.6825651596524078,-0.6879874705328978},
{-0.9247920235785742,0.3322042561974303,0.18547249200287932},
{-0.7550517961799894,0.36860597063257405,0.5422420340580301},
{-0.4811611224170927,0.4685606551766262,0.7409014014663315},
{0.2706133128270519,0.557942677753686,0.7845179432376383},
{0.26576463886527396,0.7870568427655549,0.5566962214572031},
{0.16228992996878952,0.9704718554373747,0.17845547465590528},
{0.13250237854977734,0.976744652653149,-0.1685615709232999},
{-0.30960364942446555,0.9369603905697516,-0.16202100717632623},
{-0.8681647135147211,0.47774698246811076,0.1343422902533555},
{-0.856694221770001,0.48580015053897896,0.17341633176318078},
{-0.7939225417100505,0.5708949192704095,0.20920322396150004},
{-0.7951402828135351,0.571255399902539,0.20351707232908403},
{-0.9613814264290367,0.11034144410769026,0.2521319468641372},
{-0.9144391189804111,-0.2082103398625848,0.34705842743353243},
{-0.6115131628739554,-0.7471825151470683,0.2603266038851816},
{-0.9869463619312997,0.08245748122439399,-0.1383388682211214},
{-0.9727228496930522,0.08841348588281678,-0.21446051664368582},
{-0.9732264334610036,0.16267478252321513,-0.16237987665902232},
{-0.9576806656969536,0.235632222558545,-0.16530335218125486},
{-0.9512986807772026,0.2865897162292491,-0.11356563962393132},
{-0.9498269278840006,0.30655132429700277,-0.06208939231620329},
{-0.3326987254462735,0.7710114898824793,-0.5430035364117114},
{-0.29418839744871805,0.848218608737728,-0.4404297657942618},
{-0.7105366970031952,0.20773564298719918,-0.6722971849148891},
{-0.7867977369437212,0.3280379369143024,-0.5228196946225793},
{-0.9434123290732905,0.31269183387614674,0.11044000352988817},
{-0.7805631097635934,0.3920792196362187,0.48682144283673656},
{-0.4769502748356574,0.33377516709982824,0.8130882935829741},
{-0.1820223928685809,0.2974035679946773,0.9372400792958181},
{-0.7996458845030491,-0.26666662211152065,-0.5380105687149348},
{-0.8698891224274098,-0.2697332963248902,-0.41296109203674375},
{-0.8550759335910053,-0.24691339361676934,-0.45593741220272876},
{-0.8835237794511739,-0.1939078627121856,-0.4263630752336622},
{-0.9121698205444947,-0.07293002653251011,-0.4032709135529012},
{-0.9006065142408126,-0.029245754963953926,-0.4336503111074651},
{-0.9590824759414164,0.016351486388365682,-0.2826542644910447},
{-0.9607448016372437,0.03667584619224133,-0.2749987426027551},
{-0.9348403091439025,0.14188290045552288,-0.32548861571191884},
{-0.958214672520489,0.21411318253172712,-0.18968443908920765},
{-0.9173834174014687,0.22141301805670457,-0.33073243099494165},
{-0.9478828558102784,0.22082723458070044,-0.22968113576955207},
{-0.9406481196263892,0.29945673776397286,-0.15970841321326},
{-0.9525745384763541,0.27888721097652514,-0.12175250387690639},
{-0.9478144500623061,0.3144223771346647,-0.052785765222022475},
{-0.9293941349933833,0.36065669912328313,0.07844289143956093},
{-0.8757298227205091,0.4272241104509552,0.22489294574818416},
{-0.7998424541145345,0.4532182869875928,0.39350379024358956},
{-0.5819952791220424,0.6682023308614413,0.46345133521330245},
{-0.30235851110461553,0.7888666209775648,0.5350409190613735},
{-0.19513979609391155,0.8249339003244623,0.5304757488103454},
{-0.5339247457632578,0.7090217264809472,0.4606653419127789},
{-0.32557108795255946,0.6979389131372482,0.6378751760479343},
{-0.21697319297391401,0.6777135664332757,0.7025859060662936},
{-0.4103013568937419,0.5986399602238853,0.6879556632184223},
{-0.4250870934366944,0.582232741778271,0.6930411224414467},
{-0.6134897030814133,0.6017666044844467,0.5113778817472835},
{-0.24282218412795453,0.9043636101945535,0.35094707215077797},
{-0.457546289659598,0.8767767368516303,-0.14803359934333118},
{-0.8086328081686105,-0.40929848288101,-0.42259641913372925},
{-0.7776566579263698,-0.33834735575227926,-0.5298784664790874},
{-0.7914464012025283,-0.3288336633464577,-0.515248499147465},
{-0.8743108619985849,-0.17207808448369644,-0.45383879233899044},
{-0.8727915870507866,-0.07464811715965311,-0.4823510175980641},
{-0.8716382808382732,-0.002308180583306066,-0.49014424374840365},
{-0.9005594469215352,0.03951863043489999,-0.4329329744994351},
{-0.8529758042956753,0.1413371477455753,-0.5024500850366045},
{-0.2519845163747159,0.967452685789619,0.023218618948016884},
{0.14141707433339526,0.9896777785495052,0.02321865052709196},
{0.14037630448137364,0.969253608632071,0.20209387742794419},
{0.07806459509935348,0.9804546732074253,0.1805949965466785},
{0.13112373665373084,0.9801376651102677,0.1487841494183967},
{-0.14594998836483156,0.984034390005716,0.10185735212729474},
{-0.5046134973407959,0.8633169063495318,0.007009815444382623},
{-0.36612037234812767,0.927855718824313,0.07099040777940178},
{-0.43968636543198575,0.8606044287924028,-0.2569745458136123},
{-0.8965085662076394,0.2541763921876281,-0.36285913571357636},
{-0.6575182165550584,0.7491173898843358,-0.0805787259215177},
{-0.7357882611599403,0.6638896440966158,-0.13366441261794546},
{-0.556650596731589,0.21206094935694678,-0.8032249167675243},
{-0.4571219160505017,0.5258342401255804,-0.717312976167218},
{-0.12440445302582975,0.7017401246418797,-0.701487226922161},
{-0.1834752949834616,0.9315294972163807,-0.31398982777556456},
{-0.15980646119668923,-0.8485027519625669,-0.5044848608944987},
{-0.6621002232537743,-0.6926411046105764,-0.28613212782059755},
{-0.8469014960590587,-0.5226636134090199,-0.09788055573582845},
{-0.8542262092185067,-0.5186078174966942,0.036653991808471995},
{-0.8831804728324498,-0.4514812174552603,0.12711004166692008},
{-0.8698446764650638,-0.48066657658784206,0.11103999719341026},
{-0.8591074335703036,-0.5063554928721992,0.07442131698914252},
{-0.8512600353412725,-0.5141956104971577,0.10468632373061358},
{-0.770029191374881,-0.6327548042010436,0.08170925401107242},
{-0.6429674416405258,-0.7630306367949651,0.06615977858568628},
{-0.44133697274554634,-0.8966983331650595,0.03396727523368478},
{-0.4424620273418749,-0.8967538181950276,-0.007742345455818012},
{-0.25686392101054506,-0.9656510203884284,-0.039230509885489956},
{-0.42922460299983956,-0.8956173929432568,-0.11677210984286412},
{-0.43988809662900313,-0.8866376322689281,-0.1427311160492407},
{-0.6147394706742789,-0.7859237616219878,-0.06647724507718575},
{-0.6784051254551845,-0.6766898586165971,-0.28610718446342004},
{-0.6875260496145381,-0.6200161433193689,-0.37800517605557143},
{-0.7528767355382229,-0.5143860499508524,-0.41058934801242447},
{-0.7699675551447976,0.5927918890043901,-0.2361095939493985},
{-0.7275988196124766,0.6087185614553995,-0.31632526082847023},
{-0.7352226571070222,0.6301036034213954,-0.24983413183923245},
{-0.7548618428847939,0.654442596297293,-0.0434567176421686},
{-0.7498480051347691,0.6406155693651477,0.16534709396410632},
{-0.6867659032207754,0.5828745198493958,0.4342923995232805},
{0.6501343336934987,-0.4282596915712134,0.6276296557112638},
{-0.8902336874704869,0.2633649678901496,-0.371648860325065},
{-0.01629238939503567,-0.5553909285073583,0.8314297772990422},
{0.9414795431486279,-0.2004018781287963,0.2710264877739847},
{0.02545813537574509,0.5479441252684967,-0.8361274537574592},
{-0.00039041844900310473,0.5718189967718934,-0.8203797184866409},
{-0.3955853177700021,-0.48992602030533144,0.7768428097064338},
{-0.7648423618189475,0.36227362945646596,-0.5327044011153403},
{0.8509003850734942,-0.2945331787067629,0.43499280605852486},
{-0.3966785664384433,0.24505419020922548,-0.8846437468208556},
{0.14317168321263155,0.3600144991863921,-0.9218955632291725},
{0.36100824259398173,0.3257171115917104,-0.8738314551419845},
{0.1755303441389375,0.8606341317702715,-0.47801463316356446},
{-0.38256445022140945,-0.12861750304830794,-0.91493277312402},
{-0.5897584138096107,0.7095283717050733,-0.3856870533039958},
{-0.3862295899206547,0.9000722313707449,0.2017341869515707},
{-0.49475420654400143,0.8389999093470517,0.22648935344217497},
{-0.1669984637017757,0.8426970110750654,0.511833235191305},
{-0.09896122879526704,0.7864271670502853,0.609704015175063},
{-0.39695952241149374,0.6598229284421178,0.6380100631407836},
{-0.7579051148775132,0.5208077314277567,0.39286020888806883},
{-0.6685193694365531,0.6922455727128853,0.2718049295865749},
{-0.2997814553647162,0.8290978049510209,0.47194057766292097},
{-0.09922346722156568,0.9014664447342933,0.4213228602516655},
{-0.2516438984543923,0.8682820209667412,0.4275063513406403},
{-0.597024909625458,0.6903394956686464,0.40864732717426744},
{-0.9391397749214394,-0.25359471445954473,0.23174599016744574},
{-0.8317463683354586,-0.5130763111749118,0.21201574864127623},
{-0.840348844626739,-0.4738898789165382,0.2631391304898867},
{-0.8095791965712402,-0.5703679264523445,0.13878743802490953},
{-0.7421562285064519,-0.6680116375708778,0.054447998668027096},
{-0.4453413202436766,-0.88627483476622,-0.12723217259690392},
{-0.13095078625109247,-0.9900493211220677,0.051519251993343236},
{-0.6826964808709179,-0.6241485335099368,0.3799527906514962},
{-0.9225295785943144,-0.38539256707717773,0.02029152188131529},
{-0.8697158679642403,-0.44515178117236265,-0.21315299840790697},
{-0.8495075214871648,-0.3297031765242199,-0.41186500983522933},
{-0.3764412347684244,-0.7814903909753528,-0.4975588061518098},
{-0.6549816860619149,-0.6638937819521974,-0.36089338759348194},
{-0.6879825374147714,-0.3123577618752832,-0.6550669101768126},
{-0.3548869574266773,-0.2516347686463671,-0.9004083466165366},
{-0.14825841112770538,-0.694081904673885,-0.7044641602907563},
{-0.2651061407664871,-0.6578192152434604,-0.7049770309622699},
{-0.2631802917446563,-0.29727822867225306,-0.917802696005348},
{-0.26227371318973425,-0.31170945936889166,-0.9132632218093656},
{-0.19930282766068594,-0.4044083487190806,-0.8925986054060142},
{-0.23305181711592793,-0.3153170011426988,-0.919925018319069},
{-0.585553411096145,0.5827278441875519,-0.5635205962182723},
{-0.6336877935606346,0.5691220177632006,-0.5239655610719063},
{-0.6793917609727106,0.6039996552077322,-0.4166668352909069},
{-0.7345666204925552,0.6657593670284684,-0.13105855665312208},
{-0.7179439781128266,0.6923501780392728,0.07216422424246326},
{-0.6579118899995646,0.658092976598623,0.3661496676889998},
{-0.6290321805263516,0.6395026780139504,0.44198963865146107},
{-0.5493871693182565,0.48288196130705047,0.6819081680349118},
{-0.5115840788134535,0.38533995891268524,0.7679810195374364},
{-0.4261163742593834,0.30764050675828297,0.850753874037341},
{-0.3069278423536995,0.16659363512675207,0.9370388787683023},
{-0.20000815161529253,0.802439300464042,-0.5622169584406123},
{0.9642494880417962,-0.262522129494318,0.036125563482146884},
{-0.6731733467263612,-0.5292666528746727,0.5164440486752372},
{0.7235659265365256,-0.38593791280264345,0.5722798942972559},
{0.9082958965856766,-0.2938700955099885,0.2977229101204208},
{-0.7157106215022928,0.47128050327932935,-0.5154153601684606},
{0.7313102042800323,0.5731414844887013,-0.3697218195805941},
{0.22869002459347512,0.394477918507976,-0.8899932833797402},
{0.45891502133628637,-0.39705446756253343,0.7948237244701172},
{-0.22680097321447443,0.45542619807838647,-0.8608997018543064},
{0.018551932936211,0.5408948317357931,-0.8408856086209577},
{0.025002424339099143,-0.5380016714137046,0.8425728931868316},
{0.5516888507319115,0.435119153810744,-0.7115551517381662},
{-0.08661661022104808,-0.5108489682219647,0.8552957935710715},
{0.7149378238701917,0.2879749454983101,-0.6371297660327919},
{0.9394602486502031,-0.3116990598733091,-0.14233108332403707},
{-0.3764942339875648,0.4740326472968061,-0.7959554893779544},
{0.007279315211637379,0.6055268821194629,-0.7957915597697248},
{0.4287982352880053,-0.5283855140272329,0.7327624594505844},
{0.5905840869023823,-0.357250848735681,0.723589847479437},
{-0.30293875238036844,0.5406535462187474,-0.7848068904305814},
{0.2824178256772072,-0.5573673163010906,0.7807572263252379},
{0.34783591579348755,0.4315158893160109,-0.8323486126329028},
{0.3819543686000877,-0.4304765314763287,0.817802431003612},
{0.3624306178589204,-0.18528371316917858,0.9134079005967939},
{0.47560969959632193,-0.37766793856237757,0.7944572624326249},
{0.6718307873516495,-0.610118425240137,0.41999869088957675},
{0.6463186622167669,-0.4068323967619983,0.6455691967676407},
{0.8083052069710485,-0.544423785320063,0.22415493383208068},
{0.1510086138916335,-0.516779542444242,0.8426952610770087},
{0.9530918524309966,-0.09160996419680144,-0.28848489612025113},
{-0.8832060568352589,-0.01874955442476637,0.4686101955553104},
{-0.930166824482348,0.3493840131159244,0.11278514978239101},
{0.44194052943460416,-0.3810641891008286,0.8120829097007212},
{0.7844441997800289,0.577463382413312,0.2262373519188361},
{0.6379274860721407,0.42815847870835555,-0.6401006480420289},
{0.9705612691598633,-0.19479951809983265,0.14164734573887447},
{0.9768844684379728,-0.1618916187005943,-0.13959885070859548},
{-0.34136833769031494,-0.8966376480270466,0.28197266917748803},
{-0.276790575948278,-0.9235357628650877,0.26545935993183756},
{-0.10674094357654523,-0.9630974005520214,0.24708251256276298},
{0.9994763459592522,-0.019344578147375856,-0.025938796507188767},
{0.8840487013891037,0.44304344919960587,-0.14889726556775887},
{0.7981183528249184,-0.5735209140838858,0.18461001054228637},
{0.8775764549485281,-0.4661088810408576,0.11225897173417253},
{0.8795746412522968,-0.47359863769916344,0.045307624473039355},
{0.8356934793986488,-0.5482446304338465,-0.032314604918443485},
{0.9902498576668685,-0.07995294311909651,-0.11407342493912194},
{0.7537813108842616,0.6274247016621111,-0.19532531609040155},
{0.7600189310562977,0.607793672321716,-0.23012621824061041},
{0.7561741222573173,0.6416336211351207,-0.12847954334215286},
{0.878222417121286,0.47331446682905376,0.06854780489537708},
{0.7131844906952827,0.5996718257480792,-0.3629897844784004},
{0.9313789030785794,-0.2522508606178524,-0.26249350890582956},
{0.7993559589579996,-0.05756436362416056,-0.5980939683017061},
{0.730755154792445,0.0010940529392952417,-0.6826387820747044},
{0.6517595519921459,-0.314896885990372,-0.689963359592786},
{0.47501472393005845,-0.6170190975492822,-0.6274140939675484},
{0.4280076093103662,-0.4818220767787919,-0.7646286501962877},
{0.14834759487040824,-0.18357765589189773,-0.971747001720819},
{-0.03464539758152676,-0.00105429496526208,-0.9993991119110244},
{0.042007423623882156,0.11407361222851353,-0.9925837936182631},
{-0.3235177706272667,0.14616777813907708,-0.9348642857240022},
{-0.3525481218118296,0.2567395851739413,-0.8998858856608785},
{-0.7606172819308102,0.6043696890230497,-0.23706250108013446},
{-0.34461966367270086,0.8361337436833706,0.4267524459029452},
{0.1814687403262012,0.5178717657361593,0.8359891928354901},
{0.4531393941958813,0.16762814130773793,0.8755372611542598},
{0.686380053524291,-0.02370092739451901,0.726856717768111},
{0.7270995749112317,-0.12920428900925357,0.6742643842481371},
{0.7067840343241579,-0.045710432105398345,0.7059510501594324},
{0.7605483352539667,-0.05847176849014429,0.6466430870519337},
{0.897310593350059,-0.16424328368931257,0.40970457994110426},
{0.8452347228645328,-0.2231207837523458,0.48558766368376294},
{0.8177893534452344,-0.544545233549731,0.18625536773444806},
{0.7943796755702133,-0.5854708625709896,-0.16181718116857752},
{0.9126519984567818,-0.408220989118475,0.020541512991404755},
{0.49605943847529416,-0.40054896156736997,0.7703801418046012},
{-0.7887747284632738,0.38735482258535303,-0.477274207513415},
{0.7199928811713239,-0.4245967384461001,0.548933384632006},
{-0.4588705202986798,0.502645791825281,-0.732656163258834},
{0.32712107705910004,-0.5216001554194847,0.7879879940773615},
{0.6930070545340389,-0.4466283776167239,0.5659190000994035},
{-0.2527469806118286,0.5382889700335507,-0.8039676290323032},
{-0.4763082498275321,0.5031953331458248,-0.7210581861725832},
{0.23080394305703728,-0.5519446763235518,0.8013030725932689},
{0.19778058575945762,0.5764968620025273,-0.792801493438228},
{0.30300714344847685,-0.5488942570518817,0.779039001330907},
{-0.7186605556569007,0.3607665005891058,-0.5944531417997599},
{-0.9031233254932248,0.06592458282314018,-0.4242902406721769},
{-0.9568383583762785,0.290604775861918,-0.0030364759232854913},
{-0.8883912511328883,0.4241098106343969,0.1757607846881595},
{-0.8305539802013993,0.44423100814300626,0.33591501510927135},
{-0.7295782627595977,0.40560909450794275,0.5506331092125991},
{-0.5220114722848325,0.3023478298422797,0.7975523886195098},
{-0.34728736069918203,0.21233433554463876,0.9134033167486382},
{-0.16951959803141453,0.1436039839040841,0.975008205960413},
{-0.08791958910221492,0.15385837145367712,0.9841736368069002},
{0.1418325984278727,0.9760478948071941,-0.16496672714715066},
{0.5566130552732039,0.8304175686255524,-0.024260429045158374},
{0.6327900242564846,0.7601254540224237,0.14760108180051354},
{0.32378723189253694,0.9461241299937952,0.003310454176205729},
{0.3353308151420524,0.8205196471918841,-0.46292629325657525},
{0.3549083629638116,0.5506594850526356,-0.7555224585807581},
{0.35293064487963544,0.42899363762647363,-0.8315073173345202},
{-0.3812985312764282,0.5779372614110306,-0.7215261269830474},
{-0.8115874152635085,0.4636144209206475,-0.35551024753206495},
{-0.8340946273280604,0.5264168360473371,0.16483770014282284},
{-0.2944694774152782,0.6288482785033422,0.7196093172646919},
{0.5217689344803639,0.6290023688986748,0.5762926330702842},
{0.5957519241065512,0.6556895308399404,0.46384359871646474},
{0.4074435136799051,0.7695548920625226,0.4917062652263159},
{0.10440918590108941,0.8268334406353756,0.5526709539559127},
{-0.23628059137259572,0.9203163823874323,0.31175188604068765},
{0.03611496111293292,0.9993474538625055,-0.0006132229112118403},
{0.05107542820919542,0.9933541021907598,-0.10314518066316536},
{0.2051775396055953,0.9294502830624745,-0.30663389988140627},
{0.11120951052086676,0.9240300544318258,-0.365788057864696},
{-0.05192842590221137,0.9296966625884191,-0.36464716392051355},
{-0.46519158202774175,0.864555036255244,-0.19010886695843662},
{-0.6982426729429654,0.71376075192087,-0.054797433323263756},
{-0.9252814888386909,0.33966074468343327,0.1687742425062281},
{-0.8910752875860674,0.4179477627495983,0.17693077591536455},
{-0.8457682084566783,0.5179878638044212,0.1279246282594288},
{-0.863654913786447,0.4777025891006036,0.1609360937114621},
{-0.8489681540470989,0.4956139935263451,0.1833571455785928},
{-0.9214870783213337,0.23479733990744858,0.3094055165300041},
{-0.8062133303910575,-0.5111076647497306,0.2979748662787461},
{0.23858720748055523,-0.9698658778093588,-0.049359127704125365},
{0.13292384350159678,-0.9910767619265576,-0.009904736136436557},
{0.3355847171745249,-0.9419384734548523,-0.01161076330121455},
{0.04901394872208481,-0.986181291803401,0.15825325439827187},
{-0.1728172909958168,-0.9524537258972945,0.250930436490332},
{-0.19595271527889555,-0.9645781745802491,0.1766110939274841},
{-0.10652766347175825,-0.979988289494512,0.16815115036439165},
{-0.1495822151368262,-0.9884463024651864,0.024475866841876907},
{-0.12836295349053115,-0.9905818701752355,-0.04764987566952116},
{-0.1662831393667144,-0.9739161672010521,-0.15439305951616575},
{-0.1600650866396703,-0.959127962491248,-0.23335106514953374},
{-0.1943764632872516,-0.9413604218254811,-0.2757867776752397},
{-0.1979640634685355,-0.9413639782957867,-0.2732107061265266},
{-0.21835613244889462,-0.9401447952968537,-0.26162638112047826},
{-0.17293391809730577,-0.9451390835844865,-0.27713890497833643},
{-0.18309966839964484,-0.9441880426194813,-0.2738310639907984},
{-0.23438505832936093,-0.9231066813478173,-0.3048568504773369},
{0.8110396505470429,-0.07220269130864446,0.580518265525142},
{0.7465441984529773,0.3065555533152058,0.5905044051383611},
{0.5893501946749462,0.15351676094414973,0.7931575834257779},
{0.6081644800844325,0.012384612733577105,0.7937144237892312},
{0.6986221592938477,-0.15101607446031967,0.6993720210290063},
{0.5359245022189133,0.40450281969905477,-0.7410549215658203},
{0.43035832384669714,0.46021702951015453,-0.7765255944556566},
{0.11038236795856048,0.24388254847835447,-0.9635024833344044},
{0.6453699992367997,0.6201795341230657,-0.4459539320826648},
{0.8721206460496036,0.4653893385352059,-0.1510574139583543},
{0.3540720330714748,-0.010551609201618165,-0.935158627688313},
{0.2909794314035503,0.9163943297484053,-0.27486797358920834},
{0.9558480439535177,-0.05405550650925973,-0.28884687826989097},
{-0.2548397397691198,0.9643841256872873,0.07085171244771556},
{-0.524786870767803,0.7463666147398804,0.40931114897039905},
{-0.4296581067890834,0.8911175830186925,0.1459567213434999},
{-0.46921760110519134,0.8789766571429397,-0.08505809197785033},
{-0.39184267329695666,0.9173829159394181,0.06977037283822575},
{-0.24701369551745742,0.9672712464623181,0.05805661025277223},
{-0.44933159032947106,-0.8811114002379106,-0.14745786619498075},
{-0.670796123426594,-0.7370380517084719,-0.08250740045373725},
{-0.7858145402820128,-0.615801487332094,-0.057306513425175155},
{-0.7792788283683555,-0.6259559993455899,0.030059849302796628},
{-0.7601746006569297,-0.6431369900711005,0.09224634691066479},
{-0.8763035938902195,0.24559776578210904,0.4144559672364745},
{-0.9280598487482602,0.019259668625975033,0.37193276584051327},
{-0.9225187221974672,-0.04386799504759481,0.38345117838605824},
{-0.8050547741540768,-0.49226788293126716,0.33099719341120787},
{-0.8716340691708881,-0.3180647263087951,0.3729462150749229},
{-0.8371467908706378,-0.479603878777359,0.2629930987625056},
{-0.5582978068613437,-0.8296398777207696,0.0011100221980841548},
{-0.25504479448454365,-0.9571254871333291,-0.13734247225867302},
{0.13855840441014722,-0.9619532280869542,-0.23547304631401603},
{0.3815519565257586,-0.9235896982099888,0.03741889672006911},
{0.1976355842044366,-0.9015992734226196,0.3847842590595093},
{0.023847988442364187,-0.8781184612975308,0.4778485548536375},
{-0.40253589440655,-0.783063549522222,0.47410582270625773},
{-0.8776407884937759,-0.3701952760797108,0.3044702020564408},
{-0.972162366108108,-0.22942694955828813,0.04757739735907833},
{-0.8419715221197357,-0.31756830393845864,-0.4361586044927077},
{-0.514124210764398,-0.7757642579899662,-0.3658771814846644},
{-0.8949268771645507,-0.445712367617341,-0.021127467464166882},
{-0.5826711856135524,-0.69724889026646,-0.4175383509067009},
{-0.27216521741353805,-0.36831001997436763,-0.8889734662051071},
{-0.37043360001645864,-0.4637641722953204,-0.804799192640054},
{0.23392418100425033,-0.5586197908721592,-0.7957533580120387},
{0.5450634832477597,-0.6505023882567232,-0.5289162902597331},
{0.019584661642245208,-0.8546849776169787,-0.5187774378904921},
{0.27463980169087804,-0.4501593820448851,-0.8496643514259984},
{0.22717325420026563,-0.3740062763837093,-0.899172740802152},
{0.48235469402274633,-0.6759576732529601,-0.557149148006768},
{0.26994479280921624,-0.8253141546943406,-0.49597011492261855},
{0.11907300269511603,-0.6472379669294909,-0.7529306968069162},
{-0.14992693616681363,-0.7545851659602516,-0.6388451620888835},
{-0.16889862087811952,-0.7000014446651258,-0.6938812818719107},
{-0.1085468119599883,-0.41549109171761117,-0.9030973050101692},
{-0.3193460376510504,-0.3474984937340117,-0.8816251499867542},
{-0.26427010355659936,-0.46541151141400344,-0.8447209227961134},
{-0.43310769263184506,-0.2547639065207306,-0.8645883867583556},
{-0.33469528899353934,0.34791417326340784,-0.8757481324947091},
{-0.32375339573977385,0.06596244565800409,-0.943839337233716},
{-0.3305012782485215,0.5680986422477929,-0.7536795325284531},
{-0.3039756484787882,0.9346080173219401,-0.18467988274160277},
{-0.06433510182880785,0.9924237303476718,0.10467155351617023},
{0.0313059897413572,0.912990832615629,0.40677718048845196},
{-0.13610914248084394,0.9206040963625287,0.3660087418268328},
{-0.3625633924045014,0.928231870348252,0.0832669283564926},
{-0.5200798141003544,0.8240809507466769,0.22451631028010832},
{-0.9054576169028519,0.3213964241048891,0.2772198451864482},
{-0.8816710944441464,0.3093888707955138,0.35627883441138897},
{-0.6436495095847649,0.5190148798818545,0.5624400974970718},
{-0.4501868663166495,0.5889541609249414,0.6711667316883292},
{-0.39320813578523456,0.7261481865215306,0.5640001535139799},
{-0.27721514929269414,0.8386603227361458,0.46882899235300396},
{-0.07311659295740605,0.8408856831705193,0.5362510901370272},
{-0.018647211892751297,0.8245375736417607,0.5654998418581431},
{-0.04896258102368745,0.873033869330043,0.48519535103101724},
{-0.18351380463208844,0.8636680038515908,0.46946806348511533},
{-0.12014292064003214,0.9080634900980536,0.40123107627777943},
{-0.30161118596666503,0.9006694129064636,0.31277036489173293},
{-0.5685702815668553,0.7483947298832361,0.34151597796001437},
{-0.6617989120315764,0.6775167418539604,0.32092563708967853},
{-0.761520828093062,0.5759662182041025,0.297235502368276},
{-0.8873631999938361,-0.22422982335552777,0.40287409648008904},
{-0.7872990267957725,-0.4754174213198493,0.3926047859005471},
{-0.8807859701084193,-0.30102615648551806,0.36551241835500914},
{-0.9187695717977393,-0.07472866007577036,0.38765719560183387},
{-0.8697011760079579,-0.3109902228777843,0.38328180980161447},
{-0.8077085323616078,-0.5039342074537484,0.3060347060518138},
{-0.6615211074640394,-0.7315231419691056,0.16511728299363002},
{-0.2999358523741571,-0.9503756252777424,-0.08261147219683208},
{0.06256567170017802,-0.9637096181042866,-0.2595174535517712},
{0.15627325799721484,-0.9370154832505383,-0.3123790213565824},
{0.20342720319312763,-0.9125175758877007,-0.3548648287687249},
{0.498049653282036,-0.8314450369094425,-0.2462634635188491},
{0.7708153921221654,-0.6185005415276577,-0.15264570546709302},
{0.5674738280325544,-0.7991561866366318,0.19829988365724155},
{0.4064947657998063,-0.8770207114948301,0.2561184823210981},
{-0.29120830968265493,-0.7790902993164432,-0.5551720687163446},
{-0.8865291876879033,-0.4586147962711812,-0.0611430128352321},
{-0.40703897067475375,-0.2942182556931027,-0.8647282199448246},
{-0.1527454254037988,-0.40446871834532205,-0.9017061000671478},
{0.5111260703526384,-0.6750728637865421,-0.5320026022350892},
{-0.05143893623616927,-0.9981102562432824,-0.03361476194859047},
{-0.5755448288889264,-0.8177387245246954,-0.0071783251487220505},
{0.5227108926778581,-0.6333115165602943,-0.5706924265031181},
{0.23091623216959029,0.9184202545070076,0.32121944186472173},
{0.36105636336986247,0.7878040634653186,0.4990020641817647},
{0.36350422723936193,0.8003279799650034,0.4768016372289964},
{0.34115488469600147,0.9156802051635639,0.212469071913235},
{0.6875766049326595,-0.5587590699504268,0.4637097304321008},
{0.9101367957551508,0.1431091181865036,0.3888068843326056},
{0.9013962031021083,0.3492358174627601,0.2559672417209289},
{0.20005723156482302,0.9255380612623088,0.3214909038424349},
{0.9317193639324479,0.24297773685117996,0.2699274833506092},
{-0.9126378085575985,0.019767475777353848,-0.4082909223734663},
{0.38377127995228566,0.848167007295684,0.36514700110896087},
{0.6101669493525782,0.08096544545406179,0.7881249206567408},
{0.8840488404194773,-0.2244533792431394,0.40997357024485526},
{0.918719247744869,-0.015584016920122058,0.394603702769925},
{0.8241271296304749,0.3756201013027045,0.4239386909735659},
{0.7198657546081598,0.5095482369074186,0.47133203753507563},
{0.6551041902293404,0.5614601397303683,0.5055699866862309},
{0.6034946050751907,0.3343421771693116,0.7238850531754502},
{0.6106052284665388,0.2079345115185863,0.7641495232536973},
{0.5683733190435553,0.018574716630823974,0.822561092017789},
{0.5088034906695572,-0.18428892147241305,0.8409260379516195},
{0.5438270441756673,-0.03775498755352494,0.8383476050767903},
{0.3946979941347306,-0.2880749621680573,0.872482842007734},
{0.5991940194262534,0.04662656367521744,-0.7992449503397888},
{0.6588467032286234,0.02962242795381251,-0.7516937763523758},
{0.17712572071105628,0.8921150562839778,0.4156407167422651},
{0.4256383978768413,-0.13975666267125192,-0.8940358099605573},
{0.6532334898786736,0.5480286311182521,-0.5224467697053775},
{0.8452554959093623,0.49345213195179555,-0.20505643151885228},
{0.49840074865812445,0.31383482120897993,0.808148747900873},
{0.682040275774576,-0.08213697242938964,0.7266874018320905},
{0.5214528749727272,-0.5218424489860343,0.6751054418525566},
{-0.7383453542733955,-0.003971427894414002,-0.6744111250441925},
{-0.7832518087695487,0.13960558126355813,-0.6058274389125128},
{-0.8892398765324822,0.3904573411235465,-0.23831807893491055},
{-0.8764877085585908,0.47968547035640746,-0.040879655999809084},
{-0.8895897659920017,0.36267334174880866,0.2776654379411446},
{-0.8044915686305223,0.4002418760774791,0.4388618878831716},
{-0.6954974522345112,0.24658936608619447,0.674890345514375},
{-0.5756290009736246,0.1028549795670888,0.8112164362341043},
{-0.49586551717083927,0.12651159758619615,0.8591345671995072},
{-0.386798582140352,0.09422224545671237,0.9173380103949189},
{-0.5782545065170802,-0.07778418589688704,0.8121399793859717},
{-0.45177494040716487,-0.22118497635943504,0.864278085718352},
{0.04387133306392996,-0.2010705193856409,0.9785938648740765},
{0.3485684279284688,-0.09740672562151033,0.932208120998295},
{0.3824244990882241,0.038284395367642415,0.9231932666394697},
{0.525423808186417,-0.14340890882090368,0.8386678166364089},
{0.6324110572214248,-0.2053726311420845,0.7469125364337228},
{0.5874015295616414,-0.39663523046692667,0.705435990732747},
{0.8278876237721764,-0.2786060575852985,0.4868066834808625},
{0.7945759429687933,-0.34015170692278124,0.5029372596385865},
{0.589765973260059,-0.5463938820176358,0.5946678253263018},
{0.8419565058321181,-0.4160838786676756,0.343487187824864},
{0.856536388431123,-0.4296865630208265,0.28585813413775335},
{0.8713138418954965,-0.47524381038744584,0.12229272100060196},
{0.749342628504703,-0.659481121076459,-0.0597517869975432},
{0.6835103646358257,-0.6948799040217241,-0.22350727151965397},
{0.6099554946406016,-0.6624211870099443,-0.4349166190870099},
{0.44725307072138604,-0.7948761095996223,-0.41004470624318523},
{-0.34879609208379053,-0.9357735425976829,0.051663944112491145},
{0.46414566983034206,-0.3156439314963374,0.8276096336360993},
{-0.3060708756930109,0.3411322962433145,-0.8887909627759933},
{0.5748412246902671,0.45939160047864797,-0.6771387773612292},
{0.6339406148620577,0.011276702649809732,-0.7732995104134388},
{0.43596428004035387,-0.474917600513383,-0.7644530196496753},
{0.5075778497711098,0.05428932315708244,-0.8598938282211835},
{0.45303930229771155,0.8088936511758453,-0.37476185993376215},
{0.1471240178446418,0.9609622763843682,-0.2343203506727971},
{-0.7808082985945796,-0.04245882529723026,-0.6233262781242399},
{-0.8464915830179919,-0.21626314819139586,-0.48650000063107957},
{-0.6528711526187599,-0.42466223247557233,-0.6272330080497316},
{-0.5685537486393178,-0.01218826670954699,-0.8225558224599694},
{-0.010583795744968443,0.3170829174314549,-0.9483387615935488},
{-0.7318379692098688,-0.6814542197404719,-0.0057734929358185605},
{-0.4372700541098116,-0.8977859074246213,0.05268172556543479},
{0.17791825469766087,-0.7835142386417223,-0.5953574829386296},
{0.4527271719843364,-0.1792784176700406,-0.873439955981401},
{0.8063373700534908,0.33926953116312825,-0.48447521183190684},
{0.582766056843338,0.4534258363771511,-0.6743802591245893},
{0.7209715362538178,0.4441220602379351,-0.5319357475502298},
{0.829705859172338,0.44062264093392267,-0.34269501827646687},
{0.7941454120915868,0.0599441642503136,-0.604764219862762},
{0.5634378761639303,-0.17792811272816866,-0.8067709380021517},
{0.1881517035177067,-0.5181159426175457,-0.8343589194518849},
{0.13785050371949975,0.254615073649054,-0.9571668626185129},
{-0.04473723516576247,0.5611933871538874,-0.8264747800171947},
{-0.15856812362080153,0.8532391301890061,-0.496829082165775},
{-0.4319542503434462,0.8915793894869068,-0.13602101989172774},
{-0.3480366529847079,0.9298616287449964,-0.11928050790847913},
{-0.060377183248049526,0.9961014012442706,0.06431636014446077},
{-0.03231226661816396,0.9977650588187694,0.05848764678437923},
{0.006439648249651181,0.7325437166766555,-0.6806895284106936},
{-0.5574283414224515,0.19112647691715534,-0.8079259334866353},
{-0.7726005059381413,-0.23203257604203514,-0.5909732158731266},
{-0.9162152320000705,-0.31996595888546403,-0.24118754902681575},
{-0.5544604468694839,-0.8267516026652738,-0.09515986731649761},
{-0.13380710033177265,-0.8962045995764808,0.4229810582032756},
{0.30269644992874134,-0.9495632805827895,0.08188061656697393},
{0.9271286356787241,0.036719588054127596,-0.3729398942961759},
{0.9363108306445853,0.2744766277062463,-0.21905389578971957},
{0.9291862547978919,0.25853227621073616,-0.264147621704158},
{0.9744710566036389,0.1660190997364537,-0.15114171616229954},
{0.944905307348338,-0.04870402652576165,-0.3237002903074401},
{0.6652085168446163,-0.23931345974412535,-0.7072670620795816},
{0.25899239887503234,-0.2586686126151327,-0.9305984559264637},
{-0.30131131332128874,-0.24383608867637185,-0.9218218126751008},
{-0.2322315360720317,0.1765006710318579,-0.9565124289725296},
{-0.200969806859296,0.39967970114495616,-0.8943529913985954},
{0.3257024983018194,0.619921126648455,-0.7138737138562141},
{0.18035915673562225,0.8061363345373413,-0.5635732292438268},
{0.008705348177095229,0.9530609654172103,-0.3026532886177361},
{-0.25962086248146216,0.6628071897290677,-0.7023415387173375},
{-0.4592169697831677,-0.24322845737132545,-0.8543767858433013},
{-0.8352609883212169,0.06922370928941185,-0.5454788350255938},
{-0.9508381942091197,-0.13410562400822296,-0.27914585800707375},
{-0.863143772197362,0.425293265488194,0.27222870320246706},
{-0.6247050741862231,0.6661253372967293,0.40745626182119726},
{-0.23360037788027113,0.8350013268895685,0.4982004090191561},
{-0.4304763183242326,0.48204448116050863,-0.7631010795069746},
{-0.4831180043509659,0.5189935410164126,-0.7051543790229099},
{-0.5256027910623783,0.49922942623704036,-0.6888480863052995},
{-0.5373218190558599,0.44508241218379396,-0.7163706506628793},
{-0.6237245027949498,0.5678692360154886,-0.5371147693001728},
{-0.7274835038630444,0.6394341253511445,-0.24878052766156122},
{-0.751330688475741,0.6598364349365076,0.010866263610320679},
{-0.6554777088022905,0.6733431190650129,0.3419912532084698},
{-0.5401846669373749,0.6005286262986674,0.5895471945498452},
{-0.38906245715482735,0.46087714433133753,0.7976356701311943},
{-0.36081460816331484,0.37696758688424603,0.8530581791265013},
{-0.2579739501463414,0.24505348144617037,0.9345577736432373},
{-0.009885668777242165,0.03260182627726719,0.9994195287646793},
{-0.04468871456070692,-0.036427923717543255,0.9983365790977212},
{0.07642097995753187,-0.1586605254009358,0.9843712061523485},
{0.10255134706957784,-0.2933401334257711,0.950491866002001},
{0.19529956518838917,-0.3725646586372854,0.9072230458777539},
{0.1119175152655053,-0.41692573718902365,0.9020240570218651},
{0.14980781585898148,-0.42508926937436886,0.8926683210298924},
{0.05053612611026723,-0.5338571969957591,0.8440631452525329},
{0.007567576365320737,-0.6194960587150389,0.7849632889661071},
{-0.0034697431850477917,-0.714760508983504,0.6993606906881972},
{0.06521133104093614,-0.7089074239483566,0.702280390282097},
{0.07307013484448277,-0.7502427533973671,0.6571122935758748},
{0.822918196926776,0.08944943293707583,0.5610743623745604},
{0.032558481124191144,-0.8572351128371061,0.513894840046132},
{-0.22288773103324805,-0.8665307463675538,0.44659324329252953},
{-0.7733963075574501,-0.21558659352454418,-0.5961380478957747},
{0.9724234421008857,0.0726574049102576,0.22161577282398498},
{0.7670348638079333,0.6299210302109722,-0.12188934900594386},
{-0.11981676958673582,0.341192594618517,-0.9323258846043497},
{-0.14648139867860752,0.2856267671866951,-0.9470800123049986},
{-0.29292290617453576,0.34105283054963637,-0.8932408061728625},
{-0.09580212288979748,0.08551564792062474,0.991720236362314},
{-0.06788525267551523,0.45516097752066137,0.8878175921953887},
{-0.07979092695753251,0.7411274077773654,0.6666060106363131},
{-0.4251833196694979,0.8929385475767393,0.14791854152326178},
{-0.4697265469978612,0.8756766345529501,0.11201518978908727},
{-0.5728645248954563,0.8073973140331238,0.14119423999724853},
{-0.5342241933488852,0.8172558992376138,0.2160955955174754},
{-0.3229283358126541,0.9168553444486699,0.23472018934292901},
{-0.1435297536498045,0.9873999968020214,0.06663674761417074},
{-0.1310266799571224,0.9872268071443981,-0.09063796332051591},
{-0.07859583701376317,0.959525635729763,-0.27043159723209104},
{0.08554331694193026,0.9178770702832639,-0.38753583676194986},
{0.6046778774379898,0.7225968727040097,-0.3349901850733425},
{0.28413886015762707,0.7083523360243188,-0.6461440057736474},
{0.08570793057548971,0.7108170408508762,-0.6981355778589651},
{0.0383755577213597,0.660880160484339,-0.7495096597428007},
{-0.007552753174246516,0.6409613934876973,-0.7675359587522907},
{0.02742034655699886,0.4890374628279087,-0.8718316836095921},
{-0.07574022989679478,0.395390069640881,-0.9153852251399736},
{-0.06848425017812769,0.28290860625520176,-0.9566988178022793},
{-0.15200953309770426,0.2566592875275152,-0.9544732117630575},
{-0.1537749218010883,0.26832765669447406,-0.9509750480837662},
{-0.1631367013357437,0.21074149453300062,-0.9638332009011152},
{-0.23106168097897564,0.19637855602730742,-0.9529144569770152},
{-0.4710753134013658,0.38418678864718564,-0.7940330978824294},
{0.3810137642710491,-0.9125158466299998,0.14880638791779027},
{0.2819660336982597,-0.9550835825227193,0.09116197801737244},
{0.40095586597134697,-0.889933635446834,0.2173764431661092},
{-0.43215809396917826,0.9017273880022008,0.011273843340022632},
{-0.9783945613971119,0.20558629672796339,-0.02187137001275995},
{-0.699870154209223,0.700042013121703,0.14185537392595304},
{0.012746364332141439,0.9940873374733749,0.10783272078274168},
{-0.13414625928584867,0.9690651415502269,0.2071654714276796},
{-0.46579953671382635,0.8260826452048718,0.3172038065479456},
{-0.9434174550485039,0.2823466567155613,0.17390765064064606},
{-0.9966995457662237,-0.08067355543651854,0.009043943975616815},
{-0.6504484698982625,-0.7280658760746859,-0.21641827118478035},
{-0.8894111525026899,-0.09865911842545814,-0.44633415750460825},
{-0.5588282950316328,0.729415072075486,-0.3945435201611502},
{-0.014136366871060626,0.9866830530267484,-0.16203924216528975},
{0.38430099109602683,0.9021596639634745,-0.19601196126747547},
{0.2785320501713805,0.9574718925165171,0.07528261464751729},
{-0.002024718359990939,0.952744928473357,0.30376471451414566},
{-0.2887005850560365,0.8778785575345777,0.38207487539657914},
{-0.9359438460769719,-0.350143073497316,-0.03753591709947819},
{-0.6956134385871671,-0.6957567064074305,-0.17900991465844018},
{-0.2061608272500469,-0.9086487593296187,-0.3631186382937687},
{-0.08721245131940995,-0.9285888421795249,-0.36071699504535254},
{-0.13355012064159302,-0.440151720110196,-0.8879362750561841},
{0.41184388213451817,0.5031750782397084,-0.7597364394227991},
{0.7006459262888648,0.24521628934914932,-0.670047951577089},
{0.6060086120952554,0.7592757048741672,-0.23717918554168899},
{0.690043283446424,0.7136342181352238,-0.12069163051763727},
{0.4349701257610405,0.8921743383084098,0.12176181568692153},
{0.20032825096787452,0.9575346281369846,0.2073548354457136},
{0.08277012783067358,0.9331644926545892,0.3497901307750075},
{-0.02604583856842401,0.9108930448024546,0.41181971203887396},
{-0.18955924022938536,0.8678941526447053,0.4591590511454471},
{0.92284624458414,-0.22807302353571027,-0.3103828358531262},
{0.7021969525320017,-0.5207945329966855,-0.4854817136160063},
{0.5853830291265302,-0.6653505010422153,-0.46328762121766337},
{0.760909844193936,-0.3669775560617794,-0.5351109065938421},
{0.6436418753879707,-0.11135894204235766,-0.7571818290703118},
{0.8357741410901277,-0.03364797829103723,-0.5480414205532144},
{0.6757570685037823,-0.06773232002154345,-0.7340059381174472},
{0.20923458900126102,0.024843175282444382,-0.9775498470192501},
{0.43947900728327044,0.11398441588787996,-0.8909914450161741},
{0.051643706588277015,0.9264633909235177,-0.37282504321507337},
{-0.4966473784285965,0.747413940334195,-0.4412638477080522},
{-0.24837105035801313,0.9484747922055925,0.19674193730523118},
{0.22807136200117512,0.6841598886749339,0.6927544302010856},
{0.5515586544307981,0.3003441378126078,0.7781879269200266},
{0.6745097094483891,-0.6691846316696272,-0.31181497814735476},
{0.764911990850193,-0.48044077150006737,-0.4290528071624917},
{0.9615599339465556,-0.24158005182791795,-0.13054337205509892},
{0.9321241999596078,-0.18228770596880664,-0.3129147936775934},
{0.978346390732966,-0.11474560507899653,-0.1722550024087355},
{0.9222057378202517,-0.14413783986912357,-0.3588326354294826},
{0.782336656652411,-0.16218644571087643,-0.6013691981516848},
{0.9129544724520136,-0.14505231927038292,-0.3814104821634409},
{0.6224152629634918,0.6660473042669011,-0.4110720483186387},
{0.2750396403734422,0.8334809566439533,0.47923135449918985},
{-0.946663499069504,0.31185035081753,-0.08110227015606072},
{-0.9453410705020864,0.3163154086743197,-0.07921377820283254},
{-0.9475479267366285,0.3093545103865744,-0.08032878338802199},
{-0.9563517332091637,0.2912725180655527,0.023487924718473583},
{-0.9368818549782535,0.31312173805281623,0.15558652567394843},
{-0.9263593150146326,0.316366042852902,0.2043794177876445},
{-0.8683176359060638,0.3410576119550008,0.3601446771813469},
{-0.7393985153666024,0.36495507276985106,0.5657717122066257},
{-0.5601843589372275,0.5511581829668689,0.6183996615060094},
{-0.40714845881053097,0.735335950955851,0.5417667133739978},
{-0.4304671576185392,0.795076156623194,0.4272609640267951},
{-0.5025384753511974,0.7627692216671661,0.40698672615818765},
{-0.7616126419865392,0.6145241518357745,0.20568483263674459},
{-0.8749882707194157,0.43125827689631113,0.2200268727039293},
{-0.8505891234546183,0.3899500771023047,0.35275640380949924},
{-0.6611714034787844,0.1367532655944475,-0.737665859025039},
{-0.6189508987973174,0.3336053505898247,-0.7110606548922763},
{-0.6357322460503881,0.47209746736181535,-0.6107114643121483},
{-0.560908478446476,0.5826644411735593,-0.5881188891701772},
{-0.7215776587676963,0.588168300156262,-0.3652173778157649},
{-0.8850109498389036,0.31563837214772744,0.3422397357017072},
{-0.7162273797980576,-0.023515541658948685,-0.6974706873611931},
{-0.7073946624362699,0.28789881132638195,-0.645528516793435},
{-0.9624948931326682,-0.04781143384987332,-0.26705364159051054},
{-0.764560537350472,0.03259202836306204,-0.6437273836132335},
{-0.7118019762779777,0.27732222052764943,-0.6453141347966734},
{-0.8272636642167568,0.41031120410700705,-0.38377017295631916},
{-0.5414925473714572,0.5034003529271397,-0.6733304581065686},
{-0.48442513333551107,0.5496319840554788,-0.6806151425703885},
{-0.4972781654902878,0.6312657898151598,-0.5951621029061381},
{-0.50140980203432,0.6653114440401995,-0.5531264709386532},
{-0.842831547739519,0.5233619609323377,0.12540829312316382},
{-0.7212321637995934,0.12086641943459395,0.682067060159056},
{-0.627245917126044,0.060444626354432984,0.77647215442254},
{-0.6325705490599213,-0.01075026320956361,0.774428132432542},
{-0.8789650676850604,0.135053392804232,0.457363084301152},
{-0.8696039858223604,0.1047955136107579,0.4825005784130433},
{-0.8631110015929278,0.06031022421001805,0.5014001154616845},
{-0.811418208156362,-0.0466053900360323,0.5826048653177451},
{-0.6900131327770357,-0.23964914199388004,0.6829715699330521},
{-0.5819632334176106,-0.31805207348768183,0.7484394922104965},
{-0.158397114909269,-0.3870982403284291,0.9083310554654913},
{0.42494050125356353,-0.2531216411107273,0.8691116183757885},
{0.4865479394140405,-0.12244039558126485,0.8650314746769939},
{-0.39543520599552,-0.4668243820132005,0.7910157989681837},
{0.1379834401183272,-0.6637032739835061,0.7351588497438408},
{0.4217566512045136,-0.6341986983331983,0.6480072053590388},
{0.8586531685201456,-0.3710482832779023,0.35360699606602236},
{0.4047101086478206,-0.050549646778242675,0.9130468011930517},
{0.3514506919815442,0.263142870572318,0.8984643792453065},
{-0.1816650859982009,0.8074552276415323,0.5612609481191682},
{-0.35549969429661327,0.7767299340229649,0.5199140091858416},
{-0.7416167526312604,0.6226786942216481,0.24955126923958373},
{-0.746217748603138,0.6364542863605334,0.19515381893001257},
{-0.6038888853283295,0.7003423184202658,0.38057699773716597},
{-0.4603000190570588,0.7416895252188375,0.48787348835197697},
{-0.27102412327276393,0.9113942593730948,0.3096876306635404},
{-0.21399792867080006,0.9697856282009341,0.11713548505694885},
{0.03755771947396958,0.9986839198447569,-0.03492629312460173},
{0.40924735833603143,0.9065045219181429,0.1037600666775957},
{0.7407589612205723,0.6715220043923265,0.018285485728599695},
{0.903056888429525,0.32440299077347146,0.28151546287408685},
{0.9308881444147107,0.20640798221152915,0.3014017376650335},
{0.9913108905176851,0.09161805624085945,0.09438670516381528},
{0.9685451865498063,0.23827114598249438,-0.07174317112722152},
{0.7061421750163075,0.5003053694868947,-0.5010566494178281},
{0.31652609104525725,0.49742101556828855,-0.8077026476114968},
{-0.5089872954165704,-0.7881629057774794,-0.3460219170239435},
{-0.198892659755801,-0.8337126511529184,-0.5151358317986},
{0.07377352089459313,-0.8494654878660759,-0.5224613407126545},
{0.2699644856496953,-0.7436327004183324,-0.6116613306041457},
{0.5987825022672068,-0.45289749906987903,-0.6605629192702777},
{0.839656259562504,0.15310716385141235,-0.5210907427261412},
{0.8952579390514698,0.1684607220211344,-0.4124732811970163},
{0.8296288164904805,0.5208642902707398,-0.2010383494992016},
{0.5646679040057394,0.8186949759746863,0.10434890751499437},
{0.31909838841439975,0.9062156657709327,0.2773975227407016},
{-0.8698129190707783,-0.3847437526204158,-0.30886523054097914},
{-0.7144972138924107,-0.6387747592521303,-0.2854129259202626},
{-0.05205993241739186,-0.7466687100880196,-0.663155789247285},
{-0.0009977481314264619,-0.8319435350565093,-0.5548594046930669},
{0.31017205856394486,-0.6205013559455984,-0.7202578436614755},
{0.6525673398715511,-0.41704882268176513,-0.6326342912241804},
{-0.35379841330143597,0.3577189726955748,-0.86421283218835},
{-0.38142822289032385,0.01199800773660129,-0.9243205929725259},
{-0.11844596264543329,0.5506551938398102,-0.8262865189691997},
{-0.2083483963239519,0.6283369179796284,-0.7495222900308562},
{-0.0016446300603227997,0.7254438015372323,-0.6882794388932256},
{0.046699003027362476,0.6676748263207757,-0.7429868972019441},
{-0.05091026674555207,-0.10279402099562837,-0.9933989802629389},
{-0.9450060277009196,0.20248725992362016,0.2568316903685235},
{-0.944139878923108,-0.16448795185240728,0.2855584050986054},
{-0.9136955090171734,-0.3350781088462357,0.22996342703542752},
{-0.5469002697526492,-0.8348432281309477,0.06274455664340885},
{0.47778229536930716,-0.8627867262773508,-0.1652971360648685},
{0.5345797465569362,-0.8392197921788581,-0.09967263910620672},
{-0.8671744152483183,0.17302737948961575,-0.46697972063644655},
{-0.7910795614254393,0.13457062614230028,-0.5967276381018426},
{-0.8142760870644513,0.20477619485901305,-0.5431585073015699},
{-0.8699944652478688,0.22115263540372163,-0.44068258678107924},
{-0.8774843771829528,0.33673644960911964,-0.3415109534180278},
{-0.9097268929122866,0.28894579810099075,-0.2981732819552056},
{-0.9041380175246551,0.3249439466700683,-0.2773911981102974},
{-0.9012203462791503,0.3818205628733302,-0.20497547467826932},
{-0.9380069673844288,0.31560479962413174,-0.14330575561532247},
{-0.9622707467208643,0.27209308724169345,-0.0006015650873899184},
{-0.9357990670971098,0.30390431180216454,0.1786680589479598},
{0.9433628302152957,0.256189491969243,0.21079258709150195},
{0.44276766954281516,-0.6171304162947049,0.6504666325735308},
{0.809528464156927,-0.3520096001459024,0.46984349215972837},
{-0.6268080112997656,0.5871551548097029,-0.5122114223158508},
{0.9086932419165206,0.4057373743835142,-0.0982536265163582},
{0.9473334662081141,0.12154288154781466,0.29628808910783755},
{0.9997844794893148,0.0206601014932616,-0.0020383273947133344},
{-0.7195288691230453,-0.691815277047198,0.06057911308875591},
{-0.6520702775550264,-0.7508683729428587,0.10488584100561489},
{-0.641294163413364,-0.584999504846516,-0.49650516140447576},
{-0.6013020428076226,-0.6985486385535759,-0.38789902409045296},
{0.3420582220507517,-0.9170562326359338,-0.20494886901631523},
{0.5896297397251506,-0.7887349852921443,-0.17387896079702145},
{0.8000948600977513,-0.5825468849243455,-0.14313399914101854},
{0.9795389588971612,-0.18722567285610525,-0.07382394886650455},
{0.9981153543436811,-0.027892801854273383,0.054660141127755184},
{0.9188485238351203,-0.14954062277783878,0.36517802834403473},
{0.9111546034278586,-0.1456680912191267,0.38545829327282316},
{0.9700241717957392,-0.15472903452748799,0.18738204824950974},
{0.9405367570797687,-0.01652090912713656,0.3392899470121169},
{0.8235233624484134,-0.5372774340148413,0.18205007662752312},
{0.7904193317440896,-0.46049858105720903,0.4039533845006424},
{0.8512620815462156,-0.28455245491288894,0.4408886128316906},
{0.782775182572436,-0.31761661745247644,0.5351473608892573},
{0.5550605943807837,-0.4727933721229438,0.6843786699205835},
{0.18685415742116357,-0.9328158519882548,0.3081235306396659},
{0.12079757228565452,-0.9675800518875254,0.22180349347840675},
{-0.15765206560916978,-0.9482636795329077,0.2755754348411209},
{-0.34160639031678636,-0.9390643206805006,-0.03825278708284274},
{-0.07346236558141969,-0.7938816973338865,-0.6036183657589035},
{0.2477709962211167,-0.36315944546758105,-0.8981785738923382},
{0.993781817848531,-0.0599789009444931,0.09380954085358179},
{0.4319139757720432,-0.756504733298895,0.49107118224261},
{0.3604142969106126,-0.7659228231262967,0.5324131512243783},
{0.9988814574844644,-0.005445251941668051,-0.04697002368536602},
{0.9460680374456688,0.30644233372734514,-0.10511120122726769},
{0.9700947815133851,0.20649127791491156,-0.12758317689086027},
{-0.07487763235736598,0.7602752489573293,-0.6452711724503318},
{0.6636225355769303,0.7166863510454881,-0.2143963724029617},
{0.7020749672371465,0.5686813465160511,-0.4285933579789248},
{0.5670254352527779,0.6537200348813199,-0.5011309926268417},
{0.43682138855135383,0.5484107628248758,-0.7130446758246674},
{-0.3735527138076915,0.9275516229544319,-0.010312941457619662},
{-0.6412410366170099,0.7287659125854598,0.24022942703137887},
{-0.46632460039300516,0.6035347273390297,0.6467512659161226},
{-0.7737994887288275,0.5599056809763728,0.296209351056629},
{-0.6491317232011197,0.7478113295737575,0.13930621412942865},
{-0.1842334025228108,0.9727772348553164,-0.14057917606143702},
{0.024617235064018982,0.9360871755760635,-0.35090567316564003},
{0.17136483659355686,0.8913192072717888,-0.41974297317245624},
{-0.04121272804445767,0.9278416559090401,-0.3706903999392268},
{-0.257557437249367,0.9211994742991289,-0.2916430953555168},
{-0.6097975050605638,0.7860356391421748,-0.10146416520261846},
{-0.7998544723090839,0.5959831403862765,0.0709712582843837},
{-0.9553342695478999,0.20059469863626556,0.2170211978273234},
{-0.9330299178874204,0.26693007767930393,0.24125402785676825},
{-0.8742035332809093,0.4293203439782887,0.22683082825210982},
{-0.8500986358091067,0.4773463546170357,0.22242474486738878},
{-0.8761791425216796,0.46067018969740803,0.141750084776442},
{-0.9429041086885662,0.2728588331077027,0.19099711781417877},
{-0.01050813549036175,0.9689122206848517,0.24718148736518528},
{0.49218578743706565,0.7379787433140833,0.46167144709362545},
{-0.07396508550659762,0.9952656996987754,0.06305040149839504},
{0.47935145358125913,0.4458925562028432,-0.7559113785837782},
{0.6986820109729421,0.7148188860344948,0.029621068704713992},
{0.6455691037058393,0.696090136956783,0.31416405518761453},
{0.6267017288696555,0.6486951225962959,0.4317864992696757},
{0.6503199703170969,0.460524244705499,0.6041534211151998},
{0.6332950385560621,0.20962916080902433,0.7449785292736831},
{0.5549960061209781,-0.061524767735352176,0.8295746718318215},
{-0.8200866122871926,0.053539307295287296,-0.5697293137285957},
{-0.7535087911736176,0.17773828632922914,-0.6329562411390084},
{-0.6280676798659415,0.17734664100983116,-0.7576801161640336},
{-0.5866173680628697,0.0005299685686660534,-0.8098640519373038},
{-0.712929866178381,0.1454269633484102,-0.6859897989344563},
{-0.7010285510477583,0.2889520083488423,-0.651970633914635},
{-0.6741506460868608,0.2723201333875473,-0.6865585563755335},
{-0.8223187825336434,0.2761127226234695,-0.4975475698843692},
{-0.8571177752251015,0.2991793620854629,-0.41933379150183897},
{-0.7667885550452126,0.3732390656349986,-0.5222335796706183},
{-0.8189864016958474,0.4197016225143422,-0.3912950573366813},
{-0.8154117542427052,0.4297570329665569,-0.3878305862855788},
{-0.8795592713719962,0.40922492225967744,-0.2427147526318172},
{-0.8875798436494615,0.41738678325156203,-0.1949109907473436},
{-0.9475748941673942,0.31676057169455263,-0.042006668082482594},
{-0.9526600020081168,0.29243143663938875,0.08320321771973767},
{-0.944856735350397,0.2706315582104502,0.1844025741782735},
{-0.9193137552610335,0.27636450990463945,0.28015152516633757},
{-0.880791243545151,0.2301007803955657,0.4138362189991811},
{-0.8192086762498055,0.2947994215744057,0.49192524411381566},
{-0.6445005510549551,0.2106718593702104,0.7350077600674414},
{-0.450352505316238,0.31809945183687166,0.8342633635108698},
{-0.3717578946453888,0.5979466478727263,0.7101097619851441},
{-0.4296228265104991,0.7487138649077978,0.5048284613964998},
{-0.4883606493403345,0.780510470699261,0.3902656547849232},
{-0.5331537361728625,0.8120999396172066,0.2371513897885633},
{-0.6948088303322753,0.6885254844054156,0.2077819689400009},
{-0.7121508028538539,0.6852634071434675,0.15249687480318336},
{-0.804378344305364,0.5805152033709959,0.1264024440732548},
{-0.8753520201552172,0.4641943324747631,0.13521265661353324},
{-0.9103942812245569,0.38773761674286406,0.14436687042457644},
{-0.9415396456571004,0.2906910817872806,0.17029912103485},
{-0.9589926725845728,0.21192864721831486,0.18820016582700824},
{-0.8819266502401064,0.2839159432302322,0.3762939286992981},
{-0.9056449917241071,0.21542752922747738,0.3652370854882981},
{-0.9685663007127845,0.1318723677851032,0.21092415636503611},
{-0.8521910717724994,0.011018324474464951,-0.5231146850519629},
{-0.8013245640225581,-0.04863113416489058,-0.5962499105944534},
{-0.6722722515624205,0.03924273647444985,-0.7392631651943646},
{-0.8906927506320392,-0.07408889081013802,-0.44852788121816384},
{-0.6747287526131545,-0.010883502403120937,-0.7379855417096854},
{-0.6416696551484798,-0.02493774033962668,-0.7665756079920522},
{-0.6121183660443649,-0.27052390229487094,-0.7430531099715094},
{-0.45994279047207065,-0.1657433383164612,-0.8723426937256252},
{-0.5008539769155596,0.18436326846662912,-0.8456686579554488},
{-0.4860906804872955,0.18385799885456047,-0.8543489255571135},
{-0.3992472317141663,0.032003945575095775,-0.9162845602956546},
{-0.44199304723199595,-0.15426048421267627,-0.8836548246962982},
{-0.5853255770753437,0.22874298747327534,-0.7778628507026267},
{-0.5316506863427151,0.7815400387051233,0.32640881668869526},
{-0.6017210813468491,0.7797001136566218,0.17320355950912064},
{-0.5673425089535182,0.7570108027905055,0.32412516408449643},
{-0.32859393413972526,0.8667853661331976,0.3751121905562607},
{-0.4868427008177465,0.8409365624113001,0.23624115361288742},
{0.11702960642929897,-0.2996695941549578,-0.9468380038623324},
{0.5598344785554503,-0.5537235153774733,-0.6164216293565309},
{0.6459383088335396,-0.44519153109543574,-0.6201356317953101},
{0.7220555965569853,-0.49505823440516206,-0.4832732767579643},
{0.7370245162366915,-0.5139013542959235,-0.4389763780875761},
{-0.2635608334488553,0.7585075474704491,0.5959882444328153},
{-0.30839717090512375,0.8483391754196175,0.43036243844703653},
{-0.5755281918438278,0.7156255855378151,0.39578696506660466},
{-0.3836139862394453,0.882948179939604,0.2706341092745393},
{-0.5458917586747091,0.8355692801126957,0.06185600975640615},
{-0.37118960952570795,0.9060210260714553,0.2033326685424157},
{-0.44526711731789287,0.8859381374745017,0.12981067291877355},
{-0.7454876370641115,0.6288299546424816,0.22095490745602883},
{-0.5239035878733687,-0.8338803090369195,0.17369128018960314},
{0.27716368943025793,-0.95935735588929,-0.05304482031751619},
{0.6261010024847835,-0.7651902298298292,-0.14993814344763065},
{0.6635293476798424,-0.7388007802634701,-0.11790764118432223},
{0.41808400740382723,-0.908179612665239,0.020385139007935853},
{0.30417838395051344,-0.9499756202314794,0.07086488342663137},
{-0.10062304069133851,-0.9553149731263649,0.27793579438892385},
{-0.14561623279949615,-0.9431781044346755,0.29868206518017665},
{-0.1910433484840891,-0.9248745342051246,0.3288001444325119},
{-0.20939092407976992,-0.949061978490156,0.2354502110794773},
{-0.1507390828053601,-0.9684208285857873,0.1985921138318846},
{-0.024976654908503114,-0.9890907443087386,0.14517460601760565},
{-0.03679061730752502,-0.9989312052509887,0.027980308324576382},
{-0.09368183866569456,-0.9952961673707952,-0.024683037115014208},
{-0.049202208761156274,-0.9893856376914835,-0.13673040109222293},
{-0.12035973682826823,-0.9662135577744136,-0.22791422624211008},
{-0.7562625470267527,-0.18121877448333626,-0.6286705939833407},
{-0.8086882729356545,-0.20794994823438784,-0.5502545740342951},
{-0.5916281212383692,-0.3066346748463379,-0.7456214470774282},
{-0.5503602219861985,-0.26729199642835366,-0.7909858498738439},
{-0.8083294561928981,-0.17403198270802414,-0.5624200914313141},
{-0.6733009233796304,-0.26056316134713886,-0.6919340326396164},
{-0.5463367879779065,-0.2239595319619234,-0.807067681266807},
{-0.43115802933598274,-0.25776143886215236,-0.864674386329805},
{-0.37334264669155354,-0.39613682821337787,-0.8388628502290412},
{-0.4839285690753457,-0.19947604562978477,-0.8520695084631256},
{-0.5395696575569331,0.005110567721861832,-0.8419254520095317},
{-0.5127531610141692,-0.1463140711779767,-0.8459765885917312},
{-0.4248279954202639,-0.25663184374800435,-0.868136666131376},
{-0.31983335092601917,-0.2208835054173702,-0.9213669761121073},
{-0.35927346849466074,0.11513181758764701,-0.9261032552662695},
{-0.2867105418210069,0.18283699231238495,-0.9404082621132513},
{-0.22753370139716464,0.03048755177290994,-0.9732928253693233},
{-0.2804886205688093,-0.03401836749247195,-0.95925433770432},
{-0.4243302177870517,0.11087327698276349,-0.8986940428888446},
{-0.4367110372221971,0.3694791196372822,-0.820224755856815},
{-0.5389771734690082,0.33208616066633295,-0.7740945603563256},
{-0.5709380304804262,0.11289348636821675,-0.8131942117887713},
{-0.781243581848021,0.24615747024325085,-0.5736418444157624},
{-0.670605626346787,0.4287120296044059,-0.6053875532124067},
{-0.6026288889538636,0.368280373841843,-0.7079604427092974},
{-0.6532386922550177,0.3332475686530119,-0.679871509130814},
{-0.7093144943899028,0.45237129515635555,-0.5405859407781133},
{-0.6169074230043564,0.4653058089415837,-0.6347564380196096},
{-0.6813938983413139,0.43460164575865234,-0.5889174516068428},
{-0.7245465348057969,0.5111121936009706,-0.4623814923343235},
{-0.8273843356401446,0.460240294721102,-0.3218913360939526},
{-0.8340226015447916,0.4881277175192754,-0.2571723770195392},
{-0.8473665792414024,0.4782284396425918,-0.2307974001191002},
{-0.9243075585814873,0.3768999548617877,-0.060016340894066045},
{-0.9365599745870065,0.35047056383125375,0.005079162272354348},
{-0.9515716185437034,0.29140859884852804,0.09794122369694103},
{-0.955223005034206,0.22125374591547198,0.19645811403908223},
{-0.9485811064901097,0.23349618929948698,0.21371339216955376},
{-0.9358898934564427,0.2103165907022126,0.2826252624969789},
{-0.8791236722840711,0.1527725768512234,0.45144446900145563},
{-0.6595785559381988,0.16283775553335705,0.7337847054275111},
{-0.48026575899566754,0.09177312872928974,0.8723087146071353},
{-0.3527558218555256,0.10854640035064936,0.9293981972857217},
{-0.29671647459123096,0.44329494576154804,0.8458421393903344},
{-0.23355013491290225,0.7010915753061528,0.6737395175562305},
{-0.27861243257041945,0.7375879517197591,0.6150927782823041},
{-0.2590616972139978,0.868031062865998,0.4235671268362651},
{-0.40142666912058667,0.851595393227163,0.3371081659542298},
{-0.30201388892628256,0.9406007630652914,0.15510582006041743},
{-0.5978110649561248,0.7948686363967131,0.10395086093368311},
{-0.695527793528747,0.7182784524186451,-0.017808796144284513},
{-0.7927849192390752,0.6092199053517,-0.018525084354962435},
{-0.8910950916414953,0.45186320701762744,0.04206161903897832},
{-0.8958451602965891,0.44435378106700574,-0.003341560209599372},
{-0.928823754790486,0.33279366807918004,0.1628950798007958},
{-0.9471188140480504,0.28325474552896285,0.15077367545940223},
{-0.9339549160061619,0.2963718751588211,0.19972963346175526},
{-0.9405776910251983,0.283264118652579,0.18728333142510115},
{-0.9898846317797064,0.14187203523578748,0.0008610368230388793},
{-0.9885800344572162,0.02049631827610355,0.14929640454375984},
{-0.6957628225611326,-0.5238332460723559,-0.49143954363793785},
{-0.6607527682391208,-0.6149333865850269,-0.43042154840041263},
{-0.5188659870679126,-0.6679320798379812,-0.5335211562696924},
{-0.46883786915164155,-0.6494957033241879,-0.5986204004314977},
{-0.6106994355304282,-0.4207750245455335,-0.6708163520379643},
{-0.5554618633384248,-0.42119731461607846,-0.7169762482375613},
{-0.6165948191943664,-0.4425912959277227,-0.6510942894171975},
{-0.5688929133724857,-0.7376333603492091,-0.36367276336632554},
{-0.5208812894776755,-0.7309888598619123,-0.4408378035398685},
{-0.4479139066296534,-0.6613549361428176,-0.6016500483564275},
{-0.32357897030617966,-0.7039216537729107,-0.6322902461094927},
{-0.3241016092821663,-0.645191404650953,-0.6918715185822005},
{-0.4610231482318896,-0.434620655457072,-0.7736682380997828},
{-0.37040090084262517,-0.49493463087224054,-0.7860298237461038},
{-0.4570838806354463,-0.6040635603648281,-0.6528258122214601},
{-0.4510179080050444,-0.5000685241848447,-0.739266066973417},
{-0.268631805983638,0.8448671572788525,0.46264072385115423},
{-0.32269832060266246,0.9329064454583794,0.15984792117019514},
{-0.4733942853287233,0.8777319647386806,0.07405706376898007},
{-0.5697053087606452,0.8217423978574484,0.013239816215825878},
{-0.3736525845484523,0.8969202179803211,0.2364695934753453},
{-0.02382692425232516,0.9651091490559474,0.2607615924348893},
{-0.39125937977383174,0.8872225613748709,0.24444268106533673},
{-0.6437893586824117,0.763220090034089,0.055048667700918014},
{-0.7773674097221402,0.6209707940038303,0.10047478935604996},
{-0.7018960316206742,0.696996860561113,0.14675604642774345},
{-0.9585849492231011,0.03407204467100901,0.28276136740170393},
{-0.8795979174341485,-0.375046346831921,0.29265635372145793},
{-0.5144020236150573,-0.8336624459498516,0.2009912543212883},
{0.107846557425115,-0.9940617884740329,0.014501060214979888},
{0.403693681746825,-0.9139201939713565,-0.04220533578886997},
{0.6865641769770572,-0.7089648083327719,-0.1612406010826428},
{0.7041149735343745,-0.6929378135644384,-0.15511057532361563},
{0.5586692388969193,-0.8292214117897057,-0.016749081760631016},
{0.34691034090461925,-0.9300779203302928,0.12086470736951457},
{0.011500767935755793,-0.9745295893057365,0.22396386294328896},
{0.012536678762569415,-0.9703773053905538,0.24126897203861905},
{-0.14792264987811654,-0.9179292304202791,0.3681369549407804},
{-0.15054368461991766,-0.9477085995710004,0.2813983107984692},
{-0.06010060518961436,-0.9733742871366681,0.22120220251395575},
{-0.09270411426057684,-0.9252847070868192,0.367769164055962},
{-0.18720289164412995,-0.9557547083788925,0.2269097062085582},
{-0.036706868634164794,-0.9832556878435827,0.17849610112917622},
{0.02904965383881199,-0.9759541434354814,0.21603154288890541},
{-0.04517789458450879,-0.9829903198002484,0.17801401354926155},
{-0.6380741316682533,-0.7602780588903664,0.12181410290151581},
{-0.550816764910223,-0.8182873227480835,0.16433730228895088},
{-0.5982073684255681,-0.7652841754797224,0.23767220098631214},
{-0.4672158363022314,-0.859044689849433,0.20916879105138503},
{-0.20865188790408698,-0.9754308554574049,0.07070386054307957},
{-0.027685510181063012,-0.9995031863679703,-0.015062966716042564},
{-0.07530559357258568,-0.9971565678101594,0.0028012229014597965},
{0.027436731412724288,-0.999268851152632,0.026626845203386346},
{-0.2425757563442901,-0.9592745865021872,-0.14473862692817427},
{-0.23746689000735016,-0.9582944486755185,-0.1590007100233232},
{-0.33707003926835144,-0.9325268118943536,-0.1295281194404717},
{-0.4938802447249882,-0.8449395000889047,-0.2053278964483332},
{0.17584392105036403,-0.9841723329801534,-0.02199396339988243},
{0.054365255020314876,-0.9873946990397899,-0.1486476617868536},
{0.11590864666868857,-0.9930243473342388,-0.02162940657627966},
{0.2101098364422466,-0.9765661698007083,0.04660871840103013},
{0.4564476007174805,-0.8819144785797983,0.11782376785088024},
{0.4716004061010435,-0.8425711175720828,0.2601287542711537},
{0.6861684988086683,-0.5843094702666557,0.43330732073132444},
{0.5755110569459324,-0.6014963104300137,0.5540660717568403},
{0.27824521469526386,-0.8870064565268004,0.3685093575188503},
{-0.02606939935696907,-0.9996109786364694,-0.00991351635932824},
{-0.40628125983930635,-0.8094423623065373,-0.42395589394062955},
{-0.5542490801506221,-0.6736822578056944,-0.4888355272175002},
{-0.5715375157149691,-0.6989526585998382,-0.4298953932837374},
{-0.9581994018667085,-0.1512320824580236,0.24286367265956363},
{-0.6828482707464874,-0.6906335869935478,0.23820891598543786},
{0.31725581419093596,-0.9454458144236922,-0.074033508297039},
{0.27586975599695035,-0.9592003607888692,-0.06189140157312938},
{0.6403954805033121,-0.7594053402932115,-0.11487888267686044},
{0.6474187022891482,-0.7434298022163345,-0.16781285142329505},
{0.6137375538062116,-0.7487748619377839,-0.25032463158470863},
{0.4835969101313106,-0.8724146674409983,-0.07089905884609153},
{0.054883469761783855,-0.9876046980400525,0.14705361320322555},
{-0.06989887032938695,-0.9478463214687093,0.31096864601581925},
{-0.12538178310163778,-0.9564616449438261,0.263553657188824},
{-0.10561248793616679,-0.8999027470011478,0.42310879018488995},
{-0.023508160191313184,-0.8905022369964879,0.45437113938791324},
{-0.03134267906314645,-0.9759012696184812,0.21594987480010505},
{0.03570099906044997,-0.9919369253863254,0.12160006053127333},
{-0.6501946895898538,-0.1633029808051809,-0.7420101091557286},
{-0.47707057919858104,-0.059333363524895516,-0.8768598602034153},
{-0.43804597312129845,0.06166014066556876,-0.8968354099194105},
{-0.4113618151739402,0.20200249867098416,-0.8888061923431229},
{-0.3733394680002999,0.3493887055424151,-0.8593865102924578},
{-0.26016662991669776,0.5330868063524398,-0.8050663212249936},
{-0.2584766345689364,0.6197693681576831,-0.7409964640100132},
{-0.04008729678611657,0.8229750040175273,-0.5666614080725215},
{0.16415143807917928,0.9189011975682293,-0.35871283010816796},
{0.2701212010752532,0.9379752813838156,-0.21734053520366284},
{0.41648686837759286,0.9078141606379584,-0.049113523740661684},
{0.5323087644503349,0.840392469081658,-0.10192093602490261},
{0.5786019053109964,0.7777847102748929,0.24550107868008564},
{0.5572086678638658,0.7826525359644273,0.2774409998645244},
{0.62190388119666,0.6414712295861476,0.4491661431650503},
{0.6297396821211639,0.4666054299970562,0.6210533837434571},
{0.4900783908712832,0.40497458872443604,0.7718929675081174},
{0.5295665536629413,0.18310122790958208,0.8282712149891233},
{-0.9562559129275149,0.20715787930693277,-0.2065435596483693},
{-0.9508839361732014,0.3055201693784687,-0.04977113652219376},
{-0.9272858406617729,0.36066580316688296,0.10030527470764652},
{-0.7387686092102007,0.5445347683865752,-0.3971181537827309},
{-0.8949178291842277,0.42052695552294694,-0.14926204704073606},
{-0.837889142015191,0.47296270302795357,-0.27248498534330085},
{-0.6126905633683768,0.6551917220252051,-0.44196615362376723},
{-0.5015154248357322,0.7823047084300087,-0.36943419146050116},
{-0.6718326105153654,0.4131005368037264,0.6148080106346879},
{0.9546651274386093,0.08401123890150854,0.2855811726827551},
{0.6827553913977153,-0.6055387142300112,-0.40886176280745246},
{0.5337045237235795,-0.785014704983426,-0.31450181925828674},
{0.2572142942962423,-0.8756009470564782,-0.40885668433264555},
{-0.02727678679965035,-0.991524315597215,-0.12702562135789966},
{-0.008104193042547204,-0.9132024939843487,-0.4074254864829822},
{0.2312132203736336,-0.8136202250843707,-0.5334440702249034},
{-0.41426881306566926,-0.6695543363778635,-0.6165049400927459},
{-0.4910693003591766,-0.34886655356709523,-0.7982124216315892},
{-0.48909524354810835,-0.4201150226545132,-0.7643881281643601},
{-0.44364676698466327,-0.4191060026570128,-0.7921664627342639},
{-0.6016041292328451,-0.38824533338684714,-0.6980960054271376},
{-0.6529882787262679,-0.10942073253268488,-0.7494220514090285},
{-0.3950187599388134,0.42743788163937396,-0.8131771250078587},
{-0.11748577515823887,0.8946240000657177,-0.43109742650807165},
{0.016675120415806575,0.9968226575172808,-0.07788793115306415},
{-0.12725448424775349,0.9321268501795391,-0.33903662252507394},
{0.779789688239682,-0.5539574794796635,-0.2916490237316043},
{0.7891979104096907,-0.44637671386614736,-0.421799108015934},
{0.5931794435243287,-0.6610546242655899,-0.45950509411457807},
{0.5052788075088585,-0.698433436930763,-0.5068373120237971},
{-0.4939301654639016,0.7157124003756786,0.49374968515765855},
{-0.6161762851282641,0.6703641275676234,0.41344736317460207},
{-0.6317663846925998,0.7096660275597998,0.3118418902263384},
{-0.6235147823123354,0.7640497064973052,0.1657026319627505},
{-0.14149788041808728,0.9207820380059579,0.36350899345515975},
{0.12078333859517676,0.9759428735429548,0.18151278935249468},
{0.023063787566263042,0.9997313963644009,-0.0022796548825118786},
{-0.10742787274147184,0.993901894353172,0.024865167592805524},
{-0.03179712614176565,0.9993815333796605,-0.015016441284238728},
{-0.20627475520985838,0.9779723880795468,-0.031948920437181984},
{-0.7235216370471191,0.6669257191258662,0.17811941470009124},
{-0.7436590726655832,0.6490449101599574,0.16034926952629885},
{-0.45593042823321456,0.8879686209718783,-0.06032555661059811},
{-0.4526282402836308,0.8865404931948372,-0.09577906881776685},
{0.08520318586832051,0.9258941014658677,-0.3680496297900623},
{0.20816373659416657,0.8838857755644048,-0.41882430030033463},
{0.17875796234312238,0.8901835190055923,-0.41906907949615513},
{-0.008189436148189446,0.9338532321985394,-0.3575626852006725},
{-0.4391310251377747,0.8854275318146634,-0.15225645689441333},
{-0.4258347965907012,0.9031029834684603,-0.05540511946491858},
{-0.596113802839348,0.8024245765951072,0.0276248609150118},
{-0.9170836773151165,0.35439280418136077,0.18265615003786553},
{-0.9721965268474987,-0.016603107849055512,0.23357707506391448},
{-0.9630104144193347,0.037099174099911106,0.26689809478714116},
{-0.9094468596356554,0.29457808359238863,0.2934794067151567},
{-0.8385272424692777,0.422553197411267,0.34397799202039714},
{-0.8697899588040554,0.3296535123013994,0.3671430094540692},
{-0.8800385311503864,0.3565056627829835,0.31374495389461793},
{-0.9007012374866779,0.3607557348777363,0.24205904350548776},
{-0.8847518629796716,0.3560988673676135,0.30067879475198034},
{-0.8911955091488118,0.36819134382041085,0.26496358015529226},
{-0.9754423376625388,0.05761626091935189,0.21258554130776303},
{-0.8779142625176337,-0.45500767013053794,0.14911260104531332},
{-0.4238077145576276,-0.9030726286149086,0.06961931145881742},
{-0.6371577383580745,-0.7526820848260588,0.1658303218121496},
{-0.48035191304379676,-0.8289544282340185,0.28652503476376384},
{-0.0351298026205971,-0.9811652147837789,0.18994925181779201},
{0.4290453685551304,-0.856212724993389,0.287784365942258},
{0.25784810933654173,-0.8912175168890911,0.3731563882631696},
{0.19908062005042498,-0.9725801854045559,-0.12022765771143616},
{0.45225609274396644,-0.8590108267165084,-0.23992670997573706},
{0.5079579844145417,-0.8083810231874633,-0.29748749119905227},
{0.3476920422024187,-0.9287008497246162,-0.12893787461365736},
{0.036875918514311296,-0.9963387150897745,0.07713190939541945},
{-0.13028576407557757,-0.9777871695784766,0.1641885217880788},
{-0.13892968627025956,-0.9794766383695477,0.14602759041063967},
{-0.06709500367336331,-0.9668537557081238,0.24635761720549057},
{-0.09432924125163887,-0.910672951201907,0.4022148308977416},
{-0.12232992812564668,-0.9378989062645537,0.32462444503229887},
{-0.1322159297307077,-0.9729508761520879,0.18943479226459173},
{-0.07256193934187481,-0.9026583292449538,0.4241965412443325},
{0.0309028490079361,-0.9036124203043984,0.4272348391632174},
{0.14876097577030903,-0.8887496471953636,0.4335830216901745},
{0.16656653907105495,-0.9565227146763137,0.23941571454302246},
{0.07183720839521275,-0.964942205127725,0.25244000525516214},
{-0.00530697253862498,-0.9538368754675315,0.3002782893264367},
{-0.31549445230892875,-0.8741093853578285,0.36931833557467514},
{0.11508389237312612,-0.9895582375888093,0.08677667968054682},
{0.2994956406119101,-0.9529444888663224,0.04689522783573017},
{0.2398632390664378,-0.9706659587728886,0.016529459279291572},
{-0.20261723834949236,-0.9773552285744572,0.06101648876980247},
{-0.48301083700055586,-0.8751093961758106,0.029733416635670893},
{-0.2744755256533707,-0.9509766430289023,-0.14250126396206317},
{0.3778970675600111,-0.9238024634113662,0.0615045927117288},
{0.3832380929052982,-0.8969789791725781,0.2203571534323992},
{-0.3248118959655021,-0.8183865171354879,-0.4740682870749125},
{0.4710280183770645,-0.7503636691198794,-0.46377469742184957},
{0.9104459846356839,-0.21897906571490483,-0.3509077910782079},
{0.939222938117139,-0.29532859597383804,-0.1750465449951255},
{0.804000046032161,-0.5442179151072056,0.23960548169156984},
{0.693780637045112,-0.5976625913279724,0.40183062923128654},
{0.015182180047963623,-0.9334234975202085,-0.35845512367119625},
{-0.10395806138528402,-0.9644996165964288,-0.2427616342389283},
{-0.01774252619143861,-0.9936144823445312,-0.11142469761931265},
{0.005149295100432968,-0.9904401383044326,-0.13784707902405866},
{0.8787106170242044,-0.3742291479438181,-0.29634472554473773},
{0.9978418574793053,-0.06212685361365712,0.021257505082136866},
{0.7590089597564983,-0.5967141026543358,0.2604566733696584},
{0.8657679574503595,-0.282738217799041,0.41292244313921045},
{0.7695811709871702,-0.21358515501830636,0.6017692272107489},
{0.6086696359011144,-0.2611311588892697,0.7492207900139662},
{0.3784396261248596,-0.6643391185113551,0.6445440132326359},
{0.2095003160494698,-0.852694033437017,0.4785629560633413},
{0.1251527323724829,-0.9088548876104807,0.3978939391926474},
{-0.013381998206891317,-0.9992227020406197,0.037079830779464376},
{-0.12700553440112694,-0.9667921721539187,-0.22177125623802524},
{-0.4048599820248259,-0.7350281421164465,-0.5438952337093078},
{-0.523140686372617,-0.5641335259290536,-0.6388091946617868},
{-0.5677030786884532,-0.6214438623758441,-0.5399266064596601},
{-0.5403437551286374,-0.14757762606330985,-0.8284017567454821},
{-0.35129300750195763,-0.0732883311224687,-0.933392759454193},
{-0.36589572401155607,0.0786812624276011,-0.9273238798245509},
{-0.3197977154234201,0.1919455528277644,-0.9278396014180496},
{-0.2586015939255357,0.40962024082912757,-0.8748351124196262},
{-0.11844716474862484,0.5497119599598905,-0.8269141613493312},
{-0.043538926167384015,0.7327506590220986,-0.6791029624518444},
{-0.11161373163945507,0.7588501161107186,-0.6416298591775981},
{0.10898063573520236,0.8821942223989835,-0.4581010532629279},
{0.2238160690756911,0.9489683048089731,-0.2221835360495671},
{0.31552987459620524,0.9413536538479947,-0.11955833983596739},
{0.4026569297023787,0.9153116151386322,0.008487882831534729},
{0.4621935454156633,0.8867507376167628,0.007089140443394091},
{0.43828337361368036,0.8816476401107898,0.17494319964173047},
{0.541198520806299,0.7195430106357338,0.4351574622160792},
{0.2207709511112586,0.7615869831652884,0.6092991500228971},
{-0.1713299342818509,0.9843031106521528,0.042349025720464194},
{-0.333734724523585,0.9395948884061348,0.07604327273487002},
{0.04784155617578559,0.9746510009348835,0.21855574089762259},
{0.02025086036580529,0.9732423533782038,0.22888692458351634},
{-0.27275063754972234,0.96078504156058,0.04999193564620921},
{-0.8774218123425787,0.4607835180665659,0.13345228624367333},
{-0.8237065219559858,0.562581394601109,0.07077951777063951},
{-0.6957211565398267,0.7032042320519086,-0.14654651264076937},
{-0.8425675796565114,0.5379345737043637,0.026575705546095903},
{-0.86304752425105,0.47228764331098183,0.17914617735216098},
{-0.8300502474159397,0.48763109303672314,0.27061504738012593},
{-0.9318856379402709,0.016088095392858874,0.36239526899131114},
{-0.7844700616498131,-0.5285734346438314,0.32437146385581084},
{-0.8266293758991395,-0.5308489639766877,0.18677058747424974},
{-0.8316587981596658,-0.5114116145412536,0.21633724588227662},
{-0.928197313083577,-0.06427008461267278,0.366495708308171},
{-0.9597563353535419,-0.014486349076445275,0.2804601976023961},
{-0.7354099252377025,-0.6127322399926358,0.28936386079723847},
{-0.4406105876707146,-0.8710253566673172,0.21720298818165573},
{-0.40975165906156297,-0.8976086886499827,0.16248759939255478},
{-0.27703561293168927,-0.9608565337839278,-0.0024475809075669257},
{-0.058003129775299304,-0.9860758183838202,-0.1558528707946992},
{0.16344708653847634,-0.947916035694742,-0.2733866111843234},
{0.15923781800947379,-0.9566897838249292,-0.24369648097703903},
{0.09641459142725468,-0.9644210467456903,-0.2461630986843125},
{0.08219746489732474,-0.9362935385258463,-0.34146447323140766},
{0.15392210012121038,-0.9178784757378401,-0.365796515663361},
{0.09027128176579347,-0.9070721263797684,-0.4111827491921885},
{0.27369575151344344,-0.8462356456211898,-0.45713878383219636},
{-0.4705575818492822,-0.3755711341076171,-0.7984496761783264},
{-0.25813807617381157,0.11749874330269355,-0.9589362747083725},
{-0.06874584284767772,0.5762180619631364,-0.8143996280442481},
{0.07446445815601296,0.7608470553317075,-0.6446447105690085},
{-0.9550816944818192,-0.03309846362926548,0.29448845235614757},
{-0.5167907342015617,-0.496897125300975,-0.6971517653359547},
{-0.30247533065078774,-0.5309666361265944,-0.791570025751421},
{-0.42308585743139576,-0.3638039222593009,-0.8298464095182247},
{0.6471515702536105,-0.20895225488832625,-0.7331669661784893},
{-0.2566111542169683,-0.732156167042999,-0.6309501268660936},
{-0.12830050203122073,-0.9399128256085544,-0.31639036242445784},
{0.12601482786527282,-0.9885311657007962,0.08322498180420822},
{0.39737809120138834,-0.9119117244090755,0.1025068754689523},
{0.6913480071225854,-0.4358941822783878,0.5762240839321848},
{0.8812331843965725,-0.15958695900584538,0.4449270470914789},
{0.8446451931350065,0.32594772817294937,0.4246558326607802},
{-0.1681822521472157,-0.9179050880435907,-0.35939529686179583},
{-0.24460390193437945,-0.9083527880779158,-0.33921106047644334},
{-0.14998476184556003,-0.9661789462284277,-0.2097684797081191},
{-0.10722995457612405,-0.9756329984372918,-0.19142097377733103},
{-0.6715181979270927,-0.5352523507129479,-0.5124141205207108},
{-0.5737169226025841,-0.02217759556732442,-0.8187533492904152},
{-0.4788342794020829,0.07574573081280864,-0.8746315322083474},
{0.07934025682327624,0.35445811527180626,-0.9316998272862217},
{0.5199138399033474,0.5733019591027868,-0.633257027411353},
{0.8893937517112711,0.3651486751161826,-0.2750367238712793},
{0.7934076721488634,0.32823006693172463,-0.5126102700271593},
{0.6044549782344159,0.662966230544256,-0.4417125269285129},
{0.34110651505155454,0.9147143284802653,-0.21666573947507456},
{0.9799356089076009,-0.19868462693514855,0.015831026957531247},
{0.9674999273654468,0.08692408364123912,-0.23746177425216522},
{-0.9910925435635846,0.1283379176988367,0.03556612114626384},
{-0.8123835319687832,0.5029990243378445,-0.2949999635611869},
{-0.69595978149903,0.3702743533964711,-0.6152535134013034},
{-0.9207884753591042,0.33860584679947525,-0.19363538973820532},
{0.8850193595257115,0.4610595381279907,-0.06453553723262477},
{0.7604493356158069,-0.649361362454607,0.006828536634935481},
{0.9932745804219537,-0.0726522486360795,0.09015130978367858},
{0.9526266675060844,-0.27700473435405126,0.12558188365243494},
{0.8902813006512768,-0.3790012431032149,0.2525020067977451},
{0.8321368495053939,0.03592326255571423,0.5534056223987885},
{0.9406232461888355,-0.28747781141137535,0.18051154166784697},
{0.8563782615355712,-0.48996346899799453,0.16294806601111975},
{0.7712488701289284,-0.6086765934268576,0.18624710719666834},
{-0.8843197713584652,0.4579151040758666,-0.09106206369120033},
{-0.8935827621939555,0.3992529855210032,-0.2051996604831164},
{0.9888311520598715,0.143379786870897,0.04068401937866184},
{0.8691183856934832,-0.4144385897528651,0.2699516382117547},
{-0.8999555078471727,0.38761249110997026,-0.19959118375083806},
{-0.9090614344272525,0.2804679956977385,-0.30813148463985246},
{0.023963425641341768,0.7818845277225119,-0.6229625506719295},
{0.8980646933401131,-0.34797803383615455,0.2690559319982614},
{0.5759507740223414,-0.7069551011938664,0.41048165707987005},
{0.9197545060461602,-0.3095153615131179,0.2413542823220419},
{-0.9956245879736942,-0.04452749742193709,-0.08215218679713253},
{-0.9461017784250714,-0.21560345737915718,-0.2416745208479189},
{0.6072668045414227,-0.6321783641803077,0.48122504503024344},
{0.37108772721689154,-0.8091730123531884,0.45555782814947743},
{0.8049903420102814,-0.06098675677391213,0.590145037061543},
{0.9546252733026074,-0.29445527903373386,0.04457214624726809},
{0.7803879009431712,-0.6012860230049926,0.17160956441979158},
{0.886818381259647,-0.45100215546347383,0.1007482725773504},
{0.016009538282818963,0.9937342794487206,0.11061589638249456},
{-0.34858295637579617,0.8887321776610972,-0.2977331673060186},
{-0.7206093443869023,0.6765402213900358,-0.1517086076127535},
{-0.7215769905542614,0.5974501353838907,-0.34982850431665224},
{-0.5584417608107344,0.719502368507456,-0.4128669779659879},
{-0.47795493957999363,0.8037823937404769,-0.3542498260322985},
{-0.7494097078382805,0.6553314671657796,-0.09447622949763444},
{-0.812683685997025,0.49415663098286916,0.30879515956366477},
{-0.7702750754461277,0.38510329895767637,0.5083028204509364},
{-0.4196391562841353,0.5789390467331319,0.6990940985882168},
{-0.2896728279279251,0.6566231991528177,0.696373195272878},
{-0.2635922562936002,0.7594258311420092,0.5948037738753155},
{-0.2787406587085539,0.9142700274134574,0.2939625182844189},
{0.13985123450959866,0.9100284705833502,0.3902432766030309},
{0.17284882718503225,0.9052292553981921,0.38817944060961507},
{0.12681912470186543,0.9293247086749591,0.34680325179567606},
{0.21370449009077877,0.9380105119040836,0.2728858194785495},
{0.32159214276837556,0.919560246742549,0.22580399978837193},
{0.2427754967489605,0.9601424134225397,0.13851571797249662},
{0.17004302498975887,0.9854071655187835,-0.007621535053334309},
{0.11482311127303377,0.990059507176717,-0.08122699900018937},
{0.0768366191987046,0.9964604518969087,-0.034098412800624596},
{-0.5392056906535379,-0.6665843366025679,-0.5147062709574807},
{-0.16539474133895293,-0.1714469129735394,-0.9712108605082959},
{0.020456935698212213,0.351273081230265,-0.9360495372494101},
{0.15448400603348464,0.7460492788917193,-0.6477230622302961},
{0.16950464717508626,0.720398978227551,-0.6725276847496688},
{-0.9238308379314221,0.25415597345392477,0.28625395026901285},
{-0.8888345417430311,-0.2414895794064428,0.3894302767409786},
{-0.5255450584829644,-0.6983139612781926,0.4859629646260056},
{-0.5567504463413454,-0.29772082595852095,0.775494197456879},
{-0.734394608476443,-0.5615039122346611,0.38128455985772874},
{-0.697306750165554,-0.7146571239332298,0.05503173071090576},
{-0.2872968628583507,-0.9549933317941258,0.07381225386414422},
{0.35133601041155493,-0.8939331224325134,-0.2782922571796581},
{0.450244151573095,-0.8374584341192303,-0.3097475990169914},
{0.2561480721620597,-0.9246787019887159,-0.28170456726173976},
{-0.15285467668731337,-0.9713621623669513,-0.18190931074746405},
{0.360980377447862,-0.8829087368987647,-0.30027542257971607},
{-0.06278887871836053,-0.996632909011023,-0.05272951152359527},
{-0.08096650405884837,-0.9956891202162507,0.045250426555748555},
{-0.12529838047541977,-0.9867451532958736,0.10312283111580987},
{-0.07797599383474345,-0.9631218514827737,0.25751901596169197},
{-0.09332707208056558,-0.9741322825466117,0.2058065929881676},
{-0.10784033365291294,-0.9472898173516437,0.30168272138045593},
{0.2592788359453763,-0.30699615801197044,0.9157116599654609},
{0.2049271007279907,-0.3544393092770704,0.9123473348601471},
{0.3400210071508218,-0.3666089245820101,0.8660159416044041},
{0.09069684388910054,-0.44682021298150115,0.8900144829044763},
{-0.061058160473064824,-0.5942762410522268,0.8019399293965109},
{-0.00943389959200187,-0.7025148045593786,0.7116065984189482},
{-0.059842147707978174,-0.7687269586224615,0.6367713721931576},
{0.06899402264169537,-0.7854313737550254,0.6150913606619839},
{0.22735966795547125,-0.7487561924727278,0.6226329140199071},
{0.1488029488681772,-0.8524097636511084,0.5012537054630081},
{-0.8060628669429922,0.31679766395463643,-0.49990188502198024},
{-0.9730620598932664,-0.15820318204022238,-0.16769609652171807},
{-0.9655975492194884,0.1514527005397469,-0.2113846078609686},
{0.467401977889588,0.621571858624468,-0.6286364733540568},
{0.05591059774401024,-0.834000558676776,0.5489235586005877},
{-0.7296587512600216,0.6460475760611808,-0.2240996121708794},
{-0.996044875980184,0.08123910650860171,0.03598350465566226},
{-0.797493550839467,0.4416882159097943,0.4109933774355511},
{-0.892948473824999,0.109551441047317,0.43662513081367776},
{-0.7630997384304959,-0.08853912682379987,0.6401871696844509},
{-0.8535016668347133,0.1948339385092663,0.4832956042789275},
{-0.9314040131814664,0.04686224433762111,0.3609577458444405},
{-0.7702139726323965,-0.10945257220097514,0.628323619483155},
{-0.5746267721722707,-0.7087449983242889,0.4092488241317021},
{0.22609794218828552,-0.9506718041704525,-0.21237429527492205},
{0.2660001850160591,-0.8680426254256817,-0.4192205887304582},
{-0.22638499215323102,-0.8939268447738282,-0.38683928383824917},
{-0.46912194400010665,-0.8501619289939105,-0.2390591896307563},
{-0.4991085859984424,-0.8274059044172031,-0.25746861695784484},
{-0.2709107889813291,-0.952679799580196,-0.13787147596711627},
{-0.2295709636846925,-0.9725181927148108,0.03880125605698731},
{0.92774625097286,-0.366334231733543,0.07131706994820963},
{0.9716535159228138,-0.17107339864578308,0.16316659361099367},
{0.8833093475460099,-0.11596129208268456,0.4542219449524172},
{0.9801104458224853,-0.19380755678839365,0.042686589479161687},
{0.9256410440044204,-0.21775795025265102,-0.30946749870732915},
{0.8109891912658631,0.002686841652245888,0.5850549653937458},
{0.8629584717775242,0.2374779234562503,0.4459898113839678},
{-0.48970238906132757,-0.8264713837100109,0.27773480526590094},
{-0.6059057188282854,-0.7336169491129612,0.30770835520890494},
{-0.36995508568350416,-0.8724851760343879,0.31922226140598997},
{-0.1614571392127271,-0.9744510116995634,0.15613077209486667},
{0.04768652507397778,-0.998729420985844,-0.016295366938169704},
{0.2669028434170819,-0.959738527422342,-0.08754902145124897},
{0.25841715022909445,-0.9654076591287869,-0.034765329898469956},
{0.2999546041261592,-0.9488098193868675,0.09893008692293266},
{0.2962308919074572,-0.9260874923732711,0.2336861466786144},
{0.05024081161190744,-0.9708350392633,0.23442522771067945},
{-0.06372717076731121,-0.9929373263014591,-0.10007154312442443},
{-0.1457459922714278,-0.977438096970703,-0.15288189012144998},
{-0.15690729747887416,-0.9807823260966696,-0.11595744397960032},
{-0.37744312147416276,-0.8776561089108676,-0.2953920184149793},
{-0.42726685672858344,-0.8324539589630787,-0.3527937631931338},
{-0.3263932058515095,-0.8480113625047739,-0.4175454517016931},
{-0.3167986105760042,-0.7835073964257729,-0.5345603802034153},
{-0.23078579317823975,-0.77283596224252,-0.5911535275474292},
{-0.20150268375426325,-0.7154805774034892,-0.668942607252819},
{-0.23384655295943949,-0.7204871334860381,-0.6528507334376366},
{-0.23767653193331967,-0.7454584464396024,-0.6227371602851431},
{-0.2874251019122229,-0.5563281833578594,-0.7796702913363392},
{0.3811800323925181,-0.9243693145426135,-0.015593371580823393},
{0.47099747308431594,-0.7735358687074748,-0.4240325932887252},
{0.3190421368100145,-0.8712399769693971,-0.37303219361077183},
{0.30107531983383606,-0.9423506787736998,-0.14604400022493522},
{0.0595317700754329,-0.9953363246685576,0.07590500080346091},
{-0.09716372524956712,-0.9944716447398956,-0.03981655816307871},
{-0.4853971958229974,-0.8463299749151464,-0.2193516260420665},
{-0.5952157366502961,-0.6344735405736326,-0.4931141380611635},
{-0.31844118638155217,-0.37494975912019346,-0.8706364849646598},
{-0.3233537325116343,-0.2454483436291205,-0.9138913908558913},
{-0.5159021406989149,-0.3496528588390285,-0.7820408298343324},
{-0.5535427939373857,-0.4473453017459633,-0.7024760182994191},
{-0.6506573338669629,-0.4534057926283439,-0.6091536925080556},
{-0.7320550212033348,-0.394123370631247,-0.5556637604282375},
{-0.4653184313460581,0.03375091715546167,-0.8844996512383761},
{-0.027783551432391522,0.5711486085875479,-0.8203763411863555},
{0.3418853836038224,0.8741970543639324,-0.34480993985018915},
{0.16881662884139248,0.9457307959332674,-0.2776584366628467},
{0.18520799522820508,0.9823944403870368,-0.02447778585145736},
{0.15917815501339241,0.9871126062405943,-0.016462611197312457},
{0.34359600447641053,0.8579583797270612,-0.3819020874045625},
{-0.17380449671435677,0.7657316911301665,-0.6192309537812241},
{-0.29256265176864493,0.8537536489917218,-0.43071080973597436},
{-0.7283297254526431,0.5938290097870019,-0.3419106873987214},
{-0.7503991063492834,0.5197641223404167,-0.40834597869685574},
{-0.5388602384167522,0.837589468585635,-0.08985279944372665},
{-0.6150616008198092,0.7864575399024334,0.05642486267228402},
{-0.9462816710259885,0.209471796413745,0.24631801717994836},
{-0.9289117215539547,0.15895208658749174,0.33445066561325704},
{-0.8071018155698189,0.05684031478444886,0.5876698375100656},
{-0.7420444806729304,0.03132509653591293,0.6696183443050653},
{-0.5509282241504958,-0.04873250629435063,0.8331285823116694},
{-0.4045274219466891,-0.07565180796532103,0.9113914465501328},
{-0.3501731011698181,-0.08404868076638665,0.932906543271373},
{-0.31642501143357643,0.17891440054039087,0.9315926413505708},
{-0.3013115717744122,0.5917396529244742,0.7477001537191604},
{-0.18998179744486668,0.7835649987104109,0.5915511891929317},
{-0.1823629860613957,0.8970756365029826,0.4024910479843498},
{-0.1921937011088294,0.9418016527578514,0.2758101305548247},
{-0.1510986380686054,0.9678136831188896,0.20126071733366713},
{-0.15244613991370842,0.9874345038553614,-0.041632619678882675},
{-0.3222110883391421,0.9416031306868775,-0.09779344984188229},
{-0.5829308146431267,0.8124623442181366,-0.009828762234927324},
{-0.49802628787822256,0.8469781312879431,-0.18600500450853924},
{-0.6660274293131848,0.7316030452955334,-0.14548005882859844},
{-0.7008251083663698,0.6908145059276901,-0.17781868822805813},
{-0.8042228444012315,0.5887006255718874,-0.08159160492637127},
{-0.8912333091197691,0.4522911900691235,-0.03370264234866592},
{-0.5775070645879093,0.4117877087592584,-0.704923026482932},
{-0.49727308332797693,0.4560219151364275,-0.7380809532245035},
{-0.4305239403505371,0.3204777018493476,-0.8437672542842651},
{-0.49294846031040457,0.32034422332079365,-0.8089384365096017},
{-0.5328171995493678,0.5222269385157534,-0.6658715015322647},
{-0.46142304461068595,0.5561225009795057,-0.6912427488274322},
{-0.4340517984601443,0.3608365995053678,-0.8254671312117261},
{-0.5338834284654919,0.4736123968883104,-0.7004711145533709},
{-0.5735166836560986,0.5985622375141059,-0.5592869222413642},
{-0.7245855648909405,0.5565651527618729,-0.40646154785272093},
{-0.80804377681521,0.5195261893152552,-0.2777729169047636},
{-0.8147362741157144,0.5247398721010987,-0.2466837454462004},
{-0.8476789917820218,0.5070119158923319,-0.15613854115689052},
{-0.9109722440549209,0.41230326550196206,-0.011644218220221826},
{-0.11040258223713988,0.9274744446480523,0.3572148154264583},
{0.6498194241737844,-0.7459679621048817,0.1458304339962717},
{0.8694907300051182,-0.3917448913913129,0.3008684272302015},
{-0.4486952803743291,-0.772942832827541,0.4485888123330075},
{-0.6064424471684958,-0.6865166334192415,0.4011514306480745},
{-0.5625713606950711,-0.7155201950267716,0.4141790852210514},
{-0.4666446641945926,-0.7486525564726874,0.470916242091548},
{-0.2828679313408558,-0.8580586475798727,0.4286269832060796},
{-0.11627376943547671,-0.9505849213287819,0.28786927221157},
{-0.017439816119987076,-0.9991337435602354,0.03778379669925557},
{0.038364584499251016,-0.9898066313954708,-0.1371531665757313},
{0.24882548774359034,-0.959480143037661,-0.13222606311009175},
{0.3555795416019238,-0.9123308716905582,-0.20301618200161317},
{0.4900208525681731,-0.8648720731355546,-0.10897642478338485},
{0.3675167807794136,-0.9299235672313632,0.013174784750919467},
{0.2744069899476925,-0.957280588939396,0.09118485569265432},
{0.28462523543847995,-0.9369738284806634,0.2026536949919199},
{0.2717101656929537,-0.9032938578578239,0.33201474698488465},
{0.05487457613035515,-0.9672651761714843,0.24776371780480952},
{-0.0951516834597669,-0.9306760587121247,0.3532537768727151},
{-0.12829538253102554,-0.9453693632474296,0.2996949479960702},
{-0.006371323466542188,-0.9999715904006914,0.00402798073439051},
{-0.0022205979089813246,-0.9877453992933534,-0.1560579864016592},
{-0.05504159904915839,-0.9902383047822877,-0.12805671445110933},
{-0.06429369168929043,-0.9898884340552665,-0.12644053674583464},
{-0.17108359607821808,-0.936279191091738,-0.30677626942373826},
{-0.2581654273964591,-0.8816634179673736,-0.39499396136560355},
{0.13566996699209574,-0.8476800286563232,-0.5128666776790815},
{0.1017523303272574,-0.9397578581323712,-0.326345876872117},
{-0.029796844355050704,-0.9994511741925524,0.01447406202865624},
{-0.07738070501532378,-0.9728886486781726,0.21794472639752202},
{-0.2479519393367854,-0.9678191156569014,0.04296504565598186},
{-0.30723099914565766,-0.7764374290793986,-0.5502308896168362},
{0.7200615116022228,-0.31583942496471934,-0.617864772540948},
{0.8256079058278346,0.16435386651156064,-0.5397771692071437},
{0.7995794332175948,0.533860609449492,-0.27507377129353283},
{0.63341453521971,0.7680449988175213,0.09430220762947471},
{0.3938041773631776,0.8719415493219312,0.2909230215321247},
{-0.6181943876308895,0.19344078495000333,-0.7618506164725444},
{-0.43956212737089556,0.2626190591965902,-0.8589623774810341},
{-0.39190270586211934,0.44482960379816994,-0.8053191247714862},
{-0.2680025808130451,0.45725081375843346,-0.8479954657866972},
{-0.2887284140255755,0.23885421160277487,-0.9271378368580869},
{-0.3149892381210301,0.1533606870852595,-0.9366228053622601},
{-0.3082997194110237,0.43850929254927096,-0.8441924445048191},
{-0.4088839082831352,0.5653276356323128,-0.7163927790936252},
{-0.30014270220450534,0.5699904533881072,-0.7648694276540263},
{-0.23724767415833173,0.35579570342777866,-0.9039485375444745},
{-0.36330709525322413,0.43545283667396584,-0.8236436010625356},
{-0.3950556066397452,0.6683439883404756,-0.6302756388372067},
{-0.5176990792743508,0.6097028061942938,-0.6002084233308399},
{-0.6135892347162505,0.5902955320358604,-0.5244610909293718},
{-0.6658963464611166,0.6087461086132621,-0.431289034196265},
{-0.7880880632406374,0.5531202410132796,-0.27013922995195017},
{-0.7821054859017738,0.5764069920184463,-0.23678257637460814},
{-0.810774561945628,0.5558777661390139,-0.18342442262189276},
{-0.873374741234436,0.4776352964388055,-0.09529472687140733},
{-0.9257539785181649,0.37255222630755275,0.06468701516591246},
{-0.9468235609320228,0.28061306313369916,0.1574212605168906},
{-0.9534839357029092,0.2223721968921799,0.20351656051986564},
{0.2656147762615726,-0.273149702924243,0.9245745131810159},
{0.24385036256656478,-0.3342986318980764,0.9103743325617376},
{0.406472719827802,-0.35954767603317683,0.8399436866212704},
{0.38054446580679796,-0.32676250524929656,0.8651081867067391},
{0.4029232303062784,-0.26736499835629607,0.8753107037695195},
{0.28976051179580004,-0.26357198991089575,0.9200916540966159},
{0.5673018863650353,-0.27259786577115375,0.777083633403564},
{0.8272136702182756,-0.23619365869319175,0.5098334035713371},
{0.5606509095577216,-0.2315038057576233,0.7950324179125252},
{-0.13281594981967212,-0.043405435227721154,0.9901898260768945},
{-0.4127698996080629,-0.40054351338163474,0.8180378376734452},
{-0.4788508861872394,-0.6209329248355306,0.6205998160271148},
{-0.11023927566468356,-0.8034100276308622,0.5851321471284098},
{-0.030130344277592237,-0.8956104504459542,0.44381762403684333},
{0.16000954172110265,-0.9465234364056018,0.28016125872992015},
{0.03266599842919755,-0.9875771746977511,0.15370184306842685},
{-0.09168696691177582,-0.9902724265333406,-0.10466146065428575},
{-0.2491486247360001,-0.9318905607114735,-0.2636379063204217},
{-0.2507758861723036,-0.9215244431469648,-0.29648634976533444},
{-0.1923752276778616,-0.9432331413638638,-0.2707452913879545},
{-0.24410782889365476,-0.9190957047002003,-0.3093128731146969},
{-0.5106093361484282,-0.7740010638095773,-0.3744335175431069},
{0.8152951964275892,-0.4848122729289143,0.3166240715732121},
{-0.028004708846838686,0.44823294920711665,-0.8934780128953898},
{0.0839655130472726,0.5399998020219254,-0.837466421079072},
{0.23915625386853034,0.14879584175270238,-0.9595124197803152},
{0.42440206030954447,-0.7964484544451719,0.4307583436416649},
{-0.26572729273249296,-0.7343150370237812,0.6246362399811772},
{-0.5554379852472053,-0.5676370795142557,0.6076814877096814},
{-0.5359627846379437,-0.6461969836964132,0.5432985843390342},
{-0.5782619558726697,0.6049788720382725,0.547369778831106},
{-0.3469937460613757,0.6885928491866926,0.6367379588521846},
{-0.16739387574680759,0.7362625275039746,0.6556651439232694},
{0.00847297699175542,0.6825683904369799,0.7307726055601481},
{-0.06388793975873547,0.6682862897579644,0.7411556962439931},
{0.02247071443758496,0.8452656869368075,0.5338735669425031},
{-0.34286837905286194,0.8893262605990399,0.3025559069900826},
{-0.3608404925227622,0.8533822749210904,0.37620849512794735},
{-0.297029042481142,0.8772935505326764,0.37700102667831875},
{-0.2275583642343589,0.9431893128115344,0.24209731734384898},
{-0.1514836953572451,0.9882387375768574,-0.02090185621930596},
{-0.4459577372277087,0.6738827176037855,-0.589070267049423},
{-0.8205583226275823,0.509235680596786,-0.25954394767309963},
{-0.9573709736718368,0.2883487687438823,0.017199021324665033},
{-0.9401567071505784,0.23333567291466561,0.24831397412397418},
{-0.9885055302448678,0.12735117547510424,0.08147695858598214},
{-0.7668843925449238,0.6129527986714234,-0.19020303644230468},
{-0.6756152928795354,0.727356285857375,-0.12040269702570769},
{-0.9892804067949047,-0.08493912945180074,-0.11878392576303494},
{-0.9868273150405579,0.005647850633674425,0.16167854549402372},
{-0.8820829410699792,0.39945550806093494,0.24972981830994143},
{-0.8861255653052572,0.4425683954155429,0.13753071617551543},
{-0.8608334821772511,0.28805217320131,0.41951360106269614},
{-0.6727131700709699,0.6476781661126157,0.357728925240978},
{-0.6562187377885497,0.7002552076048782,0.28110427317536746},
{-0.7766379125669483,0.49312094776385906,0.39200163729266035},
{-0.9310381002447875,0.02841999785471139,0.36381363307951414},
{-0.08200031686791079,-0.996287823149209,0.02620155488081718},
{0.17478804319611116,-0.9668052127032118,-0.1863781656889338},
{0.21591251034917144,-0.9568394572759024,-0.19452516771532574},
{0.12498563979694488,-0.9747304617795066,-0.18514620364365594},
{0.04835310760882134,-0.9876327847993344,-0.1491424130624191},
{-0.02719719289152034,-0.9824087926851548,-0.18475193301754095},
{-0.12801986603363288,-0.9679580453594766,-0.21602809151726513},
{-0.051317908186839,-0.9604165686136698,-0.2738000858868955},
{0.02453417038655286,-0.9718751945064789,-0.234215031085619},
{-0.7994347392668685,0.33516373902305174,0.4985673131056647},
{-0.7820346415654331,0.2642050654313874,0.5644621358355413},
{-0.9035461861006185,-0.04461317028576238,0.42616188780800196},
{-0.8730047038525457,-0.47629357649306003,0.10491528031120383},
{-0.3178966111114205,-0.9157097019948102,-0.24579968738070115},
{0.07672744407469465,-0.9040634261209964,-0.42045477863395725},
{-0.37171797009957597,-0.8243322603314623,-0.4269684710629966},
{-0.7057322766061083,-0.5777643087462733,-0.4100370194205646},
{-0.7033194741663936,-0.6583602483144616,-0.2681482811759717},
{-0.8223922001167584,-0.17442419753631838,-0.5415231006161502},
{-0.5299065222932228,-0.23254844267135272,-0.8155490785000193},
{-0.32309566953836594,-0.8398570379433564,-0.4361758179250271},
{-0.21985152755963913,-0.9383969599789312,-0.266601671660163},
{-0.12927715884277566,-0.9915846024550792,-0.006884212049498041},
{-0.16072928214548513,-0.9868023359418034,0.019678608710907316},
{-0.19865390287740223,-0.9800684988225208,0.001537688962820937},
{0.7700316928477154,-0.11299809748201006,0.6279192798246664},
{-0.40222483118101016,0.2731175330451063,-0.8738546780356349},
{-0.24864323746919836,0.4016742541909194,-0.8813820590305911},
{-0.2517349450258563,0.21261973388245106,-0.9441516648381153},
{-0.3346394057344275,0.08969079547017017,-0.938068243433087},
{-0.2809611576784474,-0.07547816147076383,-0.9567465050978655},
{0.030496665182345367,-0.27197806343219305,-0.9618200904662108},
{0.06067232177586896,-0.24884109409280986,-0.9666421153979474},
{-0.34629547319785614,0.04000627023116939,-0.9372720755388285},
{-0.21521763221896248,0.1360208536181281,-0.967046895534575},
{0.11139372556289394,0.06934850724266411,-0.9913537322512246},
{-0.203726795558241,0.2541518021527301,-0.945464041745687},
{0.0402848472508619,0.40301306371223666,-0.9143071702438144},
{0.14864806536321815,0.6272747148435099,-0.7644803364258402},
{0.16119102567422072,0.8334643065613634,-0.5285401620787946},
{-0.526589580495103,-0.3168103930566079,-0.7888818597010004},
{-0.47639584750768865,-0.649690328163755,-0.59240988679115},
{-0.13215051152751892,-0.9639051042087807,-0.23113457634736237},
{0.17870880182056983,-0.9278313068692858,-0.3274022451741732},
{0.8062104402265473,-0.5891779742845539,-0.05379628879082797},
{0.7393787976200609,-0.13579998010322517,0.6594523174831344},
{-0.6463536743306209,-0.758687736886647,-0.08136243345133987},
{-0.6697163161888094,-0.38468049628566725,-0.6352172633106751},
{-0.22161892745147543,-0.03738074063993587,-0.9744166107084113},
{0.5264058002185594,0.28697388189112366,-0.8003392559462502},
{0.8244516392494116,0.406560839508991,-0.3936848718413021},
{0.945126819617782,0.31001543913083834,-0.10308114444305523},
{0.9677328709542622,0.1479546480901037,-0.20396693992692772},
{0.8878828802016551,0.09848738763700715,-0.4494043007373778},
{0.8203122123170268,0.07897004003399272,-0.5664376462600054},
{0.5954446472681794,0.8025289219538226,-0.03732293486998116},
{0.3340901821769697,0.9409053594253611,0.05550544817935784},
{0.5557769618897537,0.8238895442315338,0.11098642952429245},
{0.9734504222018414,0.20269590677524305,-0.1063421125030841},
{0.2768058854050813,-0.3417843875798413,-0.898087932338355},
{-0.11656340403631489,-0.99084225455607,0.06815129804861471},
{0.13709617507098518,-0.9863953996378874,-0.09071248179891335},
{0.1412956560065214,-0.9852128976479462,-0.0969076049741418},
{0.28577635247886846,-0.9423929882899303,-0.17386009313769715},
{0.18510164182004316,-0.9680790163736342,-0.16899822559003716},
{0.1289546397904879,-0.980561806507413,-0.14788253614076402},
{0.08332401328459213,-0.9822785926970434,-0.16788649480903797},
{0.05338332370205193,-0.9887561416865089,-0.13968361760682596},
{-0.09905963422034145,-0.9913877695060349,-0.08565908791238314},
{-0.19665729200822463,-0.9792720579391743,-0.048498928231108365},
{-0.03633810271804901,-0.9962791124434266,-0.07815031925584602},
{-0.08076357897646737,-0.9834247385949539,-0.16233615687935463},
{-0.08681604015252203,-0.9687036759531069,-0.23254282050231884},
{-0.32059675441952384,-0.9445054453812454,-0.07160436230316486},
{-0.39074572831983584,-0.909181262935143,-0.14389998932404183},
{-0.2702635160661045,-0.934897532272719,-0.23005268099712903},
{0.04575396382540809,-0.9864592922562508,-0.15749488726799932},
{-0.1023068257019798,-0.9795635683909224,-0.17317196336597798},
{-0.11035008522623294,-0.8734753168095624,-0.47419798567159455},
{-0.3843338209942495,-0.03767162729842334,-0.9224252612199261},
{-0.15387747950988792,-0.17464806789679138,-0.9725326594411119},
{-0.16669792646792156,-0.09490532787091492,-0.9814299669630072},
{-0.13502694880229454,0.1380235957230409,-0.9811815378006382},
{0.008023564623303796,0.07628924254656953,-0.9970534458505252},
{-0.15470357889595124,-0.12276355792725425,-0.9803039893430128},
{-0.013465313910792547,0.10940868317456426,-0.9939056420844443},
{-0.0878808063024847,0.3085586383660841,-0.9471370178455139},
{-0.2969056687540554,0.2831385381909981,-0.911964687941793},
{-0.020996795347363068,0.2476725379260084,-0.9686162545313964},
{-0.11173316246573417,0.19737720236222442,-0.9739393925666359},
{-0.2656985763336164,0.2965861526015066,-0.9173008888142022},
{-0.35567913317424826,0.36426952167926807,-0.8606974322024974},
{-0.11015079394097894,0.4268926286838898,-0.897568652621921},
{-0.10437241830807607,0.34263193992045893,-0.9336539787538353},
{-0.1759243190229712,0.13910317319362547,-0.9745260084696397},
{-0.03261643495920213,0.470531234725803,-0.8817803157918436},
{-0.1939282834723276,0.6300488577111788,-0.7519509676610008},
{-0.0870630841522325,0.5220639321231036,-0.8484511006263501},
{-0.011495022506510553,0.43351198402138497,-0.9010744831407762},
{-0.20683157113668402,0.5938492439909976,-0.7775369937131296},
{-0.3020709472588754,0.6169904552980794,-0.7266883244508572},
{-0.5003239903659573,0.5648602936845478,-0.6562078582910235},
{-0.48179775882446874,0.6812890660941727,-0.5511044619781709},
{-0.45321877015830464,0.6490398811243379,-0.611015530969794},
{-0.583295433005786,0.6440739760366692,-0.4949092353421066},
{-0.6750929332503173,0.6455960757124196,-0.35700873728832794},
{-0.692973521021773,0.643171114472349,-0.3257585250934852},
{-0.7136018918558867,0.6376311260179817,-0.29017044486429006},
{-0.7585267330209213,0.5933731380457298,-0.269342745100683},
{-0.806438067190691,0.5404508904020683,-0.23993848972049922},
{-0.911319022134364,0.4052695468226953,-0.07248609738559578},
{-0.9459871467757502,0.2956973703855542,0.13293375523975684},
{-0.9442700683233374,0.28451023977686063,0.16555350050890755},
{-0.9415206301023797,0.19389495800032802,0.27557875163674894},
{-0.9007711842426271,0.12820435804879807,0.41493965370331953},
{-0.8766194308797046,0.1009990606212357,0.47046526243472053},
{-0.8041775348308962,-0.030164471122010462,0.5936232788185046},
{-0.5633249757664812,-0.14500773270075606,0.8134111685578698},
{-0.6414998636661683,0.0011753948387586794,0.7671222479913227},
{-0.41157977770982274,-0.2582583507578237,0.8740164248137342},
{-0.41703758048450634,-0.2818511989835853,0.8640830736075926},
{-0.4501491042139498,-0.035377335362028604,0.8922523343304074},
{-0.5083940925253664,0.2033601208310195,0.836767654693286},
{-0.5089390477695966,0.4146054832510509,0.7543761256253665},
{-0.6065006681761755,0.5785378215669539,0.5453906201232435},
{-0.2956056008202437,0.834871769653175,0.464334423664538},
{-0.24094724021397068,0.9260529843192596,0.2904656566044671},
{-0.4467777304219641,-0.033121445631772085,-0.8940316713843309},
{-0.33522868618522006,-0.36263432796579737,-0.8695505000512196},
{-0.26538221213306473,-0.05722319498603938,-0.9624436541631675},
{-0.2927442778038642,-0.5668282949193711,-0.7700691344885161},
{-0.4222015546484821,-0.3094472023860659,-0.8520494564213054},
{-0.277130527876368,-0.20119796353900693,-0.9395307605324703},
{-0.2748593687701202,-0.2691027069564525,-0.9230579941195465},
{-0.28526270659881575,-0.46467139642256816,-0.8382754210703177},
{-0.55539271452378,-0.4159004821386373,-0.7201150752558622},
{-0.5999660543823494,-0.3576327545618865,-0.7156392572052999},
{-0.5047587061660688,-0.5255848329304587,-0.6848205837611908},
{-0.22413725314255234,-0.7780343646095942,-0.5868773459933997},
{-0.07774382381759712,-0.6118420659497428,-0.7871500391873008},
{0.32856144970311874,-0.6759133481286559,-0.6596881987655195},
{0.9414102145874301,0.16164957664149246,0.2960003754086721},
{0.911922576082771,0.23687556061266818,0.33509279910943585},
{0.5784842017435897,-0.3857855924812322,0.7186970884642476},
{0.2431761972045839,-0.8704294435957791,0.42803962530898904},
{0.7440380974560987,-0.6672230779197524,0.034938142841324675},
{0.5803684800711084,-0.7573321429783575,0.2993667525824471},
{0.2052085522737982,-0.7700072807526676,0.6041342877718284},
{-0.1726843688348621,-0.9035830706587319,0.39206854398056784},
{-0.4544502958589307,-0.8581334977512374,0.2389180374751091},
{-0.5926607988409499,-0.8031608483537368,0.06071103020796954},
{-0.3668656252991199,-0.8730096946859397,-0.3213466756608013},
{-0.11826574130406076,-0.3618727236468492,-0.9246952721379147},
{0.7349057803586887,0.0704961829990717,-0.6744952054521576},
{0.8817801462142955,0.2927182384751589,-0.3698375408288025},
{0.9558285780560898,0.21738803744976695,-0.19782358440037498},
{0.9645343511200845,0.2485466937870223,0.08887084176994103},
{0.9874039228864964,0.15792386363077485,0.009671936945946499},
{0.9886871294028791,0.017203270897456876,-0.14900271012140465},
{0.9710701176140004,-0.047648917501045336,-0.23399232324610564},
{0.9411278056454622,-0.06793806610133524,-0.33115385037074213},
{0.9114375073272166,-0.3364013005941784,0.2368878114122701},
{0.9296486556034651,0.35313298014158623,0.10512124176869231},
{0.8274425726527445,0.3617877977616564,0.42947453749038317},
{0.2256156092308497,0.9029305398683728,0.3658060101261342},
{0.20972346541509418,0.9137420468204568,0.34798209713524914},
{0.41584230254078225,0.8684620913862683,0.26990512266826183},
{0.6478347841850208,0.7575292910909109,0.08037080028996357},
{0.6749081157510273,0.7325626690856952,-0.08860570611106468},
{0.44347320842003557,0.8860400631523756,-0.1351462907466348},
{0.148158383578367,0.9884751438270635,0.03108027367176086},
{0.12526187689104276,0.9803242520504994,-0.15255760564246532},
{0.1657695306350842,0.9820890868499275,-0.0895627612532091},
{0.1616162424992085,0.985288809303242,-0.055553149525806596},
{0.061277173950155014,0.9937473916880579,-0.09333396737449919},
{-0.004404177878648081,0.9865523817269369,-0.16338604997404585},
{-0.3734672399521776,0.9276402797464438,-0.002394175106813323},
{-0.6199703214566609,0.7824088191599821,0.05893420240918824},
{-0.43345865017282553,-0.9011265347792908,0.009196026697412703},
{-0.3204068131443188,-0.9312129862550708,-0.17372923853115493},
{-0.3234956553235456,-0.9416792251956414,-0.09268655685549111},
{-0.5642931864181314,-0.813200252511971,0.14240277060696097},
{-0.48772625950508747,-0.5229424217143026,-0.6990381387025721},
{-0.47454605845324604,-0.46032185332797293,-0.7502731700888607},
{-0.5115334265014172,-0.4111312253977371,-0.7545228088498547},
{-0.5620157476736108,-0.3222522078998223,-0.7617688716865252},
{-0.4291040433673088,-0.36852929841407983,-0.824655004335906},
{-0.353528490887564,-0.3023277867903311,-0.8852206027116752},
{-0.05083870103056977,-0.38587114413559376,-0.9211508489932646},
{0.233759995529855,-0.5198916883420196,-0.8216257644954706},
{0.20996720385758091,-0.4019187958556005,-0.8912772042648758},
{-0.31574989468218295,0.8680485448146652,0.3831366960411549},
{0.03215998196971491,0.8885061875395975,0.4577362671490615},
{0.27274680613287144,0.7684007436687514,0.5789382323474825},
{0.43201967122296514,0.6302514790764154,0.6450907508237828},
{0.2242788429481281,0.6368626642068483,0.737634697899444},
{0.40036560942140853,0.5628343203629482,0.7231354690610898},
{0.526758275305624,0.7547600161303836,0.390977029309789},
{0.12756040639486577,0.9811402825482978,0.14523115602866749},
{-0.11969160345749164,0.9575109188192098,0.26238666201574967},
{-0.40267328904847866,0.8721880427780081,0.27774491952499825},
{-0.37917568923447487,0.9003527641054516,0.21351978096006477},
{-0.4961677886221083,0.812340984271735,0.30646313123486113},
{-0.4221261348371149,0.8625491277329247,0.2789597256498664},
{-0.5679057671171776,0.8099666817423216,-0.14641384545999453},
{-0.5081074462991141,0.6083675311880115,-0.6096849760422152},
{-0.4483876013919564,0.502154592425089,-0.7394520432214389},
{-0.521575414908808,0.46271196410912147,-0.7168380045958667},
{-0.6136456986190789,0.5426107610010533,-0.573596128484285},
{-0.7751383402345441,0.43438349022129574,-0.45877176997021235},
{-0.8657289965011319,-0.052112050442735376,-0.4977927669380071},
{-0.9668569783760866,-0.25086833735900155,-0.04746220260579611},
{-0.8718575672660441,-0.4856605098089853,-0.06323172947984063},
{-0.2500174390615127,-0.9487229536728384,-0.1934322551680771},
{-0.5202059819214613,-0.8341799812081702,0.18311060953605343},
{-0.5831438094470779,-0.7441808659357657,0.3257884839564529},
{-0.5820572131607105,-0.7767083141595651,0.24069398688582494},
{-0.4796282377359441,-0.8727692196641662,0.09072289001743258},
{-0.30466043659708303,-0.8889191558381502,-0.3420595748644747},
{-0.4543549892275407,-0.7758091141324404,-0.43781475785208485},
{0.15013600859019405,-0.47422830917388764,-0.8675060170988332},
{0.19138718795273932,0.07488255464747016,-0.978653946651732},
{0.4444467738229303,0.5827450079512467,-0.6803494109252176},
{0.3990489781824763,0.7506101650732931,-0.5266348764563216},
{0.5074438965430229,0.630750285566014,-0.5870730526260134},
{0.22352486375825115,0.49732893845056003,-0.8382723675879424},
{0.4128326845965518,0.7150360019373023,-0.5641743440305684},
{0.4887986041329875,0.7016611129169126,-0.5184087260240154},
{0.5515710818524012,0.6874202474907458,-0.47246454364738705},
{0.31735022712504074,0.9455350362971198,0.07247294997645402},
{0.6795800400305196,0.7262967275127995,0.10326680394161251},
{0.7630889465444592,-0.5504379248560399,0.3386935938895863},
{0.9649452890246495,-0.22041068114574972,-0.14247708877571214},
{0.2130131706790667,-0.9546874036606273,0.20783972288516328},
{-0.09536603187683976,-0.9457143929318614,0.3106921417828045},
{-0.8647628380626692,0.31535004424918367,0.39081911864420815},
{-0.9277229074625606,0.2830693470468745,0.24331451196274617},
{-0.8545868169317518,0.2846679942811772,0.434333403456824},
{-0.9219435688693883,0.15295877305913236,0.35584219756040786},
{-0.6525337074604648,0.522516694832975,-0.5487951022455687},
{-0.7307968878148458,0.6071755638924968,-0.3118873889274208},
{-0.7429389479719766,0.6262455760407165,-0.23634339016719652},
{-0.7306091199410719,0.66790203916285,0.14183504482686715},
{-0.6567376819969278,0.6885840348428358,0.30748600619355454},
{-0.5950545507074505,0.679282517224558,0.42951757062479073},
{-0.5591328428930521,0.6442059847032066,0.5218899436384126},
{-0.3910350454853182,0.537181586632608,0.7473469985121831},
{-0.2283773701522412,0.38519454337684456,0.8941302704612177},
{-0.11558677083686701,0.24264892625723516,0.9632036113894696},
{0.18370880453257707,0.023519191445708985,0.9826993043504973},
{0.12381324082809583,-0.07447129296541008,0.9895071035215988},
{0.22765138644455815,-0.17067786648592245,0.958667779859991},
{0.45495465331150703,-0.29732783012971964,0.8394119518213682},
{0.4836144652385065,-0.3229668929898257,0.8135167085220634},
{-0.9717298470426932,0.1585697686621965,0.1749192180202095},
{-0.7709648066890978,0.6228230984354762,0.13305883999973434},
{-0.9770084126054557,0.08080286273676136,-0.19729535998525527},
{-0.9110147212693962,-0.3928462342950369,-0.12539542986350533},
{-0.8680494195653183,-0.3013976599936294,-0.394524594597952},
{-0.7938029644910589,0.44225468546554664,-0.41747772006297174},
{-0.582047709144025,0.8007094475666231,-0.14172101064325607},
{-0.46680800680556495,0.86540253571826,0.1821228595059423},
{-0.6426374246945749,0.7038052530871638,0.30277930264276326},
{-0.9456390605711439,0.042030261575476464,0.32249065759184653},
{-0.9320764536723225,-0.35468970580931136,0.07367969260611153},
{-0.7952675246533191,-0.5992963656689281,-0.09161566638843449},
{-0.739417201253215,-0.21578372623167946,-0.6377300259392169},
{-0.5860052906748585,0.6573216071811603,-0.4738418555107295},
{-0.40967177807214605,0.8960843881105206,-0.1708853523149371},
{-0.43596407913046537,0.8976882626814942,0.06396174443998676},
{-0.46584334749369655,0.840397394936016,0.27698771485505463},
{-0.4854304216687347,0.8444899982519335,0.22626079768922336},
{-0.7077140607399219,0.6957825382577537,0.12258657221167299},
{-0.7832616196264532,0.5189599392717623,0.3423182972778319},
{-0.8670870514576303,0.2714076458920903,0.41772949973137685},
{-0.03359078000332383,-0.8681124464328305,-0.4952296839317837},
{-0.21868736254202076,-0.8953841619952115,-0.38789565595988224},
{-0.37906998650972173,-0.9105542718262344,-0.16491471549414594},
{-0.24436119006956242,-0.925862052813642,0.28821358043557954},
{-0.29946953611287963,-0.9275552802505419,0.2235155453646914},
{-0.6297076493598028,-0.7587610724567475,-0.1665830461422708},
{-0.8139435610087424,-0.29266204683543817,-0.5018414150252043},
{-0.4303930739126521,-0.15593984088724022,-0.8890694955694299},
{-0.3429505161044404,-0.32115334142569785,-0.8827488174983906},
{-0.5863956932439061,-0.637066735278635,-0.5002859839595952},
{-0.6928162299073761,-0.5989367529002221,-0.4015973575638518},
{-0.6381252926186917,-0.5931027165293152,-0.49094325391622995},
{-0.6062512418684174,-0.37665828180042227,-0.7004198530054352},
{-0.35812845101657054,-0.32592554976077615,-0.8749380255684442},
{-0.19904461941855184,0.019005853525775815,-0.9798061119488286},
{0.2614190118374966,0.5435540895674205,-0.797627138432764},
{0.5259350021311688,0.8179628437218963,-0.23308616394731788},
{0.4694909379490926,0.8818584145230453,-0.043634801690649316},
{0.5277481641387719,0.8422590412353579,0.1099162531450718},
{0.6588907475953985,0.7492591866055222,0.066885379720893},
{0.6817694452441047,0.5162562934248875,-0.5183337371141707},
{0.4982827552441685,0.30669271518057334,-0.8109586144073245},
{0.2515677133599601,0.6713490916170866,-0.6971399305589616},
{0.13470855167873794,0.9125229550818634,-0.38620650247410454},
{-0.02889857593825718,0.998083222060272,-0.05472434696299873},
{-0.44186826415945873,0.8627901023763812,-0.24565356982966988},
{-0.9355894956816442,0.351478699937173,-0.033690043939442055},
{-0.8586193490711822,0.4526236499515622,-0.2406338399001797},
{-0.9100130218326555,0.3688133464165557,-0.18934892553172897},
{-0.9515373007463866,0.2809267609354611,-0.1251276159710195},
{-0.9441880943726363,0.31746767917903945,-0.08788125580375077},
{-0.9390789547794736,0.3278001672355198,-0.10333328142789515},
{-0.8670654825449366,-0.02992832636978954,0.49729442411897146},
{-0.8080770306995754,-0.07745634790577488,0.583962350348768},
{-0.7444517805135571,-0.2007593503405543,0.6367787918430019},
{-0.6199025100823796,-0.25153602942308345,0.7432701419373948},
{-0.6209202690323815,-0.3167332657745192,0.7170342096835846},
{-0.638143660391934,-0.3412549766077662,0.6901577425791997},
{-0.5554358636786576,-0.3428826399997554,0.7575767264946448},
{-0.5921034636429814,-0.36159572709600296,0.7201819342970897},
{-0.5526366008665576,-0.4620766683688601,0.6935978229001238},
{-0.59168333650905,-0.46664107799174237,0.6573864416218385},
{-0.2606683781079791,-0.5630668496429779,0.7842242788180481},
{-0.4454505913698945,-0.6219750981726961,0.6439881581995714},
{-0.31768886581069905,-0.932532368557381,0.1716309008677425},
{-0.4254086010941661,-0.9043758322058255,0.03364336839742969},
{-0.08484255566332469,-0.9961520050782179,0.021975521089650618},
{0.08393079394422953,-0.9964709025547472,0.001167128792700569},
{0.09677100088644064,-0.9912362329241745,-0.08992276644836888},
{0.0953505729212476,-0.9835903270719061,-0.15316114629425695},
{-0.9006054165161667,0.06786384624216132,0.4293068624130787},
{-0.778566406269241,-0.10144024197191617,0.6193094770287938},
{-0.6863936627809287,-0.18417092536710808,0.7035231410149945},
{-0.5479799172294337,-0.3060944572082821,0.7784755574708755},
{-0.43993325650140874,-0.336187611512058,0.8327284189277337},
{-0.3583922696243927,-0.38894563007855276,0.8486909201330448},
{-0.38395854070567176,-0.45581426578376516,0.8030001208761913},
{-0.472749779467991,-0.41797511461685344,0.7757605620125285},
{-0.7168847127617016,-0.1812882289231199,0.6732093928804701},
{-0.7105893622906422,-0.06617297765036652,0.7004883262612321},
{-0.7855677351548361,-0.041026716993808575,0.6174140765939914},
{-0.6808030714381033,0.003942449240554069,0.7324558928798582},
{-0.7603604969908475,0.07951039814970795,0.6446161735497383},
{-0.6277206202317909,0.42529729985726283,0.6519885195844611},
{-0.5551039326529942,0.648288561818595,0.5211348813583273},
{-0.6520394466861698,0.6034364132347111,0.4590305601456403},
{-0.5801011563253637,0.7171192802205025,0.3862933941526884},
{-0.9457888576268528,0.28036977140760405,0.16393970864235585},
{-0.94580473136525,0.10053454129511011,0.30878182610653937},
{-0.9393709119100551,0.09239442856181745,0.3302204709402594},
{-0.893677104882063,0.06619858874340331,0.44380060732044524},
{-0.8767196587299542,0.012300452809167006,0.48084440191929245},
{-0.7868388158270087,-0.08978556826132936,0.6105925234065194},
{-0.6955301901313542,-0.19397045285695597,0.6918187754277196},
{-0.5601129890078195,-0.25676793331139863,0.7876189865459818},
{-0.5564922997577518,-0.2375186580113744,0.7961791302256072},
{-0.5107135103703085,-0.3402252596392463,0.7895685423246319},
{-0.5380783859517942,-0.3708908530927468,0.7569092585400489},
{-0.44959873357769864,-0.4847086245567821,0.750278966815412},
{-0.41177262812675786,-0.5286764641261988,0.7422563566616339},
{-0.49928357897070863,-0.5581202251482149,0.6627350315553767},
{-0.4104191701867905,-0.5520855043193678,0.725780752475302},
{-0.17436711904759447,-0.8563176877161623,0.48612357019536434},
{-0.2315687763213642,-0.9271130517174404,0.2946816776934063},
{-0.1747110107763739,-0.9481654910416676,0.26543975646314016},
{-0.17199585833505943,-0.9670369080384836,0.18776858951101363},
{0.07912338951893533,-0.9498702759759451,0.30246644119375743},
{0.8104124835754593,-0.47975508292275015,0.33625387265404266},
{0.1618092392959552,-0.984198862197545,0.07190528302928813},
{0.8233759345946504,-0.22273914204706627,0.521957225192374},
{0.4237237913589589,-0.8055993476717824,0.4140867537934386},
{0.4818112827899818,-0.46018438132877876,0.7457132310461717},
{0.22947797086617258,-0.45485301318865606,0.860493229072922},
{0.13660686780041972,-0.7721981752038716,0.6205227972295374},
{-0.0006049682283064012,-0.9484639592562935,0.3168844458242132},
{0.041346739701404,-0.8855957889914905,0.46261273829911304},
{-0.08603673382573333,-0.9356607355016001,0.3422523461909421},
{-0.009188884319496922,-0.9999577687582551,0.00015844549497358052},
{0.03546308070019729,-0.9933095738289175,-0.10990204933059933},
{-0.006738604245180762,-0.9247280610929633,-0.38056879041781055},
{-0.10974986475378377,-0.9199247264535662,-0.37642192397077207},
{-0.27721290377501373,-0.7305905314341856,-0.6240116035454301},
{-0.17796845976549003,0.958510769498945,-0.2226753962233805},
{-0.25902197377169545,0.9573099736255359,-0.1283169182161523},
{-0.7403428499816999,0.6644456882084259,-0.10200192107115386},
{-0.9677590578532294,0.173419631107998,0.18266920235605072},
{-0.9462183227699235,-0.00029734290945032774,0.3235286652549773},
{-0.9269473575388897,-0.15037862910741692,0.34373662048062875},
{-0.9506061413602998,0.06739152826993058,0.3029956203074971},
{-0.9529398089203138,0.13324081430556853,0.2723097610775362},
{-0.9084353359443873,0.24302202304264964,0.3401257660393666},
{-0.9280957463124214,0.10288607817931612,0.3578445760294119},
{-0.9449139741643781,0.08335497921545355,0.3165272956142526},
{-0.7970931488945731,0.5478505778588141,-0.2539729440808557},
{-0.6646929897701075,0.6535031950027359,-0.36210054331869174},
{-0.6161100243853339,0.6692940295551468,-0.41527573954390506},
{-0.6882324990406118,0.5803428803580399,-0.4353598149600487},
{0.08830902723027628,0.30794777068253026,-0.9472959866067744},
{0.29313472641180227,0.18099278999370697,-0.9387830644732422},
{0.04626671137199836,0.09664684328263087,-0.9942428169729579},
{-0.0709976349382355,0.179710407993812,-0.9811541698896635},
{-0.17575773623234714,0.1694952663445154,-0.9697322170791699},
{-0.24459055212513534,0.27747222763229323,-0.9290772974860027},
{-0.3006535670693355,0.22215830811629508,-0.9274983119895097},
{-0.1822296190344068,0.05061336320044003,-0.9819524700371782},
{-0.13650674649159364,0.07958607970256448,-0.9874370684149227},
{-0.26459578531506855,0.15072683842056445,-0.9525074753371982},
{-0.42697414764929903,0.2780925217909225,-0.8604403678135515},
{-0.5883199520649305,0.4388308442798028,-0.6791959394099714},
{-0.6864137643499322,0.5529368817358895,-0.4723313973548093},
{-0.6947809658780857,0.5477148343134136,-0.46614146964901554},
{-0.7418958033450489,0.6493684420542651,-0.16706658386110873},
{-0.7573998148822411,0.6529444817697896,0.003004021093116716},
{-0.6789972099015866,0.6534650804503346,0.33458358832718993},
{-0.5524759871319727,0.6543168008731928,0.5163717727932297},
{-0.4614860115114808,0.6247445907504894,0.6298609826836625},
{-0.2749872746831119,0.48197784061293747,0.8319130723341499},
{-0.09076600014179897,0.3795486022848182,0.9207086356290461},
{-0.04382495837587723,0.2873009025032779,0.9568372716633454},
{0.14006828646417568,0.15966147791918037,0.9771842649140705},
{0.2575631977186668,0.098226085289878,0.9612558636229798},
{0.3206921752058386,-0.006585220164400755,0.9471605796469436},
{0.2764651570648788,-0.07080092580584904,0.9584123568872255},
{0.45109101072461616,-0.19327752745004442,0.8712982826944178},
{0.6244279461391647,-0.3190578860987445,0.7129458642832743},
{0.5932291896367605,-0.32258297638398387,0.737576675275298},
{0.4598450310676496,-0.37440736429556964,0.8052090864884952},
{-0.08125709054541994,-0.8608552693127305,-0.5023201076331705},
{-0.2787705827030541,-0.8566265628834294,-0.4341404081422526},
{-0.48839419300003856,-0.8170029962639332,-0.30655703603015927},
{-0.5383263830127202,-0.8328229734605046,0.12888211756813234},
{-0.530690729519614,-0.7883133704436848,0.3113348351560707},
{-0.7363385452484,-0.6765231244848712,0.011045760213656792},
{-0.4713074776810775,-0.4963913221303536,-0.7290164036532925},
{-0.2954279041455212,-0.8049571605656385,-0.5145544899291908},
{-0.689026334521889,-0.6088343617334484,-0.39314555867764095},
{-0.7855264660195889,-0.3269088976292966,-0.5254319592807175},
{-0.14194923990419672,-0.22344709675127936,-0.9643245347102009},
{0.18275350444080846,-0.32865697645236913,-0.9265990224707721},
{-0.06931100347582983,-0.5141298019433612,-0.8549073233695297},
{-0.4712943386661638,-0.7521559137001327,-0.4605899779925111},
{-0.6358763801129431,-0.7057884851360893,-0.31228807768431416},
{-0.6422048749672564,-0.6987619883704135,-0.3151262955973631},
{-0.5112929151315682,-0.687884307877873,-0.5151647638490452},
{-0.4147409078273205,-0.5772442454259513,-0.703405331581439},
{0.22049226430539431,0.8535185596243325,-0.4721114590414905},
{0.003937965581020046,0.9695519157084613,-0.24485419165931255},
{0.026734600243510338,0.9260989813975152,-0.37633221733503575},
{-0.44030481941299165,0.8099742988423075,-0.3873929545262861},
{-0.6151947789573109,0.760820943076028,-0.20660802627334804},
{-0.912764441434251,-0.1946597635220196,-0.35912205573978795},
{-0.958058895250882,-0.13189958803407892,-0.254412365869075},
{-0.8632217511154353,0.1676393279747088,0.47617776524885047},
{-0.8262941322488302,0.02051948858258464,0.5628649550287014},
{-0.8450821377804832,-0.10689902538159744,0.5238404134627577},
{-0.888485600713961,0.07442158408953002,0.45282973085427697},
{-0.9251629763750184,0.1641963092866091,0.3422178241435904},
{-0.9393623795845913,0.13363145027875858,0.31581791481416926},
{0.4271227347774573,0.17427533816614088,-0.8872396947518202},
{0.025493378868349206,0.12177294600053902,-0.9922305363453721},
{0.05741753575610522,0.08523736563256323,-0.9947048899486305},
{0.09361632598845468,0.09734488259199928,-0.9908380076185881},
{0.4123721719807949,-0.2923120688251395,-0.8628457835528947},
{-0.09345111141328546,-0.008591483757684133,-0.9955867999237752},
{-0.294309065759074,0.2414688270080902,-0.9247026437700706},
{-0.44166269136833874,0.23824089061392265,-0.8649712972652678},
{-0.5316201821028564,0.26723237488301615,-0.8037206229749918},
{-0.37078671037453065,0.13761030879872652,-0.918466449208654},
{-0.26537678123182784,0.06368317130022805,-0.9620393015236854},
{-0.2544984377226716,0.10065502776680046,-0.9618207268415379},
{-0.16567541981419875,-0.8716815284391868,-0.4612190024785539},
{-0.12081694643958775,-0.861280911245712,-0.4935569444114524},
{-0.057360945183813024,-0.7637051483854249,-0.6430117948352236},
{-0.1007140279677826,-0.731342048987258,-0.6745335365670292},
{-0.16432781720223508,-0.6756462693466684,-0.718678291874381},
{-0.1711898259940704,-0.47090779803732435,-0.865413132107295},
{-0.2624403380629489,-0.4949617868654238,-0.8283344122396413},
{-0.17921135923180032,-0.5524983353640928,-0.8140201951685212},
{-0.24084813506689787,-0.491863750080824,-0.8366972135672653},
{-0.11031548369237848,-0.3032108594215954,-0.9465165972060575},
{-0.08693304509386342,-0.3293715048651346,-0.9401899049945096},
{-0.14285574201967893,-0.3327714464695287,-0.9321241341079977},
{-0.0634639393231166,-0.04607524335489053,-0.9969199568447706},
{-0.17444167179215606,0.02820410986487474,-0.9842634968996299},
{0.002133614709711942,0.013595612198249169,-0.9999052990244752},
{0.13204089216487924,-0.12179820392989513,-0.9837328907359733},
{-0.030534905372150097,-0.24244496509076602,-0.9696845149099015},
{0.0375751975419968,0.04263239115991159,-0.9983839861264142},
{0.15670149946722914,0.17827888555039734,-0.9714222969603026},
{0.28378617709871773,0.05676250287076393,-0.9572060509396823},
{0.17355224704580482,-0.12063304734718092,-0.9774084537352257},
{-0.07871201929515026,-0.9921116555257504,-0.09756475279748497},
{0.044263361736820925,-0.9855523201816248,-0.16348510327357527},
{0.745121073928912,-0.3683660867900544,0.5559685344423795},
{-0.022669144613038893,-0.45079591843548095,0.8923391450588863},
{0.3449075150177317,-0.9298630411286561,-0.12803722438127277},
{0.6865918975221188,-0.34816094906687683,0.6382597588770798},
{-0.06696951719640118,-0.228126183882035,0.9713256549653678},
{-0.1569446754860299,-0.8406006140576632,0.5184196914493742},
{-0.15954104484422085,-0.7793654568115986,0.6059176014433503},
{-0.11094752293647447,-0.865380097940063,0.4886797859984669},
{-0.1385317502915741,-0.9485058895525023,0.28486054771654357},
{-0.19714489390791032,-0.9718948417988812,0.12866354297455973},
{-0.13922423043511442,-0.9552617383209502,0.2609437199086931},
{-0.2494345696219629,-0.9562226702501081,0.15303790503420714},
{-0.22988781752739038,-0.9727921609399877,-0.02875765926153096},
{0.0550369193872299,-0.9984145731483484,-0.011801594356896325},
{0.17500448657739118,-0.9656311505763651,-0.19217156583206876},
{0.3011485737728241,-0.8978907048838558,-0.32109471904372106},
{0.18232981413728874,-0.9310514201989945,-0.3160681759084538},
{0.09223895810823039,-0.784700387207266,-0.6129741241878607},
{-0.12048143711661256,-0.7737860946992605,-0.6218836731739971},
{-0.23205334310783296,-0.7231707145325604,-0.6505193030148639},
{-0.37872893892986004,-0.5040239374129636,-0.7762243627533184},
{-0.41692714490466404,-0.36835295428468817,-0.8309559897560084},
{-0.40268566077307916,-0.31401831664521285,-0.8597887853531562},
{-0.3813434539080989,-0.2267326854837051,-0.8961972213161503},
{-0.35401106816916417,-0.19411604466034055,-0.9148743765234395},
{-0.15562537540231186,-0.1315901991029237,-0.9790121357934959},
{0.1918886364847595,-0.37612863445067335,-0.9064800061414987},
{0.23716647762867732,-0.21608898201183865,-0.9471312547594939},
{0.22374779395026576,-0.049752442558635354,-0.973376401584628},
{0.20681089076408626,0.8943919284592234,-0.3966009755010145},
{-0.14054304549705046,0.9526174279423498,-0.2697548671348043},
{-0.0093983333880467,0.935096008828486,-0.3542698485654166},
{0.20769948534606508,0.8658702275381287,-0.4551150105743039},
{0.2844283411431513,0.8451573083489518,-0.452558993832749},
{0.04282113287531344,0.8846595039146011,-0.46426707045928495},
{-0.9130873777607209,-0.022385202251021794,0.4071490430962981},
{-0.8375250674622327,-0.07282188651042804,0.5415244539422434},
{-0.6469867489703404,-0.17063932834564013,0.743162409086021},
{-0.6117114091798003,-0.21042009715838855,0.7625828050717623},
{-0.5467156792090646,-0.2514184567608328,0.7986806155823317},
{-0.4514319945181525,-0.2898301596480082,0.8439239497038656},
{-0.47143969212024467,-0.24674301792095915,0.8466773292115635},
{-0.4631424948906348,-0.27808922852041823,0.8415256445334253},
{-0.30475953852476373,-0.3987456322953856,0.8649413531584242},
{-0.27155688666394584,-0.46417954364073777,0.8430861216808526},
{-0.36428701565981486,-0.45330542833386955,0.8135165387776162},
{-0.2189187329751223,-0.549781883849853,0.8061107048929904},
{-0.2849857994582685,-0.6014004498935202,0.746391715505339},
{-0.2411809996383503,-0.556959780605035,0.7947499784220428},
{-0.36492335506940166,-0.5807484080909695,0.7277102661256718},
{-0.3336113638928052,-0.7006627832253729,0.6306941589110022},
{-0.44588741572269336,-0.6248393826773622,0.6409057328152955},
{-0.11178497829549087,0.9763074233821606,0.18527799026425976},
{0.20623134775740248,0.9335653927902667,0.29312845066032134},
{0.45041495700840656,0.8126491663742921,0.3697670873594395},
{0.5992468730805526,0.6508052277362004,0.4662142647478863},
{0.6920186621850056,0.540083040217195,0.47897858079190453},
{-0.8145782226726928,0.40678799274015504,0.41350435077497383},
{-0.8262456390966773,0.4404056657951019,0.3512278368940827},
{-0.6143191740842989,0.6524160206016448,0.44380771558716614},
{-0.7026908571217199,0.5231433108456071,0.48223089452568174},
{-0.7432327582890232,0.42407069664761343,0.5174641159065024},
{-0.9093878742071239,0.19494240356514553,0.3674386391457658},
{-0.8851564515553683,-0.45566290496061396,0.09417735031717162},
{-0.8286230205916496,-0.5586868268282004,0.03539659975487787},
{-0.22285701280549886,-0.8874345444277077,-0.403478228904357},
{-0.41990511431544947,-0.8568248350102602,-0.2992171403535728},
{-0.6122232196664684,-0.7804037147223467,-0.1270935535296159},
{-0.6588557320728624,-0.7345527844549807,-0.1623001268150068},
{-0.68537690304109,-0.7281077636866482,-0.010843672672676526},
{-0.6567042775361235,-0.6620047877276228,0.3612328236628881},
{-0.6617763171733152,-0.6860933214169687,0.302205328105836},
{-0.9379679333190244,0.16329011991684406,0.3058635198953625},
{-0.8825873549925787,0.022778608694116843,0.4695963115199737},
{-0.7651994934067703,-0.17067211634176546,0.6207582170164524},
{-0.6117996337140044,-0.27483919186057243,0.7417308317744635},
{-0.43493478681353065,-0.42568065565045515,0.7934908383998311},
{-0.4292822358642592,-0.47238672858632114,0.7697840870184937},
{-0.37931536898721463,-0.48668787889056786,0.786927416850559},
{-0.49317700767917216,-0.3806266463034357,0.7822402413711641},
{-0.7189187802567423,-0.2862208545582217,0.633429877579294},
{-0.7771430659989705,-0.27639379601294706,0.5653805130133802},
{-0.6614293615089931,-0.16816934647765297,0.7309105763628576},
{-0.5978109703686679,-0.09859127600252188,0.7955512579356946},
{-0.7898264607738513,-0.1167839203151103,0.6021093570251886},
{-0.6734155792495332,-0.058797046352779374,0.7369222245014768},
{-0.7365409462406021,0.04392629969082175,0.6749651211036543},
{-0.7087866794687998,-0.006772042518066342,0.7053903759250804},
{-0.9792472780237632,0.19809597800423534,0.042810652664917306},
{-0.9606591463744099,0.2712342909128572,-0.05971569241153957},
{-0.9754767760734434,0.1259797941705446,0.18048310392418504},
{-0.9456415310387877,0.05045169931920879,0.3212735918347812},
{-0.8611618013872395,-0.0037233137877357284,0.508317311101956},
{-0.7441080322734854,-0.10415818255855411,0.6598896190365328},
{-0.6124471063556668,-0.1859139381770253,0.7683388246783315},
{-0.9715426888204761,0.21856763257754286,-0.09128523313728046},
{-0.989935194253646,0.1117734821930621,0.0868043769428333},
{-0.9656770553919759,0.08405492633857348,0.24576939200742584},
{-0.947335469802293,0.082341944432337,0.3094758663314002},
{-0.8909747712747553,0.011413633114104153,0.453909336686341},
{-0.7769239648498459,-0.06885930078766138,0.6258175049781125},
{-0.6425342185154602,-0.1575508579962113,0.7498849946367673},
{-0.5914602831139791,-0.17406772882908336,0.7873215094731099},
{-0.5408812900880188,-0.21034219858979547,0.8143731267208731},
{-0.4237261973081619,-0.32459408974503456,0.8456327729087592},
{-0.30182658531259904,-0.37572091345469566,0.8762046037263815},
{-0.2631310291527396,-0.3106233379497296,0.9133866669806321},
{-0.2805501361550176,-0.25905707250741006,0.9242191592297204},
{-0.2968666738753336,-0.3666722446346215,0.8817151711050483},
{-0.18081618593677654,-0.4762282439048141,0.8605301660084985},
{-0.14390356070117755,-0.44601492474975074,0.8833812609049373},
{-0.08494771264614498,-0.5218772093737278,0.8487803393413859},
{-0.17633438129085255,-0.5396878678252617,0.8231908595805684},
{-0.053574397320608765,-0.5625107152506192,0.8250524099594949},
{-0.02988100522976695,-0.634277980171174,0.7725273907095039},
{-0.17147248980336557,-0.6377729439126666,0.7508947045049694},
{-0.07799985322302593,-0.63713712562879,0.7667935224313452},
{-0.17061776851294114,-0.6722516782397854,0.7203938215805687},
{-0.20420193218878804,-0.7103829798621571,0.6735410847249986},
{-0.3200145319079929,-0.5590348568315581,0.7648991621220588},
{-0.42681759168118333,-0.696050145261379,0.5773568556041297},
{-0.20665725683692915,-0.734552898913988,0.646316344287913},
{-0.17394119453863519,-0.8876403245198461,0.42642597848721037},
{-0.054186435078057066,-0.9450832459845584,0.3223065131405539},
{-0.00017334937916890696,-0.9863611571324333,0.16459537554366457},
{-0.0845606771432651,-0.9832989325914041,-0.16116048227055518},
{-0.061622906678500906,-0.9445832430235476,-0.32243621752466073},
{-0.02529308083017529,-0.9313695010077607,-0.3631956947083389},
{0.16926921199388914,-0.9612422120349986,-0.21762661526805618},
{0.1318608896603917,-0.967999361103213,-0.21351801488806801},
{0.23000509231435076,-0.9075381872508903,-0.3513859647038209},
{0.4422555512167997,-0.7119207383276401,-0.5455079190597992},
{0.6211061537771019,-0.6727097346183142,-0.40210540743687156},
{0.7880119968276118,-0.5650915467043113,-0.2443535076463791},
{0.7468742043123305,-0.6644302049628633,-0.0266725639155832},
{0.5116596858782578,-0.8586589188827322,0.030153389031750657},
{0.23201926344295976,-0.9695105898092736,0.07884337409738937},
{0.08408765858810556,-0.9912874678942751,0.10138255110681926},
{-0.5926459829285585,0.13652970782051513,-0.7938075193654236},
{-0.6365730545173924,-0.3366727016418464,-0.6938488583485434},
{-0.570923920310655,-0.004497636937961157,-0.820990650664846},
{-0.39385492612952444,0.7106256968821496,-0.5830003568560366},
{-0.3107222974679688,0.9225017308439206,-0.2290026428803778},
{-0.22815590089961035,0.9673457943606196,-0.11039474180190337},
{-0.3107770215493013,0.9503374652986206,0.016623625559370973},
{-0.4144795497045139,0.8840796115862133,0.21589336083889502},
{-0.42114103514407064,0.9057696312067993,0.04713389121724652},
{-0.6453462362285466,0.760113113982807,0.07587021376672784},
{-0.7191928986991815,0.6947876557870837,-0.005629194130416711},
{-0.7786645036486901,0.5753974210443482,0.2501987182482199},
{-0.5120326122594474,0.8307024775207774,0.21853145728615078},
{-0.7000584228180118,0.6109162510971129,0.3697290072296292},
{-0.8133471103403647,0.5472230310218863,0.19751818250530326},
{-0.8898083394628559,0.14544713939944223,0.4325346791447761},
{-0.9394968033934104,0.09708128170918327,0.32851328916082795},
{-0.9652913930739047,0.15689004887342053,0.2088014344345755},
{-0.9724694798541795,0.07251581152099829,0.22146008180164725},
{-0.9208385930725328,-0.06590293251005978,0.3843346055129212},
{-0.933954649669377,0.028663418680916895,0.3562402571165613},
{-0.8163480854889295,0.41993596599897465,0.3965218629269607},
{-0.7546659918701416,0.4238759524477872,0.5008077651665723},
{-0.6824196506179405,0.496502604758513,0.5364593031335182},
{-0.824564646880574,0.4269358944582914,0.37123965997427205},
{-0.9098184053775892,0.25575154505111547,0.3268357637103811},
{-0.9684339509610986,-0.10184728316960524,0.22751442489839344},
{-0.9187317671299247,-0.39488218301917866,-4.000417537927784e-05},
{-0.8563618302188867,-0.5109041549292487,-0.07497573087465631},
{-0.9056406013685365,-0.05436902994876663,0.4205462040433438},
{-0.3621431577129734,0.9282363947427091,-0.08502663580745518},
{-0.2240428708242099,0.9362299118815519,-0.2706997305708082},
{-0.39338392999192223,0.8341306493409115,-0.38662015396797383},
{-0.5198806340984273,0.7484534713804801,-0.4117542075898264},
{-0.7169268970164983,-0.6968765925016069,-0.019463790937135468},
{0.8344064885557856,0.5443199891950056,-0.08649601851387662},
{0.7441369676666179,0.6589524232829067,-0.10973548743007264},
{0.7514101978726109,0.6441070060255683,-0.1432092152126473},
{0.6781805346260183,0.600698554858375,-0.42335848715412305},
{0.28872802700161426,0.9080868685209372,0.3033386978998776},
{0.6956851494274766,0.6730831019226569,-0.2509607753658806},
{0.47231069018837474,0.8609031044995265,-0.1891255048819664},
{0.3873674986254297,0.8006949944976417,-0.4569835301136128},
{-0.02440309959628638,0.8361571052755784,-0.5479468806620393},
{-0.2473188096220471,0.9672941439424486,0.0563510913982979},
{0.29031176858386193,0.67819035415589,0.6751125243628788},
{0.6017892585269826,0.6916199614088389,0.3993889298695956},
{0.6612318362882335,0.736151450213314,0.14440741334060914},
{0.4454081849617752,0.8863944417627398,-0.12616038356464274},
{0.34525938413509494,0.9149542295497965,0.20893710894810696},
{0.38765422621431084,0.9204997335153355,0.04903510473507791},
{0.7697379001027743,0.5174186693506811,-0.37387362270256735},
{0.2692142274731887,-0.08612307554206719,-0.9592218281425781},
{-0.4254426684039745,0.3644693455561963,-0.8283481345733471},
{-0.04723659579392272,0.9905575013758914,-0.12870330409803973},
{-0.27841494541706086,0.8057594589157526,0.5227205874424774},
{-0.26730929750899,0.17759663494726477,0.9471035712743663},
{0.18872124025043258,0.8131283718752697,0.5506419384044514},
{0.27076166422898984,0.9276962887190808,0.25703641197462984},
{0.5629000507228807,0.8132619389803214,0.1474739010881125},
{0.5647165470206559,0.821322704497972,-0.08077274662412089},
{0.7476986751389474,0.5494486423555152,-0.37289794932279247},
{0.5934928671011589,0.7386177419327363,-0.31970306223468015},
{0.2229169862369757,0.9654789711099854,-0.13475300958207906},
{-0.4742876335913636,0.8791095192014229,-0.0470923971756305},
{-0.36612486783260706,0.9172142380834275,-0.1570688467252291},
{-0.26143782586551084,0.903714098662791,-0.33904437922610414},
{-0.39259876742391403,0.8972549808998342,-0.20198937365035255},
{-0.8832835395104468,-0.4566840478715693,-0.10606540081258943},
{-0.508562834588152,-0.8162203479810748,-0.2741316961194325},
{-0.01849060170540772,-0.897843155403477,-0.43992700069863855},
{-0.02588353179606151,-0.9422876641513215,-0.3338023378737916},
{-0.799959341545116,-0.5204034585282376,-0.29873950563417845},
{-0.9596996145582299,0.12066769985552724,-0.25380298664192547},
{-0.9047818751411507,0.16444194818348556,-0.39284679468424216},
{0.9627401140965685,-0.08385237138814428,-0.25709969374137953},
{0.9485228394125628,-0.2687986109755423,-0.16748650647245805},
{0.8480334294740564,-0.4582395805044179,-0.2661875078842086},
{0.6360445900520535,-0.28666925737277815,-0.7164272582355136},
{0.8009804812272798,-0.1960825342538509,-0.565669433904204},
{0.9269889321587952,-0.35760324592917014,-0.11318762368747824},
{0.7451180461964476,-0.588873635569541,-0.31309253993587915},
{0.48239678331226127,-0.530801314556687,-0.6968093770285217},
{0.6770526543788606,-0.3007513691182419,-0.6716757530029218},
{-0.2230200294986442,0.07094906345439095,-0.972228520892783},
{-0.23483114324997575,-0.052781946363392805,-0.9706020813381772},
{-0.5648064467061754,0.24644341392591215,-0.787565439498005},
{-0.6009335223485348,0.27562190121386104,-0.7502742627126695},
{-0.5076739113916883,0.23280802416916407,-0.8294984168608848},
{-0.36908169904607946,0.14230991215683114,-0.9184370355833731},
{-0.318376963612746,0.14860894913565492,-0.9362432853043725},
{-0.4667666532945672,0.31345045058014437,-0.8269689875704492},
{0.25995839092563405,0.9653565690910835,0.022546163754558552},
{0.23215712985353573,0.9067805351568009,0.35192631063748864},
{-0.7273296731201764,0.6856321558639926,0.03000155736276099},
{-0.592009821883565,0.7871613351501505,0.17292022217780598},
{-0.6767858880774356,0.7003102701071724,0.2269942450408291},
{-0.7905599480632922,0.6052114256925312,0.09345640015204217},
{-0.746839760814537,0.5926394742467537,0.30167668990330765},
{-0.55086492813377,0.7198589031199685,0.42231622103714245},
{-0.6471630049206751,0.553123366966607,0.5246280453593446},
{-0.6025269200066188,0.45661805765839725,0.6545695227304813},
{-0.6655236138156205,0.5588262535138316,0.49476412343407783},
{-0.558743807997119,0.7264760087730022,0.4000474543127694},
{-0.2981582258567817,0.8764517733328704,0.3780660806996616},
{-0.4344840428329435,0.8787652458970288,0.19747217304490136},
{-0.5272995513988571,0.7955870917679152,0.29832258128883726},
{0.14172774827995596,0.9248883310736014,0.3528382354725489},
{0.6254092794540688,0.5386165567500665,0.5645843054561869},
{0.6172149680681553,0.3803605549702211,0.6887463476602772},
{0.7506867186869267,0.44662870056047527,0.48681850234221413},
{0.8749072625032185,0.3735747641154186,0.30818691996130143},
{0.8787155568957522,0.2913293754055641,0.3781351148666204},
{0.8414178069963052,0.393676185765081,0.3701825695936882},
{0.9552174567550713,0.12389110467101329,0.26872030904598465},
{0.955984209386968,-0.013481738569776802,0.2931082293759585},
{0.9937822826380059,-0.07028265101230084,0.08635463902696541},
{0.9926839372033559,0.07659003390921473,-0.09334113522037958},
{0.9353125018062826,0.017535879350149986,-0.3533879127818175},
{0.9831630769782703,-0.14377417373169044,-0.11278010034748781},
{0.9839628229927813,-0.15859744291713837,0.08163341269493667},
{0.9686145831890416,-0.24752023248736213,-0.022793063482594446},
{0.875000846315032,-0.41392270424755945,-0.2510806919226668},
{0.8913752512068235,-0.43203783428792053,-0.13708928214771415},
{0.8937280088181045,-0.37733915254288924,-0.24262194915596622},
{0.8836215582421667,-0.25983345004433944,-0.38948622574840935},
{0.8446482945374739,-0.41147143586753154,-0.3424332285279111},
{0.8118616850558651,-0.4798434341887088,-0.3326122111472118},
{0.8631645234789793,-0.4969495511719504,-0.08937644542777325},
{0.8160699788519387,-0.5086329396591736,-0.2744491251767144},
{0.8920938941085422,-0.4165748805723711,-0.1750252923733363},
{0.5945125501154827,-0.3980184761726849,-0.6986673889486754},
{0.6113913120052729,-0.5441672791745564,-0.574528185453274},
{-0.054511543732555685,-0.19288161872987325,-0.9797066768967319},
{-0.46627513564884426,0.16058943678342139,-0.8699416823380953},
{-0.5150346313417906,0.13718558437498415,-0.8461202302027295},
{-0.7026553058209825,0.3288513137475601,-0.6309772853662209},
{-0.6762339011123206,0.34722114953654293,-0.6497270075200307},
{-0.7467344249440514,0.32605510334551824,-0.5797204224329346},
{-0.7498400687757739,0.3042947471132722,-0.5874900664161161},
{-0.3627110424326824,0.17186577038741374,-0.9159164026626764},
{-0.36345863809990075,0.15355637139201964,-0.9188679226066615},
{-0.4198933411180276,0.21680501827735293,-0.8812974334096841},
{-0.5521142896916541,0.37258939698274557,-0.7458866886962886},
{-0.6070792225385837,0.45108855084245864,-0.6541971697132289},
{-0.5584957107946517,0.47217321108626104,-0.6820080642899069},
{-0.6370887816738536,0.4129626006220838,-0.6508300659563678},
{-0.7418564544737887,0.5548997509411444,-0.3764774460190618},
{-0.758596840885875,0.5299377640710251,-0.3790736065850181},
{-0.8044135553919325,0.5928065432710342,-0.038719945206029754},
{-0.7562596944268388,0.6139372827927165,0.22616871442027597},
{-0.7081303994236773,0.5838161204487946,0.3971272779804754},
{-0.5894472873596117,0.5948924352844454,0.5464932624156835},
{-0.3481774023494282,0.5481477772049564,0.7604646677120969},
{-0.32244295387653715,0.5719606233451611,0.754249021768002},
{-0.1223085582064158,0.4703672914121026,0.8739537904026218},
{0.2808945136359161,0.17021449115095805,0.9445238478786349},
{0.21252379997378018,0.15046401972838025,0.9655020524120507},
{0.3733650901276807,0.053368204988850386,0.9261481221544514},
{0.44579862022667166,0.008283651361416434,0.8950949510102928},
{0.6184191037051141,-0.15199193028674546,0.7710098996123671},
{0.48892427188154763,-0.1658031725671961,0.8564241731360407},
{0.5345502342704336,-0.20939830124253436,0.8187847082586274},
{0.6390365567184322,-0.25653842838693636,0.7251346867570265},
{0.7870258063410975,-0.35381184551922956,0.5053786284791061},
{0.6482501393548592,-0.29086662059605,0.7036820061998456},
{0.6482116824584628,-0.20544069046760807,0.7332228429506007},
{0.4251831478922763,-0.19905936155485005,0.8829465789762087},
{0.7192558898993299,-0.21318995626988763,0.661226895544008},
{0.930296093232847,-0.16755656651183917,0.32630350279220965},
{0.9695399539513853,-0.15028831090336073,0.19340553585086645},
{0.902018660398106,-0.13351267993808072,0.4105322162624485},
{0.10530649447054054,0.10757338442401286,0.9886043238757807},
{-0.03274110138895725,0.11733454761296801,0.9925525800763898},
{-0.34254247509296953,-0.15807921856631188,0.9261077763493009},
{-0.19107960138079763,-0.17180024236232083,0.9664229212205199},
{-0.46924439895761405,-0.40507416921403494,0.7846812164710373},
{-0.5897843730372145,-0.49766343762165577,0.6359917422228817},
{-0.5915342153013493,-0.6492830188660834,0.4780364353686462},
{-0.3828675054807349,-0.8275800117712434,0.41051650072033413},
{-0.141976764454653,-0.9767478445305451,0.16064322755697538},
{0.03171088968640841,-0.999383638378763,0.015058645892719361},
{0.3000996800949824,-0.9150199267736762,0.26958990265584093},
{0.12240497249451612,-0.9775933421253107,0.17125501493644502},
{-0.003714099349117892,-0.9999907308331927,0.002178006823212092},
{-0.027244672190788848,-0.9994739489359976,-0.017594125027955074},
{-0.34582245468618406,-0.8859233860442924,-0.30910610458973103},
{-0.3480757327102895,-0.8750852215257674,-0.33625754915747835},
{-0.29137155498104633,-0.8989995920225627,-0.32695924897637163},
{0.08526825948334546,-0.9934086425110199,0.07660674192976528},
{-0.16177755833345875,-0.9445821509527444,-0.28564415226143003},
{-0.2493031239744247,-0.9213968903929928,-0.29812031589731663},
{-0.16484747099509792,-0.9837097853459023,0.07169637034912961},
{-0.23899506026580325,-0.9497076992351278,-0.20232806820128832},
{0.2799427927918415,0.9369693733902533,-0.20909429952196254},
{-0.15494910730565253,-0.9784403971032389,-0.1365472938642047},
{-0.3050554515818227,-0.9462568761295646,0.10742018356774571},
{-0.44899232058786087,-0.8450680528215265,0.2902858628207052},
{0.9862854919797402,-0.09662713195883561,-0.13380629910318695},
{0.9978532268011181,-0.04413920484406738,0.048380454300569926},
{0.9602196873855323,0.27893506202558516,-0.013167502800967337},
{0.9496826990792303,0.16069200736062028,-0.26885098073096575},
{0.9178785298124801,0.07548475262279497,-0.38961655076594937},
{0.9107173778714057,-0.12227622310369524,-0.39451537727511543},
{0.8559148477078596,0.03435842817420196,0.5159741000153298},
{0.9703188196439961,0.03992865078830237,0.23851014882161306},
{0.8763115131114523,0.4192137258047875,-0.2373562387745168},
{0.3603034330805791,-0.9043091601322109,0.228924395841344},
{0.8262570330374549,0.08807152866412392,0.5563656362455417},
{0.7293184193396811,-0.23096513239395106,-0.6440106760218449},
{-0.0742037460562467,0.9883528863239908,0.13286224507457559},
{0.42439232373224495,0.9013748483724375,0.08610771323586908},
{0.7062443607973237,0.6835107451064847,0.1844775437985828},
{0.8116493222171625,0.5302092983961334,0.24516010613209635},
{0.8192785930692931,0.49307349916646415,0.2926791952943337},
{0.7698465358801277,0.636746642725776,0.043474408228521985},
{0.47560037418437934,0.8790842106606855,-0.03186274694306636},
{0.4543482124632386,0.8906395032566022,-0.018137725058358065},
{0.2633099138177917,0.9597318629058021,0.09789096285472836},
{-0.1464094842179858,0.9093365866456207,-0.38944991349172886},
{-0.8409501494897614,0.53951317260031,0.04157382185818492},
{-0.7115532393601746,0.7005946956760407,-0.05347017810553715},
{-0.9092722984022458,0.3386836023920513,0.24190350313511394},
{0.313443588454794,0.666755700352908,-0.6761582306705175},
{-0.10576673917435864,0.5974595317868417,-0.7948933920730951},
{-0.08031372065704226,0.813919832782607,-0.5753991762918641},
{0.6687677251029338,0.7430762002862598,0.02423820184710731},
{0.6142347893820097,0.46907495168545515,0.634574119559036},
{0.6845459144821643,0.6331747076916723,0.361229401496255},
{0.36307199717088035,0.7114534444552258,0.6016749298775405},
{0.21028363226289198,0.9369642431703121,0.27906773554570785},
{-0.07787843182572665,0.9344040261849196,-0.34759756285937604},
{-0.428104554253973,0.8966440043835985,-0.11294255190118774},
{-0.15979728884585895,0.9533431728200459,0.2561281345633887},
{-0.07478694816640105,0.9174735603282957,0.39070344058182715},
{-0.47801643022172063,0.6326755370026308,0.6092798678083132},
{-0.2926654862449018,0.9028251767178531,0.3150454148934917},
{-0.7551442759148143,0.654832679825898,0.030842891970818274},
{-0.6413052793584144,0.7470978684472502,-0.17484940271159374},
{0.3164943697428093,0.6349765099990909,-0.7047241628257658},
{-0.8877062936151227,0.04362569733358979,-0.4583386682446286},
{-0.6180858594698209,0.7591509395983674,-0.20410713174793482},
{-0.4712053731311504,0.8675045666373774,-0.15937792568492484},
{-0.2788976482863489,0.9580881989830449,0.06544543337597769},
{0.3832944312011792,0.8163638746903292,-0.43201319784325676},
{0.20541580769261575,-0.39258498176975376,-0.8964827817860376},
{-0.48285652104565974,0.7722611040156211,0.4128708845489789},
{-0.5870269995040135,0.8081506900031188,0.04787237304331258},
{-0.010555400362899285,0.8902789967968615,0.4552931927731324},
{0.3377909435951468,0.8353515034409652,0.4336878417987061},
{-0.3692195633388248,0.44616412560386154,0.8152389141055701},
{-0.11542425165403433,0.503212693311812,0.8564194226078589},
{0.4835691166199757,0.7513168378725333,0.44909232745683125},
{0.21565321842636578,0.9747241310886554,-0.05836572329557844},
{0.35042160527865335,0.9278117546091603,-0.12794548277685697},
{-0.9570287892582359,0.24578149771051458,0.153906958627905},
{-0.9448089812661569,0.32620214350239624,-0.030465562414779174},
{-0.9589521984968354,0.2263667319993239,0.17078871052277494},
{-0.9288218470120124,0.08337705085298985,0.3610238827338875},
{-0.9336767238497239,0.09559166554545064,0.34512317919765007},
{-0.9331035798054516,0.2764595891313008,-0.22997348745367077},
{-0.8226352221996998,0.41224512995104423,-0.39156767490192224},
{-0.903792532066577,0.30455534656177713,-0.3006744083910727},
{-0.9328826053311231,0.28886195644457224,-0.21514835530310258},
{-0.9583075034309431,0.22050340233071294,-0.18172775910282013},
{-0.9909710861412975,0.11722984911507109,0.06506511283625707},
{-0.9746511456495778,0.009174845184714467,0.22354186744277202},
{-0.9057795030411513,-0.04175365632054629,0.4216872348724716},
{0.83898929878284,0.5181926869299511,0.16605208743101102},
{0.8800907560754703,0.47479145610014284,0.0036516140011201444},
{0.9488957686147488,0.2174899972403234,-0.22868082867925132},
{0.9004627357912292,0.0594138312879207,-0.4308559598091522},
{0.8780081769656095,-0.13048683753268941,-0.46051582645143063},
{0.5474829661933193,-0.705863370326473,-0.44946557616742727},
{-0.15800010320873273,-0.8676799748781027,-0.47134639977575404},
{-0.20686636168216194,-0.9681025901220409,0.141363656586057},
{-0.14363108573246577,-0.723292842882624,-0.6754388015550223},
{-0.04168348535257919,0.06014124554260219,-0.9973191653795919},
{0.404937082249293,-0.160657695549637,-0.9001194722258314},
{-0.5666954770883661,-0.4025674018317352,-0.718885055645223},
{-0.5758027446441508,0.024798337598744655,-0.8172124825971527},
{-0.504965343964103,0.6542722028866544,-0.5629723669284841},
{-0.38383864445940763,0.9158900123380215,-0.11753033786654064},
{-0.29082892134339916,0.9541357182910285,-0.0710180934093423},
{-0.16249052841626893,0.985859628791944,0.040958765767683765},
{-0.19734991836742055,0.9606338768010533,0.19553916350069397},
{-0.23572320810666517,0.9700017464160618,0.05942374196978811},
{-0.2977521524860443,0.9479222109546535,-0.11308022669224226},
{-0.30757433633349335,0.9115778691438613,-0.2728072875055728},
{-0.46926451090511956,0.8772151799088884,-0.10141176924990201},
{-0.6630216479189078,0.15815514133436578,-0.7317029763916522},
{-0.6172310173643848,-0.3561286862443369,-0.7015684072399563},
{-0.8402637009708468,0.024599321879750436,-0.5416195954669953},
{-0.8243383402699122,0.3229935816222585,-0.4649101493749861},
{-0.7332486035992641,0.6408139449818617,-0.22738507698728336},
{-0.39369407340766555,0.919186169713294,-0.010087713887858054},
{-0.08365635705308026,0.9888239061776253,-0.12340541518195518},
{-0.30118058883285564,0.9513892779046176,-0.06441036250809651},
{-0.3653731114288524,0.9307599384420376,-0.01372685091976842},
{-0.8128021576457708,0.25487282564038855,0.5238248708074711},
{-0.8330462581146928,0.328765150904676,0.4449128087521577},
{-0.966796551013123,-0.12446498351354049,0.223188030207948},
{-0.5290687541100729,-0.8443301684748509,0.08481049479660642},
{-0.03567120261843161,-0.9578685428534859,-0.28498319233859126},
{0.22717198775451805,-0.9732072872553111,-0.03550301413710311},
{-0.03772141937063157,-0.9410799455216328,0.3360738470301811},
{-0.8198158139422134,-0.567456935151186,0.07677667587938972},
{-0.993741549944801,0.07963290390262412,0.07833474662842624},
{-0.9680502171041588,0.20197706685359793,-0.14860700397292295},
{-0.906716334676975,0.29303012849286275,-0.30331309273654555},
{-0.8136200437445639,0.3523371475488301,-0.46247265743419697},
{-0.6047959292599208,0.377277554061831,-0.7013440889832544},
{-0.5985118646972243,0.30114912149054973,-0.7423562180261721},
{-0.4260560883425929,0.3487060056221066,-0.8347935860015241},
{-0.27775303970326265,0.3533522267579374,-0.8933059122052227},
{-0.3198129259335128,-0.41111166879088895,-0.8536433026679328},
{-0.23696032498443562,-0.8167865433219035,-0.5260318878466658},
{-0.11679873026399966,-0.8926223786690324,-0.43541169679735997},
{-0.08150010240304803,-0.9879992200052276,-0.1312069913432767},
{-0.07691692052863466,-0.9968965028086857,-0.01676752886396451},
{-0.1402918452555721,-0.9893502963192897,-0.03878387974043096},
{-0.13298290065655816,-0.99053954080316,0.033866890002378566},
{-0.984719194195062,0.15852866139427585,-0.07208864057787964},
{-0.9728867155403694,0.2180673714376705,-0.07705881026422227},
{-0.9835654895162043,0.18003802243803493,0.013610228115328825},
{-0.9764914