// 3D model [manga3]
//
// - vertices   : 10513
// - textures   : 11535
// - normals    : 11488
// - triangles  : 13427
//
// - memory size: 453kb
//
// - model bounding box: [-0.42,0.42]x[-1.0,1.0]x[-0.44,0.44]
//
// object [manga3_1] (tagged [ | o manga3 | usemtl mt_01]) with 6975 triangles (1039 chains)
// object [manga3_2] (tagged [usemtl mt_02_hair]) with 5308 triangles (697 chains)
// object [manga3_3] (tagged [usemtl mt_03_eye]) with 146 triangles (12 chains)
// object [manga3_4] (tagged [usemtl mt_acc]) with 998 triangles (181 chains)

#pragma once

#include <tgx.h>

#include "manga3_body_texture.h" // texture for object [manga3_1]

#include "manga3_hair_texture.h" // texture for object [manga3_2]

#include "manga3_eye_texture.h" // texture for object [manga3_3]

#include "manga3_hair_texture.h" // texture for object [manga3_4]


// vertex array: 123kb.
const tgx::fVec3 manga3_vert_array[10513] PROGMEM = {
{0.0760232780653167,0.13066948576272602,-0.05263655702423132},
{0.060016229515491334,0.13196616650973286,-0.04689819632798675},
{0.06638543165362536,0.14735437005237287,-0.026773111312705457},
{0.10604790031379169,0.1304353817838389,-0.01912124492307134},
{0.11660274279270351,0.13829532682913806,0.023895640040185327},
{0.10106685173728422,0.1386187844177539,0.041907642311997756},
{0.07137816683956058,0.14209504880556742,0.01773755284542574},
{0.03830775144237451,0.078314330644085,-0.05274466125969094},
{0.05968039130882844,0.05587563157340391,-0.04947224951077195},
{0.07057883001932547,-0.002252621851477453,-0.06154304228134117},
{0.033885838345774466,0.06324249588773538,-0.04546489502707566},
{0.0616496531589683,-0.006151450737338152,-0.05176991376093984},
{0.08085138449235632,-0.006025029631534747,-0.04384334388819234},
{0.0926619116376949,-0.0011495942952641307,-0.05364372463991037},
{0.07784234901444362,0.0036849069254814427,-0.06433766627493806},
{0.051981840446538544,0.05768988164122935,-0.05977082930702478},
{0.045856768233237664,0.08601268321819794,-0.05650074744418468},
{0.0408675898414761,0.10510521973115321,-0.05228321988595442},
{0.034905522902622166,0.09940604573587435,-0.03990234158570101},
{0.0217961958053859,0.09593848124182365,-0.03699618049258141},
{0.06235849621245729,0.08445760819063002,0.020214903362924724},
{0.06459917739778014,0.06133227434227631,0.015117657914736718},
{0.07280584171345125,0.02731588801801604,0.0025164442708816934},
{0.10475623873626339,0.027566264020422355,-0.03066461592903083},
{0.024977456957972738,0.12580691437193378,-0.022417054676868},
{0.0419707661138221,0.13077150502975604,-0.03627120173869484},
{0.056314461898465146,0.11477335466187054,0.03012560669908179},
{0.05961514210560764,0.010108712670337397,-0.09509555820169749},
{0.09918802168883518,0.07411200931042296,-0.0814080475665576},
{0.10717040968338826,0.020698057292034888,-0.10062810816330055},
{0.1039060781776791,0.014955123574709833,-0.09684577358138582},
{0.13430739839027553,0.0024728456579793303,-0.06438350802284187},
{0.13820498797503036,0.008084463030132895,-0.06776309453139115},
{0.08681642575386427,0.09835663034549817,-0.06606775540466804},
{0.11801056406287914,0.09323933300541831,-0.03658102701514682},
{0.13658131763125614,0.12143307376522791,0.01198642734779135},
{0.13160692410168687,0.12196009895348373,0.028011359012573463},
{0.12149547877241103,0.12039981886127171,0.04632327215199141},
{0.1338583748136192,0.09284486346343965,0.04426993611483354},
{0.12100844583083957,0.08828333070425912,0.050218383134534667},
{0.10763886550138363,0.11565826522346165,0.0633772946690143},
{0.11807131460308587,0.08394202175158082,0.06305878189181062},
{0.12160691672784527,0.05003975027314334,0.04677217179853716},
{0.117412006414796,-0.014711253903109314,0.013100063321470352},
{0.10897236588424404,-0.011610547322400024,-0.0056270156883932495},
{0.11896855621067971,-0.006933387770047716,-0.01735327035853681},
{0.12734002278740125,-0.011280942800299197,0.004148591434219691},
{0.13069110537051692,-0.005073283561307267,-0.0026403000233961465},
{0.14891934089927078,-0.006675637926061792,-0.0008384801456619899},
{0.14601259733463137,-0.004687786559334726,0.005560155393734922},
{0.15432950987667524,-0.006260459662605064,0.015411359883802135},
{0.16260349302841393,-0.004667846204542253,0.014708713335842217},
{0.15957052664614807,-0.001054192896138976,-0.007602461651051084},
{0.16359331042861158,0.004299575487940098,-0.028958098306333308},
{0.1680238366678971,0.009783544846195433,-0.03183079826959608},
{0.15515924675303577,0.06789167202111857,-0.015844582371359415},
{0.14513942295451232,0.08897355945513884,-0.0027486149400437537},
{0.04883153703557482,0.14551297929033025,-0.013812574706232506},
{0.13656911051536394,0.01669258654601938,-0.03440730526857077},
{0.11526924240984308,0.02710153849875548,-0.041647302328700675},
{0.11113276514393264,0.022856101879622403,-0.06885281199372806},
{0.08226043267062678,0.011144235495317316,-0.09261479960615754},
{0.08795010122642415,0.023847084222859676,-0.07951662621887354},
{0.082466181440213,0.01987886686808475,-0.0740686585577419},
{0.09483809959347142,0.016173319382685878,-0.053806085477782276},
{0.07531158461928432,0.004778193575003228,-0.082516428903548},
{0.13525353042649352,0.07395353987802326,0.03731237577671725},
{0.1307185682830216,0.06610975531914375,0.044260269566208245},
{0.1237188097422526,0.046557338951845224,0.021030363490546343},
{0.1344077693868349,0.04620163474845629,0.02839429066125705},
{0.1481664778705035,0.013787689540027728,-0.011467841800066008},
{0.1424012739123071,0.010054914609334317,-0.006143791856504091},
{0.12143974740168283,0.010343671766987464,-0.01788618222704528},
{0.059021083120538664,0.007468468415491026,-0.08708627737314838},
{0.06923913313093606,0.006945495741851181,-0.07908534943405239},
{0.1722337177383045,0.13546843143474607,0.13891889357353657},
{0.18450357944549964,0.1361671617912115,0.12729403851987023},
{0.1585270599010799,0.1485046769457728,0.12662874450723935},
{0.13638200083440902,0.1455117523822356,0.13478582438566714},
{0.14670907216308446,0.148914836039751,0.09673680183515213},
{0.17146568566400214,0.13819973953484713,0.08956466890357624},
{0.19684501079155517,0.10405097106646442,0.08484197742859657},
{0.20479227699276967,0.10618016472430884,0.12162806540121589},
{0.17140857866904652,0.10722259045644812,0.1567691918370632},
{0.15490457037579225,0.13171342344221426,0.15012589347335767},
{0.20936444295543796,0.011171562084700425,0.12312273689288661},
{0.1825075115124412,0.06009545183867998,0.13576238126403273},
{0.20429195874334402,0.004346668929960777,0.12797212211991305},
{0.20949950198994888,0.002394757295302278,0.10448240896042957},
{0.19349639441764008,0.00044415931981596393,0.11061447083196718},
{0.19205136932826805,-0.0011025008532434511,0.1312810560724202},
{0.17075073285606152,0.056675538472147756,0.15476265180966062},
{0.1735480833120912,0.08040438717300782,0.15763226591316995},
{0.17941374501792434,0.08907312490597956,0.15306972932009383},
{0.18806580175801185,0.061813073599285444,0.1473709147221356},
{0.21832827067471355,0.01453502528586314,0.13763123493858},
{0.2243058412704011,0.013262374587297832,0.133529842286975},
{0.22361495568993536,0.08770136729798275,0.11686279154024067},
{0.2279728712774315,0.017782960837942473,0.15361205987700643},
{0.22086266622211287,0.014556019046595533,0.15037001100517972},
{0.23569211846818844,0.02095580713602081,0.1323902305621183},
{0.24864529362609292,0.027239014170422786,0.11525317487100625},
{0.25284530985969805,0.03352979333458115,0.11439929640910461},
{0.24046842210900532,0.01827765266034768,0.07979800953494724},
{0.24438831911366474,0.024500245477664582,0.07776431642031642},
{0.22848930044123272,0.02536898315982487,0.04252604117078486},
{0.22506140597557908,0.019336052983740817,0.04565650337104463},
{0.18619117294031146,0.0037838031537249578,0.030313162528434762},
{0.2048768964722743,0.010629975108451319,0.04145031541793252},
{0.19558361294703072,0.0036156919587221146,0.048880855023080406},
{0.1826983638827356,0.0017689226298803064,0.03774356581046101},
{0.188335981792089,0.004486697561906117,0.049125307166201025},
{0.19014658831466338,0.004732153538922468,0.0664098396889042},
{0.19948965456532725,0.004662752676997209,0.08284421165302312},
{0.18365880984672567,-0.002567391939341523,0.0670827801893579},
{0.18575946240010324,-0.002148520558589654,0.08778158725856192},
{0.19462291912281945,0.037292261919769774,0.09317503806404907},
{0.15158199171811013,0.031056148327388653,0.10846800131670786},
{0.17229441870646695,-0.007722884539502641,0.0729768962485804},
{0.13202796425937408,0.052738811758471324,0.054832747299855676},
{0.1300667826524441,0.07007135480601363,0.11229110890500368},
{0.11145344669807154,0.0821053651197624,0.05158037504981758},
{0.10848529576363942,0.11355393194579967,0.11370407327476847},
{0.10228755093349393,0.11295287090948276,0.060488471398364975},
{0.12229113486836185,0.14311866194692047,0.10566968420581566},
{0.11585172632258389,0.13863240433690688,0.07419763262382333},
{0.12232460839122974,0.12079758494419177,0.053979674383672786},
{0.12360851194383564,0.08846922587013031,0.05360787165891936},
{0.13314674333264215,0.09440154958244493,0.043854584349222014},
{0.14260327999255382,0.12554046463418506,0.05147752545104658},
{0.13818390746322062,0.14168848368479597,0.0665957596407975},
{0.15835602395546733,0.10011244736618471,0.15615136305678476},
{0.13557273721231644,0.12410527959559303,0.158711771534395},
{0.15032905830013826,0.09513167143592062,0.1663061963177749},
{0.20649750574231718,0.07403352437139217,0.04657078536884337},
{0.17798286035416955,0.05931096184569255,0.040830677258039606},
{0.142983138174495,0.0768645838174997,0.04555988745683584},
{0.15515740019438812,0.050785759966795546,0.05025680146881471},
{0.1578243637810757,0.051825533594568395,0.06292245877017175},
{0.13616165309779643,0.06787606922019639,0.04730220848848015},
{0.1593130246623833,0.1277260217063216,0.05295425186270519},
{0.18092094584377477,0.09818114530891589,0.05118372433789269},
{0.2182318778347038,0.031694834545277814,0.07325753598399061},
{0.22605782885067077,0.03401559936805796,0.09634640959381156},
{0.2252001953064185,0.03324963692660226,0.12218955555322429},
{0.2183443939821001,0.02837920836679932,0.12437567031085843},
{0.20619181973155862,0.0245832662587428,0.10399784222805866},
{0.20891579116911332,0.03881038098836246,0.0881595864888444},
{0.19819832759909745,0.021905099390058646,0.08041022428121636},
{0.19537025486865486,0.020681896805615094,0.056579703317635704},
{0.20181211723062228,0.02541228434046184,0.05317038597555809},
{-0.03898205517404462,0.16263261040789462,-0.0928958359179216},
{-0.050223321749441295,0.16135749350012898,-0.0803196561564039},
{-0.03626258239950391,0.17116651218055445,-0.06556207098145415},
{-0.0008434683326128211,0.15927595096980288,-0.08141786283131561},
{-0.006119049209926628,0.1671189671619968,-0.055154420294879165},
{-0.04396979597652342,0.16594662549493577,-0.04367104385545185},
{-0.061192363443936214,0.15633710950652308,-0.0631590661372926},
{-0.07076943452939873,0.13508237674727575,-0.0824701905792903},
{-0.03698614835012989,0.13531772002726872,-0.11723984890168272},
{-0.00036249557344878873,0.12864363742409501,-0.111315816113766},
{0.034905572474666365,0.14381616539529124,-0.07243378493197114},
{0.02340607272785253,0.15597270540937133,-0.04903599073550544},
{0.01625033574990647,0.15061146403962408,-0.026992541966499816},
{-0.014805323053545478,0.1588974560190781,-0.03135116395562631},
{-0.07437293796174535,0.10901433481619202,-0.08813104538437763},
{-0.05493635906880673,0.0881519028219882,-0.1006975090252258},
{-0.05344795844073139,0.03543707773641964,-0.13006150942623884},
{-0.073799934702464,0.0849607148675439,-0.08866171411788458},
{-0.0568944672089943,0.02869651902193022,-0.11852238922307229},
{-0.03623406608105928,0.028464782108155222,-0.12067628215195539},
{-0.030447769218042032,0.032005440581426486,-0.1365368700970963},
{-0.048106570674699214,0.0424055934963112,-0.13439038818882593},
{-0.06648665776794767,0.09170628035850065,-0.10544898946489338},
{-0.06915685593052144,0.11793382034190177,-0.09298687497715426},
{-0.07044994270432144,0.1262220802423793,-0.07052548430322597},
{-0.08079067113118277,0.12116936288292313,-0.06278604889745547},
{-0.028930939022599477,0.0885655691380958,-0.048507019844513444},
{-0.029709145758980555,0.05268935125133854,-0.07518898675739226},
{-0.015245274946107279,0.06330272592147773,-0.11765736944422941},
{-0.06987615868534341,0.1469927048106649,-0.04465010412205117},
{-0.02530962683336236,0.12861139080932174,-0.0212694494598788},
{-0.07835841878092414,0.05436395687056153,-0.15055679846784706},
{-0.034692127645213046,0.11923154210183749,-0.13855756294312724},
{-0.03858007546736475,0.06959585975773717,-0.17484365488460832},
{-0.03992347786606054,0.06289624755178383,-0.17148763988309154},
{-0.005298631877881754,0.04958363789416175,-0.166187149053551},
{-0.0027791203367632253,0.056063980555464576,-0.1693275256626572},
{0.034393765903989834,0.0967485008375909,-0.12660592897388143},
{-0.07522992706942261,0.04989972164119818,-0.1440941282403131},
{-0.058722052156718205,0.04750312398375367,-0.14843459446823948},
{-0.05718074576443592,0.056544779812473876,-0.15873150120799948},
{0.03668762549976293,0.1392259923875556,-0.05624996247241338},
{0.03437012003889102,0.1320021929928786,-0.03669379102276428},
{0.04146000055607446,0.10650419239143336,-0.05138771329990868},
{0.031471419538428434,0.10026731043236663,-0.042299162317344596},
{0.02775102522578196,0.12213237420020215,-0.017612284289650657},
{0.03323739882818257,0.09213261233190967,-0.03120617811925784},
{0.026418231244551827,0.0663126660891977,-0.05534838331094917},
{0.0010552524985844084,0.01394011118303103,-0.10247343990285959},
{-0.013538757323409732,0.022685908658761775,-0.11439179863741444},
{-0.008385718539438258,0.030820619152229767,-0.12729786796028716},
{0.007069568372059198,0.020026368485698085,-0.11330120127129242},
{0.008261800821868606,0.028050830752793316,-0.11877892455197454},
{0.025410555515419465,0.02603783396662949,-0.12510125632228686},
{0.025485582804365064,0.025924190055226937,-0.11779862498426939},
{0.03671115982776224,0.021393292819382115,-0.11309177177742191},
{0.044191110367998644,0.023157437943499618,-0.1166169265938594},
{0.03320521417846472,0.03352724037430329,-0.13369887056479615},
{0.029250604349831635,0.045280796847807815,-0.15233053578252362},
{0.032858209868838514,0.05140422079063791,-0.15505946442450164},
{0.03953677874201536,0.07777529662811375,-0.10060085593198381},
{0.03303104280105454,0.11748575102709698,-0.09785104506637296},
{0.0376996511757767,0.090725869253696,-0.06339212910325083},
{0.03528655842061388,0.08109016683291767,-0.05776029873006151},
{0.017459881236163984,0.0697161339300558,-0.08064809573546514},
{0.03003756055201964,0.067127221527012,-0.07871725221960532},
{0.02312349968271725,0.04879177405959472,-0.12816290013214113},
{0.0032539957344867552,0.059140297690411674,-0.14267408746123414},
{0.019465082818372233,0.04356441438830803,-0.12226382686849535},
{-0.004201887578274953,0.04741368362294737,-0.12382658556291916},
{-0.010560729159164336,0.06628695059125211,-0.13182999210422677},
{-0.027645709417810364,0.053383359870591125,-0.13031929644925794},
{-0.047919460993744355,0.060723752713302444,-0.14092522291975113},
{-0.045475546820080065,0.06625972314595757,-0.1471613984771877},
{-0.019726575351697667,0.06468827695078205,-0.14907238838933246},
{-0.062482463502071185,0.048325722485744634,-0.1421608185152527},
{0.06697737143380346,0.19565015721990692,0.015288706253360328},
{0.1112725211296346,0.13219299579112873,-0.01291903860894498},
{0.04647584870763295,0.18039811568976183,-0.02524935342408145},
{0.05946721912561842,0.1313490317380737,-0.06611108137132707},
{0.016467424124610823,0.14736779168334888,-0.08183260733938529},
{0.1202153055161336,0.06178205389260719,-0.10414276609937183},
{0.12170122754199733,0.016677752111782976,-0.17253483692448815},
{0.038524282131581336,0.05374274479826435,-0.17262903620154063},
{-0.013216526642888603,0.13398870591441125,-0.11495688276262969},
{-0.038104171449723445,0.18256560375177572,-0.08271895549025912},
{0.11555554575130686,0.09671549824914308,-0.05563774772614428},
{-0.006494557444986392,0.20914620822721056,-0.04606537359187278},
{-0.06907927568129785,0.15913288605014841,-0.11516260674619382},
{-0.11916067266810204,0.1296673373165254,-0.1631334739498071},
{-0.04914758360357791,0.10064410754057636,-0.17343950194570584},
{0.0810261135552642,0.19414443116237237,0.028733883950270545},
{0.12035533414807886,0.1724806794661643,0.04545714939516437},
{0.1003158352671646,0.13336665111736215,-0.02340476526518586},
{0.15499751795872785,0.12111244178313338,0.025317118408547022},
{0.1386350130657347,0.09424185324195058,-0.033550935811446435},
{0.174009152895496,0.1304853999764693,0.06894505317503336},
{0.18274421802365046,0.05508121477855902,-0.04429815500101279},
{0.2455916680943932,0.0034023834523904456,-0.05396223741711406},
{0.2529370181415278,0.030766151868629483,0.032579398102559366},
{0.20653386683676161,0.11044073320994385,0.09535868661248265},
{0.18085678722552714,0.15910196548755853,0.1268406649963325},
{0.21163608188238392,0.12905134270188356,0.15350174968557848},
{0.25788304406878515,0.08926364266497538,0.1977249579522175},
{0.26225655006419246,0.06727472314462535,0.1245962783007033},
{0.14622203922151292,0.19278118755297263,0.10009532022490267},
{0.27040743343709117,0.021100854937444503,0.011472860969544538},
{0.2512974103855329,0.048909482878624455,-0.004616985287159786},
{0.2797145723486976,0.002288189793213807,-0.05606407969955325},
{0.05775201400216917,0.0438891980291071,-0.1920525900398572},
{0.1223791128538632,0.01914780314576872,-0.2066441212596398},
{0.07754242575382707,0.06752746621214377,-0.17091260416999662},
{-0.003540076001751423,0.07497460005909846,-0.1871152268273295},
{0.09738861844825734,0.1445971605591603,-0.06953774892888599},
{0.13075430972691313,0.1426687832525012,-0.04313443886964808},
{0.10740835549570336,0.18150104410188678,-0.014392567623750607},
{0.07584830114218766,0.18268208566271063,-0.03664050107521453},
{0.022316689876814136,0.1849091469288807,-0.0834650147559555},
{0.019790994223177653,0.1454807450685682,-0.11755447027341416},
{0.16578192857447951,0.09996891151211017,-0.08451136907260018},
{0.014616118953721762,0.12207884878544235,-0.14577887134258152},
{0.19272433461474386,0.06436727317835567,-0.11665103216029124},
{0.14897947178892457,0.06637497814879766,-0.1444510345657747},
{0.18994334293331083,0.018783399048616964,-0.20025180615588242},
{0.24415658219988975,0.01739652196712943,-0.17564921299639455},
{0.22242541252352555,-0.010412019222973155,-0.24172006045732153},
{0.3030407349412476,-0.025686467317111026,-0.24199891559913944},
{0.27078416858024573,0.010120622353964258,-0.12288223812029352},
{0.22220108663036334,0.05852892566889443,-0.07437228732866484},
{0.30749598523759397,-0.01952721517931196,-0.1603017204950802},
{0.23477104510032984,0.09848653388740909,0.06492374416088567},
{0.2712675207975329,0.04552739298184145,0.07589422344466333},
{0.15844650532920235,0.1380548776285892,-0.011102223187830565},
{0.13082125677264891,0.17679051017075514,0.015972788070755247},
{0.17958403738287346,0.16805587879798753,0.06705058314662901},
{0.20914876738399418,0.12518968045618606,0.0636734876333024},
{0.25779033195305967,0.0030804378111237247,-0.008447094926703418},
{0.33275693232352027,-0.02219167537776597,0.07565946263619014},
{0.26209169823109785,0.045000739583917315,0.0760615290939474},
{0.26622354051087255,0.0647155043960766,0.1700216210329871},
{0.20575433404819732,0.0898014497728518,0.08102988722713138},
{0.1936047960853651,0.012715483402315875,-0.05458354863349981},
{0.28297271974188876,-0.0898004831179896,-0.07917708250190428},
{0.3326612458851408,-0.0710585572808784,-0.02728629350760946},
{0.33673853413023785,-0.16056333695851638,-0.09182044477636783},
{0.3906580342487181,-0.142434852775769,-0.03283712316052318},
{0.415031443454709,-0.11073108906602386,0.09020812643072278},
{0.10926604306728734,0.1446083142691126,0.03187921776380001},
{0.21270062913926185,0.1072247716263943,0.1495743920882621},
{0.15294400841941513,0.05758578034834155,-0.03540989986316938},
{0.34291806123412794,-0.024183765154274766,0.18798610850040284},
{0.38992063769775137,-0.08689435920390312,0.2032918737334846},
{0.1127881739890267,0.061888708145773026,-0.07384185406236798},
{0.1253095394626345,0.020038005523081652,-0.1199419342817089},
{0.07600582870574685,0.022561953762158866,-0.1824243234257138},
{0.13497167617599964,-0.07394113447395445,-0.22082422929831624},
{-0.003419851401476999,0.07345260197804471,-0.17805097853945032},
{-0.0012523137674189209,0.11198372505173,-0.11708849305763042},
{-0.013151674016021712,0.014869934016696642,-0.255403407040746},
{0.08365340711355491,-0.04437507842065042,-0.265603871368452},
{0.07904697447531107,-0.10904307420883606,-0.3310712163698837},
{0.13763612398144243,-0.13922749194189388,-0.28237660971348966},
{-0.09445785722818745,0.10349823038026304,-0.17440352948989168},
{-0.12712688778322434,0.021257044055809457,-0.2639989888294417},
{-0.04054063742374183,-0.06191365527703318,-0.3458052672168342},
{-0.14924718561380113,-0.029118017721026814,-0.3127283454888427},
{-0.06764664360298388,0.1372654676102118,-0.11873799043644968},
{0.05728483466431283,0.15017898513273026,-0.01787004652664765},
{-0.14924595870570634,-0.029118017721026814,-0.3127283454888427},
{-0.18868050749950357,-0.03408648739131048,0.12312521549509824},
{-0.17724300998701326,0.021781144493455733,0.11837621365764225},
{-0.18711031299844494,-0.03761476524653446,0.11413036806914427},
{-0.17726158711058934,-0.04748213022302145,0.13383648255958508},
{-0.16793460698827886,-0.043197816728199244,0.1199736603900176},
{-0.17894331871117072,-0.03836833467693202,0.10303118736552846},
{-0.1790545088063838,0.026780633870417653,0.09669522328305226},
{-0.1841096180169743,0.04909196996645465,0.1050356949391175},
{-0.18658683221135167,0.0541812838875654,0.11495232213456032},
{-0.1886854647039268,0.025144620087629476,0.11323931057406839},
{-0.2046650255552253,-0.029309006414442878,0.11824856564374402},
{-0.20696878716683376,-0.0332640871774963,0.12401290209116632},
{-0.18333086598810674,0.07409498131322918,0.11497396033186774},
{-0.18926934902691717,0.05414033737902951,0.1588385396445081},
{-0.20301427648228917,0.0245039385949599,0.13507455675729826},
{-0.22206545751734363,-0.0244070004624639,0.11257816822014197},
{-0.2142559644200618,-0.026365629109116002,0.10999853818238065},
{-0.21585714144876567,-0.02959900287320205,0.13389722070678073},
{-0.2164433308718128,-0.03219159600053013,0.15612035574311744},
{-0.21965188143474954,-0.02778589296239389,0.1614344912778329},
{-0.19223111756065436,-0.04685127638812095,0.18354237131132947},
{-0.1944618347650865,-0.04255468141934019,0.18943400876834038},
{-0.1648983068860384,-0.04557729963737261,0.21678414487241554},
{-0.1637593891698009,-0.04973887275067553,0.21051204197592158},
{-0.12278878862041004,-0.05992496118555418,0.19616579323100056},
{-0.1446555626237717,-0.05467132833082429,0.199947000048909},
{-0.14122543741612756,-0.0574107538531685,0.18685085911543856},
{-0.12421703357280947,-0.05919597948909593,0.18786506596139857},
{-0.13550457565149698,-0.05496878538224026,0.18302434344910176},
{-0.1470461992428973,-0.05075633895854398,0.17072924957139235},
{-0.16420307135869117,-0.048676779309987074,0.16306911704338248},
{-0.14195265930501566,-0.05607663381975515,0.1642799266167679},
{-0.1557225462846586,-0.050901374366956645,0.1495619742911819},
{-0.16384366164499586,-0.014397723116350916,0.15560729747832402},
{-0.13779356479392427,-0.0056346249971830934,0.11862655248101543},
{-0.13600030848683123,-0.0570049447060718,0.15186459574577302},
{-0.09383877675379211,0.005276008436195112,0.16427505616342208},
{-0.12532372946029594,0.0293855208647153,0.11756199283112642},
{-0.11957088133412447,0.05225186556797741,0.12069495841961994},
{-0.07673938342328561,0.035412204963226,0.16513628368088118},
{-0.10949411164978916,0.0831030644749931,0.12121298628184764},
{-0.0753836004065428,0.06873336815315025,0.1634867863020619},
{-0.11716166759142281,0.10512913824249531,0.14537935784510225},
{-0.09513806003312118,0.09350444429797264,0.16873274788294684},
{-0.08810254765544955,0.07017716633442753,0.1819660050907639},
{-0.08798232305517513,0.039312347508258884,0.17225978643706516},
{-0.09022689564597021,0.04039079972354409,0.18692518000275385},
{-0.10326167878169215,0.06965543296189336,0.1964546743187644},
{-0.10894635295403313,0.08966142114090646,0.18771761391582956},
{-0.1318845895144431,0.10219199462173041,0.1673670380643465},
{-0.1442267768341732,0.11257976691856837,0.1278581312042008},
{-0.15734477903915012,0.10701534213252388,0.1469049375063518},
{-0.17499195585143484,0.09451671783420765,0.15200634700625534},
{-0.16745747606254283,0.09921515618654667,0.1207507269693813},
{-0.17209370149937028,0.07092070981887906,0.10575890149242277},
{-0.15660366458486594,0.09989431797855147,0.10107682191468044},
{-0.1713947356756946,0.0713953621424034,0.09191590814054823},
{-0.18368241853279127,0.07376982588209824,0.157188658082346},
{-0.16352890395014277,0.04501312020196425,0.18717230903626303},
{-0.20267060589263752,0.02571986648191241,0.16697581549126506},
{-0.14621963497736765,0.013158459189575962,0.2157113810492061},
{-0.09869831185687511,0.02216332016846482,0.1851386778866875},
{-0.11056240159600664,-0.003869835436490436,0.17948243328171376},
{-0.12013353642917231,-0.00026100300938873284,0.1714827446437236},
{-0.09390723574687695,0.015591926054918163,0.1771245018187704},
{-0.11805328277199632,0.06856072111610015,0.20521582673519612},
{-0.14766404041618678,0.08440739170982284,0.18188800347916434},
{-0.13334847676664557,0.03549872057342258,0.20833711810727296},
{-0.17412004555844363,-0.029996397165790424,0.18978049257150215},
{-0.18745236010364794,-0.025193299835065814,0.16103171841844532},
{-0.2020438913234305,-0.01833871302583113,0.1408026064683425},
{-0.197568762637347,-0.02033894501060513,0.1336270530657146},
{-0.17551663876060072,-0.026312401126621563,0.14107029550719702},
{-0.17250762806871012,-0.017805825943344844,0.1676396719146132},
{-0.162242484616292,-0.032750582764304696,0.16995219538503975},
{-0.14603492954055805,-0.03932009314017053,0.18642871597976718},
{-0.1494219394627311,-0.0371054124920474,0.1941185793413054},
{-0.06774670477426681,0.08112439632946013,0.2815198932520557},
{-0.05144279403755627,0.0847959126064935,0.27829316214189675},
{-0.057652175905085284,0.10045575855851568,0.2570845189907744},
{-0.09245471288581479,0.07942681406773554,0.24443639780006457},
{-0.09537353963623574,0.08820646924967689,0.20070672880580245},
{-0.07661299949651533,0.0915191582845348,0.18646218950263507},
{-0.05387303872002354,0.09739958006653801,0.21463275533176615},
{-0.037514264123358884,0.10124639548498807,0.24765639950521895},
{-0.03204894624674593,0.08649007439716624,0.27048432587420096},
{-0.02978473073342377,0.060463734948292984,0.2857774006639593},
{-0.07589916205956995,0.04708861494289397,0.29227868751395025},
{-0.10184020041333042,0.04017238529665635,0.258682449050581},
{-0.11461968752125591,0.06815924952287357,0.20800470037166208},
{-0.10648883125422703,0.07000111121933644,0.19336509666198523},
{-0.09261360368059042,0.07066041940762613,0.1776495193392349},
{-0.1007698284412552,0.04151955517071384,0.17683454253904454},
{-0.08640966234491594,0.03914376537883579,0.17376429797951598},
{-0.07490149988337245,0.06868126793466206,0.16394780631342243},
{-0.03299455777649948,0.07302627000463568,0.20473320570556133},
{-0.08019208869707757,0.0357815290857679,0.16183106763169144},
{-0.03554044164514963,0.025392901671166982,0.21688426800875374},
{-0.08108562479436508,0.013394831089486605,0.17253862918587193},
{-0.08228526826478713,-0.0069544682818574715,0.18031028642039346},
{-0.041192522198407855,-0.016991543151773817,0.2273615798104862},
{-0.07505890351682112,-0.06353473548149621,0.21018982368841158},
{-0.07135091460824382,-0.0599420759338255,0.23031111644230903},
{-0.07826993268196947,-0.022670107569662992,0.25415526971805363},
{-0.0841987491721546,-0.057250301538999585,0.23963933586572536},
{-0.0870615347265709,-0.061958381653941755,0.2168151397930718},
{-0.09268300454251567,-0.056582293456946896,0.22275881550351556},
{-0.10965184989453639,-0.060793798011803034,0.21706954352407207},
{-0.10579479784895249,-0.058152512744027766,0.21145762871965307},
{-0.11149682223677476,-0.06055921070548465,0.2000387083307388},
{-0.11987633187767298,-0.06023736420830632,0.19895429507713477},
{-0.12222422500165923,-0.057075572476091706,0.22141541310481977},
{-0.1314483555251987,-0.05320152961234711,0.24143633486215793},
{-0.13717143563880868,-0.0485479043879942,0.24332129945108072},
{-0.10939868546464195,-0.0531011090437436,0.28148063219302366},
{-0.11461864650832707,-0.04824430040309327,0.2841884927162029},
{-0.0902217525463811,-0.03412242712337887,0.3212498046784001},
{-0.08568343189691248,-0.039201145020034946,0.31784916244406314},
{-0.04137073369742302,-0.03808988850447923,0.3226780496307995},
{-0.06333759365808972,-0.03992730110997204,0.3168341748384065},
{-0.05427514235681398,-0.04483261599590362,0.3076714392916487},
{-0.03925673387113589,-0.040247065581292756,0.31478066529909376},
{-0.048029758792161266,-0.04173181027110594,0.3053173496621333},
{-0.05385816710675383,-0.04539509758879673,0.28935639072043307},
{-0.06665397581024282,-0.05680789583024832,0.2779312614329787},
{-0.045518922358783326,-0.0501862852358943,0.2875308877985669},
{-0.05248254287930702,-0.054435799155665585,0.26838740361715185},
{-0.03480888220239121,-0.05240956663369169,0.27911603329013107},
{-0.018545955153249773,0.01154967285208233,0.2800675934651925},
{-0.00760992844021357,0.05461895546609264,0.27330372349690296},
{-0.012697259479555103,0.08446630808439284,0.25922652702205284},
{-0.02135502939774039,0.0561916285693628,0.2742902195701371},
{-0.02366911438756019,0.0342512152942942,0.2858941180421043},
{-0.032669439524401794,0.04070310360220766,0.2886746883611613},
{-0.08556864782849255,0.02461937949296592,0.30328783299222917},
{-0.13260173588534097,0.00487510692147735,0.23389922775492158},
{-0.12101734401277926,0.03420640216630809,0.2202909208534539},
{-0.0410524935664626,0.009374513516223669,0.27882482231628836},
{-0.03526246640711691,0.011698203089613534,0.29021398708565216},
{-0.11926477396098993,-0.0036145394086939814,0.2063579170622645},
{-0.10070338950897283,0.02237748379255945,0.1832197440544545},
{-0.09355548491401552,0.017623351248525317,0.17724425548462464},
{-0.10840973557521827,-0.037163659644020366,0.25264332236896797},
{-0.0904014388137122,-0.025081725556510014,0.26302618703342673},
{-0.09006242799621844,-0.03095269147107601,0.28909691824791006},
{-0.06874218578051808,-0.02747859586019782,0.30337661652344916},
{-0.062028879297345484,-0.030428120099009658,0.2987131140692829},
{-0.07068542230743599,-0.03476811539251578,0.276722942854816},
{-0.08933689155683427,-0.04056306257725165,0.2397273262442377},
{-0.10704029546028945,-0.043498966896910525,0.22374901708705608},
{-0.11430261233333497,-0.040867992614335616,0.22772966463192224},
{-0.09753488076476474,-0.005265313267652222,0.1919498024061415},
{-0.08883002979756985,-0.0036157663167888034,0.20144284887663022},
{-0.09280197744867322,-0.00673141886883409,0.18592060252638595},
{0.13366667971857285,0.23538830999860494,0.06992205620179703},
{0.14374020243401092,0.24096210390100928,0.08253938076002755},
{0.14414620986928467,0.23594976297158018,0.08980416384227363},
{0.1359965657974917,0.24021911810205537,0.06760952033835944},
{0.12156984923177061,0.25266300247052803,0.05963091221217905},
{0.11621233815835186,0.26414264861362685,0.06397836809834222},
{0.1210526021292395,0.27686516504971836,0.09573537218359296},
{0.10598289897079204,0.27720395279301313,0.08102274885276194},
{0.11170750342476216,0.27574871586252925,0.08839137297466365},
{0.11376719707659283,0.2776324535433573,0.09894402189061816},
{0.10994520485929223,0.2856754433619844,0.10812972168686653},
{0.11303930596510758,0.30800181218043476,0.1176827627238874},
{0.10615171656742517,0.30204792462887914,0.11814947112732362},
{0.10513297387941788,0.30981209648472163,0.1311534576305662},
{0.10477609233997841,0.3129239567753832,0.14483286323647412},
{0.10782622304255968,0.3158974986696257,0.1418682690962157},
{0.1043088758230888,0.30962989443614575,0.15486128778467187},
{0.1054477811463152,0.3093746108013605,0.17097715936459817},
{0.11232146558559043,0.3118370029545123,0.18538123389911623},
{0.10531764213719434,0.3056145836393501,0.1841868698514049},
{0.09797602238638821,0.30211856479191024,0.1950381903338591},
{0.10547468637332234,0.3084605766637828,0.20467218251911137},
{0.08662775455351601,0.29944787090889424,0.20782901704690274},
{0.05988433069880017,0.2873429477858711,0.2359147403223302},
{0.0661119426855956,0.29054323221043193,0.2463647751067238},
{0.03323249119580354,0.2673896299038546,0.2470330558350197},
{0.03478529830234774,0.2697703397211228,0.2577555013954809},
{0.011095462800298368,0.24523232654225846,0.2467808704529988},
{0.009677045505668051,0.24607609230713673,0.25375998223734514},
{-0.004971481171970573,0.2381841980793297,0.25742335630611335},
{-0.019041452521373833,0.2211770831091618,0.24987264167273526},
{-0.01997888466382909,0.22200875329524725,0.25620643697827633},
{-0.039368270970658606,0.2086256026186828,0.2467455379784722},
{-0.0493018394122178,0.2023233970983287,0.2483804611762872},
{-0.04836004492987011,0.2006666622010516,0.24030817427951884},
{-0.06361025229437856,0.2038369679318631,0.23409723089259651},
{-0.06763922018936011,0.20627223178380874,0.2409666769220899},
{-0.07364680665783041,0.19817826951069986,0.22971879247878818},
{-0.07620844204353537,0.19876080299548488,0.23604754382882856},
{-0.07296797947712408,0.178312124068466,0.2330894931984088},
{-0.07377833368418979,0.1804157013724534,0.23915364136934816},
{-0.0607827744284667,0.1753236485958987,0.24414642612732762},
{-0.0548825857938257,0.1825863124732538,0.2485901013513457},
{-0.05260855501574558,0.17800369920226367,0.2446017577466125},
{-0.0348161073278381,0.1842541019363948,0.25923093893398946},
{-0.01908957458331238,0.1853156252985746,0.26709608904393317},
{-0.03151341945290416,0.1688502955928326,0.2637692719764692},
{-0.023633472087757148,0.1674913027862258,0.2678574908573194},
{-0.011328624910345059,0.1879822542739636,0.2655411875185202},
{-0.0026543103223972656,0.20655153307402468,0.2708535880316875},
{0.013082830839594157,0.20961594052534493,0.2688969050877716},
{0.017766001002309604,0.21703186877045527,0.27071114276258595},
{0.040380742795070576,0.2391557977532721,0.26699820904259647},
{0.024784150771488853,0.20067554798998016,0.27903675519839255},
{0.06430691301799743,0.23079974808230683,0.2717227098971906},
{0.060415284471561526,0.2541179543617576,0.2600804302699766},
{0.09801445311367932,0.24539324979084765,0.25070138710821116},
{0.0866574853870444,0.2671999672626218,0.24293593877222974},
{0.1211704596644019,0.25346961398825407,0.22647132786112906},
{0.11783583499997127,0.24983734637724173,0.2236387688606834},
{0.09428497472392722,0.24380885289911655,0.2472660940149558},
{0.06811255885371241,0.22884054935714626,0.2634361602322391},
{0.02482168920198375,0.19864544884855623,0.2727403372142027},
{0.017286106435107543,0.2561263161617856,-0.04056081944224992},
{0.03230545678962609,0.2529182861053135,-0.03366616602826445},
{0.029597608659457837,0.24805401687200615,-0.031901401253593954},
{0.009548170583675089,0.2519280597357507,-0.04130645734557033},
{0.2045019087436789,0.10526273490170138,0.14979596673296947},
{0.2126498054009127,0.0868866259650025,0.17360567983098363},
{0.23926010353084262,0.034356357600110896,0.1868600051575994},
{0.2043759213932625,0.08120372399324285,0.1536636519820412},
{0.2282575635274577,0.027406369391751055,0.18226466426425256},
{0.22673571416253663,0.029805606760550968,0.20284327151920425},
{0.2414536417021005,0.03381732358413965,0.21089375910952152},
{0.24820288791734155,0.04527087004595017,0.21321001287627653},
{0.2194907227189503,0.08884969130961347,0.16274320563857714},
{0.2087020613004057,0.11470509395696256,0.15464997455312057},
{0.19929582787237882,0.13166142236781464,0.14906432053913365},
{0.1871511975419256,0.12310152005795509,0.14833386407435942},
{0.18116289459866167,0.11687891484762716,0.13748129189778832},
{0.16198348307818924,0.08515652444226154,0.19929019524885294},
{0.18424876674513446,0.0565361666697886,0.2075017919829252},
{0.22349246316863733,0.0694694510449448,0.2279068970830638},
{0.1623899490548721,0.14417082858575148,0.1416788171361708},
{0.17942660896340265,0.15426870356791864,0.15231325992510866},
{0.1509549301445934,0.10594085568077728,0.19584122027138948},
{0.2645227112802507,0.04959620440737479,0.16387575334713075},
{0.2403370437987786,0.10044583175665822,0.17339623794410208},
{0.2820011076749354,0.06944968419230724,0.2051620038881709},
{0.27868099522645384,0.06268559114981859,0.20408133332390635},
{0.26884341065553946,0.057696127718802705,0.2489873964998456},
{0.27163432913882996,0.06450484799411135,0.25099011947984223},
{0.2524727759472922,0.11576851344983423,0.19878991417846037},
{0.22482947077362714,0.14018937549516647,0.18750204988148533},
{0.2557851923359067,0.04510020589066947,0.16852769312197988},
{0.25880245677316194,0.04516005174106895,0.18315253675548654},
{0.268923977620428,0.054361205622106716,0.18573843765684325},
{0.15759506829047915,0.1663171765255723,0.164434864041016},
{0.14144823896892977,0.1635472889820473,0.19658481332788527},
{0.1326752140479044,0.13195131968248525,0.1893361411600147},
{0.15637933869170367,0.15510151391102156,0.25985980988712065},
{0.1728935464330587,0.15970890081111694,0.2604843928584258},
{0.1523280509838065,0.168777201613612,0.24238442499412308},
{0.13209150322706886,0.16165863127582925,0.2321044223214463},
{0.1633999918491167,0.17313204373436575,0.20821938450222116},
{0.18815462246826514,0.16635045176026325,0.21905377613157007},
{0.21632558487375,0.13629140172706872,0.23065691862986265},
{0.19737738976058813,0.13390333046123232,0.2690127425621315},
{0.15002606157277934,0.12384403492248876,0.2698480686864792},
{0.1375642693033277,0.14715136013823052,0.25509097923197177},
{0.21174008403118333,0.04403102364765573,0.3019469959468224},
{0.2522157448979476,0.07033080249251446,0.29332960245866435},
{0.21800054989029363,0.1191773598574917,0.277825697764786},
{0.162239051752229,0.10789173869551809,0.2717512014296132},
{0.2501572657612006,0.06356548254193116,0.29051268343817394},
{0.2308885873820769,0.052417894737122474,0.29283386962333013},
{0.2239050388997718,0.04337077359052553,0.2850770468230451},
{0.2097696820240261,0.04076853870059431,0.2944003462210713},
{0.17834224528184286,0.08358262443089656,0.2721078227158204},
{0.18282851528486752,0.08370781862860531,0.2599230142435169},
{0.1570282367507047,0.09785522151109936,0.27017758645750245},
{0.22122702074722042,0.041865332572245305,0.26694858742631994},
{0.21595007663869023,0.033647502153610884,0.26626449321591394},
{0.23299169375164397,0.04151208218504584,0.2521550501262907},
{0.22124314405460696,0.03225704349192745,0.2461878153018255},
{0.2064507964836393,0.026277341298338013,0.2594904733715678},
{0.15557247931375637,0.08233171107372718,0.26406379188426443},
{0.14302961196596276,0.11558763745344157,0.25964168049948744},
{0.1200318765594629,0.13577828149722002,0.24680625133964576},
{0.13165529402384657,0.10772050446172857,0.2606814541272603},
{0.17797293355231208,0.17214927795746018,0.1752341338770263},
{0.19937988966638576,0.16606906844418953,0.1754946969345224},
{0.21673824735596195,0.04311945571927872,0.28369402396799664},
{0.22780272762861514,0.06530049169705107,0.2790578109241802},
{0.24598675728692476,0.07160015665013818,0.2615216259189317},
{0.22266831554026395,0.05933573547479763,0.27537460803771907},
{0.2290643609403497,0.05852524494461031,0.25222692959042753},
{0.23660051378573457,0.07321339207860153,0.23466976321745767},
{0.23566238763466005,0.0554716194129105,0.2098626729825004},
{0.24994036328166214,0.05997272385017189,0.19106743241181734},
{0.25585558463871655,0.06568096952954526,0.19388312452421294},
{0.2531476869365042,0.06741097190819784,0.21955152902770672},
{-0.07485070093104539,0.19151458464380372,-0.09790659054193526},
{-0.088056978553789,0.19673844948597222,-0.10736919977726535},
{-0.08285658607456461,0.20174880753363192,-0.07946577769450225},
{-0.07205237142714212,0.19217889960856108,-0.06055653381509593},
{-0.11165052035991704,0.20126914843364008,-0.059726202074204614},
{-0.12440710518340722,0.1977990185863005,-0.0842844406471157},
{-0.1381269243983755,0.17169325232955596,-0.11531256217999658},
{-0.10097630839849385,0.1738278493402216,-0.1328310747514763},
{-0.06155286374260467,0.1622796450599495,-0.10716227367162863},
{-0.0618950471709293,0.18214919858022435,-0.08432632902449201},
{-0.1145863998935539,0.08380322002773029,-0.16033267823670327},
{-0.09085379611034317,0.12228724965939491,-0.12525672664601045},
{-0.11012741930087913,0.07540073374433053,-0.15801891546517097},
{-0.13415125884395476,0.07744436605382989,-0.1591813799024188},
{-0.12607846383373295,0.07070627354854114,-0.1455081708020399},
{-0.10590137774405198,0.06660293519419998,-0.14826312476723985},
{-0.07081968818923921,0.11415574895579114,-0.11802029877306523},
{-0.06508109202578453,0.1370344866701112,-0.1158088898798616},
{-0.06909930278716774,0.1473806556288271,-0.11848677170929134},
{-0.08007312818393106,0.12413506000116561,-0.13225629929161362},
{-0.10122922496816714,0.08780746386565098,-0.1707081070945273},
{-0.10631615943115484,0.0886019674115734,-0.17596849414028382},
{-0.11129817466252481,0.16162564108039265,-0.1543799928072203},
{-0.08655032302042515,0.0917215981201685,-0.18203073378752024},
{-0.08915223569206888,0.08711222833830393,-0.1754385318084072},
{-0.10795740306460944,0.09909251494911595,-0.18476671405279027},
{-0.1256769302754512,0.11037521136047984,-0.19248757233498476},
{-0.12618256512662085,0.11760280301654054,-0.19482364252642165},
{-0.16351775024019047,0.1003405035556756,-0.1748461210938089},
{-0.16509783436407346,0.1075246824939999,-0.17686740880437055},
{-0.1997536504868864,0.10635972706152932,-0.14927686067877968},
{-0.19720192951002788,0.0993514917011967,-0.14774756311421272},
{-0.2086868302898153,0.07775666993249346,-0.11046589102239188},
{-0.19961484876303587,0.08702542768885302,-0.12922376666473478},
{-0.19212805728069537,0.07719115205189121,-0.12305668214394704},
{-0.20125569582013664,0.074038816187114,-0.10890540024899169},
{-0.1906051421168233,0.07638974559880943,-0.11595827523515567},
{-0.1740332077299597,0.07471297120265129,-0.12092911197055127},
{-0.15952718828647788,0.07451838853602848,-0.13304823748424702},
{-0.17360935435876232,0.066133302040154,-0.11623587868285666},
{-0.15373469491793162,0.064229710755611,-0.12209899982142293},
{-0.1404159135408028,0.10590492834171991,-0.12927454083103976},
{-0.11994019306365526,0.08761656192331245,-0.09224671478472153},
{-0.16697538793238353,0.05783983707503216,-0.10742322091246753},
{-0.16806506821568726,0.10865721780954252,-0.05449374887537296},
{-0.10670347820575299,0.11871368774176475,-0.06465169278213871},
{-0.16287331366517036,0.1339527785753539,-0.027304845845163413},
{-0.09496826338861443,0.15592193124306636,-0.03396731619697578},
{-0.1474948138501887,0.16051475635516843,-0.014160818316964537},
{-0.10014855440390262,0.18869148151079546,-0.03925913191877563},
{-0.13189571843837328,0.18649051992591367,-0.024805175514748833},
{-0.15562834700760617,0.17341220014234482,-0.03067821106216154},
{-0.16172075124375793,0.1425263008043664,-0.038146251918771176},
{-0.17168996198512015,0.1516799894530518,-0.044319830377353354},
{-0.1604331050018124,0.18283081418841862,-0.048794327019872887},
{-0.14227114729619725,0.19541964721422656,-0.04425972427372168},
{-0.06129398613461245,0.15210358257101686,-0.09631531552906683},
{-0.05178482874974823,0.16884660247553726,-0.0692874101055128},
{-0.050933416497047114,0.1441188275113517,-0.0917063671095782},
{-0.18375531422383487,0.14847763539564401,-0.1184128473983299},
{-0.18766923779716435,0.12815158531304502,-0.09373511541279685},
{-0.17457491863631938,0.136699206148946,-0.05752805370283309},
{-0.17637795302913722,0.11358617856057274,-0.07521870519790955},
{-0.16429849754383843,0.11348453108387441,-0.07998259104164626},
{-0.17334735371198348,0.12626964461882023,-0.053046009716579204},
{-0.14724324811872075,0.11143721805009076,-0.1417035040141985},
{-0.16794080349380788,0.10574257989685915,-0.14367893758384528},
{-0.1400451270429561,0.11306718404348254,-0.16572025475494895},
{-0.11451081491911069,0.1092300103876358,-0.1699508693328565},
{-0.1852055195918292,0.09905158083359109,-0.12561363297147207},
{-0.18168711896641837,0.09259487164437605,-0.12098362882619575},
{-0.1587427230795125,0.0912093082220607,-0.12798320147179895},
{-0.13077912053505136,0.0979027858875403,-0.15060166116787735},
{-0.1120929508546905,0.10252292519601446,-0.1649825235926836},
{-0.16127007939663085,0.1883811605139011,-0.06461473682316353},
{-0.17141154059868938,0.16498334153141328,-0.09096857398225758},
{0.11702160178044443,0.24886696121838311,0.06198557192020306},
{0.11100234109555746,0.2637770176083804,0.0653192918948264},
{0.041942262188388535,0.26245226669132693,-0.018081954622729747},
{0.03936577997543597,0.2583079942214611,-0.013979867962505511},
{0.023613990274373896,0.28653284143902646,0.0015913803534624324},
{0.03772990251576953,0.2724979423109175,-0.005878556633839077},
{0.038934490797603735,0.2734460076568607,-0.011050160148375572},
{0.008470908097451537,0.28966011863544433,-0.012711604389854848},
{0.17461320064747787,0.22711603708239228,0.11874308396399456},
{0.14294035750032247,0.25498546513582304,0.10668468420448342},
{0.13047794558031794,0.23514795994214466,0.06162493529841296},
{0.194025352915621,0.17189814598137912,0.07223408395178126},
{0.1291427845339758,0.2025037030162127,0.032043239265153685},
{0.16379904680518678,0.20925645645358332,0.06000392945201618},
{0.17979966338227293,0.23020436304505465,0.11367062453792272},
{0.14291681077931215,0.2666236674623991,0.15551687806964426},
{0.1817044443958776,0.24130230444756462,0.16874144777670963},
{0.16062104501450827,0.2560265648157791,0.1925765665473928},
{0.22269611306406722,0.1895532171417078,0.13678371409135115},
{0.2278142531288991,0.20256297878810353,0.22747734292677974},
{0.23851527117324098,0.12172834964669771,0.09624727789835799},
{0.18350640059673337,0.14192278595186003,0.031974643948947216},
{0.2680030405756911,0.14400782331130452,0.225742618810914},
{0.2991505687701166,0.09750623431970386,0.23166323112777873},
{0.3009933599424087,0.08624339151205507,0.17798660924001464},
{0.2800368030292188,0.07105081164896676,0.11253539993898054},
{0.21644703638211923,0.10550091618122669,0.04380252130976703},
{0.26295055868344486,0.15880328152804776,0.24440944300101322},
{0.2654378236097903,0.15486475782776804,0.20381241737695713},
{0.2643187594972679,0.1443431038324697,0.14967230926863198},
{0.24370050699994134,0.12481667560936006,0.09117605777339195},
{0.2068846014427163,0.16865201980891445,0.07295585291580378},
{0.254328716104317,0.07002464554733566,0.06452363579887559},
{-0.02226342471528653,0.24821267219957177,-0.06968273476525447},
{0.04758970775551099,0.22561654470942005,-0.03747391867585931},
{0.037926951391592925,0.24659414495538662,-0.029151392099806165},
{-0.005299908358020772,0.27212872972547525,-0.03680903363259336},
{-0.052700672266940266,0.28822105458439123,-0.033031631469079746},
{-0.08891181127754214,0.2820268169763751,-0.0495971338832042},
{-0.07060609464365322,0.26833892215789246,-0.07273759959805995},
{-0.03548799442235186,0.22735297906081176,-0.11785020469629313},
{0.034489117731070704,0.2231131192966548,-0.06375391827506932},
{0.0540961005260579,0.1557892764527008,-0.09187862996328551},
{0.009915127641104794,0.17826947971741522,-0.11050206622167039},
{-0.04616582514300403,0.21836229568657328,-0.12053671206141932},
{-0.13498071068106093,0.24143902414555735,-0.11974053545900405},
{-0.09204476447302458,0.23601046393974262,-0.12250547819111683},
{-0.11819773570888928,0.19597361480852277,-0.16335283024553512},
{-0.06555966054080334,0.17969171405945147,-0.16604335294624412},
{0.01549184629411886,0.1891612014159188,-0.11022027393623178},
{-0.008862874251196442,0.15188053315799366,-0.15054467810303226},
{0.037061906826727956,0.12472372802642437,-0.1278828180822285},
{-0.037420102025339574,0.10506976332651609,-0.19129289846199696},
{0.011113420273321536,0.09608720976753164,-0.1682505606086991},
{-0.14128295338044813,0.1878635911930825,-0.16597017221594618},
{-0.15350295800415661,0.1460124919940372,-0.20155552613317027},
{-0.1579817798075354,0.2039088226099778,-0.15845139437206474},
{-0.10151799451883144,0.12937612634268264,-0.2072451699029456},
{-0.0440230735310621,0.09077428874789989,0.29018302934402906},
{-0.0383447074013497,0.09215653084325177,0.3060583897583512},
{-0.03301190799198075,0.10933288477242896,0.283608524584707},
{-0.0314615547016261,0.10885567948862658,0.2598759084084851},
{-0.002950168675386815,0.12067495609977207,0.28464334100805655},
{-0.0015701449290143566,0.107498025127214,0.3092111717715266},
{0.005477078844107094,0.07156639808801597,0.33138852702501476},
{-0.03013882384537517,0.06145481643561865,0.3243069498252402},
{-0.04966293457541704,0.05945090372656035,0.2799753646768983},
{-0.04654135816408594,0.08771073641434278,0.26958583257249025},
{-0.0004976041800039879,-0.02882935970746206,0.3198233691056152},
{-0.019010246919529655,0.018990275582209348,0.2944214267328811},
{-0.00064382931747822,-0.03552905866449295,0.3126874733383731},
{0.018747527478109486,-0.03178019760544608,0.32656516712121025},
{0.01958653432674139,-0.03199332021661182,0.3093376424493743},
{0.0025597516480242223,-0.039002770092028426,0.29972066586830476},
{-0.030377091875977844,0.012858535928959323,0.27587165453222545},
{-0.041974248549929385,0.03366216308569256,0.27931253687346796},
{-0.04298386998179793,0.041840174759797524,0.2872173694048196},
{-0.03166105739363906,0.016137392043628518,0.29506586330790124},
{-0.017422739382022823,-0.031677335613663954,0.3225770961627204},
{-0.015469216655926791,-0.03295641828496837,0.3295562946981441},
{-0.03555247525888702,0.021688196910520048,0.320295555219939},
{-0.035829632558189904,-0.03519349310407326,0.32536205360769194},
{-0.029435272607608007,-0.03580298138790969,0.3198642784351179},
{-0.021041498610981993,-0.02781935409225076,0.3410761437691153},
{-0.012694805663365633,-0.01979243800896606,0.3602295423593768},
{-0.01555511261557027,-0.01454277091777461,0.3649426168577755},
{0.02417566632154815,-0.016401648218420235,0.3659947834966064},
{0.02246916109186172,-0.01082359112021193,0.3709123178914412},
{0.058453495607089664,0.0033218288805128976,0.3703657861037799},
{0.058967805565999946,-0.0024942112090435833,0.3654804735376961},
{0.0911286235235672,-0.004547757927389563,0.3346643220659526},
{0.07259763912767556,-0.0052169929175368964,0.34793815399197386},
{0.07171717765705435,-0.011942605660690142,0.33590632484817123},
{0.08653358006248568,-0.007810812952959621,0.32836216611764285},
{0.07371050673466899,-0.009678489291456458,0.3292544629138246},
{0.05789828871168769,-0.014733573716024918,0.32410267582397},
{0.04033488865415566,-0.021419665146913874,0.32614998885775354},
{0.06205116193122796,-0.0203947259533776,0.3172815625376031},
{0.043097290819001474,-0.02631732115201153,0.31106152268056414},
{0.021819730133385215,0.007200791769647459,0.32039098140508626},
{0.02546576637968321,0.006042057628728176,0.2744488501116806},
{0.0625939758155718,-0.024511671833860518,0.30412018479392294},
{0.07166143389331504,0.04565077779993572,0.27959436633793977},
{0.01620339102401847,0.0459721533626938,0.2565751538432763},
{0.07155785310689168,0.07836273774527769,0.26455550938401584},
{0.007538011797043533,0.09078052243246222,0.2399702540469982},
{0.05638135937215674,0.10661879056468744,0.2552743957956313},
{-0.0003327523469093797,0.11783198697003767,0.25828589748274455},
{0.03092487535775602,0.12391570370543772,0.2644477025808216},
{0.05245899615829673,0.11160816724462595,0.2768407136389009},
{0.06340820903509872,0.08119455316505997,0.27541303876501017},
{0.06660337514609276,0.08751454265628227,0.28849605549977014},
{0.046014618015084434,0.11250668533235882,0.29678106843135044},
{0.02880319186461286,0.12425400812130119,0.288138182519446},
{-0.04218024517973676,0.05570827635207564,0.2676760695684402},
{-0.04475800387282834,0.08220454638726024,0.24786336278988885},
{-0.04657231590570901,0.04984762142271,0.2558989787669364},
{-0.024282890653222627,0.035387245438954995,0.34764702976920847},
{0.04549775509589621,0.05886874203210704,0.34708535372203425},
{0.06771799016764526,0.06856090701126591,0.29532917761385225},
{0.06833564544576895,0.0402752596814495,0.3023938507465435},
{0.055992231217944104,0.03709398613585164,0.2999177147441282},
{0.071630476151692,0.061085789745342095,0.28763687282913564},
{0.04239709808723111,0.0789651248337778,0.3296212092900663},
{0.020744029166555,0.00704959703473898,0.33557487376742284},
{0.03387316029546201,0.0025781862519729786,0.3494129099148742},
{0.010055255417138522,-0.002865034885923421,0.3476982500839115},
{-0.012712143485835877,-0.01122392255642105,0.33655393403402223},
{0.05835557842671982,0.005931722651278051,0.34176147728062706},
{0.05922186229269055,0.0018866314489100397,0.3341199466622154},
{0.03700611349094446,-0.004324720907377208,0.3273967505562185},
{0.012717051118214903,-0.010187829652932492,0.32561710177526726},
{-0.010586729696364231,-0.014964083721705096,0.3290041116974403},
{0.03820158051663996,0.11063306034855415,0.3116680614277687},
{-0.20278117633729775,0.10451890637799552,0.1285786484741065},
{-0.18683642745406143,0.10202095867611803,0.1336468942764186},
{-0.18007975782519658,0.12189069809155866,0.12537705039037336},
{-0.20629165782864242,0.12521917582250433,0.09456826036719836},
{-0.18143306223972777,0.137600091301791,0.09736388819469094},
{-0.15639546199909019,0.12122515621870646,0.12326528130607663},
{-0.16626525600574454,0.09824732398796591,0.1352406354984876},
{-0.17718489915816193,0.07002890874313962,0.13435227967982236},
{-0.2218156392004349,0.07571606151769221,0.11629670358112972},
{-0.22934445538327336,0.09114360047743077,0.0827364048498289},
{-0.20941917049227038,0.13428559288731876,0.055764292762058326},
{-0.18543973510781586,0.14593183827807127,0.06657593082310458},
{-0.1618037968108581,0.14548697875313052,0.06392010855335818},
{-0.1551945916205734,0.13470757491384627,0.09378974380554086},
{-0.18637416814159502,0.027056911265935298,0.11104326901457671},
{-0.19303912948863008,0.03485086352735035,0.09834540227747976},
{-0.2127799444100335,-0.01598779600714672,0.07247993650515143},
{-0.17504199883008734,0.025424764102597343,0.10771574554548244},
{-0.19995072414873194,-0.019177757053496378,0.06851789086988348},
{-0.2097325153838629,-0.00953846065951112,0.05293120086213717},
{-0.22693276303836005,-0.009144362907864323,0.05416182686020444},
{-0.21977581154533032,-0.009213763769789583,0.07348253109975005},
{-0.1935100639088371,0.030157617846644585,0.1104434472793657},
{-0.18491625432072262,0.05374247215202106,0.12528677969782628},
{-0.17666423158457883,0.04759333271124539,0.12341522434686834},
{-0.16510776116593098,0.06722262292613716,0.12613425097301093},
{-0.14469893816247495,0.09267910694053771,0.1321944333804117},
{-0.13759774282619552,0.10880490532232161,0.08159626022549667},
{-0.15529371092301586,0.0660930247542153,0.06672939347903678},
{-0.1533752852042363,0.06056263117653632,0.12935395524589993},
{-0.16524905388500416,0.042473767450141815,0.11716914677359637},
{-0.17416829155049277,0.028314826674352592,0.05202155385047415},
{-0.22000136434658735,0.02974245197619906,0.0567817093978824},
{-0.2398294756378839,0.056965522537895726,0.10977729814897183},
{-0.25188459124946466,0.0785099543236367,0.04041302039237128},
{-0.22810640597158227,0.10392407902624078,0.04729591283886265},
{-0.1872644076979411,0.11524526812995109,0.023753244343128005},
{-0.19464278511954555,0.13703618451262628,0.04800004654814954},
{-0.1748474285564755,0.13674988117116244,0.04106739616225998},
{-0.17426123913342834,0.1082856381589881,0.025693853551701572},
{-0.153468257573194,0.1320132475587425,0.03598626162844747},
{-0.16361688193564403,0.10650353556184734,0.01698280607897765},
{-0.17933679681226472,0.07445002868703211,0.012343296494219799},
{-0.20515578879312524,0.004170700565947224,0.011409656613148338},
{-0.21176992640181108,-0.0003948847078492859,0.03056677310672729},
{-0.22669978682347922,0.004307048473608096,0.034347880780547284},
{-0.21821553145311814,0.008395540000701645,0.012839810089250689},
{-0.22483836895556678,0.013496478566184937,0.01793333763412127},
{-0.23683440708343365,0.01852574834871943,0.004938745033260709},
{-0.23017478712416467,0.02094219960987905,0.003160868452890762},
{-0.22948077850491222,0.02468234838215207,-0.00925816792841047},
{-0.23579778128046958,0.028705218915693043,-0.013181249936911818},
{-0.2487370390869558,0.02552263171092299,0.005324688183631414},
{-0.265963324457686,0.026500477462438582,0.019580381196751068},
{-0.27071480489735356,0.03226072421621174,0.02105761572186306},
{-0.26612443360144106,0.007576349576751506,0.05192364906311532},
{-0.27089202495548415,0.012926338092458075,0.054544783294910144},
{-0.26429894307258595,0.0034791581558953123,0.09145735433838824},
{-0.25975070801427086,-0.0013701774990868413,0.08774936542981092},
{-0.22479061868396,-0.02066930550638035,0.10758787445738519},
{-0.2406196168439139,-0.010894231283243037,0.09439821586247044},
{-0.22931500958899934,-0.015349481579589246,0.08787964076205343},
{-0.21942632863349248,-0.020418272674387856,0.10105822000508224},
{-0.22227425496765016,-0.01450059750114407,0.08985122010526116},
{-0.22732562148890115,0.07492240069652172,0.019276752425828127},
{-0.1945137490884088,0.09679398318817405,0.01998249722655257},
{-0.18705278464111333,0.08984862996594985,0.014839447209493897},
{-0.20217898753697458,0.06904689893990847,0.015320903296089218},
{-0.19954174239080427,0.06401904196063472,0.027000076917223136},
{-0.2420658812343917,0.03431295727538553,0.020929980100975906},
{-0.2492794563949458,0.027445134730340777,0.04569442598488235},
{-0.2345284519088679,0.030305119464257922,0.019307722560462263},
{-0.2275264006610531,0.0207352239321981,0.04020605710770136},
{-0.23516297407504158,0.029705285336035846,0.058148658517588554},
{-0.22542082808228545,0.011289270903729982,0.06331034762327857},
{-0.228475705308102,0.003156927475374094,0.08571319371296848},
{-0.23590531543742052,0.006674138371723324,0.08853260372868152},
{-0.24720154501685979,0.017934428219094245,0.06816716865693984},
{0.1348338658930338,0.1413262607575904,0.27370349724761445},
{0.1342578139530321,0.14009850993808873,0.25677272322556416},
{0.11444635886859764,0.1508035928900576,0.2557713679320714},
{0.09405659631614893,0.137373076125229,0.2933288093059566},
{0.04997670082938552,0.1391418438424713,0.2849094313484846},
{0.10469056817066662,0.14608926669754208,0.23461648566291896},
{0.13012719858135222,0.1353271758947061,0.23678526259808289},
{0.14939819445354385,0.11317856003386155,0.24406233954729856},
{0.1489850982159449,0.11325410782927159,0.29248085470334073},
{0.11143112688515594,0.10548106257751157,0.31588490737039077},
{0.05482257883428257,0.12466672017555726,0.3134998723922634},
{0.04196829990462152,0.12139619216431902,0.3030853931565954},
{0.03823925527025659,0.13213474863915578,0.2674232645358665},
{0.06971004276512098,0.13837342758482613,0.24747051673235881},
{0.15473419125976579,0.08686175319180904,0.245581920991196},
{0.14842550419462835,0.06620392981017408,0.268006975356702},
{0.16522544519893853,0.012651287605035077,0.2900813818673307},
{0.1536719614959557,0.06268445099280112,0.24642590983027332},
{0.15945901433264742,0.0062031791654942985,0.279342837785505},
{0.14601506354383195,0.006522956029825872,0.29515508059450835},
{0.15292665820393386,0.009702990274318063,0.3106203190938855},
{0.1646640541910186,0.01962358323329932,0.29691985776218993},
{0.16020010400090956,0.06924517472382677,0.2634835263205031},
{0.15471381714958632,0.09576252527082113,0.25271909323857705},
{0.1405386043502778,0.10474251347651634,0.23562154646671815},
{0.14244462466498828,0.09964526802832836,0.2228778131956952},
{0.08570909782281382,0.06660256340386829,0.2512300853529599},
{0.10123538429466303,0.029552876086043574,0.27069748566439994},
{0.12081636655245041,0.03911151876406272,0.3112808789762922},
{0.12322184999882359,0.1263558751897625,0.2173852306947545},
{0.06774205739512006,0.107975788096514,0.2334118725950626},
{0.1981859841600836,0.03010996671912629,0.28776750755869884},
{0.16130937763469605,0.09654285121209298,0.3094706938160939},
{0.18688598710528273,0.04570344809693254,0.3328174412000113},
{0.1852426366599482,0.03908675752796867,0.3294428366819074},
{0.14568786326587657,0.023852103392338207,0.35353979499022564},
{0.14658638135360944,0.030329893093362998,0.3574497899790497},
{0.08530796084088592,0.07427207744124917,0.3539615787285763},
{0.19127433992793752,0.025962571210473767,0.28524068414105597},
{0.1822376165176183,0.023923772175287003,0.2997613025515642},
{0.1886271927659318,0.032652355758658214,0.30829540261240085},
{0.11383164073409487,0.03228304402912734,0.34636177537839724},
{0.1274057305320312,0.04173768455834708,0.3247372103831547},
{0.15540782576883871,0.04220041480523371,0.3271464984839227},
{0.1726365153837142,0.04308843601260029,0.308042572793805},
{0.16985424722214224,0.037696286473274214,0.3018324349526015},
{0.14757779745223362,0.031333739382078486,0.30813180247342314},
{0.10556427545026123,0.021384592925619294,0.3275429756936928},
{0.08696236585208417,0.020447693682639597,0.3426934441052057},
{0.08901711469250266,0.025677507170115764,0.3493125513113259},
{0.08355677880633502,0.011393372196617959,0.36075004882381617},
{0.10060213860862838,0.021383366017524472,0.3712271003723164},
{0.0310022077467585,0.08986082468883103,0.30391638172707275},
{0.0293943756711164,0.11521453346252698,0.287498690755838},
{0.06217634373592561,0.0580579664626654,0.33944523590688314},
{0.10065167347382749,0.027696365850510052,0.3754704673586028},
{0.0626818670499957,0.0034988258644444922,0.35615557544124343},
{0.03984491856896346,0.07303119003002564,0.3106346454146686},
{0.0701204868983535,0.09680135702975347,0.331651878509999},
{0.03650646446411594,0.06356566843709692,0.3052110424132771},
{0.031203742892584957,0.08309313767313563,0.29068493389887023},
{0.019900065113499787,0.10587770089642537,0.2694086249073707},
{0.021331470283719026,0.07594979370624763,0.28408441620933716},
{0.03983225291166202,0.04728566381871746,0.2981812556067144},
{0.08292598693648992,-0.009788737517829044,0.3167102447278256},
{0.10267545217961184,-0.003597238765256906,0.31513261442013213},
{0.10879758724929196,0.004241340728978155,0.3277809338990189},
{0.08675043296998,-0.0037447403828702436,0.32849970375436544},
{0.09065549554040285,0.003993517686849876,0.3330330795924219},
{0.0823516824110474,0.003608789051562757,0.3494164419230258},
{0.0773119157481468,0.003969970965839448,0.34415086220563584},
{0.06544067524163477,0.001099687639732973,0.34853921502829066},
{0.06345283626791882,0.04875707362863218,0.3101060091349752},
{0.0527489802240447,0.04779038158706888,0.3173745101205387},
{0.18066716176332748,0.024839776801622873,0.29263434214529505},
{-0.1575566995282433,0.1662303758761214,-0.027815437900756277},
{-0.1742949233374842,0.16817595468212937,-0.027954140480518315},
{-0.15564817582529908,0.17550158744867062,-0.007358294547184799},
{-0.13452428847680292,0.169208453612411,0.001538648091410298},
{-0.1691317718564893,0.17176019937529174,0.022342795754608},
{-0.1924346603742723,0.16530878200179835,0.00844741714499094},
{-0.21635410119219461,0.13618474747390308,-0.011783826403013873},
{-0.19478508167251443,0.14207217130715422,-0.04343231728344008},
{-0.14640849207288173,0.13987811262943178,-0.04504078140264607},
{-0.13772293702390428,0.16031770747934496,-0.024504025346037506},
{-0.2037665198605035,0.049990103870844634,-0.06527829581424625},
{-0.1724308037931611,0.0940411236418428,-0.04665034849983624},
{-0.19726638556054094,0.0427799243953206,-0.06647546068245672},
{-0.21764917084776395,0.03990102792652867,-0.053905217173235855},
{-0.20220004326276228,0.03558079948566012,-0.04760214414210778},
{-0.186710018741269,0.03548907881081926,-0.06141911217076038},
{-0.15115227645268225,0.0899355173664781,-0.05264728937180762},
{-0.14923210331934345,0.11407925929154059,-0.05209822940989047},
{-0.15595714598398805,0.12326074546402918,-0.05130460576775319},
{-0.16802632766311973,0.09767973647451708,-0.058299766501419686},
{-0.19959256612915344,0.05609622717023782,-0.0809926338358908},
{-0.20678509795693092,0.055602291321507014,-0.0824473378668992},
{-0.1895170233529129,0.10973434397264432,-0.06691662709010224},
{-0.1948678669863824,0.0623334809196364,-0.09823210537038678},
{-0.19238479089777455,0.057616800055019804,-0.0916778755771557},
{-0.21504912952078994,0.06511215510800143,-0.08802441591723392},
{-0.2358074106500617,0.07222202555202155,-0.08369925505796424},
{-0.23891185992011055,0.07907651321716784,-0.0848096564557571},
{-0.2573563782778499,0.05987854935914138,-0.053813508891406056},
{-0.2610656064875331,0.06653855350175325,-0.05391387988796544},
{-0.2760884144921368,0.06273636531612356,-0.016933147283667932},
{-0.27197765272417185,0.056410984865090864,-0.01791220755026725},
{-0.25658473983732966,0.03281063929589198,0.016599291958774326},
{-0.2613989784849954,0.04380731740504634,-0.002767935644283303},
{-0.25021079117596046,0.03572838785435082,-0.002976410876302306},
{-0.24907412898773554,0.03071159783395183,0.01335164144594936},
{-0.2448456336147189,0.035240028860596156,0.0019475926703048103},
{-0.233979441518995,0.03705059820413731,-0.011480222418113032},
{-0.22905941612893752,0.03990470865081296,-0.029492237082936534},
{-0.22953779874879043,0.028737366386377725,-0.008865309477869369},
{-0.21646812928694004,0.03101520181885276,-0.02487460116269619},
{-0.2141332736105868,0.07105327785816726,-0.028417750631189984},
{-0.17351022266330873,0.05817076764931602,-0.010933703023462802},
{-0.21780905308342421,0.02198074632955708,-0.0062342732302391275},
{-0.19691705136483578,0.07249707603944454,0.04518596552719148},
{-0.15547219506827434,0.08593733371096485,0.005971615753874213},
{-0.1474588617251092,0.1061354507404113,0.015629489271435388},
{-0.18225967607730167,0.09698818167145415,0.0666998485406743},
{-0.13299993572364813,0.13138250526094142,0.029997958685183575},
{-0.16693696959810347,0.12610059155497708,0.07224821198438745},
{-0.14608201058956766,0.16226093161325184,0.031666057973601044},
{-0.16474092803861184,0.1547557365094901,0.057973941847691744},
{-0.1849997956082651,0.13707088494358882,0.06463518529140935},
{-0.18888996177939618,0.10563971790507702,0.05814248679808162},
{-0.20197109477647532,0.11253939048854111,0.05963060238690261},
{-0.20068436561734812,0.14533456950313825,0.053455450015916034},
{-0.18559588704714766,0.16139219393109153,0.04869901237182521},
{-0.1381702999370788,0.13049390158205518,-0.03697759097599429},
{-0.11860669268079484,0.15005257641993788,-0.01869416936899887},
{-0.12571410930862545,0.12498649703988883,-0.0395330422491813},
{-0.21865254620205918,0.12235277150885909,-0.05992380863552569},
{-0.2480747317899899,0.1110295127723022,0.008966894989512445},
{-0.20920247869391986,0.09733869320320965,0.04853323106290128},
{-0.2167085413084557,0.0744254409530928,0.032169201829548},
{-0.20961973898323435,0.0768445319256078,0.02157317737489022},
{-0.20391852014113085,0.08738434168210618,0.0503100790233534},
{-0.23026214545911305,0.12570034686984533,0.022594460630164414},
{-0.2112922501835885,0.15075281872375262,0.041378113735508155},
{-0.2468386528670571,0.06906136158381336,-0.03038592189635673},
{-0.23276864433862066,0.0732096989613062,-0.05366727136092071},
{-0.2139820664826672,0.07441059412584518,-0.07137812346402181},
{-0.20796403270587496,0.06857348591748998,-0.06911762585401711},
{-0.214067590651979,0.06098527003265002,-0.04717333356648718},
{-0.22762306614730615,0.07479475268262348,-0.03437011384238548},
{-0.2284025865428593,0.05636635763227068,-0.02375303366194001},
{-0.2432221491661105,0.0529421810699345,-0.005177136993973914},
{-0.249768137606988,0.05853762556265724,-0.006290041780000487},
{-0.1453844327831305,0.04958958653946976,0.23062661771782564},
{-0.09635712335187126,0.04291825518475087,0.2798911665597697},
{-0.1364716642694142,0.010221129673645307,0.27385422104810286},
{-0.19169505786733712,-0.011095047634428002,0.22945713883631896},
{-0.18163625804903605,0.05139258375325434,0.17109595876860093},
{-0.2132571001217917,-0.008554467974510743,0.19994453383970845},
{-0.2088947478363367,0.04728972872634446,0.14699044928265256},
{-0.19544287791345513,0.06905692488585449,0.14550905070582504},
{-0.1481764914234384,0.046635910641953375,0.2352461993408021},
{-0.12090034159537995,0.11634243379193394,0.21713157054441773},
{-0.05098520689025884,0.08834072273846913,0.2939708540298426},
{-0.07138313643699479,0.04241552029816884,0.31284858248212816},
{-0.12581571960629065,-0.011653947647125386,0.30541153654617476},
{-0.08253255840744007,0.12630604289229785,0.23895548951554055},
{-0.11421956676623478,0.12831403290199417,0.21115155852555165},
{-0.02923946303289037,0.12386492953913275,0.2831896408109439},
{-0.15624798516749908,0.13308526780128843,0.15465306041287402},
{-0.13594576684516463,0.1301704439934393,0.18293267234630514},
{-0.17990253776706605,0.13552422477052942,0.12221187536613991},
{0.06512341415854797,0.21425082751697813,0.2606182745568862},
{0.07133750537027901,0.14749146154069748,0.27081630985442484},
{0.028176130291096155,0.1522473910713349,0.2722999143872206},
{0.036172076239746796,0.19344541576665245,0.2673650297769046},
{0.09309566702472763,0.24972330588948527,0.2560291425620794},
{0.10318730832233265,0.14652704981316872,0.26352726125652703},
{0.12432232459475896,0.26263191577962497,0.2302727600730843},
{0.14061651921079993,0.14767394862852767,0.24100711531717237},
{0.1492223748056629,0.25269770290149074,0.19732840638438112},
{0.15701632706707785,0.19028523512587536,0.19970290730310908},
{0.14556273103322312,0.231524193936718,0.15625920703901217},
{0.16232429088228648,0.2015492056975306,0.16029313213841695},
{-0.15661856098415775,0.23763277105230046,0.044760525850578665},
{-0.16900909344002543,0.17322999809376893,0.07101510738410857},
{-0.16923470820633774,0.1721016268299419,0.032226445147625266},
{-0.15096239073725035,0.2726466708366255,0.02060655969139321},
{-0.05702707242731574,0.2540472274476491,-0.040305102052077525},
{-0.10177205124552209,0.21705664239956052,-0.05194090013450817},
{-0.06456574105394537,0.22717427184135422,-0.06072009677504047},
{-0.013416797701587154,0.16094250113183803,0.2794405442846869},
{-0.03022963983040879,0.16952198439916938,0.2688881308359425},
{-0.035972350473534746,0.16111884128618345,0.27036582390246366},
{-0.016801824741990993,0.1510587897737655,0.2827583144540785},
{-0.03467768978733038,0.1407790845333541,0.280206395189043},
{-0.017623518554174798,0.17006971830890327,0.2714770184529642},
{-0.17519604395753927,0.17576037830558544,0.11358254740833296},
{-0.17865567692451265,0.165543840242537,0.11553198044077986},
{-0.16570263808972988,0.17240958076172397,0.13571406091391727},
{-0.16415599030968156,0.18154813754390745,0.13125257693300874},
{-0.1669654859165481,0.18401563561761533,0.11892648813464309},
{-0.17599272867340787,0.15267125683554322,0.13162776294978104},
{-0.016444930809540403,0.17426476494507429,0.26413663800326387},
{-0.00950237840781548,0.16893955005847297,0.2705314441022438},
{-0.012397336218938551,0.16993961647881559,0.2785720172837146},
{-0.018803320813892896,0.1754668870177079,0.270761941714913},
{-0.1595618887174405,0.18820690238541346,0.11822629540287265},
{-0.16611655226605865,0.1891612014159188,0.12087963907040743},
{-0.17415713784054046,0.18479142571683993,0.11389120774174546},
{-0.16619337654160768,0.18408995650493057,0.11070868250203071},
{0.006675854803755113,0.17331310562592434,0.2821602401334266},
{-0.011990870242255671,0.16298717445426628,0.2786290251345817},
{-0.009228406112354455,0.15508288721540128,0.2846048978877544},
{0.012309358233437288,0.16687114411986834,0.2890193256056754},
{0.008097283600072601,0.14838743906116333,0.29753375795796294},
{-0.004802948614591762,0.1726598576200419,0.27584679415204294},
{-0.1939428278549852,0.1668763491845128,0.09083360169882404},
{-0.18055811565902738,0.17068439926437295,0.10868113632088469},
{-0.18512247402472903,0.18562546296803767,0.08923283363948512},
{-0.17802619871383965,0.19103237258353384,0.09561315230853819},
{-0.17436781902852785,0.17798025162534165,0.1124585756634315},
{-0.17151743887818063,0.18856383349689723,0.1067292990442925},
{0.13820745418423094,0.26898083055865685,0.1604455785674424},
{0.1390390252262281,0.27313994985577034,0.16338644009152464},
{0.14798059509764333,0.260522662476573,0.16137629369790416},
{0.1419823529595109,0.25536461691613405,0.16246066977247503},
{-0.05721667310349333,0.29036499592539466,-0.027832763330215473},
{-0.06070037329794149,0.27764852727869954,-0.03329682951271157},
{-0.05929745966014483,0.2834546281733875,-0.03859608104114627},
{-0.059752307951998436,0.29485749961298163,-0.02796784715074855},
{-0.004479478632964871,0.18157990083124925,0.2708189495657802},
{-0.0061259521170859855,0.18478169720315943,0.2789779875399551},
{0.009145434903320695,0.19706417499561163,0.2714410787208958},
{0.014567228525097708,0.20251438579174474,0.2807084112809837},
{0.01900158420480009,0.2025171246471887,0.2720124089236843},
{-0.1663103169939517,0.19732427951169862,0.10763179528857501},
{-0.17436737288012974,0.2004056158161241,0.10990586324568832},
{-0.16686013292954338,0.2146895525014451,0.09646912518930867},
{-0.17610978066285143,0.221052744029216,0.09211829840413772},
{-0.16749837299903447,0.22155897374491637,0.08754863582970321},
{-0.17025120775934355,0.23181711514608672,0.0949870326038619},
{-0.16717678675508837,0.20381928310508313,0.11700137018989211},
{-0.012766846236646203,0.18935957634392533,0.27200307698635756},
{-0.013077737312049201,0.18309357080887204,0.26469680210308905},
{0.005744197804452958,0.20538458236677384,0.26740272931654324},
{0.013225226536651424,0.21370707176379386,0.27510745189834007},
{0.0173632033568999,0.2128355952261896,0.2673452009592116},
{-0.15999934961477963,0.19744719339537264,0.11622110621367543},
{-0.16258596931077773,0.2223370441581759,0.100983911510778},
{-0.16258703510972874,0.23143248565488816,0.09060103445330812},
{0.021948704199466654,0.19649403452188477,0.2808830907718473},
{0.013140929275434364,0.19957006661757737,0.2751106616882041},
{-0.0010153717889994603,0.18335481548197632,0.27715630166549493},
{0.003198028896548439,0.19310588444269433,0.2747599270822494},
{0.00546469822606007,0.1778922240677961,0.28301120623772963},
{0.026271906962989117,0.1793444371035819,0.29179389770738035},
{-0.17875866284640532,0.19539487358512148,0.0975076595159757},
{-0.17267230639964987,0.19972521472301344,0.1046018032289631},
{-0.17654616336822854,0.21620265240055928,0.08392970309858924},
{-0.17054828062741675,0.2178274257223176,0.0929705781676129},
{-0.17014923806435764,0.20995045267982468,0.1018340596763512},
{-0.18789263421449726,0.200086780820633,0.07734115705773831},
{0.1365357361365845,0.27644195611509603,0.1416452444692145},
{0.12373606081364548,0.2767025439586143,0.20165588473671864},
{0.13998732603938124,0.2567273771981025,0.19721856712737335},
{0.13101210914294334,0.25193051355194024,0.20510006361890262},
{0.13394574554157868,0.2713148311172469,0.11499641646790497},
{0.1326826870335724,0.2669509173123987,0.11979650229694236},
{0.13434082234109912,0.2704643359473642,0.13413273748892846},
{0.13607589346127452,0.27093274219331537,0.1464067756408502},
{0.13447125878248542,0.2574993006778771,0.10750874508177935},
{0.13938725644394906,0.24693367627934473,0.09679630068124197},
{0.0038424406855464156,0.2627657974780853,-0.03481126785701992},
{-0.005590412930233187,0.2735138098203595,-0.02805609778249313},
{-0.011649913722025776,0.28778138773108375,-0.025348708193734054},
{-0.016819174957472264,0.28375823215828844,-0.02446558222573534},
{-0.03772601111029721,0.2957131874544978,-0.026029158858888967},
{-0.0307786502202817,0.288807169649372,-0.024992285195703692},
{-0.042991999797052025,0.2906685999102956,-0.02609402387876695},
{-0.1653033476664496,0.21960592195324058,0.11098457571420567},
{-0.16587239755520342,0.23570316683754655,0.09089722741759622},
{-0.16413950760497434,0.22770092523927837,0.09433462732273144},
{-0.1607735905876221,0.2025512549996426,0.11523913358947746},
{-0.1622400308001025,0.1987918103091521,0.12254649905771908},
{-0.16329053677545166,0.18050561266767978,0.12440754513529981},
{-0.15902926188818636,0.1806019683286563,0.13231234048761825},
{-0.1541096454674938,0.19525815388712875,0.1377693302608002},
{-0.14261626786814263,0.21077012643120593,0.15454244039616963},
{-0.14313733201807957,0.19042942780953628,0.15713191048471106},
{-0.13928891790120315,0.18616780591796137,0.15411687678944624},
{-0.13873751566019604,0.1822902682250984,0.16179160828448252},
{-0.13339745394634708,0.18530087761541555,0.17529207120372284},
{-0.12739675799202507,0.18323067469020765,0.17404616462302092},
{-0.12986447913993196,0.2030183475864216,0.18035052652729902},
{-0.12359868428606657,0.20271039365463933,0.17759640289384},
{-0.1347845417090226,0.21180942912455852,0.1731013090669419},
{-0.12804273130041643,0.2098798249098046,0.16860760325728236},
{-0.134599836272213,0.20912701145308163,0.1531917137279385},
{-0.14103432479260092,0.21845202108663392,0.14562228564786273},
{-0.15033397832552833,0.2305318855412975,0.13273066657588373},
{-0.14427291601434244,0.23394281397481276,0.12745967111266143},
{-0.15172580021842805,0.2529901531764392,0.11623597782694511},
{-0.1414058424781,0.260990411892938,0.1023425697060863},
{-0.14816899365174824,0.2629082799262201,0.10284658107280732},
{-0.15133167768075897,0.28946033090417705,0.08088616547789083},
{-0.14066378615497538,0.2865962812626327,0.08191974260013465},
{-0.13963485641187837,0.31094575956427045,0.051193353707484825},
{-0.1293994066139554,0.3066955888149134,0.05706650079199707},
{-0.09720204166677791,0.32981581674271115,0.010933703023462802},
{-0.10042987575492103,0.3196533617799203,0.029230856086710583},
{-0.08777538455652734,0.3225297920395116,0.017778474567939514},
{-0.07788253954930494,0.33197470405505064,0.004533543143705754},
{-0.07651632161725123,0.32514725794003313,0.010585570949830298},
{-0.06261633280752057,0.3266901382447199,0.01046907664588435},
{-0.0330914215509294,0.3306947538729722,0.007674799656597099},
{-0.04652771345891101,0.3252625129428734,0.010905310635128748},
{-0.036240287372610445,0.32762582297261594,0.0104294190104985},
{-0.009993947191434187,0.32133806770315565,0.00036878502656080103},
{-0.022957433334538934,0.3233106013082147,0.009045119675311046},
{-0.0108321361013363,0.314564803832484,0.006414083427680815},
{-0.0026229683974314383,0.29799537283385413,2.0529022817721467e-05},
{0.00558737664252405,0.28971930765625775,-0.005251457881289225},
{0.015959075204019485,0.28658143443538525,-0.003940277311344432},
{-0.1711578556623305,0.23976139463163626,0.0652324912453756},
{-0.15432957184173052,0.2756817688167934,0.05364632717223257},
{-0.1369557972463981,0.28905007266611044,0.027886214386908977},
{-0.12187287074515166,0.2770054911139291,-0.007864958018272266},
{-0.09498141237334705,0.29791406228830203,-0.011324640557289907},
{-0.1650619070250161,0.25567947375507566,0.04376040985819167},
{-0.15883979753513047,0.2513278414241858,0.043871203377050895},
{-0.1424255270349477,0.26648637768589756,0.01871700968837892},
{-0.14594320886571718,0.2684330966489228,0.015278804237524927},
{-0.11913589903899696,0.27303339474669286,-0.004852415318230126},
{-0.08977945837472934,0.28104301018654065,-0.029384479851786518},
{-0.17466525129392171,0.22072617579482448,0.08170657041692463},
{-0.16832711843451037,0.21925684801076753,0.08121700930109732},
{-0.10080786259219245,0.27520835579437475,-0.018306268122880987},
{-0.08283427865466003,0.2769904459985045,-0.027629517948862984},
{0.1385272186555515,0.2535528206644981,0.18584504233796484},
{0.040358435375166,0.23539700989236775,0.26114497752685456},
{0.1064999477851462,0.2713144469339042,0.21990227602667253},
{-0.15596544930139694,0.2559843046480712,0.0716979746864198},
{-0.11418734493748377,0.29349917602897185,0.007809536472820538},
{0.05933834420362546,0.34066452229983213,0.08382702700197306},
{0.065586900379109,0.31776101095640696,0.0852571804780754},
{0.03358539457869347,0.3189221989135157,0.06644725418928853},
{0.009933618013603434,0.3249278892512942,0.03791587823621254},
{0.005691577079500328,0.348334693166799,0.04367228315655766},
{-0.021302978751296404,0.3300102135141682,0.02066108894004875},
{-0.026636943103704826,0.3525234069743193,0.02902266589394591},
{0.07930595122739173,0.33678300645041953,0.10882125170390736},
{0.08787819697626523,0.3159503548617883,0.1135330745081891},
{0.03026192362421512,0.34264725535299206,0.06507776450231548},
{0.08861683282833782,0.3323475106136999,0.13616023409803024},
{0.09887951007155532,0.3124989508541576,0.1492484930764678},
{-0.10524177212349677,0.28846924941685137,0.15957975324288076},
{-0.04267858054739322,0.279828309207683,0.21327362620203766},
{-0.043209088171756414,0.31631296197233677,0.1971558708844305},
{-0.0836447939708695,0.3224033833267192,0.16673503167941764},
{-0.058850989043766476,0.3535156286186622,0.028224816235037815},
{-0.12408203650335378,0.29829472601596196,0.12503278493619097},
{-0.10060462960385101,0.325458322517591,0.1488296093027047},
{-0.02019753455792678,0.31351263719365313,0.20939301504243235},
{-0.005908392807961385,0.27793360371206854,0.22822915254960705},
{-0.12095518066931192,0.3110898531038428,0.0404105913622039},
{-0.11036535272018319,0.33784140677381264,0.09277355407781154},
{-0.08687936985702818,0.33488564885043864,0.019608934694228877},
{-0.1010433174092849,0.3455176378231871,0.062832039361492},
{0.06517423789689714,0.3208233363818693,0.18802994258051525},
{0.08129757006948037,0.28060693730643993,0.21507851954651422},
{0.09950779855316676,0.3108828898191729,0.1781551913694377},
{0.09119211291921771,0.3268400936785227,0.1631670837957966},
{-0.08307595476330366,0.35273038265200024,0.03190526787304409},
{0.004972695687054368,0.31380764042887965,0.21364505713645934},
{0.03776829606402739,0.31583387295085336,0.20435029884289987},
{-0.11108166875934018,0.3310487602338463,0.12623095363829712},
{0.1297827100529708,-0.9133471248130695,0.27420330738358684},
{0.12914320589635175,-0.885145588849304,0.2739331397425207},
{0.15544985046933668,-0.8731503934461892,0.22089602201137565},
{0.1677474601282909,-0.8320204683466357,0.2253897278210352},
{0.14251033240961822,-0.8481959874887844,0.26369241052188697},
{0.12045325132844871,-0.884849408278027,0.3419398003167418},
{0.1304023482128637,-0.8391799232278992,0.30479918547678403},
{0.14618733879055038,-0.891031042193797,0.34611624504331456},
{0.16173683737211134,-0.8396768705783171,0.3073063040068445},
{0.1957147433970363,-0.8802937250200661,0.30865465121695246},
{0.1840294104494065,-0.8343268200975554,0.3014059790490819},
{0.21745580269622478,-0.8704338454222582,0.2738488672673257},
{0.21756736458176956,-0.9091409492529684,0.27403724103540855},
{0.19616462209145555,-0.9110036188149976,0.30883433748428357},
{0.20508141833376578,-0.8656959849017434,0.20440216359417793},
{0.21929496271627685,-0.8671682870084544,0.23458782062834166},
{0.20465134367101726,-0.9102909958931359,0.20777800741338767},
{0.1552081743606931,-0.9110531784662189,0.23659919393005688},
{0.20577910767730248,-0.8183460075521399,0.21662415109965572},
{0.19150651059709958,-0.7767532034895672,0.2234163143121909},
{0.15689737894694245,-0.8055700524523661,0.2270652753090986},
{0.1525399962589218,-0.7685744606278099,0.23272268485711178},
{0.15875677675405242,-0.6667009106217221,0.22397256222052173},
{0.11289907904498538,-0.6235966425374949,0.23255421426478828},
{0.11913586185996379,-0.498550541310922,0.20401060640979793},
{0.06723426616002634,-0.490729262460124,0.22663206521455237},
{0.08177973255770606,-0.40410039253561275,0.2138291677087382},
{0.020484147724667008,-0.37705744199663416,0.2463924487004165},
{0.037525058435990466,-0.3233089282517222,0.23182742613128718},
{-0.005692766808561894,-0.33931525800690615,0.2511152269264736},
{-0.017515959611201715,-0.30178302401751306,0.2405407539180458},
{0.03191137143099024,-0.30431983620206876,0.22717192956226445},
{0.031645541343794416,-0.25511432766480535,0.2124383000776899},
{-0.0054820112625081725,-0.23988718369387596,0.21898996451763197},
{0.042056290283133894,-0.21928765703625824,0.19712260804275064},
{0.046501750100744366,-0.13346062732021588,0.16294360062738628},
{0.006278782729454227,-0.13230274829705937,0.17232134252299064},
{0.005392793975901148,-0.04529477616428161,0.1457003120454844},
{0.04902986239153724,-0.037433889250141794,0.13878006706366397},
{0.007237196239630851,0.01446789234496142,0.12996507940719593},
{0.1080850138994745,0.02193489218864225,0.11918671658084061},
{0.06379733718931135,0.07130866063704107,0.1022900976972664},
{0.012671196977299983,0.07529048551795776,0.10446631043906512},
{0.09738115785560038,0.098115896105695,0.0643538515473799},
{0.06022565900936184,0.11869202475843514,0.05509876328221735},
{-0.0166979960953464,0.10953579554248291,0.1255716454500073},
{0.02117635935731604,0.1426666144755659,0.0719298107442833},
{0.05895787876414248,0.16432185217317724,0.03590570705656996},
{0.07400049080041696,0.1522176106657623,0.03747218365431119},
{0.06373786312924365,0.22617165246073356,0.036237852145937555},
{0.08031683674638822,0.21643279061590776,0.03673804646525269},
{0.07285013433497282,0.2719169331664927,0.05084370968650323},
{0.056313941392000785,0.27795278809318646,0.044053987897146506},
{0.05798730771011793,0.23087737790357465,0.026021004257612754},
{0.055316799722267704,0.169829368252443,0.024211661822166348},
{0.038706484180157215,0.14264032889911185,0.035895792647723496},
{-0.0034322320195239345,0.13404325994908908,0.08191723921190092},
{-0.0030294963391695406,0.09739712625034855,0.07572319989206183},
{0.03344810480219201,0.13749599000890303,-0.0013501627862279645},
{0.0027246034811187424,0.10762755687879307,0.025889663126419233},
{-0.011065261032349822,0.03288551786870482,0.06345470141608307},
{0.0021346961547541346,0.06901465232513539,-0.030664603536019762},
{-0.0032277721230877603,-0.0067054183316341935,0.009613909310832652},
{-0.009741538735214285,-0.027244293593133757,0.049003855657831843},
{0.00011092984198090809,-0.10191041301748009,-0.013248581165990364},
{-0.011247934015345951,-0.11478610707024951,0.02421163703614424},
{-0.026144754669533195,-0.22290566029154285,0.004928409262038257},
{-0.008556766878061848,-0.19257448452153514,-0.03480887600588572},
{-0.013197912340279429,-0.23121424473015567,-0.03549033050493631},
{-0.027241684864305928,-0.27601665276160514,-7.499630641796525e-05},
{-0.031537387536290463,-0.30597973131716566,-0.007342691746262687},
{-0.010261908876531986,-0.3091910207355463,-0.06476051581223971},
{-0.025328873179535572,-0.36526690477813234,-0.046633469218775134},
{0.006618549520622558,-0.39027432803684353,-0.10365731946321581},
{-0.006474282478895402,-0.48172127844244855,-0.08728983257977734},
{0.016152430962547655,-0.49602602299333604,-0.13828685000957452},
{-0.01471914205464759,-0.623315655797775,-0.12669213475880142},
{-0.0057824922086223375,-0.6659122813630413,-0.1693863057141057},
{-0.015253974839870012,-0.7670450887051765,-0.15926824251692487},
{-0.008631137337421442,-0.7489463229629465,-0.1945623111022399},
{-0.008172608321283546,-0.8044162011578035,-0.16463568039220114},
{-0.007110465308550808,-0.7968307241284075,-0.2060085332945151},
{-0.00806103404272766,-0.8313301156656453,-0.17279896916916898},
{0.0007491451254498149,-0.8720808022338107,-0.16897695216584627},
{0.0038139243671018288,-0.8661953612823288,-0.22138824762458045},
{-0.01432694043369256,-0.9098485158263183,-0.16353891130657214},
{0.0006983213871006494,-0.9107333644228541,-0.2187596775861508},
{-0.029022610125396146,-0.8678684053821585,-0.22724639916571243},
{-0.03094474135448207,-0.9107222107129018,-0.22319514863684842},
{-0.0664631234399484,-0.8708018434926168,-0.21520412271358783},
{-0.06664530070250214,-0.9094940633170462,-0.2141011447294188},
{-0.09443908181643444,-0.8797781014019836,-0.18490322306959503},
{-0.09470678324830002,-0.9104855042016925,-0.18436907189998075},
{0.2171323327145978,-0.9101224633357571,0.23719281915973886},
{0.21397991009874312,-0.8150959032231254,0.24457700890352954},
{0.1951447020673978,-0.7487518270474011,0.2440461790608788},
{0.1736656558079992,-0.6649244096655796,0.23336873252356943},
{0.15573738071889517,-0.49555019333376105,0.2167406949756459},
{0.13438171927759082,-0.42261607156284764,0.21954154026079395},
{0.10485589093818139,-0.35522831796086696,0.22996879669086281},
{0.07073743577484681,-0.3148340667837432,0.242053457240806},
{0.06376759396277194,-0.29740327194453253,0.24047955722944098},
{0.06237712290807758,-0.2685920246227319,0.2326967462849672},
{0.07059196661104707,-0.22913255348369696,0.2200418213311865},
{0.11541257997574085,-0.0932276835750239,0.17424701815323923},
{0.07057013012556274,-0.1050526361852341,0.15808215700060035},
{0.08938397260584396,-0.02868317174902108,0.1393005735281033},
{0.14511985439005162,0.027254716115433352,0.14643628340017947},
{0.143304699632419,0.07595726669191562,0.14117688779530757},
{0.11905408037999152,0.06461264240429465,0.10553830589558896},
{0.13190065085677444,0.08941104513850015,0.08681370548793699},
{0.13528270357452427,0.13780952079566142,0.07989346050611656},
{0.10314763829393576,0.14133287862549543,0.053983392286990214},
{0.20732823405956238,-0.8147896099548252,0.28295325651802206},
{0.13828555493991895,-0.8060447295619125,0.2954994823718124},
{0.17942032570679622,-0.800999410830058,0.29418757061421513},
{0.13646127892614757,-0.7617099718027397,0.28495798716581017},
{0.1368219403339598,-0.770456946614521,0.2586302744740265},
{0.16114074593322877,-0.7601831280543623,0.2873238129767975},
{0.18626384555715605,-0.7527671502372076,0.2765703972817021},
{0.16435326225970406,-0.6612320235579243,0.28272096191874946},
{0.17979484250097139,-0.6594520029866414,0.2507157506080275},
{0.17064738753684822,-0.49865222596665365,0.2595089761370775},
{0.14626415067308832,-0.41243280873449023,0.2643137713103169},
{0.1215239950908557,-0.36226959308868056,0.26791518032379485},
{0.09929217255376727,-0.32752950449067275,0.2715736095811509},
{0.07583649060264927,-0.3058860277605556,0.2737818334705126},
{0.07384764779503769,-0.26519030419643297,0.2703125835269581},
{0.10214511805740349,-0.16736809147028658,0.2565025679775091},
{0.12946543657687287,-0.07777556927435722,0.23920558047869256},
{0.14628107952619362,0.019153380000744864,0.21948335507387629},
{0.10459995047380995,-0.6488767120394838,0.26309436098725725},
{0.11897352580811406,-0.6821604483360125,0.28718874154927543},
{0.13921215559070949,-0.67706865581269,0.29083040306267},
{0.10846174904262908,-0.5181786541897633,0.31847244414920717},
{0.15406557592017137,-0.5069542916814498,0.3027097733844361},
{0.12882347860406437,-0.4110955780553014,0.31172446202109405},
{0.10588650613078228,-0.36966202418482486,0.3121520209025978},
{0.0720258379904668,-0.326025860458996,0.31155252138567424},
{0.06222466408604111,-0.30332473937916016,0.3083907792255039},
{0.0631169856682449,-0.2584347747245854,0.306093114975336},
{0.06971457860716823,-0.20770726810626827,0.2997998076369216},
{0.09727147970773635,-0.08630918600776273,0.2968632588806877},
{0.11097837301217114,0.032945747902447184,0.2794585761157764},
{0.15098074478662737,0.10961833299612966,0.19780018352934006},
{0.03573331407624656,-0.44558695131438464,0.2824864613635084},
{0.09412816595500943,-0.5832123677342729,0.3011660751410196},
{0.07774443183407377,-0.4284718188598343,0.3248461821293883},
{-0.04364511147981282,0.09169758046473783,0.20103884910914793},
{-0.050053525104934535,0.03279238439060338,0.21803337278008095},
{-0.014007411429582051,0.16816404499850252,0.22410832765666297},
{-0.02871521387911151,0.15828401436471426,0.1949501751693246},
{-0.011921469380330414,0.2237290147672083,0.22806927031394678},
{0.0575140805828651,0.20356806437792488,0.23693645733299146},
{0.06776560411613049,0.18211327124116697,0.2462857572682175},
{0.050714047808308065,0.13393045876243828,0.26649254940540473},
{-0.018633610920463548,0.039251931579350766,0.2821238914319933},
{-0.044344027731444254,-0.022923966008176817,0.23155688669988936},
{-0.030268268845876863,0.01884665297705726,0.1679051178184662},
{-0.021108383691662475,0.06890932412415277,0.14142474801646915},
{-0.03801122386678785,0.1026059459770925,0.16049139552932412},
{-0.05486944920210415,0.1540022538301699,0.17764581382892852},
{-0.05956336410540699,0.22161438289735716,0.20381459854690334},
{0.039199701234246626,0.23725106631171164,0.23341685458550798},
{0.11005053306027485,0.2285201156632285,0.21528216150422055},
{0.12266291280709321,0.196340472721864,0.2212134565966173},
{0.13098506759281453,0.1408862097209402,0.23149783400219756},
{0.05217146590873823,0.05518531607144682,0.3024632516084688},
{0.05147896923683488,-0.039568473867796425,0.3167850613355833},
{-0.016562466126415234,-0.08158285098753196,0.29643799270622967},
{-0.043275787357270966,-0.11934053863409355,0.2500085682180203},
{-0.029371027238282926,-0.11057668454125116,0.21038775246802016},
{-0.0364187343388357,0.10946053278632718,0.1481913444471915},
{-0.05476943760286545,0.10948737604827902,0.12878849933035294},
{-0.08492626849330807,0.1495504116118645,0.15450246054249625},
{-0.09868492740493241,0.22466715331129383,0.16961639435741002},
{-0.1167787359427392,0.22753612297822812,0.14492703772750448},
{-0.12894494250544455,0.23349473226699677,0.12159967301288183},
{-0.13475481087549424,0.25364198837906105,0.07279475616505982},
{-0.12146224071675325,0.2586564113343478,0.0052396225557287445},
{-0.08543927718605727,0.2913973089605106,-0.00578807526010404},
{-0.046015882102212295,0.2925263494469348,-0.010136782840384074},
{0.000197680919387437,0.28728404380431194,-0.006765883832586505},
{0.03396118785300756,0.28028206691456353,0.020402075008934893},
{0.11834641466255315,0.27067500474234046,0.09938273448207417},
{0.12375100678498148,0.27203077536607223,0.1453459338942786},
{0.12049660208112987,0.26854712474366826,0.18443844797588388},
{0.09730678739624087,0.2595931246821617,0.2187584134990228},
{0.04354343921709235,-0.1078695056336802,0.31673624526502553},
{-0.021816669059653848,-0.1794244959550173,0.29972683758781166},
{-0.03741390551981055,-0.18009109123380942,0.2461493597885123},
{-0.044056547053929994,-0.911134910374147,-0.12918423295945952},
{-0.04365004389821394,-0.8829296689000753,-0.12948290452595923},
{-0.04429980946798901,-0.8459660882230822,-0.14409013769075238},
{-0.04073645939147054,-0.7677985713844967,-0.14239145245104354},
{-0.04154820161577474,-0.6801725597902524,-0.12501270825827687},
{-0.05018081372151206,-0.6165323164091132,-0.10932138405816719},
{-0.06492340335308155,-0.39553382278580385,-0.046992668251282496},
{-0.07628042065176072,-0.346515324785407,-0.018655825392785184},
{-0.0773124610406333,-0.2956581500923891,0.014447406697682613},
{-0.07004343954860538,-0.2553885230344653,0.020758906976330174},
{-0.0672413921413847,-0.21916000902236002,0.031323948903342766},
{-0.07106960565023644,-0.18948615855887296,0.04622903569590578},
{-0.05550542135057161,-0.11359883182486333,0.05931000758384116},
{-0.05046905037270089,0.017770852866138654,0.0963011998894717},
{-0.03836567637606,0.07319977215944874,0.10243757452885754},
{-0.03325168796993248,0.11362900880678946,0.10966788025434004},
{-0.03136136960023263,-0.8056238876924022,-0.21661248927625007},
{-0.0690766359699425,-0.8152514479049153,-0.20917598863278322},
{-0.08562767574016218,-0.8333117457408212,-0.18409889186590356},
{-0.09010774923765784,-0.837565027135954,-0.16101814807133671},
{-0.11786930852283913,-0.8888460799861914,-0.12740089106121297},
{-0.0781824999889547,-0.8182837574575952,-0.13720227564682672},
{-0.10726214275124012,-0.8818403108350591,-0.10381450002246542},
{-0.06719678969458666,-0.7586574740350464,-0.14146196422867657},
{-0.06990463782475487,-0.6781153199546112,-0.12997486988593182},
{-0.08344104047606361,-0.5739634635816283,-0.10955556239512067},
{-0.0974134292563956,-0.4329195961705126,-0.07068914640725897},
{-0.09906911074773285,-0.3823536324513376,-0.05083430339111015},
{-0.10528545748747649,-0.3494514769652871,-0.028939558361790428},
{-0.1145486012098268,-0.31182006170839616,-0.000940449840647876},
{-0.11464514276596922,-0.25801618838308776,0.011847402549741813},
{-0.11937755036161844,-0.2075341377417869,0.02328833292629522},
{-0.12944535989895878,-0.17237789183244887,0.030496021406596723},
{-0.09180928486991002,-0.13545017652945765,0.0659921704302248},
{-0.10147170662252952,-0.05099914283119373,0.0897996775722706},
{-0.1070266879341477,0.014029365648671398,0.1148677522271},
{-0.1050214863519394,0.07645422643534455,0.12482307040306614},
{-0.06834438251856481,0.10027355650993981,0.12734628745449109},
{-0.1071667165660929,0.15603718624590662,0.12834517653878333},
{-0.06058633281018507,-0.752228004684137,-0.19230182588524625},
{-0.07837084897101541,-0.8011354613054535,-0.18040494423885506},
{-0.0704858948294009,-0.7582819905860086,-0.1662678275555391},
{-0.07309640825071897,-0.6741879499642838,-0.15052275486647054},
{-0.09877293017645582,-0.5133601399532826,-0.12866616791819865},
{-0.10283907710461163,-0.4224425198359903,-0.1044006274804573},
{-0.1009441857138313,-0.3698317464712653,-0.08617048342800056},
{-0.1049899089597634,-0.33462121917349275,-0.06262870722906208},
{-0.11643811403380791,-0.28241776690321363,-0.04127833760347955},
{-0.11769559568683803,-0.2387899188878047,-0.03114325880211597},
{-0.16568284645107012,-0.08404458631109776,-0.019019609839384038},
{-0.14972059863621975,-0.08204502354892097,0.050093188936825954},
{-0.16973363843852493,0.014659178470643007,0.079854930634737},
{-0.15702380005274585,0.10410419904895887,0.09851642583008124},
{-0.13687152477120315,0.16616097501419613,0.11603148075147575},
{-0.028191026690387956,-0.7491086838008184,-0.2026586528334721},
{-0.0642285396160661,-0.6603947021587964,-0.176343432296835},
{-0.014896424077833417,-0.6646658666688859,-0.18453340322661088},
{-0.03197321255616996,-0.6599144481942737,-0.1912454084436224},
{-0.08204981344769471,-0.5047965940981719,-0.1745041979187165},
{-0.03844375234572589,-0.49802625497811004,-0.1907167225918847},
{-0.08782991380518289,-0.40675052641328346,-0.15659254185744134},
{-0.08892296498749443,-0.3643118993459968,-0.13493576742645882},
{-0.08756429439917505,-0.3198525670396681,-0.10534616465214451},
{-0.0908550230184379,-0.29369649755103894,-0.08800217046238465},
{-0.10044102946487328,-0.2501970411301917,-0.07820301661876138},
{-0.11017497128430899,-0.2002380499136082,-0.06981041995818586},
{-0.1392873563818098,-0.07989728994653364,-0.06709425611759767},
{-0.15448807845316334,0.032252594400957735,-0.05084284217572915},
{-0.1834395155160529,-0.010897912007527152,-0.0025399042408146472},
{-0.19087902766120687,0.04144770049259911,0.012909223344186985},
{-0.17547326322189744,0.12564825904436816,0.037276374079593534},
{-0.16068841342261989,0.19320506571019216,0.037147499157600565},
{-0.14805002074559065,0.21777787846410745,0.05125818154832964},
{0.004103920825860825,-0.4947755805705869,-0.17522048917185132},
{-0.042306641499518106,-0.41057621174787934,-0.17099198140582364},
{-0.04457828042646408,-0.3577881935390017,-0.14972682612427646},
{-0.04824911508788924,-0.3207417655830853,-0.1289969993483941},
{-0.05412206388422459,-0.28637530148245643,-0.09970512627173903},
{-0.06360403100282738,-0.24632422517454192,-0.08593625551900286},
{-0.07130766299965108,-0.18973294058807236,-0.08466644281996992},
{-0.08352409843617487,-0.05940332695710857,-0.08914390139213234},
{-0.09124185846560481,0.04718572657754505,-0.08038172035578277},
{-0.09634641579031708,0.14454383343257748,-0.05849555129011523},
{-0.1406482948911528,0.16100670932213001,-0.03478570107520711},
{0.0020875655337002866,-0.42078064183912395,-0.15778351022012274},
{-0.004872200760384347,-0.3583745068921595,-0.13707959723036278},
{-0.021821638657088093,-0.28784340235841865,-0.09008381213679918},
{-0.026556376138816253,-0.24292483463432182,-0.0722779056388826},
{-0.026288612741895322,-0.20222358378726724,-0.06747878646470776},
{-0.018357940782487623,-0.04975995326248546,-0.07127362559478011},
{-0.0237093049224216,0.07643427368754105,-0.06824554205887112},
{-0.03145658510419185,0.12278051628552869,-0.05350491052304883},
{-0.025469509069022633,0.14213958928731008,-0.056634145815213845},
{-0.09139662238769808,0.17908441933857241,-0.05968282653550135},
{-0.0896725066892981,0.2352188727514189,-0.036063333764217664},
{-0.1334262676970571,0.21970378956156625,-0.01401456839346814},
{0.006976620789123599,0.23833670647341051,-0.02603331051759342},
{0.012969880936810774,0.1775241268533492,-0.03234632274359007},
{0.038493311996947194,0.1730193416918037,-0.0018086918023658592},
{-0.004258845857097878,0.011908871884589804,-0.027261495092482244},
{-0.0018459513901119267,-0.06896537771316871,-0.029369558666472596},
{0.0042947731961552405,0.1150174845867035,-0.029130348767029555},
{0.014696252163223343,0.13715021260737154,-0.036562425105548635},
{-0.030952152375094844,0.1804451967387715,-0.05769125726545696},
{-0.04292134724100993,0.23989688742153417,-0.043733008910742256},
{0.0190759050921154,-0.28924128443372576,0.3287822272274564},
{0.02237011614748553,-0.2427921302719119,0.3156512867189349},
{-0.02588236983941154,-0.24408223033004686,0.3116183530604147},
{0.028526629429840807,-0.18737720268808636,0.313204472580683},
{-0.023850981824837553,-0.3323441892867366,0.2989956251493629},
{-0.018438829965663688,-0.3288369051922448,0.3287020072668775},
{-0.0350270115900245,-0.30223039932369866,0.29016188686716393},
{-0.033838831654831106,-0.2610241952410826,0.27186096632855455},
{-0.02863097858294976,-0.2902302467161605,0.3267064102682392},
{0.021113340896085693,-0.3190328561092536,0.32943781751242884},
{0.04743213061990751,-0.358790726168545,0.3238271296161046},
{0.03043041900256076,-0.4055311036972127,0.3197303223785911},
{0.009287310093913604,-0.38348635366204603,0.29201313007299773},
{-0.03065351798762834,-0.21234391490547175,0.2517522400878699},
{0.1518645647632454,0.09786808545657776,0.12668945786841287},
{0.16164635599837632,0.14637803624820642,0.18291904003414125},
{0.16074046406906392,0.14120645751969202,0.12380437728710308},
{0.13724454201104033,0.20708517613018554,0.08233861398088667},
{0.1555663323802716,0.20784735870326856,0.13151036395602786},
{0.14626798011350528,0.2080756007879252,0.17896842075506889},
{-0.08924394397389868,0.4971658949714247,0.23662297611827735},
{-0.0965632439117892,0.5117463592323324,0.215377637261412},
{-0.062348296764356444,0.5313808545118687,0.24449946583333915},
{-0.0749435493698925,0.5431631503780167,0.21698344927625154},
{-0.09021432913275734,0.5285115998056799,0.20759358701583241},
{-0.08491629211940632,0.5412366692020494,0.20122110072976807},
{-0.07967033053852135,0.5568890545614147,0.19461811683103447},
{-0.07005495265587833,0.5645802191891139,0.2056840594789925},
{-0.07480607369822526,0.5799376013132524,0.18768049684771063},
{-0.06842022774624025,0.588605682216638,0.19336747612010838},
{-0.07050324504488222,0.5945836741747015,0.18209250055463372},
{-0.0646946283689494,0.6152750578302818,0.18144930328071943},
{-0.06455334804288732,0.6245883560683841,0.19210605348956178},
{-0.056309504694041924,0.6399878992161425,0.22748935175449503},
{-0.060897409780753906,0.6146529162821552,0.23535270487783524},
{-0.04724155089585634,0.6333316873349146,0.2519581003945557},
{-0.03961302054604458,0.6022124399917237,0.26633930982367154},
{-0.06178597628060716,0.6148809724716462,0.23619666893089045},
{-0.06924613518218387,0.5907850799622788,0.19400170085401663},
{-0.0689927352850793,0.5654613498823322,0.21191999956921895},
{-0.07208997182269238,0.5482890608607822,0.2226918560647688},
{-0.08457134504961572,0.5233646088111048,0.22325957990133935},
{-0.03602130286721415,0.5602533728803404,0.26413289531392425},
{-0.05586852418156226,0.5767979311057767,0.24647121867870164},
{-0.056655938925159445,0.5768351844970172,0.24756102289211596},
{-0.05777313169301214,0.648935653200076,0.21084801650570612},
{-0.06462397581290731,0.6106053712635978,0.17483763188123413},
{-0.11609215073711056,0.4945349206888498,0.20905596232068574},
{-0.1263422986461484,0.5251085161481645,0.17879240281901096},
{-0.10513988917958826,0.5213494432480058,0.202139695495415},
{-0.1065531509816185,0.5449133905437272,0.18730589330245806},
{-0.09737406905327513,0.5626834316676417,0.18278046138448983},
{-0.08195480862492348,0.5895380456175706,0.1809550947857453},
{-0.07164834687363768,0.6145933430779991,0.17430968961015994},
{-0.08313171092005395,0.6227678599229856,0.1730307432619772},
{-0.11954362910280775,0.6337913936871029,0.16256112752011181},
{-0.1259941665725159,0.6085914326085935,0.17026956800522608},
{-0.14297880062062462,0.6239514544440874,0.15365797598297662},
{-0.15409711613331412,0.590996591482007,0.14878993927430778},
{-0.12510437316456796,0.6083622362620853,0.16942560395217088},
{-0.08108781835732237,0.5873686614248649,0.1803578755828565},
{-0.09111397498449646,0.5625148495382186,0.18406215898112743},
{-0.10047456495279644,0.5406614228077665,0.19076904588457194},
{-0.14780714251487442,0.5493011361088402,0.14935280505054363},
{-0.132416956090465,0.5692991803677651,0.16787214001604064},
{-0.1335311993216859,0.5693022042624631,0.16862786583036232},
{-0.1059955770211044,0.47767417957228864,0.22781525076628933},
{-0.10388009003349027,0.6444197019355671,0.16350547496273746},
{0.08794366925368505,0.1789301139578881,0.3153002298946927},
{0.08948627691212839,0.16983381734341288,0.3274729551812146},
{0.09072370667326654,0.19081036418343952,0.32467705470747876},
{0.08732237043031033,0.20315194424562766,0.3097968282950982},
{0.09322496330909655,0.21352807950508204,0.33688082448670115},
{0.09375993241744071,0.20364038999045986,0.3505837148485641},
{0.09775973955740262,0.1864072141055813,0.3265676085443887},
{0.09633811247290817,0.1651535347522739,0.3303278339945759},
{0.08617362505630381,0.15009058578485304,0.3317559798028868},
{0.08588642941804384,0.1678994913914456,0.3196308312858168},
{0.09343978376277727,0.17694122157823233,0.30853174972628944},
{0.0953115745809454,0.1974714093389801,0.30012467802879816},
{0.10179073990619768,0.2328557610098533,0.31872999570501614},
{0.11517001157030106,0.2388735593194354,0.3373162529302268},
{0.10449230477975942,0.20837589583887353,0.3763422413284723},
{0.09611492673676324,0.19990155487735883,0.3750600851904255},
{0.09528211639366031,0.18517284541817444,0.3696816175353076},
{0.09819576286545897,0.19624298929688125,0.35569118453087506},
{0.08525486918151304,0.1384454681581068,0.3297661331613795},
{0.09113864946951314,0.16437660449603184,0.3123558735414921},
{0.10242937655204265,0.17634479552805127,0.3071861289786143},
{0.10682217846566733,0.19323721318087686,0.30223027539358793},
{0.10509926488933995,0.21713889481395296,0.3024731412312931},
{0.11860964221742674,0.24653542686899338,0.30892322015959217},
{0.12958362872333382,0.25587717946048516,0.3184196747081219},
{0.1454936152105522,0.26092857076775827,0.3172530338261474},
{0.12158152344818726,0.21803902399312336,0.36757690007430294},
{0.1128553936810057,0.20759121995072016,0.3831887478944971},
{0.10178331649257388,0.18740047676285315,0.38996307756411974},
{0.0905829220676468,0.15895768605282026,0.3983433059996592},
{0.09169489737784402,0.15683633717097573,0.39235132233211106},
{0.09336717311098806,0.14367556668483744,0.3328955543487104},
{0.10192225453954605,0.15745044804793676,0.32968819351483525},
{0.09600288152378718,0.14070978281551744,0.32703380883437155},
{0.09116403035616011,0.13732447073585918,0.32289388631138705},
{0.09954448186589869,0.16156106109976895,0.31367401898365155},
{0.10371461854984287,0.15669224363140338,0.3225819418300441},
{0.10532632963794605,0.17035923144023118,0.316626678654261},
{0.11386813815166087,0.18673587675884165,0.31024963174012726},
{0.12747721341981422,0.20898735461146814,0.30467096738437716},
{0.11429786581009978,0.2113635285866889,0.29889480800440543},
{0.12091829906840315,0.2439766790548649,0.3008259489525306},
{0.13997810563915408,0.27325265189833253,0.28476728351164843},
{0.16602298503257018,0.2877217277758502,0.2870733997953579},
{0.15813439973871565,0.256160731553494,0.3158757117561857},
{0.1379017681734724,0.21516986843102312,0.3636899313000248},
{0.11825067865212949,0.1998209011613929,0.38249700719626833},
{0.11317025051994722,0.1874148526556805,0.38667957407030373},
{0.1019075564284311,0.15813424482607738,0.40629229482941087},
{0.09600600456257377,0.15994082362005768,0.40558293126945744},
{0.09069837535866385,0.12863853150353893,0.4049000763601573},
{0.08601251591254871,0.13176411085744186,0.3989251578688361},
{0.08755832096784509,0.13308281398509897,0.39205793018832213},
{0.08462809264725074,0.11213197025000671,0.39128802676935004},
{0.08612464787660222,0.11668669924611627,0.3859242076533027},
{0.08993420990381161,0.11269152709229009,0.38639353098207224},
{0.09187444732205347,0.10934044450917431,0.3904228830603966},
{0.09403049663486066,0.12179415653541621,0.3863270920497899},
{0.09991933327137245,0.1292264435551233,0.39729584870503043},
{0.09795526409286594,0.1311996339897685,0.391403876636721},
{0.10366015126624259,0.15513517332905521,0.39113737732692805},
{0.10614817216626261,0.15414305082880084,0.39695123624653844},
{0.11259538830900717,0.18055515992588994,0.3850422962003877},
{0.105762687557301,0.176452490794146,0.3691430916327898},
{0.11202363674384269,0.17902966701571782,0.37942769211256916},
{0.11026555180213252,0.1742525702221931,0.36582243389182173},
{0.10489811392685629,0.1468335785486792,0.3820379204946328},
{0.10428868760807518,0.14561103279382184,0.3909777801305221},
{0.09773765521169706,0.12965977757978006,0.37107212576903514},
{0.09435783323593767,0.12303589906440252,0.37479362305966574},
{0.09016869806604151,0.1170576220670845,0.3552991068400306},
{0.0944685523967306,0.12335132598185276,0.3548425854916841},
{0.09156100328637252,0.11280357230526615,0.3504397824181356},
{0.09714808249663105,0.11621601268613037,0.37867614274297406},
{0.10054464743032997,0.11406582526755374,0.3784845591850272},
{0.09784039327336856,0.11194363366095707,0.35092883542050957},
{0.10204886154051537,0.12258224050161039,0.3551080190025261},
{0.10881815964764839,0.11883225167855727,0.3728142609055136},
{0.10704234030711407,0.1275715180374605,0.3685308025284543},
{0.11624382879945044,0.14356541760255306,0.3782917735050077},
{0.12050434771304117,0.14091420553292033,0.3866847295629039},
{0.1296082536363062,0.17095414554306312,0.373856922104863},
{0.12262759272557766,0.1693505642702141,0.3623727153336947},
{0.1295434877605167,0.16868028826713788,0.35941891550606786},
{0.11997372855157842,0.1465818888871007,0.37217360419886614},
{0.12081863447347405,0.1483884676810812,0.3641244426607321},
{0.10906828778983356,0.12480513771606488,0.36067710356072835},
{0.11234869303088506,0.13070173237749907,0.35607255466016535},
{0.10431979406583097,0.11556909750889864,0.3409004232653229},
{0.1103848717125997,0.12159816106553265,0.33944270773262725},
{0.11097619184222489,0.11339773043442368,0.3398812344289175},
{0.11786500814800203,0.12495841447683131,0.3452916140875099},
{0.12297308508785482,0.12002567385742824,0.35845219867848244},
{0.1220135809927051,0.12646252944292832,0.35363361008393535},
{0.13144557949072175,0.14418085453169732,0.36018723261962454},
{0.13524326901333744,0.1403385749552947,0.3675944857569943},
{0.14625550035136978,0.16351164668224424,0.36725114977864126},
{0.1407753604335313,0.16505472527510776,0.35669664191102807},
{0.14617150052241806,0.16455435745363783,0.3616566967268032},
{0.14546198824633205,0.16200044291382212,0.3512812678689791},
{0.1399017646910363,0.14645281567693086,0.36700345066662343},
{0.1401631456872622,0.14573433086083873,0.35973421849340753},
{0.13121373103984724,0.12866916702687448,0.3645058623620666},
{0.13343521545104106,0.12924630955184926,0.3566261008920855},
{0.12462021540156201,0.11130323720754198,0.35658097793882304},
{0.12922934971621647,0.11983685394094733,0.3516168334293988},
{0.12783174028715263,0.11191714979632607,0.35180844177336773},
{0.13170815021600923,0.10799772372608672,0.35555238280702456},
{0.13426018101814421,0.11374085573158872,0.3512091777236544},
{0.1437234718690825,0.12197976666203292,0.36171319646421696},
{0.14171028918775283,0.12467523417415415,0.3557297391882767},
{0.1504961284822123,0.1400864019662849,0.3578329818809655},
{0.1537242476096097,0.14007780121661068,0.36419863961793686},
{0.15709867862555887,0.15881160963147872,0.3483829267658372},
{0.1621553245695206,0.16063105237093742,0.3553002841760811},
{0.15925959839171192,0.16110825765473996,0.3636457006435585},
{0.1676724328393453,0.1785173027595435,0.3598805303819592},
{0.1677234920449045,0.17493636700033371,0.33724158503860185},
{0.14912021921551114,0.16069487637788651,0.3486398462780823},
{0.15117240270264065,0.17296289152643401,0.33899214742259975},
{0.13834530164622993,0.17907032848499937,0.34388656885181124},
{0.13068321102247296,0.1750941672101362,0.35123515347483203},
{0.14486616945369268,0.1428584582867451,0.3573300363131955},
{0.10964207180881162,0.18351830408385456,0.3214057459365439},
{0.10248956940675175,0.16954675802827446,0.3250693678655333},
{0.11070402892637844,0.1927579382642277,0.33014490075834757},
{0.12866482327649884,0.20125193454128038,0.3241559161994754},
{0.1379140124683978,0.2095456845456567,0.3189246527297054},
{0.12648357897221052,0.23511865047099215,0.29849489793057227},
{0.13620050518746352,0.22304059539594287,0.3060084954958314},
{0.1378204576279203,0.2421875867994874,0.2942994299320254},
{0.1397652804602537,0.2592213591364414,0.27761900712635934},
{0.17157422365484878,0.24127479196301574,0.2674187039077971},
{0.16015892202516355,0.22995435883298002,0.29414021691896225},
{0.17054792123009613,0.23063040997920933,0.2988697121570128},
{0.18410803171155893,0.23932693284297324,0.27556057756165664},
{0.17267924648584243,0.23677726910595026,0.3053105582920736},
{0.18352000812287522,0.23926491821563842,0.28863763325809766},
{0.18964087910542737,0.2561248042144366,0.2839632373472113},
{0.1640122189883968,0.2457629457037212,0.31618903186175595},
{0.1553680689893644,0.2006940879345231,0.3622583030556065},
{0.14131605511298428,0.18884635696998822,0.38001750029484516},
{0.13162177092893448,0.19579604774608272,0.38786767964743074},
{0.11900387629219528,0.18298039783188974,0.3850931695107811},
{0.09697004449977074,0.12832046487473345,0.40351433943568704},
{0.16431426145390432,0.1891238612736007,0.31534796777328844},
{0.15854286099017895,0.20690752231666812,0.3034353470028534},
{0.17036259614273358,0.20126243142164665,0.31909425108603523},
{0.17215761225739684,0.21770090547242582,0.32725905181035214},
{0.1386245657574127,0.2080456344871867,0.3091391559842681},
{0.1533316246262787,0.1922257947624048,0.313500863833148},
{0.11398188120715191,0.19158739358376997,0.3483675842181473},
{0.10375575095354461,0.19409923385104355,0.3490659179982591},
{0.1178995598628319,0.1765494041406201,0.35428024022191273},
{0.13200381028082184,0.19408193320760647,0.3268502931266235},
{0.09268167849033246,0.1321234957851151,0.39000559798506},
{0.09726126786662455,0.1550506406006282,0.39011858506687647},
{0.10079667170320708,0.18270193926642575,0.3604737218562542},
{0.11928885358147583,0.11613055048187389,0.3640155452725648},
{0.13411201017793384,0.14225408831647576,0.37776386841296666},
{0.14740439444150905,0.1674274911722877,0.3748197599199873},
{0.150691095332178,0.16633966984064263,0.3652313988014509},
{0.1475197485884376,0.14603869081941406,0.3747230820407232},
{0.13491456918104403,0.12625101792319995,0.36961876018322104},
{0.1382272086438576,0.1231453913171007,0.36923223456133053},
{0.14169473595887494,0.12266875611180697,0.3682897460703636},
{0.15231609172813546,0.14269990210326802,0.3724633032253598},
{0.16346660428355386,0.17571603611201955,0.36640179476577583},
{0.15843738407306365,0.1809435816784722,0.36423886733183136},
{0.11534677308702244,0.1166700554322652,0.3660606523503801},
{0.12825276805182878,0.14433932396409702,0.38063224321537015},
{0.14186880819219672,0.17008258225438166,0.3795417821723698},
{0.1511151098125191,0.1857126478008313,0.3821689394075389},
{0.11221434039800443,0.11896907052063856,0.36612090717014445},
{0.1357627840368921,0.17568832533929374,0.38014648675393775},
{0.10468230203229087,0.11401146952105287,0.37679049653844304},
{0.11773485674587006,0.1398820783929704,0.3965320922195431},
{0.13026552937078248,0.17729400103101156,0.3830277998598859},
{0.11427702076550006,0.14095561058286546,0.3991074714545115},
{0.12367332739166946,0.17577692297534794,0.3885714539593969},
{0.11012130954642751,0.14246465796736346,0.3984693305291089},
{-0.03838550519375292,0.18446674122012943,0.24431525611697183},
{0.010747838840119239,0.1985687608961289,0.24815089303944737},
{0.014096418035001267,0.2262212988630321,0.23401421011151843},
{-0.033709622121539586,0.23171632278715135,0.23927750951487364},
{-0.07075727698555072,0.183263392239401,0.22438111022306234},
{-0.06559313406367119,0.23306717338549313,0.22663292033231539},
{-0.09683295301144619,0.23586939429486856,0.20294054426299912},
{-0.10348491408988134,0.1359992488843856,0.20034084994033477},
{-0.06927095838333318,0.12841264409098338,0.2282662324386928},
{-0.10210881892801432,0.07285532081010049,0.1924666033602745},
{-0.035823386480616635,0.07335899756552301,0.2534774959432872},
{-0.03815291316221487,0.13841511767402556,0.2504513085380702},
{0.005562032934910247,0.07853746680818556,0.28066463916592654},
{0.0013551757592009592,0.14712535960103063,0.2703715618665835},
{0.036756691750389585,0.07871901202717543,0.28460839271687277},
{0.08123720371261645,0.0878827266218067,0.2796230933375724},
{0.10836616174833809,0.1625174421561319,0.012464202710102425},
{0.10678871733581045,0.2117759556016908,0.02781184392754945},
{0.12785806304264,0.20668739765425445,0.05940286841569935},
{0.13492827585127426,0.15985044139041124,0.05574567845944908},
{0.08893579175393959,0.11409986886893027,0.011903344601657987},
{0.12703022229697142,0.11250346314948376,0.06436142367713639},
{0.15809577072324765,0.15867932663144485,0.10622860900453505},
{0.15294400841941513,0.19539240737592098,0.1098077229911194},
{0.1645686527918935,0.186823904316387,0.1603588150970248},
{0.1627022529335357,0.21324575432016782,0.12913338443508823},
{0.17395511936728272,0.1499633219542977,0.15894847804560433},
{0.17096281445429845,0.11196594108086165,0.20363972076786277},
{0.10816486206972176,0.18074870157958386,-0.014880492862118257},
{0.06359707852362383,0.23692401474988903,-0.008459351614639865},
{0.019456382924609498,0.22123929602467318,-0.050831725644810054},
{0.04230912010172976,0.25966129863599213,-0.009703027453351297},
{-0.03242072418547721,0.23581096124772968,-0.06093697446855686},
{-0.014673944743318764,0.21503901062726086,-0.05453102705263568},
{0.10985599996569613,0.28895959129237525,0.11142874123052723},
{0.10538831947925861,0.3153578945751458,0.11322367059411308},
{0.1141278708774161,0.29081118150251883,0.14161563756579676},
{0.13089102942490585,0.2621426025240188,0.10837693747145309},
{0.11287988227085645,0.2510655557381526,0.059379321694688986},
{0.09697963669032969,0.29200337677329496,0.07502055334410192},
{0.09774408718443625,0.2504820803845273,0.03962197449653408},
{0.14904887265084973,0.20540840173402758,0.07661676077537147},
{0.03364113834243269,0.2862941024740037,0.22797794621545978},
{0.028274035078454975,0.23955982230677653,0.2521650017141703},
{0.061060972740698514,0.26317718348015817,0.24865158307920485},
{0.06739382617739911,0.2958947326734875,0.22395232443346386},
{0.09617969261255276,0.3125806455830524,0.1965176679939726},
{0.09106447729833059,0.28329105282043193,0.2293594075511149},
{0.10740835549570336,0.31556619630501,0.17055579698862347},
{0.10744550974285555,0.29462944342349073,0.2028234798805445},
{0.1099638315549125,0.3161207339778148,0.15054157985026775},
{0.11969479905169426,0.29634214515870627,0.17990012732641528},
{0.0253529651930325,0.15698525159184962,0.26934418124986875},
{-0.020427474485098407,0.3080014403901031,0.22538291166495325},
{-0.05901005334069691,0.31023389261608336,0.21510868413542955},
{-0.0685215901836843,0.23325184164326948,0.22802093757082023},
{-0.03566028206208125,0.23185267069481238,0.24132359564056252},
{-0.07324620257537799,0.16527493668859877,0.22948776196664347},
{-0.10299646834504926,0.1693324085090139,0.2040887815235523},
{-0.09863287675848847,0.2355841319663336,0.20808059517138178},
{-0.0867294020302144,0.29000314478852096,0.2059737956845193},
{-0.06729088982755066,0.32169462702430757,0.213308264667945},
{-0.0514685343215239,0.3636080258899418,0.214703358315764},
{-0.013279408780997303,0.37303090313181975,0.21845048435326275},
{0.003141900949466423,0.3585382805332917,0.2175655242196274},
{0.005584922826334494,0.3174239334486381,0.2270518164990895},
{0.00511396362010538,0.2817506263319349,0.23075732680545522},
{0.004833906356214879,0.2269796891747314,0.24687566459458204},
{-0.048526718535590235,0.16428101720174093,0.2503568490077855},
{-0.018975930671909825,0.6378332750996071,0.19965415319760663},
{-0.014846219990037088,0.6331569582720066,0.21598614649737477},
{0.008180155665017971,0.6483496248861724,0.20729709661927892},
{0.01650667279063182,0.6620516105582283,0.17550210795513516},
{-0.023706181883634925,0.6353656778818106,0.17358671852406474},
{0.02885321005724326,0.6758747998784318,0.1415602779854003},
{-0.03740527998411411,0.6308680682736679,0.1463930317915868},
{0.03437012003889102,0.698916728762365,0.11034254338333083},
{0.033446877894097275,0.6875410847680654,0.12390484742775093},
{0.19251613202896808,0.6201975866085733,0.09593752697997236},
{0.20153451378292134,0.6059307646715232,0.0906754544847119},
{0.16245642516618766,0.5930521334751334,0.10237676202359552},
{0.1556717101532984,0.605949292223055,0.11049063986547485},
{0.1504694091503711,0.5941631049514348,0.13022399419422132},
{0.14369374103555418,0.6069636353921368,0.12765431574433964},
{0.18314449988781537,0.6280460929046657,0.10309449086601313},
{0.17606994952531083,0.6280387190630862,0.10049094231690972},
{0.13938725644394906,0.5955354202449288,0.13687288180591403},
{0.12021157521980512,0.6039094397819286,0.15863005201947802},
{0.11430359138120859,0.5929655311138594,0.19147791372408302},
{0.13777710687523914,0.5772466820361897,0.16670909310727308},
{0.1580503379447087,0.5773091799909555,0.12442187145608292},
{0.16961053865968506,0.646068108729413,0.0647720784915569},
{0.15992461975809946,0.5875207980286139,0.09321053164771942},
{0.16734212191561426,0.6210379566884213,0.06778276223994033},
{0.15879738865128973,0.6358187663660941,0.057419875109307135},
{0.1627701418481119,0.6524387732428522,0.05448397078964815},
{0.16913584915712748,0.6742714045007486,0.06490040812106332},
{0.16307351036580262,0.6712253387057944,0.05090101496963579},
{-0.03842782732651622,0.42892935643508723,0.22480496359425975},
{0.005295025511663888,0.440257919380377,0.22996559929400984},
{0.03772470984413619,0.43344475001409843,0.22189268035367746},
{0.023396468144282465,0.36003219605128794,0.21374944346860156},
{-0.014709872082376127,0.21823021097471637,0.2649818537504359},
{0.028573945946060497,0.24207809454678939,0.2630745817416086},
{0.15806730397684726,0.2857110980547985,0.27409359205668965},
{0.15202827643932262,0.27262644544257875,0.26934172743367923},
{0.19455805410294144,0.31259530651513406,0.25087394739418384},
{0.2008660843384928,0.29269946741840513,0.26648429566004006},
{0.25958931383126155,0.30403955586397885,0.2031293146074358},
{0.2461205026622636,0.2869252289551473,0.19141247862569638},
{0.10755287039765167,0.7104203925608943,0.13817329284924934},
{0.09792477728566307,0.7096038542413106,0.1394066948817936},
{0.09733931905026835,0.6918785271012935,0.16474701920354692},
{0.08347479903818587,0.6917461573501821,0.16106614620316467},
{0.08972970043533116,0.6915753940508128,0.16911463851870157},
{0.0872325458861614,0.6698352518344428,0.17916156583240903},
{0.0777825403430774,0.674324347443989,0.18291268241946848},
{0.07904546252796202,0.6531318399932639,0.1913028500498766},
{0.10385899712866944,0.6608553503798249,0.18097962055462927},
{0.08446159254368543,0.6372167971575339,0.19333411413434004},
{0.11233626284079384,0.6229677467983413,0.16903174166773408},
{0.09659127690280266,0.613926958480395,0.196449047891744},
{0.12091522560166076,0.6262545344400876,0.16712319317876775},
{0.1330431129741745,0.6220742354870759,0.1628458817351933},
{0.1497916725546379,0.5907446167811742,0.16276625663914515},
{0.13127349013916925,0.6397706249462721,0.17724553196476361},
{0.15825121626094918,0.6009312752945613,0.17334745905257748},
{0.14859895677739732,0.6480054585760784,0.18453966169719524},
{0.17885037112823512,0.6453181332722225,0.1825832761855447},
{0.19076021586419306,0.6010486990743367,0.17634891000772263},
{0.21444840309577165,0.6161260239345849,0.15862389269298216},
{0.20669124568418815,0.6548904950134827,0.1614705301539898},
{0.17058545966059102,0.6701389425704211,0.1825163539258311},
{0.19529215411296677,0.6841665546080279,0.1604617514468732},
{0.18156317646282658,0.7041280146983094,0.1534683876998101},
{0.1946193251496126,0.6979426628792217,0.12261050895983408},
{0.2094102475243086,0.6818689647159264,0.12922144917166695},
{0.21958617369011965,0.6491370520227805,0.1308693354590487},
{0.22899496007842446,0.5918472725470556,0.1263524547187105},
{0.20934831964805142,0.6290165648146018,0.10352718045409492},
{0.21221213382238552,0.5778242954955846,0.0960177221545292},
{0.2157636609663546,0.35002006831263155,0.1936026706839686},
{0.20252285641480314,0.33060682545951525,0.18982664414468242},
{0.15485082188683336,0.2608900904684229,0.262892454051099},
{0.19046139558156072,0.30033012936611875,0.19867416345517794},
{0.21942132185702504,0.35016379006187204,0.15755058357728613},
{0.22994174894422856,0.3616148827074931,0.17117669923564433},
{0.23284192421300712,0.35100170632553085,0.20203366089280203},
{0.2649924807574182,0.34800745570981045,0.19402927530362088},
{0.29117068416379716,0.3337255019062588,0.1633898481695656},
{0.2748699212518954,0.3128573071619129,0.14959068889780347},
{0.24366968558143995,0.3036240925612678,0.14565047974801984},
{0.19772935127463764,0.26882180344075957,0.22013590907113942},
{0.19866181381965856,0.6489097518069644,0.0993245492951565},
{0.18261885032378697,0.6550886716533126,0.09017946139614545},
{0.17660226652928854,0.6512309875641646,0.07210577910829695},
{0.17946878238003328,0.6805601883901266,0.07403908883335733},
{0.16944034543882444,0.7056300476385485,0.10042380937600812},
{0.15605464180198197,0.7054453050227057,0.08348380256071954},
{0.14371742407968618,0.7147735244461221,0.11288869989822424},
{0.16773866109043958,0.7117418345439952,0.1398390622515879},
{0.13487499829673555,0.7055927942473079,0.14949145805826142},
{0.12191808044949155,0.7102414994462707,0.1310568541093685},
{0.0821823319149388,0.694394159629951,0.16353545365648697},
{0.08973196835635479,0.7050712591629509,0.1481242610783341},
{0.07073133841340622,0.7065386908163158,0.1133495711934521},
{0.12218703357547396,0.7144006187433845,0.13263324511595617},
{0.10204219410056614,0.7188458430937849,0.09980911602752739},
{0.12072091558128106,0.7202661936981403,0.08043017702901988},
{0.14589734233179127,0.7197902277154435,0.11408463785833997},
{0.0026296234443696433,0.5686941411748986,0.2752639012699372},
{0.03518435325841785,0.5539544639009278,0.2656201433919712},
{0.05479941629661503,0.5786701432863206,0.25924858658173616},
{0.014276116695343394,0.5935377536134439,0.27556802576130246},
{0.017867735230085387,0.6142471071350584,0.26446195454353844},
{0.06077718518047953,0.6192407222247789,0.23554975375365872},
{0.06780640190853361,0.5653881691520343,0.23150622407068389},
{0.05110794727177808,0.5418448314337024,0.24194263893592466},
{0.010772612469224402,0.5399837729631106,0.26210796405811154},
{-0.02453383673413767,0.5384297389484718,0.2541702404754118},
{-0.03378176183890868,0.5570569798612516,0.2578202920572926},
{-0.024858000724383822,0.59772618238171,0.2654050750780693},
{-0.0059917853793712,0.6370250524904432,0.2407237986913736},
{0.029204750208916715,0.6433253742731165,0.22690440163255363},
{0.061352431574762376,0.650880005097989,0.2065034110120863},
{0.07927002388833437,0.6123082329480332,0.21314690766396877},
{0.09772446904793126,0.5498907583959504,0.21260779928993126},
{0.0808379628613805,0.5229524668353573,0.21791271442441953},
{0.04895918504947305,0.5101860667471092,0.23364369625991507},
{0.02376611448511185,0.5214375699496397,0.2419670159886759},
{-0.018457878023659943,0.5200270470030534,0.23684072132256778},
{-0.04531691627853662,0.5445035164890034,0.23959358086889893},
{-0.05706671766969056,0.5634474979784054,0.22948955895324688},
{-0.05079213617098503,0.5733544834112451,0.2467864968800192},
{-0.053153785537245764,0.5913792380914363,0.2445158122149247},
{-0.03819253361856755,0.6184795930576358,0.23636901853567513},
{-0.018748766779215244,0.6402469751123117,0.21650418675261351},
{0.008135999366618038,0.649364166343431,0.2172373820728316},
{0.03635201036729905,0.6595308721090147,0.19818016564139182},
{0.06198426445753646,0.6658274140233151,0.18720215140689087},
{0.09027251431967509,0.7509645000277322,0.0770910289155531},
{0.0721602401953917,0.7453748306781626,0.09399950791070992},
{0.08910517942908137,0.7251932583184785,0.07953349310692359},
{0.059376551856717565,0.7136024220801666,0.09377606192133275},
{0.06730334480366411,0.7413244476600725,0.09497709340899332},
{0.0504649606790518,0.738333976912725,0.09363740891361497},
{0.04069351760815432,0.7084881486347849,0.0901662008743133},
{0.03975368122155387,0.7380539196488344,0.0917363210173056},
{-0.03947903970349568,0.622115652930032,0.18800095532765043},
{-0.036473263587491256,0.622740632477691,0.2009013858304917},
{-0.049089980888179924,0.6114892284192488,0.16148877266626727},
{-0.06446934821393564,0.6313739138060256,0.13173477660026753},
{-0.034816912873556864,0.6696353649590869,0.07618651261046812},
{-0.005749353297053047,0.6951068816959012,0.06913989609488848},
{0.026131122357369294,0.6993667933519502,0.09540856848199142},
{0.04557718190376741,0.7013030154346089,0.10190707929750539},
{0.05097430104052774,0.709004590191597,0.0935283380232928},
{0.04284820368974521,0.6714278652925055,0.17503593245117444},
{-0.057540911451805864,0.6039748748803152,0.2015031036963946},
{-0.05778941610954246,0.5924143891260844,0.23129603860313888},
{-0.043006859017310654,0.6261486361605964,0.2017093977584674},
{-0.022756703734431248,0.6419324370092214,0.20077744332689987},
{-0.05589733793227233,0.6053006668102974,0.18969125049887292},
{-0.06245490144547804,0.5744414372321159,0.1974133728681953},
{-0.06156135295517946,0.5536524710074644,0.20115966857395315},
{-0.06127065009479009,0.5746758262502576,0.18592753021956743},
{-0.08239260413356116,0.552194966155957,0.17767832069693387},
{-0.07303362525669875,0.5734575436912039,0.17460917911538948},
{-0.08358558016403397,0.5723718043854169,0.17571583782384279},
{-0.11429144623037164,0.5578408997757304,0.17073306661879825},
{-0.11886157973922636,0.586431948077051,0.16858848084121975},
{-0.0903068429603059,0.6007660020990909,0.16785987093509316},
{-0.078628524456935,0.6030736179371385,0.1663498321097104},
{-0.09216869458360535,0.6213327616354712,0.15123266371891048},
{-0.07803556844985014,0.6183375815439212,0.14841201440209165},
{0.13316229656152004,0.666931581736546,0.183536298735911},
{0.15882324047235694,0.6888969545358857,0.1760633130678892},
{0.1459382392682829,0.7015081941256867,0.16219305509168688},
{0.12183132937208503,0.6787508583476912,0.17720099148302088},
{0.1169633670214825,0.6503930713005058,0.18044176387470862},
{0.07267313735104142,0.3313365755226591,0.0665061829568697},
{0.057153555498174594,0.31632109178759077,0.052151705252606095},
{0.04802501226892603,0.3078426859184491,0.04148158298483206},
{0.11051255690553109,0.2180394949275436,0.02717459529894301},
{0.12782460191278322,0.628256749306631,0.018100754820504862},
{0.12485512492616789,0.5776840685754624,0.024188127494167058},
{0.11604007530464455,0.587934365200633,0.018176736371301957},
{0.11653883203467694,0.6341327219976647,0.014603409920881714},
{0.10556923265468446,0.6298592028154737,0.0072457040417221626},
{0.10590243114999194,0.5863028872598922,0.010527249439790982},
{0.10786384822413203,0.5248811167882598,0.027111787518900657},
{0.12462224785537551,0.5411404250781723,0.035973806652334114},
{0.15258570168370394,0.537602505460345,0.07147760216378503},
{0.1559133366898978,0.5750783388564128,0.0588923259321507},
{0.15634089557140154,0.6240728563804123,0.045872253300554736},
{0.11957510735089531,0.6861676417105648,0.015403304426614391},
{0.10631406501228603,0.6825009463148332,-0.003872053785469691},
{0.09647605907899565,0.6318188724750547,-0.007210644213438854},
{0.0984000864387735,0.5659741974659378,0.002908943324102136},
{0.09216234936194365,0.5265649799867431,0.009811007758700344},
{0.08370938634450426,0.4967861855056163,0.03578509827295274},
{0.099132290318107,0.4989690904733863,0.0474572822358499},
{0.14290517374192865,0.5157530568864426,0.08095616120434687},
{0.13649352554092073,0.513024029100376,0.12336820526291398},
{0.15033954278749345,0.5544322392632388,0.09712039031342179},
{0.13901549089822882,0.7099279686595125,0.056576096951417805},
{0.15829654989539962,0.709589664243649,0.07897771613301298},
{0.17177982370830233,0.6742352788735143,0.059296883385130644},
{0.14005360386251983,0.5311512739820176,0.15303849893222748},
{0.12667329118548765,0.4985440845521604,0.12262958180385246},
{0.11752363026539617,0.4936534182052997,0.1603322073022831},
{0.12430497437927761,0.535129430531661,0.18232299816730294},
{0.12355768820548647,0.48467625560612565,0.11777398767828595},
{0.11634868606601281,0.49125569278384873,0.08237956048942256},
{0.07126536565290988,0.4639166979967148,0.06468728550989751},
{0.09774059235531789,0.45792962196154574,0.08411828754786004},
{0.10462116730874135,0.45258947349661927,0.1236457963176039},
{0.07385426566294263,0.4220345047329249,0.09995779498119116},
{0.09108055103367285,0.41651101406240526,0.13136168500236406},
{0.0647871917685423,0.37430469398740235,0.0884677758878367},
{0.08686242861091185,0.37731879820683767,0.1231730277317603},
{0.08960332890157195,0.3482912060909963,0.11689778940346866},
{0.06707901891050179,0.3543278293843756,0.07756732950954826},
{0.09433292328371096,0.4274532248879595,0.16222411197739842},
{0.09977164575859326,0.4694547504552277,0.19167637540316712},
{0.11066029399035447,0.5088549830014052,0.1860297353817634},
{0.071039626956487,0.38509600751031325,0.1879930114075622},
{0.07197922787587739,0.36150085461274767,0.18974019049954127},
{0.08357521960678947,0.3680205326911488,0.15426556813612108},
{0.091218212600506,0.3471529947763891,0.15950242085387834},
{0.061679383992496686,0.3256095172524995,0.2175153944898975},
{0.05037324000421093,0.35910408345314826,0.2038075097445781},
{0.04824040280111548,0.3847389772547411,0.20547683594109037},
{0.06613866201743682,0.4387152125778452,0.21188148209085042},
{-0.027606088961457685,0.4693101859812351,0.236489119205839},
{0.0264889581586603,0.47039250481597034,0.23777919447795187},
{0.07418269284899283,0.4782567006640626,0.22161626663503808},
{-0.022134549793293566,0.49649052544080363,0.24115386096111113},
{-0.047903746655722716,0.5297004861425035,0.22295453832715578},
{-0.06253047402691018,0.46528750134286007,0.2247957803730657},
{-0.0748445168185274,0.5256983243304407,0.1987660452391625},
{0.03500319222277086,0.38494198716888345,0.07402880263417912},
{0.05427082958896578,0.4256582707383514,0.07979188738748455},
{0.04201482326813355,0.42491718107008936,0.06706495903945638},
{0.015683975144552293,0.42417107223234873,0.045429773233737064},
{0.013541161567555094,0.3795401834739432,0.04402317887165612},
{0.025324126656300426,0.35926991433411654,0.06361177043823317},
{0.030613699243098702,0.3581775695534352,0.07036940672196053},
{0.0393228629781418,0.35867387246727817,0.0751822945314209},
{0.03461903366599256,0.3338940840356817,0.05665418531409476},
{0.03429330815635307,0.31761861525934953,0.03287285221140363},
{0.025941459716136532,0.29498296645693367,0.005823147481398419},
{-0.007134061601605431,0.27742670477377096,-0.025398775958408715},
{-0.044042914741766095,0.3090549330811173,-0.0029699045454968185},
{-0.014050563894086349,0.3034457695251532,-0.0018384226358941754},
{-0.03828001588362651,0.33632405607190574,0.00227942793439594},
{-0.08987107990548172,0.3663387515185232,0.18404542841619903},
{-0.060930523906301104,0.4275442763402032,0.21697937197561343},
{-0.09164075231253122,0.42672036417903986,0.18913046674849485},
{-0.08238669266728645,0.46683728455470597,0.21017027990997295},
{-0.12119808368605028,0.23899346170142236,0.17986665380354738},
{-0.1211119646522077,0.16642514443791015,0.18286473385968474},
{-0.11153277436185423,0.2916340650437641,0.17683905359506968},
{-0.09582054315208957,0.31714481805358813,0.19126875687645584},
{-0.13572270503913028,0.3086645284467656,0.09529056223069639},
{-0.13690250729884834,0.32413101864025967,0.06302411863988117},
{-0.14255867754575574,0.2843221389474532,0.05348273942626593},
{-0.14705610125873272,0.2592077392172886,0.08345770287943122},
{-0.12152867964903562,0.30263433712612536,0.15365169272637016},
{-0.13686407657155725,0.24288735816888188,0.14811204156943084},
{-0.10344300092648288,0.38549746671052865,0.14106934124534556},
{-0.09968629509143624,0.369133784481485,0.166003856420002},
{-0.10290290111156074,0.43423283398029283,0.16500869763203824},
{-0.0989011854478959,0.46616058897190166,0.19113160342307606},
{-0.13207295088951487,0.30071939384345314,0.12244984596447714},
{-0.14546482624586426,0.2445455926204971,0.10783971283509643},
{-0.12281413232802384,0.33363643333578435,0.12302116377425458},
{-0.1069583652641845,0.3719193491839985,0.1230184125257997},
{-0.11373373594673596,0.45825516157601937,0.11502513107452654},
{-0.10479222804037597,0.43866226963460503,0.14255381328891548},
{0.012498971302625856,0.3251063114314972,0.015479571016665805},
{0.014572954096206526,0.34820024138982997,0.027238357340836825},
{-0.027825395685141464,0.36311692804074336,0.021755404209488217},
{-0.02060329413297937,0.39085993498837074,0.02831863132874748},
{-0.0170038308222377,0.4204792314171802,0.030045101699248504},
{-0.008626167739987107,0.4567473534926271,0.01748974219630839},
{0.03154578999778794,0.46035996578810146,0.022068959782268676},
{0.0025753544489463126,0.48368697110540343,-0.000992934242478836},
{0.03829995623841903,0.4897128124791622,0.006293908399450619},
{0.050902062179070215,0.49996811588080015,-0.006543528428182451},
{0.0020764613957922804,0.49985398864196634,-0.01464780168649175},
{0.06455028696915599,0.5253643698614585,-0.016487259138809284},
{0.09272975098022682,0.5719206120318252,-0.009875513381257648},
{0.06844471633609109,0.5673996415978378,-0.030705413721434028},
{0.09317996428594469,0.6242884328077679,-0.0184933406248027},
{0.08013506845319934,0.6818948785020486,-0.023042802591212542},
{0.06090482080136673,0.66808662276017,-0.05147236995844642},
{0.05065457374824037,0.7293589954834971,0.0028350561921738644},
{0.03644599896316354,0.7075237245142452,-0.03181085791480363},
{0.027085099169587144,0.7311968790234104,0.014504786338881526},
{0.01646473484121123,0.7176673668862497,-0.009230779373972117},
{-0.11978458641681002,0.35438247017013064,0.07128725790694398},
{-0.16259196752812982,0.23369178114282027,0.12717652798901752},
{-0.16249035723046465,0.263799337421296,0.08788697742459982},
{0.02387323967269785,0.7574476930815784,0.04338250977199766},
{0.03217597461009123,0.7616710949270502,0.02849512019922559},
{0.01707132316045999,0.7249519663931778,0.02942196871023722},
{0.02836078615586159,0.7299760311110679,0.011428370059846033},
{0.05332773384045702,0.7271393080589065,0.005010029632866773},
{0.04666986129574721,0.765085344687529,0.017715629608863994},
{0.06594468660835581,0.7648185231594486,0.014857479040583401},
{0.07125421194295768,0.7258169118139545,0.004168544182023191},
{0.08813887157086087,0.7266981292582501,0.00993871773765385},
{0.07947774314667887,0.763173896233975,0.01655813476905045},
{0.020194535449250813,0.7501192099224938,0.06855521861919041},
{0.013340431967447317,0.7181047534255227,0.046692670632599576},
{0.02167904467185387,0.7453903343349961,0.07267019401091507},
{0.012370059201599726,0.7139121729985525,0.059567769820838154},
{0.014507853609118394,0.7092574200101931,0.06705066989770642},
{0.01635609770627609,0.7031051575306307,0.0786240815624707},
{0.035432932274220875,0.7226870816572584,0.08714487152943097},
{0.031865517290075314,0.740034198885805,0.08463760428323779},
{0.02920352330082198,0.6999651155328229,0.08445045742324973},
{0.006091759799576776,0.6983751417861155,0.06615465519820729},
{-0.11851186136017841,0.49079381765472524,0.1453914038518507},
{-0.11596618817271624,0.5099440188481338,0.1363845723842036},
{-0.11847919338302933,0.49534559711420306,0.09950051765917016},
{-0.11105947287653516,0.47149033970055043,0.08249340268900208},
{-0.1100877492724822,0.49460432155077505,0.07033975024649854},
{-0.10017707072234726,0.47481021668182183,0.05163868416684585},
{-0.0940689645411849,0.504860665965342,0.03739979607672094},
{-0.12128270316555483,0.5249558094659068,0.06493398078801965},
{-0.1213014290052636,0.5092348907553905,0.09459960229216423},
{-0.14241987582190524,0.524974634449704,0.10481338910675768},
{-0.13546739661832274,0.5275610806435473,0.1402673151417109},
{-0.12218332806516757,0.5369735477561364,0.16066992924662682},
{-0.10397840379021403,0.5247400471433857,0.1657128809133694},
{-0.06783242723175556,0.6536061081334457,0.08927391647114265},
{0.011378073024466816,0.7341118887264252,0.0676442703413663},
{0.006353004472681059,0.7166934868982728,0.052909500699774466},
{0.010698341153953286,0.7123093353063669,0.06627251273336962},
{0.011860706447112665,0.7452653384254644,0.09726360394920897},
{0.010721788730875237,0.7545659586132543,0.07192604326892164},
{0.016313552499313776,0.7443582071950462,0.03950349731081885},
{0.020858342300554677,0.7696491329747219,0.032152595194730176},
{0.015578597371525388,0.7245132414087107,0.026634594628109316},
{0.0005744160625420229,0.7160178199353864,0.012460695487972982},
{-0.01023060413059924,0.7045527355802808,0.04014228267279648},
{-0.005908392807961385,0.6971490020580515,0.06735567429285681},
{-0.02357337837713652,0.6951293874039826,0.042844640699065954},
{-0.04392980372983901,0.6988480838741139,0.01891589272983897},
{-0.03553343959390184,0.7055691607752202,0.008185267782079389},
{-0.029727772454600843,0.7099514162364343,-0.01278510733844032},
{-0.012401078908278063,0.7174071632260742,-0.03552007373147572},
{0.09265572752517685,0.6821117685885761,-0.013419629504613974},
{0.07037430815783398,0.7285471789011266,0.0044399511241951335},
{0.08142891120067391,0.7489201117445583,0.00967723759733944},
{0.06950817300799593,0.7678577727983209,0.010888827930421499},
{0.040057000167200305,0.7751622259089637,0.017304206427757884},
{-0.07913337854840798,0.3999928281645005,0.05073960839361537},
{-0.053063775097930956,0.3955605545106559,0.034883320823311595},
{-0.06033154489584203,0.37568295792620443,0.03354952300818582},
{-0.08934186115426856,0.3787185268407926,0.05098432078996821},
{-0.11412875078120116,0.3437082210296743,0.0326256859988613},
{-0.0909108163542214,0.3428952642902865,0.013919303317464687},
{-0.07279750121700918,0.34107515232823055,0.0059065524458192945},
{-0.046065454146444626,0.42109891914911723,0.031047683900836058},
{-0.07412698626428674,0.4625945000399395,0.02999557922706042},
{-0.09567233513284604,0.3987112792839956,0.07607532251525503},
{-0.10039020572652411,0.3751951690109584,0.07413322614535449},
{-0.12276084238047409,0.30479539321540017,0.024241429834727855},
{-0.09609356118569908,0.31605445615467626,0.008018978359702084},
{-0.07338336842176879,0.31759610955126816,-0.004641721737231714},
{-0.04193609046888157,0.45366895433182236,0.020900298839491807},
{-0.03687588773074614,0.47806665383948704,0.009389149662283325},
{-0.060675574882814276,0.49206864952323676,0.010105998600915805},
{-0.09637736113892909,0.4523812709108437,0.059547903824112035},
{-0.10408332302183171,0.43143089811017166,0.09575408563029067},
{-0.1058660452695254,0.3738158640592274,0.10099419770995621},
{0.05284070089888556,0.4645934059725303,0.04741638529935824},
{-0.059059526240840765,0.5171645093088584,-0.0059503865259317055},
{-0.030048726654982955,0.5053465587498961,-0.014732074161686691},
{-0.091416451205391,0.5313607158688992,0.01840188020319407},
{0.07157416230944406,0.7759394412044601,0.011432273858329334},
{0.07296222911999316,0.7705744199663401,0.01162137881406456},
{0.0713747587615196,0.7701553626904225,0.015675616058593567},
{0.07123765488018406,0.7749612112696019,0.016230352019575307},
{0.06218996365507848,0.7761697653149745,0.016635913306450954},
{0.0422025030275971,0.7751782996443063,0.020319116192912115},
{0.02637043140090086,0.770231009629921,0.03299964510753884},
{0.07341456163060199,0.7678696824819476,0.010767475566140786},
{0.07538335254632168,0.7604266135426201,0.010761229488567512},
{0.082872659809907,0.7605323259269456,0.01456999836306914},
{0.0855597496465529,0.7672206852788581,0.015917874638756893},
{0.08282368263020541,0.7652039086243216,0.020024385603928878},
{0.08116988487654897,0.7606240342087753,0.019059986269411258},
{-0.02249280695696054,0.6755820645642291,0.09268425004012702},
{-0.039128280311518895,0.6735009929683232,0.07523643959673366},
{-0.053735563048356236,0.6903791338724098,0.02520860520372248},
{-0.01821465278863414,0.6824799525541005,0.07086028149695998},
{-0.00778735917953207,0.6908774196680217,0.08312957312564646},
{-0.008017683290046493,0.6833089830288309,0.08823776160259876},
{-0.015313436506926688,0.6766451990178463,0.09264595563595755},
{-0.023564690876384815,0.670128929017486,0.0917598553453049},
{-0.032906009712489484,0.6703554732596277,0.08775050558682825},
{-0.0727286704335926,0.6586583545584818,0.06219787659263902},
{-0.05910810684418844,0.6852690244787435,0.02448122220569063},
{-0.14625598367880097,0.17212791240639594,0.14883177807963985},
{-0.1622809153435831,0.17247518936226552,0.11658668764687771},
{-0.2343698213673245,-0.0049319288771788915,0.1693759327638501},
{-0.13912829208487937,0.194668618351096,0.1410108462331514},
{-0.1349679458796711,0.2429629927153693,0.1460126654961922},
{-0.13333454702221628,0.24466331383253787,0.09762043591660423},
{-0.14357614375362407,0.21599822968315616,0.09461017353059678},
{-0.166889702653928,0.16108707799884164,0.09942332159328937},
{-0.16590339247585967,0.17744111846528218,0.07444797144719653},
{-0.18314378109317397,0.10163660183116259,0.05151792666709592},
{-0.18011154589856054,0.11457054303590497,0.01622991826418828},
{-0.16300464240335283,0.17225119808040182,0.001959527139953747},
{-0.12531999916396744,0.28651818050694483,-0.010299131285244907},
{-0.14325706089791165,0.16625249740086004,-0.0358607328194402},
{-0.09463986098858637,0.2780389319130512,-0.0379652891713011},
{0.07159629622719382,0.169254307753326,-0.024767984088563524},
{0.036112614572690126,0.17240711455252347,-0.04387678023202704},
{0.03737794100172002,0.2179625343288728,-0.03045761546532774},
{0.06997279938557432,0.21709748976400783,-0.010342519216959244},
{0.09057616787662012,0.21337462924216086,0.009698218965060762},
{-0.1280804804120993,0.13775846159010213,0.1645115519934434},
{-0.1191191808670796,0.23918359527707544,0.17548840128490492},
{-0.17915724686805526,0.09440589952932625,0.08100591914374505},
{-0.06874836989303608,0.1777806497892403,-0.07918570803760072},
{-0.11135492226015976,0.14213836237921523,-0.0734263164015906},
{-0.06617310219516723,0.2129693777805616,-0.06490645591045965},
{-0.014945351685490727,0.17920837423517533,-0.0646945602073886},
{0.0388997903666411,0.21605524992703448,-0.032338862150933095},
{-0.029985274438365614,0.12849452471504413,-0.06978920312325443},
{0.02306904479212808,0.12545196614221923,-0.04199088616727488},
{0.05955884065637081,0.11834360764554827,-0.017691066660946882},
{-0.07809423696419908,0.1358543002270503,-0.08903290958509617},
{-0.030533293387353826,0.3145004097470262,-0.019975594319393202},
{-0.07283064012857847,0.3192742099996093,-0.018233136964627267},
{-0.1633603466067418,0.21506511030854916,0.06912518559076254},
{0.10378836935864945,0.7289908115179726,0.04141448722296361},
{0.10091160448775968,0.7455578754514904,0.033475326050981094},
{0.0875856475572282,0.7739185004982083,0.017512644480743716},
{0.08443033736979697,0.7732880308466504,0.021270217826564408},
{0.08364957767313795,0.7685939424411931,0.02036544126824722},
{0.10370813700505949,0.729157980844135,0.0615705547658901},
{0.08193348025289257,0.7219953533520407,0.0895685231300153},
{0.09153463095884094,0.7372439991971558,0.08540439705643432},
{0.09618753738855253,0.749474562666286,0.08949461121206492},
{0.10984975388812288,0.7591590687646107,0.06358807500109014},
{0.06255606559474514,0.7156195705250349,0.09800283466581232},
{0.06823726972398989,0.7378604647462179,0.11871562105148985},
{0.02842289992728469,0.6803147324131104,0.14610348148122582},
{0.012347689816639924,0.6794291650219331,0.1283059278727624},
{0.01733569087235095,0.6752774195663992,0.13933786409837703},
{0.01365893235163996,0.6737763284950004,0.1299786621473156},
{0.01241344713331406,0.6793618461858658,0.1211164199396831},
{0.01639283059105231,0.6857007474119629,0.1133013871664583},
{0.020708994124293768,0.692291722482981,0.10917705505138481},
{0.01736570674513365,0.6719308852183418,0.13652217198598143},
{-0.059429643516090314,0.6010759389126422,0.16512526629405055},
{-0.05333643373421975,0.6000837172682993,0.1751796789864371},
{-0.09048836339327358,0.6308266508307118,0.12622626908011716},
{-0.09825124637596597,0.6379229013555789,0.09801649176399833},
{-0.1061666005737059,0.6242092042880735,0.1222193855308411},
{0.10610708933460507,0.7671749178890207,0.04178257204439962},
{0.057115310666049315,0.7143204359618386,0.09759327043636493},
{0.05682877185737551,0.7147517871047262,0.09440122736415756},
{0.06403943466033091,0.7392764654036921,0.11474467723428221},
{0.08620392596834084,0.7488790784849451,0.09148970009724981},
{0.09611213830927516,0.7540062158758052,0.07943625754216191},
{0.10472404169353451,0.7602832759767222,0.06293496331832935},
{0.18788733000576446,0.6807498634243706,0.09128148511846303},
{0.20509729378093117,0.6730348546433957,0.10583384203029099},
{0.2261510119008165,0.4724682845961544,0.17246849713629428},
{0.23876328011053527,0.5225239536920022,0.15854379666251378},
{0.2498300778762563,0.47749945050938075,0.16114706017236285},
{0.2798366930796639,0.39955458650746484,0.1598159764266588},
{0.27336466612878113,0.377315005945454,0.15819526801252742},
{0.25057612474894164,0.3665496062086654,0.14543321787116067},
{0.20489495308938585,0.4680537825201671,0.16734636652190163},
{0.16994581918085036,0.5223785341002466,0.1502478902742134},
{0.1694725424815534,0.5239547020326353,0.1221673224913861},
{0.19054077281738765,0.4684617728372102,0.12022956367535588},
{0.20244310738864443,0.43220499036688137,0.14425901725244084},
{0.22791882535620725,0.37904974245433076,0.11394301052796824},
{0.23837164856808887,0.3620100090790577,0.12965651821787186},
{0.2332469773864294,0.3634911597956642,0.10899724485394313},
{0.23538601109505383,0.3476132712070861,0.11027124639071369},
{0.2294039914083964,0.34139057924568084,0.1236054694596209},
{0.20824731215264058,0.49763913449168845,0.09346234523940854},
{0.24226545828447105,0.4906849822316132,0.09780029568609014},
{0.2551621956700171,0.5054701418561671,0.12340086084705201},
{0.28720865092154024,0.41980006962517524,0.13039998734425712},
{0.30144810909017383,0.3695724103218637,0.13149063428242339},
{0.2893526542275991,0.3825231688426117,0.1587613807576605},
{0.29219987416012644,0.36842492903498497,0.1651860292272683},
{0.26645406290956386,0.3697162188221816,0.16541766699695487},
{0.24423586029162828,0.36792296251508855,0.15100335583530286},
{0.24847921488490357,0.4067130499478435,0.0972846101029524},
{0.26389489373305947,0.3805873309432955,0.09194817954134346},
{0.2729343559988225,0.4149927958497242,0.1001139345275119},
{0.27343751224778046,0.3596158776308137,0.09568839027867179},
{0.2763548394438634,0.3370407562944056,0.10146352103872568},
{0.2631314842518817,0.31769038318638687,0.12120806625645758},
{0.2959370486097455,0.33596258911837473,0.11434481673249329},
{0.2934484204521837,0.36273077420918465,0.10245539567875907},
{0.30194270176849075,0.351213403740425,0.1373028821105962},
{0.10207193732710547,0.729465451448486,0.06494882761526723},
{0.09967728537239709,0.7564951786446656,0.05710695158009064},
{0.10075701406782114,0.726809703536806,0.03944647706694062},
{0.09894588703878238,0.7604686010640849,0.042328868364850815},
{0.0895926956980841,0.7626009177607158,0.0265689984205789},
{0.09620134320287124,0.725644648960247,0.022282156751500817},
{0.13060932389054464,0.2954324733610213,0.1271517543599124},
{0.13296029048127334,0.2955874355712914,0.17081728952194897},
{0.03247276243891017,0.6998068319955894,0.11373964121650515},
{0.15665272851564485,0.10649464977291877,0.11615625358680849},
{0.17841901998534765,0.10596127936300104,0.16409580365147802},
{0.12941093211423943,0.20470825857430125,0.05762447132886497},
{0.22646430722036467,0.19329546033284983,0.1294357615118943},
{0.22834184839566365,0.20167940667170667,0.18412613170420924},
{-0.014923044265586148,0.15721322103026297,0.2619368785404548},
{-0.09960696742765351,-0.009709496605123682,0.33191896029131157},
{0.19727256967305892,0.5372883178440007,0.09285537273681699},
{0.21678193271994173,0.5116156873237361,0.0791124901282696},
{0.21348016192782604,0.5365683086875483,0.09489154445365941},
{0.2344231484939074,0.5145416648415375,0.09355135184482766},
{0.2135569862033751,0.5520855730473473,0.07908549815018509},
{0.19151970915387642,0.5520805538778688,0.07799739177928573},
{0.19660830428034592,0.5210856456146234,0.08065197474792632},
{0.1941891637357867,0.4582753993630772,0.05415074750831852},
{0.17144677392912752,0.5315726983230477,0.10633649016579562},
{0.1631806355533886,0.48185192556502254,0.09798854552406236},
{0.23101003889044608,0.538459420209956,0.10707883152817459},
{0.255537084254524,0.5207219974911463,0.1285921568561598},
{0.23708386600302173,0.5520694993120049,0.09564503952599063},
{0.20177245959523643,0.5759519841709521,0.08919201106105981},
{0.18662942699035837,0.5716169089028359,0.08446655594461416},
{0.15940819059429825,0.5498969920805127,0.10222077119340749},
{0.24137554094641253,0.5443870221850574,0.13183882832111118},
{0.27793743934899123,0.47238981205013464,0.18046031621226258},
{0.23837273915306206,0.5248345934247479,0.16321545371795632},
{0.23305986770547452,0.5440102374698585,0.16582790044899942},
{0.24513064808303267,0.5535714455011668,0.12976795617330614},
{0.2246028769594412,0.5837546363261299,0.10564001533734263},
{0.2277457569567811,0.543776034346883,0.15995857041189307},
{0.20706358130841712,0.5179068382782261,0.1782843761167071},
{0.20374049453728157,0.5306679341577415,0.1722016260361696},
{0.1806002271106028,0.4609486462063712,0.18260554642641608},
{0.18040568162301307,0.5171533555989061,0.1680772319560408},
{0.1996557333065165,0.5391893561682658,0.18567406835740757},
{0.1849476829967659,0.5213658020226025,0.16397638459692238},
{0.15278184586972018,0.4710266675848235,0.13251195471673075},
{0.17578927261086746,0.519799275852817,0.14893994428015478},
{0.17043550422678821,0.5244590356176438,0.134653281132401},
{0.1771116192837756,0.5327710405273086,0.11127634437354603},
{-0.07585625745528689,0.5843217529051586,0.20190566587459421},
{-0.07156654060764331,0.5709403000711092,0.241406690779707},
{-0.055950119766368656,0.5973335965774123,0.2718055076040697},
{-0.06653994771549743,0.6148140254259103,0.25448379604819227},
{-0.07298389210332268,0.6007903915448534,0.19584890393824547},
{-0.06725503684655963,0.6269144994579636,0.2371905884177484},
{-0.08067292513311995,0.5575024962157785,0.21568870183896982},
{-0.08940792829621916,0.5829947216740706,0.1879897520456539},
{-0.14433087812706108,0.6071922616601364,0.17460960047776547},
{-0.15957801202482705,0.5871813534557331,0.16540283256271834},
{-0.12730906504577813,0.5654799765779525,0.18417203541716837},
{-0.10072482941810329,0.5555382907141503,0.19510019256818267},
{-0.08485676848729438,0.5996264647323006,0.183658778864198},
{-0.12829430942489542,0.6209348964084627,0.17451665289482987},
{0.15034399187846334,0.5344180221248831,0.1381836286204718},
{0.1473906877712788,0.5577591182957582,0.13904909454771275},
{0.15539037640926898,0.5642294350111149,0.10378600849004291},
{0.2346870452713782,0.5640473321066275,0.17413741436344157},
{0.23891679233851165,0.5865777394591382,0.13901191551453854},
{0.228488073533138,0.580999694753941,0.174070504496739},
{0.1959204921666225,0.5687033120030817,0.18740537200222124},
{0.16990384405239667,0.5286441554519572,0.1766953318458291},
{0.16620453025155996,0.5582597587634713,0.176954345776943},
{0.15666312625192266,0.5560153968538643,0.1571193315784871},
{0.16145659421305497,0.5212433590733486,0.1363736665344725},
{0.2193643635782021,0.5749667645778569,0.1087333108974392},
{0.21403659573132275,0.5676474646399663,0.10513066258285557},
{0.21907001717256172,0.5672594270707267,0.09000003538204657},
{0.23309082544709753,0.5831969756145384,0.09837771085730818},
{0.23053293275073208,0.5743644766334454,0.13667583293009056},
{0.24800210874518958,0.5836121414849841,0.13934900541531828},
{0.22120097063797634,0.5695819764870994,0.16340136127683852},
{0.23095921515209691,0.5751824401493006,0.17507432599943237},
{0.1963715977691366,0.5610382470566706,0.1750098947349414},
{0.19844000370774104,0.5633111624637556,0.19497254455428448},
{0.17045035105403583,0.5536296802601287,0.1651041486032076},
{0.1610899221948796,0.5525973796180239,0.18087302826651872},
{0.16832062449671595,0.5458616417848362,0.15432749601237827},
{0.15685554014161032,0.5403332434819375,0.16249187537431928},
{0.1422185513572668,0.5667706962866405,0.16472618655195828},
{0.15377430298127326,0.5738451970771008,0.18590623902656964},
{0.18896213867579845,0.5877218126679759,0.20103057057776114},
{0.23069754911661658,0.5998193495564084,0.1825349186563961},
{0.15836736356058548,0.5506762894018666,0.13635646503512386},
{0.14477573765200197,0.5477132443879906,0.1418312883512184},
{0.13281057051468076,0.5729678586452661,0.13997303070112574},
{0.13393931356883956,0.583811644176997,0.16381279685095573},
{0.14064147873507094,0.591697788047673,0.17889138579833183},
{0.14467409017530353,0.6033877064093944,0.1820638603060785},
{0.18211838335822855,0.6090499988037645,0.19655514445941222},
{0.21357801714314067,0.6212298996436889,0.17592573825213345},
{0.16530477286272133,0.5626567743008558,0.11130732690119122},
{0.15458730929270545,0.5629716187467863,0.10248350302783878},
{0.1905827975178856,0.5668556008053993,0.09665011272280086},
{0.19486483069867316,0.5689198426922883,0.08060618257206671},
{0.19563079314012885,0.5630897241421697,0.09703232557684308},
{0.20544926768799163,0.5960414640654637,0.0838677504363099},
{0.18363394946654313,0.5906677429335809,0.07972394890086416},
{0.14502137952418415,0.5791723948454716,0.09962044482717919},
{0.14245455146684577,0.601948828253507,0.10522113156357954},
{0.17669148381589567,0.6148872185492191,0.08383946958507536},
{0.1883899161762138,0.6130266310130478,0.08062570156448319},
{0.1864079886687726,0.6306927691322513,0.08633801215148366},
{0.2006237018282189,0.6276690231502126,0.08798069337422101},
{0.2020377196039236,0.6353357983321497,0.09347995570812206},
{0.21962211342218804,0.6305246579372484,0.10091703882310862},
{0.21089702466793536,0.613789284520551,0.08817649055592762},
{0.22999512564285574,0.6002951296439393,0.09863527480612823},
{0.24576980523534206,0.6081084645746491,0.1407341350822466},
{0.2300632004525977,0.6284761056023589,0.13939238095402157},
{0.13731814410371423,0.6072737704938653,0.17342702218357037},
{0.15441834297993956,0.6075829513337422,0.16789527776768606},
{0.1788020012060755,0.6124754022741955,0.1769779048909644},
{0.2028840879011241,0.6189024302019264,0.1657411617646039},
{0.13263172697210157,0.6090897184042054,0.1614334254788819},
{0.12784837170799257,0.5971791053015619,0.15429190328461947},
{0.14841769659766185,0.6115227019421167,0.1587844689372617},
{0.1271499759628256,0.5983766915321483,0.14338045191251148},
{0.21176741062056634,0.6234556348576757,0.14029954936347297},
{0.20299443527158517,0.6253678392849045,0.11379089871024138},
{0.19575011305059603,0.6272043967726343,0.10984444348288448},
{0.1879815044967948,0.6277981707184489,0.10727341419479748},
{0.18025468517628138,0.6241556912663246,0.1052121342375514},
{0.1749130619430391,0.6151387223156319,0.1026210778435945},
{0.1525176764460062,0.6066754483129921,0.116606590822637},
{0.14269498827438357,0.6030170686276803,0.1407915519024787},
{0.14340569027953126,0.608296615268533,0.14559897439406247},
{-0.004560045597853446,0.6894856349541553,0.08270180356295474},
{0.017435913152777677,0.7287270138845904,0.08242139929475463},
{0.017634610299071863,0.7453012657645219,0.09713967383862816},
{-0.02978473073342377,0.6673120595690399,0.08811011358870055},
{0.11768677186296468,0.7091522777043763,0.1338240399764828},
{0.01843443044673817,0.7574913660525471,0.06561353915637837},
{0.019508433571053398,0.7383946778808874,0.05839044616333167},
{0.013552364849551577,0.7191680737743057,0.04925307911020981},
{0.012714597302025434,0.7152035495368263,0.06241692306309057},
{0.07829098840775721,0.7330209567490049,0.08683364584272943},
{0.06911020863689891,0.7187840143616158,0.08959233010425788},
{0.04687470537552619,0.7157551624590214,0.10441435893670964},
{0.04803594290467931,0.7334337679473495,0.10731929312173448},
{0.032395950556372136,0.7354191531048759,0.10134338318952867},
{0.0312347130272191,0.7177405476165478,0.09843970069862068},
{0.05672094026815914,0.7443011002000908,0.058758518591756626},
{0.04492052581984406,0.7591997178408815,0.014036033088620729},
{0.07452000582397161,0.7582447495877787,0.011448198877538968},
{0.09942828499421819,0.7545710645338104,0.03259589320027767},
{0.10322332241246746,0.7476319573891596,0.06718154009447974},
{0.08168177819830295,0.7385062521594434,0.0895698863612317},
{0.05207710552254197,0.726523970273851,0.1026755079481616},
{0.039926997481201085,0.7255725959939552,0.10184166898514084},
{0.029838057860006685,0.7277504941852578,0.09535657980060278},
{0.02054575338263678,0.7352487739888491,0.07571484700260869},
{0.015936197705606267,0.7471531410139196,0.05217005930198311},
{0.02743626753092883,0.7565590894026921,0.023323863688998723},
{0.03744336370709564,0.7349747645143551,0.10264549207537893},
{0.04196135981842899,0.7330296566427675,0.10333394862567735},
{0.040880639682120246,0.734128904330608,0.10638037381795229},
{0.03941722336433806,0.7372723544064567,0.10706279497186541},
{0.042888381831595504,0.7371711902571896,0.10492290614547793},
{0.038300055382507504,0.7377549506500692,0.103170212163578},
{0.0405530180417889,0.7394430646513458,0.10481094768357925},
{0.07227663535524917,0.761752975551111,0.015663061938391728},
{0.07723509147259774,0.7596276609057278,0.015503192095742503},
{0.07145220268762148,0.7666497888314567,0.01567980489633119},
{0.053025071724396584,0.7391136460244107,0.10487575073840194},
{0.07772022828347734,0.7487989080964106,0.09823419978925561},
{0.10376912301247633,0.7636657500568482,0.0662889582590437},
{0.10059560749180078,0.770758034818177,0.040078966779300756},
{0.07860991015432582,0.7765237592828377,0.017279841768017695},
{0.0466533661980289,0.7777812905079121,0.01912591708824024},
{0.0288438905129276,0.7742314612064579,0.03263376624207116},
{0.021494574702254365,0.7682259567638454,0.051047438395287},
{0.01972367538711009,0.7564167060986458,0.07569878566027742},
{0.031469201189449,0.7419019619753792,0.09657142949559311},
{0.033962328010024925,0.7435713625299577,0.1015419440127012},
{0.040644069494032646,0.7450552397089968,0.10643634065589058},
{0.04835637659859698,0.7417438767263224,0.10704208625038736},
{0.060007579193772795,0.7568181652988613,0.05966320839899641},
{0.02035735482853183,0.7636230189547197,0.050494858818229356},
{0.102726275917961,0.7674946947533522,0.04344199622507644},
{0.09095290301977461,0.772517631707236,0.027624796211649854},
{0.16555141856879924,-0.8393732418073941,0.2136882467799967},
{0.16759626539338232,-0.8395888801998048,0.21775935091257578},
{0.15739344639357525,-0.8474025993138574,0.22668380603571986},
{0.14356127214035438,-0.8433737057769422,0.23332621210262916},
{0.1463000904051567,-0.8434530210477138,0.23667108578720478},
{0.13119454665872934,-0.8498342691925963,0.25068681292720685},
{0.13507203477954802,-0.8503447744971118,0.2520285050903766},
{0.1299029222602342,-0.8551606985942812,0.27202710703479915},
{0.12758169889604482,-0.8370359199218405,0.2756309946504886},
{0.13200087313720107,-0.8202220987451452,0.24729614706677164},
{0.12701906858701914,-0.8189185770560343,0.27459493892603315},
{0.13404341486172736,-0.8213761111488513,0.2547326601032495},
{0.14365293085013994,-0.8149738816362476,0.2395090853195049},
{0.1537404080960294,-0.8072261924851125,0.23062197033867887},
{0.16290549831488826,-0.8108941023959279,0.21652625870530798},
{0.16495034513947132,-0.8111109800894443,0.2205986021389928},
{0.17050901956838477,-0.8245730494604266,0.21533268781030432},
{0.002184813491473012,-0.8240051645147123,-0.18641471187727157},
{0.0029910532188674867,-0.8101021146312503,-0.1791751733585508},
{0.005069336387285196,-0.8386655389109225,-0.18161037524544124},
{0.0006066131052709004,-0.8389121474379673,-0.18252251325232693},
{-0.005363447325715565,-0.8463619086032661,-0.1701262924043836},
{-0.00819738195038862,-0.8418839914896947,-0.1551736164493576},
{-0.01871226936164915,-0.8183065110258978,-0.14109028543403368},
{-0.008250138998462896,-0.8060684745710999,-0.16678771436942552},
{-0.001470443155052163,-0.8103487355513062,-0.18008727418640333},
{-0.02175638945386729,-0.8478587116928389,-0.13854414131215131},
{-0.044922830919900764,-0.834784047847532,-0.1289797482770012},
{-0.042029038051817166,-0.8529943382962738,-0.1316095452235256},
{-0.024055454114284756,-0.8484721285611806,-0.14192424832716502},
{-0.012137095379729903,-0.8420190753102277,-0.15694829563287455},
{-0.043788845622064414,-0.8166654780736313,-0.12924867661696157},
{-0.026423770920494805,-0.8194675378738631,-0.14110012548481382},
{-0.014214188819086135,-0.8134556634235666,-0.15451430826106777},
{0.22009023462888488,-0.8048334986261511,0.2661263855006827},
{0.21580385150121592,-0.8095531785994438,0.2793166885321725},
{0.2198749432407839,-0.8089781428863488,0.28028830059912585},
{0.20798168035362172,-0.812198057840426,0.29751016166490835},
{0.20358059990861027,-0.8128447747294807,0.29324022406291345},
{0.1891985229687203,-0.8083337187043398,0.30870670186339644},
{0.1891514295266996,-0.8259888022576796,0.31200943931037456},
{0.19133381398800522,-0.8444667817452758,0.31086556438971386},
{0.22313468933240163,-0.8373001141315765,0.28355300389516674},
{0.20697135252012283,-0.8417725411412493,0.29575848390991516},
{0.21918216152962625,-0.8379703529556195,0.28198365211886006},
{0.2248193952556369,-0.8446854936044288,0.2698781837033503},
{0.23096418474953115,-0.839503368423504,0.2547388566087786},
{0.22645688380674087,-0.8399928923602981,0.255239534255525},
{0.22577313660064452,-0.8261965834810794,0.24823476893828847},
{0.22758587472112082,-0.8110861940673282,0.25207189302209093},
{0.22307852420628635,-0.8115744787030165,0.25257257066883737},
{-0.04809915965408648,-0.811930083762317,-0.23240563445521298},
{-0.04741505305066949,-0.8122832721844612,-0.2279094376503307},
{-0.04391252787242403,-0.8270083133123726,-0.23119488684688277},
{-0.05152829342084597,-0.8404154196793123,-0.2341232933948517},
{-0.05084418681742893,-0.8407686081014565,-0.22962710898298053},
{-0.06455583903811,-0.8453081804450419,-0.2241144621971367},
{-0.07733207917713825,-0.8377803804891102,-0.21916629227896636},
{-0.07479121447796662,-0.8383470261337187,-0.21573702218908522},
{-0.08492869752347544,-0.8416931391194002,-0.2002680657863907},
{-0.09546647482616026,-0.843823497720284,-0.18117663225141953},
{-0.08690465159958667,-0.8121491550187906,-0.20167659345819663},
{-0.09602045481346747,-0.8252823138762916,-0.1793288343026599},
{-0.0928552550032119,-0.8076594521517029,-0.18075900017177332},
{-0.081640831689767,-0.8126984504479179,-0.19851445472167248},
{-0.07136208071120713,-0.8098616902167236,-0.21401935085643548},
{-0.07335486449633523,-0.8093994309042573,-0.2177161860550605},
{-0.059736296181711404,-0.8053630643816739,-0.2217168607057965},
{0.15185217175218735,-0.8505827327024378,0.3440466121966153},
{0.15665319945006512,-0.8176421093100631,0.32644108829449686},
{0.1896942558040545,-0.8382653190118129,0.31579302558640615},
{0.17491930802061237,-0.8647615766539865,0.3366901084395284},
{0.20002255404082464,-0.8556911318605781,0.3133206322733304},
{0.18843261009930887,-0.8814462874414786,0.3289320959101818},
{0.1830007905315859,-0.8984457807098459,0.34232398365954225},
{0.20112057482057047,-0.9185274282213686,0.34916741675882473},
{0.1329813214210389,-0.8427206064871924,0.3427217869214956},
{0.1306378278159783,-0.868603410081991,0.34975483308996663},
{0.11850629689821343,-0.8772921501348104,0.3366690527137407},
{0.12108777349462238,-0.8514378504654453,0.3285020460334554},
{0.11481936371542373,-0.8664321545446155,0.3061512629832205},
{0.1084407057098525,-0.8879451824403354,0.31964601272436305},
{0.10749387966501515,-0.9005463960841904,0.3039527304285061},
{0.1623225434677272,-0.8829208822552351,0.35083472289453443},
{0.12204945875971827,-0.8209609576714169,0.30420308164489035},
{0.1335675356301082,-0.813029430594246,0.32323132321647635},
{0.12185615257323429,-0.8463641393452566,0.27228612096591304},
{0.12388989525990936,-0.8615503244146391,0.2684362320807207},
{0.1064887940751939,-0.9151118895877399,0.2905323387537121},
{0.12660512962466816,-0.9111585190602126,0.2606044563495564},
{0.223771293524433,-0.8790754920330568,0.3020925518616995},
{0.21925278929964623,-0.9069325146824186,0.32454744859783335},
{-0.1004943318054341,-0.8374076358955165,-0.1827728644687112},
{-0.10534494394055527,-0.815479454522362,-0.14877883513639975},
{-0.11727941358948563,-0.8485514438319524,-0.13428271770875336},
{-0.10168404847399863,-0.8742570273686204,-0.10353689657476448},
{-0.11745662125460507,-0.8658892786952163,-0.11220705950400776},
{-0.11111636919030277,-0.8401502216356804,-0.11664498437089489},
{-0.12659915619333814,-0.881292973501679,-0.14215237887472215},
{-0.11614049587324811,-0.8634478307307526,-0.1580326717074454},
{-0.12365067296745524,-0.8973129851410712,-0.16336415745764218},
{-0.09429409598006597,-0.8486171267905602,-0.10858333067761435},
{-0.07107083255833122,-0.8635792090409792,-0.10787073254177477},
{-0.0826297815791907,-0.8846820282706768,-0.09780514135341385},
{-0.06702451444786833,-0.8974790514892494,-0.10034445692620325},
{-0.11213632639339376,-0.8805737327119123,-0.17258703628706482},
{-0.1348105670322446,-0.9178928069111065,-0.17854682291188403},
{-0.11586908893107618,-0.9069795213733619,-0.202711979960055},
{-0.09805909273951044,-0.8100761017010395,-0.12659285434721515},
{-0.0770169868709866,-0.8178068619990693,-0.118289536938302},
{-0.04503186463118978,-0.8435607782788639,-0.12292574998211843},
{-0.036877944970581784,-0.8593326446578401,-0.12660164099205534},
{-0.10008164453720005,-0.8552796095353836,-0.1885926100685742},
{-0.0953722755491078,-0.8794249005868285,-0.21372563649435894},
{0.1897066364221015,-0.8525916397949526,0.299637496371094},
{0.19281108569215039,-0.8696134404832244,0.3106288578785045},
{0.19260751809251037,-0.8386241834330217,0.29485256719458064},
{0.1650345928286441,-0.8494871781318927,0.2844399469105714},
{0.2076481472470156,-0.8258146680593025,0.285846900669973},
{0.22517268282186953,-0.8894653215697303,0.292169802518794},
{0.23529013876150853,-0.8838741278798006,0.2669650949170493},
{0.22830219076027783,-0.9143162582778112,0.2654587987810061},
{0.22096671794295647,-0.9177636221638371,0.2870118189234104},
{0.19882169605531885,-0.8950872747131065,0.31314465151630566},
{0.17280007834365876,-0.8866662236991416,0.34233018016507133},
{0.17192265316074667,-0.9083416000397222,0.35064092098760824},
{0.18668794678857462,-0.931119322320908,0.32646591149564613},
{0.19798638232398216,-0.7844511347013041,0.22205725954052877},
{0.20560560552248933,-0.7824632833345772,0.20962706944927526},
{0.17472840607827375,-0.7857585849749205,0.2062958280768635},
{0.20656341177512408,-0.8239702781885838,0.21253378822789243},
{0.18563677159062833,-0.8243529000119909,0.21218621383975753},
{0.17649443494007216,-0.8608218136526009,0.19853655146038904},
{0.2140972966994853,-0.8886057051437088,0.19668131770499456},
{0.17968316907832702,-0.8895364202741705,0.19355330932092427},
{0.18080544298071355,-0.9207117212063772,0.20022124499061322},
{0.21300593096667758,-0.9198343703815316,0.20027656739197652},
{0.15467406037011197,-0.7940990814170079,0.21891810983951726},
{0.16254823259210588,-0.7907449129741386,0.22334957794764312},
{0.14099590645832094,-0.8107379504565962,0.23348113713386623},
{0.14475592122732,-0.8360333253272418,0.24148329198105697},
{0.1625188239768651,-0.8258921243784154,0.22599326745956366},
{0.15174808285231048,-0.868828950490237,0.21836783536251644},
{0.15401229836563265,-0.8917808069697999,0.21741729141436172},
{0.1530055645053406,-0.9162380672886097,0.22800191429884611},
{0.20551265793955373,-0.7962133414965273,0.2817234112796514},
{0.21111802923413403,-0.799248402297662,0.28611921230195214},
{0.21386867043148586,-0.7835939968774943,0.26492237969036814},
{0.2161917403543228,-0.780039235157639,0.23731801335744757},
{0.22314668576710583,-0.7848204464308349,0.2710406357475871},
{0.2191883580351553,-0.8212273950161544,0.266957126210939},
{0.1415721442934884,-0.8720895516996175,0.2455593533180592},
{0.13805115352876648,-0.854352959312549,0.27029390725929364},
{0.15148659031898504,-0.8263221618621308,0.2452247420194911},
{0.14328986519818243,-0.8410946310433615,0.27779853228454665},
{0.10501526506038833,-0.8879464217414412,0.3256033207469706},
{0.1151130904705113,-0.8773144575547149,0.34262016423081926},
{0.07639509318308113,-0.9066842826709253,0.34916046427962116},
{0.10924864327976178,-0.9129447237440136,0.2974236088756787},
{0.07364280371525862,-0.9379652464154131,0.3496815780016023},
{0.07741521149531592,-0.9439194190062231,0.3419407917576265},
{0.12092911816705684,-0.9329888080390192,0.293242690272114},
{0.11439180483391997,-0.9391097285936157,0.28936987431646427},
{0.12197528658853563,-0.9454516908934439,0.2876213072072467},
{0.08080709187083475,-0.9573537156394242,0.3485903238058942},
{0.06221681931004134,-0.9453704794919804,0.3749666418870476},
{0.06683237320442388,-0.9565491861475559,0.3775002814607724},
{0.06178116779231666,-0.9445139984977564,0.41836468629840656},
{0.06404274359428343,-0.9386338493619963,0.41189833534658826},
{0.08319365118932229,-0.9365902542315303,0.4380054524415381},
{0.08046764729795398,-0.9420372676308104,0.44403845697568856},
{0.1140610229757688,-0.9418094716945519,0.4432753325337652},
{0.11318348625575729,-0.9537917535801443,0.4405100551903538},
{0.15315343791328564,-0.9421051317593644,0.4225810984856416},
{0.14881590882898002,-0.953555034675924,0.4192362124080549},
{0.17326896791704113,-0.9416827903355163,0.39263783635476285},
{0.17239700805200578,-0.9521177304324411,0.38139560312450366},
{0.19233643336862596,-0.9369706948849912,0.32897421975476826},
{0.19382759763816723,-0.942354256067654,0.31251022849422044},
{0.20013780904366474,-0.925079600774764,0.31259684324850534},
{0.22574463267521097,-0.9307122243006613,0.27075946311270144},
{0.2319704848544361,-0.9193304705519101,0.26496306594567187},
{0.22926930416421717,-0.9187516797564645,0.22751136174213415},
{0.2253935634579577,-0.9325290273287645,0.23121566992642723},
{0.2110003204151044,-0.9330371283891347,0.20535393445042738},
{0.09711934310398736,-0.897003791908183,0.3735919223494081},
{0.06808197290242106,-0.9103572241442304,0.3708774687443459},
{0.14540283640455184,-0.8763886996286764,0.3579961730505783},
{0.1272718488335707,-0.8686467856206942,0.3556960301981988},
{0.11609434430006789,-0.8872108469630999,0.3786139546134846},
{0.15072710942231274,-0.9117494302204728,0.4170294632870091},
{0.1489200101218679,-0.9365171230732766,0.41906396194735873},
{0.16974272251563055,-0.9208065029549495,0.39644670437335294},
{0.16551094299468352,-0.9056740787675369,0.39217969152196774},
{0.18867890880107716,-0.9109642957909104,0.3376141065579966},
{0.171035896040508,-0.9361527065831137,0.38469837775051496},
{0.12633375986152945,-0.9146909485741411,0.42853827018512763},
{0.13171008352573435,-0.8937367215470301,0.3881736011253994},
{0.16541629756923293,-0.8860998630937874,0.3562512618796228},
{0.06649408118157152,-0.918055923722653,0.39870948229739234},
{0.09468942063980772,-0.910046890754325,0.42289217545621044},
{0.0847353541579584,-0.9243471862142426,0.43415988871720507},
{0.11423319907839873,-0.8888845726785378,0.30723690314491925},
{0.12781840540725417,-0.8714934478677241,0.2728314134524685},
{0.12870931418619738,-0.898019436343426,0.26389916312536893},
{0.23379868945271293,-0.8849137156124075,0.2246623324299923},
{0.21868642869429206,-0.8211939338862977,0.2369895861713974},
{0.12312025209416945,-0.9256995239739113,0.27265451561262544},
{0.10840472879875085,-0.9110184904282674,0.31316200173178693},
{0.18163381662585762,-0.9337608926279376,0.20628960678531233},
{0.14931144337613733,-0.9209069730955972,0.22770071455809054},
{0.14520579992173938,-0.9333645641343002,0.2444986107155761},
{0.22223081746389162,-0.967445096683797,0.23648764443752307},
{0.22237931052238957,-0.992069018215316,0.2637700279501437},
{0.22507875619106035,-0.9925979519272747,0.2376662197891464},
{0.20889593756539832,-0.9931704966451469,0.21075727487873888},
{0.20778681264774448,-0.9679631245460248,0.21146987301457845},
{0.08607132075001939,-0.9769195784237208,0.4352715542021258},
{0.06399736038778876,-0.9975039484288145,0.4014201064620375},
{0.08553346407009868,-0.9932572849015866,0.43748369428298195},
{0.06540290134392975,-1.0000000000000002,0.3713717639903974},
{0.10439438759938957,-0.9961956554304462,0.30760368670019417},
{0.1245786988145174,-0.9744551166377222,0.2906342093046095},
{0.14445851374794824,-0.9717962828662886,0.24887445899007335},
{0.15578593653622072,-0.9940711463307819,0.22943112590610804},
{0.17872517693052645,-0.9686732316866417,0.21161734984616956},
{0.1788912556717158,-0.9939016842975736,0.2112963708597653},
{0.12734574835851006,-0.9953286899488673,0.43705411534067573},
{0.15871186448197794,-0.9963688353669719,0.41755471627468366},
{0.18911054498321894,-0.993474150202092,0.3504364363051499},
{0.1886586338349861,-0.9728539148229962,0.32319543305645215},
{0.20867038476414126,-0.9699844246495976,0.2855081996777557},
{0.20819824822186161,-0.9926710706925174,0.28668057852385},
{0.14164282163555267,-0.9945498511689221,0.24864147038218146},
{0.13861146634472438,-0.8867628767923836,0.2407805958610528},
{0.14853333578384473,-0.8064474900282891,0.23893777990273854},
{-0.009501101927676463,-0.7848724227192125,-0.20976112464989044},
{-0.004328110395901489,-0.789839838983556,-0.17425732913843955},
{0.01033885708219158,-0.785521828891667,-0.18944772783158165},
{0.001498934687474696,-0.7930146309843705,-0.16696556647112},
{-0.010324022647955,-0.8090177261636684,-0.15017426339551732},
{-0.017140166336887544,-0.8049342414130424,-0.15683180132892863},
{-0.06312567316899656,-0.8482614349801824,-0.16248177507030695},
{-0.05493052196059836,-0.7841269583180469,-0.21785555785741967},
{-0.02796792770532038,-0.7809450775149072,-0.22525858497801862},
{0.0014481233421365573,-0.7832910869012126,-0.21963337247273432},
{-0.027656863127762565,-0.8222125526441945,-0.2263293287404256},
{-0.001769176686607148,-0.8264286054341087,-0.21947718335436936},
{-0.02263950302885502,-0.8853028809456532,-0.2433999950712995},
{0.008953306052887262,-0.8894124281985345,-0.2314042667687091},
{0.005786743011415358,-0.9205693874743752,-0.22848244090961203},
{-0.02473310395894059,-0.919770038261129,-0.23716027511270035},
{-0.06472574721971626,-0.885113119160332,-0.23368398593886486},
{-0.06113783419528066,-0.9150399357655365,-0.2265313348206723},
{-0.08628392285472064,-0.8901594417260823,-0.21714531439368112},
{-0.08005096948015919,-0.918119970803801,-0.21376359628722988},
{-0.09957104008859612,-0.8946236893484569,-0.18629619751252316},
{-0.10926894303187491,-0.9301928951722722,-0.1700565321451377},
{-0.12878259406058376,-0.9070328237139227,-0.1506489405050639},
{-0.12102580843933192,-0.8853933747123993,-0.1542292566137209},
{-0.09560279794779913,-0.8690023782869837,-0.18191029850605783},
{-0.06264358503883731,-0.7856110337852631,-0.22593772198400136},
{-0.057494276551194275,-0.8219399187939277,-0.22144400378133078},
{-0.07403619506527523,-0.8257100462599501,-0.2064102775339849},
{-0.08001908226270678,-0.8379989064530974,-0.1865532285618677},
{-0.08419377957472031,-0.8519756203942886,-0.18227093512784792},
{-0.0752981010232531,-0.7994552788312543,-0.21076866405590125},
{-0.06995916707341042,-0.7962653301779159,-0.20610021679032278},
{-0.04244041166087902,-0.8523989780450437,-0.1400442905147097},
{-0.04225336394497943,-0.869252729503368,-0.1288991937051237},
{-0.019476248921335548,-0.8704424585649436,-0.14922249253926792},
{-0.018676912101100517,-0.8343738267884986,-0.15156972883366812},
{-0.006598658737874279,-0.8250282695426121,-0.1723552869802787},
{0.004147321150586274,-0.8676726205934628,-0.1661885122847674},
{0.004495552368307213,-0.8906864297353051,-0.1679309820325444},
{-0.03443374575766318,-0.8960851227844698,-0.1307182398682286},
{-0.07211309718132675,-0.8858965433543685,-0.1065434410574545},
{-0.07636884478566008,-0.9077342681398101,-0.09869990435879608},
{-0.040814510575114336,-0.9233096805074934,-0.12278303206677359},
{-0.06013649129479892,-0.930375060041815,-0.11511571159235005},
{-0.030100777301426945,-0.9089512618257133,-0.12970473942389887},
{-0.014082810508859421,-0.8850562972046306,-0.14716153480030936},
{-0.12227007914257415,-0.8657901222137406,-0.10727462870988115},
{-0.12914076447317333,-0.8740884824182306,-0.12394446788410361},
{-0.10649501536674504,-0.8741554046779442,-0.09860943537807214},
{-0.1319139237716176,-0.8929768812530371,-0.0728475256061451},
{-0.08743705535464177,-0.8845766876766831,-0.09288139806003894},
{-0.10301520657776905,-0.9020903669738501,-0.05874591489951056},
{-0.12200304693330569,-0.9052210150692758,-0.04514762155097777},
{-0.14859626749399762,-0.9126139170998402,-0.03637479491812933},
{-0.17918002522238,-0.9054985813379435,-0.057856270207695265},
{-0.1416062498599202,-0.8837830144625015,-0.09025324938398524},
{-0.13258107673590713,-0.8844428431572557,-0.143408943444934},
{-0.16714701874252688,-0.9037966119503044,-0.13404260311950306},
{-0.12056292947631266,-0.9100582923244983,-0.16970870989678166},
{-0.17249523505765202,-0.9191507099265127,-0.1365308223077},
{-0.16146179927769935,-0.9345989080356848,-0.1401177314982399},
{-0.16957060837805593,-0.9401932743364456,-0.1401607972116667},
{-0.11314759609573305,-0.9361873698350431,-0.17467777443159593},
{-0.09935913199251403,-0.9246445193355481,-0.1868092805633387},
{-0.09767165003480172,-0.9417184202423081,-0.18016849798087795},
{-0.06558157138435401,-0.9313166438429746,-0.2221982672203476},
{-0.06160505071217026,-0.9201619672358409,-0.23004969826704993},
{-0.02729623889898358,-0.9334014209491869,-0.23204624952753966},
{0.0014121836100681672,-0.933671588590253,-0.2248335294847486},
{-0.18907459285813943,-0.9339962978729857,-0.11026012985979458},
{-0.1935274141243184,-0.9397169117773951,-0.11325428133142652},
{-0.18915641151714488,-0.9510168592601519,-0.10947317365760653},
{-0.1584757776213215,-0.95069298030916,-0.14178632650709969},
{-0.160707002939207,-0.932988758466975,-0.029921183981678763},
{-0.1244948477016984,-0.9398860144132826,-0.03722542641113377},
{-0.1875205340574784,-0.9193452925931355,-0.044849805102241055},
{-0.19261516458033318,-0.9113128120478856,-0.08680131247687889},
{-0.15462643402861573,-0.8906617056782441,-0.10278449208740634},
{-0.20368606443271445,-0.9378389244536981,-0.07024889708243175},
{-0.18763644588990464,-0.9093154676346881,-0.113254380475515},
{-0.02370225329912948,-0.8248572335969995,-0.15792857041455757},
{-0.05108338432386095,-0.8392839625557317,-0.14346099409137794},
{0.0029377756643287644,-0.824460657243141,-0.1978489500278536},
{0.01688359382895225,-0.8605305159276807,-0.19545460789842162},
{0.02089153078416825,-0.8893603899451016,-0.19896184242086912},
{-0.00544744715466719,-0.9150285465883743,-0.16348490256438103},
{0.014184160553292404,-0.9205070630217641,-0.1973835676766006},
{-0.054697198741407924,-0.9363299018552222,-0.10962314148442037},
{-0.05505400592278106,-0.9429595431207416,-0.11710180315150677},
{-0.019344300532600195,-0.9318028340597941,-0.15117012858511145},
{-0.004195777823823335,-0.9195893977319466,-0.15985580756419945},
{0.008118041893594868,-0.9335327868664026,-0.19622052076783303},
{-0.19594103977895674,-0.9368037238470056,-0.037563259892577014},
{-0.16637383117562438,-0.9387395493533108,-0.025881335022988207},
{-0.19081086610038742,-0.9314991185377938,-0.041926293793640164},
{-0.12806627802142675,-0.9512089633245632,-0.04062502763254184},
{-0.10363059393486902,-0.9527352122084098,-0.06125722226730868},
{-0.10061625424822346,-0.939931087794501,-0.05580371493023407},
{-0.07886728820797993,-0.9341611373130692,-0.08497341770387855},
{-0.061138094448512884,-0.9100718254925737,-0.10340793490169406},
{-0.2007450913715327,-0.9497924421606246,-0.06964326302503447},
{-0.1503552075534708,-0.9918800867617356,-0.03030420238143976},
{-0.12156460698809299,-0.9946192272448254,-0.039190623353646564},
{-0.06972743015963542,-0.9928160069568416,-0.09331392653897698},
{-0.058489336195069574,-0.9719382448079589,-0.11812018644219337},
{-0.023351518693174794,-0.9701653006459902,-0.14815919697650684},
{-0.007491079464166554,-0.9928980982620904,-0.16346164088262502},
{-0.02237990662622135,-0.9928283999678997,-0.14481804119524866},
{-0.1887536138717352,-0.9719238813081426,-0.04387820542829871},
{-0.19070179521006525,-0.9882169729461995,-0.04218532011776509},
{-0.20083415994200715,-0.9918495132034553,-0.08264467178197699},
{-0.1898901645228606,-0.9941989430608128,-0.1178362501658417},
{-0.13281156195556532,-0.9926276207957478,-0.1643035724818667},
{-0.10657397124019603,-0.9719820293160272,-0.17155540486755708},
{-0.07537369839070737,-0.9699694786782616,-0.2007154906646205},
{-0.05791495731156081,-0.9925970100584344,-0.2189156684163388},
{-0.03154333618159838,-0.9681724920748399,-0.2265796923498209},
{-0.003636753881015419,-0.9684463776192236,-0.21909928326817535},
{0.003751946918800374,-0.9683063365942672,-0.19098323429468872},
{0.00403825026026414,-0.993529832000776,-0.19047017602989533},
{-0.003216606020124444,-0.9936797874345787,-0.219597469919699},
{-0.07636636618344848,-0.9926239028924303,-0.19927417108555484},
{-0.03339980923809865,-0.9933885516747138,-0.22826762045593132},
{-0.13494069364835443,-0.9178667815878846,-0.17848239164739313},
{-0.05379125724005125,-0.9121052831399946,-0.10241408977290246},
{-0.2654781380747622,0.2798896793984426,0.024298623580760896},
{-0.23137667372958826,0.29497303965507604,0.008549721451275385},
{-0.26796136287950273,0.2844772994459003,0.016489006553368487},
{-0.28564528496957464,0.27773410102005563,0.01096312403171469},
{-0.28631478021295415,0.27354973715941683,0.0028846034503840563},
{-0.26769095977122653,0.28144986034656627,0.007215688168939493},
{-0.25544828833029276,0.2904848859143706,0.002082911958047971},
{-0.2506794700681549,0.29573994396537207,0.00639391999868932},
{-0.24635466860620592,0.3116708746412787,-0.0070100261504306705},
{-0.22335135634472997,0.31105118690934164,-0.019755469656979607},
{-0.22821006111607206,0.28284874625576906,0.006652314279250276},
{-0.2614313738159012,0.27068852551740485,0.023767074943468816},
{-0.2943650447290724,0.26987330085699335,0.009333802474897944},
{-0.267902310181811,0.2759595581596602,0.0028446483827328155},
{-0.2858012262277184,0.2655341606812502,0.0033382744061871655},
{-0.2619335510169856,0.27011894272917547,0.007434932927567975},
{-0.25441689237799514,0.2795900411770803,-0.005098565303865694},
{-0.25876734737283436,0.2856462330349205,-0.013545430959864544},
{-0.27689352645552484,0.3029217682315955,-0.011811152992396937},
{-0.2734077442352189,0.2948254512863854,-0.01651389171957311},
{-0.2878588378536913,0.2953158923059978,-0.014838443375598184},
{-0.2862544014630792,0.30462936404625507,-0.009686916538975788},
{-0.2948464140645903,0.30012172849216623,-0.019547316643248113},
{-0.2955559511266985,0.30850983888273864,-0.009679418767285647},
{-0.30027005424501496,0.28321882635198553,-0.005717893638482156},
{-0.3018590117648155,0.28494995649464433,3.005924832138468e-05},
{-0.28653304592370904,0.26994535382328505,0.003937414525790023},
{-0.2864049145823796,0.2696530026924249,-0.001610626699635623},
{-0.27879010329580906,0.2737886620196055,-0.0013036642087380678},
{-0.2878134050751524,0.2662146485254382,-0.005784382142808744},
{-0.2784720986320588,0.269994231858898,-0.007507023072892827},
{-0.2719931687740166,0.2729298511393027,-0.003369071038666493},
{-0.2900988002443728,0.2621865729272528,0.008653240272643517},
{-0.26326742319017776,0.2663875806017426,0.014861903345531138},
{-0.24847083720942825,0.27044637847434094,0.009016380282667361},
{-0.2470135430391087,0.27145863961756495,-0.005162872638246063},
{-0.2339199550659162,0.27451065405782704,-0.001948720434311088},
{-0.23017919903610135,0.27344771789238664,-0.028516671645455575},
{-0.22223097857303534,0.27848530338534105,-0.01702714827254345},
{-0.21207726068304042,0.2894925775189501,-0.0313870789016726},
{-0.2139083900319269,0.28429471321398164,-0.04108819163481544},
{-0.20786243480122082,0.2971656855295379,-0.04020755666203939},
{-0.18475192299409246,0.29963498058984905,-0.05233746409535563},
{-0.18640515066924024,0.3102433360905096,-0.053160360029612115},
{-0.20983333252882036,0.304344485901063,-0.042990023111788275},
{-0.17404826523839523,0.3240370300443951,-0.0692337483676313},
{-0.21215827379632704,0.3124972530116425,-0.0567006467125515},
{-0.18342140932689704,0.326580931031276,-0.08060153519291993},
{-0.2128719253381066,0.31191481867094606,-0.06737904751171234},
{-0.21394368532742034,0.3053766997920903,-0.07777782480236972},
{-0.1859641205847164,0.3136868953221408,-0.09437033158758978},
{-0.2136166089795755,0.28250382397200074,-0.08911317911771935},
{-0.18018397065518396,0.2940225204929436,-0.1012861398714514},
{-0.19017261363788526,0.27819011425494866,-0.09606123401635408},
{-0.179741428623311,0.2758320092898506,-0.09217001443928308},
{-0.21058656734791936,0.27303574941879394,-0.08487129929276},
{-0.1771298741890641,0.2767553010066885,-0.07722401831721734},
{-0.20729505796895986,0.27247553574692457,-0.074209938883804},
{-0.20715346781762126,0.2856758275453271,-0.054390924062624094},
{-0.22773108363168837,0.2771840000452096,-0.048207307265084855},
{-0.22012201030923775,0.28969273704054926,-0.012062371719555254},
{-0.26609192673343574,0.3126282967105707,-0.007182883868668751},
{-0.2678582158484663,0.3224430905341492,-0.018835437302049923},
{-0.23382844507226339,0.3194695486399069,-0.03760203762417774},
{-0.27490380374412815,0.32127973380010516,-0.038861266691767045},
{-0.29823482439701293,0.3259095272641935,-0.029968054349500412},
{-0.2914685006125339,0.3236244171342274,-0.01872766767788886},
{-0.30783271574105303,0.31664171137667424,-0.013620904397208252},
{-0.31194321725578567,0.31496144215139776,-0.0210182803047647},
{-0.30965766097742153,0.30918011488581487,-0.030238742497030995},
{-0.302306151603791,0.3185478680145065,-0.034547011682228485},
{-0.2732904443855542,0.31289682847417705,-0.054708507363998425},
{-0.27636782731945225,0.2911798364024635,-0.02422450098162252},
{-0.2506140597557904,0.2790927963943971,-0.03545799713908578},
{-0.25611648230751116,0.2729792125023471,-0.04317684775348884},
{-0.2834418819615145,0.27301552402474716,-0.04608675153594797},
{-0.2843332492818668,0.2832931348462897,-0.030497768821155912},
{-0.24167738512374307,0.27718126118976566,-0.044334354986313426},
{-0.2856550010902441,0.26191701254372857,-0.05741812769474793},
{-0.24675905255703107,0.2589971695664009,-0.0621997727233309},
{-0.24715234476295922,0.25621897870546695,-0.07125332584266697},
{-0.28402861667704815,0.2590156103668553,-0.07094310398986113},
{-0.29306268798300095,0.26363008606927574,-0.055397025879352135},
{-0.2986811091182254,0.2743980511593534,-0.05066239993472353},
{-0.2973450062030428,0.2808175069573278,-0.04036875255687182},
{-0.29593439650537906,0.28708227319127544,-0.035129743455190446},
{-0.2954754213408431,0.2937598630165785,-0.0237976485017491},
{-0.2899435653878593,0.25991687970304295,-0.005123041500705399},
{-0.3074565011043629,0.27746320219133697,-0.012078767673185085},
{-0.3025272553140782,0.2807288101771851,-0.01128347097455498},
{-0.2697456466465897,0.2661916718829366,-0.006777644800080627},
{-0.2681343073488182,0.2686404441169356,-0.0005486943680909339},
{-0.28704197731582015,0.2649209049220521,0.008133502174889787},
{-0.30717465924688003,0.2839100837227831,0.0028265050145437833},
{-0.302036653185322,0.31616300653853396,-0.009697363847297745},
{-0.31509912230774767,0.28002781189969594,-7.990393879696817e-05},
{-0.31615255303370654,0.2777328617189498,-0.003210180243890851},
{-0.31528013462726195,0.2770678899246064,-0.0068850674199320595},
{-0.3097954712603873,0.305632454361296,-0.02555013180246103},
{-0.30604307819318893,0.30199177189577514,-0.024759668378143546},
{-0.3147106633761322,0.266691085442555,-0.009029318586211999},
{-0.31748435557405197,0.2994356761860131,-0.03370754629218738},
{-0.31011647503281375,0.31566490663808755,-0.046317410257760934},
{-0.2962691936991131,0.30574345856134316,-0.05701582576978058},
{-0.27265692605327624,0.29517433933369247,-0.07224652653488356},
{-0.29067215050796374,0.2551990586814091,-0.00024009599973370366},
{-0.28567325599553267,0.2572561126218844,0.004862763482463626},
{-0.29355397172736536,0.25855202500220564,0.006379296245640789},
{-0.2843420978917623,0.248916037542173,-0.033310833615207196},
{-0.3063159846896989,0.25717697085326746,-0.037651597275399004},
{-0.298435839036375,0.2627591796101803,-0.039249267081973405},
{-0.28366638135683153,0.2565803465149094,-0.03678321899055937},
{-0.2745479632176175,0.2589489483603738,-0.03873293706226065},
{-0.26168198528551767,0.2531660100033533,-0.03549368901093307},
{-0.2649174162894394,0.26067196108078966,-0.03648863711770884},
{-0.26056170665791156,0.25836028033511504,-0.029337163335566786},
{-0.282491387585404,0.2632233226603275,-0.02821186553848212},
{-0.2821682893941088,0.2579575818337938,-0.021952539836389087},
{-0.28794856325375184,0.2665706253750704,-0.03012035206239316},
{-0.2981075605664575,0.269421724320059,-0.029573151052134716},
{-0.3051103306089137,0.2679251690907075,-0.02453949414368571},
{-0.30723470338545644,0.28757536631525416,-0.03897859132745389},
{-0.29969038354578437,0.26845446219998703,-0.02360620126692388},
{-0.3083840808030269,0.2635215480784291,-0.022956051513805992},
{-0.2822469354422834,0.255090409153463,-0.0201384880567406},
{-0.2828471289678262,0.2648448861922218,-0.021792558456640337},
{-0.2666974368607224,0.266350513105668,-0.024303915396482696},
{-0.2570681911987054,0.2595160773324137,-0.02184200657076207},
{-0.2543004228600713,0.2624191649587909,-0.016909340309425345},
{-0.2799441156995154,0.2530418692115845,-0.00786549091774776},
{-0.2593499552156857,0.26510782870784116,-0.013626803470471885},
{-0.2635399331103339,0.2694956610240315,-0.018163587386569334},
{-0.2815257613427916,0.26886586059507095,-0.012777981357081929},
{-0.27950214374615107,0.26273628971875607,-0.007326209041555449},
{-0.30699002816813675,0.2717445587756859,-0.007679062852401069},
{-0.29950683065900313,0.2751363028280831,-0.013257033199531988},
{-0.28430548893709673,0.2454939430056946,-0.026366744480111056},
{-0.31496926833788114,0.2581399697775356,-0.032191905825806395},
{-0.28388667952139995,0.24700033828582618,-0.0221896553169633},
{-0.2833763725050614,0.2502395615511317,-0.020137583366933356},
{-0.3153022189729675,0.26225115290787643,-0.026019628633385302},
{-0.31383750138902416,0.29375702501704637,-0.04539720440067643},
{-0.31361037467536274,0.29861061147482143,-0.0426762072857756},
{-0.31509997742551066,0.26066987905493183,-0.01582978511615607},
{-0.28090490866781503,0.25093630902582786,-0.014031497246573465},
{-0.3060247117508008,0.2597527342715787,-0.00842628706113691},
{-0.31759066282290815,0.28218177918664544,-0.045768846016286106},
{-0.31166131343324754,0.2995960293560936,-0.06322210938454503},
{-0.3080748751771279,0.30199375477754437,-0.05404497315893781},
{-0.316485317773627,0.26340023289318154,-0.012141736562371191},
{-0.2821700987737233,0.24032227752610286,-0.041030799600605475},
{-0.30684562480328803,0.24648512363710867,-0.04756061516205216},
{-0.29833446420591986,0.24795984238097582,-0.05420093920310373},
{-0.28048316210849755,0.24312430014730135,-0.04748147339343525},
{-0.29221822820950344,0.2534734930007153,-0.05459486345259584},
{-0.29665512445647274,0.26207254483250747,-0.06323792286665515},
{-0.3033919776606557,0.26515670674345426,-0.06920184875716781},
{-0.3111890157818242,0.26719551817165205,-0.06538475177923515},
{-0.3069622926093888,0.2509751735085062,-0.043217583580836744},
{-0.2829500033526193,0.24300951607888133,-0.036033627716711446},
{-0.2627455534945221,0.2535237962326001,-0.03861483166687715},
{-0.26209675457960946,0.2484933862930483,-0.04470433593844133},
{-0.26748012986710645,0.2523680983793899,-0.04908662857868874},
{-0.27865788226083044,0.2513602739341248,-0.049075127864426846},
{-0.2710972160395727,0.2576943542789203,-0.044456141105981166},
{-0.2806843254639923,0.2554197410293203,-0.041160009133897},
{-0.29441450523620516,0.26006436892764523,-0.04575192955619183},
{-0.2961130293667702,0.26891038868380274,-0.05363915161882995},
{-0.29324066401480603,0.2641255338653557,-0.0739862078551725},
{-0.30918181892483554,0.27604625966502255,-0.07306083411247678},
{-0.31079085312255017,0.2740157763402559,-0.057447746991176746},
{-0.3064188342884699,0.2721497110931966,-0.05186379081970478},
{-0.30007807411071424,0.25737183855914475,-0.04212411103614923},
{-0.2826248355284774,0.2517204272284836,-0.0360266628444968},
{-0.26331698284139904,0.25502356125181574,-0.044178277405047976},
{-0.30372227619137565,0.2834445154763641,-0.06760090719567406},
{-0.31390820351711046,0.28321901224715146,-0.057408808150432276},
{-0.29715907385813844,0.2814808800532447,-0.07520693183740436},
{-0.24397226094642288,0.2650336937156917,-0.08097767547154368},
{-0.24658584783448334,0.2830461669219244,-0.08540890811245945},
{0.012030515484630494,0.6179408440809192,-0.06553473199906004},
{-0.015134555785314354,0.6041004408683557,-0.031722780785213865},
{-0.0012338729669644749,0.5923328802923554,-0.036616694100971965},
{0.021098456889805006,0.6050557809117899,-0.07126154240899847},
{0.019594664141995483,0.576028572979291,-0.08109416977548964},
{0.014505399792928926,0.610840801294668,-0.08431138305315597},
{-0.003930468243091962,0.5902919992313109,-0.10658658112894764},
{-0.012896948066733898,0.6458684201422343,-0.10068229040764647},
{-0.03963667880415447,0.6143049701036887,-0.10299501216624993},
{-0.048790057627563374,0.6757106544469674,-0.09026467574018078},
{-0.017519838623662874,0.6887990001764827,-0.08770310231953109},
{-0.04807683984117092,0.702713910171527,-0.07134828109339397},
{-0.07728346139475739,0.6683579801302976,-0.06610727671693224},
{-0.07382579891654224,0.6871768789590904,-0.053524652589664344},
{-0.08361936351217833,0.6441214889104764,-0.04702465461282339},
{-0.07379605569000283,0.6435980576954273,-0.0757763039444457},
{-0.06269031908353732,0.593727416254677,-0.0866364110717401},
{-0.07050208010184279,0.6000710516109978,-0.0533892713368659},
{-0.08107382664783777,0.6383723958666555,-0.026873569060342266},
{-0.06378987659665435,0.5910268428219998,-0.042564471898075946},
{-0.06763299889780895,0.6195183256724799,-0.026043162961384595},
{-0.03661662593941112,0.608228168668459,-0.02348758775808701},
{-0.03198800981137337,0.5937177744920737,-0.03324489040336717},
{-0.15848771209097043,0.5529090142740902,0.10983233551108075},
{-0.1607887844191793,0.5763857891300291,0.09581607547160317},
{-0.14287346002663093,0.5541787402220458,0.060841746571586586},
{-0.1464847710559442,0.5361568235413869,0.0790867374512909},
{-0.1128312273094424,0.5543088420521335,0.04411545723199459},
{-0.13627913884262693,0.5757946548955698,0.05026555093462172},
{-0.1516119332328264,0.5976174461026862,0.09055382947418791},
{-0.15228520834457868,0.5852422066224643,0.13456651766198335},
{-0.14115371906113447,0.5465378788262313,0.1475739494223001},
{-0.108245379462566,0.6379622367726773,0.09774062333784549},
{-0.13087243990831868,0.6247922087072788,0.11249694442566731},
{-0.10747530254143911,0.6315531787109807,0.12540067146945005},
{-0.09935895849035922,0.6360095691643444,0.04588776935039944},
{-0.0783446501456386,0.657165579197503,0.044232372898316503},
{-0.0639914117424808,0.6824822204751241,0.016819020044834074},
{-0.07705923464568355,0.6626429306878533,0.02950630315048745},
{-0.07620281561651499,0.65912298093606,0.026179089506669608},
{-0.0817160200878564,0.6401836220397829,0.02736391093586623},
{-0.08421162551064393,0.6226767217196645,0.022506581788751576},
{-0.08449483059934317,0.5956174991571668,0.012398718039671528},
{-0.12407823184895896,0.6019202747560295,0.04698017609613596},
{-0.10640398870052342,0.5384889279692853,0.041195787756821686},
{-0.07727332391171189,0.5759257977385864,-0.0016247051601976097},
{-0.05027394719961355,0.5600459262682391,-0.021948214675529796},
{-0.02279120587721692,0.5328559450460675,-0.028238237866013722},
{-0.0037177298152689343,0.5608117895656063,-0.0416317738858449},
{-0.006857734634043415,0.5652504951921902,-0.039180622193722696},
{-0.12577920979571353,0.60989888288221,0.14643774577548435},
{-0.13177415539290457,0.5836777624785366,0.16379114626063726},
{-0.09211168673273819,0.6351372375089772,0.12956472318496468},
{-0.13224894403955065,0.5653745492328814,0.16314854385125374},
{-0.09083767280295658,0.6174140047878289,0.14508201233078574},
{-0.16588667430394233,0.2995233195602157,-0.06321414067843469},
{-0.11439864577602403,0.2941940397659874,-0.09341350438282864},
{-0.10047416837644262,0.29500234912622836,-0.12160595626948828},
{-0.05470462215503168,0.6930362202292842,0.011438272075681447},
{-0.03489132051194958,0.7057070206302303,0.0016802630287709847},
{-0.0711116303507344,0.36685964216630546,-0.1305280938995645},
{-0.12240651380131251,0.34746094870817135,-0.10624525281838607},
{-0.06963922909993506,0.3663328896242927,-0.1101860940117336},
{-0.04218644168526583,0.37200888868889304,-0.11922502337802113},
{-0.03626006661825913,0.35971251833104473,-0.1047457356593916},
{-0.1690580210476827,0.31385112750468236,-0.06447561288102552},
{-0.10890214708358895,0.3400610941984033,-0.13022274250010446},
{-0.05543706150157525,0.3583952280066482,-0.15949733971934452},
{-0.019049817803838052,0.37447327611682524,-0.15872095475558903},
{-0.01710462318117298,0.3723897507047299,-0.12942454583688673},
{-0.010687150264967828,0.36335983105748165,-0.11272859458836494},
{-0.0005511172017527473,0.34608144546826325,-0.10404866596640783},
{-0.07621584067113703,0.31765303065105793,-0.1509722989495913},
{-0.024598937221225803,0.3357799161353786,-0.1731394423619676},
{-0.02034290457763805,0.36772213377089236,-0.17796318644911488},
{-0.015072999699388868,0.3799454225425313,-0.173903000559278},
{-0.019590512483291026,0.39671482716759426,-0.16509900550361847},
{-0.0488950883962806,0.4704960360303497,-0.11795561964835312},
{-0.050712808507202264,0.46620511706063344,-0.09614423001141006},
{-0.018945815655038643,0.40224286607317217,-0.09756945106911132},
{-0.00451310087196544,0.3611094089654671,-0.11703002283145839},
{0.013448263556663691,0.34627480122679144,-0.10679979049119087},
{0.014361628471644163,0.3612703446070675,-0.10482433213552195},
{0.007508330535559433,0.37688178345789664,-0.10115992944683588},
{-0.034823741422649844,0.4600030346766177,-0.07629932619012982},
{-0.010537901232795398,0.4670017150254247,-0.06761657196165148},
{-0.04533669552418535,0.5211671420553415,-0.05768488725777309},
{-0.018815713824950946,0.5227116458444766,-0.048439824938556544},
{-0.04939729038338715,0.30593832626722045,-0.14261033781235136},
{-0.007574001101156206,0.320636127556826,-0.1558822983937028},
{0.005556418900900934,0.347884640970225,-0.1775403369118132},
{0.012435060544599377,0.36581078446142706,-0.17616463832630005},
{0.010000503094283915,0.4173797517445656,-0.16251501312596472},
{-0.030789816323245015,0.4758859300416631,-0.13674996792223998},
{-0.03164753661857475,0.520956200614122,-0.12563481262737033},
{0.037914942563877674,0.6423246386301764,-0.060233683484021916},
{0.050153412774062704,0.6459374368208168,-0.05345400003362223},
{0.04749916441672066,0.6294450655649461,-0.04878964246169294},
{0.03962934214160816,0.612331680524955,-0.05625504360694719},
{0.031186405070114713,0.6217342332286975,-0.045548523065695574},
{0.018297747927778607,0.5746656144091455,-0.03987530003557229},
{0.009886908754925554,0.6204165711139693,-0.056017221724742654},
{-0.05198558313587806,0.5934422530702306,-0.006755919851695804},
{-0.04859611939751549,0.7035442543054294,-0.024470477465103273},
{-0.028260427552313214,0.7057862491499246,-0.01249758948189289},
{-0.011389809205938774,0.7123047994643193,-0.03341326185160222},
{-0.03728607161074644,0.7105900157032463,-0.05642274583258512},
{-0.004802043924784517,0.7027882186658314,-0.06451727818420279},
{0.01666796782955267,0.7029098188903333,-0.04669610349666266},
{0.03429401455798336,0.6711684176060045,-0.06021939434227195},
{0.024725903619515884,0.679382839946598,-0.06607381558707544},
{0.04970202213229429,0.6651105279056497,-0.05454115214267013},
{0.03979854392158409,0.6716561197701733,-0.06317162025749443},
{0.0212038222698208,0.7070254387186329,-0.04911397995409393},
{0.06212675929868229,0.6172133619387987,-0.045308098651168846},
{-0.08210434269635022,0.6553256136317319,0.0030172210617165746},
{-0.07833583871477631,0.6785840732048718,-0.012020297447013082},
{-0.08630059145459376,0.6652202060535136,-0.029521868772376395},
{-0.06126176430586143,0.6999849691365382,-0.037298483211321135},
{0.004796690144007471,0.6217032135220192,-0.06207088540832687},
{0.00947381251732661,0.6457630919412517,-0.07545285874884089},
{0.013650182885832945,0.6488702304947003,-0.06476440721771194},
{0.008945411704843295,0.6813077100311281,-0.07045165913635298},
{0.0021582428757645623,0.6670480636474808,-0.08590387258110808},
{0.007409149268061686,0.6313947092785811,-0.08263336935589202},
{-0.08358901302809707,0.6458610463006548,-0.011948579092019981},
{-0.0660916553264935,0.6126801967819303,-0.0011869468305930751},
{-0.0649160047254799,0.6181087569877449,-0.011770739383336538},
{0.020510111082833737,0.49618218732567865,-0.07613159917846976},
{0.027018635451282632,0.48928004853301404,-0.10969440129800431},
{0.029269181473407728,0.4045653163454564,-0.1152679101611543},
{0.03882296609109213,0.37795133749124205,-0.12809967098972277},
{0.03723663588963584,0.3556588263790023,-0.13814047615596758},
{0.030287874589370732,0.3326561337680791,-0.1416885828288846},
{0.00516601426654928,0.3174846344168006,-0.13327248901934294},
{-0.02517886817368857,0.3099789807716298,-0.12027373236676689},
{0.006779720629432875,0.5041259091257306,-0.13001394504979796},
{0.0341755869443124,0.41266050552666006,-0.13938843997650507},
{0.03683795272389742,0.35977397527288174,-0.15899603002903417},
{0.022984697958866734,0.3313796908081301,-0.16380268415393232},
{-0.11663248601924282,0.6290375585753343,0.07716211522698224},
{0.03685980160239277,0.5100598439294826,-0.0798143063444886},
{0.05332276424302277,0.4568056006446,-0.05029135318364464},
{0.017772185114827557,0.5358556733726756,-0.06571320375130743},
{0.0209162920202623,0.5350526434351452,-0.08173860635050977},
{0.028685049290196222,0.5129132975465722,-0.10110709804069531},
{0.014842477300697574,0.5368682195551537,-0.10221432682765728},
{0.0020449707546936913,0.5190322723984324,-0.13216517348130358},
{-0.005404009650908659,0.5427759679265403,-0.11984461196586983},
{-0.04033617752730566,0.4706547905020037,-0.16946998332476984},
{-0.03638031600455566,0.5422764552228333,-0.11571154277800039},
{-0.060343194326236624,0.5165444497865893,-0.10169515880841222},
{-0.055569666719896695,0.5293146173501991,-0.09669203827921034},
{-0.07291243400156178,0.4597340319785909,-0.0776563609009895},
{-0.05367598984420005,0.5201004260215283,-0.07622495573077029},
{-0.034029684025125524,0.4698881712309618,-0.03558884254983698},
{-0.04227194106855552,0.518561226441126,-0.06280828195929367},
{-0.030369718034398235,0.5232284591916206,-0.053269381347890034},
{0.0020466685972086764,0.48060885698385286,-0.03469350946594606},
{-0.006053378644329856,0.5314710508463494,-0.052321316001946956},
{-0.039986645043423565,0.5333007054269198,-0.035340945149642235},
{-0.0416646835267096,0.5566573052546284,-0.03291633928720642},
{-0.05592286753505197,0.5548900494847353,-0.047376504589773334},
{-0.07044622480100401,0.5274779607183807,-0.0659598246713632},
{-0.07176236257537201,0.5571121907255152,-0.06266328372991412},
{-0.07234358240098487,0.567412034608896,-0.09420595068891538},
{-0.06961713236121851,0.5378769858692594,-0.09707494514187182},
{-0.047609610931270245,0.5625315801031471,-0.12683925219307188},
{-0.04943634076123115,0.5795162885093221,-0.12100955500532926},
{-0.012859607924415959,0.5849890050135367,-0.11995120425398036},
{-0.0022338526362298285,0.5519368445216394,-0.1228028360984444},
{0.014336854842539,0.5821943562339178,-0.09588769468250781},
{0.027644470116704605,0.5504286522549041,-0.10445994043138127},
{0.022777722281185783,0.574489658438143,-0.0690159288052745},
{0.035996120268744186,0.5505463734669449,-0.076930118059975},
{0.02250754224710855,0.5702289040573422,-0.05313552443545171},
{0.030124311629426255,0.5506578486014123,-0.05566247178320514},
{-0.0029489417672920806,0.5486786971284481,-0.03275027293902817},
{-0.005650593391931266,0.5630347859241494,-0.0294909110307533},
{-0.003139794137586497,0.5302961562190103,-0.045387426314951594},
{-0.034825513623231164,0.5200638294598738,-0.04526673078025697},
{-0.05900747559439682,0.5159177600034044,-0.07317875361269441},
{-0.03620061734421353,0.5232842401343931,-0.12673640259430086},
{-0.04028783239116806,0.5424908914931712,-0.12259835141598609},
{0.02910432964031312,0.5196393936171567,-0.061183558209579464},
{0.21039301330121432,0.5969321373771966,0.08623999582702532},
{0.2019421199166216,0.6029342461347794,0.08136111523368067},
{0.2148693069303373,0.5969207853790676,0.08424252748371727},
{0.1979906455197862,0.6153427608496923,0.07712560541640515},
{0.19673963301852837,0.6127766391939842,0.08022690686164526},
{0.20056167480787318,0.6224605752138007,0.08429181448869526},
{0.21320089781664328,0.6309438887153211,0.08928935816292102},
{0.20971887067868797,0.6294080104618823,0.09060977152610407},
{0.21362264437596085,0.6333613809894098,0.09599329552973371},
{0.03316927444639633,0.6138828889330727,-0.06182497088990141},
{0.02982561527690444,0.611327933380328,-0.06159623308480244},
{0.030350000753804948,0.6014598124301664,-0.06684665614966831},
{0.03164718961426512,0.5953807430739132,-0.07999669428823036},
{0.028347116664664523,0.5954202643861773,-0.07637489877156198},
{0.025382757991616194,0.6002211929399668,-0.08553457324458838},
{0.022943801022375122,0.6100934655488325,-0.09229743937898224},
{0.009731599540345703,0.5734387187074069,-0.09184261587315073},
{0.023891866368318138,0.5815809021865427,-0.10166904673411287},
{0.02740482646187452,0.5657068058593485,-0.08565659483146622},
{0.011460424582947739,0.5661429654905266,-0.08561885811279439},
{0.013369320076223764,0.5616694602888918,-0.0655838207158611},
{0.028746171620734624,0.5674814354708213,-0.05973310498136397},
{0.029046702138893075,0.5945537946250405,-0.0709307853368694},
{0.022729178856871268,0.5986941880824453,-0.09888959178605108},
{-0.010340145955341625,0.5819749875451786,-0.1286709144414339},
{-0.01228170942576669,0.6064838895410675,-0.1270989849188271},
{-0.04963341442307673,0.5736878678017184,-0.12364432154928796},
{-0.056724844066642396,0.5983350881940265,-0.12584771216433707},
{-0.015867416494233934,0.6269343530616786,-0.11185732873194876},
{-0.05574936538023882,0.6198282748790426,-0.10761767964897985},
{-0.01330451702140098,0.5728165771592802,-0.1112017384469764},
{-0.041622559682123215,0.5681221045704798,-0.11069362499359514},
{-0.06045250068376889,0.559727103665759,-0.09071486425987658},
{-0.07875573871544614,0.5620185466243757,-0.09894630220465285},
{-0.05919335836725695,0.5524425041588311,-0.06296071599530803},
{-0.07710373794839312,0.5514832851029356,-0.05900982406999236},
{-0.04965005823692771,0.5446698306974027,-0.05752490587802434},
{-0.0610114626615214,0.5392139439022049,-0.049169884826976935},
{-0.03568935606602354,0.5495126476285684,-0.04246360518107424},
{-0.04515691011276577,0.5466296862521495,-0.0312578941544032},
{-0.00969195429797088,0.5614199394042484,-0.04125683572929378},
{-0.004670331003259288,0.5617793367249327,-0.028314814281341586},
{0.012161856615824038,0.5654638036985218,-0.060685359165044674},
{0.12230007022933471,0.5868484399996798,0.16109550524636126},
{0.1258764205744531,0.5860671721895675,0.1588444511107828},
{0.13107999805751944,0.576233838421446,0.16006760412318205},
{0.13820404610618994,0.5680606476286428,0.16931331087897364},
{0.13927697103854322,0.5701298095409219,0.16513389182974694},
{0.14470884017831045,0.5741228005248017,0.1733492312531588},
{0.1469643557978698,0.5827582506300715,0.18151373454521036},
{-0.06894047395744737,0.5691085634646808,-0.033443029864163726},
{-0.06667969130818831,0.5752486188283509,-0.024100236259743148},
{-0.07325189096745365,0.567050567655365,-0.033724165320016264},
{-0.07037528720570757,0.5859123834814521,-0.01613298013169197},
{-0.06711868893889866,0.585107940740661,-0.018819276815630174},
{-0.07277733778801765,0.5939577403651913,-0.0224318395390603},
{-0.08461566245715944,0.5994532476167417,-0.03120567000580444},
{-0.08065434800954391,0.5995979112348226,-0.031000367384616312},
{-0.08400417889854273,0.6044200194445104,-0.03793301777050587},
{0.2263874829448157,0.6118371869907264,0.09381460418572338},
{0.22374278959899943,0.6116637715869908,0.0963824360769574},
{0.21813741830441913,0.601767865506037,0.09193334510710693},
{0.026211825645379515,0.6102496670602087,-0.09400519630278555},
{0.02643477591431442,0.6294195359621665,-0.08015145821032366},
{0.020984465974092734,0.6151793713919026,-0.09844783051387479},
{0.024996467836935824,0.6005358638837422,-0.10215191562396879},
{0.019254748634694566,0.6058339380761264,-0.10732615884986065},
{0.018378166176534417,0.6003815461100471,-0.1058501264468213},
{0.021625853868392598,0.6010252514974148,-0.09972636789269257},
{0.01896873033248512,0.6338778225462218,-0.07088811619979643},
{0.020839480137724263,0.6293081599717872,-0.053784397708430624},
{0.023724982081410027,0.626209151233593,-0.06778602160184861},
{0.017402873385296776,0.6289829053965681,-0.08989195593260904},
{0.02671710109922846,0.6122758995821825,-0.07753471110444339},
{0.026832368495079664,0.6116210404848627,-0.05379416340114439},
{0.02011819450113303,0.6135498763329311,-0.04370072511693595},
{0.0261290403315116,0.5892894666017676,-0.04889151301259034},
{-0.010954826910811307,0.6008248069365614,-0.01783155383430127},
{-0.004899998284187619,0.5780253101349466,-0.018408200638833683},
{-0.08740441216351479,0.5864860311773086,-0.09195671832596247},
{-0.08411171305549371,0.5727750729652468,-0.05373846920944939},
{-0.0676414385383395,0.5657320504228739,-0.03609435347089605},
{-0.04706570646195327,0.5719444313990789,-0.01943123130866707},
{-0.05199905433889817,0.5973891916250186,-0.015240286759156403},
{-0.0621415689468966,0.5962025732092188,-0.01931593912679377},
{-0.06739613127745588,0.6080986245238688,-0.026156125257178982},
{-0.07731584433265215,0.6062758728504576,-0.03435157389784258},
{-0.05991722175014831,0.6104429360676593,-0.0403202463115905},
{-0.048979732661807246,0.6072245950259866,-0.03141705759542212},
{-0.04465390257994046,0.6019414544119275,-0.029212055888935478},
{-0.018598811345412438,0.605514359499972,-0.03097682066360595},
{-0.0832257366949516,0.6023608834781773,-0.04402730574433847},
{-0.08151185762368557,0.5906877824324618,-0.03915042042577417},
{-0.0667042294700833,0.6064850173050738,-0.04885993562041437},
{-0.08523604419771584,0.6078454229149411,-0.08415275251161254},
{-0.06931722149361298,0.5828164977820444,-0.028023566128465672},
{0.14492942338213316,0.5811695161844699,0.18413239017479358},
{0.13207868885363475,0.6004180435276133,0.1793625432927379},
{0.1506538791199706,0.5876103375335084,0.18861241410024498},
{0.1594431760645152,0.5785794760174198,0.19193148553579767},
{0.15298196821228607,0.5716806337656967,0.18715115416638686},
{0.1609932443156155,0.574107482763134,0.18834613786465113},
{0.1603736061557226,0.5797549283302565,0.1885028474894805},
{0.15233466885171154,0.589238134749965,0.18602013079819338},
{0.17066851762070223,0.6093553997752688,0.20266066050126347},
{-0.0851765701376481,0.5801458038990283,-0.044816096112163084},
{-0.08204732245247204,0.5817184770022986,-0.04593518501070765},
{-0.07502669408108117,0.5730842538051236,-0.04119485828099232},
{0.23043096305574626,0.6026267631374174,0.09994785578632256},
{0.233794426256909,0.6021566590489512,0.09750767190898676},
{0.23523288305042026,0.6019995156687349,0.10495173228919902},
{0.23688100480501206,0.6074626771614235,0.10458875338831894},
{0.22894272353681464,0.6167718113478103,0.10017795682263794},
{-0.022477823806591284,0.6220118366763985,-0.09474380736883604},
{-0.04943634076123115,0.6175429664608995,-0.0942592530294762},
{-4.895239367936512e-05,0.6239327409973898,-0.07811363822301051},
{0.0014342679557736474,0.6258035279816623,-0.07000320563820533},
{0.0014431537447023104,0.6264337993450427,-0.06182674309048271},
{0.0009674232292158189,0.6228283749959822,-0.05382468738738044},
{0.001726953697932325,0.6138375057265778,-0.04789947726341322},
{-0.06767392062032275,0.6112596602824087,-0.07488401954127505},
{0.15462130332203772,0.57394041258106,0.18410766611773272},
{-0.08213774186115178,0.5728602625232599,-0.05398263631331567},
{-0.08554893054789912,0.5706183544298422,-0.05336405155936269},
{-0.08416494103798815,0.5730032159058148,-0.0613594150364936},
{0.23323232884735876,0.607044945937689,0.10600104853548659},
{0.22673816797872612,0.6163966253310382,0.10259505252037254},
{0.016768524721277912,0.6054409804814971,-0.10430137185489313},
{0.017997737916084604,0.6148189454513003,-0.09711087248092917},
{0.15447786661205154,0.6233972018105369,0.20174280931628},
{0.19435770868617655,0.6260073806205565,0.19875366462111552},
{0.19286559015478386,0.624834939809407,0.19465157796089128},
{0.21723398019129622,0.6391501812406605,0.18065492366490757},
{0.214609140449195,0.6359354341721948,0.1773980279658333},
{0.17949908329207032,0.6407927261402764,0.19292483494414697},
{0.20378242009369105,0.6539636960745154,0.17427368791303618},
{0.22583969946303753,0.6452301924657542,0.10554336224410067},
{0.2348715524200109,0.6288214120694705,0.11394945489371844},
{0.23869742364977264,0.6373495510919879,0.1296675975697578},
{0.22677788757916725,0.6533625482871211,0.12255570706493524},
{0.22265714943730064,0.6449588350956266,0.10746551825920875},
{0.23383443089660447,0.643420862423319,0.15352784936686678},
{0.22107303758482377,0.6579702078334596,0.1462133455242557},
{-0.08804288770021595,0.5774884448959107,-0.06103080195527758},
{-0.08761868732470897,0.5865624216974705,-0.05168582718091076},
{-0.09462005695691558,0.6082198405650279,-0.07519484865162274},
{-0.09878032880405747,0.6223471171975636,-0.05959828141406314},
{-0.0834353396909769,0.6247396375543703,-0.09654205805938544},
{-0.08251212233220528,0.6395955117000215,-0.0806743565258972},
{-0.09484125981129123,0.6229176294616225,-0.05884746323212046},
{-0.05903969742314784,0.6377349365568612,-0.11265418694997222},
{-0.057150234171210956,0.6526102925158958,-0.09794947036019623},
{0.015002359536357935,0.6436625385319624,-0.09731413025529276},
{0.00980138458561376,0.6272166906396038,-0.10845001905766258},
{-0.0039006878375193845,0.6357470975831452,-0.11704876106417818},
{-0.015736174507128865,0.6381452939390162,-0.116556882455283},
{-0.02806337867648973,0.6418791098826386,-0.11993633264071066},
{-0.05678043911424894,0.6345300295391754,-0.10912592148775918},
{-0.0008347684388500882,0.6518130377215183,-0.10357393928481706},
{-0.025074147230247847,0.6564853763925691,-0.10559235181681324},
{-0.08449165798851228,0.5786541686950667,-0.060845055505539085},
{-0.08462464739017654,0.5881765122436968,-0.05247619146113979},
{0.12748502101678075,0.594915732512992,0.16536193562622667},
{0.13312386583422894,0.6005719771179656,0.175535358403804},
{0.13863254685653412,0.6054164051405689,0.18089657498752906},
{0.15499713377538504,0.6239760421780266,0.19776848220705348},
{0.027193364514190514,0.6209969234288081,-0.0665447624002935},
{0.024083945646707374,0.6279048249716149,-0.07725232395447398},
{0.020207399394729115,0.6318445879730001,-0.08266559118464302},
{0.012177967530199549,0.6434097087133667,-0.09489253589454402},
{0.2345092799207611,0.6397089821092695,0.14075385236284005},
{-0.08001240242974647,0.623569662952421,-0.09383541205128988},
{-0.030923747593749676,0.7046293243886197,-0.008236562454848773},
{0.06355245129080365,0.7797857856884901,0.15203944873879147},
{0.05418280203142024,0.7789370875052105,0.15325986289574686},
{0.06742347025985004,0.7679301975549443,0.14819369911929253},
{0.07834308862624531,0.7836701271444236,0.14078119134523415},
{0.07883290999530483,0.7749903348455882,0.1409553007575891},
{0.0878769700681704,0.790907645602342,0.1150513051138812},
{0.09028366802962728,0.7838062891569187,0.11024032582812378},
{0.04146292530668409,0.7682915777573978,0.1463505981217239},
{0.054253479373484514,0.7673322595574141,0.1497926206199838},
{0.04507795423931478,0.7800444774013163,0.15072559127845814},
{0.054915712312384006,0.7743099461454885,0.14181486761156642},
{0.04152968645725404,0.7795590431581711,0.13771104592979405},
{0.05741990609183477,0.7850121910979252,0.10871846407019163},
{0.036380142502400924,0.7899152380628333,0.10983378549337454},
{0.03875937755135305,0.7833963159581067,0.13796772997482898},
{0.03249518139591425,0.7841742748342664,0.13791374601866},
{0.023766684563620494,0.7917415837094514,0.11048075024265051},
{0.030535796775587667,0.7759840684372803,0.1380207100971023},
{0.024685019076035212,0.7847222937832546,0.10557683576696854},
{0.077904512357911,0.7891652502126314,0.11268265369637263},
{0.0718010907349286,0.782971582683124,0.14020116124868287},
{0.06894503458551682,0.7791940813755218,0.13960189719896945},
{0.07572132235088655,0.787329448698576,0.12008937393426689},
{0.06975174524733137,0.7942328143993354,0.12210207328816532},
{0.07587775932947266,0.7860726734471764,0.13089695948069716},
{0.06692575454274656,0.7787799441249942,0.1441080455917313},
{0.06238657877551488,0.7828220114326641,0.14532998408904685},
{0.05670614301295582,0.7947241105367107,0.12126042672817797},
{0.05477166834485595,0.7806066739549551,0.14540908867863056},
{0.04759174020932457,0.7832977915201946,0.1444754859765923},
{0.043689751105644034,0.7949483868578289,0.1206163867295117},
{0.035549228289989854,0.7869563571006726,0.1283846854580365},
{0.03633215676358403,0.7874050956380745,0.11746811577236148},
{0.04151374904503335,0.7810934218572723,0.13384953240022926},
{0.042882234898110626,0.779441421090219,0.1428008555713472},
{0.05049781455136677,0.7750553857606323,0.14522359008911323},
{0.05452149063062651,0.7759396270996262,0.1482122142778133},
{0.06221072194860075,0.7759555149398026,0.1436905002631625},
{0.0337276043805849,0.7949118894402627,0.11649727207209366},
{0.056785371532650064,0.7978860881640912,0.1202105156173596},
{0.03823495489541937,0.788406574861678,0.13215748981444755},
{0.027903397296741066,0.7872530581784138,0.13397216124464892},
{0.04028638240887431,0.7814508239031762,0.15062622411579446},
{0.04055849575267657,0.7834004676168108,0.1450062290681656},
{0.05527571689061016,0.7991538312302774,0.1413277355259065},
{0.05148261278208591,0.7777763828755329,0.15639068449332733},
{0.06493232632104343,0.7792818238938131,0.15475438567128488},
{0.07030850126911566,0.7823233414537092,0.14834633144348383},
{0.06559186997654334,0.7874784622635383,0.14578224224158934},
{0.07318900882934494,0.7879179308286688,0.13464622950910893},
{0.08004714003974227,0.7942659161318715,0.11979052886561237},
{0.08312161061604163,0.7864790526727815,0.1379036581076587},
{0.08862552032908952,0.7937939159127135,0.12110403932163608},
{0.08383745572077846,0.8005165047611686,0.14286434496699774},
{0.08835283690677855,0.8072067478507622,0.1278644392468294},
{0.06564225995950551,0.7926417128886217,0.15924340692276448},
{0.05376767334000779,0.7913077911433851,0.16123014291849622},
{0.04232282677196,0.7929703755418821,0.1575789140005649},
{0.02503943440627419,0.7946825071985888,0.11658308128065979},
{0.02688522468724242,0.8013137595555457,0.1388111859144308},
{0.024725903619515884,0.8080953515296484,0.12334099021063044},
{0.06691974393238333,0.8005911974388156,0.17146797217454235},
{0.06853501181466026,0.7976595439219495,0.16544889738482124},
{0.06333114929233953,0.8109432282917617,0.17369112964222908},
{0.056971688060897224,0.8011887636460139,0.18495669891231065},
{0.057446377563454824,0.8246262898359318,0.17487818181341613},
{0.07205613890250381,0.8114751735054077,0.16652572611565775},
{0.07768510649013874,0.7839227710678537,0.15869620591250605},
{0.06419303363938475,0.7814237823530474,0.16400288085456455},
{0.05894147041750153,0.784891359240109,0.16794341222263567},
{0.057814276489725036,0.7914530124469638,0.169315739909141},
{0.062197250745580634,0.7960784559641708,0.1727552466261561},
{0.05816737816079183,0.7967185673783316,0.17947968203325887},
{0.05254045541998143,0.7944090678026032,0.18287774652129574},
{0.0521036761382505,0.8017511460948185,0.18686450382061348},
{0.05085493155801637,0.8240786550702864,0.1757778524511774},
{0.056597406733932196,0.8334070727818795,0.17551460011028167},
{0.07326729548019886,0.8293776835245221,0.16435134753949562},
{0.10002991610904363,0.8220662283626313,0.1594285585079722},
{0.09089399903821564,0.8093137332327902,0.16191315893694017},
{0.10314703103639387,0.8082216610983526,0.1571878277506051},
{0.0950267831868307,0.7866053746344966,0.15200707819390777},
{0.08211246011859329,0.7749973245038249,0.15028728765636704},
{0.07565910943537497,0.7804204069987523,0.15385257104261058},
{0.072723205115716,0.7789713170017531,0.15562837799013382},
{0.0585516854337028,0.7786384902967772,0.1582831964259845},
{0.053469844498260054,0.7774717378777033,0.1622213731219546},
{0.04987609436561608,0.7835859785993393,0.1682335945765606},
{0.05421575504782369,0.7888823549492086,0.16913373614874205},
{0.058684340224068536,0.7963927427246037,0.17523594325664077},
{0.05245284922481194,0.7905581874765262,0.17407951421577825},
{0.047038987130112064,0.7967529827700399,0.17533326557247988},
{0.046983491226594,0.7970307845059178,0.18060624391747146},
{0.04754105279409697,0.8013201915282848,0.18428638573020126},
{0.043104813376713756,0.8112406853431781,0.17223616535798844},
{0.03705334325608687,0.8133005772831856,0.16498422143519856},
{0.03731468707327963,0.8299203982647775,0.16317994774127492},
{0.04761669973359549,0.8336173573935133,0.1732381898740784},
{0.05094272364835179,0.8409615177115862,0.17872493526681077},
{0.059775594419776645,0.8430953587485773,0.18041515607996692},
{0.0712405424517606,0.8347858200481131,0.1676421505168248},
{0.07422443251023647,0.8322516599679237,0.16226543027626605},
{0.08257883391073095,0.8296827003126834,0.16354746248420224},
{0.09501378291823083,0.8283313787799216,0.16312448901679},
{0.10642213206871252,0.8323036610423236,0.15919208746397298},
{0.04395620084339277,0.8639009563940689,0.187929596369978},
{0.047130472337742806,0.8503237931293902,0.18506042841486678},
{0.06507136351210399,0.8556880583938353,0.18737809498488242},
{0.05301371972626743,0.8970685701769833,0.19188745316750833},
{0.06711083176988787,0.9005100349897456,0.19121179859763288},
{0.08396708661644599,0.8621992224736398,0.1843756278028305},
{0.0868730618143997,0.8488219336913059,0.17889944125551957},
{0.01985198023059441,0.8501558678295531,0.17463919498817215},
{0.019876902575832245,0.8692092548205759,0.17942287247056862},
{0.03828846791716822,0.9028919717151085,0.18862733528555894},
{0.06222088421766834,0.9263011426957256,0.1876004751753086},
{0.09559220192334454,0.928728648522749,0.17476497165740057},
{0.0873481355003001,0.8916795312834329,0.1856493443003467},
{0.11232685654540073,0.8546725750677366,0.16946593081015388},
{0.10552059008628147,0.8482553871907857,0.1708738264383959},
{0.10177881782955979,0.8466028287382349,0.16903900397221408},
{0.08410138967728233,0.8460532854488865,0.17332458155416428},
{0.07520739657531907,0.7812812007608243,0.14887397628229262},
{0.07083151112178866,0.7795628230265442,0.1517185069314204},
{0.07413215414989799,0.7805847383253823,0.1536496726655677},
{0.07312972066444316,0.7824330196015732,0.14953588700290463},
{0.05498479095602178,0.7972200753568189,0.14452865199403145},
{0.04848202933771487,0.779439723247704,0.1572752728366309},
{0.036016209339669335,0.7829498453417281,0.14667419203346144},
{0.035544779199019966,0.7795751168935138,0.1527422687889062},
{0.03464305132142306,0.781469165559542,0.14944723979480617},
{0.0340925289842011,0.7819400380146937,0.1455458703416786},
{0.054067596600624344,0.7734865916698233,0.14767585715223067},
{0.05163876472141778,0.7792903254993989,0.15744299984829094},
{0.07919938372530334,0.8335352784812754,0.15219495624154822},
{0.07614070184509193,0.8345085883907439,0.15067118595991316},
{0.08911194601311909,0.8314479732008075,0.15384874160219364},
{0.09376987161230929,0.832003936069884,0.1535526725680161},
{0.09799834219930381,0.8317908134587181,0.1539752742450966},
{0.10212147219230468,0.834226077310664,0.15213863000628924},
{0.10799092615952162,0.838660147951112,0.15685773990107316},
{0.11308341269146333,0.8370802001503507,0.1543599904873726},
{0.12381567351668253,0.8402433055417374,0.14664639450965816},
{0.11595492292566453,0.8097337323775486,0.1424620058629972},
{0.10868214635128595,0.79838702606407,0.14749659224727557},
{0.09661410482917158,0.7746062630398872,0.1399842463761333},
{0.078637050848543,0.7601541160154751,0.1387955211484534},
{0.06895141698621172,0.7644040017255778,0.14906595641659331},
{0.06885563140374377,0.7736832563623036,0.15616352060063274},
{0.08402150432800198,0.7327433533013038,0.06417178582192566},
{0.09092812939066955,0.7324150748313863,0.056085346106528926},
{0.09751064003513524,0.7563669729452699,0.05059479605940171},
{0.09680363114728278,0.7634409036572214,0.037414035646426674},
{0.09495336698932262,0.730712213146951,0.043477935957144866},
{0.08505910917883969,0.7289475103373355,0.017024124377845284},
{0.08408348177630344,0.7851623324268938,0.02259784392218327},
{0.07142402098047541,0.7709685053249761,0.01614019286412778},
{0.06395433185339508,0.8269314518577902,0.016506096515617578},
{0.08212163094677627,0.8417820341877195,0.01989280900552525},
{0.09656820111621248,0.8014156796784875,0.03458099331854976},
{0.09763015823377928,0.8376463624675279,0.03644935127265473},
{0.10441991720216921,0.8018143132721816,0.04520807465891909},
{0.11093336159600817,0.8202794040282774,0.06160710175550039},
{0.09933468058169649,0.7899243097469277,0.0815236123946742},
{0.11407723303423278,0.8172963071225093,0.08502804609662257},
{0.12043669426567509,0.8196483642982111,0.10491749039964555},
{0.10181650497618745,0.7920157790791112,0.09641890870850132},
{0.11797609909912665,0.8032227417998993,0.11043093033819702},
{0.1241584270235158,0.817999771609199,0.11792005170661646},
{0.13168781328486293,0.8452993442281572,0.11234139974387737},
{0.13336184882557728,0.8499128656687261,0.12923071914393838},
{0.13447286987392296,0.8755167645496629,0.1404874398041245},
{0.12325772776583677,0.8739339787493693,0.16139925794739476},
{0.12932299130777133,0.9218277366381792,0.14325147784643005},
{0.13335617282651266,0.9282311187008114,0.11255924409225627},
{0.08836247866938178,0.7754899466933839,0.09719293900015578},
{0.09484614265764815,0.7735813362393622,0.10572095409256294},
{0.10523310940876715,0.7807345078640191,0.12934835360490168},
{0.08368192343199958,0.7626103736281532,0.12079466019358218},
{0.06426744127777742,0.7484333638422411,0.13473834676030363},
{0.06379572609787383,0.7526473222132869,0.14719826768508548},
{0.05461650784640877,0.7531346401941127,0.14974993908989978},
{0.05565963998017842,0.7672641847476721,0.15333673674334014},
{0.05494809525027873,0.7716131525811842,0.15973051422240228},
{0.05211743238052502,0.7772593712402122,0.16014115664381173},
{0.037065637123056445,0.7774774014837567,0.15347609615268823},
{0.033193862180335564,0.7811340833265537,0.1502151851180311},
{0.030480908129611413,0.7837743275814,0.15398684931742485},
{0.04524403298050412,0.7806666189494428,0.162635634302593},
{0.07725523011556718,0.7826340342409353,0.12218091762451681},
{0.07861691220557357,0.7807762970973071,0.13548241075121967},
{0.0783561756459227,0.7947208883538356,0.12427073868622968},
{0.0704259870139462,0.7880860544166827,0.11367807273756862},
{0.07466514037647284,0.7986513813829499,0.12029679576034596},
{0.06253569148456567,0.8045984651714345,0.11983831631625232},
{0.07119737759424528,0.799322698398955,0.13456868643891853},
{0.07798804125244246,0.7865959187670593,0.13987647675197223},
{0.055096786596953634,0.7709862769028336,0.13539011999787012},
{0.05734298267219731,0.7782436489644668,0.1126350645339096},
{0.05769628263144107,0.7946948010655583,0.10680003835141202},
{0.050702894098355863,0.8043178378290352,0.11772260625443914},
{0.04233512063892966,0.801253814561058,0.13215711802411584},
{0.06032106040848691,0.8025867944374537,0.1348222846242},
{0.1145204938607471,0.9147694954782271,0.03286681681501835},
{0.10493777156224214,0.9034473645056763,0.019385810923139225},
{0.1092245884452981,0.9452013520700706,0.03383329817539371},
{0.11567075118210275,0.9546366099299954,0.05772250004633437},
{0.09994850641940313,0.9704623983000853,0.05542799601398628},
{0.06637961933143909,0.9505296899954586,0.02583156469057896},
{0.08218664468278696,0.921751333725006,0.01276831480845663},
{0.08434595335750246,0.9003742571605933,0.009410440855281109},
{0.08392855674506638,0.8691222682759594,0.010829800018751872},
{0.10112012929182294,0.8704544921786808,0.02083840814226776},
{0.11639336287087719,0.8899189801325222,0.03592542433716337},
{0.13641183081202587,0.8688505267224889,0.1008570318635654},
{0.10644057286916689,0.9706312654687625,0.1024153786460525},
{0.08534507790900485,0.9797497827520651,0.10432393952802989},
{0.06386054154570754,0.9790544480806296,0.05631837189345398},
{0.027598801870955526,0.9466744597225002,0.025012956738148587},
{0.049426599854539524,0.9136851813687115,0.007404545264453566},
{0.04738283122191851,0.86963283554553,0.008232237293989503},
{0.06579756917408536,0.870411190998044,0.00772906865202043},
{0.04712876210221679,0.8422702940373857,0.01740429238506293},
{0.10070004339598719,0.9600560984517155,0.14025375718761335},
{0.11479677125626483,0.941315114483445,0.15140694663342025},
{0.08880125322589304,0.9517488276722748,0.16573672506664514},
{0.08260621007215826,0.9693321309055662,0.14851741696114062},
{0.060514428560026104,0.9861520246576801,0.10477628443164978},
{0.04865009096067343,0.7915821724082112,0.16866670552701835},
{0.04395444103582248,0.7963324259397841,0.17145732657804347},
{0.0386828383150584,0.7982412222889717,0.16332096781410477},
{0.039588829388459264,0.8009699650357837,0.16952601212776344},
{0.02215170172059797,0.7715849832670493,0.07532537184408643},
{0.019468763542656524,0.786039584107651,0.08676160526944882},
{0.01968401775172424,0.7920887739142431,0.07357830428920688},
{0.03023819100803894,0.7643748781495916,0.03512569094057446},
{0.024087737908091083,0.8013799382345961,0.03479847826960799},
{0.012211911987487606,0.8220289749713907,0.054278705347493184},
{0.005611728909253157,0.8188115881915695,0.07731668086089862},
{-0.0034299640985003084,0.821377139768769,0.0961156021558659},
{-0.004721774392161378,0.8082492727269897,0.10474892066323355},
{0.01171410951930666,0.7843459800024762,0.10066848459332778},
{0.030097505546507593,0.7660312288635258,0.10515729516361938},
{0.035722061222205795,0.7695799304009737,0.09522043018111871},
{0.03248979043610395,0.7425774306500889,0.08132801350114453},
{0.02554136374713745,0.7465578551207558,0.06152711726213154},
{0.04106227165218748,0.7291464429508399,0.015469879682018387},
{0.03839418030149364,0.767839245246789,0.023402497344162245},
{0.04774297212326631,0.7886756643107822,0.017890866785225237},
{0.02899063615686628,0.8388814003775319,0.03199861203233355},
{0.056401212975871765,0.7286574271274991,0.008830782549061568},
{0.07166195439977949,0.7286873066771601,0.011769177863943223},
{0.025421139146863024,0.7270935406690691,0.053055242509817475},
{0.028689213341911702,0.7265593275343996,0.06361905752873533},
{0.04010040049192575,0.7354543244702587,0.08696926256273799},
{0.04872667976901237,0.7320565326284652,0.09119541565666467},
{0.0373060367515611,0.7248124086956526,0.07471831259041747},
{0.05403979907682107,0.7627883124809249,0.1016866819888485},
{0.04939714166725452,0.7501581735492606,0.12348062226622182},
{0.06241778437735915,0.7512715988417517,0.12215480555021743},
{0.047720615131317534,0.7474642179844886,0.13476310799639768},
{0.0726648216406214,0.7665573121829412,0.10146039799993904},
{0.07085458690837884,0.7496950591190311,0.09780257600012482},
{0.0625173498281997,0.7319699302671911,0.08933751740389272},
{0.05360533728815796,0.7285955860023194,0.07838409090333097},
{0.06960968416157261,0.731764379785782,0.07576544766675883},
{0.08333369221427855,0.7401209995352557,0.08113038215380135},
{0.026509233124751376,0.7285447126919259,0.0365056155428584},
{0.043932790445504084,0.7529686110249676,0.14489117235350238},
{0.03188612686746491,0.7594481977125959,0.13143894303330012},
{0.03130213100737505,0.7651051982912442,0.14087138767971485},
{0.04534084718288985,0.7603723445471968,0.14944825602171297},
{0.045003633351999466,0.7683051852835397,0.15178112881629685},
{0.046521083197994945,0.7724387749778735,0.15788607477963942},
{0.030395520283421264,0.7791853814817592,0.14912507107934037},
{0.015650935377071393,0.783887215519128,0.14357607559206323},
{0.0062077707760914355,0.8080686817698515,0.150208753145292},
{0.03693865833175534,0.7841128178924293,0.15920771505091721},
{0.001966262741463802,0.7991005041036946,0.13999336763227205},
{-0.0049898228283365405,0.8131184743786979,0.13420847117950438},
{-0.012100164206776816,0.8421375524959428,0.1369842825823151},
{0.0031149089713819176,0.8337465049617493,0.15184785278783355},
{0.009137676878398287,0.8234334377355697,0.15300167929637393},
{0.020802648108859654,0.8118949743619894,0.15793324257972646},
{0.033132070627199944,0.7812543451058612,0.12646934559901032},
{0.0373256053160218,0.7853937966944255,0.11529793842694805},
{0.039105489564183124,0.7991473992575383,0.11776995994969207},
{0.034756224298405455,0.7953258284026136,0.12120574876338971},
{0.03270829161406896,0.7872689336255793,0.13657739524325624},
{-0.018479441862901066,0.8498480130418595,0.11699073698640426},
{-0.020796699463551737,0.8776834966380022,0.1294514014918496},
{-0.012700754308673463,0.8758376691780008,0.15173254821294918},
{-0.0035594586710461945,0.856292428364105,0.16122877968727983},
{0.0027962226920234317,0.8496887876357851,0.16356990622722842},
{-0.002247038799995619,0.8430285975980076,0.1491513690488056},
{-0.0026597508542517637,0.838696831263844,0.14613331145884262},
{0.0020694593445444447,0.840139489288104,0.14932746134292985},
{0.013722273031157797,0.8294754395957483,0.15734094340222768},
{0.03145529623104181,0.8291893345424615,0.16033716450670632},
{-0.0006692102041251917,0.7957594474665246,0.12320304360454296},
{-0.014899162933277206,0.847345802144178,0.10192046374944812},
{0.01178799665123489,0.777304568551541,0.13105257852055346},
{0.01156963179639161,0.7774138749090731,0.12059852840057701},
{0.020975059678699712,0.8324004752447093,0.1490067178237357},
{0.016425064812814354,0.8330846562061927,0.14805389356154633},
{0.012174237233871062,0.832989341558145,0.14787419490120418},
{0.00842164587849571,0.8355348536364634,0.14547738656257167},
{0.006681667125941384,0.8367988168342769,0.14627177857139453},
{0.004152464250175337,0.8416982698259781,0.14690518536657296},
{0.004964565871800277,0.8448133522995148,0.16040194277550693},
{0.011688815383737141,0.8479047889079527,0.1494355655783895},
{0.01960662339766654,0.8449555497083951,0.16631955598369552},
{0.018930906862735814,0.8488573033448654,0.1531610534185808},
{0.023026821803453168,0.848416124544209,0.15270499061164347},
{0.026251495673776482,0.8459424795370163,0.15434582527573318},
{0.031354268404896406,0.837947227596985,0.16305860777000525},
{0.03268721110225912,0.839346782728785,0.1521886729849418},
{0.03426035513994962,0.8325897660956104,0.1590611181231112},
{0.034329235495410435,0.8350951867831561,0.14770309699053633},
{0.031064953561745556,0.8342064096021148,0.14877250230774908},
{0.03678326236609812,0.8354181734373517,0.16530724526842738},
{0.029961058494758153,0.8423024415080705,0.16766263616410382},
{0.020551330237612925,0.847543606993676,0.1685806236722089},
{0.00671631798485973,0.8479297484322237,0.16228284245680266},
{-0.0002157499295101106,0.9066460254457889,0.16312787230880885},
{0.022510144779430783,0.9022963016386019,0.1811621943935369},
{0.014312279501610884,0.9298643936281556,0.16898989046939095},
{0.03739651812529611,0.9274463436685693,0.183318218920322},
{0.026335309607562262,0.9045405644041206,0.01379770309296281},
{0.017399130695957263,0.9438014251479387,0.030870550593782936},
{0.02551796574225978,0.9713564796898592,0.050250034884777},
{0.01379153756996141,0.9563071382485803,0.05054570734260066},
{0.014944967502147929,0.9198852808709578,0.026772256194942463},
{0.01324852539744061,0.8950179358162363,0.0269848335136217},
{0.018585563216591428,0.8731221621669988,0.02202807523878807},
{0.013746005647334067,0.8500399436041158,0.052787863296239426},
{-0.017295376407379007,0.8709974052071129,0.08993017597871218},
{-0.014005651622011844,0.9274079501203114,0.1028943933094694},
{0.0319993494164915,0.9700386192869542,0.1449197258509802},
{0.02068606705383635,0.9759119522666324,0.09458505289718205},
{0.015004813352547405,0.9612519744467759,0.13416259225256738},
{0.022947828750968957,0.9526688104551605,0.16105619461528503},
{-0.0012884765736863215,0.9428908982324907,0.14281948226696753},
{0.0028745589149215484,0.9570147667869854,0.09643454868845662},
{0.05719808358690621,0.9733946218954601,0.14891151471278755},
{0.055125947351973285,0.9503560886965567,0.17353890628740268},
{-0.014679050663874657,0.923760922433129,0.1333297323374202},
{0.11014924339335243,0.9051039011147767,0.17097246241340716},
{0.11237215300081804,0.8414246321418154,0.15729217690371414},
{0.1036895103094392,0.8434353610069557,0.16742082373233858},
{0.08507631067818829,0.8435645209682031,0.17123756131295054},
{0.10631420133540767,0.8402731850913984,0.15416757659768485},
{0.09867532282136243,0.8466890593091769,0.15561846358128736},
{0.09100495366621861,0.8478509040958719,0.15828433658300184},
{0.0870044896966706,0.8475226132329434,0.15725323806296965},
{0.08351337848160965,0.845143142716781,0.15841692940831226},
{0.07720034146959091,0.838748076364569,0.15536024280288122},
{0.10971516578803212,0.8478401221762515,0.05870957859108828},
{0.10376604954573385,0.8354431329616228,0.1531734464296389},
{-0.01148250892865322,0.819120013057772,0.08275359395616645},
{-0.007196559556371332,0.8184182588066083,0.08193689452743903},
{-0.0054192282684879505,0.8147946786963475,0.09110974277122016},
{-0.009410992344273133,0.8170083059385305,0.09577687637762647},
{-0.007532162295824094,0.8227396150114832,0.10109455631350454},
{-0.003604172654943742,0.8184666659078013,0.0912798368479923},
{-0.006899945229707299,0.8217400195255606,0.08243179703103236},
{-0.020020909364327048,0.8425637853252632,0.07195862449499331},
{-0.009888098483987121,0.8324704461851433,0.11112236121114939},
{-0.00351908224101903,0.8166635695499279,0.09997003927611656},
{-0.0012484843270019563,0.8241684796144355,0.0775663132826415},
{-0.011822845798330192,0.8555791362196462,0.07961646431595744},
{-0.015241532256767765,0.8426148445308226,0.06973254227669688},
{-0.020750225672083983,0.8609974845843489,0.07315301332872677},
{-0.027356939867146015,0.8593133363466112,0.07463769605348466},
{-0.016253235714494052,0.8497833339171473,0.11010044591231123},
{-0.014425464871604303,0.8492667064651692,0.11206436637468506},
{-0.015255672682384997,0.8550642066101829,0.10327795700171694},
{-0.018955271522476034,0.862820620441103,0.10985175535940876},
{-0.023314364446022695,0.8720370920838085,0.08999760635187919},
{-0.014431797700254932,0.8602970439923572,0.08913432159458444},
{-0.024593025754951054,0.8618762358194442,0.10517379026133769},
{-0.027452390838315365,0.8683229314557243,0.08940272942808032},
{-0.00035383285871922425,0.8375102128480437,0.09539598957576746},
{0.12501344564243483,0.830586237569895,0.12071115608507284},
{0.11984982322701979,0.8149410401569434,0.10874004030244375},
{0.12383085495522865,0.8209045694711021,0.11043199613714803},
{0.12121253393694406,0.8167240846229246,0.10015210500157078},
{0.1229312462825227,0.813001980074752,0.10023445656005173},
{0.12581679779825275,0.819887772485831,0.09186585276888463},
{0.12098004104949449,0.8224616397734502,0.08625491701233924},
{0.13202678692332354,0.8535706752755294,0.08984240867439885},
{0.13644643209890003,0.840496891334008,0.08051446189722586},
{0.14192539468068796,0.8587257960853588,0.08471693194702055},
{0.13339280656720032,0.8582335580791427,0.0996424300287962},
{0.14238765399315426,0.8697234160633537,0.10177591166846668},
{0.13206332151992278,0.8530077227482162,0.1137507701404353},
{0.13500930135757197,0.860671474035455,0.12079614735490916},
{0.13193771835284918,0.8477139861097024,0.12063565786170703},
{0.12983806963336722,0.847252383626822,0.12231988045751105},
{0.1408612687861859,0.8403176264290528,0.08339495706444416},
{0.12628308483931297,0.8151135012988279,0.10542255517230652},
{0.1302336669393522,0.8171412457681505,0.09282722820870408},
{0.12608806841730297,0.8165557875327559,0.0914116613066171},
{0.14820614789890038,0.8568619987593231,0.08711869749007631},
{0.14646370293714547,0.8658939136813517,0.10176599725962023},
{0.14122396264781165,0.8595597341924679,0.11696156383837354},
{0.11794366658918765,0.8358595381331739,0.10380588687978007},
{0.03282606239815383,0.8381497541836959,0.1518632077285345},
{0.0315222432767776,0.8335309285343941,0.1506155289472513},
{0.02971078163644023,0.832663715192594,0.15449625164395614},
{0.07906943061134833,0.8321930410256191,0.15876568113249764},
{0.07845579066880753,0.8328753134633997,0.15395172752408626},
{0.07667780255133806,0.837476937613353,0.15523442895461959},
{0.030732746507322675,0.838356258926957,0.1572253166090558},
{0.07227011663143261,0.8328669977529796,0.15821101952958225},
{0.0766137926492231,0.8376768120956974,0.1625991244920159},
{0.031750770400688556,0.8382866721698657,0.15947197122570864},
{0.03311969000915292,0.8326620049570681,0.1581467617672461},
{0.03861845662261167,0.8330103353188776,0.15599657434866934},
{-0.04476667898056898,0.05930973493759773,-0.09496574141086411},
{0.010962237931424083,0.053613882269282334,-0.06279349709710136},
{0.01607929980429391,-0.045765648619433275,-0.11504985513158739},
{-0.06798993000929271,-0.011331716966604169,-0.1649875055831289},
{-0.1533815064957874,0.11917292315953285,-0.05479875327052335},
{-0.17674975575389068,0.1123914179365077,-0.021200048597953564},
{-0.20642109043613305,0.04135597981775825,-0.01526504799525045},
{-0.2004588128160911,0.05736652319670188,-0.050539275369861504},
{-0.18078492015440126,0.0633535000877827,-0.08223068324758184},
{-0.14009122904409213,0.06802820582394536,-0.11081888115635913},
{-0.09298292780313222,0.06756216664310631,-0.12134551714210273},
{-0.14025976160147094,-0.029740258413242036,0.14657651032030164},
{-0.17225355894900846,-0.015418882441514506,0.09422471370765734},
{-0.2001105815983701,0.006537790464062452,0.051608866582240114},
{-0.2088724280234211,0.02602951825620956,0.013870908609282882},
{0.05294480219177345,0.0485190782442728,-0.03354102140259997},
{0.0855706307102619,0.0411638509673249,0.0016390066949586288},
{-0.11119568446107451,-0.03271332937306412,0.19071668541285158},
{-0.12992773306837238,-0.14618995991238923,0.2186356607244926},
{-0.17922589175630593,-0.12352812467760757,0.1751969052718078},
{-0.2277407997523579,-0.0936225249073344,0.07232625077502018},
{-0.20742988153626069,-0.10814842274055324,0.08351590045935997},
{-0.24084269104295933,-0.07013034553865033,0.0025684825243145882},
{-0.2375461501015102,-0.033567220227976806,-0.08248228615808298},
{-0.2566487373464336,-0.031762797817920616,-0.039924686184638715},
{-0.2459560474055228,0.012099773826928327,-0.11052392749317687},
{-0.24155281057658723,0.007717605116791491,-0.1181481078961072},
{-0.1744087159650195,0.009054848188991512,-0.17986655465945892},
{-0.18779439481583987,-0.009751570877666007,-0.15915038498176254},
{0.05602815855700147,-0.04661216563276634,-0.10888185352798135},
{0.13451309758781754,-0.06681396338649725,-0.026693907579033286},
{-0.221980391889441,-0.012824393183494574,0.028374932777984335},
{0.12160827995906173,0.08448238181973527,0.27438564575528435},
{0.10436833749014549,0.011311590716645588,0.30296143825999255},
{0.14666694831849802,0.026323195439252843,0.29524431027412656},
{0.15786524832455628,0.09156870554274496,0.2498834235923558},
{0.1819957049417646,0.03284315855690835,0.2741377731411117},
{0.15065747309317745,-0.06412964958432832,0.34650177922432035},
{0.21929122002693735,-0.04588713730683568,0.2869025745309334},
{0.20122840640978676,0.033778843284804426,0.22558940401520297},
{0.2013312807945799,0.03323724391554412,0.17072058685666278},
{-0.07199164567295754,-0.037441263091721404,0.22952417263313207},
{-0.022807477900736218,-0.030886599543103355,0.27265307802334277},
{0.023111119064670227,-0.01609312420812934,0.29998091910052443},
{0.06348630979078672,-0.0026120191721617073,0.3082805309991312},
{0.17254848782616866,0.03343807265974028,0.12317850544264795},
{0.1071493291715785,0.04075983880683149,0.027749854086236935},
{0.13814423743482374,0.03768389346221625,0.06866538009448568},
{-0.11187482146705725,-0.032640235393843545,0.19006730402641928},
{-0.15151262803521803,-0.14387619714085684,0.19797649889766336},
{-0.11146834309736331,-0.12918927691496027,0.2634648996248828},
{-0.011778924967140383,-0.1126209736803367,0.3262454026498897},
{-0.02538153108352137,-0.1248950490112916,0.3059208645146397},
{0.0609295944304718,-0.10003225219162817,0.3382703412795441},
{0.16358588701498789,-0.07134239441314158,0.3302173750870152},
{0.25691265890992654,-0.038799586675731176,0.20351618723363585},
{0.19638894798461787,-0.06325713203379535,0.1022479366736468},
{0.2067135531040927,-0.048199673170273266,0.07426079980118636},
{0.13608207757379248,-0.05799261811535647,-0.007141454032701601},
{0.12190820321967828,-0.06557959469909039,0.3503299927331721},
{0.2035186224603088,-0.025567531589986647,0.33751563169212917},
{0.21531554207950554,-0.027784653661288218,0.33151742673302986},
{0.264717814453338,-0.034142280727093806,0.25334600609596103},
{0.24252935506194184,-0.051685864359944066,0.26608602146366656},
{0.2394459863037027,-0.044952691880045456,0.16994105406809853},
{0.16857903117028797,-0.06279364581323414,0.012289548005260914},
{0.008991736780178377,-0.10962682220870468,0.34259178423549635},
{0.0871234873888503,-0.08489659342832961,0.3688488567642489},
{0.12032063371711622,0.08416137804730887,0.27166785843024754},
{0.15534077957901454,0.09103212534296336,0.24803563803660722},
{0.0840524620696251,0.07245376246579655,0.28098616344481736},
{0.043495118866976934,0.061906021182221126,0.2858752187002407},
{0.009335010793476093,0.05612714773282768,0.28112372586756207},
{-0.027580038852213593,0.049208166838135246,0.2583304999295426},
{-0.06549396518918447,0.04874837373486936,0.22319382258466522},
{-0.1115352653570769,-0.03267616273290091,0.1903919885231299},
{-0.10122549467183864,0.053106983330984736,0.18922459166748093},
{-0.06289641485743318,-0.1369299020497923,0.27625199604159795},
{0.08220011588580715,0.10859159681598994,0.010989298071069346},
{0.03809047717250432,0.11570808512791508,-0.029332615100508462},
{-0.03321638028142804,0.12351792522950646,-0.06823152556336444},
{-0.08043870961713336,0.1256321853090259,-0.08964170386031327},
{-0.11859556375686468,0.12187207139593836,-0.07869743579492344},
{-0.15150643152968896,0.11838596695734474,-0.05236228729650497},
{-0.1740208147189016,0.11185730394592659,-0.020009092628283195},
{-0.1820750449985584,0.09923746360645125,0.011166765989421049},
{-0.18475316229519825,0.08643674727058324,0.04274044026208963},
{-0.17949355600913836,0.0755494622700385,0.07555217633946033},
{-0.15617116089195,0.06280329996884815,0.11053392865310073},
{-0.1284802293767887,0.05600450649539696,0.15095497352013212},
{-0.19389176864942592,-0.12409939291534088,0.12654319555190544},
{-0.2533311282861858,-0.027303767653201548,-0.06845586384953778},
{-0.19790214702782039,-0.01200832579833111,-0.12442146248671801},
{-0.24693013807468786,-0.0795713785417283,0.013801495354346585},
{-0.13071219827533775,0.0043169752754657394,-0.18045771367994035},
{-0.0343664517076178,-0.03473842173802074,-0.13242485663501455},
{-0.005356866636843697,-0.021122208095497905,-0.14189683498670452},
{0.07686331353386645,-0.04817859265846333,-0.07694383712321629},
{-0.10122674636595552,-0.0043730288644816834,-0.16955803566833752},
{0.12652830534911919,0.10473505288385937,0.07017238263215918},
{0.15453151595692194,0.10147075855718346,0.1189710905814411},
{0.23290989987866068,-0.047884915475420044,0.13643529697846432},
{0.1760706063548969,-0.06677178996986655,0.05181953537721639},
{0.17751809765346951,0.09598065465845437,0.16516853029565431},
{0.17419924929211586,0.09194549025794364,0.20888734301222953},
{0.04853038686686345,-0.10782496515193737,0.344425949872092},
{0.09547760375009046,-0.05894191036939431,-0.07745072366850278},
{0.009630807181410333,0.8321614512404322,0.15456638369353384},
{0.005977545809665491,0.8269598194601019,0.15702773483375684},
{0.016328101894295947,0.8261964099789243,0.16133807365180106},
{0.01666640631015942,0.8305402842848915,0.15680282646907484},
{0.024739473966624473,0.8308740404656968,0.15868551074396292},
{0.025284283125748645,0.827949959078587,0.16324450293587645},
{0.028659705582582417,0.8322813412294079,0.1581549287615334},
{0.030690672234780437,0.8300348105428657,0.16189316901010348},
{0.09173918999936559,0.8249833200915043,0.16648206553770012},
{0.10266693818101494,0.8256082996391629,0.1639025222510162},
{0.09954604338529202,0.8309054319627069,0.16095774453543962},
{0.0920632176664901,0.8295911779260196,0.16229931276849882},
{0.08268530226873094,0.8271298143927854,0.16728956935222244},
{0.08400575281094713,0.8300881376694484,0.1629294354157469},
{0.08021259913037869,0.8315614312170442,0.16181945538033002},
{0.07761182661575232,0.8293805215240543,0.1652293675869384},
{0.005700599191550638,0.8345473537293336,0.1529102064817542},
{0.10373825202193057,0.833178830697223,0.1598779414819492},
{-0.002375814577900102,0.8369822457909476,0.1506527575524698},
{0.002518482921200752,0.8384179017639596,0.1506674432705736},
{0.1121161505713913,0.8353826302816371,0.158792425250361},
{0.107310537459422,0.8369555760311507,0.15811896424344282},
{-0.0002054389443097563,0.8317458144355664,0.15434368128482012},
{0.10929918197885662,0.8302155873951699,0.16212997466540124},
{0.02787398868150017,0.8391463257749205,0.16202884769516732},
{0.032276952864192535,0.833803426061539,0.15758287976410348},
{0.033759095021683484,0.8346076829071642,0.15858371455113188},
{0.02879311634662263,0.8402111580710526,0.16329266217684812},
{0.024720326764539738,0.8423170032960637,0.16282346277818927},
{0.024693148891289304,0.8429034157933097,0.16537365941468762},
{0.019911218823452075,0.8457119571383251,0.1652392819957849},
{0.018062553363918325,0.8442543655357401,0.1638736093562177},
{0.01566785183716567,0.8462696302429275,0.16487616677178316},
{0.011291892025568928,0.8444379803875766,0.16117065646541745},
{0.008238638284201065,0.8449918612307953,0.161855085287122},
{0.006550710178090638,0.8425331498019275,0.15798394238796507},
{0.004296991545134672,0.8432804855477629,0.1565077984478262},
{0.003657400637438269,0.8393395947823712,0.15266766286233657},
{0.000990821234093485,0.8405069172799536,0.1485173921751185},
{0.008562244588949603,0.8311932472515198,0.15451582020841687},
{0.0059350873537805425,0.83613544373836,0.1527926711648794},
{0.012395774699545213,0.8309742751391344,0.15472070146722905},
{0.0157370172318808,0.8295448404576734,0.15755000110576642},
{0.019561574802470474,0.8308091878388298,0.15727871809370506},
{0.024490424016401283,0.8306847496147957,0.15929943572575805},
{0.026558594487795684,0.8323764699822898,0.15872625896432188},
{0.02883032016581901,0.8317760657755588,0.1591773026017807},
{0.03162757147776022,0.8334403604095817,0.15737095927501032},
{0.03260163736090313,0.8322915530705197,0.1574279671258775},
{0.08063268502621444,0.8384127958434038,0.16577845233487767},
{0.07516990771686836,0.83403148225103,0.16152396881767223},
{0.07675548194465008,0.8331826105655956,0.16074557618612534},
{0.07988843514013254,0.8310616334740828,0.16280768647511232},
{0.0822147644248778,0.831598498713119,0.1626830499629012},
{0.07741729352117362,0.8328008066809186,0.16062660327996778},
{0.07641466174754184,0.8316805652323456,0.16054233080477281},
{0.08928833573950878,0.8298370056933676,0.162237893005695},
{0.08412663424080766,0.8298528935335441,0.16353815533289762},
{0.09300768903922636,0.8284643186095416,0.16304269514380668},
{0.09674865575022917,0.829793518617565,0.16071847267094133},
{0.10058487514422447,0.8299098146333338,0.16105857407340818},
{0.10355487263730424,0.8347629301566889,0.15973588039619044},
{0.10592465181881906,0.8379128122052766,0.15993781211837077},
{0.10918303467922032,0.8389961844459519,0.15620850723077356},
{0.10485660973282278,0.8418786624949395,0.16365430263253394},
{0.1024008230545648,0.8411950640049758,0.16479667799885664},
{0.10025263091076841,0.8437063465867519,0.16839524901280217},
{0.09730929078447462,0.843236986078949,0.16728660742257956},
{0.09250575969836301,0.8451964698433643,0.17033777913808973},
{0.09021989359472246,0.8432445582087058,0.16900530737514718},
{0.08823885838407738,0.8447577572519082,0.17009610302944617},
{0.08373061557244678,0.8414944171870837,0.16701927778104575},
{0.08341575873350517,0.8420885753162413,0.16954917466543099},
{0.07956912921022112,0.8394980642147708,0.1668991771108819},
{0.015504288877221193,0.8455309943908551,0.1669594319306463},
{0.02016031834571946,0.8449423139725851,0.1668714415521339},
{0.007626708577186287,0.8460544256059038,0.16989398541209993},
{0.008575331608626915,0.845166590293703,0.16754314275148183},
{0.002645275817336017,0.8446821103124097,0.16492821741822708},
{0.02039205525949446,0.8444355265713869,0.1706252969946372},
{0.014770610229571822,0.8459052261457757,0.17254991921894586},
{0.009696899109383072,0.8453698728540889,0.16388968309156002},
{0.004274956771473387,0.8441702045976445,0.16344849189789243},
{-7.098716734065006e-05,0.8417614246103301,0.1567459797273514},
{-0.0018303981612340316,0.8396207922032791,0.1524107557431026},
{-0.0031645553736805443,0.8415590839187846,0.15765475922824035},
{-0.005804291515073497,0.8393605761500926,0.15198123876585165},
{0.001475400359475383,0.8411674523763384,0.14911473530811792},
{0.002562019569047849,0.8429366910280008,0.15290458005473387},
{0.025947842116831443,0.8423175733745724,0.16647238659606375},
{0.02628619610473911,0.841618458834764,0.17035883486387743},
{0.02077253309198856,0.8445308288264235,0.17285974449539782},
{0.027028512681095903,0.8416309385968994,0.17260074295729502},
{0.02844006424760012,0.8396480196485736,0.16450065853672335},
{0.030410565398845738,0.8379736990686047,0.1618857332034686},
{0.03162218051794992,0.8358185048735607,0.1606668929589176},
{0.032471535530815436,0.8361558674205837,0.16902186443792078},
{0.03503070470731981,0.8334503739625168,0.16764476544215806},
{0.09227165571947592,0.8446811684435692,0.17245868187153626},
{0.09853000237369536,0.8441304973902146,0.17020516152675724},
{0.10490071645917844,0.8432420919995051,0.1726179568496547},
{0.10338430762611185,0.8433593422771254,0.1668673642514958},
{0.11129852166683449,0.8377172876698135,0.1606191674733329},
{0.10863775458567589,0.8396716531206613,0.15673271920551926},
{0.09104963047108298,0.8449330440003134,0.17814504149338115},
{0.09974205124818662,0.8448432194561648,0.17642397447570143},
{0.0800208916423213,0.8388564284602499,0.1683000211158319},
{0.08199772562221765,0.8415343102896797,0.17045673965123626},
{0.08004334777835856,0.8408909890856546,0.1763694452270459},
{0.07500878618010225,0.8355594413704025,0.1720433424989358},
{0.07269848105865513,0.8328639738582814,0.1703499118959156},
{0.07656713296258942,0.8355906345792359,0.1638500254561742},
{0.07811001326727607,0.8373082563398415,0.16527646102895913},
{0.11538696362188376,0.8376675421234262,0.16059686005342838},
{0.1111943708019024,0.8404511363371815,0.16695592470851686},
{0.01691952116800961,0.8452906443343946,0.16602996849430138},
{0.021291056674658602,0.8445210011686546,0.16600735124912042},
{0.009332544584275598,0.8473824978499209,0.16675990445261119},
{0.008328698295560112,0.8486006936578969,0.16858291637925468},
{0.01585620081922642,0.8484607517770292,0.17158202505530987},
{0.02181727631719566,0.8456735759830782,0.17003165937194414},
{0.025950345505065107,0.8423336471099145,0.16549829592689874},
{0.004060570073179658,0.8458371513360337,0.16247316192762157},
{0.010383484315011765,0.8451877699496013,0.16292426753013567},
{0.00586124979389651,0.8443487259219362,0.15912828824304598},
{-0.0012469228076086181,0.8458537827568735,0.1601809382093082},
{0.002699780279969385,0.8477406558694993,0.16460847773292864},
{-0.000222454548492511,0.8426670315003881,0.15614157257804887},
{0.00383997447634592,0.8432753796272069,0.15619362322449282},
{0.001384671125519216,0.8409346744496343,0.14922819332435464},
{-0.001726953697932237,0.8401523532335822,0.15180525800882694},
{-0.006076925365340195,0.8412355271860804,0.15053869227869124},
{0.03261700469461509,0.8363336203781899,0.16006428279621845},
{0.0324773974250459,0.8361066919527054,0.1649931320101493},
{0.026976462034652003,0.842871454217791,0.16910961934922306},
{0.02767174713404343,0.8437252583216264,0.17214218915513504},
{0.03131933250672365,0.8393558544128795,0.16976233445562997},
{0.03398970417145223,0.8359896399632618,0.16716267731199877},
{0.02219278455225551,0.8467132628597736,0.17247556115259738},
{0.08644682898507916,0.8437091845862841,0.17053853352421958},
{0.09107808482447236,0.8442545514309059,0.17130194300539728},
{0.09097398353158447,0.8463923458384247,0.17515121224003669},
{0.09854115608364765,0.8461370622036393,0.17310142060404146},
{0.09798221889191727,0.8439644682210695,0.16915175558682052},
{0.10432002953304109,0.8444379803875766,0.16960038258712298},
{0.1054180503127869,0.8463068836341681,0.17191043984834897},
{0.10912975712468168,0.8448345319554128,0.1686783425644019},
{0.10688165252573503,0.8430921365657023,0.16716763451642203},
{0.11253287796123025,0.8424425692841041,0.16424908041224434},
{0.09854115608364765,0.8461370622036393,0.1731026475121362},
{0.10297040584279414,0.8429928561541159,0.16603243470350196},
{0.10545978997403055,0.8416659240671164,0.16330214283030758},
{0.11139827301284097,0.8386569257682369,0.15978931905987287},
{0.10854480700274029,0.8391361139338087,0.156882674639322},
{0.09930952276924862,0.8473304843825101,0.1750508412434773},
{0.10912975712468168,0.8448332059032297,0.1686783425644019},
{0.07958889606285878,0.8429338530284683,0.1758710355013231},
{0.0821340735298786,0.8415490579728386,0.1694925633909177},
{0.08567595891124452,0.8447825184880023,0.1745712193225186},
{0.08498814679752109,0.8458358252838506,0.17693952373571753},
{0.09143251254772236,0.8474048052698255,0.17695439534898724},
{0.07614046637788188,0.8357262265132224,0.16315855740418864},
{0.07557481217415792,0.8355053458771343,0.16805656041359593},
{0.07659946632843995,0.8392860693676112,0.173401343864658},
{0.07376751458553611,0.8354344330678597,0.16999076243545247},
{0.11591242729074633,0.8395315253446277,0.1592100821160293},
{0.0923963170177092,0.8448220521932776,0.1707324841472785},
{0.09865518417839308,0.8442706251662482,0.16847881508636678},
{0.10761726448310942,0.8431522674553561,0.1687697658069773},
{0.10926807552110092,0.8404259785247334,0.16278480897669909},
{0.10304973350657695,0.8433746600387932,0.16546607409814773},
{0.10734510156726297,0.841758016532289,0.15867211389900915},
{0.08658468884008926,0.8440280071887641,0.1759281548892898},
{0.09986472966465051,0.8453241178572625,0.17478685771492916},
{0.09242147483015707,0.8453042518605361,0.17642397447570143},
{0.08034421290781553,0.8411402249310438,0.17483924297267164},
{0.08212290742691529,0.8416755782227305,0.16873039321084582},
{0.07986366151102746,0.8388821563512063,0.16637076390538752},
{0.07736188436873301,0.8378417135008362,0.1723853896041388},
{0.11215609324603147,0.8404325963926386,0.16420695656765794},
{0.00762651028900933,0.8460549956844128,0.16989405977016628},
{0.02844006424760012,0.8394572168503234,0.16445108649249104},
{0.030075607095967957,0.8382064893883199,0.1706212196939991},
{0.021291478037034572,0.8445225131160038,0.1660071405679324},
{-0.003491706079591726,0.8436984026666636,0.15629097032635403},
{-0.0005570782400716911,0.8463651183931298,0.1608806600066584},
{0.028421487124024026,0.8398611298667282,0.16355878969630933},
{0.030642971535217948,0.8397586396652781,0.17022047928842504},
{0.07958001027393012,0.8429351790806517,0.17586803639264706},
{0.08498814679752109,0.8458371513360337,0.17693952373571753},
{0.07989461925265048,0.8391423600113818,0.16721720656065434},
{0.015857105509033666,0.8465432555340787,0.1729429759576639},
{0.007657765462897793,0.84573673076743,0.16997351136405964},
{0.015573020516549243,0.8462790737173539,0.16714527752447325},
{0.02594537590763086,0.8428429007203131,0.16660994901880843},
{0.0268115606295132,0.8419664174062417,0.17275056206797615},
{0.009695672201288339,0.8453277118304691,0.1638785293816078},
{0.09227798854812663,0.8452091355006653,0.17259802888787332},
{0.09853000237369536,0.8440871962095774,0.17019400781680497},
{0.09969713897611211,0.844450646044878,0.17651782674844427},
{0.09118739118200461,0.8454899611312414,0.17829778535467194},
{0.08199527180602809,0.8420596376354205,0.17059430207398094},
{0.08024625854841243,0.8412196517389149,0.17654944131965342},
{0.09039935678785446,0.8440629926589812,0.17277973521600687},
{0.09791532141822568,0.8445196751164712,0.1701952471179108},
{0.09912236351624944,0.8480152230294911,0.17725568184082022},
{0.09096803488627654,0.8490063169098278,0.17932664073970264},
{0.08206835339223764,0.842105590920424,0.17053605492200796},
{0.0805564308291741,0.8426781976033514,0.1739664403828843},
{0.08485430227809389,0.8478051367060344,0.17920992336155764},
{0.07944352604314751,0.845926405801674,0.17762733584944093},
{0.01685263608732913,0.8458458512297963,0.16707468693348643},
{0.02151612614848437,0.8455731554144745,0.1672110100551253},
{0.016057835109141355,0.8500887348886516,0.17397065400664405},
{0.00828133220729614,0.8494329339224911,0.17068151169279663},
{0.01031654966228709,0.8457441046090096,0.16396899836233175},
{0.02588217155123467,0.8428888540053167,0.16654178745798903},
{0.026897183942913475,0.843830586522609,0.17039229599373423},
{0.02205767594570031,0.8486825742819577,0.17474597317144858},
{0.027532945410192914,0.8464729128033132,0.17461583416232765},
{0.09324562245853044,0.7686472695677758,-0.033563217285404984},
{0.0907806277730563,0.758309044529148,-0.02471460738993639},
{0.09515910336589782,0.7487862300460981,-0.033692104600409015},
{0.09702673013235037,0.7603971181763017,-0.041336113821032305},
{0.09011763886048223,0.7776073174186788,-0.026563644639801803},
{0.08715696091171819,0.7686521895931658,-0.01663064627675127},
{0.08767372468681793,0.787188379053702,-0.02040678435313696},
{0.08432386901179698,0.7797129767485238,-0.00952077583273118},
{0.08593994243979268,0.7972974077458213,-0.015154626266722962},
{0.08230880259278649,0.791383425689873,-0.00345315761869557},
{0.08493112655364286,0.807835135476462,-0.010856730031781068},
{0.08114756506363337,0.8035001593524342,0.0013144461283585848},
{0.08467337670965694,0.8186531187591698,-0.007739887750674127},
{0.08083772739417038,0.8159897987177335,0.004914615840730635},
{0.08620515287643557,0.8410744180423253,-0.004703600041444713},
{0.08245378842915496,0.840484609860049,0.008382180334781206},
{0.088325609461484,0.8641080312158383,-0.0025199391000000756},
{0.08456058791601734,0.8635702241079619,0.01076659566235566},
{0.00908345745501924,0.7601369145161263,-0.026474414960183643},
{0.007243058133861316,0.7588368380840899,-0.03709894334027501},
{0.0006648602572438693,0.7405237847876543,-0.03411222767527789},
{0.0033058109137205295,0.7424087617695884,-0.018754808372106063},
{0.01113574008623714,0.7635413242258251,-0.016662868105502267},
{0.0062504151271423145,0.7473337319710578,-0.004574725119451729},
{0.013293350918437665,0.7688777919664671,-0.008168698326294733},
{0.009351134100862718,0.7550508103848798,0.007701791634681593},
{0.015452238230777205,0.775873634315742,-0.0014231824073821814},
{0.01244938686538254,0.765164759102389,0.017447655530755148},
{0.017807691091508954,0.7855872515970422,0.0038626846691097944},
{0.015392714598665307,0.777161230985643,0.02416342822312831},
{0.01796426439321671,0.7900065745543311,0.027505823305492297},
{0.029218605595279713,0.8459825709277891,0.01408524573553236},
{0.027768226725130556,0.8422748422724442,0.035942068151014375},
{0.03672728313514878,0.8846186380191142,0.018150364043770354},
{0.03526987742772973,0.8808808315259313,0.04000419974358737},
{0.13282639638980184,0.7386796551701681,-0.024717085992148},
{0.12724707520446565,0.7571627157922981,-0.028568833828999045},
{0.12395920937075726,0.7585333208502663,-0.01830867236702626},
{0.1280922661656156,0.7406663663798775,-0.009883891056732914},
{0.12063668028511931,0.7620120514472801,-0.008878817859922672},
{0.12330982798432494,0.7456991309915305,0.0037459425049426822},
{0.11744793375385346,0.7674228400752375,-0.0007651135201981642},
{0.11872069598951818,0.7535240038155354,0.015475927471414727},
{0.11455169946259136,0.7744892110504437,0.005621017471041148},
{0.11455665666701459,0.7637396867608207,0.02470500280636638},
{0.11209661918596377,0.7828509367204735,0.009948644539511371},
{0.11102834163275727,0.775825214821538,0.0309622340895906},
{0.11012021896145442,0.7924743576672932,0.012099885364028064},
{0.10836776044676459,0.7887433673301923,0.033932739696123745},
{0.09769846851073145,0.8615411535864558,0.02182982424089198},
{0.0959461091401301,0.8578094072756801,0.043662604214921304},
{0.093751244916689,0.8838217550150687,0.022204117960868092},
{0.09199887315307653,0.8800888809402867,0.04403688554188636},
{0.1176239021178671,0.7448328595185706,-0.020659614171732833},
{0.13821738098608852,0.7510751324374477,-0.015414891891953686},
{0.13225106324444164,0.7566400281579124,0.0018841404536874468},
{0.11098910535974738,0.7511513370624441,-0.001476943289352115},
{0.1250392602844688,0.7722275484973996,0.018800092434512285},
{0.10334289018315579,0.7679992142335269,0.016332928972103034},
{0.12096410363727379,0.7886541128645519,0.024997341544215405},
{0.09920249672575102,0.7848244121943732,0.02259464652533028},
{0.10261668452117442,0.8908211913375504,0.036096918824185066},
{0.0808221245932482,0.887170383781995,0.03372240551244603},
{-0.0020298512812027903,0.7585130954562195,-0.007665442933248241},
{-0.005641943070212729,0.7530841510670621,-0.025641604617080718},
{0.015304736613163955,0.7462617117285119,-0.027933072361719564},
{0.019330110534938678,0.7524238018658431,-0.008005593907759349},
{0.0018756822236403088,0.7696474351322071,0.006333603213869649},
{0.02332673267105869,0.7639044022707935,0.0062753560618966685},
{0.005477797638748496,0.7836412018566142,0.01531828837075596},
{0.027266123882112484,0.7792812538153044,0.01603947486325877},
{0.026138929954335897,0.8918444202955607,0.031026033310517592},
{0.047951459748296316,0.8876090963734511,0.031562241719967514},
{0.12701656519878537,0.746404305713746,-0.014877035212033044},
{0.10770581254711942,0.7402758749944485,-0.02267347846867071},
{0.0977695672151716,0.7541835970430792,-0.011507635758573503},
{0.11799714243190323,0.7590357706975938,-0.004736069730416884},
{0.09031964494072893,0.76984693782422,-0.0020143290348525506},
{0.11128612865577636,0.7731509393583261,0.003824018474608598},
{0.08497353543748361,0.7865732271638118,0.005944884029021931},
{0.10643078239043106,0.7883084346071089,0.01108773575790367},
{0.08224435893528445,0.8048397570967352,0.011657653157431565},
{0.10398044863703869,0.8047964559160984,0.01616746988146662},
{0.08241777433902014,0.8295938176373749,0.01610882615313978},
{0.10416103959417695,0.8273654427120327,0.020132973166819768},
{0.08831534804832784,0.898713184709446,0.023341300655557447},
{0.11005209457966818,0.8964685377605842,0.027396963096358123},
{0.0339279621903609,0.7550946816440252,-0.0160294117382796},
{0.025278656698728304,0.7414259959926826,-0.028532894096930612},
{0.0052366420365692725,0.748104515293815,-0.023533553436101435},
{0.013075023242627553,0.760495072535705,-0.012198793985282595},
{0.042279946953699084,0.7760648089043237,-0.0023091463749132075},
{0.020625180190507984,0.7794614729821111,0.00021456639695405818},
{0.04717509957056299,0.8010422038972412,0.008399220724986068},
{0.025052062884542366,0.8020799946432449,0.009910325349319793},
{0.04723877486137943,0.830375196984587,0.014496904383848586},
{0.025107608360104717,0.8285488389449578,0.015268976579755861},
{0.020219643689654492,0.8977466909560594,0.020758212967710923},
{0.04235865496692897,0.8993550063591326,0.020073759359984265},
{0.07748683070622052,0.7700148631240571,-0.026158393178202607},
{0.07602799980252978,0.7502572556726699,-0.05019215952313577},
{0.053839577590166714,0.7503389504015645,-0.04890204707198971},
{0.05544752120290832,0.7728508302025437,-0.022459760992974146},
{0.0789597524634843,0.8082551346212201,-0.003641816426032697},
{0.056853260447226266,0.8115899575738277,-0.0013458500183797665},
{0.08034743509069059,0.9025930027163435,0.0070286776320730784},
{0.05815901287832761,0.9026813153131433,0.008301092863428196},
{0.05585309488279498,0.7706623483797975,-0.028674979968711482},
{0.0772226488894955,0.7727016307424154,-0.021842304003027464},
{0.08177590311728909,0.7500738267159992,-0.04784368392762974},
{0.060015002607396596,0.7508037626743089,-0.05230145000522086},
{0.05257448662834694,0.8089975503416655,-0.006497525571134859},
{0.0741305058794273,0.8135734466006624,-0.00026721190792878483},
{0.05314425531174212,0.903346386251575,0.004113581177980621},
{0.07492217142581736,0.9026311979764245,0.00842633663318115},
{0.052504478508879876,0.7607013789907886,-0.03314354035893419},
{0.04712625871398313,0.7476894361744469,-0.04764291714848886},
{0.025744596735478888,0.7512920225239752,-0.04377629769836813},
{0.030836178577613355,0.7636332307958319,-0.030044172223419142},
{0.05644584020869186,0.7756815054653086,-0.021078497945495926},
{0.03450273765022349,0.7775937098925368,-0.018806859018549983},
{0.059147776872585364,0.7917160541066717,-0.011273940749051317},
{0.037066814459106985,0.7928482176318824,-0.009450829678319377},
{0.0604029038535145,0.8096991186976635,-0.00443715030369599},
{0.038223131962869965,0.8095527572370677,-0.003185456186829994},
{0.05990238731591182,0.8340505922740815,4.075441686449406e-05},
{0.03774849203235665,0.8325381492045535,0.000993467141954331},
{0.033265481391240165,0.9018929463076947,0.007149199664612905},
{0.05542473045557247,0.9034189969033646,0.006127904016327647},
{0.08079054720107225,0.760549911609637,-0.03236301612948529},
{0.10187644997067541,0.7627081420923905,-0.026166758460666826},
{0.10843574850542918,0.7501307478157889,-0.03907810720625027},
{0.08771089132698115,0.7473065045257633,-0.045979775064494625},
{0.07426202051277556,0.7810484104411092,-0.017428062180272326},
{0.095764278881886,0.7819774773011003,-0.01215959489130588},
{0.07071067926397243,0.8056599017825368,-0.005806491274536344},
{0.09245367187288595,0.805290391764829,-0.001321101175296768},
{0.07143295634144836,0.8349694348999496,0.00013854766712380708},
{0.09311202579932429,0.8320561230394495,0.004181197446313486},
{0.07747203345101719,0.9036179295168685,0.00735797232889731},
{0.09921534827821821,0.9012263634219138,0.011068997525183855},
{0.041587214814585605,0.772100854745353,-0.02649232286116257},
{0.03732338696704237,0.7596511084826497,-0.03872862429441243},
{0.03698876327546319,0.7458107052700862,-0.022599132795333304},
{0.040381969703165314,0.7551909381609133,-0.013060219790918629},
{0.043186545284641754,0.7654138090526125,-0.00451399936526715},
{0.04455721230766539,0.7861337585986813,-0.016603381652423494},
{0.045376353159571246,0.7763828879261404,0.0029589863027546545},
{0.04589193959862054,0.7961870063480284,-0.011129376275058814},
{0.04692798293006491,0.7879877158739368,0.009283139845692512},
{0.04665904219709353,0.8066925866079844,-0.006703832026218692},
{0.047826463838764606,0.800116743403468,0.014396496208256027},
{0.04688090188105525,0.8174434369497907,-0.003779081416511995},
{0.04808922045921794,0.8125456818006048,0.017840526374307317},
{0.045755604083970614,0.8399193770187013,-0.0009088600554608302},
{0.04689452180020804,0.8370926799124859,0.021106084788111205},
{0.04104378127968884,0.9092342686262355,0.0052722037818004434},
{0.04218610707396727,0.906406245467837,0.027288078101201842},
{0.11310293168387975,0.7431188317311719,-0.005153478735864047},
{0.11493836140760343,0.7554027347198958,-0.02275279373944243},
{0.10698769952135896,0.7684997679501627,-0.013303816816276228},
{0.10409405536940808,0.75793027693218,0.005533200594683597},
{0.09971803359275604,0.788069026419489,-0.0030676482237118924},
{0.09585344659644883,0.7800397432710922,0.017099882854443322},
{0.09686192787130005,0.8039165645239857,0.0026615664303718113},
{0.09260735760301715,0.7979307153969114,0.023568563692340505},
{0.09614683874023779,0.8147528770700487,0.005202133697278065},
{0.09178324715367704,0.8101911708087135,0.026493326695058272},
{0.09731066640870203,0.8359232629960346,0.008152575018908174},
{0.09303100029302658,0.8337514249871396,0.02988995359381241},
{0.09921355129161483,0.9036183137002114,0.0372761757914166},
{0.10353799335624314,0.9064365092008408,0.015659368821096423},
{0.025446817465775345,0.7696372232910953,-0.019101230210212553},
{0.01855171790339176,0.7567474383847529,-0.029603650252348655},
{0.017537932419807778,0.7444523816860765,-0.011947339790914153},
{0.0253533493763753,0.7590316066458785,-6.205800287332717e-05},
{0.0317378197041329,0.7890198306208761,-0.007898890082549296},
{0.03248922035759531,0.7809430822401265,0.012604169376992366},
{0.0341941640678884,0.8047915358907084,-0.0017937210450076982},
{0.0352798042295872,0.7987311923741639,0.01949250235533823},
{0.034815041528887154,0.8157146614792331,0.0012537203741740058},
{0.035996120268744186,0.811075982226216,0.022939011123601128},
{0.03325797122653899,0.8452541469168284,0.005433659929865103},
{0.03439512913520622,0.842005740430329,0.02741101677089799},
{0.03032509080157814,0.8843533284383831,0.008110785785620333},
{0.03146891615019468,0.881458358234249,0.030118294822557515},
{0.028597492667070838,0.9074824297620985,0.010331613367228138},
{0.029741367587731573,0.9045874595579644,0.03233788310305952},
{0.020401982061352016,0.5332618533372527,-0.09601907299273452},
{0.027642859025266982,0.565798898324521,-0.09320210440019992},
{0.02941053615753619,0.5690414305237792,-0.12368892399608601},
{0.03114796194981257,0.587753860994572,-0.1203465413067331},
{0.029189853809624914,0.5808051120873181,-0.09049797417334915},
{0.03336632332221982,0.6063360037401114,-0.11511667824721256},
{0.031115727728050435,0.5970722651532302,-0.08591999588849465},
{0.036740618015047244,0.6351593590337157,-0.10457306383631941},
{0.03419846444272553,0.6235600087968068,-0.07622851252494395},
{0.04129944909781698,0.6771811223880421,-0.08468381782147336},
{0.03843365204171356,0.6629812351037168,-0.057570140368386334},
{0.04401812871964995,0.7066498809115288,-0.0676973000356838},
{0.040940906894895684,0.6906679034230742,-0.04161992616727339},
{0.04564913572597062,0.7271716414247571,-0.054253262495790947},
{0.04238475464821726,0.7094081314176703,-0.02936123056304157},
{0.04651654735594769,0.759000599332211,-0.03044141779987482},
{0.04354097300789185,0.7420903109574398,-0.004925447332395392},
{0.046023268336802974,0.7778489935273223,-0.020136641498092946},
{0.04341706768333314,0.764300941445619,0.007357265927266989},
{0.04508267597652796,0.797065571687958,-0.012622734107557366},
{0.04267843183126055,0.7864249695725243,0.016143910767445206},
{0.043985882104876875,0.8159179440396187,-0.007633307855574651},
{0.04168819306868682,0.8075959255770188,0.0219017160980399},
{0.04306013657184938,0.8335432224013637,-0.0052984645722325184},
{0.04082815528028935,0.8268720769418108,0.024661639660674153},
{0.042340548777773046,0.8640240685659197,0.000629484407178563},
{0.040229275413918714,0.8582885954412519,0.03080543771368379},
{0.04553997808457103,0.9027223485727566,0.009017954195071736},
{0.043324070528353346,0.8963473341124365,0.039064809505384955},
{0.02163507426861978,0.535212438919728,-0.12662608000986186},
{0.09258508736214582,0.5341987525802324,-0.0954328711766763},
{0.09202492326232063,0.5363451601304365,-0.12604608709234372},
{0.09806650376012321,0.5670395006964902,-0.12356153623542},
{0.09857458003447135,0.5640832594456848,-0.09300530338459763},
{0.10178066438820746,0.5859197573230317,-0.12118305716014237},
{0.10196731552775322,0.5882123404386658,-0.08973912532024082},
{0.10410312705350258,0.6137448431828967,-0.11560267017585517},
{0.10302821923938012,0.6258245093493835,-0.08052738780775943},
{0.1042084552544852,0.6448930282069081,-0.10659648314478305},
{0.10347109588255163,0.6662090196198158,-0.09904792489532908},
{0.10207439114329503,0.65501813063437,-0.0704621808027413},
{0.10221196595905072,0.6874022830442149,-0.0901732648906164},
{0.1009094728898577,0.6744875386136014,-0.06231377603205416},
{0.10056866508576047,0.7079102501361354,-0.07995398797212422},
{0.09944955140119378,0.6930139004163687,-0.053087179299314155},
{0.09867498821006383,0.7271826092395436,-0.06833800631437546},
{0.09784341716806676,0.7099440423948546,-0.042893927704043947},
{0.09665992179105334,0.7446617244288698,-0.055220004109398535},
{0.09623854702206763,0.72463106176484,-0.03189263939477589},
{0.0950797757021151,0.7617703753386366,-0.04088500821851822},
{0.0941466067554638,0.7429168752229696,-0.016604620953529298},
{0.09485422290085804,0.7800562011897773,-0.028793147329150264},
{0.09330013931417491,0.764139832301864,-0.0025174852838105856},
{0.0956362095056118,0.7985577769704282,-0.01956529890229338},
{0.0937400788137256,0.7853382016468191,0.008150418634984063},
{0.09699822620691681,0.8166478799979285,-0.012937516588432573},
{0.09493601677384135,0.8057729756154309,0.01577337212981969},
{0.0988362460699516,0.8377165316961387,-0.006716497683520058},
{0.09678789202323905,0.8293665174215588,0.022839978572236023},
{0.09977797858724398,0.8636074774992024,-0.000630004913642987},
{0.09756458681227098,0.8570204681917227,0.029361069453897815},
{0.0006599402318538176,0.5203136353837715,-0.11310409043041368},
{0.007156319449465815,0.5371805234338175,-0.11216963261061237},
{0.033953727260350584,0.5281199682632336,-0.11082873360015029},
{0.039209628036104185,0.5474059472857944,-0.10922753178542434},
{0.011664896872395029,0.5537945816652675,-0.11079030287285922},
{0.04269984695436891,0.5694669073794251,-0.10770823538078125},
{0.014428625089424147,0.570989376394899,-0.10957924543925265},
{0.02147902147337647,0.630786373544773,-0.09219929912441333},
{0.05164561805653286,0.6461501752486399,-0.08184972208765649},
{0.02984859191940605,0.7158731563173054,-0.046538489182026015},
{0.057254347857109956,0.7059723302109614,-0.048116342563918536},
{0.05913133134691134,0.7438584094520848,-0.02047695358174782},
{0.031018529342321906,0.7584588140677851,-0.01459504463841752},
{0.058837654163868054,0.7689422728030022,-0.005744625363334416},
{0.05773551890445086,0.7962427872908009,0.004893931905274683},
{0.029520363021532898,0.7973104575864656,0.0021454099128138723},
{0.055504863665074046,0.8418552149180176,0.01309266469386868},
{0.027303649919596353,0.8423039534554194,0.01038337897441774},
{0.05539736668715627,0.8592140559350248,0.016630980888049842},
{0.027278888683502308,0.8614931182755948,0.014196981123232014},
{0.05671847405895856,0.8767676779068321,0.02041828506739887},
{0.02863961651165727,0.879646561982613,0.018106988505067076},
{0.026433648150308076,0.5086406334821446,-0.11187222513124061},
{0.07783988280524312,0.5052213769451984,-0.11711446880880812},
{0.07420425668823387,0.5662661644134549,-0.11257824257820831},
{0.04590819922912873,0.5656381609710979,-0.11372571147207589},
{0.04718786437195281,0.5987817447055708,-0.10682657178808735},
{0.07529991040286758,0.5944131091635094,-0.10788626098463053},
{0.07956634078273306,0.63875381556799,-0.09179995912908884},
{0.05349744373388637,0.6616713186209,-0.08072821655195563},
{0.08344889764507446,0.6786063806247764,-0.07189710558810102},
{0.056408202634108486,0.6980109359771409,-0.06010567607280301},
{0.08490757983263252,0.703859111144371,-0.056461796210429134},
{0.056645008289406294,0.7248547680074492,-0.04099074538886576},
{0.0849451678351717,0.7258668432555074,-0.040317767709378886},
{0.053090878613115004,0.7625698980540375,-0.013929378835454906},
{0.0812781378281413,0.7651571993656436,-0.012000902384707175},
{0.05165252096369222,0.80342924654316,0.0005982540193121967},
{0.07990274906790458,0.8062117005998977,0.0024603287168107257},
{0.05124515029720209,0.8494181738463208,0.007568926163127934},
{0.0795098534383303,0.850264219925234,0.009112364153312184},
{0.050528165035447985,0.8655569229246607,0.010529901544157408},
{0.0787197741973557,0.8676512426493873,0.012219056558362558},
{0.04958752310312869,0.5037986592757309,-0.11847026421856201},
{0.15472114141912163,0.7490080525510266,0.06574569822630172},
{0.1648735332569333,0.7440558425112513,0.0475155789598671},
{0.15300225557138808,0.7490279061547416,0.03974020382202816},
{0.14501617445953968,0.7530642974633468,0.05939304075793028},
{0.14200840306875498,0.7565343281665979,0.03359822754164407},
{0.1360262966310201,0.7591925298944676,0.05437263197830237},
{0.1324521646348811,0.7661910243481088,0.029405671900695846},
{0.1282088100416058,0.7670807557910013,0.050944725119637636},
{0.12482302702752748,0.7775069092430862,0.027379414592699883},
{0.1219651614985012,0.7763284206425403,0.04928654024006663},
{0.11827516724198023,0.793666453793981,0.027907691475072625},
{0.11683170367200146,0.7889943134111075,0.049687441754784435},
{0.10876667907971313,0.8419804091157261,0.060739194405080965},
{0.10859648585885251,0.8585359351559491,0.04141913460211039},
{0.10221588215054514,0.8868551427597106,0.06980797853500742},
{0.1036780715602326,0.8921634411862178,0.048409139843176734},
{-0.028130276150181235,0.7515560184455343,0.026863865332683787},
{-0.041114446228741955,0.7469309467186592,0.03287199709364062},
{-0.033508842949387656,0.7516341192012225,0.05236496418689352},
{-0.022895505458281763,0.755407840640452,0.047456092506788325},
{-0.01617352386736844,0.7587415234360418,0.022354048608648737},
{-0.01311739494743505,0.761274555752225,0.04377041101811554},
{-0.005855115253422751,0.7681206285628628,0.019573056927215744},
{-0.004678993717988853,0.7689360267254292,0.0414975327900638},
{0.0022945412113813276,0.7792171447691011,0.01866836711997595},
{0.0019909372264804858,0.7780027288294977,0.04075890933100228},
{0.008454685645976522,0.7930110246181524,0.0198700306512005},
{0.007167039404031021,0.7895990551717083,0.04178418313583718},
{0.013823784184734568,0.8261198211705854,0.02691592837213878},
{0.012081289650935464,0.8207909255596997,0.048419041859012135},
{0.016970344906358778,0.8487196293850211,0.03299841819944408},
{0.015229139245709716,0.8433894077219525,0.05450154407932851},
{0.023421625956730426,0.8934137844648784,0.04299053122524167},
{0.02167554984273551,0.8880841204873073,0.06449416521857947},
{0.1417035226037151,0.5192465351666156,-0.05726117020969736},
{0.1542675324283738,0.5595090610292032,-0.06800135016898273},
{0.1421955747147651,0.5559181984681358,-0.09600613468918988},
{0.14834584191954703,0.5896786443280244,-0.10154027095620834},
{0.159778357441592,0.5905910673741646,-0.07303666774091351},
{0.14721325703196023,0.6174518158645671,-0.10008131612240702},
{0.1588257562536017,0.6126427574955237,-0.07191544724446697},
{0.14620581677003788,0.6607034988153301,-0.059747617197312995},
{0.133648994891793,0.6690814841158682,-0.08670830292888801},
{0.12467183229261893,0.6878646415007696,-0.07817684257940671},
{0.1363249805905309,0.6792737194842317,-0.051053486184683326},
{0.117456584075572,0.7037276832621001,-0.06911258189851646},
{0.1300937746305286,0.6927771443331151,-0.043306614972277974},
{0.11110147279101101,0.7208423943542746,-0.0575585652960581},
{0.12464082497895161,0.7075261783304345,-0.033366180802592585},
{0.1064516398280418,0.7398224023268225,-0.04315788644656997},
{0.12057966004124109,0.7243409785550033,-0.020641037048156785},
{0.10457158287149795,0.7580426071844107,-0.02935083282676383},
{0.11837491858798671,0.7428624079393692,-0.006426240971528773},
{0.10441173781487084,0.7758611545536063,-0.0185577594962826},
{0.11781228827896092,0.7618942434841621,0.0053632304480220345},
{0.10588679117003669,0.80234909648536,-0.006224755397746536},
{0.1189983366162523,0.7902072050103507,0.01884411240979058},
{0.1083366044169646,0.8279019237677261,0.0024855856733470775},
{0.12132074970950323,0.8175996260681558,0.028429115022330257},
{0.110504860845664,0.8562460908957585,0.009760307950461743},
{0.12344565538552146,0.8489921269121665,0.03677380030215525},
{0.12938488200499543,0.5155386082230936,-0.08512933417600026},
{0.10389124374344261,0.5143785604230021,-0.11246213245760517},
{0.07569214920285587,0.5165015203962843,-0.1109427369088736},
{0.07883786719972814,0.5412966141965373,-0.1097443327395573},
{0.1067662611997732,0.53686548069971,-0.11140800772302706},
{0.0867473595032376,0.5798152575080873,-0.10632947572153674},
{0.11473994930056355,0.5756926356285397,-0.10773628076480568},
{0.08920195645243394,0.6068473393763677,-0.10165365461437871},
{0.11751123725433812,0.6058503959948116,-0.10168925973514858},
{0.08923868933721006,0.6461923486652704,-0.0904618609391259},
{0.11754022450720296,0.6470779160564477,-0.08971126583138227},
{0.0869988260906171,0.6866188340641561,-0.07407257474923626},
{0.11516996199825677,0.6893398311790571,-0.07244646298228356},
{0.08384071508268669,0.7203301168491778,-0.054589175060520176},
{0.10911929742334865,0.7494023238048283,-0.032657622788357966},
{0.08059610085757099,0.7501233739742094,-0.030591373233677582},
{0.07993055898471897,0.7705780139395471,-0.01703465843724466},
{0.10824734995132433,0.7702026420276091,-0.016608338856846712},
{0.08062611673035369,0.7944669307712335,-0.0051942021702008866},
{0.10893407148007457,0.793423835816497,-0.004526243660192527},
{0.08417935410984875,0.8429450191314317,0.009840713806206563},
{0.11247251160436632,0.8417742885558084,0.010602648519068331},
{0.08460521514883752,0.8586824949047217,0.013277419702722528},
{0.11286995546899889,0.8596230872649967,0.014716260679576584},
{0.07128644616471973,0.7720490395661189,-0.04623507109229106},
{0.06751153499642876,0.7586808224678795,-0.030031209133852384},
{0.06930233748733225,0.749502558478266,-0.04049586767129453},
{0.07281326512707505,0.7641882394030568,-0.05519273948507075},
{0.06997899589110339,0.7806908225000394,-0.03821927153992537},
{0.06597725544141646,0.7687686715041008,-0.02066828927947349},
{0.06890328253126216,0.7900264281580464,-0.031225883006840167},
{0.06471320549252549,0.7796696755678867,-0.01249757708888182},
{0.06807048458117025,0.7999667755766542,-0.025323104232888072},
{0.06373412043990405,0.7912756436727006,-0.0056008540420496526},
{0.06749168139271375,0.8104154471298314,-0.020569132797997797},
{0.06305005101552023,0.8034740596711459,-4.6306485818519135e-05},
{0.06719800420967037,0.8211651573146204,-0.01742254729035147},
{0.06269562329227023,0.8160417997921333,0.0037013276651336126},
{0.06731676643464002,0.8437326321632059,-0.014400883334170585},
{0.06279953868999218,0.8408643193258577,0.007170181032334227},
{0.06827689018034257,0.9132044812557906,-0.008131754760330597},
{0.06375062793063348,0.9103369243921171,0.013437834837858306},
{0.17282982157019808,0.7481888621270765,0.04854543817879348},
{0.1711741400788608,0.755475915450194,0.02769419707357509},
{0.15203371697117712,0.75928860051619,0.03037639167085308},
{0.15165385878923596,0.7525883190876393,0.051549417308194505},
{0.13166001576105965,0.773088156364306,0.03503612664965772},
{0.13026084481260256,0.7675465099325862,0.056530056915337044},
{0.12199414875136605,0.7899912567926636,0.03911205166353836},
{0.12039481828130989,0.7851846522398094,0.060756284367330056},
{0.11293260213989756,0.8563432892814872,0.04986402976935101},
{0.11132674055301374,0.85184152801464,0.07156570407939693},
{0.10846922202829708,0.8904333396634768,0.055281064474881694},
{0.1068766953213118,0.8858578275878228,0.07697255172983786},
{-0.025565245079446304,0.7617654553132467,0.017751048834467983},
{-0.04422882230064836,0.7584824599328838,0.012381392610212332},
{-0.04901870868158491,0.7512857888394129,0.032774092306281796},
{-0.028355407589062315,0.7551056494588118,0.03875607481390608},
{-0.005665812009510557,0.7750169922123741,0.02527825392586889},
{-0.007473679676641,0.7694831038055769,0.0467442503446233},
{0.0037286480580111863,0.7921528829604468,0.03082467166684592},
{0.0021362576741474726,0.7874707042386162,0.0524914100787191},
{0.008508396955902239,0.8236870235278402,0.036297437743104795},
{0.006888642803622337,0.8191114990591751,0.05798644639584934},
{0.011506278723862657,0.8465706812675504,0.041293060500616555},
{0.009886524571582756,0.8419953426940511,0.06298330845446691},
{0.017660573657238502,0.8918274046913779,0.04910936975398033},
{0.016037076815619087,0.887253776353405,0.0707987006250124},
{-0.046134855008369884,0.5318205089721649,-0.08518262412354999},
{-0.038223169141903136,0.5231689851315531,-0.11354899952739869},
{-0.03656249326710943,0.5453523881744375,-0.11886184618896416},
{-0.044779059598616,0.5515675203990974,-0.08994401897206404},
{-0.032968507667255384,0.5661491124240114,-0.12139003283782336},
{-0.041720476862493104,0.569915373270584,-0.09220201319383503},
{-0.02776469471697894,0.5855281257805852,-0.12154246687383773},
{-0.03722180145539926,0.5870413248237878,-0.09236436163869587},
{-0.01864424412395139,0.6101344988084458,-0.11882427057943604},
{-0.029072950536314035,0.6093727995627944,-0.08993101870346411},
{-0.003155954624006202,0.6406162868418424,-0.11076949500729268},
{-0.014716304055115233,0.6376156166463941,-0.08245488521063356},
{0.010627614239844815,0.6633649227260747,-0.10242500801564464},
{-0.0018880752346983592,0.6595651016055574,-0.07461260020609206},
{0.018467420642174787,0.6787979393967011,-0.09604630043802911},
{0.004344357633398645,0.6730785400073754,-0.06934804910861997},
{0.02430699505973067,0.6944924981726969,-0.08851508001104538},
{0.008700525806335672,0.685974756886457,-0.06343162562949292},
{0.02837193986581379,0.7104843157119318,-0.07919677499647558},
{0.011689707680533271,0.6988410942158773,-0.05613709932070747},
{0.030998006516009764,0.7267885238809076,-0.06753247298861136},
{0.01369363278260259,0.7122875855719598,-0.04664775836052511},
{0.03260163736090313,0.7435414829802968,-0.052984304914521024},
{0.014994886550689849,0.7267811500393281,-0.034134535095182446},
{0.033574104545619536,0.7728553660445908,-0.02398436160635011},
{0.015966919980019256,0.7564864787509027,-0.004772492789916574},
{0.031863051080874734,0.7916746490567266,-0.011416894131606244},
{0.014934185582527413,0.7766555713484515,0.00943929178502431},
{0.02888114390416818,0.8185173409300176,0.0022465244900367306},
{0.013242527180088498,0.794956330777917,0.019414426385672322},
{0.011276995626277127,0.8131642293755244,0.027601261883650564},
{0.024890470413356083,0.8559410741075972,0.015469160887377017},
{0.008046088071391663,0.8465903365830886,0.03952477611080557},
{-0.025124970968597015,0.7657993928056622,0.034590907727396224},
{-0.03456723087976973,0.7609822046213647,0.03840547653107301},
{-0.024305830116691157,0.7433011329238363,0.04125215117111383},
{-0.011501321519439438,0.7498234631066037,0.036050804430037955},
{-0.016779554501119582,0.772391123850355,0.032040426051643506},
{-0.00018157000501192744,0.7587526771459941,0.03256217181718864},
{-0.00995593782651904,0.780420592893918,0.030887876023242132},
{0.00907726094949017,0.7696336293178884,0.030968442988130705},
{-0.005001212005498955,0.7894785951042239,0.031195235090493555},
{0.015804150172782434,0.7819114845172161,0.031353853239025904},
{-0.0019969478368436246,0.7995515105621203,0.03234515780055061},
{0.019815160594740828,0.795356649821115,0.0331449283761727},
{0.0342076848429528,0.8958968853395084,0.05705648723906213},
{0.012246141484029985,0.8994170209864674,0.05647822934309216},
{0.1469532020879175,0.740911636461728,0.05342704523457092},
{0.15800282314031208,0.7582941109508231,0.052094796545827396},
{0.14933267260407976,0.763365269110734,0.04699259389321616},
{0.13520090970154097,0.7477749107717145,0.04647952323541167},
{0.14161677152630858,0.7701814623717108,0.0433007282920254},
{0.12473995667440517,0.7570089680971116,0.04144300354140826},
{0.1352505065317954,0.7783943603719441,0.04121001493351636},
{0.11610455614117976,0.768140296271412,0.03857650008367452},
{0.1305560339429949,0.7875862566737216,0.04083202809624494},
{0.10973577536542171,0.7806015680343991,0.03803121999013009},
{0.12774054011877628,0.7974068999985194,0.042199039181006384},
{0.10591160197817492,0.7939175857700619,0.039860800212634336},
{0.11296654659718562,0.8980214564042279,0.06359132196998733},
{0.0910620606611742,0.8950533054697959,0.06130855411911124},
{0.06499080894022653,0.7726899069539545,-0.0486802121740501},
{0.06447527207322143,0.7648661742869668,-0.057785369791432},
{0.06530059703764532,0.7500999263972875,-0.04277618170598113},
{0.06590913105963013,0.7592335755470918,-0.03213803340673693},
{0.06545306825269281,0.7812980304698409,-0.040536764607786206},
{0.06645563806126938,0.7692830310350554,-0.022625158118555276},
{0.06585708041318623,0.7906064086825534,-0.03343679617960153},
{0.06693524758921703,0.7801516893399796,-0.014329264123265939},
{0.06619912751838922,0.8005257623404289,-0.027449732537443428},
{0.0673404990508162,0.7917317560516821,-0.007332157686863322},
{0.0664754916649844,0.8109581618700871,-0.022633820833284864},
{0.06767015314496114,0.8039127846556131,-0.0017044913653895151},
{0.06670969478795999,0.8216967183449237,-0.019448816991358493},
{0.06794529038346149,0.8164682309096305,0.002087770018382735},
{0.06698980162389467,0.8442600291417934,-0.016416346329534946},
{0.06825863527505405,0.8412865863916397,0.00557273429995887},
{0.06769946261611347,0.9137375542334428,-0.010165150442696008},
{0.06897760341857746,0.9107629837192828,0.011822418239448733},
{0.14120108514939844,0.4932871303704671,-0.07099173416525303},
{0.11710920797561401,0.504197292869425,-0.060872555597076966},
{0.1299698197339257,0.5426396200188792,-0.07171761760894685},
{0.15414116089461458,0.5318812099403275,-0.08184642554671505},
{0.13641915508156122,0.5653250019746713,-0.07738989877022973},
{0.161262197441598,0.5567626334556111,-0.08795617999834814},
{0.1398668659718967,0.5820754081137823,-0.0805501041970289},
{0.16543861738214855,0.5770388512407456,-0.09162449887852854},
{0.14106408041215138,0.5947782568413246,-0.08168654331105477},
{0.16701747459793684,0.5945638205709866,-0.09300631961150438},
{0.14065259526598997,0.6061860483063086,-0.0812218053963768},
{0.16635448568536276,0.61062636502433,-0.09224291013032669},
{0.13880728831245304,0.619120646340637,-0.07915341185078337},
{0.16409149708013535,0.6262329706008467,-0.08973580399327725},
{0.13581932095333904,0.6345237958546134,-0.07578747004740902},
{0.16089410022715095,0.6429870698572531,-0.08586545424682805},
{0.13168876754671446,0.6479194262933131,-0.0726012145113658},
{0.1559926643536805,0.6598761785761259,-0.08086115638157562},
{0.12538262104884396,0.6625033729903284,-0.06799602117422776},
{0.14888563190919277,0.6766764046196906,-0.07498191193562283},
{0.1076950306274989,0.7014336873432054,-0.046579733122827295},
{0.1316595448266395,0.7148796210137901,-0.05347007376896457},
{0.10153776137146914,0.7248515458245741,-0.028912120235307835},
{0.12601522229830364,0.7360944358844195,-0.03767026115005246},
{0.09910254709156759,0.7444921012865178,-0.013952516587100327},
{0.12396416657518047,0.753351728568817,-0.024225083453142254},
{0.09850768256077976,0.7640643836505423,-0.0019387440604093375},
{0.12361470844936472,0.7705309204975266,-0.013336583937513791},
{0.09914344402805927,0.7834989920547228,0.0075468789964556115},
{0.12433225139661644,0.7880832164171505,-0.004557374903970436},
{0.10107781955207058,0.8095523730537247,0.01790330936832755},
{0.12633120690125152,0.8124897025696552,0.005407510676532556},
{0.10344259195711798,0.8358916856038587,0.025153642199679898},
{0.1287119662905638,0.8384037241593093,0.01262182941775013},
{0.15433325256601477,0.7518856229676352,-0.0012186977249238654},
{0.1365381527737409,0.7430048036364266,-0.008917236194202715},
{0.12445286018023366,0.7576365997491367,-0.0012230104927720856},
{0.1437322213348895,0.7647228367210692,0.005536831746923615},
{0.11533121985814454,0.7738733031868795,0.005577641932337873},
{0.1357660433988004,0.7789011601661533,0.011485377910713208},
{0.11065779060212072,0.7854163024025073,0.00964253716637681},
{0.12996291682676633,0.7939499191359125,0.016722528060735868},
{0.1072683268637582,0.7974027483398152,0.013255099889806922},
{0.10522469455425874,0.8096098642320231,0.015970421005643155},
{0.1269199368915655,0.8101699911528152,0.020549638591603452},
{0.10512976408955384,0.8345029247846902,0.019989139880479696},
{0.12686509781763353,0.8321731750288931,0.023997894774425543},
{0.11132702559226805,0.9035352929191334,0.027716516886490697},
{0.1330556918803985,0.9012004496357912,0.03175787779253036},
{0.006158657273268282,0.759293136358237,-0.009627987771394628},
{-0.0051239028149738745,0.7449814889001903,-0.01898655767889213},
{-0.023574617678242368,0.7543692939207739,-0.013865765509693775},
{-0.013686977735664385,0.7669152843073539,-0.005656511054711484},
{0.014670202053979252,0.7752787202129097,-0.0015780950456081636},
{-0.004045921534109008,0.7858603192026958,0.003594822128100474},
{0.01904120466115277,0.7866951991786457,0.003130022248367217},
{0.02221633127326585,0.7985899244411127,0.007209801488686908},
{0.0003587404910982492,0.8012891718216065,0.00909353916951496},
{0.024165739519690685,0.8108465999845421,0.010620358131870325},
{0.0020665345939347253,0.8120190284026807,0.012085212038935294},
{0.02435933074542889,0.8357806814038115,0.015121028813744513},
{0.0022264168295949983,0.834011628647315,0.01589482363818887},
{-0.0030301531687556334,0.903125518008498,0.02183172037158387},
{0.019103182109454227,0.9048228895890348,0.021160626429777816},
{-0.0032277721230877603,0.7787982857813599,0.03723309768497872},
{0.006696563525233186,0.7627221338018749,0.035682732001613},
{0.020046290250974017,0.7719325452621729,0.037980396251780894},
{0.011177863930823574,0.786297333951637,0.03936593488807417},
{-0.011098585839084955,0.7959428764231953,0.039087092139267386},
{0.0041460818494804255,0.8016163225275178,0.04102164116543355},
{-0.016795628236461923,0.8138953054908518,0.041216223832056455},
{-0.0009449670931785664,0.8176578732201286,0.04292522005696559},
{-0.020233461896984144,0.83238572756155,0.043590724750784446},
{-0.00401721932049849,0.8341789838686431,0.04504690355010876},
{-0.02135998660216361,0.8511314456600452,0.04617218895418237},
{-0.005022304910319738,0.8509294891518425,0.047353242908017325},
{0.10432371025732538,0.7707565228708279,0.04397119019026749},
{0.11760285878509051,0.761174321078787,0.043565926335657236},
{0.1276510997579701,0.7769704281873927,0.04653653108627884},
{0.11330248394793697,0.7848709355578855,0.04662452146479121},
{0.13565451869228873,0.7938929980361228,0.04951828954685271},
{0.12045201202734286,0.7999915492057594,0.04929025814338405},
{0.1414891359054214,0.8116856440122072,0.052469077872792445},
{0.1256669910805826,0.8158907165943242,0.05192626398844857},
{0.14506945201407842,0.8300781117235028,0.05534177783605523},
{0.1288656024486508,0.8323237005412045,0.05449285657857679},
{0.14633852113244783,0.8487890302469466,0.05809302629094882},
{0.12999956296046503,0.8490431861177258,0.05695162997249972},
{0.11177193468925307,0.47280005789519036,-0.0894718576437623},
{0.1272408910919477,0.47571242788685003,-0.1158218653624394},
{0.11777536949901896,0.5068955983810784,-0.11760256754933056},
{0.10139371740394108,0.5066519393906656,-0.09145938679220175},
{0.11419248803707295,0.5461563599808084,-0.11550091116205724},
{0.09812819616917036,0.5448560976536057,-0.08934451945514052},
{0.11828197100505111,0.5672521399802247,-0.11315488938274075},
{0.10214133818903072,0.5674652625913904,-0.08701801666824047},
{0.12123399863209662,0.584535433201822,-0.10977406357308564},
{0.10395567500793353,0.5800045483589883,-0.08477612096783393},
{0.1220470049435288,0.603346871437958,-0.10456899892869237},
{0.10444767754693932,0.5957373891461425,-0.08055506140145213},
{0.12130089610578812,0.6233589941574448,-0.09784331182747275},
{0.10366814475837503,0.6136429230599548,-0.07462004840573797},
{0.1184490040080919,0.6530469354745051,-0.08626911940301181},
{0.10090687035753547,0.6413119933036099,-0.06390586898365244},
{0.11227253797793312,0.6953532919347689,-0.06651244142745402},
{0.0949770996054989,0.681613296897798,-0.04511189250009732},
{0.10721943643513406,0.7271215364810494,-0.048737195238895144},
{0.09010208563160434,0.711992966520076,-0.028143815514762215},
{0.10408332302183176,0.7589894332292477,-0.028204491696902555},
{0.08670212501287561,0.7449120880382649,-0.0070731685417715715},
{0.10389124374344261,0.7782419511219519,-0.017265168442924927},
{0.0861679490572392,0.7662231718187934,0.004839006080265281},
{0.10462116730874135,0.7974623091509601,-0.00799519617148163},
{0.08672192904454644,0.7871375057433084,0.014819097885336526},
{0.10626159300346616,0.8212065623645655,0.001485903436347115},
{0.08831227458158544,0.812731378678299,0.025020442116827666},
{0.10794871556385773,0.8494149640564568,0.010966123140390735},
{0.08989705565665952,0.842310013637827,0.03488339518137794},
{-0.005719994253856437,0.7800970361612137,0.03145547592970216},
{0.0018954862553111358,0.7627790549016648,0.032641487087960344},
{0.014838734611358062,0.7700488943324226,0.039564223065003436},
{0.008034971540472542,0.7855240844196791,0.038504620619537654},
{-0.011373685898552238,0.7981895930049038,0.03127331106015945},
{0.0029823533251046655,0.8016895032578158,0.03834227217467682},
{-0.014981279024548091,0.8167804356442057,0.03209992489773334},
{-0.00024104406507963064,0.8183010085289877,0.0390809080267494},
{-0.016487054654126834,0.8355879948678805,0.033921697523271},
{-0.0015856981578922518,0.8351059687027765,0.040708110378675215},
{-0.01586864340232867,0.8543274668888022,0.03671012501133883},
{-0.0010342339518298739,0.8518502279084026,0.043200344902454946},
{0.10920038489470167,0.7687314181128602,0.04627257234375281},
{0.1227855912235571,0.7610911267955542,0.04123480095563251},
{0.1309699357263127,0.7781886239953688,0.04117159659923632},
{0.11651348832706314,0.7840095717173043,0.04621555209987458},
{0.1370933596691428,0.79611627943392,0.04182718688420871},
{0.12198502749522734,0.8000274889378276,0.046801741522921735},
{0.14106280393201245,0.8146017938722396,0.0431929090958201},
{0.12553064317292165,0.8165450056131356,0.04802122620404779},
{0.14281766669084756,0.833363573313066,0.045246431028143845},
{0.12709962315889659,0.8333102461864829,0.04985663114174934},
{0.14233187305038186,0.8521178054101576,0.04795679493955683},
{0.12666459129172483,0.8500681253112619,0.05227823789550908},
{-0.0037631625938078853,0.7770757563883753,0.04464163969549852},
{0.006302465773586214,0.7614048434774786,0.04111954595279238},
{0.019570411019354854,0.7703722651699608,0.044568520930255845},
{0.010574336685306182,0.7843764296306458,0.04771510643790218},
{-0.011786397952808381,0.7937876698351402,0.04859996742744904},
{0.0034062190893130993,0.7993087066894702,0.051253311094983815},
{-0.01764209567775089,0.8112866386281813,0.052937533690787845},
{-0.0018261473584410995,0.8149450059204821,0.05512861804585626},
{-0.021244731599323434,0.8293073284007455,0.057587391439779194},
{-0.005044575151191149,0.8310461298172491,0.05928275535252443},
{-0.022536058565553227,0.8475757544643605,0.06247891290440309},
{-0.006199603781804176,0.847368877930768,0.063653770352709},
{0.10381932710027257,0.7691962427786156,0.05055806317462556},
{0.11718645361353905,0.759856857252236,0.04900274028683661},
{0.12708596606071063,0.7752490265584148,0.053942594494587014},
{0.11266421909242379,0.7829500312368941,0.054972453713513406},
{0.13492827585127426,0.7917391298932617,0.05902992553392856},
{0.11967249163178968,0.7976852594198952,0.05951822256262794},
{0.14059685150225076,0.8090781049135429,0.06418666982820641},
{0.12473750285821569,0.8131765232424943,0.06412594407402182},
{0.14400367784910567,0.8269997125626979,0.06933472662173254},
{0.12778125116010206,0.8291908464898106,0.06872499047767504},
{0.14509795593951197,0.8452348509986111,0.07439603233785212},
{0.12875904733957347,0.8454852270010172,0.07324720021276818},
{-0.031620160457147446,0.767492240937163,0.03190534223111043},
{-0.04181216035830075,0.7645896986032724,0.028732731400242136},
{-0.034900590484221006,0.7467189642645109,0.023127372498672888},
{-0.020310286172533207,0.7508669298516721,0.02765453943818924},
{-0.02265260244154336,0.7724493710023282,0.03514735392390398},
{-0.007471126716363053,0.7579520266665869,0.03227961116506443},
{-0.015369229842710188,0.7792097709275215,0.03829393943155031},
{0.002955125879810123,0.7676174227418605,0.03676835977030075},
{-0.010146790196813457,0.7874325089785351,0.041183989610294396},
{0.010433031573221913,0.7793708924642877,0.04089028764122897},
{-0.007101951309953917,0.797050439821456,0.04303886396836818},
{0.014726788542470403,0.7929387981497058,0.043862676985442946},
{0.02847679713237625,0.8949044777999994,0.06293172874244318},
{0.006494545051975453,0.8982731460658068,0.06234384147688108},
{0.16009722961611642,0.7439975953592782,0.036988955367134556},
{0.16663951254668752,0.7616797948208132,0.04355105472238754},
{0.15618602011220867,0.7648710943123571,0.04525633304397925},
{0.1451326563704746,0.7485581738566072,0.03941550693230648},
{0.1469916328152086,0.7700810418031071,0.047206992984520926},
{0.13197127862679445,0.7560063487164908,0.04219278071042205},
{0.1395273346479385,0.7770472028908978,0.04930512975665375},
{0.12128728857964637,0.7659654219748077,0.04518074806953602},
{0.1341784862892494,0.7854187562186965,0.051444163465278234},
{0.11363091113398709,0.7779308741513831,0.04822695018761191},
{0.1312058366918032,0.7948279267903441,0.053524627803642234},
{0.10934612670474463,0.7914567923153365,0.051217309397860095},
{0.1177951239586455,0.8967071899745298,0.07032330472082447},
{0.09587160235764895,0.8939220962064367,0.06793932314863706},
{-0.006721014936050682,0.7971973837535714,0.057551922642130965},
{0.012704670500167879,0.7604294515421524,0.06585971392803605},
{0.010869711710864453,0.7630468182985854,0.08194933711054134},
{-0.007923372475894514,0.8044899147875768,0.07279233952790348},
{-0.013519659693369282,0.8465250997728787,0.06440492314595024},
{-0.01189669575122534,0.8434936081589289,0.04838062352473209},
{0.10620249073373014,0.7621707067748456,0.08863930755389159},
{0.10732533471462531,0.7591095215064005,0.07258664033036148},
{0.1287467534726038,0.7953091969817737,0.0671808089068273},
{0.1293221485830194,0.803168101014144,0.08243731192095322},
{0.13645012521619534,0.8414214223519514,0.05892583663405175},
{0.13532733080734438,0.8444837477774141,0.07497850385758185},
{-0.056067853371420444,0.507119961453274,-0.09751368251934996},
{-0.05571466494927624,0.5250712627569238,-0.10291702294766145},
{-0.028588854738363326,0.526715790538309,-0.09495080783253913},
{-0.027391640298108644,0.5459162949636023,-0.09970722069060783},
{-0.05426837577277627,0.5473241658058221,-0.10851989085400804},
{-0.024531382917948204,0.5638229690344321,-0.10204082467284419},
{-0.05078223415514962,0.5688099662562475,-0.11142358573792706},
{-0.02026073891432297,0.5805287355477119,-0.102319679814662},
{-0.0456056734361899,0.5888395011562708,-0.11183502131204423},
{-0.014800353456111142,0.596238128757944,-0.10090809106912467},
{-0.03910306053401571,0.6074042441142846,-0.1102189726700707},
{-0.008379534426920304,0.6110701835363419,-0.0981494192006073},
{-0.03165113059178159,0.6245178150494418,-0.10706741756499007},
{0.0007120404503420006,0.6287675148643787,-0.09334782142422082},
{-0.021541482249109112,0.6441044733062936,-0.10180787324398548},
{0.014600801192053993,0.6522198011304667,-0.08482815922126681},
{-0.0030049581772745916,0.6756938247379508,-0.09064972659375532},
{0.024399322992113344,0.672728511803051,-0.07618928864494515},
{0.0061364366044411554,0.6992410414687437,-0.08050862478901749},
{0.03215180823852797,0.7015376894920047,-0.06032446229002235},
{0.012176418403817236,0.7359567743175862,-0.05467591374491568},
{0.0362504620346892,0.7430829043921147,-0.0242561651248759},
{0.013396212910219791,0.7567945318267734,-0.03371441202031355},
{0.03614607570254699,0.7608445306615205,-0.007216915077034238},
{0.013168156720728994,0.7708419974680951,-0.020414232552782862},
{0.03512365229025541,0.7788937863245736,0.0051934461965263586},
{0.012039178199360057,0.7864894628020704,-0.00934850058601281},
{0.032628592159954464,0.8050073106062403,0.019010463797223175},
{0.00947238732105492,0.8103887773700345,0.003591476015114787},
{0.02963973250404427,0.8324192010844179,0.02921978912783571},
{0.006505711154938769,0.8364928457842641,0.01340382841551494},
{-0.028942043160507573,0.5087645883787475,-0.0895474426182055},
{-0.029556724115977255,0.47568142057318263,-0.1009787684111889},
{-0.016177216984663755,0.4895293835224915,-0.10290215133439175},
{0.0021272355620972506,0.4731359084948642,-0.11698309049858141},
{0.014872208134225956,0.49122221926098103,-0.11784937436455223},
{-0.005934393345161281,0.5040415622924691,-0.10354165549101074},
{0.024331818260879937,0.5096085524318027,-0.11748006263502145},
{0.0017728078388472436,0.5190395594889347,-0.10319217257917292},
{0.031114488426944677,0.5277518834417975,-0.11625809935168378},
{0.00747853773697583,0.5343536280394254,-0.10212633644914491},
{0.037782473668677874,0.5532485455980485,-0.11377974500028909},
{0.011672357465052,0.5497903378273469,-0.1006044746912128},
{0.016210244359133628,0.5728725563902295,-0.09791117595602676},
{0.04206621708499145,0.5781926653562749,-0.10999591086403634},
{0.04555751419521823,0.603893936125095,-0.103038338132909},
{0.020286541163345998,0.6031212690646567,-0.09025818180238637},
{0.04984423193418572,0.6450518694296395,-0.0873302833678709},
{0.024315880848659332,0.6422762315289835,-0.0753748075651971},
{0.05322660687022313,0.6868782817506571,-0.06742452986229548},
{0.027568959500327728,0.6827936816290359,-0.056145315887038964},
{0.05546964272764697,0.7233496987795008,-0.04659951236847598},
{0.029717920010809713,0.718232401439421,-0.03597738823252988},
{0.056614286014993305,0.7586431972863074,-0.023294293964614153},
{0.030933141496131758,0.7566086366609023,-0.010658181601619575},
{0.0552570530159567,0.8053006036059411,-0.00022920254301363728},
{0.02968724730844092,0.7995394149833275,0.010490466982970601},
{0.054160531790548916,0.8277742757538279,0.0066322871733804165},
{0.028684243744477454,0.8224824352460057,0.017812022448873737},
{-0.01437403387571324,0.4559814901952599,-0.11452804740098697},
{0.14015194240526574,0.7487590026008032,0.007916190725986372},
{0.14225377229469388,0.7585804142922867,-0.011514811311976132},
{0.13254151824460977,0.7722638600197997,-0.004908035151858789},
{0.12947475612118856,0.7637911301497226,0.015170985041319635},
{0.12355026479186268,0.7924673556160455,0.002605165837046501},
{0.11964303344450468,0.785865040939909,0.02336939561162611},
{0.11924649426967927,0.8131990289505756,0.008171895723147722},
{0.11483761862071233,0.8086813798435519,0.029471020248005096},
{0.12010997731515098,0.8415405563672528,0.012211521607639239},
{0.11571764633594647,0.8379701174884092,0.03368727132609637},
{0.12658039317459627,0.9112485914645823,0.020086995095794296},
{0.12224901102377542,0.9083275339721711,0.04169088854859196},
{-0.000917925543049778,0.7741352170825808,-0.014391501824799617},
{-0.009978245246423531,0.7607046011736637,-0.02233638856789097},
{-0.010920126479848677,0.7508682435108441,-0.0028223533558393295},
{-0.0009704595169249554,0.7655976221926257,0.005891073575007747},
{0.0074753279471117895,0.7940925007281358,-0.005644576585062548},
{0.008217607344435503,0.7874145515055119,0.015447683799213368},
{0.011791305585187407,0.8173908657968826,0.0012891024207448256},
{0.0129070111917131,0.8128089093554784,0.023003157348837754},
{0.01022370122343997,0.8520684440471132,0.006279891903943932},
{0.011346210593036542,0.8488359377938013,0.028253035121217067},
{0.007152626332170497,0.8898408793768342,0.009097269465843447},
{0.008302697758360216,0.8868443732331012,0.031089906889510934},
{0.005302349781199213,0.912942765648266,0.011465573879042392},
{0.006451144727250003,0.9099449210593389,0.03345821130270989},
{0.13974793024477233,0.45913174403417933,-0.09273989465977779},
{0.11810228473772001,0.4457807408282996,-0.10520726378420556},
{0.10885338058507547,0.46727525356549854,-0.10922878347954122},
{0.13150036899260953,0.47770641379405065,-0.09579477188559435},
{0.10163321234263849,0.4889703967587169,-0.11117078070535333},
{0.12512416480322774,0.49634055761398976,-0.0971716230211359},
{0.09667972582272416,0.5104834370474478,-0.1114892686965349},
{0.12081263625612193,0.5146003829279306,-0.09725095068491867},
{0.09424820466011792,0.5314660440698818,-0.11062174552945828},
{0.1187405495932332,0.5320287115579407,-0.09641563695358199},
{0.09464479340698753,0.5515873740028125,-0.10899702177974407},
{0.11929120825357681,0.5489852382569698,-0.09531553414797843},
{0.1004708470494791,0.5826580283496448,-0.10524071252105131},
{0.12502257929158464,0.583570067212442,-0.08931069892796302},
{0.10183002575125176,0.6120208018425629,-0.09760319723822246},
{0.12422749327414254,0.6196733994198494,-0.07775624857011762},
{0.11575254505508606,0.6852393308242483,-0.049131652387862754},
{0.09149467589118966,0.6934146036429094,-0.06204135286297547},
{0.08635540574250372,0.7264617573583394,-0.043186861306423754},
{0.1101503835503698,0.7208641316956704,-0.02887481727202302},
{0.08337874080947472,0.7576432176170419,-0.023129566061630163},
{0.10696972965532477,0.7525480418017005,-0.008111913549626601},
{0.0843335603464444,0.8022301483652244,-0.0010148822650626914},
{0.10786144397998676,0.7954727599417184,0.013222221231469843},
{0.08641212855411652,0.8314128018354248,0.009744172250064125},
{0.10980517622734697,0.824671115356929,0.024210534058160073},
{-0.00869561817395656,0.8132848753381748,0.03343527183924138},
{0.00950231644276017,0.775197025484015,0.02936849286752161},
{0.007530972566762616,0.7724928580781311,0.04542808778423317},
{-0.009881852406413856,0.8152524889178441,0.05021626392964374},
{-0.014098078698482995,0.8578893917690488,0.055965009969154975},
{-0.012351482078023633,0.8601869940541614,0.039830685195763195},
{0.1319709935875401,0.7986914727737227,0.05616728869564494},
{0.12173219767663139,0.7720887467735491,0.05553261781333859},
{0.11763846390586029,0.774025154751374,0.039780419142911624},
{0.13057400380902917,0.8152297973145967,0.041623173136170616},
{0.13632002338610757,0.8235582477499357,0.05829503237119552},
{0.1324484343385526,0.8434849082651659,0.04494032365500929},
{0.1371652143472575,0.8408215882237295,0.05847349173043187},
{0.13117071489846457,0.8606194605680442,0.04572604055609151},
{0.13574869318331906,0.8584865861859157,0.061309012660520405},
{0.007552524012992623,0.7755612312929896,0.03195555871191777},
{0.0012200547596347333,0.7737704288020862,0.046965329268888384},
{-0.008262098254133952,0.8006515266166462,0.046198734783868774},
{-0.004362005281145351,0.817112692270673,0.03202978045514461},
{-0.013024596080632125,0.8433156569131458,0.0497186721426508},
{-0.0059021963024323155,0.8454158261390922,0.03510523007931756},
{-0.004216722012511445,0.862298701173403,0.035277492933024866},
{-0.011010558281539497,0.8603233295688116,0.05005244071646699},
{0.11462232723261136,0.7724705506582266,0.05721930661834318},
{0.1157885219661877,0.7747694666025111,0.041042721677243356},
{0.12766806579010864,0.7967976100028601,0.045030730670677976},
{0.12768527968246826,0.797414273840099,0.061707175319794375},
{0.1387478638244296,0.8409097025323526,0.05211267966078421},
{0.13724780137294856,0.838756776258332,0.06828197751138187},
{0.13843428346562703,0.858610627833596,0.05260911889774875},
{0.13726808873205068,0.8563103858371279,0.06878571623185963},
{0.0539295012784042,0.8114755452957395,-0.016111019716097068},
{0.07613598010787884,0.8150083589930109,-0.014636697548583722},
{0.07475103633611632,0.7575288177319648,-0.005651752138465177},
{0.05262724367642122,0.7578016870494416,-0.006680991706838662},
{0.054424614463185465,0.8653899518866751,-0.009908590327771652},
{0.07658079006077538,0.8597828827495798,-0.00922323203023776},
{0.07620934673334262,0.9069599404158899,0.0119457039134545},
{0.053937494770536644,0.9070089175955914,0.01094382811349726},
{0.11317852905133408,0.7551760045825884,0.015599857581995528},
{0.0967106959573583,0.7541052979992144,0.0013578092740508224},
{0.0963079478839928,0.7775727161318047,-0.0035646947182182876},
{0.11282164751189451,0.7776073174186788,0.01085705225006859},
{0.0961207886309937,0.8009470875373704,-0.006328323791158906},
{0.11267167968508077,0.7999482480251223,0.008177683259311841},
{0.0961703730682371,0.8240204079183137,-0.007204509672965095},
{0.11274850396062974,0.8219955014485228,0.007292834662776044},
{0.0964677929406199,0.846622868237116,-0.006335759597793736},
{0.1130632740484939,0.8435853164407585,0.008057483445059537},
{0.09701680333049281,0.8686005349034253,-0.003832358971050673},
{0.11362098433212962,0.864570377279382,0.010363822802968088},
{0.09776781980061243,0.8900256343856879,0.0010393336758802983},
{0.11436825811290964,0.8850263432969032,0.014945531384151056},
{0.09873573875027056,0.9106933845691806,0.007917454813114297},
{0.11532502335261548,0.9047572809884931,0.021443187081902026},
{0.034890626503330364,0.7784303001040126,-0.007930752513979613},
{0.033144463638258084,0.7549925756259176,-0.003160682557724898},
{0.014863557812507418,0.7565479356927399,0.008610199345238812},
{0.01650931250198713,0.7789520334765465,0.004009913640479772},
{0.03611629529697441,0.8017848055128525,-0.010593998197349783},
{0.017658157020082204,0.801275564295465,0.0014247439267754975},
{0.03681403421255531,0.8249176990979515,-0.011156640899386592},
{0.018301341900985445,0.8233835186870276,0.000845990310363201},
{0.03700120585856552,0.8476143339077845,-0.00993221140684835},
{0.01842932452618219,0.8556776606575578,0.002867451523079677},
{0.03670000611780995,0.8696540152014283,-0.007296205561783839},
{0.03591924642115093,0.8908894520424583,-0.003357706647526242},
{0.017385523169815505,0.8863808746195291,0.00805129933254155},
{0.03456224888932445,0.9115895479848122,0.0033555874426353114},
{0.016068133701330593,0.9061439597818038,0.014386606585431685},
{0.005520194129578135,0.8156766521143178,0.06332898671190992},
{0.016955411328033805,0.775432827305417,0.07419564974205403},
{0.00648661352489823,0.7758278669259044,0.08679198053955217},
{-0.005192448559136171,0.8193355894851273,0.07559265191357603},
{0.0034204586590188086,0.8619051735002646,0.05968453677102736},
{-0.006555171662071466,0.8624403285037747,0.07267122263083288},
{0.12639498133615634,0.8182075900116321,0.0842045305118132},
{0.11027112865710867,0.7747792942602804,0.09460902098056838},
{0.10235747230188363,0.7742405452835635,0.08026605638357771},
{0.11632891921337524,0.8141343294951289,0.07120499309954047},
{0.1202058992207405,0.8602752942579502,0.06798688752507796},
{0.1277824780681968,0.8605574459407097,0.08253452269969279},
{0.13483779447753916,0.7730455987643325,-0.048512906524766024},
{0.1292597002002977,0.7915284734912964,-0.052364641968606004},
{0.12597059506548347,0.7928990785492649,-0.042104468113622166},
{0.13010494073349194,0.7750321240788762,-0.03367971158935094},
{0.12264806597984561,0.7963791351984618,-0.03267586530063545},
{0.12532244058714598,0.7800662147427122,-0.020049878027675345},
{0.11945931944857965,0.8017899114334082,-0.02456092165980514},
{0.1207333085923392,0.7878899474096999,-0.00831988066819225},
{0.11656431206541239,0.8088551546446081,-0.01817480306157689},
{0.11656804236174088,0.7981054444598191,0.0009091946667594121},
{0.11410801727370108,0.8172166944194722,-0.013847163600095608},
{0.11303972732748356,0.8101911708087135,0.007166425949983632},
{0.11156312484593549,0.8299587918130353,-0.011589826207910683},
{0.11003810287018362,0.8250262494818092,0.010065262773567896},
{0.09581864702139772,0.9179755302599187,-0.0024109177817221586},
{0.09406605218358632,0.9142439698443091,0.01942064767722348},
{0.011413343533938174,0.794499078241918,-0.05024792807289713},
{0.009571717304685428,0.7931990018098812,-0.06087244405997744},
{0.002993507035056955,0.774885948513446,-0.05788574078799138},
{0.0056356969926394645,0.7767695994431968,-0.04252832148481953},
{0.013464386864050227,0.7979034879516168,-0.04043636882520471},
{0.00858030120606125,0.7816959080898606,-0.02834823823216522},
{0.015623224604345572,0.8032386296400758,-0.031942199045997155},
{0.011679780878675805,0.7894129741106715,-0.0160717214780319},
{0.017782111916685113,0.8102356121463675,-0.025197922428190408},
{0.01477926055129036,0.7995269352211921,-0.006325845188947274},
{0.01983189115966926,0.8185339847438685,-0.020548064679199066},
{0.01772136137647839,0.8115220686592518,0.0003899275034258896},
{0.022556618570898624,0.8320856307987787,-0.017680991142956654},
{0.0209531736211711,0.8277056308655771,0.004090455819346227},
{0.03049981986448602,0.8731711393467003,-0.013306815924952285},
{0.02904362867215068,0.8694346589057004,0.00854700738185366},
{0.0346675894833181,0.8964997433624287,-0.007825387133963824},
{0.03321017138288794,0.8927632753144398,0.014028448565853191},
{0.03913895069403991,0.9186621650375917,-0.0068525357659046},
{0.0376827718947156,0.9149256845965917,0.0150000606328066},
{-0.0014267577910723921,0.7823157817169635,0.027779622098798442},
{0.013831195205347258,0.7562071774606868,0.020662402599220916},
{0.012029239004491475,0.7494108378034252,0.041746632312331194},
{-0.004850500598021666,0.7790123502613664,0.049851562400226576},
{-0.01350486243816587,0.8220858960711804,0.039600286727182445},
{-0.016027162406772558,0.8189912372798676,0.061820558977964735},
{-0.014464651572569901,0.8635201067712431,0.05298405705429987},
{-0.01605585222737196,0.8604744251596317,0.07531022758457345},
{-0.00679448070560303,0.8965865440118793,0.06448163588439976},
{-0.008926078607592631,0.8897504971471876,0.08552125075770095},
{0.11109901897482154,0.7480277405903104,0.048789580496637654},
{0.1124857473401764,0.7548290002729622,0.02767560755698798},
{0.12730495056610683,0.7805206292791788,0.03693200948132269},
{0.12747485874771314,0.7771582070909447,0.05925623430886016},
{0.1386897529955782,0.8199658608485081,0.050420042210471736},
{0.13795622306406158,0.8168367866654868,0.07276599198639401},
{0.13889597269958467,0.8613766363646599,0.06388566837562779},
{0.1372294597165826,0.8583305705697056,0.08620522103799635},
{0.13059938469567606,0.8946680935070778,0.07424856789927203},
{0.12954226085242196,0.887817113064061,0.09536501944113332},
{0.06512961066407695,0.7865787172677108,-0.023495135101821368},
{0.06363130802016621,0.7880472766850819,-0.001734234591928902},
{0.0630339277081337,0.7668453133669202,0.0032006500183872095},
{0.06445914876583489,0.7633404954816287,-0.01801370631083291},
{0.06563276691303503,0.8099753960931811,-0.025749423813285998},
{0.0640749406370123,0.8093880541201056,-0.0037245521678564413},
{0.06597725544141646,0.8331504630949111,-0.02503061677890635},
{0.06437607841271256,0.8305156965509524,-0.00302806494639238},
{0.06617185050105039,0.8557565049939092,-0.021534548359422166},
{0.06454338406199664,0.8511078121879575,0.00016065679885140686},
{0.0661953848290497,0.8775520687557313,-0.01508645231289246},
{0.06455582664509897,0.8709503117650924,0.00601883312600549},
{0.06601942885804708,0.8983648667406474,-0.0053492759175706355},
{0.06438477830647538,0.889894206503417,0.014891002135495502},
{0.06568481755947893,0.9177637337009362,0.006947082047266683},
{0.06407124751971699,0.9075357568886814,0.02606082300214236},
{0.11963656429273231,0.7791986172175692,-0.04445543470435086},
{0.11300289529861894,0.7855142567619102,-0.025279220580731412},
{0.13425734301861195,0.7910152417243481,-0.021896151636074827},
{0.12872804002590615,0.8022708098345058,-0.008588809008152561},
{0.10735010834373039,0.7971251448921142,-0.011690779675989795},
{0.1242695675466847,0.8164364552292775,-0.0002961867677825736},
{0.10247996482318168,0.8127417764145766,-0.002722193040467934},
{0.10465927581774498,0.9251304121201019,0.011497299987351073},
{0.08285875485149981,0.921472416618133,0.009181356045872512},
{0.1402287666808148,0.7854422037956184,-0.039211939332666465},
{0.0003052274693494898,0.792887354760804,-0.031411790565722436},
{0.021665945259165532,0.7868007256678051,-0.031752040684322},
{0.017634610299071863,0.7806225617951316,-0.051706585474433055},
{-0.003312056991293794,0.7874461288976877,-0.04941510533678314},
{0.004205555909548128,0.804009412962833,-0.017439897505832785},
{0.025655391841882893,0.7982652399444021,-0.01749814465780575},
{0.007801103028795563,0.8180158453445413,-0.00837915644008304},
{0.029580208871932284,0.813613736279612,-0.007657709694347997},
{0.02863417597980277,0.9262181219146476,0.005865866190515613},
{0.05044000115478079,0.9219695622567277,0.006513004441946406},
{0.09848537514087527,0.7624793175362138,0.014952942404763789},
{0.11338673163710976,0.7617132683436811,-0.0011022034209779276},
{0.11304720031315155,0.7850976656951929,-0.00522410650588404},
{0.09819042147769295,0.7849142367385222,0.011020639996035229},
{0.11293945547501263,0.8173693019576413,-0.007883832574113727},
{0.09811302712363526,0.815754368686663,0.008477185157552447},
{0.11346359309169199,0.8533163335095845,-0.006572466109003071},
{0.09868988460935563,0.850302229290149,0.009720637922064835},
{0.11407207754163261,0.8750139429120035,-0.0032238621280989894},
{0.09930579247292014,0.87108041359518,0.012911825876509183},
{0.11488380737292576,0.8960795583225044,0.002362907256883163},
{0.10012001329943594,0.8912500762712373,0.018255704637764034},
{0.11588642675354652,0.9164475835335572,0.010330374066122333},
{0.10111270587819914,0.910749177904964,0.025895995955069903},
{0.01876984729102509,0.786413815862572,-0.011926246886093304},
{0.01720086730505007,0.7630555181923484,-0.007939427621720271},
{0.02969797965601724,0.7634397758932151,0.010062660241245698},
{0.031169054854633352,0.7858499090734072,0.0062555272442037435},
{0.01981454094418799,0.8096308579927557,-0.013811223868027172},
{0.03213692423224728,0.8081189850017364,0.004464749539322349},
{0.02047317990988065,0.8420594517402548,-0.013561529481228983},
{0.032736039565827955,0.8391750775605752,0.0047035008973562555},
{0.01997069288351978,0.8763276268701818,-0.00991360949725018},
{0.032190201786785916,0.8720174243752594,0.008140516619148662},
{0.018961926569414242,0.8974193543549824,-0.004455727427272061},
{0.031190085794398914,0.892212988444428,0.013355508065399481},
{0.017410296798920578,0.9178219808529093,0.0033308014205191447},
{0.02966823642947783,0.9117455512080116,0.02081734002346902},
{0.17267863922830062,0.7604071441222477,0.04223987415244275},
{0.17922090976586064,0.7780895294789485,0.04880197350769573},
{0.16876860706044344,0.7812806306823156,0.05050725182928744},
{0.15771529289075356,0.7649677226195767,0.04466642571761467},
{0.15957304242739284,0.7864907764612424,0.05245791176982912},
{0.1445539151470734,0.7724158974794603,0.0474437118887413},
{0.15210869468807853,0.7934567392608564,0.054554809240856136},
{0.1338699127069143,0.7823749707377772,0.05043041516072734},
{0.14676112280952835,0.8018283049816664,0.056695094643597475},
{0.126212258781116,0.7943404229143526,0.05347785657990905},
{0.14379362870468232,0.8112580851307033,0.05827293563247896},
{0.12194725359752223,0.8078323098699408,0.05598074909319874},
{0.13039028981310416,0.9132629143029295,0.07484013588911839},
{0.1084505457606326,0.9104214571205442,0.07275643697486824},
{0.002515124415204038,0.7904316796196457,0.07789952417096008},
{0.013810164265581697,0.7762491921228459,0.08550511505730334},
{0.013030631477017494,0.7847519874377499,0.10318498463275924},
{0.0025994216764210986,0.7978488347728506,0.09616063835805096},
{-0.0059889473798389325,0.8069106168515292,0.07157786162324489},
{-0.005254041824094826,0.8130674151731386,0.09032353014969562},
{-0.011398509099701595,0.8251022682116396,0.06676565542939271},
{-0.010249664581606522,0.8298663151645199,0.08587939638426839},
{-0.013522646409034222,0.8443560997635158,0.06363518083612188},
{-0.012210226537983648,0.8476478074306524,0.08298810690441849},
{-0.012284584604332125,0.8639904091478862,0.06229673564184932},
{-0.011066339224311883,0.8657787454295892,0.08175252370192798},
{0.10239907564000562,0.7835039120801128,0.10953764210113068},
{0.10389247065153734,0.7749912767144287,0.09190982317211871},
{0.11653953843630722,0.7888392396637376,0.08600455340294393},
{0.1140795009552564,0.796292334549011,0.10408596892969264},
{0.12630643327214636,0.8050640334178534,0.08098167841411545},
{0.1230991715823597,0.811275484918229,0.09944726489065357},
{0.132846262386528,0.8230871893996179,0.0770196327788475},
{0.12913824869192853,0.8279193235552518,0.09578760872520277},
{0.13592592563446068,0.8422702940373857,0.07425846991510744},
{0.1319812054286519,0.845633856382637,0.09323836635055587},
{0.13543516239656075,0.8619269232346717,0.0727973339113599},
{0.13152764600994835,0.8637871141944895,0.09188876744633102},
{-0.044357697222641324,0.7842561554583272,0.03535679581078552},
{-0.0545484702156999,0.7813524977534414,0.03218418497991722},
{-0.047638127249714876,0.7634817510216689,0.026577586777242153},
{-0.03304660842294337,0.7676297166088301,0.031105993017864323},
{-0.035390102028004064,0.7892121577594862,0.038597568202473245},
{-0.02020868826787907,0.7747161394759283,0.03573106474473951},
{-0.028106729429170897,0.7959725576846796,0.04174415371011957},
{-0.009782435671705895,0.7843802094990184,0.04021857404887002},
{-0.022884339355318358,0.804195295735693,0.04463545558298053},
{-0.0023044804062498214,0.7961336792214456,0.044341728827892994},
{-0.019839128678127135,0.8138156927878145,0.04649031754804326},
{0.0019895616022529896,0.8097038528278877,0.047312841691967984},
{0.01573971890829151,0.9116674504523234,0.0663819306280014},
{-0.006243004106529538,0.9150359328229647,0.06579405575545035},
{-0.02504214847569584,0.785386608748012,0.034134609453248796},
{-0.03232532278635214,0.768979340299077,0.03817248792318113},
{-0.03127438305561597,0.7723899836933378,0.059603721945917634},
{-0.02535662113129465,0.7857744604220857,0.056276062153701706},
{-0.015576007232214185,0.8131689635057486,0.05277151691465381},
{-0.014846219990037088,0.8146377212112969,0.030673489324948414},
{-0.008944668124179751,0.838221621254822,0.03330700417479027},
{-0.010392196601785525,0.8340611759055252,0.0550889604104704},
{-0.0027171924605059656,0.8699910059581197,0.03904698835548344},
{-0.004349339623843919,0.8648880721178558,0.06063006154970352},
{0.0040667541856977,0.9056159927247074,0.04664313576740043},
{0.002504020277296032,0.9008595055085723,0.06829744398918236},
{0.15206284054716362,0.769832004245895,0.07263745167569963},
{0.15603853088760647,0.7663508198326916,0.051563136371435794},
{0.1518274105160933,0.7776818242011599,0.048015017305507696},
{0.14830527959435394,0.7799310069920686,0.06947351595257198},
{0.1466447276496709,0.7930741917955155,0.044748417878774926},
{0.14374606432824139,0.7933565169804297,0.06660620694911946},
{0.14099093686088662,0.8127688179647053,0.04294628817576433},
{0.13863254685653412,0.8111936042941682,0.06491290027620984},
{0.13548598613490992,0.8363105445915996,0.04398606180353718},
{0.13372241108930105,0.8321552175558699,0.06574571061931278},
{0.12260669810893375,0.9039734478250918,0.05495264968184259},
{0.12096287672917906,0.899219798608489,0.07659751442919828},
{0.055242441655919225,0.41708720232552854,-0.10862153833070641},
{0.07274509117324461,0.4121412383633266,-0.13334559539157456},
{0.07567731476861929,0.4355206165453599,-0.1348451621226132},
{0.05792059613159226,0.438249557580349,-0.10995256011135518},
{0.07807243765774792,0.4677233228803035,-0.13516588085578524},
{0.06016127731691511,0.46801681416818086,-0.1102145111860898},
{0.0788505948220847,0.5127851909912647,-0.13275648121791772},
{0.06091399162954971,0.5106672377944501,-0.1079057551910249},
{0.07839225170111275,0.5798948702111243,-0.12581751039638853},
{0.060699133996835734,0.575851476851271,-0.10098480380757419},
{0.07981061942369887,0.6133229603004575,-0.1168685418973716},
{0.06245290617069775,0.6060037595066555,-0.0925586716590755},
{0.0817396907389774,0.6555321183749926,-0.10050011314509269},
{0.06446788583863088,0.6458618022743294,-0.07695143403899489},
{0.08289874709818426,0.6981875487777296,-0.07998958069988303},
{0.06566400969391238,0.6862737258852221,-0.057445615393274765},
{0.08240008951224027,0.7289074189465627,-0.06247111770044754},
{0.06534693450599142,0.7149573375861353,-0.04097747247402256},
{0.07959843868137345,0.7615956462757285,-0.041427822102862104},
{0.062369662315420606,0.74706729462632,-0.020453890188168733},
{0.07839012010321077,0.7810155069967499,-0.030820643938252044},
{0.06088496719765162,0.7682047771079471,-0.008968047539540855},
{0.07766142344600675,0.8004563614785039,-0.021574205994808037},
{0.05997287876281016,0.7891253571100355,0.0009451343988278243},
{0.010155428125520968,0.7814529059290337,0.02503217829829967},
{0.018881371997536693,0.7592260034173355,0.02923093044477693},
{0.016251562658001206,0.7600898210741058,0.050865409848865936},
{0.00788998570410407,0.7812125558725735,0.04686246727710632},
{0.003129854942717915,0.8039846393337278,0.022800209399750644},
{0.0011469731734252723,0.8026213957243279,0.044729642467021935},
{-0.002160709084965058,0.8266205731753979,0.022536238264213554},
{-0.00394531507033948,0.8241257361192963,0.04446938923480227},
{-0.005692766808561894,0.8491609940808437,0.024225405671429764},
{-0.007365798515380431,0.8455383682324343,0.046065609059082885},
{-0.007463703302739249,0.8714124843264814,0.027835489792648258},
{-0.009110746865369094,0.8666733845048606,0.04948608011111276},
{-0.007481053518220608,0.8931845881183702,0.03331817027775359},
{-0.009190074529151817,0.8873487068181096,0.05468743924519969},
{-0.005773271808395159,0.914292389338513,0.04060773938211582},
{-0.007631021345034441,0.9073907214802689,0.06160397871671375},
{0.10592740306727397,0.7588381517432619,0.05724037473714192},
{0.10636114606129568,0.7580040277409867,0.03544974339372112},
{0.11620738095392863,0.7799731804086992,0.0325720862260351},
{0.11535476657915489,0.7797116506963404,0.054501531686317446},
{0.12410051448284143,0.8022955710706001,0.03139971977295186},
{0.12292439294740762,0.8009211861442589,0.05338614829807926},
{0.13000206634869876,0.824773977348711,0.031931379947343456},
{0.1285966988947126,0.8222755587124135,0.053890556241154144},
{0.1338848091062061,0.8472126764193921,0.03414848962563385},
{0.1323505295511938,0.8435877702569482,0.05599736812102762},
{0.13574373597889583,0.8694134792498021,0.03801510907575459},
{0.1341797627693884,0.864671925611992,0.05967313520085394},
{0.13559131433589253,0.8911869090938742,0.043487875152013446},
{0.13409793171737183,0.8853485739774241,0.06487325503383506},
{0.13345725022470234,0.9123478391524231,0.05050479801309794},
{0.1321336766436995,0.9054401235047823,0.0715394556819759},
{-0.025896274797818735,0.7859276380387635,0.03500974192911507},
{-0.03333408910045768,0.7695840820596782,0.03902388778287117},
{-0.032295591952823756,0.7729724180340344,0.060458839708925106},
{-0.026248285883912353,0.7863111397659558,0.057149546359097254},
{-0.016216924192093887,0.8136124102274289,0.05368251476452217},
{-0.015429930810872626,0.8150875999057163,0.031586854239928866},
{-0.009321403267334336,0.8386157066134576,0.034246394412992674},
{-0.01084948631681757,0.8344552612641611,0.05602339344424958},
{-0.0028290022062719775,0.8702739012215422,0.04000845054638029},
{-0.00455158117130075,0.8651609538283437,0.06158253880758326},
{0.004271226475144901,0.905882430069445,0.04765068756642229},
{0.0026229683974314383,0.9011272689054934,0.06929879928267517},
{0.15296755514042554,0.7703871987482858,0.07362889256034597},
{0.1569333062859998,0.7669283341479982,0.052549620051658905},
{0.1526143543252703,0.778218305256853,0.04900151337874187},
{0.14911331630835178,0.7804502865484132,0.07046619613832412},
{0.14728436812941148,0.7935694536964296,0.04573526095631872},
{0.14441795142275515,0.7938644445386449,0.06759500812241043},
{0.14145196926525827,0.8132050767399719,0.04393401115709325},
{0.13915054993273973,0.8116224768348441,0.06590681976306781},
{0.13573753947336686,0.836697268501667,0.04497006688154867},
{0.1340533416635849,0.8325381492045535,0.06673591220285331},
{0.12226924881083333,0.9042467013259112,0.055921287426142066},
{0.12071132339072212,0.8994938080829831,0.07757189013761763},
{-0.010169097616717948,0.8003807269320161,0.05185809003461808},
{-0.0001480964821440325,0.7849204704230845,0.04756886890741684},
{0.013190476533644599,0.7941420479863459,0.049877686867537005},
{0.004237752952277094,0.8079554096487807,0.05370094317196553},
{-0.018134085823745563,0.8169105374742935,0.056369158452770005},
{-0.0028361405806414603,0.8225630022108944,0.05710282470740829},
{-0.02386214792780087,0.83403640227642,0.06017009494428291},
{-0.007989179364612934,0.8379960188815204,0.06100538388959746},
{-0.027295011990888844,0.8516036317743692,0.06361906992174639},
{-0.011046535192641056,0.8536521841092584,0.06392765589709255},
{-0.02844877653437388,0.8696020141270284,0.06764433230642158},
{-0.012068970997943662,0.8697073423280111,0.06742249740848197},
{-0.00657015481244072,0.8028222244685242,-0.01677563211311974},
{-0.011734347306364482,0.7963802629624681,-0.02427340380325769},
{-0.0172095671988128,0.7831446139035168,-0.008269081715865182},
{-0.010552029265401603,0.791466446470951,0.0014148295179290352},
{-0.0024284353028527312,0.8108577536944944,-0.010741475028940933},
{-0.005216838004898446,0.8018468325331979,0.009205063876026619},
{0.0005210889359591056,0.8201600717247992,-0.006421271374094505},
{-0.0014208463247977316,0.8138593781517942,0.014781931245173347},
{0.005657012971659346,0.8512205142305194,0.0006395351391466503},
{0.003885035464553099,0.8457819280787588,0.022161956937248505},
{0.011450497781090273,0.8869075280174532,0.006664521395142473},
{0.009802227310365695,0.8821523668535012,0.028313872412501172},
{0.015053183274707102,0.9094281077121947,0.011119808870521983},
{0.01340486323193833,0.904672934155232,0.032767920586774864},
{-0.03701742831004049,0.7867867215653096,0.04649016883191057},
{-0.043957415358476394,0.7714902386975103,0.050624985434339194},
{-0.02340677912948282,0.7630118328283688,0.05112278790252012},
{-0.012000041070438654,0.7899549452702631,0.045499421955883475},
{-0.026268424526881783,0.8165544614805725,0.04328931432884091},
{-0.004098021752597191,0.8137165982713943,0.04393125990863835},
{-0.019095870232929926,0.8471916826586595,0.04686972958158636},
{0.002292075002180744,0.8410273246003048,0.04739537914561479},
{0.015260580314764021,0.9082259856395613,0.06069205139101605},
{-0.0066036283353086145,0.9124161122503419,0.06037335271864647},
{-0.037283258397236264,0.7858542590202886,0.05002534959429402},
{-0.044221374101002416,0.7705619402042049,0.05416071148920921},
{-0.023670775051042005,0.7620837202302291,0.05465723747725116},
{-0.012263454520478086,0.7890283446194729,0.04903347495426065},
{-0.026541392988447,0.815598365463464,0.04682606900362874},
{-0.004360914696172176,0.8127917078561296,0.04746574666240256},
{-0.01936099391849537,0.8462575222711236,0.050403063785322166},
{0.002026864565537849,0.8400978859499817,0.05093110520048481},
{0.014997018148591829,0.9072976747532447,0.0642267612189793},
{-0.006867611863856687,0.9114878013640254,0.0639090787735165},
{0.11004188273855631,0.7927912965320927,0.05676200451030005},
{0.12331228180051441,0.7831966149779166,0.05634559933874859},
{0.13304576507854093,0.7984029015112354,0.0621219941859304},
{0.11873927311309418,0.8063790558212262,0.06192246670789533},
{0.14076662336073542,0.8146401750274865,0.06745842474753934},
{0.1256409409713386,0.820875074104784,0.06664792182434096},
{0.14635960164425768,0.831659571471613,0.07227063094139152},
{0.1306440243215073,0.8360601809822045,0.07086030628298211},
{0.14971191113546808,0.8493071696462738,0.07688207035610282},
{0.13364559920676303,0.8518067284395887,0.0748929920812811},
{0.15080247132255695,0.8672051438233408,0.08079950115156169},
{0.13462835259065764,0.8677652707441329,0.07826266418098392},
{0.14527893107999312,0.7607949834033103,0.06348893091262549},
{0.16585752594193376,0.7685617949705081,0.06554121354384342},
{0.15999638768513683,0.7840460691348706,0.06049218930168239},
{0.1390391243703166,0.7772886807113645,0.05810895131015846},
{0.15331990083781777,0.8048486428856639,0.057156263371090726},
{0.1320021991893843,0.7992226620136942,0.05460975985188766},
{0.14651645998521975,0.8314050438105023,0.056790446470678345},
{0.1256413623337146,0.8239619748711747,0.053859710036630586},
{0.1096448602362997,0.9068672778722088,0.06761765015361354},
{0.13142974122258952,0.9104889742447887,0.07018613887443365},
{0.14501372064335022,0.759866870805171,0.0670234176663897},
{0.16559353002037458,0.7676334964772028,0.06907570029760764},
{0.1597263067951481,0.7831345879575711,0.06402309447525081},
{0.1387711131131745,0.7763722919016858,0.061640389383202376},
{0.1530549134753739,0.8039241242607311,0.06069042790656743},
{0.13173821566083613,0.7982941652322116,0.05814424660565187},
{0.14624992349639362,0.8304869571583087,0.06032510672659737},
{0.12537993176544437,0.8230230803534146,0.05739334167263179},
{0.10938074038462989,0.9059387934837372,0.07115301681116287},
{0.13116575769404137,0.9095606633584719,0.07372062562819785},
{0.009033860624764809,0.7826463281079048,0.017648434702907084},
{0.01796800708255631,0.760501306220267,0.021843456553055873},
{0.01537167126588863,0.7613551103241023,0.0434828931615681},
{0.006813045436168009,0.7823986042098647,0.03948242919202011},
{0.0018000848561860693,0.8051124405190462,0.015417692712452817},
{-0.00012705314936744443,0.8037442892772674,0.037350843683041535},
{-0.003692485251743609,0.8276986412073405,0.015150003673598303},
{-0.005412659972627197,0.8252026763872322,0.037086872547504444},
{-0.007425272575448222,0.8502080547991187,0.01683173527417966},
{-0.009022768879867742,0.8465844746888581,0.03867689586625602},
{-0.009388350313070039,0.8724449832567632,0.0204319049865517},
{-0.010951084221471705,0.8677045697759704,0.04208869181054524},
{-0.009592810209506213,0.8942193549696755,0.025900953159493135},
{-0.01120638024926816,0.8883823335123977,0.04727641863246828},
{-0.008059807134632927,0.915345869636516,0.03317441134947987},
{-0.009814682286479056,0.9084415620669165,0.05417932579181845},
{0.1078768113136988,0.7600639196809943,0.050058624828984974},
{0.10834525473868314,0.7592396233364884,0.028267993485564167},
{0.11839477219170173,0.7811195215385606,0.025422558146629158},
{0.11749625410396887,0.7808530718008118,0.04735075191279464},
{0.1264910891369118,0.803371185286353,0.024281174221191124},
{0.1252592362307497,0.8019930080986281,0.04626389723601215},
{0.13259343256793213,0.8257962644378811,0.024837620417698873},
{0.13112239454834917,0.8232967180375769,0.04679307880819213},
{0.13667321180825182,0.8481967682484811,0.027075798214787995},
{0.13506333488578517,0.8445730022430544,0.04891971950575854},
{0.13872549443946972,0.8703765773181584,0.030961007181495855},
{0.13707600945366152,0.8656386176535553,0.05261159749996036},
{0.1387589679623376,0.8921484952148818,0.0364461662688128},
{0.13717017155168082,0.8863101600984317,0.057824110343999556},
{0.13680085982215004,0.913323231087749,0.043473003538743754},
{0.13537318494825928,0.9064141893879253,0.06450022540098688},
{-0.020822129922242902,0.7984758963463674,-0.008381845723482634},
{-0.026522902615948356,0.7924195185933613,-0.016692598939030606},
{-0.008098237861924042,0.7818086101324228,-0.02095580713602094},
{-0.0011531696789542534,0.7891737642112283,-0.010825747504135876},
{-0.016112773327161718,0.8063071887501004,-0.0014863867637783705},
{0.004586033742042227,0.7987003585626513,-0.002418328802334891},
{-0.011718459466187983,0.8183601975498013,0.00506552553638486},
{0.00888267828286727,0.8100014957744694,0.003916978450555245},
{0.011518523018788035,0.8222182658222918,0.00779480118267248},
{0.0041649564053218655,0.9159606497360743,0.023699495854169108},
{0.026062812080417212,0.912303211919603,0.024756161156014127},
{0.0777206992178975,0.7887386455929791,-0.06198269674163758},
{0.05548907496898602,0.7895368422561967,-0.061340899877972845},
{0.05695059515607635,0.810417900946021,-0.03215941135081212},
{0.07941619945376441,0.8181175795723173,-0.027454479060678664},
{0.08022900747701964,0.8431218302201975,-0.011937747600355202},
{0.05810899468569721,0.8464356594120725,-0.009317369342234923},
{0.08096730871779362,0.9361709614884021,0.007398621405167801},
{0.058778799754353184,0.9359996281105242,0.008671966112352273},
{0.0833547727260884,0.7890213549612359,-0.059331992785458185},
{0.06143038361431769,0.7890381846702529,-0.06315615377969394},
{0.07849380003372268,0.8100158716672968,-0.030610917012116164},
{0.05588547782068979,0.8185404167166076,-0.02916058771401127},
{0.05356798475282891,0.8470160117269113,-0.012160561546168415},
{0.07539961217682986,0.8461022750215991,-0.008075862280458661},
{0.07545293930341278,0.9356913891394875,0.009873927075842212},
{0.05369336484570351,0.9366582794692279,0.005518205051303316},
{0.11612810286219011,0.7629191702846873,0.04809061467296198},
{0.10830314328710774,0.7617072205542845,0.027767315838817766},
{0.11439922824754378,0.7843690557890662,0.021673684694571243},
{0.12198378819412149,0.7844583102547066,0.042269629771993195},
{0.11932794113835295,0.8072042940345725,0.017722792769255563},
{0.1267303114293659,0.8061572333162976,0.038478607689326746},
{0.12307685176944409,0.8299828094684663,0.015811790464099734},
{0.130355254770843,0.8277952695145601,0.03661222022398001},
{0.1256595676669589,0.852401642542421,0.01552799051086972},
{0.1328722629237278,0.8490804395089664,0.03625901940882475},
{0.12701784167892438,0.8744848233048786,0.01769181024161036},
{0.13422556733825905,0.8700467869008922,0.03824066187701162},
{0.12715664340277483,0.8960572509025998,0.022304501350438533},
{0.13442016239789298,0.8905250603383176,0.042559638623763316},
{0.1260821569510283,0.9169878444576233,0.029501122871865175},
{0.13346093094898664,0.9103972535699476,0.04935224798469657},
{0.01360815818533508,0.7857756005791029,0.01450927260888455},
{0.01814769334988732,0.7629651235696908,0.021357650519579163},
{0.007564061906287624,0.7644348355370902,0.04037348668709601},
{0.00319183239101937,0.786116358811156,0.03382501964400692},
{0.009910071292593095,0.8087795200981207,0.0101308341950762},
{-0.0003786064878242983,0.8079788572257025,0.029627519191646527},
{0.0060607029138652685,0.8415645740226836,0.007469559000464256},
{-0.004144966478485197,0.8391198543033004,0.027015828434277953},
{0.004186978785972124,0.8761999912492947,0.008959707043098756},
{-0.005975290281652891,0.8720036185609407,0.02827545407822113},
{0.0039973533237724415,0.8977775123745608,0.013550078339011324},
{-0.006209530583661643,0.8924892658399456,0.032562196603210754},
{0.004623187989194413,0.9186831464053132,0.02086691206770134},
{-0.005667943607412537,0.9123404653108435,0.0394613858592435},
{-0.015169677578652951,0.8031679027259673,0.04516711575737214},
{-0.005250311527766341,0.7871140581663866,0.04369853155397868},
{0.008099464770018775,0.796324482019696,0.045996195804146586},
{-0.0007628146166468829,0.8106669508962441,0.04729995296046757},
{-0.02299090685740683,0.8201228183335586,0.04628248675259927},
{-0.007787173284366228,0.8259549321584575,0.04883296842835198},
{-0.028660709416478053,0.8379701174884092,0.04800263668746067},
{-0.012808833758110988,0.8417324869295093,0.0497116329123698},
{-0.031996895600301944,0.8560725019898682,0.048880061870372686},
{-0.01577943850873258,0.8578670843491446,0.050336240669697},
{-0.033057762132895664,0.874568984242974,0.050498589114557846},
{-0.016721257777102417,0.8743670153417608,0.0516796430683928},
{0.11568937787772303,0.7948237627386289,0.05364516222919311},
{0.12896847683344387,0.7852413874444334,0.053239923160604975},
{0.13901671780632355,0.8010376680551938,0.056209288610120776},
{0.12466810199629044,0.8089381754256861,0.05629851828973895},
{0.147047413757981,0.8178549220959522,0.05878207770577803},
{0.131846146394141,0.8239534732655889,0.05855404630230937},
{0.15293781191388614,0.8354344330678597,0.06091243630666187},
{0.13711561751700307,0.839639319754811,0.06036962242231799},
{0.15657269445023184,0.8536149307180178,0.06296471893787979},
{0.1403700222208548,0.8558605195357198,0.06211703698150716},
{0.157925998864763,0.8720087244814967,0.064486593088823},
{0.1415870406927802,0.8722626820640987,0.06334519677037388},
{0.10259281558187659,0.7964547697449496,-0.042301256736213405},
{0.12232437292401963,0.801331717028569,-0.03444411251141326},
{0.13247816517208091,0.7908529924235758,-0.04621399058048126},
{0.11394069923140589,0.7847495212285491,-0.05545174102317355},
{0.09401025884780283,0.8105022353862711,-0.030737598371151857},
{0.11468675849710229,0.8138321383134887,-0.024143277187147875},
{0.08763935886715392,0.8265666759703065,-0.02056904604692039},
{0.1089732210020071,0.8282708637069249,-0.01503292689813263},
{0.08455439141048836,0.8435333153663588,-0.013726951392832231},
{0.10625086065588983,0.84327915949558,-0.009075854342735086},
{0.08459026917750144,0.8677777505062682,-0.007064567792097273},
{0.10630423735451695,0.865092308940093,-0.003163247911013916},
{0.088758137940422,0.9131931292576615,0.0018746226211948326},
{0.11047190782926056,0.9104963480863679,0.00577346390006658},
{0.09046709698629798,0.9347818164858906,0.011403608823751998},
{0.112179689539086,0.9320863489737697,0.015302450102623735},
{0.0788735714645864,0.7998826270315699,-0.05034160684348514},
{0.0999404633552265,0.8016138687113281,-0.04394637938212921},
{0.10658916507175331,0.7902792579766421,-0.057880783583568164},
{0.08589162208967718,0.787943088641117,-0.06504269228102112},
{0.07368076350812958,0.8139448527490619,-0.03764050553050202},
{0.09511202231688816,0.8147095758894116,-0.03212437630855093},
{0.07000381909225276,0.8296397709223785,-0.02675417479180873},
{0.0916161769716031,0.8297290377810296,-0.021758564427308016},
{0.06844721972432484,0.8463093374503577,-0.01952811986911914},
{0.09019691695222076,0.8451021094571678,-0.015169497879992666},
{0.06903249206455363,0.8700921701073868,-0.012818989830673111},
{0.090758369925196,0.8675347483454413,-0.008886228880535404},
{0.09451611677317152,0.913007618275133,-7.246813216211593e-05},
{0.07279094531415944,0.915554072222292,-0.0040071004269696025},
{0.07434380199274784,0.937345856115741,0.004806809037536403},
{0.0960687379845498,0.9347965641690499,0.008741590048476564},
{0.03429159792082706,0.7977121150748578,-0.04722885425602737},
{0.024525124447363912,0.7864026621526197,-0.06189610677337477},
{0.005092870715284509,0.7932077017036442,-0.05539597247341219},
{0.013840043815242752,0.8033473659190993,-0.04225218041242342},
{0.04163988511158243,0.811470067584852,-0.03451250953944279},
{0.02036974783958988,0.8155758597553826,-0.030940843752504346},
{0.047072696120190084,0.8273102194547582,-0.02349577953839639},
{0.025246459655999427,0.8298266079570901,-0.021064196410734887},
{0.049769725151704566,0.8441764506752177,-0.016234057529881663},
{0.027635770222941784,0.8447329836228029,-0.014741938998488914},
{0.049670494312162534,0.8684348775246121,-0.009578874268571453},
{0.027539179094755152,0.8665374207805426,-0.008842308049345573},
{0.045939033040641224,0.9139850922363167,-0.0012112371322669157},
{0.023807581500112193,0.9120988015952111,-0.0004726136732053727},
{0.04338728727776056,0.9345562141125894,0.012186847122622609},
{0.021254596436125678,0.9326699110784726,0.012925470581684131},
{0.059033091948253916,0.800256486996159,-0.051763692469388695},
{0.053757746538150235,0.7885368625869316,-0.06735895844078718},
{0.032348857114351454,0.791652329243811,-0.06323083406432993},
{0.03734592985415698,0.8027813771040767,-0.04844540179353266},
{0.0628629289415543,0.8141445413362406,-0.0384200259260552},
{0.04090497955583833,0.8157108692178494,-0.03603065339405751},
{0.06551509527303856,0.8297188259399177,-0.027080321663824188},
{0.043428556004583944,0.8306172448835623,-0.02523356472799345},
{0.06663410981351676,0.8463428109732256,-0.019659485786334783},
{0.044454337922872234,0.8459487132215786,-0.018466038821441755},
{0.06596860511969792,0.8701398212349049,-0.013041605488309389},
{0.04382477296112187,0.8684023458705843,-0.012269520899391043},
{0.0626598818483787,0.9157503651244409,-0.004736032551383693},
{0.04051618601292429,0.914011191917605,-0.003962783019425902},
{0.060624713965431946,0.9373978571901408,0.004581256236279358},
{0.03848093137890017,0.9356603818258202,0.005353340825197692},
{-0.012308651831806912,0.7956970362628363,0.029566557970251834},
{-0.0029328184599054564,0.7669988627739296,0.022257395515406772},
{-0.005021028430180809,0.7609041038656766,0.043528747302483},
{-0.015237702816350802,0.7933604951369793,0.051832684361949016},
{-0.015616569557407279,0.8371936581665873,0.04116558598887314},
{-0.017614248581903334,0.834884146197848,0.06353661921917698},
{-0.00763607769354614,0.8781021697305773,0.053781596887931514},
{-0.008706015910234366,0.8756548102998387,0.07621232725250211},
{0.007031174823801339,0.9090799632455513,0.06427839050304725},
{0.004613261187336857,0.9030111057304099,0.08552249005880676},
{0.12803776170298214,0.7590463543290374,0.05298709334200911},
{0.12914940240188083,0.7651549314446201,0.03164632829999658},
{0.13819076079833578,0.7935995191412563,0.040266126032299863},
{0.13787561892013983,0.791227038283331,0.06271887877752068},
{0.14097633789386024,0.8350104681595628,0.05229882268687656},
{0.13972527582055821,0.8326909426378886,0.07472269971633204},
{0.13243098497898279,0.8761489320437355,0.06373943084514244},
{0.13024846419455555,0.8737210420333692,0.08609207284703609},
{0.11729302111562744,0.9075406769140713,0.0721169699972824},
{0.11651348832706314,0.9014481735338312,0.09347632455588203},
{-0.004659177293306998,0.7859788831394885,0.03519940457034791},
{0.003468159358581386,0.7636093990355671,0.038712823205313385},
{0.02446192009096772,0.7694205190997335,0.04021857404887002},
{0.01674479210510173,0.7906273900502745,0.036940622624008046},
{-0.011068855005556662,0.8085713175123451,0.0336564870866281},
{0.01065981128257378,0.8120388820063956,0.0355327889608213},
{-0.015731068586572885,0.8311898515664896,0.0340790887637086},
{0.006233064911660956,0.8334639938816694,0.03598885176775862},
{-0.018632284868280335,0.853634784321733,0.03644491457469593},
{0.003476859252344207,0.8547155044580416,0.038285276716820714},
{-0.019773705972751514,0.875714185215818,0.040713079976109505},
{0.002388765274455855,0.8756099847788417,0.04238365786673858},
{-0.01917136845629569,0.8972395193715187,0.04682903093327163},
{0.0029513831904705223,0.8959693100961318,0.048230680483940386},
{-0.016860059500952845,0.918028857386502,0.054722139676162324},
{0.005131313835586651,0.9156234730842171,0.05575447749730032},
{0.09956732218527874,0.7683721323292755,0.045557483212690576},
{0.120393777268381,0.7619772518722292,0.04702481572196716},
{0.12955465386348,0.7841050722605181,0.044739544482857344},
{0.1082572767531818,0.7893498193263194,0.04344571412839387},
{0.13674385197128283,0.8065078315991306,0.04416452116277352},
{0.1150721935340196,0.8105814762989764,0.042956202584610796},
{0.14192539468068796,0.828987563929425,0.0452873279646355},
{0.11998356860235852,0.8318751602919795,0.04407529148315535},
{0.14508434841337023,0.85134947590359,0.04808320365234925},
{0.12297644359385153,0.853046103903463,0.04678068579713406},
{0.14622326612960773,0.8733967293269905,0.05251369271260153},
{0.12405342104082076,0.873910902962779,0.05103272789116106},
{0.14536195186107115,0.894941917086406,0.05852555476988685},
{0.1232366968260712,0.894290081883784,0.05678061881290929},
{0.1425351060387233,0.915803122172515,0.06605306968656421},
{0.12055980643752606,0.9140110060224393,0.06395989011885463},
{0.07237950974004231,0.8090943769370623,-0.05134221855631447},
{0.06866902983624229,0.7943292568113893,-0.03638261490810696},
{0.07053297587841063,0.7861176848633391,-0.047610682926726794},
{0.07396953305879383,0.8020599551443639,-0.060953011024866006},
{0.07100511242069028,0.8169886382299812,-0.04260018855594535},
{0.06705669909758619,0.8035459267422717,-0.026172013097355437},
{0.0698599981989237,0.8256674886599766,-0.03481613831036576},
{0.06571209457681776,0.8136784030113132,-0.017078021582936875},
{0.06895656008580078,0.8350452677346141,-0.02806318658481835},
{0.0646500011361293,0.8246276158881152,-0.009189870044469414},
{0.06833196472148466,0.8449262402372428,-0.022820942907250816},
{0.0639076225947172,0.8361804427615122,-0.0029958431176413825},
{0.06799238382548227,0.8552124642014705,-0.019143948919329745},
{0.06349496011250524,0.8482239956937756,0.001438363845928326},
{0.0679600876386649,0.877341214065589,-0.01413848611103786},
{0.06343175575610906,0.8725726312706614,0.007090828582529349},
{0.0638995423515073,0.9412631010160342,0.019960214592670146},
{0.0684146508912642,0.9460241364672273,-0.0011676633053866942},
{0.06593513159683002,0.8092133126641868,-0.0518057295628977},
{0.0654827990862212,0.802217482707923,-0.06156521337812406},
{0.06638255647505983,0.7861944595668441,-0.047909354493226516},
{0.06691789737373567,0.7943627303342572,-0.03650902362089938},
{0.06633173273671067,0.8170754388794323,-0.04293727845672509},
{0.06738758009982586,0.8035396806646987,-0.026148466376345096},
{0.06666634403527881,0.8257268759689667,-0.035045409014940215},
{0.06778540814780122,0.8136400094630554,-0.016928066149134113},
{0.06693775097745078,0.835083648889861,-0.028209424115303677},
{0.06810886573641708,0.8245633209467458,-0.008940770522202006},
{0.06716822380409787,0.8449485600501585,-0.022905215382445755},
{0.06837904577049432,0.8360974343734451,-0.002673624830131324},
{0.06735538305709697,0.8552236179114228,-0.019189790667233572},
{0.06859589867798854,0.8481298212027453,0.0018052093662585254},
{0.06748425797908994,0.8773618360359896,-0.014170509651611943},
{0.06874340029560187,0.8724746645182471,0.007473772624223998},
{0.068965359123652,0.9411691248131806,0.020324680654877192},
{0.06770267240597751,0.9460375580982034,-0.001219453698598415},
{-0.005801788126839833,0.7870446573044615,0.027841673905166245},
{0.002533751110824326,0.7647521461922215,0.0313526139379201},
{0.02347792740596726,0.7707516028454375,0.032813762334678705},
{0.015562523636183047,0.7918866315108749,0.029538277119017294},
{-0.0124172022156646,0.8095777167613386,0.026297517120340626},
{0.009282960147032194,0.8132423301312125,0.02813044345583055},
{-0.017282710750077573,0.8321527513466692,0.026716400894103695},
{0.004664084925686023,0.8346264087468729,0.02858154905834463},
{-0.020379687034458464,0.8545729228658184,0.029073551597350374},
{0.0017219841004979901,0.8558531456941403,0.030870538200771878},
{-0.02171196050922406,0.8766436238661408,0.033331802589917484},
{0.00045419146226759904,0.8767391120163435,0.034959004941843286},
{-0.02129181264833309,0.8981778438107698,0.039432881933809914},
{0.0008445465245749696,0.8971069513322302,0.0407911559457754},
{-0.019151552031613835,0.9189917695596925,0.04730864046121929},
{0.0028621287248302416,0.9167845618972376,0.048300081345865636},
{0.0063758819710942796,0.7967626369256541,0.045855163338305645},
{0.023512627836929888,0.7708767846501354,0.04468874553053028},
{0.022128353287764586,0.7689681741961137,0.06678795045628619},
{0.0031220473457513128,0.7983510863320014,0.06814158948211597},
{-0.008596672373668849,0.8372205138215503,0.04844263815206672},
{-0.010968533581041544,0.8391085023051713,0.07081424146087922},
{-0.012602700805181971,0.8804283131201565,0.0520273909586825},
{-0.014052695491988329,0.8824626754573847,0.07447680998392868},
{-0.007391799052580327,0.9157163215230644,0.05557477883695817},
{-0.009099580762405777,0.9137347162339107,0.07764549223029157},
{0.09810617378852018,0.7679073200565311,0.07218882467539714},
{0.09991555340299968,0.7698096844329795,0.05011936297618061},
{0.11742997628083028,0.7952180463854416,0.05375035410705409},
{0.11754054672549046,0.7967565767432468,0.07627576707610842},
{0.1329992912870732,0.835239664506071,0.058507646868907935},
{0.13223843476617347,0.8371149873323905,0.08099476543379279},
{0.13765881558468981,0.8783353318406238,0.06270959641223817},
{0.13597429555662038,0.8803772539145972,0.0851435117806507},
{0.1329813214210389,0.9137557099946428,0.0655523920398178},
{0.13149417248708045,0.9117716508892998,0.08763921634752671},
{0.12031255347390633,0.7911956467863209,0.06911140456246595},
{0.12219691080528733,0.7959007030065648,0.05338119109365602},
{0.13253599096167792,0.8142648155085592,0.059574338116698926},
{0.1381877369036376,0.8345993671967444,0.08209340586409151},
{0.14294536427678997,0.8503999977543862,0.06926323134093848},
{0.14153868316363163,0.8723937381560378,0.09072225049446721},
{0.1436207462004221,0.8766509977077204,0.0751644114164641},
{-0.008742414183711892,0.8159828090594967,0.04973871164153171},
{0.001726953697932325,0.7975812572710956,0.044817620452523244},
{0.00196861741356488,0.7932757765133863,0.0606199612456912},
{-0.00909944443928413,0.8126277483198313,0.06577998968789943},
{-0.018777084809482963,0.8476504471420078,0.057350908002768916},
{-0.017743693582405025,0.840907248716163,0.07275519767376243},
{-0.020564912977732542,0.8747694288038275,0.07956960634114685},
{-0.020338790097966766,0.8790467278543908,0.06392147178457458},
{0.1013494247824195,0.7707219091909426,0.042469157250028276},
{0.12211389002420919,0.7641386921448466,0.043972417098362235},
{0.1314780491796939,0.7861846195160638,0.04171936768800342},
{0.1102314586287117,0.7916213219301438,0.0403871189992599},
{0.13886926576075448,0.808521770254135,0.04117160899224737},
{0.11723850425998295,0.812791137777621,0.03992239347759298},
{0.14433455885134533,0.8306357724350941,0.04108857581815824},
{0.12242251317858856,0.8337217437256554,0.03983564240018643},
{0.14768937173078953,0.8529655493315856,0.04390426793055386},
{0.12565459806952456,0.8546510236215065,0.04174044819981321},
{0.1490736462799549,0.8747872003816847,0.047531714660264714},
{0.1269124639058975,0.8755022027616695,0.04600737430012097},
{0.1484763279329776,0.896018857354342,0.052325331337529785},
{0.1263498335968718,0.8955665248437332,0.05053701984184895},
{0.145878715636171,0.9166879335900177,0.05903986472879714},
{0.12389231189706566,0.9150941799749375,0.056903309622384275},
{0.10501152237104873,0.7716549418144723,0.03984926231933925},
{0.12529148284552286,0.7670720558972387,0.033180583068986795},
{0.13096870881821787,0.7898454530175653,0.02789992105713921},
{0.11041739097361607,0.7932485366750807,0.03489081859500173},
{0.13546735943928961,0.8127130370219329,0.024769458856879444},
{0.11470661210081731,0.8149177784751875,0.03196484107720028},
{0.1387800112951142,0.83544427311864,0.02367763458266266},
{0.11786808161474444,0.8364431126308878,0.030956049977072624},
{0.1409227753000672,0.8577356564668733,0.02420557685373684},
{0.11992532145038555,0.8575348277226773,0.03144557391386676},
{0.1418448401088104,0.879616682432952,0.0271613223840998},
{0.12082378996607422,0.8782286775874583,0.034243928203792115},
{0.14155479407800714,0.9009128202421445,0.03253988918330621},
{0.12057470283681786,0.8983610744792637,0.039344891555297544},
{0.14006396441976438,0.9214951082213805,0.040467698357159534},
{0.11918668559831296,0.9178132809591467,0.04687736367639814},
{-0.003516529280740995,0.7917230561579195,0.018339952326936856},
{0.000720641200016255,0.7688108449207313,0.024325776667989144},
{0.01997319627175353,0.7728423162039468,0.03380395152520818},
{0.015924374773056856,0.79456715305166,0.028173806601522765},
{-0.006903539202914138,0.8147479694376698,0.014835221192723095},
{0.012684866468497051,0.8163901301539425,0.024898346171883464},
{-0.009411884641069351,0.8376255669949725,0.013582287774751272},
{0.01027810654198486,0.8380580459018663,0.023747035444587908},
{-0.011009331373444675,0.8600468662781279,0.014146182170904945},
{0.008738906961582506,0.859277409007554,0.024283652823402734},
{-0.011682296659920495,0.8817607353110549,0.01624803684635519},
{0.008079611166303754,0.8798025775988231,0.02622936795253224},
{-0.011564538268846654,0.903050627042674,0.021655107570995175},
{0.008163896034509788,0.8999300668582496,0.03135387802504803},
{-0.010638780342808131,0.923599429106031,0.029755179598555802},
{0.009012829684999248,0.9193523813954606,0.03904498068769202},
{0.1176994870923103,0.777751225063085,0.025370507500185227},
{0.09790416770827348,0.7754547629349897,0.01653429061577471},
{0.09455681542148626,0.7987882993691193,0.012127335883521705},
{0.11451575973052289,0.8000573560944779,0.021113508201734996},
{0.09206207750947273,0.8220214152346453,0.009537208965394199},
{0.11214744292431293,0.8222619511862715,0.01858658564000369},
{0.09043859306086434,0.8449831613370326,0.00864491216921249},
{0.11061443984943956,0.844202550356506,0.017669502821705825},
{0.08971858390441212,0.867435666222032,0.009031574114224566},
{0.10994643176738696,0.8656435376789453,0.01794338836608938},
{0.08984500501021553,0.889464193805724,0.01151638522438052},
{0.11008774927248224,0.8866794718279624,0.020229911299316065},
{0.09080914409150097,0.9109524604653497,0.016109235122504697},
{0.11102834163275727,0.9071985926298352,0.024537721943104423},
{0.09258755357134642,0.931828413234618,0.022961330936516734},
{0.11274600057239599,0.9271339406458173,0.031022984629797308},
{0.034992273980028694,0.799619783660039,0.00789265639798708},
{0.03040932609773998,0.7763964954522824,0.01173571673408641},
{0.009634921661081618,0.7792593181857317,0.01768931924638769},
{0.014007213141405182,0.8014601210161416,0.013968937326752287},
{0.03846106538217404,0.8228171580816737,0.005912253230906004},
{0.017312379618550734,0.8236325562442397,0.012030682790279752},
{0.04082197116777131,0.8457628304487183,0.005457429725074498},
{0.019559257309402563,0.8455606756523389,0.011536201649062385},
{0.04208479420856745,0.8682597642783612,0.006262975443849655},
{0.020757636692696757,0.8670478145479584,0.012221535160574167},
{0.04226202665970909,0.8901285087704813,0.008134332506630685},
{0.020921261617696543,0.8879237673172267,0.013890886143108513},
{0.041255726554804126,0.9116440028754016,0.012585902078692757},
{0.019950888851848952,0.9084701155643944,0.0180636129663638},
{0.039105526743216296,0.9325757489804534,0.01915916753690907},
{0.017887440117667734,0.9284588030999704,0.024279947313096368},
{0.11087096278533075,0.8112575150521947,-0.0418294052331881},
{0.11167029960556576,0.7937033353948898,-0.0289021934334503},
{0.11871076918766063,0.7854076025087442,-0.037428597434419925},
{0.1198484476027923,0.8000883758011562,-0.052931002573960224},
{0.10570061096491117,0.8030143533189575,-0.020973144958491185},
{0.10436588367395601,0.8243091650759666,-0.03231027147442211},
{0.10087974205632931,0.8132211504753142,-0.013740583704996109},
{0.10123538429466303,0.8338616732135122,-0.026703673271747053},
{0.09726716693988818,0.8241940092172151,-0.007298696557006498},
{0.0992252379010426,0.84385554604688,-0.02226325740963725},
{0.0949385201620751,0.8356897290956562,-0.0021357681502106817},
{0.09829244074472307,0.8577602442008129,-0.018017808397493146},
{0.0939235077703963,0.8475610067812013,0.0016775613523603201},
{0.09525431886985704,0.871437828034095,0.007218526168471793},
{0.10612690575928693,0.9443316725190698,-0.0004224095854091097},
{0.10171925701841474,0.9396510057445879,0.020959351537183552},
{0.11278320439159237,0.7733145023182706,0.0331818223700926},
{0.10405230331515342,0.7736887464662026,0.013198092038939757},
{0.10921153860465396,0.7969950430620263,0.00894606233792382},
{0.11774785701447,0.7954693642566882,0.029108239635301944},
{0.11330868045346597,0.8202232389021623,0.006896258308917506},
{0.1217036813581868,0.817547624993756,0.027120413054597087},
{0.11633753235606062,0.8431466038493024,0.006927240836562698},
{0.12464210145909053,0.8393271150202358,0.02709810563469254},
{0.118315444527919,0.8654601087222749,0.008612690340461483},
{0.1265840367198474,0.8605165985762623,0.028613770887095637},
{0.11918791250640778,0.8871949591229231,0.012751968426871018},
{0.12747513139395644,0.8811546551052597,0.03247048832138096},
{0.11896610239449025,0.9081788921975404,0.019330178696499504},
{0.12732517596015364,0.9010788618043005,0.03865336153825673},
{0.11765490943153441,0.9282889816694413,0.02846506714740974},
{0.12613917719490655,0.9201753640807945,0.04728261513799733},
{-0.030141810561040202,0.8076433908093715,0.0450475727727059},
{-0.03577180676859294,0.7926562746766148,0.04653281318296141},
{-0.01488710453351776,0.7852897945456263,0.04713263491817245},
{-0.008565181732570348,0.8021838232898894,0.045525013523718405},
{-0.02488329485995343,0.8243067112597774,0.04437396304965506},
{-0.0013547543968249916,0.8267482087962852,0.046489524395335546},
{-0.019355887997939476,0.8479910194788948,0.04789049233039611},
{0.015464903888078549,0.9083865247048073,0.06170110274437591},
{-0.006364455614898696,0.9127704904015477,0.061363554302187005},
{0.02089153078416825,0.7982268463961443,0.0026677629359008583},
{0.0247482234324314,0.7747966940478057,0.0075605113086194995},
{0.013271031105522147,0.7747036597137926,0.026107904051152},
{0.00955067397190884,0.7969800970906903,0.021417149365668995},
{0.017759804496780534,0.8216050100630938,0.0002895317208443904},
{0.006518091772985793,0.8192032197340159,0.019118245814395297},
{0.01450701088436646,0.8546996166178651,0.0005447781765965838},
{0.0033275110760832105,0.8506252159443446,0.01927242726496886},
{0.01298600424419731,0.8886784769046416,0.005203385391394941},
{0.0018298156897143636,0.8829095302571058,0.023538845251823225},
{0.012859595531404932,0.9096599437700582,0.01178779216655245},
{0.0016575528360070666,0.9028337245631354,0.02971923986648737},
{0.013423489927558617,0.9297439335606709,0.021055285835784136},
{0.0021408926602832037,0.9219065933675417,0.03846870567349134},
{0.13796828146382112,0.7831569077704867,0.057998827013896366},
{0.15892483837701107,0.7899384997445891,0.06037332793262435},
{0.15388985541637878,0.8053686784156832,0.05812757800577875},
{0.13259526673356875,0.7996288553441336,0.05562013725743074},
{0.14683581548717534,0.8318970959215523,0.0577562833944787},
{0.12602504995607272,0.8242620840269571,0.054870310516372714},
{0.10930684085969056,0.9070321792773476,0.06860961154472432},
{0.13106415978938724,0.910852039896746,0.0711329649192709},
{0.08974596006583933,0.8132937735201147,-0.04979565752734357},
{0.08848176140081579,0.7952649415392854,-0.037914391074885576},
{0.09293209167177204,0.7865947910030531,-0.04768628029418108},
{0.0953561522417213,0.8017600442767583,-0.06238191280685149},
{0.08478122069188433,0.8048335234121732,-0.02896045297843434},
{0.08580487101227065,0.8265487061042722,-0.039197067719396766},
{0.08186757422008567,0.8152090018420411,-0.02091119229621185},
{0.08399795760699165,0.836145841474638,-0.033079877461128844},
{0.07976948701999713,0.8262896426011141,-0.013845924298989802},
{0.08294456406006592,0.8461531359389816,-0.028283782181652155},
{0.07853757214877982,0.8378596709738595,-0.00824304399963214},
{0.08265580690241268,0.8564728334260775,-0.024860832527410667},
{0.07818315681854084,0.8498065955989035,-0.004162025458206633},
{0.08403521099823222,0.8784835894319118,-0.019822367130671113},
{0.07963688180167568,0.873837908127647,0.0014631746540666127},
{0.08549597521164798,0.9421649404307305,0.014915193293080876},
{0.08988073406109602,0.9467884878172454,-0.006270113818219105},
{0.026580765584578527,0.8128096653291529,-0.047910606187343364},
{0.018886329201959914,0.8019546269433813,-0.06020693936615859},
{0.017249175262154456,0.7872825535447323,-0.044741700866781434},
{0.023294498449296645,0.7953367962174,-0.03527097420920831},
{0.02840413690854276,0.8044432179219099,-0.026543803429097828},
{0.03213195463481295,0.8256438551878886,-0.03751658781293228},
{0.03251120555921231,0.8144839735161103,-0.018669284202794244},
{0.03477542107253447,0.8350910227314405,-0.03149358443870574},
{0.03556360418281721,0.825334104269503,-0.01174530892464535},
{0.03649430692026793,0.8450141686506998,-0.026784227843624556},
{0.037548939768299414,0.8367505956282498,-0.0062713159402917424},
{0.03732167673151635,0.8588978730439001,-0.02241073424122838},
{0.03844371516669277,0.8485859335817267,-0.0023216757090929268},
{0.037212754557326894,0.8724994381473523,0.003033319583081013},
{0.030237149995110044,0.945733669074048,-0.0058924987712794166},
{0.031358816639954684,0.9409525941239738,0.015888713883737242},
{0.04869197933804974,0.8140503668452103,-0.05275637265514085},
{0.0445237387847975,0.8027008225321993,-0.06604528687561974},
{0.04425728904704875,0.7874945359988805,-0.05119474172472334},
{0.04757736431649713,0.7960209771788834,-0.040862688405602636},
{0.05030506605038041,0.8054717386956419,-0.031445239302568186},
{0.05155925116246913,0.8271818278601962,-0.04166575552216617},
{0.052414368925476545,0.815754368686663,-0.023034115090460838},
{0.05282084729517054,0.8367220421307723,-0.03532673036595862},
{0.053882940735858996,0.8267680624000001,-0.015711072463230724},
{0.05354335983985651,0.8466971891244314,-0.030402987072583706},
{0.054724438579713625,0.8382997220105097,-0.009959476031176126},
{0.0537193653829034,0.8570081743247532,-0.026947803196580147},
{0.054930137777255646,0.8502366082965965,-0.00583879985436477},
{0.05244405018696064,0.8790529739319641,-0.02210209869383798},
{0.053571863765290155,0.8743199342927509,-0.0004156182153492796},
{0.04836143294710867,0.942851946998735,0.01223933152445357},
{0.047233148434359,0.9475768568226941,-0.00934387799288815},
{-0.012729642417449909,0.8185080709577464,0.039055142956759645},
{-0.0024445586102392674,0.7995889498485266,0.037384292419887284},
{-0.003641711085438727,0.7972900339042419,0.05355841115178656},
{-0.01450002122612965,0.8171102384544833,0.055286827225023705},
{-0.02264068036490547,0.8512785630943157,0.04176152871162301},
{-0.023068995220083793,0.8465447674814278,0.057930677846087984},
{-0.025699275494039442,0.8813407361662968,0.06012659547546906},
{-0.024049257608755772,0.8836258462962627,0.044158337050255535},
{0.07160224487250165,0.38916038223788774,-0.11056172617690398},
{0.04789586470068977,0.39195417589974385,-0.12601885964704915},
{0.05339930347931742,0.42217443422078166,-0.12968582768902423},
{0.08078836603112606,0.458986993665021,-0.115392881284664},
{0.05794711717525652,0.4763418565254787,-0.13075123006366518},
{0.08112554268298319,0.5628129634192207,-0.10747375961156237},
{0.05763477611755977,0.5651468648337225,-0.12303722511658584},
{0.05808663769374844,0.5845837535519376,-0.1198037274223892},
{0.08202901797513928,0.5863353073768202,-0.10367993670839681},
{0.05909454889009093,0.6090817744841175,-0.11305102355706298},
{0.08393087423813421,0.6227255006111893,-0.09203858655701214},
{0.06171342759387322,0.6604786524157036,-0.09331655385732128},
{0.08573041380183369,0.6627966659900287,-0.07501049021912275},
{0.08572653478937253,0.7249544202093672,-0.041397422046736625},
{0.060985102727000896,0.7410330383980528,-0.04868000149286212},
{0.08164835424747934,0.7694161691528522,-0.01366230944715328},
{0.057967689573612945,0.7760818369015176,-0.02796902448679907},
{0.13893965806356443,0.8193739706403741,0.06699434366244744},
{0.12626554872866577,0.7954769239934336,0.06279369538527829},
{0.1278776440001118,0.7975129841731767,0.0467450187113089},
{0.14425531793863997,0.8332518131393439,0.052318837399735356},
{0.1485924752326139,0.8576728734728531,0.07145797163426904},
{0.15105043068780696,0.8812505274388048,0.05714709254290775},
{0.1489943186161721,0.8789996468053812,0.07313071830183329},
{-0.012520262495623595,0.8184384842006551,0.03897681912687259},
{-0.002447012426428824,0.799925940605218,0.03775733444574653},
{-0.0038623066822724645,0.7968252216314976,0.057014834328895925},
{-0.012368832293504991,0.8125990089271876,0.05818845247609604},
{-0.02334164146336152,0.8455720276504683,0.060155186151980046},
{-0.022602385960736004,0.8518360379107414,0.04098788260331135},
{-0.02574583603658465,0.8813594496129944,0.06173797195227371},
{-0.023921621987868572,0.8844439089562065,0.04268109013213248},
{0.1386389788292733,0.8188955508414881,0.06989428346401588},
{0.12598174877543575,0.7950121117206895,0.06624514896495338},
{0.12780626025641725,0.7978649085081928,0.047122509828138},
{0.14422468241530442,0.8335916418955676,0.051879480371704326},
{0.14841075651146932,0.8575599855351251,0.07353024419232365},
{0.15118294915505104,0.882064611942199,0.05567383617434541},
{0.14885679337246058,0.8790157205407235,0.07473312223863188},
{0.1561488162930124,0.7926214751015639,-0.0008295447846891316},
{0.13835371650073844,0.7837406681633664,-0.00852809564697903},
{0.12626024451993292,0.7983836179860287,-0.0008290738502689248},
{0.14555129228401653,0.8054532111441104,0.005923394547847223},
{0.11439672485931003,0.8205044363230699,0.008072144377141235},
{0.13515638161280927,0.8248564280512805,0.013704792689060392},
{0.10915206454458617,0.8378732908930125,0.01261935081553851},
{0.13059073437395752,0.8399677841198941,0.017581512443193458},
{0.10715055607967323,0.849921763850666,0.01471996618988295},
{0.12884579841698,0.8504820642736127,0.019297956867748496},
{0.10712129618056511,0.8752036055532362,0.018360995659713476},
{0.12879252086244136,0.8723519489227501,0.022598203319503952},
{0.132862051082616,0.9181922468442916,0.028145215925011777},
{0.11316987872961554,0.9441656433499247,0.027695461160703014},
{0.13453541740073316,0.9405507631334268,0.03660975401477945},
{0.005440110492120838,0.8000675679355898,-0.009418446740424613},
{-0.0058426726703204165,0.7857532807661873,-0.0187783550931164},
{-0.024294664013727842,0.7951410733937598,-0.013656311229801169},
{-0.014407829616868624,0.8076844240689848,-0.005449064442610281},
{0.013950192897526947,0.8160504996858959,-0.001369880066821384},
{-0.006967982860416088,0.8216558709804763,0.0015982460815885994},
{0.02020143835641017,0.8332561630862256,0.0054414427408095755},
{-0.0014807417472414025,0.8367522934707651,0.007593216464801764},
{0.023528751144316424,0.8513012546975629,0.009599174020684595},
{0.0014295338255494378,0.8524723694565295,0.011064027927749564},
{0.023801000811240324,0.8763913641260537,0.01243722312502898},
{0.0016786333478168232,0.8741266652853003,0.013562458957058347},
{-0.0018603644619724512,0.9200719196174925,0.01856867773902476},
{0.01841041279130758,0.9454880272018661,0.020959859650636927},
{-0.004091589779857996,0.9424852749805597,0.0267548316213948},
{0.08428426094845541,0.8254952134132582,-0.06901341302402972},
{0.06206676473215005,0.8244555389295739,-0.07033164521726654},
{0.08248348208365008,0.8282207463702062,-0.03745630820714579},
{0.059968107453552785,0.8328214162583079,-0.031473074005404625},
{0.05911317558571121,0.8514676680500508,-0.009202188697461127},
{0.08128782916278873,0.8525879094986238,-0.007120955992411535},
{0.059728377047645345,0.9358305750466808,0.014749758988466578},
{0.0819066741699739,0.9353048635175972,0.01611017699134511},
{-0.043054559716873234,0.7791142827773189,0.025802106503293905},
{-0.04511986740271318,0.7746391664842465,0.04748213022302134},
{-0.026603420008792737,0.8112648888937743,0.0568489043038393},
{-0.024863304933116764,0.8181236273617135,0.035543434557320196},
{-0.020770079275799002,0.8312010052764419,0.03732853626313699},
{-0.022332825577211786,0.8264445180603068,0.05898284448491892},
{-0.018137915264162526,0.8423393231089793,0.039868682167667265},
{-0.019695654789107807,0.837563539974627,0.061520387857127004},
{-0.007379034251190505,0.8980622913756644,0.050781744631212836},
{-0.008946465110783213,0.8932855663724715,0.07243114522061576},
{-0.000982183305385974,0.9320156220596613,0.058619741653928255},
{-0.0025449172137876424,0.9272591348435263,0.08027404987571019},
{0.16688273778171342,0.7713183476341348,0.0624718117090668},
{0.16868758155414573,0.776158983395354,0.04085383979570716},
{0.14804138281688323,0.8222846427895191,0.04941079256893493},
{0.14642361154637262,0.8177060944261557,0.07109666578988179},
{0.1434294600747407,0.8418274173942144,0.05224273191882769},
{0.1417945864489699,0.8370896560177881,0.07389557776530477},
{0.13214264918370552,0.9014228298262174,0.061853586352434514},
{0.13048545574501919,0.896721937657689,0.0835118727307661},
{0.12666091056744064,0.9302321934103371,0.0676926650495481},
{0.12501264009671606,0.9254783582985685,0.0893420160669068},
{0.15994855066245262,0.7980806708307142,-0.0068810644773603016},
{0.15621325995051433,0.8127478365969842,-0.021736554439668872},
{0.14999816490488757,0.8177569677365493,-0.014339166139101352},
{0.15248542983123303,0.8041049135060464,0.0020133995590232074},
{0.14442877052140893,0.8238878522720362,-0.007587453714659755},
{0.1458006644525272,0.8114774414264316,0.010132073496182005},
{0.13962150913896884,0.8309655752453717,-0.0018656005091445445},
{0.14002798750866283,0.8199989625810441,0.01706348458096574},
{0.13566813861144159,0.8388326090929962,0.0025983620739756003},
{0.13527650706899522,0.8294907573574162,0.022561024286329712},
{0.13043851101913118,0.8569419956457032,0.00883166245284668},
{0.12896923280711844,0.851387683556682,0.030306321586330703},
{0.12230564708431085,0.9242021012337854,0.021082785927322018},
{0.12074625928889487,0.9194471259649996,0.04273822191311023},
{-0.013075890753401542,0.8228857905769132,-0.022073569982382277},
{-0.020841946346924847,0.8152201555519935,-0.03432289647025418},
{-0.027047151769727218,0.800691803902585,-0.020173795745245065},
{-0.020752729060317734,0.8065239053344729,-0.010301535529390182},
{-0.015080472685056953,0.8137230302441334,-0.0013054364093193676},
{-0.0067461603554875285,0.833077282364613,-0.012001844253547589},
{-0.010129439981332098,0.8221651245908748,0.006657073195496572},
{-0.0032711724478132103,0.8409344761614574,-0.006648063476457355},
{-0.005966627566923326,0.8316247842895731,0.013151010989930116},
{0.0014592770520888468,0.8587307161107488,0.000407290111918253},
{-0.00031172140714381843,0.8530635036909887,0.02181745601585602},
{0.0050897104974647524,0.8869497014340837,0.00513051448637342},
{0.0035551459031980402,0.8831723736286367,0.026974014414967995},
{0.009734065749546286,0.9257521694848858,0.013206791932702536},
{0.008085795278821709,0.9209970083209339,0.03485614295006124},
{0.10301006347817998,0.7840814263954191,0.02908842321062008},
{0.11260970223677931,0.7840963723667554,0.009384762536368767},
{0.10821308327574869,0.8194898948658114,0.004227770381869765},
{0.09884225668031474,0.8181790365141541,0.024145346819994577},
{0.10609348180846331,0.8530722035847513,0.0030445104720664713},
{0.09687180510111332,0.850227920795845,0.022991061770045073},
{0.10567953045310133,0.875265632573582,0.004071903481792298},
{0.09651615046976858,0.8714894449251519,0.023936660906787578},
{0.10610831624269981,0.8969781755543257,0.007165199041888887},
{0.0969684829803774,0.8922848431225427,0.026870086624234943},
{0.1073364884245776,0.9182272199214976,0.012830044396536922},
{0.0981854518802587,0.9126366087030875,0.03229574686546204},
{0.10937014436017523,0.9388157415852956,0.02072191383832181},
{0.10017206394587984,0.9323527863185072,0.0398703552241601},
{0.02128929686708831,0.8085936249322497,-0.0005507020358823372},
{0.017109146630209293,0.7854285962694768,0.0025958710787529413},
{0.02382118902625395,0.7851869201608332,0.023459505195029408},
{0.02779442555050732,0.8074138226725315,0.020448015900927197},
{0.0251417882846029,0.8379797592510124,-0.002272847245524094},
{0.03149212825990642,0.8353139853933864,0.0187802512238083},
{0.027251599273152367,0.8763597743408664,-0.0015037245862486363},
{0.03340347756937191,0.8723704764742821,0.01945039090376288},
{0.026991358433943808,0.8980834710315627,0.0015412506237325063},
{0.03311846310105819,0.8931758882246076,0.022330526673660495},
{0.025566137376242522,0.9193697811829858,0.0070177222102977355},
{0.03171309564707202,0.9135649071963929,0.027570291749016422},
{0.023009471587971897,0.9400214576311362,0.014583655461255137},
{0.029223327332492808,0.9333429383300037,0.034826399723521834},
{0.1522376191821157,0.7982752658903481,-0.020369605319962722},
{0.16986294711590497,0.808122764870109,-0.01270330107244594},
{0.1599965364012695,0.815619731014528,-0.0009673054956107342},
{0.14087946172641921,0.8069098608778549,-0.00686072754621398},
{0.14942523600367255,0.8297885985921747,0.012003343807885626},
{0.12874656757743796,0.8231968675474819,0.008038460173085378},
{0.14408545932907796,0.8423287270845247,0.018233384824848427},
{0.12264929288794034,0.8375251588193797,0.015292523300766211},
{0.13997844025045258,0.8618253749020617,0.02346940721086481},
{0.1179611159487574,0.8596049315037967,0.021392202234409085},
{0.13178581721631022,0.9300777021344873,0.03603808920069236},
{0.10976508483657413,0.9278453490525952,0.03401704935035186},
{-0.027447148594637823,0.8182331196144117,-0.014297005115481752},
{-0.03575445655311163,0.810992961445138,-0.02731960592133359},
{-0.017504520861995106,0.8006447104605645,-0.03243668018721453},
{-0.007933150561619308,0.8089890487360797,-0.017437406510610102},
{-0.01860373137080249,0.8318169131400064,-6.725067450667273e-05},
{0.0022120409367676424,0.8245803365509285,-0.0010678871733580976},
{-0.013719682891846682,0.8447118039669049,0.007715436339856542},
{0.0077760071814029115,0.8393083891805267,0.00782697343937926},
{-0.00973917167010218,0.864688755321009,0.013328503694303927},
{0.012306755701115057,0.8619883801765088,0.014231941807426854},
{-0.0015993180770451246,0.9319089678064952,0.026706498878268294},
{0.020419332276833287,0.9290746985705235,0.027759904818205033},
{0.10104950152180295,0.782393498289309,0.02627519730742502},
{0.12111628981306696,0.7790921488595693,0.018326320014772968},
{0.12589254388183965,0.8024218930323149,0.01491081856017738},
{0.10560393308564708,0.8045101525746347,0.023085248654086465},
{0.12959928109630017,0.8255943079296785,0.01369878207869722},
{0.10916194177439953,0.8263936447499137,0.0216984707166874},
{0.1322761590918342,0.8482090621154507,0.013895830954520684},
{0.11170873033285689,0.8478682914903866,0.022150815620307296},
{0.1338624892932905,0.870290916825725,0.01632238251969261},
{0.11324050649963553,0.86875672402179,0.024433608257205496},
{0.13434829532676723,0.8917173423601711,0.021169301537518476},
{0.11373004282944073,0.8890143151113045,0.029015316838388466},
{0.1337137607675825,0.9124482597210268,0.02891369414771221},
{0.11315498233032373,0.9086126971566176,0.03637428680467594},
{0.13200229833347277,0.9322398983807791,0.03917138940048443},
{0.11156127828728783,0.9273186956546711,0.046130065109595955},
{0.003691245950637848,0.804127220925951,0.0062245571095696},
{0.007286458458586679,0.7806807965540934,0.010234923094953005},
{0.0261114546488202,0.7834396171387434,0.02094868115466254},
{0.022669890691969407,0.8056676474144483,0.017188653992652347},
{0.0008383624120569271,0.8273975901827175,0.004566372229998604},
{0.01993353863636768,0.8277160409948661,0.01565439922366213},
{-0.0012411600574666313,0.850194447272977,0.0048774368075563965},
{0.017934533559688413,0.8492997958046943,0.01595802799458507},
{-0.0025077629666354568,0.8721957474113741,0.00662856927006299},
{0.016707637857949632,0.8701038938958477,0.017571598034346998},
{-0.003080320077518794,0.8936357928649727,0.011401130221540377},
{0.016138773864361612,0.8903764185636871,0.022077709248075682},
{-0.002971249187196571,0.9143568701750482,0.019197573478178055},
{0.016210678114520625,0.9099672408722546,0.029482533355278055},
{-0.0021793357805853456,0.9341125814957433,0.029632488789080817},
{0.016928221061772344,0.9286397658474405,0.03940313870727052},
{0.06370438960637576,0.8199815627935185,-0.04925771409634552},
{0.06432280085817393,0.8351965492205999,-0.05340689419859048},
{0.06519778461790748,0.8342867782788264,-0.06337212678340308},
{0.0648222639898366,0.818862449108952,-0.06211919336543126},
{0.06266092286130759,0.8230463420351708,-0.03697004363225993},
{0.06350734073055228,0.8376130872328371,-0.04389649751262044},
{0.06172150783708303,0.8279675447612785,-0.025613088298636063},
{0.06277367447591402,0.841467375636955,-0.03511480987686545},
{0.060912244214990446,0.8346003090655846,-0.015510305684089846},
{0.062140416396868244,0.8466427218408309,-0.027314648716910347},
{0.060282679253240073,0.8426458518444898,-0.007361900913402709},
{0.061654610363391524,0.8528838546026907,-0.021129296897822995},
{0.05985142725444101,0.8518687554599346,-0.0014132556055246482},
{0.06132742247844717,0.8600073449658637,-0.016745876493569282},
{0.059423868372937255,0.8733248746488758,0.005951910866291864},
{0.060971718275058234,0.8786488626273821,-0.010668343870687212},
{0.05853754500808557,0.9407145243815483,0.023901836545714376},
{0.06008591541667091,0.9460385123600547,0.007281581808735308},
{0.07739001650383479,0.8197758140239325,-0.04828115721797993},
{0.07808647893927675,0.8186654126261395,-0.06117359422868877},
{0.07846326365447553,0.8340897294030031,-0.06242652764666059},
{0.07793283038817872,0.8349932666602143,-0.05243528213163706},
{0.07677283216013145,0.8228332318170158,-0.03596373113434389},
{0.07746437457018326,0.8374037444900438,-0.04290009942355085},
{0.07625477951188156,0.8277470483085333,-0.02457456636498009},
{0.07707396993583171,0.8412504731574164,-0.034094865066785524},
{0.07585081692343243,0.8343722528760941,-0.014443267431989218},
{0.0767715928590256,0.8464209117289133,-0.026269917884714278},
{0.07560166782912077,0.8424117478656027,-0.006267598036974305},
{0.07659686379611771,0.8526569385702174,-0.020062258645722367},
{0.07551742013994799,0.851627079351291,-0.0002941667069800995},
{0.07655470277249811,0.8597743687509829,-0.015657770122669928},
{0.0756738571185341,0.8730773366460015,0.007114970168070483},
{0.07672200842178219,0.8784058604665556,-0.009543058466613616},
{0.07750569286905093,0.9457646887807266,0.008527562747503535},
{0.07645154334845072,0.9404047734631624,0.02527825392586889},
{-0.0535483294372908,0.7818524813915686,0.008184462236360612},
{-0.055674994920879316,0.7774102809358662,0.029865452610950586},
{-0.03484487150650388,0.8122035975163686,0.039078045241194986},
{-0.0328917825357948,0.8189859330711348,0.01777360411459369},
{-0.02796792770532038,0.8315058361694375,0.01951606146935964},
{-0.029616198176044956,0.8267506750054858,0.041164173185612524},
{-0.024075592757254186,0.8432594917870307,0.022252636599160474},
{-0.02535940955878272,0.8388458448288063,0.04399025064127481},
{-0.015880887697254042,0.8970766999922376,0.03263992556856703},
{-0.01753402862132439,0.8923336344070785,0.05428989623647863},
{-0.01181614117934779,0.931595437019737,0.04044664263137185},
{-0.013464399257061254,0.9268415895149574,0.06209598125571949},
{0.1799271626800385,0.7737172999636801,0.04652718675594105},
{0.18163895972544675,0.7785687176445203,0.024904319603213456},
{0.15812390285834946,0.8226057333130226,0.032875231669526786},
{0.15657864309553968,0.8180275691330022,0.05456639670619544},
{0.151817954648656,0.8425490376421041,0.03562763267444879},
{0.14987170662005092,0.8385697533284544,0.05738475331596854},
{0.1434508380188159,0.9002299777258552,0.045139281054535685},
{0.14188903358624352,0.8955483690825332,0.06680838653152096},
{0.13994000952316146,0.9294763560589159,0.051234746364418805},
{0.1383772632217488,0.9247211948949642,0.07289029388730654},
{0.1419675185252743,0.7894946688395662,0.008305331273210056},
{0.1440681091135967,0.7993162664262156,-0.011126897672847203},
{0.13434310265513388,0.8130224037569759,-0.004509537881286234},
{0.13129377749827137,0.8045203644157465,0.01555692819169034},
{0.12545996583085747,0.8329991816089253,0.0028423061036428306},
{0.1215651646735906,0.826323103730971,0.023581093026520224},
{0.1213814134986325,0.851103648136242,0.006823028006575317},
{0.11687547578705859,0.846641023998316,0.028087129882182562},
{0.12266593670179132,0.889419380677738,0.011637303833274194},
{0.11776146454061176,0.879505120547407,0.03248040273022744},
{0.12097705433382946,0.914215800530174,0.0365790813124107},
{0.12634113370310898,0.9286212382959086,0.016592562553769796},
{0.12806008151589773,0.9505989049622179,0.024938028593291434},
{0.1240918145890787,0.9489580579051169,0.04166859352169847},
{-0.0016317877660172958,0.8149153246589979,-0.014178540322777579},
{-0.010698254402875834,0.8014763806466499,-0.02212817358910417},
{-0.011640123243289866,0.791638709324658,-0.002614138377052528},
{-0.0016846935302242455,0.8063786716378832,0.006105038910925487},
{0.007157310890350424,0.8361685330778851,-0.00492973531422147},
{0.007850650287005712,0.8294953055924743,0.016165982720139648},
{0.010759946811923058,0.8548565741029156,0.00012511364313684258},
{0.012010339662627894,0.8503018574998175,0.02182200425091433},
{0.009363936081285709,0.897079153808427,0.004174802652607526},
{0.010193102879137512,0.8973204457337279,0.026524904087234256},
{0.006515637956796236,0.930294220430683,0.0080748460535519},
{0.005840392356285764,0.9506268883811871,0.03312025389115606},
{0.004246452846039827,0.9523276680397648,0.016136512139843535},
{0.110450443134108,0.7885098210368028,0.09923690592095374},
{0.1085410767064118,0.7936240944821844,0.10155283746942124},
{0.11369411549038329,0.797349421213232,0.10795754558423662},
{0.1197528107364571,0.8038656912135922,0.11377846852015011},
{0.12305340419252224,0.7986528933302987,0.11243670199891398},
{0.12579316432616497,0.8152956042033151,0.11875772011005414},
{0.13003789454366765,0.8079024667055407,0.11576883566812188},
{0.1291720940051282,0.8256429133190485,0.12255189001752936},
{0.13774783458311998,0.8258947888757927,0.11900225900425218},
{0.13253258288363692,0.8439160611198766,0.12573215972923155},
{0.14156330807660403,0.8430405072816344,0.12132701437659303},
{0.13784054669884543,0.8672072258491986,0.13511298748458936},
{0.14706926263647646,0.8673838510427984,0.13097139190511195},
{0.0021929433067271915,0.798907235096244,0.10003221501259492},
{0.008095722080679263,0.7950270452990146,0.09441321140585072},
{0.006390022396711598,0.789962133216677,0.09184017444997229},
{-0.004445682891809488,0.8056018405257298,0.10494979897947396},
{-0.007675028927301613,0.8004881371588565,0.10315002394856439},
{-0.010801550150044956,0.8171875708434856,0.1090436690733667},
{-0.01479260782419985,0.8099262330183139,0.10547351523377732},
{-0.014091882192953927,0.8267432887708952,0.11183284014209803},
{-0.020706874919402814,0.8230798155580383,0.1073131090092165},
{-0.023812216486247834,0.834441839633185,0.10805719778615464},
{-0.01810482592463743,0.8481863705122031,0.11601722878875897},
{-0.02623093566843108,0.8463303312110899,0.11009494341540144},
{-0.03224240114936249,0.8701576052057735,0.1190441721676506},
{-0.023784047172112792,0.8696750089621609,0.1245381550788409},
{0.1753840211492682,0.7971387524182558,-0.002227476432040475},
{0.17164878000937422,0.8118059057915148,-0.0170842180884659},
{0.16543364778471428,0.8168152352192569,-0.009685590486792574},
{0.16792096228310394,0.803162995093588,0.006666987604343035},
{0.15986425340123556,0.8229459338595781,-0.0029338780623509764},
{0.1612349204242591,0.8105343828569559,0.014784409847384968},
{0.1550520224213613,0.8300446382006349,0.0028697690161475424},
{0.15545732345500468,0.8190780255363073,0.02179885410625784},
{0.15108627127578694,0.8379563116740906,0.007507233754080811},
{0.15069467691237373,0.8286157859906936,0.027469895966434923},
{0.14591838566456788,0.855828372065035,0.01361450960350228},
{0.14448574119324287,0.8501573797769022,0.035048222228450394},
{0.14027287340717046,0.8862182535284249,0.01970968987413107},
{0.13744172720998546,0.8845325933433379,0.0419281155662657},
{0.12955961106790323,0.9224669061834995,0.02646235656042413},
{0.12789522968280323,0.9177115467313707,0.04810922897557122},
{-0.0290338505864258,0.8223822129655791,-0.019650959394726823},
{-0.03680042668641351,0.814715821966985,-0.0319013021095055},
{-0.04300560732319378,0.8001874579245655,-0.01775221377750743},
{-0.03671119700679532,0.8060195717494644,-0.007879928775630426},
{-0.031038903452501373,0.8132200227113079,0.0011161455584182674},
{-0.022704653087987258,0.8325729363865935,-0.009580249892798903},
{-0.0260879203208208,0.8216607910058663,0.009078667556245267},
{-0.01922960321525763,0.8404299566812832,-0.004227720809825525},
{-0.02192512029942306,0.8311204507045645,0.01557260535067881},
{-0.014499215680410883,0.8582276961849122,0.0028288844726669367},
{-0.016270152174588326,0.8525602978699864,0.024239037983593652},
{-0.011144439979999874,0.8798795381974939,0.007032593823567429},
{-0.012704732465223101,0.8751230509813588,0.02868690204534936},
{0.002044784859527849,0.924137806292416,0.01751470172057936},
{0.00048000610430156516,0.9193858549183285,0.03917192229995993},
{0.1676730896689313,0.7973333474778898,-0.01571726896875977},
{0.1852984299957317,0.8071808464576506,-0.008049713027126114},
{0.17543125091441064,0.8146787544709101,0.003687112881449979},
{0.15630648017969323,0.8059758863854847,-0.002197968672711169},
{0.16486175989642815,0.8288451682323675,0.016655866054254464},
{0.1441776013662948,0.822262707159946,0.012695617405589936},
{0.15947337783246374,0.8414469519547311,0.02308651274121439},
{0.13756062575807668,0.8379181040209984,0.020838222247101884},
{0.15065870000127218,0.8842939411293927,0.03296620876370414},
{0.12941093211423943,0.8806478677040614,0.03067474101906528},
{0.14335179307443968,0.9071155718487571,0.03745991457336369},
{0.12254022199761821,0.9023530244502148,0.03481152811025214},
{0.1378406334499229,0.9294886499258858,0.04165247021431191},
{0.11629786232766365,0.9247359425781234,0.03895203310475644},
{-0.04340364605235718,0.8177316240289354,-0.011872585148211826},
{-0.05171294928561136,0.8104897556241357,-0.024898011560584906},
{-0.033463013594494835,0.8001415170325733,-0.030015085826465823},
{-0.02389703425392934,0.8084786549686639,-0.01502366931887224},
{-0.03456285614686622,0.8313110676076487,0.002353228315246804},
{-0.013746774014019577,0.8240750610970795,0.0013530379647934444},
{-0.029695860451126287,0.8441834527264656,0.010432157865942334},
{-0.008182485551096819,0.8388040555955183,0.010248567800127954},
{0.00032541568436302796,0.8828062716889696,0.021941051515138237},
{-0.021094776165520718,0.886691951590098,0.020756614269284428},
{-0.013865908029320913,0.9093102997490767,0.026283897201187796},
{0.0069716511916893525,0.9039664457738441,0.026596201079851393},
{-0.00838326472324879,0.9315298160261843,0.031258451839900815},
{0.01318428002811553,0.9261748207340104,0.03162156706390254},
{-0.05233445879017402,0.803794778404318,0.02886269690720822},
{-0.06083172682214611,0.7899657271898839,0.02511025426796556},
{-0.04149985647963718,0.7799669343311258,0.024381545217750503},
{-0.03221564463848811,0.7950726267936858,0.028475316167554773},
{-0.04332944909515249,0.8227619348243987,0.0337656323350166},
{-0.02233803064185616,0.8158782368321885,0.033904954565331526},
{-0.036217149620965006,0.8432375561574577,0.03722895841928533},
{-0.014584306094335683,0.8383157957458524,0.03797489375487111},
{-0.03141044592402262,0.8694286111163038,0.042167821186151075},
{-0.009509801821439196,0.8659137672850666,0.04333914662630544},
{-0.00131230833395107,0.9341882160422311,0.05772518932973398},
{-0.023377568802418883,0.9369542245732947,0.056990060699790825},
{0.16737317880132577,0.7770509827592704,0.039229611766435295},
{0.18667778451950695,0.7865104441697917,0.04270462446013179},
{0.17811731213113866,0.8005893013081236,0.045247682722260714},
{0.15801397685026436,0.7924403140659168,0.04200372532673105},
{0.17105514238668112,0.8152127817104139,0.048017508300730365},
{0.15029931507359895,0.808410195975579,0.04502335682909841},
{0.16516914374970168,0.8303332094631222,0.05087730713948168},
{0.14386444236986815,0.8249379368850094,0.048157797185907826},
{0.1609734402839447,0.8453971002993835,0.052889200947661336},
{0.13927327792124788,0.8414178283787448,0.050447777769219715},
{0.15738563879660863,0.8663227986150386,0.05653895509727674},
{0.13536945465193082,0.8641031111904484,0.0544618740509316},
{0.14920152976106316,0.9346874560996946,0.06859687152935662},
{0.12717654657853414,0.9324407271249755,0.06664213428817682},
{-0.05210507654850005,0.804599221145109,0.025820386194604573},
{-0.060603683025666384,0.7907650640101188,0.022066530752101295},
{-0.04127182507616852,0.7807662711513611,0.021337821701886237},
{-0.03198465130537657,0.7958772554296429,0.025433488782382392},
{-0.04310274374386704,0.8235610857494678,0.030721921212163387},
{-0.022098238270893404,0.8167078249924166,0.030867080550686675},
{-0.035986019964731816,0.8440506987920116,0.03418773829165478},
{-0.014352098246140433,0.839133660117619,0.034935817618153626},
{-0.031184050398013634,0.870226237701013,0.039123552377800255},
{-0.009283009719076389,0.8667131041053019,0.04029542311044117},
{-0.0010845743627477618,0.9349873669673002,0.05468302733326302},
{-0.02314956218497237,0.9377535613935298,0.053947576485032366},
{0.16759995851067763,0.7778503195795053,0.036185900643582077},
{0.18690456422885873,0.7873097809900268,0.03966088855125645},
{0.17834111751783652,0.8013937440489148,0.04220542158170129},
{0.1582480932221625,0.7932271711240163,0.03895801892909749},
{0.17128314900412772,0.816012118530649,0.044975024085971906},
{0.15052737126308965,0.8092095327958142,0.04197963331323414},
{0.165397534550491,0.8311317903096825,0.04783323661930779},
{0.1440852238618678,0.8257569414137937,0.045117543713139814},
{0.1612014469013913,0.8461964371196183,0.04984548982480812},
{0.1395012845386944,0.8422171651989797,0.04740405425335545},
{0.15761369498609942,0.8671221230422628,0.05349521918840141},
{0.13559628393332687,0.8649013078536659,0.05141815053506732},
{0.14942958595055397,0.9354865946317527,0.06555394116620006},
{0.1274033758599301,0.9332398656570335,0.06359844795134573},
{0.08025117857380248,0.8315493356382514,-0.0793203085307025},
{0.05812879871736795,0.8334093407029035,-0.08119822149633327},
{0.05548576603503351,0.8361494354478445,-0.04970527529769701},
{0.07706461321248279,0.8399356366492093,-0.040540085934749774},
{0.07555292611662938,0.8563289257816709,-0.020386447421990663},
{0.05330191919842305,0.859084140000103,-0.02065038137849456},
{0.07447532901910724,0.9430102181429578,0.0054334368556660595},
{0.052330455847602285,0.9433146772456216,0.003564149425731722},
{-0.08046224394513261,0.798200759107867,0.06132264497268428},
{-0.09176838793341836,0.7966504925685894,0.06839285778131853},
{-0.0810695014869785,0.8027838433132775,0.08564392917416487},
{-0.07174996956431395,0.8040553662478362,0.07981921397686761},
{-0.06928003006742768,0.801665869785728,0.055035670462920676},
{-0.05926921598794345,0.8080771957684484,0.07293731297126091},
{-0.0557142311938892,0.8084536954443929,0.04839063707766702},
{-0.038247372692499566,0.8230531457982414,0.06286998676135183},
{-0.039718993183602225,0.8217984525726995,0.04103280726839689},
{-0.03227573834910874,0.8313398070002924,0.03950598830604152},
{-0.031986968798444475,0.8312690800861839,0.06155315497836457},
{-0.0222956713300596,0.8524500620366249,0.039466330670655664},
{-0.023728303408373574,0.8486143011840386,0.06130529475720298},
{-0.015904905352684635,0.8830485178761222,0.04549476218372563},
{-0.017592697135673328,0.8781450991208826,0.06710905337280104},
{-0.00867079497280729,0.9197986661166732,0.054003345034793725},
{-0.010319065443531781,0.9150433066645444,0.07565145675104662},
{0.19849823846670298,0.7988811478079667,0.10551736170690082},
{0.21135597504644923,0.7924181925411783,0.08994058610800097},
{0.2012110561943055,0.7942685558432269,0.08134602054621193},
{0.185837699478913,0.8016395842092738,0.09494282673341774},
{0.19113058099966376,0.7980298099133316,0.0735483503814795},
{0.18142437473897607,0.8035894138180746,0.06678796284929725},
{0.17382128724086654,0.8080681116913428,0.08644079978519938},
{0.16907788704440882,0.8137941289485734,0.059411221305152494},
{0.16377862312296312,0.8162303346693597,0.08046216339056077},
{0.15745008245411068,0.8290074175331399,0.054228885443039714},
{0.1540444830153505,0.828988889981608,0.07601332028093147},
{0.14813925042520887,0.850491904324393,0.05322876945065271},
{0.14639482258168465,0.8463223872910016,0.07505433669224623},
{0.13449116195824473,0.9178036391965432,0.06403685071752528},
{0.13302141281181185,0.9130639692964142,0.08571385054255456},
{-0.011090877386206831,0.81767053887743,0.020688477494487104},
{0.004312123411636599,0.7914925337592282,0.014190772224691907},
{0.0029823533251046655,0.7854174425595245,0.03552907105750387},
{-0.014061729997049665,0.8151089654567804,0.04292486065964491},
{-0.023379031177723743,0.8577101268640936,0.03135230411264365},
{-0.025447957622792713,0.8553660136084802,0.053712208419017325},
{-0.024537480279388794,0.8995713387601626,0.04330618121689094},
{-0.02567383264233725,0.8972932182884333,0.06575081653986871},
{-0.017013757624095165,0.9330974823529872,0.0534989494847299},
{-0.018671942503666182,0.9269779374226182,0.07480129619246237},
{0.13791169497532987,0.8130600413315594,0.05744754870299983},
{0.12165414649298768,0.7848176084313022,0.04808319125933819},
{0.12409374789880373,0.7905207357971089,0.026860829044974555},
{0.14510789513438055,0.8335050271412826,0.040256521448729855},
{0.1495818093053804,0.8561318769058476,0.06922965867398215},
{0.15227463710614614,0.8775089534702603,0.05162200317396167},
{0.14875548050706078,0.8971368308818914,0.078915627147612},
{0.14890388681448127,0.9097688659442478,0.05925922102452514},
{0.14327992600331385,0.930859267376865,0.06489308385152799},
{0.141736996126583,0.9247383963943128,0.08620410566700112},
{-0.07415670470480401,0.8123325591894389,0.06567507045628174},
{-0.0830325792246004,0.8101228977107943,0.07081569144317301},
{-0.07575788173350786,0.7917478297870247,0.07623514278586002},
{-0.06430051822429145,0.7945945787851317,0.06957639033736508},
{-0.06555966054080334,0.8159984986114961,0.06125696201407646},
{-0.05320134991368669,0.7993211864516059,0.06384710132521504},
{-0.057505430261146566,0.8210051759348719,0.05769644993709029},
{-0.04279989573264073,0.8057828156662108,0.05922698680276308},
{-0.050213394947583784,0.8271001331313016,0.054717170078728034},
{-0.033391109344335916,0.8136797290634962,0.05546818654884764},
{-0.04387559669947094,0.8339707812828675,0.05192750328955438},
{-0.025227845353390167,0.8226435567827718,0.05220758533946698},
{-0.03882423017821999,0.8419420155674683,0.05149002999920419},
{-0.018702912638300328,0.8329360144315622,0.05161767801310241},
{-0.03259592418280525,0.8597064798364066,0.05261257654783395},
{-0.010947403497187503,0.8549100871246645,0.053481586876237525},
{0.002518904283576719,0.9223035167257098,0.06807912870638323},
{-0.019306477062850887,0.9266867140557643,0.06771621177055845},
{0.19426603758337999,0.7879778882161679,0.09543067761371904},
{0.20274283236108412,0.8061335998442096,0.09113031516957658},
{0.1947481009275171,0.8085786913539247,0.08479129001336903},
{0.18395008278562375,0.7911294557142595,0.08722402569105893},
{0.186967768585255,0.81247382712249,0.07920823853170432},
{0.17390803831827317,0.7961510790089713,0.07999146443756386},
{0.17963976875360166,0.8176951266113692,0.07455466287939554},
{0.1644484281916191,0.80288917151426,0.07395979834860773},
{0.17298842732571942,0.8240848887548488,0.07097432198471643},
{0.15586256252359282,0.8111379968535508,0.0693136585029338},
{0.16724553078742763,0.8313409347642987,0.0681710228833789},
{0.1484391117207702,0.8205367696889205,0.06578908615801606},
{0.16258577102260088,0.8392353943453947,0.06621912364173142},
{0.14235045017395795,0.8310050965576359,0.06430192483104655},
{0.15680812448130216,0.8569202459112962,0.06709778812574924},
{0.13505095426773817,0.8530820312425206,0.06468362957163538},
{0.14334999608783622,0.9245506174907607,0.07861695558111229},
{0.12158222984981765,0.9206853612718563,0.07632421135633445},
{0.10796729268743382,0.7880347969229466,0.14521836023844673},
{0.10527429138451318,0.7916313354830787,0.1468839809246526},
{0.11181236069132452,0.7994885416729339,0.14617923995782384},
{0.11564347416476392,0.7964508039814108,0.14448711062096478},
{0.11769935076918867,0.8120256462705856,0.14295803613059685},
{0.12443881889870491,0.8101073940539607,0.14012385364570257},
{0.12145667625478822,0.8223266179179728,0.14052598206851513},
{0.12987985886665504,0.8216736549513445,0.13667525045857082},
{0.12319764644822716,0.8299589777082015,0.1396984015760787},
{0.13286109682076447,0.8306870299288303,0.13557107035232915},
{0.12518430808589256,0.8420670114770001,0.14069294071348956},
{0.13459635383610571,0.841699967668493,0.13634976041614144},
{0.1360086118042402,0.8603333555147576,0.14376831597959616},
{0.1267860428000941,0.8587121761662059,0.1475792412380219},
{0.10763763859328888,0.7885145551670271,0.15001941272234665},
{0.10609593562465279,0.7911430756334125,0.1421188681728211},
{0.11034052951903392,0.7956491992401521,0.14171858630865622},
{0.11530800774843272,0.7972497566183031,0.1497667192268724},
{0.11399729811290815,0.800916266118869,0.14021526449526697},
{0.12310199718888094,0.8212612155433318,0.13193406861109253},
{0.12989739497730224,0.8239617889760087,0.14483599866827182},
{0.12501534177312676,0.8309462793271545,0.13016041804749337},
{0.13336269155032923,0.8400057934848092,0.14600047077331108},
{0.12660635653276298,0.8410708240691184,0.13057107286191388},
{0.12720491418084603,0.8488219336913059,0.13278878979774614},
{0.1282484181049474,0.8635195366927344,0.13903673871568786},
{0.13502122343420986,0.8555123750690761,0.1523592256031231},
{-0.0012858244693198962,0.8010577075540749,0.13814301672323448},
{0.004861133801509509,0.7930329602477252,0.13974560655519894},
{0.0023317450305776204,0.7895096148109022,0.13770943483835651},
{-0.004929927405892869,0.7981398598515275,0.1359129563483884},
{-0.006313396409339405,0.8137570738455099,0.13414250318164223},
{-0.01263518288716517,0.8120220522973787,0.13037940255288963},
{-0.009397136957910222,0.8241431359068215,0.13122637810763196},
{-0.01721155008058211,0.8237344887601925,0.12621856062723905},
{-0.010976998007594151,0.8330214890288294,0.13008950523821905},
{-0.01919617926443402,0.830629724645698,0.12492853492717039},
{-0.020703330518240172,0.8387132891825291,0.12479206308939882},
{-0.012823110506849866,0.845822019469532,0.13180687913860345},
{-0.02184144268875892,0.8497566765503615,0.1274736380361239},
{-0.014722302272467347,0.8609207098808442,0.13842576327052455},
{-0.023284621219483284,0.862782040997679,0.13336569685551078},
{0.0006896710653821118,0.7971795997827033,0.13392338235312434},
{0.004707485250411474,0.792559448081218,0.13491109294144218},
{0.00199216413457522,0.7899905008189888,0.14250924802115061},
{-0.005318014547176614,0.7989306950661768,0.1411923047010638},
{-0.002566902415404644,0.802538189048084,0.131931404113715},
{-0.007153679738110416,0.8136018142029743,0.1266181732688068},
{-0.01730444809147351,0.8235510598035218,0.13480271605973929},
{-0.010312819365958516,0.8273964500257003,0.12132006189738946},
{-0.02081362831665713,0.8370571243637607,0.13447073207951546},
{-0.012071189346923094,0.839301387129279,0.12045719850247069},
{-0.013458871974129392,0.8526234650473495,0.12378229294139757},
{-0.022120136721432954,0.8469189992363488,0.1370119809620299},
{-0.014827642866461082,0.8657501919321112,0.12977173604167883},
{-0.02363536821844909,0.8579599327879915,0.14198751464861653},
{0.10378714245055472,0.8475906880426854,-0.08161586596899054},
{0.08208192373934622,0.8474838478943537,-0.08664627590854233},
{0.09687104912743874,0.845640672538719,-0.05081984074720536},
{0.0736924872965905,0.85003975770895,-0.047829407178890844},
{0.06950657430956941,0.8631651585415288,-0.025672054245250413},
{0.09086477631814069,0.863822483848049,-0.018997599851744894},
{0.06595703004736966,0.9443857556193274,0.012838050281680438},
{0.08761240406810257,0.9429557632523687,0.017631332347646935},
{0.06130150869232473,0.8476723827715805,-0.08803434271909144},
{0.039100569538793074,0.8486627206782424,-0.08643302936726595},
{0.04107318989492965,0.8465740769525801,-0.054948398879049676},
{0.06366335634676241,0.8500609373648483,-0.048395532317034966},
{0.06487129074158239,0.8631161813618272,-0.025816085819767402},
{0.042777798993924226,0.8646479079565615,-0.022538245932004958},
{0.06560865011351596,0.9443012228909001,0.012917824093861295},
{0.043432992702542805,0.9437524479682372,0.014290771430919547},
{0.13685201817179782,0.8437080444292668,-0.07092571659534663},
{0.11666221685277121,0.8471396815842598,-0.07970238506162311},
{0.10358073685138242,0.8457274731881698,-0.050623287591824224},
{0.12072674029647837,0.8470360512257924,-0.03404642078655949},
{0.11167833027673148,0.8621228319534777,-0.011715664842194419},
{0.09168822993789479,0.8641121828745428,-0.021207298509422528},
{0.08250427755620561,0.9438897377447386,0.013653894592644858},
{0.10273818560158786,0.9419650535553746,0.022736955471310206},
{0.02760480008830764,0.848786576430757,-0.08612072548860236},
{0.006252683048165941,0.8461228845989888,-0.08033850592622326},
{0.03632464659888286,0.846973466519949,-0.05545843324914493},
{0.01703729195209448,0.8489539316520854,-0.0415164817039716},
{0.023340637629465883,0.8637553509071475,-0.018082165303917753},
{0.04454553809124866,0.8649873525294423,-0.024602252351683833},
{0.05156538570294289,0.9444617743491577,0.011424416689318515},
{0.030181455803415025,0.9433061632470247,0.017507997101596937},
{0.15227354652117306,0.8394076695921132,-0.051524395818868224},
{0.13840880343489156,0.8413179778886498,-0.038164482038037614},
{0.15452864077835643,0.8375803696836436,-0.02322728495382312},
{0.14044216193822384,0.8457569685544878,-0.008863314203089015},
{0.12501675457638733,0.8495091385474871,-0.024481172633646405},
{0.13167212373286338,0.8572993976916068,0.0001893590124619238},
{0.11609027939244079,0.8614394193586801,-0.015219615216711523},
{0.12086554202032888,0.9050318481484848,0.018559853915151407},
{0.10584386177973149,0.9084969588263461,0.0025478853399360435},
{0.11466572755733673,0.9377473153159566,0.031003155812104385},
{0.09966890769692185,0.9410724965059606,0.014939334878622021},
{0.1672740347128612,0.8360788944289022,-0.03546553208980909},
{-0.011989630941149822,0.8417003394588248,-0.06320109083779055},
{-0.02899234639239229,0.8372583248982884,-0.0495014102657916},
{-0.0006029323809866097,0.8430575352788281,-0.04869499703624238},
{-0.0039061779414180774,0.8498194595443817,-0.01578836767319997},
{0.01202162969570183,0.8519060088511751,-0.031203823447156807},
{0.021161797569322842,0.8692686297365553,-0.018385595786663756},
{0.0075852415621859475,0.8841366118540103,0.002291858124487181},
{0.028218774642147032,0.9095319239658282,-0.0029896590051234065},
{0.016285036180869104,0.9391205724782911,0.024008540370924435},
{0.03348900173868371,0.9419970151308934,0.010234947880975115},
{0.08787819697626523,0.8393989696983506,-0.06467214125038453},
{0.09067780296030742,0.8401969804664023,-0.07729938021746152},
{0.09137550469685515,0.8556163896108867,-0.0761133814522144},
{0.08921542765545404,0.855038862902569,-0.0663204117211091},
{0.08526702672536106,0.8406073378485573,-0.05229524110668077},
{0.08720276548058882,0.856018034706268,-0.056731951458484205},
{0.08291979043096084,0.8437861451849549,-0.04052807710703448},
{0.08539835546354349,0.8585213733679555,-0.04762306354477382},
{0.08090590134800081,0.8488399035573397,-0.02970526055001386},
{0.08385295937761206,0.8624772101046834,-0.03925655417247556},
{0.07931090843181496,0.8555148412782768,-0.02054930398030487},
{0.08264091050312089,0.8676599301501392,-0.03228051585487167},
{0.07818315681854084,0.8636137111837647,-0.013332841248174255},
{0.0817981733581604,0.8739184626995243,-0.02690691865309954},
{0.07715344631574711,0.8835800789064252,-0.002817891871858414},
{0.08096910570439708,0.8912947035040575,-0.018080603784524415},
{0.07892334179699566,0.9548381946478662,0.009936053240276363},
{0.07509704920485792,0.9470863290520043,0.02527684112260827},
{0.051890132164708794,0.8399157830454944,-0.06723749453940696},
{0.05145018027214691,0.8555891497725808,-0.06904563485278072},
{0.05086027294578239,0.856208837504518,-0.07905423058328555},
{0.05111684545371777,0.8407695871493297,-0.08014481555639652},
{0.052596570974052424,0.8410744180423253,-0.05460405906680092},
{0.051988036952067614,0.8565297545258672,-0.05925886162720446},
{0.05321498222585059,0.8442085981459027,-0.042608863663686006},
{0.05245649277006298,0.858999805559853,-0.04997525704359727},
{0.05372554949542136,0.8492252890222131,-0.03159519473637095},
{0.0528419278069803,0.8629270764060918,-0.04146373704890842},
{0.05414195466697282,0.8558729992978552,-0.02229176133507083},
{0.053159188890067176,0.8680899552408434,-0.03437493472368706},
{0.054450528249307906,0.8639544694158175,-0.01497367591226396},
{0.05339836161047701,0.8743335418188929,-0.02892574015446066},
{0.05462530688426007,0.883909683428526,-0.0043925354638869206},
{0.053533470217032204,0.8917035365458523,-0.02004613533833581},
{0.05481265203242501,0.9474482669399554,0.023715433266389804},
{0.05371808890276439,0.955242120057282,0.008061139383321663},
{0.11862155190105352,0.837521366557996,-0.05686082638047717},
{0.1207593587015833,0.8530981049778629,-0.05824016851124139},
{0.12491720151855783,0.8535207562269874,-0.06737505696215162},
{0.12397783606637754,0.8381225267384014,-0.06864534059560476},
{0.11355034416909852,0.8389205375064531,-0.04529566846107759},
{0.11682579220572681,0.8542259185561922,-0.04928373941956749},
{0.1089066581396141,0.8422765401149591,-0.03428199953376253},
{0.11323057969777797,0.8568693726009027,-0.04076477122523275},
{0.10482686650628338,0.8474902798670928,-0.02413957167684151},
{0.11007285287319045,0.8609490774831561,-0.0329274310321034},
{0.10145101029406252,0.8543040193118804,-0.015567325927968058},
{0.10747033294400482,0.8662397778339606,-0.026407467914447896},
{0.09887699429031054,0.8625144634959243,-0.008825503126350824},
{0.10549732840452544,0.87258491274462,-0.02140440935030128},
{0.09596354610668882,0.8826230410204761,0.001074393504163607},
{0.10305450481583424,0.8900801016692884,-0.013105181635037329},
{0.08905851974244769,0.9465029404494562,0.027597271334089856},
{0.09616882394185489,0.9539632232811436,0.01342694138113825},
{0.022039098822124216,0.8393072490235095,-0.0638219806918003},
{0.01845257381492718,0.8400731247138878,-0.07625093148194802},
{0.01790853302248852,0.8554987675429345,-0.07508598844248857},
{0.0206957088164395,0.8549484806729224,-0.06545166164593773},
{0.02544841616420185,0.8405502184605907,-0.0516446080261316},
{0.023342855978445227,0.8559546940267502,-0.056020580230739386},
{0.028583835568884882,0.8437611856606839,-0.040070774998991365},
{0.025775616442157315,0.8584854460288984,-0.04706661734826606},
{0.03135861835177772,0.8488486034511028,-0.02943385360784192},
{0.02792452738059502,0.8624673700539035,-0.03884758480755893},
{0.033718284836269236,0.8555556886427242,-0.02044893298374549},
{0.029758717803212934,0.8676773299376646,-0.03200786961159392},
{0.0356007584299694,0.8636842522027072,-0.013384891894618178},
{0.031226013133456278,0.8739579840117888,-0.026756950826285732},
{0.03780417383104056,0.8837081111036663,-0.003112064775344049},
{0.033097233873115674,0.8913809340749996,-0.018143448743599945},
{0.0431803611721238,0.9473512544493928,0.024290419407440443},
{0.03845506716482192,0.9550303234982995,0.009267252005516056},
{0.09982010243183041,0.7775974897609096,0.1431797099193927},
{0.10834280092249358,0.7779134743638574,0.1226556443061076},
{0.12253771860938446,0.8000598223036782,0.1180380207788783},
{0.11402126619629446,0.7999060746084917,0.1391408400085757},
{0.1340037572263415,0.8220412688383603,0.11600680626645914},
{0.12556907390021277,0.8217067442908694,0.13656681161181264},
{0.14144326937149543,0.8436397837243587,0.1163327424572866},
{0.1330532256711979,0.8433014793084955,0.13691133731922725},
{0.14124121371920453,0.8796906315299355,0.11536647177809922},
{0.13261058449523652,0.8800236317370662,0.13580816104688126},
{0.13456146750997725,0.9072766933855232,0.10984005635696993},
{0.12630397945595687,0.9069506704436183,0.1304719411664603},
{-0.007908624792735386,0.8018803060560659,0.1087655699052234},
{0.004869833695272242,0.779358598597318,0.11530039224313754},
{0.010392134636730303,0.7788466928825528,0.13682209524659802},
{-0.0024705591474391635,0.8015333017464397,0.13085983001956714},
{-0.018357135236768858,0.8241692355881098,0.10517655390280364},
{-0.012927769485235368,0.8236399424788303,0.12672180362727448},
{-0.025193144922427538,0.8460725813671042,0.10490018975620848},
{-0.019809633311808968,0.845540822048624,0.12645659319063157},
{-0.02564373001847718,0.8683770145559818,0.10517318300379583},
{-0.019959588745611684,0.8670092351045349,0.12670073550847574},
{-0.011087196661922628,0.9091733817629069,0.12132027257857744},
{-0.01569514124751552,0.9094801087865945,0.09956996809313963},
{0.1625188239768651,0.8464108857829673,-0.03754261313615426},
{0.15881582945174416,0.831069577394171,-0.03733439815736745},
{0.14981725172946175,0.8330351089479825,-0.02858121444704607},
{0.1555489821647902,0.8479774119527529,-0.03076610229658544},
{0.1415796172791565,0.8369092509558156,-0.020141573916494068},
{0.14917529375665323,0.8510210115385064,-0.024238703372295084},
{0.13435326492420147,0.84250951632984,-0.012528547223515962},
{0.14359597257131704,0.8553847394481889,-0.01841770607831525},
{0.12835503517908003,0.849639240377575,-0.006089151070749032},
{0.13897832425806558,0.8609044378573248,-0.013600542680039832},
{0.12376093358683904,0.8580641208319568,-0.0011121054368133192},
{0.13546116293376056,0.8673959466215911,-0.01002762519898451},
{0.11854345114536552,0.8785051408781417,0.007145370224195952},
{0.13108893341849231,0.885176298730706,-0.0031073678241530294},
{0.10609791850642208,0.9434563169690047,0.030346276653981943},
{0.11869133694632157,0.9501166929019479,0.020146593085972598},
{-0.01298232351991302,0.8353079252109787,-0.0401538081730805},
{-0.020701917714979593,0.8335753698720485,-0.05009548164387169},
{-0.023910455884905257,0.8490135048562416,-0.05079568676865317},
{-0.017929576355265105,0.8503990558855458,-0.04309838760048012},
{-0.005914576920479339,0.838968944607646,-0.030627300572734946},
{-0.012460552968345768,0.8532779523543377,-0.03572950322534618},
{0.0002968126148409895,0.8444491340975289,-0.021789856780229672},
{-0.007659525270468001,0.8575645213771725,-0.02890218104043925},
{0.005495668360694214,0.851515517465746,-0.014192928608616005},
{-0.003662754418215315,0.8631339653326954,-0.02281473400871072},
{0.009558097385532644,0.8598696710060195,-0.00840661935258773},
{3.6373487455472585e-05,0.8704737757038871,-0.018432850337828204},
{0.014175745698783992,0.8799625589785719,-0.000274325496276104},
{0.02501462359813595,0.9445882822060383,0.024583018398521703},
{0.01418033111287553,0.9515761806352249,0.012718643620135852},
{-0.05341619515338956,0.8232188031770549,0.01814767476037076},
{-0.060990357363689504,0.813347658332195,0.006917326427716236},
{-0.06610867093067625,0.8006844300610054,0.023620614338784436},
{-0.05767822601432938,0.8116903657494203,0.036132635482054455},
{-0.04668263849014802,0.8345273142304526,0.027912326461208344},
{-0.05022207005532442,0.8242261566878997,0.046951709349735554},
{-0.042576821533595294,0.8426297781091475,0.033344183207964506},
{-0.045667626098469215,0.8332421713767407,0.053031720574829244},
{-0.03850260675524071,0.8513334021682477,0.037426850019860736},
{-0.04075274380800087,0.8436446913567379,0.05803616715621436},
{-0.03013301152318899,0.8792846240946619,0.04741522035631878},
{-0.03187795987317756,0.8740497046866295,0.0689431198653083},
{-0.023197349635612312,0.9135108240961353,0.054466880827399054},
{-0.02474482774740152,0.909291388014202,0.07623553936221389},
{-0.016767124311028364,0.9461646360335927,0.062061293217767925},
{-0.018415431960786023,0.9414107885288131,0.08371063184211558},
{0.1924083004397518,0.797075597633904,0.0419982104368102},
{0.190057321456012,0.809842840446904,0.024763262351350408},
{0.18123966930216653,0.819956219085905,0.03483952392223235},
{0.18261374440323097,0.8083196154577555,0.05319960869563305},
{0.17087540654730585,0.8358960355507401,0.046480787322539595},
{0.17112813722181322,0.8260160049169518,0.06613283110573401},
{0.16252767258676057,0.8536052765624036,0.05424306304769015},
{0.1618011323134807,0.8458354411005078,0.07498105681785981},
{0.15565435993781712,0.876585376714168,0.06021100427378563},
{0.15419198463296374,0.8713457355689224,0.08175749329936227},
{0.1512300302040607,0.8985619032234597,0.06402309447525081},
{0.1496672839026479,0.893806742059508,0.08567740269703275},
{0.14218654020970375,0.9439451468971792,0.07336067062201594},
{0.14062380630130208,0.9391899733402165,0.09501513995294163},
{0.1943255116434477,0.8040118667790224,0.019881655295572974},
{0.18662818768925252,0.8158632908608525,0.003574931345352261},
{0.1790362539010953,0.825103594263823,0.015335242009883416},
{0.185882946362286,0.8143026265852974,0.03296736131373254},
{0.16956147472890612,0.8400001298787558,0.02896617854954318},
{0.17540212733842414,0.8308057797607886,0.048075755452703345},
{0.16125368344300103,0.8568014960793374,0.03833607566914778},
{0.16611668858918033,0.849626190536931,0.05872935783673697},
{0.1532897858209466,0.878944993626615,0.04561451584957985},
{0.1572914643055783,0.8742195137241472,0.06695899879490981},
{0.14720475542637446,0.9003402259522277,0.05026484453299141},
{0.1510738782647289,0.8960721844809247,0.07173154735337614},
{0.13860645956825687,0.9402508398728101,0.08275475889920592},
{0.13474115377730833,0.9445052614249602,0.06128547833252111},
{-0.04832239496227571,0.8282835293642263,-0.0008204111355393163},
{-0.05443320281984869,0.8192279933631211,-0.013560885044653961},
{-0.06468470156709188,0.8076269452836974,0.001468119465478784},
{-0.05790418778495132,0.8176907766644879,0.015620727412617334},
{-0.04017697690725353,0.8435367234443999,0.014552239178222907},
{-0.051473751779179386,0.8294015028917758,0.02796933431207552},
{-0.047249370885834016,0.8376159252323693,0.03484927722193506},
{-0.03490168106919413,0.854766365375424,0.02151882162838948},
{-0.03960002027744468,0.8564652612963207,0.04612633481326747},
{-0.02566410412865665,0.8815487404638956,0.03330577726669551},
{-0.032772698092537744,0.8769783343087973,0.05385958610652},
{-0.01634744738455755,0.9148434321821995,0.042030382693516985},
{-0.023179627629799266,0.9112896247241958,0.06288198319605606},
{-0.007675648577854537,0.9464931127916872,0.05116162759917614},
{-0.014655367619742671,0.9423897744373463,0.07185919536727435},
{0.12024627565076774,0.7767968268884913,0.1530904008625387},
{0.12362090495489378,0.7719660187850409,0.13165420963537894},
{0.13156854294644005,0.7943292568113893,0.12460506494554346},
{0.12818521374855119,0.7975094025929809,0.14649112247411147},
{0.1370673095598987,0.8185725641872925,0.1200494064736046},
{0.1334746004401836,0.8168349029278058,0.1428773328425866},
{0.13861519664105285,0.84230641966462,0.11978171743475007},
{0.13507577746888752,0.8376552606494676,0.14236550148588795},
{0.13775015207618788,0.8636161773929651,0.12490994541058327},
{0.13052143265612076,0.8771175078229797,0.15162961186310078},
{0.1331387002684655,0.8840980324105867,0.13042980492886286},
{0.126051149637361,0.9038834373857771,0.13311413112404283},
{0.12266291280709321,0.8980252362726009,0.1543557520775907},
{-0.01793330665159359,0.7964161903015257,0.11397683105514575},
{-0.011685989777215812,0.7738561016875307,0.12203475445209783},
{-0.011244810976559275,0.7786335826643983,0.1437435919225353},
{-0.017592498847496457,0.7995443226157064,0.13612808662734557},
{-0.022056449037605487,0.820793379375889,0.10873830528089562},
{-0.021778845589904543,0.8190025768849856,0.13184135649536702},
{-0.023555755515411957,0.8448549556376368,0.1087423330094895},
{-0.022739353518949887,0.8399640042515215,0.13155879584324282},
{-0.020753212387748923,0.8696373837805884,0.1391506552733337},
{-0.017815597832563947,0.886206145556621,0.1196999359547778},
{-0.010661100155723737,0.905897376040781,0.12380697981942529},
{-0.010473978081757807,0.8999896276693947,0.1453038968007696},
{-0.054069133333995496,0.825809314278525,0.04768228974462038},
{-0.07338956492729781,0.8081301387116887,0.03917261630857919},
{-0.07621021424411668,0.8014862206974299,0.060155223331013224},
{-0.056345816216442086,0.8198900404068545,0.06897329684723472},
{-0.044176461828927954,0.8394456789570285,0.052386998960554786},
{-0.046094763617597,0.833618869340862,0.07373238659569198},
{-0.03475559225484146,0.8564875811092363,0.05571356816779761},
{-0.036592224100637775,0.8511115920563302,0.07719685283697804},
{-0.028254231046784147,0.8762122727232532,0.061066122036793104},
{-0.02992603584550795,0.8713457355689224,0.08268696912871822},
{-0.02151358558121745,0.9092507265449206,0.06780176072589238},
{-0.02314695965265014,0.9046075114498564,0.08947437342500708},
{-0.014843753780836593,0.9431297363416021,0.07567005866064479},
{-0.016492024251561082,0.938374562784639,0.09731815798388663},
{0.19657644184891557,0.7969101261502562,0.07952046805230155},
{0.19710904389214762,0.8037722726962366,0.058418863337687844},
{0.1706913083680381,0.8321646734233072,0.06663920953756713},
{0.16962699657837021,0.8262618450773109,0.08802694409148977},
{0.1576506261590525,0.854367744174741,0.07030847028658796},
{0.15875271184642534,0.8443161942679088,0.09109418954234229},
{0.14570961300028346,0.8895810599000014,0.09862107241545566},
{0.14731755661302506,0.8956073722081808,0.0772154547465762},
{0.1382755785660172,0.9409917436459064,0.08655486505897793},
{0.1367128818366487,0.9362354423249372,0.10820913610172668},
{-0.054398440423830796,0.8261846861904634,0.047886613317934944},
{-0.07369815090264402,0.8085255501225076,0.03938577609877815},
{-0.07652002712755758,0.8018816321082493,0.06036962242231799},
{-0.05665286545841705,0.8202873355553546,0.06918715064605294},
{-0.04448683239786651,0.839838438263481,0.052599489528156615},
{-0.046395653533076106,0.8340273305923254,0.0739493138612526},
{-0.03506419062319869,0.8568829925200556,0.055926727957996566},
{-0.03690204937708974,0.8515081436241665,0.077410012627177},
{-0.028562804629119233,0.8766090101862556,0.06127928182699206},
{-0.030234609427843125,0.871742274743748,0.08290136822002299},
{-0.021821774980209742,0.9096512438762956,0.06801608545913079},
{-0.023464183556703766,0.9049637733387428,0.08967870939133268},
{-0.015153554271266415,0.9435249618572553,0.07588321845084375},
{-0.016801824741990993,0.9387697883002923,0.09753131777408558},
{0.19686231143499225,0.7972977919291641,0.07977630937258455},
{0.19739526048253395,0.8041601243703103,0.058675708491866534},
{0.17095860083053868,0.8325774846216519,0.06690103668219116},
{0.1699030880787221,0.8266648162248753,0.08828558623227188},
{0.1579179186215532,0.8548004089768007,0.07057178459253896},
{0.15901896329599713,0.844748103096294,0.09135745427624906},
{0.14618870202176676,0.8884309389017674,0.09860772514254612},
{0.14760508686258356,0.8959954097774201,0.07747199007547845},
{0.13856178276339248,0.9413784551629628,0.0868097397243984},
{0.1369993710732783,0.9366221538419935,0.1084646799897443},
{-0.057935789963149416,0.8311393624394393,0.011861481010303787},
{-0.06306494741481199,0.8208590003694418,-0.0005705308535752618},
{-0.04401688941854414,0.8101960784410924,0.001649057426926738},
{-0.03847349557226525,0.8213185208264644,0.015121041206755573},
{-0.05166910281248789,0.8467435141997663,0.025033330848328067},
{-0.03167311579339859,0.8382208652811473,0.029239803840694512},
{-0.045933951906107336,0.8650480534976047,0.035352991156390685},
{-0.02550587016346708,0.8579803564702151,0.04044555204639874},
{-0.0404390147330656,0.8892745187714799,0.04311112761584784},
{-0.019796013392656093,0.8833053134582564,0.048731097877454575},
{-0.03618326712873221,0.9114878013640254,0.049115541473487255},
{-0.030395718571598132,0.9337841047376491,0.05564046179556599},
{-0.006903402879792492,0.950588693121106,0.06749016324885909},
{-0.021276978214096597,0.9559402803352388,0.06237607569864315},
{0.17391914245618117,0.8071547467763623,0.017141560550631645},
{0.1933786732055994,0.817278721439818,0.017658349111753548},
{0.18679256858792687,0.8277897918036725,0.029302946232035422},
{0.16681229590685925,0.8184963471692854,0.029708755379132232},
{0.17900855552138048,0.8440304610049538,0.04246049453529868},
{0.16052478849762014,0.8312938537152892,0.040466446663042666},
{0.15489544911965347,0.8451471084803199,0.04904456669915763},
{0.17228573120571522,0.862935404509523,0.05170563121258159},
{0.14865700564119333,0.865707262541806,0.05706532345594655},
{0.1666841397795077,0.886487342977529,0.05824671202108007},
{0.16226727063840823,0.9087166993054168,0.0632225059608989},
{0.13182481802211,0.9486728947206705,0.07731416507965382},
{0.15623807075865268,0.9311790318481855,0.06890718013323988},
{0.14687760472046327,0.9535918171327441,0.07432912247114956},
{0.11013979991892615,0.7891873841303813,0.1588903300377198},
{0.12052013640912919,0.778806985675123,0.14037393221584354},
{0.12948401370044899,0.7994501481246761,0.13008526682843718},
{0.11905903758441481,0.8081499923154036,0.14924734052643937},
{0.1361155015246161,0.8219408482697566,0.12368551591804504},
{0.12611190017756774,0.8253242766117341,0.1439233029758885},
{0.13913447619739738,0.8444837477774141,0.1231303090226431},
{0.13072825961766904,0.8455941491752068,0.1421882814277574},
{0.14033532178989216,0.8660735503766387,0.12450717255119569},
{0.1326259022569043,0.8779236484062856,0.14423807306375266},
{0.1371577909336338,0.8875593632200749,0.12374129686081746},
{0.1367463553595166,0.9079162347211753,0.12125897674588418},
{0.1284293932454285,0.9076386312734747,0.14170620569060918},
{-0.06219101706101835,0.8334774155126455,0.0391310749355125},
{-0.07350833954527845,0.8155773717027317,0.022455981124601433},
{-0.05395768298555018,0.8058667783161294,0.020114049038934077},
{-0.04159689375622192,0.8254683701513061,0.03827577127733916},
{-0.054689341572397084,0.8490755194835761,0.0481259967195328},
{-0.03475063505041824,0.8395946925219908,0.04624654702053083},
{-0.02821840285181526,0.8572054090957426,0.05417588053474431},
{-0.049012524569066955,0.8652817856861599,0.05442717361996898},
{-0.04409621708232691,0.8855579043272063,0.059803274209974826},
{-0.022247165084778343,0.8814487164716458,0.06043565238523543},
{-0.039627272508761406,0.908001709318443,0.06477535024647622},
{-0.03206753576333305,0.9305073430418486,0.07037823054583386},
{-0.008978563009423613,0.9486553090379791,0.07621406227405024},
{-0.023119769386388767,0.9528978209065025,0.07605422961043418},
{0.18115916430233317,0.802870445674551,0.03658619490075804},
{0.20044519289693827,0.8119496275407553,0.041788780942939724},
{0.19183176517231884,0.8228725548411032,0.05163547437698181},
{0.17187626612035628,0.8146405592108295,0.047199123422499045},
{0.182093944340422,0.839382895963008,0.06259042521790369},
{0.16133405211971275,0.8325224472595428,0.05907556899365547},
{0.17386700505865982,0.858984871981528,0.07017724069249395},
{0.152532572845298,0.8535447738824182,0.06727462400053696},
{0.16783789192998172,0.8827037814875196,0.07528090572041005},
{0.14591010713318112,0.8797214529484371,0.07277538588877604},
{0.16336401493801503,0.9051661140302882,0.07920453302139795},
{0.15571757668722436,0.9278850562600254,0.08372674275649107},
{0.13254823525660328,0.9466801357215648,0.08627443600475572},
{0.14668178275273452,0.9505270378910922,0.08812503477401447},
{-0.01650317796151337,0.8014886745136195,0.11970735936840159},
{-0.009660984163336736,0.7806238754543036,0.13112007085877575},
{-0.0017195302843085215,0.7907501180387828,0.15093897414285612},
{-0.008655898573515489,0.8099320949125444,0.14016945992639632},
{-0.021534715665071404,0.8241406820906323,0.11247851601822395},
{-0.014403814281285817,0.8272860159041616,0.13393453606307662},
{-0.023846024620414245,0.8468656721097657,0.11195677025267882},
{-0.018192332975718532,0.8477790370247461,0.13201361934907432},
{-0.024656515150601653,0.8685882410364557,0.11360132282008593},
{-0.021453355547475177,0.8683573468474326,0.1340863132695049},
{-0.02075150215222291,0.8897641046733296,0.11251694674551505},
{-0.019455156016514676,0.9102026709033246,0.11056628680497338},
{-0.014124934353445855,0.9097342646573736,0.13198512781665178},
{0.10133948558755092,0.7780076488548877,0.14005667113275672},
{0.12156739541558106,0.7694169251265269,0.13865254297987634},
{0.13318210059319088,0.7888218398762119,0.13152408301926913},
{0.1123444918001364,0.7960049034435411,0.13314138335535955},
{0.14461962289170335,0.8129348471338504,0.1252718213334792},
{0.12277570160073271,0.8163888041017594,0.12903062158739464},
{0.1496896037155635,0.8387359807857762,0.12374748097333545},
{0.12752099792788238,0.8384668789436613,0.12875921464522272},
{0.1484986353528821,0.8619505567067592,0.12890421287460224},
{0.12665840717920687,0.8592104619618182,0.1331959126040151},
{0.14445231724241928,0.8827856621115803,0.1357228599517685},
{0.12301732813733211,0.878384879098834,0.13877400688125657},
{0.13834501660697562,0.9030432532010944,0.14005545661767302},
{0.11737234877941015,0.8969757093451254,0.14209906414115028},
{0.12889037607775589,0.9237246233037396,0.14591735084814453},
{0.1086315580801469,0.9160682458580804,0.14679477603105653},
{-0.020661020778487894,0.7909694867275217,0.12058849006161997},
{-0.010714377710262459,0.7712633102720257,0.12924872618900576},
{0.009341207299005163,0.7792916515515823,0.1335168791974083},
{-7.127220659497068e-05,0.7975736975343503,0.12515035743209896},
{-0.030425461798137543,0.8153774848273759,0.1128292382311676},
{-0.009244578991785274,0.8182329337192457,0.11964663361421701},
{-0.03453746286720822,0.8414140485103722,0.1110632341553913},
{-0.013316897639448004,0.8405390647506386,0.11915958827963448},
{-0.03347043700811864,0.864701805161653,0.11679252316754135},
{-0.01254233444831805,0.8613654702616965,0.12412422850950106},
{-0.0297971733165261,0.8852195999113428,0.12333604539921827},
{-0.009139250790802652,0.8802301364803269,0.12937887759113773},
{-0.023831128221122443,0.9054127101643217,0.1289389256985759},
{-0.0035338794962223538,0.8987689780452294,0.13391595893950056},
{-0.014702448668752324,0.925728721907964,0.13571046694071043},
{0.005009862327217493,0.9175158239077303,0.1394283702581342},
{-0.06742933215408047,0.8333832410216149,0.06157313251219019},
{-0.07681995038817419,0.8228095859519169,0.057014834328895925},
{-0.05939413753940892,0.8102382518577229,0.05502699535518002},
{-0.048578223889547634,0.822414360436264,0.06035545721067861},
{-0.05721419450128172,0.8484458181987042,0.06567370722506535},
{-0.036911530030549186,0.8397607216911359,0.06541929110105403},
{-0.050359632478069086,0.8634191285171418,0.06901746553864571},
{-0.02925061674284266,0.8566277088852702,0.06909058430388838},
{-0.04511738880050157,0.8825625259474794,0.07320259776597014},
{-0.023292850178825854,0.8783298417367253,0.07380384469745285},
{-0.04064846901295816,0.9050063185457051,0.07817343450136574},
{-0.033088732267529807,0.9275132907143051,0.0837763148007234},
{-0.009999809085664653,0.9456610584222589,0.08961209695689551},
{-0.02414097828359655,0.949903756185948,0.08945355316642951},
{-0.08416033083787455,0.8159674912978289,0.053729447097399116},
{-0.06776437720803566,0.8024379667676576,0.051285545316745874},
{0.1002488882214289,0.7791528498277318,0.1440397848868234},
{0.12031813032888247,0.7716241203959708,0.14780973885069112},
{0.13167632496361212,0.7907117368835359,0.14230972054311555},
{0.12044440271855321,0.8153808929054167,0.13653653548579778},
{0.14292551067307496,0.8122234511200837,0.13766111448824106},
{0.1481516310432559,0.8363094168275934,0.13613057762256825},
{0.12570537223582953,0.8373986385694882,0.13591865713347512},
{0.14731631731191921,0.8590109592698052,0.14044086686856824},
{0.12514151501870902,0.8578483585094355,0.139403571843007},
{0.14355010603739107,0.8802350565057169,0.14529770029524056},
{0.1217594746939703,0.8772818391496099,0.14351929081539513},
{0.1377910490126795,0.9010480403857991,0.14754703180228196},
{0.11652961163444976,0.8963547079540157,0.1449556531900376},
{0.12876150115576293,0.9224606601059264,0.15068370290108182},
{0.10834280092249358,0.916099253171748,0.1471492161473176},
{0.19526534803004822,0.8226548963878902,0.07772908308987832},
{0.18297998266601936,0.8386648696883252,0.08212695374502572},
{0.17743885674076415,0.8110839137532933,0.07344525292248734},
{0.20643841586559225,0.8119112463855084,0.07438735723011147},
{0.19018251565372077,0.7988378466273295,0.06962223208526892},
{0.1634164497678018,0.8293623657628543,0.07846902020811199},
{0.17316372646713596,0.8573368369780136,0.085168756344176},
{0.1553345954664965,0.8440735762904248,0.08107958320147428},
{0.15100325049470892,0.8543225468634122,0.08272785367219883},
{0.16687002255236777,0.8797084031077927,0.08868394717972279},
{0.14501958253758068,0.8763493766045889,0.08610249536933592},
{0.1623961455604012,0.9021720617027448,0.09260757448071068},
{0.15474964534455518,0.9248896778802985,0.09712978421580382},
{0.13157988255155817,0.9436845590536612,0.09967745267804635},
{0.14571391337512068,0.9475316595113653,0.10152807623332723},
{-0.020643670563006627,0.7928397036332856,0.13148194678167166},
{-0.010711923894072902,0.7734544441991383,0.13849515173943874},
{0.009890217688878072,0.7804143592093556,0.13761648725542092},
{-0.008028985716131457,0.817177173107208,0.12739838767297926},
{-0.030519685861212068,0.8146450950528765,0.12533254708766378},
{-0.0348336682245074,0.8389700847646633,0.12353432118313647},
{-0.01256218805203307,0.8394348970374077,0.12650244733154647},
{-0.03401447780055726,0.8617546479879532,0.12837379200131643},
{-0.011956169811293042,0.8599738714429959,0.13048060388118993},
{-0.030330060399012388,0.8826629341230721,0.1329381503670181},
{-0.008596436906458811,0.8791011951379912,0.13425180953917448},
{-0.024397488826476712,0.9034174849560154,0.13642926158207902},
{-0.0031224439221051387,0.8981305644735835,0.136861777668006},
{-0.015283705673398394,0.924471946656564,0.1404445971648967},
{0.005245341930332093,0.917538131327635,0.13982122870867533},
{-0.06776776050005452,0.8327064462947221,0.06587323470310043},
{-0.07715827959005975,0.8221329771201903,0.06131644846715525},
{-0.05973246674129449,0.8095614571308303,0.05932860949343933},
{-0.048919973562485224,0.8217335999458325,0.06465461753274843},
{-0.05755221387789083,0.8477699653406516,0.0699750735031035},
{-0.037254729685780565,0.8390733309397885,0.069716989047819},
{-0.050697961679954655,0.8627423337902491,0.07331907967690503},
{-0.029588970730750327,0.8559511000535432,0.07339095914104189},
{-0.04545571800238714,0.8818859171157525,0.07750296021011259},
{-0.023631489205987843,0.877651919245826,0.07810447978783859},
{-0.04098679821484373,0.9043308498709959,0.08247504863962507},
{-0.03342708625543747,0.9268366818825782,0.08807792893898271},
{-0.01033806392948384,0.944984449590532,0.09391374827418801},
{-0.024479332271504214,0.9492269614590554,0.09375394039659407},
{-0.08449866003976009,0.8152908824661019,0.05802982193455263},
{-0.06810270640992123,0.8017613579359306,0.05558592015389939},
{0.1949697375372798,0.821980183686855,0.0820342540223113},
{0.18268002222636964,0.8379992286713844,0.08643362423179675},
{0.177137954432274,0.8104160048153289,0.07775272895497712},
{0.20614596559064371,0.8112333115015984,0.0786914499705824},
{0.18989001580672793,0.7981599117434195,0.07392633721875091},
{0.1631262674138768,0.8286825347482523,0.08277274115825119},
{0.1728692437383739,0.8566649622765108,0.08947475760834987},
{0.15504214519154794,0.8433956414065145,0.08538367594194521},
{0.15071075064771608,0.8536446119795019,0.08703194641266976},
{0.16657881157852508,0.8790317942760658,0.09298803992019372},
{0.1447265621841235,0.8756742797202111,0.09040712100928236},
{0.16210364571340835,0.9014941268188345,0.09691166722118162},
{0.15445720746261768,0.924213069048572,0.10143387695627475},
{0.13128763056478648,0.9430066241697509,0.10398134713034037},
{0.14542142592113896,0.9468550506796384,0.10583216897379814},
{0.11990546784667053,0.7947927554249613,0.1471095461189207},
{0.12842816633733378,0.7951076122639029,0.1265854805056356},
{0.13750073033563293,0.8279879684435024,0.13066917593744964},
{0.1290132899614299,0.8282574420759491,0.15119650091264303},
{0.14066129515975279,0.8585387731554812,0.13026868339209674},
{0.13227120188741098,0.8581991426874347,0.1508460389529316},
{0.14135406447789944,0.8798880521960908,0.13014475328151595},
{0.13300859843837773,0.8795497477802272,0.1507419500530548},
{0.13889776968618814,0.901042934465243,0.12687301075519408},
{0.13059815778758133,0.9007084099177523,0.1474875453492032},
{0.13372241108930105,0.922386339218611,0.12459393602161331},
{0.12546621190843074,0.9220614688267345,0.1452270601322095},
{-0.024441273334544874,0.8339853430708606,0.11958145876906257},
{-0.015082926501246423,0.7971115249729612,0.11638355380262472},
{-0.009561852467883184,0.7965996192581963,0.13790649610719102},
{-0.018849373242984684,0.8343465373781483,0.14109096704964189},
{-0.02651520655608126,0.8754787551847476,0.11878995433181622},
{-0.02113490473532673,0.8760952207338097,0.1402915310853184},
{-0.022569532088421034,0.9034025513776904,0.1158060518803293},
{-0.017281434269938643,0.9028783517959555,0.13738724133686855},
{-0.01650563177770284,0.9244844388117107,0.11391487839286639},
{-0.011262161192040546,0.9239700792807561,0.13550722155935793},
{0.11387129836948072,0.8042336892839509,0.14159713480028702},
{0.1219317375476776,0.8127241907318852,0.12270522874335098},
{0.13282876345491396,0.8376444787298473,0.1384912231549333},
{0.12537212416847776,0.8309472335890056,0.15841047264955097},
{0.13798809788850297,0.8668829131428196,0.15282149730860048},
{0.13005657081133223,0.8583354905950956,0.1717431341990649},
{0.1384887879282604,0.8878878399781694,0.15713798306012952},
{0.13060190047692086,0.8793279252752987,0.17607202535466304},
{0.13641915508156122,0.9091616579744459,0.15957940623857114},
{0.12857684529099758,0.900594381823007,0.17852955944748017},
{-0.020654303766494467,0.841688243880032,0.1287640974915796},
{-0.007617351853837373,0.8145323930103142,0.11349598222609227},
{-0.0025473834229881374,0.8058584502126982,0.13332108201570167},
{-0.01642408576494068,0.835605196367229,0.14992673778565432},
{-0.026862446332917587,0.8691260481443321,0.1419461591707157},
{-0.021381079506984396,0.8606603079324917,0.1618014607282737},
{-0.020203433631190416,0.9028352365104846,0.16845044748405485},
{-0.0245164865186564,0.9115139010453137,0.14855086569798637},
{0.12387864240586868,0.8088328472247035,0.13173353729916173},
{0.1342354941401166,0.8270988070791182,0.14325531967985802},
{0.12025742936071995,0.8274335175217747,0.14231964734497304},
{0.12394558945160439,0.845917705907911,0.15236542210865212},
{0.13796582764763157,0.8455631418615396,0.15331224815348937},
{0.12468172191544322,0.8646112246438296,0.16116693856210002},
{0.13874781425238533,0.8642407727572816,0.16212367901578376},
{0.12226385785102302,0.8856520788182366,0.16527399481975855},
{0.13637452784874102,0.885269147169553,0.16624436758560618},
{0.11753591173935472,0.9069792239410962,0.16753076213343482},
{0.13169122136290393,0.906588918450833,0.1685172458136579},
{0.11071106815665945,0.8105553766176881,0.13123409895352114},
{-0.008326256872381583,0.8292292400380684,0.13317980168963958},
{-0.022299352054343892,0.8292850209808409,0.13212887435191445},
{-0.010928776801567215,0.810715357997437,0.12215126114905484},
{0.002220170752021734,0.8120699017130739,0.1235219281720784},
{-0.012909192361659364,0.8479339124839389,0.1430495956962939},
{-0.02692815407754753,0.8479711658751795,0.14200238626188624},
{-0.01439138409119451,0.8667639650226844,0.1521039419683377},
{-0.028456237127030853,0.8667874125996062,0.15106168973835324},
{-0.011940046503906506,0.887525889697207,0.15573509420835493},
{-0.026050716501624507,0.8875370558001703,0.15469903848389951},
{-0.0070162908175204755,0.9088233535585828,0.1590886430006712},
{-0.02117410382930344,0.9088282735839728,0.15806250168506222},
{0.10835892422988021,0.791773917075302,0.12839362081900937},
{0.1291370093908228,0.7854136502981408,0.13011499766196552},
{0.1379595815700583,0.8037429632250843,0.1373599643195297},
{0.11644659085337163,0.80850683667581,0.13606241606174882},
{0.14582048087720906,0.8251890688610902,0.14476974563115533},
{0.12356511161911028,0.8281645936371022,0.14365685323813981},
{0.1497528080719597,0.8483726374684061,0.15008139017064812},
{0.1272929417383916,0.8492464686781114,0.1489424724544106},
{0.14897696840069083,0.8712216815282311,0.15379682727887134},
{0.1244549793851246,0.877347646038328,0.15390827762731665},
{0.1454090329100808,0.8927112742400403,0.15731148521494262},
{0.13970703330828071,0.9136900890010905,0.1588878762215303},
{0.11844682283814563,0.9089994086736736,0.1562878225015453},
{0.130697301876046,0.935172121976154,0.16176553338921631},
{0.11027731276962661,0.9288071210687685,0.15823848244208696},
{-0.025799163163167566,0.8060295976954104,0.12571920903267586},
{-0.016554001699862538,0.7874474549498711,0.11975939762183446},
{0.004427378414476688,0.7932250890981585,0.12100613453427723},
{-0.004195691072745884,0.8101898447565301,0.12748645240955797},
{-0.03403060110794384,0.8276999672595234,0.13198511542364075},
{-0.011767771257188094,0.8300533380943975,0.13403615875375285},
{-0.03805709040071379,0.8511004383463779,0.13714308662601332},
{-0.015645556810272205,0.8513483481395837,0.13919289065501964},
{-0.03720815675022433,0.8740324907942699,0.14138522670420495},
{-0.012924175512028529,0.8782731189251123,0.1443542451494111},
{-0.03352126074646785,0.8952096928763379,0.14459253796603586},
{-0.0275465653293457,0.9161315989306092,0.1474107086806431},
{-0.006271508031963097,0.9108458062121837,0.1478345496588294},
{-0.018412928572552358,0.937252995283883,0.15116579103124111},
{0.0021148425510391124,0.9303178662957816,0.15054985838165458},
{0.11322315628415416,0.8019584068117539,0.15025861022877865},
{0.12128482237044579,0.8104489082596882,0.1313667041718426},
{0.13218137734326207,0.8353708941001651,0.1471532314829004},
{0.1266127885055021,0.835834764504069,0.17099964028665754},
{0.13734117031826013,0.8646076306706226,0.1614829727370921},
{0.12960301139262867,0.8567392707708148,0.17782066682194697},
{0.1378406334499229,0.8856125575059725,0.16579945848862113},
{0.1299549729066781,0.8770526551961128,0.18473350078315462},
{0.13577101299623467,0.9068875156592666,0.16824088166706272},
{0.12792993011376586,0.89831909935081,0.18718979557486595},
{-0.021305382995441678,0.8394237433274554,0.13742972457877564},
{-0.008264279424080128,0.8122569246429515,0.12215745765458387},
{-0.0031955255083146875,0.8035843078975186,0.1419825574441933},
{-0.018763514462374373,0.8388017876744948,0.16140414079375165},
{-0.027243110060577617,0.8668798892481213,0.15055521216243165},
{-0.022858437962207028,0.8791475202133263,0.17390774708251325},
{-0.02516340169588813,0.9092397587301341,0.15721234112647797},
{-0.020322716362624425,0.9004939612544033,0.17706346623930935},
{-0.09010194930848268,0.8328027028116103,0.08608499643772193},
{-0.10184515761775369,0.8319383150763313,0.08792424320885146},
{-0.09799422771963248,0.8312367467203337,0.10958033602422577},
{-0.07044720384887761,0.8402779192216226,0.1063029670708835},
{-0.06224930139202449,0.8464248774924521,0.0828027446380228},
{-0.061640990444238694,0.8451690441098926,0.10472544830028954},
{-0.05405524076859942,0.8534984364140717,0.082784861523066},
{-0.05416179587767677,0.8512131403889401,0.10482831029207161},
{-0.04708044175210133,0.8608178354960508,0.08229038038184862},
{-0.047729835531544675,0.8578546045870089,0.10427062479445803},
{-0.03713017992464687,0.881090546059056,0.08493483826045475},
{-0.03884650041909135,0.8755020044734927,0.10649955740529785},
{-0.019568390958552378,0.9388110198480824,0.12153425030750624},
{-0.01777097059974385,0.9434965942549431,0.0998785540684858},
{0.21267089830573355,0.8272686161166359,0.13174097310579658},
{0.21954528914663907,0.8274520450733066,0.11077199839552643},
{0.20599288711805433,0.8295153450913554,0.1066525243407877},
{0.1987393940688821,0.8311268702842927,0.12778796197558998},
{0.1859877044847599,0.8400521309531557,0.10217235169920358},
{0.1802251898099632,0.8402054944649993,0.12351304238314975},
{0.16839551546253997,0.8556608309485408,0.09839347476737405},
{0.16563849186449325,0.8531852898106564,0.12024424939345969},
{0.15773638579557445,0.8754328018997444,0.09881895162302003},
{0.1551909232893002,0.8748486573235218,0.12090058325909558},
{0.15212925469342384,0.8971362608033825,0.10233622448442456},
{0.1363428513124766,0.9366342618137974,0.13261696069942586},
{0.13775762506185588,0.9413253263245568,0.11093435923339832},
{-0.08401408091437813,0.8445049274333124,0.09765027828723208},
{-0.09209310960916214,0.8419096822016177,0.09848680653365244},
{-0.0896008502993603,0.8225493822917415,0.09907299595669959},
{-0.07323388392238624,0.8281071024588037,0.09725615574956305},
{-0.07273351610091627,0.84976895802432,0.09690870529153874},
{-0.05723899291640893,0.8363317242474979,0.09590906023357196},
{-0.06222717986728584,0.8570713415021163,0.09543564721115332},
{-0.047681502788418186,0.8428453545365028,0.09465612681560014},
{-0.05642972929431635,0.8626222455130962,0.09465240891228272},
{-0.039319938227532075,0.8504434972232001,0.09392741776538507},
{-0.05179350385748886,0.8691459017480471,0.09558312404274447},
{-0.03250005184926002,0.8593702574464009,0.09512210403138391},
{-0.046030753715482,0.8842096066891423,0.09799729498986937},
{-0.02417070911712493,0.8793477788790136,0.09847938312002866},
{-0.04003254875638267,0.9067201604379381,0.10308090812589348},
{-0.01602890982133174,0.9082524571111811,0.10509623479813622},
{-0.03293135342010329,0.9290226974961241,0.10857720853015164},
{-0.022485284399248257,0.9510958647056468,0.11426313439660948},
{-0.003641711085438727,0.9447284099820722,0.11412555958085376},
{0.20559075869524174,0.8184286565428859,0.12005808158134523},
{0.20867785774980926,0.8377110415922401,0.11986722921105081},
{0.19709264793851772,0.8421313064183694,0.11702854806314247},
{0.18982912894339957,0.82442527519657,0.1159653392514588},
{0.18252788562262068,0.8513927894772378,0.11378511117407725},
{0.17439875198412882,0.8330933560999556,0.11235582520874897},
{0.16526761861556924,0.8399887778806264,0.11024777402776968},
{0.174449575722478,0.8596106075028613,0.11188860869185939},
{0.1572827768048266,0.847910464907017,0.10872715157094336},
{0.1699942758540875,0.8659447745987343,0.1109380647437047},
{0.15069591621347958,0.8567069374049645,0.1077332320840854},
{0.16436910052783638,0.881167134867395,0.11254173276763121},
{0.1425351060387233,0.8769138534722623,0.10991813232663582},
{0.15831267320278616,0.9039503720385015,0.11718043680667029},
{0.13443334856165876,0.9057861859455679,0.11573320576132991},
{0.15112715581926753,0.9264524241817115,0.12166174960527176},
{0.14059931771145134,0.9488192561812667,0.12585679624144264},
{0.12179540203302766,0.9429773146985986,0.12304234343015284},
{0.08061415747468263,0.8732787354687065,-0.036594894794520806},
{0.08227235474726467,0.8708705131668895,-0.0600168429695387},
{0.06010534765800996,0.8707850385696217,-0.06151975581356303},
{0.05795203720064657,0.8771220436650268,-0.03040172298545578},
{0.07902976058295136,0.8923054526999323,-0.010031243958213467},
{0.05684418876313176,0.8969089605875663,-0.01021903525477654},
{0.05657196388222992,0.9494614496212853,0.006950676020473533},
{0.07873320822134264,0.9470229759794755,0.007764301982458554},
{0.077158118480916,0.9753123040335759,0.03752820006429371},
{0.054936284710740434,0.9761184446168821,0.03553368125761749},
{0.07568841890652739,0.985324134339967,0.060384518821609806},
{0.052443492501463025,0.9863386757972256,0.07103260631572259},
{0.07476144646540515,0.984573217013936,0.0729361604212325},
{0.08123048670062301,0.8704892793607206,-0.06001727672492574},
{0.05908542763395223,0.8711944416899255,-0.061665175405318545},
{0.05747990065836692,0.8736011520443935,-0.03823975718720438},
{0.0791374062770019,0.8768262968491367,-0.028895377277368375},
{0.055820290582524294,0.8926273115901218,-0.011683145581178032},
{0.07792791036278866,0.8966149116141912,-0.008720112960312915},
{0.07723045648646201,0.9491734484373064,0.008420003804530467},
{0.05511843718727203,0.9473493707117122,0.006083983185137817},
{0.05325289244667726,0.9756472003713986,0.03582981225685029},
{0.07554711379444312,0.9758308276162461,0.03699838644854976},
{0.0517526069209973,0.985658857175635,0.058682958403335525},
{0.07327708595893477,0.9860468947448743,0.07251427753879336},
{0.05087394243697946,0.9849066014044092,0.07123831790627565},
{0.1017751371052756,0.8724858306212103,-0.03328288737527123},
{0.10819577023930059,0.8698726279164928,-0.05583733716923464},
{0.08688120402266482,0.8708374238273644,-0.06204777244270355},
{0.07855572790997986,0.8774838080508232,-0.03198664038365143},
{0.09561885929013045,0.8916519196547954,-0.007607394069452207},
{0.07422864613399623,0.8973718891226298,-0.01239861889558306},
{0.07281600398251893,0.9419979569997339,0.003109040880645873},
{0.09389481794979682,0.9456676762901638,0.010672768175634948},
{0.06986402592751763,0.9634968196838144,0.0187458977971553},
{0.08833435892729101,0.9733666260834798,0.036342833342610535},
{0.0659187356432002,0.9772606216950279,0.03419861935536377},
{0.08158254735876092,0.9848483542524363,0.06049853452334413},
{0.06013025761023678,0.986399946843897,0.05446313813805952},
{0.07790928366716829,0.9817610693027031,0.07148989603075465},
{0.0564544905304104,0.9832668945043258,0.06539501319239124},
{0.054810532827534064,0.8712854063910919,-0.06432793776125746},
{0.03281343391988566,0.8709242244768152,-0.0611955174652505},
{0.036049496967371385,0.8734012775620487,-0.037963157573399096},
{0.05898297461153504,0.877758573498992,-0.0333757234211073},
{0.03904242153090858,0.8924399044769012,-0.011630388533103777},
{0.06104698103121396,0.8975602257116794,-0.01333301475032907},
{0.0614925593507961,0.9421760941406827,0.0023110425056051052},
{0.03966593870326265,0.9464265499292943,0.006818702845716048},
{0.06279787802651045,0.9635796421767157,0.018227820362883354},
{0.04230623253015321,0.9740033418126107,0.033062266992415316},
{0.06490051346165736,0.9772755676663639,0.03412800397835484},
{0.04589066311848153,0.9853464541528826,0.0579616851597553},
{0.06801591815348149,0.9862895127223583,0.0550233022378847},
{0.04788469859772646,0.9821812543426269,0.06935458022544759},
{0.07002111973568982,0.9830772318630931,0.06635918945270981},
{0.12095691569086012,0.8701878565457662,-0.023217221828843962},
{0.13182987437062169,0.8671444428551784,-0.04390157864715426},
{0.11240703932694651,0.8690935164903048,-0.05453121294780155},
{0.09826951367426565,0.8763722541030021,-0.02676877375883514},
{0.11308269389682192,0.8835880228265135,-0.005516011488346026},
{0.09036223971973553,0.8996172920451657,-0.0066256693054753905},
{0.10816306508311829,0.9190116231634075,0.012370350437359581},
{0.0889972982678208,0.930460261992839,0.0034175648909367663},
{0.10755078837179388,0.9434360791819465,0.01808366485825577},
{0.0878232091862005,0.948235309893221,0.008672238758595555},
{0.09718004407214989,0.9734120216829854,0.04383580893746903},
{0.08016570397653497,0.9721427666694501,0.02896989645286061},
{0.08647657221161857,0.9840365376700658,0.06441844392101462},
{0.06696252460655586,0.9862982126161209,0.05416942377598304},
{0.08022550025489016,0.9811775071980002,0.07434772438074773},
{0.060690434103073,0.9834007762027864,0.06406028590143611},
{0.028440535182020284,0.8702659573014543,-0.06049979861047206},
{0.007663106850663813,0.8688777541677835,-0.05272835205713852},
{0.015581063580725972,0.8716598240411786,-0.03070569876068835},
{0.038702840634906095,0.8771980747878682,-0.031011012981115204},
{0.02123710989752276,0.8848529278931675,-0.012062966584086036},
{0.04432759459878125,0.900260229065848,-0.009898353700637678},
{0.02456417482520795,0.9201509622420211,0.006416871855168877},
{0.04511487301925684,0.9310725634901856,0.0002970047065124111},
{0.025042507873016585,0.9445937599169262,0.012222055667038614},
{0.04602823793423722,0.948817174155409,0.00569986180739264},
{0.03248708875969324,0.9742983450478371,0.03921425682573433},
{0.0513971381848184,0.9725402601061272,0.02691880355070425},
{0.040471224168805595,0.9846785452149186,0.0611491676038933},
{0.061293948955579367,0.9863776270309813,0.05376541161548966},
{0.045173120171229805,0.9816669072046837,0.07185548985696798},
{0.06602065576614183,0.9833264677084821,0.06443951203981334},
{0.13750081708671036,0.8673583214400187,-0.010682409938238128},
{0.15230488844613896,0.8636736561782524,-0.028589926733819895},
{0.1211387955211485,0.8704531661264974,-0.02528815594170429},
{0.12698564463619544,0.8808728999988541,0.00465868776937023},
{0.10952454888494782,0.8863699068047425,-0.008058685567132162},
{0.12141275542359842,0.9026455738692518,0.016336832770586326},
{0.10369012995999212,0.9244403692643881,0.00813554702171437},
{0.12038385046652345,0.9259641643320452,0.023005945776325816},
{0.1193307791378853,0.9408083146892358,0.026496189480612692},
{0.10269488442095089,0.9453297560576432,0.013143228178985644},
{0.10454183964495863,0.972390862357822,0.04998191209053546},
{0.08887045579964134,0.9749569840135297,0.03581834872162157},
{0.09043116964724063,0.9833871686766444,0.06796904158915433},
{0.07381956523198009,0.9861977920475176,0.053933956565879536},
{0.0819097476367163,0.980748622264313,0.07635291356994495},
{0.0652547428967304,0.9835755052656941,0.0623686398920083},
{0.13584659797067797,0.8671183431738901,-0.04302029923780318},
{0.003563610329750736,0.868964926607566,-0.0524241284216848},
{-0.0148606330618977,0.866007941776097,-0.04047327521213565},
{0.01570113946486772,0.8719251336219097,-0.03278242040971281},
{-0.002644532236672472,0.8693128851790436,-0.020649303186532523},
{0.005972253993943755,0.8825687596320417,-0.003938765363995333},
{0.02520470760174477,0.887560875167424,-0.014041002686055008},
{0.01043780288247929,0.9041882682787726,0.00844485179170191},
{0.029741850915162852,0.9254847902713077,0.002883302184222963},
{0.011160513715342303,0.9274896448492065,0.015240485047333338},
{0.012123648962731933,0.942313755707516,0.01888022564401382},
{0.03059800969109916,0.9463325613334298,0.008016524543512583},
{0.02431337746042558,0.9735116738849037,0.044279528305392495},
{0.04188534108859878,0.9756006894008977,0.03246299054969083},
{0.03603701720523588,0.9841467858964384,0.06410242213903358},
{0.054538555806853455,0.9864668814966213,0.052564528843961775},
{0.043210092005652186,0.9812877554243729,0.07360166511505135},
{0.061748784854421854,0.983623924759898,0.062119540369740905},
{0.14833808389462472,0.866014745539168,0.006059048446888955},
{0.17026464178333048,0.859674146470556,-0.010871267033752189},
{0.13641774227830056,0.8694961158475372,-0.012204222124126023},
{0.13315388170701165,0.8918466882165842,0.0227771336131605},
{0.12056731660222723,0.8974276700654022,0.005687543154400915},
{0.12936587112603226,0.9405511349237583,0.036386022986147945},
{0.11680471169391696,0.9458374853276819,0.01967144504200584},
{0.11161054050624375,0.9704654221947833,0.054006480466591414},
{0.10346622542920578,0.9696780074511862,0.03409731888297504},
{0.09289611476067047,0.9794808791981268,0.043243745227180344},
{0.09359759636559088,0.9831825600640758,0.06909804489654534},
{0.0811711117846437,0.9865398763317538,0.05183829839595833},
{0.083104396723682,0.9809146514334585,0.07529331112447918},
{0.07058625343294928,0.9842458804128588,0.058011257203987615},
{0.15791607206290553,0.8638676811593778,-0.02870762315983847},
{-0.02024120752889544,0.8657059364896229,-0.04140946805348508},
{-0.035250098182080955,0.8625439588622424,-0.025480644189458383},
{-0.018983205369400867,0.8666470989284066,-0.009098558338993468},
{0.0007757157411583525,0.8742427754059033,-0.0193074747002411},
{-0.007056382208293408,0.8813117984854759,0.005954798437868393},
{0.01173050547293649,0.89560982602437,-0.003467868122821508},
{-0.0016380834156347554,0.9013269574926721,0.015830218871543098},
{0.014907714110907353,0.9403030392353867,0.010242123434377744},
{0.0007840810236225696,0.9423402271791358,0.02724352522644804},
{0.02585929405282145,0.9688168295057712,0.02676669173297739},
{0.016688912018240867,0.9717838402831862,0.047252140723805514},
{0.03698753636736845,0.9802616760738191,0.03926930658085432},
{0.03273921217665882,0.9840327578016932,0.06477164473616986},
{0.04756994090287341,0.9870096086298881,0.049450165165066444},
{0.04218269899592636,0.9814861179593685,0.07238467142914796},
{0.057107602213171196,0.9844344152900855,0.05705327744919809},
{0.09498489480945438,0.883401198184813,-0.03718267052298339},
{0.09307212030371728,0.8612626082699143,-0.03675812314316677},
{0.09598571720347175,0.8599279181579923,-0.04700093438965824},
{0.09790042501893388,0.8818709711444165,-0.04752887666073242},
{0.09071373029936479,0.8638330674794926,-0.028101592526087325},
{0.09313018156052441,0.8870629735551546,-0.029890003165856636},
{0.08885726963587555,0.8675894015242075,-0.02084548455158191},
{0.08735920245917493,0.8723337931615501,-0.014562674093533805},
{0.09080422406611093,0.8966521650054321,-0.01968921661986312},
{0.08523600701868271,0.8812860829875305,-0.005283580565951765},
{0.0898957791765205,0.9035810603089708,-0.015009628037343441},
{0.08350969775732546,0.8939939508845515,0.0036492894117007395},
{0.0893202849220165,0.9155497222754106,-0.010030599521638445},
{0.08280325894798174,0.9080499305244701,0.009553332272780758},
{0.08252196238298548,0.9221507232923748,0.01379669925906711},
{0.08879406527947936,0.9414715018899869,-0.0024963799859786654},
{0.08231125640897595,0.9348585911893957,0.016618587876991758},
{0.08737877102363563,0.9577955636626777,0.006847950351813108},
{0.08139543767780602,0.9454273262337036,0.022603172916938242},
{0.08475270437343975,0.9720327043382436,0.01910711689046514},
{0.0792613611736048,0.956558654408004,0.03273323254882331},
{0.0823323369207858,0.9812431281915527,0.029475109941654264},
{0.07718984458922472,0.9644031825475471,0.04145900291868423},
{0.08019079982392753,0.9864146945270558,0.03712531566780661},
{0.0759573720325098,0.9942174334333113,0.052057654691686335},
{0.07271166722242092,0.9730712510579216,0.05765929568993816},
{0.06946468593219311,0.9951667256873489,0.07284693074161433},
{0.07093693846685976,0.974403474960643,0.06362900911661495},
{0.0648222639898366,0.9792825042701201,0.08419025376307429},
{0.06992074873913043,0.9684573454340097,0.06545945684989327},
{0.043623138671206846,0.8841171300406269,-0.040836898549590765},
{0.04216039157602178,0.8826493265969301,-0.051492173990117227},
{0.04336993706227929,0.8606627741416923,-0.05074114512698656},
{0.04484223916899014,0.8619356231284343,-0.040187269302937305},
{0.04602204142870824,0.8644576752368198,-0.03127792126027306},
{0.0445311621984213,0.8877443041240948,-0.03334148153155383},
{0.04693790973192238,0.8681742896810938,-0.02382476440994418},
{0.047664450005202266,0.8728910696897986,-0.01738111745438432},
{0.04565523308741121,0.8972830064473212,-0.022899006483905658},
{0.04870020829739231,0.8817966626501125,-0.007881155683725183},
{0.04608401887700969,0.9041933741993284,-0.0181239793232277},
{0.04949954511762743,0.8944685908150648,0.0012314253472805198},
{0.046283335673856806,0.9161522085079989,-0.013088513035164227},
{0.04975360184431803,0.9085109629288415,0.007203617376168932},
{0.04982300270624329,0.9226081617235397,0.011471770384571428},
{0.04645830020397473,0.9420639497836182,-0.005505415463891374},
{0.04998657805919888,0.9353109237000045,0.014320923626823863},
{0.04699119967947212,0.9583594704518424,0.003976489689656138},
{0.050339766481343036,0.9458611311927805,0.020395977647494325},
{0.04825155651106777,0.9725419579486421,0.016513259676009147},
{0.051328728763777746,0.956949145793433,0.030747872177319013},
{0.04943634076123115,0.9817016943867237,0.027136548754994706},
{0.05236359475917166,0.9647499885689964,0.03969473386445606},
{0.05061614302094925,0.9868275057254005,0.03502346099235636},
{0.05291255557700029,0.994538338061649,0.050419298629808255},
{0.05474424261138445,0.973321441165162,0.056382815550956},
{0.05642352039577625,0.9953488285918362,0.07191993351447},
{0.055692307957327464,0.9746165975718089,0.06254462064903302},
{0.05897148629028424,0.9793630712350089,0.08377384859152283},
{0.056273564961973534,0.9686481482322598,0.06448908408404565},
{0.11624732362856881,0.8813672076379165,-0.028333416190939754},
{0.11307442775844619,0.859356637527248,-0.02845604503535945},
{0.11800933715478441,0.857826051089531,-0.03784993502437249},
{0.1211732480918899,0.8796439222712577,-0.037830106206679565},
{0.10908143677456618,0.8620855785622371,-0.02048608723089761},
{0.1131173075767071,0.8851439653648554,-0.021588643852690704},
{0.10593978368532099,0.8659646282024492,-0.013771553839630253},
{0.10340685051322655,0.8708115100412419,-0.007923936357897664},
{0.10916691137183378,0.8948997560627862,-0.012057600410297898},
{0.09979905909905375,0.8799054519836164,0.0007295083994283118},
{0.10761778498957388,0.9018906783866711,-0.0076469401677385284},
{0.09686315477939478,0.8927298017915718,0.009153038015604794},
{0.10653021151815005,0.9161261088267106,-0.0020383466902831188},
{0.09566722921229014,0.9068355145848668,0.014850105199003849},
{0.09518142317881342,0.920962208745883,0.01899556739793136},
{0.10577125112794218,0.9399980100542144,0.004029779637205887},
{0.09476004840982771,0.9337234037694867,0.021648911065466136},
{0.10332236735684357,0.9562922046702552,0.013460861052404212},
{0.09322827224304907,0.9444247068530829,0.02715140797525334},
{0.09879148251400977,0.9707350817223961,0.024935549991079824},
{0.08961197922329048,0.9557358700108469,0.03659489479452081},
{0.09466091671437407,0.9801264683231755,0.034583509099794546},
{0.08612884910735095,0.9635966577808983,0.04465664763188985},
{0.09102230388169988,0.9854430824601026,0.04158679964871515},
{0.08381580513045997,0.9935270187872656,0.05525133364135335},
{0.07837026649949574,0.9726039849689876,0.05983922633505431},
{0.07280333832521758,0.994947369391621,0.07406640302972932},
{0.0753451572862407,0.9740676367539801,0.065261168672964},
{0.06491148127644371,0.9792925302160661,0.08412085290114905},
{0.07361633224363866,0.9681610285396111,0.06686730290609107},
{0.07223219401759491,0.8843992693303754,-0.041014031856643894},
{0.07167060472149803,0.862197152840793,-0.04032481933267092},
{0.07242163358462875,0.8609553111677184,-0.05096298002492619},
{0.07299049757821668,0.8829615313315053,-0.051758611334854876},
{0.07106089336346268,0.864691791608718,-0.0313473221221983},
{0.07174307905016568,0.8880045077842701,-0.03346796460241259},
{0.07057883001932547,0.8683874122922594,-0.02383839672210806},
{0.07018923093069267,0.8730871766967818,-0.01734778025463807},
{0.07115138713020872,0.8975146566100191,-0.022953535732561193},
{0.06965553830248752,0.8819676118446474,-0.007782011595260537},
{0.0709307419613307,0.9044138706520739,-0.01814876534534387},
{0.06922178291545479,0.8946159065375122,0.0013974916954587915},
{0.07078263308617563,0.916408062221293,-0.01307480636493399},
{0.06904080777497365,0.9086374707857224,0.007442802489589855},
{0.06898507640424546,0.9227121638723388,0.011789031467658266},
{0.07070646564021267,0.9422645926326484,-0.005473181242129306},
{0.06900365352782147,0.9353928043240652,0.014723696486211437},
{0.07030614659701458,0.9585491454860865,0.0040632407670626895},
{0.06875455400555408,0.9459256120293156,0.020881783680971034},
{0.06966049550691075,0.9727291667736855,0.016697915540774527},
{0.06822909033669151,0.9571078011209985,0.030957314064200547},
{0.06905693108236019,0.981898743262547,0.027412912901589866},
{0.06779835884435698,0.9640646922365178,0.03879492690357316},
{0.06852900120429703,0.9870306023906203,0.035376661807511624},
{0.06750780470010027,0.9947590204095603,0.05091873697544884},
{0.06682121949447159,0.973882881745126,0.05492291884831426},
{0.06589675044158311,0.9954840363424802,0.07250612293751715},
{0.06610495302735889,0.9768534864957477,0.06547928566758619},
{0.06473055570800686,0.9857925529789293,0.08623138268433996},
{0.06550879962342102,0.9732323725946878,0.07279735869738202},
{0.06670893881428541,0.8844749162698737,-0.041412863738514986},
{0.06743717693008029,0.8830396320871934,-0.052152709086501804},
{0.06727729469442001,0.861027165845833,-0.051328573851139515},
{0.06655108903243864,0.8622690075189078,-0.04068917385777846},
{0.06595372111341714,0.8647625061298154,-0.03171044973921108},
{0.0662254998459208,0.8880807248022772,-0.03386107091317486},
{0.06547041846817418,0.8684592669703741,-0.0242027512472156},
{0.06506914516312465,0.8731582754012217,-0.01771295271847545},
{0.06558812728720383,0.8975927573657071,-0.023348872785313925},
{0.06449134580856376,0.8820396524179279,-0.008148844722579688},
{0.06531922373326561,0.9044919714077619,-0.01854658100030821},
{0.06397334273235816,0.8946890872678099,0.0010232227615047888},
{0.06508133988600574,0.9164831390822828,-0.013482325747556811},
{0.0636870393908944,0.9087117792800269,0.007062337050106827},
{0.06351973374161032,0.9227878108118373,0.011399890920434572},
{0.06480118347802684,0.9423464732567092,-0.0058920650158923995},
{0.06343917916973286,0.9354707067915762,0.014328359433458705},
{0.06430049343826935,0.9586332940311708,0.003636921186664765},
{0.06310705886638734,0.946004852942021,0.020480250122689267},
{0.06354701075894924,0.9728146413709527,0.01626416015374175},
{0.06251219433559961,0.9571883556928762,0.030552062602601352},
{0.06288274536623616,0.9819855439119981,0.02697420031013387},
{0.06202378576980066,0.9641444908347204,0.03838354090150022},
{0.06242171296186451,0.9871162628830538,0.03494290642047885},
{0.06144887398681633,0.9948431689546446,0.050487460190627685},
{0.060982871985010435,0.9739647623691868,0.054507752977868605},
{0.060010045402973375,0.9955657310713748,0.07208847846485988},
{0.06028022543705052,0.9769340534606363,0.06506535909824634},
{0.058954136074802876,0.9858744336029901,0.08582117401831753},
{0.059734945343506096,0.9733129271665651,0.07238715003135959},
{0.02127800683401446,0.8826952798819337,-0.03507854792650951},
{0.017696600140384346,0.8810890341117069,-0.045185358269649624},
{0.02022352270211565,0.8591917485151206,-0.04480117492684916},
{0.02382118902625395,0.860603386832702,-0.03480126669709605},
{0.026721178399866576,0.863234373508288,-0.02634179734885112},
{0.02352260421083164,0.8863933543816643,-0.027959754514527604},
{0.028987847729378208,0.8670391146541958,-0.019241828920666445},
{0.03080303966604406,0.8718266215770091,-0.013083283184497712},
{0.026356823874759103,0.8960561107455826,-0.017944280662885552},
{0.03340102375318244,0.8808337504769218,-0.0039909895125940925},
{0.027459801858928143,0.9030097796782265,-0.013345234259232328},
{0.03547188350797635,0.8935873857637798,0.0047882195209492835},
{0.028138257249302655,0.9172134468309244,-0.007613664933047591},
{0.036241477101672054,0.9076645326665859,0.010625327729304615},
{0.03652778044313582,0.921781399169833,0.014826558477993497},
{0.028695397454429655,0.9410749503221503,-0.0014504222456878388},
{0.036925558919067,0.9345301144313011,0.017536909996395438},
{0.03023706324403268,0.9573122238384014,0.008265710816857376},
{0.037959148434321806,0.9451956760710059,0.0232215841687364},
{0.03349892854054126,0.9716459928211872,0.020293128048723325},
{0.04051709070273154,0.9564224923955089,0.03310502288056569},
{0.03648315321031564,0.980938284905546,0.030447961309713487},
{0.043042315421947856,0.9641991440134867,0.04159478074783655},
{0.03924059817073833,0.9861656445768328,0.0379060753644656},
{0.04466499432483748,0.9940737116840704,0.052467863357708755},
{0.04882165980576147,0.9730165978791554,0.05773861096070988},
{0.05294105950243385,0.995224972839322,0.0726548390702141},
{0.05109079534447368,0.9744059411698436,0.06353606153367937},
{0.05889343510664044,0.9793766787611504,0.08369329401964531},
{0.0524093993280423,0.9684573454340097,0.06536031276142863},
{-0.05716563868395613,0.8552236179114228,0.01858877920296097},
{-0.03297853361320142,0.8625887843832394,0.03037423528692897},
{-0.02885387927984038,0.8651212342279028,0.008329621574883898},
{-0.04910793836120309,0.8598969108443251,-0.001369867673810313},
{-0.016222501047070032,0.8884853937923568,0.043468430517663324},
{-0.012585734773043412,0.8832219208868468,0.01968388762510815},
{-0.006799772521324766,0.903839752021797,0.026864373446137162},
{-0.01240925829557644,0.9359430911940769,0.055014738667243566},
{-0.0038432958033093774,0.9433791580821567,0.036633945172364825},
{0.00925298145328266,0.9706770328586001,0.07044682586204033},
{0.014310296619841577,0.9714495140238723,0.049857411901446},
{0.034869731886686454,0.9870046886044977,0.06135475526433577},
{0.028283912308268332,0.9834750970901018,0.08100896782446534},
{0.04004613149650242,0.9815838864236057,0.0850664396448805},
{0.048101601077264966,0.9851779587745372,0.06574821400754652},
{0.13509875411138922,0.8786838480975991,-0.016523335193999365},
{0.1308199802925099,0.8568457391288151,-0.01741757769291718},
{0.13753576537789414,0.8550290352448001,-0.025549896335250923},
{0.1418002004829792,0.876673305127625,-0.02476167604593497},
{0.12538938763288168,0.8598065162216674,-0.010467589484557381},
{0.13086124901933327,0.882621144889784,-0.010605932666998719},
{0.12111501333292804,0.8638676811593778,-0.0045561108168425115},
{0.11766569135115493,0.8688720781687187,0.000650143556612374},
{0.12546871529666448,0.8926343012483584,-0.002084944411861494},
{0.11275592737425354,0.8781693026714789,0.008363603211205146},
{0.12335814833444035,0.899721864272474,0.0019056051488400246},
{0.1087542364966108,0.8911681956471766,0.01602124474399234},
{0.12193769858599654,0.9137995812537887,0.0071122313126266495},
{0.10686065876500264,0.9094956124434281,0.02285722964362887},
{0.12090931413538601,0.9380597059456974,0.012724703802543251},
{0.1058988867488293,0.9323465526339452,0.027819391271283817},
{0.11757803558394116,0.9547022309235479,0.02072440483354448},
{0.10380817339032028,0.9431495899453171,0.032910440213942786},
{0.10599074374679181,0.9785034052369431,0.03948934449219052},
{0.0988571902586397,0.9547109308173108,0.0413290250187071},
{0.09421155852641924,0.9626938888903726,0.04830120910987192},
{0.10059962282738359,0.9843884620050819,0.04659233681507337},
{0.09081660468415795,0.9927897089873762,0.05869411211328779},
{0.08347372084622381,0.9721317988546638,0.061970824237043955},
{0.07585824033705624,0.9948148137453439,0.07475049724013531},
{0.07934192813849338,0.9737527799150385,0.06663059639488175},
{0.06510975706036193,0.9795168065371843,0.08283693695553204},
{0.07699714566028264,0.9679566058222078,0.06773853158347404},
{0.0008788255931616312,0.8805591709239187,-0.0260611947924741},
{-0.004645520195120957,0.8787182634893076,-0.03517180533472157},
{-0.0009164631677449184,0.856962233432761,-0.03539241332456644},
{0.0046293844947233945,0.8586081740174066,-0.02638763909675497},
{0.009103261486690066,0.8614299634912427,-0.018733715467285212},
{0.00434256064679527,0.8843890574892636,-0.01959769423319919},
{0.012609269101042812,0.8653833340187699,-0.012269520899391043},
{0.015423164226835004,0.8702965928247897,-0.0066221620833459595},
{0.008751299972640555,0.8942639822024957,-0.010382065315245565},
{0.019451413327175163,0.8794716470245392,0.0017308636929211176},
{0.010472701601618877,0.9012982181000284,-0.0061201088123721045},
{0.02268974429568452,0.8923703177198103,0.009902815184618594},
{0.011532192509985103,0.9153405778207941,-0.0007357544770015763},
{0.024105930848324377,0.9106449774679877,0.016972780133031662},
{0.01243203664990118,0.9395753711981005,0.005013784715217379},
{0.02499235335726454,0.9334754939762808,0.02206779483922922},
{0.015058090907086038,0.9561337352378556,0.013436075030288055},
{0.026640611434978003,0.9442265302132529,0.02742529351963689},
{0.02453301879540788,0.9796419883418819,0.033700122878563596},
{0.030670806238054387,0.9556626768875381,0.036482118393892295},
{0.03450334490776539,0.9635283970759903,0.044058065197784615},
{0.02902751775777517,0.9853873015173301,0.041505005775731824},
{0.03722921247601203,0.9935381848902289,0.054884500514034214},
{0.04345796461982484,0.9726894595662552,0.05912662819921476},
{0.0498155297205752,0.9951790195543184,0.07289898138805827},
{0.046932952527499155,0.9742051124256472,0.06432673563918481},
{0.05888473521287762,0.9796036071866351,0.0823945064607586},
{0.04893441142036789,0.9683482373646545,0.06574325680312328},
{0.15069591621347958,0.8748280477461321,-0.005122471422196736},
{0.14313616707504012,0.8540784169385791,-0.005232781613624697},
{0.1514394596979312,0.8518551355407815,-0.011565610264303201},
{0.1566792495593092,0.8732653014447196,-0.00972399642806157},
{0.1456155872253859,0.8774537302129854,-0.0008858958059702025},
{0.13642289777090072,0.8573663447373426,0.00026105258143290606},
{0.1311409840649363,0.8616877009422175,0.005024913639147526},
{0.14172773854732257,0.8819825454229724,0.003060410705253975},
{0.12669191788110795,0.8672085519013817,0.009629859116064395},
{0.13649970965343866,0.8902300571030909,0.00848381541846852},
{0.12080643975059287,0.8764961222485276,0.015663086724413848},
{0.13388972913159616,0.897466435403992,0.01188073974948805},
{0.11585418013877335,0.8897529509633773,0.022241296994042332},
{0.13241250699949517,0.90867831815017,0.015602360970229257},
{0.11387381415072549,0.9040594925008681,0.02711918614650233},
{0.13176184913292394,0.9221446755029786,0.01901415691451848},
{0.11230658157930974,0.9314176840621311,0.03411660240818141},
{0.1293018612239173,0.9363644039980075,0.022993552765267742},
{0.12504483713944495,0.9529808292945695,0.029752713389355243},
{0.10972957885989273,0.9422311191097805,0.03831998954079439},
{0.11790278204570706,0.9679925331612653,0.03853564032621602},
{0.10329386343141,0.9539934746211364,0.045235302104213684},
{0.11092674372810313,0.9779924537840293,0.045071714358247035},
{0.09728182787196986,0.9625174495919386,0.05100612009641937},
{0.10513548966066275,0.9836783796504874,0.050155327494271165},
{0.09346867187155372,0.9924897981197706,0.06007221494294621},
{0.08450234076404438,0.9722136794787246,0.06158168368982026},
{0.07506755383853966,0.9951901732642707,0.07231650986832854},
{0.07938527889117454,0.9739870821821024,0.0651682210900284},
{0.06177110466733746,0.9804636449750327,0.07763311161224455},
{0.07648903220690143,0.9683357576025188,0.0656527878223993},
{0.1559663292051821,0.8642742462801491,0.027457602099465305},
{0.1809337106451646,0.8565392103933043,0.01607557570447096},
{0.14903909456512496,0.8681631359711415,0.006944677803121421},
{0.14035891808294668,0.8872613360901502,0.03864277790681312},
{0.13089878744982827,0.8985874328262393,0.021150600483831827},
{0.1367419062685467,0.917795695276455,0.04702521229832102},
{0.12704034738700584,0.9450432668210138,0.03302150637904529},
{0.13415139516707641,0.9399874264227708,0.0524035808093505},
{0.11432693981404206,0.9713105264048559,0.0657208130600971},
{0.10632862680027931,0.9762650043656548,0.04721401982179086},
{0.09417138038456895,0.9848631143286066,0.07611992496205307},
{0.08659060030636392,0.9884583268365553,0.056674051310820865},
{0.08226540226806113,0.9831131592021504,0.07976966671865741},
{0.07463133224230635,0.9867777725720246,0.06013789790155403},
{0.17343088260651499,0.861241614509182,-0.0041000480099051785},
{-0.016738607992583688,0.8542035987432767,-0.023519908730926485},
{-0.0093573306063917,0.856207523845346,-0.01607294838612663},
{-0.01627634868011731,0.8771591111611016,-0.01699249741362506},
{-0.011774575020258972,0.8796535640338607,-0.012071604512793526},
{-0.003398808068700323,0.8593193841360074,-0.009678142287146673},
{0.0012733818862176506,0.8635021369052088,-0.004207867206110481},
{-0.008440520434337063,0.8839431569513936,-0.007746220579324799},
{0.005098125351973164,0.8687480365210384,0.0008131240450371818},
{-0.0037396158727975456,0.8922402158897225,-0.001279398693086347},
{0.010393361544825038,0.8780912019157907,0.008019077503790542},
{-0.0014357427240895338,0.8994083334857155,0.0024670085497710283},
{0.014730952594185972,0.8912190565645588,0.015257835262814653},
{-0.00017537349948285822,0.9105298092162248,0.006177476060559958},
{0.01641268419476733,0.9054202699010674,0.020191492965036018},
{0.00036001697123726667,0.9239787791745188,0.009673544480044132},
{0.01773446078916673,0.9327395102285745,0.027394149882847944},
{0.0026266986937599243,0.9381328990690067,0.01398879093046733},
{0.006345816526267381,0.9546377500870127,0.021314312159909053},
{0.019990546487234803,0.9434841144928078,0.031940067448095175},
{0.012588188589232968,0.9694624310238309,0.03104902234603033},
{0.025707442488326793,0.9550764626784689,0.0397191728822626},
{0.018845432265468302,0.9792775966377412,0.03852572591736956},
{0.0310816841266739,0.963445760478255,0.04630536425101249},
{0.02401331787668738,0.9848111008611958,0.044388859448946875},
{0.034401139745569354,0.9933152222282831,0.05587346279646894},
{0.0424974566907794,0.9727997077926278,0.05859496802482315},
{0.050953220528717987,0.995527349916128,0.07060255643899617},
{0.0471027119929727,0.974438088640528,0.06287427474317792},
{0.06295090692705556,0.9804475712396905,0.07771738408743949},
{0.049743675042460474,0.9687088492004221,0.06375169992608994},
{-0.021590509000854904,0.8757550325802655,-0.02239708953605343},
{-0.049704352018373144,0.8597596210678237,-0.0003199937420251364},
{-0.026802117155086923,0.8664920375740477,0.014163371277242494},
{-0.020089926042909507,0.8689267313474849,-0.007248504862221283},
{-0.03929639150652174,0.8642122192598036,-0.01922201249598459},
{-0.010951232937604468,0.8916239362358265,0.029109193897153416},
{-0.00466816222632414,0.8866229349115154,0.005981864774019235},
{0.0008199216116025693,0.9071458231887499,0.013933889891480039},
{-0.007859734364111243,0.9343620032362983,0.040113716782307615},
{0.003688643418315706,0.9467688201086962,0.024254715142582126},
{0.003180715860100337,0.9607149233125742,0.05128596667912185},
{0.023041755381778137,0.977426663257184,0.04129240367103047},
{0.014423420024779688,0.9743892973559923,0.059873666512784716},
{0.031224786225361543,0.9857418655637019,0.07164480866898064},
{0.04157666836217522,0.9890867144622552,0.05347417585562479},
{0.042441725320051214,0.9836696797567245,0.0769391029929921},
{0.052874174421753455,0.9870814633080028,0.058591250121505734},
{0.16013102535727178,0.8621343698467728,0.03731485437892887},
{0.18604160168985154,0.8536811093970681,0.028809691998912812},
{0.15574196613298663,0.8661325535022862,0.016147616277751572},
{0.14397280685856,0.8858001505143583,0.04667623749993657},
{0.13696329501808827,0.8973819026755647,0.028237010957918966},
{0.14062143923619,0.9135461813566839,0.053884198626481354},
{0.1331742558171911,0.943317329349988,0.03930610143068576},
{0.1375632778624431,0.9386398723653705,0.05954929184135055},
{0.11618302868719953,0.9710448326407819,0.07098514108337013},
{0.11413117981136862,0.9718965547187595,0.049880562046102486},
{0.0925747391979123,0.9880553432959797,0.0583917102504596},
{0.09621992032644734,0.9843797621113193,0.07877202932848204},
{0.08395333037417146,0.9828244020444971,0.08112050492398806},
{0.07881517559648077,0.9866030435091165,0.06086412834955747},
{0.18102036257848275,0.8585374471032982,0.007922399624526467},
{0.15862393606852085,0.8741183495748802,0.01720495080219372},
{0.15270233231077154,0.8527932740848673,0.013980103429715625},
{0.1620949953916898,0.8500915728881837,0.009776394078815134},
{0.16799655965055826,0.8712167615028411,0.012895714962133684},
{0.14510665583327478,0.8564690535577048,0.01775005739358334},
{0.15275878247614114,0.8785707618716944,0.020615866842697828},
{0.13756336461352048,0.8625316649952728,0.02210020256314609},
{0.1275665670295429,0.8762731719795928,0.029066846978367963},
{0.14517729599630583,0.8893773931562732,0.02586005622300148},
{0.142240152375541,0.8967860467038923,0.02853942521375822},
{0.1218486795875663,0.8900814277214715,0.03435670460442064},
{0.14061169832949835,0.9081219710977506,0.031778958304340146},
{0.11965141111997993,0.9045303525630088,0.03862733621503475},
{0.13904356106827537,0.9354128438229462,0.03816274701648948},
{0.1180306531338043,0.9318327631814992,0.04507770018258809},
{0.13343739662098733,0.9530180826858101,0.04404061583821484},
{0.11492223810021689,0.943041609639968,0.04864212845106863},
{0.1236779128057609,0.9685934950534939,0.05071673089520216},
{0.10767356593234625,0.9552574378189499,0.05380011204645228},
{0.11597563164714252,0.9790013192422236,0.05551406547578464},
{0.10104075205599593,0.9640902218392972,0.0580399965966313},
{0.10940116406685356,0.9850576969952293,0.05919602906114},
{0.09652112006720281,0.9944640295673447,0.06609397901606692},
{0.0863476972896256,0.9745844501011239,0.06542103851561322},
{0.07561036772288358,0.998096495466534,0.07379251748534577},
{0.08053535031736427,0.9766626836974976,0.06775959970227279},
{0.06054666278178824,0.9840773850345134,0.07598484114152},
{0.0772486989987395,0.9711365533156227,0.06755883292313189},
{-0.030351091338777947,0.8527783405065423,-0.00390425082819859},
{-0.021575612601563102,0.8552260841206235,0.0015920495760595743},
{-0.027297986313542758,0.876714536675415,0.003989427993200776},
{-0.01449179226678708,0.8586985686400643,0.006405495071017566},
{-0.021853401944429977,0.8810041295929482,0.008174027321049713},
{-0.008933502021216434,0.8631649726463626,0.010629033239610982},
{-0.0044569853178944505,0.8685366117523877,0.01455003322225457},
{-0.014807776869734945,0.8916640152335882,0.01469395325967205},
{0.00192521708883943,0.8783217119214709,0.02038730253975367},
{-0.012073878630322688,0.8989932543663472,0.01777609510981636},
{0.007095606088292262,0.891735882304714,0.026405348709556964},
{-0.010591699293798478,0.9102336782169922,0.02103049981366798},
{0.009080954066785489,0.9060745589198784,0.030767688602000874},
{-0.009184113490832875,0.9374846578395915,0.027626494054164806},
{0.01053160558317794,0.9333312021485317,0.03743527726738023},
{-0.00398001550130211,0.9549365331906121,0.03427244452223675},
{0.013414802426806911,0.9444581803759508,0.04142691741305487},
{0.0051672411746441025,0.9702481479249132,0.04229196197791986},
{0.020197522164915754,0.9564794134952986,0.0475812990975081},
{0.012399839607172303,0.9804475712396905,0.04815013830507393},
{0.026410807830928112,0.965135956505389,0.05273749809929938},
{0.01855294481148658,0.9863267661135988,0.05273803099877489},
{0.030584055160647772,0.9953847683239048,0.06140694223390134},
{0.040194860022210406,0.9752287255670004,0.06214060848853964},
{0.0502889551360049,0.9984495475655567,0.07199305227971267},
{0.045673810210987216,0.9771509435471639,0.06528223679176273},
{0.06449507610489225,0.9840216040917409,0.0762661624925384},
{0.04880056690094068,0.9715344185426312,0.06553629351845336},
{-0.036045704705987544,0.8740659643171379,-0.0016078258791365019},
{0.16662688406841933,0.87167740972387,0.028039912510051272},
{0.16051240787957313,0.8504796104574235,0.024210534058160073},
{0.17022852854910728,0.8475324532837237,0.021098648981476363},
{0.1763271292907881,0.8685250738590926,0.024826466707746606},
{0.15265525126176188,0.8543548802292625,0.02709810563469254},
{0.16061328698958585,0.876236104483518,0.030730583926892985},
{0.144849575211886,0.8606194605680442,0.030568879918607173},
{0.13447712067671588,0.8746922699169799,0.03636718560933966},
{0.1527308362362051,0.8873089872176684,0.035074259944683425},
{0.14970572702295015,0.8948093614401286,0.03737316349595714},
{0.12861031881386548,0.8885992359919364,0.04093615417515493},
{0.1480611496695209,0.9062133606437289,0.040345007547684546},
{0.1263833071197396,0.9031275876413448,0.04488580679936479},
{0.14639317431121396,0.9331388874029323,0.046389017075654515},
{0.12478374118247333,0.930385371027015,0.05107683461751677},
{0.14024488998820134,0.951306521107612,0.05161646349801871},
{0.1214570976171642,0.9417589329954568,0.054257401761484345},
{0.12297431199594955,0.9782768609948014,0.061300845666233124},
{0.11391342221406706,0.9541508038965189,0.058658172381219356},
{0.10674247901155283,0.9632594935220522,0.06217403243936328},
{0.10207316423520028,0.9937427935027976,0.06969910593286219},
{0.09185761761303655,0.9740750105955597,0.06799010970795306},
{0.08076709962415038,0.9977530851301148,0.07523754257471782},
{0.08585938786791514,0.9762313449476211,0.06973132776161318},
{0.06518534203480515,0.9840265241171309,0.07569608398386676},
{0.08246495453211827,0.9707301616970061,0.06918355667284609},
{-0.04007218160574643,0.8504684567474712,0.006148959742115317},
{-0.030815866432489108,0.8531503043404394,0.010610443723023862},
{-0.03682258539018537,0.8745162148018888,0.0135755707627578},
{-0.02334164146336152,0.8568122656059471,0.014586121670455698},
{-0.031096159163589734,0.8789361078376863,0.01708926204396655},
{-0.01747724384465628,0.8614299634912427,0.01814911234965349},
{-0.012791198503375309,0.866869293223667,0.021503590617799107},
{-0.02364277923906178,0.8898248056414919,0.022741974640788736},
{-0.006018678213367226,0.876889079843157,0.02659372247763977},
{-0.02076634897947052,0.8972421590828741,0.02546100126693132},
{-0.0005670050419292463,0.8904569855285756,0.031958656964682294},
{-0.019227149399068163,0.9085495299792544,0.028452674136351667},
{0.0014964312992409444,0.9048711107950616,0.03600745367735679},
{-0.017684554133635837,0.9354262778469331,0.034724070631215284},
{0.002959562577768897,0.9320848370264206,0.042415929267533826},
{-0.011834718302923883,0.953430707988989,0.04080603995205615},
{0.006117809908820867,0.9433700863980622,0.04605818564545909},
{0.004633734441604804,0.9799282916833456,0.052887874895478124},
{0.013305731536484688,0.9555562209225492,0.05150616569960181},
{0.020159128616657897,0.9644703154884486,0.05602024561944083},
{0.02455982487832654,0.9948246414031128,0.06418793391533434},
{0.03436393592637306,0.9748781272841672,0.06390289466099851},
{0.0449711140909831,0.9982524986897334,0.07269201810338834},
{0.0401130661492271,0.9768695602310902,0.0664794016599732},
{0.05994437483737661,0.9840997048474289,0.07532429365212438},
{0.043397214079618114,0.9712753550394732,0.06640628289473052},
{-0.0460518094412697,0.871630712858203,0.009017941802060676},
{0.14676816203980936,0.8204934685082838,0.11084034585151174},
{0.13851975806289452,0.8071386730410202,0.10787575171125331},
{0.14240623111673034,0.8095813107345452,0.08581619202787218},
{0.1507002165883167,0.8256347711107831,0.08930838143489517},
{0.149806841600173,0.8413677110420257,0.11250409519304784},
{0.14931673519185915,0.8590697765002867,0.09154798442825597},
{0.14760134417324397,0.8592698492708083,0.11447874800299795},
{0.14447529388492086,0.8830381201398443,0.12100382943422044},
{0.14604139869233038,0.8806034263664074,0.0976968636157994},
{0.14234344812271013,0.9051876778695291,0.12967582652910034},
{0.14407680900735942,0.9089931749891116,0.10802448023696132},
{0.13836478345961328,0.9325891706114292,0.11169876015546065},
{0.12827139474744909,0.9412997967217771,0.1352101486912847},
{0.12442519897955204,0.9544159275820842,0.11489889586388895},
{0.10721958515126673,0.9654095817965406,0.13893036950177634},
{0.10617583336694424,0.9726881335140722,0.11766147153088963},
{0.06947810756316902,0.9806947250592215,0.13958633157708047},
{0.06950079916641631,0.9871756377990332,0.11823432607403829},
{0.05277007312886557,0.9770815426852385,0.1374653296995455},
{0.05444683513201268,0.9834677232485222,0.11622742664931505},
{-0.022748003840668427,0.8118876005204098,0.07407505335144786},
{-0.02208869565237865,0.8093818080425322,0.09645930992455067},
{-0.030309822611954567,0.8229875371977,0.0982551067989106},
{-0.031051296463559426,0.828465644661725,0.07642635455347513},
{-0.0329144245669979,0.8408004085678312,0.09931187124484407},
{-0.03135485087641607,0.8585981480714606,0.10143172057235066},
{-0.028971873138124344,0.8606898156918211,0.07908901776532559},
{-0.0280057016030254,0.8819906752382264,0.1078162156861303},
{-0.02604083927181115,0.8829280578086374,0.08563278785722366},
{-0.024952088464336792,0.908432106199479,0.0944755358584618},
{-0.025471120160460256,0.910933164547132,0.11803778531166823},
{-0.02102121125187989,0.9305115070935641,0.09974627106845185},
{-0.012240056515600421,0.9431552659443817,0.12545254861373917},
{0.0023920246363641783,0.9653579649054836,0.10831286560428283},
{0.008551090878997313,0.9665307775069648,0.1318414804254776},
{0.031498609804689805,0.983014448869073,0.11446603277365235},
{0.046582775607042076,0.9810177117134171,0.13795943905043115},
{0.06518794456712737,0.9845709490929124,0.1172463552324882},
{0.06330165392602137,0.9769340534606363,0.1382138675674535},
{0.15853448331470363,0.8271992152547109,0.09024421487892391},
{0.1547756954537993,0.8163835122860376,0.07804273780674724},
{0.16104032536462518,0.842618810294361,0.07445033851230863},
{0.15855873643734433,0.8365966620378975,0.09829110849603431},
{0.1592356798803698,0.8496063369332157,0.0802657961303455},
{0.15207735276311263,0.8521943942184965,0.10742582344478974},
{0.1526645088410223,0.8624019473485278,0.08769952073933532},
{0.14524295416889155,0.8755753834919675,0.11683095389483245},
{0.14552703916137588,0.8856673965799045,0.09682450717441014},
{0.1411575856805846,0.9022208529872802,0.12357189679266457},
{0.14269621518247833,0.9112882986720126,0.1026136916090039},
{0.13707349367241675,0.9210168619246488,0.12564362405823262},
{0.13964750967616874,0.9257211621712182,0.10404136648289462},
{0.1249475891816722,0.9429353395701449,0.1285815732247162},
{0.1276253842600246,0.9476661112883344,0.10697613064553627},
{0.10269828010598085,0.9659634626397593,0.13192938405291257},
{0.10156821099963884,0.9731139945530608,0.11062025836813132},
{0.0642280191096017,0.9793710151550971,0.13203800879483663},
{0.0642235700186319,0.9857700472708479,0.11066363390683458},
{0.0477595663650731,0.9749263484901943,0.12971721918603435},
{0.04939667073283427,0.9813163089218507,0.10847683753359226},
{0.15792969198205833,0.8324973018401061,0.0630589058219212},
{-0.033699100455151294,0.8190158126207957,0.06464554584865391},
{-0.0400389683361108,0.833230645876457,0.07931794146559042},
{-0.03886979927988054,0.8471185019283618,0.06197783868130282},
{-0.03425367530698927,0.8351816032492639,0.0493980897326004},
{-0.037360479249139156,0.847154429267419,0.08958586095248557},
{-0.03493127557960082,0.8587573734775347,0.07078235424342678},
{-0.032065069554132464,0.8605239724178418,0.09733177790303946},
{-0.02959515484326828,0.8703120964816233,0.07754386953961531},
{-0.0281216258284627,0.8780490284991602,0.10471306768224252},
{-0.025583537163768075,0.8857067319970028,0.0840117820108269},
{-0.025705794217856,0.8934996308524775,0.10897167807213032},
{-0.024217802559145612,0.8980984170028987,0.08729097273679468},
{-0.018662350313107232,0.9313189737290534,0.09336667119404016},
{-0.020007909095727097,0.9232104496679512,0.1144775210949032},
{-0.007992104115222652,0.9446714888822824,0.11936004523349893},
{0.007516832141145298,0.9661998469326809,0.10210913494979632},
{0.014020250589038299,0.9669643841778649,0.1255568977668482},
{0.037534613447516255,0.9823665794299897,0.1079396128972356},
{0.052800981298444405,0.9795311824300117,0.13122595674525597},
{0.07128564061900096,0.9822438514414814,0.11028288342809721},
{0.06929486450166426,0.9746264376225887,0.13124775605170713},
{0.18880069492074492,0.8509294891518425,0.05721312250582519},
{0.20143282912718985,0.8489372878382345,0.06771156439141167},
{0.21470818539357117,0.8432829393639526,0.05070648187505712},
{0.20154566749287364,0.8457925241032135,0.03964231142768039},
{0.1839364132944267,0.8506282398390429,0.05472708448757449},
{0.19057910440059028,0.8510495650359844,0.03356601810590412},
{0.1797686436755946,0.8513184685899228,0.05423384264746294},
{0.18060892700436554,0.8579971861792322,0.03330204697036703},
{0.17356788734376202,0.8549210549394511,0.05635525349436283},
{0.17153182716401916,0.8664213106599392,0.03784758035227147},
{0.16169840664482021,0.8698113568698217,0.0701006270981329},
{0.15927434607487104,0.883914603453916,0.053734416694833406},
{0.15578570106901057,0.8834002439229615,0.07986631981189939},
{0.15568410316435646,0.8921931224477017,0.06000404098911571},
{0.15171086664010308,0.8982880796441317,0.08405639685063598},
{0.15287101358428312,0.9056326365385586,0.0635390358563333},
{0.14609027672794347,0.9201899134757765,0.08749843174190691},
{0.13791690003997426,0.9450459065323692,0.06931090725447892},
{0.13274622600126718,0.9472574641417054,0.09103010528216095},
{0.10527546872056372,0.9836649580195113,0.07509742719169518},
{0.10263205185488647,0.9796132489492382,0.09567019733843853},
{0.08038789827179521,0.9915429596819222,0.0966501870808672},
{0.08188492443556702,0.994284380479047,0.07555728226001626},
{0.0638890454711411,0.9927140744408888,0.09554349119338072},
{0.0654034714224384,0.9952818939391118,0.0744047322316149},
{0.19076575554013606,0.8594256665988416,0.046746543051669046},
{0.1886469967976026,0.8371185813055975,0.04818233534780282},
{0.19567011616421612,0.8359300791521166,0.05455234303165558},
{0.2015989574404234,0.8571407423640414,0.05231912243898969},
{0.1801416980944649,0.8401958403093851,0.043135901244952944},
{0.18542361180042935,0.8616754194682589,0.04903001730417545},
{0.17156075245182867,0.845522294497092,0.042645138007053},
{0.18138717091977977,0.8646446981666974,0.051887845654168534},
{0.1642179057929278,0.8518848291952767,0.045877247684011135},
{0.17501022314973447,0.8715841894946909,0.05896701860979775},
{0.15546772119128238,0.8620095598324068,0.054279771146444174},
{0.16741662869809543,0.885925518214222,0.0714886691226599},
{0.14610757737138055,0.8798233730713785,0.06917346876184481},
{0.16077388801988754,0.9115348948060463,0.07793672799015643},
{0.1355674453965947,0.9192029960401664,0.07719007385992926},
{0.1553247058436722,0.928764947652138,0.08041285159956067},
{0.14661489767205405,0.94562570116171,0.08269688353756469},
{0.12794855680938613,0.9363644039980075,0.07945735044698275},
{0.1357573435050376,0.9623474546592548,0.08545681949320999},
{0.11945558915225117,0.948373169748231,0.08130762699795399},
{0.1224572136095512,0.9770951626043914,0.08763427153611453},
{0.10846425243086283,0.9605481381697545,0.08310462599438655},
{0.10871211265202436,0.9867940322025326,0.08880045387667979},
{0.09726098282737024,0.9705925001301728,0.08455956549260506},
{0.09114006227277381,0.996472862301793,0.08960228169213752},
{0.08364475679183637,0.9779502803673988,0.08513831910901737},
{0.06969519593787338,0.9990629892199205,0.08824648628238364},
{0.07025782624689916,0.9808057292592689,0.0845831122136154},
{0.049269022718936045,0.9962597396906274,0.08622890408212834},
{0.061981761069302706,0.9787038621908075,0.08351359535930317},
{-0.07030246587273029,0.839644239780201,0.035645565361449826},
{-0.06241925914567499,0.8406245393479058,0.030335160123062845},
{-0.06369205856037294,0.8629783338998279,0.028658137866683565},
{-0.05320257682178142,0.8434538885584876,0.026547868336724876},
{-0.058666667790299644,0.8650834107581532,0.031678562521758644},
{-0.044494007951269114,0.8485388525327172,0.027286479402775347},
{-0.05499337931268496,0.8679449074394195,0.035084161960518834},
{-0.03750808001084088,0.854701884538889,0.03153728219569654},
{-0.04962737902669145,0.8745394764836449,0.04286730751629119},
{-0.032193944476125426,0.8612255407738398,0.03766190826059932},
{-0.02814639945756777,0.8677851243478478,0.044257468745709114},
{-0.04333606696305748,0.88898708766601,0.056694536958099874},
{-0.022081743173175097,0.8823216058125103,0.05737255859308739},
{-0.03697641983644929,0.9142961692068857,0.0638793355469771},
{-0.011717046662927407,0.9212534321127366,0.06672023504386485},
{-0.03145658510419185,0.9313724867508022,0.06713497955193452},
{-0.022692210504885013,0.9479902380995474,0.07066204289207495},
{-0.004019685529699074,0.9382072075633107,0.07007585346902781},
{-0.011874375938309733,0.9644084743632689,0.07496241772922846},
{0.00445710924800507,0.9499792048372697,0.07313320929705595},
{0.0013898761901635884,0.9787868705788746,0.07902732535627847},
{0.015417537799814576,0.9618469009426193,0.07649047599268964},
{0.015096534027388269,0.9881014824761489,0.08214664623959701},
{0.026577407078581812,0.9715790457754514,0.07953543880965971},
{0.03264008048120527,0.9972895865165428,0.08544318718104611},
{0.040173767117389535,0.9785574883372007,0.08204874145223819},
{0.05412460445149155,0.9992812177516421,0.08713979039489717},
{0.053579336750958155,0.9810387054741497,0.08339710105535722},
{0.07454582046600558,0.9959065016964389,0.08802589068554983},
{0.06186153646902828,0.9787063160069969,0.08350492025156252},
{-0.07526340059229046,0.8610073122421178,0.03263778157765398},
{0.15529866812743914,0.8225741559208467,0.10781874386038615},
{0.1515395456552362,0.8117584529521734,0.09561729157423159},
{0.1578047456445708,0.8379939368556629,0.09202497903087038},
{0.1553230575732015,0.8319714044158566,0.11586552594039701},
{0.15600003819526012,0.8449812652063405,0.09784031271879667},
{0.14883967862418945,0.8475695083867871,0.12500045157034043},
{0.14942830947041505,0.8577765038313209,0.10527386382563167},
{0.14200717616066016,0.8709503117650924,0.1344054828762947},
{0.1422911620090561,0.8810423248530292,0.11439901136985027},
{0.13792020897392676,0.8976008871809611,0.1411472561058677},
{0.1394603999952138,0.9066632393381484,0.12018822059046613},
{0.13383767848515227,0.9163929303547913,0.14321815303969487},
{0.1364117316679374,0.9210961028373542,0.12161589546435687},
{0.12171101802073316,0.9383112221051212,0.1461562633153222},
{0.12439234510723707,0.9430368879027548,0.12455007715547878},
{0.09946288628109234,0.9613380191225522,0.14950388824835267},
{0.09833753891196341,0.9684857130363216,0.1281945890614166},
{0.060990729154021324,0.9747461293233877,0.1496124634182325},
{0.06099204281319342,0.9811453597273153,0.12823771673989873},
{0.0445237387847975,0.9703012891563303,0.14729174816749657},
{0.04616084315255876,0.9766912371949752,0.1260513665150545},
{0.15469263749368797,0.8278722301132309,0.08063343480338342},
{-0.03311189480519735,0.8143374261603488,0.08249137023518856},
{-0.03945046141999579,0.8285564110747142,0.09716821494309492},
{-0.03828147825893137,0.8424469192309855,0.07983050400994152},
{-0.03366499488871944,0.830503216788817,0.06724402565623457},
{-0.036776768428303616,0.8424669711228775,0.10742657941846429},
{-0.034342694305419474,0.8540797429907622,0.08862856281330422},
{-0.03147762843696844,0.8558457718525606,0.11517771382667362},
{-0.029006486818009523,0.8656350236803484,0.09539103237134423},
{-0.027532945410192914,0.8733706420387133,0.12255900360587668},
{-0.024996096046604053,0.8810283331435445,0.10185771793446106},
{-0.02511929496953239,0.8888168944451493,0.12681765117479765},
{-0.02362917171292002,0.8934200181494407,0.10513814796153464},
{-0.018081898854180017,0.9266195935078738,0.11120845545896987},
{-0.019419228677457313,0.9185320632075042,0.13232345701853734},
{-0.007403485662008089,0.9399942301858417,0.1372078648948139},
{0.008099985276483222,0.9615169122371755,0.11995358371210352},
{0.014605200710979599,0.9622837174033834,0.14340205293078567},
{0.03811468072310076,0.9776849707866674,0.12578490438429474},
{0.0533790656922596,0.9748512716292046,0.14907159523662475},
{0.07187393685392794,0.9775648949025258,0.12812992232971554},
{0.06988354491993404,0.9699469110051245,0.1490936919753413},
{0.1602211845127193,0.8247380500096538,0.09965670677753513},
{0.156462632119025,0.8139221611458145,0.08745675404571861},
{0.16272868722612258,0.8401580292326469,0.0838646150045122},
{0.16024808973972637,0.8341313327411249,0.10770177862201998},
{0.16091764694816127,0.8471582215288027,0.08968928062976524},
{0.15377265471080256,0.8497281230528835,0.11683547734386865},
{0.15435443222191308,0.8599409679986366,0.09711315279496387},
{0.14698170601335106,0.8731104383785379,0.1262471636967611},
{0.14724621004836366,0.8832075573870305,0.10624149773603546},
{0.1430250265518713,0.8997789712674295,0.13300176369277922},
{0.1445427614371211,0.9087662465636269,0.11202246560429768},
{0.13911957979810557,0.918477410028738,0.13506231246237288},
{0.14165889537089502,0.923220289718731,0.11346872999477554},
{0.12721356450256457,0.94010466430738,0.1379590052950441},
{0.1301614280778946,0.9444133672479648,0.11628080334794219},
{0.1043673088702277,0.9637437752151686,0.14140255213366412},
{0.10340755691485684,0.9705578988432987,0.12002097690623735},
{0.0656667113703231,0.9773782437629801,0.14157332782604445},
{0.06681626229004836,0.9846202980629455,0.1204861981483466},
{0.04943382497998637,0.9729324493340711,0.13925240189412055},
{0.05107344512899241,0.9799318856565525,0.1181718900843277},
{0.159616393180074,0.8300359506998829,0.07247263702163823},
{-0.09265942064247212,0.8475749984906861,0.028856376471568596},
{-0.08176989250692586,0.852891798522779,0.04758017133350181},
{-0.06772967677707303,0.854512221897656,0.03897804603496734},
{-0.0779985257397975,0.8496963473725305,0.019770118196050266},
{-0.06257295726881731,0.8540710430969995,0.03720336685145039},
{-0.06614214445354415,0.8546349498861642,0.015316070021776563},
{-0.058359333509070355,0.8546436373869158,0.03730622884323244},
{-0.05604554595151586,0.8613011753203272,0.016478546852035456},
{-0.05232455677433865,0.858170403294791,0.04036887648698241},
{-0.04735922253585282,0.8696277296249743,0.022395738697848108},
{-0.04222236902432319,0.8727114206015005,0.055810246047061675},
{-0.03711647325441664,0.8867104791416295,0.0399794137214712},
{-0.03737546239950836,0.8861503646138489,0.06634182684421745},
{-0.03422145347823825,0.8948972898535859,0.04671005802711406},
{-0.03350761604129288,0.9008744390868972,0.07089006190253255},
{-0.03138028133510724,0.9087677585109761,0.05054707057381705},
{-0.027827006776578997,0.9226070215665223,0.07513347846086313},
{-0.016439168059398414,0.9472567081680306,0.058348904790264985},
{-0.014368878383113062,0.9493086561879504,0.08057099881367281},
{0.01608724372438216,0.984915115403006,0.06875776999192365},
{0.015684966585436902,0.980835422913764,0.08949107920391337},
{0.03787987034258328,0.9921365477325711,0.09362753168380167},
{0.03945872755837157,0.9948766424775125,0.07254082336847978},
{0.05439601139366343,0.992846630087166,0.0948680720907154},
{0.05595875769507621,0.9954146354805548,0.073733031032267},
{-0.037389912650402105,0.8327626114208375,0.058468769993218726},
{-0.03676858904100529,0.8166200824741253,0.07371995640560072},
{-0.04310837017088739,0.830832449520586,0.08839048067786746},
{-0.04163657617762991,0.8454394596111797,0.07166550499744763},
{-0.04043729210452852,0.844748103096294,0.09865170793879124},
{-0.038003379090788075,0.8563578510694803,0.07985467038150479},
{-0.03514597210317097,0.8581308819825265,0.10640717990087091},
{-0.032672327095978344,0.8679140860209184,0.08661801984332991},
{-0.031242198405898123,0.8756521581954723,0.11378351247565077},
{-0.02868670995367795,0.8833011617995522,0.09308098750312932},
{-0.028890562592572312,0.8911108903640439,0.11804128014078659},
{-0.027358216347285032,0.8956792268862954,0.09635522102467386},
{-0.021962373690663634,0.92913919180007,0.10245589139920136},
{-0.023434589046297118,0.9207466323185277,0.12350706895181976},
{-0.011692322605866529,0.9418553754075106,0.12830052451994106},
{0.0042892830922565475,0.9636842144040235,0.11114295839552792},
{0.010984495779284379,0.9648233675874713,0.13469748700284515},
{0.03740772140729259,0.9816173599464733,0.11762678349293806},
{0.04997267310079168,0.9775991243990682,0.140458737590514},
{0.05617688708270945,0.9842137329421742,0.11960328286153585},
{0.06623505485744657,0.9726968334078349,0.1404458488590136},
{0.06778791153603497,0.9796977816776654,0.11936037984479748},
{0.18783457295769018,0.8217886249149302,0.14802934300664028},
{0.1895708585929492,0.8277829756475905,0.1267051722064345},
{0.1626548868452717,0.8359196690228278,0.12686212969148508},
{0.15819013110944385,0.8331438452270062,0.14882652344295122},
{0.14249723299692982,0.8604216681115575,0.1316095204375035},
{0.14166017185103394,0.854088244596348,0.15296616092668144},
{0.13423535781699494,0.8904393874528731,0.1607299733852032},
{0.1341244031889919,0.9080971974686454,0.14166740317298634},
{0.12891274546271578,0.9116213112721542,0.1646654607977737},
{0.11321076327309612,0.9449784018011358,0.1475476018807906},
{0.11227087731445139,0.9384131422280627,0.16891988234992383},
{0.09173431954601974,0.9553824337284818,0.17186695277254616},
{0.09144618203891942,0.9621765054647197,0.15041230835192096},
{0.07899984385425722,0.9643627069734314,0.15007026124671793},
{0.07778410186247064,0.9576902354616951,0.1714605983329628},
{-0.05201900708670167,0.8371662324331159,0.11113744350560707},
{-0.07469691605682567,0.8314725609347468,0.1079194742542662},
{-0.07616191868002332,0.8254757439928858,0.12926276747053458},
{-0.04662274306770435,0.8360045859345978,0.1342678956675279},
{-0.03356919691324051,0.8536892392123221,0.11683468419116093},
{-0.028605213512959988,0.8612058730652906,0.14221464136227793},
{-0.02591097290893358,0.871077389700482,0.12189808432614933},
{-0.019970085625977883,0.9090689954307648,0.15318424074227047},
{-0.01863530876297853,0.9136743994490907,0.13146478246135623},
{0.002594885834373846,0.9482366359454041,0.14024819272564829},
{0.0011060266648893786,0.9427991899506608,0.16184347303576058},
{0.02278391878671485,0.9631356253765266,0.1455307012961435},
{0.03298735743707477,0.9595929840214863,0.16861790184947162},
{0.035209176459567205,0.9649735089164398,0.14695713686892845},
{0.1702193081488801,0.8559248144770889,0.09248343368894191},
{0.18466535781185184,0.8604362298995506,0.09958728112958776},
{0.18103038852442868,0.8608185914697256,0.07488717975909485},
{0.16868583413958646,0.8597836387232541,0.06983606109806503},
{0.15967709414823644,0.8596584445255456,0.08962575405508152},
{0.15943555436271453,0.8653324607083767,0.06798407431156778},
{0.14807542641825977,0.8747368971498001,0.08987082584875504},
{0.14981780941495937,0.8791995336807371,0.06853013516480887},
{0.1407142381029929,0.9075611005962952,0.0967271972515821},
{0.1417978458108782,0.9130989547666312,0.07585103380112593},
{0.1306935591867064,0.9406193956286665,0.10273089231458014},
{0.1310804194198954,0.9470027381924176,0.08217552195536235},
{0.1128387994391989,0.9657420243181732,0.10641851950598906},
{0.11625446200293829,0.9681201811751636,0.08529199244613754},
{0.09162450507503406,0.9873131134707003,0.08777247839543423},
{0.07979624353087152,0.9875269920555406,0.10892105262195807},
{0.05479426080401485,0.9944700773567413,0.08642478801491234},
{0.053254590289192244,0.9901723422309431,0.10737757745274064},
{0.19135116420348658,0.8631935261438406,0.0785204264179809},
{0.18016524481547525,0.8444602878074812,0.12357397881852233},
{0.18764320008093133,0.8423175733745724,0.12355910720525264},
{0.18331432131834424,0.821448808551718,0.11796614131474145},
{0.1730095202305403,0.8244615867189701,0.11799960244459826},
{0.17369960026528727,0.8475749984906861,0.12391570370543781},
{0.16454387916278845,0.82838394993283,0.11840361460509165},
{0.15772271630437737,0.8331986843009382,0.11915834897852869},
{0.16790961028497478,0.8530812752688458,0.12492437087545487},
{0.1520435446289462,0.8388195592523522,0.12020332767094592},
{0.16149143096713925,0.8613458025531474,0.12659663421558787},
{0.14368144716858464,0.8490829057181667,0.12225040523751945},
{0.15784544429288555,0.8688410708550515,0.1278830287634165},
{0.13695081525595276,0.8628117346521742,0.12492605632495879},
{0.15503594868601897,0.8801868352996898,0.13022655954751033},
{0.13332464500638092,0.8772905390433725,0.12801936427806643},
{0.15073448326389235,0.905429341585162,0.135530284952937},
{0.12893921693433583,0.9029122095021663,0.1333867897603316},
{0.14398510072552967,0.9247185427905978,0.13901320438768855},
{0.12453175408862939,0.9165219044208726,0.13559273333565866},
{0.13526288714984241,0.9407279460125242,0.14174214542267763},
{0.11739465619931473,0.9294328689831133,0.1376462552679824},
{0.12429405613653545,0.9552867472901022,0.1443085397246289},
{0.11145751160569854,0.9379490859289931,0.1390220034255398},
{0.10725343046446631,0.9699765922666084,0.14695837617003424},
{0.09812597782019092,0.9513660819187573,0.1415029603092567},
{0.0863848515367777,0.9755844297703894,0.14692615434128325},
{0.08857716279994085,0.9567273232885045,0.14219326341820274},
{0.07066430461659307,0.9695155598622369,0.1441984526074},
{0.08055765773726885,0.9551632633279196,0.1412092459471802},
{-0.06417703426210875,0.8671654366159106,0.06948759441313394},
{-0.04900384946132627,0.8622427219424538,0.06449002595288607},
{-0.05706785782670789,0.8673955748312593,0.04554930382539225},
{-0.06773710019069684,0.8700666405046071,0.0476940507121145},
{-0.03727226579642776,0.8662522575960963,0.06313574249048128},
{-0.04417473920039087,0.8660115357493039,0.042294738012396874},
{-0.025559618652425963,0.8821128331482261,0.0658031150465338},
{-0.03409359478315204,0.8718044876592596,0.041794903090402416},
{-0.02416375663792129,0.8868840804405314,0.04451438825795416},
{-0.012984876480191055,0.9376656205870615,0.07858975292183981},
{-0.010218545730839705,0.9448337381830548,0.05836738276975258},
{0.017039745768284036,0.9781760686358661,0.08897358424116115},
{0.013797064852893358,0.9780531547521921,0.06683557679778239},
{0.04322139443173715,0.9953042013590164,0.07277793884905401},
{0.06831711789423706,0.9947091013610183,0.09632655599009653},
{0.06995417268995403,0.9966290514201581,0.07487938455513933},
{-0.06744588921685409,0.8249511726208194,0.10014127350990602},
{-0.07194082193460838,0.8459424795370163,0.10510591373977257},
{-0.06448394718096206,0.8478769913841492,0.10618286640071967},
{-0.05716959205448367,0.8276763213944248,0.1016371099446162},
{-0.05804201046092821,0.8508133790312394,0.10744322323231527},
{-0.04874110523388396,0.831362114420197,0.10324200487663746},
{-0.04196337987923146,0.8359871861470721,0.10496339411260466},
{-0.05230521128407696,0.8561598603248165,0.10927141543758102},
{-0.036330297811925254,0.8414562095339917,0.10681463731843843},
{-0.04596383145576839,0.8642432389664819,0.11184895105647351},
{-0.028065844885690312,0.8514809037858609,0.11004205004420556},
{-0.04235746523786732,0.871742274743748,0.11406359452556335},
{-0.02142938746408887,0.8651293640431568,0.11407969304692778},
{-0.03957896455165697,0.8829566113061154,0.11659796528694057},
{-0.0178626788815736,0.8794544331321796,0.1174778690720642},
{-0.035335077058906206,0.9081060956505852,0.12226573539219832},
{-0.013534927882992768,0.9049773932578957,0.1232458366717265},
{-0.02863465930723405,0.9271290330134384,0.12674164483797845},
{-0.009129323988945098,0.9183883414582633,0.1260910117574293},
{-0.019958312265472667,0.9429474351489376,0.1309143840542448},
{-0.002012030131301269,0.931153130455074,0.12936400597786804},
{-0.00934357436411718,0.956870673247413,0.13487060497431547},
{0.003856804185362745,0.9394363711860731,0.13150066022836934},
{0.007846634951422904,0.9713646095051135,0.13989188126471744},
{0.017132693351219634,0.9524963493132763,0.13574516737167305},
{0.02865696672713863,0.9763900002751866,0.1428228283799532},
{0.026634427322460047,0.9575922811022921,0.13779002658926717},
{0.04443203050296775,0.9698812900115718,0.14233330444315906},
{0.03466635018221225,0.9558028046635717,0.13794740543669376},
{0.15472733792465063,0.8205715568709605,0.11544540286552812},
{0.15096977697184102,0.8097539577715954,0.10324554927780008},
{0.15723455559879956,0.8359913501987877,0.09965319955540568},
{0.1547547140860779,0.8299616298125679,0.12348937173202881},
{0.1554271588660893,0.8429841562603533,0.10547254857891482},
{0.14827000908488266,0.8455659798610717,0.13262647853191847},
{0.1488574130230135,0.8557758009121266,0.1129025552845872},
{0.1414370852589775,0.8689463990560341,0.14203336878953143},
{0.14172063735198634,0.8790423779075094,0.12202827290731445},
{0.1373504898625759,0.8955956484197194,0.1487747702287727},
{0.13889029670052006,0.9046593266290901,0.1278148795956081},
{0.13326762476250267,0.914389017645733,0.15084605134594264},
{0.13584041385815993,0.9190935037874682,0.12924379377060466},
{0.1211438518696602,0.9363025752658387,0.15378338086187332},
{0.12384309925015402,0.9410055494602252,0.13217342722666825},
{0.09889141975518217,0.9593363743345175,0.15713184851965575},
{0.09776106560958583,0.9664863361693107,0.13582288394401829},
{0.06041538361565,0.9727435426665128,0.15724013865028125},
{0.06042166687225643,0.9791416329134232,0.135865714190235},
{0.04395364788311483,0.968298690106444,0.15491964647374437},
{0.0455908018229202,0.9746884522499235,0.1336792648213023},
{0.1541225837710385,0.8258694575611899,0.08826133310963122},
{-0.03368206006494644,0.8123335134512905,0.09011930572046953},
{-0.04002032924747944,0.8265434142885504,0.10478691763513763},
{-0.03885197812997902,0.8404367604443538,0.08745102847460977},
{-0.03423509818341323,0.8284993040797587,0.07487192396248238},
{-0.037341517942220306,0.8404774219136356,0.11506270668405465},
{-0.03491395015014161,0.8520731781773374,0.09625513506736881},
{-0.03204771933865119,0.8538416608553255,0.1228056121329214},
{-0.029576528147647992,0.8636309250761243,0.10301769137648621},
{-0.028103048704886606,0.8713667169366439,0.13018690191212448},
{-0.025566186948286718,0.8790255481984924,0.10948437693960304},
{-0.02568835725129728,0.8868205414728364,0.13444604520148778},
{-0.02420045234366434,0.8914161054403824,0.11276480696667665},
{-0.01864211252604941,0.9246398719564011,0.11884112507447503},
{-0.019989331972151095,0.9165292782624521,0.13995135532478517},
{-0.007973390668524913,0.9379901191886063,0.14483421407467945},
{0.007531208033972654,0.9595148832657983,0.12758207688288212},
{0.014033064962472317,0.9602790487206503,0.15102955466067963},
{0.03755441747918708,0.9756859781029994,0.13341357105722815},
{0.05281166407397644,0.9728486849723293,0.15669898542941915},
{0.07130384595224527,0.975561924062308,0.13575677962303448},
{0.06931349119728454,0.9679441260600725,0.15672159028158908},
{0.1884375673037321,0.8710654800168549,0.033116151804495834},
{0.18800258500860453,0.8516817325300569,0.022112397286027242},
{0.19785132328947125,0.8539099215602334,0.020377388130907205},
{0.19432919236773197,0.8727868816458333,0.031729373867096775},
{0.18416693569311798,0.8709155245830524,0.03494412093556253},
{0.17712522680991735,0.8520311906558726,0.025504364412623548},
{0.1792754266215051,0.8722528544063295,0.03753673884891272},
{0.16761111222062983,0.8549212408346168,0.029922472854828807},
{0.1721404975091256,0.8763890838120191,0.04209209988858621},
{0.159403220996864,0.859544986509309,0.03475452025938498},
{0.15233675087756923,0.8653623402580376,0.03960265379229454},
{0.16463928056191351,0.8840460313361869,0.047314836966748326},
{0.14637567537959992,0.8718612228638832,0.04370597975362459},
{0.1584075540954468,0.8945892491707262,0.05265849265380414},
{0.13769564761355443,0.886678331670945,0.050325099352755795},
{0.13293797066835775,0.9032019085286598,0.05557725743916979},
{0.15074422417058397,0.9244273194237438,0.06014779991738942},
{0.1292498105774734,0.9194987552490675,0.059576482107611975},
{0.14391815367979388,0.9418878946685271,0.06458698887140449},
{0.1243496016120978,0.933637929172219,0.062481403899625754},
{0.13357992864116625,0.9576840017771328,0.06729857969091224},
{0.11686299602492309,0.9450147009305248,0.06459318537693352},
{0.12062798039135658,0.9735099760423884,0.07060007783678454},
{0.10617275990020185,0.9569230461121447,0.06668760424574892},
{0.10703535064887734,0.9847479460768437,0.07247266180766034},
{0.09495955110184066,0.9668078108761572,0.06840775418061032},
{0.08983880850468655,0.9945209382741235,0.07400443797443894},
{0.08172631868004568,0.9740377572043192,0.06949462125040387},
{0.06830468770414584,0.9993617723235199,0.07406888163194095},
{0.06798373350376373,0.9772192166450827,0.06959376533886852},
{0.047610837839365025,0.9950799250378982,0.07241441465568735},
{0.05921193549083308,0.9754543279403015,0.06889356021408703},
{0.03417308355607865,0.9806122743566521,0.06861719606749186},
{0.051714163800695066,0.9668015647985838,0.06660209246944818},
{-0.0671273640466393,0.8576104746621758,0.0015412506237325063},
{-0.057688859217817176,0.8551131837898844,0.004646926801876108},
{-0.05913637530241193,0.8745218908009535,0.015518076102023257},
{-0.055174329667143966,0.874257907272405,0.01792975605392549},
{-0.04739522423297652,0.8551665109164673,0.009543405470923236},
{-0.050662009554875195,0.8754638092134116,0.021190369656317206},
{-0.03852430691760339,0.8578001373034088,0.015268976579755861},
{-0.04399589565781175,0.8795147623100102,0.026818221872956877},
{-0.030957121972529093,0.862202060473172,0.021222579092057152},
{-0.024489209501317576,0.8678322053968577,0.02703242267608472},
{-0.03724907847273808,0.8869173680682331,0.033169454145056634},
{-0.019004062807011612,0.874223305985531,0.03215445414638889},
{-0.03149190518570732,0.8973870085961209,0.039244483379704986},
{-0.010938703603424683,0.8888061125255289,0.039965781409307316},
{-0.006500753950515461,0.9051489125309394,0.045665327194917976},
{-0.02423391347352112,0.9270819395714175,0.04853306995375752},
{-0.002963776201528573,0.9213451403945666,0.05017886182227046},
{-0.017566498310296563,0.9441435094321748,0.05310856963640039},
{0.0018669823298775759,0.935348177091245,0.05377531363132506},
{-0.007307551363407462,0.9597573153481165,0.057695235422006594},
{0.00929288694888975,0.9465167462637749,0.05694668516108755},
{0.005509275886835971,0.9751173371836104,0.062415733334029},
{0.01990624922601774,0.9581264942369616,0.0605555423742113},
{0.01900778071032916,0.9859772955947721,0.0662154305244361},
{0.031033933855067128,0.9676999961352394,0.06386323702561265},
{0.03608036795791705,0.9952720538883315,0.07018243336412729},
{0.044175507567076555,0.9745621426812194,0.06682516666849361},
{0.0575140805828651,0.99951286791434,0.07330175424744584},
{0.057849918789528075,0.9773604721851226,0.0688724920952883},
{0.07810633254299178,0.994654832365595,0.07458195228974543},
{0.06657959295787229,0.9753514535555086,0.06941654528073798},
{0.0915391172288439,0.9798118097724107,0.07269573600670576},
{0.07408232185243344,0.966489174168843,0.06819211578819974},
{-0.06472314468739403,0.8764044015736866,0.013314611128907826},
{0.17637482999035067,0.8649270233516116,0.08705699268801814},
{0.17882927822341432,0.8430524293582721,0.08538491524305102},
{0.18507165028637992,0.8452843982568212,0.08839517762905848},
{0.18149751829024083,0.8668097324125219,0.08961464991717348},
{0.17209491601445398,0.842803379408049,0.08273157157551625},
{0.17159053285740125,0.8663165525374656,0.08543820519060076},
{0.16578689817191375,0.84478120482883,0.08096432819863414},
{0.16652585624227384,0.8698920973368652,0.08464313156616969},
{0.15946146814883697,0.8488064300344722,0.0800199807560085},
{0.1537235288149684,0.854126824039772,0.07975972752378883},
{0.16238744566663837,0.8758244334421906,0.08472933735108969},
{0.14855688250485508,0.8604931509993404,0.08016497898538803},
{0.15977986938894112,0.8833117454309958,0.08566545583437277},
{0.14081867400717932,0.8747896665908853,0.08237714385226623},
{0.13611427461652134,0.8908064436543912,0.08576663237665093},
{0.15449313480167504,0.9129465455166388,0.0921564688781966},
{0.13249551538756218,0.9084442017782719,0.0897187636030724},
{0.1502819648581176,0.9305495164584794,0.09482716276121268},
{0.1281864902286902,0.9251572553820536,0.09217381909367792},
{0.14353644893920503,0.9463505311994641,0.09747060441291205},
{0.12285994928990558,0.9387673344841027,0.0943921680730741},
{0.13127358928325775,0.9639275883551822,0.10029497163304832},
{0.11545016797827995,0.9494413977293933,0.09593261934759335},
{0.11701044807049214,0.9775662209547089,0.10224439227248419},
{0.10407712651630278,0.9609569836045606,0.09767632839647618},
{0.10123042709023981,0.9872066575057115,0.10320113272616792},
{0.09265321174393207,0.9690757071137636,0.09868016229218059},
{0.08160609407977126,0.9937724747642818,0.10312057815429039},
{0.07727474910798358,0.9745670503135984,0.09872353783088386},
{0.06152820165059914,0.9963588342070477,0.10207089011767108},
{0.062362238901796804,0.9765151820798845,0.09794401743533068},
{0.04485836247637667,0.9946722197601097,0.10042881615247558},
{0.052408172419947566,0.9748024803446689,0.09677287789034218},
{0.17778359312936673,0.8698756518111911,0.06821810393238854},
{0.18023709949358996,0.8480008595296747,0.0665450598325589},
{0.18647945916354453,0.8502328284282239,0.06955656151967217},
{0.18290533956041657,0.8717583484790903,0.07077604620079822},
{0.1735027372846297,0.8477518095794516,0.06389171616502412},
{0.17299958103567173,0.8712638425518506,0.0665996014742255},
{0.16719470704907838,0.8497298208953984,0.06212571208924782},
{0.1681407027621748,0.8746992719682276,0.06570514829411969},
{0.16086933899105688,0.8537537324418683,0.061181364646622174},
{0.15513135008514403,0.8590752542111746,0.060921111414402526},
{0.16382259352619713,0.8806663952555934,0.06548051257568095},
{0.14999320770046434,0.8653351128127431,0.060916154209979284},
{0.1612291948531503,0.8880952865902707,0.06645114559476077},
{0.1422550487748328,0.879631628404288,0.0631270797757517},
{0.1375493729040359,0.8956495456248112,0.06651656830013637},
{0.15595673701462315,0.9176831791290588,0.07249743543676544},
{0.13395912999352141,0.9131806494955258,0.07005973016164124},
{0.1516898357003375,0.9354981325250478,0.07598854665182636},
{0.12959431149886586,0.9301045577894499,0.0733352029842916},
{0.1449306502902279,0.9513524743926153,0.07883647298598404},
{0.12425415064092844,0.9437679516250709,0.0757580366461461},
{0.1326677906342806,0.9689282054961504,0.08166084020612031},
{0.11684441890134709,0.9544431550273788,0.07729848792066535},
{0.11841831891271207,0.9825135109690942,0.08340453686199208},
{0.10548622426661744,0.965905599671129,0.07883647298598404},
{0.10263952484055447,0.9920733929482191,0.08434144849798286},
{0.09406230949424672,0.9739895359982921,0.07983287107505363},
{0.08302014903450913,0.9973949271105365,0.08393371843417206},
{0.07868507376639307,0.9791635685429959,0.07979197413856196},
{0.06294349590644287,0.9999814600554571,0.08288403039755274},
{0.06377133665211146,0.9810610128940543,0.07899882143084488},
{0.04627364433920938,0.9982946721063639,0.08124195643235724},
{0.05381727017026222,0.9795018729588594,0.07786857882234806},
{-0.06434018825268832,0.8487680488792251,0.07066573600937026},
{-0.05779915701623409,0.8463575586563845,0.06856388133392001},
{-0.055000753154264524,0.8681578441554196,0.0706105003590844},
{-0.05076611084776304,0.845916379855728,0.0668895855399735},
{-0.04999776894818425,0.8694110254336124,0.06968670052879306},
{-0.04422014719290768,0.8477134160311938,0.06603570707807184},
{-0.044775874594774064,0.8728400104842393,0.06962446282725937},
{-0.03771504329551081,0.851559004541549,0.06600348524932084},
{-0.03185313667202829,0.8567180911149168,0.06656860655356926},
{-0.040525765810472125,0.8786575625211451,0.07030511178059122},
{-0.026620819796318203,0.8629393702730613,0.06771248147422997},
{-0.037861293219007226,0.8860092949689745,0.07141433584233355},
{-0.018865261083161184,0.876965854546662,0.07081940934649045},
{-0.014230312126472671,0.8928003304175035,0.07466745167303512},
{-0.032678523601507414,0.9153483358457167,0.07802719697088041},
{-0.010690830989252031,0.9102336782169922,0.07871624838570962},
{-0.0284537337387971,0.9330454688855764,0.0821218478244698},
{-0.006364455614898696,0.9270361845745911,0.08260889315905232},
{-0.02172807142359957,0.9487114741640945,0.08592775391341702},
{-0.0010428842735484116,0.9405494370812434,0.08579017909766128},
{-0.00950483222400495,0.9659451209833931,0.09049333918721342},
{0.006368136339182986,0.9510177639499587,0.08838404870512832},
{0.004727289282082213,0.9791338748885007,0.09426205384997532},
{0.01770898075843137,0.9621628855455671,0.0915368307183037},
{0.02047384913247777,0.9883344586910299,0.0974606900040656},
{0.02909691861970043,0.9699629847404668,0.0941629097615107},
{0.040087016039983006,0.9943524552887887,0.10016980222136172},
{0.04446176133649604,0.9750256289017808,0.09639117314975335},
{0.06017488484305687,0.9963775476537453,0.10197546393252388},
{0.05938421073755141,0.9765560294443316,0.09773209694623752},
{0.07685711702833739,0.9942248072748908,0.10270293368163314},
{0.06935065783744776,0.9745657242614153,0.0979774785651875},
{-0.06037814261742041,0.8701880424409321,0.07242058637519429},
{0.13176681873035825,0.8237811980188705,0.13683078274734975},
{0.1375271026631645,0.8343177855924936,0.14585041619541983},
{0.12104438556290804,0.8437959728427238,0.13842824187273617},
{0.12437314833310813,0.8529854029353007,0.14507213510097244},
{0.1416725648620921,0.8457911980510304,0.15414753709880394},
{0.12634363709134272,0.8627498935269945,0.15100714809668664},
{0.14412389005636905,0.8579797863917065,0.16155855771153532},
{0.12691619420222597,0.872897315767372,0.15611554725482693},
{0.1448302916866796,0.8706441548199134,0.16793847980423457},
{0.1260808804708893,0.8832306207806094,0.16029820087993973},
{0.1423925740185443,0.8835588992505269,0.17306176296865558},
{0.12029458360787214,0.9035625327574389,0.16524301229211338},
{0.1354896668591942,0.9089447554949077,0.17934130167178436},
{0.1095002957623072,0.9218831457906198,0.16435691200146071},
{0.12301732813733211,0.9318942201233361,0.1787365227321501},
{0.09438700638396844,0.937325990119015,0.1598570096862721},
{0.10413040407084141,0.9512036467228191,0.17332822509941534},
{0.07621762526472947,0.9483298561745832,0.15070974061731485},
{0.08143013810876865,0.9649971547815385,0.1622240871913763},
{0.11642428343346714,0.835356344705183,0.13120559502808754},
{-0.06293234219649053,0.8537166649457938,0.05182711989998394},
{-0.05639131096003631,0.8513048486707698,0.04972402592342789},
{-0.05359399768303983,0.8731068444053309,0.051771301778178354},
{-0.04935826479156526,0.8508636822631244,0.048049730129481376},
{-0.04858992289198642,0.8743583154479978,0.050846832725289864},
{-0.04281104944259302,0.8526618462025963,0.047197090968685525},
{-0.04344962412338267,0.8777345558435615,0.0507158881704502},
{-0.036307209632324054,0.8565074347129517,0.047164881532945575},
{-0.030445315401852562,0.8616667195744963,0.04772875114307712},
{-0.03910428744211045,0.883553991618148,0.051260771687640774},
{-0.02519932903494549,0.867834671606058,0.04866814138127953},
{-0.0364541907434729,0.8909486410632715,0.05257216293877355},
{-0.01745621290489072,0.8819144706132304,0.05197956632900937},
{-0.012821214376158012,0.897748958877083,0.055827596262542994},
{-0.03127070233133168,0.9202967660171193,0.059187341560388296},
{-0.009281733238937372,0.9151809806243882,0.05987639297521749},
{-0.02704591246862146,0.9379927712929726,0.06328199241397768},
{-0.004955357864584037,0.9319834745889765,0.06377027704966601},
{-0.020318986066295938,0.9536600902306629,0.0670891378040307},
{0.00036493699662731844,0.9454980531478118,0.06695157538128602},
{-0.00809573447369029,0.9708937370499615,0.07165472307782711},
{0.007777234089497646,0.9559663800165275,0.069545432595742},
{0.006135160124302138,0.984081164902886,0.07542343774058902},
{0.019116851600651293,0.9671113157169694,0.07269697530781156},
{0.02188294688279243,0.9932011941335375,0.07859976647477472},
{0.03050600397700406,0.9748781272841672,0.0753143792432779},
{0.04150231029582674,0.9979737674780261,0.08098294250124338},
{0.045872085994905436,0.9796208086859836,0.07745960945743144},
{0.061590129526856406,1.0,0.08278860421240553},
{0.060794535395960886,0.9811018602585014,0.07878690094175173},
{0.0782711348040421,0.9978472596211452,0.08351607396151478},
{0.07076098249585715,0.9792653027707716,0.07907317949719335},
{-0.05897029656122258,0.8751366585075004,0.05358198265881902},
{0.17699040324261647,0.8674303620132991,0.07888025749405224},
{0.17944518608697874,0.8455557680199599,0.07720800654693032},
{0.18568754575693322,0.8477890629706921,0.08021950823404358},
{0.18211342615380535,0.8693132569693756,0.08143898052215857},
{0.1727108238780184,0.8453067180697369,0.07455466287939554},
{0.1722076676290604,0.8688198911991531,0.07726254818859692},
{0.16640279364246716,0.8472845310975069,0.07278865880361923},
{0.16714256965155702,0.8723944941297126,0.07646774721040911},
{0.16007742558444557,0.8513097686961598,0.07184431136099359},
{0.1543394366785328,0.8566314887536429,0.07158405812877393},
{0.16300340310224706,0.8783277721038786,0.07655366795607478},
{0.1491740668485585,0.8629964772680172,0.07198807028926732},
{0.1603952567460411,0.8858167819351982,0.07748896850062803},
{0.14143461904977692,0.8772929928595622,0.07420022276313447},
{0.13673023205213006,0.8933097823160792,0.07758972368053021},
{0.15511031914537846,0.9154498841783266,0.08397956018207588},
{0.13311147282317087,0.9109475404399594,0.08154185490695169},
{0.15089792229372628,0.933052855120167,0.08665025406509197},
{0.12880239809225463,0.9276607799389076,0.0839969103975572},
{0.14415240637481375,0.9488540557563178,0.08929368332378029},
{0.1234759067255142,0.9412706731457905,0.08621525937695339},
{0.13188949714682216,0.9664309270168697,0.09211806293692762},
{0.11606612541388865,0.9519447363910811,0.0877557230444837},
{0.11762640550610085,0.9800695596163967,0.09406748357636348},
{0.10469431086000612,0.9634603222662481,0.08949941970035546},
{0.10184638452584852,0.9896816285650871,0.09501802752451817},
{0.09326916917954077,0.9715591921717361,0.09049829639163666},
{0.08222573223966416,0.99543940910966,0.0947255524635475},
{0.07789193345168702,0.9768845062024262,0.09049829639163666},
{0.06214906671858678,0.9980257685524255,0.09367586442692817},
{0.06297942324550024,0.9788029443142168,0.08971010088834282},
{0.04547922754436431,0.9963389682103218,0.09203255116062686},
{0.05302535676365091,0.9771757171762688,0.08856250806436466},
{0.1590190624400856,0.8205119960598156,0.11575151023866267},
{0.15525989039583848,0.8096949670389589,0.10355024384767401},
{0.16152471859484122,0.8359289389950993,0.09995645653599688},
{0.15904459204286525,0.8299039527391033,0.12379551628419656},
{0.15971925517185606,0.842920059607161,0.10577478933259923},
{0.15255657810771747,0.8455175603668679,0.1329371713191445},
{0.15314596492761764,0.8557196357860116,0.11320928230827465},
{0.14572753329427346,0.8688868258518779,0.14233824925457123},
{0.14601160589374676,0.8789788513328258,0.12233180253414894},
{0.14164159472745794,0.8955366452940723,0.14907987376801154},
{0.1431807943078603,0.9045997534249339,0.12812098696874266},
{0.13755807279779864,0.9143296427297536,0.15115091941797143},
{0.1401320888015507,0.9190339305833121,0.1295486618426334},
{0.12543104054304785,0.9362483062704154,0.15408907926564297},
{0.12810778221546032,0.940980391647777,0.1324838225816289},
{0.10318290880340704,0.9592747314975145,0.15743665462662923},
{0.1020566195654377,0.9664229830967819,0.13612741740474846},
{0.06470715770312918,0.9726839694623566,0.1575450686873653},
{0.06471310634843702,0.9790822456044328,0.13617060704828587},
{0.04824413309744397,0.9682391169022878,0.15522451454577313},
{0.04988124985821626,0.9746277512817612,0.13398413289333105},
{0.15841303180633445,0.8258100702521998,0.08856620118165998},
{-0.06372425560310181,0.8512713875409129,0.06249006661435536},
{-0.05718322436664757,0.8488597571610551,0.0603869726377993},
{-0.05438182139600191,0.8706619387907819,0.062432972012410784},
{-0.05015017819817652,0.8484197185174159,0.05871267684385279},
{-0.049381836298597694,0.871914549990466,0.06150979183267234},
{-0.04360296284920429,0.8502167546928816,0.05786003768305694},
{-0.04415655865316869,0.8753460012502936,0.061446822943486246},
{-0.03709912303893532,0.8540623432032365,0.05782781585430592},
{-0.031237228808463788,0.8592216280647815,0.058391697857448535},
{-0.03990984555389664,0.881160901182833,0.06212942999256526},
{-0.026004911932753786,0.865442894829915,0.05953557277810925},
{-0.0372449639930668,0.8885105516048045,0.06323660920748299},
{-0.018248126311502032,0.8794691932083495,0.06264250065036973},
{-0.013613127782769326,0.8953038673673682,0.06649054297691441},
{-0.032062615737943,0.9178516745074046,0.0698502882747597},
{-0.010074923125687614,0.9127370168786798,0.0705393396895889},
{-0.027837825875232685,0.9355488075472642,0.0739449391283491},
{-0.005748498179290085,0.9295395108432679,0.07443322376403742},
{-0.021112126381001985,0.9512148004327714,0.07775208451840211},
{-0.00042697640998399535,0.9430540894021033,0.07761450970264637},
{-0.008888874788396249,0.968449785697264,0.08231766979219853},
{0.006984093774791686,0.9535212885068124,0.08020837931011342},
{0.005343246717690912,0.9816372135501886,0.08608514515385461},
{0.01832493819403998,0.9646662242072547,0.08335992202218298},
{0.021089794175075356,0.9908092438552397,0.08927634550131003},
{0.02971409057039275,0.9724466433005945,0.08598104386096675},
{0.04070794307302596,0.9960193896341669,0.09177353722951301},
{0.045078945680199475,0.9773430723975973,0.08816593171050613},
{0.060795762304055624,0.9980442961039574,0.09357919894067517},
{0.060001382688243815,0.9788437916786643,0.08949941970035546},
{0.07747675518823029,0.995892881777286,0.09430790799089021},
{0.0699678421811511,0.9769402871451986,0.08976710873920997},
{-0.05976220996783385,0.8726915669977856,0.06424492937319044},
{-0.037972086737866444,0.8123944003146186,0.08981427653929702},
{-0.04431164479354949,0.8266001494931744,0.1044798560001516},
{-0.043142897099695196,0.8404953793866589,0.0871452804987959},
{-0.0385255462187092,0.8285600050479212,0.07456705589045362},
{-0.041640244508903086,0.8405160013570592,0.11474307853585572},
{-0.03920817805381031,0.8521247950683943,0.09594470253337499},
{-0.03633816737394712,0.8539012216664708,0.12250074406089266},
{-0.03386700096896615,0.8636904858872695,0.10271282330445747},
{-0.032393496740182666,0.8714274179048064,0.1298820214470847},
{-0.029856634983582778,0.8790851214026489,0.1091795088675743},
{-0.02997899118175918,0.8868784044414666,0.13414073098106094},
{-0.028490937557993482,0.8914756786445386,0.11245993889464788},
{-0.022934878054413205,0.9246966071610251,0.11853556299382703},
{-0.024279780007447065,0.9165888390735973,0.1396464872527564},
{-0.012263268625312244,0.9380515761304434,0.14452942036071703},
{0.003240289064256519,0.9595753983387949,0.12727734513397498},
{0.009758789806607165,0.9603505316084335,0.15072779723442647},
{0.0332491226166435,0.975740061203257,0.13310569148351226},
{0.04853285307606404,0.9729101419141665,0.1563955673396842},
{0.0670134474889935,0.97562168316163,0.13545175044186197},
{0.06502176668184956,0.9680036868712176,0.15641672220956035},
{0.17550921534697697,0.8618892856600882,0.09862215060741773},
{0.17796423365854927,0.8400148775619147,0.0969500731624506},
{0.18420659332850384,0.8422468464604639,0.09996157484956388},
{0.18063370063347062,0.8637721806161645,0.10118104713767888},
{0.171229871449589,0.8397658276116916,0.09429672949491583},
{0.170726715200631,0.8632790007411082,0.09700460241110616},
{0.16492184121403777,0.8417436530324727,0.09253072541913954},
{0.16565735402732368,0.8668570117497085,0.09620995014905107},
{0.15859646076300507,0.8457677504741086,0.0915863779765139},
{0.15285848425010332,0.8510892722434146,0.09132612474429423},
{0.1615224506738176,0.8727868816458333,0.09629573457159507},
{0.14769306484808484,0.857455599202983,0.09173013690478762},
{0.1589156675488281,0.880271355635106,0.0972300064962305},
{0.1399536170493033,0.8717509746375106,0.09394230177166582},
{0.1352492796237006,0.8877688918580339,0.0973317902960505},
{0.1536293171449048,0.9099076676680983,0.10372162679759618},
{0.1316305203947415,0.9054066499819144,0.10128392152247198},
{0.14941696986529682,0.927511964662122,0.10639232068061227},
{0.12732144566382514,0.9221197035856965,0.1037389770130775},
{0.14267145394638425,0.9433131652982725,0.10903574993930058},
{0.12199495429708482,0.9357297826877453,0.10595732599247369},
{0.13040854471839278,0.9608889087948186,0.1118601295524479},
{0.11458516059244815,0.9464038583260469,0.10749777726699294},
{0.11614545307767138,0.9745273431061685,0.11380955019188378},
{0.10321330885953245,0.9579194318082033,0.10924148631587575},
{0.10036541970440802,0.984169105709354,0.1147675299466733},
{0.09178944365920604,0.9660245477912646,0.11024284160936856},
{0.08074109908695049,0.9907349229679244,0.1146869753747958},
{0.07641093145121335,0.9714192502908684,0.11026019182484988},
{0.06066438399382891,0.9933212824106903,0.11363728733817646},
{0.06149718194392081,0.9733499946626399,0.10947571422487345},
{0.043994532426595415,0.9916346803567633,0.11199397407187518},
{0.051543127855082506,0.9717526470743529,0.10833555720753016},
{-0.06520520803153124,0.8457304970828681,0.08223213322987566},
{-0.05866294988698223,0.8433188667030098,0.08012903925331959},
{-0.05586644215570452,0.865120478254228,0.08217620357097054},
{-0.05163115541262805,0.8428777002953644,0.07845474345937309},
{-0.05086278872702712,0.8663734736372554,0.08125184605518158},
{-0.045083915277633675,0.8446758642348363,0.07760210429857724},
{-0.04563739954449857,0.8698052966874145,0.08118885237997336},
{-0.03858007546736475,0.8485214527451916,0.07756988246982623},
{-0.03271695432879853,0.8536805393185595,0.07813376447296884},
{-0.04139082276834817,0.8756200107247877,0.0818715090010966},
{-0.02748586436118326,0.8599006907126977,0.07927763939362956},
{-0.03872632539086113,0.8829687192779192,0.08297850232084848},
{-0.01972907873993142,0.8739283027503046,0.08238456726589002},
{-0.015094080211198712,0.8897629769093229,0.0862326095924347},
{-0.03354231647225551,0.9123107840493593,0.08959235489028},
{-0.011554648646022354,0.9071948003684515,0.09028140630510921},
{-0.029318790696673185,0.9300079294822303,0.09368700574386939},
{-0.007228223699624736,0.923998632778234,0.09417529037955771},
{-0.02259185190133664,0.9456739223677372,0.0974941511339224},
{-0.0019079288384133814,0.937511885284886,0.09735657631816667},
{-0.01036987678886992,0.9629077550822018,0.10205973640771882},
{0.005504368254457034,0.947979071996584,0.09995044592563371},
{0.003862294289261526,0.9760963230921433,0.10582845107048072},
{0.0168439361935664,0.9591253337492097,0.10310198863770327},
{0.019610068654740704,0.9852969068946724,0.10902584792346517},
{0.028233138141963363,0.9669118130249564,0.10572434977759286},
{0.03922324795525697,0.9913149034924317,0.11173496014076131},
{0.04359799325177,0.9718765028268674,0.10792782714371935},
{0.059311067186286634,0.993339995857388,0.11354062185192346},
{0.05851915377967541,0.9733921556862595,0.1092637937357803},
{0.07599207246347242,0.9911872554785335,0.11426933090213852},
{0.0684868773597107,0.9715158909910994,0.10954015788237548},
{-0.06124318718228538,0.8671506889327517,0.08398698359569967},
{0.17459707734009125,0.8406158394541432,0.13813204890844807},
{0.18207375612540838,0.8384731250212344,0.13811593799407257},
{0.1777448773628213,0.8176045460935458,0.1325242114046672},
{0.16744012584706155,0.8206173242607983,0.13255767253452402},
{0.16813010673772014,0.8437292240851652,0.1384738109743967},
{0.1589744352072655,0.8245396874746582,0.13296168469501737},
{0.15215332192089864,0.829354421842766,0.1337164190684544},
{0.16234503678279763,0.8492324769686266,0.13948112730620846},
{0.14647396435030163,0.8349754826893462,0.13476108793559521},
{0.15592203658366052,0.8575013541998094,0.1411547043055136},
{0.13811205278510588,0.845238444971818,0.1368084753274452},
{0.1522760003373626,0.8649966225017135,0.14244109885334222},
{0.13138137130042982,0.8589674721940024,0.1394841264148845},
{0.14946650473049602,0.8763425728415178,0.1447846296374361},
{0.1277564279589527,0.8734462765852007,0.1425774219749811},
{0.1451650888804136,0.9015850791269897,0.15008834264985169},
{0.12336930204439264,0.8990673769654859,0.14794495899434582},
{0.13841565677000672,0.9208742803324256,0.1535712744776143},
{0.1189635990062565,0.9126776419627007,0.15015080342558443},
{0.1296934431943194,0.9368823575021689,0.15630021551260334},
{0.11182643915188653,0.9255886065249411,0.15220308605680236},
{0.11872612412836156,0.9514407869894151,0.15886674613767626},
{0.10588796850608713,0.934105207654164,0.15358014787353186},
{0.10168403608098765,0.9661323298084366,0.16151644625995998},
{0.09255658343671228,0.947520505801413,0.15606104279219346},
{0.08081540758125477,0.9717401673122176,0.16148422443120897},
{0.08300776841646211,0.9528830608303326,0.1567513335081285},
{0.06509491023311433,0.9656712974040651,0.1587565226973257},
{0.07498822617475694,0.9513176748175644,0.155767328430117},
{0.17501697734076116,0.8503217111035324,0.11092016923573682},
{0.18946548081992237,0.8548302885264616,0.11804566726670117},
{0.18579987600916367,0.8552073582809148,0.0933033924795776},
{0.17349200493705338,0.8541873391127683,0.08824196283334744},
{0.1644672903544495,0.8540717990706739,0.10803085024464516},
{0.16424608750007388,0.8597528049117417,0.08635306965991923},
{0.15284983392838478,0.8691695352201346,0.10820495965700011},
{0.15449398991943808,0.8736446515132074,0.0868441179370735},
{0.1454635001936811,0.9011630103493848,0.11474227299013694},
{0.14070374122262672,0.9306932258147089,0.09844468268906602},
{0.12984855412072238,0.9461640659550841,0.12258282297313032},
{0.12805024146511765,0.955684240726779,0.10228355418742772},
{0.09896980555012448,0.9741873408477901,0.12627615094962594},
{0.09790553093948985,0.9802541163370737,0.1054843715114642},
{0.05816568031827684,0.9857271178805427,0.12580899639779164},
{0.05963297564852028,0.9904726372818912,0.10483864606329403},
{0.19616089179512708,0.8575881548492602,0.09697361988346095},
{-0.06409976383816161,0.82098172835795,0.11533262646489961},
{-0.06859470894892697,0.8419730352741466,0.12029726669476618},
{-0.06113908588939754,0.8439075471212798,0.12137421935571327},
{-0.0538234666757912,0.8237068771315551,0.11682970220071559},
{-0.05470246577110761,0.8468408984806608,0.12263349799534681},
{-0.04539499224820256,0.8273938103143449,0.11843335783163103},
{-0.03861725450053899,0.832018869648209,0.12015474706759827},
{-0.04895536800206707,0.8521951501921713,0.12446445384207849},
{-0.032986713000499705,0.8374854392189389,0.12200539540890123},
{-0.042617718470086996,0.8602737823106015,0.12704030401146713},
{-0.02471971950699784,0.8475114595229911,0.12523340299919913},
{-0.03901133985917485,0.8677726445857125,0.12925493508754587},
{-0.018083274478407425,0.8611597338851213,0.12927104600192138},
{-0.03623406608105928,0.8789884930954289,0.13178931824193416},
{-0.014517792803986976,0.8754861290263272,0.13266922202705778},
{-0.03199051319960703,0.9041315330741486,0.1374560225482409},
{-0.010189855910240303,0.9010087049687008,0.13843731355683067},
{-0.0252885958935968,0.9231595763575576,0.14193423709407785},
{-0.005784437911358475,0.9144186989072168,0.14128360401352869},
{-0.01661347575993024,0.9389793169382513,0.1461057370092384},
{0.0013328559462853537,0.9271848139562109,0.14455535893286162},
{-0.006000386129045542,0.9528989486705087,0.15006120195563452},
{0.007201182149496036,0.9354674970017121,0.14669190164626342},
{0.01119274793710435,0.9673951528492327,0.155083234219711},
{0.02047880633690099,0.9485280452074238,0.15093777202078348},
{0.03200307971281999,0.9724205560123171,0.1580141813349468},
{0.02998054030814149,0.9536241628916057,0.15298136715124971},
{0.04777691658055437,0.9659129735127087,0.15752465739815266},
{0.03801119908076579,0.9518344881647082,0.15313875839168734},
{-0.07261648889749486,0.858489610080614,0.09941562553342231},
{-0.05744057763427963,0.8535689774330145,0.09439701374039781},
{-0.06548041962809799,0.8587167244012643,0.07544134564156794},
{-0.07618544061501158,0.8613915699429848,0.0776132580085295},
{-0.04569875734224715,0.8575928889794844,0.0930085627465059},
{-0.052613660936301515,0.8573432689507526,0.07216942961309125},
{-0.03402820925680964,0.8740977399974905,0.09571494850136926},
{-0.042547958210841036,0.8631385011747428,0.07162844989438398},
{-0.03265398543961238,0.8781840503546381,0.07425119521761635},
{-0.023836618325021226,0.916800263842248,0.08331764946146387},
{-0.01202802448940777,0.9476867208657241,0.11260875417143329},
{-0.009767303805203967,0.9545887729073113,0.09213842465409604},
{0.018141645560491013,0.9747300555880455,0.12037639607037201},
{0.022206020288065495,0.9807178008458118,0.09993738369197849},
{0.05985105546410924,0.9857031002251122,0.12592860134751316},
{0.06149662425842319,0.9904465499936139,0.10497102820741645},
{0.17177765493136718,0.8267431028757295,0.1018279623149106},
{0.1496065457554523,0.8285823124678258,0.1010620742315213},
{0.14865356038411914,0.8252423835946624,0.09665635880037413},
{0.17012320034812464,0.8197385606326919,0.095198940699944},
{0.17105514238668112,0.8349968606334213,0.10779519713937578},
{0.1484289494517025,0.8341782278949688,0.10630278117571765},
{0.15970171906120886,0.8597964902757214,0.12110930635133577},
{0.13874067587801592,0.8533840365289946,0.11721455476611319},
{0.16793334290115097,0.8433907337741355,0.11286269936102442},
{0.1568103924023258,0.8718568729170019,0.12549606047556408},
{0.13633860050968366,0.862411589111131,0.12078926923377192},
{0.13384883219510446,0.8785410682171991,0.12608853315521767},
{0.15529620191823865,0.8979806090397807,0.1317831217364051},
{0.1331535966677573,0.8933506296805263,0.12905913790583928},
{0.15188933839235047,0.9143604641482551,0.13440424357518885},
{0.13098360521750976,0.9070053236223845,0.1311622318823953},
{0.14472619039379173,0.9301641186005951,0.13660648164020958},
{0.12597187154562248,0.9205123424444746,0.133016226336684},
{0.1329813214210389,0.9464299456143241,0.13857574349034943},
{0.11671053720288663,0.934743237042467,0.1347252225615931},
{0.12035160385175038,0.9599048169657296,0.1403999947180987},
{0.10693989967770799,0.9457185496005573,0.13606244084777094},
{0.10488639013839528,0.9700968664389273,0.1414806652823632},
{0.0963636916477321,0.9532486050845017,0.13695225904174105},
{0.08547645621923157,0.9785737479677087,0.14191442066939597},
{0.07971743637355314,0.9602803747728337,0.1372744773292511},
{0.06666634403527881,0.9827166076343141,0.14142489673260183},
{0.06566004393037386,0.9632719732841875,0.13688285817981577},
{0.05042775685985541,0.9804500250558797,0.1396341066347094},
{0.058938062339460535,0.9621207121289362,0.1361058163864742},
{0.0370519800248704,0.9765772091002299,0.1375260554537301},
{0.04508887248205694,0.9558349521342562,0.13353426659192277},
{-0.019100740686275697,0.824724442483512,0.13054504753869192},
{-0.002801440149678831,0.8358582120809909,0.12716919132647111},
{-0.00816017813119224,0.8444355265713869,0.13368171863749181},
{-0.025784279156886792,0.8354344330678597,0.13867981999721518},
{-0.012138371859868921,0.8537278186557461,0.13980634470239459},
{-0.030741495973129602,0.8470343533832771,0.1463300257233675},
{-0.014656594527837406,0.8635541503726196,0.1454228573139161},
{-0.03387692777082366,0.8593008565844759,0.15334446998224038},
{-0.015665410413987228,0.8737238800329017,0.15041973176554474},
{-0.03512614328547805,0.8719937785101604,0.1595843510499833},
{-0.015142400561314126,0.8840373314424242,0.1546977991827937},
{-0.03308008194581127,0.8848453681564218,0.16502613459859697},
{-0.009573006177835474,0.9042949225319383,0.16078028901009903},
{-0.026453501754023098,0.91012589619982,0.17259702505397762},
{0.0018298156897143636,0.9228572116737627,0.16034901222527784},
{-0.013302050812200397,0.9332686174426883,0.17269245123912483},
{0.01778708151411936,0.9372306878639785,0.15885069718835607},
{0.006624646882063149,0.9514006955986424,0.1708359905756356},
{0.037365560383672995,0.9477077146264564,0.1523877419215677},
{0.03104263374882995,0.9645361223771671,0.1630804442554896},
{-0.030027633750162083,0.8277383484147703,0.08395476176694867},
{-0.03150117515797878,0.8311117508108019,0.08818697504328274},
{-0.05360040486975684,0.8298910887936252,0.0858062776190257},
{-0.05350000908717534,0.8381323667891817,0.09183175959546386},
{-0.030922000179190497,0.8366821366351652,0.09355446249060323},
{-0.05089501055577814,0.8464468131220249,0.0973069918809233},
{-0.04344976044650432,0.8626536370101063,0.10667458390047109},
{-0.022335143070279607,0.8556549566612993,0.10576796078350623},
{-0.04090293470901371,0.8748363758495633,0.11192297451152343},
{-0.020249585204370767,0.8647029453186702,0.11006931466853334},
{-0.018073347676549868,0.8807148023567862,0.11549498730277151},
{-0.03954796963100073,0.9007010360761726,0.11793269257789571},
{-0.01738061553743648,0.8954524967489876,0.11835777285718782},
{-0.0360927857549972,0.9169853906414336,0.12104085975126198},
{-0.015151100455076947,0.9090465021156944,0.12077317071240748},
{-0.02887633541587763,0.9325882287425886,0.1242655212285742},
{-0.010078616242982933,0.9224122530047336,0.12334472050695892},
{-0.01709553910406745,0.9485789061248063,0.12811355116210785},
{-0.0007739807196101991,0.9364362710691332,0.1265792963931176},
{-0.004480717934070632,0.9616993993250057,0.13173108348297224},
{0.00901031390375447,0.9471388878119017,0.12930701052001192},
{0.010967195135847303,0.9714080965809161,0.1348033109242701},
{0.01957286483554432,0.9543206253270475,0.13149313767065712},
{0.030348625129577454,0.979344531290466,0.1379957505728313},
{0.036194396052662406,0.9608889087948186,0.1341811817691545},
{0.04914634430247215,0.9829620636113303,0.14017939912126487},
{0.05024560438332373,0.9634877356067089,0.13578731600228158},
{0.06540597481067215,0.9802404964179208,0.1406986662845984},
{0.05697377008675501,0.9621479519672418,0.13596701466262373},
{0.07883252581196204,0.9759934487073503,0.1404954209032459},
{0.07086753760493451,0.9554756539576605,0.13536595362630688},
{-0.05121969505248874,0.8228294395556321,0.07946353455950074},
{0.17478116312634803,0.8603499993286086,0.10856957443533988},
{0.17723552460833422,0.8384706712050451,0.10689546453655924},
{0.1834778842782888,0.8407039661557774,0.1099069662236725},
{0.17990376467516084,0.8622330801798506,0.1111276778128933},
{0.17050116239937396,0.8382227490188282,0.10424336017013026},
{0.16999677924232115,0.8617399003047944,0.1069512330863206},
{0.16419313216382264,0.8402007603347751,0.10247611679324815},
{0.16493101204222066,0.8653196091559094,0.10615643210813279},
{0.15786776410580114,0.8442259979334279,0.10153176935062251},
{0.1521297751998883,0.8495488457549173,0.10127275541950867},
{0.16079251471550782,0.8712540148940817,0.10624360454791532},
{0.14696312888977506,0.855916300478492,0.10167676758000203},
{0.1581848392937221,0.878743978987253,0.10717994610539744},
{0.1392249203920993,0.8702154681744037,0.10389015935497502},
{0.13452052100144135,0.8862271393173535,0.10727842097126494},
{0.15290060809468975,0.9083636472063942,0.11366701817170481},
{0.1309030382526212,0.9038599898088552,0.11122931289658061},
{0.14868826081508177,0.9259666181482348,0.1163377120547209},
{0.12659273661361012,0.920568123387247,0.11368312908608032},
{0.14194274489616923,0.9417689589414029,0.11898114131340921},
{0.1212661956748255,0.9341744102279124,0.11590023876437071},
{0.12967860876008291,0.959357169807073,0.12180923882987396},
{0.11385646393524414,0.9448424380768174,0.1174394631307952},
{0.11541546754731732,0.9729942904592508,0.12375742016820403},
{0.10248337290122268,0.9563394840074418,0.11917820258224372},
{0.099636723047204,0.9826286792208572,0.12471416062188774},
{0.09105950770089626,0.9644209541254042,0.12017212206910168},
{0.08001239003673545,0.9891907166110547,0.12463236674890443},
{0.07568099549290358,0.9702443680565405,0.12030224868521151},
{0.06008685728551132,0.9912642284702149,0.1234587486017043},
{0.06076725837862197,0.9721045590163583,0.11950042086975378},
{0.04396357468497229,0.9878214252122587,0.12139531226053411},
{0.050811964988678,0.9708033548203152,0.11843710052097059},
{-0.06593269017365154,0.8441862783329871,0.09217752460398428},
{-0.059391658937197264,0.8417759863983232,0.09007443062742822},
{-0.05659268499671902,0.8635811919227484,0.092122623564997},
{-0.05235986446284309,0.8413348075976668,0.08840013483348172},
{-0.05159027086914742,0.8648343732009411,0.09119971603150182},
{-0.045812649113870854,0.8431329839301498,0.08754749567268585},
{-0.046362700516672656,0.8682713021716563,0.09113672235629361},
{-0.03930878451757979,0.8469797002045113,0.08751527384393484},
{-0.033445663379013564,0.8521401128300622,0.08808039514818326},
{-0.0421182677314353,0.8740869580778701,0.09181937897741684},
{-0.028213346503303562,0.858361391988207,0.08922427006884398},
{-0.03945269216198624,0.8814420986037406,0.09292881372034716},
{-0.020456548489040695,0.87239165613018,0.09233243724221027},
{-0.01582278926141375,0.8882212243686426,0.09617924026764914},
{-0.03427102552247059,0.9107665652994783,0.09953774626438862},
{-0.012283357696237392,0.905648326090558,0.10022679767921783},
{-0.030047487353877196,0.928462582968343,0.10363239711797802},
{-0.007956932749839773,0.9224470401867735,0.10411820315145472},
{-0.023320548558540648,0.9441285758538499,0.10743953011501997},
{-0.002636637888628418,0.9359578388772362,0.10729824978895787},
{-0.011096082450851292,0.9613747024352842,0.11200760638403906},
{0.00477565920424191,0.9464187919043718,0.10989088009531911},
{0.0031348121471411355,0.9745621426812194,0.11577632104680097},
{0.01611650362349029,0.9575465137124546,0.11303870490407125},
{0.018881371997536693,0.9837564804061751,0.1189737178997854},
{0.027505668392854087,0.9653082193590964,0.11565486953843178},
{0.03849453890504193,0.9897706971355618,0.12168035151486993},
{0.04286805729346023,0.9707029342517115,0.117969884004081},
{0.058434906090502545,0.9912863499949538,0.12334225429775837},
{0.05778921782136555,0.9721467324329889,0.11928850038066063},
{0.07458670500948625,0.9873938663307548,0.12357276430343864},
{0.06775567731427293,0.9705665987370617,0.1196417011958159},
{-0.06196940523727778,0.8656100641560773,0.09393361427091411},
{-0.07399599213740284,0.8671627845115442,0.07643690100588556},
{-0.058560063109178044,0.8619010094485491,0.07272897406236353},
{-0.06489380884267487,0.8672240555582152,0.05318447682913113},
{-0.07564136264353978,0.8701298076819702,0.05442469501775736},
{-0.04667558686685599,0.8656514815990335,0.0723752031686996},
{-0.051810222029406224,0.8655497473712578,0.05102656856466519},
{-0.034916614647519106,0.881200236599931,0.07602744831353768},
{-0.0416079607150968,0.8711033034866045,0.05138278088150757},
{-0.031625365521791814,0.8859277861352456,0.05493770371050655},
{-0.02239782692021135,0.9365934144493498,0.08991053305618511},
{-0.017787416125417874,0.9436788830545966,0.06999982234618649},
{0.007275255176590194,0.9762504425776617,0.10276167655404843},
{0.006091474760322455,0.9763572827259934,0.08049939199577924},
{0.03567483145706347,0.9932025201857209,0.08905074312800876},
{0.05821805318300832,0.9918568746520233,0.11451094504572683},
{0.06170790031094127,0.9940239785306945,0.09335364613941811},
{0.14895342167968048,0.8262847225757242,0.10980782213520786},
{0.14800044870135837,0.8229447937025608,0.10540334600516649},
{0.16946886175726913,0.8174409707405904,0.10394468860363054},
{0.17112454324860638,0.8244455129836279,0.11057494951970297},
{0.1704008037958256,0.8327005844004917,0.11654094504306234},
{0.14777333438070805,0.8318840460809079,0.11505295338435192},
{0.16727900431029544,0.841093131489023,0.12160844726471094},
{0.15903135630705525,0.8575049481730164,0.1298582268658532},
{0.13807597672991576,0.8510936221902959,0.1259635248526748},
{0.15613524594590372,0.8694526287717347,0.13421047884729578},
{0.13566316901400727,0.860116267140053,0.12953501713745846},
{0.13312882303865214,0.8762557721920672,0.13483304175779842},
{0.15448198109172284,0.8957127004091634,0.1405251517367742},
{0.132361683261146,0.8910840471020923,0.13780364650842},
{0.15091404560111282,0.9121360549864516,0.143146273575558},
{0.13008759051801055,0.9047684346984454,0.13990674048497606},
{0.14355010603739107,0.9280497717699985,0.14536214395274258},
{0.1249766631856145,0.9183225345695452,0.14176569214368798},
{0.13185479671585953,0.9443318584142355,0.14734006851761203},
{0.11574389473336752,0.9325436015097684,0.1434734490674913},
{0.11948041235340053,0.9576480620450646,0.149140785417362},
{0.10609966592098127,0.9434234135246454,0.14479454404628253},
{0.10418245471728531,0.9676120553287714,0.1501731232385},
{0.09562260197946995,0.9508307410200815,0.1456608155192423},
{0.08484565195637535,0.9758323395635953,0.15054491357024238},
{0.07905189450070113,0.9576717079101632,0.14593843135995432},
{0.0660342756852946,0.979803109878648,0.15001201409474496},
{0.0650118398799921,0.9605852056658293,0.1455269833928261},
{0.04978830227528066,0.9774745002798682,0.1482038737813712},
{0.05829237407032354,0.9594127648546796,0.1447462236961671},
{0.0364075558428614,0.9737813334125164,0.14614167674130682},
{0.04444195730482521,0.9531990578262916,0.14219201172408588},
{-0.051872806735249535,0.8205318496635305,0.0882105217642931},
{-0.030682021913061897,0.8254407585226687,0.09270174897174102},
{-0.0321555633208786,0.8288141485256892,0.09693396224807511},
{-0.05425351655251764,0.8275933130063579,0.09455326482381807},
{-0.05415312076993609,0.8358359046610863,0.10057874680025622},
{-0.031573599914602235,0.8343909663227917,0.10230547742398946},
{-0.05154689533044416,0.8441492232299233,0.10605397908571565},
{-0.04408663728477899,0.8603624790907439,0.11542740821347179},
{-0.022979368964111742,0.853360390663896,0.1145163607915592},
{-0.041532462491730954,0.8724470652826211,0.12064396117911594},
{-0.020881603982310693,0.8624078092427583,0.1188187804755373},
{-0.018660788793713894,0.8784281802794712,0.12424941031419873},
{-0.04004122386412336,0.8984293475771825,0.12669702999816937},
{-0.017896152404441493,0.893182134302181,0.1271221102774615},
{-0.0364249184513537,0.9147509555336841,0.129828743892546},
{-0.015563762937288807,0.9068020410619989,0.12955237974595082},
{-0.029010167542293814,0.9304591218358218,0.1330955416074557},
{-0.010390920121646595,0.920212605079024,0.1321425190570894},
{-0.017277741152643328,0.9464671990055648,0.13694481084209514},
{-0.0011160154318021558,0.9342277373544952,0.13537337703993066},
{-0.004916927137292922,0.9594377367719616,0.14050409601098657},
{0.008543097386864868,0.9448386582084447,0.13806639073586235},
{0.010364857619391477,0.9689219718115881,0.14350444398814757},
{0.01900778071032916,0.951901435210444,0.14021408715921646},
{0.029675659843101634,0.9766019827293352,0.1466237648714661},
{0.03555618076919341,0.958278915879965,0.14284637510096354},
{0.048477109312324816,0.9800483799604984,0.14876403788119638},
{0.04958875001122342,0.9608007820931844,0.1444314412152919},
{0.06474293632605388,0.9772662976940922,0.14926719413015443},
{0.0563169157146547,0.959440190588151,0.144604943370105},
{0.0781745064968223,0.9731975730196364,0.1491110421908226},
{0.0702107451978895,0.9528395737545298,0.14402371115148108},
{0.18249247879002775,0.8593623135263126,0.086712355443504},
{0.19771455401943433,0.8645371020446913,0.0913010041108795},
{0.18993862119609775,0.8646378944036265,0.06755713508061693},
{0.17702184431167087,0.8630454544477187,0.06465697220484946},
{0.17145073969266614,0.8626230014867706,0.08567616339592694},
{0.1673294438653018,0.8681850716007142,0.0644005608060578},
{0.15949635447496543,0.8771615773703023,0.08790892544718369},
{0.15743263309454092,0.88160302185233,0.06659294642728732},
{0.1520932777823223,0.9097454183673259,0.09601825505400469},
{0.1494121365909842,0.9152329816987881,0.07527470921488101},
{0.1420454705648296,0.9423232115749534,0.10370542913214328},
{0.1386820073636669,0.9486693007474639,0.08340716418033638},
{0.12408774968145161,0.966662007101059,0.11041712452387833},
{0.12383651856128225,0.9690471536162857,0.08900989576356132},
{0.09921242352760858,0.9871187166992434,0.09563687253170336},
{0.09113108973276769,0.9868180498579634,0.118445936737855},
{0.062340018232969675,0.9930922719593482,0.10063595293930032},
{0.06452977653585489,0.9884049997099725,0.12142877339039092},
{0.20063849908342224,0.8674901211126215,0.0694202383980333},
{-0.07286484483909875,0.860100007509545,0.10315517944116455},
{-0.057687310091434955,0.8551769086527452,0.09814803118336878},
{-0.06576972207823781,0.8603310875937338,0.07920790392040573},
{-0.07642957053984467,0.8629976174250346,0.08135718664917525},
{-0.04596336052134819,0.859190794253269,0.0967818628233593},
{-0.05286370232740931,0.858944966485921,0.07593985451137918},
{-0.0342398942786927,0.8750555338571144,0.09941941779480609},
{-0.04279814831808155,0.8647326265801545,0.0754235616706996},
{-0.03291035965937089,0.8797734540228365,0.07809834524736485},
{-0.02131918880976039,0.931510532500978,0.11234950477310934},
{-0.024222474724314512,0.9181538532960337,0.08723177132297022},
{-0.010012809354264513,0.9561029138193541,0.09618998500823649},
{-0.001992176527586247,0.9610437718610003,0.11969499114336564},
{0.019679804127964565,0.9776908326808978,0.1247992262497904},
{0.0230213440925655,0.9832116836400621,0.10428943738524421},
{0.059609713966764254,0.9873131134707003,0.12987866294108794},
{0.061237833401508374,0.9919219255670675,0.10897224815063898},
{0.14234482374693752,0.8400005016690874,0.12961284524690322},
{0.13443467461384198,0.8517721271527146,0.13857761483501918},
{0.12859055196122782,0.8311346283092151,0.12211459022933396},
{0.13753580255692732,0.8274690730705004,0.1210863544948562},
{0.1465467237182236,0.8651838313267569,0.14722727972397245},
{0.1359742459845761,0.8654775085098002,0.14633746153000235},
{0.14533098172643702,0.8526087173641903,0.1402512537993796},
{0.14554783463393134,0.8831474141043657,0.1539641329281554},
{0.13495924598590842,0.8820135651296507,0.15270376370354874},
{0.1414606195869768,0.903888357411167,0.1588110395529702},
{0.1295893419014316,0.9005696081939017,0.15700413854070225},
{0.13417479317195408,0.9234023926232188,0.16222159619615364},
{0.1213901505714284,0.9177648738579538,0.1597962839320875},
{0.1245850812152123,0.9406411453630734,0.16476837236159997},
{0.11279932769897891,0.9333603257245179,0.16199356479268498},
{0.11028975535272896,0.9537567185378829,0.16624933718304047},
{0.10160843871353333,0.9454980531478118,0.1634509828931151},
{0.09389255002877318,0.9623797880251054,0.16692475628570577},
{0.0895227743296944,0.9542115048646812,0.16446722219288865},
{0.07486057816085871,0.9696766813990031,0.1671664200013383},
{0.07240678675738114,0.9606148993203245,0.1646122204222682},
{0.055520045103620165,0.970743781616159,0.1658837433568271},
{0.054450528249307906,0.9618245811297036,0.16346462759829003},
{-0.013611615835420183,0.833119071597901,0.11200781706522704},
{-0.021074439234374416,0.8536154884035153,0.12755374645960332},
{-0.028133870123388076,0.8426399899502593,0.11763645004156338},
{-0.032172913536359864,0.8551926105977555,0.12804537720827733},
{-0.03399837927919282,0.8677578969025532,0.13459880145578967},
{-0.02340356933961878,0.8677554306933526,0.13521350719728145},
{-0.033450620583436785,0.8856458327406632,0.1412389891737196},
{-0.022826104596356506,0.884216980530722,0.14148684939488118},
{-0.029515827179485556,0.9062753876640748,0.14665597430720606},
{-0.017604891858554506,0.9026255219773598,0.14654071930436594},
{-0.02224607449980517,0.9255872804727581,0.15110258667484489},
{-0.009408154344740864,0.9195916036879145,0.15049780773521063},
{-0.012651405338640183,0.9426104567852572,0.15521830564723302},
{-0.0007987543487152731,0.9349998467294355,0.15412400277080462},
{0.0016501294223832633,0.955326838680875,0.15873173667520957},
{0.010405804127927371,0.9468240433659711,0.15717392279219794},
{0.018033665255141967,0.963439328505516,0.16153255717433548},
{0.022477811413580257,0.9551483173565836,0.15970210944105717},
{0.03703462980938913,0.9702046484560992,0.16447713660173513},
{0.039572706081072724,0.9610734655154956,0.16227737713892604},
{0.056385089668485135,0.9707326279062067,0.1659444691110117},
{0.05753638800276968,0.9617824077130728,0.16368398389401806},
{-0.022419576654618315,0.8297023680212327,0.10971461429904006},
{0.17284547394316446,0.8501012146507869,0.12161455701916259},
{0.18673631671073423,0.8542930514970938,0.12992549612987642},
{0.18521063790539627,0.8547408481656554,0.10499705353063843},
{0.1733213903538168,0.8539761126322944,0.09891347311835999},
{0.16266358673903455,0.8540770908863957,0.1178709629898154},
{0.16439401048006308,0.8597325795176949,0.09628101167445807},
{0.15138362918311454,0.8694134792498021,0.11712663874566716},
{0.15489044234318605,0.8738486900472674,0.09600886115162266},
{0.14420123483838257,0.9017148091667457,0.12318357418417071},
{0.14134664106427564,0.9310727617783624,0.10663192715640918},
{0.13348499817646142,0.9371323493212326,0.12863369822922646},
{0.12821702660793727,0.956975431369887,0.10947542918561912},
{0.11675662681101166,0.9610902952245122,0.13065515944194298},
{0.0979216046748322,0.9826492887982464,0.11018806450049186},
{0.0857898382898572,0.9824923313131959,0.13037418509523419},
{0.061132121017182954,0.9926429633434375,0.10622096251671222},
{0.05774336368045063,0.986357773427266,0.12648512190208727},
{0.19523887655842814,0.8568879125454456,0.1094992361598617},
{0.17409647405141118,0.8494707449992293,0.1238922313424938},
{0.188532497768437,0.8539738447112709,0.13101311917334452},
{0.1848718997341458,0.8543552644126055,0.1062721952244263},
{0.17255359374672455,0.8533354311396251,0.10120749382327682},
{0.1635369098352863,0.8532176231765071,0.12099806668407843},
{0.16331286898137837,0.8588999550697579,0.0993198399509544},
{0.1519166154096893,0.8683161152996423,0.12117184148513482},
{0.15356080857977575,0.8727912315927145,0.09981099976520821},
{0.14453259916805342,0.9002972965619225,0.12770666382304896},
{0.1397695808350908,0.9298400041823932,0.11141158930322285},
{0.1328783107131242,0.9368231684813556,0.1342288328966728},
{0.12711811353139532,0.954828552885263,0.11524990311608693},
{0.11624141216229414,0.9599084109389365,0.13758733889341232},
{0.09649085633419906,0.9797040153622277,0.11848394610277012},
{0.08481530147229403,0.9792876101906762,0.13957326934342526},
{0.05870343785410898,0.9895624945497858,0.11776534974957846},
{0.057177003075096454,0.98190744315631,0.1379969898739371},
{0.19522648354737002,0.8567343631384359,0.10994042735352931},
{0.19890674929021046,0.8591709406495537,0.04439365554422635},
{0.21987299753804787,0.8648689744878153,0.040505794473152064},
{0.21375979782934057,0.874660692524804,0.021801890393967075},
{0.19327949193810157,0.8696958168277273,0.02600291046146796},
{0.1802620094458167,0.8639930488592416,0.052997367148176246},
{0.17540256109381114,0.8755228123390592,0.035114760304821226},
{0.16373333906055684,0.8814050311076658,0.06487573363604668},
{0.161906609230596,0.8898930787394108,0.04459828894281735},
{0.15578914632608476,0.9004767597550548,0.07168626329096991},
{0.1568217815794882,0.9020865871054771,0.04933241916700364},
{0.1524675591092873,0.9228173061781557,0.05502473982716744},
{0.14663483802684651,0.9349567314439644,0.07970227352452358},
{0.1372347515323044,0.9549117595615069,0.062119069435320695},
{0.12630918452060125,0.962816232695538,0.0850833189259416},
{0.1094252684733616,0.9826056034342667,0.06748536715357961},
{0.09839819030808165,0.985060150811419,0.08920539551300254},
{0.07897492150901939,0.9936480489332586,0.06868698111275992},
{0.07333995570403236,0.9890817944368653,0.08902972458125426},
{0.0603769033163146,0.9831218590959133,0.08733931787293224},
{0.060918440720519516,0.9868163520154482,0.0666206819860353},
{-0.08249431357531484,0.8787969343235043,0.000741851838442167},
{-0.09146112801025538,0.8692164427669897,0.018373537386904244},
{-0.07143099824570111,0.862948640245333,0.02517358255447235},
{-0.06295562866426865,0.8732726876793099,0.007789583725017037},
{-0.05706549076159579,0.8658598700799752,0.03409679837651059},
{-0.04563567691596149,0.8791611401324789,0.02003535341871527},
{-0.04884643343486658,0.8719962447193611,0.040986953127482},
{-0.03888121324306501,0.8841810531916647,0.05026685220078282},
{-0.03399837927919282,0.892681394690379,0.03087798640041778},
{-0.03164990368368685,0.9024470130460791,0.058177881237663494},
{-0.029282850964604708,0.9046852280222016,0.03610287986250401},
{-0.02521029684973185,0.9252758317118573,0.04238814413674161},
{-0.022580784942461803,0.9373284563282157,0.0676754263711663},
{-0.010249701760639779,0.9569597294248766,0.05163093853493454},
{-0.002472356134042539,0.9645983352926787,0.07592499529112054},
{0.01729148500190682,0.9838935842875108,0.06093649114112559},
{0.025188968477700944,0.9860786580322163,0.0839995129298794},
{0.04755793207515808,0.9940867615247148,0.0664527938652315},
{0.050130336987472525,0.9894051528813927,0.08738021480942391},
{0.06303147389194413,0.9830847915998385,0.08752769164101505},
{0.06552866562014714,0.986751858785902,0.0669478574779686},
{-0.07476232636919021,0.8530589678489413,0.128585799241487},
{-0.059585721097355764,0.8481430569385554,0.12355470768632701},
{-0.06759151948979754,0.8532883500906155,0.10458506027102364},
{-0.07833314943137673,0.8559671737888855,0.10677649163040166},
{-0.04783573381103598,0.852172074405581,0.12213997111598092},
{-0.05475777577945978,0.8519300265066055,0.1013040229864082},
{-0.03569697776782426,0.8688257530933836,0.12481218933935716},
{-0.04468401759681159,0.857744926439145,0.10073491113259908},
{-0.03484903555821941,0.8727369502042802,0.10327680445168855},
{-0.025907998586279665,0.9115906757488185,0.11221443334558734},
{-0.023945255459956363,0.9172164707256227,0.1357406067436037},
{-0.011524818668405495,0.9495370841677727,0.12093468882552744},
{-0.008982342877796293,0.9480356213060424,0.14297192869599293},
{0.01654226551839058,0.9691398161599671,0.1491644932475161},
{0.021156319858435177,0.9760853552773571,0.12886658769302992},
{0.05773457703561045,0.9774586124396917,0.15403365772019123},
{0.059397867835737445,0.9836312986014776,0.13327666546406952},
{-0.07453122149897916,0.8569471015662589,0.12053362620166586},
{-0.05972743517880488,0.8523604233876416,0.11424994823284368},
{-0.06944258919347651,0.8573016656126308,0.09604193809813667},
{-0.07998637710652448,0.8597433614373153,0.09911141429097964},
{-0.04823436740473016,0.8566396185688969,0.1118798220470192},
{-0.0568733619111624,0.8562113037137187,0.09169676252600821},
{-0.03672463103078231,0.8734196192184148,0.11360437150080621},
{-0.04701448614725024,0.8622302421803181,0.09031251276286499},
{-0.03726507785001409,0.8774756658425581,0.0920980234380467},
{-0.028425564424662056,0.9163362075431783,0.10042213631951527},
{-0.014746319927897936,0.9474855203311959,0.1286280222301619},
{-0.014359943022140205,0.9544176378176101,0.1080457962159812},
{0.016190304004341155,0.9756791619469174,0.13393263993238472},
{0.018173507991921377,0.9815844565021143,0.11319864910478683},
{0.05719453918574365,0.9856985643830648,0.13554357026079128},
{0.056942936275242516,0.9917874737900982,0.1148023295217244},
{0.13692400917303418,0.8361341176861771,0.13603251172606567},
{0.1358837646108411,0.8323038469374893,0.13383539197461197},
{0.13679215992838722,0.8423918942618878,0.11436101439794619},
{0.1378963772136621,0.8462257465907707,0.11657689716814182},
{0.14040472265181733,0.8483801972051515,0.14720992950849116},
{0.1422945205150528,0.8593505897378517,0.12865584453998727},
{0.14195016830979304,0.8565286143688495,0.15232328587105465},
{0.1434088009253068,0.8684431932350318,0.15815295827277515},
{0.1449864436260114,0.8751576522682329,0.13690266221148661},
{0.14197989914332132,0.8856112314537891,0.16392935311995696},
{0.14381282547881125,0.8913219309493521,0.14246961517178686},
{0.13633164803048012,0.9058971901456153,0.16797248622657793},
{0.13743232091459234,0.9131602258133023,0.14706450991673564},
{0.11475431280037988,0.9442514897375239,0.17333224043499815},
{0.11548260048821896,0.9503931561926315,0.15232331065707677},
{0.09137616152644125,0.9604679553882086,0.17501998264594268},
{0.09269273305619627,0.9673993169009483,0.15435783410344847},
{0.06151207834321261,0.965779091814248,0.17395407215784833},
{0.06297568055616072,0.9712208877558727,0.1528921498646426},
{0.17310406651190233,0.8429764106284418,0.1473995549706908},
{0.1869962849036996,0.8471640834230332,0.15573731255733433},
{0.18540943419577893,0.8476109258297433,0.13073892380368451},
{0.17358102393548364,0.8468756980557117,0.12465407930427819},
{0.16291395034842984,0.8469708144155825,0.14361107345529125},
{0.16468395736677788,0.8526421784940472,0.12198044827764132},
{0.15161589899636502,0.8623257427235318,0.14276327996181912},
{0.15526013825605964,0.8667202920517157,0.12160522508183585},
{0.1441237041612032,0.8944406073960954,0.14852862024313712},
{0.14151026598927544,0.9239804770170337,0.131739994057923},
{0.12747489592674632,0.9413370501130177,0.15506431009182534},
{0.12877970648900725,0.9497781901979075,0.13451274438700236},
{0.09817973870216092,0.9682597388726885,0.15594276389465517},
{0.09850877314575293,0.9753346238464916,0.13516928893382624},
{0.05818462923218462,0.9781293593771881,0.1514807594072822},
{0.0615270243145486,0.9842604422008522,0.1309148921676982},
{0.19550778011236636,0.8497668883914732,0.13530272448388855},
{0.13401368402819908,0.837730895195955,0.1359657505754958},
{0.14035717066838752,0.8542915395497447,0.14819470295318823},
{0.12318676538451816,0.8289654424046862,0.15334936522160833},
{0.13007600305267128,0.8779319765097167,0.18105882428830142},
{0.1417810161018613,0.8879986458900396,0.16488040518156502},
{0.11458960968341804,0.9169273417776376,0.18667843515258747},
{0.12450670781328102,0.9279506772535778,0.16949180741724315},
{0.0868954311993595,0.9480522527268822,0.1785791438847235},
{0.09906416593632075,0.9559563540705814,0.16172712744794732},
{0.06839019948044661,0.9606037332173611,0.1679893159355948},
{0.08060848147561801,0.9685142665337996,0.1511707606286754},
{-0.028030103441798793,0.856641130516246,0.1362241324630457},
{-0.02048506480748528,0.8398872295480169,0.12498306417582596},
{-0.012472797263271143,0.8308598628610463,0.1437065739985048},
{-0.02201872471194475,0.8775263532577855,0.16920270325528025},
{-0.03106557321229839,0.8887119380344985,0.15194101105195712},
{-0.008632079206261856,0.9152742008535674,0.1784870390265399},
{-0.020514795641013665,0.9185989978602286,0.15936500714726634},
{0.0063146604964673956,0.9514109074397542,0.15746839312794897},
{0.023206520463795295,0.9488366559687921,0.17363928967697315},
{0.04333896692764515,0.9609533896313537,0.1662084402465488},
{0.033845932850167466,0.9691674277886042,0.14784695506289852},
{-0.022823588815111727,0.8446214093442472,0.1030139734731688},
{-0.024958941799451954,0.8345496340433682,0.12240159997242803},
{-0.0261930130545933,0.8384122381579062,0.12443598709567809},
{-0.024123764391236927,0.8484898753530157,0.1050604437822005},
{-0.03087784388079056,0.8507719615882834,0.13503379614392824},
{-0.02895069348222611,0.8593776312879805,0.1147055401053608},
{-0.03293135342010329,0.8590765802633576,0.14030454374692936},
{-0.0311219738056237,0.8667787250988543,0.11947561006161551},
{-0.03485473634330613,0.8709849254449775,0.14568684084246425},
{-0.03322256439394599,0.8776995703733445,0.12444026268449314},
{-0.033579235252197526,0.8911901312767493,0.15236058883433945},
{-0.032354347218250146,0.8975307303453612,0.13105381782165926},
{-0.014274753464126926,0.9354313837674888,0.16236692903683173},
{-0.011538723626812688,0.9428560986574395,0.14178583078665735},
{0.006287817234515564,0.9565143989655157,0.16786454310026205},
{0.010675785873827644,0.964058830342287,0.14749345681547787},
{0.046558150694069676,0.9675216730991247,0.17323590956004373},
{0.04825728208217659,0.9728129435284378,0.1521318262432184},
{0.13139999799605012,0.8528738286567447,0.16603367400460778},
{0.1310368827720484,0.864949529059693,0.17061289159056806},
{0.11529156222275869,0.867156736722148,0.1553211676390151},
{0.11423069569016497,0.8773934134281655,0.15798690431760792},
{0.12975046343819763,0.8772843053588102,0.17382517244983325},
{0.11241634647825113,0.8877106447060608,0.15948150145121232},
{0.12755692526693974,0.88971456980813,0.17562711625767796},
{0.1067093772790167,0.9077562533414268,0.15778737683957286},
{0.12065028781126108,0.9139230652159713,0.17381277943877518},
{0.09838996134873908,0.9265552985665048,0.15153386345966605},
{0.11059831654205302,0.9366183739736208,0.16647115968796902},
{0.08792778141350854,0.942988480801562,0.140540035743055},
{0.09796364176834119,0.956476959679109,0.15347957858879557},
{0.07583219022781215,0.9563555577427841,0.12601170887966864},
{0.08336715334413543,0.9726151386789398,0.13614547402186006},
{0.11558650349292988,0.8571358223386514,0.1515214580555969},
{-0.021502518622342526,0.8434056673524605,0.1551513833875194},
{-0.007100588078737536,0.8521735863529301,0.14162811732793223},
{-0.008002786890754692,0.8612119208546868,0.14750612247277922},
{-0.022588109211997127,0.8543647202800428,0.16227983095511553},
{-0.00798175595098913,0.8706887820527336,0.15245466418128137},
{-0.022555924562279277,0.8658555201330939,0.16827928760833175},
{-0.007038610630436081,0.8804793723257157,0.15640307750438542},
{-0.021404613834983707,0.877725471766456,0.1730667201730788},
{-0.005185880263275329,0.8904507394510022,0.15929932418865853},
{-0.0191503251235191,0.8898149779837227,0.17657766020583268},
{0.0011667772050960993,0.9102930531329713,0.16137763214309842},
{-0.01143811716304316,0.9138909177452864,0.17918267113024094},
{0.010794932282140008,0.9289372228988564,0.1577291296875999},
{0.0002249083646820675,0.93657620055699,0.17510660979323867},
{0.023135892693775303,0.9455710479829441,0.14927461754377822},
{0.015141161260208365,0.9569502735574392,0.16570156609427336},
{0.03736801419986255,0.9599061430179127,0.1388074927971355},
{0.03243187789542958,0.9742100324510372,0.15260463200809518},
{-0.02433754383198876,0.8480902998904808,0.13678781617801136},
{-0.0075379746180103645,0.8406907304199672,0.14930203088423868},
{-0.0058821939825846195,0.8855497745119523,0.17373450518093236},
{-0.021893357012081175,0.8954500429327983,0.16164151652755812},
{0.008415362621889277,0.9230731598914498,0.1758581219838006},
{-0.011674823674252495,0.9228918129606368,0.1635947418213888},
{0.008306105836401213,0.9551867109048414,0.15471930105697948},
{0.031097138211463315,0.9541891974447767,0.16302839360904564},
{0.04754389079362933,0.969740022078521,0.15079525239361558},
{0.030896359039311434,0.9773381647652184,0.1381519025121631},
{0.1388704926688493,0.8534167416851771,0.152785545183521},
{0.13858608545807738,0.8700743985295293,0.15944486771052463},
{0.12321125397436891,0.8640832575867331,0.17432510651591618},
{0.118958158474402,0.8910044343990551,0.17904125448105718},
{0.13442634651041102,0.8957210161195831,0.16378810997292803},
{0.11066276019955505,0.9158935167951727,0.17527267614141692},
{0.12653198607340338,0.9195668300588096,0.1601643563605125},
{0.10029228854615427,0.9366319938927734,0.16658393608859756},
{0.11663867013176087,0.9393584687185619,0.15181891510701295},
{0.08770719820968584,0.9542735318850267,0.15272236561314692},
{0.1045591898604399,0.9563120582739701,0.1384617277886151},
{0.07348991113783516,0.9681300088329324,0.13501647071446904},
{0.09092439909434107,0.9696271341407929,0.12144488430476642},
{0.12348086392993751,0.8472907771750798,0.16757536458023284},
{-0.01972288223440235,0.8395388991862073,0.1664761044993812},
{-0.005317258573502043,0.8481644348826305,0.15286486045429273},
{-0.006211996792862226,0.8572596904841769,0.15865487522062735},
{-0.020799822502338413,0.8505686790278977,0.17349674526378311},
{-0.006183480474417551,0.8667862848356,0.1635079783509712},
{-0.02075769865775198,0.862119052085105,0.17938218621526497},
{-0.005232961312284982,0.8766139302116456,0.16736097788193913},
{-0.019597700429704705,0.8740349570034703,0.18405187278194923},
{-0.003372757959456231,0.8866113970182202,0.1701580804777476},
{-0.017334761396521563,0.8861552846392389,0.1874438523015566},
{0.002994733943151689,0.9064735643039044,0.17203933955636405},
{-0.009605203220564351,0.9102546719777245,0.18981091741364972},
{0.012635269638242621,0.9250903207293292,0.1682024633327827},
{0.002073945614547502,0.9329079932139092,0.18550558537207298},
{0.024958879834396645,0.9417564791792672,0.15998713630238193},
{0.01700259152113185,0.9531928117487182,0.17589357838843775},
{0.039228217552691305,0.9558733456825144,0.1489685225636547},
{0.03431065837183434,0.9688340433981311,0.16223524090132857},
{0.12415752233370864,0.8424983626198876,0.17640786356132593},
{0.12471642234640586,0.8541391179067416,0.18243334553776408},
{0.11266917629684702,0.8597420353851323,0.16507321564760663},
{0.11237546193477047,0.8697022364074554,0.1689472709043622},
{0.12435206782129829,0.866216144361873,0.1871290574276703},
{0.11132329529593957,0.8798906919074462,0.1716712671279391},
{0.12306937878377609,0.878569435819511,0.1904305679665537},
{0.10952757277964602,0.8901693561349284,0.17321047910135254},
{0.12088326402614193,0.8910307199755091,0.19229571613079463},
{0.10388254384967988,0.9101604974866941,0.17155229422178153},
{0.11401010009333115,0.915324689980618,0.19051609213586548},
{0.0956622596148558,0.9289173692951415,0.16526408041091212},
{0.10401637597609606,0.9381092532039076,0.18309018751685333},
{0.08533888140347579,0.9453010042719885,0.15417357481503696},
{0.09147094327501347,0.9580298659297416,0.16990527544517384},
{0.07342425296524942,0.958594900482913,0.1394990228141763},
{0.07700579598200118,0.9741791986395247,0.15229108882832576},
{0.11220072047885156,0.8501437598577493,0.16010361821331684},
{0.13951121134055197,0.8473675518785849,0.16074557618612534},
{0.1414829393998924,0.8593144765036285,0.1661452111041305},
{0.12379440710970684,0.8633285479993184,0.15433838946909836},
{0.12434090171833498,0.8734846701334585,0.1580835574108499},
{0.14213605108265312,0.8715686858378572,0.1706661815381178},
{0.12378821060417786,0.8837671018363028,0.16105293525337677},
{0.14146185888808255,0.8839728506058888,0.1742514920302312},
{0.12214117943455913,0.8940434981427616,0.16320807987637675},
{0.13946658410773177,0.8963696415323408,0.17685154575021622},
{0.11944320853420415,0.9040965476039317,0.16419084565328243},
{0.13619979878583316,0.9085147427972142,0.17810571846929385},
{0.1110494221445671,0.9230033872391928,0.16250167824606623},
{0.12603502632997446,0.9314095542468768,0.1764252261698183},
{0.09888073697965014,0.9400921845452447,0.15827194357194377},
{0.11133322209779713,0.9520587644858264,0.1714952987639254},
{0.08364722300103695,0.9541396501865665,0.15035776671025433},
{0.09293578478906735,0.9676716285329275,0.16184114314968165},
{0.06601692546981333,0.9648347071925893,0.1407321274144552},
{0.07167930461526084,0.9787087698231864,0.14961791634309804},
{0.12215356005260615,0.8534279077881405,0.14986451247713173},
{0.009030179900480518,0.839319542890479,0.1858463807831591},
{0.012595612002856771,0.8498215291772284,0.16729404322921443},
{0.014519007319070684,0.8585858542044911,0.1733381147222397},
{0.011369943209212724,0.8499491771911266,0.19317065031848396},
{0.01664191772030858,0.8679040724679834,0.17813049209839893},
{0.013951419805621682,0.8612478481937443,0.19897801530029993},
{0.018937103368264884,0.8776486970629509,0.18160674409320124},
{0.01673983490067851,0.8730644850935343,0.20318916045783522},
{0.021372367220210634,0.8876907911023458,0.18371975247860378},
{0.019699285941347816,0.8852394535150577,0.20574461173102224},
{0.026613334417639176,0.9078084403109924,0.18252258761039328},
{0.026046973812284997,0.9096945450569324,0.20454496826060017},
{0.03203035673015881,0.9273706967290709,0.17535075211108284},
{0.03260291384104206,0.9334953475799957,0.19618836090413735},
{0.037281263122455936,0.945517720856361,0.16331342047037042},
{0.03896054090684782,0.9555537547133486,0.18184842020184483},
{0.042029013265795064,0.9614700170833318,0.14780110092198362},
{0.0447257448650442,0.9748817212573742,0.16303954731899795},
{0.1092982896820605,0.8463477186056045,0.18236146607362722},
{0.10897483209344463,0.8570887412896416,0.19029795035522118},
{0.09946444780048559,0.8651367378847364,0.1724619288404335},
{0.0985361864862134,0.8743261679773132,0.1775628921919389},
{0.10780741045177356,0.8685498474881979,0.19665804363022749},
{0.09694867894870657,0.883933143398459,0.18130931182780732},
{0.10581833217695184,0.8805325135571328,0.2013277425899228},
{0.09472909066820459,0.8937893422719825,0.183634240702303},
{0.10304108318485833,0.8928253023347855,0.20422398927419594},
{0.08864287054457079,0.9132402226996821,0.18264775702207992},
{0.09541439939369427,0.917156339835969,0.20328955624041678},
{0.08068407884307224,0.9313997141960968,0.17498515828486946},
{0.08543924000702416,0.9399248293239163,0.1942327437591724},
{0.07128024965919065,0.9474883583307285,0.16307796565327798},
{0.07369443299932665,0.9583322430065478,0.17913930798454872},
{0.06112541639820047,0.9602531349345281,0.14728431236086173},
{0.06101266478359413,0.9759278401068086,0.15988924390803416},
{0.09971722804703727,0.8565272883166666,0.16609811766210977},
{0.031613963951618466,0.8370900278081196,0.20098320448949716},
{0.0341346900078207,0.8459659271139381,0.18143694744869449},
{0.035582181306393304,0.8553771673184325,0.18657508983337417},
{0.03337374673584353,0.8485029251936597,0.20720821394397035},
{0.03716973841594433,0.8652295987165943,0.1904094874547439},
{0.035304577858692364,0.8604509775827098,0.21185436618265535},
{0.03887501673753603,0.8753919545352968,0.1928893413604766},
{0.03737916790981475,0.8727721339626744,0.21485595346092215},
{0.04068935355643884,0.8856732584741349,0.19377544165112928},
{0.03958387218403604,0.885249293565838,0.2159688458539377},
{0.044589409350394266,0.9058813023054388,0.19010587107683202},
{0.044300652192741034,0.9098371390421667,0.21185684478486697},
{0.04852542966244023,0.9252775295543726,0.18155097554343988},
{0.049067016638689336,0.9334023132459828,0.20169457571724195},
{0.052312721448778216,0.9427008514079148,0.16809836203989484},
{0.053658614842696684,0.9545598352264908,0.18555269120710474},
{0.05573570828205292,0.9572528489224224,0.1506242288410141},
{0.05781896104790496,0.9708020287681318,0.1640805602478766},
{0.1291805584316808,0.854661991436293,0.16878022550831034},
{0.12399972212390606,0.8971296429354776,0.17872160154683614},
{0.10576703750418243,0.8910136919783154,0.18996367366795164},
{0.09381648172689869,0.9259021373116997,0.18325562182146765},
{0.11070799468991696,0.9343585951582575,0.1706676563064337},
{0.07502168730461371,0.9549079796931341,0.16329236474458272},
{0.09357527655267528,0.9599184244918713,0.15210395436134877},
{0.06120100137264377,0.9686555220738393,0.14650231336309694},
{0.0797868372354784,0.9736599314761912,0.13535851781967204},
{0.11045867209345056,0.8498317410183401,0.17972924009693542},
{0.11578600618494284,0.8521662125113505,0.17653303297301254},
{0.11800687094558383,0.8639890830957028,0.1823428765570401},
{0.10251064991856151,0.8694978260830635,0.16810082824909536},
{0.10319846203228493,0.8793738785603019,0.17174810379649919},
{0.11885452811593436,0.8763077732664669,0.18689360261057789},
{0.10277213005887592,0.8894766735678592,0.17432089289215644},
{0.11831421761982419,0.8889078591463155,0.1901033924746204},
{0.10126390061310771,0.899542215184176,0.17544493899512423},
{0.11641808692793808,0.9014816470566992,0.19158559659716667},
{0.09512562984302991,0.9188331142321271,0.17317701797149573},
{0.10871457886122496,0.9256443874677136,0.18918135245189932},
{0.08506127795577484,0.9364561246728484,0.1672667909978977},
{0.09613567263727447,0.9476642151576424,0.1820144865500231},
{0.07186642668922677,0.9508207150741355,0.1567513335081285},
{0.07964803551162788,0.9656416161425809,0.16920878822370977},
{0.05636031603938006,0.9613164676763221,0.14391093475085254},
{0.060302532856955096,0.9787136898485764,0.1532032144422004},
{0.10072359011699752,0.8600209524920054,0.1634435346934692},
{0.08477374770621633,0.8368186704379919,0.2016499484844218},
{0.08308336578391644,0.8478299103351397,0.20856400935372424},
{0.07803318899172701,0.8553747135022429,0.18867322660550698},
{0.07631430314399355,0.8649421552181135,0.19313594988752134},
{0.08099387933350216,0.8594198047046111,0.2139648835728352},
{0.07428679414188072,0.8748615212690001,0.19628998359481356},
{0.07853138803626178,0.8714347917463859,0.21778194337173465},
{0.07197922787587739,0.885001569667798,0.19809316670376412},
{0.07573059232315801,0.8837164268140861,0.21996186162383974},
{0.06673324150897032,0.9050806394330205,0.19633707703683428},
{0.06934691514810816,0.9081007914418523,0.21808433284155176},
{0.06083419303134674,0.9242055093118263,0.18829525216124665},
{0.062160232821550095,0.9313673808302462,0.20876974573029944},
{0.05448650516040956,0.9372206619180324,0.1751115669976619},
{0.054445558651873664,0.9481451011657291,0.19322768295537326},
{0.048009892795435216,0.9539624673074691,0.15981860374500312},
{0.04660949493888329,0.9631815786615299,0.17343604429562062},
{0.07942243313832664,0.8462845638212525,0.18296376641104986},
{0.04093472278237773,0.838013418669046,0.20015535135081744},
{0.04429573216735098,0.847164455213365,0.18072558861396074},
{0.047995045968187613,0.8559361540822072,0.18612274492975428},
{0.04533177549879534,0.8484259645949889,0.20655880777151595},
{0.05123578118084215,0.86534362681134,0.19035867610940577},
{0.0491847378507301,0.8595933936105018,0.2115829592404834},
{0.05397342210959401,0.8752605266530259,0.19337762599616495},
{0.05244041903472064,0.8713653908844605,0.2151620608340567},
{0.05617192987828623,0.8855529843018163,0.1951361942653064},
{0.05506893950110608,0.8835305440412261,0.21704084131046156},
{0.05895787876414248,0.9062343544044615,0.19295626362019025},
{0.058349394314201775,0.9082197395619879,0.21499351588366683},
{0.05926643995346654,0.9269431378475673,0.18649826555782514},
{0.05871250953820349,0.932848432402764,0.20751186750091544},
{0.05711875592312348,0.9463940182752669,0.17543750318848936},
{0.05627228848183452,0.9529375281139327,0.19241718003217487},
{0.05261514809762852,0.9635855040709461,0.16052624467641946},
{0.05087266595684044,0.9644890289351463,0.17387723548928827},
{-0.011246223779819852,0.8530729595584261,0.165890547119898},
{0.005546863889375151,0.8464112575732992,0.17882518233325959},
{0.010313092012201899,0.8878466084303791,0.19417921834441257},
{-0.005904327900334383,0.8956729932017331,0.18109793663120075},
{0.023289727140039268,0.9202801222032684,0.19307922707590852},
{0.0031670091898701007,0.9193289338185388,0.1808817529463036},
{0.023432209588173988,0.951228420351924,0.16979299476498763},
{0.04608648508621028,0.9505134303649502,0.17822594306956827},
{0.0625902950912876,0.9651718838444465,0.16501003607723252},
{0.045963806669746296,0.9720202245761079,0.15191805919547757},
{0.015038286875415299,0.8427326524939405,0.19064867256816484},
{0.01852817118238142,0.8529184682825759,0.17190672194503154},
{0.020486229750524793,0.8617807476692415,0.17779464149872498},
{0.01742145050887287,0.8534810366265465,0.19778332903430107},
{0.022641386766535848,0.8711759141383937,0.18242095252670598},
{0.020038866837350303,0.8648727543561884,0.20338868793587034},
{0.024961383222630397,0.8809750060169617,0.1857224630655894},
{0.022858289246074356,0.8767551857516858,0.20738792499732359},
{0.027415174626107958,0.891049247527041,0.18765453348954395},
{0.025840047706648238,0.8889696878784843,0.2097252468828773},
{0.032674780912167904,0.9111581968419247,0.18609177479512012},
{0.03221128229859576,0.9134149517625901,0.20808192122356498},
{0.03808433023901954,0.9306202309795769,0.17856178127623118},
{0.03875725834646219,0.9370930262971452,0.19929033157197457},
{0.04330181268049296,0.9485789061248063,0.16619232933217332},
{0.045075215383870985,0.9589233772410072,0.1845488573114003},
{0.04799254257995386,0.9642647526140284,0.15039371883533384},
{0.05078344867023332,0.9746971521436862,0.1645824771957288},
{0.13953230424537283,0.8528082200562033,0.14830299308381373},
{0.1422026139450461,0.8853805231599318,0.16105745870241295},
{0.12782142930195237,0.8466546315244579,0.1661956010870926},
{0.12598614829436136,0.8988818659829574,0.18196705849670383},
{0.13467265760519032,0.9153725393963129,0.1646285296248206},
{0.10190948973815622,0.9438114510938848,0.17644122554709427},
{0.11215283388412314,0.952468365894307,0.15809153850997132},
{0.07302146771285083,0.9674596460787789,0.16125495372663448},
{0.08587796499149122,0.973228592726315,0.14405221507691465},
{0.052105795343141456,0.9771386620732054,0.14885698546413198},
{0.06500938606380254,0.9829125163531202,0.13168522934205734},
{0.027750789758571835,0.8416600621728859,0.1964736232326722},
{0.048685696081443304,0.8343989102428799,0.1965604486681451},
{0.06105213652381405,0.8719412073572523,0.207066450290477},
{0.03944223246065326,0.8769730424930755,0.20592408731716536},
{0.06394359950581877,0.8864230480361596,0.20653652513763354},
{0.042022816760266,0.8899129323431257,0.2055376484463523},
{0.06630818601570032,0.9103017530267342,0.20150868055137075},
{0.04420401149251012,0.9119760736067027,0.20081962913654156},
{0.06585708041318623,0.9333132446755085,0.1906499242622817},
{0.043788845622064414,0.9329140533963164,0.1908395373314703},
{0.06258159519752478,0.954015794434052,0.17479927551200936},
{0.04078972455299824,0.9518853614751017,0.1762604115157569},
{0.05664037330327057,0.9714241703162587,0.15493203948480244},
{0.03535288581579675,0.9678363316498891,0.15805259966922683},
{0.1092202384984167,0.8457887318418298,0.18963740286582556},
{0.10773303999241404,0.85657816162706,0.19737312036827867},
{0.1031749153112746,0.8651019507026961,0.17788263187723735},
{0.10166418247727255,0.8743634213685538,0.1827059917810418},
{0.10584065198986745,0.8681308026052909,0.2033849700325529},
{0.09985607934293197,0.8840745848336649,0.18606327086968658},
{0.10357766338464001,0.8802437563994795,0.2075663843565599},
{0.09778271619990422,0.8940669457196835,0.18789247930185907},
{0.10098383095620618,0.8927050281624669,0.2098417411868233},
{0.09307212030371728,0.9138710641415715,0.1856319940848654},
{0.09507357919658602,0.9174785705164898,0.20731728483429254},
{0.0878434965453026,0.9324704083864593,0.17639920084659633},
{0.08851523492368368,0.9386941537538049,0.19574716971046968},
{0.08233730651822005,0.9490560122645203,0.16273467924696916},
{0.08163091728092062,0.9577447027452952,0.1784638888818834},
{0.07697361133228332,0.9623413944768475,0.14512049263012108},
{0.07492010179297069,0.9762364508681772,0.15704504787020498},
{0.1043609264695328,0.8564541075863684,0.17167745124045705},
{-0.02323040179610424,0.8559541239482416,0.16015275650216212},
{-0.0064372645548649516,0.8492926202512917,0.17308693317411455},
{-0.0016703176373968893,0.8907272027416859,0.18844182430303055},
{-0.017888022589187404,0.8985552853555548,0.17535984858119943},
{0.011316231899287009,0.9231775462235919,0.18733112547297232},
{-0.008817020110281524,0.9222102841035199,0.17514502812751873},
{0.011448180288022363,0.9541099565320713,0.1640546588547652},
{0.03410245578605865,0.9533947806499318,0.17248797894967757},
{0.05060621621909178,0.9680532341294278,0.15927331125844763},
{0.03397977736959468,0.9749015748610891,0.14618133437669267},
{-0.005051986171803926,0.8452794906244423,0.18005137163336807},
{0.01649574215487854,0.8399254248080975,0.1808485892487122},
{0.023031308073456224,0.8708829929290247,0.19344829094521812},
{0.0041306773367352926,0.8874653746242103,0.1954636052244498},
{0.030535796775587667,0.9009831753659211,0.19680412005156903},
{0.01243203664990118,0.9190500043186544,0.1925225082331575},
{0.04209703850349292,0.9423703050169739,0.17944131327102306},
{0.021598056344589327,0.9513711878393133,0.1758661898339994},
{0.05081692219310122,0.9711713404976625,0.14972697484040914},
{0.02928407787269953,0.97667383740745,0.14882476363538097},
{0.08832683636957873,0.8474159589797777,0.19219655964931895},
{0.08225500453178332,0.8794563292628713,0.20538941564108662},
{0.0673885343616773,0.8414424037196729,0.19674426180815854},
{0.057180262437004685,0.8893819289983202,0.20917569120051788},
{0.07298430107268762,0.9138251108565683,0.20066347719720978},
{0.04180846724100552,0.9380583922865254,0.188369585441573},
{0.06187218206552715,0.9468365231281068,0.18264087890094266},
{0.03053820101973294,0.9637876588673254,0.1600800962783286},
{0.051795957673678464,0.9694537311300683,0.15680090555236081},
{-0.0065651852150063845,0.8489688652304104,0.18268741465746577},
{0.007885016106669824,0.8560651281482885,0.16826441599506203},
{0.007115422512974116,0.8656894909639489,0.17314479614274472},
{-0.007490992713089189,0.8606406402239425,0.18860630434579337},
{0.007269108243105408,0.8756398643285027,0.17704983392714552},
{-0.007296397653455172,0.8727063270739559,0.19334167387108545},
{0.008344821602946648,0.8857835067005074,0.1799262517937257},
{-0.005983977782404597,0.8850051636410049,0.19682907957584003},
{0.010328930280334114,0.8959842560674678,0.18173439210709946},
{-0.0035710337433744513,0.8973709348607786,0.19902140323201425},
{0.016984014397555845,0.9156877680255864,0.18082846299875388},
{0.004495552368307213,0.9213230188698278,0.19818239638338228},
{0.026831463805272418,0.9338894329386317,0.1751264386109316},
{0.01642383790471962,0.9434716347306722,0.1916165791248119},
{0.03929387572527696,0.9497995681419827,0.16565819055557005},
{0.03154947072207214,0.9579269915449486,0.1791170005646442},
{0.05368342565083493,0.9562886106970483,0.1519825028529796},
{0.04898026556128281,0.9702108945336726,0.1637409917448852},
{0.09116606280997361,0.8467864435900714,0.19452272782492042},
{0.08890062038855671,0.8573663447373426,0.2023588287169439},
{0.08378110469949733,0.8657352583537863,0.18294021969003954},
{0.08159371346172424,0.8748131141678072,0.1878515823653674},
{0.0861642683329549,0.8686897893690656,0.20847974927154034},
{0.0790667785069819,0.8843310086254675,0.19130179664393668},
{0.08300403812013363,0.8805599268975934,0.21277764550648226},
{0.07626967591117337,0.8940247723030529,0.19285835883283142},
{0.07950550349144897,0.892661528693653,0.21476424517909237},
{0.07005955046298094,0.9132935498262649,0.1903463078843698},
{0.07171524434732923,0.9168068817101532,0.21207496177948917},
{0.0633177276613637,0.9315929832035474,0.18171456328940652},
{0.06348006371321345,0.9399792842145054,0.19875371419315976},
{0.05644456372855293,0.9479159172122323,0.16863251320950912},
{0.05476901624048953,0.95863574784736,0.18392177095186152},
{0.04998535115110406,0.9608975962955703,0.15115960691872313},
{0.046633029266882606,0.9722953618146083,0.16265660327730327},
{0.08559171122207165,0.8572547704587866,0.1766544844813817},
{-0.009145249008154764,0.839700392513305,0.16532387668926735},
{0.007584634304644049,0.8341224469521963,0.17883513392113923},
{0.00619869909199693,0.8741296891799982,0.19399186080323652},
{-0.01031073734010082,0.8799672807157851,0.18031737522271868},
{0.010358760257950886,0.8910197521607229,0.19830234833741345},
{-0.006314957928732743,0.8969861194744139,0.1848729345505691},
{0.021780072497999365,0.9225584285701633,0.19579550245359623},
{0.012270159139460574,0.9414011467662099,0.17810083562293696},
{0.03850688234405578,0.9489272364866158,0.1849300167595026},
{0.048281014698352775,0.9791851199892257,0.14942312299528715},
{0.06516799181932388,0.9723250554691034,0.16237280332407325},
{0.10143243317048652,0.8474965259446662,0.1937717113548008},
{0.09850645565268502,0.8578496845616189,0.20169084542091345},
{0.09293331857986677,0.8660599428504968,0.1823292442448762},
{0.090183309426079,0.8749445420500781,0.18731248638434095},
{0.09506984890025753,0.8689314654777092,0.20790099565512804},
{0.08707266365050113,0.8842591539473528,0.19083581942815286},
{0.09118095920926542,0.8805487731876411,0.21228936087079392},
{0.08367823031470427,0.8937447150391622,0.19246797898450194},
{0.08693508883474535,0.8924026510856606,0.2144110443639371},
{0.07627960271303093,0.9125982151548292,0.19010463177572623},
{0.07766510417029096,0.9160162447836809,0.21186798610180818},
{0.06839516907788086,0.9306115434788249,0.18202314926475271},
{0.06780153145518784,0.9385479781883748,0.20208371626446564},
{0.060591290014608334,0.9464857389501077,0.16865232963419097},
{0.058049471053585225,0.9572912300776691,0.18531970259921285},
{0.05339216510494794,0.9591996546365248,0.15127238331935164},
{0.04906456282249987,0.973322754824334,0.1636951376039703},
{0.09527185498050424,0.8577604300959786,0.17597782607761056},
{0.1164267372496566,0.8476105540394118,0.17461707346343347},
{0.11616502164213208,0.8643912982695927,0.18664812184753943},
{0.09641040090640998,0.8570478939251944,0.19383876993763607},
{0.0918307619580737,0.8872409124079264,0.206000180405062},
{0.11110780561966173,0.896035315273027,0.19873272043242737},
{0.08143381883305294,0.9186237714893338,0.20256828299683657},
{0.10126635442929717,0.9250978804660746,0.19489205194746223},
{0.06763175959670319,0.9465192000799645,0.18752617907401542},
{0.08583617575820339,0.9555995221031861,0.17762685252200966},
{0.04922689887434961,0.9690942470583065,0.15798195950619576},
{0.06917095917710554,0.9754208544174336,0.15043957297624871},
{0.09657439762174154,0.8412790266548943,0.18230941542718326},
{0.12207053927152803,0.8533187873257742,0.16644388267063018},
{0.1251926237963126,0.8701831224155421,0.175678968615945},
{0.10713869596809067,0.8475084356282933,0.18190810494310056},
{0.10868947062082128,0.8869442113301851,0.19714643980301533},
{0.12451010349831099,0.8930149649760182,0.18270060082123155},
{0.10187507434644791,0.9142292221611499,0.197544119134858},
{0.11648162589563286,0.9227651192085902,0.18248306629812908},
{0.08385542558681265,0.9443764856470557,0.1869890287957251},
{0.09022773837072223,0.9603548815553149,0.16478057947749217},
{0.06812498904380371,0.9595466589461512,0.17374958747539004},
{0.05029513924852294,0.9700522392061072,0.15779234643700715},
{0.06636520625957856,0.9751829581771628,0.14329624140237182},
{0.10946682223943931,0.8527796665587254,0.18169224347649096},
{0.10530671150144115,0.8677102333820238,0.19352908098430574},
{0.08935503492502332,0.8440423830815915,0.18548466596940696},
{0.07598951950319448,0.8860754736480249,0.2066373051035578},
{0.09557243507070688,0.8967913385196141,0.2044427011333489},
{0.06353958734532543,0.9172308466184501,0.20174290846036846},
{0.084041357931717,0.9254237051198023,0.19915029054701824},
{0.050556098882372905,0.9453004465864908,0.18395529404677363},
{0.06957199701494504,0.9563950790550483,0.17846597090774116},
{0.0379703021442741,0.9670222471464951,0.15222788447192956},
{0.05851296966715737,0.9751655583896376,0.14969723161386977},
{0.1145231831441467,0.8602302952347985,0.17622072909434894},
{0.11298597883852467,0.8767822273018145,0.18577545558087372},
{0.09536769013501639,0.853224241044412,0.1851612579528353},
{0.08859333567937168,0.8923094308564818,0.19956062314315126},
{0.1080075699733726,0.9002326298302217,0.19195573865843832},
{0.0794509370637602,0.9189446761176717,0.19591943256417702},
{0.09924509150475762,0.9254758920893679,0.18819115086835878},
{0.06553778687628585,0.946795861658825,0.1809208281101697},
{0.08370191335883626,0.955910599073755,0.1709933198510179},
{0.04698623008203787,0.9693260831161701,0.1514235780542602},
{0.06689189683653586,0.9757109376272703,0.14382914087786924},
{0.10030982465680147,0.8458360111790164,0.18893918062281337},
{0.08907303195839678,0.8904199180325006,0.2112553747791852},
{0.06885837025918765,0.8808976612349483,0.2133053399173353},
{0.057170806569567384,0.9167227331650689,0.2084586811527416},
{0.07812613657466261,0.9236268548395027,0.20574585103212809},
{0.04592843701618655,0.9453622753186596,0.190491653118059},
{0.06559059349640432,0.9551876527736819,0.1849085892433832},
{0.03458083840591157,0.9675823740672872,0.15856938823034872},
{0.05557582604639264,0.9744356224313274,0.15591852316502558},
{0.07918827958739526,0.839414287460018,0.19141925760274517},
{0.018151436039226924,0.8407003721825704,0.19859379477846628},
{0.03544314411533266,0.8364223047653213,0.19893271884488262},
{0.04211618570557765,0.879354024956587,0.21115703623643936},
{0.02531127510383315,0.8863731289876176,0.2107170843438775},
{0.04846350178618306,0.9135722810379722,0.20483000751493602},
{0.031224786225361543,0.9181379654558572,0.2042636469095818},
{0.054402393794358336,0.9430527757429313,0.18760858020454058},
{0.03773302555455612,0.9502636244410527,0.18457951762075803},
{0.06014265062129483,0.968092941336858,0.15575617472016473},
{0.042858130491602676,0.9724961905588047,0.15534100884971905},
{0.012127813014447502,0.8884774622652796,0.20176987565243085},
{0.0035623710286448868,0.857051487898401,0.18872527725195093},
{0.02494195098129134,0.8508761620252597,0.18917364399902117},
{0.03767039127666857,0.8981685738384985,0.20129060073578176},
{0.02119513476906909,0.9229736935846976,0.1966369879044398},
{0.0502740091646689,0.9477462940698803,0.17961507567906837},
{0.02956366420216978,0.9567201477351016,0.17784084264394953},
{0.056086405708974434,0.9744443223250904,0.1505932463133689},
{0.03458083840591157,0.9800521598288712,0.1514966968195029},
{0.020300346977664713,0.8440463488451303,0.20032513560231313},
{0.03948350118747664,0.8357727374837232,0.20015411204971165},
{0.04498226780093539,0.8487531029078891,0.2053529801885759},
{0.02498615685173547,0.8553684674246699,0.2049142675971199},
{0.05433730570028132,0.8763790702590841,0.21206468797332198},
{0.03322827757204387,0.8797324207632232,0.2110900024396262},
{0.0587757262876108,0.8907531165278084,0.21149496886197106},
{0.03702970978399908,0.8952715216085065,0.21083813927589284},
{0.0622098172587935,0.9145130716864243,0.20651173911551737},
{0.04020104413472836,0.9172257406978941,0.20615977760146795},
{0.0627055005220835,0.9375614325430962,0.19573601600051743},
{0.04064846901295825,0.9381971940103759,0.19625652246495676},
{0.06019223505853823,0.9584560987590623,0.18000434015640265},
{0.03834955306867346,0.9573443713090862,0.18178645514655445},
{0.05480745936079167,0.9727291667736855,0.1593749339491239},
{0.03343449727605025,0.9679280523247302,0.16222656579358793},
{0.09206511379718195,0.8690704530967254,0.13418255739338195},
{0.10514706473299092,0.8592908306385298,0.12967991622274955},
{0.08745181543081201,0.8634533580136841,0.12568574790281903},
{0.07558115739581965,0.8651605696450012,0.13453797655751662},
{0.08127081355860598,0.8565012010283892,0.12171216437425604},
{0.09772016867309413,0.8551266054208603,0.12193735777819238},
{0.10498023001812709,0.8431880088992475,0.12441995053936894},
{0.1105994566990703,0.838342639007804,0.13283135979073063},
{0.11054834792146681,0.8586452415134811,0.13949122761022079},
{0.09388380056296616,0.8707761527806933,0.14512061656023167},
{0.07315808826675509,0.8656026903144981,0.14548114164492226},
{0.06811165416390516,0.8505041981913626,0.13047603086010948},
{0.07519854796542358,0.8440697964220522,0.12237713616859938},
{0.09263293677784108,0.8397626178218276,0.11923507410998924},
{0.10016635076778205,0.8247263262211929,0.1355355271966146},
{0.11180630050891718,0.8349382292981056,0.14393532419661487},
{0.11156018770231474,0.8551525192069828,0.1506440328726849},
{0.0946811049293877,0.8672321853734697,0.15614188240332533},
{0.07401419747064719,0.8618189429293226,0.15641869269831857},
{0.06397480510766303,0.8470197915952841,0.14030232539794996},
{0.06506649305875822,0.8431348800608415,0.15118456644299408},
{0.06945059507862007,0.8302549228122683,0.1403952358018524},
{0.07108391957800857,0.8400282991928909,0.16012805723112333},
{0.07881068932647771,0.8259428241866538,0.1547453635592346},
{0.08447274625363772,0.8211628893935968,0.14205808045358123},
{0.08309111141582773,0.8248121850018032,0.13112848571328417},
{0.0830368424204044,0.8327106103464377,0.12316420390788695},
{0.09535170315075141,0.823271944408472,0.15222805797408437},
{0.10564856031846719,0.8303110879383836,0.15313750669757045},
{0.10916388747713558,0.8467992951425388,0.15940455324555267},
{0.09432686310130353,0.8594061847854585,0.16417085572644577},
{0.07798894594224971,0.8549216250179598,0.1643224718237303},
{0.08028294186114436,0.8404825278341916,0.16640879805632477},
{0.08936803519362328,0.8284478606908565,0.16174985623022783},
{0.09294764490064993,0.8495083825738127,0.1682972946533991},
{0.10193293731507808,0.8376374766785991,0.1633488644819965},
{0.09135691518026803,0.8383207033782313,0.16703255069588896},
{0.00929908345441873,0.860628358749984,0.12286664771238245},
{0.018213363915484095,0.8687431164956485,0.1282114435564556},
{0.027490387810219487,0.8642901341203256,0.12142244056174024},
{0.01761292252972021,0.8539210876631967,0.11512840203567351},
{0.028732564094592867,0.8544800744269715,0.11607124992396113},
{0.03894767696136952,0.8538698425624717,0.1205523520413746},
{0.030324322434892543,0.8696402217801206,0.13121212614491518},
{0.018581027374544173,0.8718277493410154,0.13976699689228517},
{0.0025502090295094664,0.860153136347951,0.13181375725974068},
{0.0056135258958565325,0.844198014514459,0.12013781821449292},
{0.022919461148657044,0.8338431456619803,0.11747368023432656},
{0.028921569906239626,0.8433063869408745,0.11484061153288282},
{0.03886641598786169,0.8366494190859717,0.12246854701816376},
{0.04559127275734045,0.8508203686894762,0.12887603116745616},
{0.0411317592651901,0.8621165858759047,0.13186242461416575},
{0.03889643186064439,0.8660794246638802,0.14304618761825297},
{0.029962434118985564,0.8255532746700652,0.1273516908073124},
{0.045992880673688584,0.8372290154271361,0.13530479411673527},
{0.047019703604905684,0.8521786922734862,0.14083248601800355},
{0.0096471163839628,0.8313016117402117,0.12407335519910763},
{1.8366442388109062e-05,0.8364992777570032,0.1359875127029138},
{0.011637657034089371,0.8252584573300047,0.1348367472681048},
{0.026947908537174162,0.8219656218988618,0.13796841159043718},
{0.040089531821227785,0.8297188259399177,0.14357010216073327},
{0.04547194045386224,0.8434111574563595,0.14979162917909916},
{0.03639574530332302,0.8623433284062232,0.1537454582480356},
{0.016134845279856258,0.8683289792451204,0.1505593638211361},
{-0.00012625999665970454,0.8567112873518459,0.14270388025981776},
{0.0007728281695818897,0.8483098544743859,0.1516980708561856},
{0.015131841715892708,0.8605128187078895,0.158540636444694},
{0.007069704695180845,0.8287854091330455,0.14613067174748723},
{0.023250713941228397,0.8236804056599349,0.148419338671627},
{0.03621547656447216,0.8326111440396855,0.1546823698840264},
{0.036360995300316196,0.8486816200201062,0.16003984377841196},
{0.027272692177973238,0.8582263825257402,0.16049647666385794},
{0.007117070783444818,0.8389619549494093,0.15660929720839184},
{0.015638121003637373,0.8505900445789618,0.16280087031903037},
{0.017224971711558113,0.8295945860040608,0.15606406668689166},
{0.02842545288756264,0.8387106370781626,0.16213216822835855},
{0.017080642704775644,0.8393581223339031,0.16175188868404136},
{-0.02579543286683908,0.17850321190597046,-0.15597280455345996},
{-0.028618114637471458,0.17630801307123092,-0.17404895305050902},
{-0.00719726595800162,0.17767409468016285,-0.16786637726589862},
{-0.007576454917345674,0.18067069996798435,-0.18015776563330166},
{-0.017359522632615608,0.17907079941941945,-0.1820824002506214},
{-0.00955442905425938,0.18090122236667572,-0.15318315015729736},
{0.008903424183378509,0.19097346860197487,-0.17098232725020937},
{0.000623963320752171,0.18652275414767572,-0.1808282275315438},
{0.0039750459038678625,0.19055167247061308,-0.1542960425503129},
{0.011128316672613337,0.2048495141143412,-0.15899547234353656},
{0.010265725923937836,0.21135207744447126,-0.18007721106142416},
{0.004512902583788571,0.20398210248436416,-0.18861350468521812},
{0.005047016574369678,0.19505902298544767,-0.18391655349420605},
{0.010379754018683279,0.21936293218542474,-0.16711039119834475},
{-0.002247373411294223,0.22400416439871967,-0.19129545142227494},
{-0.0008421051013964399,0.2109097708798084,-0.19364384026670356},
{0.0017876918451279309,0.23043117993343967,-0.17616349816928273},
{-0.012761690744046025,0.23569570624488959,-0.18240090063481404},
{-0.024147162396114592,0.22334863607880268,-0.19620671495351436},
{-0.01936099391849537,0.21237956959828558,-0.19959621587091012},
{-0.009580429591459189,0.21398325001522311,-0.1976629061458497},
{-0.028809437942186124,0.23286899674566336,-0.1859775112331646},
{-0.040011976358026294,0.20939317615157604,-0.194082007565673},
{-0.027562688636732235,0.20652761456268257,-0.19892450227855107},
{-0.042519813682728134,0.2235480520197381,-0.1841470758928974},
{-0.04989860007369749,0.20967909530969683,-0.17864086107979277},
{-0.04168080683409618,0.18979697527620928,-0.18374802093682724},
{-0.03145162789976863,0.1890683529770715,-0.1911379734307599},
{-0.031989484579689254,0.19799871956649043,-0.19582253161071386},
{-0.04892700039975516,0.19473433848873697,-0.17133146315773762},
{-0.026096583035550455,0.18214068458162747,-0.18610888954339133},
{-0.040106882036709056,0.18333894003481102,-0.16297857370459218},
{-0.01752929449110018,0.1511147566117037,-0.18845860444000315},
{0.00353633331241191,0.15456985373662993,-0.1842958044186054},
{-0.0173434117182401,0.179151353991297,-0.1821146220793724},
{-0.02604083927181115,0.18220753248327468,-0.18612253424856626},
{-0.036350585171027364,0.15773636720605771,-0.19711512266407155},
{-0.03137106093488006,0.1891042927091401,-0.19112929832301925},
{-0.04788476056278172,0.1726587174630246,-0.20794536263471594},
{-0.031907690706705946,0.19799379954110027,-0.1957915490830687},
{-0.04904102849450051,0.19188399551742297,-0.21804815764227325},
{-0.02750071118843078,0.2064842142379572,-0.19887988743874202},
{-0.039510790597826494,0.21026162879448201,-0.22471434589740308},
{-0.01933498098828445,0.2123101687363603,-0.19954787073477248},
{-0.02184579263564033,0.22286652316262118,-0.226160622680892},
{-0.009599006715035281,0.2139063885606409,-0.19762446302554756},
{-0.0007801648321281535,0.22632170703862475,-0.22199657096537737},
{-0.0009003398603583821,0.21084661609545646,-0.19362277214790483},
{0.01804108866876577,0.2197000964442709,-0.21334005274130893},
{0.004431108710805174,0.20394985586959108,-0.1886159832874297},
{0.02957528884654223,0.20477774618730404,-0.20250980037765348},
{0.004962768885196814,0.19506772287921031,-0.18393887330712164},
{0.030731556778261022,0.1855524681329055,-0.192408244671202},
{0.0005595196632502208,0.1865698475896964,-0.18086540656471803},
{0.021201318881587047,0.16717484724885767,-0.18574205641607222},
{-0.007604971235790349,0.1807438806982823,-0.18019741087567645},
{-0.012930285266480147,0.13463203951144725,-0.20683991844134633},
{0.011393477537212038,0.13862133737803195,-0.20203268184492845},
{-0.03466388397301171,0.1422772508541433,-0.21683488185968727},
{-0.04798141365602371,0.15950854300134085,-0.22934065692538408},
{-0.04931738024808462,0.1817081189236561,-0.24100497132625937},
{-0.038312374035499176,0.2029287089374385,-0.24870350979553815},
{-0.0179147295280175,0.2174830611240469,-0.2503728359920504},
{0.006410260183769419,0.2214723713836426,-0.24556559939563247},
{0.02814265676822826,0.21382704850384715,-0.23556938428317464},
{0.041461413359335036,0.19659585550073783,-0.2230635968244669},
{0.04279737995139595,0.17439627957842255,-0.21139929481660263},
{0.031791146830715815,0.15317568956464034,-0.20370076874033488},
{-0.005739847857571547,0.1297826914634541,-0.23040769517748463},
{0.015324590216878977,0.13323778858838012,-0.2262448951560869},
{-0.024562340659571233,0.13640420291371952,-0.23906421340155307},
{-0.03609651605132564,0.1513266523147748,-0.24989447815821955},
{-0.03725278398304447,0.17055193036917315,-0.25999602147166},
{-0.027721294392253577,0.18892955125322117,-0.2666634614209067},
{-0.010056296430067327,0.20153445801437136,-0.26810848651027874},
{0.011009318980433737,0.2049884149822803,-0.26394568648888095},
{0.029830584874338685,0.19836803129602112,-0.2552891434787904},
{0.041364735480070955,0.18344559428797685,-0.24445890350814606},
{0.042521052983834025,0.16421907693247265,-0.23435736019470563},
{0.03298958817906523,0.14584278210060786,-0.22768992024545892},
{0.007195456578387218,0.13757730055445513,-0.25160217311696764},
{0.024475577189153677,0.14713907866427198,-0.25128000440150183},
{0.008528250559617262,0.1567201279062841,-0.26815061035486515},
{-0.01352954931619358,0.14603111868965749,-0.26172542898578177},
{0.030846539134857902,0.16232039328030842,-0.2575367647503058},
{0.022651313568393405,0.1774659788454646,-0.2672149504129912},
{0.006842255763231945,0.18132943807776555,-0.2739502544907919},
{-0.01370564161031784,0.16790780710186573,-0.2729000831267413},
{0.01959021505102568,0.15616616031198788,-0.24396690096914028},
{0.017295029403069376,0.15601373866898458,-0.2509800935338963},
{0.028098029535408162,0.15028686629399093,-0.2584282931798019},
{0.030327544617767696,0.16029425990242308,-0.26289102885482735},
{0.019523317577334175,0.16602103313332833,-0.25544284160193276},
{0.036920638893676944,0.16258202213675557,-0.25999354286944837},
{0.022698394617403056,0.17012067837037417,-0.25018943182140185},
{0.04075379721394087,0.156022339418659,-0.25325421106305385},
{0.02349650452954335,0.16517092214678836,-0.24135815974840352},
{0.031577987040516814,0.14399127864154201,-0.27080768431872837},
{0.03381245932729957,0.14862750407836947,-0.25377101201718677},
{0.03839167691325989,0.14034027279780958,-0.27006656986444416},
{0.026402678015673933,0.13953224847682294,-0.28339029605298527},
{0.024756018636386976,0.14818348727818048,-0.29244564615892477},
{0.03380627521478161,0.1539985731058856,-0.27527040760074273},
{0.04149985647963718,0.15429480324920694,-0.2762891007167058},
{0.046310798586361474,0.1459666378531224,-0.27302849950732516},
{0.034688669995127853,0.14842544842607847,-0.2928523599958288},
{0.038045899511728425,0.13884438679105532,-0.2931275096273403},
{0.0061877312772105715,0.1397523607462254,-0.2933769809399394},
{0.031580490428750566,0.13447091797468114,-0.2866298291435671},
{0.015980155715829333,0.13326132291637952,-0.29713538461750094},
{-0.002451982023863071,0.13717261917136453,-0.297567913096439},
{-0.010253394877935008,0.1473113415179792,-0.28425161032152174},
{-0.008025106703670298,0.15731996203450618,-0.28871435838955817},
{0.0027791203367632253,0.1515918627514177,-0.29616255803546393},
{0.01908705880206769,0.147214614066671,-0.3033579402557847},
{0.019115575120512276,0.13737581498067278,-0.30587370910756373},
{-0.003250079542992339,0.14212237539495035,-0.30640041207753216},
{0.0006562099355253317,0.15112714962276186,-0.3037904191626785},
{-0.020507322655345578,0.1512708713720025,-0.2945043607628818},
{-0.013566046733759673,0.15866580585638046,-0.29398759698778204},
{-0.026064385992821577,0.16132657293753896,-0.2747300723186105},
{-0.01814525192670888,0.16695302474392912,-0.2776920019614914},
{-0.01779947452517741,0.16844882399960617,-0.2546310869846175},
{-0.011334015870155362,0.1728222928159802,-0.26112749098825155},
{-0.011503837300684217,0.16361433517187146,-0.27633495485762066},
{-0.006329755183936067,0.16807336533659054,-0.2637523431233638},
{-0.01373335238304375,0.15360694156343932,-0.27187224396861737},
{-0.00855799378615667,0.15806597172815837,-0.2592896322343606},
{-0.021253431493086256,0.152998506685543,-0.27146821941511295},
{-0.014440968528437915,0.15886776236458286,-0.25490496013598996},
{-0.01667294981999803,0.14471128779799414,-0.28776504134949826},
{-0.10287611981466421,0.272294473855366,-0.037997882790383845},
{-0.10266281130833259,0.2890775851506593,-0.034707835786729195},
{-0.09569541091943616,0.30107263183764155,-0.0535073395532162},
{-0.09911854646884355,0.2989140295645564,-0.04336282967043742},
{-0.09933884463341193,0.2427407116690317,-0.08274743462967059},
{-0.10582595387875252,0.21134045280009872,-0.12070574033924043},
{0.0220442047426802,0.20141900472335433,-0.07916095919451772},
{0.03867168460510611,0.17110514198979482,-0.1217987047704746},
{-0.0989414751268457,0.18159777155319515,-0.16663700296194822},
{-0.10103223805739896,0.26174077153347153,-0.047173643391763644},
{-0.014559111102854554,0.2504104116015783,-0.026872565226446543},
{0.00216670730231717,0.2315951067459922,-0.05413347165090354},
{-0.07161859125408725,0.28223888618160115,-0.12670543245966676},
{0.007936930429992077,0.2758958332967997,-0.10096227331347059},
{-0.017072760749742705,0.2708772462897972,-0.13613703438132954},
{0.028029991904699285,0.2770282694682537,-0.09467948764144463},
{0.04119932596147882,0.26583198952299786,-0.11855951868420228},
{0.055657892565619246,0.24918380093909392,-0.1557658784478232},
{-0.08954123991617094,0.27630599239077785,-0.16063051947146215},
{-0.08215516643469943,0.25974848346878576,-0.19974732385474123},
{-0.010974110436017688,0.30314520182796156,-0.030371298143308204},
{-0.012229708351366985,0.2943853134986578,-0.0266491440230915},
{-0.019517616792247408,0.2655534442064565,-0.01109843092644679},
{-0.019338860000745695,0.2815173774708107,-0.007620468696118469},
{-0.015906045509701917,0.2918705360877633,-0.015802223059562904},
{0.009085304013666898,0.2846284817877977,-0.0672852572040248},
{0.046506620554090224,0.18749313930653433,-0.1414407597867562},
{0.051396568106309666,0.20242266511690407,-0.15289367420500272},
{0.0541816246953697,0.22169900237686171,-0.15678826468108156},
{0.05439095504515173,0.23877882714290746,-0.15420025696784498},
{-0.08970516227343613,0.2032658731962847,-0.19082527297574245},
{-0.09642162897442856,0.1899653591174554,-0.17224969852606384},
{-0.0841479006477833,0.23278343539731833,-0.20113156122487336},
{-0.09116776065248855,0.2865781255014327,-0.13303788932001348},
{-0.09061680455987951,0.29343980111299267,-0.09702301842553844},
{-0.0911582799990291,0.3026367909423148,-0.07306926135999627},
{-0.0938888445184668,0.30982949627224726,-0.05700715066203992},
{-0.03262864173199866,0.2722862448960234,-0.14131581344926863},
{-0.004536783916097427,0.2706850182952753,-0.12926436616896106},
{0.004675957430279716,0.2723345652461389,-0.11665110651835758},
{0.00858030120606125,0.28129451395295324,-0.10126507175265266},
{-0.07114851195164323,0.2876916623310233,-0.126908206906599},
{-0.06036553892517433,0.27753770897381813,-0.13760748992939273},
{0.02619163743036598,0.15678546386058234,-0.28386213516299946},
{0.03506782177543874,0.15408243661171575,-0.29900329642320783},
{0.017152546954934657,0.1625633954411353,-0.29413750284954054},
{0.016515459435472005,0.15311376168838306,-0.2774760537438044},
{0.02591853264567903,0.13512342239990022,-0.27613971536141174},
{0.009338034688174292,0.13244487134787317,-0.277262150372942},
{0.00541410995492103,0.14904928781672003,-0.27872913587790893},
{0.003121340944121024,0.1586175846503535,-0.2912777535828334},
{0.0043828875047782385,0.15651968334543082,-0.30886483668449755},
{0.021773405058050133,0.15861049584802822,-0.3094913777515498},
{0.007904869710384847,0.14021878411040736,-0.3202062016102103},
{0.023869558948413645,0.14278660360863035,-0.3199187209326961},
{0.029288192352370814,0.13171011450826184,-0.33951459958977526},
{0.0071322026499467455,0.12832083666506514,-0.340198433546949},
{0.0038089671626786083,0.12731396648165155,-0.3506570690810169},
{0.032736758360469354,0.13199727296748864,-0.3501750057368797},
{0.036479422913987154,0.13794964857169514,-0.31102174111506775},
{0.038117803761887344,0.128279419222109,-0.2984441237642673},
{0.0367174059053355,0.14367160092129883,-0.2855068984115946},
{0.028065832492679285,0.11954848096663688,-0.28964010392258566},
{0.012507621624344394,0.11771313799399066,-0.2907616714233418},
{0.013142726262037826,0.09670293173593021,-0.2979258356488074},
{0.035285666123817665,0.09785805951063171,-0.29610501728512123},
{0.011806201984479209,0.08580476567167648,-0.29645996551483567},
{0.039715250494262756,0.08860811434505819,-0.29383016856831123},
{0.04971137885564312,0.1111978098624708,-0.30910461666244926},
{0.05877695319570553,0.10494703533800782,-0.3102509082202663},
{0.046981929707200665,0.12515488088113497,-0.32739531296693575},
{0.05555970273900602,0.12320570810192025,-0.33402443372599083},
{-0.0076515813503797514,0.1157510145182202,-0.3275408688818129},
{-0.0020814309932265275,0.13147061956956452,-0.31136505230739864},
{-0.015157284567594902,0.11081516325304164,-0.3340132800160385},
{-0.006249200612058607,0.14708187252522792,-0.2993158853411258},
{-0.00036377205358780623,0.12180522349429096,-0.2987774585826965},
{-0.005516290331094834,0.10109785285444585,-0.30921850843407295},
{-0.011712039886459904,0.09269035979457857,-0.3103587522024937},
{-0.004233750009705227,0.1375159427567065,-0.2858308765066749},
{-0.046537528723668974,0.2740464118635914,-0.14248596155337248},
{-0.2133982565177432,0.197348681350472,-0.022679873262376693},
{-0.21611490368576267,0.18733069171758518,-0.02598003296305474},
{-0.22121648668782096,0.18867048775006307,-0.03074959480585608},
{-0.22325205114712154,0.16547074626331643,-0.026156013720079477},
{-0.22989221407902938,0.13286223078127624,-0.029013842070072546},
{-0.22960718721770462,0.1313291781343586,-0.018592559071333684},
{-0.24366210105867234,0.08493102121304869,-0.005361780465728235},
{-0.24018276320411658,0.08148670600774308,-0.01655316517161616},
{-0.25488769047508053,0.06301396876382441,-0.002382513000377033},
{-0.26272874857152734,0.0371323796841095,0.005021071805719535},
{-0.2493343822199552,0.061507003405184196,-0.015432353644534528},
{-0.2380864853836425,0.08618638366118796,-0.02856149716645265},
{-0.2326645430457328,0.13677097407598338,-0.03765053147644799},
{-0.2323386068549053,0.17259045675811663,-0.0364000766606878},
{-0.2246801969554325,0.20516059108491014,-0.02527888596943285},
{-0.21862821872135216,0.20763546300019747,-0.0010849399565740208},
{-0.24051905995218859,0.21384662946131877,-0.009727986977622257},
{-0.23244518675000478,0.2098228170589375,-0.01951210809883211},
{-0.2438977293779196,0.20484706029815175,-0.024511262864495422},
{-0.24795751869140262,0.20671339819145435,-0.0176754514670137},
{-0.25654587535465156,0.18674580356069911,-0.031813423268092646},
{-0.2591831081078108,0.15879960080376346,-0.05167446278977052},
{-0.2524289170811576,0.1525782225015302,-0.051808294916186715},
{-0.24305484351682646,0.18050835152312358,-0.03561064185628814},
{-0.23816208275109674,0.20291500226720835,-0.026728570830962726},
{-0.24549502739416226,0.14700263161252256,-0.04750915938013902},
{-0.24559788938594432,0.09767718351423905,-0.05494623010211451},
{-0.25145226105870355,0.10198219333752831,-0.06544307328927448},
{-0.25077940730932724,0.07427301931008949,-0.06048838464728757},
{-0.25323694140214437,0.0476689672577328,-0.06554474555199495},
{-0.25803303668162103,0.08048815153474942,-0.06961458559744607},
{-0.2580714550159011,0.1113913515161649,-0.0711872710937274},
{-0.22298022284257366,0.21270964505480647,-0.004679607172036263},
{-0.21460295633667698,0.20724875148314112,-0.006122698951683242},
{-0.21610500166992724,0.20197061764554947,-0.009694364738621689},
{-0.21323974990631037,0.1980420207471272,-0.0018694299495614869},
{-0.21406139414644998,0.20449627612015278,0.0032577817993649496},
{-0.2178710057457035,0.1993792514263162,0.005981554948742784},
{-0.2273764452272503,0.20605532930427034,0.006015016078599597},
{-0.22126893391061878,0.2118750501181111,0.0068286296475735695},
{-0.2302416969908672,0.20998515311078722,-0.0018099187104605933},
{-0.22561044115147405,0.2086479224315984,-0.009660903608764886},
{-0.20754445492349263,0.19159779132004767,-0.01655944842822259},
{-0.2061819301087342,0.18761822196714367,-0.0039018837630865077},
{-0.20718053415377213,0.17688213170150743,-0.004438401997812866},
{-0.20967798613520733,0.1809235297865803,-0.017749834319384296},
{-0.22019221671688177,0.1577188806674547,-0.014629261741948871},
{-0.2193123253247692,0.1559838591193236,-0.0070583712865682265},
{-0.22370438365773038,0.15782543577653216,0.0005596002178220491},
{-0.23661667427215427,0.12878489296413498,0.007099392153170478},
{-0.24357782858347737,0.13307534099943097,0.014017170925790337},
{-0.2818325751175565,0.10412405265267398,0.026866232397795883},
{-0.2741728887379447,0.0943526715468318,0.02674807743036815},
{-0.2985433112282706,0.08580343961949327,0.03151113294236399},
{-0.3192036999631946,0.06867512100117727,0.03882177016552496},
{-0.28866979931829884,0.0780021259095098,0.028593818139292126},
{-0.26292207954403335,0.09157115935893442,0.02103655999607538},
{-0.23333004773955165,0.126753752809782,-0.0014034651267887841},
{-0.2197547434265316,0.21697229556629907,-0.007625971193028255},
{-0.20955622480156166,0.21196430458375148,-0.007262013244274585},
{-0.2073840521813679,0.20636639388182806,0.0001667665533030464},
{-0.21201653492885583,0.20770486386212272,0.008017726665585208},
{-0.21378811585960825,0.21934336362096413,-0.0023443053472849726},
{-0.20883718229997192,0.21290187304932837,0.004846888035298221},
{-0.21819980472208544,0.21981432282719315,0.0035977716647322905},
{-0.22438726335305267,0.21831076554659373,0.0002262406133707716},
{-0.2681389299419429,0.17584215978555762,0.004773979951243553},
{-0.2442694205655735,0.20649896192111641,0.00989043456657157},
{-0.27077305204932656,0.18154832343907337,-0.011115595246762219},
{-0.32997125608390726,0.14215178401019124,-0.024884974112951787},
{-0.31795242720870454,0.14121714029522406,-0.0556185509520153},
{-0.2644405951889798,0.18161602645848357,-0.02710516965099564},
{-0.24579398399991628,0.21155517410969113,-0.004134116397303856},
{-0.21863937243130444,0.20761683630457717,-0.001093615064314678},
{-0.2355804574385551,0.19779836175671434,0.019477271344747846},
{-0.2567842425293426,0.1678024789008831,0.014647194428949909},
{-0.3252987810897349,0.1313298349639446,0.005933370921748973},
{-0.22303952340048655,0.18960616008494793,0.019610880396965003},
{-0.24413084191592202,0.15604371736273412,0.014256492362332908},
{-0.3057447412379878,0.11289623484894751,0.02508742634159658},
{-0.21146963135086277,0.18385650935562944,0.011108518837448069},
{-0.23044432272166682,0.1521398817004059,0.00479792324860774},
{-0.2787707082335032,0.09388284010460904,0.025253455510741672},
{-0.2546832057926222,0.08156556273710573,0.006365899400687005},
{-0.22578860307844498,0.14946380925059075,-0.011693022810991325},
{-0.24265806887479097,0.08061816661375974,-0.02437310557721995},
{-0.22813250565287058,0.15542818128950148,-0.02748168171995115},
{-0.24733367930076103,0.09144606430531423,-0.05518799296183552},
{-0.2376324426375076,0.16617704874953856,-0.03678097585555787},
{-0.2668876819734749,0.10988392761611546,-0.07434561756886784},
{-0.25326886579863,0.17380487269772,-0.03751726942854047},
{-0.29387177810293874,0.12889854926854857,-0.07451384030097022},
{-0.20554791605601394,0.1832559192537328,-0.0029453292045686576},
{-0.20798774053602903,0.1875529851569338,-0.017293759119435915},
{-0.21675060318798683,0.19605048865611605,-0.026631434410289506},
{-0.2289482012477023,0.20508059419853022,-0.02664167103742348},
{-0.2393166156612674,0.2115506382676439,-0.01793791065520169},
{-0.189445354569964,0.2402957069103943,-0.0009657191901952984},
{-0.18599454542686394,0.2509180665135505,-0.0029861889620271436},
{-0.17593604304082824,0.23712607040217984,-0.0016551671813783556},
{-0.1678934745845771,0.2596526978863179,-1.456798449877765e-05},
{-0.16955122570876108,0.2680094167798804,0.0008372780235893752},
{-0.16462106283565808,0.26579899932756124,-0.0010791152413767238},
{-0.20638864553318298,0.2191278739446861,0.006854878044994574},
{-0.20879808235008368,0.22146479925388604,-0.00043306757491905066},
{-0.21624753369010621,0.21152633557295888,0.004287541874202881},
{-0.21141796488776166,0.20754128850916714,-8.358466308121487e-05},
{-0.2068325631892834,0.2167640929805235,-0.0028001326870122027},
{-0.21422239175310548,0.2118770329998805,-0.004483376234942637},
{-0.20353861238714543,0.21306753042814158,0.0022179462065368117},
{-0.19428139252408086,0.22058972874307503,-0.0007060236434732381},
{-0.19616781948830853,0.22536079014021437,0.0018231048742264055},
{-0.19856254580108332,0.22332708463257267,0.00684467859689378},
{-0.1960780197301817,0.21833903400481736,0.008180310577656157},
{-0.19106492282707802,0.23238678468539348,0.01107632179471918},
{-0.19795940273890872,0.23776401303940564,0.008919727189425396},
{-0.190839370025821,0.22035193164689262,0.004364267005663443},
{-0.1916425858585172,0.2403464810766993,0.0030361947616464936},
{-0.1873507374129717,0.23366823442180984,0.006953167015696203},
{-0.19924478105983057,0.2394696135792848,0.003548868843097121},
{-0.21134338374721412,0.2323101091259772,0.0068704188808614095},
{-0.21687576020666238,0.23295324443483606,0.008221814771689666},
{-0.19878421958987916,0.24360234815585566,0.012347101148614634},
{-0.21646237892980907,0.211677431163779,0.004287541874202881},
{-0.2168423610418608,0.21371841136891193,-0.004478369458475177},
{-0.20964824290866793,0.22206217956591864,-0.0004318282738132456},
{-0.21474302214765537,0.22232361013418886,-0.0027840093796256222},
{-0.21932316920944503,0.22416234879186506,0.002249511205701738},
{-0.2218603036122882,0.2148804544437838,-6.251654428248515e-05},
{-0.21099822599623558,0.2324893740309323,0.0011515028189669674},
{-0.2126429892448307,0.22352280745621275,0.006867147125942071},
{-0.20430809444374154,0.24393082491395005,0.001958795952301317},
{-0.2153898877528429,0.23542329546882199,-0.0006646805585834966},
{-0.2167655615523339,0.23857336341257548,0.004416317652107364},
{-0.20541107242791062,0.24636116874050576,0.006989106747764637},
{-0.19293627988985906,0.24491236378276096,0.008168921400493776},
{-0.18315181176433962,0.24416228918148175,0.017605839923900468},
{-0.18031646433640586,0.23916572455512958,0.0164573671961372},
{-0.18804767078283383,0.23392305951518622,0.01947070304888707},
{-0.18373569608732992,0.23378350181766114,0.02488709331784273},
{-0.17579673320352435,0.23937770700927802,0.02071188789237582},
{-0.18601351912679387,0.23790535533052298,0.028934650729411423},
{-0.17638169571847678,0.24469299509402187,0.023869627109974426},
{-0.1804502097117447,0.24769735840676568,0.02246750662488545},
{-0.19751709617424584,0.23537431828912048,0.01576734912644547},
{-0.1964785370615567,0.2294211867112394,0.00976471986239842},
{-0.19696032775945058,0.2257947686014463,0.01898742518966621},
{-0.19663062409326146,0.23127514398649487,0.026136308832497127},
{-0.2041779678276317,0.22733662028621518,0.016541639671332143},
{-0.20577294835080653,0.2275943701302011,0.003817735218002143},
{-0.19876209806514053,0.22673621607948427,-0.0017800515538106303},
{-0.20080459021762256,0.23194807209393736,-0.007177344192725797},
{-0.19117272963027226,0.2387369387655311,-0.012242367812162794},
{-0.18275009231089198,0.2379124565258593,-0.00914173558951982},
{-0.18055439775570994,0.24536600995254207,-0.009442786614142693},
{-0.17300706641435074,0.24930567380983906,0.00015064324591648805},
{-0.1730169684301861,0.24317734223462986,0.0011656308515731713},
{-0.18585139375613205,0.23767059452204986,-0.0032922591561285242},
{-0.17849593101197403,0.24165421638956985,0.0036603439775645284},
{-0.18130665352693534,0.24661238746766417,0.003868311096130156},
{-0.19411750734584887,0.2394187526619025,-0.0022213542845777646},
{-0.1895323659006028,0.2454321018805147,-0.008644664308991327},
{-0.17848105939870432,0.2515686624150665,0.002019521706485896},
{-0.19955041749854496,0.23512565252224008,0.00616745011461398},
{-0.20145077420720187,0.23464797630401746,0.02104872993293442},
{-0.20483053421790595,0.23454358997187516,0.00045637882871930906},
{-0.19349271369335577,0.23229005723408513,-0.00029302654996275095},
{-0.2405103476654148,0.2077221645055598,0.010936602988050392},
{-0.2422455798947339,0.2121514142647063,-0.0021296707887701128},
{-0.2520945908218438,0.20710210498329093,-0.004887239679303331},
{-0.25031962659907253,0.20189128998176675,0.008310201726555881},
{-0.266279346239667,0.18767524221102183,-0.004074146616793804},
{-0.28481549852116983,0.1717573613757594,-0.027642567789507126},
{-0.26222559232256926,0.1897535749514839,-0.02192998455626338},
{-0.28137279440730173,0.17047496977050255,-0.038043389926989114},
{-0.27324050055099014,0.16612135455784346,-0.042289235515487064},
{-0.284029855978154,0.1289534750935579,-0.07377121389933694},
{-0.295963829906642,0.130714311283723,-0.07698583703769211},
{-0.29330602475512635,0.10996987314780321,-0.08720771648850649},
{-0.2991059539303074,0.08929834309593791,-0.10370655689614953},
{-0.3039491426518048,0.11706111689620304,-0.08494102237297274},
{-0.302418605786132,0.14067234352911093,-0.06574300894290211},
{-0.17722152050583856,0.23535579073758858,0.020324581510788736},
{-0.18941224044441682,0.23958846255533184,0.019015111176369955},
{-0.16795094097685342,0.25892030811181865,0.020973504355811877},
{-0.16493563463534533,0.26443689587517877,0.022787618100515637},
{-0.1701135585855214,0.2664859067514775,0.021086392293539914},
{-0.18713700754426404,0.2486115784395093,0.022263678772013216},
{0.013855882083374968,0.2771681122050331,-0.0004869895660327508},
{0.00904634038690031,0.2827588349605429,-0.010237252981031909},
{0.004370791925985536,0.27740799132707333,-0.000752509827952108},
{0.0037862755594312305,0.26845210752788595,-0.002029572438454005},
{-0.029944625362095068,0.2883886948449738,-0.034098954760434695},
{-0.012272203986285103,0.290466643402093,-0.034170549185317214},
{-0.007509569836665194,0.2804667227793289,-0.0400448364268468},
{0.01406791410956762,0.2745403477123223,-0.01665674595803958},
{0.015803307448030497,0.273564100659233,-0.006389185868465132},
{-0.13963019663972054,0.2652340515254676,0.057045184812977164},
{-0.13990657317932675,0.2638612652975531,0.047579948259302764},
{-0.13926701945066353,0.27368702693591823,0.056775388962242775},
{-0.1445142822977096,0.26869207340100354,0.06365988010716064},
{-0.14762011958499696,0.2767339354556244,0.05963011905947133},
{-0.14951363535154982,0.2855254879281816,0.0180498691171004},
{-0.14981106761694374,0.27241370701475587,0.01779334618120921},
{-0.1605223346814306,0.26857559149006865,0.015534100265321359},
{-0.15134780098814557,0.2598745203912465,0.05054559580550114},
{-0.14720445799410897,0.2622646736829408,0.05895627386921039},
{-0.15195787174350162,0.268915593748447,0.061157061951937285},
{-0.15815279096712587,0.2700937973097387,0.05381982932704568},
{-0.1672604395797304,0.27900307099433663,0.01456248819836794},
{-0.16062892696954112,0.2834992554062077,-0.02061011648556688},
{-0.15484633561683026,0.27380293876834433,-0.014934117420966566},
{-0.13312883543166323,0.28305184292098895,-0.04695270079062019},
{-0.13030321651741006,0.2763262301778357,-0.035839887774840505},
{-0.1024895941927738,0.28081863472133406,-0.05666882146015435},
{-0.09809984095986943,0.27439625417274993,-0.04568992732186826},
{-0.03533244974056188,0.2827163765046578,-0.05411032150624705},
{-0.038233071157738545,0.27265661003149416,-0.04743727991600215},
{-0.01271460969503646,0.2697133194772445,-0.03539994827528975},
{0.007337282196935844,0.2639827663779666,-0.014435930769442822},
{0.011567264731279505,0.2665480329159115,-0.005130378163251773},
{-0.020273119532369994,0.2729516008737097,-0.026857445752955688},
{-0.04219883469632388,0.27662358808516324,-0.03759473814066453},
{-0.09805755600613925,0.2949445853016867,-0.0408210726744696},
{-0.04313049169562608,0.29388551575569655,-0.04966047456272206},
{-0.1000427552684998,0.283028581239233,-0.0359505449705781},
{-0.10232599405379607,0.29361320412371733,-0.05429927774584959},
{-0.12607472114439344,0.28494797361287516,-0.027195750168819137},
{-0.12573765602963577,0.29706593418353144,-0.0330254349635507},
{-0.12975917572497145,0.29589851254186034,-0.04525609757676914},
{-0.1451264970439787,0.2789746042479361,-0.008383171775665848},
{-0.1446654894256292,0.2920516971234103,-0.010115714721585343},
{-0.15416226619244644,0.29476201146277914,-0.017754766737785397},
{-0.1600662718744933,0.2894094699867947,0.015950505436872823},
{0.011668627168723515,0.2740248480243504,-0.002779064568213451},
{0.0028175510640543406,0.283755778342099,0.009430542319217305},
{0.013458190358521246,0.27546241252106535,0.015128848803722164},
{-0.0038201828376861198,0.282219032577886,-0.0036800116861137088},
{-0.001615428991420634,0.27198737504134685,-0.014247557001360016},
{0.007611155348308391,0.26079279293860586,-0.014230206785878724},
{0.017189701202086752,0.25704270497146436,-0.0037878556683411087},
{0.01990748852712359,0.2635750611001778,0.009219861131229964},
{-0.16921232642836687,0.252431253163742,0.015018538612294203},
{-0.17000176123276647,0.2506726972876115,0.011420847502133784},
{-0.16993236037084125,0.25085234637590953,0.007513331115521391},
{-0.16902767056360146,0.2529269859990761,0.004128799795559935},
{-0.16802244865065852,0.2569687682674919,0.0034288549240106807},
{-0.16823977249257302,0.2563673230478322,0.016161682345302488},
{-0.1619803476463915,0.26584409749480165,0.015043944284963261},
{-0.16161450595995702,0.26630531579433914,0.005601733945834778},
{-0.146854095178486,0.2744845667695498,0.005586230289001111},
{-0.1439652966938588,0.27812469154957303,0.016907307855611835},
{-0.14451355111005718,0.2858126463874082,0.005806466488514246},
{-0.15093513850593365,0.2919447578309901,0.0175817974824478},
{-0.16036427421839583,0.294745553544094,0.005925067604340066},
{-0.16654024452811228,0.29209679529065075,0.017203463640866754},
{-0.16879469434872063,0.2880214527482897,0.005856397930067248},
{-0.16984931480374107,0.2776807738934726,0.015617121046399424},
{-0.17000262874354055,0.27064749225779144,0.0056872333291244645},
{-0.17144760426086839,0.26650567360411503,0.015178086236655916},
{-0.1754089682805281,0.2612521275004625,0.0034955417165142035},
{-0.17590331309862386,0.2610629234006389,0.016378064318376552},
{-0.17864091684834252,0.2586698329653238,0.0042452940995058724},
{-0.17879336327736794,0.2581555725784578,0.015126370201510543},
{-0.18010826175063013,0.2567229405001438,0.011534863203868113},
{-0.18005249320086877,0.25691005018109864,0.007637261226102181},
{-0.31814158173648405,0.10839672911011262,-0.010690923936835019},
{-0.3208785534426387,0.11456127306363352,-0.02801577092451014},
{-0.32391678685460423,0.09630921816762612,-0.030757947695309228},
{-0.31930176585969716,0.09620436090106375,-0.04360563354308732},
{-0.31420836224493714,0.11411367468324898,-0.04537484740872766},
{-0.3070426612861004,0.09797756531626474,-9.294758294308304e-08},
{-0.3216060727637922,0.09160113805268395,-0.018155184925071947},
{-0.3114540651093233,0.08235715392542947,-0.02606115761344093},
{-0.31253555361231766,0.08533938332042343,-0.03582580931427851},
{-0.30952392799509376,0.09132854138145043,-0.05178903617700246},
{-0.30068621155634523,0.10722930746844155,-0.05612507809998112},
{-0.29182685692028926,0.0872836484672592,-4.027108943321645e-05},
{-0.3132499363417496,0.08387942465272652,-0.010608361697166111},
{-0.30448119940255025,0.07758251094809422,-0.026588443054929016},
{-0.30204441121024433,0.07609417228507429,-0.011002558592901496},
{-0.29226643702251937,0.07121855105363792,-0.01918558943648488},
{-0.3026322612967733,0.07868714959574508,-0.03714585088712983},
{-0.28764982972219677,0.07111510659033612,-0.03203372143266108},
{-0.28996177072110363,0.07582243073160372,-0.04463669488408634},
{-0.2983173370646376,0.08354357405305252,-0.052183096749616215},
{-0.2854719315308942,0.09653888544855455,-0.05616296353478567},
{-0.2783053630612834,0.08040220600306165,-0.010790129990354952},
{-0.27163617569747756,0.07995781741254099,-0.028146963339570966},
{-0.2743738785912847,0.08612029173321513,-0.04547471029183366},
{-0.2077351709706654,0.18706349839917288,0.004999867363799158},
{-0.2164148269463792,0.19014274028472972,0.014750849573439686},
{-0.2175399636343201,0.17491943814722832,0.014234308872538948},
{-0.21226688614524009,0.17586097237634385,0.008539460038119293},
{-0.23085269722205262,0.157342095952256,0.012363943250642561},
{-0.260620697390548,0.14166995613326408,0.02141703782856948},
{-0.26855222446771876,0.14691092333069272,0.02008478913982596},
{-0.24268057458287245,0.16636056445728664,0.016497012438512},
{-0.2223894851844682,0.18024569404675853,0.01759007601383459},
{-0.2742121126179436,0.1531396754745054,0.01590090860661839},
{-0.32037607880928887,0.13615260000321838,0.008844328110148047},
{-0.3165887126648846,0.12827611028815658,0.018016036196911833},
{-0.3403722021514998,0.1216800416895934,0.004284926948869624},
{-0.36556595433146916,0.11071096281606528,0.0004988620706263991},
{-0.33567896886380516,0.11457385196985759,0.014874767291009417},
{-0.30819003103587955,0.12163541445677323,0.025107676521665484},
{-0.3127663610502633,0.07775156401193757,-0.03059897014945618},
{-0.31167630897662785,0.07934899835130177,-0.0370974933579812},
{-0.3066652940993819,0.0745419228640277,-0.030888508066806084},
{-0.2231310953591947,0.1941846216972337,0.019335743158464588},
{-0.2344218720137684,0.20186406253647202,0.016308651063440253},
{-0.24061557672230893,0.19187151575528746,0.02022750705517079},
{-0.2536211247449448,0.17415820983599684,0.015690227418631037},
{-0.2839232760830545,0.16288184625328367,0.005328430872970949},
{-0.26203216220597475,0.18304857178572018,0.007052658108470468},
{-0.24372778401728015,0.1954482007117045,0.01614630261857942},
{-0.28784566408293655,0.16878959462467016,-0.012200231574565335},
{-0.3358860808646078,0.14019221349469882,-0.040036161319106145},
{-0.32804859195534575,0.14515236745456236,-0.018531833317149082},
{-0.3431098182942295,0.13340872538990428,-0.04292995418718977},
{-0.3559031236094848,0.12116813597482831,-0.07032099962076767},
{-0.336551436842294,0.13352521969385023,-0.05337974111136223},
{-0.31858776731360805,0.14539157735400537,-0.04040549783465902},
{0.008151515416462763,-0.016494496657267356,-0.39732549278748136},
{0.0047855364340551815,0.001246049100328852,-0.42047687674507933},
{0.023275921325720553,-0.03266614917996608,-0.41870219756156235},
{0.031186405070114713,-0.02325244276627121,-0.383694432317711},
{0.03835200688486293,-0.03733706265474503,-0.40946818980820954},
{0.04658221792154447,-0.03313464217699461,-0.4340398128330633},
{0.021200091973492312,-0.02124853005721292,-0.43358123424488126},
{0.023342855978445227,0.017391701085827858,-0.43676501117871286},
{0.01621932843623916,0.04627604238684887,-0.42047436096383445},
{-0.005257734941390144,0.027610978004319903,-0.401649364773601},
{-0.0013291876150121778,0.007120323948847452,-0.37490032688487585},
{0.025167082420172418,-0.0005459802986693744,-0.35935701241583284},
{0.05168192957893302,0.021979606172539797,-0.436292825064389},
{0.033046546457888154,-0.010895359047249293,-0.44403845697568856},
{0.051695586677119064,-0.007890053865664983,-0.4437113062697774},
{0.048773289883601856,0.0515504831071454,-0.4199389704931144},
{0.039016656460918814,0.08723608409081826,-0.380766422346096},
{0.012738949568754541,0.08373778492934365,-0.38052914575637803},
{-0.004127851730213963,0.0689251128202407,-0.36559691826959784},
{-0.0007293534867901028,0.049463549617009064,-0.3469652282658483},
{0.020090248261197083,0.04630980094897109,-0.3319902077118845},
{-0.011033349028875266,0.07744473784416157,-0.3210792396672078},
{0.013624231920677332,0.07016979249284792,-0.3059790497015574},
{-0.015148597066843196,0.09682717167178743,-0.3460096899342372},
{0.0051300869274919165,0.11445745681000004,-0.36379368558860303},
{0.035953946852113554,0.11945061335831124,-0.363284332834116},
{0.04319997930862879,0.07313917033537469,-0.3036492503737159},
{0.045922909733254684,0.04575922903970484,-0.3319709241866781},
{0.05652884859675888,0.002527498836745372,-0.35630461379222783},
{0.058532823270872475,-0.020493721325709507,-0.38113280932501703},
{0.05646687114845742,-0.03530090333091367,-0.4080343184287898},
{0.06838524227602338,-0.02499492490705929,-0.4184159437921428},
{0.06641971072221202,-0.013544972418455517,-0.43331233069094305},
{0.07404016082881383,0.013367702788280453,-0.42047068023955025},
{0.07445164597497525,0.041653436869174214,-0.40175843566392316},
{0.059464145658876026,0.08002930030032403,-0.36551186503470623},
{0.06027028624218194,0.11008022051826437,-0.34607166738253864},
{0.06371805909757283,0.09056617291320165,-0.3206622768101587},
{0.06222835720333643,0.0636626809276596,-0.34426579499018856},
{0.07811001326727607,0.020993060527261385,-0.37485573683108886},
{0.07718549464234331,-0.004500577734291344,-0.39720650748831277},
{-0.1449802842995155,0.2715635960282159,0.06116020977674604},
{-0.12920767433987584,0.27420696332184874,0.0696419865448955},
{-0.13002068065130798,0.2795992120052634,0.05613608309380069},
{-0.13946414268455334,0.27591227882247377,0.0452252761582677},
{-0.150248553300305,0.2659036706989578,0.04503317209385642},
{-0.15427504259307495,0.257231053953525,0.055729592331095694},
{-0.1486994269180451,0.25628053479139234,0.06933834538096151},
{-0.13758288360593687,0.26383403785225856,0.07555220112548244},
{-0.3373717798162724,0.0025119951799117603,-0.04775316537486154},
{-0.3412170956803844,0.009045293177465729,-0.03910310390955442},
{-0.3710336268801832,-0.08876667052853561,-0.05274735054309056},
{-0.36712535451989625,-0.08835063714731592,-0.06554384086218773},
{-0.3912984802741775,-0.11477910501900176,-0.06176350155505333},
{-0.3980295707282185,-0.10960384556620308,-0.053327219530498085},
{-0.3824658697559849,-0.08371980267029869,-0.04192515363662282},
{-0.3474728026232484,0.012782046264708777,-0.03932925157534224},
{-0.32042623332504094,0.06932762542639617,-0.023906558282927492},
{-0.3090540098017935,0.06396534304372004,-0.02401551763615012},
{-0.30340117327486077,0.06226937187343297,-0.03501370769265364},
{-0.3401266966024392,0.01164601612004781,-0.05418215139833968},
{-0.3692005394355495,-0.0843917765158898,-0.07816314830218754},
{-0.3835065852525981,-0.10948121672178338,-0.0772620772541767},
{-0.39110870609584514,-0.1136721984503272,-0.07690130430926495},
{-0.415031443454709,-0.1020154561792084,-0.07135429170375714},
{-0.4084443102171187,-0.1048059409071119,-0.057923192467408895},
{-0.3991324247822769,-0.07530938485982169,-0.04730966908113711},
{-0.4077307330334055,-0.06646232409073533,-0.06470602374261733},
{-0.35128711117369305,0.015730727778768678,-0.046481766370413194},
{-0.3255035260254254,0.07473112696385133,-0.03446306142532106},
{-0.30811071576510785,0.07743576530415563,-0.03274167218935385},
{-0.3075043381270471,0.06766304575311922,-0.045494774576736695},
{-0.31887584285565307,0.07302712512239865,-0.04539855523888177},
{-0.3464384943133522,0.015246049509298303,-0.05359994013184217},
{-0.3791285929871879,-0.07575992038382715,-0.08817194232086929},
{-0.3955039494326482,-0.10357924349354998,-0.08831961744063736},
{-0.3965807038054184,-0.06922067374096517,-0.082675617130589},
{-0.4065710942026789,-0.10033500105876597,-0.08389002067718127}
};


// texture array: 90kb.
const tgx::fVec2 manga3_tex_array[11535] PROGMEM = {
{0.335147,0.353299},
{0.3481,0.3578},
{0.329196,0.37088},
{0.313,0.357813},
{0.3304,0.3707},
{0.3309,0.3763},
{0.313,0.3783},
{0.378451,0.327078},
{0.3779,0.3102},
{0.3979,0.2708},
{0.385826,0.321059},
{0.4012,0.273},
{0.4116,0.2693},
{0.4022,0.2598},
{0.391,0.2641},
{0.3679,0.3058},
{0.364499,0.327064},
{0.363673,0.340968},
{0.3758,0.3459},
{0.3818,0.3459},
{0.4159,0.3453},
{0.4159,0.3283},
{0.4159,0.3027},
{0.4159,0.2581},
{0.3845,0.3679},
{0.357,0.362},
{0.4159,0.3681},
{0.364081,0.264913},
{0.334883,0.304195},
{0.3355,0.2645},
{0.3345,0.2618},
{0.3132,0.2574},
{0.313,0.26},
{0.335405,0.326398},
{0.313,0.3268},
{0.335145,0.353321},
{0.3481,0.3578},
{0.357,0.362},
{0.363673,0.340968},
{0.3758,0.3459},
{0.3845,0.3679},
{0.3985,0.3798},
{0.4159,0.3814},
{0.3818,0.3459},
{0.386087,0.319612},
{0.4012,0.273},
{0.4116,0.2693},
{0.4022,0.2598},
{0.3979,0.2708},
{0.391,0.2641},
{0.368811,0.259524},
{0.3744,0.2618},
{0.3694,0.2642},
{0.364081,0.264913},
{0.3534,0.2622},
{0.3345,0.2618},
{0.3355,0.2645},
{0.335333,0.304155},
{0.335351,0.326399},
{0.3985,0.3798},
{0.2503,0.2389},
{0.2392,0.2264},
{0.250449,0.238893},
{0.2392,0.2525},
{0.2716,0.2514},
{0.2816,0.2251},
{0.2714,0.2258},
{0.2708,0.214},
{0.2502,0.2072},
{0.2392,0.2072},
{0.2495,0.1966},
{0.278581,0.206675},
{0.364499,0.327063},
{0.378451,0.327078},
{0.3779,0.3102},
{0.3679,0.3058},
{0.2714,0.2258},
{0.2816,0.2251},
{0.278581,0.206675},
{0.2708,0.214},
{0.2502,0.2072},
{0.2495,0.1966},
{0.2716,0.2514},
{0.3694,0.2642},
{0.368811,0.259524},
{0.3534,0.2622},
{0.3309,0.3763},
{0.3744,0.2618},
{0.2792,0.3579},
{0.292428,0.35346},
{0.2968,0.3704},
{0.2966,0.3764},
{0.313,0.3733},
{0.313,0.357811},
{0.313,0.3268},
{0.291926,0.3262},
{0.263911,0.340972},
{0.2704,0.362},
{0.2364,0.2644},
{0.2499,0.3103},
{0.2295,0.2707},
{0.2251,0.2595},
{0.216,0.2691},
{0.2264,0.2729},
{0.240709,0.313982},
{0.249303,0.327163},
{0.263603,0.327165},
{0.2596,0.306},
{0.2533,0.2615},
{0.258294,0.259155},
{0.2922,0.30427},
{0.263511,0.264915},
{0.2586,0.264},
{0.2739,0.2622},
{0.293,0.2616},
{0.2918,0.2644},
{0.3132,0.2574},
{0.3129,0.2599},
{0.3355,0.2645},
{0.3345,0.2618},
{0.364081,0.264913},
{0.3534,0.2622},
{0.368809,0.259525},
{0.3694,0.2642},
{0.3744,0.2618},
{0.391,0.2641},
{0.4022,0.2598},
{0.3979,0.2708},
{0.4116,0.2693},
{0.4159,0.2581},
{0.4159,0.3027},
{0.4012,0.273},
{0.385844,0.320958},
{0.4159,0.333752},
{0.3818,0.3459},
{0.4159,0.3681},
{0.3845,0.3679},
{0.4159,0.3814},
{0.3985,0.3798},
{0.357,0.362},
{0.3758,0.3459},
{0.363673,0.340968},
{0.3481,0.3578},
{0.3309,0.3763},
{0.3304,0.3707},
{0.313,0.3783},
{0.2518,0.3459},
{0.2433,0.3675},
{0.2297,0.3795},
{0.2092,0.3815},
{0.2092,0.3681},
{0.2092,0.333756},
{0.2458,0.3459},
{0.2092,0.3021},
{0.2092,0.258},
{0.33425,0.304205},
{0.3527,0.3027},
{0.364499,0.327063},
{0.3679,0.3058},
{0.3779,0.3102},
{0.378452,0.327078},
{0.335146,0.353312},
{0.335374,0.326399},
{0.2816,0.2251},
{0.2716,0.2514},
{0.249551,0.238934},
{0.2392,0.2525},
{0.2281,0.2389},
{0.2068,0.2514},
{0.1969,0.2251},
{0.2071,0.2258},
{0.19993,0.206707},
{0.2077,0.214},
{0.2282,0.2072},
{0.229,0.1966},
{0.2392,0.2072},
{0.2392,0.2264},
{0.2502,0.2072},
{0.2495,0.1966},
{0.278581,0.206675},
{0.2708,0.214},
{0.2714,0.2258},
{0.292428,0.353461},
{0.2792,0.3579},
{0.2968,0.3704},
{0.313,0.357811},
{0.313,0.3733},
{0.2966,0.3764},
{0.2704,0.362},
{0.263911,0.340972},
{0.291925,0.3262},
{0.313,0.3268},
{0.335146,0.353312},
{0.3304,0.3707},
{0.3309,0.3763},
{0.313,0.3783},
{0.249303,0.327163},
{0.2499,0.3103},
{0.2295,0.2707},
{0.240709,0.313979},
{0.2264,0.2729},
{0.216,0.2691},
{0.2251,0.2595},
{0.2364,0.2644},
{0.2596,0.306},
{0.263603,0.327163},
{0.2518,0.3459},
{0.2458,0.3459},
{0.2092,0.333755},
{0.2092,0.3021},
{0.2092,0.258},
{0.2433,0.3675},
{0.2092,0.3681},
{0.2092,0.3815},
{0.2297,0.3795},
{0.263511,0.264915},
{0.292199,0.30427},
{0.2918,0.2644},
{0.293,0.2616},
{0.3132,0.2574},
{0.313,0.26},
{0.33425,0.304205},
{0.2586,0.264},
{0.258296,0.259155},
{0.2739,0.2622},
{0.3481,0.3578},
{0.357,0.362},
{0.363673,0.340968},
{0.3758,0.3459},
{0.3845,0.3679},
{0.3985,0.3798},
{0.4159,0.3814},
{0.4159,0.3681},
{0.3818,0.3459},
{0.4159,0.333751},
{0.385843,0.320962},
{0.4159,0.3027},
{0.4012,0.273},
{0.4116,0.2693},
{0.4159,0.2581},
{0.4022,0.2598},
{0.3979,0.2708},
{0.391,0.2641},
{0.36881,0.259524},
{0.3744,0.2618},
{0.3694,0.2642},
{0.364081,0.264913},
{0.3534,0.2622},
{0.3345,0.2618},
{0.3355,0.2645},
{0.3527,0.3027},
{0.335375,0.326399},
{0.364499,0.327064},
{0.378451,0.327078},
{0.3779,0.3102},
{0.3679,0.3058},
{0.2714,0.2258},
{0.249553,0.238934},
{0.2816,0.2251},
{0.278581,0.206675},
{0.2708,0.214},
{0.2502,0.2072},
{0.2495,0.1966},
{0.2392,0.2072},
{0.2392,0.2264},
{0.2282,0.2072},
{0.229,0.1966},
{0.19993,0.206707},
{0.2077,0.214},
{0.2071,0.2258},
{0.1969,0.2251},
{0.2281,0.2389},
{0.2068,0.2514},
{0.2392,0.2525},
{0.2716,0.2514},
{0.2533,0.2615},
{0.5658,0.6913},
{0.5239,0.6596},
{0.572539,0.6596},
{0.5525,0.621},
{0.580874,0.612894},
{0.5121,0.5792},
{0.5075,0.5481},
{0.5525,0.5481},
{0.5877,0.5792},
{0.621,0.6201},
{0.5175,0.621},
{0.6118,0.6575},
{0.6303,0.5795},
{0.6353,0.5481},
{0.5877,0.5481},
{0.5658,0.6913},
{0.572534,0.6596},
{0.5239,0.6596},
{0.5525,0.621},
{0.5175,0.621},
{0.580874,0.612894},
{0.5121,0.5792},
{0.5075,0.5481},
{0.5525,0.5481},
{0.5877,0.5792},
{0.621,0.6201},
{0.6303,0.5795},
{0.6353,0.5481},
{0.5877,0.5481},
{0.6118,0.6575},
{0.4112,0.0682},
{0.4274,0.0826},
{0.4279,0.0482},
{0.4112,0.0682},
{0.4279,0.0482},
{0.4274,0.0826},
{0.4004,0.0957},
{0.4677,0.1336},
{0.4946,0.1334},
{0.4955,0.1649},
{0.4674,0.1636},
{0.4375,0.1653},
{0.4318,0.1376},
{0.495113,0.104599},
{0.41107,0.118512},
{0.4955,0.0794},
{0.4649,0.0815},
{0.4622,0.0466},
{0.4955,0.0412},
{0.4582,0.0223},
{0.4957,0.0018},
{0.4622,0.0466},
{0.4649,0.0815},
{0.4582,0.0223},
{0.41107,0.118512},
{0.4004,0.0957},
{0.4677,0.1336},
{0.4674,0.1636},
{0.4375,0.1653},
{0.4318,0.1376},
{0.5685,0.887331},
{0.6298,0.847027},
{0.6298,0.9068},
{0.6739,0.9068},
{0.6298,0.9455},
{0.522556,0.905913},
{0.5097,0.8258},
{0.5685,0.8258},
{0.5015,0.7701},
{0.5685,0.7701},
{0.6298,0.7701},
{0.6019,0.9906},
{0.6647,0.9455},
{0.5289,0.9455},
{0.692147,0.830234},
{0.7064,0.7701},
{0.5289,0.9455},
{0.522557,0.905916},
{0.5685,0.887333},
{0.5097,0.8258},
{0.6298,0.9068},
{0.6298,0.9455},
{0.6298,0.847023},
{0.5685,0.8258},
{0.5685,0.7701},
{0.5015,0.7701},
{0.67378,0.907302},
{0.6932,0.8258},
{0.6298,0.7701},
{0.7064,0.7701},
{0.6647,0.9455},
{0.6019,0.9906},
{0.7064,0.7701},
{0.2364,0.2644},
{0.2499,0.3103},
{0.2295,0.2707},
{0.2251,0.2595},
{0.216,0.2691},
{0.2264,0.2729},
{0.240647,0.313629},
{0.249303,0.327163},
{0.263603,0.327164},
{0.2596,0.306},
{0.2533,0.2615},
{0.258296,0.259155},
{0.263911,0.340972},
{0.29199,0.3262},
{0.2746,0.3032},
{0.263511,0.264915},
{0.2586,0.264},
{0.2739,0.2622},
{0.293,0.2616},
{0.2918,0.2644},
{0.3132,0.2574},
{0.3129,0.2599},
{0.3355,0.2645},
{0.3345,0.2618},
{0.364081,0.264913},
{0.3534,0.2622},
{0.368809,0.259525},
{0.3694,0.2642},
{0.3744,0.2618},
{0.391,0.2641},
{0.4022,0.2598},
{0.3979,0.2708},
{0.4116,0.2693},
{0.4159,0.2581},
{0.4159,0.3027},
{0.4012,0.273},
{0.385659,0.321981},
{0.4159,0.3283},
{0.4159,0.3453},
{0.3818,0.3459},
{0.4159,0.3681},
{0.3845,0.3679},
{0.4159,0.3814},
{0.3985,0.3798},
{0.357,0.362},
{0.3758,0.3459},
{0.363673,0.340968},
{0.3481,0.3578},
{0.3309,0.3763},
{0.3304,0.3707},
{0.313,0.3733},
{0.313,0.3783},
{0.2966,0.3764},
{0.2968,0.3704},
{0.289621,0.357596},
{0.2704,0.362},
{0.2518,0.3459},
{0.2433,0.3675},
{0.2297,0.3795},
{0.2092,0.3815},
{0.2092,0.3681},
{0.2092,0.3451},
{0.2458,0.3459},
{0.2092,0.3284},
{0.2092,0.3021},
{0.2092,0.258},
{0.2911,0.3421},
{0.313,0.3268},
{0.293137,0.304302},
{0.33524,0.304163},
{0.364499,0.327064},
{0.3679,0.3058},
{0.3779,0.3102},
{0.378451,0.327078},
{0.335151,0.353265},
{0.313,0.357816},
{0.335446,0.326397},
{0.2816,0.2251},
{0.2716,0.2514},
{0.25017,0.238906},
{0.2392,0.2525},
{0.2281,0.2389},
{0.2068,0.2514},
{0.1969,0.2251},
{0.2071,0.2258},
{0.19993,0.206707},
{0.2077,0.214},
{0.2282,0.2072},
{0.229,0.1966},
{0.2392,0.2072},
{0.2392,0.2264},
{0.2502,0.2072},
{0.2495,0.1966},
{0.278581,0.206675},
{0.2708,0.214},
{0.2714,0.2258},
{0.292426,0.353443},
{0.2792,0.3579},
{0.298434,0.370693},
{0.313,0.357817},
{0.3304,0.3707},
{0.3309,0.3763},
{0.313,0.3783},
{0.2966,0.3764},
{0.2704,0.362},
{0.263911,0.340972},
{0.291903,0.326199},
{0.313,0.3268},
{0.335144,0.353327},
{0.3481,0.3578},
{0.357,0.362},
{0.363673,0.340968},
{0.3758,0.3459},
{0.3845,0.3679},
{0.3985,0.3798},
{0.4159,0.3814},
{0.4159,0.3681},
{0.3818,0.3459},
{0.4159,0.33327},
{0.3843,0.3295},
{0.3873,0.3129},
{0.4159,0.3027},
{0.4012,0.273},
{0.4116,0.2693},
{0.4159,0.2581},
{0.4022,0.2598},
{0.3979,0.2708},
{0.391,0.2641},
{0.368811,0.259524},
{0.3744,0.2618},
{0.3694,0.2642},
{0.364081,0.264913},
{0.3534,0.2622},
{0.3345,0.2618},
{0.3355,0.2645},
{0.3132,0.2574},
{0.313,0.26},
{0.2918,0.2644},
{0.293,0.2616},
{0.263511,0.264915},
{0.2739,0.2622},
{0.258295,0.259155},
{0.2586,0.264},
{0.2533,0.2615},
{0.2364,0.2644},
{0.2251,0.2595},
{0.2295,0.2707},
{0.216,0.2691},
{0.2092,0.258},
{0.2092,0.3021},
{0.2264,0.2729},
{0.240722,0.314056},
{0.2092,0.333282},
{0.2458,0.3459},
{0.2433,0.3675},
{0.2092,0.3681},
{0.2092,0.3815},
{0.2297,0.3795},
{0.2518,0.3459},
{0.249303,0.327163},
{0.263603,0.327164},
{0.292222,0.304271},
{0.334565,0.304202},
{0.335362,0.326399},
{0.2499,0.3103},
{0.2596,0.306},
{0.3527,0.3027},
{0.364499,0.327064},
{0.3781,0.3284},
{0.2503,0.2389},
{0.2392,0.2264},
{0.22811,0.2389},
{0.2392,0.2525},
{0.2068,0.2514},
{0.1969,0.2251},
{0.2071,0.2258},
{0.2077,0.214},
{0.2282,0.2072},
{0.2392,0.2072},
{0.2502,0.2072},
{0.2708,0.214},
{0.2714,0.2258},
{0.2816,0.2251},
{0.2716,0.2514},
{0.3679,0.3058},
{0.3779,0.3102},
{0.3827,0.3111},
{0.278581,0.206675},
{0.2495,0.1966},
{0.19993,0.206707},
{0.229,0.1966},
{0.9631,0.673},
{0.947168,0.684287},
{0.941,0.6809},
{0.9621,0.6802},
{0.9775,0.6903},
{0.9797,0.7023},
{0.954992,0.723366},
{0.976715,0.721726},
{0.9665,0.7228},
{0.9592,0.7271},
{0.9551,0.7392},
{0.941157,0.757222},
{0.9481,0.7595},
{0.9376,0.7715},
{0.9199,0.7794},
{0.915316,0.772392},
{0.9039,0.7831},
{0.8824,0.7875},
{0.861888,0.780213},
{0.8631,0.7886},
{0.843,0.789},
{0.835497,0.7816},
{0.8181,0.7892},
{0.763257,0.78328},
{0.764612,0.77691},
{0.7186,0.7688},
{0.7205,0.7631},
{0.686878,0.750904},
{0.6941,0.7494},
{0.6753,0.7354},
{0.650496,0.724262},
{0.655353,0.72132},
{0.6289,0.7139},
{0.617994,0.705995},
{0.6153,0.7104},
{0.6,0.7145},
{0.5997,0.7108},
{0.587071,0.708132},
{0.589438,0.704025},
{0.584987,0.685512},
{0.589768,0.686868},
{0.599405,0.678754},
{0.609765,0.684434},
{0.608816,0.678907},
{0.631747,0.681195},
{0.6507,0.6835},
{0.633564,0.665522},
{0.64458,0.663667},
{0.660225,0.684825},
{0.67243,0.701998},
{0.687468,0.701202},
{0.6927,0.7119},
{0.7205,0.7331},
{0.6978,0.6944},
{0.740077,0.72038},
{0.7449,0.7446},
{0.7802,0.7275},
{0.7808,0.7505},
{0.814007,0.728551},
{0.8143,0.7211},
{0.779,0.7205},
{0.7444,0.7136},
{0.696416,0.683597},
{0.947168,0.684287},
{0.9621,0.6802},
{0.9631,0.673},
{0.941,0.6809},
{0.249303,0.327163},
{0.2499,0.3103},
{0.2295,0.2707},
{0.240644,0.313617},
{0.2264,0.2729},
{0.216,0.2691},
{0.2251,0.2595},
{0.2364,0.2644},
{0.2596,0.306},
{0.263603,0.327164},
{0.263911,0.340972},
{0.2518,0.3459},
{0.2458,0.3459},
{0.2092,0.3284},
{0.2092,0.3021},
{0.2092,0.258},
{0.2433,0.3675},
{0.2704,0.362},
{0.2092,0.3451},
{0.263511,0.264915},
{0.2746,0.3032},
{0.2918,0.2644},
{0.293,0.2616},
{0.3132,0.2574},
{0.313,0.26},
{0.293067,0.304302},
{0.291746,0.330252},
{0.257532,0.263496},
{0.259456,0.259712},
{0.2739,0.2622},
{0.2297,0.3795},
{0.2092,0.3815},
{0.2092,0.3681},
{0.3481,0.3578},
{0.33515,0.353277},
{0.3304,0.3707},
{0.3309,0.3763},
{0.313,0.3733},
{0.313,0.357824},
{0.313,0.3268},
{0.335428,0.326398},
{0.363673,0.340968},
{0.357,0.362},
{0.364081,0.264913},
{0.3355,0.2645},
{0.335249,0.304162},
{0.364499,0.327063},
{0.3345,0.2618},
{0.3534,0.2622},
{0.36881,0.259525},
{0.3694,0.2642},
{0.3679,0.3058},
{0.3779,0.3102},
{0.378451,0.327079},
{0.391,0.2641},
{0.3979,0.2708},
{0.4022,0.2598},
{0.4116,0.2693},
{0.4012,0.273},
{0.385712,0.321689},
{0.3758,0.3459},
{0.3845,0.3679},
{0.3985,0.3798},
{0.4159,0.3814},
{0.4159,0.3681},
{0.3818,0.3459},
{0.4159,0.3453},
{0.4159,0.3283},
{0.4159,0.3027},
{0.4159,0.2581},
{0.313,0.3783},
{0.2966,0.3764},
{0.2968,0.3704},
{0.289891,0.357588},
{0.3744,0.2618},
{0.2714,0.2258},
{0.250221,0.238904},
{0.2816,0.2251},
{0.278581,0.206675},
{0.2708,0.214},
{0.2502,0.2072},
{0.2495,0.1966},
{0.2392,0.2072},
{0.2392,0.2264},
{0.2282,0.2072},
{0.229,0.1966},
{0.199628,0.20658},
{0.2077,0.214},
{0.2071,0.2258},
{0.1969,0.2251},
{0.2281,0.2389},
{0.2068,0.2514},
{0.2392,0.2525},
{0.2716,0.2514},
{0.2792,0.3579},
{0.292425,0.353438},
{0.2968,0.3704},
{0.2966,0.3764},
{0.313,0.3733},
{0.313,0.357818},
{0.313,0.3268},
{0.291893,0.326199},
{0.263911,0.340972},
{0.2704,0.362},
{0.2364,0.2644},
{0.2499,0.3103},
{0.2295,0.2707},
{0.2251,0.2595},
{0.216,0.2691},
{0.2264,0.2729},
{0.240773,0.314345},
{0.249303,0.327163},
{0.263603,0.327164},
{0.2596,0.306},
{0.2533,0.2615},
{0.258293,0.259154},
{0.292231,0.304271},
{0.263511,0.264915},
{0.2586,0.264},
{0.2739,0.2622},
{0.293,0.2616},
{0.2918,0.2644},
{0.3132,0.2574},
{0.3129,0.2599},
{0.3355,0.2645},
{0.3345,0.2618},
{0.364081,0.264913},
{0.3534,0.2622},
{0.36881,0.259524},
{0.3694,0.2642},
{0.3744,0.2618},
{0.391,0.2641},
{0.4022,0.2598},
{0.3979,0.2708},
{0.4116,0.2693},
{0.4159,0.2581},
{0.4159,0.3027},
{0.4012,0.273},
{0.386049,0.319825},
{0.4159,0.332986},
{0.3818,0.3459},
{0.4159,0.3681},
{0.3845,0.3679},
{0.4159,0.3814},
{0.3985,0.3798},
{0.357,0.362},
{0.3758,0.3459},
{0.363673,0.340968},
{0.3481,0.3578},
{0.3309,0.3763},
{0.3304,0.3707},
{0.313,0.3783},
{0.2518,0.3459},
{0.2433,0.3675},
{0.2297,0.3795},
{0.2092,0.3815},
{0.2092,0.3681},
{0.2092,0.333003},
{0.2458,0.3459},
{0.2092,0.3021},
{0.2092,0.258},
{0.334362,0.304204},
{0.3527,0.3027},
{0.364499,0.327063},
{0.3679,0.3058},
{0.3779,0.3102},
{0.378452,0.327078},
{0.2392,0.2264},
{0.2503,0.2389},
{0.228277,0.238908},
{0.2071,0.2258},
{0.1969,0.2251},
{0.2068,0.2514},
{0.2392,0.2525},
{0.2716,0.2514},
{0.2816,0.2251},
{0.2714,0.2258},
{0.2708,0.214},
{0.2502,0.2072},
{0.2392,0.2072},
{0.2282,0.2072},
{0.2077,0.214},
{0.19993,0.206708},
{0.335144,0.353327},
{0.33535,0.326399},
{0.278581,0.206675},
{0.2495,0.1966},
{0.229,0.1966},
{0.9836,0.6846},
{0.9865,0.7024},
{0.9775,0.6903},
{0.9836,0.6846},
{0.976715,0.721726},
{0.9865,0.7024},
{0.9797,0.7023},
{0.954993,0.723366},
{0.3988,0.2144},
{0.4194,0.2253},
{0.4379,0.2018},
{0.393345,0.172528},
{0.440531,0.175876},
{0.4158,0.189},
{0.3988,0.2144},
{0.4014,0.2459},
{0.3838,0.2329},
{0.383218,0.246777},
{0.367095,0.1942},
{0.338808,0.225314},
{0.3647,0.1527},
{0.4082,0.1436},
{0.316951,0.19191},
{0.3041,0.173},
{0.3179,0.1571},
{0.3412,0.1367},
{0.3871,0.1344},
{0.3122,0.2085},
{0.3266,0.1921},
{0.342,0.1755},
{0.3647,0.1527},
{0.3884,0.1689},
{0.368,0.1261},
{0.3988,0.2144},
{0.425667,0.17949},
{0.4379,0.2018},
{0.4194,0.2253},
{0.4014,0.2459},
{0.383906,0.245635},
{0.3838,0.2329},
{0.372391,0.197649},
{0.4158,0.189},
{0.4082,0.1436},
{0.38501,0.166583},
{0.367095,0.1942},
{0.338807,0.225315},
{0.3524,0.2107},
{0.3266,0.1921},
{0.342,0.1755},
{0.3884,0.1689},
{0.3647,0.1527},
{0.3871,0.1344},
{0.3412,0.1367},
{0.368,0.1261},
{0.316949,0.19191},
{0.3041,0.173},
{0.3122,0.2085},
{0.3179,0.1571},
{0.2792,0.3579},
{0.292428,0.35346},
{0.2968,0.3704},
{0.2966,0.3764},
{0.313,0.3733},
{0.313,0.357811},
{0.313,0.3268},
{0.291925,0.3262},
{0.263911,0.340972},
{0.2704,0.362},
{0.2364,0.2644},
{0.2499,0.3103},
{0.2295,0.2707},
{0.2251,0.2595},
{0.216,0.2691},
{0.2264,0.2729},
{0.240709,0.31398},
{0.249303,0.327162},
{0.263603,0.327164},
{0.2596,0.306},
{0.2533,0.2615},
{0.258294,0.259155},
{0.2746,0.3032},
{0.263511,0.264915},
{0.2586,0.264},
{0.2739,0.2622},
{0.293,0.2616},
{0.2918,0.2644},
{0.3132,0.2574},
{0.3129,0.2599},
{0.3355,0.2645},
{0.3345,0.2618},
{0.364081,0.264913},
{0.3534,0.2622},
{0.368811,0.259524},
{0.3694,0.2642},
{0.3744,0.2618},
{0.391,0.2641},
{0.4022,0.2598},
{0.3979,0.2708},
{0.4116,0.2693},
{0.4159,0.2581},
{0.4159,0.3027},
{0.4012,0.273},
{0.385843,0.32096},
{0.4159,0.333751},
{0.3818,0.3459},
{0.4159,0.3681},
{0.3845,0.3679},
{0.4159,0.3814},
{0.3985,0.3798},
{0.357,0.362},
{0.3758,0.3459},
{0.363673,0.340968},
{0.3481,0.3578},
{0.3309,0.3763},
{0.3304,0.3707},
{0.313,0.3783},
{0.2518,0.3459},
{0.2433,0.3675},
{0.2297,0.3795},
{0.2092,0.3815},
{0.2092,0.3681},
{0.2092,0.333755},
{0.2458,0.3459},
{0.2092,0.3021},
{0.2092,0.258},
{0.293207,0.304303},
{0.335295,0.304159},
{0.364499,0.327063},
{0.3679,0.3058},
{0.3779,0.3102},
{0.378451,0.327078},
{0.335375,0.326399},
{0.2392,0.2264},
{0.2503,0.2389},
{0.228847,0.238934},
{0.2071,0.2258},
{0.1969,0.2251},
{0.2068,0.2514},
{0.2392,0.2525},
{0.2716,0.2514},
{0.2816,0.2251},
{0.2714,0.2258},
{0.2708,0.214},
{0.2502,0.2072},
{0.2392,0.2072},
{0.2282,0.2072},
{0.2077,0.214},
{0.19993,0.206708},
{0.335146,0.353312},
{0.278581,0.206675},
{0.2495,0.1966},
{0.229,0.1966},
{0.292428,0.353461},
{0.2792,0.3579},
{0.2968,0.3704},
{0.313,0.357812},
{0.313,0.3733},
{0.2966,0.3764},
{0.2704,0.362},
{0.263911,0.340972},
{0.291925,0.3262},
{0.313,0.3268},
{0.335146,0.353311},
{0.3304,0.3707},
{0.3309,0.3763},
{0.313,0.3783},
{0.2445,0.311},
{0.2499,0.3103},
{0.2295,0.2707},
{0.2405,0.3128},
{0.2264,0.2729},
{0.216,0.2691},
{0.2251,0.2595},
{0.2364,0.2644},
{0.2596,0.306},
{0.263603,0.327164},
{0.2497,0.3285},
{0.2518,0.3459},
{0.2433,0.3675},
{0.2297,0.3795},
{0.2092,0.3815},
{0.2092,0.3681},
{0.2092,0.333755},
{0.2458,0.3459},
{0.2434,0.3292},
{0.2092,0.3021},
{0.2092,0.258},
{0.2922,0.30427},
{0.33425,0.304205},
{0.335375,0.326399},
{0.363673,0.340968},
{0.3481,0.3578},
{0.357,0.362},
{0.3758,0.3459},
{0.3845,0.3679},
{0.3985,0.3798},
{0.4159,0.3814},
{0.4159,0.3681},
{0.3818,0.3459},
{0.4159,0.333752},
{0.385843,0.320961},
{0.4159,0.3027},
{0.4012,0.273},
{0.4116,0.2693},
{0.4159,0.2581},
{0.4022,0.2598},
{0.3979,0.2708},
{0.391,0.2641},
{0.368812,0.259523},
{0.3744,0.2618},
{0.3694,0.2642},
{0.364081,0.264913},
{0.3534,0.2622},
{0.3345,0.2618},
{0.3355,0.2645},
{0.3132,0.2574},
{0.313,0.26},
{0.2918,0.2644},
{0.293,0.2616},
{0.263511,0.264915},
{0.2739,0.2622},
{0.258295,0.259155},
{0.2586,0.264},
{0.2533,0.2615},
{0.3527,0.3027},
{0.364499,0.327064},
{0.378451,0.327079},
{0.3679,0.3058},
{0.3779,0.3102},
{0.2714,0.2258},
{0.249552,0.238934},
{0.2816,0.2251},
{0.278581,0.206675},
{0.2708,0.214},
{0.2502,0.2072},
{0.2495,0.1966},
{0.2392,0.2072},
{0.2392,0.2264},
{0.2282,0.2072},
{0.229,0.1966},
{0.19993,0.206707},
{0.2077,0.214},
{0.2071,0.2258},
{0.1969,0.2251},
{0.2281,0.2389},
{0.2068,0.2514},
{0.2392,0.2525},
{0.2716,0.2514},
{0.292428,0.353462},
{0.2792,0.3579},
{0.2968,0.3704},
{0.313,0.357816},
{0.328952,0.370916},
{0.2966,0.3764},
{0.2704,0.362},
{0.263911,0.340972},
{0.291905,0.326199},
{0.313,0.3268},
{0.335147,0.353305},
{0.3481,0.3578},
{0.3309,0.3763},
{0.313,0.3783},
{0.249303,0.327163},
{0.2499,0.3103},
{0.2295,0.2707},
{0.240678,0.313809},
{0.2264,0.2729},
{0.216,0.2691},
{0.2251,0.2595},
{0.2364,0.2644},
{0.2596,0.306},
{0.263603,0.327164},
{0.2518,0.3459},
{0.2458,0.3459},
{0.2092,0.333749},
{0.2092,0.3021},
{0.2092,0.258},
{0.2433,0.3675},
{0.2092,0.3681},
{0.2092,0.3815},
{0.2297,0.3795},
{0.263511,0.264915},
{0.292206,0.30427},
{0.2918,0.2644},
{0.293,0.2616},
{0.3132,0.2574},
{0.313,0.26},
{0.334632,0.304202},
{0.2586,0.264},
{0.258295,0.259155},
{0.2739,0.2622},
{0.2503,0.2389},
{0.2392,0.2264},
{0.228047,0.238898},
{0.2392,0.2525},
{0.2068,0.2514},
{0.1969,0.2251},
{0.2071,0.2258},
{0.2077,0.214},
{0.2282,0.2072},
{0.2392,0.2072},
{0.2502,0.2072},
{0.2708,0.214},
{0.2714,0.2258},
{0.2816,0.2251},
{0.2716,0.2514},
{0.363673,0.340968},
{0.357,0.362},
{0.3527,0.3027},
{0.3355,0.2645},
{0.3345,0.2618},
{0.364081,0.264913},
{0.364499,0.327063},
{0.335366,0.326399},
{0.378451,0.327078},
{0.3758,0.3459},
{0.3845,0.3679},
{0.3985,0.3798},
{0.4159,0.3814},
{0.4159,0.3681},
{0.3818,0.3459},
{0.4159,0.333745},
{0.385973,0.320245},
{0.4159,0.3027},
{0.4012,0.273},
{0.4116,0.2693},
{0.4159,0.2581},
{0.4022,0.2598},
{0.3979,0.2708},
{0.391,0.2641},
{0.368811,0.259524},
{0.3744,0.2618},
{0.3694,0.2642},
{0.3534,0.2622},
{0.3779,0.3102},
{0.3679,0.3058},
{0.278581,0.206675},
{0.2495,0.1966},
{0.2533,0.2615},
{0.19993,0.206707},
{0.229,0.1966},
{0.2792,0.3579},
{0.292428,0.35346},
{0.2968,0.3704},
{0.2966,0.3764},
{0.313,0.3733},
{0.313,0.357812},
{0.313,0.3268},
{0.291936,0.3262},
{0.263911,0.340971},
{0.2704,0.362},
{0.2364,0.2644},
{0.2499,0.3103},
{0.2295,0.2707},
{0.2251,0.2595},
{0.216,0.2691},
{0.2264,0.2729},
{0.240677,0.313801},
{0.249303,0.327163},
{0.263603,0.327164},
{0.2596,0.306},
{0.2533,0.2615},
{0.258294,0.259155},
{0.2746,0.3032},
{0.263511,0.264915},
{0.2586,0.264},
{0.2739,0.2622},
{0.293,0.2616},
{0.2918,0.2644},
{0.3132,0.2574},
{0.3129,0.2599},
{0.3355,0.2645},
{0.3345,0.2618},
{0.364081,0.264913},
{0.3534,0.2622},
{0.368812,0.259524},
{0.3694,0.2642},
{0.3744,0.2618},
{0.391,0.2641},
{0.4022,0.2598},
{0.3979,0.2708},
{0.4116,0.2693},
{0.4159,0.2581},
{0.4159,0.3027},
{0.4012,0.273},
{0.385811,0.321136},
{0.4159,0.3283},
{0.4159,0.3453},
{0.3818,0.3459},
{0.4159,0.3681},
{0.3845,0.3679},
{0.4159,0.3814},
{0.3985,0.3798},
{0.357,0.362},
{0.3758,0.3459},
{0.363673,0.340968},
{0.3481,0.3578},
{0.3309,0.3763},
{0.3304,0.3707},
{0.313,0.3783},
{0.2518,0.3459},
{0.2433,0.3675},
{0.2297,0.3795},
{0.2092,0.3815},
{0.2092,0.3681},
{0.2092,0.3451},
{0.2458,0.3459},
{0.2092,0.3284},
{0.2092,0.3021},
{0.2092,0.258},
{0.293198,0.304302},
{0.335283,0.304159},
{0.364499,0.327064},
{0.3679,0.3058},
{0.3779,0.3102},
{0.378451,0.327078},
{0.335387,0.326398},
{0.335146,0.353309},
{0.2816,0.2251},
{0.2716,0.2514},
{0.249809,0.238922},
{0.2392,0.2525},
{0.2281,0.2389},
{0.2068,0.2514},
{0.1969,0.2251},
{0.2071,0.2258},
{0.19993,0.206708},
{0.2077,0.214},
{0.2282,0.2072},
{0.229,0.1966},
{0.2392,0.2072},
{0.2392,0.2264},
{0.2502,0.2072},
{0.2495,0.1966},
{0.278581,0.206675},
{0.2708,0.214},
{0.2714,0.2258},
{0.011368,0.049846},
{0.055853,0.050282},
{0.041322,0.018681},
{0.032168,0.003385},
{0.058315,0.052523},
{0.0574,0.0048},
{0.0824,0.0466},
{0.073282,0.076109},
{0.008161,0.047382},
{0.008202,0.107328},
{0.081135,0.085496},
{0.0824,0.0466},
{0.0574,0.0048},
{0.036217,0.1163},
{0.0053,0.1162},
{0.0817,0.1162},
{0.0563,0.1163},
{0.0317,0.1163},
{0.0817,0.1162},
{0.7971,0.6888},
{0.81147,0.63317},
{0.7934,0.6317},
{0.7839,0.6759},
{0.8175,0.7026},
{0.830218,0.629994},
{0.8462,0.7069},
{0.849395,0.630174},
{0.8673,0.7052},
{0.8663,0.6631},
{0.8878,0.7024},
{0.8896,0.6662},
{0.7971,0.6888},
{0.7934,0.6317},
{0.811432,0.633335},
{0.8175,0.7026},
{0.8878,0.7024},
{0.8663,0.6631},
{0.8896,0.6662},
{0.927896,0.4124},
{0.9606,0.4124},
{0.962202,0.392304},
{0.9251,0.3923},
{0.944051,0.358888},
{0.9441,0.4246},
{0.927896,0.4124},
{0.9251,0.3923},
{0.9622,0.3923},
{0.9606,0.4124},
{0.9441,0.4246},
{0.944057,0.358879},
{0.9858,0.4427},
{0.9611,0.4299},
{0.9677,0.4266},
{0.9846,0.4351},
{0.9858,0.4427},
{0.9846,0.4351},
{0.9677,0.4266},
{0.9611,0.4299},
{0.927899,0.4124},
{0.9606,0.4124},
{0.9622,0.3923},
{0.9251,0.3923},
{0.944057,0.358879},
{0.9441,0.4246},
{0.944057,0.358879},
{0.9622,0.3923},
{0.9251,0.3923},
{0.927899,0.4124},
{0.9606,0.4124},
{0.9441,0.4246},
{0.8873,0.7285},
{0.8826,0.7348},
{0.8826,0.7214},
{0.8874,0.7154},
{0.8873,0.7285},
{0.8874,0.7154},
{0.8826,0.7214},
{0.8826,0.7348},
{0.969889,0.405018},
{0.974792,0.399078},
{0.9695,0.3773},
{0.96909,0.361858},
{0.9637,0.3569},
{0.969885,0.405045},
{0.974792,0.399081},
{0.9695,0.3773},
{0.96909,0.361858},
{0.9637,0.3569},
{0.982744,0.356831},
{0.990569,0.406849},
{0.990569,0.406849},
{0.9927,0.4178},
{0.991576,0.373517},
{0.982744,0.356831},
{0.984,0.3498},
{0.9927,0.4178},
{0.991576,0.373517},
{0.984,0.3498},
{0.9251,0.3923},
{0.9279,0.4124},
{0.960599,0.4124},
{0.9441,0.4246},
{0.9622,0.3923},
{0.944057,0.358879},
{0.9622,0.3923},
{0.960599,0.4124},
{0.9251,0.3923},
{0.9279,0.4124},
{0.9441,0.4246},
{0.944057,0.358879},
{0.90473,0.732243},
{0.841862,0.745997},
{0.848865,0.725214},
{0.8378,0.7196},
{0.929805,0.721132},
{0.9229,0.7199},
{0.9118,0.7251},
{0.8976,0.7288},
{0.932457,0.706476},
{0.9408,0.6927},
{0.9408,0.6927},
{0.932464,0.706465},
{0.929804,0.721133},
{0.9229,0.7199},
{0.904726,0.732244},
{0.9118,0.7251},
{0.8976,0.7288},
{0.669836,0.70033},
{0.6927,0.7119},
{0.687538,0.701226},
{0.660221,0.684821},
{0.6507,0.6835},
{0.64458,0.663667},
{0.633564,0.665521},
{0.631747,0.681195},
{0.617994,0.705995},
{0.609767,0.684435},
{0.608819,0.678908},
{0.599405,0.678754},
{0.589767,0.68687},
{0.584987,0.685512},
{0.589438,0.704024},
{0.58707,0.708131},
{0.5997,0.7108},
{0.6,0.7145},
{0.6153,0.7104},
{0.6289,0.7139},
{0.648745,0.718325},
{0.650493,0.724261},
{0.6753,0.7354},
{0.684907,0.749393},
{0.6941,0.7494},
{0.7205,0.7631},
{0.7186,0.7688},
{0.763257,0.776749},
{0.761022,0.78296},
{0.835591,0.7816},
{0.8181,0.7892},
{0.843,0.789},
{0.861442,0.780222},
{0.8631,0.7886},
{0.8824,0.7875},
{0.915316,0.772392},
{0.9039,0.7831},
{0.9199,0.7794},
{0.941157,0.757222},
{0.9376,0.7715},
{0.9481,0.7595},
{0.9551,0.7392},
{0.9592,0.7271},
{0.9665,0.7228},
{0.721798,0.712538},
{0.7449,0.7446},
{0.7808,0.7505},
{0.814007,0.728552},
{0.843633,0.745419},
{0.7443,0.7222},
{0.7444,0.7136},
{0.779,0.7205},
{0.7802,0.7275},
{0.8143,0.7211},
{0.852727,0.724827},
{0.6978,0.6944},
{0.697057,0.684066},
{0.8378,0.7196},
{0.8583,0.7183},
{0.8583,0.7183},
{0.744293,0.721944},
{0.7205,0.7331},
{0.7205,0.7631},
{0.763978,0.776835},
{0.7802,0.727516},
{0.815,0.7503},
{0.8181,0.7816},
{0.65687,0.68972},
{0.6337,0.6849},
{0.6303,0.7092},
{0.652531,0.720041},
{0.689422,0.71045},
{0.689499,0.745973},
{0.609198,0.68419},
{0.6149,0.7052},
{0.589252,0.68758},
{0.5997,0.7108},
{0.5999,0.6802},
{0.6361,0.6695},
{0.6424,0.6676},
{0.814,0.7284},
{0.698562,0.694975},
{0.590763,0.705773},
{0.744294,0.72197},
{0.761829,0.776581},
{0.7205,0.7631},
{0.7205,0.7331},
{0.687617,0.744572},
{0.68952,0.710494},
{0.652529,0.72004},
{0.656865,0.689715},
{0.6303,0.7092},
{0.6337,0.6849},
{0.609201,0.684191},
{0.6149,0.7052},
{0.5997,0.7108},
{0.589252,0.68758},
{0.590762,0.705772},
{0.5999,0.6802},
{0.6361,0.6695},
{0.6424,0.6676},
{0.699161,0.695426},
{0.780201,0.727526},
{0.815,0.7503},
{0.814,0.7284},
{0.8181,0.7816},
{0.7971,0.3531},
{0.7971,0.3488},
{0.783764,0.348089},
{0.7971,0.3488},
{0.795403,0.352926},
{0.8141,0.3501},
{0.8141,0.3544},
{0.8141,0.3544},
{0.8141,0.3501},
{0.783803,0.352387},
{0.8279,0.3531},
{0.8279,0.3488},
{0.904732,0.33562},
{0.905233,0.335663},
{0.909324,0.340274},
{0.9088,0.3402},
{0.8279,0.353071},
{0.890879,0.335868},
{0.9013,0.3395},
{0.9013,0.3395},
{0.8926,0.3354},
{0.8556,0.3459},
{0.8742,0.3447},
{0.8391,0.3492},
{0.8556,0.3501},
{0.8556,0.3501},
{0.855591,0.345903},
{0.8391,0.3492},
{0.8391,0.3534},
{0.8391,0.3534},
{0.8926,0.3397},
{0.8742,0.3447},
{0.8926,0.3397},
{0.9095,0.0081},
{0.9047,0.0146},
{0.912,0.0238},
{0.9041,0.0321},
{0.898481,0.025364},
{0.8921,0.0036},
{0.8882,0.021},
{0.8863,0.003},
{0.8805,0.02},
{0.8705,0.0079},
{0.871,0.0208},
{0.8605,0.011},
{0.86,0.0001},
{0.8703,-0.0007},
{0.8432,0.0133},
{0.8513,0.0123},
{0.8416,0.0011},
{0.8264,0.0035},
{0.8276,0.0143},
{0.8441,0.0247},
{0.8303,0.0258},
{0.845132,0.037778},
{0.8319,0.0326},
{0.8347,0.048},
{0.842359,0.067338},
{0.826752,0.079237},
{0.8275,0.1152},
{0.813289,0.11902},
{0.82635,0.144542},
{0.814499,0.160049},
{0.825681,0.164046},
{0.8149,0.1698},
{0.814774,0.179166},
{0.825,0.1747},
{0.822969,0.188279},
{0.813761,0.194477},
{0.8184,0.2072},
{0.80917,0.227503},
{0.798546,0.221956},
{0.7885,0.2465},
{0.7996,0.2507},
{0.783918,0.263505},
{0.808,0.2724},
{0.7939,0.2844},
{0.78,0.2792},
{0.7957,0.2986},
{0.7846,0.2997},
{0.778,0.2919},
{0.778571,0.296975},
{0.782,0.3121},
{0.7883,0.3137},
{0.7826,0.3292},
{0.789081,0.327798},
{0.789011,0.337481},
{0.785153,0.337597},
{0.788957,0.327831},
{0.7883,0.3137},
{0.7846,0.2997},
{0.778,0.2919},
{0.78,0.2792},
{0.7957,0.2986},
{0.7939,0.2844},
{0.783902,0.263498},
{0.808,0.2724},
{0.7996,0.2507},
{0.7885,0.2465},
{0.809061,0.227785},
{0.798547,0.221954},
{0.812701,0.196598},
{0.8184,0.2072},
{0.822845,0.188862},
{0.8142,0.1835},
{0.815094,0.176486},
{0.825576,0.164887},
{0.814563,0.160997},
{0.826367,0.147331},
{0.813225,0.120018},
{0.8275,0.1152},
{0.827078,0.078359},
{0.842378,0.067284},
{0.8347,0.048},
{0.8452,0.0477},
{0.8319,0.0326},
{0.844883,0.031196},
{0.8303,0.0258},
{0.8276,0.0143},
{0.8432,0.0133},
{0.8264,0.0035},
{0.8416,0.0011},
{0.8513,0.0123},
{0.8504,0.0003},
{0.8605,0.011},
{0.86,0.0001},
{0.8705,0.0079},
{0.8703,-0.0007},
{0.8504,0.0003},
{0.851723,0.025003},
{0.8534,0.0481},
{0.847032,0.066661},
{0.8375,0.1163},
{0.8355,0.1366},
{0.835233,0.153428},
{0.8343,0.164},
{0.8343,0.1754},
{0.8346,0.1815},
{0.833013,0.197028},
{0.825008,0.239945},
{0.8123,0.2368},
{0.8098,0.2547},
{0.821601,0.274812},
{0.8204,0.2917},
{0.8074,0.2884},
{0.8072,0.2976},
{0.8062,0.3104},
{0.7967,0.3119},
{0.862224,0.023281},
{0.8855,0.0299},
{0.871971,0.030242},
{0.8808,0.048},
{0.8881,0.0495},
{0.872,0.0482},
{0.863,0.0487},
{0.86226,0.068945},
{0.85371,0.067802},
{0.8499,0.1207},
{0.8476,0.1394},
{0.8459,0.1522},
{0.8462,0.1592},
{0.846774,0.172497},
{0.846404,0.185099},
{0.844246,0.218828},
{0.8407,0.2426},
{0.83788,0.268751},
{0.9014,0.0378},
{0.8955,0.0516},
{0.896319,0.082893},
{0.887527,0.07727},
{0.8794,0.0654},
{0.871201,0.065776},
{0.8718,0.1223},
{0.8597,0.1243},
{0.8587,0.1417},
{0.857,0.1544},
{0.856657,0.169557},
{0.8574,0.1799},
{0.8589,0.1905},
{0.857593,0.205775},
{0.853127,0.239733},
{0.85143,0.271725},
{0.836588,0.297703},
{0.894029,0.138535},
{0.906168,0.121922},
{0.881594,0.099927},
{0.8716,0.1403},
{0.9088,0.2884},
{0.9096,0.2709},
{0.8927,0.312304},
{0.9058,0.3102},
{0.8926,0.325},
{0.8725,0.3257},
{0.8714,0.3183},
{0.8618,0.2955},
{0.893023,0.270109},
{0.908185,0.255852},
{0.924934,0.270275},
{0.9295,0.2866},
{0.9191,0.2946},
{0.9095,0.3204},
{0.908042,0.325436},
{0.8742,0.33},
{0.8541,0.3302},
{0.853,0.3215},
{0.8521,0.303949},
{0.8635,0.275},
{0.865238,0.24958},
{0.890584,0.238745},
{0.9045,0.2296},
{0.914407,0.233107},
{0.9375,0.253},
{0.9399,0.271},
{0.9434,0.2868},
{0.93931,0.293707},
{0.9232,0.2966},
{0.923567,0.296872},
{0.910615,0.319675},
{0.9088,0.3255},
{0.9013,0.3248},
{0.8926,0.325},
{0.8742,0.33},
{0.854437,0.331367},
{0.8391,0.3387},
{0.8279,0.3383},
{0.8141,0.3397},
{0.7971,0.3384},
{0.8141,0.3397},
{0.8279,0.3383},
{0.8391,0.3387},
{0.8556,0.3354},
{0.8676,0.2316},
{0.887448,0.212084},
{0.9039,0.2149},
{0.929271,0.226675},
{0.9095,0.0081},
{0.9186,0.0153},
{0.912,0.0238},
{0.9047,0.0146},
{0.9041,0.0321},
{0.898493,0.025344},
{0.9014,0.0378},
{0.8881,0.0495},
{0.8955,0.0516},
{0.896189,0.082},
{0.8869,0.0665},
{0.888066,0.085902},
{0.906324,0.122818},
{0.894511,0.152626},
{0.909228,0.15907},
{0.892878,0.168171},
{0.912226,0.174374},
{0.895808,0.183749},
{0.9137,0.1828},
{0.8997,0.1938},
{0.919473,0.19767},
{0.9028,0.2041},
{0.9039,0.2149},
{0.92927,0.226673},
{0.914405,0.233101},
{0.9375,0.253},
{0.924952,0.270367},
{0.9399,0.271},
{0.9434,0.2868},
{0.9295,0.2866},
{0.938889,0.29375},
{0.9504,0.2966},
{0.9498,0.2991},
{0.85207,0.028133},
{0.862222,0.023184},
{0.871,0.0208},
{0.8805,0.02},
{0.8863,0.003},
{0.88666,0.026076},
{0.8921,0.0036},
{0.8808,0.048},
{0.8794,0.0654},
{0.881741,0.101336},
{0.8842,0.1401},
{0.8842,0.1562},
{0.8842,0.1677},
{0.88514,0.180941},
{0.886222,0.194303},
{0.8871,0.2093},
{0.888437,0.219998},
{0.9045,0.2296},
{0.907939,0.253084},
{0.9096,0.2709},
{0.9088,0.2884},
{0.9191,0.2946},
{0.9058,0.3102},
{0.863,0.0487},
{0.87189,0.030249},
{0.872,0.0482},
{0.871201,0.065728},
{0.8718,0.1223},
{0.8716,0.1403},
{0.8712,0.1557},
{0.871919,0.16832},
{0.872029,0.184685},
{0.872133,0.197234},
{0.866093,0.241143},
{0.8912,0.245},
{0.893038,0.270507},
{0.8937,0.2903},
{0.8927,0.3123},
{0.8534,0.0481},
{0.862263,0.068706},
{0.847038,0.066639},
{0.853709,0.06756},
{0.8597,0.1243},
{0.8499,0.1207},
{0.8587,0.1417},
{0.857,0.1544},
{0.8566,0.16794},
{0.8574,0.1799},
{0.8589,0.1905},
{0.857575,0.205906},
{0.853132,0.239677},
{0.851442,0.269852},
{0.8646,0.261},
{0.8635,0.275},
{0.8618,0.2955},
{0.8714,0.3183},
{0.8725,0.3257},
{0.8375,0.1163},
{0.8476,0.1394},
{0.8459,0.1522},
{0.8462,0.1592},
{0.84683,0.174712},
{0.8464,0.1849},
{0.846051,0.204539},
{0.841075,0.240087},
{0.837965,0.267698},
{0.836623,0.298888},
{0.8521,0.304166},
{0.8355,0.1366},
{0.835389,0.151893},
{0.8343,0.169601},
{0.8346,0.1815},
{0.833197,0.196015},
{0.82499,0.240082},
{0.821611,0.274719},
{0.8204,0.2917},
{0.8196,0.2991},
{0.8377,0.31},
{0.839235,0.324776},
{0.853,0.3215},
{0.8124,0.3256},
{0.8062,0.3104},
{0.7967,0.3119},
{0.8098,0.2547},
{0.8123,0.2368},
{0.8074,0.2884},
{0.8072,0.2976},
{0.8187,0.3113},
{0.8257,0.3244},
{0.8721,0.1821},
{0.872204,0.194414},
{0.886185,0.193878},
{0.870441,0.209944},
{0.8926,0.1736},
{0.884817,0.175194},
{0.8952,0.1809},
{0.912808,0.177573},
{0.898071,0.190766},
{0.8853,0.1841},
{0.8732,0.1743},
{0.871309,0.161277},
{0.8842,0.151004},
{0.894091,0.158776},
{0.909335,0.158251},
{0.9099,0.1673},
{0.9028,0.2041},
{0.918491,0.195254},
{0.8196,0.2991},
{0.8377,0.31},
{0.8187,0.3113},
{0.8124,0.3256},
{0.8257,0.3244},
{0.839259,0.325059},
{0.9186,0.0153},
{0.5236,0.2322},
{0.503,0.2547},
{0.553931,0.272052},
{0.523196,0.294624},
{0.503,0.2752},
{0.503,0.2908},
{0.503,0.3093},
{0.522825,0.315853},
{0.503,0.3359},
{0.518831,0.346594},
{0.503,0.3531},
{0.5131,0.3793},
{0.5219,0.3871},
{0.5506,0.394},
{0.5514,0.365},
{0.5751,0.383},
{0.59119,0.347526},
{0.5514,0.365},
{0.520274,0.350026},
{0.528503,0.318767},
{0.531335,0.300192},
{0.52033,0.267161},
{0.586638,0.304135},
{0.563925,0.324562},
{0.564073,0.324279},
{0.5377,0.4066},
{0.503,0.3722},
{0.5236,0.2322},
{0.553928,0.272047},
{0.52033,0.267161},
{0.531336,0.300192},
{0.528509,0.31877},
{0.520274,0.350025},
{0.5131,0.3793},
{0.5219,0.3871},
{0.5506,0.394},
{0.5514,0.365},
{0.5751,0.383},
{0.591189,0.347526},
{0.5514,0.365},
{0.518832,0.346596},
{0.522823,0.315852},
{0.5232,0.294626},
{0.586639,0.304135},
{0.563924,0.324564},
{0.564073,0.324278},
{0.503,0.214},
{0.5377,0.4066},
{0.288526,0.09914},
{0.288876,0.109252},
{0.281828,0.092136},
{0.282875,0.078004},
{0.273927,0.08338},
{0.274558,0.098777},
{0.280294,0.096181},
{0.289241,0.11474},
{0.294208,0.120388},
{0.290955,0.107216},
{0.291803,0.094608},
{0.287894,0.07489},
{0.271457,0.062703},
{0.267286,0.067833},
{0.268667,0.10547},
{0.27375,0.112084},
{0.2786,0.117214},
{0.279511,0.104643},
{0.299739,0.12447},
{0.294319,0.10438},
{0.294711,0.087274},
{0.2928,0.07},
{0.282438,0.061159},
{0.273384,0.044299},
{0.266586,0.047521},
{0.255614,0.038993},
{0.258852,0.095232},
{0.262012,0.108203},
{0.267785,0.124847},
{0.273876,0.14661},
{0.277551,0.145969},
{0.296284,0.125229},
{0.136393,0.098417},
{0.128512,0.101535},
{0.133296,0.097248},
{0.123582,0.097985},
{0.1243,0.1017},
{0.301366,0.121671},
{0.297173,0.102741},
{0.301491,0.105597},
{0.302846,0.121399},
{0.299178,0.095547},
{0.296035,0.064315},
{0.290593,0.048771},
{0.287184,0.056094},
{0.276785,0.039542},
{0.272201,0.012545},
{0.255701,0.0126},
{0.244071,0.03651},
{0.246011,0.094691},
{0.256753,0.113376},
{0.260548,0.123065},
{0.265278,0.147097},
{0.270379,0.146628},
{0.269226,0.169151},
{0.273988,0.167527},
{0.2772,0.166671},
{0.271049,0.188508},
{0.275657,0.18808},
{0.264768,0.192447},
{0.264698,0.189997},
{0.2578,0.1775},
{0.261037,0.167458},
{0.257819,0.167585},
{0.257395,0.146333},
{0.260597,0.148487},
{0.257419,0.126639},
{0.256418,0.13168},
{0.252706,0.128323},
{0.2559,0.132935},
{0.256274,0.148241},
{0.253191,0.149603},
{0.255368,0.171719},
{0.252537,0.172898},
{0.252087,0.189321},
{0.254869,0.188288},
{0.24682,0.192244},
{0.250262,0.17334},
{0.245998,0.173475},
{0.243061,0.191048},
{0.23825,0.185205},
{0.240607,0.172541},
{0.238072,0.171392},
{0.237472,0.147891},
{0.240304,0.149371},
{0.237084,0.127988},
{0.237095,0.131228},
{0.2363,0.13151},
{0.23411,0.145606},
{0.236595,0.144455},
{0.234577,0.1698},
{0.236605,0.16806},
{0.232212,0.187105},
{0.229124,0.187744},
{0.226516,0.186179},
{0.2233,0.1764},
{0.225274,0.168287},
{0.223398,0.168411},
{0.223303,0.14457},
{0.225098,0.145225},
{0.224694,0.12307},
{0.223407,0.126941},
{0.22181,0.123066},
{0.222554,0.125439},
{0.22006,0.137579},
{0.221891,0.136634},
{0.219695,0.153505},
{0.221,0.153396},
{0.217292,0.17492},
{0.221,0.1601},
{0.216435,0.177854},
{0.212807,0.175182},
{0.209591,0.168827},
{0.2106,0.153923},
{0.2088,0.153763},
{0.208197,0.136094},
{0.210139,0.137285},
{0.205455,0.113884},
{0.209562,0.114764},
{0.213133,0.120257},
{0.213795,0.104973},
{0.206842,0.098833},
{0.205573,0.113926},
{0.198941,0.11439},
{0.196696,0.099505},
{0.185703,0.099744},
{0.180158,0.105331},
{0.1904,0.114884},
{0.1944,0.115473},
{0.194306,0.136103},
{0.199592,0.135507},
{0.204994,0.135552},
{0.204662,0.152892},
{0.196699,0.152892},
{0.197494,0.1598},
{0.203399,0.16304},
{0.19976,0.167231},
{0.142064,0.091223},
{0.1365,0.0951},
{0.134741,0.089208},
{0.145537,0.079423},
{0.154694,0.087697},
{0.16267,0.082198},
{0.155707,0.062864},
{0.177164,0.071576},
{0.168227,0.046239},
{0.181843,0.057485},
{0.181782,0.033146},
{0.1697,0.0133},
{0.196688,0.0133},
{0.201608,0.036967},
{0.212189,0.036075},
{0.2135,0.0133},
{0.219709,0.035469},
{0.2206,0.0133},
{0.2321,0.0132},
{0.232539,0.041226},
{0.2322,0.0971},
{0.235336,0.112304},
{0.246258,0.11657},
{0.250031,0.126662},
{0.264183,0.169065},
{0.131281,0.093865},
{0.204025,0.077746},
{0.198176,0.063625},
{0.210663,0.071467},
{0.217725,0.066798},
{0.18881,0.068548},
{0.19519,0.076551},
{0.164293,0.097554},
{0.153698,0.097631},
{0.162816,0.113315},
{0.169095,0.105464},
{0.177927,0.084203},
{0.157601,0.142205},
{0.156051,0.1472},
{0.1531,0.142101},
{0.150688,0.151105},
{0.154083,0.152665},
{0.152853,0.130686},
{0.148662,0.14227},
{0.1479,0.130676},
{0.147406,0.111959},
{0.157608,0.114793},
{0.1532,0.1071},
{0.147193,0.101543},
{0.145991,0.095132},
{0.226962,0.168434},
{0.227199,0.145346},
{0.226526,0.123184},
{0.219878,0.119862},
{0.216601,0.137968},
{0.217951,0.155345},
{0.214805,0.156466},
{0.21204,0.155449},
{0.212097,0.138463},
{0.215997,0.109687},
{0.224201,0.106566},
{0.229953,0.168524},
{0.231422,0.145334},
{0.230256,0.125092},
{0.230937,0.1118},
{0.190136,0.150962},
{0.189125,0.1579},
{0.180707,0.150728},
{0.185833,0.164847},
{0.232891,0.168578},
{0.179915,0.135208},
{0.190113,0.135287},
{0.233743,0.120995},
{0.242698,0.173232},
{0.242797,0.151608},
{0.242278,0.127498},
{0.246214,0.151053},
{0.2462,0.133425},
{0.250101,0.151735},
{0.1698,0.1556},
{0.167451,0.152623},
{0.172828,0.151332},
{0.173194,0.143764},
{0.164738,0.143869},
{0.174257,0.131015},
{0.1638,0.131283},
{0.173976,0.113574},
{0.179816,0.113561},
{0.2823,0.0135},
{0.283453,0.03818},
{0.7556,0.6551},
{0.779,0.6658},
{0.7769,0.6834},
{0.7553,0.6845},
{0.7349,0.6534},
{0.7358,0.6839},
{0.7155,0.683188},
{0.714887,0.621269},
{0.735255,0.61678},
{0.713787,0.562629},
{0.762023,0.562578},
{0.758134,0.624856},
{0.789145,0.57732},
{0.7836,0.6284},
{0.808979,0.581375},
{0.8198,0.5877},
{0.988478,0.631888},
{0.9838,0.6645},
{0.9623,0.6635},
{0.9595,0.6332},
{0.99296,0.598374},
{0.9592,0.6001},
{0.9203,0.6334},
{0.9233,0.6605},
{0.8889,0.656},
{0.9126,0.6747},
{0.8896,0.6663},
{0.8884,0.6327},
{0.869541,0.60546},
{0.497674,0.165001},
{0.472249,0.197645},
{0.4474,0.1875},
{0.4606,0.2157},
{0.4458,0.2085},
{0.4393,0.2013},
{0.4416,0.2462},
{0.435409,0.267012},
{0.4221,0.2539},
{0.431805,0.231586},
{0.4606,0.2157},
{0.4623,0.2402},
{0.477349,0.208978},
{0.4474,0.1875},
{0.4458,0.2085},
{0.087926,0.19729},
{0.1033,0.172},
{0.1163,0.1866},
{0.1106,0.2055},
{0.126247,0.207385},
{0.1302,0.1879},
{0.1432,0.2016},
{0.1452,0.1877},
{0.160746,0.197819},
{0.1593,0.1881},
{0.79,0.6354},
{0.047098,0.208221},
{0.031871,0.206286},
{0.0287,0.17},
{0.0559,0.1667},
{0.030025,0.136993},
{0.0062,0.1382},
{0.006,0.1714},
{0.008,0.1929},
{0.020844,0.212996},
{0.025386,0.238749},
{0.043733,0.247046},
{0.059204,0.239925},
{0.0635,0.2156},
{0.0658,0.1925},
{0.0712,0.1662},
{0.0563,0.1374},
{0.586334,0.061081},
{0.6103,0.0545},
{0.627003,0.07632},
{0.5974,0.1012},
{0.559221,0.065216},
{0.581662,0.119928},
{0.513852,0.074151},
{0.55202,0.147849},
{0.5662,0.1358},
{0.7365,0.2516},
{0.7363,0.2355},
{0.751062,0.245968},
{0.7503,0.2592},
{0.75667,0.247016},
{0.753937,0.266322},
{0.7384,0.2663},
{0.743211,0.274878},
{0.7625,0.268},
{0.7641,0.2622},
{0.7707,0.2622},
{0.771348,0.267692},
{0.7725,0.2796},
{0.737079,0.315024},
{0.7694,0.2917},
{0.7522,0.3105},
{0.7466,0.324},
{0.7372,0.3264},
{0.720025,0.322454},
{0.7263,0.327},
{0.036042,0.27772},
{0.061256,0.288268},
{0.084486,0.283077},
{0.078625,0.240606},
{0.076,0.1548},
{0.1027,0.1667},
{0.662864,0.017842},
{0.658922,0.015091},
{0.66161,0.005502},
{0.669324,0.016665},
{0.668078,0.037143},
{0.677398,0.030479},
{0.67702,0.007689},
{0.686964,0.016396},
{0.687319,0.065469},
{0.700101,0.061332},
{0.695817,0.013732},
{0.6908,0.0074},
{0.6462,0.3263},
{0.641486,0.327752},
{0.641742,0.309843},
{0.63146,0.317856},
{0.6334,0.3076},
{0.6263,0.2983},
{0.623266,0.30587},
{0.6116,0.2939},
{0.6285,0.2901},
{0.6066,0.2874},
{0.60818,0.275531},
{0.5978,0.2725},
{0.591,0.2643},
{0.5982,0.2684},
{0.617486,0.271199},
{0.611223,0.261159},
{0.625491,0.262489},
{0.61418,0.244179},
{0.625755,0.236206},
{0.633958,0.271128},
{0.636989,0.235605},
{0.646877,0.267438},
{0.6632,0.2511},
{0.652522,0.218796},
{0.672103,0.218359},
{0.6787,0.2475},
{0.6659,0.2684},
{0.6796,0.2684},
{0.6793,0.2829},
{0.695552,0.28521},
{0.6938,0.2684},
{0.6843,0.2463},
{0.699621,0.243869},
{0.691087,0.219819},
{0.7163,0.2048},
{0.722685,0.244313},
{0.7387,0.2148},
{0.656254,0.069925},
{0.649582,0.062028},
{0.653158,0.015229},
{0.643561,0.04936},
{0.6456,0.0876},
{0.6557,0.0882},
{0.664992,0.071088},
{0.675465,0.085389},
{0.686664,0.097649},
{0.700746,0.092726},
{0.714799,0.084988},
{0.70677,0.036625},
{0.704752,0.012827},
{0.721291,0.048534},
{0.71211,0.014622},
{0.7145,0.0073},
{0.7226,0.2654},
{0.730102,0.28678},
{0.7341,0.3},
{0.7174,0.3034},
{0.698,0.3046},
{0.6988,0.3244},
{0.679,0.3188},
{0.679399,0.294923},
{0.6608,0.3034},
{0.6586,0.3186},
{0.091305,0.436469},
{0.084941,0.449634},
{0.074444,0.446945},
{0.075107,0.448978},
{0.069655,0.459163},
{0.068103,0.45596},
{0.045241,0.46166},
{0.0764,0.4649},
{0.0553,0.4697},
{0.0579,0.476},
{0.0784,0.4722},
{0.083399,0.353454},
{0.098,0.346},
{0.107531,0.367974},
{0.0906,0.3673},
{0.08756,0.380011},
{0.0994,0.3903},
{0.116972,0.363407},
{0.103487,0.336895},
{0.0824,0.3385},
{0.0607,0.3357},
{0.059323,0.346514},
{0.068795,0.368472},
{0.067607,0.393346},
{0.0779,0.4006},
{0.086915,0.411467},
{0.1095,0.3897},
{0.127542,0.393319},
{0.1332,0.3523},
{0.123825,0.332373},
{0.0939,0.3212},
{0.079063,0.32645},
{0.052494,0.326321},
{0.0447,0.3396},
{0.0355,0.351},
{0.0469,0.3553},
{0.045869,0.365608},
{0.05064,0.38374},
{0.0503,0.397},
{0.064521,0.404577},
{0.069301,0.415217},
{0.0829,0.4251},
{0.099115,0.420822},
{0.10744,0.411285},
{0.576505,0.220067},
{0.557164,0.216219},
{0.576128,0.187568},
{0.551454,0.177016},
{0.5365,0.2111},
{0.5187,0.2083},
{0.514803,0.171768},
{0.504,0.209},
{0.5561,0.0464},
{0.5665,0.0465},
{0.508845,0.047997},
{0.559221,0.065216},
{0.581662,0.119928},
{0.552042,0.147867},
{0.513288,0.157385},
{0.5488,0.1577},
{0.5346,0.1716},
{0.055332,0.407945},
{0.048631,0.423485},
{0.0616,0.4277},
{0.024238,0.377528},
{0.035393,0.368294},
{0.0318,0.3905},
{0.0412,0.3995},
{0.025493,0.394093},
{0.017739,0.3807},
{0.020618,0.361935},
{0.019798,0.349566},
{0.013907,0.361882},
{0.017806,0.349447},
{0.01437,0.361945},
{0.020618,0.361936},
{0.0355,0.351},
{0.035394,0.368294},
{0.024238,0.377528},
{0.017739,0.3807},
{0.0318,0.3905},
{0.025493,0.394093},
{0.6463,0.2808},
{0.6635,0.2807},
{0.6616,0.2921},
{0.6443,0.29},
{0.6316,0.28},
{0.470286,0.269663},
{0.485818,0.257536},
{0.4955,0.250868},
{0.476009,0.185711},
{0.4799,0.4251},
{0.48088,0.398159},
{0.48909,0.403756},
{0.487397,0.427326},
{0.4955,0.4271},
{0.492086,0.402285},
{0.491738,0.3715},
{0.480293,0.379629},
{0.455478,0.375964},
{0.4556,0.3955},
{0.4525,0.4195},
{0.44622,0.443567},
{0.480271,0.455305},
{0.4955,0.4542},
{0.486806,0.427168},
{0.486296,0.394179},
{0.485026,0.373525},
{0.494638,0.356098},
{0.4839,0.3564},
{0.454594,0.365998},
{0.4281,0.3663},
{0.427513,0.384609},
{0.428174,0.400033},
{0.437142,0.41891},
{0.445105,0.425647},
{0.444948,0.433551},
{0.4517,0.4707},
{0.4387,0.4675},
{0.43821,0.445888},
{0.436884,0.446608},
{0.4374,0.4659},
{0.4299,0.4782},
{0.4297,0.4753},
{0.1885,0.3373},
{0.19946,0.370555},
{0.167925,0.350799},
{0.1814,0.3239},
{0.154798,0.322094},
{0.1475,0.3498},
{0.161676,0.383111},
{0.186637,0.386005},
{0.4327,0.3584},
{0.438,0.3508},
{0.46,0.3539},
{0.4868,0.3393},
{0.4657,0.3368},
{0.4436,0.3362},
{0.4689,0.3204},
{0.4466,0.3198},
{0.472235,0.294665},
{0.447496,0.299887},
{0.4453,0.285},
{0.473,0.283},
{0.1776,0.3117},
{0.141973,0.277345},
{0.126075,0.307496},
{0.1408,0.3306},
{0.142453,0.385826},
{0.116878,0.250685},
{0.1197,0.2361},
{0.142413,0.237238},
{0.166335,0.245712},
{0.1754,0.2265},
{0.14059,0.219933},
{0.1057,0.2184},
{0.1023,0.2363},
{0.1002,0.2536},
{0.104057,0.288147},
{0.0444,0.3025},
{0.079117,0.303538},
{0.1094,0.3095},
{0.0474,0.3159},
{0.035471,0.332683},
{0.027099,0.29766},
{0.0088,0.3337},
{0.491651,0.302741},
{0.4871,0.3212},
{0.491233,0.320806},
{0.4689,0.3204},
{0.472228,0.294728},
{0.4876,0.285121},
{0.4955,0.284906},
{0.4876,0.28555},
{0.494941,0.269839},
{0.485745,0.257117},
{0.459436,0.238726},
{0.4308,0.2316},
{0.4221,0.2539},
{0.4416,0.2462},
{0.435432,0.26704},
{0.1632,0.2651},
{0.1682,0.2926},
{0.020324,0.238297},
{0.020402,0.274736},
{0.0208,0.2746},
{0.009065,0.298423},
{0.0287,0.17},
{0.029245,0.135017},
{0.0323,0.1933},
{0.020492,0.212943},
{0.088,0.1966},
{0.1106,0.2055},
{0.1163,0.1866},
{0.1033,0.172},
{0.050934,0.197239},
{0.0559,0.1667},
{0.043744,0.249521},
{0.0315,0.2393},
{0.036311,0.278584},
{0.027053,0.297322},
{0.0658,0.1925},
{0.0712,0.1662},
{0.0635,0.2156},
{0.059216,0.240746},
{0.067562,0.29498},
{0.0507,0.282},
{0.4673,0.2603},
{0.471531,0.274847},
{0.4453,0.285},
{0.447679,0.302062},
{0.4466,0.3198},
{0.4436,0.3362},
{0.4657,0.3368},
{0.436434,0.353046},
{0.46,0.3539},
{0.45602,0.362591},
{0.4281,0.3663},
{0.455441,0.374554},
{0.480119,0.397258},
{0.4556,0.3955},
{0.4799,0.4251},
{0.4764,0.4555},
{0.4533,0.45},
{0.4741,0.4813},
{0.4517,0.4707},
{0.46519,0.485441},
{0.4506,0.4792},
{0.104893,0.218343},
{0.076,0.1548},
{0.1027,0.1667},
{0.5679,0.1749},
{0.5829,0.175837},
{0.567712,0.143569},
{0.5835,0.1456},
{0.5979,0.1447},
{0.5981,0.177691},
{0.611397,0.179154},
{0.6115,0.1455},
{0.6258,0.1469},
{0.6258,0.178337},
{0.557158,0.216145},
{0.5765,0.2203},
{0.576114,0.187684},
{0.5627,0.1819},
{0.536573,0.211016},
{0.5515,0.1768},
{0.5346,0.1716},
{0.515579,0.162809},
{0.509131,0.190063},
{0.5187,0.2083},
{0.504,0.1617},
{0.5488,0.1577},
{0.047243,0.315197},
{0.052195,0.325982},
{0.075718,0.317994},
{0.092854,0.305074},
{0.0939,0.3212},
{0.1094,0.3095},
{0.123358,0.33184},
{0.103487,0.336895},
{0.079569,0.327704},
{0.0824,0.3385},
{0.0607,0.3357},
{0.0447,0.3396},
{0.035448,0.332663},
{0.5974,0.1012},
{0.036794,0.482853},
{0.038299,0.470899},
{0.027838,0.46601},
{0.0267,0.4912},
{0.040084,0.495992},
{0.0471,0.4873},
{0.051267,0.500912},
{0.054671,0.482385},
{0.0481,0.4772},
{0.0579,0.476},
{0.0553,0.4697},
{0.047912,0.461877},
{0.030469,0.453335},
{0.0516,0.4526},
{0.069236,0.455906},
{0.069505,0.459929},
{0.0764,0.4649},
{0.0784,0.4722},
{0.4863,0.455},
{0.4858,0.4786},
{0.494629,0.476597},
{0.4955,0.4859},
{0.489927,0.4944},
{0.473303,0.500876},
{0.116747,0.252986},
{0.1369,0.2496},
{0.142528,0.23086},
{0.1197,0.2361},
{0.125735,0.209497},
{0.1432,0.2016},
{0.161016,0.197218},
{0.187276,0.19696},
{0.1754,0.2265},
{0.165351,0.248414},
{0.1404,0.2683},
{0.123973,0.301798},
{0.100311,0.255089},
{0.1023,0.2363},
{0.1302,0.1879},
{0.1452,0.1877},
{0.1593,0.1881},
{0.1682,0.2926},
{0.1632,0.2651},
{0.1448,0.2936},
{0.152396,0.316261},
{0.1408,0.3306},
{0.1048,0.2931},
{0.0818,0.2774},
{0.078626,0.240648},
{0.4868,0.3393},
{0.1475,0.3498},
{0.1644,0.3445},
{0.1332,0.3523},
{0.178723,0.315305},
{0.490587,0.498089},
{0.49167,0.496109},
{0.492129,0.496127},
{0.491603,0.498478},
{0.4861,0.5002},
{0.4749,0.5015},
{0.4685,0.5027},
{0.4652,0.5023},
{0.4925,0.494208},
{0.494296,0.491203},
{0.4937,0.4917},
{0.491521,0.495107},
{0.493105,0.494342},
{0.4938,0.4926},
{0.1885,0.3373},
{0.026075,0.436028},
{0.042574,0.435399},
{0.071343,0.450334},
{0.5662,0.1358},
{0.024177,0.446319},
{0.021,0.4419},
{0.023,0.4363},
{0.027,0.4324},
{0.033412,0.432516},
{0.039964,0.43284},
{0.048619,0.423475},
{0.063412,0.424713},
{0.075305,0.447173},
{0.0563,0.137102},
{0.0781,0.1392},
{0.0809,0.006},
{0.7556,0.6551},
{0.7553,0.6845},
{0.7769,0.6834},
{0.779,0.6658},
{0.781786,0.628179},
{0.79,0.6354},
{0.809283,0.580311},
{0.8198,0.5877},
{0.830238,0.629921},
{0.8462,0.7069},
{0.849879,0.622504},
{0.8673,0.7052},
{0.9823,0.6323},
{0.9595,0.6332},
{0.9623,0.6635},
{0.9838,0.6645},
{0.9983,0.6644},
{0.735282,0.619474},
{0.7358,0.683898},
{0.789758,0.577665},
{0.8884,0.6327},
{0.869604,0.602871},
{0.8889,0.656},
{0.8896,0.6663},
{0.9126,0.6747},
{0.9233,0.6605},
{0.9203,0.6334},
{0.961,0.6644},
{0.92,0.6009},
{0.9592,0.6001},
{0.9851,0.5991},
{0.8895,0.6009},
{0.1904,0.1704},
{0.1669,0.1664},
{0.7839,0.6759},
{0.4741,0.4813},
{0.477887,0.489639},
{0.490585,0.49809},
{0.491603,0.498478},
{0.492129,0.496126},
{0.4506,0.4792},
{0.465109,0.484784},
{0.044834,0.474926},
{0.054811,0.481795},
{0.044833,0.486308},
{0.04398,0.497574},
{0.0519,0.5012},
{0.035535,0.46997},
{0.026902,0.491273},
{0.042167,0.435218},
{0.02655,0.435831},
{0.03341,0.432516},
{0.027,0.4324},
{0.023,0.4363},
{0.021,0.4419},
{0.021349,0.446455},
{0.039965,0.43284},
{0.0319,0.4307},
{0.508392,0.029621},
{0.5143,0.0286},
{0.5561,0.0464},
{0.586334,0.061081},
{0.627002,0.076319},
{0.6103,0.0545},
{0.5274,0.0106},
{0.5386,0.0294},
{0.515201,0.004323},
{0.516217,0.004413},
{0.5274,0.0106},
{0.5386,0.0294},
{0.4733,0.5009},
{0.4652,0.5023},
{0.027592,0.468433},
{0.027828,0.455903},
{0.0246,0.464},
{0.03533,0.469465},
{0.023261,0.491464},
{0.0383,0.4974},
{0.0428,0.4993},
{0.0484,0.5016},
{0.7144,0.2909},
{0.708728,0.272042},
{0.6805,0.1941},
{0.6647,0.1943},
{0.665217,0.154317},
{0.67965,0.168864},
{0.6775,0.1528},
{0.675022,0.121873},
{0.665506,0.109658},
{0.655499,0.110306},
{0.656653,0.154859},
{0.6542,0.195},
{0.643226,0.178193},
{0.6411,0.1925},
{0.6312,0.1788},
{0.629,0.1874},
{0.63576,0.152758},
{0.647799,0.142323},
{0.637299,0.121124},
{0.645563,0.111816},
{0.637,0.1152},
{0.6358,0.1101},
{0.634533,0.100066},
{0.720867,0.163907},
{0.7295,0.1882},
{0.710228,0.192648},
{0.704329,0.160449},
{0.690765,0.163485},
{0.6922,0.193},
{0.6888,0.1291},
{0.686702,0.114755},
{0.6747,0.1137},
{0.675365,0.104985},
{0.6651,0.0998},
{0.6553,0.1003},
{0.734118,0.152711},
{0.718,0.1282},
{0.731601,0.121523},
{0.7134,0.1219},
{0.7018,0.1286},
{0.732,0.1158},
{0.7128,0.1169},
{0.712,0.1098},
{0.7325,0.1101},
{0.714,0.0992},
{0.7017,0.1083},
{0.70188,0.11554},
{0.6869,0.1068},
{0.733211,0.099555},
{0.7395,0.1781},
{0.7424,0.1863},
{0.072,0.460956},
{0.6516,0.0059},
{0.5835,0.1456},
{0.5829,0.176632},
{0.567907,0.174675},
{0.5677,0.1432},
{0.5979,0.1447},
{0.5981,0.177679},
{0.611396,0.179138},
{0.6115,0.1455},
{0.187293,0.196917},
{0.1904,0.1704},
{0.1669,0.1664},
{0.416767,0.398809},
{0.029302,0.450791},
{0.92,0.6009},
{0.8895,0.6009},
{0.961,0.6644},
{0.028011,0.452206},
{0.3679,0.1948},
{0.3524,0.2107},
{0.0781,0.1392},
{0.0809,0.006},
{0.4393,0.2013},
{0.15784,0.130467},
{0.3074,0.4615},
{0.29366,0.459651},
{0.2936,0.4615},
{0.273556,0.462304},
{0.2955,0.4912},
{0.3081,0.4899},
{0.3074,0.4615},
{0.3074,0.4033},
{0.3287,0.4615},
{0.3287,0.4033},
{0.2736,0.4611},
{0.253387,0.461342},
{0.2744,0.4924},
{0.2955,0.5138},
{0.3074,0.5138},
{0.3287,0.4781},
{0.2534,0.4615},
{0.2287,0.4033},
{0.2287,0.4522},
{0.2287,0.4748},
{0.2534,0.4872},
{0.2757,0.5142},
{0.2287,0.4522},
{0.2049,0.450997},
{0.2049,0.4522},
{0.1838,0.4033},
{0.1838,0.4522},
{0.2049,0.4873},
{0.1838,0.4522},
{0.155694,0.4033},
{0.1691,0.4522},
{0.1557,0.4564},
{0.1355,0.4033},
{0.1355,0.4607},
{0.3287,0.4615},
{0.784345,0.409114},
{0.8304,0.3643},
{0.8998,0.3836},
{0.8738,0.4227},
{0.786466,0.438395},
{0.8578,0.4517},
{0.7812,0.3609},
{0.784345,0.409114},
{0.8738,0.4227},
{0.8998,0.3836},
{0.8304,0.3643},
{0.7812,0.3609},
{0.786466,0.438395},
{0.8578,0.4517},
{0.1355,0.4781},
{0.156321,0.486447},
{0.1557,0.5138},
{0.1355,0.5138},
{0.2287,0.4878},
{0.2534,0.5138},
{0.2287,0.5138},
{0.2049,0.5138},
{0.1838,0.4846},
{0.1838,0.5138},
{0.1691,0.5138},
{0.158049,0.455664},
{0.1355,0.4607},
{0.3287,0.5138},
{0.9056,0.4435},
{0.9203,0.4358},
{0.9283,0.436511},
{0.9056,0.4472},
{0.8688,0.4554},
{0.8688,0.4591},
{0.8431,0.4554},
{0.8431,0.4591},
{0.8688,0.4554},
{0.8688,0.4591},
{0.9056,0.4435},
{0.9056,0.4472},
{0.928611,0.43394},
{0.932224,0.435769},
{0.935096,0.471379},
{0.90614,0.473929},
{0.8688,0.478367},
{0.8431,0.475628},
{0.965827,0.443025},
{0.960193,0.444829},
{0.963997,0.477225},
{0.9358,0.4893},
{0.918568,0.491817},
{0.908365,0.504568},
{0.8688,0.5028},
{0.8431,0.5028},
{0.9967,0.4552},
{0.9967,0.459},
{0.9665,0.4434},
{0.957069,0.442493},
{0.951571,0.435407},
{0.939042,0.47143},
{0.967057,0.474832},
{0.9967,0.477545},
{0.9967,0.5016},
{0.9663,0.5016},
{0.954023,0.496136},
{0.948608,0.51333},
{0.933539,0.50722},
{0.928748,0.514631},
{0.9054,0.5028},
{0.928332,0.487471},
{0.90592,0.470476},
{0.8688,0.477035},
{0.8688,0.5028},
{0.0302,0.3936},
{0.92546,0.513774},
{0.905763,0.50971},
{0.8688,0.5095},
{0.8431,0.5095},
{0.939813,0.515123},
{0.947915,0.504509},
{0.927755,0.519653},
{0.963995,0.503604},
{0.0402,0.4032},
{0.0496,0.3998},
{0.8688,0.5095},
{0.9054,0.5095},
{0.918646,0.516751},
{0.9358,0.5207},
{0.95314,0.517337},
{0.9664,0.5072},
{0.9967,0.5072},
{0.9662,0.5072},
{0.957735,0.515104},
{0.028017,0.45221},
{0.0267,0.4555},
{0.0213,0.4465},
{0.0246,0.464},
{0.026456,0.478134},
{0.0231,0.4914},
{0.0319,0.4307},
{0.0779,0.4634},
{0.0802,0.4703},
{0.0751,0.4611},
{0.0267,0.4912},
{0.042099,0.4967},
{0.0423,0.4852},
{0.0425,0.4733},
{0.0355,0.4693},
{0.0279,0.4654},
{0.026896,0.49127},
{0.0421,0.4967},
{0.0423,0.4852},
{0.0425,0.4733},
{0.8334,0.4588},
{0.8334,0.5102},
{0.7831,0.5102},
{0.7831,0.4588},
{0.5363,0.7185},
{0.5581,0.744},
{0.539219,0.753263},
{0.518996,0.746825},
{0.5061,0.727849},
{0.511036,0.707251},
{0.5182,0.6979},
{0.5287,0.6892},
{0.543099,0.689106},
{0.5543,0.6979},
{0.563074,0.711037},
{0.5664,0.7323},
{0.863688,0.572445},
{0.863986,0.571429},
{0.86815,0.574458},
{0.870138,0.584267},
{0.861311,0.584513},
{0.861314,0.584519},
{0.8737,0.5927},
{0.4938,0.4926},
{0.4955,0.4912},
{0.493105,0.494343},
{0.813034,0.548025},
{0.783708,0.528281},
{0.817211,0.528535},
{0.865601,0.554241},
{0.893704,0.528202},
{0.938066,0.528364},
{0.939972,0.55423},
{0.970678,0.528328},
{0.967164,0.554233},
{0.995695,0.55428},
{0.991415,0.527117},
{0.967248,0.554238},
{0.9641,0.528352},
{0.9439,0.554236},
{0.9439,0.528389},
{0.9266,0.554206},
{0.904554,0.528308},
{0.867758,0.554278},
{0.8432,0.528036},
{0.813054,0.548115},
{0.811066,0.527366},
{0.802396,0.551979},
{0.785865,0.55693},
{0.802396,0.551979},
{0.355,0.0836},
{0.365603,0.052756},
{0.361809,0.050325},
{0.357073,0.049193},
{0.348292,0.050325},
{0.344515,0.052745},
{0.332204,0.061309},
{0.321891,0.09109},
{0.329,0.1049},
{0.354823,0.115942},
{0.378335,0.106333},
{0.3883,0.0942},
{0.3879,0.0805},
{0.378735,0.062388},
{0.038299,0.4974},
{0.0428,0.4993},
{0.0484,0.5016},
{0.4685,0.5027},
{0.4749,0.5015},
{0.4861,0.5002},
{0.5956,0.5137},
{0.5945,0.5113},
{0.6045,0.508698},
{0.613,0.5136},
{0.6128,0.5116},
{0.6297,0.513906},
{0.629,0.5122},
{0.642,0.5098},
{0.6427,0.5216},
{0.624079,0.529292},
{0.6419,0.5333},
{0.6281,0.531},
{0.6135,0.5313},
{0.604002,0.53509},
{0.5957,0.5296},
{0.5938,0.5313},
{0.589707,0.521899},
{0.589707,0.521899},
{0.5957,0.5296},
{0.5956,0.5137},
{0.5945,0.5113},
{0.6045,0.508698},
{0.613,0.5136},
{0.624078,0.529292},
{0.604002,0.53509},
{0.5938,0.5313},
{0.6297,0.513906},
{0.6427,0.5216},
{0.642,0.5098},
{0.629,0.5122},
{0.6128,0.5116},
{0.6419,0.5333},
{0.6281,0.531},
{0.6135,0.5313},
{0.604004,0.535078},
{0.6135,0.5313},
{0.6131,0.5295},
{0.628911,0.528977},
{0.6281,0.531},
{0.6419,0.5333},
{0.6427,0.5216},
{0.642,0.5098},
{0.613768,0.513614},
{0.629,0.5122},
{0.6128,0.5116},
{0.604498,0.508712},
{0.5956,0.5137},
{0.5945,0.5113},
{0.589707,0.521899},
{0.5957,0.5296},
{0.5938,0.5313},
{0.5957,0.5296},
{0.5938,0.5313},
{0.589707,0.521899},
{0.5956,0.5137},
{0.5945,0.5113},
{0.604498,0.508712},
{0.613768,0.513614},
{0.6128,0.5116},
{0.629,0.5122},
{0.642,0.5098},
{0.628911,0.528977},
{0.6427,0.5216},
{0.6419,0.5333},
{0.6281,0.531},
{0.6135,0.5313},
{0.6131,0.5295},
{0.604004,0.535078},
{0.5638,0.4813},
{0.5637,0.5008},
{0.5511,0.4988},
{0.5514,0.4795},
{0.5421,0.4957},
{0.5417,0.4787},
{0.5421,0.4665},
{0.5231,0.4648},
{0.5753,0.4805},
{0.5755,0.4628},
{0.5874,0.4624},
{0.5867,0.4815},
{0.5989,0.4806},
{0.6005,0.4633},
{0.615,0.4655},
{0.555027,0.462439},
{0.5876,0.5007},
{0.5752,0.5016},
{0.5993,0.4988},
{0.611504,0.496153},
{0.6327,0.4652},
{0.6372,0.4814},
{0.5214,0.5011},
{0.5125,0.4814},
{0.5511,0.4988},
{0.5637,0.5008},
{0.5638,0.4813},
{0.5874,0.4624},
{0.5755,0.4628},
{0.5753,0.4805},
{0.554965,0.462441},
{0.5514,0.4795},
{0.5421,0.4665},
{0.5867,0.4815},
{0.5989,0.4806},
{0.6005,0.4633},
{0.615,0.4655},
{0.5417,0.4787},
{0.5231,0.4648},
{0.5125,0.4814},
{0.5752,0.5016},
{0.5876,0.5007},
{0.5993,0.4988},
{0.611503,0.496164},
{0.5421,0.4957},
{0.5214,0.5011},
{0.6912,0.4017},
{0.6881,0.3992},
{0.688288,0.416917},
{0.7009,0.4378},
{0.676978,0.415346},
{0.678665,0.379714},
{0.665241,0.383262},
{0.6665,0.3621},
{0.6778,0.3621},
{0.6938,0.376},
{0.6928,0.3933},
{0.7114,0.3897},
{0.7154,0.3671},
{0.702598,0.351102},
{0.6473,0.4373},
{0.6457,0.4341},
{0.6517,0.4343},
{0.64769,0.417993},
{0.6533,0.4187},
{0.6498,0.3999},
{0.6425,0.3807},
{0.6488,0.3807},
{0.6515,0.3614},
{0.6448,0.3614},
{0.6645,0.4308},
{0.662491,0.434628},
{0.6731,0.4245},
{0.6759,0.4142},
{0.6654,0.417},
{0.6654,0.3977},
{0.6652,0.3795},
{0.669012,0.3621},
{0.6745,0.4277},
{0.6731,0.4245},
{0.664465,0.433964},
{0.6518,0.4339},
{0.6645,0.4299},
{0.6654,0.417},
{0.6781,0.3972},
{0.691639,0.400539},
{0.6777,0.4171},
{0.6888,0.4176},
{0.6005,0.4633},
{0.5874,0.4624},
{0.603627,0.439981},
{0.626372,0.461043},
{0.621758,0.430641},
{0.625865,0.430803},
{0.6336,0.4574},
{0.6372,0.4551},
{0.6403,0.4529},
{0.628503,0.426656},
{0.613335,0.412782},
{0.6159,0.4102},
{0.594214,0.398359},
{0.5918,0.402},
{0.5757,0.3998},
{0.576,0.394392},
{0.560461,0.399333},
{0.5577,0.3958},
{0.5403,0.4138},
{0.5378,0.4112},
{0.528433,0.429982},
{0.522864,0.432541},
{0.5152,0.4561},
{0.508025,0.464821},
{0.5097,0.4705},
{0.508174,0.485325},
{0.50322,0.491979},
{0.5069,0.4957},
{0.507809,0.5027},
{0.5031,0.5027},
{0.508201,0.5111},
{0.5028,0.5111},
{0.588261,0.43958},
{0.59849,0.429184},
{0.5637,0.4621},
{0.5755,0.4628},
{0.5634,0.5006},
{0.575641,0.444266},
{0.551386,0.42683},
{0.5434,0.4167},
{0.5404,0.4354},
{0.546871,0.440766},
{0.529114,0.462466},
{0.530173,0.435412},
{0.561671,0.417568},
{0.562998,0.441201},
{0.5509,0.4626},
{0.590177,0.41517},
{0.5759,0.4157},
{0.5758,0.4057},
{0.7114,0.3897},
{0.6928,0.3933},
{0.688237,0.376884},
{0.6515,0.3614},
{0.648892,0.382471},
{0.6533,0.4187},
{0.6938,0.3589},
{0.7154,0.3671},
{0.7026,0.3511},
{0.507626,0.5027},
{0.5032,0.5027},
{0.507046,0.491751},
{0.50364,0.484554},
{0.510447,0.470948},
{0.51009,0.459207},
{0.5152,0.4561},
{0.5186,0.4577},
{0.7055,0.5486},
{0.693109,0.5378},
{0.6928,0.549},
{0.6927,0.5561},
{0.7054,0.5553},
{0.725,0.5494},
{0.7249,0.5565},
{0.7031,0.4471},
{0.7172,0.4433},
{0.693233,0.456099},
{0.695,0.4463},
{0.7164,0.4521},
{0.7158,0.4666},
{0.692436,0.468648},
{0.715715,0.480911},
{0.6931,0.5},
{0.719719,0.511014},
{0.703005,0.510282},
{0.72581,0.529415},
{0.7048,0.5282},
{0.693629,0.537798},
{0.7252,0.5493},
{0.7058,0.5484},
{0.7254,0.5567},
{0.7058,0.5554},
{0.6932,0.5488},
{0.6931,0.5563},
{0.692972,0.455801},
{0.7162,0.4522},
{0.692165,0.469646},
{0.7156,0.4668},
{0.715615,0.485273},
{0.6929,0.5002},
{0.702645,0.510467},
{0.721978,0.514263},
{0.7044,0.528},
{0.72568,0.535599},
{0.693,0.5275},
{0.6519,0.5342},
{0.6531,0.5249},
{0.6775,0.5359},
{0.6646,0.5508},
{0.6738,0.5456},
{0.6785,0.5265},
{0.6529,0.5254},
{0.6786,0.527},
{0.6766,0.4602},
{0.681934,0.47158},
{0.6556,0.4596},
{0.6662,0.4526},
{0.6811,0.5},
{0.6492,0.5},
{0.652973,0.509381},
{0.678575,0.509592},
{0.648801,0.472133},
{0.6935,0.5277},
{0.518499,0.457903},
{0.510022,0.492522},
{0.51,0.4944},
{0.5417,0.4785},
{0.6328,0.5023},
{0.6881,0.3992},
{0.675,0.4278},
{0.6554,0.5444},
{0.6473,0.4373},
{0.662403,0.434655},
{0.6517,0.4343},
{0.6645,0.4308},
{0.6731,0.4245},
{0.675,0.4278},
{0.7009,0.4378},
{0.664484,0.433958},
{0.6518,0.4339},
{0.6457,0.4341},
{0.6533,0.4187},
{0.647538,0.417191},
{0.648915,0.382898},
{0.6425,0.3807},
{0.6448,0.3614},
{0.6515,0.3614},
{0.665239,0.383041},
{0.6665,0.3621},
{0.67867,0.379509},
{0.6778,0.3621},
{0.6938,0.376},
{0.702598,0.351102},
{0.7154,0.3671},
{0.7114,0.3897},
{0.6928,0.3933},
{0.6645,0.4299},
{0.6654,0.417},
{0.677011,0.415427},
{0.6881,0.3992},
{0.688339,0.416985},
{0.6912,0.4017},
{0.6731,0.4245},
{0.6745,0.4277},
{0.691576,0.400704},
{0.6881,0.3992},
{0.6781,0.3972},
{0.6759,0.4142},
{0.6654,0.417},
{0.6654,0.3977},
{0.6652,0.3795},
{0.688609,0.376825},
{0.6928,0.3933},
{0.7114,0.3897},
{0.7154,0.3671},
{0.6938,0.3589},
{0.7026,0.3511},
{0.6372,0.4814},
{0.6328,0.5023},
{0.5755,0.4628},
{0.5637,0.4621},
{0.5874,0.4624},
{0.588262,0.439558},
{0.6005,0.4633},
{0.603628,0.439985},
{0.59848,0.429195},
{0.590174,0.415192},
{0.5759,0.4157},
{0.575641,0.444291},
{0.5509,0.4626},
{0.546824,0.440881},
{0.529112,0.462469},
{0.5404,0.4354},
{0.530189,0.435382},
{0.518498,0.457904},
{0.528413,0.43002},
{0.5152,0.4561},
{0.5097,0.4705},
{0.508174,0.485325},
{0.508037,0.464789},
{0.50322,0.49198},
{0.5069,0.4957},
{0.51,0.4944},
{0.507809,0.5027},
{0.5031,0.5027},
{0.508201,0.5111},
{0.5028,0.5111},
{0.5434,0.4167},
{0.5403,0.4138},
{0.5378,0.4112},
{0.522854,0.432562},
{0.5918,0.402},
{0.613337,0.412779},
{0.5758,0.4057},
{0.561669,0.417547},
{0.563004,0.44138},
{0.560461,0.399331},
{0.551376,0.426818},
{0.6777,0.4171},
{0.6888,0.4176},
{0.6533,0.4187},
{0.6498,0.3999},
{0.6488,0.3807},
{0.669011,0.3621},
{0.6515,0.3614},
{0.5186,0.4577},
{0.5152,0.4561},
{0.510442,0.470944},
{0.510121,0.459117},
{0.50364,0.484556},
{0.507046,0.491751},
{0.5032,0.5027},
{0.507626,0.5027},
{0.576,0.394392},
{0.594214,0.398359},
{0.5757,0.3998},
{0.6159,0.4102},
{0.628466,0.426587},
{0.624626,0.429422},
{0.6403,0.4529},
{0.6372,0.4551},
{0.6296,0.4449},
{0.6336,0.4574},
{0.626377,0.461052},
{0.5577,0.3958},
{0.7164,0.4521},
{0.7172,0.4433},
{0.693233,0.456099},
{0.7158,0.4666},
{0.692434,0.46868},
{0.715714,0.480846},
{0.6931,0.5},
{0.71968,0.510964},
{0.703014,0.510309},
{0.72581,0.529416},
{0.7048,0.5282},
{0.693629,0.537798},
{0.6935,0.5277},
{0.7031,0.4471},
{0.695,0.4463},
{0.7162,0.4522},
{0.692972,0.455801},
{0.7156,0.4668},
{0.692166,0.469639},
{0.715616,0.48529},
{0.6929,0.5002},
{0.702648,0.510474},
{0.721964,0.514245},
{0.7044,0.528},
{0.72568,0.5356},
{0.693109,0.5378},
{0.7055,0.5486},
{0.725,0.5494},
{0.7054,0.5553},
{0.7249,0.5565},
{0.7058,0.5484},
{0.7252,0.5493},
{0.6932,0.5488},
{0.7058,0.5554},
{0.6931,0.5563},
{0.7254,0.5567},
{0.6775,0.5359},
{0.6785,0.5265},
{0.6531,0.5249},
{0.6519,0.5342},
{0.6646,0.5508},
{0.6554,0.5444},
{0.6786,0.527},
{0.6529,0.5254},
{0.6738,0.5456},
{0.6556,0.4596},
{0.648802,0.472126},
{0.681936,0.471608},
{0.6492,0.5},
{0.6811,0.5},
{0.652974,0.509387},
{0.678572,0.509616},
{0.6766,0.4602},
{0.6662,0.4526},
{0.693,0.5275},
{0.6928,0.549},
{0.6927,0.5561},
{0.510022,0.492522},
{0.5231,0.4648},
{0.5417,0.4785},
{0.6327,0.4652},
{0.5634,0.5006},
{0.290957,0.107229},
{0.283429,0.079622},
{0.289368,0.110344},
{0.294207,0.120387},
{0.296456,0.125127},
{0.289092,0.11452},
{0.280276,0.096147},
{0.2815,0.091886},
{0.274332,0.082808},
{0.271858,0.063376},
{0.288083,0.075758},
{0.29413,0.10382},
{0.299738,0.12447},
{0.129,0.101353},
{0.136655,0.097507},
{0.134203,0.096589},
{0.123582,0.097985},
{0.133469,0.090643},
{0.14211,0.091178},
{0.146012,0.095126},
{0.154738,0.088483},
{0.147209,0.101678},
{0.153704,0.097527},
{0.15475,0.10708},
{0.1472,0.1065},
{0.15761,0.11533},
{0.147582,0.115488},
{0.152893,0.131446},
{0.1479,0.131318},
{0.148912,0.142631},
{0.153173,0.142745},
{0.151586,0.1472},
{0.157317,0.142714},
{0.156728,0.14909},
{0.152387,0.152544},
{0.1243,0.1017},
{0.301283,0.122016},
{0.302846,0.121399},
{0.299915,0.10009},
{0.297324,0.103123},
{0.294796,0.088692},
{0.296795,0.068185},
{0.2928,0.07},
{0.290613,0.048813},
{0.287166,0.056043},
{0.2809,0.0445},
{0.284037,0.039201},
{0.275357,0.038481},
{0.2823,0.0135},
{0.2753,0.0126},
{0.27152,0.040767},
{0.2697,0.0125},
{0.264741,0.040945},
{0.257961,0.012753},
{0.255603,0.03853},
{0.243975,0.036975},
{0.2443,0.0132},
{0.221598,0.036376},
{0.2321,0.0132},
{0.2206,0.0133},
{0.2135,0.0133},
{0.212168,0.037108},
{0.1968,0.0133},
{0.201766,0.036401},
{0.183649,0.034567},
{0.180325,0.058353},
{0.167112,0.047764},
{0.1697,0.0133},
{0.282693,0.061685},
{0.274536,0.098862},
{0.279484,0.104778},
{0.2683,0.0953},
{0.267257,0.066703},
{0.25898,0.096801},
{0.262552,0.11054},
{0.271341,0.109905},
{0.269798,0.121436},
{0.264789,0.121714},
{0.25423,0.124048},
{0.256156,0.114858},
{0.246067,0.095573},
{0.163564,0.098611},
{0.163162,0.083346},
{0.179472,0.082465},
{0.185836,0.10111},
{0.169493,0.103051},
{0.15568,0.062903},
{0.175335,0.071154},
{0.142808,0.082083},
{0.197439,0.10084},
{0.195261,0.073519},
{0.204294,0.071996},
{0.2053,0.0989},
{0.196642,0.105935},
{0.1904,0.114936},
{0.179884,0.114012},
{0.17359,0.113809},
{0.163116,0.115676},
{0.2789,0.1108},
{0.261008,0.167915},
{0.260617,0.148584},
{0.257479,0.148551},
{0.257861,0.168092},
{0.258262,0.182876},
{0.263617,0.189748},
{0.270462,0.191963},
{0.269736,0.190223},
{0.2771,0.1773},
{0.273987,0.168914},
{0.2772,0.167328},
{0.277515,0.147614},
{0.273847,0.148019},
{0.273979,0.120443},
{0.278382,0.120823},
{0.270347,0.147125},
{0.266907,0.147225},
{0.263848,0.147457},
{0.257288,0.126287},
{0.252716,0.128534},
{0.250102,0.151006},
{0.2462,0.130644},
{0.246273,0.11716},
{0.2355,0.1058},
{0.232355,0.089848},
{0.264259,0.169917},
{0.268517,0.17197},
{0.269593,0.168654},
{0.225271,0.168245},
{0.225115,0.145681},
{0.223373,0.145572},
{0.223401,0.168109},
{0.2233,0.1764},
{0.226516,0.186178},
{0.229124,0.187744},
{0.232712,0.186273},
{0.2366,0.168008},
{0.234525,0.168868},
{0.2364,0.1559},
{0.23658,0.145602},
{0.234098,0.145763},
{0.2363,0.131684},
{0.236564,0.12982},
{0.237111,0.131478},
{0.237452,0.14793},
{0.240304,0.149361},
{0.240605,0.172453},
{0.238084,0.171145},
{0.238248,0.185344},
{0.243061,0.191047},
{0.24682,0.192245},
{0.248398,0.173307},
{0.252086,0.189331},
{0.254866,0.188382},
{0.255375,0.171519},
{0.252554,0.172708},
{0.253196,0.149352},
{0.256267,0.148572},
{0.2559,0.13404},
{0.256449,0.131813},
{0.226963,0.168389},
{0.227202,0.145639},
{0.229955,0.168484},
{0.232891,0.168519},
{0.231527,0.145567},
{0.233748,0.120933},
{0.242209,0.125541},
{0.242809,0.15175},
{0.2427,0.173179},
{0.248291,0.155559},
{0.189119,0.1579},
{0.190148,0.150751},
{0.180731,0.150759},
{0.180901,0.1444},
{0.190058,0.136068},
{0.179959,0.136213},
{0.229952,0.132449},
{0.230937,0.111816},
{0.235075,0.113453},
{0.246229,0.150681},
{0.212096,0.155922},
{0.213319,0.138426},
{0.210145,0.137648},
{0.2106,0.153958},
{0.208191,0.136613},
{0.206184,0.116434},
{0.209134,0.11494},
{0.212787,0.117528},
{0.218003,0.138172},
{0.216436,0.155936},
{0.21731,0.17485},
{0.212807,0.175182},
{0.20955,0.168156},
{0.2088,0.153767},
{0.197472,0.1598},
{0.20345,0.162752},
{0.202956,0.152885},
{0.19552,0.153002},
{0.194306,0.136264},
{0.204284,0.135902},
{0.195192,0.118827},
{0.209969,0.103409},
{0.214676,0.110977},
{0.220206,0.118753},
{0.222182,0.123901},
{0.22007,0.137424},
{0.219696,0.153487},
{0.221,0.153481},
{0.221,0.1601},
{0.216435,0.177854},
{0.19976,0.16723},
{0.221869,0.136946},
{0.167471,0.152662},
{0.1698,0.1556},
{0.172819,0.151389},
{0.173283,0.14362},
{0.164681,0.143743},
{0.163972,0.131508},
{0.174214,0.131051},
{0.222098,0.110117},
{0.226313,0.119235},
{0.2174,0.103261},
{0.222268,0.126295},
{0.223408,0.127},
{0.211035,0.067449},
{0.217657,0.067705},
{0.7365,0.2515},
{0.751475,0.262055},
{0.751135,0.245947},
{0.7363,0.2354},
{0.7387,0.2147},
{0.7264,0.2312},
{0.7163,0.2047},
{0.700307,0.242637},
{0.691119,0.219482},
{0.680861,0.262567},
{0.694599,0.275588},
{0.6793,0.2829},
{0.6659,0.2683},
{0.6634,0.2806},
{0.646762,0.265334},
{0.6632,0.251},
{0.679363,0.262882},
{0.672002,0.218091},
{0.651124,0.214279},
{0.636927,0.235852},
{0.633792,0.271647},
{0.625928,0.237113},
{0.625,0.2624},
{0.612169,0.25999},
{0.614289,0.244554},
{0.083399,0.353454},
{0.0906,0.3673},
{0.1083,0.3647},
{0.098,0.346},
{0.11622,0.367961},
{0.1052,0.3779},
{0.08757,0.379985},
{0.068795,0.368472},
{0.059323,0.346514},
{0.064523,0.404576},
{0.067606,0.393346},
{0.0503,0.397},
{0.055332,0.407945},
{0.086461,0.411214},
{0.082126,0.426931},
{0.085309,0.450133},
{0.092652,0.434095},
{0.095916,0.434286},
{0.100007,0.421499},
{0.107505,0.411324},
{0.12558,0.39274},
{0.0994,0.3903},
{0.12115,0.357803},
{0.142484,0.38608},
{0.161614,0.383077},
{0.175396,0.363703},
{0.188971,0.381735},
{0.1859,0.3873},
{0.050641,0.38374},
{0.04587,0.365609},
{0.0412,0.3995},
{0.0469,0.3553},
{0.5665,0.0465},
{0.7102,0.0074},
{0.70536,0.010571},
{0.712282,0.015346},
{0.706836,0.036865},
{0.695756,0.011843},
{0.699193,0.046004},
{0.686971,0.016426},
{0.6908,0.0074},
{0.6412,0.3139},
{0.6333,0.3075},
{0.631,0.3164},
{0.6329,0.322},
{0.6378,0.327},
{0.6461,0.3262},
{0.6423,0.3278},
{0.664924,0.072381},
{0.667514,0.043156},
{0.656282,0.069726},
{0.6557,0.0882},
{0.645817,0.086146},
{0.658579,0.016654},
{0.66314,0.015981},
{0.669411,0.015773},
{0.676662,0.05071},
{0.6754,0.0874},
{0.665514,0.10947},
{0.655344,0.101688},
{0.645,0.1011},
{0.634571,0.100431},
{0.652962,0.015959},
{0.6516,0.0059},
{0.6584,0.006},
{0.677247,0.013254},
{0.687301,0.065708},
{0.68666,0.097738},
{0.675378,0.105285},
{0.6747,0.1137},
{0.675001,0.121741},
{0.665211,0.154131},
{0.656661,0.15466},
{0.6484,0.1318},
{0.645724,0.112435},
{0.6358,0.1101},
{0.637,0.1152},
{0.6373,0.121101},
{0.6472,0.1528},
{0.635767,0.152712},
{0.643227,0.17819},
{0.6312,0.1788},
{0.6411,0.1925},
{0.629,0.1874},
{0.700924,0.07548},
{0.6999,0.0983},
{0.6869,0.1068},
{0.6867,0.114697},
{0.6888,0.1291},
{0.6775,0.1528},
{0.67965,0.168861},
{0.6805,0.1941},
{0.6647,0.1943},
{0.6542,0.195},
{0.736093,0.314679},
{0.7372,0.3263},
{0.7467,0.3239},
{0.7522,0.3105},
{0.7504,0.2949},
{0.7694,0.2916},
{0.772322,0.279289},
{0.743516,0.275518},
{0.7642,0.2621},
{0.7708,0.2621},
{0.771426,0.267372},
{0.6607,0.3033},
{0.6585,0.3185},
{0.679,0.3188},
{0.679396,0.295037},
{0.697306,0.299365},
{0.6988,0.3244},
{0.719841,0.322499},
{0.7174,0.3034},
{0.7263,0.3269},
{0.438108,0.446272},
{0.4387,0.4675},
{0.4299,0.4782},
{0.445647,0.44281},
{0.436855,0.446698},
{0.4374,0.4659},
{0.4297,0.4753},
{0.4525,0.4195},
{0.436825,0.419076},
{0.427229,0.401241},
{0.416767,0.397373},
{0.4282,0.3748},
{0.6284,0.29},
{0.6065,0.2873},
{0.6115,0.2938},
{0.621581,0.30473},
{0.644071,0.291512},
{0.6463,0.2807},
{0.6616,0.2921},
{0.75464,0.256635},
{0.756615,0.247357},
{0.7384,0.2662},
{0.7227,0.2653},
{0.729855,0.285807},
{0.714065,0.28975},
{0.7071,0.2664},
{0.7219,0.2474},
{0.6315,0.2799},
{0.608351,0.275544},
{0.616251,0.2708},
{0.5982,0.2683},
{0.5909,0.2642},
{0.5977,0.2724},
{0.4167,0.3993},
{0.710208,0.192564},
{0.7295,0.1882},
{0.720871,0.163923},
{0.704341,0.160555},
{0.718,0.1282},
{0.734108,0.152667},
{0.7395,0.1781},
{0.7424,0.1863},
{0.7316,0.121501},
{0.7134,0.1219},
{0.7128,0.1169},
{0.732,0.1158},
{0.712,0.1098},
{0.7325,0.1101},
{0.714,0.0992},
{0.733244,0.099922},
{0.714818,0.085634},
{0.690783,0.163619},
{0.6922,0.193},
{0.7018,0.1286},
{0.701866,0.115761},
{0.7017,0.1083},
{0.072,0.46091},
{0.0779,0.4006},
{0.445126,0.425637},
{0.445014,0.433529},
{0.185833,0.164846},
{0.157887,0.131284},
{0.7145,0.0073},
{0.29366,0.459651},
{0.3074,0.4033},
{0.3074,0.4615},
{0.2936,0.4615},
{0.273556,0.462304},
{0.2736,0.4611},
{0.253387,0.461342},
{0.2534,0.4615},
{0.2287,0.4033},
{0.2287,0.4522},
{0.2049,0.450997},
{0.2049,0.4522},
{0.1838,0.4033},
{0.1838,0.4522},
{0.155694,0.4033},
{0.1691,0.4522},
{0.1557,0.4564},
{0.1355,0.4033},
{0.1355,0.4607},
{0.3287,0.4033},
{0.3287,0.4615},
{0.156321,0.486447},
{0.1557,0.5138},
{0.1691,0.5138},
{0.1838,0.4846},
{0.1838,0.5138},
{0.2049,0.5138},
{0.2049,0.4873},
{0.2287,0.4878},
{0.2287,0.5138},
{0.2534,0.5138},
{0.2534,0.4872},
{0.2757,0.5142},
{0.2744,0.4924},
{0.2955,0.5138},
{0.2955,0.4912},
{0.3074,0.5138},
{0.3081,0.4899},
{0.3287,0.4781},
{0.3287,0.5138},
{0.1355,0.4781},
{0.1355,0.5138},
{0.1355,0.4607},
{0.158049,0.455664},
{0.1838,0.4522},
{0.2287,0.4522},
{0.2287,0.4748},
{0.3074,0.4615},
{0.3287,0.4615},
{0.7428,0.5347},
{0.7571,0.537452},
{0.744841,0.526739},
{0.769083,0.527911},
{0.7708,0.536},
{0.7771,0.5181},
{0.768251,0.49946},
{0.7727,0.5033},
{0.772,0.4923},
{0.769083,0.527911},
{0.7708,0.536},
{0.7571,0.537452},
{0.744842,0.526741},
{0.7428,0.5347},
{0.7381,0.5196},
{0.7406,0.5111},
{0.9056,0.4435},
{0.9056,0.4472},
{0.928299,0.436512},
{0.9203,0.4358},
{0.951567,0.435407},
{0.957069,0.442493},
{0.939043,0.471432},
{0.90592,0.470474},
{0.8688,0.4591},
{0.8688,0.477034},
{0.8431,0.4591},
{0.8431,0.475628},
{0.8688,0.5028},
{0.8431,0.5028},
{0.8688,0.4554},
{0.8431,0.4554},
{0.8688,0.4554},
{0.8688,0.4591},
{0.9056,0.4435},
{0.9056,0.4472},
{0.928613,0.433939},
{0.932226,0.435769},
{0.965827,0.443025},
{0.960194,0.444829},
{0.9967,0.4552},
{0.9967,0.459},
{0.9665,0.4434},
{0.7691,0.527861},
{0.7708,0.536},
{0.7571,0.537464},
{0.744843,0.526743},
{0.7428,0.5347},
{0.7381,0.5196},
{0.7406,0.5111},
{0.7428,0.5347},
{0.7571,0.537464},
{0.744843,0.526743},
{0.7691,0.52786},
{0.7708,0.536},
{0.7771,0.5181},
{0.768288,0.499872},
{0.7727,0.5033},
{0.772,0.4923},
{0.0302,0.3936},
{0.7454,0.5033},
{0.7406,0.5111},
{0.7381,0.5196},
{0.7454,0.5033},
{0.768251,0.499462},
{0.746,0.4923},
{0.72775,0.503298},
{0.727143,0.4923},
{0.722202,0.498201},
{0.729547,0.509361},
{0.928745,0.51463},
{0.948607,0.513331},
{0.933536,0.50722},
{0.9054,0.5028},
{0.928334,0.487472},
{0.954023,0.496135},
{0.9663,0.5016},
{0.967057,0.474833},
{0.9967,0.5016},
{0.9967,0.477544},
{0.8688,0.478366},
{0.90614,0.473927},
{0.935095,0.471379},
{0.963995,0.477225},
{0.963994,0.503606},
{0.947917,0.504508},
{0.939806,0.515124},
{0.92546,0.513774},
{0.927767,0.519655},
{0.957737,0.515103},
{0.9662,0.5072},
{0.9967,0.5072},
{0.908365,0.504568},
{0.918568,0.491816},
{0.905763,0.509711},
{0.8688,0.5028},
{0.9358,0.4893},
{0.0402,0.4032},
{0.7454,0.5033},
{0.768288,0.49987},
{0.746,0.492272},
{0.727425,0.492301},
{0.727661,0.5033},
{0.722195,0.498198},
{0.730425,0.486189},
{0.739509,0.482693},
{0.744389,0.4385},
{0.7454,0.5033},
{0.7406,0.5111},
{0.7381,0.5196},
{0.0496,0.3998},
{0.729553,0.509362},
{0.727751,0.503298},
{0.722202,0.498201},
{0.727143,0.4923},
{0.746,0.4923},
{0.8688,0.5095},
{0.8431,0.5095},
{0.9054,0.5095},
{0.918651,0.516753},
{0.9358,0.5207},
{0.953142,0.517336},
{0.9664,0.5072},
{0.8688,0.5095},
{0.72923,0.50931},
{0.729214,0.509309},
{0.727663,0.5033},
{0.722195,0.498198},
{0.730527,0.486201},
{0.7395,0.4827},
{0.730526,0.486201},
{0.7395,0.4827},
{0.7676,0.442453},
{0.746,0.3965},
{0.7428,0.3965},
{0.746,0.3548},
{0.7428,0.3548},
{0.769762,0.3965},
{0.769813,0.3548},
{0.7676,0.4802},
{0.744487,0.4802},
{0.746,0.4385},
{0.769604,0.4385},
{0.772,0.4802},
{0.746,0.3965},
{0.769768,0.3965},
{0.727424,0.492301},
{0.746,0.492272},
{0.744389,0.4385},
{0.7676,0.442449},
{0.746,0.3965},
{0.769762,0.3965},
{0.772,0.442892},
{0.746,0.3548},
{0.769813,0.3548},
{0.7676,0.4802},
{0.744487,0.4802},
{0.746,0.4385},
{0.7428,0.418899},
{0.746,0.3965},
{0.7428,0.3548},
{0.769604,0.4385},
{0.769768,0.3965},
{0.730425,0.486189},
{0.739509,0.482693},
{0.7771,0.5181},
{0.7727,0.5033},
{0.772,0.4923},
{0.772,0.442896},
{0.7771,0.5181},
{0.7727,0.5033},
{0.772,0.4923},
{0.772,0.4802},
{0.746,0.4385},
{0.746,0.492266},
{0.7676,0.442896},
{0.746,0.3965},
{0.7676,0.3965},
{0.746,0.3548},
{0.7676,0.3548},
{0.746,0.4923},
{0.7676,0.4802},
{0.7676,0.4923},
{0.746,0.418905},
{0.7676,0.4385},
{0.746,0.4802},
{0.7676,0.3965},
{0.7676,0.4923},
{0.7676,0.442892},
{0.7676,0.4923},
{0.746,0.492266},
{0.746,0.4385},
{0.746,0.3965},
{0.7676,0.3965},
{0.746,0.3548},
{0.7676,0.3548},
{0.7676,0.4802},
{0.746,0.4802},
{0.746,0.4923},
{0.7676,0.4923},
{0.746,0.418899},
{0.7676,0.4385},
{0.7676,0.3965},
{0.7428,0.418905},
{0.7428,0.3965},
{0.0802,0.4703},
{0.0779,0.4634},
{0.0751,0.461101},
{0.876034,0.944537},
{0.860648,0.950262},
{0.86684,0.906059},
{0.925195,0.919977},
{0.899184,0.886841},
{0.9824,0.9226},
{0.9758,0.8819},
{0.866839,0.906058},
{0.8491,0.9201},
{0.876036,0.944534},
{0.889853,0.973392},
{0.912522,0.950893},
{0.9607,0.992},
{0.978992,0.946895},
{0.91753,0.937479},
{0.923561,0.920218},
{0.9824,0.9226},
{0.899906,0.886669},
{0.9758,0.8819},
{0.978716,0.948061},
{0.918028,0.937447},
{0.912745,0.950897},
{0.840733,0.99242},
{0.83172,0.9938},
{0.838917,0.9705},
{0.829581,0.937116},
{0.824392,0.94028},
{0.815699,0.994228},
{0.814667,0.936095},
{0.805167,0.940694},
{0.800183,0.994444},
{0.791257,0.971505},
{0.791017,0.993701},
{0.788544,0.956166},
{0.799417,0.937517},
{0.808071,0.920471},
{0.814697,0.924918},
{0.827084,0.923895},
{0.944608,0.820844},
{0.942371,0.857502},
{0.986109,0.856369},
{0.974164,0.798565},
{0.957692,0.795632},
{0.797793,0.868583},
{0.8269,0.9088},
{0.839049,0.854952},
{0.83541,0.834029},
{0.879672,0.833698},
{0.870236,0.844383},
{0.868539,0.894524},
{0.908022,0.841577},
{0.888969,0.837223},
{0.866531,0.837143},
{0.8648,0.858},
{0.83905,0.854953},
{0.797792,0.868581},
{0.835425,0.834027},
{0.7932,0.8496},
{0.827404,0.803592},
{0.794,0.8217},
{0.885698,0.800121},
{0.9154,0.8141},
{0.885663,0.800114},
{0.7932,0.8496},
{0.827391,0.803596},
{0.794,0.8217},
{0.261539,0.775717},
{0.264869,0.76925},
{0.261116,0.790562},
{0.247504,0.780708},
{0.249709,0.819687},
{0.272919,0.792611},
{0.277985,0.738319},
{0.260765,0.737541},
{0.255903,0.747595},
{0.252979,0.759688},
{0.254692,0.768577},
{0.250804,0.769949},
{0.243692,0.771388},
{0.2436,0.781445},
{0.240539,0.819583},
{0.248324,0.835567},
{0.275094,0.822572},
{0.312395,0.813542},
{0.298921,0.785984},
{0.317827,0.781615},
{0.301608,0.745243},
{0.282073,0.724054},
{0.275847,0.730161},
{0.271488,0.731222},
{0.251263,0.731758},
{0.242352,0.734028},
{0.237644,0.745716},
{0.244727,0.75583},
{0.250965,0.766039},
{0.24165,0.762393},
{0.236395,0.766955},
{0.238873,0.773016},
{0.239635,0.78071},
{0.22608,0.790654},
{0.216621,0.793927},
{0.215187,0.823704},
{0.234142,0.83502},
{0.240751,0.857369},
{0.253904,0.863658},
{0.2725,0.835008},
{0.27814,0.828357},
{0.287087,0.824116},
{0.305648,0.823399},
{0.324974,0.825644},
{0.230338,0.897896},
{0.23462,0.879822},
{0.263641,0.886911},
{0.242809,0.947861},
{0.266789,0.953651},
{0.28852,0.89422},
{0.293394,0.865558},
{0.194114,0.866775},
{0.195062,0.900867},
{0.219595,0.956661},
{0.256007,0.992706},
{0.313545,0.98974},
{0.294333,0.937689},
{0.33799,0.879576},
{0.324022,0.863296},
{0.315603,0.856401},
{0.292624,0.855279},
{0.449096,0.694813},
{0.4419,0.697413},
{0.445458,0.691111},
{0.453143,0.690441},
{0.450221,0.687793},
{0.46123,0.682972},
{0.473282,0.691506},
{0.459727,0.6834},
{0.452825,0.690443},
{0.450188,0.687824},
{0.444803,0.691791},
{0.448793,0.695327},
{0.433655,0.708588},
{0.433424,0.701941},
{0.287243,0.827896},
{0.282826,0.829115},
{0.297867,0.827299},
{0.3049,0.8271},
{0.3114,0.8273},
{0.3179,0.8286},
{0.331119,0.834876},
{0.340813,0.831064},
{0.357673,0.831238},
{0.343795,0.779444},
{0.32248,0.758107},
{0.302648,0.720604},
{0.278682,0.692433},
{0.263473,0.699952},
{0.265105,0.72179},
{0.273423,0.730126},
{0.3986,0.5621},
{0.4111,0.5597},
{0.417487,0.600189},
{0.4369,0.5969},
{0.4251,0.5551},
{0.462038,0.542578},
{0.459007,0.607464},
{0.4731,0.5865},
{0.481132,0.631342},
{0.4682,0.6453},
{0.4476,0.6311},
{0.448235,0.658719},
{0.43274,0.639317},
{0.432424,0.671301},
{0.399043,0.661286},
{0.4265,0.6958},
{0.432986,0.756161},
{0.399535,0.689104},
{0.373621,0.733186},
{0.380653,0.774163},
{0.445041,0.824883},
{0.396125,0.838742},
{0.397648,0.888839},
{0.356875,0.898708},
{0.400435,0.961793},
{0.475717,0.949883},
{0.369624,0.653527},
{0.342323,0.681439},
{0.32286,0.719746},
{0.302168,0.682589},
{0.26227,0.667126},
{0.255717,0.685574},
{0.243055,0.687913},
{0.247737,0.711702},
{0.245939,0.722209},
{0.241202,0.729221},
{0.239533,0.730768},
{0.220472,0.726396},
{0.21298,0.730154},
{0.211147,0.730292},
{0.215761,0.731337},
{0.209147,0.733954},
{0.229683,0.736311},
{0.232442,0.732061},
{0.458422,0.717771},
{0.4502,0.7056},
{0.464644,0.709092},
{0.469318,0.725413},
{0.473432,0.714493},
{0.485266,0.71867},
{0.472813,0.700911},
{0.457966,0.700318},
{0.438038,0.723345},
{0.468518,0.743444},
{0.4841,0.7352},
{0.486221,0.721585},
{0.474586,0.700647},
{0.482081,0.699464},
{0.21746,0.55036},
{0.204747,0.542374},
{0.225671,0.543799},
{0.2395,0.558},
{0.246135,0.547633},
{0.223732,0.512087},
{0.209626,0.52435},
{0.195543,0.530167},
{0.1828,0.5391},
{0.188,0.551},
{0.205833,0.559579},
{0.22235,0.588182},
{0.24594,0.584435},
{0.259607,0.566182},
{0.2719,0.5539},
{0.256,0.5222},
{0.22496,0.53708},
{0.20444,0.52784},
{0.1828,0.5391},
{0.1757,0.526},
{0.1696,0.5487},
{0.164,0.536},
{0.2726,0.5801},
{0.271795,0.592649},
{0.288872,0.586441},
{0.2854,0.5699},
{0.2814,0.5416},
{0.2586,0.5941},
{0.234222,0.759755},
{0.23251,0.768626},
{0.222281,0.769574},
{0.225663,0.775769},
{0.115993,0.632832},
{0.10378,0.673683},
{0.087512,0.66298},
{0.068897,0.599975},
{0.051481,0.637671},
{0.054496,0.670957},
{0.0607,0.6958},
{0.054213,0.756178},
{0.111131,0.743796},
{0.129586,0.699882},
{0.164974,0.663307},
{0.154545,0.63618},
{0.134875,0.594243},
{0.1123,0.595},
{0.080294,0.560549},
{0.0502,0.5969},
{0.027598,0.609836},
{0.0189,0.6453},
{0.039435,0.65901},
{0.062,0.5552},
{0.0423,0.5485},
{0.0239,0.5426},
{0.0142,0.5864},
{0.005968,0.631342},
{0.1268,0.5532},
{0.1405,0.5488},
{0.149339,0.586268},
{0.162578,0.580174},
{0.155,0.5459},
{0.178076,0.619326},
{0.219687,0.651136},
{0.2015,0.6328},
{0.229935,0.665644},
{0.278682,0.650434},
{0.333464,0.636453},
{0.309123,0.619326},
{0.345728,0.612074},
{0.324522,0.58022},
{0.343742,0.583083},
{0.338621,0.547361},
{0.3604,0.5532},
{0.3804,0.5593},
{0.3746,0.595},
{0.1066,0.5589},
{0.228616,0.683128},
{0.20496,0.690243},
{0.208224,0.703908},
{0.231113,0.695544},
{0.229642,0.712553},
{0.232141,0.722558},
{0.207776,0.728127},
{0.188576,0.734931},
{0.171865,0.778767},
{0.21788,0.7422},
{0.165237,0.756618},
{0.143573,0.778229},
{0.129531,0.831265},
{0.162225,0.825662},
{0.175122,0.813446},
{0.192918,0.790272},
{0.451084,0.710397},
{0.460942,0.718823},
{0.473431,0.714491},
{0.464788,0.708877},
{0.457892,0.700212},
{0.091721,0.834667},
{0.089527,0.888838},
{0.130311,0.89872},
{0.149169,0.879579},
{0.163172,0.863317},
{0.149686,0.839153},
{0.146389,0.83115},
{0.15608,0.834965},
{0.18152,0.823453},
{0.204477,0.819567},
{0.156115,0.734807},
{0.042159,0.824912},
{0.180471,0.720642},
{0.167509,0.713052},
{0.189331,0.827299},
{0.1823,0.8272},
{0.1758,0.8273},
{0.1692,0.8286},
{0.1644,0.8303},
{0.160526,0.835557},
{0.167092,0.84804},
{0.173435,0.847938},
{0.187342,0.852154},
{0.184,0.8511},
{0.1895,0.8499},
{0.1946,0.8468},
{0.206569,0.839606},
{0.203956,0.834848},
{0.209123,0.82755},
{0.204375,0.829112},
{0.19989,0.827961},
{0.214708,0.835347},
{0.204096,0.849147},
{0.189893,0.855424},
{0.171602,0.856403},
{0.150322,0.949005},
{0.195596,0.951916},
{0.173665,0.989741},
{0.2184,0.9923},
{0.204745,0.542374},
{0.2264,0.5501},
{0.245849,0.548255},
{0.2395,0.558},
{0.218237,0.551347},
{0.207427,0.558229},
{0.195124,0.562495},
{0.192524,0.582427},
{0.177239,0.56824},
{0.22235,0.588182},
{0.184879,0.592729},
{0.181591,0.581333},
{0.245232,0.58562},
{0.2408,0.6055},
{0.2243,0.6047},
{0.212256,0.606711},
{0.193409,0.604046},
{0.2854,0.5699},
{0.262228,0.563488},
{0.2726,0.5801},
{0.288874,0.58644},
{0.271686,0.592547},
{0.2545,0.5718},
{0.2966,0.5609},
{0.3066,0.5779},
{0.3041,0.5958},
{0.28883,0.600172},
{0.2586,0.5941},
{0.08682,0.961638},
{0.1196,0.9855},
{0.306943,0.592551},
{0.288827,0.600172},
{0.014161,0.945304},
{0.33688,0.949005},
{0.337522,0.839066},
{0.320107,0.847976},
{0.294481,0.8507},
{0.326674,0.835559},
{0.313769,0.847906},
{0.3032,0.8511},
{0.2977,0.8499},
{0.2926,0.8468},
{0.283234,0.834799},
{0.3676,0.9855},
{0.184878,0.592729},
{0.191999,0.582664},
{0.193407,0.604046},
{0.212256,0.606711},
{0.2243,0.6047},
{0.2408,0.6055},
{0.177107,0.567837},
{0.181667,0.581583},
{0.1696,0.5487},
{0.3228,0.8302},
{0.026829,0.671915},
{0.027432,0.670834},
{0.017559,0.671329},
{0.013662,0.675221},
{0.009895,0.682296},
{0.014024,0.668674},
{0.029567,0.670919},
{0.043902,0.691086},
{0.00352,0.695279},
{0.00731,0.675787},
{0.037224,0.669429},
{0.056973,0.710371},
{0.0456,0.6909},
{0.0483,0.7092},
{0.0464,0.7084},
{0.00994,0.711337},
{0.005469,0.71179},
{0.019383,0.73473},
{0.016062,0.721423},
{0.0363,0.7264},
{0.04261,0.734031},
{0.019883,0.719335},
{0.0357,0.7216},
{0.0317,0.7933},
{0.0177,0.7946},
{0.0179,0.7676},
{0.009984,0.777573},
{0.009015,0.767717},
{0.011012,0.755952},
{0.014289,0.750956},
{0.027001,0.752126},
{0.0393,0.7769},
{0.003521,0.695275},
{0.00731,0.675788},
{0.009895,0.682295},
{0.014024,0.668674},
{0.017559,0.671329},
{0.029566,0.67092},
{0.037221,0.669429},
{0.056973,0.710371},
{0.0456,0.6909},
{0.0483,0.7092},
{0.04261,0.734031},
{0.0363,0.7264},
{0.019383,0.734731},
{0.016063,0.721423},
{0.009939,0.71134},
{0.005469,0.71179},
{0.043902,0.691086},
{0.013662,0.675221},
{0.026829,0.671916},
{0.027432,0.670834},
{0.0464,0.7084},
{0.0357,0.7216},
{0.019882,0.719335},
{0.0179,0.7676},
{0.0177,0.7946},
{0.0317,0.7933},
{0.0393,0.7769},
{0.026999,0.752127},
{0.014289,0.750956},
{0.011012,0.755953},
{0.009015,0.767714},
{0.009984,0.777573},
{0.473579,0.764606},
{0.4786,0.7559},
{0.478433,0.755939},
{0.477289,0.755679},
{0.4786,0.7559},
{0.473505,0.764738},
{0.473257,0.765172},
{0.455748,0.753925},
{0.464797,0.76561},
{0.463935,0.765636},
{0.464,0.7531},
{0.455,0.754},
{0.2617,0.6558},
{0.2081,0.6558},
{0.1945,0.5495},
{0.2771,0.5495},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2617,0.7152},
{0.2081,0.7152},
{0.2617,0.70726},
{0.2081,0.7152},
{0.2081,0.6837},
{0.2617,0.6558},
{0.2081,0.6558},
{0.2617,0.7152},
{0.2081,0.708061},
{0.2617,0.6837},
{0.2617,0.6558},
{0.2081,0.696912},
{0.2617,0.6558},
{0.2617,0.708061},
{0.2081,0.6558},
{0.2617,0.6558},
{0.2081,0.6558},
{0.2617,0.719131},
{0.2081,0.6558},
{0.2081,0.714593},
{0.2617,0.6558},
{0.2081,0.6558},
{0.262948,0.704792},
{0.2617,0.6558},
{0.2081,0.6558},
{0.2081,0.707193},
{0.2081,0.690379},
{0.2617,0.6558},
{0.2617,0.696912},
{0.2081,0.6558},
{0.217511,0.695744},
{0.2617,0.6558},
{0.2617,0.692322},
{0.2081,0.6558},
{0.2081,0.692322},
{0.2617,0.6558},
{0.2617,0.696503},
{0.2081,0.6558},
{0.2081,0.696503},
{0.2617,0.690379},
{0.2081,0.6558},
{0.2617,0.6558},
{0.1945,0.5495},
{0.2081,0.6558},
{0.1945,0.5495},
{0.2771,0.5495},
{0.1945,0.5495},
{0.1945,0.5495},
{0.2771,0.5495},
{0.2771,0.5495},
{0.1945,0.5495},
{0.2771,0.5495},
{0.1945,0.5495},
{0.2771,0.5495},
{0.2771,0.5495},
{0.1945,0.5495},
{0.233822,0.5495},
{0.2081,0.6837},
{0.2081,0.7152},
{0.2617,0.706563},
{0.2617,0.6558},
{0.2081,0.6558},
{0.2081,0.6837},
{0.2081,0.7152},
{0.2617,0.7152},
{0.2617,0.6837},
{0.2617,0.6558},
{0.2081,0.6558},
{0.2771,0.5495},
{0.1945,0.5495},
{0.2081,0.705158},
{0.2617,0.7152},
{0.2617,0.6837},
{0.2617,0.6558},
{0.2081,0.6558},
{0.2617,0.6558},
{0.2081,0.6558},
{0.2081,0.69631},
{0.2617,0.705158},
{0.2617,0.715573},
{0.2081,0.6558},
{0.2617,0.6558},
{0.2081,0.6558},
{0.2617,0.6558},
{0.2617,0.705123},
{0.2081,0.715573},
{0.2081,0.6558},
{0.2081,0.706903},
{0.2617,0.6558},
{0.2081,0.6558},
{0.2081,0.690384},
{0.2617,0.69631},
{0.2617,0.6558},
{0.2617,0.6558},
{0.2081,0.6558},
{0.2617,0.696505},
{0.2617,0.6558},
{0.2081,0.6558},
{0.2081,0.696505},
{0.2617,0.690384},
{0.2081,0.6558},
{0.2617,0.6558},
{0.206179,0.714593},
{0.1945,0.5495},
{0.1945,0.5495},
{0.2771,0.5495},
{0.1945,0.5495},
{0.1945,0.5495},
{0.2771,0.5495},
{0.2771,0.5495},
{0.1945,0.5495},
{0.2771,0.5495},
{0.1945,0.5495},
{0.2771,0.5495},
{0.1945,0.5495},
{0.2771,0.5495},
{0.1945,0.5495},
{0.2771,0.5495},
{0.1945,0.5495},
{0.2771,0.5495},
{0.2771,0.5495},
{0.1945,0.5495},
{0.2617,0.6837},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2081,0.6837},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2081,0.6837},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2081,0.6558},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2771,0.5495},
{0.208839,0.6837},
{0.2617,0.6837},
{0.231018,0.6837},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2771,0.5495},
{0.2771,0.5495},
{0.1945,0.5495},
{0.2771,0.5495},
{0.2771,0.5495},
{0.1945,0.5495},
{0.2771,0.5495},
{0.1945,0.5495},
{0.1945,0.5495},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2617,0.6837},
{0.2081,0.6837},
{0.2771,0.5495},
{0.1945,0.5495},
{0.2617,0.6837},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2081,0.6837},
{0.2617,0.6837},
{0.2081,0.6837},
{0.2771,0.5495},
{0.1945,0.5495},
{0.338802,0.100785},
{0.410483,0.036976},
{0.270757,0.02049},
{0.249534,0.085905},
{0.163864,0.090587},
{0.152704,0.03661},
{0.114182,0.094189},
{0.0825,0.0485},
{0.270498,0.020527},
{0.41045,0.036953},
{0.338803,0.100783},
{0.248169,0.085843},
{0.15253,0.036578},
{0.164173,0.090537},
{0.11418,0.094187},
{0.0825,0.0485},
{0.401089,0.131503},
{0.401129,0.131523},
{0.506432,0.167206},
{0.419208,0.188915},
{0.506429,0.167207},
{0.419208,0.188913},
{0.474525,0.10198},
{0.474506,0.101956},
{0.220672,0.408176},
{0.2048,0.386},
{0.196905,0.389906},
{0.21491,0.413822},
{0.234597,0.420249},
{0.234335,0.430019},
{0.2565,0.4355},
{0.261122,0.424306},
{0.2699,0.4347},
{0.2815,0.4211},
{0.293846,0.427199},
{0.303392,0.409827},
{0.315457,0.412746},
{0.318166,0.393112},
{0.3349,0.3916},
{0.304727,0.369643},
{0.314162,0.383267},
{0.28742,0.372147},
{0.272018,0.364566},
{0.251785,0.370256},
{0.230717,0.364883},
{0.220999,0.372643},
{0.215369,0.36755},
{0.2022,0.3791},
{0.1992,0.3728},
{0.220676,0.408181},
{0.196906,0.389907},
{0.2048,0.386},
{0.21538,0.367546},
{0.221006,0.372642},
{0.2022,0.3791},
{0.1992,0.3728},
{0.251736,0.370256},
{0.2307,0.364884},
{0.272015,0.364564},
{0.287389,0.372142},
{0.304728,0.369643},
{0.314129,0.383242},
{0.318165,0.393114},
{0.3349,0.3916},
{0.315457,0.412746},
{0.303398,0.409821},
{0.293855,0.427195},
{0.2815,0.4211},
{0.2699,0.4347},
{0.261116,0.424307},
{0.2565,0.4355},
{0.234607,0.420253},
{0.234365,0.430036},
{0.214894,0.4138},
{0.1981,0.23},
{0.1509,0.2289},
{0.278318,0.272804},
{0.2686,0.2438},
{0.3306,0.2479},
{0.1473,0.253},
{0.2048,0.2832},
{0.2587,0.2181},
{0.3126,0.2175},
{0.356882,0.162101},
{0.378078,0.130828},
{0.388,0.1861},
{0.4085,0.1525},
{0.35,0.1168},
{0.334423,0.146388},
{0.1053,0.1987},
{0.0934,0.2157},
{0.1431,0.2726},
{0.0854,0.2346},
{0.0808,0.1745},
{0.057,0.1377},
{0.045481,0.113014},
{0.034829,0.160324},
{0.0129,0.1282},
{0.197569,0.229988},
{0.2587,0.2181},
{0.32813,0.250359},
{0.301527,0.19277},
{0.3779,0.1311},
{0.35,0.1168},
{0.192207,0.280499},
{0.2783,0.2728},
{0.081155,0.175673},
{0.1053,0.1987},
{0.0854,0.2346},
{0.034806,0.160285},
{0.012975,0.128171},
{0.0455,0.113},
{0.057,0.1377},
{0.4085,0.1525},
{0.380572,0.196349},
{0.1981,0.23},
{0.152525,0.229808},
{0.2686,0.2438},
{0.2783,0.2728},
{0.2048,0.2832},
{0.1473,0.253},
{0.1053,0.1987},
{0.3126,0.2175},
{0.2587,0.2181},
{0.2993,0.1953},
{0.368764,0.213338},
{0.3306,0.2479},
{0.3567,0.1624},
{0.3201,0.173},
{0.349924,0.116944},
{0.3779,0.1311},
{0.4085,0.1525},
{0.04439,0.111001},
{0.033841,0.121376},
{0.0934,0.2157},
{0.0854,0.2346},
{0.047503,0.181632},
{0.0129,0.1282},
{0.1431,0.2726},
{0.1509,0.2289},
{0.1981,0.23},
{0.201,0.2569},
{0.2686,0.2438},
{0.2587,0.2181},
{0.3126,0.2175},
{0.3306,0.2479},
{0.3643,0.2188},
{0.3377,0.1925},
{0.388,0.1861},
{0.2686,0.2438},
{0.2993,0.1953},
{0.320934,0.171449},
{0.377916,0.131076},
{0.35,0.1168},
{0.2783,0.2728},
{0.3643,0.2188},
{0.085398,0.234605},
{0.1053,0.1987},
{0.1473,0.253},
{0.1431,0.2726},
{0.2048,0.2832},
{0.044395,0.111011},
{0.033839,0.121373},
{0.054849,0.193983},
{0.0129,0.1282},
{0.4085,0.1525},
{0.197565,0.229988},
{0.2587,0.2181},
{0.349301,0.23151},
{0.356909,0.162122},
{0.2993,0.1953},
{0.334208,0.146757},
{0.14367,0.271871},
{0.2783,0.2728},
{0.2048,0.2832},
{0.085452,0.234477},
{0.1053,0.1987},
{0.0808,0.1745},
{0.054848,0.193858},
{0.388,0.1861},
{0.278319,0.272804},
{0.0808,0.1745},
{0.055143,0.1936},
{0.152523,0.229807},
{0.387764,0.18613},
{0.3643,0.2188},
{0.0808,0.1745},
{0.054802,0.193898},
{0.085397,0.234607},
{0.1431,0.2726},
{0.0808,0.1745},
{0.054837,0.193868},
{0.193117,0.28085},
{0.278165,0.272397},
{0.197667,0.22999},
{0.1053,0.1987},
{0.085592,0.234146},
{0.2587,0.2181},
{0.197661,0.22999},
{0.2587,0.2181},
{0.278165,0.272397},
{0.193135,0.280853},
{0.1053,0.1987},
{0.085592,0.234147},
{0.191948,0.229857},
{0.2587,0.2181},
{0.27833,0.272889},
{0.204838,0.28325},
{0.1053,0.1987},
{0.0934,0.2157},
{0.1431,0.2726},
{0.0854,0.2346},
{0.1981,0.23},
{0.1509,0.2289},
{0.204838,0.283231},
{0.278296,0.272787},
{0.2587,0.2181},
{0.1053,0.1987},
{0.0934,0.2157},
{0.1431,0.2726},
{0.0854,0.2346},
{0.0709,0.4008},
{0.0041,0.4008},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.4387},
{0.0041,0.4387},
{0.0709,0.4765},
{0.0041,0.4765},
{0.0709,0.5144},
{0.0041,0.5144},
{0.0709,0.5523},
{0.0041,0.5523},
{0.0709,0.5902},
{0.0041,0.5902},
{0.0709,0.666},
{0.0041,0.666},
{0.0709,0.7417},
{0.0041,0.7417},
{0.0709,0.3896},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.3896},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.500637},
{0.0041,0.4965},
{0.0041,0.5232},
{0.0709,0.645571},
{0.0041,0.645638},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.3896},
{0.0041,0.3896},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.4965},
{0.0041,0.4965},
{0.0709,0.523198},
{0.0041,0.523199},
{0.0709,0.683499},
{0.0041,0.683499},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.403026},
{0.0041,0.404695},
{0.0709,0.456241},
{0.0041,0.457859},
{0.0709,0.49744},
{0.0041,0.497306},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.403015},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.404665},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.481706},
{0.0041,0.482724},
{0.0709,0.736957},
{0.0041,0.736976},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.403237},
{0.0041,0.403389},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.482622},
{0.0041,0.482735},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.576789},
{0.0041,0.576817},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.403292},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.403372},
{0.0709,0.456694},
{0.0041,0.456762},
{0.0709,0.513762},
{0.0041,0.513881},
{0.0709,0.577079},
{0.0041,0.5766},
{0.0041,0.737003},
{0.0709,0.737},
{0.6601,0.561678},
{0.6601,0.4265},
{0.5896,0.4265},
{0.5896,0.572344},
{0.6601,0.694129},
{0.5896,0.704588},
{0.6601,0.996999},
{0.5896,0.996999},
{0.0709,0.426764},
{0.0041,0.434386},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.521165},
{0.0041,0.533372},
{0.0709,0.736999},
{0.0041,0.736999},
{0.0709,0.403175},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.403518},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.482353},
{0.0041,0.482865},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.576578},
{0.0041,0.5766},
{0.0041,0.737},
{0.0709,0.737},
{0.0709,0.403187},
{0.0041,0.403581},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.456584},
{0.0041,0.456951},
{0.0709,0.513863},
{0.0041,0.514652},
{0.0709,0.577932},
{0.0041,0.576705},
{0.0709,0.737001},
{0.0041,0.737},
{0.0709,0.403228},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.3896},
{0.0041,0.4163},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.4965},
{0.0041,0.4965},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.5766},
{0.0041,0.5766},
{0.0709,0.73695},
{0.0041,0.736949},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.40329},
{0.0041,0.403327},
{0.0709,0.456625},
{0.0041,0.456661},
{0.0709,0.4965},
{0.0041,0.4965},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.573475},
{0.0041,0.57499},
{0.0041,0.737},
{0.0709,0.737},
{0.0709,0.403285},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.403332},
{0.0709,0.45663},
{0.0041,0.456704},
{0.0709,0.4965},
{0.0041,0.4965},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.592675},
{0.0041,0.591863},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.7776,0.0034},
{0.7776,0.099122},
{0.8823,0.098466},
{0.8823,0.1521},
{0.7776,0.1521},
{0.8823,0.2017},
{0.7776,0.2017},
{0.8823,0.273488},
{0.7776,0.273476},
{0.8823,0.375577},
{0.7776,0.375557},
{0.8823,0.4497},
{0.7776,0.4497},
{0.8823,0.505521},
{0.7776,0.504784},
{0.8823,0.5984},
{0.7776,0.5984},
{0.8823,0.648},
{0.7776,0.648},
{0.8823,0.6976},
{0.7776,0.6976},
{0.8823,0.7472},
{0.7776,0.7472},
{0.8823,0.7968},
{0.7776,0.7968},
{0.8823,0.893695},
{0.7776,0.895367},
{0.8823,0.9951},
{0.7776,0.9951},
{0.8823,0.0034},
{0.7776,0.0034},
{0.8823,0.0034},
{0.8823,0.103819},
{0.7776,0.104393},
{0.8823,0.169},
{0.7776,0.193257},
{0.8823,0.250715},
{0.7776,0.307651},
{0.8823,0.3347},
{0.8823,0.3899},
{0.7776,0.3899},
{0.8823,0.4451},
{0.7776,0.4451},
{0.8823,0.5003},
{0.7776,0.5003},
{0.8823,0.5555},
{0.7776,0.5555},
{0.8823,0.6108},
{0.7776,0.6108},
{0.8823,0.666},
{0.7776,0.666},
{0.8823,0.7212},
{0.7776,0.7212},
{0.8823,0.7764},
{0.7776,0.7764},
{0.8823,0.8316},
{0.7776,0.8316},
{0.8823,0.900214},
{0.7776,0.900983},
{0.8823,0.9973},
{0.7776,0.9973},
{0.9048,0.0034},
{0.9048,0.053},
{0.9982,0.053},
{0.9982,0.1026},
{0.9048,0.1026},
{0.9982,0.164204},
{0.9048,0.156535},
{0.9048,0.324061},
{0.9982,0.373138},
{0.9048,0.547577},
{0.9982,0.528457},
{0.9982,0.637311},
{0.9048,0.670584},
{0.9982,0.6976},
{0.9982,0.762663},
{0.9048,0.76627},
{0.9982,0.884542},
{0.9048,0.885613},
{0.9982,0.9455},
{0.9048,0.9455},
{0.9982,0.9951},
{0.9048,0.9951},
{0.9982,0.0034},
{0.7776,0.0034},
{0.7776,0.174338},
{0.8823,0.174984},
{0.8823,0.272333},
{0.7776,0.265125},
{0.7776,0.383278},
{0.8823,0.435334},
{0.7776,0.48304},
{0.8823,0.5309},
{0.7776,0.5488},
{0.8823,0.61223},
{0.7776,0.612229},
{0.8823,0.714744},
{0.7776,0.718402},
{0.8823,0.811283},
{0.7776,0.817629},
{0.8823,0.937335},
{0.7776,0.937155},
{0.8823,0.9951},
{0.7776,0.9951},
{0.8823,0.0034},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.3759},
{0.0041,0.3759},
{0.0709,0.4323},
{0.0041,0.4323},
{0.0709,0.4596},
{0.0041,0.4596},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.522557},
{0.0041,0.520819},
{0.0041,0.639303},
{0.0709,0.663781},
{0.0041,0.736998},
{0.0709,0.737},
{0.0709,0.3759},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.3759},
{0.0709,0.4323},
{0.0041,0.4323},
{0.0709,0.4596},
{0.0041,0.4596},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.517692},
{0.0041,0.518434},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.6393},
{0.0041,0.6393},
{0.0709,0.736997},
{0.0041,0.736997},
{0.7776,0.0034},
{0.7776,0.092225},
{0.8823,0.091487},
{0.8823,0.182154},
{0.7776,0.183015},
{0.8823,0.272362},
{0.7776,0.266155},
{0.7776,0.427853},
{0.8823,0.437119},
{0.8823,0.4992},
{0.7776,0.4992},
{0.8823,0.5488},
{0.7776,0.5488},
{0.8823,0.5984},
{0.7776,0.5984},
{0.8823,0.648},
{0.7776,0.648},
{0.8823,0.6976},
{0.7776,0.6976},
{0.8823,0.7472},
{0.7776,0.7472},
{0.8823,0.821378},
{0.7776,0.821412},
{0.8823,0.8959},
{0.7776,0.8959},
{0.8823,0.995099},
{0.7776,0.995097},
{0.8823,0.0034},
{0.9031,0.0034},
{0.9966,0.0034},
{0.9966,0.0719},
{0.9031,0.071706},
{0.9966,0.198481},
{0.9031,0.197225},
{0.9966,0.284261},
{0.9031,0.284506},
{0.9966,0.390157},
{0.9031,0.390838},
{0.9966,0.495481},
{0.9031,0.498443},
{0.9966,0.591906},
{0.9031,0.675128},
{0.9966,0.6832},
{0.9966,0.7355},
{0.9031,0.7355},
{0.9966,0.797388},
{0.9031,0.79898},
{0.9966,0.937585},
{0.9031,0.937948},
{0.9966,0.997},
{0.9031,0.997},
{0.0709,0.3896},
{0.0041,0.3896},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.4965},
{0.0041,0.4965},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.576605},
{0.0041,0.576601},
{0.0709,0.736972},
{0.0041,0.736972},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.404026},
{0.0041,0.407639},
{0.0709,0.47318},
{0.0041,0.474881},
{0.0709,0.518512},
{0.0041,0.519156},
{0.0709,0.66368},
{0.0041,0.663837},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.40401},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.407692},
{0.0709,0.473219},
{0.0041,0.474922},
{0.0709,0.519696},
{0.0041,0.520566},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.6393},
{0.0041,0.6393},
{0.0709,0.737},
{0.0041,0.737},
{0.7776,0.0034},
{0.8823,0.0034},
{0.8823,0.053},
{0.7776,0.053},
{0.8823,0.1026},
{0.7776,0.1026},
{0.8823,0.1521},
{0.7776,0.1521},
{0.8823,0.221157},
{0.7776,0.221571},
{0.8823,0.319602},
{0.7776,0.319148},
{0.8823,0.4001},
{0.7776,0.4001},
{0.8823,0.4497},
{0.7776,0.4497},
{0.8823,0.4992},
{0.7776,0.4992},
{0.8823,0.5488},
{0.7776,0.5488},
{0.8823,0.5984},
{0.7776,0.5984},
{0.8823,0.648},
{0.7776,0.648},
{0.8823,0.739443},
{0.7776,0.74031},
{0.8823,0.7968},
{0.7776,0.7968},
{0.8823,0.876205},
{0.7776,0.8463},
{0.7776,0.8959},
{0.8823,0.995102},
{0.7776,0.995101},
{0.0709,0.3759},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.3759},
{0.0709,0.4323},
{0.0041,0.4323},
{0.0709,0.4596},
{0.0041,0.4596},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.515461},
{0.0041,0.515306},
{0.0041,0.737},
{0.0709,0.737},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.3759},
{0.0041,0.3759},
{0.0709,0.4323},
{0.0041,0.4323},
{0.0709,0.4596},
{0.0041,0.4596},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.514498},
{0.0041,0.514586},
{0.0709,0.737},
{0.0041,0.737001},
{0.1588,0.3896},
{0.1588,0.3629},
{0.0921,0.3629},
{0.0921,0.3896},
{0.1588,0.4163},
{0.0921,0.4163},
{0.1588,0.443},
{0.0921,0.443},
{0.1588,0.4698},
{0.0921,0.4698},
{0.1588,0.4965},
{0.0921,0.4965},
{0.1588,0.5232},
{0.0921,0.5232},
{0.1588,0.576598},
{0.0921,0.5766},
{0.1588,0.736972},
{0.0921,0.736972},
{0.7776,0.003404},
{0.8823,0.003405},
{0.8823,0.1026},
{0.7776,0.1026},
{0.8823,0.1521},
{0.7776,0.1521},
{0.8823,0.2017},
{0.7776,0.2017},
{0.8823,0.2513},
{0.7776,0.2513},
{0.8823,0.3009},
{0.7776,0.3009},
{0.8823,0.3505},
{0.7776,0.3505},
{0.8823,0.4001},
{0.7776,0.4001},
{0.8823,0.4497},
{0.7776,0.4497},
{0.8823,0.503745},
{0.7776,0.503637},
{0.8823,0.633239},
{0.7776,0.633442},
{0.8823,0.6976},
{0.7776,0.6976},
{0.8823,0.7472},
{0.7776,0.7472},
{0.8823,0.7968},
{0.7776,0.7968},
{0.8823,0.8463},
{0.7776,0.8463},
{0.8823,0.916324},
{0.7776,0.91636},
{0.8823,0.9951},
{0.7776,0.9951},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.403241},
{0.0041,0.403332},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.4698},
{0.0041,0.482693},
{0.0709,0.4965},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.576767},
{0.0041,0.576774},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.403256},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.403315},
{0.0709,0.443},
{0.0041,0.456702},
{0.0709,0.4698},
{0.0709,0.4965},
{0.0041,0.4965},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.576735},
{0.0041,0.5766},
{0.0041,0.737003},
{0.0709,0.737},
{0.0758,0.4613},
{0.0758,0.3573},
{0.0,0.3573},
{0.0,0.4613},
{0.0758,0.5405},
{0.0,0.5405},
{0.0758,0.6123},
{0.0,0.6123},
{0.0758,0.6831},
{0.0,0.6831},
{0.0758,0.7539},
{0.0,0.7539},
{0.0,0.3573},
{0.0758,0.3573},
{0.0758,0.4613},
{0.0,0.4613},
{0.0758,0.5405},
{0.0,0.5405},
{0.0758,0.6123},
{0.0,0.6123},
{0.0758,0.6831},
{0.0,0.6831},
{0.0758,0.7539},
{0.0,0.7539},
{0.7776,0.0034},
{0.8823,0.0034},
{0.8823,0.080265},
{0.7776,0.088135},
{0.8823,0.185271},
{0.7776,0.185692},
{0.8823,0.2513},
{0.7776,0.2513},
{0.8823,0.3009},
{0.7776,0.3009},
{0.8823,0.3505},
{0.7776,0.3505},
{0.8823,0.4001},
{0.7776,0.4001},
{0.8823,0.470424},
{0.7776,0.470451},
{0.8823,0.571897},
{0.7776,0.572019},
{0.8823,0.655905},
{0.7776,0.655921},
{0.8823,0.7472},
{0.7776,0.7472},
{0.8823,0.7968},
{0.7776,0.7968},
{0.8823,0.8463},
{0.7776,0.8463},
{0.8823,0.910761},
{0.7776,0.911213},
{0.8823,0.9951},
{0.7776,0.9951},
{0.0758,0.4613},
{0.0758,0.3573},
{0.0,0.3573},
{0.0,0.4613},
{0.0758,0.5405},
{0.0,0.5405},
{0.0758,0.6123},
{0.0,0.6123},
{0.0758,0.6831},
{0.0,0.6831},
{0.0758,0.7539},
{0.0,0.7539},
{0.0,0.3573},
{0.0758,0.3573},
{0.0758,0.4613},
{0.0,0.4613},
{0.0758,0.5405},
{0.0,0.5405},
{0.0758,0.6123},
{0.0,0.6123},
{0.0758,0.6831},
{0.0,0.6831},
{0.0758,0.7539},
{0.0,0.7539},
{0.0758,0.4613},
{0.0758,0.3573},
{0.0,0.3573},
{0.0,0.4613},
{0.0758,0.5405},
{0.0,0.5405},
{0.0758,0.6123},
{0.0,0.6123},
{0.0758,0.6831},
{0.0,0.6831},
{0.0758,0.7539},
{0.0,0.7539},
{0.0,0.3573},
{0.0758,0.3573},
{0.0758,0.4613},
{0.0,0.4613},
{0.0758,0.5405},
{0.0,0.5405},
{0.0758,0.6123},
{0.0,0.6123},
{0.0758,0.6831},
{0.0,0.6831},
{0.0758,0.7539},
{0.0,0.7539},
{0.0709,0.3759},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.3759},
{0.0709,0.4323},
{0.0041,0.4323},
{0.0709,0.4596},
{0.0041,0.4596},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.515235},
{0.0041,0.515144},
{0.0041,0.737},
{0.0709,0.737},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.3759},
{0.0041,0.3759},
{0.0709,0.4323},
{0.0041,0.4323},
{0.0709,0.4596},
{0.0041,0.4596},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.514353},
{0.0041,0.514597},
{0.0709,0.736998},
{0.0041,0.737},
{0.1569,0.575404},
{0.1569,0.3749},
{0.0849,0.374918},
{0.0849,0.590872},
{0.0849,0.755392},
{0.1569,0.7554},
{0.0849,0.3749},
{0.1569,0.3749},
{0.1569,0.575419},
{0.0849,0.592921},
{0.1569,0.7554},
{0.0849,0.7554},
{0.7776,0.0034},
{0.7776,0.053},
{0.8823,0.053},
{0.8823,0.1026},
{0.7776,0.1026},
{0.8823,0.1521},
{0.7776,0.1521},
{0.8823,0.2017},
{0.7776,0.2017},
{0.8823,0.2513},
{0.7776,0.2513},
{0.8823,0.3009},
{0.7776,0.3009},
{0.8823,0.364015},
{0.7776,0.363554},
{0.8823,0.4497},
{0.7776,0.477382},
{0.8823,0.516367},
{0.7776,0.561637},
{0.8823,0.611847},
{0.7776,0.684065},
{0.8823,0.743583},
{0.7776,0.7472},
{0.8823,0.7968},
{0.7776,0.7968},
{0.8823,0.8463},
{0.7776,0.8463},
{0.8823,0.91729},
{0.7776,0.91765},
{0.8823,0.9951},
{0.7776,0.9951},
{0.8823,0.0034},
{0.7776,0.0034},
{0.7776,0.053},
{0.8823,0.053},
{0.8823,0.1026},
{0.7776,0.1026},
{0.8823,0.1521},
{0.7776,0.1521},
{0.8823,0.2017},
{0.7776,0.2017},
{0.8823,0.275546},
{0.7776,0.2513},
{0.7776,0.327732},
{0.8823,0.3505},
{0.8823,0.419586},
{0.7776,0.419938},
{0.8823,0.521574},
{0.7776,0.521667},
{0.8823,0.623752},
{0.7776,0.623781},
{0.8823,0.721437},
{0.7776,0.721682},
{0.8823,0.818626},
{0.7776,0.829015},
{0.8823,0.934227},
{0.7776,0.934826},
{0.8823,0.9951},
{0.7776,0.9951},
{0.8823,0.0034},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.403205},
{0.0041,0.403424},
{0.0709,0.456583},
{0.0041,0.456792},
{0.0709,0.507752},
{0.0041,0.508323},
{0.0709,0.575134},
{0.0041,0.573605},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.403228},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.403386},
{0.0709,0.456594},
{0.0041,0.456778},
{0.0709,0.514151},
{0.0041,0.514185},
{0.0709,0.595629},
{0.0041,0.595092},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.7776,0.0034},
{0.8823,0.0034},
{0.8823,0.053},
{0.7776,0.053},
{0.8823,0.1026},
{0.7776,0.1026},
{0.8823,0.1521},
{0.7776,0.1521},
{0.8823,0.2017},
{0.7776,0.2017},
{0.8823,0.2513},
{0.7776,0.254134},
{0.8823,0.34737},
{0.7776,0.365455},
{0.8823,0.429871},
{0.7776,0.461257},
{0.7776,0.622677},
{0.8823,0.63292},
{0.8823,0.722185},
{0.7776,0.722163},
{0.8823,0.806292},
{0.7776,0.812119},
{0.8823,0.916211},
{0.7776,0.918601},
{0.8823,0.9951},
{0.7776,0.9951},
{0.0758,0.563642},
{0.0758,0.3573},
{0.0,0.35732},
{0.0,0.582778},
{0.0,0.753892},
{0.0758,0.7539},
{0.0,0.507951},
{0.0,0.3573},
{0.0758,0.357311},
{0.0758,0.570014},
{0.0,0.6123},
{0.0758,0.6831},
{0.0,0.6831},
{0.0758,0.7539},
{0.0,0.7539},
{0.0758,0.357312},
{0.0,0.3573},
{0.0,0.507963},
{0.0758,0.57001},
{0.0,0.682569},
{0.0758,0.6831},
{0.0758,0.7539},
{0.0,0.7539},
{0.0,0.3573},
{0.0758,0.3573},
{0.0758,0.49389},
{0.0,0.507952},
{0.0758,0.681645},
{0.0,0.682033},
{0.0758,0.7539},
{0.0,0.7539},
{0.0709,0.491141},
{0.0041,0.500444},
{0.0041,0.362909},
{0.0709,0.362907},
{0.0709,0.623311},
{0.0041,0.610313},
{0.0041,0.736993},
{0.0709,0.737},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.5766},
{0.0041,0.5766},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.4163},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.4163},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.5766},
{0.0041,0.603471},
{0.0709,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.0758,0.570008},
{0.0758,0.357312},
{0.0,0.35732},
{0.0,0.582789},
{0.0758,0.753887},
{0.0,0.753891},
{0.0,0.584924},
{0.0,0.3573},
{0.0758,0.357312},
{0.0758,0.570027},
{0.0758,0.753887},
{0.0,0.7539},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.3896},
{0.0041,0.3896},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.4965},
{0.0041,0.4965},
{0.0709,0.530777},
{0.0041,0.527958},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.3896},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.3896},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.4965},
{0.0041,0.4965},
{0.0709,0.532849},
{0.0041,0.531324},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.8852,0.217157},
{0.8852,0.022},
{0.7792,0.022},
{0.7792,0.242331},
{0.8852,0.491744},
{0.7792,0.516934},
{0.8852,0.766452},
{0.7792,0.791595},
{0.8852,0.9871},
{0.7792,0.9871},
{0.7792,0.022},
{0.8852,0.022},
{0.8852,0.217179},
{0.7792,0.242283},
{0.8852,0.491775},
{0.7792,0.516904},
{0.8852,0.76644},
{0.7792,0.791572},
{0.8852,0.9871},
{0.7792,0.9871},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.5766},
{0.0041,0.5766},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3629},
{0.0041,0.404679},
{0.0709,0.403066},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.481938},
{0.0041,0.483054},
{0.0709,0.737003},
{0.0041,0.737001},
{0.0709,0.3629},
{0.0709,0.403081},
{0.0041,0.404728},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.481788},
{0.0041,0.482715},
{0.0709,0.737009},
{0.0041,0.737005},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.491073},
{0.0041,0.490817},
{0.0709,0.5766},
{0.0041,0.5766},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.4163},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.4163},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.546025},
{0.0041,0.545958},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.3759},
{0.0041,0.3759},
{0.0709,0.4323},
{0.0041,0.4323},
{0.0709,0.4596},
{0.0041,0.4596},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.514635},
{0.0041,0.514737},
{0.0709,0.737002},
{0.0041,0.736999},
{0.6575,0.1177},
{0.6575,0.0112},
{0.5874,0.0112},
{0.5874,0.1177},
{0.6575,0.1988},
{0.5874,0.1988},
{0.6575,0.2723},
{0.5874,0.2723},
{0.6575,0.3448},
{0.5874,0.3448},
{0.6575,0.4172},
{0.5874,0.4172},
{0.5874,0.0112},
{0.6575,0.0112},
{0.6575,0.1177},
{0.5874,0.1177},
{0.6575,0.1988},
{0.5874,0.1988},
{0.6575,0.2723},
{0.5874,0.2723},
{0.6575,0.3448},
{0.5874,0.3448},
{0.6575,0.4172},
{0.5874,0.4172},
{0.0709,0.3759},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.3759},
{0.0709,0.4323},
{0.0041,0.4323},
{0.0709,0.4596},
{0.0041,0.4596},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.515238},
{0.0041,0.515147},
{0.0041,0.737},
{0.0709,0.737},
{0.0757,0.407276},
{0.0757,0.3575},
{0.0017,0.3575},
{0.0017,0.403025},
{0.0017,0.494057},
{0.0757,0.4936},
{0.0757,0.5544},
{0.0017,0.5544},
{0.0757,0.640434},
{0.0017,0.639489},
{0.0757,0.737},
{0.0017,0.737},
{0.0017,0.3575},
{0.0757,0.3575},
{0.0757,0.3915},
{0.0017,0.3915},
{0.0757,0.436675},
{0.0017,0.435738},
{0.0757,0.4936},
{0.0017,0.4936},
{0.0757,0.5544},
{0.0017,0.5544},
{0.0757,0.736991},
{0.0017,0.736992},
{0.7776,0.0034},
{0.8823,0.0034},
{0.8823,0.053},
{0.7776,0.053},
{0.8823,0.122839},
{0.7776,0.122851},
{0.8823,0.227952},
{0.7776,0.228077},
{0.8823,0.429231},
{0.7776,0.429179},
{0.8823,0.520435},
{0.7776,0.520489},
{0.8823,0.6231},
{0.7776,0.623172},
{0.8823,0.725335},
{0.7776,0.725331},
{0.8823,0.805084},
{0.7776,0.805619},
{0.8823,0.8959},
{0.7776,0.8959},
{0.8823,0.9455},
{0.7776,0.9455},
{0.8823,0.9951},
{0.7776,0.9951},
{0.0709,0.4323},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.4323},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.6393},
{0.0041,0.6393},
{0.0709,0.6881},
{0.0041,0.6881},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.4323},
{0.0041,0.4323},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.6393},
{0.0041,0.6393},
{0.0709,0.6881},
{0.0041,0.6881},
{0.0709,0.737},
{0.0041,0.737},
{0.6569,0.072854},
{0.6569,0.0115},
{0.5902,0.0115},
{0.5902,0.068551},
{0.5902,0.160961},
{0.6569,0.1605},
{0.6569,0.2232},
{0.5902,0.2232},
{0.6569,0.310508},
{0.5902,0.309515},
{0.6569,0.4087},
{0.5902,0.4087},
{0.5902,0.0115},
{0.6569,0.0115},
{0.6569,0.0568},
{0.5902,0.0568},
{0.6569,0.102791},
{0.5902,0.101925},
{0.6569,0.1605},
{0.5902,0.1605},
{0.6569,0.2232},
{0.5902,0.2232},
{0.6569,0.408691},
{0.5902,0.408692},
{0.0758,0.4613},
{0.0758,0.3573},
{0.0,0.3573},
{0.0,0.4613},
{0.0758,0.5405},
{0.0,0.5405},
{0.0758,0.6123},
{0.0,0.6123},
{0.0758,0.6831},
{0.0,0.6831},
{0.0758,0.7539},
{0.0,0.7539},
{0.6638,0.0658},
{0.6638,0.0255},
{0.5859,0.0255},
{0.5859,0.0658},
{0.6638,0.1048},
{0.5859,0.1048},
{0.6638,0.1378},
{0.5859,0.1378},
{0.6638,0.230788},
{0.5859,0.228776},
{0.6638,0.3361},
{0.5859,0.3361},
{0.6638,0.4021},
{0.5859,0.4021},
{0.6569,0.09178},
{0.6569,0.0142},
{0.5901,0.01428},
{0.5901,0.120711},
{0.6569,0.177275},
{0.5901,0.184456},
{0.6569,0.256052},
{0.5901,0.2515},
{0.5901,0.413501},
{0.6569,0.4135},
{0.6569,0.091767},
{0.6569,0.0142},
{0.5901,0.014281},
{0.5901,0.120715},
{0.6569,0.177196},
{0.5901,0.184465},
{0.6569,0.256038},
{0.5901,0.2515},
{0.5901,0.413501},
{0.6569,0.4135},
{0.0,0.3573},
{0.0758,0.3573},
{0.0758,0.4613},
{0.0,0.4613},
{0.0758,0.5405},
{0.0,0.5405},
{0.0758,0.6123},
{0.0,0.6123},
{0.0758,0.6831},
{0.0,0.6831},
{0.0758,0.7539},
{0.0,0.7539},
{0.5901,0.0142},
{0.6569,0.0142},
{0.6569,0.091806},
{0.5901,0.092167},
{0.6569,0.150587},
{0.5901,0.150815},
{0.6569,0.222642},
{0.5901,0.214408},
{0.5901,0.413501},
{0.6569,0.4135},
{0.5901,0.0142},
{0.6569,0.0142},
{0.6569,0.091855},
{0.5901,0.092199},
{0.6569,0.150597},
{0.5901,0.150815},
{0.6569,0.222667},
{0.5901,0.214383},
{0.5901,0.413501},
{0.6569,0.4135},
{0.0709,0.4323},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.4323},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.6393},
{0.0041,0.6393},
{0.0709,0.6881},
{0.0041,0.6881},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.4323},
{0.0041,0.4323},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.6393},
{0.0041,0.6393},
{0.0709,0.6881},
{0.0041,0.6881},
{0.0709,0.737},
{0.0041,0.737},
{0.1541,0.3757},
{0.1541,0.346},
{0.084,0.346},
{0.084,0.3757},
{0.1541,0.4219},
{0.084,0.4219},
{0.1541,0.47901},
{0.084,0.4667},
{0.084,0.509388},
{0.1541,0.742003},
{0.084,0.742001},
{0.0709,0.362883},
{0.0041,0.3629},
{0.0041,0.436798},
{0.0709,0.456613},
{0.0709,0.5208},
{0.0041,0.529115},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3629},
{0.0709,0.362883},
{0.0041,0.436786},
{0.0709,0.45658},
{0.0709,0.529118},
{0.0041,0.529084},
{0.0041,0.737},
{0.0709,0.737},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.5766},
{0.0041,0.5766},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.4163},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.4163},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.546568},
{0.0041,0.546565},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.0758,0.4613},
{0.0758,0.3573},
{0.0,0.3573},
{0.0,0.4613},
{0.0758,0.5405},
{0.0,0.5405},
{0.0758,0.6123},
{0.0,0.6123},
{0.0758,0.6831},
{0.0,0.6831},
{0.0758,0.7539},
{0.0,0.7539},
{0.0,0.3573},
{0.0758,0.3573},
{0.0758,0.4613},
{0.0,0.4613},
{0.0758,0.5405},
{0.0,0.5405},
{0.0758,0.6123},
{0.0,0.6123},
{0.0758,0.6831},
{0.0,0.6831},
{0.0758,0.7539},
{0.0,0.7539},
{0.0709,0.403345},
{0.0041,0.403454},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.483878},
{0.0041,0.484158},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.576586},
{0.0041,0.576612},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.6676,0.096929},
{0.5821,0.097263},
{0.5821,0.0318},
{0.6676,0.0318},
{0.6676,0.1329},
{0.5821,0.1329},
{0.6676,0.169596},
{0.5821,0.170238},
{0.6676,0.2053},
{0.5821,0.2053},
{0.6676,0.25362},
{0.5821,0.2536},
{0.5821,0.350106},
{0.6676,0.3501},
{0.6676,0.3984},
{0.5821,0.3984},
{0.0709,0.403331},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.403491},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.483861},
{0.0041,0.484178},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.576613},
{0.0041,0.576586},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.6676,0.096948},
{0.6676,0.0318},
{0.5821,0.0318},
{0.5821,0.097296},
{0.6676,0.1329},
{0.5821,0.1329},
{0.6676,0.169588},
{0.5821,0.170231},
{0.6676,0.2053},
{0.5821,0.2053},
{0.6676,0.2536},
{0.5821,0.2536},
{0.6676,0.35012},
{0.5821,0.350116},
{0.6676,0.3984},
{0.5821,0.3984},
{0.8852,0.217133},
{0.8852,0.022},
{0.7792,0.022},
{0.7792,0.242321},
{0.8852,0.491731},
{0.7792,0.516954},
{0.8852,0.766404},
{0.7792,0.791573},
{0.8852,0.9871},
{0.7792,0.9871},
{0.7792,0.022},
{0.8852,0.022},
{0.8852,0.217161},
{0.7792,0.242354},
{0.8852,0.491753},
{0.7792,0.516975},
{0.8852,0.76642},
{0.7792,0.791616},
{0.8852,0.9871},
{0.7792,0.9871},
{0.0709,0.4323},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.4323},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.6393},
{0.0041,0.6393},
{0.0709,0.6881},
{0.0041,0.6881},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.4323},
{0.0041,0.4323},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.6393},
{0.0041,0.6393},
{0.0709,0.6881},
{0.0041,0.6881},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.3896},
{0.0041,0.3896},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.4965},
{0.0041,0.4965},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.576573},
{0.0041,0.5766},
{0.0041,0.736995},
{0.0709,0.736997},
{0.0709,0.3896},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.3896},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.4965},
{0.0041,0.4965},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.576601},
{0.0041,0.5766},
{0.0041,0.736995},
{0.0709,0.736997},
{0.0709,0.4323},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.4323},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.6393},
{0.0041,0.6393},
{0.0709,0.6881},
{0.0041,0.6881},
{0.0709,0.737},
{0.0041,0.737},
{0.8852,0.217159},
{0.8852,0.022},
{0.7792,0.022},
{0.7792,0.242293},
{0.8852,0.49177},
{0.7792,0.516918},
{0.8852,0.76641},
{0.7792,0.791557},
{0.8852,0.9871},
{0.7792,0.9871},
{0.7792,0.022},
{0.8852,0.022},
{0.8852,0.217197},
{0.7792,0.242313},
{0.8852,0.491745},
{0.7792,0.516959},
{0.8852,0.76644},
{0.7792,0.791616},
{0.8852,0.9871},
{0.7792,0.9871},
{0.0,0.357335},
{0.0758,0.3573},
{0.0758,0.48022},
{0.0,0.595736},
{0.0758,0.644845},
{0.0,0.753891},
{0.0758,0.7539},
{0.0758,0.478436},
{0.0758,0.3573},
{0.0,0.3573},
{0.0,0.483533},
{0.0758,0.622796},
{0.0,0.6123},
{0.0,0.753887},
{0.0758,0.7539},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.4323},
{0.0041,0.4323},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.6393},
{0.0041,0.6393},
{0.0709,0.6881},
{0.0041,0.6881},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.5766},
{0.0041,0.5766},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.4163},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.4163},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.5766},
{0.0041,0.5766},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.5766},
{0.0041,0.5766},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.4163},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.4163},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.5766},
{0.0041,0.5766},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.1588,0.403343},
{0.0921,0.3896},
{0.0921,0.3629},
{0.1588,0.3629},
{0.0921,0.4163},
{0.1588,0.443},
{0.0921,0.443},
{0.1588,0.4698},
{0.0921,0.4698},
{0.1588,0.4965},
{0.0921,0.4965},
{0.1588,0.532037},
{0.0921,0.5232},
{0.0921,0.576601},
{0.1588,0.736994},
{0.0921,0.736997},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.5766},
{0.0041,0.5766},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.5638,0.445832},
{0.5638,0.3908},
{0.5084,0.3908},
{0.5084,0.449488},
{0.5638,0.507},
{0.5084,0.531451},
{0.5638,0.583968},
{0.5084,0.785001},
{0.5638,0.785},
{0.0709,0.4163},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.4163},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.54702},
{0.0041,0.546968},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.5084,0.3908},
{0.5638,0.3908},
{0.5638,0.446829},
{0.5084,0.447396},
{0.5638,0.539707},
{0.5084,0.52897},
{0.5084,0.785001},
{0.5638,0.785},
{0.0709,0.403227},
{0.0041,0.3896},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0041,0.4163},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.4965},
{0.0041,0.4965},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.576608},
{0.0041,0.5766},
{0.0041,0.736994},
{0.0709,0.736997},
{0.0709,0.403324},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.3896},
{0.0041,0.4163},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.4965},
{0.0041,0.4965},
{0.0709,0.532061},
{0.0041,0.5232},
{0.0041,0.576574},
{0.0709,0.736995},
{0.0041,0.736997},
{0.1588,0.40322},
{0.1588,0.3629},
{0.0921,0.3629},
{0.0921,0.3896},
{0.0921,0.4163},
{0.1588,0.443},
{0.0921,0.443},
{0.1588,0.4698},
{0.0921,0.4698},
{0.1588,0.4965},
{0.0921,0.4965},
{0.1588,0.5232},
{0.0921,0.5232},
{0.1588,0.576574},
{0.0921,0.5766},
{0.0921,0.736995},
{0.1588,0.736997},
{0.0758,0.477666},
{0.0758,0.3573},
{0.0,0.3573},
{0.0,0.482367},
{0.0758,0.622495},
{0.0,0.6123},
{0.0,0.753887},
{0.0758,0.7539},
{0.9011,0.003412},
{0.9946,0.0034},
{0.9946,0.072034},
{0.9011,0.158992},
{0.9946,0.195334},
{0.9011,0.435229},
{0.9946,0.438839},
{0.9946,0.4992},
{0.9011,0.515705},
{0.9946,0.565479},
{0.9011,0.6161},
{0.9946,0.691731},
{0.9011,0.715122},
{0.9011,0.878204},
{0.9946,0.904432},
{0.9011,0.995085},
{0.9946,0.9951},
{0.0,0.503239},
{0.0,0.3573},
{0.0758,0.357345},
{0.0758,0.556684},
{0.0,0.667555},
{0.0758,0.753825},
{0.0,0.7539},
{0.0758,0.475224},
{0.0758,0.3573},
{0.0,0.3573},
{0.0,0.4613},
{0.0,0.609314},
{0.0758,0.622217},
{0.0,0.753915},
{0.0758,0.7539},
{0.0,0.502497},
{0.0,0.3573},
{0.0758,0.357321},
{0.0758,0.555825},
{0.0,0.667518},
{0.0758,0.753801},
{0.0,0.7539},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.403269},
{0.0041,0.403317},
{0.0709,0.457189},
{0.0041,0.457349},
{0.0709,0.4965},
{0.0041,0.4965},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.577728},
{0.0041,0.5766},
{0.0041,0.682618},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.403263},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.403311},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.483214},
{0.0041,0.483342},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.577786},
{0.0041,0.5766},
{0.0041,0.682613},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3629},
{0.0709,0.362861},
{0.0041,0.436095},
{0.0709,0.45533},
{0.0709,0.529482},
{0.0041,0.534302},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.358494},
{0.0041,0.3585},
{0.0041,0.475172},
{0.0709,0.480634},
{0.0709,0.5142},
{0.0041,0.5142},
{0.0709,0.541754},
{0.0041,0.541715},
{0.0709,0.663463},
{0.0041,0.663416},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.358482},
{0.0709,0.358494},
{0.0709,0.497198},
{0.0041,0.497581},
{0.0709,0.545386},
{0.0041,0.545417},
{0.0709,0.674876},
{0.0041,0.674992},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3485},
{0.0746,0.3485},
{0.0746,0.3808},
{0.0041,0.3808},
{0.0746,0.4132},
{0.0041,0.4132},
{0.0746,0.4456},
{0.0041,0.4456},
{0.0746,0.478},
{0.0041,0.478},
{0.0746,0.54339},
{0.0041,0.543714},
{0.0746,0.736994},
{0.0041,0.736994},
{0.0746,0.397541},
{0.0746,0.3485},
{0.0041,0.3485},
{0.0041,0.3808},
{0.0041,0.4132},
{0.0746,0.4456},
{0.0041,0.4456},
{0.0746,0.478},
{0.0041,0.478},
{0.0746,0.5427},
{0.0041,0.5427},
{0.0746,0.626291},
{0.0041,0.629082},
{0.0746,0.737},
{0.0041,0.737},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.444594},
{0.0041,0.444939},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.5766},
{0.0041,0.5766},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.4163},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.4163},
{0.0709,0.4848},
{0.0041,0.484124},
{0.0709,0.5766},
{0.0041,0.5766},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3485},
{0.0746,0.3485},
{0.0746,0.393771},
{0.0041,0.393934},
{0.0746,0.454245},
{0.0041,0.454462},
{0.0746,0.4979},
{0.0041,0.4979},
{0.0746,0.5577},
{0.0041,0.557698},
{0.0746,0.737},
{0.0041,0.737},
{0.0746,0.39375},
{0.0746,0.3485},
{0.0041,0.3485},
{0.0041,0.393939},
{0.0746,0.452803},
{0.0041,0.45308},
{0.0746,0.4979},
{0.0041,0.4979},
{0.0746,0.559036},
{0.0041,0.559318},
{0.0746,0.737},
{0.0041,0.737},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.5766},
{0.0041,0.5766},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.4163},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.4163},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.5766},
{0.0041,0.5766},
{0.0709,0.6301},
{0.0041,0.6301},
{0.0709,0.6835},
{0.0041,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.3896},
{0.0041,0.3896},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.4965},
{0.0041,0.4965},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.5766},
{0.0041,0.5766},
{0.0709,0.737002},
{0.0041,0.737002},
{0.0709,0.3896},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.3896},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.4965},
{0.0041,0.4965},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.576613},
{0.0041,0.5766},
{0.0041,0.737002},
{0.0709,0.737001},
{0.0709,0.358494},
{0.0041,0.3585},
{0.0041,0.475298},
{0.0709,0.480671},
{0.0709,0.5142},
{0.0041,0.5142},
{0.0709,0.544301},
{0.0041,0.545223},
{0.0709,0.663053},
{0.0041,0.663075},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.358481},
{0.0709,0.358494},
{0.0709,0.49722},
{0.0041,0.49761},
{0.0709,0.548039},
{0.0041,0.549879},
{0.0709,0.6745},
{0.0041,0.674657},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.403268},
{0.0041,0.403406},
{0.0709,0.456204},
{0.0041,0.456281},
{0.0709,0.501512},
{0.0041,0.502772},
{0.0709,0.592807},
{0.0041,0.5766},
{0.0041,0.656982},
{0.0709,0.6835},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.403255},
{0.0709,0.3629},
{0.0041,0.3629},
{0.0041,0.403411},
{0.0709,0.459967},
{0.0041,0.459848},
{0.0709,0.506546},
{0.0041,0.507328},
{0.0709,0.606866},
{0.0041,0.614383},
{0.0709,0.6835},
{0.0041,0.736981},
{0.0709,0.737},
{0.7778,0.009249},
{0.8826,0.0097},
{0.8826,0.0891},
{0.8826,0.199019},
{0.7778,0.203666},
{0.8826,0.358599},
{0.7778,0.332632},
{0.8826,0.50282},
{0.7778,0.545506},
{0.8826,0.738983},
{0.7778,0.73682},
{0.8826,0.984877},
{0.7778,0.984892},
{0.8826,0.0891},
{0.8826,0.0097},
{0.7778,0.009248},
{0.8826,0.199049},
{0.7778,0.203829},
{0.8826,0.358394},
{0.7778,0.33266},
{0.8826,0.489428},
{0.7778,0.4862},
{0.7778,0.617598},
{0.8826,0.761225},
{0.7778,0.745479},
{0.7778,0.984994},
{0.8826,0.985},
{0.0041,0.3484},
{0.0746,0.3484},
{0.0746,0.3808},
{0.0041,0.3808},
{0.0746,0.4132},
{0.0041,0.4132},
{0.0746,0.4456},
{0.0041,0.4456},
{0.0746,0.4779},
{0.0041,0.4779},
{0.0746,0.5427},
{0.0041,0.5427},
{0.0746,0.631785},
{0.0041,0.640808},
{0.0746,0.737},
{0.0041,0.737},
{0.0746,0.397545},
{0.0746,0.3484},
{0.0041,0.3484},
{0.0041,0.3808},
{0.0041,0.4132},
{0.0746,0.4456},
{0.0041,0.4456},
{0.0746,0.4779},
{0.0041,0.4779},
{0.0746,0.5427},
{0.0041,0.5427},
{0.0746,0.6074},
{0.0041,0.6074},
{0.0746,0.736982},
{0.0041,0.73698},
{0.0041,0.3485},
{0.0746,0.3485},
{0.0746,0.393774},
{0.0041,0.393968},
{0.0746,0.454239},
{0.0041,0.454488},
{0.0746,0.498243},
{0.0041,0.50199},
{0.0746,0.6174},
{0.0041,0.6174},
{0.0746,0.6772},
{0.0041,0.6772},
{0.0746,0.737},
{0.0041,0.737},
{0.0746,0.393761},
{0.0746,0.3485},
{0.0041,0.3485},
{0.0041,0.393912},
{0.0746,0.452797},
{0.0041,0.453077},
{0.0746,0.49807},
{0.0041,0.4979},
{0.0041,0.618623},
{0.0746,0.6174},
{0.0746,0.6772},
{0.0041,0.6772},
{0.0746,0.737},
{0.0041,0.737},
{0.0709,0.404261},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.404242},
{0.0709,0.472438},
{0.0041,0.472653},
{0.0709,0.528851},
{0.0041,0.529212},
{0.0709,0.591769},
{0.0041,0.5904},
{0.0041,0.737001},
{0.0709,0.737},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.40433},
{0.0041,0.404367},
{0.0709,0.4596},
{0.0041,0.4596},
{0.0709,0.500935},
{0.0041,0.500941},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.737003},
{0.0041,0.737001},
{0.0709,0.404291},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.404271},
{0.0709,0.472437},
{0.0041,0.47273},
{0.0709,0.528887},
{0.0041,0.529257},
{0.0709,0.591765},
{0.0041,0.5904},
{0.0041,0.737001},
{0.0709,0.737},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.404361},
{0.0041,0.4043},
{0.0709,0.4596},
{0.0041,0.4596},
{0.0709,0.500933},
{0.0041,0.50099},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.737003},
{0.0041,0.737},
{0.0709,0.362861},
{0.0041,0.3629},
{0.0041,0.436084},
{0.0709,0.45533},
{0.0709,0.52171},
{0.0041,0.529486},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.3759},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.3759},
{0.0709,0.4323},
{0.0041,0.442031},
{0.0709,0.466955},
{0.0041,0.513359},
{0.0709,0.5142},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.65725},
{0.0041,0.656923},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.3759},
{0.0041,0.405062},
{0.0709,0.4323},
{0.0709,0.4596},
{0.0041,0.4596},
{0.0709,0.497463},
{0.0041,0.496687},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.589669},
{0.0709,0.736996},
{0.0041,0.737},
{0.8852,0.217124},
{0.8852,0.022},
{0.7792,0.022},
{0.7792,0.242324},
{0.8852,0.491753},
{0.7792,0.516938},
{0.8852,0.766447},
{0.7792,0.791602},
{0.8852,0.9871},
{0.7792,0.9871},
{0.7792,0.235875},
{0.7792,0.022},
{0.8852,0.022043},
{0.8852,0.337556},
{0.7792,0.534439},
{0.8852,0.63614},
{0.7792,0.805892},
{0.8852,0.8493},
{0.8852,0.9871},
{0.7792,0.9871},
{0.0709,0.3759},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.3759},
{0.0709,0.4323},
{0.0041,0.4323},
{0.0709,0.4596},
{0.0041,0.4596},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.5142},
{0.0041,0.5142},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.591076},
{0.0041,0.5904},
{0.0041,0.737001},
{0.0709,0.737},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.3759},
{0.0041,0.3759},
{0.0709,0.4323},
{0.0041,0.4323},
{0.0709,0.4596},
{0.0041,0.4596},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.5142},
{0.0041,0.5142},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.737002},
{0.0041,0.737},
{0.7747,0.0081},
{0.8857,0.0081},
{0.8857,0.131285},
{0.7747,0.138386},
{0.8857,0.307878},
{0.7747,0.326972},
{0.8857,0.457906},
{0.7747,0.473128},
{0.8857,0.579605},
{0.7747,0.595598},
{0.8857,0.763485},
{0.7747,0.74493},
{0.7747,0.984991},
{0.8857,0.985},
{0.7747,0.0081},
{0.8857,0.0081},
{0.8857,0.0877},
{0.7747,0.132563},
{0.8857,0.172461},
{0.8857,0.471291},
{0.7747,0.48778},
{0.8857,0.599028},
{0.7747,0.754246},
{0.8857,0.724},
{0.8857,0.812173},
{0.8857,0.985},
{0.7747,0.985},
{0.8857,0.131141},
{0.8857,0.0081},
{0.7747,0.0081},
{0.7747,0.138469},
{0.8857,0.307887},
{0.7747,0.326993},
{0.8857,0.457741},
{0.7747,0.473202},
{0.8857,0.598799},
{0.7747,0.5649},
{0.7747,0.675682},
{0.8857,0.786835},
{0.7747,0.819349},
{0.8857,0.985},
{0.7747,0.985},
{0.8857,0.0877},
{0.8857,0.0081},
{0.7747,0.0081},
{0.7747,0.132519},
{0.8857,0.172374},
{0.8857,0.335595},
{0.7747,0.448817},
{0.8857,0.52804},
{0.7747,0.666055},
{0.8857,0.678172},
{0.8857,0.832614},
{0.7747,0.827697},
{0.8857,0.985},
{0.7747,0.985},
{0.0921,0.3629},
{0.1588,0.362861},
{0.0921,0.435852},
{0.1588,0.455313},
{0.1588,0.522055},
{0.0921,0.529583},
{0.1588,0.736999},
{0.0921,0.736999},
{0.0709,0.362861},
{0.0041,0.3629},
{0.0041,0.435832},
{0.0709,0.455279},
{0.0709,0.522071},
{0.0041,0.529589},
{0.0709,0.736999},
{0.0041,0.737},
{0.1588,0.362861},
{0.0921,0.3629},
{0.0921,0.436579},
{0.1588,0.456786},
{0.1588,0.529437},
{0.0921,0.528941},
{0.0921,0.736999},
{0.1588,0.736999},
{0.0921,0.3629},
{0.1588,0.362861},
{0.0921,0.436608},
{0.1588,0.456793},
{0.1588,0.529436},
{0.0921,0.528953},
{0.0921,0.736999},
{0.1588,0.736999},
{0.584,0.0136},
{0.584,0.06417},
{0.662,0.059848},
{0.662,0.119965},
{0.584,0.122142},
{0.662,0.171249},
{0.584,0.174624},
{0.662,0.313227},
{0.584,0.313615},
{0.662,0.404},
{0.584,0.404},
{0.662,0.0136},
{0.584,0.0136},
{0.662,0.013553},
{0.584,0.061881},
{0.662,0.132039},
{0.584,0.125725},
{0.584,0.19655},
{0.662,0.250538},
{0.584,0.313477},
{0.662,0.404},
{0.584,0.404},
{0.1588,0.3896},
{0.1588,0.3629},
{0.0921,0.3629},
{0.0921,0.3896},
{0.1588,0.4163},
{0.0921,0.4163},
{0.1588,0.443},
{0.0921,0.443},
{0.1588,0.4698},
{0.0921,0.4698},
{0.1588,0.4965},
{0.0921,0.4965},
{0.1588,0.5232},
{0.0921,0.5232},
{0.1588,0.576603},
{0.0921,0.5766},
{0.0921,0.737002},
{0.1588,0.737001},
{0.0709,0.3896},
{0.0041,0.3896},
{0.0041,0.3629},
{0.0709,0.3629},
{0.0709,0.4163},
{0.0041,0.4163},
{0.0709,0.443},
{0.0041,0.443},
{0.0709,0.4698},
{0.0041,0.4698},
{0.0709,0.4965},
{0.0041,0.4965},
{0.0709,0.5232},
{0.0041,0.5232},
{0.0709,0.5766},
{0.0041,0.5766},
{0.0709,0.737002},
{0.0041,0.737002},
{0.6676,0.0847},
{0.5821,0.0847},
{0.5821,0.0318},
{0.6676,0.0318},
{0.6676,0.1088},
{0.5821,0.1088},
{0.6676,0.1329},
{0.5821,0.1329},
{0.6676,0.1571},
{0.5821,0.1571},
{0.6676,0.1812},
{0.5821,0.1812},
{0.6676,0.2053},
{0.5821,0.2053},
{0.6676,0.253596},
{0.5821,0.253585},
{0.6676,0.398401},
{0.5821,0.398401},
{0.1588,0.3896},
{0.1588,0.3629},
{0.0921,0.3629},
{0.0921,0.3896},
{0.1588,0.4163},
{0.0921,0.4163},
{0.1588,0.443},
{0.0921,0.443},
{0.1588,0.4698},
{0.0921,0.4698},
{0.1588,0.4965},
{0.0921,0.4965},
{0.1588,0.5232},
{0.0921,0.5232},
{0.1588,0.576621},
{0.0921,0.576602},
{0.1588,0.737001},
{0.0921,0.737001},
{0.5784,0.0075},
{0.665,0.0076},
{0.6649,0.0698},
{0.5802,0.0698},
{0.6649,0.1382},
{0.5802,0.1382},
{0.6649,0.2089},
{0.5802,0.2089},
{0.6649,0.32929},
{0.5802,0.331252},
{0.6649,0.4082},
{0.5802,0.4082},
{0.6649,0.0698},
{0.665,0.0076},
{0.5784,0.0075},
{0.5802,0.0698},
{0.6649,0.1382},
{0.5802,0.1382},
{0.6649,0.2089},
{0.5802,0.2089},
{0.6649,0.291003},
{0.5802,0.2889},
{0.5802,0.408192},
{0.6649,0.4082},
{0.584,0.0136},
{0.662,0.0136},
{0.662,0.0437},
{0.584,0.0437},
{0.662,0.0737},
{0.584,0.0737},
{0.662,0.1037},
{0.584,0.1037},
{0.662,0.1337},
{0.584,0.1337},
{0.662,0.1638},
{0.584,0.1638},
{0.662,0.2238},
{0.584,0.2238},
{0.662,0.40399},
{0.584,0.40399},
{0.662,0.0437},
{0.662,0.0136},
{0.584,0.0136},
{0.584,0.0437},
{0.662,0.0737},
{0.584,0.0737},
{0.662,0.1037},
{0.584,0.1037},
{0.662,0.1337},
{0.584,0.1337},
{0.662,0.1638},
{0.584,0.167407},
{0.662,0.2238},
{0.662,0.40399},
{0.584,0.40399},
{0.0709,0.404514},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.404747},
{0.0709,0.4596},
{0.0041,0.4596},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.515402},
{0.0041,0.517488},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.666153},
{0.0041,0.667314},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.404608},
{0.0041,0.404631},
{0.0709,0.474871},
{0.0041,0.474785},
{0.0709,0.530718},
{0.0041,0.530917},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.6393},
{0.0041,0.6393},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.404573},
{0.0041,0.404702},
{0.0709,0.474919},
{0.0041,0.474767},
{0.0709,0.530743},
{0.0041,0.530919},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.63933},
{0.0041,0.6393},
{0.0041,0.737},
{0.0709,0.737},
{0.0709,0.404627},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.404595},
{0.0709,0.477127},
{0.0041,0.4596},
{0.0041,0.486279},
{0.0709,0.515657},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.666294},
{0.0041,0.667522},
{0.0709,0.737},
{0.0041,0.737},
{0.5784,0.415},
{0.664,0.415},
{0.6639,0.502},
{0.5784,0.502},
{0.6639,0.5975},
{0.5784,0.5975},
{0.6639,0.6964},
{0.5784,0.6964},
{0.6639,0.8081},
{0.5784,0.886753},
{0.6639,0.8916},
{0.6639,0.975},
{0.5784,0.975},
{0.6639,0.502},
{0.664,0.415},
{0.5784,0.415},
{0.5784,0.502},
{0.6639,0.5975},
{0.5784,0.5975},
{0.6639,0.697249},
{0.5784,0.6964},
{0.5784,0.846916},
{0.6639,0.8916},
{0.6639,0.975},
{0.5784,0.975},
{0.0709,0.439976},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.441115},
{0.0709,0.48915},
{0.0041,0.489371},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.663491},
{0.0041,0.663731},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.358507},
{0.0709,0.358516},
{0.0709,0.475603},
{0.0041,0.475735},
{0.0709,0.541657},
{0.0041,0.529577},
{0.0041,0.636607},
{0.0709,0.6393},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.439825},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.441115},
{0.0709,0.489142},
{0.0041,0.489411},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.663502},
{0.0041,0.663645},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.358507},
{0.0709,0.358517},
{0.0709,0.475685},
{0.0041,0.475783},
{0.0709,0.541785},
{0.0041,0.529704},
{0.0041,0.633257},
{0.0709,0.6393},
{0.0709,0.737},
{0.0041,0.737},
{0.0709,0.404098},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.404604},
{0.0709,0.472812},
{0.0041,0.473138},
{0.0709,0.529441},
{0.0041,0.529884},
{0.0709,0.5904},
{0.0041,0.589523},
{0.0709,0.6393},
{0.0709,0.6881},
{0.0041,0.737},
{0.0709,0.737},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.404531},
{0.0041,0.404759},
{0.0709,0.473971},
{0.0041,0.4596},
{0.0041,0.500635},
{0.0709,0.531637},
{0.0041,0.55473},
{0.0709,0.5904},
{0.0709,0.6393},
{0.0041,0.737006},
{0.0709,0.6881},
{0.0709,0.737},
{0.5784,0.415},
{0.664,0.415},
{0.6639,0.502},
{0.5784,0.502},
{0.6639,0.5975},
{0.5784,0.5975},
{0.6639,0.6964},
{0.5784,0.6964},
{0.6639,0.8081},
{0.5784,0.854606},
{0.6639,0.8916},
{0.6639,0.975},
{0.5784,0.975},
{0.0709,0.443441},
{0.0709,0.358536},
{0.0041,0.358537},
{0.0041,0.444401},
{0.0709,0.49398},
{0.0041,0.4869},
{0.0041,0.53567},
{0.0709,0.5416},
{0.0709,0.5904},
{0.0041,0.591087},
{0.0709,0.6393},
{0.0709,0.6881},
{0.0041,0.737},
{0.0709,0.737},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.404683},
{0.0041,0.404794},
{0.0709,0.473434},
{0.0041,0.47383},
{0.0709,0.532054},
{0.0041,0.532123},
{0.0709,0.5904},
{0.0041,0.592177},
{0.0709,0.6393},
{0.0709,0.6881},
{0.0041,0.737},
{0.0709,0.737},
{0.6639,0.502},
{0.664,0.415},
{0.5784,0.415},
{0.5784,0.502},
{0.6639,0.5975},
{0.5784,0.5975},
{0.6639,0.6964},
{0.5784,0.6964},
{0.6639,0.8081},
{0.5784,0.807148},
{0.6639,0.8916},
{0.6639,0.975},
{0.5784,0.975},
{0.7792,0.0014},
{0.8852,0.0014},
{0.8852,0.0962},
{0.7792,0.0962},
{0.8852,0.2528},
{0.7792,0.2528},
{0.8852,0.4019},
{0.7792,0.4019},
{0.8852,0.5398},
{0.7792,0.5398},
{0.8852,0.6796},
{0.7792,0.6796},
{0.8852,0.8493},
{0.7792,0.8493},
{0.8852,0.9871},
{0.7792,0.9871},
{0.8852,0.0962},
{0.8852,0.0014},
{0.7792,0.0014},
{0.7792,0.0962},
{0.8852,0.2528},
{0.7792,0.2528},
{0.8852,0.4019},
{0.7792,0.4019},
{0.8852,0.5398},
{0.7792,0.5398},
{0.8852,0.6796},
{0.7792,0.6796},
{0.8852,0.8493},
{0.7792,0.8493},
{0.8852,0.9871},
{0.7792,0.9871},
{0.0709,0.444009},
{0.0709,0.3759},
{0.0041,0.3759},
{0.0041,0.44445},
{0.0709,0.49504},
{0.0041,0.495882},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.590815},
{0.0709,0.6393},
{0.0709,0.6881},
{0.0041,0.737},
{0.0709,0.737},
{0.0709,0.3585},
{0.0041,0.3585},
{0.7792,0.0014},
{0.8852,0.0014},
{0.8852,0.0962},
{0.7792,0.245539},
{0.8852,0.2528},
{0.8852,0.4019},
{0.7792,0.4019},
{0.8852,0.5398},
{0.7792,0.5398},
{0.8852,0.6796},
{0.7792,0.6796},
{0.8852,0.8493},
{0.7792,0.8493},
{0.8852,0.9871},
{0.7792,0.9871},
{0.0709,0.404447},
{0.0709,0.473381},
{0.0041,0.404482},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.473458},
{0.0709,0.532153},
{0.0041,0.5142},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.591353},
{0.0709,0.6393},
{0.0709,0.6881},
{0.0041,0.737},
{0.0709,0.737},
{0.8852,0.0962},
{0.8852,0.0014},
{0.7792,0.0014},
{0.7792,0.245565},
{0.8852,0.2528},
{0.8852,0.4019},
{0.7792,0.4019},
{0.8852,0.5398},
{0.7792,0.5398},
{0.8852,0.6796},
{0.7792,0.6796},
{0.8852,0.8493},
{0.7792,0.8493},
{0.8852,0.9871},
{0.7792,0.9871},
{0.0709,0.444008},
{0.0709,0.3759},
{0.0041,0.3759},
{0.0041,0.444437},
{0.0709,0.495042},
{0.0041,0.495853},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.590811},
{0.0709,0.6393},
{0.0709,0.6881},
{0.0041,0.737},
{0.0709,0.737},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0709,0.404472},
{0.0709,0.473419},
{0.0041,0.404547},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.473448},
{0.0709,0.532168},
{0.0041,0.5142},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.591357},
{0.0709,0.6393},
{0.0709,0.6881},
{0.0041,0.737},
{0.0709,0.737},
{0.5784,0.415},
{0.664,0.415},
{0.6639,0.557662},
{0.5784,0.560247},
{0.6639,0.6964},
{0.5784,0.6964},
{0.6639,0.8081},
{0.5784,0.8081},
{0.6639,0.8916},
{0.5784,0.8916},
{0.6639,0.975},
{0.5784,0.975},
{0.6639,0.57418},
{0.664,0.415},
{0.5784,0.415},
{0.5784,0.577929},
{0.6639,0.772412},
{0.5784,0.77848},
{0.6639,0.8916},
{0.5784,0.8916},
{0.6639,0.975},
{0.5784,0.975},
{0.6649,0.0089},
{0.5812,0.0089},
{0.5812,0.117593},
{0.6649,0.127226},
{0.5812,0.265},
{0.6649,0.265},
{0.5812,0.3346},
{0.6649,0.3346},
{0.5812,0.4043},
{0.6649,0.4043},
{0.5812,0.127303},
{0.5812,0.0089},
{0.6649,0.0089},
{0.6649,0.140696},
{0.5812,0.264175},
{0.6649,0.265},
{0.6649,0.404357},
{0.5812,0.4043},
{0.6649,0.0089},
{0.6649,0.074},
{0.5812,0.074},
{0.5812,0.1696},
{0.6649,0.1696},
{0.5812,0.265},
{0.6649,0.265},
{0.5812,0.3346},
{0.6649,0.3346},
{0.5812,0.4043},
{0.6649,0.4043},
{0.5812,0.0089},
{0.5812,0.074},
{0.6649,0.074},
{0.6649,0.0089},
{0.5812,0.0089},
{0.5812,0.1696},
{0.6649,0.1696},
{0.5812,0.265},
{0.6649,0.265},
{0.5812,0.3346},
{0.6649,0.3346},
{0.5812,0.4043},
{0.6649,0.4043},
{0.7792,0.0014},
{0.8852,0.0014},
{0.8852,0.0962},
{0.7792,0.0962},
{0.8852,0.2528},
{0.7792,0.2528},
{0.8852,0.4019},
{0.7792,0.4019},
{0.8852,0.5398},
{0.7792,0.591553},
{0.8852,0.6796},
{0.8852,0.8493},
{0.7792,0.8493},
{0.8852,0.9871},
{0.7792,0.9871},
{0.8852,0.0962},
{0.8852,0.0014},
{0.7792,0.0014},
{0.7792,0.0962},
{0.8852,0.2528},
{0.7792,0.2528},
{0.8852,0.4019},
{0.7792,0.4019},
{0.8852,0.5398},
{0.7792,0.583214},
{0.8852,0.6796},
{0.8852,0.8493},
{0.7792,0.8493},
{0.8852,0.9871},
{0.7792,0.9871},
{0.6649,0.0089},
{0.5812,0.0089},
{0.5812,0.117599},
{0.6649,0.164632},
{0.5812,0.265},
{0.6649,0.265},
{0.5812,0.3346},
{0.6649,0.3346},
{0.5812,0.4043},
{0.6649,0.4043},
{0.5812,0.127353},
{0.5812,0.0089},
{0.6649,0.0089},
{0.6649,0.168807},
{0.5812,0.264222},
{0.6649,0.33454},
{0.5812,0.4043},
{0.6649,0.4043},
{0.0709,0.378867},
{0.0709,0.3585},
{0.0041,0.358411},
{0.0041,0.458563},
{0.0709,0.486063},
{0.0041,0.4869},
{0.0709,0.5142},
{0.0041,0.5142},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.597043},
{0.0041,0.594576},
{0.0041,0.737},
{0.0709,0.737},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.39182},
{0.0041,0.405837},
{0.0709,0.471468},
{0.0041,0.477849},
{0.0709,0.534132},
{0.0041,0.534866},
{0.0709,0.5904},
{0.0041,0.599116},
{0.0709,0.639716},
{0.0041,0.737},
{0.0709,0.737},
{0.0709,0.3759},
{0.0709,0.3585},
{0.0041,0.3585},
{0.0041,0.402677},
{0.0709,0.444917},
{0.0041,0.4596},
{0.0709,0.4869},
{0.0041,0.4869},
{0.0709,0.5142},
{0.0041,0.5142},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.6393},
{0.0041,0.65493},
{0.0709,0.6881},
{0.0709,0.737},
{0.0041,0.737},
{0.0041,0.3585},
{0.0709,0.3585},
{0.0709,0.403562},
{0.0041,0.402551},
{0.0709,0.475113},
{0.0041,0.4596},
{0.0041,0.4869},
{0.0709,0.5142},
{0.0041,0.5142},
{0.0709,0.5416},
{0.0041,0.5416},
{0.0709,0.5904},
{0.0041,0.5904},
{0.0709,0.6393},
{0.0041,0.654124},
{0.0709,0.6881},
{0.0709,0.737},
{0.0041,0.737},
{0.9882,0.118073},
{0.9882,0.0134},
{0.8984,0.013385},
{0.8984,0.16205},
{0.9882,0.295403},
{0.8984,0.319093},
{0.8984,0.594387},
{0.9882,0.585091},
{0.9882,0.783711},
{0.8984,0.781094},
{0.9882,0.8994},
{0.8984,0.986967},
{0.9882,0.9871},
{0.8984,0.013386},
{0.9882,0.0134},
{0.9882,0.118073},
{0.8984,0.162056},
{0.9882,0.295388},
{0.8984,0.319096},
{0.8984,0.594391},
{0.9882,0.585077},
{0.9882,0.783735},
{0.8984,0.781078},
{0.9882,0.8994},
{0.8984,0.986967},
{0.9882,0.9871},
{0.9874,0.118077},
{0.9874,0.0134},
{0.8976,0.013386},
{0.8976,0.162496},
{0.9874,0.294913},
{0.8976,0.319211},
{0.8976,0.558837},
{0.9874,0.581915},
{0.8976,0.674263},
{0.9874,0.759839},
{0.8976,0.787585},
{0.9874,0.8994},
{0.8976,0.8994},
{0.9874,0.9871},
{0.8976,0.9871},
{0.8976,0.013385},
{0.9874,0.0134},
{0.9874,0.118037},
{0.8976,0.162509},
{0.9874,0.294899},
{0.8976,0.319237},
{0.8976,0.55895},
{0.9874,0.581926},
{0.8976,0.674166},
{0.9874,0.75983},
{0.8976,0.787591},
{0.9874,0.8994},
{0.8976,0.8994},
{0.9874,0.9871},
{0.8976,0.9871},
{0.9882,0.11808},
{0.9882,0.0134},
{0.8984,0.013385},
{0.8984,0.163301},
{0.9882,0.246976},
{0.8984,0.338286},
{0.9882,0.456271},
{0.8984,0.5003},
{0.9882,0.580807},
{0.8984,0.59177},
{0.9882,0.770809},
{0.8984,0.73533},
{0.9882,0.8994},
{0.8984,0.8994},
{0.9882,0.9871},
{0.8984,0.9871},
{0.8984,0.013386},
{0.9882,0.0134},
{0.9882,0.118092},
{0.8984,0.163242},
{0.9882,0.246834},
{0.8984,0.33829},
{0.9882,0.456126},
{0.8984,0.5003},
{0.9882,0.580836},
{0.8984,0.591761},
{0.9882,0.770748},
{0.8984,0.735299},
{0.9882,0.8994},
{0.8984,0.8994},
{0.9882,0.9871},
{0.8984,0.9871},
{0.9896,0.118186},
{0.9896,0.0134},
{0.8998,0.117665},
{0.9896,0.244269},
{0.8998,0.260521},
{0.9896,0.382005},
{0.8998,0.477038},
{0.9896,0.5003},
{0.9896,0.577841},
{0.8998,0.583647},
{0.9896,0.774558},
{0.8998,0.775404},
{0.9896,0.8994},
{0.8998,0.8994},
{0.9896,0.9871},
{0.8998,0.9871},
{0.8998,0.0134},
{0.8998,0.0134},
{0.9896,0.0134},
{0.8998,0.117665},
{0.9896,0.118159},
{0.9896,0.244324},
{0.8998,0.260623},
{0.9896,0.38197},
{0.8998,0.477095},
{0.9896,0.5003},
{0.9896,0.577881},
{0.8998,0.583633},
{0.9896,0.774536},
{0.8998,0.775408},
{0.9896,0.8994},
{0.8998,0.8994},
{0.9896,0.9871},
{0.8998,0.9871},
{0.9879,0.145142},
{0.9879,0.0134},
{0.8981,0.141182},
{0.9879,0.332277},
{0.8981,0.341295},
{0.9879,0.582728},
{0.8981,0.589115},
{0.9879,0.767483},
{0.8981,0.735028},
{0.8981,0.8018},
{0.9879,0.8994},
{0.8981,0.8994},
{0.9879,0.9871},
{0.8981,0.9871},
{0.8981,0.0134},
{0.8981,0.013387},
{0.9879,0.0134},
{0.9879,0.118198},
{0.8981,0.162215},
{0.9879,0.250771},
{0.8981,0.321821},
{0.9879,0.375842},
{0.8981,0.556939},
{0.9879,0.582699},
{0.8981,0.719432},
{0.9879,0.767336},
{0.8981,0.8018},
{0.9879,0.8994},
{0.8981,0.8994},
{0.9879,0.9871},
{0.8981,0.9871},
{0.8798,0.084658},
{0.7832,0.0621},
{0.7832,0.0235},
{0.8798,0.0235},
{0.7832,0.1008},
{0.8798,0.158038},
{0.7832,0.1394},
{0.7832,0.180759},
{0.8798,0.2553},
{0.7832,0.2553},
{0.8798,0.3326},
{0.7832,0.3326},
{0.8798,0.415647},
{0.7832,0.4098},
{0.7832,0.4871},
{0.8773,0.5583},
{0.7832,0.5583},
{0.8773,0.6295},
{0.7832,0.6295},
{0.8773,0.7008},
{0.7832,0.7008},
{0.8773,0.7629},
{0.7832,0.773207},
{0.8773,0.8125},
{0.8773,0.8653},
{0.7832,0.8653},
{0.8773,0.905},
{0.7832,0.905},
{0.8773,0.9444},
{0.7832,0.9444},
{0.8798,0.084634},
{0.8798,0.0235},
{0.7832,0.0235},
{0.7832,0.0621},
{0.7832,0.1008},
{0.8798,0.158078},
{0.7832,0.1394},
{0.7832,0.180786},
{0.8798,0.2553},
{0.7832,0.2553},
{0.8798,0.3326},
{0.7832,0.3326},
{0.8798,0.415659},
{0.7832,0.4098},
{0.7832,0.4871},
{0.8773,0.5583},
{0.7832,0.5583},
{0.8773,0.6295},
{0.7832,0.6295},
{0.8773,0.7008},
{0.7832,0.7008},
{0.8773,0.7629},
{0.7832,0.773212},
{0.8773,0.8125},
{0.8773,0.8653},
{0.7832,0.8653},
{0.8773,0.905},
{0.7832,0.905},
{0.8773,0.9444},
{0.7832,0.9444},
{0.8807,0.084625},
{0.7841,0.0621},
{0.7841,0.0235},
{0.8807,0.0235},
{0.7841,0.1008},
{0.8807,0.157859},
{0.7841,0.1394},
{0.7841,0.180773},
{0.8807,0.2553},
{0.7841,0.2553},
{0.8807,0.3326},
{0.7841,0.3326},
{0.8807,0.428794},
{0.7841,0.4098},
{0.7841,0.4871},
{0.8782,0.5583},
{0.784,0.5583},
{0.8782,0.6295},
{0.784,0.6295},
{0.8782,0.7008},
{0.784,0.7008},
{0.8782,0.7629},
{0.784,0.771843},
{0.8782,0.8125},
{0.8782,0.8653},
{0.784,0.8653},
{0.8782,0.905},
{0.784,0.905},
{0.8782,0.9444},
{0.784,0.9444},
{0.8794,0.097343},
{0.7852,0.0764},
{0.7852,0.0405},
{0.8794,0.0405},
{0.7852,0.1123},
{0.8794,0.165539},
{0.7852,0.1482},
{0.7852,0.186587},
{0.8794,0.2558},
{0.7852,0.2558},
{0.8794,0.3275},
{0.7852,0.3275},
{0.8794,0.404971},
{0.7852,0.3993},
{0.7852,0.471},
{0.877,0.5372},
{0.7852,0.5372},
{0.877,0.6034},
{0.7852,0.6034},
{0.877,0.6695},
{0.7852,0.6695},
{0.877,0.7272},
{0.7852,0.726963},
{0.877,0.7733},
{0.877,0.8245},
{0.7852,0.8245},
{0.877,0.8592},
{0.7852,0.8592},
{0.877,0.8957},
{0.7852,0.8957},
{0.8794,0.097298},
{0.8794,0.0405},
{0.7852,0.0405},
{0.7852,0.0764},
{0.7852,0.1123},
{0.8794,0.165526},
{0.7852,0.1482},
{0.7852,0.186581},
{0.8794,0.2558},
{0.7852,0.2558},
{0.8794,0.3275},
{0.7852,0.3275},
{0.8794,0.404947},
{0.7852,0.3993},
{0.7852,0.471},
{0.877,0.5372},
{0.7852,0.5372},
{0.877,0.6034},
{0.7852,0.6034},
{0.877,0.6695},
{0.7852,0.6695},
{0.877,0.7272},
{0.7852,0.726964},
{0.877,0.7733},
{0.877,0.8245},
{0.7852,0.8245},
{0.877,0.8592},
{0.7852,0.8592},
{0.877,0.8957},
{0.7852,0.8957},
{0.8807,0.084679},
{0.8807,0.0235},
{0.7841,0.0235},
{0.7841,0.0621},
{0.7841,0.1008},
{0.8807,0.157842},
{0.7841,0.1394},
{0.7841,0.180787},
{0.8807,0.2553},
{0.7841,0.2553},
{0.8807,0.3326},
{0.7841,0.3326},
{0.8807,0.428752},
{0.7841,0.4098},
{0.7841,0.4871},
{0.8782,0.5583},
{0.784,0.5583},
{0.8782,0.6295},
{0.784,0.6295},
{0.8782,0.7008},
{0.784,0.7008},
{0.8782,0.7629},
{0.784,0.771856},
{0.8782,0.8125},
{0.8782,0.8653},
{0.784,0.8653},
{0.8782,0.905},
{0.784,0.905},
{0.8782,0.9444},
{0.784,0.9444},
{0.9882,0.0134},
{0.9882,0.142949},
{0.8984,0.117657},
{0.8984,0.0134},
{0.9882,0.3267},
{0.8984,0.265059},
{0.8984,0.386871},
{0.9882,0.56933},
{0.8984,0.58383},
{0.9882,0.771842},
{0.8984,0.760413},
{0.8984,0.891683},
{0.9882,0.8994},
{0.9882,0.9871},
{0.8984,0.9871},
{0.8794,0.084643},
{0.7828,0.0621},
{0.7828,0.0235},
{0.8794,0.0235},
{0.7828,0.1008},
{0.8794,0.157528},
{0.7828,0.1394},
{0.7828,0.180853},
{0.8794,0.2553},
{0.7828,0.2553},
{0.8794,0.3326},
{0.7828,0.3326},
{0.8794,0.427362},
{0.7828,0.432836},
{0.8769,0.5583},
{0.7828,0.5583},
{0.8769,0.6295},
{0.7828,0.6295},
{0.8769,0.75914},
{0.7828,0.7008},
{0.7828,0.770316},
{0.8769,0.8125},
{0.8769,0.8653},
{0.7828,0.8653},
{0.8769,0.905},
{0.7828,0.905},
{0.8769,0.9444},
{0.7828,0.9444},
{0.8794,0.084676},
{0.8794,0.0235},
{0.7828,0.0235},
{0.7828,0.0621},
{0.7828,0.1008},
{0.8794,0.157554},
{0.7828,0.1394},
{0.7828,0.180817},
{0.8794,0.2553},
{0.7828,0.2553},
{0.8794,0.3326},
{0.7828,0.3326},
{0.8794,0.427363},
{0.7828,0.432804},
{0.8769,0.5583},
{0.7828,0.5583},
{0.8769,0.6295},
{0.7828,0.6295},
{0.8769,0.75915},
{0.7828,0.7008},
{0.7828,0.770321},
{0.8769,0.8125},
{0.8769,0.8653},
{0.7828,0.8653},
{0.8769,0.905},
{0.7828,0.905},
{0.8769,0.9444},
{0.7828,0.9444},
{0.8798,0.0621},
{0.7832,0.0621},
{0.7832,0.0235},
{0.8798,0.0235},
{0.8798,0.118849},
{0.7832,0.1008},
{0.7832,0.1394},
{0.8798,0.183191},
{0.7832,0.183492},
{0.8798,0.2553},
{0.7832,0.2553},
{0.8798,0.3326},
{0.7832,0.3326},
{0.8798,0.4098},
{0.7832,0.4098},
{0.8798,0.4871},
{0.7832,0.557685},
{0.8773,0.5583},
{0.8773,0.6295},
{0.7832,0.6295},
{0.8773,0.7008},
{0.7832,0.7008},
{0.8773,0.7629},
{0.7832,0.774092},
{0.8773,0.8125},
{0.8773,0.8653},
{0.7832,0.8653},
{0.8773,0.905},
{0.7832,0.905},
{0.8773,0.9444},
{0.7832,0.9444},
{0.9927,0.146401},
{0.9927,0.0134},
{0.9029,0.141768},
{0.9927,0.311236},
{0.9029,0.350081},
{0.9927,0.473102},
{0.9029,0.585697},
{0.9927,0.583686},
{0.9927,0.769193},
{0.9029,0.775034},
{0.9927,0.8994},
{0.9029,0.8994},
{0.9927,0.9871},
{0.9029,0.9871},
{0.9029,0.0134},
{0.7832,0.0235},
{0.7832,0.0621},
{0.8798,0.0621},
{0.8798,0.118882},
{0.7832,0.1008},
{0.7832,0.1394},
{0.8798,0.18175},
{0.7832,0.182094},
{0.8798,0.2553},
{0.7832,0.2553},
{0.8798,0.3326},
{0.7832,0.3326},
{0.8798,0.4098},
{0.7832,0.4098},
{0.8798,0.4871},
{0.7832,0.557696},
{0.8773,0.5583},
{0.8773,0.6295},
{0.7832,0.6295},
{0.8773,0.7008},
{0.7832,0.7008},
{0.8773,0.7629},
{0.7832,0.774152},
{0.8773,0.8125},
{0.8773,0.8653},
{0.7832,0.8653},
{0.8773,0.905},
{0.7832,0.905},
{0.8773,0.9444},
{0.7832,0.9444},
{0.8798,0.0235},
{0.9927,0.0134},
{0.9927,0.142505},
{0.9029,0.117696},
{0.9029,0.0134},
{0.9927,0.325107},
{0.9029,0.265272},
{0.9029,0.387484},
{0.9927,0.546475},
{0.9029,0.585709},
{0.9927,0.680549},
{0.9029,0.775033},
{0.9927,0.786665},
{0.9927,0.8994},
{0.9029,0.8994},
{0.9927,0.9871},
{0.9029,0.9871},
{0.9882,0.147004},
{0.9882,0.0134},
{0.8984,0.14212},
{0.9882,0.313097},
{0.8984,0.351955},
{0.9882,0.460219},
{0.8984,0.583821},
{0.9882,0.58481},
{0.9882,0.771873},
{0.8984,0.76026},
{0.8984,0.891725},
{0.9882,0.8994},
{0.9882,0.9871},
{0.8984,0.9871},
{0.8984,0.0134},
{0.8798,0.084704},
{0.7832,0.0621},
{0.7832,0.0235},
{0.8798,0.0235},
{0.7832,0.1008},
{0.8798,0.156771},
{0.7832,0.151402},
{0.7832,0.253762},
{0.8798,0.2553},
{0.8798,0.3326},
{0.7832,0.3326},
{0.8798,0.4098},
{0.7832,0.4098},
{0.877407,0.555238},
{0.7832,0.556643},
{0.8773,0.6295},
{0.7832,0.6295},
{0.8773,0.7008},
{0.7832,0.7008},
{0.8773,0.7629},
{0.7832,0.773454},
{0.8773,0.8125},
{0.8773,0.8653},
{0.7832,0.8653},
{0.8773,0.905},
{0.7832,0.905},
{0.8773,0.9444},
{0.7832,0.9444},
{0.7832,0.0235},
{0.7832,0.0621},
{0.8798,0.084717},
{0.7832,0.1008},
{0.8798,0.156651},
{0.7832,0.1394},
{0.7832,0.181202},
{0.8798,0.2553},
{0.7832,0.2553},
{0.8798,0.3326},
{0.7832,0.3326},
{0.8798,0.4098},
{0.7832,0.4098},
{0.877407,0.555247},
{0.7832,0.556633},
{0.8773,0.6295},
{0.7832,0.6295},
{0.8773,0.7008},
{0.7832,0.7008},
{0.8773,0.7629},
{0.7832,0.773496},
{0.8773,0.8125},
{0.8773,0.8653},
{0.7832,0.8653},
{0.8773,0.905},
{0.7832,0.905},
{0.8773,0.9444},
{0.7832,0.9444},
{0.8798,0.0235},
{0.8798,0.084748},
{0.7832,0.0621},
{0.7832,0.0235},
{0.8798,0.0235},
{0.7832,0.1008},
{0.8798,0.156197},
{0.7832,0.151429},
{0.7832,0.254181},
{0.8798,0.2553},
{0.8798,0.3326},
{0.7832,0.3326},
{0.8798,0.4098},
{0.7832,0.4098},
{0.877483,0.553085},
{0.7832,0.556162},
{0.8773,0.6295},
{0.7832,0.6295},
{0.8773,0.75931},
{0.7832,0.7008},
{0.7832,0.77414},
{0.8773,0.8653},
{0.7832,0.8653},
{0.8773,0.905},
{0.7832,0.905},
{0.8773,0.9444},
{0.7832,0.9444},
{0.7832,0.0235},
{0.7832,0.0621},
{0.8798,0.084717},
{0.7832,0.1008},
{0.8798,0.156407},
{0.7832,0.1394},
{0.7832,0.180776},
{0.8798,0.2553},
{0.7832,0.2553},
{0.8798,0.3326},
{0.7832,0.3326},
{0.8798,0.4098},
{0.7832,0.4098},
{0.877484,0.553062},
{0.7832,0.556149},
{0.8773,0.6295},
{0.7832,0.6295},
{0.8773,0.759301},
{0.7832,0.7008},
{0.7832,0.774163},
{0.8773,0.8653},
{0.7832,0.8653},
{0.8773,0.905},
{0.7832,0.905},
{0.8773,0.9444},
{0.7832,0.9444},
{0.8798,0.0235},
{0.6536,0.423292},
{0.6536,0.3867},
{0.5818,0.3867},
{0.5818,0.432316},
{0.6536,0.486604},
{0.5818,0.521416},
{0.6536,0.5257},
{0.6536,0.586274},
{0.5818,0.568105},
{0.6536,0.653061},
{0.5818,0.6516},
{0.5818,0.718014},
{0.6536,0.753844},
{0.5818,0.7774},
{0.6536,0.833569},
{0.5818,0.842163},
{0.6536,0.932611},
{0.5818,0.936705},
{0.6536,0.9871},
{0.5818,0.9871},
{0.5818,0.3867},
{0.6536,0.3867},
{0.6536,0.423349},
{0.5818,0.433345},
{0.6536,0.479814},
{0.6536,0.518481},
{0.5818,0.519629},
{0.6536,0.575702},
{0.5818,0.5677},
{0.5818,0.644264},
{0.6536,0.663719},
{0.5818,0.705913},
{0.6536,0.753393},
{0.5818,0.807922},
{0.6536,0.832491},
{0.5818,0.889224},
{0.6536,0.932651},
{0.5818,0.987003},
{0.6536,0.9871},
{0.8744,0.0911},
{0.8744,0.023801},
{0.7857,0.089915},
{0.8744,0.160755},
{0.7857,0.158937},
{0.8744,0.225015},
{0.7857,0.22398},
{0.8744,0.3142},
{0.7857,0.327471},
{0.8744,0.430808},
{0.7857,0.4488},
{0.8744,0.5161},
{0.7857,0.5161},
{0.8744,0.612919},
{0.7857,0.613111},
{0.8744,0.740752},
{0.7857,0.754551},
{0.8744,0.899679},
{0.7857,0.906182},
{0.8744,0.9871},
{0.7857,0.9871},
{0.7857,0.0238},
{0.8744,0.023801},
{0.8744,0.121638},
{0.7857,0.110967},
{0.7857,0.0238},
{0.8744,0.193605},
{0.7857,0.193587},
{0.8744,0.2469},
{0.7857,0.2469},
{0.8744,0.3142},
{0.7857,0.3142},
{0.8744,0.382922},
{0.7857,0.3815},
{0.7857,0.529256},
{0.8744,0.5161},
{0.8744,0.612101},
{0.7857,0.699681},
{0.8744,0.739037},
{0.7857,0.830078},
{0.8744,0.899709},
{0.7857,0.986944},
{0.8744,0.9871},
{0.9927,0.083},
{0.9927,0.0134},
{0.9029,0.013401},
{0.9029,0.083},
{0.9927,0.1177},
{0.9029,0.1177},
{0.9927,0.1525},
{0.9029,0.1525},
{0.9927,0.195329},
{0.9029,0.194852},
{0.9927,0.2916},
{0.9029,0.2916},
{0.9927,0.3612},
{0.9029,0.3612},
{0.9927,0.4307},
{0.9029,0.440394},
{0.9927,0.523197},
{0.9029,0.612592},
{0.9927,0.646685},
{0.9029,0.787838},
{0.9927,0.793864},
{0.9927,0.8994},
{0.9029,0.8994},
{0.9927,0.9871},
{0.9029,0.9871},
{0.8798,0.085883},
{0.7832,0.0592},
{0.7832,0.0235},
{0.8798,0.0235},
{0.7832,0.095},
{0.8798,0.1307},
{0.7832,0.1307},
{0.8798,0.1664},
{0.7832,0.1664},
{0.8798,0.222407},
{0.7832,0.221499},
{0.8798,0.319101},
{0.7832,0.321369},
{0.8798,0.4523},
{0.7832,0.50685},
{0.8773,0.5182},
{0.8773,0.5841},
{0.7832,0.5841},
{0.8773,0.65},
{0.7832,0.65},
{0.8773,0.7075},
{0.7832,0.7075},
{0.8773,0.7533},
{0.7832,0.7533},
{0.8773,0.8022},
{0.7832,0.8022},
{0.8773,0.8219},
{0.7832,0.8219},
{0.8773,0.9203},
{0.7832,0.9203},
{0.7832,0.0235},
{0.7832,0.0592},
{0.8798,0.085881},
{0.7832,0.095},
{0.8798,0.1307},
{0.7832,0.1307},
{0.8798,0.1664},
{0.7832,0.1664},
{0.8798,0.220831},
{0.7832,0.2022},
{0.7832,0.2379},
{0.8798,0.319489},
{0.7832,0.321821},
{0.8798,0.4523},
{0.7832,0.506826},
{0.8773,0.5182},
{0.8773,0.5841},
{0.7832,0.5841},
{0.8773,0.65},
{0.7832,0.65},
{0.8773,0.7075},
{0.7832,0.7075},
{0.8773,0.7533},
{0.7832,0.7533},
{0.8773,0.8022},
{0.7832,0.8022},
{0.8773,0.8219},
{0.7832,0.8219},
{0.8773,0.9203},
{0.7832,0.9203},
{0.8798,0.0235},
{0.8744,0.0911},
{0.8744,0.0238},
{0.7857,0.089916},
{0.8744,0.160755},
{0.7857,0.158937},
{0.8744,0.225017},
{0.7857,0.223978},
{0.8744,0.3142},
{0.7857,0.327471},
{0.8744,0.430828},
{0.7857,0.4488},
{0.8744,0.5161},
{0.7857,0.5161},
{0.8744,0.612923},
{0.7857,0.613092},
{0.8744,0.740749},
{0.7857,0.754528},
{0.8744,0.899685},
{0.7857,0.906164},
{0.8744,0.9871},
{0.7857,0.9871},
{0.7857,0.0238},
{0.8744,0.0238},
{0.8744,0.121675},
{0.7857,0.111049},
{0.7857,0.0238},
{0.8744,0.193567},
{0.7857,0.193591},
{0.8744,0.2469},
{0.7857,0.2469},
{0.8744,0.3142},
{0.7857,0.3142},
{0.8744,0.382903},
{0.7857,0.3815},
{0.7857,0.529163},
{0.8744,0.5161},
{0.8744,0.612106},
{0.7857,0.699654},
{0.8744,0.739021},
{0.7857,0.830045},
{0.8744,0.899667},
{0.7857,0.986944},
{0.8744,0.9871},
{0.8744,0.091},
{0.8744,0.0238},
{0.7857,0.089919},
{0.8744,0.160736},
{0.7857,0.159024},
{0.8744,0.224987},
{0.7857,0.223996},
{0.8744,0.3142},
{0.7857,0.327564},
{0.8744,0.431013},
{0.7857,0.4488},
{0.8744,0.5161},
{0.7857,0.5161},
{0.8744,0.61165},
{0.7857,0.610438},
{0.8744,0.741352},
{0.7857,0.753915},
{0.8744,0.900716},
{0.7857,0.902272},
{0.8744,0.9871},
{0.7857,0.9871},
{0.7857,0.0238},
{0.9029,0.013401},
{0.9927,0.0134},
{0.9927,0.083},
{0.9029,0.083},
{0.9927,0.1177},
{0.9029,0.1177},
{0.9927,0.1525},
{0.9029,0.1525},
{0.9927,0.196046},
{0.9029,0.195591},
{0.9927,0.2916},
{0.9029,0.2916},
{0.9927,0.3612},
{0.9029,0.3612},
{0.9927,0.4307},
{0.9029,0.442957},
{0.9927,0.52315},
{0.9029,0.612849},
{0.9927,0.646669},
{0.9029,0.787857},
{0.9927,0.793882},
{0.9927,0.8994},
{0.9029,0.8994},
{0.9927,0.9871},
{0.9029,0.9871},
{0.7857,0.023801},
{0.8744,0.0238},
{0.8744,0.121563},
{0.7857,0.118767},
{0.8744,0.19355},
{0.7857,0.193575},
{0.8744,0.2469},
{0.7857,0.2469},
{0.8744,0.3142},
{0.7857,0.3142},
{0.8744,0.383008},
{0.7857,0.3815},
{0.7857,0.53067},
{0.8744,0.5161},
{0.8744,0.610525},
{0.7857,0.699407},
{0.8744,0.739742},
{0.7857,0.840676},
{0.8744,0.900741},
{0.7857,0.9198},
{0.8744,0.9871},
{0.7857,0.9871},
{0.8984,0.013385},
{0.9882,0.0134},
{0.9882,0.141718},
{0.8984,0.161479},
{0.9882,0.31489},
{0.8984,0.309178},
{0.8984,0.499665},
{0.9882,0.559926},
{0.8984,0.604225},
{0.9882,0.775211},
{0.8984,0.772336},
{0.8984,0.889307},
{0.9882,0.8994},
{0.9882,0.9871},
{0.8984,0.9871},
{0.9882,0.118059},
{0.9882,0.0134},
{0.8984,0.013385},
{0.8984,0.161488},
{0.9882,0.255682},
{0.8984,0.337218},
{0.9882,0.362395},
{0.8984,0.579943},
{0.9882,0.576469},
{0.9882,0.779457},
{0.8984,0.779808},
{0.9882,0.8994},
{0.8984,0.986958},
{0.9882,0.9871},
{0.9879,0.111891},
{0.9879,0.013505},
{0.8981,0.062012},
{0.8981,0.140587},
{0.9879,0.187317},
{0.8981,0.206691},
{0.9879,0.29998},
{0.8981,0.300541},
{0.9879,0.459778},
{0.8981,0.460785},
{0.9879,0.599572},
{0.8981,0.605672},
{0.9879,0.721931},
{0.8981,0.7089},
{0.8981,0.799218},
{0.9879,0.848886},
{0.8981,0.987054},
{0.9879,0.9871},
{0.8981,0.0134},
{0.8794,0.0621},
{0.8794,0.0235},
{0.7828,0.0235},
{0.7828,0.0621},
{0.8794,0.118788},
{0.7828,0.1008},
{0.7828,0.1394},
{0.8794,0.188758},
{0.7828,0.180898},
{0.8794,0.2553},
{0.7828,0.2553},
{0.8794,0.3326},
{0.7828,0.3326},
{0.8794,0.4098},
{0.7828,0.4098},
{0.877325,0.546209},
{0.7828,0.545954},
{0.8769,0.6295},
{0.7828,0.6295},
{0.8769,0.7008},
{0.7828,0.7008},
{0.8769,0.785774},
{0.7828,0.762716},
{0.8769,0.8653},
{0.7828,0.8653},
{0.8769,0.905},
{0.7828,0.905},
{0.8769,0.9444},
{0.7828,0.9444},
{0.9879,0.013506},
{0.9879,0.111888},
{0.8981,0.062059},
{0.8981,0.0134},
{0.9879,0.193376},
{0.8981,0.14059},
{0.9879,0.310366},
{0.8981,0.210907},
{0.8981,0.311973},
{0.9879,0.562597},
{0.8981,0.572126},
{0.9879,0.754448},
{0.8981,0.738482},
{0.8981,0.846766},
{0.9879,0.98708},
{0.8981,0.9871},
{0.7828,0.0235},
{0.8794,0.0235},
{0.8794,0.0621},
{0.7828,0.0621},
{0.8794,0.118843},
{0.7828,0.1008},
{0.7828,0.1394},
{0.8794,0.188791},
{0.7828,0.180944},
{0.8794,0.2553},
{0.7828,0.2553},
{0.8794,0.3326},
{0.7828,0.3326},
{0.8794,0.4098},
{0.7828,0.4098},
{0.877312,0.54656},
{0.7828,0.546331},
{0.8769,0.6295},
{0.7828,0.6295},
{0.8769,0.7008},
{0.7828,0.7008},
{0.8769,0.783549},
{0.7828,0.762013},
{0.8769,0.8653},
{0.7828,0.8653},
{0.8769,0.905},
{0.7828,0.905},
{0.8769,0.9444},
{0.7828,0.9444},
{0.874,0.1117},
{0.8744,0.0238},
{0.7857,0.110374},
{0.8744,0.15966},
{0.7857,0.158973},
{0.8744,0.225013},
{0.7857,0.223987},
{0.8744,0.3142},
{0.7857,0.327493},
{0.8744,0.430819},
{0.7857,0.4488},
{0.8744,0.5161},
{0.7857,0.5161},
{0.8744,0.612899},
{0.7857,0.612971},
{0.8744,0.740757},
{0.7857,0.754557},
{0.8744,0.899708},
{0.7857,0.906166},
{0.8744,0.9871},
{0.7857,0.9871},
{0.7857,0.0238},
{0.8744,0.023801},
{0.874215,0.130144},
{0.7857,0.123738},
{0.7857,0.0238},
{0.8744,0.193624},
{0.7857,0.193579},
{0.8744,0.2469},
{0.7857,0.2469},
{0.8744,0.3142},
{0.7857,0.3142},
{0.8744,0.382931},
{0.7857,0.3815},
{0.7857,0.529269},
{0.8744,0.5161},
{0.8744,0.612105},
{0.7857,0.699663},
{0.8744,0.73901},
{0.7857,0.830082},
{0.8744,0.899678},
{0.7857,0.986945},
{0.8744,0.9871},
{0.6524,0.4315},
{0.5786,0.4315},
{0.5786,0.4082},
{0.6524,0.4082},
{0.6524,0.4548},
{0.5786,0.4548},
{0.6524,0.4782},
{0.5786,0.4782},
{0.6524,0.509987},
{0.5786,0.5015},
{0.5786,0.5248},
{0.6524,0.5481},
{0.5786,0.5481},
{0.6524,0.5965},
{0.5786,0.5947},
{0.5786,0.6414},
{0.6524,0.688},
{0.5786,0.688},
{0.6505,0.731},
{0.5786,0.731},
{0.6505,0.774},
{0.5786,0.774},
{0.6505,0.817},
{0.5786,0.817},
{0.6505,0.8545},
{0.5786,0.8545},
{0.6505,0.8844},
{0.5786,0.8844},
{0.6505,0.9162},
{0.5786,0.9162},
{0.6505,0.9402},
{0.5786,0.9402},
{0.6505,0.9827},
{0.5786,0.9827},
{0.5786,0.4082},
{0.5786,0.4315},
{0.6524,0.4315},
{0.6524,0.4548},
{0.5786,0.4548},
{0.6524,0.4782},
{0.5786,0.4782},
{0.6524,0.510616},
{0.5786,0.5015},
{0.5786,0.5248},
{0.6524,0.5481},
{0.5786,0.5481},
{0.6524,0.596683},
{0.5786,0.5947},
{0.5786,0.6414},
{0.6524,0.688},
{0.5786,0.688},
{0.6505,0.731},
{0.5786,0.731},
{0.6505,0.774},
{0.5786,0.774},
{0.6505,0.817},
{0.5786,0.817},
{0.6505,0.8545},
{0.5786,0.8545},
{0.6505,0.8844},
{0.5786,0.8844},
{0.6505,0.9162},
{0.5786,0.9162},
{0.6505,0.9402},
{0.5786,0.9402},
{0.6505,0.9827},
{0.5786,0.9827},
{0.6524,0.4082},
{0.8798,0.081923},
{0.7832,0.0621},
{0.7832,0.0235},
{0.8798,0.0235},
{0.7832,0.1008},
{0.8798,0.1394},
{0.7832,0.1394},
{0.8798,0.194513},
{0.7832,0.178},
{0.7832,0.2167},
{0.8798,0.2553},
{0.7832,0.2553},
{0.8798,0.332121},
{0.7832,0.3326},
{0.7832,0.4098},
{0.8798,0.4871},
{0.7832,0.4871},
{0.8773,0.5583},
{0.7832,0.5583},
{0.8773,0.6295},
{0.7832,0.6295},
{0.8773,0.7008},
{0.7832,0.7008},
{0.8773,0.7629},
{0.7832,0.7629},
{0.8773,0.8125},
{0.7832,0.8125},
{0.8773,0.8653},
{0.7832,0.8653},
{0.8773,0.905},
{0.7832,0.905},
{0.8773,0.9444},
{0.7832,0.9444},
{0.8798,0.07944},
{0.7832,0.0605},
{0.7832,0.0235},
{0.8798,0.0235},
{0.7832,0.0975},
{0.8798,0.1345},
{0.7832,0.1345},
{0.8798,0.185238},
{0.7832,0.1714},
{0.7832,0.2084},
{0.8798,0.2454},
{0.7832,0.2454},
{0.8798,0.318649},
{0.7832,0.3194},
{0.7832,0.3934},
{0.8798,0.4673},
{0.7832,0.4673},
{0.8773,0.5355},
{0.7832,0.5355},
{0.8773,0.6037},
{0.7832,0.6037},
{0.8773,0.6719},
{0.7832,0.6719},
{0.8773,0.7314},
{0.7832,0.7314},
{0.8773,0.7789},
{0.7832,0.7789},
{0.8773,0.8294},
{0.7832,0.8294},
{0.8773,0.8675},
{0.7832,0.8675},
{0.8773,0.9614},
{0.7832,0.9614},
{0.7832,0.0235},
{0.7832,0.0621},
{0.8798,0.081896},
{0.7832,0.1008},
{0.8798,0.1394},
{0.7832,0.1394},
{0.8798,0.194489},
{0.7832,0.178},
{0.7832,0.2167},
{0.8798,0.2553},
{0.7832,0.2553},
{0.8798,0.332072},
{0.7832,0.3326},
{0.7832,0.4098},
{0.8798,0.4871},
{0.7832,0.4871},
{0.8773,0.5583},
{0.7832,0.5583},
{0.8773,0.6295},
{0.7832,0.6295},
{0.8773,0.7008},
{0.7832,0.7008},
{0.8773,0.7629},
{0.7832,0.7629},
{0.8773,0.8125},
{0.7832,0.8125},
{0.8773,0.8653},
{0.7832,0.8653},
{0.8773,0.905},
{0.7832,0.905},
{0.8773,0.9444},
{0.7832,0.9444},
{0.8798,0.0235},
{0.5727,0.4073},
{0.5727,0.4517},
{0.6625,0.4517},
{0.6625,0.4961},
{0.5727,0.4961},
{0.6625,0.5405},
{0.5727,0.5405},
{0.6625,0.585},
{0.5727,0.585},
{0.6625,0.6294},
{0.5727,0.6294},
{0.6625,0.7182},
{0.5727,0.7182},
{0.6625,0.807},
{0.5727,0.807},
{0.6625,0.8959},
{0.5727,0.8959},
{0.6625,0.9847},
{0.5727,0.9847},
{0.6625,0.4073},
{0.7832,0.0235},
{0.7832,0.0605},
{0.8798,0.079413},
{0.7832,0.0975},
{0.8798,0.1345},
{0.7832,0.1345},
{0.8798,0.186355},
{0.7832,0.1714},
{0.7832,0.2084},
{0.8798,0.2454},
{0.7832,0.2454},
{0.8798,0.318839},
{0.7832,0.3194},
{0.7832,0.3934},
{0.8798,0.4673},
{0.7832,0.4673},
{0.8773,0.5355},
{0.7832,0.5355},
{0.8773,0.6037},
{0.7832,0.6037},
{0.8773,0.6719},
{0.7832,0.6719},
{0.8773,0.7314},
{0.7832,0.7314},
{0.8773,0.7789},
{0.7832,0.7789},
{0.8773,0.8294},
{0.7832,0.8294},
{0.8773,0.8675},
{0.7832,0.8675},
{0.8773,0.9614},
{0.7832,0.9614},
{0.8798,0.0235},
{0.8798,0.077541},
{0.7832,0.0592},
{0.7832,0.0235},
{0.8798,0.0235},
{0.7832,0.095},
{0.8798,0.1307},
{0.7832,0.1307},
{0.8798,0.181665},
{0.7832,0.1664},
{0.7832,0.2022},
{0.8798,0.2379},
{0.7832,0.2379},
{0.8798,0.308965},
{0.7832,0.3094},
{0.7832,0.3809},
{0.8798,0.4523},
{0.7832,0.4523},
{0.8773,0.5182},
{0.7832,0.5182},
{0.8773,0.5841},
{0.7832,0.5841},
{0.8773,0.65},
{0.7832,0.65},
{0.8773,0.7075},
{0.7832,0.7075},
{0.8773,0.7533},
{0.7832,0.7533},
{0.8773,0.8022},
{0.7832,0.8022},
{0.8773,0.8389},
{0.7832,0.8389},
{0.8773,0.9203},
{0.7832,0.9203},
{0.874,0.1117},
{0.8744,0.0238},
{0.7857,0.110357},
{0.8744,0.159668},
{0.7857,0.158951},
{0.8744,0.225056},
{0.7857,0.224004},
{0.8744,0.3142},
{0.7857,0.327471},
{0.8744,0.430825},
{0.7857,0.4488},
{0.8744,0.5161},
{0.7857,0.5161},
{0.8744,0.612925},
{0.7857,0.613124},
{0.8744,0.740751},
{0.7857,0.754534},
{0.8744,0.899702},
{0.7857,0.906161},
{0.8744,0.9871},
{0.7857,0.9871},
{0.7857,0.0238},
{0.7832,0.0235},
{0.7832,0.0592},
{0.8798,0.077554},
{0.7832,0.095},
{0.8798,0.1307},
{0.7832,0.1307},
{0.8798,0.181684},
{0.7832,0.1664},
{0.7832,0.2022},
{0.8798,0.2379},
{0.7832,0.2379},
{0.8798,0.308898},
{0.7832,0.3094},
{0.7832,0.3809},
{0.8798,0.4523},
{0.7832,0.4523},
{0.8773,0.5182},
{0.7832,0.5182},
{0.8773,0.5841},
{0.7832,0.5841},
{0.8773,0.65},
{0.7832,0.65},
{0.8773,0.7075},
{0.7832,0.7075},
{0.8773,0.7533},
{0.7832,0.7533},
{0.8773,0.8022},
{0.7832,0.8022},
{0.8773,0.8389},
{0.7832,0.8389},
{0.8773,0.9203},
{0.7832,0.9203},
{0.8798,0.0235},
{0.8744,0.0238},
{0.874215,0.13013},
{0.7857,0.123736},
{0.7857,0.0238},
{0.8744,0.193534},
{0.7857,0.193537},
{0.8744,0.2469},
{0.7857,0.2469},
{0.8744,0.3142},
{0.7857,0.3142},
{0.8744,0.382924},
{0.7857,0.3815},
{0.7857,0.529255},
{0.8744,0.5161},
{0.8744,0.612109},
{0.7857,0.699663},
{0.8744,0.739094},
{0.7857,0.830026},
{0.8744,0.899729},
{0.7857,0.986944},
{0.8744,0.9871},
{0.8798,0.077545},
{0.7832,0.0592},
{0.7832,0.0235},
{0.8798,0.0235},
{0.7832,0.095},
{0.8798,0.1307},
{0.7832,0.1307},
{0.8798,0.181711},
{0.7832,0.1664},
{0.7832,0.2022},
{0.8798,0.2379},
{0.7832,0.2379},
{0.8798,0.308946},
{0.7832,0.3094},
{0.7832,0.3809},
{0.8798,0.4523},
{0.7832,0.4523},
{0.8773,0.5182},
{0.7832,0.5182},
{0.8773,0.5841},
{0.7832,0.5841},
{0.8773,0.65},
{0.7832,0.65},
{0.8773,0.7075},
{0.7832,0.7075},
{0.8773,0.7533},
{0.7832,0.7533},
{0.8773,0.8022},
{0.7832,0.8022},
{0.8773,0.8389},
{0.7832,0.8389},
{0.8773,0.9238},
{0.7832,0.9238},
{0.7832,0.0235},
{0.7832,0.0592},
{0.8798,0.077505},
{0.7832,0.095},
{0.8798,0.1307},
{0.7832,0.1307},
{0.8798,0.181686},
{0.7832,0.1664},
{0.7832,0.2022},
{0.8798,0.2379},
{0.7832,0.2379},
{0.8798,0.308893},
{0.7832,0.3094},
{0.7832,0.3809},
{0.8798,0.4523},
{0.7832,0.4523},
{0.8773,0.5182},
{0.7832,0.5182},
{0.8773,0.5841},
{0.7832,0.5841},
{0.8773,0.65},
{0.7832,0.65},
{0.8773,0.7075},
{0.7832,0.7075},
{0.8773,0.7533},
{0.7832,0.7533},
{0.8773,0.8022},
{0.7832,0.8022},
{0.8773,0.8389},
{0.7832,0.8389},
{0.8773,0.9238},
{0.7832,0.9238},
{0.8798,0.0235},
{0.8794,0.0621},
{0.8794,0.0235},
{0.7828,0.0235},
{0.7828,0.0621},
{0.8794,0.118788},
{0.7828,0.1008},
{0.7828,0.1394},
{0.8794,0.188723},
{0.7828,0.180899},
{0.8794,0.2553},
{0.7828,0.2553},
{0.8794,0.3326},
{0.7828,0.3326},
{0.8794,0.4098},
{0.7828,0.4098},
{0.877325,0.546209},
{0.7828,0.545957},
{0.8769,0.6295},
{0.7828,0.6295},
{0.8769,0.7008},
{0.7828,0.7008},
{0.8769,0.785763},
{0.7828,0.762718},
{0.8769,0.8653},
{0.7828,0.8653},
{0.8769,0.905},
{0.7828,0.905},
{0.8769,0.9444},
{0.7828,0.9444},
{0.6523,0.465295},
{0.6523,0.404961},
{0.5771,0.434193},
{0.5771,0.487026},
{0.6523,0.523881},
{0.5771,0.539179},
{0.6523,0.582669},
{0.5771,0.582944},
{0.6523,0.680258},
{0.5771,0.742455},
{0.6523,0.800052},
{0.5771,0.81677},
{0.6523,0.883748},
{0.5771,0.889225},
{0.6523,0.979729},
{0.5771,0.979761},
{0.5771,0.4049},
{0.7828,0.0235},
{0.8794,0.0235},
{0.8794,0.0621},
{0.7828,0.0621},
{0.8794,0.118781},
{0.7828,0.1008},
{0.7828,0.1394},
{0.8794,0.188838},
{0.7828,0.180933},
{0.8794,0.2553},
{0.7828,0.2553},
{0.8794,0.3326},
{0.7828,0.3326},
{0.8794,0.4098},
{0.7828,0.4098},
{0.877313,0.546533},
{0.7828,0.546335},
{0.8769,0.6295},
{0.7828,0.6295},
{0.8769,0.7008},
{0.7828,0.7008},
{0.8769,0.783526},
{0.7828,0.762006},
{0.8769,0.8653},
{0.7828,0.8653},
{0.8769,0.905},
{0.7828,0.905},
{0.8769,0.9444},
{0.7828,0.9444},
{0.6523,0.404961},
{0.6523,0.465274},
{0.5771,0.434191},
{0.5771,0.4049},
{0.6523,0.528626},
{0.5771,0.487021},
{0.6523,0.5908},
{0.5771,0.542394},
{0.5771,0.590015},
{0.5771,0.700391},
{0.6523,0.798525},
{0.5771,0.805546},
{0.6523,0.881406},
{0.5771,0.886703},
{0.6523,0.97973},
{0.5771,0.979761},
{0.8793,0.0666},
{0.7862,0.0666},
{0.7862,0.0148},
{0.8793,0.0148},
{0.8793,0.1021},
{0.7862,0.117555},
{0.8793,0.259721},
{0.7862,0.259719},
{0.8793,0.1596},
{0.8793,0.343877},
{0.7862,0.3278},
{0.7862,0.4011},
{0.8793,0.4643},
{0.7862,0.4643},
{0.8793,0.5275},
{0.7862,0.5275},
{0.8793,0.5858},
{0.7862,0.5858},
{0.8793,0.6441},
{0.7862,0.6441},
{0.8793,0.7024},
{0.7862,0.7024},
{0.8793,0.7607},
{0.7862,0.7607},
{0.8793,0.8013},
{0.7862,0.8013},
{0.8793,0.8371},
{0.7862,0.8371},
{0.8793,0.907},
{0.7862,0.907},
{0.8793,0.9633},
{0.7862,0.9633},
{0.5787,0.4093},
{0.6625,0.4093},
{0.6625,0.4535},
{0.5787,0.4535},
{0.6625,0.4978},
{0.5787,0.4978},
{0.6625,0.5421},
{0.5787,0.5421},
{0.6625,0.5863},
{0.5787,0.5863},
{0.6625,0.6306},
{0.5787,0.6306},
{0.6625,0.7191},
{0.5787,0.7191},
{0.6625,0.8076},
{0.5787,0.8076},
{0.6625,0.8962},
{0.5787,0.8962},
{0.6625,0.9847},
{0.5787,0.9847},
{0.7862,0.0148},
{0.7862,0.0666},
{0.8793,0.0666},
{0.8793,0.1021},
{0.7862,0.117555},
{0.8793,0.1596},
{0.8793,0.259842},
{0.7862,0.259842},
{0.8793,0.344645},
{0.7862,0.3278},
{0.7862,0.4011},
{0.8793,0.4643},
{0.7862,0.4643},
{0.8793,0.5275},
{0.7862,0.5275},
{0.8793,0.5858},
{0.7862,0.5858},
{0.8793,0.6441},
{0.7862,0.6441},
{0.8793,0.7024},
{0.7862,0.7024},
{0.8793,0.7607},
{0.7862,0.7607},
{0.8793,0.8013},
{0.7862,0.8013},
{0.8793,0.8371},
{0.7862,0.8371},
{0.8793,0.907},
{0.7862,0.907},
{0.8793,0.9633},
{0.7862,0.9633},
{0.8793,0.0148},
{0.8798,0.077536},
{0.7832,0.0592},
{0.7832,0.0235},
{0.8798,0.0235},
{0.7832,0.095},
{0.8798,0.1307},
{0.7832,0.1307},
{0.8798,0.181688},
{0.7832,0.1664},
{0.7832,0.2022},
{0.8798,0.2379},
{0.7832,0.2379},
{0.8798,0.308958},
{0.7832,0.3094},
{0.7832,0.3809},
{0.8798,0.4523},
{0.7832,0.4523},
{0.8773,0.5182},
{0.7832,0.5182},
{0.8773,0.5841},
{0.7832,0.5841},
{0.8773,0.65},
{0.7832,0.65},
{0.8773,0.7075},
{0.7832,0.7075},
{0.8773,0.7533},
{0.7832,0.7533},
{0.8773,0.8022},
{0.7832,0.8022},
{0.8773,0.8389},
{0.7832,0.8389},
{0.8773,0.9221},
{0.7832,0.9221},
{0.7832,0.0235},
{0.7832,0.0592},
{0.8798,0.077521},
{0.7832,0.095},
{0.8798,0.1307},
{0.7832,0.1307},
{0.8798,0.18171},
{0.7832,0.1664},
{0.7832,0.2022},
{0.8798,0.2379},
{0.7832,0.2379},
{0.8798,0.308909},
{0.7832,0.3094},
{0.7832,0.3809},
{0.8798,0.4523},
{0.7832,0.4523},
{0.8773,0.5182},
{0.7832,0.5182},
{0.8773,0.5841},
{0.7832,0.5841},
{0.8773,0.65},
{0.7832,0.65},
{0.8773,0.7075},
{0.7832,0.7075},
{0.8773,0.7533},
{0.7832,0.7533},
{0.8773,0.8022},
{0.7832,0.8022},
{0.8773,0.8389},
{0.7832,0.8389},
{0.8773,0.9221},
{0.7832,0.9221},
{0.8798,0.0235},
{0.9913,0.013506},
{0.9913,0.112027},
{0.9015,0.062038},
{0.9015,0.0134},
{0.9913,0.19339},
{0.9015,0.140573},
{0.9913,0.310103},
{0.9015,0.210761},
{0.9015,0.311727},
{0.9913,0.563015},
{0.9015,0.572529},
{0.9913,0.767594},
{0.9015,0.738875},
{0.9015,0.882446},
{0.9913,0.987259},
{0.9015,0.9873},
{0.7862,0.0666},
{0.7862,0.0148},
{0.8793,0.0148},
{0.8793,0.0666},
{0.8793,0.1021},
{0.7862,0.117588},
{0.8793,0.1596},
{0.8793,0.25976},
{0.7862,0.259762},
{0.8793,0.343294},
{0.7862,0.3278},
{0.7862,0.4011},
{0.8793,0.4643},
{0.7862,0.4643},
{0.8793,0.5275},
{0.7862,0.5275},
{0.8793,0.5858},
{0.7862,0.5858},
{0.8793,0.6441},
{0.7862,0.6441},
{0.8793,0.7024},
{0.7862,0.7024},
{0.8793,0.7607},
{0.7862,0.7607},
{0.8793,0.8013},
{0.7862,0.8013},
{0.8793,0.8371},
{0.7862,0.8371},
{0.8793,0.907},
{0.7862,0.907},
{0.8793,0.9633},
{0.7862,0.9633},
{0.8793,0.0148},
{0.7862,0.0148},
{0.7862,0.0666},
{0.8793,0.0666},
{0.8793,0.1021},
{0.7862,0.117611},
{0.8793,0.1596},
{0.8793,0.259893},
{0.7862,0.259861},
{0.8793,0.344134},
{0.7862,0.3278},
{0.7862,0.4011},
{0.8793,0.4643},
{0.7862,0.4643},
{0.8793,0.5275},
{0.7862,0.5275},
{0.8793,0.5858},
{0.7862,0.5858},
{0.8793,0.6441},
{0.7862,0.6441},
{0.8793,0.7024},
{0.7862,0.7024},
{0.8793,0.7607},
{0.7862,0.7607},
{0.8793,0.8013},
{0.7862,0.8013},
{0.8793,0.8371},
{0.7862,0.8371},
{0.8793,0.907},
{0.7862,0.907},
{0.8793,0.9633},
{0.7862,0.9633},
{0.8761,0.109719},
{0.8761,0.013503},
{0.7863,0.061053},
{0.7863,0.137686},
{0.8761,0.183529},
{0.7863,0.202449},
{0.8761,0.293502},
{0.7863,0.294066},
{0.8761,0.450013},
{0.7863,0.451006},
{0.8761,0.58659},
{0.7863,0.592782},
{0.8761,0.706271},
{0.7863,0.6933},
{0.7863,0.817133},
{0.8761,0.862112},
{0.7863,0.965168},
{0.8761,0.9652},
{0.7863,0.0134},
{0.9879,0.013505},
{0.9879,0.111921},
{0.8981,0.06201},
{0.8981,0.0134},
{0.9879,0.193325},
{0.8981,0.140626},
{0.9879,0.310226},
{0.8981,0.210852},
{0.8981,0.311697},
{0.9879,0.566333},
{0.8981,0.48753},
{0.8981,0.656315},
{0.9879,0.7089},
{0.9879,0.794113},
{0.8981,0.796706},
{0.9879,0.987025},
{0.8981,0.987043},
{0.8776,0.146797},
{0.7833,0.244964},
{0.7833,0.024257},
{0.8776,0.023801},
{0.8776,0.3464},
{0.7833,0.3464},
{0.8776,0.2684},
{0.8776,0.4243},
{0.7833,0.4243},
{0.8776,0.5023},
{0.7833,0.5023},
{0.8776,0.5802},
{0.7833,0.5802},
{0.8776,0.6582},
{0.7833,0.6582},
{0.8776,0.7361},
{0.7833,0.7361},
{0.8776,0.8141},
{0.7833,0.8141},
{0.8776,0.892},
{0.7833,0.892},
{0.8776,0.9444},
{0.7833,0.9444},
{0.7833,0.024256},
{0.7833,0.241167},
{0.8776,0.148771},
{0.8776,0.2684},
{0.8776,0.3464},
{0.7833,0.3464},
{0.8776,0.4243},
{0.7833,0.4243},
{0.8776,0.5023},
{0.7833,0.5023},
{0.8776,0.5802},
{0.7833,0.5802},
{0.8776,0.6582},
{0.7833,0.6582},
{0.8776,0.7361},
{0.7833,0.7361},
{0.8776,0.8141},
{0.7833,0.8141},
{0.8776,0.892},
{0.7833,0.892},
{0.8776,0.9444},
{0.7833,0.9444},
{0.8776,0.023799},
{0.9879,0.111905},
{0.9879,0.013505},
{0.8981,0.062026},
{0.8981,0.140587},
{0.9879,0.187357},
{0.8981,0.2067},
{0.9879,0.299917},
{0.8981,0.300433},
{0.9879,0.456974},
{0.8981,0.555501},
{0.9879,0.606251},
{0.8981,0.677235},
{0.9879,0.721334},
{0.8981,0.798502},
{0.9879,0.839136},
{0.8981,0.987043},
{0.9879,0.9871},
{0.8981,0.0134},
{0.9879,0.111823},
{0.9879,0.013504},
{0.8981,0.062208},
{0.8981,0.140671},
{0.9879,0.187343},
{0.8981,0.206761},
{0.9879,0.299872},
{0.8981,0.300315},
{0.9879,0.456024},
{0.8981,0.555638},
{0.9879,0.610874},
{0.8981,0.674568},
{0.9879,0.724629},
{0.8981,0.797529},
{0.9879,0.842777},
{0.8981,0.987017},
{0.9879,0.9871},
{0.8981,0.0134},
{0.8742,0.105129},
{0.8742,0.0132},
{0.7826,0.0132},
{0.7826,0.102957},
{0.8742,0.189968},
{0.7826,0.193344},
{0.8735,0.297},
{0.7819,0.297},
{0.873726,0.387125},
{0.7819,0.3665},
{0.7826,0.453991},
{0.8742,0.529553},
{0.7826,0.603189},
{0.8742,0.670836},
{0.7826,0.768098},
{0.8742,0.790874},
{0.7826,0.86996},
{0.8742,0.8992},
{0.8742,0.9869},
{0.7826,0.9869},
{0.9014,0.0132},
{0.9931,0.0132},
{0.9931,0.105089},
{0.9014,0.102981},
{0.9931,0.174717},
{0.9014,0.198064},
{0.9931,0.2218},
{0.9924,0.297},
{0.9008,0.297},
{0.992597,0.384554},
{0.9008,0.3665},
{0.9014,0.453891},
{0.9931,0.529594},
{0.9014,0.603128},
{0.9931,0.670751},
{0.9014,0.768113},
{0.9931,0.790862},
{0.9014,0.869958},
{0.9931,0.8992},
{0.9931,0.9869},
{0.9014,0.9869},
{0.9879,0.013502},
{0.9879,0.111884},
{0.8981,0.062413},
{0.8981,0.0134},
{0.9879,0.19335},
{0.8981,0.140644},
{0.9879,0.315418},
{0.8981,0.210907},
{0.8981,0.311145},
{0.8981,0.488813},
{0.9879,0.531865},
{0.8981,0.657358},
{0.9879,0.675687},
{0.9879,0.791796},
{0.8981,0.796642},
{0.9879,0.986974},
{0.8981,0.987043},
{0.9879,0.013504},
{0.9879,0.111885},
{0.8981,0.062251},
{0.8981,0.0134},
{0.9879,0.193373},
{0.8981,0.140641},
{0.9879,0.31298},
{0.8981,0.210876},
{0.8981,0.311557},
{0.8981,0.488416},
{0.9879,0.645409},
{0.8981,0.656682},
{0.9879,0.792419},
{0.8981,0.795844},
{0.9879,0.986997},
{0.8981,0.987017},
{0.6484,0.44097},
{0.6484,0.4104},
{0.5805,0.4104},
{0.5805,0.441058},
{0.6484,0.5218},
{0.5805,0.538396},
{0.6484,0.5696},
{0.6484,0.6173},
{0.5805,0.6173},
{0.6484,0.6651},
{0.5805,0.6651},
{0.6484,0.716308},
{0.5805,0.722538},
{0.6484,0.83288},
{0.5805,0.83769},
{0.6484,0.917264},
{0.5805,0.917924},
{0.6484,0.9826},
{0.5805,0.9826},
{0.9879,0.111945},
{0.9879,0.013502},
{0.8981,0.062436},
{0.8981,0.140714},
{0.9879,0.18742},
{0.8981,0.206657},
{0.9879,0.299787},
{0.8981,0.29987},
{0.9879,0.455454},
{0.8981,0.554571},
{0.9879,0.654029},
{0.8981,0.675343},
{0.9879,0.793248},
{0.8981,0.798172},
{0.9879,0.986975},
{0.8981,0.987043},
{0.8981,0.0134},
{0.5727,0.4073},
{0.5727,0.478556},
{0.6625,0.40725},
{0.6625,0.600196},
{0.5727,0.608381},
{0.6625,0.753464},
{0.5727,0.767014},
{0.6625,0.8959},
{0.5727,0.8959},
{0.6625,0.9847},
{0.5727,0.9847},
{0.6729,0.194809},
{0.6729,0.0835},
{0.7725,0.083421},
{0.7725,0.369563},
{0.6729,0.387269},
{0.7725,0.600092},
{0.6729,0.5688},
{0.6729,0.798297},
{0.7725,0.8461},
{0.7725,0.9847},
{0.6729,0.9847},
{0.5805,0.4104},
{0.6484,0.4104},
{0.6484,0.440968},
{0.5805,0.441063},
{0.6484,0.5218},
{0.5805,0.5218},
{0.6484,0.5696},
{0.5805,0.5696},
{0.6484,0.6173},
{0.5805,0.6173},
{0.6484,0.672711},
{0.5805,0.674443},
{0.6484,0.795569},
{0.5805,0.803961},
{0.6484,0.885443},
{0.5805,0.895677},
{0.6484,0.982732},
{0.5805,0.982582},
{0.5856,0.0283},
{0.5856,0.0819},
{0.6623,0.0819},
{0.6623,0.1135},
{0.5856,0.1135},
{0.6623,0.1451},
{0.5856,0.1451},
{0.6623,0.2083},
{0.5856,0.2083},
{0.6623,0.2715},
{0.5856,0.2715},
{0.6623,0.3347},
{0.5856,0.3347},
{0.6623,0.3979},
{0.5856,0.3979},
{0.6628,0.028},
{0.5784,0.4199},
{0.6625,0.4199},
{0.6625,0.4793},
{0.5784,0.4793},
{0.6625,0.5405},
{0.5784,0.5405},
{0.6625,0.585},
{0.5784,0.585},
{0.6625,0.6294},
{0.5784,0.6294},
{0.6625,0.7182},
{0.5784,0.7182},
{0.6625,0.807},
{0.5784,0.807},
{0.6625,0.8959},
{0.5784,0.8959},
{0.6625,0.9847},
{0.5784,0.9847},
{0.671798,0.083669},
{0.770899,0.083883},
{0.772,0.529282},
{0.673,0.549222},
{0.772,0.744773},
{0.673,0.7022},
{0.673,0.867182},
{0.772,0.8974},
{0.772,0.9917},
{0.673,0.9917},
{0.6718,0.084},
{0.673,0.257955},
{0.7735,0.253317},
{0.7735,0.506331},
{0.673,0.508711},
{0.7735,0.6536},
{0.673,0.6536},
{0.7735,0.793},
{0.673,0.793},
{0.7735,0.8816},
{0.673,0.8816},
{0.7735,0.9917},
{0.673,0.9917},
{0.7724,0.084},
{0.5793,0.4202},
{0.664,0.4202},
{0.664,0.467},
{0.5793,0.467},
{0.664,0.5138},
{0.5793,0.5138},
{0.664,0.5607},
{0.5793,0.5607},
{0.664,0.6075},
{0.5793,0.6075},
{0.664,0.7011},
{0.5793,0.7011},
{0.664,0.7947},
{0.5793,0.7947},
{0.664,0.8883},
{0.5793,0.8883},
{0.664,0.982},
{0.5793,0.982},
{0.5853,0.0277},
{0.5853,0.0586},
{0.6628,0.0586},
{0.6628,0.0894},
{0.5853,0.0894},
{0.6628,0.1202},
{0.5853,0.1202},
{0.6628,0.1511},
{0.5853,0.1511},
{0.6628,0.2128},
{0.5853,0.2128},
{0.6628,0.2745},
{0.5853,0.2745},
{0.6628,0.3362},
{0.5853,0.3362},
{0.6628,0.3979},
{0.5853,0.3979},
{0.6628,0.0277},
{0.5856,0.029},
{0.5856,0.0371},
{0.6623,0.0371},
{0.6623,0.075},
{0.5856,0.075},
{0.6623,0.1141},
{0.5856,0.1141},
{0.6623,0.1425},
{0.5856,0.1425},
{0.6623,0.1709},
{0.5856,0.1709},
{0.6623,0.2276},
{0.5856,0.2276},
{0.6623,0.2844},
{0.5856,0.2844},
{0.6623,0.3411},
{0.5856,0.3411},
{0.6623,0.3979},
{0.5856,0.3979},
{0.6623,0.029},
{0.5784,0.4199},
{0.6625,0.4199},
{0.6625,0.4793},
{0.5784,0.4793},
{0.6625,0.5405},
{0.5784,0.5405},
{0.6625,0.585},
{0.5784,0.585},
{0.6625,0.6294},
{0.5784,0.6294},
{0.6625,0.7182},
{0.5784,0.7182},
{0.6625,0.807},
{0.5784,0.807},
{0.6625,0.8959},
{0.5784,0.8959},
{0.6625,0.9847},
{0.5784,0.9847},
{0.5853,0.0277},
{0.5853,0.0586},
{0.6628,0.0586},
{0.6628,0.0894},
{0.5853,0.0894},
{0.6628,0.1202},
{0.5853,0.1202},
{0.6628,0.1511},
{0.5853,0.1511},
{0.6628,0.2128},
{0.5853,0.2128},
{0.6628,0.2745},
{0.5853,0.2745},
{0.6628,0.3362},
{0.5853,0.3362},
{0.6628,0.3979},
{0.5853,0.3979},
{0.6628,0.0277},
{0.5784,0.4199},
{0.6625,0.4199},
{0.6625,0.4793},
{0.5784,0.4793},
{0.6625,0.5405},
{0.5784,0.5405},
{0.6625,0.585},
{0.5784,0.585},
{0.6625,0.6294},
{0.5784,0.6294},
{0.6625,0.7182},
{0.5784,0.7182},
{0.6625,0.807},
{0.5784,0.807},
{0.6625,0.8959},
{0.5784,0.8959},
{0.6625,0.9847},
{0.5784,0.9847},
{0.8944,0.041749},
{0.8944,0.347654},
{0.9964,0.339982},
{0.9964,0.582908},
{0.8944,0.607984},
{0.9964,0.8287},
{0.8944,0.8287},
{0.9964,0.9816},
{0.8944,0.9816},
{0.9964,0.041913},
{0.5784,0.4199},
{0.5784,0.4793},
{0.6625,0.4793},
{0.6625,0.5405},
{0.5784,0.5405},
{0.6625,0.585},
{0.5784,0.585},
{0.6625,0.6294},
{0.5784,0.6294},
{0.6625,0.7182},
{0.5784,0.7182},
{0.6625,0.807},
{0.5784,0.807},
{0.6625,0.8959},
{0.5784,0.8959},
{0.6625,0.9847},
{0.5784,0.9847},
{0.6625,0.4199},
{0.5853,0.0279},
{0.5853,0.061},
{0.6623,0.061},
{0.6623,0.094},
{0.5853,0.094},
{0.6623,0.127},
{0.5853,0.127},
{0.6623,0.16},
{0.5853,0.16},
{0.6623,0.2425},
{0.5853,0.2425},
{0.6623,0.3085},
{0.5853,0.3085},
{0.6623,0.3384},
{0.5853,0.3384},
{0.6623,0.3979},
{0.5853,0.3979},
{0.6623,0.0279},
{0.5784,0.4199},
{0.6625,0.4199},
{0.6625,0.4793},
{0.5784,0.4793},
{0.6625,0.5405},
{0.5784,0.5405},
{0.6625,0.585},
{0.5784,0.585},
{0.6625,0.6294},
{0.5784,0.6294},
{0.6625,0.7182},
{0.5784,0.7182},
{0.6625,0.807},
{0.5784,0.807},
{0.6625,0.8959},
{0.5784,0.8959},
{0.6625,0.9847},
{0.5784,0.9847},
{0.578,0.422464},
{0.6628,0.422553},
{0.6628,0.599778},
{0.578,0.60397},
{0.6628,0.739655},
{0.578,0.7058},
{0.578,0.857966},
{0.6628,0.8946},
{0.6628,0.989},
{0.578,0.989},
{0.5784,0.4199},
{0.6625,0.4199},
{0.6625,0.4793},
{0.5784,0.4793},
{0.6625,0.5405},
{0.5784,0.5405},
{0.6625,0.585},
{0.5784,0.585},
{0.6625,0.6294},
{0.5784,0.6294},
{0.6625,0.7182},
{0.5784,0.7182},
{0.6625,0.807},
{0.5784,0.807},
{0.6625,0.8959},
{0.5784,0.8959},
{0.6625,0.9847},
{0.5784,0.9847},
{0.6718,0.084},
{0.673,0.327987},
{0.772399,0.08394},
{0.7735,0.486106},
{0.673,0.573097},
{0.7735,0.763029},
{0.673,0.781153},
{0.7735,0.9026},
{0.673,0.9026},
{0.7735,0.9917},
{0.673,0.9917},
{0.5862,0.02821},
{0.6627,0.028196},
{0.6627,0.161057},
{0.5862,0.162718},
{0.6627,0.2095},
{0.5862,0.2095},
{0.6627,0.2602},
{0.5862,0.2602},
{0.6627,0.3165},
{0.5862,0.3165},
{0.6627,0.3523},
{0.5862,0.3523},
{0.6627,0.3968},
{0.5862,0.3968},
{0.5784,0.4199},
{0.5784,0.4793},
{0.6625,0.4793},
{0.6625,0.5405},
{0.5784,0.5405},
{0.6625,0.585},
{0.5784,0.585},
{0.6625,0.6294},
{0.5784,0.6294},
{0.6625,0.7182},
{0.5784,0.7182},
{0.6625,0.807},
{0.5784,0.807},
{0.6625,0.8959},
{0.5784,0.8959},
{0.6625,0.9847},
{0.5784,0.9847},
{0.6625,0.4199},
{0.5853,0.027611},
{0.6628,0.027669},
{0.6628,0.14349},
{0.5853,0.146239},
{0.6628,0.234983},
{0.5853,0.2128},
{0.5853,0.312257},
{0.6628,0.3362},
{0.6628,0.3979},
{0.5853,0.3979},
{0.783801,0.015765},
{0.8847,0.008447},
{0.8847,0.278052},
{0.7849,0.3959},
{0.8847,0.54621},
{0.7849,0.622},
{0.8847,0.804878},
{0.7849,0.821696},
{0.8847,0.9857},
{0.7849,0.9857},
{0.5853,0.0279},
{0.5853,0.125671},
{0.6623,0.027867},
{0.6623,0.174154},
{0.5853,0.2425},
{0.6623,0.321407},
{0.5853,0.326364},
{0.6623,0.3979},
{0.5853,0.3979},
{0.7842,0.0121},
{0.8847,0.0121},
{0.8847,0.1153},
{0.7842,0.1153},
{0.8847,0.2219},
{0.7842,0.2219},
{0.8847,0.2991},
{0.7842,0.2991},
{0.8847,0.3763},
{0.7842,0.3763},
{0.8847,0.5307},
{0.7842,0.5307},
{0.8847,0.6852},
{0.7842,0.6852},
{0.8847,0.8396},
{0.7842,0.8396},
{0.8847,0.994},
{0.7842,0.994},
{0.5856,0.0371},
{0.5856,0.075},
{0.6623,0.075},
{0.6623,0.1141},
{0.5856,0.1141},
{0.6623,0.1425},
{0.5856,0.1425},
{0.6623,0.1709},
{0.5856,0.1709},
{0.6623,0.2276},
{0.5856,0.2276},
{0.6623,0.2844},
{0.5856,0.2844},
{0.6623,0.3411},
{0.5856,0.3411},
{0.6623,0.3979},
{0.5856,0.3979},
{0.6623,0.0371},
{0.671801,0.084089},
{0.770901,0.084061},
{0.772,0.370023},
{0.673,0.371113},
{0.772,0.516358},
{0.673,0.518094},
{0.772,0.7013},
{0.673,0.776235},
{0.772,0.847174},
{0.673,0.991661},
{0.772,0.9917},
{0.5798,0.4332},
{0.5798,0.4913},
{0.6623,0.4913},
{0.6623,0.5512},
{0.5798,0.5512},
{0.6623,0.5947},
{0.5798,0.5947},
{0.6623,0.6381},
{0.5798,0.6381},
{0.6623,0.725},
{0.5798,0.725},
{0.6623,0.8119},
{0.5798,0.8119},
{0.6623,0.8988},
{0.5798,0.8988},
{0.6623,0.9857},
{0.5798,0.9857},
{0.6623,0.4332},
{0.6718,0.084},
{0.673,0.269831},
{0.772,0.261179},
{0.772,0.515202},
{0.673,0.536227},
{0.772,0.6997},
{0.673,0.6997},
{0.772,0.84799},
{0.673,0.859787},
{0.772,0.9868},
{0.673,0.9868},
{0.7709,0.084},
{0.5837,0.0281},
{0.5826,0.107125},
{0.661899,0.028138},
{0.6628,0.182983},
{0.5826,0.186627},
{0.6628,0.258839},
{0.5826,0.265627},
{0.6628,0.3307},
{0.5826,0.350546},
{0.6628,0.3617},
{0.6628,0.4001},
{0.5826,0.4001},
{0.8962,0.0604},
{0.8972,0.253579},
{0.9926,0.062051},
{0.9926,0.49312},
{0.8972,0.517423},
{0.9926,0.686},
{0.8972,0.686},
{0.9926,0.839912},
{0.8972,0.853441},
{0.9926,0.9789},
{0.8972,0.9789},
{0.5853,0.0574},
{0.5853,0.098358},
{0.6623,0.057369},
{0.6623,0.158468},
{0.5853,0.162452},
{0.6623,0.2276},
{0.5853,0.2276},
{0.6623,0.306587},
{0.5853,0.315405},
{0.6623,0.3979},
{0.5853,0.3979},
{0.671801,0.084068},
{0.673,0.503463},
{0.772,0.480269},
{0.772,0.7022},
{0.673,0.7022},
{0.772,0.854147},
{0.673,0.867323},
{0.772,0.9917},
{0.673,0.9917},
{0.7709,0.084039},
{0.6718,0.084008},
{0.7724,0.083995},
{0.7735,0.413255},
{0.673,0.439317},
{0.7735,0.6514},
{0.673,0.6514},
{0.7735,0.827942},
{0.673,0.841509},
{0.7735,0.9917},
{0.673,0.9917},
{0.673,0.411332},
{0.6718,0.084},
{0.772399,0.083889},
{0.7735,0.529181},
{0.673,0.6512},
{0.7735,0.83046},
{0.673,0.845862},
{0.7735,0.9917},
{0.673,0.9917},
{0.7747,0.084},
{0.6701,0.084},
{0.6732,0.1987},
{0.7759,0.1987},
{0.6732,0.397639},
{0.7759,0.371734},
{0.6732,0.5257},
{0.7759,0.5257},
{0.6732,0.6517},
{0.7759,0.6517},
{0.6732,0.792},
{0.7759,0.792},
{0.6732,0.881},
{0.7759,0.881},
{0.6732,0.9917},
{0.7759,0.9917},
{0.414411,0.842618},
{0.151781,0.630286},
{0.497207,0.675134},
{0.748486,0.77481},
{0.616162,0.526406},
{0.302114,0.504712},
{0.158292,0.297741},
{0.06891,0.260498},
{0.066198,0.675214},
{0.397123,0.935826},
{0.812406,0.846101},
{0.9023,0.47791},
{0.730866,0.308051},
{0.395963,0.223747},
{0.2911,0.0289},
{0.066655,0.265061},
{0.067807,0.67847},
{0.403228,0.937186},
{0.817302,0.842294},
{1.0066,0.502535},
{1.0066,0.49638},
{0.9023,0.165},
{0.9023,0.463258},
{0.748455,0.166366},
{0.615245,0.003971},
{0.621344,0.005327},
{0.604008,0.098574},
{0.414399,0.098585},
{0.194,0.2255},
{0.142851,0.574787},
{0.429096,0.845884},
{0.760234,0.765674},
{0.715078,0.506849},
{0.541586,0.281984},
{0.476812,0.659191},
{0.303993,0.436874},
{0.5092,0.4711},
{0.867425,0.630274},
{0.6849,0.8248},
{0.522006,0.675104},
{0.70628,0.457143},
{0.51,0.4711},
{0.313625,0.484099},
{0.429797,0.845872},
{0.62207,0.935827},
{0.953006,0.675206},
{0.912623,0.321385},
{0.590158,0.095328},
{0.498008,0.266086},
{0.258974,0.175519},
{0.1169,0.477944},
{0.1947,0.7157},
{0.206776,0.846086},
{0.397873,0.005323},
{0.063297,0.280839},
{0.0126,0.6085},
{0.813169,0.095059},
{0.95254,0.265051},
{0.7281,0.0289},
{0.403983,0.003965},
{0.1169,0.165},
{0.0126,0.496432},
{0.201894,0.84229},
{0.615971,0.937186},
{0.951402,0.678452},
{0.876363,0.574722},
{0.590125,0.845879},
{0.764717,0.178467},
{0.429816,0.095324},
{0.159059,0.297699},
{0.152516,0.630247},
{0.335,0.8248},
{0.715213,0.436882},
{0.542397,0.659209},
{0.521274,0.26809},
{0.314209,0.459485},
{0.51,0.4711},
{0.2159,0.756},
{0.2308,0.756},
{0.2308,0.7757},
{0.2457,0.7757},
{0.2457,0.756},
{0.2159,0.7757},
{0.2308,0.804176},
{0.2457,0.7953},
{0.2159,0.7953},
{0.2159,0.8149},
{0.2308,0.8346},
{0.2457,0.8346},
{0.2457,0.8149},
{0.2159,0.8346},
{0.2308,0.862943},
{0.2457,0.8542},
{0.2159,0.8542},
{0.2159,0.8738},
{0.2308,0.8935},
{0.2457,0.8935},
{0.2457,0.8738},
{0.2159,0.8935},
{0.2308,0.922176},
{0.2457,0.9131},
{0.2159,0.9131},
{0.2159,0.9327},
{0.2308,0.9523},
{0.2457,0.9523},
{0.2457,0.9327},
{0.2159,0.9523},
{0.2308,0.980907},
{0.2457,0.972},
{0.2159,0.972},
{0.2159,0.9916},
{0.2457,0.9916},
{0.1878,0.4588},
{0.1697,0.4539},
{0.1878,0.4372},
{0.1951,0.4352},
{0.2059,0.4539},
{0.2005,0.4299},
{0.2192,0.4407},
{0.2024,0.4226},
{0.224,0.4226},
{0.2005,0.4153},
{0.2192,0.4045},
{0.1951,0.41},
{0.2059,0.3913},
{0.1878,0.408},
{0.1878,0.3864},
{0.1805,0.41},
{0.1697,0.3913},
{0.1752,0.4153},
{0.1565,0.4045},
{0.1732,0.4226},
{0.1516,0.4226},
{0.1752,0.4299},
{0.1565,0.4407},
{0.1805,0.4352},
{0.1878,0.4877},
{0.1553,0.4789},
{0.2204,0.4789},
{0.2442,0.4551},
{0.2529,0.4226},
{0.2442,0.3901},
{0.2204,0.3662},
{0.1878,0.3575},
{0.1553,0.3662},
{0.1315,0.3901},
{0.1228,0.4226},
{0.1315,0.4551},
{0.3336,0.5046},
{0.3124,0.4989},
{0.3336,0.5373},
{0.3711,0.5272},
{0.3548,0.4989},
{0.3986,0.4997},
{0.3703,0.4834},
{0.4087,0.4622},
{0.376,0.4622},
{0.3986,0.4247},
{0.3703,0.441},
{0.3711,0.3972},
{0.3548,0.4255},
{0.3336,0.3872},
{0.3336,0.4199},
{0.2961,0.3972},
{0.3124,0.4255},
{0.2686,0.4247},
{0.2969,0.441},
{0.2586,0.4622},
{0.2913,0.4622},
{0.2686,0.4997},
{0.2969,0.4834},
{0.2961,0.5272},
{0.329487,0.4813},
{0.3161,0.4723},
{0.3336,0.4622},
{0.348086,0.475313},
{0.314499,0.458088},
{0.3235,0.4447},
{0.337712,0.443099},
{0.352199,0.456212},
{0.0215,0.7778},
{0.0215,0.7741},
{0.0291,0.7741},
{0.0291,0.7705},
{0.0215,0.7705},
{0.0291,0.7668},
{0.0215,0.7668},
{0.0291,0.7631},
{0.0215,0.7631},
{0.0367,0.7741},
{0.0291,0.7778},
{0.0215,0.7815},
{0.0291,0.7815},
{0.0367,0.7778},
{0.0442,0.7741},
{0.047308,0.7705},
{0.0367,0.7705},
{0.0367,0.7668},
{0.0367,0.7631},
{0.0442,0.7668},
{0.0442,0.7631},
{0.056292,0.7741},
{0.0442,0.7778},
{0.0367,0.7815},
{0.0442,0.7815},
{0.0518,0.7778},
{0.0594,0.7778},
{0.067,0.7741},
{0.067,0.7705},
{0.0594,0.7705},
{0.0518,0.7668},
{0.0518,0.7631},
{0.0594,0.7631},
{0.0594,0.7668},
{0.067,0.7631},
{0.067,0.7668},
{0.0746,0.7631},
{0.0746,0.7668},
{0.0822,0.7631},
{0.0822,0.7668},
{0.0746,0.7705},
{0.0822,0.7705},
{0.0746,0.7741},
{0.0822,0.7741},
{0.0746,0.7778},
{0.0822,0.7778},
{0.0746,0.7815},
{0.0822,0.7815},
{0.067,0.7778},
{0.067,0.7815},
{0.0594,0.7815},
{0.0518,0.7815},
{0.347005,0.96593},
{0.411905,0.993146},
{0.5045,0.9576},
{0.470921,0.981707},
{0.183553,0.804884},
{0.209852,0.743987},
{0.209688,0.744408},
{0.21782,0.6839},
{0.2179,0.6839},
{0.163875,0.863804},
{0.16603,0.852409},
{0.187751,0.798708},
{0.8368,0.2896},
{0.836602,0.2896},
{0.7564,0.2484},
{0.877,0.2896},
{0.8898,0.2484},
{0.895293,0.1852},
{0.8898,0.2484},
{0.8954,0.1852},
{0.550201,0.958176},
{0.5045,0.9576},
{0.318649,0.905265},
{0.34695,0.965884},
{0.407837,0.992379},
{0.467873,0.983266},
{0.295161,0.789463},
{0.570006,0.827244},
{0.23812,0.698469},
{0.611247,0.741296},
{0.615602,0.6746},
{0.214853,0.588035},
{0.3294,0.563},
{0.4179,0.5537},
{0.508,0.5624},
{0.5753,0.5803},
{0.6231,0.5869},
{0.105977,0.866624},
{0.105978,0.8929},
{0.106,0.852},
{0.10591,0.8186},
{0.10593,0.796412},
{0.106,0.7962},
{0.105981,0.9346},
{0.105918,0.9679},
{0.106,0.9346},
{0.106,0.989354},
{0.105928,0.9903},
{0.2622,0.5812},
{0.2144,0.5881},
{0.238145,0.697889},
{0.615597,0.6746},
{0.611247,0.741297},
{0.563812,0.835536},
{0.294963,0.806128},
{0.552606,0.912899},
{0.321052,0.929317},
{0.5502,0.9582},
{0.508,0.5624},
{0.361042,0.559675},
{0.621082,0.586621},
{0.877,0.2896},
{0.030881,0.454444},
{0.065376,0.463482},
{0.028523,0.453363},
{0.099,0.487796},
{0.1149,0.5254},
{0.1149,0.5168},
{0.1682,0.521258},
{0.122581,0.621023},
{0.114914,0.5254},
{0.1149,0.5168},
{0.1682,0.52126},
{0.099,0.487783},
{0.837834,0.9758},
{0.86819,0.937746},
{0.8745,0.9758},
{0.81455,0.982215},
{0.788808,0.939379},
{0.752047,0.937936},
{0.794782,0.9758},
{0.837837,0.9758},
{0.868189,0.937751},
{0.908204,0.934803},
{0.8677,0.8857},
{0.9062,0.8857},
{0.943011,0.83077},
{0.886641,0.830435},
{0.9023,0.8116},
{0.9741,0.8116},
{0.8677,0.8857},
{0.8283,0.8857},
{0.828361,0.937717},
{0.789,0.8857},
{0.7528,0.8857},
{0.720599,0.832021},
{0.769449,0.829344},
{0.6916,0.8116},
{0.7542,0.8116},
{0.828129,0.83057},
{0.8279,0.8116},
{0.886647,0.830422},
{0.9023,0.8116},
{0.828129,0.830571},
{0.8283,0.8857},
{0.8279,0.8116},
{0.828361,0.937717},
{0.789,0.8857},
{0.76945,0.829347},
{0.7542,0.8116},
{0.788808,0.939377},
{0.0661,0.462595},
{0.1027,0.7003},
{0.100001,0.747875},
{0.118443,0.629858},
{0.1,0.7479},
{0.633309,0.9558},
{0.6333,0.9236},
{0.6513,0.91669},
{0.6282,0.8574},
{0.6517,0.7759},
{0.6282,0.7759},
{0.6226,0.6732},
{0.6517,0.666562},
{0.6357,0.6124},
{0.6517,0.5364},
{0.6678,0.6124},
{0.6809,0.6732},
{0.6752,0.7759},
{0.6744,0.8574},
{0.6693,0.953598},
{0.6513,0.99},
{0.669429,0.9558},
{0.6333,0.9558},
{0.6513,0.920187},
{0.6693,0.9236},
{0.6744,0.8574},
{0.6752,0.7759},
{0.6517,0.7759},
{0.6282,0.8574},
{0.6333,0.9236},
{0.6282,0.7759},
{0.6226,0.6732},
{0.6517,0.667381},
{0.6357,0.6124},
{0.6517,0.5364},
{0.6678,0.6124},
{0.6809,0.6732},
{0.163748,0.886145},
{0.163747,0.886107},
{0.1638,0.917509},
{0.1638,0.919242},
{0.1636,0.945343},
{0.1636,0.947291},
{0.1636,0.9724},
{0.1636,0.9724},
{0.0088,0.4077},
{0.0257,0.4077},
{0.0256,0.3947},
{0.0425,0.3947},
{0.053619,0.4077},
{0.0595,0.3947},
{0.0821,0.3947},
{0.0822,0.4077},
{0.099,0.3947},
{0.110041,0.4077},
{0.1159,0.3947},
{0.0087,0.3947},
{0.669348,0.9558},
{0.6333,0.9558},
{0.633436,0.9236},
{0.6693,0.9236},
{0.6744,0.8574},
{0.6513,0.8574},
{0.6282,0.8574},
{0.6517,0.7759},
{0.6282,0.7759},
{0.6226,0.6732},
{0.6517,0.664767},
{0.6357,0.6124},
{0.6517,0.5364},
{0.6678,0.6124},
{0.6809,0.6732},
{0.6752,0.7759},
{0.0089,0.4207},
{0.0088,0.4077},
{0.0257,0.4077},
{0.0258,0.4207},
{0.0426,0.4077},
{0.053719,0.4207},
{0.0596,0.4077},
{0.082248,0.413963},
{0.0315,0.4424},
{0.053578,0.4337},
{0.0258,0.424577},
{0.0427,0.4207},
{0.0597,0.4207},
{0.0823,0.4207},
{0.092461,0.4337},
{0.0653,0.4424},
{0.0089,0.4207},
{0.0089,0.43703},
{0.0992,0.4207},
{0.1162,0.4207},
{0.109694,0.43703},
{0.110206,0.4207},
{0.0991,0.4077},
{0.116,0.4077},
{0.468024,0.179382},
{0.46694,0.285194},
{0.417073,0.17935},
{0.435638,0.012696},
{0.375468,0.012714},
{0.366077,0.180845},
{0.413487,0.285738},
{0.3062,0.3618},
{0.513619,0.284047},
{0.517905,0.184449},
{0.495807,0.01271},
{0.564736,0.285142},
{0.570337,0.178005},
{0.556073,0.012714},
{0.115685,0.284765},
{0.06808,0.285312},
{0.059963,0.178405},
{0.112333,0.185845},
{0.014156,0.012707},
{0.074329,0.012724},
{0.162077,0.17797},
{0.134588,0.012687},
{0.213232,0.179118},
{0.194764,0.012708},
{0.264411,0.182951},
{0.255029,0.012706},
{0.3152,0.175208},
{0.3152,0.012691},
{0.166784,0.284747},
{0.215254,0.284243},
{0.265637,0.284018},
{0.314381,0.284762},
{0.364108,0.286823},
{0.616244,0.012707},
{0.610388,0.18562},
{0.620862,0.2145},
{0.618979,0.198134},
{0.605974,0.273699},
{0.608333,0.294167},
{0.603197,0.298915},
{0.1636,0.9947},
{0.1636,0.9947},
{0.118161,0.3712},
{0.1053,0.3712},
{0.117574,0.382},
{0.132,0.382},
{0.0964,0.3712},
{0.099244,0.382},
{0.0875,0.367395},
{0.0964,0.352842},
{0.1053,0.348605},
{0.1142,0.352137},
{0.1231,0.354249},
{0.132,0.367395},
{0.1231,0.3333},
{0.1142,0.323923},
{0.132,0.3495},
{0.0964,0.322621},
{0.0875,0.3333},
{0.1053,0.321518},
{0.1142,0.352138},
{0.1231,0.354251},
{0.1231,0.322774},
{0.132,0.3333},
{0.117574,0.382},
{0.099243,0.382},
{0.1053,0.3712},
{0.0964,0.3712},
{0.0875,0.367394},
{0.0875,0.382},
{0.1053,0.353686},
{0.118162,0.3712},
{0.132,0.382},
{0.132,0.367394},
{0.0964,0.3333},
{0.0964,0.352845},
{0.0875,0.3495},
{0.0875,0.3333},
{0.0875,0.317},
{0.132,0.317},
{0.132,0.3333},
{0.132,0.3495},
{0.0875,0.3495},
{0.0875,0.382},
{0.0383,0.367915},
{0.0302,0.3678},
{0.0302,0.349539},
{0.0221,0.3549},
{0.0221,0.3678},
{0.014,0.3549},
{0.014,0.3678},
{0.0464,0.368064},
{0.0383,0.334264},
{0.0302,0.323537},
{0.0221,0.334404},
{0.014,0.3419},
{0.014,0.3289},
{0.014,0.3159},
{0.0221,0.308405},
{0.014,0.3029},
{0.014,0.2899},
{0.0221,0.282405},
{0.014,0.2769},
{0.014,0.2639},
{0.0221,0.2639},
{0.0302,0.284539},
{0.0302,0.2639},
{0.0383,0.263854},
{0.0383,0.295262},
{0.0464,0.284396},
{0.0464,0.2639},
{0.0545,0.2769},
{0.0545,0.2639},
{0.0383,0.3159},
{0.0464,0.336393},
{0.0545,0.3549},
{0.0545,0.3419},
{0.0545,0.3289},
{0.0464,0.310394},
{0.0302,0.3029},
{0.0545,0.2899},
{0.0545,0.3029},
{0.0545,0.3159},
{0.0545,0.3678},
{0.669384,0.9558},
{0.6333,0.9558},
{0.633391,0.9236},
{0.6693,0.9236},
{0.6744,0.8574},
{0.674976,0.776665},
{0.6282,0.8574},
{0.6517,0.7759},
{0.6282,0.7759},
{0.6226,0.6732},
{0.6517,0.657462},
{0.6357,0.6124},
{0.6517,0.5364},
{0.6678,0.6124},
{0.6809,0.6732},
{0.664595,0.383034},
{0.6638,0.3889},
{0.6058,0.3889},
{0.604991,0.38293},
{0.603907,0.398484},
{0.6061,0.46538},
{0.6635,0.465675},
{0.668594,0.490356},
{0.601079,0.490485},
{0.602972,0.481119},
{0.66638,0.479601},
{0.6011,0.4127},
{0.6684,0.4127},
{0.6058,0.3889},
{0.6638,0.3889},
{0.665106,0.395659},
{0.935205,0.336502},
{0.924094,0.316366},
{0.940293,0.327668},
{0.955333,0.326718},
{0.9393,0.260369},
{0.9218,0.2778},
{0.9043,0.2778},
{0.9043,0.3121},
{0.913816,0.328302},
{0.953674,0.019943},
{0.9569,0.0373},
{0.940975,0.022039},
{0.9477,0.0037},
{0.927332,0.022059},
{0.9393,0.0718},
{0.9569,0.0718},
{0.9744,0.0718},
{0.9744,0.0373},
{0.96811,0.019927},
{0.983881,0.019973},
{0.9919,0.0373},
{0.9919,0.0718},
{0.9919,0.1061},
{0.9744,0.1061},
{0.9919,0.1404},
{0.9744,0.1404},
{0.9919,0.1748},
{0.9744,0.179454},
{0.9919,0.242922},
{0.9744,0.2434},
{0.9919,0.2778},
{0.9744,0.2778},
{0.9919,0.3121},
{0.974,0.3121},
{0.982279,0.328302},
{0.969963,0.328694},
{0.9569,0.2778},
{0.9569,0.2434},
{0.9393,0.179787},
{0.9218,0.237194},
{0.9043,0.242922},
{0.9569,0.177927},
{0.9218,0.1748},
{0.9043,0.1748},
{0.9569,0.1404},
{0.9393,0.1404},
{0.9218,0.1404},
{0.9043,0.1404},
{0.9569,0.1061},
{0.9393,0.1061},
{0.9218,0.1061},
{0.9043,0.1061},
{0.9043,0.0718},
{0.9218,0.0718},
{0.9043,0.0373},
{0.913481,0.019973},
{0.2588,0.9331},
{0.3011,0.8485},
{0.2588,0.8485},
{0.3011,0.8485},
{0.2588,0.8485},
{0.3011,0.8485},
{0.2588,0.8485},
{0.3011,0.8485},
{0.2588,0.8485},
{0.3011,0.8485},
{0.2588,0.8485},
{0.3011,0.8485},
{0.2588,0.8485},
{0.3011,0.8485},
{0.2588,0.8485},
{0.597063,0.2145},
{0.595,0.191015},
{0.596574,0.273815},
{0.59526,0.290836},
{0.600271,0.298465},
{0.600915,0.183207},
{0.1723,0.537},
{0.1834,0.5303},
{0.1988,0.5303},
{0.21,0.537},
{0.21452,0.548752},
{0.16775,0.548678},
{0.1741,0.583216},
{0.2081,0.584188},
{0.2081,0.6353},
{0.1741,0.647924},
{0.2081,0.662373},
{0.1741,0.6723},
{0.2081,0.660708},
{0.1741,0.647928},
{0.2081,0.6353},
{0.1741,0.6064},
{0.2081,0.583669},
{0.173357,0.570214},
{0.214544,0.548693},
{0.1678,0.5488},
{0.21,0.537},
{0.1723,0.537},
{0.1834,0.5303},
{0.1988,0.5303},
{0.467942,0.489767},
{0.4548,0.5078},
{0.5073,0.502498},
{0.5073,0.475053},
{0.530515,0.467516},
{0.546657,0.489766},
{0.5073,0.5248},
{0.443599,0.456294},
{0.4224,0.4632},
{0.484085,0.467516},
{0.500917,0.439596},
{0.510914,0.441577},
{0.544816,0.447768},
{0.571,0.456294},
{0.5598,0.5078},
{0.443599,0.414878},
{0.4224,0.408},
{0.469782,0.447769},
{0.501482,0.430757},
{0.469783,0.423387},
{0.484085,0.403628},
{0.512111,0.430517},
{0.5073,0.396091},
{0.530515,0.403628},
{0.544818,0.423387},
{0.570998,0.414879},
{0.5922,0.4632},
{0.467944,0.38143},
{0.4548,0.3634},
{0.5073,0.368611},
{0.5073,0.3463},
{0.546656,0.38143},
{0.5598,0.3634},
{0.5922,0.408},
{0.669222,0.9558},
{0.6333,0.9558},
{0.6513,0.918475},
{0.6693,0.9236},
{0.6744,0.8574},
{0.6752,0.7759},
{0.6517,0.7759},
{0.6282,0.8574},
{0.6333,0.9236},
{0.6282,0.7759},
{0.6226,0.6732},
{0.6517,0.669417},
{0.6357,0.6124},
{0.6517,0.5364},
{0.6678,0.6124},
{0.6809,0.6732},
{0.7967,0.0574},
{0.794182,0.0475},
{0.826595,0.0475},
{0.80559,0.0326},
{0.7856,0.0326},
{0.834432,0.0326},
{0.85653,0.0326},
{0.860423,0.051235},
{0.883947,0.0326},
{0.889238,0.0475},
{0.669384,0.955915},
{0.6333,0.9558},
{0.6513,0.921427},
{0.6744,0.8574},
{0.6752,0.7759},
{0.627613,0.859437},
{0.6333,0.9236},
{0.6282,0.7759},
{0.6517,0.638103},
{0.6809,0.6732},
{0.6678,0.6124},
{0.6517,0.5364},
{0.6357,0.6124},
{0.6226,0.6732},
{0.7558,0.4411},
{0.8279,0.4411},
{0.7818,0.3681},
{0.6943,0.4411},
{0.7401,0.3681},
{0.8288,0.3126},
{0.8282,0.3681},
{0.9006,0.4411},
{0.9119,0.5289},
{0.8278,0.5289},
{0.7445,0.5289},
{0.6744,0.5289},
{0.971,0.4411},
{0.8748,0.3681},
{0.9202,0.3681},
{0.9931,0.5289},
{0.961264,0.6684},
{0.895954,0.670996},
{0.827981,0.670924},
{0.7614,0.6603},
{0.702858,0.670488},
{0.749257,0.762738},
{0.6826,0.7637},
{0.8279,0.7637},
{0.9073,0.7636},
{0.984,0.7636},
{0.749258,0.762736},
{0.7614,0.6603},
{0.7445,0.5289},
{0.7558,0.4411},
{0.7818,0.3681},
{0.8282,0.3681},
{0.8748,0.3681},
{0.9006,0.4411},
{0.9119,0.5289},
{0.895954,0.670996},
{0.9073,0.7636},
{0.8279,0.7637},
{0.827981,0.67094},
{0.8278,0.5289},
{0.8279,0.4411},
{0.2588,0.9331},
{0.2588,0.8485},
{0.3011,0.8485},
{0.2588,0.8485},
{0.3011,0.8485},
{0.2588,0.8485},
{0.3011,0.8485},
{0.2588,0.8485},
{0.3011,0.8485},
{0.2588,0.8485},
{0.3011,0.8485},
{0.2588,0.8485},
{0.3011,0.8485},
{0.2588,0.8485},
{0.3011,0.8485},
{0.706701,0.220856},
{0.685743,0.229649},
{0.699594,0.068825},
{0.713807,0.068443},
{0.696751,0.016688},
{0.683278,0.020903},
{0.681436,0.070652},
{0.672338,0.230308},
{0.672158,0.331952},
{0.688643,0.332728},
{0.706642,0.331165},
{0.726013,0.229658},
{0.728685,0.068822},
{0.721329,0.0273},
{0.718981,0.0136},
{0.647739,0.014807},
{0.669878,0.01866},
{0.6597,0.0689},
{0.635325,0.069864},
{0.659548,0.229484},
{0.657952,0.332811},
{0.69,0.3498},
{0.727594,0.332728},
{0.746361,0.332773},
{0.744728,0.230322},
{0.74853,0.070649},
{0.741928,0.020903},
{0.642377,0.33195},
{0.643548,0.230322},
{0.6089,0.0689},
{0.620019,0.01866},
{0.7737,0.0689},
{0.758304,0.01866}
};


// normal array: 134kb.
const tgx::fVec3 manga3_norm_array[11488] PROGMEM = {
{0.18030565717874236,0.6304197797308885,-0.7550236892398807},
{-0.3099977292749495,0.6380953259688558,-0.704794837396724},
{-0.003199873271528572,0.9550621755115434,-0.29638826177533395},
{0.5706210648654214,0.6975257496383306,-0.433415999846957},
{0.4703023656268487,0.8744043982651849,0.11930060008352764},
{0.3115886879780207,0.917366695606663,0.24769100774119296},
{0.02280061003848248,0.9931265714568838,0.11480307159727143},
{-0.5101116969953197,-0.06270143776045196,-0.8578196700305533},
{-0.6797303608346151,-0.20670923287408408,-0.7037314328664391},
{-0.2108927812636439,-0.5846799867465747,-0.7833731855947779},
{-0.925172569039986,-0.3194905272462987,-0.20489392498518497},
{-0.5931967018355067,-0.7941955842848271,-0.13179926719811158},
{0.22580059950138753,-0.9339024795143747,0.277200735968931},
{0.407899490125956,-0.9114988606271363,0.05279993400012375},
{-0.42649788884067535,-0.7916960811140976,-0.437397834886076},
{-0.8940609035715116,-0.2878874109587721,0.343184992848387},
{-0.4499016623897138,0.07160026456346634,-0.8902032893072309},
{-0.6439205252938708,0.2502079755063309,-0.7230230467269274},
{-0.6489785970387987,0.33398898522489795,-0.6835774559872462},
{-0.9543196114695256,0.05040103575192716,-0.2945060521615585},
{-0.829571857252106,-0.28869020635087156,0.4779837846751527},
{-0.8641836238754899,-0.2614950447158535,0.42989185362655996},
{-0.5699934878616015,-0.5885932753602433,0.5732934501597478},
{0.5832097017740842,-0.6207103256021502,0.5240087169575105},
{-0.9183081500209972,0.3944035003465984,-0.0340003017540171},
{-0.5419143582111338,0.6146162844741886,-0.5732151875375934},
{-0.8198945641170597,0.13069913346761766,0.557396304474752},
{-0.5577101113759797,-0.3926071180315755,-0.731313258829575},
{0.26499057180317986,0.4829828157771165,-0.8345703065167318},
{0.35390002300350226,-0.07210000468650046,-0.9325000606125059},
{0.20739351490618174,-0.6336801851304116,-0.7452766955620889},
{0.40319905449932575,-0.6600984520709448,-0.6337985137442279},
{0.5867213981195912,-0.39641445749890225,-0.7061257528758196},
{0.18219928122525336,0.5015980211997096,-0.8456966637332424},
{0.6643974188210418,0.5228979685453383,-0.5339979254220896},
{0.8433369263157459,0.5273230893469617,-0.10350453204515557},
{0.7968213351768778,0.49851334787358637,0.3414091413521412},
{0.669072013303013,0.4753801152656589,0.5712761040203428},
{0.7705190898469293,0.0858021257739994,0.6316156484715387},
{0.7432748888820615,0.17319414873452585,0.6461781692393221},
{0.08059777714395915,0.28419216208825293,0.9553736511580466},
{-0.29140824405583815,0.6075171869043298,0.738920904368081},
{-0.46900698356597825,0.5499081881938838,0.6911102907088436},
{-0.5718910156627154,0.10649832692442593,0.8133872217871179},
{0.298608180483158,-0.08890243551558188,0.9502260317987166},
{-0.5493289531454834,-0.32231698816455356,0.7709406334969109},
{0.15029603599432526,-0.44648822402838484,0.8820767355328963},
{-0.5076895569332197,-0.3103936152690002,0.8036834684010807},
{-0.7105977331968466,-0.5458982585873327,0.4438985839657757},
{0.005699939865951619,-0.8529910009924089,0.5218944940421316},
{-0.43740089885977074,-0.8543017555919116,-0.2808005770457787},
{-0.6204398459263991,-0.46863009639121644,-0.6288403854263698},
{-0.2169944092110691,-0.8346784947856193,-0.5061869582610286},
{0.7019748908072257,-0.7022748800768015,0.1184957614824163},
{0.33789474070929093,-0.8815862782163685,0.3295948698957748},
{0.03269866101724645,-0.9980591303154032,0.05299782978330465},
{-0.43378514528204537,-0.7748734649125334,0.4597842549577788},
{-0.15400298383671804,-0.7702149230587028,0.6189119915360051},
{0.6884076207145422,-0.5403059812203184,0.48390535686195085},
{0.2872956245209576,-0.9385857054485582,-0.19109708961348762},
{0.6637176617619723,-0.7005186410490608,-0.26220697742050497},
{0.9287028882704738,-0.17450054269753168,-0.3272010175967471},
{0.5814045407871954,-0.6779052944610247,-0.4499035137601638},
{0.7643833901293967,-0.14909676016260212,-0.6272863692152938},
{0.9063659212820276,0.3867854571402122,-0.16999360836048624},
{0.9171884205692851,0.38209517607885285,-0.11299857340201615},
{-0.6692001539160531,0.667900153617053,0.3257000749110258},
{-0.6415187999839044,0.5745168364625924,0.5083148963863111},
{-0.5145091660624408,-0.829414776155857,0.217603876647594},
{-0.15760251141602927,-0.9874157345950971,-0.013100208753489743},
{-0.3820037341047514,-0.8691084955770666,0.3142030713500337},
{-0.6062272384017459,-0.7007314845729187,0.37611689931193765},
{-0.05889755167966396,-0.9566602324606878,0.285188144975215},
{0.47379765707637866,-0.8031960282054609,0.3610982143737449},
{0.21769828672122524,-0.8910929871257869,0.39819686620299444},
{0.8037249399718369,-0.5645175172503446,-0.18800583391154083},
{0.8151827468397428,-0.3959916189260772,-0.42269105383851724},
{0.5393158615127341,-0.8238242290268688,0.17450513227141126},
{0.8751753160283122,-0.11439677348450517,-0.47008674139043605},
{0.9100551672365019,-0.39538052205835933,-0.12439387188684851},
{0.9050722056593398,-0.09289714717241483,0.41498725593705227},
{0.8564332902089982,-0.22690882011726024,0.46371802506995846},
{0.6899177345633033,-0.36570940068096836,0.6247160585326795},
{-0.35088476140571107,-0.32728578628694566,0.877361897000202},
{-0.5219174688700295,-0.8023268543292291,-0.28960969339865983},
{-0.4830054338416962,-0.6963078335071906,-0.5309059727257899},
{0.03989822496745591,-0.3155859598929595,-0.9480578218457382},
{0.08980388455104121,-0.509222026875169,-0.8559370243567501},
{0.4117114230919028,-0.4059112621642053,-0.815922638087645},
{0.49758949848445055,-0.09779793599634096,-0.8618818101763422},
{-0.313695015425807,-0.7427881971893193,-0.5914906012890178},
{-0.4048910904695802,-0.9119799321023887,-0.06599854771793602},
{-0.6874740758413909,-0.7220727711491902,0.07739708141108895},
{-0.1534968034623515,-0.9745797045889758,-0.16319660146616136},
{0.08720106647556453,-0.9041110573458474,-0.4183051159028514},
{-0.19360849959970275,0.9690425419014047,-0.15320672592290527},
{-0.01620080568610065,0.9927493706538344,0.11910592328485109},
{-0.5208981638372087,-0.7799972505145378,0.3467987775364637},
{0.42219254414550506,0.6441886237293566,0.6377887367503627},
{0.6801604158156659,0.6905598105885017,0.24598568404977036},
{0.19939820841514605,0.9479914823347967,0.2480977708515433},
{-0.03200074482600384,0.9568222702975148,0.2889067243822659},
{0.05620195333283272,0.9897343988168068,-0.13140456704509285},
{0.5545821843334878,0.784674792727169,-0.27699110180377956},
{0.7180222805770548,0.6225193170741179,-0.31130966008863115},
{0.7724859795067068,0.5678896928956101,0.2841948419104286},
{0.33121360653444043,0.23180952293080703,0.9146375740833309},
{0.20430315957279438,0.593709181783495,0.7783120366887217},
{0.22530534655931156,-0.6979165617565181,0.6798161322282289},
{0.3470891241326903,-0.22649290295607705,0.9100714833568465},
{0.6317713024403652,-0.5379755630150624,0.5580746500347702},
{0.015300057069319303,-0.9329034797364691,-0.3598013420615089},
{-0.2228913764994616,-0.8760661056580454,-0.42758345711606005},
{-0.08119678385908574,-0.8476664245978693,0.524279233710821},
{-0.15200157702454248,-0.39980414798955316,0.9039093781084471},
{0.5397147748941968,-0.05540151663727721,0.8400229959442753},
{0.5845059327653265,0.08610087392830558,0.8068081891446799},
{-0.6710210838136854,-0.4004125811609532,0.624019607004083},
{-0.4541017551066752,-0.8525032949316024,0.25890100065430127},
{0.16050791162995118,-0.9706478444114056,0.1791088284917399},
{0.7963978776024843,0.5680984860195523,0.20739944728120951},
{0.44638044673278693,-0.3967826193180328,0.8020648663180296},
{-0.2959206308259421,-0.7926552618879409,0.5330371619811665},
{0.5072059216637034,-0.8600100406758378,0.055900652643929453},
{0.8213056382825603,-0.5513037847134732,0.1467010071058707},
{0.9889691940893987,0.03429893160492049,0.14409551149472433},
{0.7953045571081684,-0.570603269566102,-0.20470117294108145},
{0.9464245079799554,-0.1130029262486633,-0.30250783354177563},
{0.6891735603635254,-0.07719703839243203,-0.7204723596081254},
{0.6035141525728188,-0.6242146380048939,-0.496111633954226},
{-0.09570157621794056,-0.5784095264833524,-0.8101133426766317},
{0.42920562263048495,-0.8860116068280747,-0.17540229778515157},
{0.11990315709168989,-0.9923261282909414,-0.03020079519740646},
{-0.5027043383571602,-0.8612074322522106,-0.0749006463953676},
{-0.46160553006737554,-0.8528102167275949,0.24420292556857257},
{-0.036598786221382115,-0.9070699175250195,-0.41938609129091964},
{0.5143028646749344,-0.7046039246547906,0.48890272319575234},
{0.26411814289837493,-0.6830469201044683,-0.6809467758406038},
{0.2416855887180043,-0.7633544825292696,0.5990642788620454},
{0.37060297780689005,-0.2071016640685562,0.9054072749766817},
{-0.6798166489136004,-0.5953145794325777,0.42831048945233163},
{-0.32220876258644937,-0.9274252216718597,-0.1899051645411755},
{-0.6588208289497661,-0.56181776214933,-0.5003158177346204},
{-0.8630420441172937,-0.4826235115770636,0.14910726393729837},
{-0.7208317713604996,-0.20360897426331537,-0.6625292016181061},
{-0.9892601781330277,-0.008899641752131756,0.145894127150115},
{-0.8699054499747162,0.15110094665039617,-0.4695029414451422},
{-0.8947727590580195,0.43358679965082386,0.1066967516668425},
{-0.8624726384895589,0.499384157288911,-0.08219739232909187},
{-0.34560482122088426,0.40950571264453733,-0.8443117782314601},
{-0.33898858814126714,0.10269654277908004,-0.9351685180817493},
{-0.3016998159631684,0.019699987983010994,-0.9531994185485321},
{-0.09110569701735731,0.4722295294357423,-0.8767548251933827},
{-0.26438969296872555,0.878965734188766,-0.3968845277582721},
{-0.055000451555560916,0.8627070828542255,-0.5027041272178268},
{-0.24069488649145415,0.9701793887578264,-0.028599392412362232},
{0.28499925900288986,0.31179918932316164,0.9063976433691908},
{-0.4353873369434548,0.27449201651579774,0.857375063608907},
{-0.671598945590483,0.5632991156210827,0.4812992443607795},
{-0.8062901875081268,0.46319436295890404,0.3678955227387323},
{-0.8588870738468072,0.021999668907474394,0.5116922990888477},
{-0.7388645427413704,-0.4278794665570881,0.5205750182043002},
{-0.1841951833589319,-0.005499856180641289,0.9828742981731496},
{-0.7557385209741461,-0.6231317618353718,0.2014102661429046},
{-0.2606925403896836,-0.4064883685017506,-0.8756749429200075},
{0.5184854981634216,0.4411876601537158,-0.732479512834535},
{0.04009898831528704,0.2033948684122041,-0.9782753184250702},
{-0.03420141904631496,-0.1153047840947402,-0.9927411896864579},
{-0.8820198985933708,-0.4712106306317419,0.0012000270729161508},
{-0.2550958534506029,-0.42829303815324676,-0.8668859088840757},
{-0.06609933438305413,-0.2601973798255776,-0.9632902997155225},
{0.3466996637014893,0.5787994385648169,-0.7380992840440417},
{0.4060912061901439,0.45189021442335886,-0.7942827999921972},
{0.41268208379623955,-0.6272727675439328,0.6604713262597921},
{0.01429937984934361,-0.9112604794899882,0.4115821500692189},
{-0.3243078953718204,-0.8839215193313354,0.3369082021300225},
{-0.5382995989669481,-0.7983994051926646,0.26979979899922457},
{-0.401312661614214,-0.9100287118587959,0.10390327820014163},
{-0.17430523359320912,-0.9745292606803345,-0.14110423671831215},
{-0.02340059274452142,-0.7727195732346882,-0.6343160674294845},
{-0.1737057940533926,-0.8804293672113233,-0.44121471696233056},
{0.5906675998174435,-0.24488656711578116,-0.7688578254606947},
{0.582817688785286,-0.4561138432652178,-0.6725204113042293},
{0.7666826195020217,-0.211795198657269,-0.6060862601802207},
{0.8412700723495048,0.11389594822371163,-0.5284811996157295},
{0.49668915739403985,-0.866081093656086,-0.056598764462457526},
{0.12899640298545342,-0.9893724117349427,0.06709812899475912},
{0.9775711327506685,-0.1870944751817206,0.0966971445754804},
{0.9964113790829241,0.06740076972118536,-0.05120058471401618},
{0.9306700189482516,-0.16549466867512158,0.32628948875342695},
{0.8989757279830123,-0.3521904909851134,0.2603929694847346},
{0.1843941123899856,-0.7602757247836553,0.6228801117555425},
{-0.19728943937895752,0.7975573078999316,-0.5700694849971804},
{-0.5833859843200881,0.753481897814855,-0.3031927158825004},
{-0.15839603381296935,0.9855753215029204,-0.0595985076720516},
{0.33621306381239663,0.8236320028432179,-0.45671774611279453},
{0.22769304522214895,0.9711703360551209,0.07059784362179936},
{-0.19069507059613683,0.9663750195286137,0.1724955410478951},
{-0.7212136094292161,0.6871129659440023,-0.08790165871995022},
{-0.8969663643919911,0.36058647826059304,-0.2557904080395444},
{-0.25050352335683423,0.6929097458441135,-0.6761095095471282},
{0.3489015944839302,0.6829031208743935,-0.6418029330461061},
{0.7807915948237224,0.5484940954928429,-0.2991967791640084},
{0.5878181961938992,0.7955246258459455,0.14700455059629666},
{0.49081124706859136,0.7928181676364694,0.36130827947408733},
{0.1330028462913663,0.920819705752557,0.3666078454918412},
{-0.8580777674930626,0.09899743500968793,-0.5038869444584014},
{-0.9386961231930169,-0.08959962995429244,-0.3328986251315173},
{-0.6287858241833889,-0.39089118745751705,-0.6721848457634765},
{-0.9340396554953789,-0.3295139898134126,0.13780585067158804},
{-0.6035047737416405,-0.7973063067178292,-0.00920007277286345},
{0.34487975960084616,-0.9348451355489449,0.0843950470000331},
{0.26419607803833206,-0.9517858708436203,-0.1558976857160332},
{-0.7529813037063406,-0.5928852788412873,-0.2854929112990176},
{-0.6393012434421277,-0.42790083226792813,0.6389012426641254},
{-0.8123933546495383,0.24139802537222865,-0.530795658109275},
{-0.8793299548851284,0.43231472705201984,-0.1997068031281248},
{-0.9721587132961507,0.06229735428754391,0.22589040663814075},
{-0.5369826423166261,-0.47408467546054456,0.6977774447086437},
{-0.2384959611050977,-0.6990881610422383,0.6740885844064837},
{0.8385478111664694,-0.519429616123869,0.1644093740677013},
{-0.8114106904062696,0.29200384717602995,0.5063066706343287},
{-0.4793973896883197,-0.047799739731125744,0.8762952285854705},
{-0.2940187884008874,0.380824335452578,0.8766560201095848},
{-0.40099645520700394,0.5087955022676399,0.7617932657772958},
{-0.8514504044583684,-0.2540851999681402,-0.45877327723487893},
{-0.1747963363071861,0.6891855548221548,-0.7031852613913803},
{-0.17130286249474866,0.1833030630197748,-0.9680161756854447},
{-0.22710499295815587,-0.41690916584876786,-0.880119349636605},
{0.12130371073726805,-0.472714460556526,-0.8728267001771439},
{0.2594978280122693,-0.00999991630105084,-0.9656919171924796},
{0.7560089322983029,0.43690516206498486,-0.4874057587330593},
{-0.5998340805414564,-0.7717438478723607,0.21121200035070956},
{-0.28009385620864535,-0.9180798621390835,-0.28049384743493405},
{-0.1575017939556498,-0.7731088057594467,-0.6144069981355633},
{0.9219724657034616,0.37018894447225753,0.11369660450160908},
{0.8915621272452348,0.2763882592761136,0.35878475914714025},
{0.9595109288917204,-0.11210127684081486,0.2584029432262851},
{0.951040286919849,-0.03380143185898096,0.30721301381890387},
{0.5097101586246932,-0.014900296965877824,0.8602171442985305},
{0.15899292099778534,0.366183696033893,0.9168591777538954},
{-0.0342990646772592,0.31469141848202536,0.9485741327360956},
{-0.11449714161453893,-0.13079673470027678,0.9847754153886282},
{0.6614306646364353,-0.3624168020324224,0.6566304420929594},
{-0.16910357319625285,-0.5802122600145826,0.7967168348045809},
{0.4624041246631881,-0.6918061709385672,0.5546049470981923},
{-0.4638050276737501,-0.6398069355447722,0.6128066428600131},
{0.10649442516276027,-0.9766488737696521,0.1865902322570053},
{-0.679694028914184,-0.6627941773787275,-0.31419723978937264},
{-0.9328782595254896,-0.06759842463707053,-0.3537917549792242},
{-0.5730070824113082,-0.5778071417404081,-0.5812071837651874},
{0.6006124688442812,-0.7016145656695765,-0.3834079596318638},
{0.32768844263243896,-0.9390668796952195,-0.10379633916767521},
{-0.07280197878467543,-0.964826224333171,-0.252606865947926},
{-0.3134088413881251,-0.8811248568828239,0.35410998958371126},
{0.004500090790247549,-0.925218666474896,0.37940765462664894},
{0.750964701733773,-0.6600689741870355,-0.018999106967964963},
{0.07220058699315839,-0.8313067585514206,-0.5511044804976397},
{0.41179883872891215,-0.5795983655349138,-0.7031980169843882},
{0.6869285871279923,-0.049602064232855465,-0.725030172758472},
{0.9919353482459633,0.11340404122501486,-0.05660201704881694},
{0.8220995478453731,0.4261997655901934,-0.3774997923751713},
{0.9768528240320177,-0.21228974771419526,-0.026298729933506057},
{0.9340951707404509,-0.35679815535830517,-0.01269993434150918},
{0.8274874098748375,-0.5392917947377641,0.15629762194977292},
{-0.02019915609688704,-0.5855755351652006,0.8103661436097652},
{-0.7011909511891621,-0.6653914131792191,-0.2560966950934746},
{-0.41300208979586156,-0.8842044740859584,0.21820110410038013},
{-0.73259926373811,-0.4992994982042565,-0.46259953508770085},
{-0.37059369069612336,-0.004499923389456435,-0.9287841875838083},
{-0.3227070689757697,-0.19910436142880616,-0.925320269362503},
{-0.1459065236265103,-0.04110183770424656,-0.9884441943279147},
{0.025999394221171885,0.19839537744155777,-0.9797771714578544},
{-0.046001536016931834,-0.7911264161520604,-0.6099203655810158},
{-0.16959468752961843,-0.951470195662924,-0.2567919561179599},
{0.5571820116691252,-0.16079480882339434,-0.8146736986842},
{0.5101809450975443,0.17789335580723858,-0.8414685717357576},
{0.7214043356530859,-0.23310140094362952,-0.6521039191563313},
{0.604766787120052,-0.43337619963265633,-0.668163305478867},
{0.3563987704263631,-0.93369677875167,0.03449988097561596},
{0.5544157095917001,-0.8251233802022218,-0.10860307731179407},
{-0.18148935959076168,-0.9425447402217738,0.28048355573117717},
{0.048498576587665425,-0.9981707041197448,0.03609894051164375},
{-0.3308992687134242,-0.8355981533301217,0.43849903091821246},
{-0.5007905626907684,-0.8575838389848301,-0.11729778954398387},
{-0.3282018773201074,-0.8784050244911101,0.3474019871450497},
{0.5750251147703433,0.6203270933774678,-0.5334232977713064},
{-0.5576971362325581,-0.5742970509922147,0.5992969226182036},
{0.5322947968437911,0.649893647320646,-0.542494697140253},
{-0.506220469438531,-0.6638268423810685,0.5505222608176834},
{-0.5106251923153097,-0.658432484567959,0.552927279340256},
{-0.4431957785803134,-0.673493585004154,0.5915943650905087},
{-0.5026003694114073,-0.7224005309645855,0.47490034905188483},
{-0.4089925298196636,-0.7191868641718877,0.5616897408305748},
{-0.33179016920292764,-0.694079434731019,0.6388810702343294},
{-0.37098731616048697,-0.6782768101122866,0.6342783143951398},
{-0.38550766782377033,-0.6119121710541247,0.6906137364438282},
{-0.0,-1.0,-0.0},
{-0.5698098663432544,-0.5863101520481748,0.5758099702359527},
{-0.5294646594134368,-0.45896936481731354,0.7134523786430353},
{-0.4012024994993579,-0.6127038171566714,0.6809042420466419},
{-0.5090288907545655,-0.6382362241248795,0.5775327788030679},
{-0.5257939823223083,-0.6908920927852468,0.4961943210884925},
{-0.2746001084670643,-0.6899002725106614,0.6698002645711567},
{-0.2036915785457739,-0.7249700267338541,0.6579727966770704},
{-0.30980150254093103,-0.7099034430400482,0.6325030676473171},
{0.533710156600921,0.6023114620961866,-0.5936112965304605},
{0.44330465693988186,0.6671070079959287,-0.5987062894426061},
{0.39508341869686864,0.6276736570894064,-0.670771848296278},
{0.2746001084670643,0.6899002725106614,-0.6698002645711567},
{0.39589619545584237,0.6054941812288774,-0.6903933653516382},
{0.3579020293102593,0.6803038573338067,-0.6396036265628439},
{0.30980150254093103,0.7099034430400482,-0.6325030676473171},
{0.34179397764317043,0.6987876874694192,-0.6283889278846351},
{0.5770824944680415,0.6200811901223922,-0.5314838776811022},
{0.5910123493320603,0.6435134463539438,-0.4864101636465552},
{0.5978106022650476,0.6335112354213911,-0.49120871166375274},
{0.596277428345167,0.6648748316396135,-0.4498829700024997},
{0.5397892448064447,0.6989860728412465,-0.46909065346184375},
{0.5765046495287478,0.6391051544038555,-0.5091041059411717},
{0.6131062475844945,0.6601067265218151,-0.43400442252759847},
{0.6606811477324203,0.6566812618675351,-0.3636896222646909},
{0.530401527558599,0.7192020713049481,-0.44880129254958384},
{0.6223932470699037,0.6962924452679531,-0.35749612118812757},
{0.6991811153731071,0.6546823172694125,-0.2872922403413811},
{0.6925806911194935,0.6439820460308314,-0.3249909393789134},
{0.7502290156682824,0.560621682462862,-0.3505135563739442},
{0.7315825812261092,0.6408847407159832,-0.23249446437270418},
{0.7263683128735112,0.6689708167846627,-0.15769312078765516},
{0.6953863114551873,0.6685868389976103,-0.2634948131556541},
{-0.7146947898939724,-0.5939956697873507,0.3692973078324388},
{-0.7396353517164731,-0.4364208592334625,0.5123244871340579},
{-0.6032835848769802,-0.6231830434200797,0.4976864581357087},
{-0.5497744800609395,-0.6883680466968912,0.4731780355853703},
{-0.5663087948438764,-0.659810246932703,0.4939076704456835},
{-0.6004135394779746,-0.6607148992889703,0.4505101591186335},
{-0.6647698334294229,-0.6405709315506743,0.3843825571153282},
{-0.596277428345167,-0.6648748316396135,0.4498829700024997},
{-0.5397892448064447,-0.6989860728412465,0.46909065346184375},
{-0.541604804055918,-0.7189063767278425,0.43570386471042005},
{-0.6888889055335139,-0.6615893451893929,0.2961952298142355},
{-0.6953863114551873,-0.6685868389976103,0.2634948131556541},
{-0.6973745428069636,-0.6438764957175279,0.3147885088552225},
{-0.7315825812261092,-0.6408847407159832,0.23249446437270418},
{-0.8496978800064341,-0.5126987208182874,0.12309969286664944},
{-0.7874232411399484,-0.593917529734589,0.16500487019061658},
{-0.8040038190272105,-0.5935028191450864,0.036500173376235304},
{-0.14729245513722342,-0.5879698820141709,0.7953592587654278},
{-0.07200179934744881,-0.6719167914104287,0.7371184208195073},
{-0.20029646179425334,-0.6567883979354249,0.7269871578852829},
{-0.21050734157155818,-0.5796202146074828,0.7872274550362499},
{-0.4173898909392607,-0.7201825573896875,0.5541865777636279},
{-0.44190962931573535,-0.7420161687084762,0.5041109846980362},
{-0.4419927756871216,-0.7062884558095339,0.5529909614366023},
{-0.448109056375545,-0.7159144687776225,0.5354108207620325},
{-0.4529219898964272,-0.6232302585635977,0.6375309528791616},
{-0.41650763673753,-0.720213205230178,0.5548101725377711},
{-0.3898913230651567,-0.6654851897919,0.6364858351653558},
{-0.33300898969901704,-0.7295196936499487,0.5974161274660443},
{-0.34690478384995416,-0.6916095373612808,0.6335087361457076},
{-0.4836857943568265,-0.7556778060687488,0.4415870307793561},
{-0.33609645924245274,-0.756892026184506,0.5604940952258101},
{-0.28680905613892366,-0.8106255959072926,0.5105161198009781},
{-0.1688899808990659,-0.8349504680326822,0.5237689283299629},
{-0.2110953865607395,-0.8678810326672942,0.44969017212868095},
{-0.16199852906003415,-0.8745920587401598,0.4569958504965161},
{-0.16679464597779478,-0.8879714965724327,0.4285862426024151},
{-0.45361045810966893,-0.8043185437777927,0.3838088488150153},
{-0.6065853784356771,-0.7880810035363619,0.10479747388733755},
{-0.6056993276741194,-0.7586991578444022,0.23979973382244318},
{-0.5450170320483815,-0.8335260480960109,0.09050282825757526},
{-0.5350886535654004,-0.8331823325559552,0.1395970398761538},
{-0.5181063572040047,-0.8503104333730267,0.09240113376886706},
{-0.7339767920207487,-0.6239802700557864,0.26819151991820817},
{-0.7828173943957574,-0.6004133413326682,0.1634036308690173},
{-0.8343037585468984,-0.519302339462309,0.18510083388113496},
{-0.6147079144153476,-0.699008999798809,0.3654047046158581},
{-0.5944665830002785,-0.7002606359547436,0.3952777800841213},
{-0.6110933818945109,-0.6881925469150753,0.3910957644558063},
{-0.5665008554169375,-0.7287011003394922,0.384800581049316},
{-0.6853849011369401,-0.5982868198865352,0.4150908556491739},
{-0.6972582424542517,-0.6279623924584398,0.3456792978867558},
{-0.6355683463067486,-0.664366912029899,0.39328041315677187},
{-0.702866691936685,-0.6685683172981471,0.24288848978719704},
{-0.631623894783918,-0.7257274547889317,0.272710316826432},
{-0.6946756798301663,-0.7007754662803808,0.1622943181753793},
{-0.58909209738252,-0.7538898866350057,0.2908960976550247},
{-0.5223995794685078,-0.6216994995321043,0.5835995302025673},
{-0.5238991067527846,-0.6013989746156225,0.6031989715466303},
{-0.5063236610575347,-0.5722267407804096,0.645130147636215},
{-0.6052105791733867,-0.6170107854427952,0.5030087926705445},
{-0.5016145821478577,-0.5617163293310439,0.6579191259869928},
{-0.5393908169495114,-0.5084913430085772,0.6711885731118132},
{-0.6669195376940393,-0.7082207476307072,0.2316067850201522},
{-0.602205272330239,-0.6342055524939183,0.48490424535525223},
{-0.6568054055307313,-0.5773047512376541,0.48510399242228647},
{-0.7466108222023023,-0.6452093523773446,0.16210234969058826},
{-0.5995964354097872,-0.6632960567166641,0.4477973378527396},
{-0.5880923842529355,-0.7522902579042398,0.29699615392470985},
{-0.5620133058225248,-0.7288172549527688,0.3911092596213336},
{-0.633305614279156,-0.7323064919258265,0.25030221893900645},
{0.5564317787263505,0.6709383183815755,-0.49012799200895824},
{0.5114094074625761,0.645811879818795,-0.5669104284132468},
{0.481910459980052,0.6753146578637251,-0.5583121182960429},
{0.5545851900002489,0.727480572890698,-0.40398921161215395},
{0.6202887015442012,0.6796876196027625,-0.39149286902233565},
{0.5675232206876213,0.7596310809415281,-0.3176129954015657},
{0.5977156334568423,0.7452194914707024,-0.29560773172133603},
{0.58909209738252,0.7538898866350057,-0.2908960976550247},
{0.633305614279156,0.7323064919258265,-0.25030221893900645},
{0.6885836669891261,0.7061832495319792,-0.1647960910830787},
{0.6920939476648913,0.7057938278599628,-0.15119867777334425},
{0.764538801328776,0.6440326854882038,-0.026501344977387268},
{0.7134057786102103,0.6750054675664311,-0.18820152443852195},
{0.7514089230339418,0.6375075704473488,-0.170202021161002},
{0.7935575140680147,0.6065675252440244,0.04839740887209162},
{0.6158403727389957,0.6145402875091148,-0.49303232179331746},
{0.5009215375845226,0.5666243625382122,-0.6542281291431318},
{0.553502662354209,0.6677032116601721,-0.4978023944352759},
{0.7162789882640644,0.6532808362877471,-0.24529280444112103},
{0.6052105791733867,0.6170107854427952,-0.5030087926705445},
{0.6582133849052745,0.5728116482433017,-0.4885099339505113},
{0.5393908169495114,0.5084913430085772,-0.6711885731118132},
{0.6010973972539048,0.6615971352906063,-0.4482980588736076},
{0.6286281851765377,0.6306282748525688,-0.45512040578085},
{0.682597430025514,0.6098977037394682,-0.4025984842195604},
{0.6860819391306754,0.5561853586131492,-0.46898765406250803},
{0.34219867056074726,0.7616970408127446,-0.5501978624854563},
{0.37849838949277903,0.77989668154668,-0.4984978788960379},
{0.46349184956748746,0.6505885595007709,-0.601589421143043},
{0.25699388361835396,0.7237827741749595,-0.6403847590241007},
{0.5404805052197588,0.6249774574696563,-0.5632796828682518},
{0.5224777559830485,0.5896748951257488,-0.6158737797319801},
{0.7027902031728511,0.49099315560311596,-0.5147928238380532},
{0.19119462750644958,0.7419791506787948,-0.6425819437010695},
{0.06770340082723747,0.7220362687926951,-0.6885345859609011},
{0.20739854717826553,0.7025950783387144,-0.6806952317466024},
{0.20309960395615842,0.6976986394889795,-0.6869986603539185},
{-0.007900156385143483,0.6970137975246844,-0.71701419343644},
{0.05019965638452807,0.7160950983458276,-0.6961952345599292},
{0.35058085004408523,0.7794574233010965,-0.5191716410236424},
{0.3062111325080872,0.7673278967127867,-0.5634204835240245},
{0.4535139571067982,0.7368226760667892,-0.5014154312973508},
{-0.3477861357820401,-0.7791689390493549,0.5214792116455834},
{-0.3050018452667458,-0.7639046216369414,0.568703440666224},
{-0.21350089030056882,-0.7554031500377034,0.6195025833311588},
{-0.3337871194035885,-0.7624705768281493,0.5542786108011059},
{-0.5439152787947751,-0.6931194699993724,0.4730132871298558},
{-0.5452915644047475,-0.6242903423031062,0.559391346282809},
{-0.6960141257500245,-0.5471111037325266,0.46500943746230095},
{-0.7027902031728511,-0.49099315560311596,0.5147928238380532},
{-0.05019965638452807,-0.7160950983458276,0.6961952345599292},
{0.007900156385143483,-0.6970137975246844,0.71701419343644},
{-0.20309960395615842,-0.6976986394889795,0.6869986603539185},
{-0.59629869410729,-0.6689985348948129,0.44369902830019203},
{-0.4533935142521677,-0.7402894102357294,0.49639289915036616},
{-0.5061170589629633,-0.7147240901814461,0.4827162702260866},
{-0.3803848001270743,-0.7949682337040591,0.47258111603589725},
{-0.5462968806537172,-0.5102970862119566,-0.6641962074504831},
{-0.8061879878884701,-0.044399338454785504,-0.589991209196474},
{-0.8093318640227422,-0.5081200050784076,-0.29461159908698853},
{0.2987013366914726,-0.9530042647036269,-0.05060022643651996},
{0.4963867838778166,-0.852277308418741,-0.16499560705044267},
{-0.1588043123896552,-0.5944161415894903,-0.788321407158471},
{-0.3466001005140438,-0.09190002665101159,-0.9335002707151178},
{-0.9286035287001135,0.04100015580088807,-0.3688014014479883},
{-0.9498231522215065,0.15600380263903454,-0.2711066083041171},
{0.19079698924726432,-0.009399851671510926,-0.9815845107186303},
{0.25751224371069775,-0.5875279346797473,-0.7671364743707815},
{-0.18270097014472722,-0.8855047020424518,-0.42720226845006826},
{-0.8194088660518963,0.38900420904831295,-0.42100455529393255},
{-0.8557910099626602,0.38359597034549714,0.34709635377195536},
{-0.9185451185686992,0.392476550226665,-0.047297174078270714},
{-0.8148090525788615,-0.2593028808710098,-0.5185057606310011},
{-0.03540081405107876,-0.49771144500626835,-0.8666199281543745},
{-0.39408524178403764,-0.9127658175601866,-0.10749597435113942},
{-0.7416002781001564,-0.6665002499376405,0.07620002857501607},
{-0.9271180326211035,-0.18450358862969862,0.3262063447751094},
{-0.5900171667992057,-0.7430216185284912,0.31590919151164254},
{-0.7054785361420518,-0.3797884451123335,0.5983817945108488},
{-0.2450952978918145,-0.3619930552298525,0.8993827455075396},
{-0.2473005205681437,-0.8369017616800625,0.48830102787474555},
{0.5689706020484686,-0.7294623096561651,0.37968038242144736},
{-0.22069009785745872,-0.9724563668617064,0.07499663497648121},
{-0.050799620782246285,-0.9694927627635389,-0.23979820991304449},
{0.4774035781532274,-0.723105419695431,-0.49920374154606434},
{0.2578029595949643,-0.6434073863591934,-0.7208082749264946},
{0.3004920100236788,-0.9537746394695004,0.004299885667560129},
{-0.645812086486299,-0.7013131251979583,-0.30180564834556367},
{0.2022033727803872,-0.8732145653404257,0.4434073960970509},
{-0.5331056429530961,-0.6421067967364154,-0.5509058313690877},
{-0.8160719357686851,-0.08689701166315247,-0.5713803505676102},
{0.43410589085690865,-0.38210518520254505,-0.8158110706313432},
{0.3925927528046742,-0.8709839217852043,-0.29539454706699125},
{0.8557964527310552,-0.5047979076170095,-0.11309953120341476},
{0.766466195753888,-0.18859168234727108,-0.6139729213214445},
{0.7044993307259537,-0.19739981247026722,-0.6816993523859228},
{0.9729918755517585,-0.2172981855677257,0.07789934954314695},
{0.7725616625787183,0.226488760774113,-0.5931705646410764},
{0.9781003032111409,0.20760006435602993,-0.014900004619002148},
{0.6970048023796326,0.626904319385641,-0.3481023984337879},
{0.7589227186916312,0.6354190215531195,-0.1424042629354174},
{0.7603861763049711,0.2471955060265503,0.6005890813897496},
{0.8169099745316839,-0.06660081320089381,0.572906995237118},
{0.7994193102066599,-0.15730379971917388,0.579814005576459},
{0.5701180217155042,0.24260766894962515,0.7849248118654608},
{0.3989869673035661,0.7982739248081123,0.4511852622741078},
{0.2678984314592757,0.7146958154682506,0.6460962171177231},
{-0.05300001166000384,0.8884001954480645,0.45600010032003313},
{0.1664009018953324,0.9566051848141526,0.23920129647454033},
{-0.22200177047117928,0.9673077143097826,0.1226009777466963},
{-0.3950196764201359,0.8963446480389059,0.20131002750221105},
{-0.7025991639074924,0.6438992337603677,0.3028996395496434},
{-0.6712029230950951,0.7036030641980169,-0.23330101602813721},
{-0.7832921866994063,0.4664953467321244,-0.41089590133382614},
{-0.1258979315139777,0.6001901389570247,-0.7898870222628355},
{0.32901117669951196,0.7855266847947314,-0.5241178045842377},
{0.4901899781683435,0.7001856848500084,-0.5190893873259631},
{0.46740053049990316,0.3256003695566292,-0.8219009328580882},
{0.4474935785132222,-0.029899570944235405,-0.8937871742460738},
{-0.39733033931638195,0.32002443639879746,-0.8600656728217682},
{0.41161064233073796,-0.10030259335707731,-0.9058234203673043},
{0.6348072717589472,-0.3538040528486382,-0.686907868574702},
{0.7385604511467333,-0.5632698377077645,0.37048016131852785},
{-0.8475195355504442,0.3614083305580301,0.38870895984478776},
{-0.5449261271095115,0.3611173141847028,0.7567362825908741},
{-0.8322016103116741,0.35730069137750675,0.42400082044238135},
{-0.045799099369566255,0.17399657839092855,0.9836806561100945},
{0.6019129111704183,-0.35700765789639366,0.7143153222279945},
{0.7297837405993871,-0.2543943321574186,-0.6345858615845041},
{0.7244843694183429,-0.5682877393242847,0.3900915838648662},
{0.6214040484605636,-0.475103095306749,0.6230040588846656},
{0.06519840787431933,0.30419257170809727,0.9503767920821026},
{-0.41502245124676673,0.5509298033538405,0.7240391679582148},
{0.050700077571178025,0.16730025596958745,0.9846015064414573},
{-0.7019994805205766,-0.5127996205284213,-0.49419963429240593},
{-0.16819791015394941,-0.7544906255122166,-0.6343921177269055},
{0.2877119892083907,-0.7251302168057145,-0.6256260703815405},
{0.5634257350581866,-0.5878268496045475,-0.5805265161542018},
{0.5054895592209803,-0.6858858331744221,-0.5234891874424988},
{0.2718102950098889,-0.9135346007782691,-0.3026114616261677},
{0.4366889650092796,-0.8842776545859995,0.16539582050042329},
{0.4463150209848011,-0.8900299544621847,-0.0930031300730148},
{-0.00539976195674109,-0.6034733964617126,0.7973648489454344},
{-0.05630031697167683,-0.7756043666648764,0.6287035396108921},
{-0.4779076800381278,-0.5451087599681597,0.6888110692828258},
{-0.4752978207644877,-0.24919885742585804,0.8437961312036076},
{-0.15439584371982984,-0.9861734525679805,0.06019837948143624},
{-0.014100367953902699,-0.9508248120972118,-0.3094080741090422},
{-0.889808764659498,-0.25490251080209714,0.3785037282800854},
{-0.8446231936713517,-0.12140333378131908,0.5214143182337707},
{-0.9413099355788054,-0.27380289000475605,0.19740208358998848},
{-0.8812743508832709,-0.4433870954063796,0.16359523862986852},
{-0.4828042680085939,-0.6022053235185899,-0.6358056205465287},
{-0.363794206623389,0.5629910344391643,0.7420881823397938},
{0.11179689376645943,0.6416821711085602,0.7587789176206567},
{-0.1776050325098953,0.932626426344191,0.3141089004017911},
{-0.7209901225029821,0.5975918130482416,0.35079519413876026},
{-0.5566856015131229,0.8069791277547874,-0.19719489961988113},
{-0.3815940738900484,0.8782863603187356,-0.28809552591122367},
{-0.13639379149591344,0.987155065724089,-0.08319621299457476},
{0.04949971636743782,0.9739944190279685,0.2210987331078889},
{0.3629983937356615,0.6527971113791732,0.6648970578370286},
{0.4909984926369414,0.29829908422321716,0.8184974872165713},
{-0.3601078036206576,0.4372094744319675,0.8241178588275033},
{-0.8081721629892605,0.3952863845949699,0.4365849620899667},
{-0.9157249950548646,0.3966108256402308,-0.06440175786997192},
{-0.7731706200746451,0.3875852720394884,-0.5019809250872631},
{-0.5975761392611294,0.3926843204281217,-0.6990720866088614},
{-0.6228251097004566,-0.006800274158579166,-0.7823315403318355},
{-0.3014111705049722,-0.010600392857839102,-0.953435334968283},
{0.1705049199904505,0.3048087953846881,-0.9370270383052911},
{0.3350008877535289,0.6741017863721009,-0.6583017445019345},
{0.5076290549804665,0.6421367537489313,-0.5744328786067375},
{0.6876111875250323,0.23290378937547995,-0.687711189152072},
{0.716338464826581,-0.21241140573665476,-0.6646356885714725},
{0.718619988692982,-0.2471068733732756,-0.6500180805043674},
{0.7038710363027719,-0.3102872319431029,-0.6389737067729383},
{0.38739560502179143,-0.4047954076221506,-0.8282906030964116},
{0.8590698385874413,-0.397086058553222,-0.32298866006721405},
{0.23299721336999207,-0.82839009251374,-0.5093939076852959},
{0.4962901785145499,-0.7841844811426758,0.3724926284438239},
{0.5597933329011074,-0.37029558980578803,0.7412911712747249},
{0.2332026188801151,-0.8089090841000219,0.5397060609330966},
{-0.5452080991264693,-0.7954118159302891,-0.2647039322061196},
{-0.12159388337354149,-0.9085542963256562,-0.3996798946085899},
{0.13210380596547558,-0.9891284972025125,-0.06460186120643242},
{0.634586153481195,-0.6837850799723306,-0.3601921406932342},
{0.3973979315491494,-0.7145962805360397,-0.575697003504895},
{-0.4827894246134795,-0.6173864762973534,-0.6210863952515164},
{-0.17430456596790908,-0.9774256039990495,0.11940312780589986},
{-0.5889011984151581,-0.8006016292259731,0.11060022507168703},
{-0.9388825322529797,-0.3227939944735987,0.11959777490409668},
{-0.4856863669750158,-0.7620786087536742,0.4281879809320605},
{-0.7580790280337801,-0.37638958732609795,0.5325852662324116},
{-0.4652061291311272,-0.16060211594681648,0.8705114690641579},
{-0.2252924055210127,-0.6901767345344118,0.6876768188051505},
{0.49269139275655216,-0.35029388041936316,0.7965860837626739},
{-0.02230072545439874,-0.9266301437688732,0.3753122091047465},
{0.2937045098673738,-0.942814477027443,0.15760242000373886},
{0.7832969216491469,-0.6215975571264007,0.00789996895318302},
{0.66612466372227,-0.6895255301553898,-0.2843105267921353},
{0.5907657306739165,-0.6146643443555458,0.5226696808111987},
{-0.01449964374812961,-0.9791759419426561,-0.2024950247583618},
{0.23090321188601617,-0.5629078301023754,0.7936110392063336},
{0.031899380201063976,-0.9029824552213409,-0.42849167448764625},
{-0.3879090403255285,-0.6203144565968685,-0.681715887573892},
{0.7260057173175359,-0.45730360128004016,-0.5136040446477774},
{0.6703242561220696,-0.7177259713841703,0.18850682124274223},
{0.9030788049891675,-0.21429497055606087,0.37219126477352243},
{0.9295711605021112,-0.17549455536587835,-0.3241899421630642},
{0.8849894332892494,0.1851977887516034,0.427194899323353},
{0.8549208859723696,0.48881194182160986,0.17370424364650908},
{0.878699784718579,0.28059993125302524,-0.3861999053810347},
{0.6255934125360487,0.6812928260243126,-0.38009599761021756},
{0.6099076208433339,0.7684096013379534,-0.1938024215763865},
{0.4902233523455968,0.38381828361942066,0.7825372770510596},
{0.3876027829979729,-0.03380024268661373,0.9212066142872359},
{0.3017896955667643,0.08839698173658704,0.949267587811562},
{-0.4323178572578987,0.4177172541675324,0.7991330088706612},
{-0.9752299936596897,0.21970675718522747,0.025600787364323273},
{-0.9664172555341477,0.24830443351524095,-0.06620118203265787},
{0.5915707002288085,-0.14849264534140985,0.7924607503910256},
{0.9655371401004047,-0.15110581239686294,-0.2119081512038071},
{-0.8656221039426399,0.08510217311173596,-0.49341259945159255},
{-0.7454917586341622,-0.2218975469361778,-0.6284930520477141},
{-0.7614138540511128,-0.3649066395367101,-0.5358097491470795},
{0.6474143533353218,-0.7509166480066314,-0.13030288884706895},
{0.2753153809233949,-0.9613537075250982,0.0007000391087772482},
{0.5369702392492115,-0.7907561735535874,-0.2938837119466355},
{0.7391410936914374,-0.6008334042616907,-0.3044169245293919},
{0.2199025354908514,-0.928310703484117,-0.29980345675378467},
{-0.3033087430005273,-0.840524228460083,-0.44891294010200034},
{-0.03639884508296799,-0.8884718092367323,-0.45748548421587515},
{-0.7422776392229224,-0.6685798593351017,0.044998644436254225},
{-0.8335751514950954,-0.4624862134914607,0.3020909948016654},
{-0.05579848425476255,-0.9669737325153294,0.24869324433977502},
{-0.4880120711278708,-0.4938122145961939,0.7197178024400177},
{-0.19008953490872546,-0.5508696727049808,0.8126552604961661},
{0.5628074600623251,-0.7298096736913376,0.38810514436778315},
{0.4602065349791954,-0.6370090455926716,0.6184087814670456},
{0.5218886829666135,-0.8425817288133138,0.13299711598880934},
{0.5745132771552544,-0.23770549343743072,-0.783218100379452},
{-0.4876835604642604,-0.43018549869125455,-0.7596743918078709},
{-0.969595413824539,-0.18189913961910442,-0.16369922570449366},
{-0.19110630565658443,-0.3542116874074422,0.915430205117935},
{-0.6362962744962193,-0.1998988295957791,0.7450956374778139},
{-0.8781153408090071,-0.47830835611997274,0.011600202657310649},
{-0.9158730874647314,-0.1469956805953876,0.37358902224786944},
{0.7773154337511572,-0.4780094909726658,-0.40900812093686256},
{0.7708142871752204,-0.5002092714647706,-0.3945073122607997},
{0.7694326669573281,-0.5048214326488943,-0.3913166136995094},
{0.8993126848948813,0.3943055617191723,-0.18910266731193376},
{0.7553965969459961,-0.5463975384846337,-0.36169837055251103},
{0.8718213162917782,0.16690408085466593,-0.4605112596379489},
{0.7303669845066811,0.5224763819889661,-0.4399801111486031},
{0.6678016928794372,0.629501595788568,-0.3972010069058288},
{0.4670154561322853,0.7684254314604883,-0.4375144797813165},
{0.3389121519130642,0.8822316329823111,-0.3268117180442295},
{-0.41689644388850045,0.812793066904709,0.40689652918740904},
{-0.1446980653997983,0.8363888175562634,-0.5286929314227599},
{-0.4825869679148948,0.4337882857055147,-0.760879452727815},
{0.21899024967619488,0.8272631669274705,-0.517376964303485},
{-0.501321429442512,0.5261224895864863,-0.6869293634232226},
{-0.24809379649217708,0.930176741221375,-0.2705932339007784},
{-0.6222878219464856,0.7803847280203076,0.061298800394214314},
{-0.03309875004930613,0.9805629697386585,-0.19339269666271316},
{-0.7883679889676988,0.6098752365187715,0.08079671931581692},
{-0.610470200624467,0.7792619612557692,0.14169308342094508},
{0.25271084405498256,0.9485407027548516,0.19080818775500863},
{-0.6615040153415597,0.7495045495064233,-0.02560015539341486},
{-0.5353111399407344,0.8302172770013035,-0.15550323605601385},
{0.22100457815725527,0.9174190045315204,0.33090685480649673},
{-0.5203119126776127,0.8444193332019531,-0.12740291692317482},
{-0.5060897492559421,0.86168254679677,0.037099248562330475},
{-0.02809852837811329,0.7944583913313525,0.6066682265836774},
{-0.64659153940506,0.7605900477443376,-0.05849923454252399},
{-0.42330823977508164,0.677313184029442,0.6017117124324749},
{-0.6077037100424748,0.7575046245798496,-0.23850145605583384},
{-0.5199082406109211,0.7502118909527081,0.4085064748789406},
{-0.5013988944166566,0.7670983085500945,0.40019911756191867},
{-0.595986667927356,0.7706827600194854,-0.2254949557342597},
{-0.6388806230445501,0.6215811477296797,0.45328625203646034},
{-0.5415021091548227,0.8336032468909699,-0.10900042455748046},
{-0.44399803531304055,0.6761970078348605,0.587897398559767},
{-0.03809918754348836,0.9779791448171028,-0.2051956242499688},
{0.011900330179241298,0.9453262284400671,-0.32590904247182684},
{-0.36688039810397993,0.8429549621195287,0.39347897697987494},
{-0.37170606071673035,0.2677043649552562,-0.8889144938689847},
{-0.9180374107867499,0.35271437340358025,0.18110738027612244},
{-0.39288886961598346,-0.6544814588029044,-0.6459816995976719},
{-0.7825082594182675,-0.38920410807104117,0.4860051298112179},
{-0.07189864148800351,-0.9306824149219036,0.35869322255558916},
{-0.33968737235664465,-0.264890152891596,0.9024664514332404},
{0.4817088779764324,-0.8540157396551241,-0.1965036215951193},
{-0.2970059030509853,-0.9070180271624366,0.2985059328643741},
{-0.1639010481505544,0.07520048090861313,0.9836062901823387},
{-0.6661836187462201,-0.7342819442289843,-0.13049679112335894},
{0.1811016253943819,-0.9220082750614031,0.34220307128634725},
{0.7012024366827012,-0.7125024759504058,-0.025600088960463705},
{-0.1337032156010033,0.03140075519724385,0.990523822384396},
{0.18119590773663513,-0.3416922829669328,0.9221791728185702},
{-0.19350891129055212,0.3423157640039069,0.9194423412947473},
{-0.12949636703038375,0.3480902344654562,0.9284739520286587},
{-0.15479469914629004,0.35158796007645726,0.9232683832155659},
{0.08320276737006486,0.4210140031586215,0.9032300419308003},
{0.201798909279843,0.38309792936128767,0.9013951279725},
{0.6466704510688422,-0.31548558421558637,0.6944682669975428},
{0.45759058059484675,0.37849220881807144,0.804583437820397},
{0.7771718902010879,-0.16049419502994675,0.6084779917490505},
{0.5606102144111608,-0.7732140880890287,0.29640540055559766},
{0.006199781120591238,-0.8935684531226339,-0.44888415242474305},
{0.5901064144915884,-0.6971075776005531,0.40720442633617154},
{0.43451556245355893,-0.8436302151572436,-0.31541129665788836},
{-0.240404437906886,-0.8304153296084781,0.5026092782529156},
{-0.1845059873164342,-0.9357303649430215,0.3006097549448245},
{-0.5500125706809561,-0.11980273812287007,0.8265188903051094},
{-0.3300039699716383,-0.022500270679884426,0.9437113529158637},
{0.26680569236017043,0.1745037230766482,-0.9478202219601557},
{0.44689761804204375,0.24069871707925694,-0.8615954077087153},
{0.2919992393429723,-0.45639881108264574,-0.8404978105060555},
{0.31440650828208283,-0.4290088805757428,-0.8468175293042868},
{0.6500901804619856,-0.020199694885913104,-0.7595885265019602},
{0.6181750725927864,-0.3274867943612707,-0.7145711854979055},
{0.8116145239718608,-0.4026072047203933,-0.42330757515683676},
{-0.017199229749743104,-0.4741787643795453,-0.880260578412724},
{0.051101419106113134,-0.866924074815841,-0.4958137689395478},
{-0.1617019622652182,-0.91281107702963,0.37500455070783445},
{0.18919690854777127,-0.9251848826025263,0.32899462427175874},
{-0.2377048623026881,-0.12220249967769663,-0.9636197110427861},
{-0.5314072883009389,-0.5425074405405709,-0.6506089231625721},
{0.6652843693273618,0.1316969058175463,-0.7348827341329899},
{0.42541733185515684,0.24701006339497822,-0.8706354704116116},
{0.36759319039922117,0.31229421480325564,-0.8759837725509187},
{-0.08109900938165057,-0.07489908511326297,-0.9938878597339396},
{-0.6587079671210437,-0.5654068386370702,-0.496406004066929},
{-0.6489747131929411,-0.7506707506840383,-0.12379517641492464},
{-0.25741366774154273,-0.531128201000518,0.8072428616976429},
{-0.3846831935584021,0.16999257318671268,-0.907260362660614},
{0.2596997364049013,0.5886994024704097,-0.7654992230186829},
{-0.7087409345147936,-0.5024290186259803,-0.4952286027539519},
{0.5546172682774759,-0.39361225530835653,-0.733122826134543},
{0.6485205908556446,0.4307136753762933,-0.6276199272490403},
{0.9892073498379141,0.11570085966058094,-0.08990066796444447},
{0.890565228559463,-0.45328230193802443,-0.0377985241854342},
{0.8560954755473676,-0.4343977042141999,0.27999852021173105},
{0.9428764990961364,0.0359991027335464,0.3311917451486269},
{0.7735579118589925,0.6130666439513293,-0.16049126790766327},
{0.727997197216186,0.6460975125293652,-0.22929911720009818},
{-0.21629797870483347,-0.8679918886537007,-0.4469958228435532},
{0.21050201556644862,-0.9772093568243876,-0.027400262358768135},
{0.6054983863489506,-0.7941978834654609,0.05119986355254545},
{-0.7333575948230836,0.40347666963609796,-0.5471683609042697},
{-0.8473062955091636,0.30880229440957124,-0.4321032105387815},
{-0.8163098814909235,-0.16910204699266834,-0.5523066857128961},
{-0.29031101606051063,0.5401204952610464,0.7899299744615823},
{0.18499669876336558,0.7137872625799478,0.6754879460251538},
{-0.2226096469980835,0.9044391947217733,0.3639157706316379},
{-0.4279884872645368,0.8717765495262224,0.23839358729875135},
{-0.0732989258121133,0.9968853907516471,0.029099573548874443},
{0.44948457844866563,0.8690701827135379,0.20659291191878604},
{0.6230168933320972,0.7389200360884215,0.2566069579920002},
{0.250407731458065,0.609718825359354,0.752023219075339},
{-0.4492931820276937,0.07189890894233515,0.8904864869700896},
{-0.5265100011524587,0.437408308649735,0.7290138477495582},
{-0.14969645897214404,-0.5018881279767474,0.8518798490205044},
{0.6360011416230739,0.13150023604313554,0.760401364921675},
{0.32741620422893086,0.6235308593058595,0.7099351355593098},
{-0.16699694398388737,-0.01859965962934314,0.9857819603551866},
{0.6390128155305245,-0.4692094100890799,0.6095122238902264},
{0.5090299420218105,-0.7894464366051418,0.34302017704023774},
{0.24360741430448327,-0.9549290637083376,0.16960516201165993},
{-0.3900933177586997,-0.9143843367304666,0.10829814486866746},
{-0.800564111515303,-0.5952733144954534,-0.06889691142068996},
{-0.33090163134906386,-0.3707018275645148,0.867804278285638},
{-0.18299526688863207,-0.16729567295337786,0.9687749429601463},
{0.01729940672701927,-0.8546706895712931,0.5188822052399017},
{0.23999154044729618,-0.5626801658737232,0.7910721151994001},
{0.6614061974051046,-0.7197067436837826,-0.21110197803480135},
{0.4468951847303267,-0.8086912863983333,-0.38249587862911155},
{-0.2077095081203563,-0.9354428208752108,0.286013092548974},
{-0.652805650057352,-0.5829050450649976,0.4838041873433623},
{-0.49400681487101705,0.1460020141116771,0.8571118239391674},
{-0.936474781073714,0.07559796417423681,0.34249077684756757},
{-0.9140130521995787,0.40380576638751625,-0.039000556931929505},
{-0.9248966426312809,0.306498887411058,-0.22499918325444718},
{-0.9570248446874563,-0.17020441856405963,-0.23480609564536548},
{-0.7744229852153067,-0.2452072778600119,0.5832173101466516},
{-0.8002850588174266,-0.5737892874540039,-0.17409674964402594},
{-0.8293263522635215,-0.5486174325958855,-0.10600336831054295},
{-0.5210226962429833,-0.781234031295621,-0.3438149769065982},
{0.5481238274606809,-0.3952171804642603,-0.7371320438264328},
{-0.36510060789301824,0.9279015449573585,-0.07550012570781396},
{-0.08809923089707139,0.9347918393028641,-0.34409699604633676},
{0.11679951586701011,0.9341961277650758,-0.33709860272918757},
{0.5304017901090624,0.7930026763885492,-0.2997010114926207},
{-0.30008959607405306,-0.9326676649725735,-0.20019305942694243},
{0.37850751344871364,-0.7906156938772867,-0.48130955408947396},
{-0.19329780125001608,-0.9674889948752746,-0.1630981447691548},
{0.5919987420040098,-0.6219986782542131,-0.5124989109409713},
{0.9843348756024749,-0.0571020231605215,-0.16680591003809084},
{0.9674168525483583,-0.23680412516379085,-0.08960156087278572},
{0.9957904354788006,-0.006899933726454834,0.09139912211564809},
{0.9661492543430884,0.22248831410819417,0.13059314077541642},
{0.49892309568466126,-0.8314384881784473,0.24451131869091935},
{0.16919540386927998,-0.983973270729146,0.05629847067281598},
{0.8351111529839226,-0.1352018056321714,0.5332071210286523},
{0.8091674316663,0.24189026411280026,0.5354784474262279},
{0.506594630125381,-0.15579834854625807,0.8479910113429194},
{0.5481894638997549,-0.3843926120449941,0.7427857237955817},
{-0.11150367689436938,-0.8858292106998422,0.4504148526746545},
{-0.026900549583842054,-0.7497153168403862,0.6612135087299764},
{-0.3192094982199314,-0.9476281970965132,0.010300306490179491},
{-0.05359864155964429,-0.9762752566171775,0.20979468282114497},
{-0.47748871707492174,-0.8750793221199247,-0.07899813329616506},
{0.1756987885610293,-0.9418935056666676,-0.2862980259819163},
{0.657974520430035,0.6591744739627341,-0.36408590104646765},
{0.21359735995294638,0.8225898328524985,-0.5269934864007619},
{0.33910292647088325,0.9407081183460921,-0.00880007594498311},
{0.4268179907574736,0.8805371154216389,0.20610868766428145},
{0.013000298620289001,0.9815225458318196,0.19090438512409},
{-0.27080606341564056,0.9183205614275582,-0.2887064642101013},
{-0.37279397569802875,0.8051869882834032,-0.46119254718865565},
{0.21540253637979892,0.7323086229848037,-0.6460076067843551},
{0.879718307128459,0.21020437439854733,-0.42650887574205726},
{0.8200888386668581,0.5384926711646177,-0.19359736515779016},
{0.525507585756751,-0.6838098708667295,-0.5062073071552186},
{0.8036900423420626,-0.22469721601874018,-0.5509931732368751},
{0.3706009709758159,-0.41040107525222574,-0.8332021829925792},
{-0.4365070932978996,-0.8730141865957992,-0.21750353446115273},
{-0.48780355853993934,-0.8724063642276406,0.030900225417966637},
{0.4000023000198377,-0.8839050824688364,-0.24230139323701666},
{0.849187941616843,-0.5125927212350373,-0.12699819663841153},
{0.7323852316007058,-0.002399951605463809,-0.6808862700667947},
{0.7147904040032389,0.14849800642764546,-0.6833908255397503},
{0.6488941405123667,-0.6277943310427859,0.42989611805558087},
{0.191595661365372,-0.9646781551105135,0.18079590592306502},
{0.004499929576653183,-0.907885791698539,-0.41919343967400324},
{0.13109766779323473,0.7433867752669009,-0.6558883318503637},
{0.6577115297841765,-0.3502061391674299,-0.6669116910644175},
{0.4450054513501688,-0.8955109700765757,-0.005500067376238041},
{-0.15060852016498544,-0.6975394609234883,-0.7005396306478904},
{-0.10170155146900157,-0.33020503731626666,-0.938414315619578},
{-0.049401133274996144,0.2824064784789253,-0.9580219772762409},
{-0.46551630033863955,-0.3344117096310226,-0.8194286927980262},
{-0.5287079491837744,0.14680220718777776,-0.8360125695434754},
{-0.843590243935243,0.1583981681357782,-0.513094066101438},
{-0.695431691544292,-0.4039184069812187,-0.5943270841023479},
{-0.8719018702315176,-0.4713010109417527,0.1329002850714172},
{-0.3894174813431151,-0.7369330816685709,-0.5525248033951491},
{-0.21799772193570863,-0.9276903056869581,-0.30309683265464804},
{-0.14130137133646328,-0.9333090578083593,0.33010320366713747},
{0.1640953578079905,-0.958872873870092,0.2315934483140195},
{-0.5572899326482993,-0.8279850425853073,-0.062198876387447},
{0.2298024359187312,-0.6526069176699911,-0.722007653321688},
{-0.8205033722757902,-0.509702094879915,-0.2588010636745575},
{0.3758085535000176,-0.7940180720569824,-0.4778108750992773},
{0.7276934908108369,-0.335596998098278,-0.5981946491727946},
{0.482599727331231,-0.7858995559668763,0.3865997815711851},
{-0.2808966138117306,-0.9426886359569898,0.18009782893375822},
{-0.45291579344908117,-0.6384222621724297,0.6223217007360636},
{0.24959965555271296,-0.6907990466979732,0.6785990635339384},
{-0.5470004704206068,-0.2792002401123097,0.7892006787128755},
{0.34808878127936616,-0.2698913015435246,0.8977710653048403},
{-0.2687985323640199,0.0017999901720804905,0.9631947409710714},
{0.37262291515077245,0.18401131612383825,0.9095559348621244},
{0.20230847993765863,0.2648110997898764,0.9428395199467352},
{-0.6970040530903531,0.43190251152040676,0.5724033285350332},
{-0.8388426436497124,0.14920758516039234,0.5235266141519128},
{-0.8764109508232462,0.07980099711968855,0.47490593398671793},
{-0.757449385135951,0.5535630093878052,0.3461768675037178},
{-0.194496158738797,0.8421833670427498,0.502890068019234},
{-0.3344056548474356,0.8839149471281351,0.3269055280192187},
{0.17790774449268032,0.8798383001948293,0.44071918492368867},
{0.8906672106901966,0.27548985802756165,-0.3616866847497969},
{0.9482723013706095,0.06519809559144124,0.3106909248506257},
{0.6751089992629407,0.3417045549520764,0.6538087153282633},
{0.5771918241357162,0.2142969645049965,0.7879888382171594},
{0.6566863640492243,-0.24579489612197253,0.7129851950161367},
{0.5814212775009824,-0.6481237185214769,0.49181799840898366},
{0.9882329778847172,-0.15190506915673807,-0.017900597352900664},
{0.24989399137121532,-0.8367798798696797,0.4871882856985038},
{-0.8509988851921905,-0.46189939491218895,0.24989967263164325},
{-0.7449870187142973,0.6252891044322819,-0.23239595053584253},
{-0.9232246458108844,0.3359089672095711,0.18660498148647206},
{-0.9799605573813321,0.014099432509262023,0.19869200280782723},
{0.05899979055111531,-0.6510976886073082,0.7566973137293044},
{-0.876451467843665,-0.3540803933410631,0.3262819326382064},
{-0.9709054516494166,-0.13700076926147914,0.1964011027952883},
{-0.0665999107561794,-0.9445987342385442,-0.3213995693248657},
{0.2941900830194494,-0.9556677849819434,0.012299585387964742},
{0.09290363910681712,-0.9905388001647186,0.10100395640245995},
{-0.5329111566118467,-0.8456177031919264,0.030600640631117487},
{-0.7329097990695208,-0.6786090730639607,-0.04830064578395123},
{-0.24998607991269928,-0.9675461236941113,-0.036897945395114415},
{0.3348779155296822,-0.9141397144736801,0.22848493191559388},
{0.24298813639385375,-0.9232549231787868,-0.29758547074407765},
{0.4712074592731209,-0.6017095251371749,-0.6449102090094135},
{0.4305233974298172,-0.7809424414702539,-0.4525245931172876},
{0.03860106115775704,-0.1905052370609512,-0.9809269660529503},
{-0.23919330985668363,-0.02409932595127958,-0.9706728506600452},
{-0.2164011891278014,-0.7343040350117586,-0.6434035355121415},
{-0.7361122858165762,0.07300121840050273,-0.6729112309821684},
{-0.8149642034835256,-0.21089073682782278,-0.5397762908471253},
{-0.876172536802244,0.0034998902976579025,-0.48198489242031683},
{-0.6849057361095598,0.7260060803263841,-0.061800517581502123},
{-0.7746484092916922,0.618138628689898,-0.13350834319705773},
{0.14300247896945958,0.0032000554734424526,-0.9897171568956235},
{-0.26858752574204364,0.2912864715139885,-0.9181573571717963},
{-0.6520005150806104,0.3821003018593577,-0.6549005173716131},
{-0.23679653687597213,-0.23549655588805504,-0.9425862147774127},
{0.08719847839982776,-0.46409190166697323,-0.8814846182276167},
{0.06540221390241152,-0.4765161303440228,-0.8767296778018989},
{-0.24058974387782306,-0.2868877702350267,-0.9272604717286173},
{-0.2753030531277889,0.5198057646778956,-0.8087089686321935},
{-0.25500020782525407,0.42690034792392534,-0.8676007070948645},
{-0.24369729253811975,0.6936922931214349,-0.677792469767491},
{0.9214402447815554,-0.3538154532273869,0.1605070102967654},
{0.9011080469307888,-0.40370360508929026,0.15820141274492375},
{0.8222012785239821,-0.5439008457664728,-0.16780026092960862},
{0.8275525222875434,-0.5289335698342982,-0.18811193890306574},
{0.44880918721809443,0.8749179097529208,-0.18190372360733376},
{0.8648810895817121,0.3983912892696891,0.3053933226479996},
{0.8086063839726023,0.5588044117782466,-0.18410145348671297},
{0.49700558637418646,0.7804087718438936,-0.3794042645279001},
{0.4664843893611107,0.5737807987468495,-0.6731774724928182},
{-0.674990887684524,-0.6701909524832117,0.3085958339843616},
{-0.6915184879939181,-0.646217276849848,0.3228086304041023},
{-0.7562684567004927,0.6116744875891729,-0.23219031554390376},
{-0.6923652925978013,-0.5162741198270433,0.5040747313670589},
{-0.7491119034827203,-0.02100033369795371,-0.6621105210197692},
{0.560214946734171,0.5816155177090215,-0.5898157364937773},
{0.49827702497605536,0.7961632897570444,-0.3432841715317676},
{0.614110249585599,0.7234120738482697,-0.3155052658268303},
{-0.7408961066011897,0.6620965206919256,0.11269940776616827},
{0.6180804349734914,0.7838751868236854,-0.05929812294762666},
{-0.4319024057030997,0.4346024207422253,0.7903044020077789},
{-0.7421221934960497,-0.6007179647393573,0.297308891155337},
{-0.15830787047142558,0.3778187837277612,0.9122453534051448},
{-0.7657674402606454,-0.4627803229989902,0.4465810117790601},
{-0.688023898925201,-0.4997173579838996,0.5262182785093616},
{0.1519953231758577,-0.41448724642363827,0.8972723913532705},
{0.4326129677680662,-0.5745172214118216,0.6948208275664641},
{-0.8102889882474741,-0.540992647959871,0.22529693823541394},
{-0.763920209776478,-0.5112135243326816,0.39381041839242964},
{-0.7345847024328562,-0.5039895045278512,0.45429053949802145},
{0.2243912926648289,-0.08969651939409605,0.9703623458197415},
{0.8438333573919395,0.5353211616637891,-0.03710146664996558},
{0.8418886935107688,0.4637937712914771,-0.2758962947376423},
{0.8637972315343092,0.4593985276300783,-0.20689933688868786},
{0.7774016131100208,0.38450079783998325,-0.49780103293821504},
{0.8097751645765479,0.4156872510675117,-0.41408730013725426},
{0.7201390433966353,0.4216228589029599,-0.5510298748945232},
{0.6395121412532535,0.4203079796227404,-0.6437122209925245},
{0.6998021903842838,0.45230141570564675,-0.552901730585125},
{-0.7331886466617089,-0.5467915329986667,0.404293739559914},
{-0.3507056481599458,-0.6973112302877965,0.6251100674787058},
{0.7296904630079724,-0.2005973782094001,0.6536914563084987},
{0.45302640088278956,0.43912559078947655,0.7758452136972807},
{-0.3485125850166715,-0.6632239494492297,0.6623239169484693},
{0.0954986644605162,0.611591446953421,0.7853890164114076},
{-0.7337774550340357,0.44898620511076864,0.509884334044501},
{0.11510130583172203,0.8383095106753482,-0.5329060458533855},
{0.3421768200164654,0.6595553199382249,-0.6692546628784929},
{0.39760002783200293,0.8007000560490058,-0.44810003136700327},
{0.6444045720666582,0.5537039285433095,-0.5274037419428237},
{0.7362981261236534,-0.6547983335403618,0.17059956582465746},
{-0.5054875323037716,-0.5217871302791456,0.687183050839074},
{-0.33948952860698267,-0.6379803218004564,0.6911786809223753},
{-0.8517722284192312,0.4593850219955327,0.2518917872021652},
{0.10840523338896582,0.7508362474947928,-0.6515314534401405},
{0.06579960882248832,0.6192963182943315,-0.7823953486734782},
{0.2941870472294595,0.5258768461521847,-0.7980648619776737},
{0.5736795831069493,0.46298352270963494,-0.6756759531207349},
{0.5079141049705452,0.4134114805962264,-0.7557209866632035},
{0.5670060216359248,0.4380046516341007,-0.6976074086300197},
{0.4269002668127502,0.45670028543776764,-0.7805004878129573},
{0.43468401913579935,0.578778721591444,-0.6899746335488879},
{-0.9428956721187973,-0.2970986363203889,-0.15059930875075925},
{-0.770208822792598,-0.44560510443570717,-0.4563052270063132},
{-0.9820729639034506,0.03959890985701726,-0.1842949264305121},
{-0.5012931799526799,-0.49659324389487497,0.7085903596937343},
{-0.418416247418337,-0.5453211752323595,0.7263282038717451},
{-0.2553160420108952,-0.6020378272250642,0.7565475353750183},
{-0.9236854151224418,0.3332947373176463,0.18899701576068154},
{-0.6863059743195098,0.43390377714882017,0.5837050811748474},
{-0.6103081964941187,0.7748104057736248,0.16490221465161425},
{-0.5688772283003175,0.820067173368062,-0.06219751028349403},
{-0.24341157692990473,0.9516452613249685,0.18740891337988558},
{-0.21819588813723173,0.6966868710596211,0.6833871216910364},
{-0.18430718351246883,0.5216203305485824,0.833032468073177},
{-0.7065002720026571,0.2963001140755659,0.6427002474396429},
{-0.9929588129226422,-0.1119953545290392,-0.0385983989716153},
{-0.953871927962234,0.29189140976221417,-0.07019793410519848},
{-0.4328039623384129,-0.8932081773582957,-0.12190111600982562},
{-0.8374945814275873,-0.5429964868240954,-0.061299603392849074},
{-0.5216787628898354,-0.7941676700922125,0.31168731146781997},
{0.6285042455605182,-0.7740052284229771,0.07680051878925663},
{0.7505693736415502,-0.6516734090090569,-0.1093955362062158},
{-0.1398037537811842,-0.9249248345652166,-0.35350949185728625},
{-0.6003857079883299,-0.5987857460749699,-0.530087381420076},
{-0.9014848777180133,-0.40329323481272855,0.1570973647138102},
{-0.9393144373738546,-0.26740411003275705,0.21490330308915293},
{-0.17630532273804142,-0.4112124146902021,-0.8943270001397075},
{0.2225110969051109,-0.7760387020151284,-0.5901294304885659},
{0.1203020247001137,-0.9927167075627836,-0.006400107714719266},
{-0.9482124501112055,0.04450058429650774,0.31450412946633},
{-0.7193180874807175,-0.69191739848173,0.06190155653420882},
{-0.09210235278465322,-0.8309212261538367,-0.5487140170786017},
{0.0705007113557664,-0.9269093525625514,0.36860371923029067},
{-0.2233005147082796,-0.7295016815033138,0.6465014901876522},
{-0.487508526598696,-0.23060403329981397,0.842114728715409},
{0.09940086230622078,-0.6425055737600286,0.7598065913507701},
{-0.014200475936926676,-0.21580723290061804,0.976332722339543},
{0.402877540203183,-0.0029998327639849816,0.9152489762918179},
{0.43858530763828707,-0.5697809126591336,0.6949767186698803},
{0.939604059098303,-0.29160125972016304,0.1792007741490165},
{0.3081919901942609,-0.8692774077737541,0.38648995525659263},
{0.3246942545859972,-0.9450832768993717,0.03729933999401815},
{0.534031989474283,-0.6792406877358296,-0.5034301563695768},
{0.23809602263916246,-0.770587127449553,-0.5911901242514609},
{0.6895956624569247,-0.7220954580338534,0.055099653424269944},
{-0.36369743776057645,-0.9057936187064344,0.21739846843318483},
{0.7375167971363344,-0.5012114152199739,0.4526103083171592},
{-0.3456073234967782,-0.9349198111607,-0.08050170584922062},
{-0.8482137878271826,-0.5284085893514304,-0.03630059007088744},
{0.0644958214510879,-0.5361652629778811,-0.8416454715562897},
{0.5947993308511291,-0.746399160301417,-0.29849966418806667},
{0.8571581631310613,-0.245688008260968,-0.452677905330648},
{0.3331856383425822,-0.3130865046970662,-0.8893616648916344},
{0.8976405159190497,0.14860670751511898,-0.41491872777942707},
{0.2174935416251707,0.15749532324581328,-0.9632713960805837},
{0.6590811571390722,0.45688693778917017,-0.5973829210664265},
{0.06749800546340741,0.5628833670422523,-0.8237756577889633},
{0.19880386379063952,0.6713130470958567,-0.7140138769945503},
{0.7169057567763404,0.6952055825232416,0.05230041997405859},
{0.8990083743020101,0.4326040297253054,0.06810063436036361},
{0.9303147828193494,0.3522055965913951,0.10230162558574595},
{0.6358038402667928,0.7098042872308423,0.303201831344592},
{0.1371984736754705,0.9904889808713815,-0.010399884301930708},
{0.16290546312631043,0.9614322421708709,0.22160743172983666},
{-0.2240096393421758,0.9663415825729664,-0.12650544364636268},
{-0.997165254382056,-0.025199121951893114,-0.07089752961861992},
{-0.6926336766680593,0.10480509574763588,-0.7136346977625283},
{-0.3812987245578994,0.5311982231449153,-0.7565974691856983},
{-0.2014900768580661,0.49797547531174646,-0.843458460693691},
{-0.15790084398226664,0.055300295580869824,-0.9859052696777497},
{-0.05299909107338207,-0.3932932550785126,-0.917884258419951},
{-0.793236358821779,-0.24551125326619608,-0.5572255410180222},
{0.29850353728787543,-0.4819057106165064,-0.8238097622035235},
{0.9943463674521966,-0.0772036000878101,0.07290339956478441},
{-0.6155255971641982,0.2887120063384306,0.7333304961827888},
{0.33840643993582853,0.5447103659368966,0.7673146021358194},
{0.9165627179497869,0.17631206456579102,0.35892456025333175},
{0.4650271467520606,-0.2564149686607061,-0.8473494654688623},
{0.9921889024291892,-0.10129886697850925,0.07279918574566115},
{0.9535924618813832,0.04379965376510548,0.29789764512842287},
{0.405083695709365,0.5579775418559014,0.7242708486849989},
{0.23270495899551483,-0.9725207246374654,0.007200153436904628},
{0.11220194335448848,-0.8566148366974584,-0.5036087225786132},
{0.35158769991947364,-0.7989720484518187,-0.48788293171419567},
{0.7468931771619897,-0.6620939517993752,-0.061499438205197966},
{0.8262093692673715,-0.5392061146320101,0.1632018507194808},
{0.5189138811319829,-0.8345223237707453,-0.1852049542987921},
{0.2175988750167242,-0.7122963174375583,-0.6672965500857541},
{-0.05040043621766321,-0.9723084153657527,-0.22820197509664172},
{-0.5060744919580831,-0.8601566448969434,0.06339680456459686},
{-0.34790636500517214,-0.9270169599304243,-0.14000256137029063},
{-0.41761902297975495,-0.5917269537766308,0.6895314088710274},
{-0.3582928001785199,-0.4072918155531989,0.8400831186993429},
{0.1743975994335656,-0.898387633779331,0.4030944514430636},
{0.33708474894554313,-0.18679154880755697,0.922758250747396},
{0.5423909502824912,-0.3580940252510326,0.759987319717355},
{0.5515125249916655,-0.13470305914121003,0.823218695508865},
{0.3269126550338193,0.6784262623889354,0.6579254687878547},
{-0.5499867124815377,-0.4423893120033314,0.7083828856762207},
{-0.32259952255305996,-0.13119980582443108,0.9373986126510799},
{0.1319989380728148,0.08029935399429566,0.9879920516359169},
{-0.5617025332841378,0.33720152078228816,0.7555034073280507},
{-0.16479650305530735,0.19539585374397486,0.9667794851569851},
{-0.13740121119701507,0.678105977530538,0.7220063645141549},
{-0.6645193676992115,0.6685194842843083,0.3339097319409582},
{-0.16289400398206808,0.9079665783653642,0.38608578844368624},
{0.08980464930704506,0.7249375309874939,0.6829353564786309},
{0.09390336837423646,0.14520520860425062,0.9849353302639562},
{0.0546979286286635,-0.2610901127046442,0.9637635029672008},
{-0.6231291444316436,0.19140895240606093,0.7583354681792895},
{-0.8179513415219962,0.5012701803239324,0.28228320747146646},
{-0.6495348874557331,0.7312392759162926,-0.20831118869442525},
{-0.204399145613357,0.9787959086416529,-0.013399943988351194},
{0.028600773661391448,0.9995270375720544,0.011300305677402915},
{0.15069971216382466,0.9197982431870333,0.3622993080089826},
{-0.6369714197335804,-0.24928881466182354,0.7294672695379073},
{0.05920214404447056,-0.6538236786532914,0.7543273184585159},
{-0.3207991707352154,-0.8576977828540969,0.40179896135102733},
{0.7139079565485138,-0.6477072187371795,0.26610296573407977},
{0.3360044537685523,-0.9418124838072099,-0.00950012592500371},
{0.08180004376303512,-0.5345002859577295,-0.8412004500423612},
{-0.10459857014731908,-0.6702908371868831,-0.7346899568569343},
{0.11110621878910332,-0.94975315917202,0.2926163781970444},
{0.8886190299802927,-0.4489096135023109,0.09400201307466523},
{-0.1846049640942276,-0.4255114421565214,0.8859238228118974},
{-0.2752863378780682,-0.5310736434690957,0.8013602294786919},
{0.4014931525926733,-0.3080947454889231,0.8624852904388064},
{0.7933098609028569,-0.01160014419068844,0.6087075662820737},
{0.7744133742344605,0.45490785632651876,0.43970759381571833},
{0.8572883666757957,0.44719393161952153,0.2550965383634614},
{0.9896029886055384,0.01340004046818332,0.14320043246595907},
{0.9129990870013694,-0.40699959300061045,-0.027999972000042},
{0.9285889452144105,-0.36609564165732894,-0.06079927618892544},
{0.8697298278959303,-0.49141685342998753,-0.04560156393245306},
{0.8038875760135183,-0.44829307168411525,-0.3908939587805502},
{-0.09289893073946073,0.07309915863352616,-0.9929885707673253},
{-0.676110260051045,0.21800330822530367,0.7038106804081133},
{-0.7958113443715716,0.5668080799067691,-0.21310303780545606},
{-0.7189799659023712,0.6291824680747872,-0.2952917718094162},
{-0.11209773228581356,0.4885901159219313,-0.8652824955121718},
{-0.29999662505695207,0.8018909787772329,-0.5166941872230906},
{-0.05090215906086582,0.7950337220704976,-0.604425637257118},
{-0.07559556115896929,0.5627669552945491,-0.8231516659532212},
{0.5945062007320107,0.5392056239439867,-0.596506221592337},
{0.7241593395945906,0.6804617931429424,-0.1120937061150975},
{0.8339833705373855,0.5517889974370855,-0.0007999840484771085},
{0.9621854133796989,0.1707974107308798,-0.21219678312115162},
{0.4012948253365907,0.27309647844361556,-0.8742887261195645},
{0.8763137976693673,-0.27590434414809817,-0.3949062178473504},
{0.4315127794401975,-0.12340365465334964,-0.8936264651396535},
{0.8289030959588451,-0.5356020004772076,-0.16140060283237737},
{0.27171344063777,-0.6547323871385645,-0.705334890253291},
{0.0672971133522328,-0.9772580814136272,0.2010913743704906},
{0.0408983328134436,-0.6493735288276351,0.759369044951811},
{-0.22960344866969873,-0.9458142062360674,0.22960344866969873},
{-0.47659844390862094,-0.3775987671420379,-0.7938974079291947},
{-0.08299919283677448,-0.6101940658915637,-0.7878923377842724},
{-0.06320016368863594,-0.8853022929359081,-0.4607011932176357},
{0.5704195628743689,-0.7370252767153048,-0.3625124325770665},
{0.4791110436368352,-0.6010138535289875,-0.6397147455948309},
{-0.20680175368630693,-0.14480122791961916,-0.9676082053523721},
{-0.410216850003178,-0.8066331331364294,-0.42551747848940086},
{-0.7147293402416378,-0.4855199310022599,-0.5034206658425079},
{-0.9160927033506767,0.06659946953733771,-0.3953968506766265},
{-0.7748900582243292,-0.6066922161887992,-0.1773977240018015},
{-0.9793725338824254,-0.20169434356145108,0.012199657865392679},
{-0.8459097660846244,-0.2697031137404223,0.4601053119464898},
{-0.6573911712958539,-0.7428900230539852,0.12629830382516938},
{-0.05889870247587652,-0.7906825814545936,0.6093865753616156},
{-0.3892969887994374,-0.8992930439952069,-0.19929845843238603},
{-0.01659987135149554,-0.9636925314118223,-0.2664979346490097},
{0.5327960946189396,-0.8450938054851085,-0.04409967675055412},
{0.5695163026374979,-0.744721317952844,-0.3479099590651194},
{-0.4449152475068026,0.5771197782337059,-0.6848234693024463},
{-0.364183382691363,0.32208530358288856,-0.8738601266721091},
{-0.3145915596216815,0.1906948837249036,-0.9298750517870363},
{0.8330228043114063,-0.1995054615367654,-0.5160141260800548},
{-0.09320379347159301,0.04900199442176027,-0.994440474550988},
{0.1290055241348177,-0.9706415637616594,0.20300869301835656},
{0.48452012496134406,-0.8362347337310133,-0.25681066685257614},
{-0.07199696431199831,-0.9251609914091785,0.37268428609835796},
{-0.707107474165503,-0.5066053548469013,0.4933052142636723},
{-0.6938794406567556,-0.634881188749062,0.3397899321734624},
{-0.8416301098557798,-0.4410157776216717,0.31171115166592983},
{-0.9337928051541543,-0.16089876027982805,0.3195975375104602},
{-0.4249227658470367,-0.8550458103064636,-0.29721592376968536},
{-0.0321004786217044,-0.9256138010046603,-0.3771056226867517},
{-0.9325268804747502,-0.1179033986144483,-0.3413098383978898},
{-0.9883589592463081,0.11679515018208093,-0.09749595156466517},
{-0.8358939230732687,-0.03619973682886988,-0.5476960182644207},
{-0.7772879288121977,-0.25959596850591343,-0.573091099964326},
{0.03180154082198014,-0.5445263829423957,-0.8381406088962753},
{-0.19000835865154966,-0.40591785671928426,-0.8939393252558961},
{0.4620012889853944,-0.7431020732576765,-0.48410135064465243},
{0.15939636899207107,-0.7521828654694847,-0.6393854349656853},
{0.6476088334447326,-0.6814092944861656,-0.34100465133516655},
{0.20749475356148342,-0.9733753885144482,-0.09739753733440235},
{0.5576810001319827,0.775373583472009,0.2962899055748727},
{0.6647937210529569,0.7247931543609856,-0.18089829142370625},
{0.16869885706911497,0.9844933300802828,-0.04809967412581168},
{0.11089866312467399,0.820290111462309,0.5610932360618086},
{-0.40140320923148676,0.8894071108382768,0.21870174852746924},
{0.040300800784867474,0.9729193320991952,-0.22760452254679497},
{0.6126237426932312,0.6617256456743568,-0.4322167508847771},
{0.8407844582429327,0.3246939980869175,-0.43319199252002666},
{0.6635919141817883,0.667891861787246,0.33699589373005223},
{0.21199599543346903,0.6722873006128359,0.7092866017026396},
{-0.30059359742456154,0.6099870074151116,0.7331843833389504},
{-0.6902285277345891,0.4901202570888468,0.5323220013229814},
{-0.5308979666646815,0.8465967575406278,0.03769985560982952},
{-0.27410825352377227,0.9476285335247231,-0.16390493525190175},
{0.9720634219416356,0.05619788531336274,-0.22789142460703504},
{0.9039771748644985,-0.1288967453982675,-0.40768970596488496},
{0.9004962404360443,-0.4318981968287924,0.050699788328825594},
{0.5615071732999587,-0.3576045684275427,-0.7462095328876744},
{0.4221012219848065,-0.8068023356961428,-0.4134011967981971},
{-0.24069920810090803,-0.9584968465505623,0.15279949729048087},
{-0.03120051886894322,-0.9677160932524472,0.25010415926675317},
{0.7144108305502873,-0.624609469151329,-0.3154047815727332},
{0.0020999163619969193,-0.42548305334747105,-0.9049639560034344},
{0.9640102715841659,0.19900212037888904,-0.1763018785065233},
{0.7925736830277753,0.3986867618258567,-0.4613846799760478},
{0.5501007316344596,0.03870005147110268,-0.8342011094882134},
{-0.11800038114184662,-0.4723015255363912,-0.8735028214186698},
{-0.29340714601806295,-0.7358179210637039,-0.6103148643995359},
{-0.5944091242500864,-0.6755103691637506,0.43630669735920713},
{0.24719350754778527,0.2837925462866564,-0.9264756664361774},
{-0.26119709289253407,-0.05189942236264364,-0.9638892719721041},
{-0.3798125682058264,0.39871319363786983,-0.8347276215940054},
{-0.21399713887737967,0.520693038380615,-0.8264889499166088},
{0.9203575724938395,-0.2947864106596957,-0.25698815311920553},
{0.6307138727041969,0.6646146183592979,0.40060881148771404},
{0.7879605320454001,0.13969300295271875,0.5996699632837899},
{0.738221689271851,-0.45781345075677776,0.49541455549346375},
{0.46200007392001774,-0.5048000807680194,0.729200116672028},
{0.4539821928977185,-0.04709815261119503,0.889765099648436},
{-0.1907015914114205,0.47710398144933786,0.8579071592651162},
{0.25329808254077274,-0.7819940803272178,-0.5694956889339521},
{0.3548067396180292,-0.934917758931498,0.0064001215714638866},
{0.5029839651267836,-0.7975745737278779,0.3329893844676321},
{0.09629809861281415,-0.9111820088888499,-0.4005920903872622},
{0.21130205597900703,-0.9774095102408021,-0.004700045731667455},
{-0.057199522671974944,-0.952192053990464,-0.3000974956968475},
{-0.08290204397509161,-0.826220370714363,-0.5572137382740778},
{-0.10459616034542928,-0.9944634939151952,0.010099629249415255},
{-0.36278640120662137,-0.8111695938776495,0.458682806597236},
{-0.2993073241398337,-0.9284227187818963,0.22010538604469557},
{0.016300492037778353,-0.4487135446227698,0.8935269715187092},
{0.25450117325311306,-0.20170092984342985,0.9458043601681506},
{0.3798146345398087,-0.854932941200849,0.3533136134357936},
{0.6755872281441768,-0.17509668982836793,0.7161864606229417},
{0.8304465312227531,-0.3063171634315141,0.4653260729503216},
{0.5907973709575489,-0.7654965935477381,-0.2548988657025715},
{0.7793407683819189,-0.6092318697526818,-0.14650766401636228},
{0.35489945522975436,-0.9108986017717196,-0.21049967688324397},
{-0.8819623366026058,0.017899235629463314,0.4709798872333643},
{-0.8512106359433445,0.4014050155870048,0.33810422463868045},
{-0.6627911981913316,0.22439702002736092,0.7143905129569815},
{-0.005500060776007364,-0.023400258574285876,0.9997110468681021},
{0.12089908419290583,-0.5702956800265856,0.8124938453824316},
{-0.6134228044166391,-0.567221086835862,0.5495204288016681},
{-0.7134763771882204,-0.0973967752461565,0.6938770261119918},
{-0.285996896950502,0.4892946911814009,0.8238910608304848},
{-0.7109731328329558,-0.2446907533111453,0.6592750864652148},
{-0.8990045399843904,0.09770049338873742,0.4269021558613307},
{-0.9505817632638061,0.08849830217635896,-0.29759429070829857},
{-0.6774886555474435,0.4279928333200086,-0.5981899833925914},
{-0.5637870443225804,0.363591644760004,-0.7415829586194141},
{-0.573397026944123,-0.09199952298371,-0.8140957789243295},
{-0.9686178178886417,-0.2462045289739661,-0.03410062728680846},
{-0.45369713037472553,-0.5463965440527883,-0.7039955472422454},
{-0.7907210848588454,-0.605716151636528,-0.08870236528010572},
{-0.08549468367838806,-0.678557805194785,-0.729554634055578},
{-0.3392891344394516,-0.9399698979460197,-0.036598827941302474},
{0.5585833069873023,-0.8133756926306331,-0.16249514390518552},
{0.8698084676266488,-0.39600385511629443,-0.294302865052337},
{0.6656014743088984,-0.7361016304669172,0.1230002724459052},
{-0.26188416827114636,-0.6492607501277408,0.7140568329989522},
{-0.28670044581953985,-0.89880139763726,0.3316005156392027},
{0.10000210356637301,-0.9808206317789864,0.16730351926654205},
{-0.12909736514966566,-0.8874818866795373,-0.4423909708924252},
{-0.3811761505543663,-0.8922441740284919,-0.24208485322458578},
{0.2160929101079271,-0.8504720964682648,0.479584265098389},
{-0.7724059629970516,-0.42740329956620904,0.46980362689799954},
{-0.6130795142902893,-0.5310822541829597,-0.5848804565460612},
{0.899115024337586,-0.1071017896858586,0.424407091901759},
{0.6324951867299433,0.12989901147228403,0.7635941890703316},
{-0.041897380238717946,-0.8758452351096193,-0.4807699383955988},
{-0.08200297635204103,-0.23290845356573603,0.9690351717698507},
{0.2333945374647752,0.16789607043845653,0.9577775834779849},
{0.19970445645466922,0.7602169644308441,-0.6182137955947747},
{-0.24710787668910617,0.8190261068732414,-0.5178165056641812},
{0.1095006405806211,0.9838057552805027,-0.14190083012228433},
{0.29908877092288955,0.954164176578473,-0.010799594536834529},
{-0.0474980255481161,0.9739595133445279,0.2216907845056282},
{-0.5153153927006734,0.8549255370071913,-0.05960178033176816},
{-0.6670666274914191,0.7238637860006569,-0.176191185375488},
{-0.2943135578663219,0.7227332934760137,-0.6253288064349679},
{0.4294974337604998,0.36209783647189053,-0.8272950569268022},
{0.4486051118843751,0.6825077772204324,-0.5770065750273838},
{0.27131408020954817,-0.5874304854960878,-0.7624395678280853},
{0.3820822813450444,-0.08449608158507263,-0.9202573240561224},
{-0.08950200755254435,-0.36670822535774317,-0.9260207708788388},
{-0.3313020043831898,-0.9410056931016649,0.06890041684878291},
{-0.200104748542025,-0.9382222642785001,0.2823066992174596},
{0.3718931181815215,-0.8031851371965529,-0.46539138801204644},
{0.7140646296845813,-0.3524825402097954,-0.6048700385046957},
{0.2094075073937125,0.11250403334189425,-0.9713348229776168},
{0.17329603676495825,0.2590940745862705,-0.950178269671456},
{0.8844765395709275,-0.46358770349924483,-0.05279859953572072},
{0.44141650928617676,-0.8968335422017293,-0.029001084660849854},
{-0.05629994735957383,-0.9072991516756898,-0.41669961038604647},
{0.08999795121996045,0.5516874409783575,-0.8291811239065691},
{0.21979144588338606,-0.2407906286110981,-0.9453632071799508},
{0.5278753329620225,-0.7870632213949762,-0.31918508482947067},
{-0.3795143554019948,-0.7459282152683739,-0.5473207027971324},
{-0.5121114048479805,-0.37810842056829014,-0.7712171751977397},
{-0.5718309540473365,0.21111142777088623,-0.7927429123352985},
{-0.7448017726303283,-0.42480101102760937,-0.5146012247523722},
{-0.8839609474679921,0.042998100385886494,-0.46557943115508726},
{-0.9996472144529343,0.026301242237006972,0.003700174763381209},
{-0.827027201371987,-0.5319174950541232,-0.18190598298617225},
{-0.5462930648535623,-0.643891825845156,0.5356931994179998},
{-0.5011840776347762,-0.8000745820342868,-0.32968952593013917},
{-0.18959103445196615,-0.9518549878419122,-0.24088860864703926},
{0.23029749092250454,-0.943289722914453,0.23909739504807137},
{0.4260074871473805,-0.9046158987641324,-0.013700240783847684},
{-0.3449986596828107,-0.9253964048419508,0.1568993904470522},
{-0.09640556613604594,-0.5754332235962742,-0.812146890654387},
{-0.7223737746961558,-0.6681757423200047,0.17809353443159656},
{0.1702034406973309,-0.6692135282882129,-0.7233146219528758},
{0.3451978010970105,-0.1026993458072508,-0.9328940574837806},
{0.7051786721935843,-0.7062786389255936,0.062398112797617214},
{0.007699756345065629,-0.982368913427594,0.18679408899457914},
{0.07059844508637025,-0.701984538960792,0.7086843913981672},
{0.6497754389526027,-0.583977926051585,0.48658160756284463},
{0.6866039067873444,-0.5959033906999396,0.41650236990522715},
{0.029900636740839166,-0.3926083606840621,0.9192195749892763},
{0.7992810612596275,-0.19369541044162372,0.568886520393597},
{0.29420474261867685,-0.04640074798608635,0.9546153885240956},
{0.7392121934056962,0.26740441087213634,0.6181101958117706},
{0.5878023747263909,0.3242013097759372,0.7412029944661465},
{-0.31380824698909776,0.27620725882214403,0.9084238736931051},
{-0.40808408095049714,-0.029598845371562647,0.9124644054578012},
{-0.45419142948858754,-0.10509801681913375,0.884683306183517},
{-0.5115221749669376,0.38291659979440945,0.7692333469884036},
{-0.014200005254002918,0.7891002919671621,0.6141002272171261},
{-0.23950638652294606,0.8061214955162708,0.5411144290086268},
{0.23010046595391534,0.9063018352630746,0.3545007178646805},
{0.46191672630749486,0.4314156218425055,-0.7749280606531236},
{0.9356931039672355,0.25329813319963745,-0.2455981899480101},
{0.8554072153902929,0.46060388521015766,0.2369019982767832},
{0.860087705134132,0.3296952870395574,0.3892944350758256},
{0.9634593910424833,-0.12539471472415922,0.23669002372574552},
{0.8726931101150932,-0.4644963328159285,0.15049881181657102},
{0.8259093286985518,0.04240047891611405,-0.5622063501565878},
{0.8478277074622271,-0.5228170859415574,0.08860289558994258},
{0.6075024026767539,-0.7460029504475035,0.27280107893040073},
{-0.4643119469000926,-0.5371138201163896,0.7042181197653353},
{-0.4086994380386591,0.6958990431394735,-0.5904991880641747},
{-0.8226996626932074,0.49319979778812434,0.2826998840930713},
{-0.68892765755598,-0.1913076802009856,0.6991280670596396},
{0.5848918963789131,-0.6268913144810064,0.5146928689797002},
{-0.46429740690622356,-0.5291970444427602,0.7101960335662287},
{-0.6515728267218804,-0.3358859921667889,0.6801716340334916},
{-0.8098944886867567,0.464196841151244,0.3585975597519088},
{-0.7147978198699741,0.5864982111831839,0.380898838260315},
{0.11889305030986028,-0.48987136540622833,-0.8636495168429463},
{0.20769902485536745,-0.8642959421400774,-0.4580978492356468},
{0.3660085701910077,-0.91862150977448,-0.14890348661595915},
{0.4810074628886805,-0.8731135464617609,0.07940123191966993},
{0.2677983061810701,-0.9609939217326675,0.06909956294664653},
{-0.06249867660453421,-0.9972788828432314,0.0390991720837966},
{-0.4871148060795496,-0.8132247183409768,0.31840967820925603},
{-0.25411220149028885,-0.9300446571663464,0.2654127440988692},
{-0.9766313796703513,-0.1953062752914393,0.08970288219990837},
{-0.9176160767744989,-0.39720695912688636,-0.014400252294630322},
{-0.9759467782501492,-0.11070530623249464,-0.18780900190119684},
{-0.9521837701659551,0.22699613088392334,-0.20449651438661814},
{-0.4664969327927503,-0.7758948985078135,-0.42469720762503976},
{-0.11970380604302067,-0.9496301939720336,-0.2896092082711678},
{-0.6398176912037461,-0.002900080188325826,-0.7685212499063439},
{-0.7271127282197122,0.25170440612419415,-0.6387111807370791},
{-0.4430845499111121,0.035698755206108566,-0.8957687650877325},
{-0.4828065637998526,-0.16040218068246967,-0.860911704174178},
{0.23820211405314337,-0.6701059472166725,-0.7030062392080596},
{0.6728212480305246,-0.47061486225202864,-0.5708180267179301},
{0.6205627921704389,-0.5165690274496433,-0.5899646267814355},
{-0.48870933688107254,-0.8411160696760182,0.23170442675536015},
{0.6658668040379564,-0.5410730254767055,-0.5136743914015591},
{0.6905961948254496,-0.46789742189230793,-0.551496961260115},
{0.6353259535953174,-0.5686232287333504,-0.5225213454329504},
{-0.6424902502844273,-0.1488977404939319,-0.7516885932121464},
{-0.41708951658674925,0.3394914669892145,-0.8430788094804322},
{-0.6694959093924904,0.5270967794485164,0.5233968020553091},
{-0.6840905527746989,0.4858932898600003,0.5439924875156208},
{-0.6999729465684127,0.43568316117122485,0.5658781292329496},
{-0.6341158974848273,0.41691045207605193,0.6512163261979492},
{-0.5550816798314808,0.46898452142130154,0.6869773266874929},
{-0.6153397706946115,0.5248339211125177,0.58813801258817},
{-0.3578029751441075,-0.8267068740962372,0.43420361041803096},
{0.6569962814115707,-0.5425969289100735,-0.5233970375811509},
{0.6060244687318975,-0.48101942155122557,-0.6335255791116453},
{0.5926239247107706,-0.4393177356149874,-0.6751272554374641},
{0.5880833633569726,-0.4058885175762544,-0.6995802091558206},
{0.5287940008660901,-0.5258940337660302,-0.6661924420896165},
{0.7371085689369211,-0.3555041327595651,-0.5747066810040002},
{0.7409912822888456,-0.3826954976139557,-0.551793508187564},
{0.7053916023629606,-0.42039499522737256,-0.5706932059378247},
{0.736998769213083,-0.3704993812665499,-0.5652990559513649},
{-0.014800399838202518,-0.14220384168867553,-0.9897267378289886},
{-0.10280253874004167,-0.12010296597936773,-0.9874243847462757},
{-0.07820336242585281,-0.13940599388956368,-0.9871424431017813},
{-0.16769311298527165,-0.08509650515829825,-0.9821596635309112},
{-0.10830362119211284,-0.17700591829181878,-0.9782327077573849},
{-0.46838257415048706,-0.1240953831171551,-0.8747674548822504},
{-0.3879134006998948,-0.12090417670692775,-0.9137315654021496},
{-0.7043942380786987,-0.14899878119495472,-0.6939943231496548},
{-0.6371013347286943,-0.1532003209550086,-0.7554015825679732},
{-0.9426737469017179,-0.1519957669768337,-0.29709172611064005},
{-0.9264131875855885,-0.19110272036658676,-0.32440461793260467},
{-0.9638062647610814,-0.266601732916896,0.0010000065000633756},
{-0.8292028814850197,-0.49790173021151873,-0.25400088265460086},
{0.9842339960293444,-0.1768061069884049,-0.004800165800590178},
{0.9847812794858138,-0.16929678169876958,0.039299252928302685},
{0.9853081337522163,-0.15760130100410968,0.06580054318572601},
{0.879315590403628,-0.191803400704442,0.43590772871254574},
{0.07329805432897142,-0.3787899451543571,0.922575510558104},
{0.4188990930844452,-0.33139928252132994,0.8453981697149439},
{0.3363153060578759,-0.6277285685772487,0.7020319502010969},
{-0.3053025630257749,0.4474037559702971,0.8406070569258643},
{-0.3035100736665202,0.4429147005828726,0.8436280004780115},
{-0.3430861430305188,0.389884252893032,0.8545654847970894},
{-0.34229787433680053,0.3967975358949531,0.851694710992267},
{-0.3464000467640095,0.3906000527310107,0.8529001151415233},
{-0.18630384069326422,0.5958122827968161,0.7812161049360066},
{-0.825296125243788,0.4118980661431192,0.3862981863342727},
{-0.8366894828792999,0.35669551636553876,0.41559477600649825},
{-0.8396944202491161,0.3497976756021684,0.4153972396945133},
{-0.8283985917235911,0.4077993067417678,0.3839993472016646},
{-0.7649979574581804,0.5752984639551519,0.2894992270380957},
{-0.8378890488616967,0.3501954229757324,0.4186945276982843},
{-0.5797962980124558,-0.8107948230915818,-0.08029948728941048},
{-0.5495793004854636,-0.830068736049824,-0.09459643709229412},
{-0.5694107591179413,-0.8176154489898644,-0.08530161178918227},
{-0.6015722561273065,-0.7957633002428697,-0.06979678104668549},
{0.07410280966129348,-0.889433723518953,0.45101710063756223},
{0.0644019420698451,-0.8777264682407308,0.4748143182416531},
{0.07879867540539956,-0.8946849604722207,0.43969260882936784},
{0.08740260463642784,-0.9042269463645085,0.4180124569568287},
{-0.4172917314462613,0.48029048313836403,0.771484713181861},
{-0.4110882389337238,0.4775863364503685,0.7764777852883399},
{-0.40867308159064425,0.45936974231157807,0.7886480534635212},
{-0.4139836376200781,0.46278170891442555,0.783869018189322},
{-0.41171637634456015,0.4570181782595676,0.7884313604810571},
{-0.4315132347138661,0.5305162711835596,0.7296223778614989},
{-0.7709246160159904,0.40471292268993553,0.49181570392614354},
{-0.7711905529735888,0.40749500821672385,0.48909400863509117},
{-0.7662040302437987,0.4100021566170157,0.4948026026685351},
{-0.753432409592163,0.42651834708130804,0.5004215260949274},
{-0.7585810470893047,0.42488938427134926,0.4939876578725501},
{-0.71030711020976,0.47330473780413823,0.5210052152883077},
{0.3669878804253701,0.32828915842956136,-0.870371256463875},
{0.46138033177567556,0.44888086461660337,-0.7652673773470406},
{0.05020000778100181,-0.051700008013501865,-0.9974001545970359},
{-0.04260217596170728,-0.15780806025252134,-0.9865503893479868},
{0.8867037817996941,0.2917012441084592,-0.3587015298652873},
{0.9667121709828495,-0.2548032079925831,-0.023300293352539976},
{0.98513604678744,-0.1385050679931585,-0.10160371774804985},
{0.7911896789979558,0.43359434379867745,-0.4312943738015904},
{0.7997713487046398,-0.48188273686017247,0.3579871753391611},
{0.7738066199439505,-0.5474046830670956,0.31870272651348797},
{0.8669736877478592,-0.36068905325334816,0.343889563110137},
{0.8658154549438074,-0.3521062851532855,0.3555063458449105},
{0.6088959234554387,-0.7772947960287608,0.15829894019214313},
{0.5300923640744928,-0.8301880412273985,0.1725975137507215},
{0.5005146402673448,-0.8235240884318851,0.2670078100926695},
{-0.3828914118419475,-0.350592136306573,-0.8546808297239815},
{-0.3787079491632803,-0.2128044668126381,-0.9007189062882666},
{-0.3673054563630817,-0.22120328599922046,-0.9034134203060387},
{-0.3446892217365518,-0.42028685783543,-0.8393737531931},
{-0.186010244796356,-0.6748371676805431,-0.71413933230687},
{-0.9123802882368066,-0.05529880528221768,-0.4055912372959763},
{-0.4453961963327249,-0.23259801362144547,-0.8645926164105836},
{-0.8699769285177794,0.48978701102069927,-0.05699848842013038},
{-0.7473977652840226,0.2510992492143672,0.6150981608592485},
{-0.7320136265604887,0.28260526074589365,0.61991153976072},
{-0.708277356734852,0.15289511202140177,0.689177967332571},
{-0.6971963989898988,0.1684991297042426,0.6967964010558828},
{-0.8887340658296274,0.3638139452557876,-0.2789106908516744},
{-0.6946701228805084,0.5891746601427891,-0.4126822509180738},
{-0.834221435595185,0.43561119317341473,-0.33810868781435155},
{-0.6396295707586,0.7367340600029091,-0.21931013894209037},
{-0.5571838168310568,0.7755774736794107,-0.29669138272393136},
{-0.5053992393747171,0.7852988181261681,-0.3575994618132149},
{-0.7767004271853524,0.5060002783002296,-0.3751002063051702},
{-0.8433886438483653,0.3943946895112583,-0.36489508672073573},
{-0.8391713469835276,0.39778641781464164,-0.37088733626810105},
{0.43980148213349224,0.43790147573045984,0.7841026424303575},
{0.3946093997078529,0.2616062315346536,0.8808209814056687},
{0.3658936902177178,0.24879570955498276,0.8967845350840375},
{0.36260076871444447,0.30040063685002516,0.8822018702699475},
{0.24631567356497927,0.629240039817641,0.737146906150005},
{0.32301690391688453,0.6785355086922792,0.6597345248110487},
{0.38320321125636553,0.6948058224971889,0.6086051001321088},
{-0.37901319367891195,0.43131501433697816,0.8187285004351589},
{-0.3635960077377524,0.4221953643203495,0.8303908823581673},
{-0.35780391976341164,0.41500454639970885,0.8365091640080878},
{-0.2473048942122852,0.3308065467263402,0.9107180232880231},
{-0.3780049726881238,0.42880564097531076,0.8205107938904909},
{-0.3766799197287046,0.4277771958055212,0.8216561986755417},
{-0.8042396459705463,0.38241885180196084,0.45492242595374477},
{-0.8208654792281413,0.37208435232158776,0.43328177871793605},
{-0.8023801252904418,0.3846904713350361,0.4562886978689289},
{-0.8144506702168123,0.37827708845060787,0.43997335162111406},
{-0.8989776786613547,0.3064923898884374,0.31289223098235586},
{-0.8053836186637928,0.38159223849280277,0.45359077405748255},
{-0.5568909088301194,0.32399471082951825,0.764787514945727},
{-0.5573106642415914,0.35620681608263927,0.7500143516619299},
{0.04740089351526422,0.46750881262417776,0.8827166393654795},
{0.4945921335746728,0.440392995605107,0.7492880826678171},
{0.8467510380367974,0.3194815265148285,0.4253754033784289},
{0.8496155990856001,0.3234059377875272,0.41660764898665376},
{-0.6456057426886219,0.2387021232648297,0.725406452519093},
{-0.6509933957055006,0.2554974079919438,0.7147927484643499},
{0.9632121269170173,0.24130303802437322,-0.11830148942512786},
{0.898089739383341,0.4249951444582117,0.11319870671216369},
{0.7974451486351711,0.4560258186326035,0.3951223704862755},
{0.795420390863083,0.5481140510838016,0.2586066294659206},
{0.9283029195172728,-0.11090034878214537,0.3549011161657655},
{0.6427881181714524,-0.6967871200091288,0.3182941163876374},
{0.9553394611114286,0.27471134718654816,-0.1089044983932111},
{0.9742238639058232,-0.21810534255579966,0.05760141096384255},
{0.9571937878324752,-0.2844981536129745,-0.05329965408636746},
{0.9713715538005644,-0.19149439216883682,-0.1405958827098614},
{0.9834835415406473,-0.08289861270332452,-0.16089730740609065},
{0.8920421321448753,-0.1735081949855783,0.4173197104753996},
{0.9475412094633189,0.26541154299901304,0.17810774607431884},
{0.9387255993961481,0.30610834768846373,0.15840431974469998},
{-0.15689663224993275,0.4455904355039517,-0.8813810813581306},
{-0.18070024033147947,0.4087005435720844,-0.8946011898203736},
{-0.4607037893042506,-0.009100074848423444,-0.887507299777561},
{0.1053993465260773,0.3917975708625909,-0.9139943332527007},
{-0.11000486837317716,-0.07570335032590465,-0.9910438596165324},
{0.11239452314832721,0.35768257055299507,-0.9270548257189871},
{-0.0059000374653568576,-0.15430097981433274,-0.9880062738597586},
{0.08979765586279016,-0.06889820143592697,-0.9935740630876203},
{-0.11669422027840087,0.5448730131079746,-0.8303588733434797},
{0.1203992914522547,0.03809977578347928,-0.9919941621315338},
{-0.9890162941776709,-0.0011000181229478647,0.1478024350651767},
{-0.9142526886475121,0.34738202344541796,0.2084892109624918},
{-0.9334837808602101,-0.29249491794495064,-0.20749639478146073},
{-0.0054998032480581376,-0.5990785683475691,-0.8006713564945729},
{-0.9795757362095174,0.06069849651686168,0.19169525176741986},
{-0.3647203629063075,-0.8784490451793269,-0.308717236164456},
{0.12740841560378513,-0.8275546617906765,0.546736113112946},
{-0.3119975898279278,-0.9355927725737476,0.16529872307229637},
{-0.5629926332895896,0.6113919999880199,0.5560927235743177},
{-0.9013528785032355,-0.29638450542307415,0.3157834912706033},
{0.16970487144825339,-0.7761222789097788,-0.6073174332971377},
{-0.37670781676829773,-0.9244191818970385,-0.05950123466342903},
{-0.4793139722059377,-0.49251435700276297,0.7264211754859027},
{0.6393772961153152,-0.7170745371352715,0.2774901464998436},
{-0.15650731688810077,0.21521006130555456,0.9639450654852417},
{0.9010795727576257,0.19329561803800804,0.38819119980524947},
{-0.36890335519127326,0.7858071469485024,0.49640451481959347},
{0.34528555182836934,0.9305610614870562,0.12179490359888616},
{0.226313557719775,0.9575573641921544,0.17851069400344602},
{0.10469693399518125,0.7467781309226491,0.6567807664568773},
{-0.46390281589863874,0.5492033336743531,0.6951042192954168},
{0.2941000499970127,0.6329001075930275,0.716200121754031},
{-0.3440866995856864,0.6820736349532016,0.6452750573747265},
{0.27278750661828877,0.6673694351797872,0.6929682627803304},
{-0.37109980146165933,0.6884996316527956,0.6230996666417675},
{-0.555414982521233,0.6733181630024238,0.4880131643326642},
{0.10289878271460068,0.6992917274277964,0.7073916316064969},
{-0.5638323620871597,0.8206471023922015,0.09290533245458873},
{0.02309999792100028,0.82789992548901,0.5603999495640068},
{-0.27868878857554885,0.947061900466101,-0.15939358772494613},
{0.12910534184403047,0.8570354605757871,0.4988206391309249},
{0.21510212199290024,0.7801076958003788,0.5875057957732631},
{-0.09100293716719637,0.9858318182354086,-0.14090454776766997},
{0.1265960673542505,0.6720791221863489,0.7295773360320787},
{-0.03199880422702864,0.6834744590366898,0.7292727475866244},
{0.29488374350731833,0.9426480332463512,0.15639137838095823},
{0.0055999372250555585,0.5008943850054159,0.8654902979081404},
{0.03679904526115589,0.689782103835471,0.723081239900593},
{0.5901205542568634,0.7968277539940158,-0.12970451768702795},
{0.36990340127741217,0.8574078839017389,0.3578032900163776},
{0.7516856654910373,0.38499265826000983,0.5354897883071045},
{0.8153635662930422,0.2894870645595238,0.5013775964426432},
{0.613916886016178,0.7547207588799635,0.2313063621689884},
{-0.3105011504088934,0.7825028991786122,0.5397019995996127},
{-0.9588978472767493,-0.09379978941970914,-0.2677993987910246},
{-0.8825233077483405,0.4362115204983866,-0.1757046404208311},
{-0.7923436870735634,0.44622460327177077,-0.41602293805705204},
{-0.6324096474827591,-0.08630131653662572,-0.7698117435677229},
{-0.4053990412324012,0.543398714863559,-0.7350982614946673},
{-0.88960769958796,-0.05580048295526998,-0.45330392336243513},
{0.292210857296108,-0.8361310670269537,-0.4642172483122975},
{0.3988006301054934,-0.9146014450714248,-0.06680010554425014},
{-0.7168200389842886,-0.24360681012356686,-0.653318263767349},
{-0.3431929766275992,-0.7194852758844918,-0.6037876436123089},
{-0.27279764167458154,0.6552943350049608,-0.704393910540965},
{-0.40541374173166794,-0.030301027070719144,-0.9136309680465019},
{-0.7766804046005847,-0.6128845371181904,0.14539633169682636},
{-0.48118623586458187,-0.871575068951724,0.09389731410574446},
{-0.3807036585797385,-0.6130058910149191,-0.6923066530989046},
{-0.1993045033361299,-0.6566148363798439,-0.7274164361600647},
{-0.1754074190136841,-0.6391270324495183,-0.7488316725053972},
{-0.17540213904212854,-0.6402078073818168,-0.7479091208073427},
{-0.8181036078448659,-0.1961008648067207,0.5406023840617705},
{-0.9394735729800828,-0.05849835446443305,0.33759050371269395},
{0.7923029552955348,-0.606202261138651,0.06910025774444208},
{0.7535942576336351,-0.6517950333407687,0.08519935078342052},
{0.6367209834857719,-0.7584249943075378,0.13920458756277593},
{0.6566763042630833,-0.7511728944151488,0.06719757521924653},
{0.6574762195152024,-0.7504728558876949,0.06719756950786555},
{-0.3449065360407875,-0.7172135913263347,-0.6055114745511652},
{0.0933013724732837,-0.383505641409478,-0.9188135158462278},
{0.08259984264744964,-0.3962992450506573,-0.9143982580729776},
{-0.28979326962946844,-0.5104881440505301,-0.8095811976950229},
{-0.48271899777999383,-0.5206204894225497,-0.7042277154271217},
{-0.4365022567225009,-0.59710308703094,-0.6730034794369831},
{0.4888795994799616,-0.31558683083631806,-0.8132660631152645},
{0.3460097922156815,-0.3836108563408539,-0.8562242314886316},
{0.2208899431098301,-0.39448203964159334,-0.8919593900134379},
{0.29438728127226305,-0.434381232964236,-0.8512632219669752},
{0.5549960539920841,-0.25409819336826767,-0.7920943682290627},
{0.42110259189442967,-0.1738010697488765,-0.8902054792315871},
{-0.5831968215859835,-0.4278976679640643,-0.690496236805764},
{0.017299848626986764,-0.3074973094103139,-0.9513916753592607},
{0.792210425557801,-0.5620073960659987,0.23780312950977667},
{0.8983709965605564,-0.42238636347637915,-0.12049610984588942},
{0.9055544608112198,-0.4000798804887026,-0.14109290461623578},
{0.8359011117492179,-0.41580055301510327,-0.3583004765399507},
{0.8775974637469947,-0.38089889920377196,-0.2910991587246469},
{0.8415061682628201,-0.34250251055260356,-0.4178030625076723},
{0.7972692977505041,-0.25379022672654955,-0.5476789092912969},
{0.7762023907070451,-0.1828005630266012,-0.6034018584805863},
{0.8783739609898841,-0.1251962886110354,-0.4612863253695737},
{0.939926642598282,-0.33430947613640355,-0.06910195872278038},
{0.6899896502328692,-0.5829912551967575,0.4289935651447839},
{0.6823666706139409,-0.4967757355817788,0.5362738063456279},
{0.655407298000895,-0.6541072835251533,0.37760420464622824},
{-0.42389092459245564,0.4543902716084262,-0.7834832258037013},
{-0.42431000110459044,0.45411070351542426,-0.7834184653908465},
{-0.4253884168311124,0.4536876462535865,-0.7830786770579317},
{0.5072201268939607,0.08480336506428995,-0.8576340315935739},
{0.767082564411464,0.2808936153606834,-0.5767868897829911},
{0.4918860453908355,0.40318856170275436,-0.771678107802618},
{0.7776158635254254,0.18400375371486408,-0.6012122648553058},
{0.6626112181028846,0.04970084144236849,-0.7473126521103013},
{0.5431065146017142,0.027600331067956754,-0.8392100663851197},
{0.42600950650820774,0.2881064291667011,-0.8576191379845985},
{0.7822102431102007,0.17610230607479718,-0.5976078257257171},
{0.9173161036255499,0.30760540006019743,-0.25280443802086455},
{-0.5812839974718215,0.24989312053708615,0.7743786816483373},
{-0.5916044725467188,0.3186024086433141,0.7406055989994927},
{-0.5873213495190897,0.2876104548300531,0.7565275002744615},
{-0.5706860811362195,0.19499524412399305,0.7976805448087653},
{0.03410019675870295,0.35510204894473363,-0.9342053903806538},
{0.9123669318598212,0.31678851820823256,-0.2592906021824327},
{-0.8173200286727069,0.2529061975423071,0.5177126867048335},
{-0.34119923230259097,0.3290992595274991,0.8804980188816862},
{-0.9403888047379191,0.3396959559437166,0.016599802380528984},
{-0.9386117514926935,0.34380430445683785,0.028400355574677707},
{-0.6739162719048302,0.6353153398740742,-0.3771091054092765},
{0.3773087876239969,0.616214351799382,0.6913161009394886},
{0.8841193359013165,0.4672102179992027,0.006900150907950553},
{-0.14060161903696486,0.5819067006942379,-0.8010092236743163},
{0.1301046148925368,0.3393120356113585,0.9316330456102021},
{0.885447633936736,0.46462499517394124,0.010300554133214797},
{0.3185074117537082,0.6136142789704093,0.7225168131618657},
{-0.8254997564776078,0.5524998370125721,-0.11529996598651505},
{0.3755211987700227,0.7309412627989603,0.5698321679338454},
{-0.8195563966618427,0.43317695343327256,-0.3750800443970927},
{0.18310819793753663,0.5042225745500052,0.8439377839403994},
{0.2055033476768007,0.5086082852964519,0.8361136204018154},
{-0.9287836303327718,0.36659353884581625,0.054499039462894125},
{-0.935286971543229,0.35209509534948247,0.035599504102361755},
{-0.6716797525190358,0.2831914633220053,0.6845793636661187},
{-0.4020842164938663,0.3650856688433488,0.839667039517283},
{-0.8299304299570819,0.31251145844268957,0.4621169438283739},
{-0.15640324540101347,0.4123085554912906,0.8975186237046647},
{-0.8655037130188934,-0.09860042299672198,-0.49110210683255745},
{-0.9318321767206027,0.1713059152953845,-0.3199110467191681},
{-0.8896634400321324,0.14289412788646927,-0.4336821781970729},
{-0.8362051259531331,-0.04810029485571119,-0.5463033488497927},
{-0.9264125946648373,0.07770105635304174,-0.3684050085001361},
{-0.44470010228103524,0.6487001492010515,0.617600142048049},
{-0.8340954375104351,0.3922978541366068,0.3877978787514048},
{0.1780070901636046,0.5725228040374363,0.800331877853555},
{0.11660183008008478,0.39230615729345847,0.9124143204551401},
{0.7087334211124774,0.22141044085551362,0.6698315866532204},
{0.4177930458926261,0.193096785930747,0.8877852229379452},
{0.943706162421361,0.08750057138059666,0.3190020830904039},
{0.9624761164515017,0.00629984367131892,0.271293267941083},
{0.8513224326416541,0.015500408441143709,0.5244138184861781},
{0.3503908864515635,0.06309835883302985,-0.9344756946032708},
{0.9796565972759153,0.05359762540980817,-0.19339143198240483},
{0.30708642400928515,-0.08849608767444395,-0.9475581093819558},
{-0.3694050424132436,-0.23250317368998144,-0.8997122811564573},
{-0.2840905541461094,-0.14369522221329079,-0.9479684805720228},
{0.5172976359552055,0.2271989617031175,-0.8250962293188479},
{-0.24239552420796784,0.12659766239574557,-0.9618822390084334},
{0.4091968819316395,0.17659865432338107,-0.8951931786539679},
{-0.1487050040075787,0.05350180036587397,-0.9874332276871769},
{-0.23141117280114076,0.00420020279068622,-0.9728469701856082},
{0.1357046662851767,-0.0055001891272547666,-0.9907340669765995},
{-0.34208139640912066,-0.16899080968471616,-0.9243497306068142},
{-0.02670028262398737,-0.01630017253823948,-0.9995105798754823},
{-0.42610498758806975,-0.10370121382981186,-0.898710519468196},
{-0.1505047131288886,0.08860277463933243,-0.984630834197367},
{-0.4543006473788838,-0.08790012525776775,-0.8865012632652003},
{-0.08199905455635141,-0.07909908799277314,-0.9934885451431114},
{-0.31840468695148816,-0.24400359175930625,-0.9160134838177235},
{-0.2701870124224618,-0.30188548871332793,-0.9142560527677898},
{0.03489923274880194,-0.24859453470923096,-0.9679787192217844},
{0.054899437558143305,-0.3361965556839304,-0.9401903677990227},
{-0.2695985980909349,-0.3031984233722977,-0.9139952472370716},
{0.1453038869309638,-0.3929105104967356,-0.9080242899746396},
{0.06540079266241063,-0.3632044020640297,-0.9294112645327897},
{-0.22329053938026544,-0.3300860145518389,-0.917161140705685},
{-0.469193487639587,-0.23739670495660264,-0.850588193917802},
{-0.033599129625820415,-0.2586932986368971,-0.9653749922847331},
{-0.4331133855760251,-0.2623081067573109,-0.8623266506169623},
{0.3400136671240306,-0.3675147725531801,-0.8656347948898849},
{-0.04600129173440811,-0.5928166465251549,-0.8040225772709592},
{-0.4807053406660024,-0.3248036085881372,-0.8145090492458059},
{0.20849714986344192,-0.5769921125717313,-0.7896892050223505},
{-0.30240299682854793,-0.47410469840084185,-0.8269081947008144},
{-0.44460435492098477,-0.6770066313124308,-0.5865057448519064},
{-0.07059755560195517,-0.919168174352935,-0.3874865835093149},
{-0.12810258385517478,-0.17710357221507772,-0.9758196824814954},
{0.14040250901525436,-0.2337041763309469,-0.9621171931878648},
{0.5782132152140523,0.12840293468260863,-0.8057184149048113},
{0.38358440761073953,0.1274948174410044,-0.9146628197120527},
{0.5579953016993395,0.3927966926657716,-0.7309938450577368},
{0.5979960233396672,0.4516969962249627,-0.6620955970789192},
{0.8114867323003894,0.14579761622846182,-0.5658907477619104},
{0.8772792394324453,-0.23199450991488355,-0.4201900563199744},
{0.8274183813035133,-0.4809106835495039,-0.29000644256468316},
{0.7645937074196818,-0.6322947962352404,0.12489897208568959},
{0.621599950272006,-0.7731999381440073,0.1255999899520012},
{0.8380724655814576,-0.2396921250445954,0.490083898558015},
{0.7953011333049225,-0.5025007160640306,-0.33910048321853287},
{0.8843356306003498,-0.4662187843332388,-0.02430097910617268},
{0.879288841895394,-0.1391982335856236,0.4554942198150256},
{0.948474514832175,-0.03429907839614507,-0.31499153629112825},
{0.996569236382502,-0.003299898133716894,0.08269744716920822},
{0.8597829721668527,-0.12709748285927772,0.49459020473799176},
{0.9960688982342214,-0.08179744591462634,-0.03399893839972245},
{0.9601476301757292,-0.1348926424814683,0.24478664847637835},
{0.9467711002532405,-0.10589676755050503,0.3039907208248681},
{0.9894046254774361,-0.08500039737778661,-0.11770055025135863},
{0.9994089247615473,-0.034300306303102934,-0.002300020539275124},
{0.9688561069683382,-0.14519342216101014,0.2005909124345636},
{0.9418849440895022,-0.12799795396905858,0.3105950351780437},
{0.9914328318418486,0.0690022850485047,0.11090367263593001},
{0.8826376806068948,-0.07810333430251358,0.46351978808213884},
{0.9830022412476651,0.07800017784060823,0.16620037893729597},
{0.8929480017100325,-0.0912049028513327,0.4408236971147747},
{0.9985056216024744,-0.03200018016152146,0.044300249411106274},
{0.9169770208437829,-0.16239593040897526,0.36439086847925245},
{0.9927332521571809,-0.026400884312430317,-0.11740393251058028},
{0.9733908258346994,0.053999491057195155,0.22269790108217336},
{0.8659921368270963,0.10459905024493565,-0.48899555994047356},
{0.9963254365130955,0.03750095741166424,0.0770019658852839},
{0.8127744264550011,0.19299392754160338,-0.5496827045057998},
{0.9681789471776879,0.1591965383089113,0.1930958011774546},
{0.9873875540583212,-0.14489817357003315,0.06379919581620506},
{0.7977191694219646,0.03320079782475771,-0.6021144689845367},
{0.9648776826372979,-0.2279947265429619,0.13049698163972162},
{0.8357133965931219,-0.10410166876312552,-0.5392086435838356},
{-0.0576991420201372,0.033099507813978184,-0.9977851630449376},
{-0.07380140888234349,-0.0767014642449288,-0.9943189817305436},
{-0.5435961241734519,0.03309976399952402,-0.8386940201329547},
{-0.5114064412046907,-0.01980024938571153,-0.8591108205689281},
{-0.8309818972565503,0.13209712229553586,-0.5403882277706856},
{-0.727104355368133,-0.005600033544301396,-0.686504112171948},
{0.9812878222936876,-0.04669942046378805,-0.1867976818551522},
{0.975440476742391,0.2092086812943492,-0.06890285918346395},
{0.9720939098507322,0.22339860041215262,-0.07159955143021543},
{0.7617151811348415,0.11780234782418843,-0.6371126977826015},
{0.6948084454479819,0.13290161542895337,-0.7068085913106414},
{0.605120196223579,0.2720090784544927,-0.7482249724251889},
{0.5449774574736977,0.4642807954220878,-0.698171120748873},
{0.5775208517667864,0.4405159051138864,-0.6873248163104975},
{0.7416121143328323,0.017100279335344432,-0.6706109545194138},
{0.7456995451234162,-0.23569985622313153,-0.6231996198483478},
{0.7269250248247268,-0.3795130649621459,-0.5723197024448908},
{0.7536295353202451,-0.3529138309640585,-0.5545217321325318},
{0.2863078821644955,-0.36100993874042214,-0.8875244338840018},
{0.26670231231907177,-0.3489030250023402,-0.8984077892292991},
{0.8738353517242454,-0.17190695463652755,-0.45481840005056856},
{0.9305689939576736,-0.27579081080327356,-0.24079197694499008},
{0.4559998791600481,-0.5336998585695562,-0.7121998112670751},
{0.6094113930524907,-0.48200901124269857,-0.6295117688325285},
{0.7462036526758198,-0.10040049146160857,-0.6581032214231534},
{0.5359040862842369,-0.14630111555025913,-0.8315063402600168},
{0.8104123953523811,0.204503127899262,0.549008397147652},
{-0.7242323087239543,0.17670788311450253,0.6665297345547025},
{0.25811403404155664,0.2502136044835237,0.933150736784876},
{-0.7294870517197469,-0.05489902555094462,0.6817878983722048},
{-0.9546930785002712,-0.14549894513647163,-0.2595981179204676},
{0.12890054073890259,0.13660057304060585,0.9822041203549273},
{0.7256138666134877,0.22890437440439268,0.648912400834471},
{0.6661186315986923,0.00610017062415857,0.7458208609012231},
{0.9941749272244993,0.10039746800778489,0.03919901141339808},
{0.9871943039052997,0.1570990935408454,0.02769984017238331},
{0.9312113794725861,0.36440445304962454,0.007400090429657579},
{0.8690094852902982,0.49190536917640704,0.05340058287054307},
{0.7726168239145131,0.6288136925672352,0.08750190537473453},
{0.9067108352592225,0.418004995189539,0.05610067040701707},
{0.9940052433914883,-0.10320054438430745,0.03610019042900677},
{0.9485287076557624,-0.27610835654586824,0.1551046943146112},
{0.9674820920722121,-0.18059665718681292,0.17709672197001422},
{0.9709069808462886,-0.07160051480955222,0.22850164293271907},
{-0.8434103023197645,-0.13510165027673723,-0.5200063519163832},
{-0.8452027173311043,-0.11780037872882641,-0.5213016759875824},
{-0.8401147777489121,-0.2784048971852126,-0.46550818836105057},
{-0.9557635430949597,-0.27118965566787306,-0.11389565553307796},
{-0.6515876166950159,-0.20909602616778367,0.7291861419490571},
{0.08970261800911046,-0.0827024137051665,0.9925289673806258},
{0.02270043971177587,-0.11660225860762406,0.9929192330318176},
{0.698374907840334,0.03889860239832329,0.7146743222128961},
{0.6487172106959027,0.24380646827140598,0.720919126238132},
{0.5773017492269503,0.3624010980769908,0.7317022170610765},
{0.562405441298967,0.37050358463952215,0.7392071518637916},
{0.6852719660972887,0.22029098808001266,0.6941716020206301},
{0.6761167476192604,0.010600262571755894,0.7367182487370346},
{0.641185672866208,-0.09499787729614746,0.7614829848528031},
{0.6723059633803429,-0.06840060671607237,0.7371065381639904},
{0.6681129247695458,0.11630224988878636,0.7349142170530446},
{0.9580907400977452,-0.08159921134743348,0.2745973460294759},
{-0.9326236609624217,-0.3607091513072545,0.01010025624675151},
{-0.9088370040519453,-0.2972121012370578,-0.2927119180083675},
{-0.6210251240796022,-0.29531194708648395,0.7260293721123852},
{0.028400539473370998,-0.036800699035917345,0.9989189746461369},
{-0.9905140109197774,0.11610164226934493,0.07350103967955945},
{-0.9984830558863113,0.019999660608639183,0.051299129461159505},
{-0.6737093410447708,0.18170251932289574,0.7163099317060552},
{-0.775080146576315,-0.10009743603701346,0.6238840194155114},
{-0.32298986312221634,-0.06639791613410267,0.9440703708163606},
{0.03119833826476731,0.24528693513934044,0.9689483903384464},
{0.07570238541974746,0.374011785297035,0.9243291260696509},
{-0.026399530620518315,0.4057927850684217,0.9135837566252096},
{-0.6511059316020554,0.19910181382578596,0.7324066722551765},
{-0.9960641971158904,-0.03979856946613035,0.07919715330948553},
{-0.8566919599836832,-0.13519873116586198,-0.497795328212767},
{-0.8168013313872553,-0.17130027921968272,-0.5509008979691955},
{-0.9498852673937533,-0.22739647310805294,-0.21449667318239823},
{-0.5188036472024599,-0.44110310096569977,0.7323051481232871},
{-0.5575920097637498,-0.1430979494210771,0.8176882826108647},
{-0.5181230025813107,0.033801500650932834,0.8546379424937043},
{-0.17689151825504462,0.08949570878364327,0.9801530027902472},
{0.05590245473068202,0.14090618732653123,0.9884434035027926},
{0.5461810560386013,0.24619146099726041,0.8006722291653388},
{0.5951256802271646,0.3037131055032598,0.7440321056780549},
{0.6764984508203215,0.19079956306950085,0.7112983711285952},
{0.04629926708840294,0.28339551388452255,0.9578848368030491},
{0.0650986000696581,0.07859830976152268,0.9947786075160656},
{-0.644778477653618,0.06759774362497606,0.7613745857404849},
{-0.9974032864492434,-0.0196000645823192,0.0693002283446286},
{-0.8622952617005553,-0.14929917960326208,-0.4838973409914168},
{-0.6231984918614745,-0.7767981201508238,-0.09059978074879588},
{0.09909769005976675,-0.8504801755381597,0.5165879584750303},
{-0.6038824786040713,-0.4600866507794886,0.6508811149584203},
{-0.7317140600207462,-0.11280216751447339,0.6722129166952927},
{-0.7860557816757177,0.04289758686412452,0.6166653104686619},
{-0.8529889751887431,-0.10579863256151116,0.5110933941605704},
{-0.927975664157307,0.026599302442440048,0.37169025255093857},
{-0.9651854402874491,0.09729853226271115,0.24279633744487425},
{-0.9530582093137622,0.30278672309328214,0.0004999780764420115},
{-0.7876793079363671,0.4121891719326781,-0.45788797144098325},
{-0.9075836591033253,0.22389596878937254,-0.3551936047967179},
{-0.3688963073664448,0.47049529036571497,-0.8015919761044785},
{-0.3252115712335604,0.47681696544945146,-0.8166290561787375},
{0.024898867376283995,0.5090768426211318,-0.860360863074488},
{0.022999815542219023,0.5451956275486005,-0.8379932793208497},
{0.40618721748939524,0.48688467798027213,-0.7732756653977089},
{0.3307965200389137,0.6021936649559668,-0.7265923562886176},
{0.6400972027813359,0.40769821836267867,-0.6511971542746537},
{0.557826134766635,0.5611262893825009,-0.61152865078845},
{0.5721701992912347,0.6077683452100882,-0.5506713190312529},
{0.5906251139137767,0.5422230558145102,-0.5976254115727616},
{0.7256706327037298,0.5753767149755079,-0.37728473159586223},
{0.8050167565981847,0.45040937536872344,-0.3861080369224337},
{0.8345315542346098,0.5457206340872696,-0.07580286616055533},
{0.8916920907262327,0.4521959890393657,-0.02009982171537207},
{0.820592598288145,0.48779560010353057,0.29779731388034314},
{0.8270152916541154,0.40690752378967293,0.3879071724699291},
{0.3879757833073853,0.39497534640829174,0.8327480214906972},
{0.4807889780390163,0.2939932602817612,0.8260810623087174},
{0.03690077031162047,-0.014000292259151398,0.9992208589531483},
{-0.7043817109663091,0.03239915876676379,0.7090815889355617},
{-0.9727790660197464,-0.16839637614897746,-0.15919657412658678},
{-0.776579277258476,-0.19499479663327687,-0.5990840136563906},
{0.6986445260345114,-0.0767048885583267,0.7113453354828916},
{0.7438284147881777,-0.20540784672962048,0.6360242965922036},
{0.668910481909378,0.07920124109317198,0.7391115819692349},
{0.5395005314082851,0.1983001953257886,0.818300806026691},
{0.6425818505319439,-0.007699782522713926,0.7661783595978454},
{0.44318668244028603,0.18809434784976942,0.8764736623621632},
{0.5784282222014586,-0.09190448412917365,0.8105395471892846},
{0.3099977292749495,-0.08759935833705025,0.9466930654986927},
{0.5516983752506772,-0.09339972493821508,0.8287975591947822},
{0.40820242268856805,-0.21170125645068558,0.8880052703269192},
{0.143599033581756,-0.19569868295229562,0.9700934712929072},
{0.04129849614264395,-0.24649102419277802,0.9682647412814076},
{0.2818867713642225,-0.25238815570177286,0.925656559956938},
{0.002400029796554887,-0.38500477986401316,0.9229114580168774},
{0.2635000289850048,-0.4057000446270074,0.8752000962720158},
{0.027600331067956754,-0.5431065146017142,0.8392100663851197},
{0.3073964711087674,-0.4213951624113031,0.8531902054326621},
{0.043799082637821125,-0.33729293547344896,0.9403803039407989},
{0.37347781047506634,-0.18868878938860784,0.908246038164666},
{0.13269354992330354,-0.20768990443911187,0.9691528906229524},
{0.4930662877450738,-0.2132854171081408,0.8434423316020477},
{0.17560304410515457,-0.35190610034512465,0.9194159382134346},
{0.14560736136623553,-0.36171828713027054,0.9208465545743795},
{0.5923877969370733,-0.23379518386881792,0.7709841178907555},
{0.4635826808745577,-0.24199095938663276,0.8523681561205197},
{0.4781117927728049,-0.2245055374973744,0.8491209438263723},
{0.5377163844678559,-0.24040732532280557,0.8081246239324426},
{0.5042986661317921,-0.8061978676094602,0.3093991816402468},
{0.013400213802116834,0.2337037287727391,-0.9722155118222378},
{-0.6205189354242261,0.19160584694163046,-0.760423204668141},
{-0.9198933675927293,0.17289875340448188,-0.3519974621074472},
{-0.9372495117286682,0.34218156717545106,-0.06689639638818724},
{-0.8951802883470735,0.44519019701979123,0.021399528787564088},
{-0.5044135865629336,0.34710934951624556,0.7906212956714022},
{-0.47088632095106164,0.5794831662585267,0.6651806767820051},
{-0.6597819750026611,-0.010799704956090844,0.7513794725932093},
{-0.7188086545083008,-0.1862022418884886,0.6698080645376457},
{-0.7506154102925615,-0.24730507722535366,0.6127125791183752},
{-0.7836046859700332,-0.2168012964756294,0.5822034815872299},
{-0.7871874483962022,-0.3656941690529613,0.4965920819023806},
{-0.7670718106289296,-0.45778317677737446,0.449483481785561},
{-0.7417426736835608,-0.365821046290207,0.562132340403842},
{-0.7549147851508522,-0.1681032923352209,0.6339124152962315},
{-0.7082707525631469,-0.3226866749288825,0.6278740724755045},
{-0.7470107346213853,-0.35050503679356837,0.5649081177879793},
{-0.1052017232183396,-0.30780504188787955,0.9456154893085733},
{-0.10929864361224911,-0.32669594572847016,0.9387883497088698},
{-0.10099471205531156,-0.25538662830620373,0.961549654578095},
{-0.1480946309264819,-0.1640940508780262,0.9752646424213219},
{0.16920358376985675,-0.3976084214355499,0.9018191007308324},
{-0.573305191302011,-0.19000172047336836,0.7970072169330241},
{-0.6788206059122435,0.19360587699559567,-0.7083215014255186},
{-0.9525712042077386,0.24109271187747824,-0.1856943865435409},
{-0.9884160421225465,0.11730190382534876,-0.09630156298705102},
{-0.9922965815441648,-0.07059975678425681,-0.10179964930081224},
{-0.9952596828468554,-0.09379620039288157,-0.0256989589562586},
{-0.9984742696496024,-0.0014999613464941448,-0.05519857755098453},
{-0.991190762145145,0.03619966262071656,-0.12739881264859917},
{-0.9741733421112346,-0.032199118883167475,-0.22349388417353824},
{-0.9762110068411535,-0.049900562632015526,-0.211002379065236},
{-0.9827293398224172,-0.12100361261678282,-0.14000417988718675},
{-0.9633364244388251,-0.21100797836249566,-0.16570626547234849},
{-0.7687638804775938,-0.3101854262801113,0.5592737231414129},
{-0.7831129136384197,-0.1795029600282165,0.5954098183888585},
{-0.7764426045746016,0.023901311500944072,0.6297345544830327},
{-0.7172773846005898,0.057898174499336603,0.6943781066034428},
{0.03710061086658692,0.19290317617694383,-0.9805161443312257},
{-0.7350285747912783,-0.012200474302657954,-0.67792635489933},
{0.6507984771333452,0.07019983573257656,-0.7559982309662092},
{-0.01810050220540063,0.054901523263894726,-0.9983276989862679},
{-0.7046024590668731,0.011900041531217416,-0.7095024761679627},
{-0.006000027450188377,0.10260046939822125,-0.9947045507837298},
{-0.6862127979880248,0.23050429894526336,-0.6899128669949552},
{-0.7220994114892195,0.3370997252638359,-0.6040995076591019},
{-0.723187803540539,0.3506940855941193,-0.594989965578845},
{-0.6847987091556499,0.18369965372647912,-0.7051986707017587},
{-0.6626105322781165,0.015100240020222698,-0.7488119024597851},
{-0.6906562068783387,-0.10679322845606859,-0.7152546471406916},
{-0.6554136720718007,-0.06560136845881924,-0.7524156955551157},
{-0.6835797629206737,0.07999763170516953,-0.7254785225262563},
{-0.9727296395236813,-0.15290465907594414,-0.17440531421088723},
{-0.994659413750666,0.03939839238139765,-0.09539610744125217},
{-0.9793566546336776,0.19959116629046564,0.03199858377402255},
{-0.9513827563438105,0.30729443033892473,-0.02099961938534793},
{-0.937874504228149,0.3413907194194371,0.06199831459872614},
{0.720396707794568,0.0852996101816722,-0.6882968544905624},
{0.024500006737502782,0.3076000845900349,-0.951200261580108},
{-0.034999733128052345,0.4344966869753926,-0.8999931375784888},
{-0.06670183132391884,0.5564152765911311,-0.8282227391674601},
{-0.04949983293834575,0.48249837157074393,-0.8744970485774416},
{0.03190007640077447,0.16840040331944892,-0.9852023595624767},
{0.01279951228387646,0.010599596110085192,-0.9998619009881305},
{-0.060600377844533794,0.022600140912317882,-0.997906221964691},
{-0.1491962328426805,0.12809676559750247,-0.9804752433126557},
{-0.21040391670536454,0.08940166422746952,-0.973518122208519},
{-0.7196655504346313,0.22928902419711122,-0.6553686282546302},
{0.7663108701967911,0.21250301437663854,-0.6063086005484986},
{0.7178548806494206,0.3840758596704868,-0.5806635035424412},
{0.6954840110063784,0.4132904985606559,-0.5877864869439959},
{0.6813263746544541,0.2165083812016576,-0.6992270676036906},
{0.6916815669318587,0.017899522984068626,-0.7219807594691368},
{0.6656783591483105,0.009699684668377066,-0.7461757422209243},
{0.5204936838474695,0.18809771744804807,-0.8328898929424733},
{0.33839486151304166,0.00589991041054062,-0.9409857112404616},
{0.2863037033623546,-0.11500148755386233,-0.9512123040107291},
{-0.25189519640440644,0.17779660945098635,-0.9512818592279152},
{-0.365305417519513,0.4344064422953092,-0.8233122098106079},
{-0.7526050048399234,0.38870258488078424,-0.5315035345102568},
{0.5233107122799217,0.3044062312593315,-0.7959162925732651},
{0.6522976941317268,0.08029971614100516,-0.7536973356846275},
{0.7956140785156801,-0.04910086884756146,-0.6038106845245949},
{0.9714176168182229,-0.02640047877702397,-0.23590427816287707},
{0.9650849158406473,-0.039799377940584156,-0.2588959534878703},
{0.8376678928049913,-0.27208957100661113,-0.4735818479556451},
{0.7040111234636267,-0.25660405437608896,-0.6622104630079739},
{0.25210642753530604,0.11680297792988396,-0.9606244914336176},
{0.08160070176905285,0.4218036275267952,-0.9030077659001803},
{0.19719711206944043,0.1595976627093443,0.9672858342026864},
{0.10069813760516731,0.14909724247200049,0.9836818069732184},
{-0.6882248281585217,0.21940791528331832,0.691524947212464},
{0.010600247359658239,-0.006400149349227616,0.9999233334832334},
{-0.8961651532955079,-0.44368274773177513,-0.005799774480153923},
{-0.5891855150521663,-0.28469300090860794,0.7561814095085679},
{-0.9804836995939903,-0.18839686792810584,-0.056199065698299085},
{-0.9107084741817786,-0.19010176890518954,-0.3667034121911258},
{-0.9878158792678898,0.015000241130814282,-0.15490249007754217},
{-0.6641825023424607,0.08089786877372036,0.7431804211697031},
{0.16599558042650592,0.010199728435845545,0.9860737461360088},
{0.1371984819071965,0.026499706782366673,0.9901890436188483},
{-0.5528024544483466,-0.30420135065699544,0.775803444574941},
{-0.8763736741302378,-0.48138553939559164,-0.015399537404844435},
{-0.8709785132251148,-0.41468976972956956,-0.26349349969554275},
{-0.8505425860605265,-0.4595689778431907,-0.2556827407191119},
{-0.9758499060308278,-0.12649350662250203,-0.1780908579404554},
{-0.846571212835353,-0.12829563738102504,-0.5165824339129971},
{0.9187952360590516,-0.3337982692604608,-0.2106989075289967},
{0.962050869316624,0.02429875909405879,0.2717861202372502},
{0.9653699195419533,-0.07459767557264317,-0.24999221036408567},
{0.796479255967914,0.21279445784051737,-0.5659852591058874},
{0.9476633308768538,0.2996884037815692,-0.11009573992776366},
{0.8812243882224208,0.310508593444237,0.35640986377947204},
{-0.80080133733935,-0.22490037558394083,-0.5551009270193222},
{-0.23351248157571927,-0.8914476491503046,0.3883207562991511},
{0.7324313340827224,-0.43921879018177457,-0.520222255584151},
{0.23860671329431915,-0.6656187274463488,0.7071198950981268},
{0.8026885176228826,-0.3883944440572164,-0.4525935256959221},
{0.7479912485535876,-0.49919415946250123,-0.4373948825098118},
{0.766238527441764,-0.4810241865041614,-0.4260214208955775},
{0.8056998791450273,-0.38339994249001297,-0.4514999322750153},
{0.8831727766187346,-0.3089904755153861,-0.3528891223604523},
{0.8325048909806019,-0.32920193406704396,-0.4456026179230705},
{0.9316905433889766,-0.22459772034470768,-0.2854971022191186},
{0.9181180779229332,-0.2990058874838874,-0.2601051215202646},
{0.9815435569617817,-0.17780789040020867,0.07040312420795664},
{0.9871822851728373,-0.11189799200854994,-0.11379795791396768},
{0.9570151400992755,-0.1940030691528312,-0.21560341087294024},
{0.9378378659682731,-0.11600468378366358,-0.32711320746238237},
{0.405007992911611,0.7583149654935175,0.510810080936422},
{0.5768972712823602,0.27369870540818514,0.7695963598178271},
{-0.9311937377431704,0.13749907532182767,0.33759772966290197},
{-0.9522752125988199,0.2220942189627196,0.20939454953081263},
{-0.9553184521541068,0.20980405240440864,0.20820402149951325},
{-0.9857277880580235,0.13630384245947916,0.09880278528977653},
{-0.9770797844283882,0.1923960193675385,-0.0910981151994946},
{-0.9450735099607684,0.294691739906294,0.14139603672463513},
{-0.8985016262894154,0.2897005243584237,0.3298005969396207},
{-0.909357711302931,0.2822868725542307,0.30558578906331174},
{-0.8568315791097829,0.360913301704856,0.36821357076123024},
{-0.8350825928847752,0.32179329228873266,0.44619069925181015},
{-0.8151202722932611,0.4448110625886915,0.3711092296013117},
{-0.7465843069627998,0.4321909154424351,0.5057893684192126},
{-0.7409019633928046,0.5117013560103902,0.43500115275458223},
{-0.7465735531003139,0.42998476805938246,0.5076820156831361},
{0.6882074017104083,-0.3545038127090086,0.6330068080248306},
{0.8443874144993796,0.026199609497730633,-0.5350920245128115},
{-0.8312467229486342,-0.03709762230409519,0.5546644499213369},
{0.9512065252991455,-0.21220145570697926,-0.2240015366558122},
{0.9874615144374477,-0.1340947737580372,-0.08329675357229305},
{0.9756865112272227,-0.14539798988668462,-0.16399773274701704},
{0.9843132391020994,-0.16700224619531712,0.056900765320440375},
{0.883393056557863,-0.3203974816856909,-0.3419973119116925},
{0.6441797440864158,-0.49888431282942075,-0.5797817690489039},
{0.5819035321651604,-0.4539027551980862,-0.6748040960732948},
{-0.309012502898806,-0.8988363676551678,0.3108125757312263},
{-0.6329654884975838,-0.7510590496216986,-0.1877897610424111},
{-0.5674145004628414,0.449811495079637,0.68971762595915},
{-0.5689921024444268,0.4473937902172875,0.6899904229993927},
{-0.5044053442029329,0.5348056662960519,0.6779071824646475},
{-0.4367969402481503,0.4818966243259698,0.7595946790579097},
{-0.5003968925449459,0.35449779857550623,0.7898950947666922},
{-0.42719205430168433,0.4029925044091264,0.8093849455800171},
{-0.3589946276855947,0.3361949688799358,0.8706869702669842},
{-0.3833943909810896,0.3400950244461882,0.8586874374946833},
{-0.25669672842104424,0.27819645440878266,0.9255882034535199},
{-0.19790047397220273,0.36780088088416457,0.9086021761048176},
{0.04220103731424593,0.29220718254082134,0.9554234845978806},
{-0.1416973750804397,0.2189959431377297,0.9653821164619372},
{-0.25890247123588195,0.29010276904414584,0.9213087939344072},
{-0.377808430889204,0.1917042779286935,0.9058202136036023},
{-0.5678064588352041,0.6629075406161621,-0.4880055510947157},
{-0.7738621087694935,0.14139307685748337,-0.617