// 3D model [stormtrooper]
//
// - vertices   : 3275
// - textures   : 4653
// - normals    : 3275
// - triangles  : 6518
//
// - memory size: 158kb
//
// - model bounding box: [-0.57,0.57]x[-1.0,1.0]x[-0.21,0.21]
//
// object [stormtrooper] (tagged [ | o Stormtrooper.001_Stormtrooper | usemtl Stormtrooper]) with 6518 triangles (522 chains)

#pragma once

#include <tgx.h>

#include "stormtrooper_texture.h" // texture for object [stormtrooper]


// vertex array: 38kb.
const tgx::fVec3 stormtrooper_vert_array[3275] PROGMEM = {
{-0.24946240161591576,0.45396971724986324,-0.12867021165935325},
{-0.2569897246366905,0.4494149573258065,-0.1261801969802628},
{-0.294362099901572,0.4650315858470116,-0.11245809785682037},
{-0.2775858421483077,0.5063178448620347,-0.11807630155007197},
{-0.3138099359042771,0.517299739029386,-0.08573799242026131},
{-0.3284268840530177,0.47605400759703054,-0.08361867003063615},
{-0.3305364798228026,0.5244633945416913,-0.04415128892572996},
{-0.3464265344350712,0.479369163859231,-0.044870518426135646},
{-0.3365032207269946,0.5237133640784584,-0.03422419264327108},
{-0.3525429572112484,0.48044881866149286,-0.032765740035010434},
{-0.3354797641726983,0.5263060486336395,-0.015310239996239042},
{-0.3519566581819921,0.48299016827862884,-0.010678207481229652},
{-0.3462395671870318,0.4813490713644801,0.00025127101253842176},
{-0.3295130232685063,0.5271695563283415,-0.004910321915992806},
{-0.3268290165603808,0.4782646521395997,0.03763877657494914},
{-0.3112637229772211,0.5224575493835351,0.03750044242611078},
{-0.291815886974516,0.4692210571592921,0.06582327866522678},
{-0.27598797465567093,0.5119457751751265,0.06981389463855206},
{-0.24801475636303313,0.46048060849733724,0.08138370893846643},
{-0.25555396747472364,0.4553962881597588,0.07935787017286094},
{-0.23417161485935714,0.4944243502685494,-0.13451212760892936},
{-0.2573393425831687,0.5522680180904322,-0.12071869993999217},
{-0.29648412413004166,0.5653622098664131,-0.0867365920571882},
{-0.3137348247844,0.5724723689695972,-0.0456718838274141},
{-0.3193643762007985,0.5746365418840409,-0.03479914394938051},
{-0.319701565688592,0.5749850790949813,-0.02091115192088584},
{-0.31327335070975953,0.5737665497761123,-0.007634856206785778},
{-0.29376283204586207,0.572137881320648,0.03435388090780704},
{-0.257089692673937,0.5583250004120305,0.06810741322436638},
{-0.23478331117375173,0.5010260233011985,0.0863918374206301},
{-0.21516093638169204,0.5392802787649247,-0.13662010227540766},
{-0.2362563537117727,0.5947684834821733,-0.11589699833809892},
{-0.27622519610621793,0.608968808081092,-0.0864442530942134},
{-0.2924275832889106,0.6213972667657882,-0.04859527345716221},
{-0.2973206134362986,0.6259984983179704,-0.03691252229354777},
{-0.2973206134362986,0.62647510269014,-0.021741697181684883},
{-0.2924275832889106,0.6226157960846573,-0.009805513534456417},
{-0.27622519610621793,0.6125871106616454,0.028749186408777952},
{-0.23641846404244266,0.5982014399179939,0.060585493881280664},
{-0.2143368755341198,0.5432244231101246,0.08517871177944998},
{-0.19044559536775135,0.5824697130620129,-0.12773645615469434},
{-0.21773200622611744,0.6334091019006626,-0.10076291823452123},
{-0.24541828923346942,0.6404944040864773,-0.08592387893276286},
{-0.26038485532868816,0.655855438652993,-0.0509393888386497},
{-0.2654902500092538,0.6605987869283957,-0.03868654967884593},
{-0.2654902500092538,0.6611180803543083,-0.022155618892662158},
{-0.26077175865122043,0.6568351254180083,-0.009007930707560261},
{-0.24541828923346942,0.6440181423074732,0.026263494671838708},
{-0.21543544320829314,0.6386306756515419,0.04201791697411341},
{-0.19181866986852583,0.584573905154109,0.07402660176489517},
{-0.17359422649460995,0.6203376055709756,-0.11019341653736116},
{-0.20152961904342476,0.6632201109753287,-0.08126807023592186},
{-0.2260704212680108,0.6762770173752556,-0.04966952458173508},
{-0.2292910131706538,0.6815369572377266,-0.03964408136533643},
{-0.2292910131706538,0.6820762442710886,-0.022501454264758056},
{-0.22628278580118844,0.6762970109827048,-0.008095789913657338},
{-0.20365164327189442,0.6660424518322926,0.02088737573905424},
{-0.1724956588204366,0.6270808549590766,0.05119768463218382},
{-0.1619730772566501,0.6558667863761398,-0.08557047841190235},
{-0.18782427132081825,0.6826663258747272,-0.05181802683088083},
{-0.190220802375889,0.6903368463542603,-0.03860927708789325},
{-0.190220802375889,0.6907923763834429,-0.02409932175739487},
{-0.18678784594006834,0.6835876529207012,-0.0085486181039954},
{-0.16121169907027025,0.6605388061060479,0.024220364137628427},
{-0.15842772432489827,0.6800552688154031,-0.05462145481593318},
{-0.1576663461385184,0.6893771531966942,-0.038129970876879096},
{-0.15730429973335552,0.6897775657134491,-0.02421658156324613},
{-0.157803599551819,0.6803562536626805,-0.004876278746552118},
{-0.2533071182916381,0.44904426503634126,-0.11571489439997969},
{-0.24566793914270113,0.4538362464109448,-0.11823841188074193},
{-0.2888822303571588,0.46401083113155994,-0.1028476570869368},
{-0.2887828026876812,0.5098037573392077,-0.09377055930495735},
{-0.2303895808448272,0.4938774980864227,-0.12409167555346494},
{-0.26069664753134336,0.5767061504389271,-0.09413638828450255},
{-0.21215270901222663,0.5371868940282069,-0.12614020976536422},
{-0.1890471235818386,0.5784077685431929,-0.11749324472742906},
{-0.22826755661635756,0.6306710584156472,-0.08499174453141065},
{-0.1732570370068165,0.614769115712463,-0.10058946018070439},
{-0.20035648061714323,0.6550875760533862,-0.07380613171518405},
{-0.1623724090378671,0.6481876200123042,-0.07756060697350009},
{-0.20710945662508445,0.6721837315258392,-0.029696451107659366},
{-0.15866494577544532,0.6708457809300432,-0.04841262915127407},
{-0.15785385375432667,0.6788032366948622,-0.030853918868642815},
{-0.1581532174982972,0.6707885019465399,-0.010507451266257304},
{-0.16158563356634892,0.6523241352832325,0.016760587087966197},
{-0.20234125143231232,0.6575181502778976,0.013899880119410467},
{-0.1722460089112049,0.6208958054762491,0.041975227920370325},
{-0.22711927510744537,0.6345741348104108,0.026172712886663535},
{-0.19038291270655897,0.579976996544078,0.06401682921379462},
{-0.2600600942995794,0.5810539495074953,0.03988076244811456},
{-0.21144104466058555,0.5403772253357914,0.07484039562485832},
{-0.2309510229567141,0.49995177217662573,0.07603514876189586},
{-0.28676020612868913,0.5148043206726066,0.04555786622817623},
{-0.24424515080718787,0.46000238302186097,0.0709459651143972},
{-0.28644841392603393,0.46790796348086555,0.0561982479655829},
{-0.2520340118281101,0.45436796829554243,0.06887527582397306},
{-0.32000146980033145,0.47332893293846856,-0.0769267555805806},
{-0.3141844107681247,0.5459743546860558,-0.02569448741118718},
{-0.27069561272706594,0.6339635192315538,-0.02944572046288984},
{-0.318665680675611,0.4751775310758751,0.03079231694298823},
{-0.3372019162521821,0.4774281628333429,-0.004871415436632018},
{-0.3421949144368166,0.47783505976332447,-0.021742777917222685},
{-0.33703980592151217,0.47601402038213186,-0.03998235158866773},
{0.294362099901572,0.4650315858470116,-0.11245809785682037},
{0.2569897246366905,0.4494149573258065,-0.1261801969802628},
{0.24946240161591576,0.45396971724986324,-0.12867021165935325},
{0.2775858421483077,0.5063178448620347,-0.11807630155007197},
{0.23417161485935714,0.4944243502685494,-0.13451212760892936},
{0.2573393425831687,0.5522680180904322,-0.12071869993999217},
{0.21516093638169204,0.5392802787649247,-0.13662010227540766},
{0.2362563537117727,0.5947684834821733,-0.11589699833809892},
{0.19044559536775135,0.5824697130620129,-0.12773645615469434},
{0.21773200622611744,0.6334091019006626,-0.10076291823452123},
{0.17359422649460995,0.6203376055709756,-0.11019341653736116},
{0.20152961904342476,0.6632201109753287,-0.08126807023592186},
{0.1619730772566501,0.6558667863761398,-0.08557047841190235},
{0.18782427132081825,0.6826663258747272,-0.05181802683088083},
{0.15842772432489827,0.6800552688154031,-0.05462145481593318},
{0.1576663461385184,0.6893771531966942,-0.038129970876879096},
{0.190220802375889,0.6903368463542603,-0.03860927708789325},
{0.15730429973335552,0.6897775657134491,-0.02421658156324613},
{0.190220802375889,0.6907923763834429,-0.02409932175739487},
{0.18678784594006834,0.6835876529207012,-0.0085486181039954},
{0.157803599551819,0.6803562536626805,-0.004876278746552118},
{0.16121169907027025,0.6605388061060479,0.024220364137628427},
{0.20365164327189442,0.6660424518322926,0.02088737573905424},
{0.1724956588204366,0.6270808549590766,0.05119768463218382},
{0.21543544320829314,0.6386306756515419,0.04201791697411341},
{0.19181866986852583,0.584573905154109,0.07402660176489517},
{0.23641846404244266,0.5982014399179939,0.060585493881280664},
{0.2143368755341198,0.5432244231101246,0.08517871177944998},
{0.257089692673937,0.5583250004120305,0.06810741322436638},
{0.23478331117375173,0.5010260233011985,0.0863918374206301},
{0.27598797465567093,0.5119457751751265,0.06981389463855206},
{0.24801475636303313,0.46048060849733724,0.08138370893846643},
{0.291815886974516,0.4692210571592921,0.06582327866522678},
{0.25555396747472364,0.4553962881597588,0.07935787017286094},
{0.3138099359042771,0.517299739029386,-0.08573799242026131},
{0.29648412413004166,0.5653622098664131,-0.0867365920571882},
{0.27622519610621793,0.608968808081092,-0.0864442530942134},
{0.24541828923346942,0.6404944040864773,-0.08592387893276286},
{0.2260704212680108,0.6762770173752556,-0.04966952458173508},
{0.2292910131706538,0.6815369572377266,-0.03964408136533643},
{0.2292910131706538,0.6820762442710886,-0.022501454264758056},
{0.22628278580118844,0.6762970109827048,-0.008095789913657338},
{0.24541828923346942,0.6440181423074732,0.026263494671838708},
{0.27622519610621793,0.6125871106616454,0.028749186408777952},
{0.29376283204586207,0.572137881320648,0.03435388090780704},
{0.3112637229772211,0.5224575493835351,0.03750044242611078},
{0.3268290165603808,0.4782646521395997,0.03763877657494914},
{0.3295130232685063,0.5271695563283415,-0.004910321915992806},
{0.3462395671870318,0.4813490713644801,0.00025127101253842176},
{0.3354797641726983,0.5263060486336395,-0.015310239996239042},
{0.3519566581819921,0.48299016827862884,-0.010678207481229652},
{0.3525429572112484,0.48044881866149286,-0.032765740035010434},
{0.3365032207269946,0.5237133640784584,-0.03422419264327108},
{0.3464265344350712,0.479369163859231,-0.044870518426135646},
{0.3305364798228026,0.5244633945416913,-0.04415128892572996},
{0.3284268840530177,0.47605400759703054,-0.08361867003063615},
{0.319701565688592,0.5749850790949813,-0.02091115192088584},
{0.3193643762007985,0.5746365418840409,-0.03479914394938051},
{0.3137348247844,0.5724723689695972,-0.0456718838274141},
{0.2924275832889106,0.6213972667657882,-0.04859527345716221},
{0.26038485532868816,0.655855438652993,-0.0509393888386497},
{0.2654902500092538,0.6605987869283957,-0.03868654967884593},
{0.2654902500092538,0.6611180803543083,-0.022155618892662158},
{0.26077175865122043,0.6568351254180083,-0.009007930707560261},
{0.2924275832889106,0.6226157960846573,-0.009805513534456417},
{0.31327335070975953,0.5737665497761123,-0.007634856206785778},
{0.2973206134362986,0.62647510269014,-0.021741697181684883},
{0.2973206134362986,0.6259984983179704,-0.03691252229354777},
{0.2533071182916381,0.44904426503634126,-0.11571489439997969},
{0.2888822303571588,0.46401083113155994,-0.1028476570869368},
{0.24566793914270113,0.4538362464109448,-0.11823841188074193},
{0.2887828026876812,0.5098037573392077,-0.09377055930495735},
{0.32000146980033145,0.47332893293846856,-0.0769267555805806},
{0.3141844107681247,0.5459743546860558,-0.02569448741118718},
{0.33703980592151217,0.47601402038213186,-0.03998235158866773},
{0.3421949144368166,0.47783505976332447,-0.021742777917222685},
{0.3372019162521821,0.4774281628333429,-0.004871415436632018},
{0.318665680675611,0.4751775310758751,0.03079231694298823},
{0.28676020612868913,0.5148043206726066,0.04555786622817623},
{0.28644841392603393,0.46790796348086555,0.0561982479655829},
{0.24424515080718787,0.46000238302186097,0.0709459651143972},
{0.2520340118281101,0.45436796829554243,0.06887527582397306},
{0.2303895808448272,0.4938774980864227,-0.12409167555346494},
{0.26069664753134336,0.5767061504389271,-0.09413638828450255},
{0.27069561272706594,0.6339635192315538,-0.02944572046288984},
{0.2600600942995794,0.5810539495074953,0.03988076244811456},
{0.2309510229567141,0.49995177217662573,0.07603514876189586},
{0.21144104466058555,0.5403772253357914,0.07484039562485832},
{0.19038291270655897,0.579976996544078,0.06401682921379462},
{0.22711927510744537,0.6345741348104108,0.026172712886663535},
{0.1722460089112049,0.6208958054762491,0.041975227920370325},
{0.20234125143231232,0.6575181502778976,0.013899880119410467},
{0.16158563356634892,0.6523241352832325,0.016760587087966197},
{0.20710945662508445,0.6721837315258392,-0.029696451107659366},
{0.1581532174982972,0.6707885019465399,-0.010507451266257304},
{0.15785385375432667,0.6788032366948622,-0.030853918868642815},
{0.15866494577544532,0.6708457809300432,-0.04841262915127407},
{0.1623724090378671,0.6481876200123042,-0.07756060697350009},
{0.20035648061714323,0.6550875760533862,-0.07380613171518405},
{0.1732570370068165,0.614769115712463,-0.10058946018070439},
{0.22826755661635756,0.6306710584156472,-0.08499174453141065},
{0.1890471235818386,0.5784077685431929,-0.11749324472742906},
{0.21215270901222663,0.5371868940282069,-0.12614020976536422},
{0.05820571422704579,0.7065003270575921,0.1491490693651192},
{0.06450964461903128,0.7063209249583176,0.14939223486112416},
{0.06653170081025445,0.7148873751986865,0.12116072077495223},
{0.0581684288509917,0.715127298488078,0.12082839459707882},
{0.05303817725305666,0.7030203586258772,0.14811048251329373},
{0.051303056347119284,0.7105125577416734,0.11945045678638425},
{0.050978295318010486,0.6972308583498845,0.14666878130586897},
{0.04855690734557032,0.7028096151960063,0.11754457966547453},
{0.05281338426119433,0.6913208560614269,0.14538054454481172},
{0.05100369260314878,0.6949629348238119,0.11583053310252424},
{0.057843667821882896,0.6875534119766572,0.14473642616428314},
{0.05768155749121295,0.689966154064795,0.1149756712921247},
{0.06413516975518369,0.6873750906129202,0.1449920201189728},
{0.0660448294504757,0.6897267711431725,0.1153074571022292},
{0.06930270672917281,0.6908539783090974,0.14603222807410496},
{0.07291020195434811,0.6943415118895772,0.11668701601623048},
{0.07136258866421899,0.6966429382173214,0.147461500822845},
{0.07564392249721238,0.7020320259765594,0.1185928931371402},
{0.06953992817971984,0.7025534808735477,0.14874973758390225},
{0.07320956569831862,0.7098911348074386,0.12030693970009049},
{0.06116422776177238,0.696887724816633,0.1472664280582722},
{0.1011833243587253,0.15271360535266715,-0.18847001080465356},
{0.1011833243587253,0.14766927222998713,-0.16696769654459126},
{0.07078817772587846,0.14573583635286347,-0.1669077157222434},
{0.07078817772587846,0.15101090651286359,-0.18939025711508997},
{0.0,0.15051376816547582,-0.18969988784666955},
{0.0,0.14531110728650812,-0.16689420652802092},
{-0.07078817772587846,0.14573583635286347,-0.1669077157222434},
{-0.07078817772587846,0.15101090651286359,-0.18939025711508997},
{-0.1011833243587253,0.15271360535266715,-0.18847001080465356},
{-0.1011833243587253,0.14766927222998713,-0.16696769654459126},
{0.1011833243587253,0.16783093405540883,-0.20456756664017964},
{0.07078817772587846,0.1668177444887216,-0.20620920392209732},
{0.0,0.16659403223239724,-0.20657719437271815},
{-0.07078817772587846,0.1668177444887216,-0.20620920392209732},
{-0.1011833243587253,0.16783093405540883,-0.20456756664017964},
{0.1011833243587253,0.18897390374915277,-0.21095255219750011},
{0.07078817772587846,0.18891284219126694,-0.21288598807462372},
{0.0,0.18890041373258243,-0.2133101767732101},
{-0.07078817772587846,0.18891284219126694,-0.21288598807462372},
{-0.1011833243587253,0.18897390374915277,-0.21095255219750011},
{0.1011833243587253,0.21047513727367723,-0.20590713833928234},
{0.07078817772587846,0.2113959239518824,-0.20760983717908574},
{0.0,0.21159586002637543,-0.20799025608839122},
{-0.07078817772587846,0.2113959239518824,-0.20760983717908574},
{-0.1011833243587253,0.21047513727367723,-0.20590713833928234},
{0.1011833243587253,0.22657377384474114,-0.19078926926877163},
{0.07078817772587846,0.22821541112665866,-0.1918154276619124},
{0.0,0.22858232084174182,-0.19203913991823696},
{-0.07078817772587846,0.22821541112665866,-0.1918154276619124},
{-0.1011833243587253,0.22657377384474114,-0.19078926926877163},
{0.1011833243587253,0.23295713829875495,-0.16964792067833448},
{0.07078817772587846,0.23489057417587836,-0.16970790150068235},
{0.0,0.2353153032422337,-0.16972141069490482},
{-0.07078817772587846,0.23489057417587836,-0.16970790150068235},
{-0.1011833243587253,0.23295713829875495,-0.16964792067833448},
{0.1011833243587253,0.22791280517607493,-0.1481456064182722},
{0.07078817772587846,0.22961550401587824,-0.14723778856652048},
{0.0,0.22999646329295262,-0.14703731212425863},
{-0.07078817772587846,0.22961550401587824,-0.14723778856652048},
{-0.1011833243587253,0.22791280517607493,-0.1481456064182722},
{0.1011833243587253,0.212795476473333,-0.13204805058274613},
{0.07078817772587846,0.21382163486647396,-0.13040641330082842},
{0.0,0.21403237829634483,-0.13005085130889232},
{-0.07078817772587846,0.21382163486647396,-0.13040641330082842},
{-0.1011833243587253,0.212795476473333,-0.13204805058274613},
{0.1011833243587253,0.1916525067795893,-0.12566306502542565},
{0.07078817772587846,0.19171356833747488,-0.12372962914830206},
{0.0,0.19172761789946632,-0.12330544044971568},
{-0.07078817772587846,0.19171356833747488,-0.12372962914830206},
{-0.1011833243587253,0.1916525067795893,-0.12566306502542565},
{0.1011833243587253,0.17015181362283358,-0.13070739814810564},
{0.07078817772587846,0.1692429150355442,-0.12900632041160895},
{0.0,0.16904189822551344,-0.12863778959321925},
{-0.07078817772587846,0.1692429150355442,-0.12900632041160895},
{-0.1011833243587253,0.17015181362283358,-0.13070739814810564},
{0.1011833243587253,0.15405263668400093,-0.1458252672186163},
{0.07078817772587846,0.15241153976985192,-0.14481261801969805},
{0.0,0.15205705851345375,-0.1445894461311424},
{-0.07078817772587846,0.15241153976985192,-0.14481261801969805},
{-0.1011833243587253,0.15405263668400093,-0.1458252672186163},
{0.10117035553227172,0.1607045639191578,-0.1499428696176331},
{0.10117035553227172,0.15549217642034996,-0.16721356387944075},
{0.09286976623420133,0.15894728793469565,-0.16732217780098954},
{0.09286976623420133,0.16364416458197298,-0.1517714741475901},
{0.10117035553227172,0.17384360621995737,-0.137605192718112},
{0.09286976623420133,0.17548416276633716,-0.14065340730247597},
{0.10117035553227172,0.19140663944473982,-0.13348596921578856},
{0.09286976623420133,0.1912980255231909,-0.13694270183344084},
{0.10117035553227172,0.20867733370654742,-0.1386999778179031},
{0.09286976623420133,0.20684872917659036,-0.14163957848071823},
{0.10117035553227172,0.22102743906475308,-0.15183793938316478},
{0.09286976623420133,0.21797922448038923,-0.1534779555617758},
{0.10117035553227172,0.2251466625670766,-0.16940205334348507},
{0.09286976623420133,0.22167912259404643,-0.1692934394219362},
{0.10117035553227172,0.21993427506826876,-0.18667274760529268},
{0.09286976623420133,0.2169946744054536,-0.18484414307533564},
{0.10117035553227172,0.20678280430878448,-0.19902285296349845},
{0.09286976623420133,0.20514224776240467,-0.19597355764359664},
{0.10117035553227172,0.18921869034846428,-0.20314207646582186},
{0.09286976623420133,0.18932838500555094,-0.19967345575725384},
{0.10117035553227172,0.1719490768221944,-0.1979280678637074},
{0.09286976623420133,0.17377660061661376,-0.1949884672008923},
{0.10117035553227172,0.1596113999226735,-0.18477767783976098},
{0.09286976623420133,0.16265961450703736,-0.18313766166114998},
{-0.09286976623420133,0.15894728793469565,-0.16732217780098954},
{-0.10117035553227172,0.15549217642034996,-0.16721356387944075},
{-0.10117035553227172,0.1607045639191578,-0.1499428696176331},
{-0.09286976623420133,0.16364416458197298,-0.1517714741475901},
{-0.10117035553227172,0.17384360621995737,-0.137605192718112},
{-0.09286976623420133,0.17548416276633716,-0.14065340730247597},
{-0.10117035553227172,0.19140663944473982,-0.13348596921578856},
{-0.09286976623420133,0.1912980255231909,-0.13694270183344084},
{-0.10117035553227172,0.20867733370654742,-0.1386999778179031},
{-0.09286976623420133,0.20684872917659036,-0.14163957848071823},
{-0.10117035553227172,0.22102743906475308,-0.15183793938316478},
{-0.09286976623420133,0.21797922448038923,-0.1534779555617758},
{-0.10117035553227172,0.2251466625670766,-0.16940205334348507},
{-0.09286976623420133,0.22167912259404643,-0.1692934394219362},
{-0.10117035553227172,0.21993427506826876,-0.18667274760529268},
{-0.09286976623420133,0.2169946744054536,-0.18484414307533564},
{-0.10117035553227172,0.20678280430878448,-0.19902285296349845},
{-0.09286976623420133,0.20514224776240467,-0.19597355764359664},
{-0.10117035553227172,0.18921869034846428,-0.20314207646582186},
{-0.09286976623420133,0.18932838500555094,-0.19967345575725384},
{-0.10117035553227172,0.1719490768221944,-0.1979280678637074},
{-0.09286976623420133,0.17377660061661376,-0.1949884672008923},
{-0.10117035553227172,0.1596113999226735,-0.18477767783976098},
{-0.09286976623420133,0.16265961450703736,-0.18313766166114998},
{0.09207110267176738,0.19031293508048655,-0.16830726824369396},
{-0.09207110267176738,0.19031293508048655,-0.16830726824369396},
{-0.06654412926893916,0.7148873751986865,0.12116072077495223},
{-0.06450964461903128,0.7063209249583176,0.14939223486112416},
{-0.05821814268573048,0.7065003270575921,0.1491490693651192},
{-0.0581684288509917,0.715127298488078,0.12082839459707882},
{-0.053050605711741354,0.7030203586258772,0.14811048251329373},
{-0.051303056347119284,0.7105125577416734,0.11945045678638425},
{-0.05099072377669518,0.6972308583498845,0.14666878130586897},
{-0.04856933580425502,0.7028096151960063,0.11754457966547453},
{-0.05281338426119433,0.6913208560614269,0.14538054454481172},
{-0.05100369260314878,0.6949629348238119,0.11583053310252424},
{-0.057843667821882896,0.6875534119766572,0.14473642616428314},
{-0.05768155749121295,0.689966154064795,0.1149756712921247},
{-0.06414759821386838,0.6873750906129202,0.1449920201189728},
{-0.0660448294504757,0.6897267711431725,0.1153074571022292},
{-0.06931513518785751,0.6908539783090974,0.14603222807410496},
{-0.07291020195434811,0.6943415118895772,0.11668701601623048},
{-0.07137501712290369,0.6966429382173214,0.147461500822845},
{-0.07565635095589707,0.7020320259765594,0.1185928931371402},
{-0.06953992817971984,0.7025534808735477,0.14874973758390225},
{-0.0732225345247722,0.7098911348074386,0.12030693970009049},
{-0.06116422776177238,0.696887724816633,0.1472664280582722},
{0.20131779487801604,0.33913075900327017,0.007116643516410833},
{0.1909324667275301,0.2969247940455796,-0.0014735829057898535},
{0.17835000322869743,0.2901372345004286,-0.0048579062424095225},
{0.18100861265168464,0.3459588461310885,0.003405938047375662},
{0.1898338990533567,0.40726519061608146,0.013756142292883113},
{0.21015550973837283,0.40095045286871794,0.018249840659054144},
{0.15171203369301112,0.6617957015365089,-0.012498166126884298},
{0.09783790750146643,0.6611840052221142,-0.012116126114272116},
{0.10132057777202587,0.683714098978624,-0.014098195090596712},
{0.14416039412263593,0.6728953958774803,-0.008625890694948075},
{0.14802996771572766,0.6715558241783777,-0.007521378975316813},
{0.10572673655963512,0.6798429042822256,0.039212867885754364},
{0.10204413021458275,0.6602167469157834,0.06724120369081993},
{0.13771921031734988,0.6521841800310874,0.06435888201150822},
{0.14138938820371758,0.67177575386032,0.03804243129831732},
{0.10861013897448465,0.6927863334506832,0.009956816509748369},
{0.14433493291199057,0.6850007146363744,0.010163777365237006},
{0.11067002090953082,0.6989513893260614,-0.019210074184389157},
{0.1464693855991449,0.691595362888028,-0.018030451344880814},
{0.11159350942658064,0.6988314276813656,-0.0512528021446116},
{0.14768034976924946,0.6916067106111751,-0.04867740935803499},
{0.11064462362439252,0.6892447630933137,-0.08012465203692981},
{0.14612030802043563,0.6811576190639589,-0.07678571959289773},
{0.10698741456447844,0.6709943820664908,-0.10531551668750236},
{0.14222533714220562,0.6625295209666747,-0.10124006297445978},
{0.10354257003774199,0.6548843977722798,-0.12000865669165778},
{0.1386929530369074,0.6457181393084321,-0.11562357224703561},
{0.1008834202469859,0.6400999356151804,-0.13188215767769387},
{0.13585926445679664,0.6300977282128445,-0.12708477262540113},
{0.10137029160676465,0.6812338109193736,0.02621756341148222},
{0.09632757958739138,0.6525310961387211,0.07024348701482742},
{0.10072130991631595,0.6554598894461582,0.06565468392133002},
{0.10540197553052633,0.6816493537336575,0.023544904426503633},
{0.10520257982380228,0.6949456430552071,-0.01909659695292019},
{0.10898461383833223,0.6942377612779482,-0.01978664659380528},
{0.10586398997293568,0.69448741118718,-0.050790787702202245},
{0.10968384973128861,0.6940805142571985,-0.05064110583021699},
{0.10266825498766205,0.6759657655403692,-0.09255851439931503},
{0.10663779661800024,0.6761867759578492,-0.09067965566685031},
{0.09526629728927212,0.6353128175504966,-0.13120777870210687},
{0.09937309233291086,0.6370182182291446,-0.1282006320681793},
{0.14251281279526032,0.6732223183776648,0.023273099438747016},
{0.13675843642424595,0.647337081144056,0.06272535024612401},
{0.13981637762845014,0.6427163963521935,0.06631771517377012},
{0.1458582296525192,0.6723199042036021,0.025949000630339},
{0.1462575614337362,0.6866061472777758,-0.018622154051826132},
{0.14992719895233497,0.6856599633144321,-0.017743516059595003},
{0.1471934784094707,0.6860468666369646,-0.048340219870241494},
{0.15067614868003013,0.6844138752393492,-0.04785226777492494},
{0.1433487617337484,0.6672896206429135,-0.08689005650355576},
{0.14705622499617016,0.6659565333570375,-0.08877269781040278},
{0.1347109829478845,0.6268933473432685,-0.12333786251584967},
{0.13781917835459637,0.622811949584768,-0.1252323919136125},
{0.09942280616764963,0.6753881123954152,0.023403868438820776},
{0.09475456901212397,0.6459591433333612,0.06778913660848437},
{0.10138272006544935,0.6863462303809351,-0.03843419793076971},
{0.10058405650301538,0.6709327801408362,-0.08939033817025531},
{0.09276979819695487,0.6305159728659728,-0.12490060610350799},
{0.13824336705318274,0.6349572555585608,0.0614408960594491},
{0.1466066390124455,0.663321159748113,-0.08520518980012608},
{0.13570958258481142,0.6160611350479023,-0.12188589432081581},
{0.14887888548066927,0.6763105201769273,-0.03985482479520737},
{0.1435735547256107,0.6625635641361154,0.021858416619767243},
{0.1005467711269613,0.6675900651224218,-0.033997778548102056},
{0.1528484271110075,0.6636983364508052,-0.03622355338820048},
{0.15189954130881939,0.6747029260644504,-0.04052866340302547},
{0.05316300220767252,0.571124151386192,-0.18479010629844567},
{0.0,0.5712143928035982,-0.18510622144325206},
{0.0,0.5827604309216811,-0.16858447690913958},
{0.058605586376031665,0.5815959383797018,-0.16312676244325122},
{0.0,0.6114312640039685,-0.1500141981631279},
{0.05996569205035255,0.6137267462862551,-0.1429175482541663},
{0.0,0.6322024606727092,-0.13403282139791522},
{0.051677531210966875,0.640279878082224,-0.12695508436086517},
{0.07958860721018118,0.6551124329707557,-0.11197230723257943},
{0.09524144037190271,0.6734671049769763,-0.08823341077704075},
{0.1232146586645405,0.5793750268495236,-0.14713457832266064},
{0.10861013897448465,0.5697251392325104,-0.18479659071167248},
{0.12860698863039197,0.5270944452084645,-0.1476149652692126},
{0.16262205894709883,0.5802725777136662,-0.124533696388425},
{0.15367194759081085,0.6221348687703364,-0.11059923273180494},
{0.1514623837837794,0.6628218599296496,-0.08361596819179166},
{0.1121052377037288,0.48490523165160976,-0.18670246783258218},
{0.13019242766434408,0.477777780779821,-0.14800186859174486},
{0.17998515609738833,0.5231762385161717,-0.1268729484599924},
{0.1853526291458704,0.5300907844870141,-0.12223281042844951},
{0.16873848172327605,0.5825080791736048,-0.11855939033546843},
{0.15993805223897334,0.6212600133524877,-0.10028145055243148},
{0.15571940106717233,0.6569113172734232,-0.07774811458930835},
{0.2008060666008679,0.4802564477357645,-0.09294163514746502},
{0.19593789337084927,0.4699597398993782,-0.10230999115688147},
{0.20222885493638115,0.463486674395727,-0.06425296992880385},
{0.1979096953595648,0.4409117301143987,-0.07086274847798664},
{0.19354082194800962,0.4418119828173857,-0.017165322546872176},
{0.18783669977950293,0.4289998630167706,-0.017924539262176447},
{0.18137065905684752,0.37761413040100966,-0.07023592186606283},
{0.17867422389003731,0.35733250693089225,-0.02251658456228725},
{0.1771266105999082,0.3186956710867851,-0.02242688351264988},
{0.17634037549615894,0.3215617817330297,-0.06320465645713817},
{0.16655377483361403,0.3921100361695168,-0.10650864872123318},
{0.157641489221149,0.3203556808728454,-0.09838530005136197},
{0.1192699739515717,0.31797049754092144,-0.12859564090724507},
{0.12527454059958668,0.378033455789676,-0.13997308428143107},
{0.05965389984769734,0.3716549546455823,-0.16251398539331885},
{0.06303660208101032,0.3128213330710748,-0.14622946230975342},
{0.0,0.36956319101217117,-0.16709522333805163},
{0.0,0.3112175215329803,-0.1527727756233615},
{0.1297682389657577,0.42908848333087013,-0.14511090102813076},
{0.11079484586414669,0.39829670675565093,-0.1886537358460795},
{0.0542237441380229,0.39274712976904946,-0.1888282746354341},
{0.0,0.39157128950392345,-0.18886718111479495},
{0.05283824117856372,0.5535162676365909,-0.18516241969121763},
{0.0,0.5537421413639911,-0.18511864990193674},
{0.09282005239946256,0.5515039380652078,-0.18519862433173395},
{0.09511661541728686,0.48461667526301744,-0.18674407615078745},
{0.09470485517738518,0.4150054185378028,-0.18827926098223188},
{0.05333754099702717,0.41039446036578037,-0.18839652078808317},
{0.0,0.4093072404147541,-0.18838787490378076},
{0.0910346772910175,0.41655735477008315,-0.18182078540834107},
{0.05178992770689804,0.4142116182852889,-0.18138524898660782},
{0.0,0.4131357460574094,-0.18143874539572888},
{0.09053537747255405,0.48416006449829685,-0.1797863007584332},
{0.08922498563297195,0.5492560081465847,-0.17883363238186278},
{0.05134034172317337,0.549096599654759,-0.17834189771216397},
{0.0,0.549333821105306,-0.17836189131961322},
{0.0,0.38525222881440885,0.17531313636748033},
{0.0,0.3743438246636279,0.15566212208366892},
{0.005529583379152017,0.3742314281676966,0.15446628821109362},
{0.05583404008934441,0.3745513258868854,0.169779770413946},
{0.04552382305873555,0.36785779033352317,0.14636131204536493},
{0.006852944045187714,0.3747447775481515,0.14970456743154825},
{0.05939182147978092,0.3626978185082985,0.1423020693653894},
{0.10151997347874991,0.35048388582785567,0.1609950115949414},
{0.09384350895375883,0.34041305171886943,0.13101324630530292},
{0.061251767340334155,0.3625854220123675,0.13516219003491584},
{0.1242256867601521,0.32296619756440037,0.1218707640232866},
{0.11870853183968477,0.3238561832797785,0.11918189400524103},
{0.15312293393760862,0.3217038984562505,0.13217503700843758},
{0.13784403527196576,0.31903934498780545,0.11571219256113519},
{0.13849301696241448,0.3142154819148364,0.10608554075818462},
{0.18949670956556325,0.3048703617194828,0.06858834053868723},
{0.16550546136194835,0.3035745598096608,0.07705860531619216},
{0.18123340564354695,0.29500000405275834,0.031106810984487934},
{0.2037640397678256,0.44343200538854755,0.03797110275282255},
{0.19908337415361524,0.4306560902284486,0.0407707481634926},
{0.19953241976957098,0.48581250913559265,0.07996362244179767},
{0.0,0.30413600192154777,-0.14124889258380363},
{0.061725669873659315,0.3073376809522795,-0.1363034467628323},
{0.11151839830670357,0.31096516978490407,-0.1091051158507969},
{0.14337415901888667,0.3134632899805278,-0.08324419516678856},
{0.16385788003457274,0.31626671796558037,-0.0532472995796209},
{0.15864008885807593,0.27561485071124553,-0.0417299009532898},
{0.17796309990616513,0.26339227214650035,-0.005840294846269424},
{0.15991319532160392,0.23256915424068486,-0.0420503390402474},
{0.17820032135671218,0.23018343054099194,-0.004685528924130475},
{0.13652121497369896,0.2771230171542451,-0.07764436397767957},
{0.13795643176789693,0.23394709205137934,-0.07613781863798683},
{0.10641300362613791,0.2760428219842143,-0.10246345560324903},
{0.10621360791941388,0.2351180690065853,-0.10246345560324903},
{0.0601407712074761,0.27340042359429406,-0.1285318775105149},
{0.06314899857694148,0.23421403372921573,-0.12926083363076077},
{0.0,0.2694108883565066,-0.1334886710546331},
{0.0,0.234924617345319,-0.137238283003029},
{0.0,0.12974095039342842,0.14050318506272183},
{0.0,0.08286404644136752,0.13673141803580097},
{0.015777658116337398,0.1301824308606194,0.13551937313015866},
{0.059529074893081485,0.07678274757016884,0.12601862701736175},
{0.05160242009108979,0.014242743468777434,0.12573547430645823},
{0.0,0.012508703298377851,0.1333460139636435},
{0.0,-0.03191276951180203,0.1242013702105516},
{0.04683421489831765,-0.03136591732967539,0.11657840209468162},
{0.0,-0.06485142723286029,0.11089859647577545},
{0.025976019018783995,-0.06115801353242996,0.1084220909909075},
{0.0,-0.0642008244391049,0.08031918443373376},
{0.025913876725360514,-0.06688104857284813,0.07093623849455702},
{0.0,-0.07568255879268869,0.02013464343697677},
{0.0226808563640328,-0.08261547726767353,0.019291129349724125},
{0.014367298239508828,-0.09291975025282449,-0.032025976559386556},
{0.0,-0.09521631327064883,-0.031592601608728885},
{0.07152469899488893,0.13075792253449778,0.12759542016701148},
{0.11221763419965995,0.07161737206725538,0.10945959710719519},
{0.07364672322335858,0.012011024583221131,0.11309302998527769},
{0.05503537652691045,-0.0345340935587351,0.10793521963112876},
{0.06323653815550326,-0.03771577898201727,0.09929365827088259},
{0.034389004812785534,-0.09157369414049499,0.06726606060818932},
{0.0210327346688883,-0.11553306064574487,0.024957966142176703},
{0.028335264697800677,-0.11301116426828935,-0.012875342829576383},
{0.13494820439843153,0.13179434791524783,0.10133732917286177},
{0.13721991049888643,0.10125708455918024,0.09807566931978234},
{0.14173846578242685,0.09250907074846068,0.10066078872619917},
{0.11722306084297913,0.07027023521938804,0.1071414193786149},
{0.08353275155538108,0.010441796582335999,0.11045657564081539},
{0.09341877988740357,0.008872568581450867,0.10782066166412198},
{0.1222284874862983,0.06893606719797432,0.1048097324558121},
{0.1462575614337362,0.08374754774351889,0.10324590813261597},
{0.17281987948177652,0.08929604399458238,0.06675433233104118},
{0.16410752994380448,0.07308284945651164,0.08177601593868772},
{0.18657602177465962,0.03713542399821896,0.05617933509367141},
{0.19622482865613508,0.08472020972753849,0.0463295114021652},
{0.20675983867860628,0.03251095663197425,0.04610850098468517},
{0.19802209185549594,0.020958434100664648,0.04569782148032129},
{0.2033771364452933,0.02919904257638713,-0.035050414961918935},
{0.19240496889778216,0.01831711644628225,-0.03402155472993365},
{0.204063943879565,0.0014571016888384615,0.020058451581561897},
{0.20133022333670075,-0.012688105397652477,-0.004861688816791821},
{0.18489061470346102,-0.02550292703711216,-0.04066375534525043},
{0.16605447501515055,0.009640431181057596,-0.06493329294984873},
{0.15811593212224306,-0.040031254871753116,-0.07262758961121349},
{0.144872058474277,-0.013062580261500093,-0.08914825340978817},
{0.12441319437596034,-0.05485030056606215,-0.0883593164671944},
{0.10344260200049551,-0.026060586574616747,-0.11171887474896541},
{0.0699392599609368,-0.05329782396601298,-0.10175935640037254},
{0.07772866134962794,-0.07963048571227091,-0.07850192762692362},
{0.040206063844992264,-0.07834765262890264,-0.07620644534463712},
{0.04687150027437174,-0.1009409694143737,-0.05360448267486369},
{0.16576753972986474,0.12234385600495842,0.06725255141396683},
{0.16928749537647828,0.10581400595431263,0.0670104666534997},
{0.18615129270830436,0.13546398543384647,0.04480999723601886},
{0.16706550311076215,0.13719802560424604,0.07018350619247954},
{0.18329274721082423,0.14135291337931694,0.04265176836703292},
{0.1939531225556802,0.14307182325218734,-0.0032097845472650248},
{0.1824940836483903,0.13300639282089013,-0.034215546758968686},
{0.17791284570365745,0.1464950530681678,-0.05884226745880979},
{0.17956042703103306,0.07887180936473567,-0.0460150173606655},
{0.19345382273721673,0.08058099261776576,-0.03456624544098468},
{0.1814203728915863,0.030207909200923158,-0.04192551408563154},
{0.15534438583555582,0.04698200548311186,-0.08640102367270142},
{0.11919540319946352,0.030377584680357665,-0.11442773837446028},
{0.07570606479063587,0.017412000433374975,-0.13319146878173815},
{0.060003517794175544,-0.029373581365741697,-0.11777207449618136},
{0.04546114039754316,-0.060727340420616824,-0.0989283696591063},
{0.0,-0.06201773865274966,-0.1002614569449822},
{0.0,-0.08051452738219102,-0.07839979811860154},
{0.15110087774638542,0.08850494558091307,-0.08960378343897073},
{0.1508382590107001,0.14591199624552473,-0.09290543050694873},
{0.11266722018338461,0.08885186168854678,-0.11553981524285614},
{0.11410243697758259,0.1496216209790223,-0.11753701451670993},
{0.07149984207751954,0.08959054442863268,-0.13216152781421509},
{0.06789234685234424,0.1485316991891511,-0.1307662982349157},
{0.0,0.1483171731848979,-0.13958888279774334},
{0.0,0.09068911210280602,-0.13656660586628652},
{0.0,0.016373413581549503,-0.13721720866004192},
{0.0,-0.032775196470966134,-0.11873825206697428},
{0.02445326264602426,-0.11818302418442966,-0.013711832135833327},
{0.07988797095415169,-0.21238047402681787,-0.06524076221035276},
{0.04814514710566865,-0.21925233094391702,0.004237023675943609},
{0.031268380947388985,-0.160832090712618,-0.004166235498217733},
{0.06694346105015613,-0.14590875403891124,-0.07377208854574335},
{0.0456735049307208,-0.10667265033909426,-0.059969474624734856},
{0.07887694285854009,-0.086783333869198,-0.08754444187169347},
{0.11939479890618757,-0.06436725771192615,-0.10548303069586129},
{0.14027839207085951,-0.05460443323121279,-0.10479027921613172},
{0.18908494932566156,-0.03722512504785627,-0.05961445300056766},
{0.20392669046626447,-0.024836113210289786,-0.019865540288064656},
{0.20694734629441452,-0.005362339554677504,0.020810103148101566},
{0.20202945922965712,0.015612035395169636,0.048863295870536526},
{0.1912691158475547,0.04034737001655968,0.06975391381620416},
{0.16736540722250154,0.07400039392810355,0.09111411135304577},
{0.15222376197015927,0.0063576969849910665,0.12316170262318832},
{0.12576087159159652,-0.0016013798831346069,0.12384796968969111},
{0.13092894893335455,-0.07776567654179753,0.13591978564691343},
{0.07765355022975087,-0.10795602379023138,0.1146633387217006},
{0.04031846034092343,-0.143229070272937,0.0699749242336842},
{0.13779432143722695,-0.1933087339912671,-0.09778495146011425},
{0.12709666071631692,-0.11743407445673444,-0.10515232562129459},
{0.16334615175742456,-0.18833681014961973,-0.09735427834830107},
{0.15204922318080463,-0.11121768364331075,-0.10603312508460133},
{0.20594874665748764,-0.10288197044026193,-0.05694071328005128},
{0.21328856206245408,-0.18054038397993283,-0.05232867437249118},
{0.2323365259161733,-0.17820383374720994,0.020094656222078185},
{0.22419804694877288,-0.09765769485053831,0.019113888721524985},
{0.22162643673657856,-0.16969033954819307,0.07601407441890876},
{0.21373760767840985,-0.08101977124611232,0.07406550824425595},
{0.20658529988925164,-0.0271532102033322,0.06858942127422503},
{0.19547587892843993,-0.16694310981110624,0.11696530541721391},
{0.1826686224377449,-0.07156711786474751,0.1169788146114364},
{0.17660245386407536,0.0001802126509282079,0.10622009233264067},
{0.16420695761328202,-0.16599854695106941,0.13987797955410475},
{0.1570670782828085,-0.07175300437724899,0.13491848417114202},
{0.13753224306931056,-0.17098992403239716,0.13721180498235294},
{0.08820152907867566,-0.18553716473894963,0.11660055717320651},
{0.056732671689024836,-0.2042149766709724,0.0742389662980728},
{0.0,0.6646396571042286,0.07246007560285454},
{0.0,0.6296670551010313,0.07111077728391166},
{0.03639917291309293,0.6343255656367167,0.06754326927363494},
{0.03335311979980455,0.6669097421013769,0.0699911352667512},
{0.06448478770166187,0.6326466429787448,0.047114665770376665},
{0.0601531996661608,0.6716385004470194,0.05591833746129278},
{0.08445678044019979,0.6499638088686781,0.01474879788435211},
{0.08139829886822672,0.6833569158833812,0.025452402650720053},
{0.09164637360541211,0.6942615374597798,-0.01781430423732088},
{0.07548181216654243,0.7055844036893071,-0.06528885494178484},
{0.08187274176932079,0.6754205344615494,-0.07614376268344474},
{0.0930070196475019,0.6694899981978736,-0.07806747194072815},
{0.07439567295105376,0.6544834448877562,-0.10694418514296646},
{0.05016720329689184,0.6410061323636254,-0.11930942079870138},
{0.041030124692564514,0.6709603388970501,-0.09687227029844243},
{0.0,0.6317263966683084,-0.12492546302087738},
{0.0,0.6654642583195698,-0.10286873142992391},
{0.032379377080247046,0.7080133568105117,-0.08534730652334672},
{0.0,0.7067289026238368,-0.0900782263400648},
{0.0,0.7509347686942256,-0.07667926714242447},
{0.03040757509153155,0.7503965623964015,-0.07312797016521475},
{0.0696771815930204,0.7471338218077842,-0.052556709570966906},
{0.08504307946945612,0.7344227507799533,-0.0031897909398157314},
{0.07418330841787611,0.720926525383911,0.033101848787266124},
{0.053974094228791174,0.7137266652310896,0.059540962983997275},
{0.026737397205163865,0.7073281704795468,0.07372993985976917},
{0.0,0.7067802375618822,0.07815447115152102},
{0.0,0.6378503845932503,0.0867279461728858},
{0.04026874650618465,0.6420247256080016,0.08007709967326662},
{0.06724336516189554,0.647395981230866,0.0709535302631618},
{0.0896740312489277,0.6598860418412168,0.054326954381882765},
{0.08932495367021842,0.6467859060197781,0.02766304719328928},
{0.29954260570201474,0.3165374422177991,-0.07919467910665319},
{0.27297974728620555,0.3081855179816833,-0.04768637486987269},
{0.23040200930351187,0.3677918654657173,-0.053329435480493674},
{0.2551049218587679,0.38491125675223314,-0.08837282566141691},
{0.23468334313650527,0.4292792331532918,-0.08771898066104811},
{0.20642318955858166,0.4053879529869233,-0.05156351361172901},
{0.20848253112585896,0.4404848395769677,-0.05266586386028468},
{0.22300005160512193,0.46406702937952543,-0.0907099162619087},
{0.21245207275619715,0.47982469388841364,-0.09119300504730514},
{0.21513607946432264,0.5344542542208802,-0.11532636997414071},
{0.21174040840455607,0.5816921238425661,-0.10440823920351952},
{0.2092563377709235,0.6174417746974414,-0.08747311332619867},
{0.19827174176472767,0.6521193358988194,-0.053381851154076954},
{0.18763676370501,0.6480649565287641,0.004405618419840358},
{0.1538464863801655,0.6567702812857403,0.011588186804056972},
{0.1544333257771907,0.635899656947522,0.037732800566737716},
{0.1850030111993922,0.6269695391986833,0.03255607734067729},
{0.16144838015304838,0.6031231095571336,0.05744487640843482},
{0.1859891823776344,0.5986132001578955,0.051818026830880826},
{0.17589078951243428,0.5543041238436468,0.07407793670294065},
{0.1916435907114023,0.554174435579111,0.06678837550048188},
{0.2077211529394791,0.48754763004152996,0.07277835221873655},
{0.20843281729112018,0.4538000417704287,0.034485730643418595},
{0.20448813257815135,0.4431688462850933,-0.015720919500602917},
{0.3242455182572707,0.3247661626026058,-0.09675014718267107},
{0.284176707825579,0.4072068308970403,-0.10859338757364875},
{0.2569270419754981,0.47100481116443044,-0.10839993591238262},
{0.24362102603410857,0.49818260810124776,-0.10272175139678315},
{0.22982759836517136,0.5263357688609291,-0.10580508988612561},
{0.23935212065979986,0.5731127047757435,-0.09643295130232686},
{0.24475687908433602,0.5995982906005999,-0.07747090592386272},
{0.24455694300984307,0.6231599464279395,-0.04893840699041361},
{0.23911489920925283,0.6301042126260712,-0.008792323967769227},
{0.233422665131662,0.6009610981137654,0.031537484096301104},
{0.24585544675850937,0.5536783779672609,0.045036411331187895},
{0.22167669093908624,0.4974390620512416,0.06363749104002693},
{0.2339468218674948,0.48625831254493496,0.0571703695818337},
{0.22363660483688594,0.4602758091129244,0.03787978059987847},
{0.2287414591496827,0.416309866331927,0.03172985502202944},
{0.2063480784387046,0.4005095127692957,-0.004915185225912906},
{0.3425693893006641,0.332819803830289,-0.09797732238584259},
{0.3022633574184254,0.4187977195399419,-0.10810921805271449},
{0.2730921437821367,0.477816146891413,-0.10782714607734878},
{0.27952035876096915,0.5217712823170323,-0.08654043855707758},
{0.2631185758715524,0.5547596538728294,-0.08751418127663507},
{0.2746900112747735,0.5724188725604761,-0.0660518542314714},
{0.28040656190196483,0.5873476129118718,-0.038858926997124975},
{0.2814927011174535,0.588996815342554,-0.010623089968801869},
{0.2708328661403665,0.5686465651657863,0.021374247098832993},
{0.2611586619737527,0.5074747722552493,0.04120520384968806},
{0.2556290785946007,0.4738217483437052,0.057236294449639485},
{0.24258460065335868,0.43952892899378393,0.04452576378957755},
{0.255217318354699,0.38010468544786896,0.038487694339890785},
{0.23296065068925262,0.36094378473044975,-0.0005998082234788193},
{0.37508656016198066,0.34622686854446266,-0.06755083442239955},
{0.3424072789699942,0.4392338881919646,-0.06861211672051883},
{0.31370996786703065,0.4950036245168099,-0.06836624938566939},
{0.29620961730344053,0.5295152928131357,-0.06224334219626536},
{0.3028501968154506,0.5361072392259447,-0.019352190907609812},
{0.2871725067363597,0.5260147904062026,0.019142528213276673},
{0.31227475107283265,0.4960232984967239,0.023718362480320478},
{0.2730046042035749,0.48385259523779306,0.05693314813128667},
{0.286248477851541,0.4076034608394128,0.062300621179768735},
{0.32549376780342937,0.3309647212796557,0.05527908239068428},
{0.29750758068433797,0.3200152491784384,0.03625327361548997},
{0.27392809272062474,0.30894581543252536,0.005929455528137894},
{0.3901276970093076,0.35684833740995797,-0.01725664469981625},
{0.35336701805882065,0.4480878140853885,-0.017361476046982818},
{0.3269538415149967,0.499906921651807,-0.01883938189492387},
{0.3398734945016229,0.4395500033367711,0.025330279534948687},
{0.3049473641265509,0.42206478307071027,0.059061656772983126},
{0.34349341818548285,0.3382721146184883,0.05411350911316733},
{0.3728769963549492,0.3503077259351942,0.02616028442797884},
{0.3701184188947156,0.3433002367081012,0.01738849443542781},
{0.3476374986051757,0.33054647662652736,0.032813292398673616},
{0.3284765978877564,0.3227273550105466,0.03634351503289624},
{0.3031122751833671,0.3133109062696981,0.02122834780123004},
{0.2851374817186829,0.30595974314158475,-0.0024700210716411494},
{0.2817050656506312,0.3029752919539511,-0.04380059024371397},
{0.3447789531076956,0.33182876934212663,-0.07943784460265813},
{0.31505818545043573,0.31635263644083544,-0.08271085217888444},
{0.36420193219303126,0.27024845839830136,0.03631811774775794},
{0.33132271492655185,0.258230679217969,0.03377298555623972},
{0.36888259780724164,0.2692622872200593,0.04746374334908596},
{0.40413348921142245,0.29035824491790885,0.030828521583504517},
{0.40229840026823854,0.33792141593647224,-0.005172400283909228},
{0.4107238145209248,0.31868432336363806,0.0026753608238230843},
{0.4089762651563027,0.346419239470191,-0.019675871201180813},
{0.39849096896857034,0.34961497445546474,-0.03165258243107677},
{0.41464364231652423,0.3571666140258398,-0.027006500354075983},
{0.4181511695044531,0.35296633535818156,-0.047806336514568455},
{0.3952957743510656,0.34311380982783085,-0.048958400597862904},
{0.4103369111983925,0.34608853439562437,-0.051673208268815676},
{0.39057728299303224,0.32845093041873386,-0.07446105745109065},
{0.38298781767883405,0.33143051829644743,-0.06825979693519614},
{0.3577980337637993,0.3115671394794584,-0.08598277901957294},
{0.36002002602951544,0.3071269375224084,-0.09214891563048896},
{0.3260303529979469,0.29110557354229716,-0.08732559292528902},
{0.33061159094267967,0.28711009425905193,-0.09642916872794455},
{0.3582103343714699,0.3034410889707426,-0.09973946168022495},
{0.2721308295212639,0.28119955160282534,-0.009085743666281836},
{0.29861857681719606,0.27035220900993023,0.008190354273214805},
{0.2814429872827147,0.28685774251097573,-0.009849283323737305},
{0.2697591553835625,0.27701440323269616,-0.03019737202942951},
{0.2785720133265499,0.2787841076758431,-0.036672058636387346},
{0.29029313060175627,0.29170484139800706,-0.05551035979577341},
{0.32053805499484894,0.3037291049915662,-0.08502416659754464},
{0.3512822792064051,0.3216979544107925,-0.08271625585657344},
{0.3790436733336342,0.3388351778336819,-0.06790531567879783},
{0.38292567538541056,0.32011629795122265,0.02158877310308623},
{0.3489857161885808,0.3008570502998636,0.03227130352646708},
{0.3167057667778113,0.28815084258195284,0.0229921081989191},
{0.3013895827361144,0.27683932407557266,0.007574875384437892},
{0.29889308364379713,0.28043439084206323,-0.06722012934783285},
{0.3544029030718016,0.19090139558081842,-0.03511039578426682},
{0.3388122122035036,0.1890387478814207,-0.007314418119828176},
{0.3955827096363514,0.13288751191173212,-0.010182690237148503},
{0.3841236707290615,0.13055096167900923,0.012444129349994311},
{0.4302343331848223,0.08206105993678242,0.008222776339348797},
{0.41778912309929017,0.08076579839472965,0.029356559781021366},
{0.3769713629399033,0.12656142644122179,0.019825012705397167},
{0.4099251509584908,0.07816176611640116,0.03552053492086178},
{0.3780196764115689,0.12900442912441795,0.03595877318143955},
{0.4089762651563027,0.08309748531753224,0.05428534606367748},
{0.41705260183027965,0.08858600074624785,0.05885901885964569},
{0.3851222703659884,0.13509545461545686,0.039440362716461196},
{0.39472136341272507,0.14950165933432633,0.05517208957244211},
{0.42796208671659847,0.10208817018774821,0.07603136618751356},
{0.451329750514903,0.1193340075321863,0.0831453078650799},
{0.42200831463886007,0.1683005136465829,0.06679540028147757},
{0.4838215240910812,0.13211262453112968,0.06971878991122568},
{0.45815729727495236,0.18661735990898043,0.05117120661150773},
{0.5044424985200678,0.13229743030809357,0.044198300921624245},
{0.47970230058875774,0.1882876366826498,0.024830439348716343},
{0.5114953786397485,0.13655012464933505,0.04003044432009981},
{0.4860310878981126,0.1918437969697797,0.021147292635895064},
{0.48821525442000574,0.18535398006529263,0.005003265172243575},
{0.5124064386981135,0.13307880210192252,0.023342806880935096},
{0.4807506140604234,0.17987411052087943,0.0014784462157099486},
{0.5070638225670009,0.12677973501985712,0.0220048562851391},
{0.49092411804550057,0.11492136433135042,0.00033502801671789656},
{0.4661839201141906,0.16932775277526135,-0.01738525222881441},
{0.4746466197429308,0.1028635979361194,-0.013786402887941505},
{0.44777196912446643,0.15494532423822346,-0.03234425317526856},
{0.4721755179357519,0.09821481402027415,-0.020646912081893818},
{0.4442395850191682,0.15026465862401298,-0.03983969449767818},
{0.44738506580193416,0.08513575254182247,-0.015964625364376744},
{0.41569195578818985,0.13868187549764507,-0.036816877198452495},
{0.41253404654673925,0.13848247979092101,-0.0272685787219924},
{0.444726456378947,0.0866860676707961,-0.007557583615833101},
{0.376983791398588,0.19730583437781937,-0.051858014045779416},
{0.38062857199981737,0.19768193034497367,-0.06057468652590267},
{0.41048659307037777,0.21093661134831762,-0.06437563341234412},
{0.41404437446081427,0.2171557040005857,-0.05646518964341942},
{0.4335294958395735,0.2313257680044463,-0.04348609620221427},
{0.4535387739541655,0.2455158256157558,-0.019940111040172834},
{0.4610282712311172,0.2490071417706178,-0.01654119777379287},
{0.459405546821111,0.2547242327655781,0.0040608637832822625},
{0.4530519025943867,0.2504801843086388,0.008502146475870012},
{0.43430330248463805,0.24109831910499963,0.03940631954702051},
{0.394684078036671,0.22250048160277403,0.057649675792847854},
{0.35962069424829846,0.2029191747611508,0.044540353719337844},
{0.34301897528438885,0.19507033291788073,0.0252913730555879},
{0.33527982809820533,0.18797800595107034,0.01974503827559999},
{0.330960668521389,0.1874095390581877,-0.0023176373608113964},
{0.49279649236473855,0.12217526126106162,0.04000828924157492},
{0.47795475122413567,0.12238114138101269,0.06286854770488247},
{0.4573834906298878,0.11162458057329246,0.07348353215715084},
{0.44431415577127636,0.10131328280714577,0.06449127211488867},
{0.4317819464749514,0.09184117618610048,0.05197527385163068},
{0.43054612538747744,0.08622675506723136,0.03308131481204793},
{0.4425293210306002,0.08235718147413966,0.005279393102151392},
{0.48544424850108736,0.10930045879925432,0.007055581958525152},
{0.47210040681587484,0.09719405930482224,-0.009811997947683216},
{0.46051654295396904,0.08913015108952997,-0.008496202430412117},
{0.4415555783110427,0.09843204186337177,0.07333655212401008},
{0.4640618958857209,0.11427724595082177,0.07883371343702811},
{0.47666921630192294,0.10431880833776656,0.08981182502999717},
{0.4419176247162056,0.09581612149412774,0.08505875013475421},
{0.4693045439795871,0.09391240584429365,0.10518690915850419},
{0.44058237595925415,0.08976454285021851,0.10433042624479795},
{0.46345019957132627,0.07943865515431164,0.12070356964246295},
{0.43849763710683853,0.08007304691499995,0.12299418861482937},
{0.4537884238633972,0.06444453030287896,0.13517353775806276},
{0.4356763769854125,0.07025132234747654,0.13716425261868978},
{0.45109252906435593,0.05579216158725471,0.15431660633910832},
{0.43341709934364225,0.06180483375180324,0.15610036034424668},
{0.44934497969973386,0.04966817366231285,0.1669104175610879},
{0.43210670750406016,0.055887806682350036,0.16850017953719124},
{0.4488332514225857,0.045642433784009104,0.17632794703747426},
{0.43284322877307063,0.049595764381280355,0.18129879014358383},
{0.43506468067101794,0.0439246046466765,0.19120589281859343},
{0.44387753861400536,0.041008780165693016,0.1898355201566634},
{0.43166954997902024,0.03360952430614759,0.19083033721920806},
{0.4408941681619093,0.031790646396030756,0.18976311087563083},
{0.44818372936436807,0.031700945346393325,0.17697854983122965},
{0.45070562574182366,0.03598119844384896,0.16255613407929304},
{0.45250288894118446,0.04048840600424245,0.14940196148096432},
{0.45524903794273347,0.04752615582639399,0.12972338844093903},
{0.45984270434615093,0.048248627533413024,0.12054632262171312},
{0.4788782397411855,0.061099653813388895,0.1189560202778409},
{0.46804386597474373,0.043208076985115355,0.11831946704607689},
{0.49031242173110595,0.04901649013301975,0.11873663096366756},
{0.47502109460677844,0.03367274733510883,0.11690802643371051},
{0.49672820825125374,0.031463723895846375,0.12370801443754605},
{0.48586843719967376,0.020822261422901934,0.12049660878697432},
{0.5011970497000554,0.01755033458221335,0.12724310038168876},
{0.5150899050384702,0.020395370885471026,0.12162111411405488},
{0.5232537812910089,-0.0034813193511371403,0.13517191665475609},
{0.5111830460693243,-0.00747571789884476,0.14041726658746673},
{0.5261620406232278,-0.011813249979803743,0.13986663183095782},
{0.5145657483026372,-0.01579251822998209,0.14478722073455974},
{0.5331149527056619,-0.030584545535846195,0.1501984635723227},
{0.5230041313817771,-0.035513780323750535,0.15509905886847528},
{0.5361728939098661,-0.03898618360670078,0.1546710875955066},
{0.526748880020253,-0.04391974133675632,0.15904752615582643},
{0.535898387083265,-0.06336703697169253,0.16607608972590657},
{0.5428885845417533,-0.0589533130353187,0.16466464911354017},
{0.5401672924575737,-0.06723552982924641,0.16342612618722177},
{0.5482312006728659,-0.06195289452048162,0.15385567263223676},
{0.5441616910052812,-0.06914410878900068,0.1563300166460291},
{0.544374055538459,-0.06677243465129931,0.14874919721613333},
{0.542501681219221,-0.04276011210469729,0.1406896119429923},
{0.5377583329438183,-0.050376595807340455,0.13398526903425204},
{0.5398555002549186,-0.034449255819017845,0.13610729326272167},
{0.535099723520831,-0.04259746140625838,0.12874478241146142},
{0.5292329506538855,-0.02682088402545878,0.1193207685218483},
{0.5335267129455636,-0.015611495027400661,0.12669895003840664},
{0.5303936606214824,-0.007154739444118267,0.12241113179218643},
{0.5250888702341927,-0.019079575368199826,0.11451852015963546},
{0.5139291950708733,-0.0005752214899937678,0.1028476570869368},
{0.5208323933185687,0.017674078801291432,0.10971789290072931},
{0.5270984979667311,0.010600124338623704,0.09246827298190875},
{0.514578176761322,-0.0014176548417086591,0.09986428663484082},
{0.5387693610394299,-0.023977468825507914,0.10170910219786485},
{0.5275351151240023,-0.02699434207927564,0.10942177136337221},
{0.5422520313099893,-0.032880027818132714,0.10453630636474878},
{0.5317294497462028,-0.03555646937749359,0.1123889307824012},
{0.5532739126922392,-0.057063646947475934,0.11392573671715232},
{0.5436499627281332,-0.06073598630491923,0.11987356474943282},
{0.556744154504114,-0.06592351688635768,0.11692639893785312},
{0.5477567577717719,-0.0694575220949626,0.12248246033768123},
{0.5575682153516862,-0.09023358207362338,0.12861779598576997},
{0.5651447118394308,-0.09092092987566405,0.12463042221905807},
{0.5600771429026881,-0.09913181812409697,0.125213479041701},
{0.5621364844699653,-0.10138785355925381,0.11543120132130727},
{0.5670797688198611,-0.09299432100493266,0.11429264643223531},
{0.562548785077636,-0.0935163162696899,0.10800276560224123},
{0.5604889031425898,-0.06922300248326005,0.10571592920425713},
{0.5538980374653185,-0.0760467666689271,0.09798812974122058},
{0.5572310258638927,-0.06043500145764194,0.10238077933460735},
{0.5497042432108868,-0.06800717500323537,0.09391375676371583},
{0.5377210475677642,-0.0461736153008375,0.08487286362225267},
{0.5459092403699033,-0.036308661311802194,0.09280546246970227},
{0.5423519993472357,-0.027729782612748406,0.08918932136022456},
{0.5334018879909478,-0.037837902097788666,0.081488540285633},
{0.520307696214967,-0.01147606049201015,0.0703067100437887},
{0.5297073935549796,0.0072601111590538244,0.07356458732248582},
{0.5200083324709964,-0.011958068541868865,0.06568980782630851},
{0.5302564072081819,0.0009161935521697101,0.05573082984548453},
{0.5389568686552381,-0.032198624061550045,0.06462582368934473},
{0.5291826964513778,-0.03632379160933134,0.07204939609849068},
{0.5422644597686739,-0.04130706317412566,0.06688564169888385},
{0.532952842374992,-0.04528362958545949,0.07425355622783311},
{0.5533117384360622,-0.0648541290717048,0.07224663033413913},
{0.5431884886534927,-0.06720580960195696,0.07927681500752598},
{0.5567690114214834,-0.07398364252726759,0.07423140114930821},
{0.5468954115481456,-0.07629155326823873,0.08107299747134902},
{0.5527870413324605,-0.09307429543472985,0.08391046862584206},
{0.5617620096061179,-0.09093227759881085,0.07773622649839254},
{0.5577054687649867,-0.10278578497739775,0.07967020274328504},
{0.5622240240485271,-0.09281708037673357,0.06663058811196312},
{0.5577930083435485,-0.10549951191281265,0.07082600346970144},
{0.5565944726321288,-0.09975594289717629,0.06321438307697835},
{0.558491703868736,-0.07658389223121362,0.06219957240698447},
{0.5471326329986925,-0.08385345982622307,0.05620797458542309},
{0.5552965092512313,-0.06747923569302022,0.05984032672796778},
{0.5427264742110833,-0.07552531177193882,0.05297495422409538},
{0.5319542427380651,-0.05201336977933803,0.04488024504597585},
{0.5440368660506655,-0.044064559898821444,0.05383521971218391},
{0.5403299431560126,-0.03515065318304984,0.05135601238847147},
{0.528820650046215,-0.04292708574528728,0.04234592020983561},
{0.5217434533769338,-0.014869029712932295,0.03585772440865529},
{0.5283467475128898,-0.0015116788334971745,0.04124519106458664},
{0.5189973043753848,-0.016410698957603522,0.033670856047917655},
{0.5277971934919187,-0.004254045260663928,0.023922081129195718},
{0.5340508696813965,-0.034027228591506996,0.028292035276288686},
{0.5241524128906893,-0.038317208308802864,0.03761878296749985},
{0.5367348763895219,-0.04349501227040108,0.02980128245482593},
{0.5269985299294847,-0.04776661948355431,0.03892701333600635},
{0.5428885845417533,-0.060687353205718164,0.03273818127879654},
{0.5337017921026872,-0.06405654624480864,0.041574815403615545},
{0.5462340013990121,-0.06996654853326624,0.034340912081353446},
{0.5372466046666701,-0.07333952414673894,0.04264042064388602},
{0.5418278426114029,-0.08593171426541185,0.0437103488263077},
{0.5508898100958531,-0.0828959281397325,0.03660937597519496},
{0.5483187402514277,-0.09400048579062416,0.03933012769160563},
{0.5500538611573651,-0.08494932566155189,0.026494772076927835},
{0.5481685180116735,-0.09629110476299062,0.030809608711593023},
{0.5436748196455025,-0.0901184837388477,0.022948338409638214},
{0.5462215729403275,-0.07326333229132409,0.02319312500894984},
{0.5391065505272233,-0.07786672531458176,0.01820499013423546},
{0.536297718864482,-0.09398535549309502,0.028638951383922383},
{0.5368094471416301,-0.09243287889304572,0.03913073198488159},
{0.5292702360299396,-0.0806642092541762,0.03767498121546544},
{0.5243772058825517,-0.07207398283197561,0.03644294270237381},
{0.5156767444354954,-0.05492649242147712,0.03364437802724156},
{0.511233300271832,-0.04610660969749391,0.032180521741291906},
{0.5009846851668778,-0.025821203652994135,0.028721627652564058},
{0.5049666552559006,-0.021176202311531125,0.03981483758030878},
{0.5180986727757044,-0.05138654316741419,0.04975544305699015},
{0.5221800705342049,-0.06006701100702119,0.05250159205853912},
{0.5329652708336767,-0.08134345153968332,0.058976278665496956},
{0.5377583329438183,-0.08965052525098055,0.06170999920836122},
{0.5457098446631794,-0.1018396010140541,0.06606536342569388},
{0.544449166658336,-0.09845527767743448,0.07957131544157638},
{0.5358362447898415,-0.0853951290708943,0.07631343816287928},
{0.5309680715598228,-0.07691459730578022,0.07433623249647478},
{0.521019360566608,-0.056895052203579134,0.0699608746716928},
{0.5166007733203141,-0.0482632174631732,0.06764161620757471},
{0.5009473997908237,-0.018566225987744978,0.05810412508649262},
{0.5014715565266565,-0.011752188421918046,0.0722639221027439},
{0.5206448857027605,-0.04366090517545324,0.08656637620998477},
{0.5251012986928774,-0.05185342091974376,0.09014631267894617},
{0.5373590011626013,-0.07696809371490135,0.1008763954659902},
{0.5419650960247034,-0.08502173494258451,0.1045011824597703},
{0.5508028108850603,-0.0983590922145703,0.11085266521541896},
{0.5497291001282563,-0.09612359075463166,0.12400791854928546},
{0.5390314394073463,-0.08045346582430532,0.11951908349303453},
{0.5340135843053424,-0.07233714193542978,0.1166794508674659},
{0.5205076322894598,-0.0480135675539415,0.10659834977087056},
{0.5159263943447271,-0.039748102160849626,0.10337937897153425},
{0.49761441139224943,-0.0064322677370991085,0.09132971809283681},
{0.49335793447662546,-0.0022692744454948116,0.10457359174080287},
{0.5083747547743519,-0.025199780718759335,0.11887010180258584},
{0.5129808496364541,-0.03273034594614741,0.12362695927221107},
{0.5216807707157415,-0.05031823608829927,0.1350325017703799},
{0.5255881700526561,-0.0575840211089265,0.14028109390970403},
{0.5337266490200565,-0.06873451002017458,0.15027195358889306},
{0.5290454430380773,-0.0658910948202236,0.16007476528450498},
{0.5200456178470505,-0.05317137790809038,0.15313049908637322},
{0.515576776398249,-0.045317672754900146,0.1491128647246029},
{0.5062278736285128,-0.026778735339484584,0.13977585004578266},
{0.5022956173742288,-0.018683485793596195,0.13547398223757107},
{0.4912110533307864,0.004439931773165537,0.12295906470985088},
{0.478416765666545,0.012094241219631699,0.10703280545706603},
{0.4504057216300842,0.03066235849456785,0.09779467807995444},
{0.4470981305166484,0.03953357615659652,0.11064138141777913},
{0.44471402792026227,0.03812537775084349,0.1258478708023894},
{0.4420673065881909,0.031293508048642886,0.1453443399042955},
{0.4403700114260765,0.02697975214951546,0.15829371311821114},
{0.4382977010323456,0.025636938243799454,0.17198555164659515},
{0.424679352520532,0.031568555243012955,0.1731478827174987},
{0.4249414308884484,0.039579507416952944,0.18368667531435223},
{0.4221331395934759,0.04789522701255257,0.1649418577789858},
{0.42280697820129404,0.05280230672193192,0.15339798113197864},
{0.42442970261130025,0.060240469060838166,0.13531835632012792},
{0.4255655556615277,0.06692643946543582,0.12037178383235846},
{0.4254785564507348,0.07091597470322338,0.10302489771513594},
{0.4258654597732671,0.07515461948247366,0.08491987561814696},
{0.4292854473826342,0.08417714011979407,0.05647491626325961},
{0.4307460614619704,0.0710840290793512,0.026501796857923532},
{0.4448885667096169,0.06472173896832456,0.0004998401862323463},
{0.46483570253078543,0.0645499020178144,-0.018127717543282785},
{0.4601669250074909,0.0788447909762905,-0.015491803566589385},
{0.4782044011333674,0.09026114082983752,-0.01821039381192446},
{0.49103651454143177,0.09772091787949978,-0.018082867018464097},
{0.49701568390430845,0.10818946266639623,0.00946238000120502},
{0.49547995870509515,0.11855641831273946,0.04446794443830526},
{0.4846704418560228,0.12320736369966036,0.07405686235995357},
{0.4977646336320036,0.08702812046850976,0.10706414678766223},
{0.4851573132158015,0.08226748042450222,0.10900028450363033},
{0.5004356715136755,0.05980385190356714,0.10870686480511771},
{0.5137919416575727,0.04021497991317919,0.10771042663926643},
{0.4995494683726798,0.07698106254135507,-0.015557728434395167},
{0.5201952997190358,0.06784992798248561,0.021732510929613584},
{0.5061403340499511,0.11363204683475542,0.01572362133944741},
{0.5044424985200678,0.12026884377238314,0.038981050112896334},
{0.5169876766428464,0.08130994873801177,0.06380824725499928},
{0.5230289882991466,0.06562955682007623,0.07550342687729841},
{0.5229668460057231,0.050093443096437075,0.10612660870862099},
{0.4908614353843082,0.07267919473314355,-0.01653525372833497},
{0.5124064386981135,0.049481746782042514,-0.007200940888359211},
{0.5258378199618878,0.04948552935642474,0.022333940256399103},
{0.5290702999554467,0.07103809781899466,0.029025854706454666},
{0.5269234188096077,0.08083064252699758,0.05686722326348089},
{0.532915016631169,0.06247002647531893,0.07471557067024247},
{0.5371590650881083,0.029427618142631794,0.07877643445352472},
{0.4799892358740436,0.07043126481452014,-0.019335979874542816},
{0.4901378829417513,0.0455424657467627,-0.01731770625770193},
{0.5024328707875293,0.04445416506019833,-0.009815780522065515},
{0.522729624555176,0.013867187869392108,0.011164538473239501},
{0.5312922922211628,0.022265043365864465,0.011750297134726922},
{0.5356487371740333,0.05088508187787536,0.02910961171063414},
{0.5270233868468541,0.021150805026393,0.08124645552516586},
{0.5394561684737015,0.022176423051764864,0.04113765787857558},
{0.5290832687819003,0.012514106976066886,0.0440275447066519},
{0.500572924926976,0.02753633095148234,-0.010446389708371622},
{0.5142663845586668,0.004838182818844709,-0.0011401759923786543},
{0.5243772058825517,-0.007007759410977484,0.006612480388027287},
{0.4833719381073565,0.016222650974026493,-0.008466482203122624},
{0.4932585068071479,-0.00529857615794729,-0.00019777460341734168},
{0.5125312636527295,-0.014410797844905256,0.001125045694849456},
{0.5321536384447891,-0.03733373896940508,0.01405928861123592},
{0.47301146687423995,0.03745261987856323,-0.015215675636681572},
{0.46301304204628635,0.021188090402447023,0.016442310472084193},
{0.478416765666545,0.0010874901349110242,0.027776524424758246},
{0.4946191528492377,-0.020432656261524927,0.01776188856373759},
{0.49992394323652734,-0.01821660804126675,0.006814577933595824},
{0.5126436601486606,-0.04607148579251543,0.014596414173522356},
{0.5237157957334182,-0.04239536386068991,0.008348682029502457},
{0.5275102582066329,-0.051327643080604154,0.010651729460553558},
{0.5353115476862398,-0.04654809016468511,0.01612133201735769},
{0.5425513950539598,-0.0635604886329586,0.020378349300750595},
{0.45099256102710944,0.042070062463812334,0.005332889511272476},
{0.43706187994487167,0.054763301355269474,0.03213405011316652},
{0.45043111891522253,0.036958183370019874,0.04775500157652297},
{0.46848048313201485,0.015328882684266139,0.06287124954372697},
{0.4903372786484754,-0.011018368991752086,0.04552760563311784},
{0.5168001690270381,-0.0548119344544703,0.017030230604647215},
{0.5354493414673093,-0.06901063795008236,0.015478834740135788},
{0.11148111293064947,-0.6567600142981311,-0.009069532633214842},
{0.09356900212715773,-0.5848635422782391,-0.005507968668396026},
{0.11035768833910671,-0.5834839833642378,-0.08045913968587881},
{0.12054362078286862,-0.6577958993111122,-0.07144310346178506},
{0.1758286472190108,-0.6565244139508908,-0.10490267571206288},
{0.1778134180341799,-0.5773054182946371,-0.11751972274810514},
{0.20360192943715563,-0.5761668634055651,-0.11151083315793897},
{0.20200406194451884,-0.6572717425752793,-0.1028676506943861},
{0.2238608574609794,-0.6575851558812411,-0.0874217783881532},
{0.23404678990474126,-0.5748099999378576,-0.09493018853701642},
{0.24700372826742154,-0.6555555345412534,-0.038693034092072726},
{0.26038485532868816,-0.5736428055570341,-0.03233668802650396},
{0.23800390307639477,-0.653830680622925,0.02058639089177703},
{0.24835194585082662,-0.5775664159270156,0.02523355370431562},
{0.20201649040320352,-0.6529115150480265,0.06335649980019901},
{0.203028058866584,-0.5809539814702488,0.07126153989143472},
{0.18112100914761578,-0.6538377054039208,0.06291069639085665},
{0.17722657863715466,-0.5792485807916009,0.07224392849529461},
{0.14695625695892367,-0.6535307765111857,0.03528817678023486},
{0.1402659636121748,-0.5813884371564443,0.04153969149863706},
{0.1268097254310311,-0.7253937457294058,-0.005339914292268176},
{0.15655535000566034,-0.724163328319621,0.030264377632773086},
{0.13693297521360062,-0.7992063618578168,-0.004332128403269984},
{0.16213518758732004,-0.7959609130378044,0.027048649040050166},
{0.14774303243044185,-0.8645962655723859,0.029916921157370494},
{0.13287589400470068,-0.8839354876535421,-0.014434303842852407},
{0.15454572227312188,-0.8748367751608066,0.027928908135587998},
{0.14442247249055234,-0.892594340782393,-0.009416448740848536},
{0.13165304174368034,-0.7272585548998792,-0.06311603614303858},
{0.17963553815091013,-0.7238445113359702,-0.09678148851326726},
{0.1988212957856988,-0.7248533779605061,-0.09310266474259717},
{0.2175574674367628,-0.7258044252337698,-0.07768705303142266},
{0.23739220676200015,-0.7251954307582198,-0.037192432797837884},
{0.2300026775222949,-0.7237834497780844,0.014104139136054605},
{0.20089306581166078,-0.72707645096176,0.05320947383579791},
{0.18168245125950272,-0.7260654228661484,0.05317813250520172},
{0.18461610787685992,-0.7911165159896173,0.04846504482485735},
{0.18265619397906022,-0.8580426852711686,0.06321816565136067},
{0.17762591041837164,-0.8703317290714887,0.050852929995625726},
{0.14057775581483,-0.8038675742323468,-0.05447825735717472},
{0.17998515609738833,-0.7967552536580872,-0.08849548914495717},
{0.19436488279558187,-0.7977873560966857,-0.08636589976772292},
{0.21962923746272478,-0.7994235897009145,-0.06768106305470441},
{0.23706744573289137,-0.7965477524348296,-0.026246743271002813},
{0.22519664658569977,-0.7890723047198692,0.016167803645483078},
{0.2037770085942792,-0.7909657533820943,0.048122992027143756},
{0.13653364343238364,-0.8918081056786438,-0.04839425664713147},
{0.15032653073355196,-0.8848876156623435,-0.07777189077113993},
{0.17495487253669975,-0.8667458485570695,-0.1005597399534149},
{0.19475178611811414,-0.8650291001552747,-0.10116279038350712},
{0.2260952781853802,-0.8750653507270513,-0.07674465164246135},
{0.24493141787369066,-0.8831562773307885,-0.041334351746455125},
{0.24535614694004593,-0.8760947513268055,-0.01054743848115589},
{0.23108827637001467,-0.8592433824536642,0.02575284713022836},
{0.20840796037375078,-0.8575682423700746,0.05920755607058608},
{0.14574583315658804,-0.9008041482952882,-0.045737808695219886},
{0.15950143508170225,-0.8926370298361361,-0.07478095517027934},
{0.18857322104851343,-0.8792504990971804,-0.088739195008731},
{0.22047815522766642,-0.8851934638195409,-0.07557745726163771},
{0.23641846404244266,-0.8936540019772057,-0.042354025726369114},
{0.23737977830331544,-0.886703791733616,-0.007154469260233823},
{0.2264573245905431,-0.8713027699522017,0.01836331789052311},
{0.2044135618260432,-0.8698113549100382,0.04356823210308704},
{0.1409522306786776,-0.9472590250198383,0.002840172993337534},
{0.14148881587319515,-0.9873440464845968,-0.0029817493487892944},
{0.14339901593625606,-0.9892088556550702,0.030283830872453482},
{0.1456334366606569,-0.9295538750718351,0.059982443451188444},
{0.14001631370294307,-0.9943180329100182,0.07713966048152712},
{0.14304939798977787,-0.943024703182739,0.09988157840344561},
{0.1399660595004354,-0.9890440434855559,0.14642345433878848},
{0.14477209043703054,-0.9479728508425549,0.145508611706041},
{0.1570422213654391,-0.9825444999612286,0.1915279520088577},
{0.15550703653399467,-0.9519834604233295,0.18402494553768353},
{0.18510297923663868,-0.9754419060068091,0.2133101767732101},
{0.18499058274070748,-0.9524903253905574,0.20884241605994625},
{0.21814430683378802,-0.9510437608732126,0.20121674610523174},
{0.21885543081766018,-0.9776611964336808,0.20426387995405795},
{0.24588030367587876,-0.9560891747314304,0.16503263956416098},
{0.24727823509402264,-0.9873878162738777,0.1669774231644315},
{0.25649042481822704,-0.955977858971037,0.11490056017224763},
{0.26240691151991136,-0.993763615579127,0.1146757671803853},
{0.255179492610876,-0.9522768801218421,0.06137064824949212},
{0.26123377309362983,-0.9931821798597907,0.060044585744611925},
{0.254942271160329,-0.9897670555603438,0.020472913660308067},
{0.25101055527381383,-0.9497803810295248,0.0013082303685065001},
{0.2507609053645821,-0.9878757683691943,-0.008396774760934547},
{0.2422852369093882,-0.9505066353109262,-0.04767394641118799},
{0.24495627479106005,-0.9980427879410448,-0.03387943800671299},
{0.22276283015457493,-0.9495793642194941,-0.08930333895946242},
{0.22814273166174168,-0.9994455826691088,-0.0785570451393514},
{0.18727471729984713,-0.9489876615125488,-0.10186040517315681},
{0.1905579918636825,-1.0,-0.09619843169062434},
{0.1588146276474306,-0.9996130966774677,-0.08385967405556548},
{0.15588151139784226,-0.949590711942641,-0.08410662212595271},
{0.144872058474277,-0.9988176753216471,-0.05854506518591489},
{0.14177629152624985,-0.9465538450814239,-0.04744807268378786},
{0.1407150092281306,-0.9978228582591026,-0.026868166205237624},
{0.14449758361042941,-0.9133028547899414,-0.045246074025521034},
{0.1429867153285855,-0.9096078199862044,-0.004387245915697767},
{0.15781602801050368,-0.9141814927821725,-0.07801397553160706},
{0.18550231101785566,-0.9104578184866838,-0.09228022499833162},
{0.21970434858260185,-0.9119449105866961,-0.08075634195877372},
{0.23870259860158224,-0.9190037347518347,-0.045841559306848655},
{0.24334597883973855,-0.9109998073588904,-0.0005841375581807243},
{0.23502053262429878,-0.9029234706849133,0.03429335971769026},
{0.2168706600024911,-0.8926554023402787,0.06059684160442756},
{0.1737563368252799,-0.888181697581557,0.06743681682316167},
{0.15068857713871486,-0.9019075792793817,0.03720810346313598},
{0.17084807749306102,-0.9097801973044835,0.09670205445123897},
{0.17179642292748024,-0.9261836012972069,0.1390414902478478},
{0.1754541723551632,-0.9301180190225665,0.1696376536907254},
{0.18809877814741938,-0.9377064036012269,0.19961185383159924},
{0.21236453317763537,-0.9400953695075331,0.1979005091074935},
{0.22990270948504843,-0.9349089196616325,0.16223299415349093},
{0.23107584791132996,-0.9283828981166291,0.12471147738439305},
{0.2250345362550298,-0.9132315262444467,0.08500849593224652},
{0.1376068138214187,0.2786279413906311,0.10903865061522221},
{0.16692824969746162,0.27467244932228424,0.07533104955901938},
{0.13577226524600378,0.22601071062954753,0.109730321359414},
{0.16546817598589425,0.22861474290787578,0.0785516414616624},
{0.1791486667911314,0.22896544158989185,0.04357201467746934},
{0.1810458980277387,0.2688678187487622,0.03371462583719854},
{0.12292772337925469,0.27818483982013315,0.12436348054122155},
{0.1356971541261267,0.2774358900924382,0.11759321276467552},
{0.12290286646188531,0.2254427841044336,0.12388417433020739},
{0.1370080863334777,0.22534173533164936,0.11866800425701729},
{0.11833405697583718,0.2778979045348476,0.11879012737278866},
{0.1176223926241961,0.22565731010868684,0.1215427607875644},
{0.05999108933549085,0.2786717111799121,0.14343035726685224},
{0.06191317748946756,0.27844853929135643,0.13631911742813044},
{0.06467175494970122,0.22502940276122527,0.14450406802365626},
{0.0673557616578267,0.2251369359472365,0.13718208475506344},
{-0.1376068138214187,0.2786279413906311,0.10903865061522221},
{-0.13849301696241448,0.3142154819148364,0.10608554075818462},
{-0.16550546136194835,0.3035745598096608,0.07705860531619216},
{-0.16692824969746162,0.27467244932228424,0.07533104955901938},
{-0.18123340564354695,0.29500000405275834,0.031106810984487934},
{-0.1810458980277387,0.2688678187487622,0.03371462583719854},
{-0.17835000322869743,0.2901372345004286,-0.0048579062424095225},
{-0.17796309990616513,0.26339227214650035,-0.005840294846269424},
{-0.17820032135671218,0.23018343054099194,-0.004685528924130475},
{-0.1791486667911314,0.22896544158989185,0.04357201467746934},
{-0.16546817598589425,0.22861474290787578,0.0785516414616624},
{-0.13577226524600378,0.22601071062954753,0.109730321359414},
{-0.12292772337925469,0.27818483982013315,0.12436348054122155},
{-0.1242256867601521,0.32296619756440037,0.1218707640232866},
{-0.13784403527196576,0.31903934498780545,0.11571219256113519},
{-0.1356971541261267,0.2774358900924382,0.11759321276467552},
{-0.12290286646188531,0.2254427841044336,0.12388417433020739},
{-0.1370080863334777,0.22534173533164936,0.11866800425701729},
{-0.11833405697583718,0.2778979045348476,0.11879012737278866},
{-0.11870853183968477,0.3238561832797785,0.11918189400524103},
{-0.1176223926241961,0.22565731010868684,0.1215427607875644},
{-0.05999108933549085,0.2786717111799121,0.14343035726685224},
{-0.06096429168727945,0.3626978185082985,0.1423020693653894},
{-0.06282423754783269,0.3625854220123675,0.13516219003491584},
{-0.06191317748946756,0.27844853929135643,0.13631911742813044},
{-0.06467175494970122,0.22502940276122527,0.14450406802365626},
{-0.0673557616578267,0.2251369359472365,0.13718208475506344},
{0.10675019311393141,0.27885759769241364,0.13384639451764477},
{0.10688744652723198,0.31444297674554333,0.1327905158972145},
{0.08369540225381993,0.3146499376010319,0.13941650547946427},
{0.08365757650999694,0.27906509891567116,0.14045833453790316},
{0.08360786267525816,0.23438533031195719,0.1417752107907121},
{0.10660051124194617,0.23417782908869944,0.13519947541096997},
{0.10707495414304022,0.31727288275127163,0.1255085198435203},
{0.0791514496851412,0.3176235814332877,0.13266569094259864},
{0.07963832104491997,0.2783561364028746,0.1333746534553952},
{0.0795259245489888,0.2316202684384966,0.13526810211762022},
{0.10660051124194617,0.23070920838013154,0.12734090694785966},
{0.10667562236182324,0.2781216167911719,0.12591379567019517},
{-0.09243260870916138,0.28800386254881216,0.13038641969337914},
{-0.11432722996944492,0.2863346665106805,0.12019832577854161},
{-0.11357828024174975,0.28469951364198975,0.13175192904538902},
{-0.09438009414827639,0.2856435361342577,0.13717938291621895},
{-0.07857757911456958,0.28500536179918706,0.14148341219550611},
{-0.07536941567061126,0.2867880350687875,0.1350460109646024},
{-0.07263569512774701,0.27588935753784666,0.134352178749335},
{-0.07636801530753816,0.2761006413354865,0.14147584704674154},
{-0.07856461028811598,0.26721429337592867,0.14204269283631746},
{-0.07465775131897018,0.2645454169653325,0.13581981760966697},
{-0.11613692162749045,0.275477597297945,0.12086459923759513},
{-0.11392789818822793,0.26462268955628515,0.12119314284108622},
{-0.11322866229527155,0.26691114705757596,0.1323987492647621},
{-0.11512589353187885,0.27578938950060033,0.13158225356595446},
{-0.09279465511432425,0.2632533976298931,0.13085221671017078},
{-0.09469242671870048,0.2657536792965925,0.1377175892140432},
{0.08877539964924727,-0.49683709235668694,-0.010870578406957994},
{0.1067874784899855,-0.4951289898391946,-0.07138204190389938},
{0.08670362962328532,-0.4682754135637173,-0.012042636097701738},
{0.1084604571024994,-0.4639357200116827,-0.06551905161133616},
{0.1212174593906867,-0.42729662380919825,-0.06400980443279893},
{0.09077259892310108,-0.4357960684462238,0.002147421513607945},
{0.09879868139457033,-0.40899869041871195,0.010385868518254838},
{0.1284573067584067,-0.4053739034249319,-0.046352206848459},
{0.09270765590353139,-0.3910628034333887,0.010858690316042193},
{0.1278704673613815,-0.38449463320241123,-0.050380108197838364},
{0.163608230125341,-0.4041715851391298,-0.059003297053941944},
{0.1711722981544009,-0.3776341240084589,-0.061785650696007194},
{0.21261418308686708,-0.3985809402020921,-0.04956253176349292},
{0.2069970601291533,-0.37258600831139665,-0.03864061841848944},
{0.2273689250166771,-0.39746345965600727,-8.051479756607728e-05},
{0.2292910131706538,-0.3723212281046357,0.0151157075994351},
{0.22629521425987312,-0.38337985449517076,0.04474893567813318},
{0.21979188816116363,-0.36855162254879037,0.057196307234740895},
{0.207683867563425,-0.3767403557186985,0.08352950934876768},
{0.2017798093204254,-0.3635996923145923,0.08959837976128172},
{0.17167159797286435,-0.48642906875990727,-0.11326810914240122},
{0.16802681737163494,-0.4555470507672817,-0.10342314876081513},
{0.1665662032922987,-0.4350860251978894,-0.09413746902004036},
{0.19542616509370112,-0.4848647040689422,-0.11000807039262853},
{0.19099460902095358,-0.45526281732084034,-0.10113415089175541},
{0.18828574539545873,-0.43338818966800613,-0.09096821205544281},
{0.21126596550346202,-0.4231665929514969,-0.07009650698168667},
{0.24114938385916074,-0.4238928472328981,-0.00017453878935464896},
{0.23897710542818337,-0.41388199394625985,0.04816676181642464},
{0.22098988350481455,-0.3936841274803217,0.08205160350082663},
{0.2283421273684657,-0.4840325377048365,-0.08745474082205609},
{0.2234490972210777,-0.4495792291275519,-0.08120592794249838},
{0.25157199738570074,-0.4551601474447493,-0.004849260358107126},
{0.24244734724005812,-0.4456772334683262,0.036264621338636865},
{0.2110292844206839,-0.42528969791550425,0.09609414071122666},
{0.22659457800384364,-0.3998416182069354,0.0959444588392414},
{0.1853526291458704,-0.3688839487266638,0.12096078470045929},
{0.19833442442592003,-0.3513706293366202,0.12308388966446675},
{0.14406042608538944,-0.36019699647383,0.1255717428724816},
{0.15841529586621358,-0.37324633772499216,0.12163462330827737},
{0.12541179401288724,-0.40285362815078307,0.1018587840698501},
{0.14041564548416008,-0.43302884510168765,0.10019607244494531},
{0.10180744913180462,-0.42155359516133084,0.05241675431882185},
{0.10530254786104874,-0.4506691509174228,0.05506671785750664},
{0.1005467711269613,-0.40081752239756846,0.0505795039045624},
{0.1268594392657699,-0.3985074501855217,0.08754768407830685},
{0.12445047975201444,-0.38531599221113894,0.0860719397014414},
{0.09801244629082106,-0.3846680912562281,0.05620419201104079},
{0.1278456104440121,-0.3707973909963381,0.09342202209401695},
{0.2540187826432792,-0.4849895290235581,-0.02014761226343037},
{0.24625477853972635,-0.47824411816438145,0.028008342197616276},
{0.19793509264470305,-0.4858287201686595,0.08197270980656725},
{0.1652930968287707,-0.4874973758390222,0.08409851660941921},
{0.11000807039262853,-0.4837488446261641,0.04477865590542267},
{0.15561943302992584,-0.4556497206433726,0.09170311222114659},
{0.20126754067550837,-0.4538983887043682,0.08584120266412118},
{0.10954659631798806,-0.4806195748764651,0.06847162110060485},
{0.10977084894208149,-0.46108582039850493,0.07212937052828784},
{0.13623373932064423,-0.4649840334833484,0.09352036902795674},
{0.13790671793315815,-0.4839898486510934,0.0903824533939554},
{0.1659420785192194,-0.4827318724850946,0.0982361585471456},
{0.16514341495678544,-0.463550978160226,0.10136813013568906},
{0.2164837566799588,-0.47957126140479944,0.08478640477922869},
{0.2145740969846668,-0.4584331550209757,0.08898073940142923},
{0.2501119236741334,-0.47137280161505113,0.04680125246441475},
{0.2457554787212629,-0.45191253715366136,0.04924857808976211},
{0.19542616509370112,-0.35053089782374985,0.10807139230889151},
{0.14289971611779262,-0.3580652456255203,0.11272882210903919},
{-0.0936187159618965,-0.5848635422782391,-0.005507968668396026},
{-0.11050737021109197,-0.5834839833642378,-0.08045913968587881},
{-0.08877539964924727,-0.49683709235668694,-0.010870578406957994},
{-0.11334105879120271,-0.49527759097564206,-0.08010736026832503},
{-0.17185910558867262,-0.48642906875990727,-0.11326810914240122},
{-0.1781376386955198,-0.5773054182946371,-0.11751972274810514},
{-0.20395154738363383,-0.5761668634055651,-0.11151083315793897},
{-0.19565041771779454,-0.4848647040689422,-0.11000807039262853},
{-0.2296530595758167,-0.4840325377048365,-0.08745474082205609},
{-0.23440883630990417,-0.5748099999378576,-0.09493018853701642},
{-0.2607593301925358,-0.5736428055570341,-0.03233668802650396},
{-0.2553421433093149,-0.4849895290235581,-0.02014761226343037},
{-0.2487134518882206,-0.5775664159270156,0.02523355370431562},
{-0.24892581642139824,-0.4879393966739823,0.026302401151199493},
{-0.22318701885316128,-0.4866635883716098,0.06134308949327823},
{-0.20332742261055453,-0.5809539814702488,0.07126153989143472},
{-0.19512626098196173,-0.49111729952288224,0.09407856893323027},
{-0.1775010854637558,-0.5792485807916009,0.07224392849529461},
{-0.1689632747151384,-0.4890639020010628,0.09387647138766173},
{-0.11919540319946352,-0.4917841133497046,0.04822890410984812},
{-0.14046535931889886,-0.5813884371564443,0.04153969149863706},
{-0.10085856332961651,-0.45263608959621826,0.04847260997362195},
{-0.08821395753736036,-0.4682754135637173,-0.012042636097701738},
{-0.09074774200573169,-0.4358484841198071,0.0020750122325753667},
{-0.10179448030535101,-0.42159250164069156,0.052380549678305556},
{-0.09363114442058121,-0.42011459579275057,0.002816396811505941},
{-0.10102067366028646,-0.41202312882124437,0.05166780459112667},
{-0.09651454683543072,-0.4043801670979251,0.0035464336672896193},
{-0.10025929547390659,-0.40245429636956603,0.05095505950394779},
{-0.12832005334510616,-0.39769581779663415,0.08952110717032906},
{-0.12873181358500782,-0.401203344984563,0.09155451108469914},
{-0.17295767326284597,-0.39533927395646196,0.10016094853996682},
{-0.17269505452716064,-0.39161668039651104,0.09658479464538772},
{-0.11297901238603983,-0.46418753139199004,-0.07356512769025472},
{-0.1668785358627228,-0.4555756902590333,-0.10473300023262833},
{-0.19345382273721673,-0.455259034746458,-0.10180798949957351},
{-0.2294406950426391,-0.45059187832647013,-0.07605298089826956},
{-0.25308232529977576,-0.4541053495598569,-0.0026472616998402957},
{-0.24273482289311285,-0.44390590792187246,0.03818292691823128},
{-0.2116782661111326,-0.4268048891394994,0.0863880548462478},
{-0.1863009745802896,-0.42569065080002794,0.12189562094065601},
{-0.16178556964084187,-0.42517351884519083,0.12162975999835729},
{-0.13357512989765705,-0.43198053163002204,0.09142212098131867},
{-0.12144225238254903,-0.4054376668216621,0.09873059505568894},
{-0.1597262280735646,-0.3921786628761668,0.1363418128744242},
{-0.1827810189336761,-0.38931525406876666,0.13527836910522933},
{-0.2095810988000323,-0.39836263162345653,0.09333826508983749},
{-0.23492056458705232,-0.4133054215368437,0.04462681256236182},
{-0.24297150397589096,-0.42407278969994183,0.002016112145765285},
{-0.21746992785820102,-0.4201583655820314,-0.0617980791546919},
{-0.23519507141365345,-0.40843346573244277,0.00016373143397664894},
{-0.22951580616251616,-0.40928832754284233,0.04332722807815772},
{-0.2290165063440527,-0.4003981970089023,0.04365901388826221},
{-0.2086948956590366,-0.39740726140804167,0.08160580009148426},
{-0.21086663372224504,-0.3945751939312376,0.08390290347707746},
{-0.17320732317207768,-0.3992337044669231,0.0982237300884609},
{-0.09077259892310108,-0.28133140133843687,-0.04977327519336385},
{-0.07988797095415169,-0.21238047402681787,-0.06524076221035276},
{-0.04814514710566865,-0.21925233094391702,0.004237023675943609},
{-0.06801717180696011,-0.2882567546646571,0.019193322783553256},
{-0.056732671689024836,-0.2042149766709724,0.0742389662980728},
{-0.07931356001581116,-0.27990969373846136,0.07300692778498119},
{-0.10801087111877473,-0.265319223610397,0.11091372677330465},
{-0.08820152907867566,-0.18553716473894963,0.11660055717320651},
{-0.1481423642116588,-0.2610276227897944,0.129437533891191},
{-0.13753224306931056,-0.17098992403239716,0.13721180498235294},
{-0.17562871114451786,-0.2585435521561619,0.12821035868801947},
{-0.16420695761328202,-0.16599854695106941,0.13987797955410475},
{-0.19547587892843993,-0.16694310981110624,0.11696530541721391},
{-0.1994205636414087,-0.25663497319640766,0.10984163711980738},
{-0.22162643673657856,-0.16969033954819307,0.07601407441890876},
{-0.22567108948679385,-0.26139183066603294,0.06693049222370254},
{-0.2323365259161733,-0.17820383374720994,0.020094656222078185},
{-0.23448340706201234,-0.25964049872702855,0.02053019264381145},
{-0.21328856206245408,-0.18054038397993283,-0.05232867437249118},
{-0.2148988580137756,-0.2701457885222103,-0.044767848550044675},
{-0.1708356490343763,-0.27844043377482275,-0.08219804316619848},
{-0.16334615175742456,-0.18833681014961973,-0.09735427834830107},
{-0.13779432143722695,-0.1933087339912671,-0.09778495146011425},
{-0.1466693216736379,-0.2795579143209076,-0.08198838047186535},
{-0.1116934774638271,-0.3449510602420901,-0.0466639990511142},
{-0.0860665360237524,-0.3494874476620042,-0.001824281587805846},
{-0.08098653862832506,-0.3506994925676465,0.03471808878404554},
{-0.09707652931508656,-0.3446127900187588,0.07897366868917316},
{-0.12342702319771814,-0.33506503191006765,0.1058369715844907},
{-0.15063886330397605,-0.32583663115279626,0.11853561415363682},
{-0.18390444352521884,-0.3224166435434292,0.11808981074429446},
{-0.21025493740785042,-0.32647318438456024,0.09468864414431818},
{-0.22539658266019272,-0.3286438417122308,0.06930594893578622},
{-0.23403436144605658,-0.3286503261254577,0.029778587008532136},
{-0.22721870277692297,-0.3308134183043637,-0.020806860941488172},
{-0.20738396345168558,-0.3316385598874738,-0.05662405776747597},
{-0.1675902002143639,-0.33852014342441317,-0.07532780735240598},
{0.06801717180696011,-0.2882567546646571,0.019193322783553256},
{0.07931356001581116,-0.27990969373846136,0.07300692778498119},
{0.09238289487442258,-0.35282746084157407,0.0738990749714348},
{0.0775660106511891,-0.359641498407401,0.020798755424954667},
{0.09801244629082106,-0.37805453013266294,0.07471665140578027},
{0.0834581808032729,-0.3864740003398913,0.019793671374800974},
{0.10801087111877473,-0.265319223610397,0.11091372677330465},
{0.12212851944905183,-0.34289928382357737,0.10653242490306478},
{0.12894417811818545,-0.3616365362101792,0.10635896684924794},
{0.1481423642116588,-0.2610276227897944,0.129437533891191},
{0.148491982158137,-0.33022171559741836,0.11968389566254897},
{0.14964026366704916,-0.35223089482470865,0.11595427732160231},
{0.14964026366704916,-0.35447288069787414,0.10464762212514216},
{0.17562871114451786,-0.2585435521561619,0.12821035868801947},
{0.184691218996737,-0.32512118422677283,0.11904950390186057},
{0.1872871457585318,-0.3456178740689125,0.11578406147439886},
{0.1800851241346348,-0.3497792462572101,0.10376358045522202},
{0.20792108901397202,-0.358945504721058,0.09663342774458869},
{0.22761803455813992,-0.3642367859141252,0.06135659868750072},
{0.23513292912022993,-0.3682533395403577,0.016173747690940977},
{0.2242104754074576,-0.36594813063823095,-0.03129323786475838},
{0.2054245899216548,-0.3625016650081878,-0.060724368397887925},
{0.1744804296356057,-0.3636186051865038,-0.07244170309871197},
{0.13476123715039218,-0.3701808313720235,-0.06624044258281744},
{0.10355499849642669,-0.3814512819279673,-0.04256963246616015},
{0.0972386396457565,-0.35567249714483173,-0.04329264454094813},
{0.09077259892310108,-0.28133140133843687,-0.04977327519336385},
{0.1466693216736379,-0.2795579143209076,-0.08198838047186535},
{0.1708356490343763,-0.27844043377482275,-0.08219804316619848},
{0.2148988580137756,-0.2701457885222103,-0.044767848550044675},
{0.23448340706201234,-0.25964049872702855,0.02053019264381145},
{0.22567108948679385,-0.26139183066603294,0.06693049222370254},
{0.1994205636414087,-0.25663497319640766,0.10984163711980738},
{0.20722185312101565,-0.331605057085802,0.10110713250331042},
{0.2287414591496827,-0.33524335327380456,0.06398062457327833},
{0.2376418566712319,-0.3380494830977014,0.017585728671076245},
{0.22659457800384364,-0.3354805747243516,-0.02943977641743194},
{0.20760875644354793,-0.3343874107278672,-0.05945990781866231},
{0.1729074190603383,-0.3380332720646344,-0.07532996882348157},
{0.13156550216511856,-0.34687963280929357,-0.068308970402166},
{0.006877800962557107,0.32890862191899195,0.15164394735412973},
{0.03703572614485693,0.3272534754428517,0.14864814844334906},
{0.03654885478507818,0.27888677755193425,0.15026871138227965},
{0.0361495230038612,0.23163053542610568,0.15146562599039282},
{0.03641160137177762,0.22357905566949818,0.150806377312335},
{0.0,0.23175752185179713,0.1527349498795385},
{0.0,0.22429666406659715,0.15299486677637936},
{-0.03641160137177762,0.22357905566949818,0.150806377312335},
{-0.0361495230038612,0.23163053542610568,0.15146562599039282},
{-0.03654885478507818,0.27888677755193425,0.15026871138227965},
{-0.03703572614485693,0.3272534754428517,0.14864814844334906},
{-0.04552382305873555,0.36785779033352317,0.14636131204536493},
{-0.006877800962557107,0.32890862191899195,0.15164394735412973},
{-0.006852944045187714,0.3747447775481515,0.14970456743154825},
{0.0054301557096744476,0.326950329124499,0.157663103931905},
{0.0,0.3202659798232079,0.15754854596489826},
{-0.0054301557096744476,0.326950329124499,0.157663103931905},
{-0.005529583379152017,0.3742314281676966,0.15446628821109362},
{0.0341647521886921,0.32524168623923766,0.15574317724900388},
{0.027162126271519132,0.3195510732649536,0.15628408538567262},
{0.034963415751126055,0.2790737447999736,0.15623166971208932},
{0.027811107961967837,0.279113732014872,0.15747991925824797},
{0.027162126271519132,0.2390649151906297,0.15875032388293148},
{0.034064784151445635,0.2330868265632908,0.15768958195258115},
{0.0,0.23253132849686187,0.15911723359801447},
{0.0,0.23844079041755026,0.15996885320180063},
{-0.027162126271519132,0.2390649151906297,0.15875032388293148},
{-0.034064784151445635,0.2330868265632908,0.15768958195258115},
{-0.034963415751126055,0.2790737447999736,0.15623166971208932},
{-0.027811107961967837,0.279113732014872,0.15747991925824797},
{-0.027162126271519132,0.3195510732649536,0.15628408538567262},
{-0.0341647521886921,0.32524168623923766,0.15574317724900388},
{0.0,0.3187291738884568,0.1639032709271603},
{0.02692490482097211,0.31850870383874574,0.16523365637419174},
{-0.02692490482097211,0.31850870383874574,0.16523365637419174},
{0.02625052584538511,0.27931366808936503,0.16386706628664405},
{0.02598844747746869,0.24027804083180973,0.16479325664253838},
{-0.02625052584538511,0.27931366808936503,0.16386706628664405},
{-0.02598844747746869,0.24027804083180973,0.16479325664253838},
{-0.1909324667275301,0.2969247940455796,-0.0014735829057898535},
{-0.20131779487801604,0.33913075900327017,0.007116643516410833},
{-0.18100861265168464,0.3459588461310885,0.003405938047375662},
{-0.1898338990533567,0.40726519061608146,0.013756142292883113},
{-0.21015550973837283,0.40095045286871794,0.018249840659054144},
{-0.10132057777202587,0.683714098978624,-0.014098195090596712},
{-0.09783790750146643,0.6611840052221142,-0.012116126114272116},
{-0.15171203369301112,0.6617957015365089,-0.012498166126884298},
{-0.14416039412263593,0.6728953958774803,-0.008625890694948075},
{-0.14802996771572766,0.6715558241783777,-0.007521378975316813},
{-0.13771921031734988,0.6521841800310874,0.06435888201150822},
{-0.10204413021458275,0.6602167469157834,0.06724120369081993},
{-0.10572673655963512,0.6798429042822256,0.039212867885754364},
{-0.14138938820371758,0.67177575386032,0.03804243129831732},
{-0.10861013897448465,0.6927863334506832,0.009956816509748369},
{-0.14433493291199057,0.6850007146363744,0.010163777365237006},
{-0.11067002090953082,0.6989513893260614,-0.019210074184389157},
{-0.1464693855991449,0.691595362888028,-0.018030451344880814},
{-0.11159350942658064,0.6988314276813656,-0.0512528021446116},
{-0.14768034976924946,0.6916067106111751,-0.04867740935803499},
{-0.11064462362439252,0.6892447630933137,-0.08012465203692981},
{-0.14612030802043563,0.6811576190639589,-0.07678571959289773},
{-0.10698741456447844,0.6709943820664908,-0.10531551668750236},
{-0.14222533714220562,0.6625295209666747,-0.10124006297445978},
{-0.10354257003774199,0.6548843977722798,-0.12000865669165778},
{-0.1386929530369074,0.6457181393084321,-0.11562357224703561},
{-0.1008834202469859,0.6400999356151804,-0.13188215767769387},
{-0.13585926445679664,0.6300977282128445,-0.12708477262540113},
{-0.10072130991631595,0.6554598894461582,0.06565468392133002},
{-0.09632757958739138,0.6525310961387211,0.07024348701482742},
{-0.10137029160676465,0.6812338109193736,0.02621756341148222},
{-0.10540197553052633,0.6816493537336575,0.023544904426503633},
{-0.10520257982380228,0.6949456430552071,-0.01909659695292019},
{-0.10898461383833223,0.6942377612779482,-0.01978664659380528},
{-0.10586398997293568,0.69448741118718,-0.050790787702202245},
{-0.10968384973128861,0.6940805142571985,-0.05064110583021699},
{-0.10266825498766205,0.6759657655403692,-0.09255851439931503},
{-0.10663779661800024,0.6761867759578492,-0.09067965566685031},
{-0.09526629728927212,0.6353128175504966,-0.13120777870210687},
{-0.09937309233291086,0.6370182182291446,-0.1282006320681793},
{-0.13981637762845014,0.6427163963521935,0.06631771517377012},
{-0.13675843642424595,0.647337081144056,0.06272535024612401},
{-0.14251281279526032,0.6732223183776648,0.023273099438747016},
{-0.1458582296525192,0.6723199042036021,0.025949000630339},
{-0.1462575614337362,0.6866061472777758,-0.018622154051826132},
{-0.14992719895233497,0.6856599633144321,-0.017743516059595003},
{-0.1471934784094707,0.6860468666369646,-0.048340219870241494},
{-0.15067614868003013,0.6844138752393492,-0.04785226777492494},
{-0.1433487617337484,0.6672896206429135,-0.08689005650355576},
{-0.14705622499617016,0.6659565333570375,-0.08877269781040278},
{-0.1347109829478845,0.6268933473432685,-0.12333786251584967},
{-0.13781917835459637,0.622811949584768,-0.1252323919136125},
{-0.09475456901212397,0.6459591433333612,0.06778913660848437},
{-0.09942280616764963,0.6753881123954152,0.023403868438820776},
{-0.10138272006544935,0.6863462303809351,-0.03843419793076971},
{-0.10058405650301538,0.6709327801408362,-0.08939033817025531},
{-0.09276979819695487,0.6305159728659728,-0.12490060610350799},
{-0.13824336705318274,0.6349572555585608,0.0614408960594491},
{-0.13570958258481142,0.6160611350479023,-0.12188589432081581},
{-0.1466066390124455,0.663321159748113,-0.08520518980012608},
{-0.14887888548066927,0.6763105201769273,-0.03985482479520737},
{-0.1435735547256107,0.6625635641361154,0.021858416619767243},
{-0.1528484271110075,0.6636983364508052,-0.03622355338820048},
{-0.1005467711269613,0.6675900651224218,-0.033997778548102056},
{-0.15189954130881939,0.6747029260644504,-0.04052866340302547},
{-0.05316300220767252,0.571124151386192,-0.18479010629844567},
{-0.058605586376031665,0.5815959383797018,-0.16312676244325122},
{-0.1232146586645405,0.5793750268495236,-0.14713457832266064},
{-0.10861013897448465,0.5697251392325104,-0.18479659071167248},
{-0.12860698863039197,0.5270944452084645,-0.1476149652692126},
{-0.1121052377037288,0.48490523165160976,-0.18670246783258218},
{-0.13019242766434408,0.477777780779821,-0.14800186859174486},
{-0.1297682389657577,0.42908848333087013,-0.14511090102813076},
{-0.12527454059958668,0.378033455789676,-0.13997308428143107},
{-0.11079484586414669,0.39829670675565093,-0.1886537358460795},
{-0.05965389984769734,0.3716549546455823,-0.16251398539331885},
{-0.0542237441380229,0.39274712976904946,-0.1888282746354341},
{-0.05996569205035255,0.6137267462862551,-0.1429175482541663},
{-0.16262205894709883,0.5802725777136662,-0.124533696388425},
{-0.17998515609738833,0.5231762385161717,-0.1268729484599924},
{-0.19593789337084927,0.4699597398993782,-0.10230999115688147},
{-0.16655377483361403,0.3921100361695168,-0.10650864872123318},
{-0.1192699739515717,0.31797049754092144,-0.12859564090724507},
{-0.06303660208101032,0.3128213330710748,-0.14622946230975342},
{-0.051677531210966875,0.640279878082224,-0.12695508436086517},
{-0.07958860721018118,0.6551124329707557,-0.11197230723257943},
{-0.09524144037190271,0.6734671049769763,-0.08823341077704075},
{-0.15367194759081085,0.6221348687703364,-0.11059923273180494},
{-0.16873848172327605,0.5825080791736048,-0.11855939033546843},
{-0.1853526291458704,0.5300907844870141,-0.12223281042844951},
{-0.2008060666008679,0.4802564477357645,-0.09294163514746502},
{-0.20222885493638115,0.463486674395727,-0.06425296992880385},
{-0.1979096953595648,0.4409117301143987,-0.07086274847798664},
{-0.18137065905684752,0.37761413040100966,-0.07023592186606283},
{-0.17634037549615894,0.3215617817330297,-0.06320465645713817},
{-0.157641489221149,0.3203556808728454,-0.09838530005136197},
{-0.1514623837837794,0.6628218599296496,-0.08361596819179166},
{-0.15571940106717233,0.6569113172734232,-0.07774811458930835},
{-0.15993805223897334,0.6212600133524877,-0.10028145055243148},
{-0.19354082194800962,0.4418119828173857,-0.017165322546872176},
{-0.18783669977950293,0.4289998630167706,-0.017924539262176447},
{-0.17867422389003731,0.35733250693089225,-0.02251658456228725},
{-0.1771266105999082,0.3186956710867851,-0.02242688351264988},
{-0.05283824117856372,0.5535162676365909,-0.18516241969121763},
{-0.09282005239946256,0.5515039380652078,-0.18519862433173395},
{-0.09511661541728686,0.48461667526301744,-0.18674407615078745},
{-0.09470485517738518,0.4150054185378028,-0.18827926098223188},
{-0.05333754099702717,0.41039446036578037,-0.18839652078808317},
{-0.0910346772910175,0.41655735477008315,-0.18182078540834107},
{-0.05178992770689804,0.4142116182852889,-0.18138524898660782},
{-0.09053537747255405,0.48416006449829685,-0.1797863007584332},
{-0.08922498563297195,0.5492560081465847,-0.17883363238186278},
{-0.05134034172317337,0.549096599654759,-0.17834189771216397},
{-0.05583404008934441,0.3745513258868854,0.169779770413946},
{-0.10151997347874991,0.35048388582785567,0.1609950115949414},
{-0.09384350895375883,0.34041305171886943,0.13101324630530292},
{-0.15312293393760862,0.3217038984562505,0.13217503700843758},
{-0.18949670956556325,0.3048703617194828,0.06858834053868723},
{-0.2037640397678256,0.44343200538854755,0.03797110275282255},
{-0.19908337415361524,0.4306560902284486,0.0407707481634926},
{-0.19953241976957098,0.48581250913559265,0.07996362244179767},
{-0.061725669873659315,0.3073376809522795,-0.1363034467628323},
{-0.11151839830670357,0.31096516978490407,-0.1091051158507969},
{-0.14337415901888667,0.3134632899805278,-0.08324419516678856},
{-0.16385788003457274,0.31626671796558037,-0.0532472995796209},
{-0.15864008885807593,0.27561485071124553,-0.0417299009532898},
{-0.13652121497369896,0.2771230171542451,-0.07764436397767957},
{-0.10641300362613791,0.2760428219842143,-0.10246345560324903},
{-0.0601407712074761,0.27340042359429406,-0.1285318775105149},
{-0.06314899857694148,0.23421403372921573,-0.12926083363076077},
{-0.10621360791941388,0.2351180690065853,-0.10246345560324903},
{-0.13795643176789693,0.23394709205137934,-0.07613781863798683},
{-0.15991319532160392,0.23256915424068486,-0.0420503390402474},
{-0.015777658116337398,0.1301824308606194,0.13551937313015866},
{-0.059529074893081485,0.07678274757016884,0.12601862701736175},
{-0.07152469899488893,0.13075792253449778,0.12759542016701148},
{-0.11221763419965995,0.07161737206725538,0.10945959710719519},
{-0.13494820439843153,0.13179434791524783,0.10133732917286177},
{-0.13721991049888643,0.10125708455918024,0.09807566931978234},
{-0.16576753972986474,0.12234385600495842,0.06725255141396683},
{-0.16706550311076215,0.13719802560424604,0.07018350619247954},
{-0.18615129270830436,0.13546398543384647,0.04480999723601886},
{-0.18329274721082423,0.14135291337931694,0.04265176836703292},
{-0.1939531225556802,0.14307182325218734,-0.0032097845472650248},
{-0.1824940836483903,0.13300639282089013,-0.034215546758968686},
{-0.17791284570365745,0.1464950530681678,-0.05884226745880979},
{-0.17956042703103306,0.07887180936473567,-0.0460150173606655},
{-0.15110087774638542,0.08850494558091307,-0.08960378343897073},
{-0.1508382590107001,0.14591199624552473,-0.09290543050694873},
{-0.11266722018338461,0.08885186168854678,-0.11553981524285614},
{-0.11410243697758259,0.1496216209790223,-0.11753701451670993},
{-0.07149984207751954,0.08959054442863268,-0.13216152781421509},
{-0.06789234685234424,0.1485316991891511,-0.1307662982349157},
{-0.07570606479063587,0.017412000433374975,-0.13319146878173815},
{-0.060003517794175544,-0.029373581365741697,-0.11777207449618136},
{-0.04546114039754316,-0.060727340420616824,-0.0989283696591063},
{-0.040206063844992264,-0.07834765262890264,-0.07620644534463712},
{-0.014367298239508828,-0.09291975025282449,-0.032025976559386556},
{-0.04687150027437174,-0.1009409694143737,-0.05360448267486369},
{-0.028335264697800677,-0.11301116426828935,-0.012875342829576383},
{-0.05160242009108979,0.014242743468777434,0.12573547430645823},
{-0.07364672322335858,0.012011024583221131,0.11309302998527769},
{-0.08353275155538108,0.010441796582335999,0.11045657564081539},
{-0.11722306084297913,0.07027023521938804,0.1071414193786149},
{-0.14173846578242685,0.09250907074846068,0.10066078872619917},
{-0.16928749537647828,0.10581400595431263,0.0670104666534997},
{-0.19622482865613508,0.08472020972753849,0.0463295114021652},
{-0.17281987948177652,0.08929604399458238,0.06675433233104118},
{-0.18657602177465962,0.03713542399821896,0.05617933509367141},
{-0.20675983867860628,0.03251095663197425,0.04610850098468517},
{-0.19802209185549594,0.020958434100664648,0.04569782148032129},
{-0.2033771364452933,0.02919904257638713,-0.035050414961918935},
{-0.19240496889778216,0.01831711644628225,-0.03402155472993365},
{-0.1814203728915863,0.030207909200923158,-0.04192551408563154},
{-0.19345382273721673,0.08058099261776576,-0.03456624544098468},
{-0.04683421489831765,-0.03136591732967539,0.11657840209468162},
{-0.05503537652691045,-0.0345340935587351,0.10793521963112876},
{-0.06323653815550326,-0.03771577898201727,0.09929365827088259},
{-0.09341877988740357,0.008872568581450867,0.10782066166412198},
{-0.1222284874862983,0.06893606719797432,0.1048097324558121},
{-0.1462575614337362,0.08374754774351889,0.10324590813261597},
{-0.025976019018783995,-0.06115801353242996,0.1084220909909075},
{-0.025913876725360514,-0.06688104857284813,0.07093623849455702},
{-0.034389004812785534,-0.09157369414049499,0.06726606060818932},
{-0.0210327346688883,-0.11553306064574487,0.024957966142176703},
{-0.0226808563640328,-0.08261547726767353,0.019291129349724125},
{-0.02445326264602426,-0.11818302418442966,-0.013711832135833327},
{-0.11919540319946352,0.030377584680357665,-0.11442773837446028},
{-0.10344260200049551,-0.026060586574616747,-0.11171887474896541},
{-0.0699392599609368,-0.05329782396601298,-0.10175935640037254},
{-0.07772866134962794,-0.07963048571227091,-0.07850192762692362},
{-0.15534438583555582,0.04698200548311186,-0.08640102367270142},
{-0.144872058474277,-0.013062580261500093,-0.08914825340978817},
{-0.12441319437596034,-0.05485030056606215,-0.0883593164671944},
{-0.16605447501515055,0.009640431181057596,-0.06493329294984873},
{-0.15811593212224306,-0.040031254871753116,-0.07262758961121349},
{-0.18489061470346102,-0.02550292703711216,-0.04066375534525043},
{-0.20133022333670075,-0.012688105397652477,-0.004861688816791821},
{-0.204063943879565,0.0014571016888384615,0.020058451581561897},
{-0.16410752994380448,0.07308284945651164,0.08177601593868772},
{-0.031268380947388985,-0.160832090712618,-0.004166235498217733},
{-0.06694346105015613,-0.14590875403891124,-0.07377208854574335},
{-0.12709666071631692,-0.11743407445673444,-0.10515232562129459},
{-0.15204922318080463,-0.11121768364331075,-0.10603312508460133},
{-0.20594874665748764,-0.10288197044026193,-0.05694071328005128},
{-0.22419804694877288,-0.09765769485053831,0.019113888721524985},
{-0.21373760767840985,-0.08101977124611232,0.07406550824425595},
{-0.1826686224377449,-0.07156711786474751,0.1169788146114364},
{-0.1570670782828085,-0.07175300437724899,0.13491848417114202},
{-0.13092894893335455,-0.07776567654179753,0.13591978564691343},
{-0.07765355022975087,-0.10795602379023138,0.1146633387217006},
{-0.04031846034092343,-0.143229070272937,0.0699749242336842},
{-0.0456735049307208,-0.10667265033909426,-0.059969474624734856},
{-0.07887694285854009,-0.086783333869198,-0.08754444187169347},
{-0.11939479890618757,-0.06436725771192615,-0.10548303069586129},
{-0.14027839207085951,-0.05460443323121279,-0.10479027921613172},
{-0.18908494932566156,-0.03722512504785627,-0.05961445300056766},
{-0.20392669046626447,-0.024836113210289786,-0.019865540288064656},
{-0.20694734629441452,-0.005362339554677504,0.020810103148101566},
{-0.20658529988925164,-0.0271532102033322,0.06858942127422503},
{-0.17660245386407536,0.0001802126509282079,0.10622009233264067},
{-0.15222376197015927,0.0063576969849910665,0.12316170262318832},
{-0.12576087159159652,-0.0016013798831346069,0.12384796968969111},
{-0.20202945922965712,0.015612035395169636,0.048863295870536526},
{-0.1912691158475547,0.04034737001655968,0.06975391381620416},
{-0.16736540722250154,0.07400039392810355,0.09111411135304577},
{-0.03639917291309293,0.6343255656367167,0.06754326927363494},
{-0.03335311979980455,0.6669097421013769,0.0699911352667512},
{-0.026737397205163865,0.7073281704795468,0.07372993985976917},
{-0.06448478770166187,0.6326466429787448,0.047114665770376665},
{-0.0601531996661608,0.6716385004470194,0.05591833746129278},
{-0.053974094228791174,0.7137266652310896,0.059540962983997275},
{-0.07418330841787611,0.720926525383911,0.033101848787266124},
{-0.08139829886822672,0.6833569158833812,0.025452402650720053},
{-0.08504307946945612,0.7344227507799533,-0.0031897909398157314},
{-0.09164637360541211,0.6942615374597798,-0.01781430423732088},
{-0.0696896100517051,0.7471338218077842,-0.052556709570966906},
{-0.07548181216654243,0.7055844036893071,-0.06528885494178484},
{-0.032379377080247046,0.7080133568105117,-0.08534730652334672},
{-0.03040757509153155,0.7503965623964015,-0.07312797016521475},
{-0.041030124692564514,0.6709603388970501,-0.09687227029844243},
{-0.05016720329689184,0.6410061323636254,-0.11930942079870138},
{-0.08187274176932079,0.6754205344615494,-0.07614376268344474},
{-0.07439567295105376,0.6544834448877562,-0.10694418514296646},
{-0.0930070196475019,0.6694899981978736,-0.07806747194072815},
{-0.08445678044019979,0.6499638088686781,0.01474879788435211},
{-0.04026874650618465,0.6420247256080016,0.08007709967326662},
{-0.06724336516189554,0.647395981230866,0.0709535302631618},
{-0.0896740312489277,0.6598860418412168,0.054326954381882765},
{-0.08932495367021842,0.6467859060197781,0.02766304719328928},
{-0.23040200930351187,0.3677918654657173,-0.053329435480493674},
{-0.27297974728620555,0.3081855179816833,-0.04768637486987269},
{-0.29954260570201474,0.3165374422177991,-0.07919467910665319},
{-0.2551049218587679,0.38491125675223314,-0.08837282566141691},
{-0.3242455182572707,0.3247661626026058,-0.09675014718267107},
{-0.284176707825579,0.4072068308970403,-0.10859338757364875},
{-0.3425693893006641,0.332819803830289,-0.09797732238584259},
{-0.3022633574184254,0.4187977195399419,-0.10810921805271449},
{-0.37508656016198066,0.34622686854446266,-0.06755083442239955},
{-0.3424072789699942,0.4392338881919646,-0.06861211672051883},
{-0.3901276970093076,0.35684833740995797,-0.01725664469981625},
{-0.35336701805882065,0.4480878140853885,-0.017361476046982818},
{-0.3398734945016229,0.4395500033367711,0.025330279534948687},
{-0.3728769963549492,0.3503077259351942,0.02616028442797884},
{-0.3049473641265509,0.42206478307071027,0.059061656772983126},
{-0.34349341818548285,0.3382721146184883,0.05411350911316733},
{-0.286248477851541,0.4076034608394128,0.062300621179768735},
{-0.32549376780342937,0.3309647212796557,0.05527908239068428},
{-0.255217318354699,0.38010468544786896,0.038487694339890785},
{-0.29750758068433797,0.3200152491784384,0.03625327361548997},
{-0.27392809272062474,0.30894581543252536,0.005929455528137894},
{-0.23296065068925262,0.36094378473044975,-0.0005998082234788193},
{-0.2063480784387046,0.4005095127692957,-0.004915185225912906},
{-0.20642318955858166,0.4053879529869233,-0.05156351361172901},
{-0.20448813257815135,0.4431688462850933,-0.015720919500602917},
{-0.20848253112585896,0.4404848395769677,-0.05266586386028468},
{-0.23468334313650527,0.4292792331532918,-0.08771898066104811},
{-0.2569270419754981,0.47100481116443044,-0.10839993591238262},
{-0.2730921437821367,0.477816146891413,-0.10782714607734878},
{-0.31370996786703065,0.4950036245168099,-0.06836624938566939},
{-0.3269538415149967,0.499906921651807,-0.01883938189492387},
{-0.31227475107283265,0.4960232984967239,0.023718362480320478},
{-0.2730046042035749,0.48385259523779306,0.05693314813128667},
{-0.2556290785946007,0.4738217483437052,0.057236294449639485},
{-0.24258460065335868,0.43952892899378393,0.04452576378957755},
{-0.2287414591496827,0.416309866331927,0.03172985502202944},
{-0.22300005160512193,0.46406702937952543,-0.0907099162619087},
{-0.24362102603410857,0.49818260810124776,-0.10272175139678315},
{-0.27952035876096915,0.5217712823170323,-0.08654043855707758},
{-0.29620961730344053,0.5295152928131357,-0.06224334219626536},
{-0.3028501968154506,0.5361072392259447,-0.019352190907609812},
{-0.2871725067363597,0.5260147904062026,0.019142528213276673},
{-0.2611586619737527,0.5074747722552493,0.04120520384968806},
{-0.2339468218674948,0.48625831254493496,0.0571703695818337},
{-0.22363660483688594,0.4602758091129244,0.03787978059987847},
{-0.21245207275619715,0.47982469388841364,-0.09119300504730514},
{-0.22982759836517136,0.5263357688609291,-0.10580508988612561},
{-0.2631185758715524,0.5547596538728294,-0.08751418127663507},
{-0.2746900112747735,0.5724188725604761,-0.0660518542314714},
{-0.28040656190196483,0.5873476129118718,-0.038858926997124975},
{-0.2814927011174535,0.588996815342554,-0.010623089968801869},
{-0.2708328661403665,0.5686465651657863,0.021374247098832993},
{-0.24585544675850937,0.5536783779672609,0.045036411331187895},
{-0.22167669093908624,0.4974390620512416,0.06363749104002693},
{-0.20843281729112018,0.4538000417704287,0.034485730643418595},
{-0.2077211529394791,0.48754763004152996,0.07277835221873655},
{-0.1916435907114023,0.554174435579111,0.06678837550048188},
{-0.17589078951243428,0.5543041238436468,0.07407793670294065},
{-0.1859891823776344,0.5986132001578955,0.051818026830880826},
{-0.16144838015304838,0.6031231095571336,0.05744487640843482},
{-0.1850030111993922,0.6269695391986833,0.03255607734067729},
{-0.1544333257771907,0.635899656947522,0.037732800566737716},
{-0.18763676370501,0.6480649565287641,0.004405618419840358},
{-0.1538464863801655,0.6567702812857403,0.011588186804056972},
{-0.19827174176472767,0.6521193358988194,-0.053381851154076954},
{-0.2092563377709235,0.6174417746974414,-0.08747311332619867},
{-0.21174040840455607,0.5816921238425661,-0.10440823920351952},
{-0.21513607946432264,0.5344542542208802,-0.11532636997414071},
{-0.23911489920925283,0.6301042126260712,-0.008792323967769227},
{-0.24455694300984307,0.6231599464279395,-0.04893840699041361},
{-0.24475687908433602,0.5995982906005999,-0.07747090592386272},
{-0.23935212065979986,0.5731127047757435,-0.09643295130232686},
{-0.233422665131662,0.6009610981137654,0.031537484096301104},
{-0.3701184188947156,0.3433002367081012,0.01738849443542781},
{-0.3476374986051757,0.33054647662652736,0.032813292398673616},
{-0.3284765978877564,0.3227273550105466,0.03634351503289624},
{-0.3031122751833671,0.3133109062696981,0.02122834780123004},
{-0.2851374817186829,0.30595974314158475,-0.0024700210716411494},
{-0.2817050656506312,0.3029752919539511,-0.04380059024371397},
{-0.3447789531076956,0.33182876934212663,-0.07943784460265813},
{-0.31505818545043573,0.31635263644083544,-0.08271085217888444},
{-0.36888259780724164,0.2692622872200593,0.04746374334908596},
{-0.33132271492655185,0.258230679217969,0.03377298555623972},
{-0.36420193219303126,0.27024845839830136,0.03631811774775794},
{-0.40413348921142245,0.29035824491790885,0.030828521583504517},
{-0.4089762651563027,0.346419239470191,-0.019675871201180813},
{-0.4107238145209248,0.31868432336363806,0.0026753608238230843},
{-0.40229840026823854,0.33792141593647224,-0.005172400283909228},
{-0.39849096896857034,0.34961497445546474,-0.03165258243107677},
{-0.41464364231652423,0.3571666140258398,-0.027006500354075983},
{-0.4181511695044531,0.35296633535818156,-0.047806336514568455},
{-0.3952957743510656,0.34311380982783085,-0.048958400597862904},
{-0.4103369111983925,0.34608853439562437,-0.051673208268815676},
{-0.39057728299303224,0.32845093041873386,-0.07446105745109065},
{-0.38298781767883405,0.33143051829644743,-0.06825979693519614},
{-0.3577980337637993,0.3115671394794584,-0.08598277901957294},
{-0.36002002602951544,0.3071269375224084,-0.09214891563048896},
{-0.3260303529979469,0.29110557354229716,-0.08732559292528902},
{-0.33061159094267967,0.28711009425905193,-0.09642916872794455},
{-0.3582103343714699,0.3034410889707426,-0.09973946168022495},
{-0.2814429872827147,0.28685774251097573,-0.009849283323737305},
{-0.29861857681719606,0.27035220900993023,0.008190354273214805},
{-0.2721308295212639,0.28119955160282534,-0.009085743666281836},
{-0.2697591553835625,0.27701440323269616,-0.03019737202942951},
{-0.2785720133265499,0.2787841076758431,-0.036672058636387346},
{-0.29029313060175627,0.29170484139800706,-0.05551035979577341},
{-0.32053805499484894,0.3037291049915662,-0.08502416659754464},
{-0.29889308364379713,0.28043439084206323,-0.06722012934783285},
{-0.376983791398588,0.19730583437781937,-0.051858014045779416},
{-0.3544029030718016,0.19090139558081842,-0.03511039578426682},
{-0.41253404654673925,0.13848247979092101,-0.0272685787219924},
{-0.3955827096363514,0.13288751191173212,-0.010182690237148503},
{-0.3512822792064051,0.3216979544107925,-0.08271625585657344},
{-0.3790436733336342,0.3388351778336819,-0.06790531567879783},
{-0.38292567538541056,0.32011629795122265,0.02158877310308623},
{-0.4530519025943867,0.2504801843086388,0.008502146475870012},
{-0.459405546821111,0.2547242327655781,0.0040608637832822625},
{-0.4610282712311172,0.2490071417706178,-0.01654119777379287},
{-0.4535387739541655,0.2455158256157558,-0.019940111040172834},
{-0.4335294958395735,0.2313257680044463,-0.04348609620221427},
{-0.41404437446081427,0.2171557040005857,-0.05646518964341942},
{-0.41048659307037777,0.21093661134831762,-0.06437563341234412},
{-0.38062857199981737,0.19768193034497367,-0.06057468652590267},
{-0.41569195578818985,0.13868187549764507,-0.036816877198452495},
{-0.4442395850191682,0.15026465862401298,-0.03983969449767818},
{-0.44777196912446643,0.15494532423822346,-0.03234425317526856},
{-0.4661839201141906,0.16932775277526135,-0.01738525222881441},
{-0.4807506140604234,0.17987411052087943,0.0014784462157099486},
{-0.48821525442000574,0.18535398006529263,0.005003265172243575},
{-0.4860310878981126,0.1918437969697797,0.021147292635895064},
{-0.47970230058875774,0.1882876366826498,0.024830439348716343},
{-0.43430330248463805,0.24109831910499963,0.03940631954702051},
{-0.45815729727495236,0.18661735990898043,0.05117120661150773},
{-0.394684078036671,0.22250048160277403,0.057649675792847854},
{-0.42200831463886007,0.1683005136465829,0.06679540028147757},
{-0.35962069424829846,0.2029191747611508,0.044540353719337844},
{-0.39472136341272507,0.14950165933432633,0.05517208957244211},
{-0.34301897528438885,0.19507033291788073,0.0252913730555879},
{-0.3851222703659884,0.13509545461545686,0.039440362716461196},
{-0.3780196764115689,0.12900442912441795,0.03595877318143955},
{-0.33527982809820533,0.18797800595107034,0.01974503827559999},
{-0.3769713629399033,0.12656142644122179,0.019825012705397167},
{-0.330960668521389,0.1874095390581877,-0.0023176373608113964},
{-0.3841236707290615,0.13055096167900923,0.012444129349994311},
{-0.3388122122035036,0.1890387478814207,-0.007314418119828176},
{-0.3013895827361144,0.27683932407557266,0.007574875384437892},
{-0.3167057667778113,0.28815084258195284,0.0229921081989191},
{-0.3489857161885808,0.3008570502998636,0.03227130352646708},
{-0.13287589400470068,-0.8839354876535421,-0.014434303842852407},
{-0.14442247249055234,-0.892594340782393,-0.009416448740848536},
{-0.14574583315658804,-0.9008041482952882,-0.045737808695219886},
{-0.13653364343238364,-0.8918081056786438,-0.04839425664713147},
{-0.15950143508170225,-0.8926370298361361,-0.07478095517027934},
{-0.15032653073355196,-0.8848876156623435,-0.07777189077113993},
{-0.17495487253669975,-0.8667458485570695,-0.1005597399534149},
{-0.18857322104851343,-0.8792504990971804,-0.088739195008731},
{-0.19475178611811414,-0.8650291001552747,-0.10116279038350712},
{-0.2260952781853802,-0.8750653507270513,-0.07674465164246135},
{-0.22047815522766642,-0.8851934638195409,-0.07557745726163771},
{-0.23641846404244266,-0.8936540019772057,-0.042354025726369114},
{-0.24493141787369066,-0.8831562773307885,-0.041334351746455125},
{-0.23737977830331544,-0.886703791733616,-0.007154469260233823},
{-0.24535614694004593,-0.8760947513268055,-0.01054743848115589},
{-0.2264573245905431,-0.8713027699522017,0.01836331789052311},
{-0.23108827637001467,-0.8592433824536642,0.02575284713022836},
{-0.2044135618260432,-0.8698113549100382,0.04356823210308704},
{-0.20840796037375078,-0.8575682423700746,0.05920755607058608},
{-0.17762591041837164,-0.8703317290714887,0.050852929995625726},
{-0.18265619397906022,-0.8580426852711686,0.06321816565136067},
{-0.14774303243044185,-0.8645962655723859,0.029916921157370494},
{-0.15454572227312188,-0.8748367751608066,0.027928908135587998},
{-0.14057775581483,-0.8038675742323468,-0.05447825735717472},
{-0.17998515609738833,-0.7967552536580872,-0.08849548914495717},
{-0.19436488279558187,-0.7977873560966857,-0.08636589976772292},
{-0.21962923746272478,-0.7994235897009145,-0.06768106305470441},
{-0.23706744573289137,-0.7965477524348296,-0.026246743271002813},
{-0.22519664658569977,-0.7890723047198692,0.016167803645483078},
{-0.2037770085942792,-0.7909657533820943,0.048122992027143756},
{-0.18461610787685992,-0.7911165159896173,0.04846504482485735},
{-0.16213518758732004,-0.7959609130378044,0.027048649040050166},
{-0.13693297521360062,-0.7992063618578168,-0.004332128403269984},
{-0.13165304174368034,-0.7272585548998792,-0.06311603614303858},
{-0.17964796660959484,-0.7238445113359702,-0.09678148851326726},
{-0.19884615270306819,-0.7248533779605061,-0.09310266474259717},
{-0.2175947528128169,-0.7258044252337698,-0.07768705303142266},
{-0.23741706367936954,-0.7251954307582198,-0.037192432797837884},
{-0.23005239135703368,-0.7237834497780844,0.014104139136054605},
{-0.20090549427034546,-0.72707645096176,0.05320947383579791},
{-0.18168245125950272,-0.7260654228661484,0.05317813250520172},
{-0.15655535000566034,-0.724163328319621,0.030264377632773086},
{-0.1268097254310311,-0.7253937457294058,-0.005339914292268176},
{-0.14709351037222423,-0.6535307765111857,0.03528817678023486},
{-0.11149354138933418,-0.6567600142981311,-0.009069532633214842},
{-0.1813209452221087,-0.6538377054039208,0.06291069639085665},
{-0.20224128339506584,-0.6529115150480265,0.06335649980019901},
{-0.23829083836168058,-0.653830680622925,0.02058639089177703},
{-0.24726580663533795,-0.6555555345412534,-0.038693034092072726},
{-0.2241234761966647,-0.6575851558812411,-0.0874217783881532},
{-0.20225371185375055,-0.6572717425752793,-0.1028676506943861},
{-0.17604047138441953,-0.6565244139508908,-0.10490267571206288},
{-0.12064304845234618,-0.6577958993111122,-0.07144310346178506},
{-0.14339901593625606,-0.9892088556550702,0.030283830872453482},
{-0.14148881587319515,-0.9873440464845968,-0.0029817493487892944},
{-0.1409522306786776,-0.9472590250198383,0.002840172993337534},
{-0.1456334366606569,-0.9295538750718351,0.059982443451188444},
{-0.15068857713871486,-0.9019075792793817,0.03720810346313598},
{-0.1429867153285855,-0.9096078199862044,-0.004387245915697767},
{-0.1737563368252799,-0.888181697581557,0.06743681682316167},
{-0.2168706600024911,-0.8926554023402787,0.06059684160442756},
{-0.23502053262429878,-0.9029234706849133,0.03429335971769026},
{-0.24334597883973855,-0.9109998073588904,-0.0005841375581807243},
{-0.23870259860158224,-0.9190037347518347,-0.045841559306848655},
{-0.21970434858260185,-0.9119449105866961,-0.08075634195877372},
{-0.18550231101785566,-0.9104578184866838,-0.09228022499833162},
{-0.15781602801050368,-0.9141814927821725,-0.07801397553160706},
{-0.14449758361042941,-0.9133028547899414,-0.045246074025521034},
{-0.14177629152624985,-0.9465538450814239,-0.04744807268378786},
{-0.1407150092281306,-0.9978228582591026,-0.026868166205237624},
{-0.144872058474277,-0.9988176753216471,-0.05854506518591489},
{-0.15588151139784226,-0.949590711942641,-0.08410662212595271},
{-0.1588146276474306,-0.9996130966774677,-0.08385967405556548},
{-0.18727471729984713,-0.9489876615125488,-0.10186040517315681},
{-0.1905579918636825,-1.0,-0.09619843169062434},
{-0.22814273166174168,-0.9994455826691088,-0.0785570451393514},
{-0.22276283015457493,-0.9495793642194941,-0.08930333895946242},
{-0.24495627479106005,-0.9980427879410448,-0.03387943800671299},
{-0.2422852369093882,-0.9505066353109262,-0.04767394641118799},
{-0.2507609053645821,-0.9878757683691943,-0.008396774760934547},
{-0.25101055527381383,-0.9497803810295248,0.0013082303685065001},
{-0.254942271160329,-0.9897670555603438,0.020472913660308067},
{-0.255179492610876,-0.9522768801218421,0.06137064824949212},
{-0.26123377309362983,-0.9931821798597907,0.060044585744611925},
{-0.26240691151991136,-0.993763615579127,0.1146757671803853},
{-0.25649042481822704,-0.955977858971037,0.11490056017224763},
{-0.24727823509402264,-0.9873878162738777,0.1669774231644315},
{-0.24588030367587876,-0.9560891747314304,0.16503263956416098},
{-0.21885543081766018,-0.9776611964336808,0.20426387995405795},
{-0.21814430683378802,-0.9510437608732126,0.20121674610523174},
{-0.18510297923663868,-0.9754419060068091,0.2133101767732101},
{-0.18499058274070748,-0.9524903253905574,0.20884241605994625},
{-0.15550703653399467,-0.9519834604233295,0.18402494553768353},
{-0.1570422213654391,-0.9825444999612286,0.1915279520088577},
{-0.14477209043703054,-0.9479728508425549,0.145508611706041},
{-0.1399660595004354,-0.9890440434855559,0.14642345433878848},
{-0.14304939798977787,-0.943024703182739,0.09988157840344561},
{-0.14001631370294307,-0.9943180329100182,0.07713966048152712},
{-0.17084807749306102,-0.9097801973044835,0.09670205445123897},
{-0.2250345362550298,-0.9132315262444467,0.08500849593224652},
{-0.17179642292748024,-0.9261836012972069,0.1390414902478478},
{-0.23107584791132996,-0.9283828981166291,0.12471147738439305},
{-0.1754541723551632,-0.9301180190225665,0.1696376536907254},
{-0.22990270948504843,-0.9349089196616325,0.16223299415349093},
{-0.21236453317763537,-0.9400953695075331,0.1979005091074935},
{-0.18809877814741938,-0.9377064036012269,0.19961185383159924},
{0.0,0.24036071710045145,0.1662149642425138},
{0.0,0.2793698663373306,0.16563947256863548},
{-0.4302343331848223,0.08206105993678242,0.008222776339348797},
{-0.444726456378947,0.0866860676707961,-0.007557583615833101},
{-0.44738506580193416,0.08513575254182247,-0.015964625364376744},
{-0.4721755179357519,0.09821481402027415,-0.020646912081893818},
{-0.4746466197429308,0.1028635979361194,-0.013786402887941505},
{-0.49092411804550057,0.11492136433135042,0.00033502801671789656},
{-0.5070638225670009,0.12677973501985712,0.0220048562851391},
{-0.5124064386981135,0.13307880210192252,0.023342806880935096},
{-0.5114953786397485,0.13655012464933505,0.04003044432009981},
{-0.5044424985200678,0.13229743030809357,0.044198300921624245},
{-0.4838215240910812,0.13211262453112968,0.06971878991122568},
{-0.451329750514903,0.1193340075321863,0.0831453078650799},
{-0.42796208671659847,0.10208817018774821,0.07603136618751356},
{-0.41705260183027965,0.08858600074624785,0.05885901885964569},
{-0.4089762651563027,0.08309748531753224,0.05428534606367748},
{-0.4099251509584908,0.07816176611640116,0.03552053492086178},
{-0.41778912309929017,0.08076579839472965,0.029356559781021366},
{-0.49279649236473855,0.12217526126106162,0.04000828924157492},
{-0.48544424850108736,0.10930045879925432,0.007055581958525152},
{-0.47210040681587484,0.09719405930482224,-0.009811997947683216},
{-0.46051654295396904,0.08913015108952997,-0.008496202430412117},
{-0.47795475122413567,0.12238114138101269,0.06286854770488247},
{-0.4573834906298878,0.11162458057329246,0.07348353215715084},
{-0.44431415577127636,0.10131328280714577,0.06449127211488867},
{-0.4317819464749514,0.09184117618610048,0.05197527385163068},
{-0.43054612538747744,0.08622675506723136,0.03308131481204793},
{-0.4425293210306002,0.08235718147413966,0.005279393102151392},
{-0.4415555783110427,0.09843204186337177,0.07333655212401008},
{-0.4640618958857209,0.11427724595082177,0.07883371343702811},
{-0.4846704418560228,0.12320736369966036,0.07405686235995357},
{-0.49547995870509515,0.11855641831273946,0.04446794443830526},
{-0.49701568390430845,0.10818946266639623,0.00946238000120502},
{-0.49103651454143177,0.09772091787949978,-0.018082867018464097},
{-0.4782044011333674,0.09026114082983752,-0.01821039381192446},
{-0.4601669250074909,0.0788447909762905,-0.015491803566589385},
{-0.46483570253078543,0.0645499020178144,-0.018127717543282785},
{-0.4448885667096169,0.06472173896832456,0.0004998401862323463},
{-0.4307460614619704,0.0710840290793512,0.026501796857923532},
{-0.4292854473826342,0.08417714011979407,0.05647491626325961},
{-0.4258654597732671,0.07515461948247366,0.08491987561814696},
{-0.4419176247162056,0.09581612149412774,0.08505875013475421},
{-0.44058237595925415,0.08976454285021851,0.10433042624479795},
{-0.4254785564507348,0.07091597470322338,0.10302489771513594},
{-0.4255655556615277,0.06692643946543582,0.12037178383235846},
{-0.43849763710683853,0.08007304691499995,0.12299418861482937},
{-0.4356763769854125,0.07025132234747654,0.13716425261868978},
{-0.42442970261130025,0.060240469060838166,0.13531835632012792},
{-0.43341709934364225,0.06180483375180324,0.15610036034424668},
{-0.42280697820129404,0.05280230672193192,0.15339798113197864},
{-0.43210670750406016,0.055887806682350036,0.16850017953719124},
{-0.4221331395934759,0.04789522701255257,0.1649418577789858},
{-0.4249414308884484,0.039579507416952944,0.18368667531435223},
{-0.43284322877307063,0.049595764381280355,0.18129879014358383},
{-0.43506468067101794,0.0439246046466765,0.19120589281859343},
{-0.43166954997902024,0.03360952430614759,0.19083033721920806},
{-0.424679352520532,0.031568555243012955,0.1731478827174987},
{-0.4408941681619093,0.031790646396030756,0.18976311087563083},
{-0.4382977010323456,0.025636938243799454,0.17198555164659515},
{-0.44818372936436807,0.031700945346393325,0.17697854983122965},
{-0.45070562574182366,0.03598119844384896,0.16255613407929304},
{-0.4403700114260765,0.02697975214951546,0.15829371311821114},
{-0.4420673065881909,0.031293508048642886,0.1453443399042955},
{-0.45250288894118446,0.04048840600424245,0.14940196148096432},
{-0.44471402792026227,0.03812537775084349,0.1258478708023894},
{-0.45524903794273347,0.04752615582639399,0.12972338844093903},
{-0.45984270434615093,0.048248627533413024,0.12054632262171312},
{-0.4470981305166484,0.03953357615659652,0.11064138141777913},
{-0.46804386597474373,0.043208076985115355,0.11831946704607689},
{-0.4504057216300842,0.03066235849456785,0.09779467807995444},
{-0.47502109460677844,0.03367274733510883,0.11690802643371051},
{-0.48586843719967376,0.020822261422901934,0.12049660878697432},
{-0.478416765666545,0.012094241219631699,0.10703280545706603},
{-0.4912110533307864,0.004439931773165537,0.12295906470985088},
{-0.5011970497000554,0.01755033458221335,0.12724310038168876},
{-0.5111830460693243,-0.00747571789884476,0.14041726658746673},
{-0.5022956173742288,-0.018683485793596195,0.13547398223757107},
{-0.5145657483026372,-0.01579251822998209,0.14478722073455974},
{-0.5062278736285128,-0.026778735339484584,0.13977585004578266},
{-0.5230041313817771,-0.035513780323750535,0.15509905886847528},
{-0.515576776398249,-0.045317672754900146,0.1491128647246029},
{-0.526748880020253,-0.04391974133675632,0.15904752615582643},
{-0.5200456178470505,-0.05317137790809038,0.15313049908637322},
{-0.5290454430380773,-0.0658910948202236,0.16007476528450498},
{-0.535898387083265,-0.06336703697169253,0.16607608972590657},
{-0.5401672924575737,-0.06723552982924641,0.16342612618722177},
{-0.5337266490200565,-0.06873451002017458,0.15027195358889306},
{-0.5441616910052812,-0.06914410878900068,0.1563300166460291},
{-0.544374055538459,-0.06677243465129931,0.14874919721613333},
{-0.5377583329438183,-0.050376595807340455,0.13398526903425204},
{-0.5255881700526561,-0.0575840211089265,0.14028109390970403},
{-0.535099723520831,-0.04259746140625838,0.12874478241146142},
{-0.5216807707157415,-0.05031823608829927,0.1350325017703799},
{-0.5129808496364541,-0.03273034594614741,0.12362695927221107},
{-0.5292329506538855,-0.02682088402545878,0.1193207685218483},
{-0.5250888702341927,-0.019079575368199826,0.11451852015963546},
{-0.5083747547743519,-0.025199780718759335,0.11887010180258584},
{-0.5139291950708733,-0.0005752214899937678,0.1028476570869368},
{-0.49335793447662546,-0.0022692744454948116,0.10457359174080287},
{-0.49761441139224943,-0.0064322677370991085,0.09132971809283681},
{-0.514578176761322,-0.0014176548417086591,0.09986428663484082},
{-0.5275351151240023,-0.02699434207927564,0.10942177136337221},
{-0.5159263943447271,-0.039748102160849626,0.10337937897153425},
{-0.5317294497462028,-0.03555646937749359,0.1123889307824012},
{-0.5205076322894598,-0.0480135675539415,0.10659834977087056},
{-0.5436499627281332,-0.06073598630491923,0.11987356474943282},
{-0.5340135843053424,-0.07233714193542978,0.1166794508674659},
{-0.5477567577717719,-0.0694575220949626,0.12248246033768123},
{-0.5390314394073463,-0.08045346582430532,0.11951908349303453},
{-0.5497291001282563,-0.09612359075463166,0.12400791854928546},
{-0.5575682153516862,-0.09023358207362338,0.12861779598576997},
{-0.5600771429026881,-0.09913181812409697,0.125213479041701},
{-0.5508028108850603,-0.0983590922145703,0.11085266521541896},
{-0.5621364844699653,-0.10138785355925381,0.11543120132130727},
{-0.562548785077636,-0.0935163162696899,0.10800276560224123},
{-0.5538980374653185,-0.0760467666689271,0.09798812974122058},
{-0.5419650960247034,-0.08502173494258451,0.1045011824597703},
{-0.5497042432108868,-0.06800717500323537,0.09391375676371583},
{-0.5373590011626013,-0.07696809371490135,0.1008763954659902},
{-0.5251012986928774,-0.05185342091974376,0.09014631267894617},
{-0.5377210475677642,-0.0461736153008375,0.08487286362225267},
{-0.5334018879909478,-0.037837902097788666,0.081488540285633},
{-0.5206448857027605,-0.04366090517545324,0.08656637620998477},
{-0.520307696214967,-0.01147606049201015,0.0703067100437887},
{-0.5014715565266565,-0.011752188421918046,0.0722639221027439},
{-0.5200083324709964,-0.011958068541868865,0.06568980782630851},
{-0.5009473997908237,-0.018566225987744978,0.05810412508649262},
{-0.5291826964513778,-0.03632379160933134,0.07204939609849068},
{-0.5166007733203141,-0.0482632174631732,0.06764161620757471},
{-0.532952842374992,-0.04528362958545949,0.07425355622783311},
{-0.521019360566608,-0.056895052203579134,0.0699608746716928},
{-0.5431884886534927,-0.06720580960195696,0.07927681500752598},
{-0.5309680715598228,-0.07691459730578022,0.07433623249647478},
{-0.5468954115481456,-0.07629155326823873,0.08107299747134902},
{-0.5358362447898415,-0.0853951290708943,0.07631343816287928},
{-0.544449166658336,-0.09845527767743448,0.07957131544157638},
{-0.5527870413324605,-0.09307429543472985,0.08391046862584206},
{-0.5577054687649867,-0.10278578497739775,0.07967020274328504},
{-0.5457098446631794,-0.1018396010140541,0.06606536342569388},
{-0.5577930083435485,-0.10549951191281265,0.07082600346970144},
{-0.5565944726321288,-0.09975594289717629,0.06321438307697835},
{-0.5471326329986925,-0.08385345982622307,0.05620797458542309},
{-0.5377583329438183,-0.08965052525098055,0.06170999920836122},
{-0.5427264742110833,-0.07552531177193882,0.05297495422409538},
{-0.5329652708336767,-0.08134345153968332,0.058976278665496956},
{-0.5221800705342049,-0.06006701100702119,0.05250159205853912},
{-0.5319542427380651,-0.05201336977933803,0.04488024504597585},
{-0.528820650046215,-0.04292708574528728,0.04234592020983561},
{-0.5180986727757044,-0.05138654316741419,0.04975544305699015},
{-0.5217434533769338,-0.014869029712932295,0.03585772440865529},
{-0.5049666552559006,-0.021176202311531125,0.03981483758030878},
{-0.5189973043753848,-0.016410698957603522,0.033670856047917655},
{-0.5009846851668778,-0.025821203652994135,0.028721627652564058},
{-0.5241524128906893,-0.038317208308802864,0.03761878296749985},
{-0.511233300271832,-0.04610660969749391,0.032180521741291906},
{-0.5269985299294847,-0.04776661948355431,0.03892701333600635},
{-0.5156767444354954,-0.05492649242147712,0.03364437802724156},
{-0.5337017921026872,-0.06405654624480864,0.041574815403615545},
{-0.5243772058825517,-0.07207398283197561,0.03644294270237381},
{-0.5372466046666701,-0.07333952414673894,0.04264042064388602},
{-0.5292702360299396,-0.0806642092541762,0.03767498121546544},
{-0.5368094471416301,-0.09243287889304572,0.03913073198488159},
{-0.5418278426114029,-0.08593171426541185,0.0437103488263077},
{-0.5483187402514277,-0.09400048579062416,0.03933012769160563},
{-0.536297718864482,-0.09398535549309502,0.028638951383922383},
{-0.5481685180116735,-0.09629110476299062,0.030809608711593023},
{-0.5436748196455025,-0.0901184837388477,0.022948338409638214},
{-0.5391065505272233,-0.07786672531458176,0.01820499013423546},
{-0.5462215729403275,-0.07326333229132409,0.02319312500894984},
{-0.5500538611573651,-0.08494932566155189,0.026494772076927835},
{-0.5508898100958531,-0.0828959281397325,0.03660937597519496},
{-0.5462340013990121,-0.06996654853326624,0.034340912081353446},
{-0.5428885845417533,-0.060687353205718164,0.03273818127879654},
{-0.5367348763895219,-0.04349501227040108,0.02980128245482593},
{-0.5340508696813965,-0.034027228591506996,0.028292035276288686},
{-0.5277971934919187,-0.004254045260663928,0.023922081129195718},
{-0.5283467475128898,-0.0015116788334971745,0.04124519106458664},
{-0.5403299431560126,-0.03515065318304984,0.05135601238847147},
{-0.5440368660506655,-0.044064559898821444,0.05383521971218391},
{-0.5552965092512313,-0.06747923569302022,0.05984032672796778},
{-0.558491703868736,-0.07658389223121362,0.06219957240698447},
{-0.5622240240485271,-0.09281708037673357,0.06663058811196312},
{-0.5617620096061179,-0.09093227759881085,0.07773622649839254},
{-0.5567690114214834,-0.07398364252726759,0.07423140114930821},
{-0.5533117384360622,-0.0648541290717048,0.07224663033413913},
{-0.5422644597686739,-0.04130706317412566,0.06688564169888385},
{-0.5389568686552381,-0.032198624061550045,0.06462582368934473},
{-0.5302564072081819,0.0009161935521697101,0.05573082984548453},
{-0.5297073935549796,0.0072601111590538244,0.07356458732248582},
{-0.5423519993472357,-0.027729782612748406,0.08918932136022456},
{-0.5459092403699033,-0.036308661311802194,0.09280546246970227},
{-0.5572310258638927,-0.06043500145764194,0.10238077933460735},
{-0.5604889031425898,-0.06922300248326005,0.10571592920425713},
{-0.5670797688198611,-0.09299432100493266,0.11429264643223531},
{-0.5651447118394308,-0.09092092987566405,0.12463042221905807},
{-0.556744154504114,-0.06592351688635768,0.11692639893785312},
{-0.5532739126922392,-0.057063646947475934,0.11392573671715232},
{-0.5422520313099893,-0.032880027818132714,0.10453630636474878},
{-0.5387693610394299,-0.023977468825507914,0.10170910219786485},
{-0.5270984979667311,0.010600124338623704,0.09246827298190875},
{-0.5208323933185687,0.017674078801291432,0.10971789290072931},
{-0.5303936606214824,-0.007154739444118267,0.12241113179218643},
{-0.5335267129455636,-0.015611495027400661,0.12669895003840664},
{-0.5398555002549186,-0.034449255819017845,0.13610729326272167},
{-0.542501681219221,-0.04276011210469729,0.1406896119429923},
{-0.5482312006728659,-0.06195289452048162,0.15385567263223676},
{-0.5428885845417533,-0.0589533130353187,0.16466464911354017},
{-0.5361728939098661,-0.03898618360670078,0.1546710875955066},
{-0.5331149527056619,-0.030584545535846195,0.1501984635723227},
{-0.5261620406232278,-0.011813249979803743,0.13986663183095782},
{-0.5232537812910089,-0.0034813193511371403,0.13517191665475609},
{-0.5150899050384702,0.020395370885471026,0.12162111411405488},
{-0.49672820825125374,0.031463723895846375,0.12370801443754605},
{-0.49031242173110595,0.04901649013301975,0.11873663096366756},
{-0.4788782397411855,0.061099653813388895,0.1189560202778409},
{-0.46345019957132627,0.07943865515431164,0.12070356964246295},
{-0.4537884238633972,0.06444453030287896,0.13517353775806276},
{-0.45109252906435593,0.05579216158725471,0.15431660633910832},
{-0.44934497969973386,0.04966817366231285,0.1669104175610879},
{-0.4488332514225857,0.045642433784009104,0.17632794703747426},
{-0.44387753861400536,0.041008780165693016,0.1898355201566634},
{-0.4693045439795871,0.09391240584429365,0.10518690915850419},
{-0.47666921630192294,0.10431880833776656,0.08981182502999717},
{-0.4977646336320036,0.08702812046850976,0.10706414678766223},
{-0.5169876766428464,0.08130994873801177,0.06380824725499928},
{-0.5044424985200678,0.12026884377238314,0.038981050112896334},
{-0.5061403340499511,0.11363204683475542,0.01572362133944741},
{-0.5201952997190358,0.06784992798248561,0.021732510929613584},
{-0.4995494683726798,0.07698106254135507,-0.015557728434395167},
{-0.4908614353843082,0.07267919473314355,-0.01653525372833497},
{-0.4799892358740436,0.07043126481452014,-0.019335979874542816},
{-0.47301146687423995,0.03745261987856323,-0.015215675636681572},
{-0.45099256102710944,0.042070062463812334,0.005332889511272476},
{-0.43706187994487167,0.054763301355269474,0.03213405011316652},
{-0.42871157681206257,0.05767534326187062,0.05843104758667701},
{-0.4288488302253631,0.05199986058511569,0.08888185209972055},
{-0.42873643372943193,0.0481038089713479,0.11235812981957391},
{-0.42763786605525855,0.04372899151433478,0.12690753199720198},
{-0.42552827028547363,0.037950838961488924,0.14652126090495932},
{-0.4238682604994133,0.03464054600920849,0.15765337731206483},
{-0.5124064386981135,0.049481746782042514,-0.007200940888359211},
{-0.5024328707875293,0.04445416506019833,-0.009815780522065515},
{-0.4901378829417513,0.0455424657467627,-0.01731770625770193},
{-0.4833719381073565,0.016222650974026493,-0.008466482203122624},
{-0.46301304204628635,0.021188090402447023,0.016442310472084193},
{-0.45043111891522253,0.036958183370019874,0.04775500157652297},
{-0.4390590792187255,0.0406343053018454,0.07453995114535002},
{-0.5258378199618878,0.04948552935642474,0.022333940256399103},
{-0.5312922922211628,0.022265043365864465,0.011750297134726922},
{-0.522729624555176,0.013867187869392108,0.011164538473239501},
{-0.500572924926976,0.02753633095148234,-0.010446389708371622},
{-0.4932585068071479,-0.00529857615794729,-0.00019777460341734168},
{-0.478416765666545,0.0010874901349110242,0.027776524424758246},
{-0.46848048313201485,0.015328882684266139,0.06287124954372697},
{-0.45690904772879376,0.026464241297985074,0.08502632806862022},
{-0.4838090956323965,-0.00034556518821139297,0.0795491603630515},
{-0.5290702999554467,0.07103809781899466,0.029025854706454666},
{-0.5356487371740333,0.05088508187787536,0.02910961171063414},
{-0.5394561684737015,0.022176423051764864,0.04113765787857558},
{-0.5290832687819003,0.012514106976066886,0.0440275447066519},
{-0.5243772058825517,-0.007007759410977484,0.006612480388027287},
{-0.5142663845586668,0.004838182818844709,-0.0011401759923786543},
{-0.5125312636527295,-0.014410797844905256,0.001125045694849456},
{-0.49992394323652734,-0.01821660804126675,0.006814577933595824},
{-0.4946191528492377,-0.020432656261524927,0.01776188856373759},
{-0.4903372786484754,-0.011018368991752086,0.04552760563311784},
{-0.5269234188096077,0.08083064252699758,0.05686722326348089},
{-0.532915016631169,0.06247002647531893,0.07471557067024247},
{-0.5371590650881083,0.029427618142631794,0.07877643445352472},
{-0.5270233868468541,0.021150805026393,0.08124645552516586},
{-0.5230289882991466,0.06562955682007623,0.07550342687729841},
{-0.5229668460057231,0.050093443096437075,0.10612660870862099},
{-0.5137919416575727,0.04021497991317919,0.10771042663926643},
{-0.5004356715136755,0.05980385190356714,0.10870686480511771},
{-0.4851573132158015,0.08226748042450222,0.10900028450363033},
{-0.5321536384447891,-0.03733373896940508,0.01405928861123592},
{-0.5237157957334182,-0.04239536386068991,0.008348682029502457},
{-0.5126436601486606,-0.04607148579251543,0.014596414173522356},
{-0.5353115476862398,-0.04654809016468511,0.01612133201735769},
{-0.5275102582066329,-0.051327643080604154,0.010651729460553558},
{-0.5168001690270381,-0.0548119344544703,0.017030230604647215},
{-0.12973041322193474,-0.4058283527185767,0.08665391578854653},
{-0.18434160105025882,-0.43290023757268953,-0.09293190852762481},
{-0.16917509888054713,-0.41654330520809146,-0.07711048062200652},
{-0.21479888997652913,-0.4095131205347046,-0.05608855330849623},
{-0.21213974018577303,-0.39886787548737784,-0.050377946726762775},
{-0.22743106731010057,-0.3927800922029523,-0.0016762208191272911},
{-0.22851720652558924,-0.3915080664749621,0.0440048492603581},
{-0.21303891215322235,-0.3903700519536591,0.08063583994630906},
{-0.16430692565052848,-0.398910564541121,-0.05968091823614234},
{-0.12080569915078504,-0.41397277573143504,-0.05136519864054277},
{-0.12405114797079744,-0.40257047543987956,-0.04219407686677476},
{-0.11756025033077262,-0.4253880448494441,-0.06053469931100408},
{-0.16377034045601097,-0.43543672387990534,-0.09616222705010803},
{-0.08136101349217265,-0.4034026418039854,-0.0050762148210450565},
{-0.11164322326131942,-0.4013757223028421,-0.05982843863705199},
{-0.16878819555801486,-0.3946800252784042,-0.07804747833327885},
{-0.21748235631688573,-0.38796595574982373,-0.059112991711028615},
{-0.24604241400654872,-0.3830426650073773,-0.009325126587904463},
{-0.24915060941326056,-0.38204298463491265,0.04155968510608635},
{-0.24231009382675756,-0.38160474637433484,0.07380451061187734},
{-0.2237490013328171,-0.3842012135038985,0.10048570956907561},
{-0.21513607946432264,-0.38500365964071487,0.10794278477989334},
{-0.18682567168389133,-0.3871332490179491,0.12284558747838191},
{-0.17579082147518782,-0.38716567108408306,0.12498274200438077},
{-0.14472183623452284,-0.39333450953384363,0.12182969607285021},
{-0.13463641219577632,-0.3948761787785149,0.11688154841303443},
{-0.10856042513974586,-0.39911752539660966,0.0979205837701081},
{-0.09997236018862078,-0.4004295383394984,0.08757146026013846},
{-0.08596710835427485,-0.40324809662208,0.05510184176248513},
{-0.0778907716802979,-0.3508491744396318,0.05461605113824418},
{-0.07505708310018716,-0.3542032371811931,-0.006835111908814022},
{-0.10633843287402973,-0.35221738563048616,-0.06250812240302628},
{-0.16484405121281495,-0.3453066222340262,-0.0798598718301689},
{-0.21184037644180254,-0.3389221770444746,-0.06067843713753143},
{-0.23933915183334628,-0.3340329294714689,-0.014349466103135134},
{-0.2435334864555468,-0.331923333701684,0.041258700258809136},
{-0.2356695143147475,-0.3298023902087522,0.07181487648678814},
{-0.2161719644773036,-0.3309868763581806,0.09970163593640197},
{-0.20728453578220804,-0.3312754327467731,0.10720356167203839},
{-0.1813458021394781,-0.33444468971137065,0.12081596613839414},
{-0.1695873994882177,-0.3363430016835157,0.12281046357340343},
{-0.1373198785361329,-0.34028768639648455,0.1196628213195619},
{-0.12558633280224188,-0.34157700389307954,0.11520748906498274},
{-0.100559199585646,-0.3453082433373329,0.09424446183828253},
{-0.09199599155189031,-0.3469444769415616,0.08627836018916114},
{-0.2363184960051962,-0.37986476215847736,0.1061325527540789},
{-0.2502740340048033,-0.37858787312056713,0.08557263988297796},
{-0.2454934003533465,-0.33147374771795934,0.08222019824472337},
{-0.23078891262604415,-0.33319860163628756,0.10522797710894057},
{-0.21196520139641842,-0.3335757783389797,0.12145035789908254},
{-0.2181815922098421,-0.3817068758826569,0.12223767373836959},
{-0.19467721536600593,-0.38350467944978667,0.13417115554675357},
{-0.18965881989623318,-0.33576751000963734,0.13234741432671662},
{-0.0756066371211583,-0.4015843042616374,0.06631339223161892},
{-0.08692788224737875,-0.3999577972772489,0.09105250942739118},
{-0.09566562907048909,-0.34833646431424753,0.10913861865246868},
{-0.10165722689205045,-0.3964740462711516,0.11055059963260395},
{-0.08061206376447747,-0.3508540377495519,0.09022250453436105},
{-0.06884069228676346,-0.35530180485536644,0.0647220091522089},
{-0.1169609824750627,-0.34566002275488666,0.12557660618240168},
{-0.12338919745389515,-0.39285790516167396,0.1270599157080317},
{-0.13894260294613914,-0.34243943085224365,0.13387989731931657},
{-0.14534596100760216,-0.3904538089578385,0.13522595343164606},
{-0.1652930968287707,-0.33988835461526756,0.13714696085008496},
{-0.1715343445595638,-0.3864091562076233,0.1383341488383579},
{0.1837174762771795,0.22726868679554627,0.04444957193416267},
{0.16776473900371855,0.22625441649332134,0.08687978951594666},
{0.16997430281075,0.13809665720392658,0.08329228789822066},
{0.19110700551688475,0.22797548783726718,0.0041386767420038394},
{0.17499215791275383,0.230350944549351,-0.05106043121888326},
{0.14897831315014687,0.23194989277752548,-0.08481828647759379},
{0.11198041274911293,0.23316572025755014,-0.11055708404583076},
{-0.16997430281075,0.13809665720392658,0.08329228789822066},
{-0.16776473900371855,0.22625441649332134,0.08687978951594666},
{-0.1837174762771795,0.22726868679554627,0.04444957193416267},
{-0.19110700551688475,0.22797548783726718,0.0041386767420038394},
{-0.17499215791275383,0.230350944549351,-0.05106043121888326},
{-0.14897831315014687,0.23194989277752548,-0.08481828647759379},
{-0.11198041274911293,0.23316572025755014,-0.11055708404583076},
{-0.07536941567061126,0.5148891584123239,-0.1787898625925819},
{-0.051640245834912786,0.5148891584123239,-0.1787898625925819},
{-0.05341265211690425,0.5131178328658702,-0.18587894735277885},
{-0.0735840405621662,0.5131178328658702,-0.18587894735277885},
{-0.01600245110819973,0.4508528759588489,-0.1802007628371794},
{-0.04026874650618465,0.4508528759588489,-0.1802007628371794},
{-0.03822129302982317,0.4531062095551613,-0.18716556301052933},
{-0.018049904584561207,0.4531062095551613,-0.18716556301052933},
{-0.04028117496486934,0.5150766660281321,-0.17878391854712403},
{-0.01597759419083034,0.5150766660281321,-0.17878391854712403},
{-0.018049904584561207,0.5131178328658702,-0.18587894735277885},
{-0.03822129302982317,0.5131178328658702,-0.18587894735277885},
{-0.05312571683161843,0.48311499323324464,-0.18680892028305543},
{-0.0738839446739056,0.48311499323324464,-0.18680892028305543},
{-0.05341265211690425,0.4531062095551613,-0.18716556301052933},
{-0.0735840405621662,0.4531062095551613,-0.18716556301052933},
{-0.07614322231567583,0.48294045444389005,-0.178848762679392},
{-0.07535698721192656,0.4510528120333419,-0.18019427842395258},
{-0.051640245834912786,0.4510528120333419,-0.18019427842395258},
{-0.050865898822079314,0.48294045444389005,-0.178848762679392},
{-0.0177500004728218,0.48311499323324464,-0.18680892028305543},
{-0.038508228315108986,0.48311499323324464,-0.18680892028305543},
{-0.041092266985987995,0.48294045444389005,-0.178848762679392},
{-0.015165961801942785,0.48294045444389005,-0.178848762679392},
{0.08328310164614935,0.622888141440183,0.09106926082822708},
{0.03965705019179003,0.6188710474461814,0.10153564414404799},
{0.0,0.6224109967002442,0.10214842119398042},
{-0.03965705019179003,0.6188710474461814,0.10153564414404799},
{-0.08328310164614935,0.622888141440183,0.09106926082822708},
{0.11749756766958024,0.6197545487483328,0.08594603401128774},
{0.08567963270122013,0.5862393186178583,0.11948287885251824},
{0.040780474783332785,0.5901548234713064,0.12408032783031804},
{0.0,0.5931257654647176,0.12562307781052706},
{-0.040780474783332785,0.5901548234713064,0.12408032783031804},
{-0.08567963270122013,0.5862393186178583,0.11948287885251824},
{-0.11749756766958024,0.6197545487483328,0.08594603401128774},
{-0.14173846578242685,0.6132679740504591,0.07306204529740896},
{-0.14991477049365026,0.634561706351726,0.05242431946758644},
{-0.14674443279351496,0.6620167119539888,0.019166304395108268},
{0.14173846578242685,0.6132679740504591,0.07306204529740896},
{0.12828276796905205,0.5805670781477167,0.11185504742672815},
{0.08746500780966518,0.5298697740695342,0.1506021182956909},
{0.04035574571697752,0.5381503697601551,0.1565985794271723},
{0.0,0.5437437165360373,0.15695900472902855},
{-0.04035574571697752,0.5381503697601551,0.1565985794271723},
{-0.08746500780966518,0.5298697740695342,0.1506021182956909},
{-0.12828276796905205,0.5805670781477167,0.11185504742672815},
{-0.15988833840423453,0.5594241084539728,0.09239964627525848},
{-0.15655535000566034,0.6075568271009568,0.06819603353846596},
{0.04244048456939308,0.49674577020374316,0.17237407607243413},
{0.0,0.48706346052059574,0.15395726177278993},
{-0.04244048456939308,0.49674577020374316,0.17237407607243413},
{-0.09150912019211155,0.4934846507184325,0.1623605209469513},
{-0.14612030802043563,0.5165680810702958,0.1418405952907489},
{-0.1975352204957172,0.47652196608489794,0.09386782550335934},
{-0.17179642292748024,0.5566693135681213,0.08779138994208069},
{0.09150912019211155,0.4934846507184325,0.1623605209469513},
{0.03793435774453736,0.4489929300982958,0.1665046013666441},
{0.0,0.4460371184024135,0.1666353703667179},
{-0.03793435774453736,0.4489929300982958,0.1665046013666441},
{-0.09809998586938286,0.44674986348959245,0.15393726816534065},
{-0.1379688602265816,0.4910162507500981,0.15297109059454775},
{-0.1666661713295452,0.43270948775026796,0.12762784223314547},
{-0.21238939009500477,0.4310943284890264,0.05630524078382507},
{0.14991477049365026,0.634561706351726,0.05242431946758644},
{0.15655535000566034,0.6075568271009568,0.06819603353846596},
{0.15988833840423453,0.5594241084539728,0.09239964627525848},
{0.14612030802043563,0.5165680810702958,0.1418405952907489},
{0.1379688602265816,0.4910162507500981,0.15297109059454775},
{0.09809998586938286,0.44674986348959245,0.15393726816534065},
{0.0423778019082007,0.39551813568796784,0.1705449311747082},
{0.0,0.39600338594444007,0.17368933122193636},
{-0.0423778019082007,0.39551813568796784,0.1705449311747082},
{-0.10183230604917401,0.3851338882730198,0.15840719034968012},
{0.14674443279351496,0.6620167119539888,0.019166304395108268},
{0.17179642292748024,0.5566693135681213,0.08779138994208069},
{0.1975352204957172,0.47652196608489794,0.09386782550335934},
{0.1666661713295452,0.43270948775026796,0.12762784223314547},
{0.10183230604917401,0.3851338882730198,0.15840719034968012},
{-0.1570422213654391,0.3665025479691223,0.1314298698551247},
{-0.19989446617473386,0.37881158537689186,0.06609022034306329},
{0.1570422213654391,0.3665025479691223,0.1314298698551247},
{0.19466424653955236,0.3430630152575541,0.06907359079515928},
{0.19989446617473386,0.37881158537689186,0.06609022034306329},
{0.21238939009500477,0.4310943284890264,0.05630524078382507},
{-0.19466424653955236,0.3430630152575541,0.06907359079515928},
{0.08790162496693625,0.22287387573108394,0.14227342987363772},
{0.06297445978758684,0.22379250093821368,0.1488518670922243},
{0.06317385549431087,0.13417574867278917,0.14414850603172014},
{0.0890877322196714,0.13483986066076728,0.13825795698294302},
{0.09575316864905085,0.22198389001570581,0.15329152868150536},
{0.09580288248378965,0.13676194881474388,0.15013632127889923},
{0.1271090891750016,0.22291872625590267,0.14093656001337954},
{0.12777103969190393,0.13729367069934126,0.1376684157470733},
{0.1255614758848725,0.13617024610779865,0.12215553783749682},
{0.12578626887673483,0.22396758009533724,0.12383175865662412},
{0.14261224046473792,0.22442419086005758,0.11412567279164527},
{0.17670242190132182,0.2240259398143784,0.10062566482122068},
{0.1548704833022307,0.22272149202025424,0.1239203789707237},
{0.14279974808054613,0.13633667938061977,0.11077377152115958},
{0.15624355780300514,0.13817663163372365,0.12081866797723864},
{0.17791284570365745,0.13899042549368681,0.09586610551275092},
{0.02342980609172797,0.13398121627598542,0.1518725229203744},
{0.0,0.1338785463998945,0.15140078185812483},
{0.06247515996912339,0.13627777929380963,0.15859415759771944},
{0.02791107599921431,0.1359243787729492,0.1636509191790841},
{0.02375402675306787,0.2225853193424914,0.15537140422400084},
{0.0,0.2227555351896949,0.1552152379387888},
{-0.02375402675306787,0.2225853193424914,0.15537140422400084},
{-0.02342980609172797,0.13398121627598542,0.1518725229203744},
{0.028310407780431285,0.22100906656061056,0.16679802106515676},
{0.06246219114266979,0.22033468758502361,0.16242266324037477},
{0.08783948267351277,0.2246576297362223,0.13227770688452856},
{-0.08790162496693625,0.22287387573108394,0.14227342987363772},
{-0.0890877322196714,0.13483986066076728,0.13825795698294302},
{-0.06317385549431087,0.13417574867278917,0.14414850603172014},
{-0.06297445978758684,0.22379250093821368,0.1488518670922243},
{-0.09575316864905085,0.22198389001570581,0.15329152868150536},
{-0.09580288248378965,0.13676194881474388,0.15013632127889923},
{-0.1271090891750016,0.22291872625590267,0.14093656001337954},
{-0.12777103969190393,0.13729367069934126,0.1376684157470733},
{-0.1255614758848725,0.13617024610779865,0.12215553783749682},
{-0.12578626887673483,0.22396758009533724,0.12383175865662412},
{-0.14261224046473792,0.22442419086005758,0.11412567279164527},
{-0.17670242190132182,0.2240259398143784,0.10062566482122068},
{-0.1548704833022307,0.22272149202025424,0.1239203789707237},
{-0.15624355780300514,0.13817663163372365,0.12081866797723864},
{-0.14279974808054613,0.13633667938061977,0.11077377152115958},
{-0.17791284570365745,0.13899042549368681,0.09586610551275092},
{-0.02791107599921431,0.1359243787729492,0.1636509191790841},
{-0.06247515996912339,0.13627777929380963,0.15859415759771944},
{-0.028310407780431285,0.22100906656061056,0.16679802106515676},
{-0.06246219114266979,0.22033468758502361,0.16242266324037477},
{-0.08783948267351277,0.2246576297362223,0.13227770688452856},
{0.14773060397175714,0.7423494055819451,-0.014866057690203376},
{0.1387178099542768,0.7285662449006169,-0.013521622681180586},
{0.1535098372601409,0.7425390746688291,-0.02034214466023431},
{0.1498272309150885,0.7555640993703906,-0.01755330660494226},
{0.15928907054852462,0.7593066865377909,-0.026064098965114673},
{0.1474809540625254,0.7711402003089284,-0.015495045773202787},
{0.15774145725839547,0.7749260168978406,-0.024169029199582946},
{0.149290645720571,0.7898915022575216,-0.014536433351174476},
{0.1393170778099867,0.785626919825364,-0.009531006707855302},
{0.1357220110434961,0.8003314075526664,-0.003012550311616585},
{0.12566144392211895,0.7948466746983331,-0.0010915428931776692},
{0.12632285407125235,0.8059587974979893,0.00916247588946561},
{0.11272936247680809,0.8007945027306135,0.010136218609023114},
{0.11199284120779761,0.8126458486381247,0.02723507592032061},
{0.12328976978441758,0.8144582421350147,0.026091657721328557},
{0.11241757027415289,0.824917060302071,0.03937659931973101},
{0.12172918766783486,0.8296441975444069,0.03839042814148882},
{0.11101909848824011,0.8453694399871609,0.04525201807097893},
{0.12079327069210033,0.8457341882311684,0.042118965746897684},
{0.11000807039262853,0.8651971545314027,0.03913451455926389},
{0.11988167026596631,0.8641845053324844,0.03710597395481391},
{0.11443962646537607,0.8793531689732715,0.02818720392912212},
{0.12010646325782864,0.8760752980871253,0.02484340817516994},
{0.11540040035847998,0.8834599640169103,0.009050619761303344},
{0.12106777751870146,0.8809396887427614,0.0051707791806025255},
{0.11512589353187885,0.8766010759262647,-0.013699944044917532},
{0.12197883757706657,0.8755614083389015,-0.012606780048433165},
{0.12265321655265357,0.8622159455503821,-0.025549668849122027},
{0.11407758006021318,0.8629324732119433,-0.02699677373423579},
{0.11443962646537607,0.8444108275651327,-0.031009544786085967},
{0.12432565479739857,0.8453294527722622,-0.029165809958599728},
{0.12537396826906425,0.8270066624644067,-0.024868265092539334},
{0.11512589353187885,0.8271304066834848,-0.026933010337505607},
{0.11604992241669759,0.8116321187036685,-0.019765572250818188},
{0.12713394609237103,0.8096473478884997,-0.015344283165679732},
{0.12083055606815443,0.8039805110960468,-0.024819631993338347},
{0.13615916856853608,0.8022426883512652,-0.02207942703724728},
{0.14017842403361305,0.7907285319315474,-0.03237127156371355},
{0.14678171816956903,0.7910408645019714,-0.03000878367808347},
{0.1481796495877129,0.7767708324608645,-0.03541732467700193},
{0.1544457542358754,0.7768405399030528,-0.03399561707702646},
{0.15199950934606585,0.7614449217993274,-0.03749557911619069},
{0.15750423580784847,0.7613098298571025,-0.03543083387122442},
{0.1541091051158508,0.7465556282950614,-0.04036277049797322},
{0.15093822704794657,0.7485663367631378,-0.04193686180877844},
{0.13808125672251276,0.7346761832635675,-0.04960630155277381},
{-0.15352226571882557,0.7425390746688291,-0.02034214466023431},
{-0.1387178099542768,0.7285662449006169,-0.013521622681180586},
{-0.14773060397175714,0.7423494055819451,-0.014866057690203376},
{-0.1498396593737732,0.7555640993703906,-0.01755330660494226},
{-0.15928907054852462,0.7593066865377909,-0.026064098965114673},
{-0.1474809540625254,0.7711402003089284,-0.015495045773202787},
{-0.15775388571708018,0.7749260168978406,-0.024169029199582946},
{-0.14930307417925567,0.7898915022575216,-0.014536433351174476},
{-0.1393170778099867,0.785626919825364,-0.009531006707855302},
{-0.13573443950218078,0.8003314075526664,-0.003012550311616585},
{-0.12566144392211895,0.7948466746983331,-0.0010915428931776692},
{-0.12632285407125235,0.8059587974979893,0.00916247588946561},
{-0.11274179093549279,0.8007945027306135,0.010136218609023114},
{-0.11199284120779761,0.8126458486381247,0.02723507592032061},
{-0.12328976978441758,0.8144582421350147,0.026091657721328557},
{-0.11241757027415289,0.824917060302071,0.03937659931973101},
{-0.12172918766783486,0.8296441975444069,0.03839042814148882},
{-0.11101909848824011,0.8453694399871609,0.04525201807097893},
{-0.12079327069210033,0.8457341882311684,0.042118965746897684},
{-0.11000807039262853,0.8651971545314027,0.03913451455926389},
{-0.11988167026596631,0.8641845053324844,0.03710597395481391},
{-0.11443962646537607,0.8793531689732715,0.02818720392912212},
{-0.12010646325782864,0.8760752980871253,0.02484340817516994},
{-0.11540040035847998,0.8834599640169103,0.009050619761303344},
{-0.12106777751870146,0.8809396887427614,0.0051707791806025255},
{-0.11512589353187885,0.8766010759262647,-0.013699944044917532},
{-0.12197883757706657,0.8755614083389015,-0.012606780048433165},
{-0.12265321655265357,0.8622159455503821,-0.025549668849122027},
{-0.11407758006021318,0.8629324732119433,-0.02699677373423579},
{-0.11443962646537607,0.8444108275651327,-0.031009544786085967},
{-0.12432565479739857,0.8453294527722622,-0.029165809958599728},
{-0.12537396826906425,0.8270066624644067,-0.024868265092539334},
{-0.11512589353187885,0.8271304066834848,-0.026933010337505607},
{-0.11604992241669759,0.8116321187036685,-0.019765572250818188},
{-0.12713394609237103,0.8096473478884997,-0.015344283165679732},
{-0.12083055606815443,0.8039805110960468,-0.024819631993338347},
{-0.13617159702722076,0.8022426883512652,-0.02207942703724728},
{-0.14019085249229774,0.7907285319315474,-0.03237127156371355},
{-0.14678171816956903,0.7910408645019714,-0.03000878367808347},
{-0.1481796495877129,0.7767708324608645,-0.03541732467700193},
{-0.1544457542358754,0.7768405399030528,-0.03399561707702646},
{-0.15201193780475053,0.7614449217993274,-0.03749557911619069},
{-0.15750423580784847,0.7613098298571025,-0.03543083387122442},
{-0.1541091051158508,0.7465556282950614,-0.04036277049797322},
{-0.15093822704794657,0.7485663367631378,-0.04193686180877844},
{-0.13808125672251276,0.7346761832635675,-0.04960630155277381},
{0.42871157681206257,0.05767534326187062,0.05843104758667701},
{0.4288488302253631,0.05199986058511569,0.08888185209972055},
{0.4390590792187255,0.0406343053018454,0.07453995114535002},
{0.42873643372943193,0.0481038089713479,0.11235812981957391},
{0.45690904772879376,0.026464241297985074,0.08502632806862022},
{0.4838090956323965,-0.00034556518821139297,0.0795491603630515},
{0.5261868975405971,-0.07336221959303278,0.02204700497111329},
{0.5304936286587288,-0.08199837727558992,0.024615913344463107},
{0.42763786605525855,0.04372899151433478,0.12690753199720198},
{0.42552827028547363,0.037950838961488924,0.14652126090495932},
{0.4238682604994133,0.03464054600920849,0.15765337731206483},
{-0.09439252260696107,0.2759855430007108,0.13784619674304135},
{0.14964026366704916,-0.37898828563732184,0.10541764619582443},
{0.13806882826382808,-0.39658266019270055,0.09316967034594074},
{0.19674898539196792,-0.3942471906955154,0.09237208751904458},
{0.1830684945867308,-0.3733473864977765,0.1045038842986148},
{-0.5261868975405971,-0.07336221959303278,0.02204700497111329},
{-0.5304936286587288,-0.08199837727558992,0.024615913344463107},
{-0.5354493414673093,-0.06901063795008236,0.015478834740135788},
{-0.5425513950539598,-0.0635604886329586,0.020378349300750595},
{0.0034199876093670596,0.48282913868349675,-0.17960635829138952},
{0.008238447004646892,0.46487433882626183,-0.17989221284113752},
{0.02139478107405119,0.451742861674227,-0.1801045773743152},
{0.039344717621365925,0.4469449362541652,-0.18017806739088554},
{0.057307082627365356,0.451742861674227,-0.1801045773743152},
{0.07045098823808496,0.46487433882626183,-0.17989221284113752},
{0.07528187609204949,0.48282913868349675,-0.17960635829138952},
{0.07047638552322326,0.5007855596440384,-0.17932158447717933},
{0.05731951108605006,0.5139418937134425,-0.1791108410473084},
{0.039344717621365925,0.5187652164186425,-0.179037351030738},
{0.021369924156681794,0.5139418937134425,-0.1791108410473084},
{0.008226018545962197,0.5007855596440384,-0.17932158447717933},
{0.0,0.9332137859705939,0.15452897087228595},
{0.0,0.9058949530460936,0.164266398067861},
{0.03255445623737059,0.9330840977060577,0.15042487766749174},
{0.0,0.9641703747153275,0.13458669836103754},
{0.0328662484400258,0.9640158295334221,0.12965854430867105},
{0.06192560594815226,0.931864487651651,0.1390231177437052},
{0.06391037676332136,0.9044932390535676,0.14748851921129},
{0.033902673820775685,0.9054794102318099,0.1593722871849352},
{0.034788876961771416,0.8902194244380783,0.16219949135181916},
{0.0,0.8916270824760625,0.16728705389601106},
{0.029258753214850497,0.8838809105088833,0.1520697571560228},
{0.0,0.8843261735504568,0.15947441669325726},
{0.0,0.8787355286134191,0.15841367476290685},
{0.024527833398132436,0.8768777442239414,0.15137808641183104},
{0.0,0.8741629365529888,0.15637108459646548},
{0.022518205665593947,0.871836112940106,0.15071181295277752},
{0.021345067239312406,0.8644390185516363,0.15456625624834008},
{0.0177375720141371,0.8631686139269528,0.16140028742161627},
{0.0,0.8683161572934924,0.1662338771144253},
{0.0,0.8462756367356059,0.1718845028738109},
{0.01748792210490538,0.8410816217409408,0.16636464611449905},
{0.0,0.8248981474301595,0.17557791657424124},
{0.014279758660947056,0.8218137282052793,0.17039146672834063},
{0.0,0.8198440876876394,0.17288958692396458},
{0.012394955883024429,0.8177782617071352,0.16717249592900432},
{0.0,0.8057264393573622,0.17631713968209625},
{0.012132877515108009,0.804486835695506,0.17221034463845747},
{0.0,0.8052184936545964,0.1792054054068659},
{0.013768030383798912,0.8034423047982228,0.17515264714011708},
{0.01294450990399556,0.7556354279158853,0.18707099865097185},
{0.0,0.7576888254377047,0.1928129465633015},
{0.0,0.7511795552935374,0.18357589992172774},
{0.005779233288383741,0.7496589603918531,0.1801018755354707},
{0.0098611714146531,0.7340855612921601,0.1765068087689801},
{0.0,0.7316204035304388,0.18310361849170928},
{0.01475420156204111,0.7136656036732041,0.1760999118389985},
{0.0,0.7114122700768917,0.18147873261062747},
{0.014679630809932932,0.6942080410506587,0.1693058678806209},
{0.0,0.6923291823181941,0.17272315365114346},
{0.0,0.6795532671580952,0.1508452837916958},
{0.012282559387093262,0.6841744923177266,0.14926362733212595},
{0.0,0.6777035882851511,0.12415273711135061},
{0.013194159813227285,0.686060375831187,0.12106831788647035},
{0.0,0.6846089480039221,0.10583967342333518},
{0.01781268313401418,0.6851282414298348,0.10687177586193389},
{0.0,0.6811300603077449,0.09049971319980665},
{0.02151960602866705,0.6781364228680399,0.09104440391085769},
{0.05292578075712549,0.6718405979925879,0.07585520629485222},
{0.06925299289443403,0.6882710203737561,0.06021588232735317},
{0.09254500520509254,0.6924415788141252,0.057811786123517804},
{0.11060733824833845,0.7124314036890369,0.023877230604377034},
{0.11652436531779163,0.719708536432811,0.001493576513239144},
{0.11778504332263495,0.7289753033016741,-0.0470033500099833},
{0.1113935733520877,0.7301824848973965,-0.06939727108873028},
{0.09273251282090078,0.7284435814170768,-0.09415746262748965},
{0.069015771443887,0.7247788072083982,-0.11103855172792051},
{0.032129727171015324,0.7198933422097746,-0.12142550098171315},
{0.0,0.7181506561550726,-0.12443102651233404},
{0.0,0.72251844883109,-0.13806828789605916},
{0.04031846034092343,0.7249933332126514,-0.13521082313411686},
{0.0,0.736798207492037,-0.15219242063956306},
{0.049068635622718466,0.740628874605768,-0.14752904679395754},
{0.049193460577334334,0.7593731517733655,-0.1527641297390591},
{0.0,0.7564243648584792,-0.1583412654818743},
{0.0,0.7797579854873429,-0.1514310424531832},
{0.042078438164230195,0.7842668141510432,-0.1462516173882783},
{0.0,0.7952924781076754,-0.1387686045245534},
{0.03527574832155017,0.7975404080262988,-0.13597868573372351},
{0.0,0.832389265810418,-0.1354242684028323},
{0.0348137338791408,0.8362485724159007,-0.13261111379793974},
{0.0,0.8728784823663138,-0.13377452560438108},
{0.03677364777694051,0.8721570913948326,-0.13171572440487272},
{0.03657371170244757,0.905116823458878,-0.12247381445337882},
{0.0,0.9110727570076921,-0.12610778769923023},
{0.03996884239444524,0.9365802771708398,-0.11318327140268396},
{0.0,0.9420239420747367,-0.11481572243253035},
{0.04176664596157499,0.9746697204650515,-0.07865052876337107},
{0.0,0.9775082723550822,-0.08129887119874916},
{0.03832126106706964,0.9928131086736324,-0.03262470404732757},
{0.0,0.9953144710758697,-0.03211675834456173},
{0.03765985091793624,0.9974554081762509,0.012176106936619992},
{0.0,1.0,0.014119809801352702},
{0.03598687230542235,0.9953279802700922,0.05737624970178454},
{0.0,0.997843392234321,0.0571606429619935},
{0.0,0.9879508794890717,0.09923421781630361},
{0.03255445623737059,0.9853571141983525,0.09816537036941972},
{0.0673557616578267,0.9027392052757188,-0.11030959560767464},
{0.07052609935796203,0.9378539240021367,-0.09652643492634654},
{0.07157441282962772,0.9667992639110253,-0.0719710427720002},
{0.07540670104666536,0.9794714284594954,-0.031918443373375495},
{0.07521973379862601,0.984507115697873,0.011470926998205707},
{0.07043855977940026,0.9844298431069203,0.05673213132125594},
{0.06487169102419416,0.9755207997010686,0.09475294790881726},
{0.061064259724525914,0.9579253444101522,0.122219301234227},
{0.08471885880811622,0.927773903641079,0.11970659110884277},
{0.08818856025222208,0.9035330055282325,0.1252885901615781},
{0.09074774200573169,0.8875467654530999,0.12961261304831456},
{0.06435996274704602,0.8892067752391601,0.15144076907302342},
{0.05795606431781406,0.8826186114007332,0.13654931409768176},
{0.053462365951643026,0.876341159029424,0.1366590087547684},
{0.04909349254008786,0.87027715192683,0.13843519761114217},
{0.03925717804280415,0.8626190599059815,0.13915064453716555},
{0.03518820874298839,0.8530702210617526,0.1512148953456233},
{0.03282896306397171,0.8469797359384824,0.15098145646945857},
{0.03146831702188192,0.8312766485742532,0.15517038741397007},
{0.030020131401230363,0.8127852635225009,0.15849959323816196},
{0.02638777925868567,0.8092264013965266,0.15691307346867206},
{0.023591916422397923,0.8011414188382472,0.16156293812005512},
{0.02622566892801572,0.7998261636887449,0.16420155393559302},
{0.020221642647769645,0.7499399516316811,0.17788258510859908},
{0.01406793449553832,0.7467793405513861,0.17469657674316566},
{0.01606513376939211,0.7347258970983064,0.16825701404118626},
{0.021507177569982355,0.7154228796576663,0.16761451676396438},
{0.022094016967007576,0.6970714498580589,0.1638697681254885},
{0.02023407110645434,0.6895933003042541,0.1464591186115358},
{0.020346467602385506,0.6942139850961166,0.12339622223489086},
{0.025576687237567015,0.6818990036428894,0.12613102351329292},
{0.02621324046933102,0.6715671719015245,0.10850963056946927},
{0.03367788082891335,0.666773569423614,0.09030139822862042},
{0.053075462629110746,0.657640273393669,0.10567486125382074},
{0.07402119808720617,0.6582595348568282,0.10510585399316921},
{0.07966317796228936,0.6736178675844995,0.0752002805589456},
{0.10663779661800024,0.6770729790988449,0.08303561320799323},
{0.12051876386549923,0.6999921376489625,0.059647955802239444},
{0.13069172748280752,0.7167413770137818,0.027114033540087047},
{0.13748198886680288,0.7254191430145445,-9.186252071298892e-06},
{0.13015514228828998,0.7362475727355281,-0.07630641338188358},
{0.11124389148010244,0.7354937596979129,-0.10308217669863934},
{0.08189759868669018,0.7309762851499103,-0.12365992170611396},
{0.08149826690547321,0.9492151563432556,0.10934233730134392},
{0.09786276441883582,0.9295603594850621,0.09072720803051348},
{0.10268122381411565,0.902078875862123,0.09447573924337165},
{0.1058142761381969,0.8856770929727064,0.0959271670706366},
{0.08152312382284259,0.8811234137841873,0.11715119192971545},
{0.08691545378869404,0.9597869113740122,0.0844821777253381},
{0.10474056538139292,0.9308523788205014,0.05671754139149564},
{0.10897218537964755,0.9000092673072367,0.057623738139940664},
{0.11140600181077238,0.8835361558723253,0.06000135632309994},
{0.10631357595666034,0.8781173478857976,0.06679053697155747},
{0.0979000497948899,0.8793893736137878,0.08622108120565776},
{0.08197270980656725,0.8754425274297434,0.11443152094884258},
{0.09227049837849141,0.9624330923383145,0.055812425378588416},
{0.09638972188081488,0.9606255621513446,0.012584084602139368},
{0.10818595027589828,0.9311782205851482,0.011410946175857827},
{0.11265425135693101,0.8979785652317113,0.010456116328211817},
{0.10826052102800646,0.8751669398676046,0.05870339294220253},
{0.10509018332787112,0.8710660888694236,0.06973554131206158},
{0.0956407721531197,0.873119486391243,0.08896560910390003},
{0.08954920629431184,0.8611000861076039,0.10191876489219798},
{0.07320956569831862,0.8631648313525704,0.1219231796968699},
{0.05434856909263876,0.8537554073927176,0.1297001526268763},
{0.050029949883591274,0.8430301879155936,0.14449920471373612},
{0.04618523320786895,0.8357444092875171,0.141942724799071},
{0.05197689495493738,0.8195306743816776,0.14105273908369298},
{0.046971468311618206,0.8001233659616399,0.14740746404595503},
{0.043476369582374066,0.7974080179229184,0.1456453247515727},
{0.04199089858566842,0.7925938814697897,0.14864328513342898},
{0.04400052631820691,0.7912580923450693,0.15063291925851816},
{0.03787167508334497,0.7724781509047244,0.15950305618500893},
{0.024328437691408397,0.7422942880695172,0.1718655900018994},
{0.019147931890965673,0.7412108506928731,0.17075135166242794},
{0.02445326264602426,0.725011165349025,0.16551464761401963},
{0.024178755819423144,0.7075778203887786,0.15165043176735654},
{0.027062158234272663,0.7031354569606528,0.13982556388052145},
{0.024765054848679465,0.6943750146912488,0.12889878722559786},
{0.029196610921427016,0.6839934691151451,0.12997465945347744},
{0.0364737436652011,0.671052741785532,0.13030644526358195},
{0.0348385907965102,0.66476178022,0.12283586085854171},
{0.03448897285003201,0.6636297097441547,0.10629898602690005},
{0.052613448186701384,0.6595629019154147,0.12473417283068684},
{0.07606811119579876,0.6614385184412661,0.12678648961696842},
{0.09061048859243112,0.6622739270119852,0.10963791847093213},
{0.10675019311393141,0.674618088324733,0.11776775155403016},
{0.12199126603575128,0.6910047409166205,0.09675987380251125},
{0.1333751938231641,0.7172331116834808,0.06861049561721212},
{0.12944347793664893,0.7222898732648454,0.06300580111818302},
{0.13588466174193495,0.7260319200644768,0.03222915484049289},
{0.14406042608538944,0.7367031027647107,0.002620783679164201},
{0.14575826161527275,0.7581681316487189,0.004519095651309323},
{0.13947918814065666,0.7766497900806311,0.011207227526982586},
{0.12382635497893511,0.7894267859762678,0.021570400598943634},
{0.11034525988042201,0.7939042733093716,0.03253230115884569},
{0.11171833438119651,0.812644227534818,0.051438688657113145},
{0.11012046688855968,0.8429242758328891,0.056044243151446446},
{0.10673776465524672,0.860955267545539,0.06432051589991633},
{0.09686416478190892,0.9537828850937661,-0.02993745513258869},
{0.10701227148184783,0.9281683721123761,-0.02993259182266859},
{0.11100667002955542,0.8980493534094369,-0.032195652038821104},
{0.1133783441672568,0.8754733283925707,-0.03127432499284688},
{0.10812326761470589,0.873007089895312,-0.07243413794994735},
{0.11216792036492117,0.8434246563868905,-0.07115562780873035},
{0.11613692162749045,0.8099829162729864,-0.07225311474736591},
{0.13643367539513718,0.7940890790863355,-0.07490037644720621},
{0.14502174034626228,0.7742094892362793,-0.07561204079884729},
{0.14374863388273423,0.7536868617412325,-0.0749430655009493},
{0.1245126220454379,0.7525547912653875,-0.10661618190724426},
{0.09124704182419514,0.7455083955589336,-0.1321463975166859},
{0.08817613179353737,0.9454255571799612,-0.07174895161898237},
{0.09735103614168768,0.9285968837531136,-0.0739558135871693},
{0.10437851897623003,0.898221730727716,-0.0716279092387488},
{0.08538026895724962,0.9016368550271631,-0.09691225751334101},
{0.09259525940760023,0.87149027756801,-0.10083532751555381},
{0.0940056192844288,0.840606098104309,-0.10201386961952436},
{0.09808755741069815,0.8091766875617878,-0.10468490750119624},
{0.11558790797428824,0.7942711830244548,-0.10805139870144222},
{0.1252491433144484,0.7713460804288792,-0.10990377941323086},
{0.06801717180696011,0.8700199368688337,-0.11942343839793926},
{0.06790477531102894,0.8399787311246162,-0.12080137620863383},
{0.07058824165138551,0.803737885967811,-0.12434618877261677},
{0.08293348369967116,0.7892808866786648,-0.13295911064111124},
{0.09265740170102371,0.7667037809262607,-0.1364466442215908},
{0.1048281049599547,0.8471472499468415,0.08393640627874925},
{0.09546623336376504,0.8544978727071858,0.09094929918353131},
{0.08900019264110962,0.8461383833223054,0.10032846254832577},
{0.07417087995919143,0.8459303417312789,0.11595805989598461},
{0.07291020195434811,0.8310923831650583,0.1314239258096668},
{0.06981443500632095,0.8223243757468895,0.12822711008885537},
{0.0729728846155405,0.8092355876485977,0.1297747233789845},
{0.06694346105015613,0.7874420151610987,0.13689136689539533},
{0.06459718419759304,0.7858068622924077,0.13694216146567192},
{0.06458421537113944,0.7827997156584802,0.1370124092756289},
{0.0657076399626822,0.7812656115625735,0.13907067010736837},
{0.05216440257074562,0.7600940023770778,0.1509004013041236},
{0.028497375028470627,0.7276670729331677,0.16700498192064533},
{0.032129727171015324,0.712819387747107,0.16386220297672394},
{0.029458689289343438,0.7102877647498111,0.16236808609571587},
{0.03691090119024107,0.70572543967699,0.15312077246653297},
{0.03183036342704481,0.7023827246585755,0.14212266726611464},
{0.02960837116132869,0.6993890872188703,0.13547290150203325},
{0.02866002572690948,0.6927463462357848,0.13153470120229127},
{0.03236694862156235,0.6925204725083846,0.13226635916138163},
{0.03315372409308051,0.6852368553513837,0.1313963670534529},
{0.039781875146405896,0.6735178995472529,0.13167735829328084},
{0.05242648093866204,0.6645645459843516,0.13288291878569636},
{0.13886749182626204,0.7417409514741637,0.03856658803415017},
{0.1324144199300602,0.7607435244352956,0.04912321276737735},
{0.1150134970359477,0.7763342153035936,0.059210257909430575},
{0.10356742695511138,0.7809462542111536,0.06250055725426168},
{0.10636328979139914,0.7947618369586158,0.07571579141047606},
{0.10605149758874392,0.8072616241888068,0.08404015689037803},
{0.10374196574446602,0.8406985009927908,0.07861918743277488},
{0.1012081812760947,0.8304055757307867,0.09963571106859617},
{0.09934823541554146,0.8189168165962072,0.09566400796718239},
{0.09414287269772936,0.8260653418109831,0.1137101299773613},
{0.0906980281709929,0.8151942230362564,0.11234029768320021},
{0.08846360744659208,0.7997310589614187,0.11783421678960485},
{0.0765425540968928,0.776214253658898,0.12733928584455295},
{0.07440810140973846,0.7750946116417374,0.1278877591299863},
{0.0738839446739056,0.7742019240875149,0.12928947312251246},
{0.07379640509534384,0.7724046608881541,0.1300946210981732},
{0.0581684288509917,0.7513951620333283,0.1454913199374362},
{0.05859261754957807,0.7390515410883494,0.14135858724089026},
{0.041341916895219724,0.7095912306956993,0.1564834810923967},
{0.03869573593091722,0.7045047488870452,0.150423256564185},
{0.03392753073814507,0.7017672457697985,0.14040591886431988},
{0.03255445623737059,0.6985482749704622,0.13533726919203942},
{0.04609769362930717,0.7027934041629395,0.12099212603105548},
{0.04705900789017998,0.6924626531571123,0.11612125096219236},
{0.05006723525964536,0.6880791898157967,0.11572191918097538},
{0.05694503622220247,0.6851044652480033,0.11725115996696192},
{0.05280095580250963,0.6680780172177382,0.13500764485301053},
{0.07061363893652381,0.6682341835029503,0.13798831346626203},
{0.08535541203988022,0.679468429418378,0.14218102698515583},
{0.09275736973827017,0.6735270857993241,0.13431219153443644},
{0.10565162543975805,0.6942712640796199,0.1311629281772882},
{0.12051876386549923,0.711950476374716,0.11192475486891625},
{0.12700912113775514,0.7403646347667759,0.08259467310857095},
{0.12327734132573288,0.7430832250121112,0.07768921450249826},
{0.09757582913355001,0.793778367619218,0.10246075376440453},
{0.09706410085640187,0.7798790278675765,0.09371814363137408},
{0.07957563838372758,0.7661493635953694,0.11824003298404862},
{0.08907530376098668,0.7625332224858916,0.09218998358092535},
{0.0821348201372372,0.7557018931514602,0.11083753491788977},
{0.07841492841613074,0.7660683084300344,0.11885389076951883},
{0.10427855093898357,0.7558791337796591,0.0906499354395608},
{0.10734946096964133,0.7524137552777046,0.09641674026925987},
{0.10163236997468107,0.7283436133798302,0.12612129689345272},
{0.08083685675633981,0.7373985560832849,0.13089436539614496},
{0.08054938110328509,0.7558888603994994,0.1100572438595984},
{0.09077259892310108,0.7104812164110774,0.14109380703412935},
{0.07605568273711406,0.7209616492888896,0.1419637991420581},
{0.06153870262561997,0.7307266352406785,0.14195623399329352},
{0.05703257580076424,0.7198430880072668,0.14614570530557394},
{0.043863272904906346,0.7086828724761787,0.15302728884251332},
{0.1267972969723464,0.8170844294918681,-0.008371377475796254},
{0.12702208996420875,0.8302407635612722,-0.01932463215139592},
{0.12636013944730645,0.8447653088215309,-0.024078247414407773},
{0.12482495461586202,0.8607256112437566,-0.021319669954174114},
{0.1242256867601521,0.8712671056794544,-0.010161615894161409},
{0.12337676899521045,0.8756521901240766,0.006185589850596416},
{0.12269050192870766,0.8723980954197619,0.021486643594764158},
{0.12270293038739236,0.8612946185044079,0.03258849940681128},
{0.12307740525123995,0.8454045638921395,0.03722107228958957},
{0.12383878343761981,0.8313928276445667,0.03405289606052983},
{0.12483738307454671,0.8184261626620463,0.02319582684779434},
{0.12606077570333593,0.813664441882501,0.008745852339643838},
{0.125224286397079,0.8322579564425753,0.00752354044639241},
{0.12612291799675943,0.8323962905914137,-0.01232470807306745},
{0.12504974760772436,0.8527605903301729,-0.01327683608186896},
{0.12401332222697446,0.8544033083476283,0.006403898429231949},
{0.12300229413136286,0.8538699653597243,0.026402369188445962},
{0.1238760688136739,0.833641297930959,0.026875190986233317},
{0.128844210080939,0.8527719380533197,0.02244039270687237},
{0.12978066742444241,0.8347393252373634,0.02290727045920183},
{0.13172761249578852,0.8343751173611249,0.007320362165286071},
{0.13233930881018313,0.8346858288282423,-0.007813177570522724},
{0.13102891697060104,0.8520899939289683,-0.00798555488880177},
{0.130392363738837,0.8529551227269769,0.00643632049536594},
{0.0630987443744338,0.6984445243588335,0.11851832238503203},
{0.06518348322684936,0.6872113591789437,0.11672322065674678},
{0.06926542135311872,0.6712915843393857,0.13909066371481765},
{0.08189759868669018,0.6818341595106214,0.14273058100612698},
{0.09266983015970841,0.6957459277209478,0.14234367768359468},
{0.08866300315331611,0.6954562905968174,0.14343954351892355},
{0.08712781832187168,0.7075464790581824,0.14230963451415396},
{0.07477014781490134,0.717176913435515,0.1419578550966002},
{0.05733193954473475,0.7155493257155887,0.14499364122227948},
{0.055809183171975016,0.7110545466138801,0.12475308570259833},
{0.06920273869192635,0.7120590902962647,0.12494653736386446},
{0.08021273198326048,0.7055995339868362,0.12203935876718336},
{0.07829010346151488,0.6955848981258155,0.11891981563732461},
{0.07334735947938807,0.6890723857750348,0.12032315073315748},
{-0.03255445623737059,0.9330840977060577,0.15042487766749174},
{-0.0328662484400258,0.9640158295334221,0.12965854430867105},
{-0.03255445623737059,0.9853571141983525,0.09816537036941972},
{-0.03598687230542235,0.9953279802700922,0.05737624970178454},
{-0.03765985091793624,0.9974554081762509,0.012176106936619992},
{-0.03832126106706964,0.9928131086736324,-0.03262470404732757},
{-0.04176664596157499,0.9746697204650515,-0.07865052876337107},
{-0.03996884239444524,0.9365802771708398,-0.11318327140268396},
{-0.03657371170244757,0.905116823458878,-0.12247381445337882},
{-0.03677364777694051,0.8721570913948326,-0.13171572440487272},
{-0.0348137338791408,0.8362485724159007,-0.13261111379793974},
{-0.03527574832155017,0.7975404080262988,-0.13597868573372351},
{-0.042078438164230195,0.7842668141510432,-0.1462516173882783},
{-0.049193460577334334,0.7593731517733655,-0.1527641297390591},
{-0.04908106408140316,0.740628874605768,-0.14752904679395754},
{-0.04031846034092343,0.7249933332126514,-0.13521082313411686},
{-0.032129727171015324,0.7198933422097746,-0.12142550098171315},
{-0.069015771443887,0.7247788072083982,-0.11103855172792051},
{-0.09274494127958548,0.7284435814170768,-0.09415746262748965},
{-0.1113935733520877,0.7301824848973965,-0.06939727108873028},
{-0.11778504332263495,0.7289753033016741,-0.0470033500099833},
{-0.11652436531779163,0.719708536432811,0.001493576513239144},
{-0.11060733824833845,0.7124314036890369,0.023877230604377034},
{-0.09253257674640784,0.6924415788141252,0.057811786123517804},
{-0.06925299289443403,0.6882710203737561,0.06021588232735317},
{-0.05292578075712549,0.6718405979925879,0.07585520629485222},
{-0.021532034487351748,0.6781364228680399,0.09104440391085769},
{-0.01781268313401418,0.6851282414298348,0.10687177586193389},
{-0.01320658827191198,0.686060375831187,0.12106831788647035},
{-0.012282559387093262,0.6841744923177266,0.14926362733212595},
{-0.01469205926861763,0.6942080410506587,0.1693058678806209},
{-0.01475420156204111,0.7136656036732041,0.1760999118389985},
{-0.0098611714146531,0.7340855612921601,0.1765068087689801},
{-0.005779233288383741,0.7496589603918531,0.1801018755354707},
{-0.012956938362680257,0.7556354279158853,0.18707099865097185},
{-0.013768030383798912,0.8034423047982228,0.17515264714011708},
{-0.012132877515108009,0.804486835695506,0.17221034463845747},
{-0.012394955883024429,0.8177782617071352,0.16717249592900432},
{-0.014279758660947056,0.8218137282052793,0.17039146672834063},
{-0.01748792210490538,0.8410816217409408,0.16636464611449905},
{-0.0177375720141371,0.8631686139269528,0.16140028742161627},
{-0.021345067239312406,0.8644390185516363,0.15456625624834008},
{-0.022518205665593947,0.871836112940106,0.15071181295277752},
{-0.024527833398132436,0.8768777442239414,0.15137808641183104},
{-0.029258753214850497,0.8838809105088833,0.1520697571560228},
{-0.034788876961771416,0.8902194244380783,0.16219949135181916},
{-0.033902673820775685,0.9054794102318099,0.1593722871849352},
{-0.06391037676332136,0.9044932390535676,0.14748851921129},
{-0.06192560594815226,0.931864487651651,0.1390231177437052},
{-0.061064259724525914,0.9579253444101522,0.122219301234227},
{-0.06487169102419416,0.9755207997010686,0.09475294790881726},
{-0.07043855977940026,0.9844298431069203,0.05673213132125594},
{-0.07521973379862601,0.984507115697873,0.011470926998205707},
{-0.07540670104666536,0.9794714284594954,-0.031918443373375495},
{-0.07157441282962772,0.9667992639110253,-0.0719710427720002},
{-0.07052609935796203,0.9378539240021367,-0.09652643492634654},
{-0.0673557616578267,0.9027392052757188,-0.11030959560767464},
{-0.06801717180696011,0.8700199368688337,-0.11942343839793926},
{-0.06790477531102894,0.8399787311246162,-0.12080137620863383},
{-0.07058824165138551,0.803737885967811,-0.12434618877261677},
{-0.08294591215835585,0.7892808866786648,-0.13295911064111124},
{-0.09265740170102371,0.7667037809262607,-0.1364466442215908},
{-0.09124704182419514,0.7455083955589336,-0.1321463975166859},
{-0.08191002714537488,0.7309762851499103,-0.12365992170611396},
{-0.08471885880811622,0.927773903641079,0.11970659110884277},
{-0.08149826690547321,0.9492151563432556,0.10934233730134392},
{-0.08691545378869404,0.9597869113740122,0.0844821777253381},
{-0.09227049837849141,0.9624330923383145,0.055812425378588416},
{-0.09638972188081488,0.9606255621513446,0.012584084602139368},
{-0.09686416478190892,0.9537828850937661,-0.02993745513258869},
{-0.08817613179353737,0.9454255571799612,-0.07174895161898237},
{-0.09735103614168768,0.9285968837531136,-0.0739558135871693},
{-0.08538026895724962,0.9016368550271631,-0.09691225751334101},
{-0.09259525940760023,0.87149027756801,-0.10083532751555381},
{-0.0940056192844288,0.840606098104309,-0.10201386961952436},
{-0.09808755741069815,0.8091766875617878,-0.10468490750119624},
{-0.11560033643297292,0.7942711830244548,-0.10805139870144222},
{-0.12526157177313307,0.7713460804288792,-0.10990377941323086},
{-0.12452559087189151,0.7525547912653875,-0.10661618190724426},
{-0.11124389148010244,0.7354937596979129,-0.10308217669863934},
{-0.10474056538139292,0.9308523788205014,0.05671754139149564},
{-0.10818595027589828,0.9311782205851482,0.011410946175857827},
{-0.10701227148184783,0.9281683721123761,-0.02993259182266859},
{-0.10437851897623003,0.898221730727716,-0.0716279092387488},
{-0.10812326761470589,0.873007089895312,-0.07243413794994735},
{-0.11216792036492117,0.8434246563868905,-0.07115562780873035},
{-0.11613692162749045,0.8099829162729864,-0.07225311474736591},
{-0.13643367539513718,0.7940890790863355,-0.07490037644720621},
{-0.14502174034626228,0.7742094892362793,-0.07561204079884729},
{-0.14376106234141894,0.7536868617412325,-0.0749430655009493},
{-0.1301675707469747,0.7362475727355281,-0.07630641338188358},
{-0.09786276441883582,0.9295603594850621,0.09072720803051348},
{-0.10897218537964755,0.9000092673072367,0.057623738139940664},
{-0.11265425135693101,0.8979785652317113,0.010456116328211817},
{-0.11100667002955542,0.8980493534094369,-0.032195652038821104},
{-0.1133783441672568,0.8754733283925707,-0.03127432499284688},
{-0.10268122381411565,0.902078875862123,0.09447573924337165},
{-0.11140600181077238,0.8835361558723253,0.06000135632309994},
{-0.08818856025222208,0.9035330055282325,0.1252885901615781},
{-0.1058142761381969,0.8856770929727064,0.0959271670706366},
{-0.10631357595666034,0.8781173478857976,0.06679053697155747},
{-0.10826052102800646,0.8751669398676046,0.05870339294220253},
{-0.09074774200573169,0.8875467654530999,0.12961261304831456},
{-0.08152312382284259,0.8811234137841873,0.11715119192971545},
{-0.0979000497948899,0.8793893736137878,0.08622108120565776},
{-0.10509018332787112,0.8710660888694236,0.06973554131206158},
{-0.10673776465524672,0.860955267545539,0.06432051589991633},
{-0.06435996274704602,0.8892067752391601,0.15144076907302342},
{-0.05795606431781406,0.8826186114007332,0.13654931409768176},
{-0.053462365951643026,0.876341159029424,0.1366590087547684},
{-0.08197270980656725,0.8754425274297434,0.11443152094884258},
{-0.0956407721531197,0.873119486391243,0.08896560910390003},
{-0.09546623336376504,0.8544978727071858,0.09094929918353131},
{-0.1048281049599547,0.8471472499468415,0.08393640627874925},
{-0.10374196574446602,0.8406985009927908,0.07861918743277488},
{-0.11012046688855968,0.8429242758328891,0.056044243151446446},
{-0.11171833438119651,0.812644227534818,0.051438688657113145},
{-0.11034525988042201,0.7939042733093716,0.03253230115884569},
{-0.12382635497893511,0.7894267859762678,0.021570400598943634},
{-0.13947918814065666,0.7766497900806311,0.011207227526982586},
{-0.14575826161527275,0.7581681316487189,0.004519095651309323},
{-0.14406042608538944,0.7367031027647107,0.002620783679164201},
{-0.13748198886680288,0.7254191430145445,-9.186252071298892e-06},
{-0.1267972969723464,0.8170844294918681,-0.008371377475796254},
{-0.12606077570333593,0.813664441882501,0.008745852339643838},
{-0.12483738307454671,0.8184261626620463,0.02319582684779434},
{-0.12383878343761981,0.8313928276445667,0.03405289606052983},
{-0.12307740525123995,0.8454045638921395,0.03722107228958957},
{-0.12270293038739236,0.8612946185044079,0.03258849940681128},
{-0.12269050192870766,0.8723980954197619,0.021486643594764158},
{-0.12337676899521045,0.8756521901240766,0.006185589850596416},
{-0.1242256867601521,0.8712671056794544,-0.010161615894161409},
{-0.12482495461586202,0.8607256112437566,-0.021319669954174114},
{-0.12636013944730645,0.8447653088215309,-0.024078247414407773},
{-0.12702208996420875,0.8302407635612722,-0.01932463215139592},
{-0.13888046065271564,0.7417409514741637,0.03856658803415017},
{-0.13588466174193495,0.7260319200644768,0.03222915484049289},
{-0.13069172748280752,0.7167413770137818,0.027114033540087047},
{-0.12051876386549923,0.6999921376489625,0.059647955802239444},
{-0.10638814670876852,0.6770729790988449,0.08303561320799323},
{-0.07936381421831885,0.6736178675844995,0.0752002805589456},
{-0.07389637313259032,0.6582595348568282,0.10510585399316921},
{-0.053075462629110746,0.657640273393669,0.10567486125382074},
{-0.03367788082891335,0.666773569423614,0.09030139822862042},
{-0.02621324046933102,0.6715671719015245,0.10850963056946927},
{-0.025576687237567015,0.6818990036428894,0.12613102351329292},
{-0.020358896061070206,0.6942139850961166,0.12339622223489086},
{-0.02023407110645434,0.6895933003042541,0.1464591186115358},
{-0.022094016967007576,0.6970714498580589,0.1638697681254885},
{-0.021507177569982355,0.7154228796576663,0.16761451676396438},
{-0.016077562228076808,0.7347258970983064,0.16825701404118626},
{-0.01406793449553832,0.7467793405513861,0.17469657674316566},
{-0.020221642647769645,0.7499399516316811,0.17788258510859908},
{-0.026238097386700417,0.7998261636887449,0.16420155393559302},
{-0.023591916422397923,0.8011414188382472,0.16156293812005512},
{-0.02638777925868567,0.8092264013965266,0.15691307346867206},
{-0.030020131401230363,0.8127852635225009,0.15849959323816196},
{-0.03146831702188192,0.8312766485742532,0.15517038741397007},
{-0.03282896306397171,0.8469797359384824,0.15098145646945857},
{-0.03518820874298839,0.8530702210617526,0.1512148953456233},
{-0.03925717804280415,0.8626190599059815,0.13915064453716555},
{-0.04909349254008786,0.87027715192683,0.13843519761114217},
{-0.1324144199300602,0.7607435244352956,0.04912321276737735},
{-0.12944347793664893,0.7222898732648454,0.06300580111818302},
{-0.1150134970359477,0.7763342153035936,0.059210257909430575},
{-0.12327734132573288,0.7430832250121112,0.07768921450249826},
{-0.12700912113775514,0.7403646347667759,0.08259467310857095},
{-0.1333751938231641,0.7172331116834808,0.06861049561721212},
{-0.1215546488784802,0.6910047409166205,0.09675987380251125},
{-0.10675019311393141,0.674618088324733,0.11776775155403016},
{-0.09061048859243112,0.6622739270119852,0.10963791847093213},
{-0.07608108002225235,0.6614385184412661,0.12678648961696842},
{-0.052613448186701384,0.6595629019154147,0.12473417283068684},
{-0.0345014013087167,0.6636297097441547,0.10629898602690005},
{-0.0348385907965102,0.66476178022,0.12283586085854171},
{-0.0364737436652011,0.671052741785532,0.13030644526358195},
{-0.02920903938011171,0.6839934691151451,0.12997465945347744},
{-0.024765054848679465,0.6943750146912488,0.12889878722559786},
{-0.027062158234272663,0.7031354569606528,0.13982556388052145},
{-0.02419118427810784,0.7075778203887786,0.15165043176735654},
{-0.024465691104708955,0.725011165349025,0.16551464761401963},
{-0.019147931890965673,0.7412108506928731,0.17075135166242794},
{-0.024328437691408397,0.7422942880695172,0.1718655900018994},
{-0.03787167508334497,0.7724781509047244,0.15950305618500893},
{-0.04400052631820691,0.7912580923450693,0.15063291925851816},
{-0.04199089858566842,0.7925938814697897,0.14864328513342898},
{-0.043476369582374066,0.7974080179229184,0.1456453247515727},
{-0.046971468311618206,0.8001233659616399,0.14740746404595503},
{-0.05197689495493738,0.8195306743816776,0.14105273908369298},
{-0.04618523320786895,0.8357444092875171,0.141942724799071},
{-0.050029949883591274,0.8430301879155936,0.14449920471373612},
{-0.05434856909263876,0.8537554073927176,0.1297001526268763},
{-0.07320956569831862,0.8631648313525704,0.1219231796968699},
{-0.08954920629431184,0.8611000861076039,0.10191876489219798},
{-0.08900019264110962,0.8461383833223054,0.10032846254832577},
{-0.1012081812760947,0.8304055757307867,0.09963571106859617},
{-0.09934823541554146,0.8189168165962072,0.09566400796718239},
{-0.10605149758874392,0.8072616241888068,0.08404015689037803},
{-0.10636328979139914,0.7947618369586158,0.07571579141047606},
{-0.10356742695511138,0.7809462542111536,0.06250055725426168},
{-0.09757582913355001,0.793778367619218,0.10246075376440453},
{-0.09706410085640187,0.7798790278675765,0.09371814363137408},
{-0.08907530376098668,0.7625332224858916,0.09218998358092535},
{-0.10427855093898357,0.7558791337796591,0.0906499354395608},
{-0.10734946096964133,0.7524137552777046,0.09641674026925987},
{-0.10163236997468107,0.7283436133798302,0.12612129689345272},
{-0.12051876386549923,0.711950476374716,0.11192475486891625},
{-0.10565162543975805,0.6942712640796199,0.1311629281772882},
{-0.09276979819695487,0.6735270857993241,0.13431219153443644},
{-0.08536784049856493,0.679468429418378,0.14218102698515583},
{-0.07061363893652381,0.6682341835029503,0.13798831346626203},
{-0.05242648093866204,0.6645645459843516,0.13288291878569636},
{-0.0821348201372372,0.7557018931514602,0.11083753491788977},
{-0.08064934914053155,0.7373985560832849,0.13089436539614496},
{-0.09077259892310108,0.7104812164110774,0.14109380703412935},
{-0.07957563838372758,0.7661493635953694,0.11824003298404862},
{-0.07842735687481543,0.7660683084300344,0.11885389076951883},
{-0.08056180956196979,0.7558888603994994,0.1100572438595984},
{-0.07380883355402854,0.7724046608881541,0.1300946210981732},
{-0.05859261754957807,0.7390515410883494,0.14135858724089026},
{-0.06153870262561997,0.7307266352406785,0.14195623399329352},
{-0.07606811119579876,0.7209616492888896,0.1419637991420581},
{-0.07477014781490134,0.717176913435515,0.1419578550966002},
{-0.08712781832187168,0.7075464790581824,0.14230963451415396},
{-0.08867543161200081,0.6954562905968174,0.14343954351892355},
{-0.09266983015970841,0.6957459277209478,0.14234367768359468},
{-0.08189759868669018,0.6818341595106214,0.14273058100612698},
{-0.06926542135311872,0.6712915843393857,0.13909066371481765},
{-0.05280095580250963,0.6680780172177382,0.13500764485301053},
{-0.039781875146405896,0.6735178995472529,0.13167735829328084},
{-0.03315372409308051,0.6852368553513837,0.1313963670534529},
{-0.03236694862156235,0.6925204725083846,0.13226635916138163},
{-0.02866002572690948,0.6927463462357848,0.13153470120229127},
{-0.02960837116132869,0.6993890872188703,0.13547290150203325},
{-0.03183036342704481,0.7023827246585755,0.14212266726611464},
{-0.03691090119024107,0.70572543967699,0.15312077246653297},
{-0.02947111774802813,0.7102877647498111,0.16236808609571587},
{-0.032129727171015324,0.712819387747107,0.16386220297672394},
{-0.028509803487155323,0.7276670729331677,0.16700498192064533},
{-0.052176831029430326,0.7600940023770778,0.1509004013041236},
{-0.0657076399626822,0.7812656115625735,0.13907067010736837},
{-0.06459718419759304,0.7827997156584802,0.1370124092756289},
{-0.06460961265627774,0.7858068622924077,0.13694216146567192},
{-0.06695588950884082,0.7874420151610987,0.13689136689539533},
{-0.0729728846155405,0.8092355876485977,0.1297747233789845},
{-0.06981443500632095,0.8223243757468895,0.12822711008885537},
{-0.07291020195434811,0.8310923831650583,0.1314239258096668},
{-0.07417087995919143,0.8459303417312789,0.11595805989598461},
{-0.09414287269772936,0.8260653418109831,0.1137101299773613},
{-0.0906980281709929,0.8151942230362564,0.11234029768320021},
{-0.08846360744659208,0.7997310589614187,0.11783421678960485},
{-0.0765425540968928,0.776214253658898,0.12733928584455295},
{-0.07440810140973846,0.7750946116417374,0.1278877591299863},
{-0.07389637313259032,0.7742019240875149,0.12928947312251246},
{-0.0581684288509917,0.7513951620333283,0.1454913199374362},
{-0.041341916895219724,0.7095912306956993,0.1564834810923967},
{-0.05704500425944894,0.7198430880072668,0.14614570530557394},
{-0.05733193954473475,0.7155493257155887,0.14499364122227948},
{-0.05582161163065971,0.7110545466138801,0.12475308570259833},
{-0.06920273869192635,0.7120590902962647,0.12494653736386446},
{-0.08021273198326048,0.7055995339868362,0.12203935876718336},
{-0.07829010346151488,0.6955848981258155,0.11891981563732461},
{-0.03392753073814507,0.7017672457697985,0.14040591886431988},
{-0.03869573593091722,0.7045047488870452,0.150423256564185},
{-0.03255445623737059,0.6985482749704622,0.13533726919203942},
{-0.04609769362930717,0.7027934041629395,0.12099212603105548},
{-0.043863272904906346,0.7086828724761787,0.15302728884251332},
{-0.06311171320088739,0.6984445243588335,0.11851832238503203},
{-0.07334735947938807,0.6890723857750348,0.12032315073315748},
{-0.06518348322684936,0.6872113591789437,0.11672322065674678},
{-0.056957464680887165,0.6851044652480033,0.11725115996696192},
{-0.05006723525964536,0.6880791898157967,0.11572191918097538},
{-0.04707143634886468,0.6924626531571123,0.11612125096219236},
{-0.125224286397079,0.8322579564425753,0.00752354044639241},
{-0.1238760688136739,0.833641297930959,0.026875190986233317},
{-0.12300229413136286,0.8538699653597243,0.026402369188445962},
{-0.12401332222697446,0.8544033083476283,0.006403898429231949},
{-0.12504974760772436,0.8527605903301729,-0.01327683608186896},
{-0.12612291799675943,0.8323962905914137,-0.01232470807306745},
{-0.128844210080939,0.8527719380533197,0.02244039270687237},
{-0.130392363738837,0.8529551227269769,0.00643632049536594},
{-0.13102891697060104,0.8520899939289683,-0.00798555488880177},
{-0.13233930881018313,0.8346858288282423,-0.007813177570522724},
{-0.13172761249578852,0.8343751173611249,0.007320362165286071},
{-0.12978066742444241,0.8347393252373634,0.02290727045920183},
{0.011633577696644559,0.4830317765968342,-0.18749410661402047},
{0.015353469417751028,0.496875998836048,-0.18729200906845192},
{0.02352923376120554,0.49192028602746746,-0.17884389936947187},
{0.030220067475723304,0.49860463532875854,-0.1787536579520656},
{0.025489147659005243,0.5070203229616046,-0.1871482712419245},
{0.015353469417751028,0.4691762066344734,-0.18769512342405115},
{0.021082988871395984,0.4827880707330604,-0.17895575549763412},
{0.0407302205808251,0.48235523615017156,-0.17880499289011112},
{0.039344717621365925,0.5010411535987279,-0.17871745331154934},
{0.039344717621365925,0.5107315687984085,-0.18708937115511448},
{0.05320028758372661,0.5070203229616046,-0.1871482712419245},
{0.06334839428366552,0.496875998836048,-0.18729200906845192},
{0.067068286004772,0.4830317765968342,-0.18749410661402047},
{0.06334839428366552,0.4691762066344734,-0.18769512342405115},
{0.05320028758372661,0.45904268986429486,-0.18783832088280966},
{0.039344717621365925,0.4553314440274909,-0.18789722096961975},
{0.025489147659005243,0.45904268986429486,-0.18783832088280966},
{0.02352923376120554,0.4736547747031154,-0.17908058045224998},
{0.030220067475723304,0.46698285386050903,-0.17917190260519408},
{0.039344717621365925,0.46453498786739283,-0.17919459805148788},
{0.04848179622569324,0.46698285386050903,-0.17917190260519408},
{0.05516020148152632,0.4736547747031154,-0.17908058045224998},
{0.05760644637133587,0.4827880707330604,-0.17895575549763412},
{0.05517262994021101,0.49192028602746746,-0.17884389936947187},
{0.04848179622569324,0.49860463532875854,-0.1787536579520656}
};


// texture array: 36kb.
const tgx::fVec2 stormtrooper_tex_array[4653] PROGMEM = {
{1.5214,0.6764},
{1.5189,0.6722},
{1.4966,0.6686},
{1.4942,0.6921},
{1.4685,0.6847},
{1.4718,0.662},
{1.444,0.6807},
{1.4477,0.656},
{1.4372,0.6784},
{1.4378,0.6544},
{1.4262,0.6797},
{1.4233,0.6556},
{1.4141,0.6569},
{1.4192,0.682},
{1.3902,0.6629},
{1.3944,0.6871},
{1.3657,0.6704},
{1.3692,0.6942},
{1.3421,0.679},
{1.3444,0.6746},
{1.5184,0.6996},
{1.4914,0.7187},
{1.4648,0.7109},
{1.442,0.7069},
{1.4362,0.706},
{1.4296,0.706},
{1.4226,0.7073},
{1.3997,0.7139},
{1.3738,0.7204},
{1.3462,0.7017},
{1.5146,0.7266},
{1.4861,0.7438},
{1.4615,0.7353},
{1.4409,0.7343},
{1.436,0.7344},
{1.4304,0.7345},
{1.4256,0.7344},
{1.4049,0.736},
{1.3795,0.7442},
{1.3497,0.7279},
{1.5085,0.7555},
{1.4757,0.7661},
{1.4621,0.758},
{1.4422,0.7582},
{1.4369,0.7578},
{1.4302,0.7579},
{1.4245,0.7581},
{1.405,0.7587},
{1.3908,0.7682},
{1.3569,0.7554},
{1.4956,0.78},
{1.4637,0.7838},
{1.4431,0.7784},
{1.4377,0.7785},
{1.4296,0.7786},
{1.4222,0.778},
{1.4038,0.7835},
{1.3722,0.7824},
{1.4762,0.8002},
{1.4477,0.7976},
{1.4383,0.7985},
{1.4294,0.7986},
{1.4189,0.7983},
{1.3919,0.8019},
{1.4538,0.8116},
{1.4398,0.815},
{1.4281,0.8153},
{1.4127,0.8122},
{1.1845,0.5518},
{1.1826,0.5551},
{1.2035,0.5435},
{1.2184,0.5616},
{1.1864,0.5762},
{1.2256,0.5968},
{1.1918,0.6009},
{1.2009,0.6257},
{1.2358,0.6264},
{1.2148,0.6454},
{1.2424,0.6438},
{1.2339,0.6602},
{1.2659,0.644},
{1.2546,0.6666},
{1.2675,0.6678},
{1.2813,0.6645},
{1.2988,0.6558},
{1.2882,0.6393},
{1.3155,0.6385},
{1.2924,0.6225},
{1.3277,0.6138},
{1.2982,0.5914},
{1.3331,0.589},
{1.334,0.5648},
{1.3011,0.5562},
{1.3347,0.5437},
{1.3131,0.5353},
{1.3323,0.5404},
{1.2248,0.536},
{1.2598,0.5645},
{1.2629,0.6104},
{1.2909,0.5308},
{1.2689,0.5281},
{1.2579,0.5277},
{1.2464,0.5297},
{1.2702,0.5194},
{1.2634,0.518},
{1.2578,0.5247},
{1.2515,0.5189},
{1.2458,0.5268},
{1.2442,0.5214},
{1.2234,0.5334},
{1.2219,0.5277},
{1.2011,0.5412},
{1.199,0.5356},
{1.1813,0.5498},
{1.1776,0.5461},
{1.1793,0.5533},
{1.1742,0.5523},
{1.1833,0.5753},
{1.1776,0.5768},
{1.1889,0.601},
{1.1835,0.603},
{1.1985,0.6269},
{1.1937,0.6297},
{1.213,0.6474},
{1.2092,0.6513},
{1.2329,0.6628},
{1.2304,0.6676},
{1.2544,0.6696},
{1.2528,0.6749},
{1.2679,0.6708},
{1.2642,0.677},
{1.2723,0.6765},
{1.2823,0.6674},
{1.2847,0.6724},
{1.3006,0.6582},
{1.3038,0.6626},
{1.3179,0.6403},
{1.3222,0.6435},
{1.3307,0.6145},
{1.3359,0.6166},
{1.3363,0.5886},
{1.342,0.5897},
{1.3372,0.5634},
{1.3432,0.5639},
{1.3379,0.5414},
{1.3429,0.5397},
{1.3355,0.538},
{1.3386,0.5338},
{1.3155,0.5327},
{1.3167,0.5269},
{1.2923,0.5279},
{1.2929,0.5221},
{1.2693,0.5251},
{0.4966,0.6686},
{0.5189,0.6722},
{0.5214,0.6764},
{0.4942,0.6921},
{0.5184,0.6996},
{0.4914,0.7187},
{0.5146,0.7266},
{0.4861,0.7438},
{0.5085,0.7555},
{0.4757,0.7661},
{0.4956,0.78},
{0.4637,0.7838},
{0.4762,0.8002},
{0.4477,0.7976},
{0.4538,0.8116},
{0.4398,0.815},
{0.4383,0.7985},
{0.4281,0.8153},
{0.4294,0.7986},
{0.4189,0.7983},
{0.4127,0.8122},
{0.3919,0.8019},
{0.4038,0.7835},
{0.3722,0.7824},
{0.3908,0.7682},
{0.3569,0.7554},
{0.3795,0.7442},
{0.3497,0.7279},
{0.3738,0.7204},
{0.3462,0.7017},
{0.3692,0.6942},
{0.3421,0.679},
{0.3657,0.6704},
{0.3444,0.6746},
{0.4685,0.6847},
{0.4648,0.7109},
{0.4615,0.7353},
{0.4621,0.758},
{0.4431,0.7784},
{0.4377,0.7785},
{0.4296,0.7786},
{0.4222,0.778},
{0.405,0.7587},
{0.4049,0.736},
{0.3997,0.7139},
{0.3944,0.6871},
{0.3902,0.6629},
{0.4192,0.682},
{0.4141,0.6569},
{0.4262,0.6797},
{0.4233,0.6556},
{0.4378,0.6544},
{0.4372,0.6784},
{0.4477,0.656},
{0.444,0.6807},
{0.4718,0.662},
{0.4296,0.706},
{0.4362,0.706},
{0.442,0.7069},
{0.4409,0.7343},
{0.4422,0.7582},
{0.4369,0.7578},
{0.4302,0.7579},
{0.4245,0.7581},
{0.4256,0.7344},
{0.4226,0.7073},
{0.4304,0.7345},
{0.436,0.7344},
{0.1845,0.5518},
{0.2035,0.5435},
{0.1826,0.5551},
{0.2184,0.5616},
{0.2248,0.536},
{0.2598,0.5645},
{0.2464,0.5297},
{0.2579,0.5277},
{0.2689,0.5281},
{0.2909,0.5308},
{0.3011,0.5562},
{0.3131,0.5353},
{0.3347,0.5437},
{0.3323,0.5404},
{0.1864,0.5762},
{0.2256,0.5968},
{0.2629,0.6104},
{0.2982,0.5914},
{0.334,0.5648},
{0.3331,0.589},
{0.3277,0.6138},
{0.2924,0.6225},
{0.3155,0.6385},
{0.2882,0.6393},
{0.2988,0.6558},
{0.2659,0.644},
{0.2813,0.6645},
{0.2675,0.6678},
{0.2546,0.6666},
{0.2339,0.6602},
{0.2424,0.6438},
{0.2148,0.6454},
{0.2358,0.6264},
{0.2009,0.6257},
{0.1918,0.6009},
{0.2634,0.518},
{0.2702,0.5194},
{0.2578,0.5247},
{0.2515,0.5189},
{0.2458,0.5268},
{0.2442,0.5214},
{0.2234,0.5334},
{0.2219,0.5277},
{0.2011,0.5412},
{0.199,0.5356},
{0.1813,0.5498},
{0.1776,0.5461},
{0.1793,0.5533},
{0.1742,0.5523},
{0.1833,0.5753},
{0.1776,0.5768},
{0.1889,0.601},
{0.1835,0.603},
{0.1985,0.6269},
{0.1937,0.6297},
{0.213,0.6474},
{0.2092,0.6513},
{0.2329,0.6628},
{0.2304,0.6676},
{0.2544,0.6696},
{0.2528,0.6749},
{0.2679,0.6708},
{0.2642,0.677},
{0.2723,0.6765},
{0.2823,0.6674},
{0.2847,0.6724},
{0.3006,0.6582},
{0.3038,0.6626},
{0.3179,0.6403},
{0.3222,0.6435},
{0.3307,0.6145},
{0.3359,0.6166},
{0.3363,0.5886},
{0.342,0.5897},
{0.3372,0.5634},
{0.3432,0.5639},
{0.3379,0.5414},
{0.3429,0.5397},
{0.3355,0.538},
{0.3386,0.5338},
{0.3155,0.5327},
{0.3167,0.5269},
{0.2923,0.5279},
{0.2929,0.5221},
{0.2693,0.5251},
{0.8793,0.9919},
{0.8664,0.9919},
{0.8664,0.9315},
{0.8793,0.9315},
{0.892,0.9919},
{0.892,0.9315},
{0.9048,0.9919},
{0.9048,0.9315},
{0.9178,0.9919},
{0.9178,0.9315},
{0.9308,0.9919},
{0.9308,0.9315},
{0.9438,0.9919},
{0.9438,0.9315},
{0.9569,0.9919},
{0.9569,0.9315},
{0.9697,0.9919},
{0.9697,0.9315},
{0.9825,0.9919},
{0.9825,0.9315},
{0.9955,0.9919},
{0.9955,0.9315},
{0.9796,0.9088},
{0.9934,0.9043},
{0.9934,0.9133},
{0.9881,0.9205},
{0.9796,0.9233},
{0.9711,0.9205},
{0.9658,0.9133},
{0.9658,0.9043},
{0.9711,0.8971},
{0.9796,0.8943},
{0.9882,0.8971},
{0.9472,0.564},
{0.9472,0.5519},
{0.9309,0.5519},
{0.9309,0.564},
{0.8939,0.564},
{0.8939,0.5519},
{0.8569,0.5519},
{0.8569,0.564},
{0.8406,0.564},
{0.8406,0.5519},
{0.9472,0.5761},
{0.9309,0.5761},
{0.8939,0.5761},
{0.8569,0.5761},
{0.8406,0.5761},
{0.9472,0.5882},
{0.9309,0.5882},
{0.8939,0.5882},
{0.8569,0.5882},
{0.8406,0.5882},
{0.9472,0.6003},
{0.9309,0.6003},
{0.8939,0.6003},
{0.8569,0.6003},
{0.8406,0.6003},
{0.9472,0.6124},
{0.9309,0.6124},
{0.8939,0.6124},
{0.8569,0.6124},
{0.8406,0.6124},
{0.9472,0.6245},
{0.9309,0.6245},
{0.8939,0.6245},
{0.8569,0.6245},
{0.8406,0.6245},
{0.9472,0.6366},
{0.9309,0.6366},
{0.8939,0.6366},
{0.8569,0.6366},
{0.8406,0.6366},
{0.9472,0.6487},
{0.9309,0.6487},
{0.8939,0.6487},
{0.8569,0.6487},
{0.8406,0.6487},
{0.9472,0.6609},
{0.9309,0.6609},
{0.8939,0.6609},
{0.8569,0.6609},
{0.8406,0.6609},
{0.9472,0.673},
{0.9309,0.673},
{0.8939,0.673},
{0.8569,0.673},
{0.8406,0.673},
{0.9472,0.6851},
{0.9308,0.6851},
{0.8939,0.6851},
{0.8569,0.6851},
{0.8406,0.6851},
{0.9472,0.6972},
{0.9308,0.6972},
{0.8939,0.6972},
{0.8569,0.6972},
{0.8406,0.6972},
{0.942,0.7098},
{0.9497,0.7098},
{0.9497,0.7145},
{0.9419,0.7145},
{0.9339,0.7098},
{0.9336,0.7145},
{0.9251,0.7098},
{0.9249,0.7145},
{0.916,0.7098},
{0.9159,0.7145},
{0.9067,0.7098},
{0.9067,0.7145},
{0.8975,0.7098},
{0.8975,0.7145},
{0.8882,0.7098},
{0.8882,0.7145},
{0.879,0.7098},
{0.8789,0.7145},
{0.8696,0.7098},
{0.8696,0.7145},
{0.8601,0.7098},
{0.8604,0.7145},
{0.8513,0.7098},
{0.8515,0.7145},
{0.843,0.7098},
{0.843,0.7145},
{0.601,0.603},
{0.6032,0.5948},
{0.6174,0.603},
{0.6092,0.5888},
{0.6174,0.5866},
{0.6257,0.5888},
{0.6317,0.5948},
{0.6339,0.603},
{0.6317,0.6113},
{0.6257,0.6173},
{0.6174,0.6195},
{0.6092,0.6173},
{0.6032,0.6113},
{0.5951,0.603},
{0.5981,0.5919},
{0.6016,0.5939},
{0.6083,0.5872},
{0.6063,0.5837},
{0.6174,0.5848},
{0.6174,0.5807},
{0.6266,0.5872},
{0.6286,0.5837},
{0.6333,0.5939},
{0.6368,0.5919},
{0.6357,0.603},
{0.6398,0.603},
{0.6333,0.6122},
{0.6368,0.6142},
{0.6266,0.6189},
{0.6286,0.6224},
{0.6174,0.6213},
{0.6174,0.6254},
{0.6083,0.6189},
{0.6063,0.6224},
{0.6016,0.6122},
{0.5981,0.6142},
{0.5992,0.603},
{1.8664,0.9315},
{1.8664,0.9919},
{1.8793,0.9919},
{1.8793,0.9315},
{1.892,0.9919},
{1.892,0.9315},
{1.9048,0.9919},
{1.9048,0.9315},
{1.9178,0.9919},
{1.9178,0.9315},
{1.9308,0.9919},
{1.9308,0.9315},
{1.9438,0.9919},
{1.9438,0.9315},
{1.9569,0.9919},
{1.9569,0.9315},
{1.9697,0.9919},
{1.9697,0.9315},
{1.9825,0.9919},
{1.9825,0.9315},
{1.9955,0.9919},
{1.9955,0.9315},
{1.9934,0.9133},
{1.9934,0.9043},
{1.9796,0.9088},
{1.9882,0.8971},
{1.9796,0.8943},
{1.9711,0.8971},
{1.9658,0.9043},
{1.9658,0.9133},
{1.9711,0.9205},
{1.9796,0.9233},
{1.9881,0.9205},
{0.1762,0.1817},
{0.1828,0.1654},
{0.1905,0.1654},
{0.1854,0.1869},
{0.1761,0.2186},
{0.1684,0.2124},
{0.0372,0.4268},
{0.01,0.433},
{0.0092,0.4213},
{0.0321,0.4217},
{0.0343,0.4216},
{0.0748,0.3653},
{0.0714,0.3484},
{0.0889,0.3469},
{0.0927,0.3633},
{0.0774,0.3809},
{0.095,0.3791},
{0.0791,0.3948},
{0.0951,0.3944},
{0.0776,0.41},
{0.0954,0.4107},
{0.0754,0.4245},
{0.093,0.426},
{0.0724,0.4397},
{0.0904,0.4416},
{0.0703,0.4502},
{0.0877,0.4526},
{0.0685,0.4593},
{0.0859,0.4622},
{0.0719,0.3715},
{0.0673,0.3452},
{0.0691,0.3469},
{0.0728,0.3721},
{0.0754,0.3942},
{0.0764,0.3946},
{0.0731,0.4099},
{0.0747,0.4101},
{0.0686,0.4326},
{0.0702,0.4325},
{0.0646,0.4607},
{0.0659,0.4602},
{0.0975,0.3704},
{0.0899,0.3455},
{0.0903,0.3437},
{0.0987,0.3685},
{0.0991,0.3939},
{0.1008,0.3932},
{0.0988,0.4111},
{0.1005,0.4111},
{0.0959,0.4349},
{0.0972,0.436},
{0.087,0.4636},
{0.0873,0.4651},
{0.0694,0.3464},
{0.0675,0.3449},
{0.0897,0.3435},
{0.0894,0.3452},
{0.0867,0.4637},
{0.087,0.4651},
{0.0648,0.461},
{0.0663,0.4606},
{0.0733,0.3721},
{0.0694,0.3471},
{0.0708,0.3483},
{0.0743,0.3651},
{0.0771,0.3808},
{0.0769,0.3947},
{0.0789,0.3948},
{0.075,0.4101},
{0.0773,0.4101},
{0.0708,0.4327},
{0.0749,0.4246},
{0.0717,0.4398},
{0.0664,0.46},
{0.0696,0.4504},
{0.0677,0.4591},
{0.0891,0.3456},
{0.0889,0.3465},
{0.0711,0.3479},
{0.0696,0.3467},
{0.0934,0.3631},
{0.0894,0.3469},
{0.0896,0.3459},
{0.0974,0.3705},
{0.0959,0.379},
{0.096,0.3943},
{0.0986,0.394},
{0.0963,0.4107},
{0.0985,0.4111},
{0.0937,0.4261},
{0.0954,0.4347},
{0.0909,0.4417},
{0.0881,0.4528},
{0.0869,0.4634},
{0.0861,0.4623},
{0.0665,0.4603},
{0.0679,0.4597},
{0.0859,0.4625},
{0.0865,0.4635},
{0.0698,0.372},
{0.0651,0.3438},
{0.0669,0.3449},
{0.0715,0.3716},
{0.0718,0.3913},
{0.0748,0.3939},
{0.0698,0.4036},
{0.0728,0.4095},
{0.0657,0.4322},
{0.0681,0.4326},
{0.0625,0.461},
{0.0642,0.4608},
{0.0671,0.3445},
{0.0651,0.3435},
{0.0911,0.3396},
{0.0901,0.3426},
{0.0992,0.437},
{0.0874,0.4684},
{0.0874,0.4653},
{0.0975,0.4363},
{0.1048,0.4095},
{0.1009,0.4111},
{0.1068,0.3864},
{0.1014,0.3929},
{0.1025,0.3661},
{0.0989,0.3685},
{0.0906,0.3434},
{0.0913,0.3404},
{0.0871,0.4653},
{0.087,0.4686},
{0.0624,0.4613},
{0.0642,0.4612},
{0.01,0.3981},
{0.0111,0.3882},
{0.0382,0.3907},
{0.0351,0.3971},
{0.0369,0.3967},
{0.0368,0.4992},
{0.0103,0.4943},
{0.0103,0.4856},
{0.0411,0.49},
{0.0103,0.4669},
{0.0435,0.471},
{0.0103,0.4525},
{0.0396,0.4543},
{0.062,0.4616},
{0.0554,0.4461},
{0.0631,0.4304},
{0.0651,0.432},
{0.0691,0.4036},
{0.0776,0.4935},
{0.0875,0.4691},
{0.0644,0.5026},
{0.0828,0.5237},
{0.1013,0.4913},
{0.0987,0.4653},
{0.0996,0.4373},
{0.1014,0.4379},
{0.1067,0.4142},
{0.1052,0.4098},
{0.0639,0.5484},
{0.0841,0.5511},
{0.1114,0.5231},
{0.1151,0.5192},
{0.1057,0.4896},
{0.1051,0.4638},
{0.1061,0.4386},
{0.1129,0.4159},
{0.131,0.5482},
{0.1253,0.5535},
{0.1444,0.5602},
{0.1388,0.5716},
{0.1669,0.5762},
{0.1654,0.5834},
{0.1333,0.6062},
{0.157,0.6203},
{0.1549,0.6404},
{0.1339,0.6365},
{0.1126,0.5979},
{0.1129,0.637},
{0.0857,0.6412},
{0.0837,0.6085},
{0.0442,0.6188},
{0.051,0.6504},
{0.0103,0.6252},
{0.0103,0.658},
{0.0852,0.5784},
{0.0651,0.5952},
{0.0376,0.6044},
{0.0103,0.6104},
{0.0364,0.5095},
{0.0103,0.5056},
{0.0103,0.4954},
{0.0368,0.5002},
{0.0637,0.5037},
{0.0581,0.5125},
{0.0629,0.5484},
{0.0569,0.5491},
{0.0641,0.594},
{0.0586,0.5873},
{0.0376,0.6033},
{0.0366,0.5935},
{0.0103,0.5985},
{0.0103,0.6093},
{0.0553,0.5848},
{0.0573,0.5862},
{0.0366,0.5924},
{0.0359,0.5878},
{0.0103,0.5974},
{0.0103,0.5916},
{0.0575,0.5854},
{0.0555,0.584},
{0.0534,0.5496},
{0.0557,0.5491},
{0.0547,0.5156},
{0.0568,0.5135},
{0.0562,0.5133},
{0.054,0.5154},
{0.0358,0.5151},
{0.0364,0.511},
{0.0103,0.5071},
{0.0103,0.5122},
{0.0089,0.1583},
{0.0089,0.1564},
{0.0119,0.1548},
{0.0364,0.1583},
{0.0336,0.1499},
{0.0131,0.15},
{0.0483,0.1455},
{0.0672,0.1583},
{0.0662,0.1431},
{0.0508,0.1417},
{0.089,0.1494},
{0.0866,0.1438},
{0.1039,0.1583},
{0.0996,0.1502},
{0.1044,0.1474},
{0.1425,0.1583},
{0.1372,0.1442},
{0.1668,0.1481},
{0.191,0.1583},
{0.1905,0.1457},
{0.1877,0.1877},
{0.1921,0.1654},
{0.2016,0.1739},
{0.2006,0.195},
{0.1771,0.2201},
{0.192,0.2334},
{0.1603,0.2387},
{0.1902,0.2407},
{0.1596,0.2315},
{0.133,0.2569},
{0.9916,0.06},
{0.9916,0.0667},
{0.9607,0.0694},
{0.9595,0.0637},
{0.9299,0.0668},
{0.933,0.078},
{0.9082,0.069},
{0.9094,0.0805},
{0.89,0.0787},
{0.8889,0.0699},
{0.8718,0.07},
{0.8889,0.0673},
{0.8718,0.0674},
{0.864,0.0524},
{0.8855,0.0453},
{0.8649,0.0388},
{0.8853,0.0225},
{0.8643,0.0225},
{0.9084,0.0465},
{0.9073,0.0225},
{0.9082,0.0664},
{0.9298,0.0454},
{0.9296,0.0225},
{0.9299,0.0643},
{0.9587,0.043},
{0.957,0.0225},
{0.9595,0.0611},
{0.9916,0.0574},
{0.9916,0.0397},
{0.9916,0.0225},
{0.543,0.7096},
{0.543,0.6822},
{0.5536,0.7062},
{0.5746,0.6739},
{0.5693,0.6405},
{0.543,0.6421},
{0.543,0.6165},
{0.5666,0.6147},
{0.543,0.5964},
{0.5548,0.5982},
{0.543,0.5815},
{0.5591,0.5778},
{0.543,0.5466},
{0.5551,0.547},
{0.551,0.519},
{0.543,0.516},
{0.5833,0.7016},
{0.603,0.6681},
{0.5821,0.6367},
{0.5714,0.6102},
{0.5762,0.6056},
{0.5701,0.5693},
{0.5721,0.5448},
{0.5649,0.5245},
{0.6187,0.6984},
{0.6192,0.6823},
{0.62,0.6773},
{0.6057,0.6671},
{0.5872,0.6354},
{0.5924,0.6341},
{0.6083,0.6661},
{0.6208,0.6723},
{0.6439,0.6744},
{0.6347,0.6656},
{0.6518,0.6463},
{0.6597,0.6716},
{0.6622,0.6448},
{0.6615,0.6383},
{0.7022,0.6463},
{0.7044,0.6401},
{0.6761,0.6286},
{0.6902,0.623},
{0.7118,0.6184},
{0.7263,0.6368},
{0.7341,0.61},
{0.7438,0.6256},
{0.755,0.602},
{0.7687,0.6202},
{0.7859,0.6043},
{0.7803,0.5867},
{0.801,0.5846},
{0.796,0.5681},
{0.8153,0.5606},
{0.8075,0.5465},
{0.6422,0.692},
{0.6431,0.6832},
{0.6587,0.6983},
{0.6421,0.6999},
{0.6592,0.7008},
{0.6833,0.7063},
{0.7005,0.7},
{0.7136,0.7079},
{0.711,0.6725},
{0.7018,0.6724},
{0.7121,0.6467},
{0.7367,0.6576},
{0.7603,0.6502},
{0.7843,0.6448},
{0.7916,0.6191},
{0.7987,0.5999},
{0.8226,0.5995},
{0.8226,0.5852},
{0.8226,0.5601},
{0.7378,0.6795},
{0.7368,0.7096},
{0.762,0.6811},
{0.7603,0.7129},
{0.7852,0.6825},
{0.7859,0.7134},
{0.8226,0.7145},
{0.8226,0.6843},
{0.8226,0.6451},
{0.8226,0.6173},
{0.5684,0.5223},
{0.6639,0.6474},
{0.7001,0.6488},
{0.6998,0.6724},
{0.6617,0.6717},
{0.6985,0.6974},
{0.6608,0.6958},
{0.863,0.452},
{0.9029,0.4463},
{0.9045,0.4785},
{0.8639,0.4877},
{0.9041,0.5033},
{0.8759,0.5111},
{0.9039,0.5071},
{0.8785,0.5152},
{0.8515,0.5209},
{0.8545,0.5267},
{0.8247,0.5398},
{0.8263,0.5296},
{0.8164,0.5321},
{0.7803,0.5391},
{0.7987,0.543},
{0.7729,0.5489},
{0.7483,0.5517},
{0.7565,0.5444},
{0.7327,0.557},
{0.7325,0.553},
{0.7157,0.5633},
{0.7171,0.5672},
{0.7099,0.578},
{0.7019,0.5761},
{0.6889,0.5978},
{0.6845,0.5947},
{0.672,0.6008},
{0.6682,0.5562},
{0.6586,0.5922},
{0.6538,0.5542},
{0.6368,0.5637},
{0.6152,0.5421},
{0.6512,0.514},
{0.6196,0.5036},
{0.5875,0.517},
{0.5872,0.4898},
{0.5625,0.5057},
{0.5481,0.4804},
{0.5422,0.503},
{0.8272,0.4591},
{0.8276,0.4995},
{0.8131,0.4599},
{0.8148,0.5009},
{0.777,0.5004},
{0.777,0.4595},
{0.7376,0.4583},
{0.7365,0.5009},
{0.7079,0.462},
{0.7073,0.5086},
{0.7083,0.5373},
{0.6823,0.4638},
{0.6802,0.5141},
{0.6834,0.5521},
{0.6618,0.4657},
{0.6645,0.5151},
{0.6473,0.4653},
{0.6185,0.4625},
{0.5903,0.4567},
{0.5537,0.4487},
{0.5506,0.4142},
{0.5483,0.396},
{0.5676,0.3959},
{0.5681,0.4131},
{0.5856,0.3922},
{0.5841,0.4132},
{0.6069,0.3978},
{0.6042,0.416},
{0.6234,0.4008},
{0.628,0.4182},
{0.6347,0.4026},
{0.6544,0.4234},
{0.6588,0.4064},
{0.6568,0.3998},
{0.6746,0.3938},
{0.6897,0.3933},
{0.6828,0.4122},
{0.7148,0.4021},
{0.7037,0.4198},
{0.6774,0.4325},
{0.693,0.4393},
{0.6838,0.4566},
{0.67,0.4496},
{0.649,0.4412},
{0.6219,0.4355},
{0.6014,0.4315},
{0.5836,0.4307},
{0.5669,0.4299},
{0.5525,0.4316},
{0.0305,0.3509},
{0.0103,0.3503},
{0.0103,0.341},
{0.0333,0.3434},
{0.042,0.3615},
{0.0489,0.3472},
{0.0614,0.3554},
{0.0547,0.3701},
{0.0686,0.3725},
{0.0616,0.3915},
{0.0702,0.3916},
{0.053,0.3775},
{0.0396,0.4531},
{0.0103,0.4513},
{0.0103,0.4462},
{0.0384,0.449},
{0.0547,0.4452},
{0.0519,0.4428},
{0.0622,0.4304},
{0.0592,0.4255},
{0.0682,0.4036},
{0.0583,0.4016},
{0.0111,0.3844},
{0.0104,0.3726},
{0.0383,0.3746},
{0.0381,0.3869},
{0.0099,0.402},
{0.0351,0.4009},
{0.0333,0.4173},
{0.0103,0.4147},
{0.3377,0.4731},
{0.3387,0.4951},
{0.2996,0.504},
{0.2942,0.4808},
{0.2678,0.4822},
{0.2749,0.5084},
{0.2569,0.5028},
{0.2476,0.4797},
{0.2444,0.4971},
{0.2367,0.4809},
{0.232,0.4856},
{0.2086,0.4645},
{0.2006,0.4788},
{0.1871,0.4501},
{0.1718,0.4683},
{0.1714,0.4357},
{0.1512,0.4526},
{0.1352,0.4328},
{0.1538,0.4157},
{0.129,0.4083},
{0.149,0.3841},
{0.1285,0.3927},
{0.1318,0.3775},
{0.1398,0.3591},
{0.1554,0.3653},
{0.1552,0.3426},
{0.1665,0.3497},
{0.1796,0.3262},
{0.186,0.3327},
{0.2144,0.3123},
{0.2185,0.3164},
{0.2395,0.2982},
{0.2422,0.3028},
{0.2502,0.2751},
{0.2535,0.2777},
{0.2557,0.2571},
{0.2449,0.2497},
{0.3368,0.4571},
{0.2888,0.4605},
{0.2526,0.46},
{0.2361,0.4601},
{0.2184,0.4596},
{0.1999,0.4412},
{0.1906,0.4273},
{0.1809,0.4118},
{0.1759,0.3926},
{0.184,0.369},
{0.207,0.3551},
{0.2234,0.3253},
{0.2345,0.3272},
{0.2463,0.3106},
{0.2699,0.3045},
{0.2757,0.2817},
{0.2748,0.2576},
{0.3365,0.4473},
{0.2875,0.4503},
{0.2535,0.4514},
{0.2342,0.4352},
{0.2151,0.4348},
{0.2108,0.4201},
{0.2061,0.4057},
{0.2053,0.3926},
{0.2096,0.3739},
{0.2328,0.3488},
{0.2473,0.3332},
{0.2607,0.3174},
{0.2932,0.3111},
{0.2995,0.287},
{0.2999,0.2591},
{0.3398,0.4227},
{0.2875,0.4198},
{0.2549,0.4206},
{0.2353,0.4184},
{0.2341,0.3944},
{0.233,0.3707},
{0.253,0.3708},
{0.248,0.3437},
{0.2863,0.3337},
{0.3317,0.3357},
{0.3319,0.3178},
{0.3329,0.2973},
{0.3382,0.2698},
{0.3377,0.3917},
{0.2857,0.3929},
{0.2556,0.3939},
{0.2856,0.3701},
{0.2844,0.3443},
{0.3326,0.3446},
{0.3356,0.3662},
{0.3443,0.3674},
{0.3404,0.3917},
{0.3384,0.3662},
{0.3462,0.3481},
{0.3353,0.3446},
{0.3445,0.3332},
{0.3344,0.3357},
{0.3346,0.3178},
{0.3431,0.314},
{0.3356,0.2973},
{0.3427,0.2958},
{0.3409,0.2698},
{0.3459,0.2732},
{0.3393,0.4473},
{0.3425,0.4227},
{0.3474,0.4441},
{0.3395,0.4571},
{0.3454,0.4648},
{0.3404,0.4731},
{0.3472,0.4936},
{0.3414,0.4951},
{0.4015,0.5077},
{0.4016,0.4922},
{0.4076,0.5092},
{0.4034,0.5292},
{0.3753,0.5514},
{0.3884,0.5482},
{0.3735,0.5599},
{0.3654,0.5654},
{0.3724,0.564},
{0.3732,0.5718},
{0.3642,0.5773},
{0.3719,0.5743},
{0.3728,0.5909},
{0.3663,0.5913},
{0.3715,0.6109},
{0.3753,0.6112},
{0.3778,0.6314},
{0.3805,0.6285},
{0.3774,0.6128},
{0.375,0.4594},
{0.3841,0.4704},
{0.3718,0.462},
{0.3752,0.4493},
{0.3745,0.4465},
{0.3727,0.6562},
{0.3648,0.6624},
{0.3629,0.6331},
{0.3702,0.6329},
{0.3645,0.6121},
{0.3584,0.6128},
{0.3606,0.5904},
{0.3561,0.5896},
{0.3627,0.5771},
{0.3615,0.5564},
{0.3643,0.5653},
{0.3751,0.5501},
{0.3669,0.5316},
{0.3816,0.5312},
{0.368,0.5148},
{0.3828,0.508},
{0.367,0.5034},
{0.3815,0.4874},
{0.3658,0.4865},
{0.3824,0.4736},
{0.3636,0.4688},
{0.3709,0.4624},
{0.3614,0.4438},
{0.3741,0.4443},
{0.3686,0.4355},
{0.3759,0.4272},
{0.4371,0.4353},
{0.435,0.4524},
{0.4785,0.4458},
{0.476,0.4593},
{0.5128,0.4577},
{0.5089,0.4698},
{0.4751,0.4651},
{0.5061,0.4728},
{0.4749,0.4738},
{0.5044,0.482},
{0.506,0.4859},
{0.4742,0.479},
{0.4713,0.4911},
{0.5041,0.4974},
{0.5032,0.5124},
{0.4705,0.5099},
{0.5038,0.5317},
{0.469,0.5329},
{0.5054,0.548},
{0.4703,0.5505},
{0.5032,0.5503},
{0.4698,0.5541},
{0.4718,0.5626},
{0.5031,0.5582},
{0.4728,0.567},
{0.5054,0.5598},
{0.5071,0.5747},
{0.4733,0.5803},
{0.5087,0.588},
{0.4751,0.5944},
{0.5072,0.5913},
{0.4753,0.599},
{0.51,0.6053},
{0.4768,0.6153},
{0.4787,0.6199},
{0.5121,0.6074},
{0.483,0.6323},
{0.5162,0.6184},
{0.3806,0.6499},
{0.3775,0.6327},
{0.3706,0.6113},
{0.3652,0.5913},
{0.4396,0.6279},
{0.3815,0.6285},
{0.4384,0.6234},
{0.4367,0.6064},
{0.3787,0.6125},
{0.4351,0.6017},
{0.3766,0.611},
{0.4333,0.588},
{0.374,0.5908},
{0.4334,0.5707},
{0.3729,0.5747},
{0.4339,0.5668},
{0.3745,0.5717},
{0.3735,0.5639},
{0.4326,0.5563},
{0.3743,0.5606},
{0.4327,0.5527},
{0.3905,0.5471},
{0.4029,0.5337},
{0.4416,0.6431},
{0.4354,0.5343},
{0.4089,0.5092},
{0.4367,0.5099},
{0.436,0.488},
{0.4009,0.4869},
{0.434,0.4746},
{0.387,0.4731},
{0.4005,0.5079},
{0.4355,0.4689},
{0.3759,0.4592},
{0.4335,0.4571},
{0.3763,0.4492},
{0.5054,0.5582},
{0.5055,0.5503},
{0.5077,0.548},
{0.5077,0.5598},
{0.5164,0.5502},
{0.5132,0.5306},
{0.5061,0.5317},
{0.5055,0.5124},
{0.5128,0.5137},
{0.5064,0.4974},
{0.5163,0.5008},
{0.5083,0.4859},
{0.5167,0.4865},
{0.5112,0.4698},
{0.5067,0.482},
{0.5084,0.4728},
{0.5182,0.4728},
{0.5151,0.4577},
{0.5217,0.4554},
{0.5151,0.5741},
{0.5094,0.5747},
{0.511,0.588},
{0.5146,0.5897},
{0.5165,0.5986},
{0.5144,0.6074},
{0.52,0.6115},
{0.5185,0.6184},
{0.5123,0.6053},
{0.5095,0.5913},
{0.6543,0.9871},
{0.6461,0.9929},
{0.6433,0.9889},
{0.6562,0.983},
{0.655,0.9727},
{0.6407,0.9841},
{0.6462,0.9674},
{0.6343,0.9761},
{0.6369,0.9607},
{0.6274,0.9686},
{0.6266,0.9553},
{0.621,0.9639},
{0.6161,0.9504},
{0.6111,0.9591},
{0.6091,0.9471},
{0.6043,0.9558},
{0.6045,0.9446},
{0.5979,0.9511},
{0.5935,0.9458},
{0.597,0.9427},
{0.5904,0.9404},
{0.5953,0.9382},
{0.6037,0.9371},
{0.6115,0.9398},
{0.6184,0.9422},
{0.6285,0.9456},
{0.633,0.945},
{0.6414,0.9485},
{0.634,0.9422},
{0.6436,0.9394},
{0.6339,0.9365},
{0.6422,0.9285},
{0.6354,0.9277},
{0.6401,0.9198},
{0.6475,0.9179},
{0.6423,0.9011},
{0.6356,0.9019},
{0.6404,0.8953},
{0.6341,0.8959},
{0.6363,0.882},
{0.63,0.8811},
{0.6346,0.8762},
{0.6286,0.8748},
{0.6274,0.8606},
{0.6311,0.8629},
{0.63,0.8577},
{0.637,0.8616},
{0.6351,0.8566},
{0.6398,0.8589},
{0.6426,0.8748},
{0.6471,0.8716},
{0.6445,0.8805},
{0.6494,0.8775},
{0.6536,0.8893},
{0.6482,0.8934},
{0.6499,0.8992},
{0.6553,0.8951},
{0.6593,0.91},
{0.6549,0.9165},
{0.6673,0.9132},
{0.6613,0.9097},
{0.6653,0.8902},
{0.6591,0.8907},
{0.6648,0.8841},
{0.6585,0.8843},
{0.6629,0.867},
{0.6572,0.8659},
{0.6622,0.861},
{0.6569,0.8596},
{0.656,0.8444},
{0.6604,0.8448},
{0.6591,0.8389},
{0.6657,0.8382},
{0.6659,0.8444},
{0.6699,0.8438},
{0.6681,0.8597},
{0.6739,0.8571},
{0.6688,0.8657},
{0.6752,0.8632},
{0.6773,0.8798},
{0.6709,0.8828},
{0.6719,0.8888},
{0.6782,0.8861},
{0.6814,0.9058},
{0.6773,0.913},
{0.6843,0.9061},
{0.6897,0.9112},
{0.6886,0.8896},
{0.6834,0.8888},
{0.6883,0.8836},
{0.6832,0.8824},
{0.6879,0.8677},
{0.6831,0.8666},
{0.688,0.8615},
{0.6832,0.8602},
{0.6835,0.8485},
{0.6886,0.85},
{0.6876,0.8422},
{0.6938,0.85},
{0.6933,0.8415},
{0.6975,0.8461},
{0.6934,0.8604},
{0.6996,0.8582},
{0.6934,0.8665},
{0.7003,0.8645},
{0.7017,0.8818},
{0.6943,0.883},
{0.6948,0.8891},
{0.7022,0.8882},
{0.7035,0.9074},
{0.6978,0.9117},
{0.7045,0.9072},
{0.7088,0.9126},
{0.7107,0.894},
{0.7044,0.8924},
{0.7113,0.8878},
{0.7046,0.8859},
{0.7123,0.8763},
{0.7051,0.8748},
{0.7128,0.87},
{0.7057,0.8683},
{0.7066,0.8594},
{0.7135,0.8611},
{0.7108,0.8538},
{0.7195,0.8612},
{0.7227,0.8529},
{0.7246,0.8596},
{0.7184,0.87},
{0.724,0.8691},
{0.7294,0.8597},
{0.7288,0.8519},
{0.7344,0.8515},
{0.7342,0.8586},
{0.7389,0.8572},
{0.7409,0.8657},
{0.7346,0.867},
{0.7352,0.873},
{0.7419,0.8718},
{0.7371,0.8847},
{0.743,0.8824},
{0.7385,0.891},
{0.7437,0.8884},
{0.7423,0.9057},
{0.7444,0.9017},
{0.7513,0.9031},
{0.7474,0.9009},
{0.7512,0.8813},
{0.7459,0.8835},
{0.7512,0.8751},
{0.7457,0.8774},
{0.746,0.8603},
{0.751,0.86},
{0.751,0.854},
{0.7463,0.854},
{0.7515,0.8448},
{0.7478,0.8413},
{0.7516,0.8368},
{0.7575,0.8366},
{0.7575,0.8448},
{0.762,0.8426},
{0.7633,0.8535},
{0.7573,0.8543},
{0.7574,0.8604},
{0.7639,0.8597},
{0.7584,0.8743},
{0.7649,0.8753},
{0.7589,0.8805},
{0.7652,0.8815},
{0.7611,0.9029},
{0.7657,0.8981},
{0.7726,0.9027},
{0.7686,0.8974},
{0.7756,0.878},
{0.7705,0.8775},
{0.7763,0.8719},
{0.771,0.8712},
{0.7719,0.8543},
{0.7784,0.8537},
{0.7791,0.8477},
{0.7728,0.848},
{0.7806,0.8373},
{0.7762,0.8344},
{0.7797,0.8295},
{0.7863,0.8297},
{0.7858,0.8365},
{0.79,0.8345},
{0.7905,0.8496},
{0.7853,0.8484},
{0.7849,0.8544},
{0.7906,0.8559},
{0.7835,0.8725},
{0.7908,0.8738},
{0.7833,0.8786},
{0.7906,0.8801},
{0.7837,0.9036},
{0.7891,0.8995},
{0.7921,0.8999},
{0.7943,0.9058},
{0.8,0.8868},
{0.7942,0.8835},
{0.8019,0.8807},
{0.7956,0.877},
{0.7993,0.8668},
{0.8061,0.8674},
{0.8078,0.8617},
{0.8013,0.8609},
{0.8107,0.8521},
{0.8072,0.8476},
{0.8116,0.8452},
{0.8166,0.8465},
{0.8157,0.8531},
{0.8192,0.8496},
{0.8187,0.8639},
{0.8138,0.8631},
{0.8126,0.869},
{0.8178,0.8702},
{0.8097,0.8829},
{0.8149,0.8848},
{0.8083,0.889},
{0.8138,0.8909},
{0.8041,0.9065},
{0.8102,0.9093},
{0.8077,0.918},
{0.7971,0.9172},
{0.7966,0.9373},
{0.8081,0.9251},
{0.81,0.9284},
{0.806,0.9396},
{0.8112,0.931},
{0.8152,0.9389},
{0.8152,0.931},
{0.8264,0.9298},
{0.8266,0.9372},
{0.8341,0.9288},
{0.834,0.9358},
{0.8414,0.9355},
{0.8433,0.9293},
{0.8515,0.9339},
{0.8427,0.9428},
{0.8526,0.9405},
{0.8486,0.9455},
{0.8553,0.947},
{0.85,0.9522},
{0.8429,0.9571},
{0.8391,0.9512},
{0.8329,0.9539},
{0.8357,0.9608},
{0.823,0.9579},
{0.8252,0.9659},
{0.8149,0.9613},
{0.8177,0.9712},
{0.8076,0.9762},
{0.8059,0.9641},
{0.7966,0.9676},
{0.7985,0.9796},
{0.7933,0.982},
{0.7822,0.9758},
{0.7894,0.9903},
{0.7777,0.9855},
{0.7674,0.981},
{0.7633,0.9719},
{0.7478,0.9802},
{0.7458,0.9693},
{0.7333,0.9651},
{0.7336,0.9735},
{0.7326,0.98},
{0.7218,0.9817},
{0.7227,0.9745},
{0.7164,0.9732},
{0.7054,0.9824},
{0.7026,0.9772},
{0.6849,0.9821},
{0.683,0.9796},
{0.6691,0.9848},
{0.6667,0.9792},
{0.6539,0.9566},
{0.6489,0.9574},
{0.6507,0.9428},
{0.6541,0.9296},
{0.7174,0.9627},
{0.7004,0.953},
{0.6978,0.9754},
{0.6863,0.9768},
{0.6757,0.9564},
{0.6716,0.947},
{0.6587,0.9356},
{0.7214,0.9627},
{0.7158,0.9467},
{0.7016,0.9428},
{0.6946,0.9522},
{0.6811,0.9546},
{0.6744,0.9434},
{0.6745,0.9278},
{0.726,0.9643},
{0.7254,0.9497},
{0.72,0.9458},
{0.7122,0.924},
{0.7081,0.9287},
{0.6963,0.9411},
{0.6723,0.9204},
{0.6931,0.9262},
{0.6937,0.9186},
{0.7238,0.9378},
{0.7218,0.9222},
{0.718,0.9134},
{0.7341,0.936},
{0.7342,0.9221},
{0.7265,0.9115},
{0.7184,0.8941},
{0.7341,0.9496},
{0.7505,0.9407},
{0.7516,0.9246},
{0.7403,0.9118},
{0.7332,0.9126},
{0.7302,0.8934},
{0.7244,0.8932},
{0.724,0.8873},
{0.7185,0.8881},
{0.7181,0.8769},
{0.7474,0.9555},
{0.766,0.9604},
{0.7706,0.9458},
{0.7739,0.9281},
{0.7575,0.9119},
{0.7295,0.8873},
{0.7238,0.8755},
{0.5809,0.9484},
{0.5905,0.9855},
{0.5506,0.9927},
{0.5485,0.9535},
{0.5156,0.9552},
{0.5162,0.9971},
{0.5032,0.9973},
{0.5036,0.9545},
{0.4917,0.9538},
{0.4879,0.9975},
{0.4632,0.9533},
{0.457,0.9963},
{0.4321,0.9522},
{0.4279,0.9923},
{0.4033,0.9506},
{0.3976,0.9883},
{0.3937,0.9492},
{0.387,0.9882},
{0.3715,0.9453},
{0.3628,0.9824},
{0.3316,0.9737},
{0.343,0.9373},
{0.3575,0.9046},
{0.3815,0.9093},
{0.3661,0.8685},
{0.3872,0.8721},
{0.3837,0.8355},
{0.3597,0.8252},
{0.3852,0.8292},
{0.3649,0.819},
{0.5748,0.9128},
{0.5443,0.9166},
{0.5141,0.9193},
{0.5035,0.9184},
{0.4901,0.9173},
{0.4653,0.9162},
{0.4368,0.9152},
{0.4107,0.9116},
{0.3998,0.911},
{0.4042,0.8765},
{0.407,0.8404},
{0.4038,0.832},
{0.5427,0.8759},
{0.5136,0.88},
{0.5052,0.8793},
{0.488,0.8779},
{0.4624,0.8782},
{0.4375,0.8807},
{0.4158,0.8778},
{0.5697,0.8759},
{0.5643,0.8331},
{0.5475,0.8295},
{0.5319,0.833},
{0.5165,0.8424},
{0.5095,0.8431},
{0.4901,0.8374},
{0.4711,0.8325},
{0.4565,0.8355},
{0.437,0.8431},
{0.4178,0.8425},
{0.5473,0.8227},
{0.5295,0.827},
{0.5107,0.8328},
{0.4919,0.8315},
{0.4728,0.8257},
{0.4541,0.8288},
{0.4393,0.8355},
{0.4209,0.8331},
{0.5671,0.8253},
{0.3713,0.3058},
{0.3511,0.2994},
{0.3581,0.2834},
{0.3936,0.2829},
{0.3657,0.2603},
{0.3955,0.2608},
{0.3828,0.2273},
{0.4016,0.2381},
{0.4011,0.2058},
{0.4092,0.2196},
{0.4229,0.1969},
{0.4244,0.2079},
{0.4411,0.2115},
{0.4463,0.1997},
{0.4591,0.2264},
{0.4712,0.2158},
{0.4704,0.2502},
{0.4888,0.2418},
{0.478,0.277},
{0.4989,0.2694},
{0.505,0.29},
{0.4891,0.3071},
{0.5099,0.3051},
{0.4982,0.3316},
{0.5201,0.3172},
{0.5044,0.3542},
{0.5285,0.3427},
{0.5079,0.3724},
{0.5339,0.366},
{0.5365,0.3856},
{0.5105,0.39},
{0.5374,0.4023},
{0.5099,0.4102},
{0.5374,0.4197},
{0.5321,0.4327},
{0.511,0.4365},
{0.4921,0.4117},
{0.4909,0.4333},
{0.4817,0.4308},
{0.4854,0.4115},
{0.4919,0.393},
{0.4805,0.3945},
{0.4878,0.3769},
{0.4712,0.3783},
{0.4704,0.3597},
{0.4846,0.358},
{0.4692,0.3399},
{0.4823,0.3368},
{0.4703,0.3159},
{0.4597,0.3242},
{0.458,0.3011},
{0.4464,0.3163},
{0.4349,0.3053},
{0.4431,0.2913},
{0.4196,0.2898},
{0.4226,0.3022},
{0.4009,0.3005},
{0.4105,0.3122},
{0.3925,0.3247},
{0.3864,0.3181},
{0.4173,0.2706},
{0.4181,0.2467},
{0.4204,0.2312},
{0.4263,0.2158},
{0.4377,0.2157},
{0.4479,0.2329},
{0.45,0.2522},
{0.448,0.2746},
{0.2206,0.2223},
{0.2178,0.2077},
{0.2283,0.1966},
{0.236,0.2355},
{0.2481,0.1909},
{0.2577,0.2436},
{0.2774,0.1931},
{0.2808,0.2448},
{0.2972,0.196},
{0.2977,0.2434},
{0.3101,0.2425},
{0.3113,0.1963},
{0.3218,0.241},
{0.3223,0.1967},
{0.3412,0.2353},
{0.3355,0.1995},
{0.3499,0.2201},
{0.3458,0.2063},
{0.9228,0.7821},
{0.8888,0.7933},
{0.8886,0.7658},
{0.9239,0.7615},
{0.8874,0.7301},
{0.9213,0.7301},
{0.9485,0.7301},
{0.9546,0.7571},
{0.9833,0.7301},
{0.9821,0.754},
{0.9808,0.7724},
{0.956,0.775},
{0.8796,0.7949},
{0.8686,0.7981},
{0.8682,0.7663},
{0.8781,0.7655},
{0.8651,0.7301},
{0.8771,0.7301},
{0.8663,0.7981},
{0.8589,0.8008},
{0.8607,0.7661},
{0.866,0.7663},
{0.8577,0.7301},
{0.8628,0.7301},
{0.8865,0.7933},
{0.8818,0.7949},
{0.8803,0.7655},
{0.8864,0.7658},
{0.8793,0.7301},
{0.8851,0.7301},
{0.8126,0.8149},
{0.8057,0.8154},
{0.8043,0.7679},
{0.8094,0.7675},
{0.8105,0.7323},
{0.8151,0.7301},
{0.6246,0.7658},
{0.6242,0.7933},
{0.5903,0.7821},
{0.5892,0.7615},
{0.557,0.775},
{0.5585,0.7571},
{0.5323,0.7724},
{0.5309,0.754},
{0.5297,0.7301},
{0.5645,0.7301},
{0.5917,0.7301},
{0.6253,0.7301},
{0.6449,0.7663},
{0.6427,0.7981},
{0.6322,0.7947},
{0.6345,0.7655},
{0.6456,0.7301},
{0.6341,0.7301},
{0.6523,0.7663},
{0.6505,0.801},
{0.644,0.7981},
{0.6462,0.7663},
{0.6513,0.7301},
{0.6468,0.7301},
{0.633,0.7655},
{0.6307,0.7947},
{0.6262,0.7933},
{0.6266,0.7658},
{0.6326,0.7301},
{0.6273,0.7301},
{0.7035,0.7682},
{0.7034,0.8158},
{0.6969,0.8156},
{0.6982,0.7679},
{0.7007,0.7321},
{0.6951,0.7307},
{0.8424,0.7665},
{0.8427,0.7887},
{0.8304,0.7888},
{0.8298,0.7669},
{0.8292,0.7392},
{0.8414,0.7386},
{0.8301,0.7902},
{0.8429,0.7901},
{0.845,0.7923},
{0.828,0.7927},
{0.8291,0.7895},
{0.8272,0.7923},
{0.8248,0.7669},
{0.8285,0.7671},
{0.8279,0.7387},
{0.8261,0.7362},
{0.8413,0.7375},
{0.8287,0.7377},
{0.8271,0.7355},
{0.8428,0.7347},
{0.8424,0.7375},
{0.844,0.7351},
{0.8468,0.7663},
{0.8437,0.7667},
{0.8437,0.7891},
{0.8458,0.7916},
{0.6732,0.7746},
{0.6601,0.7725},
{0.6621,0.7698},
{0.6728,0.7709},
{0.681,0.7709},
{0.6832,0.7734},
{0.687,0.7655},
{0.6855,0.773},
{0.6816,0.7702},
{0.6828,0.7656},
{0.6819,0.7613},
{0.6859,0.7581},
{0.6562,0.7648},
{0.6577,0.7581},
{0.6621,0.76},
{0.6603,0.7648},
{0.6616,0.7693},
{0.6578,0.7713},
{0.6629,0.7596},
{0.6589,0.7574},
{0.6734,0.7552},
{0.6729,0.7592},
{0.6816,0.7603},
{0.6854,0.7574},
{0.8824,0.147},
{0.861,0.1895},
{0.8448,0.1297},
{0.8336,0.1761},
{0.8525,0.2048},
{0.826,0.1907},
{0.8117,0.2059},
{0.845,0.2241},
{0.8365,0.2375},
{0.8062,0.2203},
{0.8325,0.2464},
{0.7998,0.2296},
{0.785,0.2129},
{0.7767,0.2245},
{0.7572,0.2067},
{0.7539,0.2209},
{0.7292,0.2078},
{0.7226,0.2217},
{0.706,0.217},
{0.7007,0.2259},
{0.6853,0.2264},
{0.6832,0.2344},
{0.7955,0.1637},
{0.7925,0.1788},
{0.7899,0.1893},
{0.8086,0.1179},
{0.7919,0.114},
{0.7851,0.1617},
{0.7837,0.1765},
{0.7801,0.1876},
{0.7648,0.1924},
{0.7256,0.1919},
{0.7024,0.1998},
{0.6856,0.2152},
{0.766,0.1597},
{0.7656,0.1771},
{0.725,0.1745},
{0.7049,0.1835},
{0.6743,0.2026},
{0.6826,0.215},
{0.661,0.2338},
{0.6678,0.2425},
{0.6402,0.2388},
{0.6473,0.2319},
{0.6299,0.2144},
{0.6383,0.2},
{0.6066,0.1973},
{0.611,0.1837},
{0.5815,0.1883},
{0.585,0.2019},
{0.6047,0.2082},
{0.6282,0.2168},
{0.6235,0.2211},
{0.605,0.2167},
{0.6257,0.229},
{0.7721,0.112},
{0.7363,0.1119},
{0.7314,0.1581},
{0.707,0.1623},
{0.7025,0.1124},
{0.6678,0.1139},
{0.6682,0.1632},
{0.654,0.1155},
{0.6493,0.1632},
{0.6109,0.162},
{0.6269,0.1128},
{0.5935,0.1076},
{0.581,0.1538},
{0.577,0.1693},
{0.6444,0.1887},
{0.6706,0.1881},
{0.6206,0.1707},
{0.6203,0.1794},
{0.6119,0.1832},
{0.6119,0.1633},
{0.6367,0.1806},
{0.6217,0.1794},
{0.622,0.1707},
{0.6372,0.172},
{0.6503,0.1721},
{0.6504,0.1817},
{0.6749,0.1706},
{0.6746,0.1815},
{0.6972,0.1703},
{0.6975,0.179},
{0.7041,0.1822},
{0.6988,0.179},
{0.6986,0.1703},
{0.7058,0.1636},
{0.645,0.1878},
{0.6203,0.1805},
{0.6367,0.1817},
{0.6504,0.1828},
{0.6705,0.1869},
{0.6746,0.1826},
{0.6988,0.1801},
{0.7036,0.183},
{0.6372,0.1708},
{0.6206,0.1695},
{0.6489,0.1647},
{0.6503,0.1709},
{0.6677,0.1648},
{0.6749,0.1694},
{0.6986,0.1691},
{0.7051,0.1634},
{0.8573,0.3697},
{0.8749,0.3899},
{0.8556,0.378},
{0.8262,0.3732},
{0.8252,0.3653},
{0.7975,0.3714},
{0.7984,0.3782},
{0.7727,0.3822},
{0.7745,0.3899},
{0.7554,0.407},
{0.5837,0.2109},
{0.0047,0.0118},
{0.0455,0.0077},
{0.0115,0.0585},
{0.047,0.0543},
{0.0815,0.0564},
{0.0822,0.0086},
{0.0969,0.0098},
{0.0916,0.0577},
{0.11,0.0605},
{0.1141,0.0123},
{0.1467,0.0185},
{0.1431,0.066},
{0.1777,0.0236},
{0.1667,0.0698},
{0.1879,0.0757},
{0.2097,0.0298},
{0.2092,0.0791},
{0.2215,0.0317},
{0.2225,0.0811},
{0.258,0.0757},
{0.2471,0.0281},
{0.2794,0.0218},
{0.2924,0.067},
{0.2667,0.097},
{0.2967,0.0819},
{0.2923,0.1005},
{0.2673,0.1153},
{0.2936,0.1086},
{0.2686,0.1189},
{0.2948,0.1168},
{0.27,0.1241},
{0.249,0.1275},
{0.2487,0.1259},
{0.231,0.1344},
{0.2315,0.1361},
{0.0147,0.0745},
{0.049,0.0703},
{0.0798,0.0722},
{0.0904,0.073},
{0.11,0.0791},
{0.1479,0.0844},
{0.1665,0.0936},
{0.1906,0.1094},
{0.2103,0.1165},
{0.2211,0.1178},
{0.2406,0.1111},
{0.2459,0.1224},
{0.2191,0.1365},
{0.2101,0.1367},
{0.1895,0.1247},
{0.1663,0.1101},
{0.1463,0.101},
{0.1093,0.0988},
{0.1438,0.1098},
{0.1613,0.1133},
{0.1606,0.1167},
{0.1772,0.1232},
{0.1759,0.1247},
{0.1919,0.1303},
{0.1925,0.1288},
{0.6196,0.0372},
{0.6394,0.0688},
{0.6017,0.082},
{0.583,0.0484},
{0.5687,0.0994},
{0.556,0.06},
{0.5324,0.0714},
{0.5432,0.1132},
{0.5094,0.0754},
{0.5161,0.1225},
{0.495,0.0769},
{0.5025,0.1256},
{0.4825,0.1246},
{0.4792,0.0775},
{0.4574,0.1227},
{0.4529,0.0745},
{0.428,0.118},
{0.4281,0.0754},
{0.3892,0.1174},
{0.3922,0.0702},
{0.3617,0.0664},
{0.3542,0.1139},
{0.3412,0.1106},
{0.3489,0.0651},
{0.3085,0.0953},
{0.3157,0.0586},
{0.3298,0.0265},
{0.3046,0.0163},
{0.5835,0.013},
{0.5653,0.0188},
{0.5421,0.0275},
{0.5232,0.035},
{0.5074,0.041},
{0.4895,0.0432},
{0.4706,0.0406},
{0.4546,0.0393},
{0.4329,0.0393},
{0.4061,0.0382},
{0.3846,0.038},
{0.3618,0.0348},
{0.5698,0.3419},
{0.5372,0.3223},
{0.5583,0.2899},
{0.5848,0.3027},
{0.5979,0.2654},
{0.571,0.2543},
{0.6032,0.2522},
{0.5753,0.241},
{0.5974,0.244},
{0.5743,0.2348},
{0.6079,0.3154},
{0.6193,0.275},
{0.6235,0.2651},
{0.6218,0.2563},
{0.5949,0.3571},
{0.6306,0.3206},
{0.6333,0.2848},
{0.6349,0.2723},
{0.6355,0.2658},
{0.622,0.3679},
{0.6449,0.3228},
{0.6517,0.2889},
{0.654,0.2775},
{0.6526,0.2702},
{0.6694,0.2716},
{0.6696,0.266},
{0.6904,0.266},
{0.6906,0.2609},
{0.7149,0.2623},
{0.7157,0.2577},
{0.7407,0.2638},
{0.75,0.2556},
{0.7584,0.2666},
{0.7765,0.2556},
{0.7753,0.2661},
{0.7961,0.2641},
{0.8032,0.2534},
{0.8151,0.261},
{0.8389,0.2551},
{0.8463,0.2557},
{0.8185,0.2742},
{0.8508,0.2672},
{0.824,0.3118},
{0.8612,0.3015},
{0.8651,0.3394},
{0.8265,0.3495},
{0.7899,0.3137},
{0.7933,0.3602},
{0.7774,0.3135},
{0.7819,0.3621},
{0.7485,0.3638},
{0.7471,0.316},
{0.7113,0.3209},
{0.7106,0.3641},
{0.6869,0.3204},
{0.6814,0.3689},
{0.6606,0.3236},
{0.6562,0.3709},
{0.6358,0.3715},
{0.6672,0.2858},
{0.6895,0.2813},
{0.7139,0.279},
{0.7387,0.2806},
{0.7567,0.2818},
{0.7761,0.2811},
{0.7976,0.2772},
{0.8254,0.3859},
{0.8383,0.4125},
{0.7888,0.4124},
{0.7976,0.3875},
{0.7866,0.8215},
{0.7673,0.8271},
{0.767,0.8104},
{0.7849,0.8072},
{0.8026,0.8154},
{0.8013,0.7679},
{0.7858,0.7703},
{0.7843,0.736},
{0.8074,0.7323},
{0.779,0.7313},
{0.7539,0.7346},
{0.7539,0.7317},
{0.7288,0.7313},
{0.7235,0.736},
{0.7039,0.7318},
{0.7068,0.7679},
{0.7223,0.7703},
{0.7235,0.8072},
{0.7058,0.8154},
{0.7218,0.8215},
{0.7415,0.8104},
{0.7411,0.8271},
{0.7585,0.8068},
{0.7572,0.8253},
{0.7539,0.8254},
{0.7539,0.8013},
{0.7493,0.8068},
{0.7506,0.8253},
{0.7759,0.8026},
{0.7719,0.7987},
{0.7777,0.7723},
{0.7735,0.7723},
{0.7735,0.7481},
{0.7776,0.744},
{0.7539,0.7431},
{0.7539,0.7476},
{0.7343,0.7481},
{0.7302,0.744},
{0.7301,0.7723},
{0.7343,0.7723},
{0.7359,0.7987},
{0.7318,0.8026},
{0.7828,0.8055},
{0.7658,0.8089},
{0.7612,0.8074},
{0.7765,0.8038},
{0.765,0.8105},
{0.765,0.8252},
{0.7586,0.8251},
{0.7597,0.8078},
{0.7539,0.795},
{0.7667,0.795},
{0.7713,0.7981},
{0.7539,0.7994},
{0.7365,0.7981},
{0.7411,0.795},
{0.7833,0.804},
{0.7775,0.8028},
{0.779,0.7723},
{0.7834,0.7723},
{0.7788,0.7431},
{0.7825,0.7395},
{0.7724,0.7723},
{0.7712,0.7966},
{0.767,0.7938},
{0.768,0.7723},
{0.7685,0.7551},
{0.7727,0.7498},
{0.725,0.8055},
{0.7313,0.8038},
{0.7465,0.8074},
{0.742,0.8089},
{0.7428,0.8105},
{0.7481,0.8078},
{0.7491,0.8251},
{0.7428,0.8252},
{0.7288,0.7723},
{0.7303,0.8028},
{0.7245,0.804},
{0.7244,0.7723},
{0.729,0.7431},
{0.7253,0.7395},
{0.7408,0.7938},
{0.7366,0.7966},
{0.7354,0.7723},
{0.7398,0.7723},
{0.7393,0.7551},
{0.7351,0.7498},
{1.1905,0.1654},
{1.1828,0.1654},
{1.1762,0.1817},
{1.1854,0.1869},
{1.1761,0.2186},
{1.1684,0.2124},
{1.0092,0.4213},
{1.01,0.433},
{1.0372,0.4268},
{1.0321,0.4217},
{1.0343,0.4216},
{1.0889,0.3469},
{1.0714,0.3484},
{1.0748,0.3653},
{1.0927,0.3633},
{1.0774,0.3809},
{1.095,0.3791},
{1.0791,0.3948},
{1.0951,0.3944},
{1.0776,0.41},
{1.0954,0.4107},
{1.0754,0.4245},
{1.093,0.426},
{1.0724,0.4397},
{1.0904,0.4416},
{1.0703,0.4502},
{1.0877,0.4526},
{1.0685,0.4593},
{1.0859,0.4622},
{1.0691,0.3469},
{1.0673,0.3452},
{1.0719,0.3715},
{1.0728,0.3721},
{1.0754,0.3942},
{1.0764,0.3946},
{1.0731,0.4099},
{1.0747,0.4101},
{1.0686,0.4326},
{1.0702,0.4325},
{1.0646,0.4607},
{1.0659,0.4602},
{1.0903,0.3437},
{1.0899,0.3455},
{1.0975,0.3704},
{1.0987,0.3685},
{1.0991,0.3939},
{1.1008,0.3932},
{1.0988,0.4111},
{1.1005,0.4111},
{1.0959,0.4349},
{1.0972,0.436},
{1.087,0.4636},
{1.0873,0.4651},
{1.0694,0.3464},
{1.0894,0.3452},
{1.0897,0.3435},
{1.0675,0.3449},
{1.0867,0.4637},
{1.0663,0.4606},
{1.0648,0.461},
{1.087,0.4651},
{1.0708,0.3483},
{1.0694,0.3471},
{1.0733,0.3721},
{1.0743,0.3651},
{1.0771,0.3808},
{1.0769,0.3947},
{1.0789,0.3948},
{1.075,0.4101},
{1.0773,0.4101},
{1.0708,0.4327},
{1.0749,0.4246},
{1.0717,0.4398},
{1.0664,0.46},
{1.0696,0.4504},
{1.0677,0.4591},
{1.0891,0.3456},
{1.0696,0.3467},
{1.0711,0.3479},
{1.0889,0.3465},
{1.0896,0.3459},
{1.0894,0.3469},
{1.0934,0.3631},
{1.0974,0.3705},
{1.0959,0.379},
{1.096,0.3943},
{1.0986,0.394},
{1.0963,0.4107},
{1.0985,0.4111},
{1.0937,0.4261},
{1.0954,0.4347},
{1.0909,0.4417},
{1.0881,0.4528},
{1.0869,0.4634},
{1.0861,0.4623},
{1.0665,0.4603},
{1.0865,0.4635},
{1.0859,0.4625},
{1.0679,0.4597},
{1.0669,0.3449},
{1.0651,0.3438},
{1.0698,0.372},
{1.0715,0.3716},
{1.0718,0.3913},
{1.0748,0.3939},
{1.0698,0.4036},
{1.0728,0.4095},
{1.0657,0.4322},
{1.0681,0.4326},
{1.0625,0.461},
{1.0642,0.4608},
{1.0671,0.3445},
{1.0901,0.3426},
{1.0911,0.3396},
{1.0651,0.3435},
{1.0874,0.4653},
{1.0874,0.4684},
{1.0992,0.437},
{1.0975,0.4363},
{1.1048,0.4095},
{1.1009,0.4111},
{1.1068,0.3864},
{1.1014,0.3929},
{1.1025,0.3661},
{1.0989,0.3685},
{1.0906,0.3434},
{1.0913,0.3404},
{1.0871,0.4653},
{1.0642,0.4612},
{1.0624,0.4613},
{1.087,0.4686},
{1.0382,0.3907},
{1.0111,0.3882},
{1.01,0.3981},
{1.0351,0.3971},
{1.0369,0.3967},
{1.0103,0.4856},
{1.0103,0.4943},
{1.0368,0.4992},
{1.0411,0.49},
{1.0776,0.4935},
{1.0644,0.5026},
{1.0828,0.5237},
{1.0639,0.5484},
{1.0841,0.5511},
{1.0852,0.5784},
{1.0837,0.6085},
{1.0651,0.5952},
{1.0442,0.6188},
{1.0376,0.6044},
{1.0103,0.6252},
{1.0103,0.6104},
{1.0103,0.4669},
{1.0435,0.471},
{1.0875,0.4691},
{1.1013,0.4913},
{1.1114,0.5231},
{1.1253,0.5535},
{1.1126,0.5979},
{1.0857,0.6412},
{1.051,0.6504},
{1.0103,0.658},
{1.0103,0.4525},
{1.0396,0.4543},
{1.062,0.4616},
{1.0554,0.4461},
{1.0631,0.4304},
{1.0651,0.432},
{1.0691,0.4036},
{1.0987,0.4653},
{1.1057,0.4896},
{1.1151,0.5192},
{1.131,0.5482},
{1.1444,0.5602},
{1.1388,0.5716},
{1.1333,0.6062},
{1.1339,0.6365},
{1.1129,0.637},
{1.0996,0.4373},
{1.1014,0.4379},
{1.1061,0.4386},
{1.1051,0.4638},
{1.1067,0.4142},
{1.1129,0.4159},
{1.1052,0.4098},
{1.1669,0.5762},
{1.1654,0.5834},
{1.157,0.6203},
{1.1549,0.6404},
{1.0103,0.4954},
{1.0103,0.5056},
{1.0364,0.5095},
{1.0368,0.5002},
{1.0637,0.5037},
{1.0581,0.5125},
{1.0629,0.5484},
{1.0569,0.5491},
{1.0641,0.594},
{1.0586,0.5873},
{1.0376,0.6033},
{1.0366,0.5935},
{1.0103,0.5985},
{1.0103,0.6093},
{1.0366,0.5924},
{1.0573,0.5862},
{1.0553,0.5848},
{1.0359,0.5878},
{1.0103,0.5974},
{1.0103,0.5916},
{1.0534,0.5496},
{1.0555,0.584},
{1.0575,0.5854},
{1.0557,0.5491},
{1.0547,0.5156},
{1.0568,0.5135},
{1.0358,0.5151},
{1.054,0.5154},
{1.0562,0.5133},
{1.0364,0.511},
{1.0103,0.5071},
{1.0103,0.5122},
{1.0119,0.1548},
{1.0089,0.1564},
{1.0089,0.1583},
{1.0364,0.1583},
{1.0336,0.1499},
{1.0483,0.1455},
{1.0672,0.1583},
{1.0662,0.1431},
{1.089,0.1494},
{1.1039,0.1583},
{1.0996,0.1502},
{1.1044,0.1474},
{1.1425,0.1583},
{1.1372,0.1442},
{1.1668,0.1481},
{1.191,0.1583},
{1.1905,0.1457},
{1.0131,0.15},
{1.0508,0.1417},
{1.0866,0.1438},
{1.2016,0.1739},
{1.1921,0.1654},
{1.1877,0.1877},
{1.2006,0.195},
{1.1771,0.2201},
{1.192,0.2334},
{1.1603,0.2387},
{1.1596,0.2315},
{1.133,0.2569},
{1.1902,0.2407},
{1.9607,0.0694},
{1.9916,0.0667},
{1.9916,0.06},
{1.9595,0.0637},
{1.9299,0.0668},
{1.933,0.078},
{1.9082,0.069},
{1.9094,0.0805},
{1.89,0.0787},
{1.8889,0.0699},
{1.8718,0.07},
{1.864,0.0524},
{1.8718,0.0674},
{1.8889,0.0673},
{1.8855,0.0453},
{1.9084,0.0465},
{1.9082,0.0664},
{1.9298,0.0454},
{1.9299,0.0643},
{1.9587,0.043},
{1.9595,0.0611},
{1.9916,0.0574},
{1.9916,0.0397},
{1.9916,0.0225},
{1.957,0.0225},
{1.9296,0.0225},
{1.9073,0.0225},
{1.8853,0.0225},
{1.8649,0.0388},
{1.8643,0.0225},
{1.543,0.7096},
{1.5536,0.7062},
{1.543,0.6822},
{1.5746,0.6739},
{1.5833,0.7016},
{1.603,0.6681},
{1.6187,0.6984},
{1.6192,0.6823},
{1.6422,0.692},
{1.6421,0.6999},
{1.6587,0.6983},
{1.6592,0.7008},
{1.6833,0.7063},
{1.7005,0.7},
{1.7136,0.7079},
{1.711,0.6725},
{1.7378,0.6795},
{1.7368,0.7096},
{1.762,0.6811},
{1.7603,0.7129},
{1.7852,0.6825},
{1.7859,0.7134},
{1.8226,0.7145},
{1.8226,0.6843},
{1.7843,0.6448},
{1.8226,0.6451},
{1.7916,0.6191},
{1.8226,0.6173},
{1.7987,0.5999},
{1.8226,0.5995},
{1.801,0.5846},
{1.8226,0.5852},
{1.8226,0.5601},
{1.8153,0.5606},
{1.796,0.5681},
{1.8075,0.5465},
{1.5693,0.6405},
{1.5821,0.6367},
{1.5872,0.6354},
{1.6057,0.6671},
{1.62,0.6773},
{1.6431,0.6832},
{1.6597,0.6716},
{1.6439,0.6744},
{1.6518,0.6463},
{1.6622,0.6448},
{1.6615,0.6383},
{1.7022,0.6463},
{1.7044,0.6401},
{1.7121,0.6467},
{1.7018,0.6724},
{1.543,0.6421},
{1.543,0.6165},
{1.5666,0.6147},
{1.5714,0.6102},
{1.5762,0.6056},
{1.5924,0.6341},
{1.6083,0.6661},
{1.6208,0.6723},
{1.543,0.5964},
{1.5548,0.5982},
{1.5591,0.5778},
{1.5701,0.5693},
{1.5721,0.5448},
{1.5551,0.547},
{1.5649,0.5245},
{1.5684,0.5223},
{1.7603,0.6502},
{1.7687,0.6202},
{1.7859,0.6043},
{1.7803,0.5867},
{1.7367,0.6576},
{1.7438,0.6256},
{1.755,0.602},
{1.7263,0.6368},
{1.7341,0.61},
{1.7118,0.6184},
{1.6902,0.623},
{1.6761,0.6286},
{1.6347,0.6656},
{1.551,0.519},
{1.543,0.5466},
{1.543,0.516},
{1.543,0.5815},
{1.6998,0.6724},
{1.7001,0.6488},
{1.6639,0.6474},
{1.6617,0.6717},
{1.6985,0.6974},
{1.6608,0.6958},
{1.9045,0.4785},
{1.9029,0.4463},
{1.863,0.452},
{1.8639,0.4877},
{1.8272,0.4591},
{1.8276,0.4995},
{1.8131,0.4599},
{1.8148,0.5009},
{1.777,0.5004},
{1.777,0.4595},
{1.7376,0.4583},
{1.7365,0.5009},
{1.7079,0.462},
{1.7073,0.5086},
{1.6823,0.4638},
{1.6802,0.5141},
{1.6618,0.4657},
{1.6645,0.5151},
{1.6512,0.514},
{1.6473,0.4653},
{1.6196,0.5036},
{1.6185,0.4625},
{1.5872,0.4898},
{1.5903,0.4567},
{1.5481,0.4804},
{1.5537,0.4487},
{1.9041,0.5033},
{1.8759,0.5111},
{1.8515,0.5209},
{1.8263,0.5296},
{1.8164,0.5321},
{1.7803,0.5391},
{1.7565,0.5444},
{1.7325,0.553},
{1.7083,0.5373},
{1.6834,0.5521},
{1.6682,0.5562},
{1.6538,0.5542},
{1.6152,0.5421},
{1.5875,0.517},
{1.5625,0.5057},
{1.5422,0.503},
{1.9039,0.5071},
{1.8785,0.5152},
{1.8545,0.5267},
{1.8247,0.5398},
{1.7987,0.543},
{1.7729,0.5489},
{1.7483,0.5517},
{1.7327,0.557},
{1.7157,0.5633},
{1.7019,0.5761},
{1.6845,0.5947},
{1.672,0.6008},
{1.6586,0.5922},
{1.6368,0.5637},
{1.7171,0.5672},
{1.7099,0.578},
{1.6889,0.5978},
{1.5676,0.3959},
{1.5483,0.396},
{1.5506,0.4142},
{1.5681,0.4131},
{1.5669,0.4299},
{1.5525,0.4316},
{1.5856,0.3922},
{1.5841,0.4132},
{1.5836,0.4307},
{1.6014,0.4315},
{1.6042,0.416},
{1.6219,0.4355},
{1.628,0.4182},
{1.649,0.4412},
{1.6544,0.4234},
{1.6774,0.4325},
{1.67,0.4496},
{1.6838,0.4566},
{1.693,0.4393},
{1.7037,0.4198},
{1.6828,0.4122},
{1.7148,0.4021},
{1.6897,0.3933},
{1.6588,0.4064},
{1.6746,0.3938},
{1.6568,0.3998},
{1.6347,0.4026},
{1.6234,0.4008},
{1.6069,0.3978},
{1.0103,0.341},
{1.0103,0.3503},
{1.0305,0.3509},
{1.0333,0.3434},
{1.042,0.3615},
{1.0489,0.3472},
{1.0614,0.3554},
{1.0547,0.3701},
{1.053,0.3775},
{1.0616,0.3915},
{1.0686,0.3725},
{1.0702,0.3916},
{1.0103,0.4462},
{1.0103,0.4513},
{1.0396,0.4531},
{1.0384,0.449},
{1.0547,0.4452},
{1.0519,0.4428},
{1.0622,0.4304},
{1.0592,0.4255},
{1.0682,0.4036},
{1.0583,0.4016},
{1.0111,0.3844},
{1.0381,0.3869},
{1.0383,0.3746},
{1.0104,0.3726},
{1.0099,0.402},
{1.0103,0.4147},
{1.0333,0.4173},
{1.0351,0.4009},
{1.2996,0.504},
{1.3387,0.4951},
{1.3377,0.4731},
{1.2942,0.4808},
{1.3368,0.4571},
{1.2888,0.4605},
{1.3365,0.4473},
{1.2875,0.4503},
{1.3398,0.4227},
{1.2875,0.4198},
{1.3377,0.3917},
{1.2857,0.3929},
{1.2856,0.3701},
{1.3356,0.3662},
{1.2844,0.3443},
{1.3326,0.3446},
{1.2863,0.3337},
{1.3317,0.3357},
{1.2932,0.3111},
{1.3319,0.3178},
{1.3329,0.2973},
{1.2995,0.287},
{1.3382,0.2698},
{1.2999,0.2591},
{1.2757,0.2817},
{1.2748,0.2576},
{1.2535,0.2777},
{1.2557,0.2571},
{1.2502,0.2751},
{1.2449,0.2497},
{1.2678,0.4822},
{1.2526,0.46},
{1.2535,0.4514},
{1.2549,0.4206},
{1.2556,0.3939},
{1.253,0.3708},
{1.248,0.3437},
{1.2473,0.3332},
{1.2607,0.3174},
{1.2699,0.3045},
{1.2749,0.5084},
{1.2569,0.5028},
{1.2476,0.4797},
{1.2361,0.4601},
{1.2342,0.4352},
{1.2353,0.4184},
{1.2341,0.3944},
{1.233,0.3707},
{1.2328,0.3488},
{1.2345,0.3272},
{1.2463,0.3106},
{1.2444,0.4971},
{1.2367,0.4809},
{1.2184,0.4596},
{1.2151,0.4348},
{1.2108,0.4201},
{1.2061,0.4057},
{1.2053,0.3926},
{1.2096,0.3739},
{1.207,0.3551},
{1.2234,0.3253},
{1.2422,0.3028},
{1.2395,0.2982},
{1.2185,0.3164},
{1.2144,0.3123},
{1.186,0.3327},
{1.1796,0.3262},
{1.1665,0.3497},
{1.1552,0.3426},
{1.1554,0.3653},
{1.1398,0.3591},
{1.149,0.3841},
{1.1318,0.3775},
{1.1285,0.3927},
{1.129,0.4083},
{1.1538,0.4157},
{1.1352,0.4328},
{1.1714,0.4357},
{1.1512,0.4526},
{1.1718,0.4683},
{1.1871,0.4501},
{1.2006,0.4788},
{1.2086,0.4645},
{1.232,0.4856},
{1.1759,0.3926},
{1.1809,0.4118},
{1.1906,0.4273},
{1.1999,0.4412},
{1.184,0.369},
{1.3384,0.3662},
{1.3404,0.3917},
{1.3443,0.3674},
{1.3462,0.3481},
{1.3353,0.3446},
{1.3445,0.3332},
{1.3344,0.3357},
{1.3346,0.3178},
{1.3431,0.314},
{1.3356,0.2973},
{1.3427,0.2958},
{1.3409,0.2698},
{1.3459,0.2732},
{1.3474,0.4441},
{1.3425,0.4227},
{1.3393,0.4473},
{1.3395,0.4571},
{1.3454,0.4648},
{1.3404,0.4731},
{1.3472,0.4936},
{1.3414,0.4951},
{1.4076,0.5092},
{1.4016,0.4922},
{1.4015,0.5077},
{1.4034,0.5292},
{1.3735,0.5599},
{1.3884,0.5482},
{1.3753,0.5514},
{1.3654,0.5654},
{1.3724,0.564},
{1.3732,0.5718},
{1.3642,0.5773},
{1.3719,0.5743},
{1.3728,0.5909},
{1.3663,0.5913},
{1.3715,0.6109},
{1.3753,0.6112},
{1.3778,0.6314},
{1.3805,0.6285},
{1.3774,0.6128},
{1.3718,0.462},
{1.3841,0.4704},
{1.375,0.4594},
{1.3752,0.4493},
{1.3745,0.4465},
{1.3629,0.6331},
{1.3648,0.6624},
{1.3727,0.6562},
{1.3702,0.6329},
{1.3806,0.6499},
{1.3775,0.6327},
{1.4396,0.6279},
{1.4416,0.6431},
{1.4787,0.6199},
{1.483,0.6323},
{1.3645,0.6121},
{1.3706,0.6113},
{1.3584,0.6128},
{1.3606,0.5904},
{1.3652,0.5913},
{1.3561,0.5896},
{1.3627,0.5771},
{1.3615,0.5564},
{1.3643,0.5653},
{1.3751,0.5501},
{1.3669,0.5316},
{1.3816,0.5312},
{1.3905,0.5471},
{1.4029,0.5337},
{1.4327,0.5527},
{1.3743,0.5606},
{1.4326,0.5563},
{1.3735,0.5639},
{1.4339,0.5668},
{1.3745,0.5717},
{1.3729,0.5747},
{1.4334,0.5707},
{1.374,0.5908},
{1.4333,0.588},
{1.3766,0.611},
{1.4351,0.6017},
{1.3787,0.6125},
{1.4367,0.6064},
{1.3815,0.6285},
{1.4384,0.6234},
{1.4768,0.6153},
{1.4753,0.599},
{1.4751,0.5944},
{1.4733,0.5803},
{1.4728,0.567},
{1.4718,0.5626},
{1.4698,0.5541},
{1.4703,0.5505},
{1.4354,0.5343},
{1.469,0.5329},
{1.4367,0.5099},
{1.4705,0.5099},
{1.436,0.488},
{1.4713,0.4911},
{1.434,0.4746},
{1.4742,0.479},
{1.4749,0.4738},
{1.4355,0.4689},
{1.4751,0.4651},
{1.4335,0.4571},
{1.476,0.4593},
{1.435,0.4524},
{1.4785,0.4458},
{1.4371,0.4353},
{1.3741,0.4443},
{1.3759,0.4272},
{1.3686,0.4355},
{1.3614,0.4438},
{1.3709,0.4624},
{1.3636,0.4688},
{1.3824,0.4736},
{1.3658,0.4865},
{1.3815,0.4874},
{1.367,0.5034},
{1.3828,0.508},
{1.368,0.5148},
{1.4089,0.5092},
{1.4009,0.4869},
{1.387,0.4731},
{1.3759,0.4592},
{1.3763,0.4492},
{1.4005,0.5079},
{1.5643,0.8331},
{1.5671,0.8253},
{1.5473,0.8227},
{1.5475,0.8295},
{1.5295,0.827},
{1.5319,0.833},
{1.5165,0.8424},
{1.5107,0.8328},
{1.5095,0.8431},
{1.4901,0.8374},
{1.4919,0.8315},
{1.4728,0.8257},
{1.4711,0.8325},
{1.4541,0.8288},
{1.4565,0.8355},
{1.4393,0.8355},
{1.437,0.8431},
{1.4209,0.8331},
{1.4178,0.8425},
{1.4038,0.832},
{1.407,0.8404},
{1.3837,0.8355},
{1.3852,0.8292},
{1.3597,0.8252},
{1.3649,0.819},
{1.5427,0.8759},
{1.5136,0.88},
{1.5052,0.8793},
{1.488,0.8779},
{1.4624,0.8782},
{1.4375,0.8807},
{1.4158,0.8778},
{1.4042,0.8765},
{1.3872,0.8721},
{1.3661,0.8685},
{1.5443,0.9166},
{1.5141,0.9193},
{1.5035,0.9184},
{1.4901,0.9173},
{1.4653,0.9162},
{1.4368,0.9152},
{1.4107,0.9116},
{1.3998,0.911},
{1.3815,0.9093},
{1.3575,0.9046},
{1.3715,0.9453},
{1.343,0.9373},
{1.3316,0.9737},
{1.3628,0.9824},
{1.387,0.9882},
{1.3937,0.9492},
{1.3976,0.9883},
{1.4033,0.9506},
{1.4279,0.9923},
{1.4321,0.9522},
{1.457,0.9963},
{1.4632,0.9533},
{1.4879,0.9975},
{1.4917,0.9538},
{1.5032,0.9973},
{1.5036,0.9545},
{1.5156,0.9552},
{1.5162,0.9971},
{1.5506,0.9927},
{1.5485,0.9535},
{1.5809,0.9484},
{1.5905,0.9855},
{1.5748,0.9128},
{1.5697,0.8759},
{1.3581,0.2834},
{1.3511,0.2994},
{1.3713,0.3058},
{1.3936,0.2829},
{1.4009,0.3005},
{1.3864,0.3181},
{1.3925,0.3247},
{1.4105,0.3122},
{1.4226,0.3022},
{1.4196,0.2898},
{1.4349,0.3053},
{1.4431,0.2913},
{1.458,0.3011},
{1.4464,0.3163},
{1.4597,0.3242},
{1.4703,0.3159},
{1.4692,0.3399},
{1.4823,0.3368},
{1.4846,0.358},
{1.4704,0.3597},
{1.4878,0.3769},
{1.4712,0.3783},
{1.4805,0.3945},
{1.4919,0.393},
{1.4854,0.4115},
{1.4921,0.4117},
{1.4817,0.4308},
{1.4909,0.4333},
{1.511,0.4365},
{1.5099,0.4102},
{1.5321,0.4327},
{1.5374,0.4197},
{1.5374,0.4023},
{1.5105,0.39},
{1.5365,0.3856},
{1.5079,0.3724},
{1.5339,0.366},
{1.5285,0.3427},
{1.5044,0.3542},
{1.5201,0.3172},
{1.4982,0.3316},
{1.5099,0.3051},
{1.4891,0.3071},
{1.505,0.29},
{1.478,0.277},
{1.4989,0.2694},
{1.4888,0.2418},
{1.4704,0.2502},
{1.4712,0.2158},
{1.4591,0.2264},
{1.4463,0.1997},
{1.4411,0.2115},
{1.4229,0.1969},
{1.4244,0.2079},
{1.4092,0.2196},
{1.4011,0.2058},
{1.4016,0.2381},
{1.3828,0.2273},
{1.3955,0.2608},
{1.3657,0.2603},
{1.4173,0.2706},
{1.448,0.2746},
{1.4181,0.2467},
{1.45,0.2522},
{1.4204,0.2312},
{1.4479,0.2329},
{1.4377,0.2157},
{1.4263,0.2158},
{1.2283,0.1966},
{1.2178,0.2077},
{1.2206,0.2223},
{1.236,0.2355},
{1.2481,0.1909},
{1.2577,0.2436},
{1.2774,0.1931},
{1.2808,0.2448},
{1.2972,0.196},
{1.2977,0.2434},
{1.3101,0.2425},
{1.3113,0.1963},
{1.3218,0.241},
{1.3223,0.1967},
{1.3412,0.2353},
{1.3355,0.1995},
{1.3499,0.2201},
{1.3458,0.2063},
{0.7539,0.7549},
{0.7669,0.7547},
{0.7666,0.7723},
{0.7539,0.7723},
{0.7659,0.7937},
{0.7539,0.7937},
{0.7419,0.7937},
{0.7412,0.7723},
{0.7409,0.7547},
{0.7539,0.7375},
{0.7804,0.7391},
{0.7776,0.7424},
{0.7539,0.7419},
{0.7302,0.7424},
{0.7274,0.7391},
{0.7539,0.7487},
{0.7717,0.749},
{0.7674,0.7535},
{0.7539,0.753},
{0.7404,0.7535},
{0.7361,0.749},
{0.7808,0.9607},
{0.7966,0.9545},
{0.8094,0.9507},
{0.8177,0.9487},
{0.8286,0.9462},
{0.8348,0.9448},
{0.7865,0.948},
{0.7885,0.934},
{0.7792,0.9134},
{0.5572,0.241},
{0.5585,0.2196},
{0.5605,0.2194},
{0.545,0.2038},
{0.5602,0.1926},
{0.5514,0.1868},
{0.5304,0.196},
{0.527,0.2},
{0.5062,0.202},
{0.5049,0.1992},
{0.4855,0.2057},
{0.0882,0.0857},
{0.0805,0.0976},
{0.109,0.1063},
{0.1088,0.1138},
{0.1414,0.1187},
{0.1598,0.1201},
{0.1746,0.1261},
{0.1914,0.1318},
{0.0776,0.1107},
{0.0496,0.0999},
{0.049,0.1075},
{0.0163,0.0999},
{0.0185,0.1068},
{0.0142,0.093},
{0.0502,0.0922},
{0.0788,0.0833},
{0.2591,0.147},
{0.2561,0.1364},
{0.2894,0.1364},
{0.2916,0.1464},
{0.3232,0.1451},
{0.3194,0.1364},
{0.3519,0.1441},
{0.3517,0.1364},
{0.3835,0.1467},
{0.3857,0.1364},
{0.4116,0.1476},
{0.4158,0.1364},
{0.4292,0.1492},
{0.4405,0.136},
{0.4448,0.1483},
{0.4488,0.1488},
{0.4639,0.1504},
{0.4686,0.1348},
{0.4679,0.1502},
{0.4978,0.1358},
{0.4828,0.1489},
{0.4868,0.147},
{0.5033,0.1475},
{0.5098,0.1468},
{0.5275,0.1364},
{0.5272,0.1439},
{0.5539,0.1364},
{0.5584,0.1445},
{0.5282,0.176},
{0.5589,0.1706},
{0.5374,0.1797},
{0.5561,0.1767},
{0.2615,0.174},
{0.294,0.1713},
{0.3252,0.1709},
{0.3517,0.1702},
{0.3798,0.1719},
{0.4088,0.1737},
{0.4246,0.1766},
{0.292,0.1797},
{0.327,0.1749},
{0.3517,0.175},
{0.3745,0.1767},
{0.4025,0.1787},
{0.4244,0.1819},
{0.4409,0.179},
{0.4407,0.1834},
{0.4464,0.1788},
{0.4596,0.1839},
{0.4613,0.1776},
{0.4672,0.1764},
{0.477,0.1821},
{0.4838,0.1744},
{0.493,0.1791},
{0.4903,0.1738},
{0.5058,0.1764},
{0.513,0.1794},
{0.5114,0.1751},
{0.2633,0.181},
{0.9781,0.3432},
{0.9706,0.3425},
{0.9695,0.3295},
{0.9764,0.3262},
{0.9672,0.3259},
{0.9423,0.3267},
{0.9403,0.3195},
{0.9676,0.3183},
{0.9429,0.3429},
{0.9419,0.3285},
{0.9668,0.3285},
{0.9675,0.3416},
{0.94,0.3541},
{0.9423,0.3462},
{0.9669,0.3466},
{0.9682,0.3541},
{0.9674,0.364},
{0.939,0.3619},
{0.9399,0.3559},
{0.968,0.358},
{0.9405,0.3733},
{0.9392,0.3655},
{0.9676,0.3668},
{0.9659,0.3745},
{0.9659,0.3904},
{0.9407,0.3896},
{0.941,0.3765},
{0.9664,0.3765},
{0.94,0.3291},
{0.9405,0.3434},
{0.9324,0.3453},
{0.9326,0.3274},
{0.9687,0.5188},
{0.9684,0.5045},
{0.9754,0.5032},
{0.9762,0.5218},
{0.9387,0.488},
{0.9673,0.488},
{0.967,0.4951},
{0.9386,0.4942},
{0.9383,0.4861},
{0.9401,0.4779},
{0.9655,0.4788},
{0.9669,0.4864},
{0.9661,0.5037},
{0.9401,0.5034},
{0.9389,0.4969},
{0.9672,0.4968},
{0.9662,0.5051},
{0.966,0.5193},
{0.9415,0.5198},
{0.9402,0.505},
{0.9387,0.5291},
{0.9405,0.5219},
{0.965,0.5219},
{0.9665,0.5298},
{0.9316,0.5044},
{0.9382,0.5049},
{0.9391,0.5198},
{0.9322,0.5227},
{0.9398,0.477},
{0.9401,0.4629},
{0.9651,0.4626},
{0.9653,0.4771},
{0.9674,0.4772},
{0.9675,0.4628},
{0.9755,0.4615},
{0.975,0.4786},
{0.9378,0.4431},
{0.9395,0.4357},
{0.9649,0.4367},
{0.9659,0.4438},
{0.9383,0.4517},
{0.9386,0.4451},
{0.9667,0.4454},
{0.9666,0.4513},
{0.9385,0.4537},
{0.9668,0.4536},
{0.965,0.4613},
{0.9401,0.4609},
{0.9386,0.4017},
{0.9663,0.4025},
{0.9656,0.4083},
{0.9388,0.408},
{0.9386,0.3991},
{0.9404,0.3918},
{0.9655,0.3933},
{0.9663,0.4007},
{0.94,0.4183},
{0.9384,0.4104},
{0.9653,0.4114},
{0.9646,0.4187},
{0.9381,0.3763},
{0.9371,0.3893},
{0.9296,0.39},
{0.9303,0.3745},
{0.9371,0.476},
{0.9291,0.4784},
{0.93,0.4612},
{0.9373,0.4618},
{0.9761,0.3931},
{0.9688,0.3913},
{0.9701,0.3775},
{0.9779,0.3764},
{0.9404,0.4204},
{0.965,0.4204},
{0.9652,0.4344},
{0.9398,0.4344},
{0.9372,0.4348},
{0.9298,0.436},
{0.9302,0.4189},
{0.938,0.4208},
{0.9754,0.4191},
{0.9757,0.4358},
{0.9687,0.4346},
{0.9683,0.4207},
{0.2306,0.1329},
{0.2483,0.1237},
{0.6798,0.1},
{0.6576,0.1},
{0.659,0.0521},
{0.6783,0.0521},
{0.7026,0.1},
{0.7044,0.0524},
{0.7348,0.1},
{0.7361,0.0531},
{0.7597,0.0519},
{0.7586,0.1},
{0.784,0.0534},
{0.7839,0.1},
{0.8132,0.1},
{0.8105,0.0525},
{0.8489,0.1},
{0.8485,0.052},
{0.9007,0.4088},
{0.8932,0.435},
{0.8953,0.408},
{0.8989,0.3856},
{0.9067,0.3865},
{0.8996,0.3629},
{0.9094,0.3629},
{0.9021,0.3321},
{0.8974,0.3394},
{0.896,0.3122},
{0.8935,0.3125},
{0.893,0.2905},
{0.8968,0.2906},
{1.659,0.0521},
{1.6576,0.1},
{1.6798,0.1},
{1.6783,0.0521},
{1.7026,0.1},
{1.7044,0.0524},
{1.7348,0.1},
{1.7361,0.0531},
{1.7597,0.0519},
{1.7586,0.1},
{1.784,0.0534},
{1.7839,0.1},
{1.8132,0.1},
{1.8105,0.0525},
{1.8489,0.1},
{1.8485,0.052},
{1.8953,0.408},
{1.8932,0.435},
{1.9007,0.4088},
{1.8989,0.3856},
{1.9067,0.3865},
{1.8996,0.3629},
{1.9094,0.3629},
{1.9021,0.3321},
{1.8974,0.3394},
{1.896,0.3122},
{1.8935,0.3125},
{1.893,0.2905},
{1.8968,0.2906},
{0.9669,0.8627},
{0.9578,0.8627},
{0.9585,0.8599},
{0.9662,0.8599},
{0.9389,0.8314},
{0.9482,0.8314},
{0.9474,0.8341},
{0.9397,0.8341},
{0.948,0.8623},
{0.9387,0.8623},
{0.9395,0.8595},
{0.9472,0.8595},
{0.9657,0.8584},
{0.958,0.8583},
{0.958,0.847},
{0.9658,0.847},
{0.9581,0.8356},
{0.9658,0.8356},
{0.9696,0.8594},
{0.9668,0.8586},
{0.9668,0.8472},
{0.9699,0.8472},
{0.9669,0.8358},
{0.9697,0.8351},
{0.9547,0.8352},
{0.9574,0.836},
{0.9572,0.8474},
{0.954,0.8473},
{0.9565,0.8588},
{0.9537,0.8594},
{0.947,0.8581},
{0.9393,0.8581},
{0.9392,0.8467},
{0.9471,0.8467},
{0.9393,0.8353},
{0.947,0.8353},
{0.9507,0.8591},
{0.9479,0.8583},
{0.9479,0.8469},
{0.9511,0.8469},
{0.948,0.8355},
{0.9508,0.8347},
{0.9358,0.8348},
{0.9385,0.8357},
{0.9384,0.8471},
{0.9353,0.847},
{0.9382,0.8585},
{0.9354,0.8592},
{0.0693,0.372},
{0.0621,0.3549},
{0.0642,0.3428},
{0.0489,0.3452},
{0.0566,0.3278},
{0.0333,0.3414},
{0.0321,0.3249},
{0.0103,0.339},
{0.0103,0.3276},
{0.0765,0.326},
{0.0557,0.3031},
{0.0317,0.305},
{0.0103,0.3072},
{0.0918,0.3389},
{0.0923,0.3253},
{0.0996,0.3412},
{0.1044,0.3655},
{0.1031,0.3658},
{0.1093,0.3805},
{0.1075,0.3858},
{0.0789,0.3004},
{0.0548,0.269},
{0.0307,0.2719},
{0.0103,0.2729},
{0.1005,0.2929},
{0.1013,0.3228},
{0.1081,0.3233},
{0.1065,0.3461},
{0.1103,0.3655},
{0.1153,0.3785},
{0.0325,0.2482},
{0.0103,0.2421},
{0.0571,0.2484},
{0.0849,0.2633},
{0.1246,0.2501},
{0.1077,0.2917},
{0.1152,0.2934},
{0.0309,0.222},
{0.0103,0.2192},
{0.0636,0.2236},
{0.0807,0.2497},
{0.1032,0.222},
{0.147,0.2281},
{0.1573,0.2307},
{0.1306,0.2561},
{0.0336,0.1918},
{0.0103,0.1906},
{0.0671,0.1911},
{0.0369,0.1663},
{0.0103,0.1663},
{0.0681,0.1663},
{0.104,0.1663},
{0.1018,0.1881},
{0.1422,0.2016},
{0.1663,0.2131},
{0.1747,0.2193},
{0.1414,0.1841},
{0.1445,0.1663},
{0.1774,0.1663},
{0.1743,0.1817},
{0.9036,0.1749},
{0.903,0.1609},
{0.9516,0.1611},
{0.9514,0.1755},
{0.904,0.1851},
{0.9035,0.1778},
{0.9513,0.1765},
{0.9502,0.1839},
{0.9046,0.2054},
{0.9043,0.1871},
{0.9505,0.1855},
{0.9511,0.2041},
{0.9516,0.2151},
{0.9041,0.2167},
{0.9041,0.2074},
{0.9506,0.2067},
{0.8944,0.2439},
{0.8953,0.2478},
{0.8909,0.2473},
{0.8965,0.2679},
{0.905,0.2651},
{0.9039,0.2478},
{0.8925,0.2706},
{0.9055,0.2421},
{0.9045,0.2336},
{0.9523,0.232},
{0.9514,0.2411},
{0.9036,0.2287},
{0.9032,0.2248},
{0.9514,0.2304},
{0.9516,0.2192},
{0.904,0.2181},
{0.954,0.2729},
{0.9063,0.276},
{0.9067,0.2671},
{0.9529,0.2649},
{0.9066,0.2654},
{0.9056,0.2481},
{0.9514,0.2454},
{0.9527,0.2632},
{0.6686,0.0487},
{0.6599,0.0473},
{0.6608,0.0403},
{0.6699,0.039},
{0.6999,0.0464},
{0.7017,0.0379},
{0.7061,0.0469},
{0.7348,0.0469},
{0.7413,0.0383},
{0.7389,0.0464},
{0.7665,0.0472},
{0.7676,0.0424},
{0.7857,0.0472},
{0.9526,0.2447},
{0.9616,0.2432},
{0.9622,0.2641},
{0.9543,0.2626},
{0.9524,0.1857},
{0.9598,0.1845},
{0.9611,0.206},
{0.9528,0.2043},
{0.9602,0.1287},
{0.961,0.1506},
{0.9532,0.149},
{0.9534,0.1301},
{0.9518,0.1059},
{0.9518,0.1186},
{0.9037,0.1188},
{0.9036,0.1059},
{0.9037,0.093},
{0.9518,0.0932},
{0.9043,0.1278},
{0.9037,0.1211},
{0.9518,0.1209},
{0.9505,0.1277},
{0.9059,0.1491},
{0.9055,0.1304},
{0.9516,0.1302},
{0.9515,0.1491},
{0.9537,0.159},
{0.905,0.1592},
{0.9065,0.1518},
{0.9521,0.1512},
{0.8842,0.2369},
{0.8804,0.2425},
{0.8839,0.2352},
{0.8935,0.2358},
{0.8971,0.2178},
{0.8904,0.2147},
{0.885,0.2156},
{0.8822,0.2326},
{0.8857,0.2042},
{0.8894,0.2021},
{0.8916,0.2006},
{0.8881,0.1865},
{0.8989,0.1977},
{0.8945,0.1792},
{0.8874,0.1793},
{0.8796,0.1688},
{0.8809,0.1681},
{1.9037,0.1749},
{1.9514,0.1755},
{1.9516,0.1611},
{1.903,0.1609},
{1.904,0.1851},
{1.9502,0.1839},
{1.9513,0.1765},
{1.9035,0.1778},
{1.9046,0.2054},
{1.9511,0.2041},
{1.9505,0.1855},
{1.9043,0.1871},
{1.9516,0.2151},
{1.9506,0.2067},
{1.9041,0.2074},
{1.9041,0.2167},
{1.8944,0.2439},
{1.8909,0.2473},
{1.8953,0.2478},
{1.8965,0.2679},
{1.8925,0.2706},
{1.905,0.2651},
{1.9039,0.2478},
{1.9055,0.2421},
{1.9514,0.2411},
{1.9523,0.232},
{1.9045,0.2336},
{1.9036,0.2287},
{1.9514,0.2304},
{1.9032,0.2248},
{1.9516,0.2192},
{1.904,0.2181},
{1.954,0.2729},
{1.9529,0.2649},
{1.9067,0.2671},
{1.9063,0.276},
{1.9066,0.2654},
{1.9527,0.2632},
{1.9514,0.2454},
{1.9056,0.2481},
{1.6608,0.0403},
{1.6599,0.0473},
{1.6686,0.0487},
{1.6699,0.039},
{1.6999,0.0464},
{1.7017,0.0379},
{1.7061,0.0469},
{1.7348,0.0469},
{1.7413,0.0383},
{1.7389,0.0464},
{1.7665,0.0472},
{1.7676,0.0424},
{1.7857,0.0472},
{1.9526,0.2447},
{1.9543,0.2626},
{1.9622,0.2641},
{1.9616,0.2432},
{1.9524,0.1857},
{1.9528,0.2043},
{1.9611,0.206},
{1.9598,0.1845},
{1.9602,0.1287},
{1.9534,0.1301},
{1.9532,0.149},
{1.961,0.1506},
{1.9043,0.1278},
{1.9505,0.1277},
{1.9518,0.1209},
{1.9037,0.1211},
{1.9059,0.1491},
{1.9515,0.1491},
{1.9516,0.1302},
{1.9055,0.1304},
{1.9537,0.159},
{1.9521,0.1512},
{1.9065,0.1518},
{1.905,0.1592},
{1.8839,0.2352},
{1.8804,0.2425},
{1.8842,0.2369},
{1.8935,0.2358},
{1.8971,0.2178},
{1.8904,0.2147},
{1.885,0.2156},
{1.8857,0.2042},
{1.8894,0.2021},
{1.8916,0.2006},
{1.8881,0.1865},
{1.8989,0.1977},
{1.8945,0.1792},
{1.8874,0.1793},
{1.8796,0.1688},
{1.8809,0.1681},
{1.8822,0.2326},
{0.1949,0.7616},
{0.1957,0.7534},
{0.1991,0.7636},
{0.1953,0.7716},
{0.2019,0.7753},
{0.1931,0.7825},
{0.2013,0.7851},
{0.1954,0.7955},
{0.1879,0.7931},
{0.1875,0.8054},
{0.1801,0.801},
{0.1785,0.8119},
{0.1707,0.8055},
{0.1604,0.814},
{0.1665,0.8184},
{0.1529,0.824},
{0.1582,0.8284},
{0.1487,0.839},
{0.1555,0.8391},
{0.1535,0.8537},
{0.1595,0.8514},
{0.1637,0.8634},
{0.1675,0.8601},
{0.1793,0.8675},
{0.1815,0.8629},
{0.197,0.8638},
{0.1942,0.8603},
{0.2034,0.8521},
{0.2087,0.855},
{0.2124,0.8415},
{0.2054,0.8411},
{0.2025,0.8289},
{0.2097,0.829},
{0.2054,0.8197},
{0.1971,0.8157},
{0.2075,0.815},
{0.2007,0.8072},
{0.2097,0.8005},
{0.2056,0.7975},
{0.21,0.7893},
{0.2073,0.7874},
{0.2101,0.7783},
{0.2077,0.7773},
{0.211,0.768},
{0.2127,0.7693},
{0.2181,0.7593},
{1.1991,0.7636},
{1.1957,0.7534},
{1.1949,0.7616},
{1.1953,0.7716},
{1.2019,0.7753},
{1.1931,0.7825},
{1.2013,0.7851},
{1.1954,0.7955},
{1.1879,0.7931},
{1.1875,0.8054},
{1.1801,0.801},
{1.1785,0.8119},
{1.1707,0.8055},
{1.1604,0.814},
{1.1665,0.8184},
{1.1529,0.824},
{1.1582,0.8284},
{1.1487,0.839},
{1.1555,0.8391},
{1.1535,0.8537},
{1.1595,0.8514},
{1.1637,0.8634},
{1.1675,0.8601},
{1.1793,0.8675},
{1.1815,0.8629},
{1.197,0.8638},
{1.1942,0.8603},
{1.2034,0.8521},
{1.2087,0.855},
{1.2124,0.8415},
{1.2054,0.8411},
{1.2025,0.8289},
{1.2097,0.829},
{1.2054,0.8197},
{1.1971,0.8157},
{1.2075,0.815},
{1.2007,0.8072},
{1.2097,0.8005},
{1.2056,0.7975},
{1.21,0.7893},
{1.2073,0.7874},
{1.2101,0.7783},
{1.2077,0.7773},
{1.211,0.768},
{1.2127,0.7693},
{1.2181,0.7593},
{0.7285,0.8742},
{0.7286,0.8682},
{0.6766,0.8096},
{0.652,0.801},
{0.6571,0.7729},
{0.6538,0.7663},
{0.6553,0.7647},
{0.6574,0.7566},
{0.6528,0.7301},
{0.6771,0.7301},
{0.6736,0.7547},
{0.6866,0.7569},
{0.6928,0.7301},
{0.6963,0.7679},
{0.6881,0.7657},
{0.6857,0.7741},
{0.6951,0.8156},
{0.6735,0.7753},
{0.6729,0.7701},
{0.6628,0.7694},
{0.673,0.7652},
{0.6803,0.7699},
{0.6813,0.7655},
{0.6805,0.761},
{0.673,0.7601},
{0.6633,0.7605},
{0.6622,0.765},
{0.8174,0.7301},
{0.8315,0.7301},
{0.8252,0.7348},
{0.8544,0.7301},
{0.8447,0.7336},
{0.8574,0.7661},
{0.8475,0.7662},
{0.8465,0.7931},
{0.8556,0.8008},
{0.8317,0.8081},
{0.8267,0.7933},
{0.8148,0.8149},
{0.8117,0.7675},
{0.8242,0.7668},
{0.8223,0.4528},
{0.8047,0.4516},
{0.8046,0.4387},
{0.7915,0.4419},
{0.7885,0.4333},
{0.7911,0.4257},
{0.7974,0.4281},
{0.8289,0.4274},
{0.8421,0.4231},
{0.8384,0.4347},
{0.8221,0.4402},
{0.8352,0.4428},
{0.8934,0.865},
{0.8938,0.881},
{0.883,0.8651},
{0.894,0.8495},
{0.8866,0.8311},
{0.8809,0.8567},
{0.8752,0.8509},
{0.8613,0.8316},
{0.8673,0.8488},
{0.8594,0.8509},
{0.8535,0.8568},
{0.8422,0.8328},
{0.8419,0.8658},
{0.8514,0.8652},
{0.8535,0.8736},
{0.843,0.8975},
{0.8615,0.8975},
{0.8594,0.8794},
{0.8673,0.8815},
{0.8752,0.8794},
{0.8866,0.8976},
{0.8809,0.8736},
{0.9116,0.8975},
{0.9058,0.8811},
{0.9113,0.8811},
{0.9065,0.8649},
{0.9115,0.8649},
{0.9116,0.8495},
{0.9058,0.8495},
{0.9118,0.8316},
{0.923,0.8809},
{0.9301,0.8975},
{0.9312,0.8658},
{0.9234,0.8652},
{0.931,0.8328},
{0.9231,0.8495},
{0.0327,0.9212},
{0.023,0.8876},
{0.0546,0.9126},
{0.0551,0.9536},
{0.0741,0.939},
{0.0759,0.9076},
{0.0694,0.8885},
{0.0471,0.8862},
{0.0466,0.875},
{0.021,0.8766},
{0.0448,0.8654},
{0.0221,0.8669},
{0.0225,0.8623},
{0.0415,0.8596},
{0.0225,0.8582},
{0.0399,0.8551},
{0.0374,0.8487},
{0.0319,0.8454},
{0.0186,0.8497},
{0.0169,0.8321},
{0.0302,0.8282},
{0.0157,0.8153},
{0.0271,0.8132},
{0.0167,0.8105},
{0.0266,0.8086},
{0.0146,0.7994},
{0.0241,0.7976},
{0.0131,0.7958},
{0.0233,0.794},
{0.0186,0.7573},
{0.0074,0.7571},
{0.013,0.7465},
{0.0176,0.7478},
{0.0257,0.7378},
{0.0196,0.7338},
{0.0327,0.7245},
{0.0258,0.7206},
{0.0394,0.7124},
{0.0329,0.7082},
{0.0448,0.694},
{0.0526,0.6992},
{0.0574,0.6838},
{0.0669,0.6897},
{0.073,0.6721},
{0.0778,0.6824},
{0.086,0.6624},
{0.0945,0.6723},
{0.102,0.6469},
{0.1201,0.659},
{0.1169,0.6862},
{0.1477,0.6795},
{0.1353,0.6927},
{0.1449,0.7083},
{0.1722,0.696},
{0.1715,0.7236},
{0.201,0.7098},
{0.1884,0.7318},
{0.2217,0.7439},
{0.2414,0.7141},
{0.2381,0.7474},
{0.2591,0.7464},
{0.2775,0.7417},
{0.2694,0.701},
{0.2984,0.7287},
{0.2843,0.687},
{0.3137,0.7135},
{0.3186,0.7202},
{0.302,0.7407},
{0.3227,0.7298},
{0.3067,0.7564},
{0.3139,0.7703},
{0.3415,0.7543},
{0.3505,0.7849},
{0.3233,0.7934},
{0.3511,0.8115},
{0.3265,0.8122},
{0.3455,0.8479},
{0.3209,0.8457},
{0.3349,0.8845},
{0.3111,0.8754},
{0.2991,0.9028},
{0.3213,0.9193},
{0.2821,0.9256},
{0.3013,0.9477},
{0.2484,0.9506},
{0.2633,0.9771},
{0.2108,0.9664},
{0.2152,0.9938},
{0.1728,0.9695},
{0.1688,0.994},
{0.1347,0.9675},
{0.129,0.9929},
{0.0892,0.9791},
{0.1004,0.9584},
{0.278,0.8916},
{0.2612,0.9151},
{0.2381,0.9321},
{0.2076,0.9397},
{0.175,0.9429},
{0.1407,0.9437},
{0.1115,0.9382},
{0.0896,0.9262},
{0.0969,0.9026},
{0.0928,0.889},
{0.091,0.8771},
{0.0681,0.8773},
{0.0695,0.8651},
{0.0663,0.8605},
{0.0625,0.8559},
{0.0556,0.8491},
{0.0477,0.8397},
{0.0461,0.8344},
{0.0438,0.8218},
{0.042,0.8074},
{0.04,0.8032},
{0.0358,0.7961},
{0.0353,0.7924},
{0.0282,0.754},
{0.025,0.7471},
{0.032,0.7395},
{0.0402,0.7276},
{0.0442,0.7149},
{0.0541,0.7055},
{0.0674,0.6967},
{0.0746,0.6974},
{0.0872,0.6853},
{0.1005,0.6819},
{0.1013,0.6956},
{0.1089,0.7039},
{0.128,0.7017},
{0.1298,0.7188},
{0.147,0.7302},
{0.1687,0.7381},
{0.1865,0.7463},
{0.1954,0.7491},
{0.2194,0.7572},
{0.2374,0.7608},
{0.2582,0.7608},
{0.2796,0.755},
{0.1044,0.9163},
{0.1204,0.902},
{0.1177,0.8849},
{0.1162,0.8732},
{0.0928,0.8654},
{0.1232,0.923},
{0.1455,0.9013},
{0.1446,0.8802},
{0.1419,0.8689},
{0.135,0.8645},
{0.1192,0.8641},
{0.0938,0.8612},
{0.1442,0.9237},
{0.1757,0.9223},
{0.1785,0.9019},
{0.179,0.8788},
{0.1793,0.868},
{0.1633,0.864},
{0.1407,0.8618},
{0.1317,0.8586},
{0.1156,0.8596},
{0.1042,0.8507},
{0.0848,0.8518},
{0.0695,0.8437},
{0.0601,0.8331},
{0.0583,0.8267},
{0.0626,0.8146},
{0.0577,0.7991},
{0.055,0.7959},
{0.0526,0.7917},
{0.0522,0.7893},
{0.0462,0.7736},
{0.0353,0.7472},
{0.0311,0.7445},
{0.042,0.7351},
{0.0538,0.7201},
{0.0607,0.712},
{0.0666,0.7029},
{0.0728,0.7017},
{0.0817,0.6998},
{0.0861,0.6955},
{0.0934,0.6881},
{0.0933,0.7015},
{0.1007,0.7109},
{0.112,0.712},
{0.1131,0.7232},
{0.1261,0.7323},
{0.1436,0.7456},
{0.1458,0.7475},
{0.1652,0.7466},
{0.1841,0.7561},
{0.1941,0.7613},
{0.1815,0.7717},
{0.1943,0.7717},
{0.1922,0.7821},
{0.1872,0.7922},
{0.1755,0.7848},
{0.1795,0.8004},
{0.1653,0.7956},
{0.1704,0.8052},
{0.1551,0.8014},
{0.16,0.8137},
{0.1435,0.8155},
{0.1524,0.8234},
{0.1406,0.8368},
{0.1481,0.839},
{0.1356,0.8513},
{0.1531,0.8539},
{0.2068,0.9178},
{0.2085,0.9007},
{0.2103,0.8809},
{0.2104,0.8657},
{0.1972,0.8643},
{0.2092,0.8553},
{0.2412,0.8629},
{0.2413,0.8421},
{0.213,0.8415},
{0.2414,0.8184},
{0.2103,0.829},
{0.206,0.8197},
{0.2079,0.8151},
{0.2101,0.8005},
{0.2381,0.8022},
{0.2109,0.7894},
{0.2353,0.7884},
{0.2107,0.7784},
{0.2342,0.7747},
{0.2132,0.7696},
{0.2567,0.7754},
{0.2817,0.7686},
{0.2385,0.914},
{0.2408,0.9018},
{0.2398,0.8804},
{0.2634,0.8861},
{0.2657,0.8638},
{0.2685,0.8416},
{0.27,0.8187},
{0.2645,0.8043},
{0.2602,0.7881},
{0.288,0.867},
{0.2935,0.8438},
{0.297,0.816},
{0.2929,0.8006},
{0.2865,0.7837},
{0.1213,0.8401},
{0.1135,0.846},
{0.1043,0.8399},
{0.0881,0.8391},
{0.0794,0.8254},
{0.0784,0.818},
{0.0797,0.8082},
{0.0736,0.7922},
{0.0716,0.7902},
{0.0712,0.7878},
{0.0707,0.7857},
{0.0603,0.768},
{0.044,0.7407},
{0.0517,0.7343},
{0.0514,0.7308},
{0.0579,0.7277},
{0.0602,0.7183},
{0.0635,0.712},
{0.0676,0.7062},
{0.0683,0.7081},
{0.0729,0.7041},
{0.0814,0.7019},
{0.0901,0.7044},
{0.1606,0.7586},
{0.152,0.7727},
{0.1398,0.7858},
{0.1336,0.792},
{0.1257,0.8024},
{0.1206,0.8103},
{0.1248,0.8356},
{0.1102,0.8268},
{0.1121,0.8183},
{0.0992,0.8226},
{0.098,0.8144},
{0.0943,0.8022},
{0.0837,0.7855},
{0.0819,0.7841},
{0.0806,0.783},
{0.0799,0.7812},
{0.0679,0.7636},
{0.0718,0.7541},
{0.0591,0.7336},
{0.0594,0.7269},
{0.0618,0.7185},
{0.0644,0.713},
{0.0723,0.7208},
{0.0761,0.7154},
{0.0783,0.7144},
{0.0813,0.7156},
{0.089,0.7057},
{0.0961,0.7132},
{0.0995,0.7231},
{0.1032,0.7217},
{0.1058,0.7336},
{0.1167,0.7436},
{0.1322,0.7604},
{0.1339,0.7619},
{0.106,0.8001},
{0.1109,0.7912},
{0.0907,0.7791},
{0.1103,0.7793},
{0.0963,0.7723},
{0.0895,0.7787},
{0.1178,0.7717},
{0.1164,0.769},
{0.1016,0.7516},
{0.0876,0.7555},
{0.0955,0.773},
{0.0938,0.7401},
{0.0832,0.7439},
{0.0736,0.7487},
{0.0704,0.7414},
{0.0608,0.7327},
{0.1996,0.7638},
{0.2107,0.768},
{0.2027,0.7754},
{0.2071,0.7771},
{0.202,0.7854},
{0.2068,0.7872},
{0.2052,0.7974},
{0.1958,0.7962},
{0.2003,0.807},
{0.1881,0.8057},
{0.1967,0.8156},
{0.1789,0.8127},
{0.1915,0.8203},
{0.2021,0.8289},
{0.1987,0.8299},
{0.2019,0.8401},
{0.2049,0.841},
{0.2031,0.8519},
{0.2003,0.851},
{0.1923,0.8576},
{0.1939,0.86},
{0.1814,0.8625},
{0.1808,0.8599},
{0.1702,0.8577},
{0.1678,0.8597},
{0.1628,0.8498},
{0.1601,0.8511},
{0.1561,0.8391},
{0.1597,0.839},
{0.1586,0.829},
{0.1616,0.8294},
{0.1671,0.8189},
{0.1693,0.8208},
{0.1795,0.8174},
{0.1802,0.8294},
{0.1943,0.8307},
{0.1947,0.8457},
{0.181,0.8462},
{0.1669,0.8453},
{0.1666,0.8306},
{0.1705,0.8436},
{0.1704,0.8322},
{0.1807,0.8325},
{0.1905,0.8328},
{0.1905,0.8437},
{0.1811,0.8435},
{0.0796,0.723},
{0.083,0.7191},
{0.0947,0.7137},
{0.0974,0.7232},
{0.0978,0.7327},
{0.096,0.7321},
{0.0921,0.7383},
{0.0822,0.7416},
{0.0703,0.7387},
{0.0744,0.7283},
{0.0801,0.7316},
{0.0852,0.7301},
{0.0855,0.7259},
{0.0858,0.7223},
{1.023,0.8876},
{1.0327,0.9212},
{1.0546,0.9126},
{1.0551,0.9536},
{1.0741,0.939},
{1.0892,0.9791},
{1.1004,0.9584},
{1.1347,0.9675},
{1.129,0.9929},
{1.1688,0.994},
{1.1728,0.9695},
{1.2152,0.9938},
{1.2108,0.9664},
{1.2633,0.9771},
{1.2484,0.9506},
{1.3013,0.9477},
{1.2821,0.9256},
{1.3213,0.9193},
{1.2991,0.9028},
{1.3349,0.8845},
{1.3111,0.8754},
{1.3209,0.8457},
{1.3455,0.8479},
{1.3265,0.8122},
{1.3511,0.8115},
{1.3233,0.7934},
{1.3505,0.7849},
{1.3139,0.7703},
{1.3415,0.7543},
{1.3227,0.7298},
{1.3067,0.7564},
{1.302,0.7407},
{1.3186,0.7202},
{1.2984,0.7287},
{1.3137,0.7135},
{1.2843,0.687},
{1.2694,0.701},
{1.2775,0.7417},
{1.2414,0.7141},
{1.2591,0.7464},
{1.2381,0.7474},
{1.2217,0.7439},
{1.201,0.7098},
{1.1884,0.7318},
{1.1715,0.7236},
{1.1722,0.696},
{1.1449,0.7083},
{1.1477,0.6795},
{1.1353,0.6927},
{1.1169,0.6862},
{1.1201,0.659},
{1.0945,0.6723},
{1.102,0.6469},
{1.086,0.6624},
{1.0778,0.6824},
{1.073,0.6721},
{1.0669,0.6897},
{1.0574,0.6838},
{1.0526,0.6992},
{1.0448,0.694},
{1.0394,0.7124},
{1.0329,0.7082},
{1.0258,0.7206},
{1.0327,0.7245},
{1.0196,0.7338},
{1.0257,0.7378},
{1.013,0.7465},
{1.0176,0.7478},
{1.0186,0.7573},
{1.0074,0.7571},
{1.0131,0.7958},
{1.0233,0.794},
{1.0241,0.7976},
{1.0146,0.7994},
{1.0266,0.8086},
{1.0167,0.8105},
{1.0271,0.8132},
{1.0157,0.8153},
{1.0302,0.8282},
{1.0169,0.8321},
{1.0319,0.8454},
{1.0186,0.8497},
{1.0225,0.8582},
{1.0374,0.8487},
{1.0399,0.8551},
{1.0415,0.8596},
{1.0225,0.8623},
{1.0448,0.8654},
{1.0221,0.8669},
{1.021,0.8766},
{1.0466,0.875},
{1.0471,0.8862},
{1.0694,0.8885},
{1.0759,0.9076},
{1.0896,0.9262},
{1.1115,0.9382},
{1.1407,0.9437},
{1.175,0.9429},
{1.2076,0.9397},
{1.2381,0.9321},
{1.2612,0.9151},
{1.278,0.8916},
{1.288,0.867},
{1.2935,0.8438},
{1.297,0.816},
{1.2929,0.8006},
{1.2865,0.7837},
{1.2817,0.7686},
{1.2796,0.755},
{1.0969,0.9026},
{1.1044,0.9163},
{1.1232,0.923},
{1.1442,0.9237},
{1.1757,0.9223},
{1.2068,0.9178},
{1.2385,0.914},
{1.2408,0.9018},
{1.2634,0.8861},
{1.2657,0.8638},
{1.2685,0.8416},
{1.27,0.8187},
{1.2645,0.8043},
{1.2602,0.7881},
{1.2567,0.7754},
{1.2582,0.7608},
{1.1455,0.9013},
{1.1785,0.9019},
{1.2085,0.9007},
{1.2398,0.8804},
{1.2412,0.8629},
{1.2413,0.8421},
{1.2414,0.8184},
{1.2381,0.8022},
{1.2353,0.7884},
{1.2342,0.7747},
{1.2374,0.7608},
{1.1204,0.902},
{1.1446,0.8802},
{1.179,0.8788},
{1.2103,0.8809},
{1.2104,0.8657},
{1.2092,0.8553},
{1.213,0.8415},
{1.2103,0.829},
{1.206,0.8197},
{1.2079,0.8151},
{1.2101,0.8005},
{1.2109,0.7894},
{1.2107,0.7784},
{1.2132,0.7696},
{1.2194,0.7572},
{1.1177,0.8849},
{1.1419,0.8689},
{1.1793,0.868},
{1.1972,0.8643},
{1.0928,0.889},
{1.1162,0.8732},
{1.135,0.8645},
{1.1407,0.8618},
{1.1633,0.864},
{1.091,0.8771},
{1.0928,0.8654},
{1.1192,0.8641},
{1.1317,0.8586},
{1.1356,0.8513},
{1.1531,0.8539},
{1.0681,0.8773},
{1.0695,0.8651},
{1.0663,0.8605},
{1.0938,0.8612},
{1.1156,0.8596},
{1.1135,0.846},
{1.1213,0.8401},
{1.1248,0.8356},
{1.1406,0.8368},
{1.1481,0.839},
{1.1524,0.8234},
{1.1435,0.8155},
{1.16,0.8137},
{1.1551,0.8014},
{1.1704,0.8052},
{1.1653,0.7956},
{1.1795,0.8004},
{1.1755,0.7848},
{1.1872,0.7922},
{1.1815,0.7717},
{1.1922,0.7821},
{1.1943,0.7717},
{1.1941,0.7613},
{1.1841,0.7561},
{1.1954,0.7491},
{1.1865,0.7463},
{1.1996,0.7638},
{1.2107,0.768},
{1.2027,0.7754},
{1.2071,0.7771},
{1.202,0.7854},
{1.2068,0.7872},
{1.2052,0.7974},
{1.1958,0.7962},
{1.2003,0.807},
{1.1881,0.8057},
{1.1967,0.8156},
{1.1789,0.8127},
{1.1915,0.8203},
{1.1795,0.8174},
{1.1693,0.8208},
{1.1671,0.8189},
{1.1616,0.8294},
{1.1586,0.829},
{1.1597,0.839},
{1.1561,0.8391},
{1.1628,0.8498},
{1.1601,0.8511},
{1.1678,0.8597},
{1.1702,0.8577},
{1.1814,0.8625},
{1.1808,0.8599},
{1.1923,0.8576},
{1.1939,0.86},
{1.2031,0.8519},
{1.2003,0.851},
{1.2019,0.8401},
{1.2049,0.841},
{1.2021,0.8289},
{1.1987,0.8299},
{1.1606,0.7586},
{1.1652,0.7466},
{1.1687,0.7381},
{1.147,0.7302},
{1.1298,0.7188},
{1.128,0.7017},
{1.1089,0.7039},
{1.1013,0.6956},
{1.1005,0.6819},
{1.0872,0.6853},
{1.0746,0.6974},
{1.0674,0.6967},
{1.0541,0.7055},
{1.0442,0.7149},
{1.0402,0.7276},
{1.032,0.7395},
{1.025,0.7471},
{1.0282,0.754},
{1.0353,0.7924},
{1.0358,0.7961},
{1.04,0.8032},
{1.042,0.8074},
{1.0438,0.8218},
{1.0461,0.8344},
{1.0477,0.8397},
{1.0556,0.8491},
{1.0625,0.8559},
{1.152,0.7727},
{1.1458,0.7475},
{1.1398,0.7858},
{1.1339,0.7619},
{1.1322,0.7604},
{1.1436,0.7456},
{1.1261,0.7323},
{1.1131,0.7232},
{1.112,0.712},
{1.1007,0.7109},
{1.0933,0.7015},
{1.0934,0.6881},
{1.0861,0.6955},
{1.0817,0.6998},
{1.0728,0.7017},
{1.0666,0.7029},
{1.0607,0.712},
{1.0538,0.7201},
{1.042,0.7351},
{1.0311,0.7445},
{1.0353,0.7472},
{1.0462,0.7736},
{1.0522,0.7893},
{1.0526,0.7917},
{1.055,0.7959},
{1.0577,0.7991},
{1.0626,0.8146},
{1.0583,0.8267},
{1.0601,0.8331},
{1.0695,0.8437},
{1.0848,0.8518},
{1.1042,0.8507},
{1.1043,0.8399},
{1.1102,0.8268},
{1.1121,0.8183},
{1.1206,0.8103},
{1.1257,0.8024},
{1.1336,0.792},
{1.106,0.8001},
{1.1109,0.7912},
{1.1103,0.7793},
{1.1178,0.7717},
{1.1164,0.769},
{1.1016,0.7516},
{1.1167,0.7436},
{1.1058,0.7336},
{1.1032,0.7217},
{1.0995,0.7231},
{1.0961,0.7132},
{1.0901,0.7044},
{1.0963,0.7723},
{1.0876,0.7555},
{1.0938,0.7401},
{1.0907,0.7791},
{1.0895,0.7787},
{1.0955,0.773},
{1.0799,0.7812},
{1.0718,0.7541},
{1.0736,0.7487},
{1.0832,0.7439},
{1.0822,0.7416},
{1.0921,0.7383},
{1.096,0.7321},
{1.0978,0.7327},
{1.0974,0.7232},
{1.0947,0.7137},
{1.089,0.7057},
{1.0814,0.7019},
{1.0729,0.7041},
{1.0683,0.7081},
{1.0676,0.7062},
{1.0635,0.712},
{1.0602,0.7183},
{1.0579,0.7277},
{1.0514,0.7308},
{1.0517,0.7343},
{1.044,0.7407},
{1.0603,0.768},
{1.0707,0.7857},
{1.0712,0.7878},
{1.0716,0.7902},
{1.0736,0.7922},
{1.0797,0.8082},
{1.0784,0.818},
{1.0794,0.8254},
{1.0881,0.8391},
{1.0992,0.8226},
{1.098,0.8144},
{1.0943,0.8022},
{1.0837,0.7855},
{1.0819,0.7841},
{1.0806,0.783},
{1.0679,0.7636},
{1.0591,0.7336},
{1.0704,0.7414},
{1.0703,0.7387},
{1.0744,0.7283},
{1.0801,0.7316},
{1.0852,0.7301},
{1.0855,0.7259},
{1.0618,0.7185},
{1.0594,0.7269},
{1.0644,0.713},
{1.0723,0.7208},
{1.0608,0.7327},
{1.0796,0.723},
{1.0858,0.7223},
{1.083,0.7191},
{1.0813,0.7156},
{1.0783,0.7144},
{1.0761,0.7154},
{1.1802,0.8294},
{1.1666,0.8306},
{1.1669,0.8453},
{1.181,0.8462},
{1.1947,0.8457},
{1.1943,0.8307},
{1.1705,0.8436},
{1.1811,0.8435},
{1.1905,0.8437},
{1.1905,0.8328},
{1.1807,0.8325},
{1.1704,0.8322},
{0.8782,0.8651},
{0.8825,0.8651},
{0.8767,0.8708},
{0.8725,0.8684},
{0.8703,0.8708},
{0.8727,0.875},
{0.8805,0.8733},
{0.8804,0.857},
{0.8767,0.8594},
{0.8735,0.8652},
{0.8667,0.865},
{0.8673,0.8717},
{0.8673,0.8765},
{0.8749,0.879},
{0.8673,0.881},
{0.8618,0.875},
{0.8597,0.879},
{0.8578,0.8709},
{0.854,0.8733},
{0.8563,0.8652},
{0.8519,0.8652},
{0.8578,0.8595},
{0.854,0.8571},
{0.8618,0.8553},
{0.8596,0.8514},
{0.8673,0.8538},
{0.8673,0.8494},
{0.8727,0.8553},
{0.8749,0.8514},
{0.8725,0.8619},
{0.8703,0.8595},
{0.8673,0.8587},
{0.8642,0.8595},
{0.8619,0.862},
{0.8609,0.8652},
{0.862,0.8684},
{0.8642,0.8708}
};


// normal array: 38kb.
const tgx::fVec3 stormtrooper_norm_array[3275] PROGMEM = {
{0.3260028786181274,-0.4997044124094424,-0.8025070861688565},
{-0.15729931968191357,-0.7609967086963524,-0.6293972778626599},
{-0.5760015984066533,-0.5542015379114016,-0.600901667504441},
{-0.486106956240316,0.11640166571975476,-0.8661123941570412},
{-0.7611924946790035,0.24419759222361095,-0.6007940761996129},
{-0.7624025464287576,-0.4416014749513895,-0.47300157982791496},
{-0.8485354228506058,0.29011211098286477,-0.4425184733192611},
{-0.8107619518343797,-0.4630782682467948,-0.35808319554994},
{-0.9151593083460114,0.3194857943799723,-0.2457890712319161},
{-0.8959071404083637,-0.41500330758954224,-0.1585012632601023},
{-0.9096859045261133,0.3428946868879897,0.23429636960587927},
{-0.922223203427701,-0.3078077445402802,0.23400588766220132},
{-0.8235751613476949,-0.4159874540075778,0.38558837083010095},
{-0.8397888560758194,0.32949562762203205,0.4314942741089737},
{-0.7479145769971599,-0.41940817434497774,0.5145100278981665},
{-0.7508146485366909,0.27550537516230467,0.6003117121957585},
{-0.5509906167096955,-0.5408907887083019,0.6354891777114545},
{-0.4868219537310164,0.15610703980569363,0.859438757264658},
{0.3551865422368672,-0.4442831664297299,0.822468837246124},
{-0.13450141966997697,-0.7200075997203227,0.6808071859577718},
{0.35638026242573323,-0.22658745080154644,-0.9064497976681458},
{-0.4373049109617253,0.2151024156136911,-0.8732098062011857},
{-0.7375947151527988,0.30109784264168615,-0.6043956695205418},
{-0.8335766560126181,0.31529117039440796,-0.4535872974655993},
{-0.9034029225131814,0.3399010995818357,-0.26140084563310345},
{-0.9109148890255426,0.3597058794406496,0.20210330340549146},
{-0.8352972017590612,0.34939882951588164,0.42449857793214585},
{-0.7262219903348061,0.34741051974980947,0.5932179629118796},
{-0.4302113620321089,0.28450751394266616,0.8567226263433466},
{0.33018080384608034,-0.17818964035545584,0.9269461089197956},
{0.3813832023467708,-0.1297942833366829,-0.9152596882747753},
{-0.3034934597864116,0.3658921151098782,-0.8797810409228499},
{-0.6382799136471713,0.43108643392338325,-0.6377799293814286},
{-0.7479115141863921,0.45660702951932963,-0.48180741748228867},
{-0.8153656575217425,0.5191781326775677,-0.2561892095377366},
{-0.8142980904732169,0.5363987421464246,0.22179947988082954},
{-0.7462062196547614,0.4892040775329795,0.4515037632995508},
{-0.6372945384092086,0.47719591044857107,0.6050948143596613},
{-0.30320096266458474,0.4250013493814264,0.8529027079703967},
{0.39758398166406167,-0.0800967729660245,0.9140631731366166},
{0.5399091488380413,0.0039000660871797758,-0.8417142629690301},
{-0.16910212985473838,0.5220065747142131,-0.8360105296189313},
{-0.4264018335318263,0.6090026187168908,-0.6688028758585493},
{-0.5434934400737672,0.672991877037066,-0.501693944590633},
{-0.6128077888364944,0.745709478027699,-0.26150332372836704},
{-0.6138140779873198,0.7620174770712572,0.20630473165328134},
{-0.5548046908934924,0.6999059177295517,0.449803803107233},
{-0.43121274468100634,0.6428189987962682,0.6331187121000582},
{-0.16340390785118492,0.5731137061781768,0.8030192044339137},
{0.536691117835499,0.06349894910108848,0.8413860751756828},
{0.6450135163998557,0.1722036085644266,-0.7445156014878955},
{-0.10639748000552873,0.732882641880188,-0.6719840842454446},
{-0.2991963124281739,0.7984901586694413,-0.5223935615390308},
{-0.3505997598392468,0.8944993872681296,-0.27739980998119523},
{-0.3544038825157996,0.9148100217986835,0.19370212201837017},
{-0.31369642074425885,0.8356904648261942,0.45079485646003153},
{-0.11809916267990486,0.7678945556469005,0.6295955361834725},
{0.6501312037959572,0.2234107228549713,0.726234856478425},
{0.7062102048111898,0.39210566596781016,-0.589508518459638},
{-0.047102804820022,0.8453503378845986,-0.5321316867247071},
{-0.08909820825304786,0.9578807372120599,-0.2729945101356012},
{-0.0890970037181466,0.9762671686871663,0.1973933617728635},
{-0.03840147445291797,0.8812338356226905,0.47111808892629314},
{0.7058097084793107,0.4341059711687004,0.5598077002078748},
{0.7088037141411933,0.557802922894974,-0.4318022626497845},
{0.6784035684121548,0.7024036946531508,-0.21540113301293948},
{0.6892943167917871,0.7089941543672958,0.14899877151019333},
{0.7203842921917613,0.5740874821589258,0.3891915137715623},
{0.2572054296639309,-0.8005168990901116,0.5413114272048437},
{0.7572476192075993,-0.5308632788027393,0.380473681643327},
{0.04780034846581048,-0.7773056665789642,0.6273045730670066},
{0.6175070334451667,-0.2584029432262851,0.7429084617755697},
{0.8757495644491897,-0.32561842889648984,0.3564201721704821},
{0.5911197821545202,-0.34951169660464354,0.7269243269296578},
{0.8402540930984208,-0.42392729119783457,0.3380217608513048},
{0.7844364222286457,-0.49572301695402815,0.37271730566626243},
{0.40989441932547105,-0.5788921184374608,0.7048904029824946},
{0.7366368032940619,-0.5166258112703127,0.43642180417801874},
{0.15990454055389444,-0.7964226147412229,0.5832165606693637},
{0.7357837503953067,-0.5801871867074708,0.34929228596504575},
{0.3108872942959179,-0.9501611677065975,0.023299047787375},
{0.7846388013481137,-0.5513272638073096,0.2835140201149506},
{0.8305854773398919,-0.55689026285888,-0.0009999825154585744},
{0.7779775751195911,-0.5718835156952367,-0.26019250005927713},
{0.7373892452562862,-0.6003912433575729,-0.3094954860412538},
{0.19369532521973806,-0.8192802269103324,-0.5396869748120424},
{0.7361146893151894,-0.5402107800136738,-0.4078081378925883},
{0.4069188936828607,-0.6217288675414955,-0.6692310731201042},
{0.7874524736439301,-0.5069337806579988,-0.3506233645663728},
{0.5837828691430538,-0.4044881304699645,-0.7039793420293077},
{0.8301385276231212,-0.45942132223835913,-0.31591466193969886},
{0.8767260084628173,-0.34831033277928514,-0.3317098403183717},
{0.614414276081559,-0.2916067755621462,-0.7331170341721858},
{0.7800038376283218,-0.505402486586351,-0.36900181549339833},
{0.06749725629229644,-0.7980675592130635,-0.5987756602641052},
{0.26329634942142266,-0.8321884617869654,-0.48799323402071504},
{0.25870665013991384,-0.903723230504214,0.3411087683135857},
{0.902278007241607,-0.4310894923216854,0.00749981719418381},
{0.7490168343425299,-0.66221488344676,0.021100474238487824},
{0.2452062871698056,-0.9178235332970945,-0.3122080051158781},
{0.31038917381442277,-0.9335674377356478,-0.17919374983100694},
{0.3000085803680996,-0.9518272226478572,0.06340181331779171},
{0.3612006555797848,-0.9103016521989981,0.20220036699399913},
{0.5760015984066533,-0.5542015379114016,-0.600901667504441},
{0.15729931968191357,-0.7609967086963524,-0.6293972778626599},
{-0.3260028786181274,-0.4997044124094424,-0.8025070861688565},
{0.486106956240316,0.11640166571975476,-0.8661123941570412},
{-0.35638026242573323,-0.22658745080154644,-0.9064497976681458},
{0.4373049109617253,0.2151024156136911,-0.8732098062011857},
{-0.3813832023467708,-0.1297942833366829,-0.9152596882747753},
{0.3034934597864116,0.3658921151098782,-0.8797810409228499},
{-0.5399091488380413,0.0039000660871797758,-0.8417142629690301},
{0.16910212985473838,0.5220065747142131,-0.8360105296189313},
{-0.6450135163998557,0.1722036085644266,-0.7445156014878955},
{0.10639748000552873,0.732882641880188,-0.6719840842454446},
{-0.7062102048111898,0.39210566596781016,-0.589508518459638},
{0.047102804820022,0.8453503378845986,-0.5321316867247071},
{-0.7088037141411933,0.557802922894974,-0.4318022626497845},
{-0.6784035684121548,0.7024036946531508,-0.21540113301293948},
{0.08909820825304786,0.9578807372120599,-0.2729945101356012},
{-0.6892943167917871,0.7089941543672958,0.14899877151019333},
{0.0890970037181466,0.9762671686871663,0.1973933617728635},
{0.03840147445291797,0.8812338356226905,0.47111808892629314},
{-0.7203842921917613,0.5740874821589258,0.3891915137715623},
{-0.7058097084793107,0.4341059711687004,0.5598077002078748},
{0.11809916267990486,0.7678945556469005,0.6295955361834725},
{-0.6501312037959572,0.2234107228549713,0.726234856478425},
{0.16340390785118492,0.5731137061781768,0.8030192044339137},
{-0.536691117835499,0.06349894910108848,0.8413860751756828},
{0.30320096266458474,0.4250013493814264,0.8529027079703967},
{-0.39758398166406167,-0.0800967729660245,0.9140631731366166},
{0.4302113620321089,0.28450751394266616,0.8567226263433466},
{-0.33018080384608034,-0.17818964035545584,0.9269461089197956},
{0.4868219537310164,0.15610703980569363,0.859438757264658},
{-0.3551865422368672,-0.4442831664297299,0.822468837246124},
{0.5509906167096955,-0.5408907887083019,0.6354891777114545},
{0.13450141966997697,-0.7200075997203227,0.6808071859577718},
{0.7611924946790035,0.24419759222361095,-0.6007940761996129},
{0.7375947151527988,0.30109784264168615,-0.6043956695205418},
{0.6382799136471713,0.43108643392338325,-0.6377799293814286},
{0.4264018335318263,0.6090026187168908,-0.6688028758585493},
{0.2991963124281739,0.7984901586694413,-0.5223935615390308},
{0.3505997598392468,0.8944993872681296,-0.27739980998119523},
{0.3544038825157996,0.9148100217986835,0.19370212201837017},
{0.31369642074425885,0.8356904648261942,0.45079485646003153},
{0.43121274468100634,0.6428189987962682,0.6331187121000582},
{0.6372945384092086,0.47719591044857107,0.6050948143596613},
{0.7262219903348061,0.34741051974980947,0.5932179629118796},
{0.7508146485366909,0.27550537516230467,0.6003117121957585},
{0.7479145769971599,-0.41940817434497774,0.5145100278981665},
{0.8397888560758194,0.32949562762203205,0.4314942741089737},
{0.8235751613476949,-0.4159874540075778,0.38558837083010095},
{0.9096859045261133,0.3428946868879897,0.23429636960587927},
{0.922223203427701,-0.3078077445402802,0.23400588766220132},
{0.8959071404083637,-0.41500330758954224,-0.1585012632601023},
{0.9151593083460114,0.3194857943799723,-0.2457890712319161},
{0.8107619518343797,-0.4630782682467948,-0.35808319554994},
{0.8485354228506058,0.29011211098286477,-0.4425184733192611},
{0.7624025464287576,-0.4416014749513895,-0.47300157982791496},
{0.9109148890255426,0.3597058794406496,0.20210330340549146},
{0.9034029225131814,0.3399010995818357,-0.26140084563310345},
{0.8335766560126181,0.31529117039440796,-0.4535872974655993},
{0.7479115141863921,0.45660702951932963,-0.48180741748228867},
{0.5434934400737672,0.672991877037066,-0.501693944590633},
{0.6128077888364944,0.745709478027699,-0.26150332372836704},
{0.6138140779873198,0.7620174770712572,0.20630473165328134},
{0.5548046908934924,0.6999059177295517,0.449803803107233},
{0.7462062196547614,0.4892040775329795,0.4515037632995508},
{0.8352972017590612,0.34939882951588164,0.42449857793214585},
{0.8142980904732169,0.5363987421464246,0.22179947988082954},
{0.8153656575217425,0.5191781326775677,-0.2561892095377366},
{-0.2572054296639309,-0.8005168990901116,0.5413114272048437},
{-0.04780034846581048,-0.7773056665789642,0.6273045730670066},
{-0.7572476192075993,-0.5308632788027393,0.380473681643327},
{-0.6175070334451667,-0.2584029432262851,0.7429084617755697},
{-0.25870665013991384,-0.903723230504214,0.3411087683135857},
{-0.902278007241607,-0.4310894923216854,0.00749981719418381},
{-0.3612006555797848,-0.9103016521989981,0.20220036699399913},
{-0.3000085803680996,-0.9518272226478572,0.06340181331779171},
{-0.31038917381442277,-0.9335674377356478,-0.17919374983100694},
{-0.2452062871698056,-0.9178235332970945,-0.3122080051158781},
{-0.614414276081559,-0.2916067755621462,-0.7331170341721858},
{-0.06749725629229644,-0.7980675592130635,-0.5987756602641052},
{-0.7800038376283218,-0.505402486586351,-0.36900181549339833},
{-0.26329634942142266,-0.8321884617869654,-0.48799323402071504},
{-0.8757495644491897,-0.32561842889648984,0.3564201721704821},
{-0.5911197821545202,-0.34951169660464354,0.7269243269296578},
{-0.7490168343425299,-0.66221488344676,0.021100474238487824},
{-0.5837828691430538,-0.4044881304699645,-0.7039793420293077},
{-0.8767260084628173,-0.34831033277928514,-0.3317098403183717},
{-0.8301385276231212,-0.45942132223835913,-0.31591466193969886},
{-0.7874524736439301,-0.5069337806579988,-0.3506233645663728},
{-0.4069188936828607,-0.6217288675414955,-0.6692310731201042},
{-0.7361146893151894,-0.5402107800136738,-0.4078081378925883},
{-0.19369532521973806,-0.8192802269103324,-0.5396869748120424},
{-0.7373892452562862,-0.6003912433575729,-0.3094954860412538},
{-0.3108872942959179,-0.9501611677065975,0.023299047787375},
{-0.7779775751195911,-0.5718835156952367,-0.26019250005927713},
{-0.8305854773398919,-0.55689026285888,-0.0009999825154585744},
{-0.7846388013481137,-0.5513272638073096,0.2835140201149506},
{-0.7357837503953067,-0.5801871867074708,0.34929228596504575},
{-0.15990454055389444,-0.7964226147412229,0.5832165606693637},
{-0.7366368032940619,-0.5166258112703127,0.43642180417801874},
{-0.40989441932547105,-0.5788921184374608,0.7048904029824946},
{-0.7844364222286457,-0.49572301695402815,0.37271730566626243},
{-0.8402540930984208,-0.42392729119783457,0.3380217608513048},
{-0.24330359727027864,0.5477080979240921,0.8005118356549858},
{0.21520007639604072,0.5365001904576014,0.8160002896801543},
{0.32310458327102076,0.8989127511678136,0.29590419743081103},
{-0.2981835705378826,0.912949697857434,0.2785846504086321},
{-0.6153432170717557,0.2913204601544002,0.7324514418712074},
{-0.8020885983916102,0.5640919814894743,0.19609721249793635},
{-0.7592844576062276,-0.12779738401432358,0.6380869384940522},
{-0.9966609615546889,-0.007599702325489751,0.08129681566609431},
{-0.6249248381312972,-0.5495218411796252,0.5545220399164734},
{-0.8140617969762809,-0.5803727637452812,-0.021698981690683326},
{-0.266712843866252,-0.8166393262136535,0.5118246475093655},
{-0.3298020612693244,-0.9411058819301432,-0.07450046562936527},
{0.182806972390893,-0.8298316503827299,0.5272201085584179},
{0.27718776797369304,-0.9590576777185028,-0.05809743621670839},
{0.5545123241733586,-0.5831129598295499,0.5937131954224041},
{0.7807532420884551,-0.6244626020546109,0.021698700503739083},
{0.7071822923770955,-0.1679957934379978,0.68678280317391},
{0.989012827579561,-0.059100766541913104,0.13550175746919163},
{0.5793144424890792,0.26090650448023606,0.7722192516659191},
{0.8164140995932511,0.5249090652578362,0.2407041569966873},
{-0.04450114057884974,-0.22550577978720487,0.9732249440749791},
{0.677227871886613,-0.6484266865494387,-0.3477143104769276},
{0.6771682754094281,-0.7354655442463592,0.023098917841048124},
{0.034999344643407274,-0.9988812961228434,0.031799404561724316},
{0.0352006234085609,-0.8805155940692576,-0.47270837173939595},
{-0.0,-0.8806893525300914,-0.4736942730708576},
{0.0,-0.9993977763424214,0.03469992279275768},
{-0.034999344643407274,-0.9988812961228434,0.031799404561724316},
{-0.0352006234085609,-0.8805155940692576,-0.47270837173939595},
{-0.677227871886613,-0.6484266865494387,-0.3477143104769276},
{-0.6771682754094281,-0.7354655442463592,0.023098917841048124},
{0.6771877125404329,-0.3876929653749642,-0.6253886524258515},
{0.0346020801665757,-0.526531653401795,-0.8494510662858208},
{0.0,-0.5243875171037313,-0.8514797307662609},
{-0.0346020801665757,-0.526531653401795,-0.8494510662858208},
{-0.6771877125404329,-0.3876929653749642,-0.6253886524258515},
{0.6771682754094281,-0.023098917841048124,-0.7354655442463592},
{0.03460016227514161,-0.031500147736039326,-0.9989046848739581},
{0.0,-0.03150011812566446,-0.9995037481460833},
{-0.03460016227514161,-0.031500147736039326,-0.9989046848739581},
{-0.6771682754094281,-0.023098917841048124,-0.7354655442463592},
{0.677227871886613,0.3477143104769276,-0.6484266865494387},
{0.03470166797575785,0.47232270273632365,-0.8807423338976926},
{0.0,0.47251277219285087,-0.8813238225048878},
{-0.03470166797575785,0.47232270273632365,-0.8807423338976926},
{-0.677227871886613,0.3477143104769276,-0.6484266865494387},
{0.6772300629097536,0.625327758915341,-0.3877172111490128},
{0.034698311274284424,0.8493586627198038,-0.5266743673822941},
{0.0,0.8499197098666104,-0.5269122192360478},
{-0.034698311274284424,0.8493586627198038,-0.5266743673822941},
{-0.6772300629097536,0.625327758915341,-0.3877172111490128},
{0.6772180785779146,0.7354196322891294,-0.023100616679193484},
{0.034600379568245805,0.9989109581133161,-0.031300343366650114},
{-0.0,0.9995068916237767,-0.031400216505239206},
{-0.034600379568245805,0.9989109581133161,-0.031300343366650114},
{-0.6772180785779146,0.7354196322891294,-0.023100616679193484},
{0.6771604109738247,0.6484620887721875,0.3477796676560783},
{0.03459873561231015,0.8807678129284041,0.47228274074260357},
{-0.0,0.881218184124846,0.47270975446642616},
{-0.03459873561231015,0.8807678129284041,0.47228274074260357},
{-0.6771604109738247,0.6484620887721875,0.3477796676560783},
{0.6772038025100267,0.3878021775153401,0.6253035110890721},
{0.034600667626322835,0.5269101668297544,0.8492163857882472},
{-0.0,0.527029240393408,0.8498471508279282},
{-0.034600667626322835,0.5269101668297544,0.8492163857882472},
{-0.6772038025100267,0.3878021775153401,0.6253035110890721},
{0.6771682754094281,0.023098917841048124,0.7354655442463592},
{0.034600379568245805,0.031300343366650114,0.9989109581133161},
{-0.0,0.031400216505239206,0.9995068916237767},
{-0.034600379568245805,0.031300343366650114,0.9989109581133161},
{-0.6771682754094281,0.023098917841048124,0.7354655442463592},
{0.6771062632619029,-0.34780321719463864,0.6485059987082321},
{0.034500267378108275,-0.4724036611425608,0.8807068255043466},
{-0.0,-0.47278740511128947,0.881176525770026},
{-0.034500267378108275,-0.4724036611425608,0.8807068255043466},
{-0.6771062632619029,-0.34780321719463864,0.6485059987082321},
{0.6771073094128579,-0.6254067513023206,0.3878041863687879},
{0.034501489979017815,-0.8493366793965168,0.5267227470130051},
{0.0,-0.8497575641668417,0.5271736736040938},
{-0.034501489979017815,-0.8493366793965168,0.5267227470130051},
{-0.6771073094128579,-0.6254067513023206,0.3878041863687879},
{0.8745402210296691,0.412118953786537,-0.25561175585498386},
{0.8744286773587187,0.48491590307781646,-0.015200498508523015},
{0.7838921885532614,0.620593815813438,-0.019399806681889616},
{0.7841007605781066,0.5275005116757444,-0.3270003171904615},
{0.8745202672420427,0.22920531189465543,-0.42740990533933565},
{0.7841046850394897,0.2932017518857013,-0.5470032683542927},
{0.8744946087573554,-0.015199906292866555,-0.4847970112356385},
{0.7839393116224467,-0.019500977901055885,-0.6205311173130861},
{0.8744904724782033,-0.25549721637299133,-0.41229550806490933},
{0.7840850319596085,-0.3268937596576917,-0.5275899284043992},
{0.8745984738269948,-0.42719925453795127,-0.22929959987254733},
{0.784020165257979,-0.5470140693827992,-0.2934075465391467},
{0.8746674498565192,-0.48448197033895457,0.015299430642282775},
{0.7843735199969397,-0.6199790698598963,0.0195993383375064},
{0.87458608544607,-0.41209344364546696,0.25549593509200874},
{0.7840051352504539,-0.5277034564689598,0.3269021412160375},
{0.8745811573519451,-0.22919506204558177,0.42729079411901},
{0.7841046850394897,-0.2932017518857013,0.5470032683542927},
{0.8747098230464696,0.015300171821894344,0.4844054399036353},
{0.7843735199969397,0.0195993383375064,0.6199790698598963},
{0.8746221238464376,0.2555064631177279,0.4120104219354359},
{0.7839795031238327,0.32699145092027204,0.527686203824549},
{0.8745029252171773,0.427501429994675,0.2291007663433451},
{0.7840847771418262,0.5470893783628276,0.2930943096292173},
{-0.7838921885532614,0.620593815813438,-0.019399806681889616},
{-0.8744286773587187,0.48491590307781646,-0.015200498508523015},
{-0.8745402210296691,0.412118953786537,-0.25561175585498386},
{-0.7841007605781066,0.5275005116757444,-0.3270003171904615},
{-0.8745202672420427,0.22920531189465543,-0.42740990533933565},
{-0.7841046850394897,0.2932017518857013,-0.5470032683542927},
{-0.8744946087573554,-0.015199906292866555,-0.4847970112356385},
{-0.7839393116224467,-0.019500977901055885,-0.6205311173130861},
{-0.8744904724782033,-0.25549721637299133,-0.41229550806490933},
{-0.7840850319596085,-0.3268937596576917,-0.5275899284043992},
{-0.8745984738269948,-0.42719925453795127,-0.22929959987254733},
{-0.784020165257979,-0.5470140693827992,-0.2934075465391467},
{-0.8746674498565192,-0.48448197033895457,0.015299430642282775},
{-0.7843735199969397,-0.6199790698598963,0.0195993383375064},
{-0.87458608544607,-0.41209344364546696,0.25549593509200874},
{-0.7840051352504539,-0.5277034564689598,0.3269021412160375},
{-0.8745811573519451,-0.22919506204558177,0.42729079411901},
{-0.7841046850394897,-0.2932017518857013,0.5470032683542927},
{-0.8747098230464696,0.015300171821894344,0.4844054399036353},
{-0.7843735199969397,0.0195993383375064,0.6199790698598963},
{-0.8746221238464376,0.2555064631177279,0.4120104219354359},
{-0.7839795031238327,0.32699145092027204,0.527686203824549},
{-0.8745029252171773,0.427501429994675,0.2291007663433451},
{-0.7840847771418262,0.5470893783628276,0.2930943096292173},
{1.0,0.0,-0.0},
{-1.0,0.0,-0.0},
{-0.3231845763841293,0.8988571030683596,0.2959858744112075},
{-0.21509869005296633,0.5363967333538406,0.8160950299964008},
{0.24330359727027864,0.5477080979240921,0.8005118356549858},
{0.2982024840370381,0.912907604552019,0.2787023216000084},
{0.6152981448788898,0.291299121734472,0.732497791522488},
{0.8024059538742667,0.5636041819585452,0.19620145582020332},
{0.7591027859123365,-0.1273004671935719,0.6384023429408979},
{0.9966617139756222,-0.007499711904100699,0.08129687704045158},
{0.6254620043373197,-0.5489666512888707,0.5544663171943147},
{0.8144480701436917,-0.5798342228257766,-0.02160127494487198},
{0.26669919190267277,-0.8165975257132455,0.5118984489500494},
{0.3298020612693244,-0.9411058819301432,-0.07450046562936527},
{-0.18290363158765813,-0.8298164761697031,0.5272104678677603},
{-0.2770938402723954,-0.9590786799179156,-0.05819870625713971},
{-0.5546837313647351,-0.5830828984293799,0.5935825904779283},
{-0.7804069729674553,-0.6249055835563337,0.021400191211562718},
{-0.7074138159267389,-0.1673032674647207,0.6867134116438954},
{-0.9889641754216062,-0.05969783748500495,0.13559508815689567},
{-0.5787874462364352,0.26129433258738854,0.7724832450201212},
{-0.8163979590076537,0.52479868800492,0.24099939750225935},
{0.04450114057884974,-0.22550577978720487,0.9732249440749791},
{0.8231156969660132,-0.05890112325513081,-0.5648107710441066},
{0.7075974385019089,-0.43119843906447586,-0.5597979735350036},
{0.9081786762150208,-0.20739513041950597,-0.3635914629726729},
{0.7521120226067728,0.03490055788987684,-0.6581105199807435},
{0.836629914237385,0.07420265316329663,-0.5427194052792599},
{0.8117821085194902,0.189995812538437,-0.5521878299143417},
{0.41780279093196515,0.9058060508046292,-0.07040047027671217},
{0.36220455656198247,0.9310117122010096,-0.045000566110682524},
{-0.9438972768602845,-0.08159976458501877,-0.3199990768039952},
{0.7982789456704582,-0.08049787689649492,-0.5968842573853144},
{0.6503850770856074,0.7442829226242583,-0.15179651706887332},
{-0.5003846359256271,0.7714763121834959,0.3929879334907504},
{-0.4703168446994448,0.37421340269303044,0.7992286248858097},
{0.6614143726904795,0.11130241862783545,0.7417161176663573},
{0.774401978599583,0.4948012642188452,0.394301007440361},
{-0.4914927898536589,0.8396876818720598,0.23099661130456808},
{0.7727151067280063,0.5765112709055205,0.26560519263227444},
{-0.46559091873769426,0.8820827951428696,0.07179859958197261},
{0.7659904826273796,0.6318921487888265,0.11819853139237109},
{-0.43819681432073976,0.8868935523073119,-0.14629893641059843},
{0.7774564247885516,0.6196652687350038,-0.10759396952700727},
{-0.42410489631929216,0.8187094520551863,-0.3871044691468946},
{0.8090066824227954,0.47820394998094035,-0.34180282330298073},
{-0.45548561371408275,0.6915781568488685,-0.560582294287848},
{0.8044691290894955,0.3486866194077155,-0.4808815465247214},
{-0.5205092287104383,0.6150109042399992,-0.5923105017582951},
{0.8131122536939954,0.25350382033135876,-0.5240078968585089},
{-0.4664139249955992,0.06430191976247218,-0.8822263392605437},
{0.6225337733733332,-0.2554138565775892,-0.7397401319907703},
{-0.476883600254976,0.8013724412756087,0.3610875824115576},
{-0.48818255998956106,0.3214885150279473,0.8113710142882626},
{-0.128893729472588,0.6214697662312914,0.7727624060233982},
{-0.5460009363924089,0.7944013623995048,0.266100456362674},
{-0.44451519156626207,0.8872303216143705,0.12340421741119627},
{-0.5294852355100588,0.8453764270069948,0.07059803140134117},
{-0.45940925948693834,0.8678174910377996,-0.18930381545685118},
{-0.5659955484625169,0.8086936396495361,-0.16019874004186435},
{-0.4283906504760789,0.7396838565759933,-0.5189886731958099},
{-0.4971856762869963,0.7582781543210565,-0.4216878513480015},
{-0.4555837587284968,0.08349702338417359,-0.8862684050945274},
{-0.08020054817262015,0.4398030060638198,-0.8945061139701835},
{0.7343937540076833,0.5920949642537434,0.33179717807700065},
{0.4983044822689771,0.43940395245632863,0.7474067229537096},
{0.6411022534783815,-0.009000031635166796,0.7674026974252222},
{0.6801293074032977,0.587025295464984,0.43911892204203495},
{0.8208711797188111,0.5589803745435686,0.1170958888355132},
{0.8560595478618261,0.4970765112044314,0.1416933044410942},
{0.8991520180328023,0.4179776952154263,-0.12969307911349476},
{0.8729204353065886,0.4694109890398816,-0.13290311129825366},
{0.8051484560457131,0.44277165466597335,-0.39457474013367905},
{0.6971091635601829,0.49390649244351503,-0.5197068315912022},
{0.4939843854003623,0.2278927964225558,-0.8390734773065668},
{0.6603891003678468,-0.10819821420321174,-0.743087735438139},
{-0.9487584073431133,0.31598614747093573,0.0031998597212246657},
{-0.05410129168375861,0.52201246319634,0.8512203231278248},
{-0.9625072140186037,0.10760080647106676,0.24900186627598164},
{-0.5528980842114573,0.7085975447137614,-0.43839848095189526},
{-0.12489468584417358,0.32778605300016095,-0.936460154468123},
{0.6150112425082706,0.26900491745483707,0.7412135495075286},
{0.8888858401613483,0.2912953597018796,-0.3535943672865933},
{0.4293893061924922,0.19919503910932565,-0.8808780620050451},
{0.8593128983834079,0.05750086309443263,0.5082076282537505},
{0.9297685743532712,0.25659132735970036,0.26399107725238075},
{0.4192869457041651,0.7842755819598776,0.45728576262941734},
{0.4256044050283882,0.8613089145933993,0.2775028721695906},
{0.7350753386360761,0.6129794348849336,0.2896902810541032},
{0.043597336720047175,0.5410669472297598,-0.8398486952102666},
{-0.0,0.4640144681966811,-0.8858276205358191},
{-0.0,0.7131803022320748,-0.7009806391821151},
{0.1327952287531448,0.73487359646601,-0.6650761042448541},
{-0.0,0.5726163770625794,-0.8198234472858934},
{0.1384000795800686,0.5302003048652629,-0.8365004809879149},
{-0.0,0.8746191543692233,-0.4848106174687851},
{-0.06469767448388526,0.8021711664756223,-0.5935786641983662},
{-0.0064997691972936335,0.7770724066487512,-0.629377651196402},
{-0.2122089851186489,0.916238794371848,-0.3398143880457912},
{0.4913791045478592,0.42148207685576444,-0.7621675895123694},
{0.43571168376545233,0.5212139765401739,-0.7338196776384873},
{0.6979130161991293,0.06730125518011376,-0.7130132978220076},
{0.5188157903988749,0.26880818130149875,-0.8115246991300827},
{0.5770912253946262,0.45019315486512,-0.6813896395492953},
{0.5800051910696902,0.6783060708665014,-0.45110403739920213},
{0.5480932968599689,0.01459982144527558,-0.8362897722386279},
{0.7505317519174115,-0.057502432691873634,-0.6583278511488767},
{0.5663987737479822,-0.0195999575661378,-0.8238982162622925},
{0.4655967128988104,-0.002399983056179435,-0.8849937519661667},
{0.47916548216195287,0.32897630140083994,-0.8137413801823815},
{0.5738906858297528,0.46949238020050343,-0.670989109935118},
{0.7049149901766509,0.6011127827992409,-0.3765080065278892},
{0.6285122843926488,-0.4279083635506992,-0.6495126948496824},
{0.8169190426048273,-0.17640411202777762,-0.5491127999685527},
{0.2646088738073772,-0.7336246025135749,-0.6259209906123862},
{0.9601825392392845,-0.24919546842160975,-0.12629770329714812},
{0.6382872056611925,-0.7697845698229453,0.0045999077957723416},
{0.960134613476735,-0.27580994312767787,-0.0455016403637032},
{0.9633863537289484,-0.16139771381757553,-0.21409696733793634},
{0.9954725900395947,-0.08089777251050045,-0.04989862606024688},
{0.9725078044064457,-0.155101244692483,-0.1737013939592798},
{0.7892276352894829,-0.579820302763358,-0.20230708390656665},
{0.760768443979402,-0.1833923930413017,-0.6225741761587483},
{0.6180216156840194,-0.614921507255831,-0.4898171316537746},
{0.407709827963856,-0.6315152228579226,-0.6595158978223278},
{0.6190662587130782,-0.29318402044043695,-0.728560290903487},
{0.16759548084878756,-0.5635848031406723,-0.8088781888937008},
{0.20900918406532618,-0.6086267436466867,-0.7654336338928261},
{-0.0,-0.510917634626494,-0.8596296706301315},
{-0.0,-0.5817016142242193,-0.8134022571943956},
{0.77697884703883,-0.09189749812466985,-0.6227830449623981},
{0.5306927056788903,-0.3669949556890008,-0.763989499036503},
{0.03769969878061011,-0.41619667460185483,-0.9084927411719969},
{0.0,-0.37230430013950006,-0.9281107197407198},
{-0.012899982069037388,-0.4613993586553372,-0.887098766933571},
{-0.0,-0.47511329860734464,-0.8799246294350717},
{-0.19480094186483088,-0.16000077360561057,-0.9677046788634335},
{-0.4698181329807703,0.015100582818241021,-0.8826340659191739},
{-0.21930641590304722,0.19860581029797164,-0.9552279456023288},
{-0.02420008542645233,0.5119018070165682,-0.8587030312270504},
{-0.0,0.5153777980026828,-0.8569630828255708},
{-0.43300667268423954,0.4873075094665818,-0.758311685673115},
{-0.024199554006329456,0.5260903042450383,-0.8500843330901104},
{0.00030000081900335377,0.5271014389888926,-0.8498023199635002},
{-0.4826181323038523,0.013100492194737808,-0.8757329019031984},
{-0.39582593338556643,-0.48023146339502026,-0.7827512836303255},
{-0.013200558131396941,-0.47061989822995465,-0.8822373017816956},
{-0.001499962403913513,-0.4697882249057122,-0.8827778734498994},
{-0.0,-0.4025073639395856,0.9154167477026003},
{0.0,-0.517565777094447,0.855643422449224},
{0.31540249642063883,-0.7270057542733177,0.6099048274158136},
{-0.008299936837720996,-0.4827963259339394,0.8756933359990695},
{0.004200089210842267,-0.6128130162867004,0.7902167843827523},
{0.44681576170399606,-0.6865242175689197,0.5736202348106807},
{0.06500200046734704,-0.7492230576944062,0.659120284738899},
{0.04859889463071229,-0.49718869157181383,0.8662802966787255},
{-0.12639934272512676,-0.5599970880227134,0.8187957422732102},
{0.29750245440537326,-0.7725063732038684,0.5610046283072754},
{-0.21601210349724792,-0.595533368669496,0.7737433540547256},
{-0.09009937921741577,-0.40109723644956125,0.9115937191409125},
{0.39738577185715346,-0.6056783140761899,0.6893753173586351},
{0.19420346850492154,-0.7470133417774273,0.6358113556922199},
{0.6828758436942863,-0.5646800247974278,0.46348360455747806},
{0.7094904857963777,-0.6290915639386909,0.31759574106966815},
{0.6123369954571546,-0.5348323128703026,0.5822351768008418},
{0.8314811380643221,-0.5355878503274214,0.1475966518079302},
{0.9338631971765845,-0.33798668020739436,0.11689539324332664},
{0.9296670392394253,0.2150923740350655,-0.2990893959734453},
{0.8817906662951956,0.04279954696919298,0.46969502830443793},
{-0.0,-0.5857789445542502,-0.8104708681482072},
{0.26569329132908986,-0.6239842445967334,-0.7348814444777875},
{0.44130345541958393,-0.6776053056703151,-0.5883046064431028},
{0.5597045867978833,-0.6956057005120736,-0.4504036910733726},
{0.662225347160253,-0.6830261433259633,-0.30811179320458165},
{0.871178512646975,-0.09499765691168806,-0.4816881193090541},
{0.9602000864180117,0.002700000243000033,-0.27930002513700336},
{0.6545583975903317,0.675957037535998,-0.3385784806356345},
{0.712668778664695,0.6847700008833775,-0.15229332817543573},
{0.7445870517437542,-0.12409784195729236,-0.6558885941965195},
{0.5579344869964947,0.6894426157651614,-0.4619285526862896},
{0.5704218760984305,-0.11450439132761273,-0.8133311918493226},
{0.4507119643078909,0.6421170452232011,-0.6201164612099471},
{0.2991900176915868,-0.08969700730927586,-0.9499683048362548},
{0.27758710637835615,0.0684968183966765,-0.9582554900662057},
{-0.0,-0.049299212944347956,-0.9987840545398529},
{-0.0,0.05240136978970969,-0.9986261044275591},
{0.0,-0.6823895049301206,0.7309887574793642},
{0.0,-0.03960061777445596,0.9992155878847574},
{0.18070662663350023,-0.6381234004141477,0.74842744533764},
{0.2387917033263994,-0.06969757839970701,0.9685663477468611},
{0.32019221782271756,-0.13009683803477687,0.9383771930194822},
{0.0,-0.12590536305316133,0.9920422569399208},
{-0.0,-0.2898880539594394,0.9570605603469453},
{0.39088959661182743,-0.3600904163211027,0.8470774553335354},
{-0.0,-0.8327112500049818,0.5537074806385954},
{0.34229361628358396,-0.7774855000306354,0.5275901605352582},
{-0.0,-0.9922069454729275,0.1246008722091582},
{-0.2896020706622079,-0.8145058237374596,0.5027035943435494},
{0.0,-0.9633658974508348,0.26819050622411655},
{-0.7995124485057356,-0.5781090012272242,0.16300253796927444},
{-0.25519730385472705,-0.9599898577607288,-0.11529878187480419},
{-0.0,-0.9987290384689463,0.050401465443911976},
{0.203406126684805,-0.6628199644379978,0.7206217054526574},
{0.3440962390486607,-0.09719893762141767,0.9338897926403493},
{0.34991851292865267,-0.15570823796224986,0.9237488722269119},
{0.5335869672974837,-0.555786425082349,0.6374844296329569},
{-0.10550342575185215,-0.3360109104513964,0.9359303901531604},
{-0.7889032068980542,-0.18150073780199877,0.5871023865760522},
{-0.9894551836424125,-0.11749467819907372,0.08469616377414081},
{-0.9797897857447251,0.13049863955877386,-0.15159841959471354},
{0.47031097953797746,-0.6271146401621639,0.6209144954180953},
{0.5154856233064461,0.1607955154756092,0.8416765259690315},
{0.3604961895754141,0.38079597500781615,0.8514909997876982},
{0.37917488997433957,-0.15089000764010507,0.9129395425806225},
{0.24390023658334423,-0.18340017789825883,0.952300923732344},
{-0.10270123909792461,-0.0007000084456528455,0.9947120012726934},
{0.1526040486391163,0.03330088348415841,0.9877262047238217},
{0.35608737870653867,0.3811864890843374,0.8531697599337792},
{0.7241100000281511,0.12310170004621654,0.6786093716601344},
{0.8348156863341207,0.4977093520465882,0.2353044214116179},
{0.8376225072191575,0.43231161636919985,0.3339089722546283},
{0.9014946180931949,0.15599906868833988,0.4036975899325821},
{0.863117180518469,-0.19530388756257328,0.465709270035281},
{0.9788272900852766,0.15420429927579654,0.13460375280494302},
{0.8020984679933891,-0.2528995169623839,-0.5409989666929604},
{0.8030777149026127,-0.23169357059262277,-0.548984765884117},
{0.9233410618900537,0.35611583682340314,-0.14360638631800252},
{0.8145303744040029,0.42661590880386446,-0.39311465951898533},
{0.6381228164892127,0.48221724198573634,-0.6002214613020301},
{0.7953289902700527,-0.03900142162772797,-0.6049220498105807},
{0.530584080063513,0.06579802575985517,-0.8450746439157083},
{0.6367958194491679,-0.1479990283895679,-0.7566950323134192},
{-0.007000041510369236,0.39950236905607284,-0.9167054360793541},
{0.3367848517580442,-0.3493842850482798,-0.8743606721414307},
{0.1112985008192909,-0.5969919585724768,-0.7944892983012274},
{-0.414309079682973,-0.0728015954644471,-0.9072198819415714},
{-0.05010016683383334,-0.7982026580192769,-0.6003019990089851},
{-0.7992518465268266,-0.10149388517762153,-0.5923643111253497},
{0.7233085567908406,-0.012700150243666079,0.690408167576934},
{0.689604165221737,0.15500093620848204,0.7074042727347111},
{0.8858888112949697,0.27689650281925393,0.3721952992030564},
{0.5913920724424031,-0.7078905107913038,0.38619482309309444},
{0.9218374273593416,0.2280092573637773,0.31341272481494653},
{0.9473724602828636,-0.3182907474224567,-0.03429900294247648},
{0.9739818597567914,-0.06699875215986142,-0.21649596780014924},
{0.892000285440137,0.005600001792000859,-0.4520001446400694},
{0.7727281973663922,0.004200153266389086,-0.6347231614707508},
{0.8706370202731697,0.14320608925237524,-0.47062001118832264},
{0.6559775331542277,0.021499263662829105,-0.7544741597025376},
{0.7506433846881634,-0.024901439220270803,-0.6602381595671801},
{0.5086148365111747,-0.056701654011371616,-0.8591250610435512},
{0.21929083273835204,-0.14139408914365242,-0.9653596439836073},
{0.09209591747846525,-0.43448073989569114,-0.895960282960965},
{0.08969956450967145,-0.689096654443864,-0.7190965087949246},
{-0.0,-0.6639106060566483,-0.7478119463912661},
{0.0,-0.8746850517601971,-0.4846917166893421},
{0.7063390545660203,-0.013800763065285403,-0.7077391319784405},
{0.6766064785380481,0.022300213525566766,-0.736007047301217},
{0.46698203788136267,-0.0011999538446630302,-0.8842659873629314},
{0.43889611359212116,0.028299749406828497,-0.8980920474301298},
{0.21809427946207358,0.01019973246452614,-0.9758744031501037},
{0.20160694951132657,0.03230111343857068,-0.9789337444277657},
{-0.0,0.00559991219406519,-0.9999843203687839},
{-0.0,-0.019999999600000012,-0.9997999800040005},
{-0.0,-0.16989352208350206,-0.9854624250340865},
{0.0,-0.4468935714822111,-0.8945871314566703},
{-0.9495972604158555,0.1664995196495787,-0.2655992337473159},
{-0.6765714459046757,-0.24258976171515567,-0.6952706567211366},
{-0.9515770434807358,-0.2812932138830716,-0.12399700860825055},
{-0.9480191644011144,-0.2681054198058426,-0.17140346495606648},
{-0.6506124886265798,-0.18900362795945835,-0.7355141183290034},
{-0.8290145078808331,0.16080281407386968,-0.5356093732460485},
{-0.5784136362622142,0.2777065470090195,-0.7670180826644507},
{-0.37648683448559306,0.4611838726819536,-0.8034719030788154},
{0.11399960784202352,0.6267978438191258,-0.7707973484616819},
{0.5731854126168711,0.5494860157588461,-0.6078845295355825},
{0.840100861103824,0.41750042793815795,-0.34630035495804573},
{0.9607944418202312,0.26179848550014206,-0.09129947183408317},
{0.9324477751856738,0.36111850238046633,0.011600594371679339},
{0.8706711072587006,0.4837839458961288,0.08879705331867763},
{0.6846130043475276,0.6762128447849812,0.2721051686867693},
{0.28850761237378003,0.2163057073013817,0.9327246102635169},
{-0.22030428055375711,0.17710344115329274,0.9592186377992004},
{-0.2013063432628159,0.08270260600017323,0.9760307552136528},
{-0.5701982067294599,-0.003999987420059347,0.8214974163946882},
{-0.8754013087259348,-0.16240024278854445,0.45530068067502644},
{-0.1934037317610068,-0.16160311816224768,-0.9677186723119251},
{-0.20890445075673555,-0.0907019324252557,-0.9737207453414716},
{0.3815886708005434,-0.07989762787464208,-0.9208726596965944},
{0.3507116105000516,0.016900559502283637,-0.9363309977507793},
{0.844707644638776,0.1066009647430964,-0.5245047467894377},
{0.8518547376848113,0.012300790412682765,-0.5236336471610321},
{0.9976262129731235,0.058701542403290244,-0.03600094593728192},
{0.9911953562606338,0.12529941297362532,-0.04279979948340913},
{0.9290411574349318,0.05120226831073037,0.3664162325986642},
{0.9218226356327304,0.12930317507844657,0.36540897272748935},
{0.928342133763883,0.17050773866933325,0.33031499168610423},
{0.7283763063041278,0.03509885825271126,0.6842777408071314},
{0.7004056593005908,0.1332010762690444,0.7012056657646691},
{0.7150788125286726,0.1865944712877224,0.6736800391561554},
{0.2636054870053186,-0.014600303908488816,0.9645200766943468},
{0.30079518430764857,0.12329802601440513,0.9456848597065931},
{-0.2228924541036973,-0.06509779615141631,0.9726670709137119},
{-0.5739024878726774,-0.12960056181965324,0.8086035053037933},
{-0.8728406968534601,-0.23118429271682892,0.4297708002149354},
{0.0,-0.07489933152644918,0.9971911001091471},
{0.0,0.884788037746594,0.46599369980776767},
{0.10689725170698747,0.9149764762571893,0.3890899966247785},
{0.300690609578892,-0.059398145024895856,0.951870273555528},
{0.13409392166029357,0.9352576057335764,0.32758515090165685},
{0.6660964630371718,-0.04349976901683977,0.7445960462054919},
{0.4924826230572128,0.6465771859264848,0.5825794440469689},
{0.8931167416302342,0.028700537996627168,0.44890841486710575},
{0.9707677322168629,0.23899205603608384,0.022199262108791053},
{0.7170048433840757,0.3450023304986138,-0.6057040915449576},
{0.5177041364725757,0.64880518397413,-0.5577044560764062},
{-0.4241949584728777,0.8926893904496415,-0.1521981911352475},
{-0.3105040101851875,0.8666111923558244,-0.3906050446967286},
{-0.15279825810978628,0.8813899522118169,-0.44699490428713656},
{0.20349139351351317,0.48647942478783374,-0.8496640642183398},
{-0.0,0.9167804727838924,-0.39939149305179605},
{0.0,0.44529259707211,-0.8953851143462099},
{0.26430333685069174,0.3151039782128376,-0.9115115079054315},
{0.0,0.29321433266687974,-0.9560467327064699},
{0.0,-0.8378651371569492,-0.5458772865186521},
{0.18338888146916457,-0.8420489481198663,-0.5072692451979672},
{0.36238432721676445,-0.8556629933757874,-0.3694840201616845},
{0.5136939872470687,-0.819390409091392,-0.25439702230028083},
{0.5493885563555555,-0.829882713723108,-0.0972979733043239},
{0.4549066280378561,-0.8678126441223379,-0.19990291260665516},
{-0.05950090174299893,-0.9920150341017636,0.1112016852743106},
{-0.0,-0.9970385811543611,0.07690297581822504},
{0.0,0.9743827681931155,0.22489602274900622},
{-0.08669749144437708,0.9752717809192728,0.2032941177698023},
{-0.20439337367423646,0.9447693710734765,0.2561916943998991},
{-0.15209982888778875,0.943998938001792,0.29279967060055584},
{-0.6813976934727114,0.7315975235465743,0.021499927222869523},
{-0.34870967857144497,-0.6964193293867343,-0.6272174086607694},
{-0.605705602802739,-0.7370068173445907,-0.29990277411349087},
{-0.7674520465253625,-0.5140348604561328,-0.3831259825695418},
{-0.5447028488033488,-0.33410174735670806,-0.7692040229475601},
{-0.6180063654983471,-0.23120238139679264,-0.7514077395395761},
{-0.8950456455283706,-0.254284557767696,-0.36637775055479277},
{-0.8821871686809466,-0.24849638564635596,-0.39999418212693116},
{-0.5635048405273704,-0.2951025349416628,-0.7716066281294036},
{-0.17489885791418674,-0.4963967585397501,-0.8502944475953857},
{0.34101773679374797,-0.07130370860232912,-0.9373487527764808},
{0.33140005633801434,0.3353000570010145,-0.8819001499230382},
{0.3941861150386423,0.5659800637033778,-0.7240744949251164},
{0.400093826599883,0.8850863432230853,-0.23779633083092272},
{0.34879423796678277,0.8621857568089453,0.3673939307023968},
{0.5434071376996308,0.783610292788794,0.30110395502642406},
{0.6633029550212469,0.5508024538303977,0.5066022569180819},
{0.333308682804282,0.6499169305565644,0.6830177928452584},
{0.6683670068770381,0.45957731352586284,0.5848711285493411},
{0.3121849577302089,0.44517854958836967,0.8392595612522882},
{0.7339343085611493,0.3539165442155481,0.5797270999766974},
{0.3943927905656821,0.2653951486210244,0.8797839176969755},
{0.6709818401222424,-0.21479418667400543,0.7096807927492629},
{0.6926015202620055,-0.6706014719718465,0.2657005832134202},
{-0.5905931078186474,-0.7676910410978253,0.2486970977218043},
{0.06910319644227886,-0.6692309559938209,-0.739834221823414},
{-0.19490306877297692,-0.14850233818772227,-0.9695152651380253},
{-0.22910446872624418,-0.012700247720747713,-0.9733189847719488},
{-0.04950159249184611,0.04100131903365031,-0.9979321039921865},
{0.3494085676031177,-0.09220226082715358,-0.9324228632889152},
{0.46197879335022574,0.3165854674776655,-0.8284619703261082},
{0.5637182704052205,0.5290171457235439,-0.6343205586624647},
{0.6174008612748022,0.7281010157016253,-0.2978004154318693},
{0.5514147615707535,0.7913211839516454,0.2641070702409068},
{0.46400623396563034,0.531307138159352,0.7088095229199111},
{0.4869025489415156,0.22640118521330688,0.8436044162806788},
{0.4555205216617617,-0.10970494231897972,0.8834397998594956},
{0.11850599477737253,-0.2283115494318494,0.9663488839947265},
{-0.2823994620295372,-0.5381989747319297,0.7940984872438226},
{-0.7035989129405192,-0.21179967276975836,0.6782989520289288},
{-0.9190308431926549,-0.27520923617695175,0.28220947110877825},
{0.48939239245438854,-0.48119251992041634,-0.727288694385118},
{0.34661608162616925,0.11730544251226097,-0.9306431781919016},
{0.27328776518062314,0.2366894036525924,-0.9323582592550788},
{0.5444102758409356,0.30650578535129824,-0.7808147380172714},
{0.560783485169539,0.277491827985997,-0.7800770270698242},
{0.7282210568162911,0.42731235591540956,-0.5358154933289877},
{0.8163062937457872,0.529504082492214,-0.2308017794885798},
{0.8121953339512097,0.531596945984318,0.24029861948839656},
{0.689819673937655,0.3466098854549018,0.6356181280875233},
{0.4018132037988188,0.32521068659874536,0.856028129546513},
{-0.17509988355861614,0.04759996834603157,0.9833993460396523},
{-0.4767207068136105,-0.16600721067979723,0.8632374955349456},
{-0.5664905651782047,-0.3394943457687564,0.7508874940729284},
{-0.7906191332145385,-0.5332129039084138,0.30100728446442715},
{0.6575837315797186,0.2893928405096876,-0.6955827914946051},
{0.7788026128871494,0.33880113667972034,-0.5279017711134132},
{0.7521869835168744,0.4035930158832898,-0.5208909860594788},
{0.8018296040954849,0.41861545556793467,-0.4264157435598837},
{0.8884807645996674,0.4422904245159628,0.12239735012605435},
{0.6608853483342394,0.3891913717229323,0.6416857739840844},
{0.6625233411084681,0.49151731646009367,0.5652199130483112},
{0.17100451030343966,0.3927103578722851,0.9036238333929126},
{-0.17539096672088259,-0.09759497350033149,0.9796495444495363},
{0.026398851542944888,-0.5713751428651027,0.8202643151771853},
{-0.2877920901431022,-0.7016807145705865,0.6517820860155455},
{-0.4968091885709147,-0.8029148500474786,0.32940609242201957},
{0.8284353500905987,0.5469233377167412,0.1207051505986664},
{0.9080733121175295,0.4158877772378378,0.04939854819800237},
{0.8591169849106891,0.5091100652054846,0.05220103202460479},
{0.7472116976906917,0.3407053337837509,0.5706089329527686},
{0.37609972544730064,0.17449987261513947,0.9099993357007274},
{0.4995912372465474,-0.34959386817732785,0.7925860981617563},
{0.8322717448538851,-0.1780939538129003,0.5249821771576231},
{0.7558094287814364,-0.14290178271085904,0.6390079716741702},
{0.4903050182975436,-0.40600415547379703,0.771207893353183},
{0.08909854726003029,-0.6463894607057641,0.757787644373187},
{-0.3215890645497868,-0.6743770681976873,0.6646773980293634},
{-0.6169227957184604,-0.6860253491049828,0.3857142524049444},
{-0.8072122333940963,-0.5048076504179135,-0.3059046360198886},
{0.4189067633042908,-0.45550735422560146,-0.7855126822046321},
{-0.2013068505886903,-0.550018717455438,-0.8105275827229681},
{-0.25309882815513846,0.645397011818753,0.7206966631821743},
{-0.494214043291563,-0.005200147764298113,0.869324702212375},
{-0.23709788272536084,0.5567950278426018,0.7960928909222259},
{0.38231335443870984,0.4457155691167486,0.8094282738234156},
{0.5457871905249557,0.6040858222721249,0.5806863714507912},
{0.6087736254540035,0.4994783605687824,0.6163732962054004},
{0.07280101048503836,0.699809713426234,0.7106098633333551},
{-0.015499541607835322,0.9952705653082901,-0.09589716388331661},
{0.24299186476854903,0.9079696016865948,0.3413885705019862},
{0.4448018303632979,0.6992028772257597,-0.5597023031797164},
{0.057200688128417304,0.8967107874956608,-0.4389052800622789},
{0.1964137867675568,0.46553267688542616,-0.8629605733285375},
{0.3085107903535922,0.5006175094035925,-0.8088282892641341},
{0.18029699176978828,0.651189134999923,-0.7371877001258342},
{-0.12079603674705043,0.58268088255386,-0.8036736319006988},
{0.13559566507588017,0.6516791661500819,-0.7462761419331074},
{-0.5542743986567754,-0.05579742277656155,-0.8304616418626231},
{-0.6110136104797618,-0.028200628175989007,-0.7911176223413087},
{0.15209868967543264,0.5238954866598236,-0.838092779861802},
{-0.8526111309109716,0.3072040105745372,0.42270551845656545},
{-0.5680687741177066,0.08329542137652694,0.818754994274913},
{-0.7907611389987125,0.4161795473587053,0.4488779404356627},
{-0.9032488399852028,0.12690686203955076,-0.4099221650907159},
{-0.8526783635610334,-0.11109718094479983,-0.5104870465555383},
{-0.7920250283863518,0.009200290733780854,-0.6104192895543297},
{-0.3612087323266573,0.04450107582651231,-0.9314225174115409},
{0.0930003134115843,0.34250115423083466,-0.9349031506289265},
{0.4942070252027952,0.3177045162017969,-0.8092115030232738},
{0.38140491824813144,0.3968051168349726,0.8349107662437465},
{0.0056997346835255805,0.03549834759037861,0.9993534811781516},
{-0.49549659595007867,-0.11699919621828296,0.8606940870519328},
{-0.6252086123079522,0.06300086784293185,0.7779107157939157},
{-0.6672188825615685,-0.27200769792677854,-0.693419624053045},
{-0.5490799232596524,-0.5905784058953755,-0.5913783766449798},
{-0.5342195180666454,-0.5880214837573707,-0.6073221889215158},
{-0.579485463789459,-0.6135846084231441,-0.5363865449122792},
{-0.5585087267670341,-0.6029094205332943,-0.5697089017711358},
{-0.30260595988307043,-0.9093179091925842,-0.2856056250581789},
{-0.07029893357326648,-0.9756851989677966,-0.20759685077966034},
{-0.7113264511658891,-0.6225231489536988,-0.3263121341423163},
{-0.26909760638743674,-0.9526915258465662,-0.14129874315326948},
{-0.7400100309039538,-0.32600441901984994,0.5883079745686434},
{-0.32710881570137634,-0.7288196419540296,0.6015162110803359},
{-0.12479637970953618,-0.7132793080674051,0.6896799926736146},
{-0.5766122906219634,-0.13660291172209538,0.8055171697814628},
{-0.5617908541193417,-0.13859774364709998,0.8155867223562392},
{-0.21539823266475147,-0.48809599518878916,0.8457930602964103},
{0.15089150052115674,-0.13959213699637826,0.9786448744867866},
{-0.0943010250577136,0.18390199902559418,0.9784106353814103},
{0.6103929866248752,-0.059099320952703344,0.789890924205421},
{0.4745045434027547,0.41960401772770467,0.7738074092414154},
{0.7208043104226645,-0.2942017593317812,0.6276037530816652},
{0.4939060108727287,0.44180537680415377,0.7489091142793814},
{0.8423955984944967,-0.053499720464690856,0.5361971983769577},
{0.7290881378324955,0.46929236467533963,0.4981918944838146},
{0.8217836096893555,0.18069639604632093,-0.5403892220444484},
{0.9125545952117866,-0.21971314473208717,-0.34492063549429614},
{0.6316071182523343,0.016700188212181732,-0.7751087355246743},
{0.7835284230090763,-0.5656205182564564,-0.2572093304376955},
{0.7950579822959242,-0.3659806584332892,-0.4836744384813716},
{0.6922968881324817,0.06909968939759423,-0.7182967712632697},
{0.8169363299664084,-0.34731544546129717,-0.46042047535381864},
{0.7272392719810591,0.12960699896692143,-0.6740363989483414},
{0.6916955351197313,-0.5378965278891188,-0.48189688936561875},
{0.5025938533147608,-0.062099240530932444,-0.8622894542644612},
{-0.09550325958187525,-0.930731766417291,-0.3530120485068268},
{-0.4351038746172553,-0.5463048648664826,-0.7157063733936327},
{-0.6415161311259283,-0.5939149341787823,-0.48551220835797065},
{-0.22470238747555046,-0.910509674216683,-0.34710368799627755},
{-0.5982061795017515,-0.5723059119506059,-0.5609057941867811},
{-0.41569890047786245,-0.5345985859886101,-0.7357980538167216},
{0.4949003612773956,-0.0678000494940542,-0.8663006323996925},
{0.6984824159265158,0.11769703701438927,-0.7058822296385504},
{0.6470997476311476,0.044599982606010176,-0.7610997031711737},
{0.6018855157993414,0.0015999614973898426,-0.7985807823847051},
{0.8168229938909216,0.17050479977767158,-0.5511155141200869},
{0.741609563116975,0.460605939551886,0.4877062890131455},
{0.5217110943043819,0.4403093632781662,0.7307155388311516},
{0.5002074606499138,0.4153061943380832,0.7598113326705409},
{-0.043101183143716165,0.17100469414328226,0.9843270201475597},
{-0.5323021212281797,-0.14350057185091822,0.8343033247053734},
{-0.5913155695439218,-0.1842048501775586,0.7851206724994639},
{-0.738677315567953,-0.3632888435709183,0.5677825636652006},
{-0.7080000106200002,-0.6171000092565002,-0.3434000051510001},
{0.9490466325519639,-0.1888092773717711,0.2523123976742471},
{0.6043046108617713,0.3495026667155206,0.7160054631425258},
{-0.1337990098909902,0.22299834981831698,0.9655928546393134},
{-0.608185862883924,-0.18729564636329984,0.7713820694321917},
{-0.5651711939583473,-0.6160685997836832,0.5486720348990537},
{-0.5695040947491619,-0.8201058965825947,0.0556003997683115},
{-0.5690097699816266,-0.6171105958798977,-0.5435093321353498},
{0.842218832223635,0.15620349274914724,-0.5160115381469909},
{0.15459264465694667,0.04499785905279819,-0.9869530418913737},
{-0.3265093987083147,0.029700854951414845,-0.9447271943636902},
{-0.6648018016153235,0.7273019709910121,0.1705004620568783},
{-0.41260452629648037,0.7283079895824688,0.5471060017857596},
{-0.12999873901834724,0.705393157719555,0.6967932411383412},
{-0.5228191642877069,0.8206300807469248,0.23070845677347737},
{0.06159854136381056,0.7927812271628085,0.6063856409580313},
{-0.45017258082312767,0.8302494310471856,0.3286799807120437},
{0.25930681726584004,0.5287139000711516,0.8082212484159349},
{-0.3106924347313203,0.8138801822588401,0.4909880445866697},
{0.7085133945723379,0.43750827117205054,0.5537104679953471},
{-0.2279044179699639,0.8671168092222716,0.44290858586615633},
{0.7760182366428441,0.5240123144340855,0.35100824879077097},
{-0.19369771147505832,0.8986893820476763,0.39349535087989385},
{0.789717397665908,0.5179114097140354,0.32880724370336906},
{-0.21219299350302992,0.8801709372354709,0.4245859804023869},
{0.8261259820707106,0.46171452115003886,0.32301015882924533},
{-0.2148928592289298,0.8561715498920879,0.4698843860012755},
{-0.11639923991544501,0.5278965528467648,0.8412945063648101},
{0.6089801475707786,0.2787909115644221,0.7425757924237442},
{-0.3976917161678275,-0.4998895874083404,0.7693839738987338},
{0.30840487129341343,-0.6299099495062294,0.7128112589427532},
{0.8231120298702255,-0.5350078191964167,0.19040278275700515},
{0.9162134638557778,-0.3991058649037775,0.03560052315353164},
{0.9283454761169987,-0.3717182090624673,-0.0005000244942997946},
{0.8828168045778143,-0.4200079949282759,0.210304003174801},
{0.4339026793573176,-0.4962030640633809,0.7520046436430118},
{0.25000785412010773,0.13610427578298664,0.9586301158381411},
{-0.10940146270733465,-0.3569047718486996,0.9277124035977546},
{0.1937954487673279,0.24569422993876402,0.9497776947327556},
{-0.3778041388670121,-0.19550214173769417,0.9050099144379193},
{0.05770114393651793,0.2859056681360567,0.9565189631764194},
{-0.5238016552158458,-0.12100038236181239,0.8432026645246298},
{-0.12229621254494533,0.28839106866690295,0.9496705891572736},
{0.6054036294056375,0.48340289800906033,0.6323037906725876},
{0.5546843498018523,0.5452846150116282,0.628482267622975},
{-0.23489525281491044,0.37209248008696544,0.8979818519701558},
{0.5515895364457395,0.5416897242433957,0.6342879676713787},
{-0.25289850031633965,0.36279784861513653,0.8968946814303086},
{0.5644048962337124,0.5395046802234015,0.6248054202105306},
{-0.28319389865317957,0.31779315322027,0.9048805045595416},
{0.5651135007228004,0.5130122560091959,0.646115435882147},
{-0.27299645652899124,0.25359670833608855,0.9279879547945197},
{-0.18980724697903714,-0.20660788843977385,0.9598366472628022},
{0.5706154039707481,0.18580501587410617,0.799921594174906},
{0.2775863417000767,-0.725664294566807,0.6295690228183295},
{0.9966290172762632,-0.07100206725528264,0.041101196678762206},
{0.5218773353594772,-0.8325638425374607,0.18569193557435318},
{0.5442908695972432,-0.6440891954943676,-0.5374909836643729},
{0.966413404246876,0.20430283369995528,-0.1559021623779884},
{0.47171426013762924,-0.4136125036949829,-0.7787235411684796},
{0.9604938384517894,0.24069845592435782,-0.13969910383312334},
{0.4778890588552448,-0.3522919343684929,-0.8046815770261885},
{0.4889048817396163,-0.28890288470970577,-0.8231082187765969},
{0.9530153007834821,0.27920448266395403,-0.11750188650793195},
{0.940219364017205,0.2959060942487672,-0.16860347242427223},
{0.45041511618495306,-0.27740931001266866,-0.848628480449714},
{0.613266289678559,-0.7375594574709037,-0.2826844612622349},
{0.9626161817140231,0.19490327635161342,0.18810316204073108},
{0.9120381011875324,0.16620694344009634,0.3749156624289538},
{0.25799422486391393,-0.3873913283421716,0.8850801877017451},
{0.7190886492752561,0.45759277695502326,0.5229917446404658},
{-0.04259924493507523,0.30629457097684376,0.9509831439731583},
{0.718168167901421,0.4869784151601115,0.4970779675073746},
{-0.037301324593554896,0.3037107849614644,0.9520338073207576},
{0.687907972899609,0.4760055169359121,0.5479063502713997},
{-0.04400168529682092,0.2812107705787737,0.9586367164893758},
{0.7047124382843045,0.43690771148916224,0.5590098666112193},
{-0.027998910723567035,0.2608898502778086,0.9649624588657923},
{0.04500200960960968,0.022000982475809176,0.9987445999359374},
{0.8232992302155796,0.018699982515524523,0.5672994695752439},
{0.23749679500237703,-0.7524898452180577,0.6142917101893061},
{0.38670439685398844,-0.9119103684798348,-0.13740156226464445},
{0.9761498727710323,-0.15750804729170945,-0.14940763343099298},
{0.5010858044402374,-0.3963887704651968,-0.7692782066571038},
{0.9425396346249715,0.21910921373616046,-0.25221060567895787},
{0.3828013378930139,-0.2729009537905002,-0.8826030847031716},
{0.9145831489607191,0.2779948779915591,-0.2936945887270536},
{0.33381167526751726,-0.234008184579386,-0.9131319373480229},
{0.28909455640075404,-0.24209544138575767,-0.9261825601465872},
{0.9067437382965039,0.25808398638545177,-0.33347930825086464},
{0.9053032138321137,0.22400079520423447,-0.3609012812018224},
{0.27650423884247244,-0.24780379886135503,-0.9285142342323169},
{0.49652144770716056,-0.6394276206726253,-0.5870253571079622},
{0.9972834751497239,0.0468992228863151,-0.05679905884739228},
{0.4285942290175591,-0.4123944471461535,0.8038891757051231},
{0.9942556124490012,0.028398732166902984,0.1031953929445207},
{0.7830599318484047,0.40127946705499273,0.47517568588221415},
{0.031200336809453794,0.25510275384909176,0.9664104324569279},
{0.7629735863116549,0.4349849410820051,0.4781834455756663},
{0.040998563230526947,0.24849129177526696,0.9677660852318043},
{0.7703710307420731,0.42878387588551525,0.4718822552014334},
{0.05349794491591832,0.22769125340849725,0.9722626512476147},
{0.8009717742520044,0.3607872860800539,0.47778316321798714},
{0.054698110212937655,0.1909934012919761,0.9800661392998208},
{0.09079849548139471,-0.04429926596724433,0.9948835149167355},
{0.8819008554442447,0.07940007701811205,0.4647004507596558},
{0.4095176383045308,-0.7005301724843074,0.5844251717342316},
{0.9308156192171368,-0.09320156393536437,-0.3534059302012636},
{0.40361113780302366,-0.9116251566433011,-0.07770214422025505},
{0.3732944939468211,-0.5068925233904196,-0.7769885395035628},
{0.8747843065103105,0.14279743823693683,-0.4629916940035137},
{0.1556057248399272,-0.29051068808482555,-0.9441347353558823},
{0.8573378180052468,0.21430945339848873,-0.46802064484597633},
{0.12459527481380235,-0.2762895219185681,-0.952963859530928},
{0.12139762305781056,-0.22579557896584534,-0.9665810745278393},
{0.854512360610695,0.25610370456688003,-0.45190653687533416},
{0.8753941305020324,0.20369863420523646,-0.43839706055756344},
{0.1407038595598023,-0.20390559320713356,-0.9688265752774448},
{0.5209788356646929,-0.20749157082614927,-0.8279663645496462},
{0.9734389139983961,-0.020700827532121224,-0.22800911484655262},
{0.6033093694672623,-0.4686072775275305,0.6453100217424571},
{0.9973171789363621,0.07250124884476712,0.010100173976995143},
{0.8941024990199771,0.2894008088763912,0.3418009553350052},
{0.1195962106540972,0.17109457895414742,0.9779690135427012},
{0.8716398827952767,0.34281568589057004,0.35031602907662396},
{0.08829942164068239,0.1704988832359722,0.9813935718931561},
{0.8544994958454463,0.3737997794581952,0.36069978718718837},
{0.09249690418042476,0.16899434385396525,0.9812671575378467},
{0.8583956179015559,0.35459818978086177,0.3706981075909911},
{0.08340218016148451,0.11000287551274936,0.9904258900711541},
{0.053700178821893214,-0.07930026407031904,0.9954033146985569},
{0.9158894764903722,0.1455983270848326,0.37409570166508155},
{0.5377154487867686,-0.6371183046718436,0.5522158653897223},
{0.8843227760263986,-0.05340137537013422,-0.46381194563049155},
{0.5106937465933592,-0.8429896776545951,-0.168997930633009},
{0.17979796469855935,-0.4825945370607605,-0.8571902966607624},
{0.8522355048707148,0.14720613273523728,-0.5020209146269642},
{0.12160078675963551,-0.28190182391070107,-0.9517061575587592},
{-0.5178980035070447,-0.8000969156323353,-0.3026988330982476},
{-0.49177864743468247,-0.6841702939707397,0.5385766155110207},
{-0.7709573518189135,-0.3691795775506392,0.5189712913022257},
{-0.7942311106419178,-0.3439134713545146,0.5009196214058632},
{-0.796586338661437,-0.3094946922115425,0.5192910942341002},
{-0.7952248074248075,-0.29960934645934645,0.5271164436539437},
{-0.6494881956593148,-0.6848875522818547,0.3302939969611573},
{-0.3618070516881568,-0.929718120382751,-0.06870133900214585},
{-0.7095052680961734,-0.47130349944147504,-0.5239038900008249},
{-0.7138046611596561,-0.49910325915492343,-0.49130320822042456},
{-0.6885720996237734,-0.5297785338087064,-0.495179935715499},
{-0.6544627294088101,-0.5757672109909746,-0.4900720911890876},
{-0.47150691941481404,-0.7988117226480455,-0.3736054827006883},
{-0.5715081297609692,-0.5733081553665156,0.5871083516757043},
{-0.7524169596694086,-0.32200725812539815,0.5746129519219062},
{-0.7746443070482486,-0.2818161189338968,0.5661323808675621},
{-0.7767450330987287,-0.24541422830234072,0.5800336284244401},
{-0.7934351102804621,-0.22951015604911273,0.5637249453807618},
{-0.619492696224167,-0.7137915844468288,0.3266961482751176},
{-0.4246839875921161,-0.9015660070945417,0.08259688574313348},
{-0.5686083557611823,-0.5777084894886301,-0.585608605581689},
{-0.5898246640340006,-0.5543231795083868,-0.5872245553081811},
{-0.6101204210722456,-0.5776193332426308,-0.5423181516923108},
{-0.5907086568988008,-0.6122089719882272,-0.525607702837328},
{-0.4115882246293377,-0.8124767553725385,-0.4128881874379337},
{-0.5870128762686628,-0.5872128806558073,0.5573122247777271},
{-0.7571212867642203,-0.3044085585669379,0.578016251155355},
{-0.7952394885533401,-0.25928027081840954,0.548058297090514},
{-0.837394217812889,-0.2771980859538247,0.47109674708819205},
{-0.833128281019507,-0.29551003125826947,0.4675158700955702},
{-0.5903018624053138,-0.7378023277700161,0.32740103295188844},
{-0.5745141475850786,-0.8161200972048436,-0.062301534194169526},
{-0.49869351203961226,-0.6587914291792593,-0.5632926716100133},
{-0.49571996056607637,-0.6403257832367535,-0.5867236249023946},
{-0.5058948146047254,-0.6484933529771978,-0.5687941698896378},
{-0.4692902717135,-0.7115852489906811,-0.5228891606200494},
{-0.29090650037837723,-0.90372019385335,-0.3141070187997535},
{-0.6520952201595542,-0.6324953638259746,0.4179969360936876},
{-0.8582907390928876,-0.3661960487659507,0.35949612105778056},
{-0.891243560593562,-0.2984145853692986,0.3415166920362449},
{-0.8924080495569107,-0.24580221714599804,0.37840341321418086},
{-0.8796029906552523,-0.22300075820386683,0.42020142868728627},
{-0.7909023331653243,-0.22770067171797237,0.5680016756074145},
{-0.675497061594173,-0.6362972321130603,0.37259837920057565},
{-0.5548332882217202,-0.7956477363179535,0.24311458609715247},
{-0.12059640567769236,-0.934472148472666,0.3349900157713677},
{0.18740460552477187,-0.9700238386287551,-0.15470380189264785},
{0.19010368234399086,-0.9398182044549321,-0.28390549930278275},
{0.15979502326149955,-0.9694698063330653,-0.18599420730061902},
{0.04600166874080091,-0.9964361463768266,0.07070256478205705},
{-0.7593486507836774,-0.6414566229625086,0.10919261609899603},
{-0.8801490672471749,0.10789375636897315,0.4622732490210963},
{-0.9330296428226362,0.3165100556842062,0.17110543610605902},
{-0.9364961135491932,0.34419857157889194,0.06709972153673344},
{-0.9416858889426806,0.330195052064217,0.06479902899382574},
{-0.9434622858489198,0.3156873806491828,0.10109595876982065},
{-0.9658124494027097,0.2537032702562305,0.053300687050284144},
{-0.9639373725764162,0.2642102436297221,0.0319012368349286},
{-0.95777195205907,0.2852916453564968,0.035798951643051476},
{-0.9456435337021339,-0.13040600337855146,-0.29791371477354667},
{-0.7983197107569909,-0.14420356042986104,-0.5847144367776682},
{-0.402587220071545,-0.08769721609606185,-0.911171075333313},
{-0.5445234313473871,0.17000731557218698,-0.8213353428202187},
{-0.19560081956915099,0.2955012381527818,-0.9351039180936253},
{0.3212868483920361,0.5286783589943027,-0.7856678393452311},
{0.4276101216513707,0.7179169932963494,-0.5493130023926518},
{0.519412346578219,0.816919418405366,0.2507059593514815},
{0.23830713740564954,0.9045270909920688,0.3536105907957939},
{0.39911350223817493,0.5057171086991858,0.7648258744970088},
{0.22600794544898584,0.4405154865941516,0.8688305442746853},
{0.30579931959727086,0.20799953720154457,0.9290979327593994},
{0.6225221061524912,0.12330437861622837,0.7728274435897914},
{0.5817085686303243,0.1158017057716891,-0.8051118593850337},
{0.7450128255061875,0.20610354810312115,-0.6344109214780206},
{0.4156787552017186,0.724162988975426,-0.5502718763230833},
{0.3487969916389206,0.929091986616173,0.12299893913872487},
{0.6412311998630625,0.5950289518379946,0.4845235750680814},
{0.5483012473867567,0.698401588865422,0.4600010465035712},
{0.6522822483801621,0.09749734664581605,0.7516795433195891},
{0.22618878923048583,-0.02899856272185716,-0.9736517421473212},
{0.6551019587577851,0.007600022724101918,-0.7555022589551315},
{0.7036601669253936,0.2987830863682075,-0.6446635066318052},
{0.8554567363695595,0.28908537987660976,-0.4296782695710108},
{0.7985662533031881,0.531977519105054,0.2815881003383143},
{0.7977502478818441,0.5043317663367356,0.3305208185094014},
{0.8895419784764699,-0.3121147290416034,0.3336157436984265},
{0.050802547049546086,0.01780089247011654,-0.9985500635624365},
{0.23310887462378863,-0.11150424504741498,-0.966036777720205},
{0.46942299055395736,-0.10800528968859692,-0.8763429199455323},
{0.8219230100567543,-0.15460432820875314,-0.5482153475034831},
{0.7883995821483322,-0.2796998517591179,-0.5478997096132309},
{0.8833117790411108,0.234003120452417,-0.4062054167853495},
{0.9230223512568568,-0.2081050393245416,0.32360783625863365},
{0.9285883695035074,-0.3677953933915465,-0.04949938002414777},
{0.9305602845345661,-0.3619845508290489,-0.05499765275026986},
{0.4013119713146591,-0.16840502359678194,-0.9003268571507292},
{0.4791920406863058,-0.02729954655829747,-0.8772854284100502},
{0.7926649095011673,0.047897879607803596,-0.6077730944806478},
{-0.3520098564139713,-0.4620129365433374,-0.8140227929573086},
{-0.42089501242365407,-0.4982940952499568,-0.7579910178596574},
{0.11600023896073841,-0.25180051870960285,-0.9608019792541159},
{0.8182448042209163,0.12890705849923748,-0.5602306762705418},
{-0.38410363747867043,-0.36400344712896654,-0.8485080354091432},
{-0.7585018393691908,-0.6063014702828482,-0.23890057933460737},
{-0.7728936275183115,-0.6307947991183218,-0.06879943275101544},
{-0.6229793890678634,-0.7510751510896825,-0.2185927679779052},
{-0.5149603341331338,-0.5840550119750746,-0.6274516692593037},
{-0.7077888170250358,-0.46999257417599155,-0.527391667277485},
{0.10709873302948233,-0.21059750864620896,-0.9716885049929784},
{0.10409807316249847,-0.2134960482247207,-0.9713820198852164},
{0.8154158599927168,0.17650343302515883,-0.5513107230978475},
{0.8325667312981126,0.18539259186004095,-0.5219791421302123},
{-0.7716822708034902,-0.4690892227989079,-0.42949013257755475},
{-0.834219399997723,-0.5104118697660487,-0.20870485348780243},
{-0.746500768896188,-0.6612006810370522,-0.07450007673511855},
{-0.7465135194822579,-0.6653120489103096,0.008800159372329364},
{-0.687111175954166,-0.7195117029530235,0.10090164117854075},
{-0.7137355663294274,-0.4812239799883991,-0.5089253603825775},
{0.10970052766080708,-0.24020115537033598,-0.9645046392784724},
{-0.9469398385970323,-0.21150889836653536,0.24201018158251328},
{-0.9553935224538765,-0.17459881622403897,0.23819838502042429},
{-0.7934794570827808,-0.09469754831221089,-0.6011844355364433},
{-0.826624001376325,-0.18660541816697584,-0.5309154153528804},
{-0.22270828378867613,-0.13540503648399976,-0.9654359100565242},
{-0.11989793717373626,-0.0563990296630419,-0.9911829468440981},
{0.3599059276994442,-0.03270053858230571,-0.9324153570073959},
{0.3401948545917362,-0.12139816386665718,-0.9324858962574779},
{0.7533687509123047,-0.14159412679742814,-0.6421733632013301},
{0.739068198579608,-0.018699195390933124,-0.6733710254681479},
{0.9779225022556683,-0.14940343781265658,-0.14610336187703565},
{0.9943954456792881,-0.030599859852962808,-0.10119953650718419},
{0.9001125521570603,-0.1413019704697174,0.41210574685471013},
{0.8881666366469297,-0.05849780257131884,0.4557828788377286},
{0.40222574729415284,-0.12650809804254187,0.9067580434401004},
{0.41029169372873986,-0.08919819420083742,0.9075816261959646},
{-0.3318883824505049,-0.12819551259462106,0.934567286044718},
{-0.30180821985880335,-0.1498040799696777,0.9415256428000773},
{-0.6930591626919722,-0.14199163338949652,0.7067583554908179},
{-0.6562340463055064,-0.17560911083701147,0.7338380725068281},
{-0.9407087533356749,-0.1523014171712802,0.3031028203848656},
{-0.7189842184696049,-0.11829740340049272,0.6848849669399616},
{-0.9580787787900721,-0.010999756358094972,0.28629365866569007},
{-0.7377185243447223,0.050501268102763286,0.6732169046887178},
{-0.7907003281407042,-0.18620007727304813,0.5832002420281508},
{-0.9140660065173147,-0.363386485907879,0.18009330245462027},
{-0.8061787655309702,-0.19679481649279948,0.5579853028606815},
{-0.9286145236447255,-0.3024047296469578,0.21500336267888864},
{-0.8576679495475769,-0.16479384176919748,-0.4870817980933015},
{-0.20009607315309622,-0.13819728790483704,-0.9699809643103614},
{0.41279621674001027,-0.13679874624523597,-0.9004917470309575},
{0.7742607885552704,-0.11479418639564126,-0.6223684809464035},
{0.9837036692215293,-0.078200291687632,-0.16190060389037875},
{0.9197307701076296,-0.08600287727438963,0.38301281390803754},
{0.4406050207228169,-0.10180116003082787,0.8919101633742178},
{-0.3661011239321757,-0.11370034906060743,0.9236028354650574},
{-0.37102179260500184,0.05730336581203936,0.9268544403943819},
{-0.24689754831951777,-0.23549766151983162,0.9399906659390307},
{-0.41130317115967446,-0.035500273708165435,0.9108070223492136},
{-0.9040294492389712,-0.021800710169700855,-0.42691390694703185},
{-0.2751032971327743,0.03110037274020095,-0.96091151659354},
{0.3912892612135869,0.052398561941201016,-0.9187747845720513},
{0.7936089003737268,0.04300048225311272,-0.6069068064980025},
{0.9967964264912165,0.047699828996419565,-0.06419976984423766},
{0.9061655618322214,0.03939850268835745,0.42108399700678484},
{0.4958908632950149,0.07899854446522722,0.8647840665003608},
{-0.8738178741274248,-0.41960858318135436,-0.24570502594770915},
{-0.6698772747989221,-0.3677875230199187,-0.6449781194884382},
{-0.3117967183568089,-0.2209976740117215,-0.924090274001049},
{0.288389326908513,-0.22349172872417702,-0.9310655419019295},
{0.719386921664645,-0.1679969458432866,-0.6739877470141379},
{0.9316316899909117,-0.2870097628031254,-0.22290758233037164},
{0.9458894155566595,-0.2173975673348322,0.240897304374246},
{0.8422327887607121,-0.19930775920210156,0.5009195011757785},
{0.4999040317422741,-0.30150243162691664,0.8119065480527151},
{-0.9206895732496241,-0.3145964372155227,-0.23099738396943975},
{-0.5841932467651009,-0.324796245377105,-0.7437914018210922},
{0.09159696910643758,-0.4178861723753304,-0.9038700914335036},
{0.6258988389587306,-0.16569969262735523,-0.7620985863084335},
{0.9378135421253231,-0.21080304401793357,-0.27580398263826417},
{0.9727072272415477,-0.09040067167948587,0.21370158780869614},
{0.8254742868764394,-0.15379520935384175,0.5430830832254322},
{0.6064073739585013,-0.11760143004208401,0.7864095627984258},
{-0.9985469477884014,0.038601814906992785,0.037601767888676904},
{-0.7607228296346811,-0.6357190782158102,0.13100393148697675},
{-0.7081656937439299,-0.7045658681332575,-0.04569778622436824},
{-0.9473970820214811,0.2953990901722034,0.12319962054575308},
{-0.7201081732741502,-0.6927078622788555,-0.040000454007729495},
{-0.9315800411114263,0.35899230867217913,0.05729877238695227},
{-0.7553724860582839,-0.6219773448878112,0.20629248593304736},
{-0.8729093794616738,0.44230475259010005,0.20590221243115892},
{-0.6106781289544603,-0.5682796474288845,0.551480249088562},
{-0.7870684509934502,0.3923842715917036,0.4759809206871837},
{-0.1662021564869707,-0.4180054236555581,0.8931115881980358},
{-0.24369665041255995,0.3455952498259365,0.9061875445377998},
{0.556010061093084,0.3166057290325007,0.7685139063849551},
{0.4337762622435553,-0.49547288598820116,0.7525588173455504},
{0.8691200855972698,0.3331076982078594,0.36560844930889635},
{0.6711954560221441,-0.6190958087355622,0.40769723989902884},
{0.9152115225856046,0.38630486360884947,0.1147014441002719},
{0.7636041043830917,-0.6325033997149103,0.12980069768062508},
{0.9455978960470219,0.3252992762099156,0.00499998887503713},
{0.7575213245254323,-0.6449181547015859,-0.10120284890029538},
{0.7223743525539107,-0.6777759359925811,-0.13709513252372807},
{0.9857368031705823,0.14220530933433784,-0.0900033603381885},
{0.7707747922226239,-0.6353792202623965,-0.04689846621074346},
{0.9452027930783804,0.0489001445001405,-0.32280095387822805},
{0.6786304847660789,-0.7334329465479551,-0.039201760982655896},
{0.6498999642555029,0.05109999718950023,-0.7582999582935034},
{0.5810977743997859,-0.6541974944283945,-0.48409814590765166},
{-0.06370276030040702,0.06510282096635003,-0.9958431508186076},
{0.038599464243154434,-0.679790564572445,-0.7323898344996452},
{-0.5056075184396992,-0.6739100211165215,-0.5387080106476778},
{-0.7417281787887785,0.06720255307348781,-0.6673253521717026},
{-0.7027919706476028,-0.6804922254207366,-0.2073976304956073},
{-0.9797914170647796,0.051799546237962416,-0.19319830759023823},
{-0.6837984751311007,-0.7158984035483401,0.1410996853480525},
{-0.9750021937574039,0.08450019012564168,-0.20550046237656053},
{-0.9944766648788346,0.08379803370220848,0.06319851706419542},
{-0.7379933248805646,0.1496986459818706,-0.6579940484707473},
{-0.09499939913070074,0.1893988020563655,-0.9772938186361456},
{0.6519125331389255,0.17630338946524401,-0.7375141788463838},
{0.9427269859462146,0.13390383305208245,-0.30550874531300365},
{0.9763673898737582,0.21219291287506295,0.04099863066860312},
{0.8695629356697838,0.42528187274650303,0.25098930180901075},
{0.540090572801327,0.6892879685835117,0.48289157120118636},
{-0.38330611378127255,0.7139113869774341,0.5860093469236257},
{-0.9133710054976386,0.2967905785326244,0.27869115308976555},
{-0.3729977601551754,0.845094925220211,0.38299770010571627},
{-0.27150606822843815,0.9273207258498367,0.2576057575530227},
{-0.28468929303702956,0.9256651863869977,0.2491906281167115},
{-0.15550239864299875,0.790712196829705,0.5921091333538235},
{0.3556091446067319,0.7280187212421282,0.5861150721428727},
{0.5022199360160481,0.8256327741434674,0.2571102061922062},
{0.4928091047323157,0.8439155914845804,0.21200391680854488},
{0.553077802667826,0.7744689173137429,0.30708767528347375},
{0.8967460087342475,0.004500230890268889,0.44252270420977413},
{0.8670345520153605,0.01130045033191877,0.49811985047156987},
{0.7876221915678756,0.5530155814335135,0.27170765547104087},
{0.6725088132857476,0.6027078985387659,0.42950562870814657},
{0.779585024315523,0.6054883686801555,0.16009692456761832},
{0.9924785130727853,0.0022999502066170336,0.12239735012605432},
{-0.19420161479314058,0.03580029768071283,0.9803081512961672},
{0.7888770834535836,0.00919973275164529,0.6144821495528295},
{0.14199821509365432,0.7082910968368689,0.6914913080088871},
{0.6831966216010593,0.1861990792478297,0.7060965083613993},
{-0.16040264987366404,0.0406006707286207,0.9862162924277275},
{-0.0006000068941188204,0.5871067458952657,0.8095093013153085},
{0.7044786898419435,0.043698678134979324,0.7083785718722964},
{0.6775001558250537,0.047300010879003755,0.7340001688200583},
{0.39590837157102626,0.7451157556392313,0.5367113488814594},
{0.5084953345767077,0.5942945473725417,0.6230942831361782},
{-0.8967460087342475,0.004500230890268889,0.44252270420977413},
{-0.6828758436942863,-0.5646800247974278,0.46348360455747806},
{-0.6123369954571546,-0.5348323128703026,0.5822351768008418},
{-0.8670345520153605,0.01130045033191877,0.49811985047156987},
{-0.8314811380643221,-0.5355878503274214,0.1475966518079302},
{-0.9924785130727853,0.0022999502066170336,0.12239735012605432},
{-0.9081786762150208,-0.20739513041950597,-0.3635914629726729},
{-0.9602000864180117,0.002700000243000033,-0.27930002513700336},
{-0.712668778664695,0.6847700008833775,-0.15229332817543573},
{-0.779585024315523,0.6054883686801555,0.16009692456761832},
{-0.6725088132857476,0.6027078985387659,0.42950562870814657},
{-0.7876221915678756,0.5530155814335135,0.27170765547104087},
{0.19420161479314058,0.03580029768071283,0.9803081512961672},
{0.21601210349724792,-0.595533368669496,0.7737433540547256},
{-0.19420346850492154,-0.7470133417774273,0.6358113556922199},
{-0.7888770834535836,0.00919973275164529,0.6144821495528295},
{-0.14199821509365432,0.7082910968368689,0.6914913080088871},
{-0.6831966216010593,0.1861990792478297,0.7060965083613993},
{0.13130226760974262,0.07610131428104655,0.9884170701102025},
{0.11510322235981557,-0.41081150082895085,0.9044253197412442},
{0.039099451634036234,0.6029915431029116,0.7967888251150912},
{-0.7025821792290329,0.038099033630267794,0.7105819763167531},
{-0.047702041452546876,-0.7606325519666071,0.647427707261611},
{-0.2789050607782422,-0.7773141044923902,0.563910232243997},
{-0.6662764342192752,0.035198755042050854,0.7448736542847637},
{-0.39590837157102626,0.7451157556392313,0.5367113488814594},
{-0.5194936778004116,0.5954927528972956,0.612792542360139},
{0.8012866546818984,0.015099748515782687,0.5980900388933525},
{0.6798557088433063,0.45267050947693005,0.5769624121232353},
{-0.2617027295737042,0.46760487714430304,0.8443088061867731},
{-0.3787027531790234,0.027600200654188136,0.9251067255503422},
{-0.2780013163393493,-0.44420210330193866,0.8517040328281431},
{0.677933636511834,-0.4344215543601427,0.5930294238848172},
{0.5647207566928754,0.20020735875670914,0.8006294276754312},
{-0.004099887931095085,0.18949482022988257,0.9818731608639667},
{-0.4281913206498948,0.02709945069970142,0.9032816906656934},
{-9.999547730683981e-05,-0.2518886073359295,0.9677562293755957},
{0.48871062224081285,-0.40600882469770827,0.7722167843142126},
{0.8728185563197631,0.005800123311932431,0.4880103752108666},
{-0.2701898342987232,0.5864779341828318,0.7635712711713731},
{-0.5670215897580528,0.2283086930189832,0.7914301342760548},
{-0.6149786790587892,0.5596805962100883,0.5554807418165161},
{-0.2125066462492938,0.6198193851544108,0.7554236262433719},
{0.2732147485301992,0.5216281582479938,0.8082436301687665},
{0.10660026596799539,0.27470068537906506,0.955602384230923},
{0.33970098683280014,0.048100139731108875,0.9393027286783903},
{0.5050676615529129,0.02739824574648548,0.8626447666238329},
{0.25529702580697394,-0.4439948274903894,0.8588899939898545},
{0.07479913757091568,-0.20409764676769906,0.9760887457616416},
{-0.9011184821296047,-0.03560073017846402,0.43210886264366016},
{-0.581601660475111,-0.21770062153616174,0.7838022377585833},
{-0.6101884553436362,-0.5271900256590708,0.591388811029542},
{-0.8072254118559542,0.0054001700000274435,0.5902185803733698},
{-0.2656950607747299,-0.5849891251532441,0.7662857548802239},
{-0.20690400880400622,-0.5958115439604974,0.7760150354369688},
{-0.9975685720971964,-0.05099839332092723,0.04749850358321654},
{-0.7933027210329998,0.07650026239635004,-0.6040020717306591},
{-0.9969757687984054,0.05439867785620186,-0.05549865112167653},
{-0.7776831633417685,0.22349516138213357,-0.5875872788731171},
{-0.634188923987163,0.4672918388193019,-0.615989241841836},
{-0.9784918051654474,0.19769834428329988,-0.058899506718696835},
{-0.9886972168212521,0.011299968190634314,-0.149499579159277},
{-0.6660843671833511,0.26769371730218144,-0.6961836607612205},
{-0.7651853965760581,-0.62128814282894,-0.16879677854422193},
{-0.41009505633389365,-0.5132938122803892,-0.7538909118998351},
{-0.10970216499358944,0.37620742452678524,-0.9200181567374867},
{0.12489665656125519,-0.4026892201538628,-0.9067757259387207},
{0.6705768856131225,0.4016861541168973,-0.6236785021725388},
{0.7421105899936794,-0.36710523862913313,-0.5608080027873},
{0.9295576270813323,0.3050860929674209,-0.2069905645501676},
{0.8723876732492649,-0.48689312024881604,-0.04329938818396742},
{0.9455610956890604,0.2832883443408532,0.16019340897777865},
{0.7859894638818546,-0.49649334455132416,0.36839506169729674},
{0.7427646712385988,0.19519071597438675,0.6404695367909564},
{0.513986428367536,-0.48998706206243714,0.7040814089758407},
{-0.20600434879770513,0.15170320248840716,-0.9667204076832115},
{-0.23499182477662156,0.31868891300557145,-0.9182680540100919},
{-0.1833983998559419,0.5484952144001315,-0.8157928822381536},
{0.3438994583587796,0.18149971413817537,-0.9212985489559281},
{0.2849951693728183,0.3586939201895788,-0.8888849335280641},
{0.22150877745921368,0.601523835854253,-0.7675304139952437},
{0.5474016613665634,0.5894017888371437,-0.5941018031017086},
{0.92519717815291,0.35089892975989634,-0.1444995592770163},
{0.9653937587495245,0.16689892100196355,0.2003987044265638},
{0.7944964168292401,0.6045972732724463,0.05689974338273601},
{0.7598784121609615,0.1664952699365707,-0.628382147916763},
{0.7143350818573262,0.3720182702658902,-0.5927291096413793},
{0.9748954277511657,0.21439899447107388,-0.060099718132982934},
{0.959709126877195,0.21000199712848908,0.18670177554232814},
{0.4902910890404343,-0.389892913760688,0.7794858329737273},
{0.8681942699367275,0.0509996634033323,0.4935967422722514},
{0.15710319786813923,-0.28080571585852004,0.9468192727024458},
{0.45647295249652603,0.5950647404834231,0.6614608063010995},
{-0.4785816395675903,0.41258417151188415,0.775070264999664},
{-0.015499809276020281,-0.32499600094881237,0.9455883646067599},
{-0.8097205914564644,-0.0009000228878730616,0.5868149228932361},
{-0.36288412598110587,-0.407182188204757,0.8381633353468253},
{-0.9277438731934563,-0.030398160966890575,0.3719774960422136},
{-0.9100033078680362,-0.032800119228650094,0.41330150235369156},
{-0.9292552388531907,-0.1511927172222129,0.33708376306619026},
{-0.9116145449260973,0.27970446272030436,0.3012048057610142},
{-0.7007992080973423,-0.1368998453032622,0.700099208888341},
{-0.6836692253224677,-0.613472385162109,0.39528220677193426},
{-0.34391253756008927,-0.5558202627970271,0.7568275906527351},
{0.9872227014470326,0.11040253873556767,-0.11490264221663701},
{0.9588367001770624,-0.10850415307593998,0.2624100439366512},
{0.3585908255710901,-0.6060844935265972,0.709981835347111},
{-0.1603930799898425,-0.7246687348418883,0.6701710860922223},
{-0.8521961267774056,-0.31799855469985333,0.41549811156537436},
{-0.183995447088992,0.24549392532797573,0.9517764485831662},
{0.33738768388739543,0.3255881146228096,0.8832677568990409},
{-0.7397754509589831,-0.5707810589448331,0.35628817677302743},
{-0.7350303537051973,0.316513070677136,0.5996247620158318},
{-0.44149636649985546,0.29149760098461575,0.8485930161082159},
{-0.348093224431329,-0.6945864800057486,0.6295877451938086},
{0.01570085077364938,-0.601732605764639,0.7985432702394287},
{-0.008299966551202199,0.3093987531255374,0.950896167896165},
{0.5078759120167261,-0.5978716436203987,0.6201705860066421},
{0.45212464372532774,0.424723150166217,0.7843427517668093},
{0.9151706692500683,-0.33408929260975506,0.22549277307243268},
{0.7744990977090769,0.5397993711340989,0.32979961578367145},
{0.2655934452346564,0.8705785143873941,-0.41418977792241973},
{-0.5560755832571971,0.7905652870403523,-0.2564887378267776},
{0.9555577175064799,-0.16649263286399008,0.24328923468954222},
{0.7938933233852254,-0.09559919601414227,-0.6004949498587074},
{0.9975016209414511,-0.05910009603773409,0.038700062887653285},
{0.7518142507741865,0.06940131551440348,-0.6557124291468928},
{0.18370501429679878,0.12940353211761438,-0.9744265973369665},
{0.11909753113376913,-0.05639883086435415,-0.9912794509899692},
{-0.3590084852658251,-0.03380079889132281,-0.9327220451460586},
{-0.33531637557506155,0.1610078630109899,-0.928245331967707},
{-0.7542228155852624,0.1531046314851547,-0.6385193155014453},
{-0.7385320899164755,-0.022900995069854144,-0.6738292785182411},
{-0.9941697528453977,-0.036398892580539605,-0.10149691200342775},
{-0.9883893600458084,0.09559897088261765,-0.1180987286740287},
{-0.8915923590862239,-0.07669934268944974,0.44629617525816706},
{-0.9293558752305412,-0.001399933532733761,0.3691824716323604},
{-0.783101053271625,-0.07210009697469565,0.6177008308081762},
{-0.4178187416799965,-0.13960626217933822,0.8977402690429221},
{-0.426707881367354,-0.2309042648411578,0.8744161506154542},
{0.32410793750058525,-0.19300472674363764,0.9261226810221908},
{0.35911011627446515,-0.33310938382351535,0.8718245596437726},
{0.7351899242911308,-0.2680963257650329,0.6225914674424077},
{0.6574170470450477,-0.16730433825773727,0.7347190515120118},
{0.8672278471332644,-0.17130550070794304,0.467515012148064},
{0.9915895040806486,0.06309933209710461,-0.11299880391399082},
{0.9886329417984402,0.1366045517394972,-0.06280209260058875},
{0.9102804337323632,-0.02729941320541966,0.41309112070178977},
{0.9684894193108907,0.19119791117423057,-0.1595982563985732},
{0.9227007520014193,-0.04220003439304205,0.3832003123083818},
{0.697937204534308,-0.6993372791672755,-0.1543082256192058},
{0.5426960220527374,-0.800094135331482,0.2555981264725994},
{0.3712984349803949,-0.6806971308676402,0.631497338244329},
{0.4712138326850907,-0.17280507276736773,0.864925390257502},
{-0.10089551983391047,0.15239323312872108,0.9831563439118015},
{-0.15650750393216836,-0.4135198266833969,0.8969430049633342},
{0.7542164835813749,0.20190441266915884,-0.6248136554516615},
{0.2236945531039471,0.29489281944726864,-0.9289773796762041},
{-0.3256938949251589,0.3625932032541069,-0.8731836323262165},
{-0.7516158968443293,0.3615076459675692,-0.5517116688251947},
{-0.976280567328709,0.2135957484189412,-0.035399295384038},
{-0.9228036496956518,0.09250036583967035,0.37400147917877524},
{-0.8300204353546807,-0.07240178255383,0.5530136153628175},
{-0.4429132122981872,-0.2827084333183507,0.8508253804996561},
{0.325703333590679,-0.40400413500348276,0.8548087490123194},
{0.6713978616012163,-0.3795987909797761,0.6364979727571851},
{0.787655522348444,0.46177392436271614,0.407876967837921},
{0.34770090228501216,0.534401386773398,0.7704019991957818},
{-0.3343883367382183,0.6247782081161448,0.7055753899595899},
{-0.6645058111287276,0.6501056851990757,0.3685032225747722},
{-0.8449229357443904,0.49291338031531545,0.20770563824607632},
{-0.9241630665610526,0.3734850739672724,-0.0801967949991305},
{-0.6414057021220378,0.5245046628671794,-0.559904977577376},
{-0.9005937634097825,0.4181971039950822,-0.118499179396024},
{-0.8532563357242504,0.5010743581758138,0.14449260578009399},
{-0.9658080500436458,0.05880049010412754,0.25250210461381295},
{-0.8124901729907862,0.16649798621903497,0.5586932426460951},
{-0.5944954194304399,-0.19699848213254276,0.7795939932514229},
{-0.05910165782475331,0.7047197676667285,0.7070198321844431},
{0.7324056761659856,-0.25650198789810935,-0.6307048879818229},
{0.6765714459046757,-0.24258976171515567,-0.6952706567211366},
{0.9515770434807358,-0.2812932138830716,-0.12399700860825055},
{0.9687695762691784,-0.246092271593564,-0.03039904533297174},
{0.8728406968534601,-0.23118429271682892,0.4297708002149354},
{0.8586238486085972,-0.23950665238965643,0.45321258815445636},
{0.5777976512573214,-0.1959992032648581,0.7922967793201381},
{0.5739024878726774,-0.12960056181965324,0.8086035053037933},
{0.16759408654698246,-0.13999506036144121,0.9758655671909319},
{0.2228924541036973,-0.06509779615141631,0.9726670709137119},
{-0.3412095744749915,-0.08400235713921245,0.9362262708777463},
{-0.2636054870053186,-0.014600303908488816,0.9645200766943468},
{-0.7283763063041278,0.03509885825271126,0.6842777408071314},
{-0.7407260221622459,-0.022700797493024144,0.6714235875249519},
{-0.9290411574349318,0.05120226831073037,0.3664162325986642},
{-0.9361036227280298,0.009300035991208927,0.35160136069989884},
{-0.9976262129731235,0.058701542403290244,-0.03600094593728192},
{-0.9990213093517951,0.019500415948308314,-0.03970084682809436},
{-0.8518547376848113,0.012300790412682765,-0.5236336471610321},
{-0.838912738986663,0.013100198928031095,-0.5441082623466961},
{-0.3396158655257457,-0.092104302753007,-0.9360437283041755},
{-0.3815886708005434,-0.07989762787464208,-0.9208726596965944},
{0.1934037317610068,-0.16160311816224768,-0.9677186723119251},
{0.25180968352757366,-0.19880764529500253,-0.9471364228314734},
{0.6397792586926443,0.4475854895136411,-0.6247797449689968},
{0.8316025779719876,0.5032015599272536,-0.23500072850338752},
{0.7982634643173382,0.5992725719220604,0.060397235681782825},
{0.7546111343694321,0.5542081774019868,0.3513051835462251},
{0.5907849676677441,0.29749243040141143,0.7499809169783481},
{0.20190447627185898,0.05740127260032048,0.9777216763298491},
{-0.36100920224184924,0.07010178691732308,0.9299237040573285},
{-0.6896745859597524,0.5018815060072491,0.521980765363188},
{-0.6581949417913084,0.7012946105716266,0.2737978958712553},
{-0.8139003988112931,0.5809002846412091,-0.011000005390003962},
{-0.7505021201714842,0.5933016760796025,-0.2911008223609848},
{-0.6130878671111636,0.3410932498313781,-0.7125858980646146},
{-0.010500588732011354,0.22991289042756288,-0.9731545614400237},
{-0.9743740819941239,-0.2221940897158193,-0.03499906903714525},
{-0.8639040344412613,-0.21470100265602363,0.45560212766690433},
{-0.8497604700623778,-0.1603925387126446,0.502176639286098},
{-0.9853034387150017,-0.17070059574611873,-0.006200021638113276},
{-0.5657131190393475,-0.6393148258827203,0.520812077772127},
{-0.7877130367586385,-0.6155101867778875,0.02560042369051815},
{-0.5822028528009681,-0.17940087906646113,0.7930038857285601},
{-0.5619184396561508,-0.17240565758448195,0.8090265486417977},
{-0.21249842964240737,-0.5802957116305365,0.7861941900464032},
{-0.16679528893359516,-0.125496455402675,0.9779723775602882},
{-0.18170514141971572,-0.15140428404482642,0.9716274925888597},
{-0.006999773560987893,-0.6388793325878808,0.7692751143525695},
{0.1093008203057346,-0.6833051282242311,0.7219054179204923},
{0.3406932764845322,-0.07369854557355451,0.9372815029320576},
{0.34400016168011394,-0.09550004488503164,0.9341004390273095},
{0.2731938026688789,-0.5042885603437615,0.819181417080328},
{0.12970066536612002,-0.6747034612376342,0.726603727486683},
{0.5011101350549733,-0.579711724788202,0.6425129949567359},
{0.7709280584372895,-0.5434197781227437,0.3322120910790862},
{0.8684835944998484,-0.4956906364923141,-0.005199901774783202},
{0.7856947908608047,-0.5068966392864223,-0.35459764902538043},
{0.5812005782948632,-0.4109004088461102,-0.7024006988890431},
{0.1390976332739046,-0.3538939785451821,-0.9248842632281407},
{-0.27230877529167796,-0.4099132096660257,-0.8705280532185298},
{-0.5962531214411677,-0.6133517771122123,-0.5179592770526997},
{-0.7980895810085296,-0.16149789165878653,-0.5804924217209014},
{-0.7509843008372848,-0.20409573342328874,-0.6279868720716576},
{-0.2203927095297511,-0.18259395989170848,-0.958168304316731},
{0.34820708956851615,-0.1252025491498513,-0.9290189150176665},
{0.8339264984354884,0.00800025421211645,-0.5518175342807321},
{0.998539852520787,0.028801149476813885,-0.045701823996194255},
{0.9346765913179019,0.018999524162875935,0.35499110935899775},
{0.7418913273410749,-0.013099846863685241,0.6703921631614187},
{0.7567019447264969,-0.038900099973385394,0.6526016771884655},
{0.9364172817404033,-0.0202003728013201,0.35030646496546697},
{0.999453576459535,-0.009699549466390685,-0.03159853228226244},
{0.9297825295504032,0.017499671184267648,-0.3676930911117265},
{0.6433993179970844,0.04839994869608157,-0.7639991901612876},
{0.16379410024276198,-0.058397896545648954,-0.9847645294204639},
{-0.3701908045746201,-0.12299694479383652,-0.9207771281802005},
{0.5552977538251287,0.47219808996258916,0.6845972308098021},
{0.37320144802442745,0.20060077833252987,0.9058035145244545},
{0.7153114343446677,0.01150018383190784,0.6987111689873051},
{0.35970061329006847,-0.22990039198050247,0.9043015418354432},
{0.09820457594882699,0.6311294081599258,0.7694358526988543},
{-0.0,-0.6597708750575668,0.7514668272291017},
{-0.0,0.49538492814283835,0.868673571008647},
{-0.09820457594882699,0.6311294081599258,0.7694358526988543},
{-0.35970061329006847,-0.22990039198050247,0.9043015418354432},
{-0.7153114343446677,0.01150018383190784,0.6987111689873051},
{-0.36881576167837016,0.1995085261790533,0.9078387973200229},
{-0.00589974118403126,-0.6076733419552198,0.7941651607385808},
{-0.5552977538251287,0.47219808996258916,0.6845972308098021},
{-0.44681576170399606,-0.6865242175689197,0.5736202348106807},
{0.22860035090180794,0.21090032373224538,0.950401458867359},
{0.0,0.615801216208603,0.7879015561071099},
{-0.22860035090180794,0.21090032373224538,0.950401458867359},
{-0.31540249642063883,-0.7270057542733177,0.6099048274158136},
{0.483486012951965,0.48308602452346283,0.7299788820164105},
{0.3161127064056061,0.2994120351086317,0.9002361857207423},
{0.6763997531141351,0.014099994853502818,0.7363997312141473},
{0.6861570479131589,0.01199924887053032,0.727354469035313},
{0.33709128630287216,-0.27479289669542944,0.9004767229775626},
{0.5009066170201165,-0.5226069036827967,0.6899091137595895},
{-0.0,-0.7092533716698189,0.7049536543454424},
{0.0,-0.6585966378727454,0.7524961585169161},
{-0.33709128630287216,-0.27479289669542944,0.9004767229775626},
{-0.5009066170201165,-0.5226069036827967,0.6899091137595895},
{-0.6764539959280521,0.014099041156815277,0.7363499225445937},
{-0.6861570479131589,0.01199924887053032,0.727354469035313},
{-0.3161127064056061,0.2994120351086317,0.9002361857207423},
{-0.483486012951965,0.48308602452346283,0.7299788820164105},
{0.0,0.6563000196890009,0.754500022635001},
{0.563825130246095,0.5411241184394503,0.62392780908219},
{-0.563825130246095,0.5411241184394503,0.62392780908219},
{0.6468162676336991,-0.013900349598188647,0.762519177598478},
{0.5376928003416047,-0.5094931779320209,0.6717910047786686},
{-0.6468162676336991,-0.013900349598188647,0.762519177598478},
{-0.5376928003416047,-0.5094931779320209,0.6717910047786686},
{-0.7075974385019089,-0.43119843906447586,-0.5597979735350036},
{-0.8231156969660132,-0.05890112325513081,-0.5648107710441066},
{-0.7521120226067728,0.03490055788987684,-0.6581105199807435},
{-0.836629914237385,0.07420265316329663,-0.5427194052792599},
{-0.8117821085194902,0.189995812538437,-0.5521878299143417},
{0.9438972768602845,-0.08159976458501877,-0.3199990768039952},
{-0.36220455656198247,0.9310117122010096,-0.045000566110682524},
{-0.41780279093196515,0.9058060508046292,-0.07040047027671217},
{-0.7982789456704582,-0.08049787689649492,-0.5968842573853144},
{-0.6503850770856074,0.7442829226242583,-0.15179651706887332},
{-0.6614143726904795,0.11130241862783545,0.7417161176663573},
{0.4703168446994448,0.37421340269303044,0.7992286248858097},
{0.5003846359256271,0.7714763121834959,0.3929879334907504},
{-0.774401978599583,0.4948012642188452,0.394301007440361},
{0.49153406203303374,0.8396581861300817,0.23101600880901485},
{-0.7727151067280063,0.5765112709055205,0.26560519263227444},
{0.46559091873769426,0.8820827951428696,0.07179859958197261},
{-0.7659904826273796,0.6318921487888265,0.11819853139237109},
{0.43819681432073976,0.8868935523073119,-0.14629893641059843},
{-0.7774564247885516,0.6196652687350038,-0.10759396952700727},
{0.42410489631929216,0.8187094520551863,-0.3871044691468946},
{-0.8090066824227954,0.47820394998094035,-0.34180282330298073},
{0.45548561371408275,0.6915781568488685,-0.560582294287848},
{-0.8044691290894955,0.3486866194077155,-0.4808815465247214},
{0.5205092287104383,0.6150109042399992,-0.5923105017582951},
{-0.8131122536939954,0.25350382033135876,-0.5240078968585089},
{0.4664139249955992,0.06430191976247218,-0.8822263392605437},
{-0.6225337733733332,-0.2554138565775892,-0.7397401319907703},
{0.128893729472588,0.6214697662312914,0.7727624060233982},
{0.48818255998956106,0.3214885150279473,0.8113710142882626},
{0.476883600254976,0.8013724412756087,0.3610875824115576},
{0.5460009363924089,0.7944013623995048,0.266100456362674},
{0.44451519156626207,0.8872303216143705,0.12340421741119627},
{0.5294852355100588,0.8453764270069948,0.07059803140134117},
{0.45940925948693834,0.8678174910377996,-0.18930381545685118},
{0.5659955484625169,0.8086936396495361,-0.16019874004186435},
{0.4283906504760789,0.7396838565759933,-0.5189886731958099},
{0.4971856762869963,0.7582781543210565,-0.4216878513480015},
{0.4555837587284968,0.08349702338417359,-0.8862684050945274},
{0.08020054817262015,0.4398030060638198,-0.8945061139701835},
{-0.6411022534783815,-0.009000031635166796,0.7674026974252222},
{-0.4983044822689771,0.43940395245632863,0.7474067229537096},
{-0.7343937540076833,0.5920949642537434,0.33179717807700065},
{-0.6801293074032977,0.587025295464984,0.43911892204203495},
{-0.8208711797188111,0.5589803745435686,0.1170958888355132},
{-0.8560595478618261,0.4970765112044314,0.1416933044410942},
{-0.8991520180328023,0.4179776952154263,-0.12969307911349476},
{-0.8729204353065886,0.4694109890398816,-0.13290311129825366},
{-0.8051484560457131,0.44277165466597335,-0.39457474013367905},
{-0.6971091635601829,0.49390649244351503,-0.5197068315912022},
{-0.4939843854003623,0.2278927964225558,-0.8390734773065668},
{-0.6603891003678468,-0.10819821420321174,-0.743087735438139},
{0.05410129168375861,0.52201246319634,0.8512203231278248},
{0.9487584073431133,0.31598614747093573,0.0031998597212246657},
{0.9625072140186037,0.10760080647106676,0.24900186627598164},
{0.5528980842114573,0.7085975447137614,-0.43839848095189526},
{0.12489468584417358,0.32778605300016095,-0.936460154468123},
{-0.6150112425082706,0.26900491745483707,0.7412135495075286},
{-0.4293893061924922,0.19919503910932565,-0.8808780620050451},
{-0.8888858401613483,0.2912953597018796,-0.3535943672865933},
{-0.8593128983834079,0.05750086309443263,0.5082076282537505},
{-0.9297685743532712,0.25659132735970036,0.26399107725238075},
{-0.4256044050283882,0.8613089145933993,0.2775028721695906},
{-0.4192869457041651,0.7842755819598776,0.45728576262941734},
{-0.7350753386360761,0.6129794348849336,0.2896902810541032},
{-0.043597336720047175,0.5410669472297598,-0.8398486952102666},
{-0.1327952287531448,0.73487359646601,-0.6650761042448541},
{-0.4913791045478592,0.42148207685576444,-0.7621675895123694},
{-0.43571168376545233,0.5212139765401739,-0.7338196776384873},
{-0.6979130161991293,0.06730125518011376,-0.7130132978220076},
{-0.5480932968599689,0.01459982144527558,-0.8362897722386279},
{-0.7505317519174115,-0.057502432691873634,-0.6583278511488767},
{-0.77697884703883,-0.09189749812466985,-0.6227830449623981},
{-0.6190662587130782,-0.29318402044043695,-0.728560290903487},
{-0.5306927056788903,-0.3669949556890008,-0.763989499036503},
{-0.16759548084878756,-0.5635848031406723,-0.8088781888937008},
{-0.03769969878061011,-0.41619667460185483,-0.9084927411719969},
{-0.1384000795800686,0.5302003048652629,-0.8365004809879149},
{-0.5188888699531081,0.2687942344255067,-0.8114825938850398},
{-0.5663987737479822,-0.0195999575661378,-0.8238982162622925},
{-0.8169190426048273,-0.17640411202777762,-0.5491127999685527},
{-0.760768443979402,-0.1833923930413017,-0.6225741761587483},
{-0.407709827963856,-0.6315152228579226,-0.6595158978223278},
{-0.20900918406532618,-0.6086267436466867,-0.7654336338928261},
{0.06469767448388526,0.8021711664756223,-0.5935786641983662},
{0.0064997691972936335,0.7770724066487512,-0.629377651196402},
{0.21220177295321957,0.9162076549469358,-0.3399028399000911},
{-0.5770912253946262,0.45019315486512,-0.6813896395492953},
{-0.47916548216195287,0.32897630140083994,-0.8137413801823815},
{-0.4655967128988104,-0.002399983056179435,-0.8849937519661667},
{-0.6285122843926488,-0.4279083635506992,-0.6495126948496824},
{-0.2646088738073772,-0.7336246025135749,-0.6259209906123862},
{-0.9601825392392845,-0.24919546842160975,-0.12629770329714812},
{-0.9633863537289484,-0.16139771381757553,-0.21409696733793634},
{-0.7892276352894829,-0.579820302763358,-0.20230708390656665},
{-0.6180216156840194,-0.614921507255831,-0.4898171316537746},
{-0.5800051910696902,0.6783060708665014,-0.45110403739920213},
{-0.7049149901766509,0.6011127827992409,-0.3765080065278892},
{-0.5738906858297528,0.46949238020050343,-0.670989109935118},
{-0.6382872056611925,-0.7697845698229453,0.0045999077957723416},
{-0.960134613476735,-0.27580994312767787,-0.0455016403637032},
{-0.9954725900395947,-0.08089777251050045,-0.04989862606024688},
{-0.9725078044064457,-0.155101244692483,-0.1737013939592798},
{0.012899982069037388,-0.4613993586553372,-0.887098766933571},
{0.19480094186483088,-0.16000077360561057,-0.9677046788634335},
{0.4698181329807703,0.015100582818241021,-0.8826340659191739},
{0.21930641590304722,0.19860581029797164,-0.9552279456023288},
{0.02420008542645233,0.5119018070165682,-0.8587030312270504},
{0.4340056204091767,0.4889063313779872,-0.7567097994553548},
{0.022800329923161,0.526107612832237,-0.8501123012139984},
{0.5030054500935778,0.011300122437489919,-0.8642093637591848},
{0.3973935344597911,-0.48229215317050145,-0.7806872983209837},
{0.012999973740079567,-0.47479904090690606,-0.8799982224053862},
{0.006099897004108622,-0.4869917772132621,0.8733852530145033},
{-0.04449805258534197,-0.4977782152131064,0.8661620932454654},
{0.11029849388434894,-0.5450925568119548,0.8310886515619438},
{-0.39738577185715346,-0.6056783140761899,0.6893753173586351},
{-0.7094904857963777,-0.6290915639386909,0.31759574106966815},
{-0.9338947561956659,-0.3378981027074799,0.11689934361202842},
{-0.9296670392394253,0.2150923740350655,-0.2990893959734453},
{-0.8817906662951956,0.04279954696919298,0.46969502830443793},
{-0.26569329132908986,-0.6239842445967334,-0.7348814444777875},
{-0.44130345541958393,-0.6776053056703151,-0.5883046064431028},
{-0.5597045867978833,-0.6956057005120736,-0.4504036910733726},
{-0.662225347160253,-0.6830261433259633,-0.30811179320458165},
{-0.871178512646975,-0.09499765691168806,-0.4816881193090541},
{-0.7445870517437542,-0.12409784195729236,-0.6558885941965195},
{-0.5704218760984305,-0.11450439132761273,-0.8133311918493226},
{-0.2991900176915868,-0.08969700730927586,-0.9499683048362548},
{-0.27758710637835615,0.0684968183966765,-0.9582554900662057},
{-0.4507119643078909,0.6421170452232011,-0.6201164612099471},
{-0.5579344869964947,0.6894426157651614,-0.4619285526862896},
{-0.6545583975903317,0.675957037535998,-0.3385784806356345},
{-0.18070662663350023,-0.6381234004141477,0.74842744533764},
{-0.2387917033263994,-0.06969757839970701,0.9685663477468611},
{-0.203406126684805,-0.6628199644379978,0.7206217054526574},
{-0.3440962390486607,-0.09719893762141767,0.9338897926403493},
{-0.47031097953797746,-0.6271146401621639,0.6209144954180953},
{-0.5154856233064461,0.1607955154756092,0.8416765259690315},
{-0.7233085567908406,-0.012700150243666079,0.690408167576934},
{-0.5913920724424031,-0.7078905107913038,0.38619482309309444},
{-0.8858888112949697,0.27689650281925393,0.3721952992030564},
{-0.9218374273593416,0.2280092573637773,0.31341272481494653},
{-0.9473724602828636,-0.3182907474224567,-0.03429900294247648},
{-0.9739818597567914,-0.06699875215986142,-0.21649596780014924},
{-0.892000285440137,0.005600001792000859,-0.4520001446400694},
{-0.7727281973663922,0.004200153266389086,-0.6347231614707508},
{-0.7063390545660203,-0.013800763065285403,-0.7077391319784405},
{-0.6766064785380481,0.022300213525566766,-0.736007047301217},
{-0.46698203788136267,-0.0011999538446630302,-0.8842659873629314},
{-0.43889611359212116,0.028299749406828497,-0.8980920474301298},
{-0.21809427946207358,0.01019973246452614,-0.9758744031501037},
{-0.20160694951132657,0.03230111343857068,-0.9789337444277657},
{-0.21929083273835204,-0.14139408914365242,-0.9653596439836073},
{-0.09209591747846525,-0.43448073989569114,-0.895960282960965},
{-0.08969956450967145,-0.689096654443864,-0.7190965087949246},
{0.05010016683383334,-0.7982026580192769,-0.6003019990089851},
{0.25519730385472705,-0.9599898577607288,-0.11529878187480419},
{0.7992518465268266,-0.10149388517762153,-0.5923643111253497},
{0.9797897857447251,0.13049863955877386,-0.15159841959471354},
{-0.32019221782271756,-0.13009683803477687,0.9383771930194822},
{-0.34991851292865267,-0.15570823796224986,0.9237488722269119},
{-0.24390023658334423,-0.18340017789825883,0.952300923732344},
{-0.37917488997433957,-0.15089000764010507,0.9129395425806225},
{-0.3604961895754141,0.38079597500781615,0.8514909997876982},
{-0.689604165221737,0.15500093620848204,0.7074042727347111},
{-0.9014946180931949,0.15599906868833988,0.4036975899325821},
{-0.7241100000281511,0.12310170004621654,0.6786093716601344},
{-0.8376225072191575,0.43231161636919985,0.3339089722546283},
{-0.863117180518469,-0.19530388756257328,0.465709270035281},
{-0.9788272900852766,0.15420429927579654,0.13460375280494302},
{-0.8020984679933891,-0.2528995169623839,-0.5409989666929604},
{-0.8030777149026127,-0.23169357059262277,-0.548984765884117},
{-0.6559775331542277,0.021499263662829105,-0.7544741597025376},
{-0.8706370202731697,0.14320608925237524,-0.47062001118832264},
{-0.39088959661182743,-0.3600904163211027,0.8470774553335354},
{-0.5335869672974837,-0.555786425082349,0.6374844296329569},
{0.10550342575185215,-0.3360109104513964,0.9359303901531604},
{0.10270123909792461,-0.0007000084456528455,0.9947120012726934},
{-0.1526040486391163,0.03330088348415841,0.9877262047238217},
{-0.35608737870653867,0.3811864890843374,0.8531697599337792},
{-0.34229361628358396,-0.7774855000306354,0.5275901605352582},
{0.2896020706622079,-0.8145058237374596,0.5027035943435494},
{0.7889032068980542,-0.18150073780199877,0.5871023865760522},
{0.9894551836424125,-0.11749467819907372,0.08469616377414081},
{0.7995124485057356,-0.5781090012272242,0.16300253796927444},
{0.9495972604158555,0.1664995196495787,-0.2655992337473159},
{-0.5086148365111747,-0.056701654011371616,-0.8591250610435512},
{-0.3367848517580442,-0.3493842850482798,-0.8743606721414307},
{-0.1112985008192909,-0.5969919585724768,-0.7944892983012274},
{0.414309079682973,-0.0728015954644471,-0.9072198819415714},
{-0.7506433846881634,-0.024901439220270803,-0.6602381595671801},
{-0.6367958194491679,-0.1479990283895679,-0.7566950323134192},
{0.007000041510369236,0.39950236905607284,-0.9167054360793541},
{-0.7953289902700527,-0.03900142162772797,-0.6049220498105807},
{-0.530584080063513,0.06579802575985517,-0.8450746439157083},
{-0.6381228164892127,0.48221724198573634,-0.6002214613020301},
{-0.8145303744040029,0.42661590880386446,-0.39311465951898533},
{-0.9233410618900537,0.35611583682340314,-0.14360638631800252},
{-0.8348156863341207,0.4977093520465882,0.2353044214116179},
{0.9480191644011144,-0.2681054198058426,-0.17140346495606648},
{0.6506124886265798,-0.18900362795945835,-0.7355141183290034},
{0.20890445075673555,-0.0907019324252557,-0.9737207453414716},
{-0.3507116105000516,0.016900559502283637,-0.9363309977507793},
{-0.844707644638776,0.1066009647430964,-0.5245047467894377},
{-0.9911953562606338,0.12529941297362532,-0.04279979948340913},
{-0.9218226356327304,0.12930317507844657,0.36540897272748935},
{-0.7004056593005908,0.1332010762690444,0.7012056657646691},
{-0.30079518430764857,0.12329802601440513,0.9456848597065931},
{0.2013063432628159,0.08270260600017323,0.9760307552136528},
{0.5701982067294599,-0.003999987420059347,0.8214974163946882},
{0.8754013087259348,-0.16240024278854445,0.45530068067502644},
{0.8290145078808331,0.16080281407386968,-0.5356093732460485},
{0.5784136362622142,0.2777065470090195,-0.7670180826644507},
{0.37648683448559306,0.4611838726819536,-0.8034719030788154},
{-0.11399960784202352,0.6267978438191258,-0.7707973484616819},
{-0.5731854126168711,0.5494860157588461,-0.6078845295355825},
{-0.840100861103824,0.41750042793815795,-0.34630035495804573},
{-0.9607944418202312,0.26179848550014206,-0.09129947183408317},
{-0.928342133763883,0.17050773866933325,0.33031499168610423},
{-0.7150788125286726,0.1865944712877224,0.6736800391561554},
{-0.28850761237378003,0.2163057073013817,0.9327246102635169},
{0.22030428055375711,0.17710344115329274,0.9592186377992004},
{-0.9324477751856738,0.36111850238046633,0.011600594371679339},
{-0.8706711072587006,0.4837839458961288,0.08879705331867763},
{-0.6846130043475276,0.6762128447849812,0.2721051686867693},
{-0.10689725170698747,0.9149764762571893,0.3890899966247785},
{-0.300690609578892,-0.059398145024895856,0.951870273555528},
{0.05950023978644951,-0.9920039977841667,0.11130044854171144},
{-0.13409392166029357,0.9352576057335764,0.32758515090165685},
{-0.6660964630371718,-0.04349976901683977,0.7445960462054919},
{-0.4547878436834053,-0.8678768019631211,-0.19989465688723113},
{-0.5494288018127063,-0.8298435015365556,-0.09740510610949689},
{-0.8931167416302342,0.028700537996627168,0.44890841486710575},
{-0.5136939872470687,-0.819390409091392,-0.25439702230028083},
{-0.9707909280011666,0.2388977675107939,0.022199792543908012},
{-0.36227984149906406,-0.8557523829834364,-0.3693794464525373},
{-0.7169861443766385,0.344893335000701,-0.6057882932543481},
{-0.26430333685069174,0.3151039782128376,-0.9115115079054315},
{-0.18340432380790125,-0.8420198508519785,-0.5073119600204379},
{-0.20349139351351317,0.48647942478783374,-0.8496640642183398},
{0.15279825810978628,0.8813899522118169,-0.44699490428713656},
{-0.5177041364725757,0.64880518397413,-0.5577044560764062},
{0.3105040101851875,0.8666111923558244,-0.3906050446967286},
{0.4241949584728777,0.8926893904496415,-0.1521981911352475},
{-0.4924826230572128,0.6465771859264848,0.5825794440469689},
{0.08669749144437708,0.9752717809192728,0.2032941177698023},
{0.20439337367423646,0.9447693710734765,0.2561916943998991},
{0.15209982888778875,0.943998938001792,0.29279967060055584},
{0.6813976934727114,0.7315975235465743,0.021499927222869523},
{0.7674520465253625,-0.5140348604561328,-0.3831259825695418},
{0.605705602802739,-0.7370068173445907,-0.29990277411349087},
{0.34870967857144497,-0.6964193293867343,-0.6272174086607694},
{0.5447028488033488,-0.33410174735670806,-0.7692040229475601},
{-0.06910319644227886,-0.6692309559938209,-0.739834221823414},
{0.19490306877297692,-0.14850233818772227,-0.9695152651380253},
{-0.48939239245438854,-0.48119251992041634,-0.727288694385118},
{-0.34661608162616925,0.11730544251226097,-0.9306431781919016},
{-0.6575837315797186,0.2893928405096876,-0.6955827914946051},
{-0.7788026128871494,0.33880113667972034,-0.5279017711134132},
{-0.8284353500905987,0.5469233377167412,0.1207051505986664},
{-0.9080733121175295,0.4158877772378378,0.04939854819800237},
{-0.7472116976906917,0.3407053337837509,0.5706089329527686},
{-0.8322717448538851,-0.1780939538129003,0.5249821771576231},
{-0.37609972544730064,0.17449987261513947,0.9099993357007274},
{-0.4995912372465474,-0.34959386817732785,0.7925860981617563},
{0.17539096672088259,-0.09759497350033149,0.9796495444495363},
{-0.026398851542944888,-0.5713751428651027,0.8202643151771853},
{0.5664905651782047,-0.3394943457687564,0.7508874940729284},
{0.2877920901431022,-0.7016807145705865,0.6517820860155455},
{0.4968091885709147,-0.8029148500474786,0.32940609242201957},
{0.7906191332145385,-0.5332129039084138,0.30100728446442715},
{0.9190308431926549,-0.27520923617695175,0.28220947110877825},
{0.8950456455283706,-0.254284557767696,-0.36637775055479277},
{0.5905931078186474,-0.7676910410978253,0.2486970977218043},
{0.8821871686809466,-0.24849638564635596,-0.39999418212693116},
{0.6180063654983471,-0.23120238139679264,-0.7514077395395761},
{0.22910446872624418,-0.012700247720747713,-0.9733189847719488},
{-0.27328776518062314,0.2366894036525924,-0.9323582592550788},
{-0.7521869835168744,0.4035930158832898,-0.5208909860594788},
{-0.8591169849106891,0.5091100652054846,0.05220103202460479},
{-0.6625233411084681,0.49151731646009367,0.5652199130483112},
{-0.17100451030343966,0.3927103578722851,0.9036238333929126},
{0.17509988355861614,0.04759996834603157,0.9833993460396523},
{0.4767207068136105,-0.16600721067979723,0.8632374955349456},
{0.7035989129405192,-0.21179967276975836,0.6782989520289288},
{0.5635048405273704,-0.2951025349416628,-0.7716066281294036},
{0.04950159249184611,0.04100131903365031,-0.9979321039921865},
{-0.5444102758409356,0.30650578535129824,-0.7808147380172714},
{-0.8018296040954849,0.41861545556793467,-0.4264157435598837},
{-0.8884807645996674,0.4422904245159628,0.12239735012605435},
{-0.6608853483342394,0.3891913717229323,0.6416857739840844},
{-0.4018132037988188,0.32521068659874536,0.856028129546513},
{-0.11850599477737253,-0.2283115494318494,0.9663488839947265},
{0.2823994620295372,-0.5381989747319297,0.7940984872438226},
{0.17489885791418674,-0.4963967585397501,-0.8502944475953857},
{-0.3494085676031177,-0.09220226082715358,-0.9324228632889152},
{-0.560783485169539,0.277491827985997,-0.7800770270698242},
{-0.7282210568162911,0.42731235591540956,-0.5358154933289877},
{-0.8163062937457872,0.529504082492214,-0.2308017794885798},
{-0.8121953339512097,0.531596945984318,0.24029861948839656},
{-0.689819673937655,0.3466098854549018,0.6356181280875233},
{-0.4869025489415156,0.22640118521330688,0.8436044162806788},
{-0.4555205216617617,-0.10970494231897972,0.8834397998594956},
{-0.6926015202620055,-0.6706014719718465,0.2657005832134202},
{-0.6709818401222424,-0.21479418667400543,0.7096807927492629},
{-0.3943927905656821,0.2653951486210244,0.8797839176969755},
{-0.7339343085611493,0.3539165442155481,0.5797270999766974},
{-0.3121849577302089,0.44517854958836967,0.8392595612522882},
{-0.6683670068770381,0.45957731352586284,0.5848711285493411},
{-0.333308682804282,0.6499169305565644,0.6830177928452584},
{-0.6633029550212469,0.5508024538303977,0.5066022569180819},
{-0.34879423796678277,0.8621857568089453,0.3673939307023968},
{-0.5434071376996308,0.783610292788794,0.30110395502642406},
{-0.400093826599883,0.8850863432230853,-0.23779633083092272},
{-0.3942146571734356,0.5660210450536899,-0.7240269198213277},
{-0.33140005633801434,0.3353000570010145,-0.8819001499230382},
{-0.34101773679374797,-0.07130370860232912,-0.9373487527764808},
{-0.5514147615707535,0.7913211839516454,0.2641070702409068},
{-0.6174008612748022,0.7281010157016253,-0.2978004154318693},
{-0.5637182704052205,0.5290171457235439,-0.6343205586624647},
{-0.46197879335022574,0.3165854674776655,-0.8284619703261082},
{-0.46400623396563034,0.531307138159352,0.7088095229199111},
{-0.7558094287814364,-0.14290178271085904,0.6390079716741702},
{-0.4903050182975436,-0.40600415547379703,0.771207893353183},
{-0.08909854726003029,-0.6463894607057641,0.757787644373187},
{0.3215890645497868,-0.6743770681976873,0.6646773980293634},
{0.6169227957184604,-0.6860253491049828,0.3857142524049444},
{0.8072122333940963,-0.5048076504179135,-0.3059046360198886},
{-0.4189067633042908,-0.45550735422560146,-0.7855126822046321},
{0.2013068505886903,-0.550018717455438,-0.8105275827229681},
{0.23709788272536084,0.5567950278426018,0.7960928909222259},
{0.494214043291563,-0.005200147764298113,0.869324702212375},
{0.25309882815513846,0.645397011818753,0.7206966631821743},
{-0.38231335443870984,0.4457155691167486,0.8094282738234156},
{-0.07280101048503836,0.699809713426234,0.7106098633333551},
{-0.6087736254540035,0.4994783605687824,0.6163732962054004},
{-0.5457871905249557,0.6040858222721249,0.5806863714507912},
{0.015499541607835322,0.9952705653082901,-0.09589716388331661},
{-0.24299186476854903,0.9079696016865948,0.3413885705019862},
{-0.4448018303632979,0.6992028772257597,-0.5597023031797164},
{-0.057200688128417304,0.8967107874956608,-0.4389052800622789},
{-0.1964137867675568,0.46553267688542616,-0.8629605733285375},
{-0.3085107903535922,0.5006175094035925,-0.8088282892641341},
{-0.18029699176978828,0.651189134999923,-0.7371877001258342},
{0.12079603674705043,0.58268088255386,-0.8036736319006988},
{-0.13559566507588017,0.6516791661500819,-0.7462761419331074},
{0.5542743986567754,-0.05579742277656155,-0.8304616418626231},
{0.6110136104797618,-0.028200628175989007,-0.7911176223413087},
{-0.15209868967543264,0.5238954866598236,-0.838092779861802},
{0.7907611389987125,0.4161795473587053,0.4488779404356627},
{0.5680687741177066,0.08329542137652694,0.818754994274913},
{0.8526111309109716,0.3072040105745372,0.42270551845656545},
{0.9032488399852028,0.12690686203955076,-0.4099221650907159},
{0.8526783635610334,-0.11109718094479983,-0.5104870465555383},
{0.7920250283863518,0.009200290733780854,-0.6104192895543297},
{0.3612087323266573,0.04450107582651231,-0.9314225174115409},
{0.6672188825615685,-0.27200769792677854,-0.693419624053045},
{0.5982061795017515,-0.5723059119506059,-0.5609057941867811},
{0.5490799232596524,-0.5905784058953755,-0.5913783766449798},
{0.6415161311259283,-0.5939149341787823,-0.48551220835797065},
{0.579485463789459,-0.6135846084231441,-0.5363865449122792},
{-0.0930003134115843,0.34250115423083466,-0.9349031506289265},
{-0.4942070252027952,0.3177045162017969,-0.8092115030232738},
{-0.38140491824813144,0.3968051168349726,0.8349107662437465},
{-0.5217110943043819,0.4403093632781662,0.7307155388311516},
{-0.741609563116975,0.460605939551886,0.4877062890131455},
{-0.8168229938909216,0.17050479977767158,-0.5511155141200869},
{-0.6018855157993414,0.0015999614973898426,-0.7985807823847051},
{-0.6470997476311476,0.044599982606010176,-0.7610997031711737},
{-0.6984824159265158,0.11769703701438927,-0.7058822296385504},
{-0.4949003612773956,-0.0678000494940542,-0.8663006323996925},
{0.41569890047786245,-0.5345985859886101,-0.7357980538167216},
{0.4351038746172553,-0.5463048648664826,-0.7157063733936327},
{-0.5025938533147608,-0.062099240530932444,-0.8622894542644612},
{-0.7272392719810591,0.12960699896692143,-0.6740363989483414},
{-0.6922968881324817,0.06909968939759423,-0.7182967712632697},
{-0.6316071182523343,0.016700188212181732,-0.7751087355246743},
{-0.8217836096893555,0.18069639604632093,-0.5403892220444484},
{-0.7290881378324955,0.46929236467533963,0.4981918944838146},
{-0.4939060108727287,0.44180537680415377,0.7489091142793814},
{-0.5002074606499138,0.4153061943380832,0.7598113326705409},
{-0.4745045434027547,0.41960401772770467,0.7738074092414154},
{0.043101183143716165,0.17100469414328226,0.9843270201475597},
{0.0943010250577136,0.18390199902559418,0.9784106353814103},
{0.5323021212281797,-0.14350057185091822,0.8343033247053734},
{0.5617908541193417,-0.13859774364709998,0.8155867223562392},
{0.5913155695439218,-0.1842048501775586,0.7851206724994639},
{0.5766122906219634,-0.13660291172209538,0.8055171697814628},
{0.7400100309039538,-0.32600441901984994,0.5883079745686434},
{0.738677315567953,-0.3632888435709183,0.5677825636652006},
{0.7113264511658891,-0.6225231489536988,-0.3263121341423163},
{0.7080000106200002,-0.6171000092565002,-0.3434000051510001},
{0.5585087267670341,-0.6029094205332943,-0.5697089017711358},
{0.5342195180666454,-0.5880214837573707,-0.6073221889215158},
{0.6252086123079522,0.06300086784293185,0.7779107157939157},
{0.49549659595007867,-0.11699919621828296,0.8606940870519328},
{-0.0056997346835255805,0.03549834759037861,0.9993534811781516},
{0.9140660065173147,-0.363386485907879,0.18009330245462027},
{0.9286145236447255,-0.3024047296469578,0.21500336267888864},
{0.9206895732496241,-0.3145964372155227,-0.23099738396943975},
{0.8738178741274248,-0.41960858318135436,-0.24570502594770915},
{0.5841932467651009,-0.324796245377105,-0.7437914018210922},
{0.6698772747989221,-0.3677875230199187,-0.6449781194884382},
{0.3117967183568089,-0.2209976740117215,-0.924090274001049},
{-0.09159696910643758,-0.4178861723753304,-0.9038700914335036},
{-0.288389326908513,-0.22349172872417702,-0.9310655419019295},
{-0.719386921664645,-0.1679969458432866,-0.6739877470141379},
{-0.6258988389587306,-0.16569969262735523,-0.7620985863084335},
{-0.9378135421253231,-0.21080304401793357,-0.27580398263826417},
{-0.9316316899909117,-0.2870097628031254,-0.22290758233037164},
{-0.9727072272415477,-0.09040067167948587,0.21370158780869614},
{-0.9458894155566595,-0.2173975673348322,0.240897304374246},
{-0.8254742868764394,-0.15379520935384175,0.5430830832254322},
{-0.8422327887607121,-0.19930775920210156,0.5009195011757785},
{-0.6064073739585013,-0.11760143004208401,0.7864095627984258},
{-0.4999040317422741,-0.30150243162691664,0.8119065480527151},
{0.41130317115967446,-0.035500273708165435,0.9108070223492136},
{0.24689754831951777,-0.23549766151983162,0.9399906659390307},
{0.7907003281407042,-0.18620007727304813,0.5832002420281508},
{0.8061787655309702,-0.19679481649279948,0.5579853028606815},
{0.9040294492389712,-0.021800710169700855,-0.42691390694703185},
{0.2751957262435569,0.0310995170282508,-0.9608850775706171},
{-0.3912913095165223,0.052298838455696696,-0.9187795941318189},
{-0.7936123090223701,0.04290066539448044,-0.6069094132379995},
{-0.9968059160606677,0.04750028191500975,-0.06420038103039212},
{-0.9061201795210994,0.03910087078608872,0.4212093804373547},
{-0.4958908632950149,0.07899854446522722,0.8647840665003608},
{0.37102179260500184,0.05730336581203936,0.9268544403943819},
{0.7377185243447223,0.050501268102763286,0.6732169046887178},
{0.9580787787900721,-0.010999756358094972,0.28629365866569007},
{0.8577790318478465,-0.16419598627817256,-0.48708809327708796},
{0.20040900157246297,-0.13800619868762423,-0.9699435659936718},
{-0.41238188033825823,-0.13759395425447218,-0.9005604302440235},
{-0.7740064049295012,-0.11630096239444573,-0.6224051504239296},
{-0.9835333128374683,-0.08010271312484109,-0.16200548721877972},
{-0.9195127491326508,-0.08790121875884721,0.38310531179197227},
{-0.4400067827568347,-0.102601581615571,0.8921137520394824},
{0.3662909270861027,-0.113297193663269,0.923577123277981},
{0.7190918814984865,-0.11759867231848423,0.6848922676099477},
{0.9407917728119198,-0.15179867252641308,0.3030973494252688},
{0.6923914386327916,-0.14109825533085918,0.7075912506882774},
{0.9469643569323949,-0.21119205088080445,0.2421908841066801},
{0.3314068336793664,-0.12760263119338308,0.934819276172214},
{-0.4019859146603212,-0.1271955431462509,0.9067682273979584},
{-0.8998122870206694,-0.1432019554360523,0.4121056273407623},
{-0.977585566055675,-0.15159776167557318,-0.1460978428812747},
{-0.7531589953747149,-0.14319220411266484,-0.6420650437202661},
{-0.3401049978796661,-0.12220179576858334,-0.9324137019200254},
{0.22220208870945085,-0.1350012690178932,-0.9656090767679826},
{0.8262250680488525,-0.18580563742856063,-0.5318161355463324},
{0.7081656937439299,-0.7045658681332575,-0.04569778622436824},
{0.7607228296346811,-0.6357190782158102,0.13100393148697675},
{0.9985469477884014,0.038601814906992785,0.037601767888676904},
{0.9473970820214811,0.2953990901722034,0.12319962054575308},
{0.9133710054976386,0.2967905785326244,0.27869115308976555},
{0.9944766648788346,0.08379803370220848,0.06319851706419542},
{0.38330611378127255,0.7139113869774341,0.5860093469236257},
{-0.540090572801327,0.6892879685835117,0.48289157120118636},
{-0.8695629356697838,0.42528187274650303,0.25098930180901075},
{-0.9763673898737582,0.21219291287506295,0.04099863066860312},
{-0.9427269859462146,0.13390383305208245,-0.30550874531300365},
{-0.6519125331389255,0.17630338946524401,-0.7375141788463838},
{0.09499939913070074,0.1893988020563655,-0.9772938186361456},
{0.7379933248805646,0.1496986459818706,-0.6579940484707473},
{0.9750021937574039,0.08450019012564168,-0.20550046237656053},
{0.9797914170647796,0.051799546237962416,-0.19319830759023823},
{0.6837984751311007,-0.7158984035483401,0.1410996853480525},
{0.7027919706476028,-0.6804922254207366,-0.2073976304956073},
{0.7417281787887785,0.06720255307348781,-0.6673253521717026},
{0.5056075184396992,-0.6739100211165215,-0.5387080106476778},
{0.06370276030040702,0.06510282096635003,-0.9958431508186076},
{-0.038599464243154434,-0.679790564572445,-0.7323898344996452},
{-0.5810977743997859,-0.6541974944283945,-0.48409814590765166},
{-0.6498999642555029,0.05109999718950023,-0.7582999582935034},
{-0.6786304847660789,-0.7334329465479551,-0.039201760982655896},
{-0.9452027930783804,0.0489001445001405,-0.32280095387822805},
{-0.7707747922226239,-0.6353792202623965,-0.04689846621074346},
{-0.9857368031705823,0.14220530933433784,-0.0900033603381885},
{-0.7223743525539107,-0.6777759359925811,-0.13709513252372807},
{-0.9455978960470219,0.3252992762099156,0.00499998887503713},
{-0.7575213245254323,-0.6449181547015859,-0.10120284890029538},
{-0.7636041043830917,-0.6325033997149103,0.12980069768062508},
{-0.9152115225856046,0.38630486360884947,0.1147014441002719},
{-0.6711954560221441,-0.6190958087355622,0.40769723989902884},
{-0.8691200855972698,0.3331076982078594,0.36560844930889635},
{-0.4337762622435553,-0.49547288598820116,0.7525588173455504},
{-0.556010061093084,0.3166057290325007,0.7685139063849551},
{0.1662021564869707,-0.4180054236555581,0.8931115881980358},
{0.24369665041255995,0.3455952498259365,0.9061875445377998},
{0.7870684509934502,0.3923842715917036,0.4759809206871837},
{0.6106781289544603,-0.5682796474288845,0.551480249088562},
{0.8729093794616738,0.44230475259010005,0.20590221243115892},
{0.7553724860582839,-0.6219773448878112,0.20629248593304736},
{0.9315800411114263,0.35899230867217913,0.05729877238695227},
{0.7201081732741502,-0.6927078622788555,-0.040000454007729495},
{0.3729977601551754,0.845094925220211,0.38299770010571627},
{-0.553077802667826,0.7744689173137429,0.30708767528347375},
{0.27150606822843815,0.9273207258498367,0.2576057575530227},
{-0.4928091047323157,0.8439155914845804,0.21200391680854488},
{0.28468929303702956,0.9256651863869977,0.2491906281167115},
{-0.5022199360160481,0.8256327741434674,0.2571102061922062},
{-0.3556091446067319,0.7280187212421282,0.5861150721428727},
{0.15550239864299875,0.790712196829705,0.5921091333538235},
{-0.0,-0.5756147790991825,0.8177209952560832},
{-0.0,0.004699948089360028,0.9999889551829846},
{0.30260595988307043,-0.9093179091925842,-0.2856056250581789},
{0.22470238747555046,-0.910509674216683,-0.34710368799627755},
{0.09550325958187525,-0.930731766417291,-0.3530120485068268},
{-0.6916955351197313,-0.5378965278891188,-0.48189688936561875},
{-0.8169363299664084,-0.34731544546129717,-0.46042047535381864},
{-0.7950579822959242,-0.3659806584332892,-0.4836744384813716},
{-0.7835284230090763,-0.5656205182564564,-0.2572093304376955},
{-0.9125545952117866,-0.21971314473208717,-0.34492063549429614},
{-0.8423955984944967,-0.053499720464690856,0.5361971983769577},
{-0.7208043104226645,-0.2942017593317812,0.6276037530816652},
{-0.6103929866248752,-0.059099320952703344,0.789890924205421},
{-0.15089150052115674,-0.13959213699637826,0.9786448744867866},
{0.21539823266475147,-0.48809599518878916,0.8457930602964103},
{0.12479637970953618,-0.7132793080674051,0.6896799926736146},
{0.32710881570137634,-0.7288196419540296,0.6015162110803359},
{0.26909760638743674,-0.9526915258465662,-0.14129874315326948},
{0.07029893357326648,-0.9756851989677966,-0.20759685077966034},
{-0.9490466325519639,-0.1888092773717711,0.2523123976742471},
{-0.842218832223635,0.15620349274914724,-0.5160115381469909},
{-0.15459264465694667,0.04499785905279819,-0.9869530418913737},
{0.3265093987083147,0.029700854951414845,-0.9447271943636902},
{-0.6043046108617713,0.3495026667155206,0.7160054631425258},
{0.1337990098909902,0.22299834981831698,0.9655928546393134},
{0.608185862883924,-0.18729564636329984,0.7713820694321917},
{0.5651711939583473,-0.6160685997836832,0.5486720348990537},
{0.5695040947491619,-0.8201058965825947,0.0556003997683115},
{0.5690097699816266,-0.6171105958798977,-0.5435093321353498},
{0.6648018016153235,0.7273019709910121,0.1705004620568783},
{0.41260452629648037,0.7283079895824688,0.5471060017857596},
{-0.23830713740564954,0.9045270909920688,0.3536105907957939},
{-0.519412346578219,0.816919418405366,0.2507059593514815},
{-0.4276101216513707,0.7179169932963494,-0.5493130023926518},
{-0.3212868483920361,0.5286783589943027,-0.7856678393452311},
{0.19560081956915099,0.2955012381527818,-0.9351039180936253},
{0.5445234313473871,0.17000731557218698,-0.8213353428202187},
{0.402587220071545,-0.08769721609606185,-0.911171075333313},
{0.7983197107569909,-0.14420356042986104,-0.5847144367776682},
{0.9456435337021339,-0.13040600337855146,-0.29791371477354667},
{0.95777195205907,0.2852916453564968,0.035798951643051476},
{0.9639373725764162,0.2642102436297221,0.0319012368349286},
{0.5228191642877069,0.8206300807469248,0.23070845677347737},
{0.45017258082312767,0.8302494310471856,0.3286799807120437},
{0.9658124494027097,0.2537032702562305,0.053300687050284144},
{0.9434622858489198,0.3156873806491828,0.10109595876982065},
{0.3106924347313203,0.8138801822588401,0.4909880445866697},
{0.2279044179699639,0.8671168092222716,0.44290858586615633},
{0.9416858889426806,0.330195052064217,0.06479902899382574},
{0.19369771147505832,0.8986893820476763,0.39349535087989385},
{0.9364961135491932,0.34419857157889194,0.06709972153673344},
{0.21219299350302992,0.8801709372354709,0.4245859804023869},
{0.9330296428226362,0.3165100556842062,0.17110543610605902},
{0.8801490672471749,0.10789375636897315,0.4622732490210963},
{0.2148928592289298,0.8561715498920879,0.4698843860012755},
{0.11639923991544501,0.5278965528467648,0.8412945063648101},
{0.3977115954506005,-0.49981457230628645,0.7694224328380488},
{0.7593486507836774,-0.6414566229625086,0.10919261609899603},
{-0.30840487129341343,-0.6299099495062294,0.7128112589427532},
{-0.04600166874080091,-0.9964361463768266,0.07070256478205705},
{-0.8231120298702255,-0.5350078191964167,0.19040278275700515},
{-0.9162134638557778,-0.3991058649037775,0.03560052315353164},
{-0.15979502326149955,-0.9694698063330653,-0.18599420730061902},
{-0.19010368234399086,-0.9398182044549321,-0.28390549930278275},
{-0.9283454761169987,-0.3717182090624673,-0.0005000244942997946},
{-0.18740460552477187,-0.9700238386287551,-0.15470380189264785},
{-0.8828168045778143,-0.4200079949282759,0.210304003174801},
{-0.4339026793573176,-0.4962030640633809,0.7520046436430118},
{0.12059640567769236,-0.934472148472666,0.3349900157713677},
{0.10940146270733465,-0.3569047718486996,0.9277124035977546},
{0.5548332882217202,-0.7956477363179535,0.24311458609715247},
{0.3778041388670121,-0.19550214173769417,0.9050099144379193},
{0.5238016552158458,-0.12100038236181239,0.8432026645246298},
{0.675497061594173,-0.6362972321130603,0.37259837920057565},
{0.7909023331653243,-0.22770067171797237,0.5680016756074145},
{0.12229621254494533,0.28839106866690295,0.9496705891572736},
{0.23489525281491044,0.37209248008696544,0.8979818519701558},
{0.8796029906552523,-0.22300075820386683,0.42020142868728627},
{0.25289850031633965,0.36279784861513653,0.8968946814303086},
{0.8924080495569107,-0.24580221714599804,0.37840341321418086},
{0.28319389865317957,0.31779315322027,0.9048805045595416},
{0.891243560593562,-0.2984145853692986,0.3415166920362449},
{0.27299645652899124,0.25359670833608855,0.9279879547945197},
{0.8582907390928876,-0.3661960487659507,0.35949612105778056},
{0.6520952201595542,-0.6324953638259746,0.4179969360936876},
{0.18980724697903714,-0.20660788843977385,0.9598366472628022},
{-0.2775863417000767,-0.725664294566807,0.6295690228183295},
{0.29089736157289575,-0.9036918035525124,-0.31419715024477085},
{-0.5218773353594772,-0.8325638425374607,0.18569193557435318},
{-0.5442908695972432,-0.6440891954943676,-0.5374909836643729},
{-0.47171426013762924,-0.4136125036949829,-0.7787235411684796},
{0.4692902717135,-0.7115852489906811,-0.5228891606200494},
{-0.4778890588552448,-0.3522919343684929,-0.8046815770261885},
{0.5058948146047254,-0.6484933529771978,-0.5687941698896378},
{0.49571996056607637,-0.6403257832367535,-0.5867236249023946},
{-0.4889048817396163,-0.28890288470970577,-0.8231082187765969},
{-0.45041511618495306,-0.27740931001266866,-0.848628480449714},
{0.49869351203961226,-0.6587914291792593,-0.5632926716100133},
{-0.613266289678559,-0.7375594574709037,-0.2826844612622349},
{0.5745141475850786,-0.8161200972048436,-0.062301534194169526},
{0.5903018624053138,-0.7378023277700161,0.32740103295188844},
{-0.25799422486391393,-0.3873913283421716,0.8850801877017451},
{0.04259924493507523,0.30629457097684376,0.9509831439731583},
{0.833128281019507,-0.29551003125826947,0.4675158700955702},
{0.037301324593554896,0.3037107849614644,0.9520338073207576},
{0.837394217812889,-0.2771980859538247,0.47109674708819205},
{0.04400168529682092,0.2812107705787737,0.9586367164893758},
{0.7952027275500333,-0.25930088940357593,0.5481018799926726},
{0.027998910723567035,0.2608898502778086,0.9649624588657923},
{0.7571212867642203,-0.3044085585669379,0.578016251155355},
{0.5869784054616872,-0.5872783944252964,0.5572794980643924},
{-0.04500200960960968,0.022000982475809176,0.9987445999359374},
{-0.23749679500237703,-0.7524898452180577,0.6142917101893061},
{0.4115882246293377,-0.8124767553725385,-0.4128881874379337},
{-0.38670439685398844,-0.9119103684798348,-0.13740156226464445},
{-0.5010858044402374,-0.3963887704651968,-0.7692782066571038},
{-0.3828013378930139,-0.2729009537905002,-0.8826030847031716},
{0.5907086568988008,-0.6122089719882272,-0.525607702837328},
{-0.33381167526751726,-0.234008184579386,-0.9131319373480229},
{0.6101204210722456,-0.5776193332426308,-0.5423181516923108},
{0.5898246640340006,-0.5543231795083868,-0.5872245553081811},
{-0.28909455640075404,-0.24209544138575767,-0.9261825601465872},
{-0.27650423884247244,-0.24780379886135503,-0.9285142342323169},
{0.5686083557611823,-0.5777084894886301,-0.585608605581689},
{-0.49652144770716056,-0.6394276206726253,-0.5870253571079622},
{0.4246839875921161,-0.9015660070945417,0.08259688574313348},
{-0.4285942290175591,-0.4123944471461535,0.8038891757051231},
{0.619492696224167,-0.7137915844468288,0.3266961482751176},
{-0.031200336809453794,0.25510275384909176,0.9664104324569279},
{0.7934351102804621,-0.22951015604911273,0.5637249453807618},
{-0.040998563230526947,0.24849129177526696,0.9677660852318043},
{0.7767450330987287,-0.24541422830234072,0.5800336284244401},
{-0.05349794491591832,0.22769125340849725,0.9722626512476147},
{0.7746443070482486,-0.2818161189338968,0.5661323808675621},
{-0.054698110212937655,0.1909934012919761,0.9800661392998208},
{0.7524169596694086,-0.32200725812539815,0.5746129519219062},
{0.5715081297609692,-0.5733081553665156,0.5871083516757043},
{-0.09079889725408923,-0.04419946320077912,0.9948879171596187},
{-0.4095176383045308,-0.7005301724843074,0.5844251717342316},
{0.47150691941481404,-0.7988117226480455,-0.3736054827006883},
{-0.40361113780302366,-0.9116251566433011,-0.07770214422025505},
{-0.3732944939468211,-0.5068925233904196,-0.7769885395035628},
{-0.1556057248399272,-0.29051068808482555,-0.9441347353558823},
{0.6544627294088101,-0.5757672109909746,-0.4900720911890876},
{-0.12459527481380235,-0.2762895219185681,-0.952963859530928},
{0.6885720996237734,-0.5297785338087064,-0.495179935715499},
{0.7138046611596561,-0.49910325915492343,-0.49130320822042456},
{-0.12139762305781056,-0.22579557896584534,-0.9665810745278393},
{-0.1407038595598023,-0.20390559320713356,-0.9688265752774448},
{0.7095052680961734,-0.47130349944147504,-0.5239038900008249},
{-0.5209788356646929,-0.20749157082614927,-0.8279663645496462},
{0.3618070516881568,-0.929718120382751,-0.06870133900214585},
{-0.6033093694672623,-0.4686072775275305,0.6453100217424571},
{0.6494881956593148,-0.6848875522818547,0.3302939969611573},
{-0.1195962106540972,0.17109457895414742,0.9779690135427012},
{0.7952248074248075,-0.29960934645934645,0.5271164436539437},
{-0.08829942164068239,0.1704988832359722,0.9813935718931561},
{0.796586338661437,-0.3094946922115425,0.5192910942341002},
{-0.09249690418042476,0.16899434385396525,0.9812671575378467},
{0.7942311106419178,-0.3439134713545146,0.5009196214058632},
{-0.08340218016148451,0.11000287551274936,0.9904258900711541},
{0.7709573518189135,-0.3691795775506392,0.5189712913022257},
{0.49177864743468247,-0.6841702939707397,0.5385766155110207},
{-0.053700178821893214,-0.07930026407031904,0.9954033146985569},
{-0.5377154487867686,-0.6371183046718436,0.5522158653897223},
{0.5178980035070447,-0.8000969156323353,-0.3026988330982476},
{-0.5106937465933592,-0.8429896776545951,-0.168997930633009},
{-0.17979796469855935,-0.4825945370607605,-0.8571902966607624},
{-0.12160078675963551,-0.28190182391070107,-0.9517061575587592},
{-0.8522355048707148,0.14720613273523728,-0.5020209146269642},
{-0.8843227760263986,-0.05340137537013422,-0.46381194563049155},
{-0.9158894764903722,0.1455983270848326,0.37409570166508155},
{-0.8583956179015559,0.35459818978086177,0.3706981075909911},
{-0.8544994958454463,0.3737997794581952,0.36069978718718837},
{-0.8716398827952767,0.34281568589057004,0.35031602907662396},
{-0.8941024990199771,0.2894008088763912,0.3418009553350052},
{-0.9973171789363621,0.07250124884476712,0.010100173976995143},
{-0.9734389139983961,-0.020700827532121224,-0.22800911484655262},
{-0.8753941305020324,0.20369863420523646,-0.43839706055756344},
{-0.854512360610695,0.25610370456688003,-0.45190653687533416},
{-0.8573378180052468,0.21430945339848873,-0.46802064484597633},
{-0.8747843065103105,0.14279743823693683,-0.4629916940035137},
{-0.9308156192171368,-0.09320156393536437,-0.3534059302012636},
{-0.8819008554442447,0.07940007701811205,0.4647004507596558},
{-0.8009717742520044,0.3607872860800539,0.47778316321798714},
{-0.7703710307420731,0.42878387588551525,0.4718822552014334},
{-0.7629735863116549,0.4349849410820051,0.4781834455756663},
{-0.7830599318484047,0.40127946705499273,0.47517568588221415},
{-0.9942556124490012,0.028398732166902984,0.1031953929445207},
{-0.9972834751497239,0.0468992228863151,-0.05679905884739228},
{-0.9053032138321137,0.22400079520423447,-0.3609012812018224},
{-0.9067437382965039,0.25808398638545177,-0.33347930825086464},
{-0.9145831489607191,0.2779948779915591,-0.2936945887270536},
{-0.9425396346249715,0.21910921373616046,-0.25221060567895787},
{-0.9761498727710323,-0.15750804729170945,-0.14940763343099298},
{-0.8232992302155796,0.018699982515524523,0.5672994695752439},
{-0.7047124382843045,0.43690771148916224,0.5590098666112193},
{-0.687907972899609,0.4760055169359121,0.5479063502713997},
{-0.718168167901421,0.4869784151601115,0.4970779675073746},
{-0.7190886492752561,0.45759277695502326,0.5229917446404658},
{-0.9120381011875324,0.16620694344009634,0.3749156624289538},
{-0.9626161817140231,0.19490327635161342,0.18810316204073108},
{-0.940219364017205,0.2959060942487672,-0.16860347242427223},
{-0.9530153007834821,0.27920448266395403,-0.11750188650793195},
{-0.9604938384517894,0.24069845592435782,-0.13969910383312334},
{-0.966413404246876,0.20430283369995528,-0.1559021623779884},
{-0.9966290172762632,-0.07100206725528264,0.041101196678762206},
{-0.5706154039707481,0.18580501587410617,0.799921594174906},
{-0.5651135007228004,0.5130122560091959,0.646115435882147},
{-0.5644048962337124,0.5395046802234015,0.6248054202105306},
{-0.5515895364457395,0.5416897242433957,0.6342879676713787},
{-0.5546843498018523,0.5452846150116282,0.628482267622975},
{-0.6054036294056375,0.48340289800906033,0.6323037906725876},
{-0.05770114393651793,0.2859056681360567,0.9565189631764194},
{-0.1937954487673279,0.24569422993876402,0.9497776947327556},
{-0.25000785412010773,0.13610427578298664,0.9586301158381411},
{-0.25930681726584004,0.5287139000711516,0.8082212484159349},
{-0.7085133945723379,0.43750827117205054,0.5537104679953471},
{-0.7760182366428441,0.5240123144340855,0.35100824879077097},
{-0.789717397665908,0.5179114097140354,0.32880724370336906},
{-0.8261259820707106,0.46171452115003886,0.32301015882924533},
{-0.6089801475707786,0.2787909115644221,0.7425757924237442},
{-0.06159854136381056,0.7927812271628085,0.6063856409580313},
{0.12999873901834724,0.705393157719555,0.6967932411383412},
{-0.39911350223817493,0.5057171086991858,0.7648258744970088},
{-0.6412311998630625,0.5950289518379946,0.4845235750680814},
{-0.3487969916389206,0.929091986616173,0.12299893913872487},
{-0.4156787552017186,0.724162988975426,-0.5502718763230833},
{-0.7450128255061875,0.20610354810312115,-0.6344109214780206},
{-0.5817085686303243,0.1158017057716891,-0.8051118593850337},
{-0.22618878923048583,-0.02899856272185716,-0.9736517421473212},
{-0.050802547049546086,0.01780089247011654,-0.9985500635624365},
{0.38410363747867043,-0.36400344712896654,-0.8485080354091432},
{0.7716822708034902,-0.4690892227989079,-0.42949013257755475},
{0.834219399997723,-0.5104118697660487,-0.20870485348780243},
{0.9273599018247489,-0.3495848842763988,-0.1333942321580995},
{0.9002421773340353,-0.4325202640490672,-0.049902337979302776},
{0.8402064948213076,-0.5315041085426386,-0.10750083098463528},
{0.7736034773554461,-0.5886026457748392,-0.23470105498361324},
{0.7779136252764711,-0.5690099662968402,-0.266604669621683},
{0.8013720285975041,-0.569680115662588,-0.18239363366132363},
{-0.6551019587577851,0.007600022724101918,-0.7555022589551315},
{-0.46942299055395736,-0.10800528968859692,-0.8763429199455323},
{-0.23310887462378863,-0.11150424504741498,-0.966036777720205},
{0.3520098564139713,-0.4620129365433374,-0.8140227929573086},
{0.7585018393691908,-0.6063014702828482,-0.23890057933460737},
{0.746500768896188,-0.6612006810370522,-0.07450007673511855},
{0.6977074969073316,-0.7099076279984444,-0.09610103261114314},
{-0.7036601669253936,0.2987830863682075,-0.6446635066318052},
{-0.7883995821483322,-0.2796998517591179,-0.5478997096132309},
{-0.8219230100567543,-0.15460432820875314,-0.5482153475034831},
{-0.4013119713146591,-0.16840502359678194,-0.9003268571507292},
{0.42089501242365407,-0.4982940952499568,-0.7579910178596574},
{0.7728936275183115,-0.6307947991183218,-0.06879943275101544},
{0.7465135194822579,-0.6653120489103096,0.008800159372329364},
{0.6366967719555493,-0.7709960910597274,-0.013499931555520518},
{0.6281298337349467,-0.7628362317672621,0.15340728625209493},
{-0.8554814619175782,0.2889937375735594,-0.4296906887036626},
{-0.8833117790411108,0.234003120452417,-0.4062054167853495},
{-0.9285883695035074,-0.3677953933915465,-0.04949938002414777},
{-0.9305602845345661,-0.3619845508290489,-0.05499765275026986},
{-0.7926649095011673,0.047897879607803596,-0.6077730944806478},
{-0.4791920406863058,-0.02729954655829747,-0.8772854284100502},
{-0.11600023896073841,-0.25180051870960285,-0.9608019792541159},
{0.5149603341331338,-0.5840550119750746,-0.6274516692593037},
{0.6229793890678634,-0.7510751510896825,-0.2185927679779052},
{0.687111175954166,-0.7195117029530235,0.10090164117854075},
{-0.7985662533031881,0.531977519105054,0.2815881003383143},
{-0.7977502478818441,0.5043317663367356,0.3305208185094014},
{-0.8895419784764699,-0.3121147290416034,0.3336157436984265},
{-0.9230223512568568,-0.2081050393245416,0.32360783625863365},
{-0.5483012473867567,0.698401588865422,0.4600010465035712},
{-0.6522822483801621,0.09749734664581605,0.7516795433195891},
{-0.6225221061524912,0.12330437861622837,0.7728274435897914},
{-0.30579931959727086,0.20799953720154457,0.9290979327593994},
{-0.22600794544898584,0.4405154865941516,0.8688305442746853},
{-0.8182448042209163,0.12890705849923748,-0.5602306762705418},
{-0.10709873302948233,-0.21059750864620896,-0.9716885049929784},
{0.7077888170250358,-0.46999257417599155,-0.527391667277485},
{-0.8154158599927168,0.17650343302515883,-0.5513107230978475},
{-0.10409807316249847,-0.2134960482247207,-0.9713820198852164},
{0.7137355663294274,-0.4812239799883991,-0.5089253603825775},
{0.7229163019464153,0.3868087226350442,0.5725129103116929},
{-0.2314075659940573,0.5961194904453654,-0.7688251371487954},
{0.05420031192369268,0.7186041355787004,-0.6933039899759436},
{-0.626179492957403,0.4844841334044423,-0.610879994007789},
{-0.6901945405827759,-0.14129888233026114,-0.7096943863396059},
{-0.9181468316564236,-0.3792780366448285,-0.11469335829992572},
{-0.8074046304788337,-0.5656032437439044,0.16790096291478349},
{-0.6102942541066462,-0.6756936383743419,0.41349610695247946},
{0.05739899724827703,-0.3612936882543988,-0.9306837410970632},
{0.6185777408804845,0.579979129826513,-0.5300809253810941},
{0.5981926063850773,-0.5151936322460579,-0.6137924135726521},
{0.6780671620024971,0.4609776753917581,-0.5724722758390054},
{0.2414044165342011,0.5041092227625964,-0.8292151706303212},
{0.7069028452896784,-0.6865027631791827,-0.17030068546163848},
{0.4347029146928145,-0.6659044649044059,-0.6063040652823866},
{-0.0963052251817422,-0.592432143277924,-0.7998433966807623},
{-0.6136098761304352,-0.3459055673949112,-0.7098114245068169},
{-0.8801254095873675,-0.42601229915261735,-0.20950604852693272},
{-0.8837035613325283,-0.4615018598562428,0.07800031434190019},
{-0.7592002884961644,-0.650800247304141,-0.008600003268001862},
{-0.2999864619164537,-0.7574658163390455,0.579873830884505},
{-0.609898944875738,-0.7270987421202642,0.315199454705415},
{0.07679985216042687,-0.8155984299745334,0.5734988960156877},
{-0.4263079848233343,-0.7453139598612035,0.5126096012677485},
{0.26999133341729376,-0.8801717469403775,0.3903874687633758},
{-0.10820215973666274,-0.8160162878476598,0.5678113336273299},
{0.40798468250263775,-0.898466267717206,0.1621939105439408},
{0.1202004483485085,-0.8435031462726034,0.5235019526659251},
{0.4864254017977401,-0.8668452678418609,-0.10940571331552788},
{0.7100377714639062,0.6844364095632358,-0.16550880447503732},
{0.8718943021893527,0.4464970821511022,-0.20109868582438217},
{0.5832738290904199,0.4250809270466955,-0.6921689430762706},
{0.05229897155083658,0.304794006284799,-0.9509812991366269},
{-0.5887174881127304,0.33791003776676,-0.7343218133534533},
{-0.7694503852608943,0.5852383226600928,-0.25581675142934335},
{-0.8004910865813761,0.5970933514025479,0.05189942210315231},
{-0.5532935956636951,0.831490375554604,-0.049899422417528254},
{-0.31118355593946806,0.7178620655814401,0.6227670907426116},
{-0.6127972148429878,0.6674969662331827,0.4229980774781068},
{0.02259968631853083,0.3331953752802864,0.9425869169843877},
{-0.2230099843805061,0.4161186300481102,0.8815394674054533},
{0.5537758752794787,0.4462805582109631,0.7029693758061999},
{0.18679854671295984,0.6433949944064152,0.7423942241954036},
{0.7237279762456431,0.6438248875320506,0.24840960245877816},
{0.38960143957997884,0.7589028041510419,0.5218019280616862},
{-0.3240068868395704,-0.4730100539355457,0.8193174147767286},
{-0.8975582264907899,-0.4401285520652887,0.026001686784134302},
{-0.7975177928204389,0.5993133708304565,-0.06920154390366692},
{-0.23890929255765456,0.5400210045254645,0.8070313900963886},
{-0.6994777954298205,0.6167804206163163,0.36098854060066504},
{-0.8118231616452073,-0.4321123283405939,0.3927112042104865},
{0.1287012657831735,-0.5108050237921137,0.8500083598733291},
{0.24340588319129597,0.5269127356347324,0.8143196823445863},
{0.7626722277964779,-0.6414766410534162,-0.08269698864398678},
{0.30460176669537026,-0.56500327702851,0.7668044474786931},
{0.8658331403976852,0.42951644005637074,0.2566098219289051},
{0.7479961927090686,-0.6146968712008883,0.2502987259827271},
{0.4357157426941804,0.5046182321860994,0.7453269291484339},
{0.9247368191294452,0.35921430240218094,-0.12580500902615355},
{0.013999944420330979,0.5244979177473998,0.8512966203591258},
{-0.08910088834028515,-0.46990468497306387,0.878208755784943},
{0.6516983121035573,0.4626988016116557,0.6009984434160472},
{0.506024552906975,-0.6010291626424742,0.61863001665663},
{-0.3721899193725488,0.5697845675939772,0.7326801556267236},
{-0.5138905162380335,-0.47569122119951845,0.7138868253402064},
{0.7979662547206167,0.5646761203517947,0.2106910900621979},
{0.6321741288031573,0.7689685306068142,0.09509610827140186},
{0.6563256989358727,-0.7540295246040651,-0.02600101808979535},
{0.7870047613932097,0.6169037322788704,-0.007300044165400801},
{0.6888034991306633,0.6502033030411691,-0.32060162866041036},
{0.535995235023541,0.6592941389011577,-0.5272953123655095},
{0.3738923408938444,0.6489867056435009,-0.6625864270560611},
{-0.6563256989358727,-0.7540295246040651,-0.02600101808979535},
{-0.6321741288031573,0.7689685306068142,0.09509610827140186},
{-0.7979662547206167,0.5646761203517947,0.2106910900621979},
{-0.7870047613932097,0.6169037322788704,-0.007300044165400801},
{-0.6888034991306633,0.6502033030411691,-0.32060162866041036},
{-0.535995235023541,0.6592941389011577,-0.5272953123655095},
{-0.3738923408938444,0.6489867056435009,-0.6625864270560611},
{-0.20670073482241846,0.24200086031458765,-0.9480033701579714},
{0.22880354648245593,0.24160374488706884,-0.9430146168398423},
{0.49821574884873554,0.5177163652729635,-0.695521985797462},
{-0.49970349044107115,0.516303606393286,-0.695504858118401},
{0.21209201382557627,-0.192692744291318,-0.9580639247821057},
{-0.22110934538397814,-0.19010803508590796,-0.9565404290356179},
{-0.4847869448633599,-0.4788871037439419,-0.7318802907291524},
{0.48689420112459675,-0.4774943130765967,-0.7313912891816186},
{-0.22049785566878038,0.2311977516127983,-0.9475907847244276},
{0.21259230004633597,0.23619144530077402,-0.9481656580617863},
{0.48411606565821275,0.5101169285111636,-0.7109235923908768},
{-0.4870040762411773,0.5085042561984366,-0.7101059436116222},
{0.604191305749665,0.015499776959814313,-0.7966885357344556},
{-0.6043191270030592,0.01860058871794953,-0.7965252104218711},
{0.5000106978433217,-0.4864104068619834,-0.7165153300094801},
{-0.49770395427362507,-0.4879038764116972,-0.7171056974273992},
{-0.5682840371255925,0.015999550578936265,-0.8226768913306791},
{-0.22229016276651534,-0.19609132217055178,-0.9550577348551452},
{0.22879261926915168,-0.19779361928076136,-0.9531692512559239},
{0.594001871108841,0.01610005071523963,-0.8043025335569711},
{0.5893946542147294,0.01569985760293731,-0.8076926742606665},
{-0.5892967618231907,0.018899896145356018,-0.8076955617250824},
{-0.5788182793698983,0.019400612681022854,-0.8152257452355582},
{0.5618039607318848,0.016500116326230153,-0.8271058311166641},
{0.14340364536699843,0.6424163304306819,0.7528191369056934},
{0.09340040722666326,0.6474028226824604,0.7564032979255685},
{0.0,0.6685060366367663,0.7437067157019643},
{-0.09340040722666326,0.6474028226824604,0.7564032979255685},
{-0.14340364536699843,0.6424163304306819,0.7528191369056934},
{0.31968655906118043,0.6131742196318919,0.7223696286074344},
{0.17709712219514628,0.5484910870922515,0.817186720823679},
{0.10360184361121073,0.572810193248084,0.8131144695007283},
{-0.0,0.5810016820023041,0.813902356250732},
{-0.10360184361121073,0.572810193248084,0.8131144695007283},
{-0.17709712219514628,0.5484910870922515,0.817186720823679},
{-0.31968655906118043,0.6131742196318919,0.7223696286074344},
{-0.5040949767185853,0.4925950913143724,0.7093929309346646},
{-0.6805289435114644,0.5390229251325193,0.49632110898565734},
{-0.6207173461886123,0.7021196210069673,0.3489097504192151},
{0.5040949767185853,0.4925950913143724,0.7093929309346646},
{0.43688201612195193,0.5105789824487724,0.7405695150833546},
{0.20760339641934836,0.404606619418441,0.8906145705735629},
{0.12050529873448058,0.4366191985682508,0.8915392018405762},
{-0.0,0.36750803932629134,0.9300203444175537},
{-0.12050529873448058,0.4366191985682508,0.8915392018405762},
{-0.20760339641934836,0.404606619418441,0.8906145705735629},
{-0.43688201612195193,0.5105789824487724,0.7405695150833546},
{-0.5791865369654207,0.4012906721067391,0.709583505923105},
{-0.6982753268772296,0.4462842308253008,0.5596802240486687},
{-0.03809887800456391,0.07479779723730656,0.9964706543713369},
{0.0,0.029199229150525502,0.9995736116049758},
{0.03809887800456391,0.07479779723730656,0.9964706543713369},
{-0.2060999474445201,0.09089997682050885,0.9742997515535949},
{-0.5374932410649902,0.33029584655584415,0.7758902432415365},
{-0.8931542538106497,0.08739552371590997,0.4411774034720764},
{-0.7034972352612981,0.3439986480879695,0.6218975559474077},
{0.2060999474445201,0.09089997682050885,0.9742997515535949},
{0.043500530492204044,0.04560055610217252,0.9980121708326354},
{0.0,0.21429327879671414,0.9767693641093346},
{-0.043500530492204044,0.04560055610217252,0.9980121708326354},
{-0.2577050781285973,-0.053901062130894045,0.9647190099753893},
{-0.4186939101413652,0.05619918258883382,0.906386816699626},
{-0.655206938678221,-0.06430068094781687,0.752707971219623},
{-0.9643072612610161,0.26220197438830073,-0.036900277860138435},
{0.6805289435114644,0.5390229251325193,0.49632110898565734},
{0.6982753268772296,0.4462842308253008,0.5596802240486687},
{0.5791865369654207,0.4012906721067391,0.709583505923105},
{0.5374932410649902,0.33029584655584415,0.7758902432415365},
{0.4186939101413652,0.05619918258883382,0.906386816699626},
{0.2577050781285973,-0.053901062130894045,0.9647190099753893},
{0.14179480118891988,0.07349730527070246,0.9871638063025506},
{-0.0,0.12690195303608595,0.9919152656934094},
{-0.14179480118891988,0.07349730527070246,0.9871638063025506},
{-0.33119260123993155,0.057998704323417964,0.9417789608930178},
{0.6207173461886123,0.7021196210069673,0.3489097504192151},
{0.7034972352612981,0.3439986480879695,0.6218975559474077},
{0.8931542538106497,0.08739552371590997,0.4411774034720764},
{0.655206938678221,-0.06430068094781687,0.752707971219623},
{0.33119260123993155,0.057998704323417964,0.9417789608930178},
{-0.65917843203455,-0.04919839025500586,0.7503754481169999},
{-0.9295779878538684,-0.13039691223767688,0.34479183542600456},
{0.65917843203455,-0.04919839025500586,0.7503754481169999},
{0.9373065846018854,-0.12710089288690882,0.32450227963652173},
{0.9295779878538684,-0.13039691223767688,0.34479183542600456},
{0.9643072612610161,0.26220197438830073,-0.036900277860138435},
{-0.9373065846018854,-0.12710089288690882,0.32450227963652173},
{-0.1376986161358617,0.7940920194153072,0.5919940504896887},
{0.3571905524348305,0.7808793460144433,0.5124864449127956},
{0.3570974806861606,-0.8146942523523244,0.45689677660461153},
{-0.0779010462180761,-0.8267111028046664,0.5572074833467524},
{-0.23779953391337025,0.5317989576750644,0.8127984069166835},
{-0.25590847199020017,-0.5623186158659225,0.7863260317541789},
{0.6925905600549993,0.5446925758907856,0.4728935545047779},
{0.7142018069328573,-0.5643014276844182,0.414101047676976},
{0.5165001162125392,-0.7737001740825588,0.3669000825525279},
{0.6482981815261512,0.48539863845872866,0.586598354593923},
{0.12779845875988097,0.8117902098691031,0.5697931283363081},
{0.8169989624119766,0.5644992830863657,0.11769985052128475},
{0.06580157267638068,0.5200124284455616,0.8516203539696927},
{0.1577066577270869,-0.7882332759701325,0.5948251110721071},
{0.11320106749109968,-0.5727054006373921,0.8119076563252988},
{0.8275857449583135,-0.5589903714737763,0.05129911638033045},
{-0.2126073393320328,-0.8072278659869091,0.5506190076962242},
{0.0,-0.588611619308049,0.8084159582885265},
{0.6141803526847714,-0.5452825566900128,0.5704817505806937},
{-0.40758910732665815,-0.5512852670981027,0.7279805449798997},
{-0.24729625719947065,0.7586885173361845,0.6026908783425838},
{0.0,0.447093593194714,0.8944871820905204},
{0.24729625719947065,0.7586885173361845,0.6026908783425838},
{0.2126073393320328,-0.8072278659869091,0.5506190076962242},
{-0.4056024478181589,0.5259031738352312,0.7476045118068432},
{0.6125260267838288,0.4914208809168547,0.6191263072357035},
{0.22889908669446615,0.6485974121014886,0.7258971036763345},
{0.1376986161358617,0.7940920194153072,0.5919940504896887},
{0.0779010462180761,-0.8267111028046664,0.5572074833467524},
{-0.3570974806861606,-0.8146942523523244,0.45689677660461153},
{-0.3571905524348305,0.7808793460144433,0.5124864449127956},
{0.23779953391337025,0.5317989576750644,0.8127984069166835},
{0.25590847199020017,-0.5623186158659225,0.7863260317541789},
{-0.6925905600549993,0.5446925758907856,0.4728935545047779},
{-0.7142018069328573,-0.5643014276844182,0.414101047676976},
{-0.5165001162125392,-0.7737001740825588,0.3669000825525279},
{-0.6482981815261512,0.48539863845872866,0.586598354593923},
{-0.12779845875988097,0.8117902098691031,0.5697931283363081},
{-0.8169989624119766,0.5644992830863657,0.11769985052128475},
{-0.06580157267638068,0.5200124284455616,0.8516203539696927},
{-0.11320106749109968,-0.5727054006373921,0.8119076563252988},
{-0.1577066577270869,-0.7882332759701325,0.5948251110721071},
{-0.8275857449583135,-0.5589903714737763,0.05129911638033045},
{0.40758910732665815,-0.5512852670981027,0.7279805449798997},
{-0.6141803526847714,-0.5452825566900128,0.5704817505806937},
{0.4056024478181589,0.5259031738352312,0.7476045118068432},
{-0.6125260267838288,0.4914208809168547,0.6191263072357035},
{-0.21399691311679225,0.6616904551840254,0.7185896344192847},
{0.8588783307730684,-0.25059367760127016,0.4466887301855043},
{0.5640342238148264,-0.8212498308452757,-0.08610522459300808},
{0.8412947250986104,-0.42179735533887297,0.3380978801329373},
{0.8496120900660631,0.010300146572128589,0.5273075036391656},
{0.9604558536612563,-0.0647970216733466,0.2707875535361459},
{0.8096299244750231,0.09240341529334503,0.5796214232037098},
{0.9437010097606207,0.2084002229883579,0.2569002748834412},
{0.8110222344793416,0.3564097711078142,0.4639127183415124},
{0.7161154754226376,0.13340288286744847,0.6851148054909217},
{0.7462811752947768,0.27759299780494445,0.6049847394524185},
{0.7002895342511154,0.08819868188054887,0.7083894131993291},
{0.7999862523543789,-0.36609370873367264,0.4753918304615896},
{0.8059693213616624,-0.01819930725655367,0.5916774782254288},
{0.7777291731684385,-0.4988187110407833,0.3825143483823168},
{0.6304113443542133,-0.5784104085889546,0.51770931626297},
{0.8245769740094967,-0.2637926336935547,0.5004860241229118},
{0.6348063417470312,-0.2847028441956203,0.7183071759245314},
{0.8173207234296672,0.07700195240925532,0.5710144782556466},
{0.6251938074860052,0.054099464147461425,0.7785922880815797},
{0.7975292499216211,0.17340635979487035,0.5778211919808309},
{0.5964098468078569,0.3761062095647803,0.7091117075309378},
{0.8954336286413973,0.33931274312935683,0.2882108239607446},
{0.7476966578034093,0.5792974105463623,0.3245985490477286},
{0.8360851428990149,0.5471902765151788,0.03929930165761427},
{0.6428982738204522,0.7635979497422574,-0.05999983890064882},
{0.7113671320409786,0.6136716459566327,-0.34258417126404167},
{0.5939950431320474,0.7014941460557765,-0.39379671378013514},
{0.5668019668062372,0.409101419584389,-0.7151024814099157},
{0.7963648810830993,0.27598782920509224,-0.5381762669499298},
{0.803684834610255,0.03209939429014456,-0.5941887877633613},
{0.6084970700936613,0.044699784771054484,-0.792296185103053},
{0.6751970662751207,-0.2448989359164352,-0.6957969767687039},
{0.7966257792273305,-0.15740509371125008,-0.5836188862127417},
{0.757598526472299,0.14979970863985,-0.6352987643451049},
{0.7920129693185598,0.47900784381766426,-0.378506198089741},
{0.578208545985465,0.753211132542809,-0.31360463511076064},
{0.4854109364315981,0.8043181214914181,-0.34270772129194205},
{0.5420248442781193,0.7127326688505823,-0.4452204071450529},
{0.5820111368896576,0.6203118697811935,-0.5258100614717903},
{0.6737147882019033,0.40210882638560985,-0.6200136094480927},
{0.6562818409326886,0.36258996727440634,-0.6616816915208898},
{0.7288294270821897,0.17660713065685332,-0.661526709680116},
{0.7977193249847244,0.09490229903604155,-0.5955144265117255},
{0.7936216820405341,-0.29980819087166344,-0.5294144638007292},
{0.7633932516334833,-0.02639976662709452,-0.6453942947396516},
{0.5378204859724734,-0.8147310336961214,-0.2167082545746281},
{-0.8412370488954679,-0.4218185772992254,0.3382148953119915},
{-0.5639927555595818,-0.82128945060476,-0.08599889535128376},
{-0.8585861382386963,-0.25069595254651894,0.4471927801308467},
{-0.8495376948237976,0.01050046591600927,0.5274234022955513},
{-0.9604818566690896,-0.06479877596268298,0.2706948866218871},
{-0.8095015987672364,0.09240018249054062,0.5798011451083923},
{-0.9438239545559538,0.2082052843171748,0.25660651275594165},
{-0.8110853559860953,0.3562935671777164,0.46389162451232846},
{-0.7159972434159193,0.1330994875679593,0.6852973616102367},
{-0.7459920253878728,0.2776970314346009,0.6052935294467552},
{-0.7002957072004722,0.08809945995196573,0.7083956575479288},
{-0.7999775009491743,-0.36598970668424724,0.47548662712666545},
{-0.8059342771137239,-0.018200774095383766,0.5917251666065151},
{-0.7777479626246729,-0.4986666353316076,0.3826743961127055},
{-0.6304113443542133,-0.5784104085889546,0.51770931626297},
{-0.8245769740094967,-0.2637926336935547,0.5004860241229118},
{-0.6348063417470312,-0.2847028441956203,0.7183071759245314},
{-0.8173207234296672,0.07700195240925532,0.5710144782556466},
{-0.6251938074860052,0.054099464147461425,0.7785922880815797},
{-0.7975292499216211,0.17340635979487035,0.5778211919808309},
{-0.5964098468078569,0.3761062095647803,0.7091117075309378},
{-0.8954336286413973,0.33931274312935683,0.2882108239607446},
{-0.7476966578034093,0.5792974105463623,0.3245985490477286},
{-0.8360851428990149,0.5471902765151788,0.03929930165761427},
{-0.6428982738204522,0.7635979497422574,-0.05999983890064882},
{-0.7113671320409786,0.6136716459566327,-0.34258417126404167},
{-0.5939950431320474,0.7014941460557765,-0.39379671378013514},
{-0.5668019668062372,0.409101419584389,-0.7151024814099157},
{-0.7963648810830993,0.27598782920509224,-0.5381762669499298},
{-0.803684834610255,0.03209939429014456,-0.5941887877633613},
{-0.6084997870251119,0.044599984390008195,-0.7922997226951456},
{-0.6751970662751207,-0.2448989359164352,-0.6957969767687039},
{-0.7966257792273305,-0.15740509371125008,-0.5836188862127417},
{-0.757598526472299,0.14979970863985,-0.6352987643451049},
{-0.7917945801846479,0.47929671922518535,-0.3785974085096081},
{-0.5780984217934627,0.7532979434994214,-0.31359914387550586},
{-0.4854109364315981,0.8043181214914181,-0.34270772129194205},
{-0.5421805658859176,0.7125744582263092,-0.4452840390796737},
{-0.5819198874519863,0.6202211964215878,-0.5260179769715498},
{-0.6737840685640459,0.4021904903182833,-0.6198853429843457},
{-0.655923754708923,0.3626131322723821,-0.6620239756324242},
{-0.7289245177884907,0.17660594024070167,-0.6614222473114387},
{-0.7978183141296037,0.09470217391335356,-0.5954136678776211},
{-0.7936034521825255,-0.29970130370350667,-0.5295023033400292},
{-0.7634323473138481,-0.026901139825442122,-0.645327343098803},
{-0.5377883193645537,-0.8147823031205622,-0.21659529560126875},
{-0.9273599018247489,-0.3495848842763988,-0.1333942321580995},
{-0.9002032362364515,-0.43260155520538646,-0.04990017939146737},
{-0.6977074969073316,-0.7099076279984444,-0.09610103261114314},
{-0.8402064948213076,-0.5315041085426386,-0.10750083098463528},
{-0.6366967719555493,-0.7709960910597274,-0.013499931555520518},
{-0.6281298337349467,-0.7628362317672621,0.15340728625209493},
{-0.7083339902220508,-0.5017240758074303,-0.4965238262674688},
{-0.7171645944579359,-0.5030751637922303,-0.48227619061218974},
{-0.7736034773554461,-0.5886026457748392,-0.23470105498361324},
{-0.7779136252764711,-0.5690099662968402,-0.266604669621683},
{-0.8013720285975041,-0.569680115662588,-0.18239363366132363},
{-0.25939387059525587,0.030899269858879745,0.9652771907694699},
{-0.16569868684311012,-0.27999778102637807,0.9455925062090824},
{-0.1283068139142842,-0.7381391999230955,0.6623351742434171},
{0.3125991231606893,-0.6770981007424911,0.6661981313168625},
{0.30070679304318315,-0.15630353093664623,0.9408212533921739},
{0.7083339902220508,-0.5017240758074303,-0.4965238262674688},
{0.7171645944579359,-0.5030751637922303,-0.48227619061218974},
{-0.10970052766080708,-0.24020115537033598,-0.9645046392784724},
{-0.8325667312981126,0.18539259186004095,-0.5219791421302123},
{-0.33098480649117906,0.018399155406156175,-0.9434566916145843},
{-0.25818903752619504,-0.1381941324017047,-0.9561594023336473},
{-0.1534076084390155,-0.2491123550336294,-0.9562474262671877},
{0.000999971001261439,-0.28819164256354673,-0.9575722308079541},
{0.14830412068724072,-0.24650684928796254,-0.9577266108035769},
{0.26280064517637586,-0.13540033240822408,-0.9553023452701366},
{0.31000675047048804,0.0147003201029554,-0.9506206999911159},
{0.27040311235773495,0.17390200162355812,-0.9469108990071717},
{0.1632048072683982,0.2954087013914511,-0.9413277272165638},
{-0.0003999978680170452,0.33869819474343305,-0.9408949850430945},
{-0.16100351313498534,0.2944064240182589,-0.9420205551127713},
{-0.2804106642203443,0.17530666703932368,-0.9437358909584127},
{-0.0,0.4381911376738599,0.8988818202990249},
{-0.0,0.26388728489750846,0.9645535241081343},
{0.23249987561259983,0.4268997716086833,0.8738995324638752},
{-0.0,0.6945980829119368,0.7193980144642202},
{0.2123919016511821,0.6914736346129586,0.690473672740778},
{0.4925339219793503,0.389926855187307,0.7780535863958062},
{0.5111801231473596,0.26478970385254463,0.8176682055899764},
{0.24790094574391203,0.2536009674895364,0.9350035670454124},
{0.22600446928257054,-0.41390818511529176,0.8818174381122598},
{-0.0,-0.30130844579410504,0.9535267277287726},
{0.25470061510272823,-0.6442015557486358,0.7212017417043093},
{0.0,-0.5064737805310552,0.8622553621953187},
{-0.0,-0.2949079242823896,0.9555256753198484},
{0.32289470295584666,-0.28219537062291705,0.9033851800876799},
{-0.0,0.24469972471296453,0.9695989092018407},
{0.4125134584711275,0.020100655794593122,0.9107297130415899},
{0.5359196498541995,0.5681208305321342,0.6245228985518708},
{0.5008723801541236,0.5161715365054075,0.6947616884230087},
{-0.0,0.6107927071786142,0.7917905460773194},
{-0.0,0.20420583526511524,0.9789279732665099},
{0.5202977887390968,0.1419993965038473,0.8420964210978155},
{0.0,-0.11870355522471927,0.9929297386910174},
{0.4043889583102379,-0.2605928846084273,0.876676062686908},
{0.0,-0.21279912220543135,0.9770959694874388},
{0.39548788639155685,-0.2789914546226154,0.8750731969184612},
{-0.0,0.7946160633260818,0.6071122728986462},
{0.44140042815862296,0.7203006986920166,0.5351005190477552},
{0.0,0.7031960480493149,0.7109960042136844},
{0.47339307904377625,0.6317907632865607,0.6137910264407898},
{0.500499824825092,-0.3092998917450569,0.8085997169901487},
{9.999547730683981e-05,-0.2518886073359295,0.9677562293755957},
{0.0,-0.6075094954476213,0.7943124152000751},
{0.3456020926270063,-0.4958030020962666,0.7967048240623146},
{0.655490728149225,0.024999646382502863,0.7547893235805264},
{0.0,0.01330015361766143,0.9999115490450875},
{0.5958646215883586,-0.07629547009094105,0.7994525339149064},
{0.0,-0.23179176226715092,0.972765428530994},
{0.4572746791156965,-0.5988668386669378,0.6574635939614487},
{0.0001000057069885086,-0.6635378658687545,0.7481426939810328},
{0.0,-0.9638652195510675,0.2663903874762988},
{0.4805851837871723,-0.8586735275032144,0.17809450943091007},
{0.00019999043968554079,-0.9878527768267287,-0.1553925716356652},
{0.5463969811650186,-0.8374953728508475,-0.007199960220329674},
{0.0,-0.9986261044275591,0.05240136978970969},
{-0.4174037545636585,-0.8745078662336354,0.2470022217949776},
{-0.0,-0.9032077314912724,-0.42920367399917425},
{-0.5032095761693527,-0.7311139132301544,-0.4607087673712654},
{-0.2113959940838678,-0.6836870442532659,-0.6984867638012378},
{-0.16259475477781496,-0.4175865288758643,-0.893971160955514},
{0.029198652659258844,-0.7481654767005982,-0.6628694125966674},
{-0.02330100464447334,-0.9112392889289316,-0.4112177300346539},
{-0.04419924729322785,-0.9640835817964019,-0.2618955399569315},
{-0.026499803107194367,-0.9924926258071853,-0.11939911286788708},
{0.006100238340968064,-0.9999390683826175,-0.009200359465066588},
{0.07769671000247097,-0.9953578524640874,0.05679759495676127},
{0.07969768162816164,-0.9939710858016648,0.07529780961857682},
{0.05490131462771833,-0.9909237279527522,0.12270293815703168},
{-0.0,-0.9930134057714675,0.11800159303225896},
{-0.0,-0.8501095340318865,-0.5266059059183524},
{0.17369772544317788,-0.838489020058173,-0.5164932365653504},
{0.0,-0.5077148407216946,-0.861525182749143},
{0.2421031655195839,-0.4700061453705263,-0.8488110982776655},
{0.23430363290599254,0.009700150401997985,-0.9721150727610557},
{0.0,-0.018400564906014053,-0.9998306952735245},
{-0.0,0.4492923508628392,-0.8933847902534177},
{0.14380449180345334,0.46971467176691256,-0.8710272069597208},
{-0.0,0.39079122878930356,-0.9204793400730654},
{0.13369636283992276,0.3915893469567221,-0.9103752335786511},
{-0.0,0.0663995418447419,-0.9977931152512569},
{0.1948062085728024,0.057901845361217966,-0.9791312054087825},
{0.0,0.13300211408540524,-0.9911157539101136},
{0.21360627904886034,0.14480425658368434,-0.9661283997617226},
{0.24189869133161987,0.24639866698681742,-0.9384949227562019},
{0.0,0.2592059255151867,-0.96582207894509},
{0.26010122507965516,0.4551021435361441,-0.8516040110643381},
{-0.0,0.5294324949165938,-0.8483520692061703},
{0.21728707832166688,0.8037522022777535,-0.55386706250516},
{-0.0,0.8314343722074353,-0.555622969928375},
{0.1948025431638016,0.9557124769078296,-0.2206028799893975},
{0.0,0.9753660968636992,-0.22059233234378925},
{0.19449146006747856,0.9805569446898172,-0.026098854024479128},
{-0.0,0.9997331417029803,-0.023100765803079768},
{0.18900120488652172,0.9704061863591571,0.1503009581716625},
{-0.0,0.9902649798982179,0.13919507745312726},
{0.0,0.9145851289667034,0.4043934246163731},
{0.19140460429313505,0.8948215251906858,0.4033097017315641},
{0.48939816720729573,0.24919906675124254,-0.835696870321081},
{0.5217954708349697,0.4353962207772054,-0.7335936324349056},
{0.5239940972397417,0.703792071826966,-0.4796945962708093},
{0.5647888624734468,0.8005842126349887,-0.20019605217277633},
{0.5537847462092457,0.8323770724893033,-0.021699402298195433},
{0.5075023091407599,0.8477038570613246,0.15440070252479476},
{0.4678123691225615,0.7932209730397944,0.38981030672076633},
{0.45659984019008387,0.6132997853451126,0.6444997744251183},
{0.7628814240634834,0.30979245664551996,0.5674861818797048},
{0.786378076084854,0.2577928128365658,0.5613843488225293},
{0.7126032779826181,-0.40480186209284846,0.5730026358181871},
{0.43250400716818965,-0.4329040108742412,0.7909073277903381},
{0.3716053808848731,-0.710810292607556,0.5972086476438272},
{0.5084148255924745,-0.2166063163322777,0.8334243030070188},
{0.43699746542205076,-0.21739873909096988,0.872794937804041},
{0.5485135566800821,0.06740166585275759,0.8334205982446315},
{0.5353965815037407,0.20439869491849944,0.8194947675426139},
{0.5231064708670672,-0.02790034512940389,0.8518105369615137},
{0.6376173274863148,0.11500312525239369,0.7617207000412893},
{0.4402156191272548,-0.24140856532784943,0.8648306847370514},
{0.46869357659854877,-0.20439719875558646,0.8593882221651223},
{0.627006583603692,0.6162064702019059,0.47660500437881914},
{0.6203854056049976,0.6366850221610284,0.4579892259301885},
{0.5025028089985535,-0.37210208005644135,0.7804043624725795},
{0.29039405714643013,-0.5233892889478013,0.8010836059917534},
{0.46139132361773827,-0.1442972865150404,0.8753835385673344},
{0.8577169786756411,-0.03940077994615863,0.5126101472182972},
{0.8398103549255147,-0.39510487167310177,0.37230459054390225},
{0.7764891835810085,-0.6255912855740876,0.07549894830697508},
{0.015899606887079514,-0.9007777285459891,0.43398926974795654},
{-0.7757020400990482,-0.36050094811874034,0.5180013623453745},
{-0.783389404729951,-0.6156916728264371,0.0849988503983225},
{-0.45651286927918,-0.7649215634428144,-0.45441281007767664},
{-0.10510508405587664,-0.9850476479071217,-0.13650660298408338},
{0.14179902938896574,-0.9752933241400443,-0.16939884046890546},
{0.14239570469835067,-0.8150754136209666,-0.561583060102484},
{0.4969026484981748,-0.8017042730951635,-0.33220177064015627},
{0.6298065216802982,-0.7135073884072606,-0.3070031790343784},
{0.6214227942061449,-0.7708282744996725,-0.14020514281895963},
{0.6180811179102673,-0.7789762026405085,-0.10569677101296758},
{0.5520162019132928,-0.7787228558512338,-0.2981087496202039},
{0.4832012708210134,-0.7885020737631809,-0.3805010007189478},
{0.34051164910277715,-0.8162279236349095,-0.4667159666263321},
{0.7200775267310806,0.47958503238470535,0.5014843489177016},
{0.9151733322376422,0.2767919344005456,0.2929914623531787},
{0.9371240562832912,0.20240519580806543,0.2843072982620208},
{0.8619175272711274,-0.39460802443576615,0.31840647486150014},
{0.5324955882923265,-0.6855943198745897,0.49639588737710966},
{0.7829831582133984,0.550888150523322,0.28889378596149523},
{0.9569178993167117,0.25530477552048964,0.13830258697408426},
{0.9807580538750346,0.15469338390545254,0.11909490641977633},
{0.9776428119161212,-0.12710556607461027,0.16750733530682316},
{0.8997637717410815,-0.33678643956701065,0.27748882713730844},
{0.7257033309859339,-0.5652025942858617,0.3923018006693976},
{0.7723047458272447,-0.13790084740331096,0.6201038105496238},
{0.830372523427792,0.5408821025073371,0.13389556946890818},
{0.8514768529163759,0.52438574476729,-0.0025999293218820635},
{0.9665443315724247,0.25611174683465904,0.014100646740994503},
{0.9873178409945815,0.1576028479091928,0.019100345146355217},
{0.9572752882573964,-0.1984948759209163,0.2102945713157113},
{0.9394232369211514,0.033600831126837004,0.3411084374215507},
{0.887399995563,-0.034599999827,0.4596999977015},
{0.8337025261224812,-0.04470013544161558,0.5504016677195798},
{0.6262120578292614,-0.1409027131078616,0.7668147651604561},
{0.6064191358577528,0.15280482183223057,0.7803246235319994},
{0.5084804289649264,0.04919810640132622,0.8596669120573202},
{0.47041020566011893,-0.12660274667638405,0.8733189468600805},
{0.5692993794640147,0.14799983868026376,0.8086991185184412},
{0.34409779606067437,-0.27159826041871304,0.8987942432413081},
{0.3840908856314247,-0.16529607757061832,0.9083784444352673},
{0.5882708371961011,0.6398682793163099,0.49447548698533395},
{0.611774841276968,0.6025752196036301,0.5124789247375713},
{0.6192632756803713,0.12259272985372764,0.77555400713337},
{0.3565927291483782,-0.283894211456042,0.8900818514160725},
{0.014799844898438195,-0.4603951750838476,0.8875906980982257},
{0.1148959339048474,-0.21709231723883696,0.9693656947550833},
{0.5641926175878981,-0.7181906025374483,0.4072946705841029},
{0.28641063032782055,-0.8584318612898086,0.4255157933117586},
{-0.6802281144089648,-0.38471590063676675,0.6239257873857},
{-0.4891088896348544,-0.21220385684014742,0.8460153764692022},
{-0.44220811680447664,-0.43670801584919705,0.7834143797029104},
{-0.5378974557510515,-0.762796391981599,0.3588983024150444},
{-0.5034898673683778,-0.8631826286243967,-0.03759924332284212},
{-0.14289778438702952,-0.9367854752538085,0.3193950478181751},
{0.21239146522045171,-0.8989638758624581,0.3830846060544023},
{0.40968831995249483,-0.9121739942901288,-0.00969972346482597},
{0.7317770811007241,-0.6113808518515753,0.3011905668591666},
{0.8830097838026072,-0.45300501932342135,0.122801360646614},
{0.9743118769341702,-0.07680093620911861,-0.21170258067018763},
{0.9967591087963253,-0.02909880624596014,-0.07499692331433025},
{0.9191876278177937,-0.37779491491466766,0.11119850327821873},
{0.9417684089085758,-0.32308916215583017,0.09319687376330354},
{0.9724018038070192,0.10020018587151719,0.21070039084958755},
{0.8545133561481358,0.4515070571104544,0.2568040138781056},
{0.6359072907188824,0.7045080772314084,0.31510361268362924},
{0.8931789524859741,0.3674913401686022,0.25919389216789573},
{0.9924381450931741,-0.0696026752302347,0.1011038860025392},
{0.9824820551291432,0.07679859728643072,0.16979689868796796},
{0.9841053830711681,0.0355001941865933,0.17400095178780942},
{0.8518264922158683,0.4960154263196415,-0.1684052374843299},
{0.9563366379584137,0.2637101029275684,-0.12600482733740473},
{0.9863080828278583,0.12340101127543111,-0.10940089654402078},
{0.9910206233537602,0.06770140888097836,-0.11530239946789965},
{0.9344748676363978,0.1372963074654654,-0.3284911653489103},
{0.9486367082076498,0.11270436117963539,-0.29561143890594693},
{0.8261645830834686,0.5102781248456717,-0.2388897590155418},
{0.762964229260647,0.5988719225481015,-0.24338858899350127},
{0.9279969561749757,0.1759994227228402,-0.3283989228532996},
{0.8790216901278092,-0.3078075952461202,-0.36410898450004014},
{0.7291021654366471,-0.36060107098677124,-0.5817017276566967},
{0.48579142828587124,-0.4233925293047301,-0.764686507225619},
{0.7560042903365215,0.5028028534142898,-0.4191023784127462},
{0.8372234258391871,0.33580939607835525,-0.4316120766748604},
{0.9134842425327234,0.15279736426819937,-0.3770934951933114},
{0.6939260712922569,0.22820857395718838,-0.6829256579989655},
{0.745358484688572,0.1567912669696379,-0.6479639094153404},
{0.7380720608109469,0.10389606708881913,-0.6666747635044822},
{0.6264995144630644,0.450699650707906,-0.6358995071780729},
{0.6127081184363543,0.5410071683924722,-0.5761076334767157},
{0.7526942720183848,0.10279921770092994,-0.6502950512734896},
{0.4810885430127706,0.1420966160093841,-0.8650793983794384},
{0.45978200218577975,0.07609702124040417,-0.8847653665375771},
{0.34248333174185636,0.400980484754699,-0.8496586481198696},
{0.3450903686622141,0.4758867181870405,-0.8089774217552338},
{0.4888190814252724,0.05680221731783035,-0.8705339819572415},
{0.9365021258622386,0.10000022700077295,0.33610076294959784},
{0.8081868913149335,0.1393977389870103,0.5721907191418028},
{0.73001132621359,0.250403885046415,0.6359098662181122},
{0.6802903569525348,0.23249670438257292,0.6950901471669954},
{0.5682959622715321,0.02659981100901417,0.8223941569102727},
{0.5324872257846782,-0.08379798971033997,0.8422797939501118},
{0.5989726754898019,0.16319255532543522,0.7839642363672867},
{0.4699770633291227,-0.15999219177161625,0.8680576354808753},
{0.40668821637964314,-0.17589490351900472,0.8964740250414311},
{0.6957207571384384,0.427812763984223,0.5770172155654434},
{0.7183909770659918,0.42799462442127567,0.5483931122257654},
{0.6179949942608195,0.035199714883464156,0.7853936383372939},
{0.2616957357027298,-0.18989690565513334,0.9462845804183921},
{0.2527021315514695,-0.34220288649352143,0.9050076337715864},
{-0.2980191259911354,-0.6643426355567492,0.6854439897796114},
{0.05950310078737515,-0.8823459802470772,0.4668243268495247},
{-0.14990589966277412,-0.9238363582953351,0.3522138616492932},
{0.11060195711894698,-0.6683118258823894,0.7356130167874991},
{-0.40100184461272786,-0.36180166429148364,0.8416038713867126},
{0.301094842289527,-0.2795952105750639,0.9116843829802781},
{0.1672955073394748,0.008099782483262078,0.9858735247219855},
{-0.019800196022910947,0.13960138206052364,0.9900098011455473},
{-0.22220113211765224,-0.6996035644892417,0.6791034600409435},
{0.9640001831600523,-0.030900005871001678,0.26410005017901433},
{0.8546073240161504,0.34090292155055657,0.39170335691215313},
{0.5948100107367217,0.6387107495923743,0.4881082149303865},
{0.8693354652637229,0.2646107950175786,0.4174170288750465},
{0.9575007420633627,-0.22820017685520558,0.17640013671015892},
{0.9510203282767777,-0.01410030139716358,0.3088066008116393},
{0.9863327024028813,-0.03500116048271403,0.16100533822048455},
{0.9230228497134705,0.0890022032768135,0.3743092661405764},
{0.9294045680346779,-0.04340021331257265,0.36650180136078053},
{0.770511334305092,0.0577008487857285,0.634809338114046},
{0.7792760415263992,-0.06799790943641107,0.6229808467482956},
{0.7689320882055752,0.0022000918117469964,0.6393266796590249},
{0.627312929052703,-0.2943060657105221,0.7210148602694068},
{0.7041222013230171,-0.15780497566932553,0.6923218292514199},
{0.8702602414989471,0.2034140808100274,0.44863105531651076},
{0.8631028870839859,0.011300037798689655,0.504901688898974},
{0.7179901995006648,-0.09389871829124294,0.6896905857877556},
{0.64982080109677,0.04550145652493541,0.7587242871531539},
{0.5176060353215579,-0.45340528673646524,0.725608460643977},
{0.24409994385701939,-0.9121997901940724,0.3290999243070261},
{0.17600288207079104,-0.9385153683149853,0.29700486349445987},
{0.27219728756754397,-0.6896931272422303,0.670993313584945},
{0.45438449212192134,-0.5878799360001706,0.6692771579603916},
{0.39759540978749086,-0.08419902792783382,0.913689451516173},
{0.17849720654057627,0.2868955101203996,0.9411852705657725},
{-0.052597922160126785,0.4531820973948566,0.8898648465835899},
{-0.2356103670842326,0.05920260497192942,0.9700426828170866},
{0.07770012626280777,-0.6339010300900109,0.7695012504405478},
{0.2759923137210928,-0.36568981568044795,0.8888752451691282},
{0.4997070883953237,-0.6023085438072913,0.6225088303503883},
{0.7512987791404758,-0.10839982385042937,0.6509989421275786},
{0.8638148318279948,0.07010120364800004,0.49890856633362657},
{0.8534380812567975,0.5048225256836553,0.12960578313906837},
{0.8288752542986689,0.5328840909829421,0.17029491592117665},
{0.8881699048726514,-0.13019558839722947,0.44068506763947024},
{0.9021741215064817,-0.336190356517933,0.27029224677810015},
{0.666829894654281,-0.3533158395041354,0.6561294149410225},
{0.8431756410075919,0.2744920700386433,0.4622866447317478},
{0.6967963453127531,0.33009826863912145,0.6367966600102773},
{0.5696693127406618,-0.448575835870565,0.6886629027286182},
{0.5137874406195192,0.7558815227020136,0.40579008058271876},
{0.5563054379122335,0.7176070146428524,0.41900409578505454},
{0.578719650759368,0.43721484588214216,0.6884233758125954},
{0.38271449367231825,0.5676214962331012,0.7289276050111125},
{0.2866007910192748,0.5154014225098892,0.807602228985228},
{0.426799479304953,0.24259970402854167,0.8711989371379452},
{0.2463097306581183,0.24490967534784072,0.9377370460337698},
{0.3605832260584765,0.2667875893300098,0.8937584233251978},
{0.40819485473628386,0.0033999571438103017,0.9128884931130661},
{0.5790799468086569,-0.6777765290051937,0.4530843099620143},
{0.9992199596180421,0.03540070713618764,0.017500349572974118},
{0.9963344040209665,-0.026600918545576342,-0.0813028074344119},
{0.9823669537315054,0.06139793460821909,-0.17659405947575718},
{0.9586333370539541,0.1943067571349711,-0.20800723357732365},
{0.9678982529452301,0.2345995765481465,-0.09019983718944082},
{0.9671644670302099,0.24999081550615435,0.04579831740072748},
{0.9540587718305729,0.2548156971304298,0.1576097090571261},
{0.9586182091258252,0.15530295000755337,0.23860453233613801},
{0.9653667292090069,0.04439846983310535,0.2570911395065627},
{0.9707501599566809,-0.0496025630306494,0.23491213822378113},
{0.982530562088458,-0.0673020934641763,0.1735053969693104},
{0.9972619352383841,0.042098393135000474,0.0607976793968653},
{0.8289441548863963,-0.5555295910717736,0.06510346782857329},
{0.9877975206313349,-0.10469973720398944,-0.1152997105980896},
{0.9695498506871426,0.19541004726587688,-0.14760758943932156},
{0.7812911363023377,0.6237929231094308,0.021599754952170095},
{0.9558307113341407,0.1911061403389352,0.22330717497479977},
{0.9649142760123213,-0.10280152095975399,0.24160357455132844},
{0.7216365951196313,0.5649286482581481,0.4001202906144186},
{0.7451360281979661,-0.5120247569955155,0.427320661453484},
{0.8255866256049968,-0.5597909314603648,0.07099884982794909},
{0.8251473531526445,-0.44957131601724304,-0.34207817439835153},
{0.7498262706235951,0.5717200305621623,-0.33301166726814774},
{0.7520282730343971,0.6584247539439455,0.03050114671216637},
{-0.05130162885257451,-0.26950855703253085,0.9616305322541063},
{-0.23678803185138753,0.29228522681655644,0.9265531685536134},
{-0.30450474117573045,0.13060203348949226,0.9435146906381008},
{-0.379194712166608,0.16499769912312848,0.9104873033430817},
{0.48520830198507103,-0.03930067244025823,0.8735149459685894},
{-0.32200552244206526,0.05870100673089823,0.9449162054518865},
{-0.317294690117791,-0.10329827131789412,0.9426842243115081},
{-0.047902045221482024,-0.5066216306722923,0.8608367542098483},
{0.45150347884770686,-0.6365049042891814,0.625304817992184},
{0.28039293278519256,-0.7894801014048128,0.5459862385902823},
{-0.09270073929134379,-0.7810062285495091,0.6176049254189204},
{-0.5940649333819431,-0.42567487315383473,0.6825597096894704},
{-0.5360976572583567,0.16029929949359184,0.8287963781677411},
{-0.45292187439014825,0.46962268097507975,0.7578366006024605},
{-0.23249987561259983,0.4268997716086833,0.8738995324638752},
{-0.2123919016511821,0.6914736346129586,0.690473672740778},
{-0.19140460429313505,0.8948215251906858,0.4033097017315641},
{-0.18900120488652172,0.9704061863591571,0.1503009581716625},
{-0.19449146006747856,0.9805569446898172,-0.026098854024479128},
{-0.1948025431638016,0.9557124769078296,-0.2206028799893975},
{-0.21728707832166688,0.8037522022777535,-0.55386706250516},
{-0.26010122507965516,0.4551021435361441,-0.8516040110643381},
{-0.24189869133161987,0.24639866698681742,-0.9384949227562019},
{-0.21360627904886034,0.14480425658368434,-0.9661283997617226},
{-0.1948062085728024,0.057901845361217966,-0.9791312054087825},
{-0.13369636283992276,0.3915893469567221,-0.9103752335786511},
{-0.14380449180345334,0.46971467176691256,-0.8710272069597208},
{-0.23430340445320025,0.009800142397103553,-0.9721141249208534},
{-0.24219730193708452,-0.46999476428748854,-0.8487905445260006},
{-0.17360970765821315,-0.8385468886602059,-0.5164288769280027},
{-0.05490131462771833,-0.9909237279527522,0.12270293815703168},
{-0.07959771876206996,-0.9939715131846424,0.0753978391288954},
{-0.07769715089771392,-0.9953635006896323,0.05669792092535881},
{-0.006000238064167887,-0.9999396733935784,-0.009200365031724094},
{0.02659973174305805,-0.9924899907889141,-0.11939879586921547},
{0.04419924729322785,-0.9640835817964019,-0.2618955399569315},
{0.02330100464447334,-0.9112392889289316,-0.4112177300346539},
{-0.029300932663530253,-0.7488238354420291,-0.6621210756492621},
{0.1624983506501113,-0.41779575939456315,-0.8938909270531354},
{0.21119048291532633,-0.6837691866358907,-0.6984685242251678},
{0.5033861117687618,-0.7308798353035122,-0.460887284295237},
{0.4172949799715862,-0.8745894787518556,0.2468970298465963},
{-0.5463268307695047,-0.8375411326550618,-0.007200353618049486},
{-0.4805937403072985,-0.8586888156510138,0.17799768159529575},
{-0.45762683144771477,-0.5987351048683278,0.6573385408885115},
{-0.5958691645685796,-0.07619605695607615,0.7994586290863894},
{-0.6552776914507353,0.02499914891846236,0.7549742973375633},
{-0.3456020926270063,-0.4958030020962666,0.7967048240623146},
{-0.5007056630130732,-0.30920349711132855,0.8085091442901331},
{-0.47320797598765346,0.6319106509437832,0.6138103458605699},
{-0.44140042815862296,0.7203006986920166,0.5351005190477552},
{-0.39548788639155685,-0.2789914546226154,0.8750731969184612},
{-0.4043889583102379,-0.2605928846084273,0.876676062686908},
{-0.5202977887390968,0.1419993965038473,0.8420964210978155},
{-0.5008723801541236,0.5161715365054075,0.6947616884230087},
{-0.5359196498541995,0.5681208305321342,0.6245228985518708},
{-0.4125134584711275,0.020100655794593122,0.9107297130415899},
{-0.32289470295584666,-0.28219537062291705,0.9033851800876799},
{-0.25470061510272823,-0.6442015557486358,0.7212017417043093},
{-0.22600446928257054,-0.41390818511529176,0.8818174381122598},
{-0.24790094574391203,0.2536009674895364,0.9350035670454124},
{-0.5111801231473596,0.26478970385254463,0.8176682055899764},
{-0.4925339219793503,0.389926855187307,0.7780535863958062},
{-0.45659984019008387,0.6132997853451126,0.6444997744251183},
{-0.4678123691225615,0.7932209730397944,0.38981030672076633},
{-0.5075023091407599,0.8477038570613246,0.15440070252479476},
{-0.5537847462092457,0.8323770724893033,-0.021699402298195433},
{-0.5647888624734468,0.8005842126349887,-0.20019605217277633},
{-0.5239940972397417,0.703792071826966,-0.4796945962708093},
{-0.5217954708349697,0.4353962207772054,-0.7335936324349056},
{-0.48939816720729573,0.24919906675124254,-0.835696870321081},
{-0.4810885430127706,0.1420966160093841,-0.8650793983794384},
{-0.45978200218577975,0.07609702124040417,-0.8847653665375771},
{-0.3423950609868676,0.4009942157001575,-0.8496877433427027},
{-0.3451067900428918,0.47580936164128634,-0.8090159175447681},
{-0.4887765295145655,0.05679727266044869,-0.8705581967990604},
{-0.48581199484623094,-0.423310451664079,-0.764718881142266},
{-0.34058415639355827,-0.8161620330253149,-0.4667782859791926},
{-0.7628814240634834,0.30979245664551996,0.5674861818797048},
{-0.7200775267310806,0.47958503238470535,0.5014843489177016},
{-0.7829831582133984,0.550888150523322,0.28889378596149523},
{-0.830372523427792,0.5408821025073371,0.13389556946890818},
{-0.8514768529163759,0.52438574476729,-0.0025999293218820635},
{-0.8518264922158683,0.4960154263196415,-0.1684052374843299},
{-0.7560042903365215,0.5028028534142898,-0.4191023784127462},
{-0.8372234258391871,0.33580939607835525,-0.4316120766748604},
{-0.6939260712922569,0.22820857395718838,-0.6829256579989655},
{-0.745358484688572,0.1567912669696379,-0.6479639094153404},
{-0.7380720608109469,0.10389606708881913,-0.6666747635044822},
{-0.6264105206530423,0.45080757137674243,-0.635910680209562},
{-0.6127081184363543,0.5410071683924722,-0.5761076334767157},
{-0.7526942720183848,0.10279921770092994,-0.6502950512734896},
{-0.7291182792243931,-0.3607090430890668,-0.5816145812603306},
{-0.48308651724345303,-0.7885779910953986,-0.38048938068957544},
{-0.9569178993167117,0.25530477552048964,0.13830258697408426},
{-0.9665443315724247,0.25611174683465904,0.014100646740994503},
{-0.9563366379584137,0.2637101029275684,-0.12600482733740473},
{-0.9134842425327234,0.15279736426819937,-0.3770934951933114},
{-0.9344748676363978,0.1372963074654654,-0.3284911653489103},
{-0.9486367082076498,0.11270436117963539,-0.29561143890594693},
{-0.8261843150396669,0.5102903122303825,-0.238795466511102},
{-0.7630099191934248,0.5988077845517991,-0.24340316426170325},
{-0.927994742924672,0.1761990018354819,-0.32829814019630366},
{-0.8790985143247662,-0.3075994801573178,-0.3640993846725598},
{-0.5520162019132928,-0.7787228558512338,-0.2981087496202039},
{-0.9151733322376422,0.2767919344005456,0.2929914623531787},
{-0.9807580538750346,0.15469338390545254,0.11909490641977633},
{-0.9873178409945815,0.1576028479091928,0.019100345146355217},
{-0.9863080828278583,0.12340101127543111,-0.10940089654402078},
{-0.9910206233537602,0.06770140888097836,-0.11530239946789965},
{-0.9371240562832912,0.20240519580806543,0.2843072982620208},
{-0.9776428119161212,-0.12710556607461027,0.16750733530682316},
{-0.786378076084854,0.2577928128365658,0.5613843488225293},
{-0.8619175272711274,-0.39460802443576615,0.31840647486150014},
{-0.8997887347155615,-0.3367957833431886,0.27739652701722245},
{-0.9572752882573964,-0.1984948759209163,0.2102945713157113},
{-0.7126032779826181,-0.40480186209284846,0.5730026358181871},
{-0.5324955882923265,-0.6855943198745897,0.49639588737710966},
{-0.7257033309859339,-0.5652025942858617,0.3923018006693976},
{-0.9394232369211514,0.033600831126837004,0.3411084374215507},
{-0.9841053830711681,0.0355001941865933,0.17400095178780942},
{-0.43250400716818965,-0.4329040108742412,0.7909073277903381},
{-0.3716053808848731,-0.710810292607556,0.5972086476438272},
{-0.5084148255924745,-0.2166063163322777,0.8334243030070188},
{-0.7723047458272447,-0.13790084740331096,0.6201038105496238},
{-0.887399995563,-0.034599999827,0.4596999977015},
{-0.8081868913149335,0.1393977389870103,0.5721907191418028},
{-0.9365021258622386,0.10000022700077295,0.33610076294959784},
{-0.9863327024028813,-0.03500116048271403,0.16100533822048455},
{-0.9824820551291432,0.07679859728643072,0.16979689868796796},
{-0.9924381450931741,-0.0696026752302347,0.1011038860025392},
{-0.8931886163836257,0.367395317576516,0.2592966952846777},
{-0.6360116486600188,0.7044129014404359,0.3151057712150502},
{-0.8544747720047795,0.45158666710047796,0.2567924183157722},
{-0.9724222881742705,0.10020229666295957,0.21060482711795697},
{-0.9417771810153527,-0.32309217157152315,0.09309774426898422},
{-0.6180811179102673,-0.7789762026405085,-0.10569677101296758},
{-0.9992199596180421,0.03540070713618764,0.017500349572974118},
{-0.9972619352383841,0.042098393135000474,0.0607976793968653},
{-0.982530562088458,-0.0673020934641763,0.1735053969693104},
{-0.9707501599566809,-0.0496025630306494,0.23491213822378113},
{-0.9653667292090069,0.04439846983310535,0.2570911395065627},
{-0.9586182091258252,0.15530295000755337,0.23860453233613801},
{-0.9540587718305729,0.2548156971304298,0.1576097090571261},
{-0.9671644670302099,0.24999081550615435,0.04579831740072748},
{-0.9678982529452301,0.2345995765481465,-0.09019983718944082},
{-0.9586333370539541,0.1943067571349711,-0.20800723357732365},
{-0.9823669537315054,0.06139793460821909,-0.17659405947575718},
{-0.9963344040209665,-0.026600918545576342,-0.0813028074344119},
{-0.9639717367630112,-0.03099909111997235,0.26419225399666757},
{-0.9190781124153761,-0.3780909958701487,0.1110973542480125},
{-0.6214227942061449,-0.7708282744996725,-0.14020514281895963},
{-0.6303848047574199,-0.7145827751898037,-0.3032926892178386},
{-0.497779312721636,-0.8011667042036456,-0.33218619462862087},
{-0.14179984827424352,-0.8150991278443999,-0.5616993989819646},
{-0.14129464644726727,-0.9752630479831547,-0.1699935590660682},
{0.10510508405587664,-0.9850476479071217,-0.13650660298408338},
{0.4567060993506855,-0.7648102141086146,-0.4544060686335702},
{0.7832675968897612,-0.615874521798039,0.08479649204168486},
{0.7755852795310905,-0.3601931635986318,0.5183901610481141},
{-0.014999886526287642,-0.9006931862818186,0.43419671531427295},
{-0.776395027205776,-0.6256959924300027,0.07559951578665207},
{-0.8398416193826983,-0.3951195806359896,0.3722184457421294},
{-0.857363524244775,-0.03969831107128244,0.5131781672992984},
{-0.4607911321599915,-0.14439722110221956,0.8756831476399839},
{-0.29040925549046104,-0.5233166783683136,0.801125532277577},
{-0.5025980675141457,-0.3721985688992539,0.780296999763804},
{-0.6201895374907531,0.6370892523949674,0.4576922787963845},
{-0.6268202184122226,0.6166198893953039,0.476315363799843},
{-0.46869357659854877,-0.20439719875558646,0.8593882221651223},
{-0.4402156191272548,-0.24140856532784943,0.8648306847370514},
{-0.6375687598961288,0.11499436541413868,0.7617626745433986},
{-0.5231064708670672,-0.02790034512940389,0.8518105369615137},
{-0.5353965815037407,0.20439869491849944,0.8194947675426139},
{-0.5485135566800821,0.06740166585275759,0.8334205982446315},
{-0.43699746542205076,-0.21739873909096988,0.872794937804041},
{-0.8544885926534317,0.34109544640618555,0.391794769574739},
{-0.996763673609861,-0.029198935864173294,-0.07489727041871848},
{-0.5948100107367217,0.6387107495923743,0.4881082149303865},
{-0.8288752542986689,0.5328840909829421,0.17029491592117665},
{-0.8534380812567975,0.5048225256836553,0.12960578313906837},
{-0.9744401380159443,-0.07950327480733536,-0.21010865455372527},
{-0.8815199446143729,-0.4565103286630303,0.12050272640502771},
{-0.7353949662386842,-0.6086958334912796,0.2977979615799295},
{-0.40980202032894036,-0.912104496686253,-0.01130005570941197},
{-0.21250322369835542,-0.8990136381403366,0.3829058087251779},
{0.14289778438702952,-0.9367854752538085,0.3193950478181751},
{0.5031789776214632,-0.8633639294085282,-0.037598429170443204},
{0.5378757262162014,-0.7628655726535416,0.3587838084520786},
{0.4423078709385957,-0.4366077695043881,0.7834139409751206},
{0.48869076627520597,-0.21209599248408265,0.8462840096147061},
{0.6807723816247049,-0.38448440178422305,0.6234747061442473},
{-0.28668599573115444,-0.8583580702323788,0.42547921584794635},
{-0.5636841635158859,-0.7184798145931596,0.40748855176995474},
{-0.11460352927002662,-0.21740669514226693,0.9693298509723981},
{-0.014899821724699589,-0.46039449141286515,0.8875893800566009},
{-0.3563965358425073,-0.28379724150421876,0.8901913473821549},
{-0.6192016223103757,0.12260032121326238,0.7756020320799861},
{-0.611774841276968,0.6025752196036301,0.5124789247375713},
{-0.588205440925493,0.6399059191571285,0.494504574188467},
{-0.3840908856314247,-0.16529607757061832,0.9083784444352673},
{-0.34409779606067437,-0.27159826041871304,0.8987942432413081},
{-0.5692993794640147,0.14799983868026376,0.8086991185184412},
{-0.47041020566011893,-0.12660274667638405,0.8733189468600805},
{-0.5084804289649264,0.04919810640132622,0.8596669120573202},
{-0.6064191358577528,0.15280482183223057,0.7803246235319994},
{-0.6262120578292614,-0.1409027131078616,0.7668147651604561},
{-0.8337025261224812,-0.04470013544161558,0.5504016677195798},
{-0.73001132621359,0.250403885046415,0.6359098662181122},
{-0.9230228497134705,0.0890022032768135,0.3743092661405764},
{-0.9294045680346779,-0.04340021331257265,0.36650180136078053},
{-0.9510203282767777,-0.01410030139716358,0.3088066008116393},
{-0.9575007420633627,-0.22820017685520558,0.17640013671015892},
{-0.8693354652637229,0.2646107950175786,0.4174170288750465},
{-0.8881699048726514,-0.13019558839722947,0.44068506763947024},
{-0.9021741215064817,-0.336190356517933,0.27029224677810015},
{-0.8431756410075919,0.2744920700386433,0.4622866447317478},
{-0.5137874406195192,0.7558815227020136,0.40579008058271876},
{-0.5563054379122335,0.7176070146428524,0.41900409578505454},
{-0.5778057520848932,0.4375043553775368,0.6890068590974235},
{-0.8654848628021232,0.0642988754225032,0.4967913111959501},
{-0.7530310066900638,-0.1088044801167051,0.648926720107812},
{-0.49991834484025205,-0.6022220989453886,0.6224228402251908},
{-0.27610487743574025,-0.36550645672858767,0.8889157028345871},
{-0.07750132877167279,-0.6339108684950113,0.7695131934168026},
{0.22220113211765224,-0.6996035644892417,0.6791034600409435},
{-0.6967995366284623,0.32969978074971873,0.6369995763954226},
{-0.382689740225595,0.5671847939795075,0.72928044825327},
{-0.42669267374968706,0.2431958243635432,0.8710850435982009},
{-0.6683933127583586,-0.352096477292367,0.6551934448223766},
{-0.571634424861629,-0.44702692077177775,0.6880414351028704},
{-0.28540246017981014,0.5148044376333787,0.8084069684981028},
{-0.8629902051167575,0.011299871747183499,0.5050942672126004},
{-0.6504832502719554,0.045098838719854255,0.7581804771040687},
{-0.36151452956092045,0.2676107554923992,0.893135895852996},
{-0.2473088859679121,0.24620884644278188,0.9371336718177534},
{0.04779911715845905,-0.5068906378163784,0.8606841033114163},
{0.31749460739988955,-0.1035982403988301,0.9425839903468847},
{0.32111303584829076,0.058402370892370534,0.9452383727306273},
{-0.4854819282715738,-0.03919854086147414,0.8733674895002936},
{0.3793085990234109,0.1651037429442793,0.9104206394698477},
{0.30450474117573045,0.13060203348949226,0.9435146906381008},
{0.2356103670842326,0.05920260497192942,0.9700426828170866},
{0.019800196022910947,0.13960138206052364,0.9900098011455473},
{-0.1666960576848531,0.007899813171627712,0.9859766819272056},
{-0.3009129606003256,-0.27961204315005334,0.9117392694560214},
{0.4011097109836558,-0.3621087667593661,0.8414203710337771},
{-0.11060195711894698,-0.6683118258823894,0.7356130167874991},
{0.14999837027656038,-0.9237899630765765,0.35229617232288146},
{-0.05939820738915108,-0.882373370373517,0.46678591261373276},
{0.29779665725128346,-0.6643925422355699,0.6854923053920577},
{-0.252299201474291,-0.34199891757513884,0.9051971350556013},
{-0.2619068018079656,-0.1899049318951228,0.9462245737712754},
{-0.6181075069612584,0.03510042629726609,0.7853095376422524},
{-0.7180180763326104,0.4273107576837387,0.5494138316673205},
{-0.6958802338026844,0.42678787726251716,0.5775835939710167},
{-0.40668821637964314,-0.17589490351900472,0.8964740250414311},
{-0.4701032860334541,-0.1599011177127192,0.8680060673836165},
{-0.599009853793143,0.1633026863512859,0.7839128954731966},
{-0.5324872257846782,-0.08379798971033997,0.8422797939501118},
{-0.5682959622715321,0.02659981100901417,0.8223941569102727},
{-0.6802903569525348,0.23249670438257292,0.6950901471669954},
{-0.770511334305092,0.0577008487857285,0.634809338114046},
{-0.7792760415263992,-0.06799790943641107,0.6229808467482956},
{-0.7689729595413083,0.002199922641080466,0.6392775202012462},
{-0.6273818626525223,-0.2944914863741916,0.7208791596847359},
{-0.7058225584494578,-0.15500495403749784,0.6912220918110872},
{-0.8706102471429137,0.20570242113174514,0.44690526010586734},
{-0.7180194585909953,-0.09420255292377683,0.689618688919708},
{-0.5176060353215579,-0.45340528673646524,0.725608460643977},
{-0.40778694898754314,0.0033998911882237534,0.9130707776373852},
{-0.4516092106637782,-0.6369129899728971,0.6248127431858472},
{-0.2799937436096978,-0.7894823592137729,0.5461877955700605},
{0.09270073929134379,-0.7810062285495091,0.6176049254189204},
{0.5939102123739034,-0.42580732181984854,0.6826117376097431},
{0.5360263919091245,0.16030789295341913,0.8288408089818701},
{-0.17600288207079104,-0.9385153683149853,0.29700486349445987},
{-0.24409994385701939,-0.9121997901940724,0.3290999243070261},
{-0.27219728756754397,-0.6896931272422303,0.670993313584945},
{-0.4544868427963488,-0.5876829868237936,0.6693806217114981},
{-0.5790004603055489,-0.6779005389311427,0.4530003601354295},
{0.051397810242940906,-0.26938852294646454,0.9616590293898106},
{0.45300135900611554,0.46960140880633966,0.7578022734102304},
{0.23669364012733354,0.2922921462155454,0.9265751032614586},
{0.052700028721523476,0.45310024693970186,0.8899004849958965},
{-0.17880957640330325,0.2868153608079831,0.9411504046596685},
{-0.39720884991176514,-0.08460188495099528,0.9138203601444385},
{-0.8289441548863963,-0.5555295910717736,0.06510346782857329},
{-0.9649142760123213,-0.10280152095975399,0.24160357455132844},
{-0.9558307113341407,0.1911061403389352,0.22330717497479977},
{-0.7812911363023377,0.6237929231094308,0.021599754952170095},
{-0.9695498506871426,0.19541004726587688,-0.14760758943932156},
{-0.9877975206313349,-0.10469973720398944,-0.1152997105980896},
{-0.7216365951196313,0.5649286482581481,0.4001202906144186},
{-0.7520282730343971,0.6584247539439455,0.03050114671216637},
{-0.7498262706235951,0.5717200305621623,-0.33301166726814774},
{-0.8251473531526445,-0.44957131601724304,-0.34207817439835153},
{-0.8255866256049968,-0.5597909314603648,0.07099884982794909},
{-0.7451360281979661,-0.5120247569955155,0.427320661453484},
{-0.12729398295563515,0.014899295726936088,-0.9917531209379338},
{-0.11270306894635168,0.0797021703196471,-0.9904269696935821},
{0.35559301622174144,-0.1925962174474336,-0.914582037785165},
{0.20479953100961099,-0.3414992179676863,-0.9172978993902156},
{-0.0663974938738897,0.1301950858792235,-0.9892626609855283},
{-0.10659849643881153,-0.04709933566855557,-0.9931859912103903},
{0.4122013025581741,0.012800040448191725,-0.9110028787736454},
{-0.0007000079136341957,0.013300150359049717,-0.999911304061189},
{0.00030000247503062855,-0.3954032620903684,-0.9185075777187744},
{-0.0,0.1484040240296681,-0.9889268151141426},
{0.06650136894476974,0.1297026699569419,-0.9893203653693339},
{0.11270036909431318,0.08000026200128708,-0.9904032435759341},
{0.1275037467526483,0.014700431978540627,-0.99172914238903},
{0.10720073915164469,-0.04740032682638021,-0.9931068474953203},
{0.06050123726295317,-0.0898018364663338,-0.994120329968624},
{-0.0,-0.10560091239582467,-0.994408591727349},
{-0.06059814390727774,-0.09029723423807227,-0.9940695521159207},
{0.3585127596961804,0.2204078444547787,-0.907132285412567},
{0.20740354974213102,0.3726063772127195,-0.9045154809149349},
{0.0003999997680002019,0.42879975129621645,-0.9033994760284559},
{-0.20789302946358118,0.3726875039974829,-0.9043696769930871},
{-0.3584097972657142,0.22060603034826048,-0.907124796595227},
{-0.4120796808518934,0.012999359017409885,-0.9110550769817036},
{-0.3559132651345919,-0.1927071823305307,-0.9144340815933433},
{-0.20480432448896788,-0.34170721522402503,-0.9172193672914127}
};


// face array: 45kb.
const uint16_t stormtrooper_face[23209] PROGMEM = {
18, // chain 0
0,0,0, 1,1,1, 2,2,2, 
3,3,3, 32772,4,4, 32773,5,5, 6,6,6, 32775,7,7, 8,8,8, 32777,9,9, 10,10,10, 32779,11,11, 12,12,12, 13,13,13, 32782,14,14, 15,15,15, 32784,16,16, 17,17,17, 32786,18,18, 
32787,19,19, 
18, // chain 1
0,0,0, 3,3,3, 20,20,20, 
32789,21,21, 32790,22,22, 32772,4,4, 23,23,23, 32774,6,6, 24,24,24, 32776,8,8, 25,25,25, 32778,10,10, 13,13,13, 26,26,26, 32783,15,15, 27,27,27, 32785,17,17, 28,28,28, 32797,29,29, 
32786,18,18, 
18, // chain 2
30,30,30, 20,20,20, 21,21,21, 
31,31,31, 32800,32,32, 32790,22,22, 23,23,23, 33,33,33, 32802,34,34, 32792,24,24, 35,35,35, 32793,25,25, 26,26,26, 36,36,36, 32805,37,37, 32795,27,27, 28,28,28, 38,38,38, 32807,39,39, 
32797,29,29, 
18, // chain 3
30,30,30, 31,31,31, 40,40,40, 
32809,41,41, 32810,42,42, 32800,32,32, 43,43,43, 32801,33,33, 44,44,44, 32802,34,34, 45,45,45, 32803,35,35, 36,36,36, 46,46,46, 32805,37,37, 47,47,47, 32806,38,38, 48,48,48, 32817,49,49, 
32807,39,39, 
16, // chain 4
50,50,50, 40,40,40, 41,41,41, 
51,51,51, 32810,42,42, 52,52,52, 32811,43,43, 53,53,53, 32812,44,44, 54,54,54, 32813,45,45, 46,46,46, 55,55,55, 32815,47,47, 56,56,56, 32816,48,48, 57,57,57, 32817,49,49, 
12, // chain 5
50,50,50, 51,51,51, 58,58,58, 
32827,59,59, 32820,52,52, 60,60,60, 32821,53,53, 61,61,61, 32822,54,54, 55,55,55, 62,62,62, 32824,56,56, 63,63,63, 32825,57,57, 
8, // chain 6
64,64,64, 58,58,58, 59,59,59, 
65,65,65, 32828,60,60, 66,66,66, 32829,61,61, 62,62,62, 67,67,67, 32831,63,63, 
26, // chain 7
68,68,68, 69,69,69, 70,70,70, 
32839,71,71, 32840,72,72, 73,73,73, 32842,74,74, 75,75,75, 76,76,76, 32845,77,77, 78,78,78, 32847,79,79, 80,80,80, 32849,81,81, 82,82,82, 83,83,83, 84,84,84, 85,85,85, 32854,86,86, 
87,87,87, 32856,88,88, 89,89,89, 32858,90,90, 91,91,91, 92,92,92, 32861,93,93, 94,94,94, 32863,95,95, 
7, // chain 8
70,70,70, 71,71,71, 96,96,96, 
32865,97,97, 32841,73,73, 98,98,98, 32844,76,76, 80,80,80, 32846,78,78, 
7, // chain 9
80,80,80, 85,85,85, 87,87,87, 
98,98,98, 32857,89,89, 97,97,97, 32860,92,92, 99,99,99, 32862,94,94, 
4, // chain 10
99,99,99, 100,100,100, 97,97,97, 
32869,101,101, 102,102,102, 96,96,96, 
50, // chain 11
12,103,12, 11,104,11, 101,105,101, 
32777,106,9, 102,107,102, 32775,108,7, 96,109,96, 32773,110,5, 70,111,70, 32770,112,2, 68,113,68, 32769,114,1, 69,115,69, 32768,116,0, 72,117,72, 32788,118,20, 74,119,74, 32798,120,30, 75,121,75, 
32808,122,40, 77,123,77, 32818,124,50, 79,125,79, 32826,126,58, 81,127,81, 32832,128,64, 82,129,82, 32833,130,65, 66,131,66, 83,132,83, 32835,133,67, 84,134,84, 32831,135,63, 86,136,86, 32825,137,57, 
88,138,88, 32817,139,49, 90,140,90, 32807,141,39, 91,142,91, 32797,143,29, 93,144,93, 32786,145,18, 95,146,95, 32787,147,19, 94,148,94, 32784,149,16, 99,150,99, 32782,151,14, 100,152,100, 32780,103,12, 
101,105,101, 
32, // chain 12
103,153,103, 104,154,104, 105,155,105, 
106,156,106, 32875,157,107, 108,158,108, 32877,159,109, 110,160,110, 32879,161,111, 112,162,112, 32881,163,113, 114,164,114, 32883,165,115, 116,166,116, 32885,167,117, 118,168,118, 119,169,119, 32888,170,120, 121,171,121, 
32890,172,122, 32891,173,123, 124,174,124, 125,175,125, 32894,176,126, 127,177,127, 32896,178,128, 129,179,129, 32898,180,130, 131,181,131, 32900,182,132, 133,183,133, 32902,184,134, 135,185,135, 32904,186,136, 
38, // chain 13
103,153,103, 106,156,106, 137,187,137, 
32906,188,138, 32876,158,108, 139,189,139, 32878,160,110, 140,190,140, 32880,162,112, 114,164,114, 141,191,141, 32884,166,116, 119,169,119, 142,192,142, 32889,171,121, 143,193,143, 32912,194,144, 32890,172,122, 125,175,125, 
145,195,145, 32895,177,127, 129,179,129, 146,196,146, 32899,181,131, 147,197,147, 32901,183,133, 148,198,148, 32903,185,135, 149,199,149, 150,200,150, 32919,201,151, 152,202,152, 32921,203,153, 154,204,154, 155,205,155, 
32924,206,156, 157,207,157, 32926,208,158, 137,187,137, 32871,153,103, 
33, // chain 14
150,200,150, 152,202,152, 159,209,159, 
32923,205,155, 160,210,160, 32925,207,157, 161,211,161, 32905,187,137, 138,188,138, 139,189,139, 162,212,162, 32931,213,163, 32908,190,140, 141,191,141, 142,192,142, 164,214,164, 32911,193,143, 165,215,165, 32934,216,166, 
32912,194,144, 145,195,145, 146,196,146, 167,217,167, 32936,218,168, 32915,197,147, 148,198,148, 150,200,150, 159,209,159, 169,219,169, 32928,210,160, 170,220,170, 32929,211,161, 162,212,162, 164,214,164, 32931,213,163, 
4, // chain 15
167,217,167, 168,218,168, 169,219,169, 
165,215,165, 32938,220,170, 164,214,164, 
1, // chain 16
165,215,165, 166,216,166, 167,217,167, 
12, // chain 17
171,221,171, 172,222,172, 173,223,173, 
32942,224,174, 32943,225,175, 176,226,176, 32945,227,177, 178,228,178, 179,229,179, 180,230,180, 181,231,181, 32950,232,182, 183,233,183, 32952,234,184, 
8, // chain 18
173,223,173, 174,224,174, 185,235,185, 
32954,236,186, 32944,226,176, 187,237,187, 32956,238,188, 32949,231,181, 189,239,189, 32951,233,183, 
18, // chain 19
189,239,189, 190,240,190, 188,238,188, 
32959,241,191, 192,242,192, 32961,243,193, 194,244,194, 32963,245,195, 196,246,196, 32965,247,197, 198,248,198, 199,249,199, 200,250,200, 201,251,201, 32970,252,202, 203,253,203, 32972,254,204, 186,236,186, 32973,255,205, 
185,235,185, 
3, // chain 20
188,238,188, 192,242,192, 187,237,187, 
32964,246,196, 32962,244,194, 
3, // chain 21
203,253,203, 186,236,186, 187,237,187, 
196,246,196, 201,251,201, 
50, // chain 22
153,256,153, 151,257,151, 178,258,178, 
154,259,154, 32945,260,177, 156,261,156, 32943,262,175, 158,263,158, 32940,264,172, 103,265,103, 32939,266,171, 104,267,104, 32941,268,173, 105,269,105, 32953,270,185, 107,271,107, 32973,272,205, 109,273,109, 32972,274,204, 
111,275,111, 32970,276,202, 113,277,113, 32968,278,200, 115,279,115, 32967,280,199, 117,281,117, 32966,282,198, 118,283,118, 32888,284,120, 32965,285,197, 123,286,123, 32963,287,195, 124,288,124, 32961,289,193, 126,290,126, 
32959,291,191, 128,292,128, 32958,293,190, 130,294,130, 32957,295,189, 132,296,132, 32951,297,183, 134,298,134, 32952,299,184, 136,300,136, 32950,301,182, 135,302,135, 32948,303,180, 149,304,149, 32947,305,179, 151,257,151, 
32946,258,178, 
20, // chain 23
206,306,206, 207,307,207, 208,308,208, 
209,309,209, 210,310,210, 32979,311,211, 212,312,212, 32981,313,213, 214,314,214, 32983,315,215, 216,316,216, 32985,317,217, 218,318,218, 32987,319,219, 220,320,220, 32989,321,221, 222,322,222, 32991,323,223, 224,324,224, 
32993,325,225, 207,326,207, 32976,327,208, 
10, // chain 24
226,328,226, 210,329,210, 212,330,212, 
214,331,214, 216,332,216, 218,333,218, 220,334,220, 222,335,222, 224,336,224, 207,337,207, 206,338,206, 210,329,210, 
8, // chain 25
227,339,227, 228,340,228, 229,341,229, 
230,342,230, 32999,343,231, 33000,344,232, 233,345,233, 234,346,234, 33003,347,235, 33004,348,236, 
8, // chain 26
227,339,227, 230,342,230, 237,349,237, 
33006,350,238, 33007,351,239, 32999,343,231, 234,346,234, 240,352,240, 33009,353,241, 33003,347,235, 
8, // chain 27
237,349,237, 238,350,238, 242,354,242, 
33011,355,243, 33012,356,244, 33007,351,239, 240,352,240, 245,357,245, 33014,358,246, 33009,353,241, 
8, // chain 28
242,354,242, 243,355,243, 247,359,247, 
33016,360,248, 33017,361,249, 33012,356,244, 245,357,245, 250,362,250, 33019,363,251, 33014,358,246, 
8, // chain 29
247,359,247, 248,360,248, 252,364,252, 
33021,365,253, 33022,366,254, 33017,361,249, 250,362,250, 255,367,255, 33024,368,256, 33019,363,251, 
8, // chain 30
252,364,252, 253,365,253, 257,369,257, 
33026,370,258, 33027,371,259, 33022,366,254, 255,367,255, 260,372,260, 33029,373,261, 33024,368,256, 
8, // chain 31
257,369,257, 258,370,258, 262,374,262, 
33031,375,263, 33032,376,264, 33027,371,259, 260,372,260, 265,377,265, 33034,378,266, 33029,373,261, 
8, // chain 32
262,374,262, 263,375,263, 267,379,267, 
33036,380,268, 33037,381,269, 33032,376,264, 265,377,265, 270,382,270, 33039,383,271, 33034,378,266, 
8, // chain 33
267,379,267, 268,380,268, 272,384,272, 
33041,385,273, 33042,386,274, 33037,381,269, 270,382,270, 275,387,275, 33044,388,276, 33039,383,271, 
8, // chain 34
272,384,272, 273,385,273, 277,389,277, 
33046,390,278, 33047,391,279, 33042,386,274, 275,387,275, 280,392,280, 33049,393,281, 33044,388,276, 
8, // chain 35
277,389,277, 278,390,278, 282,394,282, 
33051,395,283, 33052,396,284, 33047,391,279, 280,392,280, 285,397,285, 33054,398,286, 33049,393,281, 
8, // chain 36
282,394,282, 283,395,283, 228,399,228, 
32997,400,229, 33000,401,232, 33052,396,284, 285,397,285, 233,402,233, 33004,403,236, 33054,398,286, 
24, // chain 37
287,404,287, 288,405,288, 289,406,289, 
290,407,290, 291,408,291, 33060,409,292, 293,410,293, 33062,411,294, 295,412,295, 33064,413,296, 297,414,297, 33066,415,298, 299,416,299, 33068,417,300, 301,418,301, 33070,419,302, 303,420,303, 33072,421,304, 305,422,305, 
33074,423,306, 307,424,307, 33076,425,308, 309,426,309, 33078,427,310, 288,428,288, 33057,429,289, 
24, // chain 38
311,406,311, 312,405,312, 313,404,313, 
314,407,314, 33083,408,315, 316,409,316, 33085,410,317, 318,411,318, 33087,412,319, 320,413,320, 33089,414,321, 322,415,322, 33091,416,323, 324,417,324, 33093,418,325, 326,419,326, 33095,420,327, 328,421,328, 33097,422,329, 
330,423,330, 33099,424,331, 332,425,332, 33101,426,333, 334,427,334, 33080,428,312, 311,429,311, 
12, // chain 39
306,430,306, 304,431,304, 335,432,335, 
33070,433,302, 300,434,300, 298,435,298, 296,436,296, 294,437,294, 292,438,292, 290,439,290, 289,440,289, 310,441,310, 308,442,308, 306,430,306, 
12, // chain 40
336,432,336, 328,431,328, 330,430,330, 
332,442,332, 334,441,334, 311,440,311, 314,439,314, 316,438,316, 318,437,318, 320,436,320, 322,435,322, 324,434,324, 326,433,326, 328,431,328, 
24, // chain 41
242,443,242, 247,444,247, 303,445,303, 
33069,446,301, 33020,447,252, 299,448,299, 33025,449,257, 297,450,297, 33030,451,262, 295,452,295, 33035,453,267, 293,454,293, 33040,455,272, 291,456,291, 33045,457,277, 287,458,287, 33050,459,282, 288,460,288, 32996,461,228, 
309,462,309, 32995,463,227, 307,464,307, 33005,465,237, 305,466,305, 33010,443,242, 303,445,303, 
24, // chain 42
329,466,329, 327,445,327, 246,443,246, 
241,465,241, 331,464,331, 33003,463,235, 333,462,333, 33004,461,236, 312,460,312, 33054,459,286, 313,458,313, 33049,457,281, 315,456,315, 33044,455,276, 317,454,317, 33039,453,271, 319,452,319, 33034,451,266, 321,450,321, 
33029,449,261, 323,448,323, 33024,447,256, 325,446,325, 33019,444,251, 327,445,327, 33014,443,246, 
20, // chain 43
337,467,337, 338,468,338, 339,469,339, 
340,470,340, 33109,471,341, 342,472,342, 33111,473,343, 344,474,344, 33113,475,345, 346,476,346, 33115,477,347, 348,478,348, 33117,479,349, 350,480,350, 33119,481,351, 352,482,352, 33121,483,353, 354,484,354, 33123,485,355, 
356,486,356, 33106,487,338, 337,488,337, 
10, // chain 44
343,489,343, 341,490,341, 357,491,357, 
33107,492,339, 338,493,338, 355,494,355, 353,495,353, 351,496,351, 349,497,349, 347,498,347, 345,499,345, 343,489,343, 
4, // chain 45
358,500,358, 359,501,359, 360,502,360, 
361,503,361, 362,504,362, 363,505,363, 
3, // chain 46
364,506,364, 365,507,365, 366,508,366, 
367,509,367, 368,510,368, 
16, // chain 47
369,511,369, 370,512,370, 371,513,371, 
372,514,372, 373,515,373, 33142,516,374, 375,517,375, 33144,518,376, 377,519,377, 33146,520,378, 379,521,379, 33148,522,380, 381,523,381, 33150,524,382, 383,525,383, 33152,526,384, 385,527,385, 33154,528,386, 
10, // chain 48
387,529,387, 388,530,388, 389,531,389, 
390,532,390, 391,533,391, 33160,534,392, 393,535,393, 33162,536,394, 395,537,395, 33164,538,396, 397,539,397, 33166,540,398, 
10, // chain 49
399,541,399, 400,542,400, 401,543,401, 
402,544,402, 403,545,403, 33172,546,404, 405,547,405, 33174,548,406, 407,549,407, 33176,550,408, 409,551,409, 33178,552,410, 
2, // chain 50
389,553,389, 388,554,388, 401,555,401, 
400,556,400, 
2, // chain 51
409,557,409, 410,558,410, 397,559,397, 
398,560,398, 
13, // chain 52
390,561,390, 389,562,389, 370,563,370, 
369,564,369, 373,565,373, 392,566,392, 33143,567,375, 394,568,394, 33145,569,377, 396,570,396, 33147,571,379, 381,572,381, 398,573,398, 33151,574,383, 385,575,385, 
2, // chain 53
400,576,400, 371,577,371, 370,578,370, 
389,579,389, 
13, // chain 54
372,580,372, 371,581,371, 400,582,400, 
399,583,399, 374,584,374, 33144,585,376, 33171,586,403, 378,587,378, 33173,588,405, 380,589,380, 33175,590,407, 382,591,382, 33152,592,384, 33177,593,409, 386,594,386, 
2, // chain 55
398,595,398, 385,596,385, 386,597,386, 
409,598,409, 
10, // chain 56
411,599,411, 412,600,412, 388,601,388, 
387,602,387, 366,603,366, 33159,604,391, 413,605,413, 33161,606,393, 414,607,414, 33163,608,395, 415,609,415, 33165,610,397, 
2, // chain 57
388,611,388, 412,612,412, 416,613,416, 
401,614,401, 
10, // chain 58
417,615,417, 418,616,418, 410,617,410, 
408,618,408, 419,619,419, 33174,620,406, 367,621,367, 33172,622,404, 420,623,420, 33170,624,402, 401,625,401, 416,626,416, 
2, // chain 59
410,627,410, 418,628,418, 415,629,415, 
397,630,397, 
3, // chain 60
413,631,413, 421,632,421, 422,633,422, 
419,634,419, 33191,635,423, 
11, // chain 61
424,636,424, 425,637,425, 426,638,426, 
427,639,427, 33196,640,428, 429,641,429, 33198,642,430, 431,643,431, 415,644,415, 33200,645,432, 433,646,433, 414,647,414, 33181,648,413, 
4, // chain 62
424,636,424, 427,639,427, 434,649,434, 
33186,650,418, 33197,641,429, 415,644,415, 
9, // chain 63
424,636,424, 434,649,434, 435,651,435, 
33204,652,436, 33205,653,437, 33186,650,418, 438,654,438, 33185,655,417, 439,656,439, 33191,657,423, 33187,658,419, 
12, // chain 64
435,651,435, 436,652,436, 440,659,440, 
33209,660,441, 33210,661,442, 33205,653,437, 443,662,443, 33212,663,444, 33206,654,438, 445,664,445, 33214,665,446, 33207,656,439, 423,657,423, 422,666,422, 
18, // chain 65
442,661,442, 443,662,443, 447,667,447, 
448,668,448, 33217,669,449, 450,670,450, 33219,671,451, 452,672,452, 453,673,453, 33222,674,454, 455,675,455, 456,676,456, 457,677,457, 33226,678,458, 459,679,459, 460,680,460, 33229,681,461, 33230,682,462, 463,683,463, 
33232,684,464, 
4, // chain 66
442,661,442, 448,668,448, 441,660,441, 
33225,677,457, 33218,670,450, 453,673,453, 
9, // chain 67
440,659,440, 441,660,441, 465,685,465, 
33225,677,457, 460,680,460, 440,659,440, 33234,686,466, 33229,681,461, 467,687,467, 33231,683,463, 468,688,468, 
12, // chain 68
469,689,469, 470,690,470, 425,691,425, 
424,692,424, 435,693,435, 471,694,471, 33208,695,440, 472,696,472, 33234,697,466, 473,698,473, 33235,699,467, 474,700,474, 33243,701,475, 33236,702,468, 
4, // chain 69
476,703,476, 473,704,473, 474,705,474, 
477,706,477, 33243,707,475, 478,708,478, 
4, // chain 70
473,709,473, 476,710,476, 479,711,479, 
472,712,472, 33248,713,480, 471,714,471, 
4, // chain 71
471,715,471, 480,716,480, 481,717,481, 
469,718,469, 33238,719,470, 33250,720,482, 
4, // chain 72
483,721,483, 484,722,484, 485,723,485, 
486,724,486, 33255,725,487, 33256,726,488, 
4, // chain 73
486,724,486, 487,725,487, 489,727,489, 
490,728,490, 33259,729,491, 33260,730,492, 
2, // chain 74
490,728,490, 491,729,491, 493,731,493, 
33262,732,494, 
8, // chain 75
490,728,490, 493,731,493, 495,733,495, 
33264,734,496, 497,735,497, 498,736,498, 33267,737,499, 500,738,500, 359,739,359, 33128,740,360, 
6, // chain 76
361,741,361, 360,742,360, 455,743,455, 
454,744,454, 362,745,362, 33220,746,452, 501,747,501, 33219,748,451, 
2, // chain 77
362,745,362, 501,747,501, 502,749,502, 
33271,750,503, 
9, // chain 78
504,751,504, 464,752,464, 462,753,462, 
505,754,505, 33274,755,506, 33227,756,459, 507,757,507, 33226,758,458, 456,759,456, 508,760,508, 33223,761,455, 
5, // chain 79
508,762,508, 455,763,455, 360,764,360, 
509,765,509, 33278,766,510, 511,767,511, 33280,768,512, 
3, // chain 80
508,762,508, 509,765,509, 513,769,513, 
33282,770,514, 33279,767,511, 
4, // chain 81
508,762,508, 513,769,513, 507,771,507, 
33283,772,515, 33284,773,516, 33282,770,514, 
4, // chain 82
507,771,507, 515,772,515, 506,774,506, 
33285,775,517, 33286,776,518, 33284,773,516, 
5, // chain 83
506,774,506, 517,775,517, 505,777,505, 
33272,778,504, 33287,779,519, 33288,780,520, 33286,776,518, 
14, // chain 84
521,781,521, 522,782,522, 523,783,523, 
33292,784,524, 33293,785,525, 33294,786,526, 527,787,527, 528,788,528, 33297,789,529, 530,790,530, 33299,791,531, 532,792,532, 33301,793,533, 534,794,534, 33303,795,535, 33304,796,536, 
14, // chain 85
523,783,523, 524,784,524, 537,797,537, 
33306,798,538, 33307,799,539, 33293,785,525, 528,788,528, 540,800,540, 33298,790,530, 532,792,532, 541,801,541, 33310,802,542, 33311,803,543, 33302,794,534, 544,804,544, 33303,795,535, 
35, // chain 86
537,797,537, 538,798,538, 545,805,545, 
33314,806,546, 33315,807,547, 33316,808,548, 33317,809,549, 33307,799,539, 540,800,540, 541,801,541, 550,810,550, 548,808,548, 33319,811,551, 547,807,547, 33320,812,552, 553,813,553, 33322,814,554, 555,815,555, 556,816,556, 
33325,817,557, 33326,818,558, 559,819,559, 33328,820,560, 33329,821,561, 562,822,562, 563,823,563, 564,824,564, 33333,825,565, 566,826,566, 33335,827,567, 568,828,568, 33337,829,569, 33338,830,570, 571,831,571, 33340,832,572, 
535,833,535, 33312,834,544, 
31, // chain 87
545,805,545, 546,806,546, 573,835,573, 
33342,836,574, 33315,807,547, 553,813,553, 556,816,556, 575,837,575, 573,835,573, 33344,838,576, 33345,839,577, 33346,840,578, 33347,841,579, 580,842,580, 33349,843,581, 33350,844,582, 583,845,583, 33327,819,559, 560,820,560, 
564,824,564, 584,846,584, 33334,826,566, 585,847,585, 33336,828,568, 586,848,586, 33355,849,587, 33337,829,569, 588,850,588, 33339,831,571, 589,851,589, 33358,852,590, 33304,853,536, 33303,833,535, 
1, // chain 88
545,805,545, 573,835,573, 576,838,576, 
3, // chain 89
580,842,580, 581,843,581, 591,854,591, 
33352,846,584, 33351,845,583, 
4, // chain 90
580,842,580, 591,854,591, 592,855,592, 
33361,856,593, 33353,847,585, 33352,846,584, 
4, // chain 91
592,855,592, 593,856,593, 594,857,594, 
33363,858,595, 33354,848,586, 33353,847,585, 
9, // chain 92
594,857,594, 595,858,595, 596,859,596, 
33365,860,597, 33366,861,598, 33354,848,586, 599,862,599, 33355,849,587, 600,863,600, 33356,850,588, 589,851,589, 
1, // chain 93
543,803,543, 544,804,544, 601,864,601, 
4, // chain 94
557,865,557, 559,866,559, 582,867,582, 
556,868,556, 33347,869,579, 575,870,575, 
37, // chain 95
602,871,602, 603,872,603, 604,873,604, 
605,874,605, 33369,875,601, 606,876,606, 33312,877,544, 572,878,572, 607,879,607, 33338,880,570, 567,881,567, 608,882,608, 33377,883,609, 33378,884,610, 33333,885,565, 563,886,563, 562,887,562, 611,888,611, 33329,889,561, 
612,890,612, 33381,891,613, 33326,892,558, 555,893,555, 614,894,614, 33322,895,554, 615,896,615, 33320,897,552, 616,898,616, 33319,899,551, 617,900,617, 33318,901,550, 541,902,541, 618,903,618, 33387,904,619, 33310,905,542, 
620,906,620, 33311,907,543, 604,908,604, 33369,909,601, 
4, // chain 96
602,871,602, 605,874,605, 621,910,621, 
33390,911,622, 33375,879,607, 33374,876,606, 
4, // chain 97
621,910,621, 622,911,622, 623,912,623, 
33392,913,624, 33376,882,608, 33375,879,607, 
3, // chain 98
623,912,623, 624,913,624, 625,914,625, 
33377,883,609, 33376,882,608, 
6, // chain 99
623,912,623, 625,914,625, 626,915,626, 
33395,916,627, 33396,917,628, 33379,888,611, 33378,884,610, 33377,883,609, 
5, // chain 100
627,916,627, 628,917,628, 629,918,629, 
33398,919,630, 33399,920,631, 33380,890,612, 33379,888,611, 
7, // chain 101
629,918,629, 630,919,630, 632,921,632, 
33401,922,633, 33399,920,631, 634,923,634, 33382,894,614, 33381,891,613, 33380,890,612, 
6, // chain 102
632,921,632, 633,922,633, 635,924,635, 
33404,925,636, 33402,923,634, 616,898,616, 33383,896,615, 33382,894,614, 
10, // chain 103
636,925,636, 616,898,616, 617,900,617, 
618,903,618, 635,924,635, 33405,926,637, 33387,904,619, 638,927,638, 33388,906,620, 639,928,639, 33372,908,604, 603,929,603, 
33, // chain 104
640,930,640, 641,931,641, 642,932,642, 
643,933,643, 33412,934,644, 645,935,645, 33414,936,646, 647,937,647, 33133,938,365, 648,939,648, 33189,940,421, 649,941,649, 33418,942,650, 33419,943,651, 652,944,652, 653,945,653, 654,946,654, 33423,947,655, 656,948,656, 
657,949,657, 33426,950,658, 659,951,659, 660,952,660, 661,953,661, 649,941,649, 33416,939,648, 33430,954,662, 647,937,647, 33431,955,663, 645,935,645, 33432,956,664, 665,957,665, 643,933,643, 33408,930,640, 33434,958,666, 
2, // chain 105
654,946,654, 657,949,657, 650,942,650, 
33417,941,649, 
9, // chain 106
642,959,642, 641,960,641, 667,961,667, 
668,962,668, 644,963,644, 33437,964,669, 670,965,670, 671,966,671, 33179,967,411, 365,968,365, 33134,969,366, 
2, // chain 107
644,963,644, 671,966,671, 646,970,646, 
33133,968,365, 
8, // chain 108
431,971,431, 430,972,430, 655,973,655, 
653,974,653, 432,975,432, 33420,976,652, 433,977,433, 33419,978,651, 413,979,413, 33189,980,421, 
2, // chain 109
421,981,421, 365,982,365, 364,983,364, 
422,984,422, 
2, // chain 110
413,985,413, 419,986,419, 367,987,367, 
366,988,366, 
35, // chain 111
672,989,672, 673,990,673, 674,991,674, 
675,992,675, 33444,993,676, 33445,994,677, 678,995,678, 679,996,679, 33217,997,449, 680,998,680, 33215,999,447, 681,1000,681, 33211,1001,443, 682,1002,682, 33212,1003,444, 683,1004,683, 33213,1005,445, 446,1006,446, 684,1007,684, 
33190,1008,422, 685,1009,685, 33132,1010,364, 686,1011,686, 687,1012,687, 688,1013,688, 33457,1014,689, 690,1015,690, 33459,1016,691, 692,1017,692, 33271,1018,503, 693,1019,693, 33269,1020,501, 694,1021,694, 33219,1022,451, 695,1023,695, 
33446,1024,678, 33217,1025,449, 
32, // chain 112
672,989,672, 675,992,675, 696,1026,696, 
33465,1027,697, 33444,993,676, 698,1028,698, 33447,996,679, 699,1029,699, 33448,998,680, 700,1030,700, 33449,1000,681, 701,1031,701, 33450,1002,682, 702,1032,702, 33451,1004,683, 703,1033,703, 33452,1007,684, 704,1034,704, 33453,1009,685, 
688,1013,688, 705,1035,705, 33458,1015,690, 706,1036,706, 33460,1017,692, 707,1037,707, 33461,1019,693, 694,1021,694, 708,1038,708, 33477,1039,709, 33463,1023,695, 710,1040,710, 33479,1041,711, 33445,1042,677, 33446,1024,678, 
30, // chain 113
696,1026,696, 697,1027,697, 712,1043,712, 
33481,1044,713, 33466,1028,698, 714,1045,714, 33467,1029,699, 715,1046,715, 33468,1030,700, 716,1047,716, 33469,1031,701, 717,1048,717, 33470,1032,702, 718,1049,718, 33471,1033,703, 719,1050,719, 33472,1034,704, 705,1035,705, 720,1051,720, 
33474,1036,706, 721,1052,721, 33475,1037,707, 708,1038,708, 722,1053,722, 33477,1039,709, 723,1054,723, 33478,1040,710, 724,1055,724, 33479,1041,711, 725,1056,725, 33442,1057,674, 33445,1042,677, 
26, // chain 114
712,1043,712, 713,1044,713, 726,1058,726, 
33495,1059,727, 33482,1045,714, 728,1060,728, 33483,1046,715, 729,1061,729, 33484,1047,716, 717,1048,717, 718,1049,718, 730,1062,730, 33487,1050,719, 720,1051,720, 731,1063,731, 33489,1052,721, 732,1064,732, 33501,1065,733, 33490,1053,722, 
734,1066,734, 33491,1054,723, 724,1055,724, 735,1067,735, 33504,1068,736, 33505,1069,737, 33493,1056,725, 673,1070,673, 33442,1057,674, 
14, // chain 115
726,1058,726, 727,1059,727, 738,1071,738, 
33507,1072,739, 33508,1073,740, 33496,1060,728, 729,1061,729, 730,1062,730, 731,1063,731, 732,1064,732, 741,1074,741, 33501,1065,733, 742,1075,742, 33502,1066,734, 743,1076,743, 33503,1067,735, 
5, // chain 116
740,1073,740, 741,1074,741, 739,1072,739, 
33506,1071,738, 33512,1077,744, 33510,1075,742, 743,1076,743, 
11, // chain 117
745,1078,745, 738,1079,738, 744,1080,744, 
746,1081,746, 33511,1082,743, 747,1083,747, 33503,1084,735, 736,1085,736, 748,1086,748, 33505,1087,737, 749,1088,749, 33441,1089,673, 750,1090,750, 
6, // chain 118
712,1091,712, 726,1092,726, 751,1093,751, 
696,1094,696, 33520,1095,752, 672,1096,672, 33518,1097,750, 673,1098,673, 
2, // chain 119
753,1099,753, 754,1100,754, 755,1101,755, 
756,1102,756, 
13, // chain 120
757,1103,757, 758,1104,758, 759,1105,759, 
760,1106,760, 33529,1107,761, 762,1108,762, 763,1109,763, 33532,1110,764, 765,1111,765, 766,1112,766, 33535,1113,767, 33536,1114,768, 769,1115,769, 33538,1116,770, 33539,1117,771, 
3, // chain 121
772,1118,772, 773,1119,773, 774,1120,774, 
775,1121,775, 33544,1122,776, 
62, // chain 122
777,1123,777, 750,1124,750, 752,1125,752, 
778,1126,778, 33547,1127,779, 33519,1128,751, 780,1129,780, 33494,1130,726, 763,1131,763, 33506,1132,738, 760,1133,760, 33525,1134,757, 33513,1135,745, 781,1136,781, 33514,1137,746, 782,1138,782, 33515,1139,747, 783,1140,783, 33516,1141,748, 
784,1142,784, 33517,1143,749, 774,1144,774, 33518,1145,750, 776,1146,776, 33545,1147,777, 785,1148,785, 786,1149,786, 787,1150,787, 33556,1151,788, 789,1152,789, 33558,1153,790, 791,1154,791, 792,1155,792, 33561,1156,793, 794,1157,794, 
33563,1158,795, 796,1159,796, 797,1160,797, 33566,1161,798, 33567,1162,799, 800,1163,800, 801,1164,801, 33570,1165,802, 803,1166,803, 33572,1167,804, 805,1168,805, 33574,1169,806, 807,1170,807, 33576,1171,808, 33577,1172,809, 810,1173,810, 
33579,1174,811, 812,1175,812, 813,1176,813, 33582,1177,814, 815,1178,815, 33584,1179,816, 817,1180,817, 33586,1181,818, 819,1182,819, 33588,1183,820, 33589,1184,821, 788,1185,788, 33558,1186,790, 
7, // chain 123
777,1123,777, 778,1126,778, 785,1187,785, 
33537,1188,769, 33535,1189,767, 33547,1127,779, 766,1190,766, 33548,1129,780, 763,1131,763, 
21, // chain 124
785,1187,785, 769,1188,769, 822,1191,822, 
33538,1192,770, 823,1193,823, 33592,1194,824, 33539,1195,771, 825,1196,825, 33536,1197,768, 826,1198,826, 33533,1199,765, 827,1200,827, 33532,1201,764, 828,1202,828, 33530,1203,762, 761,1204,761, 829,1205,829, 33527,1206,759, 830,1207,830, 
33526,1208,758, 756,1209,756, 33549,1136,781, 33525,1134,757, 
32, // chain 125
785,1187,785, 822,1191,822, 786,1210,786, 
33588,1183,820, 33587,1182,819, 33591,1193,823, 824,1194,824, 817,1180,817, 33583,1178,815, 33593,1196,825, 826,1198,826, 813,1176,813, 33595,1200,827, 810,1173,810, 33576,1171,808, 33596,1202,828, 807,1170,807, 33597,1205,829, 830,1207,830, 
805,1168,805, 33599,1211,831, 33524,1209,756, 755,1212,755, 832,1213,832, 33601,1214,833, 33522,1215,754, 834,1216,834, 33541,1217,773, 33552,1142,784, 33551,1140,783, 33550,1138,782, 33521,1218,753, 756,1209,756, 781,1136,781, 
1, // chain 126
786,1210,786, 820,1183,820, 788,1185,788, 
19, // chain 127
803,1166,803, 805,1168,805, 831,1211,831, 
832,1213,832, 801,1164,801, 33601,1214,833, 798,1161,798, 33602,1216,834, 797,1160,797, 33562,1157,794, 33603,1219,835, 33541,1217,773, 772,1220,772, 836,1221,836, 33543,1222,775, 776,1146,776, 787,1150,787, 789,1152,789, 792,1155,792, 
835,1219,835, 33562,1157,794, 
1, // chain 128
773,1217,773, 784,1142,784, 774,1144,774, 
14, // chain 129
809,1223,809, 806,1224,806, 804,1225,804, 
811,1226,811, 33605,1227,837, 33606,1228,838, 33570,1229,802, 800,1230,800, 839,1231,839, 33567,1232,799, 840,1233,840, 33564,1234,796, 841,1235,841, 33559,1236,791, 33563,1237,795, 793,1238,793, 
3, // chain 130
841,1235,841, 791,1236,791, 842,1239,842, 
33558,1240,790, 843,1241,843, 
8, // chain 131
811,1226,811, 837,1227,837, 844,1242,844, 
812,1243,812, 33582,1244,814, 33613,1245,845, 846,1246,846, 821,1247,821, 33611,1248,843, 790,1249,790, 
2, // chain 132
821,1247,821, 818,1250,818, 814,1244,814, 
33584,1251,816, 
280, // chain 133
839,1252,839, 840,1253,840, 847,1254,847, 
848,1255,848, 33617,1256,849, 33618,1257,850, 851,1258,851, 33620,1259,852, 853,1260,853, 33622,1261,854, 855,1262,855, 33624,1263,856, 857,1264,857, 33626,1265,858, 859,1266,859, 33628,1267,860, 861,1268,861, 33630,1269,862, 863,1270,863, 
864,1271,864, 33633,1272,865, 866,1273,866, 867,1274,867, 861,1268,861, 33627,1266,859, 33636,1275,868, 869,1276,869, 857,1264,857, 33638,1277,870, 855,1262,855, 33621,1260,853, 33639,1278,871, 872,1279,872, 33641,1280,873, 874,1281,874, 
33643,1282,875, 876,1283,876, 33645,1284,877, 878,1285,878, 879,1286,879, 33648,1287,880, 33649,1288,881, 882,1289,882, 33651,1290,883, 884,1291,884, 33653,1292,885, 886,1293,886, 33655,1294,887, 888,1295,888, 889,1296,889, 33658,1297,890, 
891,1298,891, 33660,1299,892, 893,1300,893, 894,1301,894, 33663,1302,895, 896,1303,896, 33665,1304,897, 898,1305,898, 899,1306,899, 33668,1307,900, 33669,1308,901, 902,1309,902, 903,1310,903, 33672,1311,904, 33673,1312,905, 906,1313,906, 
33675,1314,907, 908,1315,908, 33677,1316,909, 910,1317,910, 33679,1318,911, 912,1319,912, 33681,1320,913, 914,1321,914, 915,1322,915, 33684,1323,916, 917,1324,917, 918,1325,918, 33687,1326,919, 920,1327,920, 33689,1328,921, 922,1329,922, 
33691,1330,923, 924,1331,924, 925,1332,925, 33694,1333,926, 33695,1334,927, 928,1335,928, 929,1336,929, 33698,1337,930, 931,1338,931, 33700,1339,932, 33701,1340,933, 934,1341,934, 33703,1342,935, 936,1343,936, 33705,1344,937, 938,1345,938, 
33707,1346,939, 940,1347,940, 941,1348,941, 33710,1349,942, 943,1350,943, 33712,1351,944, 945,1352,945, 946,1353,946, 33715,1354,947, 948,1355,948, 33717,1356,949, 950,1357,950, 951,1358,951, 33720,1359,952, 33721,1360,953, 954,1361,954, 
955,1362,955, 33724,1363,956, 957,1364,957, 33726,1365,958, 33727,1366,959, 960,1367,960, 33729,1368,961, 962,1369,962, 33731,1370,963, 964,1371,964, 33733,1372,965, 966,1373,966, 967,1374,967, 33736,1375,968, 969,1376,969, 33738,1377,970, 
971,1378,971, 972,1379,972, 33741,1380,973, 33742,1381,974, 33738,1382,970, 968,1383,968, 975,1384,975, 33734,1385,966, 965,1386,965, 976,1387,976, 33745,1388,977, 33731,1389,963, 978,1390,978, 33729,1391,961, 979,1392,979, 33727,1393,959, 
980,1394,980, 33724,1395,956, 981,1396,981, 33722,1397,954, 982,1398,982, 33721,1399,953, 983,1400,983, 33718,1401,950, 949,1402,949, 984,1403,984, 33753,1404,985, 33715,1405,947, 986,1406,986, 33713,1407,945, 944,1408,944, 942,1409,942, 
987,1410,987, 33708,1411,940, 939,1412,939, 988,1413,988, 33757,1414,989, 33705,1415,937, 990,1416,990, 33703,1417,935, 991,1418,991, 33701,1419,933, 992,1420,992, 33698,1421,930, 993,1422,993, 33696,1423,928, 994,1424,994, 33695,1425,927, 
995,1426,995, 33692,1427,924, 923,1428,923, 996,1429,996, 33765,1430,997, 33689,1431,921, 998,1432,998, 33687,1433,919, 917,1434,917, 916,1435,916, 999,1436,999, 33682,1437,914, 913,1438,913, 1000,1439,1000, 33769,1440,1001, 33679,1441,911, 
1002,1442,1002, 33677,1443,909, 1003,1444,1003, 33675,1445,907, 1004,1446,1004, 33673,1447,905, 902,1448,902, 1005,1449,1005, 33774,1450,1006, 33669,1451,901, 1007,1452,1007, 33666,1453,898, 897,1454,897, 1008,1455,1008, 33777,1456,1009, 33663,1457,895, 
1010,1458,1010, 33661,1459,893, 892,1460,892, 890,1461,890, 1011,1462,1011, 33656,1463,888, 887,1464,887, 1012,1465,1012, 33781,1466,1013, 33653,1467,885, 1014,1468,1014, 33651,1469,883, 1015,1470,1015, 33649,1471,881, 1016,1472,1016, 33646,1473,878, 
877,1474,877, 1017,1475,1017, 33786,1476,1018, 33643,1477,875, 873,1478,873, 1019,1479,1019, 33639,1480,871, 1020,1481,1020, 33638,1482,870, 869,1483,869, 1021,1484,1021, 33636,1485,868, 1022,1486,1022, 33791,1487,1023, 33635,1488,867, 866,1489,866, 
1024,1490,1024, 33633,1491,865, 1025,1492,1025, 33631,1493,863, 862,1494,862, 860,1495,860, 1026,1496,1026, 33795,1497,1027, 33626,1498,858, 1028,1499,1028, 33624,1500,856, 1029,1501,1029, 33622,1502,854, 852,1503,852, 1030,1504,1030, 33799,1505,1031, 
33618,1506,850, 847,1507,847, 1032,1508,1032, 33608,1509,840, 841,1510,841, 842,1511,842, 1033,1512,1033, 33611,1513,843, 1034,1514,1034, 33803,1515,1035, 33804,1516,1036, 33614,1517,846, 845,1518,845, 1037,1519,1037, 33806,1520,1038, 33612,1521,844, 
1039,1522,1039, 33605,1523,837, 1040,1524,1040, 33606,1525,838, 1041,1526,1041, 33616,1255,848, 33607,1252,839, 
22, // chain 134
1041,1526,1041, 848,1255,848, 849,1256,849, 
1042,1527,1042, 33811,1528,1043, 33619,1258,851, 853,1260,853, 872,1279,872, 1044,1529,1044, 33642,1281,874, 876,1283,876, 1045,1530,1045, 33647,1286,879, 903,1310,903, 33648,1287,880, 900,1307,900, 33667,1306,899, 33650,1289,882, 896,1303,896, 
33652,1291,884, 894,1301,894, 33654,1293,886, 891,1298,891, 33657,1296,889, 
12, // chain 135
1038,1520,1038, 1039,1522,1039, 1046,1531,1046, 
33815,1532,1047, 33816,1533,1048, 33808,1524,1040, 1049,1534,1049, 33818,1535,1050, 33809,1526,1041, 1042,1527,1042, 1051,1536,1051, 33820,1537,1052, 33812,1529,1044, 33811,1528,1043, 
16, // chain 136
1038,1520,1038, 1046,1531,1046, 1037,1519,1037, 
33821,1538,1053, 33822,1539,1054, 33815,1532,1047, 1055,1540,1055, 33824,1541,1056, 33816,1533,1048, 1049,1534,1049, 1057,1542,1057, 33818,1535,1050, 1051,1536,1051, 1058,1543,1058, 33820,1537,1052, 1059,1544,1059, 33813,1530,1045, 33812,1529,1044, 
13, // chain 137
1035,1515,1035, 1036,1516,1036, 1060,1545,1060, 
33805,1519,1037, 1053,1538,1053, 1061,1546,1061, 33830,1547,1062, 33822,1539,1054, 1063,1548,1063, 33832,1549,1064, 33823,1540,1055, 1065,1550,1065, 33824,1541,1056, 1058,1543,1058, 33825,1542,1057, 
3, // chain 138
1066,1551,1066, 1059,1544,1059, 1045,1530,1045, 
904,1311,904, 33671,1310,903, 
15, // chain 139
1058,1543,1058, 1059,1544,1059, 1067,1552,1067, 
33834,1551,1066, 1068,1553,1068, 33697,1336,929, 33672,1311,904, 906,1313,906, 926,1333,926, 33693,1332,925, 33676,1315,908, 922,1329,922, 33678,1317,910, 920,1327,920, 33680,1319,912, 918,1325,918, 33683,1322,915, 
7, // chain 140
1058,1543,1058, 1067,1552,1067, 1065,1550,1065, 
33832,1549,1064, 33836,1553,1068, 1063,1548,1063, 33723,1362,955, 33699,1338,931, 33697,1336,929, 
5, // chain 141
1062,1547,1062, 1063,1548,1063, 1069,1554,1069, 
33838,1555,1070, 33839,1556,1071, 33725,1364,957, 33723,1362,955, 
9, // chain 142
1061,1546,1061, 1062,1547,1062, 1069,1554,1069, 
1072,1557,1072, 33841,1558,1073, 33838,1555,1070, 1074,1559,1074, 33839,1556,1071, 1075,1560,1075, 33726,1365,958, 33725,1364,957, 
21, // chain 143
1060,1545,1060, 1061,1546,1061, 1076,1561,1076, 
33840,1557,1072, 1077,1562,1077, 33841,1558,1073, 1078,1563,1078, 33847,1564,1079, 33848,1565,1080, 33842,1559,1074, 1081,1566,1081, 33850,1567,1082, 33843,1560,1075, 1083,1568,1083, 33852,1569,1084, 33726,1365,958, 960,1367,960, 1085,1570,1085, 33730,1369,962, 
972,1379,972, 33732,1371,964, 969,1376,969, 33735,1374,967, 
21, // chain 144
1060,1545,1060, 1076,1561,1076, 1035,1515,1035, 
33802,1514,1034, 33854,1571,1086, 33845,1562,1077, 1087,1572,1087, 33856,1573,1088, 33846,1563,1078, 1089,1574,1089, 33858,1575,1090, 33847,1564,1079, 980,1394,980, 33848,1565,1080, 979,1392,979, 33849,1566,1081, 978,1390,978, 33859,1576,1091, 33850,1567,1082, 
1083,1568,1083, 1092,1577,1092, 33853,1570,1085, 33852,1569,1084, 
3, // chain 145
951,1358,951, 952,1359,952, 932,1339,932, 
33723,1362,955, 931,1338,931, 
7, // chain 146
932,1339,932, 934,1341,934, 951,1358,951, 
33716,1355,948, 33704,1343,936, 946,1353,946, 33706,1345,938, 943,1350,943, 33709,1348,941, 
28, // chain 147
1093,1578,1093, 1094,1579,1094, 1095,1580,1095, 
1096,1581,1096, 33865,1582,1097, 33866,1583,1098, 1099,1584,1099, 1100,1585,1100, 33869,1586,1101, 33870,1587,1102, 1103,1588,1103, 33872,1589,1104, 1105,1590,1105, 33874,1591,1106, 1107,1592,1107, 33876,1593,1108, 1109,1594,1109, 33878,1595,1110, 1111,1596,1111, 
33880,1597,1112, 1094,1598,1094, 1093,1599,1093, 1113,1600,1113, 1114,1601,1114, 33883,1602,1115, 1116,1603,1116, 33885,1604,1117, 33886,1605,1118, 1119,1606,1119, 33888,1607,1120, 
24, // chain 148
1093,1578,1093, 1096,1581,1096, 1113,1608,1113, 
33889,1609,1121, 33890,1610,1122, 33865,1582,1097, 1100,1585,1100, 1123,1611,1123, 33869,1586,1101, 1124,1612,1124, 33871,1588,1103, 1125,1613,1125, 33894,1614,1126, 33873,1590,1105, 1127,1615,1127, 33875,1592,1107, 1128,1616,1128, 33877,1594,1109, 1111,1596,1111, 
1114,1601,1114, 1129,1617,1129, 33884,1603,1116, 1130,1618,1130, 33885,1604,1117, 1131,1619,1131, 33887,1606,1119, 
15, // chain 149
1113,1608,1113, 1121,1609,1121, 1132,1620,1132, 
33901,1621,1133, 33890,1610,1122, 1123,1611,1123, 1134,1622,1134, 33892,1612,1124, 1135,1623,1135, 33893,1613,1125, 1136,1624,1136, 33894,1614,1126, 1137,1625,1137, 33895,1615,1127, 1138,1626,1138, 33897,1617,1129, 33896,1616,1128, 
19, // chain 150
1113,1608,1113, 1132,1620,1132, 1115,1627,1115, 
33886,1628,1118, 33907,1629,1139, 33908,1630,1140, 33909,1631,1141, 33901,1621,1133, 1142,1632,1142, 33902,1622,1134, 1135,1623,1135, 1143,1633,1143, 33904,1624,1136, 1144,1634,1144, 33913,1635,1145, 33914,1636,1146, 33905,1625,1137, 1138,1626,1138, 1147,1637,1147, 
33898,1618,1130, 33897,1617,1129, 
18, // chain 151
1118,1628,1118, 1139,1629,1139, 1148,1638,1148, 
33917,1639,1149, 33908,1630,1140, 1141,1631,1141, 1150,1640,1150, 33910,1632,1142, 1143,1633,1143, 1151,1641,1151, 33920,1642,1152, 33912,1634,1144, 1153,1643,1153, 33913,1635,1145, 1154,1644,1154, 33914,1636,1146, 1155,1645,1155, 33915,1637,1147, 1131,1619,1131, 
33898,1618,1130, 
1, // chain 152
1118,1628,1118, 1148,1638,1148, 1120,1646,1120, 
91, // chain 153
1156,1647,1156, 1157,1648,1157, 1158,1649,1158, 
1159,1650,1159, 33928,1651,1160, 1161,1652,1161, 33930,1653,1162, 1163,1654,1163, 33932,1655,1164, 1165,1656,1165, 33934,1657,1166, 1167,1658,1167, 33936,1659,1168, 33937,1660,1169, 1170,1661,1170, 33939,1662,1171, 1172,1663,1172, 33941,1664,1173, 1174,1665,1174, 
33943,1666,1175, 1176,1667,1176, 1177,1668,1177, 33946,1669,1178, 1179,1670,1179, 33948,1671,1180, 1181,1672,1181, 33950,1673,1182, 1183,1674,1183, 33952,1675,1184, 1185,1676,1185, 1186,1677,1186, 33955,1678,1187, 1188,1679,1188, 33957,1680,1189, 1157,1681,1157, 
1156,1682,1156, 1190,1683,1190, 33959,1684,1191, 1120,1685,1120, 1148,1686,1148, 1192,1687,1192, 33917,1688,1149, 1193,1689,1193, 33918,1690,1150, 1151,1691,1151, 1194,1692,1194, 33920,1693,1152, 1195,1694,1195, 33964,1695,1196, 33921,1696,1153, 1197,1697,1197, 
33922,1698,1154, 1155,1699,1155, 1198,1700,1198, 33967,1701,1199, 33899,1702,1131, 1200,1703,1200, 33887,1704,1119, 1120,1705,1120, 1191,1706,1191, 1156,1647,1156, 1159,1650,1159, 1199,1701,1199, 33969,1707,1201, 33929,1652,1161, 1163,1654,1163, 1202,1708,1202, 
33971,1709,1203, 33933,1656,1165, 1204,1710,1204, 33935,1658,1167, 1205,1711,1205, 33936,1659,1168, 1206,1712,1206, 33938,1661,1170, 1207,1713,1207, 33940,1663,1172, 1208,1714,1208, 33942,1665,1174, 1198,1700,1198, 33965,1697,1197, 33945,1668,1177, 1196,1695,1196, 
33963,1694,1195, 33947,1670,1179, 1194,1692,1194, 33949,1672,1181, 1183,1674,1183, 1193,1689,1193, 33954,1677,1186, 1192,1687,1192, 33956,1679,1188, 1190,1683,1190, 
5, // chain 154
1201,1707,1201, 1202,1708,1202, 1207,1713,1207, 
33971,1709,1203, 1206,1712,1206, 33973,1711,1205, 33972,1710,1204, 
3, // chain 155
1201,1707,1201, 1207,1713,1207, 1208,1714,1208, 
1199,1701,1199, 33966,1700,1198, 
16, // chain 156
1169,1715,1169, 1166,1716,1166, 1164,1717,1164, 
1171,1718,1171, 33930,1719,1162, 1173,1720,1173, 33928,1721,1160, 1175,1722,1175, 33926,1723,1158, 1176,1724,1176, 33946,1725,1178, 33925,1726,1157, 1180,1727,1180, 33957,1728,1189, 1182,1729,1182, 33955,1730,1187, 1184,1731,1184, 33953,1732,1185, 
12, // chain 157
499,1733,499, 497,1734,497, 1209,1735,1209, 
1210,1736,1210, 33979,1737,1211, 1212,1738,1212, 1213,1739,1213, 1214,1740,1214, 33280,1741,512, 510,1742,510, 360,1743,360, 500,1744,500, 1210,1736,1210, 33267,1733,499, 
4, // chain 158
496,1745,496, 493,1746,493, 1215,1747,1215, 
1216,1748,1216, 33985,1749,1217, 1218,1750,1218, 
4, // chain 159
493,1751,493, 494,1752,494, 1219,1753,1219, 
1215,1754,1215, 33988,1755,1220, 1217,1756,1217, 
4, // chain 160
497,1757,497, 496,1758,496, 1216,1759,1216, 
1209,1760,1209, 33986,1761,1218, 1211,1762,1211, 
4, // chain 161
492,1763,492, 489,1764,489, 1221,1765,1221, 
1222,1766,1222, 33991,1767,1223, 1224,1768,1224, 
12, // chain 162
1225,1769,1225, 1226,1770,1226, 1227,1771,1227, 
1228,1772,1228, 33997,1773,1229, 1230,1774,1230, 33999,1775,1231, 1232,1776,1232, 1233,1777,1233, 1234,1778,1234, 1228,1772,1228, 34003,1779,1235, 1236,1780,1236, 1225,1769,1225, 
4, // chain 163
1237,1781,1237, 1238,1782,1238, 1239,1783,1239, 
1240,1784,1240, 1241,1785,1241, 34010,1786,1242, 
4, // chain 164
1243,1787,1243, 1244,1788,1244, 1238,1789,1238, 
1237,1790,1237, 1245,1791,1245, 34009,1792,1241, 
4, // chain 165
1240,1793,1240, 1239,1794,1239, 1226,1795,1226, 
1225,1796,1225, 1242,1797,1242, 34004,1798,1236, 
4, // chain 166
1246,1799,1246, 1247,1800,1247, 1248,1801,1248, 
1249,1802,1249, 1250,1803,1250, 34019,1804,1251, 
4, // chain 167
1252,1805,1252, 1253,1806,1253, 1254,1807,1254, 
1255,1808,1255, 1256,1809,1256, 1257,1810,1257, 
2, // chain 168
1254,1811,1254, 1253,1812,1253, 1258,1813,1258, 
1259,1814,1259, 
4, // chain 169
1254,1815,1254, 1259,1816,1259, 1260,1817,1260, 
1255,1818,1255, 34024,1819,1256, 34029,1820,1261, 
2, // chain 170
1257,1821,1257, 1256,1822,1256, 1261,1823,1261, 
1262,1824,1262, 
4, // chain 171
1257,1825,1257, 1262,1826,1262, 1263,1827,1263, 
1252,1828,1252, 34021,1829,1253, 34026,1830,1258, 
4, // chain 172
1264,1831,1264, 1265,1832,1265, 1266,1833,1266, 
1267,1834,1267, 1268,1835,1268, 1269,1836,1269, 
4, // chain 173
1270,1837,1270, 1269,1838,1269, 1268,1839,1268, 
1271,1840,1271, 1272,1841,1272, 1273,1842,1273, 
4, // chain 174
1274,1843,1274, 1275,1844,1275, 1276,1845,1276, 
1277,1846,1277, 1266,1847,1266, 1265,1848,1265, 
4, // chain 175
1276,1849,1276, 1275,1850,1275, 1278,1851,1278, 
1279,1852,1279, 34040,1853,1272, 34041,1854,1273, 
20, // chain 176
1094,1855,1094, 1280,1856,1280, 1095,1857,1095, 
34049,1858,1281, 34050,1859,1282, 1283,1860,1283, 34052,1861,1284, 34053,1862,1285, 1286,1863,1286, 1287,1864,1287, 34056,1865,1288, 1289,1866,1289, 1290,1867,1290, 34059,1868,1291, 1292,1869,1292, 34061,1870,1293, 1294,1871,1294, 34063,1872,1295, 1296,1873,1296, 
34065,1874,1297, 1298,1875,1298, 34067,1876,1299, 
7, // chain 177
1095,1857,1095, 1281,1858,1281, 1300,1877,1300, 
34051,1860,1283, 1301,1878,1301, 34052,1861,1284, 1302,1879,1302, 34058,1867,1290, 34055,1864,1287, 
16, // chain 178
1095,1857,1095, 1300,1877,1300, 1098,1880,1098, 
33867,1881,1099, 34071,1882,1303, 34072,1883,1304, 34069,1878,1301, 1302,1879,1302, 1305,1884,1305, 34058,1867,1290, 1306,1885,1306, 34060,1869,1292, 1307,1886,1307, 34062,1871,1294, 1308,1887,1308, 34064,1873,1296, 1309,1888,1309, 34066,1875,1298, 
26, // chain 179
1099,1881,1099, 1303,1882,1303, 1310,1889,1310, 
34072,1883,1304, 1311,1890,1311, 34073,1884,1305, 1306,1885,1306, 1312,1891,1312, 34075,1886,1307, 1313,1892,1313, 34076,1887,1308, 1314,1893,1314, 34083,1894,1315, 1316,1895,1316, 34085,1896,1317, 1318,1897,1318, 1319,1898,1319, 34088,1899,1320, 1321,1900,1321, 
34090,1901,1322, 1323,1902,1323, 34053,1903,1285, 34054,1904,1286, 34092,1905,1324, 34093,1906,1325, 1326,1907,1326, 1327,1908,1327, 34096,1909,1328, 
7, // chain 180
1099,1881,1099, 1310,1889,1310, 1102,1910,1102, 
33872,1911,1104, 34097,1912,1329, 34079,1890,1311, 1312,1891,1312, 1330,1913,1330, 34081,1892,1313, 
13, // chain 181
1104,1911,1104, 1329,1912,1329, 1106,1914,1106, 
34098,1913,1330, 1108,1915,1108, 34099,1916,1331, 1110,1917,1110, 34100,1918,1332, 1333,1919,1333, 1112,1920,1112, 33862,1921,1094, 34048,1922,1280, 34050,1923,1282, 34091,1902,1323, 1285,1903,1285, 
4, // chain 182
1321,1900,1321, 1323,1902,1323, 1334,1924,1334, 
1335,1925,1335, 1314,1893,1314, 34081,1892,1313, 
2, // chain 183
1321,1900,1321, 1314,1893,1314, 1319,1898,1319, 
34084,1895,1316, 
2, // chain 184
1336,1926,1336, 1337,1927,1337, 1323,1928,1323, 
1333,1929,1333, 
8, // chain 185
1338,1930,1338, 1337,1931,1337, 1336,1932,1336, 
1339,1933,1339, 1340,1934,1340, 1341,1935,1341, 34110,1936,1342, 1343,1937,1343, 34112,1938,1344, 1345,1939,1345, 
2, // chain 186
1313,1940,1313, 1345,1941,1345, 1344,1942,1344, 
1330,1943,1330, 
7, // chain 187
1334,1944,1334, 1323,1928,1323, 1337,1945,1337, 
1338,1946,1338, 1341,1947,1341, 1335,1948,1335, 34111,1949,1343, 1345,1950,1345, 1313,1951,1313, 
7, // chain 188
1339,1952,1339, 1336,1953,1336, 1333,1929,1333, 
1332,1954,1332, 1340,1955,1340, 34099,1956,1331, 1342,1957,1342, 34112,1958,1344, 34098,1959,1330, 
8, // chain 189
1315,1960,1315, 1308,1961,1308, 1309,1962,1309, 
1346,1963,1346, 1317,1964,1317, 34086,1965,1318, 34115,1966,1347, 1320,1967,1320, 34093,1968,1325, 1322,1969,1322, 
2, // chain 190
1324,1905,1324, 1327,1908,1327, 1288,1970,1288, 
1286,1904,1286, 
33, // chain 191
1348,1971,1348, 1349,1972,1349, 1350,1973,1350, 
34119,1974,1351, 34120,1975,1352, 34121,1976,1353, 1354,1977,1354, 1355,1978,1355, 34124,1979,1356, 34125,1980,1357, 1358,1981,1358, 1359,1982,1359, 34128,1983,1360, 1361,1984,1361, 34130,1985,1362, 34131,1986,1363, 1364,1987,1364, 34133,1988,1365, 1366,1989,1366, 
34135,1990,1367, 34136,1991,1368, 1348,1992,1348, 1350,1993,1350, 1369,1994,1369, 34138,1995,1370, 1371,1996,1371, 1372,1997,1372, 34141,1998,1373, 1374,1999,1374, 34143,2000,1375, 1376,2001,1376, 1377,2002,1377, 1378,2003,1378, 34147,2004,1379, 34148,2005,1380, 
41, // chain 192
1350,1973,1350, 1351,1974,1351, 1370,2006,1370, 
34149,2007,1381, 34120,1975,1352, 1382,2008,1382, 34151,2009,1383, 34123,1978,1355, 1356,1979,1356, 1384,2010,1384, 34127,1982,1359, 1385,2011,1385, 34129,1984,1361, 1386,2012,1386, 34130,1985,1362, 1387,2013,1387, 34132,1987,1364, 1388,2014,1388, 34134,1989,1366, 
1389,2015,1389, 34158,2016,1390, 34135,1990,1367, 1369,1994,1369, 1372,1997,1372, 1391,2017,1391, 1389,2015,1389, 34160,2018,1392, 1393,2019,1393, 1388,2014,1388, 34162,2020,1394, 1387,2013,1387, 34163,2021,1395, 1386,2012,1386, 34164,2022,1396, 1385,2011,1385, 
34165,2023,1397, 34166,2024,1398, 34167,2025,1399, 1400,2026,1400, 34169,2027,1401, 1402,2028,1402, 34147,2029,1379, 34171,2030,1403, 
26, // chain 193
1404,2031,1404, 1405,2032,1405, 1406,2033,1406, 
1407,2034,1407, 34176,2035,1408, 1409,2036,1409, 34178,2037,1410, 34179,2038,1411, 1412,2039,1412, 34181,2040,1413, 1414,2041,1414, 34183,2042,1415, 1416,2043,1416, 1417,2044,1417, 34186,2045,1418, 1419,2046,1419, 34188,2047,1420, 1421,2048,1421, 34190,2049,1422, 
1423,2050,1423, 34192,2051,1424, 34193,2052,1425, 1426,2053,1426, 1427,2054,1427, 34173,2055,1405, 1404,2056,1404, 1428,2057,1428, 34197,2058,1429, 
23, // chain 194
1404,2031,1404, 1407,2034,1407, 1429,2059,1429, 
34198,2060,1430, 34199,2061,1431, 34177,2036,1409, 1432,2062,1432, 34178,2037,1410, 1433,2063,1433, 34180,2039,1412, 1434,2064,1434, 34182,2041,1414, 1417,2044,1417, 1435,2065,1435, 34187,2046,1419, 1436,2066,1436, 34189,2048,1421, 1437,2067,1437, 34206,2068,1438, 
34191,2050,1423, 1439,2069,1439, 34192,2051,1424, 1440,2070,1440, 34195,2054,1427, 1428,2057,1428, 
8, // chain 195
639,2071,639, 603,2072,603, 1441,2073,1441, 
1442,2074,1442, 34211,2075,1443, 34212,2076,1444, 1445,2077,1445, 34214,2078,1446, 1327,2079,1327, 34056,2080,1288, 
7, // chain 196
639,2071,639, 1442,2074,1442, 1447,2081,1447, 
34216,2082,1448, 34211,2075,1443, 1449,2083,1449, 34213,2077,1445, 1328,2084,1328, 34095,2079,1327, 
8, // chain 197
639,2071,639, 1447,2081,1447, 638,2085,638, 
34218,2086,1450, 34219,2087,1451, 34216,2082,1448, 1452,2088,1452, 34217,2083,1449, 1453,2089,1453, 34096,2084,1328, 
45, // chain 198
638,2085,638, 1450,2086,1450, 637,2090,637, 
34222,2091,1454, 34223,2092,1455, 34219,2087,1451, 1452,2088,1452, 1456,2093,1456, 34221,2089,1453, 1457,2094,1457, 1458,2095,1458, 34067,2096,1299, 1459,2097,1459, 34065,2098,1297, 1460,2099,1460, 34063,2100,1295, 1461,2101,1461, 34061,2102,1293, 1462,2103,1462, 
34059,2104,1291, 1463,2105,1463, 34232,2106,1464, 34057,2107,1289, 1465,2108,1465, 34056,2109,1288, 1446,2110,1446, 1466,2111,1466, 34212,2112,1444, 1467,2113,1467, 34209,2114,1441, 603,2115,603, 602,2116,602, 1468,2117,1468, 33389,2118,621, 1469,2119,1469, 
33391,2120,623, 626,2121,626, 1470,2122,1470, 34239,2123,1471, 33395,2124,627, 1472,2125,1472, 33397,2126,629, 1473,2127,1473, 33400,2128,632, 1454,2091,1454, 33403,2129,635, 637,2090,637, 
31, // chain 199
1473,2127,1473, 1454,2091,1454, 1455,2092,1455, 
1474,2130,1474, 34224,2093,1456, 1458,2095,1458, 1475,2131,1475, 34227,2097,1459, 1476,2132,1476, 34228,2099,1460, 1477,2133,1477, 34229,2101,1461, 1478,2134,1478, 34230,2103,1462, 1479,2135,1479, 34231,2105,1463, 1464,2106,1464, 1480,2136,1480, 34233,2108,1465, 
1466,2111,1466, 1467,2113,1467, 1468,2117,1468, 1469,2119,1469, 1479,2135,1479, 34238,2122,1470, 1478,2134,1478, 34245,2133,1477, 34244,2132,1476, 34239,2123,1471, 1475,2131,1475, 34240,2125,1472, 1474,2130,1474, 34241,2127,1473, 
2, // chain 200
1346,2137,1346, 1309,2138,1309, 1325,2139,1325, 
1347,2140,1347, 
20, // chain 201
487,2141,487, 488,2142,488, 1481,2143,1481, 
1482,2144,1482, 489,2145,489, 33989,2146,1221, 34251,2147,1483, 1484,2148,1484, 1223,2149,1223, 34253,2150,1485, 34254,2151,1486, 1487,2152,1487, 34256,2153,1488, 34257,2154,1489, 1250,2155,1250, 34014,2156,1246, 34258,2157,1490, 1491,2158,1491, 1247,2159,1247, 
34260,2160,1492, 34261,2161,1493, 1494,2162,1494, 
4, // chain 202
1495,2163,1495, 485,2164,485, 484,2165,484, 
1496,2166,1496, 34265,2167,1497, 34266,2168,1498, 
16, // chain 203
1495,2163,1495, 1496,2166,1496, 1499,2169,1499, 
34268,2170,1500, 1501,2171,1501, 34270,2172,1502, 1503,2173,1503, 1504,2174,1504, 34273,2175,1505, 34274,2176,1506, 1507,2177,1507, 1508,2178,1508, 34277,2179,1509, 34278,2180,1510, 1511,2181,1511, 1512,2182,1512, 34264,2166,1496, 1497,2167,1497, 
2, // chain 204
1482,2183,1482, 1481,2184,1481, 1495,2185,1495, 
1499,2186,1499, 
2, // chain 205
1481,2187,1481, 488,2188,488, 485,2189,485, 
1495,2190,1495, 
4, // chain 206
1513,2191,1513, 1514,2192,1514, 1500,2193,1500, 
1496,2194,1496, 1511,2195,1511, 1515,2196,1515, 
4, // chain 207
1482,2197,1482, 1499,2198,1499, 1501,2199,1501, 
1483,2200,1483, 34272,2201,1504, 1484,2202,1484, 
4, // chain 208
1502,2203,1502, 1500,2204,1500, 1514,2205,1514, 
1516,2206,1516, 1517,2207,1517, 1503,2208,1503, 
2, // chain 209
1491,2209,1491, 1512,2210,1512, 1497,2211,1497, 
1493,2212,1493, 
2, // chain 210
1493,2213,1493, 1497,2214,1497, 1498,2215,1498, 
1494,2216,1494, 
4, // chain 211
1509,2217,1509, 1512,2218,1512, 1491,2219,1491, 
1490,2220,1490, 1508,2221,1508, 34257,2222,1489, 
4, // chain 212
1515,2223,1515, 1511,2224,1511, 1510,2225,1510, 
1518,2226,1518, 34287,2227,1519, 34275,2228,1507, 
4, // chain 213
1231,2229,1231, 1520,2230,1520, 1521,2231,1521, 
1522,2232,1522, 34291,2233,1523, 34292,2234,1524, 
3, // chain 214
1525,2235,1525, 1526,2236,1526, 1527,2237,1527, 
1528,2238,1528, 34297,2239,1529, 
16, // chain 215
1530,2240,1530, 1531,2241,1531, 1532,2242,1532, 
1533,2243,1533, 34302,2244,1534, 1535,2245,1535, 34304,2246,1536, 1537,2247,1537, 34306,2248,1538, 1539,2249,1539, 34308,2250,1540, 1541,2251,1541, 34310,2252,1542, 1543,2253,1543, 34312,2254,1544, 1545,2255,1545, 34314,2256,1546, 1547,2257,1547, 
10, // chain 216
1548,2258,1548, 1549,2259,1549, 1550,2260,1550, 
1551,2261,1551, 34320,2262,1552, 1553,2263,1553, 34322,2264,1554, 1555,2265,1555, 34324,2266,1556, 1557,2267,1557, 34326,2268,1558, 1559,2269,1559, 
10, // chain 217
1560,2270,1560, 1561,2271,1561, 1562,2272,1562, 
1563,2273,1563, 34332,2274,1564, 1565,2275,1565, 34334,2276,1566, 1567,2277,1567, 34336,2278,1568, 1569,2279,1569, 34338,2280,1570, 1571,2281,1571, 
2, // chain 218
1548,2282,1548, 1561,2283,1561, 1560,2284,1560, 
1549,2285,1549, 
2, // chain 219
1570,2286,1570, 1559,2287,1559, 1558,2288,1558, 
1571,2289,1571, 
13, // chain 220
1531,2290,1531, 1548,2291,1548, 1551,2292,1551, 
1532,2293,1532, 34302,2294,1534, 34321,2295,1553, 1536,2296,1536, 34323,2297,1555, 1538,2298,1538, 34325,2299,1557, 1540,2300,1540, 34310,2301,1542, 34327,2302,1559, 1544,2303,1544, 34314,2304,1546, 
2, // chain 221
1561,2305,1561, 1548,2306,1548, 1531,2307,1531, 
1530,2308,1530, 
13, // chain 222
1561,2309,1561, 1530,2310,1530, 1533,2311,1533, 
1562,2312,1562, 34303,2313,1535, 1537,2314,1537, 1564,2315,1564, 34307,2316,1539, 1566,2317,1566, 34309,2318,1541, 1568,2319,1568, 34311,2320,1543, 1545,2321,1545, 1570,2322,1570, 34315,2323,1547, 
2, // chain 223
1559,2324,1559, 1570,2325,1570, 1547,2326,1547, 
1546,2327,1546, 
10, // chain 224
1549,2328,1549, 1572,2329,1572, 1573,2330,1573, 
1550,2331,1550, 34293,2332,1525, 1552,2333,1552, 34342,2334,1574, 1554,2335,1554, 34343,2336,1575, 1556,2337,1556, 34344,2338,1576, 1558,2339,1558, 
2, // chain 225
1549,2340,1549, 1560,2341,1560, 1577,2342,1577, 
1572,2343,1572, 
10, // chain 226
1571,2344,1571, 1578,2345,1578, 1579,2346,1579, 
1569,2347,1569, 34348,2348,1580, 1567,2349,1567, 34296,2350,1528, 1565,2351,1565, 34349,2352,1581, 1563,2353,1563, 34328,2354,1560, 34345,2355,1577, 
2, // chain 227
1571,2356,1571, 1558,2357,1558, 1576,2358,1576, 
1578,2359,1578, 
3, // chain 228
1582,2360,1582, 1583,2361,1583, 1574,2362,1574, 
1580,2363,1580, 1584,2364,1584, 
14, // chain 229
426,2365,426, 425,2366,425, 1585,2367,1585, 
1586,2368,1586, 34355,2369,1587, 34356,2370,1588, 1589,2371,1589, 34358,2372,1590, 1591,2373,1591, 34360,2374,1592, 34361,2375,1593, 34362,2376,1594, 1595,2377,1595, 34364,2378,1596, 463,2379,463, 33236,2380,468, 
17, // chain 230
426,2365,426, 1586,2368,1586, 428,2381,428, 
34365,2382,1597, 34346,2383,1578, 34355,2369,1587, 1598,2384,1598, 34357,2371,1589, 1599,2385,1599, 34359,2373,1591, 1600,2386,1600, 34369,2387,1601, 34360,2374,1592, 1593,2375,1593, 1602,2388,1602, 34363,2377,1595, 1603,2389,1603, 33231,2379,463, 464,2390,464, 
4, // chain 231
428,2381,428, 1597,2382,1597, 430,2391,430, 
34372,2392,1604, 34344,2393,1576, 34346,2383,1578, 
4, // chain 232
1604,2392,1604, 1576,2393,1576, 1605,2394,1605, 
34374,2395,1606, 34343,2396,1575, 1574,2397,1574, 
13, // chain 233
1607,2398,1607, 1578,2383,1578, 1598,2384,1598, 
1608,2399,1608, 34377,2400,1609, 34367,2385,1599, 1610,2401,1610, 34368,2386,1600, 1611,2402,1611, 34380,2403,1612, 34369,2387,1601, 1613,2404,1613, 34382,2405,1614, 34383,2406,1615, 34370,2388,1602, 
5, // chain 234
1578,2383,1578, 1607,2398,1607, 1579,2407,1579, 
34384,2408,1616, 34385,2409,1617, 34386,2410,1618, 34376,2399,1608, 
3, // chain 235
1579,2407,1579, 1616,2408,1616, 1584,2411,1584, 
34385,2409,1617, 1582,2412,1582, 
1, // chain 236
1579,2407,1579, 1584,2411,1584, 1580,2413,1580, 
6, // chain 237
1611,2402,1611, 1612,2403,1612, 1619,2414,1619, 
34388,2415,1620, 34381,2404,1613, 1621,2416,1621, 34390,2417,1622, 34382,2405,1614, 
12, // chain 238
425,2418,425, 470,2419,470, 1623,2420,1623, 
1585,2421,1585, 34356,2422,1588, 34392,2423,1624, 1590,2424,1590, 34393,2425,1625, 1594,2426,1594, 34394,2427,1626, 1596,2428,1596, 34395,2429,1627, 475,2430,475, 468,2431,468, 
4, // chain 239
1627,2432,1627, 1626,2433,1626, 1628,2434,1628, 
1629,2435,1629, 475,2436,475, 33246,2437,478, 
4, // chain 240
1630,2438,1630, 1628,2439,1628, 1626,2440,1626, 
1625,2441,1625, 1631,2442,1631, 34392,2443,1624, 
4, // chain 241
1632,2444,1632, 1631,2445,1631, 1624,2446,1624, 
1623,2447,1623, 470,2448,470, 482,2449,482, 
15, // chain 242
1498,2450,1498, 484,2451,484, 483,2452,483, 
1633,2453,1633, 1492,2454,1492, 34015,2455,1247, 34402,2456,1634, 1635,2457,1635, 34006,2458,1238, 34404,2459,1636, 1239,2460,1239, 33994,2461,1226, 34405,2462,1637, 1227,2463,1227, 33997,2464,1229, 34288,2465,1520, 1231,2466,1231, 
1, // chain 243
1498,2450,1498, 1492,2454,1492, 1494,2467,1494, 
1, // chain 244
1247,2455,1247, 1635,2457,1635, 1248,2468,1248, 
1, // chain 245
1635,2457,1635, 1238,2458,1238, 1244,2469,1244, 
7, // chain 246
1622,2470,1622, 1231,2471,1231, 1522,2472,1522, 
1621,2473,1621, 34291,2474,1523, 1620,2475,1620, 34406,2476,1638, 34407,2477,1639, 1640,2478,1640, 
1, // chain 247
1620,2475,1620, 1638,2476,1638, 1619,2479,1619, 
9, // chain 248
1603,2480,1603, 464,2481,464, 504,2482,504, 
1641,2483,1641, 1642,2484,1642, 1602,2485,1602, 34411,2486,1643, 1615,2487,1615, 34382,2488,1614, 34412,2489,1644, 1622,2490,1622, 
20, // chain 249
1231,2491,1231, 1622,2492,1622, 1644,2493,1644, 
1645,2494,1645, 34414,2495,1646, 34411,2496,1643, 1647,2497,1647, 34410,2498,1642, 1648,2499,1648, 34409,2500,1641, 504,2501,504, 519,2502,519, 520,2503,520, 1649,2504,1649, 1647,2497,1647, 34418,2505,1650, 1646,2495,1646, 34419,2506,1651, 1645,2494,1645, 
34420,2507,1652, 1232,2508,1232, 34001,2509,1233, 
1, // chain 250
1231,2491,1231, 1645,2494,1645, 1232,2508,1232, 
34, // chain 251
521,2510,521, 1653,2511,1653, 522,2512,522, 
34422,2513,1654, 34423,2514,1655, 1656,2515,1656, 34425,2516,1657, 1658,2517,1658, 34427,2518,1659, 34428,2519,1660, 1661,2520,1661, 34430,2521,1662, 1663,2522,1663, 1664,2523,1664, 34433,2524,1665, 1666,2525,1666, 34435,2526,1667, 34436,2527,1668, 1669,2528,1669, 
34438,2529,1670, 1671,2530,1671, 34440,2531,1672, 597,2532,597, 598,2533,598, 1673,2534,1673, 33367,2535,599, 1674,2536,1674, 33368,2537,600, 1675,2538,1675, 33357,2539,589, 1676,2540,1676, 33358,2541,590, 536,2542,536, 1677,2543,1677, 1678,2544,1678, 
34447,2545,1679, 
21, // chain 252
522,2512,522, 1654,2513,1654, 1680,2546,1680, 
34449,2547,1681, 34424,2515,1656, 1682,2548,1682, 34451,2549,1683, 34452,2550,1684, 34426,2517,1658, 1685,2551,1685, 34427,2518,1659, 1661,2520,1661, 1686,2552,1686, 1687,2553,1687, 34456,2554,1688, 34457,2555,1689, 1690,2556,1690, 34459,2557,1691, 1692,2558,1692, 
34461,2559,1693, 34462,2560,1694, 1666,2525,1666, 34432,2523,1664, 
14, // chain 253
522,2512,522, 1680,2546,1680, 526,2561,526, 
33295,2562,527, 34463,2563,1695, 34449,2547,1681, 1696,2564,1696, 34450,2548,1682, 1697,2565,1697, 34466,2566,1698, 34451,2549,1683, 1699,2567,1699, 34452,2550,1684, 1700,2568,1700, 34455,2553,1687, 34453,2551,1685, 
10, // chain 254
527,2562,527, 1695,2563,1695, 529,2569,529, 
34469,2570,1701, 34464,2564,1696, 1702,2571,1702, 34465,2565,1697, 1703,2572,1703, 1704,2573,1704, 1705,2574,1705, 34447,2575,1679, 34474,2576,1706, 
9, // chain 255
1671,2530,1671, 1673,2534,1673, 1669,2528,1669, 
34475,2577,1707, 34476,2578,1708, 34442,2536,1674, 1709,2579,1709, 34443,2538,1675, 1676,2540,1676, 1710,2580,1710, 34446,2544,1678, 
7, // chain 256
1669,2528,1669, 1707,2577,1707, 1667,2526,1667, 
34479,2581,1711, 34480,2582,1712, 34476,2578,1708, 1713,2583,1713, 34477,2579,1709, 1710,2580,1710, 
6, // chain 257
1667,2526,1667, 1711,2581,1711, 1666,2525,1666, 
34461,2559,1693, 34482,2584,1714, 34480,2582,1712, 1715,2585,1715, 34481,2583,1713, 
3, // chain 258
1692,2558,1692, 1693,2559,1693, 1714,2584,1714, 
1716,2586,1716, 34483,2585,1715, 
3, // chain 259
1716,2586,1716, 1717,2587,1717, 1692,2558,1692, 
34486,2588,1718, 1690,2556,1690, 
2, // chain 260
1687,2553,1687, 1688,2554,1688, 1719,2589,1719, 
1700,2568,1700, 
3, // chain 261
1705,2574,1705, 1679,2575,1679, 1677,2590,1677, 
533,2591,533, 33304,2592,536, 
4, // chain 262
1705,2574,1705, 533,2591,533, 1702,2571,1702, 
33299,2593,531, 1701,2570,1701, 33297,2569,529, 
4, // chain 263
1694,2594,1694, 1691,2595,1691, 1689,2596,1689, 
1686,2597,1686, 1664,2598,1664, 34429,2599,1661, 
24, // chain 264
1720,2600,1720, 1406,2601,1406, 1405,2602,1405, 
1721,2603,1721, 34194,2604,1426, 1722,2605,1722, 34193,2606,1425, 1723,2607,1723, 34492,2608,1724, 34190,2609,1422, 1420,2610,1420, 1725,2611,1725, 34186,2612,1418, 1726,2613,1726, 34184,2614,1416, 1727,2615,1727, 34183,2616,1415, 1728,2617,1728, 34497,2618,1729, 
34181,2619,1413, 1730,2620,1730, 34179,2621,1411, 1731,2622,1731, 34176,2623,1408, 1720,2624,1720, 34174,2625,1406, 
27, // chain 265
1720,2600,1720, 1721,2603,1721, 1706,2626,1706, 
34500,2627,1732, 34501,2628,1733, 34490,2605,1722, 1734,2629,1734, 34491,2607,1723, 1735,2630,1735, 34492,2608,1724, 1736,2631,1736, 34505,2632,1737, 34493,2611,1725, 1738,2633,1738, 34507,2634,1739, 34494,2613,1726, 1727,2615,1727, 1740,2635,1740, 34496,2617,1728, 
1741,2636,1741, 34510,2637,1742, 34497,2618,1729, 1697,2638,1697, 34498,2620,1730, 1703,2639,1703, 34499,2622,1731, 1704,2640,1704, 34488,2624,1720, 1706,2641,1706, 
25, // chain 266
1706,2626,1706, 1732,2627,1732, 1679,2642,1679, 
34446,2643,1678, 34501,2628,1733, 1710,2644,1710, 34481,2645,1713, 34502,2629,1734, 1735,2630,1735, 1736,2631,1736, 1715,2646,1715, 34484,2647,1716, 34485,2648,1717, 34505,2632,1737, 1718,2649,1718, 34506,2633,1738, 1743,2650,1743, 34507,2634,1739, 1744,2651,1744, 
34508,2635,1740, 1745,2652,1745, 34509,2636,1741, 1700,2653,1700, 34467,2654,1699, 34510,2637,1742, 1698,2655,1698, 34465,2638,1697, 
6, // chain 267
1718,2649,1718, 1743,2650,1743, 1690,2656,1690, 
34456,2657,1688, 34512,2651,1744, 1719,2658,1719, 34513,2652,1745, 1700,2653,1700, 
4, // chain 268
1746,2659,1746, 641,2660,641, 640,2661,640, 
1747,2662,1747, 34516,2663,1748, 33434,2664,666, 
29, // chain 269
1746,2659,1746, 1747,2662,1747, 1749,2665,1749, 
34518,2666,1750, 34516,2663,1748, 1751,2667,1751, 1752,2668,1752, 1753,2669,1753, 34522,2670,1754, 1755,2671,1755, 34524,2672,1756, 1757,2673,1757, 34526,2674,1758, 34527,2675,1759, 659,2676,659, 658,2677,658, 656,2678,656, 1760,2679,1760, 33423,2680,655, 
1761,2681,1761, 1762,2682,1762, 34531,2683,1763, 1764,2684,1764, 1583,2685,1583, 1757,2673,1757, 34523,2671,1755, 34294,2686,1526, 1753,2669,1753, 34533,2687,1765, 1750,2666,1750, 34517,2665,1749, 
2, // chain 270
1760,2679,1760, 1762,2682,1762, 1758,2674,1758, 
34525,2673,1757, 
10, // chain 271
667,2688,667, 641,2689,641, 1746,2690,1746, 
1766,2691,1766, 34517,2692,1749, 1767,2693,1767, 34536,2694,1768, 34537,2695,1769, 34533,2696,1765, 1526,2697,1526, 1573,2698,1573, 34293,2699,1525, 
1, // chain 272
1768,2694,1768, 1769,2695,1769, 1573,2698,1573, 
8, // chain 273
655,2700,655, 430,2701,430, 1604,2702,1604, 
1761,2703,1761, 34373,2704,1605, 1763,2705,1763, 34374,2706,1606, 1764,2707,1764, 34342,2708,1574, 1583,2709,1583, 
2, // chain 274
1583,2710,1583, 1582,2711,1582, 1527,2712,1527, 
1526,2713,1526, 
2, // chain 275
1574,2714,1574, 1525,2715,1525, 1528,2716,1528, 
1580,2717,1580, 
28, // chain 276
1770,2718,1770, 1771,2719,1771, 1772,2720,1772, 
1773,2721,1773, 34542,2722,1774, 1775,2723,1775, 34544,2724,1776, 1777,2725,1777, 34546,2726,1778, 1779,2727,1779, 34548,2728,1780, 1781,2729,1781, 34550,2730,1782, 34551,2731,1783, 1784,2732,1784, 34553,2733,1785, 1786,2734,1786, 34555,2735,1787, 1788,2736,1788, 
34557,2737,1789, 1790,2738,1790, 1791,2739,1791, 34539,2740,1771, 1770,2741,1770, 1792,2742,1792, 34561,2743,1793, 1794,2744,1794, 34563,2745,1795, 1619,2746,1619, 34379,2747,1611, 
20, // chain 277
1770,2718,1770, 1773,2721,1773, 1796,2748,1796, 
34543,2723,1775, 1797,2749,1797, 34545,2725,1777, 1798,2750,1798, 34547,2727,1779, 1799,2751,1799, 34568,2752,1800, 34549,2729,1781, 1782,2730,1782, 1801,2753,1801, 34570,2754,1802, 34552,2732,1784, 1786,2734,1786, 1803,2755,1803, 34572,2756,1804, 34556,2736,1788, 
1805,2757,1805, 34560,2742,1792, 34559,2739,1791, 
22, // chain 278
1770,2718,1770, 1796,2748,1796, 1793,2758,1793, 
34563,2759,1795, 34574,2760,1806, 34565,2749,1797, 1807,2761,1807, 34566,2750,1798, 1808,2762,1808, 34567,2751,1799, 1809,2763,1809, 34568,2752,1800, 1810,2764,1810, 34579,2765,1811, 34569,2753,1801, 1812,2766,1812, 34570,2754,1802, 1803,2755,1803, 1813,2767,1813, 
34582,2768,1814, 34572,2756,1804, 1805,2757,1805, 1794,2744,1794, 34560,2742,1792, 
45, // chain 279
1795,2759,1795, 1806,2760,1806, 1611,2769,1611, 
34583,2770,1815, 34575,2761,1807, 1816,2771,1816, 34576,2762,1808, 1817,2772,1817, 34577,2763,1809, 1818,2773,1818, 34587,2774,1819, 34578,2764,1810, 1820,2775,1820, 34589,2776,1821, 34579,2765,1811, 1812,2766,1812, 1822,2777,1822, 34591,2778,1823, 34581,2767,1813, 
1824,2779,1824, 34582,2768,1814, 1794,2744,1794, 1619,2746,1619, 1638,2780,1638, 1825,2781,1825, 34408,2782,1640, 1826,2783,1826, 34595,2784,1827, 1828,2785,1828, 34597,2786,1829, 1830,2787,1830, 34599,2788,1831, 1832,2789,1832, 34601,2790,1833, 1527,2791,1527, 
1582,2792,1582, 1834,2793,1834, 34385,2794,1617, 1835,2795,1835, 34386,2796,1618, 1608,2797,1608, 1836,2798,1836, 34377,2799,1609, 1837,2800,1837, 34378,2801,1610, 1815,2770,1815, 34379,2769,1611, 
10, // chain 280
1830,2787,1830, 1832,2789,1832, 1838,2802,1838, 
34602,2793,1834, 1839,2803,1839, 34603,2795,1835, 1840,2804,1840, 34604,2798,1836, 1841,2805,1841, 34605,2800,1837, 1816,2771,1816, 34583,2770,1815, 
15, // chain 281
1816,2771,1816, 1817,2772,1817, 1841,2805,1841, 
34586,2773,1818, 1840,2804,1840, 34587,2774,1819, 1839,2803,1839, 34588,2775,1820, 1838,2802,1838, 34610,2806,1842, 34589,2776,1821, 1822,2777,1822, 1828,2785,1828, 34594,2783,1826, 34591,2778,1823, 1825,2781,1825, 34592,2779,1824, 
2, // chain 282
1838,2802,1838, 1842,2806,1842, 1830,2787,1830, 
34596,2785,1828, 
11, // chain 283
1783,2807,1783, 1780,2808,1780, 1843,2809,1843, 
1844,2810,1844, 1785,2811,1785, 34613,2812,1845, 1787,2813,1787, 34557,2814,1789, 34614,2815,1846, 1790,2816,1790, 34615,2817,1847, 1771,2818,1771, 34616,2819,1848, 
6, // chain 284
1849,2820,1849, 1778,2821,1778, 1776,2822,1776, 
1774,2823,1774, 1850,2824,1850, 34540,2825,1772, 1848,2826,1848, 34539,2827,1771, 
2, // chain 285
1851,2828,1851, 1852,2829,1852, 1853,2830,1853, 
1854,2831,1854, 
13, // chain 286
1855,2832,1855, 1856,2833,1856, 1857,2834,1857, 
1858,2835,1858, 1859,2836,1859, 34628,2837,1860, 34629,2838,1861, 1862,2839,1862, 34631,2840,1863, 34632,2841,1864, 1865,2842,1865, 1866,2843,1866, 34635,2844,1867, 1868,2845,1868, 1869,2846,1869, 
3, // chain 287
1870,2847,1870, 1871,2848,1871, 1872,2849,1872, 
1873,2850,1873, 1874,2851,1874, 
8, // chain 288
1850,2852,1850, 1848,2853,1848, 1875,2854,1875, 
1876,2855,1876, 34645,2856,1877, 1867,2857,1867, 34646,2858,1878, 34647,2859,1879, 1880,2860,1880, 34649,2861,1881, 
3, // chain 289
1850,2852,1850, 1876,2855,1876, 1882,2862,1882, 
34633,2863,1865, 34635,2857,1867, 
4, // chain 290
1850,2852,1850, 1882,2862,1882, 1849,2864,1849, 
34651,2865,1883, 34632,2866,1864, 34633,2863,1865, 
3, // chain 291
1849,2864,1849, 1883,2865,1883, 1778,2867,1778, 
34629,2868,1861, 34632,2866,1864, 
25, // chain 292
1778,2867,1778, 1861,2868,1861, 1780,2869,1780, 
34626,2870,1858, 1857,2871,1857, 1843,2872,1843, 34652,2873,1884, 34624,2874,1856, 1854,2875,1854, 34653,2876,1885, 34623,2877,1855, 1886,2878,1886, 34627,2879,1859, 1887,2880,1887, 34628,2881,1860, 1862,2882,1862, 1888,2883,1888, 34631,2884,1863, 1889,2885,1889, 
34634,2886,1866, 1890,2887,1890, 34637,2888,1869, 1891,2889,1891, 34636,2890,1868, 1892,2891,1892, 34646,2858,1878, 34635,2857,1867, 
46, // chain 293
1878,2858,1878, 1880,2860,1880, 1893,2892,1893, 
1892,2891,1892, 34659,2889,1891, 34662,2893,1894, 1895,2894,1895, 1890,2887,1890, 34657,2885,1889, 34664,2895,1896, 1888,2883,1888, 34665,2896,1897, 1898,2897,1898, 1887,2880,1887, 34667,2898,1899, 1886,2878,1886, 34653,2876,1885, 34668,2899,1900, 1901,2900,1901, 
34670,2901,1902, 1903,2902,1903, 34672,2903,1904, 1905,2904,1905, 34674,2905,1906, 1907,2906,1907, 34676,2907,1908, 1909,2908,1909, 1910,2909,1910, 34679,2910,1911, 1912,2911,1912, 34681,2912,1913, 1914,2913,1914, 34649,2914,1881, 1879,2915,1879, 1874,2916,1874, 
34645,2917,1877, 1875,2918,1875, 1848,2919,1848, 1870,2920,1870, 34615,2921,1847, 1915,2922,1915, 34614,2923,1846, 1916,2924,1916, 34613,2925,1845, 1917,2926,1917, 34612,2927,1844, 1884,2873,1884, 34611,2872,1843, 
13, // chain 294
1885,2876,1885, 1901,2900,1901, 1854,2875,1854, 
34619,2928,1851, 34671,2902,1903, 1905,2904,1905, 1852,2929,1852, 34675,2906,1907, 1871,2930,1871, 34678,2909,1910, 1872,2931,1872, 34680,2911,1912, 1873,2932,1873, 34642,2916,1874, 34682,2913,1914, 
7, // chain 295
1917,2926,1917, 1884,2873,1884, 1854,2875,1854, 
1853,2933,1853, 1852,2929,1852, 1916,2924,1916, 34683,2922,1915, 34639,2930,1871, 1870,2920,1870, 
23, // chain 296
1918,2934,1918, 1919,2935,1919, 1920,2936,1920, 
1921,2937,1921, 34690,2938,1922, 1923,2939,1923, 34692,2940,1924, 34693,2941,1925, 1926,2942,1926, 34695,2943,1927, 34696,2944,1928, 1929,2945,1929, 1930,2946,1930, 34699,2947,1931, 1932,2948,1932, 34701,2949,1933, 1934,2950,1934, 34703,2951,1935, 1936,2952,1936, 
34705,2953,1937, 1938,2954,1938, 34707,2955,1939, 34708,2956,1940, 1918,2957,1918, 34687,2958,1919, 
21, // chain 297
1918,2934,1918, 1921,2937,1921, 1941,2959,1941, 
34691,2939,1923, 1924,2940,1924, 1942,2960,1942, 34694,2942,1926, 1943,2961,1943, 34712,2962,1944, 34695,2943,1927, 1945,2963,1945, 34698,2946,1930, 1932,2948,1932, 1934,2950,1934, 1946,2964,1946, 34715,2965,1947, 34704,2952,1936, 1938,2954,1938, 1948,2966,1948, 
34717,2967,1949, 34707,2955,1939, 1950,2968,1950, 34686,2957,1918, 
40, // chain 298
1941,2959,1941, 1942,2960,1942, 1951,2969,1951, 
34720,2970,1952, 34721,2971,1953, 34711,2961,1943, 1954,2972,1954, 34712,2962,1944, 1955,2973,1955, 34713,2963,1945, 1956,2974,1956, 34714,2964,1946, 1957,2975,1957, 34715,2965,1947, 1948,2966,1948, 1958,2976,1958, 34727,2977,1959, 34717,2967,1949, 1950,2968,1950, 
1960,2978,1960, 1961,2979,1961, 34730,2980,1962, 1348,2981,1348, 1368,2982,1368, 1365,2983,1365, 1963,2984,1963, 34131,2985,1363, 1964,2986,1964, 34128,2987,1360, 1965,2988,1965, 34126,2989,1358, 1966,2990,1966, 34125,2991,1357, 1967,2992,1967, 34122,2993,1354, 
1968,2994,1968, 34737,2995,1969, 34121,2996,1353, 1349,2997,1349, 1970,2998,1970, 34730,2999,1962, 34116,3000,1348, 
18, // chain 299
1941,2959,1941, 1951,2969,1951, 1960,3001,1960, 
34738,2998,1970, 34720,2970,1952, 1969,2995,1969, 34736,2994,1968, 34721,2971,1953, 1967,2992,1967, 34722,2972,1954, 1966,2990,1966, 34723,2973,1955, 1956,2974,1956, 1965,2988,1965, 34725,2975,1957, 1964,2986,1964, 34726,2976,1958, 1963,2984,1963, 34729,2979,1961, 
34727,2977,1959, 
2, // chain 300
1941,2959,1941, 1960,3001,1960, 1950,3002,1950, 
1918,2934,1918, 
1, // chain 301
1960,3001,1960, 1970,2998,1970, 1962,2999,1962, 
60, // chain 302
1971,3003,1971, 1972,3004,1972, 1973,3005,1973, 
1974,3006,1974, 34743,3007,1975, 34744,3008,1976, 1919,3009,1919, 1940,3010,1940, 1937,3011,1937, 1977,3012,1977, 34703,3013,1935, 1978,3014,1978, 34747,3015,1979, 34701,3016,1933, 1931,3017,1931, 1980,3018,1980, 34697,3019,1929, 1981,3020,1981, 34750,3021,1982, 
34696,3022,1928, 1983,3023,1983, 34693,3024,1925, 1922,3025,1922, 1984,3026,1984, 34688,3027,1920, 1985,3028,1985, 34687,3029,1919, 1976,3030,1976, 1973,3031,1973, 1986,3032,1986, 34740,3033,1972, 1987,3034,1987, 1988,3035,1988, 1989,3036,1989, 34758,3037,1990, 
1991,3038,1991, 34760,3039,1992, 1993,3040,1993, 1994,3041,1994, 34763,3042,1995, 1996,3043,1996, 34765,3044,1997, 1998,3045,1998, 34767,3046,1999, 2000,3047,2000, 34769,3048,2001, 2002,3049,2002, 2003,3050,2003, 34772,3051,2004, 2005,3052,2005, 34774,3053,2006, 
2007,3054,2007, 34776,3055,2008, 2009,3056,2009, 34778,3057,2010, 34779,3058,2011, 2012,3059,2012, 34781,3060,2013, 2014,3061,2014, 34783,3062,2015, 1974,3006,1974, 34739,3003,1971, 
18, // chain 303
1975,3007,1975, 1977,3012,1977, 1974,3006,1974, 
34784,3063,2016, 34785,3064,2017, 34746,3014,1978, 2000,3047,2000, 34747,3015,1979, 1998,3045,1998, 34748,3018,1980, 1981,3020,1981, 1996,3043,1996, 34750,3021,1982, 1994,3041,1994, 34759,3038,1991, 34751,3023,1983, 1989,3036,1989, 34752,3026,1984, 1986,3032,1986, 
34753,3028,1985, 
7, // chain 304
1974,3006,1974, 2016,3063,2016, 2014,3061,2014, 
34780,3059,2012, 34786,3065,2018, 34787,3066,2019, 34785,3064,2017, 2003,3050,2003, 34768,3047,2000, 
6, // chain 305
2010,3057,2010, 2012,3059,2012, 2020,3067,2020, 
34786,3065,2018, 2019,3066,2019, 2021,3068,2021, 34773,3052,2005, 34771,3050,2003, 
3, // chain 306
2020,3067,2020, 2021,3068,2021, 2022,3069,2022, 
34775,3054,2007, 34773,3052,2005, 
3, // chain 307
2020,3067,2020, 2022,3069,2022, 2023,3070,2023, 
34777,3056,2009, 34775,3054,2007, 
2, // chain 308
2020,3067,2020, 2023,3070,2023, 2010,3057,2010, 
34777,3056,2009, 
16, // chain 309
2011,3071,2011, 2008,3072,2008, 2006,3073,2006, 
2004,3074,2004, 2013,3075,2013, 34770,3076,2002, 2015,3077,2015, 34769,3078,2001, 1971,3079,1971, 34767,3080,1999, 1997,3081,1997, 1972,3082,1972, 34763,3083,1995, 1987,3084,1987, 34761,3085,1993, 1988,3086,1988, 34760,3087,1992, 1990,3088,1990, 
8, // chain 310
2024,3089,2024, 1517,3090,1517, 1516,3091,1516, 
2025,3092,2025, 34282,3093,1514, 1513,3094,1513, 1515,3095,1515, 1518,3096,1518, 2024,3089,2024, 34287,3097,1519, 
4, // chain 311
1486,3098,1486, 1484,3099,1484, 1504,3100,1504, 
1505,3101,1505, 1508,3102,1508, 1489,3103,1489, 
4, // chain 312
1506,3104,1506, 1503,3105,1503, 1517,3106,1517, 
2024,3107,2024, 1519,3108,1519, 1507,3109,1507, 
34, // chain 313
1881,1185,1881, 2026,1186,2026, 2027,1184,2027, 
1880,1183,1880, 34796,1181,2028, 1893,1182,1893, 34662,1180,1894, 34797,1179,2029, 1895,1178,1895, 34798,1177,2030, 1896,1176,1896, 34799,1175,2031, 1897,1173,1897, 34800,1174,2032, 2033,1172,2033, 1898,1171,1898, 34802,1169,2034, 1899,1170,1899, 34668,1168,1900, 
34803,1167,2035, 1902,1166,1902, 34804,1165,2036, 1904,1164,1904, 34805,1163,2037, 1906,1161,1906, 34806,1162,2038, 2039,1159,2039, 1908,1160,1908, 34677,1157,1909, 34808,1158,2040, 2041,1156,2041, 1911,1155,1911, 34810,1154,2042, 1913,1152,1913, 34794,1153,2026, 
1881,1151,1881, 
11, // chain 314
2035,1225,2035, 2034,1224,2034, 2033,1223,2033, 
2032,1226,2032, 2043,1227,2043, 34812,1242,2044, 34799,1243,2031, 2030,1244,2030, 2045,1245,2045, 34814,1246,2046, 34795,1247,2027, 34796,1250,2028, 34797,1251,2029, 
12, // chain 315
2035,1225,2035, 2043,1227,2043, 2047,1228,2047, 
2036,1229,2036, 34805,1230,2037, 34816,1231,2048, 2038,1232,2038, 34817,1233,2049, 2039,1234,2039, 34818,1235,2050, 2042,1236,2042, 34819,1239,2051, 2026,1240,2026, 34820,1241,2052, 
2, // chain 316
2039,1234,2039, 2042,1236,2042, 2040,1237,2040, 
34809,1238,2041, 
2, // chain 317
2046,1246,2046, 2027,1247,2027, 2052,1248,2052, 
34794,1249,2026, 
315, // chain 318
2053,1254,2053, 2049,1253,2049, 2048,1252,2048, 
2054,1255,2054, 34815,1525,2047, 2055,1526,2055, 34824,1524,2056, 34811,1523,2043, 2057,1522,2057, 34812,1521,2044, 2058,1520,2058, 34813,1518,2045, 2059,1519,2059, 34828,1516,2060, 34814,1517,2046, 2052,1513,2052, 2061,1515,2061, 34830,1514,2062, 34831,1512,2063, 
34819,1511,2051, 2064,1508,2064, 34818,1510,2050, 2049,1509,2049, 2053,1507,2053, 2065,1505,2065, 34834,1506,2066, 2067,1503,2067, 2068,1504,2068, 34837,1501,2069, 34838,1502,2070, 2071,1500,2071, 2072,1499,2072, 34841,1498,2073, 2074,1497,2074, 34843,1495,2075, 
2076,1496,2076, 34845,1492,2077, 34846,1494,2078, 2079,1493,2079, 2080,1491,2080, 2081,1490,2081, 34850,1489,2082, 2083,1487,2083, 34852,1488,2084, 2085,1485,2085, 2086,1486,2086, 34855,1484,2087, 34856,1483,2088, 2089,1481,2089, 34858,1482,2090, 2091,1480,2091, 
2092,1479,2092, 34861,1478,2093, 2094,1476,2094, 34863,1477,2095, 2096,1474,2096, 2097,1475,2097, 34866,1472,2098, 34867,1473,2099, 2100,1471,2100, 2101,1470,2101, 34870,1469,2102, 2103,1468,2103, 34872,1467,2104, 2105,1466,2105, 34874,1464,2106, 2107,1465,2107, 
34876,1462,2108, 34877,1463,2109, 2110,1461,2110, 2111,1458,2111, 34880,1460,2112, 2113,1459,2113, 2114,1457,2114, 2115,1456,2115, 34884,1454,2116, 2117,1455,2117, 34886,1452,2118, 34887,1453,2119, 2120,1451,2120, 2121,1450,2121, 34890,1448,2122, 2123,1449,2123, 
34892,1446,2124, 34893,1447,2125, 2126,1445,2126, 2127,1444,2127, 34896,1443,2128, 2129,1442,2129, 34898,1441,2130, 2131,1440,2131, 34900,1438,2132, 2133,1439,2133, 34902,1436,2134, 34903,1437,2135, 2136,1435,2136, 2137,1432,2137, 34906,1434,2138, 2139,1433,2139, 
2140,1431,2140, 2141,1430,2141, 34910,1428,2142, 2143,1429,2143, 34912,1426,2144, 34913,1427,2145, 2146,1425,2146, 2147,1424,2147, 34916,1423,2148, 2149,1422,2149, 34918,1421,2150, 2151,1420,2151, 34920,1419,2152, 2153,1418,2153, 34922,1417,2154, 2155,1416,2155, 
34924,1415,2156, 2157,1414,2157, 34926,1412,2158, 2159,1413,2159, 34928,1410,2160, 34929,1411,2161, 2162,1409,2162, 2163,1406,2163, 34932,1408,2164, 2165,1407,2165, 2166,1405,2166, 2167,1404,2167, 34936,1402,2168, 2169,1403,2169, 34938,1400,2170, 34939,1401,2171, 
2172,1399,2172, 2173,1398,2173, 34942,1397,2174, 2175,1396,2175, 34944,1395,2176, 2177,1394,2177, 34946,1393,2178, 2179,1392,2179, 34948,1391,2180, 2181,1390,2181, 34950,1389,2182, 2183,1388,2183, 34952,1386,2184, 2185,1387,2185, 34954,1384,2186, 34955,1385,2187, 
2188,1383,2188, 2189,1381,2189, 34958,1382,2190, 2191,1378,2191, 2192,1380,2192, 34961,1379,2193, 34962,1376,2194, 34958,1377,2190, 2188,1375,2188, 2195,1374,2195, 34955,1373,2187, 2196,1371,2196, 34952,1372,2184, 2182,1370,2182, 2197,1369,2197, 34948,1368,2180, 
2198,1367,2198, 34946,1366,2178, 2199,1365,2199, 34944,1363,2176, 2200,1364,2200, 34969,1362,2201, 34942,1361,2174, 2202,1359,2202, 34940,1360,2172, 2171,1357,2171, 2203,1358,2203, 34972,1355,2204, 34936,1356,2168, 2166,1354,2166, 2205,1353,2205, 34933,1352,2165, 
2206,1350,2206, 34932,1351,2164, 2162,1349,2162, 2207,1348,2207, 34929,1347,2161, 2208,1345,2208, 34926,1346,2158, 2156,1344,2156, 2209,1343,2209, 34922,1342,2154, 2210,1341,2210, 34920,1340,2152, 2211,1339,2211, 34918,1337,2150, 2212,1338,2212, 34981,1336,2213, 
34916,1335,2148, 2214,1333,2214, 34914,1334,2146, 2145,1331,2145, 2215,1332,2215, 34984,1329,2216, 34910,1330,2142, 2140,1328,2140, 2217,1327,2217, 34907,1326,2139, 2218,1325,2218, 34906,1324,2138, 2219,1322,2219, 34904,1323,2136, 2135,1321,2135, 2220,1319,2220, 
34900,1320,2132, 2130,1318,2130, 2221,1317,2221, 34896,1316,2128, 2222,1315,2222, 34894,1314,2126, 2223,1313,2223, 34893,1312,2125, 2224,1311,2224, 34890,1309,2122, 2225,1310,2225, 34994,1307,2226, 34888,1308,2120, 2119,1305,2119, 2227,1306,2227, 34996,1303,2228, 
34884,1304,2116, 2114,1302,2114, 2229,1301,2229, 34881,1300,2113, 2230,1298,2230, 34880,1299,2112, 2110,1297,2110, 2231,1296,2231, 34877,1295,2109, 2232,1293,2232, 34874,1294,2106, 2104,1292,2104, 2233,1291,2233, 34870,1290,2102, 2234,1289,2234, 34868,1288,2100, 
2235,1287,2235, 34867,1285,2099, 2236,1286,2236, 35005,1283,2237, 34864,1284,2096, 2095,1282,2095, 2238,1281,2238, 34861,1280,2093, 2239,1279,2239, 34859,1278,2091, 2240,1260,2240, 34858,1277,2090, 2241,1262,2241, 35010,1264,2242, 34856,1276,2088, 2243,1266,2243, 
34853,1275,2085, 2084,1274,2084, 2244,1268,2244, 35013,1271,2245, 34850,1273,2082, 2080,1272,2080, 2079,1270,2079, 2244,1268,2244, 34846,1269,2078, 2075,1267,2075, 2243,1266,2243, 34841,1265,2073, 2242,1264,2242, 34839,1263,2071, 2241,1262,2241, 34838,1261,2070, 
2240,1260,2240, 34835,1259,2067, 2246,1258,2246, 34834,1257,2066, 2247,1256,2247, 34821,1254,2053, 2054,1255,2054, 2055,1526,2055, 2248,1527,2248, 35017,1535,2249, 34824,1524,2056, 2250,1534,2250, 35019,1533,2251, 34825,1522,2057, 2252,1532,2252, 35021,1531,2253, 
34826,1520,2058, 2059,1519,2059, 2254,1538,2254, 35023,1545,2255, 34828,1516,2060, 2061,1515,2061, 2256,1561,2256, 34830,1514,2062, 2257,1571,2257, 35026,1572,2258, 34831,1512,2063, 2259,3110,2259, 34832,1508,2064, 2065,1505,2065, 2260,3111,2260, 34836,1504,2068, 
2261,3112,2261, 34837,1501,2069, 2072,1499,2072, 2262,3113,2262, 35031,3114,2263, 34842,1497,2074, 2264,3115,2264, 34844,1496,2076, 2081,1490,2081, 34845,1492,2077, 
24, // chain 319
2253,1531,2253, 2254,1538,2254, 2265,1539,2265, 
35034,1547,2266, 35035,1546,2267, 35023,1545,2255, 2256,1561,2256, 2268,1557,2268, 35037,1562,2269, 35025,1571,2257, 2258,1572,2258, 2270,1573,2270, 35027,3110,2259, 2271,3116,2271, 35028,3111,2260, 2094,1476,2094, 35029,3112,2261, 2092,1479,2092, 35030,3113,2262, 
2089,1481,2089, 34855,1484,2087, 35031,3114,2263, 2264,3115,2264, 2086,1486,2086, 34851,1487,2083, 34849,1490,2081, 
31, // chain 320
2253,1531,2253, 2265,1539,2265, 2252,1532,2252, 
35040,1540,2272, 35041,1549,2273, 35042,1548,2274, 35034,1547,2266, 2275,1554,2275, 35035,1546,2267, 2268,1557,2268, 2276,1558,2276, 35037,1562,2269, 2277,1563,2277, 35038,1573,2270, 2278,1574,2278, 35047,3117,2279, 35039,3116,2271, 2094,1476,2094, 2097,1475,2097, 
2280,3118,2280, 34892,1446,2124, 34891,1449,2123, 34866,1472,2098, 2101,1470,2101, 2121,1450,2121, 34871,1468,2103, 2118,1452,2118, 34885,1455,2117, 34873,1466,2105, 2107,1465,2107, 2115,1456,2115, 34879,1458,2111, 34876,1462,2108, 
21, // chain 321
2281,1541,2281, 2251,1533,2251, 2252,1532,2252, 
2272,1540,2272, 2282,1550,2282, 35041,1549,2273, 2283,1552,2283, 35052,1553,2284, 35042,1548,2274, 2201,1362,2201, 34968,1364,2200, 35053,1556,2285, 35054,1555,2286, 35043,1554,2275, 2276,1558,2276, 2287,1559,2287, 35056,1565,2288, 35057,1564,2289, 35045,1563,2277, 
2290,1575,2290, 35046,1574,2278, 2280,3118,2280, 35047,3117,2279, 
21, // chain 322
2250,1534,2250, 2251,1533,2251, 2281,1541,2281, 
2291,1542,2291, 35060,1543,2292, 35050,1550,2282, 2283,1552,2283, 2293,1544,2293, 35062,1551,2294, 35052,1553,2284, 2213,1336,2213, 34980,1338,2212, 34969,1362,2201, 2211,1339,2211, 34970,1359,2202, 2203,1358,2203, 2210,1341,2210, 34972,1355,2204, 2209,1343,2209, 
34973,1353,2205, 2208,1345,2208, 34974,1350,2206, 2207,1348,2207, 
3, // chain 323
2248,1527,2248, 2249,1535,2249, 2295,1536,2295, 
35059,1542,2291, 35018,1534,2250, 
17, // chain 324
2291,1542,2291, 2292,1543,2292, 2295,1536,2295, 
35064,1537,2296, 35061,1544,2293, 2297,1530,2297, 35062,1551,2294, 2224,1311,2224, 34981,1336,2213, 2223,1313,2223, 34982,1333,2214, 2215,1332,2215, 2222,1315,2222, 34984,1329,2216, 2221,1317,2221, 34985,1327,2217, 2220,1319,2220, 34986,1325,2218, 2219,1322,2219, 
7, // chain 325
2295,1536,2295, 2296,1537,2296, 2248,1527,2248, 
35066,1529,2298, 35065,1530,2297, 2237,1283,2237, 35004,1286,2236, 34993,1310,2225, 34992,1311,2224, 
4, // chain 326
2248,1527,2248, 2298,1529,2298, 2299,1528,2299, 
35007,1279,2239, 35006,1281,2238, 35005,1283,2237, 
4, // chain 327
2248,1527,2248, 2299,1528,2299, 2247,1256,2247, 
35014,1258,2246, 35008,1260,2240, 35007,1279,2239, 
24, // chain 328
2285,1556,2285, 2286,1555,2286, 2287,1559,2287, 
2300,1560,2300, 35069,1567,2301, 35070,1566,2302, 35056,1565,2288, 2179,1392,2179, 34945,1394,2177, 35057,1564,2289, 2290,1575,2290, 2175,1396,2175, 34919,1420,2151, 35048,3118,2280, 2149,1422,2149, 34892,1446,2124, 2127,1444,2127, 2147,1424,2147, 34897,1442,2129, 
2144,1426,2144, 34911,1429,2143, 34899,1440,2131, 2133,1439,2133, 2141,1430,2141, 34905,1432,2137, 34902,1436,2134, 
8, // chain 329
2285,1556,2285, 2300,1560,2300, 2199,1365,2199, 
35071,1569,2303, 35072,1568,2304, 35069,1567,2301, 2305,1576,2305, 35070,1566,2302, 2181,1390,2181, 34947,1392,2179, 
1, // chain 330
2285,1556,2285, 2199,1365,2199, 2200,1364,2200, 
10, // chain 331
2235,1287,2235, 2236,1286,2236, 2225,1310,2225, 
2226,1307,2226, 2227,1306,2227, 2234,1289,2234, 34996,1303,2228, 2233,1291,2233, 34997,1301,2229, 2232,1293,2232, 34998,1298,2230, 2231,1296,2231, 
9, // chain 332
1372,3119,1372, 2306,3120,2306, 1391,3121,1391, 
34171,3122,1403, 1392,3123,1392, 34161,3124,1393, 34162,3125,1394, 34169,3126,1401, 1399,3127,1399, 1395,3128,1395, 34164,3129,1396, 
13, // chain 333
1385,2011,1385, 1397,2023,1397, 1384,2010,1384, 
35075,3130,2307, 35076,3131,2308, 35077,3132,2309, 34166,2024,1398, 2310,3133,2310, 35079,3134,2311, 34168,2026,1400, 2312,3135,2312, 34170,2028,1402, 2313,3136,2313, 34148,3137,1380, 34147,2029,1379, 
6, // chain 334
2308,3131,2308, 2309,3132,2309, 2310,3133,2310, 
2314,3138,2314, 2315,3139,2315, 35084,3140,2316, 1373,3141,1373, 34143,3142,1375, 
9, // chain 335
2315,3139,2315, 1373,3141,1373, 1371,3143,1371, 
2317,3144,2317, 34138,2006,1370, 1381,2007,1381, 1382,2008,1382, 2318,3145,2318, 34151,2009,1383, 2307,3130,2307, 34152,2010,1384, 
3, // chain 336
2315,3139,2315, 2317,3144,2317, 2308,3131,2308, 
35086,3145,2318, 2307,3130,2307, 
30, // chain 337
2319,3146,2319, 1375,3147,1375, 2316,3148,2316, 
2320,3149,2320, 35089,3150,2321, 35082,3151,2314, 2322,3152,2322, 35078,3153,2310, 2323,3154,2323, 35079,3155,2311, 2324,3156,2324, 35080,3157,2312, 2325,3158,2325, 35081,3159,2313, 2326,3160,2326, 35095,3161,2327, 35096,3162,2328, 34148,3163,1380, 2329,3164,2329, 
34145,3165,1377, 2330,3166,2330, 35099,3167,2331, 35100,3168,2332, 35101,3169,2333, 34144,3170,1376, 2334,3171,2334, 34143,3172,1375, 2319,3173,2319, 2335,3174,2335, 35104,3175,2336, 1430,3176,1430, 34197,3177,1429, 
12, // chain 338
2319,3146,2319, 2320,3149,2320, 2336,3178,2336, 
35105,3179,2337, 35089,3150,2321, 2338,3180,2338, 35090,3152,2322, 2339,3181,2339, 35108,3182,2340, 35091,3154,2323, 2341,3183,2341, 35092,3156,2324, 2342,3184,2342, 35093,3158,2325, 
26, // chain 339
2336,3178,2336, 2337,3179,2337, 1428,3185,1428, 
35106,3180,2338, 1440,3186,1440, 35107,3181,2339, 1439,3187,1439, 35108,3182,2340, 1438,3188,1438, 35109,3183,2341, 1437,3189,1437, 35110,3184,2342, 1436,3190,1436, 35111,3191,2343, 1435,3192,1435, 35112,3193,2344, 1434,3194,1434, 35113,3195,2345, 2346,3196,2346, 
1433,3197,1433, 35115,3198,2347, 1432,3199,1432, 35116,3200,2348, 2349,3201,2349, 1431,3202,1431, 35118,3203,2350, 1430,3176,1430, 35103,3174,2335, 
1, // chain 340
2336,3178,2336, 1428,3185,1428, 1429,3204,1429, 
2, // chain 341
2326,3205,2326, 2351,3206,2351, 2352,3207,2352, 
2325,3208,2325, 
2, // chain 342
2352,3209,2352, 2353,3210,2353, 2342,3211,2342, 
2325,3212,2325, 
2, // chain 343
2354,3213,2354, 2353,3214,2353, 2352,3215,2352, 
2351,3216,2351, 
2, // chain 344
2343,3217,2343, 2354,3218,2354, 2351,3219,2351, 
2326,3220,2326, 
2, // chain 345
2327,3221,2327, 2344,3222,2344, 2343,3223,2343, 
2326,3224,2326, 
2, // chain 346
2355,3225,2355, 2344,3226,2344, 2327,3227,2327, 
2356,3228,2356, 
2, // chain 347
2357,3229,2357, 2358,3230,2358, 2355,3231,2355, 
2356,3232,2356, 
2, // chain 348
2353,3233,2353, 2354,3234,2354, 2343,3235,2343, 
2342,3236,2342, 
2, // chain 349
2359,3237,2359, 2360,3238,2360, 2333,3239,2333, 
2334,3240,2334, 
2, // chain 350
2349,3241,2349, 2332,3242,2332, 2333,3243,2333, 
2350,3244,2350, 
2, // chain 351
2349,3245,2349, 2361,3246,2361, 2362,3247,2362, 
2332,3248,2332, 
2, // chain 352
2360,3249,2360, 2363,3250,2363, 2350,3251,2350, 
2333,3252,2333, 
2, // chain 353
2360,3253,2360, 2359,3254,2359, 2364,3255,2364, 
2363,3256,2363, 
2, // chain 354
2335,3257,2335, 2364,3258,2364, 2359,3259,2359, 
2334,3260,2334, 
2, // chain 355
2350,3261,2350, 2363,3262,2363, 2364,3263,2364, 
2335,3264,2335, 
2, // chain 356
2361,3265,2361, 2365,3266,2365, 2366,3267,2366, 
2362,3268,2362, 
2, // chain 357
2362,3269,2362, 2366,3270,2366, 2331,3271,2331, 
2332,3272,2332, 
2, // chain 358
2347,3273,2347, 2367,3274,2367, 2368,3275,2368, 
2330,3276,2330, 
2, // chain 359
2348,3277,2348, 2347,3278,2347, 2330,3279,2330, 
2331,3280,2331, 
2, // chain 360
2348,3281,2348, 2331,3282,2331, 2366,3283,2366, 
2365,3284,2365, 
2, // chain 361
2345,3285,2345, 2328,3286,2328, 2329,3287,2329, 
2346,3288,2346, 
2, // chain 362
2345,3289,2345, 2358,3290,2358, 2357,3291,2357, 
2328,3292,2328, 
2, // chain 363
2369,3293,2369, 2346,3294,2346, 2329,3295,2329, 
2370,3296,2370, 
2, // chain 364
2355,3297,2355, 2358,3298,2358, 2345,3299,2345, 
2344,3300,2344, 
2, // chain 365
2361,3301,2361, 2349,3302,2349, 2348,3303,2348, 
2365,3304,2365, 
2, // chain 366
2328,3305,2328, 2357,3306,2357, 2356,3307,2356, 
2327,3308,2327, 
2, // chain 367
2369,3309,2369, 2370,3310,2370, 2368,3311,2368, 
2367,3312,2367, 
2, // chain 368
2367,3313,2367, 2347,3314,2347, 2346,3315,2346, 
2369,3316,2369, 
2, // chain 369
2329,3317,2329, 2330,3318,2330, 2368,3319,2368, 
2370,3320,2370, 
4, // chain 370
1378,2003,1378, 1379,2004,1379, 1403,3321,1403, 
2306,3322,2306, 1374,1999,1374, 34140,1997,1372, 
14, // chain 371
2371,3323,2371, 2372,3324,2372, 2373,3325,2373, 
577,3326,577, 2374,3327,2374, 33346,3328,578, 2375,3329,2375, 33348,3330,580, 592,3331,592, 2376,3332,2376, 33362,3333,594, 2377,3334,2377, 33286,3335,518, 33364,3336,596, 520,3337,520, 33365,3338,597, 
11, // chain 372
2377,3339,2377, 518,3340,518, 516,3341,516, 
514,3342,514, 2376,3343,2376, 33279,3344,511, 2375,3345,2375, 35142,3346,2374, 33280,3347,512, 2371,3348,2371, 33981,3349,1213, 1212,3350,1212, 2372,3351,2372, 
14, // chain 373
2378,3352,2378, 2379,3353,2379, 2380,3354,2380, 
1662,3355,1662, 35149,3356,2381, 1663,3357,1663, 35150,3358,2382, 1665,3359,1665, 34436,3360,1668, 35151,3361,2383, 1670,3362,1670, 35152,3363,2384, 1649,3364,1649, 1672,3365,1672, 33288,3366,520, 597,3367,597, 
11, // chain 374
1650,3368,1650, 1649,3369,1649, 2384,3370,2384, 
1651,3371,1651, 35151,3372,2383, 1652,3373,1652, 35150,3374,2382, 2381,3375,2381, 1233,3376,1233, 35148,3377,2380, 1234,3378,1234, 34003,3379,1235, 35147,3380,2379, 
2, // chain 375
2385,3381,2385, 2386,3382,2386, 2387,3383,2387, 
2388,3384,2388, 
2, // chain 376
2389,3385,2389, 2390,3386,2390, 2391,3387,2391, 
2392,3388,2392, 
2, // chain 377
2393,3389,2393, 2394,3390,2394, 2395,3391,2395, 
2396,3392,2396, 
4, // chain 378
2388,3393,2388, 2387,3394,2387, 2397,3395,2397, 
2398,3396,2398, 35167,3397,2399, 2400,3398,2400, 
4, // chain 379
2385,3399,2385, 2388,3400,2388, 2398,3401,2398, 
2401,3402,2401, 35168,3403,2400, 2402,3404,2402, 
4, // chain 380
2403,3405,2403, 2399,3406,2399, 2397,3407,2397, 
2404,3408,2404, 35155,3409,2387, 2386,3410,2386, 
4, // chain 381
2396,3411,2396, 2395,3412,2395, 2405,3413,2405, 
2406,3414,2406, 35160,3415,2392, 2391,3416,2391, 
4, // chain 382
2393,3417,2393, 2396,3418,2396, 2406,3419,2406, 
2407,3420,2407, 35159,3421,2391, 2390,3422,2390, 
4, // chain 383
2389,3423,2389, 2392,3424,2392, 2405,3425,2405, 
2408,3426,2408, 35163,3427,2395, 2394,3428,2394, 
14, // chain 384
411,3429,411, 670,3430,670, 412,3431,412, 
33437,3432,669, 2409,3433,2409, 33436,3434,668, 2410,3435,2410, 33435,3436,667, 2411,3437,2411, 35180,3435,2412, 34534,3434,1766, 2413,3433,2413, 34535,3432,1767, 1572,3431,1572, 34536,3430,1768, 1573,3429,1573, 
19, // chain 385
412,3431,412, 2409,3433,2409, 2414,3438,2414, 
35183,3439,2415, 35184,3440,2416, 35178,3435,2410, 2417,3441,2417, 35179,3437,2411, 2412,3435,2412, 2418,3440,2418, 35181,3433,2413, 2419,3439,2419, 35188,3438,2420, 34340,3431,1572, 1577,3442,1577, 2421,3443,2421, 35190,3444,2422, 35191,3445,2423, 34349,3446,1581, 
1529,3447,1529, 34296,3448,1528, 
25, // chain 386
412,3431,412, 2414,3438,2414, 416,3442,416, 
35192,3443,2424, 35193,3449,2425, 35183,3439,2415, 2426,3450,2426, 35195,3451,2427, 35184,3440,2416, 2428,3452,2428, 35185,3441,2417, 2418,3440,2418, 2429,3451,2429, 35187,3439,2419, 2430,3450,2430, 35199,3449,2431, 35188,3438,2420, 2421,3443,2421, 2432,3453,2432, 
35201,3454,2433, 35190,3444,2422, 1829,3455,1829, 34599,3456,1831, 34601,3457,1833, 35191,3445,2423, 1527,3458,1527, 34297,3447,1529, 
14, // chain 387
2427,3451,2427, 2428,3452,2428, 2434,3459,2434, 
35203,3460,2435, 35204,3459,2436, 35197,3451,2429, 2430,3450,2430, 2437,3461,2437, 35206,3462,2438, 35199,3449,2431, 2432,3453,2432, 2439,3463,2439, 35208,3464,2440, 35201,3454,2433, 1827,3465,1827, 34597,3455,1829, 
18, // chain 388
2427,3451,2427, 2434,3459,2434, 2426,3450,2426, 
35209,3461,2441, 35210,3466,2442, 35203,3460,2435, 2443,3467,2443, 35212,3466,2444, 35204,3459,2436, 2437,3461,2437, 2445,3468,2445, 35214,3469,2446, 35206,3462,2438, 2439,3463,2439, 2447,3470,2447, 35216,3471,2448, 34407,3472,1639, 34408,3473,1640, 35208,3464,2440, 
1827,3465,1827, 
19, // chain 389
416,3442,416, 2424,3443,2424, 2449,3444,2449, 
35218,3454,2450, 35219,3453,2451, 35193,3449,2425, 2452,3462,2452, 35194,3450,2426, 2441,3461,2441, 2453,3469,2453, 35222,3468,2454, 35210,3466,2442, 2455,3474,2455, 35224,3475,2456, 35211,3467,2443, 2444,3466,2444, 2457,3474,2457, 35213,3468,2445, 2458,3476,2458, 
35215,3470,2447, 35214,3469,2446, 
30, // chain 390
416,3442,416, 2449,3444,2449, 2459,3445,2459, 
33454,3457,686, 33455,3456,687, 33457,3455,689, 35218,3454,2450, 691,3465,691, 35228,3464,2460, 35219,3453,2451, 2461,3463,2461, 35220,3462,2452, 2453,3469,2453, 2462,3470,2462, 35222,3468,2454, 2463,3476,2463, 35223,3474,2455, 486,3477,486, 33251,3478,483, 
35224,3475,2456, 2457,3474,2457, 1633,3477,1633, 35226,3476,2458, 1634,3479,1634, 34404,3480,1636, 35232,3481,2464, 35215,3470,2447, 2465,3482,2465, 35216,3471,2448, 1524,3483,1524, 34407,3472,1639, 1523,3484,1523, 
4, // chain 391
416,3442,416, 2459,3445,2459, 420,3446,420, 
33136,3447,368, 33132,3458,364, 33454,3457,686, 
1, // chain 392
420,3446,420, 368,3447,368, 367,3448,367, 
12, // chain 393
486,3477,486, 490,3479,490, 2463,3476,2463, 
33263,3480,495, 2466,3481,2466, 35235,3485,2467, 33266,3486,498, 359,3487,359, 358,3488,358, 2468,3482,2468, 33131,3483,363, 2469,3471,2469, 33270,3472,502, 33130,3484,362, 
8, // chain 394
2467,3485,2467, 2468,3482,2468, 2466,3481,2466, 
35230,3470,2462, 35237,3471,2469, 2461,3463,2461, 33270,3472,502, 503,3473,503, 2460,3464,2460, 33459,3465,691, 
1, // chain 395
2466,3481,2466, 2462,3470,2462, 2463,3476,2463, 
4, // chain 396
1636,3480,1636, 2464,3481,2464, 2470,3485,2470, 
35233,3482,2465, 1521,3488,1521, 34292,3483,1524, 
3, // chain 397
1636,3480,1636, 2470,3485,2470, 1637,3486,1637, 
34288,3487,1520, 34289,3488,1521, 
2, // chain 398
2471,3489,2471, 2472,3490,2472, 2473,3491,2473, 
2474,3492,2474, 
2, // chain 399
2475,3493,2475, 2471,3494,2471, 2474,3495,2474, 
2476,3496,2476, 
2, // chain 400
2477,3497,2477, 2475,3498,2475, 2476,3499,2476, 
2478,3500,2478, 
2, // chain 401
2479,3501,2479, 2480,3502,2480, 2477,3503,2477, 
2478,3504,2478, 
4, // chain 402
1218,3505,1218, 2481,3506,2481, 1211,3507,1211, 
35140,3508,2372, 35250,3509,2482, 35251,3510,2483, 
1, // chain 403
1211,3507,1211, 2372,3508,2372, 1212,3511,1212, 
2, // chain 404
2483,3512,2483, 2481,3513,2481, 2484,3514,2484, 
2485,3515,2485, 
3, // chain 405
2481,3516,2481, 1218,3517,1218, 2484,3518,2484, 
35247,3519,2479, 35248,3520,2480, 
2, // chain 406
2373,3521,2373, 2372,3522,2372, 2482,3523,2482, 
2486,3524,2486, 
2, // chain 407
2482,3525,2482, 2483,3526,2483, 2485,3527,2485, 
2486,3528,2486, 
11, // chain 408
2487,3529,2487, 2488,3530,2488, 521,3531,521, 
523,3532,523, 2473,3533,2473, 33305,3534,537, 2474,3535,2474, 35247,3536,2479, 33313,3537,545, 2484,3538,2484, 35141,3539,2373, 33344,3540,576, 577,3541,577, 
2, // chain 409
2485,3542,2485, 2484,3543,2484, 2373,3544,2373, 
2486,3545,2486, 
2, // chain 410
2476,3546,2476, 2474,3547,2474, 2479,3548,2479, 
2478,3549,2478, 
2, // chain 411
2487,3550,2487, 2473,3551,2473, 2489,3552,2489, 
2490,3553,2490, 
4, // chain 412
2488,3554,2488, 2487,3555,2487, 2491,3556,2491, 
2492,3557,2492, 2493,3558,2493, 2494,3559,2494, 
2, // chain 413
2495,3560,2495, 2491,3561,2491, 2487,3562,2487, 
2490,3563,2490, 
2, // chain 414
2496,3564,2496, 2495,3565,2495, 2490,3566,2490, 
2489,3567,2489, 
2, // chain 415
2473,3568,2473, 2472,3569,2472, 2496,3570,2496, 
2489,3571,2489, 
6, // chain 416
2480,3572,2480, 1218,3573,1218, 1217,3574,1217, 
2477,3575,2477, 35243,3576,2475, 35239,3577,2471, 35265,3578,2497, 33988,3579,1220, 
9, // chain 417
2471,3577,2471, 2497,3578,2497, 1224,3580,1224, 
1223,3581,1223, 2472,3582,2472, 34253,3583,1485, 2496,3584,2496, 35263,3585,2495, 35259,3586,2491, 34255,3587,1487, 2492,3588,2492, 
2, // chain 418
2498,3589,2498, 2499,3590,2499, 2500,3591,2500, 
2501,3592,2501, 
2, // chain 419
2502,3593,2502, 2503,3594,2503, 2499,3595,2499, 
2498,3596,2498, 
2, // chain 420
2504,3597,2504, 2505,3598,2505, 2503,3599,2503, 
2502,3600,2502, 
2, // chain 421
2506,3601,2506, 2505,3602,2505, 2504,3603,2504, 
2507,3604,2507, 
3, // chain 422
1242,3605,1242, 1236,3606,1236, 2508,3607,2508, 
35147,3608,2379, 34003,3609,1235, 
2, // chain 423
2508,3607,2508, 2379,3608,2379, 2509,3610,2509, 
2510,3611,2510, 
2, // chain 424
2510,3612,2510, 2511,3613,2511, 2512,3614,2512, 
2508,3615,2508, 
3, // chain 425
2508,3616,2508, 2512,3617,2512, 1242,3618,1242, 
35274,3619,2506, 2507,3620,2507, 
2, // chain 426
2378,3621,2378, 2513,3622,2513, 2509,3623,2509, 
2379,3624,2379, 
2, // chain 427
2509,3625,2509, 2513,3626,2513, 2511,3627,2511, 
2510,3628,2510, 
11, // chain 428
521,3629,521, 2488,3630,2488, 2494,3631,2494, 
1653,3632,1653, 35268,3633,2500, 1655,3634,1655, 35267,3635,2499, 2506,3636,2506, 1657,3637,1657, 35280,3638,2512, 2378,3639,2378, 1660,3640,1660, 34430,3641,1662, 
2, // chain 429
2511,3642,2511, 2513,3643,2513, 2378,3644,2378, 
2512,3645,2512, 
2, // chain 430
2503,3646,2503, 2505,3647,2505, 2506,3648,2506, 
2499,3649,2499, 
2, // chain 431
2494,3650,2494, 2514,3651,2514, 2515,3652,2515, 
2500,3653,2500, 
2, // chain 432
2516,3654,2516, 2514,3655,2514, 2494,3656,2494, 
2493,3657,2493, 
2, // chain 433
2517,3658,2517, 2515,3659,2515, 2514,3660,2514, 
2516,3661,2516, 
2, // chain 434
2500,3662,2500, 2515,3663,2515, 2517,3664,2517, 
2501,3665,2501, 
14, // chain 435
1241,3666,1241, 1242,3667,1242, 2507,3668,2507, 
2504,3669,2504, 2502,3670,2502, 2498,3671,2498, 2518,3672,2518, 34019,3673,1251, 34018,3674,1250, 35269,3675,2501, 1488,3676,1488, 35285,3677,2517, 2516,3678,2516, 2493,3679,2493, 1487,3680,1487, 35260,3681,2492, 
1, // chain 436
1241,3666,1241, 2518,3672,2518, 1245,3682,1245, 
44, // chain 437
2519,3683,2519, 2520,3684,2520, 2521,3685,2521, 
2522,3686,2522, 35291,3687,2523, 2524,3688,2524, 35293,3689,2525, 2526,3690,2526, 2527,3691,2527, 35296,3692,2528, 2529,3693,2529, 35298,3694,2530, 2531,3695,2531, 35300,3696,2532, 35301,3697,2533, 2534,3698,2534, 35303,3699,2535, 2536,3700,2536, 35305,3701,2537, 
2538,3702,2538, 35307,3703,2539, 2540,3704,2540, 35309,3705,2541, 2542,3706,2542, 35311,3707,2543, 2544,3708,2544, 35313,3709,2545, 2546,3710,2546, 2547,3711,2547, 35316,3712,2548, 35317,3713,2549, 2550,3714,2550, 2551,3715,2551, 35320,3716,2552, 35321,3717,2553, 
2554,3718,2554, 35323,3719,2555, 2556,3720,2556, 35325,3721,2557, 2558,3722,2558, 35327,3723,2559, 2560,3724,2560, 35329,3725,2561, 2562,3726,2562, 2563,3727,2563, 35332,3728,2564, 
44, // chain 438
2565,3729,2565, 2566,3730,2566, 2567,3731,2567, 
2568,3732,2568, 2569,3733,2569, 35338,3734,2570, 2571,3735,2571, 35340,3736,2572, 35341,3737,2573, 2574,3738,2574, 35343,3739,2575, 2576,3740,2576, 35345,3741,2577, 2578,3742,2578, 2579,3743,2579, 35348,3744,2580, 2581,3745,2581, 35350,3746,2582, 2583,3747,2583, 
35352,3748,2584, 2585,3749,2585, 35354,3750,2586, 2587,3751,2587, 35356,3752,2588, 2589,3753,2589, 35358,3754,2590, 2591,3755,2591, 35360,3756,2592, 35361,3757,2593, 2594,3758,2594, 2595,3759,2595, 35364,3760,2596, 35365,3761,2597, 2598,3762,2598, 2599,3763,2599, 
35368,3764,2600, 2601,3765,2601, 35370,3766,2602, 2603,3767,2603, 35372,3768,2604, 2605,3769,2605, 35374,3770,2606, 2607,3771,2607, 35376,3772,2608, 35377,3773,2609, 2610,3774,2610, 
4, // chain 439
1032,1508,1032, 1033,1512,1033, 2611,3110,2611, 
33855,1572,1087, 33802,1514,1034, 1086,1571,1086, 
5, // chain 440
1032,1508,1032, 2611,3110,2611, 1031,1505,1031, 
35380,3111,2612, 35381,3116,2613, 33856,1573,1088, 33855,1572,1087, 
12, // chain 441
1031,1505,1031, 2612,3111,2612, 1030,1504,1030, 
35382,3112,2614, 33786,1476,1018, 35381,3116,2613, 2615,3117,2615, 33856,1573,1088, 1089,1574,1089, 2616,3118,2616, 33858,1575,1090, 992,1420,992, 33749,1396,981, 33748,1394,980, 
2, // chain 442
1028,1499,1028, 1029,1501,1029, 2614,3112,2614, 
33798,1504,1030, 
5, // chain 443
1018,1476,1018, 2615,3117,2615, 1017,1475,1017, 
35384,3118,2616, 1004,1446,1004, 33761,1422,993, 33760,1420,992, 
12, // chain 444
1004,1446,1004, 1005,1449,1005, 1017,1475,1017, 
33784,1472,1016, 33783,1470,1015, 33774,1450,1006, 1014,1468,1014, 33775,1452,1007, 1008,1455,1008, 1013,1466,1013, 33780,1465,1012, 33777,1456,1009, 1010,1458,1010, 1011,1462,1011, 
10, // chain 445
1003,1444,1003, 1004,1446,1004, 993,1422,993, 
994,1424,994, 1002,1442,1002, 33763,1426,995, 996,1429,996, 1001,1440,1001, 33768,1439,1000, 33765,1430,997, 998,1432,998, 999,1436,999, 
10, // chain 446
991,1418,991, 992,1420,992, 981,1396,981, 
982,1398,982, 990,1416,990, 33751,1400,983, 984,1403,984, 989,1414,989, 33756,1413,988, 33753,1404,985, 986,1406,986, 987,1410,987, 
7, // chain 447
977,1388,977, 978,1390,978, 2617,3775,2617, 
33859,1576,1091, 1092,1577,1092, 2618,3776,2618, 33741,1380,973, 33853,1570,1085, 972,1379,972, 
4, // chain 448
976,1387,976, 977,1388,977, 2617,3775,2617, 
2618,3776,2618, 974,1381,974, 33741,1380,973, 
1, // chain 449
974,1381,974, 975,1384,975, 976,1387,976, 
11, // chain 450
1018,1476,1018, 1019,1479,1019, 2614,3112,2614, 
35387,3113,2619, 33788,1481,1020, 1021,1484,1021, 2620,3114,2620, 35389,3115,2621, 33790,1486,1022, 1023,1487,1023, 1024,1490,1024, 1026,1496,1026, 33793,1492,1025, 
4, // chain 451
2619,3113,2619, 2620,3114,2620, 1028,1499,1028, 
33795,1497,1027, 35389,3115,2621, 1026,1496,1026, 
1, // chain 452
2619,3113,2619, 1028,1499,1028, 2614,3112,2614, 
16, // chain 453
1635,3777,1635, 1244,3778,1244, 1265,3779,1265, 
34011,3780,1243, 1274,3781,1274, 34043,3782,1275, 34013,3783,1245, 2518,3784,2518, 1278,3785,1278, 34041,3786,1273, 34019,3787,1251, 1249,3788,1249, 1270,3789,1270, 34037,3790,1269, 34016,3791,1248, 1635,3777,1635, 1264,3792,1264, 34033,3779,1265, 
8, // chain 454
1267,3793,1267, 1266,3794,1266, 2622,3795,2622, 
1268,3796,1268, 34039,3797,1271, 34040,3798,1272, 34047,3799,1279, 34044,3800,1276, 34045,3801,1277, 34034,3794,1266, 
14, // chain 455
1224,3802,1224, 2497,3803,2497, 1261,3804,1261, 
33988,3805,1220, 1262,3806,1262, 33987,3807,1219, 1263,3808,1263, 34026,3809,1258, 33262,3810,494, 491,3811,491, 1259,3812,1259, 33260,3813,492, 1222,3814,1222, 1260,3815,1260, 34029,3804,1261, 33992,3802,1224, 
14, // chain 456
1457,3816,1457, 1453,3817,1453, 2623,3818,2623, 
34096,3819,1328, 1326,3820,1326, 1325,3821,1325, 2624,3822,2624, 35393,3823,2625, 34077,3824,1309, 1298,3825,1298, 2626,3826,2626, 34067,3827,1299, 1457,3816,1457, 2623,3818,2623, 2624,3822,2624, 2625,3823,2625, 
10, // chain 457
2151,1420,2151, 2153,1418,2153, 2175,1396,2175, 
34941,1398,2173, 34923,1416,2155, 2170,1400,2170, 34937,1403,2169, 34925,1414,2157, 2159,1413,2159, 2167,1404,2167, 34931,1406,2163, 34928,1410,2160, 
5, // chain 458
2181,1390,2181, 2183,1388,2183, 2627,3775,2627, 
34953,1387,2185, 2628,3776,2628, 34957,1381,2189, 34954,1384,2186, 
8, // chain 459
2189,1381,2189, 2192,1380,2192, 2628,3776,2628, 
35397,1577,2629, 35398,1570,2630, 34961,1379,2193, 2197,1369,2197, 34964,1371,2196, 34962,1376,2194, 2195,1374,2195, 
7, // chain 460
2627,3775,2627, 2628,3776,2628, 2629,1577,2629, 
2305,1576,2305, 35072,1568,2304, 35398,1570,2630, 2303,1569,2303, 34966,1367,2198, 34965,1369,2197, 
1, // chain 461
2627,3775,2627, 2305,1576,2305, 2181,1390,2181, 
1, // chain 462
2303,1569,2303, 2198,1367,2198, 2199,1365,2199, 
32, // chain 463
2408,3828,2408, 2394,3829,2394, 2631,3830,2631, 
2389,3831,2389, 33246,3832,478, 35400,3833,2632, 2633,3834,2633, 477,3835,477, 35402,3836,2634, 2635,3837,2635, 2636,3838,2636, 476,3839,476, 33247,3840,479, 35405,3841,2637, 2638,3842,2638, 480,3843,480, 33249,3844,481, 35407,3845,2639, 2640,3846,2640, 
2641,3847,2641, 482,3848,482, 35410,3849,2642, 2631,3830,2631, 2394,3829,2394, 1632,3850,1632, 35161,3851,2393, 2386,3852,2386, 35175,3853,2407, 2404,3854,2404, 35171,3855,2403, 35158,3856,2390, 1629,3857,1629, 35157,3831,2389, 478,3832,478, 
8, // chain 464
1632,3850,1632, 2386,3852,2386, 2385,3858,2385, 
1631,3859,1631, 34398,3860,1630, 35169,3861,2401, 1628,3862,1628, 35170,3863,2402, 1629,3857,1629, 35171,3855,2403, 
95, // chain 465
2643,3864,2643, 2644,3865,2644, 2645,3866,2645, 
2646,3867,2646, 35415,3868,2647, 35416,3869,2648, 35417,3870,2649, 35418,3871,2650, 35412,3865,2644, 2651,3872,2651, 35420,3873,2652, 2653,3874,2653, 35422,3875,2654, 2655,3876,2655, 2656,3877,2656, 35425,3878,2657, 2658,3879,2658, 35427,3880,2659, 35428,3881,2660, 
35429,3882,2661, 2662,3883,2662, 2663,3884,2663, 35432,3885,2664, 2665,3886,2665, 35434,3887,2666, 2667,3888,2667, 35436,3889,2668, 2669,3890,2669, 35438,3891,2670, 2671,3892,2671, 35440,3893,2672, 35441,3894,2673, 2674,3895,2674, 2675,3896,2675, 35444,3897,2676, 
35445,3898,2677, 2678,3899,2678, 35447,3900,2679, 2680,3901,2680, 35449,3902,2681, 2682,3903,2682, 2683,3904,2683, 35452,3905,2684, 2685,3906,2685, 35454,3907,2686, 2687,3908,2687, 35456,3909,2688, 2689,3910,2689, 33434,3911,666, 665,3912,665, 2690,3913,2690, 
33432,3914,664, 2691,3915,2691, 35460,3916,2692, 33431,3917,663, 2693,3918,2693, 33430,3919,662, 2694,3920,2694, 35463,3921,2695, 33429,3922,661, 2696,3923,2696, 35465,3924,2697, 35466,3925,2698, 33428,3926,660, 2699,3927,2699, 33427,3928,659, 2700,3929,2700, 
2701,3930,2701, 2702,3931,2702, 35471,3932,2703, 2704,3933,2704, 35473,3934,2705, 35474,3935,2706, 2707,3936,2707, 2708,3937,2708, 35477,3938,2709, 2710,3939,2710, 35479,3940,2711, 2712,3941,2712, 35481,3942,2713, 2714,3943,2714, 35483,3944,2715, 35484,3945,2716, 
2717,3946,2717, 35486,3947,2718, 2719,3948,2719, 35488,3949,2720, 2721,3950,2721, 35490,3951,2722, 2723,3952,2723, 35492,3953,2724, 2725,3954,2725, 35494,3955,2726, 2727,3956,2727, 2728,3957,2728, 35415,3868,2647, 35414,3867,2646, 
85, // chain 466
2715,3944,2715, 2717,3946,2717, 2729,3958,2729, 
35498,3959,2730, 35487,3948,2719, 2731,3960,2731, 35489,3950,2721, 2732,3961,2732, 35501,3962,2733, 35491,3952,2723, 2734,3963,2734, 35493,3954,2725, 2735,3964,2735, 35496,3957,2728, 2647,3868,2647, 2736,3965,2736, 35416,3869,2648, 2737,3966,2737, 35506,3967,2738, 
35417,3870,2649, 2739,3968,2739, 35508,3969,2740, 35418,3871,2650, 2651,3872,2651, 2741,3970,2741, 35421,3874,2653, 2742,3971,2742, 35424,3877,2656, 2743,3972,2743, 35512,3973,2744, 35426,3879,2658, 2659,3880,2659, 2745,3974,2745, 35428,3881,2660, 2746,3975,2746, 
35431,3884,2663, 2747,3976,2747, 35433,3886,2665, 2748,3977,2748, 35435,3888,2667, 2749,3978,2749, 35437,3890,2669, 2750,3979,2750, 35439,3892,2671, 2751,3980,2751, 35520,3981,2752, 35440,3893,2672, 2675,3896,2675, 2753,3982,2753, 35444,3897,2676, 2754,3983,2754, 
35523,3984,2755, 35446,3899,2678, 2756,3985,2756, 35448,3901,2680, 2683,3904,2683, 2757,3986,2757, 35453,3906,2685, 2758,3987,2758, 35455,3908,2687, 2759,3988,2759, 35528,3989,2760, 35457,3910,2689, 2761,3990,2761, 35458,3913,2690, 2762,3991,2762, 35531,3992,2763, 
35532,3993,2764, 35459,3915,2691, 2692,3916,2692, 2765,3994,2765, 35534,3995,2766, 35461,3918,2693, 2767,3996,2767, 35462,3920,2694, 2768,3997,2768, 35288,3998,2520, 35463,3921,2695, 2564,3999,2564, 35537,4000,2769, 35464,3923,2696, 2770,4001,2770, 35465,3924,2697, 
2771,4002,2771, 35466,3925,2698, 2702,3931,2702, 35467,3927,2699, 
9, // chain 467
2736,3965,2736, 2737,3966,2737, 2772,4003,2772, 
35541,4004,2773, 35542,4005,2774, 35506,3967,2738, 2775,4006,2775, 35507,3968,2739, 2776,4007,2776, 35509,3970,2741, 35508,3969,2740, 
14, // chain 468
2736,3965,2736, 2772,4003,2772, 2735,3964,2735, 
35545,4008,2777, 35541,4004,2773, 2778,4009,2778, 35547,4010,2779, 35542,4005,2774, 2780,4011,2780, 35543,4006,2775, 2781,4012,2781, 35550,4013,2782, 35544,4007,2776, 2783,4014,2783, 35510,3971,2742, 35509,3970,2741, 
93, // chain 469
2735,3964,2735, 2777,4008,2777, 2734,3963,2734, 
35552,4015,2784, 35546,4009,2778, 2785,4016,2785, 35554,4017,2786, 35547,4010,2779, 2787,4018,2787, 35548,4011,2780, 2542,4019,2542, 35308,4020,2540, 35556,4021,2788, 35549,4012,2781, 2789,4022,2789, 35550,4013,2782, 2790,4023,2790, 35551,4014,2783, 2791,4024,2791, 
35560,4025,2792, 35510,3971,2742, 2743,3972,2743, 2793,4026,2793, 35512,3973,2744, 2794,4027,2794, 35513,3974,2745, 2746,3975,2746, 2795,4028,2795, 35515,3976,2747, 2796,4029,2796, 35516,3977,2748, 2797,4030,2797, 35517,3978,2749, 2798,4031,2798, 35518,3979,2750, 
2799,4032,2799, 35519,3980,2751, 2800,4033,2800, 35569,4034,2801, 35520,3981,2752, 2802,4035,2802, 35521,3982,2753, 2803,4036,2803, 35522,3983,2754, 2804,4037,2804, 35523,3984,2755, 2805,4038,2805, 35524,3985,2756, 2757,3986,2757, 2806,4039,2806, 35526,3987,2758, 
2807,4040,2807, 35527,3988,2759, 2808,4041,2808, 35577,4042,2809, 35578,4043,2810, 35528,3989,2760, 2811,4044,2811, 35529,3990,2761, 2762,3991,2762, 2812,4045,2812, 35581,4046,2813, 35531,3992,2763, 2814,4047,2814, 35532,3993,2764, 2765,3994,2765, 2815,4048,2815, 
35584,4049,2816, 35534,3995,2766, 2817,4050,2817, 35586,4051,2818, 35587,4052,2819, 35535,3996,2767, 2768,3997,2768, 2820,4053,2820, 35288,3998,2520, 2519,4054,2519, 2821,4055,2821, 35290,4056,2522, 2524,4057,2524, 2527,4058,2527, 2822,4059,2822, 35297,4060,2529, 
2823,4061,2823, 35299,4062,2531, 2824,4063,2824, 35300,4064,2532, 2825,4065,2825, 35302,4066,2534, 2826,4067,2826, 35304,4068,2536, 2827,4069,2827, 35306,4070,2538, 2788,4021,2788, 35308,4020,2540, 
34, // chain 470
2734,3963,2734, 2784,4015,2784, 2733,3962,2733, 
35553,4016,2785, 2732,3961,2732, 35596,4071,2828, 35554,4017,2786, 2829,4072,2829, 35555,4018,2787, 2830,4073,2830, 35310,4019,2542, 2831,4074,2831, 35312,4075,2544, 2547,4076,2547, 2832,4077,2832, 35601,4078,2833, 35316,4079,2548, 2834,4080,2834, 35319,4081,2551, 
2552,4082,2552, 2554,4083,2554, 2556,4084,2556, 2835,4085,2835, 35326,4086,2558, 2836,4087,2836, 35328,4088,2560, 2837,4089,2837, 35331,4090,2563, 2564,3999,2564, 2769,4000,2769, 2770,4001,2770, 2838,4091,2838, 35607,4092,2839, 35539,4002,2771, 2704,3933,2704, 
35470,3931,2702, 
19, // chain 471
2732,3961,2732, 2828,4071,2828, 2840,4093,2840, 
35597,4072,2829, 2841,4094,2841, 35610,4095,2842, 35598,4073,2830, 2831,4074,2831, 2832,4077,2832, 2843,4096,2843, 35612,4097,2844, 35613,4098,2845, 35601,4078,2833, 2834,4080,2834, 2846,4099,2846, 35615,4100,2847, 35603,4085,2835, 2836,4087,2836, 2848,4101,2848, 
35606,4091,2838, 35605,4089,2837, 
5, // chain 472
2732,3961,2732, 2840,4093,2840, 2731,3960,2731, 
35498,3959,2730, 35609,4094,2841, 2843,4096,2843, 35610,4095,2842, 
13, // chain 473
2730,3959,2730, 2843,4096,2843, 2729,3958,2729, 
35617,4102,2849, 35612,4097,2844, 2845,4098,2845, 2850,4103,2850, 35614,4099,2846, 2851,4104,2851, 35620,4105,2852, 35615,4100,2847, 2853,4106,2853, 35616,4101,2848, 2839,4092,2839, 35606,4091,2838, 
11, // chain 474
2729,3958,2729, 2849,4102,2849, 2714,3943,2714, 
35618,4103,2850, 2712,3941,2712, 35619,4104,2851, 2710,3939,2710, 35620,4105,2852, 2708,3937,2708, 35621,4106,2853, 2705,3934,2705, 35472,3933,2704, 35607,4092,2839, 
1, // chain 475
2729,3958,2729, 2714,3943,2714, 2715,3944,2715, 
47, // chain 476
2788,4021,2788, 2789,4022,2789, 2827,4069,2827, 
35622,4107,2854, 35623,4108,2855, 35558,4023,2790, 2791,4024,2791, 2856,4109,2856, 35625,4110,2857, 35560,4025,2792, 2793,4026,2793, 2858,4111,2858, 35562,4027,2794, 2795,4028,2795, 2859,4112,2859, 35564,4029,2796, 2860,4113,2860, 35565,4030,2797, 2861,4114,2861, 
35566,4031,2798, 2862,4115,2862, 35567,4032,2799, 2863,4116,2863, 35568,4033,2800, 2864,4117,2864, 35633,4118,2865, 35569,4034,2801, 2802,4035,2802, 2866,4119,2866, 35571,4036,2803, 2804,4037,2804, 2867,4120,2867, 35636,4121,2868, 35573,4038,2805, 2869,4122,2869, 
35638,4123,2870, 35574,4039,2806, 2871,4124,2871, 35640,4125,2872, 35575,4040,2807, 2808,4041,2808, 2873,4126,2873, 35642,4127,2874, 35577,4042,2809, 2875,4128,2875, 35644,4129,2876, 35580,4045,2812, 35578,4043,2810, 2811,4044,2811, 
17, // chain 477
2820,4053,2820, 2821,4055,2821, 2877,4130,2877, 
35590,4059,2822, 2878,4131,2878, 35591,4061,2823, 2879,4132,2879, 35592,4063,2824, 2880,4133,2880, 35593,4065,2825, 2881,4134,2881, 35650,4135,2882, 35594,4067,2826, 2883,4136,2883, 35595,4069,2827, 2854,4107,2854, 2884,4137,2884, 35624,4109,2856, 35623,4108,2855, 
58, // chain 478
2883,4136,2883, 2884,4137,2884, 2885,4138,2885, 
35654,4139,2886, 35624,4109,2856, 2857,4110,2857, 2858,4111,2858, 2859,4112,2859, 2887,4140,2887, 35628,4113,2860, 2888,4141,2888, 35629,4114,2861, 2889,4142,2889, 35630,4115,2862, 2890,4143,2890, 35631,4116,2863, 2891,4144,2891, 35632,4117,2864, 2892,4145,2892, 
35633,4118,2865, 2893,4146,2893, 35634,4119,2866, 2867,4120,2867, 2894,4147,2894, 35663,4148,2895, 35636,4121,2868, 2869,4122,2869, 2896,4149,2896, 35638,4123,2870, 2897,4150,2897, 35639,4124,2871, 2898,4151,2898, 35640,4125,2872, 2873,4126,2873, 2899,4152,2899, 
35668,4153,2900, 35642,4127,2874, 2901,4154,2901, 35643,4128,2875, 2902,4155,2902, 35671,4156,2903, 35644,4129,2876, 2904,4157,2904, 35580,4045,2812, 2813,4046,2813, 2905,4158,2905, 35674,4159,2906, 35582,4047,2814, 2815,4048,2815, 2907,4160,2907, 35584,4049,2816, 
2908,4161,2908, 35585,4050,2817, 2909,4162,2909, 35586,4051,2818, 2910,4163,2910, 35646,4131,2878, 35645,4130,2877, 35587,4052,2819, 2820,4053,2820, 
4, // chain 479
2883,4136,2883, 2885,4138,2885, 2882,4135,2882, 
35679,4164,2911, 35655,4140,2887, 35654,4139,2886, 
6, // chain 480
2882,4135,2882, 2911,4164,2911, 2881,4134,2881, 
35680,4165,2912, 35681,4166,2913, 35657,4142,2889, 35656,4141,2888, 35655,4140,2887, 
6, // chain 481
2881,4134,2881, 2912,4165,2912, 2914,4167,2914, 
35683,4168,2915, 35681,4166,2913, 2916,4169,2916, 35658,4143,2890, 35657,4142,2889, 
12, // chain 482
2881,4134,2881, 2914,4167,2914, 2880,4133,2880, 
35685,4170,2917, 35686,4171,2918, 35683,4168,2915, 2919,4172,2919, 35688,4173,2920, 35662,4147,2894, 35660,4145,2892, 35689,4174,2921, 35684,4169,2916, 2891,4144,2891, 35658,4143,2890, 
19, // chain 483
2880,4133,2880, 2917,4170,2917, 2879,4132,2879, 
35678,4163,2910, 35677,4162,2909, 35686,4171,2918, 2919,4172,2919, 2908,4161,2908, 35675,4160,2907, 35690,4175,2922, 35688,4173,2920, 2923,4176,2923, 35692,4177,2924, 35662,4147,2894, 2895,4148,2895, 2925,4178,2925, 35694,4179,2926, 35664,4149,2896, 2899,4152,2899, 
35665,4150,2897, 2898,4151,2898, 
1, // chain 484
2879,4132,2879, 2910,4163,2910, 2878,4131,2878, 
1, // chain 485
2891,4144,2891, 2892,4145,2892, 2921,4174,2921, 
1, // chain 486
2894,4147,2894, 2892,4145,2892, 2893,4146,2893, 
54, // chain 487
2520,3998,2520, 2564,3999,2564, 2521,4180,2521, 
35330,4181,2562, 2523,4182,2523, 35329,4183,2561, 2525,4184,2525, 35327,4185,2559, 2557,4186,2557, 2526,4187,2526, 35323,4188,2555, 2528,4189,2528, 35321,4190,2553, 2530,4191,2530, 35695,4192,2927, 35318,4193,2550, 2928,4194,2928, 35697,4195,2929, 35317,4196,2549, 
2546,4197,2546, 2930,4198,2930, 35699,4199,2931, 35313,4200,2545, 2543,4201,2543, 2932,4202,2932, 35701,4203,2933, 35309,4204,2541, 2934,4205,2934, 35307,4206,2539, 2537,4207,2537, 2935,4208,2935, 35303,4209,2535, 2936,4210,2936, 35301,4211,2533, 2937,4212,2937, 
35298,4191,2530, 2938,4213,2938, 35695,4192,2927, 2939,4214,2939, 35708,4215,2940, 35696,4194,2928, 2929,4195,2929, 2941,4216,2941, 35698,4198,2930, 2931,4199,2931, 2942,4217,2942, 35700,4202,2932, 2933,4203,2933, 2943,4218,2943, 35702,4205,2934, 2935,4208,2935, 
2944,4219,2944, 35704,4210,2936, 2937,4212,2937, 2939,4214,2939, 35706,4213,2938, 
14, // chain 488
2942,4217,2942, 2943,4218,2943, 2945,4220,2945, 
35714,4221,2946, 35712,4219,2944, 2947,4222,2947, 35707,4214,2939, 2948,4223,2948, 35708,4215,2940, 2949,4224,2949, 35709,4216,2941, 2950,4225,2950, 35710,4217,2942, 2945,4220,2945, 2947,4222,2947, 35714,4221,2946, 
2, // chain 489
2948,4223,2948, 2949,4224,2949, 2950,4225,2950, 
2947,4222,2947, 
19, // chain 490
2900,4153,2900, 2901,4154,2901, 2951,4226,2951, 
35670,4155,2902, 2952,4227,2952, 35671,4156,2903, 2953,4228,2953, 35672,4157,2904, 2905,4158,2905, 2954,4229,2954, 35723,4230,2955, 35674,4159,2906, 2907,4160,2907, 2922,4175,2922, 2956,4231,2956, 35725,4232,2957, 35726,4233,2958, 35691,4176,2923, 2959,4234,2959, 
35693,4178,2925, 35692,4177,2924, 
12, // chain 491
2900,4153,2900, 2951,4226,2951, 2899,4152,2899, 
35728,4235,2960, 35729,4236,2961, 35730,4237,2962, 35731,4238,2963, 35732,4239,2964, 35720,4227,2952, 2953,4228,2953, 2954,4229,2954, 2963,4238,2963, 35724,4231,2956, 35723,4230,2955, 
9, // chain 492
2962,4237,2962, 2963,4238,2963, 2956,4231,2956, 
2957,4232,2957, 2958,4233,2958, 2961,4236,2961, 35728,4235,2960, 35727,4234,2959, 2899,4152,2899, 35694,4179,2926, 35693,4178,2925, 
126, // chain 493
2644,4240,2644, 2643,4241,2643, 2965,4242,2965, 
35414,4243,2646, 2966,4244,2966, 35495,4245,2727, 2967,4246,2967, 35736,4247,2968, 35494,4248,2726, 2724,4249,2724, 2969,4250,2969, 35490,4251,2722, 2970,4252,2970, 35488,4253,2720, 2971,4254,2971, 35486,4255,2718, 2972,4256,2972, 35484,4257,2716, 2973,4258,2973, 
35481,4259,2713, 2974,4260,2974, 35743,4261,2975, 35479,4262,2711, 2976,4263,2976, 35477,4264,2709, 2977,4265,2977, 35475,4266,2707, 2978,4267,2978, 35474,4268,2706, 2703,4269,2703, 2979,4270,2979, 35748,4271,2980, 35469,4272,2701, 2981,4273,2981, 35468,4274,2700, 
659,4275,659, 1759,4276,1759, 2982,4277,2982, 34524,4278,1756, 2983,4279,2983, 35752,4280,2984, 35753,4281,2985, 34522,4282,1754, 2986,4283,2986, 35755,4284,2987, 34520,4285,1752, 2988,4286,2988, 34519,4287,1751, 2989,4288,2989, 35758,4289,2990, 34516,4290,1748, 
2991,4291,2991, 33434,4292,666, 2688,4293,2688, 2992,4294,2992, 35454,4295,2686, 2993,4296,2993, 35452,4297,2684, 2994,4298,2994, 35450,4299,2682, 2995,4300,2995, 35449,4301,2681, 2679,4302,2679, 2996,4303,2996, 35445,4304,2677, 2997,4305,2997, 35442,4306,2674, 
2998,4307,2998, 35767,4308,2999, 35441,4309,2673, 2670,4310,2670, 3000,4311,3000, 35769,4312,3001, 35436,4313,2668, 3002,4314,3002, 35434,4315,2666, 3003,4316,3003, 35432,4317,2664, 3004,4318,3004, 35430,4319,2662, 3005,4320,3005, 35429,4321,2661, 2657,4322,2657, 
3006,4323,3006, 35775,4324,3007, 35776,4325,3008, 35423,4326,2655, 3009,4327,3009, 35422,4328,2654, 2652,4329,2652, 3010,4330,3010, 35412,4240,2644, 3011,4331,3011, 35733,4242,2965, 3012,4332,3012, 35781,4333,3013, 35734,4244,2966, 3014,4334,3014, 35783,4335,3015, 
35735,4246,2967, 2968,4247,2968, 3016,4336,3016, 35737,4250,2969, 3017,4337,3017, 35738,4252,2970, 3018,4338,3018, 35787,4339,3019, 35739,4254,2971, 3020,4340,3020, 35740,4256,2972, 3021,4341,3021, 35741,4258,2973, 2974,4260,2974, 3022,4342,3022, 35791,4343,3023, 
35743,4261,2975, 3024,4344,3024, 35744,4263,2976, 3025,4345,3025, 35745,4265,2977, 3026,4346,3026, 35746,4267,2978, 2979,4270,2979, 3027,4347,3027, 35796,4348,3028, 35748,4271,2980, 2982,4277,2982, 35749,4273,2981, 
32, // chain 494
3013,4333,3013, 3014,4334,3014, 3029,4349,3029, 
35798,4350,3030, 35783,4335,3015, 3031,4351,3031, 35784,4336,3016, 3032,4352,3032, 35785,4337,3017, 3033,4353,3033, 35786,4338,3018, 3034,4354,3034, 35803,4355,3035, 35787,4339,3019, 3020,4340,3020, 3036,4356,3036, 35805,4357,3037, 35789,4341,3021, 3022,4342,3022, 
3038,4358,3038, 35807,4359,3039, 35791,4343,3023, 3040,4360,3040, 35792,4344,3024, 3025,4345,3025, 3041,4361,3041, 35794,4346,3026, 3042,4362,3042, 35795,4347,3027, 3043,4363,3043, 35812,4364,3044, 35796,4348,3028, 2983,4279,2983, 35750,4277,2982, 
24, // chain 495
3032,4352,3032, 3033,4353,3033, 3045,4365,3045, 
35814,4366,3046, 35802,4354,3034, 3047,4367,3047, 35803,4355,3035, 3036,4356,3036, 3048,4368,3048, 35805,4357,3037, 3049,4369,3049, 35806,4358,3038, 3039,4359,3039, 3050,4370,3050, 35819,4371,3051, 35808,4360,3040, 3041,4361,3041, 3052,4372,3052, 35821,4373,3053, 
35810,4362,3042, 3043,4363,3043, 3054,4374,3054, 35812,4364,3044, 3055,4375,3055, 35752,4280,2984, 35751,4279,2983, 
28, // chain 496
3032,4352,3032, 3045,4365,3045, 3031,4351,3031, 
35824,4376,3056, 35825,4377,3057, 35814,4366,3046, 3058,4378,3058, 35815,4367,3047, 3059,4379,3059, 35816,4368,3048, 3060,4380,3060, 35817,4369,3049, 2593,4381,2593, 35818,4370,3050, 2594,4382,2594, 35819,4371,3051, 2597,4383,2597, 35366,4384,2598, 35368,4385,2600, 
35370,4386,2602, 35820,4372,3052, 2604,4387,2604, 35821,4373,3053, 2606,4388,2606, 35822,4374,3054, 2609,4389,2609, 35378,4390,2610, 35823,4375,3055, 2985,4281,2985, 35752,4280,2984, 
11, // chain 497
3031,4351,3031, 3056,4376,3056, 3030,4350,3030, 
35797,4349,3029, 35829,4391,3061, 35825,4377,3057, 3062,4392,3062, 35826,4378,3058, 2588,4393,2588, 35827,4379,3059, 3060,4380,3060, 2590,4394,2590, 35361,4381,2593, 
7, // chain 498
3029,4349,3029, 3061,4391,3061, 3063,4395,3063, 
35832,4396,3064, 35830,4392,3062, 3065,4397,3065, 35834,4398,3066, 35354,4399,2586, 35356,4393,2588, 
12, // chain 499
3029,4349,3029, 3063,4395,3063, 3013,4333,3013, 
35780,4332,3012, 35835,4400,3067, 35832,4396,3064, 3068,4401,3068, 35837,4402,3069, 35833,4397,3065, 3070,4403,3070, 35834,4398,3066, 3071,4404,3071, 35352,4405,2584, 35354,4399,2586, 
17, // chain 500
3010,4330,3010, 3011,4331,3011, 3072,4406,3072, 
35780,4332,3012, 3067,4400,3067, 3073,4407,3073, 35836,4401,3068, 3074,4408,3074, 35843,4409,3075, 35837,4402,3069, 3076,4410,3076, 35838,4403,3070, 3077,4411,3077, 35846,4412,3078, 35839,4404,3071, 3079,4413,3079, 35848,4414,3080, 35350,4415,2582, 35352,4405,2584, 
55, // chain 501
3080,4414,3080, 2582,4415,2582, 2580,4416,2580, 
3081,4417,3081, 35346,4418,2578, 3082,4419,3082, 35345,4420,2577, 3083,4421,3083, 35343,4422,2575, 3084,4423,3084, 35341,4424,2573, 3085,4425,3085, 35338,4426,2570, 2568,4427,2568, 2567,4428,2567, 3086,4429,3086, 35334,4430,2566, 3087,4431,3087, 35754,4283,2986, 
35753,4281,2985, 35378,4390,2610, 35333,4432,2565, 2608,4433,2608, 35337,4434,2569, 2607,4435,2607, 35339,4436,2571, 2605,4437,2605, 35371,4438,2603, 35340,4439,2572, 2601,4440,2601, 35342,4441,2574, 2599,4442,2599, 35344,4443,2576, 3088,4444,3088, 35857,4445,3089, 
35858,4446,3090, 35347,4447,2579, 3091,4448,3091, 35349,4449,2581, 3092,4450,3092, 35351,4451,2583, 3093,4452,3093, 35353,4453,2585, 2587,4454,2587, 3094,4455,3094, 35357,4456,2589, 3095,4457,3095, 35864,4458,3096, 35359,4459,2591, 2592,4460,2592, 3097,4461,3097, 
35866,4462,3098, 35363,4463,2595, 2596,4464,2596, 3099,4465,3099, 35856,4444,3088, 35367,4442,2599, 
56, // chain 502
3085,4425,3085, 3086,4429,3086, 3100,4466,3100, 
35869,4467,3101, 35855,4431,3087, 3102,4468,3102, 35754,4283,2986, 2987,4284,2987, 3103,4469,3103, 35756,4286,2988, 3104,4470,3104, 35873,4471,3105, 35757,4288,2989, 2990,4289,2990, 3106,4472,3106, 35875,4473,3107, 35876,4474,3108, 35759,4291,2991, 3109,4475,3109, 
35760,4294,2992, 3110,4476,3110, 35879,4477,3111, 35761,4296,2993, 3112,4478,3112, 35762,4298,2994, 3113,4479,3113, 35763,4300,2995, 2996,4303,2996, 3114,4480,3114, 35765,4305,2997, 3115,4481,3115, 35884,4482,3116, 35766,4307,2998, 3117,4483,3117, 35767,4308,2999, 
3000,4311,3000, 3118,4484,3118, 35887,4485,3119, 35769,4312,3001, 3120,4486,3120, 35770,4314,3002, 3121,4487,3121, 35771,4316,3003, 3122,4488,3122, 35772,4318,3004, 3123,4489,3123, 35773,4320,3005, 3124,4490,3124, 35774,4323,3006, 3125,4491,3125, 35775,4324,3007, 
3008,4325,3008, 3126,4492,3126, 35842,4408,3074, 35777,4327,3009, 3073,4407,3073, 35778,4330,3010, 3072,4406,3072, 
6, // chain 503
3085,4425,3085, 3100,4466,3100, 3084,4423,3084, 
35895,4493,3127, 35896,4494,3128, 35869,4467,3101, 3103,4469,3103, 35870,4468,3102, 
73, // chain 504
3084,4423,3084, 3127,4493,3127, 3083,4421,3083, 
35897,4495,3129, 35898,4496,3130, 35896,4494,3128, 3131,4497,3131, 35900,4498,3132, 35871,4469,3103, 3133,4499,3133, 35872,4470,3104, 3134,4500,3134, 35903,4501,3135, 35873,4471,3105, 3106,4472,3106, 3136,4502,3136, 35875,4473,3107, 3137,4503,3137, 35906,4504,3138, 
35876,4474,3108, 3109,4475,3109, 3139,4505,3139, 35878,4476,3110, 3140,4506,3140, 35909,4507,3141, 35910,4508,3142, 35879,4477,3111, 3143,4509,3143, 35880,4478,3112, 3144,4510,3144, 35881,4479,3113, 3114,4480,3114, 3145,4511,3145, 35883,4481,3115, 3146,4512,3146, 
35884,4482,3116, 3147,4513,3147, 35885,4483,3117, 3148,4514,3148, 35886,4484,3118, 3149,4515,3149, 35918,4516,3150, 35887,4485,3119, 3151,4517,3151, 35888,4486,3120, 3152,4518,3152, 35889,4487,3121, 3153,4519,3153, 35890,4488,3122, 3154,4520,3154, 35891,4489,3123, 
3155,4521,3155, 35892,4490,3124, 3125,4491,3125, 3156,4522,3156, 35894,4492,3126, 3157,4523,3157, 35842,4408,3074, 3075,4409,3075, 3158,4524,3158, 35844,4410,3076, 3077,4411,3077, 3159,4525,3159, 35846,4412,3078, 3160,4526,3160, 35847,4413,3079, 3161,4527,3161, 
35930,4528,3162, 35848,4414,3080, 3081,4417,3081, 3163,4529,3163, 35932,4530,3164, 35850,4419,3082, 3129,4495,3129, 35851,4421,3083, 
26, // chain 505
3161,4527,3161, 3162,4528,3162, 3165,4531,3165, 
35931,4529,3163, 3166,4532,3166, 35935,4533,3167, 35932,4530,3164, 3168,4534,3168, 35897,4495,3129, 3130,4496,3130, 3131,4497,3131, 3169,4535,3169, 35938,4536,3170, 35939,4537,3171, 35900,4498,3132, 3133,4499,3133, 3172,4538,3172, 35902,4500,3134, 3173,4539,3173, 
35903,4501,3135, 3136,4502,3136, 3174,4540,3174, 35943,4541,3175, 35905,4503,3137, 3176,4542,3176, 35908,4506,3140, 35907,4505,3139, 35906,4504,3138, 
7, // chain 506
3168,4534,3168, 3169,4535,3169, 3167,4533,3167, 
35945,4543,3177, 35938,4536,3170, 3178,4544,3178, 35947,4545,3179, 35940,4538,3172, 35939,4537,3171, 
70, // chain 507
3167,4533,3167, 3177,4543,3177, 3166,4532,3166, 
35948,4546,3180, 35949,4547,3181, 35950,4548,3182, 35951,4549,3183, 35952,4550,3184, 35946,4544,3178, 3185,4551,3185, 35954,4552,3186, 35947,4545,3179, 3187,4553,3187, 35956,4554,3188, 35957,4555,3189, 35958,4556,3190, 35940,4538,3172, 3173,4539,3173, 3174,4540,3174, 
3191,4557,3191, 35960,4558,3192, 35943,4541,3175, 3193,4559,3193, 35944,4542,3176, 3194,4560,3194, 35908,4506,3140, 3195,4561,3195, 35909,4507,3141, 3196,4562,3196, 35965,4563,3197, 35910,4508,3142, 3143,4509,3143, 3198,4564,3198, 35967,4565,3199, 35912,4510,3144, 
3200,4566,3200, 35969,4567,3201, 35913,4511,3145, 3202,4568,3202, 35971,4569,3203, 35914,4512,3146, 3147,4513,3147, 3204,4570,3204, 35916,4514,3148, 3149,4515,3149, 3205,4571,3205, 35974,4572,3206, 35918,4516,3150, 3207,4573,3207, 35919,4517,3151, 3208,4574,3208, 
35920,4518,3152, 3209,4575,3209, 35921,4519,3153, 3210,4576,3210, 35922,4520,3154, 3211,4577,3211, 35923,4521,3155, 3156,4522,3156, 3212,4578,3212, 35925,4523,3157, 3158,4524,3158, 3159,4525,3159, 3213,4579,3213, 35928,4526,3160, 3161,4527,3161, 3214,4580,3214, 
35933,4531,3165, 3215,4581,3215, 35984,4582,3216, 35948,4546,3180, 35934,4532,3166, 
33, // chain 508
3212,4578,3212, 3213,4579,3213, 3211,4577,3211, 
35978,4576,3210, 35982,4580,3214, 3209,4575,3209, 35983,4581,3215, 3208,4574,3208, 35984,4582,3216, 3207,4573,3207, 35985,4583,3217, 35948,4546,3180, 3181,4547,3181, 3218,4584,3218, 35950,4548,3182, 3183,4549,3183, 3205,4571,3205, 35972,4570,3204, 35987,4585,3219, 
35952,4550,3184, 3202,4568,3202, 35988,4586,3220, 35953,4551,3185, 3221,4587,3221, 35954,4552,3186, 3222,4588,3222, 35955,4553,3187, 3223,4589,3223, 35992,4590,3224, 35993,4591,3225, 35956,4554,3188, 3189,4555,3189, 3226,4592,3226, 35959,4557,3191, 35958,4556,3190, 
2, // chain 509
3217,4583,3217, 3218,4584,3218, 3206,4572,3206, 
35973,4571,3205, 
1, // chain 510
3217,4583,3217, 3206,4572,3206, 3207,4573,3207, 
2, // chain 511
3219,4585,3219, 3202,4568,3202, 3203,4569,3203, 
3204,4570,3204, 
6, // chain 512
3198,4564,3198, 3199,4565,3199, 3227,4593,3227, 
35996,4594,3228, 35968,4566,3200, 3220,4586,3220, 35969,4567,3201, 3202,4568,3202, 
28, // chain 513
3198,4564,3198, 3227,4593,3227, 3229,4595,3229, 
35998,4596,3230, 35996,4594,3228, 3231,4597,3231, 35988,4586,3220, 3221,4587,3221, 3222,4588,3222, 3230,4596,3230, 35991,4589,3223, 3232,4598,3232, 35992,4590,3224, 3225,4591,3225, 3226,4592,3226, 3233,4599,3233, 35959,4557,3191, 3192,4558,3192, 3234,4600,3234, 
35961,4559,3193, 3235,4601,3235, 35962,4560,3194, 3236,4602,3236, 35963,4561,3195, 3237,4603,3237, 35964,4562,3196, 3230,4596,3230, 35997,4595,3229, 35965,4563,3197, 3198,4564,3198, 
5, // chain 514
3230,4596,3230, 3232,4598,3232, 3237,4603,3237, 
36004,4602,3236, 36003,4601,3235, 36002,4600,3234, 36001,4599,3233, 
18, // chain 515
3089,4445,3089, 3090,4446,3090, 3238,4604,3238, 
36007,4605,3239, 35859,4448,3091, 3092,4450,3092, 3240,4606,3240, 35861,4452,3093, 3094,4455,3094, 3241,4607,3241, 35863,4457,3095, 3096,4458,3096, 3242,4608,3242, 35865,4461,3097, 3098,4462,3098, 3243,4609,3243, 35867,4465,3099, 3088,4444,3088, 3238,4604,3238, 
35857,4445,3089, 
16, // chain 516
3240,4606,3240, 3241,4607,3241, 3244,4610,3244, 
36013,4611,3245, 36010,4608,3242, 3246,4612,3246, 36011,4609,3243, 3247,4613,3247, 36006,4604,3238, 3248,4614,3248, 36007,4605,3239, 3249,4615,3249, 36008,4606,3240, 3244,4610,3244, 3248,4614,3248, 36013,4611,3245, 3247,4613,3247, 36014,4612,3246, 
6, // chain 517
3250,4616,3250, 2631,4617,2631, 3251,4618,3251, 
3252,4619,3252, 36021,4620,3253, 36022,4621,3254, 35410,4622,2642, 35399,4617,2631, 
11, // chain 518
2631,4617,2631, 3250,4616,3250, 2632,4623,2632, 
36023,4624,3255, 36024,4625,3256, 36020,4619,3252, 3257,4626,3257, 36021,4620,3253, 3258,4627,3258, 36022,4621,3254, 3259,4628,3259, 35409,4629,2641, 35410,4622,2642, 
17, // chain 519
2641,4629,2641, 2640,4630,2640, 3259,4628,3259, 
36028,4631,3260, 35407,4632,2639, 3261,4633,3261, 35406,4634,2638, 3262,4635,3262, 35405,4636,2637, 3263,4637,3263, 35404,4638,2636, 3264,4639,3264, 35403,4640,2635, 3265,4641,3265, 35402,4642,2634, 3266,4643,3266, 35401,4644,2633, 3255,4624,3255, 35400,4623,2632, 
26, // chain 520
3255,4624,3255, 3256,4625,3256, 3267,4645,3267, 
36025,4626,3257, 3268,4646,3268, 36037,4647,3269, 36038,4648,3270, 36039,4649,3271, 36040,4650,3272, 36041,4651,3273, 36042,4652,3274, 36026,4627,3258, 3259,4628,3259, 3260,4631,3260, 3273,4651,3273, 36029,4633,3261, 3272,4650,3272, 36030,4635,3262, 3271,4649,3271, 
36031,4637,3263, 3270,4648,3270, 36032,4639,3264, 3269,4647,3269, 36033,4641,3265, 3268,4646,3268, 36034,4643,3266, 3267,4645,3267, 36023,4624,3255, 
2, // chain 521
2400,3387,2400, 2399,3388,2399, 2403,3385,2403, 
2402,3386,2402, 

 0};


// mesh info for object stormtrooper (with tag [ | o Stormtrooper.001_Stormtrooper | usemtl Stormtrooper])
const tgx::Mesh3D<tgx::RGB565> stormtrooper = 
    {
    1, // version/id
    
    3275, // number of vertices
    4653, // number of texture coords
    3275, // number of normal vectors
    6518, // number of triangles
    23209, 

    stormtrooper_vert_array, // array of vertices
    stormtrooper_tex_array, // array of texture coords
    stormtrooper_norm_array, // array of normal vectors        
    stormtrooper_face, // array of face vertex indexes   
    
    &stormtrooper_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    nullptr, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.5670797688198611, 0.5670797688198611, 
    -1.0, 1.0, 
    -0.2133101767732101, 0.2133101767732101
    },
    
    "stormtrooper" // model name    
    };
    
                
/** end of stormtrooper.h */
    
    
    