// 3D model [bunny_fig_small]
//
// - vertices   : 1093
// - textures   : 1387
// - normals    : 1093
// - triangles  : 2104
//
// - memory size: 52kb
//
// - model bounding box: [-0.54,0.54]x[-1.0,1.0]x[-0.46,0.46]
//
// object [bunny_fig_small] (tagged [ | o Bunny | usemtl wire_115115115]) with 2104 triangles (276 chains)

#pragma once

#include <tgx.h>

#include "bunny_fig_texture.h" // texture for object [bunny_fig_small]


// vertex array: 12kb.
const tgx::fVec3 bunny_fig_small_vert_array[1093] PROGMEM = {
{0.03243791319323606,-0.0614663275712808,0.43487761060458596},
{0.05058153342923955,-0.04472309092049225,0.43595343938663644},
{0.02727809749234429,-0.054724684901498635,0.4491535776581205},
{-0.004485415669976899,-0.06810003371695277,0.45119141814934627},
{0.00023055409565586146,-0.05222856809613127,0.4573021619444595},
{0.027378676555672055,-0.03041072950294066,0.4497283945250953},
{0.06204228938381007,-0.02958879409131124,0.42853783704961423},
{0.05223942814183491,-0.05019651330611004,0.4207888048876736},
{-0.023796921020544592,-0.002685066695991574,0.3993286906445997},
{-0.057331712379487386,-0.01757426387859642,0.4108139308194899},
{-0.04552282522808536,-0.00278121502326818,0.4169131980597549},
{-4.867712313149996e-05,0.004785777570329706,0.4112434547730788},
{0.002517762373690808,-0.0021251950946574575,0.4367644266798275},
{-0.03966875248195743,-0.009422265080071043,0.4342145042082236},
{-0.06172807296476512,-0.02939403140017913,0.4285423355339231},
{-0.051483520182124674,-0.03475715962232019,0.4063282238320051},
{-0.040485268032973795,-0.025443115609041396,0.3989897461115074},
{-0.02224337217440311,-0.02112615598174556,0.39329752395293843},
{0.01286069917611071,-0.019960384612820604,0.3926628447254919},
{0.02691941111696876,-0.0026746334643114942,0.40060773710033876},
{0.036739846256981915,-0.00039075840055348063,0.41955384899802217},
{0.038943534482968854,-0.01330681467800149,0.4377136610676074},
{-0.003970677957898431,-0.02374123872757049,0.451998584440805},
{-0.030104188961489142,-0.038123475698076545,0.450165113343648},
{-0.050350267976878235,-0.04438588074279606,0.4358177531761873},
{-0.051961267345518675,-0.04950235110843459,0.420149369732539},
{-0.032117003246333924,-0.059676269557634665,0.4336836153115181},
{0.045441269875509574,-0.01377179806965145,0.40942311328825703},
{-0.012366733079832016,-0.005408709249897179,0.40498861043391454},
{0.015250044727399692,-0.03789512342079478,0.43924554402094795},
{0.07817108998654192,-0.06793123215815756,0.44010040508580206},
{0.06893373700093854,-0.10778398213310424,0.4523529484773416},
{-0.022688369830042403,-0.09054775496094733,0.4548465721468267},
{0.060453281099607306,-0.1335304608903128,0.45278825813213497},
{-0.05646422303940472,-0.13081928401581738,0.4538256330031355},
{0.034865116470907606,-0.1581501370764046,0.4471848403897118},
{0.09986492216890462,-0.15247570561029816,0.43805450255191425},
{0.08541003196687987,-0.18842850003352174,0.4214555019416921},
{-0.0005813410241878253,-0.17357714702764807,0.4328813268946112},
{0.058914853664576404,-0.19966992777873127,0.41076878338058276},
{0.0007312543687463781,-0.1829121252525451,0.41627299057448297},
{0.037954951907137824,-0.20126455916832015,0.3834867361648166},
{0.0003495064864620652,-0.18493518307394866,0.3940856394343421},
{0.030467536416991917,-0.18281577368049554,0.3499705755767314},
{0.0003476366345505427,-0.1689138718568263,0.3600164362692953},
{-1.3434479494760492e-05,-0.1401037084908457,0.33749729481207147},
{0.0276027471430695,-0.15232652394692237,0.3301788163772361},
{0.05355608843022895,-0.15414040224796297,0.32690832343711945},
{0.08532185083470457,-0.18488111996433287,0.3437518004099474},
{0.07330877043470369,-0.14964867921519762,0.32679316494874244},
{0.09059812579052051,-0.1385460947492444,0.3297333986823993},
{0.12898544030324335,-0.15709436177862254,0.35381671191256636},
{0.1029377934414158,-0.11793981179750809,0.3356356268900747},
{0.13639340063680105,-0.09932826789547185,0.36996272057274476},
{0.10512199726849862,-0.09774538405376189,0.339948480972956},
{0.10014521026051153,-0.07655513822026619,0.343040525002386},
{0.11467585656425604,-0.056024624919901254,0.3756911067512547},
{0.08756977867294602,-0.05405460043459678,0.34465427495028766},
{0.07853890882705054,-0.02131563430877995,0.3760101468462454},
{0.06753119902112979,-0.03395909869669151,0.3443778756086706},
{0.04251312243101992,-0.020767130865081817,0.34375593305366486},
{0.015200669797214272,-0.0002930654130021877,0.37440635589222043},
{0.014241286720436364,-0.012481058264639659,0.3430682340397706},
{0.11913935567287864,-0.06455539067737365,0.4073948117517103},
{0.13254971678789357,-0.1169141167261288,0.4206358022225656},
{0.14310549151659024,-0.11065058706033201,0.3960293233970667},
{0.14048242802601246,-0.15336070110016115,0.39452565081821733},
{0.11874321806066654,-0.16347145107391547,0.4212086137411135},
{0.10932795815043785,-0.10103996827430385,0.43717854467962364},
{0.09290286731763887,-0.037761876147621526,0.40768201016559896},
{0.09077986726652958,-0.19832630368378706,0.3686598809289142},
{0.09143171390246817,-0.20136100558793038,0.3893636942723834},
{0.12561625170136195,-0.18103724642030394,0.3860358998559346},
{-0.03561870744020581,-0.04382992499075505,0.4394695604097393},
{-0.08350852806937682,-0.10295789434946463,0.44811594534374083},
{-0.09888250468452103,-0.0747456500063222,0.43348545165785124},
{-0.09246781510622466,-0.03750767113521523,0.4075053362592631},
{-0.04950869912017778,-0.016397435994020524,0.41077904046679303},
{-0.03989562784722216,-0.005097555052098583,0.3754837022352426},
{-0.03184953312507701,-0.01619967882989972,0.34342262517561023},
{-0.13671218328841261,-0.09448264151432202,0.3982214537702962},
{-0.12669002093637957,-0.10251926503004581,0.4225008033588393},
{-0.11907420894830911,-0.06496506439146688,0.4076327842815804},
{-0.13621529046740283,-0.0997677237436342,0.3699503632905469},
{-0.099933496955312,-0.03777386758922798,0.3756414066294326},
{-0.1174739273540311,-0.1409133950174895,0.43202505666599766},
{-0.1433269470212419,-0.12597199102752898,0.4007688424570634},
{-0.1287253818413749,-0.15761656534869561,0.35441496967669284},
{-0.10264022954410464,-0.11793981179750809,0.3356356268900747},
{-0.10482443337118745,-0.09774538405376189,0.339948480972956},
{-0.09984764636320037,-0.07655513822026619,0.343040525002386},
{-0.08727221477563485,-0.05405460043459678,0.34465427495028766},
{-0.06723363512381862,-0.03395909869669151,0.3443778756086706},
{-0.13999550774853084,-0.15351431349958825,0.39395951927787504},
{-0.12416520596906593,-0.17875601353859497,0.37457598397975916},
{-0.1191483797407995,-0.18057753384310002,0.40419912643770606},
{-0.10241343547674911,-0.15949981786558398,0.4332157458440915},
{-0.06985110260831336,-0.18537102116515175,0.42831956571307284},
{-0.08687511513816391,-0.19652632732521905,0.40871676995385364},
{-0.101018187209465,-0.19760981166038558,0.3798975825199522},
{-0.05288903908527062,-0.16225747004483676,0.4449423595113865},
{-0.03769469020049637,-0.2010827228447503,0.3829758330041219},
{-0.03974029464205047,-0.19668098304781415,0.41238872551923483},
{-0.09030056189320936,-0.1385460947492444,0.3297333986823993},
{-0.08531882926241281,-0.1848122741848949,0.34373911793611267},
{-0.07301120653739253,-0.14964867921519762,0.32679316494874244},
{-0.05325852453291778,-0.15414040224796297,0.32690832343711945},
{-0.03550938885163941,-0.18385026247571962,0.3490509742768537},
{-0.031583146975942715,-0.15297242228583804,0.32949090056891733},
{-0.012700989433493964,-0.14692824792870537,0.33359362665582837},
{0.15291352872545091,-0.3145006771844842,-0.24058658284237977},
{0.2260780969937171,-0.32515120462634955,-0.16495744135751464},
{0.09014719338750987,-0.35463952805154536,-0.1780642631788924},
{0.05793082377166038,-0.3197336068050468,-0.25875940257743635},
{-0.06076056009706754,-0.35529585962214133,-0.18113248692092784},
{-0.08288215477831985,-0.3759965158968034,-0.10019566238799384},
{0.08997771434613797,-0.37533915455269096,-0.09702535557131049},
{0.23270276552181682,-0.34246652111450315,-0.08606325389244904},
{0.31811052792206496,-0.2865454290819639,-0.13731948544493722},
{0.26516351665271143,-0.27455761878207163,-0.23202209200224228},
{0.20340424561529208,-0.2698597242515835,-0.2814186745308121},
{0.0914609540504759,-0.2753891202476832,-0.3182140675842527},
{-0.07780507324968719,-0.27221808174981704,-0.3256039255833626},
{-0.060976406045984595,-0.32065070141939095,-0.2566317956448059},
{-0.15049156916292258,-0.31472629243215644,-0.24125433676921784},
{-0.1576693480162416,-0.3440173193813835,-0.17224205921316957},
{-0.23106684834400767,-0.34317946312920306,-0.08454508318645962},
{-0.17267173898775107,-0.36848586275427875,-0.009288773913170264},
{-0.059600750574816876,-0.38466735795182155,-0.008894695847991128},
{0.06297716114096519,-0.38418097966040116,-0.010202928253131778},
{0.17301094096422243,-0.3684988433204472,-0.008885753077979498},
{0.30540416605173826,-0.31639937630412,-0.0043958998971256324},
{0.3852339434054902,-0.2520136137142851,-0.009730058964289575},
{0.3793954121096704,-0.24419816116053084,-0.09827567676580007},
{0.36093265693111554,-0.22873936372679146,-0.17997873409291235},
{0.3103002242358931,-0.19960780262645353,-0.2796771513689565},
{0.22687798712230273,-0.23251707432238589,-0.3098037582289066},
{0.13428084736702356,-0.2198481365895927,-0.36023652325914207},
{0.0462706711451336,-0.21159477284795078,-0.38493167100427145},
{-0.09866554766417829,-0.2187891500243974,-0.37203359511440753},
{-0.22789314056478957,-0.23393218637881702,-0.30793658914838756},
{-0.20337378599864644,-0.27067225620504926,-0.28012737919008746},
{0.1501211623389712,-0.3301014072180294,0.2122498036519996},
{0.26654087937997223,-0.2882310192822922,0.20045727092999766},
{0.22261477896263754,-0.27406049561698576,0.2513298440993354},
{0.08057565179650221,-0.29235958455467626,0.2856028475730867},
{0.164258963595826,-0.24563404483276174,0.3035812704576026},
{0.18615524112173984,-0.18688985580406636,0.33205544311452506},
{0.3140991400361363,-0.21260149840718415,0.24031693122722605},
{0.36093265693111554,-0.2391671755464127,0.1526259305968421},
{0.28655971718950524,-0.30588442667549154,0.1428019725474304},
{0.1580678161685173,-0.3550510580678987,0.1492774187631997},
{0.06238019059373433,-0.3668607446487412,0.15750177270091},
{0.061273969943295765,-0.3368736991995786,0.22659481972974513},
{-0.059215574630694774,-0.33612200518149504,0.22806581054909744},
{-0.09161154487761115,-0.29521140681208174,0.27941972153948536},
{-0.04850259684491487,-0.23402828050748745,0.33694782934311446},
{0.06721684710556948,-0.23810892066240014,0.3316927053933412},
{0.043964832096241094,-0.164021566926146,0.37449734180226296},
{0.200275197487526,-0.11085930589254288,0.3519421311726589},
{0.3070023339003772,-0.13787947899313502,0.28235570068256094},
{0.3626358481287849,-0.15795057780862998,0.2252574826731121},
{0.40234310194557277,-0.1737752158337541,0.1577720746993373},
{0.42524335445145883,-0.18296458950328,0.07791313849548678},
{0.3793954121096704,-0.24971826209567902,0.07605684978514858},
{0.3218391887791107,-0.299543054261639,0.07372495475635854},
{0.23105963992939219,-0.34766942470726914,0.07289138019406242},
{0.08413060612089789,-0.38210906179557047,0.07967196456234976},
{-0.08990348935504147,-0.3659908434706857,0.15540976070285617},
{-0.08991988443339613,-0.3813232633045789,0.07706376503950345},
{-0.22053641146367725,-0.3365618675192034,0.1440007915164439},
{-0.15202444124082504,-0.32987335303308124,0.2114924729788784},
{-0.20153069464890117,-0.28729971108349023,0.24640683565828186},
{-0.22470088331262317,-0.2521784994237874,0.27005596385473274},
{-0.1339832834697124,-0.24130663842413425,0.3154602228570806},
{-0.18626932918764583,-0.18677588968502418,0.33197218050585614},
{-0.07362094085636725,-0.1705652491870344,0.3675694727218144},
{0.25344459918748696,-0.0417243633411683,0.3328633817361212},
{0.1730897592871886,-0.022802288525304117,0.36962762414068784},
{0.32492852287823426,-0.06236724390169463,0.284176760298914},
{0.3842122996799192,-0.0811009785612534,0.2263631071388832},
{0.4275901676465864,-0.09439993444136588,0.15830322103942193},
{0.45318409087718753,-0.10091197826592532,0.07762588588299202},
{0.4328067563874005,-0.18460407023944234,-0.011410229304004812},
{0.08686926168870171,-0.008527757734832017,0.39257534107589326},
{0.0001487819486555836,-0.0008599692834819653,0.4002349590873691},
{0.041741239432152515,-0.08324167445726448,0.3959757751742092},
{-0.08083477533241497,-0.09229706917243428,0.3882150632126473},
{-0.08657169779139055,-0.008527757734832017,0.39257534107589326},
{-0.08883042470190361,0.07640556361699616,0.3803955457634331},
{0.0001487819486555836,0.08476709422682424,0.38749556316660555},
{0.08912798859921478,0.07640556361699616,0.3803955457634331},
{0.176899921298204,0.05997390120320362,0.3590318101917118},
{0.25606793367109537,0.07597965742036644,0.3187694000523233},
{0.3307103488823895,0.05388631376256007,0.2715804351486849},
{0.390218860204397,0.0019055281440084092,0.2203064129037342},
{0.43400997899316224,-0.006674138305845728,0.15333455027270296},
{0.45970553815991066,-0.008707941000914899,0.07451758227172263},
{0.4618504344478969,-0.1012561258652061,-0.012620213185881333},
{0.17816883261459654,0.1741633456019106,0.3198083737822047},
{0.27501718908793443,0.1775525199398028,0.2619353595988089},
{0.37653433544026793,0.16183549324715185,0.16522357006326982},
{0.37948754974009324,0.08541205763978402,0.20854125047782843},
{0.4201934128748463,0.08326712070284328,0.14524811823794476},
{0.44397306486451227,0.08624122856533216,0.07056921381507293},
{0.4683596870442405,-0.006770367931031517,-0.013105304260406098},
{0.18470068602969678,-0.16267267201675556,-0.3812988603821684},
{0.07391985971883169,-0.1474360888681536,-0.41943900215163044},
{-0.041559931544992525,-0.14069227825412625,-0.42760414411214254},
{-0.18307060875169825,-0.16160040679305804,-0.38230227982642784},
{-0.30871040297259844,-0.19714710461019294,-0.28257269835185833},
{-0.2664932252555315,-0.2732568928838801,-0.23254090815943212},
{-0.2862376013236167,-0.29570647043013465,-0.16753255263131794},
{-0.3215416248817996,-0.2941001727905761,-0.0924127425475697},
{-0.30539880038973133,-0.3161972290529026,-0.0050997907446015955},
{0.20266688712853018,-0.0906013980313657,-0.40138022983352517},
{0.1730897592871886,-0.0004630186921778524,-0.42293077445092875},
{0.25344459918748696,-0.021374141704098428,-0.38280483640177837},
{0.32492852287823426,-0.04475678890385428,-0.32968883387850806},
{0.3307241424276498,0.07312927142602346,-0.3153854965288774},
{0.2563316776381808,0.09693492519698083,-0.3670013222833937},
{0.176899921298204,0.0817373650447934,-0.4115788763967726},
{0.08686926168870171,0.014131351622725372,-0.44849620276435653},
{0.08113233922972612,-0.06931687372250482,-0.44334871724635955},
{0.3070023339003772,-0.11988554175761403,-0.3264789214303944},
{0.3842122996799192,-0.06712861854961381,-0.26480632751383026},
{0.390218860204397,0.015942912933353835,-0.25875371172379263},
{0.37960812808908334,0.09884107662495971,-0.2459411612344036},
{0.3745354637468504,0.1748303271986112,-0.19837603090491238},
{0.27740981365489437,0.19157304896264146,-0.30578676078724343},
{0.17583356372257486,0.1601641166312814,-0.385516121673486},
{0.08912798859921478,0.09818928418762712,-0.4355468549930926},
{0.0001487819486555836,0.021498310710744917,-0.4573021619444595},
{0.0001487819486555836,-0.06300548668749438,-0.451856543443787},
{0.36595017419161013,0.8230405483077865,0.15201069511934506},
{0.5021532767474592,0.8521734508236265,0.18804630501273692},
{0.4563456310693291,0.959729392321434,0.22262356591165655},
{0.3293658440600956,0.9753256780692765,0.2077330137638986},
{0.4037646907354366,0.9940817425545615,0.22843296545668093},
{0.5125572682796857,0.7263062799003547,0.14814774366595793},
{0.29823957100936066,0.6548353638750789,0.09297674679262131},
{0.18827813277563687,0.8147545705549053,0.1280464426771965},
{0.26109618225560394,0.9190237866300602,0.1743133673436813},
{0.4498559035208444,0.9603211191535219,0.15909676993109026},
{0.4653563119344408,0.9208072324137581,0.13079391906814816},
{0.4027715148277359,0.9208080589425018,0.08489471839461125},
{0.41238084639686845,0.9950148122080626,0.1803990849324135},
{0.36048916328679637,0.9653964527771068,0.12663490772876998},
{0.32769089033622045,0.9132990588574639,0.07612058734595874},
{0.356492124481841,0.8167962455975152,0.00715436505547037},
{0.4145770552152093,0.7972619704260969,0.018304088759106104},
{0.4532559853282205,0.8774463150611587,0.08362632196497695},
{0.491354814210159,0.8524238348343004,0.11690217948312848},
{0.5105226255062216,0.853459854740148,0.15529422282423622},
{0.4763065847675142,0.9443014067952803,0.19335881173675148},
{0.4457819297944858,0.9803515961137214,0.20679734257730303},
{0.4150689211155005,1.0,0.21129987823199156},
{0.3786447478651033,0.9994878773706671,0.2031904253392792},
{0.340688678111714,0.9772478451853671,0.15129684527799248},
{0.27867678737111773,0.9133011184044971,0.10450561684544708},
{0.2596026312664496,0.8349827098316652,0.036307768194079125},
{0.2546431607131214,0.7071600802984869,-0.031822779338125544},
{0.3380635279748002,0.6855410286429335,-0.04892926859685608},
{0.4137426134752151,0.6602595874759811,-0.023336713881059755},
{0.477732902385763,0.7679061896921949,0.0527892933255121},
{0.5200502391269601,0.7361299534070841,0.11230751974766863},
{0.3325488333506136,0.9853039124510404,0.18552845456631115},
{0.25915546566656505,0.9252577509562124,0.14121421083116867},
{0.19216495871502473,0.8284491627101235,0.09177571923040796},
{0.1890119548033487,0.7075131029195217,0.007452186396160692},
{0.16524315608456042,0.536349826312437,-0.03758143543815969},
{0.22307428829506845,0.5275154399634182,-0.07217701546595165},
{0.2907955821523773,0.5135593124343147,-0.08414345796537674},
{0.3523377200239839,0.490564334314563,-0.06356992452139515},
{0.40272520211879687,0.471638018457769,-0.019943840488299093},
{0.4680277476809906,0.6301337529461685,0.02632143112069871},
{0.4952977763558472,0.6104746041862245,0.0709810825727146},
{0.48746473635440324,0.6012633071805187,0.11045402226554617},
{-0.23235910570999116,-0.34723028050109206,0.07191473486123177},
{-0.30839167451959304,-0.2885678636193969,0.1456614232586489},
{-0.264307910357023,-0.28944350984970224,0.20043842336471557},
{-0.31431153082391255,-0.2148577321818152,0.23864256013836685},
{-0.3215416248817996,-0.299543054261639,0.07372495475635854},
{-0.37909784821235926,-0.24971826209567902,0.07605684978514858},
{-0.36063509303380437,-0.2391671755464127,0.1526259305968421},
{-0.4020455380482616,-0.1737752158337541,0.1577720746993373},
{-0.36233828423147374,-0.15795057780862998,0.2252574826731121},
{-0.306704770003066,-0.13787947899313502,0.28235570068256094},
{-0.20157336250157784,-0.11226066505266832,0.35091803496016044},
{-0.17279219538987742,-0.022802288525304117,0.36962762414068784},
{-0.2585583189738643,-0.005918663934984663,0.3313629339743366},
{-0.32463095898092315,-0.06236724390169463,0.284176760298914},
{-0.3302188217233867,0.01752827636129419,0.27705506345328906},
{-0.29181283579085165,0.1075799243810208,0.2845469232291377},
{-0.17660235740089283,0.05997390120320362,0.3590318101917118},
{-0.36233828423147374,-0.14341994505453695,-0.26203814725533653},
{-0.306704770003066,-0.11988554175761403,-0.3264789214303944},
{-0.4020455380482616,-0.163489648255924,-0.1870380889918349},
{-0.36063509303380437,-0.22873936372679146,-0.17997873409291235},
{-0.37909784821235926,-0.24419816116053084,-0.09827567676580007},
{-0.3849363795081791,-0.2520136137142851,-0.009730058964289575},
{-0.08083477533241497,-0.06931687372250482,-0.44334871724635955},
{-0.20027717573664985,-0.08901251169402667,-0.4028000436190382},
{-0.2531470352901758,-0.021374141704098428,-0.38280483640177837},
{-0.17279219538987742,-0.0004630186921778524,-0.42293077445092875},
{-0.32463095898092315,-0.04475678890385428,-0.32968883387850806},
{-0.38391473578260804,-0.06712861854961381,-0.26480632751383026},
{-0.42729260374927525,-0.08459817072116498,-0.18940929155972153},
{-0.45288652697987647,-0.09562349507407836,-0.10459660275548965},
{-0.42494579055414766,-0.17746479949577948,-0.10280262889255067},
{-0.43250919249008934,-0.18460407023944234,-0.011410229304004812},
{-0.25839489662672754,0.09383190594980922,-0.3663308719759007},
{-0.3302188217233867,0.03511981604559499,-0.3220956091595427},
{-0.3235659563704472,0.11299237333474102,-0.3048712921310832},
{-0.2785537700848517,0.19099600995281535,-0.30449014043346634},
{-0.3735342935447455,0.17728498207028823,-0.19787594036614084},
{-0.37931056419177217,0.09884107662495971,-0.2459411612344036},
{-0.38992129630708583,0.015942912933353835,-0.25875371172379263},
{-0.17840898663836344,0.11671988247140667,-0.4032249471414544},
{-0.17177461655976622,0.2297618746300606,-0.34781017848739165},
{-0.18322071179137828,0.2894545799150048,-0.2893784173237389},
{-0.3088705598537158,0.25376238593971095,-0.20971910813592076},
{-0.3508173271751432,0.26477871332400654,-0.08651201835121444},
{-0.4202756999086049,0.16822782590041918,-0.052054319577419975},
{-0.4201315858149023,0.09258116471612209,-0.17603173415106743},
{-0.43371241509585096,0.003084320728056412,-0.18512489174505908},
{-0.5019448289082792,0.8518306581894987,0.1879445877786804},
{-0.5122768040426089,0.7266640584490776,0.1482146247459237},
{-0.36762470787628776,0.8226859674768257,0.15219461808925086},
{-0.4713607858125825,0.9354631994445292,0.2152826086049284},
{-0.3743784639345402,0.99070362473232,0.22163979346211968},
{-0.3213908037105883,0.971905190486692,0.20462824661167925},
{-0.24424995470351493,0.8988277058288271,0.1645762219116401},
{-0.18798849542447235,0.81476946162194,0.12805001978520114},
{-0.32329508528665557,0.6505071173880564,0.09495740775437884},
{-0.4871381220042059,0.6012635239749432,0.110885402521395},
{-0.4141209739446163,0.44218794569885006,0.06715635468630143},
{-0.12708464098762,0.523549131768139,0.048197804208510914},
{-0.21059710523076708,0.3765976597367065,0.036121216591775925},
{-0.2819548816657443,0.3337714116335899,0.038834154920970566},
{-0.31381438055952365,0.3013538432421302,0.0384575965552233},
{-0.4682356806334126,0.9397084272166104,0.15728943611173993},
{-0.4183700227184297,0.9936521102037602,0.18159439454168003},
{-0.44781222312980795,0.9400028475947659,0.13125555569586972},
{-0.4529600202897901,0.8774357734322659,0.08362693169929593},
{-0.392907978246197,0.923627931121593,0.08438434367032634},
{-0.36569844876543434,0.9841159196536013,0.15463912427192977},
{-0.37834718396779216,0.9994878773706671,0.2031904253392792},
{-0.4147713572181893,1.0,0.21129987823199156},
{-0.4454843658971747,0.9803515961137214,0.20679734257730303},
{-0.47600902087020297,0.9443014067952803,0.19335881173675148},
{-0.5100720182948479,0.8535247846702927,0.15570685036236373},
{-0.4910572503128479,0.8524238348343004,0.11690217948312848},
{-0.44784810260706664,0.7901042450570466,0.03275624193152125},
{-0.35526032566099675,0.81676791327616,0.0071560181129573675},
{-0.3274820495571459,0.9133633519539871,0.0761518734913479},
{-0.33544927175771877,0.9581562235798733,0.12368254705699128},
{-0.33225126945330247,0.9853039124510404,0.18552845456631115},
{-0.42063885766898623,0.9890630600240349,0.22925013139097086},
{-0.5197441524988349,0.7389727922455235,0.10829499369101123},
{-0.46773018378367953,0.6301337529461685,0.02632143112069871},
{-0.4305892204175471,0.6502617060994949,-0.010614918957637238},
{-0.3861802375188875,0.6688329397882212,-0.034952803040801964},
{-0.33776596407748904,0.6855410286429335,-0.04892926859685608},
{-0.2537600079758669,0.7071880874282052,-0.03163742010515722},
{-0.25922792920296234,0.8349531444920206,0.03632314704856882},
{-0.27837922347380656,0.9133011184044971,0.10450561684544708},
{-0.2587280012600092,0.9252691326635001,0.14078528306224725},
{-0.19186739481771356,0.8284491627101235,0.09177571923040796},
{-0.14599494115630235,0.6938830206552513,0.08838128762772103},
{-0.1492605155729126,0.7058586769177188,0.047481921919428446},
{-0.12989806353258168,0.5359677396888644,0.008082245192434582},
{-0.12990972978255141,0.4142539976485392,-0.008640829576873114},
{-0.12768077145645584,0.40766100820572326,0.0323575705344725},
{-0.4950002124585359,0.6104746041862245,0.0709810825727146},
{-0.42554876359700755,0.45683637912336905,0.030272523057306506},
{-0.4024276382214857,0.471638018457769,-0.019943840488299093},
{-0.3696455977534461,0.48634350946489224,-0.05086279032093109},
{-0.30069654287144976,0.509327322671781,-0.08351633944348547},
{-0.22394654711249068,0.5268539459755882,-0.0727476861395574},
{-0.16494559218724925,0.536349826312437,-0.03758143543815969},
{-0.18871439090603753,0.7075131029195217,0.007452186396160692},
{0.3142384440035447,0.3015078756807548,0.038359700322899024},
{0.4159945249110072,0.445320855477303,0.06806241988429788},
{0.284546509964766,0.3322600564023215,0.03895270082223078},
{0.1959325477209242,0.3831926138789948,0.035630461762910466},
{0.12721524607874438,0.5176407926676223,0.04712789662418019},
{0.24798849325652808,0.35624681481566595,-0.07722692994326111},
{0.20284957708014653,0.3807837568294986,-0.08817995335559559},
{0.20007017771018365,0.3834048420709526,-0.07259910066084903},
{0.15632657754934387,0.40112766432895436,-0.04657748267961594},
{0.11215499809518996,0.41822909956766313,-0.016563175331569462},
{0.13119973790638045,0.41109596681614463,-0.010174026846412377},
{0.12844872505637872,0.4064213234876869,0.03219855182408389},
{0.09843603011686464,0.4106902225009958,0.06332344281036248},
{0.0001487819486555836,0.4217847991228932,0.06755303428457486},
{0.0028926541322995387,0.43248521638170206,-0.016850956380474003},
{-0.09243728774132134,0.4081812877252787,0.07565587494733926},
{-0.19890847123671843,0.3767670981291237,0.06433859625284928},
{-0.09405300238869518,0.3828201475080105,0.14893294597228204},
{-0.1963292950674553,0.3507575799867095,0.1401588420229326},
{-0.26678948838629557,0.30401628202006237,0.14330711710622365},
{-0.34014047276034964,0.24736478247199736,0.11672755157417411},
{-0.3528686495696441,0.2573907658257626,0.06420879059116531},
{-0.36054109910112153,0.26143833128128374,-0.0007020887438221112},
{-0.31808348281760557,0.3039337917415308,-0.0013006039513277074},
{0.3101359618103613,0.230097946637028,0.18611186191235768},
{0.1930412282293006,0.26649908547981943,0.24945236373399995},
{0.3540182155553359,0.24780495645169107,0.0873048491113515},
{0.4131299524315093,0.16357995668338998,0.06584037188048404},
{0.1925447418978368,0.3539257324087991,0.13851460535908228},
{0.2807517945564979,0.2910049039440813,0.14647788461105912},
{0.18320892359454474,0.3201221024137945,0.19821435646282332},
{0.09142194460371304,0.3469582034983141,0.20982437537867887},
{0.08607525210888128,0.3858565973172016,0.1457291037680551},
{0.19449442835619038,0.3784100475760785,0.06813612998863616},
{0.36165803752592246,0.26058196620510965,-0.0018467904046137393},
{0.41991292153846643,0.16957161259118167,-0.010602697171954677},
{0.4517437493696024,0.09058931174219856,-0.011956293810427048},
{0.4056566692279121,0.18484815366215387,-0.08821922024573756},
{0.44391340574881355,0.09157438495828253,-0.09757654184601211},
{0.45970553815991066,-0.0033382005488257855,-0.10258178312221801},
{0.45318409087718753,-0.09562349507407836,-0.10459660275548965},
{0.42524335445145883,-0.17746479949577948,-0.10280262889255067},
{0.3393792126882839,0.27920344200171937,-0.0771747502352084},
{0.2817970688743421,0.3353034300834459,-0.06261275003781708},
{0.3072194128675837,0.31463843649161805,-0.03446851139571763},
{0.31846180263805207,0.30401659366204764,-0.0011034700711774115},
{0.34465760138973894,0.2409863924101573,-0.16538991913513765},
{0.42042914971221346,0.09258116471612209,-0.17603173415106743},
{0.43400997899316224,0.003084320728056412,-0.18512489174505908},
{0.4275901676465864,-0.08459817072116498,-0.18940929155972153},
{0.40234310194557277,-0.163489648255924,-0.1870380889918349},
{0.1068260827431692,0.3506437629138341,-0.2550623530574165},
{0.18051854543515217,0.2927029598238198,-0.2879812585555887},
{0.08754403433503376,0.30968312568131046,-0.3120431633363339},
{0.0010638170159667293,0.2941032756607773,-0.3418825853320469},
{0.08826894069203704,0.24847254778271063,-0.364974877049107},
{0.1720721804570774,0.2297618746300606,-0.34781017848739165},
{0.28474703125779943,0.26160901624164207,-0.22921954982746146},
{0.2710191611584171,0.31819879712697535,-0.15669806157059213},
{0.19230452012581226,0.3506653610583775,-0.19300676469062703},
{0.10912049943581958,0.3926489969816254,-0.16816347860528993},
{0.0001487819486555836,0.4027624433360347,-0.1826629471608575},
{0.0001487819486555836,0.36644669439720295,-0.2535953729349179},
{-0.1067932790368084,0.3510260392325283,-0.25466205570218386},
{-0.08724647043772259,0.30968312568131046,-0.3120431633363339},
{-0.08967487963438055,0.21376904478046013,-0.3895887946332974},
{0.0001487819486555836,0.18586237217868481,-0.4136804273495055},
{0.08898978215358051,0.17776640118924752,-0.4066847422631354},
{-0.2367052241873854,0.3636143023400953,-0.07885777955139706},
{-0.28151827124440376,0.3356363043726515,-0.06280476214968798},
{-0.20080189954190797,0.3829813070633413,-0.07302412613012901},
{-0.15689812895029928,0.4010086848388451,-0.0471302542635469},
{-0.10772199925216763,0.41233998742267153,-0.09737512627597747},
{-0.37558146974587736,0.16200265529811167,0.1660200863286238},
{-0.4198958489775351,0.08326712070284328,0.14524811823794476},
{-0.3791899858427821,0.08541205763978402,0.20854125047782843},
{-0.38992129630708583,0.0019055281440084092,0.2203064129037342},
{-0.43371241509585096,-0.006674138305845728,0.15333455027270296},
{-0.45940797426259944,-0.008707941000914899,0.07451758227172263},
{-0.4436755009672012,0.08624122856533216,0.07056921381507293},
{-0.4128323885341982,0.16357995668338998,0.06584037188048404},
{-0.305373028952516,0.23395313414008695,0.18746379194369153},
{-0.27539843563311206,0.17895677872535606,0.2604697479911151},
{-0.17729055775189387,0.17592631786214258,0.31933036917543156},
{-0.08850658803027037,0.1579229365195032,0.3531011277158176},
{-0.09038906821702142,0.26771706365610043,0.29006046613294406},
{0.0001487819486555836,0.16632778536528156,0.3589979496125314},
{0.08880415192758154,0.1579229365195032,0.3531011277158176},
{-0.006625461182714411,-0.0722217293160097,0.44003187094834934},
{-0.1820338165157136,0.32381736337981215,0.19444577833236198},
{-0.09112438070640189,0.3469582034983141,0.20982437537867887},
{0.0001487819486555836,0.3552953582850346,0.21373481836068836},
{0.001250829306422046,0.27995869957815606,0.2914157429282065},
{-0.18879899493020819,0.26911945258974224,0.24914722558148192},
{-0.1920069562285011,0.3506653610583775,-0.19300676469062703},
{-0.10882293553850843,0.3926489969816254,-0.16816347860528993},
{-0.2693819025651062,0.31917487337444156,-0.15837739183191235},
{-0.08883042470190361,0.09818928418762712,-0.4355468549930926},
{0.0001487819486555836,0.1060915222594489,-0.44371864983250725},
{0.12822877356304724,0.004666892927781132,0.39979578778188896},
{0.09186480141441015,0.022087043069843756,0.39979077441082184},
{0.1068158256569589,-0.004636704304165892,0.39533299325514604},
{0.13363299787828714,-0.013721976000965499,0.38872026197004667},
{0.12712142829153145,-0.021852674747281222,0.3602537855151948},
{0.10287682000951832,-0.01562635242459364,0.36673885198355244},
{0.07877632582120778,0.008807097350831886,0.3700238159515061},
{0.0847157342726891,0.049662900929446564,0.39618845050466756},
{0.10974284848037133,0.07761981563910543,0.39610476785680115},
{0.1318549990545053,0.03595229308611686,0.4018577466528431},
{0.16397465125771385,0.01700633023460044,0.3877057860101365},
{0.16061489321329928,-0.00441610242756094,0.38040232058919954},
{0.1616634194475113,-0.0010210339912520446,0.348716595976328},
{0.18006060786229908,0.03508228351084924,0.36912279122387986},
{0.17093867080845185,0.052507487672933534,0.3357627497207552},
{0.17348549040985473,0.0747117487781873,0.36893278446043576},
{0.15742924819108084,0.09899953979963533,0.3647622288179517},
{0.15585460253750283,0.08773036236808672,0.3357928163975064},
{0.12370244472026715,0.10684844644302416,0.3400689644743854},
{0.12073943402238367,0.10954458320431817,0.37298876424955874},
{0.08868694744182305,0.09565968619332248,0.3530859792054039},
{0.09026916735060789,0.08571246696391711,0.3857357479751807},
{0.07003129942404765,0.050905173630925726,0.3642221126085523},
{0.14416042673597726,0.08996048596421419,0.38442515793067333},
{0.16620015442266856,0.04228270383187942,0.38704473916080717},
{-0.12416977220163247,-0.013404819307538021,0.39166240620456966},
{-0.1083519632008808,0.018121547853656602,0.4030203880522641},
{-0.14636729913007446,0.011399755423370087,0.3966747068492241},
{-0.15203807219026702,-0.00881566073060035,0.3834130531597814},
{-0.16989843696097792,0.009753296616668286,0.3801210569226822},
{-0.16385643054809046,0.07324567648234144,0.38137601209799604},
{-0.1253967473465311,0.043591139481793,0.40233180831102017},
{-0.08442621886838839,0.04981228583759542,0.39620414100114254},
{-0.09195226441505423,0.011793725091337005,0.3964677765710157},
{-0.10257925611220717,-0.01562635242459364,0.36673885198355244},
{-0.12670885495201012,-0.021964418723472146,0.3603187831935975},
{-0.1611812415480661,-0.0009680006551526558,0.34875259740045056},
{-0.1765020357809442,0.023523333231620685,0.37139563687129},
{-0.17877294382818523,0.059491547158288596,0.3663258315055305},
{-0.15707510094896882,0.09906953729945366,0.36467906105684356},
{-0.12592152535039536,0.0904635032277167,0.3893869319247621},
{-0.08995197000822573,0.07760367800412982,0.39122795017782286},
{-0.06956020513955628,0.050782982873403035,0.3642900099123831},
{-0.07841274802162894,0.008889790874136338,0.3700391406073897},
{-0.10331450085332995,0.10170736991020225,0.37913489973447556},
{-0.12967716356364292,0.10928510737746545,0.3700402516788153},
{-0.12356594553072604,0.10668749013246626,0.3400388842479827},
{-0.08833983246885654,0.09572564589698404,0.3531100162872231},
{-0.15555703864019166,0.08773036236808672,0.3357928163975064},
{-0.1707651539709232,0.05160842764477963,0.335866458753587},
{0.17967623134761743,-0.44426310193039703,-0.08671455854232632},
{0.19175399778403573,-0.4769585872244454,-0.0819716520694464},
{0.16440283379580098,-0.45350596962417433,-0.11572154414647196},
{0.2035723561418592,-0.5076147415655993,-0.06800216458393167},
{0.19388770205985595,-0.5942177864758109,-0.12655821670109452},
{0.21073258819644322,-0.5277271939175722,-0.04967555630397809},
{0.2266835225235044,-0.6168770990781411,-0.051924283571659964},
{0.2146641550851923,-0.5349155685983898,-0.028696224346241517},
{0.23220997824522144,-0.6309762025302185,0.0036682429608611736},
{0.21560217036150303,-0.5313465361860515,-0.0024805753550591406},
{0.15383178860982688,-0.4061158330442288,0.06636344262825516},
{0.18299569272837352,-0.4173429523574198,0.025305491798423015},
{0.16447108339057154,-0.38175552428777737,0.006676604342424835},
{0.10013630813945451,-0.3386398691775724,0.019379917541156647},
{0.10284650943903952,-0.335218392470426,-0.020021195448899687},
{0.07789532747854694,-0.31363470540537325,0.009265197519503224},
{0.07933972033194042,-0.31096812043407224,-0.020831288465089515},
{0.21178691368151129,-0.5114675578796398,0.01693602109279673},
{0.2045125258127636,-0.4808367820358069,0.02996711391175783},
{0.21479950255435318,-0.605025909914654,0.07923443276470503},
{0.18069246876222683,-0.4708437649842208,0.08788556007674304},
{0.19626494777232617,-0.44747984340288327,0.03187535198607268},
{0.08285848353709206,-0.6091041653308967,0.20974749465588188},
{0.04898863639504689,-0.6856046849058344,0.22421224900422254},
{0.09599785162145155,-0.6868687725462812,0.20771504692596615},
{0.15389071604434287,-0.6755978743089879,0.17234601213972897},
{0.12849785609283654,-0.745196513035117,0.17207920595139717},
{0.06928116361589035,-0.7427931571441432,0.20808065717327492},
{2.7078978588227213e-05,-0.6877272242687915,0.23231460187953176},
{4.569619979425568e-05,-0.6011416719587087,0.22471044259177947},
{0.07917656897783432,-0.5080303635767155,0.17996026591787315},
{0.1364285077839225,-0.5905377959670708,0.1802824766313225},
{0.16976510838989542,-0.5936809357324309,0.15366092072917287},
{0.198955231084158,-0.6786563694012229,0.11797249355700519},
{0.17254435871369145,-0.7347819256753918,0.13576240013974566},
{0.14738077241577113,-0.795357214612226,0.11778825894511408},
{0.07779302760947451,-0.7788678171332524,0.18648697046539095},
{0.01705428922620052,-0.7817225796650406,0.20344934563041892},
{-0.012842176802465447,-0.7447010022785635,0.22167334239931483},
{-0.049512682717728414,-0.6847299058532271,0.22408573590786107},
{-0.07785267317552182,-0.5855513074085862,0.2063340122431399},
{-0.07617397974782365,-0.4870813963880639,0.17062420372085352},
{0.0011714283484400032,-0.49618971604212064,0.1858584969783464},
{0.0700340093543542,-0.41175942550344663,0.12415288256099684},
{0.13087088786368006,-0.4303898847190226,0.11172229674831667},
{0.1438936747462516,-0.4837726527816702,0.13805913382280816},
{0.19732923225127078,-0.606707272623704,0.12082189042678637},
{0.22111611975485532,-0.6717846907256807,0.07258385730287464},
{0.20630854567308407,-0.7524360647497738,0.06357031746128958},
{0.17317647705699832,-0.779295579632142,0.09955061767712468},
{0.225881450901022,-0.6147598169799787,0.04657657485296323},
{0.22254820952465706,-0.7235376796026634,0.003194533593623938},
{0.1248247081581205,-0.6689856308113438,-0.196762159010147},
{0.1648904722048139,-0.616100568548798,-0.1661376160060191},
{0.14843207632854735,-0.7118695733306869,-0.17338876622238805},
{0.08513519083518911,-0.6729816533924342,-0.2163103361240376},
{0.06589704329801985,-0.7277013655718204,-0.2140312034383162},
{0.11569773063390308,-0.7686502959054198,-0.16712791938759478},
{0.16075360099604027,-0.7547848561940254,-0.13491220015501887},
{0.19922354128380995,-0.7140489941307786,-0.10593034915446652},
{0.19567888469457917,-0.6613332483137864,-0.128771430332109},
{0.15106248373025588,-0.5335705488893376,-0.16211578133875867},
{0.11866240793892507,-0.5829924015180161,-0.19495203396258093},
{0.06672689170614446,-0.595037553943195,-0.21793974946911107},
{0.011412471771333461,-0.6798740901341246,-0.23423538693116597},
{0.0001487819486555836,-0.7311970401707601,-0.22407332442705705},
{0.06112745756127191,-0.7678864478499114,-0.19633674060097256},
{0.0866917612536224,-0.8049402598573849,-0.1521100276147318},
{0.13885381411037942,-0.8025085580954044,-0.10702685470475608},
{0.17266530290327298,-0.7794770094661658,-0.08826190164806579},
{0.20387991968200156,-0.7647448391951744,-0.047566837585584346},
{0.22123606127022344,-0.6746192778263366,-0.07327963190908249},
{0.149023776061332,-0.37256697714699505,-0.05532482606718817},
{0.16393245764284078,-0.4091046829275853,-0.07871355706048223},
{0.103870835995614,-0.383816832775458,-0.10821277440551039},
{0.08995692918068669,-0.3399860270573533,-0.060735283222133146},
{0.05435180526614251,-0.3134055130496964,-0.05615201874361236},
{0.042571480780171575,-0.3776273248559847,-0.12451215157138831},
{0.11725614380494483,-0.43928953973947477,-0.1429732536924562},
{0.0775120755849425,-0.4885121582920154,-0.1829892092201151},
{6.112925289008278e-05,-0.4905903225462027,-0.19517462763796134},
{-0.011164784141314428,-0.6053526055627605,-0.2300612135317226},
{-0.04165556498551083,-0.6730129395378235,-0.22837650405874388},
{-0.06629383129350558,-0.7271342720062193,-0.2139957304506034},
{-0.016008608418810424,-0.7750102990901299,-0.20289680439056404},
{0.018362928120887155,-0.8142910234263177,-0.16825229657108723},
{0.0652858591663311,-0.8402959075879077,-0.10040619687351005},
{0.09907932692268603,-0.8223787291283199,-0.11136290579106146},
{0.029806177925677326,-0.3240121125212925,0.05465543263251463},
{0.0003019201102789706,-0.3242995548289087,0.05997047314136584},
{-0.008641798376957718,-0.4211448490810002,0.14076106983495817},
{-0.029376708170694623,-0.32397779125396,0.05478386977939378},
{-0.10300367184716819,-0.4292589088552337,0.1257043989594084},
{-0.11558338512461806,-0.3833501421277147,0.07565292112330513},
{-0.05810211846633773,-0.3207847752213077,0.03521267180754898},
{-0.09993925555721343,-0.3392149976865324,0.02092620377407657},
{-0.07759776358123578,-0.31363470540537325,0.009265197519503224},
{-0.10358871870105019,-0.33558123858882216,-0.01990988506155797},
{-0.07904215643462925,-0.31096812043407224,-0.020831288465089515},
{0.05862861727594661,-0.3205407053482479,0.035398396881108685},
{-8.799821187960377e-05,-0.37825330520714723,-0.1299832298672909},
{0.003027866104945069,-0.33861024963932174,-0.09276107698917421},
{0.03333742035989065,-0.31269160900973775,-0.06925301421483103},
{-0.003323126561495734,-0.31269434603934737,-0.07569911188538035},
{-0.05291002749549489,-0.33674711835495946,-0.08117281881368033},
{-0.06611871559709603,-0.3720360882502895,-0.11426094590984529},
{-0.0645686219120954,-0.4350607612443544,-0.15800777088774987},
{0.2669924215173019,-0.49452485680863745,-0.08847740885569452},
{0.33113147205202803,-0.5576489164966951,-0.079877539875405},
{0.4358260252384481,-0.6175173878613224,-0.07337476401249408},
{0.2755286071353874,-0.47396685126531246,-0.08456422884407543},
{0.23412837855818588,-0.42543995312037347,-0.0711617536262526},
{0.23538188392078566,-0.41166907642702616,-0.0516395918433049},
{0.3385041490929944,-0.47419500029782125,-0.031479133075951383},
{0.22393769919003972,-0.39957587693751195,-0.026748434839102497},
{0.22397300958193414,-0.40431767233896626,-0.0050303894294507386},
{0.34078478579003596,-0.49711358548223117,0.028416329194529032},
{0.33141040517848164,-0.5109458691963251,0.04141845285851307},
{0.2970415243704845,-0.5143588638216119,0.04331311418199208},
{0.2843144992815703,-0.5299342153578361,0.038584990378934425},
{0.3453704756561811,-0.5914914339915989,0.04644717568082526},
{0.3663102019824874,-0.5743506370151872,0.056474703694865305},
{0.3909514627634709,-0.5631275554981531,0.05205341175076726},
{0.4358423119195904,-0.6037815776661418,0.058644490692717245},
{0.346872508727195,-0.48758685258884243,0.0067710318639567215},
{0.41731243176734223,-0.5606262356265973,0.014793617940692515},
{0.45183751295820923,-0.5946830002115371,-0.008871918883764538},
{0.4217829360458073,-0.5644315875113186,-0.041741449451751296},
{0.3506703676546187,-0.5097317662203826,-0.06963062945339785},
{0.28361213954471753,-0.5540186667587319,0.023919999280242497},
{0.2530819292145608,-0.5459934114006442,0.0022921132518898026},
{0.3065914407176459,-0.5873913771860397,0.0010300851584759045},
{0.2390957214590546,-0.5430920651668864,-0.03888468157153628},
{0.3312596111065734,-0.5931838532162996,-0.04062307476388784},
{0.3331680524256613,-0.5777052055430648,-0.06798133876952579},
{0.06333054960259141,-0.9526413257109135,0.08320509039812614},
{0.06730325323339398,-0.8409594882220737,0.11212908438663353},
{0.03691526004572517,-0.8530144370453108,0.0893917122418229},
{0.04039700560288929,-0.9526883836506869,0.06640433547658108},
{0.026764389553782315,-0.949109392244472,0.036753904020447176},
{0.020364577492868935,-0.8573680484800027,0.053502817975227865},
{0.014917915669028389,-0.8572602881013626,0.005036513871943537},
{0.021614099257918087,-0.9455633400411334,-0.004169498769664549},
{0.017757163849811523,-0.977360307293089,-0.008991643604708109},
{0.024304897456508174,-0.9777644662990084,0.04650281055001882},
{0.027355127261308097,-0.999966559460017,0.039388837005767646},
{0.023128232167750735,-0.9999737001263747,-0.033745786532611115},
{0.13030463437647402,-0.897951666658627,0.09818525994112187},
{0.10014866542165239,-0.8230094518575188,0.12230040130273936},
{0.09195368712846515,-0.9522257714480549,0.08948562487659653},
{0.06548899554211042,-0.9781004434584152,0.09876896537950214},
{0.04511420838681152,-0.9994871456894845,0.07927772390135224},
{0.16623996329887186,-0.9477929216511993,0.001928101863461889},
{0.15876524383221213,-0.950665244531374,0.042261999964337306},
{0.15538880616676073,-0.8971219943959723,0.08135405895258266},
{0.1448531526705902,-0.9503630873021931,0.06554595150232845},
{0.1200986303524443,-0.9506928180722433,0.08228477096671721},
{0.11788532187386908,-0.9779501507236136,0.09893283486513949},
{0.09218052184477528,-0.9778377292648461,0.10357487773200943},
{0.10620225678660039,-0.9999092308843818,0.0963940231077925},
{0.03689806553793009,-0.850513320418528,-0.07565167455536412},
{0.06570981421314001,-0.8992220684366883,-0.08944749615718332},
{0.03980106482917491,-0.906103326715864,-0.07213955067946354},
{0.06403981966172588,-0.9639197440048074,-0.09878878851969461},
{0.09611874161242694,-0.8959515483972684,-0.0961378398462624},
{0.1289689232780249,-0.8973936242602498,-0.08906782137158353},
{0.1476570633601759,-0.9221001266133635,-0.07243727717259313},
{0.15952951192691814,-0.9445566957798092,-0.043396525836827834},
{0.020696503306467245,-0.8556026508321464,-0.039412494697343876},
{-0.005058403333994753,-0.855926067464582,-0.05936061687552732},
{0.0001487819486555836,-0.8380428173324322,-0.13048315781024405},
{-0.03654654692821543,-0.8506354434277928,-0.0757603969592631},
{-0.02043063204409123,-0.8554685770302295,-0.03951047222757735},
{-0.014654076854382289,-0.8573636177439515,0.00488641083226349},
{0.0001487819486555836,-0.8399167070401116,0.14132014200685186},
{0.01866980062880137,-0.8133155840124734,0.1794456095037039},
{-0.07041184138734558,-0.8072952028434321,0.16693999927048672},
{-0.06263599446502156,-0.7826395523325209,0.19189814575186714},
{0.10324550602772506,-0.9999745808537244,-0.10292041601332505},
{0.16122278477966556,-0.9999722367640091,-0.03366501705982426},
{0.1414936927185094,-0.9991050184169572,0.07670287007092808},
{0.15678004373719112,-0.999966559460017,0.039388837005767646},
{0.14510879394605902,-0.998560606968022,-0.07985747284148496},
{0.04912738482674248,-0.9999890925305159,-0.08813143205345673},
{0.1598310729714315,-0.9787375616231376,0.046727355375219916},
{0.1667384143298079,-0.9758639108771127,-0.009116733987658658},
{0.1605477140409998,-0.9722357748847886,-0.049937416869500435},
{0.11927844284586255,-0.9671776628683016,-0.09886073716933363},
{0.09222848761120128,-0.9697006486326585,-0.10481874929236945},
{0.03939759685548357,-0.9690897219443487,-0.08084537793473935},
{0.02372070423067272,-0.9737534307040197,-0.049928758642170994},
{0.02706109982304695,-0.9385469375375696,-0.04537192953379064},
{0.5134538893705639,-0.7002834153511805,0.07053963492577689},
{0.46591768754709517,-0.6450375024545193,0.05584074259894997},
{0.5115821676071298,-0.7092717392912632,0.08212523736957036},
{0.5190827940075203,-0.7165897570379464,0.07262545473308026},
{0.5016011013481956,-0.7196608126571522,0.08369818931670678},
{0.4405839447252263,-0.633653938864731,0.06306308625616028},
{0.4622469785496549,-0.6210060301911166,0.03328688693449919},
{0.475344830501718,-0.6565098975597564,0.04244368724174025},
{0.5198753808739297,-0.7090192008859953,0.06024454194291921},
{0.5089633587071334,-0.7266876483923961,0.061566107205168114},
{0.5081717609652857,-0.7105966513174407,0.05104323103039299},
{0.46870661232208566,-0.6672790657504427,0.03570367053014203},
{0.48394852048373993,-0.66017789662689,0.028912829075644384},
{0.48120327978529115,-0.676444239742331,0.03383738217697264},
{0.5316154357955454,-0.7132907556310046,0.0380240890040838},
{0.5216914271192156,-0.7242833304761633,0.04146495526257354},
{0.5257669184065457,-0.7342168781071721,0.022201673121810976},
{0.537993717460173,-0.7137898028466082,0.026349790541356808},
{0.5360143843642657,-0.7174095516046336,0.012797374879672313},
{0.48029966707422195,-0.6446231541106471,0.01217249205028394},
{0.4845651109263901,-0.6583032616883764,0.0007438487698460993},
{0.5209985521384357,-0.7172121331818011,0.005851132471745309},
{0.4739243392336284,-0.6692382911634754,-0.006247690123154957},
{0.47945892474626517,-0.65685866559021,-0.010952887915819165},
{0.5288531360858167,-0.7136755928338385,-0.01471584294089442},
{0.5214324255301666,-0.7230506238286664,-0.008771217873572977},
{0.5312277260665865,-0.7217553584400426,-0.02564233613552774},
{0.48684055810689464,-0.6609913093077053,-0.027417746975866828},
{0.5232212369758716,-0.7175522023359706,-0.03831319791883857},
{0.5135570564173344,-0.7262583005842771,-0.04083419188441996},
{0.47146178491510793,-0.6759114132454563,-0.040855017698825824},
{0.47691390724851607,-0.6631349319284474,-0.03950643443142058},
{0.4765213467443087,-0.6687336072928343,-0.051615297318106636},
{0.4715076775848493,-0.6777325135107639,-0.04588535292967043},
{0.5075720804877483,-0.7112157755449277,-0.05845632668188166},
{0.49924077915049,-0.7176617377189616,-0.05156211493584051},
{0.49723219235692334,-0.7253772480430102,-0.0655378623603634},
{0.5009350004788445,-0.7100294087056727,-0.07731779390643988},
{0.49172009926583105,-0.7182099295206744,-0.07864999564514201},
{0.46044379092367377,-0.6732307095372582,-0.07170204598112187},
{0.4659496376254094,-0.662950304376662,-0.07018186992670561},
{0.42021879137216717,-0.630689695148558,-0.07700638226526219},
{0.4737671632758483,-0.6611400167332776,-0.06296623334700403},
{0.47294822233720757,-0.6323506249830966,-0.031142342937452813},
{0.4840217157013198,-0.7138858427766726,-0.052186930016971216},
{0.4790797377481205,-0.7191244497012274,-0.06125655186625041},
{0.45524885452600894,-0.6843091891731347,-0.05252056308666265},
{0.46197060630734116,-0.6817897127685248,-0.033216090005240465},
{0.49789570524283167,-0.7231637227700104,-0.034719193498725445},
{0.5120674212774731,-0.7347908955447064,-0.02912637158380089},
{0.4983052299107582,-0.7255621601374779,-0.022621603922114656},
{0.5036634396093927,-0.7203138652120771,-0.011757466223835156},
{0.4669335591211132,-0.6798490503780921,-0.011928489925481801},
{0.44598148906226054,-0.676242864821251,-0.002725092366619541},
{0.467797213909812,-0.680032797202528,0.00324039916406237},
{0.5092777783709515,-0.7235127753431462,0.01065132687130578},
{0.479008818871998,-0.7149590835752803,-0.0723689598295649},
{0.45283463181450584,-0.6800669152250876,-0.06459425107796964},
{0.43323233739239336,-0.6755139342177425,-0.047664381526968766},
{0.461244331435533,-0.6835619665400567,-0.0222248294762805},
{0.503297802262781,-0.703879614814842,-0.0672646570510029},
{0.4097362660596567,-0.6001650401755296,0.08110028752902537},
{0.4258910819933315,-0.6347974752554907,0.08004097577219327},
{0.41895578770384295,-0.6393087097864633,0.09701484104172105},
{0.4050818794602404,-0.6418587271056279,0.10198375570216758},
{0.3839088958827974,-0.6039430488634578,0.08314324978853058},
{0.391634934286087,-0.645372314343894,0.09248133088362859},
{0.41796284214021834,-0.6655560243132779,0.12278043835724241},
{0.40973045325914914,-0.6789730112078922,0.11922078230376484},
{0.43053640387587233,-0.6710377661849367,0.12202940827208392},
{0.43843533583272,-0.6668112640312739,0.10977309807741824},
{0.4374149115757871,-0.6775356506236443,0.1034573074056596},
{0.4241804520369705,-0.6468627895621505,0.06984819620805954},
{0.43178019413832314,-0.6462818076037283,0.06314136259306509},
{0.42515988859801696,-0.6570019396055174,0.053236160833062915},
{0.415754845125044,-0.6581835776163875,0.06811884063328034},
{0.4140778318541359,-0.6525376681667574,0.03026653411132902},
{0.42235550367062763,-0.6574502298264793,-0.0017822127654085489},
{0.3655889675810495,-0.6225609340024114,-0.008591386898430031},
{0.3837229946637678,-0.6536700938432605,0.03603089461465847},
{0.4022792559875503,-0.6619478198583584,0.07413893725963933},
{0.4273714762708475,-0.6893392669606,0.09932021940246144},
{0.46759646227270246,-0.6960739044605397,0.0671916515285443},
{0.446572904252363,-0.6775411788814696,0.050453956685232754},
{0.3867549595383015,-0.6437079699971691,-0.04681863937759621},
{0.35121076840670024,-0.6244365309661838,0.018134514870173462},
{0.3709276522318254,-0.6481580007521682,0.04086181962389526},
{0.3429847478618514,-0.6105916325265129,0.0358877289965632},
{0.39051425615746294,-0.6549509153033503,0.08221488186411118},
{0.4042486978378387,-0.6808120105628747,0.10395017598016416},
{0.41359931236060454,-0.6864003475431418,0.09617268955000467},
{0.461585633607992,-0.6796812379438587,0.042301863039146716},
{0.4531936027325636,-0.6764876121768874,0.033103126560411734},
{0.4892184542026384,-0.7221275944669509,0.06308925063327006},
{0.49666186042460597,-0.7185097020111855,0.053430191843012204},
{0.4871935400789748,-0.720023198087396,0.07404856108391575},
{0.46814558900037107,-0.6813103125476438,0.026261948150469845},
{0.4638912152135054,-0.6829473407968787,0.01497191780521226},
{0.5049025010434587,-0.7264043658278004,0.022861906992048348},
{0.39748095853920445,-0.634458747516823,-0.0711888800286212},
{-0.13480173662089795,-0.3966860614572085,-0.09818730593850333},
{-0.16548165705084028,-0.41446243193806775,-0.08126192132215983},
{-0.14823326229160705,-0.37155653898324165,-0.053924889620473725},
{-0.09010463393204547,-0.34019676478764244,-0.060261465457683655},
{-0.06984465297418375,-0.31133127819445355,-0.04333590469587022},
{-0.19577159141036643,-0.448597337363397,0.03188250620208198},
{-0.2040987601039074,-0.48240493740630064,0.02956066501472927},
{-0.1862569177068418,-0.45593535439574256,0.06588233515128104},
{-0.2112130723894469,-0.5103428826038137,0.01798103796726176},
{-0.1795137710257395,-0.5030702968387198,0.1062135233218499},
{-0.22131876834317948,-0.6133503686778883,0.06524476984805799},
{-0.21538514559290267,-0.5314460312772566,-0.0024491943621092415},
{-0.23210278695194575,-0.6348819844321008,0.0030935073917955913},
{-0.22111625525137069,-0.6695856500301695,0.07112930221083158},
{-0.21968519525508545,-0.7343048695442259,0.006239438385371485},
{-0.20734704516516184,-0.7482773379530779,0.06293834816414956},
{-0.19954250008089142,-0.6792019461201899,0.1168195401584301},
{-0.1712143249192346,-0.740943507763056,0.1342710441941396},
{-0.17287891315968715,-0.779295579632142,0.09955061767712468},
{-0.1373894084216721,-0.7640425065576247,0.15660983978946225},
{-0.13707871491202564,-0.7997739674230604,0.11924935851884748},
{-0.10017035841375639,-0.8218752105277105,0.12257793881508512},
{-0.06494148122297422,-0.8414224391659939,0.11100141463781862},
{-0.03681682182733962,-0.8523161828528725,0.08985802349932323},
{-0.02028050190510812,-0.8569666265036928,0.05423600316931768},
{-0.162012648166117,-0.5894634034480827,-0.167413302148178},
{-0.15859945029605718,-0.7062214146389024,-0.16405647082849453},
{-0.20526707880732065,-0.6681059332352302,-0.11346517487532558},
{-0.19179993110273189,-0.5836150351052501,-0.1281731319190279},
{-0.22517390164763224,-0.6087775238813962,-0.05201654314894661},
{-0.22581536925049667,-0.6722605544875117,-0.05183308086719288},
{-0.19286771139177197,-0.7274050482424502,-0.10873611614631216},
{-0.14339518306636095,-0.76855650521751,-0.14289402887994407},
{-0.12408614375237222,-0.7094412996305443,-0.19121543300973692},
{-0.12384317140108655,-0.6253936512511558,-0.1970326778029988},
{-0.10104409414319565,-0.56119484675317,-0.19817862603173145},
{-0.12638840569326007,-0.46086290197005964,-0.14958816647145232},
{-0.16044721627558128,-0.45272201388579114,-0.11881720593286126},
{-0.20324322155647664,-0.5076651327196496,-0.06833192245328473},
{-0.2103760291163584,-0.5282030305801,-0.04880096694649227},
{-0.21464530751991026,-0.5356048258222104,-0.02700776161978822},
{-0.20372170040105342,-0.7659954584819977,-0.04507803759204482},
{-0.17157149373363845,-0.7802662766679498,-0.08918001248627488},
{-0.13727965624425664,-0.8023225891281172,-0.1074636819205211},
{-0.10048613304272763,-0.8236605939115778,-0.11133450572144875},
{-0.09971705482172752,-0.7754959863493222,-0.17340732924498795},
{-0.08546376988485886,-0.6563210831656473,-0.2175451565171737},
{-0.07232640714892624,-0.5140094589575364,-0.19310853612328968},
{-0.18087660852655724,-0.44464372519160417,-0.08618067517263205},
{-0.19287440491962918,-0.48011346098803287,-0.08210844935132126},
{-0.13180023136300986,-0.5169898809576394,0.16106947724739804},
{-0.14784509187449618,-0.44269949924281826,0.10647995011993877},
{-0.16239183516426162,-0.41709640289812944,0.06593618146647226},
{-0.164207054880804,-0.38103576679835655,0.005468436113853703},
{-0.11682038701165093,-0.6205250446610063,0.1970822695276087},
{-0.08914851632128697,-0.7217975385052641,0.20555704812494768},
{-0.1369740574035865,-0.6784968629033791,0.18418966769696407},
{-0.1714843830239343,-0.6724599647091195,0.15394614089393768},
{-0.18619277365648565,-0.605722429751696,0.13797351357477255},
{-0.1580951187163559,-0.5148356896087016,0.1395059114148714},
{-0.18239316682401427,-0.4166749816361572,0.02515884391988383},
{-0.32059175366039766,-0.4823437878289333,0.02497704824526863},
{-0.38940424160459525,-0.5638955903959852,0.052831798582370415},
{-0.41076950828693976,-0.5702342528795312,0.046493678084885734},
{-0.3458330336602069,-0.4866049906401716,0.005874505620639343},
{-0.226392055969383,-0.40605137735188745,-0.0042606472755255045},
{-0.2239539587718791,-0.39980082825225904,-0.026054963673655236},
{-0.23234222284418135,-0.40994068287750574,-0.05119846938800397},
{-0.22822430759790205,-0.4221070640349484,-0.07112313711938419},
{-0.2946878957006359,-0.48935829338128234,-0.08535699185595484},
{-0.35013670107934897,-0.5098177794083126,-0.07008229353759125},
{-0.4409790932128764,-0.6239115090685919,-0.0732746320876669},
{-0.4186697545599861,-0.629335800417752,-0.07719920735622506},
{-0.29713856697476226,-0.5138715506042357,0.04337197386825044},
{-0.3662114250228135,-0.5746523200065644,0.05655704492722996},
{-0.29724785846402557,-0.5401129981319366,0.03903328059989618},
{-0.35003246361010737,-0.5903145248091137,0.04891285996884988},
{-0.3289544359906061,-0.5804467336369936,-0.0619944387894221},
{-0.23976881394859664,-0.539288163094879,-0.048858187124915166},
{-0.24377268177792458,-0.5461979433905313,-0.025052465605700052},
{-0.25053819893370743,-0.5446094770923899,0.002190219872363359},
{-0.2903308697537578,-0.5574774592061995,0.02643316154723795},
{-0.26891322011858765,-0.4970222066322942,-0.08855808348092065},
{-0.337493074095619,-0.5639080425257438,-0.07897221990824284},
{-0.3963120030021692,-0.633785248537735,-0.07124069389608252},
{-0.3843376204069459,-0.6421939048355941,-0.044242701575049434},
{-0.3301853811834038,-0.5935784868171916,-0.03461041689622035},
{-0.33630875325374554,-0.6102618340082052,0.014225901091120912},
{-0.34459157393781975,-0.614397539946947,0.037465667215463676},
{-0.15653891413851398,-0.8947414832174828,0.08081628683289847},
{-0.12921753228434824,-0.9009524808842869,0.0974453541198718},
{-0.14459924575051764,-0.9504039124022615,0.06550091246063351},
{-0.17399093306098173,-0.8955564270089214,0.05091362861348204},
{-0.09141705317950974,-0.9510757312245595,0.08873703372871396},
{-0.11980106645513312,-0.9506928180722433,0.08228477096671721},
{-0.11800228246590001,-0.9781090203878353,0.09881271720430147},
{-0.1412545549186075,-0.9989962282648006,0.07647384031106963},
{-0.15966491359468515,-0.9782538932620237,0.04629359038070129},
{-0.15851168920307943,-0.9500580168979328,0.03760140762451898},
{-0.16526915786585183,-0.9492235751579386,-0.00018610446380262752},
{-0.043383538495833686,-0.8098636070397267,-0.16575425571520236},
{-0.06566625208346218,-0.8404414985936274,-0.10074282441619023},
{-0.16076626992022344,-0.9999719386716754,-0.03426612025077262},
{-0.13280867772798793,-0.9999712476394472,-0.09036814078022905},
{-0.022815492660722865,-0.9999714915331748,-0.03445391842101684},
{-0.10639898417720474,-0.9999710850436289,0.09632433724995945},
{-0.02705756336399693,-0.999966559460017,0.039388837005767646},
{-0.04494684309107876,-0.9995553681849519,0.07924051655824325},
{-0.15648247983987998,-0.999966559460017,0.039388837005767646},
{-0.04211664607751952,-0.999966559460017,-0.0796326570232532},
{-0.07571226182219291,-0.9999999999999998,-0.10184480402569902},
{-0.1664296719699822,-0.9764648514722427,-0.008976413796385274},
{-0.024077236211454574,-0.9783434293593524,0.046530153746811964},
{-0.04017091611741349,-0.9690543844531514,0.07731702157630249},
{-0.04145570762540244,-0.9501397619456301,0.06579779887536807},
{-0.02648476539510054,-0.9483607604476348,0.03706965155011535},
{-0.017485262992503428,-0.9770372971501993,-0.008806758609543438},
{-0.11872661973753891,-0.9674631946750518,-0.09885637418154007},
{-0.14455756702240283,-0.9690994234948463,-0.08085778941554338},
{-0.14733058450649378,-0.9215226404650368,-0.07260830087423978},
{-0.12869526096601752,-0.8970281359598049,-0.08907811910674843},
{-0.15946505623457677,-0.9445822097736453,-0.04269575140920441},
{-0.16019139885464254,-0.9725438533116891,-0.050039648990315204},
{-0.09178659282576303,-0.9680596096865698,-0.10485980473651375},
{-0.09706027979813622,-0.896234194128242,-0.09597808945469102},
{-0.0267953369578832,-0.9378350252963864,-0.045429136162562},
{-0.02346630952314496,-0.9732206584057512,-0.04971354952687598},
{-0.03914276855910676,-0.9696029962940619,-0.08071507093594868},
{-0.039493270944956506,-0.9059590906752977,-0.07210709926404255},
{-0.06393079916549324,-0.9626868341125374,-0.09875300388999655},
{-0.021308947555748567,-0.9453885766356636,-0.004119392158296359},
{-0.06562995256700589,-0.8979257190759418,-0.08941073595257491},
{-0.06429353688667708,-0.9525775610508003,0.08371592581056318},
{-0.06547314244981711,-0.9780286980535491,0.09879289406410902},
{-0.09176118722913908,-0.9776955527713128,0.10353577343768586},
{-0.4891228343117718,-0.7223239695666153,0.06332745350721618},
{-0.44691725509641683,-0.6786406653550964,0.05037886451643813},
{-0.4930104867799031,-0.7246465153358478,0.0760296149855677},
{-0.5090805902921949,-0.7271569947718397,0.07031777293157929},
{-0.5121367412947148,-0.7111016197307639,0.08267664043869652},
{-0.49575324789212133,-0.7121343741705918,0.08251674100095827},
{-0.4307878312097145,-0.6460300415285979,0.06310582185709462},
{-0.4299747301708844,-0.6620518134338723,0.0536339379531105},
{-0.4454692715853672,-0.6749918119455786,-0.0038915683174243327},
{-0.4574030052259922,-0.6769581780249692,0.038968350669751135},
{-0.4958484612934422,-0.7173551768530326,0.0532904813860578},
{-0.5126202199607071,-0.7186105927164985,0.05382692563989176},
{-0.4814089499459071,-0.6767744176508815,0.03384469898880033},
{-0.5047648636831887,-0.7204365437570548,0.03471783853357215},
{-0.4674267257879516,-0.6801356797066163,0.0270345086319139},
{-0.46811179616944837,-0.6673664881021322,0.03594405489798493},
{-0.4624161053000871,-0.6819039227812946,0.014544927636460023},
{-0.49189278957461635,-0.710220391044027,0.019678335066514414},
{-0.5058376437936444,-0.7291874913519347,0.02290060479682595},
{-0.5243097888807116,-0.7338116757780846,0.02977908539743756},
{-0.5224339886721661,-0.7218764110268364,0.04116751331212613},
{-0.537993717460173,-0.7135463562575189,0.0259453876417097},
{-0.4865373575545459,-0.6533861744450428,0.014925361202545655},
{-0.48548799124193875,-0.6586531678895587,0.0010105872099202449},
{-0.5351660406817988,-0.7158502577062422,0.013633523875759659},
{-0.5259964630531624,-0.7260496359506724,0.008237754543076204},
{-0.4729736550331345,-0.6683560733521765,-0.006123737910933161},
{-0.47917779657626325,-0.6563305950210232,-0.01241062717597242},
{-0.474516269310489,-0.6298306336917288,0.008601887878367914},
{-0.48437490091817303,-0.6598636937574965,0.028531839973845913},
{-0.5315611694411565,-0.7135731032696445,0.03776825803349353},
{-0.5033385325152885,-0.7199815329089329,-0.011648120535965686},
{-0.46719841415962426,-0.6797094889673045,-0.01133664114653033},
{-0.4604763642859585,-0.683574052829224,-0.022657740842752558},
{-0.4883012647407336,-0.7121810933690768,-0.022522406923243237},
{-0.49970591158830696,-0.7290073080858519,-0.022659271953375762},
{-0.5148449643451759,-0.7337283183218549,-0.0187220006613314},
{-0.516147560095279,-0.715003580630914,-0.008123829072988673},
{-0.46108136977654834,-0.681899735938971,-0.0330142137470537},
{-0.49005248945308666,-0.7132988447729698,-0.034667894518022366},
{-0.5073552047653149,-0.7193421519524044,-0.041369186325539924},
{-0.47117703898814667,-0.6758295733501983,-0.04087351297316806},
{-0.460092678803505,-0.6824868287902345,-0.04779700551617154},
{-0.4715039649803294,-0.6784915920889328,-0.04600468471071955},
{-0.4951619410992312,-0.7098900369900065,-0.05031940864551234},
{-0.48395876402029864,-0.7142012109160978,-0.05205732760006025},
{-0.4979517872505259,-0.7251561041803437,-0.06049931604068993},
{-0.47866257107672955,-0.7183843541848559,-0.06145899720980156},
{-0.4832263376066946,-0.7209999382677875,-0.07304094124768118},
{-0.5018117306812726,-0.7125927588819455,-0.07675666218751319},
{-0.4871880524701042,-0.7098840073950745,-0.07879222633728152},
{-0.4523903251910947,-0.6801844991010889,-0.06442214340420037},
{-0.45679164494883356,-0.6699384558567798,-0.07102935998112588},
{-0.43258982646636085,-0.6751638247717872,-0.04863301901574356},
{-0.3679792345086428,-0.6239083249004818,-0.008525278148601637},
{-0.41142746581571965,-0.650430534757593,0.025796951209168185},
{-0.38306594496164065,-0.6530878517672456,0.03346927879378182},
{-0.42141960213995605,-0.6559188211109422,0.056371414701230985},
{-0.41551992126676884,-0.6582602279951084,0.06815142754521666},
{-0.4018633358841004,-0.6625803582408628,0.07507524527985693},
{-0.3698913206839929,-0.6471323056807888,0.039201364027160214},
{-0.39015371347982747,-0.6546028789540795,0.080684611319303},
{-0.36745928018072416,-0.6165830309909255,0.07273517981119264},
{-0.5241235082714389,-0.7072913764218394,-0.027001826872416864},
{-0.4828970404254938,-0.6577171444120233,-0.026620932618179115},
{-0.5178402232137074,-0.7109578443783497,-0.03862509734747144},
{-0.5294329798735101,-0.7230541196387619,-0.02841483873286044},
{-0.5107504222477907,-0.7326685187775677,-0.035413409895007006},
{-0.47898887378494165,-0.665090336339748,-0.03793658535448517},
{-0.4732051101806173,-0.6342092984321046,-0.0341773429339299},
{-0.5293345687544276,-0.7160791790688884,-0.014227662545820186},
{-0.5058099889548661,-0.7096064969820318,-0.057308495051585966},
{-0.47458605001588283,-0.6652377971973791,-0.04942566008075918},
{-0.47424202436346574,-0.6633126356082998,-0.06193988789235116},
{-0.4618825877709843,-0.6324575452833417,-0.059104731706330925},
{-0.42038183432906107,-0.5633362743303639,-0.04157385381194244},
{-0.43103298505489696,-0.5710547384784466,-0.002153324171239636},
{-0.5070525190997243,-0.7104262373501129,-0.0684524737029718},
{-0.46893125199484736,-0.6661003680139553,-0.07022578434732332},
{-0.42401291059576784,-0.6468025884603904,0.06941836061248544},
{-0.4365541564125161,-0.6806340494396432,0.10131948403577344},
{-0.42479687988380255,-0.6823543538471986,0.0903302559545434},
{-0.41348040061875296,-0.6863935727173753,0.09597925472472282},
{-0.4105104931482393,-0.6882259598424099,0.11039067764463044},
{-0.3841296061566148,-0.6042224562277152,0.08368833872004244},
{-0.4117427662068872,-0.6017242256767088,0.08184733401663322},
{-0.4388370017027575,-0.6142450250692941,0.060470062343030664},
{-0.46430606489448417,-0.6227988794329784,0.03125763692234515},
{-0.4751011264692497,-0.6562607872163264,0.04258022708023598},
{-0.40454733215762106,-0.6409601142159745,0.10126363237215537},
{-0.41865639460357484,-0.6394302366110608,0.09710737161203833},
{-0.425468536110282,-0.6353851371921186,0.07954852723688621},
{-0.43916862942402224,-0.6331247572241185,0.06298052822937109},
{-0.46629992321683467,-0.645624730802298,0.056228086487317315},
{-0.5197910342931382,-0.7087316772804699,0.07354721042755165},
{-0.519754585730515,-0.7093799739077069,0.061033741396445504},
{-0.3870769263580233,-0.640237389352868,0.08815922238875043},
{-0.4048920894912209,-0.669541207173142,0.11468640496797429},
{-0.4176289380774963,-0.6678104153353004,0.12390398901199136},
{-0.4305076379656683,-0.670614732514432,0.12202523497941184},
{-0.46770454784297955,-0.6801187561918519,0.0030037951489971094},
{-0.5080366980388072,-0.7226381317870542,0.010684699663030997},
{-0.4530581739654935,-0.6832356096332385,-0.05610517759826356},
{-0.33211441797282143,-0.4757034559036617,-0.04645366596390948},
{-0.34679058753402786,-0.481373917321869,-0.019213419423121963},
{0.04759334747880819,-0.007775494631384006,0.4082496457172613},
{0.04078283193028496,-0.025443115609041396,0.3989897461115074},
{0.059363130335886624,-0.016673970832152874,0.4169733314132573},
{0.05178108407943584,-0.03475715962232019,0.4063282238320051},
{-0.07568098922645528,-0.20306567369761694,0.37838724351254877},
{0.3626358481287849,-0.14341994505453695,-0.26203814725533653},
{-0.08657169779139055,0.014131351622725372,-0.44849620276435653},
{0.14637696003161726,0.6942677901098274,0.08857210737025706},
{0.14955807947022376,0.7058586769177188,0.047481921919428446},
{0.13019562742989285,0.5359677396888644,0.008082245192434582},
{-0.38391473578260804,-0.0811009785612534,0.2263631071388832},
{-0.42494579055414766,-0.18296458950328,0.07791313849548678},
{-0.45288652697987647,-0.10091197826592532,0.07762588588299202},
{-0.42729260374927525,-0.09439993444136588,0.15830322103942193},
{-0.46155287055058564,-0.1012561258652061,-0.012620213185881333},
{-0.4680621231469293,-0.006770367931031517,-0.013105304260406098},
{-0.45940797426259944,-0.0033382005488257855,-0.10258178312221801},
{-0.45144618547229126,0.09058931174219856,-0.011956293810427048},
{-0.44361584185150243,0.09157438495828253,-0.09757654184601211},
{0.4258463274943187,0.45683637912336905,0.030272523057306506},
{0.08871256983287153,0.26902146150985723,0.28944775089063207},
{0.0001487819486555836,0.42564516259283747,-0.10143415473669531},
{0.09098971071981762,0.416316227512524,-0.09580698445513518},
{0.0001487819486555836,0.3959361424434758,0.14588492476068196},
{-0.30738234742726533,0.3142984350857062,-0.03393124061314016},
{0.07014221687149493,-0.31133127819445355,-0.04333590469587022},
{0.5058500959234031,-0.7241169272056893,0.03419052674487127},
{-0.05509856721106819,-0.31263066267714335,-0.056511585846337524},
{-0.03706669095125547,-0.3125913822373498,-0.06744073477267126},
{-0.4380762565174501,-0.6667186115140927,0.10984781085596997}
};


// texture array: 10kb.
const tgx::fVec2 bunny_fig_small_tex_array[1387] PROGMEM = {
{0.059486,0.02151},
{0.061895,0.031757},
{0.051436,0.023937},
{0.03963,0.018484},
{0.0415,0.023708},
{0.05075,0.031471},
{0.062859,0.038774},
{0.068407,0.034407},
{0.03189,0.05545},
{0.019963,0.046074},
{0.026501,0.046274},
{0.0414,0.051498},
{0.04223,0.041413},
{0.029766,0.039861},
{0.020083,0.03858},
{0.014,0.0465},
{0.0199,0.0547},
{0.0285,0.0618},
{0.048553,0.062867},
{0.051559,0.054887},
{0.053013,0.046189},
{0.053422,0.038525},
{0.040195,0.03286},
{0.03096,0.029075},
{0.020964,0.031646},
{0.01441,0.034576},
{0.0231,0.0217},
{0.371226,0.432388},
{0.358637,0.423207},
{0.380582,0.412625},
{0.396112,0.428243},
{0.41157,0.422269},
{0.404,0.3996},
{0.421797,0.420942},
{0.4222,0.4005},
{0.434359,0.417165},
{0.423442,0.43503},
{0.435979,0.438479},
{0.452334,0.415527},
{0.445781,0.437991},
{0.459627,0.423783},
{0.456185,0.445959},
{0.467451,0.436062},
{0.461947,0.462175},
{0.4739,0.4577},
{0.47651,0.474599},
{0.46395,0.4773},
{0.452,0.4803},
{0.443298,0.467772},
{0.4419,0.4821},
{0.4308,0.4829},
{0.425733,0.468386},
{0.4171,0.4821},
{0.405835,0.464934},
{0.4056,0.4802},
{0.394,0.4772},
{0.3901,0.46},
{0.3815,0.4722},
{0.374478,0.452214},
{0.3691,0.4658},
{0.3582,0.459},
{0.354503,0.438778},
{0.348117,0.45247},
{0.39541,0.448366},
{0.411303,0.446193},
{0.409225,0.455462},
{0.421283,0.454759},
{0.425192,0.443427},
{0.407227,0.435815},
{0.384962,0.443143},
{0.442554,0.457636},
{0.44106,0.450576},
{0.430855,0.455345},
{0.967107,0.192603},
{0.960847,0.220006},
{0.951374,0.211142},
{0.948029,0.185878},
{0.938008,0.194273},
{0.927554,0.206266},
{0.934569,0.219786},
{0.938623,0.232709},
{0.920548,0.228066},
{0.9253,0.242},
{0.905478,0.231463},
{0.9089,0.2441},
{0.9212,0.1848},
{0.931059,0.184072},
{0.925066,0.194827},
{0.910882,0.180661},
{0.913939,0.204956},
{0.93732,0.174085},
{0.923375,0.176163},
{0.910975,0.160608},
{0.8959,0.1674},
{0.896,0.1787},
{0.8968,0.1899},
{0.8986,0.2021},
{0.901,0.2148},
{0.923434,0.168149},
{0.9209,0.1579},
{0.930779,0.16079},
{0.941705,0.167615},
{0.947607,0.156322},
{0.938655,0.153442},
{0.926704,0.150977},
{0.967073,0.144315},
{0.956767,0.163307},
{0.958324,0.174367},
{0.9743,0.1598},
{0.937991,0.135697},
{0.949779,0.125869},
{0.948855,0.14372},
{0.9604,0.1356},
{0.8975,0.1537},
{0.914565,0.14406},
{0.9004,0.1426},
{0.9045,0.1327},
{0.922614,0.128857},
{0.9095,0.1234},
{0.913469,0.115732},
{0.930513,0.116576},
{0.9156,0.1103},
{0.184217,0.561742},
{0.151116,0.546882},
{0.204476,0.533135},
{0.219264,0.559346},
{0.264148,0.532095},
{0.276106,0.504227},
{0.200792,0.504785},
{0.139629,0.523654},
{0.112656,0.559722},
{0.144416,0.578895},
{0.169192,0.5848},
{0.209108,0.585594},
{0.266281,0.585679},
{0.2622,0.5592},
{0.29518,0.561405},
{0.302473,0.537267},
{0.339854,0.522963},
{0.323648,0.485205},
{0.269193,0.472797},
{0.2092,0.473},
{0.156232,0.485579},
{0.094889,0.518651},
{0.0576,0.5529},
{0.081,0.5733},
{0.1023,0.5908},
{0.133134,0.611731},
{0.163253,0.601951},
{0.1966,0.6094},
{0.225604,0.612146},
{0.272046,0.610428},
{0.317761,0.601352},
{0.311342,0.5845},
{0.296414,0.103376},
{0.337565,0.120564},
{0.318437,0.131919},
{0.268989,0.127128},
{0.295749,0.148419},
{0.301383,0.170837},
{0.349588,0.151691},
{0.3798,0.1318},
{0.352713,0.103234},
{0.304095,0.079824},
{0.266578,0.074608},
{0.2641,0.1012},
{0.221066,0.101321},
{0.211628,0.127085},
{0.22717,0.153051},
{0.2636,0.1525},
{0.255717,0.178547},
{0.305033,0.195565},
{0.3442,0.1825},
{0.3697,0.1709},
{0.3943,0.1584},
{0.4209,0.1446},
{0.4016,0.1152},
{0.3795,0.0903},
{0.341775,0.065945},
{0.278602,0.047113},
{0.206959,0.07568},
{0.2729,0.0159},
{0.326302,0.028612},
{0.212612,0.015973},
{0.202935,0.047786},
{0.155821,0.088621},
{0.187259,0.103815},
{0.172953,0.1264},
{0.166882,0.143319},
{0.1994,0.1504},
{0.183444,0.171162},
{0.2199,0.1779},
{0.388276,0.061817},
{0.3239,0.2175},
{0.2967,0.2251},
{0.3516,0.2085},
{0.3783,0.1986},
{0.4061,0.1889},
{0.4338,0.18},
{0.448,0.1307},
{0.4259,0.096},
{0.2691,0.2303},
{0.2426,0.233},
{0.25498,0.204792},
{0.218,0.2038},
{0.2161,0.2304},
{0.2146,0.2582},
{0.2427,0.2604},
{0.2708,0.2581},
{0.2992,0.2521},
{0.328641,0.25754},
{0.356519,0.249311},
{0.3842,0.229},
{0.4118,0.2231},
{0.4417,0.2196},
{0.465,0.1711},
{0.301929,0.292741},
{0.341822,0.295855},
{0.393411,0.293176},
{0.3844,0.2608},
{0.4118,0.26},
{0.4396,0.2622},
{0.4717,0.2176},
{0.181392,0.630712},
{0.2174,0.6374},
{0.252944,0.638102},
{0.298572,0.630592},
{0.346322,0.611844},
{0.336421,0.579029},
{0.35117,0.561074},
{0.3775,0.5476},
{0.385317,0.518155},
{0.176524,0.655339},
{0.1861,0.6853},
{0.1588,0.6777},
{0.1313,0.6686},
{0.127224,0.710078},
{0.154817,0.718109},
{0.184,0.7124},
{0.2137,0.6903},
{0.2155,0.6634},
{0.1381,0.6425},
{0.1049,0.6585},
{0.0997,0.6889},
{0.1,0.7204},
{0.092449,0.751887},
{0.142025,0.754511},
{0.1823,0.7399},
{0.2124,0.7179},
{0.2404,0.6927},
{0.2403,0.6657},
{0.710641,0.913853},
{0.760274,0.923963},
{0.746551,0.964633},
{0.702204,0.972096},
{0.729625,0.978032},
{0.761526,0.876723},
{0.682728,0.852495},
{0.647215,0.913328},
{0.676828,0.950944},
{0.518196,0.261213},
{0.518256,0.241841},
{0.54466,0.242598},
{0.527602,0.278302},
{0.552421,0.266291},
{0.572202,0.245244},
{0.572529,0.205857},
{0.5535,0.1959},
{0.530588,0.222639},
{0.511,0.2182},
{0.497109,0.221865},
{0.5022,0.2615},
{0.5112,0.2781},
{0.5214,0.2875},
{0.535,0.2912},
{0.555718,0.278016},
{0.5867,0.2593},
{0.602876,0.224531},
{0.617251,0.176249},
{0.5909,0.1613},
{0.565156,0.148242},
{0.52893,0.184927},
{0.5031,0.1749},
{0.4899,0.1717},
{0.485987,0.226563},
{0.501176,0.275926},
{0.521391,0.294776},
{0.5559,0.2988},
{0.5547,0.2901},
{0.590906,0.273031},
{0.6277,0.2422},
{0.6399,0.1899},
{0.6632,0.1306},
{0.642457,0.119076},
{0.6206,0.1076},
{0.598974,0.096409},
{0.5771,0.0853},
{0.5402,0.1364},
{0.5222,0.1283},
{0.5093,0.1218},
{0.157819,0.029139},
{0.14189,0.066833},
{0.1233,0.111},
{0.147713,0.120559},
{0.13459,0.152009},
{0.095949,0.062755},
{0.1049,0.0911},
{0.083,0.1161},
{0.1049,0.1326},
{0.0905,0.1593},
{0.1152,0.1716},
{0.1408,0.1831},
{0.179429,0.195744},
{0.1885,0.2254},
{0.159611,0.230088},
{0.1336,0.2091},
{0.1297,0.2368},
{0.141604,0.26915},
{0.1863,0.2525},
{0.3678,0.6302},
{0.3424,0.6421},
{0.3921,0.6171},
{0.378,0.5902},
{0.3992,0.5727},
{0.4225,0.5522},
{0.2651,0.6633},
{0.303251,0.655313},
{0.3219,0.6774},
{0.2947,0.685},
{0.3493,0.6681},
{0.3757,0.6579},
{0.403,0.6478},
{0.4302,0.6378},
{0.4181,0.6024},
{0.4443,0.5867},
{0.325984,0.71678},
{0.353,0.6959},
{0.3543,0.7244},
{0.339635,0.753932},
{0.388519,0.751301},
{0.3808,0.7198},
{0.381,0.6884},
{0.29758,0.724013},
{0.2998,0.766},
{0.307846,0.792913},
{0.363253,0.785274},
{0.404417,0.801085},
{0.439956,0.759233},
{0.408,0.7185},
{0.4081,0.682},
{0.480413,0.769588},
{0.479499,0.722332},
{0.529796,0.759636},
{0.488008,0.801504},
{0.520924,0.823577},
{0.540561,0.816267},
{0.570869,0.790244},
{0.593483,0.759728},
{0.549758,0.695814},
{0.491497,0.676899},
{0.520057,0.623677},
{0.621748,0.656784},
{0.595693,0.600596},
{0.571026,0.583623},
{0.559001,0.572265},
{0.882006,0.380144},
{0.867797,0.403744},
{0.870252,0.376756},
{0.863414,0.348938},
{0.846226,0.370518},
{0.847045,0.402772},
{0.8586,0.4176},
{0.8722,0.4139},
{0.8825,0.4046},
{0.8916,0.388},
{0.896934,0.348488},
{0.883,0.3446},
{0.852167,0.316824},
{0.821268,0.33208},
{0.821715,0.371331},
{0.831122,0.392222},
{0.8389,0.4163},
{0.83417,0.423983},
{0.8597,0.4249},
{0.878734,0.417482},
{0.8994,0.3915},
{0.908023,0.353192},
{0.9044,0.2982},
{0.889812,0.301813},
{0.8542,0.2628},
{0.8364,0.271},
{0.8195,0.2791},
{0.8032,0.2874},
{0.776602,0.302227},
{0.791204,0.350515},
{0.8072,0.3853},
{0.802782,0.399007},
{0.7901,0.4057},
{0.7562,0.3776},
{0.7663,0.368},
{0.7248,0.3337},
{0.7376,0.3261},
{0.7134,0.2658},
{0.6995,0.2722},
{0.699587,0.219591},
{0.686264,0.22846},
{0.8723,0.2546},
{0.8855,0.248},
{0.8359,0.2025},
{0.8179,0.2117},
{0.8028,0.219},
{0.77758,0.231686},
{0.752522,0.244443},
{0.7311,0.2559},
{0.7542,0.3156},
{0.683079,0.726196},
{0.721826,0.777714},
{0.667668,0.737757},
{0.641108,0.756851},
{0.620319,0.809909},
{0.749896,0.831201},
{0.645678,0.055995},
{0.663939,0.063625},
{0.661783,0.070969},
{0.679694,0.084422},
{0.699449,0.08797},
{0.694968,0.095187},
{0.708185,0.104026},
{0.7164,0.1016},
{0.2432,0.4283},
{0.284827,0.427237},
{0.244483,0.458345},
{0.198345,0.455365},
{0.203207,0.420231},
{0.195137,0.431614},
{0.149568,0.40856},
{0.203567,0.394799},
{0.1591,0.3812},
{0.126745,0.356209},
{0.109171,0.380601},
{0.093883,0.33522},
{0.076596,0.344244},
{0.0829,0.3647},
{0.053559,0.353522},
{0.0645,0.3704},
{0.366517,0.321616},
{0.315022,0.332432},
{0.403094,0.337381},
{0.4319,0.2985},
{0.377111,0.379504},
{0.325247,0.381282},
{0.361505,0.35057},
{0.315975,0.358938},
{0.2788,0.3685},
{0.2791,0.3958},
{0.334157,0.407108},
{0.4032,0.3638},
{0.432748,0.351923},
{0.4579,0.3064},
{0.4693,0.2663},
{0.056024,0.764338},
{0.048264,0.811909},
{0.0279,0.7646},
{0.016,0.7239},
{0.046,0.7207},
{0.0432,0.6784},
{0.0135,0.6748},
{0.0503,0.6386},
{0.0195,0.6283},
{0.0622,0.6031},
{0.036,0.5875},
{0.078445,0.811055},
{0.0932,0.8332},
{0.0754,0.8284},
{0.0592,0.8294},
{0.097072,0.784677},
{0.0729,0.7192},
{0.0726,0.6826},
{0.0775,0.6484},
{0.0884,0.6178},
{0.199763,0.821193},
{0.174219,0.793263},
{0.2092,0.7984},
{0.240558,0.789629},
{0.2105,0.772},
{0.1813,0.7662},
{0.1294,0.7872},
{0.124234,0.819386},
{0.1619,0.8298},
{0.1954,0.8525},
{0.2407,0.8534},
{0.2406,0.8263},
{0.281556,0.821051},
{0.272,0.7982},
{0.269932,0.758055},
{0.2405,0.7478},
{0.2116,0.7453},
{0.148016,0.864077},
{0.11443,0.842942},
{0.746139,0.183397},
{0.764029,0.171666},
{0.734004,0.19582},
{0.715292,0.209271},
{0.624464,0.613488},
{0.602438,0.596002},
{0.72334,0.195069},
{0.092621,0.29405},
{0.0737,0.261},
{0.1011,0.2617},
{0.1011,0.2298},
{0.0735,0.2241},
{0.0435,0.2208},
{0.0459,0.2634},
{0.0538,0.2996},
{0.121274,0.322506},
{0.143589,0.296421},
{0.18363,0.293705},
{0.2137,0.2862},
{0.211302,0.329055},
{0.2428,0.2888},
{0.2719,0.286},
{0.037674,0.01427},
{0.170526,0.359511},
{0.2073,0.3687},
{0.2431,0.3717},
{0.242961,0.332951},
{0.172437,0.333275},
{0.3194,0.8295},
{0.286,0.8524},
{0.288201,0.878358},
{0.340083,0.85876},
{0.356121,0.819141},
{0.2685,0.7178},
{0.2404,0.7201},
{0.381037,0.83581},
{0.611691,0.716097},
{0.441418,0.033588},
{0.427588,0.037394},
{0.433143,0.028038},
{0.444248,0.024207},
{0.446884,0.014116},
{0.4322,0.0165},
{0.418537,0.029014},
{0.424989,0.0454},
{0.436097,0.052519},
{0.442399,0.041669},
{0.453682,0.036544},
{0.455638,0.028281},
{0.467409,0.025252},
{0.463802,0.041246},
{0.474951,0.050712},
{0.460343,0.053376},
{0.455312,0.062358},
{0.4662,0.0673},
{0.447191,0.076708},
{0.440415,0.065357},
{0.42626,0.070052},
{0.427634,0.057412},
{0.413199,0.04876},
{0.447024,0.05537},
{0.453145,0.043904},
{0.950483,0.261607},
{0.944921,0.272954},
{0.957155,0.272054},
{0.962471,0.262767},
{0.967872,0.269534},
{0.963162,0.287797},
{0.950363,0.28008},
{0.93509,0.2819},
{0.937499,0.269733},
{0.9423,0.2529},
{0.956899,0.250575},
{0.977415,0.261736},
{0.973258,0.27375},
{0.973599,0.285822},
{0.965512,0.298805},
{0.951403,0.291774},
{0.9379,0.289912},
{0.923282,0.285162},
{0.92855,0.265457},
{0.943346,0.299015},
{0.9543,0.302711},
{0.957303,0.31308},
{0.936357,0.306489},
{0.9762,0.3037},
{0.985154,0.286683},
{0.5385,0.4963},
{0.530825,0.483789},
{0.548927,0.489073},
{0.521292,0.472234},
{0.536973,0.436435},
{0.512606,0.463386},
{0.510387,0.426493},
{0.503696,0.458357},
{0.489702,0.420696},
{0.493429,0.459677},
{0.845006,0.703996},
{0.8646,0.707},
{0.856747,0.723189},
{0.829087,0.735569},
{0.83709,0.747683},
{0.8208,0.7454},
{0.8269,0.7543},
{0.888,0.6743},
{0.87908,0.683885},
{0.877318,0.63172},
{0.857555,0.676851},
{0.871428,0.695214},
{0.816201,0.620558},
{0.8058,0.594456},
{0.822248,0.594708},
{0.845127,0.598689},
{0.837,0.5739},
{0.813366,0.57586},
{0.788837,0.593254},
{0.787788,0.621229},
{0.812144,0.655745},
{0.835285,0.628682},
{0.849169,0.629514},
{0.867835,0.601399},
{0.857531,0.579129},
{0.849524,0.550652},
{0.818526,0.562354},
{0.795949,0.561079},
{0.785159,0.574737},
{0.77179,0.593519},
{0.763816,0.628675},
{0.761155,0.662316},
{0.786439,0.658232},
{0.810154,0.693488},
{0.833642,0.688449},
{0.83803,0.668416},
{0.863469,0.627314},
{0.884912,0.604843},
{0.884934,0.573602},
{0.8668,0.5609},
{0.907056,0.624867},
{0.891132,0.629162},
{0.908015,0.585716},
{0.570132,0.410056},
{0.553936,0.428209},
{0.560921,0.394532},
{0.584569,0.409291},
{0.591766,0.391298},
{0.57173,0.37345},
{0.550665,0.376651},
{0.535029,0.389565},
{0.539024,0.41165},
{0.5577,0.457407},
{0.571641,0.439591},
{0.589908,0.434597},
{0.609598,0.408153},
{0.6136,0.3909},
{0.592726,0.376465},
{0.579794,0.358837},
{0.555277,0.353897},
{0.5387,0.3628},
{0.518588,0.369875},
{0.518018,0.405103},
{0.494921,0.382534},
{0.897896,0.66779},
{0.551094,0.527744},
{0.545078,0.509752},
{0.571684,0.515751},
{0.573298,0.539084},
{0.587413,0.548406},
{0.595169,0.516508},
{0.570926,0.490967},
{0.589826,0.472835},
{0.612622,0.471785},
{0.616813,0.43333},
{0.627965,0.410089},
{0.635617,0.391852},
{0.619216,0.375959},
{0.607271,0.358148},
{0.587528,0.334518},
{0.5723,0.3445},
{0.797093,0.733715},
{0.783799,0.73252},
{0.782588,0.686489},
{0.770305,0.732727},
{0.748661,0.6849},
{0.738177,0.704629},
{0.756715,0.736224},
{0.738143,0.732102},
{0.7459,0.7427},
{0.729106,0.743635},
{0.7392,0.7512},
{0.810478,0.738233},
{0.61289,0.515762},
{0.610686,0.535327},
{0.597382,0.546776},
{0.613198,0.5461},
{0.634184,0.537771},
{0.636718,0.519012},
{0.634621,0.49278},
{0.633986,0.969939},
{0.643379,0.9782},
{0.607637,0.976766},
{0.576217,0.968503},
{0.5697,0.9759},
{0.608435,0.984416},
{0.653253,0.986495},
{0.458456,0.927631},
{0.450557,0.962279},
{0.450291,0.929408},
{0.445621,0.886005},
{0.440693,0.93464},
{0.4398,0.9634},
{0.426766,0.954389},
{0.432578,0.933372},
{0.423121,0.88026},
{0.416442,0.942661},
{0.415447,0.879806},
{0.409543,0.932329},
{0.408489,0.889243},
{0.401169,0.92397},
{0.400507,0.890191},
{0.396807,0.858573},
{0.404827,0.85607},
{0.4123,0.8519},
{0.418535,0.846155},
{0.432298,0.880898},
{0.429874,0.844962},
{0.440257,0.83821},
{0.451011,0.843981},
{0.459917,0.875888},
{0.463713,0.839556},
{0.467434,0.905904},
{0.464045,0.952148},
{0.593362,0.92395},
{0.623452,0.926437},
{0.603706,0.933434},
{0.577351,0.933076},
{0.606894,0.948762},
{0.616861,0.944931},
{0.617683,0.935503},
{0.619574,0.952999},
{0.62455,0.961183},
{0.571253,0.949342},
{0.5726,0.9605},
{0.930725,0.478947},
{0.920084,0.446826},
{0.933705,0.449523},
{0.942111,0.476943},
{0.955073,0.473508},
{0.948402,0.450123},
{0.967843,0.449291},
{0.971907,0.469665},
{0.976158,0.480503},
{0.955969,0.484629},
{0.9594,0.4929},
{0.9781,0.4891},
{0.900261,0.469227},
{0.8883,0.4383},
{0.905584,0.442416},
{0.918725,0.481915},
{0.931979,0.490668},
{0.943524,0.496013},
{0.867247,0.502392},
{0.833,0.4531},
{0.851437,0.440822},
{0.883217,0.495363},
{0.888753,0.473526},
{0.8709,0.4373},
{0.895474,0.489805},
{0.906741,0.485403},
{0.912324,0.496317},
{0.922098,0.493266},
{0.919598,0.503521},
{0.757952,0.041741},
{0.768326,0.050594},
{0.754576,0.057119},
{0.747169,0.046337},
{0.73502,0.0673},
{0.761532,0.068538},
{0.780986,0.058608},
{0.767212,0.080243},
{0.794678,0.067112},
{0.764784,0.093025},
{0.808722,0.07597},
{0.763075,0.106899},
{0.819766,0.092554},
{0.768227,0.122194},
{0.8293,0.1122},
{0.6072,0.3118},
{0.609211,0.296},
{0.614416,0.318319},
{0.599382,0.324992},
{0.6142,0.3433},
{0.629358,0.325319},
{0.622054,0.311892},
{0.62,0.2961},
{0.791,0.534},
{0.818209,0.527099},
{0.797301,0.548422},
{0.764353,0.546397},
{0.766154,0.560315},
{0.832691,0.537726},
{0.50078,0.490891},
{0.523111,0.519629},
{0.498163,0.53846},
{0.454334,0.516908},
{0.4604,0.5302},
{0.4724,0.5362},
{0.461371,0.496057},
{0.4749,0.4902},
{0.515,0.5331},
{0.518992,0.500901},
{0.904184,0.507568},
{0.889047,0.505122},
{0.8909,0.5135},
{0.870084,0.512752},
{0.8738,0.5214},
{0.752615,0.110785},
{0.745057,0.12096},
{0.737722,0.10272},
{0.744029,0.087736},
{0.729304,0.08727},
{0.738071,0.07829},
{0.719431,0.067336},
{0.728386,0.058273},
{0.720929,0.046894},
{0.708991,0.045783},
{0.712969,0.033259},
{0.732491,0.040281},
{0.72374,0.027009},
{0.749903,0.028573},
{0.741519,0.013605},
{0.845435,0.822187},
{0.820666,0.827707},
{0.846764,0.819052},
{0.849606,0.820618},
{0.847349,0.816071},
{0.811722,0.819042},
{0.799817,0.822664},
{0.810172,0.836172},
{0.827671,0.835293},
{0.848322,0.823749},
{0.8515,0.8241},
{0.848791,0.827881},
{0.832361,0.838172},
{0.829654,0.844113},
{0.836116,0.841589},
{0.851901,0.853129},
{0.854144,0.850762},
{0.8559,0.8568},
{0.851582,0.855952},
{0.851078,0.858959},
{0.820131,0.850489},
{0.82481,0.858473},
{0.848911,0.862942},
{0.826749,0.86446},
{0.82043,0.864324},
{0.83761,0.883177},
{0.840329,0.882495},
{0.837532,0.886346},
{0.817844,0.872543},
{0.834677,0.887477},
{0.833906,0.890564},
{0.814888,0.883201},
{0.812927,0.877536},
{0.809572,0.883374},
{0.814008,0.884493},
{0.813367,0.89972},
{0.816265,0.899782},
{0.8132,0.9038},
{0.809873,0.900968},
{0.808093,0.90298},
{0.797434,0.889063},
{0.799482,0.885105},
{0.782177,0.879057},
{0.785474,0.87337},
{0.803841,0.883215},
{0.781747,0.857232},
{0.804988,0.866752},
{0.793979,0.848857},
{0.7834,0.838},
{0.862626,0.903518},
{0.875919,0.897936},
{0.866099,0.904245},
{0.865973,0.906933},
{0.880188,0.904601},
{0.87644,0.896374},
{0.881552,0.894927},
{0.862642,0.882524},
{0.867295,0.883189},
{0.864513,0.87985},
{0.8622,0.8768},
{0.866863,0.874931},
{0.868333,0.880608},
{0.869581,0.877834},
{0.887018,0.883469},
{0.887206,0.878219},
{0.897448,0.887701},
{0.892909,0.876568},
{0.880467,0.858653},
{0.884432,0.85842},
{0.883451,0.853221},
{0.8803,0.8541},
{0.866385,0.909515},
{0.863296,0.910774},
{0.879216,0.914486},
{0.880785,0.910512},
{0.889547,0.905727},
{0.885206,0.889842},
{0.811261,0.898889},
{0.778327,0.821024},
{0.793378,0.814176},
{0.807579,0.81146},
{0.805081,0.804149},
{0.801625,0.800139},
{0.787629,0.808105},
{0.775,0.8141},
{0.771077,0.807351},
{0.796268,0.796529},
{0.810338,0.794247},
{0.810186,0.791006},
{0.813354,0.79513},
{0.814244,0.798269},
{0.8175,0.798142},
{0.813026,0.812326},
{0.814674,0.814799},
{0.928766,0.879729},
{0.937385,0.881835},
{0.923572,0.891028},
{0.909218,0.896047},
{0.921477,0.914781},
{0.930411,0.89915},
{0.942146,0.887324},
{0.950768,0.877141},
{0.936007,0.875764},
{0.932733,0.874817},
{0.923018,0.858649},
{0.918082,0.869933},
{0.90842,0.920054},
{0.931394,0.915023},
{0.934712,0.903121},
{0.939495,0.917553},
{0.946029,0.891841},
{0.946652,0.920044},
{0.951195,0.893937},
{0.955584,0.880963},
{0.952435,0.882331},
{0.950419,0.879909},
{0.9558,0.8755},
{0.950628,0.87307},
{0.906579,0.863934},
{0.913986,0.846091},
{0.912693,0.865659},
{0.91,0.8715},
{0.920104,0.849082},
{0.917262,0.848274},
{0.918687,0.844606},
{0.92424,0.845801},
{0.9207,0.8419},
{0.92285,0.849163},
{0.902367,0.867849},
{0.898556,0.873368},
{0.886838,0.856863},
{0.568055,0.912975},
{0.59846,0.916427},
{0.564125,0.920503},
{0.558847,0.927749},
{0.554184,0.937033},
{0.547096,0.967871},
{0.5475,0.9596},
{0.551154,0.949522},
{0.662248,0.512779},
{0.6794,0.5114},
{0.672359,0.529848},
{0.650385,0.53994},
{0.659491,0.550289},
{0.6427,0.552},
{0.6494,0.5576},
{0.699,0.689},
{0.692107,0.677083},
{0.70945,0.681616},
{0.68382,0.667008},
{0.716502,0.660157},
{0.690698,0.621516},
{0.674598,0.659645},
{0.668626,0.614348},
{0.692116,0.598993},
{0.671266,0.573828},
{0.69444,0.568058},
{0.709346,0.595254},
{0.720632,0.572167},
{0.7135,0.5552},
{0.73843,0.562414},
{0.7313,0.546},
{0.7493,0.5349},
{0.764324,0.52522},
{0.776514,0.515714},
{0.806666,0.516548},
{0.784488,0.5036},
{0.799324,0.503894},
{0.791928,0.485299},
{0.7865,0.4856},
{0.671416,0.439099},
{0.671122,0.397475},
{0.694178,0.411113},
{0.689219,0.441978},
{0.716707,0.43468},
{0.717402,0.407818},
{0.691422,0.387483},
{0.670579,0.372875},
{0.656803,0.39708},
{0.656155,0.42612},
{0.647808,0.448343},
{0.657507,0.484136},
{0.671196,0.487837},
{0.703846,0.474359},
{0.712811,0.465828},
{0.721907,0.46133},
{0.732085,0.462437},
{0.736656,0.422055},
{0.731913,0.382036},
{0.709013,0.372855},
{0.6891,0.3645},
{0.6727,0.3554},
{0.656112,0.345275},
{0.649801,0.372426},
{0.641931,0.415549},
{0.637154,0.463703},
{0.686121,0.498007},
{0.693745,0.485538},
{0.741829,0.651068},
{0.730423,0.680738},
{0.720413,0.696375},
{0.711577,0.718582},
{0.748237,0.614853},
{0.757045,0.580373},
{0.739874,0.594793},
{0.724676,0.597165},
{0.717739,0.619854},
{0.729032,0.653285},
{0.705,0.7012},
{0.509648,0.891987},
{0.496412,0.883207},
{0.561497,0.875435},
{0.599977,0.881517},
{0.602266,0.874303},
{0.567853,0.866409},
{0.51757,0.874192},
{0.51398,0.866708},
{0.4856,0.8722},
{0.485513,0.861845},
{0.516372,0.856686},
{0.515734,0.848642},
{0.493407,0.846325},
{0.547034,0.834005},
{0.568776,0.838307},
{0.60341,0.828702},
{0.603052,0.820754},
{0.563897,0.891246},
{0.597261,0.8895},
{0.570221,0.898763},
{0.5967,0.8978},
{0.531122,0.903962},
{0.52075,0.897286},
{0.307787,0.9665},
{0.314683,0.957528},
{0.366223,0.954367},
{0.330464,0.947867},
{0.319905,0.949078},
{0.321734,0.94097},
{0.332391,0.938546},
{0.320789,0.931543},
{0.333608,0.929132},
{0.314911,0.922693},
{0.347283,0.918681},
{0.344804,0.910888},
{0.307948,0.913926},
{0.333485,0.972184},
{0.297334,0.975249},
{0.366848,0.963131},
{0.3917,0.9529},
{0.388159,0.942769},
{0.368088,0.942513},
{0.372194,0.923252},
{0.3737,0.9145},
{0.37,0.9071},
{0.896847,0.104145},
{0.8827,0.1144},
{0.878566,0.074841},
{0.890357,0.071039},
{0.875538,0.056859},
{0.864928,0.075742},
{0.864266,0.122077},
{0.909365,0.091685},
{0.899409,0.051492},
{0.887415,0.054633},
{0.886271,0.042375},
{0.873451,0.037294},
{0.861961,0.047504},
{0.862181,0.058516},
{0.844815,0.060646},
{0.843564,0.107968},
{0.6302,0.3589},
{0.641006,0.335186},
{0.939944,0.421337},
{0.9207,0.411695},
{0.939552,0.373711},
{0.984876,0.402331},
{0.9657,0.3745},
{0.978869,0.381005},
{0.9659,0.4206},
{0.9782,0.4151},
{0.9233,0.3801},
{0.916447,0.392301},
{0.859,0.0393},
{0.841709,0.050728},
{0.912831,0.025977},
{0.928,0.0203},
{0.929416,0.028908},
{0.9173,0.0369},
{0.922409,0.043766},
{0.934709,0.039222},
{0.948802,0.021963},
{0.9458,0.0135},
{0.914268,0.768547},
{0.925261,0.767317},
{0.928944,0.784403},
{0.91889,0.7927},
{0.9206,0.82287},
{0.935214,0.830668},
{0.940212,0.776124},
{0.938566,0.764917},
{0.919194,0.755481},
{0.903129,0.768614},
{0.905872,0.793207},
{0.906605,0.814916},
{0.867066,0.781742},
{0.867397,0.768353},
{0.880893,0.769013},
{0.87952,0.791375},
{0.892062,0.771117},
{0.896264,0.756427},
{0.8804,0.7572},
{0.860729,0.75825},
{0.851544,0.767885},
{0.851313,0.780304},
{0.86537,0.8024},
{0.880722,0.803198},
{0.892557,0.792873},
{0.911155,0.047349},
{0.929282,0.070635},
{0.919195,0.080168},
{0.90597,0.036809},
{0.896169,0.039889},
{0.022985,0.865036},
{0.038163,0.880684},
{0.019985,0.865486},
{0.019211,0.861482},
{0.0162,0.8637},
{0.017255,0.867966},
{0.030376,0.892917},
{0.037206,0.890707},
{0.063606,0.879285},
{0.042044,0.8738},
{0.02497,0.862848},
{0.02333,0.859468},
{0.045377,0.863192},
{0.050379,0.849834},
{0.048827,0.86785},
{0.043012,0.867326},
{0.055226,0.869978},
{0.053874,0.854388},
{0.053105,0.848364},
{0.051803,0.84438},
{0.047939,0.845141},
{0.040815,0.474829},
{0.05483,0.452179},
{0.060372,0.457111},
{0.043216,0.476248},
{0.045069,0.478863},
{0.063519,0.461905},
{0.067937,0.457413},
{0.062097,0.441958},
{0.04681,0.450746},
{0.0385,0.473279},
{0.0385,0.4786},
{0.066506,0.865413},
{0.079929,0.853562},
{0.070618,0.869134},
{0.076068,0.872998},
{0.081143,0.858667},
{0.083047,0.853931},
{0.083111,0.85067},
{0.07779,0.850028},
{0.082257,0.874368},
{0.084716,0.859187},
{0.088787,0.855076},
{0.087072,0.872022},
{0.0882,0.877736},
{0.088607,0.872736},
{0.099937,0.867483},
{0.100114,0.87108},
{0.104525,0.869478},
{0.10173,0.873131},
{0.104408,0.873827},
{0.1079,0.8726},
{0.10644,0.876584},
{0.093115,0.885488},
{0.096302,0.888805},
{0.093904,0.906217},
{0.086997,0.909751},
{0.078411,0.910901},
{0.082407,0.89041},
{0.064687,0.914676},
{0.050322,0.899547},
{0.048788,0.910021},
{0.035983,0.89636},
{0.03154,0.901089},
{0.031155,0.908385},
{0.048091,0.915761},
{0.0573,0.9231},
{0.052431,0.928424},
{0.032021,0.914439},
{0.039787,0.927473},
{0.0495,0.9357},
{0.073108,0.481148},
{0.076052,0.459164},
{0.076488,0.481566},
{0.073511,0.48534},
{0.077,0.4866},
{0.080056,0.482982},
{0.08567,0.466},
{0.081878,0.461929},
{0.080245,0.448004},
{0.070105,0.483553},
{0.098413,0.476103},
{0.094833,0.476957},
{0.087345,0.466366},
{0.088168,0.46079},
{0.09325,0.458551},
{0.090731,0.44599},
{0.088445,0.425355},
{0.076592,0.418226},
{0.100476,0.475578},
{0.097776,0.457426},
{0.102625,0.474799},
{0.105215,0.471648},
{0.101716,0.455573},
{0.097828,0.440078},
{0.104862,0.438362},
{0.028662,0.895605},
{0.017289,0.903901},
{0.020567,0.905019},
{0.020491,0.908275},
{0.018412,0.910141},
{0.046651,0.387851},
{0.0587,0.3827},
{0.06141,0.389995},
{0.048195,0.395368},
{0.064006,0.39731},
{0.048282,0.403895},
{0.063879,0.405818},
{0.048313,0.417837},
{0.053588,0.432489},
{0.041705,0.443283},
{0.040583,0.448651},
{0.040602,0.453962},
{0.03522,0.473139},
{0.03355,0.400219},
{0.033774,0.405559},
{0.037426,0.41237},
{0.040471,0.420014},
{0.040916,0.433491},
{0.017528,0.447975},
{0.019048,0.450813},
{0.01928,0.453618},
{0.031387,0.920377},
{0.018695,0.915237},
{0.0152,0.9127},
{0.0135,0.9084},
{0.061529,0.867843},
{0.056919,0.845},
{0.056183,0.848985},
{0.090189,0.882285},
{0.0143,0.4505},
{0.015802,0.445612},
{0.086341,0.852195},
{0.0849,0.8479},
{0.0811,0.8477},
{0.100446,0.478768},
{0.021657,0.405622},
{0.022438,0.402625},
{0.022924,0.398388},
{0.036481,0.39297},
{0.600269,0.842177},
{0.5581,0.8496},
{0.392539,0.96114},
{0.34044,0.97848},
{0.606701,0.856202},
{0.565107,0.857515},
{0.384089,0.930674},
{0.383066,0.924509},
{0.058939,0.050056},
{0.0629,0.0549},
{0.061801,0.044239},
{0.0688,0.0468},
{0.930022,0.144235},
{0.1127,0.6307},
{0.267,0.6902},
{0.629405,0.869498},
{0.6567,0.2004},
{0.6806,0.1406},
{0.6378,0.2518},
{0.593072,0.28524},
{0.6696,0.2081},
{0.6944,0.1471},
{0.1068,0.1994},
{0.0586,0.0971},
{0.0639,0.1456},
{0.0512,0.1811},
{0.079,0.1898},
{0.0199,0.1724},
{0.0367,0.1319},
{0.461,0.6274},
{0.4671,0.6739},
{0.4375,0.6776},
{0.4649,0.723},
{0.4348,0.7199},
{0.0135,0.219},
{0.0162,0.2676},
{0.0278,0.3077},
{0.505205,0.821943},
{0.631179,0.045673},
{0.61742,0.034174},
{0.606316,0.025679},
{0.559,0.0758},
{0.5471,0.067},
{0.594008,0.018483},
{0.617596,0.766934},
{0.639429,0.749551},
{0.6094,0.7649},
{0.274647,0.329441},
{0.2904,0.4548},
{0.2408,0.8812},
{0.201,0.8797},
{0.288641,0.905953},
{0.239562,0.909941},
{0.190553,0.905737},
{0.4216,0.3693},
{0.2431,0.3996},
{0.778297,0.160096},
{0.789579,0.151671},
{0.801994,0.144764},
{0.8478,0.1939},
{0.43268,0.811707},
{0.4221,0.8286},
{0.4059,0.8277},
{0.564133,0.54939},
{0.5806,0.5512},
{0.5738,0.5567},
{0.630107,0.917395},
{0.797388,0.485799},
{0.757497,0.125881},
{0.888022,0.851624},
{0.888814,0.854913},
{0.90211,0.862448},
{0.901129,0.924568},
{0.893232,0.926261},
{0.861325,0.907189},
{0.6359,0.5491},
{0.6278,0.5473},
{0.287728,0.983852},
{0.955787,0.772612},
{0.973626,0.818473},
{0.954129,0.761823},
{0.943702,0.75357},
{0.954816,0.83096},
{0.893496,0.807913},
{0.888412,0.032474},
{0.8403,0.0417},
{0.950995,0.033284},
{0.958352,0.052743},
{0.941482,0.062265},
{0.848167,0.802302},
{0.066588,0.482086},
{0.034583,0.416969},
{0.021247,0.410931},
{0.023277,0.408449},
{0.035298,0.419623},
{0.015281,0.442254}
};


// normal array: 12kb.
const tgx::fVec3 bunny_fig_small_norm_array[1093] PROGMEM = {
{0.4732847178831853,-0.7512757416979444,0.4599851473193857},
{0.6732197525573144,-0.36721077412217146,0.641818831240767},
{0.4433241041868348,-0.4346236311292542,0.7839426241192415},
{-0.09329943134169895,-0.6736958938360406,0.7330955317963506},
{0.0025999049362139793,-0.14059485924295598,0.9900637989790234},
{0.32540337607754033,0.2497025906778175,0.912009462147255},
{0.9470326495133977,0.04610158937969128,0.31781095672160276},
{0.8665987607646581,-0.4962992902925223,0.05189992578315919},
{-0.22091083041894846,0.687533707166261,-0.691733913086404},
{-0.8399389950730404,0.3183147781066184,-0.4395204052084787},
{-0.5060060999403023,0.8625103976255154,-0.005800069920264335},
{-0.013699883619982969,0.9926915671209557,-0.1198989814624787},
{0.0009999843753662012,0.8032874487316695,0.5955906939681095},
{-0.38459764626960724,0.6581959718529784,0.6471960391723603},
{-0.9419860916780338,0.0436993547837899,0.33279508631682553},
{-0.8063741964385642,-0.16479472665311928,-0.5679818248724013},
{-0.45660498615367334,0.24660269291611003,-0.8548093345689004},
{-0.20461057045511163,0.3124161398346866,-0.9276479235296263},
{0.10099782352035445,0.3402926667720457,-0.9348798535562314},
{0.23739338512548394,0.6960806039842012,-0.6775811194651554},
{0.4063729344320232,0.8924405609758385,0.19598694672410572},
{0.4153164904686376,0.5655224545148436,0.7125282914974821},
{-0.03079940665514613,0.4004922845904553,0.9157823576228189},
{-0.4068823844084923,0.03869832459230438,0.9126604872195402},
{-0.6839094448546506,-0.415905743697981,0.5994082778854769},
{-0.8272827885606241,-0.5603883412418394,0.03959917614771028},
{-0.5043967617831839,-0.7451952158620712,0.4361971996229676},
{0.2767086694184214,0.8369262213092769,0.4722147947212816},
{-0.06199683514234692,0.9026539206934929,0.425878259469767},
{0.07430154177298785,0.5149106845075565,0.8540177210515696},
{0.32710879607379123,0.41101105223579393,0.8509228816239345},
{0.19460476592907713,0.07350180008112625,0.978123954548974},
{-0.042199445291937435,0.15129801120071407,0.9875870182539671},
{0.13340227586223946,-0.17540299240057575,0.975416640749838},
{-0.14200453498723836,-0.12270391861221233,0.9822313680596164},
{0.049499087987705664,-0.45759156895301234,0.8877836427370724},
{0.38458816063570944,-0.280391368284589,0.8794729258427104},
{0.29401303976747695,-0.7019311313360274,0.6487287717590555},
{0.027999874280846715,-0.7456966518295499,0.6656970110271306},
{-0.03639889567425761,-0.9093724100596117,0.4143874276761635},
{-0.00549999928500014,-0.943999877280024,0.3298999571130084},
{-0.23919002957142166,-0.9611599348831543,-0.13769426033438445},
{0.02359994324220475,-0.9947976075146308,-0.09909976166535978},
{-0.29590681481241854,-0.732816876967017,-0.6127141109684653},
{-0.018699261954695685,-0.7833690810325454,-0.6212754787407715},
{0.023499599805222947,-0.6049896971131865,-0.7958864461692318},
{-0.2914896085806778,-0.5440806038722018,-0.7867719520798536},
{-0.06219798046436094,-0.5170832105807242,-0.8536722817110118},
{0.2201995496923813,-0.6657986384431765,-0.712898542123972},
{0.22830916793871156,-0.3678147698986339,-0.9014361978973044},
{0.41630911935114023,-0.23050504926840698,-0.8795192660805375},
{0.7404805367248848,-0.2955922304603321,-0.6035841349995145},
{0.614910585776852,0.0170002926625573,-0.7884135726564809},
{0.8789877382065775,0.2630963298317981,-0.3976944522010874},
{0.676679723595869,0.1549953556337516,-0.7197784321624155},
{0.6953089208706825,0.3635046637947549,-0.6200079547530896},
{0.7690634472830052,0.5892719925677741,-0.2475882324109636},
{0.6498962891027839,0.5569968195572405,-0.5170970473842891},
{0.5239085240610303,0.8395136589983487,-0.14400234293717953},
{0.5175119287874393,0.713316442133489,-0.47261089380665483},
{0.329591140709205,0.8687766475975646,-0.3695900655525551},
{0.11630208589661599,0.9890177381922031,-0.09120163571600498},
{0.10709823610657686,0.9306846717496833,-0.34979423893632666},
{0.7621895390203648,0.531892699822792,0.36899493557926344},
{0.7700195394937253,0.046601182520009866,0.6363161467270875},
{0.9824782923819422,0.14949669690697234,0.11129754090800016},
{0.9504056976992366,-0.2824016930032243,0.13030078115552454},
{0.6113777768217116,-0.4594832980856664,0.6442765809719148},
{0.5254109260338115,0.19150398236672042,0.8290172395927479},
{0.564325129957568,0.6998311641756266,0.4379195009895783},
{0.2609907323836367,-0.8968681527773323,-0.35708732005439325},
{0.3160113639729764,-0.9398337970310228,0.12980466785978587},
{0.7021351181661746,-0.712035613351825,0.0034001700637587146},
{-0.17370876035368252,0.5013252824715086,0.8476427477016771},
{-0.31851313097449224,0.106304382488504,0.9419388322288045},
{-0.46400684415142723,0.3835056567501559,0.7985117781355918},
{-0.5293098161415614,0.731913573463081,0.429107957880869},
{-0.3226966229975104,0.8091915318549285,0.4909948617656573},
{-0.2944146386597603,0.949847227578262,-0.10540524087886799},
{-0.24929869991066997,0.8954953300040311,-0.36869807724454084},
{-0.9217330954209473,0.35111260692448154,0.16470591387200828},
{-0.7135325021457259,0.18690851387671503,0.6752307574615195},
{-0.7760262456514494,0.5356181149109746,0.3330112626313565},
{-0.8857301640543641,0.2602088615636734,-0.3844130914107458},
{-0.6683005045670715,0.715600540278612,-0.20320015341617376},
{-0.5912821021616472,-0.15929517820793235,0.7905760696245532},
{-0.9736695976414631,-0.012999594094011522,0.2275928935228479},
{-0.7445098052587034,-0.2970039115672732,-0.5979078744985611},
{-0.6181753971087829,0.010599578145184566,-0.7859687190674594},
{-0.6778847816574758,0.15199658771490826,-0.7192838522587732},
{-0.7043901104322738,0.3845946003297168,-0.5965916239124001},
{-0.6602826546024924,0.5157864504679169,-0.5458856597720743},
{-0.48672104140543976,0.7599328526073427,-0.4308186246917268},
{-0.9451055099811848,-0.30120175601135635,0.12670073866745965},
{-0.7135177311359309,-0.6631164786492442,-0.22620562127953406},
{-0.6321995321725193,-0.643999523440529,0.4307996812083539},
{-0.40639013093550386,-0.39149049276882325,0.8255799510343307},
{-0.15710153096187887,-0.6737065653024685,0.7221070369673631},
{-0.24769604432575795,-0.8766859994363827,0.4123934141297641},
{-0.42351597320614986,-0.8944337342044403,-0.1436054161804088},
{-0.08819753182660726,-0.4211882132127776,0.9026747390008887},
{0.22000339137841735,-0.9654148819851095,-0.1399021566083663},
{0.136897463313507,-0.9058832141395616,0.40079257338242225},
{-0.42258616052986026,-0.23069244494614,-0.8764712960350746},
{-0.215199443710157,-0.6701982675397176,-0.7102981638816196},
{-0.23069158798461342,-0.3669866180769533,-0.9011671395393742},
{0.051598715981928986,-0.5110872817512384,-0.8579786494669587},
{0.2644864652514523,-0.7362623227396761,-0.6228681255392425},
{0.2354090351721582,-0.5448209106278326,-0.8048308900023488},
{0.43618068634680335,-0.5445758867135927,-0.7163682799148325},
{0.22831278244894812,-0.8535477872105879,-0.4683262199774087},
{0.34159829201280995,-0.8861955690332323,-0.3129984350117374},
{0.11649766890496759,-0.9395811991683051,-0.32189355897432675},
{0.05719856519198801,-0.8636783349007001,-0.5007874379046783},
{-0.0595023057590231,-0.9385363689889611,-0.34001317576584633},
{-0.0986028368444246,-0.9795281814311755,-0.17550504935290584},
{0.11990029375607957,-0.9785023973338103,-0.16780041111151084},
{0.35281263091828435,-0.9230330451745365,-0.15340549201492298},
{0.5582911037021432,-0.7836875120389926,-0.27229566100321256},
{0.461501324510702,-0.7460021410292171,-0.4801013778929319},
{0.32398092132529815,-0.7456560896057866,-0.5822657113818553},
{0.12920148711767515,-0.7553086936530963,-0.6425073953026802},
{-0.11040475799557094,-0.7486322630025761,-0.6537281730226876},
{-0.06879735376068043,-0.8681666066137026,-0.49148109554323294},
{-0.22949836827240233,-0.8505939522984985,-0.4730966362948738},
{-0.24110913579823637,-0.9174347622617256,-0.31651199286661885},
{-0.3520137200021108,-0.9229359721305342,-0.15580607266002516},
{-0.24400641745316962,-0.9692254909656229,-0.03260085741382512},
{-0.05619817106028379,-0.9978675249298433,-0.03319891955874416},
{0.06210023256580644,-0.9973037349094808,-0.03910014643032257},
{0.2455948413345361,-0.968779650997144,-0.033899287952934745},
{0.5152304561724231,-0.8565506322043486,-0.02930173207657608},
{0.7286322171857401,-0.6844302627531162,-0.025501127557282968},
{0.7283311623154338,-0.660528261306253,-0.1823078002061013},
{0.6856254988864642,-0.6115227429537236,-0.3949146871503277},
{0.578316514063842,-0.5316151804882213,-0.6188176705908792},
{0.3885028846446278,-0.6153045686533835,-0.6859050928642219},
{0.2342994903991626,-0.608098677386815,-0.7584983502678823},
{0.06719725000881392,-0.5994754669685112,-0.7975673602236606},
{-0.17260197371485422,-0.5981068393908129,-0.7826089491845012},
{-0.39760715500513205,-0.6169111014151558,-0.6792122225339178},
{-0.3077974422138828,-0.7442938149440966,-0.5926950747243935},
{0.23980052276570946,-0.8426018368740066,0.4822010511994374},
{0.46860813276471686,-0.7418128742741505,0.4797083254102319},
{0.374012086395861,-0.6604213418604988,0.6511210413164307},
{0.11119491072540148,-0.7246668327580796,0.6800688739599421},
{0.28509939273894025,-0.5750987750409137,0.7667983667212184},
{0.34141110286960086,-0.3994129891216127,0.850827669365719},
{0.5711059223991232,-0.5057052441905736,0.6466067053463018},
{0.6878329995797513,-0.6160295547268491,0.38391841892798273},
{0.49469290120780113,-0.8093883853600046,0.3164954583227594},
{0.24470229287122636,-0.9274086898601362,0.2829026508102572},
{0.05800107360980887,-0.9513176090519168,0.30270560313257144},
{0.06609933438305414,-0.8656912825326772,0.4961950033414744},
{-0.057198223450769005,-0.8601732834327184,0.506784259525345},
{-0.1297942833366829,-0.7296678624867295,0.6713704301405923},
{-0.06849837695018703,-0.5584867668128387,0.8266804120397022},
{0.1047008993845886,-0.552804748613186,0.8267071014445023},
{0.08889686288506221,-0.3595873103877207,0.9288672208541539},
{0.3711909263487067,-0.2052949816255105,0.9055778634196897},
{0.5615162477076946,-0.2622075870863001,0.7848227091736397},
{0.7094941466974345,-0.32919728413360877,0.6230948594886138},
{0.8150866245382362,-0.39999343616156846,0.4190931227382833},
{0.8769439973840508,-0.4418221667741745,0.18910948786101492},
{0.7288947155324685,-0.664495182427391,0.1647988052129933},
{0.5702089637553659,-0.8094127240680343,0.14040220714004448},
{0.35430602679677414,-0.9282157890848597,0.11350193068426155},
{0.10379851102103903,-0.9879858274449572,0.11449835753284171},
{-0.11819947164954257,-0.9500957530814754,0.28869870951965265},
{-0.120697891426255,-0.9862827697905162,0.11259803292954693},
{-0.34529227589818123,-0.8947799839956345,0.2830936672654941},
{-0.23870671491433715,-0.8498239058827135,0.4699132188447718},
{-0.329677869467409,-0.7255512953762572,0.6040594508500509},
{-0.38879470854002485,-0.5946919062982325,0.7036904228385172},
{-0.2276996106339987,-0.5722990213695102,0.7877986528654553},
{-0.3442878933290929,-0.4071856815672571,0.8459702519791246},
{-0.13489197012002102,-0.36077852349372563,0.9228450646684019},
{0.49460179788080294,-0.019400070519384506,0.8689031584687216},
{0.3315876519057603,0.010599605278049032,0.9433648697463638},
{0.6139810773947876,-0.06079812623062391,0.7869757457812668},
{0.7566882033228646,-0.10979828825802897,0.6444899524799605},
{0.8866100320492694,-0.16150182740351565,0.43340490400423337},
{0.9602462849864314,-0.1916092357877528,0.20300978530748343},
{0.8889708066780552,-0.4577849665885418,-0.012799579668705407},
{0.18979215984781167,0.03329862446223461,0.9812594650087333},
{-0.008199747533660099,0.05469831586478138,0.9984692576048303},
{0.0867035436462447,-0.15790645376865098,0.9836402021966124},
{-0.15819990112509272,-0.17149989281260053,0.9723993922505699},
{-0.1773025505155339,0.029500424366656793,0.9837141508298403},
{-0.18860165404375898,0.2293020109874546,0.9549083745831678},
{-0.0,0.24368833979190474,0.9698535936157916},
{0.18849152843862724,0.22918969930044222,0.9549570804185092},
{0.34459864745296315,0.1929992424794599,0.9186963941237296},
{0.49689153800916097,0.2202962483868347,0.839385705383155},
{0.6413802586194548,0.18979415822571333,0.7433771192044009},
{0.7760834191548728,0.07959829940049977,0.6255866344843298},
{0.9029458843609505,0.06360323208035934,0.42502159802126915},
{0.9777337421736736,0.05120176700346946,0.20350702314855534},
{0.9793931540657795,-0.2018985887337971,-0.005099964351373776},
{0.34751512940049484,0.4222183816773782,0.8372364498822857},
{0.547697565489732,0.44519802109919426,0.7083968511829947},
{0.7622847125333837,0.4340912943863858,0.4800903718841369},
{0.7492860821402851,0.2770948530109075,0.6014888274487943},
{0.8752799825756952,0.2653939305102131,0.4042907539761837},
{0.9389150884867089,0.2744044097142964,0.20770333781945835},
{0.998781852298614,0.049299104243413765,0.0020999618440399373},
{0.3526991358881756,-0.4379989269039436,-0.826897974102445},
{0.15149746471114192,-0.4040932375562538,-0.9020849037354529},
{-0.08720011815624015,-0.4024005452531082,-0.9113012348140098},
{-0.34929585388282147,-0.4412947618622649,-0.8265901884326946},
{-0.5738886686801042,-0.5241896499775408,-0.6291875768139424},
{-0.46100813686542413,-0.7477131972543983,-0.47790843515832143},
{-0.4853864287851741,-0.8075774204509818,-0.3349906337928169},
{-0.5656136512502115,-0.8049194269648076,-0.1794043299757566},
{-0.51430435360478,-0.8573072571366477,-0.022700192157939933},
{0.4074930217417535,-0.23299600997749345,-0.8829848790134194},
{0.3637889246147826,0.014299564656380954,-0.9313716448219035},
{0.5264079330273265,-0.023300351138937518,-0.8499128082825319},
{0.6479191722119629,-0.06960205955541382,-0.7585224450112267},
{0.6788096086180155,0.20330287777260247,-0.7056099879800704},
{0.5304056329377329,0.24220257220497532,-0.8124086278254415},
{0.3744851238739253,0.20019204752886474,-0.9053640351280426},
{0.20160629727104443,0.03240101206141786,-0.9789305773741339},
{0.18189767627202832,-0.19549750253535753,-0.9636876889684095},
{0.5854107950745927,-0.2860052739858788,-0.7586139889709361},
{0.7829231044017214,-0.12160358857484904,-0.6101180048479885},
{0.8062867366922714,0.07999868403247143,-0.5860903588928937},
{0.7863126675991132,0.2853045962940697,-0.5480088284933411},
{0.7794066873380662,0.4462038284452722,-0.4398037735325655},
{0.5916031325468802,0.472302500848363,-0.6534034597804793},
{0.3794927707315757,0.3860926450051683,-0.8407839832176781},
{0.20419966409182883,0.24139960289797982,-0.9486984393923507},
{-0.0,0.05299970956238739,-0.9985945277169821},
{0.005299911227230409,-0.17539706212381392,-0.984483510039309},
{-0.1453048285596809,-0.32081066071538633,0.9359311015072632},
{0.5657250791486503,-0.11710519138820391,0.8162361845521097},
{0.48381252848763995,0.181604702714666,0.8561221695706254},
{-0.48099297755379117,0.33259514414634295,0.8111881567393668},
{-0.020998936955724246,0.45867678007574814,0.8883550281650199},
{0.6008734990587232,-0.2671882159235993,0.7533667734911667},
{-0.12369375980722261,-0.23598809470092588,0.9638513749246715},
{-0.7283274621046978,0.11010415155530308,0.6763255013338008},
{-0.6360777821910953,0.22669208178387254,0.7375742369818455},
{0.5701947599342343,0.7002935643317156,-0.42949605294941},
{0.6905836264563228,0.5264875171289515,-0.49588824262914927},
{0.24609425868791648,0.6320852536230476,-0.734782857715892},
{0.23238638604234887,0.9045470086657005,-0.3574790577028387},
{-0.04009992401071599,0.7892985042807515,-0.6126988389368003},
{-0.1730973014341058,0.6670896001541997,-0.724588703750162},
{0.1062984889777187,0.45429354226319474,-0.8844874271005849},
{0.44999536282167907,0.34189647677496016,-0.8249914985064116},
{0.5664910665063212,0.44249302194006557,-0.6951890369553302},
{0.7982881175698042,0.3247951654599429,-0.507192450496561},
{0.9675910353105867,0.2425977523422368,-0.07009935053252596},
{0.8929181710696737,0.4485091272536103,0.03920079774435122},
{0.6255171706820061,0.7694211208996571,0.1293035494311485},
{0.32389026076628596,0.9276721053191832,0.18579441324598928},
{-0.2042033407939833,0.9758159644797694,0.07800127611131585},
{-0.2760964204331135,0.8675887517847493,-0.41359463778028155},
{-0.44458181475279374,0.6896717895524108,-0.5715766201365202},
{-0.3874013927105102,0.5501019776201643,-0.7398026595953419},
{-0.28389487574373884,0.3466937422344285,-0.8939838637368881},
{0.12640512583178085,0.2635106855749545,-0.9563387803238291},
{0.526089870237072,0.10689794169994865,-0.8436837550256939},
{0.7273948318780793,0.20559853922756818,-0.6546953484060742},
{0.9836499777522897,9.999491488790177e-05,-0.1800908417131111},
{-0.4349129301536231,0.9003267671126853,0.016200481647479177},
{-0.680198935489499,0.7121988854096165,-0.17349972847313738},
{-0.8024797857887908,0.5226868336844872,-0.2877927505919177},
{-0.58641059653522,0.348706301179794,-0.7311132113350943},
{-0.6399852901071584,0.18859566517845325,-0.7448828790637849},
{-0.3205933958440677,0.15779674942044256,-0.9339807601945079},
{0.08919792305054236,0.0587986308898194,-0.9942768485331196},
{0.47802112422022924,-0.08790388455848985,-0.8739386202009588},
{0.7286131515860803,-0.2405043411425368,-0.6413115757784151},
{0.7655802635952035,-0.031199195695102336,-0.6425834344125885},
{0.9437212009349212,-0.22830512893233287,-0.23930537605566035},
{0.5744018926573544,-0.397101308450967,0.7158023585726572},
{-0.3577117080958121,-0.9270303421996584,0.11250368230578378},
{-0.5501061694752862,-0.7684086177509724,0.3270036673666944},
{-0.46378695849408813,-0.7355793158004555,0.49378611492966956},
{-0.5792243945490755,-0.505221277842184,0.6397269426675477},
{-0.568007350062665,-0.810610489367599,0.14240184269176673},
{-0.7314132679570222,-0.6624120162629634,0.16200293875996388},
{-0.6916874598200291,-0.6115889119935375,0.384093036456373},
{-0.815722265443107,-0.39941090206936,0.41841142069559395},
{-0.7108096635230639,-0.32440441030793743,0.6241084848125269},
{-0.5595793155328949,-0.2518906890327667,0.7895708140542778},
{-0.3862034584674559,-0.20340182147146693,0.8997080569217248},
{-0.32861042368796173,0.008200260116376404,0.9444299577933994},
{-0.49452246419316553,0.05930269388605605,0.8671393907015043},
{-0.6173964530675656,-0.07879954729790115,0.7826955034272491},
{-0.6445994134148006,0.11709989343914545,0.7554993124959384},
{-0.5678768708460661,0.29438800982053503,0.7686686927617028},
{-0.35350607505410014,0.20930359691321973,0.9117156679683822},
{-0.7261992229672471,-0.3496996258216006,-0.5918993666680165},
{-0.5857025683113931,-0.28570125280274034,-0.7585033260443771},
{-0.8131832933208564,-0.4116915418841571,-0.41139154804746714},
{-0.6803948766458682,-0.6218953171458927,-0.387697080651974},
{-0.7194722181166858,-0.6666742568705968,-0.19469248209495305},
{-0.7321017497252728,-0.680901627356834,-0.020000047800171363},
{-0.19058919771040198,-0.18878929972572872,-0.9633453991301221},
{-0.39829597324806554,-0.23669760699928977,-0.8861910406538682},
{-0.5203205400587363,-0.024000947456101616,-0.8536336978553475},
{-0.36180184519411573,0.02160011016084273,-0.9320047532363623},
{-0.6475924296887452,-0.07889907767517294,-0.7578911403043546},
{-0.784388983334093,-0.12669822053598878,-0.607191472055662},
{-0.8938994010876018,-0.17019988596611457,-0.4146997221512792},
{-0.958943623337661,-0.1950088711553279,-0.20590936703016416},
{-0.8711048564231119,-0.4458024853557838,-0.206001148459604},
{-0.8889708066780552,-0.4577849665885418,-0.012799579668705407},
{-0.5315008583745794,0.23640038178692488,-0.8134013136441823},
{-0.6770234931228242,0.11560401152880127,-0.7268252212727748},
{-0.6742788751737561,0.31039027562499466,-0.6700790067535725},
{-0.5749986027550931,0.4730988503711905,-0.6674983779809124},
{-0.7813874627387398,0.47029245421810767,-0.4101934184993999},
{-0.7865164147688661,0.2855059585715337,-0.5476114287697789},
{-0.8058938510533745,0.08589934459050115,-0.5857955303971545},
{-0.3854918835538368,0.28349403109601223,-0.8780815121883893},
{-0.37961297349505757,0.5282180521604042,-0.7595259572431408},
{-0.41159491066039433,0.6735916710904801,-0.6138924092672888},
{-0.6407072624579802,0.6228070595580304,-0.4490050895015344},
{-0.7524116888063792,0.6349098634013426,-0.17540272490249723},
{-0.8861567388839858,0.4571776811303976,-0.07559630947825471},
{-0.8909634177930827,0.28238840537010834,-0.35558539996321015},
{-0.9151002699546195,0.06220001834900812,-0.398400117528052},
{-0.5878743839318181,-0.11549496741643986,0.8006651117778648},
{-0.6052091266224447,-0.26740403248321504,0.7498113072397705},
{0.14559590808450412,-0.3225909337092103,0.9352737145016257},
{-0.5121014185228939,0.04390012160350526,0.8578023761158727},
{0.27649905575733685,0.39229866030236255,0.8772970040358467},
{0.5364076036316726,0.33870480117458523,0.7730109575079845},
{0.6635977404535406,0.17679939799907474,0.7268975249181414},
{0.7311865865051047,0.1121979417476378,0.6728876559891754},
{0.1269006122969315,-0.23570113726073091,0.9635046489211466},
{-0.5755779529087627,-0.3897850695688597,0.7188724641176328},
{-0.5337055799210072,-0.48380505820832553,0.693607251701725},
{0.782481647108198,-0.07209830895399498,0.6184854935928696},
{-0.21869758231159125,0.4980944935958098,0.8390907239033206},
{-0.30180127058602374,0.40150169032567445,0.8647036404099893},
{-0.8442061880540377,0.3917028711925688,0.3659026820764895},
{-0.7396095669116224,0.5639072941880258,-0.36740475241120885},
{-0.323991989397092,0.8815782032483838,-0.34329151222228915},
{-0.5132899139522853,0.6259876994625572,-0.5870884638250277},
{-0.5796982667047738,0.4357986969638441,-0.6884979413942328},
{-0.20280438366412987,0.6462139680658812,-0.7357159026711062},
{0.07319790620383913,0.8895745540838155,-0.45088710255889436},
{0.15039880734218666,0.9846921914218829,0.08809930137531012},
{-0.20620868775502652,0.9643406285265377,0.16590698980872404},
{-0.6945763986949518,0.7097758822252761,0.11739601095132067},
{-0.8485688241540903,0.5243807346057093,0.07039741364653307},
{-0.9665663399133086,0.23999164243657567,-0.09029685546676161},
{-0.8027455756948892,0.3209782384131284,-0.5025659271851661},
{-0.5863733440736539,0.29358665385406685,-0.7549656800402603},
{-0.10149937324330534,0.46909710333433036,-0.8772945827226775},
{0.1727022494614489,0.6629086344411957,-0.7285094888978897},
{0.25029244753934154,0.7998758641099453,-0.5454835402825042},
{0.4592128719172022,0.8879248888834579,-0.02670074843246799},
{-0.20119188307721256,0.400883826668263,0.8937639418211362},
{-0.9697680175781617,0.03439886554412122,-0.2415920324261537},
{-0.7793915943069829,-0.0260997185160537,-0.625993248699219},
{-0.6243923168998106,0.06269922849074011,-0.7785904195038317},
{-0.42491042530517886,0.1674041073101599,-0.8896218271392966},
{-0.11810416029232072,0.2737096415919406,-0.9545336240391206},
{0.294196934483914,0.3603962446906954,-0.8851907763601653},
{0.3926048663674781,0.5453067591191691,-0.7406091799076778},
{0.44457614023881287,0.6862631692440335,-0.5756691046682064},
{0.6703999329600101,0.7251999274800108,-0.15699998430000237},
{0.8001683899721189,0.5218793835621706,-0.2955883230139444},
{0.7731353872165279,-0.003900178515256058,0.6342290293270236},
{0.8789851233026812,0.3096947584605692,-0.36259386315079883},
{0.9302794875634464,0.11759740700576296,-0.3474923378784237},
{0.5304096827171378,0.8107147997337549,-0.24780452371287093},
{0.10610397207654342,0.8306310952570872,0.5466204631200625},
{-0.9431537771660438,-0.23828832177551762,-0.23168864521773994},
{-0.8737130970574881,-0.4352065237946879,-0.2173032574002428},
{-0.735873545821533,-0.2489910489326834,-0.6296773635056656},
{-0.5342285472651551,-0.12700678678898294,-0.8357446592090791},
{-0.1585012632601023,0.03850030684866838,-0.9866078632960058},
{0.3145030223885678,0.15980153570013717,-0.9357089922066228},
{0.6387285581922695,0.18830841945765514,-0.7460333558970299},
{0.5837081632157441,0.35030489904827,-0.7325102442273987},
{0.8369833734904267,0.3846923581622069,0.3891922687723705},
{0.5343933174533476,-0.47989399896306423,0.6957912991842052},
{0.29760766349600376,0.4007103184235508,0.8665223132368525},
{0.19540252363988933,0.5265067998792309,0.8274106860780166},
{-0.784316702202012,-0.07660163124910636,0.6156131096207555},
{0.437986851832059,0.49598511075045953,-0.7497774920175293},
{0.39621373102477714,0.8995311737930011,-0.1840063768514866},
{0.06990265285601478,0.7060267942252709,-0.7047267448874623},
{-0.21540408625427473,0.7477141842726147,-0.6281119153960536},
{0.23359580465702218,0.9713825541259904,0.04299922774080459},
{-0.43929287912014375,0.8611860402874295,-0.25569585520378046},
{-0.08170221661120539,0.8547231889546787,0.5126139074039643},
{0.21819847261603753,0.9489933570697506,0.2275984068167284},
{-0.00589972242458973,0.9772540212799226,0.21199002610390216},
{-0.01730065908116178,0.9996380819381109,0.020600784801845823},
{-0.18799288554386734,0.9539638979194119,0.23369115612554148},
{-0.4162825456387843,0.8775632045462338,0.237890025480343},
{-0.20269850206360457,0.8917934096710537,0.4044970107781355},
{-0.3994853451489149,0.8275696411645607,0.39438553223212025},
{-0.5694197478192875,0.7112246656991171,0.4122142958396739},
{-0.7268280124914126,0.5908227707483854,0.35021349748829483},
{-0.7603042044938764,0.6161034070612617,0.20580113808344044},
{-0.7826311649934973,0.6212247376615903,0.03960157696619282},
{-0.979518816737206,0.16220311595178644,-0.11930229181903898},
{0.631210260406175,0.5578090672600831,0.5389087600330922},
{0.3999067764777416,0.6059102672364682,0.6877116533727005},
{0.7510938973868754,0.6001951234344329,0.27499776565223105},
{0.8701931429050509,0.4473964745296711,0.2063983735872242},
{0.39279342272920414,0.826186165628484,0.4038932368643726},
{0.5805991407139076,0.678398995970229,0.45019933370547915},
{0.3890897943085412,0.7157812253046872,0.5798847898214419},
{0.20029868804788992,0.779894891705189,0.5929961158881614},
{0.20009660839123142,0.894184843695348,0.40049321169759217},
{0.4089047862585349,0.8787102853640857,0.24630288299211822},
{0.78311949208674,0.6206154473107277,0.03950098319170761},
{0.8907802560744337,0.4536899440738331,0.02599942372915949},
{0.9618055544431154,0.27360158005368723,0.008500049087925225},
{0.8638945272455049,0.47549698773612403,-0.16609894776649883},
{0.9415145229735261,0.28210435149318297,-0.1843028428932776},
{0.9795986824406583,0.0516999304636403,-0.194199738801527},
{0.9589516652594382,-0.1949901717680818,-0.20588962239511818},
{0.8711048564231119,-0.4458024853557838,-0.206001148459604},
{0.7309253964441068,0.6649231031545857,-0.15370534058483953},
{0.6850914192837099,0.3551955512035816,-0.6359920342496562},
{0.8783959549959409,0.2756987304102697,-0.3903982022204182},
{0.9817008148120144,0.15880013180416408,-0.10510008723310861},
{0.7388104431594217,0.5777081659626392,-0.34700490494899744},
{0.8884891827100504,0.2766966312390219,-0.3660955428138992},
{0.9151002699546195,0.06220001834900812,-0.398400117528052},
{0.8938994010876018,-0.17019988596611457,-0.4146997221512792},
{0.8139889420353331,-0.41089441803724613,-0.41059442211266317},
{0.2386963360393625,0.8184874363142782,-0.5225919782746997},
{0.41532112169272917,0.6764344009462124,-0.6082309323706185},
{0.19509236325890744,0.7117721382249632,-0.6747735865049244},
{-0.004099945430089486,0.6758910039506058,-0.7369901907258418},
{0.19679763450664975,0.5701931463195716,-0.7975904130208529},
{0.38068954831192464,0.5280855016115772,-0.759079159767749},
{0.5949046135031666,0.6178047910947325,-0.5142039876673866},
{0.5782045851805409,0.7407058738208693,-0.34210271288526983},
{0.41920631119852303,0.8155122776297603,-0.39900600708065526},
{0.22980364356565336,0.9176145488940101,-0.3243051418987875},
{-0.0010999421170690938,0.9269512204755,-0.3751802566584764},
{-0.0007999782648858107,0.8396771862807689,-0.5430852445743547},
{-0.2202030421260406,0.8112112069602367,-0.5417074837405821},
{-0.1916054991567398,0.7048202286308467,-0.6830196029439107},
{-0.20080294780891092,0.49900732548130755,-0.8430123755125095},
{-0.0003999941241294745,0.44789342049397907,-0.8940868659604078},
{0.19669295655133656,0.4247847887290685,-0.8836683564027256},
{-0.3555920614958397,0.5326881078707362,-0.767982854974142},
{-0.695293815389018,0.3602967951742603,-0.6218944682733069},
{-0.07329774319722991,0.5869819271046923,-0.806275175169529},
{0.1595070096895646,0.7815343452814717,-0.6031265049766545},
{-0.2109912440450544,0.9609601209824515,-0.17899257196239213},
{-0.7641067050657556,0.4410038698259367,0.47080413132437865},
{-0.875003403769861,0.2681010429150854,0.4031015680681497},
{-0.7468132597871423,0.2692047797732977,0.6081107971030547},
{-0.7725161264424609,0.08980187463369967,0.6286131224358977},
{-0.9029132413197767,0.06350093124798517,0.42510623422863775},
{-0.977728730980896,0.051301507516947904,0.2035059801110896},
{-0.9383260201413128,0.27980775917674444,0.20310563219727232},
{-0.869657900880003,0.4527780815435959,0.1966904784444022},
{-0.604900940621694,0.571800889151074,0.5542008617830101},
{-0.5515056750225942,0.4566046984865213,0.6981071835598786},
{-0.3585143785074808,0.4123165362862883,0.8375335899582014},
{-0.1753016364484144,0.3968037041798678,0.9010084109527745},
{-0.18679932658964143,0.6035978240337665,0.7750972057796096},
{9.999939750544504e-05,0.4249974393981414,0.9051945462192884},
{0.17839752653544175,0.3990944665935807,0.8993875300783425},
{-0.1073995655696359,-0.8801964396126026,0.46229813000784614},
{-0.3907189620513537,0.7229350848910253,0.5698276544071189},
{-0.1971953758226548,0.7784817448171236,0.5958860266365112},
{-0.00060002620671688,0.7925346147052124,0.6098266347599225},
{0.0009000030105151052,0.6249020903009881,0.780702611454603},
{-0.394687115649411,0.6141799504227723,0.6833776914993855},
{-0.4162910706523008,0.8159824973631454,-0.4010913966818108},
{-0.24110015068764126,0.9135005709380352,-0.32770020481269196},
{-0.5679265256278336,0.7483349518001549,-0.3427160069249139},
{-0.203091533290462,0.2455897615762554,-0.9478604845200833},
{-0.004199904978224789,0.26449401589058497,-0.9643781811904731},
{0.16590129818273744,-0.26270205565162824,0.9505074377498007},
{-0.5287883826468486,-0.17229621469374434,0.8310817413347121},
{-0.34219480381135586,-0.6236905293312176,0.7027893282250757},
{0.19479672257271385,-0.7849867927083182,0.5880901054672125},
{0.14509530043932692,-0.9638687807957768,0.22339276442553846},
{-0.3799012118867989,-0.8544027255490417,0.35450113086041113},
{-0.7977626934999373,-0.3886818237195107,0.46097844284716866},
{-0.6217128726982952,0.09290192355424098,0.7777161027786137},
{-0.06429982735519532,0.35879903662588,0.9311974997380698},
{0.1756938069024581,0.06239780051629701,0.9824653687061188},
{0.6231124935307442,-0.2225044612591728,0.7498150339421473},
{0.6662804815991831,-0.6416812022245172,0.37988887131851967},
{0.8025958666419302,-0.5822970011781659,-0.12949933308015196},
{0.9854958559986383,-0.1053995567957955,0.13299944073852754},
{0.9515909694445498,0.13709869893952056,-0.27509738933816275},
{0.8879173545142927,0.3735073002715264,0.26850524798635833},
{0.6347267257314422,0.7629321239333815,0.12270516660981244},
{0.7200144796367797,0.6217125027641471,-0.30830620010002663},
{0.06380072797045924,0.9843112310552199,-0.16450187697712454},
{-0.05460151630516198,0.9291258021817949,0.3657101559120465},
{-0.6488575563711296,0.7510508716140475,0.1220920136121358},
{-0.6139956375764924,0.5485961022385404,0.5674959679554715},
{-0.9224452654997943,0.10730526559857756,0.37091820140272524},
{0.35500919485722177,0.4928127640158842,0.7944205757593717},
{0.6052021726796999,0.09230033135878436,0.790702838628286},
{0.036198775416141166,-0.7460747607177601,0.6648775075743718},
{0.10589612109612508,-0.14489469260461307,0.9837639653859098},
{-0.3734946030419788,-0.17389748719946482,0.9111868334453843},
{-0.5210675228734174,-0.7330543101487282,0.43717275187153726},
{-0.8011345056062508,-0.3884167294688151,0.4553196110379802},
{-0.6171074207613522,0.3335040104098379,0.7127085703720883},
{-0.13829899180402463,0.12869906178725937,0.9819928412982805},
{0.6109276237170236,0.10240463033004292,0.7850354961824579},
{0.5867079235440115,-0.37390504962179294,0.7183097008380152},
{0.41267673806789423,-0.82765334649575,0.38037855866495507},
{-0.18149993738253242,-0.9669996663851728,0.17879993831403193},
{-0.7896147777788505,-0.5975111825264224,-0.1396026126873449},
{-0.9665975593442441,-0.16249958968905406,0.19819949954689547},
{-0.972252945475758,0.1784097155655989,0.15130823971454657},
{-0.648278496958878,0.7422753791340045,0.16959437464788787},
{-0.14910486238884507,0.4869158785857053,0.8606280655388333},
{0.5624000646760112,0.41010004716150816,0.7180000825700142},
{0.9011213613350587,0.15130358669403438,0.40630963168397993},
{0.7769878751988104,-0.4113935802532698,0.47649256439154847},
{0.40330969164833685,0.794719097329366,0.45361090040090657},
{-0.12549442691624826,0.9438580841932009,0.30558642920801166},
{-0.06699665527547599,0.9881506678093339,-0.1380931058737796},
{0.638511049529319,0.7545130569614271,0.1517026252366448},
{-0.7278051965476551,0.6158043968590904,-0.3018021548750787},
{-0.9466434045951739,0.09050414971039851,-0.3093141823804007},
{0.44360641903132536,0.30170436569375764,-0.8439122114980512},
{0.4605218707029719,-0.035401681265765914,-0.8869421218815761},
{0.6902691836201805,0.3435846610052065,-0.6367715719677401},
{0.44332065257366143,-0.28051306800566667,-0.8513396605819038},
{0.8571858651216254,0.10829821417717223,-0.503491697490362},
{0.631219208292767,-0.4423134598033759,-0.6371193878379624},
{0.9700479437738585,0.07639590032401071,-0.23058762584707945},
{0.6703074438054955,-0.7309081167797056,-0.12830142479523357},
{0.9995620773341652,0.028598914977748222,0.007599711672408619},
{0.6857933135477892,-0.5918942290593999,0.4234958709353875},
{0.5989325648488503,0.6146334185274728,0.513327910397253},
{0.5489016412183609,0.5084015201228177,0.6635019838738976},
{0.5120929306058891,0.7653894338717976,0.3897946189224284},
{0.5795795267148218,0.755973295714985,0.3042892511720502},
{0.6088914664458962,0.7878889578136338,-0.09209870924563482},
{0.6465044285705035,0.6961047683339947,0.312202138591974},
{0.7131056656470204,0.6911054908549374,-0.11770093513764451},
{0.5493851063716466,-0.36449011880681687,0.7518796168198782},
{0.5118715330562617,0.004099771997520361,0.8590522251389614},
{0.9386064717139339,0.12690087498454955,0.320802211938877},
{0.7952052722284324,0.3321022018448974,0.5073033634324494},
{0.49710317401389914,0.30610195446721894,0.8119051840311501},
{0.3302953197484785,0.1595977385160677,0.9302868179291842},
{0.22899123438331853,-0.05339795596536773,0.9719627939763563},
{0.43840104997177204,-0.08960021459277093,0.8943021418561946},
{0.6390935515785967,-0.08959909594968278,0.7638922923656549},
{0.5543013663545521,-0.36970091131386956,0.7457018381572966},
{0.34721061612688464,-0.28750879071566626,0.8926272924967086},
{0.005499963892855564,-0.04879967963115483,0.9987934429425704},
{-0.005799989676027565,0.21039962548899996,0.9775982598766462},
{0.2717971977853362,0.3946959307059315,0.8776909510529418},
{0.5258044036303207,0.17690148155611207,0.8320069680875366},
{0.7127958052090295,0.13479920670900278,0.6882959493902568},
{0.8424960992520906,-0.09699955089311903,0.529897546580039},
{0.737408240583133,-0.29830333355837885,0.6060067721635186},
{0.5697054093785432,-0.3806036138484703,0.728406916256505},
{0.40899974437523967,-0.5599996500003283,0.7204995496879223},
{0.07230222188141815,-0.5290162569193666,0.8455259834127116},
{-0.05839771173049788,-0.3233873283158051,0.9444629919427269},
{-0.2596078454676368,-0.030600924773920214,0.9652291696662676},
{-0.26858507245649776,0.23018720655058,0.9353480148019658},
{-0.24170154931189666,0.4277027415833604,0.8710055831636823},
{0.0077997744337850155,0.4333874666156956,0.9011739384265457},
{0.24070895092876352,0.6015223680251403,0.7617283253944295},
{0.4839892894355358,0.5550877160447644,0.6764850295519421},
{0.5488743626772651,0.39148171431617645,0.7385655024110548},
{0.8484131674745398,0.1108017196560337,0.5176080333390166},
{0.9450557552089663,-0.08700513301923817,0.3151185909696776},
{0.9116046947762672,-0.2417012447646158,0.33250171238822823},
{0.762695442908343,-0.3094981507540739,0.5678966068279113},
{0.9744074591176495,0.1473011275944476,0.16980129983392536},
{0.9857952829808563,-0.16769919756125948,0.009199955978315964},
{0.517089862552616,-0.06059881197193682,-0.8537832617432286},
{0.682297854176623,0.06699978928599405,-0.727997710450801},
{0.6295060590249772,-0.25050241109731025,-0.7355070792897075},
{0.36040680995101165,-0.06370120364561445,-0.9306175841853814},
{0.3119008327763353,-0.2973007937941792,-0.9024024094176497},
{0.49841081313988794,-0.5186112513931498,-0.6947150720069826},
{0.6884979035270757,-0.45219862305728925,-0.5669982734928859},
{0.834361248991665,-0.2907864947348708,-0.4682782513216643},
{0.8351764107754118,-0.05129855109288628,-0.5475845336932657},
{0.6063846556304314,0.2633933349159889,-0.7502810143791436},
{0.4622138180886407,0.15210454723341033,-0.8736261174431773},
{0.26160676916272924,0.16350423072670578,-0.951224613255306},
{0.055899647274338535,-0.07659951665857481,-0.9954937184544547},
{0.00040000661616414754,-0.320005292931318,-0.9474156703847834},
{0.277802954450131,-0.511705442016314,-0.8130086463929318},
{0.36179513569710064,-0.7257902418157978,-0.5850921334891475},
{0.526496827866168,-0.45779724177992737,-0.7163956837290082},
{0.7511191012016184,-0.3548090229081803,-0.5567141574210371},
{0.914992057903406,-0.28499752623220836,-0.2855975210242762},
{0.9521857696900072,-0.10719839793191428,-0.2860957243313496},
{0.44941258148133034,0.7722216186468253,-0.4491125730824776},
{0.4336248886147436,0.5392309500485926,-0.7219414370179507},
{0.3851039550379275,0.6152063182013321,-0.6879070648418341},
{0.5043069040087742,0.7402101335460929,-0.4447060880680188},
{0.36199320002160584,0.6353880643473159,-0.6820871871125341},
{0.17109984686570562,0.6142994502022382,-0.7702993105824256},
{0.4263973115734258,0.47739699002146685,-0.768295155914313},
{0.26249862188585266,0.3650980832400944,-0.8931953107369278},
{-0.0014999921250620151,0.3890979572410867,-0.9211951637380855},
{-0.048997852716156046,0.16689268608829477,-0.9847568439769484},
{-0.1845035554177697,-0.058001117692307,-0.9811189063434896},
{-0.2921052783900712,-0.3039054916218509,-0.9068163863201526},
{-0.07869889428830282,-0.537492448284152,-0.8395882038686029},
{0.09119921477814112,-0.7676933901883656,-0.6342945387475318},
{-0.10340251167751335,-0.6469157137735337,-0.7555183517636492},
{0.2438012372944189,-0.5825029562100043,-0.7754039351849566},
{0.23970647935370656,0.6651179783819368,0.7072191163910776},
{-0.0113002905342045,0.6492166915757134,0.7605195532090727},
{-0.02879890278270557,0.5773780023171596,0.8159689121766578},
{-0.22859423264026482,0.6644832352994574,0.7114820495343326},
{-0.3464903365192698,0.5676841675093491,0.7467791726193095},
{-0.4566030546846538,0.6909046221673835,0.5605037497826291},
{-0.41339750101965944,0.690295827174337,0.5937964105115476},
{-0.5736203466745512,0.759126926709644,0.30771091469972},
{-0.6382742589181962,0.7023716739215746,0.3150872927857178},
{-0.6299872460373047,0.7742843247725159,-0.05999878533688616},
{-0.7079107851029671,0.6966106129435329,-0.11660177644159624},
{0.4354911138944806,0.6665863984433082,0.6049876553528375},
{-0.0030000424659016593,0.6013085115822225,-0.799011310085142},
{0.020999516491699108,0.6410852391822999,-0.767182335830074},
{0.473912004343107,0.24180612502672139,-0.8467214477259098},
{-0.038202473117148444,0.5485355105957048,-0.8352540719225755},
{-0.2870036664952593,0.6607084406042434,-0.6936088609097976},
{-0.26918951661840895,0.6522745976604315,-0.7085724051850096},
{-0.20250051637697514,0.4849012364997296,-0.8508021695482985},
{-0.008400055608552193,-0.05580036939966815,-0.9984066094736321},
{-0.15160113625477437,-0.3111023317207144,-0.9382070318880561},
{0.45198472091475983,0.32688894970582966,-0.8299719432726784},
{0.27270196618826437,0.33950244782147326,-0.900206490512195},
{0.35638952942943575,0.5903826548123987,-0.7241787239416312},
{0.46370051238934934,0.8079008927309796,-0.3637004018891662},
{0.6144731266054491,0.7708662869001475,-0.16789265737519102},
{0.48088127965616734,0.8767658681691153,0.005899770326411702},
{0.451101567580671,0.7922027529093495,0.4110014282324446},
{0.4370143933060692,0.6532215142048614,0.6183203647165735},
{0.17959622672291442,0.40149156475083597,0.8980811315136383},
{-0.09510225918100058,0.06680158689054509,0.9932235943067275},
{-0.31909691913411864,-0.27649733043116204,0.9064912478692526},
{-0.5706767311306725,-0.18149259979011226,0.8008673452997295},
{-0.2521851820340427,0.3007823265497227,0.9197459573152755},
{0.4909305932931613,0.8266515143942292,0.27501713822696955},
{0.6500210285204145,0.48871581021219473,0.5819188253785064},
{0.621885479143591,0.7349828383510844,0.27029368871605186},
{0.6876271996318328,0.6877272035875674,0.23280920895039364},
{0.799999596000306,0.5998996970507294,-0.010999994445004206},
{0.7098266438431244,0.6240234231587907,-0.326712263374963},
{0.5150236375522806,0.5100234080614818,-0.6889316192422643},
{-0.5282726546737779,-0.5957691608075656,0.6049686846065411},
{-0.5083985231044355,-0.7942976925685545,0.3325990338012102},
{-0.5948099185380882,-0.8019133720169684,0.05600093382335732},
{-0.40929248136617535,-0.8854837338132134,-0.21999595871135738},
{-0.5252032510181858,-0.781704838767928,-0.33630208171632875},
{-0.37630135092427475,-0.6448023148444655,-0.6653023884398617},
{-0.42189212967573064,0.11989776332808748,0.898683235220619},
{-0.01970121018400447,-0.6159378351435713,0.7875483766448488},
{-0.38939235824995333,-0.7299856741717152,0.5616889769619897},
{-0.7937322380895383,0.023200942325409205,0.6078246873010222},
{-0.9657645184633754,0.02719900072706959,0.2579905216023513},
{-0.6066163879630843,-0.7596205214255832,0.23450633527422227},
{-0.6820247920517948,-0.7313265842045125,-0.0019000690687659971},
{-0.9997978954276452,0.020099957689633595,-0.0003999991580026586},
{-0.9989912838390725,-0.043799617850001374,0.00989991362363045},
{-0.9389534760078673,-0.025698726659640243,0.3430830006584657},
{-0.6253009598377101,-0.7690011804177179,0.13280020384846936},
{-0.6871100971570672,-0.7132104807050215,-0.13860203677189567},
{0.3756168862366897,-0.28071261971948563,0.8832397069335579},
{0.2496992084547638,-0.48639845811933163,0.8372973457716208},
{0.0045001534353471115,0.12900439847995054,0.9916338103311547},
{-0.397697766933308,0.0062999646257979386,0.9174948482808902},
{-0.528504391889745,-0.6528054248356208,0.5427045098932158},
{0.993226896948559,-0.11420309266162448,0.02140057953554084},
{0.9383974616382993,-0.10219972355012169,0.330099107083123},
{0.729799401564736,-0.2635997838482658,0.6307994827446362},
{0.7546685045671792,-0.08729635676257419,0.6502728614284307},
{0.4243952616533553,0.06839923632678958,0.9028899192903264},
{0.42540613227359536,0.09490136801307993,0.9000129737805262},
{-0.051999569185353936,0.045899619723225885,0.9975917349867133},
{0.1025013750651698,-0.7576101634085137,0.6446086474830093},
{-0.4026125596947026,-0.7334228794835939,-0.5477170863010149},
{-0.4138916601670706,-0.008999818655481119,-0.9102816580093848},
{-0.7726697196670177,0.012999490559947237,-0.6346751275691163},
{-0.39010090113412244,0.02610006029120891,-0.9204021261313671},
{0.003400167870431747,-0.0457022563760973,-0.9989493193453741},
{0.41620834506097854,-0.09850197498439786,-0.9039181237400733},
{0.7557164974712117,-0.08610187962454852,-0.6492141725000802},
{0.9513339204156593,-0.0660023533558641,-0.3010107327290166},
{-0.591580075918559,-0.773573946468217,-0.2271923482905622},
{-0.020900700812247548,-0.9907332198418013,-0.1342044999523264},
{-0.00619979897477731,-0.9120704265958686,-0.4099867063965641},
{0.40650510167103915,-0.7153089771839959,-0.5684071335542894},
{0.5849284340622865,-0.7799379137035001,-0.22261082137504692},
{0.8763052140315352,-0.47960285364546884,0.04550027072741624},
{-0.020199601667782625,-0.8973823037954519,0.44079130768111796},
{0.06879692828572653,-0.7374670728302808,0.6718700016741229},
{-0.28760617497086566,-0.7181154181035417,0.6337136059771821},
{-0.300294839477525,-0.5297908956216875,0.7931863692093667},
{0.0986020558742977,-0.6705139803622374,-0.7353153314844939},
{0.6875766881075779,-0.7170756879609426,-0.11419612824590662},
{0.5692250635313331,-0.6559288811844719,0.49572182711258217},
{0.6068684740016421,-0.7809594302113734,0.1476923275828679},
{0.6079882507405805,-0.6151881116046137,-0.501890301063647},
{-0.46750025712521215,-0.6787003732853079,-0.5664003115202569},
{0.9420230421654204,-0.05620137470243804,0.3308080916648844},
{0.996920307473497,-0.07770158279736254,-0.010600215928597721},
{0.9531724298861924,-0.017999479372588608,-0.3018912679213612},
{0.42477636185317597,0.02849841410738116,-0.9048496465182179},
{-0.03789922496877401,0.001999959101254565,-0.9992795649418433},
{-0.7820058767962463,-0.01440010821721988,-0.6231046826492852},
{-0.9454811000217139,-0.015799684167470206,-0.3252934974479783},
{-0.9606214509165011,0.02530056496792367,-0.2767061789179636},
{0.7704993104034259,0.5626994963841762,0.2994997319478599},
{0.674404285852855,0.5408034368167615,0.5027031946889534},
{0.4997977883996795,0.1558993101470789,0.8519962299250238},
{0.8846459762461093,-0.33691751005800835,0.32231675123685394},
{-0.014299261176262044,-0.5626709275442413,0.8265572928879863},
{0.4834935840827086,0.09849869293101716,0.8697884579837435},
{0.8166694203860696,0.4951814582774356,0.29638890192534717},
{0.9179300672917893,0.3932128798988251,0.05280172954897753},
{0.9345400085141651,0.0653027956725254,-0.34981497589968424},
{0.31518963358342433,-0.9142699301564876,-0.2544916299079362},
{0.41850035781795886,-0.18000015390019736,-0.8902007611219761},
{0.676804991455218,-0.7349054199474583,0.043000317128508235},
{0.6245706021536186,0.41068066971580397,0.6642687336065464},
{-0.09769963167308288,-0.028899891047616123,0.9947962496252083},
{0.6687601531133797,0.11419319600111837,0.7346562268127992},
{0.14930051882020434,-0.5184018014493901,0.8420029259652516},
{0.3058968477492258,-0.9461902495597172,-0.10559891180882068},
{0.9788786851486938,0.09749787700684201,0.17969608716030266},
{0.8125212680225394,-0.12480326676826205,-0.5694149046301956},
{0.8486224845505963,0.5164136825617816,0.11470303909728186},
{0.772622402511346,0.3234093773908482,-0.5463158406574532},
{0.20249442439278545,-0.28109226023117034,-0.9380741704833186},
{0.5825895833913727,-0.78298600033547,0.21799610226453697},
{0.9429492468104057,0.3005156948420054,0.14330748442881658},
{0.8588632972612206,0.2534891673718936,0.44508097987072914},
{0.3359941923905764,-0.4710918572476206,0.8155859027195062},
{0.9544965733634524,-0.2682990368081868,-0.13019953258451705},
{0.8155174604157432,0.5267112770091624,-0.2398051342828881},
{0.6569306038250354,0.0651030328954328,-0.7511349924387031},
{0.12120480647190285,-0.49301955107795464,-0.861534164814722},
{0.4156284798391913,-0.6174423085965272,-0.667845762359509},
{0.8419003493887175,0.19900008258505142,-0.5016002081641296},
{0.9420112194204353,0.2307027476860875,0.24370290251885363},
{0.5590077255401509,-0.44440614173531845,0.7000096742005465},
{0.961757140248046,-0.054197584738453,0.26848803509731795},
{0.3754071459430352,-0.492609376908735,0.7851149448052129},
{0.2965872618506494,-0.9524590927604301,-0.06969700657784984},
{0.6465926806122829,0.008199907177576123,-0.7627913652506179},
{0.049399151329870175,-0.5273909395014884,-0.8481854282995117},
{-0.21320836432820212,-0.12530491580827263,-0.9689380121838416},
{0.3557157692295827,0.2434107906395289,-0.9023400016189274},
{-0.01790043865562395,-0.13470330094483496,-0.990724277995902},
{0.7618228397911107,0.48161443901732587,-0.4332129879200697},
{0.8581093234084486,0.4829052467940098,-0.17450189597339968},
{-0.29769521012260336,-0.5259915368642573,0.7966871814063758},
{-0.561703600531619,-0.8123052068930643,0.15700100637967634},
{-0.47969973856371373,-0.8455995391483768,0.23419987236110434},
{-0.32508895691569717,-0.930768382335069,-0.1672943171085701},
{-0.5929426311430042,-0.6216446947520516,-0.5118367998296333},
{0.0122003203236152,-0.9979262008963613,-0.06320165938135087},
{-0.5756749212683205,-0.7791660563701153,0.24798919658597096},
{-0.35629744357501353,-0.5334961721786968,0.7670944961167355},
{-0.20691065099989742,-0.6688344291383826,0.7140367559880461},
{-0.47011335611017335,-0.880625018912186,0.059101679102555295},
{-0.24461008181228713,-0.7421305875425113,-0.6240257197500702},
{-0.28929899034828555,-0.6592976990550455,-0.6939975779526795},
{-0.6245586774421154,-0.5570631431364113,-0.5473637848732211},
{-0.5800902951705419,-0.5822902583654657,-0.5695904708311338},
{-0.5236094669447443,-0.8392151731474969,-0.14680265421598257},
{-0.5341259538106589,-0.8260401382655012,0.17990874197816425},
{0.869323241667553,0.42981149116382644,-0.24400652360161387},
{0.30688586669685636,0.5520745747909235,0.7752642960250008},
{0.8800633637247363,0.164693143967122,0.445381459155775},
{0.4616784424284345,0.5954721950750114,0.6574693001877748},
{-0.25830404636457965,0.414306490162003,0.8727136711667391},
{-0.333797960500692,0.3386979305619664,0.8796946250822612},
{-0.8129256482088079,-0.10930344857820481,0.5720180474541002},
{-0.13410321449257753,0.32220772341169635,0.9371224630946638},
{-0.4406118856659259,-0.4963133882342239,0.7480201781164607},
{0.5109219343494725,-0.10380445642097327,0.8533366345280973},
{0.9339709679636842,0.21439333568673866,0.2858911132128665},
{0.907296212046222,-0.418498252773442,-0.040899829243569365},
{0.877432939450832,-0.4630173819987865,0.12540470778109683},
{0.23699481934987293,-0.43159056553335506,0.8703809736798709},
{-0.28710378118169744,-0.9279122206844201,0.2378031318878706},
{0.3460070292041981,-0.8744177639773146,-0.3401069093420457},
{-0.2671847254858535,-0.9512456188424118,-0.1540911908584207},
{-0.5702936526669685,-0.8195908780042914,0.05509938674723824},
{-0.5352022639103645,-0.8265034961171829,-0.17450073813968348},
{-0.298509822627323,-0.9187302313156505,-0.2585085063623551},
{-0.31491221725645735,-0.8854343510919889,-0.3418132609026901},
{0.335994244467888,-0.9300840677963769,-0.1484974562603612},
{-0.7164033527755365,-0.5158024139609461,0.46980219867943473},
{-0.6512906800970513,-0.7577891561147636,-0.03969943190519413},
{-0.6114251270319037,-0.7759318875761433,-0.15520637833717935},
{-0.657613385856705,-0.7412150875866633,-0.1347027419022174},
{-0.638499725445177,-0.7693996691582132,-0.018499992045005128},
{-0.7478988257997652,-0.4931992256778235,0.44429930245064264},
{-0.8097858207744163,-0.5642901193665142,0.16069718621690382},
{-0.7394651794045335,-0.6622688144957708,0.12079431192977369},
{-0.3443055864034595,-0.8865143838125671,-0.30910501526955947},
{-0.18970116571724502,-0.6749041472987278,-0.7131043820398915},
{0.8246374352660801,-0.5057229578147668,0.25341150387633365},
{-0.4753083963969842,-0.854315091609391,-0.21030371504793977},
{-0.14509932238774667,-0.6221970943463541,-0.7692964073941662},
{-0.552791929296748,-0.7009897656241324,0.45059342138407144},
{-0.39441231177247094,-0.6795212115856846,0.6186193105031708},
{-0.4646194075579891,-0.8841369311709387,0.04930205939003198},
{-0.5340056791805974,-0.844808984591327,-0.03370035840521747},
{-0.41359294416455833,-0.5309909413718097,-0.7395873827468746},
{-0.4876972250106845,0.6027965700972742,-0.6314964067956679},
{-0.4169820180381998,0.4988784863291556,-0.7597672357444226},
{-0.46491745797832673,0.770828945170347,-0.43551635394614174},
{-0.49988868764699634,0.720183702427219,-0.4810891130765552},
{-0.5849930473989472,0.66859205383066,-0.4590945436937721},
{-0.5015037161563051,0.3087022874924255,0.808205988828566},
{-0.4887876729303311,-0.06499836076201211,0.8699780594300082},
{-0.8463371592487332,0.3103136246187899,0.4329190077263105},
{-0.5033119638675734,-0.30990736658565665,0.8066191735656362},
{-0.821539936026959,0.27431333469530716,0.4998242970496337},
{-0.960877602204136,0.09299783224579523,0.2608939186336342},
{-0.6861810479411802,-0.5975834949718001,0.41478854369863233},
{-0.9989941209368972,0.02659984346038185,0.03609978755337537},
{-0.9487706027983014,-0.10419677151305123,0.29829075760406126},
{-0.9776762965255326,-0.20959491843280315,-0.014799641187049076},
{-0.9248694751866989,-0.23499224420896772,0.29899013199353763},
{-0.8518572122868133,-0.11329430936975694,0.5113743143132718},
{-0.743322526730514,-0.309709385885161,0.5929179686513141},
{-0.7213310683981883,-0.34311477827175707,0.6016259125860945},
{-0.5965818045324384,-0.4387866172122594,0.6719795049376444},
{-0.5223227293681134,-0.44921954821397003,0.7248315417308225},
{-0.26568802571051575,-0.5437754925908108,0.7960641221985005},
{0.0761042235210797,-0.6228345651633173,0.7786432120041085},
{0.3908031791967942,-0.7447060582084254,0.5410044010887044},
{0.5954030693107335,-0.7673039554620855,0.23820122793049497},
{-0.641286347159002,0.1459968917592613,-0.7532839627551476},
{-0.6874834146626795,-0.2151948084878671,-0.6935832675055047},
{-0.8789106964082632,-0.08470103081781762,-0.46940571270228554},
{-0.8446084799117077,0.12740127911526353,-0.5200052208786266},
{-0.9683942477552524,0.09259944996090083,-0.23159862430825737},
{-0.9711947507065586,-0.11959935356724095,-0.20609888603853144},
{-0.8265783852578347,-0.31929165063250253,-0.46348787995040697},
{-0.6218042531556374,-0.5118035007479177,-0.5928040547936022},
{-0.5354044224587944,-0.22740187834727277,-0.8134067187672457},
{-0.5167177392244866,0.04940169598933547,-0.8547293433620451},
{-0.37239010758818614,0.21689423828108909,-0.9023760286991921},
{-0.4639137552467676,0.3918116173866858,-0.794523557972746},
{-0.6809182284249656,0.3558095251484841,-0.6401171361651058},
{-0.45980884680731965,-0.29320564133080934,-0.8382161274334392},
{-0.5968112410455887,-0.5245098792366141,-0.607211436935123},
{-0.6979734635533639,-0.7047732050321073,-0.12699517173535418},
{-0.9237131768624526,-0.2643037703201756,-0.2773039557691438},
{-0.7312820289649544,-0.3804906495571792,-0.5660860886053066},
{-0.5176951595728869,-0.43539592906709473,-0.7364931138215786},
{-0.26069079908061676,-0.5248814746352733,-0.8102714019755419},
{-0.429598889488306,-0.5673985332766872,-0.7024981840445413},
{-0.3593017803447324,-0.005600027748206239,-0.9332046240403682},
{-0.282803857470924,0.3322045313007106,-0.8998122735231168},
{-0.4310083422471971,0.27250527439062927,-0.8602166496543826},
{-0.4202264477837631,-0.04970312816480968,-0.9060570244933112},
{-0.4789964171201999,0.32859754209957764,0.8139939113483147},
{-0.5831048660304106,0.47770398645640055,0.6571054835681407},
{-0.6766883678269349,0.5756901039721685,0.45899210999344336},
{-0.5009141810812026,0.7609215419937851,0.4124116755398042},
{-0.4864026825181912,0.09990055095305778,0.868004787059601},
{-0.4222015917030011,-0.20890078755745364,0.882103325535806},
{-0.5762179408248858,-0.09000280228087419,0.8123252921417123},
{-0.7127149208430534,-0.07700161204562243,0.6972145963403632},
{-0.7904672832362063,0.1197950417858286,0.6006751385705112},
{-0.6572875971000631,0.3080941863175558,0.6877870215813531},
{-0.5270799845176248,0.5564788681162174,0.642275610046804},
{-0.38529515879674436,0.6397919610645135,0.6649916444324813},
{-0.23290403043912042,0.5667098069980658,0.7903136764965086},
{-0.5766003430773062,0.685400407813364,0.4447002645967361},
{-0.5952593779098346,0.7351498314115745,0.3243778635880234},
{-0.4432984728393916,0.8091972123204053,0.38559867161486444},
{-0.4686819068842203,0.8833658983177303,0.001399945956129525},
{-0.47880710315606334,0.7965118163404437,-0.36920547720388175},
{-0.3410068662423784,0.5863118055070571,-0.734814795644867},
{-0.24890747355909212,0.30050902291887177,-0.9207276452625798},
{-0.4933064401576147,0.47300617513592486,-0.7300095303366282},
{-0.45300982815483387,0.28560619629364364,-0.8445183220237465},
{-0.008300059345636483,-0.09000064350690161,-0.9959071207613702},
{0.10650057776720158,0.02030011012839617,0.9941053930363858},
{0.23059116737449734,0.2770893862943331,0.9327642711488773},
{0.340511957287324,-0.2766097133206279,0.8986315560011432},
{0.5679075106264924,-0.07670101437762276,0.8195108381025014},
{0.4446062223076221,-0.7021098260957748,-0.5562077841824099},
{0.41750409782283027,-0.8284081308657069,-0.3734036649749577},
{0.44870354028489934,-0.8922070395413131,-0.05130040476179036},
{0.515683965056406,-0.779275768796698,0.3560889275869424},
{0.4961228668299104,-0.5310244754821255,0.6869316614099283},
{0.04220082419014473,-0.10170198625918765,-0.9939194114356599},
{0.2353901126459731,-0.3125868700642786,-0.9202613452340231},
{0.3799014778196231,-0.5105019858565875,-0.7714030007635094},
{0.5833775958136409,-0.7909696233949092,-0.18449291468566464},
{0.5671047693711657,-0.7941066784652488,-0.21860183844919204},
{0.6355157705195206,-0.7706191231508144,-0.04760118123796882},
{0.7831142919662438,-0.48300881499131115,0.39170714872069684},
{-0.7106055285325181,-0.26980209906849617,0.6498050555029978},
{-0.3606924868537475,-0.2808941490358128,0.8893814743768311},
{-0.7642813135503228,-0.08249798294897506,0.6395843623535084},
{-0.9121776656032832,-0.27179334522141235,0.3066924907262957},
{-0.007399914124494875,0.12129859233800383,0.9925884810775152},
{-0.4005112925750935,0.06440181583479655,0.9140257713199387},
{-0.416022632246808,0.09040491816132559,0.9048492251368075},
{-0.590616094507866,-0.6183168493637208,0.5185141297025542},
{-0.9382283865292581,-0.052501588459588626,0.3420103476796059},
{-0.9479515229986392,-0.12279372048969715,0.29378497622046434},
{-0.9951279734405056,-0.09840276614063487,0.006100171478230414},
{-0.2080909055857027,-0.7525671097731853,-0.6247726949060406},
{0.07509998723300326,-0.6296998929510275,-0.7731998685560336},
{-0.6849758721498478,-0.7142748401118778,-0.14359494195725278},
{-0.44592517318655966,-0.6710378811576172,-0.5923334381664034},
{0.694808473240997,-0.7059086086079732,-0.13760167806269602},
{-0.11210303242804133,-0.7643206751538981,0.635017177446978},
{0.6320056564759382,-0.758706790456162,0.15790141322397255},
{0.4932200202069385,-0.698328345722841,0.5187210553149615},
{-0.6252808823292798,-0.7684765041900712,0.13589584504805552},
{0.5486982057598008,-0.6898977440380655,-0.4721984559135738},
{0.16379971990271847,-0.6642988640499138,-0.7292987529001989},
{-0.9974906485690044,-0.07049933907179429,-0.00649993906335692},
{0.9564193724705861,-0.035700723125470436,0.2898058700773482},
{0.7422815137090988,0.1865953529006033,0.6435839717407732},
{0.7977990067408548,0.06779991558915763,0.5990992541218929},
{0.965710555274054,0.027100296207856336,0.2582028221722696},
{0.999174496396465,-0.039998979039089874,0.007099818779438453},
{-0.3672097587290091,-0.005000132880296965,-0.9301247183928413},
{-0.7782302698550304,-0.02110082073238389,-0.6276244119262621},
{-0.765891644167743,-0.08449907812008654,-0.6373930460798006},
{-0.4172145756458047,-0.1023035740377896,-0.9030315479582015},
{-0.9549256926213946,-0.0647017408237556,-0.2897077946930758},
{-0.9440763464634554,-0.053898649586251714,-0.32529184991479926},
{-0.028000185921851783,0.001600010624105816,-0.9996066374101087},
{-0.014400272095711897,-0.04420083518267125,-0.9989188747504594},
{0.9626877643162727,0.048699381034800544,-0.26619661666250316},
{0.9502695633533209,-0.004899843060540116,-0.3113900263371821},
{0.7619421098943371,-0.011900657708022852,-0.6475357870541846},
{0.7738250220366379,0.010000323365684129,-0.6333204787487758},
{0.4129967992872083,0.0474996318792794,-0.9094929514569393},
{0.9997977304617278,0.020099954373155357,0.0006999984110054105},
{0.39969397665715733,-0.010699838754644942,-0.9165861871502388},
{0.40810012447055694,0.14530004431652027,0.9013002748966257},
{0.3586800973935781,0.004799733670167758,0.933448204396167},
{0.054802601541244216,0.05190246386844114,0.9971473357075658},
{0.46518540736265296,-0.8350738041456395,-0.2936907870645124},
{0.6213803460504768,-0.778675370887522,-0.08689725148340269},
{0.3115861767858935,-0.8043643151687186,0.5058775572399985},
{-0.3809046127827913,-0.914911079640262,0.13360161792538966},
{-0.444513333377405,-0.07500224972622131,0.8926267747416686},
{0.20810412258350297,-0.20010396409879358,0.9574189666575961},
{-0.26600073150301745,-0.4297011816798745,0.8629023729847886},
{0.608116902844225,-0.7126198075428298,0.3498097230963821},
{0.28470767866964203,-0.9571258140313114,0.053401440256265836},
{0.09340045346030233,-0.9212044724585707,-0.3777018337468543},
{0.12989853800018217,-0.6472927147614929,-0.7510915465122158},
{-0.5092731441888432,-0.5052733551121588,-0.6966632624315081},
{0.07170012009780175,0.007000011725029459,0.9974016706491975},
{0.5182900204217342,-0.5118901436501752,0.6850868087804942},
{0.2863054770761652,-0.7922151552208805,0.5389103094528307},
{-0.7729259630191541,-0.629621149329615,0.07850263694786336},
{0.3623095198077011,-0.9254243158433524,-0.11100291663995258},
{0.7392781953111892,-0.6716801890849802,-0.04809858135326417},
{0.534790232145614,-0.8449845664978382,-0.0006999872148502802},
{-0.2823081263563774,-0.9345269007440123,0.21670623797884161},
{-0.16250259518716786,-0.36700586113040373,0.9159146272733972},
{-0.9872662212640994,0.08169720477795697,0.13649532989218027},
{-0.8119932077052262,0.57679517512854,0.08929925301487278},
{-0.8085139186869164,0.2876049511618518,-0.5134088384092305},
{-0.8548755252640625,-0.018999456053359676,-0.5184851559824732},
{-0.35040115982975856,-0.5879019459586617,-0.7291024133329822},
{-0.6673103934403173,-0.7366114728130343,0.11000171329002684},
{-0.9598064115282435,0.2792018650746881,0.02860019104991432},
{-0.8479835450389611,0.5299897156493507,0.005899885513832395},
{-0.6534315713090701,0.4034194916836224,0.640530948000397},
{-0.6705078248719746,0.13450156964247664,0.729608514581048},
{0.2908959231222059,-0.4760933275987702,0.829888369196008},
{0.23789353295220883,-0.6463824283325253,0.7249802916786524},
{0.5045824383138464,-0.830171106397454,0.23709174816530512},
{0.7562206866998309,-0.6134167802455386,0.22770622898909218},
{0.6320809525274891,-0.7518773425176697,0.18749434994289543},
{-0.14960708406314957,-0.8935423102301078,0.42332004467868456},
{-0.20749952171415367,-0.12199971879097228,0.9705977627747353},
{0.31569277545349966,-0.9141790792511544,-0.2541941828326881},
{0.6550838130789658,-0.5524863482310007,-0.5153872649380231},
{0.008599683494473372,-0.27618983502017974,-0.961064628667251},
{-0.48719068256729303,-0.552889426090838,-0.6759870718708746},
{0.13009355077207674,-0.8774565011721547,0.46167711292442604},
{-0.5605979930627772,-0.30619890380988657,0.7693972455627913},
{-0.32481162034358035,-0.13950499088032473,0.9354334657308655},
{0.27600881862263477,-0.5547177235144038,0.7849250787569058},
{-0.3334962148394422,-0.9121896467062643,0.23809729761100806},
{0.6312045920301106,-0.740105384286256,0.23200168781841835},
{0.3555018539470025,-0.7784040593877547,-0.5174026982621072},
{-0.5829726767109489,-0.1792915967997824,-0.7924628581362385},
{0.11750273667060594,-0.1381032164613675,-0.9834229041861609},
{0.5900799346729764,-0.5601809513706175,-0.581380230501387},
{0.1738909222613488,-0.16079160609330012,-0.971549281593597},
{0.5395925644656921,-0.8347884966937729,-0.10939849249915998},
{0.5784249132975352,-0.8043346434391555,-0.13590585359117396},
{0.3680877318403432,-0.9212692946061077,-0.12559581396127983},
{0.23399919855411744,-0.9045969017609171,-0.3562987796787694},
{-0.03289923329230208,-0.9783771991850565,0.2041952412853521},
{-0.35021159044438177,-0.8416278541347564,-0.411113606029941},
{0.3707048692404364,-0.8630113357283427,-0.3432045080208195},
{0.6323689356390364,-0.7734620046122622,-0.043197877956366815},
{0.7834234521320645,-0.5941177851821031,0.18240546038918634},
{0.7491060453101785,-0.08240066497604955,0.6573053044752107},
{-0.8236259075603899,0.5082159861852721,-0.25170791759707395},
{-0.8458235099911948,0.512114234412971,-0.14940415274613916},
{-0.5275196794887218,0.18330683838916154,-0.8295309462291844},
{-0.8878906017277207,-0.3279965281751238,-0.3225965853332163},
{-0.0373999480141084,-0.8100988739633479,-0.5850991867126957},
{-0.7547076263590967,0.22270225041761077,-0.6171062358900207},
{-0.9174297389669908,0.35041135876829466,-0.18850611052461058},
{-0.8306183070292326,-0.016000352651658705,0.5566122678695772},
{-0.881121733135575,0.018900466185747776,0.4725116546436944},
{-0.9728448637753634,0.2308106440782832,-0.017300797844689336},
{-0.8184043457386139,0.4329022987173093,-0.3779020066649831},
{-0.7257087847580095,0.4287051895077287,-0.5381065138187748},
{-0.7151738537218532,0.6207773047965974,-0.32118825757195085},
{-0.7509660871372401,0.6543704492977496,0.08859599909501926},
{-0.9713667749676836,0.021699257789580744,-0.23659190751220296},
{-0.37690758911071087,0.3134063104995935,-0.8716175501960616},
{-0.8751782170852619,-0.4754881652468487,0.08929777740598022},
{-0.8073248094725985,-0.5846179655861279,-0.08030246773275072},
{-0.32610650099789673,-0.7514149796069292,-0.573611435057938},
{0.21079453100683862,-0.9030765699823338,-0.37419029175881885},
{0.35721559458717994,-0.8686379212161941,0.34331498774294195},
{0.36870617588016946,0.33800566164224916,0.8659145041894187},
{-0.3492940428408986,0.5588904682043464,0.7520871732626391},
{-0.6697043229553571,0.4600029693287506,0.5830037633014382},
{-0.7922935428339388,0.5473955387445388,0.26949780360185094},
{-0.9440520339347026,0.313984046875857,0.10089487366170055},
{0.21970573219733053,0.4562119027238151,0.8623224982874743},
{-0.4675964603081932,0.5826955890110868,0.6646949682781351},
{-0.8948904649928929,0.18769800008846352,0.40489568585945057},
{-0.4467809630687368,0.049697882418344275,0.8932619389196568},
{-0.687776980489688,0.5336821379577588,0.4920835302398597},
{-0.9297342752858493,0.11530425076955837,0.34971289240342207},
{-0.9412659126721978,0.06429767150198908,-0.3314879953796171},
{0.7384063909349704,-0.14670126970498396,0.6582056967949588},
{0.7563892215303892,-0.09149869615286968,0.6476907704722809},
{0.1403065173891026,0.09900459887042878,0.9851457610834281},
{-0.5287962746433678,-0.08079943077001533,0.8448940477424004},
{0.266588695546043,-0.7460683636417954,-0.6101741261147615},
{0.39162001033565524,-0.6847349874280467,-0.6146314053940084},
{0.536589944398662,-0.8423842138677468,0.04959907052212754},
{-0.5722112383390826,0.7408145497406368,-0.35180690955555616},
{-0.6407212274459037,0.7677254351650075,-0.008600284932159781},
{0.6006869742441937,0.6027869287071749,-0.5251886114084411},
{0.48759523134195604,0.2315977349852277,-0.8417917673167732},
{0.8882331583627141,0.4329161610619443,-0.15370573794229808},
{0.8217138501036663,-0.06980117650874518,-0.5656095334290296},
{-0.051602129921869695,-0.9860406996698357,-0.15830653423705374},
{0.7270346622038005,-0.3467165301046185,-0.5926282542255464},
{-0.2050912653490092,0.03659844130557648,-0.9780583453820862},
{-0.7719094713873211,-0.005600068713264669,0.6357078001825627},
{-0.8797116342632952,0.308904085283542,-0.36150478093234195},
{-0.9313298309722366,0.11950382776890613,-0.3440110188494034},
{-0.7583208768611139,-0.11410314130272069,0.6418176694836647},
{-0.8769052482936166,-0.44190264479524366,0.18910113177366047},
{-0.9602462849864314,-0.1916092357877528,0.20300978530748343},
{-0.8866100320492694,-0.16150182740351565,0.43340490400423337},
{-0.9793931540657795,-0.2018985887337971,-0.005099964351373776},
{-0.9987971634200837,0.04899986084059282,0.0017999948880217768},
{-0.9795986824406583,0.0516999304636403,-0.194199738801527},
{-0.962344644203591,0.2713125864828372,0.0168007794062354},
{-0.9406909035629437,0.2805972866373573,-0.1906981559577478},
{0.8725948473426397,-0.43729741776637215,-0.21759871508338113},
{0.1851985313814692,0.6040952095439823,0.7750938535301122},
{-0.009099926745884543,0.9847920724557251,-0.17349860334186462},
{0.21890724813898083,0.9619318500908435,-0.16360541706504003},
{-0.00019999281038769753,0.9118672189627068,0.41048524332074915},
{-0.8841145084381262,0.25260414526803604,-0.3931064509297901},
{0.579780948711033,0.6777777285897518,-0.45218514144037447},
{-0.5010994112085377,-0.6314992579888078,0.5916993047537255},
{-0.4434066755377507,0.6508097980152643,-0.6163092786060346},
{-0.31161337473307144,0.600225762242585,-0.7366316169075111},
{-0.9358833133492832,0.21409618269909345,0.2797950112994224}
};


// face array: 16kb.
const uint16_t bunny_fig_small_face[8245] PROGMEM = {
8, // chain 0
0,0,0, 1,1,1, 2,2,2, 
3,3,3, 32772,4,4, 32773,5,5, 32774,6,6, 32769,1,1, 7,7,7, 32768,0,0, 
24, // chain 1
8,8,8, 9,9,9, 10,10,10, 
11,11,11, 32780,12,12, 32781,13,13, 32782,14,14, 32777,9,9, 15,15,15, 32784,16,16, 32776,8,8, 17,17,17, 32786,18,18, 32787,19,19, 32779,11,11, 20,20,20, 32780,12,12, 21,21,21, 32773,5,5, 
32790,22,22, 32781,13,13, 23,23,23, 32782,14,14, 24,24,24, 32793,25,25, 32783,15,15, 
5, // chain 2
22,22,22, 23,23,23, 4,4,4, 
32771,3,3, 32792,24,24, 26,26,26, 32793,25,25, 
1, // chain 3
5,5,5, 22,22,22, 4,4,4, 
34, // chain 4
27,27,27, 28,28,28, 29,29,29, 
30,30,30, 32799,31,31, 32800,32,32, 33,33,33, 32802,34,34, 35,35,35, 36,36,36, 32805,37,37, 32806,38,38, 39,39,39, 32808,40,40, 41,41,41, 32810,42,42, 43,43,43, 32812,44,44, 45,45,45, 
46,46,46, 47,47,47, 48,48,48, 32817,49,49, 50,50,50, 51,51,51, 32820,52,52, 53,53,53, 32822,54,54, 55,55,55, 56,56,56, 32825,57,57, 58,58,58, 32827,59,59, 60,60,60, 61,61,61, 
32830,62,62, 
13, // chain 5
63,63,63, 64,64,64, 65,65,65, 
53,53,53, 32819,51,51, 32834,66,66, 32832,64,64, 67,67,67, 32804,36,36, 32836,68,68, 32831,63,63, 30,30,30, 32837,69,69, 32824,56,56, 32821,53,53, 
3, // chain 6
70,70,70, 71,71,71, 41,41,41, 
48,48,48, 32811,43,43, 
3, // chain 7
30,30,30, 69,69,69, 27,27,27, 
32826,58,58, 32824,56,56, 
3, // chain 8
66,66,66, 67,67,67, 72,72,72, 
32805,37,37, 32804,36,36, 
3, // chain 9
68,68,68, 30,30,30, 31,31,31, 
36,36,36, 32801,33,33, 
11, // chain 10
32,73,32, 29,74,29, 73,75,73, 
74,76,74, 32843,77,75, 32844,78,76, 32845,79,77, 32797,74,29, 28,80,28, 78,81,78, 32829,82,61, 79,83,79, 32830,84,62, 
21, // chain 11
80,85,80, 81,86,81, 82,87,82, 
83,88,83, 32852,89,84, 32844,78,76, 32843,77,75, 32849,86,81, 74,76,74, 32853,90,85, 32854,91,86, 32848,85,80, 83,88,83, 87,92,87, 32856,93,88, 32857,94,89, 32858,95,90, 32852,89,84, 91,96,91, 
32860,97,92, 32846,81,78, 32845,79,77, 32844,78,76, 
11, // chain 12
93,98,93, 94,99,94, 95,100,95, 
85,90,85, 32864,101,96, 32865,102,97, 32866,103,98, 32867,104,99, 32862,99,94, 87,92,87, 32861,98,93, 86,91,86, 32853,90,85, 
5, // chain 13
97,102,97, 38,105,38, 100,106,100, 
96,101,96, 32802,107,34, 32803,108,35, 32806,105,38, 
6, // chain 14
101,109,101, 42,110,42, 102,111,102, 
98,103,98, 32865,102,97, 32806,105,38, 32808,112,40, 32810,110,42, 
2, // chain 15
27,27,27, 58,58,58, 61,61,61, 
28,28,28, 
6, // chain 16
51,51,51, 66,66,66, 72,72,72, 
70,70,70, 32839,71,71, 32805,37,37, 39,39,39, 41,41,41, 
9, // chain 17
87,92,87, 88,93,88, 103,113,103, 
104,114,104, 32873,115,105, 106,116,106, 107,117,107, 32876,118,108, 109,119,109, 44,120,44, 32813,121,45, 
44, // chain 18
110,122,110, 111,123,111, 112,124,112, 
113,125,113, 32882,126,114, 32883,127,115, 32884,128,116, 32879,123,111, 117,129,117, 32886,130,118, 32887,131,119, 32878,122,110, 120,132,120, 32889,133,121, 32881,125,113, 122,134,122, 32891,135,123, 32882,126,114, 124,136,124, 
32893,137,125, 32883,127,115, 126,138,126, 32895,139,127, 32896,140,128, 32884,128,116, 129,141,129, 32898,142,130, 32885,129,117, 131,143,131, 32886,130,118, 132,144,132, 32901,145,133, 32902,146,134, 32887,131,119, 135,147,135, 
32904,148,136, 32888,132,120, 121,133,121, 137,149,137, 32906,150,138, 32890,134,122, 139,151,139, 32908,152,140, 32909,153,141, 32892,136,124, 32891,135,123, 
37, // chain 19
142,154,142, 143,155,143, 144,156,144, 
145,157,145, 32914,158,146, 32915,159,147, 32916,160,148, 32911,155,143, 149,161,149, 32918,162,150, 32919,163,151, 32910,154,142, 152,164,152, 32921,165,153, 32913,157,145, 154,166,154, 32923,167,155, 32924,168,156, 32925,169,157, 
32914,158,146, 147,159,147, 158,170,158, 32927,171,159, 32928,172,160, 32916,160,148, 161,173,161, 32930,174,162, 32917,161,149, 163,175,163, 32932,176,164, 32918,162,150, 165,177,165, 32934,178,166, 32919,163,151, 167,179,167, 
32920,164,152, 168,180,168, 32922,166,154, 32921,165,153, 
16, // chain 20
129,181,129, 130,182,130, 167,179,167, 
128,183,128, 32937,184,169, 32936,180,168, 170,185,170, 32939,186,171, 32922,166,154, 155,167,155, 172,187,172, 32941,188,173, 32942,189,174, 32924,168,156, 175,190,175, 32944,191,176, 32926,170,158, 32925,169,157, 
2, // chain 21
130,182,130, 131,192,131, 166,178,166, 
167,179,167, 
15, // chain 22
177,193,177, 178,194,178, 159,171,159, 
179,195,179, 32928,172,160, 180,196,180, 32929,173,161, 181,197,181, 32930,174,162, 182,198,182, 32931,175,163, 183,199,183, 32900,200,132, 32932,176,164, 131,192,131, 32933,177,165, 166,178,166, 
25, // chain 23
184,201,184, 185,202,185, 186,203,186, 
178,194,178, 32927,171,159, 32926,170,158, 32955,204,187, 32956,205,188, 32953,202,185, 189,206,189, 32958,207,190, 32959,208,191, 32952,201,184, 192,209,192, 32946,194,178, 193,210,193, 32945,193,177, 194,211,194, 32947,195,179, 
195,212,195, 32948,196,180, 196,213,196, 32949,197,181, 182,198,182, 197,214,197, 32966,215,198, 32951,199,183, 
12, // chain 24
192,209,192, 193,210,193, 199,216,199, 
32968,217,200, 32962,211,194, 201,218,201, 32970,219,202, 32963,212,195, 203,220,203, 32964,213,196, 197,214,197, 204,221,204, 32973,222,205, 32966,215,198, 
18, // chain 25
135,147,135, 136,148,136, 206,223,206, 
32905,149,137, 138,150,138, 207,224,207, 32976,225,208, 32907,151,139, 209,226,209, 32908,152,140, 210,227,210, 32979,228,211, 32909,153,141, 124,136,124, 125,137,125, 212,229,212, 32894,138,126, 213,230,213, 32982,231,214, 
32895,139,127, 
29, // chain 26
215,232,215, 216,233,216, 217,234,217, 
218,235,218, 32987,236,219, 32988,237,220, 32984,233,216, 221,238,221, 32990,239,222, 32991,240,223, 32983,232,215, 207,224,207, 32974,223,206, 32992,241,224, 32986,235,218, 225,242,225, 32994,243,226, 32987,236,219, 227,244,227, 
32996,245,228, 32997,246,229, 32988,237,220, 230,247,230, 32989,238,221, 231,248,231, 32990,239,222, 232,249,232, 33001,250,233, 32991,240,223, 208,225,208, 32975,224,207, 
3, // chain 27
234,251,234, 235,252,235, 236,253,236, 
237,254,237, 33006,255,238, 
5, // chain 28
235,252,235, 234,251,234, 239,256,239, 
33008,257,240, 33009,258,241, 33010,259,242, 33005,254,237, 
61, // chain 29
243,260,243, 244,261,244, 245,262,245, 
246,263,246, 33015,264,247, 33016,265,248, 33017,266,249, 33018,267,250, 33019,268,251, 33012,261,244, 252,269,252, 33021,270,253, 33022,271,254, 33011,260,243, 255,272,255, 33014,263,246, 256,273,256, 33025,274,257, 33026,275,258, 
33015,264,247, 248,265,248, 259,276,259, 33028,277,260, 33017,266,249, 261,278,261, 33030,279,262, 33031,280,263, 33018,267,250, 264,281,264, 33019,268,251, 252,269,252, 253,270,253, 265,282,265, 33007,283,239, 33003,284,235, 
33022,271,254, 236,285,236, 33023,272,255, 256,273,256, 238,286,238, 33025,274,257, 237,287,237, 33034,288,266, 33026,275,258, 267,289,267, 33027,276,259, 260,277,260, 268,290,268, 33037,291,269, 33029,278,261, 270,292,270, 
33039,293,271, 33030,279,262, 272,294,272, 33041,295,273, 33031,280,263, 274,296,274, 33043,297,275, 33032,281,264, 276,298,276, 33033,282,265, 277,299,277, 33007,283,239, 
11, // chain 30
128,183,128, 169,184,169, 127,300,127, 
33046,301,278, 32938,185,170, 279,302,279, 33048,303,280, 32939,186,171, 172,187,172, 173,188,173, 281,304,281, 32943,190,175, 32942,189,174, 
15, // chain 31
127,300,127, 278,301,278, 214,305,214, 
33050,306,282, 33047,302,279, 283,307,283, 33052,308,284, 33048,303,280, 281,304,281, 285,309,285, 33054,310,286, 33055,311,287, 32943,190,175, 288,312,288, 32944,191,176, 187,204,187, 32926,170,158, 
9, // chain 32
288,312,288, 289,313,289, 290,314,290, 
291,315,291, 33060,316,292, 33061,317,293, 33062,318,294, 33057,313,289, 188,205,188, 32955,204,187, 33056,312,288, 
9, // chain 33
295,319,295, 296,320,296, 210,227,210, 
297,321,297, 33066,322,298, 32979,228,211, 212,229,212, 299,323,299, 32981,230,213, 300,324,300, 32982,231,214, 
5, // chain 34
301,325,301, 233,250,233, 208,225,208, 
302,326,302, 32977,226,209, 296,320,296, 32978,227,210, 
13, // chain 35
303,327,303, 304,328,304, 302,326,302, 
305,329,305, 33064,320,296, 306,330,306, 33063,319,295, 307,331,307, 33065,321,297, 308,332,308, 33077,333,309, 33066,322,298, 299,323,299, 310,334,310, 33068,324,300, 
24, // chain 36
311,335,311, 312,336,312, 313,337,313, 
314,338,314, 33083,339,315, 33084,340,316, 33080,336,312, 317,341,317, 33073,329,305, 33071,327,303, 33079,335,311, 304,328,304, 33086,342,318, 33082,338,314, 319,343,319, 33088,344,320, 33089,345,321, 33083,339,315, 322,346,322, 
33091,347,323, 33092,348,324, 33084,340,316, 317,341,317, 325,349,325, 33074,330,306, 33073,329,305, 
14, // chain 37
326,350,326, 327,351,327, 328,352,328, 
329,353,329, 33098,354,330, 33099,355,331, 33100,356,332, 33101,357,333, 33102,358,334, 33095,351,327, 335,359,335, 336,360,336, 337,361,337, 33106,362,338, 33107,363,339, 33108,364,340, 
56, // chain 38
341,365,341, 342,366,342, 343,367,343, 
344,368,344, 33113,369,345, 33110,366,342, 346,370,346, 33115,371,347, 33116,372,348, 33117,373,349, 33118,374,350, 33109,365,341, 351,375,351, 33120,376,352, 33112,368,344, 353,377,353, 33113,369,345, 354,378,354, 33123,379,355, 
33124,380,356, 33114,370,346, 357,381,357, 33115,371,347, 331,382,331, 33098,383,330, 33116,372,348, 358,384,358, 33117,373,349, 329,385,329, 33118,374,350, 326,386,326, 33119,375,351, 327,387,327, 33127,388,359, 33120,376,352, 
353,377,353, 360,389,360, 33129,390,361, 33130,391,362, 33122,378,354, 363,392,363, 33132,393,364, 33133,394,365, 33123,379,355, 366,395,366, 33124,380,356, 367,396,367, 33125,381,357, 331,382,331, 332,397,332, 333,398,333, 
368,399,368, 33137,400,369, 370,401,370, 33139,402,371, 33105,403,337, 372,404,372, 33141,405,373, 
18, // chain 39
359,388,359, 360,389,360, 374,406,374, 
335,407,335, 33143,408,375, 33128,389,360, 376,409,376, 33129,390,361, 377,410,377, 33130,391,362, 378,411,378, 33131,392,363, 379,412,379, 33132,393,364, 380,413,380, 33149,414,381, 33133,394,365, 368,399,368, 33135,396,367, 
33134,395,366, 
6, // chain 40
382,415,382, 383,416,383, 384,417,384, 
33153,418,385, 33154,419,386, 33008,257,240, 33045,420,277, 239,256,239, 
9, // chain 41
387,421,387, 388,422,388, 389,423,389, 
272,294,272, 33039,293,271, 33158,424,390, 33156,422,388, 391,425,391, 392,426,392, 33161,427,393, 33162,428,394, 
14, // chain 42
395,429,395, 394,430,394, 396,431,396, 
372,432,372, 397,433,397, 33141,434,373, 398,435,398, 399,436,399, 33168,437,400, 33169,438,401, 33107,439,339, 402,440,402, 33171,441,403, 33108,442,340, 404,443,404, 33173,444,405, 
6, // chain 43
406,445,406, 407,446,407, 200,217,200, 
201,218,201, 408,447,408, 33177,448,409, 32971,220,203, 32970,219,202, 
10, // chain 44
384,449,384, 410,450,410, 411,451,411, 
408,447,408, 33174,445,406, 33175,446,407, 33180,452,412, 33178,450,410, 413,453,413, 33182,454,414, 33183,455,415, 33152,449,384, 
7, // chain 45
382,456,382, 384,449,384, 408,447,408, 
416,457,416, 33177,448,409, 417,458,417, 33186,459,418, 32972,221,204, 32971,220,203, 
11, // chain 46
419,460,419, 416,461,416, 417,462,417, 
418,463,418, 420,464,420, 33189,465,421, 32973,466,205, 422,467,422, 32966,468,198, 423,469,423, 32951,470,183, 133,145,133, 32900,144,132, 
16, // chain 47
424,471,424, 425,472,425, 426,473,426, 
427,474,427, 416,461,416, 419,460,419, 428,475,428, 32996,245,228, 33197,476,429, 33188,464,420, 430,477,430, 33189,465,421, 431,478,431, 33190,467,422, 432,479,432, 33191,469,423, 134,146,134, 32901,145,133, 
23, // chain 48
433,480,433, 434,481,434, 435,482,435, 
436,483,436, 33205,484,437, 33202,481,434, 438,485,438, 32997,246,229, 33207,486,439, 33208,487,440, 33209,488,441, 33201,480,433, 442,489,442, 33211,490,443, 33212,491,444, 33204,483,436, 445,492,445, 33214,493,446, 33215,494,447, 
33216,495,448, 33205,484,437, 449,496,449, 33206,485,438, 230,247,230, 32997,246,229, 
9, // chain 49
441,488,441, 442,489,442, 388,497,388, 
440,487,440, 33155,498,387, 425,472,425, 424,471,424, 428,475,428, 439,486,439, 32996,245,228, 229,246,229, 
10, // chain 50
450,499,450, 451,500,451, 378,411,378, 
452,501,452, 33147,412,379, 453,502,453, 33148,413,380, 372,404,372, 33139,402,371, 33149,414,381, 370,401,370, 33136,399,368, 
3, // chain 51
373,503,373, 337,361,337, 338,362,338, 
398,504,398, 33107,363,339, 
2, // chain 52
454,505,454, 452,501,452, 453,502,453, 
372,404,372, 
19, // chain 53
455,506,455, 456,507,456, 457,508,457, 
293,317,293, 33060,316,292, 33226,509,458, 33224,507,456, 459,510,459, 33228,511,460, 33229,512,461, 33230,513,462, 33223,506,455, 403,441,403, 33170,440,402, 33231,514,463, 33232,515,464, 33061,317,293, 465,516,465, 33062,318,294, 
189,206,189, 32956,205,188, 
8, // chain 54
466,517,466, 467,518,467, 465,516,465, 
189,206,189, 190,207,190, 468,519,468, 33237,520,469, 32959,208,191, 199,216,199, 32960,209,192, 
2, // chain 55
3,3,3, 26,26,26, 470,521,470, 
0,0,0, 
9, // chain 56
399,436,399, 471,522,471, 472,523,472, 
473,524,473, 33242,525,474, 33235,518,467, 33239,522,471, 475,526,475, 33169,438,401, 33168,437,400, 33167,436,399, 
5, // chain 57
467,518,467, 475,526,475, 465,516,465, 
33232,515,464, 33231,514,463, 33169,438,401, 402,440,402, 
18, // chain 58
445,492,445, 476,527,476, 477,528,477, 
443,490,443, 33222,529,454, 33244,527,476, 450,530,450, 33246,531,478, 33088,344,320, 33213,492,445, 446,493,446, 447,494,447, 319,343,319, 33086,342,318, 33247,532,479, 33248,533,480, 33216,495,448, 449,496,449, 231,248,231, 
32998,247,230, 
2, // chain 59
478,531,478, 322,346,322, 451,534,451, 
450,530,450, 
2, // chain 60
322,346,322, 478,531,478, 321,345,321, 
33088,344,320, 
2, // chain 61
334,358,334, 337,361,337, 369,535,369, 
333,357,333, 
27, // chain 62
481,536,481, 482,537,482, 483,538,483, 
484,539,484, 33253,540,485, 33254,541,486, 33255,542,487, 33250,537,482, 488,543,488, 33257,544,489, 33258,545,490, 33249,536,481, 491,546,491, 33260,547,492, 33252,539,484, 485,540,485, 493,548,493, 494,549,494, 33263,550,495, 
496,551,496, 33265,552,497, 33266,553,498, 499,554,499, 500,555,500, 33269,556,501, 502,557,502, 33271,558,503, 488,543,488, 33255,542,487, 
6, // chain 63
500,555,500, 489,544,489, 504,559,504, 
497,552,497, 33264,551,496, 33273,560,505, 33258,545,490, 33257,544,489, 
2, // chain 64
494,549,494, 505,560,505, 491,546,491, 
492,547,492, 
26, // chain 65
506,561,506, 507,562,507, 508,563,508, 
509,564,509, 33278,565,510, 33279,566,511, 33280,567,512, 33275,562,507, 513,568,513, 33282,569,514, 33274,561,506, 515,570,515, 33284,571,516, 33277,564,509, 517,572,517, 33278,565,510, 518,573,518, 33287,574,519, 33279,566,511, 
520,575,520, 33289,576,521, 33280,567,512, 522,577,522, 33281,568,513, 523,578,523, 33292,579,524, 33282,569,514, 515,570,515, 
6, // chain 66
521,576,521, 522,577,522, 525,580,525, 
526,581,526, 33295,582,527, 33296,583,528, 33290,577,522, 523,578,523, 
6, // chain 67
526,581,526, 527,582,527, 520,575,520, 
33297,584,529, 530,585,530, 519,574,519, 33286,573,518, 33285,572,517, 
8, // chain 68
531,586,531, 532,587,532, 533,588,533, 
33302,589,534, 535,590,535, 33304,591,536, 537,592,537, 33306,593,538, 539,594,539, 33308,595,540, 
5, // chain 69
541,596,541, 542,597,542, 543,598,543, 
544,599,544, 33313,600,545, 546,601,546, 33315,602,547, 
5, // chain 70
548,603,548, 549,604,549, 550,605,550, 
33319,606,551, 33320,607,552, 541,596,541, 33310,597,542, 
40, // chain 71
553,608,553, 554,609,554, 555,610,555, 
556,611,556, 33325,612,557, 33326,613,558, 33322,609,554, 559,614,559, 33328,615,560, 33321,608,553, 561,616,561, 33330,617,562, 33324,611,556, 563,618,563, 33332,619,564, 33333,620,565, 33325,612,557, 566,621,566, 33335,622,567, 
33326,613,558, 568,623,568, 33337,624,569, 33327,614,559, 570,625,570, 33328,615,560, 571,626,571, 33340,627,572, 33341,628,573, 33329,616,561, 574,629,574, 33343,630,575, 33344,631,576, 33330,617,562, 563,618,563, 551,606,551, 
33345,632,577, 33332,619,564, 578,633,578, 33347,634,579, 33333,620,565, 580,635,580, 33334,621,566, 
3, // chain 72
539,636,539, 581,637,581, 578,633,578, 
582,638,582, 33347,634,579, 
32, // chain 73
583,639,583, 584,640,584, 585,641,585, 
586,642,586, 33355,643,587, 33356,644,588, 33357,645,589, 33358,646,590, 33359,647,591, 33352,640,584, 535,590,535, 33360,648,592, 33361,649,593, 33351,639,583, 594,650,594, 33354,642,586, 595,651,595, 33355,643,587, 596,652,596, 
33365,653,597, 33356,644,588, 598,654,598, 33367,655,599, 33357,645,589, 600,656,600, 33369,657,601, 33358,646,590, 602,658,602, 33359,647,591, 535,590,535, 537,592,537, 539,594,539, 582,659,582, 601,657,601, 
3, // chain 74
581,637,581, 539,636,539, 540,660,540, 
550,605,550, 33316,603,548, 
3, // chain 75
550,605,550, 551,606,551, 577,632,577, 
578,633,578, 581,637,581, 
8, // chain 76
603,661,603, 604,662,604, 605,663,605, 
606,664,606, 33375,665,607, 33376,666,608, 33377,667,609, 33301,588,533, 33372,662,604, 531,586,531, 
4, // chain 77
610,668,610, 608,666,608, 609,667,609, 
592,648,592, 33301,588,533, 535,590,535, 
15, // chain 78
592,648,592, 593,649,593, 610,668,610, 
33362,650,594, 611,669,611, 33380,670,612, 33363,651,595, 613,671,613, 33382,672,614, 33364,652,596, 615,673,615, 33365,653,597, 616,674,616, 33366,654,598, 617,675,617, 33386,676,618, 33367,655,599, 
10, // chain 79
574,629,574, 619,677,619, 620,678,620, 
621,679,621, 33390,680,622, 623,681,623, 33392,682,624, 33393,683,625, 626,684,626, 33395,685,627, 628,686,628, 33397,687,629, 
5, // chain 80
630,688,630, 619,677,619, 574,629,574, 
575,630,575, 541,596,541, 33319,606,551, 33344,631,576, 
2, // chain 81
544,599,544, 546,601,546, 630,688,630, 
541,596,541, 
11, // chain 82
608,666,608, 631,689,631, 632,690,632, 
607,665,607, 33401,691,633, 33402,692,634, 33403,693,635, 33404,694,636, 33399,689,631, 637,695,637, 33379,669,611, 33376,666,608, 610,668,610, 
6, // chain 83
532,696,532, 531,697,531, 638,698,638, 
639,699,639, 33408,700,640, 33409,701,641, 33299,697,531, 604,702,604, 
31, // chain 84
642,703,642, 603,704,603, 643,705,643, 
644,706,644, 33413,707,645, 33371,704,603, 545,708,545, 543,709,543, 646,710,646, 33415,711,647, 33310,712,542, 648,713,648, 33320,714,552, 649,715,649, 33317,716,549, 650,717,650, 651,718,651, 652,719,652, 648,713,648, 
33421,720,653, 654,721,654, 647,711,647, 33423,722,655, 33424,723,656, 644,706,644, 33425,724,657, 658,725,658, 659,726,659, 33408,727,640, 641,728,641, 642,703,642, 33372,729,604, 603,704,603, 
3, // chain 85
647,711,647, 655,722,655, 646,710,646, 
33412,706,644, 645,707,645, 
6, // chain 86
660,730,660, 548,731,548, 661,732,661, 
662,733,662, 33431,734,663, 33306,735,538, 33308,736,540, 33316,731,548, 
5, // chain 87
536,737,536, 534,738,534, 663,734,663, 
33432,739,664, 33433,740,665, 33407,699,639, 33300,696,532, 
10, // chain 88
666,741,666, 667,742,667, 668,743,668, 
669,744,669, 33438,745,670, 33439,746,671, 672,747,672, 673,748,673, 674,749,674, 675,750,675, 33444,751,676, 33445,752,677, 
9, // chain 89
678,753,678, 566,754,566, 679,755,679, 
680,756,680, 33435,742,667, 666,741,666, 681,757,681, 33437,744,669, 682,758,682, 33443,750,675, 33438,745,670, 
14, // chain 90
683,759,683, 582,760,582, 579,761,579, 
684,762,684, 33453,763,685, 33348,764,580, 566,754,566, 678,753,678, 686,765,686, 33455,766,687, 33448,756,680, 688,767,688, 33457,768,689, 33449,757,681, 690,769,690, 33450,758,682, 
14, // chain 91
691,770,691, 617,771,617, 692,772,692, 
693,773,693, 33462,774,694, 33463,775,695, 33385,771,617, 618,776,618, 696,777,696, 33367,778,599, 697,779,697, 33368,780,600, 698,781,698, 33369,782,601, 683,783,683, 33350,784,582, 
6, // chain 92
699,785,699, 672,786,672, 700,787,700, 
691,788,691, 33469,789,701, 33470,790,702, 33471,791,703, 33472,792,704, 
7, // chain 93
705,793,705, 667,794,667, 706,795,706, 
707,796,707, 33476,797,708, 33336,623,568, 33335,622,567, 33447,798,679, 33435,794,667, 
4, // chain 94
677,799,677, 709,800,709, 710,801,710, 
690,802,690, 33479,803,711, 33480,804,712, 
2, // chain 95
677,799,677, 690,802,690, 682,805,682, 
676,806,676, 
1, // chain 96
713,807,713, 710,801,710, 709,800,709, 
1, // chain 97
709,800,709, 677,799,677, 714,808,714, 
6, // chain 98
690,769,690, 711,809,711, 688,767,688, 
33454,765,686, 33483,810,715, 33480,811,712, 716,812,716, 33478,813,710, 
1, // chain 99
690,769,690, 688,767,688, 689,768,689, 
16, // chain 100
717,814,717, 710,815,710, 713,816,713, 
698,781,698, 33465,779,697, 33486,817,718, 33477,818,709, 719,819,719, 33462,774,694, 33482,820,714, 720,821,720, 33489,822,721, 33445,823,677, 674,824,674, 722,825,722, 33441,826,673, 699,827,699, 33440,828,672, 
1, // chain 101
682,758,682, 675,750,675, 676,751,676, 
1, // chain 102
686,765,686, 687,766,687, 688,767,688, 
4, // chain 103
719,819,719, 694,774,694, 695,775,695, 
718,817,718, 33464,777,696, 697,779,697, 
4, // chain 104
684,762,684, 685,763,685, 686,765,686, 
715,810,715, 716,812,716, 683,759,683, 
3, // chain 105
693,773,693, 720,821,720, 722,825,722, 
699,827,699, 691,770,691, 
54, // chain 106
723,829,723, 724,830,724, 725,831,725, 
726,832,726, 33495,833,727, 33496,834,728, 33492,830,724, 654,835,654, 33497,836,729, 33498,837,730, 33491,829,723, 731,838,731, 33494,832,726, 732,839,732, 733,840,733, 730,837,730, 33502,841,734, 735,842,735, 33504,843,736, 
737,844,737, 33506,845,738, 739,846,739, 740,847,740, 33509,848,741, 742,849,742, 33511,850,743, 33512,851,744, 745,852,745, 746,853,746, 33515,854,747, 33516,855,748, 749,856,749, 750,857,750, 33519,858,751, 33520,859,752, 
753,860,753, 754,861,754, 33523,862,755, 33524,863,756, 757,864,757, 33526,865,758, 759,866,759, 760,867,760, 33529,868,761, 762,869,762, 763,870,763, 33532,871,764, 640,872,640, 765,873,765, 33426,874,658, 766,875,766, 
33425,876,657, 742,849,742, 33497,836,729, 33424,877,656, 654,835,654, 
21, // chain 107
758,878,758, 756,879,756, 767,880,767, 
768,881,768, 33537,882,769, 33524,879,756, 753,883,753, 770,884,770, 33520,885,752, 771,886,771, 33540,887,772, 33517,888,749, 748,889,748, 773,890,773, 33542,891,774, 33543,892,775, 33513,893,745, 776,894,776, 33545,895,777, 
33512,896,744, 778,897,778, 33507,898,739, 33509,899,741, 
12, // chain 108
768,881,768, 769,882,769, 779,900,779, 
761,901,761, 33530,902,762, 33548,903,780, 33537,882,769, 781,904,781, 33538,884,770, 776,894,776, 33550,905,782, 33539,886,771, 773,890,773, 33540,887,772, 
4, // chain 109
783,906,783, 765,873,765, 757,864,757, 
760,867,760, 765,873,765, 33531,870,763, 
21, // chain 110
654,835,654, 653,907,653, 784,908,784, 
785,909,785, 33554,910,786, 33555,911,787, 33556,912,788, 33421,907,653, 652,913,652, 651,914,651, 787,911,787, 33557,915,789, 790,916,790, 33559,917,791, 792,918,792, 786,910,786, 33561,919,793, 33562,920,794, 795,921,795, 
785,909,785, 33496,834,728, 33564,922,796, 727,833,727, 
1, // chain 111
654,835,654, 785,909,785, 728,834,728, 
17, // chain 112
797,923,797, 798,924,798, 799,925,799, 
800,926,800, 33569,927,801, 33570,928,802, 33566,924,798, 803,929,803, 33572,930,804, 33563,931,795, 33565,923,797, 796,932,796, 33573,933,805, 33574,934,806, 33568,926,800, 776,894,776, 33549,904,781, 33575,935,807, 33569,927,801, 
5, // chain 113
808,936,808, 802,928,802, 809,937,809, 
810,938,810, 33579,939,811, 33571,929,803, 33570,928,802, 
11, // chain 114
651,940,651, 810,938,810, 811,939,811, 
789,941,789, 33559,942,791, 33580,943,812, 33571,929,803, 813,944,813, 33572,930,804, 791,942,791, 33560,945,792, 33562,946,794, 33563,931,795, 
4, // chain 115
746,853,746, 747,854,747, 750,857,750, 
766,875,766, 33522,861,754, 33519,858,751, 
10, // chain 116
734,947,734, 733,948,733, 814,949,814, 
815,950,815, 33574,934,806, 33584,951,816, 33585,952,817, 33501,948,733, 732,953,732, 816,951,816, 33495,954,727, 33494,955,726, 
4, // chain 117
796,932,796, 805,933,805, 727,954,727, 
33586,956,818, 33584,951,816, 33574,934,806, 
3, // chain 118
775,892,775, 776,894,776, 782,905,782, 
773,890,773, 774,891,774, 
2, // chain 119
742,849,742, 743,850,743, 746,853,746, 
766,875,766, 
6, // chain 120
819,957,819, 815,950,815, 820,958,820, 
821,959,821, 33545,895,777, 33544,894,776, 33574,934,806, 33583,950,815, 
4, // chain 121
737,844,737, 740,847,740, 742,849,742, 
735,842,735, 33498,837,730, 33497,836,729, 
1, // chain 122
786,910,786, 793,919,793, 785,909,785, 
1, // chain 123
786,910,786, 787,911,787, 790,916,790, 
7, // chain 124
651,960,651, 650,961,650, 660,730,660, 
810,962,810, 33430,733,662, 808,963,808, 33569,964,801, 33432,739,664, 33431,734,663, 
6, // chain 125
639,699,639, 640,700,640, 764,965,764, 
822,966,822, 807,967,807, 665,740,665, 33432,739,664, 33569,964,801, 
5, // chain 126
823,968,823, 824,969,824, 825,970,825, 
826,971,826, 33396,972,628, 827,973,827, 33397,974,629, 
24, // chain 127
828,975,828, 829,976,829, 830,977,830, 
33599,978,831, 832,979,832, 33601,980,833, 33602,981,834, 835,982,835, 836,983,836, 33605,984,837, 838,985,838, 839,986,839, 33608,987,840, 33609,988,841, 842,989,842, 33611,990,843, 707,796,707, 33612,991,844, 845,992,845, 
705,793,705, 33614,993,846, 668,994,668, 33615,995,847, 671,996,671, 33468,997,700, 33472,998,704, 
44, // chain 128
848,999,848, 849,1000,849, 850,1001,850, 
851,1002,851, 33620,1003,852, 33621,1004,853, 33622,1005,854, 33617,1000,849, 855,1006,855, 33624,1007,856, 33625,1008,857, 33616,999,848, 858,1009,858, 33627,1010,859, 33628,1011,860, 33619,1002,851, 861,1012,861, 33630,1013,862, 33620,1003,852, 
863,1014,863, 33602,1015,834, 33603,1016,835, 33621,1004,853, 837,1017,837, 33632,1018,864, 33622,1005,854, 865,1019,865, 33623,1006,855, 866,1020,866, 33635,1021,867, 33636,1022,868, 33624,1007,856, 614,672,614, 33637,1023,869, 33625,1008,857, 
858,1009,858, 612,670,612, 33638,1024,870, 33627,1010,859, 637,695,637, 33404,694,636, 33591,968,823, 33628,1011,860, 871,1025,871, 33640,1026,872, 33629,1012,861, 
8, // chain 129
621,679,621, 623,681,623, 572,627,572, 
33641,1027,873, 33642,1028,874, 33392,682,624, 875,1029,875, 33644,1030,876, 33394,684,626, 628,686,628, 
14, // chain 130
571,626,571, 873,1027,873, 877,1031,877, 
570,625,570, 33646,1032,878, 33647,1033,879, 33648,1034,880, 33649,1035,881, 33641,1027,873, 882,1036,882, 33642,1028,874, 832,979,832, 33598,977,830, 33643,1029,875, 883,1037,883, 33644,1030,876, 
10, // chain 131
832,979,832, 833,980,833, 881,1035,881, 
33604,983,836, 839,986,839, 880,1034,880, 33608,987,840, 879,1033,879, 33610,989,842, 878,1032,878, 33476,797,708, 33475,796,707, 
2, // chain 132
611,669,611, 612,670,612, 870,1024,870, 
637,695,637, 
16, // chain 133
883,1038,883, 876,1039,876, 884,1040,884, 
885,1041,885, 33654,1042,886, 33655,1043,887, 33656,1044,888, 33644,1039,876, 889,1045,889, 33396,1046,628, 825,1047,825, 890,1048,890, 33659,1049,891, 33592,1050,824, 892,1051,892, 893,1052,893, 33662,1053,894, 33663,1054,895, 
4, // chain 134
896,1055,896, 883,1038,883, 885,1041,885, 
897,1056,897, 898,1057,898, 33667,1058,899, 
3, // chain 135
896,1055,896, 898,1057,898, 829,1059,829, 
828,1060,828, 883,1038,883, 
11, // chain 136
872,1061,872, 861,1062,861, 900,1063,900, 
33669,1064,901, 33630,1065,862, 863,1066,863, 902,1067,902, 33602,1068,834, 903,1069,903, 33599,1070,831, 904,1071,904, 33666,1072,898, 33597,1073,829, 
14, // chain 137
905,1074,905, 871,1075,871, 872,1061,872, 
906,1076,906, 33668,1063,900, 907,1077,907, 33676,1078,908, 33677,1079,909, 33669,1064,901, 902,1067,902, 910,1080,910, 33671,1069,903, 904,1071,904, 911,1081,911, 33667,1082,899, 33666,1072,898, 
6, // chain 138
843,1083,843, 841,1084,841, 912,1085,912, 
913,1086,913, 33682,1087,914, 33683,1088,915, 33606,1089,838, 33609,1084,841, 
12, // chain 139
844,1090,844, 843,1083,843, 913,1086,913, 
916,1091,916, 33685,1092,917, 33682,1087,914, 918,1093,918, 33687,1094,919, 33688,1095,920, 33689,1096,921, 33683,1088,915, 922,1097,922, 33606,1089,838, 837,1098,837, 
2, // chain 140
569,624,569, 878,1032,878, 708,797,708, 
568,623,568, 
1, // chain 141
570,625,570, 878,1032,878, 569,624,569, 
8, // chain 142
615,673,615, 616,674,616, 923,1099,923, 
868,1022,868, 33635,1021,867, 33692,1100,924, 33469,789,701, 33384,674,616, 617,675,617, 691,788,691, 
1, // chain 143
868,1022,868, 614,672,614, 615,673,615, 
4, // chain 144
925,1101,925, 926,1102,926, 927,1103,927, 
928,1104,928, 33697,1105,929, 930,1106,930, 
2, // chain 145
925,1101,925, 928,1104,928, 931,1107,931, 
33687,1108,919, 
2, // chain 146
932,1109,932, 927,1103,927, 933,1110,933, 
33694,1102,926, 
4, // chain 147
919,1094,919, 920,1095,920, 931,1111,931, 
33702,1112,934, 33689,1096,921, 922,1097,922, 
7, // chain 148
930,1113,930, 929,1114,929, 935,1115,935, 
936,1116,936, 33705,1117,937, 33706,1118,938, 33707,1119,939, 33697,1114,929, 927,1120,927, 
14, // chain 149
940,1121,940, 941,1122,941, 942,1123,942, 
943,1124,943, 33634,1125,866, 33633,1126,865, 33712,1127,944, 33709,1122,941, 945,1128,945, 33694,1129,926, 33708,1121,940, 946,1130,946, 33715,1131,947, 33711,1124,943, 867,1132,867, 33634,1125,866, 
19, // chain 150
948,1133,948, 949,1134,949, 950,1135,950, 
951,1136,951, 33720,1137,952, 33701,1138,933, 33700,1139,932, 33717,1134,949, 927,1140,927, 33707,1141,939, 33716,1133,948, 953,1142,953, 33471,1143,703, 33719,1136,951, 702,1144,702, 33722,1145,954, 33720,1137,952, 947,1131,947, 33714,1130,946, 
33701,1138,933, 926,1129,926, 
8, // chain 151
955,1146,955, 937,1117,937, 846,1147,846, 
845,1148,845, 844,1090,844, 916,1091,916, 956,1149,956, 33725,1150,957, 33686,1093,918, 33685,1092,917, 
13, // chain 152
958,1151,958, 959,1152,959, 960,1153,960, 
961,1154,961, 33730,1155,962, 33731,1156,963, 33732,1157,964, 33733,1158,965, 33727,1152,959, 966,1159,966, 33735,1160,967, 33736,1161,968, 33726,1151,958, 969,1162,969, 33729,1154,961, 
10, // chain 153
970,1163,970, 971,1164,971, 972,1165,972, 
973,1166,973, 33735,1160,967, 33742,1167,974, 33739,1164,971, 975,1168,975, 33744,1169,976, 33745,1170,977, 33746,1171,978, 33738,1163,970, 
13, // chain 154
979,1172,979, 980,1173,980, 981,1174,981, 
982,1175,982, 33751,1176,983, 33752,1177,984, 33753,1178,985, 33754,1179,986, 33748,1173,980, 987,1180,987, 33747,1172,979, 988,1181,988, 33745,1182,977, 33750,1175,982, 983,1176,983, 
9, // chain 155
984,1183,984, 989,1184,989, 990,1185,990, 
966,1159,966, 33759,1186,991, 33760,1187,992, 33757,1184,989, 993,1188,993, 33762,1189,994, 33763,1190,995, 33752,1183,984, 
30, // chain 156
996,1191,996, 997,1192,997, 998,1193,998, 
999,1194,999, 1000,1195,1000, 33769,1196,1001, 1002,1197,1002, 1003,1198,1003, 33772,1199,1004, 1005,1200,1005, 33774,1201,1006, 33775,1202,1007, 1008,1203,1008, 1009,1204,1009, 33778,1205,1010, 895,1206,895, 907,1207,907, 908,1208,908, 1011,1209,1011, 
33734,1159,966, 33780,1210,1012, 1013,1211,1013, 33782,1212,1014, 1015,1213,1015, 33784,1214,1016, 33785,1215,1017, 33786,1216,1018, 33678,1217,910, 911,1218,911, 1019,1219,1019, 33788,1220,1020, 33667,1221,899, 
12, // chain 157
1021,1222,1021, 1022,1223,1022, 1023,1224,1023, 
1024,1225,1024, 33793,1226,1025, 33766,1227,998, 33767,1228,999, 33794,1229,1026, 33790,1223,1022, 1027,1230,1027, 33753,1178,985, 33789,1222,1021, 1028,1231,1028, 33792,1225,1024, 
11, // chain 158
1029,1232,1029, 1002,1233,1002, 1001,1234,1001, 
1030,1235,1030, 33767,1228,999, 1026,1229,1026, 1027,1230,1027, 1031,1236,1031, 33800,1237,1032, 33801,1238,1033, 33802,1239,1034, 33754,1179,986, 33753,1178,985, 
8, // chain 159
1035,1240,1035, 1031,1236,1031, 1036,1241,1036, 
1007,1242,1007, 33776,1243,1008, 33778,1244,1010, 33662,1245,894, 33799,1236,1031, 1032,1237,1032, 1033,1238,1033, 
1, // chain 160
894,1245,894, 895,1246,895, 1010,1244,1010, 
10, // chain 161
964,1157,964, 965,1158,965, 1015,1213,1015, 
1037,1247,1037, 33784,1214,1016, 1038,1248,1038, 33807,1249,1039, 33785,1215,1017, 1040,1250,1040, 33809,1251,1041, 33787,1219,1019, 33786,1216,1018, 
2, // chain 162
1015,1213,1015, 965,1158,965, 1013,1211,1013, 
33734,1159,966, 
16, // chain 163
1020,1252,1020, 899,1253,899, 897,1254,897, 
1042,1255,1042, 33653,1256,885, 1043,1257,1043, 33654,1258,886, 1044,1259,1044, 33813,1260,1045, 33802,1239,1034, 986,1179,986, 1046,1261,1046, 33755,1180,987, 973,1262,973, 33738,1263,970, 33756,1181,988, 978,1264,978, 33745,1182,977, 
12, // chain 164
1047,1265,1047, 1042,1255,1042, 1043,1257,1043, 
1048,1266,1048, 33817,1267,1049, 33812,1259,1044, 1050,1268,1050, 33819,1269,1051, 33813,1260,1045, 1046,1261,1046, 1052,1270,1052, 33821,1271,1053, 33737,1272,969, 33741,1262,973, 
8, // chain 165
1019,1219,1019, 1020,1220,1020, 1054,1273,1054, 
1055,1274,1055, 1041,1251,1041, 33824,1275,1056, 1057,1276,1057, 1038,1248,1038, 1040,1250,1040, 33807,1249,1039, 
7, // chain 166
984,1183,984, 966,1159,966, 1058,1277,1058, 
983,1278,983, 33827,1279,1059, 33743,1168,975, 33742,1167,974, 33734,1159,966, 967,1160,967, 
2, // chain 167
973,1166,973, 967,1160,967, 968,1161,968, 
969,1162,969, 
8, // chain 168
1011,1209,1011, 991,1186,991, 996,1191,996, 
1060,1280,1060, 33768,1195,1000, 1003,1198,1003, 1005,1200,1005, 1006,1201,1006, 1009,1204,1009, 1011,1209,1011, 
3, // chain 169
961,1281,961, 962,1282,962, 1052,1270,1052, 
1053,1271,1053, 969,1272,969, 
5, // chain 170
1025,1283,1025, 997,1192,997, 993,1188,993, 
994,1189,994, 1024,1284,1024, 33796,1285,1028, 33763,1190,995, 
3, // chain 171
1007,1242,1007, 1004,1286,1004, 1035,1240,1035, 
33797,1232,1029, 33770,1233,1002, 
6, // chain 172
1057,1287,1057, 1056,1288,1056, 1048,1266,1048, 
33815,1265,1047, 33823,1289,1055, 1054,1290,1054, 1020,1252,1020, 1042,1255,1042, 
2, // chain 173
1033,1291,1033, 1061,1292,1061, 893,1052,893, 
894,1053,894, 
2, // chain 174
895,1293,895, 892,1294,892, 906,1076,906, 
907,1077,907, 
7, // chain 175
1034,1295,1034, 887,1043,887, 1062,1296,1062, 
1033,1291,1033, 33829,1292,1061, 33658,1048,890, 33657,1045,889, 33656,1044,888, 33655,1043,887, 
3, // chain 176
1012,1297,1012, 908,1078,908, 909,1079,909, 
910,1080,910, 1014,1298,1014, 
6, // chain 177
1063,1299,1063, 1064,1300,1064, 19,19,19, 
20,20,20, 1065,1301,1065, 32789,21,21, 6,6,6, 32773,5,5, 
1, // chain 178
19,19,19, 1064,1300,1064, 18,18,18, 
4, // chain 179
1066,1302,1066, 1064,1300,1064, 1063,1299,1063, 
1065,1301,1065, 6,6,6, 7,7,7, 
4, // chain 180
1067,1303,1067, 101,109,101, 98,103,98, 
99,104,99, 104,114,104, 32855,92,87, 
3, // chain 181
34,107,34, 32,73,32, 74,76,74, 
85,90,85, 96,101,96, 
1, // chain 182
51,51,51, 70,70,70, 48,48,48, 
3, // chain 183
104,114,104, 107,117,107, 101,109,101, 
32812,120,44, 42,110,42, 
1, // chain 184
104,114,104, 101,109,101, 1067,1303,1067, 
1, // chain 185
92,97,92, 78,81,78, 79,83,79, 
7, // chain 186
224,241,224, 225,242,225, 1068,1304,1068, 
33199,478,431, 33198,477,430, 32994,243,226, 429,476,429, 32995,244,227, 228,245,228, 
3, // chain 187
1068,1304,1068, 431,478,431, 432,479,432, 
135,147,135, 32902,146,134, 
2, // chain 188
224,241,224, 1068,1304,1068, 135,147,135, 
206,223,206, 
1, // chain 189
205,222,205, 418,459,418, 204,221,204, 
7, // chain 190
231,248,231, 232,249,232, 480,533,480, 
33247,532,479, 33837,1305,1069, 33001,250,233, 301,325,301, 304,328,304, 33070,326,302, 
2, // chain 191
241,258,241, 1070,1306,1070, 240,257,240, 
33154,419,386, 
6, // chain 192
1071,1307,1071, 268,290,268, 269,291,269, 
1072,1308,1072, 33038,292,270, 392,426,392, 33158,424,390, 33039,293,271, 
3, // chain 193
241,1309,241, 242,1310,242, 267,289,267, 
33034,288,266, 33005,287,237, 
7, // chain 194
241,1309,241, 267,289,267, 268,290,268, 
1070,1311,1070, 33839,1307,1071, 1072,1308,1072, 386,1312,386, 33160,426,392, 393,427,393, 
4, // chain 195
288,312,288, 291,315,291, 287,311,287, 
33841,1313,1073, 33226,509,458, 33060,316,292, 
9, // chain 196
300,1314,300, 214,305,214, 283,307,283, 
1074,1315,1074, 33052,308,284, 285,309,285, 1075,1316,1075, 33844,1317,1076, 33054,310,286, 1073,1313,1073, 33055,311,287, 
1, // chain 197
283,307,283, 214,305,214, 282,306,282, 
6, // chain 198
1077,1318,1077, 310,1319,310, 1075,1316,1075, 
460,511,460, 33227,510,459, 33844,1317,1076, 1073,1313,1073, 458,509,458, 
2, // chain 199
1075,1316,1075, 310,1319,310, 1074,1315,1074, 
33068,1314,300, 
12, // chain 200
309,333,309, 310,334,310, 1077,1320,1077, 
308,332,308, 33846,1321,1078, 1079,1322,1079, 33848,1323,1080, 1081,1324,1081, 33091,347,323, 324,348,324, 325,349,325, 1079,1322,1079, 33075,331,307, 33074,330,306, 
1, // chain 201
1079,1322,1079, 307,331,307, 308,332,308, 
7, // chain 202
1078,1325,1078, 1077,1318,1077, 460,511,460, 
461,512,461, 1080,1326,1080, 33230,513,462, 323,1327,323, 33172,443,404, 33171,441,403, 
2, // chain 203
1069,1305,1069, 304,328,304, 318,342,318, 
479,532,479, 
1, // chain 204
358,1328,358, 329,353,329, 330,354,330, 
1, // chain 205
335,407,335, 327,387,327, 359,388,359, 
12, // chain 206
387,421,387, 272,294,272, 273,295,273, 
425,1329,425, 33194,1330,426, 33042,296,274, 427,1331,427, 33850,1332,1082, 33043,297,275, 276,298,276, 277,299,277, 383,1333,383, 382,1334,382, 427,1331,427, 
3, // chain 207
385,418,385, 386,419,386, 393,1335,393, 
415,1336,415, 33162,1337,394, 
1, // chain 208
384,417,384, 385,418,385, 415,1336,415, 
3, // chain 209
1083,1338,1083, 469,520,469, 199,216,199, 
407,446,407, 32968,217,200, 
1, // chain 210
394,430,394, 391,1339,391, 396,431,396, 
9, // chain 211
1084,1340,1084, 1085,1341,1085, 443,490,443, 
454,529,454, 372,1342,372, 396,1343,396, 1085,1341,1085, 33159,1344,391, 388,497,388, 442,489,442, 443,490,443, 
1, // chain 212
382,456,382, 416,457,416, 427,1345,427, 
13, // chain 213
415,455,415, 394,430,394, 414,454,414, 
33854,1346,1086, 33163,429,395, 397,433,397, 399,436,399, 473,524,473, 414,454,414, 33181,453,413, 33242,525,474, 1083,1338,1083, 33236,519,468, 33235,518,467, 466,517,466, 
2, // chain 214
412,452,412, 413,453,413, 1083,1338,1083, 
407,446,407, 
1, // chain 215
1083,1338,1083, 468,519,468, 469,520,469, 
6, // chain 216
376,409,376, 377,410,377, 1087,1347,1087, 
405,1348,405, 375,408,375, 33108,1349,340, 336,1350,336, 335,407,335, 
2, // chain 217
1087,1347,1087, 377,410,377, 451,500,451, 
33146,411,378, 
1, // chain 218
452,501,452, 454,505,454, 450,499,450, 
1, // chain 219
443,490,443, 444,491,444, 445,492,445, 
2, // chain 220
404,1351,404, 405,1352,405, 322,346,322, 
323,347,323, 
2, // chain 221
322,346,322, 405,1352,405, 1087,1353,1087, 
451,534,451, 
2, // chain 222
489,544,489, 500,555,500, 502,557,502, 
488,543,488, 
1, // chain 223
490,545,490, 491,546,491, 505,560,505, 
1, // chain 224
505,560,505, 494,549,494, 496,551,496, 
1, // chain 225
520,575,520, 521,576,521, 526,581,526, 
2, // chain 226
573,628,573, 574,629,574, 621,679,621, 
572,627,572, 
3, // chain 227
603,661,603, 606,664,606, 545,1354,545, 
33856,1355,1088, 33375,665,607, 
1, // chain 228
545,1354,545, 1088,1355,1088, 547,1356,547, 
1, // chain 229
642,703,642, 644,706,644, 659,726,659, 
2, // chain 230
548,731,548, 660,730,660, 650,961,650, 
549,1357,549, 
1, // chain 231
538,735,538, 536,737,536, 663,734,663, 
1, // chain 232
671,996,671, 700,997,700, 672,1358,672, 
1, // chain 233
566,621,566, 567,622,567, 679,798,679, 
1, // chain 234
668,994,668, 667,794,667, 705,793,705, 
3, // chain 235
710,815,710, 717,814,717, 716,1359,716, 
33466,781,698, 683,783,683, 
1, // chain 236
720,821,720, 721,822,721, 722,825,722, 
1, // chain 237
720,821,720, 693,773,693, 694,774,694, 
8, // chain 238
821,959,821, 777,895,777, 778,897,778, 
739,898,739, 738,1360,738, 1089,1361,1089, 33587,957,819, 33504,1362,736, 734,947,734, 815,950,815, 
3, // chain 239
755,862,755, 757,864,757, 765,873,765, 
754,861,754, 33534,875,766, 
3, // chain 240
807,935,807, 822,1363,822, 780,903,780, 
33532,1364,764, 762,902,762, 
1, // chain 241
807,935,807, 780,903,780, 781,904,781, 
1, // chain 242
802,928,802, 808,936,808, 801,927,801, 
1, // chain 243
727,954,727, 818,956,818, 816,951,816, 
1, // chain 244
1089,1361,1089, 819,957,819, 821,959,821, 
2, // chain 245
761,901,761, 759,1365,759, 768,881,768, 
33526,878,758, 
1, // chain 246
791,942,791, 812,943,812, 813,944,813, 
1, // chain 247
830,977,830, 883,1037,883, 828,975,828, 
1, // chain 248
824,969,824, 823,968,823, 871,1025,871, 
1, // chain 249
571,626,571, 572,627,572, 873,1027,873, 
1, // chain 250
882,1036,882, 832,979,832, 881,1035,881, 
3, // chain 251
826,971,826, 827,973,827, 635,693,635, 
823,968,823, 33404,694,636, 
3, // chain 252
635,693,635, 827,973,827, 1090,1366,1090, 
1091,1367,1091, 634,692,634, 
2, // chain 253
891,1049,891, 893,1052,893, 1061,1292,1061, 
890,1048,890, 
3, // chain 254
892,1294,892, 824,1368,824, 871,1075,871, 
905,1074,905, 906,1076,906, 
5, // chain 255
922,1369,922, 837,1370,837, 944,1127,944, 
934,1371,934, 33713,1128,945, 925,1372,925, 33694,1129,926, 
2, // chain 256
944,1127,944, 837,1370,837, 864,1373,864, 
865,1126,865, 
2, // chain 257
954,1145,954, 947,1131,947, 924,1374,924, 
702,1144,702, 
1, // chain 258
924,1374,924, 947,1131,947, 867,1132,867, 
1, // chain 259
702,790,702, 924,1100,924, 701,789,701, 
2, // chain 260
612,670,612, 613,671,613, 869,1023,869, 
33382,672,614, 
4, // chain 261
928,1375,928, 930,1113,930, 956,1149,956, 
33704,1116,936, 955,1146,955, 33705,1117,937, 
3, // chain 262
928,1375,928, 956,1149,956, 957,1150,957, 
918,1093,918, 919,1094,919, 
1, // chain 263
934,1112,934, 925,1376,925, 931,1111,931, 
5, // chain 264
938,1118,938, 939,1119,939, 953,1377,953, 
704,1378,704, 847,1379,847, 846,1147,846, 937,1117,937, 
1, // chain 265
703,1143,703, 704,1380,704, 953,1142,953, 
3, // chain 266
997,1192,997, 996,1191,996, 991,1186,991, 
992,1187,992, 993,1188,993, 
2, // chain 267
984,1177,984, 985,1178,985, 1028,1231,1028, 
995,1381,995, 
2, // chain 268
1031,1236,1031, 1035,1240,1035, 1029,1232,1029, 
1030,1235,1030, 
6, // chain 269
1049,1267,1049, 1050,1268,1050, 1037,1382,1037, 
1038,1383,1038, 1092,1384,1092, 33825,1287,1057, 1048,1266,1048, 1049,1267,1049, 
5, // chain 270
1037,1382,1037, 1050,1268,1050, 964,1385,964, 
33731,1386,963, 33730,1282,962, 33820,1270,1052, 33819,1269,1051, 
1, // chain 271
991,1186,991, 1011,1209,1011, 966,1159,966, 
2, // chain 272
983,1278,983, 1059,1279,1059, 976,1169,976, 
33743,1168,975, 
1, // chain 273
983,1278,983, 976,1169,976, 977,1170,977, 
1, // chain 274
998,1193,998, 997,1192,997, 1025,1283,1025, 
1, // chain 275
887,1043,887, 1034,1295,1034, 886,1042,886, 

 0};


// mesh info for object bunny_fig_small (with tag [ | o Bunny | usemtl wire_115115115])
const tgx::Mesh3D<tgx::RGB565> bunny_fig_small PROGMEM = 
    {
    1, // version/id
    
    1093, // number of vertices
    1387, // number of texture coords
    1093, // number of normal vectors
    2104, // number of triangles
    8245, // size of the face array. 

    bunny_fig_small_vert_array, // array of vertices
    bunny_fig_small_tex_array, // array of texture coords
    bunny_fig_small_norm_array, // array of normal vectors        
    bunny_fig_small_face, // array of face vertex indexes   
    
    &bunny_fig_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    nullptr, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.537993717460173f, 0.537993717460173f, 
    -0.9999999999999998f, 1.0f, 
    -0.4573021619444595f, 0.4573021619444595f
    },
    
    "bunny_fig_small" // model name    
    };
    
                
/** end of bunny_fig_small.h */
    
    
    