/** @file font_tgx_Arial.cpp */
//
// Copyright 2020 Arvind Singh
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; If not, see <http://www.gnu.org/licenses/>.
#include "font_tgx_Arial.h"

static const unsigned char font_tgx_Arial_8_data[] = {
0x00,0x00,0x18,0x03,0x00,0x16,0x44,0x06,0x62,0xA4,
0xD0,0x0B,0x00,0x34,0x15,0xF8,0x53,0xF1,0x40,0x0B,
0x27,0xB1,0xCA,0xA8,0x74,0x15,0x53,0x84,0x13,0x00,
0x51,0x89,0x12,0x83,0x40,0x16,0x81,0x48,0x8C,0x0D,
0x00,0x38,0xC8,0x48,0x61,0x44,0x68,0x8E,0x80,0x02,
0x62,0x94,0xC0,0x07,0x47,0x20,0x96,0x42,0x10,0x07,
0x47,0x22,0x16,0x12,0x40,0x06,0x82,0x21,0x39,0x28,
0x0A,0xA0,0xB4,0x11,0xF8,0x20,0x02,0x6F,0x1C,0xC0,
0x06,0x21,0x23,0x80,0x02,0x28,0x1A,0x07,0x00,0x1C,
0x1A,0x51,0x00,0x0B,0x00,0x31,0xD9,0x13,0x80,0x07,
0x00,0x30,0x9A,0xD9,0x0B,0x00,0x31,0xC8,0xC0,0x42,
0x10,0x87,0xC0,0x0B,0x00,0x31,0xC8,0x82,0x34,0x05,
0x13,0x80,0x0B,0x00,0x30,0x43,0x42,0x92,0x7E,0x04,
0x0B,0x00,0x31,0xE4,0x20,0xF4,0x05,0x13,0x80,0x0B,
0x00,0x31,0xC8,0xA0,0xF4,0xC4,0xE0,0x0B,0x00,0x33,
0xF0,0x28,0x24,0xA0,0x0B,0x00,0x31,0xD1,0x13,0xA6,
0x27,0x00,0x0B,0x00,0x31,0xD3,0x13,0xC1,0x44,0xE0,
0x02,0xC0,0x1B,0x44,0x03,0x07,0x1B,0x49,0x80,0x0A,
0xA0,0xB0,0x27,0x20,0x70,0x20,0x0A,0x61,0x33,0xE0,
0x3E,0x0A,0xA0,0xB2,0x07,0x02,0x72,0x00,0x0B,0x00,
0x31,0xC8,0x82,0x14,0x10,0x01,0x00,0x15,0x47,0x58,
0x7C,0x30,0x44,0xD5,0x26,0xC5,0x12,0xA6,0x93,0x61,
0x01,0x1F,0xC0,0x0F,0x00,0x40,0x44,0x94,0x22,0x3E,
0x88,0x20,0x0D,0x00,0x3B,0xE8,0x85,0xFC,0xC2,0xF8,
0x0D,0x00,0x38,0xE2,0x35,0x01,0x11,0xC0,0x0D,0x00,
0x3B,0xC4,0x55,0x0A,0x27,0x80,0x0B,0x00,0x33,0xF1,
0x07,0xE6,0x0F,0x80,0x0B,0x00,0x33,0xF1,0x07,0xAA,
0x00,0x0F,0x00,0x40,0xE1,0x12,0x0A,0x02,0x3A,0x09,
0x10,0xE0,0x0D,0x00,0x3C,0xC2,0xFE,0xA1,0x03,0x00,
0x16,0xD0,0x09,0x00,0x2D,0x8C,0x49,0x80,0x0D,0x00,
0x3A,0x14,0x49,0x16,0x34,0x88,0x90,0x80,0x0B,0x00,
0x36,0xC1,0xF0,0x0F,0x00,0x42,0x0C,0x63,0x9A,0xB1,
0x24,0x0D,0x00,0x3A,0x16,0x31,0x4C,0x4A,0x8D,0x08,
0x0F,0x00,0x40,0xE1,0x15,0x41,0x22,0x1C,0x0B,0x00,
0x33,0xD3,0x17,0xA6,0x00,0x0F,0x00,0x40,0xE1,0x14,
0xC1,0x4D,0x22,0x1F,0x0D,0x00,0x3B,0xE8,0x85,0xF2,
0x48,0x89,0x08,0x0D,0x00,0x39,0xE4,0x28,0x0C,0x06,
0x02,0x84,0xF0,0x0B,0x00,0x33,0xFA,0x40,0x0D,0x00,
0x3E,0xC2,0x78,0x0F,0x00,0x44,0x41,0x84,0x50,0x52,
0x04,0x00,0x17,0x18,0x52,0x10,0xA2,0x8C,0x25,0x28,
0x51,0x50,0x41,0x00,0x0D,0x00,0x3A,0x18,0x4A,0x0C,
0x84,0x90,0x80,0x0F,0x00,0x42,0x0C,0x22,0x14,0xA1,
0x00,0x0D,0x00,0x39,0xF0,0x50,0x24,0x10,0x41,0xF8,
0x05,0x47,0x1B,0xD9,0x30,0x07,0x00,0x1C,0x4A,0x50,
0x40,0x05,0x47,0x1B,0xD4,0xB0,0x0A,0x82,0x28,0x90,
0xA4,0x40,0x0C,0x27,0x33,0xF0,0x04,0x43,0x22,0x20,
0x0A,0xC0,0x31,0xC8,0x9E,0x8A,0x6E,0x80,0x0B,0x00,
0x34,0x41,0x66,0x62,0x2C,0xAC,0x0A,0xC0,0x31,0xC8,
0xC4,0x11,0x38,0x0B,0x00,0x34,0x04,0xD4,0xE2,0x29,
0x9A,0x0A,0xC0,0x31,0xC8,0xBE,0x82,0x27,0x00,0x07,
0x00,0x20,0x93,0xDA,0x0B,0x07,0x31,0xA9,0xC4,0x53,
0x34,0x17,0x80,0x0B,0x00,0x34,0x41,0x66,0x6A,0x20,
0x03,0x00,0x12,0x64,0x05,0x5F,0x11,0x1A,0xA0,0x09,
0x00,0x2C,0x42,0x54,0xC7,0x29,0x20,0x03,0x00,0x16,
0xD0,0x0E,0xC0,0x42,0xF3,0x4D,0x49,0x0A,0xC0,0x33,
0xD7,0x10,0x0A,0xC0,0x31,0xD5,0x13,0x80,0x0B,0x07,
0x32,0xCC,0xC4,0x59,0x5A,0x20,0x0B,0x07,0x31,0xA9,
0xC4,0x53,0x36,0x02,0x06,0xC0,0x22,0xB5,0x40,0x0A,
0xC0,0x31,0xC8,0x98,0x12,0x27,0x00,0x07,0x18,0x1C,
0x27,0xA4,0x60,0x0A,0xC0,0x35,0x45,0x33,0x40,0x0A,
0xC0,0x34,0x46,0x15,0x04,0x12,0xC0,0x52,0x22,0x94,
0xC2,0xAA,0x08,0x80,0x0A,0xC0,0x32,0x25,0x41,0x0A,
0x44,0x0B,0x07,0x34,0x46,0x15,0x24,0x20,0x0A,0xC0,
0x33,0xE1,0x41,0x08,0x7C,0x07,0x47,0x20,0xCA,0x4A,
0x42,0x03,0x47,0x16,0xE6,0x07,0x4F,0x22,0x4A,0x1A,
0x48,0x0A,0x42,0x33,0xAB,0x00,};
/* font data size: 656 bytes */

static const unsigned char font_tgx_Arial_8_index[] = {
0x00,0x00,0x30,0x1C,
0x0B,0x04,0xC1,0xC0,0x9C,0x31,0x0D,0x43,0xB1,0x04,
0x46,0x13,0x05,0x01,0x50,0x57,0x17,0x46,0x31,0xA0,
0x71,0x1E,0x88,0x22,0x2C,0x93,0x26,0x8A,0x22,0xA8,
0xAE,0x2C,0xCB,0xA2,0xFC,0xC6,0x33,0xCD,0xF3,0xA0,
0xF0,0x3E,0x10,0x04,0x21,0x0F,0x46,0x92,0x04,0x91,
0x2A,0x4D,0x13,0x95,0x05,0x4A,0x54,0x95,0x95,0x89,
0x6B,0x5D,0x57,0xA5,0xFD,0x88,0x65,0x19,0xD6,0x95,
0xAE,0x6C,0xDB,0x96,0xF9,0xC4,0x72,0x1C,0xC7,0x51,
0xDC,0x78,0xDE,0xB7,0xCD,0xF8,0x80,0x60,0x88,0x32,
0x11,0x86,0x61,0xD8,0x8E,0x28,0x8B,0xA3,0x68,0xFA,
0x43,0x92,0xE5,0x19,0x5E,0x5D,0x99,0xA6,0xD9,0xD2,
0x7B,0xA0,0x68,0x5A,0x2C,
};
/* font index size: 119 bytes */

const ILI9341_t3_font_t font_tgx_Arial_8 = {
	font_tgx_Arial_8_index,
	0,
	font_tgx_Arial_8_data,
	1,
	0,
	32,
	126,
	0,
	0,
	10,
	4,
	4,
	2,
	4,
	4,
	11,
	8
};



static const unsigned char font_tgx_Arial_9_data[] = {
0x00,0x00,0x08,0x03,0x44,0x07,0xB4,0x40,0x06,0x64,
0xEB,0x34,0x11,0x40,0x0F,0x02,0x42,0x27,0xFC,0x12,
0x3F,0xE5,0x20,0x0B,0x67,0xEE,0x72,0xB1,0x47,0x07,
0x16,0x2A,0x70,0x80,0x15,0x44,0x18,0x61,0x22,0x48,
0x4A,0x06,0x40,0x13,0x02,0x98,0x12,0x44,0x30,0x11,
0x44,0x12,0x30,0x94,0x81,0x81,0x81,0x24,0x8A,0x46,
0x1C,0xC0,0x02,0x64,0xE5,0x30,0x07,0xA7,0xA8,0x30,
0xB6,0x42,0x10,0x07,0xA3,0xA8,0x90,0xB4,0xC2,0x40,
0x0A,0x80,0xCA,0x23,0xE2,0x14,0x0E,0xE4,0x31,0x22,
0x1F,0xE4,0x40,0x02,0x6B,0xC9,0x30,0x06,0x20,0x68,
0xE0,0x02,0x24,0x08,0x80,0x09,0x40,0x09,0x03,0x25,
0x29,0x10,0x0D,0x40,0x0E,0x7B,0x61,0x42,0x78,0x07,
0x44,0x0E,0x26,0xBA,0x40,0x0D,0x40,0x0E,0x79,0x0C,
0x82,0x08,0x20,0x82,0x0F,0xC0,0x0D,0x40,0x0E,0x79,
0x0C,0x02,0x3A,0x41,0x42,0x78,0x0D,0x40,0x0E,0x0A,
0x06,0x82,0xA1,0x27,0xF0,0x10,0x0D,0x40,0x0E,0x7E,
0x10,0x40,0xF9,0x0C,0x02,0x84,0xF0,0x0D,0x40,0x0E,
0x79,0x0C,0x40,0xB9,0x8C,0xC2,0x78,0x0D,0x40,0x0E,
0xFE,0x02,0x81,0x20,0x89,0x40,0x0D,0x40,0x0E,0x7A,
0x61,0x3D,0x50,0x9E,0x0D,0x40,0x0E,0x7A,0x61,0x46,
0x76,0x01,0x44,0x70,0x02,0xE4,0x08,0xD9,0x03,0x27,
0xC8,0xDA,0x60,0x0C,0xE4,0x30,0x04,0x31,0x84,0x06,
0x03,0x01,0x0E,0x80,0x70,0xFF,0x00,0x1F,0xC0,0x0C,
0xE4,0x30,0x80,0xC0,0x60,0x21,0x8C,0x20,0x0B,0x44,
0x0E,0x74,0x44,0x10,0x84,0x84,0x00,0x40,0x19,0xA3,
0xBA,0x0F,0x81,0x82,0x10,0x08,0x9D,0x29,0x19,0x50,
0x4A,0x84,0x54,0x24,0xA3,0x24,0xEE,0x10,0x04,0x40,
0xC1,0xF8,0x13,0x40,0x12,0x08,0x48,0xA2,0x08,0x87,
0xF1,0x05,0x10,0x10,0x0F,0x44,0x12,0xFD,0x30,0x5F,
0xAA,0x0B,0xF0,0x0F,0x44,0x12,0x38,0x44,0x83,0x50,
0x10,0x48,0x87,0x00,0x0F,0x44,0x12,0xF8,0x85,0x90,
0x50,0x9F,0x00,0x0F,0x44,0x12,0xFF,0x30,0x1F,0xEA,
0x03,0xF8,0x0D,0x44,0x10,0xFE,0x60,0x7D,0x70,0x00,
0x11,0x44,0x14,0x3C,0x21,0x20,0x62,0x01,0x1F,0x10,
0x24,0x21,0xE0,0x0F,0x44,0x13,0x50,0x5F,0xEE,0x08,
0x03,0x44,0x07,0xB9,0x80,0x0B,0x40,0x0D,0xA1,0x88,
0x9C,0x11,0x44,0x12,0x81,0x41,0x21,0x11,0x09,0x05,
0x83,0x21,0x08,0x82,0x40,0x80,0x0D,0x44,0x0F,0xB0,
0x44,0x0F,0xC0,0x13,0x44,0x16,0x80,0xC6,0x0E,0x28,
0xB3,0x29,0x88,0x88,0x0F,0x44,0x12,0x82,0xC3,0x14,
0x62,0x4C,0x45,0x43,0x41,0x11,0x44,0x14,0x3C,0x21,
0x64,0x09,0x08,0x78,0x0F,0x44,0x12,0xFD,0x50,0x5F,
0xAA,0x00,0x11,0x47,0xF4,0x3C,0x21,0x5C,0x0A,0x34,
0x84,0x3D,0x0F,0x44,0x12,0xFD,0x50,0x5F,0x91,0x22,
0x12,0x08,0x0F,0x44,0x12,0x7D,0x10,0x50,0x0E,0x01,
0x80,0x62,0x09,0xF0,0x0F,0x40,0x0E,0xFF,0xA2,0x20,
0x40,0x0F,0x44,0x13,0xB0,0x50,0x48,0x87,0x00,0x13,
0x40,0x13,0x10,0x18,0x41,0x41,0x12,0x05,0x10,0x10,
0x1B,0x40,0x1A,0x82,0x0A,0x14,0x32,0x8A,0x29,0x28,
0xA4,0x08,0x20,0x0F,0x40,0x0E,0x83,0x08,0x85,0x20,
0x40,0xA4,0x22,0x41,0x0F,0x44,0x12,0x83,0x08,0xA0,
0xA5,0x88,0x0F,0x40,0x0E,0x7E,0x05,0x01,0x20,0x44,
0x10,0x20,0x7F,0x05,0xA7,0xA8,0xF6,0xA9,0x80,0x09,
0x40,0x09,0x11,0x29,0x25,0x02,0x05,0xA7,0xA8,0xF5,
0xA5,0x80,0x0A,0xA0,0x8A,0x24,0xA9,0x10,0x0E,0x23,
0xAE,0xFE,0x04,0x45,0x08,0x88,0x0A,0xE4,0x0E,0x72,
0x20,0x9E,0x8A,0x66,0x80,0x0B,0x44,0x0F,0x30,0x59,
0x9A,0x8B,0xC0,0x0A,0xE4,0x0E,0x72,0x33,0x04,0x4E,
0x0B,0x44,0x0F,0x21,0x35,0x39,0x8A,0x66,0x80,0x0A,
0xE4,0x0E,0x74,0x45,0xF4,0x11,0x38,0x09,0x40,0x06,
0x38,0x47,0x62,0x00,0x0B,0x47,0xAE,0x6A,0x73,0x14,
0xCD,0x05,0x13,0x80,0x0B,0x44,0x0F,0x30,0x59,0x9B,
0x88,0x03,0x44,0x06,0xC3,0x60,0x07,0xBF,0xA6,0x30,
0x34,0xC1,0x60,0x0B,0x44,0x0F,0x30,0x45,0x25,0x1C,
0x89,0x22,0x03,0x44,0x07,0xB9,0x80,0x12,0xE4,0x16,
0xB3,0x33,0x37,0x11,0x0A,0xE4,0x0E,0xB3,0x37,0x10,
0x0A,0xE4,0x0E,0x75,0xC4,0xE0,0x0B,0x47,0xAE,0xB3,
0x33,0x16,0x56,0x98,0x00,0x0B,0x47,0xAE,0x6A,0x73,
0x14,0xCD,0x90,0x80,0x06,0xE4,0x08,0xAD,0x70,0x0A,
0xE4,0x0E,0x72,0x28,0x1C,0x0A,0x27,0x00,0x07,0x20,
0x09,0x09,0xED,0x18,0x0A,0xE4,0x0F,0x91,0x3C,0x0A,
0xE0,0x0B,0x11,0x95,0x41,0x00,0x12,0xE0,0x13,0x11,
0x19,0x55,0x41,0x10,0x0A,0xE4,0x0E,0x8C,0x28,0x48,
0x52,0x20,0x0B,0x47,0xAF,0x11,0x95,0x51,0x18,0x0A,
0xE4,0x0E,0xFC,0x08,0x48,0x43,0xE0,0x07,0xA3,0xA8,
0x36,0x92,0xD0,0x80,0x03,0x87,0xC7,0xBB,0x80,0x07,
0xA7,0xA8,0x96,0x86,0xD2,0x00,0x0E,0x40,0x90,0x72,
0x9E,};
/* font data size: 771 bytes */

static const unsigned char font_tgx_Arial_9_index[] = {
0x00,0x00,0x30,0x20,0x0C,0x05,0xC2,0x20,0xC4,
0x3E,0x10,0x84,0x91,0x40,0x56,0x17,0x46,0x11,0x94,
0x69,0x1C,0x07,0x71,0xF4,0x88,0x24,0x89,0xC2,0x9C,
0xB1,0x2E,0x8C,0x23,0x30,0xD0,0x35,0x4D,0xE3,0x94,
0xEE,0x3E,0x11,0x04,0x71,0x25,0x4C,0x13,0x95,0x09,
0x4A,0x55,0xD5,0xE5,0x8D,0x69,0x5E,0x17,0xF6,0x29,
0x95,0x67,0x9A,0x66,0xC1,0xBA,0x71,0x9C,0xD7,0x55,
0xE0,0x7B,0x5F,0x88,0x02,0x0B,0x84,0x61,0x88,0x7A,
0x24,0x8A,0x22,0xC8,0xD6,0x3D,0x91,0x24,0xD9,0x56,
0x5C,0x99,0xA6,0xD9,0xCA,0x79,0xA0,0xA8,0x7A,0x3A,
0x94,0xA6,0xAA,0x3A,0xB2,0xB1,0xAE,0xAC,0x0B,0x16,
0xCC,0xB5,0x2D,0xCB,0x8E,0xEB,0xBC,0xAF,0x7B,0xF8,
};
/* font index size: 119 bytes */

const ILI9341_t3_font_t font_tgx_Arial_9 = {
	font_tgx_Arial_9_index,
	0,
	font_tgx_Arial_9_data,
	1,
	0,
	32,
	126,
	0,
	0,
	10,
	4,
	4,
	3,
	5,
	4,
	13,
	10
};



static const unsigned char font_tgx_Arial_10_data[] = {
0x00,0x00,0x08,0x03,0x48,0x0B,0xB4,0x40,0x06,0x84,
0xCB,0x54,0x11,0x40,0x11,0x02,0x42,0x47,0xFC,0x12,
0x3F,0xE5,0x20,0x0F,0x83,0xF0,0x10,0x3C,0x53,0x12,
0x0E,0x03,0xA0,0x4A,0x51,0xE0,0x40,0x15,0x44,0x18,
0x61,0x22,0x48,0x4A,0x06,0x40,0x13,0x02,0x98,0x12,
0x44,0x30,0x11,0x44,0x12,0x38,0x84,0x42,0x40,0xC0,
0xA0,0x8A,0x42,0x21,0x8F,0x20,0x02,0x84,0xC7,0x50,
0x07,0xA7,0xAA,0x30,0xB6,0x42,0x10,0x07,0xA7,0xAA,
0x90,0xB4,0xC2,0x40,0x0A,0x80,0xCA,0x23,0xE2,0x14,
0x0E,0xE4,0x31,0x22,0x1F,0xE4,0x40,0x02,0x6B,0xC9,
0x30,0x08,0x20,0x6A,0xF0,0x02,0x28,0x08,0x80,0x09,
0x40,0x09,0x03,0x25,0x29,0x10,0x0D,0x44,0x10,0x7B,
0x61,0x42,0x78,0x07,0x48,0x10,0x26,0xBA,0x40,0x0D,
0x44,0x10,0x7A,0x21,0x80,0x41,0x04,0x10,0x41,0xF8,
0x0D,0x44,0x10,0x7A,0x21,0x02,0x3A,0x01,0x88,0x4F,
0x00,0x0F,0x40,0x10,0x04,0x0C,0x15,0x04,0x88,0x90,
0x9F,0xE0,0x10,0x0D,0x44,0x10,0x7C,0x82,0x07,0xC8,
0x60,0x14,0x28,0x8F,0x00,0x0D,0x44,0x10,0x38,0x8C,
0x40,0xB9,0x8C,0xC2,0x78,0x0D,0x44,0x10,0xFC,0x0C,
0x05,0x22,0x49,0x00,0x0D,0x44,0x10,0x7A,0x61,0x3D,
0x50,0x9E,0x0D,0x44,0x10,0x7A,0x61,0x46,0x76,0x01,
0x44,0x70,0x03,0x04,0x08,0xE1,0x03,0x47,0xC8,0xE2,
0x60,0x0C,0xE4,0x30,0x04,0x31,0x84,0x06,0x03,0x01,
0x0C,0x84,0x70,0xFE,0x00,0x7E,0x0C,0xE4,0x30,0x80,
0xC0,0x60,0x21,0x8C,0x20,0x0D,0x44,0x10,0x7A,0x21,
0x02,0x08,0x24,0x10,0x00,0x40,0x1B,0xA3,0xBC,0x0F,
0xC0,0xC0,0x84,0x01,0x11,0xD2,0x88,0xCA,0x41,0x29,
0x08,0xA4,0x24,0x91,0x91,0x3B,0x84,0x00,0x8C,0x0C,
0x0F,0xC0,0x13,0x40,0x12,0x08,0x48,0xA2,0x08,0x87,
0xF1,0x05,0x10,0x10,0x0F,0x44,0x12,0xFD,0x30,0x5F,
0xAA,0x0B,0xF0,0x11,0x44,0x14,0x3C,0x21,0x20,0x6A,
0x01,0x02,0x42,0x1E,0x00,0x11,0x44,0x14,0xFC,0x41,
0x64,0x0A,0x09,0xF8,0x0F,0x44,0x12,0xFF,0x30,0x1F,
0xEA,0x03,0xF8,0x0F,0x44,0x12,0xFF,0x30,0x1F,0xAE,
0x00,0x13,0x44,0x16,0x3E,0x10,0x48,0x0C,0x40,0x10,
0xF8,0x80,0x90,0x43,0xE0,0x0F,0x44,0x13,0x50,0x5F,
0xEE,0x08,0x03,0x44,0x07,0xB9,0x80,0x0B,0x40,0x0D,
0xA1,0x88,0x9C,0x11,0x44,0x12,0x81,0x41,0x21,0x11,
0x09,0x05,0x43,0x11,0x08,0x82,0x40,0x80,0x0F,0x44,
0x11,0xB0,0x22,0x03,0xF8,0x13,0x44,0x16,0x80,0xC6,
0x0E,0x28,0xB3,0x29,0x88,0x88,0x0F,0x44,0x12,0x82,
0xC3,0x14,0x62,0x4C,0x45,0x43,0x41,0x13,0x44,0x16,
0x3E,0x10,0x59,0x01,0x20,0x87,0xC0,0x0F,0x44,0x12,
0xFD,0x50,0x5F,0xAA,0x00,0x13,0x47,0xF6,0x3E,0x10,
0x57,0x01,0x42,0x88,0x61,0xEC,0x11,0x44,0x14,0xFE,
0xA8,0x17,0xF2,0x21,0x08,0x82,0x40,0x80,0x0F,0x44,
0x12,0x7D,0x10,0x50,0x0E,0x01,0xC0,0x62,0x09,0xF0,
0x0F,0x44,0x12,0xFF,0xA2,0x20,0x40,0x0F,0x44,0x13,
0xB0,0x50,0x48,0x87,0x00,0x13,0x40,0x13,0x10,0x18,
0x41,0x41,0x12,0x05,0x10,0x10,0x1B,0x40,0x1A,0x82,
0x0A,0x14,0x32,0x8A,0x29,0x28,0xA4,0x08,0x20,0x11,
0x40,0x10,0x81,0x84,0x21,0x24,0x0C,0x09,0x21,0x09,
0x02,0x13,0x40,0x12,0x80,0x90,0x50,0x44,0x0A,0x2C,
0x20,0x11,0x40,0x10,0x7F,0x01,0x40,0x20,0x20,0x21,
0x04,0x04,0x07,0xF8,0x05,0xA7,0xA8,0xF6,0xA9,0x80,
0x09,0x40,0x09,0x11,0x29,0x25,0x02,0x05,0xA7,0xA8,
0xF5,0xA5,0x80,0x0A,0xA0,0xAA,0x24,0xA9,0x10,0x10,
0x23,0xB0,0xFF,0x04,0x45,0x0A,0x88,0x0D,0x04,0x10,
0x79,0x08,0x11,0xE4,0x50,0xA3,0x3A,0x0D,0x44,0x11,
0x10,0x2E,0x63,0x50,0xB1,0x5C,0x0B,0x04,0x0E,0x72,
0x35,0x04,0x4E,0x0D,0x44,0x11,0x00,0x9D,0x47,0x50,
0xA3,0x3A,0x0D,0x04,0x10,0x7A,0x21,0x7F,0x10,0x21,
0x3C,0x09,0x40,0x08,0x32,0x3F,0x50,0x0D,0x67,0xB0,
0x75,0x1D,0x42,0x8C,0xE8,0x14,0x27,0x80,0x0D,0x44,
0x11,0x10,0x2E,0x63,0x90,0x80,0x03,0x44,0x06,0x9B,
0x40,0x07,0xBF,0xA6,0x21,0xA6,0x4B,0x00,0x0D,0x44,
0x0F,0x10,0x21,0x44,0x91,0x43,0x48,0x89,0x08,0x03,
0x44,0x07,0xB9,0x80,0x13,0x04,0x16,0xB7,0x33,0x39,
0x11,0x0D,0x04,0x10,0xB9,0x8E,0x42,0x0D,0x04,0x10,
0x7B,0x21,0x3C,0x0D,0x67,0xB0,0xB9,0x8D,0x42,0xC5,
0x74,0xC0,0x0D,0x67,0xB0,0x75,0x1D,0x42,0x8C,0xEC,
0x82,0x09,0x04,0x0A,0xB6,0x64,0x00,0x0B,0x04,0x0E,
0x72,0x28,0x1D,0x01,0x44,0xE0,0x09,0x40,0x29,0x08,
0xFC,0x43,0x80,0x0D,0x04,0x11,0x90,0xA3,0x3A,0x0F,
0x00,0x0F,0x10,0x61,0x14,0x14,0x81,0x00,0x13,0x00,
0x13,0x11,0x1A,0x55,0x41,0x10,0x0D,0x00,0x0C,0x86,
0x12,0x83,0x21,0x24,0x20,0x0F,0x63,0xAF,0x10,0x61,
0x14,0x94,0x91,0x06,0x00,0x0D,0x00,0x0C,0xFC,0x14,
0x09,0x04,0x10,0x7E,0x07,0xA7,0xAA,0x36,0x92,0xD0,
0x80,0x03,0xA7,0xA7,0xBC,0x80,0x07,0xA7,0xAA,0x96,
0x86,0xD2,0x00,0x0E,0x40,0x90,0x72,0x9E,};
/* font data size: 808 bytes */

static const unsigned char font_tgx_Arial_10_index[] = {
0x00,0x00,
0x30,0x20,0x0C,0x05,0xC2,0x50,0xD0,0x42,0x11,0x84,
0xD1,0x50,0x5A,0x18,0x46,0x51,0xA4,0x6D,0x1D,0x07,
0xB2,0x04,0x8C,0x25,0xCA,0x32,0xBC,0xB9,0x30,0x8C,
0xA3,0x50,0xD8,0x37,0x4E,0x63,0xB0,0xF5,0x40,0x11,
0xA4,0x99,0x2F,0x4E,0xD4,0x45,0x35,0x55,0x58,0xD6,
0xA5,0xBD,0x75,0x61,0x18,0xB6,0x59,0xA1,0x6A,0xDB,
0x36,0xF9,0xCA,0x75,0x9D,0xD7,0x95,0xF0,0x7F,0x60,
0x98,0x4E,0x20,0x89,0xA2,0xD8,0xCE,0x39,0x8F,0x64,
0x19,0x2E,0x54,0x96,0xE6,0x49,0xB6,0x73,0x9F,0xA8,
0x6A,0x2E,0x92,0xA7,0x6A,0x2A,0xA6,0xAF,0xAD,0x6B,
0xEB,0x1E,0xCD,0xB5,0xAD,0xDB,0x8E,0xEC,0xBD,0x2F,
0xDC,0x1F,0x10,0xC5,0xF1,0xCC,0x8C,
};
/* font index size: 119 bytes */

const ILI9341_t3_font_t font_tgx_Arial_10 = {
	font_tgx_Arial_10_index,
	0,
	font_tgx_Arial_10_data,
	1,
	0,
	32,
	126,
	0,
	0,
	10,
	4,
	4,
	3,
	5,
	4,
	14,
	10
};



static const unsigned char font_tgx_Arial_11_data[] = {
0x00,0x00,0x08,0x03,0x68,0x0B,0xB8,0x88,0x06,0x84,
0xEB,0x54,0x11,0x60,0x11,0x22,0x4F,0xF9,0x24,0x7F,
0xCA,0x40,0x0F,0xA3,0xF0,0x10,0x3C,0x56,0x92,0x90,
0x50,0x38,0x14,0x12,0x92,0x54,0x38,0x10,0x17,0x64,
0x1A,0x60,0x91,0x22,0x22,0x48,0x19,0x34,0x04,0x98,
0x11,0x22,0x0C,0x13,0x64,0x14,0x38,0x4A,0x20,0x50,
0x38,0x22,0x24,0x86,0x21,0x47,0x98,0x02,0x84,0xE7,
0x50,0x07,0xC7,0xAA,0x30,0xB6,0x34,0x21,0x07,0xC7,
0xAA,0x90,0xB4,0xCA,0x40,0x0A,0xA0,0xCC,0x23,0xE2,
0x42,0x80,0x0E,0xE4,0x53,0x22,0x1F,0xE4,0x40,0x02,
0x6B,0xA9,0x30,0x08,0x20,0x6A,0xF0,0x02,0x28,0x08,
0x80,0x09,0x60,0x09,0x03,0x25,0x49,0x10,0x0D,0x64,
0x10,0x7B,0x61,0x88,0x4F,0x00,0x07,0x68,0x10,0x26,
0xBA,0x44,0x0D,0x64,0x10,0x7A,0x21,0x80,0x60,0x20,
0x82,0x08,0x3F,0x0D,0x64,0x10,0x7A,0x21,0x80,0x47,
0x40,0x31,0x09,0xE0,0x0F,0x60,0x10,0x04,0x0C,0x15,
0x04,0x88,0x90,0x9F,0xE4,0x10,0x0D,0x64,0x10,0x7E,
0x10,0x40,0xF9,0x0C,0x02,0x85,0x11,0xE0,0x0D,0x64,
0x10,0x7A,0x21,0x40,0xB9,0x8D,0x42,0x78,0x0D,0x64,
0x10,0xFC,0x0C,0x05,0x22,0x51,0x00,0x0D,0x64,0x10,
0x7A,0xA1,0x3D,0x50,0x9E,0x0D,0x64,0x10,0x7A,0xA1,
0x46,0x74,0x0C,0x42,0x78,0x03,0x04,0x08,0xE1,0x03,
0x47,0xA8,0xE2,0x60,0x0E,0xE4,0x52,0x02,0x1C,0x60,
0x80,0x60,0x1C,0x02,0x0E,0xA4,0x72,0xFF,0x20,0x1F,
0xC0,0x0E,0xE4,0x52,0x80,0x70,0x0C,0x02,0x0C,0x70,
0x80,0x0D,0x64,0x10,0x7A,0x21,0x02,0x08,0x24,0x90,
0x00,0x40,0x1D,0xC3,0xBE,0x07,0xC0,0x30,0x60,0x80,
0x22,0x1D,0x64,0xC6,0x51,0x04,0xC4,0x82,0x29,0x04,
0x91,0x19,0x13,0xDC,0x20,0x02,0x30,0x18,0x1F,0xC0,
0x13,0x60,0x12,0x08,0x48,0xA2,0x08,0x84,0x11,0xFC,
0x41,0x44,0x04,0x11,0x64,0x14,0xFE,0x98,0x14,0x13,
0xFA,0xA0,0x5F,0xC0,0x13,0x64,0x16,0x1E,0x18,0x44,
0x0D,0xC0,0x08,0x13,0x08,0x3C,0x13,0x64,0x16,0xFE,
0x20,0x5B,0x01,0x40,0x9F,0xC0,0x11,0x64,0x14,0xFF,
0xA8,0x07,0xFD,0x40,0x3F,0xC0,0x0F,0x64,0x12,0xFF,
0x50,0x1F,0xAE,0x00,0x13,0x64,0x16,0x3E,0x10,0x48,
0x0C,0x40,0x10,0xF9,0x80,0x90,0x43,0xE0,0x11,0x64,
0x15,0x70,0x2F,0xFB,0x81,0x03,0x64,0x07,0xBA,0x80,
0x0D,0x60,0x0F,0xA0,0x81,0x88,0x4F,0x00,0x13,0x64,
0x14,0x81,0x20,0x88,0x42,0x20,0x90,0x2A,0x0C,0x42,
0x10,0x82,0x20,0x48,0x08,0x0F,0x64,0x11,0xB0,0x26,
0x03,0xF8,0x13,0x64,0x16,0x80,0xC6,0x0E,0x68,0xB3,
0x29,0x88,0x88,0x11,0x64,0x14,0x81,0x60,0xC5,0x0C,
0x48,0xA2,0x62,0x15,0x06,0x81,0x15,0x64,0x18,0x1E,
0x0C,0x31,0x02,0xB8,0x04,0x81,0x18,0x60,0xF0,0x11,
0x64,0x14,0xFE,0xA8,0x17,0xF5,0xC0,0x00,0x15,0x67,
0xF8,0x1E,0x0C,0x31,0x02,0xB8,0x04,0x8D,0x18,0x60,
0xF2,0x13,0x64,0x16,0xFF,0x54,0x05,0xFE,0x42,0x22,
0x08,0x81,0x20,0x20,0x11,0x64,0x14,0x3C,0x21,0x20,
0x50,0x0F,0x00,0x74,0x00,0xA0,0x58,0x43,0xC0,0x13,
0x60,0x12,0xFF,0xE8,0x42,0x42,0x00,0x11,0x64,0x15,
0xB0,0x31,0x02,0x42,0x1E,0x00,0x13,0x60,0x13,0x10,
0x18,0x41,0x49,0x12,0x05,0x10,0x10,0x1F,0x60,0x1E,
0x81,0x02,0x82,0x83,0x08,0x50,0xA1,0x11,0x10,0x91,
0x24,0x14,0x14,0x81,0x01,0x00,0x13,0x60,0x12,0x80,
0x90,0x50,0x44,0x0A,0x01,0x80,0xA2,0x08,0x84,0x12,
0x02,0x13,0x60,0x12,0x80,0x90,0x50,0x44,0x0A,0x30,
0x20,0x11,0x60,0x10,0x7F,0x01,0x40,0x20,0x22,0x04,
0x20,0x80,0x80,0xFF,0x07,0xC7,0xA8,0xFB,0x2E,0x38,
0x09,0x60,0x09,0x11,0x29,0x45,0x02,0x07,0xC3,0xA8,
0xFA,0x6C,0xB8,0x0A,0xC0,0xAA,0x24,0xAA,0x22,0x10,
0x23,0xB0,0xFF,0x04,0x45,0x2A,0x88,0x0D,0x04,0x10,
0x79,0x08,0x11,0xE4,0x50,0xA3,0x3A,0x0D,0x64,0x11,
0x30,0x2E,0x63,0x50,0xB1,0x5C,0x0D,0x04,0x10,0x79,
0x0D,0x40,0x84,0xF0,0x0D,0x64,0x11,0x20,0x9D,0x47,
0x50,0xA3,0x3A,0x0D,0x04,0x10,0x7A,0x21,0x7F,0x10,
0x21,0x3C,0x09,0x60,0x08,0x38,0x47,0xEA,0x00,0x0D,
0x67,0xB0,0x75,0x1D,0x42,0x8C,0xE8,0x14,0x27,0x80,
0x0D,0x64,0x11,0x30,0x2E,0x63,0x90,0x80,0x03,0x64,
0x06,0xC3,0x68,0x07,0xDF,0xA6,0x30,0x34,0xC9,0x60,
0x0D,0x64,0x0F,0x30,0x21,0x44,0x91,0x43,0x48,0x89,
0x08,0x03,0x64,0x07,0xBA,0x80,0x17,0x04,0x1A,0xB9,
0xCC,0x63,0x90,0x84,0x0D,0x04,0x10,0xB9,0x8E,0x42,
0x0D,0x04,0x10,0x7B,0x21,0x3C,0x0D,0x67,0xB0,0xB9,
0x8D,0x42,0xC5,0x74,0xC0,0x0D,0x67,0xB0,0x75,0x1D,
0x42,0x8C,0xEC,0x82,0x09,0x04,0x0A,0xB6,0x64,0x00,
0x0D,0x04,0x10,0x79,0x0A,0x03,0x01,0x80,0xA1,0x3C,
0x09,0x40,0x29,0x08,0xFC,0x43,0x80,0x0D,0x04,0x11,
0x90,0xA3,0x3A,0x0F,0x00,0x0F,0x10,0x61,0x14,0x14,
0x81,0x00,0x17,0x00,0x16,0x84,0x28,0xA3,0x09,0x4A,
0x14,0x54,0x10,0x40,0x0F,0x00,0x0E,0x82,0x44,0x29,
0x02,0x05,0x08,0x90,0x40,0x0F,0x63,0xAF,0x10,0x61,
0x14,0x94,0x91,0x06,0x00,0x0D,0x04,0x10,0xFC,0x14,
0x09,0x04,0x10,0x7E,0x0B,0xC3,0xAA,0x1E,0x11,0x8B,
0x20,0x60,0x03,0xC7,0xA7,0xBD,0x80,0x0B,0xC3,0xAA,
0xC6,0x10,0x3B,0x23,0x00,0x10,0x40,0x92,0x71,0x47,
0x00,};
/* font data size: 861 bytes */

static const unsigned char font_tgx_Arial_11_index[] = {
0x00,0x00,0x30,0x20,0x0C,0x05,0x82,0x60,0xD4,
0x43,0x11,0xC4,0xE1,0x54,0x5C,0x18,0xC6,0x71,0xAC,
0x6F,0x1D,0x87,0xE2,0x10,0x8F,0x26,0x8A,0x62,0xC8,
0xBC,0x31,0x4C,0xD3,0x5C,0xDB,0x38,0x0E,0xA3,0xC4,
0xFB,0x41,0x92,0x24,0xBD,0x3A,0x51,0x95,0x05,0x69,
0x62,0x5C,0x17,0x75,0xF1,0x84,0x65,0x59,0xC6,0x9D,
0xB4,0x70,0x5C,0xA7,0x5D,0xE4,0x7C,0xDF,0xB8,0x12,
0x0F,0x88,0xA3,0x18,0xEE,0x48,0x93,0xA5,0x59,0x6E,
0x61,0x99,0x66,0x99,0xCE,0x7C,0xA1,0x28,0xDA,0x5A,
0x9D,0xAA,0x2B,0x0A,0xD6,0xBC,0xB1,0xEC,0xCB,0x52,
0xDA,0xB8,0x2E,0x9B,0xCA,0xF8,0xC0,0xB0,0x9C,0x3F,
0x18,0xC9,0x32,0xFC,0xE7,0x42,0xD2,0xB4,0xFD,0x5C,
};
/* font index size: 119 bytes */

const ILI9341_t3_font_t font_tgx_Arial_11 = {
	font_tgx_Arial_11_index,
	0,
	font_tgx_Arial_11_data,
	1,
	0,
	32,
	126,
	0,
	0,
	10,
	4,
	4,
	3,
	5,
	4,
	16,
	11
};



static const unsigned char font_tgx_Arial_12_data[] = {
0x00,0x00,0x01,0x40,0x01,0x62,0x01,0x77,0x31,0x04,
0x21,0x41,0xAA,0x40,0x09,0x60,0x02,0x60,0x25,0x02,
0x47,0xFC,0x24,0x82,0x43,0xFE,0x24,0x42,0x40,0x07,
0x79,0xF2,0x42,0x07,0x8A,0xD2,0x62,0x41,0xC0,0x70,
0x4C,0x49,0x2A,0x1C,0x81,0x00,0x0D,0x61,0x03,0xCE,
0x08,0x88,0x88,0x44,0x48,0x11,0x4E,0x39,0x44,0x09,
0x18,0x08,0x88,0x42,0x21,0x07,0x00,0x09,0x61,0x02,
0xC3,0x89,0x22,0x05,0x03,0x81,0x20,0x84,0xA1,0x48,
0x21,0x0C,0x3C,0x80,0x01,0x21,0x40,0xEA,0x03,0x79,
0xE9,0x86,0x56,0xC9,0x42,0x03,0x7A,0xE9,0x92,0x56,
0x99,0x48,0x05,0x29,0x39,0xC4,0x7C,0x48,0x50,0x07,
0x39,0x1A,0xA4,0x43,0xFC,0x88,0x01,0x1A,0xE9,0x66,
0x05,0x08,0x21,0x9F,0x01,0x0A,0x01,0x50,0x05,0x60,
0x01,0x41,0x91,0x49,0x25,0x11,0x00,0x07,0x61,0x02,
0x47,0x08,0xB6,0x0A,0x09,0x10,0xE0,0x04,0x62,0x02,
0x42,0x32,0xA7,0x44,0x20,0x07,0x61,0x02,0x47,0x88,
0x90,0x60,0x0C,0x02,0x04,0x08,0x10,0x20,0x7F,0x07,
0x61,0x02,0x47,0x08,0x90,0x80,0x81,0x07,0x00,0xA0,
0x0A,0x0B,0x10,0xE0,0x08,0x60,0x02,0x40,0x80,0xC8,
0x14,0x82,0x42,0x22,0x11,0xFF,0x20,0x80,0x07,0x61,
0x02,0x4F,0xE1,0x02,0x03,0xE2,0x14,0x81,0x41,0x22,
0x1C,0x07,0x61,0x02,0x47,0x08,0xD0,0x50,0x17,0x18,
0xAA,0x09,0x10,0xE0,0x07,0x61,0x02,0x5F,0xE0,0x14,
0x04,0x91,0x14,0x40,0x07,0x61,0x02,0x47,0x08,0xA2,
0x09,0x10,0xE1,0x14,0xC1,0x22,0x1C,0x07,0x61,0x02,
0x47,0x08,0xAA,0x09,0x18,0xE8,0x0A,0x09,0x11,0xE0,
0x01,0x4A,0x01,0x5D,0x20,0x01,0x5A,0xE9,0x5D,0x4C,
0x08,0x49,0x12,0x80,0x20,0x60,0xC1,0x81,0x00,0x60,
0x0C,0x01,0x80,0x20,0x08,0x29,0x1A,0x9F,0xF2,0x00,
0xFF,0x08,0x49,0x12,0x90,0x06,0x00,0xC0,0x18,0x02,
0x06,0x0C,0x18,0x10,0x00,0x07,0x61,0x02,0x47,0x08,
0xA2,0x08,0x08,0x10,0x24,0x88,0x00,0x08,0x10,0x81,
0xE4,0x40,0xFE,0x01,0x80,0xC1,0x00,0x11,0x0E,0x48,
0x88,0xE2,0x48,0x21,0x89,0x02,0x14,0x82,0x0A,0x41,
0x09,0x11,0x88,0x47,0x78,0x20,0x00,0x88,0x00,0x83,
0x01,0x80,0x7F,0x00,0x0B,0x60,0x02,0xC0,0x82,0x02,
0x84,0x88,0x81,0x04,0x1F,0xC8,0x40,0x51,0x00,0x40,
0x09,0x61,0x02,0xDF,0xC4,0x0A,0x20,0x28,0x13,0xFC,
0x81,0x4C,0x05,0x02,0x7F,0x00,0x0A,0x61,0x03,0x03,
0xE0,0x82,0x20,0x39,0x00,0x10,0x11,0x04,0x1F,0x00,
0x0A,0x61,0x03,0x1F,0xC2,0x04,0x40,0x59,0x00,0xA0,
0x24,0x08,0xFE,0x00,0x09,0x61,0x02,0xDF,0xFA,0x80,
0x3F,0xD7,0x00,0x7F,0xC0,0x08,0x61,0x02,0x9F,0xF5,
0x00,0xFE,0xC8,0x00,0x0A,0x61,0x03,0x03,0xC0,0x84,
0x20,0x53,0x00,0x21,0xF8,0x80,0x48,0x10,0x84,0x0F,
0x00,0x09,0x61,0x02,0xEE,0x02,0xFF,0xE4,0x04,0x01,
0x62,0x01,0x77,0x70,0x07,0x61,0x02,0x74,0x08,0x0C,
0x41,0x22,0x3C,0x09,0x61,0x02,0xD0,0x14,0x09,0x04,
0x42,0x11,0x04,0xC1,0x48,0x61,0x10,0x48,0x81,0x20,
0x20,0x07,0x61,0x02,0x76,0x05,0x40,0x7F,0x0B,0x61,
0x03,0x50,0x06,0x30,0x1C,0x50,0x58,0x91,0x29,0x23,
0x11,0x46,0x21,0x08,0x09,0x61,0x02,0xD0,0x16,0x06,
0x28,0x29,0x0C,0x44,0x50,0x98,0x82,0xA0,0x68,0x08,
0x0A,0x61,0x03,0x03,0xC0,0x84,0x20,0x59,0x00,0x90,
0x21,0x08,0x1E,0x00,0x09,0x61,0x02,0xDF,0xC4,0x0A,
0x60,0x28,0x13,0xF9,0x70,0x00,0x0A,0x61,0x03,0x03,
0xC0,0x84,0x20,0x59,0x00,0x91,0xB1,0x0C,0x1E,0xC0,
0x09,0x61,0x02,0xDF,0xC4,0x0A,0x60,0x28,0x13,0xF8,
0x84,0x44,0x11,0x02,0x40,0x40,0x09,0x61,0x02,0xC7,
0xC2,0x09,0x01,0x40,0x08,0x01,0xC0,0x0E,0x00,0x62,
0x02,0x41,0x0F,0x80,0x09,0x60,0x02,0x5F,0xFD,0x08,
0x50,0x40,0x09,0x61,0x02,0xF6,0x03,0x30,0x12,0x08,
0x7C,0x09,0x61,0x02,0xE2,0x03,0x28,0x29,0x22,0x40,
0xA2,0x02,0x00,0x11,0x60,0x04,0x50,0x10,0x14,0x0A,
0x0A,0x10,0x50,0x44,0x22,0x24,0x11,0x11,0x04,0x82,
0x88,0x14,0x14,0x40,0x40,0x40,0x0B,0x60,0x02,0xC8,
0x08,0x41,0x20,0x44,0x02,0x80,0x10,0x02,0x84,0x08,
0x81,0x04,0x20,0x24,0x01,0x09,0x61,0x02,0xD0,0x18,
0x41,0x08,0x90,0x28,0xC0,0x80,0x09,0x60,0x02,0x4F,
0xF0,0x0A,0x00,0x80,0x44,0x04,0x02,0x08,0x20,0x10,
0x0F,0xF8,0x03,0x79,0xE9,0x5F,0x66,0x47,0x05,0x60,
0x01,0x50,0x94,0x49,0x24,0x50,0x10,0x03,0x79,0xE9,
0x5F,0x4E,0x17,0x07,0x38,0x29,0xC2,0x20,0xA4,0xA2,
0x41,0x09,0x08,0xEA,0x5F,0xF0,0x02,0x11,0x51,0x91,
0x07,0x49,0x02,0x47,0x88,0x50,0x41,0xCE,0x62,0x0A,
0x19,0xE8,0x07,0x61,0x02,0x66,0x02,0xE3,0x15,0xC1,
0x62,0x5C,0x07,0x49,0x02,0x47,0x08,0x90,0x66,0x02,
0x09,0x10,0xE0,0x07,0x61,0x02,0x64,0x08,0xE9,0x1D,
0xC1,0x23,0x1D,0x07,0x49,0x02,0x47,0x08,0xA2,0x0B,
0xFA,0x02,0x09,0x10,0xE0,0x04,0x61,0x01,0x47,0x08,
0xFD,0x42,0x00,0x07,0x61,0xEA,0x47,0x48,0xEE,0x09,
0x18,0xE8,0x0A,0x11,0xE0,0x07,0x61,0x02,0x66,0x02,
0xF3,0x0E,0xC1,0x01,0x61,0x01,0x18,0x6E,0x20,0x03,
0x7F,0xE8,0xC6,0x06,0x9A,0x2C,0x07,0x61,0x02,0x26,
0x02,0x0A,0x12,0x22,0x42,0xC3,0x24,0x42,0x41,0x01,
0x61,0x00,0xF7,0x70,0x0B,0x49,0x03,0x57,0x39,0x8C,
0x76,0x10,0x80,0x07,0x49,0x02,0x57,0x98,0x76,0x08,
0x07,0x49,0x02,0x47,0x08,0xAE,0x09,0x10,0xE0,0x07,
0x61,0xEA,0x57,0x18,0xAE,0x0B,0x12,0xE4,0xC0,0x07,
0x61,0xEA,0x47,0x48,0xEE,0x09,0x18,0xEC,0x81,0x05,
0x49,0x01,0x97,0x63,0x60,0x06,0x49,0x02,0x0F,0x21,
0x88,0x0F,0x40,0x28,0x4F,0x00,0x04,0x60,0x01,0x25,
0x1F,0xA8,0x70,0x07,0x49,0x02,0x76,0x0A,0x19,0xE8,
0x07,0x48,0x01,0xE2,0x0C,0xA2,0x82,0x90,0x20,0x0B,
0x48,0x02,0xE2,0x10,0xC2,0x52,0x95,0x15,0x04,0x10,
0x07,0x48,0x01,0xD0,0x48,0xA0,0xA0,0x44,0x14,0x22,
0x41,0x07,0x61,0xEA,0x66,0x0C,0xA2,0x82,0x90,0x20,
0x41,0x80,0x07,0x48,0x02,0x1F,0xC0,0xA0,0x20,0x40,
0x84,0x20,0x7F,0x05,0x79,0xE9,0x83,0xC2,0x31,0x84,
0x0C,0x01,0x82,0xE1,0x77,0xB8,0x80,0x05,0x78,0xE9,
0x98,0xC2,0x07,0x84,0x60,0x09,0x10,0x2A,0x8F,0x14,
0x78,};
/* font data size: 1011 bytes */

static const unsigned char font_tgx_Arial_12_index[] = {
0x00,0x00,0x40,0x24,0x0E,0x07,0x42,0xE1,0x0C,
0x54,0x16,0x05,0xF1,0x98,0x6D,0x1D,0x07,0x81,0xF0,
0x80,0x22,0x49,0x32,0x6C,0xA9,0x2E,0x0C,0x63,0x4C,
0xE0,0x3A,0x8F,0x74,0x11,0x09,0x43,0x91,0xC4,0x8D,
0x31,0x4F,0x96,0x25,0xC9,0x82,0x64,0x19,0xE6,0xA5,
0xB2,0x70,0xDC,0xB7,0x41,0xD9,0x7A,0xDF,0x28,0x0A,
0x12,0x88,0x22,0xC8,0xEA,0x4A,0x97,0x26,0x49,0xB6,
0x79,0xA4,0x2A,0x3A,0xBA,0xBE,0xB1,0x2C,0xDB,0x4E,
0xDB,0xB8,0x2E,0x4B,0xC2,0xFA,0xC1,0x70,0xFC,0x6F,
0x23,0xCB,0xF3,0x7C,0xF7,0x44,0xD4,0x75,0x6D,0x7F,
0x66,0xDB,0xF7,0x9E,0x0F,0x89,0xE5,0x39,0xBE,0x8B,
0xAB,0xED,0xBC,0x1F,0x33,0xD7,0xF7,0xFE,0x5F,0xB4,
};
/* font index size: 119 bytes */

const ILI9341_t3_font_t font_tgx_Arial_12 = {
	font_tgx_Arial_12_index,
	0,
	font_tgx_Arial_12_data,
	1,
	0,
	32,
	126,
	0,
	0,
	10,
	5,
	5,
	3,
	5,
	5,
	18,
	12
};



static const unsigned char font_tgx_Arial_13_data[] = {
0x00,0x00,0x01,0x40,0x02,0x6A,0x01,0xB7,0x9C,0x46,
0x05,0x29,0x41,0xAF,0x60,0x0B,0x68,0x02,0xA0,0x33,
0x06,0x64,0x7F,0xF0,0xCC,0x1D,0xC1,0x98,0x8F,0xFE,
0x33,0x10,0xCC,0x00,0x09,0x81,0xF2,0x81,0x01,0xF0,
0xFE,0x64,0xD9,0x07,0x40,0xF8,0x0F,0x81,0xF0,0x4D,
0x93,0x75,0xCF,0xE1,0xF2,0x02,0x00,0x0E,0x69,0x04,
0x0F,0x0C,0x46,0x66,0x11,0x9B,0x03,0x3E,0x03,0xDB,
0xC0,0x3C,0xE0,0x1B,0x38,0x0C,0xCC,0x30,0xF0,0x0B,
0x69,0x03,0x03,0xC0,0x7E,0x20,0xCC,0x0D,0x80,0x70,
0x1F,0x01,0xB3,0x31,0xB3,0x0E,0x38,0xE1,0xFF,0x0F,
0x18,0x02,0x28,0x40,0xEF,0x05,0x89,0xE1,0x81,0x08,
0x48,0x66,0xE2,0x18,0x20,0x40,0x80,0x05,0x88,0xE1,
0x90,0x20,0x48,0x36,0x8E,0x0C,0x21,0x08,0x00,0x05,
0x29,0x41,0xC4,0x7C,0x48,0x50,0x0A,0x51,0x0A,0xE8,
0x30,0x8F,0xFE,0x83,0x00,0x02,0x22,0xF1,0x63,0x28,
0x05,0x10,0x21,0xA3,0xE0,0x02,0x12,0x01,0x63,0x06,
0x68,0x01,0x60,0x39,0x1A,0x4C,0x96,0x23,0x00,0x08,
0x69,0x02,0x87,0x87,0xE7,0x3E,0xE1,0xB9,0xCF,0xC3,
0xC0,0x05,0x6A,0x02,0x83,0x1C,0xF6,0xD3,0xD1,0x86,
0x08,0x69,0x02,0x87,0x87,0xE7,0x3B,0x0E,0x00,0xC0,
0xC0,0xC0,0xC1,0xC0,0xC1,0x1F,0xE0,0x08,0x69,0x02,
0x87,0x07,0xC6,0x34,0x03,0x07,0x03,0xD0,0x07,0x18,
0x67,0xE1,0xE0,0x09,0x68,0x02,0x80,0xC8,0x0E,0x07,
0x90,0x6C,0x33,0x18,0xC8,0xFF,0xC8,0x30,0x08,0x69,
0x02,0xA1,0xF8,0xC0,0xC0,0x6E,0x3F,0x98,0x70,0x07,
0x18,0x67,0xE1,0xE0,0x08,0x69,0x02,0x87,0x87,0xE3,
0x1C,0x60,0x37,0x1F,0xCE,0x38,0xC3,0x31,0x9F,0x87,
0x80,0x08,0x69,0x02,0xA3,0xFC,0x04,0x06,0x80,0xC9,
0x18,0x1C,0x49,0x80,0x08,0x69,0x02,0x87,0x87,0xE9,
0xC3,0x87,0xEA,0xC3,0x3F,0x0F,0x00,0x08,0x69,0x02,
0x87,0x87,0xE9,0xC3,0x63,0x9F,0xC7,0x70,0x06,0xC6,
0x3F,0x0F,0x00,0x02,0x52,0x01,0x63,0xC2,0x30,0x02,
0x62,0xF1,0x63,0xC2,0x32,0x80,0x09,0x49,0x12,0xC0,
0x10,0x1C,0x3E,0x3C,0x18,0x03,0xC0,0x3E,0x01,0xC0,
0x10,0x09,0x31,0x22,0xE3,0xFF,0x00,0x08,0xFF,0x80,
0x09,0x49,0x12,0xD0,0x07,0x00,0xF8,0x07,0x80,0x30,
0x78,0xF8,0x70,0x10,0x00,0x08,0x69,0x02,0x87,0x87,
0xE7,0x3B,0x0C,0x06,0x06,0x06,0x06,0x20,0xC0,0x01,
0x06,0x00,0x11,0x89,0xE4,0x80,0x7E,0x00,0x7F,0xE0,
0x38,0x1C,0x18,0xEF,0x8C,0x7F,0x73,0x33,0x8D,0x9C,
0x63,0x66,0x18,0xD9,0x84,0x36,0x63,0x19,0x9C,0xCE,
0x63,0xFF,0x0C,0xEF,0x03,0x80,0x1C,0x78,0x0E,0x0F,
0xFF,0x00,0xFF,0x00,0x0B,0x68,0x02,0xE0,0x38,0x48,
0xD8,0x83,0x18,0x3F,0x87,0xFD,0x0C,0x1A,0x30,0x18,
0x0A,0x69,0x03,0x1F,0xE3,0xFE,0x9C,0x0E,0x3F,0xE9,
0xC0,0xD8,0x3B,0xFE,0x7F,0x80,0x0B,0x69,0x03,0x43,
0xE0,0x7F,0x8E,0x1C,0xC0,0xEF,0x00,0x18,0x19,0xC3,
0x0F,0xF0,0x3C,0x00,0x0B,0x69,0x03,0x5F,0xE1,0xFF,
0x18,0x39,0x81,0xEF,0x01,0xB0,0x33,0x07,0x3F,0xE3,
0xFC,0x00,0x0A,0x69,0x03,0x23,0xFF,0x9C,0x02,0x3F,
0xEA,0xC0,0x23,0xFF,0x09,0x69,0x02,0xE3,0xFF,0x38,
0x08,0xFF,0x66,0x00,0x0C,0x69,0x03,0x81,0xF0,0x3F,
0xE3,0x83,0x18,0x0E,0x30,0x02,0x30,0xFD,0x80,0x66,
0x03,0x38,0x38,0xFF,0x81,0xF0,0x0B,0x69,0x03,0x6F,
0x01,0xC7,0xFF,0xCC,0x06,0x02,0x69,0x01,0x37,0xCC,
0x07,0x69,0x02,0x74,0x1C,0x03,0x8C,0x6F,0xC7,0x80,
0x0B,0x69,0x03,0x18,0x39,0x87,0x18,0xE1,0x9C,0x1B,
0x81,0xF0,0x1F,0x81,0xDC,0x18,0xE1,0x86,0x18,0x71,
0x83,0x98,0x1C,0x08,0x69,0x02,0xB7,0x02,0xB0,0x23,
0xFC,0x0D,0x69,0x03,0xDC,0x07,0x9F,0x07,0xCE,0xC6,
0xD9,0x13,0x9C,0xD9,0xC6,0x38,0xC0,0x0B,0x69,0x03,
0x58,0x0D,0xC0,0xE3,0xC1,0xB6,0x1B,0x31,0xB3,0x9B,
0x19,0xB0,0xDC,0x60,0xF6,0x07,0x60,0x30,0x0C,0x69,
0x03,0x81,0xF0,0x3F,0xC3,0x87,0x18,0x1A,0xF0,0x0C,
0xC0,0xC7,0x0E,0x1F,0xE0,0x3C,0x00,0x0A,0x69,0x03,
0x1F,0xE3,0xFE,0x60,0xF1,0x81,0xB0,0x77,0xFC,0xFF,
0x2F,0x00,0x0C,0x69,0x03,0x83,0xF0,0x3F,0xC3,0x87,
0x18,0x1E,0xF0,0x0C,0xC6,0xC7,0x1C,0x1F,0xE0,0x7D,
0xC0,0x0C,0x69,0x03,0x5F,0xF0,0xFF,0xC6,0x07,0x30,
0x19,0x81,0xCF,0xFC,0x7F,0xC3,0x0C,0x18,0x70,0xC1,
0xC6,0x06,0x30,0x39,0x80,0xE0,0x0A,0x69,0x03,0x03,
0xE1,0xFE,0x70,0xEC,0x0D,0x80,0x1E,0x01,0xF8,0x07,
0x80,0x1B,0x03,0x70,0xE7,0xF8,0x7E,0x00,0x0A,0x69,
0x03,0x23,0xFF,0xD0,0xC2,0x83,0x00,0x0B,0x69,0x03,
0x77,0x01,0xCE,0x03,0x70,0x63,0xFE,0x0F,0x80,0x0B,
0x68,0x02,0xE3,0x01,0xCB,0x06,0x93,0x19,0x23,0x62,
0x03,0x80,0x11,0x68,0x04,0x63,0x07,0x07,0x4C,0x6C,
0x63,0x11,0x1A,0x8D,0x8D,0x90,0x38,0x38,0x0B,0x68,
0x02,0xCE,0x38,0x63,0x20,0x6C,0x48,0x70,0x81,0xB0,
0x3B,0x83,0x18,0x60,0xCE,0x0E,0x0C,0x68,0x03,0x1C,
0x0E,0x60,0x61,0x86,0x0E,0x70,0x33,0x10,0x1E,0x18,
0x0C,0x00,0x0A,0x68,0x02,0xE1,0xFF,0x00,0xC0,0x30,
0x0E,0x01,0x80,0x60,0x18,0x07,0x00,0xC0,0x30,0x11,
0xFF,0x80,0x04,0x89,0xE1,0x63,0xF7,0x33,0x23,0xC0,
0x06,0x68,0x01,0x63,0x09,0x62,0x4C,0x91,0xA0,0x30,
0x04,0x88,0xE1,0x63,0xF4,0xF0,0xE3,0xC0,0x07,0x38,
0x31,0xC2,0x07,0x05,0x21,0xB1,0x13,0x18,0x0A,0x10,
0xE2,0xA3,0xFF,0x03,0x11,0x59,0x98,0xC0,0x08,0x51,
0x02,0x87,0xC7,0xF6,0x18,0x3C,0xFE,0xF3,0x61,0xB1,
0xDF,0xE7,0xB0,0x08,0x69,0x02,0xA7,0x01,0xB8,0xFE,
0x73,0xD6,0x1B,0x9D,0xFC,0xDC,0x07,0x51,0x02,0x47,
0x8F,0xDC,0xEB,0x03,0x99,0xF8,0xF0,0x08,0x69,0x02,
0xA4,0x0C,0x76,0x7F,0x73,0xD6,0x1B,0x9C,0xFE,0x3B,
0x08,0x51,0x02,0x87,0x87,0xE7,0x33,0x0E,0x3F,0xD8,
0x0E,0x33,0xF0,0xF0,0x06,0x68,0x01,0x47,0x9F,0x31,
0x1F,0x6B,0x06,0x00,0x08,0x71,0xE2,0x87,0x67,0xF7,
0x3D,0x61,0xB9,0xCF,0xE3,0xB0,0x1B,0x1D,0xFC,0x7C,
0x08,0x69,0x02,0xA7,0x01,0xBC,0xFF,0x71,0xEE,0x18,
0x02,0x69,0x01,0x23,0x1B,0xCE,0x04,0x8F,0xE1,0x20,
0xC1,0xA7,0x66,0xF7,0x00,0x08,0x69,0x02,0x67,0x01,
0x8E,0xCE,0x6E,0x3C,0x1F,0x0D,0x88,0xCC,0x63,0x31,
0xC0,0x02,0x69,0x01,0x37,0xCC,0x0C,0x51,0x03,0x9B,
0x9C,0xFD,0xF7,0x39,0xEE,0x31,0x80,0x08,0x51,0x02,
0x9B,0xCF,0xF7,0x1E,0xE1,0x80,0x08,0x51,0x02,0x87,
0x87,0xE7,0x3D,0x61,0xB9,0xCF,0xC3,0xC0,0x08,0x71,
0xE2,0x9B,0x8F,0xE7,0x3D,0x61,0xB9,0xDF,0xCD,0xCA,
0xC0,0x08,0x71,0xE2,0x87,0x67,0xF7,0x3D,0x61,0xB9,
0xCF,0xE3,0xBA,0x03,0x05,0x51,0x01,0x9B,0x7D,0xCD,
0xC0,0x07,0x51,0x02,0x4F,0x9F,0xD8,0xDC,0x0F,0x03,
0x81,0xD8,0xDF,0xCF,0x80,0x04,0x68,0x01,0x65,0xA3,
0xF1,0xA1,0xC0,0x08,0x51,0x02,0xB7,0x0D,0x8E,0xFF,
0x3D,0x80,0x09,0x50,0x02,0x63,0x07,0x2C,0x68,0x36,
0x40,0xE0,0x10,0x0D,0x50,0x03,0x58,0x43,0x8C,0x71,
0x99,0x4D,0x0D,0xB6,0x14,0x52,0x0E,0x38,0x18,0xC0,
0x08,0x50,0x02,0x18,0x70,0xCC,0x3C,0x81,0x81,0xE4,
0x33,0x30,0xC0,0x09,0x70,0xE2,0x63,0x07,0x0C,0x61,
0x98,0x6C,0x81,0xE4,0x86,0x03,0x03,0xC0,0xE0,0x08,
0x50,0x02,0x23,0xFC,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,
0x08,0xFF,0x06,0x88,0xE1,0x83,0x8F,0xA3,0x0E,0x47,
0x07,0x2C,0xC1,0xE1,0xC0,0x02,0x8A,0xE1,0xB7,0xDE,
0x70,0x06,0x88,0xE1,0x9C,0x3C,0xA3,0x07,0x40,0xE3,
0xAC,0xC7,0x8E,0x00,0x0A,0x20,0x22,0xCE,0x03,0xF1,
0x47,0xE0,0x38,};
/* font data size: 1223 bytes */

static const unsigned char font_tgx_Arial_13_index[] = {
0x00,0x00,0x10,0x05,0x00,0xF0,0x44,
0x0E,0x42,0x78,0x65,0x0D,0x21,0xD4,0x40,0x88,0x81,
0x22,0x25,0x84,0xD8,0x9F,0x15,0x22,0xD4,0x5F,0x0C,
0xF1,0xBE,0x3B,0x87,0xF1,0x0F,0x23,0x84,0xA4,0x9C,
0x93,0xF2,0x8C,0x55,0x4A,0xF1,0x6D,0x2F,0xC6,0xA0,
0xDC,0x1C,0x83,0xB4,0x7B,0x0F,0xC2,0x02,0x43,0x08,
0x85,0x13,0x23,0x04,0x8E,0x93,0xD2,0xFA,0x74,0x50,
0xEA,0x59,0x54,0xAC,0x25,0xB0,0xB8,0x57,0x6A,0xFA,
0x61,0x4C,0x71,0x96,0x34,0x06,0x90,0xD4,0x9A,0xD3,
0x64,0x6D,0x2D,0xB9,0xBE,0xB8,0xA7,0x2A,0xE8,0x9D,
0x83,0xBA,0x79,0x4F,0x51,0xED,0x3E,0x37,0xE6,0xFE,
0x20,0x1C,0x0C,0x83,0x10,0x96,0x19,0x43,0x98,0x8F,
0x13,0xE2,0xC4,0x63,0x8E,0x92,0x06,0x48,0xC9,0xE9,
0x57,0x2C,0x65,0xF0,
};
/* font index size: 131 bytes */

const ILI9341_t3_font_t font_tgx_Arial_13 = {
	font_tgx_Arial_13_index,
	0,
	font_tgx_Arial_13_data,
	1,
	0,
	32,
	126,
	0,
	0,
	11,
	5,
	5,
	3,
	5,
	5,
	19,
	13
};



static const unsigned char font_tgx_Arial_14_data[] = {
0x00,0x00,0x01,0x40,0x02,0x72,0x01,0xB7,0xAC,0x46,
0x05,0x29,0x49,0xEF,0x60,0x0B,0x70,0x02,0xE0,0x33,
0x06,0x64,0x7F,0xF8,0x19,0x83,0x31,0x1F,0xFE,0x0C,
0xC4,0x33,0x00,0x09,0x89,0xF2,0xC1,0x01,0xF0,0xFE,
0x74,0xE3,0x20,0x78,0x0F,0x80,0xF0,0x2E,0x09,0xB2,
0x6E,0xB9,0xFC,0x3E,0x40,0x40,0x0F,0x71,0x04,0x4F,
0x03,0x23,0x30,0xC3,0x31,0x84,0x66,0x60,0x3C,0xC0,
0x00,0xDE,0x80,0x36,0x60,0x66,0x70,0x18,0xCC,0x30,
0x78,0x0C,0x71,0x03,0x43,0xC0,0x3F,0x08,0x63,0x03,
0x98,0x0F,0x80,0x78,0x07,0xC0,0x73,0x33,0x0D,0x98,
0x38,0xE3,0xC3,0xFB,0x0F,0x8C,0x02,0x29,0x49,0x2F,
0x05,0x91,0xE1,0x81,0x08,0x68,0x61,0x19,0x82,0x21,
0x83,0x04,0x08,0x05,0x90,0xE1,0x90,0x20,0xC8,0x30,
0x58,0x30,0xA0,0xC6,0x10,0x80,0x05,0x31,0x41,0xE0,
0x8F,0x89,0x0A,0x0A,0x51,0x0A,0xE8,0x30,0x8F,0xFE,
0x83,0x00,0x02,0x29,0xE9,0x63,0x85,0x00,0x05,0x10,
0x21,0xA3,0xE0,0x02,0x12,0x01,0x63,0x06,0x70,0x01,
0x60,0x39,0x1A,0x8C,0x96,0x23,0x00,0x09,0x71,0x02,
0xC7,0xC3,0xF8,0xC6,0xDC,0x1B,0x06,0x63,0x1F,0xC3,
0xE0,0x05,0x72,0x02,0xE0,0x63,0xBE,0xDE,0x8E,0x06,
0x09,0x71,0x02,0xC7,0xC3,0xF9,0xC7,0x60,0xE0,0x06,
0x03,0x01,0x80,0xC0,0x60,0x30,0x18,0x11,0xFF,0x09,
0x71,0x02,0xC7,0x83,0xF1,0xC6,0x61,0x80,0x60,0xF0,
0x3E,0x01,0xE0,0x06,0xC1,0xB8,0xE7,0xF0,0xF8,0x0A,
0x70,0x02,0xC0,0x20,0x0C,0x03,0x80,0xF2,0x06,0xC1,
0x98,0x63,0x18,0x64,0x7F,0xF2,0x06,0x00,0x09,0x71,
0x02,0xE1,0xFD,0x0C,0x06,0x01,0xBC,0x7F,0x98,0x38,
0x01,0xB0,0x6E,0x39,0xFC,0x3E,0x00,0x09,0x71,0x02,
0xC3,0xC1,0xF8,0xC7,0x70,0xD8,0x06,0xF1,0xFE,0x71,
0xE7,0x06,0x63,0x9F,0xC1,0xE0,0x09,0x71,0x02,0xE3,
0xFE,0x01,0x00,0xC0,0x60,0x11,0x01,0x89,0x18,0x49,
0x80,0x09,0x71,0x02,0xC7,0xC3,0xF9,0xC7,0x8C,0x1B,
0x8F,0x0F,0xE7,0x1E,0x30,0x6C,0x39,0xFC,0x3E,0x00,
0x09,0x71,0x02,0xC7,0x83,0xF9,0xC6,0x9C,0x1B,0x8E,
0x7F,0x8F,0x60,0x1B,0x06,0xE3,0x1F,0xC3,0xC0,0x02,
0x52,0x01,0x63,0xC2,0x30,0x02,0x6A,0xE9,0x63,0xC2,
0x38,0x50,0x09,0x49,0x12,0xC0,0x10,0x1C,0x3E,0x3C,
0x18,0x03,0xC0,0x3E,0x01,0xC0,0x10,0x09,0x31,0x22,
0xE3,0xFF,0x00,0x08,0xFF,0x80,0x09,0x49,0x12,0xD0,
0x07,0x00,0xF8,0x07,0x80,0x30,0x78,0xF8,0x70,0x10,
0x00,0x09,0x71,0x02,0xC7,0xC3,0xF9,0xC7,0x60,0xC0,
0x30,0x18,0x0E,0x07,0x03,0x88,0x18,0x00,0x10,0x30,
0x12,0x91,0xE4,0xC0,0x7F,0x00,0x3F,0xF8,0x0F,0x07,
0x83,0x80,0x38,0xE3,0xDB,0x18,0xFF,0x37,0x39,0xC6,
0xCE,0x18,0xD9,0x83,0x1B,0x30,0x47,0x66,0x18,0xCC,
0xE7,0x31,0xCF,0xFE,0x18,0xEF,0x03,0x80,0x0E,0x3C,
0x07,0x81,0xFF,0xE0,0x0F,0xE0,0x0D,0x70,0x03,0x60,
0x1C,0x12,0x1B,0x08,0x18,0xC0,0xC1,0x90,0x7F,0xC8,
0x60,0x34,0x60,0x0C,0x0A,0x72,0x03,0x5F,0xC3,0xFC,
0x61,0xD1,0x83,0x30,0xE8,0xFF,0x18,0x34,0x60,0x6C,
0x1D,0xFF,0x3F,0xC0,0x0C,0x71,0x03,0x81,0xE0,0x3F,
0xC3,0x83,0x18,0x0E,0xF0,0x01,0x80,0x66,0x06,0x38,
0x70,0xFF,0x01,0xE0,0x0B,0x72,0x03,0x9F,0xE1,0xFF,
0x18,0x39,0x81,0xB3,0x01,0xB0,0x33,0x07,0x3F,0xE3,
0xFC,0x00,0x0A,0x72,0x03,0x63,0xFF,0xAC,0x02,0x3F,
0xEA,0xC0,0x23,0xFF,0x09,0x72,0x03,0x23,0xFF,0x58,
0x08,0xFF,0x66,0x00,0x0D,0x71,0x03,0xC1,0xF8,0x1F,
0xF0,0xE0,0xE3,0x01,0xDC,0x02,0x8C,0x00,0x46,0x0F,
0xD8,0x03,0x30,0x0C,0xF0,0x71,0xFF,0x81,0xF8,0x0B,
0x71,0x03,0x73,0x01,0xC7,0xFF,0xCC,0x06,0x02,0x72,
0x01,0xB7,0xDC,0x07,0x71,0x02,0xB4,0x1C,0x83,0x8C,
0x6F,0xC7,0x80,0x0B,0x72,0x03,0x58,0x39,0x87,0x18,
0xE1,0x9C,0x1B,0x81,0xB0,0x1F,0x01,0xF8,0x19,0xC1,
0x8C,0x18,0x61,0x87,0x18,0x39,0x81,0xC0,0x08,0x72,
0x02,0xF7,0x02,0xF0,0x23,0xFC,0x0D,0x71,0x03,0xDC,
0x07,0x9F,0x07,0xD6,0xC6,0xE7,0x36,0x6C,0x51,0xC6,
0x38,0xC0,0x0B,0x71,0x03,0x58,0x0D,0xC0,0xE3,0xC1,
0xB6,0x1C,0x66,0x38,0xC6,0x6C,0x37,0x18,0x3D,0x81,
0xD8,0x0C,0x0D,0x71,0x03,0xC1,0xF0,0x1F,0xF0,0xE0,
0xE3,0x01,0xB3,0x00,0x66,0x03,0x1C,0x1C,0x3F,0xE0,
0x3E,0x00,0x0A,0x72,0x03,0x5F,0xE3,0xFE,0x60,0xF3,
0x81,0xB0,0x77,0xFC,0xFF,0x2F,0x00,0x0D,0x71,0x03,
0xC1,0xF0,0x1F,0xF0,0xE0,0xE3,0x01,0xB3,0x00,0x66,
0x1B,0x1C,0x38,0x3F,0xE0,0x3E,0xE0,0x0B,0x72,0x03,
0x9F,0xE1,0xFF,0x18,0x3A,0x30,0x33,0x07,0x3F,0xE3,
0xFC,0x31,0x83,0x0C,0x30,0xE3,0x07,0x30,0x33,0x03,
0x80,0x0B,0x71,0x03,0x43,0xF0,0x7F,0x8E,0x1C,0xC0,
0xCC,0x00,0x70,0x03,0xE0,0x07,0x80,0x0E,0x30,0x19,
0xC3,0x9F,0xF0,0x7E,0x00,0x0A,0x71,0x03,0x23,0xFF,
0xD0,0xC2,0xC3,0x00,0x0B,0x71,0x03,0x77,0x01,0xD6,
0x03,0x30,0x63,0xFE,0x0F,0x80,0x0D,0x70,0x03,0x63,
0x00,0x72,0xC0,0x68,0x30,0x64,0x8C,0x62,0x03,0x61,
0x00,0xE0,0x13,0x70,0x04,0xE3,0x03,0x81,0xCB,0x0D,
0x86,0x86,0x31,0x8D,0x06,0x63,0x32,0x4D,0x83,0x64,
0x0E,0x03,0x80,0x0D,0x70,0x03,0x4E,0x0E,0x1C,0x70,
0x31,0x80,0xEE,0x01,0xB0,0x90,0x70,0x03,0x60,0x1D,
0xC0,0xE3,0x83,0x06,0x1C,0x1C,0xE0,0x38,0x0C,0x70,
0x03,0x1C,0x0E,0x60,0x61,0x86,0x0E,0x70,0x33,0x01,
0xD8,0x07,0x86,0x83,0x00,0x0B,0x70,0x03,0x21,0xFF,
0x80,0x30,0x06,0x40,0x18,0x03,0x00,0x60,0x81,0x80,
0x30,0x06,0x01,0x1F,0xFC,0x04,0x91,0xE1,0x63,0xF7,
0x37,0x23,0xC0,0x06,0x70,0x01,0x63,0x09,0x62,0x8C,
0x91,0xA0,0x30,0x04,0x90,0xE1,0x63,0xF4,0xF4,0xE3,
0xC0,0x07,0x38,0x39,0xC2,0x07,0x05,0x21,0xB1,0x13,
0x18,0x0B,0x10,0xE2,0xE3,0xFF,0x80,0x03,0x19,0x59,
0x98,0xC4,0x09,0x51,0x02,0x87,0xC7,0xF9,0x86,0x07,
0x8F,0xE7,0x99,0x86,0x63,0x9F,0xE3,0xCC,0x09,0x71,
0x02,0xEB,0x00,0xDE,0x3F,0xCE,0x3D,0x60,0xDC,0x77,
0xF9,0xBC,0x08,0x51,0x02,0x87,0x87,0xE7,0x3D,0x60,
0x39,0xCF,0xC3,0xC0,0x09,0x71,0x02,0xE8,0x06,0x3D,
0x9F,0xEE,0x3D,0x60,0xDC,0x73,0xFC,0x7B,0x09,0x51,
0x02,0xC7,0xC3,0xF9,0xC6,0x60,0xE3,0xFE,0xC0,0x38,
0x67,0xF0,0xF8,0x06,0x71,0x01,0x87,0x9F,0x86,0x23,
0xED,0x60,0xC0,0x09,0x71,0xE2,0xC7,0xB3,0xFD,0xC7,
0xAC,0x1B,0x8E,0x7F,0x8F,0x60,0x1B,0x0E,0xFF,0x0F,
0x80,0x08,0x71,0x02,0xAB,0x01,0xBC,0xFF,0x71,0xEE,
0x18,0x02,0x71,0x01,0x23,0x83,0x79,0xC0,0x04,0x97,
0xE1,0x20,0xE0,0x34,0xEC,0xDE,0xE0,0x08,0x71,0x02,
0x6B,0x01,0x8E,0xCE,0x6E,0x47,0xC3,0x71,0x98,0xCE,
0x63,0x31,0xC0,0x02,0x71,0x01,0x37,0xDC,0x0E,0x51,
0x04,0x1B,0xCF,0x3F,0xBF,0x71,0xC7,0xB8,0x61,0x80,
0x08,0x51,0x02,0x9B,0xCF,0xF7,0x1E,0xE1,0x80,0x09,
0x51,0x02,0xC7,0xC3,0xF9,0xC7,0xAC,0x1B,0x8E,0x7F,
0x0F,0x80,0x09,0x71,0xE2,0xDB,0xC7,0xF9,0xC7,0xAC,
0x1B,0x8C,0xFF,0x37,0x95,0x80,0x09,0x71,0xE2,0xC7,
0xB3,0xFD,0xC7,0xAC,0x19,0x8E,0x7F,0x8F,0x74,0x03,
0x05,0x51,0x01,0x9B,0x7D,0xCD,0xC0,0x08,0x51,0x02,
0x8F,0x8F,0xE6,0x1B,0x80,0xF0,0x1E,0x03,0xB0,0xCF,
0xE3,0xE0,0x05,0x68,0x01,0x65,0x91,0xFC,0x61,0xE3,
0x80,0x08,0x51,0x02,0xB7,0x0D,0x8E,0xFF,0x3D,0x80,
0x09,0x50,0x02,0x63,0x07,0x2C,0x68,0x36,0x40,0xE0,
0x10,0x0D,0x50,0x03,0x58,0x43,0x8C,0x71,0x99,0x4D,
0x0D,0xB6,0x14,0x52,0x0E,0x38,0x18,0xC0,0x09,0x50,
0x02,0x58,0x33,0x1A,0x0D,0x90,0x38,0x83,0x61,0x8C,
0xC1,0x80,0x09,0x70,0xE2,0x63,0x07,0x0C,0x61,0x98,
0x6C,0x81,0xE4,0x86,0x03,0x03,0xC0,0xE0,0x09,0x50,
0x02,0x61,0xFE,0x03,0x81,0xC1,0xE0,0xE0,0x70,0x38,
0x11,0xFF,0x06,0x90,0xE1,0x83,0x8F,0xB3,0x0E,0x47,
0x07,0x2C,0xC1,0xE1,0xC0,0x02,0x92,0xE1,0xB7,0xDE,
0xB0,0x06,0x90,0xE1,0x9C,0x3C,0xB3,0x07,0x40,0xE3,
0xAC,0xC7,0x8E,0x00,0x09,0x21,0x22,0xCE,0x07,0xC5,
0x1F,0x03,0x80,};
/* font data size: 1313 bytes */

static const unsigned char font_tgx_Arial_14_index[] = {
0x00,0x00,0x10,0x05,0x00,0xF0,0x42,
0x0E,0x02,0x88,0x6A,0x0D,0xC1,0xEC,0x44,0x08,0xF1,
0x30,0x27,0x85,0x18,0xA7,0x16,0x22,0xFC,0x64,0x0D,
0xB1,0xDE,0x40,0x88,0xA9,0x28,0x26,0xE5,0x28,0xAE,
0x96,0x32,0xD4,0x5E,0x4C,0x11,0x91,0x34,0x87,0x48,
0xF2,0x1F,0x84,0x18,0x87,0x91,0x52,0x34,0x49,0xA9,
0x59,0x2D,0xA6,0x54,0xFC,0xA1,0x94,0xB2,0xAA,0x57,
0xCB,0x35,0x70,0xAF,0x96,0x22,0xC6,0x99,0x33,0x36,
0x69,0x6D,0x91,0xBA,0xB8,0x97,0x22,0xE6,0xDD,0x1B,
0xAD,0x76,0x6E,0xE1,0xE4,0x3D,0x67,0xC4,0xFC,0x1F,
0xFC,0x09,0x83,0x70,0x96,0x16,0x43,0x58,0x8B,0x12,
0xA2,0xB4,0x5F,0x8D,0x91,0xEA,0x44,0x48,0xF9,0x3D,
0x29,0xE5,0x84,0xBB,0x99,0x93,0x6A,0x75,0x4F,0x8A,
0x0B,0x42,0xE8,0xC0,
};
/* font index size: 131 bytes */

const ILI9341_t3_font_t font_tgx_Arial_14 = {
	font_tgx_Arial_14_index,
	0,
	font_tgx_Arial_14_data,
	1,
	0,
	32,
	126,
	0,
	0,
	11,
	5,
	5,
	3,
	5,
	5,
	21,
	14
};



static const unsigned char font_tgx_Arial_16_data[] = {
0x00,0x00,0x01,0x80,0x02,0x82,0x01,0xB7,0xBE,0x08,
0xC0,0x06,0x31,0x52,0x33,0x30,0x0C,0x80,0x03,0x24,
0x31,0x83,0x19,0x1F,0xFF,0x03,0x19,0x06,0x31,0x1F,
0xFE,0x31,0x89,0x63,0x00,0x0A,0x99,0xF3,0x01,0x00,
0xF8,0x3F,0xCE,0x9D,0x91,0xB2,0x07,0x40,0x78,0x07,
0xE0,0x3E,0x04,0xE0,0x8E,0x32,0x33,0x4C,0x7F,0x87,
0xC4,0x04,0x00,0x12,0x81,0x05,0x07,0x00,0xC1,0xB0,
0x30,0x63,0x06,0x0C,0x61,0x82,0x31,0x8C,0x06,0x33,
0x00,0x6C,0x67,0x07,0x19,0xB4,0x00,0xCC,0x70,0x06,
0x31,0x81,0x86,0x30,0x60,0x6C,0x0C,0x07,0x00,0x0D,
0x81,0x03,0xC1,0xC0,0x0F,0x82,0x4C,0x60,0x1B,0x00,
0x7C,0x01,0xC0,0x1D,0x80,0x63,0x33,0x06,0xCC,0x1E,
0x30,0x38,0x61,0xA1,0xFE,0x61,0xE1,0x00,0x02,0x31,
0x51,0x33,0x05,0xA1,0xE1,0xC1,0x08,0x61,0x21,0x9B,
0x86,0x21,0x82,0x0C,0x10,0x20,0x05,0xA1,0xE1,0xD0,
0x20,0xC1,0x20,0xDA,0x30,0xE0,0xC2,0x18,0x42,0x00,
0x08,0x39,0x4A,0x60,0x61,0xFF,0x07,0x86,0x61,0x20,
0x0A,0x51,0x1B,0x68,0x30,0x8F,0xFE,0x83,0x00,0x02,
0x2A,0xE9,0xA3,0x85,0x00,0x06,0x10,0x29,0xE3,0xF0,
0x02,0x12,0x01,0xA3,0x07,0x80,0x01,0xA0,0x1C,0x86,
0x91,0x92,0x62,0x58,0x38,0x30,0x00,0x0A,0x81,0x03,
0x03,0xC0,0xFE,0x86,0x1B,0x70,0x36,0x07,0x0C,0x30,
0xFC,0x0F,0x00,0x06,0x82,0x03,0x20,0x30,0xE7,0xDD,
0xA3,0xD0,0xE4,0x30,0x0A,0x81,0x03,0x07,0xE1,0xFE,
0x70,0xEC,0x0E,0x40,0x30,0x0C,0x03,0x00,0xC0,0x30,
0x0C,0x03,0x00,0xC0,0x47,0xFE,0x0A,0x81,0x03,0x07,
0xC1,0xFC,0x71,0xCC,0x18,0x03,0x00,0xC0,0x70,0x0F,
0x00,0x34,0x80,0x6C,0x0D,0xC3,0x1F,0xE1,0xF0,0x0A,
0x81,0x03,0x00,0x60,0x1C,0x80,0xF2,0x06,0xC1,0x98,
0x73,0x0C,0x63,0x0C,0x8F,0xFE,0x80,0xC0,0x0A,0x81,
0x03,0x20,0xFE,0x96,0x00,0xFC,0x3F,0xE6,0x0D,0x40,
0x1B,0x03,0x70,0xC7,0xF8,0x7C,0x00,0x0A,0x81,0x03,
0x03,0xE0,0xFE,0x30,0xE6,0x0E,0x30,0x06,0x78,0xFF,
0x9C,0x3D,0x60,0x66,0x18,0xFF,0x07,0x80,0x0A,0x81,
0x03,0x23,0xFF,0x00,0x40,0x18,0x06,0x40,0x31,0x01,
0x84,0x8C,0x01,0x02,0x4C,0x00,0x0A,0x81,0x03,0x03,
0xC0,0xFC,0xA6,0x1A,0x0F,0xC3,0x0D,0x58,0x19,0x86,
0x3F,0xC1,0xE0,0x0A,0x81,0x03,0x03,0xC1,0xFC,0x30,
0xCC,0x0A,0x70,0x37,0x0E,0x7F,0xC7,0x9C,0x00,0x6C,
0x19,0xC7,0x1F,0xC1,0xF0,0x02,0x62,0x01,0xA3,0xD0,
0x46,0x02,0x7A,0xE9,0xA3,0xD0,0x47,0x0A,0x0B,0x59,
0x13,0x40,0x04,0x01,0xC0,0xF8,0x3C,0x0F,0x01,0x80,
0x0F,0x00,0x3C,0x00,0xF8,0x01,0xC0,0x04,0x0B,0x39,
0x23,0x63,0xFF,0xC8,0x00,0x8F,0xFE,0x0B,0x59,0x13,
0x50,0x01,0xC0,0x0F,0x80,0x1E,0x00,0x78,0x00,0xC0,
0x78,0x1E,0x0F,0x81,0xC0,0x10,0x00,0x0A,0x81,0x03,
0x07,0xE1,0xFE,0x70,0xEC,0x0C,0x01,0x80,0x70,0x1C,
0x07,0x00,0xC4,0x86,0x10,0x00,0x40,0x60,0x14,0xA9,
0xDD,0x80,0x3F,0x00,0x07,0xFE,0x00,0xF0,0x3C,0x06,
0x00,0x60,0x63,0x99,0x87,0x7E,0xCE,0x37,0x1C,0x31,
0xB0,0x61,0x9B,0x83,0x0D,0x1B,0x03,0x0C,0xD8,0x30,
0xC6,0xC1,0x8E,0x37,0x1C,0xE1,0xDF,0xFE,0x06,0x71,
0xC0,0x38,0x00,0x18,0xE0,0x03,0x83,0xC0,0x78,0x0F,
0xFF,0x80,0x0F,0xE0,0x00,0x0F,0x80,0x03,0xE0,0x0E,
0x04,0x03,0x60,0x07,0x70,0x80,0xC6,0x10,0x30,0x62,
0x0F,0xFE,0x0C,0x06,0x43,0x00,0x68,0xC0,0x06,0x0C,
0x82,0x03,0xDF,0xF0,0xFF,0xC6,0x07,0x4E,0x03,0x30,
0x32,0x3F,0xF1,0x80,0xD3,0x80,0x6C,0x07,0x7F,0xF3,
0xFE,0x00,0x0E,0x81,0x04,0x00,0xF8,0x07,0xFC,0x1C,
0x1C,0x60,0x18,0xC0,0x1E,0x60,0x00,0x60,0x0C,0xC0,
0x30,0xE0,0xE0,0xFF,0x80,0xFC,0x00,0x0D,0x82,0x04,
0x1F,0xF0,0x7F,0xF1,0x80,0xE6,0x01,0x98,0x07,0xCC,
0x01,0xC6,0x01,0x98,0x1C,0x7F,0xF1,0xFF,0x00,0x0C,
0x82,0x03,0xE3,0xFF,0xEF,0x00,0x23,0xFF,0xAF,0x00,
0x23,0xFF,0xC0,0x0A,0x82,0x03,0x63,0xFF,0xBC,0x02,
0x3F,0xED,0xC0,0x00,0x0F,0x81,0x04,0x40,0xFC,0x03,
0xFF,0x07,0x03,0x8E,0x01,0x8C,0x00,0xE7,0x00,0x04,
0x60,0x7F,0x60,0x03,0x30,0x03,0x38,0x03,0x1C,0x0F,
0x0F,0xFE,0x03,0xF0,0x0C,0x82,0x04,0x37,0x00,0xE3,
0xFF,0xF7,0x00,0xC0,0x02,0x82,0x01,0xB7,0xDE,0x30,
0x08,0x81,0x02,0xF4,0x0E,0x80,0xE3,0x0D,0xCE,0x7E,
0x1E,0x00,0x0D,0x82,0x03,0xD8,0x0E,0x60,0x71,0x83,
0x86,0x1C,0x18,0xE0,0x67,0x01,0xB8,0x07,0xE0,0x1F,
0xC0,0x73,0x81,0x87,0x06,0x0E,0x18,0x18,0x60,0x71,
0x80,0xE6,0x01,0xC0,0x09,0x82,0x03,0x37,0x01,0xB8,
0x08,0xFF,0x80,0x0F,0x82,0x04,0xDC,0x01,0xE7,0xC0,
0x7C,0xEC,0x1B,0x9C,0xC6,0x73,0x8D,0x8E,0x70,0xE1,
0x80,0x0C,0x82,0x04,0x18,0x06,0xE0,0x38,0xF0,0x38,
0xD8,0x36,0x61,0xC6,0x31,0xB0,0xCE,0x30,0x6E,0x30,
0x3D,0x80,0xEC,0x03,0x0F,0x81,0x04,0x40,0xF8,0x03,
0xFE,0x07,0x07,0x0E,0x03,0x8C,0x01,0xB3,0x00,0x19,
0x80,0x31,0xC0,0x70,0xE0,0xE0,0x7F,0xC0,0x1F,0x00,
0x0C,0x82,0x03,0xDF,0xF0,0xFF,0xE6,0x03,0x56,0x01,
0xB0,0x19,0xFF,0xCF,0xF8,0xCC,0x00,0x0F,0x89,0xFC,
0x40,0xF8,0x03,0xFE,0x07,0x07,0x0E,0x03,0x8C,0x01,
0xB3,0x00,0x19,0x80,0x31,0xC3,0xB0,0xE0,0xE0,0x7F,
0xE0,0x1F,0xB8,0x00,0x08,0x0C,0x82,0x04,0x1F,0xF8,
0xFF,0xE6,0x03,0xCE,0x01,0xB0,0x1D,0xFF,0xCF,0xFC,
0x61,0x83,0x06,0x18,0x38,0xC0,0xE6,0x03,0x30,0x1D,
0x80,0x60,0x0D,0x81,0x03,0xC1,0xF8,0x1F,0xF0,0xE0,
0xE8,0x60,0x19,0xC0,0x03,0xC0,0x07,0xF0,0x03,0xF0,
0x00,0xF1,0x80,0x33,0x00,0xCE,0x0E,0x1F,0xF8,0x1F,
0x80,0x0C,0x81,0x03,0xA3,0xFF,0xF4,0x18,0x34,0x18,
0x00,0x0C,0x82,0x04,0x37,0x00,0xEF,0x00,0xDC,0x0E,
0x70,0xE1,0xFE,0x07,0xE0,0x0F,0x80,0x03,0xD8,0x00,
0xDC,0x01,0xE1,0x80,0x34,0x18,0x0C,0x1C,0x1C,0x81,
0x83,0x12,0x18,0xC2,0x01,0xB0,0x01,0xF0,0x00,0xE0,
0x00,0x15,0x80,0x05,0x63,0x01,0xC0,0x74,0xC1,0xB0,
0x6A,0x31,0x8C,0x65,0x0D,0x83,0x62,0x03,0x80,0xE0,
0x0F,0x80,0x03,0xCE,0x03,0x87,0x07,0x03,0x06,0x01,
0x8C,0x01,0xDC,0x00,0xD8,0x24,0x0E,0x00,0x1B,0x00,
0x31,0x80,0x71,0xC0,0x60,0xC0,0xC0,0x61,0xC0,0x73,
0x80,0x38,0x0E,0x80,0x03,0x9C,0x03,0x98,0x06,0x18,
0x18,0x38,0x70,0x30,0xC0,0x33,0x00,0x7E,0x00,0x78,
0x34,0x0C,0x00,0x18,0x00,0x0C,0x80,0x03,0x61,0xFF,
0xC0,0x0D,0x00,0x18,0x01,0x80,0x18,0x40,0x30,0x03,
0x00,0x30,0x10,0x60,0x06,0x00,0x8F,0xFF,0x04,0xA1,
0xE1,0xA3,0xF7,0x37,0x23,0x23,0xC0,0x07,0x80,0x01,
0xA3,0x04,0xB0,0x93,0x12,0x32,0x43,0x03,0x81,0x80,
0x04,0xA1,0xE1,0xA3,0xF4,0xF4,0xE0,0xE3,0xC0,0x0A,
0x48,0x3A,0xC1,0x84,0x0F,0x12,0x66,0x43,0x0C,0xC0,
0xC0,0x0C,0x10,0xE3,0x23,0xFF,0xC0,0x03,0x19,0x69,
0xD8,0xC4,0x0A,0x61,0x03,0x07,0xC1,0xFC,0x8C,0x18,
0x0F,0x1F,0xE3,0xCD,0x18,0x33,0x0E,0x3F,0xC7,0xCC,
0x0A,0x81,0x03,0x2B,0x00,0x6F,0x0F,0xF9,0xC3,0x66,
0x06,0xE1,0x9F,0xF3,0x78,0x09,0x61,0x02,0xC3,0xC3,
0xF8,0xC7,0x60,0xEB,0x00,0xC1,0x98,0xE7,0xF0,0x78,
0x0A,0x81,0x03,0x28,0x03,0x0F,0x67,0xFC,0xC3,0xE6,
0x06,0xE1,0xCF,0xF8,0x7B,0x0A,0x61,0x03,0x03,0xC1,
0xFE,0x30,0xCC,0x0E,0x3F,0xF8,0xC0,0x1C,0x19,0xC6,
0x1F,0xC1,0xE0,0x07,0x80,0x01,0xC3,0xC7,0xE0,0xC4,
0x7E,0xD3,0x12,0x60,0x0A,0x81,0xE3,0x03,0xD9,0xFF,
0x30,0xEE,0x0E,0xB0,0x36,0x0E,0x61,0xCF,0xF8,0x7B,
0x00,0x6C,0x19,0xFF,0x0F,0x80,0x09,0x81,0x02,0xEB,
0x00,0xDE,0x3F,0xCE,0x3E,0xE0,0xE3,0x06,0x02,0x81,
0x01,0x63,0x83,0x7B,0xC0,0x04,0xA7,0xE1,0x20,0xE0,
0x34,0xF4,0xDE,0xE0,0x09,0x81,0x02,0xAB,0x00,0xC3,
0xB1,0xCC,0xE3,0x70,0xF8,0x3F,0x0E,0xC3,0x38,0xC6,
0x31,0xCC,0x33,0x0E,0x02,0x81,0x01,0x37,0xDE,0x30,
0x10,0x61,0x04,0x9B,0xC7,0x8F,0xF7,0xE7,0x1E,0x3E,
0xE0,0xC1,0xC6,0x0C,0x18,0x09,0x61,0x02,0xDB,0xC7,
0xF9,0xC7,0xDC,0x1C,0x60,0xC0,0x0B,0x61,0x03,0x43,
0xE0,0x7F,0x0E,0x39,0xC1,0xEB,0x01,0xB8,0x39,0xC7,
0x0F,0xE0,0x7C,0x00,0x0A,0x81,0xE3,0x1B,0xC3,0xFE,
0x70,0xD9,0x81,0xB8,0x67,0xF8,0xDE,0x2B,0x00,0x0A,
0x81,0xE3,0x03,0xD9,0xFF,0x30,0xF9,0x81,0x98,0x73,
0xFE,0x1E,0xE8,0x03,0x06,0x61,0x01,0xDB,0xBF,0x71,
0xB8,0x46,0x00,0x09,0x61,0x02,0xC7,0xC3,0xF9,0x83,
0x60,0x1E,0x03,0xF0,0x3F,0x01,0xC0,0x36,0x1C,0xFE,
0x1F,0x00,0x05,0x80,0x01,0x84,0x96,0x47,0xF5,0x86,
0x1E,0x38,0x09,0x61,0x02,0xF7,0x07,0x18,0x37,0x1C,
0xFF,0x1E,0xC0,0x0B,0x60,0x02,0xE3,0x01,0xC3,0x06,
0x93,0x19,0x03,0x62,0x03,0x80,0x10,0x00,0x0F,0x60,
0x03,0xD8,0x20,0xE3,0x0E,0x19,0x8A,0x31,0x9B,0x30,
0x9B,0x24,0x1B,0x6C,0x0A,0x28,0x81,0xC7,0x00,0xC6,
0x00,0x0A,0x60,0x02,0x9C,0x39,0x86,0x83,0x30,0x3C,
0x40,0x60,0x1E,0x20,0xCC,0x30,0xCE,0x1C,0x0B,0x80,
0xE2,0xE3,0x01,0xC3,0x06,0x18,0x61,0x8C,0x81,0x99,
0x01,0xE0,0x0E,0x00,0xC0,0x1C,0x01,0x80,0xF8,0x0F,
0x00,0x0A,0x60,0x02,0xE1,0xFF,0x00,0xE0,0x38,0x0E,
0x03,0x80,0xE0,0x38,0x0E,0x03,0x80,0x8F,0xFC,0x06,
0xA0,0xE1,0xC3,0x8F,0xC3,0x0C,0x47,0x06,0x30,0xC1,
0xE1,0xC0,0x02,0xAA,0xD9,0xB7,0xDF,0x70,0x06,0xA1,
0xE1,0xDC,0x3C,0xC3,0x07,0x40,0xE3,0xB0,0xC7,0x8E,
0x00,0x0B,0x21,0x33,0x4F,0x01,0xFC,0x51,0xFC,0x07,
0x80,};
/* font data size: 1551 bytes */

static const unsigned char font_tgx_Arial_16_index[] = {
0x00,0x00,0x10,0x05,0x81,0x00,0x46,0x0F,0xC3,
0x18,0x80,0x10,0x82,0x48,0x50,0x0A,0xA1,0x66,0x2E,
0x45,0xF0,0xC2,0x19,0xE3,0x7C,0x75,0x10,0x02,0x2E,
0x4A,0x89,0xE9,0x52,0x2C,0x85,0xD4,0xC5,0x99,0x13,
0x30,0x6B,0x0D,0xA9,0xC9,0x3B,0xC8,0x5D,0x17,0xA4,
0x64,0xBE,0x9D,0x54,0x1A,0x8E,0x55,0x8A,0xD9,0x5E,
0x2C,0x85,0xD0,0xBC,0x58,0x1B,0x1A,0x66,0x8D,0x15,
0xB0,0xB7,0xC7,0x32,0xE8,0xDD,0x8B,0xCB,0x7B,0xCF,
0xFA,0x0A,0xC2,0xC8,0x6B,0x10,0xA2,0x5C,0x57,0x8B,
0xB1,0x8A,0x3A,0x48,0x39,0x25,0x28,0x65,0x9C,0xBE,
0x9A,0x93,0x82,0x73,0xCF,0x0A,0x09,0x42,0xA8,0xCD,
0x24,0xA6,0xD5,0x16,0xAA,0x55,0xDA,0xE1,0x5E,0xAC,
0x2D,0x94,0xB5,0x76,0xF2,0xE9,0xDE,0x5B,0xE5,0x7E,
0x30,0x28,
};
/* font index size: 131 bytes */

const ILI9341_t3_font_t font_tgx_Arial_16 = {
	font_tgx_Arial_16_index,
	0,
	font_tgx_Arial_16_data,
	1,
	0,
	32,
	126,
	0,
	0,
	11,
	5,
	5,
	3,
	5,
	5,
	23,
	16
};



static const unsigned char font_tgx_Arial_18_data[] = {
0x00,0x00,0x01,0xC0,0x02,0x93,0x02,0x37,0xDE,0x08,
0xC0,0x07,0x31,0x62,0x73,0x18,0x0E,0x90,0x03,0xA0,
0x18,0x60,0x71,0x90,0x18,0x64,0x7F,0xFF,0x43,0x0C,
0x47,0xFF,0xF0,0x61,0x80,0xC7,0x08,0x61,0x80,0x0B,
0xA9,0xF3,0x80,0x80,0x3E,0x0F,0xF8,0xC9,0x98,0x8E,
0x31,0x03,0x90,0x1F,0x00,0xFC,0x01,0xF0,0x13,0x40,
0x23,0x62,0x37,0x27,0x32,0xE3,0xFE,0x0F,0x88,0x04,
0x00,0x13,0x91,0x05,0x87,0x80,0xC0,0xFC,0x1C,0x1C,
0xE1,0x81,0x86,0x38,0x18,0x63,0x01,0x86,0x70,0x18,
0x66,0x01,0xCE,0xE0,0x0F,0xCC,0xF0,0x79,0x9F,0x80,
0x1B,0x9E,0x00,0x66,0x1C,0x01,0x8C,0x30,0x30,0xE7,
0x03,0x07,0xE0,0x60,0x3C,0x0F,0x91,0x04,0x41,0xF0,
0x03,0xF8,0x07,0x1C,0x20,0xC1,0x80,0xE3,0x80,0x77,
0x00,0x3E,0x00,0x78,0x00,0xEC,0x01,0x86,0x33,0x07,
0x73,0x03,0xE3,0x01,0xC3,0x81,0xE1,0xC3,0xF0,0xFF,
0x78,0x7C,0x30,0x02,0x31,0x61,0x73,0x06,0xBA,0xDA,
0x01,0x86,0x83,0x25,0x8D,0xC2,0x30,0x96,0x20,0xC0,
0xC0,0xC0,0x06,0xB8,0xDA,0x18,0x18,0x83,0x24,0x6D,
0x0C,0x18,0x78,0x18,0x74,0x18,0x61,0x80,0x08,0x41,
0x52,0xA0,0x61,0x36,0xFF,0x83,0xC3,0x30,0x90,0x0C,
0x61,0x1B,0xEC,0x18,0x23,0xFF,0xEC,0x18,0x00,0x02,
0x32,0xE1,0xE3,0x85,0xA0,0x06,0x11,0x2A,0x23,0xF0,
0x02,0x12,0x01,0xE3,0x07,0x90,0x01,0xE0,0x1C,0x86,
0x0E,0x91,0x94,0x62,0x58,0x46,0x00,0x0C,0x91,0x03,
0x83,0xF0,0x3F,0xC3,0x87,0x18,0x1B,0x70,0x0E,0x70,
0x0C,0xC0,0xC7,0x0E,0x1F,0xE0,0x7E,0x00,0x07,0x92,
0x03,0xA0,0x18,0x78,0xFB,0xDB,0x9E,0x83,0xB0,0x60,
0x0C,0x91,0x03,0x83,0xF0,0x3F,0xC3,0x87,0x30,0x1D,
0x80,0x70,0x00,0x70,0x00,0xC0,0x0C,0x00,0xC0,0x0C,
0x01,0xC0,0x1C,0x01,0x80,0x18,0x02,0x3F,0xFC,0x0C,
0x91,0x03,0x83,0xE0,0x3F,0xC3,0x86,0x38,0x19,0x80,
0xC0,0x06,0x00,0xE0,0x3E,0x01,0xF8,0x00,0x60,0x03,
0xC0,0x01,0xB0,0x0D,0xC0,0xE6,0x0E,0x1F,0xE0,0x7C,
0x00,0x0C,0x91,0x03,0x80,0x18,0x01,0xC8,0x03,0xC0,
0x36,0x03,0xB0,0x19,0x81,0x8C,0x1C,0x60,0xC3,0x0C,
0x18,0xE0,0xC8,0xFF,0xFA,0x00,0xC0,0x0C,0x91,0x03,
0xA0,0xFF,0x8E,0x01,0x2C,0x00,0x6F,0x87,0xFE,0x38,
0x38,0x00,0xF2,0x00,0x6C,0x03,0x60,0x31,0x83,0x87,
0xF8,0x1F,0x00,0x0C,0x91,0x03,0x81,0xF0,0x3F,0xC1,
0x87,0x18,0x1C,0xC0,0x6C,0x00,0x67,0xC3,0x7F,0x1E,
0x1C,0xE0,0x7A,0xC0,0x33,0x03,0x1C,0x38,0x7F,0x80,
0xF8,0x0C,0x91,0x03,0xA3,0xFF,0xC0,0x0D,0x00,0x19,
0x00,0x31,0x00,0x61,0x00,0xC1,0x21,0x81,0x43,0x00,
0x0C,0x91,0x03,0x81,0xE0,0x3F,0xC3,0x86,0x4B,0x03,
0x0C,0x30,0x3F,0x03,0xFC,0x38,0x73,0x81,0xE7,0x00,
0xD8,0x0E,0x70,0x61,0xFE,0x07,0xE0,0x0C,0x91,0x03,
0x83,0xE0,0x3F,0xC3,0x87,0x38,0x1A,0xB0,0x0D,0xC0,
0xE7,0x0F,0x1F,0xD8,0x7C,0xC0,0x07,0x18,0x0C,0x60,
0xC3,0xFC,0x07,0xC0,0x02,0x6A,0x01,0xE3,0xD2,0x08,
0xC0,0x02,0x8A,0xE1,0xE3,0xD2,0x08,0xE1,0x68,0x0C,
0x59,0x1B,0xC0,0x02,0x00,0xF0,0x1F,0x03,0xC0,0xF0,
0x0C,0x00,0x3C,0x00,0x3C,0x00,0x7C,0x00,0xF0,0x00,
0x80,0x0C,0x41,0x2B,0xE3,0xFF,0xE8,0x00,0x23,0xFF,
0xC0,0x0C,0x59,0x1B,0xD0,0x00,0xF0,0x03,0xE0,0x03,
0xC0,0x03,0xC0,0x03,0x00,0xF0,0x3C,0x0F,0x80,0xF0,
0x04,0x00,0x00,0x0C,0x91,0x03,0x83,0xF0,0x3F,0xC3,
0x87,0x38,0x1D,0x80,0x60,0x03,0x00,0x38,0x03,0x80,
0x38,0x03,0x80,0x18,0x48,0x30,0x40,0x00,0x40,0x30,
0x00,0x17,0xB9,0xDE,0x40,0x1F,0xC0,0x00,0x7F,0xF8,
0x01,0xF0,0x3C,0x03,0x80,0x0E,0x07,0x00,0x07,0x06,
0x0F,0x33,0x0C,0x3F,0xB3,0x8C,0x70,0xF1,0x8C,0xE0,
0x61,0x98,0xC0,0x61,0xA3,0x30,0x0C,0x33,0x30,0x0C,
0x63,0x30,0x18,0x63,0x30,0x38,0xE3,0x98,0x79,0xC1,
0x9F,0xFF,0x81,0xC7,0x8E,0x18,0xE0,0x00,0x30,0x70,
0x00,0xE0,0x3C,0x03,0xC0,0x1F,0xFF,0x80,0x03,0xFC,
0x00,0x0F,0x91,0x04,0x60,0x0E,0x04,0x83,0x60,0x80,
0xC6,0x01,0xC7,0x10,0x30,0x62,0x0F,0xFE,0x0C,0x06,
0x1C,0x03,0x43,0x00,0x68,0xC0,0x06,0x0E,0x92,0x04,
0x5F,0xF8,0x3F,0xFC,0x60,0x19,0x58,0x03,0x30,0x0C,
0x7F,0xF0,0xFF,0xF1,0x80,0x73,0x00,0x79,0xC0,0x0D,
0x80,0x73,0xFF,0xE7,0xFF,0x00,0x10,0x91,0x04,0x80,
0x7E,0x01,0xFF,0xC1,0xE0,0x71,0xC0,0x18,0xC0,0x0E,
0xE0,0x00,0xCC,0x00,0x03,0x00,0x19,0x80,0x1C,0xE0,
0x1C,0x3C,0x1C,0x0F,0xFC,0x01,0xF8,0x00,0x0F,0x92,
0x04,0x9F,0xF8,0x1F,0xFE,0x18,0x07,0x18,0x03,0x98,
0x01,0x98,0x01,0xF3,0x00,0x1B,0x00,0x3B,0x00,0x33,
0x00,0x73,0x00,0xE3,0xFF,0xC3,0xFF,0x00,0x0E,0x92,
0x04,0x63,0xFF,0xFC,0xC0,0x02,0x3F,0xFE,0xCC,0x00,
0x23,0xFF,0xF0,0x0C,0x92,0x03,0xE3,0xFF,0xF3,0x00,
0x23,0xFF,0xB7,0x00,0x18,0x00,0x10,0x91,0x04,0xC0,
0x7E,0x01,0xFF,0xC1,0xE0,0xF0,0xC0,0x18,0xC0,0x0E,
0x60,0x02,0x9C,0x00,0x08,0xC0,0x7F,0x60,0x01,0xC3,
0x00,0x18,0xC0,0x0C,0x78,0x3E,0x1F,0xFC,0x01,0xF8,
0x00,0x0E,0x92,0x04,0xB7,0x00,0x36,0x00,0x71,0xFF,
0xFE,0xE0,0x06,0xC0,0x0C,0x02,0x92,0x01,0xB7,0xDE,
0xB0,0x0A,0x91,0x03,0x74,0x03,0xB0,0x0E,0x70,0x33,
0x0C,0x7F,0x87,0xC0,0x0F,0x92,0x04,0x58,0x03,0x98,
0x07,0x18,0x0E,0x18,0x1C,0x18,0x38,0x18,0x70,0x18,
0xE0,0x19,0xC0,0x1B,0xE0,0x1F,0xE0,0x1E,0x70,0x1C,
0x38,0x18,0x1C,0x23,0x01,0xC3,0x00,0xE3,0x00,0x73,
0x00,0x38,0x0B,0x92,0x03,0xB7,0x00,0x6E,0x00,0x8C,
0x01,0x1F,0xFC,0x11,0x92,0x05,0x5C,0x00,0x78,0xF0,
0x07,0xCE,0xC0,0x6E,0x73,0x06,0x73,0x8C,0x63,0x9C,
0x36,0x1C,0xE0,0xE0,0xC0,0x0E,0x92,0x04,0xA3,0x80,
0x38,0xF0,0x0D,0xB0,0x1C,0x66,0x06,0xC6,0x0E,0x30,
0xC3,0x60,0xC7,0x18,0x19,0xB0,0x1B,0x8C,0x03,0xE3,
0x00,0x70,0x11,0x91,0x04,0xC0,0x7C,0x00,0xFF,0xC0,
0x78,0x3C,0x18,0x03,0x21,0x80,0x0D,0x98,0x00,0x38,
0x60,0x03,0x0C,0x01,0x83,0xC1,0xE0,0x7F,0xF0,0x03,
0xE0,0x00,0x0E,0x92,0x04,0x5F,0xFC,0x3F,0xFC,0x60,
0x1C,0xC0,0x1E,0x70,0x03,0x60,0x0E,0xC0,0x39,0xFF,
0xE3,0xFF,0x8D,0xC0,0x00,0x11,0x99,0xFC,0xC0,0x7C,
0x00,0xFF,0xC0,0x78,0x3C,0x18,0x03,0x21,0x80,0x0D,
0x98,0x00,0x33,0x00,0x1C,0xC0,0xC6,0x18,0x3F,0x87,
0x83,0xC0,0x7F,0xF8,0x07,0xEF,0x00,0x00,0xC0,0x0F,
0x92,0x04,0x9F,0xFC,0x1F,0xFF,0x18,0x07,0x27,0x00,
0x33,0x00,0x73,0x00,0xE3,0xFF,0xE3,0xFF,0x83,0x07,
0x03,0x03,0x03,0x03,0x83,0x01,0xC4,0x60,0x1C,0x60,
0x0E,0x60,0x07,0x0F,0x91,0x04,0x40,0xFC,0x03,0xFF,
0x07,0x03,0x8C,0x01,0xCC,0x00,0xCC,0x00,0x0E,0x00,
0x07,0xE0,0x03,0xFE,0x00,0x7F,0x80,0x03,0x80,0x00,
0xE3,0x00,0x19,0x80,0x39,0xE0,0x70,0xFF,0xE0,0x3F,
0x80,0x0E,0x90,0x03,0xA3,0xFF,0xFD,0x03,0x03,0x40,
0xC0,0x80,0x30,0x00,0x0E,0x92,0x04,0xB7,0x00,0x3D,
0xC0,0x0C,0xC0,0x31,0xC0,0xE1,0xFF,0x80,0xFC,0x00,
0x0F,0x91,0x04,0x58,0x00,0xDC,0x01,0xE1,0x80,0x31,
0xC0,0x74,0x18,0x0C,0x91,0x83,0x10,0x18,0xC0,0x1D,
0xC2,0x01,0xB0,0x01,0xF0,0x40,0x1C,0x00,0x19,0x90,
0x06,0x98,0x03,0x80,0x36,0x00,0xE0,0x1E,0x58,0x0D,
0x80,0xC3,0x07,0x70,0x64,0x18,0x31,0x83,0x06,0x0C,
0x61,0xC9,0x18,0xC1,0x8C,0x48,0x6C,0x06,0xC0,0x1F,
0x01,0xF0,0x80,0x70,0x07,0x00,0x11,0x90,0x04,0x4E,
0x00,0xE1,0xC0,0x70,0x38,0x38,0x06,0x0C,0x01,0xC7,
0x00,0x3B,0x80,0x06,0xC0,0x80,0x1C,0x00,0x0F,0x80,
0x03,0x60,0x01,0xDC,0x00,0xE3,0x80,0x70,0x70,0x18,
0x0C,0x0E,0x03,0x87,0x00,0x73,0x80,0x0E,0x10,0x90,
0x04,0x18,0x00,0xE6,0x00,0xE1,0x80,0x60,0xE0,0x70,
0x38,0x70,0x0C,0x30,0x07,0x38,0x01,0x98,0x20,0x0F,
0x03,0x40,0x60,0x00,0x30,0x00,0x0E,0x90,0x03,0xE1,
0xFF,0xF0,0x00,0xC0,0x03,0x80,0x0E,0x00,0x38,0x00,
0x60,0x01,0xC0,0x07,0x00,0x1C,0x00,0x30,0x00,0xE0,
0x03,0x80,0x0E,0x00,0x18,0x00,0x60,0x02,0x3F,0xFF,
0x05,0xBA,0xD9,0xE3,0xFB,0x8D,0xC5,0xE2,0x3E,0x07,
0x90,0x01,0xE3,0x04,0xB0,0x38,0x93,0x14,0x32,0x43,
0x40,0x30,0x05,0xB8,0xD9,0xE3,0xFA,0x3D,0x1D,0x8E,
0x3E,0x0A,0x51,0x43,0x01,0x84,0x0F,0x12,0x66,0x4B,
0x0C,0xC0,0xC0,0x0F,0x17,0xDB,0xA3,0xFF,0xF8,0x04,
0x19,0x7A,0x1C,0x61,0x80,0x0C,0x69,0x03,0x83,0xF0,
0x7F,0xC7,0x07,0x30,0x18,0x00,0xC0,0x3E,0x1F,0xF1,
0xF1,0x98,0x0C,0xC0,0xE7,0x0F,0x1F,0xD8,0x7C,0x60,
0x0B,0x92,0x03,0xAF,0x00,0x33,0xC3,0x7E,0x3C,0x73,
0x83,0x5E,0x03,0x70,0x67,0x8E,0x6F,0xC6,0x78,0x0B,
0x69,0x03,0x43,0xF0,0x7F,0x8E,0x1D,0xC0,0xEB,0x00,
0x30,0x1B,0x83,0x9C,0x30,0xFE,0x07,0xC0,0x0B,0x91,
0x03,0xAC,0x01,0x87,0x98,0xFD,0x9C,0x79,0x83,0xDE,
0x03,0x30,0x73,0x8F,0x1F,0xB0,0xF3,0x0C,0x69,0x03,
0x83,0xF0,0x3F,0xC3,0x87,0x18,0x19,0x80,0x71,0xFF,
0xF1,0x80,0x0E,0x03,0x38,0x30,0xFF,0x03,0xF0,0x07,
0x90,0x01,0xC3,0xC7,0xE4,0xC4,0x7F,0xD3,0x14,0x60,
0x0B,0x91,0xDB,0x83,0xCC,0x7E,0xCE,0x3C,0xC1,0xEF,
0x01,0x98,0x39,0xC7,0x8F,0xD8,0x79,0x80,0x1B,0x03,
0xB8,0x71,0xFF,0x0F,0xC0,0x0A,0x92,0x03,0xAF,0x00,
0x67,0x8D,0xF9,0xE3,0xB8,0x3D,0xC0,0xE3,0x03,0x02,
0x92,0x01,0xA3,0x93,0x7C,0xC0,0x05,0xBF,0xD9,0xA0,
0x72,0x0D,0x1E,0x8E,0x06,0xFB,0xC0,0x0B,0x92,0x03,
0x6F,0x00,0x30,0x73,0x0E,0x31,0xC3,0x38,0x37,0x03,
0xE0,0x3F,0x03,0x38,0x31,0xC3,0x0C,0x30,0x63,0x07,
0x30,0x38,0x02,0x92,0x01,0xB7,0xDE,0xB0,0x12,0x6A,
0x05,0x99,0xE1,0xE3,0x7E,0xFE,0x78,0xF8,0xEE,0x0E,
0x0F,0x70,0x30,0x38,0xC0,0xC0,0xC0,0x0A,0x6A,0x03,
0x99,0xE3,0x7E,0x78,0xEE,0x0F,0x70,0x38,0xC0,0xC0,
0x0C,0x69,0x03,0x83,0xF0,0x3F,0xC3,0x87,0x38,0x1E,
0xF0,0x0D,0xC0,0xE7,0x0E,0x1F,0xE0,0x7E,0x00,0x0B,
0x92,0xDB,0x99,0xE1,0xBF,0x1E,0x39,0xC1,0xAF,0x01,
0xB8,0x33,0xC7,0x37,0xE3,0x3C,0x5E,0x00,0x0B,0x91,
0xDB,0x83,0xCC,0x7E,0xCE,0x3D,0xC1,0xEF,0x01,0x98,
0x39,0xC7,0x8F,0xF8,0x79,0xD8,0x03,0x06,0x6A,0x02,
0x1B,0xBF,0x71,0xB8,0x4E,0x00,0x0B,0x69,0x03,0x47,
0xE0,0xFF,0x9C,0x19,0x80,0x1C,0x00,0xFC,0x07,0xF8,
0x0F,0xC0,0x1D,0x80,0xDC,0x1C,0xFF,0x83,0xE0,0x07,
0x88,0x09,0xE8,0xC4,0x7F,0xD3,0x10,0x60,0x7C,0x3C,
0x0A,0x6A,0x03,0xB7,0x03,0x8C,0x0D,0x83,0xB8,0xF3,
0xF6,0x3C,0xC0,0x0B,0x68,0x02,0xE3,0x01,0xCB,0x06,
0x83,0x19,0x23,0x62,0x03,0x80,0x10,0x00,0x13,0x68,
0x04,0xD8,0x08,0x0D,0x81,0xC0,0xCC,0x1C,0x1E,0x18,
0x6C,0x30,0xC6,0xC6,0x0C,0xC6,0x60,0x6C,0x6E,0x06,
0xC6,0xC0,0x68,0x2C,0x40,0x70,0x70,0x03,0x03,0x00,
0x0B,0x68,0x02,0xDC,0x0C,0xC1,0x86,0x38,0x73,0x03,
0x62,0x43,0x80,0x6C,0x0E,0xE0,0xC6,0x18,0x33,0x83,
0x80,0x0B,0x91,0xDB,0x23,0x01,0xC3,0x06,0x30,0xC8,
0x31,0x83,0x30,0x1B,0x10,0x3C,0x01,0xC2,0x43,0x00,
0x60,0x1E,0x01,0xC0,0x00,0x0B,0x68,0x03,0x21,0xFF,
0x80,0x30,0x06,0x00,0xC0,0x1C,0x03,0x80,0x70,0x0E,
0x01,0xC0,0x18,0x04,0x7F,0xF0,0x08,0xB9,0xDA,0x00,
0xE1,0xFD,0x18,0x18,0x47,0x00,0xC3,0x46,0x03,0x00,
0xF0,0x38,0x02,0xBA,0xD9,0xB7,0xDF,0x78,0xC0,0x08,
0xBF,0xDA,0x1C,0x0F,0x0D,0x18,0x06,0x40,0x38,0x33,
0x46,0x03,0x0F,0x07,0x00,0x0D,0x21,0x3B,0xC7,0x80,
0x7F,0x8D,0x8F,0xF0,0x0F,0x00,};
/* font data size: 1886 bytes */

static const unsigned char font_tgx_Arial_18_index[] = {
0x00,0x00,0x10,0x05,
0x81,0x00,0x4E,0x11,0xC3,0x98,0x99,0x13,0xA2,0xB0,
0x5E,0x0C,0x71,0xA2,0x35,0xC6,0xE0,0xE0,0x1D,0xA4,
0x08,0x87,0x12,0xB2,0x96,0x59,0x4B,0xF9,0x9B,0x35,
0xC7,0x24,0xF2,0x1E,0xB3,0xE6,0x82,0x50,0x9A,0x29,
0x48,0xAA,0x2D,0x52,0xAC,0x25,0xC4,0xC0,0x18,0x7B,
0x1C,0x67,0xED,0x35,0xA9,0xB6,0x07,0x0C,0xE4,0x5D,
0x3B,0xC2,0x7C,0x0F,0xDE,0x0C,0xC3,0xB8,0xC3,0x1B,
0xA3,0xF4,0x9A,0x98,0x13,0xAA,0x83,0x52,0x8A,0x63,
0x4F,0xAA,0x3D,0x53,0xAB,0x35,0x7E,0xBC,0x58,0xBB,
0x3D,0x6C,0x6E,0x3D,0xD2,0xBD,0x77,0xE7,0x00,0x60,
0xBC,0x49,0x8A,0xB1,0xEE,0x4A,0xCB,0xB9,0xC3,0x41,
0xE8,0xCD,0x47,0xAB,0xB5,0xDE,0xCA,0xDD,0x5B,0xFF,
0x8B,0xF2,0xCE,0x79,0xD0,0xFA,0x98,
};
/* font index size: 131 bytes */

const ILI9341_t3_font_t font_tgx_Arial_18 = {
	font_tgx_Arial_18_index,
	0,
	font_tgx_Arial_18_data,
	1,
	0,
	32,
	126,
	0,
	0,
	11,
	5,
	5,
	3,
	5,
	5,
	27,
	18
};



static const unsigned char font_tgx_Arial_20_data[] = {
0x00,0x00,0x01,0x00,0x02,0xA3,0x01,0x1B,0xEF,0x1C,
0x11,0x80,0x08,0x39,0x35,0x5B,0x86,0x0F,0xA0,0x02,
0x10,0x0C,0x18,0x1C,0x3A,0x43,0x06,0x47,0xFF,0xFA,
0x18,0x30,0x38,0x31,0x1F,0xFF,0xE0,0xC1,0x81,0xC3,
0x84,0x30,0x60,0x0D,0xB9,0xFA,0x00,0x20,0x03,0xE0,
0x3F,0xC1,0xCB,0x8E,0x27,0x30,0x8D,0x18,0x40,0x31,
0x00,0xFC,0x00,0xFE,0x00,0x7C,0x01,0x3A,0x00,0x87,
0x18,0x43,0x31,0x1C,0xE4,0xE1,0xFF,0x01,0xF0,0x80,
0x20,0x00,0x15,0xA2,0x03,0x23,0xC0,0x18,0x1F,0x80,
0xC0,0x66,0x03,0x04,0x61,0x83,0x02,0x30,0xC3,0x00,
0xC3,0x18,0x03,0x98,0xE0,0x07,0xE3,0x1E,0x0F,0x18,
0xFC,0x00,0x63,0x34,0x00,0x63,0x0C,0x03,0x0C,0x30,
0x1C,0x30,0xC0,0x60,0xC3,0x03,0x83,0x98,0x0C,0x07,
0xE0,0x60,0x0F,0x00,0x11,0xA1,0x02,0x60,0x78,0x00,
0x7F,0x80,0x38,0x70,0x49,0x81,0x80,0x30,0xC0,0x06,
0xF0,0x00,0xF0,0x00,0xF8,0x00,0x73,0x00,0x38,0xE1,
0x9C,0x1C,0xE6,0x03,0x71,0x80,0x7C,0x60,0x0E,0x1C,
0x07,0xC3,0x87,0xF8,0x7F,0xCF,0x07,0xC1,0x80,0x02,
0x39,0x34,0xBB,0x80,0x06,0xD2,0xE9,0x20,0xE0,0x68,
0x32,0x58,0xDC,0x27,0x09,0x62,0x0C,0x81,0x81,0x80,
0x06,0xD1,0xE9,0x2C,0x21,0x88,0x32,0x46,0xD0,0xE0,
0x30,0xF2,0x34,0x19,0x0C,0x30,0x0A,0x49,0x2D,0x70,
0x18,0x13,0x27,0xFE,0x3F,0x03,0xC0,0xFC,0x39,0xC2,
0x10,0x0E,0x71,0x0A,0x18,0x06,0x04,0x7F,0xFF,0x80,
0x60,0x00,0x02,0x3A,0xED,0x11,0xCA,0xD0,0x07,0x11,
0x19,0x31,0xFC,0x02,0x12,0x01,0x11,0x80,0x08,0xA0,
0x01,0x10,0x07,0x20,0xD2,0x18,0x1C,0x91,0x89,0x30,
0x96,0x07,0x03,0x00,0x0D,0xA1,0x02,0x00,0xF8,0x0F,
0xF8,0x70,0x74,0x30,0x1B,0x70,0x07,0x38,0x03,0x86,
0x03,0x1C,0x1C,0x3F,0xE0,0x3E,0x00,0x08,0xA2,0x02,
0x10,0x06,0x0F,0x0F,0x9F,0xDE,0x6C,0x3D,0x03,0xC0,
0x30,0x0D,0xA1,0x02,0x00,0xF8,0x0F,0xF8,0x70,0x71,
0x80,0xF1,0x80,0x38,0x00,0x18,0x00,0xC0,0x07,0x00,
0x18,0x00,0xC0,0x06,0x00,0x30,0x03,0x80,0x1C,0x00,
0xE0,0x06,0x00,0x47,0xFF,0xC0,0x0D,0xA1,0x02,0x01,
0xF8,0x0F,0xF0,0x70,0xE3,0x80,0xCC,0x03,0x00,0x0C,
0x00,0x70,0x03,0x80,0x7C,0x01,0xF8,0x00,0x70,0x00,
0xF0,0x00,0x38,0xC0,0x19,0x80,0xC7,0x07,0x0F,0xF8,
0x0F,0x80,0x0E,0xA1,0x02,0x00,0x03,0x00,0x0E,0x00,
0x3C,0x00,0xF8,0x01,0xB0,0x06,0x60,0x18,0xC0,0x71,
0x81,0xC3,0x03,0x06,0x0C,0x0C,0x30,0x18,0xE0,0x32,
0x3F,0xFF,0xB0,0x03,0x00,0x0D,0xA1,0x02,0x10,0x7F,
0xE3,0x80,0x25,0x80,0x04,0xF8,0x3F,0xF8,0xF0,0x73,
0x00,0xD4,0x00,0x38,0xC0,0x19,0x80,0xC7,0x06,0x0F,
0xF8,0x0F,0x80,0x0D,0xA1,0x02,0x00,0x7C,0x07,0xF8,
0x38,0x71,0xC0,0xE6,0x01,0x98,0x00,0xC0,0x03,0x1E,
0x0D,0xFE,0x3C,0x1C,0xE0,0x35,0x60,0x0C,0xC0,0x33,
0x01,0x86,0x0E,0x0F,0xF0,0x1F,0x00,0x0D,0xA1,0x02,
0x11,0xFF,0xF0,0x00,0x80,0x04,0x00,0x30,0x01,0x80,
0x04,0x00,0x30,0x80,0x30,0x48,0x30,0x24,0x30,0x14,
0x30,0x00,0x0D,0xA1,0x02,0x00,0xF8,0x0F,0xF8,0x30,
0x65,0x30,0x18,0x60,0xC0,0xFE,0x07,0xFC,0x38,0x38,
0xC0,0x6A,0xC0,0x19,0x80,0xC7,0x07,0x0F,0xF8,0x0F,
0x80,0x0D,0xA1,0x02,0x00,0xF8,0x0F,0xF8,0x70,0x71,
0x80,0xCC,0x01,0x56,0x00,0xCC,0x07,0x38,0x3C,0x7F,
0xB0,0x78,0xC0,0x03,0x00,0x19,0x80,0x67,0x01,0x8E,
0x1C,0x1F,0xE0,0x3E,0x00,0x02,0x7B,0x01,0x11,0xE9,
0x44,0x60,0x02,0xA3,0xED,0x11,0xE9,0x44,0x72,0xB4,
0x0C,0x6A,0x0E,0x00,0x01,0x00,0x78,0x0F,0x81,0xF0,
0x7C,0x07,0x80,0x30,0x01,0xE0,0x07,0xC0,0x07,0xC0,
0x0F,0x80,0x1E,0x00,0x10,0x0D,0x41,0x1A,0x11,0xFF,
0xFA,0x00,0x04,0x7F,0xFC,0x0C,0x6A,0x0E,0x08,0x00,
0x78,0x01,0xF0,0x03,0xE0,0x03,0xE0,0x07,0x80,0x0C,
0x01,0xE0,0x3E,0x0F,0x81,0xF0,0x1E,0x00,0x80,0x00,
0x0E,0xA1,0x02,0x00,0xFC,0x07,0xFE,0x1E,0x0E,0x30,
0x0E,0xE0,0x0D,0x80,0x18,0x00,0x30,0x00,0xE0,0x03,
0x80,0x0E,0x00,0x38,0x00,0xE0,0x03,0x82,0x40,0xC0,
0x80,0x00,0x20,0x0C,0x00,0x1A,0xD2,0xEB,0x80,0x07,
0xF8,0x00,0x03,0xFF,0xE0,0x01,0xF0,0x1E,0x00,0x78,
0x00,0xE0,0x1C,0x00,0x0E,0x07,0x07,0x8C,0xE0,0xC3,
0xFD,0x8C,0x38,0xE1,0xF1,0xC6,0x18,0x1C,0x18,0xC6,
0x01,0x83,0x30,0xC0,0x30,0x68,0xC6,0x00,0xC1,0x98,
0xC0,0x18,0x73,0x18,0x06,0x0C,0x63,0x00,0xC3,0x8C,
0x70,0x38,0x61,0xC7,0x1F,0x38,0x18,0x7F,0x7E,0x03,
0x87,0xC7,0x80,0x30,0x00,0x00,0xC7,0x00,0x00,0x70,
0x78,0x00,0x1C,0x03,0xE0,0x1F,0x00,0x3F,0xFF,0x80,
0x00,0xFF,0x80,0x00,0x11,0xA1,0x02,0x70,0x03,0x80,
0x80,0x36,0x00,0x1D,0xC1,0x00,0xC6,0x00,0x71,0xC2,
0x03,0x06,0x10,0x30,0x18,0x0F,0xFE,0x07,0xFF,0xC1,
0x80,0x30,0xE0,0x0E,0x86,0x00,0x34,0x60,0x00,0xC0,
0x10,0xA2,0x02,0x6F,0xFE,0x07,0xFF,0xC3,0x00,0x71,
0x80,0x1D,0x38,0x00,0xCC,0x00,0xE6,0x00,0xE3,0xFF,
0xE1,0xFF,0xF8,0xC0,0x0E,0x60,0x03,0xCE,0x00,0x1B,
0x00,0x1D,0x80,0x1C,0xFF,0xFC,0x7F,0xF8,0x00,0x12,
0xA1,0x02,0x80,0x3F,0x80,0x1F,0xFC,0x07,0x81,0xC1,
0xC0,0x1C,0x70,0x01,0xCC,0x00,0x1B,0x80,0x00,0xCC,
0x00,0x01,0xC0,0x01,0x98,0x00,0x73,0x80,0x0C,0x38,
0x03,0x83,0x81,0xE0,0x3F,0xF8,0x01,0xFC,0x00,0x11,
0xA2,0x02,0x8F,0xFE,0x03,0xFF,0xE0,0xC0,0x1E,0x30,
0x01,0x91,0x80,0x06,0xDC,0x00,0x1B,0x00,0x0F,0x18,
0x00,0x66,0x00,0x31,0x80,0x3C,0x7F,0xFC,0x1F,0xFC,
0x00,0x0F,0xA2,0x02,0x71,0xFF,0xFF,0x70,0x00,0x47,
0xFF,0xED,0xC0,0x01,0x1F,0xFF,0xC0,0x0E,0xA2,0x02,
0x31,0xFF,0xFE,0xE0,0x01,0x1F,0xFE,0x6E,0x00,0x11,
0x80,0x00,0x13,0xA1,0x02,0xC0,0x1F,0xC0,0x0F,0xFF,
0x01,0xE0,0x78,0x38,0x01,0xC7,0x00,0x0C,0x60,0x00,
0x66,0x00,0x01,0x38,0x00,0x02,0x30,0x07,0xFB,0x00,
0x01,0xB8,0x00,0x19,0x80,0x01,0x9C,0x00,0x18,0xE0,
0x03,0x87,0x80,0xF0,0x3F,0xFE,0x00,0x7F,0x00,0x10,
0xA2,0x02,0x9B,0x80,0x07,0x18,0x00,0x71,0xFF,0xFF,
0xB8,0x00,0x71,0x80,0x06,0x02,0xA3,0x01,0x1B,0xEF,
0x98,0x0B,0xA1,0x01,0xDA,0x00,0xF4,0x01,0xC6,0x03,
0x70,0x33,0x06,0x3F,0xE0,0xF8,0x10,0xA2,0x02,0x6C,
0x00,0xE6,0x00,0xE3,0x00,0xE1,0x80,0xE0,0xC0,0xE0,
0x60,0xE0,0x30,0xE0,0x18,0xE0,0x0C,0xF0,0x06,0xFC,
0x03,0xEE,0x01,0xE3,0x80,0xE0,0xE0,0x8C,0x07,0x06,
0x01,0xC4,0x60,0x0E,0x30,0x03,0x98,0x00,0xE0,0x0D,
0xA2,0x02,0x1B,0x80,0x0D,0xC0,0x05,0x60,0x02,0x3F,
0xFE,0x11,0xA3,0x02,0xEE,0x00,0x3C,0xF8,0x03,0xE7,
0x60,0x37,0x39,0x83,0x36,0x61,0xCE,0x71,0x8C,0x73,
0x86,0xC3,0x60,0xF0,0xE3,0x07,0x06,0x10,0xA2,0x02,
0x91,0xC0,0x06,0xF0,0x03,0x7C,0x01,0xB6,0x00,0xD9,
0x80,0x71,0x8C,0x06,0xC3,0x03,0x8C,0x18,0x36,0x06,
0x1C,0x60,0x31,0xB0,0x0C,0xD8,0x03,0x6C,0x01,0xF6,
0x00,0x7C,0x60,0x03,0x80,0x14,0xA1,0x02,0xC0,0x1F,
0x80,0x07,0xFF,0x80,0x78,0x1E,0x07,0x00,0x38,0x70,
0x00,0xE3,0x00,0x03,0x38,0x00,0x1B,0x30,0x00,0x0E,
0x18,0x00,0x18,0xE0,0x01,0xC3,0x80,0x1C,0x0F,0x03,
0xC0,0x3F,0xFC,0x00,0x3F,0x00,0x10,0xA2,0x02,0x6F,
0xFF,0x07,0xFF,0xE3,0x00,0x39,0x80,0x0F,0x58,0x00,
0x6C,0x00,0x66,0x00,0x73,0xFF,0xF1,0xFF,0xE1,0xB8,
0x00,0x0C,0x00,0x00,0x14,0xA9,0xFE,0xC0,0x1F,0x80,
0x07,0xFF,0x80,0x78,0x1E,0x07,0x00,0x38,0x70,0x00,
0xE8,0x60,0x00,0x6C,0xC0,0x00,0x33,0x00,0x03,0x98,
0x00,0x18,0xE0,0x79,0xC3,0x81,0xFC,0x0F,0x03,0xE0,
0x1F,0xFF,0x80,0x3F,0x8E,0x00,0x00,0x30,0x10,0xA2,
0x02,0x8F,0xFF,0x87,0xFF,0xE3,0x00,0x39,0x80,0x0F,
0x38,0x00,0x6C,0x00,0x76,0x00,0x73,0xFF,0xF1,0xFF,
0xE0,0xC0,0xE0,0x60,0x30,0x30,0x0C,0x18,0x07,0x0C,
0x01,0xC6,0x00,0x63,0x00,0x19,0x80,0x0E,0xC0,0x03,
0x10,0xA1,0x02,0x60,0x7F,0x00,0xFF,0xE0,0xE0,0x78,
0xE0,0x0D,0x0C,0x00,0x67,0x00,0x03,0xE0,0x00,0xFF,
0x00,0x3F,0xF0,0x03,0xFE,0x00,0x0F,0x00,0x01,0xE3,
0x00,0x0D,0xC0,0x06,0x70,0x06,0x1E,0x0F,0x07,0xFF,
0x00,0xFE,0x00,0x10,0xA0,0x02,0x11,0xFF,0xFF,0xA0,
0x30,0x1A,0x03,0x01,0x40,0x30,0x00,0x10,0xA2,0x02,
0x9B,0x80,0x07,0xB8,0x00,0x6C,0x00,0x37,0x00,0x39,
0x80,0x18,0xF0,0x38,0x3F,0xF8,0x03,0xF0,0x00,0x11,
0xA1,0x02,0x6C,0x00,0x1B,0x80,0x0F,0x0C,0x00,0x69,
0x30,0x06,0x40,0xC0,0x60,0x38,0x38,0x80,0xC1,0x84,
0x03,0x18,0x00,0xCE,0x08,0x03,0x60,0x00,0xF8,0x10,
0x03,0x80,0x1B,0xA0,0x03,0x91,0x80,0x1C,0x00,0xE5,
0x80,0x6C,0x03,0x18,0x0C,0x60,0x34,0x18,0x18,0xC0,
0xC1,0x83,0x86,0x0C,0x1C,0x30,0x61,0xC0,0xC3,0x06,
0x18,0x0C,0x70,0x31,0x80,0xC6,0x03,0x18,0x0E,0x60,
0x33,0x80,0x6E,0x03,0xB0,0x80,0xD8,0x03,0x60,0x07,
0x80,0x3C,0x10,0x0E,0x00,0x38,0x00,0x13,0xA0,0x02,
0x67,0x00,0x1C,0x38,0x03,0x81,0xC0,0x70,0x0C,0x06,
0x00,0x60,0xC0,0x07,0x1C,0x00,0x3B,0x80,0x01,0xB0,
0x10,0x01,0xC0,0x00,0x1E,0x00,0x03,0x60,0x00,0x63,
0x00,0x0E,0x38,0x01,0xC1,0xC0,0x18,0x0C,0x03,0x00,
0x60,0x70,0x07,0x0E,0x00,0x39,0xC0,0x01,0xC0,0x12,
0xA0,0x02,0x4C,0x00,0x1C,0xC0,0x07,0x0C,0x00,0xC1,
0xC0,0x38,0x1C,0x0E,0x01,0x83,0x80,0x18,0x70,0x03,
0x9C,0x00,0x33,0x02,0x00,0x78,0x0D,0x00,0xC0,0x20,
0x03,0x00,0x10,0xA0,0x02,0x30,0xFF,0xFC,0x00,0x0C,
0x00,0x0C,0x00,0x0E,0x00,0x06,0x00,0x06,0x00,0x06,
0x00,0x07,0x00,0x03,0x00,0x03,0x00,0x03,0x80,0x01,
0x80,0x01,0x80,0x01,0x80,0x01,0xC0,0x00,0xC0,0x00,
0xC0,0x01,0x1F,0xFF,0xE0,0x05,0xD2,0xE9,0x11,0xFD,
0xC6,0xE3,0x70,0xC4,0x7C,0x08,0xA0,0x01,0x11,0x81,
0x2C,0x12,0x60,0x38,0x91,0x89,0x0C,0x90,0x60,0x38,
0x0C,0x05,0xD1,0xE9,0x11,0xFD,0x1E,0x8F,0x46,0x1C,
0x7C,0x0C,0x59,0x25,0xC0,0x60,0x80,0xF0,0x81,0x98,
0x93,0x0C,0x86,0x06,0x60,0x18,0x11,0x17,0xEA,0x11,
0xFF,0xFF,0x05,0x21,0x41,0x2E,0x1C,0x30,0x60,0x0D,
0x79,0x01,0xE1,0xFC,0x1F,0xF8,0x70,0x73,0x00,0xC0,
0x03,0x00,0x3C,0x1F,0xF1,0xFC,0xC6,0x03,0x46,0x01,
0x98,0x0E,0x70,0xF8,0xFF,0x61,0xF8,0xC0,0x0D,0xA2,
0x02,0x17,0x80,0x06,0x7C,0x1B,0xFC,0x78,0x39,0xC0,
0x66,0x01,0xEF,0x00,0x6C,0x03,0xB8,0x0C,0xF0,0xE3,
0x7F,0x0C,0xF8,0x00,0x0C,0x79,0x01,0xC0,0xF8,0x1F,
0xE1,0xC3,0x8C,0x0E,0xE0,0x3A,0xC0,0x08,0xC0,0x33,
0x03,0x1C,0x38,0x7F,0x80,0xF8,0x0D,0xA1,0x02,0x16,
0x00,0x30,0x7C,0xC7,0xFB,0x38,0x3C,0xC0,0x77,0x00,
0xEF,0x00,0x6E,0x01,0x98,0x0E,0x70,0x78,0xFF,0x60,
0xF9,0x80,0x0D,0x79,0x01,0xE0,0xF8,0x0F,0xF8,0x70,
0x71,0x80,0xD1,0x80,0x38,0xFF,0xFC,0x60,0x01,0xC0,
0x03,0x00,0xCF,0x0E,0x1F,0xF0,0x1F,0x80,0x08,0xA0,
0x00,0xE1,0xF1,0xFC,0x98,0x47,0xF6,0x98,0x61,0x80,
0x0D,0xA9,0xEA,0x00,0xF9,0x8F,0xFE,0x70,0x79,0x80,
0xEE,0x01,0xDE,0x00,0xDC,0x03,0x30,0x1C,0xE0,0xF1,
0xFF,0xC1,0xF3,0x00,0x0D,0x80,0x36,0x01,0x8E,0x0E,
0x3F,0xF0,0x3F,0x00,0x0C,0xA2,0x02,0x17,0x80,0x0C,
0xF8,0x7F,0xF3,0xC1,0x9C,0x07,0xB8,0x07,0x58,0x06,
0x02,0xA2,0x00,0xD1,0xC9,0xBE,0xEC,0x05,0xD7,0xE8,
0xD0,0x39,0x06,0x8F,0x47,0x63,0x79,0xC0,0x0C,0xA2,
0x01,0xD7,0x80,0x0C,0x07,0x60,0x73,0x07,0x18,0x70,
0xC7,0x06,0x70,0x47,0xF0,0x39,0xC2,0x30,0xE1,0x83,
0x8C,0x0C,0x60,0x73,0x01,0xC0,0x02,0xA2,0x00,0xDB,
0xEF,0x98,0x14,0x7A,0x03,0x0C,0xF8,0x7C,0x6F,0xEF,
0xF3,0xC3,0xE1,0xDC,0x0E,0x07,0xB8,0x0C,0x07,0x58,
0x0C,0x06,0x0C,0x7A,0x02,0x0C,0xF8,0x6F,0xF3,0xC1,
0x9C,0x07,0xB8,0x07,0x58,0x06,0x0D,0x79,0x01,0xE0,
0xF8,0x0F,0xF8,0x70,0x71,0x80,0xCE,0x03,0xDE,0x00,
0xDC,0x07,0x30,0x18,0xE0,0xE1,0xFF,0x01,0xF0,0x0D,
0xAA,0xEA,0x0C,0xF8,0x37,0xF8,0xF0,0x73,0x80,0xCC,
0x03,0xDE,0x00,0xD8,0x07,0x70,0x19,0xE1,0xC6,0xFE,
0x19,0xF0,0xCC,0x00,0x00,0x0D,0xA9,0xEA,0x00,0xF9,
0x8F,0xF6,0x70,0x79,0x80,0xEE,0x01,0xDE,0x00,0xDC,
0x03,0x30,0x1C,0x70,0xF0,0xFE,0xC1,0xF3,0xC0,0x01,
0x80,0x07,0x7A,0x01,0x2D,0xEF,0xF1,0xC3,0x70,0x56,
0x00,0x0C,0x79,0x01,0xC1,0xF0,0x3F,0xE3,0x83,0x98,
0x0C,0xC0,0x07,0x80,0x1F,0xC0,0x7F,0x80,0x7E,0x00,
0x3B,0x00,0xDC,0x06,0x70,0x61,0xFF,0x07,0xE0,0x07,
0xA0,0x01,0x01,0x14,0x62,0x3F,0xE9,0x8A,0x30,0x3E,
0x1E,0x0C,0x7A,0x02,0x1B,0x80,0x75,0x80,0x6C,0x07,
0x30,0x79,0xFE,0xC3,0xE6,0x0D,0x78,0x01,0xB1,0x80,
0x38,0x60,0x31,0xC1,0xC3,0x06,0x0E,0x39,0x03,0x18,
0x0E,0xC2,0x03,0x61,0x00,0xE0,0x01,0x00,0x13,0x78,
0x02,0x6C,0x06,0x07,0x18,0x1C,0x0C,0xC1,0x41,0x8C,
0x36,0x18,0xC3,0x63,0x86,0x36,0x30,0x62,0x23,0x07,
0x63,0x72,0x06,0xC6,0xC0,0x28,0x2C,0x40,0x70,0x70,
0x02,0x02,0x00,0x0D,0x78,0x01,0xAE,0x01,0x98,0x0C,
0x30,0x70,0xE3,0x81,0x8C,0x03,0x60,0x0F,0x80,0x1C,
0x00,0xF8,0x03,0x60,0x1C,0xC0,0xE3,0x83,0x06,0x18,
0x0C,0xE0,0x38,0x0D,0xA8,0xE9,0xAC,0x01,0xB0,0x0F,
0x0C,0x06,0x30,0x30,0x60,0xC1,0x87,0x06,0x18,0x0C,
0x62,0x06,0x60,0x0F,0x84,0x07,0x82,0x41,0x81,0x01,
0x80,0x1E,0x00,0x70,0x00,0x0D,0x78,0x01,0xD0,0xFF,
0xF0,0x01,0x80,0x0E,0x00,0x70,0x03,0x80,0x1C,0x00,
0xE0,0x07,0x00,0x38,0x01,0xC0,0x0E,0x00,0x30,0x02,
0x3F,0xFE,0x08,0xD1,0xE9,0x20,0x70,0x78,0x73,0x46,
0x03,0x03,0x08,0xE0,0x18,0x68,0xC4,0x0C,0x03,0xC0,
0xE0,0x02,0xD2,0xE8,0xDB,0xEF,0xBD,0xE0,0x08,0xD0,
0xE9,0x2E,0x07,0x86,0x8C,0x40,0xC0,0x32,0x01,0xC1,
0x9A,0x30,0x18,0x1C,0x3C,0x1C,0x00,0x0E,0x21,0x22,
0x03,0xC0,0x1F,0xF1,0xB0,0xFF,0x40,0x78,};
/* font data size: 2278 bytes */

static const unsigned char font_tgx_Arial_20_index[] = {
0x00,0x00,
0x04,0x00,0xC0,0x11,0x02,0xB0,0x52,0x08,0x60,0xB3,
0x0B,0x80,0xC8,0x0D,0x80,0xE7,0x0F,0x20,0xF8,0x0F,
0xD1,0x02,0x11,0x21,0x29,0x13,0x71,0x5A,0x17,0xE1,
0x9F,0x1B,0xB1,0xDD,0x1F,0x62,0x13,0x23,0x52,0x3C,
0x24,0x42,0x5D,0x26,0x72,0x80,0x2A,0x32,0xFC,0x32,
0x03,0x47,0x36,0xF3,0x8F,0x39,0xF3,0xAE,0x3D,0xD3,
0xED,0x3F,0x34,0x02,0x42,0xD4,0x39,0x45,0x34,0x79,
0x4A,0x24,0xBE,0x4E,0xA5,0x14,0x53,0xF5,0x4D,0x56,
0x35,0x84,0x5B,0xB5,0xEF,0x61,0x06,0x3B,0x64,0x56,
0x55,0x65,0xF6,0x6E,0x67,0x46,0x7B,0x69,0x86,0xB2,
0x6C,0x86,0xE2,0x6F,0xC7,0x08,0x72,0xA7,0x3A,0x74,
0x17,0x4C,0x76,0x87,0x6E,0x78,0x27,0x90,0x7A,0x77,
0xC1,0x7D,0xB7,0xE5,0x80,0x18,0x0D,0x81,0xB8,0x32,
0x85,0x58,0x73,0x89,0x38,0xAE,0x8C,0x18,0xC8,0x8D,
0xB0,
};
/* font index size: 143 bytes */

const ILI9341_t3_font_t font_tgx_Arial_20 = {
	font_tgx_Arial_20_index,
	0,
	font_tgx_Arial_20_data,
	1,
	0,
	32,
	126,
	0,
	0,
	12,
	5,
	5,
	3,
	6,
	5,
	30,
	20
};



static const unsigned char font_tgx_Arial_24_data[] = {
0x00,0x00,0x00,0x24,0x01,0xE1,0x00,0x2F,0x7D,0xF3,
0xC5,0x02,0x78,0x04,0xA0,0x50,0x33,0x78,0xE4,0x10,
0x08,0xE0,0x00,0x4A,0x00,0xE1,0xC0,0x78,0xE4,0x83,
0x87,0x27,0xFF,0xFF,0x21,0xC3,0x88,0x1C,0x38,0x4F,
0xFF,0xFE,0x8E,0x1C,0x03,0x8F,0x04,0x38,0x70,0x00,
0x08,0x70,0x7D,0x48,0x03,0x00,0x07,0xE0,0x0F,0xFC,
0x0F,0xFF,0x07,0x33,0x90,0xE3,0x1D,0x0E,0x30,0x07,
0x98,0x01,0xFC,0x00,0x7F,0x80,0x1F,0xF0,0x01,0xFC,
0x00,0xDF,0x00,0x63,0xE0,0x06,0x1E,0x38,0x61,0xDE,
0x31,0xE7,0x99,0xE1,0xFF,0xE0,0x7F,0xE0,0x0F,0xE1,
0x20,0x30,0x00,0x0C,0xE0,0x80,0x74,0x3E,0x00,0xE0,
0x1F,0xC0,0x70,0x0E,0x38,0x1C,0x08,0xE0,0xE1,0xC0,
0x38,0x38,0xF0,0x11,0xC1,0xC7,0x00,0x8E,0x0E,0x70,
0x01,0xC7,0x38,0x00,0x3F,0x8E,0x7C,0x07,0xC7,0x3F,
0x80,0x01,0xDC,0x74,0x00,0x1D,0xC1,0xE0,0x01,0xCE,
0x0F,0x00,0x1C,0x70,0x70,0x0E,0x1C,0x1C,0x03,0x83,
0x8E,0x01,0xC0,0x7F,0x00,0x70,0x0F,0x80,0x0A,0x60,
0x40,0x58,0x03,0xE0,0x00,0x7F,0x80,0x07,0xFE,0x00,
0x78,0x78,0x24,0x70,0x38,0x01,0xC3,0x80,0x0F,0x3C,
0x00,0x3F,0xC0,0x00,0xF8,0x00,0x1F,0x80,0x03,0xEE,
0x00,0x3C,0x38,0x41,0xC1,0xC7,0x9C,0x07,0x38,0xE0,
0x1F,0xC7,0x00,0x7C,0x38,0x03,0xC1,0xE0,0x1F,0x07,
0x83,0xFC,0x1F,0xFE,0xF0,0x7F,0xE3,0xC0,0xFC,0x08,
0x01,0xA0,0x50,0x1B,0x79,0x00,0x04,0x7C,0xB9,0x2C,
0x06,0x06,0x07,0x03,0x03,0x10,0x70,0x30,0x87,0x03,
0x06,0xF0,0x47,0x04,0xB8,0x0C,0x20,0xE0,0x31,0x01,
0x80,0x60,0x18,0x04,0x7C,0x79,0x2D,0x80,0x60,0x38,
0x0C,0x03,0x10,0x38,0x0C,0x90,0xED,0x07,0x80,0x79,
0x0E,0x06,0x40,0xE0,0xE0,0x60,0x70,0x30,0x30,0x00,
0x05,0x28,0x4E,0x36,0x43,0x07,0x6E,0xFF,0xC7,0xE0,
0x78,0x1F,0x87,0x38,0x42,0x00,0x07,0xBC,0x84,0x4F,
0x00,0xE0,0x4F,0xFF,0xFC,0x03,0x80,0x01,0xA0,0xFB,
0x26,0x7C,0xB2,0x60,0x04,0x8C,0x47,0x2E,0x7F,0xE0,
0x01,0x8C,0xC0,0x26,0x78,0x04,0xE0,0x00,0x26,0x00,
0x72,0x06,0xA0,0x64,0x86,0x24,0x60,0x38,0x49,0x82,
0x58,0x0E,0x03,0x00,0x08,0x60,0x40,0x48,0x0F,0xC0,
0x1F,0xF8,0x1F,0xFE,0x1F,0x0F,0x0E,0x03,0xC7,0x00,
0xE7,0x80,0x76,0xF0,0x03,0xCF,0x00,0x39,0x80,0x38,
0xE0,0x1C,0x70,0x1E,0x3E,0x1E,0x0F,0xFF,0x03,0xFF,
0x00,0x7E,0x00,0x04,0x60,0xC0,0x48,0x06,0x07,0x07,
0x87,0xC7,0xE7,0xF7,0xBB,0x1D,0x0F,0xA0,0xFA,0x0E,
0x07,0x08,0x60,0x40,0x48,0x0F,0xC0,0x1F,0xF8,0x1F,
0xFE,0x1E,0x07,0x8E,0x01,0xF1,0xC0,0x0F,0x00,0x00,
0xF0,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,
0x1C,0x00,0x1C,0x00,0x1C,0x00,0x3C,0x00,0x3C,0x00,
0x38,0x00,0x38,0x00,0x1F,0xFF,0xE3,0xFF,0xFC,0x08,
0x60,0x40,0x48,0x0F,0xC0,0x1F,0xF8,0x1F,0xFE,0x1E,
0x0F,0x1E,0x03,0xCE,0x00,0xE0,0x00,0x70,0x00,0x78,
0x00,0x79,0x00,0x7F,0x00,0x3F,0xC0,0x00,0xF0,0x00,
0x3E,0x40,0x01,0xDC,0x00,0xEE,0x00,0xF3,0x80,0x71,
0xE0,0xF8,0x7F,0xF8,0x1F,0xF8,0x03,0xF0,0x00,0x08,
0xE0,0x40,0x48,0x00,0x18,0x00,0x0E,0x00,0x07,0x80,
0x03,0xE2,0x00,0x3F,0x00,0x1D,0xC0,0x0E,0x70,0x07,
0x1C,0x40,0x70,0xE0,0x38,0x38,0x1C,0x0E,0x0E,0x03,
0x87,0x00,0xE2,0x7F,0xFF,0xF8,0x00,0x38,0x08,0x60,
0x40,0x4A,0x4F,0xFF,0xAD,0xC0,0x00,0xEF,0xC0,0xEF,
0xF8,0x7F,0xFE,0x3C,0x07,0x80,0x01,0xD4,0x00,0x0E,
0xE0,0x07,0x70,0x07,0x9C,0x03,0x8F,0x03,0xC3,0xFF,
0xC0,0xFF,0xC0,0x1F,0x80,0x08,0x60,0x40,0x48,0x07,
0xE0,0x0F,0xFC,0x0F,0xFF,0x0F,0x07,0x8F,0x01,0xE7,
0x00,0x73,0x80,0x03,0x80,0x01,0xC7,0xC0,0xE7,0xF8,
0x7F,0xFE,0x3F,0x07,0x9E,0x01,0xCF,0x00,0x7A,0xE0,
0x07,0x38,0x03,0x9C,0x03,0x87,0x83,0xC3,0xFF,0xC0,
0x7F,0xC0,0x0F,0x80,0x08,0x60,0x40,0x4A,0x7F,0xFF,
0xC0,0x00,0xC0,0x00,0xC0,0x00,0xE0,0x00,0xE0,0x00,
0x60,0x00,0x70,0x80,0x0E,0x08,0x01,0xC0,0x90,0x38,
0x0A,0x07,0x00,0xA0,0xE0,0x00,0x08,0x60,0x40,0x48,
0x0F,0xC0,0x1F,0xF8,0x1F,0xFE,0x1E,0x07,0x29,0xC0,
0x38,0x70,0x38,0x1F,0xF8,0x07,0xF8,0x0F,0xFF,0x0F,
0x03,0xC7,0x00,0xEB,0xE0,0x07,0x38,0x07,0x1E,0x07,
0x87,0xFF,0x81,0xFF,0x80,0x3F,0x00,0x08,0x60,0x40,
0x48,0x0F,0x80,0x1F,0xF0,0x1F,0xFC,0x1F,0x07,0x0E,
0x01,0xCF,0x00,0x6A,0xE0,0x07,0x70,0x07,0x9C,0x03,
0xCF,0x07,0xE3,0xFF,0xF0,0xFF,0xB8,0x1F,0x1C,0x00,
0x0E,0x00,0x0E,0x70,0x07,0x3C,0x07,0x8F,0x07,0x87,
0xFF,0x81,0xFF,0x80,0x3F,0x00,0x01,0xC8,0xC0,0x26,
0x7E,0x8B,0x13,0xC0,0x01,0xDC,0xFB,0x26,0x7E,0x8B,
0x13,0xE5,0x93,0x00,0x07,0xBC,0x84,0x4C,0x00,0x04,
0x00,0x3C,0x00,0xFC,0x07,0xF8,0x1F,0xC0,0xFE,0x01,
0xF8,0x01,0xC0,0x01,0xF8,0x00,0xFE,0x00,0x1F,0xC0,
0x07,0xF8,0x00,0xFC,0x00,0x3C,0x00,0x04,0x07,0xA8,
0x87,0x4E,0x7F,0xFF,0xD0,0x00,0x09,0xFF,0xFE,0x07,
0xBC,0x84,0x4D,0x00,0x01,0xE0,0x01,0xF8,0x00,0xFF,
0x00,0x1F,0xC0,0x03,0xF8,0x00,0xFC,0x00,0x1C,0x00,
0xFC,0x03,0xF8,0x1F,0xC0,0xFF,0x01,0xF8,0x01,0xE0,
0x01,0x00,0x00,0x08,0x60,0x40,0x48,0x0F,0xC0,0x1F,
0xF8,0x1F,0xFE,0x1F,0x0F,0x8E,0x01,0xEF,0x00,0x77,
0x00,0x38,0x00,0x1C,0x00,0x1E,0x00,0x0E,0x00,0x0F,
0x00,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x07,0x05,0x00,
0xE0,0x40,0x00,0x04,0x80,0xE0,0x00,0x0F,0x7C,0xB9,
0x88,0x00,0x3F,0xE0,0x00,0x03,0xFF,0xF0,0x00,0x0F,
0xFF,0xF8,0x00,0x7F,0x01,0xF8,0x01,0xF0,0x00,0xF8,
0x03,0xC0,0x00,0x78,0x0F,0x0F,0x0E,0x70,0x3C,0x7F,
0x9C,0xF0,0x71,0xFF,0xF0,0xE1,0xE7,0xC7,0xE1,0xE3,
0x8E,0x07,0xC1,0xC7,0x3C,0x07,0x83,0x9C,0x70,0x0F,
0x07,0x39,0xE0,0x1C,0x0E,0x73,0x80,0x38,0x1C,0xE7,
0x00,0x70,0x79,0xCE,0x01,0xE0,0xE3,0x9C,0x03,0x81,
0xC7,0x38,0x0F,0x07,0x0E,0x78,0x3E,0x1E,0x1E,0x78,
0xFC,0x78,0x1C,0xFF,0xFF,0xE0,0x38,0xFF,0x7F,0x80,
0x38,0x78,0x7C,0x00,0x78,0x00,0x00,0x38,0x78,0x00,
0x01,0xE0,0x7C,0x00,0x07,0x80,0x7F,0x00,0x7E,0x00,
0x7F,0xFF,0xF8,0x00,0x3F,0xFF,0xC0,0x00,0x0F,0xFC,
0x00,0x0A,0xE0,0x00,0x5A,0x40,0x3E,0x01,0x20,0x3B,
0x80,0x80,0x38,0xE0,0x01,0xE3,0x81,0x00,0xE0,0xE0,
0x90,0xE0,0x38,0x48,0xFF,0xFE,0x24,0xE0,0x03,0x90,
0xE0,0x00,0xE7,0x80,0x03,0x9C,0x00,0x07,0x08,0xE0,
0xC0,0x59,0xFF,0xE0,0x7F,0xFE,0x1F,0xFF,0xC7,0x00,
0xF1,0xC0,0x1E,0x9E,0x00,0x73,0x80,0x38,0xE0,0x1E,
0x47,0xFF,0xE1,0xFF,0xFC,0x70,0x07,0x9C,0x00,0xFA,
0xE0,0x03,0xB8,0x01,0xEE,0x00,0xF3,0xFF,0xFC,0xFF,
0xFE,0x3F,0xFE,0x00,0x0A,0x60,0x80,0x60,0x03,0xF0,
0x00,0x7F,0xE0,0x07,0xFF,0xC0,0x78,0x1E,0x07,0x80,
0x78,0x78,0x01,0xE3,0x80,0x07,0x1C,0x00,0x23,0x78,
0x00,0x01,0xC0,0x00,0x87,0x00,0x07,0x38,0x00,0x79,
0xE0,0x03,0x87,0x80,0x3C,0x1F,0x07,0xC0,0xFF,0xFC,
0x01,0xFF,0xC0,0x03,0xF8,0x00,0x09,0xE0,0xC0,0x61,
0xFF,0xF0,0x1F,0xFF,0xC1,0xFF,0xFE,0x1C,0x01,0xF1,
0xC0,0x0F,0x1C,0x00,0x7A,0x38,0x00,0x76,0xF0,0x00,
0x77,0x00,0x07,0x8E,0x00,0x1C,0xE0,0x03,0xCE,0x00,
0x78,0xE0,0x0F,0x8F,0xFF,0xF0,0xFF,0xFE,0x0F,0xFF,
0x00,0x08,0xE0,0xC0,0x5A,0x7F,0xFF,0xDB,0xC0,0x00,
0x9F,0xFF,0xE6,0xF0,0x00,0x1C,0x00,0x09,0xFF,0xFF,
0x80,0x07,0xE0,0xC0,0x52,0x7F,0xFF,0xEF,0x00,0x09,
0xFF,0xF9,0xBC,0x00,0x2B,0x80,0x00,0x0B,0x60,0x80,
0x68,0x01,0xFC,0x00,0x1F,0xFF,0x00,0x7F,0xFF,0x01,
0xF8,0x1F,0x07,0x80,0x0F,0x0E,0x00,0x0E,0x38,0x00,
0x1C,0x70,0x00,0x19,0xE0,0x00,0x04,0xF0,0x00,0x01,
0x3C,0x01,0xFF,0xB8,0x00,0x07,0x87,0x00,0x01,0xC7,
0x00,0x03,0x8F,0x00,0x0F,0x0F,0xC0,0xFE,0x0F,0xFF,
0xF8,0x07,0xFF,0xC0,0x03,0xFC,0x00,0x09,0x60,0xC0,
0x63,0x78,0x00,0x79,0xE0,0x01,0xE7,0xFF,0xFF,0xDE,
0x00,0x1E,0xB8,0x00,0x70,0x01,0xE0,0xC0,0x27,0x7E,
0xFD,0xF3,0xC0,0x06,0xE0,0x40,0x47,0x40,0x0F,0xA0,
0x07,0x90,0x03,0xC7,0x01,0xDE,0x0F,0x78,0x78,0xFF,
0xE1,0xFF,0x03,0xF0,0x0A,0x60,0xC0,0x59,0xC0,0x03,
0xCE,0x00,0x3C,0x70,0x03,0xC3,0x80,0x3C,0x1C,0x03,
0xC0,0xE0,0x3C,0x07,0x03,0xC0,0x38,0x3C,0x01,0xC3,
0xC0,0x0E,0x3C,0x00,0x73,0xC0,0x03,0xBF,0x00,0x1F,
0xFC,0x00,0xFC,0xE0,0x07,0xC7,0x80,0x3C,0x1E,0x01,
0xC0,0x78,0x0E,0x01,0xE0,0x70,0x07,0x83,0x80,0x1C,
0x1C,0x00,0x70,0xE0,0x03,0xC7,0x00,0x0F,0x38,0x00,
0x3C,0x07,0x60,0xC0,0x4B,0x78,0x00,0xDE,0x00,0x37,
0x80,0x09,0xFF,0xFC,0x0B,0xE0,0x80,0x6D,0xF0,0x00,
0x7D,0xF8,0x00,0x7E,0x3F,0x00,0x1F,0xBF,0x80,0x1F,
0xCF,0x70,0x07,0x79,0xE7,0x01,0xCF,0x3C,0x70,0x71,
0xE7,0x87,0x1C,0x3C,0xF0,0x77,0x07,0x9E,0x07,0xC0,
0xEE,0x03,0x80,0xE0,0x09,0x60,0xC0,0x62,0x3C,0x00,
0x78,0xF8,0x01,0xDF,0x80,0x3C,0x77,0x00,0xF1,0xCE,
0x03,0xB8,0xE0,0x78,0xE1,0xC1,0xE3,0x83,0x87,0x70,
0x38,0xF1,0xC0,0x73,0xC7,0x00,0xEE,0xE0,0x0F,0xE3,
0x80,0x1F,0x8E,0x00,0x3C,0x0B,0x60,0x80,0x68,0x01,
0xF8,0x00,0x1F,0xFE,0x00,0x7F,0xFE,0x01,0xF0,0x3E,
0x07,0x80,0x1E,0x1E,0x00,0x1C,0x87,0x00,0x03,0x9C,
0x00,0x07,0xEF,0x00,0x00,0xF0,0xE0,0x00,0x70,0xE0,
0x01,0xE1,0xE0,0x07,0x81,0xF0,0x3E,0x01,0xFF,0xF8,
0x01,0xFF,0xE0,0x00,0x7E,0x00,0x08,0xE0,0xC0,0x59,
0xFF,0xF0,0x7F,0xFF,0x1F,0xFF,0xE7,0x00,0x79,0xC0,
0x0F,0xAE,0x00,0x3B,0x80,0x1E,0xE0,0x0F,0x3F,0xFF,
0xCF,0xFF,0xE3,0xFF,0xE1,0xBC,0x00,0x09,0xE0,0x00,
0x00,0x0B,0x64,0xBF,0x68,0x03,0xF8,0x00,0x1F,0xFC,
0x00,0x7F,0xFC,0x01,0xF0,0x7C,0x07,0x80,0x3C,0x1E,
0x00,0x3C,0x87,0x00,0x07,0x37,0x80,0x00,0xE7,0x00,
0x01,0xC7,0x00,0x07,0x0E,0x03,0x0E,0x1E,0x07,0xB8,
0x1E,0x07,0xF0,0x1F,0x07,0xC0,0x1F,0xFF,0xC0,0x1F,
0xFF,0xC0,0x0F,0xE3,0xE0,0x00,0x03,0x80,0x09,0xE0,
0xC0,0x61,0xFF,0xF8,0x1F,0xFF,0xE1,0xFF,0xFF,0x1C,
0x00,0xF1,0xC0,0x07,0xA7,0x80,0x07,0x38,0x00,0xF3,
0x80,0x1E,0x3F,0xFF,0xE3,0xFF,0xFC,0x3F,0xFF,0x03,
0x81,0xC0,0x38,0x0E,0x03,0x80,0xF0,0x38,0x07,0x83,
0x80,0x38,0x38,0x03,0xC3,0x80,0x1E,0x38,0x00,0xE3,
0x80,0x0F,0x38,0x00,0x73,0x80,0x07,0x80,0x09,0x60,
0x80,0x58,0x07,0xE0,0x07,0xFF,0x01,0xFF,0xF0,0x3C,
0x0F,0x0F,0x00,0xE4,0x38,0x01,0xC7,0x00,0x00,0xF0,
0x00,0x0F,0x80,0x00,0xFF,0x00,0x0F,0xFC,0x00,0x3F,
0xE0,0x00,0x7E,0x00,0x03,0xC0,0x00,0x3E,0x38,0x00,
0x77,0x80,0x0E,0x78,0x03,0xCF,0xC1,0xF0,0xFF,0xFC,
0x0F,0xFF,0x00,0x3F,0x80,0x09,0xE0,0x40,0x56,0x7F,
0xFF,0xFE,0x80,0x70,0x0D,0x00,0xE0,0x1A,0x01,0xC0,
0x00,0x09,0x60,0xC0,0x63,0x78,0x00,0x7D,0xE0,0x01,
0xEB,0x80,0x07,0x38,0x01,0xC7,0x00,0x78,0xF8,0x1F,
0x0F,0xFF,0xC0,0xFF,0xF0,0x07,0xF8,0x00,0x0A,0xE0,
0x40,0x59,0xC0,0x00,0x77,0x80,0x03,0xE1,0xC0,0x01,
0xC7,0x80,0x0F,0x41,0xC0,0x07,0x03,0x80,0x3C,0x81,
0xC0,0x1C,0x48,0x70,0x1C,0x20,0x1C,0x1C,0x00,0x78,
0xF0,0x40,0x1C,0x70,0x00,0x7B,0xC0,0x80,0x1D,0xC0,
0x00,0x7F,0x01,0x00,0x1F,0x00,0x10,0xE0,0x00,0x8A,
0x38,0x00,0xF8,0x00,0xE7,0x00,0x3E,0x00,0x74,0xB8,
0x03,0xB8,0x03,0x87,0x01,0xC6,0x01,0xC8,0x38,0x0E,
0x38,0x0E,0x07,0x03,0x8E,0x07,0x12,0x38,0x38,0x38,
0x38,0x07,0x1E,0x06,0x1C,0x24,0x38,0xE0,0x38,0xE1,
0x40,0xEE,0x00,0xEE,0x09,0x03,0xE0,0x03,0xE0,0x00,
0x0A,0xE0,0x00,0x54,0xF0,0x01,0xE1,0xE0,0x0F,0x03,
0x80,0x38,0x0F,0x01,0xE0,0x1E,0x0F,0x00,0x38,0x38,
0x00,0x71,0xC0,0x01,0xEF,0x00,0x03,0xB8,0x08,0x00,
0xF8,0x00,0x01,0xC0,0x00,0x0F,0x80,0x40,0x0E,0xE0,
0x00,0x7B,0xC0,0x03,0xC7,0x80,0x0E,0x0E,0x00,0x70,
0x1C,0x03,0xC0,0x78,0x1E,0x00,0xF0,0x70,0x01,0xC3,
0xC0,0x07,0x9E,0x00,0x0F,0x0A,0xE0,0x00,0x55,0xC0,
0x00,0xF3,0x80,0x07,0x87,0x00,0x1C,0x1E,0x00,0xF0,
0x38,0x07,0x80,0x70,0x1C,0x01,0xE0,0xF0,0x03,0x83,
0x82,0x00,0xE3,0x80,0x01,0xDC,0x00,0x07,0xF0,0x00,
0x0F,0x80,0x68,0x03,0x80,0x28,0x01,0xC0,0x00,0x09,
0xE0,0x00,0x52,0x5F,0xFF,0xF0,0x00,0x0F,0x00,0x01,
0xE0,0x00,0x3C,0x00,0x03,0x80,0x00,0x70,0x00,0x0F,
0x00,0x01,0xE0,0x00,0x3C,0x00,0x03,0x80,0x00,0x70,
0x00,0x0F,0x00,0x01,0xE0,0x00,0x3C,0x00,0x03,0x80,
0x00,0x70,0x00,0x0F,0x00,0x01,0xE0,0x00,0x3C,0x00,
0x04,0xFF,0xFF,0xF0,0x03,0x7C,0xB9,0x26,0x7F,0xDE,
0x37,0x8D,0xE2,0xB8,0x9F,0xC0,0x04,0xE0,0x40,0x26,
0x30,0x12,0xC0,0xA3,0x04,0x8C,0x24,0x30,0x0E,0x48,
0x32,0x40,0xC0,0x38,0x06,0x03,0x7C,0x79,0x26,0x7F,
0xD1,0xF4,0x7D,0x1E,0x87,0x9F,0xC0,0x06,0x34,0x4B,
0x38,0x0C,0x12,0x1E,0x01,0xF8,0x0C,0xC0,0xE6,0x07,
0x38,0x30,0xC8,0x70,0xE3,0x03,0x38,0x1C,0x09,0x8F,
0xF9,0x4A,0x7F,0xFF,0xF8,0x03,0x14,0x53,0x2D,0xE1,
0xE1,0xC1,0x81,0x80,0x07,0xC8,0x40,0x44,0x1F,0xC0,
0x7F,0xF0,0xFF,0xF1,0xE0,0x79,0xC0,0x38,0x00,0x38,
0x00,0xF8,0x1F,0xF8,0x7F,0xF8,0xFF,0xB9,0xE0,0x3A,
0x38,0x07,0x38,0x0F,0x3C,0x3F,0x1F,0xFF,0x1F,0xF7,
0x07,0xE3,0x80,0x07,0xE0,0x80,0x4B,0x38,0x00,0x38,
0xF0,0x3B,0xFC,0x3F,0xFE,0x3F,0x1F,0x3C,0x07,0x3C,
0x07,0xE7,0x00,0x77,0x80,0xF7,0x80,0xE7,0xC3,0xE7,
0xFF,0xC7,0x7F,0x87,0x1E,0x00,0x07,0xC8,0x40,0x44,
0x0F,0xC0,0x3F,0xE0,0x7F,0xF0,0xF8,0x78,0xE0,0x39,
0xE0,0x1E,0xF8,0x00,0x38,0x03,0xBC,0x03,0x9C,0x07,
0x1F,0x0F,0x0F,0xFE,0x07,0xFC,0x01,0xF8,0x00,0x07,
0xE0,0x40,0x4B,0x00,0x03,0x81,0xE3,0x87,0xFB,0x8F,
0xFF,0x9E,0x1F,0x9C,0x07,0xBC,0x07,0xE7,0x00,0x77,
0x80,0xF3,0x80,0xF3,0xE1,0xF1,0xFF,0xF0,0xFF,0x70,
0x3C,0x70,0x07,0xC8,0x40,0x44,0x0F,0x80,0x3F,0xE0,
0x7F,0xF0,0xF0,0x78,0xE0,0x3A,0x38,0x03,0xCF,0xFF,
0xF8,0xE0,0x00,0xF0,0x00,0x70,0x0E,0x7C,0x3C,0x3F,
0xFC,0x1F,0xF8,0x07,0xE0,0x05,0x60,0x40,0x28,0x1F,
0x87,0xE1,0xFD,0x27,0x04,0xFF,0x9A,0x70,0x69,0xC0,
0x38,0x00,0x07,0xE4,0x79,0x48,0x0F,0x9C,0x3F,0xDC,
0x7F,0xFC,0xF8,0xFC,0xE0,0x3D,0xE0,0x3F,0x38,0x03,
0xBC,0x07,0x9C,0x07,0x9E,0x1F,0x8F,0xFF,0x87,0xFB,
0x81,0xF3,0x80,0x03,0xB8,0x03,0xB8,0x07,0x3E,0x0F,
0x1F,0xFE,0x0F,0xFC,0x03,0xF0,0x00,0x07,0x60,0x80,
0x4B,0x38,0x00,0x71,0xF0,0xEF,0xF1,0xFF,0xF3,0xE1,
0xF7,0x81,0xFB,0xC0,0x3E,0x70,0x0E,0x01,0xE0,0x80,
0x1E,0x7C,0x8D,0xFB,0xEB,0x80,0x03,0x7F,0xF9,0x1E,
0x47,0x90,0x34,0x7D,0x1F,0x47,0x1E,0xFD,0xF3,0xC0,
0x07,0x60,0x80,0x43,0x38,0x00,0x70,0x1E,0xE0,0x79,
0xC1,0xE3,0x87,0x87,0x1E,0x0E,0x78,0x1D,0xE0,0x3F,
0xC0,0x7F,0xC0,0xF7,0x81,0xC7,0x83,0x87,0x07,0x0F,
0x0E,0x0E,0x1C,0x0E,0x38,0x1E,0x70,0x1C,0xE0,0x3C,
0x01,0xE0,0x80,0x1F,0x7E,0xFD,0xF3,0xC0,0x0B,0xC8,
0x80,0x6D,0xC7,0x81,0xE1,0xDF,0xC7,0xF9,0xFF,0xEF,
0xF9,0xF0,0xFC,0x3D,0xE0,0x78,0x1F,0x78,0x0E,0x03,
0xE7,0x01,0xC0,0x70,0x07,0x48,0x80,0x49,0xC7,0xC3,
0xBF,0xC7,0xFF,0xCF,0x87,0xDE,0x07,0xEF,0x00,0xF9,
0xC0,0x38,0x07,0xC8,0x40,0x44,0x0F,0x80,0x3F,0xE0,
0x7F,0xF0,0xF8,0xF8,0xE0,0x39,0xE0,0x3F,0x38,0x03,
0xBC,0x07,0x9C,0x07,0x1F,0x1F,0x0F,0xFE,0x07,0xFC,
0x01,0xF0,0x00,0x07,0xE4,0xB9,0x49,0xC7,0x81,0xDF,
0xE1,0xFF,0xF1,0xF8,0xF9,0xE0,0x39,0xE0,0x3F,0x38,
0x03,0xC7,0x80,0xE7,0xC3,0xE7,0xFF,0xC7,0x7F,0x87,
0x3E,0x0D,0xE0,0x00,0x07,0xE4,0x79,0x48,0x0F,0x1C,
0x3F,0xDC,0x7F,0xDC,0xF0,0xFC,0xE0,0x3D,0xE0,0x3F,
0x38,0x03,0xC3,0x80,0xF3,0xE1,0xF1,0xFF,0xF0,0xFF,
0x70,0x3E,0x7D,0x00,0x0E,0x04,0xC8,0x80,0x2D,0xCF,
0x77,0xDF,0xE7,0xC1,0xE0,0xDE,0x06,0x70,0x00,0x07,
0xC8,0x40,0x44,0x1F,0x80,0x7F,0xE0,0xFF,0xF1,0xE0,
0x79,0xC0,0x39,0xC0,0x01,0xF0,0x00,0xFF,0x80,0x7F,
0xE0,0x3F,0xF8,0x03,0xFC,0x00,0x3D,0xC0,0x1D,0xE0,
0x1C,0xF0,0x3C,0xFF,0xF8,0x7F,0xF0,0x1F,0xC0,0x04,
0x60,0x00,0x24,0x11,0x67,0x13,0xFF,0xA7,0x16,0x71,
0x07,0xE0,0xF0,0x07,0x48,0x80,0x4B,0x78,0x07,0xCE,
0x01,0xDE,0x07,0xBE,0x1F,0x3F,0xEE,0x3F,0xDC,0x3E,
0x38,0x07,0xC8,0x00,0x3D,0xC0,0x1C,0xE0,0x1E,0x1C,
0x07,0x0C,0x06,0x41,0xC1,0xC0,0xC1,0x88,0x1C,0x70,
0x0C,0x61,0x01,0xDC,0x00,0xD8,0x20,0x1F,0x04,0x01,
0xC0,0x0B,0xC8,0x00,0x5E,0x38,0x0E,0x03,0xB8,0x1F,
0x03,0x9C,0x1F,0x07,0x43,0x83,0x60,0xE1,0x87,0x70,
0xC8,0x38,0xC6,0x38,0x38,0xC6,0x30,0x1D,0xC7,0x71,
0x03,0xB0,0x6E,0x01,0xB0,0x6C,0x20,0x3E,0x0F,0x84,
0x03,0x80,0xE0,0x07,0xC8,0x00,0x3D,0xC0,0x1C,0xE0,
0x38,0xF0,0x78,0x70,0x70,0x38,0xE0,0x3D,0xE0,0x1D,
0xC0,0x1F,0xC2,0x01,0xF0,0x03,0xF8,0x03,0xB8,0x07,
0xBC,0x07,0x1C,0x0E,0x0E,0x1E,0x0F,0x1C,0x07,0x38,
0x03,0x80,0x07,0xE4,0x39,0x3D,0xC0,0x1C,0xE0,0x3E,
0x1C,0x07,0x0E,0x0F,0x41,0xC1,0xC0,0xE3,0xC8,0x1C,
0x70,0x0E,0xF1,0x01,0xDC,0x00,0xFC,0x20,0x1F,0x00,
0x0F,0x04,0x81,0xC0,0x80,0x70,0x10,0x7C,0x00,0x78,
0x00,0x07,0xC8,0x00,0x42,0x5F,0xFF,0x80,0x07,0x80,
0x0F,0x00,0x1E,0x00,0x3C,0x00,0x78,0x00,0xF0,0x01,
0xE0,0x03,0xC0,0x07,0x80,0x0F,0x00,0x1E,0x00,0x3C,
0x00,0x4F,0xFF,0xF0,0x04,0xFC,0x79,0x2C,0x0F,0x07,
0xC3,0xF0,0xF3,0x47,0x01,0xC0,0xF0,0x38,0x3C,0x0C,
0x03,0xC1,0x07,0x0D,0x1C,0x07,0x01,0xE0,0x7E,0x0F,
0x81,0xE0,0x01,0x7C,0xF9,0x23,0x7D,0xF7,0xDE,0x70,
0x04,0xFC,0x79,0x2D,0xE0,0x7C,0x1F,0x81,0xE3,0x47,
0x01,0xC0,0x78,0x0E,0x01,0xE0,0x18,0x1E,0x0E,0x07,
0x9A,0x38,0x0E,0x07,0x87,0xE1,0xF0,0x78,0x00,0x08,
0x18,0x48,0x4C,0x7C,0x00,0x7F,0x01,0x7F,0xE1,0xB0,
0xFF,0xD0,0x1F,0xC0,0x07,0xC0,};
/* font data size: 2966 bytes */

static const unsigned char font_tgx_Arial_24_index[] = {
0x00,0x00,0x04,0x00,
0xD0,0x14,0x03,0x20,0x67,0x0A,0x80,0xE6,0x0E,0xC1,
0x07,0x12,0x21,0x32,0x13,0xD1,0x44,0x14,0xA1,0x4F,
0x16,0x21,0x89,0x19,0xB1,0xCB,0x1F,0xD2,0x24,0x24,
0x92,0x7A,0x29,0xA2,0xC3,0x2F,0x42,0xFC,0x30,0x63,
0x28,0x33,0x33,0x55,0x38,0x13,0xFD,0x42,0x24,0x50,
0x48,0x44,0xB1,0x4C,0x54,0xD5,0x51,0x15,0x23,0x52,
0xB5,0x40,0x58,0x35,0x90,0x5B,0x85,0xE1,0x61,0x46,
0x37,0x67,0x06,0xAC,0x6E,0x56,0xF5,0x71,0x07,0x40,
0x77,0x67,0xB7,0x7E,0x38,0x1A,0x82,0x68,0x39,0x84,
0x58,0x5A,0x86,0x18,0x6A,0x89,0x18,0xB2,0x8D,0x38,
0xF4,0x91,0x59,0x26,0x95,0x39,0x67,0x97,0x09,0x7E,
0x9A,0x69,0xAE,0x9C,0x89,0xDA,0x9F,0x9A,0x18,0xA3,
0x7A,0x45,0xA6,0xDA,0x7B,0xA8,0xDA,0xAB,0xAD,0x5A,
0xFC,0xB2,0x3B,0x44,0xB6,0x0B,0x68,0xB8,0x50,
};
/* font index size: 143 bytes */

const ILI9341_t3_font_t font_tgx_Arial_24 = {
	font_tgx_Arial_24_index,
	0,
	font_tgx_Arial_24_data,
	1,
	0,
	32,
	126,
	0,
	0,
	12,
	6,
	5,
	4,
	6,
	6,
	35,
	24
};



static const unsigned char font_tgx_Arial_28_data[] = {
0x00,0x00,0x00,0x16,0x01,0xB8,0x80,0x17,0xBF,0x79,
0xEA,0x91,0x3C,0x05,0x94,0x29,0x1D,0xBC,0x1D,0xC1,
0xC8,0x0C,0x80,0x80,0x0B,0x38,0x00,0x2D,0x00,0x1C,
0x0E,0x00,0x78,0x38,0xA0,0x1C,0x0E,0x00,0x70,0x38,
0x4F,0xFF,0xFF,0xE0,0x38,0x3C,0x28,0x1C,0x0E,0x00,
0x78,0x38,0x13,0xFF,0xFF,0xF8,0x38,0x1C,0x0A,0x1C,
0x0E,0x00,0x38,0x3C,0x04,0x1C,0x0E,0x00,0x09,0x40,
0x3E,0xAC,0x00,0xC0,0x00,0x7E,0x00,0x3F,0xF0,0x0F,
0xFF,0x03,0xCC,0xF0,0xF1,0x8E,0x43,0x86,0x1D,0x0E,
0x18,0x01,0xE3,0x00,0x1E,0x60,0x03,0xFC,0x00,0x3F,
0xE0,0x01,0xFF,0x00,0x0F,0xF8,0x00,0xCF,0x80,0x18,
0x74,0x80,0x60,0xF1,0xC1,0x83,0xBC,0x30,0xF3,0xC6,
0x3C,0x7C,0xCF,0x87,0xFF,0xE0,0x7F,0xF8,0x01,0xFC,
0x12,0x01,0x80,0x00,0x0F,0xB8,0x40,0x46,0x1F,0x00,
0x03,0x80,0x3F,0xC0,0x07,0x80,0x79,0xE0,0x07,0x00,
0x70,0xE0,0x0F,0x00,0xE0,0x70,0x0E,0x00,0xE0,0x70,
0x1C,0x00,0xE0,0x70,0x3C,0x00,0xE0,0x70,0x38,0x00,
0xE0,0x70,0x78,0x00,0xE0,0x70,0x70,0x00,0xE0,0x70,
0xE0,0x00,0x70,0xE0,0xE0,0x00,0x79,0xE1,0xC0,0x00,
0x3F,0xC3,0xC3,0xE0,0x0F,0x03,0x87,0xF8,0x00,0x07,
0x8F,0x3C,0x00,0x07,0x0E,0x1D,0x00,0x01,0xC3,0x81,
0xC0,0x03,0x83,0x81,0xC0,0x07,0x83,0x81,0xC0,0x07,
0x03,0x81,0xC0,0x0F,0x03,0x81,0xC0,0x0E,0x03,0x81,
0xC0,0x1C,0x01,0xC3,0x80,0x3C,0x01,0xE7,0x80,0x38,
0x00,0xFF,0x00,0x78,0x00,0x3C,0x00,0x0B,0xB8,0x40,
0x34,0x01,0xF8,0x00,0x07,0xFE,0x00,0x0F,0xFF,0x00,
0x0F,0x0F,0x00,0x1E,0x07,0x81,0x23,0x80,0x70,0x01,
0xC0,0xE0,0x01,0xE3,0xE0,0x00,0xFF,0xC0,0x00,0x7F,
0x00,0x00,0xFE,0x00,0x01,0xFC,0x00,0x03,0xFE,0x00,
0x07,0x8F,0x04,0x0F,0x07,0x8F,0x1E,0x03,0x8F,0x1C,
0x01,0xDE,0x1C,0x01,0xFE,0x1C,0x00,0xFE,0x1C,0x00,
0x7C,0x1E,0x00,0x7C,0x0F,0x00,0xFE,0x0F,0x83,0xFF,
0x07,0xFF,0xE7,0xC1,0xFF,0x83,0x80,0x7E,0x01,0x00,
0x01,0x94,0x49,0x0F,0xBE,0x39,0x00,0x04,0x48,0x5C,
0x1A,0x03,0x03,0x03,0x81,0x81,0xC0,0xC4,0x1C,0x0C,
0x25,0xC3,0x78,0x2B,0x80,0xC1,0x2E,0x03,0x08,0x38,
0x0C,0x07,0x01,0x80,0xE0,0x30,0x0C,0x04,0x48,0x7C,
0x1A,0xC0,0x30,0x1C,0x06,0x03,0x80,0xC4,0x0E,0x03,
0x24,0x38,0x0D,0xA0,0xF2,0x0E,0x06,0x90,0xE0,0x64,
0x0E,0x06,0x07,0x03,0x03,0x81,0x81,0x80,0x06,0x98,
0x28,0x1F,0x20,0xE0,0x23,0x89,0xEE,0xF7,0xFF,0xC7,
0xFC,0x07,0xC0,0x3B,0x81,0xEF,0x07,0x1C,0x08,0x20,
0x09,0xA6,0x42,0x2F,0xA0,0x1C,0x00,0x01,0xC0,0x27,
0xFF,0xFF,0xE8,0x07,0x00,0x00,0x70,0x00,0x01,0x92,
0x7D,0x17,0x3E,0x9B,0x20,0x05,0x86,0x24,0x1B,0x3F,
0xFC,0x01,0x86,0x60,0x17,0x3C,0x05,0xB8,0x00,0x17,
0x00,0x1E,0x40,0x75,0x01,0xC9,0x07,0x14,0x1C,0x24,
0x70,0x51,0xC0,0x97,0x01,0x1C,0x00,0x09,0x38,0x40,
0x2C,0x03,0xF0,0x01,0xFF,0x80,0x7F,0xF8,0x1F,0x0F,
0x83,0x80,0x72,0x5C,0x00,0xED,0xE0,0x01,0xEF,0x80,
0x07,0x97,0x00,0x38,0x70,0x0E,0x0F,0x87,0xC0,0xFF,
0xF0,0x0F,0xFC,0x00,0x7E,0x00,0x05,0xB8,0x80,0x2C,
0x00,0x60,0x0E,0x01,0xE0,0x3E,0x07,0xE1,0xFE,0x7F,
0xEF,0xCE,0xF0,0xEC,0x0F,0xA0,0x1F,0x40,0x3D,0x00,
0x70,0x09,0xB8,0x20,0x2C,0x03,0xF8,0x00,0xFF,0xE0,
0x3F,0xFF,0x83,0xE0,0xFC,0x78,0x03,0xC7,0x00,0x1F,
0x1C,0x00,0x1E,0x00,0x00,0x38,0x00,0x07,0x80,0x00,
0x70,0x00,0x0F,0x00,0x01,0xE0,0x00,0x3C,0x00,0x07,
0x80,0x00,0xF0,0x00,0x1E,0x00,0x03,0xC0,0x00,0x78,
0x00,0x1F,0x00,0x03,0xC0,0x00,0x78,0x00,0x0F,0x00,
0x01,0xC0,0x00,0x1F,0xFF,0xFC,0x7F,0xFF,0xF0,0x09,
0x38,0x40,0x2C,0x07,0xF0,0x03,0xFF,0x80,0xFF,0xF8,
0x3E,0x0F,0x87,0x00,0x71,0xE0,0x07,0x38,0x00,0xE8,
0x00,0x03,0x80,0x00,0xF0,0x00,0x1C,0x00,0x0F,0x10,
0x03,0xF8,0x00,0x7F,0xC0,0x00,0x3C,0x00,0x03,0x80,
0x00,0x7C,0x00,0x00,0xF1,0xC0,0x03,0x9C,0x00,0xF3,
0xC0,0x3C,0x3C,0x0F,0x07,0xFF,0xC0,0x3F,0xF0,0x01,
0xF8,0x00,0x09,0xB8,0x20,0x2C,0x00,0x07,0x00,0x00,
0xF0,0x00,0x1F,0x10,0x00,0x7E,0x00,0x0F,0xE0,0x01,
0xEE,0x00,0x1C,0xE0,0x03,0x8E,0x00,0x78,0xE0,0x0F,
0x0E,0x00,0xE0,0xE0,0x1C,0x0E,0x03,0xC0,0xE0,0x38,
0x0E,0x07,0x00,0xE0,0xF0,0x0E,0x1E,0x00,0xE2,0x7F,
0xFF,0xFE,0x80,0x03,0x80,0x09,0x38,0x40,0x2D,0x03,
0xFF,0xF0,0xFF,0xFE,0xA3,0x80,0x02,0x1C,0x00,0x03,
0x9F,0x80,0x7F,0xFC,0x0F,0xFF,0xC3,0xE0,0x3C,0x78,
0x03,0xC0,0x00,0x3A,0xC0,0x00,0x77,0x00,0x0E,0xE0,
0x03,0x8E,0x00,0x71,0xC0,0x1E,0x1E,0x07,0x83,0xFF,
0xE0,0x3F,0xF8,0x00,0xFC,0x00,0x09,0xB8,0x20,0x2C,
0x01,0xFC,0x00,0x7F,0xF0,0x0F,0xFF,0x81,0xF0,0x7C,
0x3C,0x01,0xC3,0x80,0x1E,0x78,0x00,0xF0,0xE0,0x00,
0x1C,0x00,0x01,0xC3,0xF0,0x1C,0xFF,0xC1,0xDF,0xFE,
0x1F,0xC0,0xF1,0xF0,0x07,0x9E,0x00,0x3A,0xB8,0x00,
0x39,0x80,0x03,0x9C,0x00,0x39,0xC0,0x07,0x0E,0x00,
0xF0,0xF8,0x1E,0x07,0xFF,0xC0,0x1F,0xF8,0x00,0x7E,
0x00,0x09,0x38,0x40,0x2D,0x3F,0xFF,0xF8,0x00,0x06,
0x00,0x01,0x80,0x00,0x60,0x00,0x1C,0x00,0x07,0x00,
0x00,0xC0,0x00,0x38,0x20,0x01,0xC0,0x80,0x0E,0x02,
0x40,0x70,0x09,0x03,0x80,0x28,0x1C,0x00,0xA0,0xE0,
0x00,0x09,0x38,0x40,0x2C,0x03,0xF0,0x01,0xFF,0x80,
0x7F,0xF8,0x1E,0x07,0x87,0x80,0x7A,0x9C,0x00,0xE3,
0xC0,0x3C,0x3C,0x0F,0x03,0xFF,0xC0,0x3F,0xE0,0x0F,
0xFF,0x03,0xC0,0xF0,0xF0,0x0F,0x3C,0x00,0xEB,0xE0,
0x01,0xDE,0x00,0x79,0xC0,0x0E,0x1E,0x07,0x83,0xFF,
0xF0,0x1F,0xF8,0x00,0xFC,0x00,0x09,0x38,0x40,0x2C,
0x03,0xF0,0x01,0xFF,0x80,0xFF,0xF8,0x1E,0x07,0x87,
0x80,0x70,0xE0,0x07,0x3C,0x00,0x67,0x00,0x0D,0x5C,
0x00,0x39,0xC0,0x0F,0x3C,0x03,0xE7,0xC0,0xFC,0x7F,
0xFB,0x87,0xFE,0x70,0x3F,0x0E,0x00,0x01,0xE0,0x00,
0x0E,0x70,0x01,0xCE,0x00,0x70,0xE0,0x1E,0x1E,0x07,
0x81,0xFF,0xE0,0x1F,0xF8,0x00,0xFC,0x00,0x01,0xAA,
0x60,0x17,0x3F,0x46,0x80,0x9E,0x01,0xB6,0x7D,0x17,
0x3F,0x46,0x80,0x9F,0x4D,0x90,0x09,0xA6,0x42,0x2E,
0x00,0x00,0x20,0x00,0x1E,0x00,0x07,0xE0,0x01,0xFC,
0x00,0xFE,0x00,0x3F,0x80,0x0F,0xC0,0x07,0xF0,0x00,
0xF8,0x00,0x0E,0x00,0x00,0xF8,0x00,0x07,0xF0,0x00,
0x0F,0xC0,0x00,0x3F,0x80,0x00,0xFE,0x00,0x01,0xFC,
0x00,0x07,0xE0,0x00,0x1E,0x00,0x00,0x20,0x09,0x98,
0x44,0x2F,0x3F,0xFF,0xFF,0x00,0x00,0x04,0xFF,0xFF,
0xF0,0x09,0xA6,0x42,0x2E,0x80,0x00,0x0F,0x00,0x00,
0xFC,0x00,0x07,0xF0,0x00,0x0F,0xE0,0x00,0x3F,0x80,
0x00,0x7E,0x00,0x01,0xFC,0x00,0x03,0xE0,0x00,0x0E,
0x00,0x03,0xE0,0x01,0xFC,0x00,0x7E,0x00,0x3F,0x80,
0x0F,0xE0,0x07,0xF0,0x00,0xFC,0x00,0x0F,0x00,0x00,
0x80,0x00,0x00,0x09,0x38,0x40,0x2C,0x03,0xF0,0x01,
0xFF,0xC0,0xFF,0xFC,0x1E,0x07,0xC7,0x80,0x78,0xE0,
0x07,0xC7,0x00,0x0E,0x00,0x01,0xC0,0x00,0x78,0x00,
0x0E,0x00,0x03,0xC0,0x01,0xF0,0x00,0x7C,0x00,0x1F,
0x00,0x03,0xC0,0x00,0xF0,0x00,0x3C,0x05,0x00,0xE0,
0x12,0x00,0x00,0x48,0x0E,0x00,0x12,0x48,0x5C,0x50,
0x00,0x03,0xFE,0x00,0x00,0x00,0xFF,0xFE,0x00,0x00,
0x1F,0xFF,0xFC,0x00,0x03,0xFC,0x03,0xF8,0x00,0x3F,
0x00,0x07,0xE0,0x03,0xE0,0x00,0x0F,0x80,0x3C,0x00,
0x00,0x3C,0x01,0xC0,0x3E,0x1C,0xF0,0x1E,0x07,0xFC,
0xE3,0xC1,0xE0,0x7F,0xF7,0x0E,0x0E,0x07,0x83,0xF0,
0x70,0xF0,0x78,0x07,0x81,0xC7,0x07,0x80,0x3C,0x0E,
0x38,0x78,0x00,0xE0,0x73,0xC3,0x80,0x07,0x03,0x9C,
0x1C,0x00,0x30,0x1C,0xE1,0xE0,0x01,0x80,0xE7,0x0E,
0x00,0x0C,0x07,0x47,0x0E,0x00,0x1C,0x0E,0x38,0x70,
0x00,0xE0,0xF1,0xC3,0x80,0x0E,0x07,0x0E,0x1E,0x00,
0xF0,0x78,0x78,0x70,0x0F,0x87,0x81,0xC3,0xE1,0xFC,
0x78,0x0E,0x0F,0xFE,0xFF,0x80,0x78,0x3F,0xE7,0xF8,
0x01,0xE0,0x7C,0x1F,0x03,0x8F,0x00,0x00,0x00,0x38,
0x3E,0x00,0x00,0x03,0x80,0xF8,0x00,0x00,0x78,0x03,
0xF0,0x00,0x0F,0x80,0x0F,0xF0,0x03,0xF8,0x00,0x1F,
0xFF,0xFF,0x80,0x00,0x3F,0xFF,0xF0,0x00,0x00,0x1F,
0xF8,0x00,0x00,0x0C,0xB8,0x20,0x35,0x20,0x07,0xC0,
0x08,0x00,0x77,0x00,0x00,0x3D,0xE0,0x10,0x01,0xC7,
0x00,0x80,0x1C,0x1C,0x00,0x0F,0x07,0x81,0x00,0x70,
0x1C,0x00,0x3C,0x07,0x82,0x01,0xC0,0x1C,0x10,0x1F,
0xFF,0xF0,0x0F,0xFF,0xFE,0x20,0x70,0x00,0x71,0x27,
0x00,0x01,0xC8,0x70,0x00,0x07,0x3C,0x00,0x01,0xEE,
0x00,0x00,0x38,0x0A,0xB8,0x60,0x34,0xFF,0xFE,0x03,
0xFF,0xFE,0x0F,0xFF,0xFC,0x38,0x00,0xF8,0xE0,0x00,
0xE5,0xF0,0x00,0x39,0xC0,0x01,0xC7,0x00,0x1F,0x1F,
0xFF,0xF0,0x7F,0xFF,0xE1,0xFF,0xFF,0xC7,0x00,0x0F,
0x9C,0x00,0x0E,0x70,0x00,0x3E,0xB8,0x00,0x0E,0xE0,
0x00,0x7B,0x80,0x01,0xCE,0x00,0x1F,0x3F,0xFF,0xF8,
0xFF,0xFF,0xC3,0xFF,0xF8,0x00,0x0C,0x38,0x40,0x38,
0x00,0x7F,0x00,0x01,0xFF,0xE0,0x01,0xFF,0xFC,0x01,
0xF0,0x3F,0x01,0xE0,0x07,0x81,0xE0,0x01,0xE0,0xE0,
0x00,0x78,0xE0,0x00,0x1C,0x70,0x00,0x08,0x78,0x00,
0x00,0x6F,0x00,0x00,0x03,0x80,0x00,0x00,0xE0,0x00,
0x08,0x70,0x00,0x07,0x38,0x00,0x07,0x8E,0x00,0x03,
0x87,0x80,0x03,0xC1,0xE0,0x03,0xC0,0x7C,0x07,0xC0,
0x1F,0xFF,0xC0,0x07,0xFF,0xC0,0x00,0x7F,0x00,0x0B,
0xB8,0x60,0x38,0xFF,0xFE,0x00,0xFF,0xFF,0x80,0xFF,
0xFF,0xE0,0xE0,0x03,0xF0,0xE0,0x00,0xF0,0xE0,0x00,
0x78,0xE0,0x00,0x3D,0x1C,0x00,0x03,0xB7,0x80,0x00,
0x3C,0x70,0x00,0x07,0x70,0x00,0x0F,0x8E,0x00,0x01,
0xCE,0x00,0x03,0xCE,0x00,0x07,0x8E,0x00,0x0F,0x0E,
0x00,0x3F,0x0F,0xFF,0xFE,0x0F,0xFF,0xF8,0x0F,0xFF,
0xE0,0x00,0x0A,0xB8,0x60,0x35,0x3F,0xFF,0xFE,0xDE,
0x00,0x00,0x47,0x00,0x00,0x27,0xFF,0xFF,0x9B,0xC0,
0x00,0x09,0xE0,0x00,0x04,0xFF,0xFF,0xFC,0x09,0xB8,
0x60,0x31,0x3F,0xFF,0xFF,0x78,0x00,0x04,0x70,0x00,
0x09,0xFF,0xFF,0x9B,0xC0,0x00,0x33,0x80,0x00,0x00,
0x0D,0x38,0x40,0x3C,0x00,0x3F,0xC0,0x00,0x3F,0xFF,
0x00,0x1F,0xFF,0xF0,0x07,0xE0,0x1F,0x01,0xF0,0x00,
0xF0,0x78,0x00,0x0F,0x0E,0x00,0x00,0xE3,0xC0,0x00,
0x1C,0x70,0x00,0x01,0x8E,0x00,0x00,0x05,0x70,0x00,
0x00,0x13,0xC0,0x07,0xFF,0xB8,0x00,0x00,0x78,0x70,
0x00,0x01,0xCF,0x00,0x00,0x38,0xE0,0x00,0x07,0x1E,
0x00,0x01,0xE1,0xF0,0x00,0x7C,0x1F,0x80,0x7F,0x01,
0xFF,0xFF,0xC0,0x0F,0xFF,0xE0,0x00,0x3F,0xE0,0x00,
0x0B,0x38,0x60,0x39,0xBC,0x00,0x03,0xDF,0x00,0x00,
0xF3,0xFF,0xFF,0xFE,0xF0,0x00,0x0F,0x9C,0x00,0x03,
0x80,0x01,0xB8,0x80,0x17,0xBF,0x7E,0xFD,0xE0,0x08,
0x38,0x20,0x29,0xA0,0x00,0xFA,0x00,0x0F,0x60,0x00,
0xF3,0xC0,0x0E,0xF0,0x07,0x38,0x07,0x1F,0x0F,0x87,
0xFF,0x81,0xFF,0x80,0x3F,0x00,0x0B,0xB8,0x60,0x34,
0xE0,0x00,0x78,0xE0,0x00,0xF0,0xE0,0x01,0xE0,0xE0,
0x03,0xC0,0xE0,0x07,0x80,0xE0,0x0F,0x00,0xE0,0x1E,
0x00,0xE0,0x3C,0x00,0xE0,0x78,0x00,0xE0,0xF0,0x00,
0xE1,0xE0,0x00,0xE3,0xE0,0x00,0xE7,0xF0,0x00,0xEF,
0x70,0x00,0xFE,0x78,0x00,0xFC,0x3C,0x00,0xF8,0x1C,
0x00,0xF0,0x0E,0x00,0xE0,0x0F,0x00,0xE0,0x07,0x80,
0xE0,0x03,0x80,0xE0,0x01,0xC0,0xE0,0x01,0xE0,0xE0,
0x00,0xF0,0xE0,0x00,0x70,0xE0,0x00,0x38,0xE0,0x00,
0x3C,0xE0,0x00,0x1E,0x09,0x38,0x60,0x2D,0xBC,0x00,
0x06,0xF0,0x00,0x1B,0xC0,0x00,0x57,0x00,0x01,0x3F,
0xFF,0xF8,0x0C,0xB8,0x80,0x42,0xF8,0x00,0x0F,0xCF,
0xE0,0x00,0xFD,0xFC,0x00,0x7F,0x8E,0xE0,0x03,0xBB,
0xB8,0x01,0xEF,0x3C,0xE0,0x0E,0x79,0xE3,0x80,0xE3,
0xCF,0x0E,0x0E,0x1D,0xC1,0xC7,0x87,0x8E,0x0E,0x38,
0x3B,0x83,0x9E,0x0F,0x3C,0x0E,0xE0,0x79,0xE0,0x3E,
0x03,0xB8,0x07,0x00,0xE0,0x0B,0x38,0x60,0x39,0x1E,
0x00,0x03,0xBE,0x00,0x07,0x8F,0xC0,0x01,0xDD,0xC0,
0x03,0xBB,0xC0,0x07,0x73,0x80,0x0E,0xE3,0x80,0x1D,
0xC7,0x80,0x3B,0x87,0x00,0x77,0x07,0x00,0xEE,0x0F,
0x01,0xDC,0x0E,0x03,0xB8,0x0E,0x07,0x70,0x1E,0x0E,
0xE0,0x1C,0x1D,0xC0,0x1C,0x3B,0x80,0x3C,0x77,0x00,
0x38,0xEE,0x00,0x39,0xDC,0x00,0x7B,0xB8,0x00,0x77,
0x8E,0x00,0x0F,0xDC,0x00,0x0F,0xC7,0x00,0x01,0xE0,
0x0D,0x38,0x40,0x3C,0x00,0x7F,0x80,0x00,0x3F,0xFC,
0x00,0x1F,0xFF,0xE0,0x07,0xE0,0x7E,0x01,0xF0,0x03,
0xE0,0x78,0x00,0x1E,0x0E,0x00,0x01,0xC3,0x80,0x00,
0x3D,0x0E,0x00,0x00,0x76,0xF0,0x00,0x00,0xEE,0x00,
0x00,0x1E,0x1C,0x00,0x00,0xE3,0xC0,0x00,0x3C,0x38,
0x00,0x07,0x07,0x80,0x01,0xE0,0x78,0x00,0xF8,0x07,
0xE0,0x7E,0x00,0x7F,0xFF,0x80,0x03,0xFF,0xC0,0x00,
0x1F,0xE0,0x00,0x0A,0xB8,0x60,0x34,0xFF,0xFF,0x03,
0xFF,0xFF,0x0F,0xFF,0xFE,0x38,0x00,0x7C,0xE0,0x00,
0x73,0x80,0x01,0xF5,0xC0,0x00,0x77,0x00,0x03,0xDC,
0x00,0x0E,0x70,0x00,0xF9,0xFF,0xFF,0xC7,0xFF,0xFE,
0x1F,0xFF,0xC0,0xDE,0x00,0x00,0x5F,0x00,0x00,0x00,
0x0D,0x3C,0x5F,0x3C,0x00,0x7F,0x00,0x00,0x7F,0xF8,
0x00,0x1F,0xFF,0xC0,0x07,0xC0,0x7C,0x01,0xE0,0x03,
0xC0,0x78,0x00,0x3C,0x0E,0x00,0x03,0x83,0x80,0x00,
0x79,0x0E,0x00,0x00,0xE6,0xF0,0x00,0x01,0xCE,0x00,
0x00,0x38,0xE0,0x00,0x0F,0x1C,0x00,0x01,0xC3,0x80,
0x30,0x38,0x38,0x07,0x8F,0x07,0x80,0xFB,0xC0,0x78,
0x07,0xF8,0x07,0xC0,0x7E,0x00,0x7F,0xFF,0xE0,0x03,
0xFF,0xFF,0x00,0x1F,0xE3,0xF0,0x00,0x00,0x1C,0x00,
0x00,0x00,0x80,0x0B,0xB8,0x60,0x38,0xFF,0xFF,0x80,
0xFF,0xFF,0xE0,0xFF,0xFF,0xF0,0xE0,0x00,0xF8,0xE0,
0x00,0x78,0xE0,0x00,0x3D,0x5C,0x00,0x03,0x9C,0x00,
0x07,0x9C,0x00,0x0F,0x1C,0x00,0x3F,0x1F,0xFF,0xFE,
0x1F,0xFF,0xFC,0x1F,0xFF,0xE0,0x1C,0x07,0xC0,0x23,
0x80,0x3C,0x03,0x80,0x1E,0x03,0x80,0x0F,0x03,0x80,
0x07,0x83,0x80,0x07,0xC3,0x80,0x03,0xC4,0x70,0x00,
0x3C,0x70,0x00,0x1E,0x70,0x00,0x0F,0x0B,0x38,0x40,
0x34,0x01,0xFE,0x00,0x1F,0xFF,0x00,0x7F,0xFF,0x01,
0xF0,0x1F,0x03,0x80,0x0F,0x0E,0x00,0x0E,0x43,0x80,
0x01,0xC7,0x00,0x00,0x0F,0x00,0x00,0x0F,0x80,0x00,
0x1F,0xF0,0x00,0x1F,0xFE,0x00,0x0F,0xFF,0x80,0x03,
0xFF,0x80,0x00,0x7F,0x80,0x00,0x0F,0x80,0x00,0x07,
0xC7,0x00,0x00,0xEF,0x00,0x01,0xCE,0x00,0x03,0x9E,
0x00,0x0F,0x1E,0x00,0x3C,0x3F,0x01,0xF0,0x3F,0xFF,
0xC0,0x1F,0xFF,0x00,0x0F,0xF8,0x00,0x0A,0xB8,0x20,
0x2F,0x3F,0xFF,0xFF,0xD0,0x07,0x00,0x68,0x03,0x80,
0x34,0x01,0xC0,0x14,0x00,0xE0,0x00,0x0B,0x38,0x60,
0x39,0xBC,0x00,0x03,0xEF,0x00,0x00,0xF9,0xC0,0x00,
0x3B,0x80,0x00,0xF8,0x70,0x00,0x38,0xF0,0x00,0xF0,
0xF8,0x07,0xC0,0xFF,0xFF,0x00,0xFF,0xFC,0x00,0x3F,
0xC0,0x00,0x0C,0xB8,0x20,0x34,0xE0,0x00,0x03,0xBC,
0x00,0x01,0xF0,0xE0,0x00,0x0E,0x83,0x80,0x00,0xE0,
0xF0,0x00,0x79,0x03,0x80,0x03,0x80,0xF0,0x01,0xE0,
0x1C,0x00,0x70,0x07,0x80,0x3C,0x20,0x1C,0x01,0xC0,
0x07,0x80,0xF0,0x00,0xE0,0x38,0x00,0x3C,0x1E,0x04,
0x00,0xE0,0xE0,0x00,0x3C,0x78,0x00,0x07,0x1C,0x00,
0x01,0xCF,0x00,0x80,0x07,0x70,0x00,0x01,0xFC,0x01,
0x20,0x07,0xC0,0x00,0x12,0xB8,0x00,0x4C,0xE0,0x00,
0xF8,0x00,0x3B,0xC0,0x03,0xE0,0x01,0xE7,0x00,0x0F,
0x80,0x07,0x43,0x80,0x0E,0xE0,0x03,0x8F,0x00,0x3B,
0x80,0x1E,0x1C,0x01,0xEE,0x00,0x72,0x0E,0x00,0xE3,
0x80,0x38,0x1C,0x03,0x8E,0x01,0xC4,0x8E,0x03,0x83,
0x80,0xE0,0x1C,0x1E,0x0E,0x07,0x08,0x0E,0x0E,0x03,
0x83,0x80,0x38,0x38,0x0E,0x1E,0x00,0x71,0xE0,0x1C,
0x70,0x40,0x38,0xE0,0x0E,0x38,0x00,0xF7,0x80,0x39,
0xE0,0x90,0x3B,0x80,0x0E,0xE0,0x00,0x7E,0x00,0x1F,
0x01,0x20,0x3E,0x00,0x0F,0x80,0x0C,0xB8,0x00,0x32,
0x78,0x00,0x0F,0x0F,0x00,0x07,0x81,0xC0,0x01,0xC0,
0x38,0x00,0xE0,0x0F,0x00,0x78,0x01,0xE0,0x3C,0x00,
0x38,0x0E,0x00,0x07,0x07,0x80,0x01,0xE3,0xC0,0x00,
0x38,0xE0,0x00,0x07,0x70,0x00,0x01,0xFC,0x00,0x00,
0x3E,0x00,0x00,0x07,0x00,0x00,0x03,0xE0,0x00,0x01,
0xFC,0x00,0x00,0xF7,0x80,0x00,0x38,0xE0,0x00,0x1C,
0x1C,0x00,0x0F,0x07,0x80,0x07,0x80,0xE0,0x01,0xC0,
0x1C,0x00,0xF0,0x07,0x80,0x78,0x00,0xF0,0x1C,0x00,
0x1C,0x0E,0x00,0x03,0x87,0x80,0x00,0xF3,0xC0,0x00,
0x1E,0x0C,0xB8,0x00,0x32,0xF0,0x00,0x07,0x9C,0x00,
0x01,0xC3,0x80,0x00,0xE0,0xF0,0x00,0x78,0x1E,0x00,
0x3C,0x03,0x80,0x0E,0x00,0xF0,0x07,0x80,0x1E,0x03,
0xC0,0x03,0x80,0xE0,0x00,0xF0,0x78,0x00,0x1E,0x3C,
0x00,0x03,0x8E,0x00,0x00,0x77,0x00,0x00,0x1F,0xC0,
0x00,0x03,0xE0,0x06,0x80,0x0E,0x00,0x30,0x00,0x70,
0x00,0x0B,0x38,0x20,0x31,0x27,0xFF,0xFF,0x00,0x00,
0x1E,0x00,0x00,0x78,0x00,0x01,0xE0,0x00,0x03,0x80,
0x00,0x0E,0x00,0x00,0x3C,0x00,0x00,0xF0,0x00,0x03,
0xC0,0x00,0x07,0x00,0x00,0x1C,0x00,0x00,0x78,0x00,
0x01,0xE0,0x00,0x07,0x80,0x00,0x0E,0x00,0x00,0x38,
0x00,0x00,0xF0,0x00,0x03,0xC0,0x00,0x0F,0x00,0x00,
0x1C,0x00,0x00,0x70,0x00,0x01,0xE0,0x00,0x07,0x80,
0x00,0x13,0xFF,0xFF,0xF8,0x03,0xC8,0x5C,0x17,0x3F,
0xF7,0x86,0xF0,0xDE,0x1B,0xC2,0x38,0x4F,0xF0,0x05,
0xB8,0x00,0x17,0x1C,0x02,0x5C,0x05,0x1C,0x09,0x1C,
0x14,0x1C,0x24,0x1C,0x50,0x1C,0x90,0x1D,0x00,0x1C,
0x03,0xC8,0x5C,0x17,0x3F,0xF4,0x3E,0x87,0xD0,0xFA,
0x1E,0x03,0xCF,0xF0,0x07,0x9E,0x26,0xA2,0x03,0x81,
0x00,0xF8,0x00,0xD8,0x20,0x3B,0x84,0x0E,0x38,0x0C,
0x18,0x83,0x83,0x92,0xE0,0x39,0xC0,0x1C,0x0B,0x87,
0xFC,0x2D,0x3F,0xFF,0xFF,0xC0,0x03,0x8A,0x4B,0x9A,
0xF8,0x7C,0x3C,0x1C,0x0E,0x09,0x2A,0x40,0x2C,0x07,
0xF8,0x03,0xFF,0xC0,0xFF,0xFC,0x3C,0x07,0xCF,0x00,
0x79,0xC0,0x07,0x40,0x00,0x1C,0x00,0x0F,0x80,0x7F,
0xF0,0x7F,0xFE,0x1F,0xF9,0xC7,0xC0,0x39,0xE0,0x07,
0x38,0x00,0xE7,0x00,0x3C,0xE0,0x0F,0x9F,0x07,0xF1,
0xFF,0xEE,0x1F,0xF9,0xC0,0xFC,0x1C,0x09,0x38,0x60,
0x2D,0xBC,0x00,0x03,0x8F,0xC0,0x77,0xFE,0x0F,0xFF,
0xE1,0xFC,0x3E,0x3E,0x01,0xE8,0xF0,0x03,0xB7,0x80,
0x07,0x8F,0x00,0x39,0xF0,0x0F,0x3F,0x87,0xC7,0xFF,
0xF0,0xEF,0xFC,0x1C,0x7E,0x00,0x08,0xAA,0x40,0x28,
0x03,0xF0,0x03,0xFF,0x01,0xFF,0xE0,0xF8,0x7C,0x78,
0x07,0x1C,0x01,0xEF,0x00,0x3E,0x70,0x00,0x1C,0x00,
0x77,0x80,0x1C,0xE0,0x0E,0x3C,0x03,0x87,0x83,0xC0,
0xFF,0xF0,0x1F,0xF8,0x01,0xF8,0x00,0x09,0x38,0x20,
0x2D,0xA0,0x00,0x38,0x0F,0xC7,0x07,0xFE,0xE1,0xFF,
0xFC,0x7C,0x3F,0x9E,0x01,0xF8,0x70,0x03,0xF7,0x80,
0x07,0x87,0x00,0x3C,0xF0,0x0F,0x8F,0x87,0xF0,0xFF,
0xFE,0x0F,0xFD,0xC0,0x7E,0x38,0x09,0x2A,0x40,0x2C,
0x03,0xF0,0x01,0xFF,0x80,0x7F,0xF8,0x1E,0x07,0x87,
0x80,0x78,0xE0,0x07,0x18,0x00,0x77,0x00,0x0F,0x3F,
0xFF,0xFC,0xF0,0x00,0x0F,0x00,0x00,0xE0,0x03,0x9E,
0x00,0xE1,0xF0,0x7C,0x1F,0xFF,0x01,0xFF,0xC0,0x0F,
0xE0,0x05,0xB8,0x20,0x18,0x07,0xE0,0xFE,0x1F,0xE1,
0xE1,0x23,0x82,0x7F,0xF6,0x8E,0x0D,0x1C,0x14,0x38,
0x00,0x09,0x3A,0x3C,0x2C,0x03,0xF1,0xC1,0xFF,0x38,
0x7F,0xFF,0x1F,0x0F,0xE7,0x80,0x7E,0x1C,0x00,0xFD,
0xE0,0x01,0xE1,0xC0,0x0F,0x3C,0x03,0xE3,0xE1,0xFC,
0x3F,0xFF,0x83,0xFF,0x70,0x1F,0x8E,0x00,0x01,0xDC,
0x00,0x3B,0x80,0x0E,0x78,0x03,0xC7,0xC0,0xF8,0xFF,
0xFE,0x07,0xFF,0x00,0x3F,0x80,0x08,0x38,0x60,0x2D,
0xBC,0x00,0x0E,0x3F,0x07,0x7F,0xE3,0xFF,0xF9,0xF8,
0x3C,0xF8,0x0F,0x78,0x03,0xEF,0x00,0x3E,0xF0,0x03,
0xB8,0x01,0xC0,0x01,0xB8,0x60,0x13,0x3E,0x86,0xFD,
0xFB,0xC0,0x04,0x49,0xDC,0x13,0x20,0xF4,0x01,0xA0,
0xFA,0x0F,0xA0,0xF4,0x0E,0x0F,0x3F,0x3F,0x9F,0x00,
0x08,0xB8,0x60,0x29,0xBC,0x00,0x07,0x00,0x79,0xC0,
0x3C,0x70,0x1E,0x1C,0x0F,0x07,0x07,0x81,0xC3,0xC0,
0x71,0xE0,0x1C,0xF0,0x07,0x78,0x01,0xFF,0x00,0x7D,
0xE0,0x1E,0x38,0x07,0x0F,0x01,0xC1,0xE0,0x70,0x38,
0x1C,0x0F,0x07,0x01,0xE1,0xC0,0x3C,0x70,0x07,0x1C,
0x01,0xE7,0x00,0x3C,0x01,0xB8,0x60,0x13,0xBF,0x7E,
0xFD,0xE0,0x0D,0xAA,0x60,0x42,0xE3,0xF0,0x3F,0x0E,
0x7F,0x8F,0xF8,0xEF,0xFD,0xFF,0xCF,0xC3,0xDC,0x3C,
0xF8,0x1F,0x01,0xEF,0x00,0xF0,0x0F,0xBC,0x01,0xC0,
0x1F,0x78,0x03,0x80,0x3B,0x80,0x38,0x03,0x80,0x08,
0x2A,0x60,0x2C,0xE3,0xF0,0x77,0xFE,0x3F,0xFF,0x9F,
0x83,0xCF,0x80,0xF7,0x80,0x3E,0xF0,0x03,0xEF,0x00,
0x3B,0x80,0x1C,0x09,0x2A,0x40,0x2C,0x03,0xF0,0x01,
0xFF,0x80,0x7F,0xF8,0x1F,0x0F,0x87,0x80,0x78,0xE0,
0x07,0x3C,0x00,0xFD,0xE0,0x01,0xDE,0x00,0x79,0xC0,
0x0E,0x3C,0x03,0xC3,0xE1,0xF0,0x3F,0xFC,0x03,0xFF,
0x00,0x1F,0x80,0x09,0x3A,0x7C,0x2C,0xE3,0xF0,0x1C,
0xFF,0x83,0xBF,0xF8,0x7F,0x0F,0x8F,0x80,0x7A,0x3C,
0x00,0xED,0xE0,0x01,0xE3,0xC0,0x0E,0x7C,0x03,0xCF,
0xC1,0xF1,0xFF,0xFC,0x3B,0xFF,0x07,0x1F,0x81,0xBC,
0x00,0x03,0x80,0x00,0x09,0x3A,0x3C,0x2C,0x03,0xF1,
0xC1,0xFF,0x38,0x7F,0xF7,0x1F,0x0F,0xE7,0x80,0x7C,
0xE0,0x07,0xBC,0x00,0xFD,0xE0,0x01,0xE1,0xC0,0x0F,
0x3C,0x03,0xE3,0xE1,0xFC,0x3F,0xFF,0x83,0xFF,0x70,
0x1F,0x8F,0xA0,0x00,0x38,0x00,0x07,0x05,0x2A,0x60,
0x1A,0xE7,0xDD,0xFB,0xFE,0x7C,0x11,0xE0,0x6F,0x01,
0xBC,0x03,0x80,0x08,0xAA,0x20,0x26,0x0F,0xE0,0x0F,
0xFE,0x07,0xFF,0xE1,0xE0,0x78,0xE0,0x0F,0x38,0x01,
0xCE,0x00,0x03,0xE0,0x00,0x7F,0x80,0x1F,0xFE,0x01,
0xFF,0xE0,0x0F,0xFC,0x00,0x3F,0x80,0x01,0xF1,0xC0,
0x07,0x38,0x03,0xCF,0x81,0xE1,0xFF,0xF0,0x3F,0xF8,
0x03,0xF8,0x00,0x05,0x38,0x00,0x16,0x04,0x01,0x85,
0x8E,0x13,0xFF,0xE8,0xE1,0xA3,0x80,0x78,0x0F,0xE0,
0xFC,0x0F,0x80,0x08,0x2A,0x60,0x2D,0xBC,0x00,0xFB,
0xC0,0x0E,0xE0,0x07,0x70,0x07,0xBC,0x07,0xCF,0x07,
0xE7,0xFF,0x71,0xFF,0x38,0x3F,0x1C,0x09,0xAA,0x00,
0x26,0xE0,0x00,0xF0,0xE0,0x03,0x8F,0x00,0x7A,0x0E,
0x00,0xE0,0x70,0x1E,0x07,0x01,0xC0,0x78,0x3C,0x40,
0x70,0x70,0x07,0x8F,0x08,0x07,0x1C,0x12,0x07,0x70,
0x20,0x07,0xC0,0x00,0x3C,0x00,0x03,0x80,0x00,0x0E,
0xAA,0x00,0x3B,0x1C,0x00,0xE0,0x07,0x78,0x07,0xC0,
0x3E,0x1C,0x03,0xE0,0x1C,0x38,0x0D,0x80,0xE4,0x1C,
0x0E,0xE0,0x70,0x38,0x31,0x83,0x80,0xE1,0xC7,0x0E,
0x01,0x87,0x1C,0x70,0x07,0x1C,0x31,0xC0,0x1C,0xE0,
0xE7,0x00,0x33,0x83,0xB8,0x00,0xEE,0x0E,0xE0,0x03,
0xB8,0x1B,0x02,0x00,0xF8,0x0F,0x80,0x01,0xE0,0x3C,
0x00,0x07,0x00,0x70,0x00,0x1C,0x01,0x80,0x00,0x09,
0x2A,0x00,0x24,0xF0,0x01,0xCF,0x00,0x70,0xE0,0x1E,
0x1E,0x07,0x81,0xE0,0xE0,0x1C,0x3C,0x03,0xCF,0x00,
0x3D,0xC0,0x03,0xF0,0x00,0x3E,0x04,0x00,0xF0,0x00,
0x3F,0x00,0x0F,0xF0,0x01,0xCF,0x00,0x70,0xE0,0x1E,
0x1E,0x07,0x81,0xE0,0xE0,0x1C,0x3C,0x03,0xCF,0x00,
0x3C,0x08,0xBA,0x3C,0x26,0xE0,0x03,0x9C,0x01,0xF0,
0xE0,0x0E,0x1C,0x07,0xA0,0xE0,0x38,0x1C,0x1E,0x40,
0xE0,0xE0,0x1C,0x78,0x80,0xE3,0x80,0x1D,0xE1,0x00,
0xEE,0x00,0x1F,0x82,0x00,0xF8,0x00,0x1E,0x04,0x80,
0xE0,0x20,0x0E,0x00,0x07,0x00,0x0F,0xC0,0x03,0xE0,
0x00,0xF0,0x00,0x09,0x2A,0x00,0x27,0x2F,0xFF,0xF8,
0x00,0x1E,0x00,0x07,0x80,0x01,0xE0,0x00,0x38,0x00,
0x0F,0x00,0x03,0xC0,0x00,0xF0,0x00,0x3C,0x00,0x0F,
0x00,0x03,0xC0,0x00,0xF0,0x00,0x3C,0x00,0x0F,0x00,
0x03,0xC0,0x00,0x70,0x00,0x27,0xFF,0xFF,0x05,0xC8,
0x3C,0x1A,0x01,0xF0,0x0F,0xC1,0xE3,0x43,0x85,0x07,
0x00,0xE0,0x1E,0x07,0xC0,0x70,0x07,0xC0,0x1E,0x00,
0xE0,0xD0,0xE1,0x21,0xC0,0x1E,0x20,0x1F,0x80,0x78,
0x01,0xCA,0x7B,0x93,0xBF,0x7E,0xFD,0xFB,0xE3,0x80,
0x05,0xC8,0x3C,0x1A,0xF0,0x0F,0x80,0xFC,0x01,0xE1,
0xA1,0xC2,0x83,0x80,0x1C,0x01,0xE0,0x0F,0x80,0x38,
0x0F,0x81,0xE0,0x1C,0x68,0x70,0x90,0xE0,0x1E,0x11,
0xF8,0x1E,0x00,0x0A,0x0C,0x25,0xAE,0x1F,0x00,0x03,
0xFF,0x01,0xBF,0xFE,0x1D,0xC3,0xFF,0xEC,0x03,0xFE,
0x00,0x07,0xC0,};
/* font data size: 3983 bytes */

static const unsigned char font_tgx_Arial_28_index[] = {
0x00,0x00,0x04,0x00,0xD0,0x18,0x04,
0x40,0x86,0x0F,0x71,0x4A,0x15,0x11,0x6F,0x18,0xE1,
0xA4,0x1B,0x61,0xBD,0x1C,0x31,0xC8,0x1D,0xD2,0x04,
0x21,0xD2,0x61,0x2A,0x02,0xD5,0x30,0x83,0x49,0x37,
0x13,0xA8,0x3E,0x63,0xEE,0x3F,0x84,0x2C,0x43,0x94,
0x6D,0x4A,0x25,0x49,0x58,0x55,0xC4,0x60,0xD6,0x4C,
0x66,0x66,0x7C,0x6C,0xC6,0xE1,0x6E,0x97,0x04,0x75,
0xC7,0x6E,0x7A,0x37,0xEE,0x83,0x78,0x66,0x8B,0x99,
0x03,0x95,0x39,0x67,0x98,0xA9,0xD2,0xA2,0xEA,0x8D,
0xAC,0x9B,0x13,0xB2,0x1B,0x36,0xB4,0x4B,0x5C,0xB6,
0x4B,0x6D,0xBA,0x1B,0xC8,0xBF,0x1C,0x18,0xC4,0x5C,
0x59,0xC9,0x0C,0xAB,0xCB,0x4C,0xC6,0xCF,0xCD,0x04,
0xD2,0x9D,0x41,0xD6,0x9D,0x92,0xDB,0xDD,0xCD,0xDF,
0xFE,0x13,0xE2,0xBE,0x55,0xE9,0xBE,0xCF,0xF0,0x3F,
0x30,0xF5,0x0F,0x5A,0xF7,0xB0,
};
/* font index size: 143 bytes */

const ILI9341_t3_font_t font_tgx_Arial_28 = {
	font_tgx_Arial_28_index,
	0,
	font_tgx_Arial_28_data,
	1,
	0,
	32,
	126,
	0,
	0,
	12,
	6,
	6,
	4,
	6,
	6,
	43,
	28
};



static const unsigned char font_tgx_Arial_32_data[] = {
0x00,0x00,0x00,0x18,0x02,0x40,0xA0,0x1D,0xBF,0xBF,
0x1E,0x7D,0x63,0x48,0x57,0x80,0x06,0x16,0x4A,0xA1,
0xBE,0x1E,0xF0,0xF3,0x83,0x43,0x03,0x00,0x0C,0x40,
0x00,0x31,0x00,0x0F,0x07,0x80,0x0F,0x87,0x8A,0x00,
0xF0,0x78,0x00,0xF0,0x78,0x57,0xFF,0xFF,0xFD,0x01,
0xE0,0xF0,0x48,0x3C,0x1E,0x05,0x7F,0xFF,0xFF,0xC0,
0x78,0x3C,0x05,0x0F,0x07,0x80,0x07,0x87,0xC0,0x20,
0xF0,0x78,0x00,0x0A,0x4C,0x5E,0x31,0x00,0x0C,0x00,
0x01,0xF8,0x00,0x7F,0xF0,0x07,0xFF,0xE0,0x7F,0xFF,
0x03,0xE6,0xFC,0x3E,0x31,0xE1,0xE1,0x8F,0x8F,0x0C,
0x3C,0x78,0x61,0x88,0x78,0x60,0x01,0xE3,0x00,0x0F,
0xD8,0x00,0x3F,0xE0,0x00,0xFF,0xE0,0x01,0xFF,0x80,
0x03,0xFF,0x00,0x0D,0xF8,0x00,0x63,0xE0,0x03,0x0F,
0x40,0x03,0x07,0x8C,0x18,0x3D,0xE0,0xC1,0xEF,0x86,
0x0F,0x7C,0x30,0xF9,0xF1,0x8F,0x8F,0xCC,0xFC,0x3F,
0xFF,0xC0,0xFF,0xFC,0x03,0xFF,0xC0,0x07,0xF8,0x14,
0x00,0xC0,0x00,0x11,0x40,0x40,0x4E,0x0F,0x80,0x00,
0xE0,0x07,0xF8,0x00,0x3C,0x00,0xFF,0x80,0x07,0x00,
0x3C,0x78,0x01,0xE0,0x07,0x07,0x00,0x38,0x01,0xC0,
0x70,0x0F,0x00,0x38,0x0E,0x01,0xC0,0x08,0xE0,0x38,
0x0E,0x00,0x1C,0x07,0x03,0x80,0x03,0x80,0xE0,0xF0,
0x00,0x70,0x1C,0x1C,0x00,0x07,0x07,0x07,0x80,0x00,
0xF1,0xE0,0xE0,0x00,0x0F,0xF8,0x3C,0x00,0x01,0xFE,
0x07,0x03,0xE0,0x0F,0x81,0xC1,0xFE,0x00,0x00,0x38,
0x3F,0xE0,0x00,0x0E,0x0F,0x1E,0x00,0x03,0xC1,0xC1,
0xC0,0x00,0x70,0x70,0x1C,0x00,0x1E,0x0E,0x03,0x80,
0x03,0x81,0xC0,0x70,0x00,0xF0,0x38,0x0E,0x00,0x1C,
0x07,0x01,0xE0,0x00,0xE0,0x1C,0x07,0x00,0x38,0x01,
0xC1,0xC0,0x0F,0x00,0x3C,0x78,0x01,0xC0,0x03,0xFE,
0x00,0x78,0x00,0x7F,0x80,0x0E,0x00,0x03,0xE0,0x0D,
0x40,0x40,0x3A,0x00,0x7E,0x00,0x00,0x3F,0xE0,0x00,
0x0F,0xFE,0x00,0x03,0xFF,0xE0,0x00,0xFC,0x7E,0x00,
0x1F,0x07,0xC0,0x48,0x78,0x0F,0x00,0x0F,0x83,0xC0,
0x00,0xF8,0xF8,0x00,0x0F,0x3E,0x00,0x01,0xFF,0x80,
0x00,0x1F,0xE0,0x00,0x07,0xF0,0x00,0x01,0xFF,0x00,
0x00,0xFF,0xE0,0x00,0x3F,0x3E,0x08,0x0F,0x83,0xE1,
0xE1,0xE0,0x3E,0x7C,0x7C,0x03,0xEF,0x0F,0x00,0x7D,
0xE1,0xE0,0x07,0xFC,0x3C,0x00,0x7F,0x07,0x80,0x07,
0xC0,0xF8,0x00,0xFC,0x0F,0x80,0x3F,0xC1,0xF8,0x1F,
0xFC,0x1F,0xFF,0xF7,0xC1,0xFF,0xFC,0xFC,0x1F,0xFE,
0x0F,0x00,0xFF,0x00,0xC0,0x02,0x16,0x4A,0x91,0xBE,
0xF9,0x60,0x05,0xD2,0x7B,0x9E,0x00,0xE0,0x1C,0x03,
0x80,0x78,0x07,0x00,0xF0,0x0E,0x01,0xE0,0x1C,0x10,
0x78,0x29,0xE0,0x6F,0x80,0xAF,0x01,0x4F,0x02,0x0F,
0x00,0x70,0x07,0x80,0x38,0x03,0xC0,0x1C,0x01,0xE0,
0x0E,0x00,0x70,0x03,0x80,0x05,0xD2,0x3B,0x9E,0xE0,
0x07,0x01,0x07,0x00,0x38,0x03,0xC0,0x1C,0x01,0xE0,
0x0E,0x20,0x1E,0x50,0x1E,0xD0,0x1F,0x40,0x3E,0x40,
0xF0,0x0E,0x40,0x3C,0x03,0x80,0x78,0x07,0x00,0xF0,
0x0E,0x01,0xE0,0x1C,0x03,0x80,0x70,0x00,0x07,0x9A,
0x29,0xA3,0x20,0x70,0x08,0x70,0x8F,0x77,0x9F,0xFF,
0xC7,0xFF,0x00,0xF8,0x01,0xFC,0x03,0xDE,0x20,0xF1,
0xE0,0x20,0x80,0x0B,0x2C,0x42,0x35,0xA0,0x0F,0x00,
0x40,0x03,0xC0,0x15,0xFF,0xFF,0xFE,0x80,0x3C,0x01,
0x00,0x0F,0x00,0x00,0x02,0x16,0x9C,0x99,0x5F,0x26,
0x73,0x38,0x80,0x06,0x08,0x24,0x9F,0x5F,0xFE,0x02,
0x08,0x80,0x19,0x5E,0x06,0x40,0x00,0x19,0x00,0x0F,
0x20,0x1C,0x01,0xE9,0x01,0xC9,0x03,0x80,0x3C,0x48,
0x38,0x50,0x70,0x48,0xE0,0x0F,0x02,0x4E,0x02,0x5C,
0x01,0xE0,0x0E,0x00,0x0A,0x40,0x40,0x30,0x01,0xF8,
0x00,0x3F,0xF0,0x40,0xFF,0xFC,0x0F,0xC3,0xF0,0x78,
0x07,0x87,0x80,0x3E,0x87,0x80,0x1E,0x78,0x00,0xF6,
0xF8,0x00,0x7D,0xF8,0x00,0x79,0xC0,0x03,0xA1,0xE0,
0x07,0x8F,0x00,0x7C,0x3C,0x03,0xC1,0xF8,0x7E,0x40,
0xFF,0xFC,0x03,0xFF,0x80,0x03,0xF0,0x00,0x05,0xC0,
0xA0,0x31,0x00,0x1C,0x03,0xC0,0x7C,0x0F,0xC1,0xFC,
0x7F,0xCF,0xFD,0xF3,0xDE,0x3D,0xC3,0xD0,0x3F,0x40,
0x7E,0x80,0xFC,0x01,0xE0,0x0A,0x40,0x20,0x30,0x01,
0xFC,0x00,0x3F,0xF8,0x03,0xFF,0xE0,0x3F,0xFF,0x83,
0xF0,0x7E,0x1F,0x01,0xF1,0xF0,0x07,0xE1,0xE0,0x03,
0xC3,0x00,0x1F,0x00,0x00,0x1E,0x00,0x01,0xE0,0x00,
0x1F,0x00,0x00,0xF0,0x00,0x0F,0x80,0x00,0xF8,0x00,
0x0F,0x80,0x00,0xF8,0x00,0x0F,0x80,0x00,0xF8,0x00,
0x0F,0x80,0x00,0xF8,0x00,0x0F,0x80,0x00,0xF8,0x00,
0x0F,0x80,0x00,0xF8,0x00,0x0F,0x80,0x00,0x7F,0xFF,
0xF9,0xFF,0xFF,0xF0,0x0A,0x40,0x40,0x30,0x03,0xF0,
0x00,0x7F,0xE0,0x07,0xFF,0xC0,0x7F,0xFE,0x07,0xE0,
0xF8,0x3E,0x03,0xE3,0xE0,0x0F,0x1E,0x00,0x78,0x30,
0x03,0xC8,0x00,0x03,0xC0,0x00,0x3C,0x00,0x07,0xC0,
0x01,0xFC,0x00,0x0F,0xC0,0x00,0x7F,0x80,0x03,0xFF,
0x00,0x00,0xF8,0x00,0x01,0xE0,0x00,0x0F,0xC0,0x00,
0x07,0x8C,0x00,0x3D,0xE0,0x01,0xEF,0x80,0x0F,0x7C,
0x00,0xF1,0xF0,0x0F,0x8F,0xC0,0xF8,0x3F,0xFF,0xC0,
0xFF,0xFC,0x03,0xFF,0x80,0x07,0xF0,0x00,0x0A,0xC0,
0x20,0x30,0x00,0x03,0x80,0x00,0x1E,0x10,0x00,0x1F,
0x00,0x00,0xFC,0x00,0x07,0xF0,0x80,0x07,0xF8,0x00,
0x3F,0xE0,0x01,0xF7,0x80,0x07,0x9E,0x00,0x3E,0x78,
0x01,0xF1,0xE0,0x07,0x87,0x80,0x3E,0x1E,0x01,0xF0,
0x78,0x0F,0x81,0xE0,0x3C,0x07,0x81,0xF0,0x1E,0x0F,
0x80,0x78,0x57,0xFF,0xFF,0xF4,0x00,0x1E,0x00,0x00,
0x78,0x00,0x0A,0x40,0x40,0x31,0x21,0xFF,0xF8,0x1F,
0xFF,0xCA,0x1E,0x00,0x08,0x3C,0x00,0x01,0xE3,0xE0,
0x0F,0x7F,0xC0,0x7F,0xFF,0x07,0xFF,0xFC,0x3F,0x03,
0xF1,0xF0,0x0F,0x83,0x00,0x3D,0x80,0x00,0x1E,0xF0,
0x00,0xF7,0x80,0x0F,0x3E,0x00,0x78,0xF0,0x07,0xC7,
0xE0,0x7C,0x1F,0xFF,0xC0,0x7F,0xFC,0x01,0xFF,0xC0,
0x03,0xF8,0x00,0x0A,0xC0,0x20,0x30,0x00,0xFC,0x00,
0x0F,0xFC,0x00,0xFF,0xFC,0x07,0xFF,0xF0,0x1F,0x07,
0xE0,0xF8,0x07,0x83,0xC0,0x1F,0x1E,0x00,0x3D,0x0F,
0x00,0x00,0x78,0x00,0x01,0xE0,0xFC,0x07,0x8F,0xFC,
0x1E,0xFF,0xF8,0x7F,0xFF,0xF1,0xFE,0x07,0xE7,0xE0,
0x0F,0x9F,0x00,0x1E,0x7C,0x00,0x7E,0xBC,0x00,0x1E,
0x70,0x00,0x79,0xE0,0x03,0xE7,0x80,0x0F,0x0F,0x00,
0x7C,0x3F,0x03,0xE0,0x7F,0xFF,0x80,0xFF,0xFC,0x01,
0xFF,0xC0,0x00,0xFC,0x00,0x0A,0x40,0x40,0x31,0x5F,
0xFF,0xFE,0x00,0x00,0xE0,0x00,0x0E,0x00,0x00,0xF0,
0x00,0x0F,0x00,0x00,0x70,0x00,0x07,0x84,0x00,0x0F,
0x04,0x00,0x1E,0x04,0x80,0x3C,0x04,0x00,0x78,0x05,
0x00,0xF0,0x05,0x01,0xE0,0x05,0x83,0xC0,0x00,0x0A,
0x40,0x40,0x30,0x01,0xF8,0x00,0x7F,0xF0,0x07,0xFF,
0xE0,0x7F,0xFF,0x83,0xE0,0x7C,0x3E,0x01,0xF5,0x3C,
0x00,0xF0,0xF0,0x0F,0x07,0xC0,0xF8,0x1F,0xFF,0x80,
0x3F,0xF0,0x03,0xFF,0xC0,0x3F,0xFF,0x03,0xE0,0x7C,
0x3E,0x01,0xF1,0xE0,0x07,0xB3,0xC0,0x03,0xCF,0x00,
0x3E,0x7C,0x03,0xE3,0xF0,0x3F,0x0F,0xFF,0xF0,0x3F,
0xFF,0x00,0xFF,0xF0,0x00,0xFC,0x00,0x0A,0x40,0x40,
0x30,0x03,0xF8,0x00,0x7F,0xF0,0x07,0xFF,0xC0,0x7F,
0xFF,0x03,0xF0,0x7C,0x3E,0x01,0xE1,0xE0,0x07,0x9F,
0x00,0x3C,0xF0,0x00,0xEA,0xF0,0x00,0xF7,0x80,0x0F,
0x9E,0x00,0x7C,0xF8,0x07,0xE7,0xE0,0x7F,0x1F,0xFF,
0xF8,0x7F,0xFB,0xC1,0xFF,0x9E,0x03,0xF0,0xF0,0x00,
0x07,0xC0,0x00,0x0F,0x1E,0x00,0x78,0xF0,0x07,0x83,
0xC0,0x3C,0x1F,0x07,0xC0,0xFF,0xFE,0x03,0xFF,0xE0,
0x0F,0xFE,0x00,0x1F,0xC0,0x00,0x02,0x2E,0x80,0x19,
0x5F,0xA1,0xA0,0x0A,0xF0,0x02,0x3C,0x9C,0x99,0x5F,
0xA1,0xA0,0x0A,0xF9,0x33,0x99,0xC4,0x0A,0xAA,0x42,
0xB4,0x00,0x00,0x08,0x00,0x01,0xE0,0x00,0x1F,0x80,
0x01,0xFE,0x00,0x3F,0xF0,0x03,0xFE,0x00,0x3F,0xC0,
0x07,0xFC,0x00,0x7F,0x80,0x03,0xF8,0x00,0x0F,0x00,
0x00,0x3F,0x80,0x00,0x7F,0x80,0x00,0x7F,0xC0,0x00,
0x3F,0xC0,0x00,0x3F,0xE0,0x00,0x3F,0xF0,0x00,0x1F,
0xE0,0x00,0x1F,0x80,0x00,0x1E,0x00,0x00,0x08,0x0A,
0x9A,0x44,0xB5,0x5F,0xFF,0xFF,0xB0,0x00,0x00,0x57,
0xFF,0xFF,0xC0,0x0A,0xAA,0x42,0xB4,0x80,0x00,0x03,
0xC0,0x00,0x0F,0xC0,0x00,0x3F,0xC0,0x00,0x7F,0xE0,
0x00,0x3F,0xE0,0x00,0x1F,0xE0,0x00,0x1F,0xF0,0x00,
0x0F,0xF0,0x00,0x0F,0xE0,0x00,0x07,0x80,0x00,0xFE,
0x00,0x0F,0xF0,0x01,0xFF,0x00,0x1F,0xE0,0x03,0xFE,
0x00,0x7F,0xE0,0x03,0xFC,0x00,0x0F,0xC0,0x00,0x3C,
0x00,0x00,0x80,0x00,0x00,0x0A,0x40,0x40,0x30,0x01,
0xFC,0x00,0x7F,0xF8,0x07,0xFF,0xE0,0x7F,0xFF,0x87,
0xF0,0x7E,0x3E,0x01,0xF1,0xE0,0x07,0xDF,0x00,0x1E,
0xF0,0x00,0xF1,0x80,0x07,0x80,0x00,0x3C,0x00,0x03,
0xE0,0x00,0x1E,0x00,0x01,0xF0,0x00,0x3F,0x00,0x03,
0xF0,0x00,0x3F,0x00,0x03,0xF0,0x00,0x3E,0x00,0x01,
0xE0,0x00,0x1F,0x00,0xA0,0x1E,0x00,0x90,0x00,0x00,
0xA0,0x1E,0x00,0x14,0xD2,0x5B,0xDA,0x00,0x00,0xFF,
0xC0,0x00,0x00,0x01,0xFF,0xFF,0x00,0x00,0x01,0xFF,
0xFF,0xF0,0x00,0x01,0xFF,0xFF,0xFE,0x00,0x00,0xFF,
0x80,0x3F,0xE0,0x00,0x7F,0x00,0x01,0xFC,0x00,0x3E,
0x00,0x00,0x1F,0x00,0x1F,0x00,0x00,0x03,0xE0,0x0F,
0x80,0x7C,0x00,0x7C,0x07,0xC0,0x7F,0xC7,0x8F,0x01,
0xE0,0x3F,0xF9,0xE1,0xE0,0xF0,0x1F,0xFF,0xF0,0x38,
0x38,0x0F,0xC3,0xFC,0x0E,0x1E,0x03,0xE0,0x3F,0x01,
0xC7,0x01,0xF0,0x0F,0xC0,0x71,0xC0,0xF8,0x01,0xF0,
0x1C,0x70,0x3C,0x00,0x78,0x07,0x38,0x0F,0x00,0x1E,
0x01,0xCE,0x07,0xC0,0x07,0x80,0x73,0x81,0xE0,0x01,
0xE0,0x1C,0xE0,0x78,0x00,0x70,0x0F,0x38,0x1E,0x00,
0x3C,0x03,0x8E,0x07,0x80,0x0F,0x01,0xE3,0x81,0xE0,
0x03,0xC0,0x70,0xE0,0x78,0x01,0xE0,0x3C,0x38,0x1F,
0x00,0xF8,0x1E,0x0F,0x03,0xC0,0x7E,0x0F,0x81,0xC0,
0xFC,0x3F,0x8F,0xC0,0x70,0x1F,0xFF,0xFF,0xE0,0x1E,
0x07,0xFF,0x7F,0xF0,0x03,0xC0,0xFF,0x8F,0xF0,0x00,
0xF0,0x0F,0x81,0xF0,0x1E,0x1E,0x00,0x00,0x00,0x0F,
0x03,0xE0,0x00,0x00,0x0F,0x80,0xFC,0x00,0x00,0x07,
0xE0,0x1F,0xE0,0x00,0x07,0xE0,0x01,0xFF,0x00,0x1F,
0xF0,0x00,0x3F,0xFF,0xFF,0xF8,0x00,0x03,0xFF,0xFF,
0xF8,0x00,0x00,0x3F,0xFF,0xF8,0x00,0x00,0x00,0xFF,
0xE0,0x00,0x00,0x0E,0xC0,0x00,0x3A,0x00,0x07,0x00,
0x04,0x00,0x07,0xC0,0x00,0x00,0x3F,0x80,0x08,0x00,
0x1D,0xC0,0x00,0x00,0xF7,0x80,0x00,0x03,0x8E,0x00,
0x00,0x1E,0x3C,0x01,0x00,0x0E,0x0E,0x00,0x00,0x78,
0x3C,0x00,0x01,0xC0,0x70,0x08,0x01,0xE0,0x3C,0x00,
0x07,0x00,0x70,0x00,0x3C,0x01,0xE0,0x00,0xE0,0x03,
0x81,0x00,0xFF,0xFF,0xE0,0x07,0xFF,0xFF,0x80,0x1F,
0xFF,0xFF,0x00,0x78,0x00,0x3C,0x20,0x78,0x00,0x0F,
0x12,0x78,0x00,0x03,0xC8,0x78,0x00,0x00,0xF3,0xE0,
0x00,0x03,0xEF,0x00,0x00,0x07,0x80,0x0B,0xC0,0x80,
0x3A,0xFF,0xFF,0x00,0xFF,0xFF,0xC1,0x1F,0xFF,0xFE,
0x1E,0x00,0x3F,0x1E,0x00,0x0F,0x2F,0xC0,0x00,0xF3,
0xC0,0x01,0xE3,0xC0,0x07,0xE3,0xFF,0xFF,0xC4,0x7F,
0xFF,0xF0,0x7F,0xFF,0xF8,0x78,0x00,0x7C,0x8F,0x00,
0x03,0xD7,0xE0,0x00,0x3D,0xE0,0x00,0x7D,0xE0,0x00,
0xF9,0xE0,0x01,0xF9,0xFF,0xFF,0xF1,0xFF,0xFF,0xE1,
0xFF,0xFF,0xC1,0xFF,0xFE,0x00,0x0E,0x40,0x40,0x40,
0x00,0x1F,0xE0,0x00,0x07,0xFF,0xC0,0x00,0xFF,0xFF,
0x80,0x0F,0xFF,0xFE,0x00,0xFE,0x03,0xF8,0x0F,0xC0,
0x07,0xC0,0xF8,0x00,0x1F,0x07,0x80,0x00,0x78,0x7C,
0x00,0x03,0xE3,0xC0,0x00,0x0E,0x1E,0x00,0x00,0x01,
0xF0,0x00,0x00,0x1B,0xE0,0x00,0x00,0x0F,0x00,0x00,
0x00,0x3C,0x00,0x00,0x01,0xE0,0x00,0x03,0xCF,0x00,
0x00,0x3E,0x7C,0x00,0x01,0xE1,0xE0,0x00,0x1F,0x0F,
0x80,0x01,0xF0,0x3F,0x00,0x1F,0x80,0xFE,0x03,0xF8,
0x03,0xFF,0xFF,0x80,0x0F,0xFF,0xF8,0x00,0x3F,0xFF,
0x00,0x00,0x3F,0xE0,0x00,0x0D,0x40,0x80,0x40,0xFF,
0xFF,0x80,0x1F,0xFF,0xFC,0x03,0xFF,0xFF,0xE0,0x7F,
0xFF,0xFE,0x0F,0x00,0x0F,0xE1,0xE0,0x00,0x7C,0x3C,
0x00,0x07,0xC7,0x80,0x00,0x78,0xF0,0x00,0x0F,0xA3,
0xC0,0x00,0x1E,0xDF,0x00,0x00,0x3E,0x7C,0x00,0x00,
0xF8,0xF0,0x00,0x07,0x9E,0x00,0x01,0xF3,0xC0,0x00,
0x3C,0x78,0x00,0x0F,0x8F,0x00,0x03,0xE1,0xE0,0x03,
0xFC,0x3F,0xFF,0xFF,0x07,0xFF,0xFF,0xC0,0xFF,0xFF,
0xE0,0x1F,0xFF,0xE0,0x00,0x0B,0xC0,0x80,0x3B,0x5F,
0xFF,0xFF,0xB7,0xC0,0x00,0x04,0x78,0x00,0x00,0xAF,
0xFF,0xFF,0x9B,0xE0,0x00,0x02,0xBC,0x00,0x00,0x57,
0xFF,0xFF,0xF0,0x0A,0xC0,0x80,0x37,0x5F,0xFF,0xFF,
0xDF,0x00,0x00,0x47,0x80,0x00,0x2B,0xFF,0xFF,0x1B,
0xE0,0x00,0x0D,0xF0,0x00,0x03,0xC0,0x00,0x00,0x0E,
0xC0,0x40,0x44,0x00,0x1F,0xF0,0x00,0x03,0xFF,0xF8,
0x00,0x3F,0xFF,0xF0,0x01,0xFF,0xFF,0xE0,0x0F,0xF0,
0x1F,0xC0,0x7E,0x00,0x1F,0x81,0xF0,0x00,0x1E,0x0F,
0x80,0x00,0x7C,0x3C,0x00,0x00,0xF1,0xE0,0x00,0x03,
0xF0,0xF0,0x00,0x00,0x0A,0xF0,0x00,0x00,0x05,0x78,
0x00,0x7F,0xFD,0xF0,0x00,0x00,0xF8,0x78,0x00,0x00,
0x79,0xF0,0x00,0x01,0xE3,0xE0,0x00,0x07,0x87,0xC0,
0x00,0x3E,0x1F,0x80,0x01,0xF8,0x3F,0xC0,0x3F,0xE0,
0x7F,0xFF,0xFE,0x00,0x7F,0xFF,0xF0,0x00,0x7F,0xFF,
0x00,0x00,0x3F,0xC0,0x00,0x0C,0x40,0x80,0x41,0xBE,
0x00,0x01,0xF9,0xE0,0x00,0x1F,0x5F,0xFF,0xFF,0xFB,
0xE0,0x00,0x1F,0xBE,0x00,0x01,0xEF,0x00,0x00,0xF0,
0x02,0x40,0x80,0x19,0xBF,0xBF,0xBF,0xBF,0x5E,0x08,
0xC0,0x20,0x2D,0xA0,0x00,0xFD,0x00,0x07,0xE8,0x00,
0x3C,0x00,0x0F,0x9F,0x00,0x7B,0xE0,0x1E,0xF8,0x0F,
0x1F,0x07,0xC7,0xFF,0xF0,0xFF,0xF8,0x1F,0xFC,0x01,
0xFC,0x00,0x0D,0x40,0x80,0x3A,0xF0,0x00,0x1F,0x9E,
0x00,0x07,0xE3,0xC0,0x01,0xF8,0x78,0x00,0x7E,0x0F,
0x00,0x1F,0x81,0xE0,0x07,0xE0,0x3C,0x01,0xF8,0x07,
0x80,0x7E,0x00,0xF0,0x1F,0x80,0x1E,0x07,0xE0,0x03,
0xC1,0xF8,0x00,0x78,0x7E,0x00,0x0F,0x1F,0x80,0x01,
0xE7,0xE0,0x00,0x3D,0xFC,0x00,0x07,0xFF,0xC0,0x00,
0xFF,0xFC,0x00,0x1F,0xE7,0xC0,0x03,0xF8,0x7C,0x00,
0x7E,0x07,0x80,0x0F,0x80,0xF8,0x01,0xE0,0x0F,0x80,
0x3C,0x00,0xF8,0x07,0x80,0x0F,0x00,0xF0,0x01,0xF0,
0x1E,0x00,0x1F,0x03,0xC0,0x01,0xF0,0x8F,0x00,0x03,
0xE1,0xE0,0x00,0x3E,0x3C,0x00,0x03,0xE7,0x80,0x00,
0x3E,0x09,0xC0,0x80,0x31,0xBE,0x00,0x03,0x7C,0x00,
0x06,0xF8,0x00,0x0D,0xF0,0x00,0x15,0xFF,0xFF,0xC0,
0x0E,0xC0,0x80,0x4B,0x1F,0xC0,0x00,0x7F,0xAF,0xF0,
0x00,0x7F,0xCF,0xBC,0x00,0x7B,0xEB,0xCF,0x00,0x79,
0xF3,0xE3,0xC0,0x78,0xF7,0x8F,0x83,0xE3,0xE7,0xC3,
0xC1,0xE1,0xF3,0xE0,0xF1,0xE0,0xF7,0x83,0xEF,0x83,
0xE7,0xC0,0xF7,0x81,0xEF,0x01,0xFE,0x07,0xCF,0x80,
0xFE,0x03,0xDE,0x01,0xF0,0x0F,0x0C,0x40,0x80,0x41,
0x1F,0x00,0x01,0xF1,0xF8,0x00,0x1E,0xFE,0x00,0x0F,
0x8F,0xF0,0x00,0xF7,0xFC,0x00,0x7B,0xDF,0x00,0x3D,
0xE7,0x80,0x1E,0xF3,0xE0,0x0F,0x78,0xF0,0x07,0xBC,
0x3C,0x03,0xDE,0x1F,0x01,0xEF,0x07,0x80,0xF7,0x83,
0xE0,0x7B,0xC0,0xF8,0x3D,0xE0,0x3C,0x1E,0xF0,0x1F,
0x0F,0x78,0x07,0x87,0xBC,0x01,0xE3,0xDE,0x00,0xF9,
0xEF,0x00,0x3C,0xF7,0x80,0x1F,0x7B,0xC0,0x07,0xFE,
0x3C,0x00,0x3F,0xDE,0x00,0x0F,0xF1,0xE0,0x00,0x7F,
0x1E,0x00,0x03,0xE0,0x0F,0x40,0x40,0x44,0x00,0x1F,
0xE0,0x00,0x01,0xFF,0xF8,0x00,0x0F,0xFF,0xFC,0x00,
0x3F,0xFF,0xFC,0x00,0xFF,0x03,0xFC,0x03,0xF0,0x00,
0xFC,0x0F,0xC0,0x00,0xF8,0x1F,0x00,0x00,0xF8,0x7C,
0x00,0x00,0xF2,0x1E,0x00,0x00,0x1E,0x7C,0x00,0x00,
0x3D,0xBE,0x00,0x00,0x07,0xBC,0x00,0x00,0x0F,0x7C,
0x00,0x00,0x3F,0x0F,0x00,0x00,0x0F,0x1F,0x00,0x00,
0x3E,0x1F,0x00,0x00,0xF8,0x1F,0x00,0x03,0xE0,0x3F,
0x00,0x0F,0xC0,0x3F,0x80,0x7F,0x00,0x3F,0xFF,0xFC,
0x00,0x3F,0xFF,0xF0,0x00,0x1F,0xFF,0x80,0x00,0x07,
0xF8,0x00,0x0B,0xC0,0x80,0x3A,0xFF,0xFF,0x80,0xFF,
0xFF,0xE0,0xFF,0xFF,0xF0,0xFF,0xFF,0xF8,0xF0,0x00,
0xFC,0xF0,0x00,0x3C,0xF0,0x00,0x3F,0x7E,0x00,0x03,
0xDE,0x00,0x07,0xDE,0x00,0x0F,0x9E,0x00,0x1F,0x9F,
0xFF,0xFF,0x1F,0xFF,0xFE,0x1F,0xFF,0xFC,0x1F,0xFF,
0xE0,0x37,0xC0,0x00,0x06,0x78,0x00,0x00,0x0F,0x44,
0x5F,0x44,0x00,0x1F,0xE0,0x00,0x01,0xFF,0xF0,0x00,
0x0F,0xFF,0xF8,0x00,0x3F,0xFF,0xF8,0x00,0xFE,0x03,
0xF8,0x03,0xF0,0x01,0xF8,0x0F,0xC0,0x01,0xF8,0x1F,
0x00,0x01,0xF0,0x7C,0x00,0x01,0xF2,0x1E,0x00,0x00,
0x3C,0x7C,0x00,0x00,0x7D,0xBE,0x00,0x00,0x0F,0x3C,
0x00,0x00,0x1E,0x7C,0x00,0x00,0x79,0x0F,0x00,0x00,
0x1E,0x1F,0x00,0x70,0x78,0x1F,0x00,0xF9,0xF0,0x3F,
0x01,0xFF,0xC0,0x3F,0x00,0xFF,0x80,0x3F,0x80,0xFE,
0x00,0x3F,0xFF,0xFE,0x00,0x3F,0xFF,0xFE,0x00,0x1F,
0xFF,0xFF,0x00,0x07,0xF8,0x7F,0x00,0x00,0x00,0x3C,
0x00,0x00,0x00,0x18,0x0D,0x40,0x80,0x40,0xFF,0xFF,
0xC0,0x1F,0xFF,0xFE,0x04,0x7F,0xFF,0xFE,0x0F,0x00,
0x07,0xE1,0xE0,0x00,0x3C,0x3C,0x00,0x07,0xCA,0xF0,
0x00,0x0F,0x1E,0x00,0x03,0xE3,0xC0,0x00,0xF8,0x78,
0x00,0x3F,0x0F,0xFF,0xFF,0xC1,0xFF,0xFF,0xF0,0x3F,
0xFF,0xFC,0x07,0xFF,0xFE,0x00,0xF0,0x0F,0x00,0x1E,
0x00,0xF8,0x03,0xC0,0x0F,0x80,0x78,0x00,0xF0,0x0F,
0x00,0x1F,0x01,0xE0,0x01,0xF0,0x3C,0x00,0x1E,0x07,
0x80,0x03,0xE0,0xF0,0x00,0x3E,0x1E,0x00,0x03,0xC3,
0xC0,0x00,0x7C,0x78,0x00,0x07,0x8F,0x00,0x00,0x79,
0xE0,0x00,0x0F,0x80,0x0C,0xC0,0x40,0x3A,0x00,0xFF,
0x00,0x01,0xFF,0xF8,0x00,0xFF,0xFF,0x80,0x7F,0xFF,
0xF0,0x3F,0x80,0xFE,0x0F,0x80,0x0F,0x87,0xC0,0x01,
0xF4,0x3C,0x00,0x07,0x8F,0x00,0x00,0x03,0xE0,0x00,
0x00,0x7C,0x00,0x00,0x1F,0xC0,0x00,0x03,0xFF,0x00,
0x00,0x7F,0xFC,0x00,0x07,0xFF,0xE0,0x00,0x3F,0xFE,
0x00,0x00,0xFF,0xC0,0x00,0x03,0xF8,0x00,0x00,0x3E,
0x00,0x00,0x07,0xE3,0xC0,0x00,0x1E,0xF8,0x00,0x07,
0x9E,0x00,0x01,0xE7,0xC0,0x00,0xF9,0xF8,0x00,0x7C,
0x3F,0x80,0x7F,0x07,0xFF,0xFF,0x80,0xFF,0xFF,0xC0,
0x0F,0xFF,0xC0,0x00,0x7F,0x80,0x00,0x0C,0x40,0x20,
0x35,0x5F,0xFF,0xFF,0xFA,0x00,0x78,0x01,0xA0,0x07,
0x80,0x1A,0x00,0x78,0x01,0xA0,0x07,0x80,0x00,0x0C,
0x40,0x80,0x41,0xBE,0x00,0x01,0xFB,0xE0,0x00,0x1F,
0xBE,0x00,0x01,0xF1,0xE0,0x00,0x1E,0xF8,0x00,0x1F,
0x3C,0x00,0x0F,0x1F,0x00,0x0F,0x8F,0xC0,0x0F,0xC3,
0xF0,0x1F,0xC0,0xFF,0xFF,0xC0,0x3F,0xFF,0xC0,0x0F,
0xFF,0xC0,0x00,0xFF,0x00,0x0E,0xC0,0x00,0x3A,0xF0,
0x00,0x00,0x7B,0xE0,0x00,0x03,0xF0,0xF0,0x00,0x01,
0xE3,0xE0,0x00,0x0F,0xA0,0xF0,0x00,0x07,0x83,0xE0,
0x00,0x3E,0x07,0x80,0x00,0xF0,0x1F,0x00,0x07,0xC4,
0x07,0x80,0x03,0xC0,0x1F,0x00,0x1F,0x08,0x07,0x80,
0x0F,0x00,0x1F,0x00,0x7C,0x00,0x3C,0x01,0xE0,0x00,
0xF8,0x0F,0x81,0x00,0x3C,0x07,0x80,0x00,0xF8,0x3E,
0x02,0x00,0x3C,0x1E,0x00,0x00,0xF8,0xF8,0x00,0x01,
0xE3,0xC0,0x00,0x07,0xDF,0x00,0x40,0x01,0xEF,0x00,
0x00,0x07,0xFC,0x00,0x90,0x01,0xFC,0x00,0x00,0x15,
0xC0,0x20,0x59,0x1E,0x00,0x07,0xF0,0x00,0x3C,0xF0,
0x00,0x7F,0x00,0x07,0x8F,0x00,0x0F,0xF0,0x00,0x7A,
0x1E,0x00,0x1E,0xF0,0x00,0xF0,0xF0,0x01,0xEF,0x00,
0x1E,0x41,0xE0,0x07,0x8F,0x00,0x3C,0x0E,0x00,0x78,
0xF0,0x03,0xC0,0xF0,0x0F,0x8F,0x80,0x78,0x81,0xE0,
0x1E,0x0F,0x00,0xF0,0x0E,0x01,0xE0,0xF0,0x0E,0x00,
0xE0,0x3C,0x07,0x80,0xE1,0x01,0xE0,0x78,0x0F,0x03,
0xC0,0x0E,0x0F,0x80,0x78,0x38,0x00,0xE0,0xF0,0x07,
0x83,0x82,0x01,0xE1,0xE0,0x0F,0x0F,0x04,0x01,0xC7,
0x80,0x0F,0x1C,0x00,0x1E,0x78,0x00,0xF3,0xC0,0x01,
0xEF,0x00,0x07,0xBC,0x08,0x01,0xDE,0x00,0x0F,0x70,
0x00,0x1F,0xE0,0x00,0xFF,0x01,0x20,0x1F,0x80,0x00,
0xFC,0x00,0x01,0xF0,0x00,0x07,0xC0,0x00,0x0E,0xC0,
0x00,0x3A,0x3E,0x00,0x03,0xE0,0x7C,0x00,0x1F,0x00,
0xF0,0x00,0x78,0x03,0xE0,0x03,0xE0,0x07,0xC0,0x1F,
0x00,0x0F,0x00,0xF8,0x00,0x1E,0x03,0xC0,0x00,0x7C,
0x1F,0x00,0x00,0xF8,0xF8,0x00,0x01,0xE3,0xC0,0x00,
0x07,0xDF,0x00,0x00,0x0F,0xF8,0x01,0x00,0x03,0xF8,
0x00,0x00,0x07,0xC0,0x00,0x00,0x3F,0x00,0x00,0x00,
0xFE,0x00,0x00,0x07,0xFC,0x00,0x00,0x3E,0xF8,0x00,
0x00,0xF1,0xE0,0x00,0x07,0xC7,0xC0,0x00,0x3E,0x0F,
0x80,0x00,0xF0,0x1E,0x00,0x07,0xC0,0x7C,0x00,0x3E,
0x00,0xF8,0x00,0xF0,0x01,0xE0,0x07,0xC0,0x03,0xC0,
0x3E,0x00,0x0F,0x81,0xF0,0x00,0x1F,0x07,0x80,0x00,
0x3C,0x3E,0x00,0x00,0xF9,0xF0,0x00,0x01,0xF0,0x0E,
0x40,0x00,0x38,0xF8,0x00,0x01,0xF3,0xE0,0x00,0x1F,
0x0F,0x00,0x00,0xF0,0x7C,0x00,0x0F,0x81,0xE0,0x00,
0xF8,0x07,0x80,0x07,0x80,0x3E,0x00,0x7C,0x00,0xF0,
0x03,0xC0,0x03,0xC0,0x3C,0x00,0x1F,0x03,0xE0,0x00,
0x78,0x1E,0x00,0x03,0xE1,0xF0,0x00,0x0F,0x9F,0x00,
0x00,0x3C,0xF0,0x00,0x01,0xFF,0x80,0x00,0x07,0xF8,
0x01,0x00,0x03,0xF0,0x01,0xA0,0x01,0xE0,0x01,0xA0,
0x01,0xE0,0x00,0x0C,0xC0,0x20,0x37,0x47,0xFF,0xFF,
0xE0,0x00,0x00,0xF8,0x00,0x00,0x7C,0x00,0x00,0x3E,
0x00,0x00,0x1F,0x00,0x00,0x07,0x80,0x00,0x03,0xE0,
0x00,0x01,0xF0,0x00,0x00,0xF8,0x00,0x00,0x7C,0x00,
0x00,0x1E,0x00,0x00,0x0F,0x80,0x00,0x07,0xC0,0x00,
0x03,0xE0,0x00,0x01,0xF0,0x00,0x80,0x1F,0x00,0x00,
0x0F,0x80,0x00,0x07,0xC0,0x00,0x03,0xE0,0x00,0x10,
0x3E,0x00,0x00,0x1F,0x00,0x00,0x0F,0x80,0x00,0x07,
0xC0,0x00,0x02,0xBF,0xFF,0xFF,0xE0,0x04,0x52,0x7B,
0x99,0x5F,0xFB,0xE1,0xBE,0x1B,0xE1,0xBE,0x17,0xE1,
0x5F,0xE0,0x06,0x40,0x20,0x19,0x1C,0x01,0x2E,0x00,
0x78,0x09,0x38,0x09,0x1C,0x00,0xF0,0x48,0x70,0x50,
0x38,0x48,0x1C,0x00,0xF2,0x40,0x72,0x40,0x38,0x01,
0xE0,0x07,0x04,0x52,0x3B,0x99,0x5F,0xFA,0x1F,0xA1,
0xFA,0x1F,0xA1,0xF6,0x1F,0x5F,0xE0,0x08,0xA2,0x27,
0xA6,0x01,0xC0,0x48,0x1F,0x02,0x01,0xDC,0x00,0xF7,
0x80,0x38,0xE0,0x1E,0x38,0x07,0x8F,0x01,0xC1,0xC4,
0x1E,0x0F,0x25,0xE0,0x3C,0xF0,0x07,0x80,0x0C,0x89,
0xFB,0xB1,0x5F,0xFF,0xFF,0xF0,0x04,0x0C,0x4D,0x1E,
0xF8,0x3E,0x0F,0x03,0xC0,0xE0,0x38,0x0A,0x30,0x40,
0x30,0x01,0xFC,0x00,0x7F,0xFC,0x07,0xFF,0xF0,0x7F,
0xFF,0x83,0xE0,0x7E,0x3E,0x01,0xF1,0xF0,0x07,0x83,
0x00,0x3C,0x00,0x01,0xE0,0x00,0x3F,0x00,0x7F,0xF8,
0x1F,0xFF,0xC3,0xFF,0xFE,0x3F,0xFC,0xF1,0xF8,0x07,
0x9F,0x00,0x3C,0xF0,0x01,0xE7,0x80,0x1F,0x3C,0x01,
0xF9,0xF8,0x3F,0xC7,0xFF,0xFE,0x3F,0xFE,0xF0,0xFF,
0xE7,0xC1,0xFC,0x1E,0x0A,0x40,0x60,0x33,0xBE,0x00,
0x00,0xF0,0x00,0x07,0x87,0xC0,0x3C,0xFF,0x81,0xEF,
0xFF,0x0F,0xFF,0xFC,0x7F,0x87,0xE3,0xF0,0x0F,0xA3,
0xE0,0x07,0xB7,0xC0,0x03,0xDE,0x00,0x1F,0x1F,0x00,
0x3C,0xFC,0x03,0xE7,0xF8,0x7E,0x3F,0xFF,0xE1,0xEF,
0xFE,0x0F,0x3F,0xE0,0x78,0x7C,0x00,0x0A,0x30,0x40,
0x2C,0x01,0xF8,0x00,0x3F,0xF8,0x07,0xFF,0xE0,0x7F,
0xFF,0x83,0xF0,0xFC,0x3E,0x01,0xF1,0xE0,0x0F,0x8F,
0x00,0x31,0xBE,0x00,0x00,0xF0,0x00,0xC7,0xC0,0x07,
0x9E,0x00,0x7C,0xF8,0x07,0xC3,0xF0,0x7E,0x1F,0xFF,
0xE0,0x7F,0xFE,0x00,0xFF,0xE0,0x01,0xFC,0x00,0x0A,
0x40,0x40,0x31,0xA0,0x00,0x1E,0x00,0x00,0xF0,0x0F,
0x87,0x81,0xFF,0x3C,0x3F,0xFD,0xE3,0xFF,0xFF,0x1F,
0x87,0xF9,0xF0,0x0F,0xE1,0xE0,0x07,0xF7,0xC0,0x03,
0xDE,0x00,0x1F,0x0F,0x00,0x3E,0x7C,0x03,0xF1,0xF8,
0x7F,0x87,0xFF,0xFC,0x3F,0xFD,0xE0,0x7F,0xCF,0x00,
0xF8,0x78,0x0A,0x30,0x40,0x30,0x01,0xF8,0x00,0x3F,
0xF0,0x07,0xFF,0xE0,0x3F,0xFF,0x83,0xE0,0x7C,0x3E,
0x01,0xF1,0xE0,0x07,0x8E,0x00,0x1C,0xF0,0x00,0xFA,
0xFF,0xFF,0xF9,0xF0,0x00,0x07,0xC0,0x06,0x1E,0x00,
0x7C,0xF8,0x07,0xC3,0xF0,0x7E,0x1F,0xFF,0xE0,0x7F,
0xFE,0x00,0xFF,0xE0,0x01,0xFC,0x00,0x06,0xC0,0x20,
0x1A,0x03,0xF8,0x1F,0xE0,0xFF,0x87,0xFE,0x1F,0x05,
0x0F,0x02,0xBF,0xF9,0xA3,0xC0,0xD1,0xE0,0x58,0xF0,
0x00,0x0A,0x42,0x5B,0xB2,0x03,0xF0,0x00,0x3F,0xE7,
0x87,0xFF,0xFC,0x7F,0xFF,0xE3,0xF0,0xFF,0x3E,0x01,
0xFC,0x3C,0x00,0xFE,0xF8,0x00,0x7B,0xC0,0x03,0xE1,
0xE0,0x07,0xCF,0x80,0x7E,0x3F,0x0F,0xF8,0x1F,0xFF,
0xF0,0x7F,0xE7,0x80,0xFE,0x3C,0x00,0x01,0xE6,0x00,
0x0F,0x3C,0x00,0xF1,0xF0,0x0F,0x87,0xC0,0xFC,0x3F,
0xFF,0xC0,0xFF,0xFC,0x03,0xFF,0xC0,0x07,0xF8,0x00,
0x09,0x40,0x60,0x31,0xBE,0x00,0x03,0xC0,0x00,0x78,
0x7C,0x0F,0x3F,0xE1,0xEF,0xFE,0x3F,0xFF,0xE7,0xF0,
0x7C,0xFC,0x07,0xE3,0xE0,0x0F,0xDF,0x00,0x3F,0x7C,
0x00,0xF8,0xF0,0x03,0xC0,0x02,0x40,0x60,0x15,0x5F,
0x61,0xBF,0xBF,0xBF,0x1E,0x04,0xD3,0xDB,0x95,0x40,
0xFB,0x00,0x68,0x3F,0x41,0xFA,0x0F,0xC0,0x78,0x3E,
0x7F,0x3F,0xCF,0xE3,0xF0,0x09,0xC0,0x60,0x2D,0xBE,
0x00,0x02,0x3C,0x00,0x03,0xC0,0x3E,0x3C,0x07,0xC3,
0xC0,0xF8,0x3C,0x1F,0x03,0xC3,0xE0,0x3C,0x7C,0x03,
0xCF,0x80,0x3D,0xF0,0x03,0xFE,0x00,0x3F,0xF0,0x03,
0xFF,0x80,0x3F,0x78,0x03,0xE7,0xC0,0x3C,0x3E,0x03,
0xC1,0xE0,0x3C,0x1F,0x03,0xC0,0xF8,0x3C,0x07,0x83,
0xC0,0x7C,0x3C,0x03,0xE3,0xC0,0x1E,0x3C,0x01,0xF3,
0xC0,0x0F,0x80,0x02,0x40,0x60,0x15,0xBF,0xBF,0xBF,
0xBF,0x5E,0x10,0x30,0x60,0x4C,0x00,0xFC,0x03,0xF0,
0x79,0xFF,0x07,0xFE,0x3D,0xFF,0xC7,0xFF,0x9E,0xFF,
0xF7,0xFF,0xCF,0xE0,0xFF,0x83,0xF7,0xE0,0x3F,0x80,
0xFB,0xE0,0x0F,0x80,0x3D,0xF0,0x07,0x80,0x1F,0xBE,
0x00,0x78,0x01,0xFB,0xE0,0x07,0x80,0x1F,0x1E,0x00,
0x78,0x01,0xE0,0x09,0x30,0x60,0x30,0x00,0xFC,0x1E,
0x7F,0xC3,0xDF,0xFC,0x7F,0xFF,0xCF,0xE0,0xF9,0xF8,
0x0F,0xC7,0xC0,0x1F,0xBE,0x00,0x7E,0xF8,0x01,0xF1,
0xE0,0x07,0x80,0x0A,0x30,0x40,0x30,0x01,0xF8,0x00,
0x3F,0xF0,0x07,0xFF,0xE0,0x7F,0xFF,0x83,0xF0,0xFC,
0x3E,0x01,0xF1,0xE0,0x07,0x9F,0x00,0x3D,0xBE,0x00,
0x1E,0xF0,0x00,0xF7,0xC0,0x0F,0x9E,0x00,0x78,0xF8,
0x07,0xC3,0xF0,0xFC,0x1F,0xFF,0xE0,0x7F,0xFE,0x00,
0xFF,0xC0,0x01,0xF8,0x00,0x0A,0x42,0x7B,0xB2,0x00,
0xF8,0x07,0x9F,0xF8,0x3D,0xFF,0xE1,0xEF,0xFF,0x8F,
0xF0,0xFC,0x7E,0x01,0xF3,0xF0,0x07,0x9F,0x00,0x3C,
0xF8,0x00,0xFD,0xF0,0x00,0xF8,0xF8,0x01,0xE7,0xE0,
0x1F,0x3F,0xC3,0xF1,0xFF,0xFF,0x0F,0x7F,0xF0,0x79,
0xFF,0x03,0xC7,0xE0,0x37,0xC0,0x00,0x23,0xC0,0x00,
0x00,0x0A,0x42,0x5B,0xB2,0x01,0xF0,0x00,0x7F,0xE7,
0x87,0xFF,0xBC,0x7F,0xFD,0xE3,0xF0,0xFF,0x3E,0x01,
0xF9,0xE0,0x0F,0xCF,0x00,0x3E,0xF0,0x01,0xFD,0xF0,
0x00,0xF8,0x78,0x01,0xF3,0xE0,0x1F,0x8F,0xC3,0xFC,
0x3F,0xFF,0xE0,0xFF,0xEF,0x03,0xFE,0x78,0x07,0xC3,
0xF4,0x00,0x03,0xE0,0x00,0x03,0xC0,0x06,0xB0,0x60,
0x1E,0x03,0xE3,0x9F,0xEE,0xFF,0xBF,0xFC,0xFE,0x34,
0x7C,0x03,0x7C,0x01,0xBE,0x00,0x9F,0x00,0x00,0x09,
0x30,0x40,0x2C,0x03,0xF0,0x01,0xFF,0x80,0x7F,0xFC,
0x1F,0xFF,0x87,0xC1,0xF8,0xF0,0x1F,0x1E,0x01,0x83,
0xC0,0x00,0x7E,0x00,0x07,0xF8,0x00,0xFF,0xE0,0x0F,
0xFF,0x00,0x7F,0xF0,0x03,0xFF,0x00,0x07,0xF0,0x00,
0x3E,0x30,0x03,0xDE,0x00,0x7B,0xE0,0x1F,0x3E,0x07,
0xC7,0xFF,0xF8,0x7F,0xFE,0x07,0xFF,0x80,0x3F,0xC0,
0x05,0xBE,0x20,0x18,0x02,0x00,0xE1,0x83,0xC2,0xBF,
0xF6,0x8F,0x0D,0x1E,0x01,0xE1,0x03,0xF8,0x1F,0xC0,
0xFC,0x09,0x2E,0x60,0x31,0xBE,0x00,0x7E,0xF8,0x01,
0xF1,0xE0,0x07,0xBC,0x01,0xF7,0xC0,0x7E,0xFC,0x1F,
0xE1,0xFF,0xEF,0x1F,0xF9,0xE0,0xFC,0x3C,0x0A,0xAE,
0x20,0x2E,0xF0,0x00,0x7C,0xBC,0x00,0x7A,0x4F,0x00,
0x79,0x03,0xC0,0x78,0x90,0xF0,0x78,0x48,0x3C,0x78,
0x24,0x0F,0x78,0x10,0x03,0xF8,0x09,0x00,0xF8,0x00,
0x10,0xAE,0x00,0x43,0x1E,0x00,0x7C,0x00,0xF7,0x80,
0x1F,0x00,0x7E,0x1E,0x01,0xFC,0x03,0xC7,0x80,0x77,
0x01,0xF0,0xF0,0x1D,0xE0,0x78,0x3C,0x0F,0x78,0x1E,
0x07,0x83,0xDE,0x0F,0x81,0xE0,0xE3,0x83,0xC0,0x78,
0x78,0xF0,0xF1,0x01,0xE3,0xC7,0x8F,0x00,0x78,0xE0,
0xE3,0xC0,0x0E,0x78,0x3D,0xE0,0x03,0xDE,0x0F,0x78,
0x00,0xF7,0x03,0xDE,0x00,0x1D,0xC0,0x77,0x02,0x00,
0xFE,0x03,0xF8,0x12,0x03,0xE0,0x0F,0x80,0x0B,0x2E,
0x00,0x2C,0x7C,0x00,0x78,0x7C,0x01,0xF0,0x7C,0x07,
0xC0,0xF8,0x1F,0x00,0xF8,0x3C,0x00,0xF8,0xF8,0x00,
0xF3,0xE0,0x01,0xFF,0x80,0x01,0xFE,0x00,0x01,0xFC,
0x04,0x00,0x7E,0x00,0x00,0xFE,0x00,0x03,0xFC,0x00,
0x0F,0xFC,0x00,0x1E,0x7C,0x00,0x7C,0x78,0x01,0xF0,
0xF8,0x07,0xC0,0xF8,0x0F,0x00,0xF8,0x3E,0x00,0xF0,
0xF8,0x01,0xF3,0xE0,0x01,0xF0,0x0A,0xC0,0x1B,0xAA,
0xF0,0x00,0x79,0xE0,0x03,0xE7,0x80,0x0F,0x1F,0x00,
0x3C,0x3C,0x01,0xF0,0xF0,0x07,0x81,0xE0,0x1E,0x07,
0x80,0xF8,0x1F,0x03,0xC0,0x3C,0x0F,0x00,0xF0,0x7C,
0x40,0x3C,0x3C,0x00,0xF9,0xF0,0x01,0xE7,0x80,0x07,
0xDE,0x00,0x0F,0x70,0x20,0x07,0xF8,0x10,0x01,0xF8,
0x00,0x03,0xE0,0x20,0x01,0xE0,0x00,0x0F,0x80,0x00,
0x3C,0x00,0x01,0xF0,0x00,0x0F,0x80,0x03,0xFE,0x00,
0x0F,0xF0,0x00,0x1F,0x80,0x00,0x7C,0x00,0x00,0x0A,
0x2E,0x20,0x2D,0x4F,0xFF,0xFC,0x00,0x07,0xC0,0x00,
0x7C,0x00,0x07,0xC0,0x00,0x7C,0x00,0x07,0xE0,0x00,
0x3E,0x00,0x03,0xE0,0x00,0x3E,0x00,0x03,0xE0,0x00,
0x3E,0x00,0x03,0xE0,0x00,0x3E,0x00,0x03,0xF0,0x00,
0x1F,0x00,0x01,0xF0,0x00,0x2B,0xFF,0xFF,0xC0,0x06,
0x52,0x3B,0x9E,0x01,0xF0,0x1F,0x81,0xFC,0x1F,0xE0,
0xF8,0xD0,0xF0,0xA0,0xF0,0x0F,0x00,0xF8,0x1F,0x81,
0x1E,0x00,0xFC,0x01,0xF0,0x40,0xF0,0x68,0x78,0x50,
0x78,0x03,0xE2,0x01,0xFC,0x07,0xE0,0x1F,0x01,0xD2,
0x9B,0x97,0xBF,0x7E,0xFD,0xFB,0xF3,0x80,0x06,0x52,
0x5B,0x9E,0xF8,0x07,0xE0,0x47,0xF0,0x07,0xC3,0x43,
0xC2,0x83,0xC0,0x0F,0x00,0x7C,0x01,0xFC,0x00,0x78,
0x0F,0xC0,0xF8,0x07,0x80,0x7C,0x68,0x78,0x50,0x78,
0x07,0xC2,0x3F,0x81,0xF8,0x0F,0x80,0x0B,0x10,0x45,
0xB4,0x0F,0x80,0x00,0x7F,0xC0,0x09,0xFF,0xE0,0x37,
0xFF,0xE1,0xEF,0x0F,0xFF,0xD8,0x07,0xFF,0x20,0x07,
0xFC,0x00,0x03,0xE0,};
/* font data size: 4974 bytes */

static const unsigned char font_tgx_Arial_32_index[] = {
0x00,0x00,0x01,0x00,0x20,0x01,
0xC0,0x24,0x82,0x8C,0x25,0x61,0x95,0x0C,0xE0,0x71,
0xC3,0xE4,0x20,0xB1,0x10,0x08,0xA4,0x45,0xE2,0x34,
0x12,0x90,0xA2,0x05,0x46,0x2F,0x21,0xA3,0x0E,0x18,
0x78,0x64,0x15,0x22,0x09,0x21,0x49,0xA8,0x4D,0xD2,
0x74,0x94,0x9C,0xA6,0xA5,0x73,0x2D,0xB9,0xA4,0xCD,
0xE2,0x73,0x63,0xCC,0x9F,0xA5,0x00,0xA8,0x1F,0x43,
0xFA,0x26,0x11,0x42,0x8C,0x24,0x97,0xA5,0x09,0x2F,
0x49,0xD2,0x51,0xA2,0x9B,0x15,0xAC,0xB3,0xA5,0xD0,
0xAE,0xDD,0x7C,0xAC,0x43,0x66,0x23,0x4F,0x5B,0x0E,
0xDD,0xB6,0xF5,0x38,0x21,0xC2,0xEE,0x36,0x71,0xF3,
0x92,0x5D,0x18,0xEC,0x17,0x7A,0xBC,0xA9,0xEC,0x2F,
0x79,0x7D,0xF3,0xF8,0x5F,0xD6,0xFF,0xF8,0x21,0xC1,
0x32,0x0F,0xF0,0x9D,0x86,0x8C,0x42,0x62,0x83,0x15,
0x78,0xCA,0x46,0xA6,0x38,0x91,0xE4,0x91,0x94,0x9D,
0xA5,0x93,0x2F,0xB9,0x91,0x4C,0xB2,0x6A,0x60,
};
/* font index size: 155 bytes */

const ILI9341_t3_font_t font_tgx_Arial_32 = {
	font_tgx_Arial_32_index,
	0,
	font_tgx_Arial_32_data,
	1,
	0,
	32,
	126,
	0,
	0,
	13,
	6,
	6,
	4,
	6,
	6,
	48,
	32
};



static const unsigned char font_tgx_Arial_40_data[] = {
0x00,0x00,0x00,0x10,0x02,0xD0,0xC0,0x11,0xDF,0xEF,
0xF3,0xFA,0xEA,0x75,0x02,0xFE,0x07,0x9C,0x46,0x94,
0xDF,0x83,0xF3,0xF0,0x7E,0x9C,0x07,0x00,0x0E,0xD0,
0x20,0x1F,0x80,0x03,0xE0,0x3E,0x00,0x1F,0x81,0xF9,
0x40,0x0F,0x80,0xF8,0x00,0x7E,0x07,0xE2,0x40,0x3E,
0x03,0xE1,0x7F,0xFF,0xFF,0xFF,0x00,0xF8,0x0F,0x80,
0x07,0xE0,0x7E,0x0A,0x03,0xE0,0x3E,0x00,0x1F,0x81,
0xF8,0x10,0x0F,0x80,0xF8,0x0B,0xFF,0xFF,0xFF,0xFC,
0x07,0xC0,0x7C,0x00,0x3F,0x03,0xF0,0x0A,0x1F,0x01,
0xF0,0x00,0xFC,0x0F,0xC0,0x10,0x7C,0x07,0xC0,0x00,
0x0D,0xDC,0x5E,0xDF,0x80,0x00,0xE0,0x00,0x00,0x7F,
0xC0,0x00,0x3F,0xFF,0x00,0x07,0xFF,0xFC,0x01,0xFF,
0xFF,0xE0,0x1F,0xFF,0xFF,0x03,0xFC,0xE7,0xF0,0x3F,
0x0E,0x1F,0x87,0xE0,0xE0,0xF8,0x7C,0x0E,0x0F,0xC7,
0xC0,0xE0,0x7C,0x7C,0x0E,0x07,0x07,0xC0,0xE0,0x00,
0x7E,0x0E,0x00,0x03,0xF0,0xE0,0x00,0x3F,0xCE,0x00,
0x01,0xFF,0xE0,0x00,0x0F,0xFF,0x00,0x00,0x7F,0xFF,
0x00,0x01,0xFF,0xFC,0x00,0x07,0xFF,0xE0,0x00,0x0F,
0xFF,0x00,0x00,0xEF,0xF8,0x00,0x0E,0x3F,0xC0,0x00,
0xE0,0xFC,0x00,0x0E,0x07,0xE0,0x00,0xE0,0x3E,0x38,
0x0E,0x03,0xEF,0x80,0xE0,0x3F,0x1F,0x81,0xC0,0x7C,
0xF8,0x1C,0x0F,0xCF,0xC1,0xC1,0xF8,0xFE,0x1C,0x3F,
0x87,0xF9,0xCF,0xF0,0x3F,0xFF,0xFF,0x01,0xFF,0xFF,
0xE0,0x0F,0xFF,0xFC,0x00,0x7F,0xFF,0x00,0x00,0xFF,
0x80,0x2C,0x00,0x38,0x00,0x00,0x16,0x50,0x60,0x32,
0x03,0xF0,0x00,0x00,0xF0,0x00,0x3F,0xE0,0x00,0x0F,
0x80,0x03,0xFF,0x80,0x00,0x78,0x00,0x3E,0x3E,0x00,
0x07,0xC0,0x03,0xE0,0xF8,0x00,0x3C,0x00,0x1E,0x03,
0xC0,0x03,0xE0,0x00,0xE0,0x1E,0x00,0x1E,0x00,0x0F,
0x00,0x78,0x01,0xE0,0x00,0x78,0x03,0xC0,0x1F,0x00,
0x03,0xC0,0x1E,0x00,0xF0,0x00,0x1E,0x00,0xF0,0x0F,
0x80,0x00,0xF0,0x07,0x80,0x78,0x00,0x07,0x80,0x3C,
0x07,0xC0,0x00,0x3C,0x01,0xE0,0x3C,0x00,0x01,0xE0,
0x0F,0x03,0xE0,0x00,0x07,0x00,0xF0,0x3E,0x00,0x00,
0x3C,0x07,0x81,0xE0,0x00,0x01,0xE0,0x7C,0x1F,0x00,
0x00,0x07,0xC7,0xC0,0xF0,0x1F,0x80,0x1F,0xFC,0x0F,
0x81,0xFF,0x00,0x7F,0xC0,0x78,0x1F,0xFC,0x00,0xF8,
0x07,0xC1,0xF1,0xF0,0x00,0x00,0x7C,0x1E,0x07,0xC0,
0x00,0x03,0xC0,0xF0,0x1E,0x00,0x00,0x3E,0x07,0x00,
0xF0,0x00,0x01,0xE0,0x78,0x03,0xC0,0x00,0x1F,0x03,
0xC0,0x1E,0x00,0x00,0xF0,0x1E,0x00,0xF0,0x00,0x0F,
0x80,0xF0,0x07,0x80,0x00,0xF8,0x07,0x80,0x3C,0x00,
0x07,0x80,0x3C,0x01,0xE0,0x00,0x7C,0x01,0xE0,0x0F,
0x00,0x03,0xC0,0x0F,0x00,0x78,0x00,0x3E,0x00,0x38,
0x07,0x80,0x01,0xE0,0x01,0xE0,0x3C,0x00,0x1F,0x00,
0x0F,0x03,0xE0,0x01,0xF0,0x00,0x3E,0x3E,0x00,0x0F,
0x00,0x00,0xFF,0xE0,0x00,0xF8,0x00,0x03,0xFE,0x00,
0x07,0x80,0x00,0x07,0xC0,0x10,0xD0,0x60,0x25,0x00,
0x0F,0xE0,0x00,0x00,0x0F,0xFE,0x00,0x00,0x07,0xFF,
0xC0,0x00,0x03,0xFF,0xF8,0x00,0x01,0xFF,0xFF,0x00,
0x00,0x7E,0x0F,0xC0,0x00,0x3F,0x01,0xF8,0x02,0x81,
0xF0,0x07,0xC0,0x00,0x3E,0x03,0xE0,0x00,0x0F,0xC1,
0xF8,0x00,0x03,0xF0,0xFC,0x00,0x00,0x7E,0xFE,0x00,
0x00,0x0F,0xFF,0x00,0x00,0x01,0xFF,0x00,0x00,0x00,
0xFF,0x00,0x00,0x00,0xFF,0xC0,0x00,0x00,0x7F,0xF8,
0x00,0x00,0x3F,0xBF,0x00,0x00,0x1F,0x87,0xE0,0x20,
0x0F,0xC1,0xFC,0x0F,0x87,0xE0,0x3F,0x07,0xE1,0xF0,
0x07,0xE1,0xF0,0xFC,0x00,0xFC,0xFC,0x3E,0x00,0x1F,
0xFF,0x0F,0x80,0x07,0xFF,0x83,0xE0,0x00,0xFF,0xE0,
0xF8,0x00,0x1F,0xF0,0x47,0xE0,0x00,0x7F,0x00,0xFC,
0x00,0x3F,0xE0,0x3F,0x80,0x1F,0xFC,0x07,0xF8,0x3F,
0xFF,0x81,0xFF,0xFF,0xF7,0xF8,0x3F,0xFF,0xF8,0xFF,
0x03,0xFF,0xFC,0x1F,0x80,0x7F,0xFC,0x03,0xC0,0x03,
0xF8,0x00,0x60,0x02,0x9C,0x66,0x8B,0xDF,0xCF,0xE9,
0xC0,0x07,0x66,0x7D,0x53,0x00,0x1E,0x00,0x78,0x01,
0xE0,0x07,0xC0,0x0F,0x00,0x3E,0x00,0xF8,0x01,0xE0,
0x07,0xC0,0x0F,0x02,0x07,0xC0,0x93,0xE0,0x29,0xF0,
0x0D,0xF8,0x02,0xFE,0x00,0x3C,0x01,0x4F,0x80,0x41,
0xF0,0x01,0xE0,0x20,0x7C,0x08,0x0F,0x80,0x0F,0x00,
0x1F,0x00,0x1F,0x00,0x1E,0x00,0x3E,0x00,0x3C,0x00,
0x3C,0x00,0x3C,0x07,0x66,0x5D,0x53,0x78,0x00,0x78,
0x00,0x78,0x00,0xF8,0x00,0xF0,0x01,0xF0,0x01,0xE0,
0x01,0xE0,0x03,0xE0,0x03,0xC2,0x00,0xF8,0x00,0xF1,
0x00,0x3E,0x58,0x07,0xDA,0x00,0xFD,0x00,0x3F,0x60,
0x1F,0x40,0x0F,0x80,0x1E,0x20,0x0F,0x88,0x07,0xC0,
0x1F,0x00,0x3C,0x00,0xF8,0x01,0xE0,0x07,0xC0,0x0F,
0x00,0x3C,0x00,0xF0,0x00,0x09,0x22,0x45,0xD6,0xA0,
0x1E,0x00,0x83,0xC1,0x1E,0x79,0xE7,0xFE,0xFE,0xFF,
0xFF,0xC7,0xFF,0xE0,0x07,0xC0,0x01,0xF8,0x00,0x7F,
0x80,0x1E,0x78,0x07,0xCF,0x81,0xF0,0xF8,0x1C,0x0E,
0x00,0x81,0x00,0x0D,0xB6,0x61,0xA1,0xD0,0x01,0xF0,
0x01,0x40,0x03,0xE0,0x02,0xFF,0xFF,0xFF,0xFE,0x80,
0x0F,0x80,0x0A,0x00,0x1F,0x00,0x00,0x02,0x9A,0xBE,
0x10,0xBF,0xD1,0xC6,0x39,0xC2,0x00,0x08,0x0A,0x23,
0x13,0xBF,0xFF,0xF0,0x02,0x8A,0xA0,0x10,0xBF,0x80,
0x08,0x50,0x00,0x10,0x80,0x00,0xF9,0x00,0x1E,0x90,
0x03,0xC0,0x03,0xE4,0x80,0x3C,0x48,0x07,0x84,0x80,
0xF0,0x00,0xF8,0x24,0x0F,0x02,0x41,0xE0,0x24,0x3C,
0x00,0x3E,0x01,0x23,0xC0,0x12,0x78,0x01,0x2F,0x00,
0x0F,0x80,0x07,0x80,0x00,0x0C,0xCE,0x60,0x1F,0x00,
0x3F,0x80,0x00,0x7F,0xFC,0x00,0x3F,0xFF,0x80,0x1F,
0xFF,0xF0,0x0F,0xFF,0xFE,0x03,0xF8,0x3F,0x81,0xF8,
0x03,0xF0,0x7C,0x00,0x7C,0x3F,0x00,0x1F,0xA5,0xF0,
0x00,0x7D,0xBF,0x00,0x01,0xFD,0xF8,0x00,0x0F,0xBE,
0x00,0x03,0xF2,0xF8,0x00,0x3E,0x3F,0x00,0x1F,0x87,
0xC0,0x07,0xC1,0xF8,0x03,0xF0,0x3F,0x83,0xF8,0x0F,
0xFF,0xFE,0x01,0xFF,0xFF,0x00,0x3F,0xFF,0x80,0x07,
0xFF,0xC0,0x00,0x3F,0x80,0x00,0x07,0xCE,0xC0,0x1F,
0x80,0x01,0xE0,0x03,0xE0,0x07,0xE0,0x0F,0xE0,0x1F,
0xE0,0x3F,0xE0,0xFF,0xE3,0xFF,0xE7,0xFB,0xEF,0xF3,
0xEF,0xC3,0xEF,0x03,0xEC,0x03,0xFA,0x00,0x7F,0x40,
0x0F,0xE8,0x01,0xFA,0x00,0x3E,0x0D,0x4E,0x40,0x1F,
0x00,0x3F,0xE0,0x00,0x1F,0xFF,0x00,0x0F,0xFF,0xF8,
0x03,0xFF,0xFF,0x80,0xFF,0xFF,0xF8,0x1F,0xC0,0x7F,
0x87,0xF0,0x03,0xF0,0xFC,0x00,0x3E,0x3F,0x00,0x07,
0xF0,0xF8,0x00,0x0F,0x87,0x00,0x01,0xF8,0x00,0x00,
0x07,0xE0,0x00,0x00,0x3E,0x00,0x00,0x0F,0xC0,0x00,
0x03,0xF0,0x00,0x00,0xFC,0x00,0x00,0x3F,0x00,0x00,
0x0F,0xE0,0x00,0x03,0xF8,0x00,0x00,0xFE,0x00,0x00,
0x7F,0x80,0x00,0x1F,0xC0,0x00,0x07,0xF0,0x00,0x01,
0xFC,0x00,0x00,0xFF,0x00,0x00,0x3F,0xC0,0x00,0x0F,
0xE0,0x00,0x03,0xF8,0x00,0x00,0x7E,0x00,0x00,0x1F,
0x80,0x00,0x07,0xE0,0x00,0x02,0x1F,0xFF,0xFF,0xF9,
0xFF,0xFF,0xFF,0xC0,0x0C,0xCE,0x60,0x1F,0x00,0x7F,
0x00,0x00,0x7F,0xF8,0x00,0x7F,0xFF,0x00,0x3F,0xFF,
0xF0,0x1F,0xFF,0xFC,0x07,0xF0,0x3F,0x83,0xF0,0x07,
0xE0,0xF8,0x00,0xFC,0x7E,0x00,0x1F,0x1F,0x00,0x07,
0xC1,0xC0,0x01,0xF0,0x00,0x00,0x7C,0x00,0x00,0x3E,
0x00,0x00,0x1F,0x80,0x00,0x1F,0xC0,0x00,0x7F,0xE0,
0x00,0x1F,0xE0,0x00,0x07,0xFC,0x00,0x01,0xFF,0xC0,
0x00,0xEF,0xF8,0x00,0x00,0x3F,0x00,0x00,0x07,0xE0,
0x00,0x00,0xF8,0x00,0x00,0x3F,0x90,0x00,0x00,0xF8,
0xE0,0x00,0x3E,0xF8,0x00,0x0F,0xBF,0x00,0x07,0xEF,
0xC0,0x01,0xF1,0xF8,0x00,0xFC,0x7F,0x00,0x7F,0x0F,
0xE0,0x7F,0x83,0xFF,0xFF,0xC0,0x7F,0xFF,0xE0,0x0F,
0xFF,0xF0,0x00,0xFF,0xF8,0x00,0x0F,0xF0,0x00,0x0D,
0xCE,0x20,0x1F,0x00,0x00,0x1E,0x00,0x00,0x03,0xE0,
0x00,0x00,0x7E,0x08,0x00,0x01,0xFC,0x00,0x00,0x3F,
0xC0,0x00,0x07,0xFC,0x10,0x00,0x1F,0xF8,0x00,0x03,
0xFF,0x80,0x00,0x7E,0xF8,0x20,0x01,0xF9,0xF0,0x00,
0x3F,0x1F,0x00,0x07,0xE1,0xF0,0x40,0x1F,0x83,0xE0,
0x03,0xF0,0x3E,0x00,0x7E,0x03,0xE0,0x81,0xF8,0x07,
0xC0,0x3F,0x00,0x7C,0x07,0xE0,0x07,0xC0,0xFC,0x00,
0x7C,0x17,0xFF,0xFF,0xFF,0xF4,0x00,0x01,0xF0,0x48,
0x00,0x03,0xE0,0x0C,0xCE,0x60,0x1F,0x80,0x7F,0xFF,
0xE4,0x87,0xFF,0xFF,0x20,0x3E,0x00,0x01,0x03,0xF0,
0x00,0x09,0x1F,0x00,0x00,0x0F,0xC0,0x00,0x03,0xF1,
0xF8,0x00,0xFD,0xFF,0x80,0x3E,0xFF,0xF8,0x0F,0xFF,
0xFF,0x07,0xFF,0xFF,0xE1,0xFE,0x03,0xF8,0x7E,0x00,
0x3F,0x07,0x00,0x07,0xC0,0x00,0x01,0xFE,0x00,0x00,
0x07,0xDF,0x00,0x01,0xF7,0xC0,0x00,0xF9,0xF8,0x00,
0x3E,0x3E,0x00,0x1F,0x8F,0xC0,0x0F,0xC1,0xFC,0x0F,
0xF0,0x7F,0xFF,0xF8,0x0F,0xFF,0xFC,0x01,0xFF,0xFE,
0x00,0x1F,0xFE,0x00,0x01,0xFE,0x00,0x0D,0x4E,0x40,
0x1F,0x00,0x1F,0xE0,0x00,0x0F,0xFF,0x00,0x07,0xFF,
0xF0,0x01,0xFF,0xFF,0x00,0x7F,0xFF,0xF0,0x1F,0xE0,
0xFF,0x03,0xF0,0x07,0xE0,0xFC,0x00,0x7C,0x1F,0x00,
0x0F,0xC7,0xE0,0x00,0xFA,0x5F,0x00,0x00,0x07,0xC0,
0x00,0x00,0xF8,0x1F,0xC0,0x1F,0x0F,0xFE,0x03,0xE7,
0xFF,0xF0,0x7D,0xFF,0xFF,0x0F,0xBF,0xFF,0xF1,0xFF,
0x80,0xFE,0x3F,0xC0,0x0F,0xE7,0xF0,0x00,0xFC,0xFC,
0x00,0x0F,0xEB,0xE0,0x00,0x1F,0x87,0x80,0x00,0x7C,
0xF8,0x00,0x1F,0x9F,0x00,0x03,0xE1,0xF0,0x00,0xFC,
0x3F,0x00,0x3F,0x83,0xF8,0x1F,0xE0,0x3F,0xFF,0xF8,
0x03,0xFF,0xFE,0x00,0x3F,0xFF,0x80,0x03,0xFF,0xE0,
0x00,0x0F,0xE0,0x00,0x0D,0x4E,0x40,0x1F,0xBF,0xFF,
0xFF,0xFC,0x00,0x00,0x0F,0x00,0x00,0x03,0xC0,0x00,
0x00,0xF0,0x00,0x00,0x3C,0x00,0x00,0x0F,0x80,0x00,
0x03,0xE0,0x00,0x00,0x78,0x00,0x00,0x1F,0x02,0x00,
0x00,0xF8,0x08,0x00,0x07,0xC0,0x20,0x00,0x3E,0x00,
0x80,0x01,0xF0,0x02,0x00,0x0F,0x80,0x09,0x00,0x7C,
0x00,0x24,0x03,0xE0,0x00,0x00,0xFC,0x00,0x14,0x03,
0xE0,0x00,0x58,0x1F,0x00,0x00,0x0C,0xCE,0x60,0x1F,
0x00,0x7F,0x80,0x00,0x7F,0xFC,0x00,0x7F,0xFF,0x80,
0x3F,0xFF,0xF0,0x0F,0xFF,0xFE,0x07,0xF0,0x1F,0xC1,
0xF8,0x03,0xF0,0xFC,0x00,0x7E,0xA7,0xC0,0x01,0xF1,
0xF8,0x00,0xFC,0x3E,0x00,0x3E,0x07,0xE0,0x3F,0x00,
0xFF,0xFF,0x80,0x1F,0xFF,0xC0,0x03,0xFF,0xE0,0x03,
0xFF,0xFE,0x01,0xFF,0xFF,0xC0,0xFE,0x03,0xF8,0x7E,
0x00,0x3E,0x1F,0x00,0x0F,0xCF,0xC0,0x01,0xF6,0x7C,
0x00,0x07,0xDF,0x80,0x03,0xF3,0xE0,0x00,0xF8,0xFC,
0x00,0x7E,0x1F,0xC0,0x7F,0x07,0xFF,0xFF,0xC0,0xFF,
0xFF,0xE0,0x1F,0xFF,0xF0,0x01,0xFF,0xF0,0x00,0x0F,
0xE0,0x00,0x0C,0xCE,0x60,0x1F,0x00,0x7F,0x00,0x00,
0x7F,0xF8,0x00,0x7F,0xFF,0x02,0x07,0xFF,0xFE,0x03,
0xFC,0x0F,0xC1,0xFC,0x01,0xF8,0x7E,0x00,0x3E,0x1F,
0x00,0x07,0xCF,0xC0,0x00,0xF4,0x7C,0x00,0x07,0xAB,
0xE0,0x00,0x3E,0xFC,0x00,0x1F,0x9F,0x00,0x0F,0xE7,
0xE0,0x07,0xF8,0xFE,0x03,0xFE,0x3F,0xFF,0xFF,0x87,
0xFF,0xFB,0xE0,0xFF,0xFC,0xF8,0x1F,0xFC,0x3E,0x00,
0xFC,0x0F,0x80,0x00,0x03,0xF2,0x00,0x00,0x3E,0x3E,
0x00,0x1F,0x8F,0x80,0x07,0xC3,0xF0,0x03,0xF0,0x7E,
0x01,0xF8,0x1F,0xC0,0xFE,0x03,0xFF,0xFF,0x00,0x7F,
0xFF,0x80,0x1F,0xFF,0xC0,0x01,0xFF,0xE0,0x00,0x1F,
0xC0,0x00,0x02,0xBA,0xA0,0x10,0xBF,0xE8,0x34,0x16,
0x0B,0xF8,0x02,0xCA,0xBE,0x10,0xBF,0xE8,0x34,0x16,
0x0B,0xFD,0x1E,0x1C,0xE1,0x00,0x0D,0xB6,0x61,0xA1,
0x00,0x00,0x00,0x10,0x00,0x00,0x0F,0x00,0x00,0x03,
0xF0,0x00,0x01,0xFF,0x00,0x00,0x7F,0xF0,0x00,0x3F,
0xFE,0x00,0x0F,0xFF,0x00,0x03,0xFF,0xC0,0x01,0xFF,
0xE0,0x00,0x7F,0xF0,0x00,0x3F,0xFC,0x00,0x07,0xFE,
0x00,0x00,0x7F,0x80,0x00,0x07,0xC0,0x00,0x00,0x7F,
0x80,0x00,0x07,0xFE,0x00,0x00,0x3F,0xFC,0x00,0x00,
0x7F,0xF0,0x00,0x01,0xFF,0xE0,0x00,0x03,0xFF,0xC0,
0x00,0x0F,0xFF,0x00,0x00,0x3F,0xFE,0x00,0x00,0x7F,
0xF0,0x00,0x01,0xFF,0x00,0x00,0x03,0xF0,0x00,0x00,
0x0F,0x00,0x00,0x00,0x10,0x0D,0xA2,0x62,0xE1,0xBF,
0xFF,0xFF,0xFF,0xA0,0x00,0x00,0x02,0xFF,0xFF,0xFF,
0xF8,0x0D,0xB6,0x61,0xA1,0x40,0x00,0x00,0x07,0x80,
0x00,0x00,0x7E,0x00,0x00,0x07,0xFC,0x00,0x00,0x7F,
0xF0,0x00,0x03,0xFF,0xE0,0x00,0x07,0xFF,0x80,0x00,
0x1F,0xFE,0x00,0x00,0x3F,0xFC,0x00,0x00,0x7F,0xF0,
0x00,0x01,0xFF,0xE0,0x00,0x03,0xFF,0x00,0x00,0x0F,
0xF0,0x00,0x00,0x1F,0x00,0x00,0x0F,0xF0,0x00,0x03,
0xFF,0x00,0x01,0xFF,0xE0,0x00,0x7F,0xF0,0x00,0x3F,
0xFC,0x00,0x1F,0xFE,0x00,0x07,0xFF,0x80,0x03,0xFF,
0xE0,0x00,0x7F,0xF0,0x00,0x07,0xFC,0x00,0x00,0x7E,
0x00,0x00,0x07,0x80,0x00,0x00,0x40,0x00,0x00,0x00,
0x0C,0xD0,0x60,0x1F,0x00,0x3F,0xC0,0x00,0x7F,0xFC,
0x00,0x3F,0xFF,0xC0,0x3F,0xFF,0xF8,0x0F,0xFF,0xFF,
0x07,0xF8,0x3F,0xC3,0xF8,0x03,0xF8,0xFC,0x00,0x7E,
0x3E,0x00,0x0F,0xDF,0x80,0x03,0xF7,0xE0,0x00,0x7D,
0xF0,0x00,0x1F,0x1C,0x00,0x07,0xC0,0x00,0x01,0xF0,
0x00,0x00,0xFC,0x00,0x00,0x3E,0x00,0x00,0x1F,0x80,
0x00,0x0F,0xC0,0x00,0x07,0xE0,0x00,0x07,0xF0,0x00,
0x03,0xF8,0x00,0x01,0xFC,0x00,0x00,0xFE,0x00,0x00,
0x7F,0x00,0x00,0x1F,0x80,0x00,0x07,0xC0,0x00,0x03,
0xF0,0x02,0x80,0x1F,0x00,0x14,0x00,0x00,0x00,0xB0,
0x07,0xC0,0x00,0x1A,0x68,0x7D,0x39,0x00,0x00,0x03,
0xFF,0xC0,0x00,0x00,0x00,0x01,0xFF,0xFF,0xE0,0x00,
0x00,0x00,0x3F,0xFF,0xFF,0xC0,0x00,0x00,0x07,0xFF,
0xFF,0xFF,0x80,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,
0x00,0x0F,0xFF,0x00,0x3F,0xFC,0x00,0x00,0xFF,0x80,
0x00,0x1F,0xF0,0x00,0x0F,0xF0,0x00,0x00,0x3F,0xC0,
0x00,0xFE,0x00,0x00,0x00,0x7F,0x00,0x0F,0xE0,0x00,
0x00,0x01,0xF8,0x00,0xFC,0x00,0x7C,0x00,0x07,0xE0,
0x07,0xC0,0x0F,0xF8,0x3E,0x1F,0x80,0x7C,0x01,0xFF,
0xF1,0xF0,0x7C,0x03,0xE0,0x1F,0xFF,0xDF,0x01,0xF0,
0x3E,0x01,0xFF,0xFE,0xF8,0x0F,0x81,0xE0,0x1F,0xE1,
0xFF,0xC0,0x3C,0x1F,0x01,0xFC,0x03,0xFE,0x01,0xF0,
0xF0,0x0F,0xC0,0x0F,0xF0,0x07,0x8F,0x80,0xFC,0x00,
0x7F,0x00,0x3C,0x78,0x07,0xC0,0x01,0xF8,0x01,0xE3,
0xC0,0x7E,0x00,0x0F,0xC0,0x0F,0x1E,0x03,0xE0,0x00,
0x7E,0x00,0x79,0xE0,0x1F,0x00,0x03,0xE0,0x03,0xCF,
0x01,0xF8,0x00,0x1F,0x00,0x1E,0x78,0x0F,0x80,0x00,
0xF8,0x00,0xF3,0xC0,0x7C,0x00,0x07,0xC0,0x0F,0x1E,
0x03,0xE0,0x00,0x7C,0x00,0x78,0xF0,0x1F,0x00,0x03,
0xE0,0x07,0xC7,0x80,0xF8,0x00,0x1F,0x00,0x3C,0x3C,
0x07,0xC0,0x01,0xF8,0x03,0xE1,0xE0,0x3E,0x00,0x0F,
0xC0,0x3E,0x0F,0x01,0xF8,0x00,0xFC,0x03,0xF0,0x7C,
0x07,0xC0,0x0F,0xE0,0x3F,0x01,0xE0,0x3F,0x00,0xFF,
0x03,0xF0,0x0F,0x00,0xFC,0x1F,0xFC,0x7F,0x00,0x7C,
0x07,0xFF,0xFF,0xFF,0xF0,0x03,0xE0,0x1F,0xFF,0xBF,
0xFF,0x00,0x0F,0x80,0x7F,0xF9,0xFF,0xF0,0x00,0x7C,
0x01,0xFF,0x87,0xFE,0x00,0x01,0xF0,0x03,0xE0,0x1F,
0xC0,0x1F,0x0F,0xC0,0x00,0x00,0x00,0x01,0xF0,0x3F,
0x00,0x00,0x00,0x00,0x1F,0x80,0xFC,0x00,0x00,0x00,
0x03,0xF8,0x07,0xF8,0x00,0x00,0x00,0x3F,0x80,0x1F,
0xF0,0x00,0x00,0x07,0xF8,0x00,0x7F,0xE0,0x00,0x00,
0xFF,0x80,0x00,0xFF,0xF0,0x00,0x7F,0xF8,0x00,0x03,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x07,0xFF,0xFF,0xFF,
0xF0,0x00,0x00,0x0F,0xFF,0xFF,0xFE,0x00,0x00,0x00,
0x0F,0xFF,0xFF,0x80,0x00,0x00,0x00,0x07,0xFF,0xC0,
0x00,0x00,0x12,0xD0,0x00,0x25,0x80,0x00,0x0F,0x80,
0x00,0x40,0x00,0x0F,0xE0,0x00,0x00,0x00,0x7F,0xC0,
0x00,0x80,0x00,0x3D,0xE0,0x00,0x00,0x01,0xF7,0xC0,
0x00,0x00,0x07,0x8F,0x00,0x00,0x00,0x3E,0x3E,0x00,
0x00,0x00,0xF0,0x78,0x00,0x40,0x00,0xF8,0x3E,0x00,
0x00,0x03,0xC0,0x78,0x00,0x00,0x1F,0x01,0xF0,0x00,
0x00,0x78,0x03,0xC0,0x08,0x00,0x7C,0x01,0xF0,0x00,
0x01,0xE0,0x03,0xC0,0x10,0x01,0xF0,0x01,0xF0,0x00,
0x0F,0x80,0x03,0xE0,0x20,0x07,0xFF,0xFF,0xF0,0x10,
0x07,0xFF,0xFF,0xFC,0x00,0x3F,0xFF,0xFF,0xF8,0x00,
0xF8,0x00,0x03,0xE0,0x90,0xF8,0x00,0x00,0xF8,0x40,
0xF8,0x00,0x00,0x3E,0x07,0xE0,0x00,0x00,0xFC,0x83,
0xE0,0x00,0x00,0x3E,0x43,0xE0,0x00,0x00,0x0F,0x9F,
0x80,0x00,0x00,0x3F,0x7C,0x00,0x00,0x00,0x7C,0x0E,
0xD0,0xA0,0x25,0x7F,0xFF,0xF0,0x01,0xFF,0xFF,0xF8,
0x07,0xFF,0xFF,0xF0,0x1F,0xFF,0xFF,0xE0,0x7F,0xFF,
0xFF,0xC1,0xF0,0x00,0x7F,0x87,0xC0,0x00,0x7E,0x1F,
0x00,0x00,0xFC,0xBF,0x80,0x00,0x3E,0x3E,0x00,0x00,
0xF0,0xF8,0x00,0x07,0xC3,0xE0,0x00,0x3F,0x0F,0x80,
0x03,0xF8,0x3F,0xFF,0xFF,0xC1,0x1F,0xFF,0xFF,0xC0,
0x7F,0xFF,0xFF,0xC1,0xFF,0xFF,0xFF,0x87,0xC0,0x00,
0xFF,0x1F,0x00,0x00,0xFE,0x7C,0x00,0x01,0xF9,0xF0,
0x00,0x03,0xFB,0xF8,0x00,0x00,0xFB,0xE0,0x00,0x07,
0xEF,0x80,0x00,0x1F,0x3E,0x00,0x00,0xFC,0xF8,0x00,
0x0F,0xE3,0xFF,0xFF,0xFF,0x8F,0xFF,0xFF,0xFC,0x3F,
0xFF,0xFF,0xE0,0xFF,0xFF,0xFE,0x03,0xFF,0xFF,0xC0,
0x00,0x11,0x54,0x7F,0xE8,0x00,0x01,0xFE,0x00,0x00,
0x01,0xFF,0xF8,0x00,0x00,0xFF,0xFF,0xC0,0x00,0x7F,
0xFF,0xFC,0x00,0x1F,0xFF,0xFF,0xC0,0x07,0xFC,0x07,
0xFC,0x01,0xFC,0x00,0x3F,0xC0,0x7F,0x00,0x01,0xF8,
0x0F,0xC0,0x00,0x1F,0x83,0xF0,0x00,0x03,0xF0,0x7C,
0x00,0x00,0x3E,0x1F,0x80,0x00,0x07,0xE3,0xE0,0x00,
0x00,0x71,0x0F,0x80,0x00,0x00,0x03,0xF0,0x00,0x00,
0x00,0xDF,0x80,0x00,0x00,0x02,0x7E,0x00,0x00,0x00,
0x03,0xE0,0x00,0x00,0x00,0x7C,0x00,0x00,0x06,0x0F,
0x80,0x00,0x00,0xF9,0xF0,0x00,0x00,0x3F,0x1F,0x00,
0x00,0x07,0xC3,0xE0,0x00,0x01,0xF8,0x7E,0x00,0x00,
0x3F,0x07,0xE0,0x00,0x0F,0xC0,0xFE,0x00,0x03,0xF8,
0x0F,0xF0,0x01,0xFE,0x00,0xFF,0x80,0xFF,0x80,0x0F,
0xFF,0xFF,0xE0,0x00,0xFF,0xFF,0xF8,0x00,0x0F,0xFF,
0xFE,0x00,0x00,0x7F,0xFF,0x00,0x00,0x01,0xFF,0x00,
0x00,0x10,0x50,0xA0,0x28,0x7F,0xFF,0xF8,0x00,0x3F,
0xFF,0xFF,0x80,0x1F,0xFF,0xFF,0xF0,0x0F,0xFF,0xFF,
0xFC,0x07,0xFF,0xFF,0xFF,0x03,0xE0,0x00,0x7F,0xC1,
0xF0,0x00,0x0F,0xF0,0xF8,0x00,0x01,0xF8,0x8F,0x80,
0x00,0x0F,0xC7,0xC0,0x00,0x03,0xF4,0xFC,0x00,0x00,
0x1F,0x6F,0xC0,0x00,0x00,0xFD,0x7C,0x00,0x00,0x0F,
0xBE,0x00,0x00,0x0F,0xE3,0xE0,0x00,0x00,0xF9,0xF0,
0x00,0x00,0xFC,0xF8,0x00,0x00,0x7C,0x8F,0x80,0x00,
0x0F,0xC7,0xC0,0x00,0x0F,0xC3,0xE0,0x00,0x1F,0xC1,
0xF0,0x00,0x3F,0xE0,0xFF,0xFF,0xFF,0xE0,0x7F,0xFF,
0xFF,0xE0,0x3F,0xFF,0xFF,0xE0,0x1F,0xFF,0xFF,0xC0,
0x0F,0xFF,0xFE,0x00,0x00,0x0E,0xD0,0xA0,0x25,0xBF,
0xFF,0xFF,0xFF,0x6F,0xC0,0x00,0x00,0x2F,0xE0,0x00,
0x00,0x17,0xFF,0xFF,0xFF,0x8D,0xF8,0x00,0x00,0x06,
0x7C,0x00,0x00,0x02,0xFF,0xFF,0xFF,0xFE,0x0D,0x50,
0xA0,0x22,0xBF,0xFF,0xFF,0xFF,0x7E,0x00,0x00,0x0B,
0xF8,0x00,0x00,0x2F,0xFF,0xFF,0xF8,0xDF,0x80,0x00,
0x03,0x7E,0x00,0x00,0x0A,0xF8,0x00,0x00,0x00,0x12,
0xD4,0x7F,0xEC,0x00,0x00,0xFF,0xC0,0x00,0x00,0x1F,
0xFF,0xE0,0x00,0x03,0xFF,0xFF,0xE0,0x00,0x1F,0xFF,
0xFF,0xC0,0x00,0xFF,0xFF,0xFF,0x80,0x07,0xFE,0x01,
0xFF,0x00,0x3F,0xC0,0x01,0xFE,0x01,0xFC,0x00,0x01,
0xFC,0x0F,0xE0,0x00,0x03,0xF0,0x3F,0x00,0x00,0x07,
0xC1,0xF8,0x00,0x00,0x1F,0x87,0xC0,0x00,0x00,0x3E,
0x3F,0x00,0x00,0x00,0xF8,0xF8,0x00,0x00,0x01,0x08,
0x7C,0x00,0x00,0x00,0x05,0xFC,0x00,0x00,0x00,0x02,
0xFE,0x00,0x03,0xFF,0xFF,0x2F,0x80,0x00,0x00,0x1F,
0x3F,0x00,0x00,0x00,0x7C,0x7C,0x00,0x00,0x01,0xF1,
0xF8,0x00,0x00,0x07,0xC3,0xF0,0x00,0x00,0x1F,0x0F,
0xE0,0x00,0x00,0xFC,0x1F,0xC0,0x00,0x07,0xF0,0x3F,
0xC0,0x00,0x7F,0xC0,0x7F,0xE0,0x1F,0xFE,0x00,0xFF,
0xFF,0xFF,0xF0,0x01,0xFF,0xFF,0xFF,0x00,0x01,0xFF,
0xFF,0xF0,0x00,0x01,0xFF,0xFF,0x00,0x00,0x00,0x7F,
0xC0,0x00,0x0F,0x50,0xA0,0x28,0xDF,0x80,0x00,0x07,
0xF7,0xE0,0x00,0x01,0xF8,0xF8,0x00,0x00,0x7E,0xFF,
0xFF,0xFF,0xFF,0xDF,0x80,0x00,0x07,0xF7,0xE0,0x00,
0x01,0xFB,0xF8,0x00,0x00,0x7C,0x02,0xD0,0xA0,0x0F,
0xDF,0xEF,0xF7,0xFB,0xFD,0xFD,0xFC,0x0A,0xD2,0x5F,
0xDC,0xD0,0x00,0x0F,0xE8,0x00,0x07,0xF4,0x00,0x03,
0xFA,0x00,0x01,0xF3,0xC0,0x07,0xE7,0xE0,0x03,0xEF,
0xC0,0x0F,0xBF,0x00,0x7C,0x7E,0x03,0xF1,0xFC,0x1F,
0xD0,0x7F,0xFF,0xC0,0xFF,0xFE,0x01,0xFF,0xE0,0x00,
0xFE,0x00,0x10,0xD0,0xA0,0x25,0x7C,0x00,0x00,0x3F,
0x1F,0x00,0x00,0x1F,0x87,0xC0,0x00,0x0F,0xC1,0xF0,
0x00,0x07,0xE0,0x7C,0x00,0x03,0xF0,0x1F,0x00,0x03,
0xF8,0x07,0xC0,0x01,0xFC,0x01,0xF0,0x00,0xFE,0x00,
0x7C,0x00,0x7F,0x00,0x1F,0x00,0x3F,0x80,0x07,0xC0,
0x1F,0xC0,0x01,0xF0,0x0F,0xE0,0x00,0x7C,0x07,0xF0,
0x00,0x1F,0x03,0xF8,0x00,0x07,0xC1,0xFC,0x00,0x01,
0xF0,0xFE,0x00,0x00,0x7C,0x7F,0x00,0x00,0x1F,0x3F,
0xE0,0x00,0x07,0xDF,0xF8,0x00,0x01,0xFF,0xFF,0x00,
0x00,0x7F,0xF7,0xE0,0x00,0x1F,0xF8,0xFC,0x00,0x07,
0xFC,0x1F,0x80,0x01,0xFE,0x07,0xE0,0x00,0x7F,0x00,
0xFC,0x00,0x1F,0x80,0x1F,0x80,0x08,0xF8,0x00,0x7E,
0x00,0x3E,0x00,0x0F,0xC0,0x0F,0x80,0x01,0xF8,0x04,
0x7C,0x00,0x07,0xE0,0x1F,0x00,0x00,0xFC,0x07,0xC0,
0x00,0x1F,0x81,0xF0,0x00,0x03,0xF0,0x8F,0x80,0x00,
0x0F,0xC3,0xE0,0x00,0x01,0xF8,0xF8,0x00,0x00,0x3F,
0x3E,0x00,0x00,0x07,0xE0,0x0C,0x50,0xA0,0x1F,0xDF,
0x80,0x00,0x0D,0xF8,0x00,0x00,0xDF,0x80,0x00,0x0D,
0xF8,0x00,0x00,0xDF,0x80,0x00,0x0B,0xFF,0xFF,0xFF,
0x12,0xD0,0xA0,0x2F,0x9F,0xF8,0x00,0x00,0xFF,0xCF,
0xFE,0x00,0x00,0xFF,0xDF,0xFC,0x00,0x03,0xFF,0x9F,
0xBE,0x00,0x03,0xEF,0xCF,0xCF,0x80,0x03,0xE7,0xDF,
0x3F,0x00,0x0F,0x9F,0x9F,0x8F,0x80,0x0F,0x8F,0xCF,
0xC3,0xE0,0x0F,0x87,0xDF,0x0F,0xC0,0x7C,0x1F,0x9F,
0x83,0xE0,0x3E,0x0F,0xCF,0xC0,0xF8,0x3E,0x07,0xDF,
0x03,0xF1,0xF0,0x1F,0x9F,0x80,0xF8,0xF8,0x0F,0xCF,
0xC0,0x3E,0xF8,0x07,0xDF,0x00,0xFF,0xC0,0x1F,0x9F,
0x80,0x3F,0xE0,0x0F,0xC7,0xC0,0x0F,0xE0,0x07,0xC0,
0x0F,0x50,0xA0,0x28,0x8F,0xC0,0x00,0x07,0xDF,0xC0,
0x00,0x0F,0xC7,0xF8,0x00,0x03,0xF1,0xFF,0x00,0x00,
0xFB,0xFF,0x00,0x01,0xF7,0xFF,0x00,0x03,0xEF,0xBE,
0x00,0x07,0xDF,0x7E,0x00,0x0F,0xC7,0xCF,0xC0,0x03,
0xEF,0x8F,0xC0,0x07,0xDF,0x0F,0x80,0x0F,0xBE,0x1F,
0x80,0x1F,0x7C,0x1F,0x80,0x3E,0xF8,0x1F,0x00,0x7D,
0xF0,0x3F,0x00,0xFC,0x7C,0x07,0xE0,0x3E,0xF8,0x07,
0xE0,0x7D,0xF0,0x07,0xC0,0xFB,0xE0,0x0F,0xC1,0xF7,
0xC0,0x0F,0xC3,0xEF,0x80,0x0F,0x87,0xDF,0x00,0x1F,
0x8F,0xC7,0xC0,0x03,0xF3,0xEF,0x80,0x03,0xF7,0xDF,
0x00,0x03,0xEF,0xBE,0x00,0x07,0xFF,0x7C,0x00,0x07,
0xFF,0x1F,0x00,0x00,0xFF,0xC7,0xC0,0x00,0x1F,0xEF,
0x80,0x00,0x1F,0xE3,0xE0,0x00,0x03,0xF0,0x13,0x54,
0x7F,0xEC,0x00,0x01,0xFF,0x00,0x00,0x00,0x1F,0xFF,
0xE0,0x00,0x00,0xFF,0xFF,0xF0,0x00,0x03,0xFF,0xFF,
0xF0,0x00,0x0F,0xFF,0xFF,0xF0,0x00,0x3F,0xE0,0x1F,
0xF0,0x00,0xFF,0x00,0x0F,0xF0,0x03,0xF8,0x00,0x07,
0xF0,0x0F,0xE0,0x00,0x07,0xF0,0x1F,0x00,0x00,0x07,
0xE0,0x7E,0x00,0x00,0x07,0xE0,0xF8,0x00,0x00,0x07,
0xC3,0xF0,0x00,0x00,0x0F,0xD2,0xF8,0x00,0x00,0x01,
0xF6,0xFC,0x00,0x00,0x00,0x3F,0x3F,0x00,0x00,0x00,
0x0F,0xCB,0xE0,0x00,0x00,0x07,0xC7,0xE0,0x00,0x00,
0x1F,0x87,0xC0,0x00,0x00,0x3E,0x0F,0xC0,0x00,0x00,
0xFC,0x0F,0xC0,0x00,0x03,0xF0,0x1F,0xC0,0x00,0x0F,
0xE0,0x1F,0xC0,0x00,0x3F,0x80,0x1F,0xC0,0x00,0xFE,
0x00,0x1F,0xF0,0x0F,0xFC,0x00,0x1F,0xFF,0xFF,0xE0,
0x00,0x1F,0xFF,0xFF,0x80,0x00,0x1F,0xFF,0xFE,0x00,
0x00,0x0F,0xFF,0xF0,0x00,0x00,0x03,0xFE,0x00,0x00,
0x0E,0xD0,0xA0,0x25,0x7F,0xFF,0xFC,0x01,0xFF,0xFF,
0xFC,0x07,0xFF,0xFF,0xFC,0x1F,0xFF,0xFF,0xF8,0x7F,
0xFF,0xFF,0xF1,0xF0,0x00,0x1F,0xC7,0xC0,0x00,0x1F,
0x9F,0x00,0x00,0x3E,0x7C,0x00,0x00,0xFF,0x3E,0x00,
0x00,0x3E,0xF8,0x00,0x01,0xFB,0xE0,0x00,0x07,0xCF,
0x80,0x00,0x7F,0x3E,0x00,0x07,0xF8,0xFF,0xFF,0xFF,
0xE3,0xFF,0xFF,0xFF,0x0F,0xFF,0xFF,0xF8,0x3F,0xFF,
0xFF,0x80,0xFF,0xFF,0xF0,0x06,0xFC,0x00,0x00,0x03,
0x7E,0x00,0x00,0x01,0x1F,0x00,0x00,0x00,0x13,0x58,
0x7F,0x6C,0x00,0x01,0xFF,0x00,0x00,0x00,0x1F,0xFF,
0xC0,0x00,0x00,0xFF,0xFF,0xE0,0x00,0x03,0xFF,0xFF,
0xE0,0x00,0x1F,0xFF,0xFF,0xF0,0x00,0x7F,0xE0,0x3F,
0xF0,0x01,0xFE,0x00,0x0F,0xF0,0x03,0xF8,0x00,0x0F,
0xE0,0x0F,0xC0,0x00,0x0F,0xE0,0x1F,0x00,0x00,0x0F,
0xC0,0x7E,0x00,0x00,0x0F,0xC0,0xF8,0x00,0x00,0x0F,
0x83,0xF0,0x00,0x00,0x1F,0x92,0xF8,0x00,0x00,0x03,
0xE6,0xFC,0x00,0x00,0x00,0x7D,0x3F,0x00,0x00,0x00,
0x1F,0x4B,0xE0,0x00,0x00,0x0F,0x87,0xE0,0x00,0x00,
0x3F,0x07,0xC0,0x01,0x80,0x7C,0x0F,0xC0,0x07,0xC1,
0xF8,0x0F,0x80,0x0F,0xE7,0xE0,0x1F,0x80,0x1F,0xEF,
0xC0,0x1F,0xC0,0x0F,0xFF,0x00,0x1F,0xC0,0x07,0xFC,
0x00,0x3F,0xF0,0x1F,0xF8,0x00,0x3F,0xFF,0xFF,0xF8,
0x00,0x1F,0xFF,0xFF,0xF8,0x00,0x1F,0xFF,0xFF,0xFC,
0x00,0x0F,0xFF,0xE3,0xFC,0x00,0x03,0xFE,0x01,0xFC,
0x00,0x00,0x00,0x01,0xF0,0x00,0x00,0x00,0x00,0xE0,
0x10,0x50,0xA0,0x28,0x7F,0xFF,0xFE,0x00,0x3F,0xFF,
0xFF,0xE0,0x1F,0xFF,0xFF,0xF8,0x0F,0xFF,0xFF,0xFE,
0x07,0xFF,0xFF,0xFF,0x83,0xE0,0x00,0x1F,0xE1,0xF0,
0x00,0x03,0xF0,0xF8,0x00,0x00,0xF8,0x7C,0x00,0x00,
0x7E,0x57,0xC0,0x00,0x03,0xE4,0x7C,0x00,0x00,0x7E,
0x3E,0x00,0x00,0x7E,0x1F,0x00,0x01,0xFF,0x0F,0xFF,
0xFF,0xFF,0x07,0xFF,0xFF,0xFF,0x03,0xFF,0xFF,0xFF,
0x01,0xFF,0xFF,0xFE,0x00,0xFF,0xFF,0xFC,0x00,0x7C,
0x01,0xF8,0x00,0x3E,0x00,0x3F,0x00,0x1F,0x00,0x0F,
0xC0,0x0F,0x80,0x03,0xE0,0x07,0xC0,0x01,0xF8,0x03,
0xE0,0x00,0x7E,0x02,0x3E,0x00,0x03,0xF0,0x1F,0x00,
0x00,0xFC,0x0F,0x80,0x00,0x3E,0x07,0xC0,0x00,0x1F,
0x83,0xE0,0x00,0x07,0xE1,0xF0,0x00,0x01,0xF0,0xF8,
0x00,0x00,0xFC,0x7C,0x00,0x00,0x3E,0x3E,0x00,0x00,
0x1F,0x9F,0x00,0x00,0x07,0xEF,0x80,0x00,0x01,0xF0,
0x0F,0xD4,0x7F,0xE5,0x00,0x0F,0xF8,0x00,0x00,0x7F,
0xFF,0x00,0x01,0xFF,0xFF,0xC0,0x03,0xFF,0xFF,0xE0,
0x07,0xFF,0xFF,0xF0,0x07,0xF8,0x07,0xF8,0x0F,0xC0,
0x01,0xFC,0x0F,0x80,0x00,0xFC,0x1F,0x80,0x00,0x7C,
0x1F,0x00,0x00,0x7E,0x83,0xE0,0x00,0x07,0xC3,0xE0,
0x00,0x00,0x03,0xF0,0x00,0x00,0x01,0xF0,0x00,0x00,
0x01,0xFC,0x00,0x00,0x01,0xFF,0x80,0x00,0x00,0xFF,
0xF0,0x00,0x00,0x7F,0xFF,0x00,0x00,0x1F,0xFF,0xE0,
0x00,0x0F,0xFF,0xF8,0x00,0x01,0xFF,0xFE,0x00,0x00,
0x3F,0xFF,0x00,0x00,0x03,0xFF,0x80,0x00,0x00,0x3F,
0xC0,0x00,0x00,0x1F,0xC0,0x00,0x00,0x07,0xC0,0x00,
0x00,0x07,0xF3,0xF0,0x00,0x00,0x7D,0xF8,0x00,0x00,
0x7C,0xF8,0x00,0x00,0x7C,0xFC,0x00,0x00,0xF8,0x7E,
0x00,0x01,0xF8,0x7F,0x80,0x03,0xF8,0x3F,0xE0,0x1F,
0xF0,0x1F,0xFF,0xFF,0xE0,0x0F,0xFF,0xFF,0xC0,0x07,
0xFF,0xFF,0x80,0x01,0xFF,0xFE,0x00,0x00,0x3F,0xF0,
0x00,0x0F,0xD0,0x40,0x23,0xBF,0xFF,0xFF,0xFF,0xFA,
0x00,0x0F,0x80,0x03,0x40,0x01,0xF0,0x00,0x68,0x00,
0x3E,0x00,0x0D,0x00,0x07,0xC0,0x01,0xA0,0x00,0xF8,
0x00,0x00,0x0F,0x52,0xBF,0xE8,0xDF,0x80,0x00,0x07,
0xF7,0xE0,0x00,0x01,0xFD,0xF8,0x00,0x00,0x7F,0x7E,
0x00,0x00,0x1F,0x7C,0x00,0x00,0x3E,0xFC,0x00,0x00,
0xFE,0x1F,0x00,0x00,0x3E,0x3F,0x00,0x00,0xFC,0x7F,
0x00,0x03,0xF0,0x7F,0x00,0x0F,0xE0,0x7F,0x80,0x7F,
0x80,0xFF,0xFF,0xFF,0x00,0xFF,0xFF,0xFC,0x00,0xFF,
0xFF,0xE0,0x00,0x7F,0xFF,0x80,0x00,0x1F,0xF8,0x00,
0x12,0xD0,0x00,0x25,0x7C,0x00,0x00,0x00,0x7D,0xF8,
0x00,0x00,0x03,0xF8,0x7C,0x00,0x00,0x01,0xF4,0x1F,
0x00,0x00,0x01,0xF0,0x7E,0x00,0x00,0x0F,0xC8,0x1F,
0x00,0x00,0x07,0xC4,0x87,0xC0,0x00,0x07,0xC2,0x01,
0xF0,0x00,0x07,0xC1,0x20,0x7C,0x00,0x07,0xC0,0x80,
0x1F,0x00,0x07,0xC0,0x48,0x07,0xC0,0x07,0xC0,0x20,
0x01,0xF0,0x07,0xC0,0x00,0x03,0xC0,0x3E,0x00,0x00,
0x0F,0x80,0xF8,0x00,0x00,0x1E,0x03,0xC0,0x04,0x00,
0x0F,0x83,0xE0,0x00,0x00,0x1E,0x0F,0x00,0x00,0x00,
0x7C,0x7C,0x00,0x00,0x00,0xF1,0xE0,0x00,0x80,0x00,
0x7D,0xF0,0x00,0x00,0x00,0xF7,0x80,0x00,0x00,0x03,
0xFE,0x00,0x04,0x80,0x00,0xFE,0x00,0x00,0x00,0x01,
0xF0,0x00,0x00,0x1B,0xD0,0x20,0x38,0x7C,0x00,0x00,
0x7F,0x00,0x00,0x1F,0x7C,0x00,0x00,0xFF,0x80,0x00,
0x3F,0x87,0xC0,0x00,0x1F,0xF0,0x00,0x07,0xC7,0xC0,
0x00,0x3F,0xF8,0x00,0x07,0xC7,0xC0,0x00,0x3E,0xF8,
0x00,0x07,0xD0,0x7C,0x00,0x07,0xDF,0x00,0x01,0xF0,
0x7C,0x00,0x0F,0x8F,0x80,0x01,0xF0,0x3C,0x00,0x0F,
0x8F,0x80,0x01,0xE0,0x3E,0x00,0x0F,0x8F,0x80,0x03,
0xE0,0x3E,0x00,0x1F,0x8F,0xC0,0x03,0xE0,0x3E,0x00,
0x1F,0x07,0xC0,0x03,0xE0,0x1E,0x00,0x1F,0x07,0xC0,
0x03,0xC0,0x1F,0x00,0x3F,0x07,0xE0,0x07,0xC2,0x03,
0xE0,0x07,0xC0,0x7C,0x00,0xF8,0x01,0xE0,0x07,0xC0,
0x7C,0x00,0xF0,0x40,0x3E,0x01,0xF0,0x07,0xC0,0x3E,
0x00,0x1E,0x01,0xF0,0x07,0xC0,0x3C,0x00,0x1E,0x03,
0xF0,0x07,0xE0,0x3C,0x08,0x03,0xE0,0x7C,0x00,0x7C,
0x0F,0x80,0x01,0xE0,0xFC,0x00,0x7C,0x0F,0x00,0x01,
0xE0,0xF8,0x00,0x3E,0x0F,0x01,0x00,0x3E,0x1F,0x00,
0x07,0xC3,0xE0,0x20,0x03,0xC7,0xC0,0x00,0x7C,0x78,
0x00,0x03,0xE7,0xC0,0x00,0x7C,0xF8,0x00,0x03,0xEF,
0xC0,0x00,0x7E,0xF8,0x04,0x00,0x3D,0xF0,0x00,0x07,
0xDE,0x00,0x00,0x3F,0xF0,0x00,0x07,0xFE,0x00,0x90,
0x03,0xFC,0x00,0x00,0x7F,0x80,0x00,0x03,0xF8,0x00,
0x00,0x3F,0x80,0x00,0x01,0xF8,0x00,0x00,0x3F,0x00,
0x00,0x12,0xD0,0x00,0x25,0x1F,0x80,0x00,0x03,0xF0,
0x3F,0x00,0x00,0x1F,0x80,0x7E,0x00,0x00,0xFC,0x00,
0xF8,0x00,0x07,0xE0,0x03,0xF0,0x00,0x1F,0x80,0x07,
0xE0,0x00,0xFC,0x08,0x01,0xF8,0x00,0xFC,0x00,0x03,
0xF0,0x07,0xE0,0x00,0x07,0xE0,0x3F,0x00,0x40,0x01,
0xF8,0x3F,0x00,0x00,0x03,0xF1,0xF8,0x00,0x00,0x07,
0xEF,0xC0,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,0x3F,
0xF8,0x00,0x00,0x00,0x7F,0xC0,0x00,0x90,0x00,0x1F,
0xC0,0x00,0x00,0x00,0xFF,0x80,0x01,0x00,0x00,0xFF,
0xE0,0x00,0x00,0x07,0xEF,0xC0,0x00,0x00,0x3F,0x1F,
0x80,0x00,0x01,0xFC,0x3E,0x00,0x00,0x07,0xE0,0xFC,
0x00,0x00,0x3F,0x01,0xF8,0x02,0x00,0x3F,0x00,0x7E,
0x00,0x01,0xF8,0x00,0xFC,0x00,0x0F,0xC0,0x01,0xF8,
0x10,0x0F,0xC0,0x00,0x7E,0x00,0x7E,0x00,0x00,0xFC,
0x03,0xF0,0x00,0x01,0xF8,0x0F,0xC0,0x00,0x03,0xE0,
0x7E,0x00,0x00,0x0F,0xC3,0xF0,0x00,0x00,0x1F,0x9F,
0x80,0x00,0x00,0x3F,0x11,0xD0,0x20,0x25,0x7E,0x00,
0x00,0x03,0xF3,0xF0,0x00,0x00,0x7E,0x1F,0x00,0x00,
0x07,0xC1,0xF8,0x00,0x00,0xFC,0x0F,0xC0,0x00,0x1F,
0x80,0x7C,0x00,0x01,0xF0,0x07,0xE0,0x00,0x3F,0x00,
0x3F,0x00,0x07,0xE0,0x01,0xF0,0x00,0x7C,0x00,0x1F,
0x80,0x0F,0xC0,0x80,0x1F,0x80,0x3F,0x00,0x00,0xFC,
0x07,0xE0,0x10,0x00,0xFC,0x1F,0x80,0x00,0x07,0xE3,
0xF0,0x00,0x00,0x3E,0x7E,0x00,0x00,0x03,0xF7,0xE0,
0x00,0x00,0x1F,0xFC,0x00,0x20,0x00,0x1F,0xF0,0x00,
0x00,0x00,0xFE,0x00,0x06,0x80,0x00,0xF8,0x00,0x0D,
0x00,0x01,0xF0,0x00,0x14,0x00,0x03,0xE0,0x00,0x00,
0x0F,0xD0,0x20,0x22,0xB1,0xFF,0xFF,0xFF,0xC0,0x00,
0x00,0x1F,0xC0,0x00,0x00,0x1F,0x80,0x00,0x00,0x3F,
0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0xFC,0x00,0x00,
0x01,0xFC,0x00,0x00,0x01,0xF8,0x00,0x00,0x03,0xF0,
0x00,0x00,0x07,0xE0,0x00,0x00,0x0F,0xC0,0x00,0x00,
0x1F,0xC0,0x00,0x00,0x1F,0x80,0x00,0x00,0x3F,0x00,
0x00,0x00,0x7E,0x00,0x00,0x00,0xFC,0x00,0x00,0x01,
0xFC,0x00,0x00,0x01,0xF8,0x00,0x00,0x03,0xF0,0x00,
0x00,0x07,0xE0,0x00,0x00,0x0F,0xC0,0x00,0x00,0x1F,
0xC0,0x00,0x00,0x1F,0x80,0x00,0x00,0x3F,0x00,0x00,
0x00,0x7E,0x00,0x00,0x00,0xFC,0x00,0x00,0x01,0xFC,
0x00,0x00,0x01,0xF8,0x00,0x00,0x03,0xF0,0x00,0x00,
0x07,0xE0,0x00,0x00,0x0F,0xC0,0x00,0x00,0x17,0xFF,
0xFF,0xFF,0xFC,0x05,0xE6,0x7D,0x50,0xBF,0xFF,0xBF,
0x03,0x7E,0x06,0xFC,0x0D,0xF8,0x1B,0xF0,0x33,0xE0,
0x5F,0xFF,0x08,0x50,0x20,0x10,0x8F,0x00,0x09,0x78,
0x00,0x93,0xC0,0x01,0xF0,0x04,0x8F,0x00,0x48,0x78,
0x04,0x83,0xC0,0x01,0xF0,0x24,0x0F,0x02,0x40,0x78,
0x24,0x03,0xC0,0x01,0xF1,0x20,0x0F,0x12,0x00,0x79,
0x20,0x03,0xC0,0x01,0xF0,0x00,0x78,0x05,0xE6,0x5D,
0x50,0xBF,0xFF,0xA0,0x7F,0x40,0xFE,0x81,0xFD,0x03,
0xFA,0x07,0xF0,0x0F,0xDF,0xFF,0x0B,0x2C,0x24,0xD8,
0x00,0x3C,0x01,0x20,0x1F,0x80,0x40,0x0F,0xF0,0x12,
0x07,0x9E,0x04,0x03,0xC3,0xC0,0x0F,0x87,0xC0,0x1E,
0x07,0x84,0x0F,0x81,0xF0,0x1E,0x01,0xE2,0x0F,0x80,
0x7C,0x97,0xC0,0x0F,0x9F,0x00,0x0F,0x80,0x10,0x0B,
0xFD,0x5F,0xBF,0xFF,0xFF,0xFF,0xF0,0x05,0x10,0x48,
0x13,0x7E,0x07,0xE0,0x7C,0x40,0xF8,0x0F,0x80,0xF0,
0x0F,0x0D,0xBC,0x40,0x1F,0x00,0x3F,0xF0,0x00,0x1F,
0xFF,0xC0,0x03,0xFF,0xFF,0x00,0x7F,0xFF,0xF0,0x0F,
0xFF,0xFF,0x81,0xFE,0x03,0xF8,0x1F,0x80,0x0F,0xC8,
0x7E,0x00,0x0F,0x81,0xC0,0x00,0xF8,0x00,0x00,0x0F,
0x80,0x00,0x03,0xF8,0x00,0x07,0xFF,0x80,0x1F,0xFF,
0xF8,0x0F,0xFF,0xFF,0x81,0xFF,0xFF,0xF8,0x3F,0xFF,
0xCF,0x87,0xFF,0x00,0xF8,0x7E,0x00,0x0F,0x8F,0xC0,
0x00,0xF9,0x1F,0x00,0x03,0xF1,0xF0,0x00,0x7F,0x1F,
0x80,0x0F,0xF1,0xFE,0x07,0xFF,0x0F,0xFF,0xFF,0xF0,
0xFF,0xFF,0xDF,0x87,0xFF,0xF9,0xF8,0x1F,0xFF,0x0F,
0x80,0x7F,0x80,0x7C,0x0C,0xD0,0x80,0x1F,0xDF,0x80,
0x00,0x04,0xFC,0x00,0x00,0x1F,0x07,0xE0,0x07,0xC7,
0xFF,0x01,0xF3,0xFF,0xE0,0x7D,0xFF,0xFC,0x1F,0xFF,
0xFF,0x87,0xFE,0x0F,0xF1,0xFE,0x00,0xFC,0x7F,0x00,
0x1F,0x9F,0xC0,0x03,0xE7,0xE0,0x00,0xF9,0xF8,0x00,
0x3F,0xDF,0x80,0x00,0xFB,0xE0,0x00,0x3E,0xF8,0x00,
0x1F,0xBF,0x00,0x07,0xCF,0xC0,0x03,0xF3,0xF8,0x00,
0xFC,0xFF,0x00,0x7E,0x3F,0xF0,0x7F,0x8F,0xFF,0xFF,
0xC3,0xEF,0xFF,0xE0,0xF9,0xFF,0xF0,0x3E,0x3F,0xF0,
0x0F,0x83,0xF0,0x00,0x0D,0x3C,0x40,0x1C,0x00,0x3F,
0xC0,0x00,0x1F,0xFF,0x00,0x0F,0xFF,0xF0,0x03,0xFF,
0xFF,0x00,0xFF,0xFF,0xF0,0x3F,0xC0,0xFF,0x07,0xE0,
0x07,0xE1,0xF8,0x00,0x7E,0x3E,0x00,0x0F,0xC7,0xC0,
0x00,0xE1,0xF8,0x00,0x00,0x6F,0xC0,0x00,0x00,0xF8,
0x00,0x00,0x1F,0x80,0x00,0xE1,0xF0,0x00,0x1F,0x3E,
0x00,0x07,0xE7,0xE0,0x01,0xF8,0x7E,0x00,0x7F,0x0F,
0xF0,0x1F,0xC0,0xFF,0xFF,0xF8,0x0F,0xFF,0xFE,0x00,
0xFF,0xFF,0x80,0x07,0xFF,0xC0,0x00,0x1F,0xC0,0x00,
0x0C,0xD0,0x40,0x1F,0xD0,0x00,0x00,0xFC,0x80,0x00,
0x07,0xC0,0x0F,0xC1,0xF0,0x1F,0xFC,0x7C,0x0F,0xFF,
0x9F,0x07,0xFF,0xF7,0xC3,0xFF,0xFF,0xF1,0xFE,0x0F,
0xFC,0x7E,0x00,0xFF,0x3F,0x00,0x1F,0xCF,0x80,0x07,
0xF3,0xE0,0x00,0xFD,0xF8,0x00,0x3F,0xDF,0x80,0x00,
0xFB,0xE0,0x00,0x3E,0xFC,0x00,0x1F,0xC3,0xE0,0x00,
0xFC,0xFC,0x00,0x7F,0x1F,0x80,0x3F,0xC7,0xF8,0x3F,
0xF0,0xFF,0xFF,0xFC,0x1F,0xFF,0xDF,0x03,0xFF,0xE7,
0xC0,0x3F,0xF1,0xF0,0x03,0xF0,0x7C,0x0D,0xBC,0x40,
0x1F,0x00,0x1F,0xC0,0x00,0x0F,0xFF,0x80,0x03,0xFF,
0xFE,0x00,0x7F,0xFF,0xF0,0x0F,0xFF,0xFF,0x80,0xFE,
0x03,0xFC,0x1F,0x80,0x0F,0xC3,0xF0,0x00,0x7E,0x3E,
0x00,0x03,0xE3,0xC0,0x00,0x1E,0x7C,0x00,0x01,0xFB,
0xFF,0xFF,0xFF,0xF3,0xF0,0x00,0x00,0x1F,0x80,0x00,
0x00,0xF8,0x00,0x06,0x0F,0xC0,0x00,0xFC,0xFE,0x00,
0x1F,0x87,0xF0,0x03,0xF8,0x7F,0xC0,0xFF,0x03,0xFF,
0xFF,0xF0,0x1F,0xFF,0xFE,0x00,0xFF,0xFF,0xC0,0x03,
0xFF,0xF0,0x00,0x07,0xF8,0x00,0x08,0xD0,0x00,0x10,
0x00,0x3F,0x80,0x3F,0xF8,0x07,0xFF,0x03,0xFF,0xC0,
0xFC,0x05,0x87,0xC0,0x2F,0xFF,0xF9,0xA1,0xF0,0x0D,
0x0F,0x80,0x68,0x7C,0x02,0x43,0xE0,0x00,0x0C,0xD2,
0x5D,0x5F,0x00,0x7F,0x00,0x00,0x7F,0xF1,0xF0,0x3F,
0xFF,0x7C,0x1F,0xFF,0xFF,0x0F,0xFF,0xFF,0xC7,0xF8,
0x3F,0xF1,0xF8,0x03,0xFC,0xFC,0x00,0x7F,0x3E,0x00,
0x1F,0xCF,0x80,0x03,0xF7,0xE0,0x00,0xFF,0x7E,0x00,
0x03,0xEF,0x80,0x00,0xFB,0xF0,0x00,0x7F,0x0F,0x80,
0x03,0xF3,0xF0,0x01,0xFC,0x7E,0x00,0xFF,0x1F,0xE0,
0xFF,0xC3,0xFF,0xFF,0xF0,0x7F,0xFF,0xFC,0x0F,0xFF,
0xDF,0x01,0xFF,0xC7,0xC0,0x0F,0xC1,0xF0,0x00,0x00,
0x7C,0xE0,0x00,0x1F,0x87,0xC0,0x01,0xF1,0xF8,0x00,
0xFC,0x3F,0x80,0xFE,0x0F,0xFF,0xFF,0x81,0xFF,0xFF,
0xC0,0x3F,0xFF,0xE0,0x07,0xFF,0xE0,0x00,0x3F,0xC0,
0x00,0x0B,0xD0,0x80,0x1F,0xDF,0x80,0x00,0x13,0xF0,
0x00,0x01,0xF0,0x7F,0x01,0xF1,0xFF,0xC1,0xF3,0xFF,
0xE1,0xF7,0xFF,0xF1,0xFF,0xFF,0xF9,0xFF,0x83,0xF9,
0xFE,0x01,0xFD,0xFC,0x00,0xFE,0x3F,0x00,0x0F,0xEF,
0xC0,0x01,0xFD,0xF8,0x00,0x3F,0x9F,0x00,0x07,0xC0,
0x02,0xD0,0x80,0x0D,0xBF,0xE0,0x37,0xFB,0xFD,0xFE,
0xFD,0xF0,0x05,0xE7,0xDD,0x4D,0xB0,0x3F,0x80,0x03,
0x40,0xFE,0x81,0xFD,0x03,0xFA,0x07,0xF0,0x0F,0x81,
0xFC,0x7F,0xE8,0xFF,0x8F,0xE0,0x0C,0x50,0x80,0x1D,
0xDF,0x80,0x00,0x0A,0xF8,0x00,0x00,0x7C,0x00,0x7E,
0x3E,0x00,0x7E,0x1F,0x00,0x7E,0x0F,0x80,0xFE,0x07,
0xC0,0xFE,0x03,0xE0,0xFE,0x01,0xF0,0xFE,0x00,0xF8,
0xFE,0x00,0x7C,0xFE,0x00,0x3E,0xFE,0x00,0x23,0xFF,
0xC0,0x02,0x3F,0xFE,0x00,0x1F,0xFF,0x80,0x0F,0xE7,
0xE0,0x07,0xE1,0xF0,0x03,0xE0,0xFC,0x01,0xF0,0x3F,
0x01,0x1F,0x01,0xF8,0x0F,0x80,0x7E,0x08,0xF8,0x03,
0xF0,0x7C,0x00,0xFC,0x47,0xC0,0x07,0xE3,0xE0,0x01,
0xF9,0xF0,0x00,0x7E,0x02,0xD0,0x60,0x0B,0xDF,0xEF,
0xF7,0xFB,0xFD,0xFD,0xFC,0x13,0xBC,0x80,0x2F,0x00,
0x1F,0x80,0x0F,0xC0,0x7C,0x7F,0xE0,0x3F,0xF8,0x7C,
0xFF,0xF0,0x7F,0xFC,0x7D,0xFF,0xF8,0xFF,0xFC,0x7D,
0xFF,0xFD,0xFF,0xFE,0x7F,0xC1,0xFF,0xE0,0xFE,0x7F,
0x80,0x7F,0xC0,0x3F,0x7F,0x00,0x7F,0x80,0x3F,0x8F,
0xC0,0x07,0xE0,0x03,0xFB,0xF0,0x00,0xF8,0x00,0x7F,
0x7E,0x00,0x1F,0x00,0x0F,0xE7,0xC0,0x03,0xE0,0x01,
0xF0,0x0B,0xBC,0x80,0x1F,0x00,0x1F,0xC0,0x7C,0x7F,
0xF0,0x7C,0xFF,0xF8,0x7D,0xFF,0xFC,0x7F,0xFF,0xFE,
0x7F,0xE0,0xFE,0x7F,0x80,0x7F,0x7F,0x00,0x3F,0x8F,
0xC0,0x03,0xFB,0xF0,0x00,0x7F,0x7E,0x00,0x0F,0xE7,
0xC0,0x01,0xF0,0x0D,0xBC,0x40,0x1F,0x00,0x1F,0xC0,
0x00,0x0F,0xFF,0x80,0x03,0xFF,0xFE,0x00,0x7F,0xFF,
0xF0,0x0F,0xFF,0xFF,0x81,0xFF,0x07,0xFC,0x1F,0xC0,
0x1F,0xC8,0x7E,0x00,0x0F,0xC7,0xC0,0x00,0x7C,0xFC,
0x00,0x07,0xFB,0xF0,0x00,0x07,0xDF,0x00,0x00,0x7D,
0xF8,0x00,0x0F,0xCF,0x80,0x00,0xFA,0x1F,0x80,0x03,
0xF0,0xFE,0x00,0xFE,0x0F,0xF8,0x3F,0xE0,0x7F,0xFF,
0xFC,0x03,0xFF,0xFF,0x80,0x1F,0xFF,0xF0,0x00,0x7F,
0xFC,0x00,0x01,0xFE,0x00,0x00,0x0C,0xD2,0x9D,0x5F,
0x00,0x1F,0xC0,0x1F,0x1F,0xFC,0x07,0xCF,0xFF,0x81,
0xF7,0xFF,0xF0,0x7D,0xFF,0xFE,0x1F,0xF8,0x3F,0xC7,
0xF8,0x03,0xF1,0xFC,0x00,0x7E,0x7F,0x00,0x0F,0x9F,
0x80,0x03,0xE7,0xE0,0x00,0xFF,0x7E,0x00,0x03,0xEF,
0x80,0x00,0xFC,0xFE,0x00,0x0F,0x9F,0xC0,0x07,0xE7,
0xF8,0x03,0xF1,0xFF,0x83,0xF8,0x7F,0xFF,0xFE,0x1F,
0x7F,0xFF,0x07,0xCF,0xFF,0x81,0xF1,0xFF,0x80,0x7C,
0x1F,0x80,0x37,0xE0,0x00,0x01,0x5F,0x00,0x00,0x00,
0x0C,0xD2,0x5D,0x5F,0x00,0x7F,0x00,0x00,0x7F,0xF1,
0xF0,0x3F,0xFE,0x7C,0x1F,0xFF,0xDF,0x0F,0xFF,0xF7,
0xC7,0xF8,0x3F,0xF1,0xF8,0x03,0xFC,0xFC,0x00,0x7F,
0x3E,0x00,0x1F,0xCF,0x80,0x03,0xF7,0xE0,0x00,0xFF,
0x7E,0x00,0x03,0xEF,0x80,0x00,0xFB,0xF0,0x00,0x7F,
0x0F,0x80,0x03,0xF3,0xF0,0x01,0xFC,0x7E,0x00,0xFF,
0x0F,0xE0,0xFF,0xC3,0xFF,0xFF,0xF0,0x7F,0xFF,0x7C,
0x0F,0xFF,0x9F,0x00,0xFF,0xC7,0xC0,0x0F,0xC1,0xFD,
0x00,0x00,0x0F,0xD0,0x00,0x00,0x7C,0x08,0x3C,0x80,
0x13,0x00,0x7C,0x3C,0x7F,0x9E,0x7F,0xEF,0x7F,0xE7,
0xFF,0xF3,0xFC,0x19,0xFC,0x01,0x3F,0x80,0x1B,0xF0,
0x01,0xBF,0x00,0x19,0xF0,0x00,0x0C,0x3C,0x40,0x1C,
0x00,0x7F,0x00,0x01,0xFF,0xF0,0x01,0xFF,0xFC,0x01,
0xFF,0xFF,0x01,0xFF,0xFF,0xC0,0xFC,0x0F,0xE0,0xFC,
0x01,0xF8,0x7C,0x00,0x7C,0x3E,0x00,0x38,0x1F,0x80,
0x00,0x0F,0xE0,0x00,0x03,0xFF,0x00,0x01,0xFF,0xF0,
0x00,0x7F,0xFF,0x00,0x1F,0xFF,0xE0,0x03,0xFF,0xFC,
0x00,0x7F,0xFF,0x00,0x07,0xFF,0x80,0x00,0x3F,0xE0,
0x00,0x03,0xF1,0xC0,0x00,0xFB,0xE0,0x00,0x7D,0xF8,
0x00,0x3E,0x7E,0x00,0x3F,0x3F,0xC0,0x7F,0x41,0xFF,
0xFF,0xE0,0x7F,0xFF,0xE0,0x0F,0xFF,0xC0,0x00,0xFF,
0x00,0x07,0xCE,0x20,0x10,0x00,0x40,0x01,0xC0,0x03,
0xC0,0xD0,0xF8,0x17,0xFF,0xFB,0x43,0xE0,0x68,0x7C,
0x0A,0x0F,0x80,0x0F,0xC1,0x01,0xFF,0x80,0xFF,0xC0,
0x7F,0xC0,0x3F,0xC0,0x0B,0xBA,0x80,0x1F,0xDF,0x80,
0x03,0xFB,0xF0,0x00,0x7E,0xFE,0x00,0x0F,0xC7,0xC0,
0x03,0xF7,0xE0,0x07,0xF7,0xF0,0x0F,0xF3,0xF8,0x3F,
0xF3,0xFF,0xFD,0xF1,0xFF,0xFD,0xF1,0xFF,0xF9,0xF0,
0x7F,0xE1,0xF0,0x1F,0x81,0xF0,0x0D,0xBA,0x20,0x1D,
0x7C,0x00,0x01,0xF8,0x7C,0x00,0x07,0xC7,0xE0,0x00,
0xFD,0x07,0xC0,0x01,0xF0,0x7E,0x00,0x3F,0x20,0x7C,
0x00,0x7C,0x07,0xE0,0x0F,0xC4,0x07,0xC0,0x1F,0x00,
0x3E,0x03,0xF0,0x03,0xE0,0x3E,0x00,0x3F,0x07,0xE0,
0x80,0x3E,0x0F,0x80,0x03,0xF1,0xF8,0x10,0x03,0xE3,
0xE0,0x00,0x3F,0x7E,0x02,0x00,0x3E,0xF8,0x00,0x01,
0xFF,0x80,0x40,0x03,0xFE,0x00,0x90,0x03,0xF8,0x00,
0x13,0xBA,0x00,0x27,0x7C,0x00,0x3E,0x00,0x1F,0x8F,
0x80,0x0F,0xE0,0x03,0xF0,0xF8,0x01,0xFC,0x00,0xF8,
0xF8,0x03,0xFE,0x00,0xF8,0x7C,0x03,0xFE,0x01,0xF2,
0x0F,0x80,0x7B,0xC0,0x3E,0x40,0xF8,0x1F,0x7C,0x0F,
0x80,0xF8,0x1E,0x7C,0x0F,0x80,0x7C,0x1E,0x3C,0x1F,
0x08,0x0F,0x87,0xC7,0xC3,0xE0,0x07,0x87,0xC7,0xC7,
0xC0,0x07,0xC7,0x83,0xC7,0xC1,0x00,0xF9,0xF0,0x7C,
0xF8,0x00,0x7D,0xF0,0x7D,0xF0,0x20,0x0F,0xBC,0x07,
0xBE,0x04,0x00,0xFF,0x80,0xFF,0x80,0x00,0xFF,0x00,
0xFF,0x80,0x90,0x0F,0xE0,0x0F,0xE0,0x00,0x07,0xE0,
0x0F,0xC0,0x00,0x0E,0x3A,0x00,0x1C,0x3F,0x00,0x01,
0xF8,0xFC,0x00,0x1F,0x83,0xF0,0x01,0xF9,0x01,0xF8,
0x03,0xF0,0x07,0xE0,0x3F,0x00,0x1F,0x83,0xF0,0x00,
0xFC,0x3F,0x00,0x03,0xF1,0xF8,0x00,0x0F,0xDF,0x80,
0x00,0x3F,0xF8,0x00,0x01,0xFF,0x80,0x00,0x07,0xFC,
0x01,0x00,0x03,0xF8,0x00,0x00,0x3F,0xC0,0x00,0x03,
0xFF,0x00,0x00,0x1F,0xFC,0x00,0x01,0xFF,0xE0,0x00,
0x1F,0x9F,0x80,0x01,0xF8,0x7E,0x00,0x0F,0xC1,0xF8,
0x00,0xFC,0x0F,0xC0,0x0F,0xC0,0x3F,0x08,0x1F,0x80,
0x1F,0x81,0xF8,0x00,0x7E,0x1F,0x80,0x01,0xF9,0xF8,
0x00,0x07,0xE0,0x0C,0xD0,0x3D,0x5B,0x7C,0x00,0x07,
0xCF,0x80,0x03,0xF8,0x7C,0x00,0x1F,0x0F,0x80,0x0F,
0xC3,0xE0,0x03,0xE0,0xFC,0x00,0xF8,0x1F,0x00,0x7E,
0x07,0xC0,0x1F,0x01,0xF8,0x07,0xC0,0x3E,0x03,0xF0,
0x0F,0x80,0xF8,0x03,0xF0,0x3E,0x00,0x7C,0x1F,0x80,
0x1F,0x07,0xC0,0x07,0xE1,0xF0,0x00,0xF8,0xFC,0x00,
0x3E,0x3E,0x00,0x07,0xCF,0x80,0x01,0xF7,0xE0,0x00,
0x7D,0xF0,0x00,0x0F,0xFC,0x04,0x00,0x7F,0xC0,0x00,
0x0F,0xF0,0x08,0x00,0x7F,0x00,0x00,0x0F,0xC0,0x10,
0x00,0x7C,0x00,0x00,0x3F,0x00,0x00,0x0F,0x80,0x08,
0x00,0xFC,0x00,0x00,0x7E,0x00,0x03,0xFF,0x80,0x00,
0xFF,0xC0,0x00,0x1F,0xE0,0x00,0x07,0xF0,0x00,0x01,
0xF8,0x00,0x00,0x0C,0xBA,0x20,0x1B,0xB3,0xFF,0xFF,
0xF0,0x00,0x01,0xF8,0x00,0x00,0xFC,0x00,0x00,0x7E,
0x00,0x00,0x3F,0x00,0x00,0x1F,0x80,0x00,0x0F,0xE0,
0x00,0x07,0xF0,0x00,0x03,0xF8,0x00,0x00,0xFC,0x00,
0x00,0x7E,0x00,0x00,0x3F,0x00,0x00,0x1F,0x80,0x00,
0x0F,0xC0,0x00,0x07,0xE0,0x00,0x03,0xF8,0x00,0x01,
0xFC,0x00,0x00,0xFE,0x00,0x00,0x3F,0x00,0x00,0x1F,
0x80,0x00,0x17,0xFF,0xFF,0xFF,0x08,0xE6,0x3D,0x53,
0x00,0x0F,0xC0,0x0F,0xF0,0x07,0xFE,0x00,0x7F,0xE0,
0x3F,0x80,0x0F,0xC1,0xA0,0x7C,0x0B,0x03,0xE0,0x40,
0x3E,0x00,0x1F,0x80,0x0F,0xC0,0x1F,0xE0,0x07,0xF0,
0x01,0xF0,0x00,0x7F,0x00,0x1F,0xE0,0x01,0xFC,0x00,
0x1F,0x80,0x80,0x7C,0x06,0x81,0xF0,0x30,0x0F,0x80,
0x03,0xF8,0x40,0x0F,0xFC,0x01,0xFF,0x00,0x3F,0xC0,
0x03,0xF0,0x02,0x6A,0xBC,0xCE,0xDF,0xDF,0xDF,0xDF,
0xDF,0xDF,0xDF,0xAF,0x08,0xE6,0x3D,0x53,0x7E,0x00,
0x1F,0xE0,0x07,0xFC,0x02,0x3F,0xF0,0x00,0xFE,0x00,
0x1F,0x81,0xA0,0x7C,0x0B,0x03,0xE0,0x00,0xFC,0x00,
0x1F,0x00,0x07,0xE0,0x00,0xFC,0x00,0x1F,0xE0,0x03,
0xF8,0x00,0x3E,0x00,0x3F,0x80,0x1F,0xE0,0x0F,0xC0,
0x07,0xE0,0x01,0xF0,0x00,0xFC,0x1A,0x07,0xC0,0xB0,
0x3E,0x00,0x1F,0x80,0x0F,0xE0,0x47,0xFE,0x01,0xFF,
0x00,0x7F,0x80,0x1F,0x80,0x00,0x0E,0x14,0x43,0xA1,
0x03,0xE0,0x00,0x00,0x7F,0xE0,0x00,0x47,0xFF,0xC0,
0x06,0x7F,0xFF,0x80,0x77,0xFF,0xFF,0x0F,0xBE,0x0F,
0xFF,0xFD,0xC0,0x1F,0xFF,0xCC,0x00,0x7F,0xFC,0x40,
0x00,0xFF,0xC0,0x00,0x01,0xF8,0x00,};
/* font data size: 7477 bytes */

static const unsigned char font_tgx_Arial_40_index[] = {
0x00,0x00,0x01,
0x00,0x20,0x01,0xC0,0x32,0x03,0xD8,0x3B,0x62,0x79,
0x14,0x08,0xAF,0xC5,0xFA,0x32,0x31,0x9D,0x8D,0x14,
0x69,0x83,0x52,0x1B,0xF8,0xF4,0x07,0xF0,0x46,0xE2,
0x75,0x94,0xFC,0xB3,0xA6,0x12,0x32,0xD1,0xB1,0x0E,
0x64,0x73,0xC3,0xA5,0x1E,0xB4,0xF7,0xA8,0x20,0x44,
0x3A,0x79,0x14,0xDA,0xAE,0x75,0xBE,0xAF,0xBD,0x82,
0x0C,0x2F,0x66,0x43,0x3A,0x99,0xEA,0xD2,0x26,0xE2,
0xB7,0x79,0xC7,0x0E,0xB8,0x7A,0x83,0xEA,0x20,0x95,
0x0E,0x08,0xC0,0xC6,0x82,0x3C,0x92,0x5F,0x99,0xCC,
0xF7,0x28,0x8D,0x4C,0xBA,0x6F,0x54,0x2E,0xA3,0xD5,
0x48,0xAA,0x8D,0x57,0xEB,0x8D,0x62,0x0B,0x3B,0x5B,
0x36,0xE4,0xD7,0x46,0xBD,0xBD,0xFA,0x2F,0xE9,0x80,
0xCC,0x32,0x61,0xBF,0x16,0x38,0xDB,0xC9,0x76,0x60,
0xB3,0xB3,0x9F,0x6D,0x2A,0xE9,0xDB,0x54,0x1A,0xEA,
0xDA,0x8E,0xED,0x78,0x5B,0xC7,0x6E,0x5C,0x73,0x13,
0xA1,0x80,
};
/* font index size: 155 bytes */

const ILI9341_t3_font_t font_tgx_Arial_40 = {
	font_tgx_Arial_40_index,
	0,
	font_tgx_Arial_40_data,
	1,
	0,
	32,
	126,
	0,
	0,
	13,
	6,
	6,
	4,
	7,
	6,
	61,
	40
};



static const unsigned char font_tgx_Arial_48_data[] = {
0x00,0x00,0x00,0x02,0x60,0x01,0xB0,0x40,0x02,0xDB,
0xFE,0xFF,0x3F,0x9F,0xD7,0xAD,0xE1,0xD8,0x65,0x81,
0x9F,0x80,0x04,0x91,0x19,0xF3,0x1B,0xF8,0x1F,0xD7,
0xE0,0x7F,0x8F,0x00,0xF0,0x09,0x30,0x00,0x04,0xB0,
0x00,0x0F,0xC0,0x3F,0x00,0x00,0xFE,0x03,0xF0,0xA0,
0x00,0xFC,0x03,0xF0,0x00,0x0F,0xE0,0x3F,0x05,0x00,
0x0F,0xC0,0x3F,0x00,0x00,0xFE,0x03,0xF0,0x33,0xFF,
0xFF,0xFF,0xFF,0xE0,0x01,0xF8,0x07,0xE0,0x00,0x0F,
0xC0,0x7F,0x01,0x40,0x1F,0x80,0x7E,0x00,0x01,0xFC,
0x07,0xE0,0x08,0x01,0xF8,0x07,0xE0,0x0C,0xFF,0xFF,
0xFF,0xFF,0xF0,0x1F,0x80,0xFE,0x00,0x50,0x3F,0x00,
0xFC,0x00,0x01,0xF8,0x0F,0xE0,0x02,0x83,0xF0,0x0F,
0xC0,0x00,0x1F,0x80,0xFE,0x00,0x10,0x3F,0x00,0xFC,
0x00,0x00,0x07,0xFA,0x1F,0x94,0xB2,0x00,0x07,0x00,
0x00,0x00,0x3F,0xE0,0x00,0x01,0xFF,0xFC,0x00,0x07,
0xFF,0xFF,0x00,0x0F,0xFF,0xFF,0x80,0x1F,0xFF,0xFF,
0xC0,0x3F,0xFF,0xFF,0xE0,0x7F,0xE7,0x3F,0xE0,0x7F,
0x87,0x0F,0xF0,0x7F,0x07,0x07,0xF0,0xFE,0x07,0x03,
0xF0,0xFC,0x07,0x03,0xF8,0xFC,0x07,0x01,0xF8,0xFC,
0x07,0x01,0xC2,0x1F,0x80,0xE0,0x00,0x1F,0xC0,0xE0,
0x00,0x0F,0xC0,0xE0,0x00,0x0F,0xE0,0xE0,0x00,0x0F,
0xF8,0xE0,0x00,0x07,0xFE,0xE0,0x00,0x03,0xFF,0xE0,
0x00,0x01,0xFF,0xFC,0x00,0x00,0xFF,0xFF,0x80,0x00,
0x3F,0xFF,0xE0,0x00,0x0F,0xFF,0xF0,0x00,0x01,0xFF,
0xFC,0x00,0x00,0xFF,0xFC,0x00,0x00,0xE3,0xFE,0x00,
0x00,0xE0,0xFF,0x00,0x00,0xE0,0x7F,0x00,0x00,0xE0,
0x3F,0x00,0x00,0xE0,0x3F,0xC0,0x00,0x1C,0x03,0xF0,
0xE0,0x1C,0x03,0xF7,0xE0,0x1C,0x03,0xF7,0xF0,0x1C,
0x03,0xF7,0xF0,0x1C,0x07,0xF3,0xF0,0x1C,0x07,0xF3,
0xF8,0x1C,0x0F,0xE3,0xFC,0x1C,0x1F,0xE1,0xFE,0x1C,
0x3F,0xC1,0xFF,0x9C,0xFF,0xC0,0xFF,0xFF,0xFF,0x80,
0x7F,0xFF,0xFF,0x00,0x3F,0xFF,0xFE,0x00,0x1F,0xFF,
0xFC,0x00,0x07,0xFF,0xF0,0x00,0x00,0xFF,0x80,0x0C,
0x00,0x03,0x80,0x00,0x0D,0x32,0x27,0xF7,0x80,0x1F,
0x80,0x00,0x00,0x7E,0x00,0x03,0xFF,0x00,0x00,0x03,
0xE0,0x00,0x7F,0xFC,0x00,0x00,0x3F,0x00,0x03,0xFF,
0xF0,0x00,0x03,0xF0,0x00,0x3F,0x0F,0xC0,0x00,0x1F,
0x00,0x03,0xF0,0x3F,0x00,0x01,0xF8,0x00,0x1F,0x00,
0xF8,0x00,0x0F,0x80,0x00,0xF8,0x07,0xC0,0x00,0xFC,
0x00,0x0F,0x80,0x1F,0x00,0x07,0xC0,0x00,0x7C,0x00,
0xF8,0x00,0x7E,0x00,0x03,0xE0,0x07,0xC0,0x03,0xE0,
0x00,0x1F,0x00,0x3E,0x00,0x3F,0x00,0x01,0x1F,0x00,
0x3E,0x00,0x7E,0x00,0x00,0xF8,0x01,0xF0,0x07,0xE0,
0x00,0x07,0xC0,0x0F,0x80,0x3E,0x00,0x00,0x3E,0x00,
0x7C,0x03,0xF0,0x00,0x01,0xF0,0x03,0xE0,0x1F,0x00,
0x00,0x07,0xC0,0x3E,0x01,0xF8,0x00,0x00,0x3E,0x01,
0xF0,0x0F,0x80,0x00,0x01,0xF8,0x1F,0x00,0xFC,0x00,
0x00,0x07,0xE1,0xF8,0x07,0xC0,0x00,0x00,0x1F,0xFF,
0x80,0x7E,0x00,0x00,0x00,0x7F,0xF8,0x07,0xE0,0x00,
0x00,0x01,0xFF,0x80,0x3F,0x00,0x7E,0x00,0x03,0xF0,
0x03,0xF0,0x0F,0xFC,0x00,0x00,0x00,0x1F,0x01,0xFF,
0xF0,0x00,0x00,0x01,0xF8,0x0F,0xFF,0xC0,0x00,0x00,
0x0F,0x80,0xFC,0x3F,0x00,0x00,0x00,0xFC,0x0F,0xC0,
0xFC,0x00,0x00,0x07,0xC0,0x7C,0x03,0xE0,0x00,0x00,
0x7E,0x03,0xE0,0x1F,0x00,0x00,0x03,0xE0,0x3E,0x00,
0x7C,0x00,0x00,0x3F,0x01,0xF0,0x03,0xF0,0x00,0x00,
0x7E,0x01,0xF0,0x03,0xE0,0x00,0x07,0xE0,0x0F,0x80,
0x1F,0x00,0x00,0x3E,0x00,0x7C,0x00,0xF8,0x00,0x03,
0xF0,0x03,0xE0,0x07,0xC0,0x00,0x1F,0x00,0x1F,0x00,
0x3E,0x00,0x01,0xF8,0x00,0xF8,0x01,0xF0,0x00,0x0F,
0x80,0x07,0xC0,0x0F,0x80,0x00,0xFC,0x00,0x1F,0x00,
0xF8,0x00,0x07,0xC0,0x00,0xF8,0x07,0xC0,0x00,0x7E,
0x00,0x07,0xE0,0x7C,0x00,0x07,0xE0,0x00,0x1F,0x87,
0xE0,0x00,0x3E,0x00,0x00,0x7F,0xFE,0x00,0x03,0xF0,
0x00,0x01,0xFF,0xE0,0x00,0x1F,0x00,0x00,0x07,0xFE,
0x00,0x01,0xF8,0x00,0x00,0x0F,0xC0,0x00,0x0A,0x32,
0x1F,0xF5,0xA0,0x00,0x3F,0x80,0x00,0x00,0x00,0x7F,
0xF8,0x00,0x00,0x00,0xFF,0xFE,0x00,0x00,0x00,0xFF,
0xFF,0x80,0x00,0x00,0xFF,0xFF,0xE0,0x00,0x00,0xFF,
0xFF,0xF8,0x00,0x00,0x7F,0x83,0xFC,0x00,0x00,0x3F,
0x80,0xFF,0x00,0x00,0x3F,0x80,0x3F,0x80,0x0A,0x03,
0xF0,0x01,0xF8,0x00,0x01,0xFC,0x00,0xFC,0x00,0x00,
0x7E,0x00,0xFC,0x00,0x00,0x3F,0x80,0xFE,0x00,0x00,
0x0F,0xE0,0xFE,0x00,0x00,0x07,0xF0,0xFE,0x00,0x00,
0x01,0xFD,0xFE,0x00,0x00,0x00,0x7F,0xFE,0x00,0x00,
0x00,0x3F,0xFE,0x00,0x00,0x00,0x0F,0xFC,0x00,0x00,
0x00,0x1F,0xFC,0x00,0x00,0x00,0x1F,0xFE,0x00,0x00,
0x00,0x3F,0xFF,0x80,0x00,0x00,0x3F,0xEF,0xE0,0x00,
0x00,0x3F,0xC7,0xF8,0x00,0x00,0x3F,0xC1,0xFE,0x03,
0xC0,0x3F,0xC0,0x7F,0x03,0xF8,0x1F,0xC0,0x1F,0xC1,
0xFC,0x1F,0xC0,0x07,0xF0,0xFC,0x0F,0xC0,0x03,0xFC,
0xFE,0x0F,0xE0,0x00,0xFF,0x7E,0x07,0xE0,0x00,0x3F,
0xFF,0x03,0xF0,0x00,0x0F,0xFF,0x01,0xF8,0x00,0x03,
0xFF,0x80,0xFC,0x00,0x01,0xFF,0x80,0x7E,0x00,0x00,
0x7F,0xC0,0x3F,0x80,0x00,0x1F,0xE0,0x1F,0xC0,0x00,
0x1F,0xF8,0x07,0xF0,0x00,0x1F,0xFE,0x03,0xFC,0x00,
0x1F,0xFF,0x80,0xFF,0x00,0x1F,0xFF,0xE0,0x7F,0xE0,
0x7F,0xF7,0xF8,0x1F,0xFF,0xFF,0xF3,0xFE,0x07,0xFF,
0xFF,0xF0,0xFF,0x81,0xFF,0xFF,0xF0,0x3F,0x80,0x7F,
0xFF,0xE0,0x0F,0x80,0x0F,0xFF,0xC0,0x03,0x80,0x00,
0xFF,0x00,0x00,0x80,0x01,0x91,0x19,0xF1,0xBB,0xFD,
0x7F,0x8F,0x00,0x04,0x3D,0x27,0x32,0xC0,0x00,0xF0,
0x00,0xF0,0x00,0xF8,0x00,0xF8,0x00,0x78,0x00,0x7C,
0x40,0x0F,0x84,0x01,0xF0,0x40,0x3E,0x04,0x07,0xC0,
0x07,0xE0,0x03,0xE0,0x10,0x7E,0x00,0x3E,0x00,0xA7,
0xE0,0x03,0xE0,0x06,0xFE,0x00,0x67,0xE0,0x05,0xBF,
0x00,0x49,0xF8,0x00,0x7C,0x00,0x3F,0x01,0x01,0xF0,
0x10,0x0F,0x81,0x00,0x7C,0x10,0x03,0xE0,0x00,0xF8,
0x00,0x3C,0x00,0x1F,0x00,0x07,0x80,0x01,0xE0,0x00,
0x78,0x04,0x3D,0x17,0x32,0xCF,0x00,0x03,0xC0,0x01,
0xF0,0x00,0x7C,0x00,0x1E,0x00,0x0F,0x80,0x40,0x7C,
0x04,0x03,0xE0,0x40,0x1F,0x04,0x00,0xF8,0x00,0x7E,
0x00,0x1F,0x10,0x01,0xF8,0x00,0x7C,0xB0,0x07,0xED,
0x00,0x3F,0xC0,0x03,0xFA,0x00,0x7E,0x00,0x3E,0x48,
0x07,0xE0,0x03,0xE0,0x03,0xF1,0x00,0x3E,0x10,0x07,
0xC1,0x00,0xF8,0x10,0x1F,0x00,0x1F,0x00,0x0F,0x00,
0x0F,0x80,0x07,0x80,0x07,0x80,0x07,0x80,0x00,0x05,
0xD4,0x11,0xC3,0x56,0x00,0xF8,0x00,0xE0,0xF8,0x38,
0xFC,0x71,0xF8,0xFF,0x7F,0xF9,0xFF,0xFF,0xFC,0x7F,
0xFF,0xF0,0x03,0xFF,0x00,0x01,0xFC,0x00,0x03,0xFE,
0x00,0x07,0xDF,0x00,0x0F,0x9F,0x80,0x1F,0x8F,0xC2,
0x07,0xE0,0xFC,0x01,0xC0,0x70,0x00,0x80,0x20,0x00,
0x08,0x20,0x18,0x74,0xFA,0x00,0x0F,0xC0,0x01,0x80,
0x00,0xFC,0x00,0x19,0xFF,0xFF,0xFF,0xFF,0xA0,0x00,
0xFC,0x00,0x18,0x00,0x0F,0xC0,0x00,0x01,0x90,0x37,
0x62,0x79,0xFD,0x0E,0x3E,0x0E,0x38,0xF0,0xC0,0x04,
0x86,0x10,0xE2,0xD9,0xFF,0xFF,0x80,0x01,0x86,0x30,
0x02,0x79,0xF8,0x04,0xF0,0x00,0x02,0x70,0x00,0x07,
0xE4,0x00,0x1F,0x00,0x03,0xF4,0x80,0x07,0xC9,0x00,
0x1F,0x00,0x03,0xF1,0x00,0x07,0xC0,0x00,0xFC,0x24,
0x01,0xF0,0x48,0x07,0xC0,0x00,0xFC,0x09,0x01,0xF0,
0x12,0x07,0xC0,0x00,0xFC,0x02,0x41,0xF0,0x04,0x87,
0xC0,0x00,0xFC,0x00,0x81,0xF0,0x00,0x3F,0x00,0x12,
0x7C,0x00,0x25,0xF0,0x00,0x3F,0x00,0x03,0xE0,0x00,
0x00,0x07,0xF1,0x1F,0xF4,0xA0,0x01,0xFF,0x00,0x00,
0x07,0xFF,0xC0,0x00,0x1F,0xFF,0xF0,0x00,0x3F,0xFF,
0xF8,0x00,0x7F,0xFF,0xFC,0x00,0xFF,0xFF,0xFE,0x01,
0xFF,0x83,0xFE,0x01,0xFE,0x00,0xFF,0x03,0xF8,0x00,
0x7F,0x03,0xF8,0x00,0x3F,0x83,0xF0,0x00,0x1F,0x87,
0xF0,0x00,0x1F,0x94,0xFC,0x00,0x01,0xF9,0xF8,0x00,
0x00,0xFB,0x7F,0x00,0x00,0x1F,0xEF,0xE0,0x00,0x03,
0xF8,0xFC,0x00,0x00,0x7F,0x4F,0xC0,0x00,0x1F,0x8F,
0xE0,0x00,0x3F,0x87,0xE0,0x00,0x3F,0x07,0xF0,0x00,
0x7F,0x07,0xF8,0x00,0xFF,0x03,0xFC,0x01,0xFE,0x03,
0xFF,0x07,0xFE,0x01,0xFF,0xFF,0xFC,0x00,0xFF,0xFF,
0xF8,0x00,0x7F,0xFF,0xF0,0x00,0x3F,0xFF,0xE0,0x00,
0x1F,0xFF,0x80,0x00,0x03,0xFE,0x00,0x00,0x04,0x70,
0x38,0x04,0xA0,0x00,0x7C,0x00,0x07,0xC0,0x03,0xF0,
0x01,0xFC,0x00,0xFF,0x00,0x7F,0xC0,0x3F,0xF0,0x1F,
0xFC,0x1F,0xFF,0x0F,0xFF,0xCF,0xFB,0xF7,0xFC,0xFD,
0xFE,0x3F,0x7E,0x0F,0xDE,0x03,0xF7,0x00,0xFF,0x40,
0x07,0xFA,0x00,0x3F,0xD0,0x01,0xFE,0x80,0x0F,0xE4,
0x00,0x7E,0x07,0xF0,0x10,0x04,0xA0,0x00,0xFF,0x80,
0x00,0x07,0xFF,0xF0,0x00,0x1F,0xFF,0xF8,0x00,0x7F,
0xFF,0xFE,0x10,0x1F,0xFF,0xFF,0xE0,0x3F,0xF0,0x3F,
0xF0,0x7F,0x80,0x07,0xF8,0x7F,0x00,0x03,0xF8,0x7E,
0x00,0x01,0xF8,0xFE,0x00,0x01,0xFE,0x1F,0x80,0x00,
0x1F,0x83,0x80,0x00,0x1F,0xC8,0x00,0x00,0x03,0xF8,
0x00,0x00,0x00,0xFC,0x00,0x00,0x01,0xFC,0x00,0x00,
0x03,0xF8,0x00,0x00,0x07,0xF8,0x00,0x00,0x0F,0xF0,
0x00,0x00,0x1F,0xE0,0x00,0x00,0x3F,0xC0,0x00,0x00,
0x7F,0xC0,0x00,0x00,0xFF,0x80,0x00,0x01,0xFF,0x00,
0x00,0x03,0xFE,0x00,0x00,0x07,0xF8,0x00,0x00,0x0F,
0xF0,0x00,0x00,0x1F,0xE0,0x00,0x00,0x7F,0xC0,0x00,
0x00,0xFF,0x80,0x00,0x01,0xFF,0x00,0x00,0x03,0xFE,
0x00,0x00,0x07,0xF8,0x00,0x00,0x0F,0xF0,0x00,0x00,
0x0F,0xE0,0x00,0x00,0x1F,0xC0,0x00,0x01,0x07,0xF0,
0x00,0x00,0x21,0xFF,0xFF,0xFF,0xFD,0x7F,0xFF,0xFF,
0xFF,0x07,0xF1,0x1F,0xF4,0xA0,0x03,0xFC,0x00,0x00,
0x1F,0xFF,0x80,0x00,0x3F,0xFF,0xE0,0x00,0xFF,0xFF,
0xF0,0x01,0xFF,0xFF,0xF8,0x01,0xFF,0xFF,0xFC,0x03,
0xFE,0x03,0xFE,0x07,0xF8,0x01,0xFE,0x07,0xF0,0x00,
0x7E,0x07,0xE0,0x00,0x7F,0x0F,0xE0,0x00,0x3F,0x0F,
0xC0,0x00,0x3F,0x01,0xC0,0x00,0x3F,0x10,0x00,0x00,
0x07,0xE0,0x00,0x00,0x0F,0xC0,0x00,0x00,0x1F,0xC0,
0x00,0x00,0x3F,0x80,0x00,0x00,0xFF,0x00,0x00,0x1F,
0xFE,0x00,0x00,0x1F,0xFC,0x00,0x00,0x1F,0xF8,0x00,
0x00,0x1F,0xFF,0x00,0x00,0x1F,0xFF,0x80,0x00,0x18,
0xFF,0xC0,0x00,0x00,0x1F,0xE0,0x00,0x00,0x07,0xF0,
0x00,0x00,0x03,0xFA,0x00,0x00,0x00,0x3F,0x58,0x00,
0x00,0x03,0xF0,0xE0,0x00,0x03,0xF7,0xE0,0x00,0x03,
0xF7,0xF0,0x00,0x07,0xF7,0xF0,0x00,0x07,0xE3,0xF8,
0x00,0x0F,0xE3,0xFC,0x00,0x1F,0xC1,0xFE,0x00,0x3F,
0xC1,0xFF,0x80,0xFF,0x80,0xFF,0xFF,0xFF,0x00,0x7F,
0xFF,0xFE,0x00,0x3F,0xFF,0xFC,0x00,0x1F,0xFF,0xF8,
0x00,0x07,0xFF,0xE0,0x00,0x00,0xFF,0x00,0x00,0x08,
0x6F,0x08,0x04,0xA0,0x00,0x00,0x3E,0x00,0x00,0x00,
0x1F,0x80,0x00,0x00,0x0F,0xE0,0x40,0x00,0x00,0xFF,
0x00,0x00,0x00,0x7F,0xC0,0x00,0x00,0x3F,0xF0,0x20,
0x00,0x03,0xFF,0x80,0x00,0x01,0xFF,0xE0,0x40,0x00,
0x1F,0xFF,0x00,0x00,0x0F,0xEF,0xC0,0x00,0x07,0xF3,
0xF0,0x00,0x03,0xFC,0xFC,0x00,0x00,0xFE,0x3F,0x00,
0x00,0x7F,0x0F,0xC0,0x00,0x3F,0x83,0xF0,0x00,0x1F,
0xE0,0xFC,0x00,0x07,0xF0,0x3F,0x00,0x03,0xF8,0x0F,
0xC0,0x01,0xFC,0x03,0xF0,0x00,0xFF,0x00,0xFC,0x00,
0x3F,0x80,0x3F,0x00,0x1F,0xC0,0x0F,0xC0,0x0F,0xF0,
0x03,0xF0,0x03,0xF8,0x00,0xFC,0x01,0xFC,0x00,0x3F,
0x00,0xFE,0x00,0x0F,0xC0,0x7F,0x80,0x03,0xF0,0x33,
0xFF,0xFF,0xFF,0xFF,0xA0,0x00,0x00,0xFC,0x0A,0x00,
0x00,0x07,0xE0,0x00,0x07,0xF0,0x1F,0xF4,0xB0,0x07,
0xFF,0xFF,0xE2,0x81,0xFF,0xFF,0xFC,0x01,0xF8,0x00,
0x00,0x03,0xF8,0x00,0x00,0x50,0x7E,0x00,0x00,0x08,
0x1F,0xC0,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x83,
0xF8,0x00,0x1F,0x9F,0xFE,0x00,0x3F,0xBF,0xFF,0x80,
0x3F,0xFF,0xFF,0xC0,0x3F,0xFF,0xFF,0xE0,0x3F,0xFF,
0xFF,0xF0,0x3F,0xF0,0x1F,0xF8,0x7F,0xC0,0x07,0xF8,
0x7F,0x80,0x03,0xFC,0x7F,0x00,0x01,0xFC,0x0E,0x00,
0x00,0xFC,0x00,0x00,0x00,0xFF,0xA0,0x00,0x00,0x0F,
0xC0,0x00,0x00,0x0F,0xE3,0xF0,0x00,0x03,0xF3,0xF8,
0x00,0x03,0xF1,0xF8,0x00,0x07,0xE1,0xFC,0x00,0x0F,
0xE0,0xFE,0x00,0x1F,0xC0,0xFF,0x80,0x7F,0xC0,0x7F,
0xFF,0xFF,0x80,0x3F,0xFF,0xFF,0x00,0x1F,0xFF,0xFE,
0x00,0x0F,0xFF,0xFC,0x00,0x03,0xFF,0xF0,0x00,0x00,
0x7F,0x80,0x00,0x08,0x31,0x17,0xF4,0xA0,0x00,0x7F,
0x80,0x00,0x01,0xFF,0xF8,0x00,0x03,0xFF,0xFF,0x00,
0x03,0xFF,0xFF,0xC0,0x03,0xFF,0xFF,0xF0,0x03,0xFF,
0xFF,0xFC,0x03,0xFF,0x03,0xFE,0x01,0xFC,0x00,0x7F,
0x81,0xFC,0x00,0x1F,0xC0,0xFE,0x00,0x07,0xE0,0xFE,
0x00,0x03,0xF8,0x7E,0x00,0x00,0xFC,0x3F,0x00,0x00,
0x00,0xA7,0xE0,0x00,0x00,0x03,0xE0,0x1F,0xC0,0x03,
0xF0,0x7F,0xFC,0x01,0xF8,0x7F,0xFF,0x80,0xFC,0xFF,
0xFF,0xE0,0x7E,0xFF,0xFF,0xF8,0x3F,0x7F,0xFF,0xFE,
0x1F,0xFF,0x01,0xFF,0x8F,0xFC,0x00,0x3F,0xC7,0xFC,
0x00,0x0F,0xF3,0xFC,0x00,0x03,0xF9,0xFC,0x00,0x00,
0xFC,0xFE,0x00,0x00,0x7F,0xAF,0xC0,0x00,0x03,0xF9,
0x7C,0x00,0x00,0x3F,0x3F,0x00,0x00,0x3F,0x9F,0x80,
0x00,0x1F,0x87,0xE0,0x00,0x0F,0xC3,0xF0,0x00,0x0F,
0xE0,0xFC,0x00,0x0F,0xE0,0x7F,0x80,0x0F,0xF0,0x1F,
0xF0,0x1F,0xF1,0x00,0xFF,0xFF,0xFE,0x00,0x1F,0xFF,
0xFE,0x00,0x07,0xFF,0xFC,0x00,0x00,0xFF,0xFC,0x00,
0x00,0x0F,0xF0,0x00,0x07,0xEF,0x18,0x04,0xB7,0xFF,
0xFF,0xFF,0xFD,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,
0xF8,0x00,0x00,0x01,0xF0,0x00,0x00,0x03,0xE0,0x00,
0x00,0x07,0xC0,0x00,0x00,0x0F,0xC0,0x00,0x00,0x1F,
0x80,0x00,0x00,0x1F,0x00,0x00,0x00,0x3F,0x00,0x00,
0x00,0x7E,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0xFC,
0x02,0x00,0x00,0x3F,0x00,0x40,0x00,0x0F,0xC0,0x08,
0x00,0x03,0xF0,0x01,0x00,0x00,0xFC,0x00,0x20,0x00,
0x3F,0x00,0x04,0x80,0x0F,0xC0,0x00,0x90,0x03,0xF0,
0x00,0x14,0x00,0xFC,0x00,0x02,0xC0,0x3F,0x00,0x00,
0x58,0x0F,0xC0,0x00,0x00,0x07,0xF1,0x1F,0xF4,0xA0,
0x01,0xFF,0x00,0x00,0x07,0xFF,0xC0,0x00,0x1F,0xFF,
0xF0,0x00,0x3F,0xFF,0xF8,0x00,0x7F,0xFF,0xFC,0x00,
0xFF,0xFF,0xFE,0x01,0xFF,0x01,0xFF,0x01,0xFC,0x00,
0x7F,0x01,0xF8,0x00,0x3F,0x03,0xF8,0x00,0x3F,0x96,
0x7E,0x00,0x03,0xF0,0x7F,0x00,0x07,0xF0,0x3F,0x00,
0x07,0xE0,0x3F,0x80,0x0F,0xE0,0x1F,0xE0,0x3F,0xC0,
0x0F,0xFF,0xFF,0x80,0x07,0xFF,0xFF,0x00,0x01,0xFF,
0xFC,0x00,0x03,0xFF,0xFE,0x00,0x0F,0xFF,0xFF,0x80,
0x1F,0xFF,0xFF,0xC0,0x3F,0xE0,0x3F,0xE0,0x7F,0x80,
0x0F,0xF0,0x7E,0x00,0x07,0xF0,0xFE,0x00,0x03,0xF8,
0xFC,0x00,0x01,0xF9,0xFC,0x00,0x01,0xFF,0x3F,0x00,
0x00,0x1F,0xBF,0x80,0x00,0x3F,0x9F,0x80,0x00,0x3F,
0x1F,0x80,0x00,0x7F,0x1F,0xC0,0x00,0x7F,0x0F,0xF0,
0x01,0xFE,0x0F,0xFC,0x07,0xFE,0x07,0xFF,0xFF,0xFC,
0x03,0xFF,0xFF,0xF8,0x01,0xFF,0xFF,0xF0,0x00,0xFF,
0xFF,0xE0,0x00,0x3F,0xFF,0x80,0x00,0x07,0xFC,0x00,
0x00,0x07,0xF1,0x1F,0xF4,0xA0,0x01,0xFE,0x00,0x00,
0x0F,0xFF,0x80,0x00,0x3F,0xFF,0xE0,0x00,0x7F,0xFF,
0xF0,0x00,0xFF,0xFF,0xFC,0x01,0xFF,0xFF,0xFC,0x01,
0xFF,0x01,0xFE,0x03,0xFC,0x00,0x7F,0x07,0xF8,0x00,
0x3F,0x07,0xF0,0x00,0x1F,0x87,0xF0,0x00,0x0F,0x8F,
0xE0,0x00,0x0F,0xCF,0xE0,0x00,0x07,0xD1,0xF8,0x00,
0x00,0xFA,0xFF,0x00,0x00,0x1F,0xBF,0x80,0x00,0x3F,
0x9F,0x80,0x00,0x3F,0x9F,0xC0,0x00,0x7F,0x9F,0xE0,
0x00,0xFF,0x8F,0xF0,0x01,0xFF,0x8F,0xFC,0x07,0xFF,
0x87,0xFF,0xFF,0xDF,0x83,0xFF,0xFF,0xDF,0x81,0xFF,
0xFF,0x9F,0x80,0xFF,0xFE,0x1F,0x80,0x3F,0xFC,0x1F,
0x80,0x0F,0xE0,0x1F,0xD0,0x00,0x00,0x07,0xE0,0x00,
0x00,0x0F,0xC8,0x7E,0x00,0x01,0xF8,0x7F,0x00,0x03,
0xF0,0x3F,0x00,0x07,0xF0,0x3F,0x80,0x0F,0xE0,0x1F,
0xE0,0x3F,0xE0,0x1F,0xFF,0xFF,0xC0,0x0F,0xFF,0xFF,
0x80,0x07,0xFF,0xFF,0x00,0x03,0xFF,0xFE,0x00,0x01,
0xFF,0xF8,0x00,0x00,0x3F,0xC0,0x00,0x01,0xA3,0x30,
0x02,0x79,0xFE,0x81,0xA0,0x68,0x10,0x06,0x7E,0x01,
0xAD,0x37,0x62,0x79,0xFE,0x81,0xA0,0x68,0x10,0x06,
0x7F,0x43,0x8F,0x1C,0x79,0xE1,0xC1,0x00,0x07,0xE1,
0x20,0x74,0xE0,0x00,0x00,0x00,0x20,0x00,0x00,0x00,
0xE0,0x00,0x00,0x07,0xE0,0x00,0x00,0x1F,0xE0,0x00,
0x00,0x7F,0xE0,0x00,0x01,0xFF,0xE0,0x00,0x07,0xFF,
0xC0,0x00,0x3F,0xFE,0x00,0x00,0xFF,0xF8,0x00,0x03,
0xFF,0xE0,0x00,0x0F,0xFF,0x00,0x00,0x3F,0xFC,0x00,
0x01,0xFF,0xF0,0x00,0x07,0xFF,0x80,0x00,0x0F,0xFE,
0x00,0x00,0x0F,0xF0,0x00,0x00,0x0F,0xC0,0x00,0x00,
0x0F,0xF0,0x00,0x00,0x0F,0xFE,0x00,0x00,0x07,0xFF,
0x80,0x00,0x01,0xFF,0xF0,0x00,0x00,0x3F,0xFC,0x00,
0x00,0x0F,0xFF,0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,
0xFF,0xF8,0x00,0x00,0x3F,0xFE,0x00,0x00,0x07,0xFF,
0xC0,0x00,0x01,0xFF,0xE0,0x00,0x00,0x7F,0xE0,0x00,
0x00,0x1F,0xE0,0x00,0x00,0x07,0xE0,0x00,0x00,0x00,
0xE0,0x00,0x00,0x00,0x20,0x08,0x14,0x18,0xE4,0xF9,
0xFF,0xFF,0xFF,0xFF,0xA0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x0C,0xFF,0xFF,0xFF,0xFF,0x07,0xE1,0x20,
0x74,0xE8,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,0x0F,
0xC0,0x00,0x00,0x0F,0xF0,0x00,0x00,0x0F,0xFC,0x00,
0x00,0x0F,0xFF,0x00,0x00,0x07,0xFF,0xC0,0x00,0x00,
0xFF,0xF8,0x00,0x00,0x3F,0xFE,0x00,0x00,0x0F,0xFF,
0x80,0x00,0x01,0xFF,0xE0,0x00,0x00,0x7F,0xF8,0x00,
0x00,0x1F,0xFF,0x00,0x00,0x03,0xFF,0xC0,0x00,0x00,
0xFF,0xE0,0x00,0x00,0x1F,0xE0,0x00,0x00,0x07,0xE0,
0x00,0x00,0x1F,0xE0,0x00,0x00,0xFF,0xE0,0x00,0x03,
0xFF,0xC0,0x00,0x1F,0xFF,0x00,0x00,0x7F,0xF8,0x00,
0x01,0xFF,0xE0,0x00,0x0F,0xFF,0x80,0x00,0x3F,0xFE,
0x00,0x00,0xFF,0xF8,0x00,0x07,0xFF,0xC0,0x00,0x0F,
0xFF,0x00,0x00,0x0F,0xFC,0x00,0x00,0x0F,0xF0,0x00,
0x00,0x0F,0xC0,0x00,0x00,0x0E,0x00,0x00,0x00,0x08,
0x00,0x00,0x00,0x00,0x07,0xF1,0x18,0x04,0xA0,0x01,
0xFF,0x00,0x00,0x0F,0xFF,0xE0,0x00,0x3F,0xFF,0xF8,
0x00,0x7F,0xFF,0xFC,0x00,0xFF,0xFF,0xFE,0x01,0xFF,
0xFF,0xFF,0x03,0xFF,0x01,0xFF,0x83,0xFC,0x00,0x7F,
0xC7,0xF8,0x00,0x3F,0xC7,0xF0,0x00,0x1F,0xC7,0xE0,
0x00,0x0F,0xEF,0xE0,0x00,0x0F,0xEF,0xE0,0x00,0x07,
0xEF,0xC0,0x00,0x07,0xE1,0xC0,0x00,0x07,0xF0,0x00,
0x00,0x00,0xFC,0x00,0x00,0x01,0xF8,0x00,0x00,0x03,
0xF8,0x00,0x00,0x07,0xF0,0x00,0x00,0x0F,0xF0,0x00,
0x00,0x1F,0xE0,0x00,0x00,0x3F,0xC0,0x00,0x00,0x7F,
0x80,0x00,0x00,0xFF,0x00,0x00,0x01,0xFE,0x00,0x00,
0x03,0xFC,0x00,0x00,0x07,0xF8,0x00,0x00,0x07,0xF0,
0x00,0x00,0x0F,0xE0,0x00,0x00,0x0F,0xC0,0x02,0x00,
0x03,0xF8,0x00,0x58,0x00,0x7E,0x00,0x0B,0x00,0x00,
0x00,0x01,0x80,0x01,0xF8,0x00,0x00,0x0F,0xBF,0x1F,
0x28,0x80,0x00,0x00,0x03,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x00,0x7F,0xFF,0xF8,0x00,0x00,0x00,0x00,0x07,
0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0x80,
0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,
0x3F,0xFF,0x00,0x1F,0xFF,0x80,0x00,0x00,0xFF,0xF0,
0x00,0x03,0xFF,0x80,0x00,0x03,0xFF,0x00,0x00,0x00,
0xFF,0x80,0x00,0x0F,0xF8,0x00,0x00,0x00,0xFF,0x80,
0x00,0x3F,0xC0,0x00,0x00,0x00,0x7F,0x80,0x00,0xFF,
0x00,0x00,0x00,0x00,0x7F,0x80,0x01,0xFC,0x00,0x00,
0x00,0x00,0x7F,0x00,0x07,0xF0,0x00,0x7E,0x00,0x00,
0x7F,0x00,0x1F,0xC0,0x07,0xFF,0x03,0xF0,0x7E,0x00,
0x3F,0x00,0x1F,0xFF,0x87,0xE0,0x7E,0x00,0xFC,0x00,
0xFF,0xFF,0x9F,0x80,0x7C,0x01,0xF0,0x03,0xFF,0xFF,
0xBF,0x00,0xFC,0x07,0xE0,0x0F,0xFF,0xFF,0xFE,0x00,
0xF8,0x0F,0x80,0x3F,0xF0,0x7F,0xFC,0x01,0xF0,0x3F,
0x00,0xFF,0x80,0x3F,0xF8,0x03,0xE0,0x7C,0x01,0xFC,
0x00,0x3F,0xE0,0x07,0xE0,0xF8,0x07,0xF0,0x00,0x3F,
0xC0,0x07,0xC3,0xF0,0x0F,0xE0,0x00,0x7F,0x80,0x0F,
0x87,0xC0,0x3F,0x80,0x00,0x7F,0x00,0x1F,0x0F,0x80,
0x7E,0x00,0x00,0xFC,0x00,0x3E,0x1F,0x01,0xFC,0x00,
0x01,0xF8,0x00,0x7C,0x7E,0x03,0xF0,0x00,0x03,0xF0,
0x00,0xF8,0xF8,0x07,0xE0,0x00,0x07,0xE0,0x01,0xF1,
0xF0,0x1F,0xC0,0x00,0x0F,0x80,0x03,0xE3,0xE0,0x3F,
0x00,0x00,0x1F,0x00,0x0F,0xC7,0xC0,0x7E,0x00,0x00,
0x3E,0x00,0x1F,0x0F,0x80,0xFC,0x00,0x00,0xFC,0x00,
0x3E,0x1F,0x01,0xF8,0x00,0x01,0xF8,0x00,0xFC,0x3E,
0x03,0xF0,0x00,0x03,0xE0,0x01,0xF0,0x7C,0x07,0xE0,
0x00,0x0F,0xC0,0x07,0xE0,0xF8,0x0F,0xC0,0x00,0x1F,
0x80,0x0F,0x81,0xF0,0x1F,0x80,0x00,0x7F,0x00,0x3F,
0x03,0xE0,0x3F,0x80,0x01,0xFC,0x00,0xFC,0x07,0xE0,
0x3F,0x00,0x07,0xF8,0x03,0xF8,0x07,0xC0,0x7F,0x00,
0x1F,0xF0,0x0F,0xE0,0x0F,0x80,0xFF,0x00,0x7F,0xE0,
0x7F,0x80,0x1F,0x80,0xFF,0x83,0xFF,0xE3,0xFE,0x00,
0x3F,0x00,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x3E,0x01,
0xFF,0xFF,0xBF,0xFF,0xE0,0x00,0x7E,0x01,0xFF,0xFE,
0x7F,0xFF,0x80,0x00,0x7E,0x01,0xFF,0xF8,0x7F,0xFE,
0x00,0x00,0xFC,0x00,0xFF,0xC0,0xFF,0xF0,0x00,0x00,
0xFC,0x00,0x7E,0x00,0x7F,0x00,0x0F,0xC1,0xFC,0x00,
0x00,0x00,0x00,0x00,0x3F,0x01,0xFC,0x00,0x00,0x00,
0x00,0x00,0xFE,0x03,0xFC,0x00,0x00,0x00,0x00,0x07,
0xF8,0x03,0xFE,0x00,0x00,0x00,0x00,0x1F,0xE0,0x03,
0xFF,0x00,0x00,0x00,0x00,0xFF,0x80,0x03,0xFF,0x80,
0x00,0x00,0x07,0xFE,0x00,0x03,0xFF,0xE0,0x00,0x00,
0x7F,0xF8,0x00,0x03,0xFF,0xFC,0x00,0x0F,0xFF,0xE0,
0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x01,
0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,0xFF,0xFF,
0xFF,0xFF,0xE0,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xF0,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFC,0x00,0x00,0x00,0x0B,0x70,
0xF8,0x05,0xB0,0x00,0x00,0x7F,0xC0,0x00,0x09,0x00,
0x00,0x7F,0xF0,0x00,0x00,0x00,0x03,0xFF,0xE0,0x00,
0x00,0x00,0x0F,0xDF,0x80,0x00,0x40,0x00,0x0F,0xEF,
0xE0,0x00,0x00,0x00,0x3F,0x1F,0x80,0x00,0x00,0x01,
0xFC,0x7F,0x00,0x00,0x00,0x07,0xE1,0xFC,0x00,0x08,
0x00,0x07,0xF0,0x7F,0x00,0x00,0x00,0x1F,0x80,0xFC,
0x00,0x10,0x00,0x1F,0xC0,0x7F,0x00,0x00,0x00,0x7E,
0x00,0xFC,0x00,0x20,0x00,0x7F,0x00,0x7F,0x00,0x10,
0x00,0x7F,0x00,0x1F,0xC0,0x00,0x01,0xF8,0x00,0x3F,
0x00,0x20,0x01,0xFC,0x00,0x1F,0xC0,0x10,0x01,0xFC,
0x00,0x07,0xF0,0x00,0x07,0xFF,0xFF,0xFF,0xC0,0x20,
0x07,0xFF,0xFF,0xFF,0xF0,0x12,0x07,0xFF,0xFF,0xFF,
0xFC,0x08,0x07,0xF0,0x00,0x00,0x7F,0x00,0x3F,0xC0,
0x00,0x01,0xFE,0x10,0x1F,0xC0,0x00,0x00,0x7F,0x00,
0xFF,0x00,0x00,0x01,0xFE,0x20,0x7F,0x00,0x00,0x00,
0x7F,0x10,0x7F,0x00,0x00,0x00,0x1F,0xC3,0xFC,0x00,
0x00,0x00,0x7F,0xA1,0xFC,0x00,0x00,0x00,0x1F,0xCF,
0xF0,0x00,0x00,0x00,0x7F,0xBF,0x80,0x00,0x00,0x00,
0xFE,0x09,0x70,0x28,0x05,0xAF,0xFF,0xFF,0xF0,0x00,
0x3F,0xFF,0xFF,0xFC,0x00,0xFF,0xFF,0xFF,0xFC,0x03,
0xFF,0xFF,0xFF,0xF8,0x0F,0xFF,0xFF,0xFF,0xF0,0x3F,
0xFF,0xFF,0xFF,0xE0,0xFE,0x00,0x01,0xFF,0x83,0xF8,
0x00,0x01,0xFF,0x0F,0xE0,0x00,0x03,0xFC,0x3F,0x80,
0x00,0x07,0xF9,0x7F,0xC0,0x00,0x01,0xFC,0x7F,0x00,
0x00,0x07,0xE1,0xFC,0x00,0x00,0x3F,0x87,0xF0,0x00,
0x01,0xFC,0x1F,0xC0,0x00,0x0F,0xF0,0x7F,0x00,0x00,
0xFF,0x81,0xFF,0xFF,0xFF,0xF8,0x08,0xFF,0xFF,0xFF,
0xF8,0x03,0xFF,0xFF,0xFF,0xF8,0x0F,0xFF,0xFF,0xFF,
0xF8,0x3F,0xFF,0xFF,0xFF,0xF0,0xFE,0x00,0x00,0xFF,
0xE3,0xF8,0x00,0x00,0xFF,0x8F,0xE0,0x00,0x00,0xFF,
0x3F,0x80,0x00,0x01,0xFC,0xFE,0x00,0x00,0x07,0xFE,
0x7F,0x00,0x00,0x01,0xFD,0xFC,0x00,0x00,0x0F,0xF7,
0xF0,0x00,0x00,0x3F,0x9F,0xC0,0x00,0x01,0xFE,0x7F,
0x00,0x00,0x0F,0xF1,0xFC,0x00,0x01,0xFF,0xC7,0xFF,
0xFF,0xFF,0xFE,0x1F,0xFF,0xFF,0xFF,0xF0,0x7F,0xFF,
0xFF,0xFF,0x81,0xFF,0xFF,0xFF,0xFC,0x07,0xFF,0xFF,
0xFF,0xC0,0x1F,0xFF,0xFF,0xF0,0x00,0x0A,0xB2,0x1F,
0xF6,0x00,0x00,0x07,0xFE,0x00,0x00,0x00,0x07,0xFF,
0xF8,0x00,0x00,0x03,0xFF,0xFF,0xC0,0x00,0x01,0xFF,
0xFF,0xFE,0x00,0x00,0xFF,0xFF,0xFF,0xE0,0x00,0x3F,
0xFF,0xFF,0xFE,0x00,0x0F,0xFF,0x00,0xFF,0xE0,0x03,
0xFF,0x00,0x07,0xFE,0x00,0x7F,0x80,0x00,0x3F,0xC0,
0x1F,0xE0,0x00,0x03,0xFC,0x07,0xF8,0x00,0x00,0x7F,
0xC0,0xFE,0x00,0x00,0x07,0xF8,0x3F,0xC0,0x00,0x00,
0x7F,0x07,0xF0,0x00,0x00,0x0F,0xF0,0xFE,0x00,0x00,
0x00,0xFC,0x3F,0x80,0x00,0x00,0x18,0x12,0xFE,0x00,
0x00,0x00,0x00,0x6F,0xF0,0x00,0x00,0x00,0x01,0x7F,
0xC0,0x00,0x00,0x00,0x01,0xFC,0x00,0x00,0x00,0x00,
0x3F,0x80,0x00,0x00,0x0C,0x07,0xF0,0x00,0x00,0x01,
0xFC,0xFE,0x00,0x00,0x00,0x7F,0xC1,0xFC,0x00,0x00,
0x01,0xFC,0x3F,0xC0,0x00,0x00,0x7F,0x83,0xF8,0x00,
0x00,0x1F,0xE0,0x7F,0x80,0x00,0x03,0xFC,0x07,0xF8,
0x00,0x00,0xFF,0x00,0x7F,0x80,0x00,0x3F,0xE0,0x0F,
0xFC,0x00,0x1F,0xF8,0x00,0xFF,0xF0,0x1F,0xFE,0x00,
0x0F,0xFF,0xFF,0xFF,0x80,0x00,0xFF,0xFF,0xFF,0xE0,
0x00,0x0F,0xFF,0xFF,0xF8,0x00,0x00,0x7F,0xFF,0xFC,
0x00,0x00,0x03,0xFF,0xFE,0x00,0x00,0x00,0x07,0xFE,
0x00,0x00,0x0A,0x30,0x28,0x06,0x0F,0xFF,0xFF,0xF0,
0x00,0x07,0xFF,0xFF,0xFF,0x80,0x03,0xFF,0xFF,0xFF,
0xF0,0x01,0xFF,0xFF,0xFF,0xFE,0x00,0xFF,0xFF,0xFF,
0xFF,0x80,0x7F,0xFF,0xFF,0xFF,0xE0,0x3F,0x80,0x00,
0x7F,0xF8,0x1F,0xC0,0x00,0x07,0xFC,0x0F,0xE0,0x00,
0x01,0xFF,0x07,0xF0,0x00,0x00,0x7F,0xC3,0xF8,0x00,
0x00,0x1F,0xE1,0xFC,0x00,0x00,0x07,0xF9,0x1F,0xC0,
0x00,0x00,0x3F,0x95,0xFC,0x00,0x00,0x01,0xFD,0xBF,
0xC0,0x00,0x00,0x0F,0xF7,0xFC,0x00,0x00,0x00,0xFF,
0x3F,0xC0,0x00,0x00,0x1F,0xCF,0xE0,0x00,0x00,0x1F,
0xE8,0xFE,0x00,0x00,0x01,0xFC,0x7F,0x00,0x00,0x01,
0xFE,0x47,0xF0,0x00,0x00,0x3F,0xC3,0xF8,0x00,0x00,
0x7F,0xC1,0xFC,0x00,0x00,0x7F,0xC0,0xFE,0x00,0x01,
0xFF,0xE0,0x7F,0xFF,0xFF,0xFF,0xE0,0x3F,0xFF,0xFF,
0xFF,0xE0,0x1F,0xFF,0xFF,0xFF,0xC0,0x0F,0xFF,0xFF,
0xFF,0xC0,0x07,0xFF,0xFF,0xFF,0x80,0x03,0xFF,0xFF,
0xFC,0x00,0x00,0x09,0x30,0x28,0x05,0xB9,0xFF,0xFF,
0xFF,0xFF,0xDB,0xFC,0x00,0x00,0x00,0x1B,0xFC,0x00,
0x00,0x00,0x19,0xFF,0xFF,0xFF,0xFF,0x1B,0xFC,0x00,
0x00,0x00,0x1B,0xFC,0x00,0x00,0x00,0x11,0xFC,0x00,
0x00,0x00,0x19,0xFF,0xFF,0xFF,0xFF,0xE0,0x08,0x70,
0x28,0x05,0x39,0xFF,0xFF,0xFF,0xFF,0xDF,0xE0,0x00,
0x00,0x06,0xFF,0x00,0x00,0x00,0x33,0xFF,0xFF,0xFF,
0xE1,0xBF,0xC0,0x00,0x00,0x0D,0xFE,0x00,0x00,0x00,
0x6F,0xF0,0x00,0x00,0x01,0xFC,0x00,0x00,0x00,0x0B,
0x72,0x1F,0xF6,0x80,0x00,0x01,0xFF,0xC0,0x00,0x00,
0x00,0x7F,0xFF,0xE0,0x00,0x00,0x0F,0xFF,0xFF,0xE0,
0x00,0x00,0x7F,0xFF,0xFF,0xE0,0x00,0x07,0xFF,0xFF,
0xFF,0xC0,0x00,0x3F,0xFF,0xFF,0xFF,0x80,0x01,0xFF,
0xE0,0x0F,0xFF,0x00,0x0F,0xFC,0x00,0x07,0xFE,0x00,
0x7F,0xE0,0x00,0x07,0xFC,0x03,0xFE,0x00,0x00,0x0F,
0xF0,0x0F,0xF0,0x00,0x00,0x1F,0xE0,0x7F,0x80,0x00,
0x00,0x3F,0x81,0xFC,0x00,0x00,0x00,0xFE,0x0F,0xF0,
0x00,0x00,0x01,0xFC,0x3F,0x80,0x00,0x00,0x07,0xF0,
0xFE,0x00,0x00,0x00,0x1F,0x14,0xFE,0x00,0x00,0x00,
0x00,0x0B,0xFE,0x00,0x00,0x00,0x00,0x06,0x7F,0x00,
0x00,0x3F,0xFF,0xFE,0x5F,0xC0,0x00,0x00,0x00,0xFE,
0x7F,0x80,0x00,0x00,0x03,0xF8,0xFE,0x00,0x00,0x00,
0x0F,0xE3,0xFC,0x00,0x00,0x00,0x3F,0x87,0xF0,0x00,
0x00,0x00,0xFE,0x1F,0xE0,0x00,0x00,0x03,0xF8,0x3F,
0xC0,0x00,0x00,0x0F,0xE0,0xFF,0x80,0x00,0x00,0xFF,
0x81,0xFF,0x80,0x00,0x07,0xFE,0x03,0xFF,0x80,0x00,
0xFF,0xF8,0x07,0xFF,0xC0,0x1F,0xFF,0xC0,0x0F,0xFF,
0xFF,0xFF,0xFC,0x00,0x1F,0xFF,0xFF,0xFF,0xE0,0x00,
0x1F,0xFF,0xFF,0xFE,0x00,0x00,0x1F,0xFF,0xFF,0xE0,
0x00,0x00,0x1F,0xFF,0xFC,0x00,0x00,0x00,0x07,0xFF,
0x00,0x00,0x09,0xB0,0x28,0x06,0x1B,0xFC,0x00,0x00,
0x03,0xFE,0xFF,0x00,0x00,0x00,0xFF,0x7F,0xC0,0x00,
0x00,0x3F,0xE7,0xFF,0xFF,0xFF,0xFF,0xFB,0xFC,0x00,
0x00,0x03,0xFE,0xFF,0x00,0x00,0x00,0xFF,0xBF,0xC0,
0x00,0x00,0x3F,0xC7,0xF0,0x00,0x00,0x0F,0xE0,0x01,
0xF0,0x30,0x02,0x7B,0xFF,0x7F,0xEF,0xFD,0xFF,0xBF,
0xF7,0xFE,0x7F,0x06,0xF1,0x17,0xF4,0x5A,0x00,0x00,
0x1F,0xF4,0x00,0x00,0x3F,0xE8,0x00,0x00,0x7F,0xD0,
0x00,0x00,0xFF,0x80,0x00,0x01,0xFC,0x3C,0x00,0x1F,
0xE7,0xF8,0x00,0x3F,0xBF,0xC0,0x03,0xFB,0xFC,0x00,
0x7F,0x1F,0xC0,0x07,0xF1,0xFE,0x00,0xFF,0x1F,0xF8,
0x3F,0xE0,0xFF,0xFF,0xFE,0x0F,0xFF,0xFF,0xC0,0x7F,
0xFF,0xF8,0x03,0xFF,0xFF,0x00,0x0F,0xFF,0xC0,0x00,
0x1F,0xF0,0x00,0x0A,0x30,0x28,0x05,0xAF,0xE0,0x00,
0x00,0x7F,0xC7,0xF0,0x00,0x00,0x7F,0xC3,0xF8,0x00,
0x00,0x7F,0xC1,0xFC,0x00,0x00,0x7F,0xC0,0xFE,0x00,
0x00,0x7F,0xC0,0x7F,0x00,0x00,0x7F,0xC0,0x3F,0x80,
0x00,0x7F,0xC0,0x1F,0xC0,0x00,0x7F,0xC0,0x0F,0xE0,
0x00,0x7F,0xC0,0x07,0xF0,0x00,0x7F,0xC0,0x03,0xF8,
0x00,0x7F,0xC0,0x01,0xFC,0x00,0xFF,0xC0,0x00,0xFE,
0x00,0xFF,0xC0,0x00,0x7F,0x00,0xFF,0xC0,0x00,0x3F,
0x80,0xFF,0xC0,0x00,0x1F,0xC0,0xFF,0xC0,0x00,0x0F,
0xE0,0xFF,0xC0,0x00,0x07,0xF0,0xFF,0xC0,0x00,0x03,
0xF8,0xFF,0xC0,0x00,0x01,0xFC,0xFF,0xC0,0x00,0x00,
0xFE,0xFF,0xE0,0x00,0x00,0x7F,0xFF,0xF8,0x00,0x00,
0x3F,0xFF,0xFE,0x00,0x00,0x23,0xFF,0xFF,0xF0,0x00,
0x01,0xFF,0xF3,0xFC,0x00,0x00,0xFF,0xF1,0xFF,0x00,
0x00,0x7F,0xF0,0x7F,0xC0,0x00,0x3F,0xF0,0x1F,0xE0,
0x00,0x1F,0xF0,0x07,0xF8,0x00,0x0F,0xF0,0x03,0xFE,
0x00,0x07,0xF0,0x00,0xFF,0x80,0x03,0xF8,0x00,0x3F,
0xC0,0x01,0xFC,0x00,0x0F,0xF0,0x00,0xFE,0x00,0x07,
0xFC,0x00,0x7F,0x00,0x01,0xFF,0x00,0x3F,0x80,0x00,
0x7F,0x80,0x1F,0xC0,0x00,0x1F,0xE0,0x0F,0xE0,0x00,
0x0F,0xF8,0x07,0xF0,0x00,0x03,0xFE,0x03,0xF8,0x00,
0x00,0xFF,0x01,0xFC,0x00,0x00,0x3F,0xC0,0xFE,0x00,
0x00,0x1F,0xF0,0x7F,0x00,0x00,0x07,0xFC,0x3F,0x80,
0x00,0x01,0xFE,0x1F,0xC0,0x00,0x00,0x7F,0x8F,0xE0,
0x00,0x00,0x3F,0xE7,0xF0,0x00,0x00,0x0F,0xF8,0x07,
0xB0,0x28,0x04,0xBB,0xFC,0x00,0x00,0x06,0xFF,0x00,
0x00,0x01,0xBF,0xC0,0x00,0x00,0x6F,0xF0,0x00,0x00,
0x1B,0xFC,0x00,0x00,0x06,0xFF,0x00,0x00,0x01,0x9F,
0xFF,0xFF,0xFF,0x80,0x0B,0xF0,0x20,0x06,0xEF,0xFE,
0x00,0x00,0x00,0xFF,0xF3,0xFF,0xE0,0x00,0x00,0x3F,
0xFE,0x7F,0xFE,0x00,0x00,0x0F,0xFF,0xBF,0xFF,0x00,
0x00,0x1F,0xFF,0xCF,0xF7,0xE0,0x00,0x03,0xF7,0xF9,
0xFE,0x7E,0x00,0x00,0xFC,0xFF,0x3F,0xC7,0xE0,0x00,
0x3F,0x1F,0xDF,0xC7,0xF0,0x00,0x7F,0x1F,0xE7,0xF8,
0x7E,0x00,0x0F,0xC3,0xFC,0xFF,0x07,0xE0,0x03,0xF0,
0x7F,0x9F,0xE0,0x7E,0x00,0xFC,0x0F,0xEF,0xE0,0x7F,
0x01,0xFC,0x0F,0xF3,0xFC,0x07,0xE0,0x3F,0x01,0xFE,
0x7F,0x80,0x7E,0x0F,0xC0,0x3F,0xBF,0x80,0x7F,0x1F,
0xC0,0x3F,0xC7,0xF0,0x07,0xE3,0xF0,0x07,0xF7,0xF0,
0x07,0xE7,0xF0,0x07,0xF9,0xFE,0x00,0x7E,0xFC,0x00,
0xFF,0x5F,0xC0,0x07,0xFF,0x00,0x1F,0xE7,0xF8,0x00,
0x7F,0xC0,0x03,0xF8,0x09,0xB0,0x28,0x06,0x11,0xFE,
0x00,0x00,0x03,0xFB,0xFE,0x00,0x00,0x07,0xF8,0xFF,
0xC0,0x00,0x01,0xFD,0xFF,0xC0,0x00,0x03,0xFC,0x7F,
0xF8,0x00,0x00,0xFE,0xFF,0xF8,0x00,0x01,0xFE,0x3F,
0xFF,0x00,0x00,0x7F,0x7F,0xFF,0x00,0x00,0xFE,0xFF,
0xFF,0x00,0x01,0xFD,0xFD,0xFE,0x00,0x03,0xFB,0xFB,
0xFE,0x00,0x07,0xF7,0xF3,0xFE,0x00,0x0F,0xEF,0xE3,
0xFC,0x00,0x1F,0xDF,0xC7,0xFC,0x00,0x3F,0xBF,0x87,
0xFC,0x00,0x7F,0x7F,0x07,0xF8,0x00,0xFE,0xFE,0x0F,
0xF8,0x01,0xFD,0xFC,0x0F,0xF8,0x03,0xFB,0xF8,0x0F,
0xF0,0x07,0xF7,0xF0,0x1F,0xF0,0x0F,0xEF,0xE0,0x1F,
0xF0,0x1F,0xDF,0xC0,0x1F,0xE0,0x3F,0xBF,0x80,0x3F,
0xE0,0x7F,0x7F,0x00,0x3F,0xE0,0xFE,0xFE,0x00,0x3F,
0xC1,0xFD,0xFC,0x00,0x7F,0xC3,0xFB,0xF8,0x00,0x7F,
0xC7,0xF7,0xF0,0x00,0x7F,0x8F,0xEF,0xE0,0x00,0xFF,
0x9F,0xDF,0xC0,0x00,0xFF,0xBF,0xBF,0x80,0x00,0xFF,
0x7F,0x7F,0x00,0x01,0xFF,0xFE,0xFE,0x00,0x01,0xFF,
0xFE,0x3F,0x80,0x00,0x3F,0xFF,0x7F,0x00,0x00,0x3F,
0xFF,0x1F,0xC0,0x00,0x07,0xFF,0xBF,0x80,0x00,0x07,
0xFF,0x8F,0xE0,0x00,0x00,0xFF,0xDF,0xC0,0x00,0x00,
0xFF,0xC7,0xF0,0x00,0x00,0x1F,0xE0,0x0B,0xB2,0x1F,
0xF6,0x80,0x00,0x03,0xFF,0x00,0x00,0x00,0x00,0x7F,
0xFF,0xC0,0x00,0x00,0x03,0xFF,0xFF,0xF0,0x00,0x00,
0x1F,0xFF,0xFF,0xF0,0x00,0x00,0x7F,0xFF,0xFF,0xF8,
0x00,0x01,0xFF,0xFF,0xFF,0xF8,0x00,0x07,0xFF,0x80,
0x7F,0xF8,0x00,0x1F,0xF8,0x00,0x1F,0xF8,0x00,0x7F,
0xC0,0x00,0x0F,0xF8,0x01,0xFF,0x00,0x00,0x0F,0xF8,
0x03,0xFC,0x00,0x00,0x0F,0xF0,0x0F,0xF0,0x00,0x00,
0x0F,0xF0,0x1F,0xC0,0x00,0x00,0x0F,0xE0,0x7F,0x80,
0x00,0x00,0x1F,0xE0,0xFE,0x00,0x00,0x00,0x1F,0xC3,
0xFC,0x00,0x00,0x00,0x3F,0xD2,0xFE,0x00,0x00,0x00,
0x07,0xF3,0xF8,0x00,0x00,0x00,0x0F,0xFD,0xFE,0x00,
0x00,0x00,0x01,0xFE,0x7F,0x80,0x00,0x00,0x00,0x7F,
0x7F,0x00,0x00,0x00,0x01,0xFF,0x2F,0xE0,0x00,0x00,
0x00,0x7F,0x1F,0xE0,0x00,0x00,0x01,0xFE,0x1F,0xC0,
0x00,0x00,0x03,0xF8,0x3F,0xC0,0x00,0x00,0x0F,0xF0,
0x3F,0x80,0x00,0x00,0x1F,0xC0,0x7F,0x80,0x00,0x00,
0x7F,0x80,0x7F,0x80,0x00,0x01,0xFE,0x00,0xFF,0x80,
0x00,0x07,0xFC,0x00,0xFF,0x80,0x00,0x1F,0xF0,0x00,
0xFF,0xC0,0x00,0xFF,0xC0,0x00,0xFF,0xF0,0x0F,0xFF,
0x00,0x00,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0xFF,0xFF,
0xFF,0xF0,0x00,0x00,0x7F,0xFF,0xFF,0xC0,0x00,0x00,
0x7F,0xFF,0xFE,0x00,0x00,0x00,0x3F,0xFF,0xE0,0x00,
0x00,0x00,0x07,0xFE,0x00,0x00,0x00,0x09,0x70,0x28,
0x05,0xAF,0xFF,0xFF,0xFC,0x00,0x3F,0xFF,0xFF,0xFE,
0x00,0xFF,0xFF,0xFF,0xFE,0x03,0xFF,0xFF,0xFF,0xFE,
0x11,0xFF,0xFF,0xFF,0xFF,0x87,0xF0,0x00,0x03,0xFF,
0x1F,0xC0,0x00,0x03,0xFE,0x7F,0x00,0x00,0x07,0xF9,
0xFC,0x00,0x00,0x0F,0xE7,0xF0,0x00,0x00,0x3F,0xF7,
0xF8,0x00,0x00,0x0F,0xF1,0xFC,0x00,0x00,0x0F,0xE7,
0xF0,0x00,0x00,0x7F,0x9F,0xC0,0x00,0x07,0xFC,0x7F,
0x00,0x00,0x7F,0xF1,0xFF,0xFF,0xFF,0xFF,0x87,0xFF,
0xFF,0xFF,0xFC,0x1F,0xFF,0xFF,0xFF,0xE0,0x7F,0xFF,
0xFF,0xFF,0x01,0xFF,0xFF,0xFF,0xF0,0x07,0xFF,0xFF,
0xFC,0x00,0x37,0xF8,0x00,0x00,0x00,0x1B,0xFC,0x00,
0x00,0x00,0x0B,0xFE,0x00,0x00,0x00,0x00,0x0B,0xB5,
0x1F,0xC6,0x80,0x00,0x03,0xFE,0x00,0x00,0x00,0x00,
0x7F,0xFF,0xC0,0x00,0x00,0x03,0xFF,0xFF,0xE0,0x00,
0x00,0x1F,0xFF,0xFF,0xF0,0x00,0x00,0x7F,0xFF,0xFF,
0xF0,0x00,0x01,0xFF,0xFF,0xFF,0xF0,0x00,0x07,0xFF,
0x80,0xFF,0xF0,0x00,0x1F,0xF8,0x00,0x3F,0xF0,0x00,
0x7F,0xC0,0x00,0x1F,0xF0,0x01,0xFF,0x00,0x00,0x1F,
0xF0,0x03,0xFC,0x00,0x00,0x1F,0xE0,0x0F,0xF0,0x00,
0x00,0x1F,0xE0,0x1F,0xC0,0x00,0x00,0x1F,0xC0,0x7F,
0x00,0x00,0x00,0x3F,0xC0,0xFE,0x00,0x00,0x00,0x3F,
0x83,0xFC,0x00,0x00,0x00,0x7F,0x92,0xFE,0x00,0x00,
0x00,0x0F,0xE3,0xF8,0x00,0x00,0x00,0x1F,0xED,0xFE,
0x00,0x00,0x00,0x03,0xFA,0x7F,0x80,0x00,0x00,0x00,
0xFE,0x7F,0x00,0x00,0x00,0x03,0xF9,0x2F,0xE0,0x00,
0x00,0x00,0xFE,0x1F,0xE0,0x00,0x00,0x03,0xF8,0x1F,
0xC0,0x00,0x00,0x07,0xF0,0x3F,0xC0,0x00,0xE0,0x1F,
0xE0,0x3F,0x80,0x03,0xF0,0x3F,0x80,0x7F,0x80,0x07,
0xF8,0xFF,0x00,0x7F,0x80,0x0F,0xFB,0xFC,0x00,0xFF,
0x80,0x0F,0xFF,0xF0,0x00,0xFF,0x80,0x07,0xFF,0xC0,
0x00,0xFF,0xC0,0x03,0xFF,0x00,0x00,0xFF,0xE0,0x1F,
0xFC,0x00,0x00,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0xFF,
0xFF,0xFF,0xFE,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,
0x00,0x7F,0xFF,0xFD,0xFF,0x80,0x00,0x3F,0xFF,0xE1,
0xFF,0xC0,0x00,0x0F,0xFC,0x00,0xFF,0x80,0x00,0x00,
0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,
0x00,0x00,0x00,0x00,0x10,0x0A,0xB0,0x28,0x06,0x0F,
0xFF,0xFF,0xFF,0x00,0x01,0xFF,0xFF,0xFF,0xFC,0x00,
0x3F,0xFF,0xFF,0xFF,0xE0,0x07,0xFF,0xFF,0xFF,0xFE,
0x00,0xFF,0xFF,0xFF,0xFF,0xE0,0x1F,0xFF,0xFF,0xFF,
0xFE,0x03,0xF8,0x00,0x00,0xFF,0xC0,0x7F,0x00,0x00,
0x07,0xFC,0x0F,0xE0,0x00,0x00,0x7F,0x82,0x3F,0x80,
0x00,0x00,0xFF,0x0B,0xFE,0x00,0x00,0x01,0xFC,0x1F,
0xC0,0x00,0x00,0x7F,0x83,0xF8,0x00,0x00,0x0F,0xE0,
0x7F,0x00,0x00,0x03,0xFC,0x0F,0xE0,0x00,0x00,0xFF,
0x01,0xFC,0x00,0x00,0xFF,0xE0,0x3F,0xFF,0xFF,0xFF,
0xF8,0x07,0xFF,0xFF,0xFF,0xFE,0x00,0xFF,0xFF,0xFF,
0xFF,0x00,0x1F,0xFF,0xFF,0xFF,0xC0,0x03,0xFF,0xFF,
0xFF,0xC0,0x00,0x7F,0xFF,0xFF,0xE0,0x00,0x0F,0xE0,
0x01,0xFF,0x00,0x01,0xFC,0x00,0x0F,0xF0,0x00,0x3F,
0x80,0x00,0xFF,0x00,0x07,0xF0,0x00,0x0F,0xF0,0x01,
0x1F,0xC0,0x00,0x1F,0xE0,0x03,0xF8,0x00,0x01,0xFE,
0x00,0x8F,0xE0,0x00,0x03,0xFC,0x01,0xFC,0x00,0x00,
0x3F,0xC0,0x47,0xF0,0x00,0x00,0x7F,0x81,0x1F,0xC0,
0x00,0x00,0xFF,0x03,0xF8,0x00,0x00,0x0F,0xF0,0x8F,
0xE0,0x00,0x00,0x1F,0xE1,0xFC,0x00,0x00,0x01,0xFE,
0x47,0xF0,0x00,0x00,0x03,0xFC,0xFE,0x00,0x00,0x00,
0x3F,0xC0,0x09,0xB2,0x1F,0xF5,0xA0,0x00,0x3F,0xF0,
0x00,0x00,0x03,0xFF,0xFE,0x00,0x00,0x3F,0xFF,0xFF,
0x00,0x00,0xFF,0xFF,0xFF,0x80,0x03,0xFF,0xFF,0xFF,
0x80,0x0F,0xFF,0xFF,0xFF,0x80,0x3F,0xF8,0x03,0xFF,
0x80,0xFF,0x80,0x01,0xFF,0x01,0xFE,0x00,0x01,0xFF,
0x03,0xF8,0x00,0x01,0xFE,0x0F,0xF0,0x00,0x01,0xFC,
0x1F,0xC0,0x00,0x03,0xFD,0x07,0xF0,0x00,0x00,0x7F,
0x41,0xFC,0x00,0x00,0x00,0x03,0xFC,0x00,0x00,0x00,
0x03,0xFC,0x00,0x00,0x00,0x07,0xFC,0x00,0x00,0x00,
0x07,0xFF,0x00,0x00,0x00,0x07,0xFF,0xE0,0x00,0x00,
0x07,0xFF,0xF8,0x00,0x00,0x07,0xFF,0xFF,0x00,0x00,
0x07,0xFF,0xFF,0xC0,0x00,0x01,0xFF,0xFF,0xE0,0x00,
0x00,0xFF,0xFF,0xF0,0x00,0x00,0x1F,0xFF,0xF0,0x00,
0x00,0x07,0xFF,0xF0,0x00,0x00,0x00,0xFF,0xF0,0x00,
0x00,0x00,0x3F,0xE0,0x00,0x00,0x00,0x3F,0xE0,0x00,
0x00,0x00,0x1F,0xC0,0x00,0x00,0x00,0x3F,0xE7,0xF8,
0x00,0x00,0x07,0xF7,0xF8,0x00,0x00,0x0F,0xE7,0xF0,
0x00,0x00,0x1F,0xCF,0xF0,0x00,0x00,0x3F,0x9F,0xE0,
0x00,0x00,0xFE,0x1F,0xE0,0x00,0x03,0xFC,0x3F,0xE0,
0x00,0x0F,0xF8,0x3F,0xF0,0x00,0x3F,0xE0,0x3F,0xFC,
0x03,0xFF,0x80,0x7F,0xFF,0xFF,0xFF,0x00,0x3F,0xFF,
0xFF,0xFC,0x00,0x3F,0xFF,0xFF,0xE0,0x00,0x3F,0xFF,
0xFF,0x80,0x00,0x0F,0xFF,0xFC,0x00,0x00,0x03,0xFF,
0x80,0x00,0x09,0xF0,0x08,0x05,0x39,0xFF,0xFF,0xFF,
0xFF,0xFF,0x40,0x00,0x3F,0x80,0x00,0x68,0x00,0x07,
0xF0,0x00,0x0D,0x00,0x00,0xFE,0x00,0x01,0xA0,0x00,
0x1F,0xC0,0x00,0x34,0x00,0x03,0xF8,0x00,0x06,0x80,
0x00,0x7F,0x00,0x00,0x09,0xB1,0x2F,0xF6,0x1B,0xFC,
0x00,0x00,0x03,0xFE,0xFF,0x00,0x00,0x00,0xFF,0xBF,
0xC0,0x00,0x00,0x3F,0xEF,0xF0,0x00,0x00,0x0F,0xF9,
0xFC,0x00,0x00,0x03,0xFB,0xF8,0x00,0x00,0x0F,0xF9,
0x7F,0x00,0x00,0x03,0xF8,0xFF,0x00,0x00,0x0F,0xF0,
0xFF,0x00,0x00,0x3F,0xC1,0xFF,0x00,0x00,0xFF,0x81,
0xFF,0x00,0x03,0xFE,0x03,0xFF,0xC0,0x3F,0xFC,0x03,
0xFF,0xFF,0xFF,0xF0,0x03,0xFF,0xFF,0xFF,0xC0,0x03,
0xFF,0xFF,0xFF,0x00,0x01,0xFF,0xFF,0xF8,0x00,0x00,
0xFF,0xFF,0xC0,0x00,0x00,0x3F,0xF8,0x00,0x00,0x0B,
0x70,0x00,0x05,0xAF,0xE0,0x00,0x00,0x00,0x3F,0xBF,
0xC0,0x00,0x00,0x01,0xFF,0x0F,0xE0,0x00,0x00,0x00,
0xFE,0x3F,0xC0,0x00,0x00,0x07,0xFA,0x0F,0xE0,0x00,
0x00,0x03,0xF8,0x1F,0xC0,0x00,0x00,0x1F,0xE0,0x7F,
0x00,0x00,0x00,0x7F,0x01,0xFE,0x00,0x00,0x03,0xFC,
0x40,0x7F,0x00,0x00,0x01,0xFC,0x01,0xFE,0x00,0x00,
0x0F,0xF0,0x80,0x7F,0x00,0x00,0x07,0xF0,0x40,0x1F,
0xC0,0x00,0x07,0xF0,0x00,0x7F,0x80,0x00,0x3F,0xC0,
0x80,0x1F,0xC0,0x00,0x1F,0xC0,0x48,0x07,0xF0,0x00,
0x1F,0xC0,0x20,0x01,0xFC,0x00,0x1F,0xC0,0x00,0x07,
0xF0,0x00,0xFF,0x00,0x40,0x01,0xFC,0x00,0x7F,0x00,
0x24,0x00,0x7F,0x00,0x7F,0x00,0x10,0x00,0x1F,0xC0,
0x7F,0x00,0x00,0x00,0x3F,0x03,0xF8,0x00,0x20,0x00,
0x1F,0xC1,0xFC,0x00,0x10,0x00,0x07,0xF1,0xFC,0x00,
0x00,0x00,0x0F,0xC7,0xE0,0x00,0x20,0x00,0x07,0xF7,
0xF0,0x00,0x00,0x00,0x0F,0xDF,0x80,0x00,0x40,0x00,
0x07,0xFF,0xC0,0x00,0x20,0x00,0x01,0xFF,0xC0,0x00,
0x10,0x00,0x00,0x7F,0xC0,0x00,0x00,0x10,0x70,0x00,
0x08,0x4F,0xE0,0x00,0x00,0xFF,0x80,0x00,0x03,0xFB,
0xFC,0x00,0x00,0x3F,0xE0,0x00,0x01,0xFF,0x2F,0xE0,
0x00,0x03,0xFF,0x80,0x00,0x0F,0xE3,0xF8,0x00,0x01,
0xFF,0xF0,0x00,0x03,0xFA,0x4F,0xE0,0x00,0x0F,0xDF,
0x80,0x00,0x3F,0x83,0xF8,0x00,0x07,0xE3,0xF0,0x00,
0x0F,0xE4,0x0F,0xE0,0x00,0x3F,0x1F,0x80,0x00,0xFE,
0x03,0xF8,0x00,0x1F,0xC7,0xE0,0x00,0x3F,0x80,0xFE,
0x00,0x07,0xE0,0xFC,0x00,0x0F,0xE0,0x1F,0x80,0x01,
0xF8,0x3F,0x00,0x03,0xF0,0x07,0xF0,0x00,0x7E,0x0F,
0xC0,0x01,0xFC,0x01,0xFC,0x00,0x3F,0x83,0xF8,0x00,
0x7F,0x00,0x7F,0x00,0x0F,0xC0,0x7E,0x00,0x1F,0xC0,
0x0F,0xC0,0x03,0xF0,0x1F,0x80,0x07,0xE0,0x03,0xF8,
0x00,0xFC,0x07,0xE0,0x03,0xF8,0x20,0x1F,0xC0,0x0F,
0xC0,0x1F,0x80,0x1F,0xC0,0x03,0xF0,0x03,0xF0,0x07,
0xE0,0x07,0xE0,0x00,0xFC,0x01,0xFC,0x01,0xFC,0x03,
0xF8,0x10,0x07,0xF0,0x0F,0xC0,0x07,0xE0,0x1F,0xC0,
0x00,0xFC,0x03,0xF0,0x01,0xF8,0x07,0xE0,0x00,0x3F,
0x01,0xF8,0x00,0x3F,0x01,0xF8,0x08,0x01,0xFC,0x0F,
0xC0,0x01,0xF8,0x1F,0xC0,0x00,0x3F,0x07,0xF0,0x00,
0x7E,0x07,0xE0,0x00,0x0F,0xC1,0xF8,0x00,0x0F,0xC1,
0xF8,0x04,0x00,0x7F,0x0F,0xC0,0x00,0x7E,0x1F,0xC0,
0x00,0x1F,0xC7,0xF0,0x00,0x0F,0xC7,0xF0,0x08,0x00,
0x7E,0x3F,0x00,0x00,0x7E,0x3F,0x00,0x00,0x1F,0xCF,
0xC0,0x00,0x1F,0x9F,0xC0,0x00,0x07,0xF7,0xE0,0x00,
0x03,0xF7,0xF0,0x04,0x00,0x1F,0xBF,0x00,0x00,0x1F,
0xBF,0x00,0x00,0x07,0xFF,0xC0,0x00,0x07,0xFF,0xC0,
0x00,0x01,0xFF,0xE0,0x00,0x00,0xFF,0xF0,0x02,0x00,
0x07,0xFF,0x00,0x00,0x07,0xFF,0x00,0x10,0x00,0x3F,
0xF0,0x00,0x00,0x1F,0xF8,0x00,0x00,0x07,0xFC,0x00,
0x00,0x07,0xFC,0x00,0x00,0x0A,0xF0,0xF8,0x05,0x63,
0xFE,0x00,0x00,0x0F,0xF8,0x1F,0xE0,0x00,0x01,0xFF,
0x00,0xFF,0x00,0x00,0x1F,0xE0,0x0F,0xF8,0x00,0x03,
0xFE,0x00,0x7F,0x80,0x00,0x7F,0xC0,0x03,0xFC,0x00,
0x07,0xF8,0x00,0x3F,0xE0,0x00,0xFF,0x80,0x01,0xFE,
0x00,0x1F,0xF0,0x00,0x0F,0xF0,0x01,0xFE,0x00,0x00,
0xFF,0x80,0x3F,0xE0,0x00,0x07,0xF8,0x07,0xFC,0x00,
0x00,0x3F,0xC0,0x7F,0x80,0x00,0x01,0xFE,0x0F,0xF8,
0x00,0x00,0x1F,0xE1,0xFF,0x00,0x00,0x00,0xFF,0x1F,
0xE0,0x00,0x00,0x07,0xFB,0xFE,0x00,0x00,0x00,0x7F,
0xFF,0xC0,0x00,0x00,0x03,0xFF,0xF8,0x00,0x00,0x00,
0x1F,0xFF,0x80,0x00,0x00,0x01,0xFF,0xF0,0x00,0x00,
0x00,0x0F,0xFE,0x00,0x01,0x20,0x00,0x0F,0xF8,0x00,
0x00,0x00,0x01,0xFF,0xC0,0x00,0x20,0x00,0x07,0xFF,
0xC0,0x00,0x00,0x00,0xFF,0xFE,0x00,0x00,0x00,0x1F,
0xFF,0xF0,0x00,0x00,0x01,0xFE,0xFF,0x00,0x00,0x00,
0x3F,0xC7,0xF8,0x00,0x00,0x07,0xFC,0x7F,0xC0,0x00,
0x00,0xFF,0x83,0xFC,0x00,0x00,0x0F,0xF0,0x1F,0xE0,
0x00,0x01,0xFF,0x00,0xFF,0x00,0x00,0x3F,0xE0,0x0F,
0xF0,0x00,0x03,0xFC,0x00,0x7F,0x80,0x00,0x7F,0xC0,
0x03,0xFC,0x00,0x0F,0xF8,0x00,0x3F,0xE0,0x00,0xFF,
0x00,0x01,0xFE,0x00,0x1F,0xF0,0x00,0x0F,0xF0,0x03,
0xFE,0x00,0x00,0xFF,0x80,0x3F,0xC0,0x00,0x07,0xF8,
0x07,0xFC,0x00,0x00,0x3F,0xC0,0xFF,0x80,0x00,0x03,
0xFE,0x0F,0xF0,0x00,0x00,0x1F,0xE1,0xFF,0x00,0x00,
0x00,0xFF,0x3F,0xE0,0x00,0x00,0x0F,0xF8,0x0A,0xF0,
0x08,0x05,0xAF,0xF0,0x00,0x00,0x01,0xFE,0x7F,0x80,
0x00,0x00,0x3F,0xD0,0x7F,0x80,0x00,0x00,0xFF,0x03,
0xFC,0x00,0x00,0x1F,0xE2,0x03,0xFC,0x00,0x00,0x7F,
0x80,0x1F,0xE0,0x00,0x0F,0xF0,0x40,0x1F,0xE0,0x00,
0x3F,0xC0,0x00,0xFF,0x00,0x07,0xF8,0x00,0x0F,0xF8,
0x00,0xFF,0x80,0x00,0x7F,0x80,0x0F,0xF0,0x00,0x03,
0xFC,0x01,0xFE,0x00,0x00,0x3F,0xE0,0x3F,0xE0,0x00,
0x01,0xFE,0x03,0xFC,0x00,0x00,0x0F,0xF0,0x7F,0x80,
0x00,0x00,0xFF,0x0F,0xF8,0x00,0x00,0x07,0xF8,0xFF,
0x00,0x08,0x00,0x07,0xFB,0xFC,0x00,0x00,0x00,0x3F,
0xFF,0x80,0x01,0x00,0x00,0x3F,0xFE,0x00,0x00,0x00,
0x01,0xFF,0xC0,0x00,0x20,0x00,0x01,0xFF,0x00,0x00,
0x68,0x00,0x01,0xFC,0x00,0x00,0xD0,0x00,0x03,0xF8,
0x00,0x01,0xA0,0x00,0x07,0xF0,0x00,0x00,0x09,0xB0,
0x08,0x05,0x38,0x3F,0xFF,0xFF,0xFF,0xF0,0x00,0x00,
0x00,0x3F,0xE0,0x00,0x00,0x00,0xFF,0x80,0x00,0x00,
0x03,0xFE,0x00,0x00,0x00,0x0F,0xF8,0x00,0x00,0x00,
0x1F,0xE0,0x00,0x00,0x00,0x7F,0xC0,0x00,0x00,0x01,
0xFF,0x00,0x00,0x00,0x07,0xFC,0x04,0x00,0x00,0x03,
0xFE,0x00,0x00,0x00,0x0F,0xF8,0x00,0x00,0x00,0x3F,
0xE0,0x00,0x00,0x00,0xFF,0x80,0x00,0x00,0x01,0xFE,
0x00,0x00,0x00,0x07,0xFC,0x00,0x00,0x00,0x1F,0xF0,
0x00,0x00,0x00,0x7F,0xC0,0x00,0x00,0x01,0xFF,0x00,
0x00,0x00,0x03,0xFC,0x00,0x00,0x00,0x0F,0xF8,0x00,
0x00,0x00,0x3F,0xE0,0x00,0x00,0x00,0xFF,0x80,0x00,
0x10,0x00,0x7F,0xC0,0x00,0x00,0x01,0xFF,0x00,0x00,
0x00,0x07,0xFC,0x00,0x00,0x00,0x1F,0xF0,0x00,0x00,
0x00,0x3F,0xC0,0x00,0x00,0x00,0xFF,0x80,0x00,0x00,
0x03,0xFE,0x00,0x00,0x00,0x0F,0xF8,0x00,0x00,0x00,
0x3F,0xE0,0x00,0x00,0x00,0x7F,0x80,0x00,0x00,0x01,
0xFF,0x00,0x00,0x00,0x07,0xFC,0x00,0x00,0x00,0x1F,
0xF0,0x00,0x00,0x00,0x67,0xFF,0xFF,0xFF,0xFF,0xE0,
0x03,0x7D,0x27,0x32,0x79,0xFF,0xFD,0xFC,0x06,0xFE,
0x03,0x7F,0x01,0xBF,0x80,0xDF,0xC0,0x6F,0xE0,0x37,
0xF0,0x19,0xFF,0xF0,0x04,0xF0,0x08,0x02,0x71,0xF0,
0x00,0x25,0xF0,0x00,0x1F,0x80,0x04,0x9F,0x00,0x09,
0x1F,0x00,0x01,0xF8,0x01,0x01,0xF0,0x00,0x1F,0x80,
0x24,0x1F,0x00,0x48,0x1F,0x00,0x01,0xF8,0x09,0x01,
0xF0,0x12,0x01,0xF0,0x00,0x1F,0x82,0x40,0x1F,0x04,
0x80,0x1F,0x00,0x01,0xF8,0x80,0x01,0xF0,0x00,0x1F,
0x92,0x00,0x1F,0x24,0x00,0x1F,0x00,0x01,0xF8,0x00,
0x0F,0x80,0x03,0x7D,0x17,0x32,0x79,0xFF,0xFD,0x01,
0xFE,0x80,0xFF,0x40,0x7F,0xA0,0x3F,0xD0,0x1F,0xE8,
0x0F,0xF4,0x07,0xF9,0xFF,0xF0,0x06,0xDA,0x09,0x73,
0xC0,0x01,0xF0,0x01,0x20,0x07,0xF0,0x02,0x00,0x1F,
0xF0,0x04,0x00,0x7D,0xF0,0x00,0x0F,0xDF,0x80,0x80,
0x1F,0x1F,0x01,0x00,0x7C,0x1F,0x00,0x0F,0xC1,0xF8,
0x00,0xF8,0x0F,0x82,0x03,0xF0,0x1F,0x80,0x3E,0x00,
0xF8,0x07,0xE0,0x0F,0xC0,0x7C,0x00,0x7C,0x41,0xF8,
0x00,0xFC,0x97,0xE0,0x00,0xFC,0xFC,0x00,0x07,0xE0,
0x09,0x86,0xFF,0x34,0xB9,0xFF,0xFF,0xFF,0xFF,0xF8,
0x03,0x09,0x1A,0x72,0xCF,0xF0,0x3F,0xC0,0xFE,0x03,
0xF8,0x0F,0xC0,0x3E,0x00,0xF8,0x03,0xC0,0x0F,0x07,
0xE5,0x1F,0xF4,0xA0,0x01,0xFF,0x80,0x00,0x0F,0xFF,
0xF0,0x00,0x3F,0xFF,0xFC,0x00,0x7F,0xFF,0xFE,0x00,
0xFF,0xFF,0xFE,0x01,0xFF,0xFF,0xFF,0x03,0xFF,0x01,
0xFF,0x03,0xF8,0x00,0x7F,0x83,0xF8,0x00,0x3F,0x87,
0xF0,0x00,0x1F,0x87,0xE0,0x00,0x1F,0x80,0xE0,0x00,
0x1F,0x90,0x00,0x00,0x03,0xF0,0x00,0x00,0x0F,0xF0,
0x00,0x00,0xFF,0xF0,0x00,0x7F,0xFF,0xF0,0x07,0xFF,
0xFF,0xF0,0x0F,0xFF,0xFF,0xF0,0x3F,0xFF,0xFF,0xF0,
0x7F,0xFF,0xF3,0xF0,0x7F,0xFE,0x03,0xF0,0xFF,0x80,
0x03,0xF0,0xFE,0x00,0x03,0xF1,0xFC,0x00,0x03,0xF2,
0x3F,0x00,0x00,0xFE,0x3F,0x00,0x01,0xFE,0x3F,0x80,
0x03,0xFE,0x3F,0x80,0x07,0xFE,0x1F,0xE0,0x3F,0xFE,
0x1F,0xFF,0xFF,0xFE,0x1F,0xFF,0xFF,0xFF,0x0F,0xFF,
0xFE,0x7F,0x07,0xFF,0xFC,0x3F,0x01,0xFF,0xF0,0x1F,
0x80,0x7F,0x80,0x00,0x00,0x07,0xB1,0x27,0xF4,0xBB,
0xF8,0x00,0x00,0x05,0xFE,0x00,0x00,0x00,0xFC,0x0F,
0xE0,0x01,0xF8,0x7F,0xF8,0x03,0xF1,0xFF,0xF8,0x07,
0xE7,0xFF,0xFC,0x0F,0xDF,0xFF,0xFC,0x1F,0xFF,0xFF,
0xF8,0x3F,0xFC,0x0F,0xF8,0x7F,0xF0,0x07,0xF8,0xFF,
0x80,0x07,0xF1,0xFE,0x00,0x07,0xE3,0xFC,0x00,0x0F,
0xE8,0xFE,0x00,0x01,0xF9,0xFC,0x00,0x03,0xFE,0xFE,
0x00,0x00,0x7F,0x1F,0x80,0x00,0x1F,0xBF,0x00,0x00,
0x7F,0x8F,0xE0,0x00,0x1F,0x9F,0xC0,0x00,0x7F,0x3F,
0xC0,0x00,0xFC,0x7F,0xC0,0x03,0xF8,0xFF,0xC0,0x0F,
0xE1,0xFF,0xE0,0x7F,0xC3,0xFF,0xFF,0xFF,0x07,0xEF,
0xFF,0xFC,0x0F,0xCF,0xFF,0xF0,0x1F,0x8F,0xFF,0xC0,
0x3F,0x0F,0xFE,0x00,0x00,0x07,0xF0,0x00,0x07,0xE5,
0x1F,0xF4,0x40,0x00,0xFF,0x00,0x00,0x07,0xFF,0xE0,
0x00,0x1F,0xFF,0xF8,0x00,0x3F,0xFF,0xFC,0x00,0x7F,
0xFF,0xFE,0x00,0xFF,0xFF,0xFF,0x01,0xFF,0x81,0xFF,
0x03,0xFE,0x00,0x7F,0x83,0xF8,0x00,0x3F,0x90,0xFE,
0x00,0x03,0xF8,0xFC,0x00,0x01,0xC0,0xFC,0x00,0x00,
0x01,0xFC,0x00,0x00,0x03,0x7F,0x00,0x00,0x00,0x47,
0xE0,0x00,0x00,0x07,0xF0,0x00,0x03,0x83,0xF0,0x00,
0x03,0xF3,0xF0,0x00,0x07,0xF3,0xF8,0x00,0x07,0xE3,
0xF8,0x00,0x0F,0xE1,0xFC,0x00,0x0F,0xE1,0xFE,0x00,
0x3F,0xC0,0xFF,0xC0,0xFF,0xC0,0x7F,0xFF,0xFF,0x80,
0x3F,0xFF,0xFF,0x00,0x1F,0xFF,0xFE,0x00,0x0F,0xFF,
0xFC,0x00,0x03,0xFF,0xF0,0x00,0x00,0x7F,0x80,0x00,
0x07,0xB1,0x17,0xF4,0xBA,0x00,0x00,0x01,0xFD,0x80,
0x00,0x00,0x7E,0x00,0x1F,0xC0,0xFC,0x01,0xFF,0xE1,
0xF8,0x07,0xFF,0xE3,0xF0,0x3F,0xFF,0xE7,0xE0,0xFF,
0xFF,0xEF,0xC1,0xFF,0xFF,0xFF,0x87,0xFC,0x0F,0xFF,
0x1F,0xE0,0x07,0xFE,0x3F,0x80,0x07,0xFE,0x1F,0xC0,
0x00,0xFF,0x87,0xE0,0x00,0x1F,0xDF,0x80,0x00,0x3F,
0xEF,0xE0,0x00,0x07,0xF1,0xF8,0x00,0x01,0xFB,0xF8,
0x00,0x03,0xF8,0x7E,0x00,0x01,0xFC,0xFE,0x00,0x07,
0xF8,0xFC,0x00,0x0F,0xF1,0xFC,0x00,0x3F,0xE3,0xFC,
0x00,0xFF,0xC3,0xFE,0x07,0xFF,0x83,0xFF,0xFF,0xFF,
0x03,0xFF,0xFF,0x7E,0x03,0xFF,0xFC,0xFC,0x03,0xFF,
0xF1,0xF8,0x03,0xFF,0xC3,0xF0,0x00,0xFE,0x00,0x00,
0x08,0x25,0x17,0xF4,0xA0,0x00,0xFF,0x00,0x00,0x03,
0xFF,0xF0,0x00,0x07,0xFF,0xFE,0x00,0x07,0xFF,0xFF,
0x80,0x07,0xFF,0xFF,0xE0,0x07,0xFF,0xFF,0xF8,0x07,
0xFE,0x03,0xFE,0x03,0xF8,0x00,0x7F,0x83,0xF8,0x00,
0x1F,0xC1,0xF8,0x00,0x07,0xE4,0x3F,0x00,0x00,0x3F,
0x1F,0x00,0x00,0x0F,0x9F,0x80,0x00,0x07,0xF9,0xFF,
0xFF,0xFF,0xFF,0x3F,0x80,0x00,0x00,0x0F,0xE0,0x00,
0x00,0x03,0xF0,0x00,0x00,0x01,0xF8,0x00,0x00,0xE0,
0xFE,0x00,0x00,0xFE,0x7F,0x80,0x00,0xFE,0x1F,0xE0,
0x00,0x7F,0x0F,0xF8,0x00,0xFF,0x03,0xFF,0x01,0xFF,
0x80,0xFF,0xFF,0xFF,0x80,0x3F,0xFF,0xFF,0x80,0x0F,
0xFF,0xFF,0x80,0x03,0xFF,0xFF,0x80,0x00,0x7F,0xFF,
0x00,0x00,0x07,0xFC,0x00,0x00,0x05,0x31,0x08,0x02,
0x60,0x01,0xFE,0x00,0x3F,0xF8,0x07,0xFF,0xE0,0x0F,
0xFF,0xC0,0xFF,0xFE,0x07,0xF8,0x00,0x3F,0x80,0x60,
0x3F,0x00,0x67,0xFF,0xFE,0x68,0x3F,0x00,0x68,0x3F,
0x00,0x68,0x3F,0x00,0x68,0x3F,0x00,0x01,0xF8,0x00,
0x07,0xB2,0x17,0x24,0xA0,0x01,0xFC,0x00,0x00,0x1F,
0xFE,0x1F,0x80,0xFF,0xFF,0x3F,0x03,0xFF,0xFF,0x7F,
0x01,0xFF,0xFF,0xFF,0x87,0xFC,0x0F,0xFF,0x1F,0xE0,
0x07,0xFE,0x3F,0x80,0x07,0xFE,0x1F,0xC0,0x00,0xFF,
0x87,0xE0,0x00,0x1F,0xDF,0x80,0x00,0x3F,0xEF,0xE0,
0x00,0x07,0xF1,0xF8,0x00,0x01,0xFC,0x3F,0x00,0x00,
0xFE,0x7E,0x00,0x03,0xFC,0xFE,0x00,0x07,0xF8,0xFE,
0x00,0x1F,0xF1,0xFE,0x00,0x7F,0xE1,0xFF,0x03,0xFF,
0xE0,0x3F,0xFF,0xFF,0xF0,0x3F,0xFF,0xF7,0xE0,0x3F,
0xFF,0xCF,0xC0,0x1F,0xFF,0x1F,0x80,0x07,0xF0,0x3F,
0x90,0x00,0x00,0x0F,0xCE,0x00,0x00,0x3F,0x1F,0x80,
0x00,0x7E,0x3F,0x80,0x01,0xFC,0x7F,0x00,0x07,0xF0,
0x7F,0xC0,0x3F,0xE0,0xFF,0xFF,0xFF,0x80,0xFF,0xFF,
0xFE,0x00,0xFF,0xFF,0xF8,0x00,0xFF,0xFF,0xE0,0x00,
0x7F,0xFF,0x00,0x00,0x1F,0xF0,0x00,0x06,0xF0,0x28,
0x04,0xBB,0xF8,0x00,0x00,0x2F,0xF0,0x00,0x00,0x3F,
0x03,0xF8,0x03,0xF0,0xFF,0xF0,0x3F,0x1F,0xFF,0x83,
0xF3,0xFF,0xFC,0x3F,0x7F,0xFF,0xE3,0xFF,0xFF,0xFF,
0x3F,0xFC,0x1F,0xF3,0xFF,0x00,0x7F,0x47,0xF8,0x00,
0x7F,0x8F,0xE0,0x00,0x7F,0xBF,0x80,0x00,0xFF,0x7F,
0x00,0x01,0xFE,0xFE,0x00,0x03,0xF9,0xFC,0x00,0x07,
0xE0,0x01,0xB0,0x28,0x01,0xF9,0xFE,0x81,0xBF,0xEF,
0xFB,0xFE,0xFF,0xBF,0x80,0x03,0x7E,0xEF,0x21,0xF8,
0x03,0xFD,0x00,0x06,0x80,0xFF,0x40,0x7F,0xA0,0x3F,
0xD0,0x1F,0xE8,0x0F,0xF0,0x07,0xE0,0x3F,0x81,0xFF,
0x0F,0xFE,0x3F,0xF1,0xFF,0xC7,0xFE,0x0F,0xE0,0x07,
0x70,0x20,0x04,0x5B,0xF8,0x00,0x00,0x0C,0xFC,0x00,
0x00,0x03,0xF0,0x00,0x7F,0x8F,0xC0,0x03,0xFC,0x3F,
0x00,0x1F,0xE0,0xFC,0x00,0xFF,0x03,0xF0,0x07,0xF8,
0x0F,0xC0,0x3F,0xC0,0x3F,0x01,0xFE,0x00,0xFC,0x0F,
0xF0,0x03,0xF0,0x7F,0x80,0x0F,0xC3,0xFC,0x00,0x3F,
0x1F,0xE0,0x00,0xFC,0xFF,0x00,0x03,0xF7,0xF8,0x00,
0x0F,0xFF,0xE0,0x00,0x47,0xFF,0xF8,0x00,0x1F,0xFF,
0xF0,0x00,0x7F,0xEF,0xE0,0x01,0xFF,0x3F,0x80,0x07,
0xF8,0x7F,0x00,0x1F,0xC0,0xFE,0x00,0x7E,0x03,0xF8,
0x01,0xF8,0x07,0xF0,0x07,0xE0,0x0F,0xC0,0x1F,0x80,
0x3F,0x80,0x8F,0xC0,0x0F,0xE0,0x3F,0x00,0x1F,0xC1,
0x1F,0x80,0x07,0xF0,0x7E,0x00,0x0F,0xE2,0x3F,0x00,
0x03,0xF8,0xFC,0x00,0x07,0xF3,0xF0,0x00,0x0F,0xE0,
0x01,0xB0,0x28,0x01,0xFB,0xFE,0xFF,0xBF,0xEF,0xFB,
0xFE,0xFF,0x9F,0x80,0x0C,0x24,0x20,0x07,0x20,0x00,
0x7F,0x00,0x03,0xF8,0x07,0xE0,0xFF,0xE0,0x0F,0xFF,
0x03,0xF1,0xFF,0xF8,0x0F,0xFF,0xE1,0xF9,0xFF,0xFE,
0x0F,0xFF,0xF8,0xFD,0xFF,0xFF,0x8F,0xFF,0xFC,0x7E,
0xFF,0xFF,0xEF,0xFF,0xFF,0x3F,0xFC,0x0F,0xFF,0xE0,
0xFF,0x9F,0xF8,0x03,0xFF,0xC0,0x1F,0xEF,0xF8,0x00,
0xFF,0x80,0x07,0xF7,0xF8,0x00,0x7F,0xC0,0x03,0xFC,
0x7F,0x00,0x03,0xF8,0x00,0x1F,0xBF,0x80,0x01,0xF8,
0x00,0x0F,0xF7,0xF0,0x00,0x1F,0x80,0x00,0xFF,0x7F,
0x00,0x01,0xF8,0x00,0x0F,0xF7,0xF0,0x00,0x1F,0x80,
0x00,0xFE,0x3F,0x00,0x01,0xF8,0x00,0x0F,0xC0,0x06,
0xE4,0x28,0x04,0xA0,0x00,0x7F,0x00,0xFC,0x3F,0xFC,
0x0F,0xC7,0xFF,0xF0,0xFC,0xFF,0xFF,0x8F,0xDF,0xFF,
0xF8,0xFF,0xFF,0xFF,0xCF,0xFF,0x07,0xFC,0xFF,0xC0,
0x1F,0xD1,0xFE,0x00,0x1F,0xE3,0xF8,0x00,0x1F,0xEF,
0xE0,0x00,0x3F,0xDF,0xC0,0x00,0x7F,0xBF,0x80,0x00,
0xFE,0x7F,0x00,0x01,0xF8,0x07,0xE5,0x1F,0xF4,0xA0,
0x01,0xFF,0x00,0x00,0x07,0xFF,0xC0,0x00,0x1F,0xFF,
0xF0,0x00,0x3F,0xFF,0xF8,0x00,0x7F,0xFF,0xFC,0x00,
0xFF,0xFF,0xFE,0x01,0xFF,0x83,0xFF,0x03,0xFE,0x00,
0xFF,0x83,0xF8,0x00,0x3F,0x90,0xFE,0x00,0x03,0xFA,
0x1F,0x80,0x00,0x3F,0x3F,0x80,0x00,0x3F,0xEF,0xE0,
0x00,0x03,0xF8,0xFC,0x00,0x00,0x7E,0xFE,0x00,0x00,
0xFF,0x0F,0xC0,0x00,0x1F,0xA1,0xFC,0x00,0x07,0xF0,
0xFE,0x00,0x0F,0xE0,0xFF,0x00,0x3F,0xE0,0x7F,0xC0,
0x7F,0xC0,0x3F,0xFF,0xFF,0x80,0x3F,0xFF,0xFF,0x00,
0x0F,0xFF,0xFE,0x00,0x07,0xFF,0xFC,0x00,0x03,0xFF,
0xF0,0x00,0x00,0x7F,0xC0,0x00,0x07,0xB1,0x27,0x34,
0xA0,0x00,0xFE,0x00,0x1F,0x87,0xFF,0x80,0x3F,0x1F,
0xFF,0xC0,0x7E,0x7F,0xFF,0xC1,0x1F,0xBF,0xFF,0xF8,
0x3F,0xFE,0x0F,0xF8,0x7F,0xF0,0x07,0xF8,0xFF,0xC0,
0x07,0xF1,0xFF,0x00,0x07,0xF3,0xFC,0x00,0x0F,0xE8,
0xFE,0x00,0x01,0xF9,0xFC,0x00,0x03,0xFE,0xFE,0x00,
0x00,0x7F,0x1F,0x80,0x00,0x1F,0xBF,0x00,0x00,0x7F,
0x8F,0xE0,0x00,0x1F,0x9F,0xE0,0x00,0x7F,0x3F,0xC0,
0x00,0xFC,0x7F,0xC0,0x03,0xF8,0xFF,0xC0,0x0F,0xE1,
0xFF,0xE0,0x7F,0xC3,0xFF,0xFF,0xFF,0x07,0xEF,0xFF,
0xFC,0x0F,0xDF,0xFF,0xF0,0x1F,0x8F,0xFF,0xC0,0x3F,
0x0F,0xFE,0x00,0x7E,0x07,0xF0,0x01,0xBF,0x80,0x00,
0x00,0x5F,0xE0,0x00,0x00,0x00,0x07,0xB1,0x17,0x34,
0xA0,0x01,0xF8,0x00,0x00,0x1F,0xFC,0x1F,0x80,0xFF,
0xFE,0x3F,0x03,0xFF,0xFE,0x7E,0x0F,0xFF,0xFE,0xFC,
0x3F,0xFF,0xFD,0xF8,0x7F,0xC1,0xFF,0xF1,0xFE,0x00,
0xFF,0xE3,0xF8,0x00,0x7F,0xCF,0xE0,0x00,0xFF,0x9F,
0xC0,0x00,0xFF,0x87,0xE0,0x00,0x1F,0xDF,0x80,0x00,
0x3F,0xEF,0xE0,0x00,0x07,0xF1,0xF8,0x00,0x01,0xFB,
0xF8,0x00,0x03,0xF8,0x7E,0x00,0x01,0xFC,0xFE,0x00,
0x07,0xF8,0xFC,0x00,0x0F,0xF1,0xFC,0x00,0x3F,0xE1,
0xFC,0x00,0xFF,0xC3,0xFE,0x07,0xFF,0x83,0xFF,0xFF,
0xFF,0x03,0xFF,0xFF,0x7E,0x03,0xFF,0xFE,0xFC,0x03,
0xFF,0xF1,0xF8,0x01,0xFF,0xC3,0xF0,0x00,0xFE,0x07,
0xFA,0x00,0x00,0x01,0xFD,0x80,0x00,0x00,0x7E,0x04,
0xA4,0x28,0x02,0xC0,0x03,0xE1,0xF1,0xFF,0x3E,0x7F,
0xF7,0xDF,0xFE,0xFB,0xFF,0x9F,0xFF,0xF3,0xFF,0x0C,
0x7F,0xC0,0x0F,0xF0,0x02,0x7F,0x80,0x0D,0xFC,0x00,
0x37,0xF0,0x00,0xDF,0xC0,0x02,0x7F,0x00,0x00,0x07,
0x65,0x17,0xF4,0x40,0x07,0xFC,0x00,0x00,0x7F,0xFE,
0x00,0x07,0xFF,0xFE,0x00,0x3F,0xFF,0xFC,0x01,0xFF,
0xFF,0xF8,0x0F,0xFF,0xFF,0xF0,0x3F,0xC0,0x7F,0xC1,
0xFC,0x00,0x7F,0x07,0xE0,0x00,0xFE,0x1F,0x80,0x01,
0xF8,0x7E,0x00,0x07,0x01,0xFC,0x00,0x00,0x07,0xF8,
0x00,0x00,0x1F,0xFC,0x00,0x00,0x3F,0xFE,0x00,0x00,
0xFF,0xFF,0x80,0x01,0xFF,0xFF,0x80,0x03,0xFF,0xFF,
0xC0,0x03,0xFF,0xFF,0xC0,0x03,0xFF,0xFF,0x80,0x01,
0xFF,0xFF,0x00,0x00,0xFF,0xFC,0x00,0x00,0x3F,0xF8,
0x00,0x00,0x1F,0xE0,0x00,0x00,0x3F,0x87,0x00,0x00,
0x7E,0xFC,0x00,0x01,0xFB,0xF8,0x00,0x07,0xE7,0xF0,
0x00,0x3F,0x9F,0xE0,0x01,0xFC,0x7F,0xE0,0x1F,0xF0,
0xFF,0xFF,0xFF,0x81,0xFF,0xFF,0xFC,0x03,0xFF,0xFF,
0xE0,0x07,0xFF,0xFF,0x00,0x07,0xFF,0xF0,0x00,0x03,
0xFE,0x00,0x00,0x04,0x70,0x0F,0xF2,0x60,0x04,0x00,
0x07,0x00,0x03,0xC0,0x68,0x7E,0x02,0x03,0xF0,0x19,
0xFF,0xFE,0xD0,0xFC,0x06,0x87,0xE0,0x34,0x3F,0x01,
0x01,0xF8,0x00,0x7F,0x02,0x03,0xFF,0xC0,0x7F,0xF0,
0x1F,0xFE,0x03,0xFF,0x80,0x3F,0xE0,0x06,0xE4,0x2F,
0xF4,0xBB,0xF8,0x00,0x0F,0xF7,0xF0,0x00,0x1F,0xEF,
0xE0,0x00,0x3F,0x9F,0xC0,0x00,0x7F,0x1F,0x80,0x01,
0xFE,0x3F,0x80,0x07,0xF9,0xFC,0x01,0xFF,0x9F,0xF0,
0x7F,0xF9,0xFF,0xFF,0xDF,0x8F,0xFF,0xFD,0xF8,0x7F,
0xFF,0x9F,0x83,0xFF,0xF1,0xF8,0x1F,0xFC,0x1F,0x80,
0x7F,0x00,0x00,0x07,0xE3,0x08,0x04,0x2F,0xE0,0x00,
0x07,0xEF,0xE0,0x00,0x0F,0xE7,0xE0,0x00,0x0F,0xC7,
0xF0,0x00,0x0F,0xC7,0xF0,0x00,0x1F,0xC3,0xF0,0x00,
0x1F,0x83,0xF8,0x00,0x1F,0x83,0xF8,0x00,0x3F,0x81,
0xF8,0x00,0x3F,0x01,0xFC,0x00,0x3F,0x01,0xFC,0x00,
0x7F,0x00,0xFC,0x00,0x7E,0x00,0xFE,0x00,0x7E,0x00,
0xFE,0x00,0xFE,0x00,0x7E,0x00,0xFC,0x00,0x7F,0x00,
0xFC,0x00,0x7F,0x01,0xFC,0x00,0x3F,0x01,0xF8,0x00,
0x3F,0x81,0xF8,0x00,0x3F,0x83,0xF8,0x10,0x03,0xF0,
0x7E,0x00,0x03,0xF8,0xFE,0x02,0x00,0x3F,0x1F,0x80,
0x00,0x3F,0xBF,0x80,0x40,0x03,0xF7,0xE0,0x00,0x03,
0xFF,0xE0,0x09,0x00,0x3F,0xF8,0x01,0x20,0x03,0xFE,
0x00,0x00,0x0B,0xE3,0x00,0x05,0xF1,0xF8,0x00,0x1F,
0xC0,0x00,0xFD,0xF8,0x00,0x1F,0xE0,0x00,0xFE,0x5F,
0x80,0x07,0xFC,0x00,0x3F,0x1F,0xC0,0x07,0xFE,0x00,
0x7F,0x0F,0xC0,0x0F,0xFE,0x00,0x7E,0x0F,0xC0,0x0F,
0xBE,0x00,0x7E,0x0F,0xC0,0x0F,0xBE,0x00,0xFE,0x07,
0xE0,0x0F,0xBF,0x00,0xFC,0x07,0xE0,0x1F,0xBF,0x00,
0xFC,0x07,0xE0,0x1F,0x3F,0x00,0xFC,0x03,0xF0,0x1F,
0x1F,0x01,0xF8,0x03,0xF0,0x1F,0x1F,0x81,0xF8,0x03,
0xF0,0x3F,0x1F,0x81,0xF8,0x03,0xF8,0x3F,0x1F,0x83,
0xF0,0x01,0xF8,0x3E,0x0F,0x83,0xF0,0x40,0x3F,0x0F,
0xC1,0xF8,0x7E,0x00,0x1F,0x8F,0xC1,0xF8,0xFC,0x00,
0x1F,0x8F,0x80,0xF8,0xFC,0x00,0x1F,0x9F,0x80,0xFC,
0xFC,0x00,0x0F,0x9F,0x80,0xFD,0xF8,0x00,0x0F,0xDF,
0x80,0xFD,0xF8,0x00,0x0F,0xDF,0x00,0x7D,0xF8,0x00,
0x07,0xDF,0x00,0x7D,0xF0,0x08,0x00,0xFF,0xE0,0x0F,
0xFE,0x00,0x00,0xFF,0xC0,0x07,0xFE,0x01,0x20,0x0F,
0xF8,0x00,0xFF,0x80,0x00,0x07,0xF0,0x00,0xFF,0x00,
0x00,0x07,0xF0,0x00,0x7F,0x00,0x00,0x08,0x23,0x00,
0x04,0x07,0xF8,0x00,0x07,0xF1,0xFC,0x00,0x07,0xF0,
0x7F,0x00,0x07,0xF0,0x3F,0xC0,0x07,0xF8,0x0F,0xE0,
0x03,0xF8,0x03,0xF8,0x03,0xF8,0x01,0xFE,0x03,0xFC,
0x00,0x7F,0x01,0xFC,0x00,0x1F,0xC1,0xFC,0x00,0x0F,
0xF1,0xFC,0x00,0x03,0xF9,0xFE,0x00,0x00,0xFE,0xFE,
0x01,0x00,0x07,0xFF,0xC0,0x00,0x01,0xFF,0xC0,0x00,
0x00,0x7F,0xC0,0x04,0x00,0x07,0xF8,0x00,0x00,0x03,
0xFE,0x00,0x00,0x03,0xFF,0x00,0x00,0x03,0xFF,0xC0,
0x00,0x01,0xFF,0xF0,0x00,0x01,0xFF,0xF8,0x00,0x01,
0xFC,0xFE,0x00,0x01,0xFE,0x3F,0x80,0x00,0xFE,0x1F,
0xE0,0x00,0xFE,0x07,0xF0,0x00,0xFF,0x01,0xFC,0x00,
0x7F,0x00,0xFF,0x00,0x7F,0x00,0x3F,0x80,0x7F,0x00,
0x0F,0xE0,0x7F,0x80,0x07,0xF8,0x3F,0x80,0x01,0xFC,
0x3F,0x80,0x00,0x7F,0x3F,0xC0,0x00,0x3F,0xC0,0x07,
0xF1,0x0F,0x24,0x2F,0xE0,0x00,0x07,0xE7,0xE0,0x00,
0x0F,0xE7,0xE0,0x00,0x0F,0xC7,0xF0,0x00,0x0F,0xC3,
0xF0,0x00,0x1F,0xC3,0xF0,0x00,0x1F,0x83,0xF8,0x00,
0x1F,0x81,0xF8,0x00,0x3F,0x81,0xFC,0x00,0x3F,0x00,
0xFC,0x00,0x3F,0x00,0xFC,0x00,0x7F,0x00,0xFE,0x00,
0x7E,0x00,0x7E,0x00,0x7E,0x00,0x7F,0x00,0xFE,0x00,
0x7F,0x00,0xFC,0x00,0x3F,0x00,0xFC,0x00,0x3F,0x81,
0xFC,0x10,0x03,0xF0,0x3F,0x00,0x03,0xF8,0x7F,0x00,
0x01,0xF8,0x7E,0x00,0x01,0xFC,0x7E,0x00,0x01,0xFC,
0xFE,0x00,0x00,0xFC,0xFC,0x00,0x00,0xFE,0xFC,0x00,
0x00,0x7F,0xFC,0x02,0x00,0x0F,0xFF,0x00,0x00,0x07,
0xFF,0x00,0x40,0x00,0xFF,0xC0,0x00,0x00,0x7F,0xC0,
0x00,0x00,0x7F,0x80,0x00,0x00,0x3F,0x80,0x08,0x00,
0x07,0xE0,0x00,0x00,0x0F,0xE0,0x01,0x00,0x01,0xF8,
0x00,0x00,0x03,0xF8,0x00,0x00,0x03,0xF0,0x00,0x00,
0x07,0xF0,0x00,0x00,0x1F,0xE0,0x00,0x07,0xFF,0xE0,
0x00,0x07,0xFF,0xC0,0x00,0x03,0xFF,0x80,0x00,0x03,
0xFF,0x00,0x00,0x03,0xFE,0x00,0x00,0x01,0xF8,0x00,
0x00,0x00,0x07,0xA3,0x08,0x04,0x38,0x7F,0xFF,0xFF,
0xF0,0x00,0x00,0x3F,0xC0,0x00,0x00,0xFF,0x00,0x00,
0x03,0xFC,0x00,0x00,0x0F,0xF0,0x00,0x00,0x1F,0xC0,
0x00,0x00,0x7F,0x00,0x00,0x01,0xFE,0x00,0x00,0x07,
0xF8,0x00,0x00,0x1F,0xE0,0x00,0x00,0x7F,0x80,0x00,
0x01,0xFE,0x00,0x00,0x07,0xF8,0x00,0x00,0x1F,0xE0,
0x00,0x00,0x3F,0x80,0x00,0x00,0xFE,0x00,0x00,0x03,
0xFC,0x00,0x00,0x0F,0xF0,0x00,0x00,0x3F,0xC0,0x00,
0x00,0xFF,0x00,0x00,0x03,0xFC,0x00,0x00,0x0F,0xF0,
0x00,0x00,0x1F,0xC0,0x00,0x00,0x7F,0x00,0x00,0x03,
0x3F,0xFF,0xFF,0xFF,0x05,0x3F,0x0F,0x22,0xC0,0x00,
0x7F,0x00,0x0F,0xF8,0x00,0xFF,0xC0,0x0F,0xFF,0x00,
0x1F,0xFE,0x01,0xFE,0x00,0x0F,0xE0,0x68,0x0F,0xC0,
0x68,0x0F,0xC0,0x00,0x7E,0x02,0x00,0xFC,0x00,0x0F,
0xE0,0x00,0xFE,0x00,0x0F,0xF0,0x03,0xFF,0x00,0x1F,
0xF0,0x01,0x1F,0xC0,0x00,0xFF,0x00,0x07,0xFE,0x00,
0x07,0xF8,0x00,0x1F,0xC0,0x00,0x7F,0x00,0x80,0x3F,
0x00,0xD0,0x1F,0x80,0xD0,0x1F,0x80,0x80,0x1F,0x80,
0x00,0xFE,0x00,0x03,0xF8,0x20,0x03,0xFF,0xC0,0x0F,
0xFE,0x00,0x3F,0xF0,0x00,0xFF,0x80,0x01,0xFC,0x01,
0x7F,0x37,0x12,0x3B,0xFD,0xFE,0xFF,0x7F,0xBF,0xDF,
0xEF,0xF7,0xFB,0xF0,0x05,0x3F,0x0F,0x22,0xCF,0xE0,
0x00,0x7F,0xC0,0x03,0xFF,0x00,0x1F,0xFC,0x01,0x1F,
0xFE,0x00,0x07,0xF0,0x00,0x1F,0xC0,0x68,0x0F,0xC0,
0x68,0x0F,0xC0,0x00,0x7E,0x02,0x00,0x3F,0x00,0x01,
0xFC,0x00,0x07,0xF0,0x00,0x3F,0xC0,0x00,0xFF,0xC0,
0x01,0xFF,0x00,0x00,0xFE,0x00,0x1F,0xF0,0x01,0xFF,
0x80,0x1F,0xE0,0x00,0xFE,0x00,0x0F,0xE0,0x00,0x7E,
0x00,0x07,0xF0,0x34,0x07,0xE0,0x34,0x07,0xE0,0x20,
0x07,0xE0,0x00,0x7F,0x00,0x07,0xF8,0x08,0xFF,0xF0,
0x07,0xFF,0x00,0x3F,0xF0,0x01,0xFF,0x00,0x0F,0xE0,
0x00,0x08,0x8D,0x11,0x04,0xE0,0x3F,0x00,0x00,0x00,
0x1F,0xFC,0x00,0x00,0x87,0xFF,0xE0,0x00,0x31,0xFF,
0xFF,0x00,0x0E,0x7F,0xFF,0xF8,0x03,0xDF,0xFF,0xFF,
0xC1,0xFB,0xFF,0xFF,0xFF,0xFF,0x7E,0x0F,0xFF,0xFF,
0xEF,0x00,0x3F,0xFF,0xF9,0xC0,0x03,0xFF,0xFE,0x30,
0x00,0x1F,0xFF,0x84,0x00,0x00,0xFF,0xE0,0x00,0x00,
0x07,0xF0,0x00,};
/* font data size: 10693 bytes */

static const unsigned char font_tgx_Arial_48_index[] = {
0x00,0x00,0x00,0x50,0x05,0x80,0x23,
0x02,0x10,0x14,0xE0,0xA4,0x83,0x88,0x0E,0x44,0x3D,
0xF1,0x0B,0x44,0x60,0x11,0xEC,0x48,0x71,0x23,0xC4,
0x95,0x13,0x64,0x55,0x81,0x63,0x86,0x2D,0x1B,0x7C,
0x76,0x61,0xFC,0x48,0x9C,0x24,0x04,0x9A,0x72,0x93,
0x4A,0x59,0x29,0xB0,0xAF,0x52,0xC2,0xCB,0x94,0x30,
0x8C,0xE1,0x83,0xB3,0xCF,0x89,0x41,0x59,0x0F,0x74,
0x49,0x11,0x4D,0x48,0x89,0x25,0x14,0x97,0xD2,0xA5,
0x4E,0x6D,0x3B,0xE5,0x10,0x15,0x0B,0x57,0xC5,0x66,
0xA5,0xD8,0x58,0x30,0x64,0x59,0x94,0x06,0x67,0xDA,
0x51,0x6D,0xED,0xC7,0x87,0x41,0x1D,0xBA,0x77,0x49,
0xE1,0x67,0x8B,0x9E,0x6E,0x79,0xE1,0xE8,0xB7,0xC7,
0x5F,0x98,0x80,0x4A,0x08,0xA8,0x42,0x21,0x34,0x87,
0x1E,0x20,0x78,0x85,0x62,0x37,0x8A,0xEA,0x2C,0x88,
0xCC,0x63,0x69,0x8F,0x62,0x45,0x09,0x32,0xE4,0xF3,
0x96,0x0E,0x5A,0xF9,0x79,0xE6,0x5E,0x9C,0x36,0x79,
0xBA,0x14,0xA8,0xB8,0xA4,0x5E,0x92,0x6A,0x61,0xC0,
};
/* font index size: 167 bytes */

const ILI9341_t3_font_t font_tgx_Arial_48 = {
	font_tgx_Arial_48_index,
	0,
	font_tgx_Arial_48_data,
	1,
	0,
	32,
	126,
	0,
	0,
	14,
	7,
	6,
	5,
	7,
	7,
	74,
	48
};



static const unsigned char font_tgx_Arial_60_data[] = {
0x00,0x00,0x00,0x01,0x70,0x01,0xDE,0x24,0x01,0x9D,
0xFF,0xBF,0xF7,0xFB,0xF9,0xFE,0xBE,0xD7,0xD0,0xFB,
0x4E,0x0E,0x60,0x0D,0xFE,0x05,0x8A,0x8D,0x39,0xDD,
0xFE,0x01,0xFF,0x3F,0x80,0x7F,0xD7,0xC0,0x0F,0x87,
0x80,0x0E,0x00,0x0B,0x5E,0x00,0x02,0xE8,0x00,0x00,
0x7F,0x00,0x3F,0x80,0x00,0x03,0xFC,0x01,0xFC,0x12,
0x00,0x01,0xFC,0x00,0xFE,0x00,0x00,0x07,0xF0,0x07,
0xF8,0x00,0x00,0x3F,0xC0,0x1F,0xC0,0x90,0x00,0x1F,
0xC0,0x0F,0xE0,0x00,0x00,0xFF,0x00,0x7F,0x81,0x40,
0x00,0x7F,0x00,0x3F,0x80,0xDF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xC0,0x00,0x7F,0x00,0x3F,0x80,0x00,0x03,0xFC,
0x01,0xFC,0x00,0x90,0x01,0xFC,0x00,0xFE,0x00,0x00,
0x07,0xF0,0x07,0xF8,0x00,0x00,0x3F,0xC0,0x1F,0xC0,
0x04,0x80,0x1F,0xC0,0x0F,0xE0,0x00,0x00,0x7F,0x00,
0x7F,0x80,0x08,0x00,0x7F,0x00,0x3F,0x80,0x06,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFE,0x80,0x7F,0x00,0x3F,0x80,
0x00,0x03,0xFC,0x01,0xFE,0x00,0x04,0x81,0xFC,0x00,
0xFE,0x00,0x00,0x07,0xF0,0x07,0xF8,0x00,0x00,0x3F,
0xC0,0x1F,0xC0,0x00,0x24,0x1F,0xC0,0x0F,0xE0,0x00,
0x00,0x7F,0x00,0x7F,0x80,0x00,0x40,0x7F,0x00,0x3F,
0x80,0x00,0x00,0x09,0xE3,0x8F,0xC2,0xE9,0x00,0x00,
0x3C,0x00,0x00,0x00,0x03,0xFF,0x80,0x00,0x00,0x1F,
0xFF,0xF0,0x00,0x00,0x7F,0xFF,0xFC,0x00,0x01,0xFF,
0xFF,0xFE,0x00,0x03,0xFF,0xFF,0xFF,0x00,0x07,0xFF,
0xFF,0xFF,0x80,0x0F,0xFF,0xFF,0xFF,0xC0,0x1F,0xFE,
0x3F,0xFF,0xE0,0x1F,0xF8,0x3C,0xFF,0xE0,0x3F,0xE0,
0x3C,0x3F,0xF0,0x3F,0xC0,0x3C,0x1F,0xF0,0x7F,0x80,
0x3C,0x0F,0xF0,0x7F,0x80,0x3C,0x07,0xF8,0x7F,0x00,
0x3C,0x07,0xF8,0x7F,0x00,0x3C,0x03,0xF8,0x7F,0x00,
0x3C,0x03,0xC1,0x0F,0xE0,0x07,0x80,0x00,0x21,0xFE,
0x00,0xF0,0x00,0x00,0xFF,0x00,0xF0,0x00,0x00,0xFF,
0x80,0xF0,0x00,0x00,0x7F,0xE0,0xF0,0x00,0x00,0x7F,
0xF8,0xF0,0x00,0x00,0x3F,0xFF,0xF0,0x00,0x00,0x1F,
0xFF,0xF0,0x00,0x00,0x0F,0xFF,0xFF,0x00,0x00,0x03,
0xFF,0xFF,0xE0,0x00,0x01,0xFF,0xFF,0xF8,0x00,0x00,
0x3F,0xFF,0xFE,0x00,0x00,0x0F,0xFF,0xFF,0x00,0x00,
0x00,0xFF,0xFF,0x80,0x00,0x00,0xFF,0xFF,0xC0,0x00,
0x00,0xF1,0xFF,0xE0,0x00,0x00,0xF0,0x7F,0xE0,0x00,
0x00,0xF0,0x1F,0xF0,0x00,0x00,0xF0,0x0F,0xF0,0x00,
0x00,0xF0,0x07,0xF0,0x00,0x00,0xF0,0x07,0xFC,0x80,
0x00,0x1E,0x00,0x7F,0x0F,0x00,0x1E,0x00,0x7F,0x7F,
0x00,0x1E,0x00,0x7F,0x8F,0xF0,0x03,0xC0,0x0F,0xEF,
0xF0,0x03,0xC0,0x1F,0xE7,0xF8,0x03,0xC0,0x1F,0xC7,
0xF8,0x03,0xC0,0x3F,0xC7,0xFC,0x03,0xC0,0x7F,0xC3,
0xFE,0x03,0xC0,0xFF,0x83,0xFF,0x83,0xC1,0xFF,0x81,
0xFF,0xE3,0xCF,0xFF,0x01,0xFF,0xFF,0xFF,0xFE,0x00,
0xFF,0xFF,0xFF,0xFC,0x00,0x7F,0xFF,0xFF,0xF8,0x00,
0x3F,0xFF,0xFF,0xF0,0x00,0x1F,0xFF,0xFF,0xE0,0x00,
0x07,0xFF,0xFF,0x80,0x00,0x01,0xFF,0xFC,0x00,0x00,
0x00,0x1F,0xC0,0x00,0x1A,0x00,0x00,0x78,0x00,0x00,
0x10,0x1F,0x17,0xFC,0xA0,0x03,0xF8,0x00,0x00,0x00,
0x3F,0x80,0x00,0x0F,0xFF,0x00,0x00,0x00,0x1F,0x80,
0x00,0x0F,0xFF,0xE0,0x00,0x00,0x1F,0xC0,0x00,0x0F,
0xFF,0xF8,0x00,0x00,0x0F,0xC0,0x00,0x0F,0xFF,0xFE,
0x00,0x00,0x0F,0xE0,0x00,0x07,0xF0,0x7F,0x00,0x00,
0x07,0xE0,0x00,0x07,0xF0,0x1F,0xC0,0x00,0x07,0xF0,
0x00,0x07,0xF0,0x07,0xE0,0x00,0x07,0xF0,0x00,0x03,
0xF0,0x01,0xF8,0x00,0x03,0xF8,0x00,0x04,0x3F,0x00,
0x1F,0x80,0x00,0x7F,0x00,0x00,0x3F,0x00,0x07,0xE0,
0x00,0x7F,0x00,0x00,0x1F,0x80,0x03,0xF0,0x00,0x3F,
0x00,0x00,0x0F,0xC0,0x01,0xF8,0x00,0x3F,0x80,0x00,
0x07,0xE0,0x00,0xFC,0x00,0x1F,0x80,0x00,0x03,0xF0,
0x00,0x7E,0x00,0x1F,0xC0,0x00,0x01,0xF8,0x00,0x3F,
0x00,0x0F,0xC0,0x00,0x00,0xFC,0x00,0x1F,0x80,0x0F,
0xE0,0x00,0x00,0x7E,0x00,0x0F,0xC0,0x07,0xE0,0x00,
0x00,0x3F,0x00,0x07,0xE0,0x07,0xF0,0x00,0x00,0x1F,
0x80,0x03,0xF0,0x03,0xF0,0x00,0x00,0x07,0xC0,0x03,
0xF0,0x03,0xF8,0x00,0x00,0x08,0x7E,0x00,0x3F,0x00,
0x7F,0x00,0x00,0x00,0x3F,0x80,0x3F,0x00,0x7F,0x00,
0x00,0x00,0x0F,0xE0,0x3F,0x80,0x3F,0x80,0x00,0x00,
0x07,0xF8,0x3F,0x80,0x3F,0x80,0x00,0x00,0x01,0xFF,
0xFF,0xC0,0x1F,0x80,0x00,0x00,0x00,0x7F,0xFF,0xC0,
0x1F,0xC0,0x00,0x00,0x00,0x1F,0xFF,0xC0,0x0F,0xC0,
0x00,0x00,0x00,0x03,0xFF,0x80,0x0F,0xE0,0x01,0xFC,
0x00,0x00,0x7F,0x00,0x07,0xE0,0x07,0xFF,0x80,0x00,
0x00,0x00,0x07,0xF0,0x07,0xFF,0xF0,0x00,0x00,0x00,
0x03,0xF0,0x07,0xFF,0xFC,0x00,0x00,0x00,0x03,0xF8,
0x07,0xFF,0xFF,0x00,0x00,0x00,0x01,0xF8,0x03,0xF8,
0x3F,0x80,0x00,0x00,0x01,0xFC,0x03,0xF8,0x0F,0xE0,
0x00,0x00,0x00,0xFC,0x03,0xF8,0x03,0xF0,0x00,0x00,
0x00,0xFE,0x01,0xF8,0x00,0xFD,0x00,0x00,0x00,0x1F,
0xC0,0x1F,0x80,0x0F,0xD0,0x00,0x00,0x03,0xF8,0x03,
0xF0,0x00,0x7E,0x00,0x00,0x03,0xF8,0x01,0xF8,0x00,
0x3F,0x00,0x00,0x01,0xF8,0x00,0xFC,0x00,0x1F,0x80,
0x00,0x01,0xFC,0x00,0x7E,0x00,0x0F,0xC0,0x00,0x00,
0xFC,0x00,0x3F,0x00,0x07,0xE0,0x00,0x00,0xFE,0x00,
0x1F,0x80,0x03,0xF0,0x00,0x00,0x7E,0x00,0x0F,0xC0,
0x01,0xF8,0x00,0x00,0x7F,0x00,0x07,0xE0,0x00,0xFC,
0x00,0x00,0x3F,0x00,0x03,0xF0,0x00,0x7E,0x00,0x00,
0x3F,0x80,0x00,0xF8,0x00,0x7E,0x00,0x00,0x1F,0x80,
0x00,0x7E,0x00,0x3F,0x00,0x00,0x1F,0xC0,0x00,0x3F,
0x00,0x1F,0x80,0x00,0x1F,0xC0,0x00,0x1F,0xC0,0x1F,
0x80,0x00,0x0F,0xE0,0x00,0x07,0xF0,0x1F,0xC0,0x00,
0x0F,0xE0,0x00,0x03,0xFC,0x1F,0xC0,0x00,0x07,0xF0,
0x00,0x00,0xFF,0xFF,0xE0,0x00,0x07,0xF0,0x00,0x00,
0x3F,0xFF,0xE0,0x00,0x03,0xF0,0x00,0x00,0x0F,0xFF,
0xE0,0x00,0x03,0xF8,0x00,0x00,0x01,0xFF,0xC0,0x00,
0x01,0xF8,0x00,0x00,0x00,0x3F,0x80,0x00,0x0C,0x5F,
0x13,0xFB,0x70,0x00,0x03,0xFC,0x00,0x00,0x00,0x00,
0x03,0xFF,0xE0,0x00,0x00,0x00,0x03,0xFF,0xFE,0x00,
0x00,0x00,0x01,0xFF,0xFF,0xC0,0x00,0x00,0x00,0xFF,
0xFF,0xF8,0x00,0x00,0x00,0x7F,0xFF,0xFF,0x00,0x00,
0x00,0x3F,0xFF,0xFF,0xC0,0x00,0x00,0x1F,0xF8,0x1F,
0xF8,0x00,0x00,0x07,0xFC,0x03,0xFE,0x00,0x00,0x01,
0xFE,0x00,0x7F,0x80,0x00,0x00,0xFF,0x00,0x0F,0xF0,
0x00,0x2C,0x07,0xF0,0x00,0x3F,0x80,0x00,0x01,0xFE,
0x00,0x0F,0xE0,0x00,0x00,0x3F,0x80,0x07,0xF0,0x00,
0x00,0x0F,0xF0,0x01,0xFC,0x00,0x00,0x03,0xFC,0x00,
0xFE,0x00,0x00,0x00,0x7F,0x80,0x7F,0x80,0x00,0x00,
0x0F,0xF0,0x7F,0xC0,0x00,0x00,0x03,0xFE,0x3F,0xE0,
0x00,0x00,0x00,0x7F,0xFF,0xF0,0x00,0x00,0x00,0x0F,
0xFF,0xF8,0x00,0x00,0x00,0x01,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x7F,0xFE,0x00,0x00,0x00,0x00,0x3F,0xFE,
0x00,0x00,0x00,0x00,0x1F,0xFF,0x00,0x00,0x00,0x00,
0x1F,0xFF,0xC0,0x00,0x00,0x00,0x0F,0xFF,0xF8,0x00,
0x00,0x00,0x0F,0xFF,0xFF,0x00,0x00,0x00,0x07,0xFF,
0x3F,0xE0,0x00,0x00,0x03,0xFF,0x07,0xFC,0x00,0x00,
0x00,0xFF,0x80,0xFF,0x00,0x3C,0x00,0x7F,0xC0,0x1F,
0xE0,0x1F,0xE0,0x3F,0xE0,0x07,0xFC,0x07,0xF8,0x0F,
0xF0,0x00,0xFF,0x81,0xFC,0x07,0xF8,0x00,0x1F,0xF0,
0xFF,0x01,0xFC,0x00,0x03,0xFC,0x3F,0xC0,0x7F,0x00,
0x00,0x7F,0x9F,0xE0,0x3F,0x80,0x00,0x1F,0xF7,0xF8,
0x0F,0xE0,0x00,0x03,0xFF,0xFE,0x03,0xF8,0x00,0x00,
0x7F,0xFF,0x00,0xFE,0x00,0x00,0x0F,0xFF,0xC0,0x47,
0xF0,0x00,0x00,0x3F,0xFC,0x01,0xFE,0x00,0x00,0x07,
0xFE,0x00,0x7F,0x80,0x00,0x00,0xFF,0xC0,0x0F,0xF0,
0x00,0x00,0x7F,0xF8,0x03,0xFC,0x00,0x00,0x3F,0xFE,
0x00,0xFF,0x80,0x00,0x1F,0xFF,0xC0,0x1F,0xF0,0x00,
0x1F,0xFF,0xF8,0x03,0xFE,0x00,0x1F,0xFF,0xFF,0x00,
0xFF,0xF0,0x1F,0xFF,0x3F,0xF0,0x1F,0xFF,0xFF,0xFF,
0x8F,0xFE,0x03,0xFF,0xFF,0xFF,0xC1,0xFF,0xC0,0x7F,
0xFF,0xFF,0xE0,0x3F,0xE0,0x0F,0xFF,0xFF,0xE0,0x07,
0xF0,0x00,0xFF,0xFF,0xF0,0x00,0xF8,0x00,0x0F,0xFF,
0xF0,0x00,0x1C,0x00,0x00,0x7F,0xE0,0x00,0x02,0x00,
0x01,0xCA,0x91,0x39,0x0D,0xFF,0x9F,0xF5,0xF1,0xE0,
0x04,0xE6,0x97,0x79,0xC0,0x00,0x1F,0x00,0x03,0xE0,
0x00,0x7E,0x00,0x07,0xC0,0x00,0xF8,0x00,0x1F,0x80,
0x01,0xF0,0x00,0x3F,0x08,0x00,0xFC,0x10,0x03,0xF0,
0x20,0x0F,0xC0,0x01,0xFC,0x00,0x1F,0x80,0x03,0xF8,
0x04,0x07,0xE0,0x00,0xFE,0x00,0x81,0xF8,0x01,0x07,
0xF0,0x00,0x7E,0x00,0x2D,0xFC,0x00,0x1F,0x80,0x06,
0xFF,0x00,0x0D,0xFE,0x00,0x0F,0xE0,0x00,0x7E,0x00,
0x14,0xFE,0x00,0x07,0xE0,0x02,0x4F,0xE0,0x00,0x7E,
0x00,0x40,0xFE,0x00,0x07,0xE0,0x00,0x7F,0x00,0x80,
0x7E,0x00,0x07,0xF0,0x10,0x07,0xE0,0x20,0x07,0xE0,
0x40,0x07,0xE0,0x00,0x3F,0x00,0x01,0xF0,0x00,0x1F,
0x80,0x00,0xF8,0x00,0x0F,0xC0,0x00,0x7C,0x00,0x03,
0xE0,0x00,0x1F,0x04,0xE6,0x93,0x79,0xC7,0xC0,0x00,
0x3E,0x00,0x03,0xF0,0x00,0x1F,0x00,0x00,0xF8,0x00,
0x0F,0xC0,0x00,0x7C,0x00,0x07,0xE0,0x08,0x07,0xE0,
0x10,0x07,0xE0,0x20,0x07,0xE0,0x00,0x7F,0x00,0x03,
0xF0,0x00,0x3F,0x84,0x00,0x3F,0x08,0x00,0x7F,0x00,
0x03,0xF1,0x20,0x07,0xF0,0x00,0x3F,0x2C,0x00,0x7F,
0x68,0x00,0x7F,0xD0,0x00,0xFE,0x00,0x0F,0xF6,0x00,
0x3F,0x80,0x03,0xF2,0x40,0x0F,0xE0,0x00,0xFC,0x40,
0x03,0xF8,0x00,0x3F,0x00,0x07,0xF0,0x80,0x0F,0xC0,
0x01,0xFC,0x10,0x03,0xF0,0x20,0x0F,0xC0,0x40,0x3F,
0x00,0x07,0xE0,0x00,0x7C,0x00,0x0F,0xC0,0x00,0xF8,
0x00,0x1F,0x80,0x03,0xF0,0x00,0x3E,0x00,0x07,0xC0,
0x00,0x07,0x0C,0x8D,0x1A,0x0C,0x00,0x1F,0x80,0x01,
0x00,0xF8,0x02,0x0F,0x03,0xC0,0xF0,0xFE,0x1E,0x1F,
0xC7,0xFC,0xF7,0xFE,0x7F,0xFF,0xFF,0xF3,0xFF,0xFF,
0xFF,0xC7,0xFF,0xFF,0xF8,0x01,0xFF,0xFC,0x00,0x01,
0xFE,0x00,0x00,0x1F,0xF8,0x00,0x01,0xFF,0xE0,0x00,
0x1F,0xBF,0x80,0x01,0xFC,0xFE,0x00,0x1F,0xC3,0xF8,
0x01,0xFE,0x1F,0xE0,0x1F,0xE0,0x7F,0x80,0x3E,0x01,
0xF0,0x00,0xF0,0x0F,0x00,0x01,0x00,0x20,0x00,0x09,
0xD3,0x90,0x53,0x0D,0x00,0x00,0xFE,0x00,0x01,0xA0,
0x00,0x1F,0xC0,0x00,0x20,0x00,0x03,0xF8,0x00,0x06,
0xFF,0xFF,0xFF,0xFF,0xFF,0xD0,0x00,0x0F,0xE0,0x00,
0x1A,0x00,0x01,0xFC,0x00,0x02,0x00,0x00,0x3F,0x80,
0x00,0x00,0x01,0xCA,0x1F,0x99,0x7D,0xFF,0x83,0xC3,
0xA0,0xF1,0xE3,0xE1,0xC0,0x80,0x05,0xC3,0x8C,0x91,
0xCD,0xFF,0xFF,0xFE,0x01,0xC3,0x9C,0x01,0x7D,0xFE,
0x05,0xDE,0x00,0x01,0x78,0x00,0x00,0x7F,0x20,0x00,
0x1F,0x80,0x00,0x3F,0xA4,0x00,0x07,0xE0,0x00,0x0F,
0xE4,0x00,0x01,0xF8,0x00,0x03,0xF8,0x90,0x00,0x7E,
0x00,0x00,0xFE,0x10,0x00,0x1F,0x80,0x00,0x3F,0x82,
0x40,0x07,0xE0,0x00,0x0F,0xE0,0x40,0x01,0xF8,0x00,
0x03,0xF8,0x09,0x00,0x7E,0x00,0x00,0xFE,0x01,0x00,
0x1F,0x80,0x00,0x3F,0x80,0x24,0x07,0xE0,0x00,0x0F,
0xE0,0x04,0x81,0xF8,0x00,0x90,0x7E,0x00,0x00,0xFE,
0x00,0x12,0x1F,0x80,0x02,0x47,0xE0,0x00,0x0F,0xE0,
0x00,0x49,0xF8,0x00,0x09,0x7E,0x00,0x00,0xFE,0x00,
0x00,0xFC,0x00,0x00,0x09,0x9E,0x93,0xFA,0xE0,0x00,
0x1F,0xF8,0x00,0x00,0x01,0xFF,0xFE,0x00,0x00,0x07,
0xFF,0xFE,0x00,0x00,0x3F,0xFF,0xFF,0x00,0x00,0xFF,
0xFF,0xFF,0x00,0x03,0xFF,0xFF,0xFF,0x00,0x0F,0xFF,
0xFF,0xFF,0x00,0x1F,0xFC,0x0F,0xFE,0x00,0x7F,0xC0,
0x07,0xFE,0x00,0xFF,0x00,0x03,0xFC,0x03,0xFC,0x00,
0x03,0xFC,0x07,0xF0,0x00,0x03,0xF8,0x1F,0xE0,0x00,
0x07,0xF1,0x07,0xF0,0x00,0x00,0xFE,0x1F,0xE0,0x00,
0x01,0xFC,0xB7,0xF0,0x00,0x00,0x3F,0xB7,0xF8,0x00,
0x00,0x07,0xFD,0xFE,0x00,0x00,0x01,0xFE,0xFF,0x80,
0x00,0x00,0x7F,0xB7,0xF0,0x00,0x00,0x3F,0x87,0xE0,
0x00,0x00,0xFE,0x41,0xFC,0x00,0x00,0x3F,0x83,0xFC,
0x00,0x00,0xFF,0x03,0xF8,0x00,0x01,0xFC,0x07,0xF8,
0x00,0x07,0xF8,0x07,0xF8,0x00,0x1F,0xE0,0x0F,0xFC,
0x00,0xFF,0xC0,0x0F,0xFE,0x07,0xFF,0x00,0x1F,0xFF,
0xFF,0xFE,0x00,0x1F,0xFF,0xFF,0xF8,0x00,0x1F,0xFF,
0xFF,0xE0,0x00,0x1F,0xFF,0xFF,0x80,0x00,0x1F,0xFF,
0xFE,0x00,0x00,0x0F,0xFF,0xF0,0x00,0x00,0x03,0xFF,
0x00,0x00,0x05,0x9E,0x24,0x02,0xE8,0x00,0x00,0x7C,
0x00,0x01,0xF8,0x00,0x07,0xF0,0x00,0x1F,0xE0,0x00,
0x7F,0xC0,0x01,0xFF,0x80,0x07,0xFF,0x00,0x1F,0xFE,
0x00,0x7F,0xFC,0x01,0xFF,0xF8,0x0F,0xFF,0xF0,0x3F,
0xFF,0xE1,0xFF,0xFF,0xCF,0xFF,0xBF,0xBF,0xFC,0x7F,
0x7F,0xF0,0xFE,0xFF,0x81,0xFD,0xFE,0x03,0xFB,0xF0,
0x07,0xF7,0x80,0x0F,0xEC,0x00,0x1F,0xF4,0x00,0x07,
0xFD,0x00,0x01,0xFF,0x40,0x00,0x7F,0xD0,0x00,0x1F,
0xF4,0x00,0x07,0xF9,0x00,0x01,0xFC,0x09,0xDE,0x08,
0x02,0xE0,0x00,0x0F,0xFC,0x00,0x00,0x00,0xFF,0xFF,
0x80,0x00,0x03,0xFF,0xFF,0xE0,0x00,0x07,0xFF,0xFF,
0xF8,0x00,0x0F,0xFF,0xFF,0xFC,0x00,0x3F,0xFF,0xFF,
0xFE,0x00,0x3F,0xFF,0xFF,0xFF,0x00,0x7F,0xF8,0x0F,
0xFF,0x00,0xFF,0xC0,0x01,0xFF,0x80,0xFF,0x80,0x00,
0xFF,0x81,0xFF,0x00,0x00,0x7F,0xC1,0xFE,0x00,0x00,
0x3F,0xC1,0xFC,0x00,0x00,0x1F,0xC1,0xFC,0x00,0x00,
0x1F,0xE9,0x7F,0x00,0x00,0x01,0xFC,0x0F,0x00,0x00,
0x01,0xFD,0x00,0x00,0x00,0x00,0x3F,0x80,0x00,0x00,
0x00,0x7F,0xA0,0x00,0x00,0x00,0x0F,0xE0,0x00,0x00,
0x00,0x1F,0xE0,0x00,0x00,0x00,0x1F,0xC0,0x00,0x00,
0x00,0x3F,0xC0,0x00,0x00,0x00,0x7F,0xC0,0x00,0x00,
0x00,0x7F,0x80,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,
0x01,0xFF,0x00,0x00,0x00,0x03,0xFE,0x00,0x00,0x00,
0x07,0xFC,0x00,0x00,0x00,0x0F,0xF8,0x00,0x00,0x00,
0x1F,0xF0,0x00,0x00,0x00,0x3F,0xE0,0x00,0x00,0x00,
0x7F,0xE0,0x00,0x00,0x00,0xFF,0x80,0x00,0x00,0x01,
0xFF,0x00,0x00,0x00,0x07,0xFE,0x00,0x00,0x00,0x0F,
0xFC,0x00,0x00,0x00,0x1F,0xF8,0x00,0x00,0x00,0x3F,
0xF0,0x00,0x00,0x00,0x7F,0xE0,0x00,0x00,0x01,0xFF,
0xC0,0x00,0x00,0x03,0xFF,0x00,0x00,0x00,0x07,0xFE,
0x00,0x00,0x00,0x0F,0xFC,0x00,0x00,0x00,0x0F,0xF8,
0x00,0x00,0x00,0x1F,0xF0,0x00,0x00,0x00,0x3F,0xE0,
0x00,0x00,0x00,0x7F,0xC0,0x00,0x00,0x00,0x7F,0x80,
0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x04,0xBF,0xFF,
0xFF,0xFF,0xFF,0xAF,0xFF,0xFF,0xFF,0xFF,0xE0,0x09,
0x9E,0x93,0xFA,0xE0,0x00,0x1F,0xF0,0x00,0x00,0x01,
0xFF,0xFC,0x00,0x00,0x0F,0xFF,0xFE,0x00,0x00,0x7F,
0xFF,0xFE,0x00,0x01,0xFF,0xFF,0xFE,0x00,0x07,0xFF,
0xFF,0xFE,0x00,0x1F,0xFF,0xFF,0xFE,0x00,0x3F,0xF8,
0x0F,0xFE,0x00,0xFF,0xC0,0x07,0xFC,0x01,0xFE,0x00,
0x07,0xFC,0x07,0xF8,0x00,0x07,0xF8,0x0F,0xF0,0x00,
0x07,0xF0,0x1F,0xC0,0x00,0x0F,0xF0,0x7F,0x80,0x00,
0x0F,0xE0,0xFE,0x00,0x00,0x1F,0xC0,0x3C,0x00,0x00,
0x3F,0x89,0x00,0x00,0x00,0x0F,0xE2,0x00,0x00,0x00,
0x07,0xF0,0x00,0x00,0x00,0x1F,0xE0,0x00,0x00,0x00,
0x7F,0x80,0x00,0x00,0x03,0xFE,0x00,0x00,0x00,0x3F,
0xF8,0x00,0x00,0x0F,0xFF,0xE0,0x00,0x00,0x1F,0xFF,
0x80,0x00,0x00,0x3F,0xFC,0x00,0x00,0x00,0x7F,0xFF,
0x00,0x00,0x01,0xFF,0xFF,0x80,0x00,0x03,0xFF,0xFF,
0x80,0x00,0x06,0x07,0xFF,0x80,0x00,0x00,0x01,0xFF,
0x80,0x00,0x00,0x00,0xFF,0x80,0x00,0x00,0x00,0xFF,
0x20,0x00,0x00,0x00,0x1F,0xE0,0x00,0x00,0x00,0x1F,
0xC0,0x00,0x00,0x00,0x3F,0xE8,0x00,0x00,0x00,0x07,
0xF0,0xF0,0x00,0x00,0x0F,0xEF,0xE0,0x00,0x00,0x1F,
0xDF,0xE0,0x00,0x00,0x3F,0xBF,0xC0,0x00,0x00,0xFF,
0x3F,0x80,0x00,0x01,0xFD,0x0F,0xF0,0x00,0x00,0xFF,
0x0F,0xF0,0x00,0x03,0xFC,0x1F,0xF0,0x00,0x0F,0xF8,
0x1F,0xF0,0x00,0x7F,0xE0,0x3F,0xFC,0x03,0xFF,0x80,
0x3F,0xFF,0xFF,0xFE,0x00,0x3F,0xFF,0xFF,0xFC,0x00,
0x3F,0xFF,0xFF,0xE0,0x00,0x3F,0xFF,0xFF,0x80,0x00,
0x1F,0xFF,0xFE,0x00,0x00,0x0F,0xFF,0xF0,0x00,0x00,
0x03,0xFE,0x00,0x00,0x0A,0x5D,0x84,0x02,0xE0,0x00,
0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x3F,0x80,0x00,
0x00,0x00,0x1F,0xE0,0x20,0x00,0x00,0x01,0xFF,0x00,
0x00,0x00,0x00,0xFF,0xC0,0x00,0x00,0x00,0x7F,0xF0,
0x10,0x00,0x00,0x07,0xFF,0x80,0x00,0x00,0x03,0xFF,
0xE0,0x20,0x00,0x00,0x3F,0xFF,0x00,0x00,0x00,0x1F,
0xFF,0xC0,0x00,0x00,0x0F,0xFF,0xF0,0x00,0x00,0x07,
0xFD,0xFC,0x00,0x00,0x01,0xFE,0x7F,0x00,0x00,0x00,
0xFF,0x1F,0xC0,0x00,0x00,0x7F,0xC7,0xF0,0x00,0x00,
0x3F,0xE1,0xFC,0x00,0x00,0x0F,0xF0,0x7F,0x00,0x00,
0x07,0xF8,0x1F,0xC0,0x00,0x03,0xFE,0x07,0xF0,0x00,
0x01,0xFF,0x01,0xFC,0x00,0x00,0x7F,0x80,0x7F,0x00,
0x00,0x3F,0xC0,0x1F,0xC0,0x00,0x1F,0xF0,0x07,0xF0,
0x00,0x0F,0xF8,0x01,0xFC,0x00,0x03,0xFC,0x00,0x7F,
0x00,0x01,0xFE,0x00,0x1F,0xC0,0x00,0xFF,0x80,0x07,
0xF0,0x00,0x3F,0xC0,0x01,0xFC,0x00,0x1F,0xE0,0x00,
0x7F,0x00,0x0F,0xF8,0x00,0x1F,0xC0,0x07,0xFC,0x00,
0x07,0xF0,0x01,0xFE,0x00,0x01,0xFC,0x00,0xFF,0x00,
0x00,0x7F,0x00,0x7F,0xC0,0x00,0x1F,0xC0,0x3F,0xE0,
0x00,0x07,0xF0,0x1B,0xFF,0xFF,0xFF,0xFF,0xFF,0xD0,
0x00,0x00,0x01,0xFC,0x06,0x80,0x00,0x00,0x0F,0xE0,
0x00,0x09,0x9E,0x13,0xFA,0xE8,0x01,0xFF,0xFF,0xFF,
0xE2,0xC0,0xFF,0xFF,0xFF,0xF8,0x01,0xFC,0x00,0x00,
0x01,0x60,0xFE,0x00,0x00,0x00,0x03,0xFC,0x00,0x00,
0x00,0xA0,0xFE,0x00,0x00,0x00,0x03,0xFC,0x00,0x00,
0x00,0x07,0xF0,0x1F,0xE0,0x00,0x0F,0xE1,0xFF,0xF0,
0x00,0x1F,0xCF,0xFF,0xF8,0x00,0x3F,0xFF,0xFF,0xFC,
0x00,0xFF,0xFF,0xFF,0xFC,0x01,0xFF,0xFF,0xFF,0xFC,
0x03,0xFF,0xFF,0xFF,0xFC,0x07,0xFF,0xC0,0x3F,0xF8,
0x0F,0xFC,0x00,0x1F,0xF8,0x3F,0xF0,0x00,0x0F,0xF8,
0x7F,0xC0,0x00,0x0F,0xF0,0xFF,0x00,0x00,0x0F,0xF0,
0x3C,0x00,0x00,0x1F,0xE8,0x00,0x00,0x00,0x03,0xF8,
0x00,0x00,0x00,0x07,0xFE,0x80,0x00,0x00,0x00,0xFE,
0x1E,0x00,0x00,0x01,0xFD,0xFC,0x00,0x00,0x07,0xFC,
0x7F,0x80,0x00,0x01,0xFC,0x7F,0x00,0x00,0x07,0xF8,
0xFF,0x00,0x00,0x0F,0xE1,0xFE,0x00,0x00,0x3F,0xC1,
0xFE,0x00,0x00,0xFF,0x03,0xFE,0x00,0x03,0xFE,0x03,
0xFE,0x00,0x0F,0xF8,0x07,0xFF,0x80,0xFF,0xF0,0x07,
0xFF,0xFF,0xFF,0xC0,0x07,0xFF,0xFF,0xFF,0x00,0x07,
0xFF,0xFF,0xFC,0x00,0x07,0xFF,0xFF,0xF0,0x00,0x07,
0xFF,0xFF,0x80,0x00,0x03,0xFF,0xFC,0x00,0x00,0x00,
0x7F,0xC0,0x00,0x00,0x0A,0x1E,0x8B,0xFA,0xE0,0x00,
0x03,0xFE,0x00,0x00,0x00,0x0F,0xFF,0xF0,0x00,0x00,
0x1F,0xFF,0xFC,0x00,0x00,0x3F,0xFF,0xFF,0x80,0x00,
0x3F,0xFF,0xFF,0xE0,0x00,0x3F,0xFF,0xFF,0xF8,0x00,
0x3F,0xFF,0xFF,0xFE,0x00,0x3F,0xFC,0x07,0xFF,0x00,
0x3F,0xF0,0x00,0xFF,0xC0,0x1F,0xF0,0x00,0x1F,0xF0,
0x1F,0xF0,0x00,0x07,0xF8,0x0F,0xF0,0x00,0x03,0xFC,
0x0F,0xF0,0x00,0x00,0xFF,0x07,0xF0,0x00,0x00,0x7F,
0x87,0xF8,0x00,0x00,0x1F,0xC3,0xF8,0x00,0x00,0x0F,
0x01,0xFC,0x00,0x00,0x00,0x05,0x3F,0x80,0x00,0x00,
0x00,0x1F,0xC0,0x0F,0xF0,0x00,0x0F,0xC0,0x3F,0xFF,
0x00,0x0F,0xE0,0x7F,0xFF,0xE0,0x07,0xF0,0xFF,0xFF,
0xF8,0x03,0xF8,0xFF,0xFF,0xFF,0x01,0xFC,0xFF,0xFF,
0xFF,0xC0,0xFE,0xFF,0xFF,0xFF,0xF0,0x7F,0xFF,0x80,
0x7F,0xF8,0x3F,0xFF,0x00,0x07,0xFE,0x1F,0xFE,0x00,
0x00,0xFF,0x8F,0xFE,0x00,0x00,0x3F,0xC7,0xFE,0x00,
0x00,0x0F,0xF3,0xFE,0x00,0x00,0x07,0xFA,0x3F,0xC0,
0x00,0x00,0x3F,0x9F,0xE0,0x00,0x00,0x1F,0xF3,0xFC,
0x00,0x00,0x00,0xFF,0x4F,0xC0,0x00,0x00,0x0F,0xE7,
0xF0,0x00,0x00,0x07,0xF3,0xF8,0x00,0x00,0x07,0xF0,
0xFC,0x00,0x00,0x03,0xF8,0x7F,0x00,0x00,0x01,0xFC,
0x3F,0xC0,0x00,0x01,0xFE,0x0F,0xE0,0x00,0x01,0xFE,
0x07,0xF8,0x00,0x01,0xFF,0x01,0xFE,0x00,0x01,0xFF,
0x00,0x7F,0xC0,0x01,0xFF,0x80,0x3F,0xF8,0x07,0xFF,
0x80,0x0F,0xFF,0xFF,0xFF,0x80,0x03,0xFF,0xFF,0xFF,
0x80,0x00,0xFF,0xFF,0xFF,0x80,0x00,0x3F,0xFF,0xFF,
0x80,0x00,0x07,0xFF,0xFF,0x80,0x00,0x00,0xFF,0xFF,
0x00,0x00,0x00,0x0F,0xF8,0x00,0x00,0x09,0x9D,0x90,
0x02,0xEC,0xFF,0xFF,0xFF,0xFF,0xFD,0xFF,0xFF,0xFF,
0xFF,0xF0,0x00,0x00,0x00,0x07,0xC0,0x00,0x00,0x00,
0x1F,0x80,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x01,
0xF8,0x00,0x00,0x00,0x07,0xE0,0x00,0x00,0x00,0x1F,
0xC0,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,0xFC,
0x00,0x00,0x00,0x03,0xF8,0x00,0x00,0x00,0x07,0xE0,
0x00,0x00,0x00,0x1F,0xC0,0x00,0x00,0x00,0x7F,0x00,
0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x03,0xF8,0x00,
0x00,0x00,0x07,0xE0,0x00,0x00,0x00,0x1F,0xC0,0x04,
0x00,0x00,0x0F,0xE0,0x01,0x00,0x00,0x07,0xF0,0x00,
0x40,0x00,0x03,0xF8,0x00,0x12,0x00,0x01,0xFC,0x00,
0x04,0x00,0x00,0xFE,0x00,0x01,0x20,0x00,0x7F,0x00,
0x00,0x48,0x00,0x3F,0x80,0x00,0x12,0x00,0x1F,0xC0,
0x00,0x05,0x00,0x0F,0xE0,0x00,0x00,0x00,0x3F,0xC0,
0x00,0x02,0xC0,0x0F,0xE0,0x00,0x00,0x00,0x3F,0xC0,
0x00,0x01,0x60,0x0F,0xE0,0x00,0x00,0x00,0x09,0x9E,
0x93,0xFA,0xE0,0x00,0x1F,0xF8,0x00,0x00,0x01,0xFF,
0xFE,0x00,0x00,0x0F,0xFF,0xFF,0x00,0x00,0x3F,0xFF,
0xFF,0x00,0x01,0xFF,0xFF,0xFF,0x00,0x03,0xFF,0xFF,
0xFF,0x00,0x0F,0xFF,0xFF,0xFF,0x00,0x3F,0xF8,0x07,
0xFF,0x00,0x7F,0xC0,0x03,0xFE,0x01,0xFF,0x00,0x03,
0xFE,0x03,0xFC,0x00,0x03,0xFC,0x0F,0xF0,0x00,0x03,
0xF8,0x1F,0xC0,0x00,0x07,0xF9,0x67,0xF0,0x00,0x00,
0xFE,0x0F,0xF0,0x00,0x03,0xFC,0x0F,0xE0,0x00,0x07,
0xF1,0x03,0xFC,0x00,0x03,0xFC,0x03,0xFE,0x00,0x1F,
0xF0,0x03,0xFF,0x00,0xFF,0xC0,0x03,0xFF,0xFF,0xFF,
0x00,0x03,0xFF,0xFF,0xFC,0x00,0x01,0xFF,0xFF,0xE0,
0x00,0x01,0xFF,0xFF,0x80,0x00,0x1F,0xFF,0xFF,0xC0,
0x00,0x7F,0xFF,0xFF,0xE0,0x01,0xFF,0xFF,0xFF,0xE0,
0x07,0xFF,0x00,0xFF,0xE0,0x1F,0xF0,0x00,0x7F,0xE0,
0x7F,0xC0,0x00,0x3F,0xE0,0xFF,0x00,0x00,0x3F,0xC3,
0xFC,0x00,0x00,0x3F,0xC7,0xF0,0x00,0x00,0x7F,0x8F,
0xE0,0x00,0x00,0x7F,0x3F,0xC0,0x00,0x00,0xFF,0xDF,
0xE0,0x00,0x00,0x1F,0xDF,0xE0,0x00,0x00,0x7F,0xC3,
0xF8,0x00,0x00,0x1F,0xC7,0xF8,0x00,0x00,0x7F,0x87,
0xF8,0x00,0x01,0xFE,0x0F,0xF8,0x00,0x07,0xFC,0x0F,
0xFC,0x00,0x1F,0xF0,0x1F,0xFE,0x01,0xFF,0xE0,0x1F,
0xFF,0xFF,0xFF,0x80,0x1F,0xFF,0xFF,0xFE,0x00,0x1F,
0xFF,0xFF,0xF8,0x00,0x1F,0xFF,0xFF,0xE0,0x00,0x0F,
0xFF,0xFF,0x00,0x00,0x07,0xFF,0xF8,0x00,0x00,0x01,
0xFF,0x80,0x00,0x09,0x9E,0x93,0xFA,0xE0,0x00,0x1F,
0xE0,0x00,0x00,0x01,0xFF,0xF8,0x00,0x00,0x0F,0xFF,
0xFC,0x00,0x00,0x7F,0xFF,0xFE,0x00,0x01,0xFF,0xFF,
0xFE,0x00,0x07,0xFF,0xFF,0xFE,0x00,0x1F,0xFF,0xFF,
0xFE,0x00,0x3F,0xFC,0x07,0xFE,0x00,0xFF,0xC0,0x03,
0xFE,0x03,0xFF,0x00,0x01,0xFC,0x07,0xFC,0x00,0x01,
0xFC,0x1F,0xF0,0x00,0x01,0xF8,0x3F,0xC0,0x00,0x03,
0xF8,0x7F,0x80,0x00,0x03,0xF0,0xFE,0x00,0x00,0x07,
0xE3,0xFC,0x00,0x00,0x0F,0xEA,0xFE,0x00,0x00,0x01,
0xFA,0xBF,0x80,0x00,0x00,0x7F,0x7F,0x00,0x00,0x01,
0xFE,0xFF,0x00,0x00,0x03,0xFC,0xFE,0x00,0x00,0x07,
0xFC,0x3F,0xC0,0x00,0x03,0xFE,0x3F,0xC0,0x00,0x0F,
0xFC,0x7F,0xC0,0x00,0x3F,0xF8,0x7F,0xE0,0x01,0xFF,
0xF0,0xFF,0xF0,0x0F,0xFF,0xE0,0xFF,0xFF,0xFF,0xDF,
0xC0,0xFF,0xFF,0xFF,0x3F,0x80,0xFF,0xFF,0xFC,0x7F,
0x00,0xFF,0xFF,0xF0,0xFE,0x00,0xFF,0xFF,0xC1,0xFC,
0x00,0x7F,0xFE,0x03,0xF0,0x00,0x1F,0xE0,0x07,0xEA,
0x00,0x00,0x00,0x03,0xF8,0x00,0x00,0x00,0x0F,0xE0,
0x3C,0x00,0x00,0x1F,0xC3,0xF8,0x00,0x00,0x3F,0x90,
0xFF,0x00,0x00,0x1F,0xC0,0xFE,0x00,0x00,0x7F,0x81,
0xFE,0x00,0x01,0xFE,0x03,0xFE,0x00,0x07,0xFC,0x03,
0xFE,0x00,0x1F,0xF0,0x07,0xFF,0x01,0xFF,0xC0,0x07,
0xFF,0xFF,0xFF,0x80,0x07,0xFF,0xFF,0xFE,0x00,0x07,
0xFF,0xFF,0xF8,0x00,0x07,0xFF,0xFF,0xC0,0x00,0x07,
0xFF,0xFF,0x00,0x00,0x03,0xFF,0xF8,0x00,0x00,0x00,
0xFF,0x80,0x00,0x00,0x01,0xD6,0x1C,0x01,0x7D,0xFF,
0xA0,0x34,0x06,0x80,0xD0,0x10,0x03,0x7F,0x80,0x01,
0xDC,0x9F,0x99,0x7D,0xFF,0xA0,0x34,0x06,0x80,0xD0,
0x10,0x03,0x7F,0xE0,0xF0,0xE1,0xE3,0xE8,0xF8,0x70,
0x20,0x09,0x93,0x94,0x53,0x00,0x00,0x00,0x00,0x00,
0x20,0x00,0x00,0x00,0x01,0xC0,0x00,0x00,0x00,0x1F,
0x80,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x07,0xFE,
0x00,0x00,0x00,0x3F,0xFC,0x00,0x00,0x03,0xFF,0xF8,
0x00,0x00,0x1F,0xFF,0xE0,0x00,0x00,0xFF,0xFE,0x00,
0x00,0x07,0xFF,0xF0,0x00,0x00,0x3F,0xFF,0x00,0x00,
0x03,0xFF,0xF8,0x00,0x00,0x1F,0xFF,0x80,0x00,0x00,
0xFF,0xFC,0x00,0x00,0x07,0xFF,0xC0,0x00,0x00,0x7F,
0xFE,0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,0x0F,0xFF,
0x00,0x00,0x00,0x1F,0xF8,0x00,0x00,0x00,0x3F,0x80,
0x00,0x00,0x00,0x7F,0xC0,0x00,0x00,0x00,0xFF,0xF0,
0x00,0x00,0x00,0xFF,0xF8,0x00,0x00,0x00,0x7F,0xFE,
0x00,0x00,0x00,0x1F,0xFF,0x00,0x00,0x00,0x0F,0xFF,
0xC0,0x00,0x00,0x07,0xFF,0xE0,0x00,0x00,0x03,0xFF,
0xF8,0x00,0x00,0x00,0xFF,0xFC,0x00,0x00,0x00,0x7F,
0xFF,0x00,0x00,0x00,0x3F,0xFF,0x80,0x00,0x00,0x1F,
0xFF,0xE0,0x00,0x00,0x0F,0xFF,0xE0,0x00,0x00,0x03,
0xFF,0xC0,0x00,0x00,0x01,0xFF,0x80,0x00,0x00,0x00,
0xFF,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,
0x1C,0x00,0x00,0x00,0x00,0x08,0x09,0xCC,0x90,0x8B,
0x0D,0xFF,0xFF,0xFF,0xFF,0xFF,0xA0,0x00,0x00,0x00,
0x00,0x28,0x00,0x00,0x00,0x00,0x06,0xFF,0xFF,0xFF,
0xFF,0xFF,0x09,0x93,0x94,0x53,0x04,0x00,0x00,0x00,
0x00,0x0E,0x00,0x00,0x00,0x00,0x1F,0x80,0x00,0x00,
0x00,0x3F,0xC0,0x00,0x00,0x00,0x7F,0xE0,0x00,0x00,
0x00,0xFF,0xF0,0x00,0x00,0x01,0xFF,0xFC,0x00,0x00,
0x01,0xFF,0xFE,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,
0x00,0x3F,0xFF,0x80,0x00,0x00,0x0F,0xFF,0xC0,0x00,
0x00,0x07,0xFF,0xF0,0x00,0x00,0x01,0xFF,0xF8,0x00,
0x00,0x00,0xFF,0xFC,0x00,0x00,0x00,0x3F,0xFE,0x00,
0x00,0x00,0x1F,0xFF,0x80,0x00,0x00,0x07,0xFF,0xC0,
0x00,0x00,0x03,0xFF,0xC0,0x00,0x00,0x00,0xFF,0x80,
0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0x07,0xFE,0x00,
0x00,0x00,0x3F,0xFC,0x00,0x00,0x01,0xFF,0xF0,0x00,
0x00,0x1F,0xFF,0x80,0x00,0x00,0xFF,0xF8,0x00,0x00,
0x0F,0xFF,0xC0,0x00,0x00,0x7F,0xFE,0x00,0x00,0x07,
0xFF,0xF0,0x00,0x00,0x3F,0xFF,0x00,0x00,0x03,0xFF,
0xF8,0x00,0x00,0x1F,0xFF,0xC0,0x00,0x01,0xFF,0xFE,
0x00,0x00,0x07,0xFF,0xF0,0x00,0x00,0x0F,0xFF,0x00,
0x00,0x00,0x1F,0xF8,0x00,0x00,0x00,0x3F,0xC0,0x00,
0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0xE0,0x00,0x00,
0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x09,0x9E,0x90,
0x02,0xE0,0x00,0x1F,0xF8,0x00,0x00,0x01,0xFF,0xFE,
0x00,0x00,0x0F,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0xFF,
0x80,0x01,0xFF,0xFF,0xFF,0x80,0x07,0xFF,0xFF,0xFF,
0x80,0x1F,0xFF,0xFF,0xFF,0x80,0x3F,0xFC,0x07,0xFF,
0x80,0xFF,0xC0,0x03,0xFF,0x83,0xFF,0x00,0x01,0xFF,
0x07,0xFC,0x00,0x01,0xFF,0x1F,0xF0,0x00,0x01,0xFE,
0x3F,0xC0,0x00,0x03,0xFC,0x7F,0x80,0x00,0x03,0xFC,
0xFE,0x00,0x00,0x07,0xFC,0x7F,0x80,0x00,0x00,0xFE,
0xFE,0x00,0x00,0x01,0xFC,0x3C,0x00,0x00,0x03,0xFC,
0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x7F,
0x00,0x00,0x00,0x01,0xFE,0x00,0x00,0x00,0x07,0xF8,
0x00,0x00,0x00,0x1F,0xF0,0x00,0x00,0x00,0x7F,0xC0,
0x00,0x00,0x01,0xFF,0x00,0x00,0x00,0x07,0xFC,0x00,
0x00,0x00,0x1F,0xF0,0x00,0x00,0x00,0x7F,0xC0,0x00,
0x00,0x01,0xFF,0x00,0x00,0x00,0x07,0xFC,0x00,0x00,
0x00,0x1F,0xF0,0x00,0x00,0x00,0x7F,0xC0,0x00,0x00,
0x01,0xFF,0x00,0x00,0x00,0x03,0xFC,0x00,0x10,0x00,
0x01,0xFE,0x00,0x00,0x00,0x03,0xF8,0x00,0x08,0x00,
0x01,0xFE,0x00,0x03,0x00,0x00,0x7F,0x00,0x00,0xC0,
0x00,0x00,0x00,0x00,0x34,0x00,0x07,0xF0,0x00,0x00,
0x13,0x67,0x17,0x7D,0x40,0x00,0x00,0x00,0x03,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,
0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,
0xFE,0x00,0x00,0x00,0x01,0xFF,0xFF,0x80,0x07,0xFF,
0xFE,0x00,0x00,0x00,0x0F,0xFF,0xC0,0x00,0x01,0xFF,
0xFC,0x00,0x00,0x00,0xFF,0xF8,0x00,0x00,0x00,0xFF,
0xF8,0x00,0x00,0x07,0xFF,0x80,0x00,0x00,0x00,0xFF,
0xF0,0x00,0x00,0x3F,0xF8,0x00,0x00,0x00,0x00,0xFF,
0xE0,0x00,0x01,0xFF,0xC0,0x00,0x00,0x00,0x00,0xFF,
0x80,0x00,0x07,0xFC,0x00,0x00,0x00,0x00,0x01,0xFF,
0x00,0x00,0x3F,0xE0,0x00,0x00,0x00,0x00,0x03,0xFE,
0x00,0x01,0xFF,0x00,0x00,0x00,0x00,0x00,0x07,0xF8,
0x00,0x0F,0xF8,0x00,0x01,0xFC,0x00,0x00,0x0F,0xF0,
0x00,0x3F,0xC0,0x00,0x3F,0xFE,0x03,0xF8,0x1F,0xE0,
0x01,0xFE,0x00,0x03,0xFF,0xFC,0x0F,0xE0,0x3F,0x80,
0x07,0xF0,0x00,0x1F,0xFF,0xFC,0x3F,0x00,0xFF,0x00,
0x3F,0x80,0x01,0xFF,0xFF,0xF8,0xFC,0x01,0xFC,0x00,
0xFE,0x00,0x0F,0xFF,0xFF,0xF7,0xF0,0x07,0xF0,0x07,
0xF0,0x00,0x7F,0xFF,0xFF,0xDF,0xC0,0x0F,0xE0,0x1F,
0x80,0x03,0xFF,0xC0,0xFF,0xFF,0x00,0x3F,0x80,0xFE,
0x00,0x1F,0xF8,0x00,0xFF,0xF8,0x00,0x7E,0x03,0xF0,
0x00,0x7F,0xC0,0x00,0xFF,0xE0,0x01,0xF8,0x0F,0xC0,
0x03,0xFE,0x00,0x01,0xFF,0x80,0x07,0xF0,0x7F,0x00,
0x1F,0xF0,0x00,0x07,0xFE,0x00,0x0F,0xC1,0xF8,0x00,
0x7F,0x80,0x00,0x0F,0xF8,0x00,0x3F,0x07,0xE0,0x03,
0xFC,0x00,0x00,0x3F,0xC0,0x00,0xFC,0x3F,0x00,0x0F,
0xF0,0x00,0x00,0x7F,0x00,0x03,0xF2,0x1F,0x80,0x0F,
0xF0,0x00,0x00,0x3F,0x80,0x01,0xF8,0x7E,0x00,0x3F,
0x80,0x00,0x00,0xFE,0x00,0x07,0xE1,0xF8,0x01,0xFE,
0x00,0x00,0x03,0xF0,0x00,0x1F,0x91,0xF8,0x00,0xFE,
0x00,0x00,0x01,0xF8,0x00,0x0F,0xC7,0xE0,0x07,0xF8,
0x00,0x00,0x07,0xE0,0x00,0x7F,0x1F,0x80,0x1F,0xC0,
0x00,0x00,0x1F,0x80,0x01,0xF8,0x7E,0x00,0x7F,0x00,
0x00,0x00,0xFC,0x00,0x07,0xE2,0x3F,0x00,0x3F,0x80,
0x00,0x00,0x7E,0x00,0x07,0xF0,0xFC,0x00,0xFE,0x00,
0x00,0x03,0xF8,0x00,0x1F,0x83,0xF0,0x03,0xF8,0x00,
0x00,0x0F,0xC0,0x00,0xFE,0x0F,0xC0,0x0F,0xE0,0x00,
0x00,0x7F,0x00,0x03,0xF0,0x3F,0x00,0x3F,0x80,0x00,
0x01,0xFC,0x00,0x1F,0xC0,0xFC,0x00,0xFE,0x00,0x00,
0x0F,0xF0,0x00,0xFE,0x03,0xF8,0x01,0xFC,0x00,0x00,
0x3F,0xC0,0x03,0xF8,0x07,0xE0,0x07,0xF0,0x00,0x01,
0xFE,0x00,0x1F,0xC0,0x1F,0x80,0x1F,0xE0,0x00,0x0F,
0xF8,0x00,0xFF,0x00,0x7E,0x00,0x7F,0x80,0x00,0x7F,
0xE0,0x07,0xF8,0x01,0xFC,0x00,0xFF,0x00,0x07,0xFF,
0x80,0x7F,0xC0,0x07,0xF0,0x03,0xFE,0x00,0x3F,0xFE,
0x03,0xFE,0x00,0x0F,0xC0,0x07,0xFE,0x07,0xFF,0xFC,
0x3F,0xF0,0x00,0x3F,0x80,0x1F,0xFF,0xFF,0xFF,0xFF,
0xFF,0x80,0x00,0xFE,0x00,0x3F,0xFF,0xFF,0xBF,0xFF,
0xFC,0x00,0x01,0xFC,0x00,0x7F,0xFF,0xFC,0xFF,0xFF,
0xE0,0x00,0x07,0xF0,0x00,0xFF,0xFF,0xC1,0xFF,0xFF,
0x00,0x00,0x0F,0xE0,0x01,0xFF,0xFE,0x07,0xFF,0xF0,
0x00,0x00,0x3F,0xC0,0x01,0xFF,0xE0,0x0F,0xFF,0x80,
0x0F,0xE0,0x7F,0x80,0x00,0xFE,0x00,0x0F,0xF0,0x00,
0x7F,0x01,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x03,
0xFC,0x03,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,
0xE0,0x07,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x1F,0xF8,0x00,0x00,0x00,0x00,0x00,0x0F,0xF8,
0x00,0x3F,0xF0,0x00,0x00,0x00,0x00,0x00,0x7F,0xC0,
0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0x07,0xFF,0x00,
0x00,0xFF,0xF0,0x00,0x00,0x00,0x00,0x7F,0xF0,0x00,
0x01,0xFF,0xF8,0x00,0x00,0x00,0x07,0xFF,0x80,0x00,
0x03,0xFF,0xFC,0x00,0x00,0x00,0xFF,0xFC,0x00,0x00,
0x03,0xFF,0xFF,0xC0,0x00,0x7F,0xFF,0xE0,0x00,0x00,
0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,
0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,
0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x07,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x03,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,
0x00,0x1F,0xFF,0xE0,0x00,0x00,0x00,0x0D,0xDE,0x00,
0x03,0x70,0x00,0x00,0x07,0xF0,0x00,0x00,0x08,0x00,
0x00,0x01,0xFF,0x00,0x00,0x01,0x20,0x00,0x00,0x7F,
0xF0,0x00,0x00,0x00,0x00,0x00,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x00,0xFD,0xF8,0x00,0x00,0x20,0x00,0x00,
0x3F,0xBF,0x80,0x00,0x04,0x00,0x00,0x0F,0xE3,0xF8,
0x00,0x00,0x00,0x00,0x0F,0xC3,0xF8,0x00,0x00,0x80,
0x00,0x03,0xF8,0x3F,0x80,0x00,0x12,0x00,0x00,0xFE,
0x03,0xF8,0x00,0x02,0x00,0x00,0x3F,0x80,0x3F,0x80,
0x00,0x00,0x00,0x7F,0x80,0x3F,0xC0,0x00,0x40,0x00,
0x0F,0xE0,0x03,0xF8,0x00,0x08,0x00,0x03,0xF8,0x00,
0x3F,0x80,0x00,0x00,0x07,0xF8,0x00,0x3F,0xC0,0x01,
0x00,0x00,0xFE,0x00,0x03,0xF8,0x00,0x00,0x01,0xFE,
0x00,0x03,0xFC,0x00,0x00,0x01,0xFC,0x00,0x01,0xFC,
0x00,0x00,0x03,0xFC,0x00,0x01,0xFE,0x00,0x20,0x00,
0x7F,0x00,0x00,0x1F,0xC0,0x00,0x00,0xFF,0x00,0x00,
0x1F,0xE0,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xE0,0x04,
0x80,0x3F,0xFF,0xFF,0xFF,0xFE,0x00,0x80,0x0F,0xFF,
0xFF,0xFF,0xFF,0xE0,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,
0xF0,0x00,0x1F,0xE0,0x00,0x00,0x0F,0xF0,0x00,0x1F,
0xC0,0x00,0x00,0x07,0xF0,0x10,0x07,0xF8,0x00,0x00,
0x00,0xFF,0x02,0x41,0xFE,0x00,0x00,0x00,0x0F,0xF0,
0x40,0x7F,0x80,0x00,0x00,0x00,0xFF,0x00,0xFF,0x80,
0x00,0x00,0x00,0xFF,0x88,0x1F,0xE0,0x00,0x00,0x00,
0x0F,0xF1,0x07,0xF8,0x00,0x00,0x00,0x00,0xFF,0x0F,
0xF8,0x00,0x00,0x00,0x00,0xFF,0xA1,0xFE,0x00,0x00,
0x00,0x00,0x0F,0xF3,0xFE,0x00,0x00,0x00,0x00,0x0F,
0xFB,0xFC,0x00,0x00,0x00,0x00,0x07,0xF8,0x0B,0x1E,
0x1C,0x03,0x77,0xFF,0xFF,0xFF,0xC0,0x00,0x3F,0xFF,
0xFF,0xFF,0xC0,0x01,0xFF,0xFF,0xFF,0xFF,0xC0,0x0F,
0xFF,0xFF,0xFF,0xFF,0x00,0x7F,0xFF,0xFF,0xFF,0xFC,
0x03,0xFF,0xFF,0xFF,0xFF,0xF0,0x1F,0xFF,0xFF,0xFF,
0xFF,0xC0,0xFF,0x00,0x00,0x1F,0xFF,0x07,0xF8,0x00,
0x00,0x1F,0xF8,0x3F,0xC0,0x00,0x00,0x7F,0xE1,0xFE,
0x00,0x00,0x01,0xFF,0x0F,0xF0,0x00,0x00,0x07,0xF8,
0x7F,0x80,0x00,0x00,0x3F,0xE6,0x7F,0x80,0x00,0x00,
0x1F,0xE4,0x7F,0x80,0x00,0x00,0x3F,0xC3,0xFC,0x00,
0x00,0x03,0xFC,0x1F,0xE0,0x00,0x00,0x3F,0xE0,0xFF,
0x00,0x00,0x03,0xFE,0x07,0xF8,0x00,0x00,0xFF,0xE0,
0x3F,0xFF,0xFF,0xFF,0xFE,0x01,0xFF,0xFF,0xFF,0xFF,
0xE0,0x0F,0xFF,0xFF,0xFF,0xFC,0x00,0x7F,0xFF,0xFF,
0xFF,0xF0,0x03,0xFF,0xFF,0xFF,0xFF,0xE0,0x1F,0xFF,
0xFF,0xFF,0xFF,0x80,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,
0xF8,0x00,0x00,0x7F,0xF8,0x3F,0xC0,0x00,0x00,0x7F,
0xE1,0xFE,0x00,0x00,0x00,0xFF,0x8F,0xF0,0x00,0x00,
0x03,0xFC,0x7F,0x80,0x00,0x00,0x1F,0xF3,0xFC,0x00,
0x00,0x00,0x7F,0x9F,0xE0,0x00,0x00,0x03,0xFF,0xBF,
0xE0,0x00,0x00,0x01,0xFE,0xFF,0x00,0x00,0x00,0x1F,
0xF7,0xF8,0x00,0x00,0x00,0xFF,0x47,0xF8,0x00,0x00,
0x01,0xFF,0x3F,0xC0,0x00,0x00,0x1F,0xF1,0xFE,0x00,
0x00,0x03,0xFF,0x8F,0xF0,0x00,0x00,0xFF,0xF8,0x8F,
0xFF,0xFF,0xFF,0xFF,0xF0,0x7F,0xFF,0xFF,0xFF,0xFF,
0x03,0xFF,0xFF,0xFF,0xFF,0xE0,0x1F,0xFF,0xFF,0xFF,
0xFE,0x00,0xFF,0xFF,0xFF,0xFF,0x80,0x07,0xFF,0xFF,
0xFF,0xC0,0x00,0x00,0x0D,0x1F,0x13,0xFB,0xC0,0x00,
0x00,0x1F,0xFC,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFE,
0x00,0x00,0x00,0x01,0xFF,0xFF,0xFC,0x00,0x00,0x00,
0x3F,0xFF,0xFF,0xF8,0x00,0x00,0x07,0xFF,0xFF,0xFF,
0xE0,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xC0,0x00,0x0F,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xFF,0xFE,0x00,0xFF,
0xFC,0x00,0x0F,0xFF,0x00,0x00,0xFF,0xE0,0x00,0x7F,
0xE0,0x00,0x03,0xFF,0x80,0x07,0xFE,0x00,0x00,0x07,
0xFE,0x00,0x7F,0xE0,0x00,0x00,0x1F,0xF0,0x07,0xFE,
0x00,0x00,0x00,0x7F,0xC0,0x3F,0xE0,0x00,0x00,0x03,
0xFF,0x03,0xFE,0x00,0x00,0x00,0x0F,0xF8,0x1F,0xE0,
0x00,0x00,0x00,0x7F,0xC1,0xFF,0x00,0x00,0x00,0x01,
0xFF,0x0F,0xF0,0x00,0x00,0x00,0x0F,0xF8,0x7F,0x80,
0x00,0x00,0x00,0x3C,0x07,0xFC,0x00,0x00,0x00,0x00,
0x00,0xA7,0xF8,0x00,0x00,0x00,0x00,0x00,0x7F,0xC0,
0x00,0x00,0x00,0x00,0x06,0xFF,0x80,0x00,0x00,0x00,
0x00,0x05,0xFF,0x80,0x00,0x00,0x00,0x00,0x04,0xBF,
0xC0,0x00,0x00,0x00,0x00,0x01,0xFE,0x00,0x00,0x00,
0x00,0x38,0x0F,0xF0,0x00,0x00,0x00,0x01,0xFD,0x07,
0xF8,0x00,0x00,0x00,0x03,0xFE,0x3F,0xC0,0x00,0x00,
0x00,0x1F,0xE8,0x1F,0xE0,0x00,0x00,0x00,0x3F,0xE0,
0xFF,0x80,0x00,0x00,0x03,0xFE,0x03,0xFE,0x00,0x00,
0x00,0x3F,0xF0,0x1F,0xF8,0x00,0x00,0x01,0xFF,0x00,
0x7F,0xE0,0x00,0x00,0x1F,0xF8,0x01,0xFF,0x80,0x00,
0x01,0xFF,0x80,0x0F,0xFE,0x00,0x00,0x3F,0xF8,0x00,
0x3F,0xFC,0x00,0x07,0xFF,0xC0,0x00,0xFF,0xFC,0x01,
0xFF,0xFC,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,
0x0F,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x3F,0xFF,0xFF,
0xFF,0x80,0x00,0x00,0x7F,0xFF,0xFF,0xF8,0x00,0x00,
0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x01,0xFF,0xFF,
0xE0,0x00,0x00,0x00,0x00,0xFF,0xF0,0x00,0x00,0x0C,
0x5E,0x1C,0x03,0xC7,0xFF,0xFF,0xFF,0xC0,0x00,0x01,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x7F,0xFF,0xFF,0xFF,
0xF8,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0x00,0x07,0xFF,
0xFF,0xFF,0xFF,0xF0,0x01,0xFF,0xFF,0xFF,0xFF,0xFE,
0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xC0,0x1F,0xE0,0x00,
0x01,0xFF,0xF8,0x07,0xF8,0x00,0x00,0x0F,0xFF,0x01,
0xFE,0x00,0x00,0x00,0xFF,0xE0,0x7F,0x80,0x00,0x00,
0x1F,0xF8,0x1F,0xE0,0x00,0x00,0x03,0xFF,0x07,0xF8,
0x00,0x00,0x00,0x7F,0xC1,0xFE,0x00,0x00,0x00,0x0F,
0xF8,0x7F,0x80,0x00,0x00,0x01,0xFE,0x1F,0xE0,0x00,
0x00,0x00,0x7F,0xC8,0xFF,0x00,0x00,0x00,0x01,0xFE,
0x3F,0xC0,0x00,0x00,0x00,0x7F,0xD5,0xFE,0x00,0x00,
0x00,0x01,0xFE,0xDF,0xF0,0x00,0x00,0x00,0x07,0xFE,
0x7F,0x80,0x00,0x00,0x00,0x3F,0xDF,0xE0,0x00,0x00,
0x00,0x1F,0xFA,0xFF,0x00,0x00,0x00,0x00,0xFF,0x3F,
0xC0,0x00,0x00,0x00,0x7F,0xD1,0xFE,0x00,0x00,0x00,
0x03,0xFC,0x7F,0x80,0x00,0x00,0x01,0xFF,0x1F,0xE0,
0x00,0x00,0x00,0x7F,0x87,0xF8,0x00,0x00,0x00,0x3F,
0xE1,0xFE,0x00,0x00,0x00,0x1F,0xF0,0x7F,0x80,0x00,
0x00,0x0F,0xFC,0x1F,0xE0,0x00,0x00,0x07,0xFE,0x07,
0xF8,0x00,0x00,0x03,0xFF,0x01,0xFE,0x00,0x00,0x03,
0xFF,0xC0,0x7F,0x80,0x00,0x0F,0xFF,0xE0,0x1F,0xFF,
0xFF,0xFF,0xFF,0xF0,0x07,0xFF,0xFF,0xFF,0xFF,0xF8,
0x01,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x7F,0xFF,0xFF,
0xFF,0xFC,0x00,0x1F,0xFF,0xFF,0xFF,0xFC,0x00,0x07,
0xFF,0xFF,0xFF,0xFC,0x00,0x01,0xFF,0xFF,0xFF,0xE0,
0x00,0x00,0x0B,0x1E,0x1C,0x03,0x7D,0xFF,0xFF,0xFF,
0xFF,0xFF,0xED,0xFF,0x00,0x00,0x00,0x00,0x0D,0xFF,
0x00,0x00,0x00,0x00,0x0A,0xFF,0x00,0x00,0x00,0x00,
0x0D,0xFF,0xFF,0xFF,0xFF,0xFF,0x8D,0xFF,0x00,0x00,
0x00,0x00,0x0D,0xFF,0x00,0x00,0x00,0x00,0x0D,0xFF,
0x00,0x00,0x00,0x00,0x0D,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF0,0x0A,0x1E,0x1C,0x03,0x3D,0xFF,0xFF,0xFF,0xFF,
0xFF,0xDF,0xF0,0x00,0x00,0x00,0x0D,0xFF,0x00,0x00,
0x00,0x00,0xBF,0xF0,0x00,0x00,0x00,0x0D,0xFF,0xFF,
0xFF,0xFF,0xE0,0xDF,0xF0,0x00,0x00,0x00,0x0D,0xFF,
0x00,0x00,0x00,0x00,0xDF,0xF0,0x00,0x00,0x00,0x0C,
0xFF,0x00,0x00,0x00,0x00,0x0E,0x1F,0x13,0xFC,0x10,
0x00,0x00,0x07,0xFF,0x80,0x00,0x00,0x00,0x00,0x3F,
0xFF,0xFC,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xC0,
0x00,0x00,0x01,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x03,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x07,0xFF,0xFF,0xFF,
0xFF,0xC0,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,
0x07,0xFF,0xF8,0x01,0xFF,0xFC,0x00,0x07,0xFF,0xC0,
0x00,0x1F,0xFF,0x00,0x07,0xFF,0x80,0x00,0x03,0xFF,
0xC0,0x07,0xFF,0x00,0x00,0x00,0x7F,0xE0,0x03,0xFF,
0x00,0x00,0x00,0x1F,0xF8,0x03,0xFF,0x00,0x00,0x00,
0x07,0xFC,0x03,0xFF,0x00,0x00,0x00,0x01,0xFF,0x01,
0xFF,0x00,0x00,0x00,0x00,0x7F,0x81,0xFF,0x00,0x00,
0x00,0x00,0x3F,0xC0,0xFF,0x80,0x00,0x00,0x00,0x0F,
0xF0,0x7F,0x80,0x00,0x00,0x00,0x07,0xF8,0x7F,0xC0,
0x00,0x00,0x00,0x03,0xE0,0x3F,0xC0,0x00,0x00,0x00,
0x00,0x00,0x3F,0xE0,0x00,0x00,0x00,0x00,0x00,0x53,
0xFC,0x00,0x00,0x00,0x00,0x00,0x05,0xFF,0x80,0x00,
0x00,0x00,0x00,0x00,0x6F,0xF8,0x00,0x00,0x1F,0xFF,
0xFF,0xFB,0xFE,0x00,0x00,0x00,0x00,0x03,0xFE,0x5F,
0xE0,0x00,0x00,0x00,0x00,0x3F,0xCF,0xF8,0x00,0x00,
0x00,0x00,0x1F,0xF0,0x7F,0x80,0x00,0x00,0x00,0x01,
0xFE,0x3F,0xE0,0x00,0x00,0x00,0x00,0xFF,0x0F,0xF0,
0x00,0x00,0x00,0x00,0x7F,0x87,0xFC,0x00,0x00,0x00,
0x00,0x3F,0xC1,0xFF,0x00,0x00,0x00,0x00,0x1F,0xE0,
0xFF,0xC0,0x00,0x00,0x00,0x0F,0xF0,0x3F,0xF0,0x00,
0x00,0x00,0x0F,0xF8,0x0F,0xFC,0x00,0x00,0x00,0x1F,
0xFC,0x07,0xFF,0x00,0x00,0x00,0x1F,0xFE,0x01,0xFF,
0xE0,0x00,0x00,0x3F,0xFF,0x00,0x7F,0xFC,0x00,0x00,
0xFF,0xFF,0x00,0x1F,0xFF,0xE0,0x07,0xFF,0xFE,0x00,
0x07,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0xFF,0xFF,
0xFF,0xFF,0xFC,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xF8,
0x00,0x00,0x07,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x0F,0xFF,0xFF,
0x80,0x00,0x00,0x00,0x00,0x3F,0xFC,0x00,0x00,0x00,
0x0B,0x9E,0x1C,0x03,0xCD,0xFF,0x00,0x00,0x00,0x03,
0xFF,0x7F,0xC0,0x00,0x00,0x00,0xFF,0xDF,0xF0,0x00,
0x00,0x00,0x3F,0xEB,0xFC,0x00,0x00,0x00,0x0F,0xFD,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0xC0,0x00,0x00,
0x00,0xFF,0xDF,0xF0,0x00,0x00,0x00,0x3F,0xF7,0xFC,
0x00,0x00,0x00,0x0F,0xFD,0xFF,0x00,0x00,0x00,0x03,
0xFC,0x02,0x1E,0x1C,0x01,0x7D,0xFF,0xDF,0xFD,0xFF,
0xDF,0xFD,0xFF,0xDF,0xFD,0xFF,0xDF,0xFA,0xFF,0x08,
0x1E,0x8F,0xFA,0xAD,0x00,0x00,0x00,0xFF,0xD0,0x00,
0x00,0x0F,0xFD,0x00,0x00,0x00,0xFF,0xD0,0x00,0x00,
0x0F,0xFD,0x00,0x00,0x00,0xFF,0xD0,0x00,0x00,0x0F,
0xF0,0x78,0x00,0x07,0xFD,0x7F,0x80,0x00,0x7F,0xBF,
0xE0,0x00,0x3F,0xDF,0xF0,0x00,0x3F,0xC7,0xF8,0x00,
0x1F,0xE3,0xFE,0x00,0x0F,0xF1,0xFF,0x00,0x0F,0xF8,
0xFF,0xC0,0x0F,0xF8,0x3F,0xF8,0x1F,0xFC,0x1F,0xFF,
0xFF,0xFC,0x07,0xFF,0xFF,0xFC,0x01,0xFF,0xFF,0xFE,
0x00,0x7F,0xFF,0xFE,0x00,0x1F,0xFF,0xFC,0x00,0x03,
0xFF,0xF8,0x00,0x00,0x3F,0xE0,0x00,0x0C,0x5E,0x1C,
0x03,0x77,0xF8,0x00,0x00,0x00,0x7F,0xF1,0xFE,0x00,
0x00,0x00,0x3F,0xF8,0x7F,0x80,0x00,0x00,0x1F,0xFC,
0x1F,0xE0,0x00,0x00,0x0F,0xFE,0x07,0xF8,0x00,0x00,
0x07,0xFF,0x01,0xFE,0x00,0x00,0x03,0xFF,0x80,0x7F,
0x80,0x00,0x01,0xFF,0xC0,0x1F,0xE0,0x00,0x00,0xFF,
0xE0,0x07,0xF8,0x00,0x00,0x7F,0xF0,0x01,0xFE,0x00,
0x00,0x3F,0xF8,0x00,0x7F,0x80,0x00,0x1F,0xFC,0x00,
0x1F,0xE0,0x00,0x0F,0xFE,0x00,0x07,0xF8,0x00,0x07,
0xFF,0x00,0x01,0xFE,0x00,0x03,0xFF,0x80,0x00,0x7F,
0x80,0x01,0xFF,0xC0,0x00,0x1F,0xE0,0x00,0xFF,0xE0,
0x00,0x07,0xF8,0x00,0x7F,0xF0,0x00,0x01,0xFE,0x00,
0x3F,0xF8,0x00,0x00,0x7F,0x80,0x1F,0xFC,0x00,0x00,
0x1F,0xE0,0x0F,0xFE,0x00,0x00,0x07,0xF8,0x07,0xFF,
0x00,0x00,0x01,0xFE,0x03,0xFF,0x80,0x00,0x00,0x7F,
0x81,0xFF,0xC0,0x00,0x00,0x1F,0xE0,0xFF,0xE0,0x00,
0x00,0x07,0xF8,0x7F,0xF0,0x00,0x00,0x01,0xFE,0x3F,
0xFC,0x00,0x00,0x00,0x7F,0x9F,0xFF,0x80,0x00,0x00,
0x1F,0xEF,0xFF,0xE0,0x00,0x00,0x07,0xFF,0xFF,0xFC,
0x00,0x00,0x01,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x7F,
0xFF,0xFF,0xF0,0x00,0x00,0x1F,0xFF,0xE7,0xFC,0x00,
0x00,0x07,0xFF,0xF1,0xFF,0x80,0x00,0x01,0xFF,0xF8,
0x3F,0xF0,0x00,0x00,0x7F,0xFC,0x07,0xFE,0x00,0x00,
0x1F,0xFE,0x00,0xFF,0x80,0x00,0x07,0xFF,0x00,0x3F,
0xF0,0x00,0x01,0xFF,0x80,0x07,0xFE,0x00,0x00,0x7F,
0xC0,0x00,0xFF,0xC0,0x00,0x1F,0xE0,0x00,0x1F,0xF0,
0x00,0x07,0xF8,0x00,0x07,0xFE,0x00,0x01,0xFE,0x00,
0x00,0xFF,0xC0,0x00,0x7F,0x80,0x00,0x1F,0xF8,0x00,
0x1F,0xE0,0x00,0x03,0xFE,0x00,0x07,0xF8,0x00,0x00,
0xFF,0xC0,0x01,0xFE,0x00,0x00,0x1F,0xF8,0x00,0x7F,
0x80,0x00,0x03,0xFF,0x00,0x1F,0xE0,0x00,0x00,0x7F,
0xE0,0x07,0xF8,0x00,0x00,0x0F,0xF8,0x01,0xFE,0x00,
0x00,0x03,0xFF,0x00,0x7F,0x80,0x00,0x00,0x7F,0xE0,
0x1F,0xE0,0x00,0x00,0x0F,0xFC,0x07,0xF8,0x00,0x00,
0x01,0xFF,0x01,0xFE,0x00,0x00,0x00,0x7F,0xE0,0x7F,
0x80,0x00,0x00,0x0F,0xFC,0x1F,0xE0,0x00,0x00,0x01,
0xFF,0x87,0xF8,0x00,0x00,0x00,0x3F,0xE1,0xFE,0x00,
0x00,0x00,0x0F,0xFC,0x7F,0x80,0x00,0x00,0x01,0xFF,
0x9F,0xE0,0x00,0x00,0x00,0x3F,0xF0,0x09,0x1E,0x1C,
0x02,0xED,0xFF,0x00,0x00,0x00,0x0D,0xFF,0x00,0x00,
0x00,0x0D,0xFF,0x00,0x00,0x00,0x0D,0xFF,0x00,0x00,
0x00,0x0D,0xFF,0x00,0x00,0x00,0x0D,0xFF,0x00,0x00,
0x00,0x0D,0xFF,0x00,0x00,0x00,0x0A,0xFF,0x00,0x00,
0x00,0x0D,0xFF,0xFF,0xFF,0xFF,0xF0,0x0E,0x5E,0x18,
0x04,0x58,0xFF,0xF8,0x00,0x00,0x00,0x0F,0xFF,0xCF,
0xFF,0xE0,0x00,0x00,0x00,0xFF,0xFE,0x7F,0xFF,0x80,
0x00,0x00,0x0F,0xFF,0xEF,0xFF,0xF0,0x00,0x00,0x07,
0xFF,0xFC,0x7F,0xBF,0x80,0x00,0x00,0x3F,0xBF,0xDF,
0xEF,0xF0,0x00,0x00,0x0F,0xEF,0xF9,0xFF,0x3F,0x80,
0x00,0x00,0xFE,0x7F,0xCF,0xF8,0xFE,0x00,0x00,0x0F,
0xE3,0xFD,0xFE,0x3F,0xC0,0x00,0x07,0xF8,0xFF,0x8F,
0xF0,0xFE,0x00,0x00,0x3F,0x87,0xFB,0xFC,0x3F,0xC0,
0x00,0x1F,0xE1,0xFF,0x1F,0xE0,0xFE,0x00,0x00,0xFE,
0x0F,0xF7,0xF8,0x3F,0xC0,0x00,0x3F,0x83,0xFE,0x7F,
0xC0,0xFE,0x00,0x03,0xF8,0x1F,0xEF,0xF0,0x3F,0xC0,
0x01,0xFC,0x07,0xFC,0x7F,0x80,0xFE,0x00,0x0F,0xE0,
0x3F,0xDF,0xE0,0x3F,0xC0,0x07,0xF8,0x0F,0xF8,0xFF,
0x00,0xFE,0x00,0x3F,0x80,0x7F,0xBF,0xC0,0x3F,0xC0,
0x1F,0xE0,0x1F,0xF1,0xFE,0x00,0xFE,0x00,0xFE,0x00,
0xFF,0x7F,0x80,0x3F,0xC0,0x3F,0x80,0x3F,0xDF,0xE0,
0x0F,0xF0,0x1F,0xC0,0x0F,0xF8,0xFF,0x00,0x3F,0x80,
0xFE,0x00,0x7F,0xBF,0xC0,0x0F,0xF0,0x7F,0x80,0x1F,
0xF1,0xFE,0x00,0x3F,0x83,0xF8,0x00,0xFF,0x7F,0x80,
0x0F,0xF1,0xFE,0x00,0x3F,0xE3,0xFC,0x00,0x3F,0x8F,
0xE0,0x01,0xFE,0xFF,0x00,0x0F,0xF7,0xF8,0x00,0x7F,
0xBF,0xC0,0x03,0xFD,0xFC,0x00,0x1F,0xF1,0xFE,0x00,
0x0F,0xEF,0xE0,0x00,0xFF,0x7F,0x80,0x03,0xFF,0xF8,
0x00,0x3F,0xE7,0xFC,0x00,0x0F,0xFF,0x80,0x01,0xFF,
0x3F,0xE0,0x00,0x3F,0xF8,0x00,0x0F,0xF7,0xF8,0x00,
0x0F,0xFC,0x00,0x03,0xFD,0xFE,0x00,0x01,0xFF,0x00,
0x00,0xFF,0x0B,0x9E,0x1C,0x03,0xC8,0xFF,0x80,0x00,
0x00,0x03,0xFD,0xFF,0x80,0x00,0x00,0x07,0xFC,0x7F,
0xF0,0x00,0x00,0x01,0xFE,0xFF,0xF0,0x00,0x00,0x03,
0xFE,0x3F,0xFE,0x00,0x00,0x00,0xFF,0x7F,0xFE,0x00,
0x00,0x01,0xFF,0x1F,0xFF,0xC0,0x00,0x00,0x7F,0xBF,
0xFF,0xC0,0x00,0x00,0xFF,0x8F,0xFF,0xF8,0x00,0x00,
0x3F,0xDF,0xFF,0xF8,0x00,0x00,0x7F,0xBF,0xDF,0xF0,
0x00,0x00,0xFF,0x7F,0x9F,0xF0,0x00,0x01,0xFE,0xFF,
0x3F,0xF0,0x00,0x03,0xFD,0xFE,0x3F,0xE0,0x00,0x07,
0xFB,0xFC,0x3F,0xE0,0x00,0x0F,0xF7,0xF8,0x7F,0xE0,
0x00,0x1F,0xEF,0xF0,0x7F,0xC0,0x00,0x3F,0xDF,0xE0,
0xFF,0xC0,0x00,0x7F,0xBF,0xC0,0xFF,0xC0,0x00,0xFF,
0x7F,0x80,0xFF,0x80,0x01,0xFE,0xFF,0x01,0xFF,0x80,
0x03,0xFD,0xFE,0x01,0xFF,0x00,0x07,0xFB,0xFC,0x01,
0xFF,0x00,0x0F,0xF7,0xF8,0x03,0xFF,0x00,0x1F,0xEF,
0xF0,0x03,0xFE,0x00,0x3F,0xDF,0xE0,0x03,0xFE,0x00,
0x7F,0xBF,0xC0,0x07,0xFE,0x00,0xFF,0x7F,0x80,0x07,
0xFC,0x01,0xFE,0xFF,0x00,0x07,0xFC,0x03,0xFD,0xFE,
0x00,0x0F,0xFC,0x07,0xFB,0xFC,0x00,0x0F,0xF8,0x0F,
0xF7,0xF8,0x00,0x1F,0xF8,0x1F,0xEF,0xF0,0x00,0x1F,
0xF8,0x3F,0xDF,0xE0,0x00,0x1F,0xF0,0x7F,0xBF,0xC0,
0x00,0x3F,0xF0,0xFF,0x7F,0x80,0x00,0x3F,0xE1,0xFE,
0xFF,0x00,0x00,0x3F,0xE3,0xFD,0xFE,0x00,0x00,0x7F,
0xE7,0xFB,0xFC,0x00,0x00,0x7F,0xCF,0xF7,0xF8,0x00,
0x00,0x7F,0xDF,0xEF,0xF0,0x00,0x00,0xFF,0xFF,0xE3,
0xFC,0x00,0x00,0x1F,0xFF,0xF7,0xF8,0x00,0x00,0x1F,
0xFF,0xF1,0xFE,0x00,0x00,0x03,0xFF,0xFB,0xFC,0x00,
0x00,0x03,0xFF,0xF8,0xFF,0x00,0x00,0x00,0x7F,0xFD,
0xFE,0x00,0x00,0x00,0x7F,0xFC,0x7F,0x80,0x00,0x00,
0x0F,0xFE,0xFF,0x00,0x00,0x00,0x0F,0xFE,0x3F,0xC0,
0x00,0x00,0x01,0xFF,0x0E,0x5F,0x13,0xFC,0x10,0x00,
0x00,0x0F,0xFE,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xC0,0x00,
0x00,0x00,0x7F,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x3F,
0xFF,0xFF,0xFF,0x80,0x00,0x00,0x3F,0xFF,0xFF,0xFF,
0xF8,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0x00,0x00,
0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x00,0x07,0xFF,0xC0,
0x00,0x7F,0xFC,0x00,0x03,0xFF,0xC0,0x00,0x07,0xFF,
0x80,0x01,0xFF,0xC0,0x00,0x00,0x7F,0xF0,0x00,0xFF,
0xE0,0x00,0x00,0x0F,0xFC,0x00,0x3F,0xE0,0x00,0x00,
0x01,0xFF,0x80,0x1F,0xF0,0x00,0x00,0x00,0x3F,0xF0,
0x07,0xF8,0x00,0x00,0x00,0x07,0xFC,0x03,0xFE,0x00,
0x00,0x00,0x00,0xFF,0x80,0xFF,0x00,0x00,0x00,0x00,
0x1F,0xE0,0x7F,0xC0,0x00,0x00,0x00,0x07,0xFC,0x83,
0xFC,0x00,0x00,0x00,0x00,0x1F,0xE1,0xFE,0x00,0x00,
0x00,0x00,0x07,0xFD,0x4F,0xF0,0x00,0x00,0x00,0x00,
0x1F,0xED,0xFF,0x00,0x00,0x00,0x00,0x00,0x7F,0xDF,
0xF8,0x00,0x00,0x00,0x00,0x03,0xFD,0xFE,0x00,0x00,
0x00,0x00,0x01,0xFF,0x97,0xF8,0x00,0x00,0x00,0x00,
0x0F,0xF1,0xFE,0x00,0x00,0x00,0x00,0x07,0xFD,0x07,
0xF8,0x00,0x00,0x00,0x00,0x3F,0xC1,0xFF,0x00,0x00,
0x00,0x00,0x1F,0xF0,0x3F,0xC0,0x00,0x00,0x00,0x07,
0xF8,0x0F,0xF8,0x00,0x00,0x00,0x03,0xFE,0x01,0xFF,
0x00,0x00,0x00,0x01,0xFF,0x00,0x7F,0xE0,0x00,0x00,
0x00,0xFF,0xC0,0x0F,0xF8,0x00,0x00,0x00,0x7F,0xE0,
0x01,0xFF,0x80,0x00,0x00,0x3F,0xF8,0x00,0x7F,0xF0,
0x00,0x00,0x1F,0xFC,0x00,0x0F,0xFE,0x00,0x00,0x0F,
0xFE,0x00,0x01,0xFF,0xE0,0x00,0x1F,0xFF,0x00,0x00,
0x3F,0xFF,0x80,0x3F,0xFF,0x80,0x00,0x07,0xFF,0xFF,
0xFF,0xFF,0xC0,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xE0,
0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x01,
0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0xF0,0x00,0x00,0x00,0x00,0xFF,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x03,0xFF,0x80,0x00,0x00,0x0B,0x1E,0x1C,
0x03,0x77,0xFF,0xFF,0xFF,0xE0,0x00,0x3F,0xFF,0xFF,
0xFF,0xF0,0x01,0xFF,0xFF,0xFF,0xFF,0xE0,0x0F,0xFF,
0xFF,0xFF,0xFF,0xC0,0x7F,0xFF,0xFF,0xFF,0xFF,0x03,
0xFF,0xFF,0xFF,0xFF,0xFC,0x1F,0xFF,0xFF,0xFF,0xFF,
0xF0,0xFF,0x00,0x00,0x07,0xFF,0x87,0xF8,0x00,0x00,
0x07,0xFE,0x3F,0xC0,0x00,0x00,0x1F,0xF2,0x3F,0xC0,
0x00,0x00,0x0F,0xF9,0xFE,0x00,0x00,0x00,0x3F,0xCF,
0xF0,0x00,0x00,0x01,0xFF,0xDF,0xF0,0x00,0x00,0x00,
0xFF,0x7F,0x80,0x00,0x00,0x07,0xFC,0x7F,0x80,0x00,
0x00,0x0F,0xF3,0xFC,0x00,0x00,0x00,0xFF,0x9F,0xE0,
0x00,0x00,0x0F,0xFC,0xFF,0x00,0x00,0x00,0xFF,0xC7,
0xF8,0x00,0x00,0x0F,0xFE,0x3F,0xC0,0x00,0x03,0xFF,
0xE1,0xFF,0xFF,0xFF,0xFF,0xFE,0x11,0xFF,0xFF,0xFF,
0xFF,0xFC,0x0F,0xFF,0xFF,0xFF,0xFF,0x80,0x7F,0xFF,
0xFF,0xFF,0xF8,0x03,0xFF,0xFF,0xFF,0xFE,0x00,0x1F,
0xFF,0xFF,0xFF,0x00,0x01,0xBF,0xE0,0x00,0x00,0x00,
0x01,0xBF,0xE0,0x00,0x00,0x00,0x01,0xBF,0xE0,0x00,
0x00,0x00,0x01,0x3F,0xE0,0x00,0x00,0x00,0x00,0x0E,
0x60,0x93,0xDC,0x10,0x00,0x00,0x0F,0xFC,0x00,0x00,
0x00,0x00,0x00,0x3F,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x7F,0xFF,0xFF,0x80,0x00,0x00,0x00,0x7F,0xFF,0xFF,
0xF8,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0x80,0x00,
0x00,0x3F,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x1F,0xFF,
0xFF,0xFF,0xFE,0x00,0x00,0x0F,0xFF,0xC0,0x0F,0xFF,
0xC0,0x00,0x07,0xFF,0x80,0x00,0x7F,0xF8,0x00,0x03,
0xFF,0x80,0x00,0x07,0xFF,0x00,0x01,0xFF,0xC0,0x00,
0x00,0xFF,0xE0,0x00,0xFF,0xC0,0x00,0x00,0x0F,0xFC,
0x00,0x3F,0xE0,0x00,0x00,0x01,0xFF,0x00,0x1F,0xF0,
0x00,0x00,0x00,0x3F,0xE0,0x07,0xF8,0x00,0x00,0x00,
0x0F,0xF8,0x03,0xFE,0x00,0x00,0x00,0x01,0xFF,0x00,
0xFF,0x00,0x00,0x00,0x00,0x3F,0xC0,0x7F,0xC0,0x00,
0x00,0x00,0x0F,0xF8,0x83,0xFC,0x00,0x00,0x00,0x00,
0x3F,0xC1,0xFE,0x00,0x00,0x00,0x00,0x0F,0xF9,0x2F,
0xF0,0x00,0x00,0x00,0x00,0x3F,0xC7,0xF8,0x00,0x00,
0x00,0x00,0x0F,0xFB,0x7F,0xC0,0x00,0x00,0x00,0x00,
0x3F,0xD7,0xFE,0x00,0x00,0x00,0x00,0x01,0xFE,0x7F,
0x80,0x00,0x00,0x00,0x00,0xFF,0xA5,0xFE,0x00,0x00,
0x00,0x00,0x07,0xF8,0x7F,0x80,0x00,0x00,0x00,0x03,
0xFE,0x41,0xFE,0x00,0x00,0x00,0x00,0x1F,0xE0,0x7F,
0xC0,0x00,0x04,0x00,0x0F,0xF8,0x0F,0xF0,0x00,0x01,
0xE0,0x03,0xFC,0x03,0xFE,0x00,0x00,0xFE,0x01,0xFF,
0x00,0x7F,0xC0,0x00,0x3F,0xE0,0xFF,0x80,0x1F,0xF0,
0x00,0x0F,0xFC,0x3F,0xE0,0x03,0xFE,0x00,0x07,0xFF,
0xDF,0xF0,0x00,0xFF,0xC0,0x00,0x7F,0xFF,0xF8,0x00,
0x1F,0xFC,0x00,0x07,0xFF,0xFE,0x00,0x03,0xFF,0x80,
0x00,0x7F,0xFF,0x00,0x00,0x7F,0xF8,0x00,0x07,0xFF,
0x80,0x00,0x0F,0xFF,0xC0,0x0F,0xFF,0xC0,0x00,0x01,
0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x3F,0xFF,0xFF,
0xFF,0xFF,0x80,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xF8,
0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x07,
0xFF,0xFF,0xFC,0xFF,0xF0,0x00,0x00,0x7F,0xFF,0xF8,
0x0F,0xFF,0x00,0x00,0x01,0xFF,0xE0,0x01,0xFF,0x80,
0x00,0x00,0x00,0x00,0x00,0x1F,0xE0,0x00,0x00,0x00,
0x00,0x00,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,
0x1C,0x0C,0x9E,0x1C,0x03,0xC7,0xFF,0xFF,0xFF,0xFC,
0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x1F,0xFF,
0xFF,0xFF,0xFF,0xC0,0x03,0xFF,0xFF,0xFF,0xFF,0xFC,
0x00,0x8F,0xFF,0xFF,0xFF,0xFF,0xFC,0x01,0xFF,0xFF,
0xFF,0xFF,0xFF,0xC0,0x3F,0xC0,0x00,0x00,0x7F,0xFC,
0x07,0xF8,0x00,0x00,0x03,0xFF,0x80,0xFF,0x00,0x00,
0x00,0x1F,0xF8,0x1F,0xE0,0x00,0x00,0x01,0xFF,0x03,
0xFC,0x00,0x00,0x00,0x1F,0xE0,0x7F,0x80,0x00,0x00,
0x03,0xFE,0x19,0xFE,0x00,0x00,0x00,0x07,0xF8,0x3F,
0xC0,0x00,0x00,0x01,0xFF,0x07,0xF8,0x00,0x00,0x00,
0x3F,0xC1,0x1F,0xE0,0x00,0x00,0x01,0xFF,0x03,0xFC,
0x00,0x00,0x00,0x7F,0xC0,0x7F,0x80,0x00,0x00,0x3F,
0xF8,0x0F,0xF0,0x00,0x00,0x3F,0xFE,0x01,0xFF,0xFF,
0xFF,0xFF,0xFF,0x80,0x3F,0xFF,0xFF,0xFF,0xFF,0xE0,
0x07,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0xFF,0xFF,0xFF,
0xFF,0xFC,0x00,0x1F,0xFF,0xFF,0xFF,0xFE,0x00,0x03,
0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x7F,0xFF,0xFF,0xFF,
0x00,0x00,0x0F,0xF0,0x00,0x3F,0xF0,0x00,0x01,0xFE,
0x00,0x01,0xFF,0x80,0x00,0x3F,0xC0,0x00,0x1F,0xF8,
0x00,0x07,0xF8,0x00,0x01,0xFF,0x80,0x00,0xFF,0x00,
0x00,0x1F,0xF0,0x00,0x1F,0xE0,0x00,0x01,0xFF,0x00,
0x03,0xFC,0x00,0x00,0x1F,0xF0,0x00,0x7F,0x80,0x00,
0x03,0xFF,0x00,0x0F,0xF0,0x00,0x00,0x3F,0xE0,0x01,
0xFE,0x00,0x00,0x03,0xFE,0x00,0x3F,0xC0,0x00,0x00,
0x7F,0xE0,0x07,0xF8,0x00,0x00,0x07,0xFC,0x01,0x1F,
0xE0,0x00,0x00,0x0F,0xF8,0x03,0xFC,0x00,0x00,0x00,
0xFF,0x80,0x7F,0x80,0x00,0x00,0x1F,0xF8,0x0F,0xF0,
0x00,0x00,0x01,0xFF,0x02,0x3F,0xC0,0x00,0x00,0x03,
0xFE,0x07,0xF8,0x00,0x00,0x00,0x3F,0xE0,0xFF,0x00,
0x00,0x00,0x07,0xFE,0x1F,0xE0,0x00,0x00,0x00,0x7F,
0xC4,0x7F,0x80,0x00,0x00,0x00,0xFF,0x91,0xFE,0x00,
0x00,0x00,0x01,0xFF,0x3F,0xC0,0x00,0x00,0x00,0x1F,
0xF0,0x0B,0xDF,0x13,0xFB,0x70,0x00,0x01,0xFF,0xC0,
0x00,0x00,0x00,0x1F,0xFF,0xFC,0x00,0x00,0x00,0xFF,
0xFF,0xFF,0x80,0x00,0x03,0xFF,0xFF,0xFF,0xE0,0x00,
0x07,0xFF,0xFF,0xFF,0xF0,0x00,0x0F,0xFF,0xFF,0xFF,
0xF8,0x00,0x1F,0xFF,0xFF,0xFF,0xFC,0x00,0x3F,0xFE,
0x00,0x3F,0xFE,0x00,0x7F,0xF0,0x00,0x07,0xFF,0x00,
0x7F,0xC0,0x00,0x01,0xFF,0x80,0xFF,0x80,0x00,0x00,
0xFF,0x88,0x1F,0xE0,0x00,0x00,0x0F,0xF8,0x3F,0xC0,
0x00,0x00,0x07,0xF8,0x3F,0xC0,0x00,0x00,0x07,0xFD,
0x27,0xF8,0x00,0x00,0x00,0x7F,0x87,0xF8,0x00,0x00,
0x00,0x00,0x07,0xFC,0x00,0x00,0x00,0x00,0x03,0xFC,
0x00,0x00,0x00,0x00,0x03,0xFE,0x00,0x00,0x00,0x00,
0x03,0xFF,0x80,0x00,0x00,0x00,0x01,0xFF,0xE0,0x00,
0x00,0x00,0x01,0xFF,0xFE,0x00,0x00,0x00,0x00,0xFF,
0xFF,0xC0,0x00,0x00,0x00,0x7F,0xFF,0xFE,0x00,0x00,
0x00,0x3F,0xFF,0xFF,0xC0,0x00,0x00,0x0F,0xFF,0xFF,
0xFC,0x00,0x00,0x07,0xFF,0xFF,0xFF,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x3F,0xFF,0xFF,0xF0,
0x00,0x00,0x03,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x3F,
0xFF,0xFC,0x00,0x00,0x00,0x03,0xFF,0xFE,0x00,0x00,
0x00,0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x0F,0xFF,
0x00,0x00,0x00,0x00,0x03,0xFF,0x80,0x00,0x00,0x00,
0x00,0xFF,0x80,0x00,0x00,0x00,0x00,0x7F,0x80,0x00,
0x00,0x00,0x00,0x7F,0xDF,0xE0,0x00,0x00,0x00,0x7F,
0xE3,0xFC,0x00,0x00,0x00,0x07,0xFB,0xFE,0x00,0x00,
0x00,0x07,0xFC,0x3F,0xC0,0x00,0x00,0x00,0xFF,0x3F,
0xE0,0x00,0x00,0x00,0xFF,0x3F,0xE0,0x00,0x00,0x01,
0xFE,0x1F,0xF0,0x00,0x00,0x01,0xFE,0x1F,0xF8,0x00,
0x00,0x03,0xFE,0x0F,0xFC,0x00,0x00,0x07,0xFC,0x0F,
0xFF,0x00,0x00,0x0F,0xFC,0x07,0xFF,0xC0,0x00,0x3F,
0xF8,0x03,0xFF,0xF8,0x01,0xFF,0xF0,0x01,0xFF,0xFF,
0xFF,0xFF,0xE0,0x00,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,
0x7F,0xFF,0xFF,0xFF,0x80,0x00,0x1F,0xFF,0xFF,0xFF,
0x00,0x00,0x07,0xFF,0xFF,0xFC,0x00,0x00,0x01,0xFF,
0xFF,0xE0,0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x0C,
0x1E,0x08,0x03,0x4D,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xD0,0x00,0x00,0xFF,0x00,0x00,0x0D,0x00,0x00,0x0F,
0xF0,0x00,0x00,0xD0,0x00,0x00,0xFF,0x00,0x00,0x0D,
0x00,0x00,0x0F,0xF0,0x00,0x00,0xD0,0x00,0x00,0xFF,
0x00,0x00,0x0D,0x00,0x00,0x0F,0xF0,0x00,0x00,0xD0,
0x00,0x00,0xFF,0x00,0x00,0x0A,0x00,0x00,0x0F,0xF0,
0x00,0x00,0x0B,0x9E,0x9F,0xFB,0xCD,0xFF,0x00,0x00,
0x00,0x03,0xFF,0x7F,0xC0,0x00,0x00,0x00,0xFF,0xDF,
0xF0,0x00,0x00,0x00,0x3F,0xF7,0xFC,0x00,0x00,0x00,
0x0F,0xFD,0xFF,0x00,0x00,0x00,0x03,0xFF,0x7F,0xC0,
0x00,0x00,0x00,0xFF,0x7F,0x80,0x00,0x00,0x03,0xFF,
0x2F,0xF0,0x00,0x00,0x00,0xFF,0x1F,0xE0,0x00,0x00,
0x03,0xFE,0x3F,0xE0,0x00,0x00,0x07,0xFC,0x3F,0xC0,
0x00,0x00,0x1F,0xF0,0x7F,0xC0,0x00,0x00,0x3F,0xE0,
0x7F,0xC0,0x00,0x00,0xFF,0x80,0xFF,0xC0,0x00,0x03,
0xFF,0x00,0xFF,0xE0,0x00,0x1F,0xFC,0x01,0xFF,0xF8,
0x01,0xFF,0xF0,0x01,0xFF,0xFF,0xFF,0xFF,0xE0,0x01,
0xFF,0xFF,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xFF,0xFC,
0x00,0x00,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0xFF,0xFF,
0xFF,0x80,0x00,0x00,0x3F,0xFF,0xFC,0x00,0x00,0x00,
0x07,0xFF,0x80,0x00,0x00,0x0D,0xDE,0x00,0x03,0x77,
0xF8,0x00,0x00,0x00,0x00,0x0F,0xF8,0xFF,0x80,0x00,
0x00,0x00,0x03,0xFE,0x7F,0x80,0x00,0x00,0x00,0x03,
0xFC,0x7F,0xC0,0x00,0x00,0x00,0x07,0xFC,0x3F,0xC0,
0x00,0x00,0x00,0x07,0xFC,0x3F,0xC0,0x00,0x00,0x00,
0x07,0xF8,0x3F,0xE0,0x00,0x00,0x00,0x0F,0xF8,0x1F,
0xE0,0x00,0x00,0x00,0x0F,0xF0,0x1F,0xF0,0x00,0x00,
0x00,0x1F,0xF0,0x0F,0xF0,0x00,0x00,0x00,0x1F,0xF0,
0x0F,0xF0,0x00,0x00,0x00,0x1F,0xE0,0x0F,0xF8,0x00,
0x00,0x00,0x3F,0xE0,0x07,0xF8,0x00,0x00,0x00,0x3F,
0xC0,0x07,0xF8,0x00,0x00,0x00,0x7F,0xC0,0x03,0xFC,
0x00,0x00,0x00,0x7F,0xC0,0x03,0xFC,0x00,0x00,0x00,
0x7F,0x80,0x01,0xFE,0x00,0x00,0x00,0xFF,0x81,0x00,
0x3F,0xC0,0x00,0x00,0x1F,0xE0,0x00,0x1F,0xE0,0x00,
0x00,0x3F,0xE0,0x00,0x1F,0xE0,0x00,0x00,0x3F,0xC0,
0x00,0x0F,0xF0,0x00,0x00,0x7F,0xC0,0x20,0x01,0xFE,
0x00,0x00,0x0F,0xF0,0x00,0x00,0xFF,0x00,0x00,0x1F,
0xF0,0x00,0x00,0xFF,0x00,0x00,0x1F,0xE0,0x00,0x00,
0x7F,0x00,0x00,0x1F,0xE0,0x04,0x00,0x0F,0xF0,0x00,
0x07,0xF8,0x00,0x00,0x07,0xF8,0x00,0x0F,0xF8,0x00,
0x00,0x07,0xF8,0x00,0x0F,0xF0,0x00,0x00,0x03,0xF8,
0x00,0x0F,0xF0,0x00,0x00,0x03,0xFC,0x00,0x1F,0xF0,
0x00,0x80,0x00,0x3F,0x80,0x03,0xFC,0x00,0x00,0x00,
0x3F,0xC0,0x07,0xF8,0x00,0x00,0x00,0x1F,0xC0,0x07,
0xF8,0x00,0x00,0x00,0x1F,0xE0,0x0F,0xF8,0x00,0x10,
0x00,0x01,0xFC,0x01,0xFE,0x00,0x00,0x00,0x01,0xFE,
0x03,0xFC,0x00,0x00,0x00,0x00,0xFE,0x03,0xFC,0x00,
0x00,0x00,0x00,0xFE,0x07,0xFC,0x00,0x02,0x00,0x00,
0x0F,0xE0,0xFF,0x00,0x00,0x00,0x00,0x0F,0xF1,0xFE,
0x00,0x00,0x40,0x00,0x00,0xFE,0x3F,0xC0,0x00,0x08,
0x00,0x00,0x0F,0xEF,0xF0,0x00,0x00,0x00,0x00,0x0F,
0xEF,0xE0,0x00,0x01,0x00,0x00,0x00,0xFF,0xFC,0x00,
0x00,0x20,0x00,0x00,0x0F,0xFF,0x00,0x00,0x04,0x80,
0x00,0x00,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x7F,
0x80,0x00,0x00,0x14,0x5E,0x04,0x05,0x37,0xF8,0x00,
0x00,0x00,0xFF,0xE0,0x00,0x00,0x03,0xFD,0xFF,0x00,
0x00,0x00,0x3F,0xF8,0x00,0x00,0x01,0xFF,0x3F,0xC0,
0x00,0x00,0x0F,0xFE,0x00,0x00,0x00,0x7F,0xA1,0xFE,
0x00,0x00,0x00,0xFF,0xF8,0x00,0x00,0x03,0xFC,0x7F,
0xC0,0x00,0x00,0x3F,0xFE,0x00,0x00,0x01,0xFF,0x0F,
0xF0,0x00,0x00,0x1F,0xFF,0x80,0x00,0x00,0x7F,0x90,
0x7F,0x80,0x00,0x00,0xFE,0xFE,0x00,0x00,0x03,0xFC,
0x0F,0xF0,0x00,0x00,0x3F,0xBF,0x80,0x00,0x01,0xFF,
0x03,0xFC,0x00,0x00,0x1F,0xEF,0xF0,0x00,0x00,0x7F,
0x88,0x1F,0xE0,0x00,0x00,0xFE,0x3F,0x80,0x00,0x03,
0xFC,0x03,0xF8,0x00,0x00,0x7F,0x8F,0xE0,0x00,0x00,
0xFF,0x12,0x1F,0xE0,0x00,0x03,0xF8,0x3F,0x80,0x00,
0x0F,0xF0,0x03,0xF8,0x00,0x01,0xFE,0x0F,0xF0,0x00,
0x03,0xFC,0x20,0x1F,0xE0,0x00,0x0F,0xE0,0x3F,0x80,
0x00,0x3F,0xC0,0x03,0xF8,0x00,0x07,0xF8,0x0F,0xE0,
0x00,0x0F,0xF0,0x00,0xFE,0x00,0x01,0xFC,0x01,0xFC,
0x00,0x03,0xFC,0x10,0x07,0xF8,0x00,0x0F,0xE0,0x0F,
0xE0,0x00,0x3F,0xC0,0x00,0xFE,0x00,0x07,0xF8,0x03,
0xFC,0x00,0x0F,0xF0,0x00,0x3F,0x80,0x01,0xFC,0x00,
0x7F,0x00,0x03,0xFC,0x00,0x0F,0xF0,0x00,0x7F,0x00,
0x1F,0xC0,0x01,0xFE,0x00,0x03,0xFC,0x00,0x3F,0xC0,
0x07,0xF8,0x00,0x7F,0x80,0x80,0x0F,0xE0,0x01,0xFC,
0x00,0x1F,0xC0,0x03,0xFC,0x00,0x03,0xFC,0x00,0x7F,
0x00,0x07,0xF0,0x01,0xFE,0x00,0x00,0x7F,0x00,0x3F,
0xC0,0x00,0xFE,0x00,0x7F,0x80,0x00,0x1F,0xC0,0x0F,
0xE0,0x00,0x3F,0x80,0x1F,0xE0,0x00,0x07,0xF0,0x03,
0xF8,0x00,0x0F,0xF0,0x07,0xF8,0x00,0x01,0xFC,0x01,
0xFE,0x00,0x03,0xFC,0x01,0xFC,0x00,0x00,0x3F,0x80,
0x7F,0x00,0x00,0x7F,0x00,0xFF,0x00,0x00,0x0F,0xE0,
0x1F,0xC0,0x00,0x1F,0xE0,0x3F,0xC0,0x00,0x03,0xF8,
0x07,0xF0,0x00,0x07,0xF8,0x0F,0xE0,0x00,0x00,0xFE,
0x03,0xF8,0x00,0x00,0xFE,0x03,0xF8,0x00,0x00,0x1F,
0xC0,0xFE,0x00,0x00,0x3F,0x81,0xFE,0x00,0x00,0x07,
0xF0,0x3F,0x80,0x00,0x0F,0xF0,0x7F,0x80,0x00,0x01,
0xFC,0x1F,0xE0,0x00,0x03,0xFC,0x1F,0xC0,0x00,0x00,
0x3F,0x07,0xF0,0x00,0x00,0x7F,0x07,0xF0,0x01,0x00,
0x01,0xFC,0x3F,0x80,0x00,0x03,0xFC,0x7F,0x80,0x00,
0x00,0x7F,0x1F,0xC0,0x00,0x00,0x7F,0x1F,0xC0,0x00,
0x00,0x0F,0xC7,0xF0,0x00,0x00,0x1F,0xC7,0xF0,0x00,
0x00,0x03,0xF1,0xFC,0x00,0x00,0x07,0xFB,0xFC,0x00,
0x00,0x00,0xFE,0xFF,0x00,0x00,0x01,0xFE,0xFF,0x00,
0x00,0x00,0x3F,0xBF,0x80,0x00,0x00,0x3F,0xBF,0x80,
0x02,0x00,0x00,0xFD,0xFC,0x00,0x00,0x01,0xFD,0xFC,
0x00,0x00,0x00,0x3F,0xFE,0x00,0x00,0x00,0x3F,0xFF,
0x00,0x04,0x80,0x00,0xFF,0xF0,0x00,0x00,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x3F,0xF8,0x00,0x00,0x00,0x3F,
0xFC,0x00,0x08,0x00,0x00,0xFF,0xC0,0x00,0x00,0x01,
0xFF,0xC0,0x00,0x00,0x00,0x3F,0xE0,0x00,0x00,0x00,
0x3F,0xF0,0x00,0x00,0x0D,0xDE,0x00,0x03,0x80,0x7F,
0xE0,0x00,0x00,0x03,0xFF,0x00,0x3F,0xF0,0x00,0x00,
0x07,0xFE,0x00,0x1F,0xF0,0x00,0x00,0x07,0xFC,0x00,
0x1F,0xF8,0x00,0x00,0x0F,0xFC,0x00,0x0F,0xFC,0x00,
0x00,0x1F,0xF8,0x00,0x07,0xFC,0x00,0x00,0x3F,0xF0,
0x00,0x07,0xFE,0x00,0x00,0x3F,0xF0,0x00,0x03,0xFF,
0x00,0x00,0x7F,0xE0,0x00,0x01,0xFF,0x00,0x00,0xFF,
0xC0,0x00,0x00,0xFF,0x80,0x00,0xFF,0x80,0x00,0x00,
0xFF,0xC0,0x01,0xFF,0x80,0x00,0x00,0x7F,0xE0,0x03,
0xFF,0x00,0x00,0x00,0x3F,0xE0,0x03,0xFE,0x00,0x00,
0x00,0x3F,0xF0,0x07,0xFE,0x00,0x00,0x00,0x1F,0xF8,
0x0F,0xFC,0x00,0x00,0x00,0x0F,0xF8,0x0F,0xF8,0x00,
0x00,0x00,0x0F,0xFC,0x1F,0xF8,0x00,0x00,0x00,0x07,
0xFE,0x3F,0xF0,0x00,0x00,0x00,0x03,0xFE,0x3F,0xE0,
0x00,0x00,0x00,0x03,0xFF,0x7F,0xE0,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0xFF,0xFF,
0x80,0x00,0x00,0x00,0x00,0x7F,0xFF,0x80,0x00,0x00,
0x00,0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x3F,
0xFE,0x00,0x00,0x0A,0x00,0x00,0x03,0xFF,0x80,0x00,
0x00,0x00,0x00,0x07,0xFF,0xC0,0x00,0x01,0x00,0x00,
0x01,0xFF,0xFC,0x00,0x00,0x00,0x00,0x03,0xFF,0xFE,
0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0x00,0x00,0x00,
0x00,0x07,0xFD,0xFF,0x00,0x00,0x00,0x00,0x0F,0xFD,
0xFF,0x80,0x00,0x00,0x00,0x1F,0xF8,0xFF,0xC0,0x00,
0x00,0x00,0x3F,0xF0,0x7F,0xC0,0x00,0x00,0x00,0x3F,
0xF0,0x3F,0xE0,0x00,0x00,0x00,0x7F,0xE0,0x3F,0xF0,
0x00,0x00,0x00,0xFF,0xC0,0x1F,0xF8,0x00,0x00,0x00,
0xFF,0x80,0x0F,0xF8,0x00,0x00,0x01,0xFF,0x80,0x0F,
0xFC,0x00,0x00,0x03,0xFF,0x00,0x07,0xFE,0x00,0x00,
0x03,0xFE,0x00,0x03,0xFE,0x00,0x00,0x07,0xFE,0x00,
0x03,0xFF,0x00,0x00,0x0F,0xFC,0x00,0x01,0xFF,0x80,
0x00,0x0F,0xF8,0x00,0x00,0xFF,0x80,0x00,0x1F,0xF8,
0x00,0x00,0xFF,0xC0,0x00,0x3F,0xF0,0x00,0x00,0x7F,
0xE0,0x00,0x3F,0xE0,0x00,0x00,0x3F,0xE0,0x00,0x7F,
0xE0,0x00,0x00,0x1F,0xF0,0x00,0xFF,0xC0,0x00,0x00,
0x1F,0xF8,0x01,0xFF,0x80,0x00,0x00,0x0F,0xFC,0x01,
0xFF,0x80,0x00,0x00,0x07,0xFC,0x03,0xFF,0x00,0x00,
0x00,0x07,0xFE,0x07,0xFE,0x00,0x00,0x00,0x03,0xFF,
0x07,0xFC,0x00,0x00,0x00,0x01,0xFF,0x0F,0xFC,0x00,
0x00,0x00,0x01,0xFF,0x9F,0xF8,0x00,0x00,0x00,0x00,
0xFF,0xC0,0x0D,0x9E,0x00,0x03,0x67,0xFE,0x00,0x00,
0x00,0x00,0x7F,0xE7,0xFC,0x00,0x00,0x00,0x00,0xFF,
0x87,0xFC,0x00,0x00,0x00,0x03,0xFE,0x0F,0xFC,0x00,
0x00,0x00,0x0F,0xFC,0x0F,0xF8,0x00,0x00,0x00,0x1F,
0xF0,0x0F,0xF8,0x00,0x00,0x00,0x7F,0xC0,0x1F,0xF8,
0x00,0x00,0x00,0xFF,0x80,0x1F,0xF0,0x00,0x00,0x03,
0xFE,0x00,0x1F,0xF0,0x00,0x00,0x0F,0xF8,0x00,0x3F,
0xF0,0x00,0x00,0x1F,0xF0,0x00,0x3F,0xE0,0x00,0x00,
0x7F,0xC0,0x00,0x3F,0xE0,0x00,0x01,0xFF,0x00,0x00,
0x7F,0xE0,0x00,0x03,0xFE,0x00,0x00,0x7F,0xC0,0x00,
0x0F,0xF8,0x00,0x00,0x7F,0xC0,0x00,0x1F,0xE0,0x00,
0x00,0xFF,0xC0,0x00,0x7F,0xC0,0x00,0x00,0xFF,0x80,
0x01,0xFF,0x00,0x00,0x00,0xFF,0x80,0x03,0xFC,0x00,
0x00,0x01,0xFF,0x80,0x0F,0xF8,0x00,0x00,0x01,0xFF,
0x00,0x3F,0xE0,0x00,0x00,0x01,0xFF,0x00,0x7F,0x80,
0x00,0x00,0x03,0xFF,0x01,0xFF,0x00,0x00,0x00,0x03,
0xFE,0x03,0xFC,0x00,0x00,0x00,0x03,0xFE,0x0F,0xF0,
0x00,0x00,0x00,0x07,0xFE,0x3F,0xE0,0x00,0x00,0x00,
0x07,0xFC,0x7F,0x80,0x00,0x00,0x00,0x07,0xFD,0xFE,
0x00,0x00,0x00,0x00,0x0F,0xFF,0xFC,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xF0,0x00,0x01,0x00,0x00,0x01,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x01,0xFF,0xE0,0x00,0x00,
0x80,0x00,0x00,0x3F,0xF0,0x00,0x00,0x34,0x00,0x00,
0x07,0xF8,0x00,0x00,0x0D,0x00,0x00,0x01,0xFE,0x00,
0x00,0x03,0x40,0x00,0x00,0x7F,0x80,0x00,0x00,0xB0,
0x00,0x00,0x1F,0xE0,0x00,0x00,0x00,0x0B,0xDE,0x08,
0x03,0x3D,0x0F,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x0F,0xFC,0x00,0x00,0x00,0x00,0x1F,0xF8,
0x00,0x00,0x00,0x00,0x3F,0xF0,0x00,0x00,0x00,0x00,
0x7F,0xE1,0x00,0x00,0x00,0x00,0x1F,0xF8,0x00,0x00,
0x00,0x00,0x3F,0xF0,0x00,0x00,0x00,0x00,0x7F,0xE0,
0x00,0x00,0x00,0x00,0xFF,0xC0,0x00,0x00,0x00,0x01,
0xFF,0xC0,0x00,0x00,0x00,0x01,0xFF,0x80,0x00,0x00,
0x00,0x03,0xFF,0x00,0x00,0x00,0x00,0x07,0xFE,0x00,
0x20,0x00,0x00,0x01,0xFF,0x80,0x00,0x00,0x00,0x03,
0xFF,0x00,0x00,0x00,0x00,0x07,0xFE,0x00,0x00,0x00,
0x00,0x0F,0xFC,0x00,0x04,0x00,0x00,0x03,0xFF,0x00,
0x00,0x00,0x00,0x07,0xFE,0x00,0x00,0x00,0x00,0x0F,
0xFC,0x00,0x00,0x00,0x00,0x1F,0xF8,0x00,0x00,0x00,
0x00,0x3F,0xF8,0x00,0x00,0x00,0x00,0x3F,0xF0,0x00,
0x00,0x00,0x00,0x7F,0xE0,0x00,0x00,0x00,0x00,0xFF,
0xC0,0x00,0x00,0x80,0x00,0x3F,0xF0,0x00,0x00,0x00,
0x00,0x7F,0xE0,0x00,0x00,0x00,0x00,0xFF,0xC0,0x00,
0x00,0x00,0x01,0xFF,0x80,0x00,0x00,0x10,0x00,0x7F,
0xE0,0x00,0x00,0x00,0x00,0xFF,0xC0,0x00,0x00,0x00,
0x01,0xFF,0x80,0x00,0x00,0x00,0x03,0xFF,0x00,0x00,
0x00,0x02,0x00,0xFF,0xC0,0x00,0x00,0x00,0x01,0xFF,
0x80,0x00,0x00,0x00,0x03,0xFF,0x00,0x00,0x00,0x00,
0x40,0xFF,0xC0,0x00,0x00,0x00,0x01,0xFF,0x80,0x00,
0x00,0x00,0x03,0xFF,0x00,0x00,0x00,0x00,0x07,0xFE,
0x00,0x00,0x00,0x00,0x0D,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFE,0x03,0xE6,0x97,0x79,0x7D,0xFF,0xFF,0xBF,0xC0,
0x37,0xF8,0x06,0xFF,0x00,0xDF,0xE0,0x1B,0xFC,0x03,
0x7F,0x80,0x6F,0xF0,0x0D,0xFE,0x01,0xBF,0xC0,0x37,
0xFF,0xF8,0x05,0xDE,0x04,0x01,0x78,0xFC,0x00,0x01,
0x2F,0xC0,0x00,0x0F,0xE0,0x00,0x24,0xFC,0x00,0x04,
0x8F,0xC0,0x00,0x0F,0xE0,0x00,0x90,0xFC,0x00,0x00,
0xFE,0x00,0x10,0x0F,0xC0,0x00,0x0F,0xE0,0x02,0x40,
0xFC,0x00,0x00,0xFE,0x00,0x40,0x0F,0xC0,0x00,0x0F,
0xE0,0x09,0x00,0xFC,0x00,0x00,0xFE,0x01,0x20,0x0F,
0xC0,0x24,0x00,0xFC,0x00,0x00,0xFE,0x04,0x80,0x0F,
0xC0,0x90,0x00,0xFC,0x00,0x00,0xFE,0x12,0x00,0x0F,
0xC2,0x40,0x00,0xFC,0x00,0x00,0xFE,0x48,0x00,0x0F,
0xC9,0x00,0x00,0xFC,0x00,0x00,0xFE,0x00,0x00,0x7E,
0x03,0xE6,0x8F,0x79,0x7D,0xFF,0xFF,0xA0,0x1F,0xF4,
0x03,0xFE,0x80,0x7F,0xD0,0x0F,0xFA,0x01,0xFF,0x40,
0x3F,0xE8,0x07,0xFD,0x00,0xFF,0xA0,0x1F,0xF7,0xFF,
0xF8,0x08,0x90,0x08,0xE2,0x60,0x00,0x1F,0x80,0x01,
0x00,0x00,0xFF,0x00,0x04,0x80,0x07,0xFE,0x00,0x10,
0x00,0x3F,0xFC,0x00,0x40,0x01,0xF9,0xF8,0x00,0x00,
0x7F,0x3F,0x80,0x20,0x01,0xF8,0x7E,0x00,0x80,0x0F,
0xC0,0xFC,0x00,0x03,0xF8,0x1F,0xC0,0x00,0x7E,0x01,
0xF8,0x00,0x1F,0xC0,0x3F,0x80,0x03,0xF0,0x03,0xF0,
0x20,0x1F,0xC0,0x0F,0xE0,0x03,0xF0,0x00,0xFC,0x00,
0xFE,0x00,0x1F,0xC0,0x1F,0x80,0x01,0xF8,0x40,0xFE,
0x00,0x07,0xF1,0x07,0xF0,0x00,0x0F,0xE0,0xFC,0x00,
0x00,0xFC,0x87,0xF0,0x00,0x03,0xF9,0xFC,0x00,0x00,
0x3F,0x80,0x0C,0x03,0xFF,0x7A,0xED,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0x03,0x85,0x91,0x89,0xC7,0xFE,0x07,
0xFE,0x07,0xFC,0x07,0xF8,0x07,0xF9,0x00,0xFE,0x00,
0xFE,0x00,0xFC,0x00,0xF8,0x00,0xF8,0x0A,0x17,0x0F,
0xFA,0xE0,0x00,0x0F,0xFF,0x00,0x00,0x00,0x7F,0xFF,
0xF8,0x00,0x00,0xFF,0xFF,0xFF,0x00,0x01,0xFF,0xFF,
0xFF,0xC0,0x03,0xFF,0xFF,0xFF,0xF0,0x03,0xFF,0xFF,
0xFF,0xFC,0x01,0xFF,0xFF,0xFF,0xFF,0x01,0xFF,0xE0,
0x07,0xFF,0x80,0xFF,0x80,0x00,0xFF,0xC0,0xFF,0x80,
0x00,0x1F,0xF0,0x7F,0x80,0x00,0x07,0xF8,0x7F,0x80,
0x00,0x03,0xFC,0x3F,0xC0,0x00,0x00,0xFE,0x03,0xC0,
0x00,0x00,0x7F,0x24,0x00,0x00,0x00,0x07,0xF0,0x00,
0x00,0x00,0x0F,0xF8,0x00,0x00,0x00,0x7F,0xFC,0x00,
0x00,0x1F,0xFF,0xFE,0x00,0x03,0xFF,0xFF,0xFF,0x00,
0x1F,0xFF,0xFF,0xFF,0x80,0x3F,0xFF,0xFF,0xFF,0xC0,
0x3F,0xFF,0xFF,0xFF,0xE0,0x3F,0xFF,0xFF,0xE7,0xF0,
0x3F,0xFF,0xFF,0x03,0xF8,0x3F,0xFF,0xC0,0x01,0xFC,
0x3F,0xF8,0x00,0x00,0xFE,0x1F,0xF0,0x00,0x00,0x7F,
0x0F,0xE0,0x00,0x00,0x3F,0x8F,0xF0,0x00,0x00,0x3F,
0xC8,0xFE,0x00,0x00,0x03,0xFC,0x7F,0x00,0x00,0x03,
0xFE,0x3F,0x80,0x00,0x03,0xFF,0x1F,0xE0,0x00,0x03,
0xFF,0x8F,0xF0,0x00,0x03,0xFF,0xC3,0xFE,0x00,0x07,
0xFF,0xE1,0xFF,0xC0,0x1F,0xFF,0xF0,0xFF,0xFF,0xFF,
0xFF,0xF8,0x3F,0xFF,0xFF,0xFD,0xFE,0x0F,0xFF,0xFF,
0xFC,0xFF,0x03,0xFF,0xFF,0xFC,0x3F,0x80,0xFF,0xFF,
0xF8,0x1F,0xC0,0x1F,0xFF,0xF0,0x07,0xF0,0x01,0xFF,
0x80,0x00,0x00,0x09,0x5E,0x9B,0xFA,0xED,0xFE,0x00,
0x00,0x00,0x06,0xFF,0x00,0x00,0x00,0x01,0xFC,0x00,
0x00,0x00,0x07,0xF0,0x0F,0xF0,0x00,0x1F,0xC0,0xFF,
0xF8,0x00,0x7F,0x0F,0xFF,0xF8,0x01,0xFC,0x7F,0xFF,
0xF0,0x07,0xF3,0xFF,0xFF,0xE0,0x1F,0xDF,0xFF,0xFF,
0xC0,0x7F,0xFF,0xFF,0xFF,0x81,0xFF,0xFE,0x07,0xFF,
0x07,0xFF,0xC0,0x07,0xFE,0x1F,0xFE,0x00,0x0F,0xF8,
0x7F,0xF0,0x00,0x1F,0xF1,0xFF,0x80,0x00,0x3F,0xC7,
0xFC,0x00,0x00,0x7F,0x1F,0xF0,0x00,0x01,0xFE,0x9F,
0xF0,0x00,0x00,0x7F,0x6F,0xF0,0x00,0x00,0x1F,0xEB,
0xF8,0x00,0x00,0x0F,0xEF,0xE0,0x00,0x00,0x7F,0xCF,
0xF8,0x00,0x00,0x3F,0x9F,0xF0,0x00,0x01,0xFE,0x7F,
0xC0,0x00,0x07,0xF1,0xFF,0x80,0x00,0x3F,0xC7,0xFF,
0x00,0x01,0xFE,0x1F,0xFE,0x00,0x0F,0xF8,0x7F,0xFC,
0x00,0x7F,0xC1,0xFF,0xFC,0x0F,0xFF,0x07,0xF7,0xFF,
0xFF,0xF8,0x1F,0xDF,0xFF,0xFF,0xC0,0x7F,0x3F,0xFF,
0xFE,0x01,0xFC,0x7F,0xFF,0xF0,0x07,0xF0,0xFF,0xFF,
0x00,0x1F,0xC0,0xFF,0xF8,0x00,0x00,0x00,0xFF,0x00,
0x00,0x09,0x97,0x0F,0xFA,0xA0,0x00,0x0F,0xF8,0x00,
0x00,0x00,0xFF,0xFF,0x00,0x00,0x07,0xFF,0xFF,0x80,
0x00,0x3F,0xFF,0xFF,0x80,0x00,0xFF,0xFF,0xFF,0x80,
0x03,0xFF,0xFF,0xFF,0x80,0x0F,0xFF,0xFF,0xFF,0x80,
0x3F,0xFC,0x07,0xFF,0x80,0xFF,0xE0,0x03,0xFF,0x01,
0xFF,0x00,0x01,0xFF,0x07,0xFC,0x00,0x01,0xFE,0x0F,
0xF0,0x00,0x01,0xFC,0x1F,0xC0,0x00,0x03,0xFC,0x7F,
0x80,0x00,0x07,0xF8,0xFE,0x00,0x00,0x07,0x84,0x3F,
0x80,0x00,0x00,0x01,0xBF,0xC0,0x00,0x00,0x00,0x5F,
0xF0,0x00,0x00,0x00,0x07,0xF0,0x00,0x00,0x1E,0x0F,
0xE0,0x00,0x00,0x3F,0x9F,0xC0,0x00,0x00,0xFF,0x3F,
0xC0,0x00,0x01,0xFC,0x3F,0x80,0x00,0x03,0xF8,0x7F,
0x80,0x00,0x0F,0xF0,0xFF,0x80,0x00,0x3F,0xC0,0xFF,
0x80,0x00,0xFF,0x81,0xFF,0x80,0x03,0xFE,0x01,0xFF,
0xE0,0x3F,0xFC,0x01,0xFF,0xFF,0xFF,0xF0,0x01,0xFF,
0xFF,0xFF,0xC0,0x01,0xFF,0xFF,0xFF,0x00,0x01,0xFF,
0xFF,0xFC,0x00,0x00,0xFF,0xFF,0xE0,0x00,0x00,0x7F,
0xFF,0x80,0x00,0x00,0x1F,0xF0,0x00,0x00,0x09,0x5E,
0x8F,0xFA,0xED,0x00,0x00,0x00,0x03,0xFE,0x80,0x00,
0x00,0x01,0xFC,0x00,0x00,0x00,0x07,0xF0,0x00,0x1F,
0xE0,0x1F,0xC0,0x03,0xFF,0xE0,0x7F,0x00,0x3F,0xFF,
0xE1,0xFC,0x01,0xFF,0xFF,0xC7,0xF0,0x1F,0xFF,0xFF,
0x9F,0xC0,0x7F,0xFF,0xFF,0x7F,0x03,0xFF,0xFF,0xFF,
0xFC,0x1F,0xFC,0x0F,0xFF,0xF0,0xFF,0xC0,0x07,0xFF,
0xC3,0xFE,0x00,0x0F,0xFF,0x1F,0xF0,0x00,0x1F,0xFC,
0x7F,0x80,0x00,0x3F,0xF1,0xFC,0x00,0x00,0x7F,0xCF,
0xF0,0x00,0x01,0xFF,0x97,0xF0,0x00,0x00,0x7F,0xBF,
0x80,0x00,0x01,0xFF,0xBF,0xC0,0x00,0x00,0x7F,0xAF,
0xE0,0x00,0x00,0x3F,0xCB,0xF8,0x00,0x00,0x3F,0xCF,
0xF0,0x00,0x01,0xFF,0x1F,0xC0,0x00,0x07,0xFC,0x7F,
0x80,0x00,0x3F,0xF0,0xFF,0x00,0x01,0xFF,0xC3,0xFE,
0x00,0x0F,0xFF,0x07,0xFC,0x00,0x7F,0xFC,0x1F,0xFC,
0x07,0xFF,0xF0,0x3F,0xFF,0xFF,0xDF,0xC0,0x7F,0xFF,
0xFF,0x7F,0x00,0xFF,0xFF,0xF9,0xFC,0x01,0xFF,0xFF,
0xC7,0xF0,0x03,0xFF,0xFE,0x1F,0xC0,0x03,0xFF,0xE0,
0x7F,0x00,0x01,0xFE,0x00,0x00,0x0A,0x17,0x0F,0xFA,
0xE0,0x00,0x0F,0xFC,0x00,0x00,0x00,0x3F,0xFF,0xC0,
0x00,0x00,0x7F,0xFF,0xF8,0x00,0x00,0x7F,0xFF,0xFF,
0x00,0x00,0xFF,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0xFF,
0xF0,0x00,0xFF,0xFF,0xFF,0xFC,0x00,0xFF,0xF0,0x0F,
0xFF,0x00,0x7F,0xC0,0x00,0xFF,0x80,0x7F,0xC0,0x00,
0x1F,0xE0,0x3F,0xC0,0x00,0x07,0xF0,0x3F,0xC0,0x00,
0x01,0xFC,0x1F,0xC0,0x00,0x00,0xFE,0x43,0xF8,0x00,
0x00,0x07,0xF4,0x3F,0x00,0x00,0x00,0x3F,0x3F,0x80,
0x00,0x00,0x1F,0xF7,0xFF,0xFF,0xFF,0xFF,0xFE,0xBF,
0x80,0x00,0x00,0x00,0x25,0xFC,0x00,0x00,0x00,0x00,
0xFF,0x00,0x00,0x00,0xE0,0x3F,0xC0,0x00,0x00,0xFF,
0x1F,0xE0,0x00,0x00,0xFF,0x0F,0xF8,0x00,0x00,0xFF,
0x83,0xFF,0x00,0x00,0xFF,0x80,0xFF,0xC0,0x00,0xFF,
0xC0,0x7F,0xFC,0x03,0xFF,0xC0,0x1F,0xFF,0xFF,0xFF,
0xC0,0x07,0xFF,0xFF,0xFF,0xE0,0x01,0xFF,0xFF,0xFF,
0xE0,0x00,0x7F,0xFF,0xFF,0xC0,0x00,0x0F,0xFF,0xFF,
0xC0,0x00,0x01,0xFF,0xFF,0x80,0x00,0x00,0x0F,0xFC,
0x00,0x00,0x06,0x1E,0x88,0x01,0x80,0x00,0x3F,0xF0,
0x00,0x7F,0xFC,0x00,0xFF,0xFF,0x00,0x1F,0xFF,0xF0,
0x03,0xFF,0xFE,0x03,0xFF,0x00,0x80,0x3F,0xC0,0x0D,
0x03,0xF8,0x00,0xDF,0xFF,0xFF,0xCD,0x03,0xF8,0x00,
0xD0,0x3F,0x80,0x0D,0x03,0xF8,0x00,0xD0,0x3F,0x80,
0x0D,0x03,0xF8,0x00,0x80,0x3F,0x80,0x00,0x09,0x5F,
0x8F,0x72,0xE0,0x00,0x1F,0xE0,0x00,0x00,0x03,0xFF,
0xF0,0x7F,0x00,0x3F,0xFF,0xE1,0xFC,0x01,0xFF,0xFF,
0xE7,0xF0,0x1F,0xFF,0xFF,0xDF,0xE0,0x1F,0xFF,0xFF,
0xFF,0xE0,0xFF,0xE0,0x3F,0xFF,0x87,0xFE,0x00,0x3F,
0xFE,0x1F,0xF0,0x00,0x7F,0xF8,0xFF,0x80,0x00,0xFF,
0xE3,0xFC,0x00,0x01,0xFF,0x8F,0xE0,0x00,0x03,0xFE,
0x7F,0x80,0x00,0x0F,0xFC,0xBF,0x80,0x00,0x03,0xFF,
0x7F,0x80,0x00,0x00,0xFF,0x5F,0xC0,0x00,0x00,0x7F,
0x97,0xF0,0x00,0x00,0x7F,0x9F,0xE0,0x00,0x03,0xFE,
0x3F,0x80,0x00,0x0F,0xF8,0xFF,0x00,0x00,0x7F,0xE3,
0xFC,0x00,0x03,0xFF,0x87,0xF8,0x00,0x1F,0xFE,0x1F,
0xF8,0x00,0xFF,0xF8,0x3F,0xF8,0x0F,0xFF,0xE0,0x7F,
0xFF,0xFF,0xFF,0xC0,0x1F,0xFF,0xFF,0xFF,0xC0,0x1F,
0xFF,0xFE,0x7F,0x00,0x3F,0xFF,0xF1,0xFC,0x00,0x3F,
0xFF,0x07,0xF0,0x00,0x1F,0xE0,0x1F,0xE4,0x00,0x00,
0x00,0x0F,0xE0,0x00,0x00,0x00,0x3F,0x1E,0x00,0x00,
0x01,0xFC,0x7F,0x00,0x00,0x07,0xF1,0xFC,0x00,0x00,
0x3F,0xC7,0xF8,0x00,0x00,0xFE,0x1F,0xF0,0x00,0x07,
0xF8,0x3F,0xE0,0x00,0x7F,0xE0,0xFF,0xE0,0x0F,0xFF,
0x01,0xFF,0xFF,0xFF,0xF8,0x07,0xFF,0xFF,0xFF,0xC0,
0x0F,0xFF,0xFF,0xFE,0x00,0x1F,0xFF,0xFF,0xF0,0x00,
0x1F,0xFF,0xFF,0x80,0x00,0x1F,0xFF,0xF8,0x00,0x00,
0x0F,0xFE,0x00,0x00,0x08,0x9E,0x18,0x02,0xED,0xFE,
0x00,0x00,0x00,0x37,0xF8,0x00,0x00,0x00,0x7F,0x00,
0x00,0x00,0x0F,0xE0,0x0F,0xF0,0x01,0xFC,0x0F,0xFF,
0xC0,0x3F,0x87,0xFF,0xFC,0x07,0xF1,0xFF,0xFF,0xE0,
0xFE,0x7F,0xFF,0xFE,0x1F,0xDF,0xFF,0xFF,0xE3,0xFF,
0xFF,0xFF,0xFC,0x7F,0xFF,0x03,0xFF,0xCF,0xFF,0x80,
0x1F,0xF9,0xFF,0xC0,0x00,0xFF,0x3F,0xF0,0x00,0x1F,
0xE8,0xFF,0x80,0x00,0x3F,0xE7,0xFC,0x00,0x00,0x7F,
0xDF,0xE0,0x00,0x01,0xFF,0x7F,0x80,0x00,0x07,0xFD,
0xFE,0x00,0x00,0x1F,0xF7,0xF8,0x00,0x00,0x7F,0x7F,
0x00,0x00,0x0F,0xE0,0x01,0xDE,0x18,0x01,0x2D,0xFF,
0xA0,0x20,0x06,0xFF,0xDF,0xFB,0xFF,0x7F,0xEF,0xFD,
0xFF,0x1F,0xC0,0x04,0x67,0x73,0x71,0x3D,0x00,0x3F,
0xE8,0x00,0x02,0x00,0x00,0x1A,0x00,0x7F,0xD0,0x03,
0xFE,0x80,0x1F,0xF4,0x00,0xFF,0xA0,0x07,0xFD,0x00,
0x3F,0xE8,0x01,0xFE,0x40,0x0F,0xE0,0x07,0xF8,0x01,
0xFC,0x00,0xFF,0x43,0xFF,0xF8,0xFF,0xFC,0x87,0xFF,
0xC3,0xFF,0xC0,0x3F,0xC0,0x00,0x09,0x1E,0x18,0x02,
0xBD,0xFE,0x00,0x00,0x00,0x0D,0xFE,0x00,0x00,0x00,
0x08,0xFE,0x00,0x00,0x00,0x07,0xF0,0x00,0x03,0xFE,
0x3F,0x80,0x00,0x3F,0xE1,0xFC,0x00,0x03,0xFE,0x0F,
0xE0,0x00,0x7F,0xE0,0x7F,0x00,0x07,0xFE,0x03,0xF8,
0x00,0x7F,0xE0,0x1F,0xC0,0x07,0xFE,0x00,0xFE,0x00,
0x7F,0xE0,0x07,0xF0,0x07,0xFE,0x00,0x3F,0x80,0x7F,
0xE0,0x01,0xFC,0x07,0xFE,0x00,0x0F,0xE0,0x7F,0xE0,
0x00,0x7F,0x07,0xFE,0x00,0x03,0xF8,0x7F,0xE0,0x00,
0x1F,0xC7,0xFE,0x00,0x00,0xFE,0x7F,0xE0,0x00,0x07,
0xF7,0xFE,0x00,0x00,0x3F,0xFF,0xF0,0x00,0x02,0x3F,
0xFF,0xF8,0x00,0x01,0xFF,0xFF,0xE0,0x00,0x0F,0xFF,
0xFF,0x80,0x00,0x7F,0xF3,0xFC,0x00,0x03,0xFF,0x0F,
0xF0,0x00,0x1F,0xF0,0x7F,0xC0,0x00,0xFF,0x01,0xFE,
0x00,0x07,0xF0,0x07,0xF8,0x00,0x3F,0x80,0x3F,0xE0,
0x01,0xFC,0x00,0xFF,0x00,0x0F,0xE0,0x03,0xFC,0x00,
0x7F,0x00,0x1F,0xF0,0x03,0xF8,0x00,0x7F,0x80,0x1F,
0xC0,0x01,0xFE,0x00,0xFE,0x00,0x07,0xF8,0x07,0xF0,
0x00,0x3F,0xE0,0x3F,0x80,0x00,0xFF,0x01,0xFC,0x00,
0x03,0xFC,0x0F,0xE0,0x00,0x1F,0xF0,0x7F,0x00,0x00,
0x7F,0x83,0xF8,0x00,0x01,0xFE,0x1F,0xC0,0x00,0x0F,
0xF8,0xFE,0x00,0x00,0x3F,0xC7,0xF0,0x00,0x00,0xFF,
0x3F,0x80,0x00,0x07,0xFC,0x01,0xDE,0x18,0x01,0x2D,
0xFF,0xBF,0xF7,0xFE,0xFF,0xDF,0xFB,0xFF,0x7F,0xEF,
0xFA,0xFE,0x0E,0xD6,0x98,0x04,0x70,0x00,0x07,0xF8,
0x00,0x01,0xFE,0x00,0x7F,0x03,0xFF,0xF0,0x00,0xFF,
0xFC,0x07,0xF0,0x7F,0xFF,0x80,0x3F,0xFF,0xE0,0x7F,
0x1F,0xFF,0xFC,0x07,0xFF,0xFF,0x07,0xF3,0xFF,0xFF,
0xE0,0xFF,0xFF,0xF8,0x7F,0x7F,0xFF,0xFF,0x1F,0xFF,
0xFF,0xC7,0xF7,0xFF,0xFF,0xF3,0xFF,0xFF,0xFC,0x7F,
0xFF,0x03,0xFF,0xFF,0x80,0xFF,0xE7,0xFF,0x80,0x0F,
0xFF,0xE0,0x03,0xFE,0x7F,0xF0,0x00,0x7F,0xFC,0x00,
0x1F,0xE7,0xFE,0x00,0x03,0xFF,0x80,0x00,0xFF,0x7F,
0xC0,0x00,0x3F,0xF0,0x00,0x0F,0xF7,0xFC,0x00,0x01,
0xFE,0x00,0x00,0x7F,0x8F,0xF0,0x00,0x03,0xFC,0x00,
0x00,0xFE,0xFF,0x00,0x00,0x3F,0x80,0x00,0x0F,0xFB,
0xFC,0x00,0x00,0x7F,0x00,0x00,0x1F,0xF7,0xF8,0x00,
0x00,0xFE,0x00,0x00,0x3F,0xEF,0xF0,0x00,0x01,0xFC,
0x00,0x00,0x7F,0xDF,0xE0,0x00,0x03,0xF8,0x00,0x00,
0xFE,0xFE,0x00,0x00,0x3F,0x80,0x00,0x0F,0xE0,0x08,
0x96,0x98,0x02,0xE0,0x00,0x07,0xF8,0x00,0xFE,0x07,
0xFF,0xE0,0x1F,0xC3,0xFF,0xFF,0x03,0xF8,0xFF,0xFF,
0xF0,0x7F,0x3F,0xFF,0xFF,0x0F,0xEF,0xFF,0xFF,0xF1,
0xFF,0xFF,0xFF,0xFE,0x3F,0xFF,0x81,0xFF,0xE7,0xFF,
0x80,0x0F,0xFC,0xFF,0xE0,0x00,0x7F,0x9F,0xF8,0x00,
0x0F,0xFC,0x7F,0xC0,0x00,0x1F,0xF3,0xFE,0x00,0x00,
0x3F,0xEF,0xF0,0x00,0x00,0xFF,0xBF,0xC0,0x00,0x03,
0xFE,0xFF,0x00,0x00,0x0F,0xFB,0xFC,0x00,0x00,0x3F,
0xBF,0x80,0x00,0x07,0xF0,0x0A,0x17,0x0F,0xFA,0xE0,
0x00,0x0F,0xFC,0x00,0x00,0x00,0x3F,0xFF,0xC0,0x00,
0x00,0x7F,0xFF,0xF8,0x00,0x00,0xFF,0xFF,0xFF,0x00,
0x00,0xFF,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0xFF,0xF0,
0x00,0xFF,0xFF,0xFF,0xFC,0x00,0xFF,0xF0,0x0F,0xFF,
0x00,0x7F,0xE0,0x01,0xFF,0x80,0x7F,0xC0,0x00,0x3F,
0xE0,0x7F,0xC0,0x00,0x0F,0xF9,0x07,0xF8,0x00,0x00,
0x7F,0x87,0xF8,0x00,0x00,0x1F,0xE9,0x7F,0x00,0x00,
0x00,0xFE,0x7F,0x80,0x00,0x00,0x7F,0xEF,0xF0,0x00,
0x00,0x03,0xFC,0xFF,0x00,0x00,0x00,0x3F,0xBF,0xC0,
0x00,0x00,0x3F,0xE1,0xFC,0x00,0x00,0x03,0xF8,0xFE,
0x00,0x00,0x03,0xFC,0x7F,0x80,0x00,0x01,0xFE,0x83,
0xFC,0x00,0x00,0x3F,0xC1,0xFF,0x00,0x00,0x3F,0xE0,
0x7F,0xC0,0x00,0x3F,0xE0,0x1F,0xF8,0x00,0x7F,0xF0,
0x0F,0xFF,0x00,0xFF,0xF0,0x03,0xFF,0xFF,0xFF,0xF0,
0x00,0xFF,0xFF,0xFF,0xF0,0x00,0x3F,0xFF,0xFF,0xF0,
0x00,0x0F,0xFF,0xFF,0xF0,0x00,0x01,0xFF,0xFF,0xE0,
0x00,0x00,0x3F,0xFF,0xC0,0x00,0x00,0x03,0xFF,0x00,
0x00,0x09,0x5F,0x1B,0x7A,0xE0,0x00,0x0F,0xF0,0x00,
0x1F,0xC0,0xFF,0xF8,0x00,0x7F,0x0F,0xFF,0xF8,0x01,
0xFC,0x7F,0xFF,0xF0,0x07,0xF3,0xFF,0xFF,0xF0,0x1F,
0xCF,0xFF,0xFF,0xE0,0x7F,0x7F,0xFF,0xFF,0x81,0xFF,
0xFE,0x07,0xFF,0x07,0xFF,0xE0,0x07,0xFE,0x1F,0xFE,
0x00,0x0F,0xF8,0x7F,0xF0,0x00,0x1F,0xF1,0xFF,0x80,
0x00,0x3F,0xC7,0xFE,0x00,0x00,0x7F,0x1F,0xF0,0x00,
0x01,0xFE,0x7F,0xC0,0x00,0x03,0xFA,0x3F,0xC0,0x00,
0x01,0xFC,0xFF,0x00,0x00,0x03,0xFE,0xFF,0x00,0x00,
0x01,0xFE,0x7F,0x80,0x00,0x00,0xFE,0xFE,0x00,0x00,
0x07,0xFC,0xFF,0x80,0x00,0x03,0xF9,0xFF,0x00,0x00,
0x1F,0xE7,0xFC,0x00,0x00,0x7F,0x1F,0xF8,0x00,0x03,
0xFC,0x7F,0xF0,0x00,0x1F,0xE1,0xFF,0xE0,0x00,0xFF,
0x87,0xFF,0xC0,0x07,0xFC,0x1F,0xFF,0xC0,0x7F,0xF0,
0x7F,0xFF,0xFF,0xFF,0x81,0xFD,0xFF,0xFF,0xFC,0x07,
0xF7,0xFF,0xFF,0xE0,0x1F,0xCF,0xFF,0xFF,0x00,0x7F,
0x0F,0xFF,0xF0,0x01,0xFC,0x1F,0xFF,0x00,0x07,0xF0,
0x0F,0xE0,0x00,0x37,0xF8,0x00,0x00,0x00,0x1B,0xFC,
0x00,0x00,0x00,0x08,0xFE,0x00,0x00,0x00,0x00,0x09,
0x5F,0x0F,0x7A,0xE0,0x00,0x1F,0xC0,0x00,0x00,0x03,
0xFF,0xE0,0x7F,0x00,0x3F,0xFF,0xC1,0xFC,0x03,0xFF,
0xFF,0xC7,0xF0,0x1F,0xFF,0xFF,0x9F,0xC0,0xFF,0xFF,
0xFE,0x7F,0x03,0xFF,0xFF,0xFD,0xFC,0x1F,0xFC,0x0F,
0xFF,0xF0,0xFF,0xC0,0x0F,0xFF,0xC3,0xFE,0x00,0x0F,
0xFF,0x1F,0xF0,0x00,0x1F,0xFC,0x7F,0x80,0x00,0x3F,
0xF3,0xFC,0x00,0x00,0xFF,0xCF,0xF0,0x00,0x01,0xFF,
0x3F,0x80,0x00,0x07,0xFE,0x1F,0xC0,0x00,0x01,0xFE,
0xFE,0x00,0x00,0x07,0xFE,0xFF,0x00,0x00,0x01,0xFE,
0xBF,0x80,0x00,0x00,0xFF,0x2F,0xE0,0x00,0x00,0xFF,
0x3F,0xC0,0x00,0x07,0xFC,0x7F,0x00,0x00,0x1F,0xF1,
0xFE,0x00,0x00,0xFF,0xC3,0xFC,0x00,0x07,0xFF,0x0F,
0xF8,0x00,0x3F,0xFC,0x1F,0xF0,0x01,0xFF,0xF0,0x7F,
0xF8,0x1F,0xFF,0xC0,0xFF,0xFF,0xFF,0xFF,0x01,0xFF,
0xFF,0xFD,0xFC,0x03,0xFF,0xFF,0xF7,0xF0,0x07,0xFF,
0xFF,0x9F,0xC0,0x07,0xFF,0xF8,0x7F,0x00,0x07,0xFF,
0xC1,0xFC,0x00,0x03,0xF8,0x07,0xFD,0x00,0x00,0x00,
0x03,0xFE,0x80,0x00,0x00,0x01,0xFE,0x00,0x00,0x00,
0x00,0xFE,0x05,0xD6,0x98,0x01,0xC0,0x00,0x3F,0x07,
0xE1,0xFF,0xE7,0xE3,0xFF,0xF7,0xE7,0xFF,0xF7,0xE7,
0xFF,0xE7,0xEF,0xFF,0xE7,0xFF,0xFF,0xC7,0xFF,0xC1,
0xC7,0xFF,0x00,0x47,0xFE,0x00,0x08,0xFF,0x80,0x01,
0x5F,0xE0,0x00,0x37,0xF8,0x00,0x06,0xFF,0x00,0x00,
0xDF,0xE0,0x00,0x1B,0xFC,0x00,0x01,0xFC,0x00,0x00,
0x09,0x17,0x0F,0xFA,0xA0,0x00,0x7F,0xE0,0x00,0x00,
0x1F,0xFF,0xF0,0x00,0x03,0xFF,0xFF,0xE0,0x00,0x7F,
0xFF,0xFF,0xC0,0x07,0xFF,0xFF,0xFF,0x04,0x0F,0xFF,
0xFF,0xFF,0x80,0xFF,0xE0,0x0F,0xFE,0x07,0xF8,0x00,
0x1F,0xF0,0x7F,0x80,0x00,0x7F,0x83,0xF8,0x00,0x01,
0xFE,0x1F,0xC0,0x00,0x07,0xF0,0xFE,0x00,0x00,0x3C,
0x07,0xF0,0x00,0x00,0x00,0x3F,0xC0,0x00,0x00,0x01,
0xFF,0x00,0x00,0x00,0x07,0xFF,0x00,0x00,0x00,0x3F,
0xFF,0x00,0x00,0x01,0xFF,0xFF,0x80,0x00,0x07,0xFF,
0xFF,0xC0,0x00,0x1F,0xFF,0xFF,0xC0,0x00,0x7F,0xFF,
0xFF,0x80,0x01,0xFF,0xFF,0xFF,0x00,0x03,0xFF,0xFF,
0xFC,0x00,0x03,0xFF,0xFF,0xF0,0x00,0x03,0xFF,0xFF,
0xC0,0x00,0x03,0xFF,0xFF,0x00,0x00,0x01,0xFF,0xF8,
0x00,0x00,0x00,0xFF,0xE0,0x00,0x00,0x01,0xFF,0x00,
0x00,0x00,0x07,0xF8,0x78,0x00,0x00,0x1F,0xDF,0xC0,
0x00,0x00,0xFE,0xFF,0x00,0x00,0x07,0xF3,0xF8,0x00,
0x00,0x3F,0x9F,0xE0,0x00,0x03,0xF8,0xFF,0x80,0x00,
0x3F,0xC3,0xFE,0x00,0x03,0xFE,0x1F,0xFE,0x00,0xFF,
0xE0,0x7F,0xFF,0xFF,0xFF,0x01,0xFF,0xFF,0xFF,0xF0,
0x07,0xFF,0xFF,0xFF,0x00,0x1F,0xFF,0xFF,0xF0,0x00,
0x7F,0xFF,0xFE,0x00,0x00,0xFF,0xFF,0xC0,0x00,0x00,
0x7F,0xF0,0x00,0x05,0x5E,0x0B,0xF9,0x70,0x00,0x80,
0x00,0x06,0x00,0x00,0x78,0x00,0x07,0xE0,0x0D,0x07,
0xF0,0x05,0x03,0xF8,0x03,0x7F,0xFF,0xFD,0xA0,0xFE,
0x00,0xD0,0x7F,0x00,0x68,0x3F,0x80,0x34,0x1F,0xC0,
0x00,0x7F,0x00,0x01,0xFE,0x00,0x07,0xFC,0x00,0x1F,
0xFF,0xD0,0x07,0xFF,0xE0,0x1F,0xFF,0xC0,0x3F,0xFF,
0x00,0x3F,0xFC,0x00,0x3F,0xE0,0x08,0x96,0x9B,0xFA,
0xED,0xFE,0x00,0x00,0x1F,0xF7,0xF8,0x00,0x00,0x7F,
0xDF,0xE0,0x00,0x01,0xFF,0x7F,0x80,0x00,0x07,0xF7,
0xF0,0x00,0x00,0xFF,0x3F,0xC0,0x00,0x07,0xFC,0x7F,
0x80,0x00,0x3F,0xEF,0xF8,0x00,0x0F,0xFC,0xFF,0x00,
0x03,0xFF,0x9F,0xF8,0x01,0xFF,0xF3,0xFF,0x80,0xFF,
0xFE,0x3F,0xFF,0xFF,0xDF,0xC7,0xFF,0xFF,0xF3,0xF8,
0x7F,0xFF,0xFC,0x7F,0x07,0xFF,0xFF,0x0F,0xE0,0x7F,
0xFF,0xC1,0xFC,0x03,0xFF,0xE0,0x3F,0x80,0x0F,0xF0,
0x00,0x00,0x09,0xD6,0x04,0x02,0x97,0xF8,0x00,0x00,
0x0F,0xF8,0x7F,0x00,0x00,0x01,0xFC,0x7F,0x80,0x00,
0x03,0xFD,0x07,0xF0,0x00,0x00,0x7F,0x07,0xF8,0x00,
0x00,0xFF,0x20,0x7F,0x00,0x00,0x1F,0xC0,0x7F,0x80,
0x00,0x3F,0xC4,0x07,0xF0,0x00,0x07,0xF0,0x07,0xF8,
0x00,0x0F,0xF0,0x03,0xF8,0x00,0x0F,0xE0,0x03,0xFC,
0x00,0x0F,0xE0,0x03,0xFC,0x00,0x1F,0xE0,0x01,0xFC,
0x00,0x1F,0xC0,0x80,0x3F,0xC0,0x07,0xF8,0x00,0x1F,
0xC0,0x07,0xF0,0x00,0x1F,0xE0,0x0F,0xF0,0x00,0x0F,
0xE0,0x0F,0xF0,0x00,0x0F,0xE0,0x0F,0xE0,0x00,0x0F,
0xF0,0x1F,0xE0,0x00,0x07,0xF0,0x1F,0xE0,0x00,0x07,
0xF0,0x1F,0xC0,0x00,0x07,0xF8,0x3F,0xC0,0x10,0x00,
0x7F,0x07,0xF0,0x00,0x00,0x7F,0x8F,0xF0,0x02,0x00,
0x07,0xF1,0xFC,0x00,0x00,0x07,0xFB,0xFC,0x00,0x40,
0x00,0x7F,0x7F,0x00,0x00,0x00,0x7F,0xFF,0x00,0x09,
0x00,0x07,0xFF,0xC0,0x01,0x00,0x00,0x7F,0xF0,0x00,
0x00,0x00,0x3F,0xF0,0x00,0x20,0x00,0x07,0xFC,0x00,
0x00,0x0E,0xD6,0x00,0x03,0xB8,0xFE,0x00,0x00,0x7F,
0xC0,0x00,0x0F,0xEF,0xF0,0x00,0x07,0xFC,0x00,0x01,
0xFE,0x7F,0x00,0x00,0x7F,0xC0,0x00,0x1F,0xC7,0xF0,
0x00,0x0F,0xFE,0x00,0x01,0xFC,0x7F,0x80,0x00,0xFF,
0xE0,0x00,0x3F,0xD0,0x7F,0x00,0x01,0xFF,0xC0,0x00,
0x7F,0x07,0xF0,0x00,0x1F,0xFE,0x00,0x0F,0xF0,0x3F,
0x80,0x03,0xFF,0xE0,0x00,0xFE,0x20,0x7F,0x00,0x07,
0xEF,0xC0,0x01,0xFC,0x03,0xF8,0x00,0x7E,0xFE,0x00,
0x3F,0x84,0x07,0xF0,0x01,0xFD,0xFC,0x00,0x7F,0x08,
0x07,0xF0,0x03,0xF1,0xF8,0x01,0xFC,0x00,0x7F,0x00,
0x7F,0x1F,0xC0,0x1F,0xC0,0x03,0xF8,0x07,0xF1,0xFC,
0x03,0xF8,0x10,0x07,0xF0,0x0F,0xC1,0xF8,0x07,0xF0,
0x20,0x07,0xF0,0x3F,0x83,0xF8,0x1F,0xC0,0x00,0x7F,
0x03,0xF0,0x3F,0x81,0xFC,0x00,0x07,0xF8,0x3F,0x01,
0xF8,0x3F,0x80,0x40,0x07,0xF0,0xFE,0x03,0xF8,0x7F,
0x00,0x00,0x7F,0x0F,0xE0,0x3F,0x8F,0xE0,0x00,0x03,
0xF8,0xFC,0x01,0xF8,0xFE,0x00,0x00,0x3F,0x9F,0xC0,
0x1F,0xCF,0xE0,0x00,0x03,0xF9,0xFC,0x01,0xFC,0xFC,
0x00,0x00,0x1F,0x9F,0xC0,0x1F,0xDF,0xC0,0x00,0x01,
0xFD,0xF8,0x00,0xFD,0xFC,0x00,0x00,0x1F,0xDF,0x80,
0x0F,0xDF,0x80,0x08,0x00,0x1F,0xFF,0x00,0x1F,0xFF,
0x00,0x00,0x01,0xFF,0xF0,0x00,0xFF,0xF0,0x01,0x20,
0x01,0xFF,0xC0,0x01,0xFF,0xC0,0x00,0x00,0x0F,0xFC,
0x00,0x1F,0xF8,0x00,0x20,0x00,0x1F,0xF0,0x00,0x1F,
0xF0,0x00,0x00,0x00,0xFF,0x00,0x01,0xFE,0x00,0x00,
0x0A,0x16,0x04,0x02,0xA3,0xFE,0x00,0x00,0x07,0xF8,
0xFF,0x00,0x00,0x07,0xF8,0x3F,0xC0,0x00,0x07,0xFC,
0x1F,0xF0,0x00,0x07,0xFC,0x07,0xFC,0x00,0x03,0xFC,
0x01,0xFE,0x00,0x03,0xFC,0x00,0x7F,0x80,0x03,0xFE,
0x00,0x3F,0xE0,0x01,0xFE,0x00,0x0F,0xF0,0x01,0xFE,
0x00,0x03,0xFC,0x01,0xFF,0x00,0x01,0xFF,0x01,0xFF,
0x00,0x00,0x7F,0x80,0xFF,0x00,0x00,0x1F,0xE0,0xFF,
0x00,0x00,0x0F,0xF8,0xFF,0x80,0x00,0x03,0xFC,0xFF,
0x80,0x00,0x00,0xFF,0x7F,0x80,0x00,0x00,0x7F,0xFF,
0x80,0x00,0x00,0x1F,0xFF,0xC0,0x00,0x00,0x07,0xFF,
0xC0,0x01,0x00,0x00,0x3F,0xF8,0x00,0x10,0x00,0x01,
0xFF,0x00,0x00,0x00,0x01,0xFF,0xC0,0x00,0x00,0x01,
0xFF,0xE0,0x00,0x00,0x01,0xFF,0xF8,0x00,0x00,0x00,
0xFF,0xFE,0x00,0x00,0x00,0xFF,0xFF,0x80,0x00,0x00,
0xFF,0xBF,0xC0,0x00,0x00,0x7F,0x8F,0xF0,0x00,0x00,
0x7F,0x87,0xFC,0x00,0x00,0x7F,0xC1,0xFE,0x00,0x00,
0x7F,0xC0,0x7F,0x80,0x00,0x3F,0xC0,0x3F,0xE0,0x00,
0x3F,0xC0,0x0F,0xF0,0x00,0x3F,0xE0,0x03,0xFC,0x00,
0x3F,0xE0,0x01,0xFF,0x00,0x1F,0xE0,0x00,0x7F,0x80,
0x1F,0xE0,0x00,0x1F,0xE0,0x1F,0xF0,0x00,0x0F,0xF8,
0x0F,0xF0,0x00,0x03,0xFE,0x0F,0xF0,0x00,0x00,0xFF,
0x0F,0xF8,0x00,0x00,0x3F,0xCF,0xF8,0x00,0x00,0x1F,
0xF0,0x09,0x5F,0x07,0x72,0x77,0xF0,0x00,0x00,0x1F,
0xCF,0xE0,0x00,0x00,0xFF,0x87,0xF0,0x00,0x00,0x7F,
0x0F,0xE0,0x00,0x03,0xFD,0x07,0xF0,0x00,0x01,0xFC,
0x0F,0xE0,0x00,0x0F,0xF2,0x07,0xF0,0x00,0x07,0xF0,
0x0F,0xE0,0x00,0x3F,0xC4,0x07,0xF0,0x00,0x1F,0xC0,
0x0F,0xE0,0x00,0xFF,0x08,0x07,0xF0,0x00,0x7F,0x00,
0x0F,0xE0,0x03,0xFC,0x10,0x07,0xF0,0x01,0xFC,0x00,
0x0F,0xE0,0x0F,0xF0,0x20,0x07,0xF0,0x07,0xF0,0x00,
0x0F,0xE0,0x3F,0xC0,0x40,0x07,0xF0,0x1F,0xC0,0x00,
0x0F,0xE0,0xFF,0x00,0x80,0x07,0xF0,0x7F,0x00,0x00,
0x0F,0xC3,0xFC,0x01,0x00,0x07,0xF1,0xFC,0x00,0x00,
0x0F,0xCF,0xF0,0x02,0x00,0x07,0xF7,0xF0,0x00,0x00,
0x0F,0xFF,0xC0,0x04,0x00,0x07,0xFF,0xC0,0x00,0x00,
0x0F,0xFF,0x00,0x08,0x00,0x07,0xFF,0x00,0x00,0x00,
0x0F,0xFC,0x00,0x10,0x00,0x07,0xFC,0x00,0x00,0x00,
0x0F,0xF0,0x00,0x20,0x00,0x07,0xF0,0x00,0x00,0x00,
0x3F,0xC0,0x00,0x40,0x00,0x1F,0xC0,0x00,0x24,0x00,
0x1F,0xC0,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0x07,
0xF8,0x00,0x00,0x10,0x3F,0xC0,0x00,0x00,0x7F,0xFF,
0x00,0x00,0x10,0x3F,0xFF,0x00,0x00,0x00,0x7F,0xF8,
0x00,0x00,0x01,0xFF,0xC0,0x00,0x00,0x07,0xFE,0x00,
0x00,0x00,0x0F,0xE0,0x00,0x00,0x00,0x09,0x56,0x04,
0x02,0x8D,0x3F,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,
0xFF,0x80,0x00,0x00,0x07,0xFC,0x00,0x00,0x00,0x3F,
0xE0,0x00,0x00,0x01,0xFF,0x00,0x00,0x00,0x0F,0xF8,
0x10,0x00,0x00,0x0F,0xF8,0x00,0x00,0x00,0x7F,0xC0,
0x00,0x00,0x03,0xFE,0x00,0x00,0x00,0x1F,0xF0,0x00,
0x00,0x00,0xFF,0x80,0x00,0x00,0x07,0xFC,0x00,0x00,
0x00,0x3F,0xE0,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,
0x07,0xFC,0x00,0x00,0x00,0x3F,0xE0,0x00,0x00,0x01,
0xFF,0x00,0x00,0x00,0x0F,0xF8,0x00,0x00,0x00,0x7F,
0xC0,0x00,0x00,0x03,0xFE,0x00,0x00,0x00,0x0F,0xF0,
0x00,0x00,0x00,0x7F,0xC0,0x00,0x00,0x03,0xFE,0x00,
0x00,0x00,0x1F,0xF0,0x00,0x00,0x00,0xFF,0x80,0x00,
0x00,0x07,0xFC,0x00,0x00,0x00,0x3F,0xE0,0x00,0x00,
0x08,0x3F,0xE0,0x00,0x00,0x01,0xFF,0x00,0x00,0x00,
0x1B,0xFF,0xFF,0xFF,0xFF,0xF0,0x05,0xE7,0x8B,0x71,
0xC0,0x00,0x0F,0xF0,0x00,0x3F,0xF0,0x00,0x7F,0xF0,
0x00,0xFF,0xF0,0x01,0xFF,0xF8,0x00,0x7F,0xFE,0x00,
0x7F,0xC1,0x00,0x1F,0xE0,0x34,0x03,0xF8,0x06,0x80,
0x7F,0x00,0xB0,0x0F,0xE0,0x12,0x03,0xF8,0x00,0x07,
0xF8,0x00,0x07,0xF0,0x00,0x0F,0xF0,0x00,0x3F,0xE0,
0x01,0xFF,0xC0,0x01,0xFF,0x80,0x01,0xFE,0x00,0x01,
0xFC,0x00,0x01,0xFE,0x00,0x01,0xFF,0x80,0x01,0xFF,
0xC0,0x00,0x3F,0xE0,0x00,0x0F,0xF0,0x00,0x07,0xF0,
0x00,0x07,0xF8,0x02,0x40,0x7F,0x00,0x68,0x07,0xF0,
0x0D,0x00,0xFE,0x01,0x60,0x1F,0xC0,0x00,0x1F,0xE0,
0x00,0x0F,0xE0,0x00,0x0F,0xF8,0x00,0x0F,0xFF,0xE0,
0x00,0xFF,0xF8,0x00,0x7F,0xF8,0x00,0x3F,0xF8,0x00,
0x1F,0xF8,0x00,0x03,0xF8,0x01,0xA7,0x1F,0x71,0x4D,
0xFF,0x7F,0xDF,0xF7,0xFD,0xFF,0x7F,0xDF,0xF7,0xFD,
0xFF,0x7F,0xDF,0xDF,0x80,0x05,0xE7,0x8F,0x71,0xC7,
0xF0,0x00,0x07,0xFE,0x00,0x07,0xFF,0x00,0x07,0xFF,
0x80,0x08,0xFF,0xF8,0x00,0xFF,0xFC,0x00,0x07,0xFC,
0x00,0x01,0xFC,0x00,0x01,0xFE,0x01,0xA0,0x1F,0xC0,
0x34,0x03,0xF8,0x05,0x80,0x7F,0x00,0x90,0x07,0xF0,
0x00,0x07,0xF8,0x00,0x03,0xF8,0x00,0x03,0xFC,0x00,
0x01,0xFF,0x00,0x00,0xFF,0xE0,0x00,0x7F,0xE0,0x00,
0x1F,0xE0,0x00,0x0F,0xE0,0x00,0x3F,0xE0,0x00,0x7F,
0xE0,0x00,0xFF,0xE0,0x01,0xFF,0x00,0x03,0xFC,0x00,
0x03,0xF8,0x00,0x07,0xF8,0x00,0x07,0xF0,0x10,0x01,
0xFE,0x03,0x40,0x3F,0x80,0x68,0x07,0xF0,0x0B,0x00,
0xFE,0x01,0x00,0x3F,0xC0,0x00,0xFF,0x80,0x23,0xFF,
0xF0,0x03,0xFF,0xE0,0x03,0xFF,0xC0,0x03,0xFF,0x80,
0x03,0xFF,0x00,0x03,0xFC,0x00,0x00,0x0A,0x47,0x90,
0xAB,0x00,0x07,0xF0,0x00,0x00,0x00,0x0F,0xFF,0x80,
0x00,0x01,0x07,0xFF,0xF8,0x00,0x00,0xC3,0xFF,0xFF,
0x80,0x00,0x71,0xFF,0xFF,0xF8,0x00,0x3C,0xFF,0xFF,
0xFF,0x00,0x3F,0x7F,0xFF,0xFF,0xF8,0x3F,0xDF,0xFF,
0xFF,0xFF,0xFF,0xF7,0xF8,0x3F,0xFF,0xFF,0xFD,0xF8,
0x01,0xFF,0xFF,0xFE,0x78,0x00,0x1F,0xFF,0xFF,0x1C,
0x00,0x01,0xFF,0xFF,0x86,0x00,0x00,0x3F,0xFF,0xC1,
0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,0x1F,0xC0,
0x00,};
/* font data size: 16081 bytes */

static const unsigned char font_tgx_Arial_60_index[] = {
0x00,0x00,0x00,0x50,0x06,0x40,0x2B,0x03,0x2C,
0x1F,0x40,0xF4,0x85,0x3C,0x15,0x18,0x5C,0x11,0x8D,
0xC6,0x85,0x1A,0xC0,0x6B,0xE1,0xB1,0x86,0xCC,0x1C,
0xD0,0x7E,0x62,0x0E,0xC9,0x41,0x29,0x28,0xB1,0x92,
0xF9,0x0C,0xF5,0x36,0x58,0xE8,0xB3,0xE1,0x8F,0x95,
0x3E,0xAD,0x06,0xE4,0x22,0x11,0x4B,0x48,0x59,0x4F,
0x75,0x81,0x97,0x10,0x61,0x05,0x94,0x86,0x60,0xD9,
0xB9,0x6C,0x21,0xB4,0x56,0xD5,0xDB,0xB9,0x74,0xD5,
0xD6,0x77,0x9C,0x1F,0x9E,0x83,0xAE,0x1A,0x18,0xC2,
0xE4,0x4B,0x96,0x9E,0x5E,0x69,0x9D,0x67,0xC7,0xA6,
0xCA,0xB4,0x0B,0x0F,0xED,0x3D,0xB5,0x72,0xDB,0xEB,
0x77,0x6E,0x42,0xB9,0x36,0xE6,0x5B,0xD1,0xEF,0xF9,
0xC2,0xAB,0x15,0xCC,0x83,0x32,0x44,0xCC,0x9B,0x38,
0xAC,0xE7,0x73,0xD2,0xD2,0xB7,0x4B,0xED,0x56,0xF5,
0xB1,0xD9,0x87,0x71,0xDD,0xF5,0x38,0x0E,0xE3,0x8F,
0x92,0x2E,0x5E,0x3A,0x21,0xEC,0x6B,0xBF,0x7F,0x33,
0xFD,0x64,0xF7,0x97,0xDF,0x9F,0x9F,0x40,
};
/* font index size: 167 bytes */

const ILI9341_t3_font_t font_tgx_Arial_60 = {
	font_tgx_Arial_60_index,
	0,
	font_tgx_Arial_60_data,
	1,
	0,
	32,
	126,
	0,
	0,
	14,
	7,
	7,
	5,
	7,
	7,
	92,
	60
};



static const unsigned char font_tgx_Arial_72_data[] = {
0x00,0x00,0x00,0x01,0xC0,0x02,0x64,0x2C,0x01,0xCD,
0xFF,0xEF,0xFF,0x7F,0xF9,0xFF,0xD7,0xF6,0xBF,0xAD,
0xFD,0xA7,0xC9,0x3E,0x68,0x03,0x7F,0xF1,0xFF,0x06,
0xCD,0x11,0x72,0x4D,0xFF,0x80,0x3F,0xFB,0xFF,0x00,
0x7F,0xDF,0xF0,0x07,0xFC,0xFF,0x00,0x3F,0xB1,0xFC,
0x00,0x7F,0x0F,0xC0,0x03,0xE4,0x9F,0x00,0x07,0xC0,
0x0D,0x64,0x04,0x03,0x88,0x00,0x00,0x1F,0xF0,0x00,
0xFF,0x80,0x00,0x00,0xFF,0xC0,0x07,0xFC,0x12,0x00,
0x00,0x7F,0xC0,0x03,0xFE,0x00,0x00,0x01,0xFF,0x00,
0x1F,0xF8,0x00,0x00,0x0F,0xFC,0x00,0x7F,0xC0,0x90,
0x00,0x07,0xFC,0x00,0x3F,0xE0,0x00,0x00,0x1F,0xF0,
0x01,0xFF,0x80,0x00,0x00,0xFF,0xC0,0x07,0xFC,0x04,
0x80,0x00,0x7F,0xC0,0x03,0xFE,0x00,0x00,0x01,0xFF,
0x00,0x1F,0xF8,0x00,0x00,0x0F,0xFC,0x00,0x7F,0xC0,
0x00,0x00,0x3F,0xE0,0x01,0xFF,0x00,0xDF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC7,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xE0,0x00,0x1F,0xF0,0x00,0xFF,0x80,0x00,0x00,
0x7F,0xC0,0x07,0xFE,0x00,0x00,0x03,0xFF,0x00,0x1F,
0xF0,0x01,0x20,0x01,0xFF,0x00,0x0F,0xF8,0x00,0x00,
0x07,0xFC,0x00,0x7F,0xE0,0x00,0x00,0x3F,0xF0,0x01,
0xFF,0x00,0x09,0x00,0x1F,0xF0,0x00,0xFF,0x80,0x00,
0x00,0x7F,0xC0,0x07,0xFE,0x00,0x00,0x03,0xFF,0x00,
0x1F,0xF0,0x00,0x40,0x01,0xFF,0x00,0x0F,0xF8,0x00,
0x37,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF1,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF0,0x07,0xFC,0x00,0x3F,0xE0,
0x00,0x00,0x1F,0xF0,0x01,0xFF,0x80,0x00,0x00,0xFF,
0xC0,0x07,0xFC,0x00,0x02,0x40,0x7F,0xC0,0x03,0xFE,
0x00,0x00,0x01,0xFF,0x00,0x1F,0xF8,0x00,0x00,0x0F,
0xFC,0x00,0x7F,0xC0,0x00,0x12,0x07,0xFC,0x00,0x3F,
0xE0,0x00,0x00,0x1F,0xF0,0x01,0xFF,0x80,0x00,0x00,
0xFF,0xC0,0x07,0xFC,0x00,0x00,0x90,0x7F,0xC0,0x03,
0xFE,0x00,0x00,0x01,0xFF,0x00,0x1F,0xF8,0x00,0x01,
0x01,0xFF,0x00,0x0F,0xF8,0x00,0x00,0x0B,0xEB,0x13,
0xB3,0x8A,0x00,0x00,0x07,0xC0,0x00,0x00,0x00,0x00,
0x3F,0xF8,0x00,0x00,0x00,0x03,0xFF,0xFF,0x80,0x00,
0x00,0x1F,0xFF,0xFF,0xE0,0x00,0x00,0x3F,0xFF,0xFF,
0xF8,0x00,0x00,0xFF,0xFF,0xFF,0xFC,0x00,0x01,0xFF,
0xFF,0xFF,0xFE,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0x00,
0x03,0xFF,0xFF,0xFF,0xFF,0x80,0x07,0xFF,0xE7,0xFF,
0xFF,0xC0,0x0F,0xFF,0x07,0xCF,0xFF,0xC0,0x0F,0xFE,
0x07,0xC3,0xFF,0xE0,0x1F,0xFC,0x07,0xC0,0xFF,0xE0,
0x1F,0xF8,0x07,0xC0,0x7F,0xF0,0x1F,0xF0,0x07,0xC0,
0x3F,0xF0,0x3F,0xF0,0x07,0xC0,0x3F,0xF1,0x07,0xFC,
0x00,0xF8,0x03,0xFF,0x07,0xFC,0x00,0xF8,0x01,0xFF,
0x07,0xFC,0x00,0xF8,0x01,0xF0,0x24,0xFF,0x80,0x1F,
0x00,0x00,0x00,0xFF,0xC0,0x1F,0x00,0x00,0x00,0x7F,
0xC0,0x1F,0x00,0x00,0x00,0x7F,0xE0,0x1F,0x00,0x00,
0x00,0x7F,0xF0,0x1F,0x00,0x00,0x00,0x3F,0xF8,0x1F,
0x00,0x00,0x00,0x3F,0xFE,0x1F,0x00,0x00,0x00,0x1F,
0xFF,0x9F,0x00,0x00,0x00,0x1F,0xFF,0xFF,0x00,0x00,
0x00,0x0F,0xFF,0xFF,0x00,0x00,0x00,0x07,0xFF,0xFF,
0xE0,0x00,0x00,0x03,0xFF,0xFF,0xFE,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0x80,0x00,0x00,0x3F,0xFF,0xFF,0xE0,
0x00,0x00,0x1F,0xFF,0xFF,0xF8,0x00,0x00,0x03,0xFF,
0xFF,0xFC,0x00,0x00,0x00,0xFF,0xFF,0xFF,0x00,0x00,
0x00,0x1F,0xFF,0xFF,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0x80,0x00,0x00,0x1F,0x1F,0xFF,0xC0,0x00,0x00,0x1F,
0x07,0xFF,0xE0,0x00,0x00,0x1F,0x01,0xFF,0xE0,0x00,
0x00,0x1F,0x00,0x7F,0xF4,0x00,0x00,0x03,0xE0,0x07,
0xFE,0x80,0x00,0x00,0x7C,0x00,0x7F,0xF2,0x00,0x00,
0x0F,0x80,0x07,0xFC,0x1F,0x00,0x0F,0x80,0x07,0xFE,
0x3F,0xE0,0x01,0xF0,0x00,0xFF,0xBF,0xF0,0x01,0xF0,
0x00,0xFF,0xBF,0xF0,0x01,0xF0,0x01,0xFF,0x9F,0xF0,
0x01,0xF0,0x01,0xFF,0x1F,0xF8,0x01,0xF0,0x03,0xFF,
0x1F,0xFC,0x01,0xF0,0x03,0xFF,0x0F,0xFC,0x01,0xF0,
0x07,0xFE,0x0F,0xFE,0x01,0xF0,0x0F,0xFE,0x0F,0xFF,
0x01,0xF0,0x1F,0xFC,0x07,0xFF,0xC1,0xF0,0x7F,0xFC,
0x03,0xFF,0xF1,0xF1,0xFF,0xF8,0x03,0xFF,0xFF,0xFF,
0xFF,0xF0,0x01,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0xFF,
0xFF,0xFF,0xFF,0xC0,0x00,0x7F,0xFF,0xFF,0xFF,0x80,
0x00,0x3F,0xFF,0xFF,0xFF,0x00,0x00,0x1F,0xFF,0xFF,
0xFC,0x00,0x00,0x07,0xFF,0xFF,0xF0,0x00,0x00,0x00,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x0F,0xF0,0x00,0x00,
0x68,0x00,0x00,0x3E,0x00,0x00,0x08,0x00,0x00,0x07,
0xC0,0x00,0x00,0x13,0x65,0x1B,0xFD,0x90,0x00,0xFF,
0x00,0x00,0x00,0x00,0x1F,0xE0,0x00,0x00,0x1F,0xFF,
0x00,0x00,0x00,0x00,0x7F,0x80,0x00,0x00,0xFF,0xFF,
0x00,0x00,0x00,0x03,0xFC,0x00,0x00,0x0F,0xFF,0xFE,
0x00,0x00,0x00,0x0F,0xE0,0x00,0x00,0x3F,0xFF,0xFC,
0x00,0x00,0x00,0x7F,0x80,0x00,0x01,0xFF,0xFF,0xF8,
0x00,0x00,0x01,0xFC,0x00,0x00,0x0F,0xF8,0x1F,0xF0,
0x00,0x00,0x0F,0xF0,0x00,0x00,0x3F,0xC0,0x3F,0xC0,
0x00,0x00,0x3F,0x80,0x00,0x01,0xFE,0x00,0x7F,0x80,
0x00,0x01,0xFE,0x00,0x00,0x07,0xF0,0x00,0xFE,0x00,
0x00,0x0F,0xF0,0x00,0x00,0x3F,0x80,0x01,0xFC,0x00,
0x00,0x3F,0xC0,0x00,0x02,0x1F,0xC0,0x00,0xFE,0x00,
0x00,0x3F,0xC0,0x00,0x00,0x7F,0x00,0x01,0xF8,0x00,
0x01,0xFE,0x00,0x00,0x03,0xF8,0x00,0x07,0xF0,0x00,
0x07,0xF8,0x00,0x00,0x11,0xFC,0x00,0x03,0xF8,0x00,
0x07,0xF8,0x00,0x00,0x07,0xF0,0x00,0x0F,0xE0,0x00,
0x3F,0xC0,0x00,0x00,0x1F,0xC0,0x00,0x3F,0x80,0x00,
0xFE,0x00,0x00,0x00,0x7F,0x00,0x00,0xFE,0x00,0x07,
0xF8,0x00,0x00,0x01,0xFC,0x00,0x03,0xF8,0x00,0x1F,
0xC0,0x00,0x00,0x07,0xF0,0x00,0x0F,0xE0,0x00,0xFF,
0x00,0x00,0x00,0x1F,0xC0,0x00,0x3F,0x80,0x03,0xF8,
0x00,0x00,0x00,0x7F,0x00,0x00,0xFE,0x00,0x1F,0xE0,
0x00,0x00,0x01,0xFC,0x00,0x03,0xF8,0x00,0xFF,0x00,
0x00,0x00,0x03,0xF0,0x00,0x1F,0xC0,0x03,0xFC,0x00,
0x00,0x00,0x21,0xFC,0x00,0x0F,0xE0,0x03,0xFC,0x00,
0x00,0x00,0x07,0xF0,0x00,0x3F,0x80,0x1F,0xE0,0x00,
0x00,0x00,0x0F,0xE0,0x01,0xFC,0x00,0x7F,0x80,0x00,
0x00,0x00,0x3F,0xC0,0x0F,0xF0,0x03,0xFC,0x00,0x00,
0x00,0x00,0x7F,0x80,0x7F,0x80,0x0F,0xF0,0x00,0x00,
0x00,0x01,0xFF,0x03,0xFE,0x00,0x7F,0x80,0x00,0x00,
0x00,0x03,0xFF,0xFF,0xF0,0x01,0xFC,0x00,0x00,0x00,
0x00,0x07,0xFF,0xFF,0x80,0x0F,0xF0,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xFC,0x00,0x3F,0x80,0x00,0xFF,0x00,
0x00,0x1F,0xFF,0xE0,0x01,0xFE,0x00,0x1F,0xFF,0x00,
0x00,0x3F,0xFE,0x00,0x07,0xF0,0x00,0xFF,0xFF,0x00,
0x00,0x1F,0xE0,0x00,0x3F,0xC0,0x0F,0xFF,0xFE,0x00,
0x00,0x00,0x00,0x01,0xFE,0x00,0x3F,0xFF,0xFC,0x00,
0x00,0x00,0x00,0x07,0xF8,0x01,0xFF,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x3F,0xC0,0x0F,0xF8,0x1F,0xF0,0x00,
0x00,0x00,0x00,0xFF,0x00,0x3F,0xC0,0x3F,0xC0,0x00,
0x00,0x00,0x07,0xF8,0x01,0xFE,0x00,0x7F,0x80,0x00,
0x00,0x00,0x1F,0xE0,0x07,0xF0,0x00,0xFE,0x40,0x00,
0x00,0x00,0x1F,0xE0,0x07,0xF0,0x00,0x3F,0x80,0x00,
0x00,0x00,0xFF,0x00,0x1F,0xC0,0x00,0xFE,0x00,0x00,
0x00,0x03,0xF8,0x00,0xFF,0x00,0x01,0xF8,0x00,0x00,
0x00,0x1F,0xE0,0x03,0xF8,0x00,0x07,0xF0,0x00,0x00,
0x00,0x7F,0x00,0x0F,0xE0,0x00,0x1F,0xC0,0x00,0x00,
0x03,0xFC,0x00,0x3F,0x80,0x00,0x7F,0x80,0x00,0x00,
0x03,0xFC,0x00,0x1F,0xC0,0x00,0x3F,0xC0,0x00,0x00,
0x03,0xFC,0x00,0x0F,0xE0,0x00,0x1F,0xE0,0x00,0x00,
0x03,0xFC,0x00,0x07,0xF0,0x00,0x0F,0xF0,0x00,0x00,
0x03,0xFC,0x00,0x03,0xF8,0x00,0x07,0xF0,0x00,0x00,
0x1F,0xE0,0x00,0x07,0xE0,0x00,0x3F,0x80,0x00,0x00,
0x7F,0x80,0x00,0x1F,0xC0,0x00,0xFE,0x00,0x00,0x03,
0xFC,0x00,0x00,0x7F,0x00,0x03,0xF8,0x00,0x00,0x0F,
0xE0,0x00,0x01,0xFC,0x00,0x0F,0xE0,0x00,0x00,0x7F,
0x80,0x00,0x03,0xF8,0x00,0x7F,0x00,0x00,0x01,0xFC,
0x00,0x00,0x0F,0xF0,0x03,0xFC,0x00,0x00,0x0F,0xF0,
0x00,0x00,0x1F,0xE0,0x1F,0xE0,0x00,0x00,0x7F,0x80,
0x00,0x00,0x7F,0xC0,0xFF,0x80,0x00,0x01,0xFE,0x00,
0x00,0x00,0xFF,0xFF,0xFC,0x00,0x00,0x0F,0xF0,0x00,
0x00,0x01,0xFF,0xFF,0xE0,0x00,0x00,0x3F,0xC0,0x00,
0x00,0x03,0xFF,0xFF,0x00,0x00,0x01,0xFE,0x00,0x00,
0x00,0x07,0xFF,0xF8,0x00,0x00,0x07,0xF8,0x00,0x00,
0x00,0x0F,0xFF,0x80,0x00,0x00,0x3F,0xC0,0x00,0x00,
0x00,0x07,0xF8,0x00,0x0F,0x25,0x17,0xFC,0x30,0x00,
0x00,0x1F,0xF8,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xF0,0x00,
0x00,0x00,0x00,0x0F,0xFF,0xFF,0xC0,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x1F,0xFF,
0xFF,0xFC,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xF0,
0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xC0,0x00,0x00,
0x00,0xFF,0xF8,0x1F,0xFE,0x00,0x00,0x00,0x07,0xFE,
0x00,0x3F,0xF8,0x00,0x00,0x00,0x7F,0xE0,0x00,0xFF,
0xC0,0x00,0x00,0x03,0xFE,0x00,0x03,0xFE,0x00,0x00,
0x00,0x3F,0xF0,0x00,0x1F,0xF8,0x00,0x06,0x00,0x3F,
0xE0,0x00,0x0F,0xF8,0x00,0x00,0x01,0xFF,0x80,0x00,
0xFF,0x80,0x00,0x00,0x07,0xFC,0x00,0x07,0xFC,0x00,
0x00,0x00,0x3F,0xF0,0x00,0x7F,0xE0,0x00,0x00,0x01,
0xFF,0x80,0x07,0xFE,0x00,0x00,0x00,0x07,0xFE,0x00,
0x7F,0xE0,0x00,0x00,0x00,0x3F,0xF8,0x07,0xFF,0x00,
0x00,0x00,0x00,0xFF,0xE0,0xFF,0xF0,0x00,0x00,0x00,
0x07,0xFF,0x1F,0xFF,0x00,0x00,0x00,0x00,0x1F,0xFF,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,0x00,
0x00,0x00,0x00,0x03,0xFF,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x3F,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x03,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0x7F,0xFF,0x80,0x00,0x00,0x00,
0x00,0x07,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xC0,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,
0x00,0x0F,0xFF,0x1F,0xFC,0x00,0x00,0x00,0x00,0xFF,
0xF0,0xFF,0xF0,0x00,0x00,0x00,0x0F,0xFF,0x03,0xFF,
0xC0,0x03,0xC0,0x00,0xFF,0xE0,0x0F,0xFE,0x00,0x3F,
0xF0,0x0F,0xFE,0x00,0x3F,0xF8,0x01,0xFF,0x80,0x7F,
0xE0,0x00,0xFF,0xE0,0x1F,0xF8,0x07,0xFE,0x00,0x07,
0xFF,0x80,0xFF,0xC0,0x3F,0xE0,0x00,0x1F,0xFE,0x0F,
0xFE,0x03,0xFF,0x00,0x00,0x7F,0xF0,0x7F,0xE0,0x1F,
0xF0,0x00,0x01,0xFF,0xC7,0xFF,0x00,0xFF,0x80,0x00,
0x07,0xFF,0x7F,0xF8,0x0F,0xF8,0x00,0x00,0x3F,0xFF,
0xFF,0x80,0x7F,0xC0,0x00,0x00,0xFF,0xFF,0xFC,0x03,
0xFE,0x00,0x00,0x03,0xFF,0xFF,0xC0,0x1F,0xF0,0x00,
0x00,0x0F,0xFF,0xFE,0x00,0xFF,0x80,0x00,0x00,0x3F,
0xFF,0xE0,0x07,0xFC,0x00,0x00,0x01,0xFF,0xFE,0x00,
0x3F,0xE0,0x00,0x00,0x07,0xFF,0xF0,0x01,0xFF,0x80,
0x00,0x00,0x1F,0xFF,0x00,0x0F,0xFC,0x00,0x00,0x00,
0x7F,0xFC,0x00,0x3F,0xF0,0x00,0x00,0x07,0xFF,0xE0,
0x01,0xFF,0x80,0x00,0x00,0x7F,0xFF,0x80,0x0F,0xFE,
0x00,0x00,0x03,0xFF,0xFE,0x00,0x3F,0xF8,0x00,0x00,
0x7F,0xFF,0xF8,0x01,0xFF,0xC0,0x00,0x07,0xFF,0xFF,
0xE0,0x07,0xFF,0x00,0x00,0x7F,0xFF,0xFF,0x80,0x1F,
0xFE,0x00,0x0F,0xFF,0xDF,0xFE,0x00,0xFF,0xFC,0x03,
0xFF,0xFC,0x7F,0xFC,0x03,0xFF,0xFF,0xFF,0xFF,0xC1,
0xFF,0xF0,0x0F,0xFF,0xFF,0xFF,0xFC,0x07,0xFF,0xC0,
0x3F,0xFF,0xFF,0xFF,0x80,0x3F,0xFC,0x00,0xFF,0xFF,
0xFF,0xF8,0x00,0x7F,0xC0,0x01,0xFF,0xFF,0xFF,0x80,
0x01,0xFC,0x00,0x07,0xFF,0xFF,0xF0,0x00,0x07,0xC0,
0x00,0x07,0xFF,0xFC,0x00,0x00,0x1C,0x00,0x00,0x07,
0xFF,0x00,0x00,0x00,0x40,0x02,0x4D,0x15,0x71,0x3D,
0xFF,0xEF,0xFE,0x3F,0xF8,0xFE,0x3F,0x24,0xF8,0x06,
0x2E,0x1B,0x62,0x10,0x00,0x01,0xF8,0x00,0x01,0xF8,
0x00,0x01,0xF8,0x00,0x01,0xFC,0x00,0x00,0xFC,0x00,
0x00,0xFE,0x20,0x00,0x1F,0xC0,0x00,0x1F,0xC1,0x00,
0x03,0xF8,0x00,0x03,0xF8,0x00,0x03,0xFC,0x00,0x01,
0xFC,0x00,0x01,0xFE,0x00,0x00,0xFE,0x00,0x80,0x1F,
0xE0,0x08,0x03,0xFC,0x00,0x90,0x7F,0x80,0x08,0x0F,
0xF0,0x00,0x81,0xFF,0x00,0x00,0xFF,0x00,0x04,0x9F,
0xF0,0x00,0x0F,0xF0,0x00,0x2D,0xFF,0x00,0x00,0xFF,
0x00,0x01,0xBF,0xF0,0x00,0x1B,0xFF,0x00,0x01,0x1F,
0xF0,0x00,0x07,0xF8,0x00,0x0B,0x7F,0xC0,0x00,0x1F,
0xE0,0x00,0x49,0xFF,0x00,0x00,0x7F,0x80,0x02,0x07,
0xFC,0x00,0x01,0xFE,0x00,0x00,0xFF,0x80,0x08,0x07,
0xF8,0x00,0x03,0xFE,0x00,0x40,0x1F,0xE0,0x04,0x00,
0xFF,0x00,0x40,0x07,0xF8,0x00,0x01,0xFC,0x00,0x00,
0xFF,0x00,0x00,0x3F,0x80,0x80,0x01,0xFC,0x08,0x00,
0x0F,0xE0,0x00,0x03,0xF8,0x40,0x00,0x1F,0xC0,0x00,
0x07,0xF0,0x00,0x01,0xF8,0x00,0x00,0x7E,0x00,0x00,
0x1F,0x80,0x06,0x2E,0x0F,0x62,0x17,0xE0,0x00,0x01,
0xF8,0x00,0x00,0xFE,0x00,0x00,0x3F,0x80,0x00,0x0F,
0xC0,0x00,0x07,0xF0,0x00,0x20,0x3F,0x80,0x00,0x0F,
0xE0,0x01,0x00,0x7F,0x00,0x00,0x1F,0xC0,0x00,0x0F,
0xF0,0x00,0x03,0xF8,0x00,0x01,0xFE,0x00,0x00,0x7F,
0x00,0x80,0x07,0xF8,0x08,0x00,0x3F,0xC0,0x90,0x01,
0xFE,0x08,0x00,0x0F,0xF0,0x80,0x00,0xFF,0x80,0x00,
0x3F,0xC4,0x80,0x03,0xFE,0x00,0x00,0xFF,0x30,0x00,
0x0F,0xFB,0x40,0x00,0x7F,0xF4,0x00,0x07,0xFE,0x00,
0x00,0x7F,0xF0,0x00,0x0F,0xFA,0x40,0x01,0xFF,0x20,
0x00,0x1F,0xE0,0x00,0x1F,0xF1,0x00,0x01,0xFE,0x00,
0x01,0xFF,0x08,0x00,0x1F,0xE0,0x00,0x1F,0xF0,0x40,
0x01,0xFE,0x04,0x00,0x3F,0xC0,0x40,0x07,0xF8,0x04,
0x00,0xFF,0x00,0x00,0x7F,0x00,0x20,0x0F,0xE0,0x00,
0x0F,0xE0,0x00,0x0F,0xF0,0x00,0x07,0xF0,0x00,0x07,
0xF0,0x00,0x03,0xF0,0x00,0x03,0xF8,0x00,0x01,0xF8,
0x00,0x01,0xF8,0x00,0x01,0xF8,0x00,0x00,0x08,0x4F,
0x0D,0x52,0x7D,0x00,0x07,0xF0,0x00,0x08,0x01,0xF8,
0x00,0x83,0xC0,0x3E,0x01,0xE0,0xFE,0x0F,0x83,0xF8,
0x7F,0xE3,0xE3,0xFF,0x1F,0xFE,0xFB,0xFF,0xC7,0xFF,
0xFF,0xFF,0xF3,0xFF,0xFF,0xFF,0xFE,0x3F,0xFF,0xFF,
0xFE,0x00,0xFF,0xFF,0xFC,0x00,0x01,0xFF,0xC0,0x00,
0x00,0x3F,0xE0,0x00,0x00,0x1F,0xFC,0x00,0x00,0x0F,
0xFF,0x80,0x00,0x07,0xF7,0xF0,0x00,0x03,0xF9,0xFE,
0x00,0x01,0xFE,0x3F,0xC0,0x00,0xFF,0x07,0xF8,0x00,
0x7F,0xC1,0xFF,0x00,0x3F,0xE0,0x3F,0xE0,0x07,0xF0,
0x07,0xF0,0x00,0xFC,0x01,0xF8,0x00,0x0E,0x00,0x38,
0x00,0x01,0x00,0x04,0x00,0x0C,0x18,0x14,0x5B,0xAD,
0x00,0x00,0x0F,0xF0,0x00,0x00,0xD0,0x00,0x00,0xFF,
0x00,0x00,0x0C,0x00,0x00,0x0F,0xF0,0x00,0x00,0xDF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFE,0x80,0x00,0x07,0xF8,0x00,0x00,0x68,0x00,
0x00,0x7F,0x80,0x00,0x06,0x00,0x00,0x07,0xF8,0x00,
0x00,0x00,0x02,0x4C,0x27,0x89,0xCD,0xFF,0xC7,0xFF,
0x03,0xE0,0xF4,0x0F,0x87,0xC3,0xF1,0xF8,0x3C,0x0E,
0x01,0x00,0x06,0xC4,0x0C,0xAA,0x1D,0xFF,0xFF,0xFF,
0xEF,0xFF,0xFF,0xFE,0x02,0x44,0xA4,0x01,0xCD,0xFF,
0xC7,0xFC,0x07,0x64,0x00,0x01,0xC8,0x00,0x00,0x07,
0xF8,0x00,0x00,0x3F,0xF0,0x00,0x00,0x1F,0xE0,0x00,
0x00,0xFF,0xA4,0x00,0x00,0x7F,0x80,0x00,0x03,0xFE,
0x40,0x00,0x01,0xFE,0x00,0x00,0x0F,0xF8,0x80,0x00,
0x07,0xF8,0x00,0x00,0x3F,0xE1,0x20,0x00,0x1F,0xE0,
0x00,0x00,0xFF,0x82,0x00,0x00,0x7F,0x80,0x00,0x03,
0xFE,0x04,0x80,0x01,0xFE,0x00,0x00,0x0F,0xF8,0x08,
0x00,0x07,0xF8,0x00,0x00,0x3F,0xE0,0x12,0x00,0x1F,
0xE0,0x00,0x00,0xFF,0x80,0x20,0x00,0x7F,0x80,0x00,
0x03,0xFE,0x00,0x40,0x01,0xFE,0x00,0x00,0x0F,0xF8,
0x00,0x90,0x07,0xF8,0x00,0x00,0x3F,0xE0,0x01,0x00,
0x1F,0xE0,0x00,0x00,0xFF,0x80,0x02,0x40,0x7F,0x80,
0x00,0x03,0xFE,0x00,0x04,0x01,0xFE,0x00,0x00,0x0F,
0xF8,0x00,0x09,0x07,0xF8,0x00,0x00,0x3F,0xE0,0x00,
0x10,0x1F,0xE0,0x00,0x00,0xFF,0x80,0x00,0x20,0x7F,
0x80,0x00,0x03,0xFE,0x00,0x00,0x49,0xFE,0x00,0x00,
0x0F,0xF8,0x00,0x00,0x87,0xF8,0x00,0x00,0x3F,0xE0,
0x00,0x00,0xFF,0x00,0x00,0x00,0x0B,0xA4,0x97,0xFB,
0x80,0x00,0x01,0xFF,0x80,0x00,0x00,0x00,0x1F,0xFF,
0xE0,0x00,0x00,0x01,0xFF,0xFF,0xF8,0x00,0x00,0x07,
0xFF,0xFF,0xF8,0x00,0x00,0x1F,0xFF,0xFF,0xF8,0x01,
0x00,0x1F,0xFF,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0xFF,
0xFF,0x80,0x01,0xFF,0xF0,0x1F,0xFF,0x80,0x07,0xFF,
0x80,0x07,0xFF,0x80,0x0F,0xFE,0x00,0x07,0xFF,0x00,
0x3F,0xF0,0x00,0x07,0xFF,0x00,0x7F,0xE0,0x00,0x07,
0xFE,0x01,0xFF,0x80,0x00,0x07,0xFC,0x20,0x7F,0xC0,
0x00,0x00,0xFF,0x8A,0x3F,0xE0,0x00,0x00,0x1F,0xF3,
0x1F,0xF0,0x00,0x00,0x03,0xFE,0xDF,0xF8,0x00,0x00,
0x00,0x7F,0xF7,0xFE,0x00,0x00,0x00,0x1F,0xFD,0xFF,
0x80,0x00,0x00,0x07,0xFC,0xFF,0x00,0x00,0x00,0x1F,
0xF5,0xBF,0xE0,0x00,0x00,0x07,0xFC,0x3F,0xC0,0x00,
0x00,0x1F,0xF2,0x4F,0xF8,0x00,0x00,0x07,0xFC,0x81,
0xFF,0x00,0x00,0x03,0xFE,0x03,0xFF,0x00,0x00,0x0F,
0xFC,0x03,0xFF,0x00,0x00,0x3F,0xF0,0x07,0xFF,0x00,
0x00,0xFF,0xE0,0x07,0xFF,0x00,0x03,0xFF,0x80,0x0F,
0xFF,0x00,0x0F,0xFF,0x00,0x0F,0xFF,0xC0,0xFF,0xFC,
0x00,0x0F,0xFF,0xFF,0xFF,0xF0,0x00,0x1F,0xFF,0xFF,
0xFF,0xC0,0x00,0x1F,0xFF,0xFF,0xFF,0x80,0x00,0x1F,
0xFF,0xFF,0xFE,0x00,0x00,0x0F,0xFF,0xFF,0xF0,0x00,
0x00,0x0F,0xFF,0xFF,0xC0,0x00,0x00,0x07,0xFF,0xFE,
0x00,0x00,0x00,0x00,0xFF,0xC0,0x00,0x00,0x06,0xE4,
0x2C,0x03,0x80,0x00,0x00,0x3F,0x80,0x00,0x00,0xFE,
0x00,0x00,0x1F,0xE0,0x00,0x03,0xFE,0x00,0x00,0x7F,
0xE0,0x00,0x0F,0xFE,0x00,0x01,0xFF,0xE0,0x00,0x3F,
0xFE,0x00,0x07,0xFF,0xE0,0x00,0xFF,0xFE,0x00,0x1F,
0xFF,0xE0,0x03,0xFF,0xFE,0x00,0xFF,0xFF,0xE0,0x1F,
0xFF,0xFE,0x07,0xFF,0xFF,0xE1,0xFF,0xFB,0xFE,0x7F,
0xFF,0x3F,0xEF,0xFF,0xE3,0xFE,0xFF,0xF8,0x3F,0xEF,
0xFF,0x03,0xFE,0xFF,0xC0,0x3F,0xEF,0xF8,0x03,0xFE,
0xFE,0x00,0x3F,0xEF,0x80,0x03,0xFE,0xE0,0x00,0x3F,
0xFA,0x00,0x00,0x7F,0xF4,0x00,0x00,0xFF,0xE8,0x00,
0x01,0xFF,0xD0,0x00,0x03,0xFF,0xA0,0x00,0x07,0xFF,
0x40,0x00,0x0F,0xFD,0x00,0x00,0x1F,0xF0,0x0B,0xE4,
0x0C,0x03,0x80,0x00,0x01,0xFF,0xC0,0x00,0x00,0x00,
0x1F,0xFF,0xFC,0x00,0x00,0x00,0x7F,0xFF,0xFF,0x00,
0x00,0x01,0xFF,0xFF,0xFF,0xC0,0x00,0x03,0xFF,0xFF,
0xFF,0xF0,0x00,0x0F,0xFF,0xFF,0xFF,0xF8,0x00,0x1F,
0xFF,0xFF,0xFF,0xFC,0x00,0x1F,0xFF,0xFF,0xFF,0xFE,
0x00,0x3F,0xFF,0x00,0x7F,0xFE,0x00,0x7F,0xFC,0x00,
0x0F,0xFF,0x00,0x7F,0xF0,0x00,0x07,0xFF,0x80,0xFF,
0xE0,0x00,0x03,0xFF,0x80,0xFF,0xC0,0x00,0x01,0xFF,
0xC1,0xFF,0x80,0x00,0x00,0xFF,0xC1,0xFF,0x00,0x00,
0x00,0x7F,0xC1,0xFF,0x00,0x00,0x00,0x7F,0xE3,0xFF,
0x00,0x00,0x00,0x3F,0xE9,0x7F,0xC0,0x00,0x00,0x07,
0xFC,0x07,0xC0,0x00,0x00,0x07,0xFD,0x00,0x00,0x00,
0x00,0x00,0xFF,0xA0,0x00,0x00,0x00,0x00,0x3F,0xF0,
0x00,0x00,0x00,0x00,0x3F,0xE4,0x00,0x00,0x00,0x00,
0x0F,0xFC,0x80,0x00,0x00,0x00,0x03,0xFF,0x00,0x00,
0x00,0x00,0x07,0xFE,0x00,0x00,0x00,0x00,0x0F,0xFE,
0x00,0x00,0x00,0x00,0x1F,0xFC,0x00,0x00,0x00,0x00,
0x3F,0xFC,0x00,0x00,0x00,0x00,0x7F,0xF8,0x00,0x00,
0x00,0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0xFF,0xF0,
0x00,0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,0x07,
0xFF,0xC0,0x00,0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,
0x00,0x1F,0xFF,0x00,0x00,0x00,0x00,0x3F,0xFE,0x00,
0x00,0x00,0x00,0x7F,0xFC,0x00,0x00,0x00,0x00,0xFF,
0xF8,0x00,0x00,0x00,0x01,0xFF,0xF0,0x00,0x00,0x00,
0x03,0xFF,0xE0,0x00,0x00,0x00,0x0F,0xFF,0xC0,0x00,
0x00,0x00,0x1F,0xFF,0x80,0x00,0x00,0x00,0x3F,0xFE,
0x00,0x00,0x00,0x00,0x7F,0xFC,0x00,0x00,0x00,0x00,
0xFF,0xF8,0x00,0x00,0x00,0x01,0xFF,0xF0,0x00,0x00,
0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,0x07,0xFF,0x80,
0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,0x00,0x1F,
0xFE,0x00,0x00,0x00,0x00,0x3F,0xFC,0x00,0x00,0x00,
0x00,0x7F,0xF8,0x00,0x00,0x00,0x00,0x7F,0xF0,0x00,
0x00,0x00,0x00,0xFF,0xE0,0x00,0x00,0x00,0x01,0xFF,
0xC0,0x00,0x00,0x00,0x01,0xFF,0x80,0x00,0x00,0x00,
0x03,0xFF,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,
0xFF,0xFF,0xF2,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x0B,0xA4,0x97,0xFB,
0x80,0x00,0x03,0xFE,0x00,0x00,0x00,0x00,0x3F,0xFF,
0xC0,0x00,0x00,0x01,0xFF,0xFF,0xE0,0x00,0x00,0x0F,
0xFF,0xFF,0xF0,0x00,0x00,0x3F,0xFF,0xFF,0xF0,0x00,
0x01,0xFF,0xFF,0xFF,0xF0,0x00,0x03,0xFF,0xFF,0xFF,
0xF0,0x00,0x0F,0xFF,0xFF,0xFF,0xF0,0x00,0x3F,0xFE,
0x01,0xFF,0xF0,0x00,0xFF,0xF0,0x00,0xFF,0xF0,0x01,
0xFF,0xC0,0x00,0xFF,0xE0,0x07,0xFF,0x00,0x00,0xFF,
0xE0,0x0F,0xFC,0x00,0x00,0xFF,0xC0,0x3F,0xF0,0x00,
0x00,0xFF,0x80,0x7F,0xE0,0x00,0x01,0xFF,0x80,0xFF,
0x80,0x00,0x01,0xFF,0x08,0x7F,0xE0,0x00,0x00,0x7F,
0xC0,0xFF,0x80,0x00,0x00,0xFF,0x80,0x1F,0x00,0x00,
0x01,0xFF,0x08,0x00,0x00,0x00,0x00,0x7F,0xC0,0x00,
0x00,0x00,0x01,0xFF,0x84,0x00,0x00,0x00,0x00,0x7F,
0xC0,0x00,0x00,0x00,0x01,0xFF,0x00,0x00,0x00,0x00,
0x07,0xFE,0x00,0x00,0x00,0x00,0x1F,0xF8,0x00,0x00,
0x00,0x00,0xFF,0xE0,0x00,0x00,0x00,0x0F,0xFF,0x80,
0x00,0x00,0x07,0xFF,0xFE,0x00,0x00,0x00,0x0F,0xFF,
0xF8,0x00,0x00,0x00,0x1F,0xFF,0xC0,0x00,0x00,0x00,
0x3F,0xFF,0xC0,0x00,0x00,0x00,0x7F,0xFF,0xF0,0x00,
0x00,0x00,0xFF,0xFF,0xF0,0x00,0x00,0x03,0xFF,0xFF,
0xF8,0x00,0x00,0x07,0x01,0xFF,0xF8,0x00,0x00,0x00,
0x00,0x7F,0xF8,0x00,0x00,0x00,0x00,0x7F,0xF8,0x00,
0x00,0x00,0x00,0x3F,0xF0,0x00,0x00,0x00,0x00,0x3F,
0xF0,0x00,0x00,0x00,0x00,0x3F,0xE0,0x00,0x00,0x00,
0x00,0x7F,0xE8,0x00,0x00,0x00,0x00,0x0F,0xF8,0x00,
0x00,0x00,0x00,0x1F,0xFD,0x80,0x00,0x00,0x00,0x03,
0xFE,0x0F,0x80,0x00,0x00,0x07,0xFD,0xFF,0x00,0x00,
0x00,0x0F,0xFB,0xFF,0x00,0x00,0x00,0x1F,0xF7,0xFE,
0x00,0x00,0x00,0x7F,0xE7,0xFC,0x00,0x00,0x00,0xFF,
0xA1,0xFF,0x80,0x00,0x00,0x7F,0xE3,0xFF,0x80,0x00,
0x01,0xFF,0x83,0xFF,0x00,0x00,0x07,0xFF,0x07,0xFF,
0x00,0x00,0x1F,0xFC,0x07,0xFF,0x00,0x00,0x7F,0xF8,
0x07,0xFF,0x80,0x01,0xFF,0xE0,0x0F,0xFF,0xC0,0x1F,
0xFF,0x80,0x0F,0xFF,0xFF,0xFF,0xFE,0x00,0x0F,0xFF,
0xFF,0xFF,0xF8,0x00,0x0F,0xFF,0xFF,0xFF,0xE0,0x00,
0x0F,0xFF,0xFF,0xFF,0x80,0x00,0x07,0xFF,0xFF,0xFC,
0x00,0x00,0x07,0xFF,0xFF,0xF0,0x00,0x00,0x01,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x7F,0xF0,0x00,0x00,0x0C,
0xA3,0x84,0x03,0x80,0x00,0x00,0x00,0x01,0xFC,0x00,
0x00,0x00,0x00,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,
0x1F,0xF0,0x04,0x00,0x00,0x00,0x00,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x3F,0xF8,0x00,0x00,0x00,0x00,0x0F,
0xFF,0x00,0x40,0x00,0x00,0x00,0x7F,0xFC,0x00,0x00,
0x00,0x00,0x1F,0xFF,0x80,0x00,0x00,0x00,0x07,0xFF,
0xF0,0x04,0x00,0x00,0x00,0x3F,0xFF,0xC0,0x00,0x00,
0x00,0x0F,0xFF,0xF8,0x00,0x00,0x00,0x03,0xFF,0xFF,
0x00,0x40,0x00,0x00,0x1F,0xFF,0xFC,0x00,0x00,0x00,
0x07,0xFF,0xFF,0x80,0x00,0x00,0x01,0xFF,0xDF,0xF0,
0x00,0x00,0x00,0x7F,0xF3,0xFE,0x00,0x00,0x00,0x1F,
0xFE,0x7F,0xC0,0x00,0x00,0x03,0xFF,0x8F,0xF8,0x00,
0x00,0x00,0xFF,0xE1,0xFF,0x00,0x00,0x00,0x3F,0xF8,
0x3F,0xE0,0x00,0x00,0x0F,0xFF,0x07,0xFC,0x00,0x00,
0x01,0xFF,0xC0,0xFF,0x80,0x00,0x00,0x7F,0xF0,0x1F,
0xF0,0x00,0x00,0x1F,0xFC,0x03,0xFE,0x00,0x80,0x00,
0xFF,0xE0,0x0F,0xF8,0x00,0x00,0x3F,0xF8,0x01,0xFF,
0x00,0x00,0x0F,0xFE,0x00,0x3F,0xE0,0x08,0x00,0x7F,
0xF0,0x00,0xFF,0x80,0x00,0x1F,0xFC,0x00,0x1F,0xF0,
0x00,0x07,0xFF,0x00,0x03,0xFE,0x00,0x80,0x3F,0xF8,
0x00,0x0F,0xF8,0x00,0x0F,0xFE,0x00,0x01,0xFF,0x00,
0x03,0xFF,0x80,0x00,0x3F,0xE0,0x08,0x1F,0xFC,0x00,
0x00,0xFF,0x80,0x07,0xFF,0x00,0x00,0x1F,0xF0,0x01,
0xFF,0xC0,0x00,0x03,0xFE,0x00,0x7F,0xF0,0x00,0x00,
0x7F,0xC0,0x1B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC7,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xA0,0x00,0x00,0x00,
0x1F,0xF0,0x06,0x80,0x00,0x00,0x00,0x7F,0xC0,0x12,
0x00,0x00,0x00,0x01,0xFF,0x00,0x00,0x0B,0xA4,0x17,
0xFB,0x89,0x00,0xFF,0xFF,0xFF,0xFF,0xC2,0xC0,0x7F,
0xFF,0xFF,0xFF,0xF0,0x01,0xFF,0xFF,0xFF,0xFF,0xE1,
0x40,0x7F,0xC0,0x00,0x00,0x00,0x01,0xFF,0x80,0x00,
0x00,0x00,0xA0,0x7F,0xC0,0x00,0x00,0x00,0x01,0xFF,
0x80,0x00,0x00,0x00,0x50,0x7F,0xC0,0x00,0x00,0x00,
0x00,0xFF,0x80,0x7F,0x80,0x00,0x03,0xFF,0x0F,0xFF,
0xF0,0x00,0x07,0xFC,0x7F,0xFF,0xF8,0x00,0x0F,0xF9,
0xFF,0xFF,0xF8,0x00,0x1F,0xFF,0xFF,0xFF,0xFC,0x00,
0x3F,0xFF,0xFF,0xFF,0xFC,0x00,0xFF,0xFF,0xFF,0xFF,
0xFC,0x01,0xFF,0xFF,0xFF,0xFF,0xFC,0x03,0xFF,0xFC,
0x01,0xFF,0xF8,0x07,0xFF,0xE0,0x00,0x7F,0xF8,0x0F,
0xFF,0x00,0x00,0x7F,0xF8,0x3F,0xFC,0x00,0x00,0x3F,
0xF0,0x7F,0xF0,0x00,0x00,0x3F,0xF0,0xFF,0xC0,0x00,
0x00,0x7F,0xE0,0x1F,0x00,0x00,0x00,0x7F,0xE0,0x00,
0x00,0x00,0x00,0xFF,0xD0,0x00,0x00,0x00,0x00,0x1F,
0xF0,0x00,0x00,0x00,0x00,0x3F,0xFD,0x00,0x00,0x00,
0x00,0x07,0xFE,0x00,0x00,0x00,0x00,0x01,0xFF,0x07,
0xC0,0x00,0x00,0x03,0xFF,0x1F,0xF0,0x00,0x00,0x01,
0xFF,0x3F,0xF0,0x00,0x00,0x03,0xFE,0x3F,0xE0,0x00,
0x00,0x0F,0xFC,0x7F,0xC0,0x00,0x00,0x1F,0xF0,0xFF,
0xC0,0x00,0x00,0x7F,0xE1,0xFF,0xC0,0x00,0x00,0xFF,
0x81,0xFF,0x80,0x00,0x03,0xFF,0x03,0xFF,0x80,0x00,
0x0F,0xFC,0x03,0xFF,0x80,0x00,0x3F,0xF8,0x07,0xFF,
0xC0,0x01,0xFF,0xE0,0x07,0xFF,0xE0,0x1F,0xFF,0x80,
0x07,0xFF,0xFF,0xFF,0xFE,0x00,0x07,0xFF,0xFF,0xFF,
0xFC,0x00,0x07,0xFF,0xFF,0xFF,0xF0,0x00,0x07,0xFF,
0xFF,0xFF,0x80,0x00,0x07,0xFF,0xFF,0xFE,0x00,0x00,
0x03,0xFF,0xFF,0xF0,0x00,0x00,0x01,0xFF,0xFF,0x80,
0x00,0x00,0x00,0x3F,0xF0,0x00,0x00,0x0C,0x24,0x8F,
0xFB,0x80,0x00,0x00,0x3F,0xF0,0x00,0x00,0x00,0x01,
0xFF,0xFF,0x80,0x00,0x00,0x03,0xFF,0xFF,0xF0,0x00,
0x00,0x07,0xFF,0xFF,0xFC,0x00,0x00,0x07,0xFF,0xFF,
0xFF,0x80,0x00,0x0F,0xFF,0xFF,0xFF,0xE0,0x00,0x0F,
0xFF,0xFF,0xFF,0xF8,0x00,0x0F,0xFF,0xFF,0xFF,0xFE,
0x00,0x07,0xFF,0xE0,0x3F,0xFF,0x00,0x07,0xFF,0x80,
0x03,0xFF,0xC0,0x07,0xFF,0x00,0x00,0xFF,0xE0,0x07,
0xFF,0x00,0x00,0x3F,0xF8,0x03,0xFF,0x00,0x00,0x0F,
0xFC,0x40,0x7F,0xE0,0x00,0x00,0x7F,0xE0,0x3F,0xE0,
0x00,0x00,0x1F,0xF0,0x3F,0xF0,0x00,0x00,0x0F,0xFC,
0x1F,0xF0,0x00,0x00,0x07,0xFE,0x1F,0xF8,0x00,0x00,
0x01,0xFF,0x0F,0xF8,0x00,0x00,0x00,0xF8,0x07,0xFC,
0x00,0x00,0x00,0x00,0x03,0xFC,0x00,0x00,0x00,0x00,
0x09,0x7F,0xC0,0x00,0x00,0x00,0x00,0x3F,0xE0,0x01,
0xFF,0x00,0x00,0x1F,0xE0,0x07,0xFF,0xF0,0x00,0x0F,
0xF0,0x0F,0xFF,0xFF,0x00,0x0F,0xF8,0x1F,0xFF,0xFF,
0xC0,0x07,0xFC,0x1F,0xFF,0xFF,0xF8,0x03,0xFE,0x3F,
0xFF,0xFF,0xFE,0x01,0xFF,0x3F,0xFF,0xFF,0xFF,0x80,
0xFF,0xBF,0xFF,0xFF,0xFF,0xE0,0x7F,0xDF,0xF8,0x07,
0xFF,0xF0,0x3F,0xFF,0xE0,0x00,0x7F,0xFC,0x1F,0xFF,
0xE0,0x00,0x0F,0xFF,0x0F,0xFF,0xC0,0x00,0x03,0xFF,
0x87,0xFF,0xC0,0x00,0x00,0xFF,0xE3,0xFF,0xC0,0x00,
0x00,0x3F,0xF2,0x3F,0xF8,0x00,0x00,0x01,0xFF,0xA3,
0xFF,0x00,0x00,0x00,0x0F,0xF9,0xFF,0x80,0x00,0x00,
0x07,0xFF,0x3F,0xF0,0x00,0x00,0x00,0x3F,0xF8,0xFF,
0x00,0x00,0x00,0x03,0xFE,0x3F,0xC0,0x00,0x00,0x03,
0xFF,0x83,0xFC,0x00,0x00,0x00,0x3F,0xE1,0xFF,0x00,
0x00,0x00,0x1F,0xF0,0x7F,0x80,0x00,0x00,0x1F,0xF8,
0x3F,0xE0,0x00,0x00,0x0F,0xF8,0x0F,0xF8,0x00,0x00,
0x0F,0xFC,0x07,0xFE,0x00,0x00,0x0F,0xFC,0x01,0xFF,
0x80,0x00,0x0F,0xFE,0x00,0xFF,0xE0,0x00,0x0F,0xFE,
0x00,0x3F,0xFC,0x00,0x1F,0xFF,0x00,0x0F,0xFF,0x80,
0x3F,0xFF,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0x00,0x01,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x3F,0xFF,0xFF,0xFF,
0x00,0x00,0x0F,0xFF,0xFF,0xFF,0x00,0x00,0x03,0xFF,
0xFF,0xFF,0x00,0x00,0x00,0x7F,0xFF,0xFE,0x00,0x00,
0x00,0x0F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x7F,0xE0,
0x00,0x00,0x0B,0xE3,0x90,0x03,0x8D,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x03,
0xF8,0x00,0x00,0x00,0x00,0x07,0xF0,0x00,0x00,0x00,
0x00,0x0F,0xE0,0x00,0x00,0x00,0x00,0x1F,0xE0,0x00,
0x00,0x00,0x00,0x3F,0xC0,0x00,0x00,0x00,0x00,0x7F,
0x81,0x00,0x00,0x00,0x00,0x1F,0xE0,0x00,0x00,0x00,
0x00,0x3F,0xC0,0x20,0x00,0x00,0x00,0x0F,0xF0,0x00,
0x00,0x00,0x00,0x1F,0xE0,0x00,0x00,0x00,0x00,0x3F,
0xE0,0x00,0x00,0x00,0x00,0x3F,0xC0,0x00,0x00,0x00,
0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0xFF,0x80,0x00,
0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x01,0xFF,
0x00,0x04,0x00,0x00,0x00,0x7F,0xC0,0x00,0x80,0x00,
0x00,0x1F,0xF0,0x00,0x10,0x00,0x00,0x07,0xFC,0x00,
0x02,0x00,0x00,0x01,0xFF,0x00,0x00,0x40,0x00,0x00,
0x7F,0xC0,0x00,0x08,0x00,0x00,0x1F,0xF0,0x00,0x01,
0x20,0x00,0x07,0xFC,0x00,0x00,0x24,0x00,0x01,0xFF,
0x00,0x00,0x04,0x80,0x00,0x7F,0xC0,0x00,0x00,0x90,
0x00,0x1F,0xF0,0x00,0x00,0x12,0x00,0x07,0xFC,0x00,
0x00,0x00,0x00,0x07,0xF8,0x00,0x00,0x02,0x80,0x01,
0xFF,0x00,0x00,0x00,0x58,0x00,0x7F,0xC0,0x00,0x00,
0x08,0x00,0x1F,0xF8,0x00,0x00,0x01,0x60,0x03,0xFE,
0x00,0x00,0x00,0x00,0x0B,0xA4,0x97,0xFB,0x80,0x00,
0x01,0xFF,0x80,0x00,0x00,0x00,0x3F,0xFF,0xF0,0x00,
0x00,0x01,0xFF,0xFF,0xF8,0x00,0x00,0x0F,0xFF,0xFF,
0xFC,0x00,0x00,0x3F,0xFF,0xFF,0xFC,0x00,0x01,0xFF,
0xFF,0xFF,0xFC,0x00,0x07,0xFF,0xFF,0xFF,0xFC,0x00,
0x0F,0xFF,0xFF,0xFF,0xFC,0x00,0x3F,0xFF,0x00,0xFF,
0xFC,0x00,0xFF,0xF0,0x00,0x3F,0xFC,0x01,0xFF,0xC0,
0x00,0x3F,0xF8,0x07,0xFF,0x00,0x00,0x3F,0xF8,0x0F,
0xFC,0x00,0x00,0x3F,0xF0,0x1F,0xF0,0x00,0x00,0x3F,
0xE0,0x7F,0xE0,0x00,0x00,0x7F,0xE6,0x9F,0xF0,0x00,
0x00,0x0F,0xF8,0x3F,0xF0,0x00,0x00,0x3F,0xF0,0x3F,
0xE0,0x00,0x00,0x7F,0xC0,0x7F,0xE0,0x00,0x01,0xFF,
0x80,0x7F,0xE0,0x00,0x07,0xFE,0x00,0xFF,0xE0,0x00,
0x1F,0xFC,0x00,0xFF,0xE0,0x00,0x7F,0xF0,0x00,0xFF,
0xF8,0x07,0xFF,0xC0,0x00,0xFF,0xFF,0xFF,0xFF,0x00,
0x00,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x7F,0xFF,0xFF,
0xE0,0x00,0x00,0x3F,0xFF,0xFF,0x00,0x00,0x00,0xFF,
0xFF,0xFF,0x00,0x00,0x07,0xFF,0xFF,0xFF,0x80,0x00,
0x3F,0xFF,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0xFF,0xFF,
0xC0,0x03,0xFF,0xF0,0x0F,0xFF,0xC0,0x0F,0xFF,0x00,
0x03,0xFF,0xC0,0x3F,0xF8,0x00,0x03,0xFF,0xC0,0xFF,
0xE0,0x00,0x01,0xFF,0x81,0xFF,0x80,0x00,0x01,0xFF,
0x87,0xFE,0x00,0x00,0x03,0xFF,0x0F,0xFC,0x00,0x00,
0x03,0xFF,0x43,0xFE,0x00,0x00,0x00,0x7F,0xCF,0xFC,
0x00,0x00,0x00,0xFF,0xF7,0xFE,0x00,0x00,0x00,0x1F,
0xF7,0xFC,0x00,0x00,0x00,0x3F,0xEF,0xFC,0x00,0x00,
0x00,0xFF,0xE1,0xFF,0x00,0x00,0x00,0x3F,0xE3,0xFF,
0x00,0x00,0x00,0xFF,0xC3,0xFE,0x00,0x00,0x01,0xFF,
0x07,0xFE,0x00,0x00,0x07,0xFE,0x0F,0xFE,0x00,0x00,
0x1F,0xFC,0x0F,0xFE,0x00,0x00,0x7F,0xF0,0x0F,0xFF,
0x00,0x03,0xFF,0xC0,0x1F,0xFF,0xC0,0x3F,0xFF,0x80,
0x1F,0xFF,0xFF,0xFF,0xFE,0x00,0x1F,0xFF,0xFF,0xFF,
0xF8,0x00,0x1F,0xFF,0xFF,0xFF,0xE0,0x00,0x1F,0xFF,
0xFF,0xFF,0x80,0x00,0x0F,0xFF,0xFF,0xFC,0x00,0x00,
0x0F,0xFF,0xFF,0xE0,0x00,0x00,0x03,0xFF,0xFF,0x00,
0x00,0x00,0x00,0x7F,0xE0,0x00,0x00,0x0B,0xA4,0x97,
0xFB,0x80,0x00,0x03,0xFF,0x00,0x00,0x00,0x00,0x3F,
0xFF,0xC0,0x00,0x00,0x01,0xFF,0xFF,0xE0,0x00,0x00,
0x0F,0xFF,0xFF,0xF0,0x00,0x00,0x3F,0xFF,0xFF,0xF0,
0x00,0x01,0xFF,0xFF,0xFF,0xF8,0x00,0x07,0xFF,0xFF,
0xFF,0xF8,0x00,0x0F,0xFF,0xFF,0xFF,0xF8,0x00,0x3F,
0xFF,0x80,0xFF,0xF8,0x00,0xFF,0xF8,0x00,0x3F,0xF0,
0x03,0xFF,0xC0,0x00,0x3F,0xF0,0x07,0xFF,0x00,0x00,
0x3F,0xF0,0x1F,0xFC,0x00,0x00,0x3F,0xE0,0x3F,0xF0,
0x00,0x00,0x3F,0xE0,0x7F,0xE0,0x00,0x00,0x3F,0xC1,
0xFF,0x80,0x00,0x00,0x7F,0x83,0xFF,0x00,0x00,0x00,
0x7F,0x87,0xFC,0x00,0x00,0x00,0xFF,0x1F,0xF8,0x00,
0x00,0x01,0xFE,0x3F,0xF0,0x00,0x00,0x01,0xFE,0xBF,
0xF8,0x00,0x00,0x00,0x7F,0xAB,0xFE,0x00,0x00,0x00,
0x1F,0xF7,0xFC,0x00,0x00,0x00,0x7F,0xF0,0xFF,0x80,
0x00,0x00,0x1F,0xFC,0x3F,0xF0,0x00,0x00,0x0F,0xFE,
0x3F,0xF0,0x00,0x00,0x3F,0xFC,0x7F,0xF0,0x00,0x00,
0xFF,0xF8,0xFF,0xE0,0x00,0x03,0xFF,0xF0,0xFF,0xF0,
0x00,0x0F,0xFF,0xE0,0xFF,0xF0,0x00,0x3F,0xFF,0xC1,
0xFF,0xFC,0x03,0xFE,0xFF,0x81,0xFF,0xFF,0xFF,0xFD,
0xFF,0x01,0xFF,0xFF,0xFF,0xF3,0xFE,0x01,0xFF,0xFF,
0xFF,0xC7,0xFC,0x01,0xFF,0xFF,0xFF,0x0F,0xF8,0x01,
0xFF,0xFF,0xF8,0x1F,0xF0,0x00,0xFF,0xFF,0xE0,0x3F,
0xC0,0x00,0x7F,0xFF,0x00,0x7F,0x80,0x00,0x1F,0xF0,
0x01,0xFF,0x48,0x00,0x00,0x00,0x00,0x7F,0xC0,0x00,
0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x03,0xFE,
0x01,0xF0,0x00,0x00,0x07,0xFC,0x3F,0xE0,0x00,0x00,
0x0F,0xF8,0x7F,0xC0,0x00,0x00,0x3F,0xE0,0xFF,0xC0,
0x00,0x00,0x7F,0xC0,0xFF,0x80,0x00,0x01,0xFF,0x81,
0xFF,0x00,0x00,0x03,0xFE,0x03,0xFF,0x00,0x00,0x0F,
0xFC,0x07,0xFF,0x00,0x00,0x1F,0xF0,0x07,0xFE,0x00,
0x00,0x7F,0xE0,0x0F,0xFE,0x00,0x03,0xFF,0x80,0x0F,
0xFF,0x00,0x0F,0xFE,0x00,0x1F,0xFF,0x80,0xFF,0xFC,
0x00,0x1F,0xFF,0xFF,0xFF,0xF0,0x00,0x1F,0xFF,0xFF,
0xFF,0xC0,0x00,0x1F,0xFF,0xFF,0xFF,0x00,0x00,0x1F,
0xFF,0xFF,0xFC,0x00,0x00,0x1F,0xFF,0xFF,0xE0,0x00,
0x00,0x0F,0xFF,0xFF,0x80,0x00,0x00,0x07,0xFF,0xF8,
0x00,0x00,0x00,0x01,0xFF,0x80,0x00,0x00,0x02,0x5A,
0x24,0x01,0xCD,0xFF,0xC7,0xFF,0x40,0x1A,0x00,0xD0,
0x06,0x80,0x30,0x01,0xBF,0xF8,0xFF,0x80,0x02,0x61,
0xA7,0x89,0xCD,0xFF,0xC7,0xFF,0x40,0x1A,0x00,0xD0,
0x06,0x80,0x30,0x01,0xBF,0xF8,0xFF,0xE0,0x7C,0x1E,
0x81,0xF0,0xF8,0x7E,0x3F,0x07,0x81,0xC0,0x20,0x00,
0x0B,0x97,0x98,0x63,0xA0,0x00,0x00,0x00,0x00,0x00,
0x20,0x00,0x00,0x00,0x00,0x01,0xC0,0x00,0x00,0x00,
0x00,0x1F,0x80,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,
0x00,0x00,0x07,0xFE,0x00,0x00,0x00,0x00,0x7F,0xFC,
0x00,0x00,0x00,0x03,0xFF,0xF8,0x00,0x00,0x00,0x1F,
0xFF,0xF0,0x00,0x00,0x01,0xFF,0xFF,0xE0,0x00,0x00,
0x0F,0xFF,0xFF,0x80,0x00,0x00,0x7F,0xFF,0xF8,0x00,
0x00,0x03,0xFF,0xFF,0xC0,0x00,0x00,0x3F,0xFF,0xFC,
0x00,0x00,0x01,0xFF,0xFF,0xE0,0x00,0x00,0x0F,0xFF,
0xFE,0x00,0x00,0x00,0xFF,0xFF,0xE0,0x00,0x00,0x07,
0xFF,0xFF,0x00,0x00,0x00,0x3F,0xFF,0xF0,0x00,0x00,
0x03,0xFF,0xFF,0x80,0x00,0x00,0x1F,0xFF,0xF8,0x00,
0x00,0x00,0x7F,0xFF,0xC0,0x00,0x00,0x00,0xFF,0xFC,
0x00,0x00,0x00,0x01,0xFF,0xE0,0x00,0x00,0x00,0x03,
0xFE,0x00,0x00,0x00,0x00,0x07,0xFF,0x80,0x00,0x00,
0x00,0x0F,0xFF,0xC0,0x00,0x00,0x00,0x1F,0xFF,0xF0,
0x00,0x00,0x00,0x1F,0xFF,0xF8,0x00,0x00,0x00,0x0F,
0xFF,0xFE,0x00,0x00,0x00,0x03,0xFF,0xFF,0x00,0x00,
0x00,0x01,0xFF,0xFF,0xC0,0x00,0x00,0x00,0xFF,0xFF,
0xE0,0x00,0x00,0x00,0x3F,0xFF,0xF8,0x00,0x00,0x00,
0x1F,0xFF,0xFE,0x00,0x00,0x00,0x0F,0xFF,0xFF,0x00,
0x00,0x00,0x03,0xFF,0xFF,0xC0,0x00,0x00,0x01,0xFF,
0xFF,0xE0,0x00,0x00,0x00,0xFF,0xFF,0xF8,0x00,0x00,
0x00,0x7F,0xFF,0xF8,0x00,0x00,0x00,0x1F,0xFF,0xF0,
0x00,0x00,0x00,0x0F,0xFF,0xE0,0x00,0x00,0x00,0x07,
0xFF,0xC0,0x00,0x00,0x00,0x01,0xFF,0x80,0x00,0x00,
0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,
0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,
0x08,0x0B,0xCF,0x14,0xA3,0xAD,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xF4,0x00,
0x00,0x00,0x00,0x00,0x05,0x80,0x00,0x00,0x00,0x00,
0x00,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF1,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFC,0x0B,0x97,0x98,0x63,0xA4,0x00,
0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,
0x1F,0x80,0x00,0x00,0x00,0x00,0x3F,0xC0,0x00,0x00,
0x00,0x00,0x7F,0xE0,0x00,0x00,0x00,0x00,0xFF,0xF8,
0x00,0x00,0x00,0x01,0xFF,0xFC,0x00,0x00,0x00,0x03,
0xFF,0xFE,0x00,0x00,0x00,0x07,0xFF,0xFF,0x80,0x00,
0x00,0x07,0xFF,0xFF,0xC0,0x00,0x00,0x01,0xFF,0xFF,
0xE0,0x00,0x00,0x00,0xFF,0xFF,0xF0,0x00,0x00,0x00,
0x3F,0xFF,0xFC,0x00,0x00,0x00,0x1F,0xFF,0xFE,0x00,
0x00,0x00,0x07,0xFF,0xFF,0x00,0x00,0x00,0x01,0xFF,
0xFF,0xC0,0x00,0x00,0x00,0xFF,0xFF,0xE0,0x00,0x00,
0x00,0x3F,0xFF,0xF0,0x00,0x00,0x00,0x1F,0xFF,0xFC,
0x00,0x00,0x00,0x07,0xFF,0xFE,0x00,0x00,0x00,0x03,
0xFF,0xFE,0x00,0x00,0x00,0x00,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x7F,0xF8,0x00,0x00,0x00,0x00,0x1F,0xF0,
0x00,0x00,0x00,0x01,0xFF,0xE0,0x00,0x00,0x00,0x0F,
0xFF,0xC0,0x00,0x00,0x00,0xFF,0xFF,0x80,0x00,0x00,
0x07,0xFF,0xFE,0x00,0x00,0x00,0x7F,0xFF,0xF0,0x00,
0x00,0x03,0xFF,0xFF,0x00,0x00,0x00,0x3F,0xFF,0xF8,
0x00,0x00,0x01,0xFF,0xFF,0xC0,0x00,0x00,0x1F,0xFF,
0xFC,0x00,0x00,0x01,0xFF,0xFF,0xE0,0x00,0x00,0x0F,
0xFF,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xF0,0x00,0x00,
0x07,0xFF,0xFF,0x80,0x00,0x00,0x7F,0xFF,0xFC,0x00,
0x00,0x01,0xFF,0xFF,0xE0,0x00,0x00,0x03,0xFF,0xFE,
0x00,0x00,0x00,0x07,0xFF,0xF0,0x00,0x00,0x00,0x0F,
0xFF,0x80,0x00,0x00,0x00,0x1F,0xF8,0x00,0x00,0x00,
0x00,0x3F,0xC0,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,
0x00,0x00,0x00,0xE0,0x00,0x00,0x00,0x00,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x0B,0xA4,0x94,0x03,0x80,
0x00,0x01,0xFF,0xC0,0x00,0x00,0x00,0x3F,0xFF,0xF8,
0x00,0x00,0x01,0xFF,0xFF,0xFC,0x00,0x00,0x0F,0xFF,
0xFF,0xFE,0x00,0x00,0x7F,0xFF,0xFF,0xFE,0x00,0x01,
0xFF,0xFF,0xFF,0xFE,0x00,0x07,0xFF,0xFF,0xFF,0xFE,
0x00,0x1F,0xFF,0xFF,0xFF,0xFE,0x00,0x7F,0xFF,0x00,
0xFF,0xFE,0x00,0xFF,0xF8,0x00,0x3F,0xFE,0x03,0xFF,
0xC0,0x00,0x3F,0xFC,0x07,0xFF,0x00,0x00,0x1F,0xFC,
0x1F,0xFC,0x00,0x00,0x1F,0xFC,0x3F,0xF0,0x00,0x00,
0x3F,0xF8,0xFF,0xC0,0x00,0x00,0x3F,0xF1,0xFF,0x80,
0x00,0x00,0x3F,0xE3,0xFE,0x00,0x00,0x00,0x7F,0xE7,
0xFC,0x00,0x00,0x00,0x7F,0xE3,0xFF,0x00,0x00,0x00,
0x1F,0xF7,0xFC,0x00,0x00,0x00,0x3F,0xE0,0xF8,0x00,
0x00,0x00,0x7F,0xE0,0x00,0x00,0x00,0x00,0x1F,0xF8,
0x00,0x00,0x00,0x00,0x0F,0xF8,0x00,0x00,0x00,0x00,
0x3F,0xF0,0x00,0x00,0x00,0x00,0xFF,0xC0,0x00,0x00,
0x00,0x03,0xFF,0x80,0x00,0x00,0x00,0x0F,0xFE,0x00,
0x00,0x00,0x00,0x3F,0xFC,0x00,0x00,0x00,0x00,0xFF,
0xF0,0x00,0x00,0x00,0x03,0xFF,0xC0,0x00,0x00,0x00,
0x0F,0xFF,0x00,0x00,0x00,0x00,0x3F,0xFC,0x00,0x00,
0x00,0x00,0xFF,0xF0,0x00,0x00,0x00,0x03,0xFF,0xC0,
0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,0x00,0x3F,
0xFC,0x00,0x00,0x00,0x00,0xFF,0xF0,0x00,0x00,0x00,
0x03,0xFF,0xC0,0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,
0x00,0x00,0x1F,0xFC,0x00,0x00,0x00,0x00,0x7F,0xF0,
0x00,0x00,0x00,0x00,0xFF,0xC0,0x00,0x10,0x00,0x00,
0x7F,0xE0,0x00,0x00,0x00,0x00,0xFF,0x80,0x00,0x08,
0x00,0x00,0x7F,0xE0,0x00,0x03,0x40,0x00,0x1F,0xF0,
0x00,0x00,0xD0,0x00,0x00,0x00,0x00,0x00,0x34,0x00,
0x01,0xFF,0x00,0x00,0x08,0x00,0x00,0x7F,0xC0,0x00,
0x00,0x17,0x2F,0x17,0x5E,0x60,0x00,0x00,0x00,0x00,
0x07,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x07,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFE,0x00,
0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,
0xFC,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,
0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x07,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,
0x00,0x00,0x0F,0xFF,0xFF,0xE0,0x00,0x7F,0xFF,0xFE,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xE0,0x00,0x00,0x3F,
0xFF,0xF8,0x00,0x00,0x00,0x0F,0xFF,0xF8,0x00,0x00,
0x00,0x1F,0xFF,0xE0,0x00,0x00,0x00,0xFF,0xFE,0x00,
0x00,0x00,0x00,0x3F,0xFF,0x80,0x00,0x00,0x0F,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x7F,0xFE,0x00,0x00,0x00,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0xFF,0xF8,0x00,
0x00,0x0F,0xFF,0x80,0x00,0x00,0x00,0x00,0x01,0xFF,
0xC0,0x00,0x00,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,
0x07,0xFF,0x00,0x00,0x07,0xFF,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0xFC,0x00,0x00,0x7F,0xF0,0x00,0x00,
0x00,0x00,0x00,0x00,0x7F,0xF0,0x00,0x07,0xFE,0x00,
0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0x80,0x00,0x3F,
0xE0,0x00,0x00,0x7F,0x00,0x00,0x00,0x07,0xFE,0x00,
0x03,0xFE,0x00,0x00,0x1F,0xFF,0x00,0x3F,0xE0,0x1F,
0xF0,0x00,0x3F,0xF0,0x00,0x03,0xFF,0xFE,0x01,0xFF,
0x00,0x7F,0xC0,0x01,0xFF,0x00,0x00,0x7F,0xFF,0xF8,
0x1F,0xF0,0x01,0xFE,0x00,0x1F,0xF0,0x00,0x07,0xFF,
0xFF,0xE0,0xFF,0x80,0x0F,0xF8,0x00,0xFF,0x00,0x00,
0xFF,0xFF,0xFF,0x87,0xFC,0x00,0x3F,0xC0,0x0F,0xF8,
0x00,0x0F,0xFF,0xFF,0xFE,0x3F,0xE0,0x01,0xFE,0x00,
0x7F,0x80,0x00,0xFF,0xFF,0xFF,0xFB,0xFF,0x00,0x07,
0xF8,0x07,0xF8,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xF0,
0x00,0x3F,0xC0,0x3F,0xC0,0x00,0x7F,0xFE,0x07,0xFF,
0xFF,0x80,0x01,0xFE,0x01,0xFC,0x00,0x07,0xFF,0x80,
0x07,0xFF,0xFC,0x00,0x07,0xF0,0x1F,0xE0,0x00,0x7F,
0xF8,0x00,0x1F,0xFF,0xE0,0x00,0x3F,0x80,0xFE,0x00,
0x03,0xFF,0x80,0x00,0x7F,0xFE,0x00,0x01,0xFE,0x0F,
0xF0,0x00,0x3F,0xF8,0x00,0x01,0xFF,0xF0,0x00,0x07,
0xF0,0x7F,0x80,0x03,0xFF,0x80,0x00,0x0F,0xFF,0x80,
0x00,0x3F,0x83,0xF8,0x00,0x1F,0xF8,0x00,0x00,0x3F,
0xFC,0x00,0x01,0xFC,0x1F,0xC0,0x01,0xFF,0x80,0x00,
0x01,0xFF,0xC0,0x00,0x0F,0xE1,0xFE,0x00,0x0F,0xFC,
0x00,0x00,0x07,0xFE,0x00,0x00,0x7F,0x0F,0xE0,0x00,
0x7F,0xC0,0x00,0x00,0x3F,0xF0,0x00,0x03,0xF8,0x7F,
0x00,0x07,0xFE,0x00,0x00,0x01,0xFF,0x80,0x00,0x1F,
0xC3,0xF8,0x00,0x3F,0xE0,0x00,0x00,0x0F,0xFC,0x00,
0x00,0xFE,0x1F,0xC0,0x03,0xFF,0x00,0x00,0x00,0x7F,
0xC0,0x00,0x07,0xF1,0xFE,0x00,0x1F,0xF8,0x00,0x00,
0x03,0xFE,0x00,0x00,0x3F,0x8F,0xE0,0x00,0xFF,0x80,
0x00,0x00,0x1F,0xF0,0x00,0x03,0xFC,0x7F,0x00,0x07,
0xFC,0x00,0x00,0x00,0xFF,0x80,0x00,0x1F,0xC3,0xF8,
0x00,0x7F,0xE0,0x00,0x00,0x07,0xF8,0x00,0x00,0xFE,
0x1F,0xC0,0x03,0xFF,0x00,0x00,0x00,0x7F,0xC0,0x00,
0x07,0xF1,0x1F,0xC0,0x03,0xFE,0x00,0x00,0x00,0x7F,
0xC0,0x00,0x0F,0xF0,0xFE,0x00,0x1F,0xF0,0x00,0x00,
0x03,0xFC,0x00,0x00,0xFF,0x07,0xF0,0x00,0xFF,0x80,
0x00,0x00,0x3F,0xE0,0x00,0x07,0xF8,0x47,0xF0,0x00,
0xFF,0x80,0x00,0x00,0x3F,0xE0,0x00,0x0F,0xF0,0x3F,
0x80,0x07,0xFC,0x00,0x00,0x03,0xFF,0x00,0x00,0xFF,
0x81,0xFC,0x00,0x3F,0xE0,0x00,0x00,0x1F,0xF0,0x00,
0x07,0xF8,0x0F,0xE0,0x01,0xFF,0x00,0x00,0x01,0xFF,
0x80,0x00,0x7F,0xC0,0x7F,0x80,0x0F,0xFC,0x00,0x00,
0x1F,0xFC,0x00,0x07,0xFC,0x01,0xFC,0x00,0x3F,0xE0,
0x00,0x00,0xFF,0xE0,0x00,0x7F,0xC0,0x0F,0xE0,0x01,
0xFF,0x80,0x00,0x0F,0xFE,0x00,0x07,0xFE,0x00,0x7F,
0x00,0x0F,0xFC,0x00,0x00,0xFF,0xF0,0x00,0x7F,0xE0,
0x03,0xF8,0x00,0x3F,0xF0,0x00,0x0F,0xFF,0x80,0x07,
0xFE,0x00,0x1F,0xE0,0x01,0xFF,0xC0,0x01,0xFF,0xFC,
0x00,0xFF,0xE0,0x00,0xFF,0x00,0x0F,0xFF,0x00,0x3F,
0xFF,0xF0,0x1F,0xFF,0x00,0x03,0xF8,0x00,0x3F,0xFE,
0x07,0xFF,0xFF,0xC3,0xFF,0xF0,0x00,0x1F,0xE0,0x01,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xFF,
0x00,0x07,0xFF,0xFF,0xFF,0x7F,0xFF,0xFF,0xF0,0x00,
0x03,0xFC,0x00,0x1F,0xFF,0xFF,0xFB,0xFF,0xFF,0xFF,
0x00,0x00,0x1F,0xE0,0x00,0x7F,0xFF,0xFF,0x9F,0xFF,
0xFF,0xE0,0x00,0x00,0xFF,0x80,0x03,0xFF,0xFF,0xF0,
0x7F,0xFF,0xFE,0x00,0x00,0x03,0xFE,0x00,0x07,0xFF,
0xFF,0x03,0xFF,0xFF,0xE0,0x00,0x00,0x1F,0xF0,0x00,
0x1F,0xFF,0xF0,0x0F,0xFF,0xFC,0x00,0x00,0x00,0x7F,
0xC0,0x00,0x3F,0xFE,0x00,0x3F,0xFF,0x80,0x01,0xFF,
0x03,0xFF,0x00,0x00,0x3F,0x80,0x00,0x7F,0xC0,0x00,
0x1F,0xF0,0x0F,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x01,0xFF,0x80,0x7F,0xF0,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x1F,0xF8,0x01,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x00,0x00,0x01,0xFF,0x80,0x07,0xFF,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFC,0x00,0x1F,
0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xC0,
0x00,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,
0xFC,0x00,0x03,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,
0x07,0xFF,0xC0,0x00,0x0F,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0xFF,0xFC,0x00,0x00,0x3F,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x1F,0xFF,0xC0,0x00,0x00,0xFF,0xFF,
0xC0,0x00,0x00,0x00,0x07,0xFF,0xFC,0x00,0x00,0x03,
0xFF,0xFF,0xE0,0x00,0x00,0x01,0xFF,0xFF,0xC0,0x00,
0x00,0x07,0xFF,0xFF,0xFC,0x00,0x03,0xFF,0xFF,0xF8,
0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x80,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x01,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,
0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,
0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x10,0xE4,0x7C,0x04,
0x30,0x00,0x00,0x00,0x7F,0xF0,0x00,0x00,0x00,0x90,
0x00,0x00,0x01,0xFF,0xF0,0x00,0x00,0x01,0x00,0x00,
0x00,0x07,0xFF,0xF0,0x00,0x00,0x02,0x00,0x00,0x00,
0x1F,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x01,0xFE,
0xFF,0x00,0x00,0x00,0x40,0x00,0x00,0x07,0xFD,0xFF,
0x00,0x00,0x00,0x80,0x00,0x00,0x1F,0xF1,0xFF,0x00,
0x00,0x00,0x00,0x00,0x01,0xFE,0x1F,0xF0,0x00,0x00,
0x10,0x00,0x00,0x07,0xFC,0x1F,0xF0,0x00,0x00,0x24,
0x00,0x00,0x1F,0xF0,0x1F,0xF0,0x00,0x00,0x40,0x00,
0x00,0x7F,0xC0,0x1F,0xF0,0x00,0x00,0x00,0x00,0x0F,
0xFC,0x01,0xFF,0x80,0x00,0x08,0x00,0x00,0x1F,0xF0,
0x01,0xFF,0x00,0x00,0x10,0x00,0x00,0x7F,0xC0,0x01,
0xFF,0x00,0x00,0x00,0x00,0x0F,0xFC,0x00,0x1F,0xF8,
0x00,0x02,0x00,0x00,0x1F,0xF0,0x00,0x1F,0xF0,0x00,
0x00,0x00,0x03,0xFF,0x00,0x01,0xFF,0x80,0x00,0x00,
0x00,0x3F,0xE0,0x00,0x0F,0xF8,0x00,0x04,0x00,0x00,
0xFF,0xC0,0x00,0x1F,0xF8,0x00,0x00,0x00,0x0F,0xF8,
0x00,0x00,0xFF,0x80,0x00,0x00,0x01,0xFF,0x80,0x00,
0x0F,0xFC,0x00,0x00,0x00,0x1F,0xF0,0x00,0x00,0x7F,
0xC0,0x00,0x80,0x00,0x7F,0xE0,0x00,0x00,0xFF,0xC0,
0x00,0x00,0x07,0xFC,0x00,0x00,0x07,0xFC,0x00,0x10,
0x00,0x1F,0xF8,0x00,0x00,0x0F,0xFC,0x00,0x00,0x01,
0xFF,0x00,0x00,0x00,0x7F,0xC0,0x02,0x00,0x07,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC0,0x04,0x80,0x1F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xC0,0x08,0x00,0x7F,0xFF,0xFF,0xFF,
0xFF,0xFF,0xC0,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFE,0x01,0x00,0x1F,0xF8,0x00,0x00,0x00,0x0F,0xFC,
0x02,0x00,0x7F,0xE0,0x00,0x00,0x00,0x0F,0xFC,0x04,
0x81,0xFF,0x80,0x00,0x00,0x00,0x0F,0xFC,0x08,0x07,
0xFE,0x00,0x00,0x00,0x00,0x0F,0xFC,0x00,0xFF,0xE0,
0x00,0x00,0x00,0x00,0xFF,0xE1,0x01,0xFF,0x80,0x00,
0x00,0x00,0x00,0xFF,0xC2,0x07,0xFE,0x00,0x00,0x00,
0x00,0x00,0xFF,0xC0,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x0F,0xFE,0x41,0xFF,0x80,0x00,0x00,0x00,0x00,0x0F,
0xFC,0x3F,0xF8,0x00,0x00,0x00,0x00,0x00,0xFF,0xE3,
0xFF,0x00,0x00,0x00,0x00,0x00,0x07,0xFE,0x8F,0xFE,
0x00,0x00,0x00,0x00,0x00,0x0F,0xFE,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x00,0x7F,0xE0,0x0D,0xA4,0x20,0x04,
0x37,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x0F,0xFF,0xFF,
0xFF,0xFF,0xC0,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xF0,
0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x7F,0xFF,
0xFF,0xFF,0xFF,0xF8,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF8,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x03,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF8,0x07,0xFE,0x00,0x00,0x07,
0xFF,0xF8,0x0F,0xFC,0x00,0x00,0x00,0xFF,0xF0,0x1F,
0xF8,0x00,0x00,0x00,0xFF,0xF0,0x3F,0xF0,0x00,0x00,
0x00,0xFF,0xE0,0x7F,0xE0,0x00,0x00,0x00,0xFF,0xE1,
0x1F,0xF8,0x00,0x00,0x00,0x1F,0xF8,0x3F,0xF0,0x00,
0x00,0x00,0x3F,0xF8,0xDF,0xFC,0x00,0x00,0x00,0x07,
0xFE,0x23,0xFF,0x00,0x00,0x00,0x03,0xFF,0x07,0xFE,
0x00,0x00,0x00,0x07,0xFC,0x0F,0xFC,0x00,0x00,0x00,
0x1F,0xF8,0x1F,0xF8,0x00,0x00,0x00,0x7F,0xE0,0x3F,
0xF0,0x00,0x00,0x01,0xFF,0xC0,0x7F,0xE0,0x00,0x00,
0x0F,0xFF,0x00,0xFF,0xC0,0x00,0x00,0xFF,0xFC,0x01,
0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x03,0xFF,0xFF,0xFF,
0xFF,0xFF,0x80,0x07,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,
0x0F,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x1F,0xFF,0xFF,
0xFF,0xFF,0xFE,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x81,0xFF,0x80,0x00,0x00,0xFF,
0xFF,0x83,0xFF,0x00,0x00,0x00,0x1F,0xFF,0x07,0xFE,
0x00,0x00,0x00,0x0F,0xFF,0x0F,0xFC,0x00,0x00,0x00,
0x0F,0xFF,0x1F,0xF8,0x00,0x00,0x00,0x0F,0xFE,0x3F,
0xF0,0x00,0x00,0x00,0x0F,0xFE,0x8F,0xFC,0x00,0x00,
0x00,0x01,0xFF,0x9F,0xF8,0x00,0x00,0x00,0x03,0xFF,
0xEF,0xFE,0x00,0x00,0x00,0x00,0x7F,0xEF,0xFC,0x00,
0x00,0x00,0x01,0xFF,0xE3,0xFF,0x00,0x00,0x00,0x00,
0x7F,0xE7,0xFE,0x00,0x00,0x00,0x01,0xFF,0xD1,0xFF,
0x80,0x00,0x00,0x00,0xFF,0xE3,0xFF,0x00,0x00,0x00,
0x07,0xFF,0x87,0xFE,0x00,0x00,0x00,0x1F,0xFF,0x0F,
0xFC,0x00,0x00,0x03,0xFF,0xFC,0x23,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFE,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,
0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x1F,0xFF,0xFF,
0xFF,0xFF,0xFF,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xF8,
0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0xFF,0xFF,
0xFF,0xFF,0xE0,0x00,0x00,0x0F,0xA5,0x17,0xFC,0x80,
0x00,0x00,0x00,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFF,0xFE,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0x80,
0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xC0,0x00,0x00,
0x03,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x0F,0xFF,
0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x7F,0xFF,0xFF,0xFF,
0xFF,0xC0,0x00,0x01,0xFF,0xFF,0x00,0x3F,0xFF,0xC0,
0x00,0x07,0xFF,0xF0,0x00,0x0F,0xFF,0xC0,0x00,0x1F,
0xFF,0x80,0x00,0x07,0xFF,0xC0,0x00,0x3F,0xFC,0x00,
0x00,0x07,0xFF,0xC0,0x00,0xFF,0xF0,0x00,0x00,0x07,
0xFF,0x80,0x03,0xFF,0xC0,0x00,0x00,0x07,0xFF,0x80,
0x0F,0xFF,0x00,0x00,0x00,0x07,0xFF,0x80,0x1F,0xFC,
0x00,0x00,0x00,0x07,0xFF,0x00,0x7F,0xF0,0x00,0x00,
0x00,0x0F,0xFE,0x00,0xFF,0xC0,0x00,0x00,0x00,0x0F,
0xFE,0x03,0xFF,0x80,0x00,0x00,0x00,0x1F,0xFC,0x40,
0xFF,0xC0,0x00,0x00,0x00,0x03,0xFF,0x83,0xFF,0x00,
0x00,0x00,0x00,0x03,0xF8,0x07,0xFE,0x00,0x00,0x00,
0x00,0x06,0x00,0x0F,0xFC,0x00,0x00,0x00,0x00,0x00,
0x00,0x3F,0xF8,0x00,0x00,0x00,0x00,0x00,0x01,0x4F,
0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xF8,0x00,
0x00,0x00,0x00,0x00,0x00,0xDF,0xFC,0x00,0x00,0x00,
0x00,0x00,0x00,0x37,0xFF,0x00,0x00,0x00,0x00,0x00,
0x00,0x0A,0x7F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x1C,0x00,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x3F,0x88,0x3F,0xF0,0x00,0x00,
0x00,0x00,0x1F,0xFC,0x7F,0xF0,0x00,0x00,0x00,0x00,
0x3F,0xF4,0x0F,0xFC,0x00,0x00,0x00,0x00,0x1F,0xFD,
0x01,0xFF,0x80,0x00,0x00,0x00,0x0F,0xFE,0x03,0xFF,
0x80,0x00,0x00,0x00,0x3F,0xF8,0x03,0xFF,0x80,0x00,
0x00,0x00,0x7F,0xF0,0x03,0xFF,0x80,0x00,0x00,0x01,
0xFF,0xC0,0x07,0xFF,0x80,0x00,0x00,0x07,0xFF,0x80,
0x07,0xFF,0x80,0x00,0x00,0x1F,0xFE,0x00,0x0F,0xFF,
0x80,0x00,0x00,0xFF,0xFC,0x00,0x0F,0xFF,0xC0,0x00,
0x03,0xFF,0xF0,0x00,0x0F,0xFF,0xE0,0x00,0x1F,0xFF,
0xC0,0x00,0x0F,0xFF,0xF8,0x01,0xFF,0xFF,0x00,0x00,
0x0F,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x0F,0xFF,
0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x0F,0xFF,0xFF,0xFF,
0xFF,0xC0,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFE,0x00,
0x00,0x00,0x07,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0xFF,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x80,
0x00,0x00,0x0E,0xE4,0x20,0x04,0x87,0xFF,0xFF,0xFF,
0xFE,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0x00,
0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x7F,
0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x07,0xFF,0xFF,0xFF,
0xFF,0xFF,0xC0,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x7F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x07,0xFE,0x00,0x00,
0x03,0xFF,0xFE,0x00,0x7F,0xE0,0x00,0x00,0x03,0xFF,
0xF0,0x07,0xFE,0x00,0x00,0x00,0x0F,0xFF,0x80,0x7F,
0xE0,0x00,0x00,0x00,0x7F,0xFC,0x07,0xFE,0x00,0x00,
0x00,0x03,0xFF,0xC0,0x7F,0xE0,0x00,0x00,0x00,0x1F,
0xFE,0x07,0xFE,0x00,0x00,0x00,0x00,0xFF,0xE0,0x7F,
0xE0,0x00,0x00,0x00,0x07,0xFF,0x07,0xFE,0x00,0x00,
0x00,0x00,0x3F,0xF0,0x7F,0xE0,0x00,0x00,0x00,0x03,
0xFF,0x87,0xFE,0x00,0x00,0x00,0x00,0x1F,0xF8,0x7F,
0xE0,0x00,0x00,0x00,0x01,0xFF,0xC9,0xFF,0xC0,0x00,
0x00,0x00,0x01,0xFF,0x97,0xFF,0x80,0x00,0x00,0x00,
0x01,0xFF,0xB7,0xFF,0x00,0x00,0x00,0x00,0x01,0xFF,
0xEF,0xFE,0x00,0x00,0x00,0x00,0x03,0xFF,0x7F,0xE0,
0x00,0x00,0x00,0x00,0x3F,0xF7,0xFE,0x00,0x00,0x00,
0x00,0x07,0xFF,0xAF,0xFC,0x00,0x00,0x00,0x00,0x0F,
0xFC,0xFF,0xC0,0x00,0x00,0x00,0x01,0xFF,0xD1,0xFF,
0x80,0x00,0x00,0x00,0x03,0xFF,0x1F,0xF8,0x00,0x00,
0x00,0x00,0x7F,0xF2,0x3F,0xF0,0x00,0x00,0x00,0x00,
0xFF,0xC3,0xFF,0x00,0x00,0x00,0x00,0x1F,0xFC,0x3F,
0xF0,0x00,0x00,0x00,0x01,0xFF,0x83,0xFF,0x00,0x00,
0x00,0x00,0x3F,0xF8,0x3F,0xF0,0x00,0x00,0x00,0x07,
0xFF,0x03,0xFF,0x00,0x00,0x00,0x00,0xFF,0xF0,0x3F,
0xF0,0x00,0x00,0x00,0x1F,0xFE,0x03,0xFF,0x00,0x00,
0x00,0x03,0xFF,0xC0,0x3F,0xF0,0x00,0x00,0x00,0xFF,
0xFC,0x03,0xFF,0x00,0x00,0x00,0x3F,0xFF,0x80,0x3F,
0xF0,0x00,0x00,0x3F,0xFF,0xF0,0x03,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFE,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xC0,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x3F,
0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x03,0xFF,0xFF,0xFF,
0xFF,0xFF,0x80,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xE0,
0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x3F,
0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x0D,0xA4,0x20,
0x04,0x3D,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF1,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xE6,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x01,0xBF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x6F,0xFE,0x00,0x00,0x00,0x00,0x00,0x11,0xFF,0x80,
0x00,0x00,0x00,0x00,0x06,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xC0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x83,0x7F,
0xF0,0x00,0x00,0x00,0x00,0x00,0xDF,0xFC,0x00,0x00,
0x00,0x00,0x00,0x37,0xFF,0x00,0x00,0x00,0x00,0x00,
0x0A,0xFF,0xC0,0x00,0x00,0x00,0x00,0x03,0x7F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFE,0x0C,0x24,0x20,0x03,0xDD,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xEF,
0xFE,0x00,0x00,0x00,0x00,0x06,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x6F,0xFE,0x00,0x00,0x00,0x00,0x04,0x7F,
0xE0,0x00,0x00,0x00,0x00,0x6F,0xFF,0xFF,0xFF,0xFF,
0xFE,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0x03,0x7F,0xF0,
0x00,0x00,0x00,0x00,0x37,0xFF,0x00,0x00,0x00,0x00,
0x03,0x7F,0xF0,0x00,0x00,0x00,0x00,0x37,0xFF,0x00,
0x00,0x00,0x00,0x02,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x00,0x10,0xE5,0x17,0xFC,0xE0,0x00,0x00,0x00,0x3F,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFE,0x00,
0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFC,0x00,0x00,
0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x1F,0xFF,
0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x07,0xFF,0xFF,0xFF,
0xFF,0xFF,0xF0,0x00,0x00,0xFF,0xFF,0xE0,0x03,0xFF,
0xFF,0x80,0x00,0x1F,0xFF,0xE0,0x00,0x03,0xFF,0xF8,
0x00,0x03,0xFF,0xF8,0x00,0x00,0x0F,0xFF,0xC0,0x00,
0x7F,0xFE,0x00,0x00,0x00,0x3F,0xFE,0x00,0x07,0xFF,
0x80,0x00,0x00,0x01,0xFF,0xE0,0x00,0xFF,0xF0,0x00,
0x00,0x00,0x0F,0xFF,0x00,0x1F,0xFE,0x00,0x00,0x00,
0x00,0x7F,0xF0,0x01,0xFF,0xC0,0x00,0x00,0x00,0x03,
0xFF,0x80,0x3F,0xF8,0x00,0x00,0x00,0x00,0x1F,0xF8,
0x03,0xFF,0x00,0x00,0x00,0x00,0x01,0xFF,0xC0,0x7F,
0xF0,0x00,0x00,0x00,0x00,0x0F,0xFC,0x07,0xFE,0x00,
0x00,0x00,0x00,0x00,0xFF,0xC0,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x07,0xFE,0x0F,0xFC,0x00,0x00,0x00,0x00,
0x00,0x7F,0x81,0xFF,0xC0,0x00,0x00,0x00,0x00,0x07,
0x80,0x93,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
0x4F,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x3F,
0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0xFF,0xE0,
0x00,0x00,0x07,0xFF,0xFF,0xFF,0xF7,0xFE,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xFF,0xB7,0xFE,0x00,0x00,0x00,
0x00,0x00,0x07,0xFF,0x07,0xFE,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFC,0x7F,0xF0,0x00,0x00,0x00,0x00,0x00,
0xFF,0xE0,0x7F,0xE0,0x00,0x00,0x00,0x00,0x01,0xFF,
0x87,0xFF,0x00,0x00,0x00,0x00,0x00,0x1F,0xFC,0x07,
0xFF,0x00,0x00,0x00,0x00,0x00,0x3F,0xF0,0x3F,0xF8,
0x00,0x00,0x00,0x00,0x03,0xFF,0x01,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x3F,0xF0,0x1F,0xFE,0x00,0x00,0x00,
0x00,0x0F,0xFF,0x00,0xFF,0xF0,0x00,0x00,0x00,0x01,
0xFF,0xF0,0x07,0xFF,0x80,0x00,0x00,0x00,0x7F,0xFF,
0x00,0x3F,0xFE,0x00,0x00,0x00,0x1F,0xFF,0xF0,0x03,
0xFF,0xF8,0x00,0x00,0x07,0xFF,0xFE,0x00,0x1F,0xFF,
0xF0,0x00,0x03,0xFF,0xFF,0xC0,0x00,0x7F,0xFF,0xF0,
0x03,0xFF,0xFF,0xF0,0x00,0x03,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFE,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,
0x80,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,
0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,
0x07,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x1F,
0xFF,0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,0x3F,0xFF,
0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0x00,
0x00,0x00,0x0E,0x24,0x20,0x04,0x8D,0xFF,0xC0,0x00,
0x00,0x00,0x03,0xFF,0xDF,0xFC,0x00,0x00,0x00,0x00,
0x3F,0xFD,0xFF,0xC0,0x00,0x00,0x00,0x03,0xFF,0xDF,
0xFC,0x00,0x00,0x00,0x00,0x3F,0xF8,0xFF,0xC0,0x00,
0x00,0x00,0x03,0xFF,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,
0xE0,0x00,0x00,0x00,0x01,0xFF,0xEF,0xFE,0x00,0x00,
0x00,0x00,0x1F,0xFE,0xFF,0xE0,0x00,0x00,0x00,0x01,
0xFF,0xEF,0xFE,0x00,0x00,0x00,0x00,0x1F,0xFE,0x7F,
0xE0,0x00,0x00,0x00,0x01,0xFF,0x80,0x02,0xA4,0x24,
0x01,0xCD,0xFF,0xF7,0xFF,0xDF,0xFF,0x7F,0xFD,0xFF,
0xF7,0xFF,0xDF,0xFF,0x7F,0xFD,0xFF,0xF7,0xFF,0x8F,
0xFC,0x09,0xE4,0x8F,0xFB,0x2D,0x00,0x00,0x00,0x07,
0xFF,0xA0,0x00,0x00,0x00,0xFF,0xF4,0x00,0x00,0x00,
0x1F,0xFE,0x80,0x00,0x00,0x03,0xFF,0xD0,0x00,0x00,
0x00,0x7F,0xFA,0x00,0x00,0x00,0x0F,0xFF,0x40,0x00,
0x00,0x01,0xFF,0x80,0x00,0x00,0x01,0xFF,0x80,0xF0,
0x00,0x01,0xFF,0xDF,0xFE,0x00,0x00,0x3F,0xF7,0xFF,
0x00,0x00,0x3F,0xF7,0xFF,0x00,0x00,0x7F,0xE8,0x7F,
0xE0,0x00,0x0F,0xFC,0x7F,0xF0,0x00,0x1F,0xFC,0x7F,
0xF0,0x00,0x1F,0xF8,0x3F,0xF8,0x00,0x3F,0xF8,0x3F,
0xFC,0x00,0x7F,0xF8,0x1F,0xFF,0x01,0xFF,0xF0,0x1F,
0xFF,0xFF,0xFF,0xE0,0x0F,0xFF,0xFF,0xFF,0xE0,0x07,
0xFF,0xFF,0xFF,0xC0,0x03,0xFF,0xFF,0xFF,0x80,0x01,
0xFF,0xFF,0xFE,0x00,0x00,0xFF,0xFF,0xFC,0x00,0x00,
0x3F,0xFF,0xF0,0x00,0x00,0x03,0xFF,0x00,0x00,0x0E,
0xE4,0x20,0x04,0x37,0xFE,0x00,0x00,0x00,0x00,0xFF,
0xFC,0x7F,0xE0,0x00,0x00,0x00,0x1F,0xFF,0x87,0xFE,
0x00,0x00,0x00,0x03,0xFF,0xF0,0x7F,0xE0,0x00,0x00,
0x00,0x7F,0xFE,0x07,0xFE,0x00,0x00,0x00,0x0F,0xFF,
0xC0,0x7F,0xE0,0x00,0x00,0x01,0xFF,0xF8,0x07,0xFE,
0x00,0x00,0x00,0x3F,0xFF,0x00,0x7F,0xE0,0x00,0x00,
0x07,0xFF,0xE0,0x07,0xFE,0x00,0x00,0x00,0xFF,0xFC,
0x00,0x7F,0xE0,0x00,0x00,0x1F,0xFF,0x80,0x07,0xFE,
0x00,0x00,0x03,0xFF,0xF0,0x00,0x7F,0xE0,0x00,0x00,
0x7F,0xFE,0x00,0x07,0xFE,0x00,0x00,0x0F,0xFF,0xC0,
0x00,0x7F,0xE0,0x00,0x01,0xFF,0xF8,0x00,0x07,0xFE,
0x00,0x00,0x3F,0xFF,0x00,0x00,0x7F,0xE0,0x00,0x07,
0xFF,0xE0,0x00,0x07,0xFE,0x00,0x00,0xFF,0xFC,0x00,
0x00,0x7F,0xE0,0x00,0x1F,0xFF,0x80,0x00,0x07,0xFE,
0x00,0x03,0xFF,0xF0,0x00,0x00,0x7F,0xE0,0x00,0x7F,
0xFE,0x00,0x00,0x07,0xFE,0x00,0x0F,0xFF,0xC0,0x00,
0x00,0x7F,0xE0,0x01,0xFF,0xF8,0x00,0x00,0x07,0xFE,
0x00,0x3F,0xFF,0x00,0x00,0x00,0x7F,0xE0,0x07,0xFF,
0xE0,0x00,0x00,0x07,0xFE,0x00,0xFF,0xFC,0x00,0x00,
0x00,0x7F,0xE0,0x1F,0xFF,0x80,0x00,0x00,0x07,0xFE,
0x03,0xFF,0xF0,0x00,0x00,0x00,0x7F,0xE0,0x7F,0xFE,
0x00,0x00,0x00,0x07,0xFE,0x0F,0xFF,0xC0,0x00,0x00,
0x00,0x7F,0xE1,0xFF,0xF8,0x00,0x00,0x00,0x07,0xFE,
0x3F,0xFF,0x80,0x00,0x00,0x00,0x7F,0xE7,0xFF,0xFC,
0x00,0x00,0x00,0x07,0xFE,0xFF,0xFF,0xC0,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x07,0xFF,
0xFF,0xFF,0xF0,0x00,0x00,0x00,0x8F,0xFF,0xFF,0xFF,
0xF0,0x00,0x00,0x00,0xFF,0xFF,0xF7,0xFF,0x80,0x00,
0x00,0x0F,0xFF,0xFE,0x3F,0xFC,0x00,0x00,0x00,0xFF,
0xFF,0xC3,0xFF,0xE0,0x00,0x00,0x0F,0xFF,0xF8,0x1F,
0xFE,0x00,0x00,0x00,0xFF,0xFF,0x00,0xFF,0xF0,0x00,
0x00,0x0F,0xFF,0xE0,0x07,0xFF,0x80,0x00,0x00,0xFF,
0xFC,0x00,0x7F,0xFC,0x00,0x00,0x0F,0xFF,0x80,0x03,
0xFF,0xC0,0x00,0x00,0xFF,0xF0,0x00,0x1F,0xFE,0x00,
0x00,0x0F,0xFE,0x00,0x00,0xFF,0xF0,0x00,0x00,0xFF,
0xC0,0x00,0x0F,0xFF,0x80,0x00,0x0F,0xFC,0x00,0x00,
0x7F,0xF8,0x00,0x00,0xFF,0xC0,0x00,0x03,0xFF,0xC0,
0x00,0x0F,0xFC,0x00,0x00,0x1F,0xFE,0x00,0x00,0xFF,
0xC0,0x00,0x01,0xFF,0xF0,0x00,0x0F,0xFC,0x00,0x00,
0x0F,0xFF,0x00,0x00,0xFF,0xC0,0x00,0x00,0x7F,0xF8,
0x00,0x0F,0xFC,0x00,0x00,0x03,0xFF,0xC0,0x00,0xFF,
0xC0,0x00,0x00,0x3F,0xFE,0x00,0x0F,0xFC,0x00,0x00,
0x01,0xFF,0xE0,0x00,0xFF,0xC0,0x00,0x00,0x0F,0xFF,
0x00,0x0F,0xFC,0x00,0x00,0x00,0x7F,0xF8,0x00,0xFF,
0xC0,0x00,0x00,0x07,0xFF,0xC0,0x0F,0xFC,0x00,0x00,
0x00,0x3F,0xFC,0x00,0xFF,0xC0,0x00,0x00,0x01,0xFF,
0xE0,0x0F,0xFC,0x00,0x00,0x00,0x0F,0xFF,0x00,0xFF,
0xC0,0x00,0x00,0x00,0xFF,0xF8,0x0F,0xFC,0x00,0x00,
0x00,0x07,0xFF,0x80,0xFF,0xC0,0x00,0x00,0x00,0x3F,
0xFC,0x0F,0xFC,0x00,0x00,0x00,0x01,0xFF,0xE0,0xFF,
0xC0,0x00,0x00,0x00,0x1F,0xFF,0x0F,0xFC,0x00,0x00,
0x00,0x00,0xFF,0xF0,0xFF,0xC0,0x00,0x00,0x00,0x07,
0xFF,0x8F,0xFC,0x00,0x00,0x00,0x00,0x3F,0xFC,0xFF,
0xC0,0x00,0x00,0x00,0x03,0xFF,0xE0,0x0B,0x64,0x20,
0x03,0x8D,0xFF,0xC0,0x00,0x00,0x00,0x06,0xFF,0xE0,
0x00,0x00,0x00,0x03,0x7F,0xF0,0x00,0x00,0x00,0x01,
0xBF,0xF8,0x00,0x00,0x00,0x00,0xDF,0xFC,0x00,0x00,
0x00,0x00,0x6F,0xFE,0x00,0x00,0x00,0x00,0x37,0xFF,
0x00,0x00,0x00,0x00,0x1B,0xFF,0x80,0x00,0x00,0x00,
0x0D,0xFF,0xC0,0x00,0x00,0x00,0x03,0xFF,0x00,0x00,
0x00,0x00,0x1B,0xFF,0xFF,0xFF,0xFF,0xFF,0xF7,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC0,0x11,0x64,0x1C,0x05,0x38,
0xFF,0xFE,0x00,0x00,0x00,0x00,0x03,0xFF,0xFC,0xFF,
0xFF,0x80,0x00,0x00,0x00,0x03,0xFF,0xFE,0x7F,0xFF,
0xE0,0x00,0x00,0x00,0x03,0xFF,0xFF,0x3F,0xFF,0xF8,
0x00,0x00,0x00,0x03,0xFF,0xFF,0x7F,0xFF,0xF0,0x00,
0x00,0x00,0x0F,0xFF,0xFD,0xFF,0xFF,0xC0,0x00,0x00,
0x00,0x7F,0xFF,0xF7,0xFE,0xFF,0x00,0x00,0x00,0x01,
0xFE,0xFF,0xDF,0xFB,0xFE,0x00,0x00,0x00,0x07,0xFB,
0xFF,0x7F,0xEF,0xF8,0x00,0x00,0x00,0x3F,0xEF,0xFD,
0xFF,0x9F,0xE0,0x00,0x00,0x00,0xFF,0x3F,0xF7,0xFE,
0x7F,0xC0,0x00,0x00,0x03,0xFC,0xFF,0xDF,0xF9,0xFF,
0x00,0x00,0x00,0x1F,0xF3,0xFF,0x8F,0xFC,0x7F,0x80,
0x00,0x00,0x0F,0xF1,0xFF,0xBF,0xF1,0xFF,0x00,0x00,
0x00,0x7F,0xC7,0xFF,0x1F,0xF8,0x7F,0x80,0x00,0x00,
0x3F,0xC3,0xFF,0x7F,0xE1,0xFF,0x00,0x00,0x01,0xFF,
0x0F,0xFE,0x3F,0xF0,0x7F,0x80,0x00,0x00,0xFF,0x07,
0xFE,0xFF,0xC1,0xFF,0x00,0x00,0x07,0xFC,0x1F,0xFC,
0x7F,0xE0,0x7F,0x80,0x00,0x03,0xFC,0x0F,0xFD,0xFF,
0x81,0xFF,0x00,0x00,0x1F,0xF0,0x3F,0xF8,0xFF,0xC0,
0x7F,0x80,0x00,0x0F,0xF0,0x1F,0xFB,0xFF,0x01,0xFF,
0x00,0x00,0x7F,0xC0,0x7F,0xEF,0xFC,0x07,0xFC,0x00,
0x01,0xFE,0x01,0xFF,0xBF,0xF0,0x0F,0xF0,0x00,0x07,
0xF8,0x07,0xFF,0x1F,0xF8,0x07,0xFC,0x00,0x07,0xFC,
0x03,0xFF,0x7F,0xE0,0x0F,0xF0,0x00,0x1F,0xE0,0x0F,
0xFE,0x3F,0xF0,0x07,0xFC,0x00,0x1F,0xF0,0x07,0xFE,
0xFF,0xC0,0x0F,0xF0,0x00,0x7F,0x80,0x1F,0xFC,0x7F,
0xE0,0x07,0xFC,0x00,0x7F,0xC0,0x0F,0xFD,0xFF,0x80,
0x0F,0xF0,0x01,0xFE,0x00,0x3F,0xF8,0xFF,0xC0,0x07,
0xFC,0x01,0xFF,0x00,0x1F,0xFB,0xFF,0x00,0x0F,0xF0,
0x07,0xF8,0x00,0x7F,0xEF,0xFC,0x00,0x3F,0xC0,0x3F,
0xE0,0x01,0xFF,0xBF,0xF0,0x00,0xFF,0x80,0xFF,0x80,
0x07,0xFF,0x1F,0xF8,0x00,0x3F,0xC0,0x7F,0x80,0x03,
0xFF,0x7F,0xE0,0x00,0xFF,0x83,0xFE,0x00,0x0F,0xFE,
0x3F,0xF0,0x00,0x3F,0xC1,0xFE,0x00,0x07,0xFE,0xFF,
0xC0,0x00,0xFF,0x8F,0xF8,0x00,0x1F,0xFB,0xFF,0x00,
0x03,0xFE,0x3F,0xC0,0x00,0x7F,0xEF,0xFC,0x00,0x07,
0xF8,0xFF,0x00,0x01,0xFF,0xBF,0xF0,0x00,0x1F,0xF7,
0xFC,0x00,0x07,0xFE,0xFF,0xC0,0x00,0x7F,0xDF,0xE0,
0x00,0x1F,0xFB,0xFF,0x00,0x00,0xFF,0x7F,0x80,0x00,
0x7F,0xF1,0xFF,0x80,0x00,0x7F,0xFF,0xC0,0x00,0x3F,
0xF9,0xFF,0xC0,0x00,0x1F,0xFF,0xC0,0x00,0x1F,0xFC,
0xFF,0xE0,0x00,0x07,0xFF,0xC0,0x00,0x0F,0xFE,0x7F,
0xF0,0x00,0x01,0xFF,0xC0,0x00,0x07,0xFE,0x0E,0x24,
0x20,0x04,0x87,0xFF,0x00,0x00,0x00,0x00,0x1F,0xFC,
0x7F,0xF8,0x00,0x00,0x00,0x01,0xFF,0xBF,0xFE,0x00,
0x00,0x00,0x00,0xFF,0xE3,0xFF,0xF0,0x00,0x00,0x00,
0x0F,0xFE,0x3F,0xFF,0x80,0x00,0x00,0x00,0xFF,0xDF,
0xFF,0xE0,0x00,0x00,0x00,0x7F,0xF1,0xFF,0xFF,0x00,
0x00,0x00,0x07,0xFE,0xFF,0xFF,0xC0,0x00,0x00,0x03,
0xFF,0x8F,0xFF,0xFE,0x00,0x00,0x00,0x3F,0xF7,0xFF,
0xFF,0x80,0x00,0x00,0x1F,0xFC,0x7F,0xFF,0xFC,0x00,
0x00,0x01,0xFF,0xBF,0xFF,0xFF,0x00,0x00,0x00,0xFF,
0xE3,0xFF,0x7F,0xF8,0x00,0x00,0x0F,0xFD,0xFF,0x9F,
0xFE,0x00,0x00,0x07,0xFF,0x1F,0xF8,0xFF,0xF0,0x00,
0x00,0x7F,0xEF,0xFC,0x3F,0xFC,0x00,0x00,0x3F,0xF7,
0xFE,0x1F,0xFF,0x00,0x00,0x1F,0xFB,0xFF,0x07,0xFF,
0x80,0x00,0x0F,0xFD,0xFF,0x81,0xFF,0xE0,0x00,0x07,
0xFE,0xFF,0xC0,0xFF,0xF8,0x00,0x03,0xFF,0x7F,0xE0,
0x3F,0xFC,0x00,0x01,0xFF,0xC7,0xFE,0x01,0xFF,0xE0,
0x00,0x1F,0xFB,0xFF,0x00,0x7F,0xF8,0x00,0x0F,0xFE,
0x3F,0xF0,0x03,0xFF,0xC0,0x00,0xFF,0xDF,0xF8,0x00,
0xFF,0xF0,0x00,0x7F,0xF1,0xFF,0x80,0x07,0xFF,0x80,
0x07,0xFE,0xFF,0xC0,0x01,0xFF,0xE0,0x03,0xFF,0x8F,
0xFC,0x00,0x0F,0xFF,0x00,0x3F,0xF7,0xFE,0x00,0x03,
0xFF,0xC0,0x1F,0xFC,0x7F,0xE0,0x00,0x1F,0xFE,0x01,
0xFF,0xBF,0xF0,0x00,0x07,0xFF,0x80,0xFF,0xDF,0xF8,
0x00,0x03,0xFF,0xE0,0x7F,0xEF,0xFC,0x00,0x00,0xFF,
0xF0,0x3F,0xF7,0xFE,0x00,0x00,0x3F,0xFC,0x1F,0xFB,
0xFF,0x00,0x00,0x1F,0xFF,0x0F,0xFD,0xFF,0x80,0x00,
0x07,0xFF,0x87,0xFF,0x1F,0xF8,0x00,0x00,0x3F,0xFC,
0x7F,0xEF,0xFC,0x00,0x00,0x0F,0xFF,0x3F,0xF8,0xFF,
0xC0,0x00,0x00,0x7F,0xFB,0xFF,0x7F,0xE0,0x00,0x00,
0x1F,0xFF,0xFF,0xC7,0xFE,0x00,0x00,0x00,0xFF,0xFF,
0xFB,0xFF,0x00,0x00,0x00,0x3F,0xFF,0xFE,0x3F,0xF0,
0x00,0x00,0x01,0xFF,0xFF,0xDF,0xF8,0x00,0x00,0x00,
0x7F,0xFF,0xF1,0xFF,0x80,0x00,0x00,0x03,0xFF,0xFE,
0xFF,0xC0,0x00,0x00,0x00,0xFF,0xFF,0x8F,0xFC,0x00,
0x00,0x00,0x07,0xFF,0xF8,0xFF,0xC0,0x00,0x00,0x00,
0x3F,0xFF,0x7F,0xE0,0x00,0x00,0x00,0x0F,0xFF,0xC7,
0xFE,0x00,0x00,0x00,0x00,0x7F,0xFB,0xFF,0x00,0x00,
0x00,0x00,0x1F,0xFC,0x11,0x25,0x17,0xFC,0xE0,0x00,
0x00,0x00,0x7F,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,
0x7F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xF0,
0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,
0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,
0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0xFF,
0xFF,0xC0,0x0F,0xFF,0xFC,0x00,0x00,0x0F,0xFF,0xF0,
0x00,0x0F,0xFF,0xF0,0x00,0x00,0xFF,0xFC,0x00,0x00,
0x0F,0xFF,0xC0,0x00,0x0F,0xFF,0x80,0x00,0x00,0x3F,
0xFF,0x00,0x00,0xFF,0xF8,0x00,0x00,0x00,0x7F,0xF8,
0x00,0x07,0xFF,0x80,0x00,0x00,0x01,0xFF,0xE0,0x00,
0x7F,0xF8,0x00,0x00,0x00,0x07,0xFF,0x80,0x07,0xFF,
0x80,0x00,0x00,0x00,0x1F,0xFC,0x00,0x3F,0xF8,0x00,
0x00,0x00,0x00,0x7F,0xF0,0x03,0xFF,0x80,0x00,0x00,
0x00,0x01,0xFF,0xC0,0x1F,0xF8,0x00,0x00,0x00,0x00,
0x0F,0xFE,0x01,0xFF,0xC0,0x00,0x00,0x00,0x00,0x3F,
0xF8,0x0F,0xFC,0x00,0x00,0x00,0x00,0x01,0xFF,0xC0,
0x7F,0xE0,0x00,0x00,0x00,0x00,0x07,0xFE,0x07,0xFE,
0x00,0x00,0x00,0x00,0x00,0x3F,0xF9,0x07,0xFE,0x00,
0x00,0x00,0x00,0x00,0x1F,0xF8,0x7F,0xE0,0x00,0x00,
0x00,0x00,0x00,0xFF,0xEA,0x7F,0xE0,0x00,0x00,0x00,
0x00,0x00,0x7F,0xED,0xFF,0xC0,0x00,0x00,0x00,0x00,
0x00,0x3F,0xFD,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,
0x3F,0xF3,0xFE,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,
0x53,0xFF,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0x49,
0xFF,0x80,0x00,0x00,0x00,0x00,0x07,0xFE,0x40,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x0F,0xFC,0x07,0xFF,0x00,
0x00,0x00,0x00,0x00,0xFF,0xE0,0x1F,0xF8,0x00,0x00,
0x00,0x00,0x0F,0xFE,0x00,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x7F,0xF0,0x03,0xFF,0x80,0x00,0x00,0x00,0x07,
0xFF,0x00,0x1F,0xFE,0x00,0x00,0x00,0x00,0x7F,0xF8,
0x00,0x7F,0xF8,0x00,0x00,0x00,0x07,0xFF,0x80,0x01,
0xFF,0xE0,0x00,0x00,0x00,0x7F,0xF8,0x00,0x07,0xFF,
0x80,0x00,0x00,0x07,0xFF,0xC0,0x00,0x3F,0xFE,0x00,
0x00,0x00,0x7F,0xFC,0x00,0x00,0xFF,0xFC,0x00,0x00,
0x0F,0xFF,0xC0,0x00,0x03,0xFF,0xF8,0x00,0x01,0xFF,
0xFC,0x00,0x00,0x0F,0xFF,0xFC,0x00,0xFF,0xFF,0xC0,
0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x01,
0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x03,0xFF,
0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFC,
0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,0x00,0x00,
0x00,0x00,0x00,0x00,0x07,0xFF,0x80,0x00,0x00,0x00,
0x0D,0xA4,0x20,0x04,0x37,0xFF,0xFF,0xFF,0xFF,0x80,
0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x1F,0xFF,
0xFF,0xFF,0xFF,0xFE,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,
0xFE,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0x01,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,
0xFE,0x00,0x00,0x00,0xFF,0xFE,0x0F,0xFC,0x00,0x00,
0x00,0x3F,0xFE,0x1F,0xF8,0x00,0x00,0x00,0x1F,0xFE,
0x3F,0xF0,0x00,0x00,0x00,0x1F,0xFC,0x7F,0xE0,0x00,
0x00,0x00,0x3F,0xFC,0xFF,0xC0,0x00,0x00,0x00,0x3F,
0xFA,0x3F,0xF0,0x00,0x00,0x00,0x07,0xFE,0x7F,0xE0,
0x00,0x00,0x00,0x0F,0xFF,0xBF,0xF8,0x00,0x00,0x00,
0x01,0xFF,0xBF,0xF0,0x00,0x00,0x00,0x03,0xFF,0x7F,
0xE0,0x00,0x00,0x00,0x0F,0xFF,0x1F,0xF8,0x00,0x00,
0x00,0x03,0xFF,0x3F,0xF0,0x00,0x00,0x00,0x0F,0xFE,
0x7F,0xE0,0x00,0x00,0x00,0x3F,0xF8,0xFF,0xC0,0x00,
0x00,0x00,0xFF,0xF1,0xFF,0x80,0x00,0x00,0x03,0xFF,
0xC3,0xFF,0x00,0x00,0x00,0x1F,0xFF,0x87,0xFE,0x00,
0x00,0x01,0xFF,0xFE,0x11,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x07,0xFF,
0xFF,0xFF,0xFF,0xFF,0xE0,0x0F,0xFF,0xFF,0xFF,0xFF,
0xFF,0x80,0x1F,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x3F,
0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x7F,0xFF,0xFF,0xFF,
0xF0,0x00,0x01,0xBF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x6F,0xFE,0x00,0x00,0x00,0x00,0x00,0x1B,0xFF,0x80,
0x00,0x00,0x00,0x00,0x06,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x01,0x1F,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,
0x11,0x27,0x17,0xDC,0xE0,0x00,0x00,0x00,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x03,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x0F,
0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x00,0xFF,0xFF,
0xFF,0xFF,0xFF,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,
0xFF,0xFC,0x00,0x00,0x00,0xFF,0xFF,0x80,0x1F,0xFF,
0xF0,0x00,0x00,0x0F,0xFF,0xE0,0x00,0x1F,0xFF,0xC0,
0x00,0x00,0xFF,0xFC,0x00,0x00,0x3F,0xFF,0x00,0x00,
0x0F,0xFF,0x80,0x00,0x00,0x7F,0xFC,0x00,0x00,0xFF,
0xF8,0x00,0x00,0x01,0xFF,0xF0,0x00,0x07,0xFF,0x00,
0x00,0x00,0x07,0xFF,0x80,0x00,0x7F,0xF0,0x00,0x00,
0x00,0x1F,0xFE,0x00,0x07,0xFF,0x00,0x00,0x00,0x00,
0x7F,0xF8,0x00,0x3F,0xF8,0x00,0x00,0x00,0x01,0xFF,
0xC0,0x03,0xFF,0x80,0x00,0x00,0x00,0x07,0xFF,0x00,
0x1F,0xF8,0x00,0x00,0x00,0x00,0x1F,0xF8,0x01,0xFF,
0xC0,0x00,0x00,0x00,0x00,0xFF,0xE0,0x81,0xFF,0x80,
0x00,0x00,0x00,0x00,0x7F,0xE0,0x93,0xFF,0x00,0x00,
0x00,0x00,0x00,0x3F,0xF0,0xB7,0xFE,0x00,0x00,0x00,
0x00,0x00,0x1F,0xF8,0xDF,0xFC,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFC,0xDF,0xFC,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFC,0xB7,0xFE,0x00,0x00,0x00,0x00,0x00,0x1F,
0xF8,0x93,0xFF,0x00,0x00,0x00,0x00,0x00,0x3F,0xF0,
0x0F,0xFC,0x00,0x00,0x00,0x00,0x03,0xFF,0x00,0x7F,
0xE0,0x00,0x00,0x60,0x00,0x1F,0xF8,0x03,0xFF,0x80,
0x00,0x03,0xC0,0x01,0xFF,0xC0,0x0F,0xFC,0x00,0x00,
0x1F,0xC0,0x0F,0xFC,0x00,0x7F,0xF0,0x00,0x01,0xFF,
0x00,0xFF,0xE0,0x01,0xFF,0xC0,0x00,0x0F,0xFE,0x0F,
0xFE,0x00,0x0F,0xFE,0x00,0x00,0x7F,0xF8,0xFF,0xF0,
0x00,0x3F,0xF8,0x00,0x07,0xFF,0xF7,0xFF,0x00,0x00,
0xFF,0xE0,0x00,0x0F,0xFF,0xFF,0xF0,0x00,0x07,0xFF,
0xC0,0x00,0x0F,0xFF,0xFF,0x00,0x00,0x1F,0xFF,0x00,
0x00,0x3F,0xFF,0xF8,0x00,0x00,0x7F,0xFE,0x00,0x00,
0x7F,0xFF,0x80,0x00,0x01,0xFF,0xFC,0x00,0x03,0xFF,
0xF8,0x00,0x00,0x07,0xFF,0xFC,0x00,0xFF,0xFF,0x80,
0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x01,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x03,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x07,0xFF,0xFF,
0xFF,0xF7,0xFF,0xF0,0x00,0x00,0x0F,0xFF,0xFF,0xFE,
0x1F,0xFF,0xE0,0x00,0x00,0x0F,0xFF,0xFF,0x80,0x7F,
0xFF,0x80,0x00,0x00,0x07,0xFF,0x80,0x00,0xFF,0xF8,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0xFC,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x07,0xE0,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x0E,0x00,0x0F,0x64,0x20,0x04,0x87,
0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x1F,0xFF,0xFF,
0xFF,0xFF,0xFE,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,
0xFF,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,
0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x1F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x8F,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0x00,0x3F,0xF0,0x00,0x00,0x01,0xFF,
0xFE,0x00,0xFF,0xC0,0x00,0x00,0x00,0xFF,0xFC,0x03,
0xFF,0x00,0x00,0x00,0x00,0xFF,0xF0,0x0F,0xFC,0x00,
0x00,0x00,0x01,0xFF,0xC0,0x47,0xFE,0x00,0x00,0x00,
0x00,0x7F,0xF0,0x1F,0xF8,0x00,0x00,0x00,0x00,0xFF,
0xC0,0x7F,0xE0,0x00,0x00,0x00,0x03,0xFF,0x83,0x7F,
0xF0,0x00,0x00,0x00,0x00,0xFF,0xC0,0xFF,0xC0,0x00,
0x00,0x00,0x07,0xFF,0x04,0x7F,0xE0,0x00,0x00,0x00,
0x03,0xFF,0x01,0xFF,0x80,0x00,0x00,0x00,0x1F,0xFC,
0x08,0xFF,0xC0,0x00,0x00,0x00,0x1F,0xFC,0x03,0xFF,
0x00,0x00,0x00,0x01,0xFF,0xE0,0x0F,0xFC,0x00,0x00,
0x00,0x0F,0xFF,0x80,0x3F,0xF0,0x00,0x00,0x03,0xFF,
0xFC,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x03,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x0F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xF8,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,
0xFF,0x80,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,
0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x0F,0xFF,
0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x3F,0xFF,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0xFF,0xC0,0x00,0x3F,0xFE,0x00,
0x00,0x03,0xFF,0x00,0x00,0x1F,0xFE,0x00,0x00,0x0F,
0xFC,0x00,0x00,0x3F,0xFC,0x00,0x00,0x3F,0xF0,0x00,
0x00,0x7F,0xF8,0x00,0x00,0xFF,0xC0,0x00,0x00,0xFF,
0xF0,0x00,0x03,0xFF,0x00,0x00,0x01,0xFF,0xE0,0x00,
0x0F,0xFC,0x00,0x00,0x03,0xFF,0xC0,0x00,0x3F,0xF0,
0x00,0x00,0x07,0xFF,0x00,0x00,0xFF,0xC0,0x00,0x00,
0x0F,0xFE,0x00,0x03,0xFF,0x00,0x00,0x00,0x3F,0xFC,
0x00,0x0F,0xFC,0x00,0x00,0x00,0x7F,0xF8,0x00,0x3F,
0xF0,0x00,0x00,0x00,0xFF,0xE0,0x00,0xFF,0xC0,0x00,
0x00,0x03,0xFF,0xC0,0x03,0xFF,0x00,0x00,0x00,0x07,
0xFF,0x00,0x0F,0xFC,0x00,0x00,0x00,0x0F,0xFE,0x00,
0x3F,0xF0,0x00,0x00,0x00,0x3F,0xFC,0x00,0xFF,0xC0,
0x00,0x00,0x00,0x7F,0xF0,0x03,0xFF,0x00,0x00,0x00,
0x01,0xFF,0xE0,0x0F,0xFC,0x00,0x00,0x00,0x03,0xFF,
0x80,0x3F,0xF0,0x00,0x00,0x00,0x07,0xFF,0x00,0xFF,
0xC0,0x00,0x00,0x00,0x1F,0xFE,0x03,0xFF,0x00,0x00,
0x00,0x00,0x3F,0xF8,0x0F,0xFC,0x00,0x00,0x00,0x00,
0xFF,0xF0,0x3F,0xF0,0x00,0x00,0x00,0x01,0xFF,0xE0,
0xFF,0xC0,0x00,0x00,0x00,0x03,0xFF,0x83,0xFF,0x00,
0x00,0x00,0x00,0x0F,0xFF,0x0F,0xFC,0x00,0x00,0x00,
0x00,0x1F,0xFC,0x3F,0xF0,0x00,0x00,0x00,0x00,0x7F,
0xF8,0xFF,0xC0,0x00,0x00,0x00,0x00,0xFF,0xF3,0xFF,
0x00,0x00,0x00,0x00,0x01,0xFF,0xCF,0xFC,0x00,0x00,
0x00,0x00,0x07,0xFF,0xBF,0xF0,0x00,0x00,0x00,0x00,
0x0F,0xFE,0x0E,0x65,0x17,0xFC,0x30,0x00,0x00,0x1F,
0xFF,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFC,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,0xFF,0xFF,0xFF,
0xFF,0xE0,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFC,0x00,
0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x1F,0xFF,
0xFF,0xFF,0xFF,0xF8,0x00,0x0F,0xFF,0xF0,0x01,0xFF,
0xFE,0x00,0x07,0xFF,0xE0,0x00,0x0F,0xFF,0xC0,0x03,
0xFF,0xE0,0x00,0x00,0xFF,0xF8,0x00,0xFF,0xE0,0x00,
0x00,0x0F,0xFE,0x08,0x0F,0xFE,0x00,0x00,0x00,0x3F,
0xF8,0x03,0xFF,0x00,0x00,0x00,0x07,0xFF,0x01,0xFF,
0xC0,0x00,0x00,0x00,0xFF,0xC0,0x7F,0xE0,0x00,0x00,
0x00,0x3F,0xF0,0x1F,0xF8,0x00,0x00,0x00,0x0F,0xFE,
0x48,0xFF,0xC0,0x00,0x00,0x00,0x3F,0xF0,0x3F,0xF0,
0x00,0x00,0x00,0x00,0x00,0x81,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x00,0x3F,0xF8,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFF,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x00,0x7F,0xFE,0x00,0x00,0x00,
0x00,0x00,0x1F,0xFF,0xF0,0x00,0x00,0x00,0x00,0x03,
0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFE,
0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xF8,0x00,0x00,
0x00,0x01,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x3F,
0xFF,0xFF,0xFF,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,
0xF8,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0x80,0x00,
0x00,0x03,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x1F,
0xFF,0xFF,0xFF,0x80,0x00,0x00,0x00,0xFF,0xFF,0xFF,
0xF0,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFE,0x00,0x00,
0x00,0x00,0x1F,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,
0x7F,0xFF,0xF8,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x01,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x00,0x7F,0xF4,0x7F,0xE0,0x00,
0x00,0x00,0x01,0xFF,0xDF,0xF8,0x00,0x00,0x00,0x00,
0x3F,0xF8,0xFF,0xE0,0x00,0x00,0x00,0x01,0xFF,0xC3,
0xFF,0x00,0x00,0x00,0x00,0x0F,0xFC,0xFF,0xE0,0x00,
0x00,0x00,0x03,0xFF,0x3F,0xF8,0x00,0x00,0x00,0x01,
0xFF,0xE0,0xFF,0xE0,0x00,0x00,0x00,0x0F,0xFC,0x1F,
0xFC,0x00,0x00,0x00,0x07,0xFF,0x07,0xFF,0x80,0x00,
0x00,0x03,0xFF,0x80,0xFF,0xF0,0x00,0x00,0x01,0xFF,
0xE0,0x3F,0xFF,0x00,0x00,0x00,0xFF,0xF0,0x07,0xFF,
0xE0,0x00,0x00,0x7F,0xFC,0x00,0xFF,0xFF,0x00,0x00,
0x7F,0xFE,0x00,0x1F,0xFF,0xF8,0x01,0xFF,0xFF,0x00,
0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x7F,0xFF,
0xFF,0xFF,0xFF,0xC0,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,
0xE0,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,
0x1F,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x01,0xFF,0xFF,
0xFF,0xF0,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x1F,0xFF,0x80,0x00,0x00,0x0E,0xA4,
0x08,0x03,0xED,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x80,0x00,
0x00,0x7F,0xE0,0x00,0x00,0x1A,0x00,0x00,0x01,0xFF,
0x80,0x00,0x00,0x68,0x00,0x00,0x07,0xFE,0x00,0x00,
0x01,0xA0,0x00,0x00,0x1F,0xF8,0x00,0x00,0x06,0x80,
0x00,0x00,0x7F,0xE0,0x00,0x00,0x1A,0x00,0x00,0x01,
0xFF,0x80,0x00,0x00,0x68,0x00,0x00,0x07,0xFE,0x00,
0x00,0x01,0xA0,0x00,0x00,0x1F,0xF8,0x00,0x00,0x06,
0x80,0x00,0x00,0x7F,0xE0,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFC,0x00,0x00,0x00,0x0E,0x24,0xA3,0xFC,0x8D,
0xFF,0xC0,0x00,0x00,0x00,0x03,0xFF,0xDF,0xFC,0x00,
0x00,0x00,0x00,0x3F,0xFD,0xFF,0xC0,0x00,0x00,0x00,
0x03,0xFF,0xDF,0xFC,0x00,0x00,0x00,0x00,0x3F,0xFD,
0xFF,0xC0,0x00,0x00,0x00,0x03,0xFF,0xDF,0xFC,0x00,
0x00,0x00,0x00,0x3F,0xFD,0xFF,0xC0,0x00,0x00,0x00,
0x03,0xFF,0x7F,0xE0,0x00,0x00,0x00,0x03,0xFF,0xD3,
0xFF,0x00,0x00,0x00,0x00,0x3F,0xF4,0x3F,0xF8,0x00,
0x00,0x00,0x07,0xFF,0x0F,0xFC,0x00,0x00,0x00,0x03,
0xFF,0x07,0xFF,0x00,0x00,0x00,0x03,0xFF,0x83,0xFF,
0xC0,0x00,0x00,0x03,0xFF,0xC0,0xFF,0xF0,0x00,0x00,
0x03,0xFF,0xC0,0x7F,0xFC,0x00,0x00,0x03,0xFF,0xE0,
0x1F,0xFF,0x00,0x00,0x03,0xFF,0xE0,0x0F,0xFF,0xE0,
0x00,0x07,0xFF,0xF0,0x03,0xFF,0xFE,0x00,0x3F,0xFF,
0xF0,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x3F,
0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x0F,0xFF,0xFF,0xFF,
0xFF,0xF0,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,
0x00,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x1F,0xFF,
0xFF,0xFF,0xE0,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xC0,
0x00,0x00,0x00,0x3F,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x01,0xFF,0xF8,0x00,0x00,0x00,0x11,0x64,0x7C,0x04,
0x37,0xFF,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xE1,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x01,0xFF,0xC3,0xFF,
0x00,0x00,0x00,0x00,0x00,0x07,0xFE,0x41,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x07,0xFF,0x03,0xFF,0x00,0x00,
0x00,0x00,0x00,0x1F,0xF8,0x0F,0xFE,0x00,0x00,0x00,
0x00,0x00,0xFF,0xE0,0x1F,0xF8,0x00,0x00,0x00,0x00,
0x03,0xFF,0x08,0x0F,0xFE,0x00,0x00,0x00,0x00,0x03,
0xFF,0x80,0x1F,0xF8,0x00,0x00,0x00,0x00,0x0F,0xFC,
0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0x7F,0xF0,0x00,
0xFF,0xC0,0x00,0x00,0x00,0x01,0xFF,0xC0,0x03,0xFF,
0x00,0x00,0x00,0x00,0x07,0xFE,0x00,0x0F,0xFE,0x00,
0x00,0x00,0x00,0x3F,0xF8,0x00,0x1F,0xF8,0x00,0x00,
0x00,0x00,0xFF,0xC0,0x00,0x7F,0xF0,0x00,0x00,0x00,
0x07,0xFF,0x00,0x00,0xFF,0xC0,0x00,0x00,0x00,0x1F,
0xFC,0x00,0x03,0xFF,0x00,0x00,0x00,0x00,0x7F,0xE0,
0x00,0x0F,0xFE,0x00,0x00,0x00,0x03,0xFF,0x80,0x00,
0x1F,0xF8,0x00,0x00,0x00,0x0F,0xFC,0x00,0x00,0x7F,
0xE0,0x00,0x00,0x00,0x7F,0xF0,0x00,0x00,0xFF,0xC0,
0x00,0x00,0x01,0xFF,0xC0,0x00,0x03,0xFF,0x00,0x00,
0x00,0x07,0xFE,0x00,0x40,0x00,0xFF,0xC0,0x00,0x00,
0x07,0xFF,0x00,0x00,0x03,0xFF,0x00,0x00,0x00,0x1F,
0xF8,0x00,0x00,0x07,0xFE,0x00,0x00,0x00,0xFF,0xE0,
0x00,0x00,0x1F,0xF8,0x00,0x00,0x03,0xFF,0x00,0x08,
0x00,0x07,0xFE,0x00,0x00,0x03,0xFF,0x80,0x00,0x00,
0x1F,0xF8,0x00,0x00,0x0F,0xFC,0x00,0x00,0x00,0x3F,
0xF0,0x00,0x00,0x7F,0xF0,0x00,0x00,0x00,0xFF,0xC0,
0x00,0x01,0xFF,0x80,0x00,0x00,0x01,0xFF,0x00,0x00,
0x07,0xFE,0x00,0x00,0x00,0x07,0xFE,0x00,0x00,0x3F,
0xF8,0x00,0x00,0x00,0x1F,0xF8,0x00,0x00,0xFF,0xC0,
0x00,0x00,0x00,0x3F,0xF0,0x00,0x07,0xFF,0x00,0x00,
0x00,0x00,0xFF,0xC0,0x00,0x1F,0xF8,0x00,0x00,0x00,
0x01,0xFF,0x00,0x00,0x7F,0xE0,0x00,0x00,0x00,0x07,
0xFE,0x00,0x03,0xFF,0x80,0x00,0x00,0x00,0x1F,0xF8,
0x00,0x0F,0xFC,0x00,0x00,0x00,0x00,0x3F,0xE0,0x00,
0x3F,0xF0,0x00,0x00,0x00,0x00,0xFF,0xC0,0x01,0xFF,
0xC0,0x00,0x00,0x00,0x01,0xFF,0x00,0x07,0xFE,0x00,
0x00,0x00,0x00,0x07,0xFE,0x00,0x3F,0xF8,0x00,0x00,
0x00,0x00,0x1F,0xF8,0x00,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x3F,0xE0,0x03,0xFF,0x00,0x00,0x00,0x00,0x00,
0xFF,0xC0,0x1F,0xFC,0x00,0x00,0x40,0x00,0x00,0x3F,
0xE0,0x0F,0xFC,0x00,0x00,0x00,0x00,0x00,0xFF,0xC0,
0x7F,0xE0,0x00,0x00,0x00,0x00,0x01,0xFF,0x01,0xFF,
0x80,0x00,0x00,0x00,0x00,0x07,0xFC,0x0F,0xFE,0x00,
0x00,0x08,0x00,0x00,0x01,0xFF,0x07,0xFE,0x00,0x00,
0x00,0x00,0x00,0x07,0xFE,0x3F,0xF0,0x00,0x00,0x10,
0x00,0x00,0x01,0xFF,0x1F,0xF8,0x00,0x00,0x09,0x00,
0x00,0x00,0x7F,0xDF,0xF8,0x00,0x00,0x04,0x00,0x00,
0x00,0x1F,0xFF,0xF8,0x00,0x00,0x02,0x40,0x00,0x00,
0x07,0xFF,0xF8,0x00,0x00,0x01,0x00,0x00,0x00,0x01,
0xFF,0xF8,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x7F,
0xF8,0x00,0x00,0x00,0x00,0x18,0x64,0x04,0x06,0x37,
0xFE,0x00,0x00,0x00,0x00,0xFF,0xE0,0x00,0x00,0x00,
0x0F,0xFD,0xFF,0xC0,0x00,0x00,0x00,0x7F,0xFC,0x00,
0x00,0x00,0x07,0xFF,0x87,0xFE,0x00,0x00,0x00,0x03,
0xFF,0xE0,0x00,0x00,0x00,0x3F,0xF1,0xFF,0x80,0x00,
0x00,0x01,0xFF,0xFC,0x00,0x00,0x00,0x0F,0xFC,0x7F,
0xF0,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,0x00,0x07,
0xFF,0x41,0xFF,0x80,0x00,0x00,0x03,0xFF,0xF8,0x00,
0x00,0x00,0x3F,0xF0,0x7F,0xE0,0x00,0x00,0x01,0xFF,
0xFF,0x00,0x00,0x00,0x0F,0xFC,0x1F,0xF8,0x00,0x00,
0x00,0x7F,0xBF,0xC0,0x00,0x00,0x07,0xFF,0x03,0xFF,
0x00,0x00,0x00,0x1F,0xEF,0xF0,0x00,0x00,0x01,0xFF,
0x80,0xFF,0xC0,0x00,0x00,0x0F,0xFB,0xFE,0x00,0x00,
0x00,0x7F,0xE2,0x07,0xFE,0x00,0x00,0x00,0x7F,0x8F,
0xF0,0x00,0x00,0x03,0xFF,0x00,0xFF,0xC0,0x00,0x00,
0x3F,0xE3,0xFC,0x00,0x00,0x01,0xFF,0x84,0x07,0xFE,
0x00,0x00,0x01,0xFE,0x0F,0xF0,0x00,0x00,0x0F,0xFC,
0x00,0xFF,0x80,0x00,0x00,0x7F,0x83,0xFC,0x00,0x00,
0x03,0xFF,0x00,0x3F,0xF0,0x00,0x00,0x3F,0xE0,0x7F,
0x80,0x00,0x01,0xFF,0x82,0x01,0xFF,0x80,0x00,0x01,
0xFE,0x03,0xFC,0x00,0x00,0x0F,0xFC,0x00,0x3F,0xE0,
0x00,0x00,0xFF,0x80,0xFF,0x80,0x00,0x03,0xFE,0x00,
0x0F,0xF8,0x00,0x00,0x3F,0xC0,0x1F,0xE0,0x00,0x00,
0xFF,0x81,0x00,0x7F,0xE0,0x00,0x01,0xFE,0x00,0xFF,
0x00,0x00,0x0F,0xFC,0x00,0x0F,0xF8,0x00,0x00,0xFF,
0x80,0x1F,0xE0,0x00,0x03,0xFE,0x00,0x03,0xFE,0x00,
0x00,0x3F,0xC0,0x07,0xF8,0x00,0x00,0xFF,0x80,0x00,
0xFF,0xC0,0x00,0x0F,0xF0,0x01,0xFE,0x00,0x00,0x7F,
0xE0,0x00,0x3F,0xF0,0x00,0x07,0xFC,0x00,0x3F,0xC0,
0x00,0x1F,0xF8,0x08,0x00,0xFF,0x80,0x00,0x3F,0xC0,
0x01,0xFE,0x00,0x00,0xFF,0x80,0x00,0x3F,0xF0,0x00,
0x1F,0xF0,0x00,0x3F,0x80,0x00,0x7F,0xE0,0x00,0x0F,
0xFC,0x00,0x07,0xFC,0x00,0x0F,0xF0,0x00,0x1F,0xF8,
0x00,0x01,0xFF,0x00,0x01,0xFE,0x00,0x03,0xFC,0x00,
0x07,0xFC,0x00,0x00,0x7F,0xC0,0x00,0x7F,0x80,0x00,
0x7F,0x00,0x01,0xFF,0x00,0x00,0x1F,0xF0,0x00,0x3F,
0xE0,0x00,0x1F,0xE0,0x00,0x7F,0xC0,0x00,0x07,0xFE,
0x00,0x0F,0xF0,0x00,0x07,0xF8,0x00,0x3F,0xF0,0x00,
0x00,0xFF,0x80,0x03,0xFC,0x00,0x01,0xFE,0x00,0x0F,
0xF8,0x00,0x00,0x3F,0xE0,0x01,0xFF,0x00,0x00,0x3F,
0xC0,0x03,0xFE,0x00,0x00,0x0F,0xF8,0x00,0x7F,0x80,
0x00,0x0F,0xF0,0x00,0xFF,0x80,0x00,0x03,0xFF,0x00,
0x1F,0xE0,0x00,0x03,0xFC,0x00,0x7F,0xE0,0x04,0x00,
0x0F,0xF8,0x01,0xFF,0x00,0x00,0x0F,0xF0,0x03,0xFE,
0x00,0x00,0x03,0xFE,0x00,0x7F,0x80,0x00,0x03,0xFC,
0x00,0xFF,0x80,0x00,0x00,0xFF,0xC0,0x1F,0xE0,0x00,
0x00,0x7F,0x80,0x7F,0xE0,0x00,0x00,0x1F,0xF0,0x0F,
0xF8,0x00,0x00,0x1F,0xE0,0x1F,0xF0,0x00,0x00,0x07,
0xFC,0x03,0xFC,0x00,0x00,0x07,0xF8,0x07,0xFC,0x00,
0x00,0x01,0xFF,0x00,0xFF,0x00,0x00,0x00,0xFF,0x01,
0xFF,0x00,0x00,0x00,0x7F,0xC0,0x7F,0xC0,0x00,0x00,
0x3F,0xC0,0x7F,0xC0,0x00,0x00,0x0F,0xF8,0x1F,0xE0,
0x00,0x00,0x0F,0xF0,0x3F,0xE0,0x00,0x80,0x00,0x7F,
0xC0,0xFF,0x00,0x00,0x00,0x3F,0xC1,0xFF,0x00,0x00,
0x00,0x0F,0xF0,0x7F,0xC0,0x00,0x00,0x0F,0xF0,0x7F,
0xC0,0x00,0x00,0x03,0xFE,0x1F,0xE0,0x00,0x00,0x03,
0xFC,0x3F,0xE0,0x00,0x00,0x00,0xFF,0x87,0xF8,0x00,
0x00,0x00,0x7F,0x8F,0xF8,0x00,0x00,0x00,0x3F,0xE3,
0xFE,0x00,0x00,0x00,0x1F,0xE3,0xFE,0x00,0x00,0x00,
0x07,0xF8,0xFF,0x00,0x00,0x00,0x07,0xF8,0xFF,0x00,
0x00,0x00,0x01,0xFE,0x3F,0xC0,0x00,0x00,0x00,0xFE,
0x7F,0xC0,0x00,0x40,0x00,0x0F,0xFB,0xFE,0x00,0x00,
0x00,0x07,0xFB,0xFE,0x00,0x02,0x00,0x00,0x3F,0xDF,
0xE0,0x00,0x00,0x00,0x1F,0xDF,0xE0,0x00,0x00,0x00,
0x0F,0xFF,0xF8,0x00,0x00,0x00,0x07,0xFF,0xF8,0x00,
0x00,0x00,0x03,0xFF,0xFC,0x00,0x00,0x00,0x00,0xFF,
0xFE,0x00,0x01,0x00,0x00,0x0F,0xFF,0xE0,0x00,0x00,
0x00,0x07,0xFF,0xE0,0x00,0x08,0x00,0x00,0x7F,0xFE,
0x00,0x00,0x00,0x00,0x1F,0xFF,0x00,0x00,0x40,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0xFF,0xF0,0x00,
0x02,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,0x00,0x03,
0xFF,0x80,0x00,0x00,0x10,0x64,0x00,0x04,0x20,0x7F,
0xF8,0x00,0x00,0x00,0x07,0xFF,0xC0,0x0F,0xFF,0x00,
0x00,0x00,0x01,0xFF,0xE0,0x01,0xFF,0xE0,0x00,0x00,
0x00,0xFF,0xF0,0x00,0x7F,0xF8,0x00,0x00,0x00,0x7F,
0xFC,0x00,0x0F,0xFF,0x00,0x00,0x00,0x1F,0xFE,0x00,
0x01,0xFF,0xE0,0x00,0x00,0x0F,0xFF,0x00,0x00,0x7F,
0xF8,0x00,0x00,0x07,0xFF,0xC0,0x00,0x0F,0xFF,0x00,
0x00,0x01,0xFF,0xE0,0x00,0x01,0xFF,0xE0,0x00,0x00,
0xFF,0xF0,0x00,0x00,0x7F,0xF8,0x00,0x00,0x7F,0xFC,
0x00,0x00,0x0F,0xFF,0x00,0x00,0x1F,0xFE,0x00,0x00,
0x01,0xFF,0xE0,0x00,0x0F,0xFF,0x00,0x00,0x00,0x3F,
0xF8,0x00,0x07,0xFF,0xC0,0x00,0x00,0x0F,0xFF,0x00,
0x01,0xFF,0xE0,0x00,0x00,0x01,0xFF,0xE0,0x00,0xFF,
0xF0,0x00,0x00,0x00,0x3F,0xFC,0x00,0x7F,0xFC,0x00,
0x00,0x00,0x0F,0xFF,0x00,0x1F,0xFE,0x00,0x00,0x00,
0x01,0xFF,0xE0,0x0F,0xFF,0x00,0x00,0x80,0x00,0x07,
0xFF,0x80,0xFF,0xF0,0x00,0x00,0x00,0x00,0xFF,0xF0,
0x7F,0xF8,0x00,0x00,0x00,0x00,0x1F,0xFC,0x3F,0xFC,
0x00,0x00,0x00,0x00,0x07,0xFF,0x8F,0xFF,0x00,0x00,
0x00,0x00,0x00,0xFF,0xF7,0xFF,0x80,0x00,0x04,0x00,
0x00,0x03,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x7F,0xFF,0xFC,0x00,0x00,0x08,0x00,0x00,0x01,0xFF,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xE0,
0x00,0x00,0x10,0x00,0x00,0x00,0xFF,0xFE,0x00,0x00,
0x00,0x80,0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0x01,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xF8,
0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0x00,0x00,
0x00,0x00,0x00,0x03,0xFF,0xFF,0xE0,0x00,0x00,0x40,
0x00,0x00,0x3F,0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,
0x1F,0xFE,0xFF,0xF0,0x00,0x00,0x00,0x00,0x0F,0xFF,
0x9F,0xFE,0x00,0x00,0x00,0x00,0x03,0xFF,0xC7,0xFF,
0x80,0x00,0x00,0x00,0x01,0xFF,0xE0,0xFF,0xF0,0x00,
0x00,0x00,0x00,0xFF,0xF8,0x1F,0xFE,0x00,0x00,0x00,
0x00,0x3F,0xFC,0x07,0xFF,0x80,0x00,0x00,0x00,0x1F,
0xFE,0x00,0xFF,0xF0,0x00,0x08,0x00,0x01,0xFF,0xE0,
0x03,0xFF,0xC0,0x00,0x00,0x00,0xFF,0xF0,0x00,0x7F,
0xF8,0x00,0x10,0x00,0x0F,0xFF,0x00,0x01,0xFF,0xE0,
0x00,0x00,0x07,0xFF,0x80,0x00,0x3F,0xFC,0x00,0x00,
0x03,0xFF,0xC0,0x00,0x07,0xFF,0x80,0x00,0x01,0xFF,
0xF0,0x00,0x01,0xFF,0xE0,0x00,0x00,0x7F,0xF8,0x00,
0x00,0x3F,0xFC,0x00,0x00,0x3F,0xFC,0x00,0x00,0x07,
0xFF,0x80,0x00,0x1F,0xFF,0x00,0x00,0x00,0xFF,0xE0,
0x00,0x07,0xFF,0x80,0x00,0x00,0x3F,0xFC,0x00,0x03,
0xFF,0xC0,0x00,0x00,0x07,0xFF,0x80,0x01,0xFF,0xF0,
0x00,0x00,0x00,0xFF,0xF0,0x00,0x7F,0xF8,0x00,0x00,
0x00,0x3F,0xFC,0x00,0x3F,0xFC,0x00,0x00,0x00,0x07,
0xFF,0x80,0x1F,0xFF,0x00,0x00,0x00,0x00,0xFF,0xF0,
0x07,0xFF,0x80,0x00,0x00,0x00,0x3F,0xFC,0x03,0xFF,
0xC0,0x00,0x00,0x00,0x07,0xFF,0x81,0xFF,0xF0,0x00,
0x00,0x00,0x00,0xFF,0xF0,0x7F,0xF8,0x00,0x00,0x00,
0x00,0x3F,0xFC,0x3F,0xFC,0x00,0x00,0x00,0x00,0x07,
0xFF,0x9F,0xFF,0x00,0x00,0x00,0x00,0x00,0xFF,0xF0,
0x10,0xA4,0x00,0x04,0x27,0xFF,0x80,0x00,0x00,0x00,
0x00,0x1F,0xFE,0x7F,0xF8,0x00,0x00,0x00,0x00,0x07,
0xFF,0x87,0xFF,0x80,0x00,0x00,0x00,0x00,0xFF,0xE0,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x3F,0xFC,0x0F,0xFF,
0x00,0x00,0x00,0x00,0x0F,0xFF,0x00,0xFF,0xF0,0x00,
0x00,0x00,0x01,0xFF,0xC0,0x1F,0xFE,0x00,0x00,0x00,
0x00,0x7F,0xF8,0x01,0xFF,0xE0,0x00,0x00,0x00,0x1F,
0xFE,0x00,0x1F,0xFE,0x00,0x00,0x00,0x03,0xFF,0x80,
0x03,0xFF,0xC0,0x00,0x00,0x00,0xFF,0xF0,0x00,0x3F,
0xFC,0x00,0x00,0x00,0x3F,0xFC,0x00,0x03,0xFF,0xC0,
0x00,0x00,0x07,0xFF,0x00,0x00,0x7F,0xF8,0x00,0x00,
0x01,0xFF,0xE0,0x00,0x07,0xFF,0x80,0x00,0x00,0x3F,
0xF8,0x00,0x00,0x7F,0xF8,0x00,0x00,0x0F,0xFE,0x00,
0x00,0x0F,0xFF,0x00,0x00,0x03,0xFF,0xC0,0x00,0x00,
0xFF,0xF0,0x00,0x00,0x7F,0xF0,0x00,0x00,0x0F,0xFF,
0x00,0x00,0x1F,0xFC,0x00,0x00,0x01,0xFF,0xE0,0x00,
0x07,0xFF,0x80,0x00,0x00,0x1F,0xFE,0x00,0x00,0xFF,
0xE0,0x00,0x00,0x01,0xFF,0xE0,0x00,0x3F,0xF8,0x00,
0x00,0x00,0x1F,0xFC,0x00,0x0F,0xFF,0x00,0x00,0x00,
0x03,0xFF,0xC0,0x01,0xFF,0xC0,0x00,0x00,0x00,0x3F,
0xFC,0x00,0x7F,0xF0,0x00,0x00,0x00,0x03,0xFF,0x80,
0x0F,0xFC,0x00,0x00,0x00,0x00,0x7F,0xF8,0x03,0xFF,
0x80,0x00,0x00,0x00,0x07,0xFF,0x80,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x7F,0xF0,0x1F,0xF8,0x00,0x00,0x00,
0x00,0x0F,0xFF,0x07,0xFF,0x00,0x00,0x00,0x00,0x00,
0xFF,0xF1,0xFF,0xC0,0x00,0x00,0x00,0x00,0x0F,0xFE,
0x3F,0xF0,0x00,0x00,0x00,0x00,0x01,0xFF,0xEF,0xFE,
0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,0x80,0x00,
0x01,0x00,0x00,0x00,0x3F,0xFF,0xFC,0x00,0x00,0x00,
0x00,0x00,0x03,0xFF,0xFF,0x00,0x00,0x00,0x80,0x00,
0x00,0x07,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,
0x7F,0xFE,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0xFF,
0xF0,0x00,0x00,0x01,0xA0,0x00,0x00,0x01,0xFF,0x80,
0x00,0x00,0x06,0x80,0x00,0x00,0x07,0xFE,0x00,0x00,
0x00,0x1A,0x00,0x00,0x00,0x1F,0xF8,0x00,0x00,0x00,
0x68,0x00,0x00,0x00,0x7F,0xE0,0x00,0x00,0x01,0x20,
0x00,0x00,0x01,0xFF,0x80,0x00,0x00,0x00,0x0E,0x64,
0x08,0x03,0xDD,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,
0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,
0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,0x00,0x01,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x7F,0xF8,0x00,
0x00,0x00,0x00,0x00,0x3F,0xFC,0x00,0x00,0x00,0x00,
0x00,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,
0x80,0x00,0x00,0x00,0x00,0x03,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x01,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x7F,0xFC,0x00,
0x00,0x00,0x00,0x00,0x1F,0xFE,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,
0x80,0x00,0x00,0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,
0x7F,0xF8,0x00,0x00,0x00,0x00,0x00,0x3F,0xFC,0x00,
0x00,0x00,0x00,0x00,0x1F,0xFF,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0x80,0x00,0x00,0x00,0x00,0x03,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x01,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x00,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,0x1F,0xFE,0x00,
0x00,0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,0x00,
0x00,0x07,0xFF,0xC0,0x00,0x00,0x00,0x00,0x03,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x00,0xFF,0xF0,0x00,0x00,
0x00,0x00,0x00,0x7F,0xF8,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFC,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0x00,
0x00,0x00,0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,0x00,
0x00,0x03,0xFF,0xC0,0x00,0x00,0x00,0x00,0x01,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x00,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x00,0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,
0x1F,0xFE,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x00,
0x00,0x00,0x00,0x00,0x07,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x7F,0xF8,0x00,0x00,
0x00,0x00,0x00,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,
0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0x80,
0x00,0x00,0x00,0x00,0x03,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x01,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x00,0x7F,0xFC,0x00,0x00,
0x00,0x00,0x00,0x1F,0xFE,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFF,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x7F,
0xF8,0x00,0x00,0x00,0x00,0x00,0x3F,0xFE,0x00,0x00,
0x00,0x00,0x00,0x1B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x04,
0xEE,0x1B,0x61,0xCD,0xFF,0xFF,0xEF,0xFF,0xFF,0xBF,
0xF0,0x03,0x7F,0xE0,0x06,0xFF,0xC0,0x0D,0xFF,0x80,
0x1B,0xFF,0x00,0x37,0xFE,0x00,0x6F,0xFC,0x00,0xDF,
0xF8,0x01,0xBF,0xF0,0x03,0x7F,0xE0,0x06,0x7F,0xC0,
0x0D,0xFF,0xFF,0xEF,0xFF,0xFE,0x07,0x64,0x00,0x01,
0xC8,0xFF,0x00,0x00,0x03,0xFE,0x00,0x00,0x10,0xFF,
0x00,0x00,0x03,0xFE,0x00,0x00,0x24,0xFF,0x00,0x00,
0x03,0xFE,0x00,0x00,0x40,0xFF,0x00,0x00,0x03,0xFE,
0x00,0x00,0x80,0xFF,0x00,0x00,0x03,0xFE,0x00,0x01,
0x20,0xFF,0x00,0x00,0x03,0xFE,0x00,0x02,0x00,0xFF,
0x00,0x00,0x03,0xFE,0x00,0x04,0x80,0xFF,0x00,0x00,
0x03,0xFE,0x00,0x08,0x00,0xFF,0x00,0x00,0x03,0xFE,
0x00,0x12,0x00,0xFF,0x00,0x00,0x03,0xFE,0x00,0x20,
0x00,0xFF,0x00,0x00,0x03,0xFE,0x00,0x40,0x00,0xFF,
0x00,0x00,0x03,0xFE,0x00,0x90,0x00,0xFF,0x00,0x00,
0x03,0xFE,0x01,0x00,0x00,0xFF,0x00,0x00,0x03,0xFE,
0x02,0x40,0x00,0xFF,0x00,0x00,0x03,0xFE,0x04,0x00,
0x00,0xFF,0x00,0x00,0x03,0xFE,0x09,0x00,0x00,0xFF,
0x00,0x00,0x03,0xFE,0x10,0x00,0x00,0xFF,0x00,0x00,
0x03,0xFE,0x20,0x00,0x00,0xFF,0x00,0x00,0x03,0xFE,
0x48,0x00,0x00,0xFF,0x00,0x00,0x03,0xFE,0x80,0x00,
0x00,0xFF,0x00,0x00,0x03,0xFE,0x00,0x00,0x07,0xF8,
0x04,0xEE,0x0F,0x61,0xCD,0xFF,0xFF,0xEF,0xFF,0xFF,
0xA0,0x07,0xFF,0x40,0x0F,0xFE,0x80,0x1F,0xFD,0x00,
0x3F,0xFA,0x00,0x7F,0xF4,0x00,0xFF,0xE8,0x01,0xFF,
0xD0,0x03,0xFF,0xA0,0x07,0xFF,0x40,0x0F,0xFE,0x00,
0x1F,0xFD,0xFF,0xFF,0xEF,0xFF,0xFE,0x09,0xD3,0x89,
0x12,0xB0,0x00,0x07,0xF0,0x00,0x09,0x00,0x01,0xFF,
0x00,0x01,0x00,0x00,0x7F,0xF0,0x00,0x20,0x00,0x1F,
0xFF,0x00,0x00,0x00,0x3F,0xFF,0x00,0x04,0x00,0x07,
0xF7,0xF0,0x00,0x00,0x0F,0xF7,0xF8,0x00,0x00,0x0F,
0xE3,0xF8,0x00,0x80,0x03,0xFC,0x7F,0x80,0x00,0x03,
0xF8,0x3F,0x80,0x10,0x00,0xFF,0x07,0xF8,0x02,0x00,
0x3F,0xC0,0x7F,0x80,0x00,0x3F,0x80,0x3F,0x80,0x40,
0x0F,0xF0,0x07,0xF8,0x09,0x03,0xFC,0x00,0x7F,0x81,
0x00,0xFF,0x00,0x07,0xF8,0x01,0xFF,0x00,0x07,0xFC,
0x01,0xFE,0x00,0x03,0xFC,0x20,0x7F,0xC0,0x00,0x7F,
0xC0,0x7F,0x80,0x00,0x3F,0xC4,0x1F,0xF0,0x00,0x07,
0xFC,0x97,0xFC,0x00,0x00,0x7F,0xCF,0xF8,0x00,0x00,
0x3F,0xE0,0x0E,0x83,0x7F,0x63,0x8C,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC0,0x04,0x87,0x11,0xD2,0x17,
0xFF,0x80,0x7F,0xF8,0x07,0xFF,0x00,0x7F,0xF0,0x80,
0xFF,0xC0,0x0F,0xFC,0x00,0xFF,0x88,0x01,0xFF,0x00,
0x1F,0xF0,0x01,0xFE,0x00,0x1F,0xC0,0x01,0xFC,0x0C,
0x1B,0x13,0xFB,0x80,0x00,0x01,0xFF,0xF0,0x00,0x00,
0x00,0x0F,0xFF,0xFF,0x80,0x00,0x00,0x3F,0xFF,0xFF,
0xF8,0x00,0x00,0x7F,0xFF,0xFF,0xFE,0x00,0x00,0x7F,
0xFF,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0xFF,0xFF,0xF0,
0x00,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x7F,0xFF,0xFF,
0xFF,0xFE,0x00,0x7F,0xFE,0x00,0x7F,0xFF,0x80,0x7F,
0xF8,0x00,0x07,0xFF,0xC0,0x3F,0xF8,0x00,0x01,0xFF,
0xE0,0x3F,0xF8,0x00,0x00,0x7F,0xF8,0x1F,0xF8,0x00,
0x00,0x1F,0xFC,0x0F,0xF8,0x00,0x00,0x0F,0xFE,0x0F,
0xFC,0x00,0x00,0x03,0xFF,0x07,0xFC,0x00,0x00,0x01,
0xFF,0x80,0x3E,0x00,0x00,0x00,0xFF,0xC4,0x80,0x00,
0x00,0x00,0x0F,0xFC,0x00,0x00,0x00,0x00,0x1F,0xFE,
0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x0F,
0xFF,0xFF,0x80,0x00,0x07,0xFF,0xFF,0xFF,0xC0,0x00,
0x3F,0xFF,0xFF,0xFF,0xE0,0x00,0xFF,0xFF,0xFF,0xFF,
0xF0,0x01,0xFF,0xFF,0xFF,0xFF,0xF8,0x01,0xFF,0xFF,
0xFF,0xFF,0xFC,0x01,0xFF,0xFF,0xFF,0xF7,0xFE,0x01,
0xFF,0xFF,0xFF,0x83,0xFF,0x01,0xFF,0xFF,0xF0,0x01,
0xFF,0x81,0xFF,0xFE,0x00,0x00,0xFF,0xC0,0xFF,0xF0,
0x00,0x00,0x7F,0xE0,0xFF,0xE0,0x00,0x00,0x3F,0xF0,
0x7F,0xE0,0x00,0x00,0x1F,0xF8,0x7F,0xE0,0x00,0x00,
0x0F,0xFC,0x47,0xFC,0x00,0x00,0x01,0xFF,0xC4,0x7F,
0xC0,0x00,0x00,0x3F,0xFC,0x3F,0xE0,0x00,0x00,0x3F,
0xFE,0x1F,0xF8,0x00,0x00,0x3F,0xFF,0x0F,0xFC,0x00,
0x00,0x3F,0xFF,0x83,0xFF,0x00,0x00,0x3F,0xFF,0xC1,
0xFF,0xC0,0x00,0x7F,0xFF,0xE0,0xFF,0xFC,0x01,0xFF,
0xFF,0xF0,0x3F,0xFF,0xFF,0xFF,0xEF,0xFC,0x1F,0xFF,
0xFF,0xFF,0xE7,0xFE,0x07,0xFF,0xFF,0xFF,0xE1,0xFF,
0x01,0xFF,0xFF,0xFF,0xC0,0xFF,0x80,0x7F,0xFF,0xFF,
0xC0,0x7F,0xE0,0x0F,0xFF,0xFF,0x80,0x1F,0xF0,0x01,
0xFF,0xFF,0x00,0x07,0xFC,0x00,0x1F,0xF8,0x00,0x00,
0x00,0x0B,0x64,0x9B,0xFB,0x8D,0xFF,0x80,0x00,0x00,
0x00,0x06,0xFF,0xC0,0x00,0x00,0x00,0x02,0xFF,0xE0,
0x00,0x00,0x00,0x00,0xFF,0x80,0x1F,0xF0,0x00,0x03,
0xFE,0x03,0xFF,0xF8,0x00,0x0F,0xF8,0x3F,0xFF,0xF8,
0x00,0x3F,0xE1,0xFF,0xFF,0xF8,0x00,0xFF,0x8F,0xFF,
0xFF,0xF0,0x03,0xFE,0x7F,0xFF,0xFF,0xE0,0x0F,0xFB,
0xFF,0xFF,0xFF,0xC0,0x3F,0xFF,0xFF,0xFF,0xFF,0x80,
0xFF,0xFF,0xE0,0x3F,0xFF,0x03,0xFF,0xFE,0x00,0x3F,
0xFE,0x0F,0xFF,0xE0,0x00,0x3F,0xF8,0x3F,0xFF,0x00,
0x00,0x7F,0xF0,0xFF,0xF8,0x00,0x00,0xFF,0xC3,0xFF,
0xE0,0x00,0x01,0xFF,0x8F,0xFF,0x00,0x00,0x07,0xFE,
0x3F,0xF8,0x00,0x00,0x0F,0xF8,0xFF,0xE0,0x00,0x00,
0x3F,0xF4,0xFF,0xE0,0x00,0x00,0x0F,0xF9,0xFF,0x80,
0x00,0x00,0x3F,0xFD,0xFF,0x80,0x00,0x00,0x0F,0xFD,
0xFF,0xC0,0x00,0x00,0x07,0xFD,0xFF,0x00,0x00,0x00,
0x3F,0xE9,0xFF,0xC0,0x00,0x00,0x1F,0xF3,0xFF,0x00,
0x00,0x00,0xFF,0xCF,0xFE,0x00,0x00,0x03,0xFE,0x3F,
0xF8,0x00,0x00,0x1F,0xF8,0xFF,0xF0,0x00,0x00,0xFF,
0xC3,0xFF,0xE0,0x00,0x03,0xFF,0x0F,0xFF,0xC0,0x00,
0x1F,0xF8,0x3F,0xFF,0x80,0x00,0xFF,0xE0,0xFF,0xFF,
0x00,0x0F,0xFF,0x03,0xFF,0xFF,0x80,0xFF,0xFC,0x0F,
0xFB,0xFF,0xFF,0xFF,0xE0,0x3F,0xEF,0xFF,0xFF,0xFF,
0x00,0xFF,0x9F,0xFF,0xFF,0xF8,0x03,0xFE,0x3F,0xFF,
0xFF,0xC0,0x0F,0xF8,0x7F,0xFF,0xFC,0x00,0x3F,0xE0,
0xFF,0xFF,0xE0,0x00,0xFF,0x80,0xFF,0xFE,0x00,0x00,
0x00,0x00,0x7F,0xC0,0x00,0x00,0x0B,0x5B,0x13,0xFB,
0x20,0x00,0x01,0xFF,0xC0,0x00,0x00,0x00,0x3F,0xFF,
0xE0,0x00,0x00,0x07,0xFF,0xFF,0xE0,0x00,0x00,0x3F,
0xFF,0xFF,0xE0,0x00,0x03,0xFF,0xFF,0xFF,0xC0,0x00,
0x1F,0xFF,0xFF,0xFF,0x80,0x00,0xFF,0xFF,0xFF,0xFF,
0x00,0x07,0xFF,0xFF,0xFF,0xFE,0x00,0x3F,0xFF,0x80,
0xFF,0xFC,0x01,0xFF,0xF0,0x00,0xFF,0xF0,0x07,0xFF,
0x00,0x00,0xFF,0xE0,0x3F,0xF8,0x00,0x01,0xFF,0x80,
0xFF,0xC0,0x00,0x03,0xFF,0x07,0xFE,0x00,0x00,0x0F,
0xFC,0x1F,0xF8,0x00,0x00,0x1F,0xF0,0x7F,0xC0,0x00,
0x00,0x7F,0xE3,0xFF,0x00,0x00,0x00,0xFF,0x8F,0xF8,
0x00,0x00,0x03,0xE0,0x87,0xFC,0x00,0x00,0x00,0x00,
0x3F,0xF0,0x00,0x00,0x00,0x01,0xBF,0xF0,0x00,0x00,
0x00,0x00,0xCF,0xF8,0x00,0x00,0x00,0x00,0x1F,0xF0,
0x00,0x00,0x03,0xE0,0x7F,0xC0,0x00,0x00,0x0F,0xF9,
0xFF,0x00,0x00,0x00,0x7F,0xE7,0xFE,0x00,0x00,0x01,
0xFF,0x0F,0xF8,0x00,0x00,0x07,0xFD,0x07,0xFE,0x00,
0x00,0x07,0xFE,0x0F,0xFC,0x00,0x00,0x3F,0xF0,0x3F,
0xF8,0x00,0x01,0xFF,0xC0,0x7F,0xF0,0x00,0x0F,0xFE,
0x01,0xFF,0xF0,0x00,0x7F,0xF8,0x03,0xFF,0xF0,0x0F,
0xFF,0xC0,0x07,0xFF,0xFF,0xFF,0xFE,0x00,0x0F,0xFF,
0xFF,0xFF,0xF0,0x00,0x1F,0xFF,0xFF,0xFF,0x80,0x00,
0x3F,0xFF,0xFF,0xFC,0x00,0x00,0x7F,0xFF,0xFF,0xE0,
0x00,0x00,0x7F,0xFF,0xFE,0x00,0x00,0x00,0x7F,0xFF,
0xE0,0x00,0x00,0x00,0x1F,0xF8,0x00,0x00,0x0B,0x64,
0x8F,0xFB,0x8D,0x00,0x00,0x00,0x00,0x0F,0xFE,0x80,
0x00,0x00,0x00,0x07,0xFE,0xC0,0x00,0x00,0x00,0x03,
0xFE,0x00,0x00,0x7F,0xC0,0x0F,0xF8,0x00,0x0F,0xFF,
0xE0,0x3F,0xE0,0x00,0xFF,0xFF,0xE0,0xFF,0x80,0x0F,
0xFF,0xFF,0xC3,0xFE,0x00,0x7F,0xFF,0xFF,0x8F,0xF8,
0x03,0xFF,0xFF,0xFF,0x3F,0xE0,0x1F,0xFF,0xFF,0xFE,
0xFF,0x80,0xFF,0xFF,0xFF,0xFF,0xFE,0x07,0xFF,0xE0,
0x3F,0xFF,0xF8,0x3F,0xFC,0x00,0x3F,0xFF,0xE0,0xFF,
0xE0,0x00,0x3F,0xFF,0x87,0xFF,0x00,0x00,0x7F,0xFE,
0x1F,0xF8,0x00,0x00,0xFF,0xFC,0x1F,0xF8,0x00,0x00,
0x3F,0xFC,0x7F,0xC0,0x00,0x00,0x7F,0xF3,0xFF,0x00,
0x00,0x01,0xFF,0xE5,0xFF,0x00,0x00,0x00,0x7F,0xEF,
0xFC,0x00,0x00,0x01,0xFF,0xEF,0xFC,0x00,0x00,0x00,
0x7F,0xEF,0xFE,0x00,0x00,0x00,0x3F,0xEF,0xFC,0x00,
0x00,0x00,0xFF,0xCB,0xFE,0x00,0x00,0x00,0xFF,0xCF,
0xFC,0x00,0x00,0x07,0xFF,0x1F,0xF0,0x00,0x00,0x1F,
0xFC,0x7F,0xE0,0x00,0x00,0xFF,0xF0,0xFF,0x80,0x00,
0x03,0xFF,0xC3,0xFF,0x00,0x00,0x1F,0xFF,0x0F,0xFE,
0x00,0x00,0xFF,0xFC,0x1F,0xFC,0x00,0x07,0xFF,0xF0,
0x3F,0xFC,0x00,0x7F,0xFF,0xC0,0xFF,0xFC,0x07,0xFF,
0xFF,0x01,0xFF,0xFF,0xFF,0xF7,0xFC,0x03,0xFF,0xFF,
0xFF,0xDF,0xF0,0x07,0xFF,0xFF,0xFE,0x7F,0xC0,0x0F,
0xFF,0xFF,0xF1,0xFF,0x00,0x0F,0xFF,0xFF,0x87,0xFC,
0x00,0x1F,0xFF,0xFC,0x1F,0xF0,0x00,0x1F,0xFF,0xC0,
0x7F,0xC0,0x00,0x0F,0xF8,0x00,0x00,0x0C,0x5B,0x0F,
0xFB,0x80,0x00,0x00,0xFF,0xE0,0x00,0x00,0x00,0x01,
0xFF,0xFF,0x80,0x00,0x00,0x03,0xFF,0xFF,0xF8,0x00,
0x00,0x03,0xFF,0xFF,0xFF,0x80,0x00,0x01,0xFF,0xFF,
0xFF,0xF0,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,
0x7F,0xFF,0xFF,0xFF,0xE0,0x00,0x3F,0xFF,0xFF,0xFF,
0xFC,0x00,0x1F,0xFF,0x80,0x3F,0xFF,0x80,0x0F,0xFF,
0x00,0x01,0xFF,0xE0,0x07,0xFF,0x00,0x00,0x1F,0xFC,
0x01,0xFF,0x80,0x00,0x03,0xFF,0x80,0xFF,0xC0,0x00,
0x00,0x7F,0xE0,0x3F,0xE0,0x00,0x00,0x0F,0xFC,0x1F,
0xF0,0x00,0x00,0x01,0xFF,0x07,0xFC,0x00,0x00,0x00,
0x3F,0xC8,0x7F,0xC0,0x00,0x00,0x01,0xFF,0x43,0xFC,
0x00,0x00,0x00,0x07,0xF8,0xFF,0x00,0x00,0x00,0x01,
0xFF,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x5F,0xF0,0x00,0x00,0x00,0x00,
0x07,0xFE,0x00,0x00,0x00,0x00,0x02,0x1F,0xF0,0x00,
0x00,0x00,0x00,0x07,0xFE,0x00,0x00,0x00,0x00,0x01,
0xFF,0x80,0x00,0x00,0x03,0xC0,0x3F,0xF0,0x00,0x00,
0x01,0xFF,0x8F,0xFC,0x00,0x00,0x00,0x7F,0xC3,0xFF,
0x80,0x00,0x00,0x3F,0xF0,0x7F,0xF0,0x00,0x00,0x1F,
0xF8,0x1F,0xFE,0x00,0x00,0x0F,0xFE,0x03,0xFF,0xC0,
0x00,0x07,0xFF,0x00,0x7F,0xFC,0x00,0x07,0xFF,0xC0,
0x1F,0xFF,0xE0,0x0F,0xFF,0xE0,0x03,0xFF,0xFF,0xFF,
0xFF,0xF0,0x00,0x7F,0xFF,0xFF,0xFF,0xF8,0x00,0x0F,
0xFF,0xFF,0xFF,0xFC,0x00,0x00,0xFF,0xFF,0xFF,0xFE,
0x00,0x00,0x1F,0xFF,0xFF,0xFF,0x00,0x00,0x01,0xFF,
0xFF,0xFF,0x00,0x00,0x00,0x0F,0xFF,0xFE,0x00,0x00,
0x00,0x00,0x7F,0xF8,0x00,0x00,0x07,0xE4,0x84,0x01,
0xD0,0x00,0x01,0xFF,0xC0,0x00,0x0F,0xFF,0xF0,0x00,
0x3F,0xFF,0xF0,0x00,0x7F,0xFF,0xE0,0x00,0xFF,0xFF,
0xE0,0x01,0xFF,0xFF,0xE8,0x00,0x7F,0xFF,0xFC,0x00,
0x7F,0xF8,0x04,0x00,0xFF,0xE0,0x01,0x00,0x1F,0xF8,
0x00,0x34,0x03,0xFE,0x00,0x04,0x00,0x7F,0xC0,0x00,
0xDF,0xFF,0xFF,0xFE,0x0F,0xFF,0xFF,0xFE,0x1A,0x01,
0xFF,0x00,0x03,0x40,0x3F,0xE0,0x00,0x68,0x07,0xFC,
0x00,0x0D,0x00,0xFF,0x80,0x01,0xA0,0x1F,0xF0,0x00,
0x34,0x03,0xFE,0x00,0x04,0x00,0x7F,0xC0,0x00,0x0B,
0x65,0x0F,0x5B,0x70,0x00,0x03,0xFE,0x00,0x00,0x00,
0x00,0x7F,0xFF,0x01,0xFF,0x00,0x07,0xFF,0xFE,0x07,
0xFC,0x00,0x7F,0xFF,0xFE,0x1F,0xF0,0x03,0xFF,0xFF,
0xFC,0x7F,0xC0,0x1F,0xFF,0xFF,0xF9,0xFF,0x00,0xFF,
0xFF,0xFF,0xF7,0xFC,0x07,0xFF,0xFF,0xFF,0xFF,0xF0,
0x3F,0xFF,0x01,0xFF,0xFF,0xC1,0xFF,0xF0,0x01,0xFF,
0xFF,0x07,0xFF,0x00,0x01,0xFF,0xFC,0x3F,0xF8,0x00,
0x03,0xFF,0xF0,0xFF,0xC0,0x00,0x07,0xFF,0xE0,0xFF,
0xC0,0x00,0x01,0xFF,0xE3,0xFE,0x00,0x00,0x03,0xFF,
0x9F,0xF8,0x00,0x00,0x0F,0xFF,0x2F,0xF8,0x00,0x00,
0x03,0xFF,0x7F,0xC0,0x00,0x00,0x0F,0xFF,0x7F,0xE0,
0x00,0x00,0x03,0xFF,0x5F,0xF0,0x00,0x00,0x01,0xFF,
0x7F,0xC0,0x00,0x00,0x0F,0xFE,0x5F,0xF0,0x00,0x00,
0x07,0xFE,0x7F,0xE0,0x00,0x00,0x3F,0xF8,0xFF,0x80,
0x00,0x00,0xFF,0xE3,0xFE,0x00,0x00,0x07,0xFF,0x8F,
0xFC,0x00,0x00,0x1F,0xFE,0x1F,0xF8,0x00,0x00,0xFF,
0xF8,0x7F,0xF0,0x00,0x07,0xFF,0xE0,0xFF,0xE0,0x00,
0x3F,0xFF,0x83,0xFF,0xC0,0x03,0xFF,0xFE,0x07,0xFF,
0xE0,0x3F,0xFF,0xF8,0x0F,0xFF,0xFF,0xFF,0xFF,0xE0,
0x1F,0xFF,0xFF,0xFF,0xFF,0x80,0x3F,0xFF,0xFF,0xFB,
0xFE,0x00,0x7F,0xFF,0xFF,0xCF,0xF8,0x00,0xFF,0xFF,
0xFC,0x3F,0xE0,0x01,0xFF,0xFF,0xE0,0xFF,0x80,0x00,
0xFF,0xFE,0x03,0xFE,0x00,0x00,0x7F,0xC0,0x0F,0xFC,
0x00,0x00,0x00,0x00,0x07,0xFC,0x00,0x00,0x00,0x00,
0x1F,0xE0,0x00,0x00,0x00,0x00,0xFF,0x8F,0x80,0x00,
0x00,0x03,0xFE,0x3F,0xE0,0x00,0x00,0x0F,0xF8,0xFF,
0x80,0x00,0x00,0x7F,0xE3,0xFF,0x00,0x00,0x01,0xFF,
0x0F,0xFC,0x00,0x00,0x0F,0xFC,0x1F,0xF8,0x00,0x00,
0x7F,0xF0,0x7F,0xF0,0x00,0x03,0xFF,0x81,0xFF,0xE0,
0x00,0x3F,0xFE,0x03,0xFF,0xF0,0x07,0xFF,0xF0,0x0F,
0xFF,0xFF,0xFF,0xFF,0x80,0x1F,0xFF,0xFF,0xFF,0xFC,
0x00,0x3F,0xFF,0xFF,0xFF,0xE0,0x00,0x7F,0xFF,0xFF,
0xFF,0x00,0x00,0x7F,0xFF,0xFF,0xF8,0x00,0x00,0xFF,
0xFF,0xFF,0x80,0x00,0x00,0x7F,0xFF,0xF0,0x00,0x00,
0x00,0x1F,0xFC,0x00,0x00,0x0A,0xA4,0x1C,0x03,0x8D,
0xFF,0x80,0x00,0x00,0x00,0x37,0xFE,0x00,0x00,0x00,
0x00,0xBF,0xF8,0x00,0x00,0x00,0x01,0xFF,0x00,0x1F,
0xF0,0x00,0x3F,0xE0,0x1F,0xFF,0xE0,0x07,0xFC,0x0F,
0xFF,0xFF,0x00,0xFF,0x87,0xFF,0xFF,0xF0,0x1F,0xF1,
0xFF,0xFF,0xFF,0x03,0xFE,0x7F,0xFF,0xFF,0xF0,0x7F,
0xDF,0xFF,0xFF,0xFF,0x0F,0xFF,0xFF,0xFF,0xFF,0xF1,
0xFF,0xFF,0xC0,0x7F,0xFE,0x3F,0xFF,0xC0,0x03,0xFF,
0xE7,0xFF,0xE0,0x00,0x1F,0xFC,0xFF,0xF8,0x00,0x01,
0xFF,0x9F,0xFE,0x00,0x00,0x3F,0xF4,0x7F,0xF0,0x00,
0x00,0x7F,0xEF,0xFC,0x00,0x00,0x0F,0xFE,0x7F,0xF0,
0x00,0x00,0x1F,0xFD,0xFF,0x80,0x00,0x00,0x7F,0xF7,
0xFE,0x00,0x00,0x01,0xFF,0xDF,0xF8,0x00,0x00,0x07,
0xFF,0x7F,0xE0,0x00,0x00,0x1F,0xFC,0xFF,0x80,0x00,
0x00,0x7F,0xC0,0x02,0x64,0x1C,0x01,0x6D,0xFF,0xC7,
0xFF,0x40,0x14,0x00,0xDF,0xFE,0xFF,0xF7,0xFF,0xBF,
0xFD,0xFF,0xEF,0xFF,0x7F,0xF3,0xFF,0x04,0xEE,0xF3,
0x59,0x6D,0x00,0x3F,0xF0,0x00,0x7F,0xF4,0x00,0x00,
0x50,0x00,0x00,0xD0,0x03,0xFF,0xA0,0x07,0xFF,0x40,
0x0F,0xFE,0x80,0x1F,0xFD,0x00,0x3F,0xFA,0x00,0x7F,
0xF4,0x00,0xFF,0xE8,0x01,0xFF,0xB0,0x03,0xFE,0x00,
0x7F,0xF0,0x00,0xFF,0x88,0x3F,0xF8,0xFF,0xFF,0x8F,
0xFF,0xF1,0xFF,0xFF,0x1F,0xFF,0xE1,0xFF,0xFC,0x1F,
0xFF,0x81,0xFF,0xF0,0x0F,0xF8,0x00,0x0A,0xE4,0x18,
0x03,0x2D,0xFF,0x80,0x00,0x00,0x00,0x1B,0xFF,0x00,
0x00,0x00,0x00,0x33,0xFE,0x00,0x00,0x00,0x00,0x3F,
0xE0,0x00,0x01,0xFF,0xE3,0xFE,0x00,0x00,0x3F,0xFC,
0x3F,0xE0,0x00,0x07,0xFF,0x83,0xFE,0x00,0x00,0xFF,
0xF0,0x3F,0xE0,0x00,0x1F,0xFE,0x03,0xFE,0x00,0x03,
0xFF,0xC0,0x3F,0xE0,0x00,0x7F,0xF8,0x03,0xFE,0x00,
0x0F,0xFF,0x00,0x3F,0xE0,0x01,0xFF,0xE0,0x03,0xFE,
0x00,0x3F,0xFC,0x00,0x3F,0xE0,0x07,0xFF,0x80,0x03,
0xFE,0x00,0xFF,0xF0,0x00,0x3F,0xE0,0x3F,0xFE,0x00,
0x03,0xFE,0x07,0xFF,0xC0,0x00,0x3F,0xE0,0xFF,0xF8,
0x00,0x03,0xFE,0x1F,0xFF,0x00,0x00,0x3F,0xE3,0xFF,
0xE0,0x00,0x03,0xFE,0x7F,0xFC,0x00,0x00,0x3F,0xEF,
0xFF,0x80,0x00,0x03,0xFF,0xFF,0xF0,0x00,0x00,0x47,
0xFF,0xFF,0xF0,0x00,0x00,0x7F,0xFF,0xFF,0x80,0x00,
0x08,0xFF,0xFF,0xFF,0x80,0x00,0x0F,0xFF,0xFF,0xFC,
0x00,0x00,0xFF,0xFE,0xFF,0xC0,0x00,0x0F,0xFF,0x87,
0xFE,0x00,0x00,0xFF,0xF0,0x7F,0xF0,0x00,0x0F,0xFE,
0x03,0xFF,0x00,0x00,0xFF,0xC0,0x1F,0xF8,0x00,0x0F,
0xF8,0x01,0xFF,0xC0,0x00,0xFF,0x80,0x0F,0xFC,0x00,
0x0F,0xF8,0x00,0xFF,0xE0,0x00,0xFF,0x80,0x07,0xFF,
0x00,0x0F,0xF8,0x00,0x3F,0xF0,0x00,0xFF,0x80,0x03,
0xFF,0x80,0x0F,0xF8,0x00,0x1F,0xFC,0x00,0xFF,0x80,
0x00,0xFF,0xC0,0x0F,0xF8,0x00,0x0F,0xFE,0x00,0xFF,
0x80,0x00,0x7F,0xF0,0x0F,0xF8,0x00,0x03,0xFF,0x00,
0xFF,0x80,0x00,0x3F,0xF8,0x0F,0xF8,0x00,0x01,0xFF,
0x80,0xFF,0x80,0x00,0x0F,0xFC,0x0F,0xF8,0x00,0x00,
0xFF,0xE0,0xFF,0x80,0x00,0x07,0xFE,0x0F,0xF8,0x00,
0x00,0x3F,0xF0,0xFF,0x80,0x00,0x03,0xFF,0x8F,0xF8,
0x00,0x00,0x1F,0xF8,0xFF,0x80,0x00,0x01,0xFF,0xCF,
0xF8,0x00,0x00,0x0F,0xFE,0x02,0x64,0x1C,0x01,0x6D,
0xFF,0xEF,0xFF,0x7F,0xFB,0xFF,0xDF,0xFE,0xFF,0xF7,
0xFF,0xBF,0xFD,0xFF,0xEF,0xFE,0x3F,0xE0,0x11,0xDA,
0x98,0x05,0x40,0x00,0x00,0x7F,0xC0,0x00,0x00,0xFF,
0x80,0x07,0xFC,0x03,0xFF,0xF8,0x00,0x0F,0xFF,0xF0,
0x07,0xFC,0x0F,0xFF,0xFE,0x00,0x1F,0xFF,0xFC,0x07,
0xFC,0x1F,0xFF,0xFF,0x00,0x7F,0xFF,0xFE,0x07,0xFC,
0x3F,0xFF,0xFF,0x80,0xFF,0xFF,0xFF,0x07,0xFC,0x7F,
0xFF,0xFF,0xC1,0xFF,0xFF,0xFF,0x87,0xFC,0xFF,0xFF,
0xFF,0xC3,0xFF,0xFF,0xFF,0x87,0xFD,0xFF,0xFF,0xFF,
0xE7,0xFF,0xFF,0xFF,0xC7,0xFF,0xFE,0x03,0xFF,0xEF,
0xFC,0x07,0xFF,0xC7,0xFF,0xF8,0x00,0xFF,0xFF,0xE0,
0x01,0xFF,0xE7,0xFF,0xE0,0x00,0x7F,0xFF,0xC0,0x00,
0xFF,0xE7,0xFF,0xC0,0x00,0x3F,0xFF,0x80,0x00,0x7F,
0xE7,0xFF,0x80,0x00,0x1F,0xFF,0x00,0x00,0x3F,0xF7,
0xFF,0x00,0x00,0x1F,0xFE,0x00,0x00,0x3F,0xF7,0xFF,
0x00,0x00,0x1F,0xFE,0x00,0x00,0x1F,0xF9,0xFF,0xC0,
0x00,0x01,0xFF,0x80,0x00,0x03,0xFE,0xFF,0xC0,0x00,
0x01,0xFF,0x00,0x00,0x03,0xFF,0xBF,0xF0,0x00,0x00,
0x3F,0xE0,0x00,0x00,0x7F,0xF7,0xFE,0x00,0x00,0x07,
0xFC,0x00,0x00,0x0F,0xFE,0xFF,0xC0,0x00,0x00,0xFF,
0x80,0x00,0x01,0xFF,0xDF,0xF8,0x00,0x00,0x1F,0xF0,
0x00,0x00,0x3F,0xF9,0xFF,0x00,0x00,0x03,0xFE,0x00,
0x00,0x07,0xFC,0x0A,0x9A,0x9C,0x03,0x80,0x00,0x00,
0x7F,0xE0,0x00,0xFF,0x80,0x7F,0xFF,0x80,0x1F,0xF0,
0x3F,0xFF,0xFC,0x03,0xFE,0x1F,0xFF,0xFF,0xC0,0x7F,
0xC7,0xFF,0xFF,0xFC,0x0F,0xF9,0xFF,0xFF,0xFF,0xC1,
0xFF,0x7F,0xFF,0xFF,0xFC,0x3F,0xEF,0xFF,0xFF,0xFF,
0xC7,0xFF,0xFF,0x01,0xFF,0xF8,0xFF,0xFF,0x00,0x0F,
0xFF,0x9F,0xFF,0x80,0x00,0x7F,0xF3,0xFF,0xE0,0x00,
0x07,0xFE,0x7F,0xF8,0x00,0x00,0xFF,0xF1,0xFF,0xC0,
0x00,0x01,0xFF,0xBF,0xF0,0x00,0x00,0x3F,0xF9,0xFF,
0xC0,0x00,0x00,0x7F,0xF7,0xFE,0x00,0x00,0x01,0xFF,
0xDF,0xF8,0x00,0x00,0x07,0xFF,0x7F,0xE0,0x00,0x00,
0x1F,0xFD,0xFF,0x80,0x00,0x00,0x7F,0xF3,0xFE,0x00,
0x00,0x01,0xFF,0x0C,0x1B,0x13,0xFB,0x80,0x00,0x00,
0xFF,0xC0,0x00,0x00,0x00,0x07,0xFF,0xFE,0x00,0x00,
0x00,0x0F,0xFF,0xFF,0xC0,0x00,0x00,0x1F,0xFF,0xFF,
0xF8,0x00,0x00,0x3F,0xFF,0xFF,0xFE,0x00,0x00,0x3F,
0xFF,0xFF,0xFF,0xC0,0x00,0x3F,0xFF,0xFF,0xFF,0xF0,
0x00,0x3F,0xFF,0xFF,0xFF,0xFC,0x00,0x3F,0xFF,0x80,
0x7F,0xFF,0x00,0x1F,0xFE,0x00,0x0F,0xFF,0x80,0x1F,
0xFE,0x00,0x01,0xFF,0xE0,0x1F,0xFE,0x00,0x00,0x7F,
0xF8,0x0F,0xFC,0x00,0x00,0x1F,0xFC,0x0F,0xFE,0x00,
0x00,0x07,0xFF,0x07,0xFE,0x00,0x00,0x01,0xFF,0x83,
0xFE,0x00,0x00,0x00,0x7F,0xC3,0xFF,0x00,0x00,0x00,
0x3F,0xF4,0xBF,0xE0,0x00,0x00,0x01,0xFF,0x3F,0xF0,
0x00,0x00,0x00,0xFF,0xF7,0xFE,0x00,0x00,0x00,0x07,
0xFE,0xBF,0xE0,0x00,0x00,0x00,0x7F,0xDF,0xF0,0x00,
0x00,0x00,0x7F,0xEF,0xFC,0x00,0x00,0x00,0x3F,0xF8,
0x7F,0xC0,0x00,0x00,0x03,0xFE,0x3F,0xE0,0x00,0x00,
0x03,0xFF,0x1F,0xF8,0x00,0x00,0x01,0xFF,0x87,0xFC,
0x00,0x00,0x00,0xFF,0x83,0xFF,0x00,0x00,0x00,0xFF,
0xC1,0xFF,0xC0,0x00,0x00,0xFF,0xE0,0x7F,0xE0,0x00,
0x00,0xFF,0xE0,0x3F,0xF8,0x00,0x00,0xFF,0xF0,0x0F,
0xFF,0x00,0x00,0xFF,0xF0,0x03,0xFF,0xC0,0x00,0xFF,
0xF0,0x01,0xFF,0xFC,0x03,0xFF,0xF8,0x00,0x7F,0xFF,
0xFF,0xFF,0xF8,0x00,0x1F,0xFF,0xFF,0xFF,0xF8,0x00,
0x07,0xFF,0xFF,0xFF,0xF8,0x00,0x01,0xFF,0xFF,0xFF,
0xF8,0x00,0x00,0x3F,0xFF,0xFF,0xF0,0x00,0x00,0x07,
0xFF,0xFF,0xE0,0x00,0x00,0x00,0xFF,0xFF,0xC0,0x00,
0x00,0x00,0x07,0xFE,0x00,0x00,0x00,0x0B,0x64,0x9B,
0x63,0x80,0x00,0x00,0xFF,0x80,0x00,0x1F,0xF0,0x0F,
0xFF,0xC0,0x00,0x7F,0xC0,0xFF,0xFF,0xE0,0x01,0xFF,
0x07,0xFF,0xFF,0xC0,0x07,0xFC,0x7F,0xFF,0xFF,0x80,
0x1F,0xF1,0xFF,0xFF,0xFF,0x80,0x7F,0xCF,0xFF,0xFF,
0xFE,0x01,0xFF,0x7F,0xFF,0xFF,0xFC,0x07,0xFF,0xFF,
0x01,0xFF,0xF8,0x1F,0xFF,0xF0,0x01,0xFF,0xF0,0x7F,
0xFF,0x80,0x01,0xFF,0xC1,0xFF,0xFC,0x00,0x03,0xFF,
0x87,0xFF,0xE0,0x00,0x07,0xFE,0x1F,0xFF,0x00,0x00,
0x0F,0xFC,0x7F,0xF8,0x00,0x00,0x3F,0xF1,0xFF,0xC0,
0x00,0x00,0x7F,0xC7,0xFF,0x00,0x00,0x01,0xFF,0x9F,
0xFC,0x00,0x00,0x03,0xFE,0x8F,0xFC,0x00,0x00,0x01,
0xFF,0x3F,0xF0,0x00,0x00,0x07,0xFF,0xBF,0xF0,0x00,
0x00,0x01,0xFF,0xBF,0xF8,0x00,0x00,0x00,0xFF,0xBF,
0xE0,0x00,0x00,0x07,0xFD,0x3F,0xF8,0x00,0x00,0x03,
0xFE,0x8F,0xFE,0x00,0x00,0x03,0xFE,0x3F,0xF8,0x00,
0x00,0x1F,0xF8,0xFF,0xF0,0x00,0x00,0x7F,0xC3,0xFF,
0xE0,0x00,0x03,0xFF,0x0F,0xFF,0xC0,0x00,0x1F,0xF8,
0x3F,0xFF,0x80,0x00,0xFF,0xE0,0xFF,0xFF,0x00,0x0F,
0xFF,0x03,0xFF,0xFF,0x80,0xFF,0xF8,0x0F,0xFF,0xFF,
0xFF,0xFF,0xE0,0x3F,0xEF,0xFF,0xFF,0xFF,0x00,0xFF,
0xBF,0xFF,0xFF,0xF8,0x03,0xFE,0x7F,0xFF,0xFF,0xC0,
0x0F,0xF8,0x7F,0xFF,0xFC,0x00,0x3F,0xE0,0xFF,0xFF,
0xC0,0x00,0xFF,0x80,0xFF,0xFC,0x00,0x03,0xFE,0x00,
0xFF,0x80,0x00,0x1B,0xFF,0x00,0x00,0x00,0x00,0x0D,
0xFF,0x80,0x00,0x00,0x00,0x05,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x0B,0x64,0x8F,0x63,0x70,0x00,0x03,0xFC,
0x00,0x00,0x00,0x00,0x7F,0xFE,0x01,0xFF,0x00,0x0F,
0xFF,0xFE,0x07,0xFC,0x00,0x7F,0xFF,0xFC,0x1F,0xF0,
0x07,0xFF,0xFF,0xF8,0x7F,0xC0,0x3F,0xFF,0xFF,0xF1,
0xFF,0x01,0xFF,0xFF,0xFF,0xE7,0xFC,0x07,0xFF,0xFF,
0xFF,0xDF,0xF0,0x3F,0xFF,0x03,0xFF,0xFF,0xC1,0xFF,
0xE0,0x01,0xFF,0xFF,0x07,0xFF,0x00,0x03,0xFF,0xFC,
0x3F,0xF8,0x00,0x07,0xFF,0xF0,0xFF,0xC0,0x00,0x0F,
0xFF,0xC7,0xFE,0x00,0x00,0x1F,0xFF,0x1F,0xF8,0x00,
0x00,0x3F,0xFC,0x7F,0xC0,0x00,0x00,0x7F,0xF3,0xFF,
0x00,0x00,0x01,0xFF,0xCF,0xF8,0x00,0x00,0x07,0xFF,
0x87,0xFC,0x00,0x00,0x01,0xFF,0xBF,0xF0,0x00,0x00,
0x07,0xFE,0xFF,0x80,0x00,0x00,0x1F,0xFE,0xFF,0xC0,
0x00,0x00,0x07,0xFE,0xBF,0xE0,0x00,0x00,0x03,0xFE,
0x7F,0xC0,0x00,0x00,0x0F,0xFC,0xBF,0xE0,0x00,0x00,
0x0F,0xFC,0xFF,0xC0,0x00,0x00,0x7F,0xF1,0xFF,0x00,
0x00,0x01,0xFF,0xC7,0xFE,0x00,0x00,0x0F,0xFF,0x0F,
0xF8,0x00,0x00,0x3F,0xFC,0x3F,0xF0,0x00,0x01,0xFF,
0xF0,0x7F,0xE0,0x00,0x0F,0xFF,0xC1,0xFF,0xC0,0x00,
0x7F,0xFF,0x03,0xFF,0xC0,0x07,0xFF,0xFC,0x07,0xFF,
0xC0,0x7F,0xFF,0xF0,0x1F,0xFF,0xFF,0xFF,0xFF,0xC0,
0x3F,0xFF,0xFF,0xFD,0xFF,0x00,0x7F,0xFF,0xFF,0xF7,
0xFC,0x00,0x7F,0xFF,0xFF,0x9F,0xF0,0x00,0xFF,0xFF,
0xF8,0x7F,0xC0,0x00,0xFF,0xFF,0xC1,0xFF,0x00,0x00,
0xFF,0xFC,0x07,0xFC,0x00,0x00,0x7F,0x80,0x1F,0xFD,
0x00,0x00,0x00,0x00,0x0F,0xFE,0x80,0x00,0x00,0x00,
0x07,0xFE,0xC0,0x00,0x00,0x00,0x03,0xFE,0x06,0xDA,
0x9C,0x02,0x10,0x00,0x0F,0xE0,0x7F,0x83,0xFF,0xC7,
0xF8,0x7F,0xFF,0x7F,0x8F,0xFF,0xF8,0xFF,0x3F,0xFF,
0xCF,0xF7,0xFF,0xFC,0xFF,0xFF,0xFF,0x8F,0xFF,0xF0,
0x78,0xFF,0xFC,0x01,0x0F,0xFF,0x80,0x00,0xFF,0xF0,
0x00,0x11,0xFF,0xC0,0x00,0x2F,0xFF,0x00,0x00,0x6F,
0xFC,0x00,0x00,0xDF,0xF8,0x00,0x01,0xBF,0xF0,0x00,
0x03,0x7F,0xE0,0x00,0x06,0x7F,0xC0,0x00,0x00,0x0A,
0xDB,0x0F,0xFB,0x20,0x00,0x0F,0xFE,0x00,0x00,0x00,
0x0F,0xFF,0xFC,0x00,0x00,0x03,0xFF,0xFF,0xF8,0x00,
0x00,0xFF,0xFF,0xFF,0xE0,0x00,0x1F,0xFF,0xFF,0xFF,
0x00,0x03,0xFF,0xFF,0xFF,0xF8,0x00,0x7F,0xFF,0xFF,
0xFF,0xC0,0x0F,0xFF,0xFF,0xFF,0xFC,0x00,0xFF,0xF8,
0x03,0xFF,0xE0,0x1F,0xFC,0x00,0x0F,0xFE,0x01,0xFF,
0x80,0x00,0x7F,0xF0,0x3F,0xF0,0x00,0x03,0xFF,0x03,
0xFE,0x00,0x00,0x1F,0xF0,0x3F,0xE0,0x00,0x01,0xFF,
0x83,0xFE,0x00,0x00,0x0F,0xF8,0x3F,0xE0,0x00,0x00,
0xF8,0x03,0xFF,0x00,0x00,0x00,0x00,0x3F,0xF8,0x00,
0x00,0x00,0x03,0xFF,0xC0,0x00,0x00,0x00,0x1F,0xFF,
0x00,0x00,0x00,0x01,0xFF,0xFF,0x00,0x00,0x00,0x0F,
0xFF,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFE,0x00,0x00,
0x07,0xFF,0xFF,0xFC,0x00,0x00,0x3F,0xFF,0xFF,0xF8,
0x00,0x01,0xFF,0xFF,0xFF,0xF0,0x00,0x07,0xFF,0xFF,
0xFF,0xC0,0x00,0x1F,0xFF,0xFF,0xFE,0x00,0x00,0x7F,
0xFF,0xFF,0xF0,0x00,0x00,0xFF,0xFF,0xFF,0x80,0x00,
0x00,0xFF,0xFF,0xFC,0x00,0x00,0x01,0xFF,0xFF,0xE0,
0x00,0x00,0x01,0xFF,0xFE,0x00,0x00,0x00,0x03,0xFF,
0xE0,0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,0x00,
0x3F,0xF0,0x7C,0x00,0x00,0x03,0xFF,0x7F,0xC0,0x00,
0x00,0x1F,0xF7,0xFE,0x00,0x00,0x01,0xFF,0x87,0xFC,
0x00,0x00,0x03,0xFE,0x7F,0xE0,0x00,0x00,0x7F,0xC3,
0xFF,0x00,0x00,0x0F,0xFC,0x3F,0xF8,0x00,0x01,0xFF,
0xC3,0xFF,0xE0,0x00,0x3F,0xF8,0x1F,0xFF,0xC0,0x1F,
0xFF,0x80,0xFF,0xFF,0xFF,0xFF,0xF0,0x0F,0xFF,0xFF,
0xFF,0xFE,0x00,0x7F,0xFF,0xFF,0xFF,0xC0,0x03,0xFF,
0xFF,0xFF,0xF8,0x00,0x0F,0xFF,0xFF,0xFF,0x00,0x00,
0x7F,0xFF,0xFF,0xC0,0x00,0x00,0xFF,0xFF,0xE0,0x00,
0x00,0x00,0xFF,0xF0,0x00,0x00,0x06,0xA3,0x87,0xF9,
0xC0,0x00,0x08,0x00,0x00,0x07,0x00,0x00,0x01,0xE0,
0x00,0x00,0xFC,0x00,0x00,0x7F,0x80,0x1A,0x03,0xFE,
0x00,0x60,0x0F,0xF8,0x01,0xBF,0xFF,0xFF,0xF3,0xFF,
0xFF,0xFE,0xD0,0x1F,0xF0,0x03,0x40,0x7F,0xC0,0x0D,
0x01,0xFF,0x00,0x34,0x07,0xFC,0x00,0xD0,0x1F,0xF0,
0x00,0x03,0xFF,0x00,0x00,0x7F,0xF0,0x00,0x0F,0xFF,
0xFD,0x00,0x1F,0xFF,0xF4,0x00,0x3F,0xFF,0xE0,0x03,
0xFF,0xFC,0x00,0x1F,0xFF,0x80,0x00,0x7F,0xE0,0x0A,
0x9A,0x9F,0xFB,0x8D,0xFF,0x80,0x00,0x00,0x7F,0xF7,
0xFE,0x00,0x00,0x01,0xFF,0xDF,0xF8,0x00,0x00,0x07,
0xFF,0x7F,0xE0,0x00,0x00,0x1F,0xFC,0xFF,0x80,0x00,
0x00,0x7F,0xEB,0xFE,0x00,0x00,0x03,0xFF,0x8F,0xFC,
0x00,0x00,0x1F,0xFC,0xFF,0xC0,0x00,0x07,0xFF,0x9F,
0xF8,0x00,0x01,0xFF,0xF3,0xFF,0x80,0x00,0x7F,0xFE,
0x7F,0xFC,0x00,0x3F,0xFF,0xC7,0xFF,0xE0,0x3F,0xFF,
0xF8,0xFF,0xFF,0xFF,0xFD,0xFF,0x0F,0xFF,0xFF,0xFF,
0x3F,0xE0,0xFF,0xFF,0xFF,0xC7,0xFC,0x0F,0xFF,0xFF,
0xF0,0xFF,0x80,0xFF,0xFF,0xFC,0x1F,0xF0,0x0F,0xFF,
0xFE,0x03,0xFE,0x00,0x7F,0xFF,0x80,0x7F,0xC0,0x00,
0xFF,0x80,0x00,0x00,0x0B,0xDA,0x04,0x03,0x17,0xFE,
0x00,0x00,0x00,0x3F,0xF3,0xFE,0x00,0x00,0x00,0x3F,
0xF3,0xFE,0x00,0x00,0x00,0x3F,0xE3,0xFF,0x00,0x00,
0x00,0x7F,0xE8,0x3F,0xE0,0x00,0x00,0x0F,0xF8,0x3F,
0xF0,0x00,0x00,0x1F,0xF9,0x03,0xFE,0x00,0x00,0x03,
0xFE,0x03,0xFF,0x00,0x00,0x07,0xFE,0x20,0x3F,0xE0,
0x00,0x00,0xFF,0x80,0x1F,0xF0,0x00,0x01,0xFF,0x80,
0x1F,0xF0,0x00,0x01,0xFF,0x00,0x1F,0xF8,0x00,0x01,
0xFF,0x00,0x0F,0xF8,0x00,0x03,0xFF,0x00,0x0F,0xF8,
0x00,0x03,0xFE,0x00,0x0F,0xFC,0x00,0x03,0xFE,0x00,
0x07,0xFC,0x00,0x07,0xFE,0x00,0x07,0xFC,0x00,0x07,
0xFC,0x00,0x07,0xFE,0x00,0x07,0xFC,0x00,0x03,0xFE,
0x00,0x0F,0xFC,0x00,0x03,0xFE,0x00,0x0F,0xF8,0x04,
0x00,0x3F,0xE0,0x03,0xFF,0x00,0x00,0x3F,0xE0,0x03,
0xFE,0x00,0x80,0x03,0xFE,0x00,0xFF,0xC0,0x00,0x03,
0xFE,0x00,0xFF,0x80,0x10,0x00,0x3F,0xE0,0x3F,0xF0,
0x00,0x00,0x3F,0xE0,0x3F,0xE0,0x02,0x00,0x03,0xFE,
0x0F,0xFC,0x00,0x00,0x01,0xFE,0x0F,0xF8,0x00,0x40,
0x00,0x3F,0xE3,0xFF,0x00,0x00,0x00,0x1F,0xE3,0xFE,
0x00,0x08,0x00,0x03,0xFE,0xFF,0xC0,0x01,0x00,0x00,
0x3F,0xDF,0xF0,0x00,0x00,0x00,0x3F,0xFF,0xF0,0x00,
0x20,0x00,0x03,0xFF,0xFC,0x00,0x00,0x00,0x01,0xFF,
0xFC,0x00,0x04,0x00,0x00,0x3F,0xFF,0x00,0x00,0x00,
0x00,0x1F,0xFF,0x00,0x00,0x80,0x00,0x03,0xFF,0xC0,
0x00,0x00,0x00,0x01,0xFF,0xC0,0x00,0x00,0x11,0xDA,
0x00,0x04,0x78,0xFF,0x80,0x00,0x01,0xFF,0x00,0x00,
0x03,0xFE,0xFF,0xC0,0x00,0x01,0xFF,0x80,0x00,0x07,
0xFF,0x0F,0xF8,0x00,0x00,0x7F,0xF0,0x00,0x00,0xFF,
0x8F,0xF8,0x00,0x00,0x7F,0xF0,0x00,0x01,0xFF,0x8F,
0xFC,0x00,0x00,0xFF,0xF8,0x00,0x01,0xFF,0xA0,0xFF,
0x80,0x00,0x1F,0xFF,0x00,0x00,0x3F,0xE0,0xFF,0xC0,
0x00,0x1F,0xFF,0x80,0x00,0x7F,0xE4,0x0F,0xF8,0x00,
0x07,0xFF,0xF0,0x00,0x0F,0xF8,0x0F,0xFC,0x00,0x07,
0xF7,0xF0,0x00,0x1F,0xF8,0x07,0xFC,0x00,0x07,0xF7,
0xF8,0x00,0x1F,0xF0,0x80,0xFF,0x80,0x01,0xFE,0xFF,
0x00,0x03,0xFE,0x00,0xFF,0xC0,0x01,0xFC,0x7F,0x00,
0x07,0xFE,0x10,0x0F,0xF8,0x00,0x7F,0x8F,0xF0,0x00,
0xFF,0x80,0x0F,0xFC,0x00,0x7F,0x8F,0xF0,0x01,0xFF,
0x80,0x07,0xFC,0x00,0x7F,0x07,0xF0,0x01,0xFF,0x00,
0x07,0xFC,0x00,0xFF,0x07,0xF8,0x01,0xFF,0x00,0x07,
0xFC,0x00,0xFF,0x07,0xF8,0x03,0xFF,0x00,0x03,0xFE,
0x00,0xFF,0x07,0xF8,0x03,0xFE,0x00,0x03,0xFE,0x00,
0xFE,0x03,0xFC,0x03,0xFE,0x00,0x03,0xFE,0x01,0xFE,
0x03,0xFC,0x03,0xFE,0x00,0x03,0xFF,0x01,0xFE,0x03,
0xFC,0x07,0xFE,0x00,0x01,0xFF,0x01,0xFC,0x03,0xFC,
0x07,0xFC,0x00,0x01,0xFF,0x03,0xFC,0x01,0xFE,0x07,
0xFC,0x00,0x01,0xFF,0x03,0xFC,0x01,0xFE,0x0F,0xFC,
0x00,0x00,0xFF,0x83,0xFC,0x01,0xFE,0x0F,0xF8,0x00,
0x00,0xFF,0x83,0xF8,0x01,0xFE,0x0F,0xF8,0x00,0x00,
0xFF,0x87,0xF8,0x00,0xFF,0x0F,0xF8,0x00,0x00,0x7F,
0x87,0xF8,0x00,0xFF,0x1F,0xF0,0x00,0x00,0x7F,0xC7,
0xF8,0x00,0xFF,0x1F,0xF0,0x00,0x00,0x7F,0xC7,0xF0,
0x00,0xFF,0x1F,0xF0,0x00,0x00,0x7F,0xCF,0xF0,0x00,
0x7F,0xBF,0xF0,0x00,0x00,0x3F,0xCF,0xF0,0x00,0x7F,
0xBF,0xE0,0x00,0x00,0x3F,0xEF,0xF0,0x00,0x7F,0xBF,
0xE0,0x00,0x00,0x3F,0xEF,0xE0,0x00,0x3F,0xBF,0xE0,
0x02,0x40,0x03,0xFF,0xFC,0x00,0x07,0xFF,0xF8,0x00,
0x48,0x00,0x3F,0xFF,0x00,0x00,0x7F,0xFE,0x00,0x00,
0x00,0x3F,0xFF,0x00,0x00,0x7F,0xFC,0x00,0x09,0x00,
0x03,0xFF,0xC0,0x00,0x07,0xFF,0x80,0x00,0x00,0x01,
0xFF,0xC0,0x00,0x07,0xFF,0x00,0x00,0x00,0x01,0xFF,
0x80,0x00,0x03,0xFF,0x00,0x00,0x0B,0xDA,0x04,0x03,
0x13,0xFF,0x80,0x00,0x00,0x3F,0xF1,0xFF,0xC0,0x00,
0x00,0x7F,0xF0,0xFF,0xE0,0x00,0x00,0xFF,0xE0,0xFF,
0xE0,0x00,0x01,0xFF,0xC0,0x7F,0xF0,0x00,0x01,0xFF,
0xC0,0x3F,0xF8,0x00,0x03,0xFF,0x80,0x3F,0xF8,0x00,
0x07,0xFF,0x00,0x1F,0xFC,0x00,0x07,0xFF,0x00,0x0F,
0xFE,0x00,0x0F,0xFE,0x00,0x0F,0xFE,0x00,0x1F,0xFC,
0x00,0x07,0xFF,0x00,0x1F,0xF8,0x00,0x03,0xFF,0x80,
0x3F,0xF8,0x00,0x03,0xFF,0x80,0x7F,0xF0,0x00,0x01,
0xFF,0xC0,0xFF,0xE0,0x00,0x00,0xFF,0xE0,0xFF,0xE0,
0x00,0x00,0xFF,0xE1,0xFF,0xC0,0x00,0x00,0x7F,0xF3,
0xFF,0x80,0x00,0x00,0x3F,0xFB,0xFF,0x00,0x00,0x00,
0x1F,0xFF,0xFF,0x00,0x00,0x00,0x1F,0xFF,0xFE,0x00,
0x00,0x00,0x0F,0xFF,0xFC,0x00,0x00,0x00,0x07,0xFF,
0xFC,0x00,0x00,0x00,0x07,0xFF,0xF8,0x00,0x00,0x00,
0x03,0xFF,0xF0,0x00,0x09,0x00,0x00,0x3F,0xFC,0x00,
0x00,0x00,0x00,0x7F,0xFC,0x00,0x00,0x00,0x00,0x7F,
0xFE,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,
0x01,0xFF,0xFF,0x00,0x00,0x00,0x01,0xFF,0xFF,0x80,
0x00,0x00,0x03,0xFF,0xFF,0xC0,0x00,0x00,0x07,0xFF,
0xFF,0xC0,0x00,0x00,0x0F,0xFE,0xFF,0xE0,0x00,0x00,
0x0F,0xFE,0x7F,0xF0,0x00,0x00,0x1F,0xFC,0x3F,0xF8,
0x00,0x00,0x3F,0xF8,0x3F,0xF8,0x00,0x00,0x3F,0xF0,
0x1F,0xFC,0x00,0x00,0x7F,0xF0,0x0F,0xFE,0x00,0x00,
0xFF,0xE0,0x0F,0xFE,0x00,0x01,0xFF,0xC0,0x07,0xFF,
0x00,0x01,0xFF,0xC0,0x03,0xFF,0x80,0x03,0xFF,0x80,
0x03,0xFF,0x80,0x07,0xFF,0x00,0x01,0xFF,0xC0,0x07,
0xFE,0x00,0x00,0xFF,0xE0,0x0F,0xFE,0x00,0x00,0xFF,
0xE0,0x1F,0xFC,0x00,0x00,0x7F,0xF1,0x07,0xFF,0x00,
0x00,0x07,0xFF,0x0F,0xFE,0x00,0x00,0x03,0xFF,0x9F,
0xFC,0x00,0x00,0x01,0xFF,0xC0,0x0B,0xE4,0x87,0x5B,
0x17,0xFE,0x00,0x00,0x00,0x1F,0xF8,0x7F,0xC0,0x00,
0x00,0x07,0xFE,0x7F,0xE0,0x00,0x00,0x07,0xFD,0x07,
0xFC,0x00,0x00,0x01,0xFF,0x87,0xFE,0x00,0x00,0x01,
0xFF,0x03,0xFE,0x00,0x00,0x03,0xFF,0x20,0x7F,0xE0,
0x00,0x00,0x7F,0xC0,0x3F,0xE0,0x00,0x00,0xFF,0xC0,
0x3F,0xF0,0x00,0x00,0xFF,0x84,0x03,0xFE,0x00,0x00,
0x3F,0xF0,0x03,0xFF,0x00,0x00,0x3F,0xE0,0x80,0x3F,
0xE0,0x00,0x0F,0xFC,0x00,0x3F,0xF0,0x00,0x0F,0xF8,
0x00,0x1F,0xF0,0x00,0x1F,0xF8,0x00,0x1F,0xF0,0x00,
0x1F,0xF0,0x00,0x1F,0xF8,0x00,0x1F,0xF0,0x00,0x0F,
0xF8,0x00,0x3F,0xF0,0x00,0x0F,0xF8,0x00,0x3F,0xE0,
0x10,0x00,0xFF,0x80,0x0F,0xFC,0x00,0x00,0xFF,0x80,
0x0F,0xF8,0x00,0x00,0x7F,0xC0,0x1F,0xF8,0x00,0x00,
0x7F,0xC0,0x1F,0xF0,0x00,0x00,0x7F,0xE0,0x1F,0xF0,
0x00,0x00,0x3F,0xE0,0x3F,0xF0,0x00,0x00,0x3F,0xE0,
0x3F,0xE0,0x00,0x00,0x3F,0xF0,0x7F,0xE0,0x00,0x00,
0x1F,0xF0,0x7F,0xE0,0x00,0x00,0x1F,0xF0,0x7F,0xC0,
0x02,0x00,0x01,0xFF,0x1F,0xF8,0x00,0x00,0x01,0xFF,
0x1F,0xF0,0x00,0x00,0x00,0xFF,0x3F,0xF0,0x00,0x40,
0x00,0x1F,0xF7,0xFC,0x00,0x00,0x00,0x0F,0xFF,0xFC,
0x00,0x08,0x00,0x01,0xFF,0xFF,0x00,0x00,0x00,0x00,
0xFF,0xFF,0x00,0x01,0x00,0x00,0x1F,0xFF,0xC0,0x00,
0x00,0x00,0x0F,0xFF,0xC0,0x00,0x00,0x00,0x0F,0xFF,
0x80,0x00,0x00,0x00,0x07,0xFF,0x80,0x00,0x20,0x00,
0x00,0xFF,0xE0,0x00,0x00,0x00,0x00,0x7F,0xE0,0x00,
0x04,0x00,0x00,0x0F,0xF8,0x00,0x00,0x00,0x00,0x1F,
0xF8,0x00,0x00,0x80,0x00,0x03,0xFE,0x00,0x00,0x00,
0x00,0x07,0xFE,0x00,0x00,0x10,0x00,0x00,0xFF,0x80,
0x00,0x02,0x00,0x00,0x3F,0xE0,0x00,0x00,0x00,0x00,
0x7F,0xE0,0x00,0x00,0x00,0x00,0xFF,0xC0,0x00,0x00,
0x01,0x03,0xFF,0xC0,0x00,0x00,0x01,0xFF,0xFF,0x80,
0x00,0x00,0x40,0x3F,0xFF,0xE0,0x00,0x00,0x00,0x1F,
0xFF,0xC0,0x00,0x00,0x00,0x1F,0xFF,0x80,0x00,0x00,
0x00,0x1F,0xFF,0x00,0x00,0x00,0x00,0x1F,0xFE,0x00,
0x00,0x00,0x00,0x07,0xF0,0x00,0x00,0x00,0x00,0x0B,
0x5A,0x08,0x03,0x1D,0x1F,0xFF,0xFF,0xFF,0xFF,0xF0,
0x7F,0xFF,0xFF,0xE7,0xFF,0x80,0x00,0x00,0x00,0x3F,
0xFC,0x00,0x00,0x00,0x01,0xFF,0xE0,0x00,0x00,0x00,
0x07,0xFF,0x00,0x00,0x00,0x00,0x3F,0xF8,0x00,0x00,
0x00,0x01,0xFF,0xC0,0x00,0x00,0x00,0x0F,0xFF,0x00,
0x00,0x00,0x00,0x7F,0xF8,0x00,0x00,0x00,0x03,0xFF,
0xC0,0x00,0x00,0x00,0x0F,0xFE,0x00,0x00,0x00,0x00,
0x7F,0xF0,0x00,0x00,0x00,0x03,0xFF,0x80,0x00,0x00,
0x00,0x1F,0xFE,0x00,0x00,0x00,0x00,0xFF,0xF0,0x00,
0x00,0x00,0x07,0xFF,0x80,0x00,0x00,0x00,0x1F,0xFC,
0x00,0x00,0x00,0x00,0xFF,0xE0,0x00,0x00,0x00,0x07,
0xFF,0x00,0x00,0x00,0x00,0x3F,0xFC,0x00,0x00,0x00,
0x01,0xFF,0xE0,0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,
0x00,0x00,0x7F,0xF8,0x00,0x00,0x00,0x01,0xFF,0xC0,
0x00,0x00,0x00,0x0F,0xFE,0x00,0x00,0x00,0x00,0x7F,
0xF0,0x00,0x00,0x00,0x03,0xFF,0xC0,0x00,0x00,0x00,
0x1F,0xFE,0x00,0x00,0x00,0x00,0xFF,0xF0,0x00,0x00,
0x00,0x03,0xFF,0x80,0x00,0x00,0x00,0x1F,0xFC,0x00,
0x00,0x00,0x00,0xFF,0xE0,0x00,0x00,0x00,0x07,0xFF,
0x80,0x00,0x00,0x00,0x3F,0xFC,0x00,0x00,0x00,0x01,
0xFF,0xE0,0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,
0x00,0x3F,0xF8,0x00,0x00,0x00,0x01,0xFF,0xC0,0x00,
0x00,0x00,0x0F,0xFE,0x3F,0xFF,0xFF,0xFF,0xEF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC0,0x07,0x6F,0x0B,0x5A,0x10,
0x00,0x00,0x7F,0xC0,0x00,0x0F,0xFF,0x00,0x00,0xFF,
0xFC,0x00,0x07,0xFF,0xF0,0x00,0x3F,0xFF,0xE0,0x00,
0x3F,0xFF,0xF0,0x00,0x3F,0xFF,0xF0,0x00,0xFF,0xF0,
0x00,0x07,0xFF,0x00,0x80,0x03,0xFF,0x00,0x68,0x01,
0xFF,0x00,0x34,0x00,0xFF,0x80,0x1A,0x00,0x7F,0xC0,
0x0A,0x00,0x7F,0xC0,0x00,0x03,0xFE,0x00,0x00,0x1F,
0xF8,0x00,0x00,0x7F,0xC0,0x00,0x07,0xFF,0x00,0x00,
0x7F,0xF8,0x00,0x0F,0xFF,0xC0,0x00,0x3F,0xFE,0x00,
0x00,0xFF,0xE0,0x00,0x04,0x7F,0xC0,0x00,0x01,0xFF,
0xC0,0x00,0x07,0xFF,0xC0,0x00,0x1F,0xFF,0x80,0x00,
0x0F,0xFF,0x00,0x00,0x0F,0xFE,0x00,0x00,0x0F,0xF8,
0x00,0x00,0x3F,0xF0,0x00,0x00,0x7F,0xC0,0x02,0x80,
0x1F,0xF0,0x00,0x00,0x3F,0xC0,0x06,0x80,0x1F,0xF0,
0x03,0x40,0x0F,0xF8,0x01,0x80,0x07,0xFC,0x00,0x00,
0x1F,0xF8,0x00,0x00,0x3F,0xE0,0x00,0x00,0xFF,0xC0,
0x00,0x03,0xFF,0xC0,0x00,0x0F,0xFF,0xFE,0x00,0x03,
0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x01,0xFF,0xFC,
0x00,0x01,0xFF,0xF0,0x00,0x03,0xFF,0xC0,0x00,0x01,
0xFF,0x02,0x2F,0x27,0x51,0xAD,0xFF,0xDF,0xFD,0xFF,
0xDF,0xFD,0xFF,0xDF,0xFD,0xFF,0xDF,0xFD,0xFF,0xDF,
0xFD,0xFF,0xDF,0xFD,0xFF,0x9F,0xF0,0x07,0x6F,0x0B,
0x5A,0x17,0xFC,0x00,0x00,0x1F,0xFE,0x00,0x00,0x7F,
0xFC,0x00,0x01,0xFF,0xFC,0x00,0x08,0xFF,0xFF,0x00,
0x04,0x7F,0xFF,0xC0,0x01,0xFF,0xFF,0x80,0x00,0x1F,
0xFE,0x00,0x00,0x1F,0xF8,0x00,0x00,0x3F,0xE0,0x03,
0x40,0x0F,0xF8,0x01,0xA0,0x07,0xFC,0x00,0xD0,0x03,
0xFE,0x00,0x00,0x0F,0xF8,0x01,0x40,0x03,0xFE,0x00,
0x80,0x00,0xFF,0x80,0x00,0x01,0xFF,0x00,0x00,0x07,
0xFF,0x00,0x00,0x0F,0xFF,0x00,0x00,0x1F,0xFF,0x80,
0x00,0x3F,0xFE,0x00,0x00,0x3F,0xFC,0x00,0x00,0x07,
0xFC,0x00,0x00,0x7F,0xF0,0x00,0x07,0xFF,0xC0,0x00,
0x3F,0xFF,0x00,0x01,0xFF,0xE0,0x00,0x0F,0xFE,0x08,
0x00,0x0F,0xFC,0x00,0x00,0x7F,0xE0,0x10,0x00,0x3F,
0xE0,0x08,0x00,0x3F,0xF0,0x06,0x80,0x1F,0xF0,0x03,
0x40,0x0F,0xF8,0x01,0xA0,0x07,0xFC,0x00,0x80,0x07,
0xFE,0x00,0x00,0x3F,0xF8,0x00,0x03,0xFF,0xC0,0x04,
0x7F,0xFF,0xE0,0x02,0x3F,0xFF,0xE0,0x00,0xFF,0xFF,
0x00,0x03,0xFF,0xF8,0x00,0x0F,0xFF,0xC0,0x00,0x3F,
0xFC,0x00,0x00,0xFF,0x80,0x00,0x00,0x0C,0x89,0x10,
0xCB,0xA0,0x01,0xFE,0x00,0x00,0x00,0x00,0x01,0xFF,
0xF8,0x00,0x00,0x00,0x40,0xFF,0xFF,0xC0,0x00,0x00,
0x18,0x3F,0xFF,0xFF,0x00,0x00,0x07,0x0F,0xFF,0xFF,
0xF8,0x00,0x01,0xE3,0xFF,0xFF,0xFF,0xC0,0x00,0xFC,
0xFF,0xFF,0xFF,0xFE,0x00,0x3F,0xBF,0xFF,0xFF,0xFF,
0xF0,0x3F,0xF8,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,
0xF0,0x1F,0xFF,0xFF,0xFF,0xFB,0xF8,0x00,0x7F,0xFF,
0xFF,0xFE,0x7E,0x00,0x03,0xFF,0xFF,0xFF,0x8F,0x00,
0x00,0x1F,0xFF,0xFF,0xE1,0xC0,0x00,0x00,0xFF,0xFF,
0xF8,0x30,0x00,0x00,0x07,0xFF,0xFE,0x04,0x00,0x00,
0x00,0x3F,0xFF,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,
0x00,};
/* font data size: 23001 bytes */

static const unsigned char font_tgx_Arial_72_index[] = {
0x00,0x00,0x00,0x14,0x00,0xE8,0x03,0xC0,0x28,
0xE0,0xB9,0xC2,0xB9,0x07,0x85,0x0F,0x26,0x21,0x00,
0x47,0x30,0x95,0x11,0x31,0x42,0x67,0x84,0xD5,0x09,
0xB2,0x14,0xC0,0x2D,0x20,0x5E,0x00,0xD3,0x01,0xD5,
0xE3,0xF1,0x48,0x73,0x92,0x5E,0x26,0x78,0x52,0x74,
0xB0,0x81,0x62,0x42,0xC8,0x85,0xD7,0x4B,0xC4,0x18,
0xA1,0x33,0x92,0x77,0xF0,0xFB,0xC2,0x0F,0x34,0x52,
0x89,0x02,0xD2,0x3A,0x24,0xCD,0x4D,0x0C,0x9B,0x95,
0x37,0xEA,0x78,0x75,0x34,0x2A,0x7B,0xD5,0xCB,0x2D,
0x0E,0x5D,0xAC,0xBF,0x91,0x8D,0xAB,0x39,0xC6,0xB0,
0x4D,0x78,0xDB,0x56,0x38,0xA9,0x76,0xDC,0xF6,0x19,
0xF7,0xB4,0x0A,0xF8,0x1B,0xD0,0x63,0x20,0xDD,0xC2,
0x38,0x84,0x8B,0x09,0x9E,0x1C,0xFC,0x49,0xE8,0xB2,
0x11,0xA2,0x63,0xCB,0x47,0xF3,0x92,0x9B,0x27,0x5E,
0x4F,0x7C,0xA3,0x59,0x6B,0xF2,0xDD,0xA6,0x21,0xCC,
0xBB,0x9B,0x87,0x3B,0x0A,0x7E,0x65,0x01,0x3A,0x27,
0x94,0x63,0xE9,0x01,0x52,0xF6,0xA8,0xCD,0x56,0x4A,
0xB7,0x9D,0x7D,0xFB,0x13,0x36,0x2C,0xEC,0xB3,0x80,
};
/* font index size: 179 bytes */

const ILI9341_t3_font_t font_tgx_Arial_72 = {
	font_tgx_Arial_72_index,
	0,
	font_tgx_Arial_72_data,
	1,
	0,
	32,
	126,
	0,
	0,
	15,
	7,
	7,
	5,
	7,
	7,
	111,
	72
};



static const unsigned char font_tgx_Arial_96_data[] = {
0x00,0x00,0x00,0x00,0x94,0x03,0x2F,0xAC,0x00,0x8B,
0x7F,0xFF,0x7F,0xFF,0x7F,0xFF,0x7F,0xFE,0x3F,0xFF,
0x5F,0xFB,0x5F,0xFA,0x5F,0xFB,0x4F,0xF3,0x4F,0xF2,
0x4F,0xF0,0x3F,0x9A,0x3F,0x01,0xF8,0xD0,0x00,0x90,
0x00,0xDF,0xFF,0xBF,0xFF,0x09,0x11,0x18,0xF4,0xBF,
0x7F,0xFC,0x00,0x3F,0xFF,0x7F,0xFC,0x00,0x3F,0xFE,
0xFF,0xFC,0x00,0x3F,0xFF,0x1F,0xF8,0x00,0x1F,0xF8,
0x7F,0xC0,0x00,0x7F,0xD6,0x7F,0x80,0x00,0x7F,0x81,
0xFC,0x00,0x03,0xFC,0x0F,0xE0,0x00,0x0F,0xC0,0x7E,
0x00,0x00,0x7E,0x00,0x12,0x6F,0x80,0x01,0x28,0x00,
0x00,0x00,0x7F,0xF8,0x00,0x03,0xFF,0xC0,0x00,0x00,
0x00,0x1F,0xFE,0x00,0x01,0xFF,0xF0,0x00,0x00,0x00,
0x0F,0xFF,0x80,0x00,0x7F,0xF8,0x09,0x00,0x00,0x00,
0x7F,0xF8,0x00,0x03,0xFF,0xC0,0x00,0x00,0x00,0x1F,
0xFE,0x00,0x01,0xFF,0xF0,0x00,0x00,0x00,0x0F,0xFF,
0x80,0x00,0x7F,0xF8,0x04,0x80,0x00,0x00,0x7F,0xF8,
0x00,0x03,0xFF,0xC0,0x00,0x00,0x00,0x1F,0xFE,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x0F,0xFF,0x80,0x00,
0x7F,0xF8,0x02,0x40,0x00,0x00,0x7F,0xF8,0x00,0x03,
0xFF,0xC0,0x00,0x00,0x00,0x1F,0xFE,0x00,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x0F,0xFF,0x80,0x00,0x7F,0xF8,
0x01,0x00,0x00,0x00,0x7F,0xF8,0x00,0x03,0xFF,0xC0,
0x00,0x00,0x00,0x1F,0xFE,0x00,0x01,0xFF,0xF0,0x00,
0x00,0x00,0x0F,0xFF,0x80,0x00,0x7F,0xF8,0x00,0x90,
0x00,0x00,0x7F,0xF8,0x00,0x03,0xFF,0xC0,0x00,0x00,
0x00,0x1F,0xFE,0x00,0x01,0xFF,0xF0,0x01,0xBF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x0F,
0xFF,0x00,0x00,0x7F,0xF8,0x00,0x00,0x00,0x03,0xFF,
0xC0,0x00,0x3F,0xFE,0x00,0x00,0x00,0x01,0xFF,0xF0,
0x00,0x0F,0xFF,0x00,0x01,0x20,0x00,0x0F,0xFF,0x00,
0x00,0x7F,0xF8,0x00,0x00,0x00,0x03,0xFF,0xC0,0x00,
0x3F,0xFE,0x00,0x00,0x00,0x01,0xFF,0xF0,0x00,0x0F,
0xFF,0x00,0x00,0x90,0x00,0x0F,0xFF,0x00,0x00,0x7F,
0xF8,0x00,0x00,0x00,0x03,0xFF,0xC0,0x00,0x3F,0xFE,
0x00,0x00,0x00,0x01,0xFF,0xF0,0x00,0x0F,0xFF,0x00,
0x00,0x48,0x00,0x0F,0xFF,0x00,0x00,0x7F,0xF8,0x00,
0x00,0x00,0x03,0xFF,0xC0,0x00,0x3F,0xFE,0x00,0x00,
0x00,0x01,0xFF,0xF0,0x00,0x0F,0xFF,0x00,0x00,0x20,
0x00,0x0F,0xFF,0x00,0x00,0x7F,0xF8,0x00,0x01,0xBF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC8,0x00,
0xFF,0xF0,0x00,0x07,0xFF,0x80,0x00,0x00,0x00,0x3F,
0xFC,0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,0x1F,0xFF,
0x00,0x00,0xFF,0xF0,0x00,0x00,0x20,0x00,0xFF,0xF0,
0x00,0x07,0xFF,0x80,0x00,0x00,0x00,0x3F,0xFC,0x00,
0x03,0xFF,0xE0,0x00,0x00,0x00,0x1F,0xFF,0x00,0x00,
0xFF,0xF0,0x00,0x00,0x12,0x00,0xFF,0xF0,0x00,0x07,
0xFF,0x80,0x00,0x00,0x00,0x3F,0xFC,0x00,0x03,0xFF,
0xE0,0x00,0x00,0x00,0x1F,0xFF,0x00,0x00,0xFF,0xF0,
0x00,0x00,0x09,0x00,0xFF,0xF0,0x00,0x07,0xFF,0x80,
0x00,0x00,0x00,0x3F,0xFC,0x00,0x03,0xFF,0xE0,0x00,
0x00,0x00,0x1F,0xFF,0x00,0x00,0xFF,0xF0,0x00,0x00,
0x04,0x80,0xFF,0xF0,0x00,0x07,0xFF,0x80,0x00,0x00,
0x00,0x3F,0xFC,0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,
0x1F,0xFF,0x00,0x00,0xFF,0xF0,0x00,0x00,0x00,0x07,
0xFF,0x80,0x00,0x3F,0xFC,0x00,0x00,0x00,0x0F,0xFA,
0x1B,0xCD,0x2A,0xC0,0x00,0x00,0x03,0xF8,0x00,0x00,
0x00,0x00,0x00,0x00,0x3F,0xFF,0x00,0x00,0x00,0x00,
0x00,0x03,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0x1F,
0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,
0xFF,0xC0,0x00,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xE0,
0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,
0x0F,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x1F,0xFF,
0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x3F,0xFF,0xFF,0xFF,
0xFF,0xFF,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,
0x80,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,
0xFF,0xFF,0xF3,0xFF,0xFF,0xFF,0xC0,0x01,0xFF,0xFF,
0x83,0xF9,0xFF,0xFF,0xE0,0x01,0xFF,0xFE,0x03,0xF8,
0x3F,0xFF,0xF0,0x03,0xFF,0xF8,0x03,0xF8,0x0F,0xFF,
0xF0,0x03,0xFF,0xF0,0x03,0xF8,0x07,0xFF,0xF8,0x07,
0xFF,0xE0,0x03,0xF8,0x01,0xFF,0xF8,0x07,0xFF,0xC0,
0x03,0xF8,0x01,0xFF,0xF8,0x07,0xFF,0xC0,0x03,0xF8,
0x00,0xFF,0xFC,0x07,0xFF,0x80,0x03,0xF8,0x00,0x7F,
0xFC,0x0F,0xFF,0x80,0x03,0xF8,0x00,0x7F,0xFC,0x49,
0xFF,0xE0,0x00,0x7F,0x00,0x07,0xFF,0xC1,0xFF,0xE0,
0x00,0x7F,0x00,0x03,0xFE,0x01,0xFF,0xE0,0x00,0x7F,
0x00,0x03,0x80,0x09,0x3F,0xFC,0x00,0x0F,0xE0,0x00,
0x00,0x01,0x07,0xFF,0xC0,0x01,0xFC,0x00,0x00,0x00,
0x03,0xFF,0xC0,0x01,0xFC,0x00,0x00,0x00,0x20,0x7F,
0xFC,0x00,0x3F,0x80,0x00,0x00,0x00,0x7F,0xFE,0x00,
0x3F,0x80,0x00,0x00,0x00,0x3F,0xFF,0x00,0x3F,0x80,
0x00,0x00,0x00,0x3F,0xFF,0xC0,0x3F,0x80,0x00,0x00,
0x00,0x1F,0xFF,0xE0,0x3F,0x80,0x00,0x00,0x00,0x1F,
0xFF,0xFC,0x3F,0x80,0x00,0x00,0x00,0x0F,0xFF,0xFF,
0xBF,0x80,0x00,0x00,0x04,0x00,0xFF,0xFF,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFE,0x00,0x00,
0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,
0x0F,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x07,0xFF,
0xFF,0xFF,0xFF,0x00,0x00,0x00,0x01,0xFF,0xFF,0xFF,
0xFF,0xC0,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xF0,
0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFC,0x00,0x00,
0x00,0x07,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x1F,0xFF,
0xFF,0xFF,0x80,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,
0xC0,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xE0,0x00,
0x00,0x00,0x07,0xF7,0xFF,0xFF,0xF0,0x00,0x00,0x00,
0x07,0xF0,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x07,0xF0,
0x1F,0xFF,0xF8,0x00,0x00,0x00,0x07,0xF0,0x0F,0xFF,
0xF8,0x00,0x00,0x00,0x07,0xF0,0x03,0xFF,0xFC,0x00,
0x00,0x00,0x07,0xF0,0x01,0xFF,0xFC,0x80,0x00,0x00,
0x00,0xFE,0x00,0x0F,0xFF,0xC0,0x00,0x00,0x00,0xFE,
0x00,0x07,0xFF,0xC0,0x00,0x00,0x00,0xFE,0x00,0x03,
0xFF,0xD0,0x00,0x00,0x00,0x1F,0xC0,0x00,0x7F,0xFE,
0x40,0x00,0x00,0x03,0xF8,0x00,0x07,0xFF,0x80,0x1C,
0x00,0x03,0xF8,0x00,0x07,0xFF,0x87,0xFC,0x00,0x03,
0xF8,0x00,0x07,0xFF,0xBF,0xFC,0x00,0x03,0xF8,0x00,
0x07,0xFF,0xC7,0xFF,0xC0,0x00,0x7F,0x00,0x00,0xFF,
0xF7,0xFF,0xC0,0x00,0x7F,0x00,0x01,0xFF,0xF8,0x7F,
0xFC,0x00,0x0F,0xE0,0x00,0x3F,0xFC,0x7F,0xFC,0x00,
0x0F,0xE0,0x00,0x7F,0xFC,0x7F,0xFE,0x00,0x0F,0xE0,
0x00,0x7F,0xFC,0x3F,0xFE,0x00,0x0F,0xE0,0x00,0xFF,
0xF8,0x3F,0xFF,0x00,0x0F,0xE0,0x01,0xFF,0xF8,0x3F,
0xFF,0x80,0x0F,0xE0,0x03,0xFF,0xF8,0x1F,0xFF,0xC0,
0x0F,0xE0,0x07,0xFF,0xF0,0x1F,0xFF,0xE0,0x0F,0xE0,
0x0F,0xFF,0xF0,0x0F,0xFF,0xF8,0x0F,0xE0,0x1F,0xFF,
0xE0,0x0F,0xFF,0xFC,0x0F,0xE0,0x7F,0xFF,0xC0,0x07,
0xFF,0xFF,0x8F,0xE3,0xFF,0xFF,0xC0,0x07,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x80,0x03,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,
0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,
0x7F,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x3F,0xFF,
0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x1F,0xFF,0xFF,0xFF,
0xFF,0xC0,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0x00,
0x00,0x00,0x01,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xE0,
0x00,0x00,0x01,0xA0,0x00,0x00,0x01,0xFC,0x00,0x00,
0x00,0x2C,0x00,0x00,0x00,0x3F,0x80,0x00,0x00,0x00,
0x19,0xF0,0x9F,0xFD,0xD8,0x00,0x03,0xFF,0x00,0x00,
0x00,0x00,0x00,0x01,0xFF,0xE0,0x00,0x00,0x00,0x1F,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x01,0xFF,0xC0,0x00,
0x00,0x00,0x7F,0xFF,0xF8,0x00,0x00,0x00,0x00,0x03,
0xFF,0xC0,0x00,0x00,0x00,0xFF,0xFF,0xFE,0x00,0x00,
0x00,0x00,0x03,0xFF,0x80,0x00,0x00,0x01,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x07,0xFF,0x80,0x00,0x00,
0x03,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x00,0x07,0xFF,
0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xC0,0x00,0x00,
0x00,0x0F,0xFE,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,
0xE0,0x00,0x00,0x00,0x0F,0xFE,0x00,0x00,0x00,0x1F,
0xFF,0x83,0xFF,0xF0,0x00,0x00,0x00,0x1F,0xFC,0x00,
0x00,0x00,0x1F,0xFC,0x00,0xFF,0xF0,0x00,0x00,0x00,
0x1F,0xFC,0x00,0x00,0x00,0x3F,0xF8,0x00,0x3F,0xF8,
0x00,0x00,0x00,0x3F,0xF8,0x00,0x00,0x00,0x3F,0xF0,
0x00,0x1F,0xF8,0x00,0x00,0x00,0x3F,0xF8,0x00,0x00,
0x00,0x7F,0xF0,0x00,0x1F,0xFC,0x00,0x00,0x00,0x7F,
0xF0,0x00,0x00,0x00,0x7F,0xE0,0x00,0x0F,0xFC,0x00,
0x00,0x00,0xFF,0xF0,0x00,0x00,0x00,0xFF,0xE0,0x00,
0x0F,0xFE,0x00,0x00,0x00,0xFF,0xE0,0x00,0x00,0x00,
0xFF,0xC0,0x00,0x07,0xFE,0x00,0x00,0x01,0xFF,0xE0,
0x00,0x00,0x00,0xFF,0xC0,0x00,0x07,0xFE,0x00,0x00,
0x01,0xFF,0xC0,0x00,0x00,0x00,0xFF,0xC0,0x00,0x07,
0xFE,0x00,0x00,0x03,0xFF,0xC0,0x00,0x00,0x00,0xFF,
0xC0,0x00,0x07,0xFE,0x00,0x00,0x03,0xFF,0x80,0x00,
0x00,0x02,0x3F,0xF0,0x00,0x00,0x7F,0xE0,0x00,0x00,
0xFF,0xE0,0x00,0x00,0x00,0x47,0xFE,0x00,0x00,0x0F,
0xFC,0x00,0x00,0x3F,0xF8,0x00,0x00,0x00,0x08,0xFF,
0xC0,0x00,0x01,0xFF,0x80,0x00,0x0F,0xFE,0x00,0x00,
0x00,0x00,0xFF,0xC0,0x00,0x01,0xFF,0x80,0x00,0x1F,
0xFC,0x00,0x00,0x00,0x00,0xFF,0xC0,0x00,0x01,0xFF,
0x80,0x00,0x3F,0xFC,0x00,0x00,0x00,0x00,0xFF,0xC0,
0x00,0x01,0xFF,0x80,0x00,0x3F,0xF8,0x00,0x00,0x00,
0x00,0xFF,0xC0,0x00,0x01,0xFF,0x80,0x00,0x7F,0xF8,
0x00,0x00,0x00,0x00,0xFF,0xC0,0x00,0x01,0xFF,0x80,
0x00,0x7F,0xF0,0x00,0x00,0x00,0x00,0xFF,0xC0,0x00,
0x01,0xFF,0x80,0x00,0xFF,0xF0,0x00,0x00,0x00,0x00,
0xFF,0xC0,0x00,0x01,0xFF,0x80,0x00,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x7F,0xC0,0x00,0x03,0xFF,0x00,0x01,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x7F,0xE0,0x00,0x03,
0xFF,0x00,0x01,0xFF,0xC0,0x00,0x00,0x00,0x01,0x0F,
0xFC,0x00,0x00,0x7F,0xE0,0x00,0x7F,0xF0,0x00,0x00,
0x00,0x00,0x0F,0xFC,0x00,0x00,0xFF,0xC0,0x00,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x07,0xFE,0x00,0x00,0xFF,
0xC0,0x00,0xFF,0xE0,0x00,0x00,0x00,0x00,0x07,0xFE,
0x00,0x01,0xFF,0xC0,0x01,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x03,0xFF,0x00,0x01,0xFF,0x80,0x03,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x03,0xFF,0x80,0x03,0xFF,0x80,
0x03,0xFF,0x80,0x00,0x00,0x00,0x00,0x01,0xFF,0xC0,
0x07,0xFF,0x00,0x07,0xFF,0x80,0x00,0x00,0x00,0x00,
0x01,0xFF,0xF0,0x1F,0xFF,0x00,0x07,0xFF,0x00,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFE,0x00,0x0F,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,
0xFC,0x00,0x0F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFF,0xFF,0xF8,0x00,0x1F,0xFC,0x00,0x00,0x00,
0x00,0x00,0x00,0x1F,0xFF,0xFF,0xF0,0x00,0x1F,0xFC,
0x00,0x00,0xFF,0xC0,0x00,0x00,0x0F,0xFF,0xFF,0xE0,
0x00,0x3F,0xF8,0x00,0x07,0xFF,0xF8,0x00,0x00,0x03,
0xFF,0xFF,0x80,0x00,0x3F,0xF8,0x00,0x1F,0xFF,0xFE,
0x00,0x00,0x00,0xFF,0xFE,0x00,0x00,0x7F,0xF0,0x00,
0x3F,0xFF,0xFF,0x80,0x00,0x00,0x1F,0xF0,0x00,0x00,
0x7F,0xF0,0x00,0x7F,0xFF,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0xE0,0x00,0xFF,0xFF,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xE0,0x01,0xFF,
0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,
0xC0,0x03,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x00,0x03,0xFF,0xC0,0x07,0xFF,0xE0,0xFF,0xFC,0x00,
0x00,0x00,0x00,0x00,0x03,0xFF,0x80,0x07,0xFF,0x00,
0x3F,0xFC,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0x80,
0x0F,0xFE,0x00,0x0F,0xFE,0x00,0x00,0x00,0x00,0x00,
0x07,0xFF,0x00,0x0F,0xFC,0x00,0x07,0xFE,0x00,0x00,
0x00,0x00,0x00,0x0F,0xFE,0x00,0x1F,0xFC,0x00,0x07,
0xFF,0x00,0x00,0x00,0x00,0x00,0x0F,0xFE,0x00,0x1F,
0xF8,0x00,0x03,0xFF,0x00,0x00,0x00,0x00,0x00,0x1F,
0xFC,0x00,0x3F,0xF8,0x00,0x03,0xFF,0x80,0x00,0x00,
0x00,0x00,0x1F,0xFC,0x00,0x3F,0xF0,0x00,0x01,0xFF,
0xA0,0x00,0x00,0x00,0x00,0x07,0xFF,0x00,0x07,0xFE,
0x00,0x00,0x3F,0xF0,0x00,0x00,0x00,0x00,0x0F,0xFE,
0x00,0x0F,0xFE,0x00,0x00,0x3F,0xF0,0x00,0x00,0x00,
0x00,0x1F,0xFE,0x00,0x0F,0xFC,0x00,0x00,0x1F,0xF8,
0x00,0x00,0x00,0x00,0x1F,0xFC,0x00,0x0F,0xFC,0x00,
0x00,0x1F,0xF8,0x00,0x00,0x00,0x00,0x3F,0xFC,0x00,
0x0F,0xFC,0x00,0x00,0x1F,0xF8,0x00,0x00,0x00,0x00,
0x3F,0xF8,0x00,0x0F,0xFC,0x00,0x00,0x1F,0xF8,0x00,
0x00,0x00,0x00,0x7F,0xF8,0x00,0x0F,0xFC,0x00,0x00,
0x1F,0xF8,0x00,0x00,0x00,0x00,0x7F,0xF0,0x00,0x0F,
0xFC,0x00,0x00,0x1F,0xFC,0x00,0x00,0x00,0x00,0x1F,
0xFC,0x00,0x01,0xFF,0x80,0x00,0x03,0xFF,0x80,0x00,
0x00,0x00,0x07,0xFF,0x00,0x00,0x3F,0xF0,0x00,0x00,
0x7F,0xF0,0x00,0x00,0x00,0x01,0xFF,0xC0,0x00,0x07,
0xFE,0x00,0x00,0x0F,0xFC,0x00,0x00,0x00,0x03,0xFF,
0x80,0x00,0x07,0xFE,0x00,0x00,0x0F,0xFC,0x00,0x00,
0x00,0x07,0xFF,0x80,0x00,0x03,0xFE,0x00,0x00,0x1F,
0xF8,0x00,0x00,0x00,0x07,0xFF,0x00,0x00,0x03,0xFF,
0x00,0x00,0x1F,0xF8,0x00,0x00,0x00,0x0F,0xFF,0x00,
0x00,0x03,0xFF,0x00,0x00,0x1F,0xF8,0x00,0x00,0x00,
0x0F,0xFE,0x00,0x00,0x03,0xFF,0x00,0x00,0x1F,0xF8,
0x00,0x00,0x00,0x1F,0xFE,0x00,0x00,0x03,0xFF,0x80,
0x00,0x3F,0xF0,0x00,0x00,0x00,0x1F,0xFC,0x00,0x00,
0x01,0xFF,0x80,0x00,0x3F,0xF0,0x00,0x00,0x00,0x3F,
0xF8,0x00,0x00,0x01,0xFF,0xC0,0x00,0x7F,0xF0,0x00,
0x00,0x00,0x3F,0xF8,0x00,0x00,0x00,0xFF,0xC0,0x00,
0x7F,0xE0,0x00,0x00,0x00,0x7F,0xF0,0x00,0x00,0x00,
0xFF,0xE0,0x00,0xFF,0xE0,0x00,0x00,0x00,0x7F,0xF0,
0x00,0x00,0x00,0x7F,0xF0,0x01,0xFF,0xC0,0x00,0x00,
0x00,0xFF,0xE0,0x00,0x00,0x00,0x7F,0xFC,0x07,0xFF,
0xC0,0x00,0x00,0x00,0xFF,0xE0,0x00,0x00,0x00,0x3F,
0xFF,0xFF,0xFF,0x80,0x00,0x00,0x01,0xFF,0xC0,0x00,
0x00,0x00,0x1F,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x03,
0xFF,0xC0,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFE,0x00,
0x00,0x00,0x03,0xFF,0x80,0x00,0x00,0x00,0x07,0xFF,
0xFF,0xFC,0x00,0x00,0x00,0x07,0xFF,0x80,0x00,0x00,
0x00,0x03,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x07,0xFF,
0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xE0,0x00,0x00,
0x00,0x0F,0xFF,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,
0x80,0x00,0x00,0x00,0x0F,0xFE,0x00,0x00,0x00,0x00,
0x00,0x07,0xFC,0x00,0x00,0x14,0x30,0x9B,0xFD,0x64,
0x00,0x00,0x00,0x07,0xFF,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x1F,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x7F,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,
0x00,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,
0x00,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFF,0x80,0x7F,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x7F,0xFF,0x00,0x0F,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x7F,0xFF,0x00,0x03,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x3F,0xFF,0x00,0x00,0xFF,0xFC,0x00,
0x00,0x00,0x00,0x1F,0xFF,0x00,0x00,0x3F,0xFE,0x00,
0x00,0x02,0x00,0x03,0xFF,0xE0,0x00,0x01,0xFF,0xF0,
0x00,0x00,0x30,0x00,0x3F,0xFC,0x00,0x00,0x0F,0xFF,
0x00,0x00,0x00,0x00,0x1F,0xFF,0x00,0x00,0x07,0xFF,
0x00,0x00,0x00,0x00,0x07,0xFF,0x80,0x00,0x07,0xFF,
0x80,0x00,0x00,0x00,0x03,0xFF,0xE0,0x00,0x03,0xFF,
0xC0,0x00,0x00,0x00,0x01,0xFF,0xF0,0x00,0x03,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x7F,0xFC,0x00,0x03,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x3F,0xFF,0x00,0x03,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xC0,0x03,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x07,0xFF,0xE0,0x03,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x01,0xFF,0xF8,0x07,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0xFF,0xFE,0x07,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x8F,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,
0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,
0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,
0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xF7,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xE1,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xC0,
0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xC0,
0x3F,0xFF,0x80,0x00,0x7C,0x00,0x00,0x3F,0xFF,0x80,
0x0F,0xFF,0xE0,0x00,0x7F,0xF0,0x00,0x3F,0xFF,0x80,
0x03,0xFF,0xF8,0x00,0x3F,0xFE,0x00,0x3F,0xFF,0x80,
0x00,0xFF,0xFE,0x00,0x1F,0xFF,0x00,0x1F,0xFF,0x80,
0x00,0x3F,0xFF,0x80,0x1F,0xFF,0x00,0x1F,0xFF,0x80,
0x00,0x1F,0xFF,0xC0,0x0F,0xFF,0x80,0x1F,0xFF,0x80,
0x00,0x07,0xFF,0xF0,0x07,0xFF,0xC0,0x0F,0xFF,0x80,
0x00,0x01,0xFF,0xFC,0x07,0xFF,0xC0,0x07,0xFF,0x80,
0x00,0x00,0x7F,0xFF,0x03,0xFF,0xE0,0x07,0xFF,0xC0,
0x00,0x00,0x1F,0xFF,0xC3,0xFF,0xF0,0x03,0xFF,0xC0,
0x00,0x00,0x0F,0xFF,0xE1,0xFF,0xF0,0x01,0xFF,0xE0,
0x00,0x00,0x03,0xFF,0xF9,0xFF,0xF8,0x01,0xFF,0xF0,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFC,0x00,0xFF,0xF0,
0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFC,0x00,0x7F,0xF8,
0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFE,0x00,0x3F,0xFC,
0x00,0x00,0x00,0x07,0xFF,0xFF,0xFE,0x00,0x1F,0xFE,
0x00,0x00,0x00,0x01,0xFF,0xFF,0xFF,0x00,0x0F,0xFF,
0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,0x00,0x07,0xFF,
0x80,0x00,0x00,0x00,0x1F,0xFF,0xFF,0x80,0x03,0xFF,
0xC0,0x00,0x00,0x00,0x07,0xFF,0xFF,0x80,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x03,0xFF,0xFF,0x80,0x00,0xFF,
0xF8,0x00,0x00,0x00,0x00,0xFF,0xFF,0xC0,0x00,0x7F,
0xFC,0x00,0x00,0x00,0x00,0x3F,0xFF,0xE0,0x00,0x1F,
0xFF,0x00,0x00,0x00,0x00,0x0F,0xFF,0xF0,0x00,0x0F,
0xFF,0x80,0x00,0x00,0x00,0x0F,0xFF,0xFC,0x00,0x07,
0xFF,0xE0,0x00,0x00,0x00,0x0F,0xFF,0xFF,0x00,0x01,
0xFF,0xF8,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xC0,0x00,
0xFF,0xFC,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xF0,0x00,
0x7F,0xFF,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFC,0x00,
0x1F,0xFF,0xC0,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0x00,
0x0F,0xFF,0xF0,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xC0,
0x03,0xFF,0xFC,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xF0,
0x00,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0xF7,0xFF,0xFC,
0x00,0x7F,0xFF,0xF8,0x03,0xFF,0xFF,0xF3,0xFF,0xFF,
0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0xFF,0xFF,
0xE0,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x3F,0xFF,
0xF8,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x0F,0xFF,
0xFE,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xF0,0x03,0xFF,
0xFE,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0xFF,
0xFE,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x1F,
0xFE,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x07,
0xFE,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xC0,0x00,0x01,
0xFE,0x00,0x00,0x03,0xFF,0xFF,0xFF,0x00,0x00,0x00,
0x7E,0x00,0x00,0x00,0x3F,0xFF,0xFE,0x00,0x00,0x00,
0x0E,0x00,0x00,0x00,0x01,0xFF,0xE0,0x00,0x00,0x00,
0x02,0x00,0x03,0x11,0x18,0xF4,0x67,0x7F,0xFF,0x7F,
0xFE,0xFF,0xFF,0x5F,0xFB,0x0F,0xF0,0x7F,0x01,0xF8,
0x08,0x3C,0xA3,0x98,0xB0,0x00,0x00,0x01,0xFE,0x00,
0x00,0x01,0xFE,0x00,0x00,0x01,0xFE,0x00,0x00,0x01,
0xFF,0x20,0x00,0x00,0x3F,0xE0,0x00,0x00,0x3F,0xE1,
0x00,0x00,0x07,0xFC,0x00,0x00,0x07,0xFC,0x00,0x00,
0x07,0xFE,0x00,0x00,0x03,0xFE,0x00,0x00,0x03,0xFF,
0x00,0x00,0x03,0xFF,0x00,0x00,0x01,0xFF,0x00,0x00,
0x01,0xFF,0x80,0x00,0x00,0xFF,0x80,0x00,0x00,0xFF,
0xC0,0x08,0x00,0x1F,0xF8,0x00,0x80,0x03,0xFF,0x00,
0x00,0x03,0xFF,0x80,0x00,0x01,0xFF,0x80,0x00,0x01,
0xFF,0xC0,0x00,0x00,0xFF,0xC0,0x00,0x80,0x1F,0xFC,
0x00,0x09,0x03,0xFF,0x80,0x00,0x90,0x7F,0xF0,0x00,
0x09,0x0F,0xFE,0x00,0x00,0x0F,0xFF,0x00,0x00,0x40,
0xFF,0xE0,0x00,0x04,0x9F,0xFE,0x00,0x00,0x41,0xFF,
0xC0,0x00,0x06,0x3F,0xFC,0x00,0x00,0x6F,0xFF,0x80,
0x00,0x06,0xFF,0xF8,0x00,0x00,0x5F,0xFF,0x80,0x00,
0x06,0x3F,0xFC,0x00,0x00,0x0F,0xFE,0x00,0x00,0x28,
0xFF,0xF0,0x00,0x00,0x3F,0xF8,0x00,0x01,0x03,0xFF,
0xC0,0x00,0x10,0x1F,0xFC,0x00,0x00,0x0F,0xFF,0x00,
0x00,0x80,0x7F,0xF0,0x00,0x00,0x3F,0xFC,0x00,0x04,
0x01,0xFF,0xC0,0x00,0x48,0x0F,0xFE,0x00,0x04,0x00,
0x7F,0xF0,0x00,0x00,0x1F,0xF8,0x00,0x00,0x0F,0xFE,
0x00,0x00,0x03,0xFF,0x00,0x00,0x01,0xFF,0xC0,0x00,
0x00,0x7F,0xE0,0x00,0x00,0x3F,0xF8,0x00,0x00,0x0F,
0xFC,0x00,0x80,0x00,0x7F,0xE0,0x08,0x00,0x03,0xFF,
0x00,0x80,0x00,0x1F,0xF8,0x00,0x00,0x07,0xFE,0x00,
0x00,0x01,0xFF,0x00,0x00,0x00,0xFF,0xC0,0x00,0x00,
0x3F,0xE0,0x00,0x00,0x0F,0xF8,0x40,0x00,0x00,0x7F,
0xC0,0x00,0x00,0x1F,0xF0,0x00,0x00,0x07,0xF8,0x00,
0x00,0x01,0xFE,0x00,0x00,0x00,0x7F,0x80,0x08,0x3C,
0x9F,0x98,0xB1,0xFE,0x00,0x00,0x00,0x7F,0x80,0x00,
0x00,0x3F,0xE0,0x00,0x00,0x0F,0xF8,0x00,0x00,0x03,
0xFC,0x00,0x00,0x01,0xFF,0x00,0x00,0x00,0x7F,0xC0,
0x00,0x00,0x3F,0xF0,0x00,0x00,0x0F,0xF8,0x00,0x00,
0x03,0xFE,0x00,0x00,0x01,0xFF,0x80,0x00,0x00,0x7F,
0xC0,0x00,0x00,0x3F,0xF0,0x00,0x10,0x01,0xFF,0x80,
0x00,0x00,0x7F,0xE0,0x00,0x00,0x1F,0xF0,0x00,0x00,
0x0F,0xFC,0x00,0x20,0x00,0x7F,0xE0,0x00,0x00,0x3F,
0xF8,0x00,0x00,0x0F,0xFC,0x00,0x00,0x07,0xFF,0x00,
0x00,0x01,0xFF,0x80,0x00,0x00,0xFF,0xE0,0x00,0x00,
0x3F,0xF0,0x08,0x00,0x03,0xFF,0x80,0x00,0x00,0xFF,
0xC0,0x40,0x00,0x0F,0xFE,0x04,0x80,0x00,0x7F,0xF0,
0x00,0x00,0x3F,0xFC,0x20,0x00,0x01,0xFF,0xC2,0x00,
0x00,0x1F,0xFE,0x00,0x00,0x07,0xFF,0x14,0x00,0x00,
0x7F,0xF8,0x00,0x00,0x1F,0xFC,0xC0,0x00,0x01,0xFF,
0xE0,0x00,0x00,0x7F,0xF6,0x80,0x00,0x07,0xFF,0xE8,
0x00,0x00,0x7F,0xFD,0x00,0x00,0x07,0xFF,0xE0,0x00,
0x00,0xFF,0xF0,0x00,0x00,0x7F,0xF2,0x40,0x00,0x0F,
0xFF,0x20,0x00,0x00,0xFF,0xE2,0x00,0x00,0x1F,0xFE,
0x20,0x00,0x01,0xFF,0xC0,0x00,0x01,0xFF,0xE1,0x00,
0x00,0x1F,0xFC,0x00,0x00,0x1F,0xFE,0x08,0x00,0x01,
0xFF,0xC0,0x80,0x00,0x3F,0xF8,0x00,0x00,0x1F,0xF8,
0x04,0x00,0x03,0xFF,0x80,0x00,0x01,0xFF,0x80,0x00,
0x01,0xFF,0xC0,0x00,0x00,0xFF,0xC0,0x00,0x00,0xFF,
0xE0,0x00,0x00,0x7F,0xE0,0x00,0x00,0x7F,0xF0,0x00,
0x00,0x3F,0xF0,0x00,0x80,0x07,0xFE,0x00,0x08,0x00,
0xFF,0xC0,0x00,0x00,0xFF,0xC0,0x00,0x00,0x7F,0xC0,
0x00,0x00,0x7F,0xE0,0x00,0x00,0x3F,0xE0,0x00,0x08,
0x07,0xFC,0x00,0x00,0x07,0xFC,0x00,0x00,0x40,0xFF,
0x80,0x00,0x00,0xFF,0x80,0x00,0x00,0x7F,0x80,0x00,
0x00,0x7F,0x80,0x00,0x00,0x7F,0x80,0x00,0x00,0x00,
0x0B,0x14,0x10,0xDC,0xD3,0x40,0x00,0x1F,0xF8,0x00,
0x00,0x00,0x00,0xFF,0x80,0x00,0x10,0x00,0x00,0x7F,
0x80,0x00,0x01,0x80,0x03,0xFC,0x00,0x18,0x1F,0x80,
0x1F,0xE0,0x07,0xE0,0xFF,0x00,0xFF,0x00,0xFF,0x07,
0xFF,0x07,0xF8,0x3F,0xF8,0x7F,0xFE,0x3F,0xC7,0xFF,
0xE3,0xFF,0xFD,0xFC,0xFF,0xFF,0x1F,0xFF,0xFF,0xFF,
0xFF,0xFA,0x3F,0xFF,0xFF,0xFF,0xFF,0xFC,0x7F,0xFF,
0xFF,0xFF,0xFF,0x80,0x3F,0xFF,0xFF,0xFF,0xE0,0x00,
0x0F,0xFF,0xFF,0xF0,0x00,0x00,0x03,0xFF,0xC0,0x00,
0x00,0x00,0x3F,0xFF,0x00,0x00,0x00,0x03,0xFF,0xFC,
0x00,0x00,0x00,0x3F,0xFF,0xF0,0x00,0x00,0x03,0xFF,
0xFF,0xC0,0x00,0x00,0x3F,0xF3,0xFF,0x00,0x00,0x03,
0xFF,0x9F,0xFC,0x00,0x00,0x1F,0xF8,0x7F,0xF0,0x00,
0x01,0xFF,0x83,0xFF,0x80,0x00,0x1F,0xFC,0x0F,0xFE,
0x00,0x01,0xFF,0xC0,0x3F,0xF8,0x00,0x1F,0xFE,0x01,
0xFF,0xE0,0x01,0xFF,0xE0,0x07,0xFF,0x80,0x03,0xFE,
0x00,0x1F,0xF8,0x00,0x0F,0xF0,0x00,0xFF,0x00,0x00,
0x3F,0x00,0x03,0xF0,0x00,0x00,0x70,0x00,0x0E,0x00,
0x00,0x01,0x00,0x00,0x20,0x00,0x0F,0xDF,0x9C,0x3D,
0x3B,0x40,0x00,0x00,0x0F,0xFE,0x00,0x00,0x00,0x68,
0x00,0x00,0x01,0xFF,0xC0,0x00,0x00,0x0D,0x00,0x00,
0x00,0x3F,0xF8,0x00,0x00,0x01,0x60,0x00,0x00,0x07,
0xFF,0x00,0x00,0x00,0x37,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFD,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xD0,0x00,0x00,0x03,0xFF,0x80,0x00,0x00,0x1A,
0x00,0x00,0x00,0x7F,0xF0,0x00,0x00,0x03,0x40,0x00,
0x00,0x0F,0xFE,0x00,0x00,0x00,0x58,0x00,0x00,0x01,
0xFF,0xC0,0x00,0x00,0x00,0x03,0x10,0x33,0xB0,0x97,
0x7F,0xFE,0xFF,0xFE,0xC0,0xFE,0x01,0xFE,0x01,0xFA,
0x03,0xF8,0x1F,0x81,0xFC,0x1F,0xC1,0xFE,0x1F,0xE0,
0x7E,0x01,0xE0,0x0E,0x00,0x20,0x00,0x09,0x05,0x90,
0x74,0xB3,0x7F,0xFF,0xFF,0xFF,0xFE,0xBF,0xFF,0xFF,
0xFF,0xFC,0x03,0x06,0x30,0x00,0x97,0x7F,0xFE,0xFF,
0xFC,0x09,0xAF,0x80,0x00,0x96,0x00,0x00,0x00,0x03,
0xFF,0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,0x03,
0xFF,0x00,0x00,0x00,0x0F,0xFE,0x80,0x00,0x00,0x03,
0xFF,0x20,0x00,0x00,0x01,0xFF,0xC8,0x00,0x00,0x00,
0x7F,0xE0,0x00,0x00,0x01,0xFF,0xC4,0x00,0x00,0x00,
0x7F,0xE1,0x00,0x00,0x00,0x3F,0xF8,0x40,0x00,0x00,
0x0F,0xFC,0x00,0x00,0x00,0x3F,0xF8,0x20,0x00,0x00,
0x0F,0xFC,0x00,0x00,0x00,0x3F,0xF8,0x10,0x00,0x00,
0x0F,0xFC,0x04,0x00,0x00,0x07,0xFF,0x01,0x00,0x00,
0x01,0xFF,0x80,0x00,0x00,0x07,0xFF,0x00,0x80,0x00,
0x01,0xFF,0x80,0x20,0x00,0x00,0xFF,0xE0,0x08,0x00,
0x00,0x3F,0xF0,0x00,0x00,0x00,0xFF,0xE0,0x04,0x00,
0x00,0x3F,0xF0,0x00,0x00,0x00,0xFF,0xE0,0x02,0x00,
0x00,0x3F,0xF0,0x00,0x80,0x00,0x1F,0xFC,0x00,0x20,
0x00,0x07,0xFE,0x00,0x00,0x00,0x1F,0xFC,0x00,0x10,
0x00,0x07,0xFE,0x00,0x04,0x00,0x03,0xFF,0x80,0x01,
0x00,0x00,0xFF,0xC0,0x00,0x00,0x03,0xFF,0x80,0x00,
0x80,0x00,0xFF,0xC0,0x00,0x00,0x03,0xFF,0x80,0x00,
0x40,0x00,0xFF,0xC0,0x00,0x10,0x00,0x7F,0xF0,0x00,
0x04,0x00,0x1F,0xF8,0x00,0x00,0x00,0x7F,0xF0,0x00,
0x02,0x00,0x1F,0xF8,0x00,0x00,0x80,0x0F,0xFE,0x00,
0x00,0x00,0x1F,0xF8,0x00,0x00,0x40,0x0F,0xFE,0x00,
0x00,0x10,0x03,0xFF,0x00,0x00,0x00,0x0F,0xFE,0x00,
0x00,0x08,0x03,0xFF,0x00,0x00,0x02,0x01,0xFF,0xC0,
0x00,0x00,0x80,0x7F,0xE0,0x00,0x00,0x01,0xFF,0xC0,
0x00,0x00,0x40,0x7F,0xE0,0x00,0x00,0x01,0xFF,0xC0,
0x00,0x00,0x20,0x7F,0xE0,0x00,0x00,0x08,0x3F,0xF8,
0x00,0x00,0x02,0x0F,0xFC,0x00,0x00,0x00,0x3F,0xF8,
0x00,0x00,0x01,0x0F,0xFC,0x00,0x00,0x00,0x47,0xFF,
0x00,0x00,0x00,0x00,0x0F,0xB0,0x1B,0xFD,0x28,0x00,
0x00,0x00,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x1F,
0xFF,0xFE,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0x80,0x00,
0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x01,
0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x07,0xFF,0xFF,
0xFF,0xFF,0xE0,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,
0xE0,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xE0,0x04,
0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0xFF,
0xFF,0xE0,0x1F,0xFF,0xFC,0x00,0x03,0xFF,0xFE,0x00,
0x07,0xFF,0xFC,0x00,0x07,0xFF,0xF0,0x00,0x03,0xFF,
0xF8,0x00,0x1F,0xFF,0xC0,0x00,0x03,0xFF,0xF8,0x00,
0x3F,0xFF,0x00,0x00,0x03,0xFF,0xF0,0x00,0xFF,0xFC,
0x00,0x00,0x03,0xFF,0xF0,0x01,0xFF,0xF0,0x00,0x00,
0x03,0xFF,0xE0,0x07,0xFF,0xC0,0x00,0x00,0x03,0xFF,
0xC0,0x0F,0xFF,0x80,0x00,0x00,0x07,0xFF,0xC0,0x1F,
0xFE,0x00,0x00,0x00,0x07,0xFF,0x80,0x7F,0xFC,0x00,
0x00,0x00,0x0F,0xFF,0x88,0x1F,0xFE,0x00,0x00,0x00,
0x01,0xFF,0xE0,0x7F,0xFC,0x00,0x00,0x00,0x03,0xFF,
0xC5,0x1F,0xFE,0x00,0x00,0x00,0x00,0x7F,0xF9,0xAF,
0xFF,0x00,0x00,0x00,0x00,0x0F,0xFF,0x6F,0xFF,0x80,
0x00,0x00,0x00,0x01,0xFF,0xFB,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x7F,0xFE,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x1F,0xFF,0x3F,0xFE,0x00,0x00,0x00,0x00,0x07,0xFF,
0x9F,0xFC,0x00,0x00,0x00,0x00,0x1F,0xFE,0xC7,0xFF,
0x80,0x00,0x00,0x00,0x07,0xFF,0x87,0xFF,0x00,0x00,
0x00,0x00,0x1F,0xFE,0x49,0xFF,0xE0,0x00,0x00,0x00,
0x07,0xFF,0x83,0xFF,0xC0,0x00,0x00,0x00,0x1F,0xFF,
0x20,0x7F,0xF8,0x00,0x00,0x00,0x07,0xFF,0x80,0xFF,
0xF8,0x00,0x00,0x00,0x1F,0xFF,0x00,0xFF,0xF0,0x00,
0x00,0x00,0x3F,0xFC,0x20,0x3F,0xFE,0x00,0x00,0x00,
0x1F,0xFF,0x00,0x3F,0xFE,0x00,0x00,0x00,0x7F,0xFC,
0x00,0x7F,0xFE,0x00,0x00,0x01,0xFF,0xF8,0x00,0x7F,
0xFE,0x00,0x00,0x07,0xFF,0xE0,0x00,0xFF,0xFE,0x00,
0x00,0x1F,0xFF,0xC0,0x00,0xFF,0xFE,0x00,0x00,0x7F,
0xFF,0x00,0x01,0xFF,0xFF,0x00,0x03,0xFF,0xFE,0x00,
0x01,0xFF,0xFF,0xC0,0x3F,0xFF,0xF8,0x00,0x03,0xFF,
0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x03,0xFF,0xFF,0xFF,
0xFF,0xFF,0xC0,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,
0x03,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x03,0xFF,
0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x01,0xFF,0xFF,0xFF,
0xFE,0x00,0x00,0x00,0x01,0xFF,0xFF,0xFF,0xF8,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x3F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x07,
0xFF,0x80,0x00,0x00,0x00,0x08,0xEF,0xB8,0x01,0x28,
0x00,0x00,0x00,0x3F,0xE0,0x00,0x00,0x00,0xFF,0x80,
0x00,0x00,0x1F,0xFC,0x00,0x00,0x00,0x7F,0xF0,0x00,
0x00,0x0F,0xFF,0x00,0x00,0x01,0xFF,0xF0,0x00,0x00,
0x3F,0xFF,0x00,0x00,0x07,0xFF,0xF0,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x1F,0xFF,0xF0,0x00,0x03,0xFF,0xFF,
0x00,0x00,0x7F,0xFF,0xF0,0x00,0x0F,0xFF,0xFF,0x00,
0x01,0xFF,0xFF,0xF0,0x00,0x7F,0xFF,0xFF,0x00,0x0F,
0xFF,0xFF,0xF0,0x03,0xFF,0xFF,0xFF,0x00,0x7F,0xFF,
0xFF,0xF0,0x1F,0xFF,0xFF,0xFF,0x07,0xFF,0xFE,0xFF,
0xF0,0xFF,0xFF,0xCF,0xFF,0x3F,0xFF,0xF8,0xFF,0xF7,
0xFF,0xFF,0x0F,0xFF,0x7F,0xFF,0xC0,0xFF,0xF7,0xFF,
0xF8,0x0F,0xFF,0x7F,0xFF,0x00,0xFF,0xF7,0xFF,0xC0,
0x0F,0xFF,0x7F,0xF0,0x00,0xFF,0xF7,0xFC,0x00,0x0F,
0xFF,0x7F,0x80,0x00,0xFF,0xF7,0xE0,0x00,0x0F,0xFF,
0x78,0x00,0x00,0xFF,0xF4,0x00,0x00,0x0F,0xFF,0xD0,
0x00,0x00,0x1F,0xFF,0xA0,0x00,0x00,0x3F,0xFF,0x40,
0x00,0x00,0x7F,0xFE,0x80,0x00,0x00,0xFF,0xFD,0x00,
0x00,0x01,0xFF,0xFA,0x00,0x00,0x03,0xFF,0xF4,0x00,
0x00,0x07,0xFF,0xE8,0x00,0x00,0x0F,0xFF,0xA0,0x00,
0x00,0x1F,0xFE,0x0F,0xAF,0x90,0x01,0x28,0x00,0x00,
0x00,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,
0xFF,0x80,0x00,0x00,0x00,0x01,0xFF,0xFF,0xFF,0xE0,
0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xF0,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x01,0xFF,
0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x07,0xFF,0xFF,0xFF,
0xFF,0xF8,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xF8,
0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x01,
0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x07,0xFF,0xFF,
0xFF,0xFF,0xFF,0xF8,0x00,0x1F,0xFF,0xFE,0x00,0xFF,
0xFF,0xF8,0x00,0x7F,0xFF,0xE0,0x00,0x1F,0xFF,0xF0,
0x00,0xFF,0xFF,0x00,0x00,0x0F,0xFF,0xF0,0x03,0xFF,
0xF8,0x00,0x00,0x0F,0xFF,0xE0,0x07,0xFF,0xE0,0x00,
0x00,0x0F,0xFF,0xE0,0x1F,0xFF,0x80,0x00,0x00,0x0F,
0xFF,0xC0,0x3F,0xFE,0x00,0x00,0x00,0x0F,0xFF,0xC0,
0x7F,0xFC,0x00,0x00,0x00,0x0F,0xFF,0x81,0xFF,0xF0,
0x00,0x00,0x00,0x1F,0xFF,0x03,0xFF,0xE0,0x00,0x00,
0x00,0x1F,0xFE,0x40,0xFF,0xF0,0x00,0x00,0x00,0x07,
0xFF,0xC3,0xFF,0xE0,0x00,0x00,0x00,0x07,0xFF,0xA4,
0xFF,0xF0,0x00,0x00,0x00,0x01,0xFF,0xE0,0x3F,0xE0,
0x00,0x00,0x00,0x03,0xFF,0xC0,0x01,0xC0,0x00,0x00,
0x00,0x07,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x0F,
0xFF,0x40,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x24,0x00,0x00,
0x00,0x00,0x00,0x07,0xFF,0xC0,0x00,0x00,0x00,0x00,
0x00,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,
0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0x03,0xFF,0xF0,0x00,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x7F,0xFE,
0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x00,0x07,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x00,0x1F,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x7F,
0xFF,0x80,0x00,0x00,0x00,0x00,0x01,0xFF,0xFE,0x00,
0x00,0x00,0x00,0x00,0x07,0xFF,0xF8,0x00,0x00,0x00,
0x00,0x00,0x1F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,
0x7F,0xFF,0x80,0x00,0x00,0x00,0x00,0x01,0xFF,0xFE,
0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x00,0x3F,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x00,0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,0x03,0xFF,
0xFE,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0x3F,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,0x07,
0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xF8,
0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x01,0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,
0x07,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x03,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x3F,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x80,
0x00,0x00,0x00,0x00,0x03,0xFF,0xFE,0x00,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,
0x80,0x00,0x00,0x00,0x00,0x01,0xFF,0xFE,0x00,0x00,
0x00,0x00,0x00,0x07,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x08,0x03,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0x80,
0x00,0x00,0x00,0x00,0x00,0x7F,0xFE,0x00,0x00,0x00,
0x00,0x00,0x10,0x3F,0xFF,0x00,0x00,0x00,0x00,0x00,
0x04,0x9F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x2F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x0F,0xB0,0x1B,0xFD,
0x28,0x00,0x00,0x01,0xFF,0xC0,0x00,0x00,0x00,0x00,
0x00,0x3F,0xFF,0xF8,0x00,0x00,0x00,0x00,0x03,0xFF,
0xFF,0xFE,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFF,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x80,0x00,
0x00,0x03,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x0F,
0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x3F,0xFF,0xFF,
0xFF,0xFF,0xC0,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
0xC0,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,
0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x3F,0xFF,
0xF8,0x03,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0x80,0x00,
0xFF,0xFF,0x80,0x01,0xFF,0xFE,0x00,0x00,0x7F,0xFF,
0x00,0x07,0xFF,0xF0,0x00,0x00,0x7F,0xFF,0x00,0x0F,
0xFF,0xC0,0x00,0x00,0x7F,0xFE,0x00,0x3F,0xFF,0x00,
0x00,0x00,0x7F,0xFE,0x00,0x7F,0xFE,0x00,0x00,0x00,
0x7F,0xFC,0x00,0xFF,0xF8,0x00,0x00,0x00,0x7F,0xF8,
0x03,0xFF,0xE0,0x00,0x00,0x00,0xFF,0xF0,0x07,0xFF,
0xC0,0x00,0x00,0x01,0xFF,0xF0,0x41,0xFF,0xE0,0x00,
0x00,0x00,0x3F,0xFC,0x07,0xFF,0xC0,0x00,0x00,0x00,
0x7F,0xF8,0x0F,0xFF,0x00,0x00,0x00,0x00,0xFF,0xF0,
0x03,0xFE,0x00,0x00,0x00,0x01,0xFF,0xE0,0x00,0x1C,
0x00,0x00,0x00,0x03,0xFF,0xC1,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0xF0,0x40,0x00,0x00,0x00,0x00,0x00,
0x7F,0xF8,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,0x00,0x00,
0x00,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xF0,0x00,
0x00,0x00,0x00,0x00,0x7F,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x07,0xFF,0xFF,0x00,0x00,0x00,0x00,0x07,0xFF,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,0x80,0x00,0x00,
0x00,0x00,0x7F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,
0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,
0xFE,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,0x80,
0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0x80,0x00,0x00,
0x00,0x0F,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x3F,
0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x60,0x01,0xFF,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x80,0x00,0x00,
0x00,0x00,0x00,0x3F,0xFF,0x80,0x00,0x00,0x00,0x00,
0x00,0x1F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x1F,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x00,
0x00,0x00,0x00,0x00,0x00,0x3F,0xFE,0x40,0x00,0x00,
0x00,0x00,0x00,0x07,0xFF,0xD0,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x01,
0xFF,0xFB,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFC,
0x00,0xE0,0x00,0x00,0x00,0x00,0x7F,0xF8,0x7F,0xC0,
0x00,0x00,0x00,0x00,0xFF,0xF8,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x3F,0xFD,0xFF,0xF0,0x00,0x00,0x00,0x00,
0xFF,0xF9,0xFF,0xE0,0x00,0x00,0x00,0x01,0xFF,0xE3,
0xFF,0xE0,0x00,0x00,0x00,0x03,0xFF,0xC7,0xFF,0xC0,
0x00,0x00,0x00,0x0F,0xFF,0x8F,0xFF,0xC0,0x00,0x00,
0x00,0x1F,0xFF,0x0F,0xFF,0x80,0x00,0x00,0x00,0x7F,
0xFC,0x1F,0xFF,0x80,0x00,0x00,0x01,0xFF,0xF8,0x3F,
0xFF,0x80,0x00,0x00,0x03,0xFF,0xE0,0x3F,0xFF,0x00,
0x00,0x00,0x0F,0xFF,0xC0,0x7F,0xFF,0x00,0x00,0x00,
0x3F,0xFF,0x00,0x7F,0xFF,0x00,0x00,0x01,0xFF,0xFE,
0x00,0xFF,0xFF,0x80,0x00,0x07,0xFF,0xF8,0x00,0xFF,
0xFF,0xC0,0x00,0x3F,0xFF,0xE0,0x00,0xFF,0xFF,0xF0,
0x07,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,
0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x01,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0xFF,0xFF,0xFF,
0xFF,0xFE,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xF8,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x3F,
0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,
0x80,0x00,0x00,0x00,0x00,0x01,0xFF,0xE0,0x00,0x00,
0x00,0x10,0xAF,0x08,0x01,0x28,0x00,0x00,0x00,0x00,
0x00,0x0F,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x03,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xE0,
0x01,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0x80,0x00,
0x00,0x00,0x00,0x00,0x01,0xFF,0xF0,0x00,0x00,0x00,
0x00,0x00,0x00,0x7F,0xFE,0x00,0x00,0x00,0x00,0x00,
0x00,0x1F,0xFF,0xC0,0x02,0x00,0x00,0x00,0x00,0x00,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFC,0x00,
0x20,0x00,0x00,0x00,0x00,0x7F,0xFF,0xF0,0x00,0x00,
0x00,0x00,0x00,0x1F,0xFF,0xFE,0x00,0x00,0x00,0x00,
0x00,0x07,0xFF,0xFF,0xC0,0x02,0x00,0x00,0x00,0x00,
0x3F,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFC,
0x00,0x20,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xF0,0x00,
0x00,0x00,0x00,0x07,0xFF,0xFF,0xFE,0x00,0x00,0x00,
0x00,0x01,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,
0x7F,0xFF,0x7F,0xF8,0x00,0x00,0x00,0x00,0x0F,0xFF,
0xCF,0xFF,0x00,0x00,0x00,0x00,0x03,0xFF,0xF9,0xFF,
0xE0,0x00,0x00,0x00,0x00,0xFF,0xFE,0x3F,0xFC,0x00,
0x00,0x00,0x00,0x3F,0xFF,0x87,0xFF,0x80,0x04,0x00,
0x00,0x01,0xFF,0xFC,0x1F,0xFE,0x00,0x00,0x00,0x00,
0x7F,0xFF,0x03,0xFF,0xC0,0x00,0x00,0x00,0x1F,0xFF,
0xC0,0x7F,0xF8,0x00,0x40,0x00,0x00,0xFF,0xFE,0x01,
0xFF,0xE0,0x00,0x00,0x00,0x3F,0xFF,0x80,0x3F,0xFC,
0x00,0x00,0x00,0x0F,0xFF,0xE0,0x07,0xFF,0x80,0x00,
0x00,0x03,0xFF,0xF8,0x00,0xFF,0xF0,0x00,0x00,0x00,
0x7F,0xFE,0x00,0x1F,0xFE,0x00,0x00,0x00,0x1F,0xFF,
0xC0,0x03,0xFF,0xC0,0x00,0x00,0x07,0xFF,0xF0,0x00,
0x7F,0xF8,0x00,0x00,0x01,0xFF,0xFC,0x00,0x0F,0xFF,
0x00,0x00,0x00,0x3F,0xFF,0x00,0x01,0xFF,0xE0,0x00,
0x00,0x0F,0xFF,0xE0,0x00,0x3F,0xFC,0x00,0x00,0x03,
0xFF,0xF8,0x00,0x07,0xFF,0x80,0x00,0x00,0xFF,0xFE,
0x00,0x00,0xFF,0xF0,0x00,0x00,0x1F,0xFF,0x80,0x00,
0x1F,0xFE,0x00,0x00,0x07,0xFF,0xF0,0x00,0x03,0xFF,
0xC0,0x00,0x01,0xFF,0xFC,0x00,0x00,0x7F,0xF8,0x00,
0x00,0x7F,0xFF,0x00,0x00,0x0F,0xFF,0x00,0x08,0x03,
0xFF,0xF8,0x00,0x00,0x3F,0xFC,0x00,0x00,0xFF,0xFE,
0x00,0x00,0x07,0xFF,0x80,0x00,0x3F,0xFF,0x80,0x00,
0x00,0xFF,0xF0,0x00,0x0F,0xFF,0xE0,0x00,0x00,0x1F,
0xFE,0x00,0x01,0xFF,0xF8,0x00,0x00,0x03,0xFF,0xC0,
0x00,0x7F,0xFF,0x00,0x00,0x00,0x7F,0xF8,0x00,0x1F,
0xFF,0xC0,0x00,0x00,0x0F,0xFF,0x00,0x07,0xFF,0xF0,
0x00,0x00,0x01,0xFF,0xE0,0x01,0xBF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFD,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFA,0x00,0x00,0x00,0x00,0x00,0x7F,
0xF8,0x00,0x68,0x00,0x00,0x00,0x00,0x01,0xFF,0xE0,
0x01,0xA0,0x00,0x00,0x00,0x00,0x07,0xFF,0x80,0x04,
0x00,0x00,0x00,0x00,0x00,0x1F,0xFE,0x00,0x00,0x0F,
0xAF,0x9B,0xFD,0x2A,0x00,0x03,0xFF,0xFF,0xFF,0xFF,
0xFF,0xE0,0xB0,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,
0x2C,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x03,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x14,0x00,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x04,0x00,0x7F,0xFC,0x00,0x00,
0x00,0x00,0x01,0x20,0x1F,0xFE,0x00,0x00,0x00,0x00,
0x00,0x40,0x0F,0xFF,0x80,0x00,0x00,0x00,0x00,0x12,
0x03,0xFF,0xC0,0x00,0x00,0x00,0x00,0x04,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x01,0x00,0x7F,0xF8,0x00,
0x00,0x00,0x00,0x00,0x00,0xFF,0xF0,0x01,0xFF,0x80,
0x00,0x00,0x03,0xFF,0xE0,0x1F,0xFF,0xF0,0x00,0x00,
0x07,0xFF,0xC1,0xFF,0xFF,0xFC,0x00,0x00,0x0F,0xFF,
0x8F,0xFF,0xFF,0xFC,0x00,0x00,0x1F,0xFE,0x3F,0xFF,
0xFF,0xFE,0x00,0x00,0x3F,0xFD,0xFF,0xFF,0xFF,0xFE,
0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x01,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x03,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x07,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x3F,0xFF,0xFF,0x80,0x1F,0xFF,0xFE,0x00,0x7F,
0xFF,0xF8,0x00,0x07,0xFF,0xFE,0x00,0xFF,0xFF,0xC0,
0x00,0x03,0xFF,0xFE,0x01,0xFF,0xFE,0x00,0x00,0x01,
0xFF,0xFC,0x03,0xFF,0xF8,0x00,0x00,0x01,0xFF,0xFC,
0x0F,0xFF,0xE0,0x00,0x00,0x01,0xFF,0xF8,0x1F,0xFF,
0x80,0x00,0x00,0x01,0xFF,0xF8,0x07,0xFE,0x00,0x00,
0x00,0x01,0xFF,0xF0,0x00,0x38,0x00,0x00,0x00,0x03,
0xFF,0xE4,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFD,
0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x40,0x00,
0x00,0x00,0x00,0x00,0x03,0xFF,0xFA,0x00,0x00,0x00,
0x00,0x00,0x00,0x7F,0xFC,0x80,0x00,0x00,0x00,0x00,
0x00,0x1F,0xFE,0x03,0xF0,0x00,0x00,0x00,0x00,0x3F,
0xFE,0x3F,0xFC,0x00,0x00,0x00,0x00,0x1F,0xFE,0x7F,
0xFC,0x00,0x00,0x00,0x00,0x3F,0xFC,0xFF,0xF8,0x00,
0x00,0x00,0x00,0xFF,0xF8,0xFF,0xF0,0x00,0x00,0x00,
0x01,0xFF,0xE1,0xFF,0xF0,0x00,0x00,0x00,0x03,0xFF,
0xC3,0xFF,0xE0,0x00,0x00,0x00,0x0F,0xFF,0x87,0xFF,
0xE0,0x00,0x00,0x00,0x3F,0xFE,0x07,0xFF,0xC0,0x00,
0x00,0x00,0x7F,0xFC,0x0F,0xFF,0xC0,0x00,0x00,0x01,
0xFF,0xF0,0x0F,0xFF,0xC0,0x00,0x00,0x07,0xFF,0xE0,
0x1F,0xFF,0xC0,0x00,0x00,0x1F,0xFF,0x80,0x1F,0xFF,
0xC0,0x00,0x00,0x7F,0xFF,0x00,0x3F,0xFF,0xC0,0x00,
0x03,0xFF,0xFC,0x00,0x3F,0xFF,0xE0,0x00,0x1F,0xFF,
0xF0,0x00,0x7F,0xFF,0xF8,0x01,0xFF,0xFF,0xE0,0x00,
0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x7F,0xFF,
0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x7F,0xFF,0xFF,0xFF,
0xFF,0xF8,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xE0,
0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,
0x7F,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x3F,0xFF,
0xFF,0xFF,0xF0,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFF,
0x80,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x07,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,
0x00,0x7F,0xF8,0x00,0x00,0x00,0x10,0x30,0x13,0xFD,
0x28,0x00,0x00,0x00,0x1F,0xFE,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x03,
0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,
0xFF,0xE0,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFC,
0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0x00,0x00,
0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x1F,
0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x1F,0xFF,0xFF,
0xFF,0xFF,0xFC,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,
0xFF,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,
0x00,0x0F,0xFF,0xFE,0x00,0xFF,0xFF,0xE0,0x00,0x0F,
0xFF,0xF8,0x00,0x0F,0xFF,0xF8,0x00,0x0F,0xFF,0xF0,
0x00,0x01,0xFF,0xFE,0x00,0x07,0xFF,0xF0,0x00,0x00,
0x7F,0xFF,0x00,0x07,0xFF,0xF0,0x00,0x00,0x1F,0xFF,
0x80,0x07,0xFF,0xF0,0x00,0x00,0x07,0xFF,0xE0,0x03,
0xFF,0xF0,0x00,0x00,0x01,0xFF,0xF0,0x01,0xFF,0xF0,
0x00,0x00,0x00,0xFF,0xFC,0x01,0xFF,0xF0,0x00,0x00,
0x00,0x3F,0xFE,0x00,0xFF,0xF0,0x00,0x00,0x00,0x1F,
0xFF,0x00,0xFF,0xF8,0x00,0x00,0x00,0x07,0xFF,0x88,
0x0F,0xFF,0x00,0x00,0x00,0x00,0x7F,0xFC,0x0F,0xFF,
0x00,0x00,0x00,0x00,0x1F,0xFE,0x07,0xFF,0x80,0x00,
0x00,0x00,0x0F,0xC0,0x03,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x00,0x12,0x7F,0xF8,0x00,0x00,0x00,0x00,0x00,
0x01,0x07,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x07,
0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xC0,
0x00,0x1F,0xFC,0x00,0x00,0x01,0xFF,0xE0,0x00,0xFF,
0xFF,0xE0,0x00,0x00,0xFF,0xF0,0x01,0xFF,0xFF,0xFC,
0x00,0x00,0x7F,0xF0,0x03,0xFF,0xFF,0xFF,0x80,0x00,
0x3F,0xF8,0x07,0xFF,0xFF,0xFF,0xF0,0x00,0x1F,0xFC,
0x07,0xFF,0xFF,0xFF,0xFC,0x00,0x1F,0xFE,0x0F,0xFF,
0xFF,0xFF,0xFF,0x00,0x0F,0xFF,0x0F,0xFF,0xFF,0xFF,
0xFF,0xE0,0x07,0xFF,0x8F,0xFF,0xFF,0xFF,0xFF,0xF8,
0x03,0xFF,0xCF,0xFF,0xFF,0xFF,0xFF,0xFC,0x01,0xFF,
0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0xFF,0xF7,0xFF,
0xE0,0x07,0xFF,0xFF,0xC0,0x7F,0xFF,0xFF,0x80,0x00,
0x3F,0xFF,0xF0,0x3F,0xFF,0xFF,0x00,0x00,0x07,0xFF,
0xF8,0x1F,0xFF,0xFE,0x00,0x00,0x01,0xFF,0xFE,0x0F,
0xFF,0xFE,0x00,0x00,0x00,0x3F,0xFF,0x87,0xFF,0xFE,
0x00,0x00,0x00,0x0F,0xFF,0xC3,0xFF,0xFE,0x00,0x00,
0x00,0x03,0xFF,0xF1,0xFF,0xFE,0x00,0x00,0x00,0x01,
0xFF,0xF8,0xFF,0xFE,0x00,0x00,0x00,0x00,0x7F,0xFC,
0x7F,0xFF,0x00,0x00,0x00,0x00,0x1F,0xFF,0x3F,0xFF,
0x00,0x00,0x00,0x00,0x0F,0xFF,0x9F,0xFF,0x80,0x00,
0x00,0x00,0x03,0xFF,0xCF,0xFF,0x80,0x00,0x00,0x00,
0x01,0xFF,0xE8,0xFF,0xF8,0x00,0x00,0x00,0x00,0x1F,
0xFF,0x8F,0xFF,0x00,0x00,0x00,0x00,0x00,0xFF,0xFD,
0x7F,0xF0,0x00,0x00,0x00,0x00,0x0F,0xFF,0x1F,0xFC,
0x00,0x00,0x00,0x00,0x07,0xFF,0x8F,0xFE,0x00,0x00,
0x00,0x00,0x07,0xFF,0xE0,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x7F,0xF8,0x3F,0xF8,0x00,0x00,0x00,0x00,0x3F,
0xFC,0x1F,0xFC,0x00,0x00,0x00,0x00,0x3F,0xFE,0x0F,
0xFF,0x00,0x00,0x00,0x00,0x1F,0xFE,0x03,0xFF,0x80,
0x00,0x00,0x00,0x1F,0xFF,0x01,0xFF,0xE0,0x00,0x00,
0x00,0x0F,0xFF,0x80,0xFF,0xF8,0x00,0x00,0x00,0x0F,
0xFF,0x80,0x3F,0xFE,0x00,0x00,0x00,0x0F,0xFF,0xC0,
0x1F,0xFF,0x00,0x00,0x00,0x0F,0xFF,0xC0,0x07,0xFF,
0xE0,0x00,0x00,0x0F,0xFF,0xE0,0x03,0xFF,0xF8,0x00,
0x00,0x0F,0xFF,0xE0,0x00,0xFF,0xFF,0x00,0x00,0x0F,
0xFF,0xF0,0x00,0x3F,0xFF,0xE0,0x00,0x1F,0xFF,0xF0,
0x00,0x0F,0xFF,0xFE,0x00,0xFF,0xFF,0xF0,0x00,0x07,
0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x01,0xFF,0xFF,
0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x7F,0xFF,0xFF,0xFF,
0xFF,0xF8,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xF8,
0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,
0x00,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x1F,
0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x07,0xFF,0xFF,
0xFF,0xE0,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0x80,0x00,0x00,
0x00,0x00,0x00,0x3F,0xFC,0x00,0x00,0x00,0x0F,0xAF,
0x18,0x01,0x2B,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x9F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x80,0x00,
0x00,0x00,0x00,0x00,0x3F,0xFE,0x08,0x00,0x00,0x00,
0x00,0x00,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,
0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xF0,
0x08,0x00,0x00,0x00,0x00,0x00,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x00,0x03,0xFF,0xE0,0x04,0x00,0x00,0x00,
0x00,0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x07,
0xFF,0xC0,0x02,0x00,0x00,0x00,0x00,0x03,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,
0x00,0x00,0x00,0x3F,0xFF,0x00,0x00,0x00,0x00,0x00,
0x00,0x7F,0xFC,0x00,0x04,0x00,0x00,0x00,0x00,0x3F,
0xFE,0x00,0x01,0x00,0x00,0x00,0x00,0x1F,0xFF,0x00,
0x00,0x00,0x00,0x00,0x00,0x7F,0xFC,0x00,0x00,0x80,
0x00,0x00,0x00,0x3F,0xFE,0x00,0x00,0x20,0x00,0x00,
0x00,0x1F,0xFF,0x00,0x00,0x08,0x00,0x00,0x00,0x0F,
0xFF,0x80,0x00,0x02,0x00,0x00,0x00,0x07,0xFF,0xC0,
0x00,0x00,0x80,0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x00,0x07,0xFF,0x80,0x00,0x00,0x40,0x00,
0x00,0x03,0xFF,0xE0,0x00,0x00,0x10,0x00,0x00,0x01,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,
0x00,0x00,0x00,0x1F,0xFE,0x00,0x00,0x00,0x20,0x00,
0x00,0x0F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x1F,
0xFE,0x00,0x00,0x00,0x10,0x00,0x00,0x0F,0xFF,0x80,
0x00,0x00,0x00,0x00,0x00,0x1F,0xFE,0x00,0x00,0x00,
0x00,0x00,0x00,0x7F,0xFC,0x00,0x00,0x00,0x10,0x00,
0x00,0x1F,0xFE,0x00,0x00,0x00,0x04,0x00,0x00,0x0F,
0xFF,0x80,0x00,0x00,0x01,0x00,0x00,0x03,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,
0x00,0x80,0x00,0x03,0xFF,0xC0,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0x80,0x00,0x00,0x00,0x50,0x00,0x03,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x80,
0x00,0x00,0x00,0x28,0x00,0x03,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,0x00,0x16,
0x00,0x03,0xFF,0xC0,0x00,0x00,0x00,0x04,0x00,0x01,
0xFF,0xF0,0x00,0x00,0x00,0x01,0x80,0x00,0x7F,0xF8,
0x00,0x00,0x00,0x00,0x00,0x0F,0xB0,0x1B,0xFD,0x28,
0x00,0x00,0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFF,0xFE,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,
0xFF,0x80,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xC0,
0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xE0,0x00,0x00,
0x03,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x0F,0xFF,
0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x3F,0xFF,0xFF,0xFF,
0xFF,0xF0,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,
0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x0F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x3F,0xFF,0xFC,
0x00,0xFF,0xFF,0xE0,0x00,0x7F,0xFF,0xC0,0x00,0x3F,
0xFF,0xE0,0x01,0xFF,0xFE,0x00,0x00,0x1F,0xFF,0xC0,
0x03,0xFF,0xF8,0x00,0x00,0x1F,0xFF,0xC0,0x0F,0xFF,
0xC0,0x00,0x00,0x1F,0xFF,0x80,0x1F,0xFF,0x80,0x00,
0x00,0x1F,0xFF,0x80,0x3F,0xFE,0x00,0x00,0x00,0x1F,
0xFF,0x00,0xFF,0xF8,0x00,0x00,0x00,0x1F,0xFE,0x01,
0xFF,0xF0,0x00,0x00,0x00,0x3F,0xFE,0x03,0xFF,0xC0,
0x00,0x00,0x00,0x7F,0xFC,0x68,0xFF,0xF0,0x00,0x00,
0x00,0x0F,0xFF,0x10,0x1F,0xFE,0x00,0x00,0x00,0x07,
0xFF,0x80,0x3F,0xFE,0x00,0x00,0x00,0x1F,0xFF,0x08,
0x07,0xFF,0xC0,0x00,0x00,0x0F,0xFF,0x80,0x07,0xFF,
0xC0,0x00,0x00,0x3F,0xFE,0x00,0x0F,0xFF,0xE0,0x00,
0x01,0xFF,0xFC,0x00,0x0F,0xFF,0xF0,0x00,0x0F,0xFF,
0xF0,0x00,0x0F,0xFF,0xFC,0x00,0xFF,0xFF,0xC0,0x00,
0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x0F,0xFF,
0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x07,0xFF,0xFF,0xFF,
0xFF,0xE0,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0x80,
0x00,0x00,0x01,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,
0x03,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x1F,0xFF,
0xFF,0xFF,0xF8,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,
0xFC,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,
0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x03,0xFF,0xFF,0xC0,
0x0F,0xFF,0xFE,0x00,0x07,0xFF,0xFC,0x00,0x03,0xFF,
0xFE,0x00,0x1F,0xFF,0xE0,0x00,0x01,0xFF,0xFE,0x00,
0x7F,0xFF,0x00,0x00,0x00,0xFF,0xFE,0x01,0xFF,0xFC,
0x00,0x00,0x00,0xFF,0xFC,0x03,0xFF,0xF0,0x00,0x00,
0x00,0xFF,0xFC,0x0F,0xFF,0xC0,0x00,0x00,0x00,0xFF,
0xF8,0x83,0xFF,0xE0,0x00,0x00,0x00,0x1F,0xFF,0x21,
0xFF,0xF0,0x00,0x00,0x00,0x03,0xFF,0xE3,0xFF,0xC0,
0x00,0x00,0x00,0x03,0xFF,0xCF,0xFF,0x80,0x00,0x00,
0x00,0x07,0xFF,0x9F,0xFF,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xEF,0xFF,0x80,0x00,0x00,0x00,0x01,0xFF,0xF1,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x7F,0xFB,0xFF,0xE0,
0x00,0x00,0x00,0x01,0xFF,0xF3,0xFF,0xC0,0x00,0x00,
0x00,0x03,0xFF,0xE7,0xFF,0x80,0x00,0x00,0x00,0x07,
0xFF,0xA1,0xFF,0xF0,0x00,0x00,0x00,0x03,0xFF,0xE1,
0xFF,0xE0,0x00,0x00,0x00,0x0F,0xFF,0x83,0xFF,0xE0,
0x00,0x00,0x00,0x1F,0xFF,0x07,0xFF,0xE0,0x00,0x00,
0x00,0x7F,0xFE,0x07,0xFF,0xE0,0x00,0x00,0x01,0xFF,
0xF8,0x0F,0xFF,0xE0,0x00,0x00,0x07,0xFF,0xF0,0x0F,
0xFF,0xE0,0x00,0x00,0x1F,0xFF,0xC0,0x1F,0xFF,0xF0,
0x00,0x00,0xFF,0xFF,0x80,0x1F,0xFF,0xF8,0x00,0x07,
0xFF,0xFE,0x00,0x1F,0xFF,0xFF,0x00,0x7F,0xFF,0xF8,
0x10,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x03,
0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x01,0xFF,0xFF,
0xFF,0xFF,0xFF,0x80,0x00,0x01,0xFF,0xFF,0xFF,0xFF,
0xFE,0x00,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,
0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x7F,0xFF,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,0x80,
0x00,0x00,0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,
0x0F,0xB0,0x1B,0xFD,0x28,0x00,0x00,0x01,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x03,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,
0x1F,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x7F,0xFF,
0xFF,0xFF,0x80,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,
0x80,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,
0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x03,0xFF,0xFF,0xFF,
0xFF,0xFF,0xC0,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xC0,0x00,0x3F,0xFF,0xFE,0x00,0xFF,0xFF,0xC0,0x00,
0xFF,0xFF,0xE0,0x00,0x3F,0xFF,0x80,0x01,0xFF,0xFF,
0x00,0x00,0x1F,0xFF,0x80,0x07,0xFF,0xF8,0x00,0x00,
0x1F,0xFF,0x80,0x0F,0xFF,0xE0,0x00,0x00,0x0F,0xFF,
0x00,0x3F,0xFF,0x80,0x00,0x00,0x0F,0xFF,0x00,0x7F,
0xFE,0x00,0x00,0x00,0x0F,0xFE,0x01,0xFF,0xF8,0x00,
0x00,0x00,0x1F,0xFE,0x03,0xFF,0xF0,0x00,0x00,0x00,
0x1F,0xFC,0x07,0xFF,0xC0,0x00,0x00,0x00,0x1F,0xFC,
0x43,0xFF,0xE0,0x00,0x00,0x00,0x07,0xFF,0x07,0xFF,
0xC0,0x00,0x00,0x00,0x07,0xFF,0x0F,0xFF,0x00,0x00,
0x00,0x00,0x0F,0xFE,0x3F,0xFE,0x00,0x00,0x00,0x00,
0x1F,0xFC,0x7F,0xFC,0x00,0x00,0x00,0x00,0x1F,0xF9,
0xBF,0xFE,0x00,0x00,0x00,0x00,0x07,0xFF,0x4F,0xFF,
0x80,0x00,0x00,0x00,0x01,0xFF,0xEF,0xFF,0x00,0x00,
0x00,0x00,0x07,0xFF,0xDF,0xFF,0x00,0x00,0x00,0x00,
0x0F,0xFF,0xC3,0xFF,0xC0,0x00,0x00,0x00,0x03,0xFF,
0xF0,0xFF,0xF8,0x00,0x00,0x00,0x01,0xFF,0xF8,0xFF,
0xF8,0x00,0x00,0x00,0x07,0xFF,0xF1,0xFF,0xF0,0x00,
0x00,0x00,0x1F,0xFF,0xE3,0xFF,0xF0,0x00,0x00,0x00,
0x3F,0xFF,0xC3,0xFF,0xF0,0x00,0x00,0x00,0xFF,0xFF,
0x87,0xFF,0xF0,0x00,0x00,0x03,0xFF,0xFF,0x07,0xFF,
0xF0,0x00,0x00,0x0F,0xFF,0xFE,0x0F,0xFF,0xF8,0x00,
0x00,0x7F,0xFF,0xFC,0x0F,0xFF,0xFC,0x00,0x03,0xFF,
0xFF,0xF8,0x0F,0xFF,0xFF,0x00,0x3F,0xFE,0xFF,0xF0,
0x1F,0xFF,0xFF,0xFF,0xFF,0xFD,0xFF,0xE0,0x1F,0xFF,
0xFF,0xFF,0xFF,0xF3,0xFF,0xC0,0x1F,0xFF,0xFF,0xFF,
0xFF,0xC7,0xFF,0x80,0x1F,0xFF,0xFF,0xFF,0xFF,0x0F,
0xFF,0x00,0x1F,0xFF,0xFF,0xFF,0xFC,0x1F,0xFE,0x00,
0x1F,0xFF,0xFF,0xFF,0xF0,0x3F,0xF8,0x00,0x0F,0xFF,
0xFF,0xFF,0x80,0x7F,0xF0,0x00,0x0F,0xFF,0xFF,0xFE,
0x00,0xFF,0xE0,0x00,0x07,0xFF,0xFF,0xF0,0x01,0xFF,
0xC0,0x00,0x01,0xFF,0xFF,0x00,0x07,0xFF,0x80,0x00,
0x00,0x7F,0xF0,0x00,0x0F,0xFF,0x40,0x00,0x00,0x00,
0x00,0x00,0x03,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,
0x07,0xFF,0x28,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,
0xC0,0x07,0xE0,0x00,0x00,0x00,0x0F,0xFF,0x10,0x7F,
0xF8,0x00,0x00,0x00,0x03,0xFF,0xC0,0xFF,0xF8,0x00,
0x00,0x00,0x0F,0xFF,0x00,0xFF,0xF0,0x00,0x00,0x00,
0x1F,0xFE,0x01,0xFF,0xE0,0x00,0x00,0x00,0x7F,0xFC,
0x03,0xFF,0xE0,0x00,0x00,0x00,0xFF,0xF0,0x07,0xFF,
0xC0,0x00,0x00,0x03,0xFF,0xE0,0x07,0xFF,0xC0,0x00,
0x00,0x0F,0xFF,0x80,0x0F,0xFF,0x80,0x00,0x00,0x3F,
0xFF,0x00,0x1F,0xFF,0x80,0x00,0x00,0xFF,0xFC,0x00,
0x1F,0xFF,0x80,0x00,0x03,0xFF,0xF8,0x00,0x3F,0xFF,
0x80,0x00,0x0F,0xFF,0xE0,0x00,0x3F,0xFF,0xC0,0x00,
0x7F,0xFF,0x80,0x00,0x7F,0xFF,0xF0,0x07,0xFF,0xFF,
0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,
0x7F,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x7F,0xFF,
0xFF,0xFF,0xFF,0xC0,0x00,0x00,0xFF,0xFF,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,
0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,
0x7F,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x00,0x7F,0xFF,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x0F,0xFF,0xFE,0x00,0x00,0x00,
0x00,0x00,0x01,0xFF,0xC0,0x00,0x00,0x00,0x03,0x22,
0xB0,0x00,0x97,0x7F,0xFE,0xFF,0xFF,0x40,0x03,0x40,
0x03,0x40,0x03,0x40,0x03,0x40,0x03,0x40,0x02,0x40,
0x03,0x7F,0xFE,0xFF,0xFC,0x03,0x2C,0xB3,0xB0,0x97,
0x7F,0xFE,0xFF,0xFF,0x40,0x03,0x40,0x03,0x40,0x03,
0x40,0x03,0x40,0x03,0x40,0x02,0x40,0x03,0x7F,0xFE,
0xFF,0xFE,0xC0,0xFE,0x01,0xFE,0x01,0xFA,0x03,0xF8,
0x1F,0x81,0xFC,0x1F,0xC1,0xFE,0x1F,0xE0,0x7E,0x01,
0xE0,0x0E,0x00,0x20,0x00,0x0F,0xDF,0x9C,0x41,0x38,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFC,
0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFC,0x00,0x00,
0x00,0x00,0x00,0x01,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x3F,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFC,
0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x1F,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x7F,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x03,0xFF,0xFF,
0xFF,0xC0,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFE,0x00,
0x00,0x00,0x00,0x3F,0xFF,0xFF,0xF8,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x07,0xFF,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xF8,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xC0,0x00,0x00,
0x00,0x03,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,
0xE0,0x00,0x00,0x00,0x01,0xFF,0xFF,0xFF,0x00,0x00,
0x00,0x00,0x07,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x3F,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x01,0xFF,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x01,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x01,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x00,0x01,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x00,0x01,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x01,
0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x01,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x07,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x3F,
0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,
0xFE,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x1F,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x07,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFC,
0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x00,0x01,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x00,0x00,0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,
0x1F,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFC,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x04,0x0F,0xD4,0x1C,0x6D,0x3B,0x7F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFD,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x01,0xA0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x06,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x0F,0xDF,
0x9C,0x41,0x39,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xF8,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFE,0x00,0x00,
0x00,0x00,0x00,0x00,0x01,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x00,0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,
0x01,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,
0xFF,0x80,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x01,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0xFF,
0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0xFE,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,0x80,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x1F,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x07,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFE,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0x80,0x00,0x00,
0x00,0x00,0x3F,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x07,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xFC,0x00,0x00,0x00,
0x00,0x00,0x3F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,
0x07,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,
0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFC,0x00,
0x00,0x00,0x00,0x00,0x01,0xFF,0xFC,0x00,0x00,0x00,
0x00,0x00,0x07,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
0xFC,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x3F,0xFF,0xFF,0xE0,0x00,0x00,0x00,
0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x07,0xFF,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xF0,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0x80,0x00,0x00,
0x00,0x07,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x1F,
0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,
0xC0,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0x00,0x00,
0x00,0x00,0x1F,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x03,0xFF,0xFF,
0xFF,0x80,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFE,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x01,0xFF,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0xF8,
0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x01,0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,
0x01,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x00,0x01,0xFE,0x00,0x00,0x00,0x00,
0x00,0x00,0x01,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xB0,0x18,
0x01,0x28,0x00,0x00,0x00,0xFF,0xF8,0x00,0x00,0x00,
0x00,0x00,0x3F,0xFF,0xFF,0x00,0x00,0x00,0x00,0x03,
0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0xFF,0xE0,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xF0,
0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,
0x0F,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x7F,0xFF,
0xFF,0xFF,0xFF,0xF8,0x00,0x01,0xFF,0xFF,0xFF,0xFF,
0xFF,0xF8,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,
0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x3F,
0xFF,0xFE,0x00,0xFF,0xFF,0xF8,0x00,0xFF,0xFF,0xE0,
0x00,0x3F,0xFF,0xF8,0x01,0xFF,0xFF,0x00,0x00,0x1F,
0xFF,0xF0,0x07,0xFF,0xF8,0x00,0x00,0x0F,0xFF,0xF0,
0x1F,0xFF,0xE0,0x00,0x00,0x0F,0xFF,0xE0,0x3F,0xFF,
0x80,0x00,0x00,0x0F,0xFF,0xE0,0x7F,0xFE,0x00,0x00,
0x00,0x0F,0xFF,0xC8,0x3F,0xFF,0x00,0x00,0x00,0x01,
0xFF,0xF8,0x7F,0xFC,0x00,0x00,0x00,0x01,0xFF,0xF4,
0xBF,0xFE,0x00,0x00,0x00,0x00,0x3F,0xFE,0x7F,0xF8,
0x00,0x00,0x00,0x00,0x3F,0xFE,0x3F,0xFE,0x00,0x00,
0x00,0x00,0x0F,0xFF,0x7F,0xF8,0x00,0x00,0x00,0x00,
0x1F,0xFE,0x1F,0xF0,0x00,0x00,0x00,0x00,0x3F,0xFC,
0x00,0xE0,0x00,0x00,0x00,0x00,0x7F,0xF8,0x00,0x00,
0x00,0x00,0x00,0x00,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x00,0x03,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0x80,0x00,0x00,
0x00,0x00,0x00,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,
0x00,0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x00,0x1F,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x01,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,
0x03,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x00,0x03,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,
0x00,0x00,0x03,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,
0x07,0xFF,0xE0,0x00,0x01,0x00,0x00,0x00,0x03,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x00,0x1F,0xFF,0x00,0x00,0x01,0x00,
0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,0x40,0x00,0x00,
0x03,0xFF,0xC0,0x00,0x00,0x10,0x00,0x00,0x01,0xFF,
0xF0,0x00,0x00,0x06,0x80,0x00,0x00,0x7F,0xF8,0x00,
0x00,0x00,0x00,0x00,0x00,0xFF,0xF0,0x00,0x00,0x03,
0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x34,0x00,0x00,0x03,
0xFF,0xC0,0x00,0x00,0x0B,0x00,0x00,0x00,0xFF,0xF0,
0x00,0x00,0x00,0x1E,0xFE,0x1F,0x92,0x1C,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,
0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0xFF,
0xFE,0x00,0x03,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,
0x00,0x00,0x3F,0xFF,0xFF,0xF8,0x00,0x00,0x00,0xFF,
0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,
0xF8,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0x1F,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xC0,
0x00,0x00,0x00,0x03,0xFF,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x00,0x1F,0xFF,0xFE,0x00,0x00,0x00,0x00,0x7F,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,
0xF0,0x00,0x00,0x00,0x0F,0xFF,0xFC,0x00,0x00,0x00,
0x00,0x00,0x00,0x01,0xFF,0xFF,0x00,0x00,0x00,0x01,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xF8,0x00,0x00,0x00,0x3F,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xC0,0x00,0x00,
0x03,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0xFF,0xFE,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xE0,0x00,
0x00,0x0F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x3F,0xFF,0x00,0x00,0x01,0xFF,0xFC,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xF0,
0x00,0x00,0x1F,0xFF,0x80,0x00,0x00,0x07,0xFC,0x00,
0x00,0x00,0x00,0x0F,0xFF,0x80,0x00,0x03,0xFF,0xF0,
0x00,0x00,0x07,0xFF,0xF8,0x00,0x00,0x00,0x00,0xFF,
0xFC,0x00,0x00,0x7F,0xFE,0x00,0x00,0x01,0xFF,0xFF,
0xE0,0x01,0xFF,0xE0,0x07,0xFF,0xC0,0x00,0x07,0xFF,
0xC0,0x00,0x00,0x7F,0xFF,0xFF,0x80,0x1F,0xFE,0x00,
0x3F,0xFE,0x00,0x00,0xFF,0xF8,0x00,0x00,0x1F,0xFF,
0xFF,0xFC,0x03,0xFF,0xC0,0x01,0xFF,0xE0,0x00,0x0F,
0xFF,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xF0,0x3F,0xFC,
0x00,0x1F,0xFE,0x00,0x01,0xFF,0xE0,0x00,0x00,0xFF,
0xFF,0xFF,0xFF,0x83,0xFF,0xC0,0x00,0xFF,0xF0,0x00,
0x1F,0xFE,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFC,0x3F,
0xFC,0x00,0x07,0xFF,0x00,0x03,0xFF,0xC0,0x00,0x03,
0xFF,0xFF,0xFF,0xFF,0xC3,0xFF,0xC0,0x00,0x7F,0xF8,
0x00,0x3F,0xF8,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFE,
0x7F,0xF8,0x00,0x03,0xFF,0x80,0x07,0xFF,0x80,0x00,
0x0F,0xFF,0xFF,0xFF,0xFF,0xF7,0xFF,0x80,0x00,0x3F,
0xF8,0x00,0x7F,0xF0,0x00,0x01,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xF8,0x00,0x03,0xFF,0x80,0x0F,0xFF,0x00,
0x00,0x3F,0xFF,0xFC,0x03,0xFF,0xFF,0xFF,0x80,0x00,
0x1F,0xFC,0x00,0xFF,0xE0,0x00,0x03,0xFF,0xFE,0x00,
0x07,0xFF,0xFF,0xF0,0x00,0x01,0xFF,0xC0,0x0F,0xFE,
0x00,0x00,0x7F,0xFF,0x80,0x00,0x3F,0xFF,0xFF,0x00,
0x00,0x1F,0xFC,0x01,0xFF,0xC0,0x00,0x0F,0xFF,0xF0,
0x00,0x00,0xFF,0xFF,0xF0,0x00,0x00,0xFF,0xC0,0x1F,
0xFC,0x00,0x00,0xFF,0xFE,0x00,0x00,0x07,0xFF,0xFF,
0x00,0x00,0x0F,0xFC,0x01,0xFF,0x80,0x00,0x1F,0xFF,
0xC0,0x00,0x00,0x3F,0xFF,0xE0,0x00,0x00,0xFF,0xE0,
0x3F,0xF8,0x00,0x03,0xFF,0xF8,0x00,0x00,0x03,0xFF,
0xFE,0x00,0x00,0x0F,0xFE,0x03,0xFF,0x00,0x00,0x3F,
0xFF,0x00,0x00,0x00,0x1F,0xFF,0xE0,0x00,0x00,0x7F,
0xE0,0x3F,0xF0,0x00,0x07,0xFF,0xE0,0x00,0x00,0x01,
0xFF,0xFE,0x00,0x00,0x07,0xFE,0x07,0xFF,0x00,0x00,
0x7F,0xFC,0x00,0x00,0x00,0x0F,0xFF,0xE0,0x00,0x00,
0x7F,0xE0,0x7F,0xE0,0x00,0x0F,0xFF,0xC0,0x00,0x00,
0x00,0xFF,0xFC,0x00,0x00,0x07,0xFE,0x07,0xFE,0x00,
0x00,0xFF,0xF8,0x00,0x00,0x00,0x0F,0xFF,0xC0,0x00,
0x00,0x7F,0xE0,0x7F,0xE0,0x00,0x1F,0xFF,0x80,0x00,
0x00,0x00,0x7F,0xFC,0x00,0x00,0x07,0xFE,0x0F,0xFE,
0x00,0x01,0xFF,0xF0,0x00,0x00,0x00,0x07,0xFF,0xC0,
0x00,0x00,0x7F,0xE0,0xFF,0xC0,0x00,0x1F,0xFF,0x00,
0x00,0x00,0x00,0x7F,0xF8,0x00,0x00,0x07,0xFE,0x21,
0xFF,0x80,0x00,0x7F,0xFC,0x00,0x00,0x00,0x00,0xFF,
0xF0,0x00,0x00,0x0F,0xFC,0x1F,0xF8,0x00,0x07,0xFF,
0x80,0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,0xFF,
0xC1,0xFF,0x80,0x00,0xFF,0xF8,0x00,0x00,0x00,0x00,
0xFF,0xE0,0x00,0x00,0x0F,0xFC,0x3F,0xF0,0x00,0x0F,
0xFF,0x80,0x00,0x00,0x00,0x0F,0xFE,0x00,0x00,0x01,
0xFF,0x84,0x7F,0xE0,0x00,0x1F,0xFE,0x00,0x00,0x00,
0x00,0x1F,0xFC,0x00,0x00,0x03,0xFF,0x07,0xFE,0x00,
0x03,0xFF,0xE0,0x00,0x00,0x00,0x03,0xFF,0x80,0x00,
0x00,0x3F,0xF0,0x7F,0xE0,0x00,0x3F,0xFE,0x00,0x00,
0x00,0x00,0x3F,0xF8,0x00,0x00,0x07,0xFF,0x08,0xFF,
0xC0,0x00,0x7F,0xF8,0x00,0x00,0x00,0x00,0x7F,0xF0,
0x00,0x00,0x0F,0xFC,0x0F,0xFC,0x00,0x07,0xFF,0x80,
0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x01,0xFF,0xC0,
0xFF,0xC0,0x00,0x7F,0xF8,0x00,0x00,0x00,0x00,0xFF,
0xE0,0x00,0x00,0x1F,0xF8,0x0F,0xFC,0x00,0x07,0xFF,
0x80,0x00,0x00,0x00,0x0F,0xFE,0x00,0x00,0x03,0xFF,
0x80,0xFF,0xC0,0x00,0x7F,0xF8,0x00,0x00,0x00,0x01,
0xFF,0xE0,0x00,0x00,0x3F,0xF8,0x0F,0xFC,0x00,0x07,
0xFF,0x80,0x00,0x00,0x00,0x1F,0xFE,0x00,0x00,0x07,
0xFF,0x00,0xFF,0xC0,0x00,0x7F,0xF8,0x00,0x00,0x00,
0x03,0xFF,0xC0,0x00,0x00,0x7F,0xF0,0x0F,0xFC,0x00,
0x07,0xFF,0x80,0x00,0x00,0x00,0x3F,0xFC,0x00,0x00,
0x0F,0xFE,0x00,0xFF,0xC0,0x00,0x7F,0xF8,0x00,0x00,
0x00,0x07,0xFF,0xC0,0x00,0x00,0xFF,0xE0,0x0F,0xFC,
0x00,0x07,0xFF,0xC0,0x00,0x00,0x00,0x7F,0xFC,0x00,
0x00,0x1F,0xFC,0x00,0xFF,0xE0,0x00,0x3F,0xFC,0x00,
0x00,0x00,0x0F,0xFF,0x80,0x00,0x03,0xFF,0xC0,0x07,
0xFE,0x00,0x03,0xFF,0xC0,0x00,0x00,0x01,0xFF,0xF8,
0x00,0x00,0x7F,0xF8,0x00,0x7F,0xE0,0x00,0x3F,0xFC,
0x00,0x00,0x00,0x3F,0xFF,0x80,0x00,0x0F,0xFF,0x80,
0x07,0xFE,0x00,0x03,0xFF,0xE0,0x00,0x00,0x03,0xFF,
0xF8,0x00,0x00,0xFF,0xF0,0x00,0x7F,0xE0,0x00,0x3F,
0xFF,0x00,0x00,0x00,0x7F,0xFF,0x80,0x00,0x3F,0xFE,
0x00,0x07,0xFF,0x00,0x01,0xFF,0xF0,0x00,0x00,0x1F,
0xFF,0xF0,0x00,0x07,0xFF,0xC0,0x00,0x7F,0xF0,0x00,
0x1F,0xFF,0x80,0x00,0x03,0xFF,0xFF,0x00,0x00,0xFF,
0xFC,0x00,0x03,0xFF,0x00,0x00,0xFF,0xFC,0x00,0x00,
0x7F,0xFF,0xF0,0x00,0x1F,0xFF,0x80,0x00,0x3F,0xF0,
0x00,0x0F,0xFF,0xE0,0x00,0x1F,0xFF,0xFF,0x00,0x07,
0xFF,0xF0,0x00,0x03,0xFF,0x80,0x00,0xFF,0xFF,0x80,
0x07,0xFF,0xFF,0xF0,0x00,0xFF,0xFE,0x00,0x00,0x3F,
0xF8,0x00,0x07,0xFF,0xFE,0x03,0xFF,0xFF,0xFF,0x80,
0x3F,0xFF,0xC0,0x00,0x01,0xFF,0xC0,0x00,0x7F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFC,0x1F,0xFF,0xF8,0x00,0x00,
0x1F,0xFC,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0x00,0x00,0x01,0xFF,0xC0,0x00,0x1F,
0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,
0x00,0x0F,0xFE,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xCF,
0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,0xFF,0xE0,0x00,
0x0F,0xFF,0xFF,0xFF,0xF8,0xFF,0xFF,0xFF,0xFF,0x80,
0x00,0x00,0x0F,0xFF,0x00,0x00,0x7F,0xFF,0xFF,0xFF,
0x07,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x7F,0xF8,
0x00,0x03,0xFF,0xFF,0xFF,0xE0,0x7F,0xFF,0xFF,0xFC,
0x00,0x00,0x00,0x07,0xFF,0x80,0x00,0x1F,0xFF,0xFF,
0xF8,0x03,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x00,0x3F,
0xFC,0x00,0x00,0x7F,0xFF,0xFF,0x00,0x3F,0xFF,0xFF,
0xE0,0x00,0x00,0x00,0x03,0xFF,0xE0,0x00,0x01,0xFF,
0xFF,0xC0,0x01,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x3F,0xFF,0x00,0x00,0x07,0xFF,0xF0,0x00,0x07,0xFF,
0xFC,0x00,0x00,0x1F,0xFE,0x01,0xFF,0xF0,0x00,0x00,
0x0F,0xF8,0x00,0x00,0x0F,0xFC,0x00,0x00,0x03,0xFF,
0xC0,0x0F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x7F,0xFC,0x00,0xFF,0xFC,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,
0xFF,0x80,0x07,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x01,0xFF,0xF0,0x00,0x3F,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFF,0x00,0x03,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xE0,0x00,0x1F,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0xFF,0xFC,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x80,0x00,
0x07,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xF0,0x00,0x00,0x7F,0xFF,0xF0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0x00,
0x00,0x03,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0xFF,0xE0,0x00,0x00,0x1F,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFC,
0x00,0x00,0x00,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xFF,0x00,0x00,0x00,0x07,0xFF,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,
0xE0,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x03,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x03,0xFF,0xFF,
0xFF,0x80,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,
0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,
0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0xF0,0x00,
0x00,0x00,0x00,0x00,0x00,0x16,0xEF,0xF8,0x01,0x64,
0x00,0x00,0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x24,0x00,0x00,0x00,0x00,0x0F,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x3F,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x90,0x00,0x00,0x00,0x00,
0xFF,0xFF,0xE0,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
0x00,0x03,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x02,0x00,
0x00,0x00,0x00,0x0F,0xFE,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x01,0xFF,0xEF,0xFE,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFE,0x7F,0xF0,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xC7,
0xFF,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x07,
0xFF,0x87,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0xF0,0x7F,0xF8,0x00,0x00,0x00,0x08,0x00,
0x00,0x00,0x01,0xFF,0xE0,0x7F,0xF0,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3F,0xFC,0x07,0xFF,0x80,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xC0,0x3F,0xF8,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFC,0x03,
0xFF,0xC0,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0xFF,
0xF0,0x03,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
0x1F,0xFF,0x00,0x3F,0xFC,0x00,0x00,0x00,0x00,0x00,
0x00,0x01,0xFF,0xE0,0x01,0xFF,0xC0,0x00,0x00,0x02,
0x00,0x00,0x00,0x07,0xFF,0xC0,0x03,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x00,0x00,0x7F,0xF8,0x00,0x1F,0xFC,
0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x80,0x01,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xF0,
0x00,0x0F,0xFE,0x00,0x00,0x00,0x40,0x00,0x00,0x03,
0xFF,0xE0,0x00,0x1F,0xFE,0x00,0x00,0x00,0x00,0x00,
0x00,0x3F,0xFC,0x00,0x00,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0x07,0xFF,0xC0,0x00,0x0F,0xFF,0x00,0x00,
0x00,0x00,0x00,0x00,0x7F,0xF8,0x00,0x00,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x80,0x00,0x07,
0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0xFF,0xF0,0x00,
0x00,0x7F,0xF8,0x00,0x00,0x08,0x00,0x00,0x03,0xFF,
0xE0,0x00,0x00,0x7F,0xF8,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFC,0x00,0x00,0x07,0xFF,0x80,0x00,0x00,0x00,
0x00,0x07,0xFF,0xC0,0x00,0x00,0x3F,0xFC,0x00,0x00,
0x00,0x00,0x00,0x7F,0xF8,0x00,0x00,0x03,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,0x3F,
0xFE,0x00,0x00,0x00,0x00,0x00,0xFF,0xF8,0x00,0x00,
0x01,0xFF,0xE0,0x00,0x00,0x00,0x00,0x0F,0xFF,0x00,
0x00,0x00,0x1F,0xFE,0x00,0x00,0x00,0x00,0x01,0xFF,
0xF0,0x00,0x00,0x00,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x1F,0xFE,0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,
0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,0xFF,0xF8,0x00,
0x01,0x00,0x00,0x07,0xFF,0x80,0x00,0x00,0x00,0xFF,
0xF0,0x00,0x00,0x00,0x00,0xFF,0xF8,0x00,0x00,0x00,
0x0F,0xFF,0x80,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xF8,0x00,0x02,0x40,0x00,0x3F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x04,0x00,0x00,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x08,
0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,
0x00,0x12,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xF8,0x00,0x20,0x00,0x3F,0xFE,0x00,0x00,0x00,
0x00,0x00,0xFF,0xF8,0x00,0x48,0x00,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0xFF,0xF8,0x00,0x80,0x03,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x00,0xFF,0xF8,0x01,0x20,
0x0F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0xFF,0xF8,
0x02,0x00,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0xF8,0x00,0x07,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xC0,0x40,0x0F,0xFF,0x80,0x00,0x00,
0x00,0x00,0x00,0x0F,0xFF,0x80,0x80,0x3F,0xFE,0x00,
0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x80,0x07,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFC,0x00,
0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,
0xC1,0x01,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFF,0xC0,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x7F,0xFC,0x03,0xFF,0xF0,0x00,0x00,0x00,
0x00,0x00,0x00,0x07,0xFF,0xE0,0x3F,0xFE,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3F,0xFE,0x20,0xFF,0xFC,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFE,0x0F,
0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,
0xE4,0x3F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x07,0xFF,0xE7,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x3F,0xFF,0x12,0x2F,0xAC,0x01,0x65,0xFF,
0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x7F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x3F,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0x80,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xF0,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFC,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x80,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xE0,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,
0x01,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,
0x0F,0xFF,0x80,0x00,0x00,0x03,0xFF,0xFF,0xF0,0x07,
0xFF,0xC0,0x00,0x00,0x00,0x0F,0xFF,0xFC,0x03,0xFF,
0xE0,0x00,0x00,0x00,0x01,0xFF,0xFE,0x01,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x7F,0xFF,0x80,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x1F,0xFF,0xC0,0x7F,0xFC,0x00,0x00,
0x00,0x00,0x07,0xFF,0xF0,0x47,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x3F,0xFF,0x03,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x0F,0xFF,0x82,0x3F,0xFE,0x00,0x00,0x00,0x00,
0x00,0xFF,0xFC,0x37,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x07,0xFF,0xC1,0xFF,0xF0,0x00,0x00,0x00,0x00,0x03,
0xFF,0xC1,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,0x7F,
0xFC,0x0F,0xFF,0x80,0x00,0x00,0x00,0x00,0x3F,0xFC,
0x07,0xFF,0xC0,0x00,0x00,0x00,0x00,0x3F,0xFE,0x03,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x3F,0xFE,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x3F,0xFE,0x00,0xFF,0xF8,
0x00,0x00,0x00,0x00,0x3F,0xFF,0x00,0x7F,0xFC,0x00,
0x00,0x00,0x00,0x3F,0xFF,0x00,0x3F,0xFE,0x00,0x00,
0x00,0x00,0x7F,0xFF,0x00,0x1F,0xFF,0x00,0x00,0x00,
0x07,0xFF,0xFF,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFE,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,
0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,
0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,
0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x3F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x1F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x0F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x07,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF8,0x03,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFE,0x01,0xFF,0xF0,0x00,0x00,0x00,
0x1F,0xFF,0xFF,0x80,0xFF,0xF8,0x00,0x00,0x00,0x00,
0xFF,0xFF,0xE0,0x7F,0xFC,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xF8,0x3F,0xFE,0x00,0x00,0x00,0x00,0x01,0xFF,
0xFE,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,
0x0F,0xFF,0x80,0x00,0x00,0x00,0x00,0x1F,0xFF,0xC8,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0xFF,0xFC,0x7F,
0xFC,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x47,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x01,0xFF,0xF3,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x7F,0xFE,0x00,
0x00,0x00,0x00,0x00,0x07,0xFF,0xE3,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x00,0x7F,0xFD,0xFF,0xF0,0x00,0x00,
0x00,0x00,0x00,0x7F,0xFF,0x1F,0xFF,0x00,0x00,0x00,
0x00,0x00,0x07,0xFF,0xD1,0xFF,0xF0,0x00,0x00,0x00,
0x00,0x00,0xFF,0xFC,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x00,0xFF,0xFC,0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,
0xFF,0xFE,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFE,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
0x0F,0xFF,0x80,0x00,0x00,0x00,0x01,0xFF,0xFF,0x07,
0xFF,0xC0,0x00,0x00,0x00,0x03,0xFF,0xFF,0x83,0xFF,
0xE0,0x00,0x00,0x00,0x1F,0xFF,0xFF,0x81,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x81,0x1F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x0F,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF0,0x07,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xE0,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xE0,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xC0,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x80,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,
0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,
0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x15,0x30,0x9B,0xFD,0x80,0x00,0x00,0x00,0x00,0x07,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x03,
0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,
0x1F,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,
0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x00,
0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,
0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x80,0x00,0x00,0x0F,0xFF,0xFF,0xF0,0x00,0xFF,0xFF,
0xFE,0x00,0x00,0x00,0xFF,0xFF,0xF8,0x00,0x00,0x7F,
0xFF,0xF8,0x00,0x00,0x0F,0xFF,0xFE,0x00,0x00,0x00,
0xFF,0xFF,0xE0,0x00,0x00,0xFF,0xFF,0xC0,0x00,0x00,
0x01,0xFF,0xFF,0x80,0x00,0x0F,0xFF,0xF8,0x00,0x00,
0x00,0x07,0xFF,0xFC,0x00,0x00,0xFF,0xFF,0x80,0x00,
0x00,0x00,0x0F,0xFF,0xF0,0x00,0x0F,0xFF,0xF0,0x00,
0x00,0x00,0x00,0x3F,0xFF,0xC0,0x00,0x7F,0xFF,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFE,0x00,0x07,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x07,0xFF,0xF8,0x00,0x3F,0xFF,
0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xC0,0x03,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,0x3F,
0xFF,0x80,0x00,0x00,0x00,0x00,0x01,0xFF,0xF8,0x01,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xE0,
0x0F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,
0x00,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,
0xF8,0x07,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x07,
0xFF,0xE0,0x7F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFF,0x03,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,
0x01,0xFF,0x80,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,
0x00,0x07,0x80,0x01,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x49,0xFF,0xF0,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x02,0x9F,0xFF,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1B,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1B,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x11,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x18,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
0x10,0x00,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xF8,0x00,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFC,0x07,0xFF,0xC0,0x00,0x00,0x00,0x00,
0x00,0x00,0x7F,0xFE,0x1F,0xFF,0x00,0x00,0x00,0x00,
0x00,0x00,0x03,0xFF,0xF0,0xFF,0xF8,0x00,0x00,0x00,
0x00,0x00,0x00,0x1F,0xFF,0x07,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x00,0x01,0xFF,0xF8,0x1F,0xFF,0x00,0x00,
0x00,0x00,0x00,0x00,0x0F,0xFF,0xC0,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0x00,0xFF,0xFC,0x07,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xE0,0x1F,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,0xFF,
0xFC,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xF0,0x03,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x80,
0x1F,0xFF,0x80,0x00,0x00,0x00,0x00,0x03,0xFF,0xF8,
0x00,0x7F,0xFE,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,
0xC0,0x03,0xFF,0xF8,0x00,0x00,0x00,0x00,0x01,0xFF,
0xFC,0x00,0x0F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x1F,
0xFF,0xE0,0x00,0x7F,0xFF,0x80,0x00,0x00,0x00,0x01,
0xFF,0xFE,0x00,0x01,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x1F,0xFF,0xF0,0x00,0x07,0xFF,0xFC,0x00,0x00,0x00,
0x03,0xFF,0xFF,0x00,0x00,0x1F,0xFF,0xF8,0x00,0x00,
0x00,0x3F,0xFF,0xF0,0x00,0x00,0xFF,0xFF,0xF0,0x00,
0x00,0x07,0xFF,0xFF,0x00,0x00,0x03,0xFF,0xFF,0xF0,
0x00,0x01,0xFF,0xFF,0xF0,0x00,0x00,0x0F,0xFF,0xFF,
0xF8,0x00,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x3F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x03,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,
0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,
0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,
0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x00,
0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x13,0xEF,0xAC,0x01,0x81,0xFF,
0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x01,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x01,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x01,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x01,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x01,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x01,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x01,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x01,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x01,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x01,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xC0,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x01,0xFF,0xFF,0xE0,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x7F,0xFF,0xF0,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x1F,0xFF,0xF8,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x07,0xFF,0xFC,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x03,0xFF,0xFC,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x01,0xFF,0xFE,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0xFF,0xFE,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x82,0x3F,
0xFE,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xF0,0x3F,
0xFE,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xF8,0x3F,
0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xF8,0x3F,
0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFC,0x47,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x87,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xC9,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xF8,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFD,
0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,
0xB7,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFE,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,
0xFF,0xAF,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x03,
0xFF,0xF9,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0xFA,0x7F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFE,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,
0x7F,0xFE,0x47,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFF,0x87,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,
0x1F,0xFF,0x87,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,
0x1F,0xFF,0x08,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x07,0xFF,0xE1,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,
0x01,0xFF,0xF8,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,
0x03,0xFF,0xF0,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,
0x07,0xFF,0xF0,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFF,0xE0,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,
0x1F,0xFF,0xE0,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFF,0xC0,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,
0x7F,0xFF,0x80,0x1F,0xFF,0x00,0x00,0x00,0x00,0x01,
0xFF,0xFF,0x80,0x1F,0xFF,0x00,0x00,0x00,0x00,0x07,
0xFF,0xFF,0x00,0x1F,0xFF,0x00,0x00,0x00,0x00,0x3F,
0xFF,0xFE,0x00,0x1F,0xFF,0x00,0x00,0x00,0x07,0xFF,
0xFF,0xFC,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xF8,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xF0,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xE0,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xC0,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFE,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF8,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xE0,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,
0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,
0x00,0x00,0x00,0x00,0x11,0xEF,0xAC,0x01,0x67,0x7F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x57,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCD,0xFF,0xF8,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xBF,0xFF,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x37,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x00,0x00,0x06,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x7F,0xFC,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xF8,0x15,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x03,0x7F,0xFE,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x6F,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,
0x00,0x0D,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0xBF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x2F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x06,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x10,
0x2F,0xAC,0x01,0x47,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xEB,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x7F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x37,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x03,0x7F,0xFE,
0x00,0x00,0x00,0x00,0x00,0x00,0x37,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x00,0x02,0x3F,0xFE,0x00,0x00,0x00,
0x00,0x00,0x00,0x37,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFC,0x02,0xBF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,
0x37,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x03,0x7F,
0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x37,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x00,0x03,0x7F,0xFE,0x00,0x00,
0x00,0x00,0x00,0x00,0x37,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0x03,0x7F,0xFE,0x00,0x00,0x00,0x00,0x00,
0x00,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x16,0x70,0x9B,0xFD,0x9C,0x00,0x00,0x00,0x00,0x01,
0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x1F,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3F,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x80,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x3F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x1F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,
0x0F,0xFF,0xFF,0xFC,0x00,0x1F,0xFF,0xFF,0xF0,0x00,
0x00,0x07,0xFF,0xFF,0xE0,0x00,0x00,0x7F,0xFF,0xFE,
0x00,0x00,0x03,0xFF,0xFF,0xC0,0x00,0x00,0x03,0xFF,
0xFF,0xC0,0x00,0x01,0xFF,0xFF,0xC0,0x00,0x00,0x00,
0x3F,0xFF,0xF8,0x00,0x00,0xFF,0xFF,0xC0,0x00,0x00,
0x00,0x03,0xFF,0xFE,0x00,0x00,0x7F,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x3F,0xFF,0xC0,0x00,0x3F,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x07,0xFF,0xF0,0x00,0x0F,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0xFF,0xFE,0x00,0x07,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0x80,
0x03,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,
0xF0,0x00,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0xFC,0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,
0x00,0x1F,0xFF,0x80,0x1F,0xFF,0x80,0x00,0x00,0x00,
0x00,0x00,0x07,0xFF,0xE0,0x0F,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x00,0x00,0xFF,0xF8,0x03,0xFF,0xF0,0x00,
0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x20,0x3F,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xF8,0x0F,
0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFE,
0x07,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x07,
0xF8,0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0xE0,0x00,0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3F,0xFF,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x41,0xFF,0xF0,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFC,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xB7,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x37,0xFF,0xE0,0x00,0x00,0x00,0x01,0xFF,0xFF,
0xFF,0xFF,0xFF,0x1F,0xFF,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xFF,0xFF,0xFF,0xF8,0x7F,0xFC,0x00,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xCB,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFE,0x4F,0xFF,
0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xE3,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFC,0x0F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
0x07,0xFF,0xC3,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,
0x00,0x01,0xFF,0xF0,0x7F,0xFC,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x7F,0xFC,0x1F,0xFF,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x1F,0xFF,0x80,0x7F,0xFE,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xF8,0x0F,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFE,0x03,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,
0x80,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x03,
0xFF,0xE0,0x1F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0xF8,0x03,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x00,0x00,0x7F,0xFE,0x00,0x7F,0xFF,0x80,0x00,0x00,
0x00,0x00,0x00,0x7F,0xFF,0x80,0x1F,0xFF,0xF0,0x00,
0x00,0x00,0x00,0x00,0x7F,0xFF,0xE0,0x03,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xF8,0x00,0x7F,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFE,0x00,
0x0F,0xFF,0xFE,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,
0x80,0x01,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x7F,0xFF,
0xFF,0xC0,0x00,0x3F,0xFF,0xFF,0x80,0x00,0x01,0xFF,
0xFF,0xFF,0xC0,0x00,0x07,0xFF,0xFF,0xFF,0x00,0x07,
0xFF,0xFF,0xFF,0xE0,0x00,0x00,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x0F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x01,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,
0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,
0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,
0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFF,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x07,
0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x07,0xFF,0xF8,0x00,0x00,0x00,0x00,0x12,0xAF,
0xAC,0x01,0x83,0x7F,0xFE,0x00,0x00,0x00,0x00,0x00,
0x01,0xFF,0xFD,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x07,0xFF,0xF7,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,
0x1F,0xFF,0xDF,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,
0x7F,0xFF,0x7F,0xFE,0x00,0x00,0x00,0x00,0x00,0x01,
0xFF,0xFA,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x07,
0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xAF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x7F,0xFE,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,
0xFD,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,
0xF7,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,
0xDF,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,
0x7F,0xFE,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xFD,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xE7,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0x03,
0x6F,0xB0,0x00,0x97,0x7F,0xFF,0xBF,0xFF,0xDF,0xFF,
0xEF,0xFF,0xF7,0xFF,0xFB,0xFF,0xFD,0xFF,0xFE,0xFF,
0xFF,0x7F,0xFF,0xBF,0xFF,0xDF,0xFF,0xEF,0xFF,0xF7,
0xFF,0xF5,0xFF,0xF0,0x0D,0x30,0x13,0xFD,0x0F,0x40,
0x00,0x00,0x00,0x00,0x7F,0xFF,0x40,0x00,0x00,0x00,
0x00,0x7F,0xFF,0x40,0x00,0x00,0x00,0x00,0x7F,0xFF,
0x40,0x00,0x00,0x00,0x00,0x7F,0xFF,0x40,0x00,0x00,
0x00,0x00,0x7F,0xFF,0x40,0x00,0x00,0x00,0x00,0x7F,
0xFF,0x40,0x00,0x00,0x00,0x00,0x7F,0xFF,0x40,0x00,
0x00,0x00,0x00,0x7F,0xFF,0x40,0x00,0x00,0x00,0x00,
0x7F,0xFE,0x40,0x00,0x00,0x00,0x00,0x7F,0xFC,0x00,
0xF0,0x00,0x00,0x03,0xFF,0xF7,0xFF,0xF0,0x00,0x00,
0x03,0xFF,0xEF,0xFF,0xC0,0x00,0x00,0x1F,0xFF,0x7F,
0xFE,0x00,0x00,0x00,0xFF,0xF4,0x7F,0xFE,0x00,0x00,
0x01,0xFF,0xF1,0xFF,0xF0,0x00,0x00,0x0F,0xFF,0x8F,
0xFF,0xC0,0x00,0x00,0x7F,0xFC,0x7F,0xFE,0x00,0x00,
0x07,0xFF,0xE3,0xFF,0xF8,0x00,0x00,0x3F,0xFE,0x0F,
0xFF,0xC0,0x00,0x03,0xFF,0xF0,0x7F,0xFF,0x00,0x00,
0x3F,0xFF,0x83,0xFF,0xFC,0x00,0x03,0xFF,0xF8,0x0F,
0xFF,0xF8,0x00,0x7F,0xFF,0xC0,0x7F,0xFF,0xF0,0x0F,
0xFF,0xFC,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x0F,
0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x3F,0xFF,0xFF,0xFF,
0xFF,0xE0,0x00,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x03,
0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x0F,0xFF,0xFF,0xFF,
0xFE,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xE0,0x00,0x00,
0x7F,0xFF,0xFF,0xFC,0x00,0x00,0x00,0xFF,0xFF,0xFF,
0x80,0x00,0x00,0x01,0xFF,0xFF,0xF0,0x00,0x00,0x00,
0x00,0xFF,0xF0,0x00,0x00,0x00,0x13,0xEF,0xAC,0x01,
0x65,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,
0xE1,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
0xC1,0xFF,0xF0,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,
0x81,0xFF,0xF0,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x07,0xFF,0xFE,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFC,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x1F,0xFF,0xF8,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x3F,0xFF,0xF0,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x7F,0xFF,0xE0,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0xFF,0xFF,0xC0,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x01,0xFF,0xFF,0x80,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x03,0xFF,0xFF,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x07,0xFF,0xFE,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x0F,0xFF,0xFC,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x1F,0xFF,0xF8,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x3F,0xFF,0xF0,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x7F,0xFF,0xE0,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0xFF,0xFF,0xC0,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x01,0xFF,0xFF,0x80,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x03,0xFF,0xFF,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x07,0xFF,0xFE,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x0F,0xFF,0xFC,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x1F,0xFF,0xF8,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x3F,0xFF,0xF0,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x7F,0xFF,0xE0,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x00,0xFF,0xFF,0xC0,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x01,0xFF,0xFF,0x80,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x03,0xFF,0xFF,0x00,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x07,0xFF,0xFE,0x00,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x0F,0xFF,0xFC,0x00,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x1F,0xFF,0xF8,0x00,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x3F,0xFF,0xF0,0x00,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x7F,0xFF,0xC0,0x00,0x00,0x00,
0x01,0xFF,0xF0,0x00,0xFF,0xFF,0x80,0x00,0x00,0x00,
0x01,0xFF,0xF0,0x01,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x01,0xFF,0xF0,0x03,0xFF,0xFE,0x00,0x00,0x00,0x00,
0x01,0xFF,0xF0,0x07,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x01,0xFF,0xF0,0x0F,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x01,0xFF,0xF0,0x1F,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x01,0xFF,0xF0,0x3F,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x01,0xFF,0xF0,0x7F,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x01,0xFF,0xF0,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x01,0xFF,0xF1,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x01,0xFF,0xF3,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,
0x01,0xFF,0xF7,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xFF,0xCF,0xFF,0xC0,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xFF,0x8F,0xFF,0xE0,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xFF,0x07,0xFF,0xF0,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xFE,0x03,0xFF,0xF8,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xFC,0x01,0xFF,0xFC,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xF8,0x01,0xFF,0xFC,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xF0,0x00,0xFF,0xFE,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xE0,0x00,0x7F,0xFF,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xC0,0x00,0x3F,0xFF,0x80,0x00,0x00,
0x01,0xFF,0xFF,0x80,0x00,0x3F,0xFF,0x80,0x00,0x00,
0x01,0xFF,0xFF,0x00,0x00,0x1F,0xFF,0xC0,0x00,0x00,
0x01,0xFF,0xFE,0x00,0x00,0x0F,0xFF,0xE0,0x00,0x00,
0x01,0xFF,0xFC,0x00,0x00,0x0F,0xFF,0xF0,0x00,0x00,
0x01,0xFF,0xF8,0x00,0x00,0x07,0xFF,0xF0,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x03,0xFF,0xF8,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x01,0xFF,0xFC,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x01,0xFF,0xFE,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0xFF,0xFE,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x3F,0xFF,0x80,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x3F,0xFF,0xC0,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x1F,0xFF,0xE0,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x0F,0xFF,0xE0,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x07,0xFF,0xF0,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x07,0xFF,0xF8,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x03,0xFF,0xFC,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x01,0xFF,0xFC,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0xFF,0xFE,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x7F,0xFF,0x80,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x3F,0xFF,0x80,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x3F,0xFF,0xC0,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x1F,0xFF,0xE0,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xF0,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x07,0xFF,0xF0,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x07,0xFF,0xF8,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x03,0xFF,0xFC,
0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x01,0xFF,0xFE,
0x02,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,
0xE0,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,
0xF0,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,
0xF8,0x47,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x7F,
0xFF,0x87,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x3F,
0xFF,0xC7,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x1F,
0xFF,0xE7,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xF0,0x0E,0xEF,0xAC,0x01,0x2B,0x7F,0xFE,0x00,
0x00,0x00,0x00,0x00,0x06,0xFF,0xFC,0x00,0x00,0x00,
0x00,0x00,0x0D,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x1B,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x37,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x00,0x6F,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x00,0xDF,0xFF,0x80,0x00,0x00,0x00,
0x00,0x01,0xBF,0xFF,0x00,0x00,0x00,0x00,0x00,0x03,
0x7F,0xFE,0x00,0x00,0x00,0x00,0x00,0x06,0xFF,0xFC,
0x00,0x00,0x00,0x00,0x00,0x0D,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x00,0x1B,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x00,0x37,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD7,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x16,0xEF,0xA4,
0x01,0xB6,0x3F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,
0x00,0x7F,0xFF,0xFC,0xFF,0xFF,0xFC,0x00,0x00,0x00,
0x00,0x00,0x01,0xFF,0xFF,0xF9,0xFF,0xFF,0xFC,0x00,
0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xF3,0xFF,0xFF,
0xFC,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xDF,
0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,
0xFE,0x3F,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x07,
0xFF,0xFF,0xFB,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xBF,0xFF,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xFF,0xFC,0x7F,0xFD,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x1F,0xFD,0xFF,0xF7,0xFF,0xDF,
0xFE,0x00,0x00,0x00,0x00,0x03,0xFF,0xDF,0xFF,0x8F,
0xFF,0x9F,0xFC,0x00,0x00,0x00,0x00,0x07,0xFF,0x3F,
0xFE,0xFF,0xF9,0xFF,0xE0,0x00,0x00,0x00,0x00,0xFF,
0xF3,0xFF,0xF1,0xFF,0xF1,0xFF,0xC0,0x00,0x00,0x00,
0x01,0xFF,0xC7,0xFF,0xDF,0xFF,0x1F,0xFE,0x00,0x00,
0x00,0x00,0x3F,0xFC,0x7F,0xFE,0x3F,0xFE,0x1F,0xFC,
0x00,0x00,0x00,0x00,0x7F,0xF0,0xFF,0xFB,0xFF,0xE1,
0xFF,0xE0,0x00,0x00,0x00,0x0F,0xFF,0x0F,0xFF,0xC7,
0xFF,0xC1,0xFF,0xC0,0x00,0x00,0x00,0x1F,0xFC,0x1F,
0xFF,0x7F,0xFC,0x1F,0xFE,0x00,0x00,0x00,0x03,0xFF,
0xC1,0xFF,0xF7,0xFF,0xC1,0xFF,0xE0,0x00,0x00,0x00,
0x3F,0xF8,0x1F,0xFF,0x7F,0xFC,0x0F,0xFE,0x00,0x00,
0x00,0x03,0xFF,0x81,0xFF,0xF7,0xFF,0xC0,0xFF,0xF0,
0x00,0x00,0x00,0x3F,0xF8,0x1F,0xFF,0x7F,0xFC,0x0F,
0xFF,0x00,0x00,0x00,0x07,0xFF,0x81,0xFF,0xF8,0xFF,
0xF8,0x0F,0xFE,0x00,0x00,0x00,0x0F,0xFE,0x03,0xFF,
0xEF,0xFF,0x80,0xFF,0xF0,0x00,0x00,0x01,0xFF,0xE0,
0x3F,0xFF,0x1F,0xFF,0x00,0xFF,0xE0,0x00,0x00,0x03,
0xFF,0x80,0x7F,0xFD,0xFF,0xF0,0x0F,0xFF,0x00,0x00,
0x00,0x7F,0xF8,0x07,0xFF,0xE3,0xFF,0xE0,0x0F,0xFE,
0x00,0x00,0x00,0xFF,0xE0,0x0F,0xFF,0xBF,0xFE,0x00,
0xFF,0xF0,0x00,0x00,0x1F,0xFE,0x00,0xFF,0xFC,0x7F,
0xFC,0x00,0xFF,0xE0,0x00,0x00,0x3F,0xF8,0x01,0xFF,
0xF7,0xFF,0xC0,0x0F,0xFF,0x00,0x00,0x07,0xFF,0x80,
0x1F,0xFF,0x8F,0xFF,0x80,0x0F,0xFE,0x00,0x00,0x0F,
0xFE,0x00,0x3F,0xFE,0xFF,0xF8,0x00,0xFF,0xF0,0x00,
0x01,0xFF,0xE0,0x03,0xFF,0xEF,0xFF,0x80,0x0F,0xFF,
0x00,0x00,0x1F,0xFC,0x00,0x3F,0xFE,0xFF,0xF8,0x00,
0x7F,0xF0,0x00,0x01,0xFF,0xC0,0x03,0xFF,0xEF,0xFF,
0x80,0x07,0xFF,0x80,0x00,0x1F,0xFC,0x00,0x3F,0xFE,
0xFF,0xF8,0x00,0x7F,0xF8,0x00,0x03,0xFF,0xC0,0x03,
0xFF,0xF1,0xFF,0xF0,0x00,0x7F,0xF0,0x00,0x07,0xFF,
0x00,0x07,0xFF,0xDF,0xFF,0x00,0x07,0xFF,0x80,0x00,
0xFF,0xF0,0x00,0x7F,0xFE,0x3F,0xFE,0x00,0x07,0xFF,
0x00,0x01,0xFF,0xC0,0x00,0xFF,0xFB,0xFF,0xE0,0x00,
0x7F,0xF8,0x00,0x3F,0xFC,0x00,0x0F,0xFF,0xC7,0xFF,
0xC0,0x00,0x7F,0xF0,0x00,0x7F,0xF0,0x00,0x1F,0xFF,
0x7F,0xFC,0x00,0x07,0xFF,0x80,0x0F,0xFF,0x00,0x01,
0xFF,0xF8,0xFF,0xF8,0x00,0x07,0xFF,0x00,0x1F,0xFC,
0x00,0x03,0xFF,0xEF,0xFF,0x80,0x00,0x7F,0xF8,0x03,
0xFF,0xC0,0x00,0x3F,0xFE,0xFF,0xF8,0x00,0x07,0xFF,
0x80,0x3F,0xF8,0x00,0x03,0xFF,0xEF,0xFF,0x80,0x00,
0x3F,0xF8,0x03,0xFF,0x80,0x00,0x3F,0xFE,0xFF,0xF8,
0x00,0x03,0xFF,0xC0,0x7F,0xF8,0x00,0x03,0xFF,0xEF,
0xFF,0x80,0x00,0x3F,0xFC,0x07,0xFF,0x00,0x00,0x3F,
0xFE,0xFF,0xF8,0x00,0x01,0xFF,0xC0,0x7F,0xF0,0x00,
0x03,0xFF,0xEF,0xFF,0x80,0x00,0x1F,0xFC,0x0F,0xFF,
0x00,0x00,0x3F,0xFE,0xFF,0xF8,0x00,0x01,0xFF,0xE0,
0xFF,0xF0,0x00,0x03,0xFF,0xF1,0xFF,0xF0,0x00,0x01,
0xFF,0xC1,0xFF,0xC0,0x00,0x07,0xFF,0xDF,0xFF,0x00,
0x00,0x1F,0xFE,0x3F,0xFC,0x00,0x00,0x7F,0xFE,0x3F,
0xFE,0x00,0x00,0x1F,0xFC,0x7F,0xF0,0x00,0x00,0xFF,
0xFB,0xFF,0xE0,0x00,0x01,0xFF,0xEF,0xFF,0x00,0x00,
0x0F,0xFF,0xC7,0xFF,0xC0,0x00,0x01,0xFF,0xDF,0xFC,
0x00,0x00,0x1F,0xFF,0x7F,0xFC,0x00,0x00,0x1F,0xFF,
0xFF,0xC0,0x00,0x01,0xFF,0xF9,0xFF,0xF8,0x00,0x00,
0x1F,0xFF,0xFF,0x00,0x00,0x03,0xFF,0xEF,0xFF,0x80,
0x00,0x01,0xFF,0xFF,0xE0,0x00,0x00,0x3F,0xFF,0x1F,
0xFF,0x00,0x00,0x01,0xFF,0xFF,0xC0,0x00,0x00,0x7F,
0xFD,0xFF,0xF0,0x00,0x00,0x1F,0xFF,0xF8,0x00,0x00,
0x07,0xFF,0xE7,0xFF,0xE0,0x00,0x00,0x1F,0xFF,0xF0,
0x00,0x00,0x0F,0xFF,0xCF,0xFF,0xC0,0x00,0x00,0x1F,
0xFF,0xC0,0x00,0x00,0x1F,0xFF,0x12,0xAF,0xAC,0x01,
0x81,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,
0xC7,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x3F,0xFE,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xE3,
0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0x7F,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x03,0xFF,0xF1,0xFF,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xBF,0xFF,
0xFC,0x00,0x00,0x00,0x00,0x01,0xFF,0xF8,0xFF,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x07,0xFF,0xDF,0xFF,0xFF,
0x80,0x00,0x00,0x00,0x00,0xFF,0xFC,0x7F,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x03,0xFF,0xEF,0xFF,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x7F,0xFE,0x3F,0xFF,0xFF,0xE0,
0x00,0x00,0x00,0x01,0xFF,0xF7,0xFF,0xFF,0xFE,0x00,
0x00,0x00,0x00,0x3F,0xFF,0x1F,0xFF,0xFF,0xFC,0x00,
0x00,0x00,0x00,0xFF,0xFB,0xFF,0xFF,0xFF,0xC0,0x00,
0x00,0x00,0x1F,0xFF,0x8F,0xFF,0xFF,0xFF,0x80,0x00,
0x00,0x00,0x7F,0xFD,0xFF,0xF7,0xFF,0xF8,0x00,0x00,
0x00,0x0F,0xFF,0xBF,0xFE,0x7F,0xFF,0x00,0x00,0x00,
0x01,0xFF,0xF7,0xFF,0xCF,0xFF,0xF0,0x00,0x00,0x00,
0x3F,0xFE,0xFF,0xF8,0xFF,0xFF,0x00,0x00,0x00,0x07,
0xFF,0xDF,0xFF,0x0F,0xFF,0xE0,0x00,0x00,0x00,0xFF,
0xFB,0xFF,0xE1,0xFF,0xFE,0x00,0x00,0x00,0x1F,0xFF,
0x7F,0xFC,0x1F,0xFF,0xE0,0x00,0x00,0x03,0xFF,0xEF,
0xFF,0x81,0xFF,0xFC,0x00,0x00,0x00,0x7F,0xFD,0xFF,
0xF0,0x3F,0xFF,0xC0,0x00,0x00,0x0F,0xFF,0xBF,0xFE,
0x03,0xFF,0xFC,0x00,0x00,0x01,0xFF,0xF7,0xFF,0xC0,
0x3F,0xFF,0x80,0x00,0x00,0x3F,0xFE,0xFF,0xF8,0x07,
0xFF,0xF8,0x00,0x00,0x07,0xFF,0xDF,0xFF,0x00,0x7F,
0xFF,0x80,0x00,0x00,0xFF,0xFB,0xFF,0xE0,0x07,0xFF,
0xF0,0x00,0x00,0x1F,0xFF,0x7F,0xFC,0x00,0xFF,0xFF,
0x00,0x00,0x03,0xFF,0xEF,0xFF,0x80,0x0F,0xFF,0xF0,
0x00,0x00,0x7F,0xFD,0xFF,0xF0,0x00,0xFF,0xFE,0x00,
0x00,0x0F,0xFF,0xBF,0xFE,0x00,0x1F,0xFF,0xE0,0x00,
0x01,0xFF,0xF7,0xFF,0xC0,0x01,0xFF,0xFE,0x00,0x00,
0x3F,0xFE,0xFF,0xF8,0x00,0x1F,0xFF,0xC0,0x00,0x07,
0xFF,0xDF,0xFF,0x00,0x03,0xFF,0xFC,0x00,0x00,0xFF,
0xFB,0xFF,0xE0,0x00,0x3F,0xFF,0xC0,0x00,0x1F,0xFF,
0x7F,0xFC,0x00,0x03,0xFF,0xF8,0x00,0x03,0xFF,0xEF,
0xFF,0x80,0x00,0x7F,0xFF,0x80,0x00,0x7F,0xFD,0xFF,
0xF0,0x00,0x07,0xFF,0xF0,0x00,0x0F,0xFF,0xBF,0xFE,
0x00,0x00,0xFF,0xFF,0x00,0x01,0xFF,0xF7,0xFF,0xC0,
0x00,0x0F,0xFF,0xF0,0x00,0x3F,0xFE,0xFF,0xF8,0x00,
0x00,0xFF,0xFE,0x00,0x07,0xFF,0xDF,0xFF,0x00,0x00,
0x1F,0xFF,0xE0,0x00,0xFF,0xFB,0xFF,0xE0,0x00,0x01,
0xFF,0xFE,0x00,0x1F,0xFF,0x7F,0xFC,0x00,0x00,0x1F,
0xFF,0xC0,0x03,0xFF,0xEF,0xFF,0x80,0x00,0x03,0xFF,
0xFC,0x00,0x7F,0xFD,0xFF,0xF0,0x00,0x00,0x3F,0xFF,
0xC0,0x0F,0xFF,0xBF,0xFE,0x00,0x00,0x03,0xFF,0xF8,
0x01,0xFF,0xF7,0xFF,0xC0,0x00,0x00,0x7F,0xFF,0x80,
0x3F,0xFE,0xFF,0xF8,0x00,0x00,0x07,0xFF,0xF8,0x07,
0xFF,0xDF,0xFF,0x00,0x00,0x00,0x7F,0xFF,0x00,0xFF,
0xFB,0xFF,0xE0,0x00,0x00,0x0F,0xFF,0xF0,0x1F,0xFF,
0x7F,0xFC,0x00,0x00,0x00,0xFF,0xFF,0x03,0xFF,0xEF,
0xFF,0x80,0x00,0x00,0x0F,0xFF,0xE0,0x7F,0xFD,0xFF,
0xF0,0x00,0x00,0x01,0xFF,0xFE,0x0F,0xFF,0xBF,0xFE,
0x00,0x00,0x00,0x1F,0xFF,0xE1,0xFF,0xF7,0xFF,0xC0,
0x00,0x00,0x01,0xFF,0xFC,0x3F,0xFE,0xFF,0xF8,0x00,
0x00,0x00,0x3F,0xFF,0xC7,0xFF,0xDF,0xFF,0x00,0x00,
0x00,0x03,0xFF,0xFC,0xFF,0xFB,0xFF,0xE0,0x00,0x00,
0x00,0x3F,0xFF,0x9F,0xFF,0x7F,0xFC,0x00,0x00,0x00,
0x07,0xFF,0xFB,0xFF,0xF1,0xFF,0xF0,0x00,0x00,0x00,
0x0F,0xFF,0xFF,0xFF,0xBF,0xFE,0x00,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0xF8,0xFF,0xF8,0x00,0x00,0x00,0x01,
0xFF,0xFF,0xFF,0xDF,0xFF,0x00,0x00,0x00,0x00,0x1F,
0xFF,0xFF,0xFC,0x7F,0xFC,0x00,0x00,0x00,0x00,0x3F,
0xFF,0xFF,0xEF,0xFF,0x80,0x00,0x00,0x00,0x03,0xFF,
0xFF,0xFE,0x3F,0xFE,0x00,0x00,0x00,0x00,0x07,0xFF,
0xFF,0xF7,0xFF,0xC0,0x00,0x00,0x00,0x00,0x7F,0xFF,
0xFF,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
0xFB,0xFF,0xE0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,
0x8F,0xFF,0x80,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFD,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0xC7,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x03,0xFF,0xFE,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xE3,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x7F,0xFC,
0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xE0,0x16,0xF0,
0x9B,0xFD,0x9C,0x00,0x00,0x00,0x00,0x07,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,
0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,
0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x0F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x01,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xE0,0x03,0xFF,0xFF,0xFE,0x00,
0x00,0x00,0x0F,0xFF,0xFF,0xC0,0x00,0x01,0xFF,0xFF,
0xF0,0x00,0x00,0x01,0xFF,0xFF,0xF0,0x00,0x00,0x07,
0xFF,0xFF,0x80,0x00,0x00,0x1F,0xFF,0xF8,0x00,0x00,
0x00,0x1F,0xFF,0xFC,0x00,0x00,0x03,0xFF,0xFF,0x00,
0x00,0x00,0x00,0x7F,0xFF,0xE0,0x00,0x00,0x7F,0xFF,
0xC0,0x00,0x00,0x00,0x01,0xFF,0xFF,0x00,0x00,0x0F,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x0F,0xFF,0xF8,0x00,
0x01,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,
0x80,0x00,0x1F,0xFF,0xC0,0x00,0x00,0x00,0x00,0x01,
0xFF,0xFC,0x00,0x03,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xE0,0x00,0x3F,0xFF,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFE,0x00,0x07,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x00,0x07,0xFF,0xF0,0x00,0xFF,0xFE,
0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x00,0x0F,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xF8,
0x00,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,
0xFF,0x80,0x1F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0xFC,0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xC0,0x3F,0xFF,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x7F,0xFE,0x03,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xE0,0x3F,0xFE,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFE,0x07,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,
0xF2,0x4F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xFF,0xE1,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x3F,0xFF,0x5B,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3F,0xFE,0xDF,0xFF,0x80,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xBF,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFD,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,
0xFF,0xDF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0xFE,0xDF,0xFF,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x01,0xFF,0xF4,0x9F,0xFF,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x07,0xFF,0xC1,0xFF,0xF0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFC,0x81,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xF0,
0x1F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,
0xFF,0x00,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xFF,0xE0,0x0F,0xFF,0xC0,0x00,0x00,0x00,0x00,
0x00,0x00,0x7F,0xFE,0x00,0x7F,0xFC,0x00,0x00,0x00,
0x00,0x00,0x00,0x0F,0xFF,0xC0,0x07,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x00,0x00,0xFF,0xFC,0x00,0x3F,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xC0,0x03,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xF8,
0x00,0x1F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x7F,
0xFF,0x00,0x01,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,
0x07,0xFF,0xF0,0x00,0x0F,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0xFF,0xFE,0x00,0x00,0x7F,0xFF,0x00,0x00,
0x00,0x00,0x00,0x3F,0xFF,0xE0,0x00,0x07,0xFF,0xFC,
0x00,0x00,0x00,0x00,0x07,0xFF,0xFC,0x00,0x00,0x3F,
0xFF,0xE0,0x00,0x00,0x00,0x00,0xFF,0xFF,0x80,0x00,
0x01,0xFF,0xFF,0x80,0x00,0x00,0x00,0x3F,0xFF,0xF0,
0x00,0x00,0x0F,0xFF,0xFC,0x00,0x00,0x00,0x07,0xFF,
0xFF,0x00,0x00,0x00,0x7F,0xFF,0xF0,0x00,0x00,0x01,
0xFF,0xFF,0xE0,0x00,0x00,0x03,0xFF,0xFF,0xE0,0x00,
0x00,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0xE0,0x01,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x00,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,
0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,
0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x00,0x00,0x03,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0x12,0x2F,0xAC,0x01,0x65,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x7F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x3F,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xF0,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFE,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xC0,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xF0,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFC,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,
0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x3F,
0xFE,0x00,0x00,0x00,0x00,0xFF,0xFF,0xF8,0x1F,0xFF,
0x00,0x00,0x00,0x00,0x07,0xFF,0xFE,0x0F,0xFF,0x80,
0x00,0x00,0x00,0x00,0xFF,0xFF,0x87,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x3F,0xFF,0xC3,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xF1,0xFF,0xF0,0x00,0x00,0x00,
0x00,0x03,0xFF,0xF8,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x00,0xFF,0xFC,0x8F,0xFF,0x80,0x00,0x00,0x00,0x00,
0x07,0xFF,0xE8,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFE,0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,0x1F,
0xFF,0xEF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFC,0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,
0xBF,0xFE,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xE7,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0xFF,0xF9,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0xFF,0xFD,0x1F,0xFF,
0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0x8F,0xFF,0x80,
0x00,0x00,0x00,0x00,0x1F,0xFF,0xC7,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x1F,0xFF,0xC3,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x1F,0xFF,0xE1,0xFF,0xF0,0x00,0x00,0x00,
0x00,0x3F,0xFF,0xE0,0xFF,0xF8,0x00,0x00,0x00,0x00,
0xFF,0xFF,0xF0,0x7F,0xFC,0x00,0x00,0x00,0x07,0xFF,
0xFF,0xF0,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF0,0x23,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,
0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x7F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x3F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x1F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x0F,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xE0,0x00,0x07,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x80,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF0,0x00,0x00,0x03,0x7F,0xFE,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x37,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x00,0x00,0x03,0x7F,0xFE,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x37,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0x7F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x2B,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x16,0xF3,0x9B,0xE5,0x9C,0x00,0x00,0x00,0x00,
0x0F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x1F,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x03,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,
0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,
0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,
0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x80,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xC0,0x07,0xFF,
0xFF,0xFC,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xC0,0x00,
0x07,0xFF,0xFF,0xE0,0x00,0x00,0x01,0xFF,0xFF,0xE0,
0x00,0x00,0x0F,0xFF,0xFF,0x00,0x00,0x00,0x3F,0xFF,
0xF8,0x00,0x00,0x00,0x3F,0xFF,0xF8,0x00,0x00,0x07,
0xFF,0xFE,0x00,0x00,0x00,0x00,0xFF,0xFF,0xC0,0x00,
0x00,0x7F,0xFF,0xC0,0x00,0x00,0x00,0x07,0xFF,0xFC,
0x00,0x00,0x0F,0xFF,0xF0,0x00,0x00,0x00,0x00,0x1F,
0xFF,0xE0,0x00,0x01,0xFF,0xFE,0x00,0x00,0x00,0x00,
0x00,0xFF,0xFF,0x00,0x00,0x1F,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x07,0xFF,0xF0,0x00,0x03,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0x3F,0xFF,0x80,0x00,0x7F,0xFF,
0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xFC,0x00,0x07,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xC0,
0x00,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFE,0x00,0x0F,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,
0x07,0xFF,0xE0,0x00,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x00,0x00,0x7F,0xFF,0x00,0x1F,0xFF,0x80,0x00,0x00,
0x00,0x00,0x00,0x03,0xFF,0xF0,0x01,0xFF,0xF0,0x00,
0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0x00,0x3F,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xF8,0x03,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,
0x80,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0xF8,0x07,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xC2,0x4F,0xFF,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x0F,0xFF,0x85,0xBF,0xFE,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x87,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFC,0xDF,
0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xF9,0xBF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0xFF,0xF1,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0xFF,0x1F,0xFF,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x03,0xFF,0xF2,0xDF,0xFF,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xC4,0x9F,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0x01,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,
0xF0,0x81,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,
0x07,0xFF,0xC0,0x1F,0xFF,0x80,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0xFC,0x00,0xFF,0xF8,0x00,0x00,0x00,
0x08,0x00,0x00,0x0F,0xFF,0x80,0x0F,0xFF,0xC0,0x00,
0x00,0x01,0xF0,0x00,0x01,0xFF,0xF8,0x00,0x7F,0xFC,
0x00,0x00,0x00,0x1F,0xE0,0x00,0x1F,0xFF,0x00,0x07,
0xFF,0xE0,0x00,0x00,0x01,0xFF,0x80,0x03,0xFF,0xF0,
0x00,0x7F,0xFF,0x00,0x00,0x00,0x3F,0xFE,0x00,0x7F,
0xFE,0x00,0x03,0xFF,0xF0,0x00,0x00,0x03,0xFF,0xF0,
0x07,0xFF,0xE0,0x00,0x1F,0xFF,0x80,0x00,0x00,0x3F,
0xFF,0xC0,0xFF,0xFC,0x00,0x01,0xFF,0xFC,0x00,0x00,
0x07,0xFF,0xFE,0x1F,0xFF,0xC0,0x00,0x0F,0xFF,0xE0,
0x00,0x00,0x7F,0xFF,0xF3,0xFF,0xF8,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0x00,0x00,
0x07,0xFF,0xF8,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xF0,
0x00,0x00,0x3F,0xFF,0xE0,0x00,0x00,0x1F,0xFF,0xFF,
0xFE,0x00,0x00,0x01,0xFF,0xFF,0x00,0x00,0x00,0x7F,
0xFF,0xFF,0xC0,0x00,0x00,0x1F,0xFF,0xFC,0x00,0x00,
0x01,0xFF,0xFF,0xF8,0x00,0x00,0x00,0xFF,0xFF,0xF0,
0x00,0x00,0x07,0xFF,0xFF,0x00,0x00,0x00,0x07,0xFF,
0xFF,0xC0,0x00,0x03,0xFF,0xFF,0xE0,0x00,0x00,0x00,
0x3F,0xFF,0xFF,0xE0,0x03,0xFF,0xFF,0xFE,0x00,0x00,
0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,
0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xC0,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0x00,0x00,0x00,0x01,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x07,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,
0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,
0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,0xFF,0xFE,
0x00,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xF0,0x7F,
0xFF,0xFC,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xF8,
0x03,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x0F,0xFF,0xFF,
0xFC,0x00,0x0F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x07,
0xFF,0xF0,0x00,0x00,0x7F,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0x80,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,
0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x02,0x00,0x14,0x6F,0xAC,0x01,
0x81,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,
0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,
0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,
0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,
0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xC0,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF8,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xE0,0x00,0x8F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x80,0x03,0xFF,0xE0,0x00,0x00,0x00,0x03,
0xFF,0xFF,0xF0,0x00,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x0F,0xFF,0xFE,0x00,0x3F,0xFE,0x00,0x00,0x00,0x00,
0x00,0xFF,0xFF,0x80,0x0F,0xFF,0x80,0x00,0x00,0x00,
0x00,0x1F,0xFF,0xF0,0x03,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x01,0xFF,0xFC,0x00,0xFF,0xF8,0x00,0x00,0x00,
0x00,0x00,0x3F,0xFF,0x00,0x3F,0xFE,0x00,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xE0,0x0F,0xFF,0x80,0x00,0x00,
0x00,0x00,0x01,0xFF,0xF8,0x04,0x7F,0xFC,0x00,0x00,
0x00,0x00,0x00,0x07,0xFF,0xC0,0x1F,0xFF,0x00,0x00,
0x00,0x00,0x00,0x01,0xFF,0xF8,0x0D,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0x07,0xFF,0xC0,0x3F,0xFE,0x00,
0x00,0x00,0x00,0x00,0x01,0xFF,0xF0,0x0F,0xFF,0x80,
0x00,0x00,0x00,0x00,0x00,0xFF,0xFC,0x04,0x7F,0xFC,
0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xC0,0x23,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x00,0x7F,0xFE,0x00,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x00,0x3F,
0xFE,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xC0,0x0F,
0xFF,0x80,0x00,0x00,0x00,0x00,0x0F,0xFF,0xF0,0x03,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x07,0xFF,0xF8,0x00,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x07,0xFF,0xFC,0x00,
0x3F,0xFE,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0x00,
0x0F,0xFF,0x80,0x00,0x00,0x00,0x1F,0xFF,0xFF,0x80,
0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,
0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,
0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,
0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,
0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,
0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,
0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,
0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,
0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,
0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,
0x00,0x00,0x00,0x0F,0xFF,0x80,0x00,0x03,0xFF,0xFE,
0x00,0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,0x1F,0xFF,
0xE0,0x00,0x00,0x00,0xFF,0xF8,0x00,0x00,0x03,0xFF,
0xFC,0x00,0x00,0x00,0x3F,0xFE,0x00,0x00,0x00,0x3F,
0xFF,0x80,0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,0x07,
0xFF,0xF0,0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,
0xFF,0xFE,0x00,0x00,0x00,0xFF,0xF8,0x00,0x00,0x00,
0x1F,0xFF,0xC0,0x00,0x00,0x3F,0xFE,0x00,0x00,0x00,
0x03,0xFF,0xF8,0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,
0x00,0x7F,0xFF,0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,
0x00,0x0F,0xFF,0xE0,0x00,0x00,0xFF,0xF8,0x00,0x00,
0x00,0x03,0xFF,0xFC,0x00,0x00,0x3F,0xFE,0x00,0x00,
0x00,0x00,0x7F,0xFF,0x00,0x00,0x0F,0xFF,0x80,0x00,
0x00,0x00,0x0F,0xFF,0xE0,0x00,0x03,0xFF,0xE0,0x00,
0x00,0x00,0x03,0xFF,0xFC,0x00,0x00,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,0x3F,0xFE,0x00,
0x00,0x00,0x00,0x0F,0xFF,0xE0,0x00,0x0F,0xFF,0x80,
0x00,0x00,0x00,0x03,0xFF,0xFC,0x00,0x03,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,0xFF,0xF8,
0x00,0x00,0x00,0x00,0x0F,0xFF,0xE0,0x00,0x3F,0xFE,
0x00,0x00,0x00,0x00,0x03,0xFF,0xFC,0x00,0x0F,0xFF,
0x80,0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,0x04,0x7F,
0xFC,0x00,0x00,0x00,0x00,0x01,0xFF,0xFC,0x00,0x1F,
0xFF,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x80,0x07,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xF0,0x01,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x01,0xFF,0xFC,0x00,
0x8F,0xFF,0x80,0x00,0x00,0x00,0x00,0x07,0xFF,0xF0,
0x03,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0xFF,0xFE,
0x01,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,
0xF8,0x07,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x7F,
0xFF,0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x1F,
0xFF,0xE0,0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,0x03,
0xFF,0xF8,0x23,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFF,0xE0,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x01,0xFF,0xFC,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,
0x00,0x7F,0xFF,0x8F,0xFF,0x80,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xE4,0x7F,0xFC,0x00,0x00,0x00,0x00,
0x00,0x00,0x3F,0xFF,0x9F,0xFF,0x00,0x00,0x00,0x00,
0x00,0x00,0x07,0xFF,0xF0,0x13,0x30,0x9B,0xFD,0x64,
0x00,0x00,0x00,0x03,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x00,0x00,0x07,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,
0x00,0x01,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,
0x0F,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x1F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x01,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x1F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x01,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x1F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x01,0xFF,0xFF,0xFC,
0x00,0x1F,0xFF,0xFF,0xC0,0x00,0x1F,0xFF,0xFC,0x00,
0x00,0x0F,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x80,0x00,
0x00,0x0F,0xFF,0xF8,0x00,0x0F,0xFF,0xF0,0x00,0x00,
0x00,0x3F,0xFF,0xE0,0x00,0xFF,0xFF,0x00,0x00,0x00,
0x00,0x7F,0xFF,0x80,0x07,0xFF,0xF0,0x00,0x00,0x00,
0x01,0xFF,0xFC,0x00,0x3F,0xFF,0x00,0x00,0x00,0x00,
0x07,0xFF,0xF0,0x03,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x1F,0xFF,0x80,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,
0xFF,0xFC,0x00,0xFF,0xF8,0x00,0x00,0x00,0x00,0x03,
0xFF,0xF0,0x0F,0xFF,0xC0,0x00,0x00,0x00,0x00,0x1F,
0xFF,0x88,0x0F,0xFF,0x80,0x00,0x00,0x00,0x00,0x0F,
0xFF,0x80,0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,0x7F,
0xFE,0x48,0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,0x3F,
0xFE,0x03,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
0x02,0x03,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x7F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,
0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,
0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,
0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,
0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,
0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,
0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,
0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,
0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,
0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,
0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xF8,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xF9,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xD1,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xF1,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xF0,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xF2,0xFF,
0xFC,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xE3,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x1F,0xFF,
0x80,0x00,0x00,0x00,0x00,0x01,0xFF,0xF0,0xFF,0xFE,
0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x83,0xFF,0xF8,
0x00,0x00,0x00,0x00,0x00,0xFF,0xFC,0x1F,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x0F,0xFF,0xC0,0x7F,0xFF,0x00,
0x00,0x00,0x00,0x00,0x7F,0xFE,0x03,0xFF,0xFC,0x00,
0x00,0x00,0x00,0x07,0xFF,0xF0,0x0F,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x7F,0xFF,0x00,0x7F,0xFF,0xE0,0x00,
0x00,0x00,0x07,0xFF,0xF8,0x01,0xFF,0xFF,0xC0,0x00,
0x00,0x00,0xFF,0xFF,0x80,0x07,0xFF,0xFF,0x80,0x00,
0x00,0x1F,0xFF,0xF8,0x00,0x1F,0xFF,0xFF,0x80,0x00,
0x07,0xFF,0xFF,0xC0,0x00,0x7F,0xFF,0xFF,0xC0,0x03,
0xFF,0xFF,0xFC,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xC0,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFC,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xC0,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFC,0x00,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x80,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,
0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,
0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFE,0x00,0x00,0x00,
0x00,0x00,0x00,0x01,0xFF,0xFE,0x00,0x00,0x00,0x00,
0x12,0xEF,0x8C,0x01,0x47,0x7F,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFD,0x7F,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFD,0x00,0x00,0x00,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x1A,0x00,0x00,0x00,0x03,0xFF,
0xE0,0x00,0x00,0x00,0x34,0x00,0x00,0x00,0x07,0xFF,
0xC0,0x00,0x00,0x00,0x68,0x00,0x00,0x00,0x0F,0xFF,
0x80,0x00,0x00,0x00,0xD0,0x00,0x00,0x00,0x1F,0xFF,
0x00,0x00,0x00,0x01,0xA0,0x00,0x00,0x00,0x3F,0xFE,
0x00,0x00,0x00,0x03,0x40,0x00,0x00,0x00,0x7F,0xFC,
0x00,0x00,0x00,0x06,0x80,0x00,0x00,0x00,0xFF,0xF8,
0x00,0x00,0x00,0x0D,0x00,0x00,0x00,0x01,0xFF,0xF0,
0x00,0x00,0x00,0x1A,0x00,0x00,0x00,0x03,0xFF,0xE0,
0x00,0x00,0x00,0x34,0x00,0x00,0x00,0x07,0xFF,0xC0,
0x00,0x00,0x00,0x68,0x00,0x00,0x00,0x0F,0xFF,0x80,
0x00,0x00,0x00,0x12,0xB0,0x2F,0xFD,0x83,0x7F,0xFE,
0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xFD,0xFF,0xF8,
0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xF7,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xDF,0xFF,0x80,
0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x7F,0xFE,0x00,
0x00,0x00,0x00,0x00,0x01,0xFF,0xFD,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0x07,0xFF,0xF7,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x00,0x1F,0xFF,0xDF,0xFF,0x80,0x00,
0x00,0x00,0x00,0x00,0x7F,0xFF,0x7F,0xFE,0x00,0x00,
0x00,0x00,0x00,0x01,0xFF,0xF7,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x00,0x7F,0xFE,0xFF,0xFC,0x00,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xE9,0xFF,0xF0,0x00,0x00,0x00,
0x00,0x00,0x3F,0xFE,0x3F,0xFE,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xC7,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x01,0xFF,0xF8,0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFE,0x0F,0xFF,0x80,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xC8,0x3F,0xFF,0x00,0x00,0x00,0x00,0x00,0x3F,
0xFF,0x03,0xFF,0xF0,0x00,0x00,0x00,0x00,0x0F,0xFF,
0xC0,0x7F,0xFF,0x00,0x00,0x00,0x00,0x03,0xFF,0xF8,
0x0F,0xFF,0xF0,0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x1F,0xFF,0xC0,0x1F,
0xFF,0xF0,0x00,0x00,0x00,0x0F,0xFF,0xF8,0x01,0xFF,
0xFF,0x00,0x00,0x00,0x03,0xFF,0xFE,0x00,0x3F,0xFF,
0xF8,0x00,0x00,0x01,0xFF,0xFF,0xC0,0x03,0xFF,0xFF,
0xC0,0x00,0x01,0xFF,0xFF,0xF0,0x00,0x7F,0xFF,0xFF,
0x80,0x03,0xFF,0xFF,0xFC,0x00,0x07,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x7F,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xE0,0x00,0x07,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xF8,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFE,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xC0,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,
0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xF0,0x00,0x00,0x00,0x00,0x16,
0xEF,0xFC,0x01,0x65,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x0F,0xFF,0xE1,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x0F,0xFF,0x80,
0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xE0,0xFF,
0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFE,
0x07,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x07,
0xFF,0xE0,0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0xFC,0x07,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xC0,0x3F,0xFE,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xFF,0xF8,0x03,0xFF,0xF0,0x00,
0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0x80,0x1F,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xF8,0x01,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,
0x00,0x1F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x03,
0xFF,0xF0,0x00,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x00,0x3F,0xFE,0x00,0x0F,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x00,0x07,0xFF,0xE0,0x00,0x7F,0xFC,0x00,0x00,
0x00,0x00,0x00,0x00,0x7F,0xFE,0x00,0x07,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xC0,0x00,0x7F,
0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFC,0x00,
0x03,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,
0x80,0x00,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,0x01,
0xFF,0xF8,0x00,0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x00,0x1F,0xFF,0x80,0x00,0x1F,0xFF,0x00,0x00,0x00,
0x00,0x00,0x01,0xFF,0xF0,0x00,0x01,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0x3F,0xFF,0x00,0x40,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x7F,0xFC,0x00,0x00,
0x0F,0xFF,0x80,0x00,0x00,0x00,0x00,0x0F,0xFF,0xC0,
0x00,0x00,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0xFF,
0xF8,0x00,0x00,0x07,0xFF,0xC0,0x00,0x00,0x00,0x00,
0x1F,0xFF,0x80,0x08,0x00,0x0F,0xFF,0x80,0x00,0x00,
0x00,0x00,0x3F,0xFE,0x00,0x00,0x00,0x7F,0xFC,0x00,
0x00,0x00,0x00,0x07,0xFF,0xE0,0x00,0x00,0x07,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x7F,0xFC,0x00,0x00,0x00,
0x3F,0xFC,0x00,0x00,0x00,0x00,0x0F,0xFF,0xC0,0x01,
0x00,0x00,0x7F,0xFC,0x00,0x00,0x00,0x00,0x1F,0xFF,
0x00,0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,0x03,
0xFF,0xF0,0x00,0x00,0x00,0x3F,0xFE,0x00,0x00,0x00,
0x00,0x3F,0xFE,0x00,0x00,0x00,0x01,0xFF,0xE0,0x00,
0x00,0x00,0x03,0xFF,0xE0,0x00,0x20,0x00,0x03,0xFF,
0xE0,0x00,0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,0x00,
0x1F,0xFF,0x00,0x00,0x00,0x01,0xFF,0xF8,0x00,0x00,
0x00,0x01,0xFF,0xF0,0x00,0x00,0x00,0x1F,0xFF,0x00,
0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,0x01,0xFF,
0xF0,0x00,0x00,0x00,0x00,0xFF,0xF8,0x00,0x00,0x00,
0x3F,0xFE,0x00,0x00,0x00,0x00,0x07,0xFF,0x80,0x00,
0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,0x00,0x7F,0xF8,
0x00,0x00,0x00,0x7F,0xFE,0x00,0x00,0x00,0x00,0x07,
0xFF,0xC0,0x00,0x00,0x07,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x3F,0xFC,0x00,0x00,0x00,0x7F,0xFC,0x00,0x00,
0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,0x0F,0xFF,0x80,
0x00,0x04,0x00,0x00,0x03,0xFF,0xC0,0x00,0x00,0x1F,
0xFF,0x00,0x00,0x00,0x00,0x00,0x3F,0xFE,0x00,0x00,
0x03,0xFF,0xE0,0x00,0x00,0x00,0x00,0x01,0xFF,0xE0,
0x00,0x00,0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,0x1F,
0xFF,0x00,0x00,0x07,0xFF,0xC0,0x00,0x00,0x80,0x00,
0x00,0x1F,0xFE,0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,
0x00,0x00,0x01,0xFF,0xF0,0x00,0x01,0xFF,0xF0,0x00,
0x00,0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x1F,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xF0,0x00,0x03,
0xFF,0xE0,0x00,0x00,0x10,0x00,0x00,0x00,0xFF,0xF0,
0x00,0x07,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x0F,
0xFF,0x80,0x00,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x00,0x7F,0xF8,0x00,0x0F,0xFF,0x80,0x00,0x00,0x00,
0x00,0x00,0x07,0xFF,0x80,0x00,0xFF,0xF0,0x00,0x00,
0x02,0x00,0x00,0x00,0x07,0xFF,0x80,0x03,0xFF,0xE0,
0x00,0x00,0x04,0x00,0x00,0x00,0x07,0xFF,0x80,0x0F,
0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xF8,
0x00,0xFF,0xF0,0x00,0x00,0x00,0x80,0x00,0x00,0x00,
0x7F,0xF8,0x03,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0xFF,0x80,0x7F,0xFC,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x3F,0xFC,0x07,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0xFF,0xC0,0x7F,0xF8,0x00,
0x00,0x00,0x10,0x00,0x00,0x00,0x03,0xFF,0xC1,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFC,
0x1F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
0xFF,0xE3,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x1F,0xFE,0x3F,0xFC,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0xE3,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x0F,0xFF,0x7F,0xFC,0x00,0x00,
0x00,0x02,0x00,0x00,0x00,0x00,0x0F,0xFE,0xFF,0xF0,
0x00,0x00,0x00,0x04,0x80,0x00,0x00,0x00,0x0F,0xFF,
0xFF,0xC0,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
0x0F,0xFF,0xFF,0x00,0x00,0x00,0x00,0x12,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x20,
0x00,0x00,0x00,0x00,0x0F,0xFF,0xF0,0x00,0x00,0x00,
0x00,0x40,0x00,0x00,0x00,0x00,0x0F,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x1F,0x2F,0x88,0x01,0xFE,0x3F,0xFF,
0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x80,0x00,0x00,
0x00,0x00,0xFF,0xFC,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x07,0xFF,0xFC,0x00,0x00,0x00,0x00,0x07,0xFF,0xC7,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x7F,0xFF,0xF0,0x00,
0x00,0x00,0x00,0x3F,0xFE,0x3F,0xFE,0x00,0x00,0x00,
0x00,0x03,0xFF,0xFF,0x80,0x00,0x00,0x00,0x03,0xFF,
0xF1,0xFF,0xF8,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFC,
0x00,0x00,0x00,0x00,0x1F,0xFF,0x87,0xFF,0xC0,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,
0xFF,0xF9,0x07,0xFF,0xC0,0x00,0x00,0x00,0x01,0xFF,
0xFF,0xF0,0x00,0x00,0x00,0x00,0xFF,0xF8,0x1F,0xFF,
0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0x80,0x00,0x00,
0x00,0x0F,0xFF,0x88,0x1F,0xFF,0x00,0x00,0x00,0x00,
0x1F,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x0F,0xFF,0x80,
0xFF,0xF8,0x00,0x00,0x00,0x00,0xFF,0xEF,0xFE,0x00,
0x00,0x00,0x00,0x7F,0xFC,0x03,0xFF,0xE0,0x00,0x00,
0x00,0x07,0xFF,0x7F,0xF0,0x00,0x00,0x00,0x07,0xFF,
0xC0,0x1F,0xFF,0x00,0x00,0x00,0x00,0x7F,0xFB,0xFF,
0xC0,0x00,0x00,0x00,0x3F,0xFE,0x10,0x1F,0xFF,0x00,
0x00,0x00,0x00,0x7F,0xF1,0xFF,0xC0,0x00,0x00,0x00,
0x3F,0xFE,0x00,0x7F,0xFC,0x00,0x00,0x00,0x03,0xFF,
0x8F,0xFF,0x00,0x00,0x00,0x03,0xFF,0xE0,0x03,0xFF,
0xE0,0x00,0x00,0x00,0x3F,0xFC,0x7F,0xF8,0x00,0x00,
0x00,0x1F,0xFF,0x04,0x03,0xFF,0xE0,0x00,0x00,0x00,
0x3F,0xF8,0x3F,0xF8,0x00,0x00,0x00,0x1F,0xFF,0x00,
0x0F,0xFF,0x00,0x00,0x00,0x01,0xFF,0xC1,0xFF,0xE0,
0x00,0x00,0x00,0xFF,0xF0,0x00,0x7F,0xFC,0x00,0x00,
0x00,0x1F,0xFE,0x0F,0xFF,0x00,0x00,0x00,0x0F,0xFF,
0x80,0x03,0xFF,0xE0,0x00,0x00,0x00,0xFF,0xE0,0x3F,
0xF8,0x00,0x00,0x00,0x7F,0xFC,0x00,0x0F,0xFF,0x00,
0x00,0x00,0x07,0xFF,0x01,0xFF,0xC0,0x00,0x00,0x03,
0xFF,0xC0,0x00,0x7F,0xF8,0x00,0x00,0x00,0x7F,0xF8,
0x0F,0xFF,0x00,0x00,0x00,0x1F,0xFE,0x00,0x03,0xFF,
0xE0,0x00,0x00,0x03,0xFF,0xC0,0x7F,0xF8,0x00,0x00,
0x01,0xFF,0xF0,0x00,0x1F,0xFF,0x00,0x00,0x00,0x1F,
0xFC,0x01,0xFF,0xC0,0x00,0x00,0x0F,0xFF,0x80,0x00,
0x7F,0xF8,0x00,0x00,0x00,0xFF,0xE0,0x0F,0xFF,0x00,
0x00,0x00,0x7F,0xF8,0x00,0x03,0xFF,0xC0,0x00,0x00,
0x0F,0xFF,0x00,0x7F,0xF8,0x00,0x00,0x03,0xFF,0xC0,
0x20,0x03,0xFF,0xE0,0x00,0x00,0x0F,0xFE,0x00,0x3F,
0xF8,0x00,0x00,0x07,0xFF,0xC0,0x00,0x0F,0xFF,0x00,
0x00,0x00,0x7F,0xF0,0x01,0xFF,0xE0,0x00,0x00,0x3F,
0xFC,0x00,0x00,0x7F,0xF8,0x00,0x00,0x07,0xFF,0x80,
0x0F,0xFF,0x00,0x00,0x01,0xFF,0xE0,0x00,0x03,0xFF,
0xC0,0x00,0x00,0x3F,0xF8,0x00,0x3F,0xF8,0x00,0x00,
0x1F,0xFF,0x00,0x00,0x1F,0xFF,0x00,0x00,0x01,0xFF,
0xC0,0x01,0xFF,0xE0,0x00,0x00,0xFF,0xF8,0x00,0x00,
0x7F,0xF8,0x00,0x00,0x0F,0xFE,0x00,0x0F,0xFF,0x00,
0x00,0x07,0xFF,0x80,0x00,0x03,0xFF,0xC0,0x00,0x00,
0xFF,0xF0,0x00,0x7F,0xF8,0x00,0x00,0x3F,0xFC,0x00,
0x00,0x1F,0xFE,0x00,0x00,0x07,0xFF,0x00,0x01,0xFF,
0xC0,0x00,0x01,0xFF,0xE0,0x00,0x00,0xFF,0xF8,0x00,
0x00,0x3F,0xF8,0x00,0x0F,0xFF,0x00,0x00,0x1F,0xFF,
0x00,0x20,0x00,0x7F,0xF8,0x00,0x00,0x7F,0xF8,0x00,
0x0F,0xFF,0x00,0x00,0x1F,0xFE,0x00,0x00,0x03,0xFF,
0xC0,0x00,0x03,0xFF,0x80,0x00,0x3F,0xF8,0x00,0x00,
0xFF,0xF0,0x00,0x00,0x0F,0xFF,0x00,0x00,0x1F,0xFC,
0x00,0x01,0xFF,0xE0,0x00,0x0F,0xFF,0x00,0x00,0x00,
0x7F,0xF8,0x00,0x01,0xFF,0xE0,0x00,0x0F,0xFF,0x00,
0x00,0x7F,0xF8,0x00,0x00,0x03,0xFF,0xC0,0x00,0x0F,
0xFE,0x00,0x00,0x3F,0xF8,0x00,0x03,0xFF,0xC0,0x00,
0x00,0x1F,0xFE,0x00,0x00,0x7F,0xF0,0x00,0x01,0xFF,
0xE0,0x00,0x1F,0xFE,0x00,0x00,0x00,0x7F,0xF8,0x00,
0x03,0xFF,0x80,0x00,0x0F,0xFF,0x00,0x01,0xFF,0xE0,
0x00,0x00,0x03,0xFF,0xC0,0x00,0x3F,0xFC,0x00,0x00,
0x7F,0xF8,0x00,0x0F,0xFF,0x00,0x00,0x00,0x1F,0xFE,
0x00,0x01,0xFF,0xC0,0x00,0x01,0xFF,0xC0,0x00,0x7F,
0xF8,0x00,0x00,0x00,0xFF,0xF0,0x00,0x0F,0xFE,0x00,
0x00,0x0F,0xFF,0x00,0x03,0xFF,0xC0,0x00,0x00,0x03,
0xFF,0x80,0x00,0x7F,0xF0,0x00,0x00,0x7F,0xF8,0x00,
0x1F,0xFC,0x00,0x00,0x00,0x1F,0xFE,0x00,0x07,0xFF,
0x80,0x00,0x03,0xFF,0xC0,0x01,0xFF,0xE0,0x00,0x00,
0x00,0xFF,0xF0,0x00,0x3F,0xF8,0x00,0x00,0x0F,0xFE,
0x00,0x0F,0xFF,0x00,0x00,0x00,0x07,0xFF,0x80,0x01,
0xFF,0xC0,0x00,0x00,0x7F,0xF8,0x00,0x7F,0xF8,0x00,
0x00,0x00,0x1F,0xFC,0x00,0x1F,0xFE,0x00,0x00,0x03,
0xFF,0xC0,0x03,0xFF,0x80,0x00,0x80,0x00,0x1F,0xFE,
0x00,0x1F,0xFC,0x00,0x00,0x01,0xFF,0xC0,0x07,0xFF,
0x80,0x00,0x00,0x00,0x7F,0xF0,0x00,0xFF,0xE0,0x00,
0x00,0x0F,0xFE,0x00,0x3F,0xF8,0x00,0x00,0x00,0x03,
0xFF,0x80,0x0F,0xFF,0x00,0x00,0x00,0x7F,0xF8,0x01,
0xFF,0xC0,0x00,0x20,0x00,0x03,0xFF,0xC0,0x0F,0xFE,
0x00,0x00,0x00,0x3F,0xF8,0x03,0xFF,0xC0,0x00,0x00,
0x00,0x0F,0xFE,0x00,0x7F,0xF0,0x00,0x00,0x01,0xFF,
0xC0,0x1F,0xFC,0x00,0x00,0x00,0x00,0x7F,0xF0,0x07,
0xFF,0x80,0x00,0x00,0x0F,0xFF,0x00,0xFF,0xE0,0x00,
0x00,0x00,0x03,0xFF,0x80,0x3F,0xF8,0x00,0x00,0x00,
0x3F,0xF8,0x0F,0xFF,0x00,0x00,0x00,0x00,0x1F,0xFE,
0x01,0xFF,0xC0,0x00,0x00,0x01,0xFF,0xC0,0x7F,0xF8,
0x00,0x00,0x00,0x00,0x7F,0xF0,0x0F,0xFE,0x00,0x00,
0x00,0x0F,0xFE,0x03,0xFF,0x80,0x00,0x00,0x00,0x03,
0xFF,0x80,0xFF,0xF0,0x00,0x00,0x00,0x7F,0xF8,0x1F,
0xFC,0x00,0x00,0x00,0x00,0x1F,0xFC,0x07,0xFF,0x00,
0x00,0x00,0x01,0xFF,0xC0,0xFF,0xE0,0x00,0x00,0x00,
0x00,0xFF,0xF0,0x3F,0xF8,0x00,0x00,0x00,0x0F,0xFE,
0x0F,0xFF,0x00,0x00,0x00,0x00,0x03,0xFF,0x83,0xFF,
0xC0,0x00,0x00,0x00,0x7F,0xF0,0x7F,0xF0,0x00,0x00,
0x00,0x00,0x1F,0xFC,0x1F,0xFC,0x00,0x00,0x00,0x01,
0xFF,0x83,0xFF,0x80,0x00,0x00,0x00,0x00,0xFF,0xE0,
0xFF,0xE0,0x00,0x00,0x00,0x0F,0xFE,0x1F,0xFC,0x00,
0x00,0x00,0x00,0x03,0xFF,0x87,0xFF,0x00,0x00,0x00,
0x00,0x7F,0xF1,0xFF,0xC0,0x00,0x00,0x00,0x00,0x1F,
0xFC,0x7F,0xF8,0x00,0x00,0x00,0x03,0xFF,0x8F,0xFE,
0x00,0x00,0x10,0x00,0x00,0x1F,0xFC,0x7F,0xF0,0x00,
0x00,0x00,0x01,0xFF,0x8F,0xFE,0x00,0x00,0x00,0x00,
0x00,0x7F,0xE3,0xFF,0x80,0x00,0x00,0x00,0x0F,0xFE,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x03,0xFF,0xBF,0xFC,
0x00,0x00,0x00,0x00,0x7F,0xF7,0xFF,0x00,0x00,0x04,
0x00,0x00,0x03,0xFF,0xBF,0xF8,0x00,0x00,0x00,0x00,
0x3F,0xF7,0xFF,0x00,0x00,0x00,0x00,0x00,0x0F,0xFD,
0xFF,0xC0,0x00,0x00,0x00,0x01,0xFF,0xBF,0xF0,0x00,
0x00,0x00,0x00,0x00,0x7F,0xFF,0xFE,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xFF,0x80,0x00,0x01,0x00,0x00,0x00,
0x7F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,
0x80,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x3F,0xFF,0xF8,0x00,0x00,0x08,0x00,
0x00,0x01,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x1F,
0xFF,0xF8,0x00,0x00,0x08,0x00,0x00,0x00,0xFF,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x1F,0xFF,0xF0,0x00,0x00,
0x08,0x00,0x00,0x00,0xFF,0xFF,0x80,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xF0,0x00,0x00,0x08,0x00,0x00,0x00,
0x7F,0xFF,0x80,0x00,0x00,0x00,0x00,0x0F,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x00,0x3F,0xFF,0x00,0x00,0x00,0x00,0x15,
0xAF,0x84,0x01,0x64,0x0F,0xFF,0xF0,0x00,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x00,0x1F,0xFF,0xC0,0x1F,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,0x1F,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x01,0xFF,0xFC,0x00,0x1F,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x07,0xFF,0xF0,0x00,0x3F,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x0F,0xFF,0xE0,0x00,
0x3F,0xFF,0xC0,0x00,0x00,0x00,0x00,0x3F,0xFF,0x80,
0x00,0x3F,0xFF,0xC0,0x00,0x00,0x00,0x00,0xFF,0xFE,
0x00,0x00,0x3F,0xFF,0x80,0x00,0x00,0x00,0x01,0xFF,
0xF8,0x00,0x00,0x7F,0xFF,0x80,0x00,0x00,0x00,0x07,
0xFF,0xF0,0x00,0x00,0x7F,0xFF,0x80,0x00,0x00,0x00,
0x1F,0xFF,0xC0,0x00,0x00,0x7F,0xFF,0x00,0x00,0x00,
0x00,0x7F,0xFF,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,
0x00,0x00,0xFF,0xFE,0x00,0x00,0x00,0xFF,0xFF,0x00,
0x00,0x00,0x03,0xFF,0xF8,0x00,0x00,0x00,0xFF,0xFE,
0x00,0x00,0x00,0x0F,0xFF,0xE0,0x00,0x00,0x01,0xFF,
0xFE,0x00,0x00,0x00,0x3F,0xFF,0x80,0x00,0x00,0x01,
0xFF,0xFE,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,0x00,
0x01,0xFF,0xFC,0x00,0x00,0x01,0xFF,0xFC,0x00,0x00,
0x00,0x03,0xFF,0xFC,0x00,0x00,0x07,0xFF,0xF0,0x00,
0x00,0x00,0x03,0xFF,0xFC,0x00,0x00,0x1F,0xFF,0xC0,
0x00,0x00,0x00,0x03,0xFF,0xFC,0x00,0x00,0x3F,0xFF,
0x80,0x00,0x00,0x00,0x03,0xFF,0xF8,0x00,0x00,0xFF,
0xFE,0x00,0x00,0x00,0x00,0x07,0xFF,0xF8,0x00,0x03,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x07,0xFF,0xF8,0x00,
0x0F,0xFF,0xF0,0x00,0x00,0x00,0x00,0x07,0xFF,0xF0,
0x00,0x1F,0xFF,0xC0,0x00,0x00,0x00,0x00,0x0F,0xFF,
0xF0,0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xF0,0x01,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFF,0xE0,0x07,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x00,0x1F,0xFF,0xE0,0x0F,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0x1F,0xFF,0xE0,0x3F,0xFF,0x80,0x00,0x00,
0x00,0x00,0x00,0x1F,0xFF,0xC0,0xFF,0xFE,0x00,0x00,
0x00,0x00,0x00,0x00,0x1F,0xFF,0xC1,0xFF,0xFC,0x00,
0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xC7,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x9F,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFF,
0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,
0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,
0xFF,0xFF,0xF8,0x00,0x00,0x00,0x40,0x00,0x00,0x00,
0x0F,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x40,
0x00,0x00,0x00,0x01,0xFF,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0x80,0x00,0x00,
0x00,0x20,0x00,0x00,0x00,0x00,0x3F,0xFF,0xC0,0x00,
0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x1F,0xFF,0xF8,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,
0xFF,0xF8,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x04,0x00,0x00,
0x00,0x01,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x00,0x00,0x07,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x00,0x00,0x7F,0xFF,0x9F,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x00,0x00,0xFF,0xFE,0x3F,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xF8,0x3F,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xF0,0x3F,
0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xC0,
0x7F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,
0x00,0x7F,0xFF,0x80,0x00,0x00,0x00,0x00,0x01,0xFF,
0xFC,0x00,0x7F,0xFF,0x80,0x00,0x00,0x00,0x00,0x07,
0xFF,0xF8,0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,
0x1F,0xFF,0xE0,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x00,0x3F,0xFF,0x80,0x00,0xFF,0xFF,0x00,0x00,0x00,
0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFE,0x00,0x00,
0x00,0x00,0x03,0xFF,0xFC,0x00,0x01,0xFF,0xFE,0x00,
0x00,0x00,0x00,0x0F,0xFF,0xF0,0x00,0x01,0xFF,0xFE,
0x00,0x00,0x00,0x00,0x1F,0xFF,0xC0,0x00,0x01,0xFF,
0xFC,0x00,0x00,0x00,0x00,0x7F,0xFF,0x80,0x00,0x03,
0xFF,0xFC,0x00,0x00,0x00,0x01,0xFF,0xFE,0x00,0x00,
0x03,0xFF,0xFC,0x00,0x00,0x00,0x07,0xFF,0xF8,0x00,
0x00,0x03,0xFF,0xFC,0x00,0x00,0x00,0x0F,0xFF,0xE0,
0x00,0x00,0x03,0xFF,0xF8,0x00,0x00,0x00,0x3F,0xFF,
0xC0,0x00,0x00,0x07,0xFF,0xF8,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x07,0xFF,0xF8,0x00,0x00,0x01,
0xFF,0xFC,0x00,0x00,0x00,0x07,0xFF,0xF0,0x00,0x00,
0x07,0xFF,0xF8,0x00,0x00,0x00,0x0F,0xFF,0xF0,0x00,
0x00,0x1F,0xFF,0xE0,0x00,0x00,0x00,0x0F,0xFF,0xF0,
0x00,0x00,0x7F,0xFF,0x80,0x00,0x00,0x00,0x0F,0xFF,
0xE0,0x00,0x00,0xFF,0xFE,0x00,0x00,0x00,0x00,0x1F,
0xFF,0xE0,0x00,0x03,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x1F,0xFF,0xE0,0x00,0x0F,0xFF,0xF0,0x00,0x00,0x00,
0x00,0x1F,0xFF,0xE0,0x00,0x3F,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x1F,0xFF,0xC0,0x00,0x7F,0xFF,0x00,0x00,
0x00,0x00,0x00,0x3F,0xFF,0xC0,0x01,0xFF,0xFE,0x00,
0x00,0x00,0x00,0x00,0x3F,0xFF,0xC0,0x07,0xFF,0xF8,
0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x80,0x1F,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x80,0x3F,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x80,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,
0x03,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x0F,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0xFF,0x1F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0xFF,0x7F,0xFF,0x80,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0xFE,0x15,0xEF,0x80,0x01,0x5D,0xFF,
0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xFC,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,
0xF8,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x07,
0xFF,0xF0,0x7F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFF,0xF0,0x3F,0xFF,0x80,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xE0,0x1F,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x00,0x1F,0xFF,0xC0,0x1F,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x00,0x3F,0xFF,0xC0,0x0F,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x00,0x3F,0xFF,0x80,0x07,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,0x03,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x03,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0xFF,0xFE,0x00,
0x01,0xFF,0xFC,0x00,0x00,0x00,0x00,0x01,0xFF,0xFC,
0x00,0x00,0xFF,0xFE,0x00,0x00,0x00,0x00,0x03,0xFF,
0xFC,0x00,0x00,0xFF,0xFE,0x00,0x00,0x00,0x00,0x03,
0xFF,0xF8,0x00,0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,
0x07,0xFF,0xF0,0x00,0x00,0x3F,0xFF,0x80,0x00,0x00,
0x00,0x07,0xFF,0xF0,0x00,0x00,0x3F,0xFF,0x80,0x00,
0x00,0x00,0x0F,0xFF,0xE0,0x00,0x00,0x1F,0xFF,0xC0,
0x00,0x00,0x00,0x1F,0xFF,0xC0,0x00,0x00,0x0F,0xFF,
0xE0,0x00,0x00,0x00,0x1F,0xFF,0xC0,0x00,0x00,0x0F,
0xFF,0xE0,0x00,0x00,0x00,0x3F,0xFF,0x80,0x00,0x00,
0x07,0xFF,0xF0,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,
0x00,0x03,0xFF,0xF8,0x00,0x00,0x00,0x7F,0xFF,0x00,
0x00,0x00,0x03,0xFF,0xF8,0x00,0x00,0x00,0xFF,0xFE,
0x00,0x00,0x00,0x01,0xFF,0xFC,0x00,0x00,0x01,0xFF,
0xFC,0x00,0x00,0x00,0x00,0xFF,0xFC,0x00,0x00,0x01,
0xFF,0xFC,0x00,0x00,0x00,0x00,0xFF,0xFE,0x00,0x00,
0x03,0xFF,0xF8,0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,
0x00,0x07,0xFF,0xF0,0x00,0x00,0x00,0x00,0x3F,0xFF,
0x00,0x00,0x07,0xFF,0xF0,0x00,0x00,0x00,0x00,0x3F,
0xFF,0x80,0x00,0x0F,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x1F,0xFF,0xC0,0x00,0x1F,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xC0,0x00,0x1F,0xFF,0x80,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xE0,0x00,0x3F,0xFF,0x80,0x00,
0x00,0x00,0x00,0x07,0xFF,0xF0,0x00,0x3F,0xFF,0x00,
0x00,0x00,0x00,0x00,0x03,0xFF,0xF0,0x00,0x7F,0xFE,
0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xF8,0x00,0xFF,
0xFE,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xFC,0x00,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFC,
0x01,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFE,0x03,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,
0x7F,0xFE,0x03,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,
0x00,0x3F,0xFF,0x07,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x00,0x00,0x3F,0xFF,0x8F,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0x00,0x1F,0xFF,0x8F,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x00,0x00,0x0F,0xFF,0xDF,0xFF,0x80,0x00,
0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0x80,
0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,
0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,
0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x7F,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x7F,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3F,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xC0,0x00,
0x00,0x00,0x03,0x40,0x00,0x00,0x00,0x01,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x68,0x00,0x00,0x00,0x00,0x3F,
0xFE,0x00,0x00,0x00,0x00,0x0D,0x00,0x00,0x00,0x00,
0x07,0xFF,0xC0,0x00,0x00,0x00,0x01,0xA0,0x00,0x00,
0x00,0x00,0xFF,0xF8,0x00,0x00,0x00,0x00,0x34,0x00,
0x00,0x00,0x00,0x1F,0xFF,0x00,0x00,0x00,0x00,0x06,
0x00,0x00,0x00,0x00,0x03,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x12,0xEF,0x8C,0x01,0x47,0x40,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xE5,0x01,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,
0x00,0x00,0x07,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x07,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xFE,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xFC,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x80,0x00,
0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xF0,0x00,0x00,
0x00,0x00,0x00,0x00,0x01,0xFF,0xFE,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3F,0xFF,0xE0,0x00,0x00,0x00,
0x00,0x00,0x00,0x07,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x7F,0xFF,0x80,0x00,0x00,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,
0x00,0x01,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x3F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x7F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xFC,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x80,
0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xF8,0x00,
0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0xFF,0xFC,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x7F,0xFF,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x0F,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x00,0x00,0x01,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,
0x00,0x03,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x7F,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,
0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xF8,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xFE,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x00,0x00,0x07,0xFF,0xF8,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x1F,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x00,0x00,0x03,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x7F,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,
0x00,0x07,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x1F,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x03,
0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xFE,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x1F,0xFF,0xF0,0x00,0x00,0x00,
0x00,0x00,0x00,0x03,0xFF,0xFE,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x3F,0xFF,0xC0,0x00,0x00,0x00,0x00,
0x00,0x00,0x07,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,
0x00,0x1F,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x07,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xDF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x5F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x06,
0x7C,0xA3,0x98,0x97,0x7F,0xFF,0xFF,0xF5,0xFF,0xFF,
0xFF,0xDF,0xFF,0x00,0x06,0xFF,0xF8,0x00,0x37,0xFF,
0xC0,0x01,0xBF,0xFE,0x00,0x0D,0xFF,0xF0,0x00,0x6F,
0xFF,0x80,0x03,0x7F,0xFC,0x00,0x1B,0xFF,0xE0,0x00,
0xDF,0xFF,0x00,0x06,0xFF,0xF8,0x00,0x37,0xFF,0xC0,
0x01,0xBF,0xFE,0x00,0x0D,0xFF,0xF0,0x00,0x6F,0xFF,
0x80,0x01,0xFF,0xE0,0x00,0xDF,0xFF,0xFF,0xFD,0x7F,
0xFF,0xFF,0xC0,0x09,0xAF,0x84,0x00,0x96,0x3F,0xF0,
0x00,0x00,0x00,0x7F,0xF0,0x00,0x00,0x01,0x0F,0xFC,
0x00,0x00,0x00,0x1F,0xFC,0x00,0x00,0x00,0x93,0xFF,
0x00,0x00,0x00,0x07,0xFF,0x00,0x00,0x00,0x40,0xFF,
0xC0,0x00,0x00,0x01,0xFF,0xC0,0x00,0x00,0x20,0x3F,
0xF0,0x00,0x00,0x08,0x0F,0xFE,0x00,0x00,0x02,0x01,
0xFF,0x80,0x00,0x00,0x03,0xFF,0x80,0x00,0x01,0x00,
0x7F,0xE0,0x00,0x00,0x00,0xFF,0xE0,0x00,0x00,0x80,
0x1F,0xF8,0x00,0x00,0x20,0x07,0xFF,0x00,0x00,0x08,
0x00,0xFF,0xC0,0x00,0x00,0x01,0xFF,0xC0,0x00,0x04,
0x00,0x3F,0xF0,0x00,0x00,0x00,0x7F,0xF0,0x00,0x02,
0x40,0x0F,0xFC,0x00,0x00,0x00,0x1F,0xFC,0x00,0x01,
0x00,0x03,0xFF,0x00,0x00,0x00,0x07,0xFF,0x00,0x00,
0x80,0x00,0xFF,0xC0,0x00,0x20,0x00,0x3F,0xF8,0x00,
0x08,0x00,0x07,0xFE,0x00,0x00,0x00,0x0F,0xFE,0x00,
0x04,0x00,0x01,0xFF,0x80,0x00,0x00,0x03,0xFF,0x80,
0x02,0x40,0x00,0x7F,0xE0,0x00,0x00,0x00,0xFF,0xE0,
0x01,0x00,0x00,0x1F,0xF8,0x00,0x00,0x00,0x3F,0xF8,
0x00,0x80,0x00,0x07,0xFE,0x00,0x20,0x00,0x01,0xFF,
0xC0,0x08,0x00,0x00,0x3F,0xF0,0x00,0x00,0x00,0x7F,
0xF0,0x04,0x00,0x00,0x0F,0xFC,0x00,0x00,0x00,0x1F,
0xFC,0x02,0x40,0x00,0x03,0xFF,0x00,0x00,0x00,0x07,
0xFF,0x01,0x00,0x00,0x00,0xFF,0xC0,0x00,0x00,0x01,
0xFF,0xC0,0x80,0x00,0x00,0x3F,0xF0,0x20,0x00,0x00,
0x0F,0xFE,0x08,0x00,0x00,0x01,0xFF,0x80,0x00,0x00,
0x03,0xFF,0x84,0x00,0x00,0x00,0x7F,0xE0,0x00,0x00,
0x00,0xFF,0xE2,0x40,0x00,0x00,0x1F,0xF8,0x00,0x00,
0x00,0x3F,0xF9,0x00,0x00,0x00,0x07,0xFE,0x00,0x00,
0x00,0x0F,0xFE,0x80,0x00,0x00,0x01,0xFF,0xA0,0x00,
0x00,0x00,0x7F,0xF0,0x06,0x7C,0x93,0x98,0x97,0x7F,
0xFF,0xFF,0xF5,0xFF,0xFF,0xFF,0xD0,0x00,0x7F,0xFE,
0x80,0x03,0xFF,0xF4,0x00,0x1F,0xFF,0xA0,0x00,0xFF,
0xFD,0x00,0x07,0xFF,0xE8,0x00,0x3F,0xFF,0x40,0x01,
0xFF,0xFA,0x00,0x0F,0xFF,0xD0,0x00,0x7F,0xFE,0x80,
0x03,0xFF,0xF4,0x00,0x1F,0xFF,0xA0,0x00,0xFF,0xFD,
0x00,0x07,0xFF,0xE8,0x00,0x3F,0xFC,0x00,0x0F,0xFF,
0xDF,0xFF,0xFF,0xFD,0x7F,0xFF,0xFF,0xC0,0x0D,0x59,
0x90,0xB8,0xF6,0x00,0x00,0x01,0xFF,0xC0,0x00,0x01,
0x20,0x00,0x01,0xFF,0xF0,0x00,0x00,0x80,0x00,0x01,
0xFF,0xFC,0x00,0x00,0x40,0x00,0x01,0xFF,0xFF,0x00,
0x00,0x24,0x00,0x01,0xFF,0xFF,0xC0,0x00,0x10,0x00,
0x01,0xFF,0xBF,0xF0,0x00,0x00,0x00,0x0F,0xFE,0xFF,
0xE0,0x00,0x00,0x00,0x3F,0xF1,0xFF,0x80,0x00,0x00,
0x01,0xFF,0xC7,0xFF,0x00,0x02,0x00,0x00,0xFF,0xC1,
0xFF,0x80,0x00,0x00,0x07,0xFF,0x07,0xFF,0x00,0x00,
0x00,0x1F,0xF8,0x0F,0xFC,0x00,0x00,0x00,0xFF,0xE0,
0x3F,0xF8,0x00,0x00,0x03,0xFF,0x00,0x7F,0xE0,0x01,
0x00,0x03,0xFF,0x80,0x3F,0xF8,0x00,0x00,0x0F,0xFC,
0x00,0x7F,0xF0,0x02,0x00,0x0F,0xFE,0x00,0x3F,0xF8,
0x01,0x00,0x0F,0xFE,0x00,0x0F,0xFE,0x00,0x80,0x0F,
0xFE,0x00,0x03,0xFF,0x80,0x00,0x7F,0xF8,0x00,0x0F,
0xFF,0x01,0x00,0x3F,0xF8,0x00,0x03,0xFF,0x80,0x80,
0x3F,0xF8,0x00,0x00,0xFF,0xE0,0x01,0xFF,0xE0,0x00,
0x03,0xFF,0xC0,0x07,0xFF,0x00,0x00,0x07,0xFF,0x04,
0x07,0xFF,0x80,0x00,0x03,0xFF,0xC0,0x1F,0xFC,0x00,
0x00,0x07,0xFF,0x00,0xFF,0xF0,0x00,0x00,0x1F,0xFE,
0x03,0xFF,0x80,0x00,0x00,0x3F,0xF8,0x83,0xFF,0xC0,
0x00,0x00,0x1F,0xFE,0x43,0xFF,0xC0,0x00,0x00,0x07,
0xFF,0x8F,0xFE,0x00,0x00,0x00,0x0F,0xFE,0x8F,0xFF,
0x00,0x00,0x00,0x07,0xFF,0x80,0x13,0x44,0x7B,0x99,
0x2B,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF8,0x06,0x09,0x19,0x34,0xB1,0xFF,0xFC,0x00,0x7F,
0xFF,0x00,0x1F,0xFF,0x80,0x07,0xFF,0xE0,0x01,0xFF,
0xF0,0x10,0x0F,0xFF,0x80,0x03,0xFF,0xE0,0x00,0xFF,
0xF0,0x00,0x3F,0xFC,0x00,0x0F,0xFE,0x10,0x00,0x7F,
0xF0,0x00,0x1F,0xFC,0x00,0x07,0xFE,0x00,0x01,0xFF,
0x80,0x00,0x7F,0xC0,0x00,0x1F,0xF0,0x10,0x23,0x97,
0xFD,0x28,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x3F,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x7F,0xFF,
0xFF,0xFF,0xF8,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,
0xFE,0x00,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,
0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x01,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x01,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x01,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xE0,0x00,0xFF,0xFF,0xE0,0x01,0xFF,0xFF,0xF0,0x00,
0xFF,0xFF,0x80,0x00,0x1F,0xFF,0xFC,0x00,0xFF,0xFF,
0x00,0x00,0x03,0xFF,0xFE,0x00,0x7F,0xFF,0x00,0x00,
0x00,0x7F,0xFF,0x00,0x3F,0xFF,0x00,0x00,0x00,0x1F,
0xFF,0x80,0x3F,0xFF,0x00,0x00,0x00,0x07,0xFF,0xE1,
0x03,0xFF,0xE0,0x00,0x00,0x00,0x7F,0xFE,0x10,0x7F,
0xFC,0x00,0x00,0x00,0x03,0xFF,0xE0,0x07,0xFC,0x00,
0x00,0x00,0x01,0xFF,0xF0,0x00,0x0E,0x00,0x00,0x00,
0x00,0xFF,0xF8,0x48,0x00,0x00,0x00,0x00,0x00,0x0F,
0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x07,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x7F,0xFF,0xFF,
0xFF,0xFC,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xFE,
0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,
0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC0,0x01,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xE0,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF0,0x01,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xF8,0x01,
0xFF,0xFF,0xFF,0xFF,0xF0,0x7F,0xFC,0x01,0xFF,0xFF,
0xFF,0xFF,0x00,0x3F,0xFE,0x01,0xFF,0xFF,0xFF,0xC0,
0x00,0x1F,0xFF,0x00,0xFF,0xFF,0xF0,0x00,0x00,0x0F,
0xFF,0x80,0xFF,0xFF,0x80,0x00,0x00,0x07,0xFF,0xC0,
0x7F,0xFF,0x00,0x00,0x00,0x03,0xFF,0xE0,0x7F,0xFE,
0x00,0x00,0x00,0x01,0xFF,0xF0,0x3F,0xFE,0x00,0x00,
0x00,0x00,0xFF,0xF8,0x1F,0xFE,0x00,0x00,0x00,0x00,
0xFF,0xFC,0x1F,0xFF,0x00,0x00,0x00,0x00,0x7F,0xFE,
0x0F,0xFF,0x00,0x00,0x00,0x00,0x3F,0xFF,0x08,0xFF,
0xF0,0x00,0x00,0x00,0x07,0xFF,0xF0,0x8F,0xFF,0x00,
0x00,0x00,0x00,0xFF,0xFF,0x07,0xFF,0x80,0x00,0x00,
0x00,0xFF,0xFF,0x83,0xFF,0xE0,0x00,0x00,0x00,0xFF,
0xFF,0xC1,0xFF,0xF8,0x00,0x00,0x01,0xFF,0xFF,0xE0,
0x7F,0xFC,0x00,0x00,0x01,0xFF,0xFF,0xF0,0x3F,0xFF,
0x80,0x00,0x03,0xFF,0xFF,0xF8,0x1F,0xFF,0xE0,0x00,
0x07,0xFF,0xFF,0xFE,0x07,0xFF,0xFE,0x00,0x3F,0xFF,
0xFF,0xFF,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x80,0xFF,0xFF,0xFF,0xFF,0xFF,0xF7,0xFF,0xC0,0x7F,
0xFF,0xFF,0xFF,0xFF,0xF3,0xFF,0xE0,0x1F,0xFF,0xFF,
0xFF,0xFF,0xF0,0xFF,0xF0,0x07,0xFF,0xFF,0xFF,0xFF,
0xE0,0x7F,0xFC,0x01,0xFF,0xFF,0xFF,0xFF,0xE0,0x3F,
0xFE,0x00,0x7F,0xFF,0xFF,0xFF,0xC0,0x0F,0xFF,0x00,
0x0F,0xFF,0xFF,0xFF,0x80,0x07,0xFF,0xC0,0x03,0xFF,
0xFF,0xFF,0x00,0x01,0xFF,0xE0,0x00,0x3F,0xFF,0xFC,
0x00,0x00,0x7F,0xF8,0x00,0x01,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x0F,0x30,0x27,0xFD,0x2B,0x7F,0xFC,0x00,
0x00,0x00,0x00,0x00,0x03,0x7F,0xFC,0x00,0x00,0x00,
0x00,0x00,0x03,0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,
0x02,0xBF,0xFC,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,
0xE0,0x00,0x7F,0xE0,0x00,0x00,0x0F,0xFF,0x00,0x1F,
0xFF,0xF0,0x00,0x00,0x7F,0xF8,0x03,0xFF,0xFF,0xF0,
0x00,0x03,0xFF,0xC0,0x7F,0xFF,0xFF,0xE0,0x00,0x1F,
0xFE,0x07,0xFF,0xFF,0xFF,0x80,0x00,0xFF,0xF0,0xFF,
0xFF,0xFF,0xFF,0x00,0x07,0xFF,0x8F,0xFF,0xFF,0xFF,
0xFC,0x00,0x3F,0xFC,0xFF,0xFF,0xFF,0xFF,0xF0,0x01,
0xFF,0xE7,0xFF,0xFF,0xFF,0xFF,0xC0,0x0F,0xFF,0x7F,
0xFF,0xFF,0xFF,0xFF,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFC,0x03,0xFF,0xFF,0xFF,0x00,0xFF,0xFF,0xF0,
0x1F,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0x80,0xFF,0xFF,
0xFC,0x00,0x01,0xFF,0xFE,0x07,0xFF,0xFF,0x80,0x00,
0x07,0xFF,0xF0,0x3F,0xFF,0xF8,0x00,0x00,0x1F,0xFF,
0xC1,0xFF,0xFF,0x80,0x00,0x00,0x7F,0xFE,0x0F,0xFF,
0xF8,0x00,0x00,0x01,0xFF,0xF8,0x7F,0xFF,0x80,0x00,
0x00,0x07,0xFF,0xC3,0xFF,0xFC,0x00,0x00,0x00,0x1F,
0xFF,0x1F,0xFF,0xC0,0x00,0x00,0x00,0xFF,0xF8,0xFF,
0xFE,0x00,0x00,0x00,0x03,0xFF,0xC7,0xFF,0xE0,0x00,
0x00,0x00,0x1F,0xFE,0x3F,0xFF,0x00,0x00,0x00,0x00,
0xFF,0xFA,0xBF,0xFE,0x00,0x00,0x00,0x00,0x7F,0xF9,
0xFF,0xE0,0x00,0x00,0x00,0x03,0xFF,0xFB,0xFF,0xE0,
0x00,0x00,0x00,0x01,0xFF,0xF9,0xFF,0xE0,0x00,0x00,
0x00,0x01,0xFF,0xEF,0xFF,0x00,0x00,0x00,0x00,0x1F,
0xFE,0xAF,0xFF,0x80,0x00,0x00,0x00,0x1F,0xFE,0x7F,
0xFC,0x00,0x00,0x00,0x01,0xFF,0xF3,0xFF,0xF0,0x00,
0x00,0x00,0x0F,0xFF,0x1F,0xFF,0x80,0x00,0x00,0x00,
0xFF,0xF8,0xFF,0xFE,0x00,0x00,0x00,0x07,0xFF,0xC7,
0xFF,0xF0,0x00,0x00,0x00,0x7F,0xFC,0x3F,0xFF,0xC0,
0x00,0x00,0x03,0xFF,0xE1,0xFF,0xFF,0x00,0x00,0x00,
0x3F,0xFF,0x0F,0xFF,0xF8,0x00,0x00,0x03,0xFF,0xF0,
0x7F,0xFF,0xE0,0x00,0x00,0x3F,0xFF,0x83,0xFF,0xFF,
0x80,0x00,0x03,0xFF,0xF8,0x1F,0xFF,0xFF,0x00,0x00,
0x7F,0xFF,0x80,0xFF,0xFF,0xFE,0x00,0x07,0xFF,0xFC,
0x07,0xFF,0xFF,0xFE,0x01,0xFF,0xFF,0xC0,0x3F,0xFD,
0xFF,0xFF,0xFF,0xFF,0xFC,0x01,0xFF,0xEF,0xFF,0xFF,
0xFF,0xFF,0xC0,0x0F,0xFF,0x3F,0xFF,0xFF,0xFF,0xFC,
0x00,0x7F,0xF8,0xFF,0xFF,0xFF,0xFF,0xC0,0x03,0xFF,
0xC3,0xFF,0xFF,0xFF,0xFC,0x00,0x1F,0xFE,0x0F,0xFF,
0xFF,0xFF,0xC0,0x00,0xFF,0xF0,0x3F,0xFF,0xFF,0xFC,
0x00,0x07,0xFF,0x80,0xFF,0xFF,0xFF,0x80,0x00,0x3F,
0xFC,0x01,0xFF,0xFF,0xF0,0x00,0x01,0xFF,0xE0,0x03,
0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0x00,
0x00,0x00,0x0F,0x63,0x97,0xFD,0x0C,0x00,0x00,0x00,
0x7F,0xF8,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFE,
0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xFF,0x00,0x00,
0x00,0x00,0x7F,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x07,
0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x3F,0xFF,0xFF,
0xFF,0xFE,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFC,
0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,
0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x00,0x07,0xFF,0xFF,
0xFF,0xFF,0xFF,0xE0,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,
0xFF,0xC0,0x00,0xFF,0xFF,0xF0,0x07,0xFF,0xFF,0x00,
0x07,0xFF,0xFE,0x00,0x03,0xFF,0xFE,0x00,0x3F,0xFF,
0xE0,0x00,0x03,0xFF,0xF8,0x00,0xFF,0xFE,0x00,0x00,
0x07,0xFF,0xF0,0x07,0xFF,0xF0,0x00,0x00,0x0F,0xFF,
0xC0,0x1F,0xFF,0x80,0x00,0x00,0x1F,0xFF,0x80,0xFF,
0xFC,0x00,0x00,0x00,0x3F,0xFE,0x03,0xFF,0xE0,0x00,
0x00,0x00,0xFF,0xF8,0x83,0xFF,0xE0,0x00,0x00,0x00,
0x3F,0xFE,0x0F,0xFF,0x00,0x00,0x00,0x00,0x7F,0xC0,
0x3F,0xFC,0x00,0x00,0x00,0x01,0xC0,0x01,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x00,0x14,0xFF,0xF0,0x00,0x00,
0x00,0x00,0x00,0x0D,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x00,0x06,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x01,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x08,0x7F,0xF8,
0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xE0,0x00,0x00,
0x00,0x01,0xC0,0x07,0xFF,0x80,0x00,0x00,0x00,0x07,
0xFC,0x43,0xFF,0xE0,0x00,0x00,0x00,0x07,0xFF,0xC7,
0xFF,0x80,0x00,0x00,0x00,0x1F,0xFE,0x83,0xFF,0xE0,
0x00,0x00,0x00,0x1F,0xFF,0x07,0xFF,0xC0,0x00,0x00,
0x00,0xFF,0xFC,0x1F,0xFF,0x80,0x00,0x00,0x03,0xFF,
0xE0,0x3F,0xFF,0x00,0x00,0x00,0x1F,0xFF,0x80,0xFF,
0xFE,0x00,0x00,0x00,0xFF,0xFC,0x01,0xFF,0xFC,0x00,
0x00,0x07,0xFF,0xF0,0x07,0xFF,0xF8,0x00,0x00,0x7F,
0xFF,0x80,0x0F,0xFF,0xF8,0x00,0x07,0xFF,0xFE,0x00,
0x1F,0xFF,0xFE,0x00,0xFF,0xFF,0xF0,0x00,0x7F,0xFF,
0xFF,0xFF,0xFF,0xFF,0x80,0x00,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFC,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,
0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x03,
0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x07,0xFF,0xFF,
0xFF,0xFF,0xC0,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFE,
0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xE0,0x00,0x00,
0x00,0x0F,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x07,
0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x01,0xFF,0xF0,
0x00,0x00,0x00,0x0F,0x30,0x17,0xFD,0x2B,0x40,0x00,
0x00,0x00,0x00,0x00,0x3F,0xFF,0x40,0x00,0x00,0x00,
0x00,0x00,0x3F,0xFF,0x40,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFE,0x80,0x00,0x00,0x00,0x00,0x00,0x3F,0xFC,
0x00,0x00,0x01,0xFF,0x80,0x01,0xFF,0xE0,0x00,0x00,
0xFF,0xFF,0x80,0x0F,0xFF,0x00,0x00,0x3F,0xFF,0xFF,
0x00,0x7F,0xF8,0x00,0x07,0xFF,0xFF,0xFE,0x03,0xFF,
0xC0,0x00,0x7F,0xFF,0xFF,0xF8,0x1F,0xFE,0x00,0x0F,
0xFF,0xFF,0xFF,0xE0,0xFF,0xF0,0x00,0xFF,0xFF,0xFF,
0xFF,0xC7,0xFF,0x80,0x0F,0xFF,0xFF,0xFF,0xFE,0x3F,
0xFC,0x00,0xFF,0xFF,0xFF,0xFF,0xF9,0xFF,0xE0,0x0F,
0xFF,0xFF,0xFF,0xFF,0xEF,0xFF,0x00,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xF8,0x0F,0xFF,0xFF,0x00,0xFF,0xFF,
0xFF,0xC0,0x7F,0xFF,0xC0,0x00,0xFF,0xFF,0xFE,0x07,
0xFF,0xF8,0x00,0x03,0xFF,0xFF,0xF0,0x3F,0xFF,0x80,
0x00,0x07,0xFF,0xFF,0x83,0xFF,0xF0,0x00,0x00,0x1F,
0xFF,0xFC,0x1F,0xFF,0x00,0x00,0x00,0x7F,0xFF,0xE1,
0xFF,0xF8,0x00,0x00,0x01,0xFF,0xFF,0x0F,0xFF,0x80,
0x00,0x00,0x07,0xFF,0xF8,0x7F,0xF8,0x00,0x00,0x00,
0x3F,0xFF,0xC7,0xFF,0xC0,0x00,0x00,0x00,0xFF,0xFE,
0x3F,0xFC,0x00,0x00,0x00,0x07,0xFF,0xF1,0xFF,0xE0,
0x00,0x00,0x00,0x1F,0xFF,0x9F,0xFF,0x00,0x00,0x00,
0x00,0xFF,0xFC,0xFF,0xF0,0x00,0x00,0x00,0x07,0xFF,
0xF2,0xFF,0xF0,0x00,0x00,0x00,0x03,0xFF,0xEF,0xFF,
0x00,0x00,0x00,0x00,0x1F,0xFF,0xDF,0xFF,0x00,0x00,
0x00,0x00,0x0F,0xFF,0xDF,0xFF,0x00,0x00,0x00,0x00,
0x0F,0xFF,0xA7,0xFF,0x80,0x00,0x00,0x00,0x1F,0xFF,
0x3F,0xFE,0x00,0x00,0x00,0x01,0xFF,0xF8,0xFF,0xF0,
0x00,0x00,0x00,0x0F,0xFF,0xC7,0xFF,0xC0,0x00,0x00,
0x00,0x7F,0xFE,0x3F,0xFE,0x00,0x00,0x00,0x07,0xFF,
0xF0,0xFF,0xF8,0x00,0x00,0x00,0x3F,0xFF,0x87,0xFF,
0xC0,0x00,0x00,0x03,0xFF,0xFC,0x3F,0xFF,0x00,0x00,
0x00,0x3F,0xFF,0xE0,0xFF,0xFC,0x00,0x00,0x03,0xFF,
0xFF,0x07,0xFF,0xF0,0x00,0x00,0x1F,0xFF,0xF8,0x1F,
0xFF,0xC0,0x00,0x03,0xFF,0xFF,0xC0,0x7F,0xFF,0x00,
0x00,0x3F,0xFF,0xFE,0x03,0xFF,0xFE,0x00,0x07,0xFF,
0xFF,0xF0,0x0F,0xFF,0xFE,0x01,0xFF,0xFF,0xFF,0xC0,
0x07,0xFF,0xFF,0xFF,0xFF,0xF7,0xFF,0x80,0x1F,0xFF,
0xFF,0xFF,0xFF,0x3F,0xFC,0x00,0x7F,0xFF,0xFF,0xFF,
0xF1,0xFF,0xE0,0x01,0xFF,0xFF,0xFF,0xFF,0x0F,0xFF,
0x00,0x03,0xFF,0xFF,0xFF,0xF0,0x7F,0xF8,0x00,0x0F,
0xFF,0xFF,0xFF,0x03,0xFF,0xC0,0x00,0x1F,0xFF,0xFF,
0xF0,0x1F,0xFE,0x00,0x00,0x3F,0xFF,0xFE,0x00,0xFF,
0xF0,0x00,0x00,0x7F,0xFF,0xC0,0x07,0xFF,0x80,0x00,
0x00,0x3F,0xF0,0x00,0x00,0x00,0x10,0x23,0x97,0xFD,
0x28,0x00,0x00,0x00,0x7F,0xF8,0x00,0x00,0x00,0x00,
0x00,0x03,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0xFF,0xC0,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xF0,
0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xFE,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x7F,
0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x7F,0xFF,0xFF,
0xFF,0xFF,0xF8,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,
0xFE,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,
0x00,0x7F,0xFF,0xF8,0x01,0xFF,0xFF,0xE0,0x00,0x7F,
0xFF,0xC0,0x00,0x0F,0xFF,0xF8,0x00,0x3F,0xFF,0x80,
0x00,0x01,0xFF,0xFE,0x00,0x3F,0xFF,0x80,0x00,0x00,
0x3F,0xFF,0x00,0x1F,0xFF,0x00,0x00,0x00,0x0F,0xFF,
0xC0,0x1F,0xFF,0x00,0x00,0x00,0x03,0xFF,0xE0,0x0F,
0xFF,0x00,0x00,0x00,0x00,0xFF,0xF8,0x0F,0xFF,0x00,
0x00,0x00,0x00,0x3F,0xFC,0x07,0xFF,0x00,0x00,0x00,
0x00,0x0F,0xFF,0x07,0xFF,0x80,0x00,0x00,0x00,0x07,
0xFF,0x90,0x7F,0xF0,0x00,0x00,0x00,0x00,0x3F,0xF8,
0x7F,0xF8,0x00,0x00,0x00,0x00,0x1F,0xFE,0x97,0xFF,
0x00,0x00,0x00,0x00,0x00,0xFF,0xE3,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF6,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xCF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFD,0x7F,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x25,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x00,0x02,0x1F,0xFF,0x00,
0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,
0x00,0x01,0xC0,0x03,0xFF,0xE0,0x00,0x00,0x00,0x01,
0xFF,0x81,0xFF,0xF0,0x00,0x00,0x00,0x00,0xFF,0xF0,
0xFF,0xFC,0x00,0x00,0x00,0x00,0xFF,0xF8,0x3F,0xFF,
0x00,0x00,0x00,0x00,0xFF,0xFC,0x1F,0xFF,0xC0,0x00,
0x00,0x00,0x7F,0xFC,0x07,0xFF,0xF0,0x00,0x00,0x00,
0x7F,0xFE,0x03,0xFF,0xFC,0x00,0x00,0x00,0x7F,0xFE,
0x00,0xFF,0xFF,0x00,0x00,0x00,0xFF,0xFF,0x00,0x7F,
0xFF,0xE0,0x00,0x00,0xFF,0xFF,0x00,0x1F,0xFF,0xFC,
0x00,0x01,0xFF,0xFF,0x80,0x07,0xFF,0xFF,0xC0,0x0F,
0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x80,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x00,
0x1F,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x07,0xFF,
0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x01,0xFF,0xFF,0xFF,
0xFF,0xFF,0x80,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,
0x80,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0x00,0x00,
0x00,0x01,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x3F,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x03,0xFF,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0x80,
0x00,0x00,0x00,0x0A,0x30,0x08,0x00,0x94,0x00,0x00,
0x03,0xFF,0xE0,0x00,0x00,0x1F,0xFF,0xFF,0x00,0x00,
0x3F,0xFF,0xFF,0x80,0x00,0x3F,0xFF,0xFF,0xC0,0x00,
0x3F,0xFF,0xFF,0xC0,0x00,0x3F,0xFF,0xFF,0xE0,0x00,
0x3F,0xFF,0xFF,0xF0,0x00,0x3F,0xFF,0xFF,0xFA,0x00,
0x07,0xFF,0xFF,0xFF,0x80,0x03,0xFF,0xFF,0xFF,0x80,
0x03,0xFF,0xFE,0x00,0x40,0x01,0xFF,0xFC,0x00,0x04,
0x00,0x1F,0xFF,0x00,0x00,0x68,0x01,0xFF,0xE0,0x00,
0x05,0x80,0x1F,0xFE,0x00,0x00,0x6F,0xFF,0xFF,0xFF,
0xFF,0x05,0x7F,0xFF,0xFF,0xFF,0xF0,0x68,0x01,0xFF,
0xE0,0x00,0x06,0x80,0x1F,0xFE,0x00,0x00,0x68,0x01,
0xFF,0xE0,0x00,0x06,0x80,0x1F,0xFE,0x00,0x00,0x68,
0x01,0xFF,0xE0,0x00,0x06,0x80,0x1F,0xFE,0x00,0x00,
0x68,0x01,0xFF,0xE0,0x00,0x06,0x80,0x1F,0xFE,0x00,
0x00,0x40,0x01,0xFF,0xE0,0x00,0x00,0x0F,0x30,0x97,
0x95,0x28,0x00,0x00,0x03,0xFF,0x00,0x00,0x00,0x00,
0x00,0x01,0xFF,0xFF,0x80,0x0F,0xFF,0x00,0x00,0x7F,
0xFF,0xFF,0x00,0x7F,0xF8,0x00,0x07,0xFF,0xFF,0xFE,
0x03,0xFF,0xC0,0x00,0xFF,0xFF,0xFF,0xF8,0x1F,0xFE,
0x00,0x0F,0xFF,0xFF,0xFF,0xE0,0xFF,0xF0,0x01,0xFF,
0xFF,0xFF,0xFF,0x87,0xFF,0x80,0x1F,0xFF,0xFF,0xFF,
0xFE,0x3F,0xFC,0x01,0xFF,0xFF,0xFF,0xFF,0xF9,0xFF,
0xE0,0x0F,0xFF,0xFF,0xFF,0xFF,0xEF,0xFF,0x00,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x0F,0xFF,0xFE,0x01,
0xFF,0xFF,0xFF,0xC0,0xFF,0xFF,0xC0,0x01,0xFF,0xFF,
0xFE,0x07,0xFF,0xF8,0x00,0x03,0xFF,0xFF,0xF0,0x7F,
0xFF,0x00,0x00,0x07,0xFF,0xFF,0x83,0xFF,0xF0,0x00,
0x00,0x1F,0xFF,0xFC,0x3F,0xFF,0x00,0x00,0x00,0x7F,
0xFF,0xF0,0x3F,0xFE,0x00,0x00,0x00,0x3F,0xFF,0xE3,
0xFF,0xE0,0x00,0x00,0x00,0xFF,0xFF,0x83,0xFF,0xC0,
0x00,0x00,0x00,0x7F,0xFF,0x3F,0xFE,0x00,0x00,0x00,
0x01,0xFF,0xFC,0x3F,0xFC,0x00,0x00,0x00,0x01,0xFF,
0xF9,0xFF,0xE0,0x00,0x00,0x00,0x07,0xFF,0xF3,0xFF,
0xC0,0x00,0x00,0x00,0x07,0xFF,0xF3,0xFF,0xC0,0x00,
0x00,0x00,0x03,0xFF,0xF3,0xFF,0xC0,0x00,0x00,0x00,
0x07,0xFF,0xDF,0xFF,0x00,0x00,0x00,0x00,0x3F,0xFF,
0x2F,0xFF,0x00,0x00,0x00,0x00,0x7F,0xFE,0x7F,0xFC,
0x00,0x00,0x00,0x07,0xFF,0xF1,0xFF,0xE0,0x00,0x00,
0x00,0x3F,0xFF,0x8F,0xFF,0x80,0x00,0x00,0x03,0xFF,
0xFC,0x3F,0xFC,0x00,0x00,0x00,0x1F,0xFF,0xE1,0xFF,
0xF0,0x00,0x00,0x01,0xFF,0xFF,0x0F,0xFF,0xC0,0x00,
0x00,0x1F,0xFF,0xF8,0x3F,0xFF,0x00,0x00,0x01,0xFF,
0xFF,0xC1,0xFF,0xFC,0x00,0x00,0x1F,0xFF,0xFE,0x07,
0xFF,0xF8,0x00,0x01,0xFF,0xFF,0xF0,0x1F,0xFF,0xE0,
0x00,0x3F,0xFF,0xFF,0x80,0xFF,0xFF,0xE0,0x0F,0xFF,
0xFF,0xFC,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE0,
0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x3F,0xFF,
0xFF,0xFF,0xFF,0x7F,0xF8,0x00,0xFF,0xFF,0xFF,0xFF,
0xF3,0xFF,0xC0,0x03,0xFF,0xFF,0xFF,0xFF,0x1F,0xFE,
0x00,0x0F,0xFF,0xFF,0xFF,0xF0,0xFF,0xF0,0x00,0x3F,
0xFF,0xFF,0xFF,0x07,0xFF,0x00,0x00,0x7F,0xFF,0xFF,
0xE0,0x3F,0xF8,0x00,0x00,0xFF,0xFF,0xFE,0x01,0xFF,
0xC0,0x00,0x01,0xFF,0xFF,0x80,0x1F,0xFE,0x00,0x00,
0x00,0xFF,0xE0,0x00,0xFF,0xF5,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0xF0,0xE0,0x00,0x00,0x00,0x00,0x07,
0xFF,0x87,0xFC,0x00,0x00,0x00,0x00,0x3F,0xF9,0x07,
0xFF,0x80,0x00,0x00,0x00,0x7F,0xF8,0x3F,0xFC,0x00,
0x00,0x00,0x07,0xFF,0xC1,0xFF,0xF0,0x00,0x00,0x00,
0x3F,0xFE,0x0F,0xFF,0x80,0x00,0x00,0x03,0xFF,0xE0,
0x7F,0xFE,0x00,0x00,0x00,0x3F,0xFF,0x01,0xFF,0xF8,
0x00,0x00,0x03,0xFF,0xF0,0x0F,0xFF,0xE0,0x00,0x00,
0x7F,0xFF,0x80,0x7F,0xFF,0xC0,0x00,0x0F,0xFF,0xF8,
0x01,0xFF,0xFF,0xC0,0x03,0xFF,0xFF,0xC0,0x07,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x3F,0xFF,0xFF,0xFF,
0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,
0x00,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x0F,
0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x3F,0xFF,0xFF,
0xFF,0xFF,0xC0,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xF8,
0x00,0x00,0x01,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x03,0xFF,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0xFF,0xFC,0x00,
0x00,0x00,0x0E,0x2F,0xA4,0x01,0x2B,0x7F,0xFC,0x00,
0x00,0x00,0x00,0x00,0x37,0xFF,0xC0,0x00,0x00,0x00,
0x00,0x03,0x7F,0xFC,0x00,0x00,0x00,0x00,0x00,0x2B,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x01,0xFF,0xE0,0x00,
0x3F,0xF8,0x00,0x00,0xFF,0xF0,0x00,0xFF,0xFF,0xC0,
0x00,0x7F,0xF8,0x03,0xFF,0xFF,0xFC,0x00,0x3F,0xFC,
0x03,0xFF,0xFF,0xFF,0x00,0x1F,0xFE,0x07,0xFF,0xFF,
0xFF,0xE0,0x0F,0xFF,0x07,0xFF,0xFF,0xFF,0xF8,0x07,
0xFF,0x87,0xFF,0xFF,0xFF,0xFE,0x03,0xFF,0xC7,0xFF,
0xFF,0xFF,0xFF,0x81,0xFF,0xE7,0xFF,0xFF,0xFF,0xFF,
0xE0,0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xF8,0x7F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFC,0x3F,0xFF,0xFF,0xF0,0x0F,
0xFF,0xFF,0x1F,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0x8F,
0xFF,0xFF,0x80,0x00,0x1F,0xFF,0xC7,0xFF,0xFF,0x00,
0x00,0x07,0xFF,0xF3,0xFF,0xFF,0x00,0x00,0x01,0xFF,
0xF9,0xFF,0xFF,0x00,0x00,0x00,0xFF,0xFC,0xFF,0xFF,
0x00,0x00,0x00,0x3F,0xFE,0x7F,0xFF,0x00,0x00,0x00,
0x0F,0xFF,0x4F,0xFF,0xE0,0x00,0x00,0x00,0xFF,0xFD,
0x7F,0xFC,0x00,0x00,0x00,0x07,0xFF,0xEF,0xFF,0x80,
0x00,0x00,0x00,0x7F,0xFE,0xFF,0xF8,0x00,0x00,0x00,
0x07,0xFF,0xEF,0xFF,0x80,0x00,0x00,0x00,0x7F,0xFE,
0xFF,0xF8,0x00,0x00,0x00,0x07,0xFF,0xEF,0xFF,0x80,
0x00,0x00,0x00,0x7F,0xFE,0xFF,0xF8,0x00,0x00,0x00,
0x07,0xFF,0xC7,0xFF,0x80,0x00,0x00,0x00,0x7F,0xF8,
0x03,0x2F,0xA4,0x00,0x7B,0x7F,0xFE,0xFF,0xFF,0x40,
0x03,0x40,0x03,0x7F,0xFF,0x7F,0xFF,0x7F,0xFF,0x7F,
0xFF,0x7F,0xFF,0x7F,0xFF,0x7F,0xFF,0x7F,0xFF,0x7F,
0xFF,0x3F,0xFC,0x06,0xFD,0x6B,0x94,0x7B,0x40,0x00,
0x7F,0xFD,0x80,0x00,0xFF,0xFD,0x00,0x00,0x00,0x1A,
0x00,0x00,0x00,0x34,0x00,0x07,0xFF,0xE8,0x00,0x0F,
0xFF,0xD0,0x00,0x1F,0xFF,0xA0,0x00,0x3F,0xFF,0x40,
0x00,0x7F,0xFE,0x80,0x00,0xFF,0xFD,0x00,0x01,0xFF,
0xFA,0x00,0x03,0xFF,0xF4,0x00,0x07,0xFF,0xE8,0x00,
0x0F,0xFF,0xC0,0x00,0x1F,0xFF,0x00,0x00,0x7F,0xFE,
0x80,0x00,0xFF,0xF0,0x00,0x1F,0xFF,0x00,0x03,0xFF,
0xF0,0xC0,0x7F,0xFE,0x41,0xFF,0xFF,0xFC,0x87,0xFF,
0xFF,0xF1,0x0F,0xFF,0xFF,0xC0,0xFF,0xFF,0xF8,0x1F,
0xFF,0xFF,0x01,0xFF,0xFF,0xC0,0x1F,0xFF,0xF0,0x00,
0x3F,0xF8,0x00,0x00,0x0E,0x6F,0xA4,0x01,0x0F,0x7F,
0xFC,0x00,0x00,0x00,0x00,0x00,0x1B,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x00,0xDF,0xFF,0x00,0x00,0x00,0x00,
0x00,0x05,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x1F,
0xFE,0x00,0x00,0x00,0x7F,0xFF,0x87,0xFF,0x80,0x00,
0x00,0x7F,0xFF,0xC1,0xFF,0xE0,0x00,0x00,0x3F,0xFF,
0xE0,0x7F,0xF8,0x00,0x00,0x1F,0xFF,0xF0,0x1F,0xFE,
0x00,0x00,0x0F,0xFF,0xF8,0x07,0xFF,0x80,0x00,0x07,
0xFF,0xFC,0x01,0xFF,0xE0,0x00,0x03,0xFF,0xFE,0x00,
0x7F,0xF8,0x00,0x01,0xFF,0xFF,0x00,0x1F,0xFE,0x00,
0x00,0xFF,0xFF,0x80,0x07,0xFF,0x80,0x00,0x7F,0xFF,
0xC0,0x01,0xFF,0xE0,0x00,0x3F,0xFF,0xE0,0x00,0x7F,
0xF8,0x00,0x1F,0xFF,0xF0,0x00,0x1F,0xFE,0x00,0x0F,
0xFF,0xF8,0x00,0x07,0xFF,0x80,0x07,0xFF,0xFC,0x00,
0x01,0xFF,0xE0,0x03,0xFF,0xFE,0x00,0x00,0x7F,0xF8,
0x01,0xFF,0xFF,0x00,0x00,0x1F,0xFE,0x00,0xFF,0xFF,
0x80,0x00,0x07,0xFF,0x80,0x7F,0xFF,0xC0,0x00,0x01,
0xFF,0xE0,0x3F,0xFF,0xE0,0x00,0x00,0x7F,0xF8,0x1F,
0xFF,0xF0,0x00,0x00,0x1F,0xFE,0x0F,0xFF,0xF8,0x00,
0x00,0x07,0xFF,0x87,0xFF,0xFC,0x00,0x00,0x01,0xFF,
0xE3,0xFF,0xFE,0x00,0x00,0x00,0x7F,0xFB,0xFF,0xFE,
0x00,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0x00,0x00,0x00,
0x07,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x02,0x3F,0xFF,
0xFF,0xFE,0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFF,0xC0,
0x00,0x00,0x04,0x7F,0xFF,0xFF,0xFF,0x00,0x00,0x00,
0x1F,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x08,0xFF,0xFF,
0xFF,0xFF,0x80,0x00,0x00,0x3F,0xFF,0xFB,0xFF,0xF0,
0x00,0x00,0x0F,0xFF,0xFC,0xFF,0xFE,0x00,0x00,0x03,
0xFF,0xFE,0x1F,0xFF,0x80,0x00,0x00,0xFF,0xFF,0x03,
0xFF,0xF0,0x00,0x00,0x3F,0xFF,0x80,0xFF,0xFE,0x00,
0x00,0x0F,0xFF,0xC0,0x1F,0xFF,0x80,0x00,0x03,0xFF,
0xE0,0x03,0xFF,0xF0,0x00,0x00,0xFF,0xF0,0x00,0xFF,
0xFE,0x00,0x00,0x3F,0xFC,0x00,0x1F,0xFF,0x80,0x00,
0x0F,0xFF,0x00,0x03,0xFF,0xF0,0x00,0x03,0xFF,0xC0,
0x00,0xFF,0xFE,0x00,0x00,0xFF,0xF0,0x00,0x1F,0xFF,
0x80,0x00,0x3F,0xFC,0x00,0x03,0xFF,0xF0,0x00,0x0F,
0xFF,0x00,0x00,0xFF,0xFE,0x00,0x03,0xFF,0xC0,0x00,
0x1F,0xFF,0x80,0x00,0xFF,0xF0,0x00,0x03,0xFF,0xF0,
0x00,0x3F,0xFC,0x00,0x00,0xFF,0xFE,0x00,0x0F,0xFF,
0x00,0x00,0x1F,0xFF,0x80,0x03,0xFF,0xC0,0x00,0x03,
0xFF,0xF0,0x00,0xFF,0xF0,0x00,0x00,0xFF,0xFE,0x00,
0x3F,0xFC,0x00,0x00,0x1F,0xFF,0x80,0x0F,0xFF,0x00,
0x00,0x03,0xFF,0xF0,0x03,0xFF,0xC0,0x00,0x00,0xFF,
0xFE,0x00,0xFF,0xF0,0x00,0x00,0x1F,0xFF,0x80,0x3F,
0xFC,0x00,0x00,0x03,0xFF,0xF0,0x0F,0xFF,0x00,0x00,
0x00,0xFF,0xFE,0x03,0xFF,0xC0,0x00,0x00,0x1F,0xFF,
0x80,0xFF,0xF0,0x00,0x00,0x03,0xFF,0xF0,0x3F,0xFC,
0x00,0x00,0x00,0xFF,0xFE,0x0F,0xFF,0x00,0x00,0x00,
0x1F,0xFF,0x83,0xFF,0xC0,0x00,0x00,0x03,0xFF,0xF0,
0xFF,0xF0,0x00,0x00,0x00,0xFF,0xFE,0x3F,0xFC,0x00,
0x00,0x00,0x1F,0xFF,0x8F,0xFF,0x00,0x00,0x00,0x03,
0xFF,0xF3,0xFF,0xC0,0x00,0x00,0x00,0xFF,0xFE,0x03,
0x2F,0xA4,0x00,0x7B,0x7F,0xFF,0x7F,0xFF,0x7F,0xFF,
0x7F,0xFF,0x7F,0xFF,0x7F,0xFF,0x7F,0xFF,0x7F,0xFF,
0x7F,0xFF,0x7F,0xFF,0x7F,0xFF,0x7F,0xFF,0x7F,0xFE,
0xBF,0xFC,0x17,0xA3,0x24,0x01,0xC0,0x00,0x00,0x00,
0x3F,0xF0,0x00,0x00,0x00,0x3F,0xF8,0x00,0x03,0xFF,
0xC0,0x03,0xFF,0xFE,0x00,0x00,0x03,0xFF,0xFF,0x00,
0x07,0xFF,0x80,0x1F,0xFF,0xFF,0x00,0x00,0x1F,0xFF,
0xFF,0x80,0x0F,0xFF,0x00,0xFF,0xFF,0xFF,0x00,0x00,
0xFF,0xFF,0xFF,0xC0,0x1F,0xFE,0x07,0xFF,0xFF,0xFF,
0x80,0x07,0xFF,0xFF,0xFF,0xC0,0x3F,0xFC,0x1F,0xFF,
0xFF,0xFF,0x80,0x1F,0xFF,0xFF,0xFF,0xC0,0x7F,0xF8,
0x7F,0xFF,0xFF,0xFF,0x00,0x7F,0xFF,0xFF,0xFF,0xC0,
0xFF,0xF1,0xFF,0xFF,0xFF,0xFF,0x01,0xFF,0xFF,0xFF,
0xFF,0xC1,0xFF,0xE7,0xFF,0xFF,0xFF,0xFF,0x07,0xFF,
0xFF,0xFF,0xFF,0x83,0xFF,0xDF,0xFF,0xFF,0xFF,0xFE,
0x1F,0xFF,0xFF,0xFF,0xFF,0x87,0xFF,0xBF,0xFF,0xFF,
0xFF,0xFE,0x3F,0xFF,0xFF,0xFF,0xFF,0x0F,0xFF,0xFF,
0xF8,0x07,0xFF,0xFC,0xFF,0xF8,0x07,0xFF,0xFF,0x1F,
0xFF,0xFF,0x80,0x03,0xFF,0xFF,0xFF,0x80,0x01,0xFF,
0xFE,0x3F,0xFF,0xFC,0x00,0x01,0xFF,0xFF,0xFC,0x00,
0x01,0xFF,0xFE,0x7F,0xFF,0xE0,0x00,0x01,0xFF,0xFF,
0xF0,0x00,0x00,0xFF,0xFC,0xFF,0xFF,0x80,0x00,0x03,
0xFF,0xFF,0xC0,0x00,0x01,0xFF,0xF9,0xFF,0xFE,0x00,
0x00,0x03,0xFF,0xFF,0x00,0x00,0x01,0xFF,0xF3,0xFF,
0xF8,0x00,0x00,0x07,0xFF,0xFC,0x00,0x00,0x01,0xFF,
0xE7,0xFF,0xF0,0x00,0x00,0x07,0xFF,0xF0,0x00,0x00,
0x03,0xFF,0xCF,0xFF,0xC0,0x00,0x00,0x0F,0xFF,0xE0,
0x00,0x00,0x07,0xFF,0xDF,0xFF,0x80,0x00,0x00,0x1F,
0xFF,0x80,0x00,0x00,0x0F,0xFF,0xBF,0xFE,0x00,0x00,
0x00,0x3F,0xFF,0x00,0x00,0x00,0x1F,0xFF,0x8F,0xFF,
0x80,0x00,0x00,0x07,0xFF,0xC0,0x00,0x00,0x03,0xFF,
0xDF,0xFF,0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,
0x07,0xFF,0xEF,0xFF,0x80,0x00,0x00,0x03,0xFF,0xC0,
0x00,0x00,0x01,0xFF,0xFB,0xFF,0xE0,0x00,0x00,0x00,
0xFF,0xF0,0x00,0x00,0x00,0x7F,0xFE,0xFF,0xF8,0x00,
0x00,0x00,0x3F,0xFC,0x00,0x00,0x00,0x1F,0xFF,0xBF,
0xFE,0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,0x07,
0xFF,0xEF,0xFF,0x80,0x00,0x00,0x03,0xFF,0xC0,0x00,
0x00,0x01,0xFF,0xFB,0xFF,0xE0,0x00,0x00,0x00,0xFF,
0xF0,0x00,0x00,0x00,0x7F,0xFC,0xFF,0xF8,0x00,0x00,
0x00,0x3F,0xFC,0x00,0x00,0x00,0x1F,0xFE,0x0E,0x23,
0x24,0x01,0x28,0x00,0x00,0x00,0x1F,0xFC,0x00,0x00,
0xFF,0xF0,0x00,0xFF,0xFF,0xC0,0x00,0x7F,0xF8,0x03,
0xFF,0xFF,0xFC,0x00,0x3F,0xFC,0x03,0xFF,0xFF,0xFF,
0x80,0x1F,0xFE,0x07,0xFF,0xFF,0xFF,0xE0,0x0F,0xFF,
0x07,0xFF,0xFF,0xFF,0xFC,0x07,0xFF,0x87,0xFF,0xFF,
0xFF,0xFF,0x03,0xFF,0xC7,0xFF,0xFF,0xFF,0xFF,0x81,
0xFF,0xE7,0xFF,0xFF,0xFF,0xFF,0xE0,0xFF,0xF7,0xFF,
0xFF,0xFF,0xFF,0xF8,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFC,0x3F,0xFF,0xFF,0xF0,0x0F,0xFF,0xFF,0x1F,0xFF,
0xFF,0x80,0x00,0xFF,0xFF,0x8F,0xFF,0xFF,0x00,0x00,
0x1F,0xFF,0xE7,0xFF,0xFF,0x00,0x00,0x07,0xFF,0xF3,
0xFF,0xFE,0x00,0x00,0x01,0xFF,0xF9,0xFF,0xFE,0x00,
0x00,0x00,0x7F,0xFC,0xFF,0xFF,0x00,0x00,0x00,0x3F,
0xFF,0x7F,0xFF,0x00,0x00,0x00,0x0F,0xFF,0xCF,0xFF,
0xE0,0x00,0x00,0x00,0xFF,0xFD,0x7F,0xFC,0x00,0x00,
0x00,0x07,0xFF,0xEF,0xFF,0x80,0x00,0x00,0x00,0x7F,
0xFE,0xFF,0xF8,0x00,0x00,0x00,0x07,0xFF,0xEF,0xFF,
0x80,0x00,0x00,0x00,0x7F,0xFE,0xFF,0xF8,0x00,0x00,
0x00,0x07,0xFF,0xEF,0xFF,0x80,0x00,0x00,0x00,0x7F,
0xFE,0xFF,0xF8,0x00,0x00,0x00,0x07,0xFF,0xC7,0xFF,
0x80,0x00,0x00,0x00,0x7F,0xF8,0x10,0x23,0x97,0xFD,
0x28,0x00,0x00,0x00,0x7F,0xF8,0x00,0x00,0x00,0x00,
0x00,0x07,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0xFF,0x80,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xF0,
0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFE,0x00,0x00,
0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x7F,
0xFF,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0xFF,0xFF,0xFF,
0xFF,0xFF,0xF8,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFE,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,
0x00,0x7F,0xFF,0xF8,0x01,0xFF,0xFF,0xE0,0x00,0x7F,
0xFF,0xE0,0x00,0x1F,0xFF,0xF8,0x00,0x7F,0xFF,0xC0,
0x00,0x03,0xFF,0xFC,0x00,0x3F,0xFF,0xC0,0x00,0x00,
0xFF,0xFF,0x00,0x3F,0xFF,0x80,0x00,0x00,0x1F,0xFF,
0xC0,0x1F,0xFF,0x80,0x00,0x00,0x07,0xFF,0xE1,0x03,
0xFF,0xF0,0x00,0x00,0x00,0x3F,0xFF,0x03,0xFF,0xF0,
0x00,0x00,0x00,0x0F,0xFF,0xC8,0x3F,0xFE,0x00,0x00,
0x00,0x00,0x7F,0xFC,0x1F,0xFE,0x00,0x00,0x00,0x00,
0x1F,0xFE,0x43,0xFF,0xE0,0x00,0x00,0x00,0x01,0xFF,
0xF4,0x3F,0xFC,0x00,0x00,0x00,0x00,0x0F,0xFF,0x1F,
0xFE,0x00,0x00,0x00,0x00,0x07,0xFF,0xDF,0xFF,0x00,
0x00,0x00,0x00,0x03,0xFF,0xFB,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x1F,0xFF,0x9F,0xFE,0x00,0x00,0x00,0x00,
0x01,0xFF,0xEF,0xFF,0x80,0x00,0x00,0x00,0x01,0xFF,
0xF9,0x7F,0xF8,0x00,0x00,0x00,0x00,0x1F,0xFE,0x3F,
0xFC,0x00,0x00,0x00,0x00,0x1F,0xFF,0x1F,0xFF,0x00,
0x00,0x00,0x00,0x0F,0xFF,0x87,0xFF,0x80,0x00,0x00,
0x00,0x07,0xFF,0xD0,0x7F,0xFC,0x00,0x00,0x00,0x00,
0xFF,0xF8,0x3F,0xFF,0x00,0x00,0x00,0x00,0xFF,0xFC,
0x81,0xFF,0xF8,0x00,0x00,0x00,0x1F,0xFF,0x80,0x7F,
0xFE,0x00,0x00,0x00,0x1F,0xFF,0x80,0x3F,0xFF,0x80,
0x00,0x00,0x1F,0xFF,0xC0,0x0F,0xFF,0xF0,0x00,0x00,
0x3F,0xFF,0xC0,0x07,0xFF,0xFC,0x00,0x00,0x3F,0xFF,
0xE0,0x01,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0xE0,0x00,
0x7F,0xFF,0xF8,0x01,0xFF,0xFF,0xE0,0x20,0x03,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFC,0x00,0x00,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFC,0x00,0x00,0x1F,0xFF,0xFF,0xFF,0xFF,
0xF8,0x00,0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,
0x00,0x01,0xFF,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,
0x3F,0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x0F,0xFF,
0xFF,0xFF,0xE0,0x00,0x00,0x00,0x01,0xFF,0xFF,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,0x00,0x00,
0x00,0x00,0x00,0x00,0x7F,0xF8,0x00,0x00,0x00,0x0F,
0x30,0x27,0x99,0x28,0x00,0x00,0x00,0x3F,0xF0,0x00,
0x00,0x0F,0xFF,0x00,0x1F,0xFF,0xF8,0x00,0x00,0x7F,
0xF8,0x03,0xFF,0xFF,0xF0,0x00,0x03,0xFF,0xC0,0x3F,
0xFF,0xFF,0xE0,0x00,0x1F,0xFE,0x07,0xFF,0xFF,0xFF,
0xC0,0x00,0xFF,0xF0,0x7F,0xFF,0xFF,0xFF,0x00,0x07,
0xFF,0x87,0xFF,0xFF,0xFF,0xFC,0x00,0x3F,0xFC,0x7F,
0xFF,0xFF,0xFF,0xF0,0x01,0xFF,0xE3,0xFF,0xFF,0xFF,
0xFF,0xC0,0x0F,0xFF,0x3F,0xFF,0xFF,0xFF,0xFF,0x00,
0x7F,0xFB,0xFF,0xFF,0xFF,0xFF,0xFC,0x03,0xFF,0xFF,
0xFF,0x00,0xFF,0xFF,0xF0,0x1F,0xFF,0xFF,0xE0,0x00,
0xFF,0xFF,0x80,0xFF,0xFF,0xFC,0x00,0x01,0xFF,0xFE,
0x07,0xFF,0xFF,0xC0,0x00,0x07,0xFF,0xF0,0x3F,0xFF,
0xF8,0x00,0x00,0x1F,0xFF,0xC1,0xFF,0xFF,0x80,0x00,
0x00,0x7F,0xFE,0x0F,0xFF,0xF8,0x00,0x00,0x01,0xFF,
0xF8,0x7F,0xFF,0xC0,0x00,0x00,0x07,0xFF,0xC3,0xFF,
0xFC,0x00,0x00,0x00,0x3F,0xFE,0x1F,0xFF,0xC0,0x00,
0x00,0x00,0xFF,0xF8,0xFF,0xFE,0x00,0x00,0x00,0x03,
0xFF,0xC7,0xFF,0xE0,0x00,0x00,0x00,0x1F,0xFE,0x3F,
0xFF,0x00,0x00,0x00,0x00,0xFF,0xF9,0xFF,0xF8,0x00,
0x00,0x00,0x03,0xFF,0xD3,0xFF,0xF0,0x00,0x00,0x00,
0x03,0xFF,0xCF,0xFF,0x80,0x00,0x00,0x00,0x1F,0xFF,
0xDF,0xFF,0x00,0x00,0x00,0x00,0x0F,0xFF,0xCF,0xFF,
0x00,0x00,0x00,0x00,0x0F,0xFF,0x7F,0xF8,0x00,0x00,
0x00,0x00,0xFF,0xF5,0x7F,0xFC,0x00,0x00,0x00,0x00,
0xFF,0xF4,0x7F,0xFE,0x00,0x00,0x00,0x01,0xFF,0xE3,
0xFF,0xF0,0x00,0x00,0x00,0x1F,0xFF,0x1F,0xFF,0xC0,
0x00,0x00,0x00,0xFF,0xF8,0xFF,0xFE,0x00,0x00,0x00,
0x0F,0xFF,0x87,0xFF,0xF8,0x00,0x00,0x00,0x7F,0xFC,
0x3F,0xFF,0xE0,0x00,0x00,0x07,0xFF,0xC1,0xFF,0xFF,
0x00,0x00,0x00,0x7F,0xFE,0x0F,0xFF,0xFC,0x00,0x00,
0x07,0xFF,0xE0,0x7F,0xFF,0xF8,0x00,0x00,0x7F,0xFF,
0x03,0xFF,0xFF,0xE0,0x00,0x07,0xFF,0xF0,0x1F,0xFF,
0xFF,0xC0,0x00,0xFF,0xFF,0x80,0xFF,0xFF,0xFF,0xC0,
0x3F,0xFF,0xF8,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x80,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x01,0xFF,
0xEF,0xFF,0xFF,0xFF,0xFF,0x80,0x0F,0xFF,0x3F,0xFF,
0xFF,0xFF,0xF8,0x00,0x7F,0xF8,0xFF,0xFF,0xFF,0xFF,
0x80,0x03,0xFF,0xC3,0xFF,0xFF,0xFF,0xF8,0x00,0x1F,
0xFE,0x0F,0xFF,0xFF,0xFF,0x00,0x00,0xFF,0xF0,0x3F,
0xFF,0xFF,0xF0,0x00,0x07,0xFF,0x80,0x7F,0xFF,0xFE,
0x00,0x00,0x3F,0xFC,0x00,0xFF,0xFF,0x80,0x00,0x01,
0xFF,0xE0,0x00,0xFF,0xC0,0x00,0x00,0x1B,0xFF,0xE0,
0x00,0x00,0x00,0x00,0x00,0x1B,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x00,0x1B,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x00,0x15,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
0x0F,0x30,0x17,0x99,0x28,0x00,0x00,0x03,0xFF,0x00,
0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0x00,0x0F,0xFF,
0x00,0x00,0x3F,0xFF,0xFE,0x00,0x7F,0xF8,0x00,0x07,
0xFF,0xFF,0xFC,0x03,0xFF,0xC0,0x00,0xFF,0xFF,0xFF,
0xF0,0x1F,0xFE,0x00,0x0F,0xFF,0xFF,0xFF,0xC0,0xFF,
0xF0,0x01,0xFF,0xFF,0xFF,0xFF,0x07,0xFF,0x80,0x1F,
0xFF,0xFF,0xFF,0xFC,0x3F,0xFC,0x01,0xFF,0xFF,0xFF,
0xFF,0xF1,0xFF,0xF0,0x03,0xFF,0xFF,0xFF,0xFF,0xF9,
0xFF,0xE0,0x3F,0xFF,0xF8,0x07,0xFF,0xEF,0xFF,0x03,
0xFF,0xFF,0x00,0x07,0xFF,0xFF,0xF8,0x1F,0xFF,0xE0,
0x00,0x0F,0xFF,0xFF,0xC1,0xFF,0xFC,0x00,0x00,0x3F,
0xFF,0xFE,0x0F,0xFF,0xC0,0x00,0x00,0xFF,0xFF,0xF0,
0xFF,0xFC,0x00,0x00,0x03,0xFF,0xFF,0x87,0xFF,0xC0,
0x00,0x00,0x0F,0xFF,0xFC,0x7F,0xFE,0x00,0x00,0x00,
0x3F,0xFF,0xF0,0x7F,0xFC,0x00,0x00,0x00,0x1F,0xFF,
0xF0,0xFF,0xF8,0x00,0x00,0x00,0x0F,0xFF,0xF2,0xFF,
0xF0,0x00,0x00,0x00,0x07,0xFF,0xEF,0xFF,0x80,0x00,
0x00,0x00,0x1F,0xFF,0xBF,0xFF,0x00,0x00,0x00,0x00,
0x1F,0xFF,0xDF,0xFF,0x00,0x00,0x00,0x00,0x0F,0xFF,
0x8F,0xFF,0x00,0x00,0x00,0x00,0x0F,0xFF,0x9F,0xFF,
0x00,0x00,0x00,0x00,0x1F,0xFF,0x87,0xFF,0x80,0x00,
0x00,0x00,0x1F,0xFF,0x87,0xFF,0x80,0x00,0x00,0x00,
0x3F,0xFF,0x3F,0xFE,0x00,0x00,0x00,0x01,0xFF,0xF8,
0xFF,0xF0,0x00,0x00,0x00,0x1F,0xFF,0xC7,0xFF,0xC0,
0x00,0x00,0x00,0xFF,0xFE,0x3F,0xFE,0x00,0x00,0x00,
0x0F,0xFF,0xF0,0xFF,0xF8,0x00,0x00,0x00,0x7F,0xFF,
0x87,0xFF,0xE0,0x00,0x00,0x07,0xFF,0xFC,0x1F,0xFF,
0x80,0x00,0x00,0x7F,0xFF,0xE0,0xFF,0xFE,0x00,0x00,
0x07,0xFF,0xFF,0x03,0xFF,0xF8,0x00,0x00,0x7F,0xFF,
0xF8,0x0F,0xFF,0xE0,0x00,0x07,0xFF,0xFF,0xC0,0x7F,
0xFF,0xC0,0x00,0xFF,0xFF,0xFE,0x01,0xFF,0xFF,0xC0,
0x3F,0xFF,0xFF,0xF0,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x80,0x1F,0xFF,0xFF,0xFF,0xFF,0xBF,0xFC,0x00,
0x7F,0xFF,0xFF,0xFF,0xFD,0xFF,0xE0,0x01,0xFF,0xFF,
0xFF,0xFF,0xCF,0xFF,0x00,0x07,0xFF,0xFF,0xFF,0xFC,
0x7F,0xF8,0x00,0x1F,0xFF,0xFF,0xFF,0xC3,0xFF,0xC0,
0x00,0x7F,0xFF,0xFF,0xFC,0x1F,0xFE,0x00,0x00,0xFF,
0xFF,0xFF,0x80,0xFF,0xF0,0x00,0x01,0xFF,0xFF,0xF0,
0x07,0xFF,0x80,0x00,0x01,0xFF,0xFE,0x00,0x3F,0xFC,
0x00,0x00,0x01,0xFF,0x80,0x01,0xFF,0xFA,0x00,0x00,
0x00,0x00,0x00,0x01,0xFF,0xFA,0x00,0x00,0x00,0x00,
0x00,0x01,0xFF,0xFA,0x00,0x00,0x00,0x00,0x00,0x01,
0xFF,0xF4,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xE0,
0x09,0x63,0x24,0x00,0xB0,0x00,0x00,0x0F,0xF8,0x07,
0xFE,0x00,0xFF,0xFC,0x1F,0xF8,0x0F,0xFF,0xFE,0x7F,
0xE0,0x7F,0xFF,0xFD,0xFF,0x83,0xFF,0xFF,0xE7,0xFE,
0x1F,0xFF,0xFF,0x9F,0xF8,0xFF,0xFF,0xFE,0x8F,0xFC,
0xFF,0xFF,0xFE,0x3F,0xF7,0xFF,0xFF,0xF8,0xFF,0xFF,
0xFF,0xFF,0xC3,0xFF,0xFF,0xF0,0x3F,0x0F,0xFF,0xFE,
0x00,0x18,0x3F,0xFF,0xF0,0x00,0x20,0xFF,0xFF,0x80,
0x00,0x03,0xFF,0xFC,0x00,0x00,0x11,0xFF,0xFC,0x00,
0x00,0x09,0xFF,0xFC,0x00,0x00,0x05,0xFF,0xFC,0x00,
0x00,0x03,0x7F,0xFC,0x00,0x00,0x01,0xBF,0xFE,0x00,
0x00,0x00,0xDF,0xFF,0x00,0x00,0x00,0x6F,0xFF,0x80,
0x00,0x00,0x37,0xFF,0xC0,0x00,0x00,0x1B,0xFF,0xE0,
0x00,0x00,0x08,0xFF,0xF0,0x00,0x00,0x00,0x0E,0x63,
0x97,0xFD,0x0C,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,
0x00,0x00,0x7F,0xFF,0xFE,0x00,0x00,0x00,0x00,0x7F,
0xFF,0xFF,0xF0,0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,
0x00,0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xE0,0x00,0x00,
0x3F,0xFF,0xFF,0xFF,0xFE,0x00,0x00,0x1F,0xFF,0xFF,
0xFF,0xFF,0xC0,0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0xF8,
0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x03,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC0,0x01,0xFF,0xFF,0xFF,0xFF,
0xFF,0xF8,0x00,0x7F,0xFF,0xE0,0x07,0xFF,0xFF,0x00,
0x3F,0xFF,0xC0,0x00,0x3F,0xFF,0xC0,0x0F,0xFF,0xC0,
0x00,0x07,0xFF,0xF0,0x03,0xFF,0xE0,0x00,0x00,0x7F,
0xFE,0x01,0xFF,0xF0,0x00,0x00,0x1F,0xFF,0x80,0x7F,
0xF8,0x00,0x00,0x03,0xFF,0xE0,0x93,0xFF,0xC0,0x00,
0x00,0x0F,0xFF,0x80,0xFF,0xF0,0x00,0x00,0x01,0xFF,
0x00,0x3F,0xFE,0x00,0x00,0x00,0x70,0x00,0x0F,0xFF,
0x80,0x00,0x00,0x00,0x00,0x03,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,
0x1F,0xFF,0xF8,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,
0xE0,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0x00,0x00,
0x00,0x00,0x3F,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x07,
0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x01,0xFF,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xF8,0x00,
0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0xFF,
0xFF,0xFF,0xFF,0xFC,0x00,0x00,0x0F,0xFF,0xFF,0xFF,
0xFF,0xC0,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFC,0x00,
0x00,0x0F,0xFF,0xFF,0xFF,0xFF,0x80,0x00,0x00,0xFF,
0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x07,0xFF,0xFF,0xFF,
0xFE,0x00,0x00,0x00,0x3F,0xFF,0xFF,0xFF,0xC0,0x00,
0x00,0x00,0xFF,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x07,
0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x7F,0xFF,0xF0,0x00,0x00,
0x00,0x00,0x03,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,
0x3F,0xFF,0x80,0x00,0x00,0x00,0x00,0x07,0xFF,0xE0,
0x07,0x00,0x00,0x00,0x00,0xFF,0xF8,0x7F,0xC0,0x00,
0x00,0x00,0x1F,0xFF,0x1F,0xFF,0x00,0x00,0x00,0x00,
0xFF,0xF3,0xFF,0xC0,0x00,0x00,0x00,0x3F,0xFC,0xFF,
0xF8,0x00,0x00,0x00,0x0F,0xFF,0x3F,0xFE,0x00,0x00,
0x00,0x07,0xFF,0xCF,0xFF,0xC0,0x00,0x00,0x01,0xFF,
0xE1,0xFF,0xF8,0x00,0x00,0x00,0xFF,0xF8,0x7F,0xFF,
0x00,0x00,0x00,0x7F,0xFE,0x0F,0xFF,0xF0,0x00,0x00,
0x3F,0xFF,0x03,0xFF,0xFF,0x00,0x00,0x3F,0xFF,0xC0,
0x7F,0xFF,0xF8,0x00,0xFF,0xFF,0xE0,0x1F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xF0,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFC,0x00,0x7F,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x0F,
0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x01,0xFF,0xFF,0xFF,
0xFF,0xFF,0x80,0x00,0x3F,0xFF,0xFF,0xFF,0xFF,0xC0,
0x00,0x07,0xFF,0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x7F,
0xFF,0xFF,0xFF,0xC0,0x00,0x00,0x07,0xFF,0xFF,0xFF,
0xC0,0x00,0x00,0x00,0x3F,0xFF,0xFF,0x80,0x00,0x00,
0x00,0x00,0x7F,0xFE,0x00,0x00,0x00,0x08,0xAF,0x0B,
0xFC,0x94,0x00,0x00,0x10,0x00,0x00,0x00,0x0E,0x00,
0x00,0x00,0x03,0xC0,0x00,0x00,0x01,0xF8,0x00,0x00,
0x00,0xFF,0x00,0x00,0x00,0x7F,0xE0,0x00,0x00,0x1F,
0xFC,0x00,0x1A,0x00,0xFF,0xF0,0x00,0x68,0x03,0xFF,
0xC0,0x01,0x20,0x0F,0xFF,0x00,0x06,0xFF,0xFF,0xFF,
0xFF,0x95,0xFF,0xFF,0xFF,0xFE,0x68,0x03,0xFF,0xC0,
0x01,0xA0,0x0F,0xFF,0x00,0x06,0x80,0x3F,0xFC,0x00,
0x1A,0x00,0xFF,0xF0,0x00,0x68,0x03,0xFF,0xC0,0x01,
0xA0,0x0F,0xFF,0x00,0x04,0x80,0x3F,0xFC,0x00,0x00,
0x07,0xFF,0xC0,0x00,0x00,0xFF,0xFC,0x00,0x00,0x1F,
0xFF,0xC0,0x08,0x00,0x3F,0xFF,0xFF,0x20,0x00,0xFF,
0xFF,0xFE,0x80,0x01,0xFF,0xFF,0xF8,0x00,0x1F,0xFF,
0xFF,0x00,0x01,0xFF,0xFF,0xF0,0x00,0x1F,0xFF,0xFE,
0x00,0x00,0xFF,0xFF,0xC0,0x00,0x03,0xFF,0xC0,0x0E,
0x23,0x27,0xFD,0x2B,0x7F,0xFC,0x00,0x00,0x00,0x03,
0xFF,0xF7,0xFF,0xC0,0x00,0x00,0x00,0x3F,0xFF,0x7F,
0xFC,0x00,0x00,0x00,0x03,0xFF,0xF7,0xFF,0xC0,0x00,
0x00,0x00,0x3F,0xFF,0x7F,0xFC,0x00,0x00,0x00,0x03,
0xFF,0xF7,0xFF,0xC0,0x00,0x00,0x00,0x3F,0xFE,0x3F,
0xFC,0x00,0x00,0x00,0x03,0xFF,0xEB,0xFF,0xC0,0x00,
0x00,0x00,0x7F,0xFE,0x3F,0xFE,0x00,0x00,0x00,0x0F,
0xFF,0xE3,0xFF,0xE0,0x00,0x00,0x01,0xFF,0xFC,0xFF,
0xF8,0x00,0x00,0x01,0xFF,0xFE,0x7F,0xFC,0x00,0x00,
0x01,0xFF,0xFF,0x3F,0xFF,0x00,0x00,0x01,0xFF,0xFF,
0x9F,0xFF,0xC0,0x00,0x01,0xFF,0xFF,0xC7,0xFF,0xF0,
0x00,0x03,0xFF,0xFF,0xE3,0xFF,0xFE,0x00,0x07,0xFF,
0xFF,0xF1,0xFF,0xFF,0xE0,0x1F,0xFF,0x7F,0xF8,0x7F,
0xFF,0xFF,0xFF,0xFF,0xBF,0xFC,0x3F,0xFF,0xFF,0xFF,
0xFF,0x9F,0xFE,0x0F,0xFF,0xFF,0xFF,0xFF,0x8F,0xFF,
0x03,0xFF,0xFF,0xFF,0xFF,0x87,0xFF,0x80,0xFF,0xFF,
0xFF,0xFF,0x83,0xFF,0xC0,0x3F,0xFF,0xFF,0xFF,0x81,
0xFF,0xE0,0x0F,0xFF,0xFF,0xFF,0x80,0xFF,0xF0,0x03,
0xFF,0xFF,0xFF,0x00,0x7F,0xF8,0x00,0x7F,0xFF,0xFF,
0x00,0x3F,0xFC,0x00,0x07,0xFF,0xFC,0x00,0x1F,0xFE,
0x00,0x00,0x3F,0xF0,0x00,0x00,0x00,0x0F,0xE2,0x88,
0x01,0x0D,0xFF,0xF0,0x00,0x00,0x00,0x00,0x7F,0xFC,
0xFF,0xF0,0x00,0x00,0x00,0x00,0x7F,0xFE,0x1F,0xFF,
0x00,0x00,0x00,0x00,0x1F,0xFF,0x0F,0xFF,0x00,0x00,
0x00,0x00,0x1F,0xFE,0x41,0xFF,0xF0,0x00,0x00,0x00,
0x07,0xFF,0xC0,0xFF,0xF0,0x00,0x00,0x00,0x07,0xFF,
0x88,0x1F,0xFF,0x00,0x00,0x00,0x01,0xFF,0xF0,0x0F,
0xFF,0x00,0x00,0x00,0x01,0xFF,0xE0,0x0F,0xFF,0x80,
0x00,0x00,0x03,0xFF,0xE0,0x07,0xFF,0x80,0x00,0x00,
0x03,0xFF,0xE0,0x07,0xFF,0x80,0x00,0x00,0x03,0xFF,
0xC0,0x07,0xFF,0xC0,0x00,0x00,0x07,0xFF,0xC0,0x03,
0xFF,0xC0,0x00,0x00,0x07,0xFF,0xC0,0x03,0xFF,0xC0,
0x00,0x00,0x07,0xFF,0x80,0x03,0xFF,0xE0,0x00,0x00,
0x0F,0xFF,0x80,0x01,0xFF,0xE0,0x00,0x00,0x0F,0xFF,
0x80,0x01,0xFF,0xF0,0x00,0x00,0x0F,0xFF,0x00,0x01,
0xFF,0xF0,0x00,0x00,0x1F,0xFF,0x00,0x00,0xFF,0xF0,
0x00,0x00,0x1F,0xFF,0x00,0x00,0xFF,0xF8,0x00,0x00,
0x1F,0xFE,0x01,0x00,0x0F,0xFF,0x00,0x00,0x07,0xFF,
0xC0,0x00,0x0F,0xFF,0x80,0x00,0x07,0xFF,0x80,0x20,
0x00,0xFF,0xF0,0x00,0x01,0xFF,0xF0,0x00,0x00,0xFF,
0xF8,0x00,0x03,0xFF,0xE0,0x04,0x00,0x0F,0xFF,0x00,
0x00,0x7F,0xFC,0x00,0x00,0x0F,0xFF,0x80,0x00,0xFF,
0xF8,0x00,0x80,0x00,0xFF,0xF0,0x00,0x1F,0xFF,0x00,
0x12,0x00,0x0F,0xFF,0x00,0x07,0xFF,0xC0,0x02,0x00,
0x00,0xFF,0xF0,0x01,0xFF,0xF0,0x00,0x00,0x00,0xFF,
0xF0,0x01,0xFF,0xE0,0x00,0x40,0x00,0x0F,0xFF,0x00,
0x7F,0xFC,0x00,0x00,0x00,0x0F,0xFF,0x00,0x7F,0xF8,
0x00,0x08,0x00,0x00,0xFF,0xF0,0x1F,0xFF,0x00,0x00,
0x00,0x00,0xFF,0xF0,0x1F,0xFE,0x00,0x01,0x00,0x00,
0x0F,0xFF,0x07,0xFF,0xC0,0x00,0x00,0x00,0x07,0xFF,
0x07,0xFF,0x80,0x00,0x20,0x00,0x00,0xFF,0xF1,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x7F,0xF1,0xFF,0xE0,0x00,
0x04,0x00,0x00,0x0F,0xFF,0x7F,0xFC,0x00,0x00,0x00,
0x00,0x07,0xFF,0x7F,0xF8,0x00,0x00,0x80,0x00,0x00,
0xFF,0xFF,0xFF,0x00,0x00,0x10,0x00,0x00,0x0F,0xFF,
0xFF,0xC0,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,0xC0,
0x00,0x02,0x00,0x00,0x00,0xFF,0xFF,0xF0,0x00,0x00,
0x00,0x00,0x00,0x7F,0xFF,0xF0,0x00,0x00,0x40,0x00,
0x00,0x0F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x07,
0xFF,0xFC,0x00,0x00,0x08,0x00,0x00,0x00,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,
0x00,0x17,0xE2,0x80,0x01,0x7E,0x3F,0xFC,0x00,0x00,
0x00,0x1F,0xFF,0x00,0x00,0x00,0x07,0xFF,0xBF,0xFE,
0x00,0x00,0x00,0x1F,0xFF,0x80,0x00,0x00,0x0F,0xFF,
0xC3,0xFF,0xC0,0x00,0x00,0x07,0xFF,0xF0,0x00,0x00,
0x01,0xFF,0xE3,0xFF,0xE0,0x00,0x00,0x07,0xFF,0xF0,
0x00,0x00,0x03,0xFF,0xE8,0x3F,0xFC,0x00,0x00,0x01,
0xFF,0xFF,0x00,0x00,0x00,0x7F,0xF8,0x3F,0xFC,0x00,
0x00,0x01,0xFF,0xFF,0x00,0x00,0x00,0xFF,0xF8,0x3F,
0xFE,0x00,0x00,0x01,0xFF,0xFF,0x00,0x00,0x00,0xFF,
0xF9,0x03,0xFF,0xC0,0x00,0x00,0x7F,0xFF,0xF0,0x00,
0x00,0x1F,0xFE,0x03,0xFF,0xE0,0x00,0x00,0x7F,0xFF,
0xF0,0x00,0x00,0x3F,0xFE,0x01,0xFF,0xE0,0x00,0x00,
0x7F,0xFF,0xF0,0x00,0x00,0x3F,0xFC,0x01,0xFF,0xE0,
0x00,0x00,0xFF,0xFF,0xF8,0x00,0x00,0x3F,0xFC,0x01,
0xFF,0xF0,0x00,0x00,0xFF,0xFF,0xF8,0x00,0x00,0x7F,
0xFC,0x00,0xFF,0xF0,0x00,0x00,0xFF,0xDF,0xF8,0x00,
0x00,0x7F,0xF8,0x00,0xFF,0xF0,0x00,0x00,0xFF,0xDF,
0xFC,0x00,0x00,0x7F,0xF8,0x00,0xFF,0xF0,0x00,0x01,
0xFF,0xDF,0xFC,0x00,0x00,0x7F,0xF8,0x00,0x7F,0xF8,
0x00,0x01,0xFF,0xDF,0xFC,0x00,0x00,0xFF,0xF0,0x00,
0x7F,0xF8,0x00,0x01,0xFF,0x8F,0xFC,0x00,0x00,0xFF,
0xF0,0x00,0x7F,0xF8,0x00,0x01,0xFF,0x8F,0xFE,0x00,
0x00,0xFF,0xF0,0x20,0x07,0xFF,0x80,0x00,0x7F,0xF1,
0xFF,0xC0,0x00,0x3F,0xFC,0x00,0x07,0xFF,0x80,0x00,
0x7F,0xE0,0xFF,0xC0,0x00,0x3F,0xFC,0x00,0x07,0xFF,
0x80,0x00,0x7F,0xE0,0xFF,0xE0,0x00,0x7F,0xF8,0x04,
0x00,0x7F,0xF8,0x00,0x1F,0xFC,0x1F,0xFC,0x00,0x0F,
0xFF,0x00,0x00,0x7F,0xF8,0x00,0x1F,0xF8,0x0F,0xFC,
0x00,0x0F,0xFF,0x00,0x00,0x3F,0xFC,0x00,0x1F,0xF8,
0x0F,0xFE,0x00,0x1F,0xFE,0x00,0x80,0x07,0xFF,0x80,
0x07,0xFF,0x01,0xFF,0xC0,0x03,0xFF,0xC0,0x00,0x03,
0xFF,0xC0,0x07,0xFE,0x00,0xFF,0xC0,0x07,0xFF,0x80,
0x10,0x00,0x7F,0xF8,0x01,0xFF,0xC0,0x1F,0xFC,0x00,
0xFF,0xF0,0x00,0x00,0x3F,0xF8,0x01,0xFF,0xC0,0x1F,
0xFC,0x00,0xFF,0xE0,0x00,0x00,0x3F,0xFC,0x01,0xFF,
0x80,0x0F,0xFC,0x01,0xFF,0xE0,0x00,0x00,0x3F,0xFC,
0x03,0xFF,0x80,0x0F,0xFE,0x01,0xFF,0xE0,0x00,0x00,
0x1F,0xFC,0x03,0xFF,0x80,0x0F,0xFE,0x01,0xFF,0xC0,
0x00,0x00,0x1F,0xFE,0x03,0xFF,0x80,0x0F,0xFE,0x03,
0xFF,0xC0,0x00,0x00,0x1F,0xFE,0x03,0xFF,0x00,0x07,
0xFE,0x03,0xFF,0xC0,0x00,0x00,0x1F,0xFE,0x07,0xFF,
0x00,0x07,0xFF,0x03,0xFF,0x80,0x00,0x00,0x0F,0xFE,
0x07,0xFF,0x00,0x07,0xFF,0x07,0xFF,0x80,0x00,0x00,
0x0F,0xFF,0x07,0xFF,0x00,0x07,0xFF,0x07,0xFF,0x80,
0x00,0x00,0x0F,0xFF,0x07,0xFE,0x00,0x03,0xFF,0x07,
0xFF,0x80,0x00,0x00,0x07,0xFF,0x0F,0xFE,0x00,0x03,
0xFF,0x87,0xFF,0x00,0x00,0x00,0x07,0xFF,0x0F,0xFE,
0x00,0x03,0xFF,0x8F,0xFF,0x00,0x00,0x00,0x07,0xFF,
0x8F,0xFE,0x00,0x03,0xFF,0x8F,0xFF,0x00,0x00,0x00,
0x03,0xFF,0x8F,0xFC,0x00,0x01,0xFF,0x8F,0xFE,0x00,
0x00,0x00,0x03,0xFF,0x9F,0xFC,0x00,0x01,0xFF,0xCF,
0xFE,0x00,0x00,0x00,0x03,0xFF,0x9F,0xFC,0x00,0x01,
0xFF,0xDF,0xFE,0x00,0x00,0x00,0x01,0xFF,0x9F,0xFC,
0x00,0x01,0xFF,0xDF,0xFC,0x00,0x00,0x00,0x01,0xFF,
0xDF,0xF8,0x00,0x00,0xFF,0xDF,0xFC,0x00,0x00,0x00,
0x01,0xFF,0xFF,0xF8,0x00,0x00,0xFF,0xFF,0xFC,0x00,
0x02,0x00,0x00,0x1F,0xFF,0xFF,0x00,0x00,0x1F,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFE,0x00,0x00,
0x0F,0xFF,0xFF,0x00,0x00,0x48,0x00,0x01,0xFF,0xFF,
0xC0,0x00,0x01,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x01,
0xFF,0xFF,0x80,0x00,0x00,0xFF,0xFF,0x80,0x00,0x09,
0x00,0x00,0x1F,0xFF,0xF0,0x00,0x00,0x1F,0xFF,0xF0,
0x00,0x01,0x20,0x00,0x01,0xFF,0xFC,0x00,0x00,0x01,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0xFF,0xFC,0x00,
0x00,0x01,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0xFF,
0xF8,0x00,0x00,0x00,0xFF,0xF8,0x00,0x00,0x00,0x10,
0x22,0x84,0x01,0x08,0x7F,0xFF,0x00,0x00,0x00,0x00,
0x7F,0xFE,0x1F,0xFF,0x80,0x00,0x00,0x00,0x7F,0xFE,
0x07,0xFF,0xE0,0x00,0x00,0x00,0x7F,0xFF,0x03,0xFF,
0xF8,0x00,0x00,0x00,0x7F,0xFF,0x00,0xFF,0xFC,0x00,
0x00,0x00,0x3F,0xFF,0x00,0x3F,0xFF,0x00,0x00,0x00,
0x3F,0xFF,0x80,0x1F,0xFF,0xC0,0x00,0x00,0x3F,0xFF,
0x80,0x07,0xFF,0xE0,0x00,0x00,0x1F,0xFF,0x80,0x01,
0xFF,0xF8,0x00,0x00,0x1F,0xFF,0x80,0x00,0x7F,0xFE,
0x00,0x00,0x1F,0xFF,0xC0,0x00,0x3F,0xFF,0x80,0x00,
0x1F,0xFF,0xC0,0x00,0x0F,0xFF,0xC0,0x00,0x0F,0xFF,
0xC0,0x00,0x03,0xFF,0xF0,0x00,0x0F,0xFF,0xE0,0x00,
0x01,0xFF,0xFC,0x00,0x0F,0xFF,0xE0,0x00,0x00,0x7F,
0xFE,0x00,0x0F,0xFF,0xE0,0x00,0x00,0x1F,0xFF,0x80,
0x07,0xFF,0xE0,0x00,0x00,0x0F,0xFF,0xE0,0x07,0xFF,
0xF0,0x00,0x00,0x03,0xFF,0xF0,0x07,0xFF,0xF0,0x00,
0x00,0x00,0xFF,0xFC,0x03,0xFF,0xF0,0x00,0x00,0x00,
0x7F,0xFF,0x03,0xFF,0xF0,0x00,0x00,0x00,0x1F,0xFF,
0x83,0xFF,0xF8,0x00,0x00,0x00,0x07,0xFF,0xE3,0xFF,
0xF8,0x00,0x00,0x00,0x01,0xFF,0xF9,0xFF,0xF8,0x00,
0x00,0x00,0x00,0xFF,0xFD,0xFF,0xFC,0x00,0x00,0x00,
0x00,0x3F,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x0F,
0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,
0xFC,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0xFE,0x00,
0x00,0x00,0x00,0x00,0x7F,0xFF,0xFE,0x00,0x00,0x00,
0x00,0x00,0x3F,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xFF,0x00,
0x00,0x01,0x00,0x00,0x00,0x0F,0xFF,0xE0,0x00,0x00,
0x00,0x00,0x00,0x0F,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x00,0x07,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x07,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xFF,
0xC0,0x00,0x01,0x00,0x00,0x00,0xFF,0xFF,0xFE,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0x80,0x00,0x00,
0x00,0x00,0xFF,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0xF0,0x00,0x00,0x00,0x00,0x7F,0xFE,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x7F,0xFF,0x7F,0xFF,
0x00,0x00,0x00,0x00,0x7F,0xFF,0x1F,0xFF,0x80,0x00,
0x00,0x00,0x3F,0xFF,0x07,0xFF,0xE0,0x00,0x00,0x00,
0x3F,0xFF,0x01,0xFF,0xF8,0x00,0x00,0x00,0x3F,0xFF,
0x80,0xFF,0xFE,0x00,0x00,0x00,0x3F,0xFF,0x80,0x3F,
0xFF,0x00,0x00,0x00,0x1F,0xFF,0x80,0x0F,0xFF,0xC0,
0x00,0x00,0x1F,0xFF,0xC0,0x07,0xFF,0xF0,0x00,0x00,
0x1F,0xFF,0xC0,0x01,0xFF,0xF8,0x00,0x00,0x1F,0xFF,
0xC0,0x00,0x7F,0xFE,0x00,0x00,0x0F,0xFF,0xC0,0x00,
0x3F,0xFF,0x80,0x00,0x0F,0xFF,0xE0,0x00,0x0F,0xFF,
0xC0,0x00,0x0F,0xFF,0xE0,0x00,0x03,0xFF,0xF0,0x00,
0x07,0xFF,0xE0,0x00,0x01,0xFF,0xFC,0x00,0x07,0xFF,
0xE0,0x00,0x00,0x7F,0xFE,0x00,0x07,0xFF,0xF0,0x00,
0x00,0x1F,0xFF,0x80,0x07,0xFF,0xF0,0x00,0x00,0x07,
0xFF,0xE0,0x03,0xFF,0xF0,0x00,0x00,0x03,0xFF,0xF8,
0x03,0xFF,0xF8,0x00,0x00,0x00,0xFF,0xFC,0x03,0xFF,
0xF8,0x00,0x00,0x00,0x3F,0xFF,0x01,0xFF,0xF8,0x00,
0x00,0x00,0x1F,0xFF,0xC1,0xFF,0xF8,0x00,0x00,0x00,
0x07,0xFF,0xE1,0xFF,0xFC,0x00,0x00,0x00,0x01,0xFF,
0xF9,0xFF,0xFC,0x00,0x00,0x00,0x00,0xFF,0xFE,0x0F,
0x70,0x0B,0x95,0x05,0xFF,0xF0,0x00,0x00,0x00,0x00,
0xFF,0xF3,0xFF,0xC0,0x00,0x00,0x00,0x07,0xFF,0xCF,
0xFF,0x80,0x00,0x00,0x00,0x1F,0xFF,0x3F,0xFE,0x00,
0x00,0x00,0x00,0x7F,0xF8,0x7F,0xF8,0x00,0x00,0x00,
0x03,0xFF,0xE1,0xFF,0xF0,0x00,0x00,0x00,0x0F,0xFF,
0x87,0xFF,0xC0,0x00,0x00,0x00,0x3F,0xFC,0x0F,0xFF,
0x00,0x00,0x00,0x01,0xFF,0xF0,0x3F,0xFE,0x00,0x00,
0x00,0x07,0xFF,0xC0,0xFF,0xF8,0x00,0x00,0x00,0x1F,
0xFE,0x01,0xFF,0xE0,0x00,0x00,0x00,0xFF,0xF8,0x07,
0xFF,0xC0,0x00,0x00,0x03,0xFF,0xE0,0x0F,0xFF,0x00,
0x00,0x00,0x0F,0xFF,0x00,0x3F,0xFC,0x00,0x00,0x00,
0x7F,0xFC,0x00,0xFF,0xF8,0x00,0x00,0x01,0xFF,0xF0,
0x01,0xFF,0xE0,0x00,0x00,0x07,0xFF,0x82,0x00,0xFF,
0xF8,0x00,0x00,0x07,0xFF,0xC0,0x01,0xFF,0xE0,0x00,
0x00,0x1F,0xFE,0x04,0x00,0xFF,0xF8,0x00,0x00,0x1F,
0xFF,0x00,0x01,0xFF,0xE0,0x00,0x00,0x7F,0xF8,0x00,
0x07,0xFF,0xC0,0x00,0x03,0xFF,0xE0,0x00,0x0F,0xFF,
0x00,0x00,0x0F,0xFF,0x00,0x00,0x3F,0xFC,0x00,0x00,
0x7F,0xFC,0x00,0x00,0xFF,0xF8,0x00,0x01,0xFF,0xF0,
0x00,0x01,0xFF,0xE0,0x00,0x07,0xFF,0x80,0x00,0x07,
0xFF,0x80,0x00,0x3F,0xFE,0x00,0x00,0x1F,0xFF,0x00,
0x00,0xFF,0xF8,0x00,0x00,0x3F,0xFC,0x00,0x03,0xFF,
0xC0,0x08,0x00,0x1F,0xFF,0x00,0x03,0xFF,0xE0,0x00,
0x00,0x3F,0xFC,0x00,0x0F,0xFF,0x00,0x00,0x00,0xFF,
0xF8,0x00,0x7F,0xFC,0x00,0x00,0x01,0xFF,0xE0,0x01,
0xFF,0xF0,0x00,0x00,0x07,0xFF,0x80,0x07,0xFF,0x80,
0x00,0x00,0x1F,0xFF,0x00,0x3F,0xFE,0x00,0x00,0x00,
0x3F,0xFC,0x00,0xFF,0xF8,0x00,0x00,0x00,0xFF,0xF0,
0x03,0xFF,0xC0,0x00,0x00,0x03,0xFF,0xE0,0x1F,0xFF,
0x00,0x00,0x00,0x07,0xFF,0x80,0x7F,0xFC,0x00,0x00,
0x00,0x1F,0xFE,0x01,0xFF,0xE0,0x00,0x00,0x00,0x7F,
0xFC,0x0F,0xFF,0x80,0x00,0x00,0x00,0xFF,0xF0,0x3F,
0xFE,0x00,0x00,0x00,0x03,0xFF,0xC0,0xFF,0xF0,0x00,
0x00,0x00,0x07,0xFF,0x87,0xFF,0xC0,0x00,0x00,0x00,
0x1F,0xFE,0x1F,0xFE,0x00,0x00,0x00,0x00,0x7F,0xF8,
0xFF,0xF8,0x00,0x00,0x00,0x00,0xFF,0xF3,0xFF,0xE0,
0x00,0x00,0x00,0x03,0xFF,0xCF,0xFF,0x00,0x00,0x00,
0x00,0x0F,0xFF,0x7F,0xFC,0x00,0x00,0x00,0x00,0x1F,
0xFD,0xFF,0xF0,0x00,0x04,0x00,0x00,0x0F,0xFF,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x7F,0xFF,0xFE,0x00,0x00,0x20,0x00,
0x00,0x1F,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x7F,
0xFF,0xF8,0x00,0x00,0x40,0x00,0x00,0x1F,0xFF,0xFC,
0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0xE0,0x00,0x00,
0x80,0x00,0x00,0x1F,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x00,0x7F,0xFF,0x80,0x00,0x01,0x00,0x00,0x00,0x1F,
0xFF,0xC0,0x00,0x00,0x90,0x00,0x00,0x07,0xFF,0xC0,
0x00,0x00,0x40,0x00,0x00,0x07,0xFF,0xC0,0x00,0x00,
0x00,0x00,0x00,0x1F,0xFE,0x00,0x00,0x00,0x80,0x00,
0x00,0x1F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,
0xF8,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x00,0x0F,0xFF,0x00,0x00,0x00,0x10,
0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,0x08,0x00,0x00,
0x0F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x7F,0xFC,
0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xF0,0x00,0x00,
0x00,0x01,0x80,0x7F,0xFF,0x80,0x00,0x00,0x00,0x07,
0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x1F,0xFF,0xFF,
0xF0,0x00,0x00,0x00,0x10,0x07,0xFF,0xFF,0xF0,0x00,
0x00,0x00,0x00,0x1F,0xFF,0xFF,0x80,0x00,0x00,0x00,
0x00,0x7F,0xFF,0xFC,0x00,0x00,0x00,0x00,0x01,0xFF,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,0x00,
0x00,0x00,0x00,0x00,0x0F,0xFF,0xF8,0x00,0x00,0x00,
0x00,0x00,0x3F,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,
0x1F,0xF0,0x00,0x00,0x00,0x00,0x00,0x0F,0x22,0x94,
0x01,0x0F,0x43,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF2,
0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0x1F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0xFF,0xFF,0xFF,0xFF,
0x8F,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,
0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xF0,0x00,0x00,
0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,
0x07,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,
0x80,0x00,0x00,0x00,0x00,0x07,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x00,0x7F,0xFF,0x80,0x00,0x00,0x00,0x00,
0x03,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,
0x80,0x00,0x00,0x00,0x00,0x03,0xFF,0xF8,0x00,0x00,
0x00,0x00,0x00,0x3F,0xFF,0xC0,0x00,0x00,0x00,0x00,
0x03,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,
0xC0,0x00,0x00,0x00,0x00,0x01,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x00,0x1F,0xFF,0xC0,0x00,0x00,0x00,0x00,
0x01,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x01,0xFF,0xFE,0x00,0x00,
0x00,0x00,0x00,0x1F,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x01,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,
0xE0,0x00,0x00,0x00,0x00,0x00,0xFF,0xFE,0x00,0x00,
0x00,0x00,0x00,0x0F,0xFF,0xE0,0x00,0x00,0x00,0x00,
0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,
0x00,0x00,0x00,0x0F,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,
0xF0,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x80,0x00,
0x00,0x00,0x00,0x07,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x00,0x7F,0xFF,0x80,0x00,0x00,0x00,0x00,0x07,0xFF,
0xF8,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x80,0x00,
0x00,0x00,0x00,0x03,0xFF,0xF8,0x00,0x00,0x00,0x00,
0x00,0x3F,0xFF,0x80,0x00,0x00,0x00,0x00,0x03,0xFF,
0xFC,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x03,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x00,0x3F,0xFF,0xC0,0x00,0x00,0x00,0x00,0x01,0xFF,
0xFC,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xC0,0x00,
0x00,0x00,0x00,0x01,0xFF,0xFC,0x00,0x00,0x00,0x00,
0x00,0x1F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x01,0xFF,
0xFE,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,0xE0,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFE,0x00,0x00,0x00,0x00,
0x00,0x0F,0xFF,0xE1,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0x09,0xBD,0x8F,0x94,0xB0,
0x00,0x00,0x00,0x3F,0xF8,0x00,0x00,0x07,0xFF,0xF0,
0x00,0x00,0x3F,0xFF,0xE0,0x00,0x00,0xFF,0xFF,0xC0,
0x00,0x07,0xFF,0xFF,0xC0,0x00,0x03,0xFF,0xFF,0xE0,
0x00,0x0F,0xFF,0xFF,0xE4,0x00,0x07,0xFF,0xFF,0xF0,
0x00,0x1F,0xFF,0xFF,0xE0,0x00,0x3F,0xFF,0xE0,0x00,
0x00,0x7F,0xFE,0x00,0x00,0x01,0xFF,0xF8,0x00,0x90,
0x00,0x7F,0xFC,0x00,0x34,0x00,0x1F,0xFE,0x00,0x0D,
0x00,0x07,0xFF,0x80,0x03,0x40,0x01,0xFF,0xE0,0x00,
0xA0,0x00,0x7F,0xF8,0x00,0x2C,0x00,0x3F,0xFC,0x00,
0x08,0x00,0x1F,0xFE,0x00,0x00,0x00,0x7F,0xFC,0x00,
0x00,0x00,0xFF,0xF0,0x00,0x00,0x03,0xFF,0xE0,0x00,
0x00,0x0F,0xFF,0x80,0x00,0x00,0x7F,0xFF,0x00,0x00,
0x03,0xFF,0xFC,0x00,0x00,0x7F,0xFF,0xF0,0x00,0x00,
0xFF,0xFF,0xC0,0x00,0x01,0xFF,0xFE,0x00,0x00,0x03,
0xFF,0xF8,0x00,0x00,0x07,0xFF,0xC0,0x00,0x00,0x0F,
0xFE,0x00,0x00,0x00,0x1F,0xFF,0x00,0x00,0x00,0x3F,
0xFF,0x80,0x00,0x00,0x7F,0xFF,0x80,0x00,0x00,0xFF,
0xFF,0xC0,0x00,0x01,0xFF,0xFF,0xC0,0x00,0x00,0x3F,
0xFF,0xC0,0x00,0x00,0x1F,0xFF,0x80,0x00,0x00,0x0F,
0xFF,0x80,0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,0x0F,
0xFF,0x00,0x00,0x00,0x1F,0xFF,0x00,0x01,0x00,0x03,
0xFF,0xC0,0x00,0x58,0x00,0x7F,0xF8,0x00,0x1A,0x00,
0x0F,0xFF,0x00,0x06,0x80,0x03,0xFF,0xC0,0x01,0xA0,
0x00,0xFF,0xF0,0x00,0x58,0x00,0x3F,0xFC,0x00,0x10,
0x00,0x07,0xFF,0x80,0x00,0x00,0x0F,0xFF,0x80,0x00,
0x00,0x1F,0xFF,0x80,0x00,0x00,0x3F,0xFF,0xC0,0x00,
0x00,0x7F,0xFF,0xFF,0xC0,0x00,0x0F,0xFF,0xFF,0xF0,
0x00,0x01,0xFF,0xFF,0xF8,0x00,0x01,0xFF,0xFF,0xF0,
0x00,0x01,0xFF,0xFF,0xE0,0x00,0x01,0xFF,0xFF,0xC0,
0x00,0x01,0xFF,0xFF,0x80,0x00,0x01,0xFF,0xFF,0x00,
0x00,0x00,0xFF,0xFE,0x00,0x00,0x00,0x1F,0xFC,0x02,
0xBE,0xB3,0x88,0x8B,0x7F,0xFD,0xFF,0xF7,0xFF,0xDF,
0xFF,0x7F,0xFD,0xFF,0xF7,0xFF,0xDF,0xFF,0x7F,0xFD,
0xFF,0xF7,0xFF,0xDF,0xFF,0x7F,0xFD,0xFF,0xF7,0xFF,
0xDF,0xFF,0x7F,0xFC,0xFF,0xC0,0x09,0xBD,0x8F,0x94,
0xB1,0xFF,0xC0,0x00,0x00,0x03,0xFF,0xF8,0x00,0x00,
0x07,0xFF,0xFC,0x00,0x00,0x0F,0xFF,0xFC,0x00,0x00,
0x1F,0xFF,0xFC,0x00,0x00,0x3F,0xFF,0xFC,0x00,0x00,
0x7F,0xFF,0xFC,0x00,0x01,0x1F,0xFF,0xFF,0x80,0x00,
0x47,0xFF,0xFF,0xF0,0x00,0x0F,0xFF,0xFF,0xF0,0x00,
0x00,0x1F,0xFF,0xE0,0x00,0x00,0x0F,0xFF,0xC0,0x00,
0x00,0x0F,0xFF,0x80,0x01,0x00,0x01,0xFF,0xE0,0x00,
0x68,0x00,0x3F,0xFC,0x00,0x1A,0x00,0x0F,0xFF,0x00,
0x06,0x80,0x03,0xFF,0xC0,0x01,0x60,0x00,0xFF,0xF0,
0x00,0x58,0x00,0x1F,0xFE,0x00,0x10,0x00,0x03,0xFF,
0xC0,0x00,0x00,0x07,0xFF,0xC0,0x00,0x00,0x07,0xFF,
0x80,0x00,0x00,0x0F,0xFF,0x80,0x00,0x00,0x0F,0xFF,
0x80,0x00,0x00,0x0F,0xFF,0xC0,0x00,0x00,0x1F,0xFF,
0xE0,0x00,0x00,0x1F,0xFF,0xFC,0x00,0x00,0x0F,0xFF,
0xF8,0x00,0x00,0x0F,0xFF,0xF0,0x00,0x00,0x0F,0xFF,
0xE0,0x00,0x00,0x07,0xFF,0xC0,0x00,0x00,0x03,0xFF,
0x80,0x00,0x00,0x1F,0xFF,0x00,0x00,0x00,0xFF,0xFE,
0x00,0x00,0x07,0xFF,0xFC,0x00,0x00,0x1F,0xFF,0xF8,
0x00,0x00,0x7F,0xFF,0xF0,0x00,0x01,0xFF,0xFE,0x00,
0x00,0x07,0xFF,0xF0,0x00,0x00,0x1F,0xFF,0x80,0x00,
0x00,0x3F,0xFE,0x00,0x80,0x00,0x1F,0xFF,0x00,0x20,
0x00,0x0F,0xFF,0x80,0x00,0x00,0x1F,0xFE,0x00,0x14,
0x00,0x0F,0xFF,0x80,0x06,0x80,0x03,0xFF,0xC0,0x01,
0xA0,0x00,0xFF,0xF0,0x00,0x68,0x00,0x3F,0xFC,0x00,
0x14,0x00,0x0F,0xFF,0x00,0x04,0x80,0x07,0xFF,0xC0,
0x00,0x00,0x1F,0xFF,0x80,0x00,0x00,0x7F,0xFE,0x00,
0x00,0x07,0xFF,0xFC,0x00,0x07,0xFF,0xFF,0xF8,0x00,
0x13,0xFF,0xFF,0xFC,0x00,0x03,0xFF,0xFF,0xF0,0x00,
0x07,0xFF,0xFF,0xC0,0x00,0x11,0xFF,0xFF,0xE0,0x00,
0x03,0xFF,0xFF,0x00,0x00,0x07,0xFF,0xFC,0x00,0x00,
0x0F,0xFF,0xE0,0x00,0x00,0x1F,0xFC,0x00,0x00,0x00,
0x00,0x10,0xCC,0x18,0x85,0x38,0x00,0x07,0xFC,0x00,
0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xFC,0x00,0x00,
0x00,0x00,0x04,0x01,0xFF,0xFF,0xF0,0x00,0x00,0x00,
0x00,0xC0,0x3F,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x1C,
0x07,0xFF,0xFF,0xFF,0x80,0x00,0x00,0x03,0xC1,0xFF,
0xFF,0xFF,0xFE,0x00,0x00,0x00,0x7C,0x3F,0xFF,0xFF,
0xFF,0xF8,0x00,0x00,0x0F,0xC3,0xFF,0xFF,0xFF,0xFF,
0xC0,0x00,0x03,0xFC,0x7F,0xFF,0xFF,0xFF,0xFF,0x00,
0x00,0x7F,0xCF,0xFF,0xFF,0xFF,0xFF,0xFE,0x00,0x1F,
0xFD,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x07,0xFF,0xE3,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBF,0xFE,
0x01,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0xFF,0x80,0x03,
0xFF,0xFF,0xFF,0xFF,0xFF,0x3F,0xE0,0x00,0x0F,0xFF,
0xFF,0xFF,0xFF,0xE3,0xF8,0x00,0x00,0x3F,0xFF,0xFF,
0xFF,0xFC,0x3F,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,
0x83,0xE0,0x00,0x00,0x03,0xFF,0xFF,0xFF,0xF0,0x3C,
0x00,0x00,0x00,0x0F,0xFF,0xFF,0xFE,0x03,0x80,0x00,
0x00,0x00,0x3F,0xFF,0xFF,0xC0,0x30,0x00,0x00,0x00,
0x00,0xFF,0xFF,0xF0,0x02,0x00,0x00,0x00,0x00,0x03,
0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFE,
0x00,0x00,};
/* font data size: 40352 bytes */

static const unsigned char font_tgx_Arial_96_index[] = {
0x00,0x00,0x00,0x05,0x00,0x2D,0x00,0x5E,
0x02,0x38,0x05,0x0A,0x09,0x97,0x0D,0x36,0x0D,0x48,
0x0E,0x68,0x0F,0xA0,0x10,0x5A,0x10,0xB3,0x10,0xD3,
0x10,0xE2,0x10,0xEB,0x12,0x10,0x13,0xD3,0x14,0x99,
0x17,0x08,0x19,0xB5,0x1B,0x9D,0x1D,0x98,0x20,0x42,
0x21,0xE3,0x24,0x4A,0x26,0xC8,0x26,0xE3,0x27,0x15,
0x29,0x12,0x29,0x52,0x2B,0x4F,0x2D,0x49,0x34,0xA3,
0x37,0x86,0x3A,0x2A,0x3D,0x44,0x3F,0xBA,0x40,0x55,
0x40,0xE2,0x44,0x0A,0x44,0xA1,0x44,0xC4,0x45,0xB6,
0x49,0x5E,0x49,0xD1,0x4C,0xB4,0x4F,0xA4,0x52,0xE8,
0x54,0xB1,0x58,0x3A,0x5B,0x77,0x5E,0xCE,0x5F,0x5D,
0x60,0xCB,0x64,0x35,0x69,0x13,0x6C,0xE2,0x6F,0x7D,
0x72,0x5F,0x72,0xA9,0x73,0xCC,0x74,0x16,0x74,0xFA,
0x75,0x13,0x75,0x4B,0x77,0x62,0x79,0x24,0x7A,0xBF,
0x7C,0x7A,0x7E,0x39,0x7E,0xC9,0x80,0xFE,0x81,0xEC,
0x82,0x0D,0x82,0x7C,0x84,0x7F,0x84,0xA0,0x86,0x18,
0x86,0xE8,0x88,0x8F,0x8A,0x52,0x8C,0x00,0x8C,0x80,
0x8E,0x73,0x8F,0x01,0x8F,0xD1,0x91,0x65,0x93,0xF7,
0x96,0x1D,0x98,0x9B,0x9A,0x3D,0x9B,0x77,0x9B,0x9C,
0x9C,0xD7,
};
/* font index size: 190 bytes */

const ILI9341_t3_font_t font_tgx_Arial_96 = {
	font_tgx_Arial_96_index,
	0,
	font_tgx_Arial_96_data,
	1,
	0,
	32,
	126,
	0,
	0,
	16,
	7,
	7,
	5,
	8,
	8,
	148,
	95
};



