// 3D model [spot]
//
// - vertices   : 2930
// - textures   : 3225
// - normals    : 2930
// - triangles  : 5856
//
// - memory size: 133kb
//
// - model bounding box: [-0.55,0.55]x[-0.98,0.98]x[-1.0,1.0]
//
// object [spot] (tagged []) with 5856 triangles (416 chains)

#pragma once

#include <tgx.h>

#include "spot_texture.h" // texture for object [spot]


// vertex array: 34kb.
const tgx::fVec3 spot_vert_array[2930] PROGMEM = {
{0.3645373532591074,-0.5973669152440554,0.2727239917830339},
{0.33719830328614614,-0.6058702760157845,0.20140589519002464},
{0.3693885997453882,-0.5887692537846883,0.2030404404424216},
{0.3910311896613849,-0.5738674167257987,0.2743422381511477},
{0.3973423504970287,-0.5639122910468483,0.20511738398250434},
{0.3700056289361078,-0.5830972420541485,0.13439536087185064},
{0.33163805533354795,-0.6038387365104904,0.13366423949114886},
{0.30540849369786177,-0.6183039963117953,0.2003499603296799},
{0.33420047278406484,-0.6127716893036826,0.27166107168656783},
{0.3532503758930188,-0.6014905329676951,0.3402037011273589},
{0.382048176009323,-0.5775940401965413,0.34115602165190356},
{0.401289008905594,-0.5425281548673416,0.343607839530499},
{0.40910665233140986,-0.5387503063317091,0.2768115191200466},
{0.416424851374549,-0.528208420818565,0.20750167791192667},
{0.4024462296896984,-0.5540328387592125,0.13455485709662157},
{0.3685887902094931,-0.5877459166929099,0.07003106683764976},
{0.31997736783496683,-0.6137519507727127,0.07289384944138487},
{0.2928490391516664,-0.6180373931331637,0.13072461929007884},
{0.27865271094103355,-0.6291613816564208,0.2000065195537133},
{0.3045935494837037,-0.6236092831459641,0.2708589337386323},
{0.32018576071258725,-0.617471589007334,0.3399731883353543},
{0.33920539446501535,-0.6074943434139992,0.4037111395306737},
{0.37308961068368585,-0.5808049204003239,0.4057042602373001},
{0.39444231330064633,-0.5434653407136234,0.4088499449039501},
{0.4130742664483393,-0.4989088479075434,0.34697239492895143},
{0.42044951158646937,-0.4948515899270567,0.27974997511509636},
{0.42838706823236855,-0.48440516930757105,0.21000588506143228},
{0.4234554915306923,-0.514867784032798,0.13577960182989907},
{0.407802741588757,-0.5505343996684342,0.06372572703210709},
{0.36380856029044617,-0.6182062030060964,0.02138588248853695},
{0.3057193367052621,-0.6461401622553931,0.028080067104835026},
{0.2691772381424162,-0.6279692346917095,0.0645441638643258},
{0.2599939810548754,-0.6288808080055464,0.12898645970188183},
{0.2443668436453852,-0.6590023103668471,0.014287718383220556},
{0.22680712424232016,-0.6354620646378825,0.05740990937238237},
{0.27540923296868464,-0.6434089349319435,0.4591983626606532},
{0.3140911421967054,-0.6565237157497865,0.5052159340221164},
{0.2545524821163403,-0.6790627443013572,0.5004915859920404},
{0.22252983132401077,-0.6546237315247782,0.4669310190469927},
{0.19094259358324567,-0.6885859495468037,0.5138345511898478},
{0.18175467967162406,-0.6600547526091312,0.47236902536746717},
{0.11822046452984414,-0.6796786092860565,0.5507992565380355},
{0.3260812999990104,-0.6217314188353399,0.4614790422542755},
{0.3668541232393567,-0.589216308896455,0.46812782283578463},
{0.29923005234852373,-0.6257549148412402,0.40345035738214313},
{0.25960513624412,-0.6378125965927183,0.4054981957717202},
{0.22842886322849465,-0.6469679127357736,0.4059429224714464},
{0.3900369577201121,-0.5454887307767757,0.47349830520708613},
{0.40662456509628864,-0.4986410805228915,0.41275003507170643},
{0.4195006836799854,-0.44935441865663434,0.35066525642510754},
{0.4267432093318098,-0.44500960178915183,0.28277458235564285},
{0.4349811311309272,-0.43525471954568024,0.21244606087982545},
{0.4358601066761976,-0.4691319505282294,0.1376120621057344},
{0.4304092940895007,-0.5026983385033782,0.06174774100374353},
{0.43727112437271126,-0.4884729051422398,-0.01642287222431452},
{0.4174866072649948,-0.5662709724438256,-0.012894163777010295},
{0.2881433184179139,-0.6287934925540295,0.3396914504784596},
{0.2802907488114912,-0.6334049126001435,0.27002070540406975},
{0.26241087275286407,-0.6387113636403325,0.3385807979351642},
{0.35027815792338246,-0.5171857182190676,-0.3498386701507472},
{0.2741239495223554,-0.44033182199988474,-0.36470558102903006},
{0.3410134064144259,-0.4291566084117378,-0.3496733528958752},
{0.39527006378102686,-0.42564885567279764,-0.314718183559199},
{0.3826919819385078,-0.3506495396438345,-0.31184981276656676},
{0.33009315394470834,-0.3568454440834759,-0.35213215601059195},
{0.26715966910936495,-0.3730605055331802,-0.3762626541918111},
{0.2015310473371989,-0.39455989810868913,-0.3873004914695714},
{0.2031912051220408,-0.45556312936249826,-0.36273923706086875},
{0.2801102968783562,-0.523479415964408,-0.3579904407043679},
{0.141416105276822,-0.41644231446485236,-0.3900876006819919},
{0.1390970068845323,-0.4705802228173902,-0.3538225831519597},
{0.2053461504654787,-0.5327185549409195,-0.34501885722701264},
{0.26083686621351887,-0.31657788625590766,-0.38658683317917303},
{0.20025973436311237,-0.29103054934807376,-0.4191694670672311},
{0.25747231081506644,-0.2663982783721373,-0.3912937181189458},
{0.319983188865068,-0.29720666228537135,-0.35417068075200725},
{0.31314813532032254,-0.2471981926865742,-0.3527433641712105},
{0.25938742971833784,-0.218034133356307,-0.38599541652089836},
{0.20515405647214144,-0.23711954474887786,-0.4177328368382726},
{0.15363328325307105,-0.25562122324290754,-0.4408365053096526},
{0.1467598109096582,-0.3148793096723983,-0.43740791858008776},
{0.19980220139716365,-0.34161297251484213,-0.40756815407568153},
{0.37079612482384106,-0.2892935539658969,-0.30821609293623814},
{0.36203780293368276,-0.23964121498868685,-0.3024859873252891},
{0.31205378166131037,-0.20377458875877594,-0.3448023149072506},
{0.2644761742327446,-0.16958593266581642,-0.3707513028920624},
{0.21291348959694606,-0.17945094879880136,-0.4045784730157418},
{0.162864272787441,-0.1900557014370377,-0.43209331809775725},
{0.11768609396656052,-0.19850050264594926,-0.4545170902533254},
{0.10910577917689472,-0.2681317811362534,-0.4561283513853179},
{0.10222590370037063,-0.3317335202272064,-0.44703939498541545},
{0.1433288957680529,-0.36651417508145073,-0.41921952792610084},
{0.0978644386867989,-0.3854872405930698,-0.42364583921499915},
{0.09502750145671278,-0.43380644725651946,-0.3894624220491306},
{0.09272120933064558,-0.4811081378582917,-0.34800038884481077},
{0.13272996415991767,-0.5434164440607739,-0.30967600728560124},
{0.4068248085317674,-0.29863514307218836,-0.2466176031442876},
{0.39888841609188846,-0.24994106207022607,-0.23948823831762917},
{0.35887349097070914,-0.1997501613880596,-0.2933283427701933},
{0.3141935923264853,-0.16336034097265922,-0.32938799435825766},
{0.27063365987371857,-0.11915527539584461,-0.34561376650334796},
{0.22196519140420126,-0.11759482021457482,-0.3810289136386153},
{0.17336773950191775,-0.11949747047136956,-0.41376755113338365},
{0.12714992470497563,-0.12666310031555805,-0.4458088292220368},
{0.08311290062512043,-0.13417756120958677,-0.4722223354089186},
{0.07626201387849997,-0.2042458593557633,-0.47096615711309503},
{0.06982337248364145,-0.27570610550384217,-0.46511485765544036},
{0.06441528625788677,-0.34254666574306325,-0.45062631373373097},
{0.31706219596032154,-0.1223789152976089,-0.30554144602537153},
{0.35856031955126844,-0.1647939442659652,-0.27910267656785076},
{0.27600414224502,-0.06547040617401736,-0.30969975708841385},
{0.23173753673797626,-0.053629616004107324,-0.34464514709452015},
{0.18485961712756616,-0.03870065294494644,-0.38580448673358136},
{0.13466836718359354,-0.06208245023455841,-0.4399866349148878},
{0.0892552515878315,-0.07292481732152285,-0.47452629912294536},
{0.04447045798118527,-0.07734391053309575,-0.4954529023365033},
{0.041060382127342025,-0.13712669297384203,-0.48807882140439335},
{0.03747241559360828,-0.20675204565550329,-0.4805568863077148},
{0.03403754215153422,-0.2794047880300994,-0.46930250671019247},
{0.031087094834476102,-0.34827106674451325,-0.4507299280695311},
{0.06065606501857782,-0.3987533681935423,-0.42345490942768216},
{0.05844547062737316,-0.44686418197937144,-0.38694540863340254},
{0.0576829156841253,-0.4894170762246429,-0.3444449036590413},
{0.09097012705562403,-0.5260266987366619,-0.30045200298735264},
{0.0897983536962668,-0.5671965162299051,-0.24800673376762097},
{0.11103044456953191,-0.5984507910488857,-0.2462571649604257},
{0.09364710237853112,-0.6007396200846494,-0.1921329942389265},
{0.11233912855686769,-0.6325538779993586,-0.18132974447424163},
{0.10695700412536403,-0.6227803684595633,-0.13429884819277388},
{0.1309906403657004,-0.6523628434334997,-0.11231875495151372},
{0.11872689414864233,-0.6354830203462465,-0.08285945297451724},
{0.17386369126653392,-0.65190065364347,-0.0275014567127828},
{0.35835192667364807,-0.12994625442907629,-0.25816850601516145},
{0.39406860316815384,-0.17790651309236985,-0.2185071735464451},
{0.39159932219925503,-0.14453780729945534,-0.200850918180183},
{0.35550427874817586,-0.09038045670637967,-0.22888538333520575},
{0.3181553854133135,-0.07725403382833432,-0.2723023163625081},
{0.2787318769504089,-0.007259988742127791,-0.2621247109130926},
{0.24165424361825918,0.010366090404090084,-0.2929883946122874},
{0.21159793679409097,0.0312845441755064,-0.32003918717464075},
{0.1735062800183246,0.012601365962923532,-0.3991043763086403},
{0.13741589339132632,-0.014221940743077782,-0.44703240974929404},
{0.09356851847216588,-0.027911024390698234,-0.4835139695990882},
{0.04737165938358784,-0.03421857618767932,-0.5062660478523601},
{0.0,-0.07794766777518483,-0.5025138118491724},
{0.0,-0.13745993530507147,-0.49336664514825873},
{0.0,-0.20719537530800528,-0.4836385396432523},
{0.0,-0.2802849277813901,-0.47019661693372583},
{0.0,-0.3498613721681416,-0.44991032703129213},
{0.02895194099338207,-0.4065360854387514,-0.42125339584343524},
{0.027750829642315164,-0.4558262399230693,-0.3840581777032427},
{0.027602160533532337,-0.4977737470378233,-0.34232721290825063},
{0.05852289032771818,-0.5275029119703081,-0.2987180345408284},
{0.061119535435229695,-0.5622148786693592,-0.25252944131499394},
{0.06561814391798403,-0.5918159809396191,-0.20647042421921066},
{0.0721638922667033,-0.6145668949868707,-0.16113193422934508},
{0.07704168265024516,-0.6302429290492104,-0.11882655018397364},
{0.39556693631618445,-0.21136975241412673,-0.23075222261481834},
{0.4208115796587596,-0.1983697623098779,-0.15033415623295526},
{0.41674384382409085,-0.1632008447478883,-0.1360723996439858},
{0.38536616316696637,-0.10624963254747487,-0.1758811438789831},
{0.3472733421851798,-0.04126982279038064,-0.18961295388754584},
{0.31496546091789496,-0.024409325523063213,-0.22871112497809837},
{0.2785933364340021,0.05021569827039733,-0.20747466833225742},
{0.2480166295187929,0.07170461299172426,-0.23234937356984564},
{0.22224809346711613,0.0926533361196664,-0.2562344105537604},
{0.20643002627030885,0.11221432567149948,-0.2806497899481288},
{0.1964306607625899,0.058312751141067425,-0.34201404148880993},
{0.17465185874222677,0.04614330561164765,-0.41958043179237087},
{0.1407781203777383,0.01912091967618773,-0.4649937802293369},
{0.09761436723365441,0.0025484469782741655,-0.49936114194640113},
{0.049935823143135064,-0.005873419372038908,-0.5215904916965917},
{0.0,-0.008046992011800395,-0.5296712456829785},
{0.0,-0.03552702733381105,-0.5142082613223402},
{0.31083718637017443,-0.5184838079316192,0.8315300752251721},
{0.3509988014499022,-0.4672145032129176,0.7923917972372228},
{0.30630842495149624,-0.4629500165608306,0.8272050498600334},
{0.2493042413771626,-0.5158736580342731,0.8497044954069163},
{0.2509411150416,-0.459682090262057,0.8494378922282846},
{0.30059217339218786,-0.4153095420071727,0.8247660382476605},
{0.34215782093230784,-0.420359867722912,0.7882763289557247},
{0.369434003780177,-0.42579554563134603,0.7389186505222338},
{0.37805029253586775,-0.4727735869594955,0.7423262815434346},
{0.35916919929984653,-0.5221685199856337,0.7978996559189108},
{0.3130200726580977,-0.5876714075076154,0.8378866400956047},
{0.24659746238013774,-0.5857853937548497,0.8526219956936021},
{0.18246600954998202,-0.5134963493409721,0.85462326584237},
{0.19186231633922404,-0.45711152336939853,0.8617621771583943},
{0.2505557628489053,-0.4111509981029263,0.8505206038270945},
{0.2948491450944142,-0.36980422129460877,0.824067514635525},
{0.3347604558797934,-0.37601526041251315,0.7857139115052079},
{0.36290397221273074,-0.3814800434714528,0.7366496129888138},
{0.3818816945484307,-0.3862241830038727,0.6795488003148014},
{0.38598784918176693,-0.43138024191036894,0.680186785213885},
{0.39180655087085525,-0.4791150171516652,0.6814022162990008},
{0.3864046349370077,-0.5277683509429195,0.7466093954918451},
{0.36455015952533,-0.5908135995562047,0.8046369161579572},
{0.248300695787728,-0.36459789197215925,0.8527488941498066},
{0.19786263416746755,-0.4083906656289711,0.8676705227110401},
{0.20024692809688988,-0.362147238299584,0.8727988502301345},
{0.24432842484671774,-0.31434028228503375,0.8559225197609419},
{0.2902365608422798,-0.32067472724108204,0.8249627890650786},
{0.33092672545519,-0.32859016397259694,0.7848675337285037},
{0.3608049087582637,-0.3344740611988179,0.7357857721218063},
{0.3819329196133206,-0.33867335231377216,0.6797408943081387},
{0.39637140267616044,-0.3415349707114871,0.6187574545566733},
{0.3942991159601586,-0.39027561995425836,0.6170833262995886},
{0.3953864843830494,-0.43687645853185475,0.6155745152973761},
{0.396617050146428,-0.48572072211042616,0.614010986612213},
{0.3968906385611811,-0.5344043252582064,0.682940132451719},
{0.39215348426488245,-0.5961328568626162,0.7515025533948538},
{0.14745367769771273,-0.40612744912565213,0.8789505148410074},
{0.13679304317050556,-0.4541253349275195,0.8681408619432113},
{0.1221298683457622,-0.5086625659449947,0.8530550803331259},
{0.09345885026506061,-0.449610543981084,0.8725369038755837},
{0.10426943452767289,-0.40345908892729476,0.8870929717464663},
{0.11139158127700595,-0.35844273474322563,0.8971726674695808},
{0.15362979063501037,-0.36068615974420065,0.8867588446186615},
{0.17432006002646241,-0.584234671335909,0.8502120892317347},
{0.1020736255529251,-0.5816524623830482,0.8284030178548457},
{0.06717166043137326,-0.5458962028838548,0.8193408381934084},
{0.0801000518653782,-0.4986864845576803,0.8517663042687361},
{0.05835897012007039,-0.44524477140523744,0.8753309983241254},
{0.06650294049335559,-0.40089783568279813,0.8924518120575655},
{0.07243678215784423,-0.3560421419295201,0.9042894588712208},
{0.11368483429564663,-0.31277093256976946,0.9045176432511851},
{0.15484056489604514,-0.31381755378195236,0.8928418210743411},
{0.1987928347776279,-0.31319703197317206,0.8775965432394848},
{0.41731779739206215,-0.359207618098514,-0.2523552760943682},
{0.43029403769349833,-0.31983300628845884,-0.1739787148213322},
{0.424897942789752,-0.2722390999756099,-0.16742504987167536},
{0.42263356208041286,-0.23323377431517037,-0.16016424618533343},
{0.4283055738109528,-0.4334152740337236,-0.25691675170221473},
{0.4060738956487218,-0.5162322334885026,-0.318152591318865},
{0.43772632892661956,-0.5230137335563176,-0.26051705881976284},
{0.44344723731000885,-0.44900399264454643,-0.18321634033001746},
{0.43706389570111104,-0.37806891983219143,-0.1793883145149132},
{0.4434227889835841,-0.3474887202989215,-0.09490316425375266},
{0.44126318681606536,-0.3006759962256441,-0.08997158755207636},
{0.4405716484400513,-0.2599427559899855,-0.08465465865770536},
{0.4388823855047037,-0.22185563961769805,-0.07731666811222246},
{0.448445173754838,-0.5351109983124834,-0.1856089001221834},
{0.4440270119080813,-0.46896546906733716,-0.10056469813011049},
{0.4450212438493541,-0.40278384943556383,-0.09868799802550657},
{0.448434695900656,-0.3762050259938099,-0.013994338466123631},
{0.44917978775360046,-0.3293911377145122,-0.010803249764684822},
{0.4498829681898169,-0.2860954800283368,-0.007315288528088473},
{0.448372992981584,-0.24403620913564106,-0.0021857968029738205},
{0.44248327472526194,-0.2009308991337725,0.005932211776060351},
{0.4337261170411239,-0.1829826841817582,-0.06631608542710932},
{0.4077422028757053,-0.12328027852464829,-0.11551647962726778},
{0.372575031622746,-0.058028335610326276,-0.14169563114227818},
{0.3354939056725356,0.009709478208682766,-0.14683641566578903},
{0.30883824463344683,0.029036462350450452,-0.18009056358631334},
{0.2753615005218554,0.10169339586671938,-0.1503357861213836},
{0.24712368350127978,0.12769593732846155,-0.16901838223095633},
{0.22154025620681886,0.149744835145517,-0.1911072123145056},
{0.2037465313936885,0.16361052884640573,-0.2198985045191567},
{0.19491835714231662,0.17530614252559362,-0.24932240299107808},
{0.20096407900534896,0.1313387379657479,-0.30531989761972256},
{0.19446198838238812,0.08591724008664021,-0.3642142860884948},
{0.20400149251211794,0.10856221138605131,-0.39193985246017105},
{0.1863404871852933,0.06961719159745947,-0.44924789380578367},
{0.15014066519239377,0.04014997301952547,-0.4919160444470575},
{0.10295434740722588,0.02013959994388528,-0.5222377902438371},
{0.052335368171422356,0.009568609280235455,-0.5425031244379068},
{0.0,0.0066417953453879125,-0.5501228528402843},
{0.054742364118239094,0.013984442714951717,-0.5700785082329739},
{0.0,0.010692068089753298,-0.5767820064974338},
{0.4452599060835004,-0.4285570423113215,-0.0161225070710963},
{0.44184528982617827,-0.45059429806817475,0.06244044358577786},
{0.44754989932528444,-0.4005835000573372,0.06414484119938836},
{0.4498468778031899,-0.3525274039544586,0.06640456508464654},
{0.45106463730034596,-0.3062944544792536,0.06876324648162391},
{0.4493765385710186,-0.26058190509508944,0.07232455269749445},
{0.4429559423694736,-0.21409271387483272,0.07819215103943229},
{0.4300437333991498,-0.15450003463512912,0.018385723574415196},
{0.42263356208041286,-0.13989087896972424,-0.05001836534996905},
{0.39111501249484115,-0.07416166979741069,-0.08680378297104209},
{0.3553017069006566,-0.006222681178106643,-0.10435186031390485},
{0.32200541472220007,0.05488416441150258,-0.10704105980002432},
{0.3011195587193501,0.0759656070257505,-0.13176355674252826},
{0.29466520054321854,0.11060422874552728,-0.08378499676059672},
{0.27103880356875715,0.14099931952158118,-0.09293682028559136},
{0.2426729238859567,0.17065513947479177,-0.10512419458772261},
{0.20637181596929757,0.20304684357553282,-0.11932157058377363},
{0.1858829542193446,0.20587353579264095,-0.16853884577122535},
{0.17570546519053107,0.21218236821624428,-0.20231618787723912},
{0.1743060895542197,0.22395714790480756,-0.22672422113161989},
{0.19623507415119196,0.19084712868958717,-0.2733093545700034},
{0.20625539536727497,0.15097540090889564,-0.3299691660035543},
{0.22353104850140493,0.17369488139360117,-0.3539797509646902},
{0.22692820166842367,0.13146912904001318,-0.4226760556001511},
{0.21482977270623765,0.08475885509651561,-0.49900140228615136},
{0.16121692126882156,0.04675917059634708,-0.5298470407920326},
{0.10873206904440225,0.025470499310498995,-0.5533174341597838},
{0.4414389819251195,-0.5501071360590113,-0.10210377848884893},
{0.4424902599613833,-0.42035637510485135,0.13959703337021928},
{0.4453961181878668,-0.3704445346057329,0.14157618360460308},
{0.44662784815726564,-0.3213057269040444,0.14339350920217547},
{0.44466732521920543,-0.2724416718231292,0.1459524340346317},
{0.4379987531353524,-0.22335420560693262,0.1501587103857073},
{0.42997388103793627,-0.16552622985268722,0.0874708730206315},
{0.4088866173935872,-0.10246200468127241,0.03652056075147173},
{0.40313776806571244,-0.08914721326915453,-0.026783141598303504},
{0.3690917272102306,-0.02031853840919397,-0.05480208788707666},
{0.3356242967468009,0.042820661629923366,-0.06990766099950577},
{0.3105612695433809,0.08521638806246433,-0.07837376717858743},
{0.31436007378737757,0.08774038671431372,-0.044985502724533104},
{0.2923274748546052,0.12718019406150152,-0.03621088195009163},
{0.2676276799294957,0.16195735629768515,-0.03750664325060289},
{0.23836186899306078,0.19289263866712383,-0.042795631200488474},
{0.2024985025400065,0.21813029677357762,-0.044531462376645056},
{0.15751591033052392,0.23271197717690517,-0.09016484575143384},
{0.15034207283389284,0.2323790142551206,-0.13534954412602762},
{0.14270720975325235,0.23633149369378706,-0.17039598721468946},
{0.1408316738546687,0.2460852117312384,-0.19497726596694},
{0.14618818575372736,0.26398255088016886,-0.20843409051352543},
{0.1826522825132181,0.24311182955558183,-0.24215589999237444},
{0.20860243470405013,0.21196233327842162,-0.292238762355864},
{0.43796033433668496,-0.38350226932858494,0.21463360399182965},
{0.4390779721161016,-0.33190000168809874,0.21638573405226938},
{0.4370184916663223,-0.2805620088142038,0.2184382292659274},
{0.43046983280255247,-0.22960133511146402,0.22153152466166717},
{0.4251051714613522,-0.17354563018180824,0.15691576212709754},
{0.4086060437427128,-0.1135830826894789,0.10126438594826623},
{0.38157434415909114,-0.04750402960808751,0.05759385392357806},
{0.37769520969969894,-0.03413778028987566,-0.0003498439090778165},
{0.343901801550606,0.03377594505878951,-0.024374399342456405},
{0.4232249787386876,-0.23372029601102273,0.2920079003020533},
{0.42920550506458727,-0.2858882513567366,0.2895188278308106},
{0.4309250373564607,-0.33884449059874533,0.28755015545060886},
{0.4240026683601984,-0.2893692273572116,0.3589322833747306},
{0.41911882410535134,-0.23659704908700055,0.36128630794762706},
{0.4116900254902909,-0.18286952335659226,0.29561926737679356},
{0.418116442721937,-0.17913475044370802,0.22640489106233222},
{0.40446845554683053,-0.12251853852561458,0.16712934154253808},
{0.38119481299649755,-0.06024149125477543,0.11761915212039753},
{0.3506704953521985,0.007687252351550633,0.07886040529504183},
{0.34876469009708894,0.021752025281897944,0.025544426392783356},
{0.3174580260071983,0.08489506720088202,-0.0005314600482330215},
{0.2916743552772586,0.12981362807925215,0.011719479902602564},
{0.2645378771518166,0.1681439470891648,0.01625522655740207},
{0.23403800783394232,0.1995006720379252,0.016951421757497087},
{0.19812923734609925,0.22282670385916836,0.0180504322405902},
{0.15800604106503896,0.23581575042682704,-0.03516775335596935},
{0.10739497843017295,0.2465462373152478,-0.07234317999381805},
{0.10381329860894845,0.24698863560293358,-0.11571649022154257},
{0.09993730750581085,0.25037298250372986,-0.15074814789374757},
{0.09869789377667852,0.2592721733223355,-0.17554515402154594},
{0.10183915446045164,0.27646400362300916,-0.18813057036199238},
{0.3997080171301274,-0.6025953644808894,0.6851719153924917},
{0.394972027039849,-0.5411916463561225,0.6121703768942359},
{0.39109522099249727,-0.609163814847003,0.6123356941491082},
{0.3896783822658826,-0.5456971236543962,0.5403435222703881},
{0.36800785140540043,-0.6144993710376977,0.5344957154307941},
{0.39799779848641575,-0.4916884421701033,0.5447360715846998},
{0.4014659682206683,-0.49611475345900163,0.47815978611207005},
{0.4011958724239759,-0.4420490258797177,0.5485744588333842},
{0.40698081213847764,-0.44666044592583193,0.48268039808860663},
{0.4129974288510044,-0.4494999444091626,0.41700637228165177},
{0.40276056531515936,-0.3936599668550546,0.5519273721716342},
{0.40987037148067795,-0.3964063288567672,0.4867527907473563},
{0.4162874750641623,-0.397638058826166,0.4209984347250059},
{0.42266848826101966,-0.39648200224808183,0.35410315680283416},
{0.35981416943505157,-0.2388045001219506,0.7342001235222588},
{0.32953084243693936,-0.28064583164766005,0.7841224418755592},
{0.3606163073829871,-0.2863807105032921,0.7353084476535137},
{0.3820342055370803,-0.24065116371123269,0.6803707297650807},
{0.3830237806542722,-0.289794162554594,0.6802019198921481},
{0.28805949558445765,-0.27198763147524113,0.8250722244309798},
{0.32944934801552356,-0.23474863918868813,0.781862717990301},
{0.3542632351306152,-0.19218154162996995,0.7321650913989042},
{0.37544130684454186,-0.19201936773135247,0.6798654643523028},
{0.39012194475958856,-0.19079345879205475,0.6225585872127104},
{0.39742733753650517,-0.2409631709246532,0.6217168662600873},
{0.3984623166884858,-0.2914880823140225,0.6203757009247871},
{0.4086374773052589,-0.292063200088014,0.5574014688787358},
{0.4061810026025826,-0.34340584978598987,0.554860007136583},
{0.41525948114830297,-0.29212373880106574,0.492852066087319},
{0.413423528254407,-0.34463059451926736,0.49007194211101984},
{0.40730795403016107,-0.24041471346852483,0.5595820267546185},
{0.4129951004389639,-0.23968021589036442,0.49530737658397517},
{0.4163200728327286,-0.23849575268538672,0.42913157798230295},
{0.4198674085763565,-0.2913367355313931,0.426703044224112},
{0.4192166174110503,-0.3446515502276314,0.4241115216230895},
{0.39936923317824174,-0.1892387780726453,0.5614272932966765},
{0.4042472564029876,-0.18808993957188652,0.4976555801267704},
{0.4066583270708751,-0.1869261992340689,0.43175569835189176},
{0.4085047578189532,-0.18532634732107464,0.3642398986209398},
{0.4246779078519293,-0.3429087338153535,0.3566981720219174},
{0.429673515884718,-0.3920615119892847,0.28550231706103185},
{0.257686524722788,0.14907658088990744,0.12034688682578651},
{0.22955115783199226,0.19556798410160262,0.07310107811298507},
{0.22498281340862644,0.18219474954726939,0.1268152154741608},
{0.2204156331912808,0.16047997885801868,0.1792557114492095},
{0.18336710500963674,0.18407377806391376,0.1847111808599874},
{0.18843722222771989,0.20597715012844103,0.13161640110157174},
{0.19340023249194224,0.21883464141581424,0.07641440844654757},
{0.2611803069894855,0.16313436858413338,0.0686491542916418},
{0.28834123344135226,0.10801969138062611,0.11100529771949505},
{0.2541939066621108,0.12811621570176301,0.17202249944554696},
{0.2159939787264634,0.1351259001495423,0.2317218199567032},
{0.17844484195612223,0.15808171445635363,0.23725878378889692},
{0.1416279907725031,0.19748543141691438,0.18889999412075964},
{0.14625687390892067,0.21902557120313126,0.13596005376303408},
{0.1507425597048505,0.231844643691837,0.08088146694615375},
{0.15476489150473047,0.23706727189856971,0.023795788950404274},
{0.10775180757537216,0.24647172812995335,-0.022523311770297483},
{0.05441289381451521,0.2524615681040149,-0.062059748217163986},
{0.05298208461565776,0.25356174279312815,-0.10502535349660544},
{0.05140831091751659,0.2569262981915806,-0.1405595989077419},
{0.0507920966710111,0.2655530648014534,-0.16590459680926053},
{0.052233732985856644,0.2824422015368684,-0.17830257598045063},
{0.31880268396055905,0.07513552813332955,0.04716373218837556},
{0.2902691586108461,0.12262698431639861,0.06076747953471347},
{0.3187386526294467,0.06042345665573672,0.09757850968823151},
{0.28611759994272107,0.08839467049768061,0.16250511523020136},
{0.2507408716061212,0.10440832430588584,0.22458523705271938},
{0.211861047354662,0.1108359057435522,0.285513959121234},
{0.17392422997958565,0.13295931274590214,0.2908157533373421},
{0.13712833450433057,0.17205684352314354,0.2412962502670398},
{0.0963729743542877,0.20349389868729953,0.19185242058805213},
{0.09985232046633437,0.22440420301657424,0.13950273268258098},
{0.10320581590759464,0.23745728091534538,0.08544049772135777},
{0.10598756977232204,0.24427370716376715,0.03098941794937918},
{0.05460021456316953,0.25062561521011884,-0.014419273663506002},
{0.0,0.2534395011610045,-0.05880113556655211},
{0.0,0.254840041003336,-0.10191517711357236},
{0.0,0.2583303306519728,-0.1378301178933226},
{0.0,0.2669675751160277,-0.16353217778124451},
{0.0,0.2838054867865527,-0.17600746023217761},
{0.2809822871875053,0.04767423652824453,0.2712070313386798},
{0.31568028341431353,0.024560090202682454,0.20510690612832233},
{0.28364831897382226,0.06714674642254044,0.21574658494716542},
{0.24737049517756762,0.08210562957642112,0.2789420161370597},
{0.31760820858380745,0.042725196736264855,0.15019480077233432},
{0.34779956330632184,-0.022134234118338047,0.19256375046641008},
{0.34463059451926736,-0.034664350672823765,0.2526693788786252},
{0.3132261371236777,0.008449807294798503,0.2624137832679147},
{0.3105158655085921,-0.0030863101596184674,0.32221089708476996},
{0.2781684012366197,0.03337429398181161,0.3293626146670168},
{0.24412236038113777,0.06536201859353435,0.3360044100124046},
{0.20815887221034413,0.09231222375574027,0.3419325470673942},
{0.25344881480916626,0.004294756008612794,0.6816210870308032},
{0.2745849751063648,-0.037081242370812416,0.716656703003477},
{0.2826925058312169,-0.024256814534413633,0.6760305697216792},
{0.2588810000995396,0.017589988759590874,0.6315846764875206},
{0.29001303328639644,-0.014312399550849323,0.6265308581537207},
{0.31124000165317256,-0.059452043152460346,0.6749874411275568},
{0.2983766893356983,-0.0678572613566842,0.7185566872284854},
{0.2672493129729223,-0.04902844097097111,0.7435277421563076},
{0.24835308505863818,-0.013863947391858361,0.7239120349215239},
{0.22301297682240445,0.027469441047226605,0.6896808853088261},
{0.22703763703432486,0.044001166534432264,0.6381612762957759},
{0.23111934334123638,0.053845692641461204,0.5817112547870698},
{0.2640582242714835,0.02545420042621582,0.575643413009653},
{0.29623222184644243,-0.00826004171350171,0.5705383696109632},
{0.32102748166521045,-0.05233548459202438,0.6238834536637273},
{0.33746024964069693,-0.10001565857097204,0.6764322207986571},
{0.32002626448781635,-0.10490800152976672,0.7243823741536951},
{0.27960735987761864,-0.0729694064120975,0.7547553450153647},
{0.246825646760102,-0.038245215549834136,0.7580791532031091},
{0.21959952477110253,0.004513626740415244,0.7351990122876124},
{0.19089253272437598,0.04653215042240306,0.6981283641915842},
{0.19389036322645728,0.0655541125868716,0.6453781894151552},
{0.19691147784894314,0.07732190703931349,0.5880957606019876},
{0.19962989890617022,0.0813232831308294,0.5272333982766259},
{0.23470276947149124,0.05673758039570199,0.5214030545273354},
{0.26838907066672335,0.027325079500718597,0.5156425631392584},
{0.30103457167987363,-0.007110970371538891,0.5104362338168088},
{0.32814194465481006,-0.04770636861440275,0.5670434231382454},
{0.3495994258135908,-0.09524590650610713,0.6228601165719488},
{0.35972219715945375,-0.14467285519780151,0.6783054282852002},
{0.3398282446858361,-0.14694934364975096,0.7289053145422721},
{0.31259979428479623,-0.14768419048971745,0.7735398091517072},
{0.29563964098214746,-0.10791048885592892,0.7661901765460221},
{0.2626413855448688,-0.10701125612590655,0.8013328994725565},
{0.25209950003172465,-0.07020662910549977,0.783745239125006},
{0.21801154775951465,-0.025081654499743578,0.7740124767959188},
{0.1882439640283624,0.02077059960684762,0.7453928002007092},
{0.15662412851903101,0.06199513478304147,0.7061287879625755},
{0.15884659781164195,0.08287749816783078,0.6523529476823279},
{0.16093518341192695,0.09629264413889212,0.5941496319071616},
{0.16282352557673313,0.10127428169943811,0.5326516130947565},
{0.16478754113285396,0.10262592488892021,0.46971463564135235},
{0.2022633329239209,0.08211494322458293,0.464668966749694},
{0.23795439688598174,0.05684352314354254,0.45910289776699464},
{0.2720586480424749,0.026840769796304686,0.4533901388257469},
{0.30477749403489945,-0.0078665400786654,0.4478974148223218},
{0.33298504169894916,-0.04676324531741786,0.5062672120583803},
{0.3574950710427619,-0.09176481408503012,0.5646789207111669},
{0.373405110515167,-0.14180983975286235,0.6226785004327937},
{0.32552480952134255,-0.19054525006854264,0.778273470829945},
{0.2881607815082173,-0.18637564620710412,0.8170042767108154},
{0.27691455135283655,-0.14592193183690172,0.8112647410311025},
{0.24057269622546945,-0.14586744699515516,0.8418810309509992},
{0.22053671061738428,-0.10568755388090988,0.8355174808444452},
{0.21946214846071593,-0.06153294499301185,0.8054157699854883},
{0.18530317962127216,-0.04891202036894853,0.8196575022309099},
{0.18627179903009997,-0.011215262275242752,0.786220341124006},
{0.15433879210132784,0.03460951656927114,0.7543432160842047},
{0.11975023124042077,0.07436948057202099,0.7128450924932579},
{0.12131259571956374,0.09660348714629238,0.6582030829339622},
{0.12268868723547058,0.11116537604727607,0.5992278985673863},
{0.12393671608915256,0.11678383430088557,0.5371745534833335},
{0.12532794228332234,0.11834736298604874,0.47387085113355837},
{0.12712780479059135,0.1207421347696531,0.4111457591758354},
{0.16710780373116388,0.10515458036485051,0.40719211553114865},
{0.20503414325205818,0.08425941071383874,0.4022756735077353},
{0.24103954283957998,0.058330214231370824,0.3966816635805506},
{0.27525672198003504,0.02764407195026045,0.3906941520185296},
{0.3078184001597291,-0.007524263508719026,0.3845972050906073},
{0.33630768568067343,-0.04724674007761762,0.4429972716831916},
{0.3621996275704941,-0.09073879931940516,0.502902656659928},
{0.382001607768514,-0.13931552835452868,0.5629663736554148},
{0.33885729686496785,-0.04689759469215191,0.3786783816837796},
{0.36494016854210554,-0.09065090176487813,0.4386792315541743},
{0.3866351477290125,-0.13814526846299777,0.5001097264174063},
{0.1700602301984564,0.11366376216668055,0.34694096136640534},
{0.3986462612396815,-0.12927635864297818,0.23379759929076574},
{0.3933107050489869,-0.13386455277898887,0.3009513309494275},
{0.37362747386503015,-0.08084619150374088,0.24284115165587938},
{0.3780479641238273,-0.07160425843278079,0.17945828329672878},
{0.35008024289994405,-0.007478859473930225,0.13458046962906656},
{0.36942701854405563,-0.08722150009109912,0.3074988256071771},
{0.39063419540848787,-0.13629117723930662,0.3682738724810221},
{0.3669402744848534,-0.08998404455649282,0.3731612093539297},
{0.3413824597228375,-0.043456550958170664,0.314754157525224},
{0.38896006715140324,-0.1374276053038898,0.4349351449931283},
{0.307606514664048,0.19309753892668358,-0.486932078474471},
{0.2713740949025822,0.11922517432529896,-0.5324455486291765},
{0.31902853992848285,0.15120591370090034,-0.5720483448191959},
{0.34342331287629324,0.23055703183346732,-0.5230713617543188},
{0.35698980562998395,0.18651744650036764,-0.6149470082524745},
{0.32574135184110453,0.11489083531199848,-0.6484936047252794},
{0.2779262463844127,0.08562968119964447,-0.6068080439650761},
{0.2243029170928146,0.05983786102756316,-0.5805272572645},
{0.2651188159559092,0.15985829284321812,-0.4539035536806664},
{0.2894553786027083,0.2359461415010923,-0.40037918190078753},
{0.321576986906757,0.27519851167902376,-0.4270662765024224},
{0.3432964144200887,0.3202404783955378,-0.458485868576275},
{0.36630461799781017,0.2738305696052585,-0.5618091528713104},
{0.3802110589094067,0.22730540441897681,-0.6584044905754612},
{0.36289465856456893,0.14828841341421464,-0.6944063975449224},
{0.32382041190773203,0.08451320762624795,-0.7143026784305805},
{0.27970166056525697,0.05900079689902085,-0.6725554147513052},
{0.2291227300165492,0.038236018322274364,-0.6437704209012236},
{0.17569149471828832,0.020828809907858903,-0.6360249582486616},
{0.16972028204055045,0.03684362792208436,-0.5808322792417991},
{0.25401811155305665,0.2020642536944623,-0.3767341576300025},
{0.26255290588733166,0.2751321519358709,-0.319627873187695},
{0.2908291417065747,0.3152355567145873,-0.3352154275924976},
{0.31110146113676573,0.3597198687474133,-0.35681692103598034},
{0.3167164267723145,0.4076106475954198,-0.3879955224636462},
{0.34752597489156883,0.3714876631998552,-0.49633304208779394},
{0.36998700163978415,0.3245096218717057,-0.6026343653825668},
{0.38365361611121424,0.27571309073996353,-0.6996895644647068},
{0.3851030526063954,0.18748257329113474,-0.7398907625491223},
{0.3578757664113757,0.11616680511016592,-0.7609314579526624},
{0.30934700266428544,0.06043509871593899,-0.7675115503789782},
{0.27162207078489026,0.03926517644415392,-0.7252555286688642},
{0.22754523085914333,0.023360958001849924,-0.6955170500882176},
{0.17917247071876335,0.009139017258772142,-0.6865817688829852},
{0.11944288085108118,0.00787934634488788,-0.6401730242987259},
{0.1140910257761034,0.019147696414652936,-0.5937701007445679},
{0.23292619108462673,0.24038176643815246,-0.3064902739318555},
{0.22593513393317108,0.3073492251335781,-0.2525735647231605},
{0.2497571175190304,0.3484980869184573,-0.2581678074915493},
{0.267624187311435,0.3930441018703552,-0.27109119283966726},
{0.2739784237698272,0.4390220902271308,-0.296647843395663},
{0.27767477788404393,0.47960165526811965,-0.32694874990468065},
{0.31574897156950693,0.4536165768966808,-0.416811949876274},
{0.3413393841000891,0.4350090720754127,-0.543334367536348},
{0.3593415017908399,0.37828429794593316,-0.6500350134960583},
{0.37044802722379355,0.32845395186823056,-0.7411027010161771},
{0.38808225581215305,0.23413463693362105,-0.7802910398629962},
{0.37801885897332166,0.15443076437692566,-0.8065299151468442},
{0.3386686954896913,0.09045298674143976,-0.8139994609726127},
{0.2783733014961794,0.04253892377302871,-0.8067220091401814},
{0.2485125812834091,0.0244355201585183,-0.7627336488719717},
{0.2217137229038325,0.01679367184175647,-0.7308204334455434},
{0.1867968559452218,0.005220299794692271,-0.7347589424119672},
{0.13342150253593177,-0.004416997640736507,-0.7399070614334055},
{0.12519987962109752,-0.00162988842831605,-0.6891011107107536},
{0.060416122157809296,0.0004912949405352737,-0.6470639597324421},
{0.05732888063337464,0.009250781036713814,-0.605388876826421},
{0.20171382768237434,0.27156502468989924,-0.24900434190635243},
{0.35599906630677175,0.12821633741950245,-0.8585862231352184},
{0.3804043171087642,0.19977309624665804,-0.8451885402544606},
{0.35775468898527224,0.1726238118549935,-0.8951353069341857},
{0.31608309869731166,0.10890914478007857,-0.8963204686627755},
{0.30200901211880254,0.07144615925523413,-0.8530923349257732},
{0.2446334468240169,0.05944319518670663,-0.8776896797211028},
{0.22695497840688886,0.030705933783454202,-0.8305346790778789},
{0.20520062471295047,0.012521035747527956,-0.7828173669268861},
{0.14616723004536328,0.004479864765828696,-0.7919412495073953},
{0.0758934262524965,0.0012678203560258507,-0.7965363706692263},
{0.06937724873669095,-0.008623273991812137,-0.7440108876547012},
{0.06432529313252333,-0.007175001702651307,-0.6937288296411509},
{0.0,-0.001812668773491498,-0.6511945626922031},
{0.0,0.006251786328612284,-0.6108699587696438},
{0.37371944614062796,0.2843270510836139,-0.816646865462606},
{0.3662510645208798,0.24713648976750224,-0.8770400527618168},
{0.3451358599320453,0.2181198189193956,-0.9226513162222213},
{0.3172647678078408,0.1526867837586275,-0.9308787601671568},
{0.2553115444415275,0.09657787461384743,-0.9199957622900864},
{0.17889771809799007,0.08971138750655593,-0.9328043569246102},
{0.1717203879832983,0.05288173005671429,-0.8910570932453349},
{0.16005970048471718,0.023948882042063937,-0.8430440727652047},
{0.08265653186519192,0.021279357637686267,-0.848342374363252},
{0.0,0.020967350424265778,-0.8491887521399561},
{0.0,0.0008684976910884065,-0.7977029051014927},
{0.0,-0.009368365844756619,-0.7458014365138085},
{0.0,-0.008640737082115523,-0.6965694923305018},
{-0.06432529313252333,-0.007175001702651307,-0.6937288296411509},
{-0.060416122157809296,0.0004912949405352737,-0.6470639597324421},
{-0.05732888063337464,0.009250781036713814,-0.605388876826421},
{-0.054742364118239094,0.013984442714951717,-0.5700785082329739},
{-0.1140910257761034,0.019147696414652936,-0.5937701007445679},
{-0.10873206904440225,0.025470499310498995,-0.5533174341597838},
{-0.16972028204055045,0.03684362792208436,-0.5808322792417991},
{-0.16121692126882156,0.04675917059634708,-0.5298470407920326},
{-0.2243029170928146,0.05983786102756316,-0.5805272572645},
{-0.21482977270623765,0.08475885509651561,-0.49900140228615136},
{-0.2713740949025822,0.11922517432529896,-0.5324455486291765},
{-0.2651188159559092,0.15985829284321812,-0.4539035536806664},
{-0.22692820166842367,0.13146912904001318,-0.4226760556001511},
{-0.25401811155305665,0.2020642536944623,-0.3767341576300025},
{-0.22353104850140493,0.17369488139360117,-0.3539797509646902},
{-0.23292619108462673,0.24038176643815246,-0.3064902739318555},
{-0.20860243470405013,0.21196233327842162,-0.292238762355864},
{-0.20171382768237434,0.27156502468989924,-0.24900434190635243},
{-0.1826522825132181,0.24311182955558183,-0.24215589999237444},
{0.3437260064415519,0.3822449268267411,-0.7849455355318589},
{0.3439052941686667,0.3341410982770333,-0.8500013679420737},
{0.33677918911886484,0.2914647981936179,-0.902217172155219},
{0.3193475323780247,0.25914643907215107,-0.9401388548520324},
{0.30710124925127,0.19747146094467172,-0.9549545406654253},
{0.256067114148654,0.13995735513347912,-0.9531709770424395},
{0.17933895217965562,0.13287432570642568,-0.9651110739858747},
{0.09225808817579977,0.1298741667923039,-0.9697958390112631},
{0.09205586559008655,0.08679970824997135,-0.9379361770617652},
{0.08844973744243728,0.05019590676805347,-0.8964636660032633},
{0.0,0.04982219663556103,-0.8971773242936617},
{-0.08265653186519192,0.021279357637686267,-0.848342374363252},
{-0.0758934262524965,0.0012678203560258507,-0.7965363706692263},
{-0.06937724873669095,-0.008623273991812137,-0.7440108876547012},
{0.280047429753264,0.2901539022148437,-0.9523269276777757},
{0.2921912627502388,0.3262466172538825,-0.9212915235905976},
{0.2980088002333069,0.37384750880285283,-0.8774242407484913},
{0.23269334988058157,0.3449740352952339,-0.9348347322238838},
{0.2268979323118978,0.30559243824905746,-0.9639433753475883},
{0.2653935685766825,0.26612003313330335,-0.9680530225989852},
{0.2871455938585804,0.23795905371006268,-0.9667363055901099},
{0.24887464935569928,0.18538700245472842,-0.9754282677371153},
{0.17506282346736646,0.17931333964721066,-0.9865487636423117},
{0.09027544532335531,0.17669736871976338,-0.990794622998075},
{0.0,0.1293956781179911,-0.9703255527504658},
{0.0,0.0863328616358608,-0.9385834756090108},
{-0.08844973744243728,0.05019590676805347,-0.8964636660032633},
{-0.16005970048471718,0.023948882042063937,-0.8430440727652047},
{-0.14616723004536328,0.004479864765828696,-0.7919412495073953},
{-0.13342150253593177,-0.004416997640736507,-0.7399070614334055},
{-0.12519987962109752,-0.00162988842831605,-0.6891011107107536},
{-0.11944288085108118,0.00787934634488788,-0.6401730242987259},
{-0.17569149471828832,0.020828809907858903,-0.6360249582486616},
{-0.2291227300165492,0.038236018322274364,-0.6437704209012236},
{-0.2779262463844127,0.08562968119964447,-0.6068080439650761},
{-0.31902853992848285,0.15120591370090034,-0.5720483448191959},
{-0.307606514664048,0.19309753892668358,-0.486932078474471},
{-0.2894553786027083,0.2359461415010923,-0.40037918190078753},
{-0.26255290588733166,0.2751321519358709,-0.319627873187695},
{-0.22593513393317108,0.3073492251335781,-0.2525735647231605},
{0.3359002135735944,-0.9469162801987766,-0.25965938824466256},
{0.3935551883132343,-0.9180067163045308,-0.18522424645310082},
{0.335655730309347,-0.9639171807121332,-0.18725706658501698},
{0.27203652812809065,-0.9625818364069342,-0.26720123126428696},
{0.26739600293147076,-0.9805792972736043,-0.19017957295758972},
{0.2647893456521853,-0.9699838582835296,-0.11253250317682716},
{0.32732932885269245,-0.9536418983776207,-0.11522112055993651},
{0.3807465936787106,-0.9109877182085897,-0.11963730325645885},
{0.4130439970918134,-0.8420492587209218,-0.11597319764900234},
{0.42870256806384976,-0.84219478447345,-0.18559632669716497},
{0.3900637344585773,-0.9033086152991806,-0.2517473277106063},
{0.33635308971546224,-0.9019220459290918,-0.31811184410815707},
{0.27726846998298516,-0.9148482253716583,-0.3282258839088683},
{0.2182222690491755,-0.9059024663122437,-0.31657951614433594},
{0.20912982003121236,-0.950765145301643,-0.2620304102254543},
{0.20117014347092893,-0.9686485139783307,-0.19247655143549514},
{0.20512262290959532,-0.9599833285697903,-0.1213790718833186},
{0.21277727749257966,-0.9264087911525001,-0.06319135646882341},
{0.26563106660480856,-0.9323578839158536,-0.04963999839339566},
{0.32149782089738166,-0.9172872369840313,-0.05691279340174593},
{0.36177003554903087,-0.8924686930448588,-0.07602905625385277},
{0.37901658353265516,-0.8427151845644909,-0.05873826844145992},
{0.394806709784977,-0.7624932403287951,-0.04565259277412248},
{0.43021720009616343,-0.7530666641830271,-0.10934735192609152},
{0.4461749720153978,-0.745980142137913,-0.18666250657048772},
{0.4238722772859331,-0.8312954877120966,-0.2558072633649396},
{0.37637383586674267,-0.8781943630308707,-0.29693353955302637},
{0.34530466980497804,-0.8282138343765589,-0.3482984255859885},
{0.2816482130310744,-0.836237542267955,-0.3578821695444869},
{0.21766810698354802,-0.8336250639585683,-0.3426636684480959},
{0.17852284375947738,-0.8858944216486437,-0.2944211829613792},
{0.1589746604738668,-0.9122031492937054,-0.253854773448419},
{0.14934434827455936,-0.9291982287769608,-0.19264221795217323},
{0.15906663274946461,-0.925022221782411,-0.12955529076336406},
{0.17836800435878736,-0.9080620684797623,-0.08550918587655106},
{0.21592994739535099,-0.869562939596917,-0.03236550946528597},
{0.2713345118978945,-0.8692625744436986,-0.016883897808323927},
{0.3287380181371656,-0.8560500003201568,-0.025692280557351982},
{0.34202510144600207,-0.7776884573047816,-0.010457480576677784},
{0.35433425169784893,-0.6899632052687307,-0.00010419643881016353},
{0.4057968146159081,-0.6664904834889392,-0.036473992510662655},
{0.4382583710778627,-0.6502800788633158,-0.1048781978556489},
{0.45105532365218415,-0.6388603820109214,-0.18671221816755135},
{0.4405995893845367,-0.7378027590518474,-0.26272125007785624},
{0.3966938877437629,-0.8223136382660547,-0.3141824159486911},
{0.3544343734155884,-0.7331214866445196,-0.35816972843148265},
{0.28408955305548783,-0.7370506819627815,-0.36594546044057047},
{0.21270160410126498,-0.7407575139311803,-0.3492414324623714},
{0.1543376278953076,-0.7486811001048369,-0.31058350587836725},
{0.16452093795422226,-0.8331617099625185,-0.3062824631572453},
{0.13336212802890027,-0.8476258055578032,-0.2523820528328334},
{0.12428015686511917,-0.8633041680321833,-0.18917043917925805},
{0.13736233991439592,-0.8664812862613793,-0.12485585674212078},
{0.16908578975952743,-0.8657140744940506,-0.06929994545694794},
{0.16706239969637507,-0.7985789701317124,-0.05603498206249571},
{0.21949474622928225,-0.7984415938213257,-0.01759289927464141},
{0.28065863791388257,-0.7919162190779606,-0.0017678468417127778},
{0.29236705785929296,-0.7115347786174937,0.008205906133561224},
{0.44352058228928315,-0.6297597835508167,-0.26337157556075436},
{0.4108867233363351,-0.7322716162497549,-0.3242985513202387},
{0.3554216201207398,-0.6239771722483555,-0.35567716334217936},
{0.2835051216333345,-0.6275920319411564,-0.3621932244373829},
{0.20855470225722084,-0.634118570890542,-0.3452726541394218},
{0.14790073280947943,-0.6479155764362373,-0.3069126478759934},
{0.11887358410719079,-0.6733383432999072,-0.24910865476576463},
{0.12307054681010461,-0.7652628864509122,-0.2525031302589369},
{0.11641489741307602,-0.7828132922058154,-0.1842798425294937},
{0.1318905716193349,-0.7936439008119757,-0.11519376171846121},
{0.1345344834912676,-0.7157946084454998,-0.10848257969426783},
{0.17243637468573714,-0.7229649533240702,-0.046703870810386315},
{0.2283904444298272,-0.722040573744011,-0.00756675702845726},
{0.2873621361783424,-0.9550482592500535,0.7630049088746843},
{0.23349315941647666,-0.9265030918401383,0.8252096007413664},
{0.23155592059882102,-0.9683469846190922,0.7705699195941113},
{0.28947051328097123,-0.9697254045470396,0.6995126051496325},
{0.23079685827363383,-0.9840043913851084,0.702484823119269},
{0.1730720311727804,-0.9730177791722379,0.7050204638313207},
{0.1767602358448556,-0.9573999554109094,0.7673287700338027},
{0.1813134455899585,-0.9179007735566902,0.8173605237530045},
{0.17880341741035177,-0.8541686433914719,0.8436657587800053},
{0.23684141593064595,-0.8575541544982883,0.8533927000789914},
{0.2865111015775574,-0.9158063669263039,0.8143184534221545},
{0.3231358587678393,-0.895379208095423,0.7944314861846583},
{0.33554396653140534,-0.9172383403311817,0.7547937638140321},
{0.3397362724102383,-0.9297651971088109,0.6966172247773311},
{0.33015369265776007,-0.9231525069139285,0.6388458294356687},
{0.2845715343478613,-0.9603698449685053,0.6360203014245807},
{0.23098778806095085,-0.9743973633062053,0.6339631493868418},
{0.17817823877749053,-0.9651104918828646,0.6418913923845792},
{0.13488374529733532,-0.9335931065033131,0.6497078716043749},
{0.12563994949674284,-0.9375525711781009,0.7066142618730097},
{0.13159369908417734,-0.922752020042971,0.7624612246632388},
{0.14629994953166903,-0.899700740842501,0.7997763560235147},
{0.13132826011156587,-0.852803029729747,0.8137107378795968},
{0.11960237707585211,-0.7765906110277089,0.822195471355002},
{0.17409886088261953,-0.7717056025668415,0.8530911707197529},
{0.2406018013759751,-0.7707823871928025,0.8623955052333971},
{0.29518560063425947,-0.8514653570125078,0.8412698227903807},
{0.34250591853235535,-0.8468492801423126,0.8084520192862369},
{0.3674688240180359,-0.854648296271805,0.7560941819386243},
{0.37223391925881993,-0.8637069833151814,0.6943120968572841},
{0.35895498539212495,-0.862868754980619,0.6332238785639985},
{0.31456497404693734,-0.9064915545584777,0.6000125734250185},
{0.280433946151979,-0.9280037534002092,0.5839453661398829},
{0.23188189828448422,-0.9408146764467734,0.5780218859089743},
{0.18391661025118328,-0.9350250799081908,0.5901831819962525},
{0.1510580595363317,-0.9183769338189627,0.610262243227086},
{0.10983992749324907,-0.8809314113844214,0.6473130998207706},
{0.09784499644626113,-0.8783946064663496,0.7067574592134974},
{0.10467504390511953,-0.8649491911387625,0.7651493763639402},
{0.09019325237832737,-0.7900348621492757,0.7698713959819758},
{0.0823366080508339,-0.7040559191435635,0.7711077827754557},
{0.11283414895666768,-0.6836322529307431,0.8236169669056976},
{0.1720673213773256,-0.6760160171464263,0.8524881120012759},
{0.2437754269871105,-0.675473497141001,0.8594966322430351},
{0.3060325081247028,-0.7692223511257,0.8499431576410625},
{0.35840664435659864,-0.769552985635444,0.8156130505166456},
{0.38573754488741835,-0.7743017819919449,0.7592841064340429},
{0.39066446476501376,-0.780486044371384,0.6918463085064459},
{0.375828987449277,-0.7851207485379027,0.6241919682590872},
{0.34296577991034455,-0.7916740642257536,0.5689562136294765},
{0.3292723887004493,-0.8626696757511603,0.5832247226133631},
{0.28482649546629074,-0.8736493027279093,0.5547074961479335},
{0.233237034092027,-0.8845485994892629,0.5476768559917902},
{0.18212373298003562,-0.8841143506437187,0.5621374589690142},
{0.13861386138613863,-0.8802678139528929,0.596034481453907},
{0.0969381963771073,-0.81444942659943,0.6403616256740027},
{0.08344667849111916,-0.8050007305392778,0.705976276973926},
{0.07620508420411094,-0.7268242962811186,0.7047922794513563},
{0.06910913209023295,-0.6595308599000297,0.7053767108735096},
{0.07389343673035069,-0.62889943530187,0.7705338292074843},
{0.3116975346191213,-0.6762709782648557,0.8464202702238594},
{0.36502515558158205,-0.6787414234397747,0.8124405891115304},
{0.39294747277067643,-0.6832212882056036,0.7567403162798496},
{0.3987277556610973,-0.6890353330706108,0.6884701110477913},
{0.38562810952151716,-0.695512975367147,0.6167852895584109},
{0.35381385160680806,-0.7060874586488576,0.5575504872493247},
{0.30345146337786233,-0.7241931906754084,0.5266315037641692},
{0.2938118375303931,-0.8036095043451079,0.5387788293792046},
{0.23634197154796907,-0.8149442141580259,0.5321370340338167},
{0.17853099320161894,-0.8196883536904458,0.5475080461188573},
{0.1291418812055819,-0.8191039222682925,0.5839116041652963},
{0.12420215506176405,-0.7486624728085133,0.5737539066388266},
{0.09007007938138749,-0.7414711722215787,0.6345045051862469},
{0.08144319635091266,-0.6783258018905542,0.63477925780702},
{0.24248897933476105,-0.7413442737653742,0.5206067376095009},
{0.17887443397758557,-0.7490606312674303,0.5360510946738157},
{0.4126470028389164,-0.6243427329387062,-0.3234839563678868},
{0.11618147410602075,-0.6995702333476338,-0.18018917183622646},
{0.3392391564396019,0.43084470714106515,-0.708503768243836},
{0.3161704141488286,0.5276367956626341,-0.7059320371451574},
{0.3322096804894788,0.4801441752735448,-0.6421719660354537},
{0.32897784457733215,0.4976421917575378,-0.5235742987550563},
{0.32440018650580443,0.5303482314837399,-0.6074425362460992},
{0.3108430074002756,0.5745356709814082,-0.6731794291781462},
{0.3009635551126399,0.5748453497827882,-0.7395554712152972},
{0.29479675582350406,0.5469882281308266,-0.7739973421176559},
{0.3157140453889001,0.4858557700087723,-0.7568788567962564},
{0.32371330495387124,0.573178206761825,-0.5939237759392377},
{0.3293468978857437,0.5372333458873549,-0.5207825327185549},
{0.3235037478702306,0.5220986676244201,-0.4435747178692236},
{0.3162740284846287,0.4924521613193715,-0.4313284347424689},
{0.30642368134749864,0.5261559256049069,-0.380970703337604},
{0.28756820064392236,0.5079535644786773,-0.35410432100885436},
{0.30050020111659004,0.625201916981633,-0.379665628388931},
{0.24802827157899518,0.5829715078039639,-0.34930197117542316},
{0.3116335032880089,0.584260283868354,-0.37207384093103885},
{0.38005738371473696,0.6250365997267608,-0.3824993058421604},
{0.3799328136705728,0.5866550556519584,-0.38604082055568717},
{0.3252337580162861,0.5527382416647214,-0.38077395252018587},
{0.27834070372761305,0.5477892018727419,-0.3516385326580162},
{0.22425634885200554,0.6276758547746126,-0.3676789632046866},
{0.29380252388223127,0.6679469052202417,-0.3962672062373501},
{0.38055566389139356,0.6663368082942692,-0.3903029787957336},
{0.4479771629347073,0.6280623711733276,-0.38855317714733434},
{0.442771997818278,0.5939068949519444,-0.39869224737748044},
{0.4282438708918808,0.5693386553071205,-0.4214256983344286},
{0.3776055658361415,0.5579841539918587,-0.4037064827065927},
{0.33700388088076844,0.5362833537748507,-0.4103995031168705},
{0.374147873956071,0.5451895298295778,-0.43742538167039113},
{0.4126877500496243,0.5597292988161772,-0.457078343497822},
{0.37063546439304995,0.5544356540422106,-0.489128935234637},
{0.3426467874608027,0.5405385267787759,-0.4655851968876117},
{0.4675253462203179,0.587091632909543,-0.4445002616553031},
{0.4923171134210252,0.6096271688430528,-0.4176082667941084},
{0.5010148965981318,0.6401340233970485,-0.4009845690313049},
{0.5207365465807561,0.6374319012241045,-0.45037135261530153},
{0.48582666485826664,0.6115364667162231,-0.48349650650878484},
{0.44163689694855784,0.5770014593322463,-0.46931531297641493},
{0.4044020958036776,0.5704539646744967,-0.5059761605533238},
{0.36719057877920197,0.5802868487213235,-0.5453880269560262},
{0.34278765638924996,0.5627981458854922,-0.5309763206316517},
{0.4525059243533855,0.665896738418624,-0.38993741810538274},
{0.3840075347413629,0.7037637034324868,-0.4066728796461279},
{0.46500716859856955,0.7015074721652893,-0.4017704080949573},
{0.4942916068313281,0.6659351572172916,-0.39687841439796867},
{0.3639377871586912,0.6173051075464417,-0.5927781972153358},
{0.3328232170621378,0.6445254085053399,-0.6276636306114003},
{0.36392381668644846,0.6587985743133078,-0.6184617462275359},
{0.397890691532555,0.6294582541915782,-0.5920249559202496},
{0.40174304925348203,0.6669689721632521,-0.6091143360911434},
{0.37020121554750574,0.698076557023684,-0.6096044668256584},
{0.33147972331479725,0.6866312476388448,-0.6216377002507119},
{0.3006399058390171,0.6812013907605118,-0.6367374523330397},
{0.30754714015701645,0.6269424049818705,-0.6518884294802577},
{0.33805283050499185,0.6003542678919547,-0.5912228179723141},
{0.400448452158991,0.5956508755702425,-0.555247687741318},
{0.44129578458463165,0.61404765910185,-0.5517643833288026},
{0.43760292308847565,0.6450562864505629,-0.5831117946294012},
{0.4328110511092264,0.6699283838666658,-0.5951904320892433},
{0.4170244174749652,0.7032782295220528,-0.5993221992550245},
{0.3725808526528471,0.7348596462327166,-0.5760019884638825},
{0.3234839563678868,0.7207215283230952,-0.5932427154174057},
{0.29101192205175014,0.7160705252722933,-0.6080700432910008},
{0.44308633344373893,0.5892640413432843,-0.5071054403929428},
{0.4884682483181589,0.6406334677797253,-0.5261483582657754},
{0.48076818970038576,0.6723429471526141,-0.5601850854730955},
{0.458397971021748,0.6965840449057545,-0.5848336553333151},
{0.436996371751938,0.7331203224384994,-0.5718644002680002},
{0.40044612374695054,0.7546220434260488,-0.5352629271981229},
{0.32480765861288347,0.7483795707455984,-0.5463426758926113},
{0.2982975233263229,0.7408483220007579,-0.5625786930506796},
{0.2734393963824626,0.7385350446385694,-0.5778321203276774},
{0.2699817045023922,0.7518349342136282,-0.5349707114870461},
{0.25542563663150963,0.7522179579942826,-0.5512812378304089},
{0.48637384168777276,0.7251082566073058,-0.5576075333443157},
{0.517136821566218,0.7019731545733795,-0.5277363352773633},
{0.5287649112962328,0.6704895311684147,-0.4895561988440599},
{0.5364568204718644,0.7246018269885076,-0.4902570508682358},
{0.5034143252058171,0.7427913818485147,-0.5219700228591853},
{0.4549228160513741,0.7512318754951512,-0.5359602866042381},
{0.5489836772494935,0.6986959146264441,-0.45314332714945904},
{0.5269068384879525,0.7404501635418407,-0.46202854749582195},
{0.5358688964316504,0.720416506345796,-0.4277438444061938},
{0.5359271067326616,0.6671098410916995,-0.4229508082209244},
{0.5208622808309404,0.6914929719793074,-0.4053712973155156},
{0.4761637548903929,0.7308140303124323,-0.42418952342644456},
{0.4766597066550091,0.7497405275832423,-0.45733097620421104},
{0.5031640209114686,0.7483690928914162,-0.4930441600806562},
{0.3824603049404829,0.7375780672899437,-0.43217714093121345},
{0.41051883423394375,0.7548304363036693,-0.4640647438251968},
{0.46880830125460665,0.7569807248230261,-0.49623874140015567},
{0.05383707751691155,0.246500833280459,0.03642975268189413},
{0.0,0.25107616293994617,-0.01150293758284052},
{0.0,0.24636927800017344,0.038712760687556816},
{0.05241616406922602,0.23853649989609466,0.08902625226365311},
{0.0,0.23794159061975925,0.09057581047657355},
{0.05063038845480174,0.2251795642260446,0.14190332549628648},
{0.0,0.2244158450767765,0.14281722722216375},
{0.04877266490832751,0.20487697543932773,0.19359872961839075},
{0.0,0.20441245723725762,0.19417035477432162},
{0.04696488580012096,0.1817942626763117,0.24547807829169066},
{0.0,0.1819199969264961,0.24592513340345734},
{0.045328943500499735,0.1600922982532835,0.2989058209718909},
{0.0,0.16092703396978536,0.29937033917396094},
{0.04398684680038349,0.14393544710459052,0.35524873552673636},
{0.0,0.1454221381924188,0.35579824076828287},
{0.04306025522888582,0.1374869099585601,0.4158712714119316},
{0.0,0.1393938794196899,0.4164976142508131},
{0.04243728858746301,0.13594317277574075,0.47899335762255163},
{0.0,0.13807716241081455,0.4797000306768287},
{0.04200560099516331,0.1344995573106608,0.5428384157717319},
{0.0,0.13671154874908975,0.5436324042775258},
{0.041653079412238954,0.12835138531784865,0.6056240464425067},
{0.0,0.13053310739975169,0.6065274703142018},
{0.04126749437834019,0.11269630696387295,0.6655725070419912},
{0.0,0.1147779073280366,0.6666121430180527},
{0.04078562950656874,0.089072238401452,0.7213158554964204},
{0.0,0.09100831301308741,0.7225126592852125},
{0.0401443848306284,0.0590217526073849,0.7714873139380491},
{0.0,0.060784360522006704,0.772852927599774},
{0.03928066038422292,0.024085094146430355,0.8147189402931122},
{0.0,0.02566725012791715,0.8162545280337901},
{0.038131239780454025,-0.0141983073608672,0.8496451208998848},
{0.0,-0.012781585054854475,0.8513413690713537},
{0.0365710872927495,-0.05333577040460235,0.8783975169814001},
{0.0,-0.05210764947386619,0.8802462761415186},
{0.034474934353333035,-0.09083472989547177,0.9031112823787524},
{0.0,-0.08985574905306393,0.9050974178492575},
{0.03171774523563239,-0.1242028885115568,0.9259192425209951},
{0.0,-0.12357086434729662,0.9280252912115834},
{0.028174484213075314,-0.15094792564681833,0.9489495660131009},
{0.0,-0.1507978594908112,0.9511615574515299},
{0.02433737759101326,-0.17242822524359555,0.9699285584975689},
{0.0,-0.17281800141916714,0.9722104022972116},
{0.020698302412991608,-0.19000261364251542,0.9865534204663926},
{0.0,-0.19091244064732182,0.9888934745670465},
{0.01774971782556585,-0.20502960284857932,0.9965306660597273},
{0.0,-0.20636261874173778,0.9989172884011902},
{0.01598350087228136,-0.21886770486678864,0.9975784514779306},
{0.0,-0.2204495115864694,1.0},
{0.015399185870730057,-0.22977072708740684,0.9921183252430718},
{0.0,-0.23142913856321842,0.9945398737651414},
{0.0,-0.2375576354742888,0.9849701002788855},
{0.01599619071790182,-0.23599259332129932,0.9825601938170182},
{0.0,-0.2370907888601783,0.9737122280633027},
{0.017773584048980474,-0.23578711095872948,0.9713372477820421},
{0.0,-0.2282847345231907,0.9631878056404618},
{0.020730900181557932,-0.22740797096935866,0.9608593936000103},
{0.0,-0.21738310934979677,0.9535598218531948},
{0.02438732202928095,-0.2170134739383751,0.9512896201137547},
{0.0,-0.21062989948827326,0.9450145496647379},
{0.02826191608519427,-0.2107616876097628,0.9428316633768146},
{0.0,-0.2142689746662949,0.937723127360064},
{0.03187409810414871,-0.21481091256871,0.9356438554079407},
{0.0,-0.23454397177033243,0.9318683352843486},
{0.034742818158586986,-0.2353193329798028,0.9299066481402684},
{0.0,-0.2672609550331246,0.9261194859564739},
{0.036546522545722736,-0.26813760216635457,0.9243172950371644},
{0.0,-0.30822820067884854,0.9191493845133824},
{0.03696319188036153,-0.30911532566626054,0.9175695569439359},
{0.0,-0.3532503758930188,0.9096331645040571},
{0.035671156039115,-0.3541037389058443,0.90835952311793},
{0.03234839563678868,-0.39895361162902104,0.8953832828164938},
{0.0,-0.39813517479680244,0.8962424668594204},
{0.027995429327164596,-0.44270796648716554,0.87690151224541},
{0.0,-0.441895350685048,0.877381165125743},
{0.02361207724041262,-0.4844121545436924,0.8511737234044412},
{0.0,-0.48354947788270514,0.8514531328492954},
{0.0,-0.5221091454786022,0.8168599151643073},
{0.020198858030314765,-0.5231103626559964,0.81646059249937},
{0.0,-0.5565905993856485,0.7720077140290901},
{0.018755708247642923,-0.5578456134754518,0.7710227957359792},
{0.0,-0.5867330574553135,0.7217652390202275},
{0.01887666925314438,-0.5882604957538496,0.7199723617490799},
{0.0,-0.6122745733330462,0.6710058565383848},
{0.020155549566362365,-0.6139941056249196,0.6684213191734837},
{0.0,-0.6329555290763363,0.6245994403661661},
{0.022186390548044166,-0.6346855392223919,0.6214805324379813},
{0.04101067053027838,-0.6225498556675587,0.6602870117101663},
{0.046403854918974176,-0.6416428343992611,0.610406604773594},
{0.0632649342893017,-0.641338976627982,0.6462234029858391},
{0.07468369977687991,-0.6555923509336059,0.5896616176991913},
{0.09298827819168537,0.17923300943181508,0.24398556617376124},
{0.08991873259875816,0.1561270125483946,0.2973993383817187},
{0.08738483819573681,0.13867905692327126,0.3535932345659753},
{0.0856072120234541,0.13139461985471873,0.41406209525650084},
{0.08437850898970783,0.12940964859023385,0.4770072221520465},
{0.08349138400229582,0.1278577619652729,0.5406275885393231},
{0.08273849196901582,0.12187374302131254,0.6031210034990213},
{0.08191260421826767,0.10659004638778888,0.662688768729892},
{0.08091953648301511,0.08346076538396388,0.7180001967508175},
{0.07966498807561985,0.053937664917059064,0.7677246000806796},
{0.07805489114964763,0.019471345688275677,0.8105312912383602},
{0.0759949450174602,-0.01848421540372628,0.8450907469487616},
{0.07305637260180838,-0.05729942622106293,0.8735637335854228},
{0.06881074608724909,-0.09434294831682005,0.8981086891098423},
{0.06301777335120778,-0.12691377017059693,0.9207839297657793},
{0.055437627953517914,-0.15231086163469662,0.9436524286210737},
{0.047378295357903125,-0.17224823899286867,0.9643636537208897},
{0.04014717892507694,-0.18843978348096435,0.9805810435826344},
{0.03460241491254776,-0.20226426428873706,0.9902090273699014},
{0.031601673895415884,-0.2151009162883482,0.9911403921860822},
{0.03074295553489737,-0.22540379030554006,0.9858665389144593},
{0.031624143071606235,-0.23162728642786087,0.9768788684383166},
{0.03464525769409206,-0.231973521298276,0.9662496674736556},
{0.04020597132909834,-0.2246443787185468,0.9560046544956688},
{0.0474777185520304,-0.21536379400771521,0.9464348810094133},
{0.05563228320009966,-0.20985546964361906,0.9377976365453584},
{0.06341826022216544,-0.21456642930446257,0.9304025999048844},
{0.06958459382889315,-0.23594427877145996,0.9245478078291691},
{0.07352286995411282,-0.26954279883276705,0.9190504270016632},
{0.07462525663466459,-0.3109163523795498,0.9127264598997968},
{0.049540109516860324,-0.48884312265667157,0.8510433323301759},
{0.04204145854058626,-0.5298080398903551,0.8167819133609522},
{0.037857651365700976,-0.5662535093535223,0.7697398407016903},
{0.0373827717300509,-0.5974204687209858,0.7156601426501636},
{0.055147624233879686,-0.618787141810189,0.7098973228500464},
{0.12960523520163175,0.12885432231858615,0.3508259168558987},
{0.11793756246692928,0.045732340886507974,0.7618977489494497},
{0.11581579699506785,0.011961052651799375,0.8041072024187544},
{0.11332323190576452,-0.025674701046446584,0.8382172746053488},
{0.10937051962589403,-0.0642782592093062,0.8664539274199041},
{0.10286819616172917,-0.10095202947303962,0.8910431227730923},
{0.09348213438546513,-0.13251831150544063,0.9138033504685057},
{0.08087809074869506,-0.15579987065671116,0.936553100309737},
{0.06782640989714822,-0.17326715210177024,0.9568079566496247},
{0.05709720363534972,-0.18739025175373084,0.9720706975747843},
{0.0496611869429638,-0.1993001957612423,0.9808022427264775},
{0.046488841958450655,-0.2101274281699438,0.9814774822182084},
{0.04597554352413312,-0.21893639302198198,0.9767857319566987},
{0.04651596795872191,-0.2247911850976973,0.9694628760894786},
{0.04971299411086385,-0.2257474639227107,0.9604752056133359},
{0.05716915156739968,-0.21986065618143918,0.950765727404653},
{0.06797461332352296,-0.2118936451232283,0.9408967529711995},
{0.0812195523744273,-0.20660943041802565,0.9314142949364606},
{0.09430289962972428,-0.21166511148145797,0.9229935927921677},
{0.10462381884022962,-0.2347180205703562,0.9163098860300518},
{0.11135898350843962,-0.2702564571231655,0.9104550939543364},
{0.15205694830168537,0.0016880987293273473,0.7958646237955562},
{0.14984844948131712,-0.03580550541384905,0.82956023863895},
{0.14526613458570856,-0.0740523508521115,0.8576956055297459},
{0.13586051414830472,-0.1092352388863438,0.8825339409712623},
{0.12369572544296584,-0.14278719070684187,0.9063198341704946},
{0.10024605494237472,-0.16191113731868217,0.9303257623075495},
{0.08339289217298472,-0.17652972305285092,0.9492522595783595},
{0.0696673688769312,-0.18866051694239916,0.9635370674465294},
{0.06024870933210083,-0.1970615440049502,0.971744719889121},
{0.06112186384727015,-0.2033214797757041,0.969847064076153},
{0.06146425683781854,-0.21074853208173425,0.9655977121023291},
{0.06115294814801017,-0.21650553085175062,0.960219080288886},
{0.060300167238194806,-0.2191504905091015,0.9559930124354667},
{0.06973465998490025,-0.21394625675748832,0.9476223711500437},
{0.08355285408016375,-0.20657857895848966,0.9370094690696655},
{0.10064898664597485,-0.20076453409348227,0.9264105374615305},
{0.12502990554214455,-0.20231257883857645,0.9141432986264116},
{0.13942298457019553,-0.23230788126728483,0.9057773141650693},
{0.15035022227603442,-0.26964990578662784,0.8986861352958744},
{0.19079241100663658,-0.26709214516019186,0.8838948978089061},
{0.2362709549807353,-0.2581650133971008,0.8622103964761813},
{0.0337651179428014,-0.5934738103124206,-0.21821401482849206},
{0.0,-0.6178057161351388,-0.18661489054426048},
{0.0,-0.5969478010767741,-0.22343734155883693},
{0.030935980893050795,-0.5661498950177222,-0.25799725130958623},
{0.0,-0.5703456935146157,-0.2609674901289882},
{0.02862433341929055,-0.5340050025932689,-0.2992454198679907},
{0.0,-0.5385116440975628,-0.3000744509749934},
{0.0,-0.5019637245046158,-0.34162752509009503},
{0.0,-0.4592839318031398,-0.38252142575654474},
{0.0,-0.40905542726651994,-0.41965028415358435},
{0.03633975955653065,-0.6152444628906422,-0.1795269714519221},
{0.0,-0.6324025312167292,-0.14963109221734094},
{0.037887920722226846,-0.6307284029596446,-0.14156733563884932},
{0.05765194780398729,-0.5864513195984189,0.7698271561532073},
{0.1330303293131359,0.1475689340937151,0.2947402918315231},
{0.0,0.3983330898202408,-0.15177195066793409},
{0.06299495491321136,0.34894630623624423,-0.16493784013006507},
{0.06911984278561903,0.39644009083135373,-0.15708189432618372},
{0.0,0.4549065171670909,-0.15295827660254413},
{0.0736108839292419,0.45201695782489065,-0.16038137060810553},
{0.1356334939743607,0.3886410747018614,-0.17476443746438258},
{0.12340234552586894,0.342607204456115,-0.17923778267649798},
{0.11110553585783647,0.30472859738204994,-0.18652734225153952},
{0.05683386023357465,0.3105938673119473,-0.17499588162120344},
{0.0,0.35037129440500053,-0.16118176224701075},
{-0.06299495491321136,0.34894630623624423,-0.16493784013006507},
{-0.06911984278561903,0.39644009083135373,-0.15708189432618372},
{-0.0736108839292419,0.45201695782489065,-0.16038137060810553},
{-0.07487090410493222,0.5146163155324294,-0.18378971179497866},
{0.0,0.5192091082822199,-0.17368649911025555},
{0.07487090410493222,0.5146163155324294,-0.18378971179497866},
{0.14752236585290607,0.499334947310946,-0.20827494355056056},
{0.14470615148997998,0.4413702937699261,-0.18160938676029986},
{0.21076785790167002,0.4209862105617934,-0.2156006633645903},
{0.19693592617536787,0.3728125296508721,-0.20657194298417436},
{0.1786334433313988,0.3292910159967728,-0.2071132987835793},
{0.16025295868407466,0.2923658936532727,-0.21010670530278377},
{0.0,0.3119012706726608,-0.17224218512156347},
{-0.05683386023357465,0.3105938673119473,-0.17499588162120344},
{-0.11110553585783647,0.30472859738204994,-0.18652734225153952},
{-0.12340234552586894,0.342607204456115,-0.17923778267649798},
{-0.1356334939743607,0.3886410747018614,-0.17476443746438258},
{-0.14470615148997998,0.4413702937699261,-0.18160938676029986},
{-0.14752236585290607,0.499334947310946,-0.20827494355056056},
{-0.07065380063786848,0.5814266064151244,-0.22003626501753},
{0.0,0.5875817636440581,-0.20747117571419674},
{0.07065380063786848,0.5814266064151244,-0.22003626501753},
{0.150105739011787,0.564777296119876,-0.2533917687141752},
{0.2231049490980023,0.5143485481477773,-0.27684574677704116},
{0.2157366891959935,0.4718666704697396,-0.2413176716578119},
{0.0,0.538398716113601,-0.8437204764629559},
{0.07293576085811297,0.619075864903205,-0.8103939149279735},
{0.07738919814728254,0.5376128770499484,-0.8423851321577569},
{0.08065165267776116,0.4623655851386773,-0.8755847952365348},
{0.15150511464809838,0.5350376533332091,-0.8368423472954621},
{0.14182008476584032,0.6151839241775905,-0.8057545539373738},
{0.13178928569557527,0.690717610769837,-0.7736736928440332},
{0.06780091378530528,0.6969216646516202,-0.7777088309101355},
{0.0,0.6206941112713188,-0.8118829344278423},
{-0.07293576085811297,0.619075864903205,-0.8103939149279735},
{-0.07738919814728254,0.5376128770499484,-0.8423851321577569},
{-0.08065165267776116,0.4623655851386773,-0.8755847952365348},
{0.0,0.46247734891661896,-0.8767187319002345},
{0.0,0.40291889733391,-0.9127846702008081},
{0.08221401715690413,0.40316687321621814,-0.911897545213396},
{0.15878838751063068,0.4603142541310396,-0.8696845991260306},
{0.2190721394439403,0.5304530100255601,-0.8255565341353938},
{0.20260095266978637,0.6099810874732015,-0.7977937131710703},
{0.18815199175276456,0.6819266911111125,-0.7679353213703404},
{0.175251424842643,0.7399833169277302,-0.735784607915786},
{0.12193078911630362,0.7528419724211237,-0.7391270433998541},
{0.062493880642106196,0.761317392248367,-0.7424252390551537},
{0.0,0.6993769751482762,-0.779300300539784},
{-0.06780091378530528,0.6969216646516202,-0.7777088309101355},
{-0.13178928569557527,0.690717610769837,-0.7736736928440332},
{-0.14182008476584032,0.6151839241775905,-0.8057545539373738},
{-0.15150511464809838,0.5350376533332091,-0.8368423472954621},
{-0.15878838751063068,0.4603142541310396,-0.8696845991260306},
{-0.08221401715690413,0.40316687321621814,-0.911897545213396},
{0.2327306044732288,0.6718237112675934,-0.759692742747142},
{0.24947305125009533,0.6064954546486456,-0.7856056403453269},
{0.2701505143753249,0.5317918469488199,-0.8055880724764816},
{0.2766316492899216,0.6077586181805906,-0.7682810905583474},
{0.2613654157467014,0.6616858052434674,-0.7481461474385431},
{0.24785480488198153,0.7060606819103922,-0.7200387214922327},
{0.21853427626259597,0.7239778125616665,-0.7301661496621765},
{0.2318947045507067,0.4546096446319334,-0.8565220858613583},
{0.161616243933759,0.4010526750834882,-0.9070323282548727},
{0.2353966362595458,0.39371468453800523,-0.8959875057409911},
{0.30026619570652463,0.4430246305246669,-0.8239860202141092},
{0.0,0.354514703630984,-0.9475327272864861},
{0.08341128662810429,0.31245426853226804,-0.9761419260275137},
{0.0,0.3120584384853913,-0.9765750106670377},
{-0.08341128662810429,0.31245426853226804,-0.9761419260275137},
{0.0,0.27034027995662174,-0.9955259562642725},
{0.08463288800512718,0.27070816905901307,-0.9952151132568722},
{0.16098873688885731,0.311134058905332,-0.9726586216149983},
{0.08286946514629122,0.3549012200296989,-0.9468924139753618},
{-0.08286946514629122,0.3549012200296989,-0.9468924139753618},
{-0.16098873688885731,0.311134058905332,-0.9726586216149983},
{-0.08463288800512718,0.27070816905901307,-0.9952151132568722},
{0.0,0.2241538987222257,-1.0},
{0.08732732641833764,0.22454972876910245,-0.9996833359624987},
{0.1621482860850022,0.2706522871700422,-0.9914314436911386},
{0.16176060548026702,0.3528068133993128,-0.9432379712778732},
{0.22542986852039312,0.2690107566815239,-0.9813226428175182},
{0.16808573678815353,0.22597588114387904,-0.9956912735191445},
{0.23570864347296627,0.22867334649274204,-0.9849817423390878},
{0.0,0.17625380622605735,-0.9911974382810732},
{-0.08732732641833764,0.22454972876910245,-0.9996833359624987},
{-0.09027544532335531,0.17669736871976338,-0.990794622998075},
{-0.09225808817579977,0.1298741667923039,-0.9697958390112631},
{-0.09205586559008655,0.08679970824997135,-0.9379361770617652},
{-0.1717203879832983,0.05288173005671429,-0.8910570932453349},
{-0.22695497840688886,0.030705933783454202,-0.8305346790778789},
{-0.20520062471295047,0.012521035747527956,-0.7828173669268861},
{-0.1867968559452218,0.005220299794692271,-0.7347589424119672},
{-0.17917247071876335,0.009139017258772142,-0.6865817688829852},
{-0.22754523085914333,0.023360958001849924,-0.6955170500882176},
{-0.27970166056525697,0.05900079689902085,-0.6725554147513052},
{-0.32574135184110453,0.11489083531199848,-0.6484936047252794},
{-0.35698980562998395,0.18651744650036764,-0.6149470082524745},
{-0.34342331287629324,0.23055703183346732,-0.5230713617543188},
{-0.321576986906757,0.27519851167902376,-0.4270662765024224},
{-0.2908291417065747,0.3152355567145873,-0.3352154275924976},
{-0.2497571175190304,0.3484980869184573,-0.2581678074915493},
{0.24413516664736026,0.5373241539569326,-0.31530773748784136},
{0.19927132345194074,0.5790388198676414,-0.3102311007160449},
{0.11496138619682417,0.6383981922208918,-0.2939532885618505},
{0.1662765606327227,0.6315759449423689,-0.3341691556421207},
{0.14680172232638636,0.6835507585093274,-0.3691889384129194},
{0.09542251655937538,0.69687043958673,-0.3352101886654066},
{0.046977692066343446,0.7100131613490587,-0.3049603908006769},
{0.043371563918694185,0.7533053264171734,-0.34509569482434754},
{0.08984038153359694,0.7400892596755706,-0.3709480537094805},
{0.14250347369971286,0.723577325690709,-0.3973569030722815},
{0.20813558808993957,0.7098210673557215,-0.4150109231629847},
{0.20997503360189626,0.6729448416650706,-0.39387941968986717},
{0.0,0.6563653837310358,-0.2478268639374961},
{0.05871393653563722,0.6496397655521917,-0.2618503075541254},
{-5.04894031057524e-19,0.7165397002984443,-0.29076767162870676},
{0.0,0.759089101925655,-0.3323074737951778},
{0.0,0.7884911249664565,-0.3715697397242811},
{0.04186927247019487,0.7838762123022814,-0.3818194095263486},
{0.09178064728690519,0.7751900711853772,-0.4054167013503044},
{0.14942817110801562,0.7512027703446458,-0.41865488800629136},
{0.21170853636601242,0.7368073629045544,-0.43085925971631794},
{0.163622170906608,0.7659695595051893,-0.43306310171260526},
{0.2136655666860119,0.7524065593695591,-0.44121137964816526},
{0.17886628453544395,0.7731585316800831,-0.44405320654353636},
{0.21501022463937264,0.760899442287106,-0.44961345449613455},
{0.26881400586410575,0.6842760588599279,-0.7049750597965317},
{0.28050729113125317,0.6447291445588794,-0.7322687057347043},
{0.28662752217958,0.6096097057527495,-0.7474709079468121},
{0.2966059319789349,0.6141710649399938,-0.7110335879257865},
{0.28701054596023423,0.6566692415023148,-0.6845502293776912},
{0.27746289238836286,0.6940472399876827,-0.6562192758754974},
{0.2571649604257269,0.7160705252722933,-0.6756009777002158},
{0.2667743169166702,0.7241699065550038,-0.6271164537818942},
{0.2459990604857417,0.7403651765023642,-0.6464154969791764},
{0.23496005900196112,0.7381718123602589,-0.6903992004233053},
{0.20549749724810804,0.7591601184928889,-0.6993391384526189},
{0.25081654499743583,0.9665820482924299,-0.546558054006353},
{0.2636181543958382,0.93636158841941,-0.5352734050523049},
{0.2625284575609069,0.9429847564684743,-0.5564375062939888},
{0.24172875280355366,0.9654772167792358,-0.5666836834779956},
{0.2524720459581969,0.9435948004230725,-0.5751299981547334},
{0.2624527841695922,0.9114487437925991,-0.5630769732273363},
{0.2645332203277357,0.9062796690627968,-0.5391769878381218},
{0.2582045964017885,0.9279071243005305,-0.51931330472103},
{0.24940087047684134,0.9409590379932814,-0.5077003496692781},
{0.2525919591782801,0.9586002518177622,-0.5253043089011118},
{0.23095635449840476,0.9807527639706178,-0.5352734050523049},
{0.22338319433683623,0.9785826839489169,-0.5569835189174747},
{0.212221951220932,0.9650429679336917,-0.5755595901761967},
{0.22925195688479427,0.9537699610398456,-0.5839558439940649},
{0.2397158405945833,0.9398751621884512,-0.5860840125990375},
{0.2515104117854904,0.9148819873462447,-0.5836450009866646},
{0.25443838992635814,0.875860129960318,-0.5671400522379241},
{0.2580928326238468,0.8711672154927882,-0.5397043731652841},
{0.258119609362312,0.9049629520539215,-0.5162316513854924},
{0.2435856614058137,0.9130867816630567,-0.49852640622989924},
{0.2232190412879844,0.9242061133622329,-0.48693440688651146},
{0.23172589467777396,0.9529503600016066,-0.4966927817480437},
{0.23402170894965915,0.9720037557286214,-0.5139917190025781},
{0.20658835828905955,0.9840043913851084,-0.5244171839136997},
{0.20153453995525958,0.9809646494662988,-0.5447092948462345},
{0.19315574922769485,0.9673061844370104,-0.5620606213716792},
{0.19838885528860958,0.9396807397830734,-0.58743798420056},
{0.21730487470523757,0.9299479774539863,-0.5966515106446266},
{0.2352720662153816,0.9199299846499437,-0.5963476528733478},
{0.24279516551808045,0.8820700048722022,-0.5904882039735516},
{0.2302752939765727,0.8478912445304145,-0.5939214475271973},
{0.24233413993407102,0.8401038704611246,-0.5692891765512609},
{0.24705499534608646,0.8338404420723101,-0.5395437127344929},
{0.2521123062979471,0.8710938705135138,-0.5136261583122272},
{0.23484945943003965,0.8787380472423162,-0.49434923502932926},
{0.2108807858856319,0.8900552939649305,-0.482213551474496},
{0.19931090645662838,0.9318712457993992,-0.4823288078704984},
{0.2093254066426103,0.9575757505199636,-0.49142940633060306},
{0.21046865695447198,0.975581360828775,-0.5060576549747396},
{0.18141938833779905,0.9750097356728441,-0.5158148656302517},
{0.17893846530869797,0.971903634010882,-0.5344864017826323},
{0.1785659193822257,0.9629415760671841,-0.5495919748950614},
{0.1793005333809882,0.9438753740739468,-0.5715908118532472},
{0.18337758286381875,0.9075626240970855,-0.5942148274442942},
{0.20492354368013674,0.8988706619500801,-0.6048568346751778},
{0.22550903452976848,0.8897549288117125,-0.6047322646310137},
{0.21262825912199076,0.8565436236727325,-0.6086428326529519},
{0.20051236706950135,0.8276119398641024,-0.6102180033983174},
{0.2181954923107103,0.8188000644970135,-0.5955816053120393},
{0.23066995981742924,0.8102652701627385,-0.57072813519226},
{0.2366050821085401,0.8021856803823719,-0.5401653987492935},
{0.2415413156342973,0.8330452893604959,-0.5114409436122636},
{0.22289655622038188,0.8416627423222068,-0.4917367567199427},
{0.197096586606159,0.8547856725821914,-0.48002950098055247},
{0.17011844049946767,0.867505787559178,-0.47591868952313543},
{0.18478743635431213,0.9010023231731134,-0.47755789159961326},
{0.17791978504100042,0.9386073418324254,-0.485023944807321},
{0.19094725040732657,0.9557060356514809,-0.4914573472750885},
{0.1861053175692077,0.967752075342757,-0.5002552521699345},
{0.15915394820098155,0.9524381093527073,-0.5112954178597353},
{0.15835297445906624,0.9506836508802272,-0.5309390660390044},
{0.16447669812545368,0.9462899373598952,-0.5518447135441982},
{0.16320771356340763,0.9139762350625091,-0.5761649773067141},
{0.16868064606448885,0.8737587380938105,-0.5974850821551083},
{0.19114050860668405,0.8654020672806302,-0.6086579673312148},
{0.1789535999869609,0.8365227727429101,-0.6101248669166993},
{0.19304747806781383,0.8102722553988598,-0.6115964233262646},
{0.21080045567023634,0.8012496587421104,-0.5971090436105755},
{0.2239781036131716,0.79242963393288,-0.5726583887737942},
{0.23193428755539441,0.7840915904160233,-0.5430386592072106},
{0.23537335213914126,0.7765847899976077,-0.5146285396956417},
{0.23255131674611404,0.7939314596989713,-0.5063440496557152},
{0.21111246288365682,0.8101546705908171,-0.48739659667654106},
{0.18463725377770304,0.8249365944296234,-0.47759398198624026},
{0.15754850809909024,0.8383924876113926,-0.4749256217878829},
{0.13415844494673468,0.8492475445439777,-0.47976871883202193},
{0.14659798627284684,0.8781524516141427,-0.47974892732967817},
{0.16175245603812544,0.9105860671316117,-0.48076760759737563},
{0.14696354696319772,0.9178146223111936,-0.49222921586649815},
{0.1651053693763756,0.9469372359071407,-0.4953353175284605},
{0.1398921595963465,0.9217752511920014,-0.5097435312347743},
{0.14001207281642974,0.9215575446662193,-0.5311136969420382},
{0.14766905581145454,0.9185084890992479,-0.5540241072140608},
{0.14811611092322122,0.8809116198820777,-0.5786470645418355},
{0.15640642199324878,0.8448689657019085,-0.5988367253445905},
{0.24193830988719428,0.7584080414038229,-0.5739948972850133},
{0.22287327209997737,0.7757139638944789,-0.5845100060596924},
{0.2348599372842217,0.7668578486986214,-0.5583479683731792},
{0.24447860742332683,0.7607446028864161,-0.5336761143925551},
{0.23177479133062348,0.7741259868828908,-0.5488655103384406},
{0.22159963071385042,0.7823324751194621,-0.5767086615181596},
{0.2074859611306536,0.7915937340103579,-0.600288490251812},
{0.2076442931494043,0.7861848328403892,-0.6069093298888358},
{0.22764418837086248,0.7686984584165983,-0.5981428585565359},
{0.2384945884793665,0.7676786139428805,-0.5223472256097383},
{0.2526001086204217,0.7585046705035017,-0.5157450132690381},
{0.24224333186449343,0.7637005219717691,-0.5027443246411772},
{0.18928942103452515,0.8012182251795642,-0.6144114734831705},
{0.18830217432937368,0.7971435041087741,-0.620293042297351},
{0.21067006459597104,0.7813789903888971,-0.6187586187626936},
{0.20288385473270124,0.7925041431181745,-0.47803521606790583},
{0.1762782545524821,0.8070474047228345,-0.47211755686709833},
{0.14932339256619528,0.8206767646016176,-0.47209660115873425},
{0.126135901261359,0.8318112309790566,-0.47862896113822095},
{0.11083590574355219,0.8388686478736651,-0.49237590582504664},
{0.11878277603761317,0.8562281238412511,-0.49249931166319055},
{0.13117342071087584,0.8850608501381622,-0.491867147794208},
{0.21955761335437443,0.7719209806805833,-0.47170892055399904},
{0.22412828618978073,0.7794440799832821,-0.4864105141774098},
{0.2349996420066488,0.7702619871017616,-0.49380671502390405},
{0.2350415534233769,0.7650498367492109,-0.4782389521214453},
{0.2397239900367249,0.7608796507847623,-0.4655945105357735},
{0.21674605581552925,0.7665726182236661,-0.45961049159181305},
{0.19617220702609975,0.7835292789082543,-0.46636521492116284},
{0.16905435619698134,0.797462496558316,-0.46423588211017},
{0.1423707542134071,0.8113095629628813,-0.46734896900825357},
{0.11972461870797581,0.8229458021350375,-0.4762481598268593},
{0.10471788668666385,0.8302465380878732,-0.49148179560151317},
{0.10339092466481054,0.8422576515985422,-0.5113990321955354},
{0.11133872632368769,0.859661367394897,-0.5109962169125373},
{0.1237294874175524,0.8885092283700707,-0.5100438963879926},
{0.13361941755937015,0.8072429913342324,-0.46060355932706565},
{0.14608457141792727,0.7891570508100255,-0.4430694524564456},
{0.1600014901837059,0.7925274272385789,-0.45458228579045806},
{0.18894132343447761,0.778045868552991,-0.45509570064537763},
{0.1199958787106884,0.8054279941487007,-0.45178004189977466},
{0.11211571742158635,0.8197547134335986,-0.4725459846825414},
{0.1387256251640803,0.8165426690237959,-0.6070129442246359},
{0.16118432350025524,0.8070811666974211,-0.6295217034196806},
{0.13250294398597365,0.8176149027684237,-0.6162148286085002},
{0.10880133930260566,0.8255594446504442,-0.5924626973838544},
{0.11663598013631689,0.823804986177964,-0.5858639776612148},
{0.0916651580496988,0.830860074660532,-0.5639547845665865},
{0.10012521035747528,0.8289461199632809,-0.5603899857326552},
{0.09161847338828775,0.8316668694325485,-0.5350207723459158},
{0.08267946672379037,0.8334597467036964,-0.5363817291835598},
{0.09091506011086735,0.8314119083141192,-0.5110555914195688},
{0.0814320199731185,0.8327868356240057,-0.5105596396549527},
{0.08751045602531915,0.8282720446775703,-0.4873069528129837},
{0.09781426140732716,0.827625910336345,-0.48979718949024653},
{0.10050241310802843,0.8193425845024388,-0.4674409412838515},
{0.1639714327126757,0.8074595336539945,-0.6194082457219795},
{0.1668644846729367,0.8105155744570871,-0.613882923949988},
{0.1434418237520148,0.8189409334254608,-0.6020697254627573},
{0.12225327418390615,0.8259471252551795,-0.5823387618319713},
{0.10611807726718936,0.8310626465080515,-0.5584760310354041},
{0.0978561728240553,0.8338125011278247,-0.5342652026387894},
{0.09740888487108457,0.8337042299679436,-0.5113769122811511},
{0.13576272084260574,0.8519857571035485,-0.5798869439533759},
{0.14866445195874753,0.8274885340259582,-0.5998542414062678},
{0.12788570290975831,0.8345028752978186,-0.5807321575240598},
{0.11991205587723215,0.8572107137223217,-0.5568100522204611},
{0.11194620902504149,0.8396661289975198,-0.5575155610687178},
{0.17136064832304854,0.8192156860462343,-0.6113263275295723},
{0.13231667102273753,0.8861540395911542,-0.5556633092905386},
{0.11174258939210402,0.8598790739206791,-0.5331405796232513},
{0.1037712707716183,0.8423868784667874,-0.5337587730199911},
{0.12414860158483366,0.8887793241667631,-0.5320520469943403},
{0.2869104242424948,0.7550132166488447,-0.5209804477419933},
{0.2631978760225367,0.758553567156351,-0.501660448836347},
{0.24784781964586017,0.7611741949078792,-0.4876573788250716},
{0.26013484998332276,0.7590856093075944,-0.4746869595537366},
{0.25118792671788787,0.7558514449834073,-0.4546311824433076},
{0.28364715476780206,0.7560551810369466,-0.46274686261030124},
{0.2802406879526215,0.7593068084514372,-0.48852587651616003},
{0.3086345085799073,0.7595524559217047,-0.4775974746043009},
{0.3075180350065108,0.7595105445049767,-0.5052287402883389},
{0.3256319164752033,0.761400050875803,-0.492728660249175},
{0.36226249469558636,0.7628506515770044,-0.49620614363158927},
{0.4141674559013312,0.7613872446095805,-0.49891175842259394},
{0.3532853020736256,0.7580808995121395,-0.47013142139659314},
{0.34944924323698173,0.7576652779629189,-0.5229130297355681},
{0.271574338338061,0.7480640709141171,-0.44410676002046673},
{0.2894809911351533,0.7326837451809148,-0.4315775748307972},
{0.2935103081711546,0.7048755201818024,-0.4146011226438653},
{0.322922809066138,0.7507033259619689,-0.4507473911598345},
{0.07016215643552715,0.8021309626994214,-0.42824445299489083},
{0.0820772229495276,0.8188117065572158,-0.4608538636214141},
{0.058173162839242364,0.8193041657037714,-0.45338897461972666},
{0.030123132249729175,0.8219585554298859,-0.4456528256153265},
{0.05021406838196901,0.8311848881401752,-0.48028562630500216},
{0.07119189666041682,0.8294478927579984,-0.48399478668544144},
{0.09842791440058817,0.8028178442513544,-0.4407992507170054},
{0.12426851480491692,0.7842685497310976,-0.42960890245059546},
{0.0364441888365449,0.8060880989621686,-0.4146965875375238},
{0.0,0.8238271060923483,-0.44171664506094327},
{0.0,0.8348218677473603,-0.4747800960353546},
{0.02593292194173265,0.8335109717685862,-0.4766102278991495},
{0.02440001187490141,0.8408466339020285,-0.5084815319088496},
{0.04712065656562717,0.8381375264929632,-0.5093453727758571},
{0.06648256688800164,0.8352398177086214,-0.5100147912374869},
{0.0,0.8092267983926973,-0.4076764252355625},
{-0.030123132249729175,0.8219585554298859,-0.4456528256153265},
{-0.02593292194173265,0.8335109717685862,-0.4766102278991495},
{0.0,0.8421540372627421,-0.5079995506164762},
{0.0,0.8457642401314621,-0.5425089454680079},
{0.026050623170377474,0.8440656635479529,-0.5421783109582637},
{0.0497282452097288,0.8405276414524868,-0.5409791787574313},
{0.06866033066943593,0.8367032246760452,-0.5387078128119708},
{0.07843593578006752,0.834350364309169,-0.5698689511493333},
{0.041007760015227816,0.838563625896366,-0.6186969158436215},
{0.058872850657398036,0.838719629503076,-0.5755991731808845},
{0.07538979072814685,0.8330790513350823,-0.6136139923593159},
{0.050994202836122285,0.8261985937555483,-0.6606374377222541},
{0.10445198203164428,0.8188617674160855,-0.6561843496948907},
{0.12276086800872456,0.8194764681947648,-0.6312051453249271},
{0.09652024641584624,0.8286981440809729,-0.6032909775779741},
{0.03141109336990493,0.8432716750421588,-0.5786121383612287},
{0.0,0.8415824121068114,-0.6199274816070003},
{0.0,0.829709839112549,-0.6621450845184466},
{0.0,0.8059530510638224,-0.7042683867422547},
{0.057524001562364487,0.802428999440599,-0.702640826725979},
{0.11276126965980156,0.792760268442624,-0.7006395565772111},
{0.15617590920124408,0.7988735142548297,-0.6693782965221092},
{0.1570071522996853,0.8064187334719127,-0.6458403792051849},
{0.19086924860397148,0.7907077732289661,-0.6477846032589619},
{0.19561222393037117,0.7803952363018064,-0.6707113124152676},
{0.16342542008918984,0.7778467893235322,-0.7011459861960092},
{0.22391523648807943,0.7599995110334716,-0.6620018871779587},
{0.21595672413381617,0.7735264207824745,-0.6376222489084113},
{0.18914156686995645,0.7947417470890484,-0.6308733466091626},
{-5.04894031057524e-19,0.7644595842969564,-0.7440644411316316},
{-0.062493880642106196,0.761317392248367,-0.7424252390551537},
{-0.12193078911630362,0.7528419724211237,-0.7391270433998541},
{-0.175251424842643,0.7399833169277302,-0.735784607915786},
{-0.18815199175276456,0.6819266911111125,-0.7679353213703404},
{-0.20260095266978637,0.6099810874732015,-0.7977937131710703},
{-0.2190721394439403,0.5304530100255601,-0.8255565341353938},
{-0.2318947045507067,0.4546096446319334,-0.8565220858613583},
{-0.161616243933759,0.4010526750834882,-0.9070323282548727},
{-0.16176060548026702,0.3528068133993128,-0.9432379712778732},
{-5.04894031057524e-19,0.8455931018464891,-0.5794410530476294},
{-0.03141109336990493,0.8432716750421588,-0.5786121383612287},
{-0.026050623170377474,0.8440656635479529,-0.5421783109582637},
{-0.0497282452097288,0.8405276414524868,-0.5409791787574313},
{-0.058872850657398036,0.838719629503076,-0.5755991731808845},
{-0.06866033066943593,0.8367032246760452,-0.5387078128119708},
{-0.07843593578006752,0.834350364309169,-0.5698689511493333},
{-0.08267946672379037,0.8334597467036964,-0.5363817291835598},
{-0.0916651580496988,0.830860074660532,-0.5639547845665865},
{0.23575521171377528,0.7574114810505097,-0.6196876551668336},
{0.25375500099248566,0.744902087363184,-0.5983128326354888},
{0.2482785758733437,-0.650481486504815,0.3358658694959978},
{0.21379595776027718,-0.6565190589257056,0.4008751336654038},
{0.23879029680850383,-0.6639094387420987,0.3323301758125722},
{0.20689454447237896,-0.666964315339171,0.3932984808857745},
{0.16596804603736287,-0.6695348822318294,0.44780544254672405},
{0.16739769103020008,-0.6643821063863103,0.4632009029581894},
{0.2658639078088537,-0.6456826292894443,0.2688518425597631},
{0.2548039506167091,-0.6601036492619807,0.267500199370281},
{0.24059830875791444,-0.676329188565867,0.26611479420621237},
{0.22699106879351585,-0.6788042905648669,0.3287514065063982},
{0.19891624061577187,-0.6788042905648669,0.3862177798707615},
{0.16397725374277683,-0.6774386769031422,0.4345637632726764},
{0.1275410979277715,-0.6758076242688059,0.47201510673731856},
{0.12375393574397714,-0.6703253781195628,0.49216634874140597},
{0.11989110016886809,-0.668433543336696,0.5156600262295618},
{0.08208362608263885,-0.6630316274028486,0.5510693523347279},
{0.05122448278692294,-0.6547028975341534,0.5728097355564236},
{0.02456288429713099,-0.649977385298057,0.5842631943834046},
{0.0,-0.6485139783306334,0.587417028492196},
{-0.022186390548044166,-0.6346855392223919,0.6214805324379813},
{-0.02456288429713099,-0.649977385298057,0.5842631943834046},
{-0.046403854918974176,-0.6416428343992611,0.610406604773594},
{-0.05122448278692294,-0.6547028975341534,0.5728097355564236},
{-0.07468369977687991,-0.6555923509336059,0.5896616176991913},
{-0.08208362608263885,-0.6630316274028486,0.5510693523347279},
{-0.11822046452984414,-0.6796786092860565,0.5507992565380355},
{-0.11989110016886809,-0.668433543336696,0.5156600262295618},
{-0.18175467967162406,-0.6600547526091312,0.47236902536746717},
{-0.16739769103020008,-0.6643821063863103,0.4632009029581894},
{-0.21379595776027718,-0.6565190589257056,0.4008751336654038},
{-0.22842886322849465,-0.6469679127357736,0.4059429224714464},
{-0.2482785758733437,-0.650481486504815,0.3358658694959978},
{-0.26241087275286407,-0.6387113636403325,0.3385807979351642},
{-0.2658639078088537,-0.6456826292894443,0.2688518425597631},
{-0.2802907488114912,-0.6334049126001435,0.27002070540406975},
{-0.26157031600626107,-0.6415322348273397,0.20051294917251153},
{-0.27865271094103355,-0.6291613816564208,0.2000065195537133},
{-0.2599939810548754,-0.6288808080055464,0.12898645970188183},
{-0.23943177432564824,-0.6395612340350973,0.13186321277785965},
{-0.22680712424232016,-0.6354620646378825,0.05740990937238237},
{-0.20348574924515792,-0.641297065211254,0.06392014943748478},
{-0.16067789388145706,-0.6430212543272082,0.002602582558214701},
{-0.17386369126653392,-0.65190065364347,-0.0275014567127828},
{-0.1179561897632529,-0.6410095063242581,-0.04616833604108248},
{-0.11872689414864233,-0.6354830203462465,-0.08285945297451724},
{-0.0765360679756611,-0.638615898746674,-0.08186638523926469},
{-0.07704168265024516,-0.6302429290492104,-0.11882655018397364},
{-0.037637732848480335,-0.6391921807266858,-0.10396650812121012},
{-0.037887920722226846,-0.6307284029596446,-0.14156733563884932},
{0.0,-0.6402225030545856,-0.11161662230071556},
{0.037637732848480335,-0.6391921807266858,-0.10396650812121012},
{0.0765360679756611,-0.638615898746674,-0.08186638523926469},
{0.1179561897632529,-0.6410095063242581,-0.04616833604108248},
{0.16067789388145706,-0.6430212543272082,0.002602582558214701},
{0.20348574924515792,-0.641297065211254,0.06392014943748478},
{0.23943177432564824,-0.6395612340350973,0.13186321277785965},
{0.26157031600626107,-0.6415322348273397,0.20051294917251153},
{0.18249045787640675,-0.6916338409077547,0.3814131016252898},
{0.15371361346846663,-0.6864135411130625,0.426955676930501},
{0.12955517434276206,-0.6819301837291731,0.4561760838321471},
{0.10684593887103451,-0.6839302896719209,0.46738156677681997},
{0.09497371513857836,-0.675013635763012,0.4967963960838438},
{0.08800140170404835,-0.6680423701139001,0.5226964874158061},
{0.05667448042940575,-0.6647197261321759,0.5418255565341353},
{0.02773930400271493,-0.6623878214736637,0.5519797614425443},
{0.0,-0.6614704271297258,0.554813438895774},
{-0.02773930400271493,-0.6623878214736637,0.5519797614425443},
{-0.05667448042940575,-0.6647197261321759,0.5418255565341353},
{-0.08800140170404835,-0.6680423701139001,0.5226964874158061},
{-0.12375393574397714,-0.6703253781195628,0.49216634874140597},
{-0.16596804603736287,-0.6695348822318294,0.44780544254672405},
{-0.20689454447237896,-0.666964315339171,0.3932984808857745},
{-0.23879029680850383,-0.6639094387420987,0.3323301758125722},
{-0.2548039506167091,-0.6601036492619807,0.267500199370281},
{-0.24808648188000648,-0.6552803437201855,0.201412880426146},
{-0.224619581130316,-0.650652624789788,0.13688559754911353},
{-0.19038959572363845,-0.6474335951438639,0.07673689351415007},
{-0.15107785103867552,-0.6453450095435789,0.02438604140265874},
{-0.11236893223098547,-0.6441144437802002,-0.016745357291917052},
{-0.07431790624532499,-0.6438629752798315,-0.046551359821736756},
{-0.03698053855006289,-0.6447175024986772,-0.06492718764498},
{0.0,-0.6454206829348935,-0.07125581157092718},
{0.03698053855006289,-0.6447175024986772,-0.06492718764498},
{0.07431790624532499,-0.6438629752798315,-0.046551359821736756},
{0.11236893223098547,-0.6441144437802002,-0.016745357291917052},
{0.15107785103867552,-0.6453450095435789,0.02438604140265874},
{0.19038959572363845,-0.6474335951438639,0.07673689351415007},
{0.224619581130316,-0.650652624789788,0.13688559754911353},
{0.24808648188000648,-0.6552803437201855,0.201412880426146},
{0.23212987416679232,-0.670269496230592,0.202253437172749},
{0.21673324954930676,-0.6940204632492175,0.2648423170261056},
{0.20592592506355112,-0.6949739479797824,0.3259142364351081},
{0.16863873464776075,-0.7122251527874877,0.3245963552202126},
{0.15025242897033547,-0.7050501510848363,0.38066451715428473},
{0.12746309612441636,-0.694780689780425,0.42846448793271363},
{0.09012805684119474,-0.7020057523419461,0.43359048703976755},
{0.07459719926957714,-0.6864810650622355,0.47744612782167156},
{0.06395577414170367,-0.6746830012532677,0.5117808917701695},
{0.03216980643328605,-0.6744408464010608,0.5198406900481924},
{0.0,-0.6743430530953619,0.5221388327321179},
{-0.03216980643328605,-0.6744408464010608,0.5198406900481924},
{-0.06395577414170367,-0.6746830012532677,0.5117808917701695},
{-0.09497371513857836,-0.675013635763012,0.4967963960838438},
{-0.1275410979277715,-0.6758076242688059,0.47201510673731856},
{-0.16397725374277683,-0.6774386769031422,0.4345637632726764},
{-0.19891624061577187,-0.6788042905648669,0.3862177798707615},
{-0.22699106879351585,-0.6788042905648669,0.3287514065063982},
{-0.24059830875791444,-0.676329188565867,0.26611479420621237},
{-0.23212987416679232,-0.670269496230592,0.202253437172749},
{-0.20901805625327072,-0.6627324264556504,0.14158433304674464},
{-0.17869514625047078,-0.655829848961732,0.08852098685087514},
{-0.14448029552205618,-0.6509657962092289,0.04498317431249271},
{-0.10969160764627231,-0.6495477932765938,0.012890671158949646},
{-0.07405782262040655,-0.6501613298492529,-0.009179182366469923},
{-0.037307913282950377,-0.6513860745825303,-0.02265021022650209},
{0.0,-0.6521521221438388,-0.02723485353415109},
{0.037307913282950377,-0.6513860745825303,-0.02265021022650209},
{0.07405782262040655,-0.6501613298492529,-0.009179182366469923},
{0.10969160764627231,-0.6495477932765938,0.012890671158949646},
{0.14448029552205618,-0.6509657962092289,0.04498317431249271},
{0.17869514625047078,-0.655829848961732,0.08852098685087514},
{0.20901805625327072,-0.6627324264556504,0.14158433304674464},
{0.03830854835733441,-0.6886569661140376,0.48305527242711926},
{0.0,-0.6896511980553103,0.4847468637745073},
{-0.03830854835733441,-0.6886569661140376,0.48305527242711926},
{-0.07459719926957714,-0.6864810650622355,0.47744612782167156},
{-0.10684593887103451,-0.6839302896719209,0.46738156677681997},
{-0.12955517434276206,-0.6819301837291731,0.4561760838321471},
{-0.15371361346846663,-0.6864135411130625,0.426955676930501},
{-0.18249045787640675,-0.6916338409077547,0.3814131016252898},
{-0.20592592506355112,-0.6949739479797824,0.3259142364351081},
{-0.21673324954930676,-0.6940204632492175,0.2648423170261056},
{-0.20762915847114138,-0.6863623160481725,0.2025794148584122},
{-0.18646854984751812,-0.6754595266687584,0.14420263238623235},
{-0.1611086501089406,-0.6647779364331872,0.09478907206377059},
{-0.14006679049938037,-0.6577158627144978,0.061759383063945794},
{-0.11424097551150847,-0.6586029877019096,0.04730343691080263},
{-0.07857447629647438,-0.6608208001704398,0.03322236509617217},
{-0.04001143250311862,-0.6632796032851566,0.024661958229452226},
{0.0,-0.6645695435555667,0.021763085239090114},
{0.04001143250311862,-0.6632796032851566,0.024661958229452226},
{0.07857447629647438,-0.6608208001704398,0.03322236509617217},
{0.11424097551150847,-0.6586029877019096,0.04730343691080263},
{0.14006679049938037,-0.6577158627144978,0.061759383063945794},
{0.1611086501089406,-0.6647779364331872,0.09478907206377059},
{0.18646854984751812,-0.6754595266687584,0.14420263238623235},
{0.20762915847114138,-0.6863623160481725,0.2025794148584122},
{0.1766985329257836,-0.7128386893601465,0.26383178620054965},
{0.12453628218956883,-0.7299385473852225,0.2630948437897468},
{0.11918442711459107,-0.7279291277943128,0.3243006468910752},
{0.10637990720113813,-0.7171800136095685,0.381960278454796},
{0.055053439966843414,-0.7261525494074482,0.3832898017298938},
{0.046609686543350085,-0.7075578508524026,0.436836293424157},
{0.0,-0.7099153680433598,0.43798885738418053},
{-0.046609686543350085,-0.7075578508524026,0.436836293424157},
{-0.09012805684119474,-0.7020057523419461,0.43359048703976755},
{-0.12746309612441636,-0.694780689780425,0.42846448793271363},
{-0.15025242897033547,-0.7050501510848363,0.38066451715428473},
{-0.16863873464776075,-0.7122251527874877,0.3245963552202126},
{-0.1766985329257836,-0.7128386893601465,0.26383178620054965},
{-0.16851067198553593,-0.7034225910685608,0.20193560892922738},
{-0.1508112478600438,-0.6884928130651857,0.14298370868305596},
{-0.13033402817029308,-0.6725688031205379,0.09105429915088639},
{-0.09068652646909703,-0.6791535523709347,0.08362433632980565},
{-0.04648232240473739,-0.6844797949134674,0.07880685181811146},
{0.0,-0.6868291626622831,0.07705122913961102},
{0.04648232240473739,-0.6844797949134674,0.07880685181811146},
{0.09068652646909703,-0.6791535523709347,0.08362433632980565},
{0.13033402817029308,-0.6725688031205379,0.09105429915088639},
{0.1508112478600438,-0.6884928130651857,0.14298370868305596},
{0.16851067198553593,-0.7034225910685608,0.20193560892922738},
{0.118431185819505,-0.7188937248713406,0.2008261205919522},
{0.06428966842830441,-0.7424747178110134,0.2626431318538992},
{0.06162002760332474,-0.7394547673945476,0.32452301024093827},
{0.0,-0.7298500677276852,0.3839627128095842},
{0.0,-0.7441732943945226,0.32476400088712504},
{0.0,-0.7476007169180673,0.26248829245320915},
{-0.06428966842830441,-0.7424747178110134,0.2626431318538992},
{-0.06162002760332474,-0.7394547673945476,0.32452301024093827},
{-0.055053439966843414,-0.7261525494074482,0.3832898017298938},
{-0.10637990720113813,-0.7171800136095685,0.381960278454796},
{-0.11918442711459107,-0.7279291277943128,0.3243006468910752},
{-0.12453628218956883,-0.7299385473852225,0.2630948437897468},
{-0.118431185819505,-0.7188937248713406,0.2008261205919522},
{-0.10557741999139651,-0.7001732920661106,0.14012558290340177},
{-0.054299732989349266,-0.7088419700927115,0.1378251118074357},
{0.0,-0.7124242320169462,0.1368145809818797},
{0.054299732989349266,-0.7088419700927115,0.1378251118074357},
{0.10557741999139651,-0.7001732920661106,0.14012558290340177},
{0.0,-0.7348491683785346,0.1992323225502632},
{0.061042581417292775,-0.7302214494481373,0.199757379465385},
{-0.061042581417292775,-0.7302214494481373,0.199757379465385},
{0.17463905247600428,-0.17066328891693333,0.8929326291439187},
{0.17339451624038293,-0.14814381902650256,0.8857064023763773},
{0.1605405175710704,-0.1609602138413618,0.8976208867873678},
{0.1618735334642289,-0.17881540873236013,0.9006454940279143},
{0.1549919116786745,-0.16986604063428276,0.9023126370488775},
{0.144561789943472,-0.15812304377007166,0.9036724296805012},
{0.15247373405692619,-0.14200624130847445,0.8927195794422174},
{0.16700186098332334,-0.11776609820427043,0.8732005013071124},
{0.19320348167452409,-0.1305832497530428,0.8663247005516591},
{0.18938139331012296,-0.1608668445185397,0.8819460169310482},
{0.19166440131578566,-0.18496893607286533,0.8861127102774362},
{0.1773027558502808,-0.19593645530700404,0.8939187116430498},
{0.1556706437884661,-0.20103614335800093,0.902691004005451},
{0.14581098300317422,-0.18302378065427213,0.9075841619084597},
{0.14257099764888595,-0.17037573002993758,0.9079846487794174},
{0.1272838083973016,-0.16167538559958647,0.9130256608469949},
{0.1804950087577398,-0.08640166621165615,0.847913946547809},
{0.2113767376502481,-0.15172526600652306,0.8651849428578581},
{0.20006880457579534,-0.1740822127365303,0.879236909521983},
{0.21972060219720604,-0.17684964686720894,0.868169967093717},
{0.21642939177802786,-0.20161370596463493,0.8736673479212229},
{0.20115384458664573,-0.22084767004538655,0.8820088840561404},
{0.1735423704049516,-0.2293817658560494,0.893527538420254},
{0.127889195527819,-0.18640149158075311,0.9153424308272441},
{0.12776462548365483,-0.17429013993174258,0.9154099547764173},
{0.10929205214013082,-0.17114084622642994,0.9276189833105247},
{0.2502134862789589,-0.18127595815610725,0.8473178730654535},
{0.24904462343465225,-0.21706970508915197,0.8531249326943395},
{0.2896218600636006,-0.2278091563639285,0.8220138552158467},
{0.1112979791129798,-0.18176550678761216,0.9266189303391508},
{0.0917889131496488,-0.18308082674926324,0.9436989968618827},
{0.0759770162447487,-0.19405672826674755,0.9575181223219624},
{0.10954608189374408,-0.1920616284098867,0.9255140988259565},
{0.09188717213775584,-0.19939472929008464,0.9370851424609803},
{0.09421884395506397,-0.19125704562930868,0.9397674731315804},
{0.07757651889593688,-0.20122008790919663,0.9530126450236888},
{0.07601636640823232,-0.20779133236975883,0.949042702494719},
{-0.3700056289361078,-0.5830972420541485,0.13439536087185064},
{-0.3973423504970287,-0.5639122910468483,0.20511738398250434},
{-0.4024462296896984,-0.5540328387592125,0.13455485709662157},
{-0.3685887902094931,-0.5877459166929099,0.07003106683764976},
{-0.407802741588757,-0.5505343996684342,0.06372572703210709},
{-0.4234554915306923,-0.514867784032798,0.13577960182989907},
{-0.416424851374549,-0.528208420818565,0.20750167791192667},
{-0.40910665233140986,-0.5387503063317091,0.2768115191200466},
{-0.3910311896613849,-0.5738674167257987,0.2743422381511477},
{-0.3693885997453882,-0.5887692537846883,0.2030404404424216},
{-0.33719830328614614,-0.6058702760157845,0.20140589519002464},
{-0.33163805533354795,-0.6038387365104904,0.13366423949114886},
{-0.31997736783496683,-0.6137519507727127,0.07289384944138487},
{-0.36380856029044617,-0.6182062030060964,0.02138588248853695},
{-0.4174866072649948,-0.5662709724438256,-0.012894163777010295},
{-0.43727112437271126,-0.4884729051422398,-0.01642287222431452},
{-0.4304092940895007,-0.5026983385033782,0.06174774100374353},
{-0.4358601066761976,-0.4691319505282294,0.1376120621057344},
{-0.42838706823236855,-0.48440516930757105,0.21000588506143228},
{-0.42044951158646937,-0.4948515899270567,0.27974997511509636},
{-0.4130742664483393,-0.4989088479075434,0.34697239492895143},
{-0.401289008905594,-0.5425281548673416,0.343607839530499},
{-0.382048176009323,-0.5775940401965413,0.34115602165190356},
{-0.3645373532591074,-0.5973669152440554,0.2727239917830339},
{-0.33420047278406484,-0.6127716893036826,0.27166107168656783},
{-0.30540849369786177,-0.6183039963117953,0.2003499603296799},
{-0.2928490391516664,-0.6180373931331637,0.13072461929007884},
{-0.2691772381424162,-0.6279692346917095,0.0645441638643258},
{-0.3057193367052621,-0.6461401622553931,0.028080067104835026},
{-0.3045935494837037,-0.6236092831459641,0.2708589337386323},
{-0.2881433184179139,-0.6287934925540295,0.3396914504784596},
{-0.25960513624412,-0.6378125965927183,0.4054981957717202},
{-0.22252983132401077,-0.6546237315247782,0.4669310190469927},
{-0.19094259358324567,-0.6885859495468037,0.5138345511898478},
{-0.2443668436453852,-0.6590023103668471,0.014287718383220556},
{-0.32018576071258725,-0.617471589007334,0.3399731883353543},
{-0.29923005234852373,-0.6257549148412402,0.40345035738214313},
{-0.27540923296868464,-0.6434089349319435,0.4591983626606532},
{-0.2545524821163403,-0.6790627443013572,0.5004915859920404},
{-0.3532503758930188,-0.6014905329676951,0.3402037011273589},
{-0.33920539446501535,-0.6074943434139992,0.4037111395306737},
{-0.3260812999990104,-0.6217314188353399,0.4614790422542755},
{-0.3140911421967054,-0.6565237157497865,0.5052159340221164},
{-0.37308961068368585,-0.5808049204003239,0.4057042602373001},
{-0.3668541232393567,-0.589216308896455,0.46812782283578463},
{-0.36800785140540043,-0.6144993710376977,0.5344957154307941},
{-0.3896783822658826,-0.5456971236543962,0.5403435222703881},
{-0.39109522099249727,-0.609163814847003,0.6123356941491082},
{-0.394972027039849,-0.5411916463561225,0.6121703768942359},
{-0.3997080171301274,-0.6025953644808894,0.6851719153924917},
{-0.3968906385611811,-0.5344043252582064,0.682940132451719},
{-0.39215348426488245,-0.5961328568626162,0.7515025533948538},
{-0.3864046349370077,-0.5277683509429195,0.7466093954918451},
{-0.36455015952533,-0.5908135995562047,0.8046369161579572},
{-0.35916919929984653,-0.5221685199856337,0.7978996559189108},
{-0.3130200726580977,-0.5876714075076154,0.8378866400956047},
{-0.31083718637017443,-0.5184838079316192,0.8315300752251721},
{-0.2493042413771626,-0.5158736580342731,0.8497044954069163},
{-0.24659746238013774,-0.5857853937548497,0.8526219956936021},
{-0.18246600954998202,-0.5134963493409721,0.85462326584237},
{-0.17432006002646241,-0.584234671335909,0.8502120892317347},
{-0.1221298683457622,-0.5086625659449947,0.8530550803331259},
{-0.1020736255529251,-0.5816524623830482,0.8284030178548457},
{-0.06717166043137326,-0.5458962028838548,0.8193408381934084},
{-0.05765194780398729,-0.5864513195984189,0.7698271561532073},
{-0.07389343673035069,-0.62889943530187,0.7705338292074843},
{-0.055147624233879686,-0.618787141810189,0.7098973228500464},
{-0.06910913209023295,-0.6595308599000297,0.7053767108735096},
{-0.0632649342893017,-0.641338976627982,0.6462234029858391},
{-0.08144319635091266,-0.6783258018905542,0.63477925780702},
{-0.3410134064144259,-0.4291566084117378,-0.3496733528958752},
{-0.3826919819385078,-0.3506495396438345,-0.31184981276656676},
{-0.33009315394470834,-0.3568454440834759,-0.35213215601059195},
{-0.26715966910936495,-0.3730605055331802,-0.3762626541918111},
{-0.26083686621351887,-0.31657788625590766,-0.38658683317917303},
{-0.319983188865068,-0.29720666228537135,-0.35417068075200725},
{-0.37079612482384106,-0.2892935539658969,-0.30821609293623814},
{-0.4068248085317674,-0.29863514307218836,-0.2466176031442876},
{-0.41731779739206215,-0.359207618098514,-0.2523552760943682},
{-0.39527006378102686,-0.42564885567279764,-0.314718183559199},
{-0.35027815792338246,-0.5171857182190676,-0.3498386701507472},
{-0.2741239495223554,-0.44033182199988474,-0.36470558102903006},
{-0.2015310473371989,-0.39455989810868913,-0.3873004914695714},
{-0.19980220139716365,-0.34161297251484213,-0.40756815407568153},
{-0.20025973436311237,-0.29103054934807376,-0.4191694670672311},
{-0.25747231081506644,-0.2663982783721373,-0.3912937181189458},
{-0.31314813532032254,-0.2471981926865742,-0.3527433641712105},
{-0.36203780293368276,-0.23964121498868685,-0.3024859873252891},
{-0.39888841609188846,-0.24994106207022607,-0.23948823831762917},
{-0.424897942789752,-0.2722390999756099,-0.16742504987167536},
{-0.43029403769349833,-0.31983300628845884,-0.1739787148213322},
{-0.43706389570111104,-0.37806891983219143,-0.1793883145149132},
{-0.4283055738109528,-0.4334152740337236,-0.25691675170221473},
{-0.4060738956487218,-0.5162322334885026,-0.318152591318865},
{-0.2801102968783562,-0.523479415964408,-0.3579904407043679},
{-0.2031912051220408,-0.45556312936249826,-0.36273923706086875},
{-0.141416105276822,-0.41644231446485236,-0.3900876006819919},
{-0.1433288957680529,-0.36651417508145073,-0.41921952792610084},
{-0.1467598109096582,-0.3148793096723983,-0.43740791858008776},
{-0.15363328325307105,-0.25562122324290754,-0.4408365053096526},
{-0.20515405647214144,-0.23711954474887786,-0.4177328368382726},
{-0.25938742971833784,-0.218034133356307,-0.38599541652089836},
{-0.31205378166131037,-0.20377458875877594,-0.3448023149072506},
{-0.35887349097070914,-0.1997501613880596,-0.2933283427701933},
{-0.39556693631618445,-0.21136975241412673,-0.23075222261481834},
{-0.42263356208041286,-0.23323377431517037,-0.16016424618533343},
{-0.4405716484400513,-0.2599427559899855,-0.08465465865770536},
{-0.44126318681606536,-0.3006759962256441,-0.08997158755207636},
{-0.4434227889835841,-0.3474887202989215,-0.09490316425375266},
{-0.4450212438493541,-0.40278384943556383,-0.09868799802550657},
{-0.44344723731000885,-0.44900399264454643,-0.18321634033001746},
{-0.43772632892661956,-0.5230137335563176,-0.26051705881976284},
{-0.2053461504654787,-0.5327185549409195,-0.34501885722701264},
{-0.1390970068845323,-0.4705802228173902,-0.3538225831519597},
{-0.09502750145671278,-0.43380644725651946,-0.3894624220491306},
{-0.0978644386867989,-0.3854872405930698,-0.42364583921499915},
{-0.10222590370037063,-0.3317335202272064,-0.44703939498541545},
{-0.10910577917689472,-0.2681317811362534,-0.4561283513853179},
{-0.11768609396656052,-0.19850050264594926,-0.4545170902533254},
{-0.162864272787441,-0.1900557014370377,-0.43209331809775725},
{-0.21291348959694606,-0.17945094879880136,-0.4045784730157418},
{-0.2644761742327446,-0.16958593266581642,-0.3707513028920624},
{-0.3141935923264853,-0.16336034097265922,-0.32938799435825766},
{-0.35856031955126844,-0.1647939442659652,-0.27910267656785076},
{-0.39406860316815384,-0.17790651309236985,-0.2185071735464451},
{-0.4208115796587596,-0.1983697623098779,-0.15033415623295526},
{-0.4388823855047037,-0.22185563961769805,-0.07731666811222246},
{-0.448372992981584,-0.24403620913564106,-0.0021857968029738205},
{-0.4498829681898169,-0.2860954800283368,-0.007315288528088473},
{-0.44917978775360046,-0.3293911377145122,-0.010803249764684822},
{-0.448434695900656,-0.3762050259938099,-0.013994338466123631},
{-0.4452599060835004,-0.4285570423113215,-0.0161225070710963},
{-0.4440270119080813,-0.46896546906733716,-0.10056469813011049},
{-0.448445173754838,-0.5351109983124834,-0.1856089001221834},
{-0.31706219596032154,-0.1223789152976089,-0.30554144602537153},
{-0.27600414224502,-0.06547040617401736,-0.30969975708841385},
{-0.27063365987371857,-0.11915527539584461,-0.34561376650334796},
{-0.22196519140420126,-0.11759482021457482,-0.3810289136386153},
{-0.23173753673797626,-0.053629616004107324,-0.34464514709452015},
{-0.24165424361825918,0.010366090404090084,-0.2929883946122874},
{-0.2787318769504089,-0.007259988742127791,-0.2621247109130926},
{-0.3181553854133135,-0.07725403382833432,-0.2723023163625081},
{-0.35835192667364807,-0.12994625442907629,-0.25816850601516145},
{-0.17336773950191775,-0.11949747047136956,-0.41376755113338365},
{-0.3509988014499022,-0.4672145032129176,0.7923917972372228},
{-0.30630842495149624,-0.4629500165608306,0.8272050498600334},
{-0.2509411150416,-0.459682090262057,0.8494378922282846},
{-0.19186231633922404,-0.45711152336939853,0.8617621771583943},
{-0.13679304317050556,-0.4541253349275195,0.8681408619432113},
{-0.09345885026506061,-0.449610543981084,0.8725369038755837},
{-0.0801000518653782,-0.4986864845576803,0.8517663042687361},
{-0.04204145854058626,-0.5298080398903551,0.8167819133609522},
{-0.037857651365700976,-0.5662535093535223,0.7697398407016903},
{-0.0373827717300509,-0.5974204687209858,0.7156601426501636},
{-0.04101067053027838,-0.6225498556675587,0.6602870117101663},
{-0.19786263416746755,-0.4083906656289711,0.8676705227110401},
{-0.248300695787728,-0.36459789197215925,0.8527488941498066},
{-0.2505557628489053,-0.4111509981029263,0.8505206038270945},
{-0.30059217339218786,-0.4153095420071727,0.8247660382476605},
{-0.2948491450944142,-0.36980422129460877,0.824067514635525},
{-0.2902365608422798,-0.32067472724108204,0.8249627890650786},
{-0.24432842484671774,-0.31434028228503375,0.8559225197609419},
{-0.20024692809688988,-0.362147238299584,0.8727988502301345},
{-0.14745367769771273,-0.40612744912565213,0.8789505148410074},
{-0.10426943452767289,-0.40345908892729476,0.8870929717464663},
{-0.06650294049335559,-0.40089783568279813,0.8924518120575655},
{-0.05835897012007039,-0.44524477140523744,0.8753309983241254},
{-0.049540109516860324,-0.48884312265667157,0.8510433323301759},
{-0.020198858030314765,-0.5231103626559964,0.81646059249937},
{-0.018755708247642923,-0.5578456134754518,0.7710227957359792},
{-0.01887666925314438,-0.5882604957538496,0.7199723617490799},
{-0.020155549566362365,-0.6139941056249196,0.6684213191734837},
{-0.34215782093230784,-0.420359867722912,0.7882763289557247},
{-0.44184528982617827,-0.45059429806817475,0.06244044358577786},
{-0.4424902599613833,-0.42035637510485135,0.13959703337021928},
{-0.4349811311309272,-0.43525471954568024,0.21244606087982545},
{-0.4267432093318098,-0.44500960178915183,0.28277458235564285},
{-0.4195006836799854,-0.44935441865663434,0.35066525642510754},
{-0.40662456509628864,-0.4986410805228915,0.41275003507170643},
{-0.39444231330064633,-0.5434653407136234,0.4088499449039501},
{-0.3900369577201121,-0.5454887307767757,0.47349830520708613},
{-0.4014659682206683,-0.49611475345900163,0.47815978611207005},
{-0.39799779848641575,-0.4916884421701033,0.5447360715846998},
{-0.396617050146428,-0.48572072211042616,0.614010986612213},
{-0.39180655087085525,-0.4791150171516652,0.6814022162990008},
{-0.37805029253586775,-0.4727735869594955,0.7423262815434346},
{-0.369434003780177,-0.42579554563134603,0.7389186505222338},
{-0.36290397221273074,-0.3814800434714528,0.7366496129888138},
{-0.3347604558797934,-0.37601526041251315,0.7857139115052079},
{-0.33092672545519,-0.32859016397259694,0.7848675337285037},
{-0.32953084243693936,-0.28064583164766005,0.7841224418755592},
{-0.28805949558445765,-0.27198763147524113,0.8250722244309798},
{-0.2362709549807353,-0.2581650133971008,0.8622103964761813},
{-0.1987928347776279,-0.31319703197317206,0.8775965432394848},
{-0.15362979063501037,-0.36068615974420065,0.8867588446186615},
{-0.11139158127700595,-0.35844273474322563,0.8971726674695808},
{-0.07243678215784423,-0.3560421419295201,0.9042894588712208},
{-0.035671156039115,-0.3541037389058443,0.90835952311793},
{-0.03234839563678868,-0.39895361162902104,0.8953832828164938},
{-0.027995429327164596,-0.44270796648716554,0.87690151224541},
{-0.02361207724041262,-0.4844121545436924,0.8511737234044412},
{-0.4414389819251195,-0.5501071360590113,-0.10210377848884893},
{-0.43796033433668496,-0.38350226932858494,0.21463360399182965},
{-0.4453961181878668,-0.3704445346057329,0.14157618360460308},
{-0.44754989932528444,-0.4005835000573372,0.06414484119938836},
{-0.4498468778031899,-0.3525274039544586,0.06640456508464654},
{-0.44662784815726564,-0.3213057269040444,0.14339350920217547},
{-0.4390779721161016,-0.33190000168809874,0.21638573405226938},
{-0.4309250373564607,-0.33884449059874533,0.28755015545060886},
{-0.429673515884718,-0.3920615119892847,0.28550231706103185},
{-0.45106463730034596,-0.3062944544792536,0.06876324648162391},
{-0.44466732521920543,-0.2724416718231292,0.1459524340346317},
{-0.4370184916663223,-0.2805620088142038,0.2184382292659274},
{-0.42920550506458727,-0.2858882513567366,0.2895188278308106},
{-0.4240026683601984,-0.2893692273572116,0.3589322833747306},
{-0.4246779078519293,-0.3429087338153535,0.3566981720219174},
{-0.42266848826101966,-0.39648200224808183,0.35410315680283416},
{-0.43046983280255247,-0.22960133511146402,0.22153152466166717},
{-0.4251051714613522,-0.17354563018180824,0.15691576212709754},
{-0.4379987531353524,-0.22335420560693262,0.1501587103857073},
{-0.4493765385710186,-0.26058190509508944,0.07232455269749445},
{-0.4429559423694736,-0.21409271387483272,0.07819215103943229},
{-0.42997388103793627,-0.16552622985268722,0.0874708730206315},
{-0.4086060437427128,-0.1135830826894789,0.10126438594826623},
{-0.40446845554683053,-0.12251853852561458,0.16712934154253808},
{-0.418116442721937,-0.17913475044370802,0.22640489106233222},
{-0.4232249787386876,-0.23372029601102273,0.2920079003020533},
{-0.41911882410535134,-0.23659704908700055,0.36128630794762706},
{-0.4198674085763565,-0.2913367355313931,0.426703044224112},
{-0.4192166174110503,-0.3446515502276314,0.4241115216230895},
{-0.4162874750641623,-0.397638058826166,0.4209984347250059},
{-0.4129974288510044,-0.4494999444091626,0.41700637228165177},
{-0.44248327472526194,-0.2009308991337725,0.005932211776060351},
{-0.4300437333991498,-0.15450003463512912,0.018385723574415196},
{-0.4088866173935872,-0.10246200468127241,0.03652056075147173},
{-0.38157434415909114,-0.04750402960808751,0.05759385392357806},
{-0.38119481299649755,-0.06024149125477543,0.11761915212039753},
{-0.3780479641238273,-0.07160425843278079,0.17945828329672878},
{-0.3986462612396815,-0.12927635864297818,0.23379759929076574},
{-0.4116900254902909,-0.18286952335659226,0.29561926737679356},
{-0.4085047578189532,-0.18532634732107464,0.3642398986209398},
{-0.4163200728327286,-0.23849575268538672,0.42913157798230295},
{-0.41525948114830297,-0.29212373880106574,0.492852066087319},
{-0.413423528254407,-0.34463059451926736,0.49007194211101984},
{-0.40987037148067795,-0.3964063288567672,0.4867527907473563},
{-0.40698081213847764,-0.44666044592583193,0.48268039808860663},
{-0.39159932219925503,-0.14453780729945534,-0.200850918180183},
{-0.41674384382409085,-0.1632008447478883,-0.1360723996439858},
{-0.4337261170411239,-0.1829826841817582,-0.06631608542710932},
{-0.38536616316696637,-0.10624963254747487,-0.1758811438789831},
{-0.4077422028757053,-0.12328027852464829,-0.11551647962726778},
{-0.372575031622746,-0.058028335610326276,-0.14169563114227818},
{-0.39111501249484115,-0.07416166979741069,-0.08680378297104209},
{-0.42263356208041286,-0.13989087896972424,-0.05001836534996905},
{-0.35550427874817586,-0.09038045670637967,-0.22888538333520575},
{-0.3472733421851798,-0.04126982279038064,-0.18961295388754584},
{-0.3354939056725356,0.009709478208682766,-0.14683641566578903},
{-0.3553017069006566,-0.006222681178106643,-0.10435186031390485},
{-0.3690917272102306,-0.02031853840919397,-0.05480208788707666},
{-0.40313776806571244,-0.08914721326915453,-0.026783141598303504},
{-0.3818816945484307,-0.3862241830038727,0.6795488003148014},
{-0.38598784918176693,-0.43138024191036894,0.680186785213885},
{-0.3953864843830494,-0.43687645853185475,0.6155745152973761},
{-0.3942991159601586,-0.39027561995425836,0.6170833262995886},
{-0.39637140267616044,-0.3415349707114871,0.6187574545566733},
{-0.3819329196133206,-0.33867335231377216,0.6797408943081387},
{-0.4011958724239759,-0.4420490258797177,0.5485744588333842},
{-0.35981416943505157,-0.2388045001219506,0.7342001235222588},
{-0.37544130684454186,-0.19201936773135247,0.6798654643523028},
{-0.3820342055370803,-0.24065116371123269,0.6803707297650807},
{-0.3606163073829871,-0.2863807105032921,0.7353084476535137},
{-0.3830237806542722,-0.289794162554594,0.6802019198921481},
{-0.39742733753650517,-0.2409631709246532,0.6217168662600873},
{-0.39012194475958856,-0.19079345879205475,0.6225585872127104},
{-0.373405110515167,-0.14180983975286235,0.6226785004327937},
{-0.35972219715945375,-0.14467285519780151,0.6783054282852002},
{-0.3542632351306152,-0.19218154162996995,0.7321650913989042},
{-0.32944934801552356,-0.23474863918868813,0.781862717990301},
{-0.3608049087582637,-0.3344740611988179,0.7357857721218063},
{-0.3984623166884858,-0.2914880823140225,0.6203757009247871},
{-0.40730795403016107,-0.24041471346852483,0.5595820267546185},
{-0.39936923317824174,-0.1892387780726453,0.5614272932966765},
{-0.382001607768514,-0.13931552835452868,0.5629663736554148},
{-0.3574950710427619,-0.09176481408503012,0.5646789207111669},
{-0.3495994258135908,-0.09524590650610713,0.6228601165719488},
{-0.33746024964069693,-0.10001565857097204,0.6764322207986571},
{-0.3398282446858361,-0.14694934364975096,0.7289053145422721},
{-0.32552480952134255,-0.19054525006854264,0.778273470829945},
{-0.2896218600636006,-0.2278091563639285,0.8220138552158467},
{-0.4086374773052589,-0.292063200088014,0.5574014688787358},
{-0.4061810026025826,-0.34340584978598987,0.554860007136583},
{-0.4129951004389639,-0.23968021589036442,0.49530737658397517},
{-0.4042472564029876,-0.18808993957188652,0.4976555801267704},
{-0.3866351477290125,-0.13814526846299777,0.5001097264174063},
{-0.3621996275704941,-0.09073879931940516,0.502902656659928},
{-0.33298504169894916,-0.04676324531741786,0.5062672120583803},
{-0.32814194465481006,-0.04770636861440275,0.5670434231382454},
{-0.32102748166521045,-0.05233548459202438,0.6238834536637273},
{-0.31124000165317256,-0.059452043152460346,0.6749874411275568},
{-0.32002626448781635,-0.10490800152976672,0.7243823741536951},
{-0.31259979428479623,-0.14768419048971745,0.7735398091517072},
{-0.2881607815082173,-0.18637564620710412,0.8170042767108154},
{-0.24904462343465225,-0.21706970508915197,0.8531249326943395},
{-0.20115384458664573,-0.22084767004538655,0.8820088840561404},
{-0.19079241100663658,-0.26709214516019186,0.8838948978089061},
{-0.15484056489604514,-0.31381755378195236,0.8928418210743411},
{-0.11368483429564663,-0.31277093256976946,0.9045176432511851},
{-0.07462525663466459,-0.3109163523795498,0.9127264598997968},
{-0.03696319188036153,-0.30911532566626054,0.9175695569439359},
{-0.4066583270708751,-0.1869261992340689,0.43175569835189176},
{-0.39063419540848787,-0.13629117723930662,0.3682738724810221},
{-0.38896006715140324,-0.1374276053038898,0.4349351449931283},
{-0.40276056531515936,-0.3936599668550546,0.5519273721716342},
{-0.2923274748546052,0.12718019406150152,-0.03621088195009163},
{-0.3174580260071983,0.08489506720088202,-0.0005314600482330215},
{-0.2916743552772586,0.12981362807925215,0.011719479902602564},
{-0.2676276799294957,0.16195735629768515,-0.03750664325060289},
{-0.2645378771518166,0.1681439470891648,0.01625522655740207},
{-0.2902691586108461,0.12262698431639861,0.06076747953471347},
{-0.31880268396055905,0.07513552813332955,0.04716373218837556},
{-0.34876469009708894,0.021752025281897944,0.025544426392783356},
{-0.343901801550606,0.03377594505878951,-0.024374399342456405},
{-0.31436007378737757,0.08774038671431372,-0.044985502724533104},
{-0.29466520054321854,0.11060422874552728,-0.08378499676059672},
{-0.27103880356875715,0.14099931952158118,-0.09293682028559136},
{-0.2426729238859567,0.17065513947479177,-0.10512419458772261},
{-0.23836186899306078,0.19289263866712383,-0.042795631200488474},
{-0.23403800783394232,0.1995006720379252,0.016951421757497087},
{-0.2611803069894855,0.16313436858413338,0.0686491542916418},
{-0.28834123344135226,0.10801969138062611,0.11100529771949505},
{-0.3187386526294467,0.06042345665573672,0.09757850968823151},
{-0.3506704953521985,0.007687252351550633,0.07886040529504183},
{-0.37769520969969894,-0.03413778028987566,-0.0003498439090778165},
{-0.3356242967468009,0.042820661629923366,-0.06990766099950577},
{-0.3105612695433809,0.08521638806246433,-0.07837376717858743},
{-0.32200541472220007,0.05488416441150258,-0.10704105980002432},
{-0.3011195587193501,0.0759656070257505,-0.13176355674252826},
{-0.2753615005218554,0.10169339586671938,-0.1503357861213836},
{-0.24712368350127978,0.12769593732846155,-0.16901838223095633},
{-0.22154025620681886,0.149744835145517,-0.1911072123145056},
{-0.20637181596929757,0.20304684357553282,-0.11932157058377363},
{-0.2024985025400065,0.21813029677357762,-0.044531462376645056},
{-0.19812923734609925,0.22282670385916836,0.0180504322405902},
{-0.22955115783199226,0.19556798410160262,0.07310107811298507},
{-0.257686524722788,0.14907658088990744,0.12034688682578651},
{-0.2541939066621108,0.12811621570176301,0.17202249944554696},
{-0.28611759994272107,0.08839467049768061,0.16250511523020136},
{-0.31760820858380745,0.042725196736264855,0.15019480077233432},
{-0.35008024289994405,-0.007478859473930225,0.13458046962906656},
{-0.19340023249194224,0.21883464141581424,0.07641440844654757},
{-0.15476489150473047,0.23706727189856971,0.023795788950404274},
{-0.1507425597048505,0.231844643691837,0.08088146694615375},
{-0.18843722222771989,0.20597715012844103,0.13161640110157174},
{-0.22498281340862644,0.18219474954726939,0.1268152154741608},
{-0.2204156331912808,0.16047997885801868,0.1792557114492095},
{-0.2159939787264634,0.1351259001495423,0.2317218199567032},
{-0.2507408716061212,0.10440832430588584,0.22458523705271938},
{-0.28364831897382226,0.06714674642254044,0.21574658494716542},
{-0.31568028341431353,0.024560090202682454,0.20510690612832233},
{-0.34779956330632184,-0.022134234118338047,0.19256375046641008},
{-0.2781684012366197,0.03337429398181161,0.3293626146670168},
{-0.24737049517756762,0.08210562957642112,0.2789420161370597},
{-0.2809822871875053,0.04767423652824453,0.2712070313386798},
{-0.3105158655085921,-0.0030863101596184674,0.32221089708476996},
{-0.3132261371236777,0.008449807294798503,0.2624137832679147},
{-0.211861047354662,0.1108359057435522,0.285513959121234},
{-0.20815887221034413,0.09231222375574027,0.3419325470673942},
{-0.24412236038113777,0.06536201859353435,0.3360044100124046},
{-0.27525672198003504,0.02764407195026045,0.3906941520185296},
{-0.3078184001597291,-0.007524263508719026,0.3845972050906073},
{-0.33885729686496785,-0.04689759469215191,0.3786783816837796},
{-0.3413824597228375,-0.043456550958170664,0.314754157525224},
{-0.34463059451926736,-0.034664350672823765,0.2526693788786252},
{-0.37362747386503015,-0.08084619150374088,0.24284115165587938},
{-0.3933107050489869,-0.13386455277898887,0.3009513309494275},
{-0.36942701854405563,-0.08722150009109912,0.3074988256071771},
{-0.3669402744848534,-0.08998404455649282,0.3731612093539297},
{-0.36494016854210554,-0.09065090176487813,0.4386792315541743},
{-0.17392422997958565,0.13295931274590214,0.2908157533373421},
{-0.17844484195612223,0.15808171445635363,0.23725878378889692},
{-0.18336710500963674,0.18407377806391376,0.1847111808599874},
{-0.1416279907725031,0.19748543141691438,0.18889999412075964},
{-0.13712833450433057,0.17205684352314354,0.2412962502670398},
{-0.1330303293131359,0.1475689340937151,0.2947402918315231},
{-0.1700602301984564,0.11366376216668055,0.34694096136640534},
{-0.21959952477110253,0.004513626740415244,0.7351990122876124},
{-0.246825646760102,-0.038245215549834136,0.7580791532031091},
{-0.21801154775951465,-0.025081654499743578,0.7740124767959188},
{-0.1882439640283624,0.02077059960684762,0.7453928002007092},
{-0.18627179903009997,-0.011215262275242752,0.786220341124006},
{-0.18530317962127216,-0.04891202036894853,0.8196575022309099},
{-0.21946214846071593,-0.06153294499301185,0.8054157699854883},
{-0.25209950003172465,-0.07020662910549977,0.783745239125006},
{-0.2672493129729223,-0.04902844097097111,0.7435277421563076},
{-0.24835308505863818,-0.013863947391858361,0.7239120349215239},
{-0.22301297682240445,0.027469441047226605,0.6896808853088261},
{-0.19089253272437598,0.04653215042240306,0.6981283641915842},
{-0.15662412851903101,0.06199513478304147,0.7061287879625755},
{-0.15433879210132784,0.03460951656927114,0.7543432160842047},
{-0.15205694830168537,0.0016880987293273473,0.7958646237955562},
{-0.14984844948131712,-0.03580550541384905,0.82956023863895},
{-0.14526613458570856,-0.0740523508521115,0.8576956055297459},
{-0.1804950087577398,-0.08640166621165615,0.847913946547809},
{-0.22053671061738428,-0.10568755388090988,0.8355174808444452},
{-0.2626413855448688,-0.10701125612590655,0.8013328994725565},
{-0.27960735987761864,-0.0729694064120975,0.7547553450153647},
{-0.2983766893356983,-0.0678572613566842,0.7185566872284854},
{-0.2745849751063648,-0.037081242370812416,0.716656703003477},
{-0.25344881480916626,0.004294756008612794,0.6816210870308032},
{-0.22703763703432486,0.044001166534432264,0.6381612762957759},
{-0.19389036322645728,0.0655541125868716,0.6453781894151552},
{-0.15884659781164195,0.08287749816783078,0.6523529476823279},
{-0.12131259571956374,0.09660348714629238,0.6582030829339622},
{-0.11975023124042077,0.07436948057202099,0.7128450924932579},
{-0.11793756246692928,0.045732340886507974,0.7618977489494497},
{-0.11581579699506785,0.011961052651799375,0.8041072024187544},
{-0.11332323190576452,-0.025674701046446584,0.8382172746053488},
{-0.10937051962589403,-0.0642782592093062,0.8664539274199041},
{-0.13586051414830472,-0.1092352388863438,0.8825339409712623},
{-0.16700186098332334,-0.11776609820427043,0.8732005013071124},
{-0.19320348167452409,-0.1305832497530428,0.8663247005516591},
{-0.24057269622546945,-0.14586744699515516,0.8418810309509992},
{-0.27691455135283655,-0.14592193183690172,0.8112647410311025},
{-0.29563964098214746,-0.10791048885592892,0.7661901765460221},
{-0.2826925058312169,-0.024256814534413633,0.6760305697216792},
{-0.2588810000995396,0.017589988759590874,0.6315846764875206},
{-0.23111934334123638,0.053845692641461204,0.5817112547870698},
{-0.19691147784894314,0.07732190703931349,0.5880957606019876},
{-0.16093518341192695,0.09629264413889212,0.5941496319071616},
{-0.12268868723547058,0.11116537604727607,0.5992278985673863},
{-0.08273849196901582,0.12187374302131254,0.6031210034990213},
{-0.08191260421826767,0.10659004638778888,0.662688768729892},
{-0.08091953648301511,0.08346076538396388,0.7180001967508175},
{-0.07966498807561985,0.053937664917059064,0.7677246000806796},
{-0.07805489114964763,0.019471345688275677,0.8105312912383602},
{-0.0759949450174602,-0.01848421540372628,0.8450907469487616},
{-0.07305637260180838,-0.05729942622106293,0.8735637335854228},
{-0.10286819616172917,-0.10095202947303962,0.8910431227730923},
{-0.12369572544296584,-0.14278719070684187,0.9063198341704946},
{-0.15247373405692619,-0.14200624130847445,0.8927195794422174},
{-0.17339451624038293,-0.14814381902650256,0.8857064023763773},
{-0.18938139331012296,-0.1608668445185397,0.8819460169310482},
{-0.2113767376502481,-0.15172526600652306,0.8651849428578581},
{-0.21972060219720604,-0.17684964686720894,0.868169967093717},
{-0.2502134862789589,-0.18127595815610725,0.8473178730654535},
{-0.29001303328639644,-0.014312399550849323,0.6265308581537207},
{-0.29623222184644243,-0.00826004171350171,0.5705383696109632},
{-0.2640582242714835,0.02545420042621582,0.575643413009653},
{-0.23470276947149124,0.05673758039570199,0.5214030545273354},
{-0.19962989890617022,0.0813232831308294,0.5272333982766259},
{-0.16282352557673313,0.10127428169943811,0.5326516130947565},
{-0.12393671608915256,0.11678383430088557,0.5371745534833335},
{-0.08349138400229582,0.1278577619652729,0.5406275885393231},
{-0.04200560099516331,0.1344995573106608,0.5428384157717319},
{-0.041653079412238954,0.12835138531784865,0.6056240464425067},
{-0.04126749437834019,0.11269630696387295,0.6655725070419912},
{-0.04078562950656874,0.089072238401452,0.7213158554964204},
{-0.0401443848306284,0.0590217526073849,0.7714873139380491},
{-0.03928066038422292,0.024085094146430355,0.8147189402931122},
{-0.038131239780454025,-0.0141983073608672,0.8496451208998848},
{-0.0365710872927495,-0.05333577040460235,0.8783975169814001},
{-0.06881074608724909,-0.09434294831682005,0.8981086891098423},
{-0.09348213438546513,-0.13251831150544063,0.9138033504685057},
{-0.10024605494237472,-0.16191113731868217,0.9303257623075495},
{-0.1272838083973016,-0.16167538559958647,0.9130256608469949},
{-0.144561789943472,-0.15812304377007166,0.9036724296805012},
{-0.1605405175710704,-0.1609602138413618,0.8976208867873678},
{-0.17463905247600428,-0.17066328891693333,0.8929326291439187},
{-0.19166440131578566,-0.18496893607286533,0.8861127102774362},
{-0.20006880457579534,-0.1740822127365303,0.879236909521983},
{-0.21642939177802786,-0.20161370596463493,0.8736673479212229},
{-0.30477749403489945,-0.0078665400786654,0.4478974148223218},
{-0.2720586480424749,0.026840769796304686,0.4533901388257469},
{-0.24103954283957998,0.058330214231370824,0.3966816635805506},
{-0.23795439688598174,0.05684352314354254,0.45910289776699464},
{-0.26838907066672335,0.027325079500718597,0.5156425631392584},
{-0.30103457167987363,-0.007110970371538891,0.5104362338168088},
{-0.33630768568067343,-0.04724674007761762,0.4429972716831916},
{-0.20503414325205818,0.08425941071383874,0.4022756735077353},
{-0.2022633329239209,0.08211494322458293,0.464668966749694},
{-0.16478754113285396,0.10262592488892021,0.46971463564135235},
{-0.12532794228332234,0.11834736298604874,0.47387085113355837},
{-0.08437850898970783,0.12940964859023385,0.4770072221520465},
{-0.04243728858746301,0.13594317277574075,0.47899335762255163},
{-0.034474934353333035,-0.09083472989547177,0.9031112823787524},
{-0.06301777335120778,-0.12691377017059693,0.9207839297657793},
{-0.08087809074869506,-0.15579987065671116,0.936553100309737},
{-0.08339289217298472,-0.17652972305285092,0.9492522595783595},
{-0.0917889131496488,-0.18308082674926324,0.9436989968618827},
{-0.10929205214013082,-0.17114084622642994,0.9276189833105247},
{-0.12776462548365483,-0.17429013993174258,0.9154099547764173},
{-0.14257099764888595,-0.17037573002993758,0.9079846487794174},
{-0.1549919116786745,-0.16986604063428276,0.9023126370488775},
{-0.1618735334642289,-0.17881540873236013,0.9006454940279143},
{-0.1773027558502808,-0.19593645530700404,0.8939187116430498},
{-0.16710780373116388,0.10515458036485051,0.40719211553114865},
{-0.12712780479059135,0.1207421347696531,0.4111457591758354},
{-0.0856072120234541,0.13139461985471873,0.41406209525650084},
{-0.04306025522888582,0.1374869099585601,0.4158712714119316},
{-0.12960523520163175,0.12885432231858615,0.3508259168558987},
{-0.08738483819573681,0.13867905692327126,0.3535932345659753},
{-0.04398684680038349,0.14393544710459052,0.35524873552673636},
{-0.22224809346711613,0.0926533361196664,-0.2562344105537604},
{-0.21159793679409097,0.0312845441755064,-0.32003918717464075},
{-0.18485961712756616,-0.03870065294494644,-0.38580448673358136},
{-0.1735062800183246,0.012601365962923532,-0.3991043763086403},
{-0.1964306607625899,0.058312751141067425,-0.34201404148880993},
{-0.20643002627030885,0.11221432567149948,-0.2806497899481288},
{-0.2037465313936885,0.16361052884640573,-0.2198985045191567},
{-0.2480166295187929,0.07170461299172426,-0.23234937356984564},
{-0.2785933364340021,0.05021569827039733,-0.20747466833225742},
{-0.31496546091789496,-0.024409325523063213,-0.22871112497809837},
{-0.30883824463344683,0.029036462350450452,-0.18009056358631334},
{-0.17465185874222677,0.04614330561164765,-0.41958043179237087},
{-0.19446198838238812,0.08591724008664021,-0.3642142860884948},
{-0.20096407900534896,0.1313387379657479,-0.30531989761972256},
{-0.19491835714231662,0.17530614252559362,-0.24932240299107808},
{-0.17570546519053107,0.21218236821624428,-0.20231618787723912},
{-0.1858829542193446,0.20587353579264095,-0.16853884577122535},
{-0.15034207283389284,0.2323790142551206,-0.13534954412602762},
{-0.15751591033052392,0.23271197717690517,-0.09016484575143384},
{-0.15800604106503896,0.23581575042682704,-0.03516775335596935},
{-0.10775180757537216,0.24647172812995335,-0.022523311770297483},
{-0.10598756977232204,0.24427370716376715,0.03098941794937918},
{-0.10320581590759464,0.23745728091534538,0.08544049772135777},
{-0.14625687390892067,0.21902557120313126,0.13596005376303408},
{-0.20625539536727497,0.15097540090889564,-0.3299691660035543},
{-0.20400149251211794,0.10856221138605131,-0.39193985246017105},
{-0.1863404871852933,0.06961719159745947,-0.44924789380578367},
{-0.15014066519239377,0.04014997301952547,-0.4919160444470575},
{-0.10295434740722588,0.02013959994388528,-0.5222377902438371},
{-0.052335368171422356,0.009568609280235455,-0.5425031244379068},
{-0.19623507415119196,0.19084712868958717,-0.2733093545700034},
{-0.1743060895542197,0.22395714790480756,-0.22672422113161989},
{-0.1407781203777383,0.01912091967618773,-0.4649937802293369},
{-0.09761436723365441,0.0025484469782741655,-0.49936114194640113},
{-0.049935823143135064,-0.005873419372038908,-0.5215904916965917},
{-0.1408316738546687,0.2460852117312384,-0.19497726596694},
{-0.14270720975325235,0.23633149369378706,-0.17039598721468946},
{-0.09993730750581085,0.25037298250372986,-0.15074814789374757},
{-0.10381329860894845,0.24698863560293358,-0.11571649022154257},
{-0.10739497843017295,0.2465462373152478,-0.07234317999381805},
{-0.05441289381451521,0.2524615681040149,-0.062059748217163986},
{-0.05460021456316953,0.25062561521011884,-0.014419273663506002},
{-0.05383707751691155,0.246500833280459,0.03642975268189413},
{-0.05241616406922602,0.23853649989609466,0.08902625226365311},
{-0.09985232046633437,0.22440420301657424,0.13950273268258098},
{-0.31110146113676573,0.3597198687474133,-0.35681692103598034},
{-0.3432964144200887,0.3202404783955378,-0.458485868576275},
{-0.36630461799781017,0.2738305696052585,-0.5618091528713104},
{-0.34752597489156883,0.3714876631998552,-0.49633304208779394},
{-0.3167164267723145,0.4076106475954198,-0.3879955224636462},
{-0.2739784237698272,0.4390220902271308,-0.296647843395663},
{-0.267624187311435,0.3930441018703552,-0.27109119283966726},
{-0.3578757664113757,0.11616680511016592,-0.7609314579526624},
{-0.3851030526063954,0.18748257329113474,-0.7398907625491223},
{-0.37801885897332166,0.15443076437692566,-0.8065299151468442},
{-0.3386686954896913,0.09045298674143976,-0.8139994609726127},
{-0.35599906630677175,0.12821633741950245,-0.8585862231352184},
{-0.3804043171087642,0.19977309624665804,-0.8451885402544606},
{-0.38808225581215305,0.23413463693362105,-0.7802910398629962},
{-0.38365361611121424,0.27571309073996353,-0.6996895644647068},
{-0.3802110589094067,0.22730540441897681,-0.6584044905754612},
{-0.36289465856456893,0.14828841341421464,-0.6944063975449224},
{-0.32382041190773203,0.08451320762624795,-0.7143026784305805},
{-0.30934700266428544,0.06043509871593899,-0.7675115503789782},
{-0.2783733014961794,0.04253892377302871,-0.8067220091401814},
{-0.30200901211880254,0.07144615925523413,-0.8530923349257732},
{-0.31608309869731166,0.10890914478007857,-0.8963204686627755},
{-0.35775468898527224,0.1726238118549935,-0.8951353069341857},
{-0.3662510645208798,0.24713648976750224,-0.8770400527618168},
{-0.37371944614062796,0.2843270510836139,-0.816646865462606},
{-0.37044802722379355,0.32845395186823056,-0.7411027010161771},
{-0.3593415017908399,0.37828429794593316,-0.6500350134960583},
{-0.36998700163978415,0.3245096218717057,-0.6026343653825668},
{-0.27162207078489026,0.03926517644415392,-0.7252555286688642},
{-0.2485125812834091,0.0244355201585183,-0.7627336488719717},
{-0.2446334468240169,0.05944319518670663,-0.8776896797211028},
{-0.2553115444415275,0.09657787461384743,-0.9199957622900864},
{-0.3172647678078408,0.1526867837586275,-0.9308787601671568},
{-0.3451358599320453,0.2181198189193956,-0.9226513162222213},
{-0.33677918911886484,0.2914647981936179,-0.902217172155219},
{-0.3439052941686667,0.3341410982770333,-0.8500013679420737},
{-0.3437260064415519,0.3822449268267411,-0.7849455355318589},
{-0.3392391564396019,0.43084470714106515,-0.708503768243836},
{-0.3322096804894788,0.4801441752735448,-0.6421719660354537},
{-0.3413393841000891,0.4350090720754127,-0.543334367536348},
{-0.2217137229038325,0.01679367184175647,-0.7308204334455434},
{-0.2921912627502388,0.3262466172538825,-0.9212915235905976},
{-0.2980088002333069,0.37384750880285283,-0.8774242407484913},
{-0.30026619570652463,0.4430246305246669,-0.8239860202141092},
{-0.3157140453889001,0.4858557700087723,-0.7568788567962564},
{-0.3161704141488286,0.5276367956626341,-0.7059320371451574},
{-0.32440018650580443,0.5303482314837399,-0.6074425362460992},
{-0.32897784457733215,0.4976421917575378,-0.5235742987550563},
{-0.31574897156950693,0.4536165768966808,-0.416811949876274},
{-0.27767477788404393,0.47960165526811965,-0.32694874990468065},
{-0.3193475323780247,0.25914643907215107,-0.9401388548520324},
{-0.30710124925127,0.19747146094467172,-0.9549545406654253},
{-0.280047429753264,0.2901539022148437,-0.9523269276777757},
{-0.23269334988058157,0.3449740352952339,-0.9348347322238838},
{-0.2353966362595458,0.39371468453800523,-0.8959875057409911},
{-0.2701505143753249,0.5317918469488199,-0.8055880724764816},
{-0.29479675582350406,0.5469882281308266,-0.7739973421176559},
{-0.3009635551126399,0.5748453497827882,-0.7395554712152972},
{-0.3108430074002756,0.5745356709814082,-0.6731794291781462},
{-0.32371330495387124,0.573178206761825,-0.5939237759392377},
{-0.3293468978857437,0.5372333458873549,-0.5207825327185549},
{-0.3235037478702306,0.5220986676244201,-0.4435747178692236},
{-0.3162740284846287,0.4924521613193715,-0.4313284347424689},
{-0.28756820064392236,0.5079535644786773,-0.35410432100885436},
{-0.2871455938585804,0.23795905371006268,-0.9667363055901099},
{-0.24887464935569928,0.18538700245472842,-0.9754282677371153},
{-0.23570864347296627,0.22867334649274204,-0.9849817423390878},
{-0.2653935685766825,0.26612003313330335,-0.9680530225989852},
{-0.256067114148654,0.13995735513347912,-0.9531709770424395},
{-0.17933895217965562,0.13287432570642568,-0.9651110739858747},
{-0.17506282346736646,0.17931333964721066,-0.9865487636423117},
{-0.16808573678815353,0.22597588114387904,-0.9956912735191445},
{-0.22542986852039312,0.2690107566815239,-0.9813226428175182},
{-0.2268979323118978,0.30559243824905746,-0.9639433753475883},
{-0.3359002135735944,-0.9469162801987766,-0.25965938824466256},
{-0.27726846998298516,-0.9148482253716583,-0.3282258839088683},
{-0.27203652812809065,-0.9625818364069342,-0.26720123126428696},
{-0.335655730309347,-0.9639171807121332,-0.18725706658501698},
{-0.26739600293147076,-0.9805792972736043,-0.19017957295758972},
{-0.20117014347092893,-0.9686485139783307,-0.19247655143549514},
{-0.20912982003121236,-0.950765145301643,-0.2620304102254543},
{-0.2182222690491755,-0.9059024663122437,-0.31657951614433594},
{-0.21766810698354802,-0.8336250639585683,-0.3426636684480959},
{-0.2816482130310744,-0.836237542267955,-0.3578821695444869},
{-0.33635308971546224,-0.9019220459290918,-0.31811184410815707},
{-0.3900637344585773,-0.9033086152991806,-0.2517473277106063},
{-0.3935551883132343,-0.9180067163045308,-0.18522424645310082},
{-0.3807465936787106,-0.9109877182085897,-0.11963730325645885},
{-0.32732932885269245,-0.9536418983776207,-0.11522112055993651},
{-0.2647893456521853,-0.9699838582835296,-0.11253250317682716},
{-0.20512262290959532,-0.9599833285697903,-0.1213790718833186},
{-0.15906663274946461,-0.925022221782411,-0.12955529076336406},
{-0.14934434827455936,-0.9291982287769608,-0.19264221795217323},
{-0.1589746604738668,-0.9122031492937054,-0.253854773448419},
{-0.17852284375947738,-0.8858944216486437,-0.2944211829613792},
{-0.16452093795422226,-0.8331617099625185,-0.3062824631572453},
{-0.1543376278953076,-0.7486811001048369,-0.31058350587836725},
{-0.21270160410126498,-0.7407575139311803,-0.3492414324623714},
{-0.28408955305548783,-0.7370506819627815,-0.36594546044057047},
{-0.34530466980497804,-0.8282138343765589,-0.3482984255859885},
{-0.37637383586674267,-0.8781943630308707,-0.29693353955302637},
{-0.4238722772859331,-0.8312954877120966,-0.2558072633649396},
{-0.42870256806384976,-0.84219478447345,-0.18559632669716497},
{-0.4130439970918134,-0.8420492587209218,-0.11597319764900234},
{-0.36177003554903087,-0.8924686930448588,-0.07602905625385277},
{-0.32149782089738166,-0.9172872369840313,-0.05691279340174593},
{-0.26563106660480856,-0.9323578839158536,-0.04963999839339566},
{-0.21277727749257966,-0.9264087911525001,-0.06319135646882341},
{-0.17836800435878736,-0.9080620684797623,-0.08550918587655106},
{-0.13736233991439592,-0.8664812862613793,-0.12485585674212078},
{-0.12428015686511917,-0.8633041680321833,-0.18917043917925805},
{-0.13336212802890027,-0.8476258055578032,-0.2523820528328334},
{-0.12307054681010461,-0.7652628864509122,-0.2525031302589369},
{-0.11887358410719079,-0.6733383432999072,-0.24910865476576463},
{-0.14790073280947943,-0.6479155764362373,-0.3069126478759934},
{-0.20855470225722084,-0.634118570890542,-0.3452726541394218},
{-0.2835051216333345,-0.6275920319411564,-0.3621932244373829},
{-0.3544343734155884,-0.7331214866445196,-0.35816972843148265},
{-0.3966938877437629,-0.8223136382660547,-0.3141824159486911},
{-0.4405995893845367,-0.7378027590518474,-0.26272125007785624},
{-0.4461749720153978,-0.745980142137913,-0.18666250657048772},
{-0.43021720009616343,-0.7530666641830271,-0.10934735192609152},
{-0.394806709784977,-0.7624932403287951,-0.04565259277412248},
{-0.37901658353265516,-0.8427151845644909,-0.05873826844145992},
{-0.3287380181371656,-0.8560500003201568,-0.025692280557351982},
{-0.2713345118978945,-0.8692625744436986,-0.016883897808323927},
{-0.21592994739535099,-0.869562939596917,-0.03236550946528597},
{-0.16908578975952743,-0.8657140744940506,-0.06929994545694794},
{-0.1318905716193349,-0.7936439008119757,-0.11519376171846121},
{-0.11641489741307602,-0.7828132922058154,-0.1842798425294937},
{-0.11618147410602075,-0.6995702333476338,-0.18018917183622646},
{-0.11233912855686769,-0.6325538779993586,-0.18132974447424163},
{-0.11103044456953191,-0.5984507910488857,-0.2462571649604257},
{-0.13272996415991767,-0.5434164440607739,-0.30967600728560124},
{-0.3554216201207398,-0.6239771722483555,-0.35567716334217936},
{-0.4108867233363351,-0.7322716162497549,-0.3242985513202387},
{-0.44352058228928315,-0.6297597835508167,-0.26337157556075436},
{-0.45105532365218415,-0.6388603820109214,-0.18671221816755135},
{-0.4382583710778627,-0.6502800788633158,-0.1048781978556489},
{-0.4057968146159081,-0.6664904834889392,-0.036473992510662655},
{-0.35433425169784893,-0.6899632052687307,-0.00010419643881016353},
{-0.34202510144600207,-0.7776884573047816,-0.010457480576677784},
{-0.28065863791388257,-0.7919162190779606,-0.0017678468417127778},
{-0.21949474622928225,-0.7984415938213257,-0.01759289927464141},
{-0.16706239969637507,-0.7985789701317124,-0.05603498206249571},
{-0.1345344834912676,-0.7157946084454998,-0.10848257969426783},
{-0.1309906403657004,-0.6523628434334997,-0.11231875495151372},
{-0.2873621361783424,-0.9550482592500535,0.7630049088746843},
{-0.3397362724102383,-0.9297651971088109,0.6966172247773311},
{-0.28947051328097123,-0.9697254045470396,0.6995126051496325},
{-0.23155592059882102,-0.9683469846190922,0.7705699195941113},
{-0.23079685827363383,-0.9840043913851084,0.702484823119269},
{-0.23098778806095085,-0.9743973633062053,0.6339631493868418},
{-0.2845715343478613,-0.9603698449685053,0.6360203014245807},
{-0.33015369265776007,-0.9231525069139285,0.6388458294356687},
{-0.37223391925881993,-0.8637069833151814,0.6943120968572841},
{-0.33554396653140534,-0.9172383403311817,0.7547937638140321},
{-0.2865111015775574,-0.9158063669263039,0.8143184534221545},
{-0.23349315941647666,-0.9265030918401383,0.8252096007413664},
{-0.1813134455899585,-0.9179007735566902,0.8173605237530045},
{-0.1767602358448556,-0.9573999554109094,0.7673287700338027},
{-0.1730720311727804,-0.9730177791722379,0.7050204638313207},
{-0.17817823877749053,-0.9651104918828646,0.6418913923845792},
{-0.18391661025118328,-0.9350250799081908,0.5901831819962525},
{-0.23188189828448422,-0.9408146764467734,0.5780218859089743},
{-0.280433946151979,-0.9280037534002092,0.5839453661398829},
{-0.31456497404693734,-0.9064915545584777,0.6000125734250185},
{-0.35895498539212495,-0.862868754980619,0.6332238785639985},
{-0.375828987449277,-0.7851207485379027,0.6241919682590872},
{-0.39066446476501376,-0.780486044371384,0.6918463085064459},
{-0.3674688240180359,-0.854648296271805,0.7560941819386243},
{-0.3231358587678393,-0.895379208095423,0.7944314861846583},
{-0.29518560063425947,-0.8514653570125078,0.8412698227903807},
{-0.23684141593064595,-0.8575541544982883,0.8533927000789914},
{-0.17880341741035177,-0.8541686433914719,0.8436657587800053},
{-0.14629994953166903,-0.899700740842501,0.7997763560235147},
{-0.13159369908417734,-0.922752020042971,0.7624612246632388},
{-0.12563994949674284,-0.9375525711781009,0.7066142618730097},
{-0.13488374529733532,-0.9335931065033131,0.6497078716043749},
{-0.1510580595363317,-0.9183769338189627,0.610262243227086},
{-0.18212373298003562,-0.8841143506437187,0.5621374589690142},
{-0.233237034092027,-0.8845485994892629,0.5476768559917902},
{-0.28482649546629074,-0.8736493027279093,0.5547074961479335},
{-0.3292723887004493,-0.8626696757511603,0.5832247226133631},
{-0.34296577991034455,-0.7916740642257536,0.5689562136294765},
{-0.35381385160680806,-0.7060874586488576,0.5575504872493247},
{-0.38562810952151716,-0.695512975367147,0.6167852895584109},
{-0.3987277556610973,-0.6890353330706108,0.6884701110477913},
{-0.38573754488741835,-0.7743017819919449,0.7592841064340429},
{-0.34250591853235535,-0.8468492801423126,0.8084520192862369},
{-0.3060325081247028,-0.7692223511257,0.8499431576410625},
{-0.2406018013759751,-0.7707823871928025,0.8623955052333971},
{-0.17409886088261953,-0.7717056025668415,0.8530911707197529},
{-0.11960237707585211,-0.7765906110277089,0.822195471355002},
{-0.13132826011156587,-0.852803029729747,0.8137107378795968},
{-0.10467504390511953,-0.8649491911387625,0.7651493763639402},
{-0.09784499644626113,-0.8783946064663496,0.7067574592134974},
{-0.10983992749324907,-0.8809314113844214,0.6473130998207706},
{-0.13861386138613863,-0.8802678139528929,0.596034481453907},
{-0.17853099320161894,-0.8196883536904458,0.5475080461188573},
{-0.23634197154796907,-0.8149442141580259,0.5321370340338167},
{-0.2938118375303931,-0.8036095043451079,0.5387788293792046},
{-0.30345146337786233,-0.7241931906754084,0.5266315037641692},
{-0.39294747277067643,-0.6832212882056036,0.7567403162798496},
{-0.35840664435659864,-0.769552985635444,0.8156130505166456},
{-0.3116975346191213,-0.6762709782648557,0.8464202702238594},
{-0.2437754269871105,-0.675473497141001,0.8594966322430351},
{-0.1720673213773256,-0.6760160171464263,0.8524881120012759},
{-0.11283414895666768,-0.6836322529307431,0.8236169669056976},
{-0.0823366080508339,-0.7040559191435635,0.7711077827754557},
{-0.09019325237832737,-0.7900348621492757,0.7698713959819758},
{-0.08344667849111916,-0.8050007305392778,0.705976276973926},
{-0.0969381963771073,-0.81444942659943,0.6403616256740027},
{-0.1291418812055819,-0.8191039222682925,0.5839116041652963},
{-0.12420215506176405,-0.7486624728085133,0.5737539066388266},
{-0.17887443397758557,-0.7490606312674303,0.5360510946738157},
{-0.24248897933476105,-0.7413442737653742,0.5206067376095009},
{-0.36502515558158205,-0.6787414234397747,0.8124405891115304},
{-0.07620508420411094,-0.7268242962811186,0.7047922794513563},
{-0.09007007938138749,-0.7414711722215787,0.6345045051862469},
{-0.4126470028389164,-0.6243427329387062,-0.3234839563678868},
{-0.29236705785929296,-0.7115347786174937,0.008205906133561224},
{-0.2283904444298272,-0.722040573744011,-0.00756675702845726},
{-0.17243637468573714,-0.7229649533240702,-0.046703870810386315},
{-0.38055566389139356,0.6663368082942692,-0.3903029787957336},
{-0.30050020111659004,0.625201916981633,-0.379665628388931},
{-0.29380252388223127,0.6679469052202417,-0.3962672062373501},
{-0.3840075347413629,0.7037637034324868,-0.4066728796461279},
{-0.2935103081711546,0.7048755201818024,-0.4146011226438653},
{-0.20997503360189626,0.6729448416650706,-0.39387941968986717},
{-0.22425634885200554,0.6276758547746126,-0.3676789632046866},
{-0.24802827157899518,0.5829715078039639,-0.34930197117542316},
{-0.3116335032880089,0.584260283868354,-0.37207384093103885},
{-0.38005738371473696,0.6250365997267608,-0.3824993058421604},
{-0.4479771629347073,0.6280623711733276,-0.38855317714733434},
{-0.4525059243533855,0.665896738418624,-0.38993741810538274},
{-0.46500716859856955,0.7015074721652893,-0.4017704080949573},
{-0.4761637548903929,0.7308140303124323,-0.42418952342644456},
{-0.3824603049404829,0.7375780672899437,-0.43217714093121345},
{-0.2894809911351533,0.7326837451809148,-0.4315775748307972},
{-0.20813558808993957,0.7098210673557215,-0.4150109231629847},
{-0.4923171134210252,0.6096271688430528,-0.4176082667941084},
{-0.442771997818278,0.5939068949519444,-0.39869224737748044},
{-0.3799328136705728,0.5866550556519584,-0.38604082055568717},
{-0.4282438708918808,0.5693386553071205,-0.4214256983344286},
{-0.4675253462203179,0.587091632909543,-0.4445002616553031},
{-0.48582666485826664,0.6115364667162231,-0.48349650650878484},
{-0.5207365465807561,0.6374319012241045,-0.45037135261530153},
{-0.5010148965981318,0.6401340233970485,-0.4009845690313049},
{-0.4942916068313281,0.6659351572172916,-0.39687841439796867},
{-0.5208622808309404,0.6914929719793074,-0.4053712973155156},
{-0.5358688964316504,0.720416506345796,-0.4277438444061938},
{-0.5269068384879525,0.7404501635418407,-0.46202854749582195},
{-0.4766597066550091,0.7497405275832423,-0.45733097620421104},
{-0.41051883423394375,0.7548304363036693,-0.4640647438251968},
{-0.3532853020736256,0.7580808995121395,-0.47013142139659314},
{-0.322922809066138,0.7507033259619689,-0.4507473911598345},
{-0.271574338338061,0.7480640709141171,-0.44410676002046673},
{-0.21170853636601242,0.7368073629045544,-0.43085925971631794},
{-0.374147873956071,0.5451895298295778,-0.43742538167039113},
{-0.3776055658361415,0.5579841539918587,-0.4037064827065927},
{-0.3252337580162861,0.5527382416647214,-0.38077395252018587},
{-0.33700388088076844,0.5362833537748507,-0.4103995031168705},
{-0.3426467874608027,0.5405385267787759,-0.4655851968876117},
{-0.37063546439304995,0.5544356540422106,-0.489128935234637},
{-0.4126877500496243,0.5597292988161772,-0.457078343497822},
{-0.44163689694855784,0.5770014593322463,-0.46931531297641493},
{-0.44308633344373893,0.5892640413432843,-0.5071054403929428},
{-0.4884682483181589,0.6406334677797253,-0.5261483582657754},
{-0.5287649112962328,0.6704895311684147,-0.4895561988440599},
{-0.5489836772494935,0.6986959146264441,-0.45314332714945904},
{-0.5359271067326616,0.6671098410916995,-0.4229508082209244},
{-0.5364568204718644,0.7246018269885076,-0.4902570508682358},
{-0.5031640209114686,0.7483690928914162,-0.4930441600806562},
{-0.46880830125460665,0.7569807248230261,-0.49623874140015567},
{-0.4141674559013312,0.7613872446095805,-0.49891175842259394},
{-0.36226249469558636,0.7628506515770044,-0.49620614363158927},
{-0.3256319164752033,0.761400050875803,-0.492728660249175},
{-0.3086345085799073,0.7595524559217047,-0.4775974746043009},
{-0.28364715476780206,0.7560551810369466,-0.46274686261030124},
{-0.25118792671788787,0.7558514449834073,-0.4546311824433076},
{-0.2136655666860119,0.7524065593695591,-0.44121137964816526},
{-0.27834070372761305,0.5477892018727419,-0.3516385326580162},
{-0.34278765638924996,0.5627981458854922,-0.5309763206316517},
{-0.33805283050499185,0.6003542678919547,-0.5912228179723141},
{-0.36719057877920197,0.5802868487213235,-0.5453880269560262},
{-0.30642368134749864,0.5261559256049069,-0.380970703337604},
{-0.400448452158991,0.5956508755702425,-0.555247687741318},
{-0.44129578458463165,0.61404765910185,-0.5517643833288026},
{-0.397890691532555,0.6294582541915782,-0.5920249559202496},
{-0.43760292308847565,0.6450562864505629,-0.5831117946294012},
{-0.48076818970038576,0.6723429471526141,-0.5601850854730955},
{-0.4044020958036776,0.5704539646744967,-0.5059761605533238},
{-0.3639377871586912,0.6173051075464417,-0.5927781972153358},
{-0.36392381668644846,0.6587985743133078,-0.6184617462275359},
{-0.40174304925348203,0.6669689721632521,-0.6091143360911434},
{-0.4328110511092264,0.6699283838666658,-0.5951904320892433},
{-0.458397971021748,0.6965840449057545,-0.5848336553333151},
{-0.48637384168777276,0.7251082566073058,-0.5576075333443157},
{-0.517136821566218,0.7019731545733795,-0.5277363352773633},
{-0.3328232170621378,0.6445254085053399,-0.6276636306114003},
{-0.33147972331479725,0.6866312476388448,-0.6216377002507119},
{-0.37020121554750574,0.698076557023684,-0.6096044668256584},
{-0.4170244174749652,0.7032782295220528,-0.5993221992550245},
{-0.436996371751938,0.7331203224384994,-0.5718644002680002},
{-0.4549228160513741,0.7512318754951512,-0.5359602866042381},
{-0.5034143252058171,0.7427913818485147,-0.5219700228591853},
{-0.40044612374695054,0.7546220434260488,-0.5352629271981229},
{-0.34944924323698173,0.7576652779629189,-0.5229130297355681},
{-0.3075180350065108,0.7595105445049767,-0.5052287402883389},
{-0.32480765861288347,0.7483795707455984,-0.5463426758926113},
{-0.2869104242424948,0.7550132166488447,-0.5209804477419933},
{-0.2982975233263229,0.7408483220007579,-0.5625786930506796},
{-0.2699817045023922,0.7518349342136282,-0.5349707114870461},
{-0.2734393963824626,0.7385350446385694,-0.5778321203276774},
{-0.25542563663150963,0.7522179579942826,-0.5512812378304089},
{-0.05298208461565776,0.25356174279312815,-0.10502535349660544},
{-0.05140831091751659,0.2569262981915806,-0.1405595989077419},
{-0.0507920966710111,0.2655530648014534,-0.16590459680926053},
{-0.052233732985856644,0.2824422015368684,-0.17830257598045063},
{-0.09869789377667852,0.2592721733223355,-0.17554515402154594},
{-0.10183915446045164,0.27646400362300916,-0.18813057036199238},
{-0.14618818575372736,0.26398255088016886,-0.20843409051352543},
{-0.05063038845480174,0.2251795642260446,0.14190332549628648},
{-0.0963729743542877,0.20349389868729953,0.19185242058805213},
{-0.09298827819168537,0.17923300943181508,0.24398556617376124},
{-0.08991873259875816,0.1561270125483946,0.2973993383817187},
{-0.0721638922667033,-0.6145668949868707,-0.16113193422934508},
{-0.10695700412536403,-0.6227803684595633,-0.13429884819277388},
{-0.03633975955653065,-0.6152444628906422,-0.1795269714519221},
{-0.0337651179428014,-0.5934738103124206,-0.21821401482849206},
{-0.06561814391798403,-0.5918159809396191,-0.20647042421921066},
{-0.09364710237853112,-0.6007396200846494,-0.1921329942389265},
{-0.030935980893050795,-0.5661498950177222,-0.25799725130958623},
{-0.061119535435229695,-0.5622148786693592,-0.25252944131499394},
{-0.0897983536962668,-0.5671965162299051,-0.24800673376762097},
{-0.09097012705562403,-0.5260266987366619,-0.30045200298735264},
{-0.05852289032771818,-0.5275029119703081,-0.2987180345408284},
{-0.02862433341929055,-0.5340050025932689,-0.2992454198679907},
{-0.027602160533532337,-0.4977737470378233,-0.34232721290825063},
{-0.0576829156841253,-0.4894170762246429,-0.3444449036590413},
{-0.09272120933064558,-0.4811081378582917,-0.34800038884481077},
{-0.027750829642315164,-0.4558262399230693,-0.3840581777032427},
{-0.05844547062737316,-0.44686418197937144,-0.38694540863340254},
{-0.04877266490832751,0.20487697543932773,0.19359872961839075},
{-0.04696488580012096,0.1817942626763117,0.24547807829169066},
{-0.045328943500499735,0.1600922982532835,0.2989058209718909},
{-0.19693592617536787,0.3728125296508721,-0.20657194298417436},
{-0.1786334433313988,0.3292910159967728,-0.2071132987835793},
{-0.16025295868407466,0.2923658936532727,-0.21010670530278377},
{-0.21076785790167002,0.4209862105617934,-0.2156006633645903},
{-0.2157366891959935,0.4718666704697396,-0.2413176716578119},
{-0.2231049490980023,0.5143485481477773,-0.27684574677704116},
{-0.150105739011787,0.564777296119876,-0.2533917687141752},
{-0.11496138619682417,0.6383981922208918,-0.2939532885618505},
{-0.05871393653563722,0.6496397655521917,-0.2618503075541254},
{-0.24947305125009533,0.6064954546486456,-0.7856056403453269},
{-0.2766316492899216,0.6077586181805906,-0.7682810905583474},
{-0.28662752217958,0.6096097057527495,-0.7474709079468121},
{-0.2966059319789349,0.6141710649399938,-0.7110335879257865},
{-0.30754714015701645,0.6269424049818705,-0.6518884294802577},
{-0.2327306044732288,0.6718237112675934,-0.759692742747142},
{-0.2613654157467014,0.6616858052434674,-0.7481461474385431},
{-0.28050729113125317,0.6447291445588794,-0.7322687057347043},
{-0.28701054596023423,0.6566692415023148,-0.6845502293776912},
{-0.3006399058390171,0.6812013907605118,-0.6367374523330397},
{-0.27746289238836286,0.6940472399876827,-0.6562192758754974},
{-0.29101192205175014,0.7160705252722933,-0.6080700432910008},
{-0.2667743169166702,0.7241699065550038,-0.6271164537818942},
{-0.25375500099248566,0.744902087363184,-0.5983128326354888},
{-0.24193830988719428,0.7584080414038229,-0.5739948972850133},
{-0.21853427626259597,0.7239778125616665,-0.7301661496621765},
{-0.24785480488198153,0.7060606819103922,-0.7200387214922327},
{-0.26881400586410575,0.6842760588599279,-0.7049750597965317},
{-0.2571649604257269,0.7160705252722933,-0.6756009777002158},
{-0.2459990604857417,0.7403651765023642,-0.6464154969791764},
{-0.23575521171377528,0.7574114810505097,-0.6196876551668336},
{-0.22764418837086248,0.7686984584165983,-0.5981428585565359},
{-0.1621482860850022,0.2706522871700422,-0.9914314436911386},
{-0.06441528625788677,-0.34254666574306325,-0.45062631373373097},
{-0.06065606501857782,-0.3987533681935423,-0.42345490942768216},
{-0.02895194099338207,-0.4065360854387514,-0.42125339584343524},
{-0.031087094834476102,-0.34827106674451325,-0.4507299280695311},
{-0.03403754215153422,-0.2794047880300994,-0.46930250671019247},
{-0.06982337248364145,-0.27570610550384217,-0.46511485765544036},
{-0.03747241559360828,-0.20675204565550329,-0.4805568863077148},
{-0.07626201387849997,-0.2042458593557633,-0.47096615711309503},
{-0.12714992470497563,-0.12666310031555805,-0.4458088292220368},
{-0.0892552515878315,-0.07292481732152285,-0.47452629912294536},
{-0.08311290062512043,-0.13417756120958677,-0.4722223354089186},
{-0.041060382127342025,-0.13712669297384203,-0.48807882140439335},
{-0.04447045798118527,-0.07734391053309575,-0.4954529023365033},
{-0.04737165938358784,-0.03421857618767932,-0.5062660478523601},
{-0.09356851847216588,-0.027911024390698234,-0.4835139695990882},
{-0.13466836718359354,-0.06208245023455841,-0.4399866349148878},
{-0.13741589339132632,-0.014221940743077782,-0.44703240974929404},
{-0.17889771809799007,0.08971138750655593,-0.9328043569246102},
{-0.09542251655937538,0.69687043958673,-0.3352101886654066},
{-0.046977692066343446,0.7100131613490587,-0.3049603908006769},
{-0.19927132345194074,0.5790388198676414,-0.3102311007160449},
{-0.24413516664736026,0.5373241539569326,-0.31530773748784136},
{-0.1662765606327227,0.6315759449423689,-0.3341691556421207},
{-0.14680172232638636,0.6835507585093274,-0.3691889384129194},
{-0.08984038153359694,0.7400892596755706,-0.3709480537094805},
{-0.043371563918694185,0.7533053264171734,-0.34509569482434754},
{-0.23402170894965915,0.9720037557286214,-0.5139917190025781},
{-0.24940087047684134,0.9409590379932814,-0.5077003496692781},
{-0.23172589467777396,0.9529503600016066,-0.4966927817480437},
{-0.21046865695447198,0.975581360828775,-0.5060576549747396},
{-0.2093254066426103,0.9575757505199636,-0.49142940633060306},
{-0.2232190412879844,0.9242061133622329,-0.48693440688651146},
{-0.2435856614058137,0.9130867816630567,-0.49852640622989924},
{-0.2582045964017885,0.9279071243005305,-0.51931330472103},
{-0.2636181543958382,0.93636158841941,-0.5352734050523049},
{-0.2525919591782801,0.9586002518177622,-0.5253043089011118},
{-0.23095635449840476,0.9807527639706178,-0.5352734050523049},
{-0.20658835828905955,0.9840043913851084,-0.5244171839136997},
{-0.18141938833779905,0.9750097356728441,-0.5158148656302517},
{-0.1861053175692077,0.967752075342757,-0.5002552521699345},
{-0.19094725040732657,0.9557060356514809,-0.4914573472750885},
{-0.19931090645662838,0.9318712457993992,-0.4823288078704984},
{-0.2108807858856319,0.8900552939649305,-0.482213551474496},
{-0.23484945943003965,0.8787380472423162,-0.49434923502932926},
{-0.258119609362312,0.9049629520539215,-0.5162316513854924},
{-0.2645332203277357,0.9062796690627968,-0.5391769878381218},
{-0.2624527841695922,0.9114487437925991,-0.5630769732273363},
{-0.2625284575609069,0.9429847564684743,-0.5564375062939888},
{-0.25081654499743583,0.9665820482924299,-0.546558054006353},
{-0.22338319433683623,0.9785826839489169,-0.5569835189174747},
{-0.20153453995525958,0.9809646494662988,-0.5447092948462345},
{-0.17893846530869797,0.971903634010882,-0.5344864017826323},
{-0.15835297445906624,0.9506836508802272,-0.5309390660390044},
{-0.15915394820098155,0.9524381093527073,-0.5112954178597353},
{-0.1651053693763756,0.9469372359071407,-0.4953353175284605},
{-0.17791978504100042,0.9386073418324254,-0.485023944807321},
{-0.18478743635431213,0.9010023231731134,-0.47755789159961326},
{-0.17011844049946767,0.867505787559178,-0.47591868952313543},
{-0.197096586606159,0.8547856725821914,-0.48002950098055247},
{-0.22289655622038188,0.8416627423222068,-0.4917367567199427},
{-0.2521123062979471,0.8710938705135138,-0.5136261583122272},
{-0.2580928326238468,0.8711672154927882,-0.5397043731652841},
{-0.25443838992635814,0.875860129960318,-0.5671400522379241},
{-0.2515104117854904,0.9148819873462447,-0.5836450009866646},
{-0.2524720459581969,0.9435948004230725,-0.5751299981547334},
{-0.24172875280355366,0.9654772167792358,-0.5666836834779956},
{-0.212221951220932,0.9650429679336917,-0.5755595901761967},
{-0.19315574922769485,0.9673061844370104,-0.5620606213716792},
{-0.1785659193822257,0.9629415760671841,-0.5495919748950614},
{-0.16447669812545368,0.9462899373598952,-0.5518447135441982},
{-0.14766905581145454,0.9185084890992479,-0.5540241072140608},
{-0.14001207281642974,0.9215575446662193,-0.5311136969420382},
{-0.1398921595963465,0.9217752511920014,-0.5097435312347743},
{-0.14696354696319772,0.9178146223111936,-0.49222921586649815},
{-0.16175245603812544,0.9105860671316117,-0.48076760759737563},
{-0.14659798627284684,0.8781524516141427,-0.47974892732967817},
{-0.13415844494673468,0.8492475445439777,-0.47976871883202193},
{-0.15754850809909024,0.8383924876113926,-0.4749256217878829},
{-0.18463725377770304,0.8249365944296234,-0.47759398198624026},
{-0.21111246288365682,0.8101546705908171,-0.48739659667654106},
{-0.2415413156342973,0.8330452893604959,-0.5114409436122636},
{-0.24705499534608646,0.8338404420723101,-0.5395437127344929},
{-0.24233413993407102,0.8401038704611246,-0.5692891765512609},
{-0.2302752939765727,0.8478912445304145,-0.5939214475271973},
{-0.24279516551808045,0.8820700048722022,-0.5904882039735516},
{-0.2352720662153816,0.9199299846499437,-0.5963476528733478},
{-0.2397158405945833,0.9398751621884512,-0.5860840125990375},
{-0.22925195688479427,0.9537699610398456,-0.5839558439940649},
{-0.19838885528860958,0.9396807397830734,-0.58743798420056},
{-0.1793005333809882,0.9438753740739468,-0.5715908118532472},
{-0.16320771356340763,0.9139762350625091,-0.5761649773067141},
{-0.14811611092322122,0.8809116198820777,-0.5786470645418355},
{-0.13231667102273753,0.8861540395911542,-0.5556633092905386},
{-0.12414860158483366,0.8887793241667631,-0.5320520469943403},
{-0.1237294874175524,0.8885092283700707,-0.5100438963879926},
{-0.13117342071087584,0.8850608501381622,-0.491867147794208},
{-0.23177479133062348,0.7741259868828908,-0.5488655103384406},
{-0.24447860742332683,0.7607446028864161,-0.5336761143925551},
{-0.2384945884793665,0.7676786139428805,-0.5223472256097383},
{-0.23193428755539441,0.7840915904160233,-0.5430386592072106},
{-0.23537335213914126,0.7765847899976077,-0.5146285396956417},
{-0.24224333186449343,0.7637005219717691,-0.5027443246411772},
{-0.2526001086204217,0.7585046705035017,-0.5157450132690381},
{-0.2348599372842217,0.7668578486986214,-0.5583479683731792},
{-0.22159963071385042,0.7823324751194621,-0.5767086615181596},
{-0.2239781036131716,0.79242963393288,-0.5726583887737942},
{-0.2366050821085401,0.8021856803823719,-0.5401653987492935},
{-0.23255131674611404,0.7939314596989713,-0.5063440496557152},
{-0.22412828618978073,0.7794440799832821,-0.4864105141774098},
{-0.2349996420066488,0.7702619871017616,-0.49380671502390405},
{-0.24784781964586017,0.7611741949078792,-0.4876573788250716},
{-0.2631978760225367,0.758553567156351,-0.501660448836347},
{-0.2802406879526215,0.7593068084514372,-0.48852587651616003},
{-0.22287327209997737,0.7757139638944789,-0.5845100060596924},
{-0.2074859611306536,0.7915937340103579,-0.600288490251812},
{-0.21080045567023634,0.8012496587421104,-0.5971090436105755},
{-0.23066995981742924,0.8102652701627385,-0.57072813519226},
{-0.20288385473270124,0.7925041431181745,-0.47803521606790583},
{-0.21955761335437443,0.7719209806805833,-0.47170892055399904},
{-0.2350415534233769,0.7650498367492109,-0.4782389521214453},
{-0.2397239900367249,0.7608796507847623,-0.4655945105357735},
{-0.26013484998332276,0.7590856093075944,-0.4746869595537366},
{-0.2076442931494043,0.7861848328403892,-0.6069093298888358},
{-0.18928942103452515,0.8012182251795642,-0.6144114734831705},
{-0.19304747806781383,0.8102722553988598,-0.6115964233262646},
{-0.2181954923107103,0.8188000644970135,-0.5955816053120393},
{-0.21067006459597104,0.7813789903888971,-0.6187586187626936},
{-0.18830217432937368,0.7971435041087741,-0.620293042297351},
{-0.1639714327126757,0.8074595336539945,-0.6194082457219795},
{-0.1668644846729367,0.8105155744570871,-0.613882923949988},
{-0.17136064832304854,0.8192156860462343,-0.6113263275295723},
{-0.1789535999869609,0.8365227727429101,-0.6101248669166993},
{-0.20051236706950135,0.8276119398641024,-0.6102180033983174},
{-0.19617220702609975,0.7835292789082543,-0.46636521492116284},
{-0.1762782545524821,0.8070474047228345,-0.47211755686709833},
{-0.16905435619698134,0.797462496558316,-0.46423588211017},
{-0.18894132343447761,0.778045868552991,-0.45509570064537763},
{-0.21674605581552925,0.7665726182236661,-0.45961049159181305},
{-0.14932339256619528,0.8206767646016176,-0.47209660115873425},
{-0.1423707542134071,0.8113095629628813,-0.46734896900825357},
{-0.1600014901837059,0.7925274272385789,-0.45458228579045806},
{-0.17886628453544395,0.7731585316800831,-0.44405320654353636},
{-0.21501022463937264,0.760899442287106,-0.44961345449613455},
{-0.14608457141792727,0.7891570508100255,-0.4430694524564456},
{-0.13361941755937015,0.8072429913342324,-0.46060355932706565},
{-0.1199958787106884,0.8054279941487007,-0.45178004189977466},
{-0.11211571742158635,0.8197547134335986,-0.4725459846825414},
{-0.10050241310802843,0.8193425845024388,-0.4674409412838515},
{-0.09781426140732716,0.827625910336345,-0.48979718949024653},
{-0.08751045602531915,0.8282720446775703,-0.4873069528129837},
{-0.09091506011086735,0.8314119083141192,-0.5110555914195688},
{-0.0814320199731185,0.8327868356240057,-0.5105596396549527},
{-0.09161847338828775,0.8316668694325485,-0.5350207723459158},
{-0.10012521035747528,0.8289461199632809,-0.5603899857326552},
{-0.11663598013631689,0.823804986177964,-0.5858639776612148},
{-0.10880133930260566,0.8255594446504442,-0.5924626973838544},
{-0.1387256251640803,0.8165426690237959,-0.6070129442246359},
{-0.13250294398597365,0.8176149027684237,-0.6162148286085002},
{-0.16118432350025524,0.8070811666974211,-0.6295217034196806},
{-0.18914156686995645,0.7947417470890484,-0.6308733466091626},
{-0.11972461870797581,0.8229458021350375,-0.4762481598268593},
{-0.10471788668666385,0.8302465380878732,-0.49148179560151317},
{-0.09740888487108457,0.8337042299679436,-0.5113769122811511},
{-0.0978561728240553,0.8338125011278247,-0.5342652026387894},
{-0.10611807726718936,0.8310626465080515,-0.5584760310354041},
{-0.12225327418390615,0.8259471252551795,-0.5823387618319713},
{-0.1434418237520148,0.8189409334254608,-0.6020697254627573},
{-0.14866445195874753,0.8274885340259582,-0.5998542414062678},
{-0.15640642199324878,0.8448689657019085,-0.5988367253445905},
{-0.16868064606448885,0.8737587380938105,-0.5974850821551083},
{-0.19114050860668405,0.8654020672806302,-0.6086579673312148},
{-0.21262825912199076,0.8565436236727325,-0.6086428326529519},
{-0.22550903452976848,0.8897549288117125,-0.6047322646310137},
{-0.20492354368013674,0.8988706619500801,-0.6048568346751778},
{-0.21730487470523757,0.9299479774539863,-0.5966515106446266},
{-0.18337758286381875,0.9075626240970855,-0.5942148274442942},
{-0.13576272084260574,0.8519857571035485,-0.5798869439533759},
{-0.11991205587723215,0.8572107137223217,-0.5568100522204611},
{-0.11174258939210402,0.8598790739206791,-0.5331405796232513},
{-0.11133872632368769,0.859661367394897,-0.5109962169125373},
{-0.11878277603761317,0.8562281238412511,-0.49249931166319055},
{-0.11083590574355219,0.8388686478736651,-0.49237590582504664},
{-0.126135901261359,0.8318112309790566,-0.47862896113822095},
{-0.10339092466481054,0.8422576515985422,-0.5113990321955354},
{-0.1037712707716183,0.8423868784667874,-0.5337587730199911},
{-0.11194620902504149,0.8396661289975198,-0.5575155610687178},
{-0.12788570290975831,0.8345028752978186,-0.5807321575240598},
{-0.3234839563678868,0.7207215283230952,-0.5932427154174057},
{-0.3725808526528471,0.7348596462327166,-0.5760019884638825},
{-0.12426851480491692,0.7842685497310976,-0.42960890245059546},
{-0.163622170906608,0.7659695595051893,-0.43306310171260526},
{-0.09842791440058817,0.8028178442513544,-0.4407992507170054},
{-0.0820772229495276,0.8188117065572158,-0.4608538636214141},
{-0.07016215643552715,0.8021309626994214,-0.42824445299489083},
{-0.09178064728690519,0.7751900711853772,-0.4054167013503044},
{-0.14942817110801562,0.7512027703446458,-0.41865488800629136},
{-0.058173162839242364,0.8193041657037714,-0.45338897461972666},
{-0.07119189666041682,0.8294478927579984,-0.48399478668544144},
{-0.05021406838196901,0.8311848881401752,-0.48028562630500216},
{-0.0364441888365449,0.8060880989621686,-0.4146965875375238},
{-0.04186927247019487,0.7838762123022814,-0.3818194095263486},
{-0.14250347369971286,0.723577325690709,-0.3973569030722815},
{-0.041007760015227816,0.838563625896366,-0.6186969158436215},
{-0.050994202836122285,0.8261985937555483,-0.6606374377222541},
{-0.07538979072814685,0.8330790513350823,-0.6136139923593159},
{-0.10445198203164428,0.8188617674160855,-0.6561843496948907},
{-0.057524001562364487,0.802428999440599,-0.702640826725979},
{-0.09652024641584624,0.8286981440809729,-0.6032909775779741},
{-0.12276086800872456,0.8194764681947648,-0.6312051453249271},
{-0.15617590920124408,0.7988735142548297,-0.6693782965221092},
{-0.11276126965980156,0.792760268442624,-0.7006395565772111},
{-0.16342542008918984,0.7778467893235322,-0.7011459861960092},
{-0.20549749724810804,0.7591601184928889,-0.6993391384526189},
{-0.19561222393037117,0.7803952363018064,-0.6707113124152676},
{-0.22391523648807943,0.7599995110334716,-0.6620018871779587},
{-0.23496005900196112,0.7381718123602589,-0.6903992004233053},
{-0.1570071522996853,0.8064187334719127,-0.6458403792051849},
{-0.19086924860397148,0.7907077732289661,-0.6477846032589619},
{-0.21595672413381617,0.7735264207824745,-0.6376222489084113},
{-0.02440001187490141,0.8408466339020285,-0.5084815319088496},
{-0.04712065656562717,0.8381375264929632,-0.5093453727758571},
{-0.06648256688800164,0.8352398177086214,-0.5100147912374869},
{-0.14581098300317422,-0.18302378065427213,0.9075841619084597},
{-0.127889195527819,-0.18640149158075311,0.9153424308272441},
{-0.1112979791129798,-0.18176550678761216,0.9266189303391508},
{-0.10954608189374408,-0.1920616284098867,0.9255140988259565},
{-0.12502990554214455,-0.20231257883857645,0.9141432986264116},
{-0.1556706437884661,-0.20103614335800093,0.902691004005451},
{-0.1735423704049516,-0.2293817658560494,0.893527538420254},
{-0.15035022227603442,-0.26964990578662784,0.8986861352958744},
{-0.11135898350843962,-0.2702564571231655,0.9104550939543364},
{-0.07352286995411282,-0.26954279883276705,0.9190504270016632},
{-0.036546522545722736,-0.26813760216635457,0.9243172950371644},
{-0.13942298457019553,-0.23230788126728483,0.9057773141650693},
{-0.10462381884022962,-0.2347180205703562,0.9163098860300518},
{-0.03171774523563239,-0.1242028885115568,0.9259192425209951},
{-0.055437627953517914,-0.15231086163469662,0.9436524286210737},
{-0.06782640989714822,-0.17326715210177024,0.9568079566496247},
{-0.0696673688769312,-0.18866051694239916,0.9635370674465294},
{-0.0759770162447487,-0.19405672826674755,0.9575181223219624},
{-0.07757651889593688,-0.20122008790919663,0.9530126450236888},
{-0.09421884395506397,-0.19125704562930868,0.9397674731315804},
{-0.034742818158586986,-0.2353193329798028,0.9299066481402684},
{-0.03187409810414871,-0.21481091256871,0.9356438554079407},
{-0.02826191608519427,-0.2107616876097628,0.9428316633768146},
{-0.02438732202928095,-0.2170134739383751,0.9512896201137547},
{-0.020730900181557932,-0.22740797096935866,0.9608593936000103},
{-0.017773584048980474,-0.23578711095872948,0.9713372477820421},
{-0.01599619071790182,-0.23599259332129932,0.9825601938170182},
{-0.015399185870730057,-0.22977072708740684,0.9921183252430718},
{-0.01598350087228136,-0.21886770486678864,0.9975784514779306},
{-0.01774971782556585,-0.20502960284857932,0.9965306660597273},
{-0.020698302412991608,-0.19000261364251542,0.9865534204663926},
{-0.02433737759101326,-0.17242822524359555,0.9699285584975689},
{-0.028174484213075314,-0.15094792564681833,0.9489495660131009},
{-0.06341826022216544,-0.21456642930446257,0.9304025999048844},
{-0.06958459382889315,-0.23594427877145996,0.9245478078291691},
{-0.09430289962972428,-0.21166511148145797,0.9229935927921677},
{-0.0812195523744273,-0.20660943041802565,0.9314142949364606},
{-0.05563228320009966,-0.20985546964361906,0.9377976365453584},
{-0.09188717213775584,-0.19939472929008464,0.9370851424609803},
{-0.10064898664597485,-0.20076453409348227,0.9264105374615305},
{-0.08355285408016375,-0.20657857895848966,0.9370094690696655},
{-0.07601636640823232,-0.20779133236975883,0.949042702494719},
{-0.06973465998490025,-0.21394625675748832,0.9476223711500437},
{-0.06797461332352296,-0.2118936451232283,0.9408967529711995},
{-0.06146425683781854,-0.21074853208173425,0.9655977121023291},
{-0.06115294814801017,-0.21650553085175062,0.960219080288886},
{-0.060300167238194806,-0.2191504905091015,0.9559930124354667},
{-0.05716915156739968,-0.21986065618143918,0.950765727404653},
{-0.0474777185520304,-0.21536379400771521,0.9464348810094133},
{-0.06112186384727015,-0.2033214797757041,0.969847064076153},
{-0.046488841958450655,-0.2101274281699438,0.9814774822182084},
{-0.04597554352413312,-0.21893639302198198,0.9767857319566987},
{-0.04651596795872191,-0.2247911850976973,0.9694628760894786},
{-0.04971299411086385,-0.2257474639227107,0.9604752056133359},
{-0.04020597132909834,-0.2246443787185468,0.9560046544956688},
{-0.04014717892507694,-0.18843978348096435,0.9805810435826344},
{-0.0496611869429638,-0.1993001957612423,0.9808022427264775},
{-0.03460241491254776,-0.20226426428873706,0.9902090273699014},
{-0.031601673895415884,-0.2151009162883482,0.9911403921860822},
{-0.06024870933210083,-0.1970615440049502,0.971744719889121},
{-0.05709720363534972,-0.18739025175373084,0.9720706975747843},
{-0.047378295357903125,-0.17224823899286867,0.9643636537208897},
{-0.03464525769409206,-0.231973521298276,0.9662496674736556},
{-0.031624143071606235,-0.23162728642786087,0.9768788684383166},
{-0.03074295553489737,-0.22540379030554006,0.9858665389144593}
};


// texture array: 25kb.
const tgx::fVec2 spot_tex_array[3225] PROGMEM = {
{0.789584,0.668215},
{0.799923,0.663933},
{0.800375,0.667457},
{0.79029,0.672484},
{0.80103,0.671718},
{0.811217,0.666381},
{0.810842,0.6624},
{0.799641,0.661178},
{0.789057,0.664897},
{0.778915,0.668524},
{0.779732,0.673035},
{0.780606,0.678305},
{0.791163,0.677558},
{0.801925,0.676679},
{0.811842,0.670848},
{0.822041,0.665116},
{0.821717,0.660492},
{0.810548,0.658683},
{0.799442,0.658809},
{0.788653,0.662549},
{0.778165,0.664791},
{0.768389,0.668485},
{0.769427,0.673433},
{0.77033,0.678903},
{0.781583,0.684283},
{0.792268,0.683394},
{0.803066,0.682261},
{0.812703,0.675707},
{0.822539,0.669852},
{0.832855,0.663756},
{0.832622,0.658487},
{0.821466,0.655998},
{0.810346,0.655189},
{0.832389,0.653218},
{0.821251,0.651569},
{0.756532,0.663039},
{0.747747,0.667793},
{0.74577,0.661865},
{0.755019,0.658037},
{0.743793,0.655937},
{0.753496,0.653114},
{0.741816,0.650008},
{0.758027,0.6682},
{0.759367,0.673605},
{0.767347,0.664111},
{0.76625,0.660042},
{0.765177,0.656219},
{0.760412,0.679339},
{0.771295,0.685081},
{0.782707,0.69092},
{0.79352,0.689825},
{0.804461,0.688386},
{0.813905,0.681083},
{0.823312,0.674685},
{0.832962,0.673545},
{0.833088,0.669026},
{0.777492,0.661858},
{0.788538,0.66243},
{0.776857,0.659324},
{0.85437,0.658994},
{0.861885,0.655612},
{0.860743,0.66105},
{0.858253,0.665619},
{0.86356,0.668573},
{0.867109,0.663417},
{0.868881,0.657298},
{0.870052,0.650753},
{0.862482,0.650015},
{0.85471,0.654338},
{0.870421,0.644717},
{0.862589,0.644612},
{0.85505,0.649682},
{0.876218,0.659429},
{0.885992,0.655087},
{0.883125,0.662497},
{0.87346,0.666407},
{0.879453,0.669777},
{0.889995,0.666526},
{0.89431,0.659538},
{0.89794,0.652608},
{0.888074,0.648027},
{0.877897,0.652301},
{0.869196,0.672347},
{0.874212,0.676013},
{0.884742,0.673283},
{0.89598,0.672443},
{0.902596,0.665971},
{0.908133,0.659549},
{0.912967,0.652217},
{0.901136,0.646022},
{0.889853,0.641715},
{0.878895,0.645534},
{0.879607,0.639641},
{0.870406,0.639191},
{0.862262,0.639758},
{0.85539,0.645025},
{0.862995,0.676364},
{0.867102,0.680206},
{0.878268,0.679148},
{0.889305,0.677736},
{0.901798,0.679591},
{0.910596,0.674701},
{0.918591,0.668435},
{0.924862,0.659954},
{0.930472,0.650822},
{0.917129,0.645104},
{0.903798,0.639508},
{0.891113,0.635857},
{0.893116,0.683944},
{0.881403,0.682863},
{0.90593,0.689794},
{0.916609,0.686107},
{0.929571,0.681021},
{0.936428,0.667127},
{0.942567,0.656273},
{0.949711,0.646823},
{0.936482,0.642606},
{0.92121,0.637592},
{0.905828,0.63279},
{0.89156,0.629458},
{0.879896,0.634217},
{0.870091,0.634597},
{0.861301,0.635363},
{0.855223,0.640762},
{0.849337,0.641623},
{0.849581,0.645756},
{0.844215,0.642375},
{0.843773,0.646487},
{0.839469,0.64305},
{0.837964,0.647218},
{0.83491,0.643687},
{0.832155,0.647948},
{0.884277,0.688027},
{0.872828,0.687102},
{0.875007,0.692109},
{0.886607,0.695639},
{0.896144,0.692562},
{0.908376,0.702434},
{0.918934,0.700571},
{0.929639,0.699595},
{0.942885,0.685053},
{0.947274,0.67163},
{0.952791,0.65981},
{0.958961,0.649232},
{0.960269,0.639284},
{0.942694,0.634846},
{0.925118,0.630408},
{0.907542,0.62597},
{0.889967,0.621532},
{0.879626,0.628853},
{0.869213,0.629853},
{0.859507,0.631337},
{0.854083,0.636646},
{0.848717,0.637567},
{0.84458,0.638283},
{0.840973,0.638882},
{0.837664,0.639425},
{0.870286,0.68346},
{0.863108,0.691149},
{0.86533,0.696176},
{0.877095,0.699305},
{0.888732,0.70646},
{0.898356,0.704249},
{0.908808,0.716733},
{0.918764,0.716584},
{0.928443,0.716654},
{0.938165,0.716742},
{0.940102,0.70044},
{0.953367,0.687709},
{0.957281,0.67448},
{0.9614,0.662237},
{0.966001,0.650564},
{0.970644,0.639264},
{0.965457,0.639274},
{0.718232,0.673865},
{0.719971,0.68226},
{0.713434,0.678889},
{0.714094,0.668877},
{0.707382,0.674426},
{0.707762,0.685198},
{0.716169,0.688193},
{0.72474,0.690242},
{0.727195,0.684244},
{0.723135,0.677582},
{0.722594,0.669482},
{0.720227,0.663887},
{0.710252,0.663404},
{0.702107,0.668949},
{0.699881,0.681004},
{0.701094,0.693026},
{0.711754,0.695525},
{0.722029,0.697328},
{0.73204,0.698591},
{0.733516,0.691513},
{0.734908,0.685353},
{0.729268,0.679242},
{0.72496,0.675077},
{0.690854,0.689174},
{0.692886,0.67536},
{0.6822,0.683174},
{0.680292,0.699272},
{0.693307,0.702612},
{0.70688,0.704276},
{0.719186,0.705595},
{0.730575,0.706575},
{0.741399,0.707225},
{0.741945,0.699272},
{0.742539,0.692176},
{0.743049,0.685744},
{0.736161,0.679693},
{0.731151,0.674738},
{0.686646,0.668347},
{0.697269,0.662673},
{0.706788,0.657767},
{0.693146,0.655714},
{0.681027,0.660046},
{0.66725,0.665722},
{0.674442,0.675309},
{0.717861,0.658291},
{0.715494,0.652696},
{0.712958,0.649959},
{0.703781,0.652284},
{0.689461,0.648127},
{0.676137,0.650509},
{0.660815,0.654442},
{0.651642,0.673186},
{0.66043,0.68407},
{0.669656,0.692929},
{0.858365,0.672357},
{0.855227,0.679121},
{0.858343,0.683022},
{0.861137,0.686828},
{0.853611,0.668611},
{0.85403,0.66365},
{0.848795,0.664994},
{0.847566,0.670615},
{0.851241,0.674754},
{0.846261,0.68128},
{0.848914,0.685681},
{0.851162,0.689863},
{0.853212,0.694487},
{0.843559,0.666338},
{0.840865,0.672225},
{0.843484,0.67676},
{0.836434,0.683129},
{0.83861,0.688008},
{0.840668,0.692798},
{0.842717,0.698135},
{0.844937,0.704332},
{0.855272,0.700217},
{0.867471,0.703655},
{0.879363,0.709514},
{0.890467,0.718513},
{0.899583,0.717133},
{0.908091,0.730817},
{0.917291,0.732639},
{0.926839,0.733706},
{0.936315,0.732906},
{0.945243,0.731521},
{0.947275,0.716911},
{0.950147,0.702062},
{0.959599,0.703413},
{0.963128,0.689798},
{0.966331,0.676693},
{0.969418,0.663982},
{0.972601,0.651548},
{0.975831,0.639254},
{0.97898,0.652359},
{0.981019,0.639244},
{0.834415,0.678265},
{0.82446,0.679693},
{0.826081,0.684957},
{0.827981,0.690382},
{0.829963,0.69587},
{0.832092,0.701818},
{0.834432,0.708622},
{0.847489,0.712022},
{0.857607,0.707609},
{0.870023,0.713177},
{0.881776,0.720957},
{0.891789,0.729325},
{0.899655,0.729345},
{0.897762,0.739947},
{0.905106,0.743418},
{0.913707,0.74723},
{0.924257,0.752441},
{0.935707,0.747908},
{0.944286,0.744982},
{0.951463,0.743182},
{0.953145,0.730828},
{0.956139,0.717201},
{0.964644,0.717556},
{0.968754,0.704629},
{0.972864,0.691703},
{0.974903,0.678588},
{0.976942,0.665473},
{0.838324,0.667682},
{0.815369,0.686723},
{0.817113,0.692704},
{0.819076,0.698906},
{0.821237,0.705648},
{0.823667,0.712859},
{0.837107,0.716573},
{0.850604,0.721518},
{0.860485,0.717218},
{0.872961,0.724451},
{0.884297,0.731857},
{0.892477,0.736968},
{0.887783,0.741206},
{0.893091,0.747999},
{0.899727,0.753469},
{0.907202,0.758849},
{0.914323,0.765617},
{0.928896,0.766724},
{0.937496,0.760723},
{0.945308,0.756461},
{0.951941,0.753153},
{0.957984,0.750323},
{0.956423,0.743409},
{0.960533,0.730482},
{0.806115,0.694921},
{0.808032,0.701735},
{0.810186,0.708981},
{0.812549,0.716812},
{0.826337,0.721153},
{0.840238,0.725959},
{0.854152,0.732184},
{0.863872,0.728122},
{0.876505,0.735646},
{0.801046,0.72017},
{0.798864,0.71184},
{0.796857,0.704106},
{0.787299,0.713921},
{0.789126,0.722623},
{0.803314,0.729031},
{0.81509,0.725328},
{0.829319,0.730383},
{0.843731,0.736281},
{0.858049,0.743181},
{0.867737,0.739401},
{0.880731,0.745814},
{0.886161,0.754214},
{0.891992,0.760942},
{0.898651,0.768079},
{0.904716,0.775474},
{0.919899,0.77525},
{0.93322,0.778201},
{0.940794,0.771842},
{0.94749,0.766441},
{0.953683,0.761713},
{0.959544,0.757237},
{0.737342,0.674399},
{0.743345,0.679784},
{0.743533,0.67406},
{0.751276,0.679628},
{0.749725,0.673721},
{0.751789,0.685777},
{0.761214,0.685501},
{0.751932,0.692359},
{0.761821,0.692189},
{0.772112,0.691699},
{0.751974,0.699565},
{0.762394,0.699466},
{0.773153,0.698992},
{0.784024,0.698116},
{0.715092,0.72481},
{0.702617,0.714132},
{0.716708,0.714828},
{0.728191,0.725265},
{0.729177,0.71566},
{0.686784,0.713263},
{0.700538,0.724407},
{0.713954,0.735509},
{0.727285,0.735883},
{0.740092,0.735897},
{0.740453,0.725533},
{0.740902,0.715992},
{0.75229,0.716217},
{0.752093,0.707508},
{0.76386,0.71596},
{0.763091,0.707391},
{0.752425,0.725529},
{0.764649,0.725167},
{0.776943,0.72426},
{0.775609,0.715256},
{0.774288,0.706826},
{0.752628,0.735708},
{0.765442,0.735096},
{0.778298,0.733889},
{0.790991,0.731868},
{0.785576,0.705767},
{0.795054,0.69679},
{0.872582,0.772759},
{0.888929,0.775502},
{0.877978,0.781668},
{0.865736,0.787127},
{0.870501,0.796949},
{0.883161,0.790753},
{0.894526,0.783756},
{0.883177,0.767576},
{0.867387,0.763696},
{0.860927,0.77752},
{0.852231,0.792074},
{0.856409,0.802551},
{0.87515,0.807317},
{0.888113,0.80057},
{0.899742,0.793007},
{0.910263,0.784583},
{0.924761,0.786096},
{0.938087,0.788562},
{0.944716,0.781755},
{0.950371,0.775653},
{0.955796,0.769832},
{0.961105,0.764151},
{0.872228,0.750111},
{0.877492,0.759308},
{0.862406,0.753942},
{0.856148,0.767799},
{0.847704,0.781855},
{0.837491,0.796705},
{0.841215,0.807639},
{0.860816,0.813432},
{0.879899,0.818138},
{0.893079,0.810992},
{0.904862,0.803051},
{0.915109,0.794589},
{0.929739,0.796503},
{0.944378,0.797731},
{0.94895,0.791065},
{0.953522,0.784398},
{0.958094,0.777732},
{0.962666,0.771065},
{0.83028,0.775596},
{0.839713,0.76143},
{0.843778,0.771729},
{0.83386,0.786091},
{0.851602,0.757722},
{0.836031,0.750919},
{0.823637,0.754744},
{0.826842,0.765165},
{0.813012,0.768991},
{0.815809,0.779609},
{0.818643,0.790465},
{0.821654,0.801351},
{0.721897,0.791331},
{0.712133,0.77893},
{0.724356,0.780932},
{0.736823,0.793158},
{0.738282,0.782037},
{0.725558,0.770057},
{0.712782,0.769064},
{0.703179,0.776568},
{0.708432,0.787628},
{0.71878,0.801121},
{0.734947,0.804179},
{0.751835,0.804371},
{0.752608,0.793134},
{0.75314,0.781706},
{0.739135,0.77052},
{0.726143,0.758511},
{0.712375,0.758296},
{0.700367,0.76912},
{0.696924,0.781352},
{0.7032,0.796344},
{0.715066,0.812163},
{0.732844,0.815397},
{0.751007,0.816099},
{0.769269,0.814405},
{0.768947,0.80275},
{0.768648,0.791284},
{0.768262,0.779889},
{0.753262,0.7701},
{0.739591,0.758816},
{0.726681,0.747058},
{0.712907,0.746891},
{0.698005,0.747078},
{0.69786,0.758579},
{0.68235,0.760278},
{0.68787,0.771805},
{0.688991,0.788336},
{0.697958,0.806263},
{0.711339,0.823597},
{0.730608,0.827229},
{0.750148,0.828139},
{0.769629,0.82649},
{0.788691,0.822864},
{0.787323,0.810943},
{0.785894,0.799205},
{0.784699,0.788076},
{0.783398,0.776846},
{0.767683,0.768445},
{0.753132,0.758368},
{0.739858,0.747133},
{0.699285,0.735409},
{0.682763,0.73584},
{0.681446,0.748063},
{0.664776,0.7482},
{0.663413,0.762979},
{0.67624,0.777475},
{0.666427,0.786487},
{0.681689,0.797702},
{0.692594,0.817566},
{0.707465,0.836555},
{0.728335,0.840094},
{0.749297,0.841006},
{0.77004,0.839246},
{0.790259,0.835472},
{0.80965,0.830342},
{0.807157,0.818048},
{0.804858,0.806345},
{0.802671,0.795049},
{0.800517,0.783977},
{0.798447,0.773092},
{0.782175,0.765786},
{0.766981,0.757058},
{0.752889,0.746823},
{0.796513,0.762357},
{0.780855,0.754707},
{0.766227,0.745834},
{0.824711,0.812689},
{0.817782,0.734631},
{0.80562,0.738467},
{0.820629,0.744508},
{0.832437,0.740517},
{0.847491,0.747042},
{0.807922,0.748352},
{0.792827,0.741649},
{0.794659,0.751851},
{0.810425,0.758547},
{0.779622,0.744124},
{0.153188,0.186399},
{0.169355,0.173108},
{0.168776,0.186925},
{0.153921,0.199631},
{0.169774,0.199674},
{0.182759,0.189357},
{0.184318,0.177386},
{0.191177,0.166862},
{0.170337,0.155827},
{0.15372,0.172537},
{0.136076,0.187112},
{0.135878,0.200202},
{0.13741,0.213278},
{0.156324,0.212569},
{0.172299,0.21177},
{0.183316,0.200806},
{0.195445,0.192426},
{0.197705,0.18287},
{0.204286,0.174321},
{0.216438,0.167843},
{0.20652,0.159758},
{0.195322,0.151089},
{0.137511,0.174005},
{0.154886,0.15836},
{0.11798,0.188318},
{0.115769,0.200908},
{0.115489,0.212947},
{0.118437,0.223765},
{0.141637,0.226246},
{0.160802,0.225544},
{0.176497,0.223558},
{0.185616,0.211745},
{0.195322,0.2024},
{0.206672,0.195261},
{0.208611,0.187062},
{0.213838,0.179979},
{0.223799,0.174757},
{0.232631,0.163206},
{0.226699,0.154829},
{0.220307,0.146351},
{0.139434,0.160894},
{0.120823,0.175844},
{0.0992616,0.189776},
{0.0946273,0.201684},
{0.0899929,0.213591},
{0.0932179,0.219692},
{0.0964428,0.225792},
{0.121641,0.233595},
{0.148988,0.242126},
{0.168322,0.238524},
{0.183072,0.235218},
{0.189289,0.222187},
{0.197221,0.212029},
{0.206572,0.20383},
{0.218051,0.196712},
{0.218754,0.189245},
{0.220169,0.183556},
{0.228354,0.181409},
{0.24059,0.178843},
{0.237237,0.170956},
{0.250658,0.159766},
{0.248065,0.150831},
{0.245291,0.141613},
{0.123982,0.163427},
{0.103896,0.177868},
{0.207879,0.212331},
{0.200177,0.221191},
{0.210159,0.220329},
{0.218642,0.212212},
{0.217851,0.204542},
{0.229944,0.203984},
{0.229862,0.196333},
{0.229853,0.188704},
{0.242017,0.186776},
{0.255353,0.184799},
{0.254532,0.176342},
{0.25289,0.168134},
{0.269766,0.158525},
{0.270029,0.149052},
{0.270276,0.136874},
{0.194814,0.232099},
{0.204829,0.229447},
{0.213531,0.227462},
{0.220244,0.219432},
{0.230377,0.211402},
{0.242969,0.210229},
{0.242663,0.202753},
{0.242681,0.194855},
{0.255674,0.193252},
{0.26904,0.192481},
{0.269203,0.183716},
{0.269409,0.175133},
{0.269586,0.166899},
{0.286147,0.16786},
{0.28884,0.159589},
{0.292003,0.150779},
{0.2954,0.141698},
{0.313373,0.154734},
{0.320524,0.146521},
{0.333528,0.159639},
{0.345648,0.151344},
{0.348714,0.166736},
{0.370772,0.156168},
{0.370795,0.173446},
{0.386764,0.173365},
{0.386251,0.159166},
{0.403134,0.175347},
{0.40173,0.162164},
{0.419955,0.177717},
{0.417209,0.165162},
{0.437002,0.180281},
{0.432688,0.16816},
{0.192704,0.246651},
{0.20267,0.241446},
{0.210793,0.236729},
{0.218111,0.23337},
{0.222696,0.225794},
{0.231438,0.218332},
{0.243486,0.217235},
{0.256133,0.216346},
{0.255922,0.209205},
{0.255817,0.201447},
{0.269103,0.200716},
{0.282346,0.192959},
{0.282908,0.18447},
{0.284108,0.176013},
{0.224444,0.237674},
{0.219048,0.242324},
{0.21291,0.248905},
{0.229504,0.24562},
{0.233074,0.239996},
{0.228379,0.234767},
{0.225701,0.231231},
{0.232926,0.224635},
{0.244466,0.223601},
{0.256393,0.223033},
{0.269011,0.215922},
{0.269141,0.208639},
{0.28222,0.201212},
{0.295194,0.194359},
{0.296019,0.186221},
{0.297761,0.178302},
{0.301572,0.170503},
{0.306768,0.162912},
{0.322801,0.167455},
{0.334762,0.173858},
{0.355175,0.177265},
{0.370756,0.187276},
{0.38669,0.187253},
{0.404072,0.188535},
{0.422389,0.190328},
{0.441316,0.192402},
{0.13896,0.937482},
{0.15442,0.936036},
{0.147552,0.942756},
{0.131991,0.943023},
{0.140528,0.948093},
{0.148962,0.952945},
{0.155644,0.947301},
{0.162965,0.941085},
{0.17217,0.935147},
{0.161958,0.928403},
{0.145004,0.930904},
{0.130641,0.931218},
{0.122815,0.936756},
{0.115375,0.942445},
{0.124894,0.947972},
{0.133402,0.953212},
{0.141677,0.957166},
{0.14902,0.960085},
{0.157149,0.955791},
{0.164222,0.950166},
{0.168383,0.944741},
{0.177196,0.942628},
{0.191842,0.938528},
{0.18483,0.928669},
{0.170213,0.919654},
{0.149326,0.922843},
{0.137176,0.927417},
{0.123364,0.923705},
{0.112481,0.9301},
{0.10407,0.937626},
{0.11077,0.946594},
{0.116632,0.951525},
{0.125551,0.956525},
{0.134656,0.9604},
{0.141913,0.961891},
{0.154732,0.962219},
{0.165935,0.957311},
{0.17427,0.950399},
{0.187555,0.948567},
{0.205846,0.945238},
{0.214023,0.932819},
{0.202519,0.920832},
{0.180131,0.909732},
{0.152639,0.912726},
{0.135915,0.920575},
{0.116168,0.914322},
{0.100899,0.922774},
{0.0891699,0.932953},
{0.0850445,0.943365},
{0.101008,0.945485},
{0.10617,0.952878},
{0.116457,0.959008},
{0.12877,0.963081},
{0.141924,0.964387},
{0.141749,0.967835},
{0.159735,0.964585},
{0.17534,0.957124},
{0.186612,0.957297},
{0.198452,0.956803},
{0.226639,0.94116},
{0.254826,0.925518},
{0.222723,0.912315},
{0.190621,0.899112},
{0.155653,0.899975},
{0.133862,0.910183},
{0.108088,0.902447},
{0.0872616,0.914579},
{0.0688679,0.927864},
{0.0611106,0.940896},
{0.072194,0.95227},
{0.0918948,0.952851},
{0.106027,0.960245},
{0.123264,0.966181},
{0.117382,0.970674},
{0.141615,0.973986},
{0.164947,0.968203},
{0.170264,0.972446},
{0.878596,0.946725},
{0.86416,0.948207},
{0.871579,0.942636},
{0.886187,0.942108},
{0.879367,0.938048},
{0.872605,0.934139},
{0.865133,0.939046},
{0.857275,0.944342},
{0.848379,0.949442},
{0.856645,0.954682},
{0.872055,0.95214},
{0.878967,0.954757},
{0.885478,0.951547},
{0.893652,0.946846},
{0.901581,0.942011},
{0.893918,0.937827},
{0.887213,0.93361},
{0.880339,0.930202},
{0.873942,0.927331},
{0.865671,0.931509},
{0.858017,0.93669},
{0.853203,0.941375},
{0.845039,0.94326},
{0.831685,0.94681},
{0.836809,0.955124},
{0.849069,0.962192},
{0.867473,0.958814},
{0.87954,0.960235},
{0.891517,0.95734},
{0.902437,0.951808},
{0.911331,0.94532},
{0.906681,0.938262},
{0.902324,0.934359},
{0.895145,0.930139},
{0.887365,0.926738},
{0.880712,0.92523},
{0.868668,0.924726},
{0.857703,0.929735},
{0.848987,0.936302},
{0.836697,0.937574},
{0.819804,0.940196},
{0.811605,0.952025},
{0.820926,0.962167},
{0.840048,0.970839},
{0.864116,0.967327},
{0.880983,0.968761},
{0.897606,0.964725},
{0.912651,0.957127},
{0.924587,0.948175},
{0.929636,0.938971},
{0.915423,0.938551},
{0.911938,0.93218},
{0.903495,0.926861},
{0.892712,0.923251},
{0.880724,0.922242},
{0.863614,0.921492},
{0.84864,0.929044},
{0.837802,0.927994},
{0.826204,0.927352},
{0.800609,0.943494},
{0.775015,0.959635},
{0.802886,0.96989},
{0.830758,0.980145},
{0.86125,0.978259},
{0.883219,0.980673},
{0.904637,0.974329},
{0.924742,0.963135},
{0.94277,0.951002},
{0.950985,0.939207},
{0.941648,0.929031},
{0.924475,0.930625},
{0.91222,0.923978},
{0.897103,0.91889},
{0.880267,0.917735},
{0.87928,0.910354},
{0.857877,0.916732},
{0.851798,0.911211},
{0.963417,0.953814},
{0.937778,0.969427},
{0.91214,0.985041},
{0.886501,1.00065},
{0.85863,0.990399},
{0.989055,0.9382},
{0.96114,0.927417},
{0.933224,0.916635},
{0.922496,0.92029},
{0.901263,0.912802},
{0.905308,0.905852},
{0.877392,0.895069},
{0.158518,0.885909},
{0.131,0.896051},
{0.126415,0.872706},
{0.0995652,0.889326},
{0.0727151,0.905945},
{0.045865,0.922565},
{0.0190149,0.939185},
{0.0497805,0.951411},
{0.080546,0.963637},
{0.0937428,0.962144},
{0.111312,0.975863},
{0.142077,0.988088},
{0.179853,0.251475},
{0.181861,0.270696},
{0.168188,0.257701},
{0.143271,0.254169},
{0.161775,0.267111},
{0.176773,0.279775},
{0.191338,0.282164},
{0.199167,0.27764},
{0.19145,0.264485},
{0.157989,0.278114},
{0.139623,0.26474},
{0.121258,0.251367},
{0.122129,0.24267},
{0.102893,0.237993},
{0.0996677,0.231893},
{0.0472563,0.523503},
{0.0332681,0.539408},
{0.0419152,0.53618},
{0.0550589,0.52441},
{0.0504472,0.534124},
{0.0380519,0.549348},
{0.0277081,0.556063},
{0.038828,0.522754},
{0.0547796,0.5128},
{0.0629257,0.517019},
{0.0616102,0.525629},
{0.0581,0.532485},
{0.0559107,0.540335},
{0.0476885,0.543737},
{0.0376346,0.561691},
{0.0221481,0.572717},
{0.0478604,0.554178},
{0.055828,0.548702},
{0.0513392,0.563763},
{0.0426311,0.57189},
{0.0332182,0.580753},
{0.0632249,0.540131},
{0.0662616,0.533766},
{0.0687181,0.527585},
{0.0746039,0.537227},
{0.0701373,0.544116},
{0.0611958,0.546374},
{0.0586375,0.557107},
{0.0576334,0.571748},
{0.0509533,0.580146},
{0.0442882,0.588789},
{0.0679204,0.520553},
{0.073766,0.51176},
{0.0785101,0.518041},
{0.0719578,0.52396},
{0.0655669,0.57722},
{0.0718228,0.588438},
{0.0757862,0.577556},
{0.0704192,0.569255},
{0.0789464,0.569999},
{0.0882754,0.571292},
{0.0853955,0.582515},
{0.0816758,0.596094},
{0.0664284,0.60486},
{0.0553583,0.596825},
{0.060513,0.586655},
{0.0637107,0.564356},
{0.070071,0.55722},
{0.0760258,0.562179},
{0.0810156,0.564522},
{0.0894754,0.56478},
{0.101838,0.557019},
{0.0994555,0.572536},
{0.0969232,0.587328},
{0.0648092,0.550898},
{0.0767944,0.549978},
{0.0833422,0.555408},
{0.0881221,0.560358},
{0.0989423,0.555133},
{0.107589,0.538443},
{0.112325,0.545469},
{0.112227,0.562147},
{0.112171,0.578561},
{0.124355,0.551553},
{0.127418,0.569795},
{0.0957205,0.55254},
{0.0904211,0.548013},
{0.0825732,0.542567},
{0.0953147,0.539062},
{0.100791,0.542278},
{0.104283,0.542593},
{0.0877993,0.53464},
{0.0982366,0.53011},
{0.090315,0.526886},
{0.0781908,0.530701},
{0.0798442,0.524364},
{0.0900973,0.518593},
{0.0994002,0.522709},
{0.101769,0.534189},
{0.0876161,0.508163},
{0.100625,0.514782},
{0.104701,0.530629},
{0.920243,0.805051},
{0.934775,0.80669},
{0.925171,0.815649},
{0.910168,0.813683},
{0.915568,0.824608},
{0.898686,0.821929},
{0.905965,0.833567},
{0.884966,0.82932},
{0.890192,0.840682},
{0.86976,0.836188},
{0.87442,0.847798},
{0.853822,0.842863},
{0.858647,0.854913},
{0.836161,0.849417},
{0.842874,0.862029},
{0.815787,0.855921},
{0.819336,0.868912},
{0.793818,0.862058},
{0.795798,0.875795},
{0.771369,0.867508},
{0.772261,0.882678},
{0.748212,0.870509},
{0.748723,0.889561},
{0.724119,0.869298},
{0.722193,0.885121},
{0.69961,0.865356},
{0.695663,0.88068},
{0.675206,0.860163},
{0.669133,0.87624},
{0.651382,0.852648},
{0.642603,0.8718},
{0.628613,0.841743},
{0.618698,0.858285},
{0.606349,0.829025},
{0.594793,0.84477},
{0.584037,0.816073},
{0.570888,0.831255},
{0.561282,0.802854},
{0.546984,0.81774},
{0.537687,0.789339},
{0.521696,0.80043},
{0.5145,0.775693},
{0.496408,0.78312},
{0.492969,0.762083},
{0.471121,0.76581},
{0.478432,0.748437},
{0.445833,0.7485},
{0.476228,0.734685},
{0.454664,0.733089},
{0.481514,0.721061},
{0.463494,0.717678},
{0.472325,0.702267},
{0.489445,0.707801},
{0.481156,0.686856},
{0.500703,0.696106},
{0.500082,0.677282},
{0.515971,0.687177},
{0.519008,0.667707},
{0.533662,0.679776},
{0.537934,0.658133},
{0.55219,0.672662},
{0.55686,0.648558},
{0.571868,0.665802},
{0.58088,0.642801},
{0.593009,0.659162},
{0.6049,0.637043},
{0.614692,0.652678},
{0.628919,0.631286},
{0.635997,0.646287},
{0.652939,0.625528},
{0.655577,0.64149},
{0.672084,0.639787},
{0.66845,0.628475},
{0.686608,0.639919},
{0.68396,0.631421},
{0.700237,0.640623},
{0.69947,0.634368},
{0.71498,0.637314},
{0.711679,0.641543},
{0.71996,0.638782},
{0.719643,0.64232},
{0.724939,0.640251},
{0.725656,0.643083},
{0.729918,0.641719},
{0.731247,0.643959},
{0.734897,0.643187},
{0.736627,0.644893},
{0.732577,0.6462},
{0.738356,0.646598},
{0.733906,0.64844},
{0.740086,0.648303},
{0.735235,0.65068},
{0.865004,0.824698},
{0.849222,0.830896},
{0.831679,0.83698},
{0.812478,0.843031},
{0.791851,0.848437},
{0.770591,0.852857},
{0.748599,0.854921},
{0.726136,0.854086},
{0.703598,0.850293},
{0.681189,0.844692},
{0.659402,0.836491},
{0.638424,0.825833},
{0.617742,0.813781},
{0.597165,0.801047},
{0.575655,0.789046},
{0.553225,0.778158},
{0.531598,0.768055},
{0.512875,0.758052},
{0.500324,0.747435},
{0.496419,0.736002},
{0.499408,0.724217},
{0.505915,0.712954},
{0.516448,0.703502},
{0.530573,0.696655},
{0.547123,0.691597},
{0.56563,0.687095},
{0.584936,0.681759},
{0.604883,0.675219},
{0.624356,0.66752},
{0.643447,0.660513},
{0.701506,0.646666},
{0.711659,0.645946},
{0.719749,0.645744},
{0.726461,0.64589},
{0.727515,0.648634},
{0.728655,0.651352},
{0.827993,0.824626},
{0.686995,0.830434},
{0.667117,0.821916},
{0.648026,0.811186},
{0.629233,0.799056},
{0.610251,0.786335},
{0.590115,0.774943},
{0.567858,0.766798},
{0.546459,0.760192},
{0.5289,0.753414},
{0.51732,0.74582},
{0.513862,0.73676},
{0.515969,0.727011},
{0.521085,0.717345},
{0.529774,0.709521},
{0.542602,0.705297},
{0.558759,0.703094},
{0.577435,0.701334},
{0.597105,0.697898},
{0.616244,0.690669},
{0.634531,0.681735},
{0.674567,0.808938},
{0.657375,0.798004},
{0.64028,0.785894},
{0.622928,0.773335},
{0.604328,0.759732},
{0.579071,0.755761},
{0.557994,0.751956},
{0.540511,0.747664},
{0.529143,0.743889},
{0.530226,0.737883},
{0.532926,0.729581},
{0.536163,0.720718},
{0.538817,0.714517},
{0.550413,0.713789},
{0.566532,0.713946},
{0.585456,0.714475},
{0.608299,0.714718},
{0.627328,0.703786},
{0.644545,0.693632},
{0.655097,0.70327},
{0.667128,0.712276},
{0.844724,0.634228},
{0.843982,0.630547},
{0.844791,0.630193},
{0.847346,0.633664},
{0.845599,0.629839},
{0.851791,0.632782},
{0.846408,0.629484},
{0.857298,0.627496},
{0.868187,0.625508},
{0.879077,0.62352},
{0.842478,0.634715},
{0.843173,0.630902},
{0.840419,0.635163},
{0.7207,0.648941},
{0.722074,0.652024},
{0.845073,0.819095},
{0.268705,0.737229},
{0.241633,0.762787},
{0.237985,0.738297},
{0.268705,0.710477},
{0.234693,0.711537},
{0.207029,0.741466},
{0.214528,0.765549},
{0.222333,0.788147},
{0.245519,0.78554},
{0.268705,0.761697},
{0.295776,0.762787},
{0.299424,0.738297},
{0.302716,0.711537},
{0.305534,0.681974},
{0.268705,0.681041},
{0.231875,0.681974},
{0.195405,0.687835},
{0.200475,0.715676},
{0.165843,0.72393},
{0.175598,0.746705},
{0.187254,0.769363},
{0.199147,0.791261},
{0.211159,0.812779},
{0.230341,0.810102},
{0.249523,0.807426},
{0.268705,0.784364},
{0.29189,0.78554},
{0.315076,0.788147},
{0.322881,0.76555},
{0.33038,0.741466},
{0.336934,0.71568},
{0.342004,0.687835},
{0.306111,0.650222},
{0.268707,0.649795},
{0.231298,0.650222},
{0.189521,0.653078},
{0.152896,0.681504},
{0.159651,0.701684},
{0.127915,0.732152},
{0.14393,0.752977},
{0.159946,0.773803},
{0.175961,0.794629},
{0.191977,0.815455},
{0.268706,0.280765},
{0.253464,0.295744},
{0.253345,0.280308},
{0.253558,0.266767},
{0.238168,0.279086},
{0.238957,0.294344},
{0.239577,0.31028},
{0.253859,0.311911},
{0.268576,0.296249},
{0.283688,0.295775},
{0.283986,0.280354},
{0.283956,0.266822},
{0.268814,0.267129},
{0.268799,0.256538},
{0.254158,0.256284},
{0.238317,0.265747},
{0.223441,0.277203},
{0.225134,0.292637},
{0.22632,0.307825},
{0.227134,0.322083},
{0.240382,0.325349},
{0.254334,0.327593},
{0.268615,0.312525},
{0.283294,0.311929},
{0.297456,0.310292},
{0.298143,0.294421},
{0.299047,0.279209},
{0.299023,0.2659},
{0.283363,0.256332},
{0.214544,0.305067},
{0.21323,0.291052},
{0.210121,0.276206},
{0.203439,0.290476},
{0.204702,0.30253},
{0.204397,0.314025},
{0.215045,0.317962},
{0.223004,0.263413},
{0.239676,0.25526},
{0.225586,0.253155},
{0.205687,0.259413},
{0.268768,0.248379},
{0.255927,0.241503},
{0.268934,0.241592},
{0.281812,0.241506},
{0.269051,0.235581},
{0.256594,0.23557},
{0.243677,0.241038},
{0.254998,0.248112},
{0.282538,0.248141},
{0.29388,0.241063},
{0.281311,0.235544},
{0.268973,0.2293},
{0.256648,0.229427},
{0.244966,0.235422},
{0.241893,0.247542},
{0.235164,0.235206},
{0.244951,0.229727},
{0.234642,0.230172},
{0.26887,0.222737},
{0.281165,0.229372},
{0.281328,0.222946},
{0.281754,0.216221},
{0.28215,0.209032},
{0.295125,0.202337},
{0.307895,0.195694},
{0.308085,0.188134},
{0.309891,0.180957},
{0.31486,0.174313},
{0.324674,0.179566},
{0.341079,0.182428},
{0.356262,0.189263},
{0.36925,0.200049},
{0.385442,0.200518},
{0.403793,0.201683},
{0.424198,0.203052},
{0.44563,0.204522},
{0.124255,0.719528},
{0.120595,0.706905},
{0.141452,0.664926},
{0.116935,0.694282},
{0.127664,0.650149},
{0.113276,0.681659},
{0.142052,0.61864},
{0.162996,0.634435},
{0.203702,0.612749},
{0.178593,0.601672},
{0.15644,0.58713},
{0.187831,0.570739},
{0.211524,0.580428},
{0.239135,0.585332},
{0.241505,0.558876},
{0.215104,0.553361},
{0.190298,0.545736},
{0.166291,0.537055},
{0.170828,0.555621},
{0.268705,0.617234},
{0.234725,0.616894},
{0.268705,0.586687},
{0.268704,0.561105},
{0.268702,0.540749},
{0.243925,0.538213},
{0.216094,0.528531},
{0.187254,0.524533},
{0.161754,0.51849},
{0.179959,0.505005},
{0.157216,0.499924},
{0.170538,0.486314},
{0.152679,0.481359},
{0.194745,0.309006},
{0.195938,0.298294},
{0.197069,0.290309},
{0.187394,0.290439},
{0.185378,0.30188},
{0.183331,0.315904},
{0.193422,0.320894},
{0.176354,0.291487},
{0.173467,0.310566},
{0.17058,0.329645},
{0.18128,0.331343},
{0.192219,0.333104},
{0.203968,0.325186},
{0.215289,0.329543},
{0.159054,0.422514},
{0.151701,0.418126},
{0.158413,0.418134},
{0.164461,0.422716},
{0.164807,0.418553},
{0.157521,0.413533},
{0.148879,0.413937},
{0.147015,0.418787},
{0.147324,0.422254},
{0.153357,0.422511},
{0.159401,0.426978},
{0.164378,0.426932},
{0.169254,0.42687},
{0.169733,0.422548},
{0.169209,0.419346},
{0.166076,0.414524},
{0.156354,0.409665},
{0.144491,0.409813},
{0.142544,0.416326},
{0.140909,0.42129},
{0.142327,0.427533},
{0.148767,0.427196},
{0.154331,0.42702},
{0.159655,0.431437},
{0.1639,0.431123},
{0.16807,0.431122},
{0.174588,0.426678},
{0.175028,0.421443},
{0.172571,0.417098},
{0.16826,0.410583},
{0.17135,0.406685},
{0.155839,0.404764},
{0.13814,0.405626},
{0.135724,0.413665},
{0.132677,0.420037},
{0.1348,0.428233},
{0.145149,0.43376},
{0.150273,0.432153},
{0.15511,0.43158},
{0.159617,0.435925},
{0.163693,0.43525},
{0.166865,0.4343},
{0.172391,0.431921},
{0.179537,0.42641},
{0.180644,0.419795},
{0.176559,0.414437},
{0.182441,0.411169},
{0.188648,0.408382},
{0.175531,0.40322},
{0.156251,0.401361},
{0.13333,0.401583},
{0.124506,0.410074},
{0.121193,0.418911},
{0.1248,0.429441},
{0.131925,0.438966},
{0.13921,0.436123},
{0.14915,0.438598},
{0.151569,0.435731},
{0.155198,0.436148},
{0.159394,0.440679},
{0.164422,0.439274},
{0.168862,0.436383},
{0.176807,0.433082},
{0.186036,0.426037},
{0.186883,0.417995},
{0.193566,0.416303},
{0.1956,0.40625},
{0.180988,0.400577},
{0.159402,0.397834},
{0.133566,0.39789},
{0.106177,0.400376},
{0.10719,0.406598},
{0.105778,0.419582},
{0.112909,0.431692},
{0.123421,0.442151},
{0.135792,0.449792},
{0.140851,0.446115},
{0.145413,0.441926},
{0.152195,0.445145},
{0.154101,0.440679},
{0.158914,0.444672},
{0.165593,0.443116},
{0.171559,0.438762},
{0.181259,0.434168},
{0.191608,0.425692},
{0.139469,0.389504},
{0.17063,0.392906},
{0.137897,0.391939},
{0.101359,0.388325},
{0.10962,0.392167},
{0.136029,0.394644},
{0.164076,0.395797},
{0.189135,0.398093},
{0.201386,0.395105},
{0.177579,0.390684},
{0.108525,0.396264},
{0.0922294,0.393554},
{0.0851413,0.39891},
{0.205359,0.404085},
{0.221392,0.400547},
{0.215689,0.391863},
{0.0857539,0.42372},
{0.0978159,0.435407},
{0.113824,0.445537},
{0.130697,0.452864},
{0.14535,0.456142},
{0.147456,0.453335},
{0.149859,0.449516},
{0.0493589,0.420043},
{0.0792543,0.412786},
{0.0799332,0.404918},
{0.0520286,0.41091},
{0.019659,0.417742},
{0.0109524,0.427572},
{0.0604704,0.429958},
{0.0810976,0.440196},
{0.104492,0.449389},
{0.127195,0.455721},
{0.14455,0.458507},
{0.158128,0.455703},
{0.158194,0.452773},
{0.158597,0.449574},
{0.0967788,0.453971},
{0.042503,0.451596},
{0.0620736,0.445754},
{0.0292777,0.436932},
{-0.00486957,0.444274},
{0.0898755,0.458919},
{0.12693,0.459685},
{-0.0522421,0.436952},
{0.211205,0.424626},
{0.236149,0.408646},
{0.218498,0.42425},
{0.200848,0.439853},
{0.197771,0.438115},
{0.183198,0.455456},
{0.18375,0.449328},
{0.171322,0.455881},
{0.17171,0.458153},
{0.159192,0.459271},
{0.160223,0.460849},
{0.148735,0.463545},
{0.146064,0.460995},
{0.137248,0.466241},
{0.221871,0.411246},
{0.209393,0.413479},
{0.203585,0.425014},
{0.194343,0.436667},
{0.182271,0.446693},
{0.17064,0.453743},
{0.158284,0.457002},
{0.185733,0.435099},
{0.197971,0.425316},
{0.190212,0.435797},
{0.176955,0.4435},
{0.179819,0.445093},
{0.200514,0.414982},
{0.174252,0.441387},
{0.167924,0.449711},
{0.169371,0.451874},
{0.166713,0.446693},
{0.0991561,0.388722},
{0.100257,0.388524},
{0.0806903,0.395723},
{0.0646922,0.403325},
{0.0433475,0.407848},
{-0.0149432,0.424994},
{0.0223556,0.413036},
{0.0699681,0.398298},
{0.0596545,0.401078},
{0.0980548,0.388921},
{0.0969534,0.389119},
{0.121292,0.533311},
{0.110423,0.513527},
{0.106779,0.524557},
{0.103732,0.504253},
{0.115165,0.496827},
{0.112506,0.528264},
{0.118228,0.515069},
{0.0753139,0.485928},
{0.0650052,0.492652},
{0.0850253,0.491819},
{0.076075,0.499356},
{0.0546966,0.499376},
{0.0651895,0.505551},
{0.044388,0.5061},
{0.100394,0.488016},
{0.0930081,0.48361},
{0.0856225,0.479205},
{0.0945577,0.497873},
{0.107779,0.492421},
{0.230571,0.517622},
{0.228964,0.503271},
{0.23946,0.508287},
{0.253257,0.51249},
{0.244771,0.497304},
{0.234955,0.49435},
{0.225998,0.491141},
{0.224113,0.501179},
{0.217261,0.507781},
{0.200655,0.50824},
{0.248486,0.524031},
{0.268704,0.514179},
{0.268704,0.500841},
{0.256308,0.499747},
{0.258069,0.48605},
{0.247642,0.484503},
{0.237658,0.483058},
{0.227882,0.481103},
{0.188396,0.491269},
{0.206255,0.496224},
{0.268704,0.526377},
{0.284152,0.512489},
{0.281101,0.499747},
{0.268703,0.486337},
{0.268704,0.471564},
{0.25897,0.471644},
{0.249236,0.471672},
{0.239501,0.471434},
{0.229767,0.471064},
{0.240915,0.459645},
{0.231652,0.461026},
{0.258636,0.367175},
{0.255765,0.379731},
{0.24946,0.367438},
{0.255826,0.354536},
{0.241478,0.353126},
{0.234227,0.359499},
{0.242109,0.369275},
{0.249247,0.379811},
{0.262283,0.37965},
{0.268728,0.367451},
{0.268674,0.354878},
{0.268674,0.342201},
{0.254691,0.341571},
{0.240937,0.339238},
{0.227222,0.344776},
{0.224857,0.351242},
{0.228611,0.363909},
{0.23567,0.3719},
{0.242729,0.379892},
{0.214279,0.345817},
{0.215158,0.338968},
{0.227708,0.334728},
{0.203423,0.33552},
{0.202774,0.344537},
{0.202072,0.352895},
{0.214493,0.347926},
{0.221552,0.355917},
{0.268669,0.328244},
{0.282898,0.327607},
{0.296663,0.325331},
{0.309865,0.321929},
{0.31066,0.307783},
{0.311916,0.292761},
{0.313749,0.277461},
{0.31433,0.263721},
{0.297743,0.255375},
{0.295585,0.24761},
{0.250178,0.458265},
{0.259441,0.456884},
{0.268704,0.455503},
{0.277967,0.456884},
{0.278439,0.471644},
{0.288173,0.471672},
{0.28723,0.458265},
{0.297907,0.471434},
{0.296494,0.459645},
{0.307642,0.471064},
{0.305757,0.461026},
{0.190908,0.345555},
{0.18965,0.357864},
{0.179249,0.347026},
{0.177228,0.362833},
{0.167693,0.348723},
{0.164806,0.367802},
{0.746935,0.609408},
{0.714187,0.592962},
{0.718331,0.590305},
{0.748316,0.600181},
{0.722394,0.585817},
{0.698297,0.570265},
{0.691016,0.56935},
{0.682993,0.567088},
{0.74538,0.618837},
{0.776045,0.619539},
{0.775836,0.606046},
{0.775571,0.595734},
{0.74935,0.591359},
{0.724973,0.581367},
{0.704095,0.568485},
{0.687534,0.554647},
{0.678793,0.553513},
{0.668258,0.550016},
{0.651799,0.541213},
{0.653323,0.535777},
{0.641663,0.531566},
{0.643349,0.524282},
{0.631527,0.521919},
{0.635476,0.513181},
{0.62139,0.512271},
{0.631937,0.501954},
{0.611254,0.502624},
{0.620833,0.49139},
{0.634969,0.490079},
{0.630412,0.480156},
{0.642366,0.477595},
{0.639991,0.468922},
{0.651924,0.464538},
{0.649571,0.457689},
{0.666675,0.448773},
{0.681322,0.43065},
{0.68965,0.428163},
{0.717395,0.406114},
{0.713072,0.403611},
{0.746453,0.386032},
{0.744823,0.376573},
{0.775924,0.375151},
{0.776574,0.349534},
{0.804904,0.380706},
{0.806571,0.368936},
{0.836568,0.388337},
{0.833101,0.395604},
{0.866565,0.407739},
{0.860227,0.412749},
{0.884353,0.430602},
{0.896562,0.42714},
{0.903554,0.447624},
{0.915223,0.44455},
{0.919103,0.464149},
{0.933883,0.461959},
{0.932278,0.480511},
{0.952544,0.479369},
{0.938271,0.4968},
{0.971205,0.496778},
{0.952549,0.514234},
{0.932277,0.513107},
{0.933894,0.53169},
{0.919101,0.529512},
{0.915238,0.549145},
{0.903546,0.546094},
{0.896582,0.566601},
{0.884334,0.563198},
{0.86658,0.586129},
{0.860186,0.581167},
{0.833052,0.598471},
{0.836578,0.605656},
{0.804878,0.613577},
{0.806576,0.625184},
{0.776574,0.644712},
{0.726629,0.571953},
{0.707052,0.562689},
{0.694305,0.554226},
{0.689104,0.545131},
{0.676113,0.541788},
{0.66485,0.539385},
{0.656336,0.526524},
{0.649849,0.514184},
{0.647883,0.501604},
{0.649396,0.488552},
{0.655529,0.474973},
{0.663815,0.460707},
{0.677635,0.445158},
{0.697322,0.42707},
{0.721657,0.410555},
{0.747928,0.395308},
{0.775728,0.388743},
{0.803376,0.3921},
{0.829462,0.404087},
{0.854087,0.418075},
{0.874945,0.43437},
{0.891561,0.450226},
{0.903209,0.465704},
{0.912385,0.481335},
{0.915407,0.496828},
{0.912378,0.512315},
{0.903217,0.52798},
{0.89162,0.543518},
{0.874997,0.559455},
{0.854086,0.575883},
{0.829393,0.590056},
{0.803304,0.602321},
{0.801979,0.591764},
{0.775203,0.583316},
{0.749786,0.580241},
{0.74937,0.564127},
{0.725988,0.558685},
{0.705814,0.551558},
{0.702985,0.536491},
{0.684619,0.531929},
{0.668859,0.529},
{0.664797,0.515372},
{0.663468,0.501153},
{0.664408,0.486592},
{0.66825,0.472074},
{0.675624,0.457981},
{0.687208,0.443737},
{0.70368,0.428763},
{0.72449,0.414957},
{0.749092,0.40422},
{0.7756,0.399248},
{0.802127,0.402739},
{0.826949,0.411924},
{0.848341,0.424031},
{0.865824,0.437779},
{0.878921,0.451884},
{0.887953,0.466437},
{0.893241,0.481526},
{0.894945,0.496872},
{0.893224,0.512192},
{0.888008,0.52727},
{0.879227,0.541892},
{0.866281,0.556104},
{0.848572,0.569954},
{0.826879,0.582241},
{0.681508,0.516892},
{0.680604,0.50058},
{0.681197,0.484039},
{0.68415,0.468328},
{0.689031,0.45406},
{0.694232,0.4441},
{0.707038,0.434775},
{0.72621,0.424666},
{0.749645,0.415483},
{0.77532,0.411729},
{0.801153,0.415145},
{0.824944,0.4236},
{0.84502,0.432484},
{0.85855,0.440351},
{0.864248,0.450831},
{0.869741,0.465154},
{0.873151,0.480724},
{0.874064,0.496896},
{0.87312,0.513029},
{0.86975,0.528566},
{0.864702,0.54298},
{0.859045,0.553539},
{0.845415,0.561476},
{0.824828,0.570521},
{0.80095,0.579355},
{0.774586,0.566031},
{0.773996,0.544472},
{0.748527,0.544271},
{0.725299,0.540094},
{0.723365,0.520768},
{0.701169,0.518891},
{0.700461,0.499917},
{0.700952,0.48073},
{0.702688,0.462561},
{0.705712,0.446642},
{0.725766,0.438352},
{0.749286,0.431814},
{0.774704,0.42899},
{0.800446,0.431839},
{0.824826,0.438046},
{0.846154,0.445298},
{0.848903,0.461112},
{0.850422,0.478567},
{0.850862,0.496842},
{0.850371,0.515118},
{0.848896,0.532613},
{0.846383,0.548548},
{0.824745,0.55595},
{0.800262,0.562542},
{0.799857,0.542467},
{0.773366,0.521907},
{0.747679,0.521923},
{0.723056,0.499144},
{0.747248,0.498271},
{0.773136,0.497495},
{0.773403,0.473071},
{0.747651,0.474504},
{0.723247,0.47733},
{0.725094,0.457517},
{0.74847,0.451919},
{0.774044,0.450536},
{0.799984,0.45176},
{0.824792,0.456782},
{0.825727,0.475971},
{0.825711,0.49681},
{0.825661,0.517765},
{0.8247,0.537119},
{0.799659,0.497042},
{0.799676,0.520274},
{0.799741,0.47385},
{0.629822,0.737341},
{0.630937,0.748106},
{0.622835,0.741898},
{0.623594,0.732979},
{0.61964,0.737363},
{0.614012,0.74515},
{0.621199,0.753622},
{0.634824,0.763445},
{0.644256,0.754878},
{0.637348,0.741916},
{0.638168,0.732456},
{0.632743,0.72671},
{0.623692,0.721651},
{0.615298,0.729693},
{0.612351,0.737387},
{0.601727,0.746549},
{0.651148,0.774455},
{0.649538,0.745843},
{0.64197,0.737033},
{0.651523,0.736804},
{0.651064,0.728223},
{0.64705,0.720202},
{0.638367,0.712843},
{0.603694,0.727299},
{0.601364,0.736825},
{0.584349,0.745549},
{0.666356,0.736499},
{0.666861,0.725286},
{0.683906,0.72429},
{0.586302,0.735665},
{0.565094,0.743135},
{0.547179,0.740294},
{0.587541,0.725613},
{0.569532,0.724249},
{0.568421,0.733816},
{0.550572,0.731836},
{0.552359,0.722818},
{0.817268,0.334177},
{0.807098,0.329266},
{0.817772,0.32972},
{0.827985,0.335004},
{0.82832,0.330282},
{0.818436,0.324849},
{0.807782,0.324278},
{0.797082,0.323766},
{0.796428,0.328877},
{0.806518,0.333516},
{0.806012,0.337004},
{0.8169,0.338119},
{0.827785,0.339607},
{0.838685,0.335915},
{0.838683,0.330654},
{0.838379,0.326237},
{0.828882,0.32546},
{0.81933,0.31943},
{0.808609,0.31864},
{0.797841,0.317858},
{0.787134,0.317284},
{0.786496,0.323337},
{0.785864,0.328653},
{0.795796,0.333142},
{0.795184,0.336418},
{0.805553,0.339703},
{0.816582,0.341797},
{0.82763,0.344073},
{0.838686,0.341177},
{0.827498,0.348469},
{0.816308,0.345239},
{0.805117,0.342008},
{0.794562,0.338721},
{0.793926,0.338777},
{0.783629,0.339781},
{0.782822,0.342267},
{0.772735,0.341953},
{0.771718,0.345756},
{0.761859,0.344306},
{0.760614,0.349246},
{0.750993,0.34675},
{0.74951,0.352736},
{0.838688,0.346438},
{0.838689,0.3517},
{0.784417,0.336886},
{0.773732,0.337889},
{0.763085,0.339283},
{0.752475,0.340764},
{0.785167,0.333173},
{0.774651,0.33352},
{0.764271,0.334092},
{0.753958,0.334778},
{0.775476,0.328538},
{0.765302,0.328633},
{0.755441,0.328792},
{0.756792,0.322664},
{0.749221,0.328331},
{0.748795,0.322531},
{0.743001,0.327869},
{0.741594,0.322579},
{0.736781,0.327408},
{0.734712,0.322982},
{0.730562,0.326947},
{0.728685,0.324646},
{0.728661,0.332789},
{0.724048,0.328479},
{0.720269,0.333665},
{0.726761,0.338632},
{0.716815,0.339387},
{0.724861,0.344474},
{0.713734,0.345346},
{0.72296,0.350316},
{0.720575,0.353357},
{0.728459,0.354192},
{0.729598,0.350921},
{0.735307,0.354339},
{0.736235,0.351526},
{0.741697,0.354388},
{0.742872,0.352131},
{0.747858,0.354388},
{0.866407,0.338084},
{0.86882,0.330441},
{0.872696,0.335583},
{0.874845,0.341757},
{0.882136,0.339457},
{0.878875,0.332422},
{0.874176,0.326498},
{0.867789,0.322599},
{0.863427,0.326736},
{0.863658,0.333516},
{0.860064,0.340257},
{0.867867,0.343569},
{0.876407,0.348394},
{0.88421,0.346688},
{0.892061,0.343631},
{0.888775,0.336165},
{0.88462,0.328842},
{0.878929,0.322664},
{0.871643,0.31863},
{0.862887,0.316059},
{0.859996,0.320044},
{0.856285,0.324517},
{0.858906,0.330607},
{0.859512,0.335574},
{0.860616,0.34494},
{0.868751,0.349227},
{0.876903,0.354499},
{0.885368,0.353577},
{0.894264,0.350808},
{0.903538,0.34573},
{0.899861,0.338745},
{0.895263,0.331765},
{0.889606,0.32508},
{0.882771,0.319356},
{0.874638,0.315263},
{0.865464,0.312169},
{0.855505,0.309448},
{0.853481,0.313684},
{0.851078,0.31815},
{0.848559,0.322731},
{0.852849,0.328742},
{0.854305,0.334344},
{0.861168,0.349623},
{0.869036,0.354668},
{0.876827,0.360099},
{0.885881,0.359586},
{0.895778,0.357262},
{0.906434,0.352429},
{0.917439,0.345549},
{0.912856,0.338167},
{0.907418,0.331814},
{0.900633,0.325513},
{0.89379,0.320385},
{0.885668,0.315488},
{0.876986,0.311536},
{0.86722,0.30781},
{0.857319,0.304788},
{0.84681,0.301473},
{0.84504,0.30685},
{0.84324,0.311687},
{0.841341,0.316617},
{0.839608,0.321509},
{0.846187,0.327308},
{0.849098,0.333114},
{0.897126,0.314006},
{0.909273,0.307792},
{0.905832,0.318045},
{0.914539,0.322618},
{0.91968,0.310994},
{0.921301,0.296781},
{0.911041,0.2953},
{0.899606,0.305356},
{0.888216,0.310241},
{0.922353,0.328655},
{0.725283,0.320091},
{0.718943,0.323554},
{0.713106,0.328223},
{0.708141,0.33392},
{0.703619,0.340611},
{0.699871,0.348099},
{0.711074,0.351244},
{0.71959,0.357661},
{0.727779,0.35756},
{0.734474,0.357174},
{0.740522,0.356645},
{0.746207,0.356041},
{0.698212,0.327693},
{0.695328,0.313899},
{0.705092,0.321759},
{0.712853,0.317398},
{0.705649,0.309794},
{0.697203,0.300525},
{0.683842,0.304224},
{0.68654,0.320218},
{0.692159,0.335172},
{0.686879,0.344167},
{0.682493,0.354562},
{0.69659,0.356392},
{0.709168,0.357329},
{0.720036,0.362311},
{0.728015,0.361123},
{0.73391,0.360061},
{0.739347,0.358902},
{0.744555,0.357694},
{0.721158,0.3143},
{0.829771,0.320444},
{0.820468,0.313742},
{0.809616,0.312441},
{0.79869,0.311344},
{0.78785,0.310554},
{0.776741,0.316735},
{0.776124,0.323009},
{0.766062,0.322804},
{0.766566,0.316536},
{0.757036,0.316401},
{0.748245,0.31651},
{0.740091,0.316932},
{0.732418,0.318062},
{0.729673,0.312154},
{0.726615,0.305165},
{0.716325,0.307131},
{0.710968,0.298566},
{0.706282,0.288897},
{0.690213,0.290189},
{0.669742,0.291872},
{0.672639,0.311009},
{0.678736,0.328632},
{0.6718,0.339046},
{0.665914,0.351378},
{0.661557,0.365446},
{0.679123,0.366239},
{0.694271,0.365301},
{0.708348,0.363848},
{0.723976,0.366596},
{0.728708,0.364784},
{0.73344,0.362971},
{0.738172,0.361159},
{0.742904,0.359347},
{0.84389,0.331884},
{0.810856,0.305827},
{0.821851,0.307693},
{0.831091,0.315141},
{0.832672,0.309663},
{0.823454,0.301435},
{0.812381,0.298942},
{0.801169,0.296892},
{0.799782,0.304286},
{0.834348,0.304125},
{0.825244,0.294637},
{0.814142,0.291631},
{0.802762,0.289081},
{0.791154,0.28731},
{0.789858,0.295534},
{0.78873,0.303265},
{0.81609,0.283741},
{0.829537,0.279056},
{0.827295,0.287378},
{0.836158,0.298133},
{0.838143,0.291297},
{0.84041,0.283327},
{0.843066,0.273938},
{0.832047,0.269793},
{0.81819,0.275174},
{0.80451,0.280694},
{0.792536,0.278545},
{0.779434,0.286256},
{0.778545,0.294752},
{0.777827,0.302657},
{0.777196,0.310038},
{0.848714,0.295264},
{0.850879,0.287575},
{0.853522,0.278101},
{0.856542,0.267463},
{0.846044,0.263615},
{0.834654,0.259639},
{0.820407,0.265831},
{0.806322,0.271776},
{0.793935,0.269245},
{0.780323,0.277204},
{0.767676,0.285819},
{0.767323,0.294432},
{0.767022,0.302415},
{0.766828,0.309761},
{0.878898,0.306488},
{0.869186,0.302754},
{0.859093,0.299048},
{0.88062,0.29932},
{0.870963,0.295312},
{0.882397,0.289232},
{0.873054,0.28587},
{0.861066,0.291675},
{0.890121,0.302638},
{0.891715,0.291968},
{0.892897,0.280142},
{0.884271,0.277953},
{0.87545,0.274707},
{0.863474,0.282119},
{0.736628,0.303749},
{0.738426,0.310793},
{0.747447,0.310045},
{0.746533,0.302937},
{0.745635,0.294985},
{0.734816,0.295809},
{0.75687,0.309754},
{0.718591,0.277987},
{0.730298,0.26671},
{0.731654,0.277237},
{0.720525,0.287868},
{0.73303,0.286789},
{0.743878,0.276719},
{0.743048,0.266393},
{0.742291,0.255201},
{0.729185,0.255607},
{0.717089,0.267402},
{0.704046,0.278768},
{0.723383,0.296998},
{0.744751,0.286232},
{0.755817,0.276484},
{0.75555,0.26631},
{0.755289,0.255203},
{0.754976,0.243665},
{0.741468,0.243564},
{0.728096,0.244245},
{0.715531,0.256156},
{0.702583,0.267919},
{0.687377,0.279381},
{0.756105,0.285792},
{0.756313,0.294527},
{0.768024,0.276581},
{0.768346,0.266629},
{0.768618,0.255873},
{0.768829,0.24463},
{0.768967,0.233217},
{0.754532,0.231935},
{0.740439,0.231904},
{0.72694,0.232765},
{0.714427,0.244869},
{0.700801,0.256437},
{0.68627,0.268024},
{0.670072,0.278979},
{0.648422,0.284838},
{0.656458,0.301386},
{0.663002,0.320505},
{0.65434,0.332333},
{0.646724,0.346174},
{0.640225,0.361705},
{0.660357,0.382546},
{0.676262,0.378559},
{0.692167,0.374571},
{0.708071,0.370584},
{0.781204,0.267531},
{0.795284,0.259419},
{0.782032,0.257262},
{0.756566,0.302501},
{0.894254,0.251226},
{0.882204,0.253513},
{0.887192,0.245173},
{0.900579,0.245749},
{0.892695,0.238422},
{0.878436,0.240212},
{0.873612,0.249405},
{0.869642,0.26007},
{0.878455,0.263629},
{0.889316,0.257984},
{0.899158,0.259059},
{0.906216,0.25556},
{0.914548,0.251706},
{0.907771,0.240362},
{0.899039,0.231269},
{0.883747,0.231913},
{0.868263,0.235954},
{0.863735,0.245736},
{0.859897,0.256492},
{0.866329,0.271283},
{0.886283,0.267215},
{0.894098,0.262064},
{0.893739,0.269552},
{0.901437,0.269362},
{0.909625,0.267746},
{0.918548,0.265802},
{0.927824,0.264632},
{0.924796,0.246563},
{0.914646,0.233613},
{0.904851,0.223823},
{0.889175,0.22393},
{0.873068,0.226854},
{0.861296,0.22221},
{0.856947,0.232012},
{0.852868,0.242144},
{0.849272,0.252848},
{0.894483,0.215603},
{0.910176,0.214711},
{0.899431,0.206272},
{0.882937,0.208649},
{0.878092,0.21784},
{0.8657,0.212494},
{0.852027,0.207701},
{0.847948,0.218052},
{0.844486,0.228275},
{0.840898,0.238644},
{0.837735,0.249207},
{0.816277,0.220886},
{0.83396,0.214024},
{0.83088,0.224634},
{0.814013,0.231601},
{0.827947,0.235154},
{0.837098,0.203273},
{0.821041,0.19888},
{0.818586,0.209908},
{0.800826,0.216826},
{0.799325,0.227809},
{0.797938,0.238614},
{0.811949,0.242115},
{0.825254,0.245637},
{0.822756,0.255918},
{0.80815,0.262293},
{0.809955,0.252364},
{0.796609,0.249173},
{0.782742,0.246644},
{0.840323,0.192176},
{0.855747,0.197071},
{0.870075,0.20254},
{0.874335,0.192023},
{0.859716,0.186019},
{0.843668,0.180528},
{0.823544,0.187373},
{0.70332,0.207275},
{0.697939,0.222493},
{0.689623,0.215775},
{0.697458,0.197483},
{0.68169,0.206684},
{0.666981,0.218489},
{0.677556,0.227123},
{0.689474,0.232327},
{0.704382,0.227027},
{0.709017,0.215819},
{0.718515,0.201921},
{0.714155,0.190926},
{0.709695,0.179461},
{0.691318,0.186238},
{0.673705,0.195595},
{0.656893,0.207226},
{0.639961,0.22002},
{0.65209,0.231125},
{0.665491,0.242026},
{0.684642,0.243963},
{0.701971,0.234531},
{0.714289,0.234159},
{0.713143,0.224363},
{0.722188,0.211648},
{0.734425,0.198302},
{0.731649,0.18705},
{0.728678,0.175143},
{0.725582,0.162157},
{0.70494,0.166437},
{0.684786,0.173336},
{0.665245,0.182639},
{0.646437,0.19413},
{0.627782,0.207015},
{0.62248,0.233347},
{0.635774,0.242815},
{0.64648,0.25088},
{0.667905,0.256541},
{0.684466,0.25604},
{0.700028,0.24508},
{0.725203,0.22199},
{0.736932,0.209325},
{0.751207,0.197567},
{0.74968,0.185753},
{0.748091,0.173595},
{0.746459,0.160576},
{0.744921,0.146466},
{0.722473,0.147996},
{0.700099,0.152559},
{0.677929,0.158979},
{0.656395,0.167991},
{0.635672,0.179448},
{0.615129,0.192251},
{0.608699,0.2205},
{0.603235,0.247789},
{0.621719,0.253201},
{0.632769,0.258173},
{0.639784,0.263935},
{0.652498,0.259521},
{0.654614,0.268283},
{0.669832,0.267969},
{0.738996,0.220423},
{0.753811,0.220319},
{0.752641,0.20886},
{0.768345,0.19871},
{0.767985,0.186934},
{0.767639,0.174701},
{0.767318,0.161769},
{0.767097,0.147949},
{0.767051,0.133048},
{0.743596,0.130619},
{0.719464,0.132562},
{0.695065,0.137329},
{0.670811,0.143368},
{0.647183,0.151721},
{0.62466,0.163426},
{0.602642,0.176918},
{0.594645,0.205765},
{0.588272,0.232651},
{0.576957,0.252641},
{0.599928,0.261159},
{0.613611,0.261924},
{0.623739,0.264647},
{0.631303,0.268742},
{0.640023,0.273125},
{0.644474,0.268488},
{0.653616,0.276716},
{0.784162,0.2244},
{0.784858,0.21308},
{0.802394,0.205632},
{0.785435,0.201844},
{0.768707,0.210268},
{0.768953,0.22173},
{0.783513,0.23552},
{0.803984,0.194191},
{0.786206,0.189958},
{0.786915,0.177877},
{0.787797,0.165074},
{0.788702,0.151899},
{0.789947,0.13803},
{0.791208,0.124039},
{0.767091,0.117607},
{0.742974,0.111175},
{0.716504,0.116494},
{0.690034,0.121812},
{0.663563,0.127131},
{0.637093,0.13245},
{0.613523,0.146733},
{0.589953,0.161017},
{0.580529,0.190632},
{0.573039,0.21849},
{0.565582,0.241532},
{0.555322,0.257166},
{0.561955,0.266155},
{0.581699,0.262937},
{0.598688,0.270903},
{0.610984,0.269667},
{0.619495,0.269287},
{0.62364,0.273336},
{0.633284,0.279074},
{0.805673,0.182317},
{0.807536,0.169823},
{0.809729,0.156901},
{0.812406,0.143745},
{0.815325,0.130471},
{0.826253,0.175235},
{0.829357,0.162643},
{0.833272,0.14992},
{0.839442,0.136903},
{0.929903,0.281016},
{0.93161,0.297423},
{0.932192,0.315548},
{0.944658,0.31122},
{0.941581,0.296368},
{0.939264,0.280761},
{0.937066,0.26534},
{0.920542,0.281282},
{0.910872,0.281409},
{0.901221,0.293843},
{0.901867,0.281252},
{0.954503,0.308374},
{0.951091,0.294591},
{0.948004,0.28051},
{0.945764,0.266671},
{0.944666,0.253926},
{0.936188,0.251002},
{0.937833,0.238648},
{0.929173,0.232598},
{0.920022,0.224053},
{0.924739,0.213284},
{0.914837,0.204675},
{0.904301,0.196133},
{0.88756,0.198715},
{0.956479,0.280128},
{0.960523,0.267756},
{0.964594,0.279716},
{0.960023,0.293069},
{0.968665,0.291676},
{0.963661,0.306017},
{0.972736,0.303635},
{0.975048,0.316665},
{0.967014,0.318797},
{0.970264,0.331384},
{0.97736,0.329695},
{0.973591,0.343753},
{0.979672,0.342725},
{0.976958,0.356012},
{0.981984,0.355755},
{0.953407,0.267371},
{0.956452,0.255796},
{0.951694,0.255808},
{0.958528,0.321259},
{0.962698,0.33339},
{0.967306,0.344981},
{0.971931,0.35627},
{0.952226,0.24645},
{0.945638,0.243001},
{0.947856,0.233441},
{0.941091,0.227849},
{0.933404,0.221309},
{0.938258,0.211078},
{0.929637,0.202912},
{0.919804,0.19418},
{0.909372,0.185384},
{0.892208,0.188152},
{0.424104,0.215186},
{0.401826,0.214817},
{0.382596,0.213492},
{0.397205,0.227812},
{0.420828,0.226027},
{0.446522,0.222697},
{0.449944,0.216643},
{0.342946,0.202073},
{0.352708,0.211778},
{0.340863,0.211835},
{0.331412,0.203371},
{0.330031,0.212063},
{0.337711,0.221083},
{0.34877,0.222299},
{0.361782,0.224028},
{0.366322,0.212187},
{0.355322,0.200767},
{0.343097,0.19204},
{0.331414,0.194664},
{0.319782,0.196009},
{0.319946,0.204047},
{0.319164,0.211948},
{0.327627,0.220146},
{0.332918,0.229442},
{0.34302,0.232291},
{0.354926,0.235741},
{0.36984,0.23949},
{0.377725,0.226506},
{0.32968,0.18654},
{0.319256,0.188731},
{0.307775,0.203492},
{0.307347,0.211107},
{0.317481,0.219239},
{0.32414,0.227342},
{0.32682,0.236795},
{0.334971,0.241716},
{0.345001,0.247217},
{0.357948,0.252377},
{0.369662,0.258935},
{0.389421,0.243699},
{0.318073,0.183115},
{0.31849,0.242434},
{0.324587,0.249202},
{0.33175,0.259955},
{0.346028,0.26526},
{0.355607,0.271672},
{0.375987,0.26863},
{0.394993,0.256063},
{0.417354,0.23588},
{0.4431,0.22875},
{0.319507,0.233375},
{0.314915,0.225618},
{0.313143,0.237776},
{0.307969,0.245729},
{0.311831,0.253377},
{0.327087,0.27663},
{0.338053,0.278233},
{0.345863,0.28289},
{0.360587,0.280948},
{0.379618,0.279895},
{0.398497,0.266882},
{0.417376,0.253869},
{0.416668,0.245046},
{0.439677,0.234803},
{0.311922,0.231227},
{0.304681,0.22447},
{0.302952,0.230124},
{0.309225,0.234833},
{0.306231,0.218115},
{0.294211,0.217025},
{0.29317,0.223456},
{0.292675,0.229646},
{0.302421,0.235265},
{0.304463,0.240079},
{0.630881,0.947663},
{0.647016,0.946972},
{0.63785,0.953205},
{0.622289,0.952938},
{0.629313,0.958275},
{0.636439,0.963394},
{0.644947,0.958154},
{0.654465,0.952626},
{0.665771,0.947808},
{0.65736,0.940282},
{0.6392,0.9414},
{0.624837,0.941085},
{0.615431,0.946184},
{0.606875,0.951267},
{0.614197,0.957483},
{0.620878,0.963127},
{0.628164,0.967348},
{0.635184,0.970582},
{0.644288,0.966733},
{0.653209,0.961707},
{0.659071,0.956775},
{0.668833,0.955667},
{0.684796,0.953548},
{0.680671,0.943135},
{0.668941,0.932959},
{0.646476,0.933887},
{0.632664,0.937599},
{0.620514,0.933025},
{0.607883,0.938585},
{0.597671,0.945329},
{0.601457,0.954923},
{0.605619,0.960347},
{0.612697,0.965958},
{0.620821,0.970267},
{0.627927,0.972073},
{0.64107,0.973262},
{0.653384,0.96919},
{0.663671,0.963059},
{0.677946,0.963033},
{0.697647,0.962452},
{0.70873,0.951078},
{0.700973,0.938045},
{0.682579,0.924761},
{0.653673,0.924504},
{0.633926,0.930757},
{0.617202,0.922908},
{0.599629,0.929832},
{0.585011,0.938851},
{0.577999,0.948709},
{0.592645,0.95281},
{0.595571,0.96058},
{0.603906,0.967493},
{0.615108,0.972401},
{0.627917,0.974569},
{0.646577,0.976363},
{0.663814,0.97043},
{0.676098,0.972325},
{0.689295,0.973819},
{0.72006,0.961593},
{0.750826,0.949367},
{0.723976,0.932747},
{0.697126,0.916127},
{0.661753,0.912628},
{0.635979,0.920365},
{0.614188,0.910157},
{0.58971,0.919914},
{0.567321,0.931013},
{0.555818,0.943001},
{0.563995,0.95542},
{0.582286,0.958749},
{0.594501,0.967304},
{0.610106,0.974767},
{0.628092,0.978017},
{0.652459,0.980856},
{0.658529,0.986044},
{0.374142,0.923099},
{0.360165,0.922438},
{0.367121,0.917394},
{0.381201,0.91911},
{0.374091,0.913509},
{0.367048,0.90811},
{0.360477,0.912329},
{0.353375,0.916883},
{0.352513,0.92816},
{0.367724,0.92812},
{0.380653,0.929651},
{0.388569,0.925813},
{0.396044,0.921905},
{0.388216,0.915684},
{0.381128,0.909826},
{0.374115,0.905116},
{0.367999,0.901318},
{0.360243,0.904335},
{0.353385,0.908573},
{0.349193,0.91288},
{0.344718,0.920885},
{0.333156,0.924854},
{0.344112,0.934726},
{0.362633,0.93464},
{0.374133,0.932158},
{0.385766,0.937253},
{0.39657,0.933133},
{0.40528,0.927706},
{0.400674,0.918841},
{0.396055,0.913595},
{0.388646,0.907697},
{0.380927,0.902848},
{0.374675,0.900396},
{0.363602,0.898194},
{0.353137,0.901438},
{0.345023,0.906797},
{0.341477,0.913527},
{0.328818,0.915038},
{0.309844,0.916921},
{0.317341,0.929308},
{0.334074,0.942122},
{0.357974,0.943112},
{0.374058,0.938334},
{0.390161,0.946583},
{0.405214,0.941284},
{0.417515,0.933928},
{0.422947,0.925132},
{0.409188,0.921144},
{0.405585,0.913617},
{0.397194,0.906411},
{0.386735,0.900808},
{0.375205,0.897753},
{0.360174,0.89468},
{0.345731,0.899719},
{0.333962,0.906288},
{0.318775,0.906333},
{0.301524,0.906655},
{0.275352,0.917971},
{0.299401,0.934005},
{0.32345,0.950038},
{0.352852,0.95399},
{0.373801,0.947808},
{0.394517,0.958315},
{0.415406,0.950555},
{0.434342,0.941415},
{0.443681,0.930756},
{0.435775,0.918439},
{0.418321,0.915362},
{0.406833,0.906276},
{0.392361,0.898152},
{0.376316,0.893935},
{0.377906,0.887331},
{0.356966,0.889714},
{0.336894,0.897334},
{0.327696,0.895339},
{0.347499,0.966072},
{0.373169,0.960769},
{0.398853,0.971248},
{0.42616,0.960391},
{0.453466,0.949534},
{0.480772,0.938676},
{0.455589,0.922184},
{0.430406,0.905691},
{0.418226,0.905767},
{0.398631,0.894039},
{0.405223,0.889198},
{0.38004,0.872706},
{0.353868,0.884022},
{0.547117,0.922496},
{0.57922,0.909293},
{0.611323,0.89609},
{0.638841,0.906233},
{0.643425,0.882887},
{0.670275,0.899507},
{0.515015,0.935699},
{0.543202,0.951342},
{0.571389,0.966985},
{0.583228,0.967478},
{0.604894,0.978385},
{0.628226,0.984167},
{0.627764,0.99827},
{0.599576,0.982628},
{0.466212,0.581429},
{0.482679,0.589544},
{0.470993,0.595329},
{0.453765,0.571874},
{0.456182,0.585446},
{0.479266,0.621214},
{0.489311,0.600458},
{0.499356,0.579702},
{0.49224,0.574945},
{0.476881,0.579741},
{0.472749,0.572159},
{0.46434,0.573191},
{0.453943,0.564519},
{0.445266,0.55059},
{0.440576,0.55139},
{0.440131,0.567599},
{0.459898,0.602127},
{0.474256,0.558067},
{0.479771,0.564752},
{0.485524,0.569542},
{0.486003,0.554296},
{0.480758,0.549772},
{0.476929,0.543255},
{0.469248,0.549809},
{0.468458,0.56471},
{0.463254,0.566666},
{0.456741,0.560093},
{0.449568,0.548141},
{0.446261,0.536501},
{0.442015,0.535846},
{0.438076,0.530458},
{0.43219,0.518805},
{0.428372,0.534587},
{0.424725,0.549489},
{0.440531,0.58304},
{0.497062,0.544746},
{0.492648,0.557082},
{0.500678,0.558385},
{0.505852,0.543851},
{0.505621,0.535332},
{0.497996,0.536049},
{0.490231,0.543792},
{0.48531,0.54359},
{0.484501,0.537962},
{0.473801,0.535793},
{0.465093,0.54022},
{0.456268,0.544777},
{0.462181,0.555305},
{0.453071,0.533958},
{0.446797,0.527765},
{0.44392,0.523436},
{0.441643,0.516565},
{0.437618,0.505763},
{0.433175,0.490402},
{0.42533,0.504018},
{0.417486,0.517634},
{0.409641,0.53125},
{0.421164,0.563953},
{0.509401,0.558946},
{0.507915,0.530515},
{0.501948,0.53012},
{0.50215,0.526678},
{0.496798,0.525508},
{0.495549,0.530351},
{0.51368,0.534353},
{0.519446,0.53819},
{0.489579,0.530568},
{0.482316,0.532549},
{0.485801,0.52569},
{0.479193,0.527051},
{0.470659,0.528429},
{0.491239,0.536243},
{0.491373,0.524968},
{0.484285,0.519868},
{0.479547,0.521219},
{0.47602,0.523291},
{0.469034,0.521857},
{0.460157,0.521751},
{0.461514,0.530505},
{0.490005,0.520085},
{0.481402,0.512442},
{0.474669,0.513513},
{0.470459,0.516768},
{0.46027,0.514483},
{0.450715,0.51651},
{0.451562,0.524114},
{0.449301,0.508912},
{0.446094,0.499081},
{0.44199,0.488134},
{0.456009,0.49597},
{0.450804,0.485866},
{0.465757,0.493643},
{0.459618,0.483598},
{0.475421,0.491708},
{0.468433,0.48133},
{0.924585,0.183534},
{0.934625,0.192739},
{0.944666,0.201943},
{0.949366,0.209059},
{0.945053,0.218173},
{0.954067,0.216174},
{0.950811,0.224595},
{0.958767,0.22329},
{0.956323,0.230743},
{0.963467,0.230405},
{0.961713,0.236753},
{0.954077,0.238396},
{0.959959,0.243101},
{0.958206,0.249448},
{0.914544,0.174329},
{0.89751,0.177035},
{0.878699,0.181029},
{0.863449,0.174562},
{0.847301,0.168505},
{0.847714,0.360296},
{0.847408,0.363957},
{0.844502,0.359871},
{0.846081,0.356324},
{0.841595,0.355786},
{0.844447,0.352351},
{0.849348,0.364269},
{0.850315,0.368043},
{0.850981,0.368241},
{0.851475,0.364632},
{0.851223,0.360798},
{0.850753,0.356913},
{0.850205,0.353003},
{0.851648,0.36844},
{0.853976,0.365096},
{0.855262,0.361451},
{0.855799,0.357604},
{0.855963,0.353655},
{0.861641,0.358449},
{0.86172,0.354306},
{0.860512,0.36239},
{0.858224,0.366005},
{0.865591,0.367703},
{0.867597,0.363815},
{0.868698,0.3595},
{0.852315,0.368639},
{0.852982,0.368837},
{0.863133,0.371378},
{0.873284,0.373919},
{0.874845,0.369526},
{0.876132,0.364721},
{0.883387,0.169647},
{0.904503,0.165124},
{0.888238,0.158069},
{0.867761,0.162851},
{0.871973,0.151014},
{0.85139,0.156282},
{0.855707,0.143958},
{0.393479,0.752977},
{0.377463,0.773803},
{0.361811,0.746705},
{0.350155,0.769363},
{0.361448,0.794629},
{0.338262,0.791261},
{0.345432,0.815455},
{0.32625,0.812779},
{0.307068,0.810102},
{0.287886,0.807426},
{0.268705,0.80475},
{0.371566,0.72393},
{0.377758,0.701684},
{0.384513,0.681504},
{0.347888,0.653078},
{0.333707,0.612749},
{0.302684,0.616894},
{0.323816,0.291325},
{0.333606,0.290848},
{0.340033,0.290817},
{0.349731,0.291219},
{0.360739,0.292908},
{0.322425,0.305028},
{0.332267,0.302652},
{0.341074,0.298701},
{0.351677,0.302345},
{0.363585,0.310039},
{0.353718,0.315393},
{0.366431,0.327171},
{0.355806,0.329495},
{0.357889,0.343783},
{0.369277,0.344302},
{0.35997,0.358164},
{0.372123,0.361433},
{0.321942,0.31772},
{0.332584,0.313884},
{0.34226,0.309133},
{0.343632,0.320416},
{0.344952,0.331857},
{0.346397,0.343469},
{0.347817,0.354895},
{0.292617,0.235389},
{0.896427,0.363349},
{0.885694,0.365176},
{0.884753,0.370807},
{0.896131,0.370165},
{0.909799,0.366215},
{0.908527,0.359153},
{0.883435,0.376459},
{0.893585,0.379},
{0.910658,0.373446},
{0.927731,0.367892},
{0.924545,0.360491},
{0.921054,0.3528},
{0.928384,0.337086},
{0.944982,0.340124},
{0.933647,0.34626},
{0.939163,0.354526},
{0.951802,0.349505},
{0.960613,0.346611},
{0.954599,0.336095},
{0.93903,0.329282},
{0.944804,0.362339},
{0.961877,0.356785},
{0.966904,0.356527},
{0.949139,0.32438},
{0.294766,0.209933},
{0.325885,0.580428},
{0.298274,0.585332},
{0.374414,0.634434},
{0.380969,0.58713},
{0.395357,0.618639},
{0.395957,0.664926},
{0.409745,0.650149},
{0.420474,0.694282},
{0.424133,0.681659},
{0.358816,0.601672},
{0.366581,0.55562},
{0.349578,0.570739},
{0.416814,0.706905},
{0.322305,0.553361},
{0.295904,0.558876},
{0.413154,0.719528},
{0.382162,0.422373},
{0.388869,0.417427},
{0.387723,0.422423},
{0.381664,0.426972},
{0.386531,0.427438},
{0.394183,0.422617},
{0.395216,0.416313},
{0.388965,0.413938},
{0.384244,0.41338},
{0.382859,0.417822},
{0.377097,0.422446},
{0.377116,0.426931},
{0.377432,0.431442},
{0.381856,0.431562},
{0.385455,0.431061},
{0.391746,0.428935},
{0.40174,0.423148},
{0.40336,0.414868},
{0.393279,0.411364},
{0.386805,0.409108},
{0.37815,0.408898},
{0.377549,0.413541},
{0.377169,0.417955},
{0.372123,0.422513},
{0.372857,0.426712},
{0.373317,0.430853},
{0.372836,0.434912},
{0.377944,0.436209},
{0.38323,0.436089},
{0.388047,0.433887},
{0.397822,0.431174},
{0.405273,0.433865},
{0.411804,0.424136},
{0.414761,0.413476},
{0.399926,0.408536},
{0.390935,0.404866},
{0.379071,0.404986},
{0.369666,0.410088},
{0.37118,0.414106},
{0.371782,0.41828},
{0.367249,0.422554},
{0.368692,0.426806},
{0.370091,0.429971},
{0.368224,0.432108},
{0.365676,0.434559},
{0.371902,0.438797},
{0.378668,0.44021},
{0.385408,0.440532},
{0.391983,0.437144},
{0.396797,0.441249},
{0.402075,0.444828},
{0.413961,0.436871},
{0.423791,0.426121},
{0.430198,0.413801},
{0.41091,0.404675},
{0.397021,0.400516},
{0.379291,0.400052},
{0.363918,0.402333},
{0.367243,0.406178},
{0.363338,0.412821},
{0.366833,0.415002},
{0.366505,0.41823},
{0.361911,0.422489},
{0.364426,0.427706},
{0.360087,0.428972},
{0.355707,0.430165},
{0.363148,0.437257},
{0.371003,0.442416},
{0.379285,0.445126},
{0.388009,0.44487},
{0.398456,0.389437},
{0.424679,0.386349},
{0.426004,0.390403},
{0.401115,0.392641},
{0.428621,0.394516},
{0.449541,0.392567},
{0.442133,0.387347},
{0.433807,0.382477},
{0.432694,0.382302},
{0.396424,0.386762},
{0.370508,0.391231},
{0.375308,0.393171},
{0.401577,0.396345},
{0.427991,0.40079},
{0.456271,0.406372},
{0.455111,0.398484},
{0.470234,0.396534},
{0.453791,0.389264},
{0.434919,0.382651},
{0.464657,0.391608},
{0.436031,0.382826},
{0.475128,0.394166},
{0.437143,0.383},
{0.363793,0.388475},
{0.394705,0.384351},
{0.345629,0.394106},
{0.353918,0.396416},
{0.378598,0.396645},
{0.45045,0.417502},
{0.486588,0.412986},
{0.483347,0.40387},
{0.516095,0.409998},
{0.49183,0.400597},
{0.513113,0.405332},
{0.356716,0.386401},
{0.33321,0.391382},
{0.329812,0.40053},
{0.339672,0.402446},
{0.35953,0.398947},
{0.318726,0.38845},
{0.313563,0.397303},
{0.31374,0.40806},
{0.32634,0.410021},
{0.3353,0.411329},
{0.34232,0.412499},
{0.346746,0.40443},
{0.476084,0.423195},
{0.43912,0.429517},
{0.456111,0.433947},
{0.507665,0.429493},
{0.525393,0.419675},
{0.423753,0.440055},
{0.43331,0.443713},
{0.475452,0.439099},
{0.542219,0.436093},
{0.589083,0.427663},
{0.551098,0.416497},
{0.495356,0.444524},
{0.441295,0.448141},
{0.448493,0.452954},
{0.411532,0.454564},
{0.401629,0.461384},
{0.392502,0.456314},
{0.389991,0.458936},
{0.379286,0.45488},
{0.378353,0.456489},
{0.366715,0.454041},
{0.366963,0.45175},
{0.355077,0.451593},
{0.354149,0.44545},
{0.339458,0.434504},
{0.336492,0.43632},
{0.325214,0.421259},
{0.317907,0.421046},
{0.299322,0.405773},
{0.280737,0.3905},
{0.411039,0.45059},
{0.393862,0.45378},
{0.380059,0.45258},
{0.367513,0.449587},
{0.355509,0.44277},
{0.342793,0.432971},
{0.332854,0.421481},
{0.338474,0.421652},
{0.344846,0.421904},
{0.350438,0.422105},
{0.349098,0.414046},
{0.353116,0.407088},
{0.35919,0.410239},
{0.35544,0.415713},
{0.36115,0.417241},
{0.356951,0.422334},
{0.351296,0.431202},
{0.360577,0.439441},
{0.369978,0.445476},
{0.379885,0.448331},
{0.390643,0.448651},
{0.392918,0.451424},
{0.407352,0.447798},
{0.38013,0.451272},
{0.368666,0.447681},
{0.357815,0.441106},
{0.346865,0.432004},
{0.482409,0.502085},
{0.472738,0.503366},
{0.462264,0.506664},
{0.489397,0.512463},
{0.496385,0.522841},
{0.336754,0.508239},
{0.331154,0.496224},
{0.349013,0.491269},
{0.35745,0.505005},
{0.366871,0.486313},
{0.380193,0.499924},
{0.38473,0.481358},
{0.320148,0.507781},
{0.313296,0.501179},
{0.308444,0.503271},
{0.306838,0.517622},
{0.321314,0.528529},
{0.350155,0.524533},
{0.375656,0.518489},
{0.297949,0.508264},
{0.302454,0.49435},
{0.292638,0.497304},
{0.288923,0.524031},
{0.293484,0.538213},
{0.347111,0.545735},
{0.371118,0.537055},
{0.27883,0.367232},
{0.281519,0.354585},
{0.288051,0.367559},
{0.295899,0.353213},
{0.282591,0.341601},
{0.268801,0.37957},
{0.275331,0.37971},
{0.281861,0.37985},
{0.288392,0.37999},
{0.295502,0.369475},
{0.30337,0.359703},
{0.310112,0.344766},
{0.296239,0.339242},
{0.309416,0.334597},
{0.321809,0.329248},
{0.322149,0.338741},
{0.333814,0.334838},
{0.333105,0.324778},
{0.312751,0.351414},
{0.309216,0.364244},
{0.323307,0.345678},
{0.334695,0.343565},
{0.316363,0.356301},
{0.32351,0.348357},
{0.335664,0.351626},
{0.302069,0.372187},
{0.294922,0.38013},
{0.27934,0.48605},
{0.289767,0.484501},
{0.309526,0.481102},
{0.299751,0.483057},
{0.311411,0.491141},
{0.613376,0.277111},
{0.600029,0.280268},
{0.582766,0.272899},
{0.583116,0.283009},
{0.604207,0.292645},
{0.621969,0.284647},
{0.637949,0.292669},
{0.645124,0.311795},
{0.635039,0.324678},
{0.625589,0.340224},
{0.616832,0.356454},
{0.634284,0.378082},
{0.625515,0.302527},
{0.614437,0.31673},
{0.566382,0.1753},
{0.557833,0.204588},
{0.550357,0.230094},
{0.543702,0.248829},
{0.537387,0.262094},
{0.543727,0.269714},
{0.546607,0.278466},
{0.56464,0.275636},
{0.608211,0.373618},
{0.593087,0.35113},
{0.582138,0.369154},
{0.570201,0.34546},
{0.556065,0.36469},
{0.549386,0.339171},
{0.5362,0.354987},
{0.530115,0.332372},
{0.516335,0.345283},
{0.511862,0.325172},
{0.49647,0.33558},
{0.496234,0.31623},
{0.476605,0.325877},
{0.484835,0.304206},
{0.467587,0.30982},
{0.476889,0.290416},
{0.458569,0.293763},
{0.449551,0.277706},
{0.471621,0.276173},
{0.440532,0.261649},
{0.473932,0.261753},
{0.466102,0.243633},
{0.488727,0.247432},
{0.491672,0.225616},
{0.51058,0.233141},
{0.517242,0.2076},
{0.534066,0.218808},
{0.542812,0.189584},
{0.582299,0.32801},
{0.603899,0.333518},
{0.593411,0.310569},
{0.572839,0.308275},
{0.561842,0.32354},
{0.564966,0.285457},
{0.580542,0.294418},
{0.561644,0.296106},
{0.547908,0.287734},
{0.545646,0.297066},
{0.553916,0.307529},
{0.528899,0.281331},
{0.53186,0.290461},
{0.534275,0.296732},
{0.537837,0.306011},
{0.542934,0.319725},
{0.526554,0.27266},
{0.509974,0.274041},
{0.511827,0.28428},
{0.516739,0.294259},
{0.525234,0.302122},
{0.526052,0.315178},
{0.509284,0.25153},
{0.513745,0.264403},
{0.496387,0.262785},
{0.492244,0.274874},
{0.525704,0.266294},
{0.525705,0.256225},
{0.528338,0.24086},
{0.511906,0.308506},
{0.501435,0.298913},
{0.495044,0.287182},
{0.10853,0.16596},
{0.253799,0.393043},
{0.371547,0.982105},
{0.436255,0.240856},
{0.409494,0.732152},
{0.401796,0.544866}
};


// normal array: 34kb.
const tgx::fVec3 spot_norm_array[2930] PROGMEM = {
{0.5621717947196511,-0.8269486488879928,-0.010899785502929303},
{0.43675530311641314,-0.8969615543069897,-0.06859136457951172},
{0.5919534745429351,-0.8038286211265404,-0.058742078907299516},
{0.790626284815176,-0.6118281157912261,0.024009050100121585},
{0.7890403717315638,-0.6139926083347919,-0.020697069549922006},
{0.5757549991223703,-0.8172271768799673,-0.02541500254570542},
{0.4193446842686561,-0.9078252141471082,0.0018483328645734348},
{0.3614374526443727,-0.9299792575055131,-0.06709357968868163},
{0.40148951319762305,-0.9154954132819281,-0.025967653958096366},
{0.541962127352223,-0.8394657755374564,0.039676998590491015},
{0.7738932886979388,-0.6290709672251916,0.0732044800722645},
{0.9170084270647194,-0.38854610133868533,0.09015249207202859},
{0.9319280613559172,-0.3572907167187344,0.06207601955678761},
{0.9303118355684556,-0.365224413930274,0.03363058236990135},
{0.787501583586068,-0.6162763483830783,0.00668717227634359},
{0.5865390095484823,-0.7946947781096241,0.15630802897861887},
{0.36709253192845226,-0.8888262450302755,0.27428266286394953},
{0.32173127785441263,-0.9468137949785872,-0.005711609966757961},
{0.4200834641053345,-0.9036658298872802,-0.08317422124309569},
{0.3563887059208082,-0.9339545732118085,-0.026757157338554903},
{0.385766107818431,-0.922536375559943,0.010542572140723737},
{0.531243215494729,-0.8469387355742016,-0.02180422378332447},
{0.7354933651307837,-0.6765001190683608,0.03737778416505345},
{0.9167945868008823,-0.39300861467867565,0.07093598805224034},
{0.9709963551362651,-0.21882100560534432,0.09635063994574072},
{0.9774861723544872,-0.1926551187510671,0.08605107828950188},
{0.9776722653671499,-0.19786338320102118,0.07076032165070502},
{0.9318112025244112,-0.36151814814417665,0.032132715609107645},
{0.8543417079346614,-0.5043652871651856,0.12536308542017302},
{0.6190923190673907,-0.5179600163288264,0.5902898626576625},
{0.1738891013467346,-0.5672023633861841,0.8050118380508153},
{0.17608419948554288,-0.9438818103407897,0.2794306404089022},
{0.35307050580952,-0.93308836202411,-0.06846405321461123},
{-0.24630484352336637,-0.554619213056521,0.7948153575299709},
{0.03954624563916638,-0.9850160999363441,0.16786714187726176},
{0.28471177322379293,-0.8871062945481218,-0.3632927584756742},
{0.5371460457075239,-0.5506233196511023,-0.6389742447369616},
{0.10929148527564131,-0.549902889583275,-0.8280472107761784},
{0.1113278992633373,-0.9178466297019077,-0.3810034949845755},
{-0.3039401517299598,-0.4926946744621318,-0.8153970455692263},
{0.0036041723308793423,-0.9641648655254768,-0.265279328308952},
{-0.6043464939503107,-0.6128636699493666,-0.509080973231333},
{0.4949291940189584,-0.8347710304934304,-0.24125177627673683},
{0.801980896575008,-0.5860110120148232,-0.1158349486386074},
{0.3597358936442617,-0.930326824993803,-0.07128874750558004},
{0.27257347533928367,-0.9595709721565131,-0.07019437253846686},
{0.34618759451805137,-0.9375087112153759,0.035093671752753845},
{0.9411817413504067,-0.33564980782817555,0.03893759434691752},
{0.9771295501763694,-0.194380525057732,0.08622095830137001},
{0.9889933206169508,-0.11056818368417783,0.09832033630861386},
{0.9903871198531102,-0.09654730668172587,0.09905539057298095},
{0.9909251830535585,-0.09813397199111352,0.091853171592051},
{0.9801787341563174,-0.1914305002588968,0.051029527514449634},
{0.9500006945457793,-0.31109612776653034,0.026793276231310767},
{0.9768365105085136,-0.1923052084643265,0.09385701111287598},
{0.9026754938026856,-0.29371452296757944,0.31449758645497594},
{0.3377184347296083,-0.9412107207320077,0.008284806751982355},
{0.4828923238556363,-0.8756098350018522,-0.011064375686525305},
{0.4546293087540663,-0.8876835042359417,0.07300813604796921},
{0.3269141394900666,0.04114403760680152,-0.9441579918482285},
{0.1369281240295299,-0.1209253360042547,-0.9831722900702664},
{0.41618371637807966,0.02683656450473151,-0.9088844332627298},
{0.7156436646339737,0.12123404893031409,-0.6878636860957401},
{0.7358963172435122,0.15168728010911697,-0.6598845196854781},
{0.5136318382292835,0.04441665620780959,-0.8568602543055224},
{0.3027818111465638,-0.13576488003259696,-0.9433403798144873},
{0.20248135100236175,-0.33633268286920104,-0.9197182334444955},
{-0.01005597099803868,-0.2886732595554025,-0.9573748621438448},
{-0.0017426117538017248,-0.03004636047377403,-0.999546987152958},
{0.17317855199995957,-0.5042590740238477,-0.8460094416682411},
{-0.0671845904814192,-0.4860343362171542,-0.8713534614723203},
{-0.24851667607065836,-0.13220508907657685,-0.9595630652213776},
{0.4278575573573702,-0.08304908543622587,-0.900022644170907},
{0.4123091185935207,-0.10024528135029118,-0.9055120508815082},
{0.49683003181548857,0.01985964597495302,-0.867620604842906},
{0.5677680495746962,0.060245360428058045,-0.8209810828691722},
{0.6231328451461939,0.1316553291360839,-0.7709554666840872},
{0.5271402703273236,0.1402340631835858,-0.8381274025601706},
{0.441467500181395,0.06660979204407669,-0.8948014203651192},
{0.3801952717176796,-0.012801656767492058,-0.9248176430775568},
{0.33961724438779933,-0.20467406296868304,-0.9180243217161129},
{0.3459864793796737,-0.25726264377776425,-0.9022800497644475},
{0.7507673903065926,0.169225781919635,-0.6385224822869723},
{0.7733655201748382,0.190755025016889,-0.6045810885526505},
{0.6489294268682961,0.19611794266086136,-0.7351383213456196},
{0.5542261826284457,0.2540476139546989,-0.7926494485792728},
{0.4860114161486095,0.18811843946263335,-0.8534660837475422},
{0.45527382036108077,0.10374042029644816,-0.8842870991315789},
{0.41378530834735505,0.01042063619217928,-0.9103148515416161},
{0.303809634624647,-0.09128814583548207,-0.9483491869238663},
{0.24384474350931382,-0.2797098984971156,-0.928602236560741},
{0.2894128934725407,-0.4001835490530424,-0.8695362581049528},
{0.21954562198161237,-0.48385261899255894,-0.8471637167411908},
{0.16505664938729936,-0.6028582706776661,-0.7805883729396512},
{-0.01118627785442927,-0.6560636179830748,-0.7546226847549189},
{-0.5227390701007779,-0.31577317732180504,-0.7918529946109099},
{0.9096343421612204,0.18880515716043952,-0.37002429135199427},
{0.8998117063740723,0.17859242446377604,-0.398049794619129},
{0.798367700759913,0.20769298102943864,-0.5652191079700289},
{0.6615885678635148,0.2879110284045397,-0.692392812351012},
{0.5973351689248079,0.35130246229266615,-0.7209558072119824},
{0.5702205227031917,0.26829840830583745,-0.7764435070168678},
{0.5681721929063728,0.15118231220389441,-0.8089031262670753},
{0.5350714795333198,0.028071749610065023,-0.8443402682946336},
{0.4303742365257911,-0.05658389988195217,-0.900875284825259},
{0.30895719347316514,-0.07342257961283151,-0.9482376165308897},
{0.19514797571201759,-0.15854736559911328,-0.9678739589621589},
{0.1296412295510575,-0.3272360822269022,-0.9360073173267813},
{0.6782333404380149,0.3793892015805621,-0.6293356573739926},
{0.7986950124499987,0.269706059033808,-0.5379079092260572},
{0.6480711016663054,0.42444591079911587,-0.6323365527873034},
{0.6581993386484641,0.354799478935766,-0.6639962050717108},
{0.7298768398710754,0.1571452629222142,-0.6652707456073207},
{0.6635360906150626,-0.030670989704438264,-0.7475153154563656},
{0.5220223354906299,-0.12525196507014336,-0.8436851465416324},
{0.31548333462049527,-0.15929570647013172,-0.9354652016386896},
{0.23336292095539243,-0.11453258989309748,-0.9656210607560021},
{0.15399840286872907,-0.13018246648238854,-0.9794575117555853},
{0.07764921302098098,-0.2046943728524693,-0.9757411610871791},
{0.03262464412619793,-0.35312430035481773,-0.9350074123206508},
{0.12530547736391934,-0.5200311177800456,-0.8449060148223805},
{0.13103139626664922,-0.6457875796343386,-0.7521895872600437},
{0.10676382794100976,-0.7269354424369882,-0.6783556202850557},
{-0.17211390302990062,-0.7506210738089507,-0.6379222585375994},
{-0.4019504652615172,-0.720957325818135,-0.5644965525361635},
{-0.897573695943892,-0.24108686126472648,-0.3691051146694452},
{-0.5113023375556941,-0.78855155994098,-0.3416962934020945},
{-0.9741910539015601,-0.22545856044411686,0.010964853881104386},
{-0.4527615021276172,-0.8758910809997174,-0.16679879021231028},
{-0.9144416604579173,-0.22532711689279375,0.33619063046395026},
{-0.24298607796000601,-0.968372885645178,-0.056672041297670984},
{-0.5862588444397177,-0.5881972193267503,0.5570678580680147},
{0.7965368238001882,0.35462552191705937,-0.48966297341677895},
{0.8922404651830628,0.23070606745064787,-0.3881773598902552},
{0.8904533939496593,0.30238420036236785,-0.34008314950133056},
{0.7998567426298757,0.42243397970150287,-0.42635516188158795},
{0.7052684376865727,0.4443511071720492,-0.5524025021287604},
{0.6956167518734124,0.46832102204732856,-0.5447868893628307},
{0.7117997588777987,0.4188798660023633,-0.5638091531000092},
{0.8211391386137401,0.26404388857539346,-0.5059756317676476},
{0.8873664908760682,-0.06771489239068028,-0.45606513155339024},
{0.7483381375052267,-0.20680745729288658,-0.6302544784158692},
{0.5666546741648651,-0.2989829420188232,-0.7677966401521172},
{0.2963357867685627,-0.33108504778172937,-0.8958614807076074},
{0.021880340192730687,-0.18592017846238176,-0.9823211989739236},
{0.0,-0.13372536384332478,-0.9910184292256983},
{4.637501138400432e-18,-0.15834451145764972,-0.9873839251736065},
{0.0,-0.23925833186247358,-0.9709559468041723},
{0.0,-0.3918753672563034,-0.9200183131534595},
{0.04036256285845272,-0.5276756527645942,-0.8484864577581405},
{0.08009976255251007,-0.6521640800824998,-0.7538342262654157},
{0.12180641923710034,-0.7282620954728366,-0.6743867707259306},
{0.11862223870733503,-0.7739066369332851,-0.6220910558709815},
{0.09140471242257071,-0.8073695116936711,-0.5829233655760164},
{0.10579320803611134,-0.8566623233980151,-0.5049133200894415},
{0.13253479456874143,-0.9084158046373961,-0.39650378827145333},
{0.12196273204893815,-0.954355538686521,-0.27263638379629246},
{0.9041351481530335,0.17220489880856485,-0.39100525150005855},
{0.9508305295816588,0.1751222340021022,-0.2554476603407738},
{0.9349459212447736,0.274341846141478,-0.22497261122956097},
{0.8775898690932583,0.38275899782159567,-0.2886720825633915},
{0.8143122873482509,0.4554507743470544,-0.3598056292226791},
{0.7391318135512616,0.47734265396515824,-0.4752137970449956},
{0.734097708370397,0.5000722878422644,-0.45937812474859413},
{0.7440412203604562,0.47276166198187064,-0.47212188401371785},
{0.8217628811243431,0.39023349879829944,-0.41523918844667856},
{0.9391124650956326,0.2295745175531972,-0.25566250955550995},
{0.9616258157455764,0.01631316433557893,-0.27387893522689066},
{0.915710692182597,-0.352788695576803,-0.19239039605886557},
{0.7660865565573446,-0.5073654423708626,-0.3945778703246411},
{0.5709019441892902,-0.5878157208352464,-0.5731872717182652},
{0.3376010835515274,-0.6287576232700326,-0.7004922266268586},
{-2.1863552253217712e-18,-0.6521099978095818,-0.7581243636480675},
{-0.0342524412442132,-0.3385610252602261,-0.9403207976236387},
{0.46285600421406325,0.11219039798618455,0.879305199553996},
{0.7495401450842404,0.17435062767581253,0.6385854911725963},
{0.4840456434678505,0.09701738690924018,0.8696478837305922},
{0.2112968210978532,0.020301304277427178,0.9772110879633822},
{0.32020001925992336,0.008752705237202368,0.9473095258768253},
{0.55536821936005,0.08604131678054329,0.8271414828984929},
{0.76930254263504,0.1666233490680141,0.616774073255857},
{0.9169755046584748,0.16554802456310558,0.36297351889578533},
{0.9268151513638526,0.1698607323933714,0.3349044741313356},
{0.7341035124660403,0.14069387811184242,0.6643020891483574},
{0.4176419888982956,0.08393366376541872,0.9047266488813014},
{0.10571378976610225,0.04578562951662516,0.9933419707145443},
{0.019650203900963947,-0.09118954414974718,0.9956396619884184},
{0.16523291527580866,-0.1166734631611545,0.9793290492492501},
{0.37438205983030604,-0.028476585221550856,0.9268371795365878},
{0.6085051156367774,0.05233891919851406,0.7918220518405658},
{0.784967048392494,0.10310410353985701,0.6108979266385002},
{0.9120652181502317,0.09323235349933597,0.39930535446140136},
{0.9676008866478416,0.04465338426815566,0.24850472718182112},
{0.974818194359044,0.10688840731884293,0.19571498748796448},
{0.985338288202691,0.10340364679526858,0.13570609283016763},
{0.9421401331134982,0.12221639222724974,0.31214599636681994},
{0.7681267726780759,0.09319398103891896,0.6334793942925697},
{0.45121245040439645,-0.026991369406288875,0.8920082906440013},
{0.28120053846223475,-0.12657337850279046,0.9512651770263318},
{0.35324931430903717,-0.08490458688317366,0.9316684673564909},
{0.4974560285456997,-0.021450988939600533,0.8672239357496154},
{0.6317235295310606,0.02749888335892617,0.7747058755752607},
{0.7836558966755041,0.045701038009410805,0.6195117841740979},
{0.9006385383193423,0.026979794185002126,0.4337306929417534},
{0.9576566318444578,-0.00963916520705906,0.28775138918594234},
{0.9814715372136404,-0.041642348163918944,0.1870281702816146},
{0.9876027377824198,-0.00909044858783414,0.15671054868495865},
{0.993882609750654,0.02766724122358795,0.10691997848066054},
{0.9992758299850127,0.001983426076844792,0.03799844245178359},
{0.9961162942832321,0.055634699534565395,0.06824301041967659},
{0.9550618911548777,0.05410134318465344,0.2914272271584875},
{0.1761141903449323,-0.20978581695228302,0.9617555318087919},
{0.06909044224182163,-0.24290437452154148,0.9675866760291444},
{-0.16470414162468025,-0.2522236576892084,0.9535490402876794},
{0.027380116908113237,-0.3382791449241111,0.940647409663956},
{0.13043140098970002,-0.27301973730250567,0.9531253184545748},
{0.2036305983997989,-0.18944318884159014,0.9605445630458117},
{0.2596934391358712,-0.14183373819408818,0.9552185657637075},
{-0.18670029468831773,-0.038558694689388794,0.9816599345125306},
{-0.5518904495652213,-0.20767336302687497,0.8076439227579231},
{-0.4674972185090618,-0.47019376201398333,0.7485747637006126},
{-0.16030083760039063,-0.4692513156455414,0.8683932543666733},
{-0.0050188677795735505,-0.4103660962787217,0.9119070555660671},
{0.08034140688038519,-0.31207502982327046,0.9466543371797782},
{0.1394467857304696,-0.21920484077416186,0.9656623797842675},
{0.2313126177280325,-0.1442999475532711,0.9621184947894558},
{0.29545840497726844,-0.11458797127449154,0.9484587116830573},
{0.37620835565747085,-0.07322827444941743,0.9236367754451219},
{0.9201411548013281,0.16614178306760793,-0.35459436425300683},
{0.9719166335626663,0.13293742990521235,-0.1941795487027676},
{0.964627347660246,0.12305624349906874,-0.23313352629310266},
{0.959589332104281,0.11420487800309817,-0.2571877904410651},
{0.9343968031429264,0.12612997486438984,-0.3331573858058496},
{0.7063821655139958,0.09300252506447731,-0.70169421158749},
{0.9490042959878963,0.07907615026856776,-0.3051848761901876},
{0.9932742799932341,0.06877696954577454,-0.09314468940321603},
{0.9826568684031606,0.10817237679489988,-0.15061280117784148},
{0.9945282416075633,0.05137078562275807,-0.09096493296578101},
{0.9899569686642528,0.05416184359630194,-0.13058213848506808},
{0.9865638643523199,0.059810205863349154,-0.15203447250147265},
{0.9820392950265306,0.12440222448558207,-0.1418552415909742},
{0.9990229769090497,0.03256977772185462,-0.029871410862715494},
{0.999165315875126,-0.023768938478230136,0.03322211787014109},
{0.9990774384869242,0.01410858520727933,-0.04056130828579503},
{0.9992745856862679,-0.02630641383084075,-0.02753679343892796},
{0.9987399533293786,-0.0027120860063811008,-0.050111378080477206},
{0.9980911491020826,0.021613655624062374,-0.05785246731686458},
{0.9944687426324259,0.09588121291803448,-0.04288021614274348},
{0.9778816711897216,0.20657457662338388,-0.032777758374649565},
{0.9640852075938207,0.23209158165995145,-0.12912478546491996},
{0.9193710526378537,0.3531412526253836,-0.17334394499301073},
{0.8744575749708268,0.4257722763963963,-0.23246917694260347},
{0.8333755594826867,0.4695747882275432,-0.29152134590451},
{0.7715029177308097,0.4953773731971833,-0.3992298912369993},
{0.76399367875862,0.5323902759749595,-0.3645192078123965},
{0.7521803792188426,0.5360337065271513,-0.38326562927682667},
{0.7709641118442967,0.5414663700712639,-0.3353036061988951},
{0.8707034561375552,0.44171428523680406,-0.21624981315103123},
{0.96140693544279,0.27507437160673437,0.00554928532907362},
{0.9998733190275392,0.004571029108173263,-0.015246363164544228},
{0.9780736447660021,-0.20444829032260944,-0.03965907208080192},
{0.8901791344111258,-0.43077554774750765,0.14836959298284014},
{0.7446077415198975,-0.6655970154735458,0.05039766126861499},
{0.5987717182211265,-0.7782043659713203,-0.1893948104930419},
{0.41027335356484756,-0.8738486004622141,-0.260891546097001},
{0.2103447252238767,-0.9167542678263935,-0.33958314002992696},
{2.935291770073925e-18,-0.9566872302953675,-0.29111774832493226},
{0.12572646974922994,-0.9916540133059178,0.028551229372171954},
{2.279428435074484e-18,-0.9984346087440313,0.055931494367243886},
{0.9964202437795661,-0.0843531599973612,0.005589470880996503},
{0.9875550322060143,-0.15482489766861995,0.027646146684109158},
{0.9969684097667765,-0.07467101492989402,0.021868458026212057},
{0.999277496770102,-0.03245298380522893,0.019781008341748448},
{0.9996726914245846,0.006246396194956682,0.02480912240493138},
{0.9956542943214995,0.08358447093991901,0.041062908041816955},
{0.9803641435177531,0.1907742861827374,0.04991310285054945},
{0.9486853060139963,0.31602222950631914,0.011231233725004399},
{0.9402694991134147,0.33199615444739217,-0.07531150290063111},
{0.9038172500368243,0.4091434005368174,-0.1253636962323709},
{0.8782647066666962,0.4455338294821063,-0.17363960323230238},
{0.8494869137442537,0.4812498910975103,-0.21626494328923787},
{0.8029401464104053,0.5112205518160781,-0.30649742035342065},
{0.8166499856019398,0.5314099014821043,-0.2251362201493391},
{0.7741846779822581,0.5771915585775912,-0.25978450508888823},
{0.7097664573654595,0.6586022284555094,-0.24994935621505857},
{0.6150580300601245,0.7631361777512505,-0.19830984308846258},
{0.6916911086971708,0.7025707302625781,-0.16720579872596023},
{0.796639751077086,0.6033081600021365,0.037207137469507184},
{0.8724200246476949,0.29054006740699406,0.39302642382523717},
{0.9547126323508471,-0.018703627201090107,0.2969410109082928},
{0.9433774846017399,-0.24343714355023388,0.22533814299092075},
{0.8191822957471482,-0.431735951472562,0.3775505721628738},
{0.7660428552976483,-0.5678581771754572,0.30119003048307125},
{0.6236512034234304,-0.7292427918264206,0.28153885528948724},
{0.44422755286254495,-0.8838910358984797,0.1462823227053336},
{0.26686270597824663,-0.96079769055497,0.07518040956395446},
{0.9802881783528876,-0.07555341240578255,0.18255620848226142},
{0.9934063853626596,-0.09488431499587385,0.0643484287955742},
{0.9964660498874569,-0.04199746470786829,0.07274355215274843},
{0.9966609374559913,0.003956254489488204,0.08155564848469396},
{0.9924111898346825,0.07966956827123206,0.09366317409945822},
{0.9781415794113445,0.18237247446553653,0.09989660246473715},
{0.9495705252202445,0.30376360175552414,0.07773989890307513},
{0.9173341973352457,0.396067267402738,0.04035703273815761},
{0.9154100009490258,0.40094071153888294,-0.0356521527147931},
{0.8969128372324818,0.43579444379580584,-0.07503709192315305},
{0.8799047221863986,0.46068554820492175,-0.11634648920017986},
{0.8490230437408275,0.49529520318834147,-0.18396340096791217},
{0.871884727412097,0.48313164143315085,-0.0800052445258597},
{0.8383353281767248,0.5380835774740191,-0.08752108993599346},
{0.7757262298810278,0.6215917385274972,-0.10896112549405186},
{0.6670710561044231,0.736319703673019,-0.11335563546029448},
{0.5159611540344899,0.8503491207851047,-0.10339468220076331},
{0.35783436198425916,0.9305435306376124,-0.07773870960985232},
{0.4233793540494332,0.9044391387525859,-0.052342782283380934},
{0.5129353963447176,0.8512877080730147,0.11048310848487831},
{0.6264692453735006,0.5986855691844931,0.49911108367917073},
{0.5650353812008915,0.015685200235772252,0.8249175670845706},
{0.7524292000301352,-0.14719581268343152,0.6420153360087864},
{0.8234144692200299,-0.30123950709326924,0.4808777092414457},
{0.9938674346124815,-0.04360097097429098,0.10161927842148964},
{0.9942248498702216,0.003539653394037863,0.10725865351749052},
{0.9908270196811076,0.07569572323563954,0.11194630209921036},
{0.9777494846950076,0.17520017740144744,0.11537262681047164},
{0.949041750466307,0.2947890180457262,0.11144142278113843},
{0.9147621811990015,0.39278381110544575,0.09450412467996608},
{0.8946713501771174,0.44047530509989924,0.0744626132324445},
{0.9001719507476474,0.4354633394231283,0.007882836141414707},
{0.8912613127461704,0.4528377169515921,-0.024316136782866475},
{0.9835966407064353,0.15459528486577362,0.09294055244233193},
{0.9930086869015146,0.062001333586551056,0.10044691320104922},
{0.9950380202273871,-0.002256138687177527,0.0994698353280334},
{0.9962396410101957,0.045807428081989586,0.07354085403630843},
{0.9881101948084078,0.14324477217635478,0.055849603040974444},
{0.9572337259522876,0.2779516850593007,0.08028981674033243},
{0.95146076393474,0.2864668034522394,0.11251304463295426},
{0.9124490549225346,0.3918937852119699,0.11771144074901099},
{0.8862167139675345,0.44809880271443614,0.11758996084051551},
{0.8770535246297799,0.46619051967447706,0.1159461698380808},
{0.8885614800614292,0.45527837085303124,0.056392385873024524},
{0.8794407548278336,0.47564013199022165,0.018719604380832908},
{0.8460201046614987,0.5316784501377249,0.03959808287901813},
{0.7729507299227092,0.6331948709655852,0.04014255217131732},
{0.6396630715696991,0.7679006862222784,0.034054235703831544},
{0.4379041526011879,0.8983802911557824,0.03395299099471536},
{0.28225699670615206,0.9589084065011226,-0.02873422614063157},
{0.18052360621522717,0.9835265061233701,-0.009318763426870267},
{0.21674104143899636,0.9760143154274774,0.02047869714048906},
{0.2677979267728583,0.9492358834067307,0.16503183956195303},
{0.3441423670024703,0.7602472417204774,0.5509901656929488},
{0.32732510000968745,0.12101419929548,0.9371306432256508},
{0.9999778504299546,0.0018411907392279969,0.006395988285587314},
{0.9977720271798162,-0.0444860468925525,-0.049718944169740355},
{0.9695611947521373,-0.1152431298556525,-0.2160326610767025},
{0.9700874854019176,-0.22818638073284248,-0.08283264039393563},
{0.8688833890647479,-0.34881011916946153,-0.35124515224034614},
{0.9946631308470842,-0.0986047430049566,0.03037039331985299},
{0.9841963289020513,-0.16484345620802682,0.06468555573787318},
{0.9957167443492211,-0.043217575042895626,0.08173375208565659},
{0.9925034012708451,-0.08420235127151612,0.08858308250536356},
{0.990736816280387,-0.09854146651847792,0.09343521949987897},
{0.9923327373914202,-0.048258799802361085,0.11378412254302525},
{0.9930326428421377,-0.06342687451935429,0.09931365383805829},
{0.9938140005075877,-0.06111210257498487,0.09273102670610804},
{0.993601155265121,-0.05753292786806103,0.09719416889271525},
{0.8871829401802813,0.07651338487090915,0.4550298150546484},
{0.7792726160550859,0.031032795252396,0.6259162527730733},
{0.8908141072265383,0.019536558766746204,0.4539477384432473},
{0.9463897867263222,0.07690731573414662,0.31373816530137744},
{0.9509841086552216,0.0014182283731483411,0.30923650126321606},
{0.6374017265754379,0.01812237354998903,0.7703185175857876},
{0.7823594128617494,0.07451684850008643,0.6183534494091819},
{0.871366407716096,0.2154876602834286,0.4407784610998138},
{0.9254740069840254,0.22273343458254397,0.3064109650714149},
{0.9528375639683024,0.22978431295932,0.19824163591123958},
{0.9760153601050008,0.0790629456643667,0.20283753957780787},
{0.9795733144380472,-0.011500452942014886,0.20075821582935827},
{0.9918084933981981,-0.012130820233794158,0.12715642187342197},
{0.9902313107631556,-0.05733150157167536,0.12710251811754023},
{0.9964556468596835,0.002246598745435642,0.08408981291171375},
{0.993959678515542,-0.05270241223497216,0.09626324963294852},
{0.9888345316831386,0.08665695838841732,0.12123052632837927},
{0.9922743796441972,0.1023265521675156,0.07014864377329427},
{0.9912560065672694,0.12252162137756054,0.04898960848305533},
{0.9975409232111531,0.024920101989247802,0.06550645033800971},
{0.9959842929280861,-0.03567394693567952,0.08211368796108687},
{0.964566577317925,0.23757488021482515,0.11475841673748771},
{0.9671595660632663,0.2469410807369153,0.060187012027503844},
{0.9655794135202052,0.25734848827825124,0.037790895290735135},
{0.9623042895499292,0.2682258002381032,0.04500415981256841},
{0.9957348422529143,-0.02526518289918023,0.08873440401915512},
{0.9936575353074347,-0.046409790586759044,0.10242477173246434},
{0.7426755575465788,0.6162884974733855,0.2619570653845301},
{0.6366436338100335,0.7523332265588206,0.1693505233081665},
{0.604913386116319,0.7394674098165683,0.2954111458907134},
{0.6166324440894936,0.6973212718302392,0.365386744079852},
{0.4284524844229712,0.8121540840932774,0.39602299463843427},
{0.4074918205556905,0.8633291916334339,0.29767956438722876},
{0.4299769004022858,0.8864819416598302,0.1710836994908066},
{0.7697388772753473,0.6180782682457947,0.15962867891819243},
{0.8268842943017737,0.5224822479632997,0.20802563399801197},
{0.7372867586778019,0.601746519807453,0.3070982926979558},
{0.5960443277029555,0.7092607195320437,0.37640455781249443},
{0.42629661948523007,0.7994894268773864,0.42318772256143383},
{0.23060944291886057,0.8813307968667131,0.41240188085281193},
{0.22218304185823504,0.923317118561617,0.3132414316173624},
{0.2220704671243968,0.9590634159324108,0.17573295607599457},
{0.24112455980052516,0.9689704020103922,0.05436273253638042},
{0.1416012442109727,0.9897336519308337,0.019400666832870634},
{0.06326192285526791,0.9976616182120868,0.025869376936735217},
{0.08038620305068837,0.9955081315449914,0.05001618125060631},
{0.10179735247641,0.9771145430175481,0.18677384413349132},
{0.13262937649308085,0.8174621752304909,0.5605042734524786},
{0.12855381626840237,0.1674278969645625,0.9774670406928583},
{0.8709784778407833,0.4780685195807355,0.11334452666113291},
{0.8390630549372938,0.5269047677692074,0.1354420744871159},
{0.854328692416601,0.4911880475596004,0.16987285612577568},
{0.8067162525222868,0.5373873304434146,0.24581241830977169},
{0.7095839429400129,0.6304095268672355,0.31476095113074737},
{0.5920097214683764,0.7354571213584655,0.32958657789730256},
{0.43811430560479797,0.8203522531737345,0.36752963953564716},
{0.2470833364844705,0.8691285242319137,0.4284453678103638},
{0.095265715603183,0.9107797480107087,0.40175203054143166},
{0.08372013147453129,0.9470721238443744,0.30991181297716486},
{0.08559199857846217,0.9786811013892646,0.186701128981162},
{0.10504343133410438,0.990544805295245,0.08824322204091727},
{0.044013536852784266,0.9974741302706085,0.05575094631126586},
{8.134072924911248e-19,0.9991790060491472,0.04051313207637851},
{0.0,0.9988192601463929,0.04858071181664984},
{1.1963358250814662e-18,0.9877172874498859,0.15625159222433466},
{1.6641422916535133e-18,0.8816106117994698,0.4719774667953597},
{0.0,0.3194913485605589,0.947589192738581},
{0.7621843462831775,0.6138923652423873,0.20545361076893406},
{0.812476194201795,0.5486330442757062,0.19719081262609048},
{0.7801966643657713,0.5730570886443066,0.250796208238951},
{0.6830064284314736,0.6807836514370014,0.26464285113598973},
{0.8342069321904151,0.5149200220026364,0.19737316237589225},
{0.8486260668601159,0.5047544754253545,0.1582931400396286},
{0.8358955855357106,0.5308044124027826,0.13973276586272876},
{0.7981913247729573,0.5801352332003255,0.16227667810500493},
{0.7802910055888775,0.6141802473212042,0.1180193645024524},
{0.7272161708368203,0.6697968038384241,0.15009624392790216},
{0.6570005554546662,0.7352240417124152,0.1667209603508831},
{0.5678253389347128,0.7929751459708995,0.22082753980450245},
{0.6610412071550591,0.6847466649797403,0.3068330608687814},
{0.7040080118398873,0.6088551893473031,0.36560645189890834},
{0.7223585762589131,0.6341313670782693,0.2758178685158761},
{0.6833966234512877,0.7001646901305139,0.20673282697680265},
{0.7434593953269678,0.6403209305446856,0.1930213288899628},
{0.7728356009713204,0.5664872622581826,0.28603726255599515},
{0.7404967691423314,0.5454674034247049,0.39259374255186363},
{0.6730279706040021,0.5832670490120845,0.4547888524594606},
{0.6319585883136218,0.6552045362145328,0.41392675484988045},
{0.5841299387057607,0.7363653463646247,0.3414063434983458},
{0.6067116867550677,0.7612004711126086,0.22907372597651507},
{0.6189007620387186,0.7757141091805347,0.12340772895626528},
{0.6944210454000154,0.7102565200759018,0.11539101956053571},
{0.7530975224876266,0.6484291364831354,0.11128241812044698},
{0.794958903975797,0.5766431850096365,0.18847540468597396},
{0.8269444575033426,0.48338729243519013,0.287227418114424},
{0.7805927558258521,0.4694952005794813,0.4126126587794349},
{0.6857321057708166,0.5117486322253956,0.5175759041247557},
{0.6102832952795495,0.5982160861782347,0.5193186052322113},
{0.559063844394366,0.6904078865843838,0.4591128053464386},
{0.497487117173646,0.7818711298723656,0.37574473318779256},
{0.5163128931952328,0.8176555365760932,0.254677089324559},
{0.5278470817094519,0.8385100437072216,0.13519750342712794},
{0.5307025314694932,0.8457781807501146,0.05490074734371195},
{0.6215198910750703,0.7815796074743048,0.053351121622179504},
{0.696695058238523,0.7153579627820339,0.05365613581277849},
{0.7558554754714929,0.6524335028323535,0.054891024600282626},
{0.8046985701746457,0.5835060199854502,0.10945746114185237},
{0.8483218707464084,0.49446337577049637,0.18935673643934323},
{0.8783618801376983,0.3754152280970103,0.2958780391205763},
{0.8296566395729439,0.3651530918965871,0.4222950152332998},
{0.7449012632942844,0.3528794107010652,0.5662139431750585},
{0.7027541077343262,0.4404499704067739,0.5586953442003997},
{0.6107367039333002,0.4451780210207875,0.6548413609941753},
{0.601489663267558,0.5238505590983059,0.603150708127473},
{0.5313881400381062,0.6090798998022756,0.588768477657977},
{0.4783034005416349,0.7238947116182508,0.49719443231138255},
{0.40349848189734777,0.8207859109805038,0.40435066890316895},
{0.41708237667164016,0.8651006902057603,0.2786450912459309},
{0.426056083784412,0.8924207484652371,0.1485308761807997},
{0.42752152205115246,0.9021751657117862,0.057491899916222056},
{0.42767568715461063,0.9029867411483564,0.04133342384926372},
{0.53379322613516,0.8445296923874449,0.04282978412490258},
{0.6247793983523497,0.7796546323577432,0.04230079949112175},
{0.6993139297481158,0.7136299912255748,0.041137127800001956},
{0.7582948863551408,0.6507143800704649,0.039492542297944064},
{0.8083500340292126,0.5860624019023543,0.055687373446899176},
{0.8589447131336057,0.5002426402489235,0.10941334770773678},
{0.9033172126151663,0.3832602607208181,0.192690388824604},
{0.7767096344833782,0.20695938874149333,0.5948865060769531},
{0.6741517946949035,0.20037569815210687,0.7108930561622446},
{0.6512590561905216,0.3445353450345958,0.6761338904031678},
{0.5714890076030225,0.3544630397649513,0.7401055787044866},
{0.5227596119886392,0.44663871641005953,0.726110353236381},
{0.5228141069096871,0.512844121498322,0.6809231356480997},
{0.44720613189895553,0.5465267728613212,0.7080361305313196},
{0.44994807211224735,0.6406596090629753,0.6221752146443535},
{0.39096189985916824,0.7552865371513262,0.5260142960571204},
{0.30702716298264304,0.8510593628008392,0.42594868491387455},
{0.3158558315080419,0.900823948642296,0.297911576235073},
{0.3213083329254941,0.9333142760311913,0.1602667069263382},
{0.320364560240629,0.9454392210611281,0.059255614258529134},
{0.3165761643018574,0.9478680929354706,0.036408935590012986},
{0.30966008451203847,0.9465591937084604,0.0902015790659258},
{0.4288318014467892,0.8980682807069741,0.09786035589512802},
{0.5421271386403,0.8348274369578406,0.09571476402354964},
{0.635105947490033,0.7675858556810053,0.08632722410251772},
{0.7087325129175257,0.7016140719699244,0.07372868605496148},
{0.7657752951027148,0.6402059948824875,0.0610285304335129},
{0.810916348110901,0.5839686579851898,0.03735348521164006},
{0.8629075075663986,0.5022516178495792,0.055981655504513755},
{0.9145474045038302,0.3889597486362791,0.11096557509475695},
{0.8161344445488734,0.575636520697435,0.05066719313572935},
{0.8649233103206171,0.5006696755088863,0.035178733488457264},
{0.9180180511295125,0.3924793272665629,0.05659359918540176},
{0.4286665370788891,0.8732208392056542,0.2317981146725878},
{0.9131279934457597,0.39211824575697335,0.11153720872513583},
{0.9161205484063822,0.3935664348298403,0.0763452825190828},
{0.8737003468079863,0.4716228167054316,0.11924605968517185},
{0.8786580823349278,0.45888918364597625,0.13183585051205382},
{0.8627730866692744,0.48263167977630145,0.15062955419000107},
{0.870689009939087,0.48518449863289853,0.08060180058556464},
{0.9178767185853124,0.39471510901260537,0.041259086226263515},
{0.8674944412732739,0.4955268114435877,0.043664327551464585},
{0.8249844817827248,0.5571880562322822,0.09456254443372547},
{0.9184115184309364,0.39413372040355366,0.034335014988131914},
{0.7788453355344854,-0.5002569896266991,0.37834228900006334},
{0.662037546533187,-0.6563454097343213,0.36182452943520016},
{0.7643929519828094,-0.5429003634047327,0.3477967946574776},
{0.8818317509886194,-0.34059891818072335,0.32613668895490167},
{0.8814779823341431,-0.37776125434219254,0.28336019723655814},
{0.7500209954203085,-0.5885773603548248,0.30173696708636205},
{0.6199655056715522,-0.7064626923254278,0.3413989398485656},
{0.47791039762772886,-0.819996085699239,0.314973127865271},
{0.717762767750652,-0.5854018733379909,0.3769897292013333},
{0.7855593286294884,-0.44857942592358796,0.42623120467799097},
{0.8728927431683452,-0.3067922412979174,0.3793900098888236},
{0.9571421345473504,-0.06300115382494759,0.28268319527497054},
{0.9714790690976556,-0.08746302699614593,0.2204056197419293},
{0.9782393648288252,-0.1245228345075622,0.16595724987326987},
{0.8757716980517227,-0.43120256775110616,0.21699833745090003},
{0.7221963165300789,-0.6603638095089491,0.20579630580069852},
{0.5858290541748435,-0.7635398016697047,0.2716823338952979},
{0.43089509955906197,-0.8547141159624048,0.2894705393482916},
{0.28237206437157786,-0.9183244013757426,0.27739198095910705},
{0.3045298625183101,-0.9183501032594684,0.2527739121782603},
{0.7549769591408326,-0.49476430848138747,0.43036969017275833},
{0.7588861042621069,-0.39677568478067726,0.5163922314720732},
{0.8359250371768381,-0.2747721826934491,0.47511007128746485},
{0.9207956976404537,-0.0401056869416521,0.3879778564322561},
{0.9442759234349569,0.1417373504879842,0.29707491293898514},
{0.9736845003314856,0.13705858264707146,0.18208085768965743},
{0.9853305257660814,0.13684235827823527,0.10197021121086705},
{0.9919164160442344,0.12184434653679689,0.03543696938202253},
{0.97800278825256,-0.1908836682943352,0.08410690428684538},
{0.8460531340213338,-0.5255516834197561,0.08938412872171204},
{0.6429294402874686,-0.7649010641574664,0.039599202800278184},
{0.5285377649001368,-0.8351776295981221,0.15207287099686728},
{0.3926851598075869,-0.898674091192147,0.19540533024167675},
{0.24184907204959188,-0.9533079689399185,0.18086719631928502},
{0.1501434233445296,-0.9624682277400697,0.22607932903579364},
{0.18615952799814378,-0.9566521855110921,0.22396702009974434},
{0.7410746532812446,-0.41664607652919705,0.5265115432513419},
{0.6662003110135958,-0.33341568377190517,0.6670915435083113},
{0.7353605894595372,-0.21017570101529365,0.6442600237267959},
{0.8165169923218617,0.035175899397762056,0.5762487807806794},
{0.8450010257674645,0.2252892880893487,0.4849927866722628},
{0.8580403796595261,0.23690199318257907,0.455679879410818},
{0.9613440475171978,0.15123824985573098,0.23009696669844884},
{0.9743681027543558,0.20682538433985792,0.08848763036462862},
{0.9677696326054174,0.2517902812098313,-0.0048572106243758946},
{0.9575648919079957,0.2758054495087344,-0.08367097350045402},
{0.9957059654832898,0.06986551589274614,-0.06073252826970206},
{0.9475476044727142,-0.31211164159497945,-0.06884664435473807},
{0.7408528185271342,-0.6610210586656021,-0.11911448812385456},
{0.45984081095060764,-0.8607496877610431,-0.218303466769436},
{0.3971070304038662,-0.916088856515005,-0.0555626976743684},
{0.3392292231389083,-0.9388455279399268,0.05909829807847803},
{0.2231721415483615,-0.9747678817603712,0.004666039553741485},
{0.11746367065472342,-0.9921432099805624,-0.04305969073024624},
{0.11419658114823027,-0.9855179816593307,0.12535329544999982},
{0.06016854149162765,-0.9798099321503911,0.19066264310088668},
{0.08037151658599914,-0.9793640233499229,0.18543605121312884},
{0.6546974377762588,-0.33591474854199566,0.6771503132105676},
{0.8185034057528131,-0.4844946707996093,-0.3087346574938162},
{0.9718767182392092,-0.046678305401842916,-0.2308176343986685},
{0.8408097196780466,-0.23805703079034068,-0.48617678408806353},
{0.5722934159702114,-0.6042686485224736,-0.5543822205391961},
{0.5079522957627386,-0.7641270882270383,-0.39761068681190026},
{0.264441684921438,-0.8143810865463873,-0.51657917220058},
{0.24312707137147763,-0.9046625496435067,-0.34996413878973126},
{0.22120999599775468,-0.958390229321585,-0.18042811868329475},
{0.10843817260676344,-0.9643160581369085,-0.2415278508598966},
{0.03506684390539101,-0.961611243782293,-0.27216563392534815},
{0.04109157397058253,-0.9961143183824425,-0.07789574611043971},
{0.03920189915057938,-0.995138729818112,0.09034444929813133},
{7.369000505583561e-19,-0.9857315883830576,0.16832479218408167},
{8.859470005265672e-19,-0.983422067292551,0.18133129228581996},
{0.9356716803748891,0.2738846652587259,-0.22249875658202423},
{0.910335557323901,0.1654447997644767,-0.37936419349046985},
{0.7827738512881682,0.022972720355401235,-0.6218821044691359},
{0.5470989014197499,-0.42161035673280023,-0.7231372616322186},
{0.3118120225625549,-0.6776247666787557,-0.6660314843676765},
{0.12837196781401294,-0.6697697232034034,-0.7313885121873289},
{0.11591518458335721,-0.8117394500204002,-0.57240085190676},
{0.10895210591670851,-0.9030625974982507,-0.41546044771557616},
{0.033390675633835375,-0.8986140514879641,-0.43746754079486005},
{0.0,-0.9093983908119135,-0.41592615545154427},
{0.0,-0.967964137352687,-0.2510884879859456},
{1.1911911191944735e-18,-0.9985197060810997,-0.05439114420302342},
{0.0,-0.9968260344764079,0.07961065877154277},
{-0.03920189915057938,-0.995138729818112,0.09034444929813133},
{-0.06016854149162765,-0.9798099321503911,0.19066264310088668},
{-0.08037151658599913,-0.9793640233499229,0.18543605121312884},
{-0.12572646974922994,-0.9916540133059178,0.028551229372171964},
{-0.18615952799814378,-0.9566521855110921,0.22396702009974434},
{-0.26686270597824663,-0.96079769055497,0.07518040956395446},
{-0.3045298625183101,-0.9183501032594684,0.2527739121782603},
{-0.44422755286254495,-0.8838910358984797,0.1462823227053336},
{-0.47791039762772886,-0.819996085699239,0.314973127865271},
{-0.6236512034234304,-0.7292427918264206,0.28153885528948724},
{-0.662037546533187,-0.6563454097343213,0.36182452943520016},
{-0.7177627677506521,-0.5854018733379909,0.3769897292013332},
{-0.7660428552976483,-0.5678581771754572,0.30119003048307125},
{-0.7549769591408325,-0.49476430848138747,0.4303696901727583},
{-0.8191822957471482,-0.431735951472562,0.3775505721628738},
{-0.7410746532812446,-0.4166460765291971,0.526511543251342},
{-0.8234144692200299,-0.30123950709326924,0.4808777092414457},
{-0.6546974377762588,-0.33591474854199566,0.6771503132105676},
{-0.7524292000301352,-0.14719581268343152,0.6420153360087864},
{0.888735647339807,0.36009646350588653,-0.2836890659120436},
{0.7917916158290231,0.4421099320472535,-0.4214318985174682},
{0.7697889255240955,0.3757032710168279,-0.5160155639975545},
{0.6350224542032699,0.23838657696815785,-0.7347913462875433},
{0.5094908468774599,-0.1777124289071039,-0.8419248004186752},
{0.27396356251302634,-0.4965195731512765,-0.8236578657991711},
{0.12717975216871846,-0.49040578567411747,-0.8621644135637093},
{0.044097375321972526,-0.5082286142569926,-0.8600924933634347},
{0.03655728055952846,-0.6770469450912578,-0.7350312914296147},
{0.03504574546619187,-0.8075557572485462,-0.5887490931283427},
{0.0,-0.8241730887740344,-0.5663379907269751},
{-0.033390675633835375,-0.8986140514879641,-0.43746754079486005},
{-0.03506684390539101,-0.961611243782293,-0.27216563392534815},
{-0.04109157397058253,-0.9961143183824425,-0.07789574611043971},
{0.45206721370714154,0.44222939504382913,-0.7746408177021338},
{0.5493355222412799,0.517969757480438,-0.655696434594208},
{0.5868818684671055,0.5103202563574066,-0.6286039360486615},
{0.2696280725165586,0.5810622032023868,-0.7678980521661671},
{0.2101575750583992,0.4898265775769222,-0.8461109369018065},
{0.32831154038903554,0.28685657495475003,-0.8999582422827231},
{0.42727516375629926,0.07534289465995006,-0.900976904621471},
{0.25468654018006437,-0.2783121607007718,-0.9261085829734957},
{0.10668944704243231,-0.3026568636213071,-0.9471093837528449},
{0.029542115554535738,-0.3026941998696621,-0.9526297731930424},
{6.404279749799161e-19,-0.5063419815742818,-0.8623327650596547},
{2.0649820996844874e-19,-0.7017946128796038,-0.7123793380869263},
{-0.03504574546619187,-0.8075557572485462,-0.5887490931283426},
{-0.10895210591670851,-0.9030625974982505,-0.41546044771557616},
{-0.10843817260676344,-0.9643160581369085,-0.2415278508598966},
{-0.11746367065472339,-0.9921432099805624,-0.04305969073024624},
{-0.11419658114823024,-0.9855179816593307,0.1253532954499998},
{-0.15014342334452963,-0.9624682277400697,0.22607932903579364},
{-0.28237206437157786,-0.9183244013757426,0.27739198095910717},
{-0.4308950995590618,-0.8547141159624048,0.2894705393482916},
{-0.6199655056715521,-0.7064626923254278,0.3413989398485656},
{-0.7643929519828095,-0.5429003634047328,0.34779679465747765},
{-0.7788453355344855,-0.5002569896266991,0.3783422890000633},
{-0.7855593286294885,-0.44857942592358796,0.42623120467799097},
{-0.7588861042621069,-0.39677568478067726,0.5163922314720731},
{-0.6662003110135958,-0.3334156837719052,0.6670915435083113},
{0.45647947487501966,-0.8018456982467058,-0.38557744386968357},
{0.7935196281669025,-0.6082328997496744,0.019476636669699378},
{0.4189131576227241,-0.9080004904856676,0.006846579317127906},
{0.004354651749200328,-0.9133998942714042,-0.40704013334452765},
{0.036906685278445456,-0.9982573791905447,-0.0460445596502245},
{0.0030537234961646067,-0.9556242018154675,0.29457267299829376},
{0.435132551048533,-0.8119625199708745,0.3890713677213257},
{0.7161287010718274,-0.6251773728718907,0.31034325504218435},
{0.8786330934962416,-0.3185556212782358,0.35570521947992556},
{0.9541964394369058,-0.29507997957987797,0.04936558129983048},
{0.7797404704241702,-0.5484522126383312,-0.302001604689135},
{0.4075031883097573,-0.5372680625924533,-0.7384335992054628},
{0.009221680309620528,-0.5842882333398146,-0.8114938206745049},
{-0.3604129905665699,-0.5699821844540115,-0.738392027066852},
{-0.4326403117255805,-0.7639381968432372,-0.47877008268468085},
{-0.3962789268214346,-0.9151745912587093,-0.07361032313274155},
{-0.4408422489929807,-0.8313418449772763,0.33842111088492854},
{-0.38567214629563346,-0.6738040086245026,0.630273871847208},
{0.018515751862152225,-0.6900215859578895,0.7235519178643218},
{0.39370475747326594,-0.5835059476181711,0.7102938638599781},
{0.6617029461502887,-0.5008409682563355,0.557949402340467},
{0.6884885355560906,-0.30973759922962635,0.655779045129758},
{0.7532347631640279,-0.1932591079677096,0.6287195787859291},
{0.9360568725391124,-0.1468354420551518,0.31974503018618455},
{0.9920838682093397,-0.11486311154819341,0.05075494108223396},
{0.9255186140716413,-0.28370921189448217,-0.2508473202829164},
{0.6848934081386179,-0.43601276258103266,-0.5837926775446267},
{0.33781807526107577,-0.23236860323267633,-0.912076630694262},
{-0.034633375700124286,-0.20981043536762378,-0.977128502551462},
{-0.41487753658554016,-0.20790556301981816,-0.8858057950262722},
{-0.6434836435354256,-0.3965921265713541,-0.6547087028931143},
{-0.7617710636015989,-0.5364670938384102,-0.36319127727391703},
{-0.8071701910809356,-0.5872649799203996,-0.05996770788898621},
{-0.781909219995103,-0.5700370686171927,0.2523404685914799},
{-0.6896522656096526,-0.4602207241545585,0.5590855369244738},
{-0.46152147322349135,-0.2949182225860449,0.8366726789732687},
{-0.016403497569110078,-0.3229271728170567,0.946281652746096},
{0.3889137760965828,-0.3286726814318276,0.8606511158667659},
{0.3940307099435219,-0.19916462862023138,0.8972587421295874},
{0.44503312289347613,-0.22812625906703668,0.865969935651209},
{0.8446956801215624,-0.1570613482837069,0.5116844152984096},
{0.9635710856973476,-0.059096491602616194,0.26084165213457877},
{0.9996096343971576,-0.017495212440371593,0.02178293740631136},
{0.9617106669728968,-0.10433259711102194,-0.2534310600747577},
{0.7264133442545487,-0.2418342194558685,-0.643303865672431},
{0.3072320217805139,-0.051833485486922605,-0.950221960688625},
{-0.06115739522545621,-0.02480984639662114,-0.9978197455106876},
{-0.392544386378652,-0.03209887681614437,-0.9191727622322963},
{-0.7321164548497108,-0.06415809281048998,-0.6781513368454065},
{-0.7437473756476187,-0.18206434581132147,-0.6431892530208939},
{-0.9189242519161431,-0.20330224054374976,-0.33800357724475055},
{-0.9712060685129983,-0.2374404300379272,0.019514473268054347},
{-0.9039473151326907,-0.24052703803806788,0.3535901517817401},
{-0.7769525480874397,-0.21457732681805344,0.5918625759718662},
{-0.7509798259028725,-0.08016636557865027,0.6554408096211292},
{-0.42698814181617706,-0.11208408301855087,0.8972838375242579},
{-0.02866038496450408,-0.1557168872139964,0.9873858584008939},
{0.007073217503094391,-0.20144414223437435,0.979474464778746},
{0.96156744831534,0.013176282832231764,-0.27425248934339846},
{0.7322629655173551,-0.061126517712270664,-0.6782731737022335},
{0.3239264661645437,0.040945452843594264,-0.9451958074439306},
{-0.059445747362707343,0.02718319731354219,-0.9978613515435409},
{-0.3626139949331791,-0.006635077853130656,-0.9319158043624346},
{-0.7215282660355529,-0.059071413585618494,-0.6898605144583398},
{-0.9587498456549195,-0.05551197979794843,-0.2787779646162522},
{-0.9523742586263977,-0.07023253449951693,-0.29673331899804145},
{-0.997221521668211,-0.0526730336000171,0.052676258913376225},
{-0.9330224088023381,-0.07514583695573444,0.35188391247811357},
{-0.9261883103510353,-0.01176924930052266,0.3768775643892806},
{-0.748120501694642,-0.07422534351955476,0.6593984480748809},
{-0.3995219784172116,-0.14378638382863063,0.9053770841959072},
{0.43997265431749644,-0.7826485380874664,0.4403241184427311},
{0.03561263642821213,-0.5991914922486329,0.7998132880513354},
{0.00398177380129514,-0.9159761102818192,0.4012130492274443},
{0.4481893835725719,-0.8934491871742892,0.029577464232759018},
{-0.008639675040554594,-0.9998862365231073,0.012364061907414802},
{-0.3990213239887531,-0.9153233150553306,0.05445375945132526},
{-0.4390114065443547,-0.8062253895998959,0.396572321384692},
{-0.36994919689989886,-0.608706712894238,0.7018644665393822},
{-0.36850550542446,-0.25701560251455696,0.8933905487164853},
{0.025416239854391363,-0.23603428337053034,0.9714122872526496},
{0.38669988379152287,-0.521410139252091,0.7606541044132595},
{0.6618111118741807,-0.4888974552338679,0.5683179835846378},
{0.7633038606266539,-0.5883493365605555,0.26685628064784217},
{0.7881177001207906,-0.6155022300118053,-0.005243625349913907},
{0.756549659520886,-0.5938032395542523,-0.27391663946118117},
{0.43628381953879036,-0.8148918136357945,-0.3815858499446877},
{0.026812236365552314,-0.9450286432919085,-0.3258864331925041},
{-0.387754626233156,-0.871847475346045,-0.29921284993715236},
{-0.714503714048709,-0.6439599401515078,-0.2734959562601739},
{-0.780965708176989,-0.6234472408989036,0.03749800617577508},
{-0.7504689766144373,-0.5438381433126691,0.37554811811205757},
{-0.6434293767498515,-0.40766131002987266,0.6479281545356906},
{-0.7228506374535683,-0.2533472852373387,0.642885766676974},
{-0.6965615327748469,-0.1137806574111018,0.7084179508294897},
{-0.313607235900614,-0.06190423275858811,0.9475327791466357},
{0.02713642505759233,-0.04027964326964818,0.9988198860521168},
{0.37299343730890255,-0.2473072286990769,0.8942678739380456},
{0.7250918998044126,-0.2612326389909362,0.6371807005582162},
{0.913961691032699,-0.3127179666287675,0.25861457938835963},
{0.9382655665664721,-0.3403077774466677,-0.06203501595878228},
{0.8657609244464718,-0.3237562512796825,-0.3816279752048027},
{0.6595727932382384,-0.5092959766412279,-0.5527941195390613},
{0.38416072642255117,-0.5880961487893182,-0.7117327139127932},
{0.005194540045988046,-0.6933106179025926,-0.7206201522697211},
{-0.382778089702098,-0.6838384863180127,-0.6211649206726839},
{-0.670611765101195,-0.5030605315205112,-0.5451696636223998},
{-0.8870492550648998,-0.34183757347092436,-0.31030741604466455},
{-0.952467975188816,-0.30463369331681095,-0.0017518949387390062},
{-0.9019619402761054,-0.2846486477734461,0.3247149605640487},
{-0.9377205108076572,-0.13994828700140932,0.31795395983695157},
{-0.9391492169227778,-0.0935566993591857,0.33052366384019827},
{-0.6107331389063161,-0.05546206107249235,0.7898917601945405},
{-0.24009557197692222,0.019084807098770074,0.9705616345472745},
{0.053304389106914145,0.04292108009145175,0.9976554630661438},
{0.3640911304485654,-0.06313692375971122,0.9292208443566287},
{0.7416159712724107,-0.08514037876875308,0.6653997798743188},
{0.9559071961406761,-0.14329164144568246,0.25633754671969705},
{0.9860009964573495,-0.15690820277767348,-0.05640789737434242},
{0.9222861853026694,-0.1850985704238786,-0.3393032738228247},
{0.7222899342105517,-0.2202450543751193,-0.6555832265711331},
{0.6726003816189743,-0.3224139422881866,-0.6660765545072129},
{0.36711452082123885,-0.3373021424040024,-0.8668645761200894},
{-0.03320378707965518,-0.34338025350638013,-0.9386093489974746},
{-0.43003404318972993,-0.36418049204392855,-0.8261012594788458},
{-0.734388791497383,-0.27901993476658477,-0.6187252855071175},
{-0.9209085998159074,-0.16944709097776003,-0.35101999108922477},
{-0.9892617223821595,-0.14422483894920823,-0.023673623709904754},
{-0.9945692025626728,-0.10269142359284603,-0.016928462255142496},
{-0.9783515500736832,-0.20201201910450733,0.04493760792188637},
{-0.900219123518213,-0.18531335635898075,0.394036152665044},
{0.36942096260500584,0.04214141359587975,0.9283061206563985},
{0.7402744588733086,0.028801522590197588,0.6716875745734147},
{0.9627479429616985,-0.02503028958637828,0.26923945276693767},
{0.9975411549327762,-0.059251640174313565,-0.03742842972977506},
{0.951759524333376,-0.10108083854264317,-0.28971791784462014},
{0.8052335500457883,-0.20059864212005976,-0.5579956224382454},
{0.38595580308156685,-0.25369466115343975,-0.8869482154950785},
{0.3565460388995573,-0.2161821749600406,-0.9089225431105677},
{-0.04635848995539585,-0.18719379030997924,-0.9812285030911194},
{-0.45094292735970665,-0.1886814023406842,-0.8723816852015012},
{-0.7427919806625007,-0.19002855259213125,-0.6419884910675726},
{-0.7394187273068136,-0.18276602293927954,-0.6479633682292009},
{-0.9486318111681322,-0.11455453658876846,-0.2949151487916512},
{-0.9268252452043205,-0.26646254985879286,-0.26456128661370953},
{-0.0167041975848368,-0.22834719197242886,-0.9734364538588811},
{-0.36286417067384963,-0.18127541013214,-0.9140398346475955},
{0.7596068705953805,0.04095980043946132,-0.6490914395462725},
{-0.9961307378342009,-0.03299116916908301,0.08145634351447142},
{0.9533700568433614,0.28029480577930327,-0.11189439917899545},
{0.9669735962062932,0.21229141054798875,-0.14104758504637394},
{0.9741561454394049,0.2239912187477944,-0.029115944541071297},
{0.9939247890711035,0.08627231276219283,0.06834180068321868},
{0.990562498036195,0.11805626631857838,-0.06963228753394606},
{0.9774647997962291,0.15274489118081344,-0.1457105465554203},
{0.9430032122705919,0.22179059285088246,-0.2481005331920893},
{0.8334127654737934,0.23802260168528225,-0.49876688285439835},
{0.9015236857260721,0.2899019577718779,-0.3212660874647536},
{0.9518394770902882,-0.13747499999903934,-0.2740478684970035},
{0.9715548183428849,-0.21970427522722769,-0.0883813690864907},
{0.9132012391890328,-0.3928629946824896,0.10826894362060144},
{0.9675151405953634,-0.06834523121616065,0.2433996345287801},
{0.796769700684713,-0.3624769860794439,0.4834960999155585},
{0.8697025829528238,0.07374337343435365,0.4880361995587093},
{0.10029327904128302,0.31204038279339996,0.9447603175860508},
{0.397319319878892,0.41913577753751186,0.8163715808619261},
{0.2532716612821043,0.08333480865040443,0.9637991363653546},
{0.10458310730179765,0.03539555575151587,0.9938860741051472},
{0.2685716791854573,-0.34228797982603576,0.9003933540437284},
{0.43691476573676263,-0.38854031132242206,0.8112594615526312},
{0.5817937432881448,0.13082581502023008,0.8027456922307717},
{0.29067937709537767,0.5161113727007277,0.8056888671816271},
{0.01220938313467514,0.4270270592731727,0.9041564143509557},
{-0.00521172875091424,0.2744329809664419,0.9615921052303307},
{0.17327341933039336,-0.12603073441473306,0.9767766255067923},
{0.3280411071677655,-0.5272490500058189,0.7838351046464481},
{0.4006194763045952,-0.8379222345433589,0.37066206180737726},
{0.38620782856972596,-0.780375067716116,0.4917908771404007},
{0.4602747984719961,-0.8511611765422696,0.252332640454505},
{0.3266873139135554,-0.9451032851261073,0.007428281886560065},
{0.36443754237923653,-0.9296048118794811,-0.054956086424495704},
{0.27096943996983813,-0.9152357811729915,-0.29819293664186014},
{0.48364857304193565,-0.8618251624169304,-0.15277907978362373},
{0.5770484600715563,-0.8156319614795905,0.041947325802741214},
{0.5821800817035869,-0.6432552489602148,0.4972816477135838},
{0.531466549538571,-0.351986041586594,0.7704862966008974},
{0.8032255675309948,-0.5941368053933676,-0.04278018398131153},
{0.6619605545651558,-0.6870017470396518,-0.299727916224461},
{0.47833819038554914,-0.8588694737031158,-0.18312783174496194},
{0.32871660501774164,-0.8725571696659423,-0.36137152523430793},
{0.27795807695949354,-0.8179128504705911,-0.5037438600003503},
{0.5888033755238672,-0.7182114580118268,-0.37078684786845645},
{0.05423197796852703,0.19803478137073946,0.9786935771389658},
{-0.04397009100507599,0.4939331703834026,0.8683873872253131},
{0.0451470485253977,0.43035034799726785,0.9015322079593584},
{0.2903804881362297,0.04896795179960548,0.9556575285144341},
{0.30689824586885356,-0.6390028042026383,-0.7053289182387076},
{0.5803660964811477,-0.20637459244266995,-0.7877719985181988},
{0.28875326504068277,-0.18228512557848398,-0.9398902515300293},
{0.320959387549333,-0.5758215478537408,-0.7519405671801987},
{0.312243313990818,-0.12586266382394196,-0.9416276879548376},
{0.13254888141180116,0.47977539139720693,-0.8673213751811593},
{0.23497371959790503,0.439654488825713,-0.8668859680221649},
{0.6511531842922327,0.40973767817380646,-0.6388384503697503},
{0.9222244092786778,0.1144500110771464,-0.36932821973826335},
{0.5585799959508444,-0.6096557603698101,-0.5624128750050656},
{0.3137659001893598,-0.7758712225445543,-0.547334272547937},
{0.5238092605546455,-0.6405389302091465,-0.5615458462527503},
{0.5145965695897111,-0.4332213535387577,-0.7399389362674114},
{0.43406560203558997,-0.09597947001253293,-0.8957538693556362},
{0.2172545505158881,0.43852674952731563,-0.8720635012595966},
{0.02982524894414523,0.7960294528534776,-0.6045225923943728},
{0.06044845078254851,0.771240325815404,-0.6336673769685003},
{0.39853147682617784,0.7508330886150654,-0.5267089661468723},
{0.5064791750802103,-0.7699987479196643,-0.3880473855242669},
{0.6915097194255992,-0.5412907322343518,-0.4783499254072567},
{0.6821820938260278,-0.31326328196097214,-0.6606767038712482},
{0.5165092054707541,0.10175559968464454,-0.8502141133836751},
{0.1730040863122983,0.738283764658595,-0.6519253553596294},
{0.02333472513947977,0.935872432259838,-0.35156547205139493},
{-0.030177551470480436,0.9139798331575955,-0.4046358609521165},
{0.08036650697795937,0.9053489277336344,-0.4169946565697457},
{0.3647674607802996,0.8848108685634978,-0.28992141422772},
{0.16255581541390704,0.9581557383204529,-0.23561236809367112},
{0.47127757172278995,0.868831619589775,-0.1517533103167081},
{0.5662495074250304,0.40773906783206837,-0.716317211788427},
{0.8109365742124793,-0.09630817649585897,-0.5771538856705121},
{0.83700927115326,-0.39940886986266216,-0.3740160887963506},
{0.8881766712428486,0.2899871479760308,-0.3564402539959542},
{0.5329824097332659,0.7271430099056451,-0.43265782560850524},
{0.16335068720842355,0.9177244679376073,-0.36207506671569006},
{0.9955518280430108,-0.07357495569612889,-0.058849669281417},
{0.48370454198874563,0.8461685206637061,0.2236710770243956},
{0.5911788854563006,0.5451505365083854,0.5944059369953045},
{0.8276930870584941,-0.27254816476951993,0.49055239426216923},
{0.3176847945020111,0.324445712048071,0.8909609145612591},
{0.06618546407137886,0.741541789446131,0.6676340755613708},
{0.12360239604594699,0.9447690693452322,0.30353558819394594},
{0.3654822881621299,0.929527061640133,-0.04901161819848512},
{-0.014255247552954627,0.728285298172543,0.6851257639170594},
{0.032608428553990994,0.9377075144296793,0.34589204640950066},
{0.13731452028831093,0.990522515619558,0.0031414278112947536},
{0.02595064652213397,0.9931111833941577,0.11426609892062994},
{0.0,0.9971669788529512,0.07521978652773612},
{1.8383829686410754e-19,0.9908511064387776,0.13495956753431762},
{0.01479245873671874,0.9800317313667446,0.1982901628392683},
{3.673146799119034e-19,0.9757163342473265,0.21903797634875924},
{0.012857562654679926,0.9512648434284829,0.30810693069057216},
{-1.8628777371281222e-19,0.9450253587972489,0.32699705079729846},
{0.021197641000311695,0.9209788814506578,0.38903542247193534},
{0.0,0.9210176073247153,0.3895209455187956},
{0.037833215804909684,0.918061480080095,0.39462864388562113},
{0.0,0.9248520830885234,0.38032699668419395},
{0.05993363499029713,0.9423247067380288,0.32929030727906033},
{-1.5650293363530564e-18,0.9531441177879958,0.302516595786319},
{0.08123340271483721,0.9780014295455893,0.19213104405627085},
{-1.55834729450237e-18,0.9877422763858839,0.15609354708005033},
{0.09485520001176431,0.993314239928187,0.0657975059300605},
{-1.5264020239781883e-18,0.9988591112958041,0.04775432735738571},
{0.10247277367967307,0.9944457013567114,0.024022441748347258},
{0.0,0.999764208601583,0.02171467704688089},
{0.10653338037052405,0.9925296612324187,0.05946015843141738},
{0.0,0.9974008964049558,0.07205173037887906},
{0.10866666492862456,0.9788251432270711,0.17347303801972777},
{0.0,0.9795443524242117,0.20122838178008548},
{0.1083706370030816,0.9414148054292537,0.3193649466584375},
{0.0,0.9385704399282072,0.34508771246303654},
{0.10687627526836617,0.8868176711232122,0.4495907916854646},
{0.0,0.8809111973355,0.47328158891819966},
{0.10605792888340146,0.815764873378304,0.5685766325510071},
{0.0,0.8069162387349209,0.5906658815827169},
{0.10700987300315623,0.7244185946390955,0.6810041019119976},
{1.9760057079403e-18,0.7120725257608617,0.7021059165514467},
{0.1098967081880213,0.6291296513374476,0.7694924270825924},
{0.0,0.6213890883583837,0.7835021383947443},
{0.11368544282712809,0.5646698508167208,0.8174494355419313},
{0.0,0.564581542323803,0.825377296796608},
{0.11759337008367811,0.5468435696507522,0.8289354074015575},
{0.0,0.5572412274329631,0.830350657523076},
{0.11849356461153107,0.5922623315098966,0.7969846961015713},
{0.0,0.6161639980548643,0.7876178816539435},
{0.11283551774237915,0.6590315254705873,0.7436031161659558},
{0.0,0.6750912565515296,0.7377342308227786},
{0.10706839987113839,0.6787858865067162,0.7264888698585309},
{0.0,0.6841442939833158,0.7293466836903217},
{0.11995680922953635,0.6167741023085458,0.7779460589532902},
{2.552490567415835e-18,0.602670055196074,0.7979904789970624},
{0.19341155746738922,0.33631946256853346,0.9216730377610336},
{3.9672920555294496e-18,0.27162722196157757,0.9624025417097753},
{0.2901171564351573,-0.18198292380931677,0.9395287387748131},
{5.202271796475223e-18,-0.2641745428777439,0.9644748886805374},
{0.2746295624823685,-0.6341489754623147,0.7227957390098804},
{8.730128791304229e-18,-0.660002799153877,0.7512631397247219},
{0.0,-0.9312631831289979,0.3643472021965403},
{0.2515394886876423,-0.9259062963416896,0.28182515151344245},
{0.0,-0.9594075333020511,-0.28202337676737677},
{0.07176754007021638,-0.9249907283487189,-0.37315087117837},
{0.0,-0.7332290465210861,-0.6799817389737601},
{-0.051311139843805545,-0.7183288832588147,-0.6938088947282771},
{-1.696607180703355e-18,-0.7016760460311987,-0.7124961237971917},
{-0.07086863738132838,-0.7257399974001473,-0.6843092081868751},
{2.2251754936511673e-18,-0.9376836086132609,-0.34749021588817885},
{-0.010424757823193164,-0.995490050697991,-0.09429148098125864},
{1.4304827885451418e-18,-0.5740507246409683,0.8188197393438797},
{0.09069156345780156,-0.4275386840541776,0.8994363312401839},
{0.0,-0.22659771463349798,0.9739884371607682},
{0.09487131210882745,-0.19544555892600823,0.9761149868918362},
{-3.937706828021333e-18,-0.16861935053397173,0.9856812439249828},
{0.08840839908917884,-0.16008519629363185,0.9831361476917212},
{-1.2881559959933594e-18,-0.1799281127966069,0.9836797620290109},
{0.07876918831452237,-0.18103658292244673,0.9803168725550098},
{-9.39157500446471e-19,-0.2426847555263896,0.9701052053437794},
{0.07241548391756504,-0.23628725370883602,0.9689810789812777},
{0.034055723555022455,-0.3323107325461062,0.9425549239847056},
{0.0,-0.35647720607929506,0.9343040198703524},
{-0.006181664716058679,-0.4507851324867434,0.8926110862801602},
{1.9833323333955536e-19,-0.4826676722171499,0.875803584256469},
{-0.041334432499275146,-0.5947427566608319,0.8028527374864192},
{-6.451589768432673e-19,-0.6022961778517982,0.7982727066266986},
{-8.987222262045722e-19,-0.7119736845826858,0.7022061466989264},
{-0.10998900242438049,-0.7191084132288531,0.6861381124592706},
{0.0,-0.8158459461335484,0.5782693076564371},
{-0.16372201067826206,-0.8128297472213497,0.5590195929048853},
{9.30229273316817e-19,-0.8702142604348991,0.492673462788226},
{-0.17491958738584096,-0.8650472118778163,0.4702089526701755},
{0.0,-0.9003914634920365,0.4350806965043024},
{-0.13850161766323485,-0.9008042323894496,0.4115446960099492},
{0.0,-0.9168079266115533,0.3993284684344767},
{-0.07968379390138662,-0.9219047039687953,0.3791334986382622},
{-0.4206848720348409,-0.852704129313527,0.3097093900621829},
{-0.2440573938591701,-0.925815133831458,0.2886214241377614},
{-0.8009902630811259,-0.5960207041473096,0.05633754234055641},
{-0.5688409830379533,-0.822334219710793,-0.013651633933574726},
{0.11787900424936361,0.9028500079324767,0.41348083816968473},
{0.14854799548357886,0.924839549687027,0.35015039679044757},
{0.17860357016569275,0.961255240841741,0.20997410954295084},
{0.19736558599415732,0.9772673234021798,0.07742999467597853},
{0.207668044483637,0.9777464831981386,0.029762356996955935},
{0.2132079977490019,0.9751798547719926,0.059721022619652266},
{0.21563072922772966,0.9618023169419283,0.1686407179119445},
{0.21340806492869696,0.9259905244495301,0.31144589651024973},
{0.20885610927603615,0.8729594011164972,0.4408185676901586},
{0.2056346712879927,0.8023165276459489,0.5603593234973666},
{0.205594197546629,0.7097639854831362,0.6737700726852239},
{0.20859348203425623,0.6125391094514289,0.7624202244466465},
{0.2135585968601316,0.5458569061715154,0.8102055070733556},
{0.22049255209754215,0.524628989160084,0.8222818605577903},
{0.22741026646870793,0.5653376223141119,0.7928921386297494},
{0.2271320351173588,0.6296823811496969,0.7429072199764214},
{0.2281412520041281,0.6448701076020256,0.7294478140726318},
{0.26373664135789077,0.5677621727762302,0.7798006791287587},
{0.38368908468658663,0.25738710170545914,0.8868678403054386},
{0.49433456328030156,-0.21575340116863687,0.8420711427371436},
{0.49016463433909097,-0.5710458802580103,0.658517451464712},
{0.44518800223773075,-0.8291842187316989,0.33802540447410184},
{0.20492819919004365,-0.9393169998572832,-0.2751145342504435},
{-0.022053851918419652,-0.7532009441411388,-0.6574206913084325},
{-0.06256046541788886,-0.758865179450838,-0.6482359351221935},
{0.08379836679927948,-0.9924176533862066,0.08991682250384692},
{0.19295527960991324,-0.3471037518984208,0.917762085449546},
{0.1853147803267124,-0.16419104971014498,0.9688651770951121},
{0.17419928105530105,-0.14120601995856571,0.9745334629489526},
{0.15739736687876593,-0.16660925611578264,0.9733793837328674},
{-0.1297446779977929,-0.5557718633298006,0.8211479491919655},
{-0.3147931135648497,-0.6414394153465739,0.6996147311856671},
{-0.4710828235769553,-0.7101159490787281,0.5232746049587925},
{-0.5189281885399413,-0.7612184388142318,0.38892161620033266},
{-0.8477146068782329,-0.4884235187109789,0.2069357669791987},
{0.29582542845763754,0.9278280373820293,0.2272057414011952},
{0.2998592692915603,0.7818992409402936,0.5465510000328645},
{0.2877341608305078,0.7015845253841186,0.6519111952043042},
{0.3009282144435276,0.594686730388148,0.7455131806025193},
{0.2940112370449914,0.5224539053109375,0.8003744806755296},
{0.30080735200611364,0.49236548466724117,0.816756491549019},
{0.3208822654035168,0.5186383677365438,0.7924953092991027},
{0.33929845289992716,0.5671165282528049,0.7505034331981442},
{0.36944846959577465,0.5559122944088367,0.7446269866439456},
{0.42895122873748087,0.4500088386626525,0.7832578684508035},
{0.545840418635658,0.13909992343322802,0.826262336479474},
{0.6224168110246594,-0.24249863114649936,0.7441718398635945},
{0.6134381026186029,-0.5057975955873607,0.6065166828321651},
{0.5839815147062631,-0.7059781753572915,0.400699895683251},
{0.403745762320385,-0.9107108401724077,-0.08715001434766774},
{0.14525189140831296,-0.8512537884891589,-0.504250806271207},
{0.09320411192036106,-0.8772178796399789,-0.47095836881944897},
{0.2760170783821783,-0.855362947103555,0.43837062078073574},
{0.28356899248654843,-0.2572195659043841,0.9238109771030673},
{0.26195993706404586,-0.12689902424273777,0.9566993409737682},
{0.2502293075210514,-0.11735128436908002,0.9610483701221612},
{0.3686919011362994,0.667515461012449,0.6469075601241948},
{0.3817162798649744,0.5728869403974732,0.7253228489493948},
{0.36386200404110763,0.5057836289935378,0.7821683723197431},
{0.34735330363041744,0.46672352354005453,0.8133356226253656},
{0.3745928898700543,0.45038332805625425,0.8104535919272453},
{0.4549141973770979,0.4320395945645033,0.7787135941752209},
{0.5329013540356101,0.3543352380992335,0.7684156986346472},
{0.6029886112815588,0.19548985031710575,0.7734264367654707},
{0.6360383298592373,0.05323144690179875,0.7698192359317952},
{0.6840353848815658,-0.19767316590549355,0.702154478523656},
{0.6849937424280567,-0.42595978356275244,0.5910514661360533},
{0.6492227296644453,-0.6443702896205815,0.40409995934339654},
{0.5396473294087566,-0.8389477514311156,0.07033797147112189},
{0.5071522478459884,-0.8617209519944622,0.015283926148696309},
{0.4740510875369553,-0.8707306721889289,0.1307809730597152},
{0.44106768729494955,-0.551672978491282,0.707895627919005},
{0.3539855214421359,-0.15084048974986183,0.9230067157184508},
{0.31747538118427315,-0.09539501255857288,0.9434559734936497},
{0.31338068395318064,-0.09369214183688014,0.9449943542069733},
{0.38596918732677227,-0.06652380718730402,0.9201099768569067},
{0.5054105445882483,-0.020556277964560974,0.8626341176044766},
{0.19439729048323362,-0.8285585063306562,-0.5250718951152205},
{2.7429975445778018e-18,-0.8903601830749946,-0.4552567895096809},
{0.0,-0.8350234276166959,-0.5502143903345899},
{0.1824621153580658,-0.7884484534616737,-0.5874151961712899},
{-5.463100919072513e-18,-0.7917781076904312,-0.6108088311265316},
{0.14929014351216885,-0.7617159790684158,-0.6304769783917259},
{0.0,-0.7627742820374256,-0.6466648240489735},
{2.5685536629628514e-18,-0.7358110532481095,-0.6771868973318281},
{6.128295777811088e-19,-0.6639736589647923,-0.7477559629992301},
{5.643798007301915e-19,-0.549619083822735,-0.8354153833260777},
{0.1853914958081255,-0.8834850358381542,-0.4302141149847147},
{0.0,-0.9478261042464884,-0.3187878230248526},
{0.14396322489668986,-0.9442992704751879,-0.29592816300138275},
{-0.7422425179623567,-0.4760563235662935,0.4716422598977376},
{0.2712606023552867,0.8895449900056621,0.3675967850317429},
{-4.763255915053563e-18,-0.10563397261557994,0.9944050803517905},
{0.12256907732623176,-0.21731930923677298,0.9683744828919482},
{0.15783025914609952,-0.056980544095093504,0.9858208898641285},
{-0.024125229939502734,0.17522922618538747,0.9842320313680287},
{0.23124189707584572,0.2347348987528523,0.9441539664399299},
{0.3673222886677239,-0.04101613589678317,0.9291889005170058},
{0.29645818097583515,-0.2172842649919046,0.9300000511394754},
{0.27527834318619054,-0.21938962994287056,0.9359968077115415},
{0.1070444472376511,-0.21441227031847448,0.9708598583999974},
{-1.5579521190835567e-18,-0.23894051761600768,0.9710342059069775},
{-0.12256907732623175,-0.21731930923677298,0.9683744828919482},
{-0.15783025914609952,-0.056980544095093504,0.9858208898641285},
{-0.2474206723036523,0.22114194779126345,0.9433341135800691},
{-0.23231715516043408,0.3908325411577607,0.8906619247449226},
{-0.016706871572996915,0.3935395290030395,0.9191558733720355},
{0.24699130158890145,0.41441184882284826,0.8759327123099405},
{0.4433228351157439,0.430907916175368,0.7859918775931091},
{0.4315685730521681,0.25015744992814454,0.8667005347864758},
{0.6100334875832365,0.10127249507801823,0.7858772332671979},
{0.5684430504279112,-0.14406981299767863,0.8100101156177159},
{0.4932439148359235,-0.25763306064508723,0.8308643972032844},
{0.47887975424087914,-0.2580019731696221,0.8391121276794757},
{-1.1425411632863984e-18,-0.19142995684802805,0.9815062769137863},
{-0.10704444723765111,-0.2144122703184745,0.9708598583999974},
{-0.27527834318619054,-0.21938962994287056,0.9359968077115415},
{-0.29645818097583515,-0.21728426499190454,0.9300000511394754},
{-0.36732228866772393,-0.04101613589678317,0.9291889005170058},
{-0.4315685730521681,0.25015744992814454,0.8667005347864758},
{-0.4433228351157439,0.430907916175368,0.7859918775931091},
{-0.32212133372822455,0.5091229401942582,0.7981426427181444},
{0.03033584806366918,0.47706280985646676,0.878345496814386},
{0.3454401053869387,0.5172294050637967,0.7830356799837486},
{0.4945185943163571,0.5369749043560207,0.6834539574596205},
{0.6297066035072643,0.4426976012807229,0.6383482022530016},
{0.6376360268233653,0.33892577111172395,0.6917728087842394},
{0.0,0.38253260760247126,-0.9239419917510264},
{0.054090444961988636,0.37831512228974845,-0.9240951747578313},
{0.05652447514580388,0.3826469111785625,-0.9221639361171075},
{0.04182868757267295,0.4515584416793922,-0.8912605312948771},
{0.12259111830777668,0.3878919437684748,-0.9135158770768919},
{0.11447302952878546,0.38512964391086213,-0.9157352690005963},
{0.12446078586361049,0.443019266782029,-0.8878307507865032},
{0.06602700015339763,0.43275348293431787,-0.8990911290069323},
{-1.3338596293542674e-18,0.3770268434021028,-0.9262023317581565},
{-0.05409044496198863,0.37831512228974845,-0.9240951747578313},
{-0.05652447514580388,0.3826469111785625,-0.9221639361171075},
{-0.041828687572672954,0.4515584416793922,-0.8912605312948771},
{-4.992383193708663e-19,0.4541668347483837,-0.8909166550326884},
{-2.8950000331753295e-19,0.5509593343897098,-0.8345320915631992},
{0.0459582632612108,0.5570636694142184,-0.8291971455913122},
{0.13038011647637598,0.46574458518472445,-0.8752616789273454},
{0.23666821960766338,0.38039824241026404,-0.8940275896184193},
{0.20136258176585706,0.3851659318024657,-0.900611079014314},
{0.2045959497041788,0.4536664671651405,-0.867367992223915},
{0.23959118012397165,0.5860802529812226,-0.774019381845357},
{0.15133720240021523,0.5837698109424596,-0.7976903277600157},
{0.08566892142062935,0.5782617461501123,-0.8113409818578432},
{0.0,0.44378696132690326,-0.8961323188883624},
{-0.06602700015339763,0.43275348293431787,-0.8990911290069323},
{-0.12446078586361049,0.443019266782029,-0.8878307507865032},
{-0.11447302952878546,0.38512964391086213,-0.9157352690005963},
{-0.12259111830777666,0.38789194376847475,-0.9135158770768919},
{-0.13038011647637596,0.46574458518472445,-0.8752616789273454},
{-0.0459582632612108,0.5570636694142184,-0.8291971455913122},
{0.3520848159883502,0.4716124798197211,-0.8084664193575034},
{0.40343911434762453,0.36862686800787603,-0.8374670818588084},
{0.5730882330076608,0.3410839385986686,-0.7451386609337733},
{0.717296075375239,0.3372343652308219,-0.609720692742705},
{0.6215128800702149,0.47767373814097713,-0.6209263561786147},
{0.6605713180216872,0.5718752216485983,-0.4864198440354356},
{0.4146919806198963,0.5926593588945585,-0.690496521008063},
{0.3182516402982906,0.46741551905459466,-0.8247658006939735},
{0.13832970069391068,0.5664510331455608,-0.812402683990064},
{0.2808633258636687,0.5592030247832244,-0.7800049802777488},
{0.7060932483448326,0.39172151536603683,-0.5899038727124772},
{0.0,0.5723191786372169,-0.8200309492720512},
{0.016693373178315016,0.4968502928987132,-0.867675698483248},
{0.0,0.4953105948367108,-0.868715957400636},
{-0.016693373178315016,0.4968502928987132,-0.867675698483248},
{0.0,0.3109947516356951,-0.9504116289561342},
{0.023956693642325052,0.25634401421122893,-0.9662886852322141},
{0.0800766070961206,0.502157503080058,-0.8610607290408586},
{0.026730375008098495,0.5786016436694036,-0.8151721443934349},
{-0.02673037500809849,0.5786016436694036,-0.8151721443934349},
{-0.0800766070961206,0.502157503080058,-0.8610607290408586},
{-0.02395669364232506,0.25634401421122904,-0.9662886852322142},
{0.0,8.233669091787636e-05,-0.9999999966103346},
{0.02562252020396414,-0.04910835019436996,-0.9984647497030551},
{0.09628176858400102,0.2570333124047976,-0.9615943517682259},
{0.102912880742202,0.5843914284332773,-0.804919621671043},
{0.2049338393043257,0.23698358351874546,-0.9496530433008692},
{0.09854289897571686,-0.04625727454006991,-0.9940571219067775},
{0.22629054702087403,-0.02529806537228253,-0.9737312751562482},
{2.320258605758659e-19,-0.26178883516571605,-0.9651251762246064},
{-0.025622520203964147,-0.04910835019436996,-0.9984647497030551},
{-0.02954211555453574,-0.3026941998696621,-0.9526297731930424},
{-0.044097375321972526,-0.5082286142569926,-0.8600924933634347},
{-0.03655728055952846,-0.6770469450912578,-0.7350312914296147},
{-0.11591518458335719,-0.8117394500204,-0.5724008519067602},
{-0.24312707137147765,-0.9046625496435067,-0.34996413878973137},
{-0.22120999599775462,-0.958390229321585,-0.1804281186832947},
{-0.2231721415483615,-0.9747678817603712,0.004666039553741489},
{-0.24184907204959188,-0.9533079689399185,0.18086719631928508},
{-0.3926851598075869,-0.898674091192147,0.19540533024167675},
{-0.5858290541748435,-0.7635398016697047,0.2716823338952979},
{-0.7500209954203085,-0.5885773603548248,0.3017369670863621},
{-0.8814779823341431,-0.37776125434219254,0.28336019723655814},
{-0.8818317509886197,-0.34059891818072335,0.32613668895490167},
{-0.8728927431683454,-0.3067922412979174,0.37939000988882365},
{-0.835925037176838,-0.2747721826934491,0.47511007128746474},
{-0.7353605894595374,-0.21017570101529365,0.6442600237267959},
{0.6503050896847704,0.38513070689006523,0.6548111399025227},
{0.5265956455347935,0.5596619201264312,0.6399027748527039},
{0.5069022409094506,0.5822058474829028,0.6356779603837874},
{0.4690320278325683,0.5936977363872207,0.6538592774259299},
{0.46945204490261094,0.5758742416112802,0.6693157964558956},
{0.5368766528405968,0.5914707155451275,0.601602736269718},
{0.428982558330824,0.6123441273775029,0.6640848095794886},
{0.413784819919496,0.6701154011666589,0.6162203111902739},
{0.49052955352080924,0.5860887091985392,0.6448881934666394},
{0.4117631344297478,0.52740409781741,0.7431662255040881},
{0.19701897712666047,0.5168827662549735,0.8330760641145386},
{0.2242780463339776,0.5310810603887425,0.8170999114116847},
{-0.03459730089924596,0.5526524790869217,0.8326933794197997},
{0.3715081000427153,0.5566257301613302,0.7430676470719325},
{0.06715854039750664,0.6282918948199646,0.7750735612541656},
{1.3099303860686166e-17,0.7275465078700012,0.6860583640523352},
{4.175657892059824e-18,0.8128451428477488,0.5824798483628619},
{0.3402923999562963,0.749752389841561,0.5675142610180399},
{0.38555703609218717,0.6587505799332997,0.6460599394462941},
{0.3699531677391986,0.5299889875091791,0.7630506711868665},
{0.15466030893035804,0.5311831120051528,0.8330214225109026},
{0.29206752365557653,0.5342220913865531,0.7932864039552654},
{0.19776820723022603,0.6336626242278626,0.7479033459382308},
{0.3217443409603713,0.6379927458861286,0.6996040560607507},
{0.2910904630153967,0.7713230154353843,0.5659745119712971},
{0.8263965356314839,0.47941036539305165,-0.2953548161956775},
{0.8612934240339232,0.38666897996875355,-0.32963728194159764},
{0.8908569184426351,0.2966449172750992,-0.34405776247273023},
{0.9396673462522039,0.2620923316553735,-0.2198474199866589},
{0.881586140228741,0.3688282298503084,-0.29457021950984585},
{0.7633026744831035,0.5393611948925306,-0.3556100794002369},
{0.779195573898666,0.5707315492084173,-0.25907480841426594},
{0.6874468504171886,0.6682017679427934,-0.28447007781067685},
{0.7288657390460007,0.6527835092360338,-0.20646652153416042},
{0.676916330074935,0.650497404640633,-0.3444378153363569},
{0.46564040541914575,0.7204549181876431,-0.513929687506307},
{0.741468012868005,0.6657378285858389,-0.08377547065450783},
{0.9708074336442775,0.19141202266545784,0.1445488303658323},
{0.9167139446111339,0.31387263377570707,-0.24722361036558776},
{0.5012363649642773,0.6835161215728265,-0.530629642959606},
{0.7496037161163587,0.3068474029944803,-0.5864630764678102},
{0.958929949586737,-0.02891464255575502,-0.28216536858985913},
{0.9934121550139069,-0.10516493350539081,0.045526113730829564},
{0.8913128288504356,0.05848205229329748,0.44960125743396023},
{0.7227923533256322,0.24409138649551498,0.6465219323524081},
{0.7855922596667656,0.5316333304986933,0.31656090007221743},
{0.386026191477039,0.9213556794758804,0.04568907299640971},
{0.1233283603858951,0.9035936824425578,-0.410254277947744},
{-0.10921665117637526,0.696768425257125,-0.7089326376113065},
{0.1538929261971912,0.5424647690175496,-0.8258625440357508},
{0.45824437584799876,0.3276796795545516,-0.8262191716552603},
{0.7944586464479427,0.009375379227216572,-0.6072458821173254},
{0.9126053800412273,-0.2170665274837565,-0.3464585732319968},
{0.9710983104057174,-0.23852997422687103,0.008457122589241497},
{0.879858987885532,-0.08801482586139289,0.4670134386349456},
{0.619914328669711,0.006343388207002761,0.784643859681599},
{0.3941141789455841,0.11556408505440323,0.9117669418220792},
{0.4512452507350787,0.3946300586525221,0.8004029238433246},
{0.5099929557149904,0.7023558548985017,0.4965918225372653},
{-0.05565664555233363,0.9871097411542662,0.15005564542601985},
{-0.24958611429447866,0.926086764915524,-0.2829665623349909},
{-0.42070075729173395,0.695955341759268,-0.5819424671657001},
{-0.34415151523844206,0.4754954238323128,-0.8096072112287622},
{-0.06687970278028685,0.36408446429895436,-0.9289615752075884},
{0.41355435426445997,0.16596765932293636,-0.8952248500392352},
{0.7156315193443545,-0.12083379969683736,-0.6879467431216717},
{0.7305076685644465,-0.23166500411385996,-0.6424094271081815},
{0.8891804054066526,-0.30012831512345783,-0.34537110635085744},
{0.9538961499540596,-0.2992659149357264,-0.02284835356223558},
{0.8611075858086656,-0.19192171284701906,0.4708075846889449},
{0.566318036737247,-0.08960672379630841,0.8193012366135928},
{0.29549026261998285,-0.010976591837806153,0.9552826906881544},
{0.11684741281983413,0.1768425116075615,0.9772785724682809},
{0.15537733867190648,0.41618609106675586,0.8959056982907351},
{0.10424131401824513,0.776652078369412,0.6212449578195564},
{-0.5002544744287796,0.840712404710127,0.20723926601998277},
{-0.5532816604933808,0.8123320747907468,-0.18438005431132673},
{-0.6174465665814854,0.6596656410684542,-0.42848684858520536},
{-0.5748617092940915,0.48538663298002427,-0.6587365419587641},
{-0.4385360984399338,0.3439837598787374,-0.8302778229633547},
{-0.1473006849873328,0.23787987406409633,-0.9600602448375373},
{0.30244836864470875,0.05824213905341949,-0.9513846948225709},
{0.39311079670120214,-0.07028468073820085,-0.9168009408647416},
{0.31809970318984215,-0.07702809732277924,-0.9449228810084804},
{0.7242492667308698,-0.25575819050072834,-0.6403520497598104},
{0.8793231228279532,-0.30640591322368244,-0.364563111136683},
{0.9720203183639236,-0.2255451672376694,-0.0656191909690173},
{0.8652858730273321,-0.1963257061860549,0.46123375313378195},
{0.5369196906614682,-0.10476098380958145,0.8371035670998195},
{0.2712873873307227,-0.04107030251007598,0.9616217467003338},
{0.02233751941960511,0.03129110498713339,0.9992606776886915},
{0.011896961893270077,0.0903404235726733,0.9958398817914553},
{-0.21523709305581476,0.3146892934201545,0.9244693842305467},
{-0.13770384600673174,0.44979397204822646,0.8824528505841168},
{-0.3184804575041478,0.6930190765082629,0.6467571088001918},
{-0.7305349188510544,0.6320022264825513,0.25863471936378024},
{-0.7869387204171906,0.5905433815521053,-0.17884620435770843},
{-0.7032300822830136,0.5167207944174352,-0.4883309041918609},
{-0.6313393290689888,0.38712333225488554,-0.6719718574424025},
{-0.4665319211325591,0.2665771506985794,-0.8433768963457503},
{-0.11551563734679036,0.13249762380653335,-0.9844290310702885},
{-0.21188547309689618,0.14664262741303966,-0.9662300378874095},
{0.3679456812167491,-0.015482424593143484,-0.9297183822011159},
{0.7747306372562885,-0.17013757836305604,-0.6089709714963595},
{0.9181956373923976,-0.15880896882259424,-0.3629001004340904},
{0.9779245774865022,-0.02217065340054536,-0.20777868725073606},
{0.976662707092105,0.18827127456584603,0.10336287413221887},
{0.9050375060772957,-0.006714779356112629,0.4252787607341656},
{0.5842463406223257,0.06776433056386842,0.8087423625436299},
{0.2760030043945566,0.07508785036277994,0.9582192631611385},
{0.010035732149515673,0.0763831226159748,0.9970280350419722},
{-0.3201357289885925,0.16546081211417563,0.9328107174981751},
{-0.3384730151208965,0.1691963838375515,0.9256395636160251},
{-0.2662987963281102,0.2198575469188029,0.9384815449102055},
{-0.5996511793878001,0.37068114602010105,0.7092347644074175},
{-0.5678374366866825,0.5263907560190974,0.6328296907341981},
{-0.8436094233052708,0.48291724565551064,0.23476387021653014},
{-0.867015034106375,0.462265341402932,-0.18599915260869385},
{-0.7645651358391864,0.4372929550961917,-0.4735134892296589},
{-0.661725049335324,0.33303223708299523,-0.671721287548384},
{-0.5003041805707902,0.25892482898498603,-0.8262285760239026},
{0.6048515950317571,0.7868343462499657,-0.12266319557604928},
{0.7541446636244439,0.633121809630614,-0.17442075706988228},
{0.7153889843628392,0.6881969616892515,-0.12084511977729309},
{0.5439411276963868,0.8321449671902162,-0.10799445902627156},
{0.9197380926713463,0.3373104797570784,-0.20075726919671755},
{0.9061924114383121,0.21811634582731185,-0.3622714081107661},
{0.7862095423494414,0.23492888995446812,-0.5715618708271601},
{0.6902632066438575,0.6800424890452472,-0.24714149519431974},
{0.6794865918084391,0.7246989133169138,-0.11449653527437414},
{0.8276661754971097,0.5561486234705911,-0.07528220606328105},
{0.35571186539304805,0.9300451962860697,-0.09211406887009266},
{0.5513126112265169,0.8342985073294645,-0.0006366870713303903},
{0.4178992018431707,0.4548800694048959,-0.7864123470273328},
{0.4953309211519966,0.831110927154265,-0.25278826182299774},
{0.6355139772338634,0.760402543593812,-0.13382808537992852},
{0.4577805385052514,0.3766817633565469,0.8053246722412299},
{0.284483215528201,0.3649119433834734,0.8865148468349708},
{0.07511914228484842,0.2967811314713682,0.9519863835501867},
{-0.24486871895434387,0.31181311765249736,0.9180478691971833},
{-0.6709494468028091,0.39523458298039316,0.6273886070461586},
{-0.7137914184626373,0.30446010628028125,0.6307185224907352},
{-0.7300002222740194,0.3359246486705582,0.5951926628373743},
{0.4827612728322935,0.7268321523931583,0.4885248977287368},
{0.7267917531636342,0.4206367018743971,0.542990342980021},
{0.6728722027256085,0.7176960467134409,0.17931922186727833},
{0.5206216225398358,0.8086915792006629,0.2738084291506139},
{0.26150871829533046,0.9302121627110868,0.2575238291884777},
{0.38877734958511784,0.7710070378108197,0.5043811258321986},
{0.41658540378355435,0.6259268593628926,0.6592967223357011},
{0.29015731910073816,0.5812001043082725,0.760273088386223},
{0.10668667452137412,0.5834581805857224,0.8051052757168897},
{-0.17434550633420132,0.632480141631375,0.7547002814780358},
{-0.48611446507366285,0.7112659056128491,0.5077337278129948},
{-0.8682396034056121,0.46768124943551903,0.16563284699750036},
{-0.9028265820539256,0.39352798730368566,0.1733201833184371},
{-0.893531380281306,0.40706601776858525,0.1894701285971219},
{0.218067835546994,0.7643359518316294,0.6068253223436595},
{0.2998490495839525,0.6733888557905547,0.6757499510622903},
{0.31606597836736244,0.703285654015359,0.6367822125145068},
{0.3697149429926584,0.7046704645258851,0.6055992052115067},
{0.22310920671446688,0.7800467741148372,0.5845932877413813},
{0.08654299370948787,0.8542474592929392,0.5126125130460214},
{0.21546215214361444,0.9615222393806258,-0.17044366861256052},
{0.3411541450255334,0.931260115671356,-0.12793922890055986},
{0.2906874044853722,0.9537470626565016,-0.07659878163295168},
{0.26438130936802917,0.9637338299779377,-0.03632668733730159},
{0.07369037132839361,0.9774513963159219,-0.19788506010696746},
{0.24384961123607177,0.9695066004894336,-0.024378652699406842},
{-0.01642737304140016,0.9889152787575598,-0.1475693493067455},
{-0.0021774040458172514,0.9992481629979599,-0.038708754265976815},
{0.2150722643685975,0.9765743603510829,0.006814675651677986},
{0.027398166209691613,0.9946956121684765,0.09914625369183626},
{0.1591458740797805,0.9813804396654908,0.10754079879445899},
{0.1195928900891881,0.9557900589665799,0.26863153914009646},
{-0.027723718654683416,0.9489279506740897,0.3142723975366405},
{0.14977315034460154,0.8780526685862358,0.4545233928242237},
{0.25076570044816515,0.8947307999051397,-0.3695583298747983},
{-0.07586141550823039,0.5317837869714006,-0.8434755773295652},
{-0.24598697234213224,0.7144950200502217,-0.6549712022382239},
{-0.4817093633699596,0.6696162442629657,-0.5653053817724262},
{-0.5515422569192013,0.7421938608760865,-0.3807222238198366},
{-0.5820353893327458,0.7953943518585161,-0.16906398373352569},
{-0.6066335671613129,0.7844390293681147,0.12903923588254396},
{-0.6723652441095511,0.32327875046075905,-0.6658947574609925},
{-0.47250568622419314,0.33554732552517064,-0.8149517585837271},
{-0.6425931424447984,0.39774384168257343,-0.6548846384566573},
{-0.7890345778375233,0.36772191845393215,-0.49214329789739186},
{-0.7735443505312879,0.44211226708723206,-0.4540549317561873},
{-0.18912935952616003,0.2250039142741459,-0.9558259904012536},
{-0.8048083789943427,0.3820948791280691,-0.45418826101585336},
{-0.8897226479026866,0.40056409144815724,-0.21895665884221047},
{-0.8483249443510474,0.4960604722791238,-0.1851183314369614},
{-0.8975668330339767,0.41177144676856214,-0.1575374744734812},
{-0.015431464158865602,0.9682833201022933,-0.24937778955952222},
{0.09568300236285207,0.9902641308372854,-0.10110249371754469},
{0.2934451634108754,0.9530203395193398,0.07511436968521212},
{0.07991450635590784,0.9922621572645872,0.09502359146295708},
{0.12268466129936473,0.9088731128885627,0.39862029370080254},
{0.02857411088510027,0.9613864247466818,0.2737145639163527},
{-0.017378236206459615,0.9997698208016141,-0.012581825013118789},
{-0.016736098553513042,0.9842399078766302,0.1760446157887532},
{-0.050327521170070826,0.9830007348169544,-0.17656923843694813},
{-0.03222873740634698,0.9994750857236769,-0.003295679420279698},
{0.011293380527409028,0.9999275113861227,-0.004175108312208862},
{0.05606198512115455,0.9974069079022527,-0.04512775080970072},
{0.015504552114915738,0.9424894908330694,0.3338759777715932},
{-0.03295383979714369,0.9698113584511849,-0.24161948071645917},
{0.06052320631696616,0.7492851607980783,0.659476071821345},
{0.010660917968736099,0.5932204023077738,0.8049695019774766},
{-0.011607356643260151,0.506017243251941,0.8624452555400036},
{0.014336923587092812,0.8598908904772758,0.5102765025907577},
{0.27684835299835286,0.8037125319024072,0.5266888602439979},
{0.1595288718605711,0.8796172561620883,0.44813393277542907},
{0.17302904049907153,0.892295039168827,0.41697783420545526},
{0.15985300005727227,0.9101690548142272,0.3821508995557463},
{0.14212998054764914,0.9504276406169386,0.2765616903709625},
{0.13304754155173368,0.949218776169775,0.28510009935774155},
{0.2123449292586352,0.794167738122806,0.5693919868974724},
{0.3032980655002108,0.6475714041603954,0.699043317668915},
{0.20456026462407162,0.8659351222558006,0.45641150531155694},
{0.03707159175110136,0.9269511173876881,0.37334611697291875},
{-2.1947756921921453e-18,0.9563281952493734,0.2922950272773668},
{0.09111546512021568,0.9597403675212521,0.2656998286903824},
{0.0894820329191724,0.983459211103056,0.15748316062743575},
{0.13741051547654945,0.9808331733027725,0.1381471548215242},
{0.15541476564751772,0.9784712214101364,0.13579513795008602},
{-0.011832879768533262,0.8787274997174243,0.47717707844860646},
{-0.13817904699218514,0.9179542072643211,0.3718422035461595},
{-0.09111546512021568,0.9597403675212521,0.2656998286903824},
{1.2132727690622937e-18,0.9835922462292691,0.1804059122026242},
{-1.596748125640281e-18,0.9991529645221057,0.04115037650724466},
{0.10632798600296427,0.9929954420249857,0.05152098126158436},
{0.16409945011932126,0.985890673834307,0.03302952795715839},
{0.20325377345289591,0.9788628324946338,0.022703716386117862},
{0.23788009252866654,0.9709911332309032,-0.024275105880704057},
{0.11860861254536978,0.9756673286199024,-0.1844051541952278},
{0.186900623912287,0.9815192416175522,-0.04108692146782247},
{0.19170306172491647,0.969838599321863,-0.15054244381801338},
{0.11532423479135091,0.9190347475233476,-0.3769289770162095},
{0.19373663209392686,0.9099017055907388,-0.3668037670852998},
{0.25903816008749875,0.9494041368341456,-0.17756975131112407},
{0.2538100646983,0.9657887431977283,-0.053221749035494856},
{0.10675641039810334,0.9930463572255752,-0.049618557414813476},
{0.011858121716373422,0.984553157083015,-0.1746839025990298},
{-1.8972807113758775e-18,0.9347198533118534,-0.355385418700131},
{0.0,0.8115071363171024,-0.5843425088990324},
{0.10775270954454932,0.7827483378308757,-0.6129391431527351},
{0.1808895149966198,0.7763790926233877,-0.6037503522993364},
{0.28997202223521984,0.8726736392443739,-0.39288286509950715},
{0.3356127910823731,0.9199131577876984,-0.20279012942193264},
{0.4873995678633205,0.8419859921878262,-0.23130337266484044},
{0.48474769842404125,0.798613400375115,-0.35670198431448485},
{0.275289096922423,0.7514668429081487,-0.5995944438746047},
{0.6665981582887801,0.7061484299945491,-0.2387494297003451},
{0.6438990475362193,0.7443781308565345,-0.17690453607661363},
{0.4621411182901833,0.8735677929449782,-0.15265941803484867},
{-1.0742828141001315e-18,0.612828259226742,-0.7902161253056794},
{-0.08566892142062935,0.5782617461501123,-0.8113409818578432},
{-0.1513372024002152,0.5837698109424596,-0.7976903277600157},
{-0.2395911801239716,0.5860802529812226,-0.774019381845357},
{-0.2045959497041788,0.45366646716514064,-0.867367992223915},
{-0.201362581765857,0.38516593180246567,-0.900611079014314},
{-0.23666821960766338,0.3803982424102641,-0.8940275896184194},
{-0.31825164029829056,0.46741551905459455,-0.8247658006939736},
{-0.13832970069391068,0.5664510331455608,-0.8124026839900641},
{-0.102912880742202,0.5843914284332772,-0.804919621671043},
{-0.01940518344502709,0.9976758490761777,-0.06531721844653732},
{-0.11473831619180343,0.9927113369024192,-0.03686896232444321},
{-0.1063279860029643,0.9929954420249857,0.05152098126158436},
{-0.16409945011932128,0.985890673834307,0.03302952795715839},
{-0.18690062391228698,0.9815192416175522,-0.04108692146782246},
{-0.20325377345289597,0.9788628324946339,0.022703716386117873},
{-0.23788009252866654,0.9709911332309032,-0.024275105880704057},
{-0.2150722643685975,0.9765743603510829,0.006814675651677986},
{-0.24384961123607177,0.9695066004894336,-0.024378652699406842},
{0.6961408543770494,0.7015651183575805,-0.15229673526082477},
{0.6008740280187702,0.7693102286084703,-0.21705339115268688},
{0.6718888204989898,-0.7148206587922589,0.1938990424222798},
{0.5311311401140084,-0.8124084628904049,0.2406079828792956},
{0.7348004749347209,-0.6361717086705703,0.23527392359306593},
{0.6369920690574785,-0.677622043803911,0.3675179855583712},
{0.45594434294916686,-0.8220797309100619,0.34102737743397193},
{0.2843564570611561,-0.946832792752359,0.15049607269425774},
{0.7046757925941387,-0.7093956175747719,0.01377988017112016},
{0.7749341148670619,-0.630756704803693,0.04028767752539604},
{0.6830814850657114,-0.7301952044458777,-0.014650875900948228},
{0.6434266493189199,-0.7388183321260695,0.2003736985252317},
{0.5714394191346389,-0.7494584450657937,0.33431875415332146},
{0.4751244366926862,-0.782626691103568,0.40218432593742154},
{0.3079241231539765,-0.8812185967757239,0.3586593356884481},
{0.21444696538142097,-0.9502475328309573,0.22592504373658573},
{-0.041377140098179915,-0.9949772292732301,-0.09114957764609687},
{-0.22120482455333568,-0.9727790869322552,0.06905992775536188},
{-0.0810393567285473,-0.9537511480810258,0.28946739055573883},
{-0.024129930041722227,-0.9324033867774838,0.3606129099215107},
{0.0,-0.9256027096659787,0.3784965308414304},
{0.07968379390138662,-0.9219047039687953,0.3791334986382622},
{0.024129930041722234,-0.9324033867774838,0.3606129099215107},
{0.24405739385917008,-0.925815133831458,0.2886214241377613},
{0.0810393567285473,-0.9537511480810258,0.28946739055573883},
{0.5688409830379533,-0.822334219710793,-0.013651633933574736},
{0.2212048245533357,-0.9727790869322552,0.06905992775536188},
{0.6043464939503107,-0.6128636699493666,-0.509080973231333},
{0.041377140098179915,-0.9949772292732301,-0.09114957764609685},
{-0.0036041723308793423,-0.9641648655254768,-0.265279328308952},
{-0.2843564570611561,-0.946832792752359,0.15049607269425777},
{-0.5311311401140084,-0.8124084628904049,0.2406079828792956},
{-0.3461875945180514,-0.9375087112153759,0.035093671752753845},
{-0.6718888204989899,-0.714820658792259,0.19389904242227984},
{-0.4546293087540662,-0.8876835042359417,0.07300813604796921},
{-0.7046757925941387,-0.7093956175747719,0.01377988017112016},
{-0.4828923238556363,-0.8756098350018522,-0.011064375686525305},
{-0.6042381840533242,-0.7852052555191196,-0.1354581988552011},
{-0.4200834641053345,-0.9036658298872802,-0.08317422124309569},
{-0.3530705058095201,-0.93308836202411,-0.06846405321461124},
{-0.4637697238904201,-0.866957250955887,-0.18249046062086274},
{-0.03954624563916638,-0.9850160999363441,0.16786714187726176},
{-0.2583120794864684,-0.9544165433780889,-0.1495457499148569},
{0.004003129998332617,-0.9988829367319083,0.04708347540331878},
{0.5862588444397177,-0.5881972193267503,0.5570678580680147},
{0.04032127948333865,-0.9968283518750172,-0.06861072306107374},
{0.24298607796000601,-0.9683728856451779,-0.056672041297670984},
{-0.08708586257530808,-0.9819138896990325,-0.1681105759779283},
{-0.12196273204893815,-0.954355538686521,-0.27263638379629246},
{-0.08966407491652123,-0.9802745875947603,-0.17613087913618922},
{-0.14396322489668986,-0.9442992704751879,-0.29592816300138275},
{-1.3756684377704356e-18,-0.983291401306784,-0.18203851272777685},
{0.08966407491652124,-0.9802745875947603,-0.17613087913618922},
{0.08708586257530808,-0.9819138896990325,-0.1681105759779283},
{-0.040321279483338655,-0.9968283518750172,-0.06861072306107374},
{-0.004003129998332617,-0.9988829367319083,0.04708347540331878},
{0.2583120794864684,-0.9544165433780889,-0.1495457499148569},
{0.4637697238904201,-0.866957250955887,-0.18249046062086274},
{0.6042381840533242,-0.7852052555191196,-0.1354581988552011},
{0.42362286371492036,-0.8592065942773386,0.28689318166925326},
{0.3510503348634451,-0.8651283880613255,0.358212973749801},
{0.31374400465999464,-0.8640111694910578,0.3937631249045595},
{0.22396396183673414,-0.8993874507949381,0.3754229044037891},
{0.18943274643416672,-0.9231902924431689,0.3344172820251745},
{0.07848486537087022,-0.9698268098108811,0.230816127858877},
{0.038142324341931585,-0.9513257688099399,0.3058176657617603},
{0.017978550499877084,-0.9359202513025016,0.3517528321474974},
{0.0,-0.9310317463145792,0.36493819662296945},
{-0.017978550499877087,-0.9359202513025017,0.3517528321474974},
{-0.038142324341931585,-0.95132576880994,0.3058176657617602},
{-0.07848486537087022,-0.9698268098108811,0.230816127858877},
{-0.21444696538142094,-0.9502475328309573,0.22592504373658573},
{-0.4559443429491668,-0.8220797309100618,0.341027377433972},
{-0.6369920690574784,-0.677622043803911,0.36751798555837123},
{-0.7348004749347209,-0.6361717086705703,0.23527392359306593},
{-0.7749341148670619,-0.630756704803693,0.04028767752539604},
{-0.6871762798212467,-0.7026723301430943,-0.1845002897079184},
{-0.5074172042478113,-0.817119258202124,-0.27357612963953104},
{-0.3138359260567981,-0.9120464772258179,-0.26396635182546946},
{-0.15185306327063838,-0.9772081014552227,-0.14834073488291333},
{-0.09421760391878527,-0.9874163609967685,-0.12701170476653648},
{-0.08996832010238605,-0.9854039018036475,-0.14451592191901205},
{-0.0680621167425358,-0.98676655165937,-0.1471710596238317},
{-1.3194835541478503e-18,-0.9901882693892086,-0.13973972650611646},
{0.0680621167425358,-0.98676655165937,-0.1471710596238317},
{0.08996832010238603,-0.9854039018036475,-0.14451592191901202},
{0.0942176039187853,-0.9874163609967685,-0.1270117047665365},
{0.15185306327063838,-0.9772081014552227,-0.14834073488291333},
{0.3138359260567981,-0.9120464772258179,-0.26396635182546946},
{0.5074172042478113,-0.8171192582021239,-0.27357612963953104},
{0.6871762798212468,-0.7026723301430944,-0.1845002897079184},
{0.5826284596761031,-0.7803615141901008,-0.22711227431907913},
{0.5186540277290291,-0.8536486110688728,-0.04777078961708613},
{0.47711093687255823,-0.8658428463712738,0.15060318490749253},
{0.34438770609063285,-0.9294179383432227,0.1325873439641411},
{0.303994350844235,-0.9141096374932458,0.2683113961365763},
{0.2576106852353204,-0.9015162607655026,0.3477142022235717},
{0.17899863009785505,-0.918320538313946,0.35305364937056766},
{0.147985277795941,-0.9153211450902095,0.3745498083117995},
{0.11157649210951519,-0.9316989120823259,0.34567010809895843},
{0.04891029833268646,-0.9310753752734766,0.3615334400527321},
{-9.089051449754677e-19,-0.9301408471315529,0.36720294728854963},
{-0.04891029833268646,-0.9310753752734766,0.361533440052732},
{-0.11157649210951522,-0.9316989120823259,0.34567010809895843},
{-0.18943274643416672,-0.9231902924431689,0.3344172820251745},
{-0.3079241231539765,-0.8812185967757239,0.35865933568844804},
{-0.4751244366926862,-0.782626691103568,0.40218432593742154},
{-0.571439419134639,-0.7494584450657937,0.3343187541533215},
{-0.6434266493189199,-0.7388183321260695,0.2003736985252317},
{-0.6830814850657115,-0.7301952044458777,-0.014650875900948226},
{-0.5826284596761031,-0.7803615141901008,-0.22711227431907913},
{-0.467052486607228,-0.8248549807906649,-0.3185533478380616},
{-0.33568726300801965,-0.878208828060457,-0.3406806653904261},
{-0.22534196779977364,-0.9368854060259018,-0.2673326271217324},
{-0.16400309291333917,-0.9600835712780696,-0.22658888250928416},
{-0.1259075651440529,-0.968659933098314,-0.21411496689737916},
{-0.07461219060507822,-0.9754306202398437,-0.20728754451636835},
{-2.3905111907409445e-18,-0.9822371078757542,-0.18764398181629496},
{0.07461219060507822,-0.9754306202398437,-0.20728754451636835},
{0.1259075651440529,-0.968659933098314,-0.21411496689737913},
{0.1640030929133392,-0.9600835712780698,-0.2265888825092842},
{0.22534196779977364,-0.9368854060259018,-0.2673326271217324},
{0.33568726300801965,-0.878208828060457,-0.3406806653904261},
{0.467052486607228,-0.8248549807906649,-0.31855334783806155},
{0.07210403283416204,-0.9217277851633525,0.38107597471752375},
{1.287730065817671e-18,-0.9238914445589408,0.3826546728720214},
{-0.07210403283416206,-0.9217277851633525,0.38107597471752375},
{-0.147985277795941,-0.9153211450902095,0.37454980831179946},
{-0.22396396183673414,-0.8993874507949382,0.37542290440378917},
{-0.3137440046599947,-0.8640111694910578,0.3937631249045595},
{-0.3510503348634451,-0.8651283880613255,0.358212973749801},
{-0.42362286371492036,-0.8592065942773386,0.28689318166925326},
{-0.47711093687255823,-0.8658428463712738,0.15060318490749255},
{-0.5186540277290291,-0.8536486110688728,-0.04777078961708612},
{-0.44336991543513193,-0.864267148054384,-0.23762452499896883},
{-0.3725064839959573,-0.8667460007964984,-0.331647839559141},
{-0.30145273931455535,-0.8802344968329586,-0.36648803056167983},
{-0.2596617567221341,-0.8992829890811278,-0.35194584476207047},
{-0.20899128505903525,-0.9174764029704205,-0.3384666789535299},
{-0.15846805155384086,-0.9311517492795341,-0.32839655365182063},
{-0.0888026611494144,-0.9428140627914361,-0.32127205041131146},
{0.0,-0.9553208549811292,-0.2955707428656026},
{0.0888026611494144,-0.9428140627914361,-0.32127205041131146},
{0.15846805155384083,-0.9311517492795341,-0.32839655365182063},
{0.20899128505903525,-0.9174764029704205,-0.3384666789535299},
{0.25966175672213404,-0.8992829890811278,-0.35194584476207047},
{0.30145273931455535,-0.8802344968329587,-0.3664880305616798},
{0.3725064839959573,-0.8667460007964984,-0.33164783955914107},
{0.443369915435132,-0.864267148054384,-0.23762452499896883},
{0.37712155903700867,-0.9239106743899438,-0.06456311220670102},
{0.26888617874818166,-0.9605419908737682,-0.07112880321261156},
{0.23930685479928535,-0.9617834719707659,0.13305931868881907},
{0.21075870025571575,-0.938674133857491,0.2728949261041884},
{0.11240212633894052,-0.9473511227191124,0.2998192993743434},
{0.10092983648924524,-0.9255593592252068,0.36490141224292216},
{0.0,-0.9317772365979324,0.36303055154893066},
{-0.10092983648924524,-0.9255593592252068,0.36490141224292205},
{-0.17899863009785505,-0.918320538313946,0.35305364937056766},
{-0.2576106852353204,-0.9015162607655027,0.3477142022235717},
{-0.303994350844235,-0.9141096374932458,0.2683113961365763},
{-0.34438770609063285,-0.9294179383432227,0.1325873439641411},
{-0.3771215590370086,-0.9239106743899439,-0.06456311220670102},
{-0.33064125789503335,-0.9107023502475412,-0.24758349668585528},
{-0.28654814558142067,-0.8942077780271773,-0.34392238947115283},
{-0.24368478131296162,-0.8937845299769314,-0.3765195098934051},
{-0.18268451409623185,-0.9059044336551243,-0.38205173130534603},
{-0.10164574818835832,-0.9180293560812484,-0.3832626296004832},
{0.0,-0.9249123152216105,-0.3801804954904971},
{0.10164574818835832,-0.9180293560812484,-0.3832626296004832},
{0.1826845140962318,-0.9059044336551242,-0.38205173130534587},
{0.24368478131296153,-0.8937845299769314,-0.37651950989340505},
{0.28654814558142067,-0.8942077780271774,-0.3439223894711528},
{0.3306412578950333,-0.9107023502475412,-0.24758349668585528},
{0.23398268957869883,-0.9376335389472916,-0.2570903491356608},
{0.13766192931643526,-0.987757178105196,-0.0733822207250299},
{0.12952548371810518,-0.977135912000792,0.1686077060693594},
{0.016756332896403544,-0.960968590394371,0.27614958552081964},
{-0.008578053715202663,-0.9918155152136157,0.1273907405426676},
{3.0264217967370686e-18,-0.9972528200931682,-0.0740730235390929},
{-0.13766192931643526,-0.987757178105196,-0.0733822207250299},
{-0.1410802477625577,-0.9776417286353543,0.15592630990994252},
{-0.10586956688139125,-0.9516343123723021,0.28841596752614507},
{-0.21075870025571572,-0.9386741338574908,0.2728949261041884},
{-0.23930685479928535,-0.9617834719707659,0.133059318688819},
{-0.2688861787481817,-0.9605419908737683,-0.07112880321261157},
{-0.23398268957869886,-0.9376335389472916,-0.25709034913566087},
{-0.2070375032625241,-0.9117110831875046,-0.3548497893981161},
{-0.12392223915057328,-0.9222153366086183,-0.36628151955532895},
{-0.012314494851002496,-0.9305184340709303,-0.3660379721705775},
{0.11407115960472664,-0.9257118117477643,-0.3606180973510686},
{0.20703750326252418,-0.9117110831875047,-0.3548497893981162},
{0.008787040541190784,-0.9666807526581442,-0.2558341461939966},
{0.13922440179129597,-0.950538124219229,-0.2776577756009101},
{-0.12785137141143732,-0.949224709392921,-0.2874482177821586},
{0.4604897222678798,0.18693558882004352,0.8677582044084369},
{0.429844351938927,0.3759520396202279,0.8209104074206847},
{0.4188982316110939,0.30166917955742356,0.8564578084519103},
{0.41651559790388026,0.05822859313311224,0.9072619178850788},
{0.3986222089012806,0.16917681812998636,0.901376468950725},
{0.3910405522177525,0.3359955607310394,0.8568513696611972},
{0.38029755660393577,0.41992566311504015,0.8240365318955647},
{0.3918015305415007,0.45074669245957255,0.802071680027473},
{0.47240089254467643,0.4102240755427125,0.7800984582526234},
{0.47783527960288713,0.29499904811685174,0.8274351981738403},
{0.4766757628052663,0.09168355033813277,0.8742850471965149},
{0.41847468736395504,-0.006010505185713734,0.9082085717846163},
{0.36337114449426494,-0.06589998023373658,0.9293108220364815},
{0.3912569600618874,-0.018507139529066626,0.9200953629866755},
{0.4143979274399189,0.1669692113464066,0.8946483332549492},
{0.47232882729188375,0.2981419277318956,0.8294678232682586},
{0.43931799290167745,0.4843378038128213,0.7565821785573691},
{0.5189974632668927,0.32277384707623963,0.7914914255796678},
{0.49998589544922806,0.2292656636957059,0.8351355337919715},
{0.5496940619134412,0.2111218502384992,0.8082474884891226},
{0.5333971658375398,0.06684268039843251,0.8432197338497439},
{0.4608004241142557,-0.022038544960334947,0.8872301120183834},
{0.3661387339265137,-0.0693420356240758,0.927973119014877},
{0.48306254134916016,-0.1006184117990084,0.8697853277403201},
{0.49279975287569,0.079719675863267,0.8664832236378928},
{0.5668927210978608,0.17600277315338153,0.8047705676828536},
{0.6042690086246245,0.20214595900883378,0.7707113444553756},
{0.5843755919465021,0.050658458971887844,0.8099005420863531},
{0.6809900522373178,0.07925209513503251,0.7279915206721318},
{0.6084429095951346,-0.06759913189952683,0.7907133381509617},
{0.6478433023896671,0.04954997835055018,0.760160414119487},
{0.6927332979339382,-0.112969147656207,0.7122910568099249},
{0.5516866688151689,-0.28256068174175714,0.784730068612931},
{0.6407588853860645,-0.5283189663295919,0.5570521704609359},
{0.6671450566744161,-0.2528829347217346,0.7006908695576195},
{0.7014619850551368,-0.3310440277416343,0.631158407390017},
{0.6688705226443354,-0.6005368071427595,0.43814126398260395},
{-0.5757549991223703,-0.8172271768799673,-0.02541500254570542},
{-0.7890403717315638,-0.6139926083347919,-0.020697069549922006},
{-0.787501583586068,-0.6162763483830783,0.00668717227634359},
{-0.5865390095484823,-0.7946947781096241,0.15630802897861887},
{-0.8543417079346614,-0.5043652871651856,0.12536308542017302},
{-0.9318112025244112,-0.36151814814417665,0.032132715609107645},
{-0.9303118355684556,-0.365224413930274,0.03363058236990135},
{-0.9319280613559172,-0.3572907167187344,0.06207601955678761},
{-0.790626284815176,-0.6118281157912261,0.024009050100121585},
{-0.5919534745429351,-0.8038286211265404,-0.05874207890729952},
{-0.4367553031164131,-0.8969615543069897,-0.06859136457951172},
{-0.4193446842686561,-0.9078252141471082,0.0018483328645734333},
{-0.36709253192845226,-0.8888262450302755,0.27428266286394953},
{-0.6190923190673907,-0.5179600163288264,0.5902898626576625},
{-0.9026754938026856,-0.29371452296757944,0.31449758645497594},
{-0.9768365105085136,-0.1923052084643265,0.09385701111287598},
{-0.9500006945457793,-0.3110961277665304,0.02679327623131078},
{-0.9801787341563174,-0.19143050025889685,0.051029527514449655},
{-0.9776722653671499,-0.19786338320102118,0.07076032165070502},
{-0.9774861723544872,-0.1926551187510671,0.08605107828950188},
{-0.9709963551362651,-0.21882100560534432,0.09635063994574072},
{-0.9170084270647194,-0.38854610133868533,0.09015249207202859},
{-0.7738932886979388,-0.6290709672251916,0.0732044800722645},
{-0.5621717947196511,-0.8269486488879928,-0.010899785502929303},
{-0.40148951319762305,-0.9154954132819281,-0.025967653958096366},
{-0.3614374526443727,-0.9299792575055131,-0.06709357968868163},
{-0.3217312778544127,-0.9468137949785872,-0.005711609966757958},
{-0.1760841994855429,-0.9438818103407897,0.2794306404089022},
{-0.1738891013467346,-0.5672023633861842,0.8050118380508153},
{-0.3563887059208082,-0.9339545732118085,-0.026757157338554903},
{-0.3377184347296083,-0.9412107207320077,0.008284806751982355},
{-0.2725734753392837,-0.9595709721565131,-0.07019437253846687},
{-0.11132789926333732,-0.9178466297019077,-0.3810034949845755},
{0.3039401517299598,-0.4926946744621318,-0.8153970455692263},
{0.24630484352336637,-0.554619213056521,0.7948153575299709},
{-0.385766107818431,-0.922536375559943,0.010542572140723737},
{-0.35973589364426173,-0.930326824993803,-0.07128874750558004},
{-0.28471177322379293,-0.8871062945481218,-0.36329275847567427},
{-0.10929148527564131,-0.549902889583275,-0.8280472107761784},
{-0.5419621273522229,-0.8394657755374564,0.039676998590491015},
{-0.531243215494729,-0.8469387355742016,-0.02180422378332447},
{-0.4949291940189583,-0.8347710304934304,-0.24125177627673677},
{-0.5371460457075239,-0.5506233196511023,-0.6389742447369616},
{-0.7677139625258591,-0.6395982023076217,0.03910768911227543},
{-0.7927419318490484,-0.59467109766146,-0.13388993649394715},
{-0.8688833890647479,-0.3488101191694615,-0.35124515224034614},
{-0.9700874854019174,-0.22818638073284248,-0.08283264039393565},
{-0.9695611947521373,-0.1152431298556525,-0.2160326610767025},
{-0.9977720271798162,-0.0444860468925525,-0.049718944169740355},
{-0.9999778504299546,0.0018411907392279973,0.006395988285587316},
{-0.9961162942832321,0.055634699534565395,0.06824301041967659},
{-0.9550618911548777,0.05410134318465345,0.2914272271584875},
{-0.9421401331134982,0.12221639222724974,0.3121459963668199},
{-0.7681267726780759,0.09319398103891896,0.6334793942925697},
{-0.7341035124660403,0.14069387811184242,0.6643020891483574},
{-0.4176419888982956,0.08393366376541872,0.9047266488813014},
{-0.46285600421406325,0.11219039798618452,0.879305199553996},
{-0.21129682109785322,0.020301304277427174,0.9772110879633822},
{-0.10571378976610225,0.04578562951662516,0.9933419707145443},
{-0.01965020390096395,-0.09118954414974721,0.9956396619884184},
{0.18670029468831773,-0.038558694689388794,0.9816599345125306},
{0.1647041416246803,-0.25222365768920835,0.9535490402876794},
{0.5518904495652213,-0.20767336302687497,0.8076439227579232},
{0.4674972185090618,-0.47019376201398333,0.7485747637006126},
{0.7422425179623567,-0.4760563235662935,0.4716422598977376},
{0.900219123518213,-0.18531335635898075,0.394036152665044},
{0.847714606878233,-0.4884235187109789,0.20693576697919872},
{0.9783515500736832,-0.20201201910450733,0.04493760792188637},
{0.8009902630811259,-0.5960207041473096,0.056337542340556414},
{0.9268252452043205,-0.26646254985879286,-0.2645612866137096},
{-0.4161837163780797,0.02683656450473152,-0.9088844332627298},
{-0.7358963172435123,0.15168728010911697,-0.6598845196854781},
{-0.5136318382292835,0.04441665620780959,-0.8568602543055224},
{-0.3027818111465638,-0.13576488003259696,-0.9433403798144873},
{-0.4278575573573701,-0.08304908543622587,-0.900022644170907},
{-0.5677680495746962,0.060245360428058045,-0.8209810828691722},
{-0.7507673903065926,0.169225781919635,-0.6385224822869723},
{-0.9096343421612204,0.18880515716043952,-0.37002429135199427},
{-0.9201411548013281,0.16614178306760793,-0.35459436425300683},
{-0.7156436646339737,0.12123404893031409,-0.6878636860957401},
{-0.32691413949006665,0.04114403760680153,-0.9441579918482285},
{-0.1369281240295299,-0.1209253360042547,-0.9831722900702662},
{-0.20248135100236167,-0.33633268286920104,-0.9197182334444955},
{-0.3459864793796737,-0.2572626437777642,-0.9022800497644475},
{-0.4123091185935207,-0.10024528135029118,-0.9055120508815082},
{-0.4968300318154884,0.019859645974953016,-0.867620604842906},
{-0.6231328451461939,0.13165532913608394,-0.7709554666840872},
{-0.7733655201748382,0.190755025016889,-0.6045810885526505},
{-0.8998117063740723,0.17859242446377604,-0.398049794619129},
{-0.964627347660246,0.12305624349906875,-0.23313352629310266},
{-0.9719166335626663,0.13293742990521235,-0.1941795487027676},
{-0.9826568684031606,0.10817237679489987,-0.1506128011778415},
{-0.9343968031429264,0.12612997486438982,-0.3331573858058495},
{-0.7063821655139958,0.09300252506447731,-0.70169421158749},
{0.0017426117538017248,-0.03004636047377403,-0.999546987152958},
{0.010055970998038679,-0.28867325955540246,-0.9573748621438448},
{-0.17317855199995957,-0.5042590740238477,-0.8460094416682411},
{-0.28941289347254057,-0.4001835490530423,-0.8695362581049528},
{-0.33961724438779933,-0.2046740629686831,-0.9180243217161129},
{-0.38019527171767953,-0.012801656767492058,-0.9248176430775568},
{-0.44146750018139497,0.06660979204407669,-0.8948014203651192},
{-0.5271402703273236,0.1402340631835858,-0.8381274025601706},
{-0.6489294268682961,0.19611794266086136,-0.7351383213456197},
{-0.798367700759913,0.20769298102943864,-0.5652191079700289},
{-0.9041351481530335,0.17220489880856485,-0.39100525150005855},
{-0.959589332104281,0.11420487800309817,-0.25718779044106505},
{-0.9865638643523199,0.05981020586334917,-0.15203447250147265},
{-0.9899569686642528,0.05416184359630194,-0.13058213848506808},
{-0.9945282416075633,0.051370785622758076,-0.090964932965781},
{-0.9990774384869242,0.014108585207279332,-0.04056130828579503},
{-0.9932742799932344,0.06877696954577457,-0.09314468940321606},
{-0.9490042959878963,0.07907615026856776,-0.3051848761901876},
{0.24851667607065836,-0.13220508907657685,-0.9595630652213776},
{0.06718459048141918,-0.4860343362171542,-0.8713534614723203},
{-0.16505664938729933,-0.6028582706776661,-0.7805883729396513},
{-0.21954562198161237,-0.48385261899255894,-0.8471637167411908},
{-0.24384474350931382,-0.2797098984971156,-0.928602236560741},
{-0.303809634624647,-0.09128814583548207,-0.9483491869238663},
{-0.41378530834735505,0.01042063619217928,-0.9103148515416162},
{-0.45527382036108077,0.10374042029644816,-0.8842870991315789},
{-0.4860114161486094,0.18811843946263326,-0.8534660837475422},
{-0.5542261826284457,0.2540476139546988,-0.7926494485792727},
{-0.6615885678635148,0.2879110284045397,-0.692392812351012},
{-0.7986950124499987,0.269706059033808,-0.5379079092260572},
{-0.8922404651830628,0.2307060674506479,-0.3881773598902552},
{-0.9508305295816587,0.1751222340021022,-0.2554476603407738},
{-0.9820392950265306,0.12440222448558202,-0.14185524159097418},
{-0.9944687426324259,0.09588121291803446,-0.04288021614274348},
{-0.9980911491020826,0.021613655624062374,-0.05785246731686458},
{-0.9987399533293786,-0.0027120860063811003,-0.050111378080477206},
{-0.9992745856862679,-0.02630641383084075,-0.02753679343892796},
{-0.9964202437795661,-0.08435315999736119,0.005589470880996505},
{-0.999165315875126,-0.023768938478230136,0.033222117870141094},
{-0.9990229769090497,0.032569777721854626,-0.029871410862715494},
{-0.6782333404380149,0.3793892015805621,-0.6293356573739926},
{-0.6480711016663054,0.42444591079911587,-0.6323365527873034},
{-0.5973351689248079,0.35130246229266615,-0.7209558072119824},
{-0.5702205227031918,0.2682984083058375,-0.7764435070168678},
{-0.6581993386484642,0.35479947893576597,-0.6639962050717106},
{-0.7117997588777987,0.4188798660023633,-0.5638091531000092},
{-0.6956167518734124,0.46832102204732856,-0.5447868893628307},
{-0.7052684376865725,0.4443511071720492,-0.5524025021287603},
{-0.7965368238001882,0.35462552191705937,-0.48966297341677895},
{-0.5681721929063728,0.15118231220389441,-0.8089031262670753},
{-0.7495401450842404,0.17435062767581253,0.6385854911725964},
{-0.4840456434678505,0.09701738690924015,0.869647883730592},
{-0.3202000192599233,0.008752705237202368,0.9473095258768253},
{-0.16523291527580866,-0.11667346316115451,0.9793290492492501},
{-0.06909044224182163,-0.24290437452154148,0.9675866760291444},
{-0.027380116908113233,-0.338279144924111,0.940647409663956},
{0.16030083760039066,-0.4692513156455414,0.8683932543666733},
{0.3147931135648497,-0.6414394153465739,0.6996147311856671},
{0.4710828235769553,-0.7101159490787281,0.5232746049587925},
{0.5189281885399412,-0.7612184388142318,0.38892161620033266},
{0.4206848720348408,-0.8527041293135269,0.3097093900621829},
{-0.28207608996653455,-0.11355827242813026,0.952647677912632},
{-0.4512124504043965,-0.026991369406288875,0.8920082906440016},
{-0.3743820598303061,-0.028476585221550856,0.9268371795365876},
{-0.55536821936005,0.08604131678054329,0.8271414828984929},
{-0.6085051156367774,0.05233891919851406,0.7918220518405658},
{-0.6317235295310605,0.02749888335892617,0.7747058755752607},
{-0.4974560285456998,-0.02145098893960054,0.8672239357496154},
{-0.3296848143047306,-0.10299306920509016,0.938456366014196},
{-0.1910214546428994,-0.19749457188242883,0.9615127133548922},
{-0.13043140098970002,-0.27301973730250567,0.9531253184545748},
{-0.08034140688038519,-0.31207502982327046,0.9466543371797782},
{0.005018867779573554,-0.4103660962787217,0.9119070555660671},
{0.12974467799779296,-0.5557718633298006,0.8211479491919653},
{0.10998900242438049,-0.7191084132288531,0.6861381124592706},
{0.1637220106782621,-0.8128297472213498,0.5590195929048852},
{0.17491958738584096,-0.8650472118778163,0.4702089526701755},
{0.13850161766323485,-0.9008042323894496,0.4115446960099492},
{-0.76930254263504,0.1666233490680141,0.6167740732558569},
{-0.9875550322060143,-0.15482489766861995,0.027646146684109158},
{-0.9934063853626596,-0.09488431499587385,0.06434842879557422},
{-0.9909251830535585,-0.09813397199111357,0.09185317159205103},
{-0.9903871198531102,-0.09654730668172587,0.09905539057298095},
{-0.9889933206169508,-0.11056818368417785,0.09832033630861384},
{-0.9771295501763694,-0.194380525057732,0.08622095830136998},
{-0.9222419747268159,-0.3783846820587741,0.07933960193537415},
{-0.9323624986970719,-0.3597059856724098,0.036218433080307415},
{-0.9841963289020513,-0.16484345620802682,0.06468555573787317},
{-0.9946631308470842,-0.0986047430049566,0.030370393319852994},
{-0.9992758299850127,0.001983426076844792,0.03799844245178358},
{-0.985338288202691,0.10340364679526858,0.13570609283016763},
{-0.9268151513638526,0.1698607323933714,0.3349044741313356},
{-0.9169755046584748,0.1655480245631056,0.36297351889578533},
{-0.9120652181502317,0.09323235349933597,0.39930535446140136},
{-0.7849670483924941,0.10310410353985704,0.6108979266385003},
{-0.7836558966755041,0.045701038009410805,0.6195117841740979},
{-0.7792726160550858,0.031032795252396,0.6259162527730733},
{-0.6374017265754378,0.01812237354998903,0.7703185175857876},
{-0.5054105445882484,-0.02055627796456097,0.8626341176044765},
{-0.37620835565747085,-0.07322827444941743,0.9236367754451219},
{-0.2701670306900377,-0.14692548329090396,0.951537008154629},
{-0.2036305983997989,-0.18944318884159014,0.9605445630458117},
{-0.1394467857304696,-0.21920484077416183,0.9656623797842675},
{-0.07241548391756504,-0.23628725370883602,0.9689810789812777},
{-0.034055723555022455,-0.3323107325461062,0.9425549239847056},
{0.006181664716058679,-0.4507851324867434,0.8926110862801602},
{0.04133443249927515,-0.5947427566608319,0.8028527374864195},
{-0.9802881783528876,-0.07555341240578255,0.18255620848226145},
{-0.9938674346124813,-0.04360097097429096,0.10161927842148959},
{-0.9964660498874569,-0.04199746470786828,0.07274355215274843},
{-0.9969684097667765,-0.07467101492989403,0.021868458026212057},
{-0.999277496770102,-0.03245298380522893,0.019781008341748448},
{-0.9966609374559913,0.0039562544894882,0.08155564848469396},
{-0.9942248498702216,0.0035396533940378625,0.10725865351749053},
{-0.9950380202273871,-0.0022561386871775275,0.0994698353280334},
{-0.9936575353074347,-0.046409790586759044,0.10242477173246432},
{-0.9996726914245846,0.006246396194956682,0.02480912240493138},
{-0.9924111898346825,0.07966956827123205,0.09366317409945821},
{-0.9908270196811076,0.07569572323563954,0.11194630209921036},
{-0.9930086869015146,0.06200133358655104,0.10044691320104922},
{-0.9962396410101957,0.04580742808198958,0.07354085403630843},
{-0.9957348422529143,-0.02526518289918023,0.08873440401915512},
{-0.993601155265121,-0.05753292786806103,0.09719416889271525},
{-0.9777494846950076,0.17520017740144744,0.11537262681047164},
{-0.9490417504663069,0.29478901804572627,0.11144142278113844},
{-0.9781415794113445,0.18237247446553653,0.09989660246473715},
{-0.9956542943214995,0.08358447093991901,0.041062908041816955},
{-0.9803641435177531,0.1907742861827374,0.04991310285054945},
{-0.9495705252202445,0.30376360175552414,0.07773989890307513},
{-0.9147621811990017,0.39278381110544563,0.09450412467996609},
{-0.9124490549225346,0.3918937852119699,0.11771144074901099},
{-0.95146076393474,0.2864668034522394,0.11251304463295426},
{-0.9835966407064353,0.15459528486577362,0.09294055244233193},
{-0.9881101948084078,0.14324477217635478,0.05584960304097445},
{-0.997540923211153,0.024920101989247795,0.0655064503380097},
{-0.9959842929280861,-0.03567394693567952,0.08211368796108687},
{-0.9938140005075877,-0.06111210257498485,0.09273102670610806},
{-0.990736816280387,-0.09854146651847792,0.09343521949987899},
{-0.9778816711897217,0.2065745766233839,-0.032777758374649565},
{-0.9486853060139963,0.31602222950631914,0.011231233725004399},
{-0.9173341973352457,0.396067267402738,0.04035703273815761},
{-0.8946713501771174,0.44047530509989913,0.07446261323244448},
{-0.8862167139675345,0.4480988027144361,0.11758996084051551},
{-0.8786580823349278,0.4588891836459763,0.13183585051205382},
{-0.9131279934457597,0.39211824575697335,0.11153720872513583},
{-0.9572337259522876,0.2779516850593007,0.08028981674033243},
{-0.9623042895499292,0.2682258002381032,0.04500415981256842},
{-0.9912560065672694,0.12252162137756054,0.04898960848305533},
{-0.9964556468596835,0.0022465987454356414,0.08408981291171375},
{-0.993959678515542,-0.05270241223497215,0.09626324963294852},
{-0.9930326428421377,-0.06342687451935429,0.09931365383805829},
{-0.9925034012708451,-0.08420235127151612,0.08858308250536356},
{-0.8904533939496592,0.30238420036236785,-0.34008314950133056},
{-0.9349459212447736,0.274341846141478,-0.22497261122956097},
{-0.9640852075938209,0.2320915816599514,-0.12912478546491993},
{-0.8775898690932583,0.3827589978215956,-0.28867208256339144},
{-0.9193710526378537,0.35314125262538365,-0.17334394499301073},
{-0.8744575749708268,0.42577227639639637,-0.2324691769426035},
{-0.9038172500368243,0.40914340053681747,-0.12536369623237092},
{-0.9402694991134147,0.33199615444739217,-0.07531150290063111},
{-0.7998567426298757,0.42243397970150287,-0.42635516188158795},
{-0.8143122873482509,0.4554507743470544,-0.359805629222679},
{-0.8333755594826867,0.4695747882275433,-0.29152134590450995},
{-0.8782647066666962,0.4455338294821063,-0.1736396032323024},
{-0.8969128372324819,0.43579444379580584,-0.07503709192315307},
{-0.9154100009490258,0.40094071153888294,-0.035652152714793106},
{-0.9676008866478416,0.04465338426815568,0.24850472718182115},
{-0.974818194359044,0.1068884073188429,0.19571498748796445},
{-0.993882609750654,0.02766724122358795,0.10691997848066054},
{-0.9876027377824198,-0.00909044858783414,0.15671054868495865},
{-0.9814715372136404,-0.041642348163918944,0.1870281702816146},
{-0.9576566318444578,-0.00963916520705906,0.2877513891859423},
{-0.9957167443492211,-0.043217575042895626,0.0817337520856566},
{-0.8871829401802813,0.07651338487090915,0.4550298150546484},
{-0.9254740069840254,0.22273343458254397,0.3064109650714149},
{-0.9463897867263222,0.0769073157341466,0.31373816530137744},
{-0.8908141072265383,0.019536558766746204,0.4539477384432473},
{-0.9509841086552219,0.0014182283731483424,0.30923650126321606},
{-0.9760153601050008,0.07906294566436671,0.20283753957780792},
{-0.9528375639683024,0.22978431295932,0.19824163591123958},
{-0.9033172126151663,0.3832602607208181,0.192690388824604},
{-0.8783618801376983,0.3754152280970102,0.29587803912057625},
{-0.871366407716096,0.2154876602834286,0.4407784610998138},
{-0.7823594128617494,0.07451684850008643,0.6183534494091819},
{-0.9006385383193423,0.026979794185002133,0.43373069294175354},
{-0.9795733144380472,-0.011500452942014886,0.20075821582935827},
{-0.9888345316831386,0.08665695838841732,0.12123052632837927},
{-0.964566577317925,0.2375748802148252,0.11475841673748771},
{-0.9145474045038302,0.3889597486362791,0.11096557509475695},
{-0.8589447131336057,0.5002426402489234,0.10941334770773678},
{-0.8483218707464084,0.49446337577049637,0.18935673643934323},
{-0.8269444575033426,0.48338729243519013,0.287227418114424},
{-0.8296566395729439,0.3651530918965871,0.4222950152332998},
{-0.7767096344833782,0.20695938874149333,0.5948865060769531},
{-0.6809900522373178,0.07925209513503251,0.7279915206721318},
{-0.9918084933981981,-0.012130820233794156,0.12715642187342197},
{-0.9902313107631556,-0.05733150157167536,0.12710251811754023},
{-0.992274379644197,0.10232655216751561,0.07014864377329429},
{-0.9671595660632663,0.2469410807369153,0.060187012027503844},
{-0.9180180511295125,0.3924793272665629,0.056593599185401765},
{-0.8629075075663986,0.5022516178495792,0.055981655504513755},
{-0.8083500340292126,0.5860624019023543,0.05568737344689917},
{-0.8046985701746457,0.5835060199854502,0.10945746114185237},
{-0.7906735332303259,0.5806436430787156,0.19413480780465345},
{-0.77466622633996,0.5588962133194196,0.2958500642308866},
{-0.7805927558258521,0.4694952005794812,0.41261265877943487},
{-0.7449012632942844,0.35287941070106515,0.5662139431750585},
{-0.6741517946949036,0.2003756981521069,0.7108930561622446},
{-0.5843755919465021,0.050658458971887844,0.8099005420863531},
{-0.4608004241142557,-0.022038544960334947,0.8872301120183834},
{-0.38596918732677216,-0.06652380718730401,0.9201099768569067},
{-0.29545840497726844,-0.11458797127449154,0.9484587116830573},
{-0.2313126177280325,-0.1442999475532711,0.9621184947894558},
{-0.1573973668787659,-0.16660925611578264,0.9733793837328674},
{-0.07876918831452237,-0.18103658292244673,0.9803168725550098},
{-0.9655794135202052,0.2573484882782513,0.03779089529073515},
{-0.9178767185853124,0.39471510901260537,0.04125908622626353},
{-0.9184115184309364,0.3941337204035536,0.034335014988131914},
{-0.9923327373914202,-0.04825879980236109,0.11378412254302527},
{-0.8383353281767248,0.5380835774740191,-0.08752108993599346},
{-0.8794407548278337,0.47564013199022165,0.0187196043808329},
{-0.8460201046614987,0.5316784501377249,0.03959808287901813},
{-0.7757262298810277,0.621591738527497,-0.10896112549405183},
{-0.7729507299227092,0.6331948709655851,0.04014255217131731},
{-0.8390630549372938,0.5269047677692074,0.1354420744871159},
{-0.8709784778407833,0.4780685195807355,0.11334452666113291},
{-0.8885614800614293,0.45527837085303124,0.05639238587302452},
{-0.8912613127461704,0.4528377169515921,-0.024316136782866475},
{-0.871884727412097,0.48313164143315085,-0.0800052445258597},
{-0.8163751946739106,0.5312640363111478,-0.2264731004855146},
{-0.7741846779822581,0.5771915585775912,-0.25978450508888823},
{-0.7097664573654595,0.6586022284555094,-0.24994935621505857},
{-0.667071056104423,0.736319703673019,-0.11335563546029447},
{-0.639663071569699,0.7679006862222784,0.03405423570383154},
{-0.7697388772753474,0.6180782682457946,0.15962867891819246},
{-0.8268842943017737,0.5224822479632997,0.20802563399801197},
{-0.854328692416601,0.49118804755960044,0.1698728561257757},
{-0.8770535246297799,0.46619051967447706,0.1159461698380808},
{-0.9001719507476474,0.4354633394231283,0.007882836141414707},
{-0.8799047221863985,0.46068554820492175,-0.11634648920017987},
{-0.8593772588329548,0.48806138425959306,-0.15253462621767724},
{-0.8490310710682186,0.48109602927341905,-0.21838692950381283},
{-0.7984587148581073,0.5122592411134472,-0.31631337398379916},
{-0.76399367875862,0.5323902759749595,-0.3645192078123966},
{-0.7521803792188426,0.5360337065271513,-0.38326562927682667},
{-0.7709641118442967,0.5414663700712639,-0.3353036061988951},
{-0.6150580300601245,0.7631361777512504,-0.19830984308846256},
{-0.5159611540344899,0.8503491207851047,-0.10339468220076331},
{-0.43790415260118787,0.8983802911557824,0.03395299099471536},
{-0.6366436338100335,0.7523332265588207,0.1693505233081665},
{-0.7426755575465789,0.6162884974733855,0.2619570653845301},
{-0.7372867586778019,0.601746519807453,0.3070982926979558},
{-0.8067162525222868,0.5373873304434146,0.24581241830977163},
{-0.8342069321904151,0.5149200220026364,0.19737316237589225},
{-0.8627730866692744,0.48263167977630134,0.15062955419000107},
{-0.4299769004022858,0.8864819416598302,0.1710836994908066},
{-0.24112455980052513,0.9689704020103922,0.05436273253638042},
{-0.22207046712439688,0.959063415932411,0.17573295607599462},
{-0.40749182055569044,0.863329191633434,0.29767956438722876},
{-0.604913386116319,0.7394674098165684,0.2954111458907134},
{-0.6166324440894936,0.6973212718302392,0.365386744079852},
{-0.5960443277029556,0.7092607195320437,0.3764045578124944},
{-0.7095839429400129,0.6304095268672355,0.31476095113074737},
{-0.7801966643657713,0.5730570886443066,0.250796208238951},
{-0.812476194201795,0.5486330442757062,0.19719081262609048},
{-0.8486260668601159,0.5047544754253543,0.1582931400396286},
{-0.7272161708368203,0.6697968038384241,0.15009624392790216},
{-0.6830064284314736,0.6807836514370014,0.2646428511359898},
{-0.7621843462831775,0.6138923652423873,0.205453610768934},
{-0.7802910055888775,0.6141802473212042,0.1180193645024524},
{-0.7981913247729573,0.5801352332003255,0.16227667810500493},
{-0.5920097214683764,0.7354571213584654,0.32958657789730256},
{-0.5678253389347128,0.7929751459708995,0.22082753980450245},
{-0.6570005554546662,0.7352240417124152,0.1667209603508831},
{-0.7087325129175257,0.7016140719699244,0.07372868605496148},
{-0.7657752951027148,0.6402059948824875,0.0610285304335129},
{-0.8161344445488734,0.5756365206974349,0.050667193135729365},
{-0.8249844817827248,0.5571880562322822,0.09456254443372547},
{-0.8358955855357106,0.5308044124027828,0.13973276586272876},
{-0.8737003468079863,0.4716228167054316,0.11924605968517185},
{-0.9161205484063822,0.3935664348298403,0.0763452825190828},
{-0.870689009939087,0.4851844986328987,0.08060180058556464},
{-0.8674944412732737,0.4955268114435877,0.04366432755146457},
{-0.8649233103206173,0.5006696755088862,0.035178733488457264},
{-0.43811430560479797,0.8203522531737345,0.36752963953564716},
{-0.4262966194852301,0.7994894268773864,0.4231877225614339},
{-0.4284524844229712,0.8121540840932774,0.39602299463843427},
{-0.23060944291886062,0.8813307968667131,0.41240188085281193},
{-0.24708333648447048,0.8691285242319136,0.4284453678103637},
{-0.2712606023552867,0.8895449900056621,0.3675967850317429},
{-0.42866653707888913,0.8732208392056542,0.2317981146725878},
{-0.559063844394366,0.6904078865843838,0.4591128053464386},
{-0.6083072973149793,0.602600669575236,0.5165604176287828},
{-0.5313881400381062,0.6090798998022756,0.588768477657977},
{-0.4783034005416349,0.7238947116182508,0.49719443231138255},
{-0.44994807211224735,0.6406596090629753,0.6221752146443535},
{-0.44720613189895553,0.5465267728613212,0.7080361305313196},
{-0.5228141069096871,0.512844121498322,0.6809231356480997},
{-0.6060962755022843,0.5278944361545235,0.5949577876617442},
{-0.6645449671025415,0.5751014650065369,0.47711454771995454},
{-0.6319585883136218,0.6552045362145329,0.41392675484988045},
{-0.5841299387057607,0.7363653463646246,0.3414063434983458},
{-0.4974871171736459,0.7818711298723656,0.37574473318779256},
{-0.4034984818973478,0.8207859109805038,0.40435066890316884},
{-0.39096189985916824,0.7552865371513262,0.5260142960571204},
{-0.3686919011362994,0.667515461012449,0.6469075601241948},
{-0.38171627986497453,0.5728869403974731,0.7253228489493949},
{-0.36386200404110763,0.5057836289935378,0.7821683723197431},
{-0.43931799290167745,0.4843378038128213,0.7565821785573691},
{-0.5227596119886393,0.4466387164100596,0.7261103532363808},
{-0.6107367039333,0.4451780210207875,0.6548413609941753},
{-0.6887787875366661,0.5091041853758355,0.5161363291537682},
{-0.7404967691423314,0.5454674034247049,0.39259374255186363},
{-0.7040080118398873,0.6088551893473031,0.36560645189890834},
{-0.6610412071550591,0.6847466649797403,0.3068330608687814},
{-0.6067116867550676,0.7612004711126086,0.22907372597651504},
{-0.5163128931952327,0.8176555365760932,0.25467708932455896},
{-0.41708237667164016,0.8651006902057603,0.2786450912459309},
{-0.3158558315080419,0.900823948642296,0.297911576235073},
{-0.30702716298264304,0.8510593628008392,0.4259486849138745},
{-0.2998592692915603,0.7818992409402936,0.5465510000328645},
{-0.28773416083050773,0.7015845253841186,0.6519111952043042},
{-0.3009282144435276,0.594686730388148,0.7455131806025193},
{-0.2940112370449914,0.5224539053109375,0.8003744806755296},
{-0.34735330363041744,0.46672352354005453,0.8133356226253656},
{-0.39180153054150063,0.45074669245957255,0.802071680027473},
{-0.47240089254467643,0.4102240755427125,0.7800984582526234},
{-0.5714890076030225,0.3544630397649513,0.7401055787044866},
{-0.6512590561905216,0.3445353450345958,0.6761338904031678},
{-0.7027541077343263,0.44044997040677386,0.5586953442003996},
{-0.7304220355711335,0.6286837779978747,0.26690889313479355},
{-0.6833966234512877,0.7001646901305139,0.20673282697680265},
{-0.6189007620387184,0.7757141091805347,0.12340772895626526},
{-0.5278470817094519,0.8385100437072216,0.13519750342712794},
{-0.4260560837844121,0.8924207484652371,0.1485308761807997},
{-0.3213083329254941,0.9333142760311913,0.16026670692633818},
{-0.2156307292277297,0.9618023169419283,0.1686407179119445},
{-0.21340806492869696,0.9259905244495301,0.31144589651024973},
{-0.20885610927603623,0.8729594011164972,0.4408185676901587},
{-0.20563467128799268,0.8023165276459489,0.5603593234973666},
{-0.205594197546629,0.7097639854831361,0.673770072685224},
{-0.20859348203425626,0.612539109451429,0.7624202244466465},
{-0.21355859686013162,0.5458569061715154,0.8102055070733556},
{-0.3008073520061137,0.49236548466724117,0.8167564915490189},
{-0.37459288987005435,0.4503833280562543,0.8104535919272453},
{-0.38029755660393577,0.41992566311504015,0.8240365318955647},
{-0.42984435193892695,0.37595203962022783,0.8209104074206847},
{-0.47783527960288713,0.29499904811685174,0.8274351981738403},
{-0.5189974632668927,0.32277384707623963,0.7914914255796678},
{-0.5530905207416799,0.21927797119420486,0.8037462579786303},
{-0.6042690086246245,0.20214595900883378,0.7707113444553756},
{-0.740319350929203,0.6460054787686974,0.18602198805676123},
{-0.7530975224876266,0.6484291364831354,0.11128241812044698},
{-0.6944210454000151,0.7102565200759018,0.1153910195605357},
{-0.6215198910750702,0.7815796074743048,0.053351121622179504},
{-0.5307025314694932,0.8457781807501146,0.05490074734371195},
{-0.42752152205115246,0.9021751657117862,0.057491899916222056},
{-0.32036456024062887,0.9454392210611281,0.059255614258529106},
{-0.2132079977490019,0.9751798547719926,0.059721022619652266},
{-0.10653338037052403,0.9925296612324187,0.059460158431417366},
{-0.10866666492862456,0.9788251432270711,0.17347303801972777},
{-0.1083706370030816,0.9414148054292537,0.3193649466584375},
{-0.10687627526836617,0.8868176711232122,0.4495907916854646},
{-0.10605792888340146,0.815764873378304,0.5685766325510071},
{-0.10700987300315623,0.7244185946390955,0.6810041019119976},
{-0.1098967081880213,0.6291296513374476,0.7694924270825924},
{-0.11368544282712809,0.5646698508167208,0.8174494355419313},
{-0.22049255209754215,0.524628989160084,0.8222818605577903},
{-0.3208822654035168,0.5186383677365438,0.7924953092991027},
{-0.4549141973770978,0.4320395945645033,0.7787135941752209},
{-0.47232882729188375,0.2981419277318956,0.8294678232682586},
{-0.3910405522177525,0.3359955607310394,0.8568513696611972},
{-0.4188982316110939,0.30166917955742356,0.8564578084519103},
{-0.46048972226788,0.18693558882004355,0.8677582044084368},
{-0.47226702665947146,0.08575324278522974,0.8772743224795991},
{-0.5038478203665667,0.19380299985210364,0.8417706167122879},
{-0.5318054895714724,0.07130878080309723,0.8438589805423785},
{-0.7582948863551408,0.6507143800704649,0.039492542297944064},
{-0.6993139297481158,0.7136299912255748,0.041137127800001956},
{-0.635105947490033,0.7675858556810053,0.08632722410251772},
{-0.6247793983523497,0.7796546323577432,0.04230079949112175},
{-0.6966950582385231,0.7153579627820339,0.053656135812778505},
{-0.7558554754714929,0.6524335028323534,0.05489102460028262},
{-0.810916348110901,0.5839686579851898,0.03735348521164006},
{-0.5421271386403,0.8348274369578406,0.09571476402354964},
{-0.5337932261351601,0.8445296923874449,0.04282978412490258},
{-0.42767568715461063,0.9029867411483564,0.04133342384926372},
{-0.3165761643018574,0.9478680929354706,0.036408935590012986},
{-0.20766804448363693,0.9777464831981386,0.029762356996955928},
{-0.10247277367967307,0.9944457013567114,0.024022441748347258},
{-0.11759337008367811,0.5468435696507522,0.8289354074015575},
{-0.22741026646870793,0.565337622314112,0.7928921386297494},
{-0.33929845289992716,0.5671165282528049,0.7505034331981443},
{-0.5329013540356101,0.3543352380992335,0.7684156986346472},
{-0.6478433023896671,0.04954997835055017,0.7601604141194871},
{-0.5668927210978608,0.17600277315338153,0.8047705676828535},
{-0.49279975287569,0.079719675863267,0.8664832236378928},
{-0.41439792743991893,0.16696921134640663,0.8946483332549492},
{-0.3986222089012806,0.16917681812998636,0.901376468950725},
{-0.41651559790388026,0.058228593133112225,0.9072619178850788},
{-0.41847468736395504,-0.006010505185713734,0.9082085717846163},
{-0.4288318014467892,0.8980682807069741,0.09786035589512802},
{-0.30966008451203847,0.9465591937084605,0.09020157906592581},
{-0.19736558599415735,0.9772673234021798,0.07742999467597854},
{-0.09485520001176434,0.993314239928187,0.0657975059300605},
{-0.29582542845763754,0.9278280373820293,0.2272057414011952},
{-0.17860357016569273,0.961255240841741,0.20997410954295084},
{-0.08123340271483721,0.9780014295455893,0.19213104405627085},
{-0.8217628811243431,0.3902334987982995,-0.41523918844667856},
{-0.8211391386137401,0.26404388857539346,-0.5059756317676476},
{-0.7298768398710757,0.15714526292221423,-0.6652707456073208},
{-0.8873664908760682,-0.06771489239068028,-0.45606513155339024},
{-0.9616258157455764,0.016313164335578927,-0.27387893522689066},
{-0.9391124650956326,0.2295745175531972,-0.25566250955550995},
{-0.8707034561375552,0.44171428523680406,-0.21624981315103123},
{-0.7440412203604562,0.4727616619818707,-0.47212188401371785},
{-0.734097708370397,0.5000722878422644,-0.45937812474859424},
{-0.7391318135512616,0.47734265396515824,-0.4752137970449956},
{-0.7715029177308097,0.49537737319718333,-0.39922989123699926},
{-0.9157106921825968,-0.352788695576803,-0.19239039605886557},
{-0.9780736447660021,-0.20444829032260944,-0.03965907208080192},
{-0.9998733190275391,0.004571029108173272,-0.015246363164544228},
{-0.96140693544279,0.27507437160673437,0.005549285329073623},
{-0.796639751077086,0.6033081600021365,0.03720713746950719},
{-0.6916911086971709,0.7025707302625781,-0.16720579872596025},
{-0.4233793540494332,0.9044391387525859,-0.05234278228338093},
{-0.35783436198425905,0.9305435306376124,-0.07773870960985231},
{-0.28225699670615206,0.9589084065011226,-0.028734226140631574},
{-0.1416012442109727,0.9897336519308337,0.019400666832870634},
{-0.10504343133410438,0.990544805295245,0.08824322204091727},
{-0.08559199857846218,0.9786811013892648,0.186701128981162},
{-0.22218304185823504,0.923317118561617,0.3132414316173624},
{-0.9433774846017399,-0.24343714355023385,0.22533814299092078},
{-0.8901791344111258,-0.4307755477475076,0.1483695929828401},
{-0.7446077415198975,-0.6655970154735458,0.050397661268614995},
{-0.5987717182211265,-0.7782043659713201,-0.18939481049304188},
{-0.41027335356484756,-0.8738486004622141,-0.26089154609700094},
{-0.2103447252238767,-0.9167542678263935,-0.33958314002992696},
{-0.9547126323508471,-0.018703627201090096,0.2969410109082928},
{-0.8724200246476949,0.2905400674069941,0.39302642382523717},
{-0.7660865565573446,-0.5073654423708626,-0.39457787032464114},
{-0.5709019441892902,-0.5878157208352462,-0.5731872717182653},
{-0.3376010835515274,-0.6287576232700326,-0.7004922266268586},
{-0.6264692453735006,0.5986855691844931,0.49911108367917073},
{-0.5129353963447176,0.8512877080730147,0.11048310848487833},
{-0.2677979267728583,0.9492358834067307,0.165031839561953},
{-0.21674104143899642,0.9760143154274774,0.02047869714048906},
{-0.1805236062152272,0.9835265061233701,-0.009318763426870267},
{-0.06326192285526791,0.9976616182120868,0.025869376936735217},
{-0.04401353685278426,0.9974741302706085,0.05575094631126586},
{-0.02595064652213397,0.9931111833941577,0.11426609892062994},
{-0.01479245873671874,0.9800317313667446,0.19829016283926829},
{-0.08372013147453128,0.9470721238443744,0.30991181297716486},
{-0.9207956976404537,-0.0401056869416521,0.3879778564322561},
{-0.9571421345473504,-0.0630011538249476,0.28268319527497054},
{-0.9714790690976556,-0.08746302699614593,0.2204056197419293},
{-0.9736845003314856,0.1370585826470714,0.18208085768965734},
{-0.9442759234349569,0.1417373504879842,0.2970749129389851},
{-0.8450010257674645,0.2252892880893487,0.4849927866722628},
{-0.8165169923218617,0.03517589939776205,0.5762487807806794},
{-0.8460531340213338,-0.5255516834197561,0.08938412872171204},
{-0.97800278825256,-0.1908836682943352,0.08410690428684538},
{-0.9475476044727142,-0.31211164159497945,-0.06884664435473807},
{-0.7408528185271341,-0.6610210586656021,-0.1191144881238546},
{-0.8185034057528131,-0.4844946707996093,-0.3087346574938162},
{-0.9718767182392092,-0.046678305401842916,-0.2308176343986685},
{-0.9957059654832898,0.06986551589274614,-0.06073252826970206},
{-0.9919164160442344,0.12184434653679689,0.03543696938202253},
{-0.9782393648288252,-0.12452283450756219,0.16595724987326982},
{-0.8757716980517227,-0.43120256775110616,0.21699833745090003},
{-0.7221963165300788,-0.6603638095089491,0.2057963058006985},
{-0.6429294402874687,-0.7649010641574664,0.039599202800278184},
{-0.4598408109506077,-0.8607496877610431,-0.21830346676943604},
{-0.5079522957627386,-0.7641270882270383,-0.39761068681190026},
{-0.5722934159702115,-0.6042686485224736,-0.5543822205391962},
{-0.8408097196780466,-0.23805703079034068,-0.48617678408806353},
{-0.9068837925330777,0.1907647922672055,-0.375726736967269},
{-0.9436032496293669,0.26426692244303757,-0.1994389655794076},
{-0.9575648919079957,0.2758054495087344,-0.08367097350045402},
{-0.9677696326054174,0.2517902812098313,-0.0048572106243758946},
{-0.9853305257660814,0.1368423582782353,0.10197021121086704},
{-0.5285377649001368,-0.8351776295981221,0.15207287099686728},
{-0.3971070304038662,-0.916088856515005,-0.0555626976743684},
{-0.264441684921438,-0.8143810865463873,-0.51657917220058},
{-0.3118120225625549,-0.6776247666787557,-0.6660314843676765},
{-0.5470989014197499,-0.42161035673280023,-0.7231372616322186},
{-0.7827738512881682,0.022972720355401224,-0.6218821044691359},
{-0.7326895129135902,0.3844861395536417,-0.5615482937001798},
{-0.8031019643386265,0.4329266440988883,-0.40939193409825997},
{-0.8887356473398071,0.36009646350588653,-0.2836890659120436},
{-0.9533700568433614,0.28029480577930327,-0.11189439917899545},
{-0.9741561454394049,0.2239912187477944,-0.029115944541071297},
{-0.9743681027543558,0.2068253843398579,0.0884876303646286},
{-0.3392292231389083,-0.9388455279399268,0.059098298078478016},
{-0.5210577815715169,0.5271201414165027,-0.6712995939048494},
{-0.6137057320095475,0.4999207000202951,-0.6111011112654301},
{-0.7060932483448326,0.39172151536603683,-0.5899038727124772},
{-0.9015236857260721,0.2899019577718779,-0.3212660874647536},
{-0.9669735962062932,0.21229141054798875,-0.14104758504637394},
{-0.990562498036195,0.11805626631857838,-0.06963228753394606},
{-0.9939247890711035,0.08627231276219283,0.06834180068321868},
{-0.9613440475171978,0.15123824985573098,0.23009696669844884},
{-0.8580403796595261,0.23690199318257907,0.455679879410818},
{-0.6350224542032699,0.23838657696815785,-0.7347913462875433},
{-0.5094908468774602,-0.17771242890710395,-0.8419248004186751},
{-0.45206721370714154,0.44222939504382913,-0.7746408177021338},
{-0.2438101748169744,0.5767252906408079,-0.7797079823825019},
{-0.29407044923154413,0.5688250198222116,-0.7680889712220965},
{-0.5730882330076608,0.34108393859866865,-0.7451386609337733},
{-0.8334127654737936,0.23802260168528236,-0.49876688285439835},
{-0.9430032122705919,0.22179059285088246,-0.2481005331920893},
{-0.9774647997962291,0.15274489118081344,-0.1457105465554203},
{-0.9518394770902882,-0.13747499999903934,-0.2740478684970035},
{-0.9715548183428849,-0.2197042752272276,-0.08838136908649066},
{-0.9132012391890328,-0.3928629946824896,0.10826894362060144},
{-0.9675151405953634,-0.06834523121616065,0.2433996345287801},
{-0.8697025829528238,0.07374337343435365,0.4880361995587093},
{-0.42727516375629926,0.07534289465995006,-0.900976904621471},
{-0.25468654018006437,-0.2783121607007718,-0.9261085829734957},
{-0.22629054702087403,-0.025298065372282522,-0.9737312751562485},
{-0.3283115403890355,0.28685657495475003,-0.8999582422827231},
{-0.27396356251302634,-0.4965195731512765,-0.8236578657991711},
{-0.12717975216871846,-0.49040578567411747,-0.8621644135637093},
{-0.10668944704243231,-0.30265686362130717,-0.9471093837528449},
{-0.09854289897571687,-0.04625727454006993,-0.9940571219067775},
{-0.2049338393043257,0.23698358351874546,-0.9496530433008692},
{-0.2101575750583992,0.4898265775769222,-0.8461109369018065},
{-0.4564794748750197,-0.8018456982467058,-0.38557744386968357},
{-0.009221680309620528,-0.5842882333398145,-0.8114938206745049},
{-0.004354651749200328,-0.9133998942714042,-0.40704013334452765},
{-0.4189131576227241,-0.9080004904856676,0.006846579317127914},
{-0.03690668527844545,-0.9982573791905445,-0.04604455965022446},
{0.3641110894614494,-0.9303530739522439,-0.043200374058645},
{0.45973418656034715,-0.7659972776780732,-0.4493246580118619},
{0.3604129905665699,-0.5699821844540115,-0.738392027066852},
{0.41487753658554016,-0.20790556301981816,-0.8858057950262722},
{0.0346333757001243,-0.20981043536762378,-0.9771285025514618},
{-0.4075031883097573,-0.5372680625924533,-0.7384335992054629},
{-0.7797404704241702,-0.5484522126383312,-0.30200160468913506},
{-0.7935196281669024,-0.6082328997496743,0.019476636669699374},
{-0.7161287010718274,-0.6251773728718907,0.31034325504218435},
{-0.43513255104853293,-0.8119625199708745,0.38907136772132567},
{-0.0030537234961646067,-0.9556242018154675,0.29457267299829376},
{0.4408422489929807,-0.8313418449772763,0.33842111088492854},
{0.781909219995103,-0.5700370686171927,0.2523404685914799},
{0.771568953231119,-0.6273617449784115,-0.10534985214739487},
{0.7946145646681437,-0.4716179508843251,-0.3823142712755133},
{0.6434836435354256,-0.396592126571354,-0.6547087028931144},
{0.7437473756476187,-0.18206434581132147,-0.6431892530208939},
{0.7321164548497108,-0.06415809281048998,-0.6781513368454065},
{0.392544386378652,-0.03209887681614437,-0.9191727622322963},
{0.06115739522545623,-0.02480984639662114,-0.9978197455106876},
{-0.3378180752610758,-0.2323686032326764,-0.9120766306942619},
{-0.6848934081386179,-0.43601276258103255,-0.5837926775446267},
{-0.9255186140716413,-0.2837092118944821,-0.2508473202829164},
{-0.9541964394369058,-0.295079979579878,0.04936558129983048},
{-0.8786330934962416,-0.3185556212782358,0.3557052194799255},
{-0.6617029461502887,-0.5008409682563355,0.557949402340467},
{-0.39370475747326594,-0.5835059476181711,0.7102938638599781},
{-0.018515751862152225,-0.6900215859578895,0.7235519178643218},
{0.41784160479841076,-0.6390885891300293,0.6457353703672095},
{0.7099526961348624,-0.48508721061387694,0.5105463420196915},
{0.9039473151326907,-0.2405270380380678,0.35359015178174},
{0.9712060685129983,-0.23744043003792728,0.019514473268054344},
{0.9189242519161431,-0.20330224054374982,-0.3380035772447506},
{0.9523742586263977,-0.07023253449951691,-0.29673331899804145},
{0.9587498456549195,-0.05551197979794843,-0.2787779646162522},
{0.7215282660355529,-0.059071413585618494,-0.6898605144583398},
{0.36261399493317914,-0.006635077853130656,-0.9319158043624346},
{0.059445747362707343,0.02718319731354219,-0.9978613515435409},
{-0.30723202178051395,-0.05183348548692261,-0.950221960688625},
{-0.7264133442545488,-0.2418342194558685,-0.643303865672431},
{-0.9617106669728968,-0.10433259711102194,-0.2534310600747577},
{-0.9920838682093397,-0.11486311154819341,0.05075494108223396},
{-0.9360568725391124,-0.1468354420551518,0.31974503018618455},
{-0.7532347631640279,-0.1932591079677096,0.6287195787859291},
{-0.6884885355560905,-0.30973759922962635,0.655779045129758},
{-0.3889137760965828,-0.3286726814318276,0.860651115866766},
{0.01640349756911009,-0.32292717281705674,0.946281652746096},
{0.445422813524828,-0.28586426548903665,0.8484575056583799},
{0.7597600810861032,-0.23222950835575706,0.6073171120896242},
{0.9330224088023381,-0.07514583695573446,0.35188391247811357},
{0.997221521668211,-0.0526730336000171,0.052676258913376225},
{0.9961307378342009,-0.03299116916908301,0.08145634351447142},
{0.9741910539015601,-0.22545856044411686,0.01096485388110439},
{0.897573695943892,-0.24108686126472648,-0.3691051146694452},
{0.5227390701007779,-0.31577317732180504,-0.7918529946109099},
{-0.32392646616454374,0.04094545284359427,-0.9451958074439305},
{-0.7322629655173551,-0.061126517712270664,-0.6782731737022335},
{-0.96156744831534,0.013176282832231767,-0.27425248934339846},
{-0.9996096343971576,-0.017495212440371593,0.02178293740631136},
{-0.9635710856973476,-0.05909649160261619,0.2608416521345787},
{-0.8446956801215624,-0.1570613482837069,0.5116844152984096},
{-0.44503312289347613,-0.22812625906703668,0.8659699356512092},
{-0.39403070994352185,-0.19916462862023146,0.8972587421295876},
{0.028660384964504088,-0.15571688721399637,0.9873858584008939},
{0.42698814181617706,-0.11208408301855087,0.8972838375242579},
{0.7509798259028725,-0.08016636557865027,0.6554408096211292},
{0.9261883103510353,-0.011769249300522663,0.3768775643892806},
{0.9144416604579173,-0.22532711689279375,0.33619063046395026},
{-0.4557162953963499,-0.7980844708555688,0.394187563844185},
{-0.7602209195654221,-0.648660920896421,0.03609935119792446},
{-0.42049404705681737,-0.9072835301803601,0.004620849839878447},
{-0.00398177380129514,-0.9159761102818192,0.4012130492274443},
{0.008639675040554603,-0.9998862365231073,0.01236406190741479},
{-0.026812236365552314,-0.9450286432919085,-0.32588643319250404},
{-0.43628381953879036,-0.8148918136357945,-0.3815858499446877},
{-0.756549659520886,-0.5938032395542523,-0.2739166394611812},
{-0.9382655665664721,-0.34030777744666774,-0.062035015958782296},
{-0.7694455746566153,-0.5572771002266279,0.31208290758122553},
{-0.4171588700214542,-0.5396447180652921,0.7312742682650982},
{-0.0822404006942318,-0.6395860051540612,0.7643076988391005},
{0.3085500409243629,-0.5597157466757372,0.7691002243978323},
{0.45557514393859017,-0.7867164073336086,0.4165676207501399},
{0.3990213239887531,-0.9153233150553304,0.05445375945132526},
{0.387754626233156,-0.8718474753460451,-0.2992128499371524},
{0.382778089702098,-0.6838384863180128,-0.6211649206726839},
{-0.00519454004598804,-0.6933106179025926,-0.720620152269721},
{-0.38416072642255117,-0.5880961487893182,-0.7117327139127932},
{-0.6595727932382384,-0.509295976641228,-0.5527941195390612},
{-0.8657609244464718,-0.32375625127968244,-0.3816279752048027},
{-0.9222861853026694,-0.18509857042387862,-0.3393032738228247},
{-0.9860009964573495,-0.15690820277767345,-0.05640789737434241},
{-0.913961691032699,-0.31271796662876755,0.2586145793883597},
{-0.6786105782639136,-0.44526605305720834,0.5841453800751766},
{-0.37299343730890255,-0.2473072286990769,0.8942678739380456},
{0.0007179227085602692,-0.2538901629391291,0.9672327898441653},
{0.3959296927511502,-0.2381774210702617,0.8868546636796241},
{0.6260049593844368,-0.45884408574186447,0.6305393689578804},
{0.774979759049977,-0.5291578778483047,0.3455406103107395},
{0.780965708176989,-0.6234472408989036,0.03749800617577509},
{0.714503714048709,-0.6439599401515078,-0.2734959562601739},
{0.670611765101195,-0.5030605315205112,-0.5451696636223998},
{0.43003404318973004,-0.3641804920439287,-0.8261012594788458},
{0.033203787079655205,-0.3433802535063801,-0.9386093489974746},
{-0.3671145208212388,-0.33730214240400236,-0.8668645761200894},
{-0.6726003816189743,-0.3224139422881866,-0.6660765545072129},
{-0.7222899342105517,-0.2202450543751193,-0.6555832265711331},
{-0.8052335500457883,-0.20059864212005976,-0.5579956224382454},
{-0.951759524333376,-0.10108083854264317,-0.28971791784462014},
{-0.9975411549327762,-0.05925164017431357,-0.03742842972977506},
{-0.9559071961406761,-0.14329164144568246,0.25633754671969705},
{-0.7250918998044126,-0.26123263899093613,0.6371807005582161},
{-0.3640911304485654,-0.06313692375971122,0.9292208443566287},
{-0.027136425057592325,-0.040279643269648176,0.9988198860521168},
{0.313607235900614,-0.06190423275858811,0.9475327791466357},
{0.6965615327748469,-0.1137806574111018,0.7084179508294898},
{0.7228506374535683,-0.2533472852373387,0.642885766676974},
{0.9019619402761054,-0.2846486477734462,0.32471496056404875},
{0.952467975188816,-0.30463369331681084,-0.0017518949387389981},
{0.8870492550648998,-0.3418375734709244,-0.31030741604466455},
{0.734388791497383,-0.27901993476658477,-0.6187252855071175},
{0.4509429273597067,-0.1886814023406842,-0.8723816852015013},
{0.04635848995539585,-0.18719379030997924,-0.9812285030911194},
{-0.3565460388995573,-0.2161821749600406,-0.9089225431105677},
{-0.3859558030815668,-0.2536946611534398,-0.8869482154950785},
{-0.9627479429616985,-0.025030289586378283,0.26923945276693767},
{-0.7416159712724107,-0.08514037876875306,0.6653997798743189},
{-0.36942096260500584,0.04214141359587975,0.9283061206563985},
{-0.053304389106914145,0.04292108009145175,0.9976554630661438},
{0.24009557197692222,0.019084807098770074,0.9705616345472745},
{0.6107331389063161,-0.05546206107249233,0.7898917601945405},
{0.9391492169227778,-0.0935566993591857,0.33052366384019827},
{0.9377205108076572,-0.13994828700140927,0.31795395983695157},
{0.9892617223821595,-0.14422483894920823,-0.023673623709904768},
{0.9209085998159074,-0.16944709097776003,-0.35101999108922477},
{0.7427919806625007,-0.19002855259213125,-0.6419884910675725},
{0.7394187273068136,-0.18276602293927954,-0.6479633682292009},
{0.3628641706738495,-0.18127541013213994,-0.9140398346475955},
{0.0167041975848368,-0.22834719197242886,-0.9734364538588811},
{-0.7402744588733086,0.028801522590197588,0.6716875745734147},
{0.9945692025626728,-0.10269142359284604,-0.0169284622551425},
{0.9486318111681322,-0.11455453658876848,-0.2949151487916511},
{-0.7596068705953805,0.040959800439461326,-0.6490914395462725},
{-0.007073217503094384,-0.20144414223437435,0.979474464778746},
{0.3995219784172116,-0.14378638382863063,0.9053770841959072},
{0.748120501694642,-0.07422534351955476,0.6593984480748809},
{0.00521172875091424,0.2744329809664419,0.9615921052303307},
{-0.10029327904128302,0.3120403827934,0.9447603175860508},
{-0.01220938313467514,0.4270270592731727,0.9041564143509557},
{0.04397009100507601,0.4939331703834028,0.8683873872253132},
{0.011607356643260153,0.506017243251941,0.8624452555400036},
{-0.2242780463339776,0.5310810603887426,0.8170999114116847},
{-0.2906793770953777,0.5161113727007277,0.8056888671816272},
{-0.397319319878892,0.41913577753751186,0.8163715808619261},
{-0.2532716612821043,0.08333480865040443,0.9637991363653546},
{-0.10458310730179765,0.03539555575151587,0.9938860741051472},
{-0.17327341933039336,-0.12603073441473306,0.9767766255067923},
{-0.05423197796852703,0.19803478137073946,0.9786935771389658},
{-0.04514704852539771,0.43035034799726785,0.9015322079593585},
{-0.06618546407137886,0.7415417894461311,0.6676340755613708},
{0.014255247552954632,0.7282852981725431,0.6851257639170594},
{-0.010660917968736099,0.5932204023077738,0.8049695019774766},
{-0.1970189771266605,0.5168827662549735,0.8330760641145386},
{-0.6272806426542235,-0.6892472879680315,0.3625702295832052},
{-0.3280411071677655,-0.5272490500058189,0.7838351046464481},
{-0.2685716791854573,-0.3422879798260357,0.9003933540437286},
{-0.4087735395653843,-0.8395694758913913,0.3578090112093904},
{-0.5538935579380959,-0.828707800269657,0.0802826771284052},
{-0.6678294979602636,-0.6950771092070419,-0.2662171555526133},
{-0.8149522089984952,-0.5784719648676445,-0.03497260228578548},
{-0.531466549538571,-0.351986041586594,0.7704862966008974},
{-0.29038048813622974,0.048967951799605475,0.9556575285144341},
{-0.3176847945020111,0.32444571204807093,0.8909609145612591},
{-0.5911788854563006,0.5451505365083854,0.5944059369953045},
{-0.48370454198874563,0.8461685206637061,0.2236710770243956},
{-0.12360239604594697,0.9447690693452323,0.3035355881939459},
{-0.032608428553991,0.9377075144296793,0.34589204640950066},
{-0.015504552114915738,0.9424894908330694,0.3338759777715932},
{-0.014336923587092813,0.8598908904772758,0.5102765025907577},
{-0.06052320631696616,0.7492851607980783,0.659476071821345},
{-0.15466030893035804,0.5311831120051528,0.8330214225109026},
{-0.31458927283041027,-0.9485992421559771,0.034540804871047485},
{-0.3767337589313163,-0.7321425772675669,0.5674847323351402},
{-0.43691476573676263,-0.38854031132242206,0.8112594615526312},
{-0.4602747984719961,-0.8511611765422696,0.252332640454505},
{-0.48364857304193565,-0.8618251624169304,-0.15277907978362373},
{-0.27096943996983813,-0.9152357811729915,-0.29819293664186014},
{-0.36977900650504675,-0.9194591718473938,-0.1336350165706784},
{-0.47833819038554926,-0.8588694737031158,-0.18312783174496197},
{-0.5064791750802103,-0.7699987479196643,-0.3880473855242669},
{-0.6915097194255992,-0.5412907322343518,-0.4783499254072567},
{-0.8370092711532598,-0.39940886986266205,-0.3740160887963505},
{-0.9955518280430108,-0.07357495569612886,-0.058849669281416994},
{-0.8276930870584941,-0.27254816476951993,0.49055239426216923},
{-0.8881766712428486,0.2899871479760308,-0.35644025399595425},
{-0.3654822881621299,0.929527061640133,-0.04901161819848511},
{-0.13731452028831093,0.990522515619558,0.0031414278112947627},
{-0.05606198512115455,0.9974069079022527,-0.04512775080970072},
{-0.011293380527409028,0.9999275113861227,-0.004175108312208862},
{0.03222873740634698,0.9994750857236769,-0.003295679420279698},
{0.016736098553513042,0.9842399078766302,0.1760446157887532},
{-0.02857411088510027,0.9613864247466818,0.2737145639163527},
{-0.12268466129936473,0.9088731128885627,0.39862029370080254},
{-0.19776820723022603,0.6336626242278626,0.7479033459382308},
{-0.5817937432881448,0.13082581502023008,0.8027456922307717},
{-0.5888033755238672,-0.7182114580118268,-0.37078684786845656},
{-0.5585799959508444,-0.6096557603698101,-0.5624128750050656},
{-0.2779580769594936,-0.8179128504705911,-0.5037438600003504},
{-0.796769700684713,-0.3624769860794439,0.4834960999155585},
{-0.31376590018935985,-0.7758712225445542,-0.5473342725479371},
{-0.5238092605546455,-0.6405389302091465,-0.5615458462527503},
{-0.320959387549333,-0.575821547853741,-0.7519405671801989},
{-0.5145965695897111,-0.4332213535387577,-0.7399389362674114},
{-0.6821820938260279,-0.31326328196097214,-0.6606767038712482},
{-0.32871660501774164,-0.8725571696659423,-0.36137152523430793},
{-0.3068982458688535,-0.6390028042026383,-0.7053289182387075},
{-0.2887532650406829,-0.18228512557848398,-0.9398902515300293},
{-0.312243313990818,-0.12586266382394196,-0.9416276879548376},
{-0.43406560203558997,-0.09597947001253293,-0.8957538693556362},
{-0.5165092054707541,0.10175559968464454,-0.8502141133836751},
{-0.5662495074250304,0.4077390678320685,-0.716317211788427},
{-0.8109365742124793,-0.09630817649585897,-0.5771538856705121},
{-0.5803660964811477,-0.20637459244266995,-0.7877719985181988},
{-0.23497371959790503,0.439654488825713,-0.8668859680221649},
{-0.13254888141180116,0.47977539139720693,-0.8673213751811593},
{-0.21725455051588813,0.43852674952731563,-0.8720635012595966},
{-0.1730040863122983,0.7382837646585951,-0.6519253553596294},
{-0.16335068720842355,0.9177244679376073,-0.36207506671569006},
{-0.5329824097332659,0.7271430099056451,-0.43265782560850524},
{-0.023334725139479765,0.935872432259838,-0.3515654720513949},
{0.03295383979714369,0.9698113584511849,-0.24161948071645917},
{0.050327521170070826,0.9830007348169544,-0.17656923843694813},
{0.030177551470480436,0.9139798331575955,-0.4046358609521165},
{0.015431464158865605,0.9682833201022933,-0.24937778955952222},
{-0.08036650697795937,0.9053489277336345,-0.4169946565697457},
{-0.16255581541390704,0.9581557383204529,-0.23561236809367112},
{-0.3647674607802996,0.8848108685634978,-0.28992141422772},
{-0.47127757172278995,0.868831619589775,-0.1517533103167081},
{-0.08038620305068837,0.9955081315449914,0.05001618125060631},
{-0.10179735247641,0.9771145430175481,0.18677384413349132},
{-0.13262937649308085,0.8174621752304909,0.5605042734524784},
{-0.12855381626840234,0.1674278969645625,0.9774670406928583},
{-0.34414236700247025,0.7602472417204773,0.5509901656929488},
{-0.3273251000096874,0.12101419929548,0.9371306432256509},
{-0.5650353812008915,0.015685200235772252,0.8249175670845706},
{-0.012857562654679926,0.9512648434284829,0.30810693069057216},
{-0.095265715603183,0.9107797480107087,0.40175203054143166},
{-0.11787900424936361,0.9028500079324767,0.41348083816968473},
{-0.14854799548357886,0.924839549687027,0.35015039679044757},
{-0.13253479456874143,-0.9084158046373961,-0.39650378827145333},
{0.4527615021276172,-0.8758910809997174,-0.16679879021231028},
{-0.18539149580812553,-0.8834850358381542,-0.43021411498471474},
{-0.19439729048323362,-0.8285585063306562,-0.5250718951152205},
{-0.10579320803611138,-0.8566623233980151,-0.5049133200894416},
{0.5113023375556941,-0.78855155994098,-0.3416962934020945},
{-0.18246211535806575,-0.7884484534616737,-0.5874151961712898},
{-0.09140471242257073,-0.8073695116936711,-0.5829233655760164},
{0.4019504652615172,-0.720957325818135,-0.5644965525361635},
{0.17211390302990062,-0.7506210738089507,-0.6379222585375994},
{-0.11862223870733501,-0.7739066369332851,-0.6220910558709815},
{-0.14929014351216885,-0.7617159790684158,-0.6304769783917259},
{-0.12180641923710031,-0.7282620954728366,-0.6743867707259305},
{-0.10676382794100976,-0.7269354424369883,-0.6783556202850557},
{0.011186277854429274,-0.6560636179830748,-0.7546226847549189},
{-0.08009976255251007,-0.6521640800824998,-0.7538342262654157},
{-0.13103139626664922,-0.6457875796343386,-0.7521895872600437},
{-0.021197641000311695,0.9209788814506578,0.3890354224719354},
{-0.03783321580490969,0.918061480080095,0.39462864388562113},
{-0.059933634990297135,0.9423247067380288,0.32929030727906033},
{-0.5684430504279112,-0.14406981299767863,0.8100101156177159},
{-0.4932439148359235,-0.25763306064508723,0.8308643972032843},
{-0.47887975424087914,-0.2580019731696222,0.8391121276794757},
{-0.6100334875832365,0.10127249507801823,0.7858772332671979},
{-0.6376360268233653,0.33892577111172395,0.6917728087842394},
{-0.6297066035072643,0.442697601280723,0.6383482022530016},
{-0.4945185943163571,0.5369749043560207,0.6834539574596205},
{-0.5025253997374005,0.5852934966732448,0.6363173307169718},
{-0.41171073425502436,0.5666796538415182,0.7137005262862327},
{-0.40343911434762453,0.3686268680078761,-0.8374670818588086},
{-0.717296075375239,0.3372343652308219,-0.609720692742705},
{-0.8908569184426351,0.2966449172750992,-0.3440577624727303},
{-0.9396673462522039,0.2620923316553735,-0.21984741998665888},
{-0.9222244092786778,0.1144500110771464,-0.36932821973826335},
{-0.3520848159883502,0.4716124798197211,-0.8084664193575034},
{-0.6215128800702149,0.4776737381409772,-0.6209263561786147},
{-0.8612934240339232,0.38666897996875355,-0.3296372819415976},
{-0.881586140228741,0.3688282298503084,-0.29457021950984585},
{-0.6511531842922328,0.40973767817380646,-0.6388384503697503},
{-0.7633026744831036,0.5393611948925306,-0.3556100794002369},
{-0.39853147682617784,0.7508330886150654,-0.5267089661468723},
{-0.6874468504171886,0.6682017679427934,-0.2844700778106769},
{-0.6008740280187701,0.7693102286084703,-0.21705339115268688},
{-0.6048515950317571,0.7868343462499657,-0.12266319557604925},
{-0.4146919806198963,0.5926593588945586,-0.6904965210080629},
{-0.6605713180216872,0.5718752216485983,-0.4864198440354356},
{-0.8263965356314837,0.4794103653930515,-0.29535481619567744},
{-0.779195573898666,0.5707315492084173,-0.25907480841426594},
{-0.7288657390460008,0.6527835092360338,-0.20646652153416042},
{-0.6961408543770494,0.7015651183575804,-0.15229673526082474},
{-0.6794865918084391,0.7246989133169138,-0.11449653527437414},
{-0.09628176858400102,0.25703331240479754,-0.9615943517682259},
{-0.12964122955105753,-0.32723608222690226,-0.9360073173267813},
{-0.12530547736391934,-0.5200311177800455,-0.8449060148223805},
{-0.04036256285845272,-0.5276756527645942,-0.8484864577581405},
{-0.03262464412619793,-0.35312430035481773,-0.9350074123206508},
{-0.07764921302098098,-0.2046943728524693,-0.9757411610871791},
{-0.19514797571201759,-0.15854736559911328,-0.9678739589621589},
{-0.15399840286872907,-0.13018246648238854,-0.9794575117555853},
{-0.30895719347316514,-0.07342257961283152,-0.9482376165308897},
{-0.5350714795333198,0.028071749610065023,-0.8443402682946337},
{-0.5220223354906299,-0.12525196507014336,-0.8436851465416324},
{-0.4303742365257911,-0.056583899881952185,-0.900875284825259},
{-0.23336292095539243,-0.11453258989309748,-0.9656210607560021},
{-0.2945755944830644,-0.17449634119557558,-0.9395617308321504},
{-0.32021841983692884,-0.3421094111583343,-0.8834145767384859},
{-0.5666546741648651,-0.2989829420188232,-0.7677966401521172},
{-0.6635360906150626,-0.030670989704438264,-0.7475153154563656},
{-0.7483381375052266,-0.2068074572928866,-0.6302544784158692},
{-0.12837196781401294,-0.6697697232034034,-0.7313885121873289},
{-0.5276484373876579,0.5868321258632173,0.614178461505465},
{-0.3812275942622352,0.6048113746297029,0.6991914777023227},
{-0.5265956455347934,0.5596619201264312,0.6399027748527039},
{-0.6503050896847704,0.38513070689006523,0.6548111399025227},
{-0.4690320278325683,0.5936977363872207,0.6538592774259298},
{-0.46945204490261094,0.5758742416112802,0.6693157964558956},
{-0.4905295535208093,0.5860887091985392,0.6448881934666394},
{-0.413784819919496,0.6701154011666589,0.6162203111902739},
{-0.5099929557149904,0.7023558548985017,0.4965918225372653},
{-0.7227923533256322,0.24409138649551493,0.6465219323524081},
{-0.4512452507350787,0.39463005865252215,0.8004029238433247},
{-0.10424131401824509,0.776652078369412,0.6212449578195564},
{-0.15537733867190648,0.41618609106675586,0.8959056982907351},
{-0.3941141789455841,0.11556408505440323,0.9117669418220792},
{-0.6199143286697109,0.006343388207002751,0.784643859681599},
{-0.8913128288504356,0.05848205229329746,0.4496012574339602},
{-0.9708074336442775,0.19141202266545784,0.1445488303658323},
{-0.7855922596667656,0.5316333304986933,0.31656090007221743},
{-0.386026191477039,0.9213556794758804,0.0456890729964097},
{0.05565664555233362,0.9871097411542662,0.15005564542601985},
{0.5002544744287796,0.840712404710127,0.20723926601998274},
{0.3184804575041478,0.6930190765082629,0.6467571088001918},
{0.13770384600673174,0.44979397204822646,0.8824528505841168},
{-0.11684741281983413,0.1768425116075615,0.9772785724682809},
{-0.2954902626199829,-0.010976591837806155,0.9552826906881544},
{-0.566318036737247,-0.08960672379630841,0.8193012366135928},
{-0.879858987885532,-0.08801482586139289,0.4670134386349456},
{-0.9934121550139069,-0.10516493350539081,0.045526113730829564},
{-0.958929949586737,-0.028914642555755012,-0.28216536858985913},
{-0.9167139446111339,0.3138726337757071,-0.24722361036558776},
{-0.741468012868005,0.6657378285858389,-0.08377547065450783},
{-0.12332836038589509,0.9035936824425578,-0.410254277947744},
{0.24958611429447866,0.926086764915524,-0.2829665623349909},
{0.5532816604933808,0.8123320747907468,-0.18438005431132673},
{0.7869387204171906,0.5905433815521053,-0.17884620435770843},
{0.7305349188510544,0.6320022264825513,0.2586347193637803},
{0.5678374366866825,0.5263907560190974,0.6328296907341981},
{0.21523709305581476,0.3146892934201545,0.9244693842305467},
{-0.011896961893270077,0.0903404235726733,0.9958398817914553},
{-0.02233751941960511,0.03129110498713339,0.9992606776886915},
{-0.2712873873307227,-0.04107030251007598,0.9616217467003338},
{-0.5369196906614682,-0.10476098380958143,0.8371035670998194},
{-0.8611075858086656,-0.19192171284701906,0.4708075846889449},
{-0.9710983104057171,-0.23852997422687106,0.008457122589241497},
{-0.9126053800412273,-0.2170665274837565,-0.34645857323199675},
{-0.7944586464479426,0.009375379227216585,-0.6072458821173256},
{-0.7496037161163587,0.3068474029944804,-0.5864630764678102},
{-0.5012363649642773,0.6835161215728265,-0.530629642959606},
{0.10921665117637523,0.696768425257125,-0.7089326376113065},
{0.42070075729173395,0.695955341759268,-0.5819424671657002},
{0.6174465665814854,0.6596656410684542,-0.42848684858520536},
{0.7032300822830136,0.5167207944174352,-0.4883309041918609},
{0.7645651358391864,0.4372929550961917,-0.4735134892296589},
{0.867015034106375,0.462265341402932,-0.18599915260869385},
{0.8436094233052708,0.48291724565551064,0.2347638702165301},
{0.5996511793878001,0.37068114602010105,0.7092347644074175},
{0.2662987963281102,0.21985754691880297,0.9384815449102055},
{0.3384730151208965,0.1691963838375515,0.9256395636160251},
{0.3201357289885925,0.16546081211417563,0.9328107174981751},
{-0.010035732149515673,0.0763831226159748,0.9970280350419722},
{-0.2760030043945566,0.07508785036277994,0.9582192631611385},
{-0.5842463406223257,0.06776433056386842,0.8087423625436299},
{-0.8652858730273321,-0.1963257061860549,0.46123375313378195},
{-0.9538961499540596,-0.2992659149357264,-0.02284835356223558},
{-0.8891804054066526,-0.30012831512345783,-0.34537110635085744},
{-0.7305076685644465,-0.23166500411385996,-0.6424094271081815},
{-0.7156315193443545,-0.12083379969683736,-0.6879467431216717},
{-0.41355435426445997,0.16596765932293636,-0.8952248500392352},
{-0.4582443758479988,0.3276796795545516,-0.8262191716552602},
{-0.15389292619719117,0.5424647690175496,-0.8258625440357508},
{0.3441515152384421,0.4754954238323127,-0.8096072112287623},
{0.5748617092940915,0.4853866329800244,-0.6587365419587642},
{0.6313393290689888,0.38712333225488554,-0.6719718574424025},
{0.6617250493353238,0.3330322370829953,-0.671721287548384},
{0.8048083789943425,0.3820948791280691,-0.4541882610158533},
{0.8975668330339767,0.41177144676856214,-0.1575374744734812},
{0.893531380281306,0.40706601776858525,0.1894701285971219},
{0.7300002222740194,0.3359246486705582,0.5951926628373743},
{-0.9197380926713463,0.3373104797570784,-0.20075726919671755},
{-0.5439411276963867,0.8321449671902162,-0.10799445902627153},
{-0.8276661754971099,0.556148623470591,-0.07528220606328108},
{-0.9779245774865022,-0.022170653400545352,-0.20777868725073606},
{-0.976662707092105,0.18827127456584603,0.10336287413221887},
{-0.5513126112265169,0.8342985073294645,-0.0006366870713304067},
{-0.3557118653930481,0.9300451962860697,-0.09211406887009263},
{-0.7153889843628392,0.6881969616892515,-0.12084511977729309},
{-0.9061924114383121,0.21811634582731182,-0.36227140811076614},
{-0.9181956373923976,-0.15880896882259427,-0.3629001004340905},
{-0.9720203183639236,-0.2255451672376694,-0.0656191909690173},
{-0.9050375060772957,-0.006714779356112629,0.4252787607341656},
{-0.726791753163634,0.42063670187439717,0.542990342980021},
{-0.6728722027256085,0.7176960467134409,0.17931922186727833},
{-0.2934451634108754,0.9530203395193398,0.07511436968521212},
{-0.09568300236285208,0.9902641308372854,-0.10110249371754472},
{0.01737823620645962,0.9997698208016141,-0.012581825013118789},
{-0.7541446636244438,0.633121809630614,-0.17442075706988225},
{-0.7862095423494413,0.23492888995446817,-0.5715618708271601},
{-0.7747306372562885,-0.17013757836305604,-0.6089709714963595},
{-0.8793231228279532,-0.3064059132236824,-0.364563111136683},
{-0.4577805385052514,0.3766817633565469,0.8053246722412299},
{-0.48276127283229336,0.7268321523931583,0.4885248977287368},
{-0.5206216225398358,0.8086915792006629,0.2738084291506139},
{-0.2615087182953305,0.9302121627110868,0.25752382918847777},
{-0.07991450635590784,0.9922621572645872,0.09502359146295708},
{-0.6902632066438574,0.6800424890452473,-0.2471414951943198},
{-0.41789920184317075,0.4548800694048959,-0.7864123470273328},
{-0.3679456812167491,-0.015482424593143484,-0.9297183822011159},
{-0.7242492667308698,-0.25575819050072834,-0.6403520497598104},
{-0.6355139772338634,0.760402543593812,-0.13382808537992852},
{-0.4953309211519966,0.831110927154265,-0.25278826182299774},
{-0.25076570044816515,0.8947307999051397,-0.3695583298747983},
{0.07586141550823039,0.5317837869714007,-0.8434755773295652},
{0.18912935952616,0.2250039142741459,-0.9558259904012536},
{0.21188547309689618,0.14664262741303966,-0.9662300378874095},
{-0.3180997031898421,-0.07702809732277924,-0.9449228810084804},
{-0.41658540378355435,0.6259268593628926,0.6592967223357011},
{-0.284483215528201,0.3649119433834734,0.8865148468349708},
{-0.2901573191007381,0.5812001043082724,0.7602730883862231},
{-0.3697149429926584,0.7046704645258851,0.6055992052115067},
{-0.38877734958511784,0.7710070378108197,0.5043811258321986},
{-0.07511914228484842,0.2967811314713682,0.9519863835501867},
{-0.10668667452137415,0.5834581805857224,0.8051052757168897},
{-0.3160659783673624,0.7032856540153591,0.6367822125145067},
{-0.3217443409603713,0.6379927458861286,0.6996040560607507},
{-0.2910904630153967,0.7713230154353843,0.5659745119712971},
{-0.2998490495839525,0.6733888557905547,0.6757499510622903},
{-0.21806783554699394,0.7643359518316294,0.6068253223436595},
{-0.22310920671446693,0.7800467741148372,0.5845932877413813},
{-0.08654299370948787,0.8542474592929392,0.5126125130460214},
{-0.14977315034460154,0.8780526685862358,0.4545233928242237},
{0.02772371865468341,0.9489279506740897,0.3142723975366405},
{-0.11959289008918811,0.9557900589665799,0.26863153914009646},
{-0.027398166209691596,0.9946956121684765,0.09914625369183627},
{-0.1591458740797805,0.9813804396654908,0.10754079879445899},
{0.0021774040458172514,0.9992481629979599,-0.038708754265976815},
{0.016427373041400194,0.9889152787575598,-0.1475693493067455},
{-0.0736903713283936,0.9774513963159219,-0.19788506010696746},
{-0.2643813093680292,0.9637338299779377,-0.03632668733730159},
{-0.21546215214361444,0.9615222393806258,-0.17044366861256055},
{-0.2906874044853722,0.9537470626565016,-0.07659878163295168},
{-0.3411541450255334,0.931260115671356,-0.12793922890055986},
{-0.46214111829018334,0.8735677929449782,-0.1526594180348487},
{0.17434550633420132,0.632480141631375,0.7547002814780358},
{0.48611446507366285,0.7112659056128492,0.5077337278129948},
{0.6066335671613129,0.7844390293681147,0.12903923588254396},
{0.5820353893327458,0.7953943518585161,-0.16906398373352569},
{0.5515422569192013,0.7421938608760866,-0.38072222381983656},
{0.4817093633699596,0.6696162442629656,-0.5653053817724261},
{0.2459869723421322,0.7144950200502217,-0.6549712022382239},
{0.472505686224193,0.3355473255251706,-0.8149517585837271},
{0.5003041805707902,0.25892482898498603,-0.8262285760239026},
{0.4665319211325591,0.2665771506985794,-0.8433768963457503},
{0.11551563734679039,0.1324976238065334,-0.9844290310702887},
{-0.39311079670120214,-0.07028468073820085,-0.9168009408647416},
{-0.30244836864470875,0.05824213905341949,-0.9513846948225709},
{0.14730068498733281,0.23787987406409633,-0.9600602448375375},
{0.06687970278028686,0.36408446429895436,-0.9289615752075884},
{0.4385360984399338,0.3439837598787374,-0.8302778229633548},
{0.6723652441095511,0.3232787504607591,-0.6658947574609925},
{0.7890345778375233,0.36772191845393215,-0.49214329789739186},
{0.8897226479026866,0.40056409144815713,-0.2189566588422104},
{0.908642848830384,0.39305989090518956,0.14096841997768214},
{0.7300633656589434,0.31315708096386,0.607404416155275},
{0.6303145973145284,0.3962599688982382,0.6675938476806024},
{0.24486871895434387,0.31181311765249736,0.9180478691971833},
{0.8658014901109754,0.4553595117740666,0.20744998134128195},
{0.8483249443510474,0.4960604722791238,-0.18511833143696144},
{0.7735443505312879,0.44211226708723206,-0.4540549317561873},
{0.6425931424447984,0.39774384168257343,-0.6548846384566573},
{-0.06044845078254851,0.771240325815404,-0.6336673769685003},
{-0.029825248944145236,0.7960294528534776,-0.6045225923943729},
{-0.3032980655002108,0.6475714041603954,0.699043317668915},
{-0.29206752365557653,0.534222091386553,0.7932864039552656},
{-0.2123449292586352,0.794167738122806,0.5693919868974724},
{-0.15952887186057108,0.8796172561620883,0.44813393277542896},
{-0.2853044653718591,0.7928253635184876,0.5385436890361407},
{-0.3855570360921872,0.6587505799332997,0.6460599394462941},
{-0.3699531677391987,0.5299889875091791,0.7630506711868665},
{-0.1951671717389562,0.8898283065483303,0.4124504333138074},
{-0.13304754155173368,0.949218776169775,0.28510009935774155},
{-0.14212998054764914,0.9504276406169386,0.2765616903709625},
{-0.2222260595523339,0.8540846313098078,0.4702712206974101},
{-0.3402923999562963,0.7497523898415611,0.5675142610180398},
{-0.4117631344297478,0.52740409781741,0.7431662255040881},
{-0.11372415511409423,0.9780634477420251,-0.1745242353788384},
{-0.11532423479135093,0.9190347475233476,-0.3769289770162095},
{-0.19170306172491647,0.969838599321863,-0.15054244381801338},
{-0.19373663209392683,0.9099017055907389,-0.3668037670852997},
{-0.10775270954454935,0.7827483378308757,-0.6129391431527351},
{-0.25381006469830003,0.9657887431977283,-0.053221749035494856},
{-0.25903816008749875,0.9494041368341455,-0.17756975131112399},
{-0.28997202223521984,0.872673639244374,-0.3928828650995071},
{-0.1808895149966198,0.7763790926233876,-0.6037503522993365},
{-0.2752890969224229,0.7514668429081487,-0.5995944438746048},
{-0.46564040541914575,0.7204549181876431,-0.513929687506307},
{-0.4847476984240412,0.7986134003751151,-0.35670198431448485},
{-0.66659815828878,0.7061484299945491,-0.2387494297003451},
{-0.6769163300749351,0.650497404640633,-0.3444378153363569},
{-0.3356127910823731,0.9199131577876984,-0.20279012942193267},
{-0.4873995678633206,0.8419859921878262,-0.23130337266484047},
{-0.6438990475362193,0.7443781308565343,-0.17690453607661363},
{-0.0894820329191724,0.983459211103056,0.15748316062743575},
{-0.13741051547654942,0.9808331733027725,0.13814715482152415},
{-0.1554147656475177,0.9784712214101364,0.13579513795008605},
{-0.3912569600618874,-0.01850713952906662,0.9200953629866755},
{-0.48306254134916016,-0.1006184117990084,0.8697853277403201},
{-0.6084429095951346,-0.06759913189952683,0.7907133381509617},
{-0.5516866688151688,-0.2825606817417571,0.784730068612931},
{-0.353985521442136,-0.15084048974986186,0.9230067157184507},
{-0.36337114449426494,-0.06589998023373658,0.9293108220364815},
{-0.3661387339265137,-0.06934203562407582,0.927973119014877},
{-0.31338068395318064,-0.09369214183688014,0.9449943542069733},
{-0.25022930752105144,-0.11735128436908003,0.9610483701221612},
{-0.17419928105530103,-0.14120601995856571,0.9745334629489526},
{-0.08840839908917883,-0.16008519629363183,0.9831361476917212},
{-0.3174753811842732,-0.09539501255857291,0.9434559734936497},
{-0.2619599370640458,-0.12689902424273777,0.9566993409737681},
{-0.11849356461153107,0.5922623315098966,0.7969846961015713},
{-0.2271320351173588,0.6296823811496969,0.7429072199764214},
{-0.36944846959577465,0.5559122944088367,0.7446269866439456},
{-0.6029886112815588,0.19548985031710578,0.7734264367654708},
{-0.6927332979339382,-0.11296914765620703,0.7122910568099249},
{-0.7014619850551368,-0.3310440277416344,0.6311584073900172},
{-0.6671450566744161,-0.2528829347217346,0.7006908695576195},
{-0.09487131210882745,-0.19544555892600823,0.9761149868918362},
{-0.09069156345780156,-0.4275386840541776,0.8994363312401839},
{0.010424757823193166,-0.995490050697991,-0.09429148098125861},
{0.07086863738132838,-0.7257399974001473,-0.684309208186875},
{0.05131113984380555,-0.7183288832588147,-0.6938088947282772},
{-0.07176754007021638,-0.9249907283487189,-0.37315087117837},
{-0.25153948868764225,-0.9259062963416896,0.28182515151344245},
{-0.2746295624823686,-0.6341489754623147,0.7227957390098804},
{-0.2901171564351573,-0.18198292380931674,0.9395287387748129},
{-0.19341155746738917,0.33631946256853334,0.9216730377610336},
{-0.11995680922953636,0.6167741023085458,0.7779460589532902},
{-0.10706839987113839,0.6787858865067162,0.7264888698585309},
{-0.11283551774237915,0.6590315254705873,0.7436031161659558},
{-0.19295527960991327,-0.34710375189842085,0.917762085449546},
{-0.18531478032671247,-0.16419104971014503,0.9688651770951122},
{-0.28356899248654843,-0.2572195659043841,0.9238109771030673},
{-0.27601707838217826,-0.8553629471035548,0.43837062078073574},
{-0.08379836679927948,-0.9924176533862066,0.08991682250384692},
{-0.6407588853860645,-0.5283189663295919,0.5570521704609359},
{-0.4410676872949495,-0.5516729784912819,0.707895627919005},
{-0.4740510875369554,-0.870730672188929,0.13078097305971526},
{-0.6688705226443354,-0.6005368071427595,0.43814126398260395},
{-0.5071522478459884,-0.8617209519944622,0.015283926148696309},
{-0.09320411192036106,-0.877217879639979,-0.47095836881944897},
{-0.6849937424280568,-0.4259597835627525,0.5910514661360533},
{-0.6492227296644453,-0.6443702896205815,0.40409995934339654},
{-0.5396473294087566,-0.8389477514311156,0.07033797147112188},
{-0.14525189140831296,-0.8512537884891589,-0.504250806271207},
{0.06256046541788884,-0.758865179450838,-0.6482359351221934},
{-0.6840353848815658,-0.19767316590549355,0.702154478523656},
{-0.6224168110246594,-0.24249863114649936,0.7441718398635945},
{-0.6134381026186029,-0.5057975955873607,0.6065166828321651},
{-0.5839815147062631,-0.7059781753572915,0.400699895683251},
{-0.403745762320385,-0.9107108401724077,-0.08715001434766774},
{0.022053851918419652,-0.7532009441411389,-0.6574206913084326},
{-0.2637366413578908,0.5677621727762302,0.7798006791287587},
{-0.545840418635658,0.13909992343322802,0.826262336479474},
{-0.38368908468658663,0.2573871017054591,0.8868678403054386},
{-0.4943345632803015,-0.2157534011686368,0.8420711427371437},
{-0.6360383298592373,0.05323144690179875,0.7698192359317952},
{-0.4289512287374809,0.4500088386626525,0.7832578684508035},
{-0.22814125200412808,0.6448701076020257,0.7294478140726317},
{-0.20492819919004365,-0.9393169998572832,-0.2751145342504435},
{-0.4451880022377307,-0.829184218731699,0.33802540447410184},
{-0.4901646343390911,-0.5710458802580103,0.6585174514647121}
};


// face array: 40kb.
const uint16_t spot_face[20481] PROGMEM = {
49, // chain 0
0,0,0, 1,1,1, 2,2,2, 
3,3,3, 32772,4,4, 32773,5,5, 32769,1,1, 6,6,6, 32775,7,7, 32776,8,8, 32768,0,0, 9,9,9, 32778,10,10, 32771,3,3, 11,11,11, 32780,12,12, 32772,4,4, 13,13,13, 32782,14,14, 
32773,5,5, 15,15,15, 32774,6,6, 16,16,16, 32785,17,17, 32775,7,7, 18,18,18, 32787,19,19, 32776,8,8, 20,20,20, 32777,9,9, 21,21,21, 32790,22,22, 32778,10,10, 23,23,23, 32779,11,11, 
24,24,24, 32780,12,12, 25,25,25, 32781,13,13, 26,26,26, 32795,27,27, 32782,14,14, 28,28,28, 32783,15,15, 29,29,29, 32784,16,16, 30,30,30, 32799,31,31, 32785,17,17, 32,32,32, 32786,18,18, 
3, // chain 1
33,33,33, 30,30,30, 31,31,31, 
34,34,34, 32800,32,32, 
5, // chain 2
35,35,35, 36,36,36, 37,37,37, 
38,38,38, 32807,39,39, 40,40,40, 32809,41,41, 
9, // chain 3
36,36,36, 35,35,35, 42,42,42, 
43,43,43, 32789,21,21, 32812,44,44, 32803,35,35, 45,45,45, 32806,38,38, 46,46,46, 32808,40,40, 
17, // chain 4
43,43,43, 21,21,21, 22,22,22, 
23,23,23, 47,47,47, 32816,48,48, 32792,24,24, 49,49,49, 32793,25,25, 50,50,50, 32794,26,26, 51,51,51, 32820,52,52, 32795,27,27, 53,53,53, 32796,28,28, 54,54,54, 32823,55,55, 32797,29,29, 
7, // chain 5
19,19,19, 20,20,20, 56,56,56, 
57,57,57, 32826,58,58, 32813,45,45, 32812,44,44, 32788,20,20, 21,21,21, 
1, // chain 6
46,46,46, 58,58,58, 45,45,45, 
10, // chain 7
59,59,59, 60,60,60, 61,61,61, 
62,62,62, 32831,63,63, 32832,64,64, 32833,65,65, 32828,60,60, 66,66,66, 32835,67,67, 32836,68,68, 32827,59,59, 
4, // chain 8
66,66,66, 67,67,67, 69,69,69, 
32838,70,70, 32839,71,71, 32836,68,68, 
31, // chain 9
72,72,72, 73,73,73, 74,74,74, 
75,75,75, 32844,76,76, 32845,77,77, 32846,78,78, 32841,73,73, 79,79,79, 32848,80,80, 32849,81,81, 32840,72,72, 65,65,65, 32832,64,64, 32843,75,75, 82,82,82, 32844,76,76, 83,83,83, 32852,84,84, 
32845,77,77, 85,85,85, 32854,86,86, 32846,78,78, 87,87,87, 32847,79,79, 88,88,88, 32857,89,89, 32848,80,80, 90,90,90, 32859,91,91, 32849,81,81, 66,66,66, 32833,65,65, 
7, // chain 10
91,91,91, 66,66,66, 69,69,69, 
92,92,92, 32861,93,93, 32838,70,70, 94,94,94, 32863,95,95, 32839,71,71, 
23, // chain 11
63,63,63, 64,64,64, 82,82,82, 
96,96,96, 32865,97,97, 32851,83,83, 98,98,98, 32852,84,84, 99,99,99, 32853,85,85, 100,100,100, 32869,101,101, 32854,86,86, 102,102,102, 32855,87,87, 103,103,103, 32856,88,88, 104,104,104, 32873,105,105, 
32857,89,89, 106,106,106, 32858,90,90, 107,107,107, 32860,92,92, 32859,91,91, 
35, // chain 12
108,108,108, 109,109,109, 99,99,99, 
100,100,100, 110,110,110, 32879,111,111, 32869,101,101, 112,112,112, 32870,102,102, 113,113,113, 32871,103,103, 114,114,114, 32872,104,104, 115,115,115, 32884,116,116, 32873,105,105, 117,117,117, 32874,106,106, 118,118,118, 
32875,107,107, 119,119,119, 32888,120,120, 32860,92,92, 93,93,93, 121,121,121, 32862,94,94, 122,122,122, 32891,123,123, 32863,95,95, 124,124,124, 32893,125,125, 126,126,126, 32895,127,127, 128,128,128, 32897,129,129, 
130,130,130, 32899,131,131, 
44, // chain 13
109,109,109, 108,108,108, 132,132,132, 
133,133,133, 32902,134,134, 32903,135,135, 32904,136,136, 32876,108,108, 110,110,110, 137,137,137, 32906,138,138, 32879,111,111, 139,139,139, 32880,112,112, 140,140,140, 32909,141,141, 32881,113,113, 142,142,142, 32882,114,114, 
143,143,143, 32883,115,115, 144,144,144, 32884,116,116, 145,145,145, 32885,117,117, 146,146,146, 32886,118,118, 147,147,147, 32887,119,119, 148,148,148, 32917,149,149, 32888,120,120, 121,121,121, 150,150,150, 32890,122,122, 
151,151,151, 32920,152,152, 32891,123,123, 153,153,153, 32892,124,124, 154,154,154, 32894,126,126, 155,155,155, 32896,128,128, 156,156,156, 32898,130,130, 
30, // chain 14
98,98,98, 99,99,99, 109,109,109, 
157,157,157, 32901,133,133, 158,158,158, 32902,134,134, 159,159,159, 32928,160,160, 32903,135,135, 161,161,161, 32930,162,162, 32904,136,136, 137,137,137, 163,163,163, 32932,164,164, 32906,138,138, 165,165,165, 32907,139,139, 
166,166,166, 32935,167,167, 32908,140,140, 168,168,168, 32937,169,169, 32909,141,141, 170,170,170, 32910,142,142, 171,171,171, 32911,143,143, 172,172,172, 32941,173,173, 32912,144,144, 
31, // chain 15
174,174,174, 175,175,175, 176,176,176, 
177,177,177, 32946,178,178, 32947,179,179, 32948,180,180, 32943,175,175, 181,181,181, 32950,182,182, 32951,183,183, 32942,174,174, 184,184,184, 32945,177,177, 185,185,185, 32954,186,186, 32955,187,187, 32946,178,178, 188,188,188, 
32947,179,179, 189,189,189, 32958,190,190, 32948,180,180, 191,191,191, 32949,181,181, 192,192,192, 32961,193,193, 32950,182,182, 194,194,194, 32963,195,195, 32951,183,183, 196,196,196, 32952,184,184, 
22, // chain 16
188,188,188, 189,189,189, 197,197,197, 
198,198,198, 32967,199,199, 32968,200,200, 32969,201,201, 32957,189,189, 202,202,202, 32958,190,190, 203,203,203, 32959,191,191, 204,204,204, 32960,192,192, 205,205,205, 32974,206,206, 32961,193,193, 207,207,207, 32962,194,194, 
208,208,208, 32977,209,209, 32963,195,195, 210,210,210, 32964,196,196, 
11, // chain 17
187,187,187, 211,211,211, 212,212,212, 
186,186,186, 32981,213,213, 32982,214,214, 32983,215,215, 32979,211,211, 216,216,216, 32985,217,217, 32966,198,198, 32955,187,187, 188,188,188, 
17, // chain 18
218,218,218, 185,185,185, 186,186,186, 
213,213,213, 219,219,219, 32988,220,220, 32989,221,221, 32982,214,214, 222,222,222, 32991,223,223, 32983,215,215, 224,224,224, 32984,216,216, 225,225,225, 32994,226,226, 32985,217,217, 227,227,227, 32967,199,199, 32966,198,198, 
8, // chain 19
228,228,228, 62,62,62, 63,63,63, 
96,96,96, 229,229,229, 32998,230,230, 32865,97,97, 231,231,231, 32925,157,157, 32866,98,98, 
15, // chain 20
62,62,62, 228,228,228, 232,232,232, 
233,233,233, 33002,234,234, 33003,235,235, 33004,236,236, 32996,228,228, 229,229,229, 237,237,237, 33006,238,238, 32998,230,230, 239,239,239, 32999,231,231, 240,240,240, 32926,158,158, 32925,157,157, 
48, // chain 21
241,241,241, 234,234,234, 235,235,235, 
242,242,242, 33011,243,243, 33004,236,236, 237,237,237, 244,244,244, 33013,245,245, 33006,238,238, 246,246,246, 33007,239,239, 247,247,247, 33008,240,240, 248,248,248, 33017,249,249, 32926,158,158, 159,159,159, 250,250,250, 
32928,160,160, 251,251,251, 32929,161,161, 252,252,252, 33021,253,253, 32930,162,162, 163,163,163, 254,254,254, 33023,255,255, 32932,164,164, 256,256,256, 32933,165,165, 257,257,257, 32934,166,166, 258,258,258, 33027,259,259, 
32935,167,167, 260,260,260, 32936,168,168, 261,261,261, 33030,262,262, 32937,169,169, 263,263,263, 32938,170,170, 264,264,264, 32939,171,171, 265,265,265, 32940,172,172, 266,266,266, 267,267,267, 33036,268,268, 
52, // chain 22
243,243,243, 244,244,244, 269,269,269, 
242,242,242, 32822,54,54, 33038,270,270, 33039,271,271, 33012,244,244, 272,272,272, 33013,245,245, 273,273,273, 33014,246,246, 274,274,274, 33015,247,247, 275,275,275, 33016,248,248, 276,276,276, 33045,277,277, 33017,249,249, 
250,250,250, 278,278,278, 33019,251,251, 279,279,279, 33020,252,252, 280,280,280, 33049,281,281, 33021,253,253, 254,254,254, 282,282,282, 33051,283,283, 33023,255,255, 284,284,284, 33024,256,256, 285,285,285, 33054,286,286, 
33025,257,257, 287,287,287, 33026,258,258, 288,288,288, 33057,289,289, 33027,259,259, 290,290,290, 33028,260,260, 261,261,261, 291,291,291, 33060,292,292, 33030,262,262, 293,293,293, 33062,294,294, 33031,263,263, 264,264,264, 
295,295,295, 33033,265,265, 267,267,267, 
3, // chain 23
296,296,296, 241,241,241, 242,242,242, 
54,54,54, 55,55,55, 
46, // chain 24
53,53,53, 54,54,54, 270,270,270, 
52,52,52, 33065,297,297, 33039,271,271, 298,298,298, 33040,272,272, 299,299,299, 33041,273,273, 300,300,300, 33042,274,274, 301,301,301, 33043,275,275, 302,302,302, 33044,276,276, 303,303,303, 33072,304,304, 33045,277,277, 
278,278,278, 305,305,305, 33047,279,279, 306,306,306, 33048,280,280, 307,307,307, 33049,281,281, 282,282,282, 308,308,308, 33077,309,309, 33051,283,283, 310,310,310, 33052,284,284, 311,311,311, 33080,312,312, 33053,285,285, 
313,313,313, 33082,314,314, 33054,286,286, 315,315,315, 33055,287,287, 316,316,316, 33056,288,288, 317,317,317, 33086,318,318, 33057,289,289, 319,319,319, 33058,290,290, 291,291,291, 
19, // chain 25
320,320,320, 297,297,297, 298,298,298, 
321,321,321, 33067,299,299, 322,322,322, 33068,300,300, 323,323,323, 33069,301,301, 324,324,324, 33070,302,302, 325,325,325, 33071,303,303, 326,326,326, 33095,327,327, 33072,304,304, 305,305,305, 328,328,328, 33074,306,306, 
308,308,308, 33075,307,307, 
2, // chain 26
297,297,297, 320,320,320, 51,51,51, 
52,52,52, 
10, // chain 27
322,322,322, 329,329,329, 330,330,330, 
321,321,321, 33099,331,331, 33100,332,332, 33097,329,329, 333,333,333, 33102,334,334, 33103,335,335, 33091,323,323, 33090,322,322, 
30, // chain 28
335,335,335, 323,323,323, 324,324,324, 
336,336,336, 33093,325,325, 337,337,337, 33094,326,326, 338,338,338, 33107,339,339, 33095,327,327, 328,328,328, 340,340,340, 33076,308,308, 309,309,309, 341,341,341, 33078,310,310, 342,342,342, 33079,311,311, 343,343,343, 
33080,312,312, 344,344,344, 33113,345,345, 33081,313,313, 346,346,346, 33115,347,347, 33082,314,314, 348,348,348, 33083,315,315, 349,349,349, 33084,316,316, 350,350,350, 33085,317,317, 
7, // chain 29
209,209,209, 210,210,210, 351,351,351, 
352,352,352, 33121,353,353, 354,354,354, 33123,355,355, 43,43,43, 32804,36,36, 
2, // chain 30
352,352,352, 356,356,356, 208,208,208, 
209,209,209, 
4, // chain 31
356,356,356, 352,352,352, 354,354,354, 
357,357,357, 32815,47,47, 32811,43,43, 
6, // chain 32
358,358,358, 208,208,208, 356,356,356, 
359,359,359, 33125,357,357, 360,360,360, 32816,48,48, 32815,47,47, 
9, // chain 33
207,207,207, 208,208,208, 358,358,358, 
361,361,361, 33130,362,362, 33127,359,359, 363,363,363, 33128,360,360, 364,364,364, 32817,49,49, 32816,48,48, 
19, // chain 34
365,365,365, 366,366,366, 367,367,367, 
368,368,368, 33137,369,369, 32971,203,203, 32970,202,202, 33134,366,366, 201,201,201, 33138,370,370, 33139,371,371, 33133,365,365, 372,372,372, 33141,373,373, 33136,368,368, 374,374,374, 33143,375,375, 33137,369,369, 376,376,376, 
32972,204,204, 32971,203,203, 
2, // chain 35
205,205,205, 377,377,377, 376,376,376, 
204,204,204, 
6, // chain 36
377,377,377, 205,205,205, 378,378,378, 
379,379,379, 33148,380,380, 33129,361,361, 32974,206,206, 32973,205,205, 
9, // chain 37
381,381,381, 376,376,376, 377,377,377, 
382,382,382, 33147,379,379, 383,383,383, 33152,384,384, 33148,380,380, 385,385,385, 33130,362,362, 33129,361,361, 
14, // chain 38
375,375,375, 376,376,376, 381,381,381, 
386,386,386, 33155,387,387, 33150,382,382, 388,388,388, 33151,383,383, 389,389,389, 33101,333,333, 33152,384,384, 332,332,332, 33153,385,385, 390,390,390, 33131,363,363, 33130,362,362, 
4, // chain 39
331,331,331, 332,332,332, 390,390,390, 
391,391,391, 33132,364,364, 33131,363,363, 
35, // chain 40
392,392,392, 393,393,393, 394,394,394, 
395,395,395, 33164,396,396, 33165,397,397, 33166,398,398, 33161,393,393, 344,344,344, 33111,343,343, 33167,399,399, 33160,392,392, 400,400,400, 33169,401,401, 33163,395,395, 402,402,402, 33171,403,403, 33164,396,396, 404,404,404, 
33173,405,405, 33165,397,397, 406,406,406, 33166,398,398, 407,407,407, 33112,344,344, 345,345,345, 408,408,408, 33114,346,346, 409,409,409, 33178,410,410, 33115,347,347, 411,411,411, 33116,348,348, 412,412,412, 33117,349,349, 
413,413,413, 33118,350,350, 
5, // chain 41
340,340,340, 341,341,341, 414,414,414, 
33183,415,415, 33110,342,342, 399,399,399, 33111,343,343, 
31, // chain 42
415,415,415, 399,399,399, 400,400,400, 
414,414,414, 33184,416,416, 33185,417,417, 33169,401,401, 418,418,418, 33170,402,402, 419,419,419, 33188,420,420, 33171,403,403, 421,421,421, 33172,404,404, 422,422,422, 33191,423,423, 33173,405,405, 424,424,424, 33174,406,406, 
425,425,425, 33175,407,407, 408,408,408, 426,426,426, 33177,409,409, 427,427,427, 33196,428,428, 33178,410,410, 429,429,429, 33179,411,411, 430,430,430, 33180,412,412, 431,431,431, 33181,413,413, 
17, // chain 43
432,432,432, 433,433,433, 434,434,434, 
435,435,435, 33186,418,418, 33185,417,417, 33204,436,436, 33201,433,433, 437,437,437, 33206,438,438, 33207,439,439, 33200,432,432, 440,440,440, 33209,441,441, 33203,435,435, 442,442,442, 33211,443,443, 33187,419,419, 33186,418,418, 
122, // chain 44
444,444,444, 445,445,445, 446,446,446, 
447,447,447, 33216,448,448, 33217,449,449, 33213,445,445, 450,450,450, 33219,451,451, 33220,452,452, 33212,444,444, 453,453,453, 33222,454,454, 33215,447,447, 455,455,455, 33224,456,456, 33216,448,448, 457,457,457, 33226,458,458, 
33217,449,449, 459,459,459, 33228,460,460, 33218,450,450, 461,461,461, 33219,451,451, 462,462,462, 33220,452,452, 463,463,463, 33221,453,453, 464,464,464, 33233,465,465, 33222,454,454, 466,466,466, 33223,455,455, 467,467,467, 
33236,468,468, 33224,456,456, 469,469,469, 33225,457,457, 470,470,470, 33239,471,471, 33226,458,458, 472,472,472, 33227,459,459, 473,473,473, 33242,474,474, 33228,460,460, 475,475,475, 33244,476,476, 33229,461,461, 477,477,477, 
33246,478,478, 33230,462,462, 479,479,479, 33231,463,463, 480,480,480, 33232,464,464, 481,481,481, 33250,482,482, 33233,465,465, 483,483,483, 33234,466,466, 484,484,484, 33235,467,467, 485,485,485, 33254,486,486, 33236,468,468, 
487,487,487, 33237,469,469, 488,488,488, 33238,470,470, 489,489,489, 33258,490,490, 33239,471,471, 491,491,491, 33240,472,472, 492,492,492, 33241,473,473, 373,373,373, 33140,372,372, 33242,474,474, 493,493,493, 33243,475,475, 
494,494,494, 33263,495,495, 33244,476,476, 477,477,477, 496,496,496, 33265,497,497, 33266,498,498, 33246,478,478, 479,479,479, 499,499,499, 33268,500,500, 33248,480,480, 501,501,501, 33249,481,481, 502,502,502, 33271,503,503, 
33250,482,482, 504,504,504, 33251,483,483, 505,505,505, 33252,484,484, 506,506,506, 33253,485,485, 507,507,507, 33276,508,508, 33254,486,486, 509,509,509, 33255,487,487, 510,510,510, 33256,488,488, 511,511,511, 33257,489,489, 
512,512,512, 33281,513,513, 33258,490,490, 514,514,514, 33259,491,491, 515,515,515, 33260,492,492, 374,374,374, 33141,373,373, 
13, // chain 45
510,510,510, 511,511,511, 442,442,442, 
33209,441,441, 33280,512,512, 440,440,440, 33284,516,516, 33281,513,513, 517,517,517, 33282,514,514, 518,518,518, 33283,515,515, 386,386,386, 33142,374,374, 375,375,375, 
5, // chain 46
442,442,442, 443,443,443, 510,510,510, 
33277,509,509, 33287,519,519, 33188,420,420, 33187,419,419, 
13, // chain 47
335,335,335, 336,336,336, 520,520,520, 
334,334,334, 33289,521,521, 33290,522,522, 33291,523,523, 33104,336,336, 337,337,337, 524,524,524, 33106,338,338, 416,416,416, 33182,414,414, 33107,339,339, 340,340,340, 
12, // chain 48
521,521,521, 522,522,522, 525,525,525, 
526,526,526, 33295,527,527, 33296,528,528, 33206,438,438, 33290,522,522, 437,437,437, 33291,523,523, 524,524,524, 436,436,436, 33184,416,416, 417,417,417, 
6, // chain 49
529,529,529, 387,387,387, 388,388,388, 
526,526,526, 33157,389,389, 521,521,521, 33102,334,334, 33101,333,333, 
2, // chain 50
387,387,387, 529,529,529, 518,518,518, 
386,386,386, 
4, // chain 51
527,527,527, 528,528,528, 516,516,516, 
517,517,517, 529,529,529, 33286,518,518, 
28, // chain 52
530,530,530, 531,531,531, 532,532,532, 
533,533,533, 33302,534,534, 33303,535,535, 33304,536,536, 33299,531,531, 537,537,537, 33061,538,293, 33306,539,538, 33298,530,530, 539,540,539, 33308,541,540, 33301,533,533, 541,542,541, 33310,543,542, 33302,534,534, 543,544,543, 
33312,545,544, 33303,535,535, 545,546,545, 33314,547,546, 33304,536,536, 547,548,547, 33305,537,537, 548,549,548, 33317,550,549, 33062,551,294, 33061,538,293, 
29, // chain 53
550,552,550, 292,553,292, 538,539,538, 
539,540,539, 551,554,551, 33320,555,552, 33308,541,540, 553,556,553, 33309,542,541, 554,557,554, 33323,558,555, 33310,543,542, 556,559,556, 33311,544,543, 557,560,557, 33326,561,558, 33312,545,544, 559,562,559, 33313,546,545, 
560,563,560, 33329,564,561, 33314,547,546, 562,565,562, 33315,548,547, 563,566,563, 33316,549,548, 564,567,564, 33333,568,565, 33317,550,549, 295,569,295, 33062,551,294, 
39, // chain 54
291,570,291, 292,553,292, 550,552,550, 
566,571,566, 33319,554,551, 567,572,567, 33336,573,568, 33320,555,552, 569,574,569, 33321,556,553, 570,575,570, 33322,557,554, 571,576,571, 33340,577,572, 33323,558,555, 573,578,573, 33324,559,556, 574,579,574, 33325,560,557, 
575,580,575, 33344,581,576, 33326,561,558, 577,582,577, 33327,562,559, 578,583,578, 33328,563,560, 579,584,579, 33348,585,580, 33329,564,561, 581,586,581, 33330,565,562, 582,587,582, 33331,566,563, 583,588,583, 33352,589,584, 
33332,567,564, 585,590,585, 33354,591,586, 33333,568,565, 267,592,267, 33063,569,295, 
3, // chain 55
319,593,319, 291,570,291, 566,571,566, 
587,594,587, 33335,572,567, 
25, // chain 56
577,582,577, 578,583,578, 588,595,588, 
589,596,589, 33358,597,590, 33359,598,591, 33360,599,592, 33346,583,578, 579,584,579, 593,600,593, 33362,601,594, 33348,585,580, 595,602,595, 33349,586,581, 582,587,582, 596,603,596, 33351,588,583, 597,604,597, 33366,605,598, 
33352,589,584, 599,606,599, 33353,590,585, 600,607,600, 33369,608,601, 33354,591,586, 268,609,268, 33035,592,267, 
46, // chain 57
576,581,576, 577,582,577, 589,596,589, 
602,610,602, 33371,611,603, 33358,597,590, 604,612,604, 33373,613,605, 33359,598,591, 606,614,606, 33360,599,592, 593,600,593, 607,615,607, 33376,616,608, 33362,601,594, 609,617,609, 33363,602,595, 596,603,596, 610,618,610, 
33365,604,597, 611,619,611, 33380,620,612, 33366,605,598, 613,621,613, 33367,606,599, 614,622,614, 33368,607,600, 615,623,615, 33384,624,616, 33369,608,601, 617,625,617, 33036,609,268, 618,626,618, 619,627,619, 33388,628,620, 
621,629,621, 33390,630,622, 623,631,623, 33392,632,624, 625,633,625, 33394,634,626, 33395,635,627, 628,636,628, 33397,637,629, 630,638,630, 33399,639,631, 632,640,632, 33401,641,633, 
28, // chain 58
575,580,575, 576,581,576, 602,610,602, 
634,642,634, 33403,643,635, 33404,644,636, 33371,611,603, 604,612,604, 637,645,637, 33406,646,638, 33373,613,605, 639,647,639, 33374,614,606, 607,615,607, 640,648,640, 33409,649,641, 33410,650,642, 33376,616,608, 643,651,643, 
33377,617,609, 610,618,610, 644,652,644, 33379,619,611, 645,653,645, 33414,654,646, 33380,620,612, 647,655,647, 33381,621,613, 615,623,615, 33382,622,614, 
10, // chain 59
636,644,636, 648,656,648, 649,657,649, 
635,643,635, 33418,658,650, 33419,659,651, 33416,656,648, 652,660,652, 33421,661,653, 33422,662,654, 33405,645,637, 33404,644,636, 
40, // chain 60
654,662,654, 637,645,637, 638,646,638, 
655,663,655, 33407,647,639, 640,648,640, 656,664,656, 33409,649,641, 657,665,657, 33426,666,658, 33410,650,642, 659,667,659, 33411,651,643, 644,652,644, 660,668,660, 33413,653,645, 661,669,661, 33430,670,662, 33414,654,646, 
663,671,663, 33415,655,647, 664,672,664, 33383,623,615, 616,624,616, 665,673,665, 33385,625,617, 619,627,619, 666,674,666, 33389,629,621, 623,631,623, 667,675,667, 33436,676,668, 33393,633,625, 669,677,669, 33438,678,670, 
33394,634,626, 671,679,671, 33396,636,628, 672,680,672, 33398,638,630, 673,681,673, 33400,640,632, 
133, // chain 61
674,682,674, 675,683,675, 676,684,676, 
677,685,677, 33446,686,678, 33447,687,679, 33448,688,680, 33449,689,681, 33443,683,675, 682,690,682, 33451,691,683, 33452,692,684, 33442,682,674, 685,693,685, 33454,694,686, 33445,685,677, 687,695,687, 33456,696,688, 33457,697,689, 
33446,686,678, 679,687,679, 690,698,690, 33459,699,691, 33460,700,692, 33448,688,680, 693,701,693, 33462,702,694, 33449,689,681, 682,690,682, 695,703,695, 33464,704,696, 33465,705,697, 33451,691,683, 698,706,698, 33467,707,699, 
33452,692,684, 700,708,700, 33453,693,685, 701,709,701, 33470,710,702, 33454,694,686, 703,711,703, 33455,695,687, 704,712,704, 33456,696,688, 705,713,705, 33457,697,689, 706,714,706, 33475,715,707, 33458,698,690, 708,716,708, 
33459,699,691, 709,717,709, 33460,700,692, 710,718,710, 33461,701,693, 711,719,711, 33462,702,694, 695,703,695, 712,720,712, 33464,704,696, 713,721,713, 33482,722,714, 33465,705,697, 715,723,715, 33466,706,698, 716,724,716, 
33485,725,717, 33467,707,699, 718,726,718, 33468,708,700, 701,709,701, 719,727,719, 33488,728,720, 33470,710,702, 721,729,721, 33471,711,703, 722,730,722, 33491,731,723, 33472,712,704, 724,732,724, 33473,713,705, 725,733,725, 
33474,714,706, 707,715,707, 726,734,726, 33476,716,708, 727,735,727, 33477,717,709, 728,736,728, 33497,737,729, 33478,718,710, 730,738,730, 33479,719,711, 712,720,712, 731,739,731, 33481,721,713, 30,740,30, 32797,741,29, 
33482,722,714, 55,742,55, 33064,743,296, 33483,723,715, 716,724,716, 241,744,241, 33500,745,732, 33485,725,717, 733,746,733, 33486,726,718, 719,727,719, 734,747,734, 33503,748,735, 33488,728,720, 736,749,736, 33489,729,721, 
737,750,737, 33490,730,722, 738,751,738, 33507,752,739, 33491,731,723, 724,732,724, 740,753,740, 33493,733,725, 741,754,741, 33494,734,726, 727,735,727, 728,736,728, 742,755,742, 33511,756,743, 33497,737,729, 744,757,744, 
33498,738,730, 731,739,731, 33,758,33, 32798,740,30, 
133, // chain 62
745,759,745, 746,760,746, 747,761,747, 
748,762,748, 33517,763,749, 33518,764,750, 33519,765,751, 33520,766,752, 33514,760,746, 753,767,753, 33522,768,754, 33523,769,755, 33513,759,745, 756,770,756, 33525,771,757, 33516,762,748, 758,772,758, 33527,773,759, 33528,774,760, 
33529,775,761, 33517,763,749, 762,776,762, 33518,764,750, 763,777,763, 33532,778,764, 33519,765,751, 765,779,765, 33520,766,752, 766,780,766, 33521,767,753, 767,781,767, 33536,782,768, 33537,783,769, 33522,768,754, 770,784,770, 
33539,785,771, 33523,769,755, 756,770,756, 772,786,772, 33541,787,773, 33525,771,757, 774,788,774, 33526,772,758, 759,773,759, 775,789,775, 33544,790,776, 33528,774,760, 777,791,777, 33546,792,778, 33529,775,761, 779,793,779, 
33530,776,762, 780,794,780, 33531,777,763, 781,795,781, 33532,778,764, 782,796,782, 33533,779,765, 783,797,783, 33534,780,766, 767,781,767, 784,798,784, 33536,782,768, 785,799,785, 33554,800,786, 33537,783,769, 787,801,787, 
33538,784,770, 788,802,788, 33557,803,789, 33539,785,771, 772,786,772, 790,804,790, 33559,805,791, 33541,787,773, 792,806,792, 33542,788,774, 793,807,793, 33543,789,775, 794,808,794, 33563,809,795, 33544,790,776, 796,810,796, 
33545,791,777, 797,811,797, 33546,792,778, 798,812,798, 33547,793,779, 780,794,780, 799,813,799, 33549,795,781, 800,814,800, 33550,796,782, 801,815,801, 33551,797,783, 784,798,784, 802,816,802, 33553,799,785, 803,817,803, 
33572,818,804, 33554,800,786, 219,819,219, 32986,820,218, 33555,801,787, 788,802,788, 185,821,185, 33573,822,805, 33557,803,789, 790,804,790, 806,823,806, 33575,824,807, 33559,805,791, 808,825,808, 33560,806,792, 809,826,809, 
33561,807,793, 810,827,810, 33562,808,794, 811,828,811, 33580,829,812, 33563,809,795, 796,810,796, 813,830,813, 33565,811,797, 814,831,814, 33566,812,798, 799,813,799, 815,832,815, 33568,814,800, 816,833,816, 33585,834,817, 
33569,815,801, 802,816,802, 818,835,818, 33571,817,803, 
8, // chain 63
808,825,808, 353,836,353, 351,837,351, 
807,824,807, 32978,838,210, 806,823,806, 32964,839,196, 184,840,184, 805,822,805, 32953,821,185, 
13, // chain 64
353,836,353, 808,825,808, 809,826,809, 
810,827,810, 355,841,355, 32804,842,36, 33579,828,811, 37,843,37, 33587,844,819, 33580,829,812, 813,830,813, 820,845,820, 33582,831,814, 816,833,816, 33583,832,815, 
6, // chain 65
37,843,37, 819,844,819, 39,846,39, 
33588,845,820, 816,833,816, 41,847,41, 33586,835,818, 33585,834,817, 
20, // chain 66
234,848,234, 241,744,241, 732,745,732, 
821,849,821, 33501,746,733, 734,747,734, 233,850,233, 32827,851,59, 32836,852,68, 33503,748,735, 71,853,71, 33504,749,736, 95,854,95, 33505,750,737, 125,855,125, 33506,751,738, 127,856,127, 33590,857,822, 33507,752,739, 
740,753,740, 742,755,742, 33509,754,741, 
6, // chain 67
127,856,127, 822,857,822, 129,858,129, 
33510,755,742, 743,756,743, 131,859,131, 33512,757,744, 33,758,33, 
14, // chain 68
823,860,823, 824,861,824, 825,862,825, 
574,579,574, 33341,578,573, 33594,863,826, 33595,864,827, 33592,861,824, 828,865,828, 33597,866,829, 33598,867,830, 33599,868,831, 33591,860,823, 634,642,634, 33343,580,575, 33342,579,574, 
8, // chain 69
832,869,832, 833,870,833, 827,864,827, 
33594,863,826, 33602,871,834, 835,872,835, 33604,873,836, 837,874,837, 572,577,572, 33339,576,571, 
6, // chain 70
838,875,838, 839,876,839, 840,877,840, 
841,878,841, 33610,879,842, 33611,880,843, 33612,881,844, 33607,876,839, 
13, // chain 71
845,882,845, 839,876,839, 838,875,838, 
846,883,846, 33615,884,847, 33609,878,841, 848,885,848, 33617,886,849, 33610,879,842, 850,887,850, 33619,888,851, 33611,880,843, 852,889,852, 33604,890,836, 33612,881,844, 
7, // chain 72
851,888,851, 852,889,852, 853,891,853, 
854,892,854, 33623,893,855, 33624,894,856, 33620,889,852, 834,895,834, 33604,890,836, 
9, // chain 73
849,886,849, 857,896,857, 858,897,858, 
848,885,848, 33627,898,859, 33628,899,860, 33625,896,857, 861,900,861, 33630,901,862, 33618,887,850, 33617,886,849, 
9, // chain 74
850,887,850, 851,888,851, 854,892,854, 
862,901,862, 33631,902,863, 33623,893,855, 864,903,864, 33633,904,865, 33624,894,856, 833,905,833, 33602,895,834, 
6, // chain 75
847,884,847, 848,885,848, 866,906,866, 
867,907,867, 33636,908,868, 33637,909,869, 33627,898,859, 33616,885,848, 
25, // chain 76
870,910,870, 871,911,871, 872,912,872, 
873,913,873, 33642,914,874, 33643,915,875, 33644,916,876, 33639,911,871, 877,917,877, 33646,918,878, 33600,919,832, 33647,920,879, 33638,910,870, 864,903,864, 33648,921,880, 33641,913,873, 881,922,881, 33650,923,882, 33642,914,874, 
883,924,883, 33652,925,884, 33643,915,875, 885,926,885, 33654,927,886, 33644,916,876, 887,928,887, 33645,917,877, 
2, // chain 77
865,904,865, 832,919,832, 879,920,879, 
864,903,864, 
1, // chain 78
833,905,833, 832,919,832, 865,904,865, 
17, // chain 79
888,929,888, 880,921,880, 881,922,881, 
889,930,889, 33658,931,890, 33650,923,882, 891,932,891, 33651,924,883, 884,925,884, 892,933,892, 33653,926,885, 893,934,893, 33662,935,894, 33654,927,886, 895,936,895, 33655,928,887, 896,937,896, 897,938,897, 33666,939,898, 
2, // chain 80
880,921,880, 888,929,888, 863,902,863, 
864,903,864, 
10, // chain 81
890,931,890, 899,940,899, 900,941,900, 
889,930,889, 33669,942,901, 33670,943,902, 33671,944,903, 33667,940,899, 904,945,904, 33660,933,892, 33659,932,891, 33658,931,890, 
25, // chain 82
905,946,905, 906,947,906, 907,948,907, 
908,949,908, 33677,950,909, 33678,951,910, 33674,947,906, 911,952,911, 33680,953,912, 33670,943,902, 33673,946,905, 901,942,901, 33628,899,860, 33676,949,908, 859,898,859, 33637,909,869, 33677,950,909, 868,908,868, 33678,951,910, 
867,907,867, 33681,954,913, 33682,955,914, 33679,952,911, 915,956,915, 33680,953,912, 903,944,903, 33670,943,902, 
3, // chain 83
888,929,888, 889,930,889, 861,900,861, 
862,901,862, 863,902,863, 
91, // chain 84
916,957,916, 917,958,917, 918,959,918, 
919,960,919, 33688,961,920, 921,962,921, 33690,963,922, 923,964,923, 33692,965,924, 925,966,925, 33694,967,926, 927,968,927, 33696,969,928, 929,970,929, 33698,971,930, 931,972,931, 33700,973,932, 933,974,933, 33702,975,934, 
935,976,935, 33704,977,936, 937,978,937, 33706,979,938, 939,980,939, 33708,981,940, 941,982,941, 33710,983,942, 943,984,943, 33712,985,944, 945,986,945, 33714,987,946, 947,988,947, 33716,989,948, 949,990,949, 33718,991,950, 
951,992,951, 33720,993,952, 953,994,953, 33722,995,954, 955,996,955, 33724,997,956, 957,998,957, 33726,999,958, 959,1000,959, 33728,1001,960, 961,1002,961, 33730,1003,962, 963,1004,963, 33732,1005,964, 965,1006,965, 33734,1007,966, 
967,1008,967, 968,1009,968, 33737,1010,969, 970,1011,970, 33739,1012,971, 972,1013,972, 33741,1014,973, 974,1015,974, 33743,1016,975, 976,1017,976, 33745,1018,977, 978,1019,978, 33747,1020,979, 980,1021,980, 33749,1022,981, 982,1023,982, 
33751,1024,983, 984,1025,984, 33753,1026,985, 986,1027,986, 33755,1028,987, 33756,1029,988, 989,1030,989, 33758,1031,990, 991,1032,991, 33760,1033,992, 993,1034,993, 994,1035,994, 33763,1036,995, 996,1037,996, 33765,1038,997, 998,1039,998, 
33767,1040,999, 1000,1041,1000, 33769,1042,1001, 1002,1043,1002, 1003,1044,1003, 33772,1045,1004, 1005,1046,1005, 33774,1047,1006, 818,1048,818, 32809,41,41, 
2, // chain 85
917,958,917, 916,957,916, 426,426,426, 
427,427,427, 
4, // chain 86
919,960,919, 423,423,423, 424,424,424, 
916,957,916, 33193,425,425, 426,426,426, 
83, // chain 87
423,423,423, 919,960,919, 921,962,921, 
422,422,422, 33691,964,923, 1007,1049,1007, 33693,966,925, 1008,1050,1008, 33695,968,927, 1009,1051,1009, 33697,970,929, 1010,1052,1010, 33699,972,931, 1011,1053,1011, 33701,974,933, 1012,1054,1012, 33703,976,935, 1013,1055,1013, 33705,978,937, 
1014,1056,1014, 33707,980,939, 1015,1057,1015, 33709,982,941, 1016,1058,1016, 33711,984,943, 1017,1059,1017, 33713,986,945, 1018,1060,1018, 33715,988,947, 1019,1061,1019, 33717,990,949, 1020,1062,1020, 33719,992,951, 1021,1063,1021, 33721,994,953, 
1022,1064,1022, 33723,996,955, 1023,1065,1023, 33725,998,957, 1024,1066,1024, 33727,1000,959, 1025,1067,1025, 33729,1002,961, 1026,1068,1026, 33731,1004,963, 1027,1069,1027, 33733,1006,965, 968,1009,968, 1028,1070,1028, 33738,1011,970, 1029,1071,1029, 
33740,1013,972, 1030,1072,1030, 33742,1015,974, 1031,1073,1031, 33744,1017,976, 1032,1074,1032, 33746,1019,978, 1033,1075,1033, 33748,1021,980, 1034,1076,1034, 33750,1023,982, 1035,1077,1035, 33752,1025,984, 1036,1078,1036, 33754,1027,986, 224,224,224, 
32991,223,223, 33755,1028,987, 222,222,222, 33757,1030,989, 1037,1079,1037, 33759,1032,991, 994,1035,994, 1038,1080,1038, 33764,1037,996, 1039,1081,1039, 33766,1039,998, 1040,1082,1040, 33768,1041,1000, 1003,1044,1003, 1041,1083,1041, 33773,1046,1005, 
803,1084,803, 33586,1048,818, 
10, // chain 88
1012,1054,1012, 504,504,504, 505,505,505, 
1011,1053,1011, 33274,506,506, 1010,1052,1010, 33275,507,507, 1009,1051,1009, 33810,1085,1042, 33276,508,508, 519,519,519, 33277,509,509, 
48, // chain 89
504,504,504, 1012,1054,1012, 1013,1055,1013, 
503,503,503, 33782,1056,1014, 502,502,502, 33783,1057,1015, 1043,1086,1043, 33784,1058,1016, 1044,1087,1044, 33785,1059,1017, 1045,1088,1045, 33786,1060,1018, 1046,1089,1046, 33787,1061,1019, 1047,1090,1047, 33788,1062,1020, 1048,1091,1048, 33789,1063,1021, 
1049,1092,1049, 33790,1064,1022, 1050,1093,1050, 33791,1065,1023, 1051,1094,1051, 33792,1066,1024, 1052,1095,1052, 33793,1067,1025, 1053,1096,1053, 33794,1068,1026, 1054,1097,1054, 33795,1069,1027, 1028,1070,1028, 1055,1098,1055, 33797,1071,1029, 1056,1099,1056, 
33798,1072,1030, 1057,1100,1057, 33799,1073,1031, 1058,1101,1058, 33800,1074,1032, 1059,1102,1059, 33801,1075,1033, 1060,1103,1060, 33802,1076,1034, 1061,1104,1061, 33803,1077,1035, 1062,1105,1062, 33804,1078,1036, 225,225,225, 32992,224,224, 
46, // chain 90
501,501,501, 502,502,502, 1043,1086,1043, 
1063,1106,1063, 33812,1087,1044, 1045,1088,1045, 1064,1107,1064, 33833,1108,1065, 33814,1089,1046, 1066,1109,1066, 33815,1090,1047, 1067,1110,1067, 33816,1091,1048, 1068,1111,1068, 33817,1092,1049, 1069,1112,1069, 33818,1093,1050, 1070,1113,1070, 33819,1094,1051, 
1071,1114,1071, 33820,1095,1052, 1072,1115,1072, 33821,1096,1053, 1073,1116,1073, 33822,1097,1054, 1055,1098,1055, 1074,1117,1074, 33824,1099,1056, 1075,1118,1075, 33825,1100,1057, 1076,1119,1076, 33826,1101,1058, 1077,1120,1077, 33827,1102,1059, 1078,1121,1078, 
33828,1103,1060, 1079,1122,1079, 33829,1104,1061, 1080,1123,1080, 33830,1105,1062, 1081,1124,1081, 32993,225,225, 226,226,226, 1082,1125,1082, 32995,227,227, 1083,1126,1083, 32968,200,200, 32967,199,199, 
12, // chain 91
1084,1127,1084, 1085,1128,1085, 1086,1129,1086, 
1087,1130,1087, 33856,1131,1088, 1089,1132,1089, 33858,1133,1090, 1091,1134,1091, 151,151,151, 33860,1135,1092, 150,150,150, 33861,1136,1093, 149,149,149, 32916,148,148, 
11, // chain 92
1085,1128,1085, 1084,1127,1084, 1094,1137,1094, 
1095,1138,1095, 33864,1139,1096, 32923,155,155, 32922,154,154, 33852,1127,1084, 153,153,153, 33855,1130,1087, 152,152,152, 33857,1132,1089, 151,151,151, 
1, // chain 93
156,156,156, 1096,1139,1096, 155,155,155, 
6, // chain 94
1038,1080,1038, 1039,1081,1039, 220,220,220, 
33865,1140,1097, 33808,1082,1040, 1041,1083,1041, 804,1141,804, 33571,1084,803, 
7, // chain 95
420,420,420, 421,421,421, 1098,1142,1098, 
519,519,519, 33810,1085,1042, 33776,1050,1008, 33775,1049,1007, 33189,421,421, 422,422,422, 
1, // chain 96
1009,1051,1009, 1042,1085,1042, 1008,1050,1008, 
63, // chain 97
1099,1143,1099, 1100,1144,1100, 1101,1145,1101, 
1102,1146,1102, 33871,1147,1103, 33872,1148,1104, 33873,1149,1105, 33868,1144,1100, 1106,1150,1106, 33875,1151,1107, 33876,1152,1108, 33867,1143,1099, 1109,1153,1109, 33878,1154,1110, 33870,1146,1102, 1111,1155,1111, 33880,1156,1112, 33881,1157,1113, 33871,1147,1103, 
1114,1158,1114, 33883,1159,1115, 33884,1160,1116, 33872,1148,1104, 1117,1161,1117, 33886,1162,1118, 33887,1163,1119, 33873,1149,1105, 1120,1164,1120, 33874,1150,1106, 317,1165,317, 33118,1166,350, 33875,1151,1107, 413,1167,413, 33889,1168,1121, 33876,1152,1108, 
1122,1169,1122, 33877,1153,1109, 1123,1170,1123, 33892,1171,1124, 33878,1154,1110, 1125,1172,1125, 33879,1155,1111, 1126,1173,1126, 33895,1174,1127, 33880,1156,1112, 1128,1175,1128, 33881,1157,1113, 1129,1176,1129, 33882,1158,1114, 1130,1177,1130, 33883,1159,1115, 
1131,1178,1131, 33900,1179,1132, 33901,1180,1133, 33884,1160,1116, 1117,1161,1117, 569,1181,569, 33336,1182,568, 33886,1162,1118, 567,1183,567, 33887,1163,1119, 587,1184,587, 33888,1164,1120, 318,1185,318, 33085,1165,317, 
40, // chain 98
1134,1186,1134, 1135,1187,1135, 1136,1188,1136, 
1137,1189,1137, 33906,1190,1138, 33907,1191,1139, 33903,1187,1135, 1140,1192,1140, 33909,1193,1141, 33910,1194,1142, 33902,1186,1134, 1143,1195,1143, 33912,1196,1144, 33913,1197,1145, 33914,1198,1146, 33905,1189,1137, 1147,1199,1147, 33916,1200,1148, 33917,1201,1149, 
33906,1190,1138, 1150,1202,1150, 33919,1203,1151, 33907,1191,1139, 1152,1204,1152, 33908,1192,1140, 1153,1205,1153, 33922,1206,1154, 33909,1193,1141, 1155,1207,1155, 33924,1208,1156, 33910,1194,1142, 1157,1209,1157, 33911,1195,1143, 1158,1210,1158, 33927,1211,1159, 
33912,1196,1144, 1160,1212,1160, 33913,1197,1145, 1161,1213,1161, 33930,1214,1162, 33915,1199,1147, 33914,1198,1146, 
11, // chain 99
1151,1203,1151, 1163,1215,1163, 1164,1216,1164, 
1150,1202,1150, 33933,1217,1165, 33598,867,830, 33934,1218,1166, 33935,1219,1167, 33931,1215,1163, 1168,1220,1168, 33937,1221,1169, 33920,1204,1152, 33919,1203,1151, 
7, // chain 100
1149,1201,1149, 1150,1202,1150, 1170,1222,1170, 
1171,1223,1171, 33940,1224,1172, 33418,658,650, 33941,1225,1173, 33933,1217,1165, 33918,1202,1150, 
24, // chain 101
1174,1226,1174, 1175,1227,1175, 1176,1228,1176, 
1177,1229,1177, 33946,1230,1178, 33943,1227,1175, 1179,1231,1179, 33948,1232,1180, 33949,1233,1181, 33942,1226,1174, 1147,1199,1147, 33950,1234,1182, 33945,1229,1177, 1183,1235,1183, 33952,1236,1184, 33946,1230,1178, 1185,1237,1185, 33947,1231,1179, 1186,1238,1186, 
33955,1239,1187, 33948,1232,1180, 652,660,652, 33956,1240,1188, 33949,1233,1181, 1148,1200,1148, 33915,1199,1147, 
5, // chain 102
1148,1200,1148, 1149,1201,1149, 1171,1223,1171, 
1188,1240,1188, 33419,659,651, 33940,1224,1172, 650,658,650, 
5, // chain 103
1187,1239,1187, 652,660,652, 1189,1241,1189, 
1190,1242,1190, 33959,1243,1191, 33421,661,653, 33420,660,652, 
2, // chain 104
1037,1079,1037, 1038,1080,1038, 221,221,221, 
32988,220,220, 
36, // chain 105
657,665,657, 658,666,658, 1192,1244,1192, 
1186,1238,1186, 33953,1237,1185, 33961,1245,1193, 33962,1246,1194, 33426,666,658, 1195,1247,1195, 33964,1248,1196, 33427,667,659, 660,668,660, 1197,1249,1197, 33429,669,661, 1198,1250,1198, 33967,1251,1199, 33430,670,662, 1200,1252,1200, 33431,671,663, 
1201,1253,1201, 33432,672,664, 665,673,665, 666,674,666, 667,675,667, 1202,1254,1202, 33971,1255,1203, 33436,676,668, 1204,1256,1204, 33437,677,669, 1205,1257,1205, 33974,1258,1206, 33438,678,670, 1207,1259,1207, 33439,679,671, 1208,1260,1208, 
33440,680,672, 1209,1261,1209, 33441,681,673, 
7, // chain 106
1186,1238,1186, 1187,1239,1187, 1190,1242,1190, 
657,665,657, 33424,664,656, 33959,1243,1191, 655,663,655, 33422,662,654, 33421,661,653, 
2, // chain 107
570,1262,570, 1132,1179,1132, 1133,1180,1133, 
569,1181,569, 
5, // chain 108
1132,1179,1132, 570,1262,570, 571,1263,571, 
1210,1264,1210, 33605,1265,837, 844,1266,844, 33604,1267,836, 
7, // chain 109
1210,1264,1210, 839,1268,839, 1211,1269,1211, 
1132,1179,1132, 33899,1178,1131, 33980,1270,1212, 33981,1271,1213, 33613,1272,845, 33607,1268,839, 
1, // chain 110
844,1266,844, 839,1268,839, 1210,1264,1210, 
10, // chain 111
1212,1270,1212, 1214,1273,1214, 1215,1274,1215, 
1216,1275,1216, 33985,1276,1217, 33986,1277,1218, 33982,1273,1214, 1219,1278,1219, 33988,1279,1220, 33989,1280,1221, 33981,1271,1213, 33980,1270,1212, 
4, // chain 112
1129,1176,1129, 1130,1177,1130, 1222,1281,1222, 
33991,1282,1223, 33980,1270,1212, 33899,1178,1131, 
16, // chain 113
1223,1282,1223, 1212,1270,1212, 1216,1275,1216, 
1224,1283,1224, 33993,1284,1225, 33985,1276,1217, 1226,1285,1226, 33995,1286,1227, 33986,1277,1218, 1228,1287,1228, 33997,1288,1229, 33987,1278,1219, 1220,1279,1220, 1230,1289,1230, 1231,1290,1231, 34000,1291,1232, 1233,1292,1233, 34002,1293,1234, 
10, // chain 114
1167,1219,1167, 1235,1294,1235, 1236,1295,1236, 
1166,1218,1166, 34005,1296,1237, 34006,1297,1238, 34007,1298,1239, 34003,1294,1235, 1240,1299,1240, 34009,1300,1241, 33936,1220,1168, 33935,1219,1167, 
15, // chain 115
828,865,828, 829,866,829, 1238,1297,1238, 
878,1301,878, 34007,1298,1239, 877,1302,877, 34008,1299,1240, 887,1303,887, 34010,1304,1242, 34009,1300,1241, 1243,1305,1243, 34012,1306,1244, 33936,1220,1168, 1169,1221,1169, 1245,1307,1245, 33921,1205,1153, 33920,1204,1152, 
148, // chain 116
1246,1308,1246, 1247,1309,1247, 1248,1310,1248, 
1249,1311,1249, 34018,1312,1250, 34019,1313,1251, 34015,1309,1247, 1252,1314,1252, 34021,1315,1253, 34022,1316,1254, 34023,1317,1255, 34014,1308,1246, 1256,1318,1256, 34025,1319,1257, 34017,1311,1249, 1258,1320,1258, 34027,1321,1259, 34018,1312,1250, 1260,1322,1260, 
34029,1323,1261, 34019,1313,1251, 1262,1324,1262, 34020,1314,1252, 1263,1325,1263, 34032,1326,1264, 34021,1315,1253, 1265,1327,1265, 34022,1316,1254, 1266,1328,1266, 34035,1329,1267, 34036,1330,1268, 34023,1317,1255, 1256,1318,1256, 1269,1331,1269, 34038,1332,1270, 
34025,1319,1257, 1271,1333,1271, 34026,1320,1258, 1272,1334,1272, 34027,1321,1259, 1273,1335,1273, 34028,1322,1260, 1274,1336,1274, 34029,1323,1261, 1275,1337,1275, 34030,1324,1262, 1276,1338,1276, 34045,1339,1277, 34031,1325,1263, 1278,1340,1278, 34047,1341,1279, 
34032,1326,1264, 1280,1342,1280, 34033,1327,1265, 1281,1343,1281, 34034,1328,1266, 1282,1344,1282, 34051,1345,1283, 34035,1329,1267, 1284,1346,1284, 34036,1330,1268, 1269,1331,1269, 1285,1347,1285, 34054,1348,1286, 34038,1332,1270, 1287,1349,1287, 34039,1333,1271, 
1288,1350,1288, 34040,1334,1272, 1289,1351,1289, 34041,1335,1273, 1290,1352,1290, 34042,1336,1274, 1291,1353,1291, 34043,1337,1275, 1292,1354,1292, 34044,1338,1276, 1293,1355,1293, 34062,1356,1294, 34045,1339,1277, 1295,1357,1295, 34046,1340,1278, 1296,1358,1296, 
34065,1359,1297, 34047,1341,1279, 1298,1360,1298, 34048,1342,1280, 1299,1361,1299, 34049,1343,1281, 1300,1362,1300, 34069,1363,1301, 34050,1344,1282, 1302,1364,1302, 34071,1365,1303, 34051,1345,1283, 1304,1366,1304, 34052,1346,1284, 1285,1347,1285, 1305,1367,1305, 
34074,1368,1306, 34054,1348,1286, 1287,1349,1287, 1307,1369,1307, 34056,1350,1288, 1308,1370,1308, 34057,1351,1289, 1309,1371,1309, 34058,1352,1290, 1310,1372,1310, 34059,1353,1291, 1292,1354,1292, 1293,1355,1293, 1311,1373,1311, 34080,1374,1312, 34062,1356,1294, 
1313,1375,1313, 34063,1357,1295, 1314,1376,1314, 34064,1358,1296, 1315,1377,1315, 34084,1378,1316, 34085,1379,1317, 34065,1359,1297, 1318,1380,1318, 34066,1360,1298, 1319,1381,1319, 34067,1361,1299, 1320,1382,1320, 34068,1362,1300, 1321,1383,1321, 34090,1384,1322, 
34069,1363,1301, 1323,1385,1323, 34070,1364,1302, 1324,1386,1324, 34093,1387,1325, 34071,1365,1303, 1304,1366,1304, 1305,1367,1305, 1326,1388,1326, 34074,1368,1306, 1327,1389,1327, 34096,1390,1328, 34075,1369,1307, 1308,1370,1308, 1329,1391,1329, 34077,1371,1309, 
1330,1392,1330, 34079,1373,1311, 34078,1372,1310, 
10, // chain 117
1331,1393,1331, 1332,1394,1332, 1333,1395,1333, 
898,1396,898, 34102,1397,1334, 34103,1398,1335, 34104,1399,1336, 34100,1394,1332, 1337,1400,1337, 34106,1401,1338, 34107,1402,1339, 34099,1393,1331, 
16, // chain 118
1334,1397,1334, 1335,1398,1335, 1340,1403,1340, 
1341,1404,1341, 34110,1405,1342, 34084,1378,1316, 34083,1377,1315, 34103,1398,1335, 1314,1376,1314, 34104,1399,1336, 1313,1375,1313, 34105,1400,1337, 1312,1374,1312, 34111,1406,1343, 34106,1401,1338, 1344,1407,1344, 34113,1408,1345, 34107,1402,1339, 
12, // chain 119
1318,1380,1318, 1319,1381,1319, 1346,1409,1346, 
34115,1410,1347, 34116,1411,1348, 34088,1382,1320, 1349,1412,1349, 34089,1383,1321, 1350,1413,1350, 34119,1414,1351, 34090,1384,1322, 1352,1415,1352, 34092,1386,1324, 34091,1385,1323, 
27, // chain 120
1346,1409,1346, 1353,1416,1353, 1354,1417,1354, 
1318,1380,1318, 34085,1379,1317, 34084,1378,1316, 34123,1418,1355, 34124,1419,1356, 34121,1416,1353, 1357,1420,1357, 34126,1421,1358, 34127,1422,1359, 34114,1409,1346, 1347,1410,1347, 1360,1423,1360, 34116,1411,1348, 1361,1424,1361, 34117,1412,1349, 1362,1425,1362, 
34118,1413,1350, 1363,1426,1363, 34132,1427,1364, 34133,1428,1365, 34119,1414,1351, 1366,1429,1366, 34120,1415,1352, 1326,1388,1326, 34092,1386,1324, 1325,1387,1325, 
6, // chain 121
1367,1430,1367, 1368,1431,1368, 1369,1432,1369, 
1361,1424,1361, 34128,1423,1360, 34138,1433,1370, 34001,1434,1233, 34136,1431,1368, 
4, // chain 122
1371,1435,1371, 1368,1431,1368, 1367,1430,1367, 
1372,1436,1372, 34130,1425,1362, 34129,1424,1361, 
3, // chain 123
1358,1421,1358, 1359,1422,1359, 1370,1433,1370, 
1234,1437,1234, 34001,1434,1233, 
14, // chain 124
1373,1438,1373, 1374,1439,1374, 1375,1440,1375, 
1376,1441,1376, 1377,1442,1377, 34146,1443,1378, 1379,1444,1379, 34148,1445,1380, 34149,1446,1381, 1382,1447,1382, 34151,1448,1383, 1384,1449,1384, 1385,1450,1385, 34154,1451,1386, 1372,1436,1372, 34139,1435,1371, 
18, // chain 125
1374,1439,1374, 1373,1438,1373, 1387,1452,1387, 
1344,1407,1344, 34111,1406,1343, 34156,1453,1388, 34157,1454,1389, 34141,1438,1373, 1377,1442,1377, 1390,1455,1390, 34159,1456,1391, 34147,1444,1379, 1392,1457,1392, 34148,1445,1380, 1393,1458,1393, 34150,1447,1382, 1385,1450,1385, 1363,1426,1363, 34140,1436,1372, 
1362,1425,1362, 
18, // chain 126
1394,1459,1394, 1395,1460,1395, 1396,1461,1396, 
1397,1462,1397, 34166,1463,1398, 34158,1455,1390, 34157,1454,1389, 34163,1460,1395, 1388,1453,1388, 34167,1464,1399, 34098,1392,1330, 34162,1459,1394, 1329,1391,1329, 34168,1465,1400, 34165,1462,1397, 1401,1466,1401, 34166,1463,1398, 1402,1467,1402, 34159,1456,1391, 
34158,1455,1390, 
4, // chain 127
1388,1453,1388, 1399,1464,1399, 1343,1406,1343, 
34080,1374,1312, 34079,1373,1311, 34098,1392,1330, 
4, // chain 128
1402,1467,1402, 1391,1456,1391, 1392,1457,1392, 
1393,1458,1393, 1364,1427,1364, 34131,1426,1363, 
6, // chain 129
1402,1467,1402, 1364,1427,1364, 1401,1466,1401, 
34133,1428,1365, 1403,1468,1403, 34134,1429,1366, 1327,1389,1327, 34094,1388,1326, 
4, // chain 130
1404,1469,1404, 897,1470,897, 1405,1471,1405, 
34109,1404,1341, 34102,1397,1334, 33666,1396,898, 
8, // chain 131
1342,1405,1342, 1316,1378,1316, 1355,1418,1355, 
1406,1472,1406, 34124,1419,1356, 1357,1420,1357, 1407,1473,1407, 34176,1474,1408, 34002,1437,1234, 34126,1421,1358, 
5, // chain 132
1407,1473,1407, 1408,1474,1408, 1409,1475,1409, 
1410,1476,1410, 34179,1477,1411, 1412,1478,1412, 34181,1479,1413, 
5, // chain 133
1410,1476,1410, 1404,1469,1404, 1405,1471,1405, 
1407,1473,1407, 34174,1472,1406, 34110,1405,1342, 34109,1404,1341, 
1, // chain 134
1412,1478,1412, 1404,1469,1404, 1410,1476,1410, 
2, // chain 135
894,935,894, 895,936,895, 1404,1480,1404, 
33665,938,897, 
12, // chain 136
893,934,893, 1414,1481,1414, 1415,1482,1415, 
904,945,904, 33683,956,915, 33682,955,914, 34182,1481,1414, 1416,1483,1416, 34181,1484,1413, 34185,1485,1417, 33661,934,893, 894,935,894, 1412,1486,1412, 34172,1480,1404, 
7, // chain 137
1232,1487,1232, 1230,1488,1230, 1418,1489,1418, 
34187,1490,1419, 33988,1491,1220, 1420,1492,1420, 33989,1493,1221, 846,883,846, 33613,882,845, 
3, // chain 138
1418,1489,1418, 1409,1494,1409, 1408,1495,1408, 
1232,1487,1232, 34002,1496,1234, 
6, // chain 139
1409,1494,1409, 1418,1489,1418, 1421,1497,1421, 
1411,1498,1411, 34184,1483,1416, 33681,954,913, 34187,1490,1419, 34186,1489,1418, 
2, // chain 140
1420,1492,1420, 846,883,846, 867,907,867, 
33615,884,847, 
24, // chain 141
1422,1499,1422, 1423,1500,1423, 1424,1501,1424, 
1425,1502,1425, 34194,1503,1426, 34195,1504,1427, 34191,1500,1423, 1384,1505,1384, 34154,1506,1386, 34196,1507,1428, 34190,1499,1422, 1429,1508,1429, 33996,1287,1228, 33995,1286,1227, 34198,1509,1430, 34193,1502,1425, 1431,1510,1431, 34200,1511,1432, 34201,1512,1433, 
34194,1503,1426, 1434,1513,1434, 34203,1514,1435, 34204,1515,1436, 34195,1504,1427, 1383,1516,1383, 34152,1505,1384, 
3, // chain 142
1368,1517,1368, 1371,1518,1371, 1429,1508,1429, 
34196,1507,1428, 34154,1506,1386, 
19, // chain 143
1226,1285,1226, 1227,1286,1227, 1437,1519,1437, 
34198,1509,1430, 1431,1510,1431, 1438,1520,1438, 34200,1511,1432, 1439,1521,1439, 34208,1522,1440, 34201,1512,1433, 1434,1513,1434, 1441,1523,1441, 34210,1524,1442, 34203,1514,1435, 1443,1525,1443, 34204,1515,1436, 1444,1526,1444, 34151,1516,1383, 1381,1527,1381, 
1445,1528,1445, 34146,1529,1378, 
4, // chain 144
1233,1292,1233, 1368,1517,1368, 1231,1290,1231, 
34197,1508,1429, 1229,1288,1229, 33996,1287,1228, 
7, // chain 145
1446,1530,1446, 1447,1531,1447, 1448,1532,1448, 
1449,1533,1449, 34218,1534,1450, 34219,1535,1451, 34220,1536,1452, 34213,1537,1445, 34215,1531,1447, 
16, // chain 146
1453,1538,1453, 1447,1531,1447, 1446,1530,1446, 
1454,1539,1454, 34223,1540,1455, 34217,1533,1449, 1456,1541,1456, 34225,1542,1457, 34218,1534,1450, 1458,1543,1458, 34227,1544,1459, 34219,1535,1451, 1460,1545,1460, 34143,1546,1375, 34220,1536,1452, 1376,1547,1376, 34213,1537,1445, 1378,1548,1378, 
10, // chain 147
1459,1544,1459, 1461,1549,1461, 1462,1550,1462, 
1463,1551,1463, 34013,1307,1245, 34232,1552,1464, 34233,1553,1465, 34229,1549,1461, 1345,1554,1345, 34234,1555,1466, 34228,1545,1460, 34227,1544,1459, 
2, // chain 148
1460,1545,1460, 1375,1546,1375, 1374,1556,1374, 
1466,1555,1466, 
2, // chain 149
1463,1551,1463, 1154,1206,1154, 1458,1543,1458, 
1459,1544,1459, 
2, // chain 150
1153,1205,1153, 1154,1206,1154, 1463,1551,1463, 
1245,1307,1245, 
21, // chain 151
1154,1206,1154, 1155,1207,1155, 1458,1543,1458, 
34225,1542,1457, 34235,1557,1467, 33924,1208,1156, 1468,1558,1468, 33925,1209,1157, 1469,1559,1469, 33926,1210,1158, 1470,1560,1470, 34239,1561,1471, 33927,1211,1159, 1472,1562,1472, 33928,1212,1160, 1473,1563,1473, 33929,1213,1161, 1474,1564,1474, 34243,1565,1475, 
33930,1214,1162, 1476,1566,1476, 33950,1234,1182, 33915,1199,1147, 
2, // chain 152
1443,1525,1443, 1444,1526,1444, 1447,1567,1447, 
34213,1528,1445, 
12, // chain 153
1447,1567,1447, 1453,1568,1453, 1443,1525,1443, 
34210,1524,1442, 34209,1523,1441, 34245,1569,1477, 1478,1570,1478, 1479,1571,1479, 34248,1572,1480, 34249,1573,1481, 1482,1574,1482, 34251,1575,1483, 1484,1576,1484, 34253,1577,1485, 
10, // chain 154
1244,1306,1244, 1245,1307,1245, 1464,1552,1464, 
1243,1305,1243, 34254,1578,1486, 34233,1553,1465, 1345,1554,1345, 1339,1579,1339, 1487,1580,1487, 34099,1581,1331, 896,1582,896, 33666,1583,898, 
3, // chain 155
1487,1580,1487, 887,1303,887, 1242,1304,1242, 
1486,1578,1486, 34011,1305,1243, 
1, // chain 156
896,1582,896, 887,1303,887, 1487,1580,1487, 
4, // chain 157
1328,1390,1328, 1329,1391,1329, 1400,1465,1400, 
1327,1389,1327, 34171,1468,1403, 34169,1466,1401, 
7, // chain 158
1488,1584,1488, 46,1585,46, 1489,1586,1489, 
1490,1587,1490, 34259,1588,1491, 34260,1589,1492, 34261,1590,1493, 32808,1591,40, 32814,1585,46, 
73, // chain 159
58,1592,58, 46,1585,46, 1488,1584,1488, 
1494,1593,1494, 34263,1594,1495, 34258,1587,1490, 1496,1595,1496, 34265,1596,1497, 34259,1588,1491, 1498,1597,1498, 34267,1598,1499, 34260,1589,1492, 1500,1599,1500, 34269,1600,1501, 34261,1590,1493, 1502,1601,1502, 32808,1591,40, 41,1602,41, 1503,1603,1503, 
33774,1604,1006, 1504,1605,1504, 33772,1606,1004, 1505,1607,1505, 33770,1608,1002, 1506,1609,1506, 33769,1610,1001, 1507,1611,1507, 1508,1612,1508, 34277,1613,1509, 1510,1614,1510, 34279,1615,1511, 1512,1616,1512, 34281,1617,1513, 1514,1618,1514, 34283,1619,1515, 
1516,1620,1516, 34285,1621,1517, 34286,1622,1518, 1519,1623,1519, 34288,1624,1520, 1521,1625,1521, 34290,1626,1522, 1523,1627,1523, 34292,1628,1524, 1525,1629,1525, 1526,1630,1526, 34295,1631,1527, 1528,1632,1528, 34297,1633,1529, 34298,1634,1530, 1531,1635,1531, 
34300,1636,1532, 1533,1637,1533, 34302,1638,1534, 1535,1639,1535, 34304,1640,1536, 1537,1641,1537, 33863,1642,1095, 1096,1643,1096, 1538,1644,1538, 32924,1645,156, 1539,1646,1539, 32898,1647,130, 1540,1648,1540, 32899,1649,131, 1541,1650,1541, 32802,1651,34, 
1542,1652,1542, 34311,1653,1543, 32800,1654,32, 1544,1655,1544, 32786,1656,18, 57,1657,57, 1494,1593,1494, 32826,1592,58, 
133, // chain 160
1498,1597,1498, 1499,1598,1499, 1545,1658,1545, 
34314,1659,1546, 34315,1660,1547, 34268,1599,1500, 1548,1661,1548, 34317,1662,1549, 34269,1600,1501, 1550,1663,1550, 34270,1601,1502, 1503,1603,1503, 1551,1664,1551, 34272,1605,1504, 1552,1665,1552, 34273,1607,1505, 1553,1666,1553, 34274,1609,1506, 1508,1612,1508, 
1554,1667,1554, 34278,1614,1510, 1555,1668,1555, 34280,1616,1512, 1556,1669,1556, 34282,1618,1514, 1557,1670,1557, 34284,1620,1516, 1558,1671,1558, 34285,1621,1517, 1559,1672,1559, 34328,1673,1560, 34287,1623,1519, 1561,1674,1561, 34289,1625,1521, 1562,1675,1562, 
34291,1627,1523, 1526,1630,1526, 1563,1676,1563, 34296,1632,1528, 1564,1677,1564, 34333,1678,1565, 34297,1633,1529, 1566,1679,1566, 34299,1635,1531, 1567,1680,1567, 34301,1637,1533, 1568,1681,1568, 34303,1639,1535, 1569,1682,1569, 34305,1641,1537, 1538,1644,1538, 
1570,1683,1570, 34307,1646,1539, 1571,1684,1571, 34308,1648,1540, 1572,1685,1572, 34309,1650,1541, 1573,1686,1573, 34310,1652,1542, 1574,1687,1574, 34343,1688,1575, 34311,1653,1543, 1576,1689,1576, 34312,1655,1544, 1494,1593,1494, 1495,1594,1495, 1496,1595,1496, 
1577,1690,1577, 34346,1691,1578, 34265,1596,1497, 1579,1692,1579, 34266,1597,1498, 1545,1658,1545, 1580,1693,1580, 34349,1694,1581, 34314,1659,1546, 1582,1695,1582, 34315,1660,1547, 1548,1661,1548, 1583,1696,1583, 34352,1697,1584, 34317,1662,1549, 1585,1698,1585, 
34318,1663,1550, 1551,1664,1551, 1586,1699,1586, 34320,1665,1552, 1587,1700,1587, 34321,1666,1553, 1554,1667,1554, 1588,1701,1588, 34323,1668,1555, 1589,1702,1589, 34324,1669,1556, 1590,1703,1590, 34325,1670,1557, 1591,1704,1591, 34326,1671,1558, 1592,1705,1592, 
34327,1672,1559, 1593,1706,1593, 34362,1707,1594, 34328,1673,1560, 1595,1708,1595, 34329,1674,1561, 1562,1675,1562, 1596,1709,1596, 34331,1676,1563, 1597,1710,1597, 34332,1677,1564, 1598,1711,1598, 34367,1712,1599, 34333,1678,1565, 1600,1713,1600, 34334,1679,1566, 
1601,1714,1601, 34335,1680,1567, 1602,1715,1602, 34336,1681,1568, 1603,1716,1603, 34337,1682,1569, 1570,1683,1570, 1604,1717,1604, 34339,1684,1571, 1605,1718,1605, 34340,1685,1572, 1606,1719,1606, 34341,1686,1573, 1607,1720,1607, 34342,1687,1574, 1608,1721,1608, 
34377,1722,1609, 34343,1688,1575, 1577,1690,1577, 34344,1689,1576, 
117, // chain 161
1584,1697,1584, 1585,1698,1585, 1610,1723,1610, 
34354,1699,1586, 1611,1724,1611, 34355,1700,1587, 1588,1701,1588, 1612,1725,1612, 34357,1702,1589, 1613,1726,1613, 34358,1703,1590, 1614,1727,1614, 34359,1704,1591, 1615,1728,1615, 34360,1705,1592, 1616,1729,1616, 34385,1730,1617, 34361,1706,1593, 1618,1731,1618, 
34362,1707,1594, 1619,1732,1619, 34363,1708,1595, 1596,1709,1596, 1620,1733,1620, 34365,1710,1597, 1621,1734,1621, 34366,1711,1598, 1622,1735,1622, 34391,1736,1623, 34367,1712,1599, 1624,1737,1624, 34368,1713,1600, 1625,1738,1625, 34369,1714,1601, 1626,1739,1626, 
34370,1715,1602, 1627,1740,1627, 34371,1716,1603, 1604,1717,1604, 1628,1741,1628, 34373,1718,1605, 1629,1742,1629, 34374,1719,1606, 1630,1743,1630, 34375,1720,1607, 1631,1744,1631, 34376,1721,1608, 1632,1745,1632, 34401,1746,1633, 34377,1722,1609, 1634,1747,1634, 
34345,1690,1577, 1578,1691,1578, 1635,1748,1635, 34347,1692,1579, 1580,1693,1580, 1636,1749,1636, 34405,1750,1637, 34349,1694,1581, 1638,1751,1638, 34350,1695,1582, 1583,1696,1583, 1639,1752,1639, 34408,1753,1640, 34352,1697,1584, 1610,1723,1610, 1641,1754,1641, 
34379,1724,1611, 1612,1725,1612, 1642,1755,1642, 34381,1726,1613, 1643,1756,1643, 34382,1727,1614, 1644,1757,1644, 34383,1728,1615, 1616,1729,1616, 1645,1758,1645, 34385,1730,1617, 1646,1759,1646, 34386,1731,1618, 1647,1760,1647, 34387,1732,1619, 1620,1733,1620, 
1648,1761,1648, 34389,1734,1621, 1649,1762,1649, 34390,1735,1622, 1650,1763,1650, 34391,1736,1623, 1624,1737,1624, 1651,1764,1651, 34393,1738,1625, 1652,1765,1652, 34394,1739,1626, 1653,1766,1653, 34395,1740,1627, 1628,1741,1628, 1654,1767,1654, 34397,1742,1629, 
1655,1768,1655, 34398,1743,1630, 1656,1769,1656, 34399,1744,1631, 1632,1745,1632, 1657,1770,1657, 34401,1746,1633, 1658,1771,1658, 34402,1747,1634, 1635,1748,1635, 1636,1749,1636, 1659,1772,1659, 34428,1773,1660, 34405,1750,1637, 1661,1774,1661, 34406,1751,1638, 
1639,1752,1639, 1662,1775,1662, 34409,1754,1641, 34408,1753,1640, 
35, // chain 162
1661,1774,1661, 1662,1775,1662, 1663,1776,1663, 
1660,1773,1660, 34432,1777,1664, 34433,1778,1665, 34434,1779,1666, 34435,1780,1667, 34430,1775,1662, 1641,1754,1641, 1642,1755,1642, 1643,1756,1643, 1668,1781,1668, 34412,1757,1644, 1645,1758,1645, 1669,1782,1669, 34414,1759,1646, 1670,1783,1670, 34415,1760,1647, 
1648,1761,1648, 1671,1784,1671, 34417,1762,1649, 1672,1785,1672, 34418,1763,1650, 1651,1764,1651, 1673,1786,1673, 34420,1765,1652, 1674,1787,1674, 34421,1766,1653, 1654,1767,1654, 1675,1788,1675, 34423,1768,1655, 1676,1789,1676, 34424,1769,1656, 1657,1770,1657, 
1659,1772,1659, 34426,1771,1658, 
5, // chain 163
1677,1790,1677, 1675,1788,1675, 1678,1791,1678, 
1660,1773,1660, 34427,1772,1659, 34444,1789,1676, 34443,1788,1675, 
5, // chain 164
1674,1787,1674, 1675,1788,1675, 1677,1790,1677, 
1679,1792,1679, 34433,1778,1665, 34432,1777,1664, 34428,1773,1660, 
48, // chain 165
1680,1793,1680, 1681,1794,1681, 1682,1795,1682, 
1683,1796,1683, 34452,1797,1684, 34453,1798,1685, 34454,1799,1686, 34449,1794,1681, 1687,1800,1687, 34456,1801,1688, 34457,1802,1689, 34448,1793,1680, 1690,1803,1690, 34459,1804,1691, 34451,1796,1683, 1692,1805,1692, 34461,1806,1693, 34452,1797,1684, 1694,1807,1694, 
34453,1798,1685, 1695,1808,1695, 33835,1110,1067, 34454,1799,1686, 1066,1109,1066, 34455,1800,1687, 1065,1108,1065, 34464,1809,1696, 34456,1801,1688, 497,497,497, 33264,496,496, 34465,1810,1697, 34457,1802,1689, 1698,1811,1698, 34458,1803,1690, 1699,1812,1699, 
34468,1813,1700, 34469,1814,1701, 34459,1804,1691, 1702,1815,1702, 34460,1805,1692, 1080,1123,1080, 33847,1122,1079, 34461,1806,1693, 1703,1816,1703, 34472,1817,1704, 34462,1807,1694, 1695,1808,1695, 1705,1818,1705, 33836,1111,1068, 33835,1110,1067, 
7, // chain 166
1706,1819,1706, 1700,1813,1700, 1707,1820,1707, 
494,494,494, 34476,1821,1708, 33138,370,370, 33851,1126,1083, 34469,1814,1701, 34468,1813,1700, 
4, // chain 167
1699,1812,1699, 1700,1813,1700, 1706,1819,1706, 
496,496,496, 33263,495,495, 33262,494,494, 
3, // chain 168
1702,1815,1702, 1081,1124,1081, 1082,1125,1082, 
1701,1814,1701, 33851,1126,1083, 
1, // chain 169
1080,1123,1080, 1081,1124,1081, 1702,1815,1702, 
3, // chain 170
1708,1821,1708, 370,370,370, 371,371,371, 
493,493,493, 33140,372,372, 
2, // chain 171
1699,1812,1699, 496,496,496, 1697,1810,1697, 
1698,1811,1698, 
4, // chain 172
1064,1107,1064, 1065,1108,1065, 499,499,499, 
34464,1809,1696, 498,498,498, 33265,497,497, 
9, // chain 173
1709,1822,1709, 1703,1816,1703, 1704,1817,1704, 
1705,1818,1705, 1710,1823,1710, 33836,1111,1068, 1069,1112,1069, 1711,1824,1711, 33838,1113,1070, 1072,1115,1072, 33839,1114,1071, 
11, // chain 174
1703,1816,1703, 1709,1822,1709, 1712,1825,1712, 
1079,1122,1079, 33846,1121,1078, 34481,1826,1713, 34482,1827,1714, 34477,1822,1709, 1710,1823,1710, 1715,1828,1715, 34479,1824,1711, 1073,1116,1073, 33840,1115,1072, 
4, // chain 175
1077,1120,1077, 1078,1121,1078, 1713,1826,1713, 
1716,1829,1716, 34483,1828,1715, 34482,1827,1714, 
4, // chain 176
1076,1119,1076, 1077,1120,1077, 1716,1829,1716, 
1074,1117,1074, 33841,1116,1073, 34483,1828,1715, 
40, // chain 177
1717,1830,1717, 1718,1831,1718, 1719,1832,1719, 
1720,1833,1720, 34489,1834,1721, 34490,1835,1722, 34491,1836,1723, 34486,1831,1718, 1724,1837,1724, 34493,1838,1725, 34494,1839,1726, 34485,1830,1717, 1727,1840,1727, 34496,1841,1728, 34488,1833,1720, 1729,1842,1729, 34498,1843,1730, 34489,1834,1721, 1731,1844,1731, 
34500,1845,1732, 34501,1846,1733, 34490,1835,1722, 1734,1847,1734, 34503,1848,1735, 34491,1836,1723, 1736,1849,1736, 34492,1837,1724, 1737,1850,1737, 34506,1851,1738, 34493,1838,1725, 1739,1852,1739, 34508,1853,1740, 34494,1839,1726, 1727,1840,1727, 1741,1854,1741, 
34510,1855,1742, 34496,1841,1728, 1743,1856,1743, 34497,1842,1729, 1744,1857,1744, 34513,1858,1745, 34498,1843,1730, 
14, // chain 178
1527,1859,1527, 1525,1860,1525, 1744,1857,1744, 
34511,1856,1743, 34292,1861,1524, 1742,1855,1742, 34514,1862,1746, 34290,1863,1522, 1747,1864,1747, 34288,1865,1520, 1748,1866,1748, 34286,1867,1518, 1749,1868,1749, 34283,1869,1515, 1750,1870,1750, 34281,1871,1513, 
3, // chain 179
1744,1857,1744, 1745,1858,1745, 1751,1872,1751, 
1527,1859,1527, 34298,1873,1530, 
9, // chain 180
1741,1854,1741, 1742,1855,1742, 1746,1862,1746, 
1752,1874,1752, 34515,1864,1747, 1753,1875,1753, 34516,1866,1748, 1754,1876,1754, 34517,1868,1749, 1755,1877,1755, 34518,1870,1750, 
7, // chain 181
1756,1878,1756, 1741,1854,1741, 1752,1874,1752, 
1757,1879,1757, 34521,1875,1753, 1758,1880,1758, 34522,1876,1754, 1759,1881,1759, 34523,1877,1755, 
34, // chain 182
1740,1853,1740, 1741,1854,1741, 1756,1878,1756, 
1739,1852,1739, 34528,1882,1760, 34525,1879,1757, 1761,1883,1761, 34526,1880,1758, 1759,1881,1759, 1762,1884,1762, 1763,1885,1763, 34532,1886,1764, 1765,1887,1765, 34534,1888,1766, 1767,1889,1767, 34536,1890,1768, 1769,1891,1769, 34538,1892,1770, 1771,1893,1771, 
34540,1894,1772, 1773,1895,1773, 34542,1896,1774, 34543,1897,1775, 1776,1898,1776, 34545,1899,1777, 1778,1900,1778, 34547,1901,1779, 1780,1902,1780, 34549,1903,1781, 34550,1904,1782, 1783,1905,1783, 34552,1906,1784, 1785,1907,1785, 34554,1908,1786, 1511,1909,1511, 
34281,1871,1513, 
32, // chain 183
1787,1910,1787, 1788,1911,1788, 1789,1912,1789, 
1790,1913,1790, 34559,1914,1791, 34560,1915,1792, 34561,1916,1793, 34556,1911,1788, 1794,1917,1794, 34563,1918,1795, 34564,1919,1796, 34555,1910,1787, 1797,1920,1797, 34566,1921,1798, 34558,1913,1790, 1799,1922,1799, 34568,1923,1800, 34559,1914,1791, 1801,1924,1801, 
34570,1925,1802, 34560,1915,1792, 1803,1926,1803, 34561,1916,1793, 1804,1927,1804, 34573,1928,1805, 34562,1917,1794, 1806,1929,1806, 34575,1930,1807, 34563,1918,1795, 1808,1931,1808, 34577,1932,1809, 34564,1919,1796, 1810,1933,1810, 34565,1920,1797, 
30, // chain 184
1811,1934,1811, 1797,1920,1797, 1798,1921,1798, 
1812,1935,1812, 34567,1922,1799, 1813,1936,1813, 34582,1937,1814, 34568,1923,1800, 1815,1938,1815, 34569,1924,1801, 1816,1939,1816, 34585,1940,1817, 34570,1925,1802, 1818,1941,1818, 34571,1926,1803, 1819,1942,1819, 34572,1927,1804, 1820,1943,1820, 34573,1928,1805, 
1821,1944,1821, 34590,1945,1822, 34574,1929,1806, 1823,1946,1823, 34592,1947,1824, 34575,1930,1807, 1825,1948,1825, 34576,1931,1808, 1826,1949,1826, 34595,1950,1827, 34577,1932,1809, 1828,1951,1828, 34578,1933,1810, 
38, // chain 185
1829,1952,1829, 1811,1934,1811, 1812,1935,1812, 
1830,1953,1830, 34581,1936,1813, 1831,1954,1831, 34600,1955,1832, 34582,1937,1814, 1833,1956,1833, 34583,1938,1815, 1834,1957,1834, 34584,1939,1816, 1835,1958,1835, 34604,1959,1836, 34585,1940,1817, 1837,1960,1837, 34586,1941,1818, 1838,1961,1838, 34587,1942,1819, 
1839,1962,1839, 34588,1943,1820, 1840,1963,1840, 34589,1944,1821, 1841,1964,1841, 34610,1965,1842, 34590,1945,1822, 1843,1966,1843, 34591,1946,1823, 1844,1967,1844, 34613,1968,1845, 34592,1947,1824, 1846,1969,1846, 34593,1948,1825, 1847,1970,1847, 34594,1949,1826, 
1848,1971,1848, 34617,1972,1849, 34595,1950,1827, 1850,1973,1850, 34596,1951,1828, 
13, // chain 186
1851,1974,1851, 1852,1975,1852, 1853,1976,1853, 
1839,1962,1839, 34606,1961,1838, 34622,1977,1854, 34623,1978,1855, 34620,1975,1852, 1856,1979,1856, 34625,1980,1857, 34626,1981,1858, 34619,1974,1851, 1859,1982,1859, 34608,1963,1840, 34607,1962,1839, 
3, // chain 187
1836,1959,1836, 1837,1960,1837, 1860,1983,1860, 
34622,1977,1854, 34606,1961,1838, 
20, // chain 188
1771,1893,1771, 1773,1895,1773, 1861,1984,1861, 
34630,1985,1862, 34542,1896,1774, 1863,1986,1863, 34632,1987,1864, 34544,1898,1776, 1865,1988,1865, 34546,1900,1778, 1866,1989,1866, 34635,1990,1867, 34548,1902,1780, 1868,1991,1868, 34637,1992,1869, 34549,1903,1781, 1870,1993,1870, 34551,1905,1783, 1871,1994,1871, 
34553,1907,1785, 1509,1995,1509, 34279,1909,1511, 
29, // chain 189
1872,1996,1872, 1873,1997,1873, 1874,1998,1874, 
1864,1987,1864, 34631,1986,1863, 34643,1999,1875, 34644,2000,1876, 34641,1997,1873, 1877,2001,1877, 34646,2002,1878, 34647,2003,1879, 34640,1996,1872, 1880,2004,1880, 34632,1987,1864, 1865,1988,1865, 1881,2005,1881, 34634,1989,1866, 1882,2006,1882, 34651,2007,1883, 
34635,1990,1867, 1884,2008,1884, 34636,1991,1868, 1885,2009,1885, 34654,2010,1886, 34637,1992,1869, 1887,2011,1887, 34638,1993,1870, 1888,2012,1888, 34639,1994,1871, 1507,2013,1507, 34277,1995,1509, 
3, // chain 190
1861,1984,1861, 1862,1985,1862, 1889,2014,1889, 
34643,1999,1875, 34631,1986,1863, 
65, // chain 191
1848,1971,1848, 1849,1972,1849, 1732,1845,1732, 
1890,2015,1890, 34501,1846,1733, 1734,1847,1734, 1891,2016,1891, 34660,2017,1892, 34503,1848,1735, 1893,2018,1893, 34504,1849,1736, 1894,2019,1894, 34505,1850,1737, 1895,2020,1895, 34664,2021,1896, 34506,1851,1738, 1739,1852,1739, 1760,1882,1760, 1897,2022,1897, 
34529,1883,1761, 1763,1885,1763, 1898,2023,1898, 34667,2024,1899, 34533,1887,1765, 1900,2025,1900, 34535,1889,1767, 1901,2026,1901, 34537,1891,1769, 1902,2027,1902, 34539,1893,1771, 1861,1984,1861, 1903,2028,1903, 34657,2014,1889, 1904,2029,1904, 34673,2030,1905, 
34643,1999,1875, 1876,2000,1876, 1906,2031,1906, 34645,2001,1877, 1907,2032,1907, 34676,2033,1908, 34646,2002,1878, 1909,2034,1909, 34678,2035,1910, 34647,2003,1879, 1911,2036,1911, 34648,2004,1880, 1912,2037,1912, 34649,2005,1881, 1913,2038,1913, 34650,2006,1882, 
1914,2039,1914, 34683,2040,1915, 34651,2007,1883, 1916,2041,1916, 34652,2008,1884, 1917,2042,1917, 34653,2009,1885, 993,2043,993, 33763,2044,995, 34654,2010,1886, 997,2045,997, 34655,2011,1887, 999,2046,999, 34656,2012,1888, 1001,2047,1001, 34275,2013,1507, 
3, // chain 192
1849,1972,1849, 1850,1973,1850, 1918,2048,1918, 
1732,1845,1732, 34499,1844,1731, 
10, // chain 193
1891,2016,1891, 1919,2049,1919, 1920,2050,1920, 
1921,2051,1921, 34690,2052,1922, 34691,2053,1923, 34692,2054,1924, 34687,2049,1919, 1925,2055,1925, 34694,2056,1926, 34660,2017,1892, 34659,2016,1891, 
2, // chain 194
1921,2051,1921, 1848,1971,1848, 1890,2015,1890, 
1891,2016,1891, 
16, // chain 195
1847,1970,1847, 1848,1971,1848, 1921,2051,1921, 
1922,2052,1922, 1846,1969,1846, 34695,2057,1927, 34691,2053,1923, 1928,2058,1928, 34697,2059,1929, 34692,2054,1924, 1930,2060,1930, 34693,2055,1925, 1931,2061,1931, 34700,2062,1932, 34694,2056,1926, 1933,2063,1933, 34661,2018,1893, 34660,2017,1892, 
13, // chain 196
1934,2064,1934, 1935,2065,1935, 1936,2066,1936, 
1928,2058,1928, 34705,2067,1937, 34706,2068,1938, 34707,2069,1939, 34703,2065,1935, 1940,2070,1940, 34709,2071,1941, 34710,2072,1942, 34702,2064,1934, 1943,2073,1943, 34697,2059,1929, 34696,2058,1928, 
11, // chain 197
1943,2073,1943, 1929,2059,1929, 1930,2060,1930, 
1931,2061,1931, 1944,2074,1944, 34713,2075,1945, 34714,2076,1946, 34700,2062,1932, 1947,2077,1947, 34701,2063,1933, 1948,2078,1948, 34662,2019,1894, 34661,2018,1893, 
28, // chain 198
1937,2067,1937, 1938,2068,1938, 1844,1967,1844, 
34717,2079,1949, 34718,2080,1950, 34707,2069,1939, 1951,2081,1951, 34708,2070,1940, 1952,2082,1952, 34721,2083,1953, 34709,2071,1941, 1954,2084,1954, 34723,2085,1955, 34710,2072,1942, 1956,2086,1956, 34711,2073,1943, 1944,2074,1944, 1957,2087,1957, 34726,2088,1958, 
34713,2075,1945, 1959,2089,1959, 34728,2090,1960, 34714,2076,1946, 1961,2091,1961, 34715,2077,1947, 1962,2092,1962, 34716,2078,1948, 1898,2023,1898, 34663,2020,1895, 34662,2019,1894, 
2, // chain 199
1937,2067,1937, 1845,1968,1845, 1927,2057,1927, 
1928,2058,1928, 
1, // chain 200
1844,1967,1844, 1845,1968,1845, 1937,2067,1937, 
8, // chain 201
1840,1963,1840, 1841,1964,1841, 1859,1982,1859, 
34731,2093,1963, 34610,1965,1842, 1964,2094,1964, 34733,2095,1965, 34611,1966,1843, 1949,2079,1949, 34612,1967,1844, 
6, // chain 202
1966,2096,1966, 1964,2094,1964, 1967,2097,1967, 
1968,2098,1968, 34737,2099,1969, 34738,2100,1970, 34733,2095,1965, 34732,2094,1964, 
13, // chain 203
1963,2093,1963, 1964,2094,1964, 1966,2096,1966, 
1971,2101,1971, 34740,2102,1972, 34736,2098,1968, 1973,2103,1973, 34742,2104,1974, 34737,2099,1969, 1975,2105,1975, 34744,2106,1976, 34738,2100,1970, 1950,2080,1950, 34717,2079,1949, 34733,2095,1965, 
10, // chain 204
1903,2028,1903, 1977,2107,1977, 1978,2108,1978, 
1902,2027,1902, 34669,2026,1901, 34747,2109,1979, 34748,2110,1980, 34745,2107,1977, 1981,2111,1981, 34750,2112,1982, 34672,2029,1904, 34671,2028,1903, 
3, // chain 205
1899,2024,1899, 1900,2025,1900, 1983,2113,1983, 
34747,2109,1979, 34669,2026,1901, 
35, // chain 206
1984,2114,1984, 1985,2115,1985, 1986,2116,1986, 
1987,2117,1987, 34756,2118,1988, 34757,2119,1989, 34758,2120,1990, 34753,2115,1985, 1991,2121,1991, 34760,2122,1992, 34761,2123,1993, 34752,2114,1984, 1994,2124,1994, 34675,2032,1907, 34755,2117,1987, 1906,2031,1906, 34763,2125,1995, 34756,2118,1988, 1982,2112,1982, 
34764,2126,1996, 34757,2119,1989, 1997,2127,1997, 34766,2128,1998, 34758,2120,1990, 1999,2129,1999, 34759,2121,1991, 2000,2130,2000, 34769,2131,2001, 34760,2122,1992, 2002,2132,2002, 34771,2133,2003, 34761,2123,1993, 2004,2134,2004, 34762,2124,1994, 2005,2135,2005, 
34676,2033,1908, 34675,2032,1907, 
46, // chain 207
1996,2126,1996, 1997,2127,1997, 2006,2136,2006, 
1981,2111,1981, 34775,2137,2007, 34727,2089,1959, 34776,2138,2008, 34765,2127,1997, 2009,2139,2009, 34766,2128,1998, 2010,2140,2010, 34767,2129,1999, 2011,2141,2011, 34768,2130,2000, 2012,2142,2012, 34781,2143,2013, 34769,2131,2001, 2014,2144,2014, 34770,2132,2002, 
2015,2145,2015, 34784,2146,2016, 34771,2133,2003, 2017,2147,2017, 34772,2134,2004, 2018,2148,2018, 34773,2135,2005, 2019,2149,2019, 34676,2033,1908, 1909,2034,1909, 2020,2150,2020, 34789,2151,2021, 34678,2035,1910, 2022,2152,2022, 34679,2036,1911, 1912,2037,1912, 
2023,2153,2023, 34681,2038,1913, 2024,2154,2024, 34682,2039,1914, 2025,2155,2025, 33753,2156,985, 34683,2040,1915, 988,2157,988, 34684,2041,1916, 990,2158,990, 34685,2042,1917, 992,2159,992, 33761,2043,993, 
3, // chain 208
1995,2125,1995, 1982,2112,1982, 1904,2029,1904, 
1905,2030,1905, 1906,2031,1906, 
7, // chain 209
1957,2087,1957, 1958,2088,1958, 2026,2160,2026, 
2027,2161,2027, 34796,2162,2028, 34777,2139,2009, 34776,2138,2008, 34726,2088,1958, 1959,2089,1959, 
7, // chain 210
2007,2137,2007, 1959,2089,1959, 1960,2090,1960, 
2029,2163,2029, 34729,2091,1961, 1983,2113,1983, 34730,2092,1962, 1899,2024,1899, 34666,2023,1898, 
56, // chain 211
2030,2164,2030, 2031,2165,2031, 2032,2166,2032, 
2033,2167,2033, 34802,2168,2034, 34803,2169,2035, 34804,2170,2036, 34799,2165,2031, 2037,2171,2037, 34806,2172,2038, 34807,2173,2039, 34798,2164,2030, 2040,2174,2040, 34809,2175,2041, 34801,2167,2033, 2042,2176,2042, 34811,2177,2043, 34802,2168,2034, 2044,2178,2044, 
34813,2179,2045, 34803,2169,2035, 2046,2180,2046, 34804,2170,2036, 2047,2181,2047, 34816,2182,2048, 34805,2171,2037, 1952,2082,1952, 34817,2183,2049, 34806,2172,2038, 1975,2105,1975, 34818,2184,2050, 34807,2173,2039, 2051,2185,2051, 34808,2174,2040, 2052,2186,2052, 
34821,2187,2053, 34822,2188,2054, 34809,2175,2041, 2055,2189,2055, 34810,2176,2042, 2056,2190,2056, 34825,2191,2057, 34826,2192,2058, 34811,2177,2043, 2044,2178,2044, 2059,2193,2059, 34828,2194,2060, 34813,2179,2045, 2061,2195,2061, 34814,2180,2046, 2062,2196,2062, 
34831,2197,2063, 34815,2181,2047, 2064,2198,2064, 34833,2199,2065, 34816,2182,2048, 1953,2083,1953, 34720,2082,1952, 
19, // chain 212
2059,2193,2059, 2060,2194,2060, 2066,2200,2066, 
2067,2201,2067, 34836,2202,2068, 34837,2203,2069, 34838,2204,2070, 34828,2194,2060, 2061,2195,2061, 2071,2205,2071, 34830,2196,2062, 2072,2206,2072, 34841,2207,2073, 34831,2197,2063, 2074,2208,2074, 34832,2198,2064, 2075,2209,2075, 34844,2210,2076, 34833,2199,2065, 
1954,2084,1954, 34721,2083,1953, 
33, // chain 213
2077,2211,2077, 2078,2212,2078, 2079,2213,2079, 
2080,2214,2080, 34849,2215,2081, 34843,2209,2075, 34842,2208,2074, 34846,2212,2078, 2073,2207,2073, 34850,2216,2082, 34851,2217,2083, 34852,2218,2084, 34845,2211,2077, 2085,2219,2085, 34854,2220,2086, 34848,2214,2080, 2087,2221,2087, 34856,2222,2088, 34849,2215,2081, 
2089,2223,2089, 34843,2209,2075, 2076,2210,2076, 2090,2224,2090, 34722,2084,1954, 1955,2085,1955, 2091,2225,2091, 34724,2086,1956, 1957,2087,1957, 2027,2161,2027, 2092,2226,2092, 34861,2227,2093, 34796,2162,2028, 2094,2228,2094, 34778,2140,2010, 34777,2139,2009, 
12, // chain 214
2072,2206,2072, 2095,2229,2095, 2096,2230,2096, 
2071,2205,2071, 34865,2231,2097, 34866,2232,2098, 34867,2233,2099, 34863,2229,2095, 2100,2234,2100, 34869,2235,2101, 34851,2217,2083, 34850,2216,2082, 34840,2206,2072, 2073,2207,2073, 
101, // chain 215
2102,2236,2102, 2103,2237,2103, 2104,2238,2104, 
2105,2239,2105, 34874,2240,2106, 34875,2241,2107, 34876,2242,2108, 34877,2243,2109, 34871,2237,2103, 2110,2244,2110, 34879,2245,2111, 34870,2236,2102, 2112,2246,2112, 34881,2247,2113, 34873,2239,2105, 2114,2248,2114, 34883,2249,2115, 34874,2240,2106, 2116,2250,2116, 
34885,2251,2117, 34875,2241,2107, 2118,2252,2118, 34887,2253,2119, 34876,2242,2108, 2120,2254,2120, 34889,2255,2121, 34877,2243,2109, 2122,2256,2122, 34878,2244,2110, 2123,2257,2123, 34892,2258,2124, 34879,2245,2111, 2125,2259,2125, 34880,2246,2112, 2126,2260,2126, 
34895,2261,2127, 34881,2247,2113, 2128,2262,2128, 34882,2248,2114, 2129,2263,2129, 34898,2264,2130, 34883,2249,2115, 2131,2265,2131, 34884,2250,2116, 2132,2266,2132, 34901,2267,2133, 34885,2251,2117, 2118,2252,2118, 2134,2268,2134, 34903,2269,2135, 34904,2270,2136, 
34887,2253,2119, 2137,2271,2137, 34888,2254,2120, 2138,2272,2138, 34889,2255,2121, 2139,2273,2139, 34908,2274,2140, 34890,2256,2122, 2016,2146,2016, 34891,2257,2123, 2015,2145,2015, 34892,2258,2124, 2141,2275,2141, 34893,2259,2125, 2142,2276,2142, 34894,2260,2126, 
2143,2277,2143, 34912,2278,2144, 34895,2261,2127, 2145,2279,2145, 34896,2262,2128, 2146,2280,2146, 34897,2263,2129, 2147,2281,2147, 34916,2282,2148, 34898,2264,2130, 2149,2283,2149, 34899,2265,2131, 2150,2284,2150, 34900,2266,2132, 2151,2285,2151, 34901,2267,2133, 
2152,2286,2152, 34902,2268,2134, 2153,2287,2153, 34922,2288,2154, 34903,2269,2135, 2155,2289,2155, 34924,2290,2156, 34904,2270,2136, 2157,2291,2157, 34905,2271,2137, 2158,2292,2158, 34927,2293,2159, 34906,2272,2138, 2160,2294,2160, 34929,2295,2161, 34907,2273,2139, 
2018,2148,2018, 34785,2147,2017, 34908,2274,2140, 2016,2146,2016, 
49, // chain 216
2141,2275,2141, 2142,2276,2142, 2162,2296,2162, 
2014,2144,2014, 34931,2297,2163, 34932,2298,2164, 34910,2276,2142, 2143,2277,2143, 2165,2299,2165, 34934,2300,2166, 34912,2278,2144, 2167,2301,2167, 34913,2279,2145, 2168,2302,2168, 34914,2280,2146, 2169,2303,2169, 34915,2281,2147, 2170,2304,2170, 34939,2305,2171, 
34916,2282,2148, 2172,2306,2172, 34917,2283,2149, 2173,2307,2173, 34918,2284,2150, 2174,2308,2174, 34919,2285,2151, 2175,2309,2175, 34920,2286,2152, 2176,2310,2176, 34921,2287,2153, 2177,2311,2177, 34946,2312,2178, 34922,2288,2154, 2179,2313,2179, 34923,2289,2155, 
2180,2314,2180, 34949,2315,2181, 34950,2316,2182, 34924,2290,2156, 2183,2317,2183, 34925,2291,2157, 2184,2318,2184, 34926,2292,2158, 2185,2319,2185, 34954,2320,2186, 34927,2293,2159, 2160,2294,2160, 2187,2321,2187, 34929,2295,2161, 2019,2149,2019, 34786,2148,2018, 
10, // chain 217
2085,2219,2085, 2188,2322,2188, 2189,2323,2189, 
2190,2324,2190, 34959,2325,2191, 34960,2326,2192, 34961,2327,2193, 34956,2322,2188, 2012,2142,2012, 34962,2328,2194, 34854,2220,2086, 34853,2219,2085, 
12, // chain 218
2084,2218,2084, 2085,2219,2085, 2190,2324,2190, 
2083,2217,2083, 34963,2329,2195, 34959,2325,2191, 2196,2330,2196, 34933,2299,2165, 34960,2326,2192, 2164,2298,2164, 34931,2297,2163, 34961,2327,2193, 2013,2143,2013, 34780,2142,2012, 
2, // chain 219
2166,2300,2166, 2197,2331,2197, 2196,2330,2196, 
2165,2299,2165, 
45, // chain 220
2197,2331,2197, 2166,2300,2166, 2167,2301,2167, 
2198,2332,2198, 34936,2302,2168, 2199,2333,2199, 34937,2303,2169, 2200,2334,2200, 34938,2304,2170, 934,2335,934, 33704,2336,936, 34939,2305,2171, 938,2337,938, 34940,2306,2172, 940,2338,940, 34941,2307,2173, 942,2339,942, 34942,2308,2174, 944,2340,944, 
34943,2309,2175, 946,2341,946, 34944,2310,2176, 948,2342,948, 34945,2311,2177, 950,2343,950, 34969,2344,2201, 34946,2312,2178, 2202,2345,2202, 34947,2313,2179, 2203,2346,2203, 34948,2314,2180, 2204,2347,2204, 34973,2348,2205, 34974,2349,2206, 34949,2315,2181, 
2207,2350,2207, 34976,2351,2208, 34950,2316,2182, 2209,2352,2209, 34951,2317,2183, 2210,2353,2210, 34952,2318,2184, 2211,2354,2211, 34953,2319,2185, 2020,2150,2020, 34955,2321,2187, 34954,2320,2186, 
9, // chain 221
2212,2355,2212, 2196,2330,2196, 2197,2331,2197, 
2213,2356,2213, 34966,2332,2198, 2214,2357,2214, 34967,2333,2199, 2215,2358,2215, 34968,2334,2200, 932,2359,932, 33702,2335,934, 
10, // chain 222
2195,2329,2195, 2196,2330,2196, 2212,2355,2212, 
2101,2235,2101, 34984,2360,2216, 34981,2356,2213, 2217,2361,2217, 34982,2357,2214, 2218,2362,2218, 34983,2358,2215, 930,2363,930, 33700,2359,932, 
9, // chain 223
2090,2224,2090, 2091,2225,2091, 2092,2226,2092, 
2089,2223,2089, 34856,2222,2088, 34861,2227,2093, 2087,2221,2087, 34862,2228,2094, 2194,2328,2194, 34779,2141,2011, 34778,2140,2010, 
1, // chain 224
2015,2145,2015, 2141,2275,2141, 2014,2144,2014, 
18, // chain 225
1856,1979,1856, 2219,2364,2219, 2220,2365,2220, 
1855,1978,1855, 34989,2366,2221, 34990,2367,2222, 34991,2368,2223, 34992,2369,2224, 34987,2364,2219, 2225,2370,2225, 34824,2190,2056, 34994,2371,2226, 34624,1979,1856, 1857,1980,1857, 2227,2372,2227, 34996,2373,2228, 34626,1981,1858, 1971,2101,1971, 34627,1982,1859, 
1963,2093,1963, 
2, // chain 226
1972,2102,1972, 2229,2374,2229, 2228,2373,2228, 
1971,2101,1971, 
6, // chain 227
2229,2374,2229, 1972,2102,1972, 1973,2103,1973, 
2053,2187,2053, 34820,2186,2052, 34742,2104,1974, 2050,2184,2050, 34743,2105,1975, 
5, // chain 228
2055,2189,2055, 2056,2190,2056, 2226,2371,2226, 
2227,2372,2227, 2054,2188,2054, 34997,2374,2229, 34996,2373,2228, 
1, // chain 229
2087,2221,2087, 2194,2328,2194, 2086,2220,2086, 
3, // chain 230
1952,2082,1952, 2049,2183,2049, 1951,2081,1951, 
34744,2106,1976, 34743,2105,1975, 
25, // chain 231
2222,2367,2222, 2223,2368,2223, 2230,2375,2230, 
34999,2376,2231, 35000,2377,2232, 34992,2369,2224, 2233,2378,2233, 34993,2370,2225, 2234,2379,2234, 35003,2380,2235, 34824,2190,2056, 2057,2191,2057, 2236,2381,2236, 35005,2382,2237, 34826,2192,2058, 2238,2383,2238, 34827,2193,2059, 2067,2201,2067, 2239,2384,2239, 
35008,2385,2240, 34836,2202,2068, 2241,2386,2241, 35010,2387,2242, 34837,2203,2069, 2097,2231,2097, 34838,2204,2070, 2071,2205,2071, 
13, // chain 232
2243,2388,2243, 631,2389,631, 629,2390,629, 
2244,2391,2244, 33395,2392,627, 2245,2393,2245, 33392,2394,624, 622,2395,622, 2246,2396,2246, 35015,2397,2247, 33388,2398,620, 2248,2399,2248, 33386,2400,618, 266,2401,266, 33036,2402,268, 
18, // chain 233
631,2389,631, 2243,2388,2243, 2249,2403,2249, 
633,2404,633, 35018,2405,2250, 35001,2378,2233, 35000,2377,2232, 35011,2388,2243, 2231,2376,2231, 35012,2391,2244, 2230,2375,2230, 35013,2393,2245, 2251,2406,2251, 35014,2396,2246, 2252,2407,2252, 35015,2397,2247, 2253,2408,2253, 35016,2399,2248, 172,2409,172, 
33034,2401,266, 
21, // chain 234
2250,2405,2250, 2233,2378,2233, 2234,2379,2234, 
2254,2410,2254, 35023,2411,2255, 35003,2380,2235, 2236,2381,2236, 2256,2412,2256, 35025,2413,2257, 35005,2382,2237, 2258,2414,2258, 35006,2383,2238, 2239,2384,2239, 2259,2415,2259, 35028,2416,2260, 35008,2385,2240, 2261,2417,2261, 35009,2386,2241, 2262,2418,2262, 
35031,2419,2263, 35010,2387,2242, 2098,2232,2098, 34865,2231,2097, 
10, // chain 235
1207,1259,1207, 2264,2420,2264, 2265,2421,2265, 
1206,1258,1206, 35034,2422,2266, 35035,2423,2267, 35036,2424,2268, 35032,2420,2264, 2269,2425,2269, 35038,2426,2270, 33976,1260,1208, 33975,1259,1207, 
58, // chain 236
2271,2427,2271, 2272,2428,2272, 2273,2429,2273, 
2274,2430,2274, 35043,2431,2275, 35044,2432,2276, 35045,2433,2277, 35040,2428,2272, 2278,2434,2278, 35047,2435,2279, 35048,2436,2280, 35039,2427,2271, 2281,2437,2281, 35050,2438,2282, 35042,2430,2274, 2283,2439,2283, 35052,2440,2284, 35043,2431,2275, 2285,2441,2285, 
35054,2442,2286, 35044,2432,2276, 2287,2443,2287, 35056,2444,2288, 35045,2433,2277, 2289,2445,2289, 35046,2434,2278, 2290,2446,2290, 35059,2447,2291, 35047,2435,2279, 2266,2422,2266, 33973,1257,1205, 35048,2436,2280, 1204,1256,1204, 35049,2437,2281, 1203,1255,1203, 
35060,2448,2292, 35050,2438,2282, 2293,2449,2293, 35051,2439,2283, 1198,1250,1198, 35062,2450,2294, 35052,2440,2284, 2295,2451,2295, 35053,2441,2285, 2296,2452,2296, 35054,2442,2286, 2297,2453,2297, 35055,2443,2287, 2298,2454,2298, 35067,2455,2299, 35056,2444,2288, 
2300,2456,2300, 35057,2445,2289, 2301,2457,2301, 35058,2446,2290, 2302,2458,2302, 35071,2459,2303, 35059,2447,2291, 2267,2423,2267, 35034,2422,2266, 
5, // chain 237
1202,1254,1202, 1203,1255,1203, 2292,2448,2292, 
2304,2460,2304, 35061,2449,2293, 1199,1251,1199, 33966,1250,1198, 
16, // chain 238
2298,2454,2298, 2299,2455,2299, 2305,2461,2305, 
35074,2462,2306, 35068,2456,2300, 2307,2463,2307, 35076,2464,2308, 35069,2457,2301, 2309,2465,2309, 35070,2458,2302, 2310,2466,2310, 35079,2467,2311, 35071,2459,2303, 2312,2468,2312, 35035,2423,2267, 2268,2424,2268, 2313,2469,2313, 35037,2425,2269, 
24, // chain 239
2314,2470,2314, 2315,2471,2315, 2297,2453,2297, 
2298,2454,2298, 2316,2472,2316, 35073,2461,2305, 2317,2473,2317, 35086,2474,2318, 35074,2462,2306, 1474,1564,1474, 35075,2463,2307, 2319,2475,2319, 35076,2464,2308, 2320,2476,2320, 35077,2465,2309, 2321,2477,2321, 35090,2478,2322, 35078,2466,2310, 2323,2479,2323, 
35092,2480,2324, 35079,2467,2311, 2325,2481,2325, 35094,2482,2326, 35080,2468,2312, 2327,2483,2327, 35081,2469,2313, 
6, // chain 240
2315,2471,2315, 2314,2470,2314, 2328,2484,2328, 
2329,2485,2329, 35098,2486,2330, 35099,2487,2331, 35084,2472,2316, 35082,2470,2314, 
16, // chain 241
2296,2452,2296, 2297,2453,2297, 2315,2471,2315, 
2332,2488,2332, 35097,2485,2329, 2333,2489,2333, 35102,2490,2334, 35098,2486,2330, 2335,2491,2335, 35104,2492,2336, 35099,2487,2331, 2337,2493,2337, 35084,2472,2316, 2317,2473,2317, 1476,1566,1476, 34243,1565,1475, 35086,2474,2318, 1474,1564,1474, 
130, // chain 242
2338,2494,2338, 2339,2495,2339, 2340,2496,2340, 
2341,2497,2341, 35110,2498,2342, 35111,2499,2343, 35112,2500,2344, 35113,2501,2345, 35107,2495,2339, 2346,2502,2346, 35115,2503,2347, 35116,2504,2348, 35106,2494,2338, 2349,2505,2349, 35118,2506,2350, 35109,2497,2341, 2351,2507,2351, 35120,2508,2352, 35121,2509,2353, 
35110,2498,2342, 2343,2499,2343, 2354,2510,2354, 35123,2511,2355, 35124,2512,2356, 35112,2500,2344, 2357,2513,2357, 35126,2514,2358, 35113,2501,2345, 2346,2502,2346, 2359,2515,2359, 35128,2516,2360, 35129,2517,2361, 35115,2503,2347, 2362,2518,2362, 35131,2519,2363, 
35116,2504,2348, 2364,2520,2364, 35117,2505,2349, 2365,2521,2365, 35134,2522,2366, 35118,2506,2350, 2367,2523,2367, 35119,2507,2351, 2368,2524,2368, 35120,2508,2352, 2369,2525,2369, 35138,2526,2370, 35121,2509,2353, 2371,2527,2371, 35122,2510,2354, 2372,2528,2372, 
35123,2511,2355, 2373,2529,2373, 35142,2530,2374, 35124,2512,2356, 2357,2513,2357, 2375,2531,2375, 35126,2514,2358, 2359,2515,2359, 2376,2532,2376, 35128,2516,2360, 2377,2533,2377, 35146,2534,2378, 35129,2517,2361, 2379,2535,2379, 35130,2518,2362, 2380,2536,2380, 
35149,2537,2381, 35131,2519,2363, 2382,2538,2382, 35132,2520,2364, 2365,2521,2365, 2383,2539,2383, 35152,2540,2384, 35134,2522,2366, 2385,2541,2385, 35135,2523,2367, 2386,2542,2386, 35155,2543,2387, 35136,2524,2368, 2388,2544,2388, 35137,2525,2369, 2389,2545,2389, 
35138,2526,2370, 2390,2546,2390, 35139,2527,2371, 2391,2547,2391, 35140,2528,2372, 2373,2529,2373, 2392,2548,2392, 35142,2530,2374, 2393,2549,2393, 35143,2531,2375, 2376,2532,2376, 2394,2550,2394, 35145,2533,2377, 2395,2551,2395, 35164,2552,2396, 35146,2534,2378, 
2397,2553,2397, 35147,2535,2379, 1829,2554,1829, 35148,2536,2380, 1811,2555,1811, 35166,2556,2398, 35149,2537,2381, 2399,2557,2399, 35150,2538,2382, 2383,2539,2383, 2400,2558,2400, 35169,2559,2401, 35152,2540,2384, 2402,2560,2402, 35153,2541,2385, 2403,2561,2403, 
35154,2542,2386, 2404,2562,2404, 35173,2563,2405, 35155,2543,2387, 2388,2544,2388, 2406,2564,2406, 35157,2545,2389, 2407,2565,2407, 35158,2546,2390, 2408,2566,2408, 35159,2547,2391, 2392,2548,2392, 2409,2567,2409, 35161,2549,2393, 2394,2550,2394, 2410,2568,2410, 
35163,2551,2395, 
129, // chain 243
2411,2569,2411, 2412,2570,2412, 2413,2571,2413, 
2414,2572,2414, 35183,2573,2415, 35184,2574,2416, 35185,2575,2417, 35186,2576,2418, 35180,2570,2412, 2419,2577,2419, 35188,2578,2420, 35179,2569,2411, 2421,2579,2421, 35190,2580,2422, 35182,2572,2414, 2423,2581,2423, 35192,2582,2424, 35193,2583,2425, 35183,2573,2415, 
2426,2584,2426, 35184,2574,2416, 2427,2585,2427, 35196,2586,2428, 35185,2575,2417, 2429,2587,2429, 35198,2588,2430, 35186,2576,2418, 2431,2589,2431, 35187,2577,2419, 2432,2590,2432, 35201,2591,2433, 35202,2592,2434, 35188,2578,2420, 2435,2593,2435, 35189,2579,2421, 
2436,2594,2436, 35205,2595,2437, 35190,2580,2422, 2423,2581,2423, 2438,2596,2438, 35207,2597,2439, 35192,2582,2424, 2440,2598,2440, 35209,2599,2441, 35193,2583,2425, 2442,2600,2442, 35194,2584,2426, 2443,2601,2443, 35195,2585,2427, 2444,2602,2444, 35196,2586,2428, 
2445,2603,2445, 35197,2587,2429, 2446,2604,2446, 35198,2588,2430, 2447,2605,2447, 35199,2589,2431, 2448,2606,2448, 35200,2590,2432, 2449,2607,2449, 35218,2608,2450, 35201,2591,2433, 2451,2609,2451, 35220,2610,2452, 35202,2592,2434, 2453,2611,2453, 35203,2593,2435, 
2436,2594,2436, 2454,2612,2454, 35223,2613,2455, 35205,2595,2437, 2456,2614,2456, 35206,2596,2438, 2457,2615,2457, 35226,2616,2458, 35207,2597,2439, 2459,2617,2459, 35208,2598,2440, 2460,2618,2460, 35209,2599,2441, 2461,2619,2461, 35210,2600,2442, 2443,2601,2443, 
2462,2620,2462, 35212,2602,2444, 2463,2621,2463, 35213,2603,2445, 2464,2622,2464, 35214,2604,2446, 2465,2623,2465, 35215,2605,2447, 2448,2606,2448, 2466,2624,2466, 35217,2607,2449, 1759,2625,1759, 34530,2626,1762, 34532,2627,1764, 35218,2608,2450, 2451,2609,2451, 
1766,2628,1766, 35235,2629,2467, 35220,2610,2452, 2468,2630,2468, 35221,2611,2453, 2454,2612,2454, 2469,2631,2469, 35238,2632,2470, 35223,2613,2455, 2471,2633,2471, 35224,2614,2456, 2472,2634,2472, 35225,2615,2457, 2473,2635,2473, 35242,2636,2474, 35226,2616,2458, 
2459,2617,2459, 2475,2637,2475, 35228,2618,2460, 2476,2638,2476, 35229,2619,2461, 2462,2620,2462, 2477,2639,2477, 35231,2621,2463, 2478,2640,2478, 35247,2641,2479, 35232,2622,2464, 2480,2642,2480, 35233,2623,2465, 2466,2624,2466, 1755,2643,1755, 34527,2625,1759, 
21, // chain 244
1768,2644,1768, 1766,2628,1766, 2467,2629,2467, 
2481,2645,2481, 35236,2630,2468, 2469,2631,2469, 1772,2646,1772, 34543,2647,1775, 35238,2632,2470, 1777,2648,1777, 35239,2633,2471, 2472,2634,2472, 1779,2649,1779, 34550,2650,1782, 35241,2635,2473, 1784,2651,1784, 35250,2652,2482, 35242,2636,2474, 2475,2637,2475, 
2483,2653,2483, 35244,2638,2476, 2478,2640,2478, 35245,2639,2477, 
8, // chain 245
1784,2651,1784, 2482,2652,2482, 1786,2654,1786, 
35251,2653,2483, 2478,2640,2478, 1513,2655,1513, 34518,2656,1750, 35247,2641,2479, 2480,2642,2480, 1755,2643,1755, 
8, // chain 246
2401,2559,2401, 1918,2657,1918, 1850,2658,1850, 
2400,2558,2400, 34596,2659,1828, 2484,2660,2484, 34578,2661,1810, 2398,2556,2398, 34565,2662,1797, 1811,2555,1811, 
20, // chain 247
1918,2657,1918, 2401,2559,2401, 2402,2560,2402, 
2403,2561,2403, 1731,2663,1731, 34498,2664,1730, 35172,2562,2404, 1745,2665,1745, 35253,2666,2485, 35173,2563,2405, 2406,2564,2406, 2486,2667,2486, 35175,2565,2407, 2487,2668,2487, 35176,2566,2408, 2409,2567,2409, 2410,2568,2410, 1530,2669,1530, 2486,2667,2486, 
34519,2670,1751, 2485,2666,2485, 34513,2665,1745, 
2, // chain 248
2399,2557,2399, 2400,2558,2400, 2484,2660,2484, 
2398,2556,2398, 
20, // chain 249
2488,2671,2488, 2489,2672,2489, 2490,2673,2490, 
2491,2674,2491, 35260,2675,2492, 35261,2676,2493, 35262,2677,2494, 35257,2672,2489, 2495,2678,2495, 35264,2679,2496, 35265,2680,2497, 35256,2671,2488, 2498,2681,2498, 35267,2682,2499, 35259,2674,2491, 2500,2683,2500, 35269,2684,2501, 35270,2685,2502, 35260,2675,2492, 
2503,2686,2503, 35272,2687,2504, 35261,2676,2493, 
26, // chain 250
2498,2681,2498, 2505,2688,2505, 2506,2689,2506, 
2497,2680,2497, 35275,2690,2507, 35276,2691,2508, 35277,2692,2509, 35273,2688,2505, 2510,2693,2510, 35279,2694,2511, 35280,2695,2512, 35266,2681,2498, 2499,2682,2499, 2513,2696,2513, 35268,2683,2500, 2514,2697,2514, 35269,2684,2501, 2515,2698,2515, 35284,2699,2516, 
35285,2700,2517, 35286,2701,2518, 35270,2685,2502, 2519,2702,2519, 35288,2703,2520, 35271,2686,2503, 2521,2704,2521, 35290,2705,2522, 35272,2687,2504, 
40, // chain 251
2508,2691,2508, 2523,2706,2523, 2524,2707,2524, 
2507,2690,2507, 35293,2708,2525, 35294,2709,2526, 35291,2706,2523, 2527,2710,2527, 35296,2711,2528, 35297,2712,2529, 35276,2691,2508, 2530,2713,2530, 35277,2692,2509, 2510,2693,2510, 2531,2714,2531, 35300,2715,2532, 35301,2716,2533, 35279,2694,2511, 2534,2717,2534, 
35303,2718,2535, 35280,2695,2512, 2513,2696,2513, 2514,2697,2514, 2515,2698,2515, 2534,2717,2534, 35284,2699,2516, 2536,2719,2536, 35305,2720,2537, 35285,2700,2517, 2538,2721,2538, 35286,2701,2518, 2539,2722,2539, 35308,2723,2540, 35287,2702,2519, 2541,2724,2541, 
35310,2725,2542, 35288,2703,2520, 2543,2726,2543, 35289,2704,2521, 2544,2727,2544, 35313,2728,2545, 35290,2705,2522, 
4, // chain 252
2495,2678,2495, 2496,2679,2496, 2546,2729,2546, 
35293,2708,2525, 35275,2690,2507, 35265,2680,2497, 
6, // chain 253
2324,2730,2324, 2527,2710,2527, 2547,2731,2547, 
2323,2732,2323, 35316,2733,2548, 35317,2734,2549, 35296,2711,2528, 35295,2710,2527, 
5, // chain 254
2527,2710,2527, 2324,2730,2324, 2325,2735,2325, 
2526,2709,2526, 35318,2736,2550, 2525,2708,2525, 35314,2729,2546, 
6, // chain 255
2551,2737,2551, 2531,2714,2531, 2552,2738,2552, 
2553,2739,2553, 35322,2740,2554, 35323,2741,2555, 35300,2715,2532, 35299,2714,2531, 
20, // chain 256
2531,2714,2531, 2551,2737,2551, 2556,2742,2556, 
2530,2713,2530, 35297,2712,2529, 35296,2711,2528, 35317,2734,2549, 35319,2737,2551, 2557,2743,2557, 35321,2739,2553, 2558,2744,2558, 35327,2745,2559, 35322,2740,2554, 2560,2746,2560, 35329,2747,2561, 35323,2741,2555, 2562,2748,2562, 35331,2749,2563, 35300,2715,2532, 
2533,2716,2533, 2536,2719,2536, 35302,2717,2534, 
28, // chain 257
2564,2750,2564, 2557,2743,2557, 2558,2744,2558, 
2565,2751,2565, 35334,2752,2566, 35327,2745,2559, 2567,2753,2567, 35328,2746,2560, 2561,2747,2561, 2568,2754,2568, 35330,2748,2562, 2569,2755,2569, 35338,2756,2570, 35331,2749,2563, 2536,2719,2536, 2537,2720,2537, 2538,2721,2538, 2569,2755,2569, 35307,2722,2539, 
2571,2757,2571, 35308,2723,2540, 2572,2758,2572, 35309,2724,2541, 2573,2759,2573, 2574,2760,2574, 35343,2761,2575, 2576,2762,2576, 35345,2763,2577, 2578,2764,2578, 35347,2765,2579, 
2, // chain 258
2557,2743,2557, 2564,2750,2564, 2548,2733,2548, 
2549,2734,2549, 
18, // chain 259
918,2766,918, 917,2767,917, 2261,2417,2261, 
35028,2416,2260, 33195,2768,427, 2259,2415,2259, 33196,2769,428, 2580,2770,2580, 33197,2771,429, 2581,2772,2581, 33198,2773,430, 2582,2774,2582, 33199,2775,431, 2583,2776,2583, 2584,2777,2584, 35353,2778,2585, 2254,2410,2254, 35354,2779,2586, 2250,2405,2250, 
33401,2404,633, 
12, // chain 260
2261,2417,2261, 2262,2418,2262, 918,2766,918, 
33688,2780,920, 35355,2781,2587, 35031,2419,2263, 2588,2782,2588, 34866,2232,2098, 2099,2233,2099, 2589,2783,2589, 34868,2234,2100, 2590,2784,2590, 34984,2360,2216, 34869,2235,2101, 
5, // chain 261
2591,2785,2591, 1536,2786,1536, 1534,2787,1534, 
2592,2788,2592, 34300,2789,1532, 2410,2790,2410, 34298,1873,1530, 
10, // chain 262
1536,2786,1536, 2591,2785,2591, 2593,2791,2593, 
1095,2792,1095, 33853,2793,1085, 35362,2794,2594, 35363,2795,2595, 35359,2785,2591, 2596,2796,2596, 35360,2788,2592, 2395,2797,2395, 35178,2790,2410, 
8, // chain 263
1086,2798,1086, 1085,2793,1085, 2594,2794,2594, 
2597,2799,2597, 35366,2800,2598, 35363,2795,2595, 2599,2801,2599, 35364,2796,2596, 2396,2802,2396, 35163,2797,2395, 
3, // chain 264
2600,2803,2600, 2598,2800,2598, 2599,2801,2599, 
2397,2804,2397, 35164,2802,2396, 
10, // chain 265
2598,2800,2598, 2600,2803,2600, 2601,2805,2601, 
2597,2799,2597, 35370,2806,2602, 35371,2807,2603, 35372,2808,2604, 35368,2803,2600, 2605,2809,2605, 35165,2804,2397, 1830,1953,1830, 34597,1952,1829, 
12, // chain 266
1088,2810,1088, 1086,2798,1086, 2597,2799,2597, 
2602,2806,2602, 1090,2811,1090, 33859,2812,1091, 35371,2807,2603, 1092,2813,1092, 35374,2814,2606, 35372,2808,2604, 2607,2815,2607, 35373,2809,2605, 1831,1954,1831, 34598,1953,1830, 
6, // chain 267
2587,2781,2587, 2588,2782,2588, 2608,2816,2608, 
922,2817,922, 33692,2818,924, 35377,2819,2609, 35357,2783,2589, 35356,2782,2588, 
4, // chain 268
926,2820,926, 924,2818,924, 2609,2819,2609, 
2610,2821,2610, 35358,2784,2590, 35357,2783,2589, 
5, // chain 269
2590,2784,2590, 2216,2360,2216, 2217,2361,2217, 
2610,2821,2610, 34986,2362,2218, 928,2822,928, 33698,2363,930, 
1, // chain 270
928,2822,928, 926,2820,926, 2610,2821,2610, 
8, // chain 271
2259,2415,2259, 2580,2770,2580, 2258,2414,2258, 
35025,2413,2257, 35349,2772,2581, 2256,2412,2256, 35350,2774,2582, 2584,2777,2584, 2255,2411,2255, 35022,2410,2254, 
13, // chain 272
1209,2823,1209, 673,2824,673, 2611,2825,2611, 
35380,2826,2612, 33400,2827,632, 2613,2828,2613, 33401,2829,633, 2586,2830,2586, 1123,1170,1123, 35353,2831,2585, 1122,1169,1122, 35351,2832,2583, 1121,1168,1121, 33199,2833,431, 413,1167,413, 
10, // chain 273
2614,2834,2614, 1125,1172,1125, 1126,1173,1126, 
2615,2835,2615, 33895,1174,1127, 2616,2836,2616, 35385,2837,2617, 33896,1175,1128, 2618,2838,2618, 35387,2839,2619, 33990,1281,1222, 33897,1176,1129, 
5, // chain 274
1125,1172,1125, 2614,2834,2614, 2611,2825,2611, 
2612,2826,2612, 1124,1171,1124, 35381,2828,2613, 1123,1170,1123, 
9, // chain 275
2620,2840,2620, 1473,1563,1473, 2319,2475,2319, 
2320,2476,2320, 2621,2841,2621, 35089,2477,2321, 2622,2842,2622, 35391,2843,2623, 35090,2478,2322, 2624,2844,2624, 35091,2479,2323, 
17, // chain 276
1472,1562,1472, 1473,1563,1473, 2620,2840,2620, 
2625,2845,2625, 35394,2846,2626, 35389,2841,2621, 2627,2847,2627, 35390,2842,2622, 2623,2843,2623, 2628,2848,2628, 35392,2844,2624, 2629,2849,2629, 2630,2850,2630, 35399,2851,2631, 2632,2852,2632, 35401,2853,2633, 35346,2854,2578, 2634,2855,2634, 35347,2856,2579, 
15, // chain 277
1471,1561,1471, 1472,1562,1472, 2625,2845,2625, 
2635,2857,2635, 35404,2858,2636, 35394,2846,2626, 2637,2859,2637, 35395,2847,2627, 2628,2848,2628, 2630,2850,2630, 2638,2860,2638, 35400,2852,2632, 2639,2861,2639, 35408,2862,2640, 35401,2853,2633, 2641,2863,2641, 35402,2855,2634, 
7, // chain 278
1183,1235,1183, 1184,1236,1184, 2642,2864,2642, 
2337,2493,2337, 35104,2492,2336, 35103,2491,2335, 33961,1245,1193, 33952,1236,1184, 1185,1237,1185, 
10, // chain 279
1832,1955,1832, 2643,2865,2643, 2644,2866,2644, 
1831,1954,1831, 35375,2815,2607, 35413,2867,2645, 35414,2868,2646, 35411,2865,2643, 2647,2869,2647, 35416,2870,2648, 34601,1956,1833, 34600,1955,1832, 
11, // chain 280
1093,2871,1093, 2606,2814,2606, 2645,2867,2645, 
148,2872,148, 35414,2868,2646, 147,2873,147, 35415,2869,2647, 146,2874,146, 35417,2875,2649, 35416,2870,2648, 2650,2876,2650, 34602,1957,1834, 34601,1956,1833, 
1, // chain 281
1092,2813,1092, 2606,2814,2606, 1093,2871,1093, 
13, // chain 282
2651,2877,2651, 2652,2878,2652, 2653,2879,2653, 
1835,1958,1835, 35418,2876,2650, 35422,2880,2654, 35423,2881,2655, 35420,2878,2652, 2656,2882,2656, 35425,2883,2657, 35426,2884,2658, 35419,2877,2651, 1860,1983,1860, 34604,1959,1836, 34603,1958,1835, 
15, // chain 283
145,2885,145, 2649,2875,2649, 2654,2880,2654, 
144,2886,144, 35423,2881,2655, 173,2887,173, 35424,2882,2656, 172,2409,172, 35021,2408,2253, 35425,2883,2657, 2252,2407,2252, 35427,2888,2659, 35426,2884,2658, 2221,2366,2221, 34628,1983,1860, 1854,1977,1854, 1855,1978,1855, 
1, // chain 284
146,2874,146, 2649,2875,2649, 145,2885,145, 
2, // chain 285
2222,2367,2222, 2251,2406,2251, 2659,2888,2659, 
2221,2366,2221, 
1, // chain 286
2230,2375,2230, 2251,2406,2251, 2222,2367,2222, 
2, // chain 287
2294,2450,2294, 2660,2889,2660, 1197,1249,1197, 
1198,1250,1198, 
3, // chain 288
2660,2889,2660, 2294,2450,2294, 2295,2451,2295, 
2332,2488,2332, 35064,2452,2296, 
4, // chain 289
1196,1248,1196, 1197,1249,1197, 2660,2889,2660, 
1195,1247,1195, 35101,2489,2333, 35100,2488,2332, 
5, // chain 290
2618,2838,2618, 2619,2839,2619, 2661,2890,2661, 
35430,2891,2662, 33990,1281,1222, 1224,1283,1224, 33991,1282,1223, 
5, // chain 291
2663,2892,2663, 2494,2893,2494, 2495,2894,2495, 
2664,2895,2664, 35314,2896,2546, 2327,2897,2327, 35318,2898,2550, 
10, // chain 292
2494,2893,2494, 2663,2892,2663, 2665,2899,2665, 
2493,2900,2493, 35434,2901,2666, 35386,2838,2618, 35431,2892,2663, 2617,2837,2617, 35384,2836,2616, 35432,2895,2664, 2313,2902,2313, 35095,2897,2327, 
6, // chain 293
2666,2901,2666, 2618,2838,2618, 2661,2890,2661, 
2667,2903,2667, 35436,2904,2668, 35430,2891,2662, 1225,1284,1225, 33992,1283,1224, 
2, // chain 294
2615,2835,2615, 2616,2836,2616, 2269,2905,2269, 
35081,2902,2313, 
117, // chain 295
2669,2906,2669, 2670,2907,2670, 2671,2908,2671, 
2672,2909,2672, 35441,2910,2673, 35442,2911,2674, 35438,2907,2670, 2675,2912,2675, 35444,2913,2676, 35445,2914,2677, 35446,2915,2678, 35437,2906,2669, 2679,2916,2679, 35448,2917,2680, 35440,2909,2672, 2681,2918,2681, 35450,2919,2682, 35441,2910,2673, 2683,2920,2683, 
35452,2921,2684, 35442,2911,2674, 2685,2922,2685, 35443,2912,2675, 2686,2923,2686, 35455,2924,2687, 35444,2913,2676, 2688,2925,2688, 35445,2914,2677, 2689,2926,2689, 35458,2927,2690, 35459,2928,2691, 35446,2915,2678, 2679,2916,2679, 2692,2929,2692, 35461,2930,2693, 
35448,2917,2680, 2694,2931,2694, 35449,2918,2681, 2695,2932,2695, 35464,2933,2696, 35450,2919,2682, 2697,2934,2697, 35451,2920,2683, 2698,2935,2698, 35452,2921,2684, 2699,2936,2699, 35453,2922,2685, 2700,2937,2700, 35469,2938,2701, 35454,2923,2686, 2702,2939,2702, 
35471,2940,2703, 35455,2924,2687, 2704,2941,2704, 35456,2925,2688, 2705,2942,2705, 35457,2926,2689, 2706,2943,2706, 35475,2944,2707, 35458,2927,2690, 2708,2945,2708, 35459,2928,2691, 2692,2929,2692, 2709,2946,2709, 35478,2947,2710, 35461,2930,2693, 2711,2948,2711, 
35462,2931,2694, 2695,2932,2695, 2712,2949,2712, 35481,2950,2713, 35482,2951,2714, 35483,2952,2715, 35464,2933,2696, 2697,2934,2697, 2716,2953,2716, 35466,2935,2698, 2717,2954,2717, 35467,2936,2699, 2718,2955,2718, 35468,2937,2700, 2719,2956,2719, 35488,2957,2720, 
35469,2938,2701, 2721,2958,2721, 35470,2939,2702, 2722,2959,2722, 35491,2960,2723, 35471,2940,2703, 2724,2961,2724, 35472,2941,2704, 2725,2962,2725, 35473,2942,2705, 2726,2963,2726, 35495,2964,2727, 35474,2943,2706, 2728,2965,2728, 35497,2966,2729, 35475,2944,2707, 
2730,2967,2730, 35476,2945,2708, 2709,2946,2709, 2731,2968,2731, 35478,2947,2710, 2732,2969,2732, 35479,2948,2711, 2712,2949,2712, 2733,2970,2733, 35481,2950,2713, 2734,2971,2734, 35503,2972,2735, 35482,2951,2714, 2736,2973,2736, 35505,2974,2737, 35483,2952,2715, 
2738,2975,2738, 35484,2953,2716, 2718,2955,2718, 35485,2954,2717, 
28, // chain 296
2739,2976,2739, 2740,2977,2740, 2741,2978,2741, 
2742,2979,2742, 35511,2980,2743, 35512,2981,2744, 35513,2982,2745, 35508,2977,2740, 2577,2983,2577, 35347,2984,2579, 35514,2985,2746, 35507,2976,2739, 2747,2986,2747, 35516,2987,2748, 35510,2979,2742, 2749,2988,2749, 35511,2980,2743, 2750,2989,2750, 35519,2990,2751, 
35520,2991,2752, 35512,2981,2744, 2753,2992,2753, 35522,2993,2754, 35513,2982,2745, 2577,2983,2577, 2575,2994,2575, 2755,2995,2755, 35341,2996,2573, 2542,2997,2542, 35309,2998,2541, 
23, // chain 297
2756,2999,2756, 2634,3000,2634, 2746,2985,2746, 
2747,2986,2747, 2757,3001,2757, 35526,3002,2758, 35516,2987,2748, 2759,3003,2759, 35517,2988,2749, 2724,2961,2724, 35491,2960,2723, 35518,2989,2750, 2722,2959,2722, 35519,2990,2751, 2760,3004,2760, 35529,3005,2761, 35530,3006,2762, 35520,2991,2752, 2753,2992,2753, 
2763,3007,2763, 35532,3008,2764, 35522,2993,2754, 2755,2995,2755, 2543,3009,2543, 35310,2997,2542, 
10, // chain 298
2641,3010,2641, 2634,3000,2634, 2756,2999,2756, 
2765,3011,2765, 35525,3001,2757, 2766,3012,2766, 35535,3013,2767, 35526,3002,2758, 2768,3014,2768, 35527,3003,2759, 2725,2962,2725, 35492,2961,2724, 
12, // chain 299
2769,3015,2769, 2641,3010,2641, 2765,3011,2765, 
2770,3016,2770, 35534,3012,2766, 2771,3017,2771, 35540,3018,2772, 35541,3019,2773, 35535,3013,2767, 2774,3020,2774, 35543,3021,2775, 35536,3014,2768, 2726,2963,2726, 35493,2962,2725, 
8, // chain 300
2760,3004,2760, 2761,3005,2761, 2776,3022,2776, 
2777,3023,2777, 35546,3024,2778, 35547,3025,2779, 35548,3026,2780, 35529,3005,2761, 2763,3007,2763, 35530,3006,2762, 
14, // chain 301
2722,2959,2722, 2760,3004,2760, 2721,2958,2721, 
35545,3023,2777, 2781,3027,2781, 35546,3024,2778, 2782,3028,2782, 35551,3029,2783, 35547,3025,2779, 2784,3030,2784, 35553,3031,2785, 35548,3026,2780, 2763,3007,2763, 2544,3032,2544, 35532,3008,2764, 2543,3009,2543, 
22, // chain 302
2783,3029,2783, 2784,3030,2784, 2786,3033,2786, 
2787,3034,2787, 35556,3035,2788, 2789,3036,2789, 35558,3037,2790, 2791,3038,2791, 35560,3039,2792, 2793,3040,2793, 35562,3041,2794, 1484,3042,1484, 2795,3043,2795, 34253,3044,1485, 2796,3045,2796, 35565,3046,2797, 35566,3047,2798, 2799,3048,2799, 35568,3049,2800, 
2801,3050,2801, 2771,3017,2771, 35538,3016,2770, 35570,3051,2802, 2769,3015,2769, 
2, // chain 303
2787,3034,2787, 2803,3052,2803, 2782,3028,2782, 
2783,3029,2783, 
54, // chain 304
2803,3052,2803, 2787,3034,2787, 2789,3036,2789, 
2804,3053,2804, 35559,3038,2791, 2805,3054,2805, 35561,3040,2793, 2795,3043,2795, 2806,3055,2806, 35564,3045,2796, 2807,3056,2807, 35565,3046,2797, 2808,3057,2808, 35577,3058,2809, 35567,3048,2799, 2771,3017,2771, 2772,3018,2772, 2810,3059,2810, 35541,3019,2773, 
2811,3060,2811, 35542,3020,2774, 2812,3061,2812, 35581,3062,2813, 35543,3021,2775, 2814,3063,2814, 35494,2963,2726, 2727,2964,2727, 2815,3064,2815, 35496,2965,2728, 2816,3065,2816, 35585,3066,2817, 35497,2966,2729, 2730,2967,2730, 2731,2968,2731, 2818,3067,2818, 
35500,2969,2732, 2733,2970,2733, 2812,3061,2812, 35502,2971,2734, 2811,3060,2811, 35587,3068,2819, 35503,2972,2735, 2820,3069,2820, 35589,3070,2821, 35504,2973,2736, 2822,3071,2822, 35505,2974,2737, 2823,3072,2823, 35506,2975,2738, 2718,2955,2718, 2719,2956,2719, 
2824,3073,2824, 35593,3074,2825, 35488,2957,2720, 2781,3027,2781, 35489,2958,2721, 
16, // chain 305
2781,3027,2781, 2782,3028,2782, 2825,3074,2825, 
35571,3052,2803, 2824,3073,2824, 35572,3053,2804, 2826,3075,2826, 35573,3054,2805, 2827,3076,2827, 35574,3055,2806, 2807,3056,2807, 2828,3077,2828, 35576,3057,2808, 2829,3078,2829, 35577,3058,2809, 2810,3059,2810, 2819,3068,2819, 35579,3060,2811, 
5, // chain 306
2821,3070,2821, 2826,3075,2826, 2827,3076,2827, 
2828,3077,2828, 2820,3069,2820, 35597,3078,2829, 2819,3068,2819, 
3, // chain 307
2826,3075,2826, 2821,3070,2821, 2822,3071,2822, 
2823,3072,2823, 2824,3073,2824, 
11, // chain 308
2576,2762,2576, 2631,3079,2631, 2830,3080,2830, 
2574,2760,2574, 35599,3081,2831, 35334,2752,2566, 35333,2751,2565, 35399,3079,2631, 2629,3082,2629, 2564,2750,2564, 35392,3083,2624, 2323,2732,2323, 2548,2733,2548, 
1, // chain 309
2578,2764,2578, 2631,3079,2631, 2576,2762,2576, 
5, // chain 310
2832,3084,2832, 2788,3085,2788, 2786,3086,2786, 
2833,3087,2833, 35552,3088,2784, 2545,3089,2545, 35553,3090,2785, 
10, // chain 311
2788,3085,2788, 2832,3084,2832, 2834,3091,2834, 
2790,3092,2790, 35603,3093,2835, 35604,3094,2836, 35600,3084,2832, 2837,3095,2837, 35606,3096,2838, 35601,3087,2833, 2522,3097,2522, 35313,3089,2545, 
13, // chain 312
2835,3093,2835, 2836,3094,2836, 2839,3098,2839, 
2840,3099,2840, 35609,3100,2841, 34206,1520,1438, 35610,3101,2842, 35604,3094,2836, 2843,3102,2843, 35605,3095,2837, 2667,2903,2667, 35606,3096,2838, 2844,3103,2844, 35272,3104,2504, 35290,3097,2522, 
3, // chain 313
2666,2901,2666, 2667,2903,2667, 2844,3103,2844, 
2504,3104,2504, 2493,2900,2493, 
2, // chain 314
2668,2904,2668, 1226,1285,1226, 2843,3102,2843, 
2667,2903,2667, 
1, // chain 315
1225,1284,1225, 1226,1285,1226, 2668,2904,2668, 
3, // chain 316
1226,1285,1226, 1437,1519,1437, 2843,3102,2843, 
35610,3101,2842, 34206,1520,1438, 
6, // chain 317
2845,3105,2845, 1455,1540,1455, 2846,3106,2846, 
2847,3107,2847, 35616,3108,2848, 35617,3109,2849, 34224,1541,1456, 34223,1540,1455, 
16, // chain 318
1454,1539,1454, 1455,1540,1455, 2845,3105,2845, 
1477,3110,1477, 34246,3111,1478, 34249,3112,1481, 35615,3107,2847, 1483,3113,1483, 35618,3114,2850, 35619,3115,2851, 35616,3108,2848, 2852,3116,2852, 35621,3117,2853, 35617,3109,2849, 1468,1558,1468, 34235,1557,1467, 34224,1541,1456, 1457,1542,1457, 
6, // chain 319
2853,3117,2853, 1468,1558,1468, 1469,1559,1469, 
2854,3118,2854, 34238,1560,1470, 2855,3119,2855, 35403,2857,2635, 34239,1561,1471, 
2, // chain 320
2854,3118,2854, 2856,3120,2856, 2852,3116,2852, 
2853,3117,2853, 
7, // chain 321
2856,3120,2856, 2854,3118,2854, 2855,3119,2855, 
2857,3121,2857, 35626,3122,2858, 35403,2857,2635, 2636,2858,2636, 2638,2860,2638, 35405,2859,2637, 
10, // chain 322
2859,3123,2859, 2800,3124,2800, 2851,3115,2851, 
2852,3116,2852, 2860,3125,2860, 35624,3120,2856, 2861,3126,2861, 35625,3121,2857, 2640,2862,2640, 35407,2861,2639, 35626,3122,2858, 2638,2860,2638, 
7, // chain 323
2801,3127,2801, 2800,3124,2800, 2859,3123,2859, 
2802,3128,2802, 35628,3125,2860, 2769,3129,2769, 35629,3126,2861, 2640,2862,2640, 2641,2863,2641, 
4, // chain 324
2851,3115,2851, 2800,3124,2800, 2850,3114,2850, 
35566,3130,2798, 1483,3113,1483, 34253,3131,1485, 
6, // chain 325
1439,1521,1439, 1440,1522,1440, 2862,3132,2862, 
2841,3100,2841, 35631,3133,2863, 34247,1571,1479, 34209,1523,1441, 34208,1522,1440, 
1, // chain 326
1439,1521,1439, 2841,3100,2841, 1438,1520,1438, 
9, // chain 327
1482,1574,1482, 2794,3134,2794, 2864,3135,2864, 
1480,1572,1480, 35631,3133,2863, 35609,3100,2841, 35608,3099,2840, 35562,3134,2794, 2792,3136,2792, 2835,3093,2835, 35558,3092,2790, 
1, // chain 328
1484,1576,1484, 2794,3134,2794, 1482,1574,1482, 
5, // chain 329
2814,3063,2814, 2815,3064,2815, 2813,3062,2813, 
35584,3065,2816, 2812,3061,2812, 35586,3067,2818, 35585,3066,2817, 
6, // chain 330
1665,1778,1665, 1669,1782,1669, 1670,1783,1670, 
1671,1784,1671, 1679,1792,1679, 34440,1785,1672, 1673,1786,1673, 1674,1787,1674, 
3, // chain 331
1669,1782,1669, 1665,1778,1665, 1666,1779,1666, 
1668,1781,1668, 34435,1780,1667, 
10, // chain 332
2207,2350,2207, 2865,3137,2865, 2866,3138,2866, 
2867,3139,2867, 35636,3140,2868, 35637,3141,2869, 35633,3137,2865, 2870,3142,2870, 34978,2353,2210, 34977,2352,2209, 34976,2351,2208, 34975,2350,2207, 
14, // chain 333
2870,3142,2870, 2210,2353,2210, 2211,2354,2211, 
2871,3143,2871, 34788,2150,2020, 2021,2151,2021, 2872,3144,2872, 34790,2152,2022, 2023,2153,2023, 2873,3145,2873, 34792,2154,2024, 2874,3146,2874, 34793,2155,2025, 2875,3147,2875, 33751,3148,983, 33753,2156,985, 
6, // chain 334
2871,3143,2871, 2872,3144,2872, 2876,3149,2876, 
2870,3142,2870, 35637,3141,2869, 35645,3150,2877, 35641,3145,2873, 35640,3144,2872, 
15, // chain 335
952,3151,952, 950,2343,950, 2201,2344,2201, 
2878,3152,2878, 34970,2345,2202, 2879,3153,2879, 34971,2346,2203, 2880,3154,2880, 34972,2347,2204, 2881,3155,2881, 35650,3156,2882, 34973,2348,2205, 2883,3157,2883, 35652,3158,2884, 35635,3139,2867, 34974,2349,2206, 2207,2350,2207, 
30, // chain 336
2875,3147,2875, 983,3148,983, 981,3159,981, 
2885,3160,2885, 33747,3161,979, 2886,3162,2886, 33745,3163,977, 2887,3164,2887, 33743,3165,975, 2888,3166,2888, 33741,3167,973, 2889,3168,2889, 33739,3169,971, 2890,3170,2890, 33737,3171,969, 2891,3172,2891, 33735,3173,967, 2892,3174,2892, 33734,3175,966, 
964,3176,964, 2893,3177,2893, 33730,3178,962, 2894,3179,2894, 33728,3180,960, 2895,3181,2895, 33726,3182,958, 2896,3183,2896, 33724,3184,956, 2897,3185,2897, 33722,3186,954, 2878,3152,2878, 33720,3151,952, 
10, // chain 337
2885,3160,2885, 2898,3187,2898, 2899,3188,2899, 
2875,3147,2875, 35642,3146,2874, 35645,3150,2877, 35668,3189,2900, 35666,3187,2898, 2901,3190,2901, 35670,3191,2902, 35654,3162,2886, 35653,3160,2885, 
22, // chain 338
2903,3192,2903, 2904,3193,2904, 2905,3194,2905, 
2906,3195,2906, 35675,3196,2907, 35676,3197,2908, 35669,3190,2901, 35672,3193,2904, 2900,3189,2900, 35637,3141,2869, 35636,3140,2868, 35671,3192,2903, 2884,3158,2884, 35651,3157,2883, 35674,3195,2906, 2909,3198,2909, 35678,3199,2910, 35675,3196,2907, 2911,3200,2911, 
35680,3201,2912, 35676,3197,2908, 2913,3202,2913, 35670,3191,2902, 35669,3190,2901, 
15, // chain 339
2883,3157,2883, 2909,3198,2909, 2882,3156,2882, 
35682,3203,2914, 35683,3204,2915, 35684,3205,2916, 35685,3206,2917, 35678,3199,2910, 2918,3207,2918, 35679,3200,2911, 2912,3201,2912, 2919,3208,2919, 35681,3202,2913, 2888,3166,2888, 35655,3164,2887, 35670,3191,2902, 2886,3162,2886, 
13, // chain 340
2920,3209,2920, 2921,3210,2921, 2922,3211,2922, 
2895,3181,2895, 35662,3179,2894, 35691,3212,2923, 35683,3204,2915, 35689,3210,2921, 2914,3203,2914, 35692,3213,2924, 35693,3214,2925, 35688,3209,2920, 2926,3215,2926, 35664,3183,2896, 35663,3181,2895, 
5, // chain 341
2880,3154,2880, 2881,3155,2881, 2925,3214,2925, 
2926,3215,2926, 2879,3153,2879, 35665,3185,2897, 35664,3183,2896, 
1, // chain 342
2897,3185,2897, 2878,3152,2878, 2879,3153,2879, 
2, // chain 343
2889,3168,2889, 2927,3216,2927, 2919,3208,2919, 
2888,3166,2888, 
8, // chain 344
2927,3216,2927, 2889,3168,2889, 2890,3170,2890, 
2928,3217,2928, 35659,3172,2891, 2929,3218,2929, 35660,3174,2892, 2893,3177,2893, 2923,3212,2923, 35662,3179,2894, 
7, // chain 345
2918,3207,2918, 2919,3208,2919, 2927,3216,2927, 
2917,3206,2917, 35696,3217,2928, 2916,3205,2916, 35697,3218,2929, 2923,3212,2923, 2915,3204,2915, 
1, // chain 346
57,57,57, 18,18,18, 19,19,19, 
1, // chain 347
131,131,131, 33,33,33, 34,34,34, 
1, // chain 348
233,233,233, 59,59,59, 62,62,62, 
4, // chain 349
50,50,50, 51,51,51, 391,391,391, 
33088,320,320, 331,331,331, 33089,321,321, 
1, // chain 350
206,206,206, 207,207,207, 361,361,361, 
2, // chain 351
391,391,391, 364,364,364, 50,50,50, 
32817,49,49, 
3, // chain 352
500,500,500, 501,501,501, 1063,1106,1063, 
1064,1107,1064, 499,499,499, 
2, // chain 353
528,528,528, 439,439,439, 440,440,440, 
516,516,516, 
1, // chain 354
438,438,438, 439,439,439, 528,528,528, 
1, // chain 355
526,526,526, 527,527,527, 529,529,529, 
1, // chain 356
292,553,292, 293,538,293, 538,539,538, 
1, // chain 357
318,3219,318, 319,593,319, 587,594,587, 
4, // chain 358
634,642,634, 650,658,650, 1173,1225,1173, 
831,868,831, 33933,1217,1165, 830,867,830, 
1, // chain 359
635,643,635, 650,658,650, 634,642,634, 
1, // chain 360
233,850,233, 234,848,234, 821,849,821, 
2, // chain 361
878,1301,878, 832,869,832, 828,865,828, 
33595,864,827, 
2, // chain 362
573,578,573, 826,863,826, 572,577,572, 
33603,872,835, 
2, // chain 363
860,899,860, 861,900,861, 901,942,901, 
33657,930,889, 
2, // chain 364
220,220,220, 1097,1140,1097, 219,219,219, 
33572,1141,804, 
1, // chain 365
651,659,651, 652,660,652, 1188,1240,1188, 
1, // chain 366
1037,1079,1037, 221,221,221, 222,222,222, 
1, // chain 367
845,1272,845, 1221,1280,1221, 1213,1271,1213, 
3, // chain 368
830,867,830, 1166,1218,1166, 829,866,829, 
34005,1296,1237, 1238,1297,1238, 
2, // chain 369
1344,1407,1344, 1345,1408,1345, 1466,3220,1466, 
1374,1439,1374, 
1, // chain 370
1359,1422,1359, 1360,1423,1360, 1370,1433,1370, 
1, // chain 371
1412,1486,1412, 1413,1484,1413, 1417,1485,1417, 
1, // chain 372
904,945,904, 915,956,915, 903,944,903, 
1, // chain 373
904,945,904, 892,933,892, 893,934,893, 
2, // chain 374
867,907,867, 913,954,913, 1420,1492,1420, 
34187,1490,1419, 
1, // chain 375
1411,1498,1411, 1416,1483,1416, 1413,1484,1413, 
1, // chain 376
914,955,914, 1416,1483,1416, 913,954,913, 
1, // chain 377
1477,3110,1477, 1453,1538,1453, 1454,1539,1454, 
2, // chain 378
1083,1126,1083, 200,200,200, 370,370,370, 
32969,201,201, 
1, // chain 379
494,494,494, 1708,1821,1708, 493,493,493, 
1, // chain 380
1075,1118,1075, 1076,1119,1076, 1074,1117,1074, 
1, // chain 381
1845,1968,1845, 1846,1969,1846, 1927,2057,1927, 
4, // chain 382
1983,2113,1983, 1979,2109,1979, 2029,2163,2029, 
34748,2110,1980, 2007,2137,2007, 34749,2111,1981, 
1, // chain 383
1981,2111,1981, 1982,2112,1982, 1996,2126,1996, 
2, // chain 384
1898,2023,1898, 1895,2020,1895, 1897,2022,1897, 
34664,2021,1896, 
1, // chain 385
2083,2217,2083, 2195,2329,2195, 2101,2235,2101, 
1, // chain 386
2013,2143,2013, 2014,2144,2014, 2163,2297,2163, 
1, // chain 387
2053,2187,2053, 2054,2188,2054, 2229,2374,2229, 
1, // chain 388
2012,2142,2012, 2194,2328,2194, 2011,2141,2011, 
1, // chain 389
1951,2081,1951, 1976,2106,1976, 1950,2080,1950, 
1, // chain 390
2052,2186,2052, 2050,2184,2050, 2051,2185,2051, 
1, // chain 391
1209,1261,1209, 2270,2426,2270, 1208,1260,1208, 
1, // chain 392
1206,1258,1206, 2266,2422,2266, 1205,1257,1205, 
2, // chain 393
1770,3221,1770, 1768,2644,1768, 2481,2645,2481, 
1772,2646,1772, 
2, // chain 394
2325,2481,2325, 2326,2482,2326, 2550,3222,2550, 
35095,2483,2327, 
1, // chain 395
922,2817,922, 920,2780,920, 2587,2781,2587, 
2, // chain 396
2270,3223,2270, 1209,2823,1209, 2614,2834,2614, 
35379,2825,2611, 
1, // chain 397
1473,1563,1473, 1474,1564,1474, 2319,2475,2319, 
2, // chain 398
1476,1566,1476, 1182,1234,1182, 1183,1235,1183, 
2337,2493,2337, 
1, // chain 399
2606,2814,2606, 2607,2815,2607, 2645,2867,2645, 
1, // chain 400
1835,1958,1835, 2650,2876,2650, 1834,1957,1834, 
1, // chain 401
2649,2875,2649, 2650,2876,2650, 2654,2880,2654, 
1, // chain 402
2251,2406,2251, 2252,2407,2252, 2659,2888,2659, 
3, // chain 403
1201,1253,1201, 1202,1254,1202, 1200,1252,1200, 
35072,2460,2304, 1199,1251,1199, 
4, // chain 404
2333,2489,2333, 2334,2490,2334, 1195,1247,1195, 
33962,1246,1194, 35103,2491,2335, 1193,1245,1193, 
2, // chain 405
2614,2834,2614, 2615,2835,2615, 2270,3223,2270, 
35037,2905,2269, 
1, // chain 406
2634,3000,2634, 2579,2984,2579, 2746,2985,2746, 
4, // chain 407
2566,2752,2566, 2567,2753,2567, 2831,3081,2831, 
35336,2754,2568, 2571,2757,2571, 35337,2755,2569, 
2, // chain 408
2831,3081,2831, 2571,2757,2571, 2574,2760,2574, 
35340,2758,2572, 
1, // chain 409
2785,3224,2785, 2544,2727,2544, 2545,2728,2545, 
1, // chain 410
1480,1572,1480, 2863,3133,2863, 1479,1571,1479, 
1, // chain 411
2187,2321,2187, 2019,2149,2019, 2020,2150,2020, 
1, // chain 412
2900,3189,2900, 2869,3141,2869, 2877,3150,2877, 
1, // chain 413
2873,3145,2873, 2874,3146,2874, 2877,3150,2877, 
1, // chain 414
2867,3139,2867, 2868,3140,2868, 2884,3158,2884, 
3, // chain 415
2882,3156,2882, 2914,3203,2914, 2881,3155,2881, 
35692,3213,2924, 2925,3214,2925, 

 0};


// mesh info for object spot (with tag [])
const tgx::Mesh3D<tgx::RGB565> spot = 
    {
    1, // version/id
    
    2930, // number of vertices
    3225, // number of texture coords
    2930, // number of normal vectors
    5856, // number of triangles
    20481, // size of face
    
    spot_vert_array, // array of vertices
    spot_tex_array, // array of texture coords
    spot_norm_array, // array of normal vectors        
    spot_face, // array of face vertex indexes   
    
    &spot_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    nullptr, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.5489836772494935, 0.5489836772494935, 
    -0.9840043913851084, 0.9840043913851084, 
    -1.0, 1.0
    },
    
    "spot" // model name    
    };
    
                
/** end of spot.h */
    
    
    