// 3D model [teapot]
//
// - vertices   : 1202
// - textures   : 0
// - normals    : 1202
// - triangles  : 2256
//
// - memory size: 37kb
//
// - model bounding box: [-1.0,1.0]x[-0.49,0.49]x[-0.62,0.62]
//
// object [teapot] (tagged []) with 2256 triangles (55 chains)

#pragma once

#include <tgx.h>


// vertex array: 14kb.
const tgx::fVec3 teapot_vert_array[1202] PROGMEM = {
{-0.06682033025228512,-0.48991932661755033,0.0},
{0.11502030443431427,-0.48808345114726664,-0.050608199849758076},
{0.12165179022743144,-0.48808314008737674,-0.0},
{0.11502030443431427,-0.48808282902748684,0.050608199849758076},
{0.25115131041755123,-0.4830069537438391,-0.0},
{0.23996404147672573,-0.483007264803729,-0.0853815849434571},
{0.09624286311965075,-0.48808345114726664,-0.09577160738642815},
{0.06699483485052796,-0.4880837622071566,-0.13381516510281308},
{0.02895127713414303,-0.4880837622071566,-0.16306319337193587},
{-0.01621213040252704,-0.4880837622071566,-0.1818406346865994},
{-0.06682033025228512,-0.4880837622071566,-0.18847212047971657},
{-0.1174285301020432,-0.4880837622071566,-0.1818406346865994},
{-0.16259193763871327,-0.4880837622071566,-0.16306319337193587},
{-0.2006354953550982,-0.4880837622071566,-0.13381516510281308},
{-0.229883523624221,-0.48808345114726664,-0.09577160738642815},
{-0.2486609649388845,-0.48808345114726664,-0.050608199849758076},
{-0.2552924507320017,-0.48808314008737674,-0.0},
{-0.2486609649388845,-0.48808282902748684,0.050608199849758076},
{-0.229883523624221,-0.48808282902748684,0.09577160738642815},
{-0.2006354953550982,-0.4880825179675969,0.13381516510281308},
{-0.16259193763871327,-0.4880825179675969,0.16306319337193587},
{-0.1174285301020432,-0.4880825179675969,0.1818406346865994},
{-0.06682033025228512,-0.4880825179675969,0.18847212047971657},
{-0.01621213040252704,-0.4880825179675969,0.1818406346865994},
{0.02895127713414303,-0.4880825179675969,0.16306319337193587},
{0.06699483485052796,-0.4880825179675969,0.13381516510281308},
{0.09624286311965075,-0.48808282902748684,0.09577160738642815},
{0.23996404147672573,-0.48300664268394916,0.0853815849434571},
{0.3326956605590058,-0.47533839427774227,-0.0},
{0.318638864133706,-0.4753387053376322,-0.10727771271441748},
{0.20828476910802024,-0.483007575863619,-0.16157694921791768},
{0.15894009453110058,-0.4830078869235088,-0.2257604247833857},
{0.09475661896563256,-0.4830078869235088,-0.27510509936030536},
{0.018561254691171977,-0.4830078869235088,-0.30678437172901085},
{-0.06682033025228512,-0.4830081979833987,-0.31797164066983635},
{-0.15220191519574222,-0.4830078869235088,-0.30678437172901085},
{-0.2283972794702028,-0.4830078869235088,-0.27510509936030536},
{-0.2925807550356708,-0.4830078869235088,-0.2257604247833857},
{-0.3419254296125905,-0.483007575863619,-0.16157694921791768},
{-0.37360470198129603,-0.483007264803729,-0.0853815849434571},
{-0.3847919709221215,-0.4830069537438391,-0.0},
{-0.37360470198129603,-0.48300664268394916,0.0853815849434571},
{-0.3419254296125905,-0.48300633162405926,0.16157694921791768},
{-0.2925807550356708,-0.48300602056416936,0.2257604247833857},
{-0.2283972794702028,-0.48300602056416936,0.27510509936030536},
{-0.15220191519574222,-0.48300602056416936,0.30678437172901085},
{-0.06682033025228512,-0.4830057095042794,0.31797164066983635},
{0.018561254691171977,-0.48300602056416936,0.30678437172901085},
{0.09475661896563256,-0.48300602056416936,0.27510509936030536},
{0.15894009453110058,-0.48300602056416936,0.2257604247833857},
{0.20828476910802024,-0.48300633162405926,0.16157694921791768},
{0.318638864133706,-0.47533808321785237,0.10727771271441748},
{0.3773047593718457,-0.4657257104996711,-0.0},
{0.36167711050247064,-0.465726021559561,-0.11925569589540923},
{0.2788356406200668,-0.47533901639752213,-0.20301417033328514},
{0.21683704972136814,-0.47533932745741203,-0.28365737997365326},
{0.13619384008100002,-0.47533963851730193,-0.34565597087235195},
{0.04045738246213236,-0.47533963851730193,-0.38545919438599113},
{-0.06682033025228512,-0.47533963851730193,-0.3995159908112909},
{-0.17409804296670262,-0.47533963851730193,-0.38545919438599113},
{-0.2698345005855703,-0.47533963851730193,-0.34565597087235195},
{-0.3504777102259383,-0.47533932745741203,-0.28365737997365326},
{-0.41247630112463707,-0.47533901639752213,-0.20301417033328514},
{-0.45227952463827625,-0.4753387053376322,-0.10727771271441748},
{-0.46633632106357603,-0.47533839427774227,-0.0},
{-0.45227952463827625,-0.47533808321785237,0.10727771271441748},
{-0.41247630112463707,-0.4753377721579624,0.20301417033328514},
{-0.3504777102259383,-0.47533746109807257,0.28365737997365326},
{-0.2698345005855703,-0.47533715003818267,0.34565597087235195},
{-0.17409804296670262,-0.47533715003818267,0.38545919438599113},
{-0.06682033025228512,-0.47533715003818267,0.3995159908112909},
{0.04045738246213236,-0.47533715003818267,0.38545919438599113},
{0.13619384008100002,-0.47533715003818267,0.34565597087235195},
{0.21683704972136814,-0.47533746109807257,0.28365737997365326},
{0.2788356406200668,-0.4753377721579624,0.20301417033328514},
{0.36167711050247064,-0.46572539943978114,0.11925569589540923},
{0.3959901269590941,-0.4548171512202102,-0.0},
{0.37970614172199646,-0.4548174622801001,-0.12427309191975278},
{0.31742884116193315,-0.46572664367934086,-0.22568110451145715},
{0.24850730135326607,-0.46572695473923076,-0.31532763160555116},
{0.15886077425917203,-0.46572695473923076,-0.38424917141421827},
{0.0524353656431241,-0.4657272657991206,-0.42849744075475577},
{-0.06682033025228512,-0.4657272657991206,-0.44412508962413083},
{-0.18607602614769433,-0.4657272657991206,-0.42849744075475577},
{-0.29250143476374224,-0.46572695473923076,-0.38424917141421827},
{-0.3821479618578363,-0.46572695473923076,-0.31532763160555116},
{-0.4510695016665034,-0.46572664367934086,-0.22568110451145715},
{-0.4953177710070409,-0.465726021559561,-0.11925569589540923},
{-0.510945419876416,-0.4657257104996711,-0.0},
{-0.4953177710070409,-0.46572539943978114,0.11925569589540923},
{-0.4510695016665034,-0.4657247773200013,0.22568110451145715},
{-0.3821479618578363,-0.4657244662601114,0.31532763160555116},
{-0.29250143476374224,-0.4657244662601114,0.38424917141421827},
{-0.18607602614769433,-0.46572415520022153,0.42849744075475577},
{-0.06682033025228512,-0.46572415520022153,0.44412508962413083},
{0.0524353656431241,-0.46572415520022153,0.42849744075475577},
{0.15886077425917203,-0.4657244662601114,0.38424917141421827},
{0.24850730135326607,-0.4657244662601114,0.31532763160555116},
{0.31742884116193315,-0.4657247773200013,0.22568110451145715},
{0.37970614172199646,-0.45481684016032026,0.12427309191975278},
{0.39976950462157235,-0.4432603431301646,-3.11059889915905e-07},
{0.3833517636318109,-0.4432606541900545,-0.1252883914004383},
{0.33359462364086273,-0.45481808439988,-0.2351758965912502},
{0.26177400565817943,-0.4548183954597699,-0.32859433591046455},
{0.1683555663389651,-0.45481870651965983,-0.40041495389314785},
{0.05745276166746766,-0.45481870651965983,-0.4465264719742816},
{-0.06682033025228512,-0.45481870651965983,-0.4628104572113792},
{-0.19109342217203792,-0.45481870651965983,-0.4465264719742816},
{-0.30199622684353533,-0.45481870651965983,-0.40041495389314785},
{-0.3954146661627497,-0.4548183954597699,-0.32859433591046455},
{-0.46723528414543297,-0.45481808439988,-0.2351758965912502},
{-0.5133468022265667,-0.4548174622801001,-0.12427309191975278},
{-0.5296307874636643,-0.4548171512202102,-0.0},
{-0.5133468022265667,-0.45481684016032026,0.12427309191975278},
{-0.46723528414543297,-0.4548162180405404,0.2351758965912502},
{-0.3954146661627497,-0.45481590698065055,0.32859433591046455},
{-0.30199622684353533,-0.45481559592076065,0.40041495389314785},
{-0.19109342217203792,-0.45481559592076065,0.4465264719742816},
{-0.06682033025228512,-0.45481559592076065,0.4628104572113792},
{0.05745276166746766,-0.45481559592076065,0.4465264719742816},
{0.1683555663389651,-0.45481559592076065,0.40041495389314785},
{0.26177400565817943,-0.45481590698065055,0.32859433591046455},
{0.33359462364086273,-0.4548162180405404,0.2351758965912502},
{0.3833517636318109,-0.44326003207027465,0.12528776928065846},
{0.4112911629440575,-0.42759941085256853,-3.11059889915905e-07},
{0.39446904409740535,-0.42760003297234833,-0.12838188200565195},
{0.336866973682778,-0.44326127630983436,-0.23709700247137083},
{0.26445845250815364,-0.44326158736972426,-0.3312787827604388},
{0.17027636115919578,-0.4432618984296142,-0.40368730393506314},
{0.058467750088263264,-0.4432618984296142,-0.450172093884096},
{-0.06682033025228512,-0.44326220948950407,-0.46658983487385747},
{-0.1921084105928335,-0.4432618984296142,-0.450172093884096},
{-0.30391702166376605,-0.4432618984296142,-0.40368730393506314},
{-0.39809911301272394,-0.44326158736972426,-0.3312787827604388},
{-0.47050763418734826,-0.44326127630983436,-0.23709700247137083},
{-0.5169924241363811,-0.4432606541900545,-0.1252883914004383},
{-0.5334101651261426,-0.4432603431301646,-3.11059889915905e-07},
{-0.5169924241363811,-0.44326003207027465,0.12528776928065846},
{-0.47050763418734826,-0.4432594099504948,0.23709638035159103},
{-0.39809911301272394,-0.44325909889060494,0.3312787827604388},
{-0.30391702166376605,-0.44325878783071504,0.40368730393506314},
{-0.1921084105928335,-0.44325878783071504,0.450172093884096},
{-0.06682033025228512,-0.4432584767708251,0.46658983487385747},
{0.058467750088263264,-0.44325878783071504,0.450172093884096},
{0.17027636115919578,-0.44325878783071504,0.40368730393506314},
{0.26445845250815364,-0.44325909889060494,0.3312787827604388},
{0.336866973682778,-0.4432594099504948,0.23709638035159103},
{0.39446904409740535,-0.4275987887327887,0.12838125988587212},
{0.4400921981513711,-0.40351373251649003,-3.11059889915905e-07},
{0.42225602406359314,-0.4035143546362699,-0.13611576404863113},
{0.34683333255568366,-0.42760034403223823,-0.2429514606594781},
{0.27263932761294196,-0.4276006550921282,-0.3394596578652271},
{0.17613081934730307,-0.4276009661520181,-0.4136536628079688},
{0.06156124069347693,-0.4276009661520181,-0.4612893743496905},
{-0.06682033025228512,-0.427601277211908,-0.4781114931963426},
{-0.19520190119804715,-0.4276009661520181,-0.4612893743496905},
{-0.3097714798518733,-0.4276009661520181,-0.4136536628079688},
{-0.4062799881175122,-0.4276006550921282,-0.3394596578652271},
{-0.4804739930602539,-0.42760034403223823,-0.2429514606594781},
{-0.5281097046019756,-0.42760003297234833,-0.12838188200565195},
{-0.5449318234486277,-0.42759941085256853,-3.11059889915905e-07},
{-0.5281097046019756,-0.4275987887327887,0.12838125988587212},
{-0.4804739930602539,-0.42759847767289877,0.24295083853969826},
{-0.4062799881175122,-0.42759816661300887,0.3394596578652271},
{-0.3097714798518733,-0.4275978555531189,0.4136536628079688},
{-0.19520190119804715,-0.4275978555531189,0.4612893743496905},
{-0.06682033025228512,-0.427597544493229,0.4781114931963426},
{0.06156124069347693,-0.4275978555531189,0.4612893743496905},
{0.17613081934730307,-0.4275978555531189,0.4136536628079688},
{0.27263932761294196,-0.42759816661300887,0.3394596578652271},
{0.34683333255568366,-0.42759847767289877,0.24295083853969826},
{0.42225602406359314,-0.40351311039671023,0.13611514192885127},
{0.4775344771005486,-0.3703556814311243,-3.11059889915905e-07},
{0.45838251967842636,-0.37035630355090415,-0.14616953075060307},
{0.3717523403368468,-0.40351466569615985,-0.2575868284800214},
{0.2930884047760136,-0.40351497675604975,-0.35990873502829873},
{0.19076618716784638,-0.40351528781593965,-0.4385726705891319},
{0.06929512273645606,-0.4035155988758296,-0.48907635431587826},
{-0.06682033025228512,-0.4035155988758296,-0.5069125284036562},
{-0.20293578324102632,-0.4035155988758296,-0.48907635431587826},
{-0.3244068476724166,-0.40351528781593965,-0.4385726705891319},
{-0.42672906528058385,-0.40351497675604975,-0.35990873502829873},
{-0.505393000841417,-0.40351466569615985,-0.2575868284800214},
{-0.5558966845681633,-0.4035143546362699,-0.13611576404863113},
{-0.5737328586559414,-0.40351373251649003,-3.11059889915905e-07},
{-0.5558966845681633,-0.40351311039671023,0.13611514192885127},
{-0.505393000841417,-0.4035127993368203,0.2575862063602416},
{-0.42672906528058385,-0.4035124882769304,0.35990873502829873},
{-0.3244068476724166,-0.40351217721704047,0.4385726705891319},
{-0.20293578324102632,-0.40351186615715057,0.48907635431587826},
{-0.06682033025228512,-0.40351186615715057,0.5069125284036562},
{0.06929512273645606,-0.40351186615715057,0.48907635431587826},
{0.19076618716784638,-0.40351217721704047,0.4385726705891319},
{0.2930884047760136,-0.4035124882769304,0.35990873502829873},
{0.3717523403368468,-0.4035127993368203,0.2575862063602416},
{0.45838251967842636,-0.37035505931134455,0.14616890863082324},
{0.5149767560497261,-0.3274770087858866,-6.2211977983181e-07},
{0.49450590469436034,-0.3274776309056664,-0.15622391957235487},
{0.4041461172726891,-0.3703566146107941,-0.2766131177066177},
{0.3196715829682268,-0.37035723673057397,-0.3864919132205119},
{0.20979247639444262,-0.37035754779046387,-0.47096644752497424},
{0.07934888943842805,-0.37035754779046387,-0.5252028499307115},
{-0.06682033025228512,-0.37035754779046387,-0.5443548073528337},
{-0.21298954994299832,-0.37035754779046387,-0.5252028499307115},
{-0.3434331368990129,-0.37035754779046387,-0.47096644752497424},
{-0.453312243472797,-0.37035723673057397,-0.3864919132205119},
{-0.5377867777772594,-0.3703566146107941,-0.2766131177066177},
{-0.5920231801829966,-0.37035630355090415,-0.14616953075060307},
{-0.6111751376051189,-0.3703556814311243,-3.11059889915905e-07},
{-0.5920231801829966,-0.37035505931134455,0.14616890863082324},
{-0.5377867777772594,-0.3703547482514546,0.2766124955868378},
{-0.453312243472797,-0.3703541261316748,0.3864919132205119},
{-0.3434331368990129,-0.37035381507178483,0.47096644752497424},
{-0.21298954994299832,-0.37035381507178483,0.5252028499307115},
{-0.06682033025228512,-0.37035381507178483,0.5443548073528337},
{0.07934888943842805,-0.37035381507178483,0.5252028499307115},
{0.20979247639444262,-0.37035381507178483,0.47096644752497424},
{0.3196715829682268,-0.3703541261316748,0.3864919132205119},
{0.4041461172726891,-0.3703547482514546,0.2766124955868378},
{0.49450590469436034,-0.3274763866661068,0.1562226753327952},
{0.5437777912570397,-0.2742294657701921,-6.2211977983181e-07},
{0.5222959952594473,-0.2742300878899719,-0.16395811267522392},
{0.43654300480743063,-0.3274782530254463,-0.29563971799310385},
{0.34625476116044007,-0.32747856408533615,-0.4130750914127252},
{0.22881876562103887,-0.3274788751452261,-0.5033633350597158},
{0.08940296720028994,-0.32747918620511607,-0.5613262349466455},
{-0.06682033025228512,-0.32747918620511607,-0.5817970863020112},
{-0.22304362770486016,-0.32747918620511607,-0.5613262349466455},
{-0.36245942612560905,-0.3274788751452261,-0.5033633350597158},
{-0.4798954216650103,-0.32747856408533615,-0.4130750914127252},
{-0.5701836653120009,-0.3274782530254463,-0.29563971799310385},
{-0.6281465651989306,-0.3274776309056664,-0.15622391957235487},
{-0.6486174165542964,-0.3274770087858866,-6.2211977983181e-07},
{-0.6281465651989306,-0.3274763866661068,0.1562226753327952},
{-0.5701836653120009,-0.3274760756062169,0.2956384737535442},
{-0.4798954216650103,-0.32747545348643703,0.4130750914127252},
{-0.36245942612560905,-0.32747514242654713,0.5033633350597158},
{-0.22304362770486016,-0.32747483136665717,0.5613262349466455},
{-0.06682033025228512,-0.32747483136665717,0.5817970863020112},
{0.08940296720028994,-0.32747483136665717,0.5613262349466455},
{0.22881876562103887,-0.32747514242654713,0.5033633350597158},
{0.34625476116044007,-0.32747545348643703,0.4130750914127252},
{0.43654300480743063,-0.3274760756062169,0.2956384737535442},
{0.5222959952594473,-0.2742288436504122,0.16395624631588446},
{0.5552994495795248,-0.20996542569323584,-9.33179669747715e-07},
{0.5334101651261426,-0.2099660478130157,-0.1670516032804376},
{0.46146201258859376,-0.27423071000975174,-0.310275707933427},
{0.3667038383235116,-0.27423102106964165,-0.43352416857579673},
{0.24345444450147213,-0.27423133212953155,-0.5282823428408788},
{0.09713684924326907,-0.2742316431894215,-0.5891163255117324},
{-0.06682033025228512,-0.2742316431894215,-0.6105981215093249},
{-0.2307775097478393,-0.2742316431894215,-0.5891163255117324},
{-0.3770951050060424,-0.27423133212953155,-0.5282823428408788},
{-0.5003444988280819,-0.27423102106964165,-0.43352416857579673},
{-0.595102673093164,-0.27423071000975174,-0.310275707933427},
{-0.6559366557640176,-0.2742300878899719,-0.16395811267522392},
{-0.67741845176161,-0.2742294657701921,-6.2211977983181e-07},
{-0.6559366557640176,-0.2742288436504122,0.16395624631588446},
{-0.595102673093164,-0.2742282215306324,0.3102738415740875},
{-0.5003444988280819,-0.27422791047074246,0.43352416857579673},
{-0.3770951050060424,-0.27422759941085256,0.5282823428408788},
{-0.2307775097478393,-0.27422728835096266,0.5891163255117324},
{-0.06682033025228512,-0.27422728835096266,0.6105981215093249},
{0.09713684924326907,-0.27422728835096266,0.5891163255117324},
{0.24345444450147213,-0.27422759941085256,0.5282823428408788},
{0.3667038383235116,-0.27422791047074246,0.43352416857579673},
{0.46146201258859376,-0.2742282215306324,0.3102738415740875},
{0.5334101651261426,-0.20996480357345604,0.16704973692109812},
{0.5275062484155387,-0.1381416971116534,0.16540609646278245},
{0.5491777909459798,-0.1381416971116534,-1.24423955966362e-06},
{0.5275062484155387,-0.1381416971116534,-0.16540858494190178},
{0.46613413213513066,-0.1381416971116534,-0.3130195672223752},
{0.47142837146149935,-0.2099666699327955,-0.3161301661215342},
{0.37488471342829993,-0.20996698099268543,-0.44170504368058505},
{0.2493098358692491,-0.20996729205257536,-0.5382487017137845},
{0.10023033984848274,-0.20996760311246523,-0.6002304953784278},
{-0.06682033025228512,-0.20996760311246523,-0.62211977983181},
{-0.23387100035305297,-0.20996760311246523,-0.6002304953784278},
{-0.38295049637381934,-0.20996729205257536,-0.5382487017137845},
{-0.5085253739328702,-0.20996698099268543,-0.44170504368058505},
{-0.6050690319660696,-0.2099666699327955,-0.3161301661215342},
{-0.6670508256307129,-0.2099660478130157,-0.1670516032804376},
{-0.6889401100840951,-0.20996542569323584,-9.33179669747715e-07},
{-0.6670508256307129,-0.20996480357345604,0.16704973692109812},
{-0.6050690319660696,-0.20996418145367618,0.3161301661215342},
{-0.5085253739328702,-0.20996387039378625,0.44170504368058505},
{-0.38295049637381934,-0.20996355933389635,0.5382487017137845},
{-0.23387100035305297,-0.20996324827400645,0.6002304953784278},
{-0.06682033025228512,-0.20996324827400645,0.62211977983181},
{0.10023033984848274,-0.20996324827400645,0.6002304953784278},
{0.2493098358692491,-0.20996355933389635,0.5382487017137845},
{0.37488471342829993,-0.20996387039378625,0.44170504368058505},
{0.47142837146149935,-0.20996418145367618,0.3161301661215342},
{0.46613413213513066,-0.1381416971116534,0.3130195672223752},
{0.45149254311678905,-0.0630767244771472,0.30441907232609033},
{0.5111787147938529,-0.0630767244771472,0.16086213359089094},
{0.5322592435334538,-0.0630767244771472,-1.555299449579525e-06},
{0.5111787147938529,-0.0630767244771472,-0.16086524418979006},
{0.45149254311678905,-0.0630767244771472,-0.30442218292498946},
{0.3585260738176225,-0.0630767244771472,-0.4253495146688068},
{0.37053920676617474,-0.13814480771055257,-0.43735953701845987},
{0.24619923697009005,-0.13814480771055257,-0.5329544623874157},
{0.098587010450057,-0.13814480771055257,-0.5943265786678238},
{-0.06682033025228512,-0.13814480771055257,-0.615998121198265},
{-0.23222767095462724,-0.13814480771055257,-0.5943265786678238},
{-0.3798398974746603,-0.13814480771055257,-0.5329544623874157},
{-0.5041798672707449,-0.13814480771055257,-0.43735953701845987},
{-0.5997747926397009,-0.1381416971116534,-0.3130195672223752},
{-0.6611469089201091,-0.1381416971116534,-0.16540858494190178},
{-0.6828184514505501,-0.1381416971116534,-1.24423955966362e-06},
{-0.6611469089201091,-0.1381416971116534,0.16540609646278245},
{-0.5997747926397009,-0.1381416971116534,0.3130195672223752},
{-0.5041798672707449,-0.1381385865127542,0.43735953701845987},
{-0.3798398974746603,-0.1381385865127542,0.5329544623874157},
{-0.23222767095462724,-0.1381385865127542,0.5943265786678238},
{-0.06682033025228512,-0.1381385865127542,0.615998121198265},
{0.098587010450057,-0.1381385865127542,0.5943265786678238},
{0.24619923697009005,-0.1381385865127542,0.5329544623874157},
{0.37053920676617474,-0.1381385865127542,0.43735953701845987},
{0.3585260738176225,-0.06307361387824802,0.42534329347100847},
{0.34037572924102943,0.014579377040358457,0.40719294889441543},
{0.4293792955426674,0.014582487639257636,0.29142952238309205},
{0.48651788672131996,0.014582487639257636,0.15399797500011667},
{0.5066963417801646,0.014579377040358457,-1.86635933949543e-06},
{0.48651788672131996,0.014579377040358457,-0.15400170771879565},
{0.4293792955426674,0.014582487639257636,-0.29143325510177104},
{0.34037572924102943,0.014579377040358457,-0.40719917009221374},
{0.23760029737325478,-0.06307983507604638,-0.5183159839679733},
{0.36866351562998184,0.25662440918062157,-2.48847911932724e-06},
{0.3533407054527244,0.25662440918062157,0.11693270063751725},
{0.3477478486320364,0.2736362745601224,0.11537615694837806},
{0.3049397865818096,0.2736362745601224,0.21834195746878127},
{0.30995407200725394,0.25662440918062157,0.22128738356639496},
{0.23825787798053702,0.2736362745601224,0.3050754086938129},
{0.24237320032412443,0.25662440918062157,0.3091907310374003},
{0.1544698528531191,0.25662440918062157,0.3767712916606399},
{0.15152442675550537,0.2736362745601224,0.37175700623519553},
{0.05011516992424137,0.25662751977952075,0.42015792510611033},
{0.048558626235102174,0.2736362745601224,0.4145650682854224},
{-0.06682033025228512,0.25662751977952075,0.43548073528336784},
{-0.06682033025228512,0.2736362745601224,0.42968568953423447},
{-0.18219928673967242,0.2736362745601224,0.4145650682854224},
{-0.1837558304288116,0.25662751977952075,0.42015792510611033},
{-0.2851650872600756,0.2736362745601224,0.37175700623519553},
{-0.28811051335768934,0.25662440918062157,0.3767712916606399},
{-0.37189853848510723,0.2736362745601224,0.3050754086938129},
{-0.37601386082869465,0.25662440918062157,0.3091907310374003},
{-0.4435947325118242,0.25662440918062157,0.22128738356639496},
{-0.43858044708637983,0.2736362745601224,0.21834195746878127},
{-0.48698136595729463,0.25662440918062157,0.11693270063751725},
{-0.48138850913660663,0.2736362745601224,0.11537615694837806},
{-0.502304176134552,0.25662440918062157,-2.48847911932724e-06},
{-0.4965091303854188,0.2736362745601224,-2.799539009243145e-06},
{-0.48138850913660663,0.2736362745601224,-0.11538175602639655},
{-0.48698136595729463,0.25662440918062157,-0.11693829971553575},
{-0.43858044708637983,0.2736362745601224,-0.21834755654679974},
{-0.4435947325118242,0.25662440918062157,-0.22129298264441347},
{-0.37189853848510723,0.2736362745601224,-0.30508100777183134},
{-0.37601386082869465,0.25662440918062157,-0.3091963301154188},
{-0.28811051335768934,0.25662440918062157,-0.37677751285843825},
{-0.2851650872600756,0.2736362745601224,-0.37176322743299384},
{-0.1837558304288116,0.25662440918062157,-0.42016414630390864},
{-0.18219928673967242,0.2736331639612234,-0.4145712894832207},
{-0.06682033025228512,0.2566212985817224,-0.43548695648116614},
{-0.06682033025228512,0.2736331639612234,-0.42969191073203283},
{0.048558626235102174,0.2736331639612234,-0.4145712894832207},
{0.05011516992424137,0.25662440918062157,-0.42016414630390864},
{0.15152442675550537,0.2736362745601224,-0.37176322743299384},
{0.1544698528531191,0.25662440918062157,-0.37677751285843825},
{0.23825787798053702,0.2736362745601224,-0.30508100777183134},
{0.24237320032412443,0.25662440918062157,-0.3091963301154188},
{0.30995407200725394,0.25662440918062157,-0.22129298264441347},
{0.3049397865818096,0.2736362745601224,-0.21834755654679974},
{0.3533407054527244,0.25662440918062157,-0.11693829971553575},
{0.3477478486320364,0.2736362745601224,-0.11538175602639655},
{0.36286846988084853,0.2736362745601224,-2.799539009243145e-06},
{0.36376743296270553,0.28384214954826326,-2.799539009243145e-06},
{0.3486157057249018,0.28384214954826326,0.11561785048284273},
{0.3057174363065993,0.28384214954826326,0.21879952656684756},
{0.2388967949944243,0.28384214954826326,0.30571432570770013},
{0.15198199585357167,0.28384214954826326,0.37253465595998525},
{0.04880031976956684,0.28384214954826326,0.41543292537828774},
{-0.06682033025228512,0.28384214954826326,0.43058465261609147},
{-0.18244098027413708,0.28384214954826326,0.41543292537828774},
{-0.28562265635814194,0.28384214954826326,0.37253465595998525},
{-0.3725374554989946,0.28384214954826326,0.30571432570770013},
{-0.43935809681116955,0.28384214954826326,0.21879952656684756},
{-0.48225636622947204,0.28384214954826326,0.11561785048284273},
{-0.49740809346727577,0.28384214954826326,-2.799539009243145e-06},
{-0.48225636622947204,0.28384214954826326,-0.11562344956086121},
{-0.43935809681116955,0.28384214954826326,-0.21880512564486604},
{-0.3725374554989946,0.28384214954826326,-0.30571992478571863},
{-0.28562265635814194,0.28384214954826326,-0.3725408771577836},
{-0.18244098027413708,0.2838390389493642,-0.4154391465760861},
{-0.06682033025228512,0.2838390389493642,-0.4305908738138898},
{0.04880031976956684,0.2838390389493642,-0.4154391465760861},
{0.15198199585357167,0.28384214954826326,-0.3725408771577836},
{0.2388967949944243,0.28384214954826326,-0.30571992478571863},
{0.3057174363065993,0.28384214954826326,-0.21880512564486604},
{0.3486157057249018,0.28384214954826326,-0.11562344956086121},
{0.36963402248651944,0.2872451447439433,-2.799539009243145e-06},
{0.3542801063202704,0.2872451447439433,0.11719367988515669},
{0.3107939337100269,0.2872451447439433,0.22178134667158142},
{0.24306344221984783,0.2872451447439433,0.3098809729331237},
{0.15496381595830558,0.2872451447439433,0.3776111533634129},
{0.050376149171880824,0.2872482553428425,0.4210973259736564},
{-0.06682033025228512,0.2872482553428425,0.43645124213990544},
{-0.18401680967645107,0.2872482553428425,0.4210973259736564},
{-0.2886044764628758,0.2872451447439433,0.3776111533634129},
{-0.37670410272441807,0.2872451447439433,0.3098809729331237},
{-0.44443459421459713,0.2872451447439433,0.22178134667158142},
{-0.4879207668248407,0.2872451447439433,0.11719367988515669},
{-0.5032746829910897,0.2872451447439433,-2.799539009243145e-06},
{-0.4879207668248407,0.2872451447439433,-0.11719927896317518},
{-0.44443459421459713,0.2872451447439433,-0.2217869457495999},
{-0.37670410272441807,0.2872451447439433,-0.30988657201114217},
{-0.2886044764628758,0.2872451447439433,-0.3776173745612112},
{-0.18401680967645107,0.2872451447439433,-0.42110354717145465},
{-0.06682033025228512,0.2872420341450441,-0.43645746333770374},
{0.050376149171880824,0.2872451447439433,-0.42110354717145465},
{0.15496381595830558,0.2872451447439433,-0.3776173745612112},
{0.24306344221984783,0.2872451447439433,-0.30988657201114217},
{0.3107939337100269,0.2872451447439433,-0.2217869457495999},
{0.3542801063202704,0.2872451447439433,-0.11719927896317518},
{0.37874496666215635,0.28384214954826326,-2.799539009243145e-06},
{0.3630675482103947,0.28384214954826326,0.11963954379956546},
{0.31867619132049596,0.28384214954826326,0.2264099178335301},
{0.24953068839108938,0.28384214954826326,0.3163479080444753},
{0.15959238712025423,0.28384214954826326,0.3854934109738819},
{0.05282201308628959,0.28384214954826326,0.42988476786378066},
{-0.06682033025228512,0.28384526014716244,0.4455621863155423},
{-0.1864626735908598,0.28384214954826326,0.42988476786378066},
{-0.2932330476248245,0.28384214954826326,0.3854934109738819},
{-0.3831713488956596,0.28384214954826326,0.3163479080444753},
{-0.4523168518250662,0.28384214954826326,0.2264099178335301},
{-0.49670820871496496,0.28384214954826326,0.11963954379956546},
{-0.5123856271667265,0.28384214954826326,-2.799539009243145e-06},
{-0.49670820871496496,0.28384214954826326,-0.11964514287758395},
{-0.4523168518250662,0.28384214954826326,-0.22641551691154857},
{-0.3831713488956596,0.28384214954826326,-0.3163541292422737},
{-0.2932330476248245,0.28384214954826326,-0.38549963217168015},
{-0.1864626735908598,0.2838390389493642,-0.429890989061579},
{-0.06682033025228512,0.2838390389493642,-0.44556840751334065},
{0.05282201308628959,0.2838390389493642,-0.429890989061579},
{0.15959238712025423,0.28384214954826326,-0.38549963217168015},
{0.24953068839108938,0.28384214954826326,-0.3163541292422737},
{0.31867619132049596,0.28384214954826326,-0.22641551691154857},
{0.3630675482103947,0.28384214954826326,-0.11964514287758395},
{0.3893645513038853,0.2736362745601224,-2.799539009243145e-06},
{0.3733138609842246,0.2736362745601224,0.12249134087031448},
{0.3278649004686117,0.2736362745601224,0.23180680692357106},
{0.25707078012265094,0.2736362745601224,0.3238879997760369},
{0.1649892762102952,0.2736362745601224,0.3946821201219977},
{0.05567381015703859,0.2736393851590216,0.44013108063761064},
{-0.06682033025228512,0.2736393851590216,0.4561817709572713},
{-0.18931447066160886,0.2736393851590216,0.44013108063761064},
{-0.29862993671486543,0.2736362745601224,0.3946821201219977},
{-0.3907114406272212,0.2736362745601224,0.3238879997760369},
{-0.461505560973182,0.2736362745601224,0.23180680692357106},
{-0.5069545214887948,0.2736362745601224,0.12249134087031448},
{-0.5230052118084556,0.2736362745601224,-2.799539009243145e-06},
{-0.5069545214887948,0.2736362745601224,-0.12249693994833297},
{-0.461505560973182,0.2736362745601224,-0.2318124060015895},
{-0.3907114406272212,0.2736362745601224,-0.32389422097383525},
{-0.29862993671486543,0.2736362745601224,-0.394688341319796},
{-0.18931447066160886,0.2736331639612234,-0.4401373018354089},
{-0.06682033025228512,0.2736331639612234,-0.4561879921550696},
{0.05567381015703859,0.2736331639612234,-0.4401373018354089},
{0.1649892762102952,0.2736362745601224,-0.394688341319796},
{0.25707078012265094,0.2736362745601224,-0.32389422097383525},
{0.3278649004686117,0.2736362745601224,-0.2318124060015895},
{0.3733138609842246,0.2736362745601224,-0.12249693994833297},
{0.39976950462157235,0.25662440918062157,-2.48847911932724e-06},
{0.3833517636318109,0.25662440918062157,0.12528528080153914},
{0.336866973682778,0.25662440918062157,0.2370938918724717},
{0.26445845250815364,0.25662440918062157,0.3312756721615397},
{0.17027636115919578,0.25662440918062157,0.403684193336164},
{0.058467750088263264,0.25662751977952075,0.4501689832851969},
{-0.06682033025228512,0.25662751977952075,0.4665867242749583},
{-0.1921084105928335,0.25662751977952075,0.4501689832851969},
{-0.30391702166376605,0.25662440918062157,0.403684193336164},
{-0.39809911301272394,0.25662440918062157,0.3312756721615397},
{-0.47050763418734826,0.25662440918062157,0.2370938918724717},
{-0.5169924241363811,0.25662440918062157,0.12528528080153914},
{-0.5334101651261426,0.25662440918062157,-2.48847911932724e-06},
{-0.5169924241363811,0.25662440918062157,-0.12529087987955762},
{-0.47050763418734826,0.25662440918062157,-0.23709949095049015},
{-0.39809911301272394,0.25662440918062157,-0.33128189335933794},
{-0.30391702166376605,0.25662440918062157,-0.4036904145339623},
{-0.1921084105928335,0.2566212985817224,-0.4501752044829952},
{-0.06682033025228512,0.2566212985817224,-0.46659294547275665},
{0.058467750088263264,0.2566212985817224,-0.4501752044829952},
{0.17027636115919578,0.25662440918062157,-0.4036904145339623},
{0.26445845250815364,0.25662440918062157,-0.33128189335933794},
{0.336866973682778,0.25662440918062157,-0.23709949095049015},
{0.3833517636318109,0.25662440918062157,-0.12529087987955762},
{0.438291161388758,0.17508005903916707,-2.48847911932724e-06},
{0.4205203098778624,0.17508005903916707,0.13562957744069257},
{0.3701939302883681,0.17508005903916707,0.25666951286465944},
{0.2918099486284592,0.17508005903916707,0.35862716828184515},
{0.18985167109149362,0.17508316963806625,0.4370111499417541},
{0.06881173566752675,0.17508316963806625,0.4873375295312483},
{-0.06682033025228512,0.17508316963806625,0.5051083810421441},
{-0.20245239617209698,0.17508316963806625,0.4873375295312483},
{-0.3234923315960639,0.17508316963806625,0.4370111499417541},
{-0.42545060913302946,0.17508005903916707,0.35862716828184515},
{-0.5038345907929384,0.17508005903916707,0.25666951286465944},
{-0.5541609703824326,0.17508005903916707,0.13562957744069257},
{-0.5719318218933283,0.17508005903916707,-2.48847911932724e-06},
{-0.5541609703824326,0.17508005903916707,-0.1356345543989312},
{-0.5038345907929384,0.17508005903916707,-0.2566744898228981},
{-0.42545060913302946,0.17508005903916707,-0.3586333894796435},
{-0.3234923315960639,0.17507694844026803,-0.4370173711395524},
{-0.20245239617209698,0.17507694844026803,-0.4873437507290466},
{-0.06682033025228512,0.17507694844026803,-0.5051146022399423},
{0.06881173566752675,0.17507694844026803,-0.4873437507290466},
{0.18985167109149362,0.17507694844026803,-0.4370173711395524},
{0.2918099486284592,0.17508005903916707,-0.3586333894796435},
{0.3701939302883681,0.17508005903916707,-0.2566744898228981},
{0.4205203098778624,0.17508005903916707,-0.1356345543989312},
{0.4746540625199273,0.09418271346873773,-2.1774192294113347e-06},
{0.4556016442625781,0.09418271346873773,0.14539374738515282},
{0.40165452755446274,0.09418271346873773,0.275147092445444},
{0.31762791949147934,0.09418271346873773,0.3844451391448653},
{0.20832893961238827,0.09418582406763691,0.46847174720784873},
{0.07857559455209709,0.09418582406763691,0.5224188639159641},
{-0.06682033025228512,0.09418582406763691,0.5414712821733133},
{-0.21221625505666733,0.09418582406763691,0.5224188639159641},
{-0.3419696001169585,0.09418582406763691,0.46847174720784873},
{-0.4512685799960496,0.09418271346873773,0.3844451391448653},
{-0.535295188059033,0.09418271346873773,0.275147092445444},
{-0.5892423047671483,0.09418271346873773,0.14539374738515282},
{-0.6082947230244975,0.09418271346873773,-2.1774192294113347e-06},
{-0.5892423047671483,0.09418271346873773,-0.14539810222361163},
{-0.535295188059033,0.09418271346873773,-0.27515144728390284},
{-0.4512685799960496,0.09418271346873773,-0.38445136034266364},
{-0.3419696001169585,0.09417960286983855,-0.46847796840564704},
{-0.21221625505666733,0.09417960286983855,-0.5224250851137624},
{-0.06682033025228512,0.09417960286983855,-0.5414775033711116},
{0.07857559455209709,0.09417960286983855,-0.5224250851137624},
{0.20832893961238827,0.09417960286983855,-0.46847796840564704},
{0.31762791949147934,0.09418271346873773,-0.38445136034266364},
{0.40165452755446274,0.09418271346873773,-0.27515144728390284},
{0.4556016442625781,0.09418271346873773,-0.14539810222361163},
{0.22461105849014643,0.014585598238156815,0.49619651519605334},
{0.08717951110717104,0.014582487639257636,0.5533351063747058},
{-0.06682033025228512,0.014582487639257636,0.5735135614335506},
{-0.22082017161174128,0.014585598238156815,0.5533351063747058},
{-0.3582517189947167,0.014585598238156815,0.49619651519605334},
{-0.4740163897455997,0.014579377040358457,0.40719294889441543},
{-0.5630199560472376,0.014582487639257636,0.29142952238309205},
{-0.6201585472258901,0.014579377040358457,0.15399797500011667},
{-0.6403370022847349,0.014579377040358457,-1.86635933949543e-06},
{-0.6201585472258901,0.014582487639257636,-0.15400170771879565},
{-0.5630199560472376,0.014582487639257636,-0.29143325510177104},
{-0.4740163897455997,0.014579377040358457,-0.40719917009221374},
{-0.3582517189947167,0.014579377040358457,-0.4962027363938516},
{-0.22082017161174128,0.014576266441459346,-0.5533413275725042},
{-0.06682033025228512,0.014576266441459346,-0.573519782631349},
{0.08717951110717104,0.014579377040358457,-0.5533413275725042},
{0.22461105849014643,0.014579377040358457,-0.4962027363938516},
{0.23760029737325478,-0.06307361387824802,0.5183097627701749},
{0.0940433586380554,-0.06307361387824802,0.5779959344472388},
{-0.06682033025228512,-0.06307361387824802,0.5990764631868397},
{-0.22768401914262565,-0.06307361387824802,0.5779959344472388},
{-0.371240957877825,-0.06307361387824802,0.5183097627701749},
{-0.49216673432219277,-0.06307361387824802,0.42534329347100847},
{-0.5851332036213592,-0.0630767244771472,0.30441907232609033},
{-0.6448193752984231,-0.0630767244771472,0.16086213359089094},
{-0.665899904038024,-0.0630767244771472,-1.555299449579525e-06},
{-0.6448193752984231,-0.0630767244771472,-0.16086524418979006},
{-0.5851332036213592,-0.0630767244771472,-0.30442218292498946},
{-0.49216673432219277,-0.0630767244771472,-0.4253495146688068},
{-0.371240957877825,-0.06307983507604638,-0.5183159839679733},
{-0.22768401914262565,-0.06307983507604638,-0.5780021556450372},
{-0.06682033025228512,-0.06307983507604638,-0.5990826843846381},
{0.0940433586380554,-0.06307983507604638,-0.5780021556450372},
{-0.004608352269104122,0.3499423761553932,-3.11059889915905e-06},
{-0.015408662706874259,0.37651311195200965,0.014319642032278685},
{-0.00679728071444235,0.3499423761553932,0.016702049729144602},
{0.04233867267634375,0.33006875978866596,-2.799539009243145e-06},
{0.03849801621555208,0.33006875978866596,0.029308373887766484},
{-0.012995460080906672,0.3499423761553932,0.031609906013254266},
{-0.020710678530490863,0.37651311195200965,0.027092072172115664},
{-0.01353701534925026,0.37651311195200965,-3.11059889915905e-06},
{-0.015408662706874259,0.37651311195200965,-0.014325863230077004},
{-0.00679728071444235,0.3499423761553932,-0.01670827092694292},
{0.03849801621555208,0.33006875978866596,-0.02931397296578497},
{0.11175106499129811,0.31538051178683696,-2.799539009243145e-06},
{0.10546796627488675,0.31538051178683696,0.04794677143163759},
{0.027622429284422285,0.33006875978866596,0.05546571109068485},
{-0.022649825884226617,0.3499423761553932,0.04416739376915935},
{-0.02897305132643713,0.37651311195200965,0.037844168326948834},
{-0.0352073136401317,0.3499423761553932,0.05382175957247929},
{-0.011351508562701111,0.33006875978866596,0.09443964893780825},
{-0.0375091568255094,0.33006875978866596,0.10531523586893804},
{-0.05011516992424136,0.3499423761553932,0.06001993893894362},
{-0.0397251474812703,0.37651311195200965,0.0461065411228951},
{-0.05249757762110727,0.37651311195200965,0.0514085569465117},
{-0.06682033025228512,0.3499423761553932,0.06220886738428184},
{-0.06682033025228512,0.37651311195200965,0.0532802043041357},
{-0.08114308288346296,0.37651311195200965,0.0514085569465117},
{-0.08352549058032888,0.3499423761553932,0.06001993893894362},
{-0.09391551302329995,0.37651311195200965,0.0461065411228951},
{-0.09843334686443854,0.3499423761553932,0.05382175957247929},
{-0.10466760917813311,0.37651311195200965,0.037844168326948834},
{-0.11099083462034363,0.3499423761553932,0.04416739376915935},
{-0.12064520042366357,0.3499423761553932,0.031609906013254266},
{-0.11292998197407937,0.37651311195200965,0.027092072172115664},
{-0.12684337979012789,0.3499423761553932,0.016702049729144602},
{-0.11823199779769598,0.37651311195200965,0.014319642032278685},
{-0.12903230823546613,0.3499423761553932,-3.11059889915905e-06},
{-0.12010364515531999,0.37651311195200965,-3.11059889915905e-06},
{-0.11823199779769598,0.37651311195200965,-0.014325863230077004},
{-0.12684337979012789,0.3499423761553932,-0.01670827092694292},
{-0.11292998197407937,0.37651311195200965,-0.027098293369913977},
{-0.12064520042366357,0.3499423761553932,-0.03161612721105258},
{-0.10466760917813311,0.37651311195200965,-0.03785038952474715},
{-0.11099083462034363,0.3499423761553932,-0.04417361496695767},
{-0.09843334686443854,0.3499423761553932,-0.05382798077027761},
{-0.09391551302329995,0.37651311195200965,-0.04611276232069341},
{-0.08352549058032888,0.3499423761553932,-0.06002616013674193},
{-0.08114308288346296,0.37651311195200965,-0.05141477814431002},
{-0.06682033025228512,0.3499423761553932,-0.06221508858208016},
{-0.06682033025228512,0.37651311195200965,-0.05328642550193402},
{-0.05249757762110727,0.37651311195200965,-0.05141477814431002},
{-0.05011516992424136,0.3499423761553932,-0.06002616013674193},
{-0.0397251474812703,0.37651311195200965,-0.04611276232069341},
{-0.0352073136401317,0.3499423761553932,-0.05382798077027761},
{-0.02897305132643713,0.37651311195200965,-0.03785038952474715},
{-0.022649825884226617,0.3499423761553932,-0.04417361496695767},
{-0.012995460080906672,0.3499423761553932,-0.03161612721105258},
{-0.020710678530490863,0.37651311195200965,-0.027098293369913977},
{0.18980407892833648,0.3032833926680073,-2.799539009243145e-06},
{0.1807746324438576,0.3032833926680073,0.06890567575428136},
{0.2626729687400364,0.2911862735491778,-2.799539009243145e-06},
{0.25107976664287057,0.2911862735491778,0.08847227600966152},
{0.15520737585210972,0.3032833926680073,0.13040034963131628},
{0.08767689587114656,0.31538051178683696,0.09073772518791906},
{0.010682418739492012,0.33006875978866596,0.07749963839287798},
{0.0239205055345331,0.31538051178683696,0.15449411552453252},
{-0.018870448221748368,0.31538051178683696,0.17228518592827272},
{-0.06682033025228512,0.31538051178683696,0.17856828464468408},
{-0.06682033025228512,0.33006875978866596,0.10915589232972972},
{-0.09613150367906084,0.33006875978866596,0.10531523586893804},
{-0.12228915194186912,0.33006875978866596,0.09443964893780825},
{-0.14432307924406224,0.33006875978866596,0.07749963839287798},
{-0.16126308978899254,0.33006875978866596,0.05546571109068485},
{-0.1721386767201223,0.33006875978866596,0.029308373887766484},
{-0.17597933318091402,0.33006875978866596,-2.799539009243145e-06},
{-0.1721386767201223,0.33006875978866596,-0.02931397296578497},
{-0.16126308978899254,0.33006875978866596,-0.05547193228848316},
{-0.14432307924406224,0.33006875978866596,-0.0775058595906763},
{-0.12228915194186912,0.33006875978866596,-0.09444587013560657},
{-0.09613150367906084,0.33006875978866596,-0.10532145706673635},
{-0.06682033025228512,0.33006875978866596,-0.10916211352752804},
{-0.0375091568255094,0.33006875978866596,-0.10532145706673635},
{-0.011351508562701111,0.33006875978866596,-0.09444587013560657},
{0.010682418739492012,0.33006875978866596,-0.0775058595906763},
{0.027622429284422285,0.33006875978866596,-0.05547193228848316},
{0.10546796627488675,0.31538051178683696,-0.047952992629435906},
{0.1807746324438576,0.3032833926680073,-0.06891127483229985},
{0.25107976664287057,0.2911862735491778,-0.08847787508768003},
{0.31653298867897534,0.2764980255473488,-2.799539009243145e-06},
{0.3030423212533226,0.2764980255473488,0.1029343834715217},
{0.2182520611605956,0.2911862735491778,0.16742860786701566},
{0.11538300026595621,0.3032833926680073,0.18220053097923208},
{0.05996550345820833,0.31538051178683696,0.1267827231115943},
{0.06358281891804039,0.3032833926680073,0.22202490656538557},
{0.0020881450410054777,0.3032833926680073,0.24759216315713348},
{-0.06682033025228512,0.3032833926680073,0.2566216096416124},
{-0.11477021228282187,0.31538051178683696,0.17228518592827272},
{0.32332964727363783,0.25662440918062157,0.10858012047349538},
{0.3375575266383914,0.25662440918062157,-2.48847911932724e-06},
{0.3030423212533226,0.2764980255473488,-0.10293998254954018},
{0.32332964727363783,0.25662440918062157,-0.10858571955151385},
{0.2648503879694477,0.2764980255473488,-0.19480281135928507},
{0.2830411703317299,0.25662440918062157,-0.20548678539822668},
{0.20535987296314098,0.2764980255473488,-0.27218300275443535},
{0.2202879481400952,0.25662440918062157,-0.2871110779313895},
{0.1386636556069323,0.25662440918062157,-0.3498646111829141},
{0.1279796815679907,0.2764980255473488,-0.331673828820632},
{0.041762589760219494,0.25662440918062157,-0.39015308812482213},
{0.03611685275824582,0.2764980255473488,-0.3698657621045068},
{-0.06682033025228512,0.25662440918062157,-0.4043809674895757},
{-0.06682033025228512,0.2764980255473488,-0.38335642953015964},
{-0.16975751326281607,0.2764980255473488,-0.3698657621045068},
{-0.17540325026478973,0.25662440918062157,-0.39015308812482213},
{-0.26162034207256096,0.2764980255473488,-0.331673828820632},
{-0.2723043161115025,0.25662440918062157,-0.3498646111829141},
{-0.33900053346771125,0.2764980255473488,-0.27218300275443535},
{-0.3539286086446654,0.25662440918062157,-0.2871110779313895},
{-0.4166818308363001,0.25662440918062157,-0.20548678539822668},
{-0.39849104847401795,0.2764980255473488,-0.19480281135928507},
{-0.4569703077782081,0.25662440918062157,-0.10858571955151385},
{-0.43668298175789283,0.2764980255473488,-0.10293998254954018},
{-0.47119818714296163,0.25662440918062157,-2.48847911932724e-06},
{-0.4501736491835456,0.2764980255473488,-2.799539009243145e-06},
{-0.43668298175789283,0.2764980255473488,0.1029343834715217},
{-0.4569703077782081,0.25662440918062157,0.10858012047349538},
{-0.39849104847401795,0.2764980255473488,0.1947972122812666},
{-0.4166818308363001,0.25662440918062157,0.20548118632020815},
{-0.33900053346771125,0.2764980255473488,0.27217740367641685},
{-0.3539286086446654,0.25662440918062157,0.28710547885337107},
{-0.2723043161115025,0.25662440918062157,0.3498583899851158},
{-0.26162034207256096,0.2764980255473488,0.33166760762283365},
{-0.17540325026478973,0.25662440918062157,0.3901468669270238},
{-0.16975751326281607,0.2764980255473488,0.36985954090670853},
{-0.06682033025228512,0.25662440918062157,0.40437474629177733},
{-0.06682033025228512,0.2764980255473488,0.3833502083323613},
{0.03611685275824582,0.2764980255473488,0.36985954090670853},
{0.041762589760219494,0.25662440918062157,0.3901468669270238},
{0.1279796815679907,0.2764980255473488,0.33166760762283365},
{0.1386636556069323,0.25662440918062157,0.3498583899851158},
{0.20535987296314098,0.2764980255473488,0.27217740367641685},
{0.2202879481400952,0.25662440918062157,0.28710547885337107},
{0.2830411703317299,0.25662440918062157,0.20548118632020815},
{0.2648503879694477,0.2764980255473488,0.1947972122812666},
{0.16711972539632922,0.2911862735491778,0.23393725610960509},
{0.1006110771537398,0.2911862735491778,0.28506959187387143},
{0.021654745296385645,0.2911862735491778,0.3178969862962566},
{-0.06682033025228512,0.2911862735491778,0.32949018839342237},
{-0.13572880554557573,0.3032833926680073,0.24759216315713348},
{-0.15756116603910333,0.31538051178683696,0.15449411552453252},
{-0.15529540580095588,0.2911862735491778,0.3178969862962566},
{-0.19722347942261065,0.3032833926680073,0.22202490656538557},
{-0.19360616396277858,0.31538051178683696,0.1267827231115943},
{-0.23425173765831006,0.2911862735491778,0.28506959187387143},
{-0.24902366077052646,0.3032833926680073,0.18220053097923208},
{-0.28884803635667994,0.3032833926680073,0.13040034963131628},
{-0.22131755637571682,0.31538051178683696,0.09073772518791906},
{-0.239108626779457,0.31538051178683696,0.04794677143163759},
{-0.24539172549586835,0.31538051178683696,-2.799539009243145e-06},
{-0.239108626779457,0.31538051178683696,-0.047952992629435906},
{-0.22131755637571682,0.31538051178683696,-0.09074394638571738},
{-0.19360616396277858,0.31538051178683696,-0.1267889443093926},
{-0.15756116603910333,0.31538051178683696,-0.15450033672233085},
{-0.11477021228282187,0.31538051178683696,-0.17229140712607102},
{-0.06682033025228512,0.31538051178683696,-0.1785745058424824},
{-0.018870448221748368,0.31538051178683696,-0.17229140712607102},
{0.0239205055345331,0.31538051178683696,-0.15450033672233085},
{0.05996550345820833,0.31538051178683696,-0.1267889443093926},
{0.08767689587114656,0.31538051178683696,-0.09074394638571738},
{-0.30076038590089943,0.2911862735491778,0.23393725610960509},
{-0.35189272166516583,0.2911862735491778,0.16742860786701566},
{-0.3847204271474408,0.2911862735491778,0.08847227600966152},
{-0.3144152929484279,0.3032833926680073,0.06890567575428136},
{-0.3234447394329067,0.3032833926680073,-2.799539009243145e-06},
{-0.3144152929484279,0.3032833926680073,-0.06891127483229985},
{-0.28884803635667994,0.3032833926680073,-0.13040594870933478},
{-0.24902366077052646,0.3032833926680073,-0.1822061300572506},
{-0.19722347942261065,0.3032833926680073,-0.22203050564340404},
{-0.13572880554557573,0.3032833926680073,-0.24759776223515198},
{-0.06682033025228512,0.3032833926680073,-0.25662720871963085},
{0.0020881450410054777,0.3032833926680073,-0.24759776223515198},
{0.06358281891804039,0.3032833926680073,-0.22203050564340404},
{0.11538300026595621,0.3032833926680073,-0.1822061300572506},
{0.15520737585210972,0.3032833926680073,-0.13040594870933478},
{-0.39631362924460667,0.2911862735491778,-2.799539009243145e-06},
{-0.3847204271474408,0.2911862735491778,-0.08847787508768003},
{-0.35189272166516583,0.2911862735491778,-0.1674342069450342},
{-0.30076038590089943,0.2911862735491778,-0.23394285518762356},
{-0.23425173765831006,0.2911862735491778,-0.28507519095188993},
{-0.15529540580095588,0.2911862735491778,-0.3179032074940549},
{-0.06682033025228512,0.2911862735491778,-0.3294964095912207},
{0.021654745296385645,0.2911862735491778,-0.3179032074940549},
{0.1006110771537398,0.2911862735491778,-0.28507519095188993},
{0.16711972539632922,0.2911862735491778,-0.23394285518762356},
{0.2182520611605956,0.2911862735491778,-0.1674342069450342},
{-0.5645161541177331,0.13997695046215722,-2.1774192294113347e-06},
{-0.6662451805158307,0.1448139317503496,0.038879997760368795},
{-0.6654675307910409,0.13965344817664477,-2.1774192294113347e-06},
{-0.6662451805158307,0.1448139317503496,-0.038884974718607454},
{-0.7531584243572337,0.142378332812308,-0.038884974718607454},
{-0.7500011664745871,0.13738582157915777,-2.1774192294113347e-06},
{-0.7531584243572337,0.142378332812308,0.038879997760368795},
{-0.7610500137644001,0.1548580555957341,0.06220948950406167},
{-0.6681924154267042,0.15771358538516214,0.06220948950406167},
{-0.5622112003334562,0.14516231882705535,0.038879997760368795},
{-0.817252314674406,0.13122683575882282,-2.1774192294113347e-06},
{-0.8221483973416823,0.13576519955269592,0.03888030882025871},
{-0.8663593394954299,0.11923858760146384,-2.1774192294113347e-06},
{-0.8724187861509917,0.12288732011017742,0.03888030882025871},
{-0.8875674027898963,0.13200759608251175,0.06220980056395159},
{-0.8343886040098731,0.1471064431390298,0.06220948950406167},
{-0.8964574944436928,0.09947384219620727,-2.1774192294113347e-06},
{-0.9031670562691787,0.10165748262341692,0.03888030882025871},
{-0.9066820330252285,0.06998847523107865,-1.86635933949543e-06},
{-0.9135937837791599,0.06998847523107865,0.03888030882025871},
{-0.9199425161323436,0.10711969429034023,0.06220980056395159},
{-0.8724187861509917,0.12288732011017742,-0.03888466365871754},
{-0.9031670562691787,0.10165748262341692,-0.03888466365871754},
{-0.9135937837791599,0.06998847523107865,-0.03888466365871754},
{-0.9013535771109692,0.0298088692506412,-1.86635933949543e-06},
{-0.907982263365077,0.027678109004717243,0.038880619880148626},
{-0.9245586448986958,0.022346542491558652,0.062210111623841505},
{-0.9308762712628875,0.06998847523107865,0.06220980056395159},
{-0.9417478144154485,0.11421808097822118,0.06998629781184922},
{-0.9072574938215731,0.1438651990861061,0.06998598675195929},
{-0.8503024279779706,0.16184757132214453,0.06998598675195929},
{-0.5564503711722137,0.15812107384095203,0.06220948950406167},
{-0.6707244429306196,0.1744859346494278,0.06998598675195929},
{-0.5489631596219379,0.17497118807769663,0.06998598675195929},
{-0.6732533598356361,0.19125517331479414,0.06220948950406167},
{-0.541475948071662,0.19182130231444108,0.06220948950406167},
{-0.6752005947465095,0.20415793754850586,0.038879997760368795},
{-0.5357151189104195,0.20478005732833776,0.038879997760368795},
{-0.6759782444712993,0.20931842112221083,-2.48847911932724e-06},
{-0.5334101651261426,0.20996542569323587,-2.48847911932724e-06},
{-0.5357151189104195,0.20478005732833776,-0.038884974718607454},
{-0.6752005947465095,0.20415793754850586,-0.038884974718607454},
{-0.541475948071662,0.19182130231444108,-0.06221446646230032},
{-0.6732533598356361,0.19125517331479414,-0.06221446646230032},
{-0.5489631596219379,0.17497118807769663,-0.06999096371019796},
{-0.6707244429306196,0.1744859346494278,-0.06999096371019796},
{-0.5564503711722137,0.15812107384095203,-0.06221446646230032},
{-0.6681924154267042,0.15771358538516214,-0.06221446646230032},
{-0.5622112003334562,0.14516231882705535,-0.038884974718607454},
{-0.7713118795327261,0.17108293945374775,0.06998598675195929},
{-0.7815768558999507,0.18730782331176143,0.06220948950406167},
{-0.7894684453071171,0.1997875460951875,0.038879997760368795},
{-0.7926257031897637,0.20478005732833776,-2.48847911932724e-06},
{-0.7894684453071171,0.1997875460951875,-0.038884974718607454},
{-0.7815768558999507,0.18730782331176143,-0.06221446646230032},
{-0.7713118795327261,0.17108293945374775,-0.06999096371019796},
{-0.7610500137644001,0.1548580555957341,-0.06221446646230032},
{-0.8343886040098731,0.1471064431390298,-0.06221446646230032},
{-0.8221483973416823,0.13576519955269592,-0.03888466365871754},
{-0.8875674027898963,0.13200759608251175,-0.062214155402410404},
{-0.9199425161323436,0.10711969429034023,-0.062214155402410404},
{-0.9308762712628875,0.06998847523107865,-0.062214155402410404},
{-0.9245586448986958,0.022346542491558652,-0.06221384434252049},
{-0.907982263365077,0.027678109004717243,-0.03888435259882762},
{-0.8905971261176772,-0.02166532133264278,-0.03888435259882762},
{-0.8847927485718464,-0.018144123378794737,-1.555299449579525e-06},
{-0.8905971261176772,-0.02166532133264278,0.038880619880148626},
{-0.9051018487844559,-0.030465205618363706,0.06221042268373142},
{-0.9239645205089562,-0.0419059883694707,0.06998691993162905},
{-0.9461057634731703,0.015419238743131445,0.06998660887173913},
{-0.9533410165126144,0.06998847523107865,0.06998629781184922},
{-0.9635562232974525,0.12131646766610209,0.06220980056395159},
{-0.9269506954521488,0.1557228020897003,0.06220948950406167},
{-0.8662162519460684,0.17659181010415848,0.06220948950406167},
{-0.8784564586142593,0.18793305369049235,0.038879997760368795},
{-0.8833525412815356,0.19246830688546626,-2.48847911932724e-06},
{-0.8784564586142593,0.18793305369049235,-0.038884974718607454},
{-0.8662162519460684,0.17659181010415848,-0.06221446646230032},
{-0.8503024279779706,0.16184757132214453,-0.06999096371019796},
{-0.9072574938215731,0.1438651990861061,-0.06999096371019796},
{-0.975805761762341,0.06998847523107865,0.06220980056395159},
{-0.9676497714487459,0.008488824395805058,0.062210111623841505},
{-0.9842261529823646,0.0031572578826464678,0.038880619880148626},
{-0.9930882492460686,0.06998847523107865,0.03888030882025871},
{-0.9803285725617183,0.1267755687341263,0.03888030882025871},
{-0.9420962014921545,0.16484307806203471,0.038879997760368795},
{-0.9481556481477161,0.16849181057074827,-2.1774192294113347e-06},
{-0.9420962014921545,0.16484307806203471,-0.038884974718607454},
{-0.9269506954521488,0.1557228020897003,-0.06221446646230032},
{-0.9417478144154485,0.11421808097822118,-0.06999065265030803},
{-0.9870381343872042,0.12895920916133588,-2.1774192294113347e-06},
{-1.0,0.06998847523107865,-1.86635933949543e-06},
{-0.9930882492460686,0.06998847523107865,-0.03888466365871754},
{-0.9803285725617183,0.1267755687341263,-0.03888466365871754},
{-0.9635562232974525,0.12131646766610209,-0.062214155402410404},
{-0.9533410165126144,0.06998847523107865,-0.06999065265030803},
{-0.975805761762341,0.06998847523107865,-0.062214155402410404},
{-0.9842261529823646,0.0031572578826464678,-0.03888435259882762},
{-0.9676497714487459,0.008488824395805058,-0.06221384434252049},
{-0.8561348009138942,-0.06998847523107858,-1.555299449579525e-06},
{-0.8605985103341872,-0.07441796806348108,0.03888093094003854},
{-0.8171621073063302,-0.12695287287137827,0.038881241999928456},
{-0.8237752405659423,-0.13975298734141775,0.062210733743621335},
{-0.87175933918437,-0.08548858954558813,0.06221042268373142},
{-0.814514987643146,-0.12183282708336249,-1.24423955966362e-06},
{-0.7594511659302323,-0.17564618803881407,0.038881241999928456},
{-0.7603967879955769,-0.190297730973633,0.062210733743621335},
{-0.8323729359232181,-0.1563946914519187,0.06998723099151896},
{-0.8862671724500478,-0.09987822005309789,0.06998691993162905},
{-0.7590716728645349,-0.16978581971279844,-1.24423955966362e-06},
{-0.6866351562998183,-0.2168777985669471,0.03888155305981837},
{-0.6808743271385757,-0.23415873075122517,0.06221104480351125},
{-0.7616285851596438,-0.20934392803318388,0.06998754205140888},
{-0.8409706312804938,-0.1730363955624196,0.062210733743621335},
{-0.9007781163146247,-0.11427096115950683,0.062210733743621335},
{-0.6889401100840951,-0.20996542569323584,-9.33179669747715e-07},
{-0.6866351562998183,-0.2168777985669471,-0.03888341941915787},
{-0.7594511659302323,-0.17564618803881407,-0.038883730479047786},
{-0.7603967879955769,-0.19029835309341284,-0.06221322222274066},
{-0.6808743271385757,-0.23415935287100503,-0.06221291116285074},
{-0.7616285851596438,-0.2093445501529637,-0.06998940841074837},
{-0.6733871155882998,-0.25662472024051153,-0.06998940841074837},
{-0.7628603823237107,-0.2283910582724045,-0.06221291116285074},
{-0.665899904038024,-0.279090087610018,-0.06221291116285074},
{-0.7638060043890551,-0.2430416680275537,-0.03888341941915787},
{-0.6601390748767816,-0.2963710197942961,-0.038883108359267955},
{-0.6578341210925046,-0.30328339266800736,-6.2211977983181e-07},
{-0.7641854974547525,-0.24890203635356933,-9.33179669747715e-07},
{-0.7638060043890551,-0.2430416680275537,0.03888155305981837},
{-0.6601390748767816,-0.2963710197942961,0.03888186411970829},
{-0.665899904038024,-0.27908946549023816,0.06221104480351125},
{-0.7628603823237107,-0.22839043615262464,0.06221104480351125},
{-0.6733871155882998,-0.25662409812073167,0.06998754205140888},
{-0.9428240816345577,-0.0533467711205777,0.06221042268373142},
{-0.9573319149002355,-0.06214665540629863,0.03888093094003854},
{-0.9631331818471669,-0.06566785336014667,-1.555299449579525e-06},
{-0.9908548392364724,0.0010264976367225114,-1.86635933949543e-06},
{-0.9573319149002355,-0.06214665540629863,-0.0388840415389377},
{-0.9428240816345577,-0.0533467711205777,-0.06221353328263057},
{-0.9461057634731703,0.015419238743131445,-0.06999034159041811},
{-0.9239645205089562,-0.0419059883694707,-0.0699900305305282},
{-0.9051018487844559,-0.030465205618363706,-0.06221353328263057},
{-0.87175933918437,-0.08548858954558813,-0.06221353328263057},
{-0.8605985103341872,-0.07441796806348108,-0.0388840415389377},
{-0.8171621073063302,-0.12695287287137827,-0.038883730479047786},
{-0.9119389451648072,-0.12534158264161388,0.038881241999928456},
{-0.9164026545851006,-0.1297710754740164,-1.24423955966362e-06},
{-0.9119389451648072,-0.12534158264161388,-0.038883730479047786},
{-0.9007781163146247,-0.11427096115950683,-0.06221322222274066},
{-0.8475837645401058,-0.18583557685278934,0.038881241999928456},
{-0.8502308842032902,-0.19095624476058495,-9.33179669747715e-07},
{-0.8475837645401058,-0.18583588791267927,-0.038883730479047786},
{-0.8409706312804938,-0.1730363955624196,-0.06221322222274066},
{-0.8323729359232181,-0.1563946914519187,-0.06998971947063828},
{-0.8862671724500478,-0.09987822005309789,-0.0699900305305282},
{-0.8237752405659423,-0.13975298734141775,-0.06221322222274066},
{0.46198148260475336,-0.04665898348738572,-1.555299449579525e-06},
{0.46198148260475336,-0.06566785336014667,0.08553991442742429},
{0.577813964411638,-0.04659366091050337,0.08160376258042842},
{0.5883744476742829,-0.08639688442414259,0.13056676667242129},
{0.46198148260475336,-0.11319158334149867,0.13686510732343854},
{0.6021015206162719,-0.1381416971116534,0.14688807909630883},
{0.46198148260475336,-0.17497118807769654,0.1539734012688133},
{0.6158317041571599,-0.18988339920026504,0.1305670777323112},
{0.46198148260475336,-0.2367504817540045,0.13686541838332844},
{0.6263921874198048,-0.2296863116540143,0.08160438470020825},
{0.46198148260475336,-0.28427390067546654,0.08554084760709404},
{0.46198148260475336,-0.30328339266800736,-6.2211977983181e-07},
{0.6306163807248628,-0.24560760105947,-9.33179669747715e-07},
{0.6263921874198048,-0.22968693377379415,-0.08160625105954776},
{0.46198148260475336,-0.2842745227952464,-0.0855420918466537},
{0.46198148260475336,-0.23675172599356417,-0.13686728474266793},
{0.6158317041571599,-0.1898846434398247,-0.13056956621143054},
{0.46198148260475336,-0.17497118807769654,-0.15397588974793264},
{0.6021015206162719,-0.1381416971116534,-0.14689056757542815},
{0.46198148260475336,-0.11319158334149867,-0.13686759580255786},
{0.5883744476742829,-0.08639688442414259,-0.13056987727132044},
{0.46198148260475336,-0.06566785336014667,-0.08554302502632345},
{0.577813964411638,-0.04659366091050337,-0.08160687317932759},
{0.5735897711065802,-0.03067361574460735,-1.555299449579525e-06},
{0.6455441448419272,-0.0009269584719493914,0.07176276084315894},
{0.6609073928048738,-0.031329952112329924,0.11482184822454791},
{0.6808743271385757,-0.0708532217250448,0.12917477366504762},
{0.7008443720711769,-0.11037649133775974,0.11482215928443784},
{0.7162045094352241,-0.1407763743792411,0.07176338296293877},
{0.7223510528599626,-0.15293881607495302,-1.24423955966362e-06},
{0.7162045094352241,-0.1407763743792411,-0.07176587144205811},
{0.7008443720711769,-0.11037649133775974,-0.11482495882344708},
{0.6808743271385757,-0.0708532217250448,-0.12917788426394677},
{0.6609073928048738,-0.031329952112329924,-0.11482495882344708},
{0.6455441448419272,-0.0009269584719493914,-0.07176649356183794},
{0.6394007120160881,0.011232372624863356,-1.86635933949543e-06},
{0.6827469076758695,0.061779604736197875,0.0589694896906976},
{0.7000293951595972,0.04125898379844566,0.09435286322852171},
{0.7224941404093237,0.014579377040358457,0.10614732107446308},
{0.7449588856590503,-0.012097119118829503,0.09435286322852171},
{0.7622413731427782,-0.03261774005658178,0.058970111810477434},
{0.7691531238967095,-0.040826610551462486,-1.555299449579525e-06},
{0.7622413731427782,-0.03261774005658178,-0.058973222409376594},
{0.7449588856590503,-0.012097119118829503,-0.09435659594720071},
{0.7224941404093237,0.014579377040358457,-0.10615105379314208},
{0.7000293951595972,0.04125898379844566,-0.09435659594720071},
{0.6827469076758695,0.061779604736197875,-0.05897384452915643},
{0.6758351569219382,0.06998847523107865,-1.86635933949543e-06},
{0.7069878048970158,0.13197649009352017,0.0461768406580161},
{0.7261895319015248,0.12061658291379135,0.07388418929238542},
{0.7511520880672761,0.10584745934058419,0.08311986848387855},
{0.7761146442330276,0.09107833576737696,0.07388418929238542},
{0.795313260638637,0.07971842858764815,0.0461768406580161},
{0.8029964399195599,0.07517384359597677,-1.86635933949543e-06},
{0.795313260638637,0.07971842858764815,-0.04618119549647492},
{0.7761146442330276,0.09107833576737696,-0.07388854413084424},
{0.7511520880672761,0.10584745934058419,-0.08312422332233738},
{0.7261895319015248,0.12061658291379135,-0.07388854413084424},
{0.7069878048970158,0.13197649009352017,-0.04618119549647492},
{0.6993077362149922,0.13652107508519154,-2.1774192294113347e-06},
{0.7358386096867162,0.20010793778180078,0.036335838920746606},
{0.7598399907926274,0.1959895048393143,0.058138959784622135},
{0.7910424083500917,0.1906330535349624,0.06540656305261734},
{0.8222448259075562,0.18527660223061052,0.058138959784622135},
{0.8462462070134675,0.1811550586892247,0.036335838920746606},
{0.8558455152162722,0.17950644127267054,-2.48847911932724e-06},
{0.8462462070134675,0.1811550586892247,-0.036340815878985265},
{0.8222448259075562,0.18527660223061052,-0.058143936742860794},
{0.7910424083500917,0.1906330535349624,-0.065411540010856},
{0.7598399907926274,0.1959895048393143,-0.058143936742860794},
{0.7358386096867162,0.20010793778180078,-0.036340815878985265},
{0.7262393014839111,0.20175655519835511,-2.48847911932724e-06},
{0.7730413725206584,0.25662440918062157,-2.48847911932724e-06},
{0.7868648740285212,0.25662440918062157,0.03239937601386083},
{0.8214298489959765,0.25662440918062157,0.051840619133604895},
{0.8663593394954299,0.25662440918062157,0.05832092982022294},
{0.911288829994883,0.25662440918062157,0.051840619133604895},
{0.9458538049623386,0.25662440918062157,0.03239937601386083},
{0.9596773064702013,0.25662440918062157,-2.48847911932724e-06},
{0.9458538049623386,0.25662440918062157,-0.03240497509187932},
{0.911288829994883,0.25662440918062157,-0.05184621821162338},
{0.8663593394954299,0.25662440918062157,-0.05832652889824143},
{0.8214298489959765,0.25662440918062157,-0.05184621821162338},
{0.7868648740285212,0.25662440918062157,-0.03240497509187932},
{0.7883050813188318,0.26634503074049365,-2.799539009243145e-06},
{0.8030306565074508,0.26655655146563645,0.03142420325897447},
{0.8398383732811999,0.2670791320806951,0.05025639111426319},
{0.8876918267458627,0.2677634638385102,0.05651180550047204},
{0.9355421696116263,0.2684446849974261,0.05020848789121614},
{0.9723529969842745,0.2689703762113839,0.0313641687002207},
{0.9870754615739942,0.2691787863376276,-2.799539009243145e-06},
{0.9723529969842745,0.2689703762113839,-0.03144473321170892},
{0.9355421696116263,0.2684446849974261,-0.050309893415328724},
{0.8876918267458627,0.2677634638385102,-0.05659828014986866},
{0.8398383732811999,0.2670791320806951,-0.050309893415328724},
{0.8030306565074508,0.26655655146563645,-0.03144473321170892},
{0.801842407727972,0.2721774036764169,-2.799539009243145e-06},
{0.8165213239331036,0.2725600073410134,0.02891892690559177},
{0.8532170591464828,0.2735211824008536,0.04608010103225225},
{0.9009212038639861,0.2747685325594164,0.05162443251011334},
{0.9486253485814894,0.27601899331687824,0.045696253128096026},
{0.9853210837948686,0.2769770577778193,0.028438961495451526},
{1.0,0.27736277204131504,-2.799539009243145e-06},
{0.9853210837948686,0.2769770577778193,-0.029044595101117794},
{0.9486253485814894,0.27601899331687824,-0.046469859074316874},
{0.9009212038639861,0.2747685325594164,-0.05227828039871657},
{0.8532170591464828,0.2735211824008536,-0.046469859074316874},
{0.8165213239331036,0.2725600073410134,-0.029044595101117794},
{0.8119238587601466,0.27412152798839123,-2.799539009243145e-06},
{0.8258220146415891,0.27460678141666006,0.025513754290682356},
{0.8605642937462966,0.27582302558623134,0.040175873261758456},
{0.9057270791631867,0.2774032098270041,0.04446912186237778},
{0.9508929751789761,0.2789802834688777,0.03887968670047888},
{0.9856352542836836,0.2801965276384489,0.023893754384000324},
{0.9995334101651261,0.28068178106671765,-2.799539009243145e-06},
{0.9856352542836836,0.2801965276384489,-0.025924353345371354},
{0.9508929751789761,0.2789802834688777,-0.0414773478411666},
{0.9057270791631867,0.2774032098270041,-0.04666178302639499},
{0.8605642937462966,0.27582302558623134,-0.0414773478411666},
{0.8258220146415891,0.27460678141666006,-0.025924353345371354},
{0.8168199414274226,0.2721774036764169,-2.799539009243145e-06},
{0.8294085351723194,0.2726564359068874,0.021838581691325944},
{0.8257629132625051,0.2666747542238046,0.018523305384602225},
{0.8531579577673989,0.2674990629320816,0.02663885791250819},
{0.8608753536362124,0.27385712708196275,0.03340721005718836},
{0.8148042733407677,0.26634503074049365,-2.799539009243145e-06},
{0.8133640660504571,0.25662440918062157,0.01619813270748084},
{0.8364042720965281,0.25662440918062157,0.020734630142014394},
{0.8663593394954299,0.25662440918062157,0.01749431926876041},
{0.8887712045638708,0.2685722195522916,0.026594065288360298},
{0.9017859503579522,0.2754186477293406,0.03585556245071645},
{0.8041473615122489,0.25662440918062157,-2.48847911932724e-06},
{0.8133640660504571,0.25662440918062157,-0.019444042658753304},
{0.8257629132625051,0.2666747542238046,-0.020403973479033787},
{0.8364042720965281,0.25662440918062157,-0.031108788530599743},
{0.8531579577673989,0.2674990629320816,-0.03264480226700448},
{0.8663593394954299,0.25662440918062157,-0.034997037154548556},
{0.8887712045638708,0.2685722195522916,-0.036725285902921324},
{0.8963144068943314,0.25662440918062157,-0.031108788530599743},
{0.9243844513603428,0.26964537617250145,-0.03264480226700448},
{0.9193546129404027,0.25662440918062157,-0.019444042658753304},
{0.9517794958652366,0.2704696848807786,-0.020403973479033787},
{0.928571317478611,0.25662440918062157,-2.48847911932724e-06},
{0.9627381357869738,0.27079940836408944,-2.799539009243145e-06},
{0.9517794958652366,0.2704696848807786,0.011023029318949926},
{0.9193546129404027,0.25662440918062157,0.0032375113342447393},
{0.9243844513603428,0.26964537617250145,0.020638512636030382},
{0.8963144068943314,0.25662440918062157,0.010365759771557617},
{0.942693436480793,0.2769770577778193,0.030335182584378884},
{0.9741633655435851,0.27817774895289465,0.01799823629042418},
{0.9867519592884817,0.2786567811833651,-2.799539009243145e-06},
{0.9741633655435851,0.27817774895289465,-0.022804422649514825},
{0.942693436480793,0.2769770577778193,-0.03648514766790624},
{0.9017859503579522,0.2754186477293406,-0.04104528565407341},
{0.8608753536362124,0.27385712708196275,-0.03648514766790624},
{0.8294085351723194,0.2726564359068874,-0.022804422649514825},
{-0.06682033025228512,0.48991932661755033,-3.421658789074955e-06},
{0.016837982901037864,0.48278983394067776,0.02335033275631724},
{0.01987330530683726,0.48278983394067776,-3.421658789074955e-06},
{0.016837982901037864,0.48278983394067776,-0.02335717607389539},
{0.04608290057126149,0.4639987059908579,-3.421658789074955e-06},
{0.04212964043032026,0.4639987059908579,0.03040921483817887},
{0.008233755286074012,0.48278983394067776,0.04414561957686523},
{-0.005186923664347706,0.48278983394067776,0.06162998492914834},
{-0.022671289016630812,0.48278983394067776,0.07505066387957006},
{-0.043466575837178806,0.48278983394067776,0.0836548914945339},
{-0.06682033025228512,0.48278983394067776,0.08669021390033331},
{-0.09017408466739144,0.48278983394067776,0.0836548914945339},
{-0.11096937148793944,0.48278983394067776,0.07505066387957006},
{-0.12845373684022254,0.48278983394067776,0.06162998492914834},
{-0.14187441579064425,0.48278983394067776,0.04414561957686523},
{-0.1504786434056081,0.48278983394067776,0.02335033275631724},
{-0.1535139658114075,0.48278983394067776,-3.421658789074955e-06},
{-0.1504786434056081,0.48278983394067776,-0.02335717607389539},
{-0.14187441579064425,0.48278983394067776,-0.04415246289444339},
{-0.12845373684022254,0.48278983394067776,-0.061636828246726484},
{-0.11096937148793944,0.48278983394067776,-0.07505750719714821},
{-0.09017408466739144,0.48278983394067776,-0.08366173481211206},
{-0.06682033025228512,0.48278983394067776,-0.08669705721791146},
{-0.043466575837178806,0.48278983394067776,-0.08366173481211206},
{-0.022671289016630812,0.48278983394067776,-0.07505750719714821},
{-0.005186923664347706,0.48278983394067776,-0.061636828246726484},
{0.008233755286074012,0.48278983394067776,-0.04415246289444339},
{0.04212964043032026,0.4639987059908579,-0.030416058155757018},
{0.030733339243471245,0.43742797019424146,-0.027230182763238325},
{0.034274133970384,0.43742797019424146,-3.421658789074955e-06},
{0.030733339243471245,0.43742797019424146,0.02722333944566017},
{0.020696991895334575,0.43742797019424146,0.0514710799843848},
{0.03092339683620987,0.4639987059908579,0.057491333093817217},
{0.013444630561945257,0.4639987059908579,0.08026185021533122},
{-0.00932588655956874,0.4639987059908579,0.09774061648959582},
{-0.036407693755317175,0.4639987059908579,0.10894686008370623},
{-0.06682033025228512,0.4639987059908579,0.11290012022464747},
{-0.09723296674925307,0.4639987059908579,0.10894686008370623},
{-0.1243147739450015,0.4639987059908579,0.09774061648959582},
{-0.1470852910665155,0.4639987059908579,0.08026185021533122},
{-0.16456405734078008,0.4639987059908579,0.057491333093817217},
{-0.17577030093489052,0.4639987059908579,0.03040921483817887},
{-0.1797235610758317,0.4639987059908579,-3.421658789074955e-06},
{-0.17577030093489052,0.4639987059908579,-0.030416058155757018},
{-0.16456405734078008,0.4639987059908579,-0.057497554291615544},
{-0.1470852910665155,0.4639987059908579,-0.08026807141312954},
{-0.1243147739450015,0.4639987059908579,-0.09774683768739416},
{-0.09723296674925307,0.4639987059908579,-0.10895308128150455},
{-0.06682033025228512,0.4639987059908579,-0.11290634142244578},
{-0.036407693755317175,0.4639987059908579,-0.10895308128150455},
{-0.00932588655956874,0.4639987059908579,-0.09774683768739416},
{0.013444630561945257,0.4639987059908579,-0.08026807141312954},
{0.03092339683620987,0.4639987059908579,-0.057497554291615544},
{0.020696991895334575,0.43742797019424146,-0.05147792330196295},
{-0.002997062039339737,0.40696898577367596,-0.037531864197473265},
{0.004327776248399989,0.40696898577367596,-0.019849664755203642},
{0.0069123728737112465,0.40696898577367596,-3.11059889915905e-06},
{0.004327776248399989,0.40696898577367596,0.01984344355740533},
{-0.002997062039339737,0.40696898577367596,0.037525020879895114},
{-0.014418248017382021,0.40696898577367596,0.052398660576114024},
{0.005044147174876318,0.43742797019424146,0.07186105576837237},
{-0.015345828609111253,0.43742797019424146,0.08751390048883062},
{-0.03959356914783588,0.43742797019424146,0.0975502478369673},
{-0.06682033025228512,0.43742797019424146,0.10109104256388003},
{-0.09404709135673436,0.43742797019424146,0.0975502478369673},
{-0.11829483189545899,0.43742797019424146,0.08751390048883062},
{-0.13868480767944658,0.43742797019424146,0.07186105576837237},
{-0.15433765239990482,0.43742797019424146,0.0514710799843848},
{-0.1643739997480415,0.43742797019424146,0.02722333944566017},
{-0.16791479447495422,0.43742797019424146,-3.421658789074955e-06},
{-0.1643739997480415,0.43742797019424146,-0.027230182763238325},
{-0.15433765239990482,0.43742797019424146,-0.05147792330196295},
{-0.13868480767944658,0.43742797019424146,-0.07186789908595052},
{-0.11829483189545899,0.43742797019424146,-0.08752074380640877},
{-0.09404709135673436,0.43742797019424146,-0.09755709115454546},
{-0.06682033025228512,0.43742797019424146,-0.1010978858814582},
{-0.03959356914783588,0.43742797019424146,-0.09755709115454546},
{-0.015345828609111253,0.43742797019424146,-0.08752074380640877},
{0.005044147174876318,0.43742797019424146,-0.07186789908595052},
{-0.014418248017382021,0.40696898577367596,-0.05240550389369218},
{-0.02897305132643713,0.37651311195200965,-0.03785038952474715},
{-0.020710678530490863,0.37651311195200965,-0.027098293369913977},
{-0.015408662706874259,0.37651311195200965,-0.014325863230077004},
{-0.01353701534925026,0.37651311195200965,-3.11059889915905e-06},
{-0.015408662706874259,0.37651311195200965,0.014319642032278685},
{-0.020710678530490863,0.37651311195200965,0.027092072172115664},
{-0.02897305132643713,0.37651311195200965,0.037844168326948834},
{-0.02929188771360093,0.40696898577367596,0.0638198465541563},
{-0.0397251474812703,0.37651311195200965,0.0461065411228951},
{-0.046973776095980635,0.40696898577367596,0.07114468484189604},
{-0.05249757762110727,0.37651311195200965,0.0514085569465117},
{-0.06682033025228512,0.40696898577367596,0.0737292814672073},
{-0.06682033025228512,0.37651311195200965,0.0532802043041357},
{-0.08114308288346296,0.37651311195200965,0.0514085569465117},
{-0.0866668844085896,0.40696898577367596,0.07114468484189604},
{-0.10434877279096931,0.40696898577367596,0.0638198465541563},
{-0.11922241248718823,0.40696898577367596,0.052398660576114024},
{-0.13064359846523052,0.40696898577367596,0.037525020879895114},
{-0.13796843675297024,0.40696898577367596,0.01984344355740533},
{-0.14055303337828148,0.40696898577367596,-3.11059889915905e-06},
{-0.13796843675297024,0.40696898577367596,-0.019849664755203642},
{-0.13064359846523052,0.40696898577367596,-0.037531864197473265},
{-0.11922241248718823,0.40696898577367596,-0.05240550389369218},
{-0.10434877279096931,0.40696898577367596,-0.06382668987173447},
{-0.0866668844085896,0.40696898577367596,-0.07115152815947419},
{-0.06682033025228512,0.40696898577367596,-0.07373612478478545},
{-0.046973776095980635,0.40696898577367596,-0.07115152815947419},
{-0.02929188771360093,0.40696898577367596,-0.06382668987173447},
{-0.09391551302329995,0.37651311195200965,0.0461065411228951},
{-0.10466760917813311,0.37651311195200965,0.037844168326948834},
{-0.11292998197407937,0.37651311195200965,0.027092072172115664},
{-0.11823199779769598,0.37651311195200965,0.014319642032278685},
{-0.12010364515531999,0.37651311195200965,-3.11059889915905e-06},
{-0.11823199779769598,0.37651311195200965,-0.014325863230077004},
{-0.11292998197407937,0.37651311195200965,-0.027098293369913977},
{-0.10466760917813311,0.37651311195200965,-0.03785038952474715},
{-0.09391551302329995,0.37651311195200965,-0.04611276232069341},
{-0.08114308288346296,0.37651311195200965,-0.05141477814431002},
{-0.06682033025228512,0.37651311195200965,-0.05328642550193402},
{-0.05249757762110727,0.37651311195200965,-0.05141477814431002},
{-0.0397251474812703,0.37651311195200965,-0.04611276232069341}
};


// normal array: 14kb.
const tgx::fVec3 teapot_norm_array[1202] PROGMEM = {
{0.0,-1.0,0.0},
{0.024781172539687934,-0.9996709602402888,-0.006623046113165457},
{0.025666168672814207,-0.9996705696306453,0.0},
{0.024781172539687934,-0.9996709602402888,0.006623046113165457},
{0.06866834518180112,-0.997639543307097,0.0},
{0.06625765943402166,-0.9976449861834202,-0.017731444086945155},
{0.022156193772260135,-0.999672742875639,-0.012787111832726593},
{0.018067172127907035,-0.9996735239980106,-0.018067172127907035},
{0.012787120326466915,-0.9996734069005414,-0.022126208207038943},
{0.006623051034030265,-0.9996717029869894,-0.02475119072071313},
{0.0,-0.9996705696306453,-0.025666168672814207},
{-0.006623051034030265,-0.9996717029869894,-0.02475119072071313},
{-0.012787120326466915,-0.9996734069005414,-0.022126208207038943},
{-0.018067172127907035,-0.9996735239980106,-0.018067172127907035},
{-0.022156193772260135,-0.999672742875639,-0.012787111832726593},
{-0.024781172539687934,-0.9996709602402888,-0.006623046113165457},
{-0.025666168672814207,-0.9996705696306453,0.0},
{-0.024781172539687934,-0.9996709602402888,0.006623046113165457},
{-0.022156193772260135,-0.999672742875639,0.012787111832726593},
{-0.018067172127907035,-0.9996735239980106,0.018067172127907035},
{-0.012787111832726593,-0.999672742875639,0.022156193772260135},
{-0.006623046113165457,-0.9996709602402888,0.024781172539687934},
{0.0,-0.9996705696306453,0.025666168672814207},
{0.006623046113165457,-0.9996709602402888,0.024781172539687934},
{0.012787111832726593,-0.999672742875639,0.022156193772260135},
{0.018067172127907035,-0.9996735239980106,0.018067172127907035},
{0.022156193772260135,-0.999672742875639,0.012787111832726593},
{0.06625765943402166,-0.9976449861834202,0.017731444086945155},
{0.15717365737894168,-0.987570980449571,0.0},
{0.15167941339262161,-0.9875947137593165,-0.04062064632085478},
{0.05923638679235873,-0.9976565143391973,-0.03424222358943797},
{0.04834150210012052,-0.9976603622222385,-0.04834150210012052},
{0.034272188563015706,-0.9976554890258118,-0.05923632591383048},
{0.017731444086945155,-0.9976449861834202,-0.06625765943402166},
{0.0,-0.997639543307097,-0.06866834518180112},
{-0.017731444086945155,-0.9976449861834202,-0.06625765943402166},
{-0.034272188563015706,-0.9976554890258118,-0.05923632591383048},
{-0.04834150210012052,-0.9976603622222385,-0.04834150210012052},
{-0.05923638679235873,-0.9976565143391973,-0.03424222358943797},
{-0.06625765943402166,-0.9976449861834202,-0.017731444086945155},
{-0.06866834518180112,-0.997639543307097,0.0},
{-0.06625765943402166,-0.9976449861834202,0.017731444086945155},
{-0.05923632591383048,-0.9976554890258118,0.034272188563015706},
{-0.04834150210012052,-0.9976603622222385,0.04834150210012052},
{-0.034272188563015706,-0.9976554890258118,0.05923632591383048},
{-0.017731444086945155,-0.9976449861834202,0.06625765943402166},
{0.0,-0.997639543307097,0.06866834518180112},
{0.017731444086945155,-0.9976449861834202,0.06625765943402166},
{0.034272188563015706,-0.9976554890258118,0.05923632591383048},
{0.04834150210012052,-0.9976603622222385,0.04834150210012052},
{0.05923632591383048,-0.9976554890258118,0.034272188563015706},
{0.15167941339262161,-0.9875947137593165,0.04062064632085478},
{0.37315277875427,-0.9277699088178959,0.0},
{0.3601518554056155,-0.9278923566441655,-0.09646976484489565},
{0.13562514730239097,-0.9876483548762272,-0.078463663752636},
{0.11069444461221738,-0.9876707345385838,-0.11069444461221738},
{0.078463663752636,-0.9876483548762272,-0.13562514730239097},
{0.04062064632085478,-0.9875947137593165,-0.15167941339262161},
{0.0,-0.987570980449571,-0.15717365737894168},
{-0.04062064632085478,-0.9875947137593165,-0.15167941339262161},
{-0.078463663752636,-0.9876483548762272,-0.13562514730239097},
{-0.11069444461221738,-0.9876707345385838,-0.11069444461221738},
{-0.13562514730239097,-0.9876483548762272,-0.078463663752636},
{-0.15167941339262161,-0.9875947137593165,-0.04062064632085478},
{-0.15717365737894168,-0.987570980449571,0.0},
{-0.15167941339262161,-0.9875947137593165,0.04062064632085478},
{-0.13562514730239097,-0.9876483548762272,0.078463663752636},
{-0.11069444461221738,-0.9876707345385838,0.11069444461221738},
{-0.078463663752636,-0.9876483548762272,0.13562514730239097},
{-0.04062064632085478,-0.9875947137593165,0.15167941339262161},
{0.0,-0.987570980449571,0.15717365737894168},
{0.04062064632085478,-0.9875947137593165,0.15167941339262161},
{0.078463663752636,-0.9876483548762272,0.13562514730239097},
{0.11069444461221738,-0.9876707345385838,0.11069444461221738},
{0.13562514730239097,-0.9876483548762272,0.078463663752636},
{0.3601248757300209,-0.927902716100696,0.09647084188182592},
{0.7891717932490163,-0.614172517083052,0.0},
{0.7620300856297356,-0.6144095506803968,-0.20447751130100056},
{0.3221641425994221,-0.9281611020436221,-0.18635244531893824},
{0.2629559184827872,-0.9282824838753274,-0.2629559184827872},
{0.1863823695503497,-0.9281557395408045,-0.32216228127802155},
{0.09647084188182592,-0.927902716100696,-0.3601248757300209},
{0.0,-0.9277699088178959,-0.37315277875427},
{-0.09647084188182592,-0.927902716100696,-0.3601248757300209},
{-0.1863823695503497,-0.9281557395408045,-0.32216228127802155},
{-0.2629559184827872,-0.9282824838753274,-0.2629559184827872},
{-0.3221641425994221,-0.9281611020436221,-0.18635244531893824},
{-0.3601518554056155,-0.9278923566441655,-0.09646976484489565},
{-0.37315277875427,-0.9277699088178959,0.0},
{-0.3601248757300209,-0.927902716100696,0.09647084188182592},
{-0.32216228127802155,-0.9281557395408045,0.1863823695503497},
{-0.2629559184827872,-0.9282824838753274,0.2629559184827872},
{-0.1863823695503497,-0.9281557395408045,0.32216228127802155},
{-0.09646976484489565,-0.9278923566441655,0.3601518554056155},
{0.0,-0.9277699088178959,0.37315277875427},
{0.09646976484489565,-0.9278923566441655,0.3601518554056155},
{0.1863823695503497,-0.9281557395408045,0.32216228127802155},
{0.2629559184827872,-0.9282824838753274,0.2629559184827872},
{0.32216228127802155,-0.9281557395408045,0.1863823695503497},
{0.7620252548680762,-0.6144056557343093,0.20450721538600308},
{0.8864019194725241,-0.4629164472725341,0.0},
{0.8558650933902008,-0.4634724624278182,-0.22953914369291692},
{0.6823444085899012,-0.6151412849742202,-0.3949776039047824},
{0.5573519580488455,-0.6154003491372392,-0.5573519580488455},
{0.3949776039047824,-0.6151412849742202,-0.6823444085899012},
{0.20450721538600308,-0.6144056557343093,-0.7620252548680762},
{0.0,-0.614172517083052,-0.7891717932490163},
{-0.20450721538600308,-0.6144056557343093,-0.7620252548680762},
{-0.3949776039047824,-0.6151412849742202,-0.6823444085899012},
{-0.5573519580488455,-0.6154003491372392,-0.5573519580488455},
{-0.6823444085899012,-0.6151412849742202,-0.3949776039047824},
{-0.7620300856297356,-0.6144095506803968,-0.20447751130100056},
{-0.7891717932490163,-0.614172517083052,0.0},
{-0.7620252548680762,-0.6144056557343093,0.20450721538600308},
{-0.6823444085899012,-0.6151412849742202,0.3949776039047824},
{-0.5573519580488455,-0.6154003491372392,0.5573519580488455},
{-0.3949776039047824,-0.6151412849742202,0.6823444085899012},
{-0.20447751130100056,-0.6144095506803968,0.7620300856297356},
{0.0,-0.614172517083052,0.7891717932490163},
{0.20447751130100056,-0.6144095506803968,0.7620300856297356},
{0.3949776039047824,-0.6151412849742202,0.6823444085899012},
{0.5573519580488455,-0.6154003491372392,0.5573519580488455},
{0.6823570009884382,-0.6151226361102121,0.3949848930616055},
{0.8558731182490574,-0.46346056210646197,0.22953324994561752},
{0.724035447749479,-0.689762763855959,0.0},
{0.6987755864705631,-0.6903523021510312,-0.1874203261855338},
{0.7666341713247493,-0.4641305524423274,-0.4436833078298022},
{0.6262356405487668,-0.464389755499571,-0.6262356405487668},
{0.4436833078298022,-0.4641305524423274,-0.7666341713247493},
{0.22953914369291692,-0.4634724624278182,-0.8558650933902008},
{0.0,-0.4629164472725341,-0.8864019194725241},
{-0.22953914369291692,-0.4634724624278182,-0.8558650933902008},
{-0.4436833078298022,-0.4641305524423274,-0.7666341713247493},
{-0.6262356405487668,-0.464389755499571,-0.6262356405487668},
{-0.7666341713247493,-0.4641305524423274,-0.4436833078298022},
{-0.8558650933902008,-0.4634724624278182,-0.22953914369291692},
{-0.8864019194725241,-0.4629164472725341,0.0},
{-0.8558731182490574,-0.46346056210646197,0.22953324994561752},
{-0.7666341713247493,-0.4641305524423274,0.4436833078298022},
{-0.6262356405487668,-0.464389755499571,0.6262356405487668},
{-0.4436833078298022,-0.4641305524423274,0.7666341713247493},
{-0.22953914369291692,-0.4634724624278182,0.8558650933902008},
{0.0,-0.4629164472725341,0.8864019194725241},
{0.22953914369291692,-0.4634724624278182,0.8558650933902008},
{0.4436833078298022,-0.4641305524423274,0.7666341713247493},
{0.6262356405487668,-0.464389755499571,0.6262356405487668},
{0.7666341713247493,-0.4641305524423274,0.4436833078298022},
{0.6987715261259274,-0.6903482907512041,0.18745023801674193},
{0.6529904806804707,-0.7573661149937247,0.0},
{0.6301720091581707,-0.7578362782594947,-0.16901897593865667},
{0.6256709506748395,-0.690951093226869,-0.3621083377253791},
{0.5109922921712483,-0.6912118016087018,-0.5109922921712483},
{0.3621083377253791,-0.690951093226869,-0.6256709506748395},
{0.1874203261855338,-0.6903523021510312,-0.6987755864705631},
{0.0,-0.689762763855959,-0.724035447749479},
{-0.1874203261855338,-0.6903523021510312,-0.6987755864705631},
{-0.3621083377253791,-0.690951093226869,-0.6256709506748395},
{-0.5109922921712483,-0.6912118016087018,-0.5109922921712483},
{-0.6256709506748395,-0.690951093226869,-0.3621083377253791},
{-0.6987755864705631,-0.6903523021510312,-0.1874203261855338},
{-0.724035447749479,-0.689762763855959,0.0},
{-0.6987715261259274,-0.6903482907512041,0.18745023801674193},
{-0.6256709506748395,-0.690951093226869,0.3621083377253791},
{-0.5109922921712483,-0.6912118016087018,0.5109922921712483},
{-0.3621083377253791,-0.690951093226869,0.6256709506748395},
{-0.1874203261855338,-0.6903523021510312,0.6987755864705631},
{0.0,-0.689762763855959,0.724035447749479},
{0.1874203261855338,-0.6903523021510312,0.6987755864705631},
{0.3621083377253791,-0.690951093226869,0.6256709506748395},
{0.5109922921712483,-0.6912118016087018,0.5109922921712483},
{0.6256709506748395,-0.690951093226869,0.3621083377253791},
{0.6301720091581707,-0.7578362782594947,0.16901897593865667},
{0.7121849494999813,-0.7019918786607927,0.0},
{0.687417168100128,-0.7024635657690722,-0.1843978735457673},
{0.564054743544309,-0.7584617910730334,-0.32646279691176194},
{0.46065648691085637,-0.7586772713966696,-0.46065648691085637},
{0.32646279691176194,-0.7584617910730334,-0.564054743544309},
{0.16901897593865667,-0.7578362782594947,-0.6301720091581707},
{0.0,-0.7573661149937247,-0.6529904806804707},
{-0.16901897593865667,-0.7578362782594947,-0.6301720091581707},
{-0.32646279691176194,-0.7584617910730334,-0.564054743544309},
{-0.46065648691085637,-0.7586772713966696,-0.46065648691085637},
{-0.564054743544309,-0.7584617910730334,-0.32646279691176194},
{-0.6301720091581707,-0.7578362782594947,-0.16901897593865667},
{-0.6529904806804707,-0.7573661149937247,0.0},
{-0.6301720091581707,-0.7578362782594947,0.16901897593865667},
{-0.564054743544309,-0.7584617910730334,0.32646279691176194},
{-0.46065648691085637,-0.7586772713966696,0.46065648691085637},
{-0.32646279691176194,-0.7584617910730334,0.564054743544309},
{-0.16901897593865667,-0.7578362782594947,0.6301720091581707},
{0.0,-0.7573661149937247,0.6529904806804707},
{0.16901897593865667,-0.7578362782594947,0.6301720091581707},
{0.32646279691176194,-0.7584617910730334,0.564054743544309},
{0.46065648691085637,-0.7586772713966696,0.46065648691085637},
{0.564054743544309,-0.7584617910730334,0.32646279691176194},
{0.687417168100128,-0.7024635657690722,0.1843978735457673},
{0.8244041464590732,-0.5660015930199196,0.0},
{0.7959127702781461,-0.5664997834769234,-0.21354357267023008},
{0.6153921626830398,-0.7031656105982997,-0.3561609329786346},
{0.5025859342955807,-0.7034307053978214,-0.5025859342955807},
{0.3561609329786346,-0.7031656105982997,-0.6153921626830398},
{0.1843978735457673,-0.7024635657690722,-0.687417168100128},
{0.0,-0.7020073773340193,-0.7121696723173571},
{-0.1843978735457673,-0.7024635657690722,-0.687417168100128},
{-0.3561609329786346,-0.7031656105982997,-0.6153921626830398},
{-0.5025859342955807,-0.7034307053978214,-0.5025859342955807},
{-0.6153921626830398,-0.7031656105982997,-0.3561609329786346},
{-0.687417168100128,-0.7024635657690722,-0.1843978735457673},
{-0.7121849494999813,-0.7019918786607927,0.0},
{-0.687417168100128,-0.7024635657690722,0.1843978735457673},
{-0.6153921626830398,-0.7031656105982997,0.3561609329786346},
{-0.5025859342955807,-0.7034307053978214,0.5025859342955807},
{-0.3561609329786346,-0.7031656105982997,0.6153921626830398},
{-0.1843978735457673,-0.7024635657690722,0.687417168100128},
{0.0,-0.7019918786607927,0.7121849494999813},
{0.1843978735457673,-0.7024635657690722,0.687417168100128},
{0.3561609329786346,-0.7031656105982997,0.6153921626830398},
{0.5025859342955807,-0.7034307053978214,0.5025859342955807},
{0.6153921626830398,-0.7031656105982997,0.3561609329786346},
{0.7959127702781461,-0.5664997834769234,0.21354357267023008},
{0.9452728602689336,-0.32628089070460276,0.0},
{0.912850434065986,-0.32661309104875846,-0.24500606886588847},
{0.7127469620392172,-0.56726229565911,-0.41255939696899807},
{0.5821921435748169,-0.5675426115451769,-0.5821921435748169},
{0.41255939696899807,-0.56726229565911,-0.7127469620392172},
{0.21354357267023008,-0.5664997834769234,-0.7959127702781461},
{0.0,-0.5660015930199196,-0.8244041464590732},
{-0.21354357267023008,-0.5664997834769234,-0.7959127702781461},
{-0.41255939696899807,-0.56726229565911,-0.7127469620392172},
{-0.5821921435748169,-0.5675426115451769,-0.5821921435748169},
{-0.7127469620392172,-0.56726229565911,-0.41255939696899807},
{-0.7959127702781461,-0.5664997834769234,-0.21354357267023008},
{-0.8244041464590732,-0.5660015930199196,0.0},
{-0.7959127702781461,-0.5664997834769234,0.21354357267023008},
{-0.7127469620392172,-0.56726229565911,0.41255939696899807},
{-0.5821921435748169,-0.5675426115451769,0.5821921435748169},
{-0.41255939696899807,-0.56726229565911,0.7127469620392172},
{-0.21354357267023008,-0.5664997834769234,0.7959127702781461},
{0.0,-0.5660015930199196,0.8244041464590732},
{0.21354357267023008,-0.5664997834769234,0.7959127702781461},
{0.41255939696899807,-0.56726229565911,0.7127469620392172},
{0.5821921435748169,-0.5675426115451769,0.5821921435748169},
{0.7127469620392172,-0.56726229565911,0.41255939696899807},
{0.912850434065986,-0.32661309104875846,0.24500606886588847},
{0.9989571685634214,-0.04565715032447811,0.0},
{0.9647988879812689,-0.04571780025108228,-0.2589845333032633},
{0.8178040857681869,-0.3271700360879026,-0.47345141755738845},
{0.6681319325502516,-0.32741325784600167,-0.6681319325502516},
{0.47345141755738845,-0.3271700360879026,-0.8178040857681869},
{0.24500606886588847,-0.32661309104875846,-0.912850434065986},
{0.0,-0.32628089070460276,-0.9452728602689336},
{-0.24500606886588847,-0.32661309104875846,-0.912850434065986},
{-0.47345141755738845,-0.3271700360879026,-0.8178040857681869},
{-0.6681319325502516,-0.32741325784600167,-0.6681319325502516},
{-0.8178040857681869,-0.3271700360879026,-0.47345141755738845},
{-0.912850434065986,-0.32661309104875846,-0.24500606886588847},
{-0.9452728602689336,-0.32628089070460276,0.0},
{-0.912850434065986,-0.32661309104875846,0.24500606886588847},
{-0.8178040857681869,-0.3271700360879026,0.47345141755738845},
{-0.6681319325502516,-0.32741325784600167,0.6681319325502516},
{-0.47345141755738845,-0.3271700360879026,0.8178040857681869},
{-0.24500606886588847,-0.32661309104875846,0.912850434065986},
{0.0,-0.32628089070460276,0.9452728602689336},
{0.24500606886588847,-0.32661309104875846,0.912850434065986},
{0.47345141755738845,-0.3271700360879026,0.8178040857681869},
{0.6681319325502516,-0.32741325784600167,0.6681319325502516},
{0.8178040857681869,-0.3271700360879026,0.47345141755738845},
{0.9647988879812689,-0.04571780025108228,0.2589845333032633},
{0.954586305925456,0.1521085104063719,0.2561795963802471},
{0.9883966675924873,0.15189479086547422,0.0},
{0.954586305925456,0.1521085104063719,-0.2561795963802471},
{0.8553403659479937,0.1523840535650024,-0.49514842077810445},
{0.8645155416807074,-0.04580892949817102,-0.500514155814543},
{0.7063625012422191,-0.04586974686732141,-0.7063625012422191},
{0.500514155814543,-0.04580892949817102,-0.8645155416807074},
{0.2589845333032633,-0.04571780025108228,-0.9647988879812689},
{0.0,-0.04565715032447811,-0.9989571685634214},
{-0.2589845333032633,-0.04571780025108228,-0.9647988879812689},
{-0.500514155814543,-0.04580892949817102,-0.8645155416807074},
{-0.7063625012422191,-0.04586974686732141,-0.7063625012422191},
{-0.8645155416807074,-0.04580892949817102,-0.500514155814543},
{-0.9647988879812689,-0.04571780025108228,-0.2589845333032633},
{-0.9989571685634214,-0.04565715032447811,0.0},
{-0.9647988879812689,-0.04571780025108228,0.2589845333032633},
{-0.8645155416807074,-0.04580892949817102,0.500514155814543},
{-0.7063625012422191,-0.04586974686732141,0.7063625012422191},
{-0.500514155814543,-0.04580892949817102,0.8645155416807074},
{-0.2589845333032633,-0.04571780025108228,0.9647988879812689},
{0.0,-0.04565715032447811,0.9989571685634214},
{0.2589845333032633,-0.04571780025108228,0.9647988879812689},
{0.500514155814543,-0.04580892949817102,0.8645155416807074},
{0.7063625012422191,-0.04586974686732141,0.7063625012422191},
{0.8645155416807074,-0.04580892949817102,0.500514155814543},
{0.8553364552532411,0.15241335770887257,0.49514615691402414},
{0.8341892239192535,0.26637469318726564,0.4828797588700354},
{0.9310523369680219,0.26591495080544597,0.24986153118181742},
{0.9640979323092562,0.265546939197229,0.0},
{0.9310593158347993,0.2659169440177952,-0.24983340305385954},
{0.8341892239192535,0.26637469318726564,-0.4828797588700354},
{0.6815235153913213,0.266554677200215,-0.6815235153913213},
{0.698838746099691,0.15247561739380905,-0.698838746099691},
{0.49514842077810445,0.1523840535650024,-0.8553403659479937},
{0.25618076532052947,0.15207920344672407,-0.9545906616758818},
{0.0,0.15189479086547422,-0.9883966675924873},
{-0.25618076532052947,0.15207920344672407,-0.9545906616758818},
{-0.49514842077810445,0.1523840535650024,-0.8553403659479937},
{-0.698838746099691,0.15247561739380905,-0.698838746099691},
{-0.8553403659479937,0.1523840535650024,-0.49514842077810445},
{-0.954586305925456,0.1521085104063719,-0.2561795963802471},
{-0.9883966675924873,0.15189479086547422,0.0},
{-0.954586305925456,0.1521085104063719,0.2561795963802471},
{-0.8553364552532411,0.15241335770887257,0.49514615691402414},
{-0.6988354424336537,0.15250589758143399,0.6988354424336537},
{-0.49514615691402414,0.15241335770887257,0.8553364552532411},
{-0.25617838824987016,0.15213879384317566,0.9545818041433863},
{0.0,0.15192409923576017,0.9883921630969171},
{0.25617838824987016,0.15213879384317566,0.9545818041433863},
{0.49514615691402414,0.15241335770887257,0.8553364552532411},
{0.6988354424336537,0.15250589758143399,0.6988354424336537},
{0.681518065135507,0.26658254591760094,0.681518065135507},
{0.6640602103793032,0.3435812480069179,0.6640602103793032},
{0.812852690365947,0.3433425842321416,0.47051713424447855},
{0.9073303870247895,0.34275881269890573,0.24345012856575382},
{0.9395667881130817,0.3423656680727017,0.0},
{0.9073303870247895,0.34275881269890573,-0.24345012856575382},
{0.812852690365947,0.3433425842321416,-0.47051713424447855},
{0.6640670550299957,0.343554788712917,-0.6640670550299957},
{0.4828797588700354,0.26637469318726564,-0.8341892239192535},
{-0.94658120323918,-0.3224655418401571,0.0},
{-0.9140196717524698,-0.3229543040347362,-0.24549655222619013},
{-0.9586341149031092,-0.12222918220964402,-0.2570615894300315},
{-0.8590187849825907,-0.12241210689323791,-0.49709355571460795},
{-0.8188641850734317,-0.3234437628983679,-0.4741788466877967},
{-0.7017862496185805,-0.12244231169238343,-0.7017862496185805},
{-0.6690395952910546,-0.3236850936721735,-0.6690395952910546},
{-0.4741788466877967,-0.3234437628983679,-0.8188641850734317},
{-0.49709355571460795,-0.12241210689323791,-0.8590187849825907},
{-0.24546504115136036,-0.32298363316199347,-0.914017771316313},
{-0.257060646689871,-0.12225873437550255,-0.958630599236372},
{0.0,-0.3224924224746378,-0.9465720455657033},
{0.0,-0.12204420482299438,-0.9925246657232871},
{0.257060646689871,-0.12225873437550255,-0.958630599236372},
{0.24546504115136036,-0.32298363316199347,-0.914017771316313},
{0.49709355571460795,-0.12241210689323791,-0.8590187849825907},
{0.4741788466877967,-0.3234437628983679,-0.8188641850734317},
{0.7017862496185805,-0.12244231169238343,-0.7017862496185805},
{0.6690395952910546,-0.3236850936721735,-0.6690395952910546},
{0.8188641850734317,-0.3234437628983679,-0.4741788466877967},
{0.8590187849825907,-0.12241210689323791,-0.49709355571460795},
{0.9140196717524698,-0.3229543040347362,-0.24549655222619013},
{0.9586341149031092,-0.12222918220964402,-0.2570615894300315},
{0.94658120323918,-0.3224655418401571,0.0},
{0.9925284203623761,-0.1220136663368754,0.0},
{0.9586341149031092,-0.12222918220964402,0.2570615894300315},
{0.9140196717524698,-0.3229543040347362,0.24549655222619013},
{0.8590187849825907,-0.12241210689323791,0.49709355571460795},
{0.8188641850734317,-0.3234437628983679,0.4741788466877967},
{0.7017862496185805,-0.12244231169238343,0.7017862496185805},
{0.6690395952910546,-0.3236850936721735,0.6690395952910546},
{0.4741788466877967,-0.3234437628983679,0.8188641850734317},
{0.49709355571460795,-0.12241210689323791,0.8590187849825907},
{0.24546504115136036,-0.32298363316199347,0.914017771316313},
{0.25703262837358637,-0.12225967718204526,0.958637991781417},
{0.0,-0.3224655418401571,0.94658120323918},
{0.0,-0.1220136663368754,0.9925284203623761},
{-0.25703262837358637,-0.12225967718204526,0.958637991781417},
{-0.24546504115136036,-0.32298363316199347,0.914017771316313},
{-0.49709355571460795,-0.12241210689323791,0.8590187849825907},
{-0.4741788466877967,-0.3234437628983679,0.8188641850734317},
{-0.7017862496185805,-0.12244231169238343,0.7017862496185805},
{-0.6690395952910546,-0.3236850936721735,0.6690395952910546},
{-0.8188641850734317,-0.3234437628983679,0.4741788466877967},
{-0.8590187849825907,-0.12241210689323791,0.49709355571460795},
{-0.9140196717524698,-0.3229543040347362,0.24549655222619013},
{-0.9586341149031092,-0.12222918220964402,0.2570615894300315},
{-0.9925284203623761,-0.1220136663368754,0.0},
{-0.8320644480398245,0.5546789650853747,0.0},
{-0.803234034634289,0.5553877784198453,-0.2153125662542495},
{-0.719670752767816,0.5555696168270927,-0.41643295795266044},
{-0.587893282993657,0.5556644451662173,-0.587893282993657},
{-0.41644013015736747,0.5555481842494135,-0.7196831476224064},
{-0.21534827147738123,0.555216903980894,-0.8033425866375907},
{0.0,0.5544959469238331,-0.8321864243335393},
{0.21534827147738123,0.555216903980894,-0.8033425866375907},
{0.41644013015736747,0.5555481842494135,-0.7196831476224064},
{0.587893282993657,0.5556644451662173,-0.587893282993657},
{0.719670752767816,0.5555696168270927,-0.41643295795266044},
{0.803234034634289,0.5553877784198453,-0.2153125662542495},
{0.8320644480398245,0.5546789650853747,0.0},
{0.803234034634289,0.5553877784198453,0.2153125662542495},
{0.719670752767816,0.5555696168270927,0.41643295795266044},
{0.587893282993657,0.5556644451662173,0.587893282993657},
{0.41643295795266044,0.5555696168270927,0.719670752767816},
{0.21537688118552598,0.5552133166613381,0.8033373961497824},
{0.0,0.5546789650853747,0.8320644480398245},
{-0.21537688118552598,0.5552133166613381,0.8033373961497824},
{-0.41643295795266044,0.5555696168270927,0.719670752767816},
{-0.587893282993657,0.5556644451662173,0.587893282993657},
{-0.719670752767816,0.5555696168270927,0.41643295795266044},
{-0.803234034634289,0.5553877784198453,0.2153125662542495},
{-0.0486163662878763,0.9988175253413223,0.0},
{-0.04620550367274571,0.9988508881827792,-0.012726138723933812},
{-0.04174982483175698,0.9988297334117509,-0.02441548236526256},
{-0.034272504562361,0.9988247047715859,-0.034272504562361},
{-0.02441548236526256,0.9988297334117509,-0.04174982483175698},
{-0.01272612048911212,0.9988494569656411,-0.04623643776006506},
{0.0,0.9988085485689204,-0.04880044370337658},
{0.01272612048911212,0.9988494569656411,-0.04623643776006506},
{0.02441548236526256,0.9988297334117509,-0.04174982483175698},
{0.034272504562361,0.9988247047715859,-0.034272504562361},
{0.04174982483175698,0.9988297334117509,-0.02441548236526256},
{0.04620550367274571,0.9988508881827792,-0.012726138723933812},
{0.0486163662878763,0.9988175253413223,0.0},
{0.04620550367274571,0.9988508881827792,0.012726138723933812},
{0.04174982483175698,0.9988297334117509,0.02441548236526256},
{0.034272504562361,0.9988247047715859,0.034272504562361},
{0.02441548236526256,0.9988297334117509,0.04174982483175698},
{0.01272612048911212,0.9988494569656411,0.04623643776006506},
{0.0,0.9988175253413223,0.0486163662878763},
{-0.01272612048911212,0.9988494569656411,0.04623643776006506},
{-0.02441548236526256,0.9988297334117509,0.04174982483175698},
{-0.034272504562361,0.9988247047715859,0.034272504562361},
{-0.04174982483175698,0.9988297334117509,0.02441548236526256},
{-0.04620550367274571,0.9988508881827792,0.012726138723933812},
{0.5442756995714702,0.8389064088776452,0.0},
{0.5253876712854972,0.8391246408318775,0.14084612884270178},
{0.47011623406792147,0.8396414923182989,0.2720163429709606},
{0.3838444443898007,0.8398374158265219,0.3838444443898007},
{0.27202017938402673,0.8396533342964565,0.4700928633926758},
{0.14087456534530468,0.8390853236012357,0.5254428385236409},
{0.0,0.8389064088776452,0.5442756995714702},
{-0.14087456534530468,0.8390853236012357,0.5254428385236409},
{-0.27202017938402673,0.8396533342964565,0.4700928633926758},
{-0.3838444443898007,0.8398374158265219,0.3838444443898007},
{-0.47011623406792147,0.8396414923182989,0.2720163429709606},
{-0.5253876712854972,0.8391246408318775,0.14084612884270178},
{-0.5442756995714702,0.8389064088776452,0.0},
{-0.5253876712854972,0.8391246408318775,-0.14084612884270178},
{-0.47011623406792147,0.8396414923182989,-0.2720163429709606},
{-0.3838444443898007,0.8398374158265219,-0.3838444443898007},
{-0.2720163429709606,0.8396414923182989,-0.47011623406792147},
{-0.14087371407953744,0.8390492530851583,-0.525500663728101},
{0.0,0.8389064088776452,-0.5442756995714702},
{0.14087371407953744,0.8390492530851583,-0.525500663728101},
{0.2720163429709606,0.8396414923182989,-0.47011623406792147},
{0.3838444443898007,0.8398374158265219,-0.3838444443898007},
{0.47011623406792147,0.8396414923182989,-0.2720163429709606},
{0.5253876712854972,0.8391246408318775,-0.14084612884270178},
{0.7834911314325456,0.6214029666541265,0.0},
{0.756371346815303,0.6218707726159691,0.20292641001807077},
{0.6772571166101133,0.622627413277483,0.391992222163075},
{0.5531573967368202,0.622923581886806,0.5531573967368202},
{0.39201761276978514,0.6226200909450534,0.6772491518118369},
{0.20292331628917654,0.6219222934394022,0.7563298147166201},
{0.0,0.6214029666541265,0.7834911314325456},
{-0.20292331628917654,0.6219222934394022,0.7563298147166201},
{-0.39201761276978514,0.6226200909450534,0.6772491518118369},
{-0.5531573967368202,0.622923581886806,0.5531573967368202},
{-0.6772571166101133,0.622627413277483,0.391992222163075},
{-0.756371346815303,0.6218707726159691,0.20292641001807077},
{-0.7834911314325456,0.6214029666541265,0.0},
{-0.756371346815303,0.6218707726159691,-0.20292641001807077},
{-0.6772571166101133,0.622627413277483,-0.391992222163075},
{-0.5531573967368202,0.622923581886806,-0.5531573967368202},
{-0.39199222216307505,0.6226274132774832,-0.6772571166101135},
{-0.20292165177133412,0.6218561909034451,-0.7563846118724596},
{0.0,0.6214029666541265,-0.7834911314325456},
{0.20292165177133412,0.6218561909034451,-0.7563846118724596},
{0.39199222216307505,0.6226274132774832,-0.6772571166101135},
{0.5531573967368202,0.622923581886806,-0.5531573967368202},
{0.6772571166101133,0.622627413277483,-0.391992222163075},
{0.756371346815303,0.6218707726159691,-0.20292641001807077},
{0.8809057985992524,0.4732916373592643,0.0},
{0.8505607525638113,0.4737744323167033,0.2282196167753084},
{0.7618357497014862,0.4744913973778179,0.44098095683512245},
{0.6223234443473847,0.47479159768388374,0.6223234443473847},
{0.4409744699957123,0.47451541847575407,0.7618245430811353},
{0.2282196167753084,0.4737744323167033,0.8505607525638113},
{0.0,0.4732916373592643,0.8809057985992524},
{-0.2282196167753084,0.4737744323167033,0.8505607525638113},
{-0.4409744699957123,0.47451541847575407,0.7618245430811353},
{-0.6223234443473847,0.47479159768388374,0.6223234443473847},
{-0.7618357497014862,0.4744913973778179,0.44098095683512245},
{-0.8505607525638113,0.4737744323167033,0.2282196167753084},
{-0.8809057985992524,0.4732916373592643,0.0},
{-0.8505607525638113,0.4737744323167033,-0.2282196167753084},
{-0.7618357497014862,0.4744913973778179,-0.44098095683512245},
{-0.6223234443473847,0.47479159768388374,-0.6223234443473847},
{-0.44098095683512245,0.4744913973778179,-0.7618357497014862},
{-0.2281911786829971,0.4737776759125842,-0.8505665757470927},
{0.0,0.4732916373592643,-0.8809057985992524},
{0.2281911786829971,0.4737776759125842,-0.8505665757470927},
{0.44098095683512245,0.4744913973778179,-0.7618357497014862},
{0.6223234443473847,0.47479159768388374,-0.6223234443473847},
{0.7618357497014862,0.4744913973778179,-0.44098095683512245},
{0.8505607525638113,0.4737744323167033,-0.2282196167753084},
{0.9083226842035401,0.4182701296546,0.0},
{0.8770793283178315,0.41876229988919794,0.23530828295886866},
{0.7856616222004436,0.4194286108065308,0.4547696733933248},
{0.6418151406234563,0.4196982851203778,0.6418151406234563},
{0.4547696733933248,0.4194286108065308,0.7856616222004436},
{0.23530828295886866,0.41876229988919794,0.8770793283178315},
{0.0,0.4182701296546,0.9083226842035401},
{-0.23530828295886866,0.41876229988919794,0.8770793283178315},
{-0.4547696733933248,0.4194286108065308,0.7856616222004436},
{-0.6418151406234563,0.4196982851203778,0.6418151406234563},
{-0.7856616222004436,0.4194286108065308,0.4547696733933248},
{-0.8770793283178315,0.41876229988919794,0.23530828295886866},
{-0.9083226842035401,0.4182701296546,0.0},
{-0.8770793283178315,0.41876229988919794,-0.23530828295886866},
{-0.7856616222004436,0.4194286108065308,-0.4547696733933248},
{-0.6418151406234563,0.4196982851203778,-0.6418151406234563},
{-0.4547696733933248,0.4194286108065308,-0.7856616222004436},
{-0.23530828295886866,0.41876229988919794,-0.8770793283178315},
{0.0,0.4182701296546,-0.9083226842035401},
{0.23530828295886866,0.41876229988919794,-0.8770793283178315},
{0.4547696733933248,0.4194286108065308,-0.7856616222004436},
{0.6418151406234563,0.4196982851203778,-0.6418151406234563},
{0.7856616222004436,0.4194286108065308,-0.4547696733933248},
{0.8770793283178315,0.41876229988919794,-0.23530828295886866},
{0.9203185162871834,0.39116982063926814,0.0},
{0.8886813536747356,0.3916498850848552,0.23844458296186832},
{0.79609146125147,0.39229311167544884,0.46080852840902703},
{0.6503533380523563,0.3925316183039466,0.6503533380523563},
{0.46080852840902703,0.39229311167544884,0.79609146125147},
{0.23844458296186832,0.3916498850848552,0.8886813536747356},
{0.0,0.39116982063926814,0.9203185162871834},
{-0.23844458296186832,0.3916498850848552,0.8886813536747356},
{-0.46080852840902703,0.39229311167544884,0.79609146125147},
{-0.6503533380523563,0.3925316183039466,0.6503533380523563},
{-0.79609146125147,0.39229311167544884,0.46080852840902703},
{-0.8886813536747356,0.3916498850848552,0.23844458296186832},
{-0.9203185162871834,0.39116982063926814,0.0},
{-0.8886813536747356,0.3916498850848552,-0.23844458296186832},
{-0.79609146125147,0.39229311167544884,-0.46080852840902703},
{-0.6503533380523563,0.3925316183039466,-0.6503533380523563},
{-0.4607841100603939,0.3922987156552573,-0.7961028335655428},
{-0.23844458296186832,0.3916498850848552,-0.8886813536747356},
{0.0,0.39116982063926814,-0.9203185162871834},
{0.23844458296186832,0.3916498850848552,-0.8886813536747356},
{0.4607841100603939,0.3922987156552573,-0.7961028335655428},
{0.6503533380523563,0.3925316183039466,-0.6503533380523563},
{0.79609146125147,0.39229311167544884,-0.46080852840902703},
{0.8886813536747356,0.3916498850848552,-0.23844458296186832},
{0.4705171342444786,0.34334258423214165,0.8128526903659471},
{0.2434501285657538,0.34275881269890573,0.9073303870247895},
{0.0,0.3423656680727017,0.9395667881130817},
{-0.2434501285657538,0.34275881269890573,0.9073303870247895},
{-0.4705171342444786,0.34334258423214165,0.8128526903659471},
{-0.6640602103793032,0.3435812480069179,0.6640602103793032},
{-0.812852690365947,0.3433425842321416,0.47051713424447855},
{-0.9073303870247895,0.34275881269890573,0.24345012856575382},
{-0.9395667881130817,0.3423656680727017,0.0},
{-0.9073303870247895,0.34275881269890573,-0.24345012856575382},
{-0.812852690365947,0.3433425842321416,-0.47051713424447855},
{-0.6640670550299957,0.343554788712917,-0.6640670550299957},
{-0.4705171342444786,0.34334258423214165,-0.8128526903659471},
{-0.2434501285657538,0.34275881269890573,-0.9073303870247895},
{0.0,0.3423656680727017,-0.9395667881130817},
{0.2434501285657538,0.34275881269890573,-0.9073303870247895},
{0.4705171342444786,0.34334258423214165,-0.8128526903659471},
{0.4828758997646224,0.2664025650984467,0.8341825571992465},
{0.24983340305385954,0.2659169440177952,0.9310593158347993},
{0.0,0.26557482392735615,0.9640902514266773},
{-0.24983340305385954,0.2659169440177952,0.9310593158347993},
{-0.4828758997646224,0.2664025650984467,0.8341825571992465},
{-0.681518065135507,0.26658254591760094,0.681518065135507},
{-0.8341892239192535,0.26637469318726564,0.4828797588700354},
{-0.9310593158347993,0.2659169440177952,0.24983340305385954},
{-0.9640979323092562,0.265546939197229,0.0},
{-0.9310600118189764,0.26588614172978037,-0.2498635908404799},
{-0.8341892239192535,0.26637469318726564,-0.4828797588700354},
{-0.6815235153913213,0.266554677200215,-0.6815235153913213},
{-0.4828797588700354,0.26637469318726564,-0.8341892239192535},
{-0.24985637900676005,0.2658784674358341,-0.9310641387270817},
{0.0,0.2655181242759619,-0.9641058685025079},
{0.24985637900676005,0.2658784674358341,-0.9310641387270817},
{0.71707617485654,0.6969948059011006,0.0},
{0.9156016339178393,0.31877144302933197,0.24506818454458823},
{0.6921469948687553,0.6974881337310109,0.18558782502788965},
{0.2925265470958752,0.9562574021905215,0.0},
{0.28208594657150665,0.9563989902106002,0.07568679059784197},
{0.6200637562812807,0.6976741039132713,0.3588478547729696},
{0.8204633803586024,0.31899236692438554,0.47442988031374395},
{0.9479144064340393,0.31852516081905163,0.0},
{0.9156016339178393,0.31877144302933197,-0.24506818454458823},
{0.6921469948687553,0.6974881337310109,-0.18558782502788965},
{0.28208594657150665,0.9563989902106002,-0.07568679059784197},
{0.177958426544746,0.9840380065941143,0.0},
{0.17160956604256142,0.9840894493545527,0.04602295635590108},
{0.2523935693616694,0.9565321070086524,0.1460952237633525},
{0.5065610288532563,0.6977046997793985,0.5065610288532563},
{0.6701510724226949,0.31905341286597133,0.6701510724226949},
{0.3588478547729696,0.6976741039132713,0.6200637562812807},
{0.1460952237633525,0.9565321070086524,0.2523935693616694},
{0.07568679059784197,0.9563989902106002,0.28208594657150665},
{0.18558782502788965,0.6974881337310109,0.6921469948687553},
{0.47442988031374395,0.31899236692438554,0.8204633803586024},
{0.24506818454458823,0.31877144302933197,0.9156016339178393},
{0.0,0.6969948059011006,0.71707617485654},
{0.0,0.31852516081905163,0.9479144064340393},
{-0.24506818454458823,0.31877144302933197,0.9156016339178393},
{-0.18558782502788965,0.6974881337310109,0.6921469948687553},
{-0.47442988031374395,0.31899236692438554,0.8204633803586024},
{-0.3588478547729696,0.6976741039132713,0.6200637562812807},
{-0.6701510724226949,0.31905341286597133,0.6701510724226949},
{-0.5065610288532563,0.6977046997793985,0.5065610288532563},
{-0.6200637562812807,0.6976741039132713,0.3588478547729696},
{-0.8204633803586024,0.31899236692438554,0.47442988031374395},
{-0.6921469948687553,0.6974881337310109,0.18558782502788965},
{-0.9156016339178393,0.31877144302933197,0.24506818454458823},
{-0.71707617485654,0.6969948059011006,0.0},
{-0.9479144064340393,0.31852516081905163,0.0},
{-0.9156016339178393,0.31877144302933197,-0.24506818454458823},
{-0.6921469948687553,0.6974881337310109,-0.18558782502788965},
{-0.8204633803586024,0.31899236692438554,-0.47442988031374395},
{-0.6200637562812807,0.6976741039132713,-0.3588478547729696},
{-0.6701510724226949,0.31905341286597133,-0.6701510724226949},
{-0.5065610288532563,0.6977046997793985,-0.5065610288532563},
{-0.3588478547729696,0.6976741039132713,-0.6200637562812807},
{-0.47442988031374395,0.31899236692438554,-0.8204633803586024},
{-0.18558782502788965,0.6974881337310109,-0.6921469948687553},
{-0.24506818454458823,0.31877144302933197,-0.9156016339178393},
{0.0,0.6969948059011006,-0.71707617485654},
{0.0,0.31852516081905163,-0.9479144064340393},
{0.24506818454458823,0.31877144302933197,-0.9156016339178393},
{0.18558782502788965,0.6974881337310109,-0.6921469948687553},
{0.47442988031374395,0.31899236692438554,-0.8204633803586024},
{0.3588478547729696,0.6976741039132713,-0.6200637562812807},
{0.6701510724226949,0.31905341286597133,-0.6701510724226949},
{0.5065610288532563,0.6977046997793985,-0.5065610288532563},
{0.6200637562812807,0.6976741039132713,-0.3588478547729696},
{0.8204633803586024,0.31899236692438554,-0.47442988031374395},
{0.15888277448650676,0.9872974546566349,0.0},
{0.15326810425322782,0.987330438991732,0.041079100026843174},
{0.21772526760760225,0.9760100961799515,0.0},
{0.21006407211014133,0.9760665676528912,0.05627735884713492},
{0.1370613192458554,0.9873817077111612,0.07931934218068686},
{0.15351038473442155,0.9841452883803208,0.08884038010671286},
{0.206093370937951,0.9565830047156724,0.206093370937951},
{0.08884038010671286,0.9841452883803208,0.15351038473442155},
{0.04602295635590108,0.9840894493545527,0.17160956604256142},
{0.0,0.9840380065941143,0.177958426544746},
{0.0,0.9562574021905215,0.2925265470958752},
{-0.07568679059784197,0.9563989902106002,0.28208594657150665},
{-0.1460952237633525,0.9565321070086524,0.2523935693616694},
{-0.206093370937951,0.9565830047156724,0.206093370937951},
{-0.2523935693616694,0.9565321070086524,0.1460952237633525},
{-0.28208594657150665,0.9563989902106002,0.07568679059784197},
{-0.2925265470958752,0.9562574021905215,0.0},
{-0.28208594657150665,0.9563989902106002,-0.07568679059784197},
{-0.2523935693616694,0.9565321070086524,-0.1460952237633525},
{-0.206093370937951,0.9565830047156724,-0.206093370937951},
{-0.1460952237633525,0.9565321070086524,-0.2523935693616694},
{-0.07568679059784197,0.9563989902106002,-0.28208594657150665},
{0.0,0.9562574021905215,-0.2925265470958752},
{0.07568679059784197,0.9563989902106002,-0.28208594657150665},
{0.1460952237633525,0.9565321070086524,-0.2523935693616694},
{0.206093370937951,0.9565830047156724,-0.206093370937951},
{0.2523935693616694,0.9565321070086524,-0.1460952237633525},
{0.17160956604256142,0.9840894493545527,-0.04602295635590108},
{0.15326810425322782,0.987330438991732,-0.041079100026843174},
{0.21006407211014133,0.9760665676528912,-0.05627735884713492},
{0.5047189343110356,0.8632837293427535,0.0},
{0.48720443485170234,0.8634731767992228,0.13055999237550428},
{0.18787708218279553,0.9761614057257233,0.10867893982763521},
{0.11191105569490084,0.9873964913987215,0.11191105569490084},
{0.12534043210430143,0.9841643928530507,0.12534043210430143},
{0.07931934218068686,0.9873817077111612,0.1370613192458554},
{0.041079100026843174,0.987330438991732,0.15326810425322782},
{0.0,0.9872974546566349,0.15888277448650676},
{-0.04602295635590108,0.9840894493545527,0.17160956604256142},
{0.6628283926516199,0.7272560552480563,0.17820536467768358},
{0.6869282470030083,0.7267252462033874,0.0},
{0.48720443485170234,0.8634731767992228,-0.13055999237550428},
{0.6628283926516199,0.7272560552480563,-0.17820536467768358},
{0.4359391681185406,0.8639130956364651,-0.25221261841536535},
{0.5933230583072805,0.7278820197837337,-0.34373756523901755},
{0.35591442474793117,0.8640890258027227,-0.35591442474793117},
{0.48467756774167264,0.7281313828259516,-0.48467756774167264},
{0.34373756523901755,0.7278820197837336,-0.5933230583072804},
{0.25221261841536535,0.8639130956364651,-0.4359391681185406},
{0.17820536467768358,0.7272560552480563,-0.6628283926516199},
{0.13055999237550428,0.8634731767992228,-0.48720443485170234},
{0.0,0.7267252462033874,-0.6869282470030083},
{0.0,0.8632837293427535,-0.5047189343110356},
{-0.13055999237550428,0.8634731767992228,-0.48720443485170234},
{-0.17820536467768358,0.7272560552480563,-0.6628283926516199},
{-0.25221261841536535,0.8639130956364651,-0.4359391681185406},
{-0.34373756523901755,0.7278820197837336,-0.5933230583072804},
{-0.35591442474793117,0.8640890258027227,-0.35591442474793117},
{-0.48467756774167264,0.7281313828259516,-0.48467756774167264},
{-0.5933230583072805,0.7278820197837337,-0.34373756523901755},
{-0.4359391681185406,0.8639130956364651,-0.25221261841536535},
{-0.6628283926516199,0.7272560552480563,-0.17820536467768358},
{-0.48720443485170234,0.8634731767992228,-0.13055999237550428},
{-0.6869282470030083,0.7267252462033874,0.0},
{-0.5047189343110356,0.8632837293427535,0.0},
{-0.48720443485170234,0.8634731767992228,0.13055999237550428},
{-0.6628283926516199,0.7272560552480563,0.17820536467768358},
{-0.4359391681185406,0.8639130956364651,0.25221261841536535},
{-0.5933230583072805,0.7278820197837337,0.34373756523901755},
{-0.35591442474793117,0.8640890258027227,0.35591442474793117},
{-0.48467756774167264,0.7281313828259516,0.48467756774167264},
{-0.34373756523901755,0.7278820197837336,0.5933230583072804},
{-0.25221261841536535,0.8639130956364651,0.4359391681185406},
{-0.17820536467768358,0.7272560552480563,0.6628283926516199},
{-0.13055999237550428,0.8634731767992228,0.48720443485170234},
{0.0,0.7267252462033874,0.6869282470030083},
{0.0,0.8632837293427535,0.5047189343110356},
{0.13055999237550428,0.8634731767992228,0.48720443485170234},
{0.17820536467768358,0.7272560552480563,0.6628283926516199},
{0.25221261841536535,0.8639130956364651,0.4359391681185406},
{0.34373756523901755,0.7278820197837336,0.5933230583072804},
{0.35591442474793117,0.8640890258027227,0.35591442474793117},
{0.48467756774167264,0.7281313828259516,0.48467756774167264},
{0.5933230583072805,0.7278820197837337,0.34373756523901755},
{0.4359391681185406,0.8639130956364651,0.25221261841536535},
{0.15335640210960147,0.9761985596506464,0.15335640210960147},
{0.10867893982763521,0.9761614057257233,0.18787708218279553},
{0.05627735884713492,0.9760665676528912,0.21006407211014133},
{0.0,0.9760100961799515,0.21772526760760225},
{-0.041079100026843174,0.987330438991732,0.15326810425322782},
{-0.08884038010671286,0.9841452883803208,0.15351038473442155},
{-0.05627735884713492,0.9760665676528912,0.21006407211014133},
{-0.07931934218068686,0.9873817077111612,0.1370613192458554},
{-0.12534043210430143,0.9841643928530507,0.12534043210430143},
{-0.10867893982763521,0.9761614057257233,0.18787708218279553},
{-0.11191105569490084,0.9873964913987215,0.11191105569490084},
{-0.1370613192458554,0.9873817077111612,0.07931934218068686},
{-0.15351038473442155,0.9841452883803208,0.08884038010671286},
{-0.17160956604256142,0.9840894493545527,0.04602295635590108},
{-0.177958426544746,0.9840380065941143,0.0},
{-0.17160956604256142,0.9840894493545527,-0.04602295635590108},
{-0.15351038473442155,0.9841452883803208,-0.08884038010671286},
{-0.12534043210430143,0.9841643928530507,-0.12534043210430143},
{-0.08884038010671286,0.9841452883803208,-0.15351038473442155},
{-0.04602295635590108,0.9840894493545527,-0.17160956604256142},
{0.0,0.9840380065941143,-0.177958426544746},
{0.04602295635590108,0.9840894493545527,-0.17160956604256142},
{0.08884038010671286,0.9841452883803208,-0.15351038473442155},
{0.12534043210430143,0.9841643928530507,-0.12534043210430143},
{0.15351038473442155,0.9841452883803208,-0.08884038010671286},
{-0.15335640210960147,0.9761985596506464,0.15335640210960147},
{-0.18787708218279553,0.9761614057257233,0.10867893982763521},
{-0.21006407211014133,0.9760665676528912,0.05627735884713492},
{-0.15326810425322782,0.987330438991732,0.041079100026843174},
{-0.15888277448650676,0.9872974546566349,0.0},
{-0.15326810425322782,0.987330438991732,-0.041079100026843174},
{-0.1370613192458554,0.9873817077111612,-0.07931934218068686},
{-0.11191105569490084,0.9873964913987215,-0.11191105569490084},
{-0.07931934218068686,0.9873817077111612,-0.1370613192458554},
{-0.041079100026843174,0.987330438991732,-0.15326810425322782},
{0.0,0.9872974546566349,-0.15888277448650676},
{0.041079100026843174,0.987330438991732,-0.15326810425322782},
{0.07931934218068686,0.9873817077111612,-0.1370613192458554},
{0.11191105569490084,0.9873964913987215,-0.11191105569490084},
{0.1370613192458554,0.9873817077111612,-0.07931934218068686},
{-0.21772526760760225,0.9760100961799515,0.0},
{-0.21006407211014133,0.9760665676528912,-0.05627735884713492},
{-0.18787708218279553,0.9761614057257233,-0.10867893982763521},
{-0.15335640210960147,0.9761985596506464,-0.15335640210960147},
{-0.10867893982763521,0.9761614057257233,-0.18787708218279553},
{-0.05627735884713492,0.9760665676528912,-0.21006407211014133},
{0.0,0.9760100961799515,-0.21772526760760225},
{0.05627735884713492,0.9760665676528912,-0.21006407211014133},
{0.10867893982763521,0.9761614057257233,-0.18787708218279553},
{0.15335640210960147,0.9761985596506464,-0.15335640210960147},
{0.18787708218279553,0.9761614057257233,-0.10867893982763521},
{0.0032960842744091732,-0.9999945678994742,0.0},
{0.015168169254589322,-0.9493495933532815,0.313855502168471},
{0.015290077987363983,-0.9998830999247564,0.0},
{0.015168169254589322,-0.9493495933532815,-0.313855502168471},
{0.058046838926811964,-0.9476436959000589,-0.3140095382492091},
{0.05887033248585919,-0.9982656379706778,0.0},
{0.058046838926811964,-0.9476436959000589,0.3140095382492091},
{0.04645025196343262,-0.6744161773910103,0.7368888612035271},
{0.011902303869881234,-0.6794203458333826,0.7336527304046757},
{0.0032650879504506633,-0.944420439499496,0.32872385471129856},
{0.15976451070405118,-0.9871551555452138,0.0},
{0.1583652595723564,-0.934715141162823,0.31816355768934934},
{0.39159733732666857,-0.9201366884320303,0.0},
{0.3739490382380872,-0.8609719023043272,0.34480356761970665},
{0.27009757376746624,-0.5621378440668375,0.7816958135443838},
{0.12598321512511643,-0.6489625616969662,0.7503171482929402},
{0.7845827711123383,-0.6200240924945452,0.0},
{0.7268510820560403,-0.553896827629607,0.40606133632226166},
{0.9950077900909413,-0.09979728282043183,0.0},
{0.9081707969249123,-0.08276889790911666,0.4103353666839844},
{0.4600796574524832,-0.3162717010889603,0.8296378245286922},
{0.3739490382380872,-0.8609719023043272,-0.34480356761970665},
{0.7268510820560403,-0.553896827629607,-0.40606133632226166},
{0.9081707969249123,-0.08276889790911666,-0.4103353666839844},
{0.9729468634922552,0.23102900428427356,0.0},
{0.890523168144548,0.2147645873863616,0.4010544339644718},
{0.5596877965644117,0.13971619590729725,0.8168408382163977},
{0.563050761575671,-0.04120108017412323,0.8253946394795295},
{-0.04651032014082112,0.04153628590344326,0.9980538698255449},
{-0.007813053435729545,0.05884040242651049,0.99823682723004},
{0.005921041498111141,0.03595125196733552,0.9993360039293885},
{0.0023800511217979777,-0.636232665823188,0.7714935711308145},
{0.0001530033646625355,0.004242093286918141,0.999990990576673},
{-0.0005190025434825163,0.1132545550280711,0.99356586918118},
{-0.014161531784191196,0.6824196257567521,0.7308234433839269},
{-0.0032040645713693507,0.7277586664877082,0.6858258214169655},
{-0.02056939453179523,0.9494182103401426,0.3133400100260356},
{-0.004273034561567114,0.9547797225407341,0.29728340451608554},
{-0.021851114437459393,0.9997612358947715,0.0},
{-0.00451709394693223,0.9999897978790957,0.0},
{-0.004273034561567114,0.9547797225407341,-0.29728340451608554},
{-0.02056939453179523,0.9494182103401426,-0.3133400100260356},
{-0.0032040645713693507,0.7277586664877082,-0.6858258214169655},
{-0.014161531784191196,0.6824196257567521,-0.7308234433839269},
{-0.0005190025434825163,0.1132545550280711,-0.99356586918118},
{0.0001530033646625355,0.004242093286918141,-0.999990990576673},
{0.0023800511217979777,-0.636232665823188,-0.7714935711308145},
{0.011902303869881234,-0.6794203458333826,-0.7336527304046757},
{0.0032650879504506633,-0.944420439499496,-0.32872385471129856},
{0.0035100622005240995,0.014008248235026092,0.9998957187850813},
{-0.0553626302902293,0.6800940270587128,0.7310315270399835},
{-0.08270757013222739,0.9449743650153875,0.31651683573956707},
{-0.08765139420524425,0.9961512099545313,0.0},
{-0.08270757013222739,0.9449743650153875,-0.31651683573956707},
{-0.0553626302902293,0.6800940270587128,-0.7310315270399835},
{0.0035100622005240995,0.014008248235026092,-0.9998957187850813},
{0.04645025196343262,-0.6744161773910103,-0.7368888612035271},
{0.12598321512511643,-0.6489625616969662,-0.7503171482929402},
{0.1583652595723564,-0.934715141162823,-0.31816355768934934},
{0.2700928668172044,-0.5621590482180253,-0.7816821910476582},
{0.4600796574524832,-0.3162717010889603,-0.8296378245286922},
{0.5630500421403487,-0.041232028302788305,-0.8253935848356163},
{0.5596877965644117,0.13971619590729725,-0.8168408382163977},
{0.890523168144548,0.2147645873863616,-0.4010544339644718},
{0.8366457044181072,0.3840803731672207,-0.390520463262116},
{0.9125369709845479,0.4089942256149179,0.0},
{0.8366457044181072,0.3840803731672207,0.390520463262116},
{0.5286007773625534,0.25551055981374615,0.8095032872047958},
{-0.02084427539419711,-0.01220716128079851,0.9997082081271291},
{-0.024537452837546037,-0.005737105878021014,0.9996824490929055},
{-0.039155833369459395,0.0031130662566499065,0.9992282669798853},
{-0.5376591405393527,0.3158143059773099,0.7817825610325129},
{-0.32253331433230203,0.5652263328183063,0.7592703430495557},
{-0.150034423936613,0.6556837038057955,0.7399787511797365},
{-0.22959676374770197,0.914570959192361,0.33293435791240694},
{-0.2462244804810931,0.9692128276141498,0.0},
{-0.22959676374770197,0.914570959192361,-0.33293435791240694},
{-0.150034423936613,0.6556837038057955,-0.7399787511797365},
{0.005921041498111141,0.03595125196733552,-0.9993360039293885},
{-0.007813067683531223,0.058809509458695466,-0.9982386476041689},
{-0.6115501202106837,0.029939985035873393,0.7906390122972368},
{-0.5854493230200694,-0.15467125564811943,0.7958177510281964},
{-0.8891428780819212,-0.23887253437833597,0.39033940958589947},
{-0.9212455682115551,0.03970558478845697,0.3869496990400377},
{-0.8106488052076491,0.4432286416222066,0.3826184599063988},
{-0.5023415461583205,0.7859532419845499,0.36045869724178337},
{-0.5492228041647824,0.8356759607559459,0.0},
{-0.5023415461583205,0.7859532419845499,-0.36045869724178337},
{-0.32253331433230203,0.5652263328183063,-0.7592703430495557},
{-0.04651032014082112,0.04153628590344326,-0.9980538698255449},
{-0.881067187509625,0.4729911321514171,0.0},
{-0.9991407839794191,0.041445069537783985,0.0},
{-0.9212455682115551,0.03970558478845697,-0.3869496990400377},
{-0.8106488052076491,0.4432286416222066,-0.3826184599063988},
{-0.5376591405393527,0.3158143059773099,-0.7817825610325129},
{-0.039155833369459395,0.0031130662566499065,-0.9992282669798853},
{-0.6115501202106837,0.029939985035873393,-0.7906390122972368},
{-0.8891428780819212,-0.23887253437833597,-0.39033940958589947},
{-0.5854493230200694,-0.15467125564811943,-0.7958177510281964},
{0.828819886659646,0.5595155006588214,0.0},
{0.7652131950191633,0.5302133788462884,0.3651335907047808},
{0.6710567912975934,0.6632436074378769,0.33134679724749055},
{0.445160700277212,0.46789760433164546,0.7634813571983335},
{0.4948987200338879,0.3597907934521595,0.7909651331480326},
{0.7189688033032443,0.6950423439451017,0.0},
{0.549474993102295,0.7762662450896601,0.3090112436297952},
{0.3760580466362087,0.5599974715729351,0.7382297592159768},
{-0.00979616537437714,-0.013276224123135045,0.999863879244065},
{-0.01446606816349261,-0.01446606816349261,0.9997907109709403},
{0.5808657096240818,0.8139994025691369,0.0},
{0.4611764123587488,0.8215483301904051,0.33522329549909025},
{0.28733461746248345,0.5279448092907979,0.7991952802354324},
{-0.014771125191481249,-0.013886117690671494,0.9997944736774945},
{-0.4283431986969654,-0.5119673611201583,0.7445881581637687},
{-0.48723529116306696,-0.4089241192866975,0.7716105466560447},
{0.49709787579485676,0.8676944749623806,0.0},
{0.4611764123587488,0.8215483301904051,-0.33522329549909025},
{0.549474993102295,0.7762662450896601,-0.3090112436297952},
{0.3760580466362087,0.5599974715729351,-0.7382297592159768},
{0.28733461746248345,0.5279448092907979,-0.7991952802354324},
{-0.014771119031378345,-0.013916112141402821,-0.9997940567263984},
{-0.1017806468890249,-0.19666418217748777,-0.9751737790605896},
{-0.3608302449819091,-0.5847516027368123,-0.7265446286382032},
{-0.3573244468816769,-0.6915750254444358,-0.6277286227680172},
{-0.48620540255237965,-0.8149918182120213,-0.3152659873445628},
{-0.4401441904160671,-0.8555980335742909,-0.27244283177722195},
{-0.45696551394867774,-0.889484411927281,0.0},
{-0.5076212611629006,-0.8615803242968042,0.0},
{-0.48620540255237965,-0.8149918182120213,0.3152659873445628},
{-0.4401441904160671,-0.8555980335742909,0.27244283177722195},
{-0.35731771757424097,-0.6915620013678526,0.6277468016418923},
{-0.3608302449819091,-0.5847516027368123,0.7265446286382032},
{-0.1017806468890249,-0.19666418217748777,0.9751737790605896},
{-0.5385145715040164,-0.2917044348261289,0.7905128582006837},
{-0.8070347066593363,-0.4485187328599498,0.3840910419691978},
{-0.8721226207496019,-0.4892873740214907,0.0},
{-0.9654709235330609,-0.2605108362663988,0.0},
{-0.8070234849611982,-0.4485434971370931,-0.38408570124011276},
{-0.5385145715040164,-0.2917044348261289,-0.7905128582006837},
{-0.024537452837546037,-0.005737105878021014,-0.9996824490929055},
{-0.02084426749614907,-0.012238157053246608,-0.9997078293303945},
{0.5286007773625534,0.25551055981374615,-0.8095032872047958},
{0.4948987200338879,0.3597907934521595,-0.7909651331480326},
{0.7652131950191633,0.5302133788462884,-0.3651335907047808},
{0.6710567912975934,0.6632436074378769,-0.33134679724749055},
{-0.7010021630370596,-0.6134113937482213,0.3637615007628327},
{-0.7482691241873468,-0.6633952952711534,0.0},
{-0.7010021630370596,-0.6134113937482213,-0.3637615007628327},
{-0.48723529116306696,-0.4089241192866975,-0.7716105466560447},
{-0.5904646924388025,-0.7337852004596868,0.33602191382332147},
{-0.621795090992043,-0.7831799696226894,0.0},
{-0.5904646924388025,-0.7337852004596868,-0.33602191382332147},
{-0.4283431986969654,-0.5119673611201583,-0.7445881581637687},
{-0.009766167733706107,-0.013276228018910737,-0.9998641726441583},
{-0.01446606816349261,-0.01446606816349261,-0.9997907109709403},
{0.445160700277212,0.46789760433164546,-0.7634813571983335},
{-0.1499396021004482,0.9886951581361968,0.0},
{-0.137031712407309,0.8724256353997809,0.4691437098502005},
{-0.2977717057818966,0.8403656362061299,0.45289911538841204},
{-0.11789397205424895,0.5031631486589013,0.8561120587778986},
{-0.06671528957666342,0.49145686612137773,0.8683428003264934},
{0.13593216435485678,-0.0024720575468458236,0.9907150627830836},
{0.06271692572997963,-0.0434586414690582,0.9970847174180558},
{0.36010031195875836,-0.4792483856741121,0.8004053661464061},
{0.20258777959616275,-0.542909488582792,0.8149892507052273},
{0.48843005705722964,-0.7687189760817423,0.41292519319473475},
{0.294117440024559,-0.8550673515634747,0.42703015790881227},
{0.32078356447631134,-0.947152524550229,0.0},
{0.5251148164036563,-0.8510313916615264,0.0},
{0.48843005705722964,-0.7687189760817423,-0.41292519319473475},
{0.294117440024559,-0.8550673515634747,-0.42703015790881227},
{0.20258777959616275,-0.542909488582792,-0.8149892507052273},
{0.36010031195875836,-0.4792483856741121,-0.8004053661464061},
{0.06271692572997963,-0.0434586414690582,-0.9970847174180558},
{0.13593216435485678,-0.0024720575468458236,-0.9907150627830836},
{-0.06671528957666342,0.49145686612137773,-0.8683428003264934},
{-0.11789397205424895,0.5031631486589013,-0.8561120587778986},
{-0.137031712407309,0.8724256353997809,-0.4691437098502005},
{-0.2977717057818966,0.8403656362061299,-0.45289911538841204},
{-0.35050790857418707,0.9365597717321352,0.0},
{-0.6175358369005837,0.6639866299024934,0.42162927490180885},
{-0.2543466077123138,0.474359458450381,0.8427875813773595},
{0.24797084979784306,0.09519001334758528,0.9640795190280842},
{0.6120017089878456,-0.28224132227459464,0.7387785488200402},
{0.7845873803890265,-0.5015221098516144,0.3645520756548648},
{0.8275865081034817,-0.56133819717269,0.0},
{0.7845873803890265,-0.5015221098516144,-0.3645520756548648},
{0.6120017089878456,-0.28224132227459464,-0.7387785488200402},
{0.24797084979784306,0.09519001334758528,-0.9640795190280842},
{-0.2543502273064934,0.4743362079483397,-0.8427995750463597},
{-0.6175358369005837,0.6639866299024934,-0.42162927490180885},
{-0.7155247885692033,0.6985873438182207,0.0},
{-0.8013466587813713,0.4502217304152907,0.3938831373920365},
{-0.4111326380429328,0.3991991260821279,0.8195181582314843},
{0.20929941068726662,0.1706627810750751,0.9628436902434807},
{0.6792364288453591,-0.1067565821456339,0.726113562673213},
{0.8939289566298713,-0.2796144271535364,0.35029529346856675},
{0.9434440444838409,-0.33153180077931055,0.0},
{0.8939289566298713,-0.2796144271535364,-0.35029529346856675},
{0.6792364288453591,-0.1067565821456339,-0.726113562673213},
{0.2093005179217305,0.1706326832451024,-0.9628487838732891},
{-0.4111221929447805,0.399188984162785,-0.8195283383699179},
{-0.8013466587813713,0.4502217304152907,-0.3938831373920365},
{-0.9008746670795418,0.4340792948463734,0.0},
{-0.828047884482991,0.37981212068950987,0.4124069034104307},
{-0.45941276028365025,0.3464593936573743,0.8178666176309691},
{0.09619566425436382,0.1786280903947828,0.9792029409170374},
{0.5839266135360474,-0.07852609969893458,0.8079996049939606},
{0.8614258253328639,-0.28529058517873124,0.4201842803556212},
{0.9335641965283479,-0.35841022719836046,0.0},
{0.8614180865692047,-0.2852979581291394,-0.42019513945165277},
{0.5839266135360474,-0.07852609969893458,-0.8079996049939606},
{0.09619566425436382,0.1786280903947828,-0.9792029409170374},
{-0.45941276028365025,0.3464593936573743,-0.8178666176309691},
{-0.828047884482991,0.37981212068950987,-0.4124069034104307},
{-0.9293162606856243,0.3692848326499326,0.0},
{-0.729211419350747,0.5034863840456246,0.4634136024860846},
{-0.38588412133013217,0.3957423288062966,0.8333555388285607},
{0.009552263025408137,0.15433624971077145,0.9879722042123998},
{0.4027295884075093,-0.2052408672384225,0.8920118076776442},
{0.6793933374201405,-0.5404381778423151,0.4963378577134746},
{0.7563621293784585,-0.6541531389835901,0.0},
{0.6793933374201405,-0.5404381778423151,-0.4963378577134746},
{0.4027295884075093,-0.2052408672384225,-0.8920118076776442},
{0.009552263025408137,0.15433624971077145,-0.9879722042123998},
{-0.38588412133013217,0.3957423288062966,-0.8333555388285607},
{-0.7292254670354844,0.5034753692501781,-0.4634034643647764},
{-0.8578963482763112,0.513822786195951,0.0},
{-0.6630884491035202,0.7485410534269235,0.0},
{-0.5314691481921037,0.6865400269865102,0.49618881070145227},
{-0.27067373224308516,0.48784652911859944,0.8299045093867933},
{-0.0001220019132751147,0.15195438299983793,0.9883875002258333},
{0.27952259968544796,-0.3386983617495165,0.898415569774524},
{0.4583719796593195,-0.7545646592768146,0.46960334670193865},
{0.4919425105375047,-0.8706276803901641,9.200271374967563e-05},
{0.4578553496176068,-0.7556349830701636,-0.4683847256124954},
{0.2791621150650273,-0.34224617485493486,-0.8971822943580562},
{-0.00045800637611396555,0.14936007930923506,-0.9887827652922043},
{-0.27104398246280226,0.4871521443392906,-0.8301915127465078},
{-0.5315495059524864,0.6864639849223336,-0.4962079404102858},
{-0.48070912412420236,0.8768801160841442,0.0},
{-0.3946475601958996,0.8153889508634796,0.4235494800388474},
{-0.20682820644182726,0.6382159799433019,0.7415540816185072},
{0.02011258894309907,0.32262044707250065,0.9463147102823383},
{0.2817491355817348,-0.1749943264093478,0.9433951506783803},
{0.4672424918797149,-0.6832245682437539,0.5611493946625719},
{0.4953525923631,-0.8686905609036618,0.001587021120752443},
{0.4591343482990735,-0.703778993631101,-0.5421169415684958},
{0.277055647796153,-0.21580273589614263,-0.9363062251229529},
{0.01690744638657887,0.3000959230647472,-0.9537591809343711},
{-0.20997262162920885,0.6321769253697994,-0.745830968246924},
{-0.39549402339963624,0.8148243495580186,-0.42384638351945375},
{-0.3207566494941181,0.9471616352771879,9.200190725941968e-05},
{-0.2552971956169564,0.9220008212709289,0.29109762535247535},
{-0.12949302173083255,0.8620761166205467,0.48995543315229767},
{0.021943645525616534,0.7489160311835695,0.6623014832063241},
{0.3039066121331357,0.44414127891584604,0.8428400177167411},
{0.6995372899492843,0.004364139058259904,0.7145827693561404},
{0.933917484948689,-0.35731883758540933,0.011017241656927593},
{0.6936762857091835,-0.09653296214906182,-0.713788902872158},
{0.3062021161540165,0.3498755590156138,-0.8853402494331284},
{0.01934927756007301,0.7018750682051084,-0.7120372139782989},
{-0.13739594478809927,0.8491290191029921,-0.5100022188902477},
{-0.2579485833799153,0.9206444967465591,-0.2930464791506113},
{0.0026860728588597,0.9999961245722544,-0.0007320198558024201},
{-0.007172045951065494,0.9999454066177467,-0.007599048686858154},
{-0.03448687352320226,0.9990483050446585,0.026704676406761964},
{-0.025697512143299073,0.9954118382434818,0.09216783687587275},
{0.03527974979406057,0.9838769101557657,0.17533272631431865},
{0.3549095774174088,0.8927820921837449,0.27745148717102164},
{0.7042307500524811,0.7098458756342205,0.01333729828738374},
{0.4086834380125176,0.8484366695656188,-0.3363525906406398},
{0.05624777382744754,0.9711296255033334,-0.2318263108648626},
{-0.023713356897587703,0.9953759808940156,-0.09308240093553581},
{-0.02343843037387044,0.9997133566262655,-0.0048830896627531945},
{0.0050050593882023315,0.9999198646830404,0.011628137975228114},
{0.8532544384661975,0.5212372637159969,-0.01638835414537601},
{0.36684132082195897,0.7044158980251075,-0.6076394390977942},
{0.5675059162635465,-0.15409177860695367,-0.8088218337629234},
{0.10348833576638032,0.5538817970613282,-0.826138680394774},
{0.041597977702466246,0.8713544799721308,-0.4888874906188159},
{0.8037720108976313,-0.594413445238602,-0.024964186691211705},
{0.5809395331781406,-0.584509653217812,-0.5664430457565501},
{0.18964740567546437,0.17420496550693354,-0.9662745425153733},
{-0.06640949495611967,0.6515236665667776,-0.7557160120594609},
{-0.07071348612986264,0.7820334945690114,-0.6192117701170915},
{-0.05655200144907019,0.9316244976386868,-0.3589953572562865},
{0.6737652063329886,-0.7386479965931225,-0.020966255365031366},
{0.5848399903443526,-0.6614128220937233,0.4695692328762974},
{0.6219607594562071,-0.40087631383303235,0.6726536959716333},
{0.34151298006590514,-0.38552239502318314,0.8571705590966674},
{0.26075585706188603,0.006531146701711133,0.9653826842919248},
{0.08072355434868062,0.001404044428408315,0.9967355398662971},
{-0.01525944883169352,0.3866193717755665,0.9221131224471427},
{-0.1593728525191157,0.4447905427996506,0.8813408347035285},
{-0.20261649203179177,0.7008125370975243,0.6839651635892444},
{-0.3359872583812848,0.8088852894417526,0.48251129596120323},
{-0.3068423085447536,0.8885429553501425,0.34108534736127416},
{-0.31495950354438246,0.9163127393901754,-0.24732867758985924},
{-0.3223703864358472,0.9457179345760335,-0.04116943247657916},
{-0.2530080235612562,0.8943494319447635,-0.3689526170034653},
{-0.1914485663305324,0.8079704915878598,-0.5572532020305097},
{-0.1495752668079737,0.8477061818020656,-0.5089415181471115},
{-0.1456356505060442,0.7775288118259437,-0.6117509330456452},
{-0.10992868903463265,0.953556976909095,-0.28043675778170446},
{-0.17438658814376645,0.969073939472709,-0.17459959252650226},
{-0.2056401493636222,0.978605263738759,-0.006623198056913107},
{-0.1982508390688922,0.9634527972120498,0.18015357990547193},
{-0.14673503883634062,0.912180674458146,0.38261631633109877},
{-0.047395695048034606,0.8293831627320077,0.5566661633937936},
{0.12043020957202884,0.7245653267842307,0.6786027201864859},
{0.4666296737117152,0.5998131514154693,0.6499853313735177},
{0.0,1.0,0.0},
{0.35145384736091906,0.9315235468906159,0.0935097575846197},
{0.3638439251053017,0.9314599283726421,0.0},
{0.35145384736091906,0.9315235468906159,-0.0935097575846197},
{0.9682671140563034,0.24991757808741147,0.0},
{0.9354333970735225,0.24976577607486045,0.25016278048745044},
{0.3144375988148909,0.9318075915852269,0.18128322789399115},
{0.25639505070491775,0.9319458975434385,0.25639505070491775},
{0.18128322789399115,0.9318075915852269,0.3144375988148909},
{0.0935097575846197,0.9315235468906159,0.35145384736091906},
{0.0,0.9314599283726421,0.3638439251053017},
{-0.0935097575846197,0.9315235468906159,0.35145384736091906},
{-0.18128322789399115,0.9318075915852269,0.3144375988148909},
{-0.25639505070491775,0.9319458975434385,0.25639505070491775},
{-0.3144375988148909,0.9318075915852269,0.18128322789399115},
{-0.35145384736091906,0.9315235468906159,0.0935097575846197},
{-0.3638439251053017,0.9314599283726421,0.0},
{-0.35145384736091906,0.9315235468906159,-0.0935097575846197},
{-0.3144375988148909,0.9318075915852269,-0.18128322789399115},
{-0.25642197523115123,0.9319310818065409,-0.25642197523115123},
{-0.18128322789399115,0.9318075915852269,-0.3144375988148909},
{-0.0935097575846197,0.9315235468906159,-0.35145384736091906},
{0.0,0.9314599283726421,-0.3638439251053017},
{0.0935097575846197,0.9315235468906159,-0.35145384736091906},
{0.18128322789399115,0.9318075915852269,-0.3144375988148909},
{0.25642197523115123,0.9319310818065409,-0.25642197523115123},
{0.3144375988148909,0.9318075915852269,-0.18128322789399115},
{0.9354333970735225,0.24976577607486045,-0.25016278048745044},
{0.8139712903535588,-0.5387211342834672,-0.21732528144810254},
{0.84287401626687,-0.5381109483202848,0.0},
{0.8139712903535588,-0.5387211342834672,0.21732528144810254},
{0.7290561094590922,-0.5397422909433426,0.42089838278093267},
{0.8384302270434647,0.24983281505232985,0.4843741517699647},
{0.6846726311390587,0.24989353000475398,0.6846726311390587},
{0.4843741517699646,0.24983281505232982,0.8384302270434646},
{0.25016278048745044,0.24976577607486045,0.9354333970735225},
{0.0,0.24991757808741147,0.9682671140563034},
{-0.25016278048745044,0.24976577607486045,0.9354333970735225},
{-0.4843741517699646,0.24983281505232982,0.8384302270434646},
{-0.6846726311390587,0.24989353000475398,0.6846726311390587},
{-0.8384302270434647,0.24983281505232985,0.4843741517699647},
{-0.9354333970735225,0.24976577607486045,0.25016278048745044},
{-0.9682671140563034,0.24991757808741147,0.0},
{-0.9354333970735225,0.24976577607486045,-0.25016278048745044},
{-0.8384302270434647,0.24983281505232985,-0.4843741517699647},
{-0.6846726311390587,0.24989353000475398,-0.6846726311390587},
{-0.4843741517699646,0.24983281505232982,-0.8384302270434646},
{-0.25016278048745044,0.24976577607486045,-0.9354333970735225},
{0.0,0.24991757808741147,-0.9682671140563034},
{0.25016278048745044,0.24976577607486045,-0.9354333970735225},
{0.4843741517699646,0.24983281505232982,-0.8384302270434646},
{0.6846726311390587,0.24989353000475398,-0.6846726311390587},
{0.8384302270434647,0.24983281505232985,-0.4843741517699647},
{0.7290561094590922,-0.5397422909433426,-0.42089838278093267},
{0.6800392742611775,-0.619121920634674,-0.3927271735594107},
{0.7595067240501042,-0.6180484916926307,-0.20289307045619592},
{0.7867884171737916,-0.6172228014268103,0.0},
{0.7595067240501042,-0.6180484916926307,0.20289307045619592},
{0.6800392742611775,-0.619121920634674,0.3927271735594107},
{0.5550535246333675,-0.6195410959606725,0.5550535246333675},
{0.5950714864528714,-0.540166503979597,0.5950714864528714},
{0.42089838278093267,-0.5397422909433426,0.7290561094590922},
{0.21732528144810254,-0.5387211342834672,0.8139712903535588},
{0.0,-0.5381109483202848,0.84287401626687},
{-0.21732528144810254,-0.5387211342834672,0.8139712903535588},
{-0.42089838278093267,-0.5397422909433426,0.7290561094590922},
{-0.5950714864528714,-0.540166503979597,0.5950714864528714},
{-0.7290561094590922,-0.5397422909433426,0.42089838278093267},
{-0.8139712903535588,-0.5387211342834672,0.21732528144810254},
{-0.84287401626687,-0.5381109483202848,0.0},
{-0.8139712903535588,-0.5387211342834672,-0.21732528144810254},
{-0.7290561094590922,-0.5397422909433426,-0.42089838278093267},
{-0.5950714864528714,-0.540166503979597,-0.5950714864528714},
{-0.42089838278093267,-0.5397422909433426,-0.7290561094590922},
{-0.21732528144810254,-0.5387211342834672,-0.8139712903535588},
{0.0,-0.5381109483202848,-0.84287401626687},
{0.21732528144810254,-0.5387211342834672,-0.8139712903535588},
{0.42089838278093267,-0.5397422909433426,-0.7290561094590922},
{0.5950714864528714,-0.540166503979597,-0.5950714864528714},
{0.5550535246333675,-0.6195410959606725,-0.5550535246333675},
{0.5858775149510751,-0.559874915126273,-0.5859075156431274},
{0.7177867594217183,-0.5593599567758559,-0.41460656863414613},
{0.8015924046270995,-0.5582002981457278,-0.2141542528042927},
{0.8302191143690777,-0.5574371912029411,0.0},
{0.8015924046270995,-0.5582002981457278,0.2141542528042927},
{0.7177867594217183,-0.5593599567758559,0.41460656863414613},
{0.585897217312241,-0.5598650743630517,0.585897217312241},
{0.3927271735594107,-0.619121920634674,0.6800392742611775},
{0.41460656863414613,-0.5593599567758559,0.7177867594217183},
{0.20288844742504195,-0.6180344091149195,0.759519418482127},
{0.2141542528042927,-0.5582002981457278,0.8015924046270995},
{0.0,-0.6172228014268103,0.7867884171737916},
{0.0,-0.5574371912029411,0.8302191143690777},
{-0.2141542528042927,-0.5582002981457278,0.8015924046270995},
{-0.20288844742504195,-0.6180344091149195,0.759519418482127},
{-0.3927271735594107,-0.619121920634674,0.6800392742611775},
{-0.5550535246333675,-0.6195410959606725,0.5550535246333675},
{-0.6800392742611775,-0.619121920634674,0.3927271735594107},
{-0.7595067240501042,-0.6180484916926307,0.20289307045619592},
{-0.7867884171737916,-0.6172228014268103,0.0},
{-0.7595067240501042,-0.6180484916926307,-0.20289307045619592},
{-0.6800392742611775,-0.619121920634674,-0.3927271735594107},
{-0.5550535246333675,-0.6195410959606725,-0.5550535246333675},
{-0.3927271735594107,-0.619121920634674,-0.6800392742611775},
{-0.20289307045619592,-0.6180484916926307,-0.7595067240501042},
{0.0,-0.6172228014268103,-0.7867884171737916},
{0.20289307045619592,-0.6180484916926307,-0.7595067240501042},
{0.3927271735594107,-0.619121920634674,-0.6800392742611775},
{-0.41460656863414613,-0.5593599567758559,0.7177867594217183},
{-0.585897217312241,-0.5598650743630517,0.585897217312241},
{-0.7177867594217183,-0.5593599567758559,0.41460656863414613},
{-0.8015924046270995,-0.5582002981457278,0.2141542528042927},
{-0.8302191143690777,-0.5574371912029411,0.0},
{-0.8015924046270995,-0.5582002981457278,-0.2141542528042927},
{-0.7177867594217183,-0.5593599567758559,-0.41460656863414613},
{-0.5858775149510751,-0.559874915126273,-0.5859075156431274},
{-0.41460656863414613,-0.5593599567758559,-0.7177867594217183},
{-0.21415066646426228,-0.5582209506027687,-0.8015789807380514},
{0.0,-0.5574371912029411,-0.8302191143690777},
{0.21415066646426228,-0.5582209506027687,-0.8015789807380514},
{0.41460656863414613,-0.5593599567758559,-0.7177867594217183}
};


// face array: 9kb.
const uint16_t teapot_face[4788] PROGMEM = {
627, // chain 0
0,0, 1,1, 2,2, 
3,3, 32772,4, 32769,1, 5,5, 32774,6, 32768,0, 7,7, 32776,8, 32777,9, 32778,10, 32779,11, 32780,12, 32781,13, 32782,14, 32783,15, 32784,16, 
32785,17, 32786,18, 32787,19, 32788,20, 32789,21, 32790,22, 32791,23, 32792,24, 32793,25, 32794,26, 32771,3, 27,27, 32772,4, 28,28, 32773,5, 29,29, 
32798,30, 32774,6, 7,7, 31,31, 32800,32, 32776,8, 33,33, 32777,9, 34,34, 32778,10, 11,11, 35,35, 32780,12, 36,36, 32781,13, 37,37, 
32806,38, 32782,14, 39,39, 32783,15, 40,40, 32784,16, 17,17, 41,41, 32786,18, 42,42, 32787,19, 43,43, 32812,44, 32788,20, 45,45, 32789,21, 
46,46, 32790,22, 23,23, 47,47, 32792,24, 48,48, 32793,25, 49,49, 32818,50, 32794,26, 27,27, 51,51, 32796,28, 52,52, 32797,29, 53,53, 
32822,54, 32798,30, 31,31, 55,55, 32824,56, 32800,32, 57,57, 32801,33, 58,58, 32802,34, 35,35, 59,59, 32804,36, 60,60, 32805,37, 61,61, 
32830,62, 32806,38, 63,63, 32807,39, 64,64, 32808,40, 41,41, 65,65, 32810,42, 66,66, 32811,43, 67,67, 32836,68, 32812,44, 69,69, 32813,45, 
70,70, 32814,46, 47,47, 71,71, 32816,48, 72,72, 32817,49, 73,73, 32842,74, 32818,50, 51,51, 75,75, 32820,52, 76,76, 32821,53, 77,77, 
32846,78, 32822,54, 55,55, 79,79, 32848,80, 32824,56, 81,81, 32825,57, 82,82, 32826,58, 59,59, 83,83, 32828,60, 84,84, 32829,61, 85,85, 
32854,86, 32830,62, 87,87, 32831,63, 88,88, 32832,64, 65,65, 89,89, 32834,66, 90,90, 32835,67, 91,91, 32860,92, 32836,68, 93,93, 32837,69, 
94,94, 32838,70, 71,71, 95,95, 32840,72, 96,96, 32841,73, 97,97, 32866,98, 32842,74, 75,75, 99,99, 32844,76, 100,100, 32845,77, 101,101, 
32870,102, 32846,78, 79,79, 103,103, 32872,104, 32848,80, 105,105, 32849,81, 106,106, 32850,82, 83,83, 107,107, 32852,84, 108,108, 32853,85, 109,109, 
32878,110, 32854,86, 111,111, 32855,87, 112,112, 32856,88, 89,89, 113,113, 32858,90, 114,114, 32859,91, 115,115, 32884,116, 32860,92, 117,117, 32861,93, 
118,118, 32862,94, 95,95, 119,119, 32864,96, 120,120, 32865,97, 121,121, 32890,122, 32866,98, 99,99, 123,123, 32868,100, 124,124, 32869,101, 125,125, 
32894,126, 32870,102, 103,103, 127,127, 32896,128, 32872,104, 129,129, 32873,105, 130,130, 32874,106, 107,107, 131,131, 32876,108, 132,132, 32877,109, 133,133, 
32902,134, 32878,110, 135,135, 32879,111, 136,136, 32880,112, 113,113, 137,137, 32882,114, 138,138, 32883,115, 139,139, 32908,140, 32884,116, 141,141, 32885,117, 
142,142, 32886,118, 119,119, 143,143, 32888,120, 144,144, 32889,121, 145,145, 32914,146, 32890,122, 123,123, 147,147, 32892,124, 148,148, 32893,125, 149,149, 
32918,150, 32894,126, 127,127, 151,151, 32920,152, 32896,128, 153,153, 32897,129, 154,154, 32898,130, 131,131, 155,155, 32900,132, 156,156, 32901,133, 157,157, 
32926,158, 32902,134, 159,159, 32903,135, 160,160, 32904,136, 137,137, 161,161, 32906,138, 162,162, 32907,139, 163,163, 32932,164, 32908,140, 165,165, 32909,141, 
166,166, 32910,142, 143,143, 167,167, 32912,144, 168,168, 32913,145, 169,169, 32938,170, 32914,146, 147,147, 171,171, 32916,148, 172,172, 32917,149, 173,173, 
32942,174, 32918,150, 151,151, 175,175, 32944,176, 32920,152, 177,177, 32921,153, 178,178, 32922,154, 155,155, 179,179, 32924,156, 180,180, 32925,157, 181,181, 
32950,182, 32926,158, 183,183, 32927,159, 184,184, 32928,160, 161,161, 185,185, 32930,162, 186,186, 32931,163, 187,187, 32956,188, 32932,164, 189,189, 32933,165, 
190,190, 32934,166, 167,167, 191,191, 32936,168, 192,192, 32937,169, 193,193, 32962,194, 32938,170, 171,171, 195,195, 32940,172, 196,196, 32941,173, 197,197, 
32966,198, 32942,174, 175,175, 199,199, 32968,200, 32944,176, 201,201, 32945,177, 202,202, 32946,178, 179,179, 203,203, 32948,180, 204,204, 32949,181, 205,205, 
32974,206, 32950,182, 207,207, 32951,183, 208,208, 32952,184, 185,185, 209,209, 32954,186, 210,210, 32955,187, 211,211, 32980,212, 32956,188, 213,213, 32957,189, 
214,214, 32958,190, 191,191, 215,215, 32960,192, 216,216, 32961,193, 217,217, 32986,218, 32962,194, 195,195, 219,219, 32964,196, 220,220, 32965,197, 221,221, 
32990,222, 32966,198, 199,199, 223,223, 32992,224, 32968,200, 225,225, 32969,201, 226,226, 32970,202, 203,203, 227,227, 32972,204, 228,228, 32973,205, 229,229, 
32998,230, 32974,206, 231,231, 32975,207, 232,232, 32976,208, 209,209, 233,233, 32978,210, 234,234, 32979,211, 235,235, 33004,236, 32980,212, 237,237, 32981,213, 
238,238, 32982,214, 215,215, 239,239, 32984,216, 240,240, 32985,217, 241,241, 33010,242, 32986,218, 219,219, 243,243, 32988,220, 244,244, 32989,221, 245,245, 
33014,246, 32990,222, 223,223, 247,247, 33016,248, 32992,224, 249,249, 32993,225, 250,250, 32994,226, 227,227, 251,251, 32996,228, 252,252, 32997,229, 253,253, 
33022,254, 32998,230, 255,255, 32999,231, 256,256, 33000,232, 233,233, 257,257, 33002,234, 258,258, 33003,235, 259,259, 33028,260, 33004,236, 261,261, 33005,237, 
262,262, 33006,238, 239,239, 263,263, 33008,240, 264,264, 33009,241, 265,265, 33034,266, 33010,242, 243,243, 267,267, 33012,244, 268,268, 33037,269, 33038,270, 
33013,245, 271,271, 33040,272, 33014,246, 247,247, 273,273, 33042,274, 33016,248, 275,275, 33017,249, 276,276, 33018,250, 251,251, 277,277, 33020,252, 278,278, 
33021,253, 279,279, 33048,280, 33022,254, 281,281, 33023,255, 282,282, 33024,256, 257,257, 283,283, 33026,258, 284,284, 33027,259, 285,285, 33054,286, 33028,260, 
287,287, 33029,261, 288,288, 33030,262, 263,263, 289,289, 33032,264, 290,290, 33033,265, 291,291, 33060,292, 33034,266, 267,267, 293,293, 33036,268, 294,294, 
33063,295, 33037,269, 296,296, 33065,297, 33038,270, 298,298, 33039,271, 299,299, 33068,300, 33040,272, 273,273, 274,274, 301,301, 33043,275, 302,302, 33044,276, 
303,303, 33072,304, 33045,277, 305,305, 33046,278, 306,306, 33047,279, 280,280, 307,307, 33049,281, 308,308, 33050,282, 309,309, 33078,310, 33051,283, 311,311, 
33052,284, 312,312, 33053,285, 286,286, 313,313, 33055,287, 314,314, 33056,288, 315,315, 33084,316, 33057,289, 317,317, 33058,290, 318,318, 33059,291, 292,292, 
293,293, 319,319, 33062,294, 320,320, 33089,321, 33063,295, 322,322, 33064,296, 323,323, 33092,324, 33065,297, 325,325, 33066,298, 326,326, 33067,299, 327,327, 
33069,301, 33068,300, 
432, // chain 1
328,328, 329,329, 330,330, 
33099,331, 33100,332, 333,333, 33102,334, 335,335, 336,336, 33105,337, 338,338, 33107,339, 340,340, 33109,341, 33110,342, 343,343, 33112,344, 345,345, 33114,346, 
347,347, 348,348, 33117,349, 350,350, 33119,351, 352,352, 33121,353, 33122,354, 355,355, 33124,356, 357,357, 33126,358, 359,359, 360,360, 33129,361, 362,362, 
33131,363, 364,364, 33133,365, 33134,366, 367,367, 33136,368, 369,369, 33138,370, 371,371, 372,372, 33141,373, 374,374, 33096,328, 375,375, 33098,330, 376,376, 
33145,377, 33099,331, 378,378, 33101,333, 379,379, 33104,336, 380,380, 33149,381, 33106,338, 382,382, 33108,340, 341,341, 383,383, 33111,343, 384,384, 33153,385, 
33113,345, 386,386, 33116,348, 387,387, 33118,350, 388,388, 33120,352, 389,389, 33121,353, 355,355, 390,390, 33159,391, 33125,357, 392,392, 33128,360, 393,393, 
33130,362, 394,394, 33132,364, 365,365, 395,395, 33135,367, 396,396, 33137,369, 397,397, 33140,372, 398,398, 33167,399, 33142,374, 375,375, 376,376, 400,400, 
33145,377, 401,401, 33146,378, 402,402, 33147,379, 403,403, 33172,404, 33148,380, 405,405, 33149,381, 406,406, 33150,382, 383,383, 407,407, 33152,384, 408,408, 
33153,385, 409,409, 33178,410, 33154,386, 411,411, 33155,387, 412,412, 33156,388, 389,389, 413,413, 33158,390, 414,414, 33159,391, 415,415, 33184,416, 33160,392, 
417,417, 33161,393, 418,418, 33162,394, 395,395, 419,419, 33164,396, 420,420, 33165,397, 421,421, 33190,422, 33166,398, 423,423, 33167,399, 400,400, 424,424, 
33169,401, 425,425, 33170,402, 426,426, 33171,403, 427,427, 33196,428, 33172,404, 429,429, 33173,405, 430,430, 33174,406, 407,407, 431,431, 33176,408, 432,432, 
33177,409, 433,433, 33202,434, 33178,410, 435,435, 33179,411, 436,436, 33180,412, 413,413, 437,437, 33182,414, 438,438, 33183,415, 439,439, 33208,440, 33184,416, 
441,441, 33185,417, 442,442, 33186,418, 419,419, 443,443, 33188,420, 444,444, 33189,421, 445,445, 33214,446, 33190,422, 447,447, 33191,423, 424,424, 448,448, 
33193,425, 449,449, 33194,426, 450,450, 33195,427, 451,451, 33220,452, 33196,428, 453,453, 33197,429, 454,454, 33198,430, 431,431, 455,455, 33200,432, 456,456, 
33201,433, 457,457, 33226,458, 33202,434, 459,459, 33203,435, 460,460, 33204,436, 437,437, 461,461, 33206,438, 462,462, 33207,439, 463,463, 33232,464, 33208,440, 
465,465, 33209,441, 466,466, 33210,442, 443,443, 467,467, 33212,444, 468,468, 33213,445, 469,469, 33238,470, 33214,446, 471,471, 33215,447, 448,448, 472,472, 
33217,449, 473,473, 33218,450, 474,474, 33219,451, 475,475, 33244,476, 33220,452, 477,477, 33221,453, 478,478, 33222,454, 455,455, 479,479, 33224,456, 480,480, 
33225,457, 481,481, 33250,482, 33226,458, 483,483, 33227,459, 484,484, 33228,460, 461,461, 485,485, 33230,462, 486,486, 33231,463, 487,487, 33256,488, 33232,464, 
489,489, 33233,465, 490,490, 33234,466, 467,467, 491,491, 33236,468, 492,492, 33237,469, 493,493, 33262,494, 33238,470, 495,495, 33239,471, 472,472, 496,496, 
33241,473, 497,497, 33242,474, 498,498, 33243,475, 499,499, 33268,500, 33244,476, 501,501, 33245,477, 502,502, 33246,478, 479,479, 503,503, 33248,480, 504,504, 
33249,481, 505,505, 33274,506, 33250,482, 507,507, 33251,483, 508,508, 33252,484, 485,485, 509,509, 33254,486, 510,510, 33255,487, 511,511, 33280,512, 33256,488, 
513,513, 33257,489, 514,514, 33258,490, 491,491, 515,515, 33260,492, 516,516, 33261,493, 517,517, 33286,518, 33262,494, 519,519, 33263,495, 496,496, 520,520, 
33265,497, 521,521, 33266,498, 522,522, 33267,499, 523,523, 33292,524, 33268,500, 525,525, 33269,501, 526,526, 33270,502, 503,503, 527,527, 33272,504, 528,528, 
33273,505, 529,529, 33298,530, 33274,506, 531,531, 33275,507, 532,532, 33276,508, 509,509, 533,533, 33278,510, 534,534, 33279,511, 535,535, 33304,536, 33280,512, 
537,537, 33281,513, 538,538, 33282,514, 515,515, 539,539, 33284,516, 540,540, 33285,517, 541,541, 33310,542, 33286,518, 543,543, 33287,519, 520,520, 323,323, 
33289,521, 322,322, 33290,522, 321,321, 33291,523, 320,320, 33312,544, 33292,524, 545,545, 33293,525, 546,546, 33294,526, 527,527, 547,547, 33296,528, 548,548, 
33297,529, 549,549, 33318,550, 33298,530, 551,551, 33299,531, 552,552, 33300,532, 533,533, 553,553, 33302,534, 554,554, 33303,535, 555,555, 33324,556, 33304,536, 
557,557, 33305,537, 558,558, 33306,538, 539,539, 559,559, 33308,540, 560,560, 33309,541, 326,326, 33093,325, 33310,542, 324,324, 33311,543, 323,323, 
6, // chain 2
319,319, 320,320, 561,561, 
317,317, 33084,316, 33330,562, 33312,544, 33088,320, 
1, // chain 3
317,317, 318,318, 319,319, 
32, // chain 4
544,544, 545,545, 562,562, 
33331,563, 33314,546, 547,547, 564,564, 33316,548, 565,565, 33317,549, 566,566, 33335,567, 33318,550, 568,568, 33319,551, 569,569, 33320,552, 553,553, 570,570, 
33322,554, 571,571, 33323,555, 572,572, 33341,573, 33324,556, 574,574, 33325,557, 575,575, 33326,558, 559,559, 576,576, 33328,560, 327,327, 33094,326, 
30, // chain 5
315,315, 316,316, 562,562, 
563,563, 564,564, 314,314, 33333,565, 313,313, 33334,566, 312,312, 33079,311, 33335,567, 310,310, 33336,568, 309,309, 33337,569, 570,570, 308,308, 33339,571, 
307,307, 33340,572, 306,306, 33073,305, 33341,573, 304,304, 33342,574, 303,303, 33343,575, 576,576, 302,302, 33095,327, 301,301, 
6, // chain 6
577,577, 578,578, 579,579, 
580,580, 33349,581, 33350,582, 33351,583, 33346,578, 
13, // chain 7
584,584, 578,578, 577,577, 
585,585, 33354,586, 33348,580, 587,587, 33356,588, 33349,581, 589,589, 33358,590, 33350,582, 591,591, 33360,592, 33351,583, 
6, // chain 8
591,591, 592,592, 593,593, 
594,594, 33363,595, 33364,596, 33365,597, 33360,592, 
37, // chain 9
597,597, 598,598, 596,596, 
33367,599, 33368,600, 601,601, 602,602, 33371,603, 604,604, 33373,605, 606,606, 33375,607, 33376,608, 609,609, 33378,610, 611,611, 33380,612, 613,613, 614,614, 
33383,615, 616,616, 33385,617, 618,618, 33387,619, 33388,620, 621,621, 33390,622, 623,623, 33392,624, 625,625, 626,626, 33395,627, 628,628, 33397,629, 630,630, 
33399,631, 33400,632, 586,586, 33353,585, 
51, // chain 10
633,633, 589,589, 634,634, 
635,635, 33404,636, 33405,637, 33406,638, 33357,589, 590,590, 639,639, 33359,591, 594,594, 640,640, 33409,641, 33363,595, 642,642, 33411,643, 33364,596, 599,599, 
602,602, 644,644, 33372,604, 645,645, 33374,606, 646,646, 33415,647, 33375,607, 648,648, 33377,609, 649,649, 33379,611, 614,614, 650,650, 33384,616, 651,651, 
33386,618, 652,652, 33421,653, 33387,619, 654,654, 33389,621, 655,655, 33391,623, 626,626, 656,656, 33396,628, 657,657, 33398,630, 658,658, 33427,659, 33399,631, 
587,587, 33354,586, 
23, // chain 11
588,588, 589,589, 633,633, 
660,660, 33429,661, 33403,635, 662,662, 33431,663, 33404,636, 664,664, 33433,665, 33405,637, 666,666, 33435,667, 33406,638, 639,639, 640,640, 668,668, 33437,669, 
33409,641, 670,670, 33410,642, 671,671, 33412,644, 33411,643, 
54, // chain 12
672,672, 673,673, 664,664, 
33431,663, 33442,674, 33443,675, 676,676, 33445,677, 678,678, 33447,679, 680,680, 681,681, 33450,682, 683,683, 33452,684, 685,685, 33454,686, 33455,687, 688,688, 
33457,689, 690,690, 33459,691, 692,692, 693,693, 33462,694, 695,695, 33464,696, 697,697, 33466,698, 33467,699, 700,700, 33469,701, 702,702, 33471,703, 704,704, 
705,705, 33474,706, 707,707, 33476,708, 709,709, 33478,710, 33479,711, 712,712, 33481,713, 714,714, 33483,715, 716,716, 717,717, 33440,672, 664,664, 665,665, 
718,718, 33434,666, 719,719, 33436,668, 33435,667, 
14, // chain 13
714,714, 717,717, 718,718, 
712,712, 33487,719, 710,710, 33488,720, 33436,668, 669,669, 721,721, 33438,670, 722,722, 33439,671, 723,723, 33413,645, 33412,644, 
9, // chain 14
709,709, 710,710, 720,720, 
721,721, 724,724, 33490,722, 725,725, 33491,723, 726,726, 33414,646, 33413,645, 
36, // chain 15
707,707, 709,709, 724,724, 
727,727, 33493,725, 728,728, 33494,726, 729,729, 33498,730, 33414,646, 647,647, 731,731, 33416,648, 732,732, 33417,649, 650,650, 733,733, 33419,651, 734,734, 
33420,652, 735,735, 33504,736, 33421,653, 737,737, 33422,654, 738,738, 33423,655, 656,656, 739,739, 33425,657, 740,740, 33426,658, 741,741, 33510,742, 33427,659, 
660,660, 33355,587, 588,588, 
33, // chain 16
705,705, 707,707, 727,727, 
743,743, 33496,728, 744,744, 33497,729, 745,745, 33514,746, 33498,730, 731,731, 747,747, 33500,732, 733,733, 748,748, 33502,734, 749,749, 33503,735, 750,750, 
33519,751, 33504,736, 752,752, 33505,737, 753,753, 33506,738, 739,739, 754,754, 33508,740, 755,755, 33509,741, 756,756, 33525,757, 33510,742, 661,661, 33428,660, 
31, // chain 17
702,702, 705,705, 743,743, 
700,700, 33512,744, 698,698, 33513,745, 697,697, 33526,758, 33514,746, 747,747, 748,748, 759,759, 33517,749, 760,760, 33518,750, 761,761, 33530,762, 33519,751, 
763,763, 33520,752, 764,764, 33521,753, 754,754, 765,765, 33523,755, 766,766, 33524,756, 767,767, 33536,768, 33525,757, 662,662, 33429,661, 
2, // chain 18
695,695, 697,697, 759,759, 
33526,758, 
2, // chain 19
693,693, 695,695, 760,760, 
33527,759, 
2, // chain 20
690,690, 693,693, 761,761, 
33528,760, 
17, // chain 21
688,688, 690,690, 761,761, 
762,762, 686,686, 33531,763, 685,685, 33532,764, 765,765, 683,683, 33534,766, 681,681, 33535,767, 678,678, 33444,676, 33536,768, 674,674, 33430,662, 663,663, 
10, // chain 22
769,769, 770,770, 771,771, 
772,772, 33541,773, 33542,774, 33543,775, 33538,770, 776,776, 33545,777, 33546,778, 33537,769, 
7, // chain 23
779,779, 774,774, 780,780, 
781,781, 33550,782, 33551,783, 33552,784, 33543,775, 33542,774, 
6, // chain 24
785,785, 782,782, 786,786, 
787,787, 33556,788, 33557,789, 33551,783, 33550,782, 
18, // chain 25
781,781, 782,782, 785,785, 
790,790, 33559,791, 33555,787, 792,792, 33561,793, 33556,788, 794,794, 33563,795, 33564,796, 33557,789, 797,797, 33566,798, 33551,783, 784,784, 799,799, 33544,776, 
33543,775, 
20, // chain 26
777,777, 778,778, 800,800, 
801,801, 33570,802, 803,803, 33572,804, 805,805, 33574,806, 807,807, 33576,808, 809,809, 810,810, 33579,811, 812,812, 33581,813, 814,814, 33583,815, 816,816, 
33585,817, 772,772, 33537,769, 
50, // chain 27
776,776, 777,777, 818,818, 
33569,801, 819,819, 33571,803, 820,820, 33573,805, 821,821, 33575,807, 810,810, 822,822, 33580,812, 823,823, 33582,814, 824,824, 33584,816, 825,825, 33540,772, 
773,773, 826,826, 33595,827, 33542,774, 779,779, 781,781, 790,790, 828,828, 33559,791, 829,829, 33560,792, 830,830, 33599,831, 33600,832, 33561,793, 833,833, 
33602,834, 33603,835, 33562,794, 836,836, 33563,795, 837,837, 33606,838, 33564,796, 839,839, 33565,797, 840,840, 33609,841, 33566,798, 799,799, 842,842, 33586,818, 
33544,776, 
16, // chain 28
842,842, 818,818, 819,819, 
843,843, 33588,820, 821,821, 844,844, 33613,845, 33590,822, 823,823, 846,846, 33592,824, 847,847, 33593,825, 826,826, 848,848, 33596,828, 33595,827, 
21, // chain 29
839,839, 840,840, 849,849, 
850,850, 33619,851, 33620,852, 33621,853, 33608,840, 854,854, 33609,841, 842,842, 843,843, 844,844, 855,855, 33624,856, 33613,845, 846,846, 857,857, 33615,847, 
848,848, 858,858, 33597,829, 33596,828, 
13, // chain 30
853,853, 855,855, 859,859, 
852,852, 33628,860, 33629,861, 33630,862, 33623,855, 856,856, 863,863, 33625,857, 858,858, 864,864, 33598,830, 33597,829, 
1, // chain 31
854,854, 855,855, 853,853, 
6, // chain 32
861,861, 862,862, 865,865, 
866,866, 33635,867, 33632,864, 33631,863, 33630,862, 
6, // chain 33
868,868, 834,834, 869,869, 
870,870, 33639,871, 33640,872, 33603,835, 33602,834, 
9, // chain 34
873,873, 868,868, 870,870, 
874,874, 33643,875, 33639,871, 876,876, 33645,877, 33640,872, 836,836, 33603,835, 
11, // chain 35
878,878, 873,873, 874,874, 
879,879, 33643,875, 880,880, 33649,881, 33644,876, 882,882, 33651,883, 33645,877, 837,837, 33604,836, 
20, // chain 36
879,879, 884,884, 878,878, 
33653,885, 886,886, 33655,887, 33656,888, 889,889, 33658,890, 891,891, 33660,892, 893,893, 33662,894, 895,895, 896,896, 33665,897, 33666,898, 899,899, 900,900, 
33669,901, 881,881, 33648,880, 
30, // chain 37
838,838, 839,839, 850,850, 
902,902, 33671,903, 33619,851, 904,904, 33673,905, 33620,852, 860,860, 861,861, 866,866, 904,904, 33674,906, 33635,867, 907,907, 33676,908, 33632,864, 830,830, 
831,831, 909,909, 33678,910, 33600,832, 833,833, 911,911, 33680,912, 33602,834, 868,868, 913,913, 33641,873, 886,886, 33646,878, 
12, // chain 38
837,837, 838,838, 902,902, 
883,883, 33682,914, 33671,903, 915,915, 33672,904, 906,906, 916,916, 33675,907, 917,917, 33677,909, 33676,908, 
21, // chain 39
900,900, 881,881, 882,882, 
897,897, 33686,918, 33651,883, 914,914, 919,919, 33683,915, 916,916, 920,920, 33685,917, 921,921, 33690,922, 33691,923, 33677,909, 910,910, 911,911, 924,924, 
33680,912, 913,913, 887,887, 33654,886, 
11, // chain 40
896,896, 897,897, 918,918, 
919,919, 920,920, 893,893, 33689,921, 891,891, 33657,889, 33690,922, 887,887, 33692,924, 33691,923, 
144, // chain 41
925,925, 926,926, 927,927, 
33696,928, 33697,929, 930,930, 33699,931, 932,932, 33701,933, 934,934, 33703,935, 936,936, 937,937, 33706,938, 33707,939, 940,940, 941,941, 33710,942, 943,943, 
33712,944, 945,945, 33714,946, 947,947, 33693,925, 948,948, 33695,927, 949,949, 33718,950, 33696,928, 951,951, 33698,930, 952,952, 33700,932, 934,934, 953,953, 
33705,937, 954,954, 33723,955, 33706,938, 956,956, 33709,941, 943,943, 957,957, 33713,945, 958,958, 33715,947, 959,959, 33716,948, 960,960, 33717,949, 961,961, 
33730,962, 33718,950, 951,951, 963,963, 33720,952, 964,964, 33721,953, 965,965, 33722,954, 966,966, 33735,967, 33723,955, 968,968, 33724,956, 969,969, 33725,957, 
970,970, 33726,958, 959,959, 971,971, 33728,960, 972,972, 33729,961, 973,973, 33742,974, 33730,962, 963,963, 975,975, 33732,964, 976,976, 33733,965, 977,977, 
33734,966, 978,978, 33747,979, 33735,967, 980,980, 33736,968, 981,981, 33737,969, 982,982, 33738,970, 971,971, 983,983, 33740,972, 984,984, 33741,973, 985,985, 
33742,974, 986,986, 33743,975, 987,987, 33744,976, 988,988, 33745,977, 989,989, 33746,978, 990,990, 33759,991, 33747,979, 992,992, 33748,980, 993,993, 33749,981, 
994,994, 33750,982, 995,995, 33751,983, 984,984, 996,996, 33753,985, 997,997, 33766,998, 33754,986, 999,999, 33755,987, 1000,1000, 33756,988, 1001,1001, 33757,989, 
1002,1002, 33758,990, 1003,1003, 33772,1004, 33759,991, 1005,1005, 33760,992, 1006,1006, 33761,993, 1007,1007, 33762,994, 1008,1008, 33763,995, 997,997, 33764,996, 
24, // chain 42
997,997, 998,998, 1009,1009, 
33778,1010, 33767,999, 1011,1011, 33768,1000, 1012,1012, 33769,1001, 1013,1013, 33770,1002, 1014,1014, 33771,1003, 1015,1015, 33784,1016, 33772,1004, 1017,1017, 33773,1005, 1018,1018, 
33774,1006, 1019,1019, 33775,1007, 1020,1020, 33776,1008, 1009,1009, 33765,997, 
24, // chain 43
1009,1009, 1010,1010, 1021,1021, 
33790,1022, 33779,1011, 1023,1023, 33780,1012, 1024,1024, 33781,1013, 1025,1025, 33782,1014, 1026,1026, 33783,1015, 1027,1027, 33796,1028, 33784,1016, 1029,1029, 33785,1017, 1030,1030, 
33786,1018, 1031,1031, 33787,1019, 1032,1032, 33788,1020, 1021,1021, 33777,1009, 
24, // chain 44
1021,1021, 1022,1022, 1033,1033, 
33802,1034, 33791,1023, 1035,1035, 33792,1024, 1036,1036, 33793,1025, 1037,1037, 33794,1026, 1038,1038, 33795,1027, 1039,1039, 33808,1040, 33796,1028, 1041,1041, 33797,1029, 1042,1042, 
33798,1030, 1043,1043, 33799,1031, 1044,1044, 33800,1032, 1033,1033, 33789,1021, 
6, // chain 45
1045,1045, 1033,1033, 1046,1046, 
1047,1047, 33816,1048, 33817,1049, 33802,1034, 33801,1033, 
10, // chain 46
1050,1050, 1045,1045, 1047,1047, 
1051,1051, 33820,1052, 33816,1048, 1053,1053, 33822,1054, 33817,1049, 1055,1055, 33803,1035, 33802,1034, 
19, // chain 47
1051,1051, 1056,1056, 1050,1050, 
33825,1057, 1058,1058, 33827,1059, 1060,1060, 33829,1061, 1062,1062, 33831,1063, 1064,1064, 33833,1065, 1066,1066, 33835,1067, 1068,1068, 33837,1069, 33838,1070, 1071,1071, 33840,1072, 
1054,1054, 33821,1053, 
21, // chain 48
1035,1035, 1036,1036, 1055,1055, 
33841,1073, 33805,1037, 1074,1074, 33806,1038, 1075,1075, 33807,1039, 1040,1040, 1076,1076, 33809,1041, 1077,1077, 33810,1042, 1078,1078, 33811,1043, 1079,1079, 33812,1044, 1080,1080, 
33801,1033, 1045,1045, 1058,1058, 33818,1050, 
16, // chain 49
1071,1071, 1054,1054, 1055,1055, 
1073,1073, 1069,1069, 33842,1074, 1068,1068, 33843,1075, 1076,1076, 1066,1066, 33845,1077, 1064,1064, 33846,1078, 1062,1062, 33847,1079, 1060,1060, 33848,1080, 1058,1058, 
147, // chain 50
1081,1081, 1082,1082, 1083,1083, 
1084,1084, 33853,1085, 33850,1082, 1086,1086, 33855,1087, 33849,1081, 1088,1088, 33857,1089, 33858,1090, 33859,1091, 33860,1092, 33861,1093, 33862,1094, 33863,1095, 33864,1096, 33865,1097, 
33866,1098, 33867,1099, 33868,1100, 33869,1101, 33870,1102, 33871,1103, 33872,1104, 33873,1105, 33874,1106, 33875,1107, 33852,1084, 1108,1108, 33853,1085, 1109,1109, 33878,1110, 33879,1111, 
33854,1086, 1112,1112, 33881,1113, 33855,1087, 1088,1088, 1114,1114, 33883,1115, 33857,1089, 1116,1116, 33858,1090, 1117,1117, 33859,1091, 1092,1092, 1118,1118, 33861,1093, 1119,1119, 
33862,1094, 1120,1120, 33889,1121, 33863,1095, 1122,1122, 33864,1096, 1123,1123, 33865,1097, 1098,1098, 1124,1124, 33867,1099, 1125,1125, 33868,1100, 1126,1126, 33895,1127, 33869,1101, 
1128,1128, 33870,1102, 1129,1129, 33871,1103, 1104,1104, 1130,1130, 33873,1105, 1131,1131, 33874,1106, 1132,1132, 33901,1133, 33875,1107, 1108,1108, 1134,1134, 33877,1109, 1135,1135, 
33904,1136, 33878,1110, 1137,1137, 33906,1138, 33879,1111, 1139,1139, 33880,1112, 1140,1140, 33909,1141, 33881,1113, 1114,1114, 1115,1115, 1142,1142, 33884,1116, 1143,1143, 33885,1117, 
1144,1144, 33913,1145, 33886,1118, 1146,1146, 33887,1119, 1147,1147, 33888,1120, 1121,1121, 1148,1148, 33890,1122, 1149,1149, 33891,1123, 1150,1150, 33919,1151, 33892,1124, 1152,1152, 
33893,1125, 1153,1153, 33894,1126, 1127,1127, 1154,1154, 33896,1128, 1155,1155, 33897,1129, 1156,1156, 33925,1157, 33898,1130, 1158,1158, 33899,1131, 1159,1159, 33900,1132, 1133,1133, 
1134,1134, 1160,1160, 33903,1135, 1161,1161, 33930,1162, 33904,1136, 1163,1163, 33905,1137, 1164,1164, 33933,1165, 33906,1138, 1166,1166, 33907,1139, 1167,1167, 33908,1140, 1168,1168, 
33910,1142, 33909,1141, 
4, // chain 51
1169,1169, 1167,1167, 1168,1168, 
1170,1170, 33911,1143, 33910,1142, 
4, // chain 52
1171,1171, 1169,1169, 1170,1170, 
1172,1172, 33912,1144, 33911,1143, 
33, // chain 53
1173,1173, 1171,1171, 1172,1172, 
1174,1174, 33943,1175, 33912,1144, 1145,1145, 1176,1176, 33914,1146, 1177,1177, 33915,1147, 1148,1148, 1178,1178, 33917,1149, 1179,1179, 33918,1150, 1180,1180, 33949,1181, 33919,1151, 
1182,1182, 33920,1152, 1183,1183, 33921,1153, 1154,1154, 1184,1184, 33923,1155, 1185,1185, 33924,1156, 1186,1186, 33955,1187, 33925,1157, 1188,1188, 33926,1158, 1160,1160, 33927,1159, 
28, // chain 54
1189,1189, 1174,1174, 1175,1175, 
1176,1176, 1190,1190, 33945,1177, 1178,1178, 1191,1191, 33947,1179, 1192,1192, 33948,1180, 1193,1193, 33962,1194, 33949,1181, 1195,1195, 33950,1182, 1196,1196, 33951,1183, 1184,1184, 
1197,1197, 33953,1185, 1198,1198, 33954,1186, 1199,1199, 33968,1200, 33955,1187, 1201,1201, 33956,1188, 1161,1161, 33928,1160, 

 0};


// mesh info for object teapot (with tag [])
const tgx::Mesh3D<tgx::RGB565> teapot = 
    {
    1, // version/id
    
    1202, // number of vertices
    0, // number of texture coords
    1202, // number of normal vectors
    2256, // number of triangles
    4788, // size of faces
    
    teapot_vert_array, // array of vertices
    nullptr, // array of texture coords
    teapot_norm_array, // array of normal vectors        
    teapot_face, // array of face vertex indexes   
    
    nullptr, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    nullptr, // next mesh to draw after this one    
    
    { // mesh bounding box
    -1.0, 1.0, 
    -0.48991932661755033, 0.48991932661755033, 
    -0.62211977983181, 0.62211977983181
    },
    
    "Utah teapot" // model name    
    };
    
                
/** end of teapot.h */
    
    
    