// 3D model [skull]
//
// - vertices   : 5077
// - textures   : 0
// - normals    : 5077
// - triangles  : 9535
//
// - memory size: 160kb
//
// - model bounding box: [-0.86,0.86]x[-1.0,1.0]x[-0.68,0.68]
//
// object [skull_1] (tagged [ | g skull]) with 5535 triangles (267 chains)
// object [skull_2] (tagged [g uteeth]) with 1084 triangles (75 chains)
// object [skull_3] (tagged [g jaw]) with 2066 triangles (62 chains)
// object [skull_4] (tagged [g lteeth]) with 850 triangles (51 chains)

#pragma once

#include <tgx.h>


// vertex array: 59kb.
const tgx::fVec3 skull_vert_array[5077] PROGMEM = {
{0.6226915980354712,-0.5280601623479669,-0.24020936324954145},
{0.5944523042329892,-0.5121857802976917,-0.252307460583011},
{0.6438172751577487,-0.4178216969612204,-0.21119652280563972},
{0.6849292887997117,-0.5395019822805102,-0.2215452643130336},
{0.6950940574619279,-0.4314830255464047,-0.18778463342603702},
{0.6722093417322496,-0.3104170589089657,-0.20662840174935584},
{0.6363077403078049,-0.3375159362442643,-0.2556953581822192},
{0.615332684228363,-0.4197195221009484,-0.24344126048295564},
{0.5957078382114828,-0.4273635400248525,-0.2655180019042804},
{0.5594006358359737,-0.43743040500922553,-0.26840562246835614},
{0.5326212902844049,-0.509504725735219,-0.25381044341759146},
{0.5516931419011604,-0.50572628928923,-0.2498706272828502},
{0.5649897523897642,-0.5047580111567158,-0.2502288901918805},
{0.5760356541525683,-0.5170228675018962,-0.23433406671436333},
{0.5805973200213022,-0.5325766419038499,-0.2116806618718968},
{0.6022566259810541,-0.5265098414713524,-0.22790362404987707},
{0.6177931865495409,-0.5257728742260499,-0.22840390108500946},
{0.635507297051593,-0.5357977804913474,-0.21465219987412384},
{0.6420625400087145,-0.547197641704815,-0.20071760168265224},
{0.6508996917647945,-0.5413180417112702,-0.20936647713518777},
{0.6687332232365235,-0.5345443982420373,-0.2157883128829406},
{0.6866130168856948,-0.5349650612973851,-0.21187862095676638},
{0.7140120604420728,-0.5426757828259735,-0.2116010478921123},
{0.7397800932774601,-0.5408328267804214,-0.18865608374529982},
{0.7181369252865836,-0.42978531122072977,-0.17415773250778657},
{0.719104127554506,-0.33484779205689175,-0.1663641694056386},
{0.7163671280332657,-0.2282037902709565,-0.16910116892687888},
{0.715316008327192,-0.22086962134945695,-0.23011344992119293},
{0.6814176667724601,-0.23592527044546174,-0.22240488012178788},
{0.6698499706826899,-0.26517264937035023,-0.23030172622473735},
{0.6771260429162386,-0.253913726418393,-0.27323948207878557},
{0.6499410964136054,-0.30130771341119006,-0.3362765402346461},
{0.6145462272118432,-0.3890240294356552,-0.25837103342173356},
{0.6210175527308134,-0.3504359941257793,-0.31209325594280707},
{0.601480927610451,-0.38279369758522186,-0.30140238949525816},
{0.5654792707789797,-0.4016632866587411,-0.287320397854726},
{0.5168039290574888,-0.381031431384046,-0.276257282258455},
{0.5097430297422766,-0.4217765752002453,-0.267826807318031},
{0.5007649397246863,-0.4904941984001894,-0.25570504096354435},
{0.4913597314641979,-0.5050700118883037,-0.22113643576819425},
{0.49957073002791874,-0.5063223182730222,-0.23123557669031775},
{0.5209976492358672,-0.5060092416768425,-0.24389312361146226},
{0.5301769259321022,-0.5055347853919107,-0.23943258901434666},
{0.7774880713513398,-0.5312942113105644,-0.162198421706644},
{0.7488614662958519,-0.4281187969682136,-0.14205500895657272},
{0.7876571434719227,-0.5370447075531074,-0.1307681135252317},
{0.7671909713443467,-0.4326621731388888,-0.08697934877916266},
{0.7447925464101088,-0.3426176861380226,-0.1335836511616648},
{0.7395175823170895,-0.31890993399570733,-0.10851600617546275},
{0.7477339602037687,-0.2634899971489588,-0.11628374852741036},
{0.7343566598707887,-0.25046988386041735,-0.13434428742798432},
{0.7652328977874845,-0.17139706396552928,-0.12634415832423332},
{0.746848523644814,-0.1417419323603931,-0.13832928987557627},
{0.7511154026154269,-0.18312829147323517,-0.19540928578729083},
{0.7551531224280112,-0.21487813143837714,-0.19982463407155576},
{0.7354110071706376,-0.17752949213811947,-0.24562849319784613},
{0.7082368193139211,-0.20158905200191501,-0.301507824225243},
{0.770815559153725,-0.3563607804321748,-0.08557642135160869},
{0.7297713249810378,-0.31039769334631545,-0.09684825467866613},
{0.7356251042243823,-0.2576598869266314,-0.10274506850567788},
{0.7675298686907266,-0.1900450249331619,-0.09958095074153968},
{0.7798689596927332,-0.19073142654265532,-0.11439130271064085},
{0.8058478619880902,-0.13995492127360848,-0.0935700952678096},
{0.7954055202612199,-0.11865280235829516,-0.10010597266228073},
{0.7608035632635276,-0.11778242790362403,-0.11980505333598714},
{0.7664055901924184,-0.11301957535624564,-0.13899202246405268},
{0.7442406278745758,-0.15373459496387784,-0.20085746407957095},
{0.7812342318595781,-0.3665147904484742,-0.045480023884193935},
{0.42228814881359034,-0.3702179163730453,-0.08563559390415122},
{0.42118538760711577,-0.34418091738973733,-0.10142390678709177},
{0.40742077602112997,-0.28607777425133274,-0.11013303065676155},
{0.38097172089920767,-0.22567120502213592,-0.11066558362964436},
{0.3570789200471228,-0.19428715901816596,-0.10558535102771965},
{0.8073831207604212,-0.1473697800394842,-0.07817554882542484},
{0.7862929471696692,-0.42431238804284094,-0.03401345906604195},
{0.8321979375675779,-0.37338526173095854,0.0},
{0.7949848572058721,-0.33610440189997687,0.0},
{0.39384766833246365,-0.3881353652829255,0.0},
{0.4293393653474774,-0.3908820475854909,-0.0523214468227029},
{0.4281978730157023,-0.41012496167232393,-0.08132352862068781},
{0.4097446435391642,-0.3932446462288256,-0.10887749667826807},
{0.3963243086225168,-0.3640424536167878,-0.10079237427177415},
{0.4001780555899234,-0.3257922397887002,-0.10622871805354578},
{0.3610004464838056,-0.3435816608121702,-0.11632032792352755},
{0.37273274985610305,-0.3059748140099087,-0.11184257949294503},
{0.3507765052690469,-0.24554565162428654,-0.11310994798194701},
{0.32053825505521877,-0.19667235081792603,-0.10481180438629996},
{0.3697719704997929,-0.1538034502977455,-0.09298912838830105},
{0.3687574301898363,-0.13032485731345853,-0.06443998558341447},
{0.8194414111039986,-0.12506387946013112,-0.06323609310532177},
{0.8246389129464166,-0.12309935071571891,-0.07750851277858169},
{0.819046568798851,-0.09387241321807235,-0.0803896781551074},
{0.8020048736666002,-0.051318741023254795,-0.07489523768538492},
{0.7995895576582732,-0.0638170599848303,-0.08765606760733095},
{0.7665755767979042,-0.07142880197098392,-0.11381786688327408},
{0.745435913435935,-0.0684680226146737,-0.1383820072405687},
{0.7368268449732917,-0.100579353082621,-0.16831578777495065},
{0.7265770830083326,-0.13692636244802228,-0.22270074288450056},
{0.702755289219299,-0.15798426010102368,-0.3091701318472057},
{0.7365331339397624,-0.1773519744804919,-0.30660634652522634},
{0.7219691549621565,-0.19255286529637378,-0.30496134956454385},
{0.6678456349483854,-0.22577126042916237,-0.3946518771147463},
{0.8166387838426656,-0.5444111524123574,-0.07914490282253075},
{0.8326734697171013,-0.5308025411921655,-0.048607562252214936},
{0.8316072879067441,-0.536741313738253,-0.021398946728564745},
{0.8080533844010392,-0.47681458011694644,-0.010330451809335279},
{0.8155779813552666,-0.4724896044583829,0.0},
{0.8080533844010392,-0.47681458011694644,0.010330451809335279},
{0.7862929471696692,-0.42431238804284094,0.03401345906604195},
{0.7812342318595781,-0.3665147904484742,0.045480023884193935},
{0.4293393653474774,-0.3908820475854909,0.0523214468227029},
{0.40146371377698403,-0.336408871579423,0.007988294593242495},
{0.7032491110668811,-0.30046208384212764,0.0},
{0.40146371377698403,-0.336408871579423,-0.007988294593242495},
{0.3836118926071964,-0.2192762658891752,0.0},
{0.39071690237066764,-0.24241918912085725,0.007993673916200907},
{0.40086768479319196,-0.28340855419936845,0.007989370457834178},
{0.4038854849728613,-0.3042168512670995,0.007988294593242495},
{0.7212956637277633,-0.21213790432336183,0.0},
{0.40086768479319196,-0.28340855419936845,-0.007989370457834178},
{0.4038854849728613,-0.3042168512670995,-0.007988294593242495},
{0.39071690237066764,-0.24241918912085725,-0.007993673916200907},
{0.8072938239993115,-0.5298030629864925,-0.10644819443024901},
{0.7850341855974007,-0.5232994615297718,-0.09304076988870182},
{0.7887028838550381,-0.5443369177555313,-0.07865323270413185},
{0.7933667568599816,-0.5463240396563689,-0.07218513477893673},
{0.7993001500831106,-0.5308154515672657,-0.06680366009134091},
{0.8076929697628256,-0.524332291537787,-0.044588132137689154},
{0.8082976056633512,-0.5313652183736155,-0.024751340796247388},
{0.8057456548518803,-0.5465004814494048,-0.011208357316148191},
{0.8315685567814435,-0.5541380441857587,0.0},
{0.8316072879067441,-0.536741313738253,0.021398946728564745},
{0.8326734697171013,-0.5308025411921655,0.048607562252214936},
{0.8166387838426656,-0.5444111524123574,0.07914490282253075},
{0.7671909713443467,-0.4326621731388888,0.08697934877916266},
{0.770815559153725,-0.3563607804321748,0.08557642135160869},
{0.42228814881359034,-0.3702179163730453,0.08563559390415122},
{0.4097446435391642,-0.3932446462288256,0.10887749667826807},
{0.4281978730157023,-0.41012496167232393,0.08132352862068781},
{0.4496484612446678,-0.3790808888793257,0.060225823977794156},
{0.4271553602263619,-0.3853327380215926,0.02036073739759114},
{0.4992092395251134,-0.38350376821573234,0.07737295384002969},
{0.45048118043863,-0.3943398763831584,0.025532418489808875},
{0.41027181718908856,-0.3967358268288353,0.0},
{0.4271553602263619,-0.3853327380215926,-0.02036073739759114},
{0.4496484612446678,-0.3790808888793257,-0.060225823977794156},
{0.45539572989343563,-0.3642985093896082,-0.09552924468926342},
{0.4403347014744724,-0.3481949681813047,-0.12043120652834634},
{0.4255178943178211,-0.4137968875237362,-0.11476677945313804},
{0.39051356396283965,-0.41522886329526565,-0.1190218239132423},
{0.3715600574511692,-0.37989101491686256,-0.11116908825855179},
{0.3462428118796968,-0.3887959461422185,-0.12462815430049974},
{0.318856678698419,-0.3503359387187528,-0.12551681845322948},
{0.33421464574468657,-0.31330898293140824,-0.1198749845344465},
{0.3168727843913565,-0.25218158442578414,-0.11638810739280354},
{0.28539728989709356,-0.20202908061991318,-0.11472912419242914},
{0.3360629811131971,-0.16542278788791642,-0.09243828571735963},
{0.3387106838733277,-0.14485440862413057,-0.06635932801497604},
{0.38641129227475435,-0.19454536652016977,-0.01936341092110147},
{0.7915076628455543,-0.1317084191783622,0.0},
{0.8530664830524431,-0.07527932134461554,0.0},
{0.852202563785322,-0.079503165731561,-0.02350548959907906},
{0.8418118635588525,-0.1013475204010823,-0.048380554823369934},
{0.8448597879470889,-0.09945615044890448,-0.06006767188281683},
{0.8391975126010641,-0.07637455149894833,-0.05723384454832515},
{0.8201751507555259,-0.025411921655540418,-0.05448716224575975},
{0.7966438404062465,0.021309649967455116,-0.0499125860019258},
{0.7891687332232367,0.010713459603974266,-0.05996331301742363},
{0.7621935803159815,-0.0017697972533176763,-0.08980887265528761},
{0.740973227109636,-0.031661619068624004,-0.11167689634582592},
{0.6910929170454607,-0.08762379166958044,-0.13532009661264033},
{0.6875242741948498,-0.10971129173682198,-0.1681361183881397},
{0.6789560885866905,-0.1475559046138453,-0.22764972000624004},
{0.6739414837248584,-0.16144316476328288,-0.29650397800932776},
{0.6495753024524333,-0.1577486457554452,-0.34943221246173956},
{0.6866603549277288,-0.15378408473509522,-0.36431787495225854},
{0.6925162859002565,-0.18086682410151858,-0.37966723508179256},
{0.6849185301537949,-0.20905232467441645,-0.3895802514295551},
{0.6672151782976594,-0.20819701232402887,-0.42887512977616643},
{0.6455741620359662,-0.30471820416682355,-0.40773546641419717},
{0.6208615523650193,-0.35326766973108764,-0.38835699338881213},
{0.777348208954421,-0.5232488958939627,-0.11160588928277487},
{0.8569761749786172,-0.06711028149997039,-0.02841573559551795},
{0.8531579315427361,-0.05162321070270094,-0.027216146575791973},
{0.8316600052717366,-0.01058220412378896,-0.02166038182434359},
{0.8156898712728016,0.009025428059624438,-0.025755122460287147},
{0.7762024131642792,0.10031253866388379,-0.025585135854801315},
{0.7918250429001007,0.09453084234818208,-0.04746822164962318},
{0.7562946147597863,0.032013426790104216,-0.08256615222408109},
{0.7202047370317971,0.07178598901542255,-0.10828469528825102},
{0.6962194118248277,-0.046209460077354644,-0.10098818162746037},
{0.48926932656255884,-0.06688434993571707,-0.2144843649978214},
{0.5388053599573958,-0.07638638600945682,-0.22261574958175764},
{0.5905673571924238,-0.10459017628041334,-0.23608880186339748},
{0.608555813165355,-0.11724341974319112,-0.2462643291715305},
{0.6042276099130164,-0.13236469657928854,-0.26323716896991345},
{0.572492832052158,-0.13063363045127138,-0.283535506221187},
{0.6379796338832795,-0.13168690188652854,-0.39316718397822453},
{0.6614679096488916,-0.1310693556109028,-0.40826909525167165},
{0.6748269202838131,-0.15669645018477973,-0.4117150895388307},
{0.860172568680506,-0.06487355901386249,0.0},
{0.8563575528383998,-0.04929396386170834,0.0},
{0.8333620230557782,-0.007359989671699899,0.0},
{0.8196350667305012,0.011270757462465794,0.0},
{0.796275894715891,0.06658633544382106,0.0},
{0.7794020344599428,0.10121949251467213,0.0},
{0.7928428108038322,0.14941069516990593,-0.026653469394342027},
{0.7932613221299968,0.1448726983221892,-0.05125634087693723},
{0.7554414541385822,0.09904194258110677,-0.07098016643625234},
{0.763089775520853,0.13096499674550963,-0.09541197544877002},
{0.719951908852752,0.11061394212924364,-0.12620752352108963},
{0.6922397887001941,0.06347278331549194,-0.12298100561063384},
{0.44891256986395695,-0.03601456720657136,-0.20463697639015155},
{0.44394315131497547,-0.0529282344524118,-0.2428086521030463},
{0.4980473057660963,-0.10231149507522982,-0.27491890670640196},
{0.796245770507324,0.152632909621995,0.0},
{0.8021242946362772,0.18608369150658702,-0.028945060974625732},
{0.8002447591946078,0.1769528287169777,-0.08745057747031958},
{0.8011344992119291,0.1897588449517744,0.0},
{0.8105246453681341,0.24035460496941857,-0.0673448199809572},
{0.8104278175548826,0.2809674174408409,-0.12183090636212526},
{0.8011990510874301,0.29798114009370785,-0.1851240202908062},
{0.7985922311817835,0.23078478942640282,-0.14959144042130856},
{0.7764315723223075,0.1886044422448991,-0.17154338154999813},
{0.7722367762793375,0.1527071442788211,-0.11968670823090208},
{0.7341135144730685,0.13844548325147799,-0.14710511734993034},
{0.6816392948783466,0.10653103600380857,-0.1325196210804908},
{0.4320666820873925,0.012463891294641677,-0.18465494332883264},
{0.4291790615233167,0.010140023776607497,-0.21793143514957208},
{0.5705100136096871,-0.0032899939213650365,-0.4290956820174613},
{0.573377192746521,-0.09640499846689293,-0.4181261666406666},
{0.7529228551294534,0.17540035611117985,-0.17803837608998532},
{0.6883150346697364,0.1459905216329473,-0.14594748704927998},
{0.43313286389774985,0.04463762190890656,-0.17098715955609828},
{0.4324496898820314,0.07393018714664575,-0.16794891794918693},
{0.4279493482950236,0.07157727128463615,-0.25295728279638724},
{0.6219115962065014,0.07794531380280481,-0.4409925926722863},
{0.6412739312630112,0.07797543801137191,-0.45129399613764615},
{0.5868879002888697,-0.0022743777468167644,-0.4532187178921661},
{0.5924974582699022,-0.09201116747446166,-0.436917217598993},
{0.7687875543984035,0.2055568406160401,-0.2102562171525092},
{0.7561041867270586,0.1884064831600295,-0.21569471266346418},
{0.7042658031060212,0.17613732335648236,-0.17817070743476227},
{0.7857733045718867,0.24602010790921855,-0.2002646626895539},
{0.7494994539987198,0.19970090964351228,-0.30766069382507516},
{0.7419576432110254,0.1813240665529837,-0.2993270466979026},
{0.7080603775208854,0.19669709570353477,-0.21670925297342078},
{0.4397709484284308,0.11934350742615538,-0.17216200369021553},
{0.434186135333007,0.09249853413449385,-0.22353238621387114},
{0.42930063422217685,0.1209336352926621,-0.24013728032189868},
{0.6347154607121148,0.12127038090985871,-0.43023179502627806},
{0.675294921381195,0.10471067311468181,-0.4329440496619096},
{0.6789668472326074,0.1315997568546023,-0.44410076547765703},
{0.6391953608718807,0.09851692066036571,-0.47525457645900687},
{0.579909842547217,0.00430991355428008,-0.4681334287266605},
{0.5818367160309204,-0.10109361635744524,-0.45724783078801706},
{0.6445531665384595,-0.19790206404621913,-0.4517652248288031},
{0.6078328321597444,-0.2925135962387774,-0.46506506291118205},
{0.6029387241321807,-0.344093772357811,-0.44249127204850003},
{0.598875183569396,-0.3645642479437538,-0.37087526963856327},
{0.5742862983264927,-0.36432648186899197,-0.33665309284173495},
{0.5283705492826672,-0.32770727876189504,-0.2987503832767608},
{0.47720673276061476,-0.32604184037397055,-0.26795806279821627},
{0.47456010586507585,-0.36389398430313563,-0.2638611704330893},
{0.4696746047542456,-0.401514817345089,-0.2596222639418603},
{0.45449307950101403,-0.4290903026945029,-0.21740426149964767},
{0.4263785859911672,-0.4576415972285728,-0.20789146677999107},
{0.4212746843682254,-0.456699139846259,-0.2342447699532537},
{0.4550008875882881,-0.473973221730313,-0.24156387677046967},
{0.47188980994851987,-0.4794655104708521,-0.24815785085289166},
{0.4802213053465091,-0.49228013362238227,-0.2393389887948703},
{0.7489808872655287,0.22935711711324014,-0.3180686078850116},
{0.717132067757952,0.16131836447064776,-0.39700694470593934},
{0.7125435052744262,0.14872859701877925,-0.38285179427317284},
{0.6934845640327708,0.20427118242897951,-0.2877927024104746},
{0.4367122653942775,0.15391856780905558,-0.1899223763697101},
{0.6587803998988687,0.17734982275130853,-0.393565253877147},
{0.6589794348483301,0.17236426623345188,-0.4607949563467942},
{0.6150239110905501,0.10871073766655731,-0.4863714852848621},
{0.5867200654125673,0.011485930380802293,-0.5028924619547384},
{0.5673168475015734,-0.09450717332716503,-0.5075466521783568},
{0.5644001785935222,-0.1308240584839992,-0.5101954308030792},
{0.5341608525151025,-0.16556587787861018,-0.5279418172428818},
{0.5267728903640188,-0.2908642958197281,-0.5299289391437194},
{0.5444256765843452,-0.35569266852073994,-0.4825586211719393},
{0.5825995040264232,-0.3593333942989935,-0.43054917508082435},
{0.5617696896668585,-0.35595410361651886,-0.41240471874209916},
{0.5507076499351792,-0.3164924662581967,-0.3494042399823558},
{0.5129049957772315,-0.23849551095499122,-0.30094837463756813},
{0.4846011500992485,-0.2573425068720851,-0.2681936771437947},
{0.44257680328353877,-0.2800260359231187,-0.24036643947992706},
{0.445537582639849,-0.32728231224818044,-0.24880982479545125},
{0.4462820809372932,-0.3745536506775257,-0.2540503612215367},
{0.4360387741598843,-0.4192644313786667,-0.2437801578293356},
{0.40210385320903513,-0.45022351086892204,-0.23731528749791553},
{0.3934291570062992,-0.4394476511186302,-0.24132611069570786},
{0.40227491567911267,-0.4442944211041598,-0.235626180088974},
{0.40391991263979515,-0.4627142987783558,-0.2205178136279768},
{0.5376886125112293,-0.3679478420845952,-0.4683356912698968},
{0.5259541574097484,-0.3496097301193672,-0.4663743901192596},
{0.557813735563242,-0.324190277411685,-0.4080829706773106},
{0.5335508372916186,-0.20689736789727645,-0.3307412169104397},
{0.49188152579116395,-0.1914651661941828,-0.2666820873924808},
{0.45137307218513484,-0.18795139243774778,-0.22113751163278592},
{0.443616088479104,-0.23244269676218549,-0.2335131820309096},
{0.4160072513273479,-0.26177184139604187,-0.1888615738823112},
{0.41752744799539526,-0.3023986401071561,-0.2011059888002496},
{0.420500061862214,-0.342982404234603,-0.21338590724971357},
{0.4188120303178642,-0.38344459566318984,-0.22833827334491683},
{0.40764455585619996,-0.4231515301484155,-0.22730867093067667},
{0.3726413013658101,-0.42937648267589046,-0.23129367337826862},
{0.4988778732308751,-0.17638477221256935,-0.5499249584447302},
{0.4366218927685761,-0.2336347547297697,-0.5946325115520961},
{0.40820400544387486,-0.26406773643469234,-0.5879180406354056},
{0.49472180831320567,-0.33078963081706536,-0.5344292807307273},
{0.4793046687143956,-0.3394137613839922,-0.5214177743589192},
{0.47887647460690597,-0.32475725805150163,-0.5088688897615347},
{0.5648531175866205,-0.2533402905910262,-0.4173547717284302},
{0.5618944899594936,-0.14741173875855984,-0.3787280052932538},
{0.49990317218674857,-0.14908685992780948,-0.2605722523763159},
{0.45909993168259844,-0.13957298934356122,-0.20848749576378317},
{0.42817743158846033,-0.18007606362663192,-0.16294937519163838},
{0.42131987068107607,-0.221143966820336,-0.17311952317681298},
{0.4115800685325745,-0.3396375412190622,-0.1888303738091524},
{0.40533575044244935,-0.3758156398435693,-0.20433143084611372},
{0.3903425014927622,-0.4106575146452067,-0.21566566431948875},
{0.3704605238384697,-0.4443094832084434,-0.2227964948331603},
{0.35038489055767447,-0.4658515199277019,-0.210287417225668},
{0.3677665589008968,-0.4683711948014223,-0.17481723750248793},
{0.359514677482692,-0.42780249277825894,-0.21378612887781942},
{0.33509362711609114,-0.4674997444821594,-0.21861998848824887},
{0.6971242139464328,0.19873693496936476,-0.40964512606443354},
{0.6798651941666622,0.24808684378984064,-0.41341495559368896},
{0.6352157377472472,0.22744315400463702,-0.4573371275491267},
{0.5845371361560434,0.1891380710823736,-0.4667175909240063},
{0.5925265066138776,0.10392314023357022,-0.4864177474623044},
{0.5665045697348532,0.013159975685460248,-0.5111927572795688},
{0.5456414035729463,-0.08994012813547285,-0.5056907857577045},
{0.5489776596717537,-0.1287411846345019,-0.5114445095940224},
{0.5340005486909417,-0.1519486597416849,-0.5108721496312474},
{0.49538346503709046,-0.18054621645319718,-0.5294157517334869},
{0.45673948476844706,-0.179150820077785,-0.5487285970187793},
{0.46503870422868576,-0.17069775198093567,-0.5686450023400055},
{0.4206442277174995,-0.16259971919934157,-0.5816747984098722},
{0.3309676864069888,-0.185358558771793,-0.6110157775542371},
{0.36805166301769265,-0.2293216135817146,-0.6003561111798469},
{0.36172450335400785,-0.23696670737021036,-0.5851035788635642},
{0.3994550745843128,-0.2704529927863279,-0.5770496565302291},
{0.7187361818641507,0.2664615351511859,-0.3629590579729635},
{0.6743610709156146,0.3141556883650624,-0.40272301328154836},
{0.6296363039747818,0.31128958509282023,-0.4477135187765268},
{0.5789006815602188,0.31064514220240247,-0.48440588067585816},
{0.5226641634883834,0.29852875517087424,-0.5083503230283437},
{0.5324340898454522,0.15090937454611966,-0.45316169706880693},
{0.5796882144413305,0.09987358591047735,-0.4724745423540993},
{0.5575415418215464,0.013629052647433816,-0.4752513488652319},
{0.5486290795440486,-0.08217991683566704,-0.46399350177786625},
{0.5330365740167943,-0.14432077978665606,-0.4998499168894603},
{0.48176732276475687,-0.1872596115052959,-0.5254856183800707},
{0.43220546861971954,-0.18139184602225963,-0.5481626922435542},
{0.40469883860417327,-0.1782912042690307,-0.5700113503714422},
{0.3325739522423708,-0.22117624275808648,-0.5735348069092024},
{0.2630849341301904,-0.2011188991753498,-0.6160830997810616},
{0.33336686444644076,-0.21320623786290258,-0.6097139813983012},
{0.3315916878701647,-0.22615426822380133,-0.58402018321974},
{0.3654308568723541,-0.231841288455435,-0.5653001393244647},
{0.4032980629058027,-0.2591617938966202,-0.5630505064632565},
{0.5654652845392879,-0.16501503520766875,-0.4463826742766156},
{0.5425396859551257,-0.08553553849712474,-0.412395035960774},
{0.4899718661409275,-0.12360393120921799,-0.3139932328117183},
{0.45964754675976477,-0.11604598245264851,-0.24074621968079096},
{0.42775031334556235,-0.1382572069479335,-0.17577690871826873},
{0.4076908180336423,-0.26527808410033515,-0.15880191719070239},
{0.40922392507678984,-0.30254926114999164,-0.17283226733083373},
{0.3816301500293173,-0.33336632651414494,-0.19054207437451923},
{0.37778608584323575,-0.3652700151158975,-0.20542020581289638},
{0.3683701189368306,-0.39739102836517,-0.2156871816113224},
{0.35417300978498845,-0.4277228787984744,-0.2238347041641339},
{0.34168329774014644,-0.44764358757806744,-0.21010344438049028},
{0.3565280773761815,-0.4322780894796581,-0.1830540568164091},
{0.3621182697945637,-0.4257798673458959,-0.1594087048204113},
{0.3947191186517265,-0.44083874403567563,-0.16592629251682384},
{0.3706455725482391,-0.43520659289821784,-0.17371232456683003},
{0.48440641860815403,-0.09374115773788709,-0.3336417478496157},
{0.4602780034104908,-0.13513504790287093,-0.2915786699086053},
{0.4192660451755542,-0.11035573462723981,-0.20846490260735784},
{0.4061082212192773,-0.2256346256260187,-0.1415654905673572},
{0.38129878373507914,-0.26596340984523686,-0.1672259369435763},
{0.38278347687160097,-0.30037493881020133,-0.1783482250923899},
{0.3389011119060555,-0.3591106903285152,-0.20769028010134646},
{0.3249568309332587,-0.39194069834370643,-0.20654663604038798},
{0.3262715374642947,-0.4146715654367741,-0.19483154650155735},
{0.36068844575221765,-0.39881870067833264,-0.18709285249358518},
{0.3678924350581235,-0.40180422492025153,-0.1563188217130992},
{0.34492272602570245,-0.4223661489964873,-0.14188824994486193},
{0.31611860331258707,-0.43982850718408584,-0.13589568416919046},
{0.340200756332808,-0.4397176931311425,-0.1299214080915776},
{0.3737881730205436,-0.44123251047623147,-0.13626362985954588},
{0.4193026245716714,-0.4193569557335514,-0.14751394589476968},
{0.3986460244113676,-0.4534887599046784,-0.1562499663792315},
{0.34077204043099135,-0.4862520643151853,-0.1707956556587788},
{0.3266362555608751,-0.49531514763551854,-0.21220030446967947},
{0.5051985777070098,0.014673717165957514,-0.385331662157001},
{0.4455042308375068,-0.030369505694013334,-0.36375842536458364},
{0.42189760996680964,-0.11633001070485267,-0.3439065719188583},
{0.45207023244054506,-0.15073508448226705,-0.32395681479528987},
{0.4094875119017521,-0.12675298686907263,-0.23926798173181923},
{0.40002743454708795,-0.1871337353480691,-0.127138146392895},
{0.3753234317928746,-0.23194349559164482,-0.16386923941752693},
{0.34183714637675705,-0.28713104568658987,-0.19750184241811328},
{0.34280972796763803,-0.3234802067811745,-0.20229697090324214},
{0.3082626400641215,-0.34950967471234073,-0.19903279773207747},
{0.29034949461260806,-0.3589364002646627,-0.20282737214694158},
{0.3380135236179174,-0.3586125650225662,-0.1935684814709221},
{0.36374605292177925,-0.35459528663722384,-0.17838803208228213},
{0.38118689381754417,-0.3581510191127345,-0.15493310811901215},
{0.3538158227405499,-0.37296890213397743,-0.14508894710511736},
{0.32549045977073326,-0.3858792772341673,-0.1420313399355557},
{0.29997633097898296,-0.4034524494747091,-0.13783869562176904},
{0.3125467328682012,-0.40291559304345953,-0.12448829190358102},
{0.3670780055622199,-0.4397833208712351,-0.11511428371625147},
{0.40557351651721113,-0.42996498060754074,-0.13611623641048537},
{0.42317035777877,-0.37996094611532194,-0.1324830416843736},
{0.4207130830513672,-0.4394605614937304,-0.1512052373088323},
{0.3825941247034648,-0.4422728715363884,-0.15627686299402357},
{0.36321887927185487,-0.488248868997348,-0.1626556641581091},
{0.5191450104089899,0.07404530465795578,-0.4138399221074036},
{0.4859696498598687,0.06875635432524466,-0.40646702206060353},
{0.42077440733309307,0.0516651694217766,-0.44031587384411797},
{0.3949063190906793,-0.011560165037628344,-0.4216001334072094},
{0.37925786860465743,-0.06724368870933903,-0.40688015406380956},
{0.40061808420792155,-0.08956465139297566,-0.37276341199696605},
{0.4070248578513908,-0.18445913597314642,-0.303025869164107},
{0.4089463520121358,-0.1604834935475021,-0.2708973248626928},
{0.3993378053438194,-0.16800055944958767,-0.14457253210110976},
{0.3651597389952501,-0.20267675110410605,-0.18167264668068878},
{0.3380942134622936,-0.2508948503741319,-0.19760082196054807},
{0.30840788178399864,-0.3268476629531407,-0.2051318741023255},
{0.32804778990516253,-0.2764111308950655,-0.19538561676627378},
{0.3583398333485748,-0.2729877297643319,-0.1655153122428011},
{0.35765450760367296,-0.3049860944501525,-0.14132342103422862},
{0.32587884688833063,-0.33790109576808663,-0.14318789437161442},
{0.29209024352195034,-0.3731335094165048,-0.13323507103395968},
{0.55075929143558,0.09713658638923708,-0.43403174876410056},
{0.47423519475838777,0.12370829007461123,-0.4502019935770884},
{0.41842579492945015,0.11297438904339502,-0.48132352862068783},
{0.36319843784461286,0.10713567190433415,-0.5134553005158771},
{0.30401512665615904,0.0944501525038059,-0.5370199626674986},
{0.3551746397198449,0.043942613382679685,-0.49361958503902703},
{0.34817291295717523,-0.0007444982974442626,-0.4789329574979693},
{0.3488410248686101,-0.05612893161266721,-0.4381587653377946},
{0.35523273640779574,-0.1800222703970478,-0.3544059344690877},
{0.3758753503284077,-0.1960967632613759,-0.3249692033760631},
{0.3963587362894506,-0.18758775020575907,-0.2332119399452385},
{0.4014475758081088,-0.16859120911042133,-0.1867830034911806},
{0.3587615722685143,-0.1855963248465548,-0.213303065676154},
{0.3319574818313367,-0.2160852515102449,-0.20596566916087944},
{0.3106263145720479,-0.2955529137102804,-0.20200218400512113},
{0.2828496425439894,-0.28408096956917,-0.20083271919396228},
{0.3176355723868594,-0.2155882020688876,-0.1619778694653491},
{0.3308913000209794,-0.24799754702873095,-0.14213462293635723},
{0.3159152649047591,-0.2884909385304765,-0.14654459189766378},
{0.2788259089710969,-0.323648041657477,-0.14403137221149345},
{0.296391550159497,-0.3252801282430593,-0.12115418753395699},
{0.46979187399473904,0.26934377639230334,-0.5260655093949875},
{0.4169948950225125,0.23715175607997982,-0.5392534575598316},
{0.3600644442890418,0.2182993808399275,-0.55523865366305},
{0.3043701619714143,0.19855403798877874,-0.5753605491212876},
{0.24963770259875093,0.17639875845226122,-0.5959999354481246},
{0.24805187819061092,0.08343652667875223,-0.5680177732830546},
{0.2900213559121449,0.033543306239476725,-0.5355804558438275},
{0.3026767511041061,-0.02380027649720004,-0.5077682802842435},
{0.3244049123977256,-0.06838087758274743,-0.4728209707526211},
{0.34322285997084406,-0.15240697805774164,-0.38278939412685525},
{0.38464472261521165,-0.17227927293070894,-0.2688122992840121},
{0.38261564199529846,-0.2097882160551273,-0.26472401383561867},
{0.3430485699069915,-0.18296583591989113,-0.267331909605857},
{0.3622721184311743,-0.19783966389990157,-0.24467850476339048},
{0.31934619708763456,-0.19073465413643037,-0.22561310833418508},
{0.30018935216813614,-0.26442815107290596,-0.207569783267078},
{0.29025589439313165,-0.2349752820110061,-0.2184037397053207},
{0.25679542972721453,-0.28361081674260474,-0.22385191799760082},
{0.2837662791761029,-0.21665545974383663,-0.17967153854015933},
{0.19234145790410817,-0.17978342845769432,-0.18546291763718617},
{0.22257325293038616,-0.19592354906211504,-0.18520148254140736},
{0.24983888927739556,-0.21572160927825623,-0.16539804300230773},
{0.27116790480750097,-0.23938417510772095,-0.14681678563935943},
{0.28311860869191,-0.2609574119001382,-0.12437747785063773},
{0.26881498894549133,-0.22185296158625475,-0.6041388510842025},
{0.28698203844064185,-0.2344438049027149,-0.5791153165462595},
{0.2089764762207029,-0.23570149061039175,-0.5819555990683013},
{0.2365325960074665,-0.2533973114143854,-0.5490190804585335},
{0.28745649472557383,-0.23366272720915346,-0.5718994927298451},
{0.26645346616674825,-0.21529449103535828,-0.5766160830997811},
{0.21690882585517787,-0.19681974426698653,-0.57778554791094},
{0.19889454913204624,-0.17787914813041628,-0.6085757166603012},
{0.14963393707268002,-0.17155306433132325,-0.5887206356208008},
{0.17224430733147927,-0.20897809001759038,-0.5853531794488346},
{0.21939192133278107,-0.008816710328837993,-0.5532074213139535},
{0.2487296728833709,-0.05083998127995609,-0.5252521557636756},
{0.20513456376380468,-0.10729274813471974,-0.5162127414643594},
{0.2526974614974959,-0.12238820422061678,-0.4866888653394084},
{0.28937798888631877,-0.09704406203435234,-0.4823864828372701},
{0.1645120685110572,-0.05934684260638954,-0.5542908169577777},
{0.1331258707779039,-0.13288111158329613,-0.5421324712071739},
{0.16765359311877007,-0.15850820615717304,-0.5229153778705412},
{0.2085859373739221,-0.19787839502520213,-0.4983006718774375},
{0.22131233962893432,-0.1549223494730953,-0.4854935797780492},
{0.2738489593699737,-0.14843488598524987,-0.46243887744288503},
{0.3015664588454897,-0.14600343200804747,-0.4387375804881198},
{0.3235033378698957,-0.12785144461718045,-0.4120464558330689},
{0.1809243828571736,-0.1928723970801035,-0.5542327202698268},
{0.0949983055132681,-0.13643684405880674,-0.5838103896243619},
{0.09303915609181428,-0.16778861412502621,-0.5794649725385563},
{0.1344276669338397,-0.18410517652248287,-0.5812971699381917},
{0.13021135359903602,-0.21480604851073443,-0.5530266760625507},
{0.15999236136139905,-0.2395337202859648,-0.5517614593027322},
{0.05009386918562429,-0.07595711603737552,-0.5977966293162343},
{0.01673668752050866,-0.10284835150647938,-0.6043841482111062},
{0.05715907195920321,-0.1397386724906803,-0.5829055875027569},
{0.02861100501890831,-0.1623587255308047,-0.5888110082465021},
{0.0521767430351216,-0.17097102158722302,-0.5667622393045612},
{0.05986702313646804,-0.1988628111265916,-0.5162902037149605},
{0.09516183693120385,-0.20396456102034996,-0.5357407596679883},
{0.15850659236028553,-0.20754073492310257,-0.5037875812950182},
{0.18714395606169007,-0.2337401894597546,-0.4959563629321614},
{0.21706590208556353,-0.24032986008380983,-0.47519002458350595},
{0.18809394449614572,-0.2582225641080813,-0.5287390329053185},
{0.21355965938127028,-0.24528851998687445,-0.4996745509610161},
{0.23738898422244578,-0.21663824591036973,-0.527361926227965},
{0.08635050592532424,-0.0828835322786274,-0.5747806581063707},
{0.01708096418984706,-0.023506565463670723,-0.616518824940693},
{-0.04520514048101907,-0.036718182649531715,-0.6309935071571893},
{-0.09884236969934965,-0.007850583925507115,-0.648519341355697},
{-0.05705901655217676,-0.1540121680285319,-0.6260294679311662},
{0.07451061609385842,0.005223322592618515,-0.6066746639267981},
{0.014763551859362975,0.13281871143697857,-0.6616405859158566},
{-0.040230342609079234,0.10386611941021105,-0.6661108032942974},
{-0.10088220896517966,0.10362727747085754,-0.6655610364879477},
{-0.15915856630284514,0.12661312447215395,-0.6644227717499476},
{-0.1445601596583054,0.04081292328547531,-0.6608595082222951},
{-0.0813337493343088,-0.1465661091894974,-0.6352915862009607},
{-0.09736843520874464,-0.2574942037795123,-0.5748258444192215},
{-0.0665072593963324,-0.22497512063131733,-0.5812121766354487},
{-0.01956513553204195,-0.18399005901117282,-0.5888465117780276},
{-0.010287955157963827,-0.19474762906340606,-0.5678187383335934},
{0.03386767941386896,-0.17944237938213095,-0.5265066138775775},
{0.018622678149728067,-0.18127565264635792,-0.4837216307955481},
{0.040152880358478076,-0.2033653044427828,-0.47802277605340593},
{0.09404078602667067,-0.19881654894914924,-0.5077134111900676},
{0.12860723949283742,-0.1846667778393411,-0.5078478942640279},
{0.0865065062911182,-0.19039898438382544,-0.4460878873784946},
{0.11195285561359247,-0.16825338762863304,-0.449335922580784},
{0.14049661909552064,-0.16733997859029462,-0.4453821202063508},
{0.15896813827011733,-0.19921677057725515,-0.4393960096182295},
{0.24115128269955943,-0.22031447522014877,-0.4548809286863156},
{0.264058591585663,-0.19016659763202204,-0.4410399307143203},
{0.2230261919234845,-0.2137753702319026,-0.4738860766983867},
{-0.03298439458409766,-0.212557491514118,-0.5540756440394412},
{0.006338456241897386,-0.16966814956669554,-0.4384029866001065},
{0.046610219637756384,-0.22106220111136812,-0.4450798022560881},
{0.0731173714476296,-0.2242284706046897,-0.48727843913565044},
{0.04377101298030629,-0.22789394126855192,-0.41656078365976856},
{0.058672813439700475,-0.20098549196598114,-0.43227593775047474},
{0.050805015680726415,-0.20209255663082243,-0.38896162928933764},
{0.061003136145284756,-0.1700522332259262,-0.3956158517888939},
{0.09453138028047789,-0.16747984098721333,-0.3892886921252091},
{0.18194537835468028,-0.22198421706644,-0.43288272538018363},
{0.21297008558502828,-0.22822207996901508,-0.4273118985244518},
{0.2885732421717403,-0.16517318730264607,-0.4251365003200697},
{0.24493187087473173,-0.18161670172192126,-0.4620225178459039},
{0.3065573946863048,-0.15468027993996675,-0.39287024535092013},
{0.32407892542644584,-0.17196512046993764,-0.36340554177851175},
{0.34151115940547727,-0.17814488668456188,-0.33094347945367597},
{0.36873698876259436,-0.17117328413045932,-0.3037079673152337},
{-0.02068833816575847,-0.23189077822665238,-0.48941187862095675},
{-0.012106166317907242,-0.20213989467285648,-0.4560590004142079},
{0.0016315486532864885,-0.17622769598218369,-0.41386574285760397},
{0.018484967481992708,-0.2508701054885232,-0.4203295373244324},
{0.05034777322926136,-0.2366073685965884,-0.4603893553957299},
{0.032307675755929355,-0.25843128183886777,-0.40482848028747104},
{0.06231461508254571,-0.3254920735676208,-0.334321694271559},
{0.053118124552843766,-0.2897593828840702,-0.3382227792809997},
{0.03932984394584097,-0.2593801944087317,-0.35013260031092486},
{0.03861224226318875,-0.23082889987466176,-0.37189949272984507},
{0.055382819518335416,-0.22435327089732485,-0.31695616389721193},
{0.05843719909412201,-0.19888755601220026,-0.34495553989574873},
{0.08008467054336542,-0.20391507124913258,-0.3424907341162041},
{0.10962360877259988,-0.20714696848254677,-0.3315491912187932},
{0.12471476140013019,-0.1687784095493741,-0.3821955168722465},
{0.14016417693669073,-0.20049920117054068,-0.3755681909874823},
{0.2370307213134155,-0.21719661963345294,-0.4066983329478152},
{-0.15124343050183706,-0.19458409764547033,-0.5950069124300016},
{-0.17255523219847552,-0.2631328101045202,-0.5657627610988881},
{-0.13984679688214444,-0.30280208932903707,-0.5611053432814946},
{-0.10473380420340297,-0.30012211063115596,-0.5691936932817636},
{-0.04994432400738044,-0.3023803504090975,-0.5416945943183591},
{-0.03135876318606541,-0.2626615814133633,-0.5231897233414202},
{0.00033513182030908884,-0.2769608977014153,-0.43962839637003287},
{-0.17955373136737013,-0.1321452202025853,-0.5927131691205345},
{-0.1339618175656412,-0.10343362184435465,-0.6454692652382771},
{-0.22427742244361126,-0.07269617045998589,-0.6021732464751987},
{-0.3047843698392121,-0.10078376735504067,-0.5786354809383691},
{-0.29354050899153833,-0.1334782164316799,-0.5716337541756995},
{-0.2622446838840864,-0.16344965222677071,-0.5650032006971603},
{-0.2271198566948364,-0.19414944835043063,-0.5680866286169223},
{-0.16626787952468305,-0.2018300456704519,-0.5769797253317698},
{-0.2622167114047026,-0.244419221396795,-0.5479410641376676},
{-0.23143084611370815,-0.27852197722394656,-0.5445445596217261},
{-0.20026412475725808,-0.31257093982151407,-0.5398258175226066},
{-0.11365164580385914,-0.338855387660909,-0.55784762529788},
{-0.09309617691517347,-0.3314383771658499,-0.5571752099280785},
{-0.055478571466995176,-0.3479787193983765,-0.538218475822633},
{-0.026066585259579243,-0.3361969262548616,-0.490963275362163},
{-0.007637024804058174,-0.30401351285927153,-0.47518894871891426},
{0.015143332060226892,-0.30651812562870834,-0.44191460862735815},
{0.033208174419167596,-0.26943092142422953,-0.4469184548432734},
{0.025253231628267255,-0.28907513300376014,-0.3896437274404643},
{0.0290047714594641,-0.3181848012609133,-0.3701727300601946},
{0.04728801433051635,-0.36683217050302047,-0.33869185624297327},
{0.03556646960413561,-0.35910746273474015,-0.3224495285023427},
{0.04084358542633823,-0.33656594780980864,-0.3187560853590967},
{0.009800588497931643,-0.2916851805031819,-0.306085628062852},
{0.01572214721055207,-0.20427225829357118,-0.28914291247303614},
{0.05465123159599132,-0.2352560826694352,-0.2762099442164209},
{-0.10373217426854657,-0.36235764966621303,-0.546652178356832},
{-0.08368021000876831,-0.3591580283705492,-0.5491600187200439},
{-0.07845473568696645,-0.384111631710033,-0.5403960257561984},
{-0.04868879002888698,-0.39183203601994654,-0.5202235646621516},
{-0.098502396488378,-0.38733061856834694,-0.5377999644964685},
{-0.09002565937051164,-0.4040958165005352,-0.5227292532961801},
{-0.07466338886587737,-0.40223672248610787,-0.5277374029704621},
{-0.04460373217426856,-0.43305163612107783,-0.49326239799458843},
{-0.019579121771733817,-0.4139206119517797,-0.46207200761712136},
{-0.027437236749382733,-0.3765128000989795,-0.48081141707504693},
{-0.018540912440760216,-0.37544984588239727,-0.42900853698553504},
{-0.005435805849475797,-0.33930725078941565,-0.43862353884140143},
{-0.002385729732055934,-0.31458065487877696,-0.38200508883951867},
{-0.07733153305324993,-0.4208007660155893,-0.5101502444902285},
{-0.05983582306330926,-0.46060560417865803,-0.4688456510863543},
{-0.022842219078306813,-0.45408694061765387,-0.4505634840798937},
{-0.0328283942183037,-0.4535468565926293,-0.41495451782438664},
{-0.020696945082491928,-0.41460055837372306,-0.418490884737247},
{-0.03798070974787114,-0.3602349688268235,-0.39812907147506416},
{-0.02520804531541661,-0.32702625647536004,-0.40115440270687536},
{-0.02514349343991566,-0.3004943597798781,-0.3723793283377354},
{-0.004628907405713927,-0.33981828647046486,-0.3545640865640651},
{0.018401050043841474,-0.3506156635125903,-0.362513650032007},
{0.03349973372351355,-0.3579455289757231,-0.3599186646368688},
{0.04997122062217249,-0.48664905834951616,-0.3258159088097172},
{0.05268455112239573,-0.4860982156785747,-0.3187410232548132},
{0.048676955518378445,-0.48436069436300744,-0.3134660591617939},
{0.04028413583866334,-0.4820787855640489,-0.30789308057687864},
{0.008277164236109236,-0.3541143751647418,-0.3414955593688978},
{0.005297019317148735,-0.33011936717644713,-0.324461395288789},
{-0.015877071711754367,-0.2787661984862585,-0.3188120303178642},
{-0.009174435305572454,-0.24086779237965109,-0.298630962307084},
{-0.07227281774315886,-0.36308170653641536,-0.26638407290058475},
{-0.03593441529449105,-0.35036068360436157,-0.2554134816591984},
{-0.029387779254103092,-0.30407376127640573,-0.2536049532805801},
{-0.038899498109167985,-0.25088516759280677,-0.2641150744767264},
{-0.018318208470281944,-0.24743594571187272,-0.2514661344723153},
{0.08592446354701797,-0.24294636277078166,-0.2822100410442342},
{-0.35413858211805466,-0.14138474531595452,-0.5376794676622001},
{-0.4000220552241295,-0.1105891972436349,-0.5293759447435946},
{-0.3251128312990527,-0.1776887200976885,-0.5390641053916955},
{-0.2940902757978881,-0.21158706165242042,-0.5438355648558072},
{-0.33831476570358854,-0.2361167743427812,-0.5034067252295626},
{-0.31742793052066465,-0.27145569858577595,-0.5119781384314971},
{-0.2888497393718027,-0.3007095326982146,-0.5115972823660414},
{-0.26792309719898655,-0.33339107139975366,-0.4979499400205491},
{-0.16850567787538262,-0.34601634238314766,-0.5371167904807501},
{-0.1403416945943184,-0.381621005180288,-0.529991339290037},
{-0.11162794450690437,-0.4187663060727177,-0.5204161444240628},
{-0.09465510470852141,-0.44911537033948906,-0.4909385304765542},
{-0.08364578234183447,-0.4727176877518196,-0.453910498824618},
{-0.04938595028429723,-0.48535586911031375,-0.4465526608821014},
{-0.06870847835091476,-0.45447317600606785,-0.4104563279665621},
{-0.09566534156011126,-0.383047601628859,-0.3886410216410163},
{-0.06236087725998807,-0.38031705729516885,-0.39053131572860245},
{-0.07713249810378868,-0.34257680328353873,-0.37396084928750867},
{-0.05664911214274573,-0.31290553370952734,-0.3748064788565711},
{-0.07689258029984347,-0.33057553376332055,-0.3494053158469475},
{-0.062255442530003174,-0.2991839567072088,-0.34826597524435576},
{-0.008914076074385286,-0.31507878018472596,-0.35188841132455073},
{0.03481981957750797,-0.4861003674077581,-0.32031931661081137},
{0.040878013093272075,-0.4871310456865899,-0.33028182272979123},
{-0.35252801282430596,-0.01872004389527532,-0.5815758188674374},
{-0.4005330909051787,-0.048891590504419095,-0.550003496559923},
{-0.45869971005449256,-0.11522940122756148,-0.46633996245232573},
{-0.4274727402809083,-0.16459114455854584,-0.4731232887028839},
{-0.39381539239471325,-0.18358768565388361,-0.47998300133945143},
{-0.36999037101190446,-0.2117591999870896,-0.49796715385401596},
{-0.38186684023948747,-0.24114428957971348,-0.4691770173805925},
{-0.35645491858394707,-0.27084353163310865,-0.4680764079033013},
{-0.3341092110147017,-0.3034454563548632,-0.4666906943092143},
{-0.31087483929272663,-0.33497474407871025,-0.46367504585872826},
{-0.28972979660779896,-0.366095203257718,-0.4524860541052303},
{-0.2481271887120287,-0.3679446144908202,-0.48279638724670115},
{-0.22129727752465075,-0.3963711087322549,-0.4719914791524339},
{-0.18664905834951617,-0.4149007245948025,-0.46631629343130876},
{-0.15278837205549312,-0.4368408312129835,-0.4638923705062481},
{-0.12000032275937751,-0.45937911854414004,-0.46157388231117236},
{-0.13260515231552958,-0.45168991430738525,-0.42430916044906586},
{-0.09980742023808885,-0.4561988628111266,-0.4072803756919154},
{-0.12729576055557648,-0.38303899471212555,-0.3943377246539751},
{-0.11806806995271577,-0.396347439711238,-0.3605157694852526},
{-0.09441411103998452,-0.3749527964410399,-0.3666094665325422},
{-0.11764095170981782,-0.3742696224253215,-0.3379591924560375},
{-0.09026988063282357,-0.35878685508641883,-0.34119324141863505},
{-0.09992468947858224,-0.3378537577260526,-0.31120889524844403},
{-0.04150309042103961,-0.27846388053599574,-0.336835989822321},
{-0.4890347880815721,-0.1175511170164123,-0.4513972791384476},
{-0.46365299063459875,-0.17368542795203795,-0.43569180782906664},
{-0.506346525226335,-0.17868819830336152,-0.40179454213892646},
{-0.48851191789001436,-0.2090749178308418,-0.40901251768452423},
{-0.42844424600719755,-0.18755224667423356,-0.44240089942279864},
{-0.5337929068247471,-0.12283683975534838,-0.4151438699925228},
{-0.5402491702394338,-0.1706149104073761,-0.386876603710657},
{-0.521344077634389,-0.20075525694336108,-0.3856856216076645},
{-0.5008090501729453,-0.22972613866818722,-0.38765445381044344},
{-0.4662092449044363,-0.23264280757623845,-0.4171955437688613},
{-0.40770480427333416,-0.2142304609541843,-0.4606841422938509},
{-0.5510185748021754,-0.1371404595017671,-0.3866625066569122},
{-0.5563473321247788,-0.17307326099937062,-0.3559896071480444},
{-0.5413777521961086,-0.2030586830341533,-0.3561144074406795},
{-0.5226480255195081,-0.22945717252026657,-0.35716337541757},
{-0.49982570993614744,-0.2519330597051055,-0.35910746273474026},
{-0.47822019720597964,-0.2566883812003421,-0.39207410555307515},
{-0.43855737316901294,-0.24793622274700505,-0.42659322097720787},
{-0.5606884457522177,-0.1432051082050813,-0.3543715068021539},
{-0.611541337407274,-0.1503822008961952,-0.3064320564613738},
{-0.5817269778425688,-0.18461728806812372,-0.31537464294743867},
{-0.5493305432578256,-0.21609708602075342,-0.32191805139405155},
{-0.5149609730119368,-0.24566292086477998,-0.32630435133434105},
{-0.47498184478501543,-0.27201729990263424,-0.35874812396111827},
{-0.45088032620214424,-0.27608084046541903,-0.39380947513945896},
{-0.4094186565678844,-0.26205479378365437,-0.4356939595582501},
{-0.38171299160287686,-0.2802110846328881,-0.4419199879503166},
{-0.35563618562967664,-0.3009881816274604,-0.4402846737709592},
{-0.3305588578621495,-0.3227443154004637,-0.4327955803482574},
{-0.30538039882300416,-0.34419275190024584,-0.4273710710769943},
{-0.265664857421045,-0.3946518771147463,-0.44105499281860383},
{-0.2343206184069673,-0.4166769770356703,-0.43891617401033906},
{-0.19960892322092344,-0.429147323517862,-0.4455166032803112},
{-0.16494564194150524,-0.4411066343190046,-0.4409990478598364},
{-0.18979381055100406,-0.38088403793498554,-0.41054777645685514},
{-0.1581106741905464,-0.3843257287637778,-0.40518997079027635},
{-0.15135316869018867,-0.40457457624383397,-0.36319359645395033},
{-0.17401518044938866,-0.39615055649096004,-0.3504263113444542},
{-0.14579202461578186,-0.38716385955663624,-0.3424089684072363},
{-0.13413395590031038,-0.36548411216964233,-0.3207195382389173},
{-0.16501126968159788,-0.3818092814838324,-0.31002221660381823},
{-0.12936357230079024,-0.3601220030446968,-0.3067365261408199},
{-0.06680742561741182,-0.3051162740657461,-0.3093315115359581},
{-0.6665395353340829,-0.11464951021264462,-0.2707520831428157},
{-0.6345659155338709,-0.09215425746515542,-0.32180185801814987},
{-0.6531643867302862,-0.03034798840217968,-0.34492326395799827},
{-0.6951575334728372,-0.020345675293307563,-0.2958444730146264},
{-0.6854769038768781,-0.07275641887712012,-0.2706843036735397},
{-0.7033922010575749,-0.1283043836102788,-0.2010952301543328},
{-0.6728656191331759,-0.1469652549530116,-0.2063120975594012},
{-0.6358322081582812,-0.1418107876942608,-0.27909110959294664},
{-0.6124461395288789,-0.17799964496468473,-0.2764799862289332},
{-0.5860960639493914,-0.20794633587416686,-0.2813751701210886},
{-0.5535048978735537,-0.2298208147522553,-0.29509244366504034},
{-0.5229557227927294,-0.2584377370264178,-0.294344717773821},
{-0.4817210605873145,-0.27732884339177066,-0.32973635938180823},
{-0.44912021173015165,-0.2902144736063519,-0.35609073841966254},
{-0.4194392593748151,-0.2886254216044368,-0.39284334873612814},
{-0.3879895856307526,-0.3012506925878309,-0.39414406902747223},
{-0.3581709226076806,-0.3167087150411249,-0.39919417742082985},
{-0.32787027224753496,-0.33121997665373837,-0.4013534376563366},
{-0.2971371243215329,-0.3452944372421287,-0.4001204968342685},
{-0.28047520939014614,-0.3671161987552247,-0.4219325755660393},
{-0.2547566663259762,-0.38692501761728265,-0.4145715100297477},
{-0.22294980553747507,-0.3836909686546851,-0.41187969682135805},
{-0.21007600983340238,-0.3952812579008806,-0.38470873655841675},
{-0.1833020436047919,-0.4094643808130309,-0.3710678494004745},
{-0.20354873935566473,-0.39484338101206584,-0.35957223623834705},
{-0.21026105854317176,-0.37253532870352934,-0.34942037795123104},
{-0.17415827044008242,-0.3715767333523403,-0.3476430496457716},
{-0.7225619563521736,-0.09216394024648056,-0.19746203542822102},
{-0.7113245506920499,-0.1393137059769657,-0.16990053631849897},
{-0.679669386810976,-0.16036514844241703,-0.17481508577330457},
{-0.6485919622156356,-0.18326922973474558,-0.17624275808646722},
{-0.6441464897228035,-0.16883112691436655,-0.21171508953883064},
{-0.618368774106091,-0.19443778006100151,-0.2182509669333018},
{-0.5972441728484054,-0.2241176565517464,-0.22738398145209446},
{-0.5732007509534851,-0.2508701054885232,-0.23359494773987746},
{-0.5491745428920316,-0.2805456785209014,-0.23792637858599117},
{-0.4912392346299295,-0.28405730054815304,-0.28753234317928744},
{-0.44719871756940677,-0.3063276975959806,-0.32876808124929396},
{-0.42208265867657896,-0.3054401093078425,-0.3521982603269553},
{-0.39372286803982853,-0.31715519884667315,-0.3477721533967735},
{-0.36517910455790037,-0.3292823445241182,-0.34454563548631767},
{-0.33723782524731444,-0.34426160723411353,-0.34448646293377516},
{-0.3086155236501934,-0.3536614361716434,-0.34776677407381507},
{-0.26770792428065004,-0.3624447946981393,-0.3997815994878885},
{-0.2379645717789959,-0.3779071206098001,-0.39554484472584284},
{-0.2503273318020194,-0.35731722405418054,-0.36839002243177676},
{-0.22718225684115398,-0.3758414605937697,-0.37129485682931945},
{-0.24251978246017958,-0.37780168587981516,-0.3161654034223253},
{-0.2424208029177448,-0.401111368123208,-0.29768958078936186},
{-0.20367569137748326,-0.3909057166065079,-0.3028311376730125},
{-0.7284835150647939,-0.10904425568997884,-0.16291387166011287},
{-0.714516640935572,-0.16688703959719628,-0.11161557206410001},
{-0.6839696175839309,-0.18728973571386304,-0.11131863343679564},
{-0.6540659612581161,-0.2087618412346622,-0.11005126494779369},
{-0.6248594651877115,-0.23140018397284517,-0.10765854209589182},
{-0.619615701167851,-0.2092050974464354,-0.17570912924899273},
{-0.5972495521713638,-0.24179088419931466,-0.1774982920649607},
{-0.5732491648601108,-0.2728317293985379,-0.1800125876157227},
{-0.5451023954125134,-0.29968638547152454,-0.17682157323679243},
{-0.517332178572005,-0.3253608180874355,-0.16782411765655175},
{-0.5290235990898186,-0.30774138366945136,-0.22819087989585632},
{-0.4609547222386591,-0.31260644335303955,-0.2856334421749679},
{-0.40880756547980873,-0.3279482724304319,-0.32101647686622165},
{-0.7383362829954223,-0.13876501503520766,-0.10246534371184042},
{-0.7256077290112267,-0.17818146608067909,-0.021326863800922018},
{-0.6978095396913344,-0.21147947519325216,-0.03171541229820815},
{-0.6679736628347955,-0.22746789889024566,-0.03104514865758996},
{-0.6384347246055612,-0.24378768888147737,-0.03329047806043132},
{-0.6091948767328145,-0.26051200395918167,-0.037648805521337085},
{-0.5803003813939979,-0.2781421970230827,-0.03918191256448464},
{-0.5966449162708382,-0.25529190896033827,-0.10728736881176136},
{-0.5697300117807174,-0.28091039661748174,-0.10954991204806963},
{-0.5441394966029576,-0.3090872902736462,-0.10914969041996375},
{-0.5163972522418329,-0.33154703948960984,-0.10331742846845296},
{-0.4827151594700291,-0.33931263011237406,-0.0940983447823257},
{-0.4832789125160708,-0.34076827490492045,-0.16303759608815635},
{-0.5058548551079362,-0.32116171858609877,-0.20365578788253713},
{-0.4292812686595265,-0.33976556910547234,-0.28623592634631007},
{-0.3687488232731029,-0.34601311478937263,-0.3119652280563968},
{-0.7153773326089179,-0.23376816193913832,0.0},
{-0.7188921822299447,-0.19395794445311113,0.0},
{-0.6820707165796114,-0.23287196673426683,0.0},
{-0.6502520212806017,-0.2435402400253904,0.0},
{-0.6204193720178379,-0.2601300720291344,-0.0031587384411797936},
{-0.591393621198836,-0.2776645131443756,-0.007456817484951345},
{-0.5621752906179228,-0.2947718360167189,-0.012294980553747507},
{-0.5524473229799298,-0.2979208916765736,-0.036913990005217945},
{-0.5270440082411227,-0.3216383266002141,-0.03622758839572452},
{-0.4995954749135274,-0.3413793659929961,-0.036197464187157406},
{-0.46762508270709047,-0.351772217948649,-0.03356052007294362},
{-0.43507049602736997,-0.3568664367902656,-0.026772890364018788},
{-0.44778721550105705,-0.34524817506468636,-0.0848383782417145},
{-0.4484703895167754,-0.35200352883586067,-0.15456301069947337},
{-0.47480970645034615,-0.3395977342291699,-0.20322544204586412},
{-0.39491707773659607,-0.36233720823897103,-0.2875904398672383},
{-0.35818060538900576,-0.37864623958428595,-0.2898293140825296},
{-0.3279262172063024,-0.3619262279649483,-0.30562300628842853},
{-0.762232311441282,-0.10676127102642859,-0.021870175419721673},
{-0.7371721975072218,-0.1662727209153456,0.0},
{-0.762232311441282,-0.10676127102642859,0.021870175419721673},
{-0.7709554215506437,-0.055841675766687984,0.06881445101319549},
{-0.7256077290112267,-0.17818146608067909,0.021326863800922018},
{-0.6978095396913344,-0.21147947519325216,0.03171541229820815},
{-0.6679736628347955,-0.22746789889024566,0.03104514865758996},
{-0.6384347246055612,-0.24378768888147737,0.03329047806043132},
{-0.6091948767328145,-0.26051200395918167,0.037648805521337085},
{-0.6204193720178379,-0.2601300720291344,0.0031587384411797936},
{-0.6504026423234373,-0.2520557082685573,0.0},
{-0.6196867082309021,-0.26560729866538996,0.0},
{-0.5901951080437017,-0.28023475365390516,0.0},
{-0.5639354050899154,-0.3014518792664755,0.0},
{-0.537076445558562,-0.3220762034890289,0.0},
{-0.5328881047031421,-0.3125053120814214,-0.013050237497108616},
{-0.5030070415337526,-0.32893914371937144,-0.01103514311688731},
{-0.47169077499905865,-0.3410221789485575,-0.008207770969945724},
{-0.4394643270198013,-0.34962264049446734,-0.0033997321097166714},
{-0.4035487393556647,-0.3644943167452944,-0.02157431265700899},
{-0.4151928218314443,-0.35968842961424874,-0.07838964587916965},
{-0.41657315610257295,-0.36785424186511884,-0.14041861891262367},
{-0.44185382227792813,-0.35626610434810674,-0.20287148259520058},
{-0.40913678004486354,-0.3684556501718694,-0.19646470895173132},
{-0.31987659833133403,-0.39179438075923767,-0.29228874053911574},
{-0.28518642043712383,-0.373668214118571,-0.30465365229132263},
{0.8196415219180514,-0.5649676971656347,-0.013288003571870446},
{0.8218276787683502,-0.5472761798200079,-0.03810927556657719},
{0.7553661436171644,-0.5664384040624647,-0.12912096483536584},
{0.7544774794644347,-0.5719425273135124,-0.13729753573215275},
{0.7516458038591264,-0.5521842740872634,-0.1354147726967084},
{0.7566023120330077,-0.5523607158802993,-0.1262580891568987},
{0.7496328612080884,-0.5456839002243178,-0.14115343442874279},
{0.7524591574904382,-0.5321032614835097,-0.14786145015788313},
{0.7504709597250091,-0.5222784660322651,-0.15756682463945088},
{0.7453294028413584,-0.5210509045331555,-0.17134004314217013},
{0.7219347272952227,-0.5314351495720748,-0.1795822417790497},
{0.7082023916469873,-0.5404724121422078,-0.17612979230434056},
{0.6942591865387823,-0.5524123573807,-0.1709419732432476},
{0.6937234059721243,-0.5353642070608994,-0.202856420490917},
{0.7696084390818573,-0.5299622909460615,-0.12216550025013853},
{0.7828394218303685,-0.5637153907809163,-0.07767096833192574},
{0.8028322135376043,-0.5600725132734794,0.0},
{0.8057456548518803,-0.5465004814494048,0.011208357316148191},
{0.8082976056633512,-0.5313652183736155,0.024751340796247388},
{0.8076929697628256,-0.524332291537787,0.044588132137689154},
{0.7993001500831106,-0.5308154515672657,0.06680366009134091},
{0.7887028838550381,-0.5443369177555313,0.07865323270413185},
{0.7850341855974007,-0.5232994615297718,0.09304076988870182},
{0.8072938239993115,-0.5298030629864925,0.10644819443024901},
{0.7876571434719227,-0.5370447075531074,0.1307681135252317},
{0.7488614662958519,-0.4281187969682136,0.14205500895657272},
{0.7447925464101088,-0.3426176861380226,0.1335836511616648},
{0.7395175823170895,-0.31890993399570733,0.10851600617546275},
{0.7297713249810378,-0.31039769334631545,0.09684825467866613},
{0.42118538760711577,-0.34418091738973733,0.10142390678709177},
{0.3963243086225168,-0.3640424536167878,0.10079237427177415},
{0.3715600574511692,-0.37989101491686256,0.11116908825855179},
{0.39051356396283965,-0.41522886329526565,0.1190218239132423},
{0.4255178943178211,-0.4137968875237362,0.11476677945313804},
{0.4403347014744724,-0.3481949681813047,0.12043120652834634},
{0.45539572989343563,-0.3642985093896082,0.09552924468926342},
{0.47290972958143485,-0.3676788759366746,0.09542273409468685},
{0.48532090351108415,-0.3741846291225786,0.1009257814811428},
{0.5005088839518658,-0.38730372195355495,0.10886351043857621},
{0.5087661446930289,-0.3927271553602264,0.06875420259606127},
{0.46764229654055745,-0.4013674238960285,0.025380721582381645},
{0.4265001586900273,-0.4057956825553936,0.0},
{0.45048118043863,-0.3943398763831584,-0.025532418489808875},
{0.4992092395251134,-0.38350376821573234,-0.07737295384002969},
{0.47290972958143485,-0.3676788759366746,-0.09542273409468685},
{0.4663168313636046,-0.37681404218465064,-0.12759000952140165},
{0.4483918514015826,-0.41268874699430325,-0.13827657251058384},
{0.7706025379645718,-0.5757263430824596,-0.0063809528932688535},
{0.7608605840868868,-0.5532343179287456,-0.01313845839362658},
{0.7564280219691549,-0.5687353749657068,-0.0303114090060625},
{0.753571601478238,-0.5523026191923485,-0.024461933221084795},
{0.7712921671678403,-0.5641166882736139,-0.03403067289950887},
{0.7855269315803913,-0.5648611865710582,-0.0157915404767156},
{0.7810459555560337,-0.558345750603829,0.0},
{0.7834171611161019,-0.549183687741061,0.0},
{0.7855269315803913,-0.5648611865710582,0.0157915404767156},
{0.7608605840868868,-0.5532343179287456,0.01313845839362658},
{0.753571601478238,-0.5523026191923485,0.024461933221084795},
{0.7564280219691549,-0.5687353749657068,0.0303114090060625},
{0.7706025379645718,-0.5757263430824596,0.0063809528932688535},
{0.744710780701141,-0.5455870724110664,-0.07231746612371368},
{0.7479555883096554,-0.5606222800798292,-0.07323948207878557},
{0.7490820185371468,-0.5493848744197055,-0.06853902967772477},
{0.7712910913032486,-0.562672877991576,-0.07385380076063627},
{0.7841476731738544,-0.5697542187340302,-0.07120502213591398},
{0.7512735547104042,-0.5568944092696493,-0.05836350236959177},
{0.7480158367267896,-0.5553236469657928,-0.041331490018666255},
{0.7783788872332528,-0.5664168867706311,-0.06077666664873559},
{0.7704572962446946,-0.5628579267013454,-0.050211676358413525},
{0.7590154763121514,-0.549454805618165,-0.037303452987407004},
{0.7711049667288876,-0.5528082755504392,-0.017122384976626843},
{0.7597008020570531,-0.5081233155994986,0.0},
{0.7477156705057102,-0.5157372093148357,0.014061550213290155},
{0.7711049667288876,-0.5528082755504392,0.017122384976626843},
{0.7712921671678403,-0.5641166882736139,0.03403067289950887},
{0.7704572962446946,-0.5628579267013454,0.050211676358413525},
{0.7783788872332528,-0.5664168867706311,0.06077666664873559},
{0.7480158367267896,-0.5553236469657928,0.041331490018666255},
{0.7841476731738544,-0.5697542187340302,0.07120502213591398},
{0.7512735547104042,-0.5568944092696493,0.05836350236959177},
{0.7712910913032486,-0.562672877991576,0.07385380076063627},
{0.7490820185371468,-0.5493848744197055,0.06853902967772477},
{0.744710780701141,-0.5455870724110664,0.07231746612371368},
{0.7479555883096554,-0.5606222800798292,0.07323948207878557},
{0.7219002996282887,-0.5502972075934522,-0.11729828883736693},
{0.7372098527679306,-0.5784611908745165,-0.12135214661882657},
{0.7358596427053691,-0.5727268326008489,-0.11303248573134586},
{0.7314475220148792,-0.5523800814429496,-0.10155946572564377},
{0.7450991678187383,-0.5585135854801314,-0.11210939391168229},
{0.7576857076768317,-0.5640596674502547,-0.11620521041221753},
{0.7349397784794806,-0.5491653980430024,-0.0844704325513591},
{0.754252623764773,-0.5619735660069823,-0.10138732739097457},
{0.7578341769904839,-0.5592656148297176,-0.08207878556404892},
{0.7562860078430529,-0.5460948804983404,-0.061449082018537146},
{0.6861633054863715,-0.5497850960478115,-0.12276690855688903},
{0.7133256588325794,-0.5469846205156619,-0.11625254845425155},
{0.7182520427978935,-0.5561574420243468,-0.11998902618116483},
{0.7107425079479497,-0.5336535823601242,-0.11772433121567319},
{0.7293431308735482,-0.5351995997783718,-0.10097204365858513},
{0.3899906937712819,-0.5094789049850186,-0.17050194462524945},
{0.39516237486349964,-0.5165096800916636,-0.18641828539460026},
{0.4274705885517249,-0.4745079264323792,-0.16655997676132483},
{0.4968003787043363,-0.4071770926911139,-0.12636675148065865},
{0.5138528324825038,-0.41617992759431294,-0.1252091211800083},
{0.44452626992366745,-0.48055320957304315,-0.15662651898632038},
{0.4145376202951097,-0.47053260676611236,-0.18003948423051477},
{0.479577938320683,-0.39939643996406615,-0.12955023480744712},
{0.48532090351108415,-0.3741846291225786,-0.1009257814811428},
{0.5005088839518658,-0.38730372195355495,-0.10886351043857621},
{0.5182272979122848,-0.39913930832665395,-0.10654932570186718},
{0.5289698058602345,-0.4285394600235614,-0.1251090657729818},
{0.46383050829222633,-0.4914388075116866,-0.14481352576964665},
{0.4313512321339236,-0.48613479507469187,-0.1745740921047677},
{0.48449679123385536,-0.5042039408919993,-0.1427328036493327},
{0.5416090630833204,-0.44403406187297273,-0.1250423621682975},
{0.45865237201245856,-0.49105472385245597,-0.1554204747790443},
{0.4493837985551139,-0.49102352377929714,-0.1621005180288009},
{0.5354088554414542,-0.412171256125704,-0.10637395977342291},
{0.5582580676396068,-0.45218911547792595,-0.12626239261526545},
{0.5081442949590365,-0.509074379898546,-0.14428420039053885},
{0.47728096741744086,-0.5014927621209595,-0.16311183074498245},
{0.5313711356288697,-0.5114014750103552,-0.149732378682819},
{0.5774138366945136,-0.45572117893241954,-0.12877561230143575},
{0.5069888163875694,-0.49753573215275126,-0.1517173488544732},
{0.4859782567766021,-0.5018919078844736,-0.1658864855269316},
{0.5535188841132455,-0.42342802734847795,-0.10921424229546471},
{0.5730006401394321,-0.43158630854720625,-0.10996734750964243},
{0.5952462923016509,-0.4611930262457167,-0.13278320790545303},
{0.554618417725945,-0.5088333862300091,-0.15584974475112565},
{0.5433562671802127,-0.5001780555899235,-0.17036100636373908},
{0.5777656444159939,-0.5099985475828013,-0.15803159814305773},
{0.6087752895420583,-0.4744670435778953,-0.13836156581332673},
{0.5540923199406123,-0.5036197464187158,-0.17152401598734784},
{0.592487775488577,-0.4374508464364675,-0.10480642506334154},
{0.6127871886044423,-0.44161229067709534,-0.10262241994222608},
{0.6259364056439857,-0.48240584839992035,-0.1404035568083401},
{0.6001113519852391,-0.5179739318009435,-0.15181525253231629},
{0.5884349935717091,-0.5050883015863623,-0.14962479222365074},
{0.6230251160588929,-0.5227647568277056,-0.14950859884774903},
{0.6418602774654782,-0.4908438543924862,-0.13414310074933972},
{0.6110173913511245,-0.5235512138442255,-0.1567233467995718},
{0.6091927250036311,-0.5185968573995277,-0.15562058559309727},
{0.6316384879799029,-0.4505408909234684,-0.09879019026665303},
{0.6575485349413923,-0.4960273699952124,-0.12447968498684756},
{0.6454278444514974,-0.524989644803305,-0.14407655852434414},
{0.6217545199761159,-0.5269918288084262,-0.15788635642318058},
{0.6396719688859961,-0.51206958692179,-0.13423132164585766},
{0.6665997837512171,-0.5300096289880956,-0.1332382986277347},
{0.6613226679290145,-0.5199621295663728,-0.13211939945238493},
{0.6896501826280145,-0.531156500642829,-0.1272360500707381},
{0.6716359059048828,-0.528219390307536,-0.13426252171901645},
{0.688479641952264,-0.5399065073669828,-0.13496828889116017},
{0.6732497027924066,-0.4948449948089534,-0.11350479028709448},
{0.6908486957831487,-0.4969203376063088,-0.10639117360688984},
{0.7058709930768114,-0.5021479636572941,-0.09769711184150363},
{0.7138937153369878,-0.5048365492719087,-0.07960644873236256},
{0.724668499222688,-0.5132164585765235,-0.06531789109022738},
{0.7430647078758668,-0.5400592801390017,-0.08154192913279935},
{0.7329601876307849,-0.5211843117425241,-0.04977487533419044},
{0.7385579111013089,-0.5199761158060646,-0.030714858227943436},
{0.7477156705057102,-0.5157372093148357,-0.014061550213290155},
{0.6770690220928794,-0.4614953441959795,0.0},
{0.6800943533246906,-0.460216141196469,0.020635082868470173},
{0.7385579111013089,-0.5199761158060646,0.030714858227943436},
{0.7590154763121514,-0.549454805618165,0.037303452987407004},
{0.6499744482159475,-0.45316277293339857,-0.08913215382711934},
{0.6677606416456425,-0.45087010548852324,-0.08081572053341367},
{0.6719748032512628,-0.45470448689327964,-0.06086703927443692},
{0.6743266432486807,-0.46120163316245016,-0.04174247029268897},
{0.5087661446930289,-0.3927271553602264,-0.06875420259606127},
{0.5197636325492074,-0.4009575194865974,-0.06339532106489078},
{0.5324362415746354,-0.4082109985637208,-0.06206340070038785},
{0.46764229654055745,-0.4013674238960285,-0.025380721582381645},
{0.49586222478038916,-0.4061119867453482,-0.02987460798183941},
{0.5209234145790411,-0.42004443320763646,-0.036231891854091244},
{0.546164273764504,-0.4141637573495,-0.062352808275550446},
{0.5602763896136033,-0.41829184978778566,-0.06175462756257498},
{0.5742916776494511,-0.42153020220875,-0.06238508421330092},
{0.5542171202332474,-0.42264049446736635,-0.03109248669962399},
{0.5883801244775333,-0.4242628982716235,-0.06424310236313659},
{0.6032862283952942,-0.42577771561671246,-0.06407419162224243},
{0.6178717246647337,-0.4265168345911983,-0.0590929385627525},
{0.5788135365282926,-0.4243618778140583,-0.025314017977697327},
{0.625637315287498,-0.4305631613205162,-0.0482471476140013},
{0.628541073820449,-0.4356659870788662,-0.033761706751588245},
{0.634684260638956,-0.43640295432416876,-0.019959439904893572},
{0.6388769049527426,-0.43794359241945807,-0.005493364605130799},
{0.6800943533246906,-0.460216141196469,-0.020635082868470173},
{0.6396569067817125,-0.4367407758059571,0.0},
{0.6388769049527426,-0.43794359241945807,0.005493364605130799},
{0.634684260638956,-0.43640295432416876,0.019959439904893572},
{0.6743266432486807,-0.46120163316245016,0.04174247029268897},
{0.7329601876307849,-0.5211843117425241,0.04977487533419044},
{0.7562860078430529,-0.5460948804983404,0.061449082018537146},
{0.7578341769904839,-0.5592656148297176,0.08207878556404892},
{0.7349397784794806,-0.5491653980430024,0.0844704325513591},
{0.5867996793923517,-0.42250923898718107,-0.0040398715417677535},
{0.5924490443632765,-0.41951833542230377,0.0},
{0.5867996793923517,-0.42250923898718107,0.0040398715417677535},
{0.628541073820449,-0.4356659870788662,0.033761706751588245},
{0.6719748032512628,-0.45470448689327964,0.06086703927443692},
{0.7138937153369878,-0.5048365492719087,0.07960644873236256},
{0.724668499222688,-0.5132164585765235,0.06531789109022738},
{0.7430647078758668,-0.5400592801390017,0.08154192913279935},
{0.754252623764773,-0.5619735660069823,0.10138732739097457},
{0.7314475220148792,-0.5523800814429496,0.10155946572564377},
{0.7576857076768317,-0.5640596674502547,0.11620521041221753},
{0.7219002996282887,-0.5502972075934522,0.11729828883736693},
{0.7372098527679306,-0.5784611908745165,0.12135214661882657},
{0.7358596427053691,-0.5727268326008489,0.11303248573134586},
{0.4438108199701986,-0.4138280875968951,0.0},
{0.46128824026208065,-0.4125650225662598,0.0},
{0.47852143929165075,-0.40298767597110224,0.0},
{0.49565350704960276,-0.4024454402168943,0.0},
{0.58407451438162,-0.4226566324362416,-0.01335901063492149},
{0.5133482519890047,-0.4049382184758226,0.0},
{0.58407451438162,-0.4226566324362416,0.01335901063492149},
{0.5319585576959284,-0.4055794337724654,0.0},
{0.5514833483057823,-0.4048532251730797,0.0},
{0.37106085628062846,-0.501419603328725,-0.1633851003512698},
{0.31401313630666444,-0.16964340468108682,-0.32219670032329734},
{0.3273248088995519,-0.16532273248088994,-0.29334308783896457},
{0.27281397763277515,-0.17222763143030817,-0.2709478904985019},
{0.29146086273581606,-0.18024067090915935,-0.24250741001737525},
{0.28568777333684786,-0.2021205291102062,-0.22237152831944573},
{0.25891488297282905,-0.19539960300596568,-0.39241300289945513},
{0.2778318100883823,-0.17038359952016438,-0.37772422362921404},
{0.2973038833332437,-0.17340139969983376,-0.3519626459813768},
{0.23604307761825097,-0.19121556560891245,-0.3248659203752616},
{0.25519023975642424,-0.17635464800400222,-0.2994529228551295},
{0.26771760706197517,-0.18741238427731485,-0.24466882198206533},
{0.15871531009107195,-0.22840928040796787,-0.36364868717623205},
{0.189858362426505,-0.22974873182461253,-0.354398403416946},
{0.21605458936938196,-0.2099356095041878,-0.34646067445951256},
{0.2150508077053422,-0.17391673883924968,-0.2681388080496189},
{0.24637998461513633,-0.18071512719409133,-0.2665615905582123},
{0.2285948670500331,-0.1976470841379904,-0.22620160626583538},
{0.24134816591983732,-0.238482600579891,-0.2201122126769125},
{0.2460636804251817,-0.22252860454983134,-0.19396977896361964},
{0.1724637837081825,-0.15231875716122367,-0.19174381512342856},
{0.1553553849712475,-0.14249826516834588,-0.13374825844419222},
{0.1551294534069942,-0.18288729780469828,-0.14087478549949703},
{0.17223677627933748,-0.17731539508437466,-0.1666740184080432},
{0.18991538324986415,-0.17733583651161666,-0.15160976239530494},
{0.2177178760281231,-0.20198389430706248,-0.1420797538421814},
{0.24969257169292672,-0.20932559428070383,-0.12384600074234657},
{0.16021506533187735,-0.22575619832487884,-0.31250531208142146},
{0.1885802352915862,-0.20996788544193826,-0.3039962990258046},
{0.20473003867733208,-0.20017536592844423,-0.280204629445338},
{0.1820604958659903,-0.1314566668639085,-0.2446053459711561},
{0.20349387026148888,-0.15224667423358096,-0.22677611795779382},
{0.1845801707397107,-0.18324663657832024,-0.22573790862682022},
{0.21395880514478446,-0.20102207136209838,-0.21009591332834848},
{0.15565662705691863,-0.1844031910143789,-0.1841342248664583},
{0.14278928654039602,-0.11205882827587317,-0.11424821271994706},
{0.1443837178652695,-0.13985379000199033,-0.09091163386176217},
{0.17409694615835647,-0.1282430593285529,-0.10151427941279312},
{0.17488555490405977,-0.16929374868879002,-0.1111002329246841},
{0.1965244194365697,-0.19098748231547577,-0.11021372050113773},
{0.23544812449905056,-0.19025804612231503,-0.10929815973361594},
{0.2697692808383137,-0.1893640026466269,-0.10659128442094279},
{0.3030974141594539,-0.17775757543155618,-0.09934748812514457},
{0.3068758506054428,-0.15302667606255074,-0.07063696563150562},
{0.3653264980069609,-0.1638197496463095,-0.03112476263737446},
{0.38641129227475435,-0.19454536652016977,0.01936341092110147},
{0.3687574301898363,-0.13032485731345853,0.06443998558341447},
{0.852202563785322,-0.079503165731561,0.02350548959907906},
{0.8569761749786172,-0.06711028149997039,0.02841573559551795},
{0.8531579315427361,-0.05162321070270094,0.027216146575791973},
{0.8316600052717366,-0.01058220412378896,0.02166038182434359},
{0.8156898712728016,0.009025428059624438,0.025755122460287147},
{0.7762024131642792,0.10031253866388379,0.025585135854801315},
{0.7928428108038322,0.14941069516990593,0.026653469394342027},
{0.8021242946362772,0.18608369150658702,0.028945060974625732},
{0.809531622350011,0.2441491793842827,-0.0},
{0.7933334050576394,0.323783600596029,-0.06390850847512332},
{0.7841810249761966,0.35944958767489527,-0.1183020705014067},
{0.7795020898669693,0.3712894775063611,-0.18249891068710095},
{0.7650962629843407,0.37186936852127794,-0.24542623065460983},
{0.7801712776429959,0.2975895253823354,-0.24931870874731707},
{0.7527399581488674,0.2779076585420959,-0.3069452438716063},
{0.7129092992355981,0.32894344717773827,-0.3545027622823391},
{0.6569417473116833,0.4375519777080857,-0.4096365191477001},
{0.612815161083826,0.41833488437145305,-0.4487883075036176},
{0.5648445106698871,0.4049479012571478,-0.4849696337218998},
{0.5142003367456173,0.39240977530568005,-0.5166925770722497},
{0.46182724842251355,0.37474838216862033,-0.5426876173364821},
{-0.2788743228777226,-0.3540110921639403,-0.35509341194317284},
{0.13477409533236145,-0.22274377746816784,-0.32135214661882655},
{0.15556840616040066,-0.21478668294808415,-0.27281128797129595},
{0.1719419893812165,-0.1734293721792175,-0.26210751114864683},
{0.12273732228061776,-0.2458759420539331,-0.29452653888981534},
{0.06594135462110738,-0.21591203731098405,-0.2194860594845533},
{0.09316072879067441,-0.1950348849093853,-0.24014803896781553},
{0.1145629031130142,-0.1727289843300322,-0.2637643426198379},
{0.15073992587292964,-0.18758559847657572,-0.24951881956137},
{0.096215108366461,-0.19908228750329482,-0.16092567389468362},
{0.1317111088398414,-0.18998800410980274,-0.16306018924458168},
{0.10665207077037282,-0.12097882160551271,-0.10031791798684218},
{0.11634453487684039,-0.15612946954496307,-0.07490061700834333},
{0.1276992097774574,-0.1992823983173478,-0.060165575560659934},
{0.15122514080377844,-0.1720404309913554,-0.06829480841541284},
{0.18072427204312067,-0.1612753298869804,-0.06635287282742594},
{0.21296255453288648,-0.1734659515753347,-0.06370839766107038},
{0.24473391178986215,-0.1778414928697074,-0.0656126779883484},
{0.27524650747456925,-0.1637702598750921,-0.07121470491723912},
{-0.10050888395186583,-0.3411028687929337,-0.2870277626857884},
{-0.17193338246448303,-0.3438613856060076,-0.24736493864882167},
{-0.13856221455967552,-0.3395676100206028,-0.24475489114939997},
{-0.1134633695003147,-0.33888873946325115,-0.21924936927438315},
{-0.08130577685492506,-0.331038155537744,-0.20541052303157126},
{-0.04733212477877536,-0.31839567072088304,-0.2110243844709705},
{-0.02553188055751304,-0.29461045632796656,-0.20713513397203828},
{0.00578653770636427,-0.22333873058736825,-0.24820303716574232},
{0.09245280988934733,-0.21000554070264713,-0.2905856468904824},
{0.02870137764460964,-0.2342867286723293,-0.2217464509916782},
{-0.009020586668961854,-0.21640908675234136,-0.18281736660623893},
{0.01893145128754094,-0.2237647729656745,-0.1970327654561397},
{0.04663066106499835,-0.22932699290467298,-0.1840664453971823},
{0.06790265577174456,-0.21343432115633923,-0.15329133875210468},
{0.08821820685648503,-0.1564285599014508,-0.10317864193612591},
{-0.01737252349419303,-0.25491535635324936,-0.19035594980015816},
{-0.005640220121895472,-0.2555199922537749,-0.14681678563935943},
{0.019760942887728145,-0.22772933398602452,-0.1414051867431965},
{0.0314997014475758,-0.19249154101464785,-0.12618708209384766},
{0.0624135946249805,-0.1820922338714449,-0.1070635889766914},
{0.06600052717364992,-0.20742561741179255,-0.07883075036175947},
{0.09045492934259294,-0.18142089436623504,-0.06803660091340905},
{0.10618406967299096,-0.22404557362410366,-0.051370382523655576},
{0.16632597621263387,-0.20170094191945,-0.02553457021899224},
{0.1962436187781406,-0.1854855107936115,-0.02220261757855156},
{0.2292134891902505,-0.18717031474418627,-0.024242456844381567},
{0.25891380710823736,-0.2027111787710399,-0.023147226690048792},
{0.28565442153450565,-0.2077236319036886,0.0005572978584915303},
{0.30851869583694197,-0.19248078236873106,-0.016544645690893346},
{0.33837608998531443,-0.18054621645319718,-0.02545818383298278},
{0.35757381775929686,-0.23112045917900773,0.0},
{0.3653264980069609,-0.1638197496463095,0.03112476263737446},
{0.3387106838733277,-0.14485440862413057,0.06635932801497604},
{0.3697719704997929,-0.1538034502977455,0.09298912838830105},
{0.8194414111039986,-0.12506387946013112,0.06323609310532177},
{0.8418118635588525,-0.1013475204010823,0.048380554823369934},
{0.8448597879470889,-0.09945615044890448,0.06006767188281683},
{0.8391975126010641,-0.07637455149894833,0.05723384454832515},
{0.8201751507555259,-0.025411921655540418,0.05448716224575975},
{0.7966438404062465,0.021309649967455116,0.0499125860019258},
{0.7891687332232367,0.010713459603974266,0.05996331301742363},
{0.7918250429001007,0.09453084234818208,0.04746822164962318},
{0.7932613221299968,0.1448726983221892,0.05125634087693723},
{0.8002447591946078,0.1769528287169777,0.08745057747031958},
{0.8105246453681341,0.24035460496941857,0.0673448199809572},
{0.794998843445564,0.32290354336003274,-0.0},
{0.7603829002081799,0.48061560971936074,-0.06310914108350323},
{0.7574156656643195,0.48545700038193196,-0.12603430932182877},
{0.7531982764649242,0.48784541977546714,-0.18934786467775166},
{0.7410732825166624,0.4769458355971318,-0.2500201724610941},
{0.7228718053545782,0.4552628606163629,-0.3074250794794967},
{0.7438726821842204,0.3497130131201688,-0.3021554947094359},
{0.6960408183026084,0.4425450652780842,-0.36186275195403905},
{0.6522552811503145,0.5131637412115312,-0.39672721991210186},
{0.6049097080641431,0.509247594097807,-0.43696455564102704},
{0.5521407015713002,0.5044858174150202,-0.4697461497495925},
{0.49968692340382037,0.49414783455354316,-0.5020081012603753},
{0.44620569455128384,0.4831288294055311,-0.5322979929746042},
{0.3906103917760911,0.4727037015121277,-0.5591730904748329},
{0.4093508770986084,0.3547598939197513,-0.567409909788754},
{0.3564129598648714,0.3357977804913474,-0.591224172525646},
{0.3005282495145161,0.3216157334437888,-0.6098280230450196},
{0.24220025067644985,0.3128840164176937,-0.62391539400851},
{0.18299757392534574,0.3082287503294836,-0.6358617944345525},
{0.19190358101529342,0.16297412007724713,-0.6148275658025681},
{0.18997132820863166,0.06324900348042198,-0.5889540982371959},
{0.13164440523515708,0.03618347794746555,-0.6006584291301097},
{0.07436537437398127,0.14660806790857306,-0.6494639504671943},
{0.008464364675061987,0.2734901585286476,-0.667393233887583},
{-0.051054616265996784,0.26939649375729574,-0.6744691953070787},
{-0.1118721657692163,0.26557502272763955,-0.6764864414164834},
{-0.18366030651382217,0.2642538610090534,-0.6718171890885813},
{-0.24213462293635726,0.28861143536474504,-0.6624324222553349},
{-0.21696154322017033,0.15156134848867925,-0.659829905808055},
{-0.20233086063788014,0.07125343604253971,-0.652826027316202},
{-0.2640123294082207,0.06589563037596091,-0.635104385762008},
{-0.3116763584135301,0.027488340317487665,-0.6104692383416623},
{-0.3757204258272054,0.09810056106338458,-0.5935501917728635},
{-0.4221343001769797,0.06966330817603299,-0.5607105009763471},
{-0.4712679602145274,0.052799130701409944,-0.5252876592952012},
{-0.45555710958218804,-0.05723169281914176,-0.5143988337627827},
{-0.5043120652834635,-0.051005664427075194,-0.470547668870396},
{-0.5485322517307972,-0.038824725520046025,-0.42286857776080305},
{-0.5997961236598762,-0.032980629058026734,-0.3827248422513543},
{-0.655780889417258,0.06076375627363542,-0.35557755100943},
{-0.6937793509308918,0.06141788194537838,-0.3046256798119389},
{-0.7289396816516673,0.06966330817603299,-0.2518157904646121},
{-0.7304491196737979,-0.0012888857808356035,-0.24145629031130145},
{-0.7602258239777943,0.011623641048537654,-0.18350161648654903},
{-0.772357273113606,-0.009690312377284174,-0.12170395434030674},
{-0.7709554215506437,-0.055841675766687984,-0.06881445101319549},
{-0.7786607637562737,-0.004442244899056984,-0.028396370032867668},
{-0.7646013652721669,-0.06497253855629728,0.0},
{-0.7786607637562737,-0.004442244899056984,0.028396370032867668},
{-0.7822466204403514,0.0402050597911747,0.07580541912994831},
{-0.7776214785607084,0.06830233946755464,0.13521896534102218},
{-0.772357273113606,-0.009690312377284174,0.12170395434030674},
{-0.7383362829954223,-0.13876501503520766,0.10246534371184042},
{-0.714516640935572,-0.16688703959719628,0.11161557206410001},
{-0.6839696175839309,-0.18728973571386304,0.11131863343679564},
{-0.6540659612581161,-0.2087618412346622,0.11005126494779369},
{-0.6248594651877115,-0.23140018397284517,0.10765854209589182},
{-0.5966449162708382,-0.25529190896033827,0.10728736881176136},
{-0.5803003813939979,-0.2781421970230827,0.03918191256448464},
{-0.591393621198836,-0.2776645131443756,0.007456817484951345},
{-0.2811562316766812,-0.4027746547819492,-0.29448458017073975},
{-0.37534817667848325,-0.3783062663733142,-0.1961484047617767},
{-0.34074514381619936,-0.384314970117861,-0.20192041829615326},
{-0.3062346353088001,-0.3825978902295357,-0.20946868427139761},
{-0.2726579772669812,-0.3748968514822725,-0.21764848276195958},
{-0.24096946158356514,-0.36397252241832845,-0.22663302796710008},
{-0.20849448888362915,-0.3525952543612861,-0.23694626594296844},
{-0.03520713083051368,-0.27349984130997274,-0.30650091179524147},
{-0.3484472584280543,-0.3856275249197136,-0.1428619074003346},
{-0.31374094256496876,-0.3776015750657622,-0.15470179723180041},
{-0.019280031415246084,-0.288635104385762,-0.15477603188862651},
{-0.03681662425967069,-0.25752110039430437,-0.13281763557238688},
{-0.010702163025761586,-0.32958143488060593,-0.15031011796855248},
{0.018229987573763956,-0.3206754277906583,-0.12350925512514996},
{0.015824354346761906,-0.29053830884844833,-0.10980489195629839},
{0.03084342404664948,-0.26532004281941074,-0.09722911074412174},
{0.052842703217373055,-0.23688709339042585,-0.09903656325814833},
{0.05421658230095159,-0.26304674093718566,-0.05601166237217384},
{0.07935200675642963,-0.2405708537523467,-0.0629703545511762},
{0.1403513773756435,-0.2242833396988655,-0.024577050732394825},
{0.14753922871267422,-0.198844521428533,0.0},
{0.1760560955798103,-0.18476468151718423,0.0},
{0.21025352749102996,-0.17889476430496454,0.0},
{0.2411652689392513,-0.18675503101179686,0.0},
{0.26569175403583706,-0.20847566125327466,0.0},
{0.29815381636067284,-0.21885990629219404,0.0},
{0.32767338902725707,-0.2370452454854032,0.0},
{0.33837608998531443,-0.18054621645319718,0.02545818383298278},
{0.3068758506054428,-0.15302667606255074,0.07063696563150562},
{0.3360629811131971,-0.16542278788791642,0.09243828571735963},
{0.3570789200471228,-0.19428715901816596,0.10558535102771965},
{0.8073831207604212,-0.1473697800394842,0.07817554882542484},
{0.8058478619880902,-0.13995492127360848,0.0935700952678096},
{0.8246389129464166,-0.12309935071571891,0.07750851277858169},
{-0.3845199223225765,-0.38701646610757573,-0.13322861584640958},
{-0.3494929988111697,-0.39105741351393514,-0.07976567669193156},
{-0.31535796704626756,-0.3951489265561036,-0.09065988154730846},
{-0.28554791093992915,-0.38590617384895937,-0.1079974394422718},
{-0.2801858018149836,-0.3644157786301016,-0.16447495118264416},
{-0.24777645685514024,-0.3455289757231155,-0.16501395934307708},
{-0.21886905114122338,-0.32248288030468486,-0.1540584302059743},
{-0.19125806226028397,-0.29892897679898006,-0.16147006137807496},
{-0.17382260068747749,-0.31690559826140285,-0.19406875850605443},
{-0.1437123783600596,-0.3280784520460255,-0.1948433810120658},
{-0.10615071787064881,-0.3266238831180707,-0.19394503407801097},
{-0.07030613726956327,-0.3281085762545926,-0.1843020597427608},
{-0.03580961500185588,-0.318392443127108,-0.17214371399215694},
{-0.38333001608417566,-0.37766612694126317,-0.07581510191127346},
{-0.3402911289585093,-0.3837641274469195,-0.009530008553123505},
{-0.3131492170395434,-0.39461637358322077,-0.023749710861390987},
{-0.30050242876431577,-0.40454983135822525,-0.05547480594092428},
{-0.283772734363653,-0.4024669575087279,-0.08462858464633642},
{-0.2595786914258971,-0.36969719791067096,-0.129269434149018},
{-0.23621844354669524,-0.3449243398225899,-0.14260477576292246},
{-0.20956712588153656,-0.3200094676084068,-0.13746321887927185},
{-0.17867044653759878,-0.3037929606179766,-0.12812686595265121},
{-0.16806780098656787,-0.3025159093476495,-0.1602812310042658},
{-0.14361124708844145,-0.319412362760023,-0.17695175285238599},
{-0.11093508770986085,-0.3338891967057026,-0.1738489593699737},
{-0.07504747252510799,-0.3403239428285556,-0.17444391248917412},
{-0.04073384723798664,-0.33858104219002993,-0.16692254312872182},
{-0.3722669004879046,-0.3765106483697962,-0.01854252623764773},
{-0.37962796602419624,-0.3622586701237782,0.0},
{-0.34901101147409586,-0.3750797484628584,0.0},
{-0.3173332544365966,-0.3791045579003427,0.0},
{-0.3114859303808023,-0.3835242096429743,0.0},
{-0.28636987148797455,-0.3867862310849557,-0.0217087957309693},
{-0.2728914398833763,-0.39014938379855507,-0.054968073718241826},
{-0.2510610714535469,-0.37906905436881716,-0.07610450948643604},
{-0.2585878201369576,-0.39982033061318906,-0.1072303479884022},
{-0.23207421313953427,-0.3892295195726666,-0.1275814026046682},
{-0.21587707171175438,-0.3589536140981296,-0.13306938788684058},
{-0.19165720802379815,-0.33971070001129655,-0.1330866017203075},
{-0.1560762142476748,-0.3411706482622097,-0.1356536146360619},
{-0.12389280085208478,-0.3474805940924275,-0.13574936658472164},
{-0.0927443691936933,-0.35821234339446034,-0.1308068446505323},
{-0.06055450061055317,-0.3663544866243134,-0.12167813359010635},
{-0.02885522628122026,-0.3670936055987993,-0.11062900423352717},
{-0.0010677956072448825,-0.35540648853935247,-0.09987896523343573},
{0.025197286669499767,-0.33483488168179154,-0.08587981516646316},
{0.032464751986314995,-0.308735482552166,-0.0702141508469744},
{0.027372684873881763,-0.27766881660274234,-0.05083890541536442},
{0.08295938073234102,-0.26017095488361835,-0.019649590902489016},
{0.11174951720576448,-0.24214591951456987,-0.02034890288708263},
{0.1259035917739393,-0.22561848765714346,0.0},
{0.16632597621263387,-0.20170094191945,0.02553457021899224},
{0.1962436187781406,-0.1854855107936115,0.02220261757855156},
{0.2292134891902505,-0.18717031474418627,0.024242456844381567},
{0.25891380710823736,-0.2027111787710399,0.023147226690048792},
{0.28565442153450565,-0.2077236319036886,-0.0005572978584915303},
{0.30851869583694197,-0.19248078236873106,0.016544645690893346},
{-0.41024599643888826,-0.34943651592010627,0.0},
{-0.4035487393556647,-0.3644943167452944,0.02157431265700899},
{-0.3722669004879046,-0.3765106483697962,0.01854252623764773},
{-0.3402911289585093,-0.3837641274469195,0.009530008553123505},
{-0.3131492170395434,-0.39461637358322077,0.023749710861390987},
{-0.30050242876431577,-0.40454983135822525,0.05547480594092428},
{-0.28636987148797455,-0.3867862310849557,0.0217087957309693},
{-0.28939305099060236,-0.35858782013695756,0.0},
{-0.2657304851611376,-0.3655249950241263,0.0},
{-0.2511934027983238,-0.36144854408624133,-0.0504655804020506},
{-0.22680032491110672,-0.3562273732228062,-0.07251757693776661},
{-0.2222784660322652,-0.3658047198179637,-0.09095036498706273},
{-0.1931397494311366,-0.36108382598966093,-0.10692480244436435},
{-0.16071641823160138,-0.35150863112368674,-0.10884952419888433},
{-0.12753675422411337,-0.355401109216394,-0.1089065450222435},
{-0.10122110631155963,-0.3632398586313927,-0.09775413266486281},
{-0.0757661500723519,-0.37896469550342393,-0.07689742169050603},
{-0.043385853456483985,-0.3825193521143429,-0.07219481756026187},
{-0.01171562747112649,-0.38030522278466034,-0.06515543553688333},
{0.01827302215743126,-0.3656089124622775,-0.0546313281010452},
{0.02683905603640725,-0.33456806726305427,-0.04212978154569466},
{0.04184306363201127,-0.31583834058645377,-0.01653065945120147},
{0.05923333889196705,-0.2859002565937051,-0.01866302307191617},
{0.08231816543569825,-0.27527394202165717,0.0},
{0.10927502864489474,-0.2574500933312533,0.0},
{0.1403513773756435,-0.2242833396988655,0.024577050732394825},
{0.1276992097774574,-0.1992823983173478,0.060165575560659934},
{0.15122514080377844,-0.1720404309913554,0.06829480841541284},
{0.18072427204312067,-0.1612753298869804,0.06635287282742594},
{0.21296255453288648,-0.1734659515753347,0.06370839766107038},
{0.24473391178986215,-0.1778414928697074,0.0656126779883484},
{0.27524650747456925,-0.1637702598750921,0.07121470491723912},
{-0.5069285679704353,-0.33618509174435307,0.0},
{-0.5030070415337526,-0.32893914371937144,0.01103514311688731},
{-0.47169077499905865,-0.3410221789485575,0.008207770969945724},
{-0.47518948665121014,-0.3451093885323593,0.0},
{-0.44256712050221364,-0.3478453121890079,0.0},
{-0.19768742906017853,-0.3406735988208524,-0.07417656013814102},
{-0.020561386143939937,-0.3195909562822423,-0.027032173730614267},
{-0.1673943097521746,-0.3336245340161487,-0.07843375632742863},
{-0.13683437602543344,-0.3457656659332856,-0.08745488092868632},
{-0.10879626890159606,-0.36500858002011866,-0.07918470981242301},
{-0.08236657934232398,-0.36818238056558206,-0.06310914108350323},
{-0.05465768678354144,-0.36235549793702965,-0.04357897115069098},
{-0.030342071146925456,-0.35692238174903307,-0.027542133547071766},
{-0.001201202816613511,-0.30267944076558523,0.0},
{0.026733621306422362,-0.31268067800986565,0.0},
{0.05379699511019542,-0.2917755531288832,0.0},
{0.08295938073234102,-0.26017095488361835,0.019649590902489016},
{0.11174951720576448,-0.24214591951456987,0.02034890288708263},
{0.10618406967299096,-0.22404557362410366,0.051370382523655576},
{0.1443837178652695,-0.13985379000199033,0.09091163386176217},
{0.17409694615835647,-0.1282430593285529,0.10151427941279312},
{0.17488555490405977,-0.16929374868879002,0.1111002329246841},
{0.1965244194365697,-0.19098748231547577,0.11021372050113773},
{0.23544812449905056,-0.19025804612231503,0.10929815973361594},
{0.2697692808383137,-0.1893640026466269,0.10659128442094279},
{0.3030974141594539,-0.17775757543155618,0.09934748812514457},
{0.32053825505521877,-0.19667235081792603,0.10481180438629996},
{0.38097172089920767,-0.22567120502213592,0.11066558362964436},
{0.7675298686907266,-0.1900450249331619,0.09958095074153968},
{0.7798689596927332,-0.19073142654265532,0.11439130271064085},
{0.7954055202612199,-0.11865280235829516,0.10010597266228073},
{0.819046568798851,-0.09387241321807235,0.0803896781551074},
{-0.7822466204403514,0.0402050597911747,-0.07580541912994831},
{-0.8213091120351593,0.1209153455946035,-0.03863860094568498},
{-0.779045923280096,0.06985696380253584,0.0},
{-0.8213091120351593,0.1209153455946035,0.03863860094568498},
{-0.8127366229686331,0.14866081754950325,0.09660403341635422},
{-0.7937852681861461,0.1649106763422756,0.15505037735950553},
{-0.776734966137162,0.1724481836716031,0.21567857469458895},
{-0.7606680043249757,0.07685869056520549,0.1966077989424251},
{-0.7602258239777943,0.011623641048537654,0.18350161648654903},
{-0.7284835150647939,-0.10904425568997884,0.16291387166011287},
{-0.7113245506920499,-0.1393137059769657,0.16990053631849897},
{-0.679669386810976,-0.16036514844241703,0.17481508577330457},
{-0.6485919622156356,-0.18326922973474558,0.17624275808646722},
{-0.619615701167851,-0.2092050974464354,0.17570912924899273},
{-0.5972495521713638,-0.24179088419931466,0.1774982920649607},
{-0.5732491648601108,-0.2728317293985379,0.1800125876157227},
{-0.5697300117807174,-0.28091039661748174,0.10954991204806963},
{-0.5524473229799298,-0.2979208916765736,0.036913990005217945},
{-0.5621752906179228,-0.2947718360167189,0.012294980553747507},
{-0.7776214785607084,0.06830233946755464,-0.13521896534102218},
{-0.8127366229686331,0.14866081754950325,-0.09660403341635422},
{-0.8569492783638253,0.3350048682872774,-0.06063142492885846},
{-0.860172568680506,0.33714691468931723,-0.0},
{-0.8569492783638253,0.3350048682872774,0.06063142492885846},
{-0.8456785209013594,0.3222010037816641,0.11927142449851262},
{-0.8342528389376914,0.32060334486301556,0.17784149286970743},
{-0.8175511170164124,0.334979047537077,0.23498926825069796},
{-0.7968665443767248,0.33925883688278996,0.29218545753831426},
{-0.7505914565592775,0.17419108431012878,0.27280806037752087},
{-0.7289396816516673,0.06966330817603299,0.2518157904646121},
{-0.7304491196737979,-0.0012888857808356035,0.24145629031130145},
{-0.7225619563521736,-0.09216394024648056,0.19746203542822102},
{-0.7033922010575749,-0.1283043836102788,0.2010952301543328},
{-0.6728656191331759,-0.1469652549530116,0.2063120975594012},
{-0.6441464897228035,-0.16883112691436655,0.21171508953883064},
{-0.618368774106091,-0.19443778006100151,0.2182509669333018},
{-0.5972441728484054,-0.2241176565517464,0.22738398145209446},
{-0.5732007509534851,-0.2508701054885232,0.23359494773987746},
{-0.5491745428920316,-0.2805456785209014,0.23792637858599117},
{-0.5451023954125134,-0.29968638547152454,0.17682157323679243},
{-0.5441394966029576,-0.3090872902736462,0.10914969041996375},
{-0.5270440082411227,-0.3216383266002141,0.03622758839572452},
{-0.5328881047031421,-0.3125053120814214,0.013050237497108616},
{-0.7606680043249757,0.07685869056520549,-0.1966077989424251},
{-0.7937852681861461,0.1649106763422756,-0.15505037735950553},
{-0.8456785209013594,0.3222010037816641,-0.11927142449851262},
{-0.8397956933140395,0.382593586771169,-0.05817737779523069},
{-0.8221181622081045,0.3790937992544259,-0.0},
{-0.8397956933140395,0.39819685094434015,0.05817737779523069},
{-0.8316643087301033,0.4013136306664444,0.11551988466731576},
{-0.8225635701490611,0.4114450475263184,0.17216415541939895},
{-0.8067031743384777,0.42991979429469007,0.22532585248820583},
{-0.7841250800174291,0.4530110760259714,0.2749565619671108},
{-0.776687628095128,0.47728903640187853,0.322448452637751},
{-0.7726466806887685,0.3520293495860612,0.3464864952097129},
{-0.7145801169464812,0.17363378645163724,0.32542859755671155},
{-0.6937793509308918,0.06141788194537838,0.3046256798119389},
{-0.6951575334728372,-0.020345675293307563,0.2958444730146264},
{-0.6854769038768781,-0.07275641887712012,0.2706843036735397},
{-0.6665395353340829,-0.11464951021264462,0.2707520831428157},
{-0.6358322081582812,-0.1418107876942608,0.27909110959294664},
{-0.6124461395288789,-0.17799964496468473,0.2764799862289332},
{-0.5860960639493914,-0.20794633587416686,0.2813751701210886},
{-0.5535048978735537,-0.2298208147522553,0.29509244366504034},
{-0.5229557227927294,-0.2584377370264178,0.294344717773821},
{-0.4912392346299295,-0.28405730054815304,0.28753234317928744},
{-0.4609547222386591,-0.31260644335303955,0.2856334421749679},
{-0.5290235990898186,-0.30774138366945136,0.22819087989585632},
{-0.517332178572005,-0.3253608180874355,0.16782411765655175},
{-0.5163972522418329,-0.33154703948960984,0.10331742846845296},
{-0.4995954749135274,-0.3413793659929961,0.036197464187157406},
{-0.776734966137162,0.1724481836716031,-0.21567857469458895},
{-0.8342528389376914,0.32060334486301556,-0.17784149286970743},
{-0.8316643087301033,0.3857006837119481,-0.11551988466731576},
{-0.7932193634109211,0.5767613248196582,-0.12463245775886649},
{-0.7875775294921381,0.5869702039301333,-0.04719710377251919},
{-0.7856033179664008,0.5759576539696715,-0.0},
{-0.7875775294921381,0.5869702039301333,0.04719710377251919},
{-0.7932193634109211,0.5767613248196582,0.12463245775886649},
{-0.7897002103315277,0.5735875242741949,0.17974577319698545},
{-0.7900929009074918,0.5658574371829562,0.21436279229896127},
{-0.7726531358763187,0.5810830728844468,0.26404299154908367},
{-0.7475209390146157,0.49737758005777394,0.37020823359172017},
{-0.739163622866426,0.36458791696477083,0.3959289283850735},
{-0.6789119781384315,0.17162191966519097,0.37774358919186435},
{-0.655780889417258,0.06076375627363542,0.35557755100943},
{-0.6531643867302862,-0.03034798840217968,0.34492326395799827},
{-0.6345659155338709,-0.09215425746515542,0.32180185801814987},
{-0.611541337407274,-0.1503822008961952,0.3064320564613738},
{-0.5817269778425688,-0.18461728806812372,0.31537464294743867},
{-0.5493305432578256,-0.21609708602075342,0.32191805139405155},
{-0.5149609730119368,-0.24566292086477998,0.32630435133434105},
{-0.4817210605873145,-0.27732884339177066,0.32973635938180823},
{-0.44719871756940677,-0.3063276975959806,0.32876808124929396},
{-0.4292812686595265,-0.33976556910547234,0.28623592634631007},
{-0.5058548551079362,-0.32116171858609877,0.20365578788253713},
{-0.4832789125160708,-0.34076827490492045,0.16303759608815635},
{-0.4827151594700291,-0.33931263011237406,0.0940983447823257},
{-0.46762508270709047,-0.351772217948649,0.03356052007294362},
{-0.43507049602736997,-0.3568664367902656,0.026772890364018788},
{-0.4394643270198013,-0.34962264049446734,0.0033997321097166714},
{-0.4151928218314443,-0.35968842961424874,0.07838964587916965},
{-0.38333001608417566,-0.37766612694126317,0.07581510191127346},
{-0.3494929988111697,-0.39105741351393514,0.07976567669193156},
{-0.31535796704626756,-0.3951489265561036,0.09065988154730846},
{-0.28554791093992915,-0.38590617384895937,0.1079974394422718},
{-0.2595786914258971,-0.36969719791067096,0.129269434149018},
{-0.283772734363653,-0.4024669575087279,0.08462858464633642},
{-0.2728914398833763,-0.39014938379855507,0.054968073718241826},
{-0.2510610714535469,-0.37906905436881716,0.07610450948643604},
{-0.2511934027983238,-0.36144854408624133,0.0504655804020506},
{-0.6146086273581607,0.06007197534118359,-0.4038870987697489},
{-0.6789119781384315,0.17162191966519097,-0.37774358919186435},
{-0.7145801169464812,0.17363378645163724,-0.32542859755671155},
{-0.7505914565592775,0.17419108431012878,-0.27280806037752087},
{-0.8175511170164124,0.334979047537077,-0.23498926825069796},
{-0.8225635701490611,0.3958019763632549,-0.17216415541939895},
{-0.7897002103315277,0.5735875242741949,-0.17974577319698545},
{-0.7051221913210004,0.7190196721840592,-0.12655717951338644},
{-0.6918933603016725,0.7313738252903489,-0.0},
{-0.7051221913210004,0.7190196721840592,0.12655717951338644},
{-0.6818254194527077,0.7302248019064321,0.22937002748834034},
{-0.7273538572435273,0.6216883543037274,0.3218158442578417},
{-0.7134687488232732,0.51693572246997,0.4146285308531068},
{-0.7021183773810229,0.36245662920864785,0.44447731808474583},
{-0.6401507286292948,0.16661484585550065,0.42775730646540827},
{-0.6146086273581607,0.06007197534118359,0.4038870987697489},
{-0.5997961236598762,-0.032980629058026734,0.3827248422513543},
{-0.5606884457522177,-0.1432051082050813,0.3543715068021539},
{-0.5563473321247788,-0.17307326099937062,0.3559896071480444},
{-0.5413777521961086,-0.2030586830341533,0.3561144074406795},
{-0.5226480255195081,-0.22945717252026657,0.35716337541757},
{-0.49982570993614744,-0.2519330597051055,0.35910746273474026},
{-0.47498184478501543,-0.27201729990263424,0.35874812396111827},
{-0.44912021173015165,-0.2902144736063519,0.35609073841966254},
{-0.42208265867657896,-0.3054401093078425,0.3521982603269553},
{-0.40880756547980873,-0.3279482724304319,0.32101647686622165},
{-0.39491707773659607,-0.36233720823897103,0.2875904398672383},
{-0.47480970645034615,-0.3395977342291699,0.20322544204586412},
{-0.4484703895167754,-0.35200352883586067,0.15456301069947337},
{-0.44778721550105705,-0.34524817506468636,0.0848383782417145},
{-0.41657315610257295,-0.36785424186511884,0.14041861891262367},
{-0.3845199223225765,-0.38701646610757573,0.13322861584640958},
{-0.3484472584280543,-0.3856275249197136,0.1428619074003346},
{-0.31374094256496876,-0.3776015750657622,0.15470179723180041},
{-0.2801858018149836,-0.3644157786301016,0.16447495118264416},
{-0.24777645685514024,-0.3455289757231155,0.16501395934307708},
{-0.21886905114122338,-0.32248288030468486,0.1540584302059743},
{-0.23621844354669524,-0.3449243398225899,0.14260477576292246},
{-0.2585878201369576,-0.39982033061318906,0.1072303479884022},
{-0.23207421313953427,-0.3892295195726666,0.1275814026046682},
{-0.2222784660322652,-0.3658047198179637,0.09095036498706273},
{-0.22680032491110672,-0.3562273732228062,0.07251757693776661},
{-0.19768742906017853,-0.3406735988208524,0.07417656013814102},
{-0.1673943097521746,-0.3336245340161487,0.07843375632742863},
{-0.13683437602543344,-0.3457656659332856,0.08745488092868632},
{-0.10879626890159606,-0.36500858002011866,0.07918470981242301},
{-0.08236657934232398,-0.36818238056558206,0.06310914108350323},
{-0.05465768678354144,-0.36235549793702965,0.04357897115069098},
{-0.030342071146925456,-0.35692238174903307,0.027542133547071766},
{-0.020561386143939937,-0.3195909562822423,0.027032173730614267},
{0.02683905603640725,-0.33456806726305427,0.04212978154569466},
{0.04184306363201127,-0.31583834058645377,0.01653065945120147},
{0.05923333889196705,-0.2859002565937051,0.01866302307191617},
{0.05421658230095159,-0.26304674093718566,0.05601166237217384},
{0.07935200675642963,-0.2405708537523467,0.0629703545511762},
{0.11634453487684039,-0.15612946954496307,0.07490061700834333},
{0.1553553849712475,-0.14249826516834588,0.13374825844419222},
{0.1551294534069942,-0.18288729780469828,0.14087478549949703},
{0.17223677627933748,-0.17731539508437466,0.1666740184080432},
{0.18991538324986415,-0.17733583651161666,0.15160976239530494},
{0.2177178760281231,-0.20198389430706248,0.1420797538421814},
{0.24969257169292672,-0.20932559428070383,0.12384600074234657},
{0.28539728989709356,-0.20202908061991318,0.11472912419242914},
{0.3507765052690469,-0.24554565162428654,0.11310994798194701},
{0.40742077602112997,-0.28607777425133274,0.11013303065676155},
{0.7356251042243823,-0.2576598869266314,0.10274506850567788},
{0.7477339602037687,-0.2634899971489588,0.11628374852741036},
{0.7652328977874845,-0.17139706396552928,0.12634415832423332},
{0.746848523644814,-0.1417419323603931,0.13832928987557627},
{0.7608035632635276,-0.11778242790362403,0.11980505333598714},
{0.8020048736666002,-0.051318741023254795,0.07489523768538492},
{0.7995895576582732,-0.0638170599848303,0.08765606760733095},
{0.7621935803159815,-0.0017697972533176763,0.08980887265528761},
{0.7562946147597863,0.032013426790104216,0.08256615222408109},
{0.7554414541385822,0.09904194258110677,0.07098016643625234},
{0.763089775520853,0.13096499674550963,0.09541197544877002},
{0.7722367762793375,0.1527071442788211,0.11968670823090208},
{0.7985922311817835,0.23078478942640282,0.14959144042130856},
{0.8104278175548826,0.2809674174408409,0.12183090636212526},
{0.7933334050576394,0.323783600596029,0.06390850847512332},
{0.7624195118802348,0.4825069796715386,-0.0},
{0.7511422992302189,0.5592720700172676,-0.06030974141594539},
{0.7476037805881751,0.5573645620962147,-0.12083250402104391},
{0.7443180901251769,0.5593775047472526,-0.181549998117237},
{0.7372421287056811,0.553788388193462,-0.24139281430039217},
{0.7174429926249483,0.5447554290816958,-0.2984760378058818},
{0.6905259364056439,0.5254866942446624,-0.3504316906674126},
{-0.5717128302231882,0.05419022361845541,-0.450199841847905},
{-0.6401507286292948,0.16661484585550065,-0.42775730646540827},
{-0.739163622866426,0.36458791696477083,-0.3959289283850735},
{-0.7726466806887685,0.3520293495860612,-0.3464864952097129},
{-0.7968665443767248,0.33925883688278996,-0.29218545753831426},
{-0.8067031743384777,0.42991979429469007,-0.22532585248820583},
{-0.7900929009074918,0.5658574371829562,-0.21436279229896127},
{-0.6818254194527077,0.7302248019064321,-0.22937002748834034},
{-0.5721926658310785,0.8552144467097372,-0.13612591919181052},
{-0.5862509884505936,0.8535500841864042,-0.08861466295852004},
{-0.5885856146145447,0.8501116209513873,-0.0},
{-0.5862509884505936,0.8535500841864042,0.08861466295852004},
{-0.5721926658310785,0.8552144467097372,0.13612591919181052},
{-0.6218599547061007,0.7677057725514668,0.2811427833692851},
{-0.6775499335653615,0.6525968681581737,0.37455795413589243},
{-0.672082389710431,0.5448458017073972,0.44826758904124325},
{-0.6594603463208121,0.35879868959692734,0.48837151756079983},
{-0.5966675094272635,0.1661016584452681,0.4740227115015304},
{-0.5717128302231882,0.05419022361845541,0.450199841847905},
{-0.5485322517307972,-0.038824725520046025,0.42286857776080305},
{-0.5510185748021754,-0.1371404595017671,0.3866625066569122},
{-0.5402491702394338,-0.1706149104073761,0.386876603710657},
{-0.521344077634389,-0.20075525694336108,0.3856856216076645},
{-0.5008090501729453,-0.22972613866818722,0.38765445381044344},
{-0.47822019720597964,-0.2566883812003421,0.39207410555307515},
{-0.45088032620214424,-0.27608084046541903,0.39380947513945896},
{-0.4194392593748151,-0.2886254216044368,0.39284334873612814},
{-0.3879895856307526,-0.3012506925878309,0.39414406902747223},
{-0.3581709226076806,-0.3167087150411249,0.39919417742082985},
{-0.39372286803982853,-0.31715519884667315,0.3477721533967735},
{-0.3687488232731029,-0.34601311478937263,0.3119652280563968},
{-0.35818060538900576,-0.37864623958428595,0.2898293140825296},
{-0.44185382227792813,-0.35626610434810674,0.20287148259520058},
{-0.5234409377235781,0.05143601026374822,-0.49060824004690773},
{-0.5966675094272635,0.1661016584452681,-0.4740227115015304},
{-0.7021183773810229,0.36245662920864785,-0.44447731808474583},
{-0.7475209390146157,0.49737758005777394,-0.37020823359172017},
{-0.776687628095128,0.47728903640187853,-0.322448452637751},
{-0.7841250800174291,0.4530110760259714,-0.2749565619671108},
{-0.7726531358763187,0.5810830728844468,-0.26404299154908367},
{-0.7273538572435273,0.6216883543037274,-0.3218158442578417},
{-0.6218599547061007,0.7677057725514668,-0.2811427833692851},
{-0.5306072717687752,0.8658655061673938,-0.1783094939670893},
{-0.47204258272053884,0.9214747951822784,-0.08233161374309429},
{-0.5074417553806678,0.907807011409544,-0.052884124004152835},
{-0.5096730985438174,0.9054756128393681,-0.0},
{-0.5074417553806678,0.907807011409544,0.052884124004152835},
{-0.5306072717687752,0.8658655061673938,0.1783094939670893},
{-0.5456586174064133,0.7948541396579828,0.330878927578175},
{-0.6147796898282383,0.6834182369806937,0.41124601257685706},
{-0.6277201891369952,0.5654916432217841,0.4822347859298429},
{-0.6146097032227524,0.3707698349085784,0.5278116376272882},
{-0.5499932758463021,0.1777339064105392,0.5157931542736032},
{-0.5234409377235781,0.05143601026374822,0.49060824004690773},
{-0.5043120652834635,-0.051005664427075194,0.470547668870396},
{-0.5337929068247471,-0.12283683975534838,0.4151438699925228},
{-0.506346525226335,-0.17868819830336152,0.40179454213892646},
{-0.48851191789001436,-0.2090749178308418,0.40901251768452423},
{-0.4662092449044363,-0.23264280757623845,0.4171955437688613},
{-0.43855737316901294,-0.24793622274700505,0.42659322097720787},
{-0.4094186565678844,-0.26205479378365437,0.4356939595582501},
{-0.38171299160287686,-0.2802110846328881,0.4419199879503166},
{-0.35563618562967664,-0.3009881816274604,0.4402846737709592},
{-0.3305588578621495,-0.3227443154004637,0.4327955803482574},
{-0.30538039882300416,-0.34419275190024584,0.4273710710769943},
{-0.32787027224753496,-0.33121997665373837,0.4013534376563366},
{-0.36517910455790037,-0.3292823445241182,0.34454563548631767},
{-0.3279262172063024,-0.3619262279649483,0.30562300628842853},
{-0.31987659833133403,-0.39179438075923767,0.29228874053911574},
{-0.40913678004486354,-0.3684556501718694,0.19646470895173132},
{-0.37534817667848325,-0.3783062663733142,0.1961484047617767},
{-0.34074514381619936,-0.384314970117861,0.20192041829615326},
{-0.3062346353088001,-0.3825978902295357,0.20946868427139761},
{-0.2726579772669812,-0.3748968514822725,0.21764848276195958},
{-0.24096946158356514,-0.36397252241832845,0.22663302796710008},
{-0.20849448888362915,-0.3525952543612861,0.23694626594296844},
{-0.19125806226028397,-0.29892897679898006,0.16147006137807496},
{-0.20956712588153656,-0.3200094676084068,0.13746321887927185},
{-0.21587707171175438,-0.3589536140981296,0.13306938788684058},
{-0.1931397494311366,-0.36108382598966093,0.10692480244436435},
{-0.16071641823160138,-0.35150863112368674,0.10884952419888433},
{-0.12753675422411337,-0.355401109216394,0.1089065450222435},
{-0.10122110631155963,-0.3632398586313927,0.09775413266486281},
{-0.0757661500723519,-0.37896469550342393,0.07689742169050603},
{-0.043385853456483985,-0.3825193521143429,0.07219481756026187},
{-0.01171562747112649,-0.38030522278466034,0.06515543553688333},
{0.01827302215743126,-0.3656089124622775,0.0546313281010452},
{0.025197286669499767,-0.33483488168179154,0.08587981516646316},
{0.032464751986314995,-0.308735482552166,0.0702141508469744},
{0.027372684873881763,-0.27766881660274234,0.05083890541536442},
{0.06600052717364992,-0.20742561741179255,0.07883075036175947},
{0.09045492934259294,-0.18142089436623504,0.06803660091340905},
{0.14278928654039602,-0.11205882827587317,0.11424821271994706},
{0.1724637837081825,-0.15231875716122367,0.19174381512342856},
{0.19234145790410817,-0.17978342845769432,0.18546291763718617},
{0.22257325293038616,-0.19592354906211504,0.18520148254140736},
{0.24983888927739556,-0.21572160927825623,0.16539804300230773},
{0.27116790480750097,-0.23938417510772095,0.14681678563935943},
{0.28311860869191,-0.2609574119001382,0.12437747785063773},
{0.3168727843913565,-0.25218158442578414,0.11638810739280354},
{0.37273274985610305,-0.3059748140099087,0.11184257949294503},
{0.4001780555899234,-0.3257922397887002,0.10622871805354578},
{0.7343566598707887,-0.25046988386041735,0.13434428742798432},
{0.7163671280332657,-0.2282037902709565,0.16910116892687888},
{0.7511154026154269,-0.18312829147323517,0.19540928578729083},
{0.7442406278745758,-0.15373459496387784,0.20085746407957095},
{0.7664055901924184,-0.11301957535624564,0.13899202246405268},
{0.7665755767979042,-0.07142880197098392,0.11381786688327408},
{-0.5499932758463021,0.1777339064105392,-0.5157931542736032},
{-0.6594603463208121,0.35879868959692734,-0.48837151756079983},
{-0.7134687488232732,0.51693572246997,-0.4146285308531068},
{-0.6775499335653615,0.6525968681581737,-0.37455795413589243},
{-0.3296120970214689,0.13313393976234156,-0.620306944168007},
{-0.41246980854989596,0.2785876049640392,-0.6014169136672458},
{-0.4590848695783149,0.2403287842192182,-0.5785494117710346},
{-0.5044347138469153,0.20388709876974886,-0.5520444116903447},
{-0.6146097032227524,0.3707698349085784,-0.5278116376272882},
{-0.672082389710431,0.5448458017073972,-0.44826758904124325},
{-0.6147796898282383,0.6834182369806937,-0.41124601257685706},
{-0.5456586174064133,0.7948541396579828,-0.330878927578175},
{-0.2762976271806431,0.15646513929756803,-0.6437737026417856},
{-0.3610230396402309,0.30655147743105055,-0.6265448070705821},
{-0.4829733669720329,0.45486048725907363,-0.6135903215221332},
{-0.5249159480787748,0.43092787941709665,-0.590207480486506},
{-0.5706423449544641,0.39889616292893376,-0.5618197173703718},
{-0.6277201891369952,0.5654916432217841,-0.4822347859298429},
{-0.5646648412830761,0.7006116290203716,-0.4405794606690802},
{-0.4780071760168266,0.8002334626163953,-0.3749893758371572},
{-0.43557077306250236,0.8884758764261932,-0.22955292446892636},
{-0.4811357902494392,0.8797269455666312,-0.21533644975443392},
{-0.40550896464171027,0.938621925044514,-0.11938116268686423},
{-0.37778931343701083,0.9547728042948515,-0.044070641269089876},
{-0.4023868055966476,0.9521950327331802,-0.0},
{-0.37778931343701083,0.9547728042948515,0.044070641269089876},
{-0.47204258272053884,0.9214747951822784,0.08233161374309429},
{-0.4811357902494392,0.8797269455666312,0.21533644975443392},
{-0.4780071760168266,0.8002334626163953,0.3749893758371572},
{-0.5646648412830761,0.7006116290203716,0.4405794606690802},
{-0.5820196130115064,0.5756359704567583,0.5192326933732121},
{-0.5706423449544641,0.39889616292893376,0.5618197173703718},
{-0.5044347138469153,0.20388709876974886,0.5520444116903447},
{-0.4712679602145274,0.052799130701409944,0.5252876592952012},
{-0.45555710958218804,-0.05723169281914176,0.5143988337627827},
{-0.4890347880815721,-0.1175511170164123,0.4513972791384476},
{-0.46365299063459875,-0.17368542795203795,0.43569180782906664},
{-0.42844424600719755,-0.18755224667423356,0.44240089942279864},
{-0.40770480427333416,-0.2142304609541843,0.4606841422938509},
{-0.38186684023948747,-0.24114428957971348,0.4691770173805925},
{-0.35645491858394707,-0.27084353163310865,0.4680764079033013},
{-0.3341092110147017,-0.3034454563548632,0.4666906943092143},
{-0.31087483929272663,-0.33497474407871025,0.46367504585872826},
{-0.28972979660779896,-0.366095203257718,0.4524860541052303},
{-0.265664857421045,-0.3946518771147463,0.44105499281860383},
{-0.2343206184069673,-0.4166769770356703,0.43891617401033906},
{-0.28047520939014614,-0.3671161987552247,0.4219325755660393},
{-0.2971371243215329,-0.3452944372421287,0.4001204968342685},
{-0.33723782524731444,-0.34426160723411353,0.34448646293377516},
{-0.28518642043712383,-0.373668214118571,0.30465365229132263},
{-0.2811562316766812,-0.4027746547819492,0.29448458017073975},
{-0.2424208029177448,-0.401111368123208,0.29768958078936186},
{-0.20367569137748326,-0.3909057166065079,0.3028311376730125},
{-0.16501126968159788,-0.3818092814838324,0.31002221660381823},
{-0.17193338246448303,-0.3438613856060076,0.24736493864882167},
{-0.17382260068747749,-0.31690559826140285,0.19406875850605443},
{-0.17867044653759878,-0.3037929606179766,0.12812686595265121},
{-0.19165720802379815,-0.33971070001129655,0.1330866017203075},
{-0.1560762142476748,-0.3411706482622097,0.1356536146360619},
{-0.12389280085208478,-0.3474805940924275,0.13574936658472164},
{-0.0927443691936933,-0.35821234339446034,0.1308068446505323},
{-0.06055450061055317,-0.3663544866243134,0.12167813359010635},
{-0.02885522628122026,-0.3670936055987993,0.11062900423352717},
{-0.0010677956072448825,-0.35540648853935247,0.09987896523343573},
{0.015824354346761906,-0.29053830884844833,0.10980489195629839},
{0.03084342404664948,-0.26532004281941074,0.09722911074412174},
{0.052842703217373055,-0.23688709339042585,0.09903656325814833},
{0.08821820685648503,-0.1564285599014508,0.10317864193612591},
{0.10665207077037282,-0.12097882160551271,0.10031791798684218},
{0.15565662705691863,-0.1844031910143789,0.1841342248664583},
{0.2460636804251817,-0.22252860454983134,0.19396977896361964},
{0.2837662791761029,-0.21665545974383663,0.17967153854015933},
{0.3176355723868594,-0.2155882020688876,0.1619778694653491},
{0.3308913000209794,-0.24799754702873095,0.14213462293635723},
{0.3159152649047591,-0.2884909385304765,0.14654459189766378},
{0.2788259089710969,-0.323648041657477,0.14403137221149345},
{0.296391550159497,-0.3252801282430593,0.12115418753395699},
{0.33421464574468657,-0.31330898293140824,0.1198749845344465},
{0.3610004464838056,-0.3435816608121702,0.11632032792352755},
{0.3462428118796968,-0.3887959461422185,0.12462815430049974},
{0.3670780055622199,-0.4397833208712351,0.11511428371625147},
{0.40557351651721113,-0.42996498060754074,0.13611623641048537},
{0.42317035777877,-0.37996094611532194,0.1324830416843736},
{0.4663168313636046,-0.37681404218465064,0.12759000952140165},
{-0.3010027057994481,0.3095854155795952,-0.6480384298832149},
{-0.4242225533494354,0.46699946744702714,-0.6329913877039436},
{-0.47862257056326896,0.597709484284308,-0.5749280515554313},
{-0.5322694825629246,0.5865183408016268,-0.5505554150954561},
{-0.5820196130115064,0.5756359704567583,-0.5192326933732121},
{-0.4828819184817399,0.7228519018596319,-0.47248745272919956},
{-0.3833536851051927,0.823071916168631,-0.3932209772078087},
{-0.3640763433514258,0.9004631597067193,-0.2583871713906088},
{-0.327622823391448,0.9471169518604388,-0.15863085472062488},
{0.13285152530702488,0.1578056665788044,-0.6335024233849927},
{0.06610488603904312,0.2884941661242516,-0.6575888798635804},
{-0.028460383976072777,0.42151406423987486,-0.6687628095127948},
{-0.09136511078715634,0.42280940520826055,-0.6758226329634153},
{-0.1815096531950489,0.43215113745783956,-0.67750098172644},
{-0.24172902198529295,0.45173725234941936,-0.6714331054293508},
{-0.30301457258589437,0.4675384756074601,-0.6636546044314863},
{-0.3642162057483445,0.4728500190965966,-0.6512617201998957},
{0.12395627686299403,0.3022856743250295,-0.6468743443950145},
{0.03321893306508442,0.42795849314405293,-0.6587852412895313},
{-0.06546689833617542,0.6040592371044181,-0.626579234737516},
{-0.12523870745627957,0.5980354712555878,-0.6320607648321382},
{-0.1847480056160132,0.604283016939488,-0.6288600676718828},
{-0.24436489023491506,0.613597852574275,-0.6223048247147615},
{-0.30439383099243134,0.6135720318240746,-0.617061060694901},
{-0.3636481492439362,0.6100324373174393,-0.6073890380156753},
{-0.4218857754563011,0.6051587707171177,-0.5930714320295648},
{0.09392028919240224,0.44072470238895733,-0.6474251870659559},
{0.037811799006976975,0.6053212262704616,-0.61722674384202},
{-0.045204064616427383,0.7078209976492358,-0.5537765536829535},
{-0.1314432185565125,0.7145828066079604,-0.5514785069151197},
{-0.23847775918922848,0.723810497210821,-0.5385014282102455},
{-0.3174225511977063,0.7256082669435224,-0.5303657401679425},
{-0.39968315787774955,0.7311446661323205,-0.5024847092744907},
{0.1554479093261322,0.44885285937911856,-0.6363265679381593},
{0.09758145639789775,0.58436553575367,-0.6092857872908116},
{0.09472396004238906,0.7102051135844042,-0.544402545495624},
{0.11243807054444127,0.820910504203941,-0.4362243608019495},
{0.02903274393884785,0.8158270440082412,-0.45288950332711125},
{-0.11418850223510871,0.8207738694007973,-0.44657310230934333},
{-0.20642990473219044,0.829371103352932,-0.42711931876254056},
{-0.2851702824682486,0.8301833811196523,-0.41452739958148865},
{0.21696369494935366,0.4456435553021297,-0.6226749221343002},
{0.1576426730931645,0.5779017412868417,-0.6033696079011496},
{0.1604184037397053,0.7080157291403304,-0.5331124224705078},
{0.17024427505554152,0.8160432927911693,-0.4323146688757753},
{0.12570993614743647,0.9117704965653024,-0.29865463132810105},
{0.04872106596663743,0.9155198846673159,-0.29962075773143193},
{-0.09654970225447428,0.90911526275303,-0.3119856694836388},
{-0.1707929659972996,0.9110690328515254,-0.30632877346057225},
{-0.28016320865855826,0.908488033696079,-0.2766413659176856},
{-0.22666906943092147,0.9548384320349441,-0.17285270875807573},
{-0.22514564516909905,0.973620876076537,-0.09593161804655267},
{-0.287625405466468,0.9670172192127899,-0.08297605663351211},
{-0.14270214150846977,1.0,-0.0},
{-0.287625405466468,0.9670172192127899,0.08297605663351211},
{-0.327622823391448,0.9471169518604388,0.15863085472062488},
{-0.40550896464171027,0.938621925044514,0.11938116268686423},
{-0.43557077306250236,0.8884758764261932,0.22955292446892636},
{-0.3833536851051927,0.823071916168631,0.3932209772078087},
{-0.39968315787774955,0.7311446661323205,0.5024847092744907},
{-0.4828819184817399,0.7228519018596319,0.47248745272919956},
{-0.5322694825629246,0.5865183408016268,0.5505554150954561},
{-0.5249159480787748,0.43092787941709665,0.590207480486506},
{-0.4590848695783149,0.2403287842192182,0.5785494117710346},
{-0.4221343001769797,0.06966330817603299,0.5607105009763471},
{-0.4005330909051787,-0.048891590504419095,0.550003496559923},
{-0.45869971005449256,-0.11522940122756148,0.46633996245232573},
{-0.4274727402809083,-0.16459114455854584,0.4731232887028839},
{-0.39381539239471325,-0.18358768565388361,0.47998300133945143},
{-0.36999037101190446,-0.2117591999870896,0.49796715385401596},
{-0.33831476570358854,-0.2361167743427812,0.5034067252295626},
{-0.31742793052066465,-0.27145569858577595,0.5119781384314971},
{-0.2888497393718027,-0.3007095326982146,0.5115972823660414},
{-0.26792309719898655,-0.33339107139975366,0.4979499400205491},
{-0.2481271887120287,-0.3679446144908202,0.48279638724670115},
{-0.22129727752465075,-0.3963711087322549,0.4719914791524339},
{-0.18664905834951617,-0.4149007245948025,0.46631629343130876},
{-0.15278837205549312,-0.4368408312129835,0.4638923705062481},
{-0.19960892322092344,-0.429147323517862,0.4455166032803112},
{-0.2547566663259762,-0.38692501761728265,0.4145715100297477},
{-0.26770792428065004,-0.3624447946981393,0.3997815994878885},
{-0.3086155236501934,-0.3536614361716434,0.34776677407381507},
{-0.2788743228777226,-0.3540110921639403,0.35509341194317284},
{-0.24251978246017958,-0.37780168587981516,0.3161654034223253},
{0.2767624006842499,0.44361339881762485,-0.6047693077349285},
{0.21344669359914362,0.5709893112852816,-0.5831745536506775},
{0.19893543198653016,0.7019629149475247,-0.5263602962931085},
{0.2343561219384928,0.8204737031797178,-0.41503198007498776},
{0.186934162466312,0.9120104143692477,-0.284396197894533},
{0.10641430469561101,0.9631301204430411,-0.16977788775504715},
{0.046997530890762085,0.958224177904969,-0.18733384616212206},
{-0.07289897093551806,0.9598164575006591,-0.18963727225291427},
{-0.14515941623587258,0.9558206964071501,-0.18287761502337319},
{-0.12125585673787098,0.9783428457694314,-0.09902257701845647},
{0.3341748387547943,0.45784816323017585,-0.583366057547997},
{0.26623291392545334,0.5708300833257126,-0.5713615604340038},
{0.23812272387397324,0.7039984507549879,-0.520402158184371},
{0.2986164381350963,0.8171492815914189,-0.387333846162122},
{0.24842089974555803,0.9069108162046724,-0.25935437365853137},
{0.1515414449937331,0.9653367187205818,-0.1450243952296164},
{0.12449313329424358,0.982257917018564,-0.05796005314771083},
{0.07532827318353712,0.9839362657815888,-0.07464025777715617},
{-0.05499873585910477,0.9841729559917588,-0.08862649746902855},
{0.15986971279794723,0.979272392776645,-0.0},
{0.12449313329424358,0.982257917018564,0.05796005314771083},
{0.07532827318353712,0.9839362657815888,0.07464025777715617},
{-0.05499873585910477,0.9841729559917588,0.08862649746902855},
{-0.12125585673787098,0.9783428457694314,0.09902257701845647},
{-0.22514564516909905,0.973620876076537,0.09593161804655267},
{-0.22666906943092147,0.9548384320349441,0.17285270875807573},
{-0.28016320865855826,0.908488033696079,0.2766413659176856},
{-0.3640763433514258,0.9004631597067193,0.2583871713906088},
{-0.2851702824682486,0.8301833811196523,0.41452739958148865},
{-0.3174225511977063,0.7256082669435224,0.5303657401679425},
{-0.3636481492439362,0.6100324373174393,0.6073890380156753},
{-0.4218857754563011,0.6051587707171177,0.5930714320295648},
{-0.47862257056326896,0.597709484284308,0.5749280515554313},
{-0.4829733669720329,0.45486048725907363,0.6135903215221332},
{-0.41246980854989596,0.2785876049640392,0.6014169136672458},
{-0.3757204258272054,0.09810056106338458,0.5935501917728635},
{-0.35252801282430596,-0.01872004389527532,0.5815758188674374},
{-0.4000220552241295,-0.1105891972436349,0.5293759447435946},
{-0.35413858211805466,-0.14138474531595452,0.5376794676622001},
{-0.3251128312990527,-0.1776887200976885,0.5390641053916955},
{-0.2940902757978881,-0.21158706165242042,0.5438355648558072},
{-0.2622167114047026,-0.244419221396795,0.5479410641376676},
{-0.23143084611370815,-0.27852197722394656,0.5445445596217261},
{-0.20026412475725808,-0.31257093982151407,0.5398258175226066},
{-0.16850567787538262,-0.34601634238314766,0.5371167904807501},
{-0.1403416945943184,-0.381621005180288,0.529991339290037},
{-0.11162794450690437,-0.4187663060727177,0.5204161444240628},
{-0.09465510470852141,-0.44911537033948906,0.4909385304765542},
{-0.12000032275937751,-0.45937911854414004,0.46157388231117236},
{-0.16494564194150524,-0.4411066343190046,0.4409990478598364},
{-0.22294980553747507,-0.3836909686546851,0.41187969682135805},
{-0.2379645717789959,-0.3779071206098001,0.39554484472584284},
{-0.21007600983340238,-0.3952812579008806,0.38470873655841675},
{-0.2503273318020194,-0.35731722405418054,0.36839002243177676},
{-0.21026105854317176,-0.37253532870352934,0.34942037795123104},
{0.3239659596443192,0.5760308127619058,-0.557396838033965},
{0.28250321414546764,0.7027837996309785,-0.5033550837291618},
{0.36415165387284354,0.7048096526571166,-0.47306196442115794},
{0.36329634152245593,0.8146941585931996,-0.35250380587099306},
{0.30661441550966395,0.9091432352324137,-0.21862214021743223},
{0.18982393475957118,0.9666406666057011,-0.11319924474305663},
{0.22514456930450732,0.9678875936674609,-0.09067494365159202},
{0.24831654088016483,0.9672033437871511,-0.06563311941559036},
{0.2651484424170374,0.9669870950042228,-0.0},
{0.24831654088016483,0.9672033437871511,0.06563311941559036},
{0.22514456930450732,0.9678875936674609,0.09067494365159202},
{0.18982393475957118,0.9666406666057011,0.11319924474305663},
{0.1515414449937331,0.9653367187205818,0.1450243952296164},
{0.10641430469561101,0.9631301204430411,0.16977788775504715},
{0.046997530890762085,0.958224177904969,0.18733384616212206},
{-0.07289897093551806,0.9598164575006591,0.18963727225291427},
{-0.14515941623587258,0.9558206964071501,0.18287761502337319},
{-0.1707929659972996,0.9110690328515254,0.30632877346057225},
{0.6334222714729124,0.5927034863392094,-0.3816091706697795},
{0.5871514871138318,0.587459722319349,-0.41852961586254755},
{0.5374422395197341,0.5822439307788723,-0.4508389054153645},
{0.48633759555022404,0.5788657159609892,-0.48142681162148937},
{0.4330973603662243,0.5776037267949456,-0.508417026633028},
{0.37835306648305245,0.5785537152294012,-0.5326616352065929},
{0.7537760157506576,0.5649149798006423,-0.0},
{0.7258508744089468,0.6202208750006725,-0.05758780399898868},
{0.7254248320306407,0.6103584242887191,-0.11488835215199815},
{0.7209094283393493,0.6117764138205566,-0.17270531530901523},
{0.7127888024013298,0.6140411087860482,-0.23018768457801905},
{0.6957858383943796,0.6162724519491978,-0.2859518980941059},
{0.6692614727510395,0.6076945835597133,-0.3371716595749259},
{0.5970591241386359,0.7401141492331774,-0.2647401518044939},
{0.5694244662366794,0.7332651952425269,-0.31228906329849326},
{0.5114385923387683,0.7201073712862498,-0.3741276082992195},
{0.42915324077311634,0.7042749479550503,-0.43545189002512147},
{0.7269278148652211,0.6236270622979393,-0.0},
{0.6774488022937434,0.7159771271187809,-0.06918024497436753},
{0.6698542741410566,0.7132024723368318,-0.10963920880917928},
{0.6576281489211768,0.717629655131605,-0.15560444762422201},
{0.6264226964394262,0.73484026100475,-0.2125230638471842},
{0.6792056891719608,0.7175640273915127,-0.0},
{0.5791890132707898,0.8237217383820074,-0.0},
{0.5681538701539024,0.8231084955647482,-0.09634367418516707},
{0.5501342141078124,0.8189556582408538,-0.14839615485994934},
{0.4974760216679129,0.8112933506188912,-0.24717558648068555},
{0.43360409258890675,0.8145112616126137,-0.3079554807231962},
{0.4178491315083084,0.9151562424353271,-0.0},
{0.40742615534408844,0.9148388623807809,-0.07953436580471981},
{0.3925749205205033,0.9097392642162058,-0.11774154504914011},
{0.40742615534408844,0.9148388623807809,0.07953436580471981},
{0.3925749205205033,0.9097392642162058,0.11774154504914011},
{0.36092836355616287,0.9110184672157162,0.16356692146726415},
{0.30661441550966395,0.9091432352324137,0.21862214021743223},
{0.24842089974555803,0.9069108162046724,0.25935437365853137},
{0.186934162466312,0.9120104143692477,0.284396197894533},
{0.12570993614743647,0.9117704965653024,0.29865463132810105},
{0.04872106596663743,0.9155198846673159,0.29962075773143193},
{-0.09654970225447428,0.90911526275303,0.3119856694836388},
{-0.11418850223510871,0.8207738694007973,0.44657310230934333},
{-0.20642990473219044,0.829371103352932,0.42711931876254056},
{-0.23847775918922848,0.723810497210821,0.5385014282102455},
{-0.30439383099243134,0.6135720318240746,0.617061060694901},
{-0.3642162057483445,0.4728500190965966,0.6512617201998957},
{-0.4242225533494354,0.46699946744702714,0.6329913877039436},
{0.36092836355616287,0.9110184672157162,-0.16356692146726415},
{0.6226915980354712,-0.5280601623479669,0.24020936324954145},
{0.6438172751577487,-0.4178216969612204,0.21119652280563972},
{0.5944523042329892,-0.5121857802976917,0.252307460583011},
{0.5649897523897642,-0.5047580111567158,0.2502288901918805},
{0.5516931419011604,-0.50572628928923,0.2498706272828502},
{0.5301769259321022,-0.5055347853919107,0.23943258901434666},
{0.5326212902844049,-0.509504725735219,0.25381044341759146},
{0.5594006358359737,-0.43743040500922553,0.26840562246835614},
{0.5957078382114828,-0.4273635400248525,0.2655180019042804},
{0.615332684228363,-0.4197195221009484,0.24344126048295564},
{0.6145462272118432,-0.3890240294356552,0.25837103342173356},
{0.6363077403078049,-0.3375159362442643,0.2556953581822192},
{0.6722093417322496,-0.3104170589089657,0.20662840174935584},
{0.6950940574619279,-0.4314830255464047,0.18778463342603702},
{0.6849292887997117,-0.5395019822805102,0.2215452643130336},
{0.6177931865495409,-0.5257728742260499,0.22840390108500946},
{0.6022566259810541,-0.5265098414713524,0.22790362404987707},
{0.5805973200213022,-0.5325766419038499,0.2116806618718968},
{0.5760356541525683,-0.5170228675018962,0.23433406671436333},
{0.7140120604420728,-0.5426757828259735,0.2116010478921123},
{0.6687332232365235,-0.5345443982420373,0.2157883128829406},
{0.6508996917647945,-0.5413180417112702,0.20936647713518777},
{0.6420625400087145,-0.547197641704815,0.20071760168265224},
{0.635507297051593,-0.5357977804913474,0.21465219987412384},
{0.7397800932774601,-0.5408328267804214,0.18865608374529982},
{0.6937234059721243,-0.5353642070608994,0.202856420490917},
{0.6866130168856948,-0.5349650612973851,0.21187862095676638},
{0.7774880713513398,-0.5312942113105644,0.162198421706644},
{0.7219347272952227,-0.5314351495720748,0.1795822417790497},
{0.7082023916469873,-0.5404724121422078,0.17612979230434056},
{0.6942591865387823,-0.5524123573807,0.1709419732432476},
{0.7181369252865836,-0.42978531122072977,0.17415773250778657},
{0.719104127554506,-0.33484779205689175,0.1663641694056386},
{0.7504709597250091,-0.5222784660322651,0.15756682463945088},
{0.7453294028413584,-0.5210509045331555,0.17134004314217013},
{0.7764315723223075,0.1886044422448991,0.17154338154999813},
{0.7857733045718867,0.24602010790921855,0.2002646626895539},
{0.8011990510874301,0.29798114009370785,0.1851240202908062},
{0.7841810249761966,0.35944958767489527,0.1183020705014067},
{0.7603829002081799,0.48061560971936074,0.06310914108350323},
{0.7511422992302189,0.5592720700172676,0.06030974141594539},
{0.7258508744089468,0.6202208750006725,0.05758780399898868},
{0.6774488022937434,0.7159771271187809,0.06918024497436753},
{0.5681538701539024,0.8231084955647482,0.09634367418516707},
{0.5501342141078124,0.8189556582408538,0.14839615485994934},
{0.4974760216679129,0.8112933506188912,0.24717558648068555},
{0.43360409258890675,0.8145112616126137,0.3079554807231962},
{0.36329634152245593,0.8146941585931996,0.35250380587099306},
{0.2986164381350963,0.8171492815914189,0.387333846162122},
{0.2343561219384928,0.8204737031797178,0.41503198007498776},
{0.17024427505554152,0.8160432927911693,0.4323146688757753},
{0.11243807054444127,0.820910504203941,0.4362243608019495},
{0.02903274393884785,0.8158270440082412,0.45288950332711125},
{-0.045204064616427383,0.7078209976492358,0.5537765536829535},
{-0.1314432185565125,0.7145828066079604,0.5514785069151197},
{-0.1847480056160132,0.604283016939488,0.6288600676718828},
{-0.24436489023491506,0.613597852574275,0.6223048247147615},
{-0.30301457258589437,0.4675384756074601,0.6636546044314863},
{-0.3010027057994481,0.3095854155795952,0.6480384298832149},
{-0.3610230396402309,0.30655147743105055,0.6265448070705821},
{0.7551531224280112,-0.21487813143837714,0.19982463407155576},
{0.7354110071706376,-0.17752949213811947,0.24562849319784613},
{0.7265770830083326,-0.13692636244802228,0.22270074288450056},
{0.7368268449732917,-0.100579353082621,0.16831578777495065},
{0.745435913435935,-0.0684680226146737,0.1383820072405687},
{0.740973227109636,-0.031661619068624004,0.11167689634582592},
{0.715316008327192,-0.22086962134945695,0.23011344992119293},
{0.7082368193139211,-0.20158905200191501,0.301507824225243},
{0.7219691549621565,-0.19255286529637378,0.30496134956454385},
{0.7365331339397624,-0.1773519744804919,0.30660634652522634},
{0.702755289219299,-0.15798426010102368,0.3091701318472057},
{0.6789560885866905,-0.1475559046138453,0.22764972000624004},
{0.6875242741948498,-0.10971129173682198,0.1681361183881397},
{0.6910929170454607,-0.08762379166958044,0.13532009661264033},
{0.6962194118248277,-0.046209460077354644,0.10098818162746037},
{0.6922397887001941,0.06347278331549194,0.12298100561063384},
{0.7202047370317971,0.07178598901542255,0.10828469528825102},
{0.6814176667724601,-0.23592527044546174,0.22240488012178788},
{0.6771260429162386,-0.253913726418393,0.27323948207878557},
{0.6499410964136054,-0.30130771341119006,0.3362765402346461},
{0.6678456349483854,-0.22577126042916237,0.3946518771147463},
{0.6849185301537949,-0.20905232467441645,0.3895802514295551},
{0.6925162859002565,-0.18086682410151858,0.37966723508179256},
{0.6866603549277288,-0.15378408473509522,0.36431787495225854},
{0.6655798641183021,-0.16144316476328288,0.29650397800932776},
{0.5905673571924238,-0.10459017628041334,0.23608880186339748},
{0.5388053599573958,-0.07638638600945682,0.22261574958175764},
{0.48926932656255884,-0.06688434993571707,0.2144843649978214},
{0.44891256986395695,-0.03601456720657136,0.20463697639015155},
{0.4320666820873925,0.012463891294641677,0.18465494332883264},
{0.43313286389774985,0.04463762190890656,0.17098715955609828},
{0.6816392948783466,0.10653103600380857,0.1325196210804908},
{0.719951908852752,0.11061394212924364,0.12620752352108963},
{0.7341135144730685,0.13844548325147799,0.14710511734993034},
{0.7529228551294534,0.17540035611117985,0.17803837608998532},
{0.7561041867270586,0.1884064831600295,0.21569471266346418},
{0.7687875543984035,0.2055568406160401,0.2102562171525092},
{0.7489808872655287,0.22935711711324014,0.3180686078850116},
{0.7801712776429959,0.2975895253823354,0.24931870874731707},
{0.7795020898669693,0.3712894775063611,0.18249891068710095},
{0.7574156656643195,0.48545700038193196,0.12603430932182877},
{0.7476037805881751,0.5573645620962147,0.12083250402104391},
{0.7254248320306407,0.6103584242887191,0.11488835215199815},
{0.6698542741410566,0.7132024723368318,0.10963920880917928},
{0.6576281489211768,0.717629655131605,0.15560444762422201},
{0.6264226964394262,0.73484026100475,0.2125230638471842},
{0.5970591241386359,0.7401141492331774,0.2647401518044939},
{0.5694244662366794,0.7332651952425269,0.31228906329849326},
{0.5114385923387683,0.7201073712862498,0.3741276082992195},
{0.42915324077311634,0.7042749479550503,0.43545189002512147},
{0.36415165387284354,0.7048096526571166,0.47306196442115794},
{0.28250321414546764,0.7027837996309785,0.5033550837291618},
{0.23812272387397324,0.7039984507549879,0.520402158184371},
{0.19893543198653016,0.7019629149475247,0.5263602962931085},
{0.1604184037397053,0.7080157291403304,0.5331124224705078},
{0.09472396004238906,0.7102051135844042,0.544402545495624},
{0.09758145639789775,0.58436553575367,0.6092857872908116},
{0.037811799006976975,0.6053212262704616,0.61722674384202},
{-0.06546689833617542,0.6040592371044181,0.626579234737516},
{-0.12523870745627957,0.5980354712555878,0.6320607648321382},
{-0.1815096531950489,0.43215113745783956,0.67750098172644},
{-0.24172902198529295,0.45173725234941936,0.6714331054293508},
{-0.24213462293635726,0.28861143536474504,0.6624324222553349},
{-0.2762976271806431,0.15646513929756803,0.6437737026417856},
{-0.3296120970214689,0.13313393976234156,0.620306944168007},
{0.7494994539987198,0.19970090964351228,0.30766069382507516},
{0.6971242139464328,0.19873693496936476,0.40964512606443354},
{0.7527399581488674,0.2779076585420959,0.3069452438716063},
{0.7650962629843407,0.37186936852127794,0.24542623065460983},
{0.7531982764649242,0.48784541977546714,0.18934786467775166},
{0.7443180901251769,0.5593775047472526,0.181549998117237},
{0.7209094283393493,0.6117764138205566,0.17270531530901523},
{0.7419576432110254,0.1813240665529837,0.2993270466979026},
{0.717132067757952,0.16131836447064776,0.39700694470593934},
{0.6789668472326074,0.1315997568546023,0.44410076547765703},
{0.6589794348483301,0.17236426623345188,0.4607949563467942},
{0.7187361818641507,0.2664615351511859,0.3629590579729635},
{0.7438726821842204,0.3497130131201688,0.3021554947094359},
{0.7410732825166624,0.4769458355971318,0.2500201724610941},
{0.7372421287056811,0.553788388193462,0.24139281430039217},
{0.7127888024013298,0.6140411087860482,0.23018768457801905},
{0.7080603775208854,0.19669709570353477,0.21670925297342078},
{0.6934845640327708,0.20427118242897951,0.2877927024104746},
{0.6587803998988687,0.17734982275130853,0.393565253877147},
{0.7125435052744262,0.14872859701877925,0.38285179427317284},
{0.675294921381195,0.10471067311468181,0.4329440496619096},
{0.6391953608718807,0.09851692066036571,0.47525457645900687},
{0.6150239110905501,0.10871073766655731,0.4863714852848621},
{0.6798651941666622,0.24808684378984064,0.41341495559368896},
{0.7129092992355981,0.32894344717773827,0.3545027622823391},
{0.7228718053545782,0.4552628606163629,0.3074250794794967},
{0.7174429926249483,0.5447554290816958,0.2984760378058818},
{0.6957858383943796,0.6162724519491978,0.2859518980941059},
{0.7042658031060212,0.17613732335648236,0.17817070743476227},
{0.4367122653942775,0.15391856780905558,0.1899223763697101},
{0.434186135333007,0.09249853413449385,0.22353238621387114},
{0.42930063422217685,0.1209336352926621,0.24013728032189868},
{0.4279493482950236,0.07157727128463615,0.25295728279638724},
{0.6347154607121148,0.12127038090985871,0.43023179502627806},
{0.6883150346697364,0.1459905216329473,0.14594748704927998},
{0.4397709484284308,0.11934350742615538,0.17216200369021553},
{0.4324496898820314,0.07393018714664575,0.16794891794918693},
{0.4291790615233167,0.010140023776607497,0.21793143514957208},
{0.6219115962065014,0.07794531380280481,0.4409925926722863},
{0.6412739312630112,0.07797543801137191,0.45129399613764615},
{0.579909842547217,0.00430991355428008,0.4681334287266605},
{0.5867200654125673,0.011485930380802293,0.5028924619547384},
{0.5925265066138776,0.10392314023357022,0.4864177474623044},
{0.6352157377472472,0.22744315400463702,0.4573371275491267},
{0.6743610709156146,0.3141556883650624,0.40272301328154836},
{0.6960408183026084,0.4425450652780842,0.36186275195403905},
{0.6905259364056439,0.5254866942446624,0.3504316906674126},
{0.6692614727510395,0.6076945835597133,0.3371716595749259},
{0.6334222714729124,0.5927034863392094,0.3816091706697795},
{0.5871514871138318,0.587459722319349,0.41852961586254755},
{0.5374422395197341,0.5822439307788723,0.4508389054153645},
{0.48633759555022404,0.5788657159609892,0.48142681162148937},
{0.4330973603662243,0.5776037267949456,0.508417026633028},
{0.37835306648305245,0.5785537152294012,0.5326616352065929},
{0.3239659596443192,0.5760308127619058,0.557396838033965},
{0.26623291392545334,0.5708300833257126,0.5713615604340038},
{0.21344669359914362,0.5709893112852816,0.5831745536506775},
{0.1576426730931645,0.5779017412868417,0.6033696079011496},
{0.09392028919240224,0.44072470238895733,0.6474251870659559},
{0.03321893306508442,0.42795849314405293,0.6587852412895313},
{-0.028460383976072777,0.42151406423987486,0.6687628095127948},
{-0.09136511078715634,0.42280940520826055,0.6758226329634153},
{-0.1118721657692163,0.26557502272763955,0.6764864414164834},
{-0.18366030651382217,0.2642538610090534,0.6718171890885813},
{-0.21696154322017033,0.15156134848867925,0.659829905808055},
{-0.2640123294082207,0.06589563037596091,0.635104385762008},
{-0.3116763584135301,0.027488340317487665,0.6104692383416623},
{0.6698499706826899,-0.26517264937035023,0.23030172622473735},
{0.6210175527308134,-0.3504359941257793,0.31209325594280707},
{0.6455741620359662,-0.30471820416682355,0.40773546641419717},
{0.6672151782976594,-0.20819701232402887,0.42887512977616643},
{0.6748269202838131,-0.15669645018477973,0.4117150895388307},
{0.6614679096488916,-0.1310693556109028,0.40826909525167165},
{0.6495753024524333,-0.1577486457554452,0.34943221246173956},
{0.608555813165355,-0.11724341974319112,0.2462643291715305},
{0.6042276099130164,-0.13236469657928854,0.26323716896991345},
{0.572492832052158,-0.13063363045127138,0.283535506221187},
{0.4980473057660963,-0.10231149507522982,0.27491890670640196},
{0.44394315131497547,-0.0529282344524118,0.2428086521030463},
{0.601480927610451,-0.38279369758522186,0.30140238949525816},
{0.6208615523650193,-0.35326766973108764,0.38835699338881213},
{0.6029387241321807,-0.344093772357811,0.44249127204850003},
{0.6078328321597444,-0.2925135962387774,0.46506506291118205},
{0.6445531665384595,-0.19790206404621913,0.4517652248288031},
{0.5818367160309204,-0.10109361635744524,0.45724783078801706},
{0.5924974582699022,-0.09201116747446166,0.436917217598993},
{0.6379796338832795,-0.13168690188652854,0.39316718397822453},
{0.598875183569396,-0.3645642479437538,0.37087526963856327},
{0.5825995040264232,-0.3593333942989935,0.43054917508082435},
{0.5376886125112293,-0.3679478420845952,0.4683356912698968},
{0.5444256765843452,-0.35569266852073994,0.4825586211719393},
{0.5267728903640188,-0.2908642958197281,0.5299289391437194},
{0.4988778732308751,-0.17638477221256935,0.5499249584447302},
{0.5341608525151025,-0.16556587787861018,0.5279418172428818},
{0.5644001785935222,-0.1308240584839992,0.5101954308030792},
{0.5673168475015734,-0.09450717332716503,0.5075466521783568},
{0.5868879002888697,-0.0022743777468167644,0.4532187178921661},
{0.573377192746521,-0.09640499846689293,0.4181261666406666},
{0.5705100136096871,-0.0032899939213650365,0.4290956820174613},
{0.5097430297422766,-0.4217765752002453,0.267826807318031},
{0.5007649397246863,-0.4904941984001894,0.25570504096354435},
{0.5654792707789797,-0.4016632866587411,0.287320397854726},
{0.4212746843682254,-0.456699139846259,0.2342447699532537},
{0.45449307950101403,-0.4290903026945029,0.21740426149964767},
{0.4696746047542456,-0.401514817345089,0.2596222639418603},
{0.5168039290574888,-0.381031431384046,0.276257282258455},
{0.5283705492826672,-0.32770727876189504,0.2987503832767608},
{0.5742862983264927,-0.36432648186899197,0.33665309284173495},
{0.5617696896668585,-0.35595410361651886,0.41240471874209916},
{0.5259541574097484,-0.3496097301193672,0.4663743901192596},
{0.47887647460690597,-0.32475725805150163,0.5088688897615347},
{0.4793046687143956,-0.3394137613839922,0.5214177743589192},
{0.49472180831320567,-0.33078963081706536,0.5344292807307273},
{0.4366218927685761,-0.2336347547297697,0.5946325115520961},
{0.46503870422868576,-0.17069775198093567,0.5686450023400055},
{0.49538346503709046,-0.18054621645319718,0.5294157517334869},
{0.5340005486909417,-0.1519486597416849,0.5108721496312474},
{0.5489776596717537,-0.1287411846345019,0.5114445095940224},
{0.5456414035729463,-0.08994012813547285,0.5056907857577045},
{0.5665045697348532,0.013159975685460248,0.5111927572795688},
{0.5575415418215464,0.013629052647433816,0.4752513488652319},
{0.5796882144413305,0.09987358591047735,0.4724745423540993},
{0.5845371361560434,0.1891380710823736,0.4667175909240063},
{0.6296363039747818,0.31128958509282023,0.4477135187765268},
{0.6569417473116833,0.4375519777080857,0.4096365191477001},
{0.6522552811503145,0.5131637412115312,0.39672721991210186},
{0.6049097080641431,0.509247594097807,0.43696455564102704},
{0.5521407015713002,0.5044858174150202,0.4697461497495925},
{0.49968692340382037,0.49414783455354316,0.5020081012603753},
{0.44620569455128384,0.4831288294055311,0.5322979929746042},
{0.3906103917760911,0.4727037015121277,0.5591730904748329},
{0.3341748387547943,0.45784816323017585,0.583366057547997},
{0.2767624006842499,0.44361339881762485,0.6047693077349285},
{0.21696369494935366,0.4456435553021297,0.6226749221343002},
{0.1554479093261322,0.44885285937911856,0.6363265679381593},
{0.12395627686299403,0.3022856743250295,0.6468743443950145},
{0.06610488603904312,0.2884941661242516,0.6575888798635804},
{0.008464364675061987,0.2734901585286476,0.667393233887583},
{-0.051054616265996784,0.26939649375729574,0.6744691953070787},
{-0.10088220896517966,0.10362727747085754,0.6655610364879477},
{-0.15915856630284514,0.12661312447215395,0.6644227717499476},
{-0.20233086063788014,0.07125343604253971,0.652826027316202},
{-0.22427742244361126,-0.07269617045998589,0.6021732464751987},
{-0.3047843698392121,-0.10078376735504067,0.5786354809383691},
{0.4263785859911672,-0.4576415972285728,0.20789146677999107},
{0.40210385320903513,-0.45022351086892204,0.23731528749791553},
{0.4360387741598843,-0.4192644313786667,0.2437801578293356},
{0.47456010586507585,-0.36389398430313563,0.2638611704330893},
{0.47720673276061476,-0.32604184037397055,0.26795806279821627},
{0.4846011500992485,-0.2573425068720851,0.2681936771437947},
{0.5129049957772315,-0.23849551095499122,0.30094837463756813},
{0.5335508372916186,-0.20689736789727645,0.3307412169104397},
{0.5507076499351792,-0.3164924662581967,0.3494042399823558},
{0.557813735563242,-0.324190277411685,0.4080829706773106},
{0.5648531175866205,-0.2533402905910262,0.4173547717284302},
{0.48176732276475687,-0.1872596115052959,0.5254856183800707},
{0.4032980629058027,-0.2591617938966202,0.5630505064632565},
{0.3994550745843128,-0.2704529927863279,0.5770496565302291},
{0.40820400544387486,-0.26406773643469234,0.5879180406354056},
{0.36805166301769265,-0.2293216135817146,0.6003561111798469},
{0.33336686444644076,-0.21320623786290258,0.6097139813983012},
{0.3309676864069888,-0.185358558771793,0.6110157775542371},
{0.4206442277174995,-0.16259971919934157,0.5816747984098722},
{0.45673948476844706,-0.179150820077785,0.5487285970187793},
{0.43220546861971954,-0.18139184602225963,0.5481626922435542},
{0.5330365740167943,-0.14432077978665606,0.4998499168894603},
{0.5654652845392879,-0.16501503520766875,0.4463826742766156},
{0.5486290795440486,-0.08217991683566704,0.46399350177786625},
{0.5618944899594936,-0.14741173875855984,0.3787280052932538},
{0.5425396859551257,-0.08553553849712474,0.412395035960774},
{0.5051985777070098,0.014673717165957514,0.385331662157001},
{0.55075929143558,0.09713658638923708,0.43403174876410056},
{0.5324340898454522,0.15090937454611966,0.45316169706880693},
{0.5789006815602188,0.31064514220240247,0.48440588067585816},
{0.612815161083826,0.41833488437145305,0.4487883075036176},
{0.5648445106698871,0.4049479012571478,0.4849696337218998},
{0.5142003367456173,0.39240977530568005,0.5166925770722497},
{0.46182724842251355,0.37474838216862033,0.5426876173364821},
{0.4093508770986084,0.3547598939197513,0.567409909788754},
{0.3564129598648714,0.3357977804913474,0.591224172525646},
{0.3005282495145161,0.3216157334437888,0.6098280230450196},
{0.24220025067644985,0.3128840164176937,0.62391539400851},
{0.18299757392534574,0.3082287503294836,0.6358617944345525},
{0.13285152530702488,0.1578056665788044,0.6335024233849927},
{0.07436537437398127,0.14660806790857306,0.6494639504671943},
{0.014763551859362975,0.13281871143697857,0.6616405859158566},
{-0.040230342609079234,0.10386611941021105,0.6661108032942974},
{-0.09884236969934965,-0.007850583925507115,0.648519341355697},
{-0.1445601596583054,0.04081292328547531,0.6608595082222951},
{-0.1339618175656412,-0.10343362184435465,0.6454692652382771},
{-0.17955373136737013,-0.1321452202025853,0.5927131691205345},
{-0.29354050899153833,-0.1334782164316799,0.5716337541756995},
{0.49990317218674857,-0.14908685992780948,0.2605722523763159},
{0.4899718661409275,-0.12360393120921799,0.3139932328117183},
{0.45909993168259844,-0.13957298934356122,0.20848749576378317},
{0.45964754675976477,-0.11604598245264851,0.24074621968079096},
{0.4602780034104908,-0.13513504790287093,0.2915786699086053},
{0.48440641860815403,-0.09374115773788709,0.3336417478496157},
{0.49188152579116395,-0.1914651661941828,0.2666820873924808},
{0.45137307218513484,-0.18795139243774778,0.22113751163278592},
{0.42775031334556235,-0.1382572069479335,0.17577690871826873},
{0.4192660451755542,-0.11035573462723981,0.20846490260735784},
{0.4094875119017521,-0.12675298686907263,0.23926798173181923},
{0.4089463520121358,-0.1604834935475021,0.2708973248626928},
{0.45207023244054506,-0.15073508448226705,0.32395681479528987},
{0.4455042308375068,-0.030369505694013334,0.36375842536458364},
{0.443616088479104,-0.23244269676218549,0.2335131820309096},
{0.42817743158846033,-0.18007606362663192,0.16294937519163838},
{0.4061082212192773,-0.2256346256260187,0.1415654905673572},
{0.40002743454708795,-0.1871337353480691,0.127138146392895},
{0.3993378053438194,-0.16800055944958767,0.14457253210110976},
{0.4014475758081088,-0.16859120911042133,0.1867830034911806},
{0.3963587362894506,-0.18758775020575907,0.2332119399452385},
{0.4070248578513908,-0.18445913597314642,0.303025869164107},
{0.42189760996680964,-0.11633001070485267,0.3439065719188583},
{0.40061808420792155,-0.08956465139297566,0.37276341199696605},
{0.3949063190906793,-0.011560165037628344,0.4216001334072094},
{0.4859696498598687,0.06875635432524466,0.40646702206060353},
{0.5191450104089899,0.07404530465795578,0.4138399221074036},
{0.47423519475838777,0.12370829007461123,0.4502019935770884},
{0.5226641634883834,0.29852875517087424,0.5083503230283437},
{0.36172450335400785,-0.23696670737021036,0.5851035788635642},
{0.3315916878701647,-0.22615426822380133,0.58402018321974},
{0.26881498894549133,-0.22185296158625475,0.6041388510842025},
{0.2630849341301904,-0.2011188991753498,0.6160830997810616},
{0.26645346616674825,-0.21529449103535828,0.5766160830997811},
{0.3325739522423708,-0.22117624275808648,0.5735348069092024},
{0.3654308568723541,-0.231841288455435,0.5653001393244647},
{0.40469883860417327,-0.1782912042690307,0.5700113503714422},
{0.28698203844064185,-0.2344438049027149,0.5791153165462595},
{0.2365325960074665,-0.2533973114143854,0.5490190804585335},
{0.2089764762207029,-0.23570149061039175,0.5819555990683013},
{0.17224430733147927,-0.20897809001759038,0.5853531794488346},
{0.19889454913204624,-0.17787914813041628,0.6085757166603012},
{0.21690882585517787,-0.19681974426698653,0.57778554791094},
{0.23738898422244578,-0.21663824591036973,0.527361926227965},
{0.28745649472557383,-0.23366272720915346,0.5718994927298451},
{0.42077440733309307,0.0516651694217766,0.44031587384411797},
{0.41842579492945015,0.11297438904339502,0.48132352862068783},
{0.34817291295717523,-0.0007444982974442626,0.4789329574979693},
{0.3551746397198449,0.043942613382679685,0.49361958503902703},
{0.2900213559121449,0.033543306239476725,0.5355804558438275},
{0.30401512665615904,0.0944501525038059,0.5370199626674986},
{0.36319843784461286,0.10713567190433415,0.5134553005158771},
{0.3026767511041061,-0.02380027649720004,0.5077682802842435},
{0.21939192133278107,-0.008816710328837993,0.5532074213139535},
{0.24805187819061092,0.08343652667875223,0.5680177732830546},
{0.3043701619714143,0.19855403798877874,0.5753605491212876},
{0.3600644442890418,0.2182993808399275,0.55523865366305},
{0.4169948950225125,0.23715175607997982,0.5392534575598316},
{0.2487296728833709,-0.05083998127995609,0.5252521557636756},
{0.1645120685110572,-0.05934684260638954,0.5542908169577777},
{0.18997132820863166,0.06324900348042198,0.5889540982371959},
{0.24963770259875093,0.17639875845226122,0.5959999354481246},
{0.46979187399473904,0.26934377639230334,0.5260655093949875},
{0.20513456376380468,-0.10729274813471974,0.5162127414643594},
{0.1331258707779039,-0.13288111158329613,0.5421324712071739},
{0.08635050592532424,-0.0828835322786274,0.5747806581063707},
{0.13164440523515708,0.03618347794746555,0.6006584291301097},
{0.19190358101529342,0.16297412007724713,0.6148275658025681},
{0.1809243828571736,-0.1928723970801035,0.5542327202698268},
{0.2085859373739221,-0.19787839502520213,0.4983006718774375},
{0.2230261919234845,-0.2137753702319026,0.4738860766983867},
{0.21355965938127028,-0.24528851998687445,0.4996745509610161},
{0.18809394449614572,-0.2582225641080813,0.5287390329053185},
{0.14963393707268002,-0.17155306433132325,0.5887206356208008},
{0.16765359311877007,-0.15850820615717304,0.5229153778705412},
{0.22131233962893432,-0.1549223494730953,0.4854935797780492},
{0.24493187087473173,-0.18161670172192126,0.4620225178459039},
{0.264058591585663,-0.19016659763202204,0.4410399307143203},
{0.24115128269955943,-0.22031447522014877,0.4548809286863156},
{0.21706590208556353,-0.24032986008380983,0.47519002458350595},
{0.18714395606169007,-0.2337401894597546,0.4959563629321614},
{0.15999236136139905,-0.2395337202859648,0.5517614593027322},
{0.13021135359903602,-0.21480604851073443,0.5530266760625507},
{0.09516183693120385,-0.20396456102034996,0.5357407596679883},
{0.1344276669338397,-0.18410517652248287,0.5812971699381917},
{0.0949983055132681,-0.13643684405880674,0.5838103896243619},
{0.05009386918562429,-0.07595711603737552,0.5977966293162343},
{0.07451061609385842,0.005223322592618515,0.6066746639267981},
{0.2526974614974959,-0.12238820422061678,0.4866888653394084},
{0.2738489593699737,-0.14843488598524987,0.46243887744288503},
{0.2885732421717403,-0.16517318730264607,0.4251365003200697},
{0.18194537835468028,-0.22198421706644,0.43288272538018363},
{0.15896813827011733,-0.19921677057725515,0.4393960096182295},
{0.14049661909552064,-0.16733997859029462,0.4453821202063508},
{0.11195285561359247,-0.16825338762863304,0.449335922580784},
{0.0865065062911182,-0.19039898438382544,0.4460878873784946},
{0.15850659236028553,-0.20754073492310257,0.5037875812950182},
{0.12860723949283742,-0.1846667778393411,0.5078478942640279},
{0.09404078602667067,-0.19881654894914924,0.5077134111900676},
{0.05986702313646804,-0.1988628111265916,0.5162902037149605},
{0.09303915609181428,-0.16778861412502621,0.5794649725385563},
{0.05715907195920321,-0.1397386724906803,0.5829055875027569},
{0.01673668752050866,-0.10284835150647938,0.6043841482111062},
{0.01708096418984706,-0.023506565463670723,0.616518824940693},
{0.02861100501890831,-0.1623587255308047,0.5888110082465021},
{-0.05705901655217676,-0.1540121680285319,0.6260294679311662},
{-0.01956513553204195,-0.18399005901117282,0.5888465117780276},
{-0.0665072593963324,-0.22497512063131733,0.5812121766354487},
{-0.0813337493343088,-0.1465661091894974,0.6352915862009607},
{-0.04520514048101907,-0.036718182649531715,0.6309935071571893},
{-0.010287955157963827,-0.19474762906340606,0.5678187383335934},
{0.0521767430351216,-0.17097102158722302,0.5667622393045612},
{0.03386767941386896,-0.17944237938213095,0.5265066138775775},
{0.018622678149728067,-0.18127565264635792,0.4837216307955481},
{-0.03298439458409766,-0.212557491514118,0.5540756440394412},
{-0.012106166317907242,-0.20213989467285648,0.4560590004142079},
{-0.02068833816575847,-0.23189077822665238,0.48941187862095675},
{-0.09736843520874464,-0.2574942037795123,0.5748258444192215},
{-0.15124343050183706,-0.19458409764547033,0.5950069124300016},
{-0.17255523219847552,-0.2631328101045202,0.5657627610988881},
{-0.10473380420340297,-0.30012211063115596,0.5691936932817636},
{-0.13984679688214444,-0.30280208932903707,0.5611053432814946},
{-0.2271198566948364,-0.19414944835043063,0.5680866286169223},
{-0.16626787952468305,-0.2018300456704519,0.5769797253317698},
{-0.2622446838840864,-0.16344965222677071,0.5650032006971603},
{-0.11365164580385914,-0.338855387660909,0.55784762529788},
{-0.09309617691517347,-0.3314383771658499,0.5571752099280785},
{-0.04994432400738044,-0.3023803504090975,0.5416945943183591},
{-0.055478571466995176,-0.3479787193983765,0.538218475822633},
{-0.08368021000876831,-0.3591580283705492,0.5491600187200439},
{-0.10373217426854657,-0.36235764966621303,0.546652178356832},
{-0.07845473568696645,-0.384111631710033,0.5403960257561984},
{-0.098502396488378,-0.38733061856834694,0.5377999644964685},
{-0.07466338886587737,-0.40223672248610787,0.5277374029704621},
{-0.09002565937051164,-0.4040958165005352,0.5227292532961801},
{-0.07733153305324993,-0.4208007660155893,0.5101502444902285},
{0.04028413583866334,-0.4820787855640489,0.30789308057687864},
{0.048676955518378445,-0.48436069436300744,0.3134660591617939},
{0.03481981957750797,-0.4861003674077581,0.32031931661081137},
{0.03556646960413561,-0.35910746273474015,0.3224495285023427},
{0.008277164236109236,-0.3541143751647418,0.3414955593688978},
{-0.004628907405713927,-0.33981828647046486,0.3545640865640651},
{0.040878013093272075,-0.4871310456865899,0.33028182272979123},
{0.04997122062217249,-0.48664905834951616,0.3258159088097172},
{0.05268455112239573,-0.4860982156785747,0.3187410232548132},
{0.04728801433051635,-0.36683217050302047,0.33869185624297327},
{0.032307675755929355,-0.25843128183886777,0.40482848028747104},
{0.04084358542633823,-0.33656594780980864,0.3187560853590967},
{0.005297019317148735,-0.33011936717644713,0.324461395288789},
{-0.008914076074385286,-0.31507878018472596,0.35188841132455073},
{-0.02514349343991566,-0.3004943597798781,0.3723793283377354},
{0.018401050043841474,-0.3506156635125903,0.362513650032007},
{0.03349973372351355,-0.3579455289757231,0.3599186646368688},
{0.0290047714594641,-0.3181848012609133,0.3701727300601946},
{0.025253231628267255,-0.28907513300376014,0.3896437274404643},
{0.033208174419167596,-0.26943092142422953,0.4469184548432734},
{0.05034777322926136,-0.2366073685965884,0.4603893553957299},
{0.0731173714476296,-0.2242284706046897,0.48727843913565044},
{0.04377101298030629,-0.22789394126855192,0.41656078365976856},
{0.06231461508254571,-0.3254920735676208,0.334321694271559},
{-0.015877071711754367,-0.2787661984862585,0.3188120303178642},
{-0.04150309042103961,-0.27846388053599574,0.336835989822321},
{-0.062255442530003174,-0.2991839567072088,0.34826597524435576},
{-0.07689258029984347,-0.33057553376332055,0.3494053158469475},
{-0.09026988063282357,-0.35878685508641883,0.34119324141863505},
{-0.05664911214274573,-0.31290553370952734,0.3748064788565711},
{-0.002385729732055934,-0.31458065487877696,0.38200508883951867},
{0.8218276787683502,-0.5472761798200079,0.03810927556657719},
{0.8196415219180514,-0.5649676971656347,0.013288003571870446},
{0.7544774794644347,-0.5719425273135124,0.13729753573215275},
{0.7553661436171644,-0.5664384040624647,0.12912096483536584},
{0.7566023120330077,-0.5523607158802993,0.1262580891568987},
{0.7516458038591264,-0.5521842740872634,0.1354147726967084},
{0.7696084390818573,-0.5299622909460615,0.12216550025013853},
{0.777348208954421,-0.5232488958939627,0.11160588928277487},
{0.40391991263979515,-0.4627142987783558,0.2205178136279768},
{0.40227491567911267,-0.4442944211041598,0.235626180088974},
{0.3934291570062992,-0.4394476511186302,0.24132611069570786},
{0.3726413013658101,-0.42937648267589046,0.23129367337826862},
{0.40764455585619996,-0.4231515301484155,0.22730867093067667},
{0.4188120303178642,-0.38344459566318984,0.22833827334491683},
{0.420500061862214,-0.342982404234603,0.21338590724971357},
{0.4462820809372932,-0.3745536506775257,0.2540503612215367},
{0.445537582639849,-0.32728231224818044,0.24880982479545125},
{0.44257680328353877,-0.2800260359231187,0.24036643947992706},
{0.42131987068107607,-0.221143966820336,0.17311952317681298},
{0.4076908180336423,-0.26527808410033515,0.15880191719070239},
{0.3753234317928746,-0.23194349559164482,0.16386923941752693},
{0.3651597389952501,-0.20267675110410605,0.18167264668068878},
{0.3587615722685143,-0.1855963248465548,0.213303065676154},
{0.3622721184311743,-0.19783966389990157,0.24467850476339048},
{0.3430485699069915,-0.18296583591989113,0.267331909605857},
{0.3273248088995519,-0.16532273248088994,0.29334308783896457},
{0.38261564199529846,-0.2097882160551273,0.26472401383561867},
{0.3758753503284077,-0.1960967632613759,0.3249692033760631},
{0.35523273640779574,-0.1800222703970478,0.3544059344690877},
{0.37925786860465743,-0.06724368870933903,0.40688015406380956},
{0.3488410248686101,-0.05612893161266721,0.4381587653377946},
{0.3244049123977256,-0.06838087758274743,0.4728209707526211},
{0.28937798888631877,-0.09704406203435234,0.4823864828372701},
{0.3015664588454897,-0.14600343200804747,0.4387375804881198},
{0.3065573946863048,-0.15468027993996675,0.39287024535092013},
{0.21297008558502828,-0.22822207996901508,0.4273118985244518},
{0.09453138028047789,-0.16747984098721333,0.3892886921252091},
{0.061003136145284756,-0.1700522332259262,0.3956158517888939},
{0.050805015680726415,-0.20209255663082243,0.38896162928933764},
{0.03861224226318875,-0.23082889987466176,0.37189949272984507},
{0.058672813439700475,-0.20098549196598114,0.43227593775047474},
{0.4550008875882881,-0.473973221730313,0.24156387677046967},
{0.47188980994851987,-0.4794655104708521,0.24815785085289166},
{0.4802213053465091,-0.49228013362238227,0.2393389887948703},
{0.4913597314641979,-0.5050700118883037,0.22113643576819425},
{0.5209976492358672,-0.5060092416768425,0.24389312361146226},
{0.49957073002791874,-0.5063223182730222,0.23123557669031775},
{0.7524591574904382,-0.5321032614835097,0.14786145015788313},
{0.7496328612080884,-0.5456839002243178,0.14115343442874279},
{0.7828394218303685,-0.5637153907809163,0.07767096833192574},
{0.7933667568599816,-0.5463240396563689,0.07218513477893673},
{0.7133256588325794,-0.5469846205156619,0.11625254845425155},
{0.6861633054863715,-0.5497850960478115,0.12276690855688903},
{0.7182520427978935,-0.5561574420243468,0.11998902618116483},
{0.7450991678187383,-0.5585135854801314,0.11210939391168229},
{0.7293431308735482,-0.5351995997783718,0.10097204365858513},
{0.7107425079479497,-0.5336535823601242,0.11772433121567319},
{0.6716359059048828,-0.528219390307536,0.13426252171901645},
{0.688479641952264,-0.5399065073669828,0.13496828889116017},
{0.7058709930768114,-0.5021479636572941,0.09769711184150363},
{0.6908486957831487,-0.4969203376063088,0.10639117360688984},
{0.6896501826280145,-0.531156500642829,0.1272360500707381},
{0.6613226679290145,-0.5199621295663728,0.13211939945238493},
{0.6396719688859961,-0.51206958692179,0.13423132164585766},
{0.6665997837512171,-0.5300096289880956,0.1332382986277347},
{0.6454278444514974,-0.524989644803305,0.14407655852434414},
{0.6217545199761159,-0.5269918288084262,0.15788635642318058},
{0.6110173913511245,-0.5235512138442255,0.1567233467995718},
{0.6091927250036311,-0.5185968573995277,0.15562058559309727},
{0.5884349935717091,-0.5050883015863623,0.14962479222365074},
{0.6230251160588929,-0.5227647568277056,0.14950859884774903},
{0.6001113519852391,-0.5179739318009435,0.15181525253231629},
{0.5540923199406123,-0.5036197464187158,0.17152401598734784},
{0.5777656444159939,-0.5099985475828013,0.15803159814305773},
{0.5433562671802127,-0.5001780555899235,0.17036100636373908},
{0.554618417725945,-0.5088333862300091,0.15584974475112565},
{0.5069888163875694,-0.49753573215275126,0.1517173488544732},
{0.5313711356288697,-0.5114014750103552,0.149732378682819},
{0.4859782567766021,-0.5018919078844736,0.1658864855269316},
{0.5081442949590365,-0.509074379898546,0.14428420039053885},
{0.47728096741744086,-0.5014927621209595,0.16311183074498245},
{0.45865237201245856,-0.49105472385245597,0.1554204747790443},
{0.48449679123385536,-0.5042039408919993,0.1427328036493327},
{0.46383050829222633,-0.4914388075116866,0.14481352576964665},
{0.4493837985551139,-0.49102352377929714,0.1621005180288009},
{0.4313512321339236,-0.48613479507469187,0.1745740921047677},
{0.4145376202951097,-0.47053260676611236,0.18003948423051477},
{0.44452626992366745,-0.48055320957304315,0.15662651898632038},
{0.4274705885517249,-0.4745079264323792,0.16655997676132483},
{0.3899906937712819,-0.5094789049850186,0.17050194462524945},
{0.39516237486349964,-0.5165096800916636,0.18641828539460026},
{0.3986460244113676,-0.4534887599046784,0.1562499663792315},
{0.3825941247034648,-0.4422728715363884,0.15627686299402357},
{0.34077204043099135,-0.4862520643151853,0.1707956556587788},
{0.3266362555608751,-0.49531514763551854,0.21220030446967947},
{0.3706455725482391,-0.43520659289821784,0.17371232456683003},
{0.3947191186517265,-0.44083874403567563,0.16592629251682384},
{0.3677665589008968,-0.4683711948014223,0.17481723750248793},
{0.359514677482692,-0.42780249277825894,0.21378612887781942},
{0.35038489055767447,-0.4658515199277019,0.210287417225668},
{0.33509362711609114,-0.4674997444821594,0.21861998848824887},
{0.36321887927185487,-0.488248868997348,0.1626556641581091},
{0.479577938320683,-0.39939643996406615,0.12955023480744712},
{0.37106085628062846,-0.501419603328725,0.1633851003512698},
{0.4968003787043363,-0.4071770926911139,0.12636675148065865},
{0.4483918514015826,-0.41268874699430325,0.13827657251058384},
{0.4207130830513672,-0.4394605614937304,0.1512052373088323},
{0.4193026245716714,-0.4193569557335514,0.14751394589476968},
{0.3621182697945637,-0.4257798673458959,0.1594087048204113},
{0.3565280773761815,-0.4322780894796581,0.1830540568164091},
{0.34168329774014644,-0.44764358757806744,0.21010344438049028},
{0.35417300978498845,-0.4277228787984744,0.2238347041641339},
{0.3704605238384697,-0.4443094832084434,0.2227964948331603},
{0.3903425014927622,-0.4106575146452067,0.21566566431948875},
{0.40533575044244935,-0.3758156398435693,0.20433143084611372},
{0.41752744799539526,-0.3023986401071561,0.2011059888002496},
{0.4160072513273479,-0.26177184139604187,0.1888615738823112},
{0.40922392507678984,-0.30254926114999164,0.17283226733083373},
{0.38129878373507914,-0.26596340984523686,0.1672259369435763},
{0.3380942134622936,-0.2508948503741319,0.19760082196054807},
{0.3319574818313367,-0.2160852515102449,0.20596566916087944},
{0.31934619708763456,-0.19073465413643037,0.22561310833418508},
{0.29146086273581606,-0.18024067090915935,0.24250741001737525},
{0.27281397763277515,-0.17222763143030817,0.2709478904985019},
{0.25519023975642424,-0.17635464800400222,0.2994529228551295},
{0.23604307761825097,-0.19121556560891245,0.3248659203752616},
{0.31401313630666444,-0.16964340468108682,0.32219670032329734},
{0.38464472261521165,-0.17227927293070894,0.2688122992840121},
{0.36873698876259436,-0.17117328413045932,0.3037079673152337},
{0.34322285997084406,-0.15240697805774164,0.38278939412685525},
{0.3235033378698957,-0.12785144461718045,0.4120464558330689},
{0.5138528324825038,-0.41617992759431294,0.1252091211800083},
{0.5182272979122848,-0.39913930832665395,0.10654932570186718},
{0.5197636325492074,-0.4009575194865974,0.06339532106489078},
{0.49586222478038916,-0.4061119867453482,0.02987460798183941},
{0.5209234145790411,-0.42004443320763646,0.036231891854091244},
{0.5542171202332474,-0.42264049446736635,0.03109248669962399},
{0.5788135365282926,-0.4243618778140583,0.025314017977697327},
{0.625637315287498,-0.4305631613205162,0.0482471476140013},
{0.5289698058602345,-0.4285394600235614,0.1251090657729818},
{0.5354088554414542,-0.412171256125704,0.10637395977342291},
{0.5324362415746354,-0.4082109985637208,0.06206340070038785},
{0.5416090630833204,-0.44403406187297273,0.1250423621682975},
{0.5535188841132455,-0.42342802734847795,0.10921424229546471},
{0.546164273764504,-0.4141637573495,0.062352808275550446},
{0.5602763896136033,-0.41829184978778566,0.06175462756257498},
{0.5742916776494511,-0.42153020220875,0.06238508421330092},
{0.5883801244775333,-0.4242628982716235,0.06424310236313659},
{0.6032862283952942,-0.42577771561671246,0.06407419162224243},
{0.6178717246647337,-0.4265168345911983,0.0590929385627525},
{0.6677606416456425,-0.45087010548852324,0.08081572053341367},
{0.5582580676396068,-0.45218911547792595,0.12626239261526545},
{0.5730006401394321,-0.43158630854720625,0.10996734750964243},
{0.592487775488577,-0.4374508464364675,0.10480642506334154},
{0.6127871886044423,-0.44161229067709534,0.10262241994222608},
{0.6316384879799029,-0.4505408909234684,0.09879019026665303},
{0.6499744482159475,-0.45316277293339857,0.08913215382711934},
{0.6732497027924066,-0.4948449948089534,0.11350479028709448},
{0.5774138366945136,-0.45572117893241954,0.12877561230143575},
{0.5952462923016509,-0.4611930262457167,0.13278320790545303},
{0.6087752895420583,-0.4744670435778953,0.13836156581332673},
{0.6259364056439857,-0.48240584839992035,0.1404035568083401},
{0.6418602774654782,-0.4908438543924862,0.13414310074933972},
{0.6575485349413923,-0.4960273699952124,0.12447968498684756},
{-0.08364578234183447,-0.4727176877518196,0.453910498824618},
{-0.05983582306330926,-0.46060560417865803,0.4688456510863543},
{-0.04938595028429723,-0.48535586911031375,0.4465526608821014},
{-0.13260515231552958,-0.45168991430738525,0.42430916044906586},
{-0.18979381055100406,-0.38088403793498554,0.41054777645685514},
{-0.1581106741905464,-0.3843257287637778,0.40518997079027635},
{-0.1833020436047919,-0.4094643808130309,0.3710678494004745},
{-0.22718225684115398,-0.3758414605937697,0.37129485682931945},
{-0.20354873935566473,-0.39484338101206584,0.35957223623834705},
{-0.17415827044008242,-0.3715767333523403,0.3476430496457716},
{-0.09980742023808885,-0.4561988628111266,0.4072803756919154},
{-0.06870847835091476,-0.45447317600606785,0.4104563279665621},
{-0.12729576055557648,-0.38303899471212555,0.3943377246539751},
{-0.15135316869018867,-0.40457457624383397,0.36319359645395033},
{-0.11806806995271577,-0.396347439711238,0.3605157694852526},
{-0.17401518044938866,-0.39615055649096004,0.3504263113444542},
{-0.13413395590031038,-0.36548411216964233,0.3207195382389173},
{-0.12936357230079024,-0.3601220030446968,0.3067365261408199},
{-0.07227281774315886,-0.36308170653641536,0.26638407290058475},
{-0.03593441529449105,-0.35036068360436157,0.2554134816591984},
{-0.13856221455967552,-0.3395676100206028,0.24475489114939997},
{-0.1437123783600596,-0.3280784520460255,0.1948433810120658},
{-0.16806780098656787,-0.3025159093476495,0.1602812310042658},
{-0.14361124708844145,-0.319412362760023,0.17695175285238599},
{-0.11093508770986085,-0.3338891967057026,0.1738489593699737},
{-0.07504747252510799,-0.3403239428285556,0.17444391248917412},
{-0.04073384723798664,-0.33858104219002993,0.16692254312872182},
{-0.010702163025761586,-0.32958143488060593,0.15031011796855248},
{0.018229987573763956,-0.3206754277906583,0.12350925512514996},
{0.019760942887728145,-0.22772933398602452,0.1414051867431965},
{0.0314997014475758,-0.19249154101464785,0.12618708209384766},
{0.0624135946249805,-0.1820922338714449,0.1070635889766914},
{0.096215108366461,-0.19908228750329482,0.16092567389468362},
{0.1317111088398414,-0.18998800410980274,0.16306018924458168},
{0.21395880514478446,-0.20102207136209838,0.21009591332834848},
{0.25679542972721453,-0.28361081674260474,0.22385191799760082},
{0.2828496425439894,-0.28408096956917,0.20083271919396228},
{0.32804778990516253,-0.2764111308950655,0.19538561676627378},
{0.3583398333485748,-0.2729877297643319,0.1655153122428011},
{0.35765450760367296,-0.3049860944501525,0.14132342103422862},
{0.32587884688833063,-0.33790109576808663,0.14318789437161442},
{0.29209024352195034,-0.3731335094165048,0.13323507103395968},
{0.318856678698419,-0.3503359387187528,0.12551681845322948},
{0.3125467328682012,-0.40291559304345953,0.12448829190358102},
{0.340200756332808,-0.4397176931311425,0.1299214080915776},
{0.3737881730205436,-0.44123251047623147,0.13626362985954588},
{-0.022842219078306813,-0.45408694061765387,0.4505634840798937},
{-0.0328283942183037,-0.4535468565926293,0.41495451782438664},
{-0.019579121771733817,-0.4139206119517797,0.46207200761712136},
{-0.04868879002888698,-0.39183203601994654,0.5202235646621516},
{-0.027437236749382733,-0.3765128000989795,0.48081141707504693},
{-0.020696945082491928,-0.41460055837372306,0.418490884737247},
{-0.09566534156011126,-0.383047601628859,0.3886410216410163},
{-0.04460373217426856,-0.43305163612107783,0.49326239799458843},
{-0.026066585259579243,-0.3361969262548616,0.490963275362163},
{-0.018540912440760216,-0.37544984588239727,0.42900853698553504},
{-0.06236087725998807,-0.38031705729516885,0.39053131572860245},
{-0.007637024804058174,-0.30401351285927153,0.47518894871891426},
{-0.03135876318606541,-0.2626615814133633,0.5231897233414202},
{0.00033513182030908884,-0.2769608977014153,0.43962839637003287},
{-0.005435805849475797,-0.33930725078941565,0.43862353884140143},
{-0.03798070974787114,-0.3602349688268235,0.39812907147506416},
{-0.09441411103998452,-0.3749527964410399,0.3666094665325422},
{-0.14579202461578186,-0.38716385955663624,0.3424089684072363},
{-0.11764095170981782,-0.3742696224253215,0.3379591924560375},
{-0.09992468947858224,-0.3378537577260526,0.31120889524844403},
{-0.10050888395186583,-0.3411028687929337,0.2870277626857884},
{0.01572214721055207,-0.20427225829357118,0.28914291247303614},
{-0.029387779254103092,-0.30407376127640573,0.2536049532805801},
{-0.1134633695003147,-0.33888873946325115,0.21924936927438315},
{-0.10615071787064881,-0.3266238831180707,0.19394503407801097},
{-0.07030613726956327,-0.3281085762545926,0.1843020597427608},
{-0.03580961500185588,-0.318392443127108,0.17214371399215694},
{-0.019280031415246084,-0.288635104385762,0.15477603188862651},
{-0.03681662425967069,-0.25752110039430437,0.13281763557238688},
{-0.005640220121895472,-0.2555199922537749,0.14681678563935943},
{0.01893145128754094,-0.2237647729656745,0.1970327654561397},
{0.04663066106499835,-0.22932699290467298,0.1840664453971823},
{0.06790265577174456,-0.21343432115633923,0.15329133875210468},
{0.1845801707397107,-0.18324663657832024,0.22573790862682022},
{0.015143332060226892,-0.30651812562870834,0.44191460862735815},
{-0.02520804531541661,-0.32702625647536004,0.40115440270687536},
{-0.07713249810378868,-0.34257680328353873,0.37396084928750867},
{-0.06680742561741182,-0.3051162740657461,0.3093315115359581},
{-0.009174435305572454,-0.24086779237965109,0.298630962307084},
{0.009800588497931643,-0.2916851805031819,0.306085628062852},
{0.053118124552843766,-0.2897593828840702,0.3382227792809997},
{0.055382819518335416,-0.22435327089732485,0.31695616389721193},
{0.05465123159599132,-0.2352560826694352,0.2762099442164209},
{-0.038899498109167985,-0.25088516759280677,0.2641150744767264},
{-0.08130577685492506,-0.331038155537744,0.20541052303157126},
{-0.04733212477877536,-0.31839567072088304,0.2110243844709705},
{-0.02553188055751304,-0.29461045632796656,0.20713513397203828},
{-0.01737252349419303,-0.25491535635324936,0.19035594980015816},
{-0.009020586668961854,-0.21640908675234136,0.18281736660623893},
{0.09316072879067441,-0.1950348849093853,0.24014803896781553},
{0.1145629031130142,-0.1727289843300322,0.2637643426198379},
{0.15073992587292964,-0.18758559847657572,0.24951881956137},
{0.20349387026148888,-0.15224667423358096,0.22677611795779382},
{0.2285948670500331,-0.1976470841379904,0.22620160626583538},
{0.24134816591983732,-0.238482600579891,0.2201122126769125},
{0.28568777333684786,-0.2021205291102062,0.22237152831944573},
{0.29025589439313165,-0.2349752820110061,0.2184037397053207},
{0.30018935216813614,-0.26442815107290596,0.207569783267078},
{0.3106263145720479,-0.2955529137102804,0.20200218400512113},
{0.30840788178399864,-0.3268476629531407,0.2051318741023255},
{0.3082626400641215,-0.34950967471234073,0.19903279773207747},
{0.3380135236179174,-0.3586125650225662,0.1935684814709221},
{0.36374605292177925,-0.35459528663722384,0.17838803208228213},
{0.38118689381754417,-0.3581510191127345,0.15493310811901215},
{0.3538158227405499,-0.37296890213397743,0.14508894710511736},
{0.32549045977073326,-0.3858792772341673,0.1420313399355557},
{0.29997633097898296,-0.4034524494747091,0.13783869562176904},
{0.31611860331258707,-0.43982850718408584,0.13589568416919046},
{0.018484967481992708,-0.2508701054885232,0.4203295373244324},
{0.0016315486532864885,-0.17622769598218369,0.41386574285760397},
{0.046610219637756384,-0.22106220111136812,0.4450798022560881},
{0.040152880358478076,-0.2033653044427828,0.47802277605340593},
{0.32407892542644584,-0.17196512046993764,0.36340554177851175},
{0.2370307213134155,-0.21719661963345294,0.4066983329478152},
{0.12471476140013019,-0.1687784095493741,0.3821955168722465},
{0.08008467054336542,-0.20391507124913258,0.3424907341162041},
{0.05843719909412201,-0.19888755601220026,0.34495553989574873},
{0.03932984394584097,-0.2593801944087317,0.35013260031092486},
{0.34151115940547727,-0.17814488668456188,0.33094347945367597},
{0.25891488297282905,-0.19539960300596568,0.39241300289945513},
{0.14016417693669073,-0.20049920117054068,0.3755681909874823},
{0.10962360877259988,-0.20714696848254677,0.3315491912187932},
{0.09245280988934733,-0.21000554070264713,0.2905856468904824},
{0.08592446354701797,-0.24294636277078166,0.2822100410442342},
{0.2778318100883823,-0.17038359952016438,0.37772422362921404},
{0.15871531009107195,-0.22840928040796787,0.36364868717623205},
{0.13477409533236145,-0.22274377746816784,0.32135214661882655},
{0.12273732228061776,-0.2458759420539331,0.29452653888981534},
{0.00578653770636427,-0.22333873058736825,0.24820303716574232},
{-0.018318208470281944,-0.24743594571187272,0.2514661344723153},
{0.4115800685325745,-0.3396375412190622,0.1888303738091524},
{0.38278347687160097,-0.30037493881020133,0.1783482250923899},
{0.34183714637675705,-0.28713104568658987,0.19750184241811328},
{0.26771760706197517,-0.18741238427731485,0.24466882198206533},
{0.24637998461513633,-0.18071512719409133,0.2665615905582123},
{0.2150508077053422,-0.17391673883924968,0.2681388080496189},
{0.20473003867733208,-0.20017536592844423,0.280204629445338},
{0.21605458936938196,-0.2099356095041878,0.34646067445951256},
{0.2973038833332437,-0.17340139969983376,0.3519626459813768},
{0.189858362426505,-0.22974873182461253,0.354398403416946},
{0.16021506533187735,-0.22575619832487884,0.31250531208142146},
{0.15556840616040066,-0.21478668294808415,0.27281128797129595},
{0.02870137764460964,-0.2342867286723293,0.2217464509916782},
{0.3816301500293173,-0.33336632651414494,0.19054207437451923},
{0.34280972796763803,-0.3234802067811745,0.20229697090324214},
{0.37778608584323575,-0.3652700151158975,0.20542020581289638},
{0.3389011119060555,-0.3591106903285152,0.20769028010134646},
{0.29034949461260806,-0.3589364002646627,0.20282737214694158},
{0.3249568309332587,-0.39194069834370643,0.20654663604038798},
{0.3262715374642947,-0.4146715654367741,0.19483154650155735},
{0.36068844575221765,-0.39881870067833264,0.18709285249358518},
{0.3678924350581235,-0.40180422492025153,0.1563188217130992},
{0.34492272602570245,-0.4223661489964873,0.14188824994486193},
{0.3683701189368306,-0.39739102836517,0.2156871816113224},
{0.1885802352915862,-0.20996788544193826,0.3039962990258046},
{0.1719419893812165,-0.1734293721792175,0.26210751114864683},
{0.06594135462110738,-0.21591203731098405,0.2194860594845533},
{0.1820604958659903,-0.1314566668639085,0.2446053459711561},
{0.006338456241897386,-0.16966814956669554,0.4384029866001065},
{-0.03520713083051368,-0.27349984130997274,0.30650091179524147},
{0.3557620617869035,-0.48974539664437833,-0.25248605410523034},
{0.3373185150916906,-0.48083401023147226,-0.2380436478264846},
{0.35134886523182185,-0.4693986454864791,-0.24101303409952826},
{0.37293070894097263,-0.4966804198023637,-0.2523160674997445},
{0.37053691022447915,-0.4688542580030877,-0.25352856689457065},
{0.3726413013658101,-0.42937648267589046,-0.23129367337826862},
{0.33509362711609114,-0.4674997444821594,-0.21861998848824887},
{0.3266362555608751,-0.49531514763551854,-0.21220030446967947},
{0.337123783600596,-0.4938756408118475,-0.2241660704583721},
{0.3443611247088441,-0.5000145241719878,-0.2447312221283829},
{0.3565140911364896,-0.5136489561423799,-0.24564463116672136},
{0.3723723352178895,-0.5076628455542586,-0.24749081480604854},
{0.38360866501342145,-0.5069979612365988,-0.24540471336277617},
{0.38584753922871273,-0.4737774143746268,-0.2504429872456253},
{0.40227491567911267,-0.4442944211041598,-0.235626180088974},
{0.3934291570062992,-0.4394476511186302,-0.24132611069570786},
{0.39100093062287183,-0.5088592069802095,-0.22952925544790934},
{0.38365385132627206,-0.5141944194903629,-0.2350731856888492},
{0.3935109227152671,-0.5106247007751604,-0.22292559858416222},
{0.3949428984867965,-0.4835053820126199,-0.23394137613839922},
{0.4021242946362771,-0.48777333684782437,-0.2185565124773396},
{0.40391991263979515,-0.4627142987783558,-0.2205178136279768},
{0.41436763368962387,-0.47867259826678216,-0.21011097543263205},
{0.4212746843682254,-0.456699139846259,-0.2342447699532537},
{0.4248766790211784,-0.4738871525629785,-0.22613167506737603},
{0.4550008875882881,-0.473973221730313,-0.24156387677046967},
{0.4114853924485064,-0.4975712356842768,-0.2352205791379097},
{0.45820696407150197,-0.5049602736999521,-0.25993749226722324},
{0.47188980994851987,-0.4794655104708521,-0.24815785085289166},
{0.4759350608132461,-0.5117328413045934,-0.2502611661296309},
{0.4826086488754525,-0.5201998956411346,-0.23814477909810275},
{0.4802213053465091,-0.49228013362238227,-0.2393389887948703},
{0.4892940714481675,-0.5285948670500331,-0.22591972974281457},
{0.4913597314641979,-0.5050700118883037,-0.22113643576819425},
{0.5035772497673443,-0.5313017423627062,-0.2436510540783337},
{0.49957073002791874,-0.5063223182730222,-0.23123557669031775},
{0.5296680419802364,-0.5329747118027726,-0.2498405030742831},
{0.5209976492358672,-0.5060092416768425,-0.24389312361146226},
{0.5301769259321022,-0.5055347853919107,-0.23943258901434666},
{0.5516931419011604,-0.50572628928923,-0.2498706272828502},
{0.5529605103901624,-0.5453987961075218,-0.2510626852504344},
{0.5663517969628343,-0.5443476764014481,-0.25140803778436444},
{0.5649897523897642,-0.5047580111567158,-0.2502288901918805},
{0.5760356541525683,-0.5170228675018962,-0.23433406671436333},
{0.5696686874989914,-0.54062088145586,-0.23653205807517066},
{0.5703927443691937,-0.5447199255501702,-0.218514553758264},
{0.575149141729022,-0.5472331452363406,-0.20973872628390994},
{0.5805973200213022,-0.5325766419038499,-0.2116806618718968},
{0.6022566259810541,-0.5265098414713524,-0.22790362404987707},
{0.6046977627395816,-0.5476667186667886,-0.23471384691522723},
{0.6225743287949779,-0.5480669402948946,-0.23089237588557104},
{0.6177931865495409,-0.5257728742260499,-0.22840390108500946},
{0.6319085299924152,-0.5525575991005772,-0.2156441470276551},
{0.635507297051593,-0.5357977804913474,-0.21465219987412384},
{0.6345712948568294,-0.5587911585447856,-0.20047660801411535},
{0.6420625400087145,-0.547197641704815,-0.20071760168265224},
{0.6508996917647945,-0.5413180417112702,-0.20936647713518777},
{0.6493633571278719,-0.557298934356122,-0.2149383798555114},
{0.6687332232365235,-0.5345443982420373,-0.2157883128829406},
{0.668524505505737,-0.5600800443256212,-0.22348719990102048},
{0.6844247083062126,-0.5614033577733907,-0.21493300053255296},
{0.6866130168856948,-0.5349650612973851,-0.21187862095676638},
{0.6937234059721243,-0.5353642070608994,-0.202856420490917},
{0.694260262403374,-0.561178502073729,-0.19872940391722296},
{0.6905915641457366,-0.5648267589041244,-0.18043217480647888},
{0.6942591865387823,-0.5524123573807,-0.1709419732432476},
{0.6933199567502435,-0.5647008827468974,-0.17102589068139884},
{0.7188351614065854,-0.5667213564500772,-0.1867582586055719},
{0.7082023916469873,-0.5404724121422078,-0.17612979230434056},
{0.7416370355627041,-0.5600520718462374,-0.1839147484897551},
{0.7219347272952227,-0.5314351495720748,-0.1795822417790497},
{0.7453294028413584,-0.5210509045331555,-0.17134004314217013},
{0.7555049301494914,-0.5587147721587761,-0.17481723750248793},
{0.7504709597250091,-0.5222784660322651,-0.15756682463945088},
{0.7524591574904382,-0.5321032614835097,-0.14786145015788313},
{0.7567066708984007,-0.5620553317159502,-0.1494935367434655},
{0.7496328612080884,-0.5456839002243178,-0.14115343442874279},
{0.7544774794644347,-0.5719425273135124,-0.13729753573215275},
{0.7516458038591264,-0.5521842740872634,-0.1354147726967084},
{0.4039521885775456,-0.49322366686928787,-0.21743438570821477},
{0.40378758129501824,-0.5115929789076747,-0.2353808829620704},
{0.4245958783627493,-0.5183182084702819,-0.24946932979015263},
{0.4448242844155635,-0.5393718026649166,-0.2546775902784876},
{0.43650892698644955,-0.5037391673883925,-0.25402561633592796},
{0.46292893376439637,-0.5341312662388311,-0.25435267917179943},
{0.4767968283511837,-0.5327950424159615,-0.24525624404912397},
{0.4887561391523263,-0.5362302780572037,-0.22515156242435327},
{0.4936104401899977,-0.5479216985750174,-0.241925367273275},
{0.5034255528599171,-0.5602844585980409,-0.24731760060678765},
{0.5338606862940231,-0.5696896668585292,-0.2434681570977477},
{0.5534769253941699,-0.5745601058650759,-0.24287965916609736},
{0.564543268584216,-0.5834790233301237,-0.23104084519922324},
{0.5715428436177022,-0.586717375751088,-0.22018214387537183},
{0.5864016094934292,-0.589075670936056,-0.22836947341807562},
{0.5944544559621726,-0.60044755967014,-0.22631457204796204},
{0.6150099248508584,-0.5930305491750808,-0.22564215667816048},
{0.6240364287750744,-0.5989079974394423,-0.21541498786962676},
{0.6311554247782374,-0.5992135429834801,-0.20637449770571878},
{0.6441809173897374,-0.5967110819432266,-0.21347843160459826},
{0.6612527367305551,-0.6032340489625976,-0.215546243349812},
{0.6795359796016074,-0.5985282172385784,-0.21291898201692339},
{0.6915211111529502,-0.598505624082153,-0.196940241101255},
{0.6964926814311151,-0.5991048806597201,-0.18545000726208602},
{0.7161003136145285,-0.6040689198857432,-0.18488087489308597},
{0.7308826931042459,-0.61653603877416,-0.181007762363029},
{0.7514715137952738,-0.6169965088194,-0.16781766246900165},
{0.7591833111884538,-0.6131115617788345,-0.1555140749985207},
{0.762703540132439,-0.6070695062319457,-0.14016794246276165},
{0.7553661436171644,-0.5664384040624647,-0.12912096483536584},
{0.7625894984857207,-0.6098893473267455,-0.1384196625012776},
{0.7622387666288322,-0.561883193381281,-0.13079285841084043},
{0.7566023120330077,-0.5523607158802993,-0.1262580891568987},
{0.7696084390818573,-0.5299622909460615,-0.12216550025013853},
{0.777348208954421,-0.5232488958939627,-0.11160588928277487},
{0.776240068424988,-0.5538862918713051,-0.1297245248712997},
{0.7850341855974007,-0.5232994615297718,-0.09304076988870182},
{0.7952796441039931,-0.5503380904479362,-0.11089259105848938},
{0.7974496629854168,-0.5611946400426042,-0.09665997837512172},
{0.7887028838550381,-0.5443369177555313,-0.07865323270413185},
{0.7884403728946675,-0.5761609923774994,-0.08048327837458379},
{0.7828394218303685,-0.5637153907809163,-0.07767096833192574},
{0.7933667568599816,-0.5463240396563689,-0.07218513477893673},
{0.8115338063551321,-0.5676799518012663,-0.07494903091496904},
{0.8181492977293878,-0.5495720748586583,-0.05965561574420244},
{0.7993001500831106,-0.5308154515672657,-0.06680366009134091},
{0.8076929697628256,-0.524332291537787,-0.044588132137689154},
{0.8218276787683502,-0.5472761798200079,-0.03810927556657719},
{0.8082976056633512,-0.5313652183736155,-0.024751340796247388},
{0.43793014411206205,-0.5472708004970495,-0.2489486113277783},
{0.45619509728505575,-0.5464068812299284,-0.24004152837323894},
{0.4764202757440949,-0.5448081464466883,-0.23590482901821977},
{0.4926206447656498,-0.5442271795671797,-0.22464160260789576},
{0.5004023733572892,-0.5766967729441572,-0.2387666288320952},
{0.5249073411620414,-0.5778931343701083,-0.2352948137947358},
{0.5423169819846474,-0.5898008036708501,-0.22434143638681636},
{0.5676568207125452,-0.5820674889858363,-0.21663609418118634},
{0.581902343771013,-0.6021710947460153,-0.2119948143326681},
{0.6016961005287874,-0.6080506947395601,-0.20696837496032752},
{0.6206937174887168,-0.5973275523542607,-0.19837652033115113},
{0.6270585324131105,-0.5969714411744138,-0.20331904226534048},
{0.6396816516673212,-0.6098054298885942,-0.19710377251919073},
{0.6664405557916481,-0.6116559169862881,-0.1914414971731658},
{0.6925496377025987,-0.6007229810056107,-0.17612441298138218},
{0.6967670269019942,-0.6006605808592931,-0.1786161153757188},
{0.7028790136473423,-0.6196130115063718,-0.16389936362609403},
{0.7419737811799008,-0.6221294587863172,-0.1731367370102799},
{0.7221724933699846,-0.630208126005261,-0.1598272161465758},
{0.7346869503004352,-0.622641570331958,-0.14463600811201902},
{0.7420329537324433,-0.6173063578218045,-0.13909207787107916},
{0.7540062507732777,-0.6066703604684315,-0.1373932876808125},
{0.7643657509265884,-0.622123003598767,-0.12920488227351706},
{0.7795720210654287,-0.6159077338526173,-0.14270590703454064},
{0.7950612435918816,-0.6218411270757462,-0.13518238594490498},
{0.8048451561886422,-0.6284006734912344,-0.11088613587093928},
{0.8084546818937369,-0.6228621225732529,-0.09332049468253925},
{0.805251833004298,-0.615004007595604,-0.08215624781465006},
{0.8013668859637326,-0.6103530449657606,-0.07861019812046456},
{0.8141901160319963,-0.6203757995018747,-0.07414858765875727},
{0.8160857894425407,-0.6296755730323782,-0.06675201859094015},
{0.8211133046794732,-0.6337229756262877,-0.05123052012673685},
{0.8243161535689119,-0.632817097640091,-0.03460733632065068},
{0.8196415219180514,-0.5649676971656347,-0.013288003571870446},
{0.8221074035621877,-0.6301166775149679,0.0},
{0.8103600380856065,-0.578398790728199,0.0},
{0.8057456548518803,-0.5465004814494048,-0.011208357316148191},
{0.8028322135376043,-0.5600725132734794,0.0},
{0.8196415219180514,-0.5649676971656347,0.013288003571870446},
{0.8057456548518803,-0.5465004814494048,0.011208357316148191},
{0.820808835000027,-0.6175989929907422,0.0},
{0.8218276787683502,-0.5472761798200079,0.03810927556657719},
{0.8243161535689119,-0.632817097640091,0.03460733632065068},
{0.8211133046794732,-0.6337229756262877,0.05123052012673685},
{0.8160857894425407,-0.6296755730323782,0.06675201859094015},
{0.8181492977293878,-0.5495720748586583,0.05965561574420244},
{0.8082976056633512,-0.5313652183736155,0.024751340796247388},
{0.7993001500831106,-0.5308154515672657,0.06680366009134091},
{0.8076929697628256,-0.524332291537787,0.044588132137689154},
{0.40703346476812424,-0.5266281865764375,-0.2363018230525506},
{0.3964566399672937,-0.5275620370420179,-0.22655664158109062},
{0.400714912021173,-0.511547792594824,-0.21159674443374557},
{0.4124267739662286,-0.5332318434401846,-0.20950311193833143},
{0.42200842401975286,-0.5266615383787796,-0.24401362044573072},
{0.39826516834591197,-0.513116403169497,-0.2142390678709178},
{0.3733707375589709,-0.5133175898481417,-0.22263834273818298},
{0.37972264210826434,-0.5270337875275017,-0.2091738973732766},
{0.3965706816140121,-0.5159760512541891,-0.20051749086859927},
{0.40656653953533406,-0.5293694895560445,-0.201382486000312},
{0.4324787382260069,-0.5300332980091126,-0.21200987643695166},
{0.44522450604366937,-0.5399538454090168,-0.20752459695422737},
{0.449729151089044,-0.5375654260154817,-0.20963867087688345},
{0.457685169744536,-0.547916319252059,-0.21211638703152824},
{0.4684470432551359,-0.5480325126279607,-0.21724610940467032},
{0.4801621327939666,-0.5464746606992044,-0.20801411534344286},
{0.4888873946325116,-0.5666772460018182,-0.22196592736838142},
{0.4895436720334379,-0.5669268465870886,-0.21022178948557535},
{0.523048247147614,-0.567115122890633,-0.20459286594189258},
{0.5316938950063745,-0.5747742029188206,-0.19713927605071624},
{0.549447812498319,-0.577612333711679,-0.19372448183671603},
{0.5604087209583801,-0.5753928250590381,-0.19847227227981087},
{0.5777850099786441,-0.5800330290429646,-0.19774283608665014},
{0.5957024588885244,-0.5877426747069614,-0.18352098204919928},
{0.6065202773578917,-0.5917814703841374,-0.18248384858281738},
{0.6228260811094316,-0.577653216566163,-0.18731770819324683},
{0.6354513520928257,-0.5904882811449351,-0.18110351431168875},
{0.6506425601273824,-0.5983442443934007,-0.17619972350279997},
{0.6821062201111369,-0.5954706100690167,-0.17227066601397548},
{0.6865054304265266,-0.596438888201531,-0.1702362060711039},
{0.7066370086660893,-0.6077042663410384,-0.15218857754563012},
{0.8025965991920258,-0.6349397784794806,-0.024639450878712405},
{0.8015691485069689,-0.6327234974206146,-0.04545527899858524},
{0.7888707187313405,-0.606756429635766,-0.03247066924156926},
{0.7898519072389549,-0.6017784041700511,-0.0219852929310317},
{0.8038435262537856,-0.6314765703588546,0.0},
{0.8025965991920258,-0.6349397784794806,0.024639450878712405},
{0.8015691485069689,-0.6327234974206146,0.04545527899858524},
{0.7964458813213768,-0.6276550993291984,0.06550831912295518},
{0.8141901160319963,-0.6203757995018747,0.07414858765875727},
{0.8115338063551321,-0.5676799518012663,0.07494903091496904},
{0.7933667568599816,-0.5463240396563689,0.07218513477893673},
{0.7828394218303685,-0.5637153907809163,0.07767096833192574},
{0.7884403728946675,-0.5761609923774994,0.08048327837458379},
{0.7974496629854168,-0.5611946400426042,0.09665997837512172},
{0.7887028838550381,-0.5443369177555313,0.07865323270413185},
{0.7952796441039931,-0.5503380904479362,0.11089259105848938},
{0.7850341855974007,-0.5232994615297718,0.09304076988870182},
{0.777348208954421,-0.5232488958939627,0.11160588928277487},
{0.776240068424988,-0.5538862918713051,0.1297245248712997},
{0.7696084390818573,-0.5299622909460615,0.12216550025013853},
{0.7622387666288322,-0.561883193381281,0.13079285841084043},
{0.7553661436171644,-0.5664384040624647,0.12912096483536584},
{0.7566023120330077,-0.5523607158802993,0.1262580891568987},
{0.7964458813213768,-0.6276550993291984,-0.06550831912295518},
{0.789085891649677,-0.6136107629493752,-0.05754476941532139},
{0.7859067117812553,-0.6024271505188357,-0.05034723529696553},
{0.7846425708860283,-0.5967013991619015,-0.04203402959703492},
{0.7564280219691549,-0.5687353749657068,-0.0303114090060625},
{0.7706025379645718,-0.5757263430824596,-0.0063809528932688535},
{0.7924963824053105,-0.611852800206566,0.0},
{0.7898519072389549,-0.6017784041700511,0.0219852929310317},
{0.7888707187313405,-0.606756429635766,0.03247066924156926},
{0.7846425708860283,-0.5967013991619015,0.04203402959703492},
{0.7859067117812553,-0.6024271505188357,0.05034723529696553},
{0.789085891649677,-0.6136107629493752,0.05754476941532139},
{0.7901004319596335,-0.6144563925184376,0.0766596556157442},
{0.805251833004298,-0.615004007595604,0.08215624781465006},
{0.8013668859637326,-0.6103530449657606,0.07861019812046456},
{0.7901004319596335,-0.6144563925184376,-0.0766596556157442},
{0.785704449238019,-0.6135085558131653,-0.07860589466209783},
{0.7709941526759443,-0.5821460271010291,-0.06684023948745811},
{0.7633651968563236,-0.5767763869239417,-0.053585587717929824},
{0.7480158367267896,-0.5553236469657928,-0.041331490018666255},
{0.753571601478238,-0.5523026191923485,-0.024461933221084795},
{0.7859572774170643,-0.6276507958708317,-0.09336675685998161},
{0.7873322323652345,-0.6305351888411325,-0.10351753928250591},
{0.7688478028155377,-0.6138388462428119,-0.10161218309063622},
{0.777612871643975,-0.6273301882225103,-0.1237642350333787},
{0.7569691818587713,-0.6110007154499535,-0.11951672162541624},
{0.34077204043099135,-0.4862520643151853,-0.1707956556587788},
{0.34167791841718803,-0.5001479313813564,-0.1760372679494559},
{0.3494725573839277,-0.4959133283484941,-0.19913392900369561},
{0.3597567470158206,-0.4967890821261236,-0.21156877195436183},
{0.36771276567131256,-0.5071410512272926,-0.2140464881090066},
{0.36941370759076264,-0.5294824553381712,-0.19277126580848536},
{0.39516237486349964,-0.5165096800916636,-0.18641828539460026},
{0.4038241606911354,-0.5101158168232947,-0.19728129017681836},
{0.41237620833041955,-0.5400140938261511,-0.20141045847969577},
{0.4249756585636132,-0.5556980478436984,-0.1933640671985024},
{0.43998289375299227,-0.5625050431152735,-0.1930757354879315},
{0.45083298816011014,-0.5631258169846743,-0.19598702507302432},
{0.4575915695250596,-0.5613904473982905,-0.19591171455160655},
{0.47406735988208526,-0.5483660306513822,-0.196326998283996},
{0.47981462853085316,-0.5550482256303222,-0.20269934426053135},
{0.7372098527679306,-0.5784611908745165,-0.12135214661882657},
{0.7358596427053691,-0.5727268326008489,-0.11303248573134586},
{0.7360597535194221,-0.5611494537297537,-0.08699871434181293},
{0.7479555883096554,-0.5606222800798292,-0.07323948207878557},
{0.7653910498824618,-0.5692055277922721,-0.06625281742039947},
{0.7478738226006876,-0.601273823676552,-0.13601833273264227},
{0.7361049398322728,-0.6095934845640327,-0.13724697009634368},
{0.7151277320236475,-0.5785257427500176,-0.12043766171589644},
{0.7363814370323352,-0.5879083578540805,-0.12327256491497982},
{0.7270192633555141,-0.6099840234108135,-0.1416945943183591},
{0.7022410259444747,-0.5753583973921043,-0.11691420517813629},
{0.7133256588325794,-0.5469846205156619,-0.11625254845425155},
{0.7219002996282887,-0.5502972075934522,-0.11729828883736693},
{0.7157872370183489,-0.6106682732911236,-0.1436913990005218},
{0.6903441152896497,-0.5758866469066204,-0.13067343744116366},
{0.6861633054863715,-0.5497850960478115,-0.12276690855688903},
{0.6847625297880009,-0.5822320962683637,-0.14357628148921178},
{0.6798243113121784,-0.5786903500325449,-0.15687827130077409},
{0.6747634442729038,-0.5688192924038581,-0.14279950725401702},
{0.6716359059048828,-0.528219390307536,-0.13426252171901645},
{0.688479641952264,-0.5399065073669828,-0.13496828889116017},
{0.7816129361958504,-0.5807226582462331,0.0},
{0.7706025379645718,-0.5757263430824596,0.0063809528932688535},
{0.7564280219691549,-0.5687353749657068,0.0303114090060625},
{0.7633651968563236,-0.5767763869239417,0.053585587717929824},
{0.7709941526759443,-0.5821460271010291,0.06684023948745811},
{0.785704449238019,-0.6135085558131653,0.07860589466209783},
{0.7859572774170643,-0.6276507958708317,0.09336675685998161},
{0.8048451561886422,-0.6284006734912344,0.11088613587093928},
{0.8084546818937369,-0.6228621225732529,0.09332049468253925},
{0.6829141944194904,-0.5893693819695853,-0.16629423820717926},
{0.6734799378150267,-0.5989424251063762,-0.16313227217222442},
{0.6622844908739786,-0.6069156575953351,-0.15481799060770213},
{0.6496656750781347,-0.604787597432987,-0.14677267519110046},
{0.6573430448043809,-0.5714788296744971,-0.13312318111642468},
{0.6613226679290145,-0.5199621295663728,-0.13211939945238493},
{0.632034406149642,-0.5990360253258525,-0.15191638380393443},
{0.6372878529508276,-0.5741814015288036,-0.1328402287288122},
{0.6396719688859961,-0.51206958692179,-0.13423132164585766},
{0.6206625174155581,-0.5919998708962491,-0.16655244570918307},
{0.6055272543397688,-0.5875909777995342,-0.16742497189303754},
{0.5922155817468814,-0.5924205339515969,-0.16069759060124694},
{0.5949880847996472,-0.5623619531245797,-0.1522628122024562},
{0.6141729021985293,-0.5613215920644228,-0.16700323297309802},
{0.6211176081378398,-0.5713239051732949,-0.14814009908712888},
{0.6217545199761159,-0.5269918288084262,-0.15788635642318058},
{0.5138087220342448,-0.5883322485032034,-0.18262478684432776},
{0.49859061738489596,-0.5839341140524054,-0.18340263694411424},
{0.5295572279272931,-0.5851864204371238,-0.1826344696256529},
{0.5457113347714057,-0.5774100711684427,-0.18170277088925588},
{0.5532015040586992,-0.5658165543284722,-0.18194484042238446},
{0.5733750410173376,-0.5936319574818314,-0.17914866834860163},
{0.5823434482536028,-0.5955663620176764,-0.17517765214070158},
{0.5817732400200111,-0.5639273361054777,-0.14970548206802692},
{0.5884349935717091,-0.5050883015863623,-0.14962479222365074},
{0.6091927250036311,-0.5185968573995277,-0.15562058559309727},
{0.6110173913511245,-0.5235512138442255,-0.1567233467995718},
{0.48021592602355073,-0.5643964130674514,-0.18333378161024655},
{0.48445160492100464,-0.55172810750039,-0.1643178749522585},
{0.5003270628358715,-0.5563758425364584,-0.15179696283425767},
{0.5323716896991345,-0.5624361877814058,-0.16379930821906755},
{0.5451013195479217,-0.561723965421712,-0.1736822003582629},
{0.5521697499152757,-0.55433707913522,-0.1771970499792896},
{0.5567271123256426,-0.5596615329994568,-0.1666675632204931},
{0.566261424337133,-0.5613398817624814,-0.15317299364701958},
{0.5540923199406123,-0.5036197464187158,-0.17152401598734784},
{0.4728989709355181,-0.5436612747919547,-0.18348117505930706},
{0.4859782567766021,-0.5018919078844736,-0.1658864855269316},
{0.5069888163875694,-0.49753573215275126,-0.1517173488544732},
{0.5433562671802127,-0.5001780555899235,-0.17036100636373908},
{0.3495564748220789,-0.5103976933463155,-0.17849023921849197},
{0.35712840981834026,-0.5220331689053616,-0.18596534640150192},
{0.37106085628062846,-0.501419603328725,-0.1633851003512698},
{0.3899906937712819,-0.5094789049850186,-0.17050194462524945},
{0.36321887927185487,-0.488248868997348,-0.1626556641581091},
{0.3825941247034648,-0.4422728715363884,-0.15627686299402357},
{0.46456209621457045,-0.5448264361447468,-0.17387693184935746},
{0.47728096741744086,-0.5014927621209595,-0.16311183074498245},
{0.45165387284356395,-0.5450050296669661,-0.1662974658009543},
{0.45865237201245856,-0.49105472385245597,-0.1554204747790443},
{0.421743761330199,-0.5280354174623582,-0.17102373895221548},
{0.4313512321339236,-0.48613479507469187,-0.1745740921047677},
{0.4493837985551139,-0.49102352377929714,-0.1621005180288009},
{0.4145376202951097,-0.47053260676611236,-0.18003948423051477},
{0.7608605840868868,-0.5532343179287456,-0.01313845839362658},
{0.7810459555560337,-0.558345750603829,0.0},
{0.7608605840868868,-0.5532343179287456,0.01313845839362658},
{0.7512735547104042,-0.5568944092696493,-0.05836350236959177},
{0.7490820185371468,-0.5493848744197055,-0.06853902967772477},
{0.7349397784794806,-0.5491653980430024,-0.0844704325513591},
{0.7314475220148792,-0.5523800814429496,-0.10155946572564377},
{0.744710780701141,-0.5455870724110664,-0.07231746612371368},
{0.359514677482692,-0.42780249277825894,-0.21378612887781942},
{0.3706455725482391,-0.43520659289821784,-0.17371232456683003},
{0.3557620617869035,-0.48974539664437833,0.25248605410523034},
{0.35134886523182185,-0.4693986454864791,0.24101303409952826},
{0.3373185150916906,-0.48083401023147226,0.2380436478264846},
{0.3443611247088441,-0.5000145241719878,0.2447312221283829},
{0.337123783600596,-0.4938756408118475,0.2241660704583721},
{0.33509362711609114,-0.4674997444821594,0.21861998848824887},
{0.3726413013658101,-0.42937648267589046,0.23129367337826862},
{0.3934291570062992,-0.4394476511186302,0.24132611069570786},
{0.37053691022447915,-0.4688542580030877,0.25352856689457065},
{0.37293070894097263,-0.4966804198023637,0.2523160674997445},
{0.3723723352178895,-0.5076628455542586,0.24749081480604854},
{0.3565140911364896,-0.5136489561423799,0.24564463116672136},
{0.36771276567131256,-0.5071410512272926,0.2140464881090066},
{0.3597567470158206,-0.4967890821261236,0.21156877195436183},
{0.3494725573839277,-0.4959133283484941,0.19913392900369561},
{0.3266362555608751,-0.49531514763551854,0.21220030446967947},
{0.3706455725482391,-0.43520659289821784,0.17371232456683003},
{0.359514677482692,-0.42780249277825894,0.21378612887781942},
{0.38360866501342145,-0.5069979612365988,0.24540471336277617},
{0.38584753922871273,-0.4737774143746268,0.2504429872456253},
{0.38365385132627206,-0.5141944194903629,0.2350731856888492},
{0.3733707375589709,-0.5133175898481417,0.22263834273818298},
{0.37972264210826434,-0.5270337875275017,0.2091738973732766},
{0.36941370759076264,-0.5294824553381712,0.19277126580848536},
{0.35712840981834026,-0.5220331689053616,0.18596534640150192},
{0.3495564748220789,-0.5103976933463155,0.17849023921849197},
{0.34167791841718803,-0.5001479313813564,0.1760372679494559},
{0.34077204043099135,-0.4862520643151853,0.1707956556587788},
{0.36321887927185487,-0.488248868997348,0.1626556641581091},
{0.37106085628062846,-0.501419603328725,0.1633851003512698},
{0.3825941247034648,-0.4422728715363884,0.15627686299402357},
{0.40227491567911267,-0.4442944211041598,0.235626180088974},
{0.3949428984867965,-0.4835053820126199,0.23394137613839922},
{0.39100093062287183,-0.5088592069802095,0.22952925544790934},
{0.3935109227152671,-0.5106247007751604,0.22292559858416222},
{0.39826516834591197,-0.513116403169497,0.2142390678709178},
{0.400714912021173,-0.511547792594824,0.21159674443374557},
{0.3965706816140121,-0.5159760512541891,0.20051749086859927},
{0.39516237486349964,-0.5165096800916636,0.18641828539460026},
{0.3899906937712819,-0.5094789049850186,0.17050194462524945},
{0.4021242946362771,-0.48777333684782437,0.2185565124773396},
{0.4039521885775456,-0.49322366686928787,0.21743438570821477},
{0.40378758129501824,-0.5115929789076747,0.2353808829620704},
{0.40703346476812424,-0.5266281865764375,0.2363018230525506},
{0.3964566399672937,-0.5275620370420179,0.22655664158109062},
{0.4124267739662286,-0.5332318434401846,0.20950311193833143},
{0.40656653953533406,-0.5293694895560445,0.201382486000312},
{0.4038241606911354,-0.5101158168232947,0.19728129017681836},
{0.4145376202951097,-0.47053260676611236,0.18003948423051477},
{0.4313512321339236,-0.48613479507469187,0.1745740921047677},
{0.421743761330199,-0.5280354174623582,0.17102373895221548},
{0.4493837985551139,-0.49102352377929714,0.1621005180288009},
{0.45165387284356395,-0.5450050296669661,0.1662974658009543},
{0.45865237201245856,-0.49105472385245597,0.1554204747790443},
{0.47728096741744086,-0.5014927621209595,0.16311183074498245},
{0.46456209621457045,-0.5448264361447468,0.17387693184935746},
{0.4859782567766021,-0.5018919078844736,0.1658864855269316},
{0.4728989709355181,-0.5436612747919547,0.18348117505930706},
{0.48445160492100464,-0.55172810750039,0.1643178749522585},
{0.5069888163875694,-0.49753573215275126,0.1517173488544732},
{0.5003270628358715,-0.5563758425364584,0.15179696283425767},
{0.5433562671802127,-0.5001780555899235,0.17036100636373908},
{0.5323716896991345,-0.5624361877814058,0.16379930821906755},
{0.5451013195479217,-0.561723965421712,0.1736822003582629},
{0.5540923199406123,-0.5036197464187158,0.17152401598734784},
{0.5521697499152757,-0.55433707913522,0.1771970499792896},
{0.5567271123256426,-0.5596615329994568,0.1666675632204931},
{0.566261424337133,-0.5613398817624814,0.15317299364701958},
{0.5884349935717091,-0.5050883015863623,0.14962479222365074},
{0.5817732400200111,-0.5639273361054777,0.14970548206802692},
{0.6091927250036311,-0.5185968573995277,0.15562058559309727},
{0.5949880847996472,-0.5623619531245797,0.1522628122024562},
{0.6110173913511245,-0.5235512138442255,0.1567233467995718},
{0.6141729021985293,-0.5613215920644228,0.16700323297309802},
{0.6217545199761159,-0.5269918288084262,0.15788635642318058},
{0.6211176081378398,-0.5713239051732949,0.14814009908712888},
{0.6396719688859961,-0.51206958692179,0.13423132164585766},
{0.6372878529508276,-0.5741814015288036,0.1328402287288122},
{0.6613226679290145,-0.5199621295663728,0.13211939945238493},
{0.6573430448043809,-0.5714788296744971,0.13312318111642468},
{0.6716359059048828,-0.528219390307536,0.13426252171901645},
{0.6747634442729038,-0.5688192924038581,0.14279950725401702},
{0.688479641952264,-0.5399065073669828,0.13496828889116017},
{0.6861633054863715,-0.5497850960478115,0.12276690855688903},
{0.6798243113121784,-0.5786903500325449,0.15687827130077409},
{0.6847625297880009,-0.5822320962683637,0.14357628148921178},
{0.6903441152896497,-0.5758866469066204,0.13067343744116366},
{0.7133256588325794,-0.5469846205156619,0.11625254845425155},
{0.7022410259444747,-0.5753583973921043,0.11691420517813629},
{0.7219002996282887,-0.5502972075934522,0.11729828883736693},
{0.7151277320236475,-0.5785257427500176,0.12043766171589644},
{0.7372098527679306,-0.5784611908745165,0.12135214661882657},
{0.7363814370323352,-0.5879083578540805,0.12327256491497982},
{0.7478738226006876,-0.601273823676552,0.13601833273264227},
{0.7569691818587713,-0.6110007154499535,0.11951672162541624},
{0.7358596427053691,-0.5727268326008489,0.11303248573134586},
{0.7688478028155377,-0.6138388462428119,0.10161218309063622},
{0.7360597535194221,-0.5611494537297537,0.08699871434181293},
{0.7349397784794806,-0.5491653980430024,0.0844704325513591},
{0.7314475220148792,-0.5523800814429496,0.10155946572564377},
{0.40391991263979515,-0.4627142987783558,0.2205178136279768},
{0.41436763368962387,-0.47867259826678216,0.21011097543263205},
{0.4248766790211784,-0.4738871525629785,0.22613167506737603},
{0.4114853924485064,-0.4975712356842768,0.2352205791379097},
{0.4245958783627493,-0.5183182084702819,0.24946932979015263},
{0.42200842401975286,-0.5266615383787796,0.24401362044573072},
{0.4324787382260069,-0.5300332980091126,0.21200987643695166},
{0.4448242844155635,-0.5393718026649166,0.2546775902784876},
{0.43650892698644955,-0.5037391673883925,0.25402561633592796},
{0.43793014411206205,-0.5472708004970495,0.2489486113277783},
{0.44522450604366937,-0.5399538454090168,0.20752459695422737},
{0.43998289375299227,-0.5625050431152735,0.1930757354879315},
{0.4249756585636132,-0.5556980478436984,0.1933640671985024},
{0.41237620833041955,-0.5400140938261511,0.20141045847969577},
{0.45820696407150197,-0.5049602736999521,0.25993749226722324},
{0.46292893376439637,-0.5341312662388311,0.25435267917179943},
{0.45619509728505575,-0.5464068812299284,0.24004152837323894},
{0.457685169744536,-0.547916319252059,0.21211638703152824},
{0.449729151089044,-0.5375654260154817,0.20963867087688345},
{0.45083298816011014,-0.5631258169846743,0.19598702507302432},
{0.4767968283511837,-0.5327950424159615,0.24525624404912397},
{0.4759350608132461,-0.5117328413045934,0.2502611661296309},
{0.4764202757440949,-0.5448081464466883,0.23590482901821977},
{0.4801621327939666,-0.5464746606992044,0.20801411534344286},
{0.4684470432551359,-0.5480325126279607,0.21724610940467032},
{0.4575915695250596,-0.5613904473982905,0.19591171455160655},
{0.4550008875882881,-0.473973221730313,0.24156387677046967},
{0.47188980994851987,-0.4794655104708521,0.24815785085289166},
{0.4802213053465091,-0.49228013362238227,0.2393389887948703},
{0.4826086488754525,-0.5201998956411346,0.23814477909810275},
{0.4887561391523263,-0.5362302780572037,0.22515156242435327},
{0.4926206447656498,-0.5442271795671797,0.22464160260789576},
{0.4888873946325116,-0.5666772460018182,0.22196592736838142},
{0.47981462853085316,-0.5550482256303222,0.20269934426053135},
{0.47406735988208526,-0.5483660306513822,0.196326998283996},
{0.4936104401899977,-0.5479216985750174,0.241925367273275},
{0.4892940714481675,-0.5285948670500331,0.22591972974281457},
{0.5034255528599171,-0.5602844585980409,0.24731760060678765},
{0.5004023733572892,-0.5766967729441572,0.2387666288320952},
{0.4895436720334379,-0.5669268465870886,0.21022178948557535},
{0.49859061738489596,-0.5839341140524054,0.18340263694411424},
{0.48021592602355073,-0.5643964130674514,0.18333378161024655},
{0.4913597314641979,-0.5050700118883037,0.22113643576819425},
{0.49957073002791874,-0.5063223182730222,0.23123557669031775},
{0.5035772497673443,-0.5313017423627062,0.2436510540783337},
{0.5296680419802364,-0.5329747118027726,0.2498405030742831},
{0.5338606862940231,-0.5696896668585292,0.2434681570977477},
{0.5249073411620414,-0.5778931343701083,0.2352948137947358},
{0.523048247147614,-0.567115122890633,0.20459286594189258},
{0.5138087220342448,-0.5883322485032034,0.18262478684432776},
{0.5534769253941699,-0.5745601058650759,0.24287965916609736},
{0.5529605103901624,-0.5453987961075218,0.2510626852504344},
{0.5423169819846474,-0.5898008036708501,0.22434143638681636},
{0.549447812498319,-0.577612333711679,0.19372448183671603},
{0.5316938950063745,-0.5747742029188206,0.19713927605071624},
{0.5295572279272931,-0.5851864204371238,0.1826344696256529},
{0.5301769259321022,-0.5055347853919107,0.23943258901434666},
{0.5516931419011604,-0.50572628928923,0.2498706272828502},
{0.5649897523897642,-0.5047580111567158,0.2502288901918805},
{0.5663517969628343,-0.5443476764014481,0.25140803778436444},
{0.5696686874989914,-0.54062088145586,0.23653205807517066},
{0.564543268584216,-0.5834790233301237,0.23104084519922324},
{0.5715428436177022,-0.586717375751088,0.22018214387537183},
{0.5676568207125452,-0.5820674889858363,0.21663609418118634},
{0.5604087209583801,-0.5753928250590381,0.19847227227981087},
{0.5532015040586992,-0.5658165543284722,0.18194484042238446},
{0.5457113347714057,-0.5774100711684427,0.18170277088925588},
{0.5733750410173376,-0.5936319574818314,0.17914866834860163},
{0.5823434482536028,-0.5955663620176764,0.17517765214070158},
{0.5922155817468814,-0.5924205339515969,0.16069759060124694},
{0.6055272543397688,-0.5875909777995342,0.16742497189303754},
{0.6206625174155581,-0.5919998708962491,0.16655244570918307},
{0.632034406149642,-0.5990360253258525,0.15191638380393443},
{0.6496656750781347,-0.604787597432987,0.14677267519110046},
{0.6622844908739786,-0.6069156575953351,0.15481799060770213},
{0.6734799378150267,-0.5989424251063762,0.16313227217222442},
{0.6829141944194904,-0.5893693819695853,0.16629423820717926},
{0.6865054304265266,-0.596438888201531,0.1702362060711039},
{0.7066370086660893,-0.6077042663410384,0.15218857754563012},
{0.7157872370183489,-0.6106682732911236,0.1436913990005218},
{0.7270192633555141,-0.6099840234108135,0.1416945943183591},
{0.7361049398322728,-0.6095934845640327,0.13724697009634368},
{0.7420329537324433,-0.6173063578218045,0.13909207787107916},
{0.7540062507732777,-0.6066703604684315,0.1373932876808125},
{0.7643657509265884,-0.622123003598767,0.12920488227351706},
{0.777612871643975,-0.6273301882225103,0.1237642350333787},
{0.7873322323652345,-0.6305351888411325,0.10351753928250591},
{0.7479555883096554,-0.5606222800798292,0.07323948207878557},
{0.744710780701141,-0.5455870724110664,0.07231746612371368},
{0.7950612435918816,-0.6218411270757462,0.13518238594490498},
{0.7795720210654287,-0.6159077338526173,0.14270590703454064},
{0.7625894984857207,-0.6098893473267455,0.1384196625012776},
{0.7544774794644347,-0.5719425273135124,0.13729753573215275},
{0.762703540132439,-0.6070695062319457,0.14016794246276165},
{0.7567066708984007,-0.5620553317159502,0.1494935367434655},
{0.7516458038591264,-0.5521842740872634,0.1354147726967084},
{0.7496328612080884,-0.5456839002243178,0.14115343442874279},
{0.7555049301494914,-0.5587147721587761,0.17481723750248793},
{0.7504709597250091,-0.5222784660322651,0.15756682463945088},
{0.7524591574904382,-0.5321032614835097,0.14786145015788313},
{0.7591833111884538,-0.6131115617788345,0.1555140749985207},
{0.7514715137952738,-0.6169965088194,0.16781766246900165},
{0.7416370355627041,-0.5600520718462374,0.1839147484897551},
{0.7453294028413584,-0.5210509045331555,0.17134004314217013},
{0.7219347272952227,-0.5314351495720748,0.1795822417790497},
{0.7188351614065854,-0.5667213564500772,0.1867582586055719},
{0.7082023916469873,-0.5404724121422078,0.17612979230434056},
{0.6933199567502435,-0.5647008827468974,0.17102589068139884},
{0.6942591865387823,-0.5524123573807,0.1709419732432476},
{0.6905915641457366,-0.5648267589041244,0.18043217480647888},
{0.694260262403374,-0.561178502073729,0.19872940391722296},
{0.6937234059721243,-0.5353642070608994,0.202856420490917},
{0.6866130168856948,-0.5349650612973851,0.21187862095676638},
{0.6844247083062126,-0.5614033577733907,0.21493300053255296},
{0.668524505505737,-0.5600800443256212,0.22348719990102048},
{0.6687332232365235,-0.5345443982420373,0.2157883128829406},
{0.6508996917647945,-0.5413180417112702,0.20936647713518777},
{0.6493633571278719,-0.557298934356122,0.2149383798555114},
{0.6420625400087145,-0.547197641704815,0.20071760168265224},
{0.6345712948568294,-0.5587911585447856,0.20047660801411535},
{0.6319085299924152,-0.5525575991005772,0.2156441470276551},
{0.635507297051593,-0.5357977804913474,0.21465219987412384},
{0.6225743287949779,-0.5480669402948946,0.23089237588557104},
{0.6177931865495409,-0.5257728742260499,0.22840390108500946},
{0.6046977627395816,-0.5476667186667886,0.23471384691522723},
{0.6022566259810541,-0.5265098414713524,0.22790362404987707},
{0.5805973200213022,-0.5325766419038499,0.2116806618718968},
{0.575149141729022,-0.5472331452363406,0.20973872628390994},
{0.5703927443691937,-0.5447199255501702,0.218514553758264},
{0.5760356541525683,-0.5170228675018962,0.23433406671436333},
{0.7419737811799008,-0.6221294587863172,0.1731367370102799},
{0.7308826931042459,-0.61653603877416,0.181007762363029},
{0.7161003136145285,-0.6040689198857432,0.18488087489308597},
{0.6964926814311151,-0.5991048806597201,0.18545000726208602},
{0.6915211111529502,-0.598505624082153,0.196940241101255},
{0.6795359796016074,-0.5985282172385784,0.21291898201692339},
{0.6612527367305551,-0.6032340489625976,0.215546243349812},
{0.6441809173897374,-0.5967110819432266,0.21347843160459826},
{0.6311554247782374,-0.5992135429834801,0.20637449770571878},
{0.6396816516673212,-0.6098054298885942,0.19710377251919073},
{0.6270585324131105,-0.5969714411744138,0.20331904226534048},
{0.6240364287750744,-0.5989079974394423,0.21541498786962676},
{0.6150099248508584,-0.5930305491750808,0.22564215667816048},
{0.5944544559621726,-0.60044755967014,0.22631457204796204},
{0.5864016094934292,-0.589075670936056,0.22836947341807562},
{0.5209976492358672,-0.5060092416768425,0.24389312361146226},
{0.4212746843682254,-0.456699139846259,0.2342447699532537},
{0.6925496377025987,-0.6007229810056107,0.17612441298138218},
{0.6967670269019942,-0.6006605808592931,0.1786161153757188},
{0.6664405557916481,-0.6116559169862881,0.1914414971731658},
{0.6506425601273824,-0.5983442443934007,0.17619972350279997},
{0.6354513520928257,-0.5904882811449351,0.18110351431168875},
{0.6228260811094316,-0.577653216566163,0.18731770819324683},
{0.6206937174887168,-0.5973275523542607,0.19837652033115113},
{0.6016961005287874,-0.6080506947395601,0.20696837496032752},
{0.581902343771013,-0.6021710947460153,0.2119948143326681},
{0.5777850099786441,-0.5800330290429646,0.19774283608665014},
{0.7028790136473423,-0.6196130115063718,0.16389936362609403},
{0.6821062201111369,-0.5954706100690167,0.17227066601397548},
{0.6065202773578917,-0.5917814703841374,0.18248384858281738},
{0.7346869503004352,-0.622641570331958,0.14463600811201902},
{0.7221724933699846,-0.630208126005261,0.1598272161465758},
{0.5957024588885244,-0.5877426747069614,0.18352098204919928},
{0.7653910498824618,-0.5692055277922721,0.06625281742039947},
{0.7512735547104042,-0.5568944092696493,0.05836350236959177},
{0.7490820185371468,-0.5493848744197055,0.06853902967772477},
{0.7480158367267896,-0.5553236469657928,0.041331490018666255},
{0.753571601478238,-0.5523026191923485,0.024461933221084795},
{0.7828932150599526,-0.7223085902408322,-0.005824730899369006},
{0.7820002474488561,-0.716745294437242,0.00019257976191116587},
{0.7817237502487937,-0.7296244694642732,0.00019257976191116587},
{0.7828932150599526,-0.7223085902408322,0.005824730899369006},
{0.7843294942898487,-0.7360333948369258,0.006535877394471133},
{0.7877550471497659,-0.7429522800260359,0.013752777075477281},
{0.7915281042727962,-0.7317977159394718,0.020172461094046704},
{0.7872343286873915,-0.7218868513208927,0.030189836307202376},
{0.7906738677870004,-0.7366014513413343,0.031144128200024747},
{0.7823875587018618,-0.7299450771125945,0.04303243193811627},
{0.7830094084358543,-0.706783864182854,0.037776833407747304},
{0.7876388537738641,-0.737662253828733,0.052603323345723714},
{0.7870654179464972,-0.7165742319671646,0.049451040092094015},
{0.7887061114488131,-0.7356245662920866,0.06998714341812941},
{0.7885382765725105,-0.72508862434574,0.06739646148135796},
{0.7832729952608165,-0.7381657584576405,0.0869029623931532},
{0.7829125806226028,-0.7171842471906487,0.08163983281064247},
{0.7802476640290054,-0.7314448323533999,0.09504295389382292},
{0.7745369747763547,-0.700030662140863,0.09094606152869601},
{0.7756849222956799,-0.7344163703556271,0.10334217335406165},
{0.7740194839077554,-0.7153520497910134,0.1023878814612393},
{0.7752244522504398,-0.7367488447903948,0.11861407123299463},
{0.7744369193693281,-0.7207819383852349,0.12009876436951646},
{0.7606959768043595,-0.7295717520992808,0.1450728091362421},
{0.7607078113148679,-0.7192273140502536,0.14037020500599795},
{0.7415907733852618,-0.7149087935792402,0.15562273732228063},
{0.7360134913419797,-0.6861251122933667,0.14078871633216244},
{0.7325147796898283,-0.6948482224027286,0.16037805881751724},
{0.7305061404971571,-0.7094337186721679,0.16727757844397703},
{0.7274270160357617,-0.7131379204613307,0.18020409151304217},
{0.727917610289569,-0.7003641801642846,0.17972533176974348},
{0.7094073599896717,-0.6912236345933501,0.1861181191735208},
{0.7075773143192198,-0.7059984830309257,0.1909046407419162},
{0.6931241493945571,-0.6753944388559256,0.1773218502719248},
{0.6971414277798996,-0.7008450916367664,0.19613764611585985},
{0.6830927879417097,-0.6860153741050151,0.20496834268438976},
{0.6853295104278175,-0.7027999375998536,0.2081109431566943},
{0.6699564812772665,-0.697770270633738,0.21498894549132047},
{0.671530471174898,-0.682969601445962,0.21239933941914071},
{0.6547050248255755,-0.6850105165763837,0.22600795063933254},
{0.6526458199970951,-0.6709790905716606,0.2121368284587702},
{0.64515457484521,-0.6829577669354535,0.23359602360446913},
{0.6332200089296761,-0.6666143079232048,0.20999585792132203},
{0.6388005185667331,-0.6850460201079093,0.2395412513381066},
{0.6329897739070561,-0.6717235888691049,0.234128576577352},
{0.6213532224834183,-0.6842186802369054,0.24860648638762328},
{0.6220568379263786,-0.671550374669844,0.24601688031544353},
{0.6029107516527971,-0.6751104106037213,0.255092874010877},
{0.6012453132648725,-0.6586087994964953,0.2455198308740862},
{0.5809114724820734,-0.6694728801433052,0.25913920074019486},
{0.5828932150599525,-0.6599988165489492,0.25458614178819455},
{0.5645411168550326,-0.6613888336014029,0.2636524527023029},
{0.5641860815397775,-0.6481998095719672,0.2522117086343513},
{0.5564022012189546,-0.6443557453858858,0.2512681753874457},
{0.5454412927588934,-0.6545194381835102,0.2680269181320839},
{0.5438016751211693,-0.6354691038585883,0.24749189067064023},
{0.53716466645508,-0.6426451206851106,0.2579783428457694},
{0.5385008902779497,-0.6536533671872058,0.2694287696950462},
{0.5278433756327429,-0.648390237604695,0.27685869056520546},
{0.5262941306207201,-0.6372754805080232,0.26752018590940146},
{0.5087101997342615,-0.6363803611677434,0.2787081017983077},
{0.5069188851891101,-0.6380587099307681,0.26773535882773797},
{0.4921182160013341,-0.6281855005728979,0.2854182692566314},
{0.48621602285136395,-0.630499685309607,0.267558917034702},
{0.4673571924237616,-0.6159615270822014,0.25633227002049525},
{0.4775994233365789,-0.6157893887475323,0.2899401281354729},
{0.4604178658074095,-0.6099711130357133,0.27496839647761934},
{0.4649644695718597,-0.6069877405229778,0.28616384341866735},
{0.43652076149695795,-0.5929412524139712,0.29357547459076805},
{0.4402228115569375,-0.5895415203042546,0.2938078613425715},
{0.4054099850992754,-0.5749129894511477,0.29619090141314813},
{0.4168216808232516,-0.5675314824876141,0.3057596410915722},
{0.3906340607971081,-0.5650548421975611,0.2942930762734202},
{0.39860621742147534,-0.5429587352135861,0.30290752405902194},
{0.35733712754912667,-0.5777629547545146,0.2693028935378194},
{0.3608605840868868,-0.5477915189594238,0.2840766661108033},
{0.39050495704610616,-0.5910315927637347,0.22805101749893758},
{0.3884349935717091,-0.6108135150110008,0.23729592193526525},
{0.4075369693970317,-0.5838663345831294,0.20989042319133716},
{0.40454176237378764,-0.6162068242091051,0.22392184919606017},
{0.4250348311161557,-0.6133105967282958,0.22159475408425097},
{0.43174607443907115,-0.5853693174177098,0.20153418290773922},
{0.4581650053524263,-0.6114267578282597,0.22913441314276184},
{0.44327073594517397,-0.6275421335470718,0.21966034954840585},
{0.4751131002652006,-0.6275873198599224,0.21201417989531837},
{0.47019424735202825,-0.6459630870858594,0.2100539546092729},
{0.49437000059172553,-0.6475510632231827,0.20169771432567496},
{0.4966970957035347,-0.6252311764041378,0.19887356977250845},
{0.5205221170863435,-0.6526764821379581,0.20454875549363358},
{0.5234355584006197,-0.6358725530804693,0.19764923586717378},
{0.5405955986379554,-0.6573618724347354,0.20026789028332895},
{0.5561450695815425,-0.6467968821444133,0.20576233075305142},
{0.5305631613205162,-0.6159249476860842,0.18668402394874584},
{0.7843294942898487,-0.7360333948369258,-0.006535877394471133},
{0.7420232709511181,-0.7705794068758507,-0.004904866673480476},
{0.7726413013658101,-0.7562951526920823,0.00019042803272780088},
{0.7420232709511181,-0.7705794068758507,0.004904866673480476},
{0.7760560955798104,-0.7684309052862607,0.024484526377510127},
{0.7759495849852338,-0.7579218599547061,0.041399269487942245},
{0.773678434832192,-0.7646901241009806,0.05667224323146689},
{0.7710780701140956,-0.7659660995067162,0.07382260068747748},
{0.7659289821783032,-0.7608589702899993,0.09481271887120286},
{0.7252957282796387,-0.7698445913597316,0.11172100679408489},
{0.7205339515968521,-0.7725159631408792,0.12432906394401201},
{0.7130072029134414,-0.7713056154752362,0.13434751502175935},
{0.7352065928982178,-0.75603156586712,0.1479550503773595},
{0.7228287707709108,-0.7421292436133989,0.15921612505850014},
{0.7102540654233258,-0.7333544920036363,0.1749441895243065},
{0.6826280144381028,-0.7248347203021027,0.19566426569551956},
{0.650457511417613,-0.7141718263339377,0.2224220939552548},
{0.6175607997977375,-0.7057133789141299,0.24697332393744925},
{0.5866178582763574,-0.693094563118286,0.26941263172617097},
{0.5433724051490879,-0.6717386509733886,0.28588842208319665},
{0.5145489168733223,-0.6470497103234587,0.2928223693765903},
{0.4654948708155591,-0.6045821072959757,0.30997810615555926},
{0.4246873268530423,-0.5610623086978273,0.3214231536818776},
{0.39210476769393804,-0.5032593317805021,0.3331941881794757},
{0.39001005933393224,-0.5179072281962592,0.32050328945598905},
{0.35643662888588845,-0.5169088258551778,0.30621365594926225},
{0.32942489658251617,-0.5420044433207636,0.3152982565614292},
{0.3218647960967633,-0.5752658730372195,0.3031130141960333},
{0.3303942505796221,-0.6050415014766242,0.2857668493843365},
{0.34635900525559854,-0.62141508469744,0.2609670946814634},
{0.388679214834021,-0.634287804536921,0.24373174392270988},
{0.4195145698962328,-0.6209352490895496,0.22135268455112242},
{0.4158211267529869,-0.6496726681979806,0.23000478759743298},
{0.4438925856791664,-0.6633286174602064,0.21747634442729039},
{0.4747419269810702,-0.6724304319058403,0.2076214247674788},
{0.5067037122707736,-0.6795526555027784,0.20017106247007752},
{0.538818270332496,-0.6859088635104386,0.19353943312694666},
{0.5559567932779981,-0.6727370533144699,0.19809141621435525},
{0.5665196318391368,-0.6571477753809906,0.20287471018897563},
{0.7915281042727962,-0.7317977159394718,-0.020172461094046704},
{0.7877550471497659,-0.7429522800260359,-0.013752777075477281},
{0.7760560955798104,-0.7684309052862607,-0.024484526377510127},
{0.7250203069441681,-0.8206985588793796,-0.010881294480276714},
{0.7221832520159013,-0.811066343190046,0.00019042803272780088},
{0.7250203069441681,-0.8206985588793796,0.010881294480276714},
{0.7240262080614535,-0.8174871030732072,0.032339413761383995},
{0.7215958299488426,-0.8054438748339134,0.04015987347832402},
{0.7383943796833731,-0.789611451502714,0.0508894710511735},
{0.7204930687423681,-0.8152062701388404,0.05786322533445941},
{0.7210363803611678,-0.8155548502665454,0.07094681463391019},
{0.7195258664744456,-0.8119098210299253,0.07932134461556668},
{0.7137022114396682,-0.80815290187577,0.09576055557647516},
{0.7106779560724488,-0.8140056052545226,0.10860207534279737},
{0.7049694185489813,-0.8155613054540954,0.1252758247846926},
{0.6939837652033115,-0.808474585388683,0.14962264049446736},
{0.6778049134735902,-0.7714228847157296,0.1806774719333825},
{0.6815865775133542,-0.7530148415520423,0.20758269364217818},
{0.6478829674497167,-0.7389296223177352,0.23840621419388158},
{0.6175769377666127,-0.7344142186264436,0.2677439657444714},
{0.5800271117877104,-0.7184300983878168,0.29801449189604995},
{0.5411410619859385,-0.6914355799179115,0.31683566706294347},
{0.5027305443336901,-0.646435391641608,0.3328230148953453},
{0.4698456672243232,-0.6016008865124235,0.3428748177754348},
{0.4462971430415768,-0.5587136962941844,0.3474515457484521},
{0.42459480249815756,-0.5062846630123132,0.3495957438796753},
{0.4195543768861251,-0.42836516995970886,0.3588686207953867},
{0.40185640435294817,-0.43786828189804033,0.3553376332054848},
{0.3825650763594894,-0.4934248535479324,0.3274641333641748},
{0.3520460254872322,-0.48870611144881304,0.31982872235700416},
{0.32283199836468585,-0.5102363136575631,0.33007956018655493},
{0.279628503956492,-0.5333286712534361,0.340119528556136},
{0.2837673550406946,-0.5698488948180982,0.3335567545468727},
{0.29556958961145147,-0.606485311758662,0.31984916378424616},
{0.3153020220875001,-0.631112928126866,0.29872025906819366},
{0.33993932123702914,-0.6478813536528293,0.2734094686842714},
{0.3775805957062245,-0.6692039139953845,0.24919606018386528},
{0.7872343286873915,-0.7218868513208927,-0.030189836307202376},
{0.7906738677870004,-0.7366014513413343,-0.031144128200024747},
{0.7830094084358543,-0.706783864182854,-0.037776833407747304},
{0.7823875587018618,-0.7299450771125945,-0.04303243193811627},
{0.7759495849852338,-0.7579218599547061,-0.041399269487942245},
{0.7240262080614535,-0.8174871030732072,-0.032339413761383995},
{0.7341199696606185,-0.8630714858227945,-0.027399043556377994},
{0.7357068699333503,-0.8694502869868799,0.00019365562650284834},
{0.7341199696606185,-0.8630714858227945,0.027399043556377994},
{0.7278078721012174,-0.8591241386359113,0.06337918309601553},
{0.7173031302280294,-0.850393497474408,0.09713658638923706},
{0.7058871310456867,-0.8466537921537196,0.13071647202483097},
{0.6921558712620429,-0.8436897852036344,0.16476543462239843},
{0.6610493983227271,-0.8312829147323519,0.19193101556238135},
{0.6568546022797571,-0.8058161239826355,0.20761604544452036},
{0.6366036030705176,-0.7952016439210962,0.23341097489469975},
{0.6127925679274007,-0.7885926077343904,0.2605571902720324},
{0.5854268761733649,-0.7777123891187054,0.2823520551703363},
{0.5836646099721889,-0.7603447070151751,0.3018445698424397},
{0.5562236076967353,-0.7410167996255991,0.3209723664179627},
{0.5299251736176485,-0.719002458350592,0.3381055100405063},
{0.5051985777070098,-0.6912785036875259,0.3499486274657472},
{0.48271300774084575,-0.6589218760926749,0.3568728919778157},
{0.46383050829222633,-0.6233333512644099,0.35965507781190664},
{0.4500734277583823,-0.5852283791561994,0.36041786580740953},
{0.44170535296427593,-0.5451976094288773,0.36124305394922995},
{0.4338569207679521,-0.5049645771583189,0.36417908841993146},
{0.42775138921015404,-0.4648025519508115,0.36833300160841753},
{0.4288993367294792,-0.42387128356025106,0.3706224414595179},
{0.43611408468130203,-0.3557819652818496,0.3684029328068769},
{0.4089312899078522,-0.37105493902537423,0.3641521918051394},
{0.3860928363556163,-0.39882515586588274,0.360856818560816},
{0.3785617842138389,-0.4263662135483628,0.3503735939794617},
{0.3769877943162074,-0.44372959219352653,0.34434660053685645},
{0.381814122874495,-0.4695836941962484,0.3350414476833946},
{0.35130152718978797,-0.47009472987729767,0.3298450217055682},
{0.31857049871703147,-0.4786704465375988,0.34678666143079234},
{0.2734670274399264,-0.4926728241983464,0.3469071582650608},
{0.2552935227572258,-0.5576464386192354,0.35282764111308956},
{0.26508389054153647,-0.5992479706504139,0.34721808313205704},
{0.2798974701044127,-0.6386063250079345,0.3422045541348166},
{0.304486355347316,-0.6606238938767167,0.32252053556539373},
{0.3297229110744122,-0.6724056870202316,0.29599509405746194},
{0.3512014717827614,-0.7063169389500636,0.28314066391603954},
{0.39083847506952774,-0.7394664787489847,0.2733911789862128},
{0.3977928637901634,-0.6997864408785509,0.2327762147856071},
{0.42277121201525575,-0.7276900649284281,0.21991210186285956},
{0.4519379010957681,-0.7517420937400819,0.20834225404390605},
{0.4579175564963394,-0.7813638735428758,0.19968154408086197},
{0.49005470771448706,-0.7902838668725155,0.18810416520976672},
{0.5706509518711975,-0.691759415160008,0.1853209035110841},
{0.5705369102244792,-0.6799378150266008,0.19122309666105425},
{0.5774514919552225,-0.6573209895802514,0.19098640645088408},
{0.5851869583694196,-0.681946454219272,0.18192332313055082},
{0.5963296879454751,-0.6640806468097925,0.1888088565173187},
{0.6098317885710904,-0.6811008246502095,0.17787592053664128},
{0.6166237217383821,-0.668876851159513,0.18233215167539016},
{0.6226302737537454,-0.6874226049909359,0.16856754008940436},
{0.6281785074530519,-0.6719193962247911,0.1749872241079738},
{0.6369898384589316,-0.6892881541929132,0.16137108183564017},
{0.641410566066155,-0.6784541977546705,0.1613700059710485},
{0.673573538034503,-0.6631801481465542,0.16398435692883695},
{0.6588729242537534,-0.6845166947288015,0.1546598385127248},
{0.6779393965475505,-0.665336180788286,0.16015212725326392},
{0.6680048629079545,-0.6915872768253387,0.15373459496387787},
{0.6815855016487625,-0.6749264377585437,0.15655551192326936},
{0.6720705551999225,-0.69359591601801,0.15208959800319533},
{0.6927562037042018,-0.7012506925878308,0.13277244925953618},
{0.701551396741206,-0.6900154386568906,0.1374718257960053},
{0.7012738236765521,-0.7054573231413095,0.12722098796645454},
{0.7137570805338439,-0.6830266222693212,0.13841428317831916},
{0.7118721657692163,-0.7081308466516406,0.10890331742846847},
{0.7224694319972889,-0.6924565754154182,0.11368661140308882},
{0.7262995099436785,-0.7125935329779394,0.09318278401480388},
{0.7311495075229831,-0.6941833380850687,0.09504940908137302},
{0.7273829055875027,-0.713130389409189,0.08245318644195442},
{0.7503719801825742,-0.6906609574119001,0.08598309816726467},
{0.7316713018499492,-0.7152476909256201,0.07861234984964792},
{0.7476909256201015,-0.6997918202015095,0.0773664986524796},
{0.7404277637616531,-0.7170121088559793,0.05998590617384896},
{0.747272414293937,-0.6995874059290897,0.06218066994088125},
{0.7473584834612716,-0.7229992953086923,0.04143369715487609},
{0.7696912806554168,-0.702768737526695,0.042852762551305296},
{0.7646411722620591,-0.7055025094541602,0.03587147721587761},
{0.7438005992565776,-0.7264700344814603,0.03899471212553188},
{0.7438178130900445,-0.7264807931273769,0.019498969859653464},
{0.7543784999219998,-0.7134542246512855,0.01566566431948875},
{0.7455564102702035,-0.7273425606653148,0.00018182111599434096},
{0.775962495360334,-0.7110991570600923,0.00019150389731948338},
{0.7438178130900445,-0.7264807931273769,-0.019498969859653464},
{0.7543784999219998,-0.7134542246512855,-0.01566566431948875},
{0.7438005992565776,-0.7264700344814603,-0.03899471212553188},
{0.7646411722620591,-0.7055025094541602,-0.03587147721587761},
{0.7473584834612716,-0.7229992953086923,-0.04143369715487609},
{0.7696912806554168,-0.702768737526695,-0.042852762551305296},
{0.7404277637616531,-0.7170121088559793,-0.05998590617384896},
{0.747272414293937,-0.6995874059290897,-0.06218066994088125},
{0.7316713018499492,-0.7152476909256201,-0.07861234984964792},
{0.7476909256201015,-0.6997918202015095,-0.0773664986524796},
{0.7273829055875027,-0.713130389409189,-0.08245318644195442},
{0.7503719801825742,-0.6906609574119001,-0.08598309816726467},
{0.7262995099436785,-0.7125935329779394,-0.09318278401480388},
{0.7311495075229831,-0.6941833380850687,-0.09504940908137302},
{0.7118721657692163,-0.7081308466516406,-0.10890331742846847},
{0.7224694319972889,-0.6924565754154182,-0.11368661140308882},
{0.7012738236765521,-0.7054573231413095,-0.12722098796645454},
{0.7137570805338439,-0.6830266222693212,-0.13841428317831916},
{0.701551396741206,-0.6900154386568906,-0.1374718257960053},
{0.6927562037042018,-0.7012506925878308,-0.13277244925953618},
{0.6720705551999225,-0.69359591601801,-0.15208959800319533},
{0.6815855016487625,-0.6749264377585437,-0.15655551192326936},
{0.6680048629079545,-0.6915872768253387,-0.15373459496387787},
{0.6588729242537534,-0.6845166947288015,-0.1546598385127248},
{0.6779393965475505,-0.665336180788286,-0.16015212725326392},
{0.673573538034503,-0.6631801481465542,-0.16398435692883695},
{0.6369898384589316,-0.6892881541929132,-0.16137108183564017},
{0.641410566066155,-0.6784541977546705,-0.1613700059710485},
{0.6226302737537454,-0.6874226049909359,-0.16856754008940436},
{0.6281785074530519,-0.6719193962247911,-0.1749872241079738},
{0.6098317885710904,-0.6811008246502095,-0.17787592053664128},
{0.6166237217383821,-0.668876851159513,-0.18233215167539016},
{0.5851869583694196,-0.681946454219272,-0.18192332313055082},
{0.5963296879454751,-0.6640806468097925,-0.1888088565173187},
{0.5705369102244792,-0.6799378150266008,-0.19122309666105425},
{0.5774514919552225,-0.6573209895802514,-0.19098640645088408},
{0.5559567932779981,-0.6727370533144699,-0.19809141621435525},
{0.5665196318391368,-0.6571477753809906,-0.20287471018897563},
{0.5561450695815425,-0.6467968821444133,-0.20576233075305142},
{0.5405955986379554,-0.6573618724347354,-0.20026789028332895},
{0.5205221170863435,-0.6526764821379581,-0.20454875549363358},
{0.5234355584006197,-0.6358725530804693,-0.19764923586717378},
{0.5305631613205162,-0.6159249476860842,-0.18668402394874584},
{0.7870654179464972,-0.7165742319671646,-0.049451040092094015},
{0.7876388537738641,-0.737662253828733,-0.052603323345723714},
{0.773678434832192,-0.7646901241009806,-0.05667224323146689},
{0.7215958299488426,-0.8054438748339134,-0.04015987347832402},
{0.7278078721012174,-0.8591241386359113,-0.06337918309601553},
{0.7389247809270726,-0.8934409915168079,-0.036678375659639474},
{0.7434079086806135,-0.8957013830239325,0.00019688322027789582},
{0.7389247809270726,-0.8934409915168079,0.036678375659639474},
{0.7276572510583817,-0.8885328972495521,0.07388607669838675},
{0.7143864613199783,-0.8822606066800431,0.1094724497974685},
{0.7015255759910057,-0.8766661108032944,0.14542569272231398},
{0.6887636702044682,-0.8551692603968863,0.18220950311193834},
{0.647147076069006,-0.8464181778081412,0.1870734869309349},
{0.6330026842821562,-0.8365008580020118,0.20410011995890198},
{0.6239847872746737,-0.821126752986869,0.24181347735574},
{0.6004524010608024,-0.8153106290042337,0.26883596830502915},
{0.5767790765854209,-0.794372152320909,0.29327423250509693},
{0.5473843042114719,-0.7753766870901628,0.31305723061695456},
{0.5412551036326568,-0.7576862456091278,0.33372028596480846},
{0.514184198776742,-0.7324851934135571,0.35239944700559994},
{0.4853768484698516,-0.7031463659983755,0.3618337036100637},
{0.4508792503375525,-0.6825016003485802,0.3701738059247863},
{0.4146570412647864,-0.6659096166156527,0.38214817883021246},
{0.3893548577975976,-0.6348052954055202,0.3933500809588106},
{0.35323808345481633,-0.5976062012835065,0.40378058817517226},
{0.3445709183042222,-0.5549912048069631,0.41205075929143564},
{0.37197856877733365,-0.51297761663717,0.408023798124768},
{0.3854483934651985,-0.4713083051367155,0.40439813445079803},
{0.3983146581171294,-0.4293893930509906,0.39857985873897916},
{0.4337568653609257,-0.3828711598358231,0.37220719000306624},
{0.4400560525452267,-0.34243694088661997,0.37423304302920435},
{0.4527813789356472,-0.2911429447489739,0.3696391012227201},
{0.42452917475806495,-0.31367692862176366,0.36985642587024},
{0.40945738769318496,-0.32704024271505183,0.37111088398414177},
{0.39307842514941066,-0.368453498442686,0.3668074256174118},
{0.34939401926873487,-0.4119614625303259,0.3641952263888067},
{0.34756289773369126,-0.43186280574726865,0.35174854892763197},
{0.3492111222881488,-0.44825575453073474,0.3417311737144763},
{0.7885382765725105,-0.72508862434574,-0.06739646148135796},
{0.7887061114488131,-0.7356245662920866,-0.06998714341812941},
{0.7710780701140956,-0.7659660995067162,-0.07382260068747748},
{0.7210363803611678,-0.8155548502665454,-0.07094681463391019},
{0.7204930687423681,-0.8152062701388404,-0.05786322533445941},
{0.7383943796833731,-0.789611451502714,-0.0508894710511735},
{0.7173031302280294,-0.850393497474408,-0.09713658638923706},
{0.7276572510583817,-0.8885328972495521,-0.07388607669838675},
{0.7413088968622409,-0.9156662022517847,-0.03653098221057898},
{0.746493488329559,-0.9164946179873802,0.00020011081405294328},
{0.7413088968622409,-0.9156662022517847,0.03653098221057898},
{0.7302113535990361,-0.9133756865360925,0.07330833741265325},
{0.715752809351415,-0.9094670704745101,0.10845575775832854},
{0.7055051991156392,-0.9009117952414508,0.14039494989160664},
{0.690007369672453,-0.8871891423745407,0.17278170169502466},
{0.670717117543586,-0.8671361022501707,0.19827754078871634},
{0.636856431249563,-0.845974921596368,0.22138711221805624},
{0.6140072190514102,-0.8542214236916141,0.24743917330564774},
{0.5916529045654314,-0.8426956863209197,0.2740302425536722},
{0.5694642732265717,-0.8260606680043251,0.2976691393621199},
{0.5371721975072218,-0.8041399269487941,0.32039570299682085},
{0.5061012280994315,-0.7887755047149765,0.3399495419506501},
{0.47520454875549367,-0.7699080673706408,0.3566157603404036},
{0.4626137054390334,-0.7482487614108888,0.3633151691528104},
{0.42976971118415036,-0.7266077451491957,0.3763040823681932},
{0.39691711001253377,-0.7059350070200165,0.3901203354545797},
{0.3503805870993077,-0.6793073583758749,0.4020807221203139},
{0.32632640655847056,-0.6466408817786193,0.4127210229320538},
{0.3151879804407817,-0.6060269934426054,0.4242822638342738},
{0.30224748113202476,-0.5654647466069921,0.4328881047031421},
{0.31593032700904267,-0.5212736085036338,0.43856974561181733},
{0.3145338547690388,-0.477368650381663,0.4395606169007569},
{0.314119646901241,-0.4337767688558718,0.4374271774154505},
{0.40379296061797665,-0.3877297643318612,0.4014481137404047},
{0.4024169298052147,-0.344320779786656,0.4107295975728495},
{0.4489330112911989,-0.30270418565119395,0.3768828975185184},
{0.45761201095230153,-0.25448070705820963,0.3751109485360173},
{0.44252623764772964,-0.2548196044045896,0.38010296024142404},
{0.42361361399054315,-0.24814494047779145,0.3822794343103977},
{0.3531154348913646,-0.37987272521880394,0.38274420781400453},
{0.3517103557346273,-0.39742222843832875,0.3746892096160777},
{0.31012388580773226,-0.41588191310241696,0.3797188765821934},
{0.3153213876501504,-0.44622882564000493,0.3622210148630694},
{0.7829125806226028,-0.7171842471906487,-0.08163983281064247},
{0.7832729952608165,-0.7381657584576405,-0.0869029623931532},
{0.7659289821783032,-0.7608589702899993,-0.09481271887120286},
{0.7137022114396682,-0.80815290187577,-0.09576055557647516},
{0.7195258664744456,-0.8119098210299253,-0.07932134461556668},
{0.7106779560724488,-0.8140056052545226,-0.10860207534279737},
{0.6918836775203473,-0.8466537921537196,-0.13071647202483097},
{0.7143864613199783,-0.8822606066800431,-0.1094724497974685},
{0.7302113535990361,-0.9133756865360925,-0.07330833741265325},
{0.7374637568115677,-0.9480325126279607,-0.04256443084073439},
{0.7381372480459609,-0.9380323512482721,0.0002011866786446258},
{0.7374637568115677,-0.9480325126279607,0.04256443084073439},
{0.7304491196737979,-0.9463799846151363,0.08415412836140444},
{0.7140550950257402,-0.9509481056714201,0.11935319020748049},
{0.6939256685153606,-0.928730425988585,0.14867695551837848},
{0.685419883053519,-0.9152423116026618,0.17690656653953535},
{0.6479980849610268,-0.9041167958600732,0.20440458963834812},
{0.6243355191315622,-0.8916733459926732,0.23150669456742176},
{0.6003932285082599,-0.8834483611892606,0.25739630010166925},
{0.5768188835753132,-0.8659698650327871,0.2823014895345272},
{0.5465827850906685,-0.8423008440157723,0.30956282242316985},
{0.516752287557088,-0.8209675250273002,0.33169550880326204},
{0.47927454450582846,-0.8119593108011427,0.3470448689327961},
{0.44832514779689825,-0.7855403798877875,0.35923656648574215},
{0.43124902499771384,-0.7675379376751642,0.3710893666923081},
{0.39449641468124824,-0.750369290521095,0.38624184360156427},
{0.34313033561595935,-0.7299891875608534,0.40159443132487344},
{0.3102088791104752,-0.7047192800314153,0.4126467882752277},
{0.2852972344900671,-0.6700387849185302,0.42062647595173674},
{0.27719597411469793,-0.6251902935496538,0.4331947261117716},
{0.26873752669489015,-0.5800889740017322,0.4403513773756435},
{0.27469243720985276,-0.5348262747650581,0.4485279482724304},
{0.2657832025261301,-0.48921714712986225,0.45354470486344595},
{0.26035761739027524,-0.4427268863940784,0.4544247620994422},
{0.2654496845027085,-0.39537916157872366,0.4551014809276105},
{0.3154612500470691,-0.38950386504354567,0.43914425730377576},
{0.31533322216065884,-0.3456301069947336,0.43618240208287384},
{0.41069463197361983,-0.3016143348198196,0.4070436854817453},
{0.4603888174634341,-0.2636406181917944,0.3801309327208078},
{0.46701399161901486,-0.21228637363701403,0.3808173343303012},
{0.4527985927691141,-0.2104929073626793,0.3858082701711163},
{0.4358483461271564,-0.20468431443218554,0.38821928272107675},
{0.39766268417456985,-0.2509077607492321,0.39063567459399556},
{0.35894769684287536,-0.35672011920579677,0.3932371151766839},
{0.30136634803143675,-0.3598132299068839,0.4220821207442832},
{0.30400974733320063,-0.38818162746036783,0.4007638638600946},
{0.2568363125816985,-0.3844236324416209,0.4001420141261021},
{0.26974776354648006,-0.4179314351495721,0.38236980693609907},
{0.27281505349736684,-0.45511331543811895,0.36320973442282556},
{0.26589401657907336,-0.521519981495129,0.3735864484096032},
{0.20921854575383142,-0.585629676648897,0.36936798334561616},
{0.21737575108796808,-0.6324147242828018,0.3673077026525442},
{0.2326810007692432,-0.6751835693959559,0.3618014276723132},
{0.2604157140782261,-0.7107731700888127,0.35811659144580066},
{0.29061953662512036,-0.7400280800658431,0.3465639574603141},
{0.3226813773218503,-0.7631839136726253,0.3288767435730539},
{0.354550638256669,-0.7865958030522279,0.31136597147882966},
{0.3861229605641834,-0.8107963011775339,0.29448350430614806},
{0.41761782062109665,-0.7681845322947655,0.26123498496479236},
{0.42761367854241866,-0.7929928939143721,0.24822455445757596},
{0.45758834193128456,-0.8117323033722975,0.23165086042270722},
{0.48757161223688383,-0.8212085186958369,0.20900929009074917},
{0.5182391324227933,-0.8199788054675439,0.18596749813068528},
{0.5239627320505441,-0.7826452282715698,0.17388015944313248},
{0.6019629149475247,-0.6977358429668042,0.17508082432745015},
{0.7745369747763547,-0.700030662140863,-0.09094606152869601},
{0.7802476640290054,-0.7314448323533999,-0.09504295389382292},
{0.7756849222956799,-0.7344163703556271,-0.10334217335406165},
{0.7252957282796387,-0.7698445913597316,-0.11172100679408489},
{0.7740194839077554,-0.7153520497910134,-0.1023878814612393},
{0.7744369193693281,-0.7207819383852349,-0.12009876436951646},
{0.7752244522504398,-0.7367488447903948,-0.11861407123299463},
{0.7205339515968521,-0.7725159631408792,-0.12432906394401201},
{0.7049694185489813,-0.8155613054540954,-0.1252758247846926},
{0.6781534936012954,-0.8436897852036344,-0.16476543462239843},
{0.6875221224656665,-0.8766661108032944,-0.14542569272231398},
{0.715752809351415,-0.9094670704745101,-0.10845575775832854},
{0.7304491196737979,-0.9463799846151363,-0.08415412836140444},
{0.7304652576426731,-0.9703674615512892,-0.04426322103100104},
{0.7272516501073174,-0.9706127586781926,0.0001990349494612608},
{0.7304652576426731,-0.9703674615512892,0.04426322103100104},
{0.7214903952188578,-0.9764848276195959,0.08924296788006261},
{0.7030715934092534,-0.9729753573215275,0.1279859276911408},
{0.6761685234296412,-0.9637756391980506,0.1580455843827496},
{0.6514677482692028,-0.9502208212074428,0.18898960176872137},
{0.6269670839228175,-0.9283312802250709,0.21658983200374402},
{0.6015045966314679,-0.9114143853854553,0.2453649063728839},
{0.5748930859562016,-0.8947019048182597,0.2724099904785984},
{0.5370129695476528,-0.8777215339677348,0.2962500739656907},
{0.5002162487829281,-0.8581773777952307,0.3157490438253442},
{0.4621596905813435,-0.8411453654443052,0.3339860245189541},
{0.4249240170632124,-0.8175903860740087,0.34847684470432555},
{0.38913322969171105,-0.7928713212155118,0.3649806075407349},
{0.35443014142240054,-0.770147985174586,0.38590832557814275},
{0.31849411233102204,-0.7504263113444543,0.4065272704777377},
{0.2787721157415128,-0.7364067198502398,0.42560880487581837},
{0.24346977089463523,-0.7129808442309451,0.43764988138592875},
{0.22021173015164314,-0.6677407381506963,0.4381533860148362},
{0.2044503138834946,-0.6168114601096306,0.4367483068580989},
{0.20832019881977656,-0.568456726036461,0.4414401523424262},
{0.23537819330059118,-0.5209002834903199,0.4509712367601414},
{0.23625287121362906,-0.47007751604383075,0.45688311269143667},
{0.22535651462906878,-0.4205673033991942,0.4605012453132649},
{0.206854871245905,-0.3735487931488943,0.4670672469163032},
{0.20320123509255128,-0.32407515990037494,0.4717816855570558},
{0.2540508991538325,-0.35185183192843345,0.44983942720969144},
{0.2531590074073277,-0.31236437381991106,0.4524795989176802},
{0.2815220256378532,-0.3133541692442589,0.4510207265313588},
{0.3162939692410313,-0.29926787414536005,0.44744885608697293},
{0.351833004298079,-0.2620902973151799,0.43641586469926896},
{0.36863262989720114,-0.26259810540245404,0.43377031366832175},
{0.434094686842714,-0.2455295136554113,0.40281338590724974},
{0.46644808684378986,-0.22245974921596368,0.38990301080705986},
{0.461924076235765,-0.18117882483310652,0.38987934178604283},
{0.44774418091738977,-0.1792992893914372,0.3948702776268579},
{0.43055294060689525,-0.17870110867846173,0.40183434912881866},
{0.38794439931790187,-0.194039710162079,0.4263888067047881},
{0.2846624743809744,-0.3330478705950069,0.4369290521095015},
{0.33175737101728375,-0.34328902564323255,0.4268815526877787},
{0.2141610676880208,-0.3251402658461406,0.4319854543107205},
{0.23224204801583673,-0.3585157372093148,0.41766569659542646},
{0.21067956986933623,-0.41393997751443,0.3991511428371625},
{0.2318633436795645,-0.4488238110351431,0.38926932656255886},
{0.252592026767511,-0.485192337692378,0.3832165123697531},
{0.2053497366821412,-0.5414686627541058,0.36717321957858384},
{0.1474983458581903,-0.557007375051776,0.4092900907491784},
{0.14984910999101653,-0.610697321635099,0.41181191735208206},
{0.1661775068989817,-0.6608971634830041,0.4126995056402201},
{0.19035648773245398,-0.7072561687386024,0.40793019790529167},
{0.22407085644200822,-0.7432018806113062,0.40071544995346886},
{0.26409409511718857,-0.7672474542354101,0.387354287589364},
{0.30220337068376574,-0.785880353098759,0.36422750232655715},
{0.33896458791696477,-0.8063217803407264,0.3404896259756747},
{0.37668547636594457,-0.8314722669004879,0.32233441099103266},
{0.41763288272538024,-0.8352797516904523,0.2775892026229579},
{0.4492148878142197,-0.8555554957853007,0.257698618051932},
{0.48076031350694204,-0.8781551073981829,0.2386568906437436},
{0.5120970214688779,-0.8961909014131482,0.21623910014685552},
{0.5434617019101976,-0.9048225630322169,0.19143934544398244},
{0.5510250299897255,-0.8113428403901084,0.1679069592301113},
{0.5823757241913533,-0.7671915092766426,0.16474606905974815},
{0.6322398962866533,-0.7043545619348347,0.16225651839459487},
{0.7607078113148679,-0.7192273140502536,-0.14037020500599795},
{0.7606959768043595,-0.7295717520992808,-0.1450728091362421},
{0.7130072029134414,-0.7713056154752362,-0.13434751502175935},
{0.6939837652033115,-0.808474585388683,-0.14962264049446736},
{0.6610493983227271,-0.8312829147323519,-0.19193101556238135},
{0.647147076069006,-0.8464181778081412,-0.1870734869309349},
{0.6747602166791288,-0.8551692603968863,-0.18220950311193834},
{0.6915017455903001,-0.9009117952414508,-0.14039494989160664},
{0.7140550950257402,-0.9509481056714201,-0.11935319020748049},
{0.7214903952188578,-0.9764848276195959,-0.08924296788006261},
{0.7104240520288116,-0.9894705132412034,-0.052547378386956216},
{0.7117871724664734,-0.9894059613657025,0.00019257976191116587},
{0.7104240520288116,-0.9894705132412034,0.052547378386956216},
{0.6973748903962949,-0.9893026783649009,0.09924958444730146},
{0.677022759915437,-0.9850992754051976,0.1409328821874479},
{0.6519863150023938,-0.972302941951726,0.17632775138921014},
{0.6236329795531934,-0.9579229358192978,0.20695438872063562},
{0.593758371571354,-0.9413062072007617,0.23280311140039917},
{0.5655986917486565,-0.9213198706810761,0.2606959768043594},
{0.5248115892133817,-0.8988127834230782,0.28558502826834214},
{0.48646669930122594,-0.8746424095063394,0.3050850739925873},
{0.44678881315997565,-0.8510712921671677,0.32241510083540886},
{0.4069613818404816,-0.8324782002937111,0.34288342469216826},
{0.3688983684513467,-0.8079861428640592,0.36282242316981983},
{0.3313184182638773,-0.7879051302603055,0.3870272247534925},
{0.29402357219320374,-0.7677369726246254,0.408878034610564},
{0.2540530508830159,-0.7463143568750437,0.425748667272737},
{0.21157684093879944,-0.7255533978493467,0.4368634243694089},
{0.18162261897717552,-0.6831212983533893,0.4354691038585884},
{0.16674986686175677,-0.631702501923108,0.43241042082443504},
{0.16724476457393073,-0.5771260429162386,0.43392523816952405},
{0.19320645303582093,-0.5271693464660538,0.4427946658633545},
{0.19776381544618796,-0.474264781034659,0.453212262704616},
{0.18168394325890147,-0.4228943985110034,0.45684545743072774},
{0.17132982242854913,-0.3708311591903043,0.46701130195753565},
{0.16300478221811004,-0.31882171309918933,0.4817302054363438},
{0.17377956610381015,-0.27572150169179704,0.5037596088156345},
{0.1847770539599886,-0.2603473966766543,0.5042340651005665},
{0.22225049355288146,-0.30222327417871186,0.4663023071916169},
{0.22147694691146175,-0.2940542343340667,0.4615254684045466},
{0.1915711388564635,-0.292304878507991,0.4388516221348381},
{0.7415907733852618,-0.7149087935792402,-0.15562273732228063},
{0.7325147796898283,-0.6948482224027286,-0.16037805881751724},
{0.7305061404971571,-0.7094337186721679,-0.16727757844397703},
{0.7102540654233258,-0.7333544920036363,-0.1749441895243065},
{0.7228287707709108,-0.7421292436133989,-0.15921612505850014},
{0.7352065928982178,-0.75603156586712,-0.1479550503773595},
{0.6778049134735902,-0.7714228847157296,-0.1806774719333825},
{0.6568546022797571,-0.8058161239826355,-0.20761604544452036},
{0.6330026842821562,-0.8365008580020118,-0.20410011995890198},
{0.6567136640182466,-0.8671361022501707,-0.19827754078871634},
{0.6760039161471137,-0.8871891423745407,-0.17278170169502466},
{0.6939256685153606,-0.928730425988585,-0.14867695551837848},
{0.7030715934092534,-0.9729753573215275,-0.1279859276911408},
{0.6973748903962949,-0.9893026783649009,-0.09924958444730146},
{0.6966196334529338,-0.9946615598960716,-0.05036444913043245},
{0.6980300919326295,-0.9936039850024475,0.0001872004389527534},
{0.6966196334529338,-0.9946615598960716,0.05036444913043245},
{0.6848184747467684,-0.9928992936948956,0.09734745584920682},
{0.6624394153751809,-0.988028854688349,0.13771819878750063},
{0.6337299687461336,-0.9797446973323938,0.1702986062174215},
{0.6036014567206571,-0.967406682194979,0.1993060673383648},
{0.5731060748694169,-0.9476989946045391,0.22350656546367076},
{0.5314722669004879,-0.9217577475698908,0.2468603581553226},
{0.49298643872682185,-0.9038338434724605,0.26758796537867746},
{0.45457592107457356,-0.8788748608100185,0.28721281139555777},
{0.41663448038429884,-0.8532520696945084,0.3072787618950279},
{0.37998838066240986,-0.8313151906701022,0.33273156640505225},
{0.3448086843789841,-0.8054826059592141,0.35876856538836027},
{0.305482605959214,-0.7847980333195264,0.37977266981177754},
{0.26534747736649866,-0.7700393228508259,0.40173536958638384},
{0.2237954351065375,-0.7477570912924901,0.4157442024346816},
{0.18801110292258616,-0.7136715492988053,0.4253914802282984},
{0.16636901079630118,-0.6650155731399646,0.4266125865398581},
{0.1547905560606142,-0.6117624275808647,0.42816505914565595},
{0.15115628546991075,-0.5568664367902656,0.42722905695089214},
{0.15714885124558223,-0.5021264463654604,0.43013496721302663},
{0.1575501487382798,-0.44793191928863835,0.43934006465946196},
{0.1500481449404778,-0.3942828555597992,0.4481266507797329},
{0.14721862106435285,-0.34403244807608513,0.4677224484526378},
{0.14548970666551908,-0.29155177329381327,0.4826048833493817},
{0.14469356686767404,-0.24577911424068166,0.5104482589821245},
{0.18503526146199237,-0.2552456467828959,0.5192714244985127},
{0.18157528093514153,-0.24575221762588959,0.48158711544565},
{0.17321796478695192,-0.21816167017219212,0.44702281370866664},
{0.167331909605857,-0.29858362426505,0.4019462390463537},
{0.17546544591897664,-0.3377160470583172,0.4113492955776586},
{0.727917610289569,-0.7003641801642846,-0.17972533176974348},
{0.7274270160357617,-0.7131379204613307,-0.18020409151304217},
{0.6826280144381028,-0.7248347203021027,-0.19566426569551956},
{0.7094073599896717,-0.6912236345933501,-0.1861181191735208},
{0.7075773143192198,-0.7059984830309257,-0.1909046407419162},
{0.6931241493945571,-0.6753944388559256,-0.1773218502719248},
{0.6971414277798996,-0.7008450916367664,-0.19613764611585985},
{0.6853295104278175,-0.7027999375998536,-0.2081109431566943},
{0.6830927879417097,-0.6860153741050151,-0.20496834268438976},
{0.671530471174898,-0.682969601445962,-0.21239933941914071},
{0.6699564812772665,-0.697770270633738,-0.21498894549132047},
{0.650457511417613,-0.7141718263339377,-0.2224220939552548},
{0.6526458199970951,-0.6709790905716606,-0.2121368284587702},
{0.6547050248255755,-0.6850105165763837,-0.22600795063933254},
{0.6175607997977375,-0.7057133789141299,-0.24697332393744925},
{0.6478829674497167,-0.7389296223177352,-0.23840621419388158},
{0.6815865775133542,-0.7530148415520423,-0.20758269364217818},
{0.6366036030705176,-0.7952016439210962,-0.23341097489469975},
{0.6239847872746737,-0.821126752986869,-0.24181347735574},
{0.636856431249563,-0.845974921596368,-0.22138711221805624},
{0.6479980849610268,-0.9041167958600732,-0.20440458963834812},
{0.6714175053927712,-0.9152423116026618,-0.17690656653953535},
{0.6761685234296412,-0.9637756391980506,-0.1580455843827496},
{0.677022759915437,-0.9850992754051976,-0.1409328821874479},
{0.6848184747467684,-0.9928992936948956,-0.09734745584920682},
{0.685924463547018,-0.9986928245211057,-0.04961672323921311},
{0.6836629961753015,-0.9921375815639845,0.00018182111599434096},
{0.685924463547018,-0.9986928245211057,0.04961672323921311},
{0.6787484467204958,-1.0,0.09736466968267374},
{0.6506070565958568,-0.9913651107871565,0.12923070302371742},
{0.6220406999575033,-0.9799286701775715,0.1588191310241693},
{0.5924619547383766,-0.9662867071550375,0.1865871961354944},
{0.5668187221956245,-0.9452331129604029,0.21607664459351147},
{0.5270988773352986,-0.9241580014739346,0.24191676035654155},
{0.48985459690043415,-0.9009849540336855,0.2634125348983577},
{0.45269746149749596,-0.8768135042523549,0.28365277546168044},
{0.4148593038080227,-0.8523935297503457,0.30216948094912777},
{0.15203634270590702,-0.5031657315610257,0.4092761045094865},
{0.1453412373518669,-0.45169744535952705,0.4212719947067462},
{0.13799846151363387,-0.40035395945066354,0.43383701727300605},
{0.12645013098651403,-0.3481809819416128,0.43793283377354125},
{0.11075757005223322,-0.2978563398010726,0.4339930176388},
{0.10237550901843494,-0.2509282021764741,0.4107833908024336},
{0.10015277277201891,-0.21590558212343394,0.4286965362539471},
{0.12091265593312427,-0.20800873602048447,0.48040689198857434},
{0.14634609488049832,-0.1996557233306616,0.5152100356649112},
{0.167718144994271,-0.19463251155209604,0.5127979472503591},
{0.18679860352775998,-0.20661979483262236,0.4913591935319021},
{0.17883720554930957,-0.19490362942920006,0.4596276432648187},
{0.1685175123858911,-0.19503918836775203,0.42601010236851594},
{0.15388575393900925,-0.2398833762782616,0.3764439447651119},
{0.16361156984781897,-0.2499125860019258,0.3799781599487888},
{0.13440077031904762,-0.28754955701275436,0.39603005965669164},
{0.13937987164935423,-0.33040124369946794,0.4137517012108856},
{0.14348106747284786,-0.37718844306255617,0.4202262543236308},
{0.19540874785499496,-0.37491514118033104,0.4070200164607282},
{0.14900670801572916,-0.42294926760517926,0.4138280875968951},
{0.16634534177528415,-0.4622495252747489,0.3955276308923759},
{0.18646293377515502,-0.5009698919294018,0.3777048580665638},
{0.6332200089296761,-0.6666143079232048,-0.20999585792132203},
{0.64515457484521,-0.6829577669354535,-0.23359602360446913},
{0.6388005185667331,-0.6850460201079093,-0.2395412513381066},
{0.6213532224834183,-0.6842186802369054,-0.24860648638762328},
{0.5866178582763574,-0.693094563118286,-0.26941263172617097},
{0.6175769377666127,-0.7344142186264436,-0.2677439657444714},
{0.5854268761733649,-0.7777123891187054,-0.2823520551703363},
{0.6127925679274007,-0.7885926077343904,-0.2605571902720324},
{0.6329897739070561,-0.6717235888691049,-0.234128576577352},
{0.6220568379263786,-0.671550374669844,-0.24601688031544353},
{0.6012453132648725,-0.6586087994964953,-0.2455198308740862},
{0.6029107516527971,-0.6751104106037213,-0.255092874010877},
{0.5809114724820734,-0.6694728801433052,-0.25913920074019486},
{0.5433724051490879,-0.6717386509733886,-0.28588842208319665},
{0.5800271117877104,-0.7184300983878168,-0.29801449189604995},
{0.5836646099721889,-0.7603447070151751,-0.3018445698424397},
{0.5767790765854209,-0.794372152320909,-0.29327423250509693},
{0.6004524010608024,-0.8153106290042337,-0.26883596830502915},
{0.5828932150599525,-0.6599988165489492,-0.25458614178819455},
{0.5641860815397775,-0.6481998095719672,-0.2522117086343513},
{0.5645411168550326,-0.6613888336014029,-0.2636524527023029},
{0.5454412927588934,-0.6545194381835102,-0.2680269181320839},
{0.5385008902779497,-0.6536533671872058,-0.2694287696950462},
{0.5145489168733223,-0.6470497103234587,-0.2928223693765903},
{0.5411410619859385,-0.6914355799179115,-0.31683566706294347},
{0.5562236076967353,-0.7410167996255991,-0.3209723664179627},
{0.5473843042114719,-0.7753766870901628,-0.31305723061695456},
{0.5694642732265717,-0.8260606680043251,-0.2976691393621199},
{0.5916529045654314,-0.8426956863209197,-0.2740302425536722},
{0.6140072190514102,-0.8542214236916141,-0.24743917330564774},
{0.6243355191315622,-0.8916733459926732,-0.23150669456742176},
{0.6269670839228175,-0.9283312802250709,-0.21658983200374402},
{0.6514677482692028,-0.9502208212074428,-0.18898960176872137},
{0.6519863150023938,-0.972302941951726,-0.17632775138921014},
{0.6624394153751809,-0.988028854688349,-0.13771819878750063},
{0.6787484467204958,-1.0,-0.09736466968267374},
{0.6499550826532973,-0.9694884801798848,-0.09079328875667708},
{0.6604404589638349,-0.9717122922908923,-0.04972968902133978},
{0.6634743971123795,-0.9790432336186167,0.00017429006385256352},
{0.6604404589638349,-0.9717122922908923,0.04972968902133978},
{0.6499550826532973,-0.9694884801798848,0.09079328875667708},
{0.6282903973705869,-0.9586114891579745,0.12137904323361862},
{0.6033174284684529,-0.9418635050592534,0.14577212112083573},
{0.5777333684782433,-0.9256459222042314,0.16847609159911134},
{0.5564022012189546,-0.6443557453858858,-0.2512681753874457},
{0.5438016751211693,-0.6354691038585883,-0.24749189067064023},
{0.53716466645508,-0.6426451206851106,-0.2579783428457694},
{0.5262941306207201,-0.6372754805080232,-0.26752018590940146},
{0.5278433756327429,-0.648390237604695,-0.27685869056520546},
{0.5087101997342615,-0.6363803611677434,-0.2787081017983077},
{0.4921182160013341,-0.6281855005728979,-0.2854182692566314},
{0.4654948708155591,-0.6045821072959757,-0.30997810615555926},
{0.5027305443336901,-0.646435391641608,-0.3328230148953453},
{0.5051985777070098,-0.6912785036875259,-0.3499486274657472},
{0.5299251736176485,-0.719002458350592,-0.3381055100405063},
{0.5412551036326568,-0.7576862456091278,-0.33372028596480846},
{0.5371721975072218,-0.8041399269487941,-0.32039570299682085},
{0.5465827850906685,-0.8423008440157723,-0.30956282242316985},
{0.5768188835753132,-0.8659698650327871,-0.2823014895345272},
{0.6003932285082599,-0.8834483611892606,-0.25739630010166925},
{0.6015045966314679,-0.9114143853854553,-0.2453649063728839},
{0.593758371571354,-0.9413062072007617,-0.23280311140039917},
{0.6236329795531934,-0.9579229358192978,-0.20695438872063562},
{0.6337299687461336,-0.9797446973323938,-0.1702986062174215},
{0.6506070565958568,-0.9913651107871565,-0.12923070302371742},
{0.6282903973705869,-0.9586114891579745,-0.12137904323361862},
{0.6206076483213823,-0.8902026390958434,-0.07574947417118082},
{0.628137624598568,-0.9032345868948933,-0.03972092072491756},
{0.6292005788151503,-0.9170078053976126,0.00015922795956900866},
{0.628137624598568,-0.9032345868948933,0.03972092072491756},
{0.6206076483213823,-0.8902026390958434,0.07574947417118082},
{0.611998579858739,-0.871712830223188,0.10610284189631894},
{0.6022663087623792,-0.8417327875113638,0.12864866027961722},
{0.584372528873516,-0.8150459663146795,0.14968504064078497},
{0.5069188851891101,-0.6380587099307681,-0.26773535882773797},
{0.48621602285136395,-0.630499685309607,-0.267558917034702},
{0.4673571924237616,-0.6159615270822014,-0.25633227002049525},
{0.4775994233365789,-0.6157893887475323,-0.2899401281354729},
{0.4649644695718597,-0.6069877405229778,-0.28616384341866735},
{0.4402228115569375,-0.5895415203042546,-0.2938078613425715},
{0.4246873268530423,-0.5610623086978273,-0.3214231536818776},
{0.4698456672243232,-0.6016008865124235,-0.3428748177754348},
{0.48271300774084575,-0.6589218760926749,-0.3568728919778157},
{0.4853768484698516,-0.7031463659983755,-0.3618337036100637},
{0.514184198776742,-0.7324851934135571,-0.35239944700559994},
{0.5061012280994315,-0.7887755047149765,-0.3399495419506501},
{0.516752287557088,-0.8209675250273002,-0.33169550880326204},
{0.5002162487829281,-0.8581773777952307,-0.3157490438253442},
{0.5370129695476528,-0.8777215339677348,-0.2962500739656907},
{0.5748930859562016,-0.8947019048182597,-0.2724099904785984},
{0.5655986917486565,-0.9213198706810761,-0.2606959768043594},
{0.5731060748694169,-0.9476989946045391,-0.22350656546367076},
{0.6036014567206571,-0.967406682194979,-0.1993060673383648},
{0.6220406999575033,-0.9799286701775715,-0.1588191310241693},
{0.6033174284684529,-0.9418635050592534,-0.14577212112083573},
{0.611998579858739,-0.871712830223188,-0.10610284189631894},
{0.6242128705681103,-0.846408495026816,-0.0769985529621242},
{0.6285518324663658,-0.8701764955862654,-0.0485236448140637},
{0.6264216205748345,-0.8759861643813511,0.00015815209497732616},
{0.6285518324663658,-0.8701764955862654,0.0485236448140637},
{0.6242128705681103,-0.846408495026816,0.0769985529621242},
{0.6197093013873274,-0.8147748484375757,0.10151427941279312},
{0.6130948858776635,-0.7794671242677397,0.12213214844779637},
{0.6147882967449717,-0.7625545328864909,0.14722991764256552},
{0.4604178658074095,-0.6099711130357133,-0.27496839647761934},
{0.43652076149695795,-0.5929412524139712,-0.29357547459076805},
{0.4054099850992754,-0.5749129894511477,-0.29619090141314813},
{0.4168216808232516,-0.5675314824876141,-0.3057596410915722},
{0.39001005933393224,-0.5179072281962592,-0.32050328945598905},
{0.39210476769393804,-0.5032593317805021,-0.3331941881794757},
{0.4462971430415768,-0.5587136962941844,-0.3474515457484521},
{0.4500734277583823,-0.5852283791561994,-0.36041786580740953},
{0.46383050829222633,-0.6233333512644099,-0.35965507781190664},
{0.4508792503375525,-0.6825016003485802,-0.3701738059247863},
{0.4626137054390334,-0.7482487614108888,-0.3633151691528104},
{0.47520454875549367,-0.7699080673706408,-0.3566157603404036},
{0.47927454450582846,-0.8119593108011427,-0.3470448689327961},
{0.4621596905813435,-0.8411453654443052,-0.3339860245189541},
{0.44678881315997565,-0.8510712921671677,-0.32241510083540886},
{0.48646669930122594,-0.8746424095063394,-0.3050850739925873},
{0.5248115892133817,-0.8988127834230782,-0.28558502826834214},
{0.5314722669004879,-0.9217577475698908,-0.2468603581553226},
{0.5668187221956245,-0.9452331129604029,-0.21607664459351147},
{0.5924619547383766,-0.9662867071550375,-0.1865871961354944},
{0.5777333684782433,-0.9256459222042314,-0.16847609159911134},
{0.6022663087623792,-0.8417327875113638,-0.12864866027961722},
{0.6197093013873274,-0.8147748484375757,-0.10151427941279312},
{0.716135817146054,-0.7380872203424476,-0.06671543919482295},
{0.7238454628100508,-0.7487275211541875,-0.03595431878943716},
{0.7253430663216728,-0.7589708279315965,0.0001764417930359285},
{0.7238454628100508,-0.7487275211541875,0.03595431878943716},
{0.716135817146054,-0.7380872203424476,0.06671543919482295},
{0.7026035923118716,-0.7273952780303071,0.0958799765461519},
{0.6838749414998629,-0.7182009392297884,0.12241510083540885},
{0.6600219476376704,-0.7110701087161169,0.14495553989574872},
{0.3906340607971081,-0.5650548421975611,-0.2942930762734202},
{0.39860621742147534,-0.5429587352135861,-0.30290752405902194},
{0.35733712754912667,-0.5777629547545146,-0.2693028935378194},
{0.3608605840868868,-0.5477915189594238,-0.2840766661108033},
{0.35643662888588845,-0.5169088258551778,-0.30621365594926225},
{0.39050495704610616,-0.5910315927637347,-0.22805101749893758},
{0.3884349935717091,-0.6108135150110008,-0.23729592193526525},
{0.3303942505796221,-0.6050415014766242,-0.2857668493843365},
{0.3218647960967633,-0.5752658730372195,-0.3031130141960333},
{0.32942489658251617,-0.5420044433207636,-0.3152982565614292},
{0.3520460254872322,-0.48870611144881304,-0.31982872235700416},
{0.3825650763594894,-0.4934248535479324,-0.3274641333641748},
{0.381814122874495,-0.4695836941962484,-0.3350414476833946},
{0.40185640435294817,-0.43786828189804033,-0.3553376332054848},
{0.42459480249815756,-0.5062846630123132,-0.3495957438796753},
{0.4338569207679521,-0.5049645771583189,-0.36417908841993146},
{0.44170535296427593,-0.5451976094288773,-0.36124305394922995},
{0.3893548577975976,-0.6348052954055202,-0.3933500809588106},
{0.4146570412647864,-0.6659096166156527,-0.38214817883021246},
{0.42976971118415036,-0.7266077451491957,-0.3763040823681932},
{0.43124902499771384,-0.7675379376751642,-0.3710893666923081},
{0.44832514779689825,-0.7855403798877875,-0.35923656648574215},
{0.4249240170632124,-0.8175903860740087,-0.34847684470432555},
{0.4069613818404816,-0.8324782002937111,-0.34288342469216826},
{0.41663448038429884,-0.8532520696945084,-0.3072787618950279},
{0.45457592107457356,-0.8788748608100185,-0.28721281139555777},
{0.49298643872682185,-0.9038338434724605,-0.26758796537867746},
{0.5270988773352986,-0.9241580014739346,-0.24191676035654155},
{0.5120970214688779,-0.8961909014131482,-0.21623910014685552},
{0.5434617019101976,-0.9048225630322169,-0.19143934544398244},
{0.584372528873516,-0.8150459663146795,-0.14968504064078497},
{0.6130948858776635,-0.7794671242677397,-0.12213214844779637},
{0.7026035923118716,-0.7273952780303071,-0.0958799765461519},
{0.4075369693970317,-0.5838663345831294,-0.20989042319133716},
{0.40454176237378764,-0.6162068242091051,-0.22392184919606017},
{0.43174607443907115,-0.5853693174177098,-0.20153418290773922},
{0.4250348311161557,-0.6133105967282958,-0.22159475408425097},
{0.4195145698962328,-0.6209352490895496,-0.22135268455112242},
{0.4158211267529869,-0.6496726681979806,-0.23000478759743298},
{0.388679214834021,-0.634287804536921,-0.24373174392270988},
{0.34635900525559854,-0.62141508469744,-0.2609670946814634},
{0.29556958961145147,-0.606485311758662,-0.31984916378424616},
{0.2837673550406946,-0.5698488948180982,-0.3335567545468727},
{0.279628503956492,-0.5333286712534361,-0.340119528556136},
{0.2734670274399264,-0.4926728241983464,-0.3469071582650608},
{0.32283199836468585,-0.5102363136575631,-0.33007956018655493},
{0.35130152718978797,-0.47009472987729767,-0.3298450217055682},
{0.3492111222881488,-0.44825575453073474,-0.3417311737144763},
{0.3769877943162074,-0.44372959219352653,-0.34434660053685645},
{0.3785617842138389,-0.4263662135483628,-0.3503735939794617},
{0.4089312899078522,-0.37105493902537423,-0.3641521918051394},
{0.4195543768861251,-0.42836516995970886,-0.3588686207953867},
{0.42775138921015404,-0.4648025519508115,-0.36833300160841753},
{0.3445709183042222,-0.5549912048069631,-0.41205075929143564},
{0.35323808345481633,-0.5976062012835065,-0.40378058817517226},
{0.3503805870993077,-0.6793073583758749,-0.4020807221203139},
{0.39691711001253377,-0.7059350070200165,-0.3901203354545797},
{0.39449641468124824,-0.750369290521095,-0.38624184360156427},
{0.35443014142240054,-0.770147985174586,-0.38590832557814275},
{0.38913322969171105,-0.7928713212155118,-0.3649806075407349},
{0.3688983684513467,-0.8079861428640592,-0.36282242316981983},
{0.37998838066240986,-0.8313151906701022,-0.33273156640505225},
{0.4148593038080227,-0.8523935297503457,-0.30216948094912777},
{0.45269746149749596,-0.8768135042523549,-0.28365277546168044},
{0.48985459690043415,-0.9009849540336855,-0.2634125348983577},
{0.48076031350694204,-0.8781551073981829,-0.2386568906437436},
{0.5182391324227933,-0.8199788054675439,-0.18596749813068528},
{0.5510250299897255,-0.8113428403901084,-0.1679069592301113},
{0.6147882967449717,-0.7625545328864909,-0.14722991764256552},
{0.6838749414998629,-0.7182009392297884,-0.12241510083540885},
{0.44327073594517397,-0.6275421335470718,-0.21966034954840585},
{0.4581650053524263,-0.6114267578282597,-0.22913441314276184},
{0.4751131002652006,-0.6275873198599224,-0.21201417989531837},
{0.47019424735202825,-0.6459630870858594,-0.2100539546092729},
{0.4747419269810702,-0.6724304319058403,-0.2076214247674788},
{0.4438925856791664,-0.6633286174602064,-0.21747634442729039},
{0.4966970957035347,-0.6252311764041378,-0.19887356977250845},
{0.49437000059172553,-0.6475510632231827,-0.20169771432567496},
{0.5067037122707736,-0.6795526555027784,-0.20017106247007752},
{0.42277121201525575,-0.7276900649284281,-0.21991210186285956},
{0.3977928637901634,-0.6997864408785509,-0.2327762147856071},
{0.3775805957062245,-0.6692039139953845,-0.24919606018386528},
{0.33993932123702914,-0.6478813536528293,-0.2734094686842714},
{0.3153020220875001,-0.631112928126866,-0.29872025906819366},
{0.2798974701044127,-0.6386063250079345,-0.3422045541348166},
{0.26508389054153647,-0.5992479706504139,-0.34721808313205704},
{0.2552935227572258,-0.5576464386192354,-0.35282764111308956},
{0.26589401657907336,-0.521519981495129,-0.3735864484096032},
{0.252592026767511,-0.485192337692378,-0.3832165123697531},
{0.27281505349736684,-0.45511331543811895,-0.36320973442282556},
{0.31857049871703147,-0.4786704465375988,-0.34678666143079234},
{0.34756289773369126,-0.43186280574726865,-0.35174854892763197},
{0.34939401926873487,-0.4119614625303259,-0.3641952263888067},
{0.3860928363556163,-0.39882515586588274,-0.360856818560816},
{0.39307842514941066,-0.368453498442686,-0.3668074256174118},
{0.42452917475806495,-0.31367692862176366,-0.36985642587024},
{0.43611408468130203,-0.3557819652818496,-0.3684029328068769},
{0.4337568653609257,-0.3828711598358231,-0.37220719000306624},
{0.4288993367294792,-0.42387128356025106,-0.3706224414595179},
{0.37197856877733365,-0.51297761663717,-0.408023798124768},
{0.3151879804407817,-0.6060269934426054,-0.4242822638342738},
{0.32632640655847056,-0.6466408817786193,-0.4127210229320538},
{0.3102088791104752,-0.7047192800314153,-0.4126467882752277},
{0.34313033561595935,-0.7299891875608534,-0.40159443132487344},
{0.31849411233102204,-0.7504263113444543,-0.4065272704777377},
{0.29402357219320374,-0.7677369726246254,-0.408878034610564},
{0.3313184182638773,-0.7879051302603055,-0.3870272247534925},
{0.3448086843789841,-0.8054826059592141,-0.35876856538836027},
{0.37668547636594457,-0.8314722669004879,-0.32233441099103266},
{0.3861229605641834,-0.8107963011775339,-0.29448350430614806},
{0.41763288272538024,-0.8352797516904523,-0.2775892026229579},
{0.4492148878142197,-0.8555554957853007,-0.257698618051932},
{0.48757161223688383,-0.8212085186958369,-0.20900929009074917},
{0.5239627320505441,-0.7826452282715698,-0.17388015944313248},
{0.5823757241913533,-0.7671915092766426,-0.16474606905974815},
{0.6600219476376704,-0.7110701087161169,-0.14495553989574872},
{0.538818270332496,-0.6859088635104386,-0.19353943312694666},
{0.4519379010957681,-0.7517420937400819,-0.20834225404390605},
{0.41761782062109665,-0.7681845322947655,-0.26123498496479236},
{0.39083847506952774,-0.7394664787489847,-0.2733911789862128},
{0.3512014717827614,-0.7063169389500636,-0.28314066391603954},
{0.3297229110744122,-0.6724056870202316,-0.29599509405746194},
{0.304486355347316,-0.6606238938767167,-0.32252053556539373},
{0.2326810007692432,-0.6751835693959559,-0.3618014276723132},
{0.21737575108796808,-0.6324147242828018,-0.3673077026525442},
{0.20921854575383142,-0.585629676648897,-0.36936798334561616},
{0.2053497366821412,-0.5414686627541058,-0.36717321957858384},
{0.18646293377515502,-0.5009698919294018,-0.3777048580665638},
{0.16634534177528415,-0.4622495252747489,-0.3955276308923759},
{0.2318633436795645,-0.4488238110351431,-0.38926932656255886},
{0.26974776354648006,-0.4179314351495721,-0.38236980693609907},
{0.3153213876501504,-0.44622882564000493,-0.3622210148630694},
{0.31012388580773226,-0.41588191310241696,-0.3797188765821934},
{0.3517103557346273,-0.39742222843832875,-0.3746892096160777},
{0.3531154348913646,-0.37987272521880394,-0.38274420781400453},
{0.40945738769318496,-0.32704024271505183,-0.37111088398414177},
{0.44252623764772964,-0.2548196044045896,-0.38010296024142404},
{0.4527813789356472,-0.2911429447489739,-0.3696391012227201},
{0.4489330112911989,-0.30270418565119395,-0.3768828975185184},
{0.4400560525452267,-0.34243694088661997,-0.37423304302920435},
{0.3983146581171294,-0.4293893930509906,-0.39857985873897916},
{0.3854483934651985,-0.4713083051367155,-0.40439813445079803},
{0.30224748113202476,-0.5654647466069921,-0.4328881047031421},
{0.27719597411469793,-0.6251902935496538,-0.4331947261117716},
{0.2852972344900671,-0.6700387849185302,-0.42062647595173674},
{0.24346977089463523,-0.7129808442309451,-0.43764988138592875},
{0.2787721157415128,-0.7364067198502398,-0.42560880487581837},
{0.2540530508830159,-0.7463143568750437,-0.425748667272737},
{0.26534747736649866,-0.7700393228508259,-0.40173536958638384},
{0.305482605959214,-0.7847980333195264,-0.37977266981177754},
{0.33896458791696477,-0.8063217803407264,-0.3404896259756747},
{0.354550638256669,-0.7865958030522279,-0.31136597147882966},
{0.42761367854241866,-0.7929928939143721,-0.24822455445757596},
{0.45758834193128456,-0.8117323033722975,-0.23165086042270722},
{0.49005470771448706,-0.7902838668725155,-0.18810416520976672},
{0.6019629149475247,-0.6977358429668042,-0.17508082432745015},
{0.6322398962866533,-0.7043545619348347,-0.16225651839459487},
{0.35894769684287536,-0.35672011920579677,-0.3932371151766839},
{0.30400974733320063,-0.38818162746036783,-0.4007638638600946},
{0.30136634803143675,-0.3598132299068839,-0.4220821207442832},
{0.2846624743809744,-0.3330478705950069,-0.4369290521095015},
{0.33175737101728375,-0.34328902564323255,-0.4268815526877787},
{0.39766268417456985,-0.2509077607492321,-0.39063567459399556},
{0.42361361399054315,-0.24814494047779145,-0.3822794343103977},
{0.4358483461271564,-0.20468431443218554,-0.38821928272107675},
{0.4527985927691141,-0.2104929073626793,-0.3858082701711163},
{0.45761201095230153,-0.25448070705820963,-0.3751109485360173},
{0.4603888174634341,-0.2636406181917944,-0.3801309327208078},
{0.4024169298052147,-0.344320779786656,-0.4107295975728495},
{0.40379296061797665,-0.3877297643318612,-0.4014481137404047},
{0.3145338547690388,-0.477368650381663,-0.4395606169007569},
{0.31593032700904267,-0.5212736085036338,-0.43856974561181733},
{0.26873752669489015,-0.5800889740017322,-0.4403513773756435},
{0.2044503138834946,-0.6168114601096306,-0.4367483068580989},
{0.22021173015164314,-0.6677407381506963,-0.4381533860148362},
{0.18162261897717552,-0.6831212983533893,-0.4354691038585884},
{0.21157684093879944,-0.7255533978493467,-0.4368634243694089},
{0.2237954351065375,-0.7477570912924901,-0.4157442024346816},
{0.26409409511718857,-0.7672474542354101,-0.387354287589364},
{0.30220337068376574,-0.785880353098759,-0.36422750232655715},
{0.3226813773218503,-0.7631839136726253,-0.3288767435730539},
{0.43055294060689525,-0.17870110867846173,-0.40183434912881866},
{0.44774418091738977,-0.1792992893914372,-0.3948702776268579},
{0.46701399161901486,-0.21228637363701403,-0.3808173343303012},
{0.46644808684378986,-0.22245974921596368,-0.38990301080705986},
{0.41069463197361983,-0.3016143348198196,-0.4070436854817453},
{0.3154612500470691,-0.38950386504354567,-0.43914425730377576},
{0.314119646901241,-0.4337767688558718,-0.4374271774154505},
{0.2657832025261301,-0.48921714712986225,-0.45354470486344595},
{0.27469243720985276,-0.5348262747650581,-0.4485279482724304},
{0.20832019881977656,-0.568456726036461,-0.4414401523424262},
{0.16724476457393073,-0.5771260429162386,-0.43392523816952405},
{0.16674986686175677,-0.631702501923108,-0.43241042082443504},
{0.16636901079630118,-0.6650155731399646,-0.4266125865398581},
{0.18801110292258616,-0.7136715492988053,-0.4253914802282984},
{0.22407085644200822,-0.7432018806113062,-0.40071544995346886},
{0.2604157140782261,-0.7107731700888127,-0.35811659144580066},
{0.29061953662512036,-0.7400280800658431,-0.3465639574603141},
{0.3162939692410313,-0.29926787414536005,-0.44744885608697293},
{0.2815220256378532,-0.3133541692442589,-0.4510207265313588},
{0.31533322216065884,-0.3456301069947336,-0.43618240208287384},
{0.36863262989720114,-0.26259810540245404,-0.43377031366832175},
{0.351833004298079,-0.2620902973151799,-0.43641586469926896},
{0.38794439931790187,-0.194039710162079,-0.4263888067047881},
{0.44345040533198493,-0.16682571531547039,-0.41350532821939034},
{0.461924076235765,-0.18117882483310652,-0.38987934178604283},
{0.4623404358327461,-0.18917142288471572,-0.3989747010441266},
{0.434094686842714,-0.2455295136554113,-0.40281338590724974},
{0.2654496845027085,-0.39537916157872366,-0.4551014809276105},
{0.26035761739027524,-0.4427268863940784,-0.4544247620994422},
{0.23625287121362906,-0.47007751604383075,-0.45688311269143667},
{0.23537819330059118,-0.5209002834903199,-0.4509712367601414},
{0.19320645303582093,-0.5271693464660538,-0.4427946658633545},
{0.15115628546991075,-0.5568664367902656,-0.42722905695089214},
{0.1547905560606142,-0.6117624275808647,-0.42816505914565595},
{0.1661775068989817,-0.6608971634830041,-0.4126995056402201},
{0.19035648773245398,-0.7072561687386024,-0.40793019790529167},
{0.2531590074073277,-0.31236437381991106,-0.4524795989176802},
{0.2540508991538325,-0.35185183192843345,-0.44983942720969144},
{0.206854871245905,-0.3735487931488943,-0.4670672469163032},
{0.22535651462906878,-0.4205673033991942,-0.4605012453132649},
{0.18168394325890147,-0.4228943985110034,-0.45684545743072774},
{0.19776381544618796,-0.474264781034659,-0.453212262704616},
{0.15714885124558223,-0.5021264463654604,-0.43013496721302663},
{0.1474983458581903,-0.557007375051776,-0.4092900907491784},
{0.14984910999101653,-0.610697321635099,-0.41181191735208206},
{0.22225049355288146,-0.30222327417871186,-0.4663023071916169},
{0.22147694691146175,-0.2940542343340667,-0.4615254684045466},
{0.20320123509255128,-0.32407515990037494,-0.4717816855570558},
{0.16300478221811004,-0.31882171309918933,-0.4817302054363438},
{0.17132982242854913,-0.3708311591903043,-0.46701130195753565},
{0.1500481449404778,-0.3942828555597992,-0.4481266507797329},
{0.1575501487382798,-0.44793191928863835,-0.43934006465946196},
{0.15203634270590702,-0.5031657315610257,-0.4092761045094865},
{0.18157528093514153,-0.24575221762588959,-0.48158711544565},
{0.1847770539599886,-0.2603473966766543,-0.5042340651005665},
{0.17377956610381015,-0.27572150169179704,-0.5037596088156345},
{0.14548970666551908,-0.29155177329381327,-0.4826048833493817},
{0.14721862106435285,-0.34403244807608513,-0.4677224484526378},
{0.13799846151363387,-0.40035395945066354,-0.43383701727300605},
{0.1453412373518669,-0.45169744535952705,-0.4212719947067462},
{0.18503526146199237,-0.2552456467828959,-0.5192714244985127},
{0.14469356686767404,-0.24577911424068166,-0.5104482589821245},
{0.11075757005223322,-0.2978563398010726,-0.4339930176388},
{0.12645013098651403,-0.3481809819416128,-0.43793283377354125},
{0.14348106747284786,-0.37718844306255617,-0.4202262543236308},
{0.14900670801572916,-0.42294926760517926,-0.4138280875968951},
{0.21067956986933623,-0.41393997751443,-0.3991511428371625},
{0.2568363125816985,-0.3844236324416209,-0.4001420141261021},
{0.23224204801583673,-0.3585157372093148,-0.41766569659542646},
{0.18679860352775998,-0.20661979483262236,-0.4913591935319021},
{0.167718144994271,-0.19463251155209604,-0.5127979472503591},
{0.14634609488049832,-0.1996557233306616,-0.5152100356649112},
{0.12091265593312427,-0.20800873602048447,-0.48040689198857434},
{0.10237550901843494,-0.2509282021764741,-0.4107833908024336},
{0.13937987164935423,-0.33040124369946794,-0.4137517012108856},
{0.19540874785499496,-0.37491514118033104,-0.4070200164607282},
{0.17883720554930957,-0.19490362942920006,-0.4596276432648187},
{0.15817199847227228,-0.17690764240412704,-0.4741604221692658},
{0.13287627019263357,-0.18522084810405762,-0.47853596346363847},
{0.10015277277201891,-0.21590558212343394,-0.4286965362539471},
{0.09527157511955543,-0.2239508975400356,-0.40245404713362776},
{0.1273678434832192,-0.2293517377902817,-0.3754724390388226},
{0.13440077031904762,-0.28754955701275436,-0.39603005965669164},
{0.17546544591897664,-0.3377160470583172,-0.4113492955776586},
{0.17321796478695192,-0.21816167017219212,-0.44702281370866664},
{0.1685175123858911,-0.19503918836775203,-0.42601010236851594},
{0.1392141885022351,-0.17534333528782067,-0.4201036057601791},
{0.11585501648762486,-0.18204919928777763,-0.43324421588298895},
{0.10067887055735164,-0.19536409947444014,-0.39531998902618115},
{0.12222736246416026,-0.19565673464337777,-0.3735617035239945},
{0.14859895533548148,-0.20868115139028603,-0.36812320801303955},
{0.15388575393900925,-0.2398833762782616,-0.3764439447651119},
{0.16361156984781897,-0.2499125860019258,-0.3799781599487888},
{0.167331909605857,-0.29858362426505,-0.4019462390463537},
{0.2141610676880208,-0.3251402658461406,-0.4319854543107205},
{0.1915711388564635,-0.292304878507991,-0.4388516221348381},
{0.42411711861945056,-0.19632592241940428,-0.4149114832407193},
{0.4070646648412831,-0.1644340683281602,-0.42709564974152353},
{0.4579175564963394,-0.7813638735428758,-0.19968154408086197},
{0.5706509518711975,-0.691759415160008,-0.1853209035110841},
{0.7360134913419797,-0.6861251122933667,-0.14078871633216244},
{0.14859895533548148,-0.20868115139028603,0.36812320801303955},
{0.1273678434832192,-0.2293517377902817,0.3754724390388226},
{0.12222736246416026,-0.19565673464337777,0.3735617035239945},
{0.10067887055735164,-0.19536409947444014,0.39531998902618115},
{0.09527157511955543,-0.2239508975400356,0.40245404713362776},
{0.11585501648762486,-0.18204919928777763,0.43324421588298895},
{0.13287627019263357,-0.18522084810405762,0.47853596346363847},
{0.15817199847227228,-0.17690764240412704,0.4741604221692658},
{0.1392141885022351,-0.17534333528782067,0.4201036057601791},
{0.42411711861945056,-0.19632592241940428,0.4149114832407193},
{0.4623404358327461,-0.18917142288471572,0.3989747010441266},
{0.44345040533198493,-0.16682571531547039,0.41350532821939034},
{0.4070646648412831,-0.1644340683281602,0.42709564974152353},
{0.7943931316804467,-0.6855290833095746,0.00019580735568621336},
{0.7820002474488561,-0.716745294437242,0.00019257976191116587},
{0.8106741905463778,-0.6975884495177437,-0.009915168076945835},
{0.8228325362969816,-0.6343803288918057,-0.006047434869847282},
{0.8228217776510649,-0.6391248917411254,-0.027983238029661586},
{0.8115897513138997,-0.6909159373201289,-0.027064449668364743},
{0.7828932150599526,-0.7223085902408322,-0.005824730899369006},
{0.7915281042727962,-0.7317977159394718,-0.020172461094046704},
{0.7872343286873915,-0.7218868513208927,-0.030189836307202376},
{0.8034895668031222,-0.6636137215770024,-0.03800599256577567},
{0.7830094084358543,-0.706783864182854,-0.037776833407747304},
{0.8022620053040125,-0.6890546915765182,-0.05212133600864995},
{0.7870654179464972,-0.7165742319671646,-0.049451040092094015},
{0.7885382765725105,-0.72508862434574,-0.06739646148135796},
{0.8018015352587724,-0.6911752206867243,-0.0673932338875829},
{0.7946631736929591,-0.6927212381049721,-0.08187975061458765},
{0.7829125806226028,-0.7171842471906487,-0.08163983281064247},
{0.7745369747763547,-0.700030662140863,-0.09094606152869601},
{0.7867609482670511,-0.6607562252214937,-0.0883532278627412},
{0.7740194839077554,-0.7153520497910134,-0.1023878814612393},
{0.7945416009940989,-0.6760786887362357,-0.10505602564861186},
{0.7744369193693281,-0.7207819383852349,-0.12009876436951646},
{0.7892053126193538,-0.6950171331436225,-0.11837630515823279},
{0.7710963598121542,-0.6868846726950946,-0.14012490787909435},
{0.7607078113148679,-0.7192273140502536,-0.14037020500599795},
{0.7360134913419797,-0.6861251122933667,-0.14078871633216244},
{0.7490551219223548,-0.6556544753277352,-0.14298132837001135},
{0.7325147796898283,-0.6948482224027286,-0.16037805881751724},
{0.7474918906706403,-0.6644539718231064,-0.16272021603361},
{0.7427419484983621,-0.6646487033142009,-0.18183402636944115},
{0.727917610289569,-0.7003641801642846,-0.17972533176974348},
{0.7270978014707069,-0.6552951365541133,-0.18855280074449832},
{0.7094073599896717,-0.6912236345933501,-0.1861181191735208},
{0.6931241493945571,-0.6753944388559256,-0.1773218502719248},
{0.7028908481578509,-0.6421007332017192,-0.18114977648913108},
{0.6947712980844232,-0.6241983463961226,-0.1968767650903457},
{0.6968455650171869,-0.6440415929251144,-0.20448743121190766},
{0.6830927879417097,-0.6860153741050151,-0.20496834268438976},
{0.682051351016961,-0.6421512988375283,-0.21599272715536025},
{0.671530471174898,-0.682969601445962,-0.21239933941914071},
{0.667000005379323,-0.6378166403976395,-0.21855328488356457},
{0.6526458199970951,-0.6709790905716606,-0.2121368284587702},
{0.6469803170572952,-0.6311591903043082,-0.21195500734277586},
{0.6332200089296761,-0.6666143079232048,-0.20999585792132203},
{0.6433783224043422,-0.6177065794499104,-0.23270198012878102},
{0.6452234301790777,-0.6326966008058226,-0.24006842498803102},
{0.6329897739070561,-0.6717235888691049,-0.234128576577352},
{0.6319354266072073,-0.6385622145596755,-0.24985448931397497},
{0.6220568379263786,-0.671550374669844,-0.24601688031544353},
{0.6175694067144709,-0.6321124063325391,-0.25461088667380327},
{0.6012453132648725,-0.6586087994964953,-0.2455198308740862},
{0.5915689871272802,-0.629943463315707,-0.2606109835016165},
{0.5828932150599525,-0.6599988165489492,-0.25458614178819455},
{0.5722141831229122,-0.6212547808732792,-0.25604071071614926},
{0.5641860815397775,-0.6481998095719672,-0.2522117086343513},
{0.5564022012189546,-0.6443557453858858,-0.2512681753874457},
{0.5657342506872085,-0.6160174720409689,-0.2507872639149637},
{0.5513574721485553,-0.6142240057666343,-0.23839437968337307},
{0.5438016751211693,-0.6354691038585883,-0.24749189067064023},
{0.53716466645508,-0.6426451206851106,-0.2579783428457694},
{0.546574178173935,-0.6144961995083299,-0.2575071141546125},
{0.5330570154440363,-0.6155085880891031,-0.2670500330828362},
{0.5262941306207201,-0.6372754805080232,-0.26752018590940146},
{0.5154074568174849,-0.6075848453713616,-0.26491013840997973},
{0.5069188851891101,-0.6380587099307681,-0.26773535882773797},
{0.4940558481309542,-0.6027520616255237,-0.26253570525613645},
{0.48621602285136395,-0.630499685309607,-0.267558917034702},
{0.472329838566518,-0.5953296718075063,-0.253507049602737},
{0.4673571924237616,-0.6159615270822014,-0.25633227002049525},
{0.4604178658074095,-0.6099711130357133,-0.27496839647761934},
{0.46646745240644016,-0.5832853677036208,-0.2675901171078608},
{0.43930187146645727,-0.5710893666923081,-0.281654894914926},
{0.43652076149695795,-0.5929412524139712,-0.29357547459076805},
{0.41626545882935173,-0.5583253091765871,-0.2831126914366558},
{0.4054099850992754,-0.5749129894511477,-0.29619090141314813},
{0.3968407236265244,-0.5543564446978703,-0.28097172089920763},
{0.3906340607971081,-0.5650548421975611,-0.2942930762734202},
{0.35733712754912667,-0.5777629547545146,-0.2693028935378194},
{0.3761066612156194,-0.5616368203897858,-0.24876679021178394},
{0.3950612435918815,-0.5653991188668994,-0.21613043782309557},
{0.39050495704610616,-0.5910315927637347,-0.22805101749893758},
{0.4075369693970317,-0.5838663345831294,-0.20989042319133716},
{0.4163784246114784,-0.5726396875689226,-0.2098871955975621},
{0.4414579041081889,-0.5720673276061474,-0.20153203117855586},
{0.43174607443907115,-0.5853693174177098,-0.20153418290773922},
{0.46201014540309954,-0.5954523203709581,-0.21988950870643423},
{0.4581650053524263,-0.6114267578282597,-0.22913441314276184},
{0.480601085547373,-0.5942989935286744,-0.18913161589482347},
{0.4751131002652006,-0.6275873198599224,-0.21201417989531837},
{0.5009155607675219,-0.6129211337461067,-0.18766521245636025},
{0.4966970957035347,-0.6252311764041378,-0.19887356977250845},
{0.5305631613205162,-0.6159249476860842,-0.18668402394874584},
{0.5234355584006197,-0.6358725530804693,-0.19764923586717378},
{0.821351070754235,-0.6365675616066963,0.0002033384078279908},
{0.8103987692109071,-0.6335497614270268,-0.013478431604598246},
{0.809802740227115,-0.6356089662555071,-0.030870858593737397},
{0.8055885786214947,-0.6384686143401991,-0.034937626750297206},
{0.8019510804370162,-0.6274237884419868,-0.04706692415692561},
{0.806580525775026,-0.6554941715035746,-0.061893414094902025},
{0.7998628272645606,-0.6501471244829126,-0.07833262505581048},
{0.7897453966443783,-0.6384309590794903,-0.08763992963845571},
{0.7949558088618967,-0.638438490131632,-0.10338843553150401},
{0.794971946830772,-0.6668606809147001,-0.11554140195914943},
{0.7837366928998316,-0.6547335352372551,-0.13557830411464414},
{0.7797839663899901,-0.6174623581875985,-0.12912526829373255},
{0.7493585157372092,-0.6393002576695697,-0.14226910601031753},
{0.7479050226738463,-0.6268126973539111,-0.16105262591650216},
{0.7513456376380468,-0.6401899976868911,-0.16200691780932452},
{0.7500147931381357,-0.6442492347913091,-0.17727989155284918},
{0.726372668735913,-0.6313044320241854,-0.1851670548744735},
{0.6964668606809146,-0.6273850573166861,-0.17111088398414176},
{0.674779582241779,-0.6081442949590364,-0.18540804854301038},
{0.6879126613124472,-0.6092879390199949,-0.1911467102750448},
{0.668700947298773,-0.6054148264899379,-0.18689381754412393},
{0.6817458054729232,-0.613597852574275,-0.2059420001398624},
{0.6608449840503074,-0.6113891025675509,-0.2102325481314922},
{0.6461852531240418,-0.6118893796026832,-0.21099856372077008},
{0.80220928793902,-0.6227868120518352,-0.062104283554871784},
{0.7865328649736145,-0.6512488098247954,-0.046593543736585315},
{0.7954205823655035,-0.6244888298358768,-0.07235727311360593},
{0.7785456462449636,-0.6452368784864737,-0.07595819190196722},
{0.7836753686181057,-0.6357057940687585,-0.08904178120141801},
{0.7845952328439944,-0.6148738279800104,-0.09904947363324852},
{0.7885060006347601,-0.6237088280069071,-0.11292812686595265},
{0.7794300069393266,-0.6078021700188814,-0.1090668488464042},
{0.7724196732599234,-0.60940628412508,-0.12151675390135398},
{0.7433046256798119,-0.6365847754401631,-0.12417521530740142},
{0.7345083567782159,-0.6515468243166915,-0.1413266486280037},
{0.7259584608681153,-0.6192902521288671,-0.15422088575931833},
{0.7407440679516076,-0.6235958622247804,-0.17326799249046515},
{0.7190266653039048,-0.6138474531595454,-0.17277201891369953},
{0.6916566700915023,-0.6298853666277563,-0.1621015938933926},
{0.671893037542295,-0.6163552935227572,-0.15949262225856256},
{0.6738704766618073,-0.6195710527872962,-0.17069882784552737},
{0.6640919433880051,-0.6128512025476474,-0.17804483127753543},
{0.7226286599568578,-0.6272989881493516,-0.15202504612769438},
{0.7078333700920402,-0.627737940902758,-0.15491374255636187},
{0.6944797387800772,-0.6264953172993647,-0.1513719963205431},
{0.6876415434353432,-0.6470905931779426,-0.1516172934474467},
{0.6815855016487625,-0.6749264377585437,-0.15655551192326936},
{0.6779393965475505,-0.665336180788286,-0.16015212725326392},
{0.67495279644104,-0.622387666288321,-0.15135263075789282},
{0.6529793380205168,-0.6386106284663012,-0.15423379613441854},
{0.6596755192391486,-0.6108694599697682,-0.16228664260316197},
{0.6461583565092498,-0.6118818485505415,-0.17182956153138565},
{0.6485790518405353,-0.6177173380958273,-0.18978358983738308},
{0.6521390877744128,-0.6074826382351517,-0.1983151960494252},
{0.6368381415515043,-0.6147748484375756,-0.19932650876560679},
{0.6368220035826291,-0.6124348429506663,-0.22743885054627025},
{0.6280999693378592,-0.6085176199723503,-0.2350183165946734},
{0.6325002555178405,-0.6080711361668021,-0.23980376229847714},
{0.6157167678875938,-0.6123692152105736,-0.24480438092061735},
{0.600010220713621,-0.6077386940079722,-0.253869615970134},
{0.5790577577906045,-0.6077440733309306,-0.2496177991038048},
{0.5645109926464655,-0.6036364223198868,-0.24796311936179713},
{0.5558050963705709,-0.5997299579874877,-0.23604684314432187},
{0.5418930913355245,-0.5863096230708403,-0.24275701060264557},
{0.5314023357020285,-0.5911015239621942,-0.2527765375449846},
{0.5198389430706252,-0.5906625712087876,-0.2515898589003588},
{0.49963313017423633,-0.5745127678230417,-0.24223198868190451},
{0.47412438070544444,-0.5843042114719441,-0.24010392851955653},
{0.4663340451970715,-0.5713949122363459,-0.25395245754369355},
{0.443928089210692,-0.5589127312436457,-0.26848523644814065},
{0.4217695820803994,-0.5489642113643577,-0.27238201799921463},
{0.39542918928223697,-0.5418925534032287,-0.2606798388354842},
{0.3809620381178825,-0.5519841632732104,-0.2444568766575039},
{0.39505586426892314,-0.5583145505306703,-0.22230805230853645},
{0.42112621505457326,-0.5770980704368548,-0.2322909998547583},
{0.43778490239218487,-0.5656637815564532,-0.2160927825623867},
{0.4710549390253743,-0.5829271047945905,-0.23109356256421568},
{0.49650774353539867,-0.5872735977449878,-0.2207760211299806},
{0.49852176205102827,-0.581099210853322,-0.2076999628826716},
{0.49353405380398824,-0.5788603366380308,-0.19837221687278442},
{0.5143864613199783,-0.5976320220337069,-0.19269165182870085},
{0.5424148856624905,-0.6008058225791703,-0.18480341264248482},
{0.5561945593527599,-0.6069888163875695,-0.20597212434842951},
{0.5561450695815425,-0.6467968821444133,-0.20576233075305142},
{0.5665196318391368,-0.6571477753809906,-0.20287471018897563},
{0.5759119297245249,-0.6252526936959714,-0.19143181439184065},
{0.5908653716843199,-0.6367171067849401,-0.1826000419587191},
{0.5774514919552225,-0.6573209895802514,-0.19098640645088408},
{0.5963296879454751,-0.6640806468097925,-0.1888088565173187},
{0.6080286395154306,-0.6420942780141692,-0.17807710721528588},
{0.6166237217383821,-0.668876851159513,-0.18233215167539016},
{0.6405046880799583,-0.6140927502864489,-0.19094229600262513},
{0.6281785074530519,-0.6719193962247911,-0.1749872241079738},
{0.6347950746918993,-0.6280241208841455,-0.16713986777624168},
{0.641410566066155,-0.6784541977546705,-0.1613700059710485},
{0.673573538034503,-0.6631801481465542,-0.16398435692883695},
{0.6257481293404412,-0.600294786898121,-0.18668940327170422},
{0.6148926556103649,-0.6001721383346692,-0.19858631392652923},
{0.6158340371280872,-0.6148469313652184,-0.21457043416515598},
{0.5968945168561085,-0.6134257142396058,-0.21909444477318085},
{0.5827565802568089,-0.611829131185549,-0.2240939875307294},
{0.6107139975362701,-0.6030425450652781,-0.24173816683432225},
{0.5918358015460174,-0.5968972065175877,-0.24391571676788762},
{0.5791545856038559,-0.5983775961957428,-0.24484096031673455},
{0.5575092658837958,-0.6051544672587508,-0.22124294636277078},
{0.5375530535726774,-0.5843633840244867,-0.22700850470959727},
{0.5273452503267939,-0.5845312189007892,-0.23248573134585285},
{0.518836237271177,-0.5807108237357246,-0.23795219933619155},
{0.5002818765230208,-0.5748043271273877,-0.23581230466333505},
{0.4543456860519535,-0.5660155892779335,-0.23513881342894183},
{0.45960989149905596,-0.5588750759829367,-0.23748419823880965},
{0.43394406579987843,-0.5544328310838798,-0.24991473773110917},
{0.4209174973237868,-0.5438323372620323,-0.25897889691603415},
{0.39343130873548254,-0.5480776989408113,-0.2542612306815064},
{0.3985352103584243,-0.5598734783240181,-0.24658816441362694},
{0.4111260536748845,-0.5702770889255878,-0.24183284291839033},
{0.44185704987170316,-0.5793229584124543,-0.23012205683792641},
{0.5409689236512693,-0.5930725078941564,-0.2060269934426053},
{0.5305125956847071,-0.5977880223995008,-0.21604759624953604},
{0.5128081679639801,-0.599342646734482,-0.2186931472804833},
{0.41281516108382604,-0.5473687041748926,-0.25396106446042704},
{0.512398263554549,-0.5991608256184877,-0.20342124940155032},
{0.5760582473089937,-0.5969940343308391,-0.19666159217200924},
{0.5800238841939354,-0.596350667305013,-0.20575587556550134},
{0.5950397263000479,-0.6030931107010872,-0.19457871832251192},
{0.7034987116521515,-0.6588702345922742,-0.13416892149954007},
{0.7151987390866986,-0.6333765472277659,-0.1320537717122923},
{0.7137570805338439,-0.6830266222693212,-0.13841428317831916},
{0.701551396741206,-0.6900154386568906,-0.1374718257960053},
{0.7193461970876346,-0.6258261295233382,-0.14512767823041792},
{0.7356455456516243,-0.6402265770830083,-0.13442820486613555},
{0.7224694319972889,-0.6924565754154182,-0.11368661140308882},
{0.7306836581547846,-0.6616653308014654,-0.11531762212407948},
{0.7470733793444758,-0.6619450555953028,-0.09740124907879096},
{0.7311495075229831,-0.6941833380850687,-0.09504940908137302},
{0.7620720076171213,-0.6639278740377735,-0.08386794838001689},
{0.7503719801825742,-0.6906609574119001,-0.08598309816726467},
{0.7476909256201015,-0.6997918202015095,-0.0773664986524796},
{0.7642807576238454,-0.6624991258600192,-0.07094251117554345},
{0.7670328192493693,-0.6661592172009231,-0.054025616335927965},
{0.747272414293937,-0.6995874059290897,-0.06218066994088125},
{0.7921122987460798,-0.6679161040791406,-0.03705277653754498},
{0.7696912806554168,-0.702768737526695,-0.042852762551305296},
{0.7646411722620591,-0.7055025094541602,-0.03587147721587761},
{0.7789867507275534,-0.6738581042190029,-0.0251375761846614},
{0.7700194193558798,-0.6864177474623044,-0.013943205108205082},
{0.7543784999219998,-0.7134542246512855,-0.01566566431948875},
{0.8041049613495646,-0.6638945222354314,0.0001990349494612608},
{0.775962495360334,-0.7110991570600923,0.00019150389731948338},
{0.7700194193558798,-0.6864177474623044,0.013943205108205082},
{0.7543784999219998,-0.7134542246512855,0.01566566431948875},
{0.7789867507275534,-0.6738581042190029,0.0251375761846614},
{0.7646411722620591,-0.7055025094541602,0.03587147721587761},
{0.7696912806554168,-0.702768737526695,0.042852762551305296},
{0.7921122987460798,-0.6679161040791406,0.03705277653754498},
{0.7670328192493693,-0.6661592172009231,0.054025616335927965},
{0.747272414293937,-0.6995874059290897,0.06218066994088125},
{0.7642807576238454,-0.6624991258600192,0.07094251117554345},
{0.7476909256201015,-0.6997918202015095,0.0773664986524796},
{0.7503719801825742,-0.6906609574119001,0.08598309816726467},
{0.7620720076171213,-0.6639278740377735,0.08386794838001689},
{0.7470733793444758,-0.6619450555953028,0.09740124907879096},
{0.7311495075229831,-0.6941833380850687,0.09504940908137302},
{0.7306836581547846,-0.6616653308014654,0.11531762212407948},
{0.7224694319972889,-0.6924565754154182,0.11368661140308882},
{0.7137570805338439,-0.6830266222693212,0.13841428317831916},
{0.7356455456516243,-0.6402265770830083,0.13442820486613555},
{0.7151987390866986,-0.6333765472277659,0.1320537717122923},
{0.7034987116521515,-0.6588702345922742,0.13416892149954007},
{0.701551396741206,-0.6900154386568906,0.1374718257960053},
{0.6876415434353432,-0.6470905931779426,0.1516172934474467},
{0.6815855016487625,-0.6749264377585437,0.15655551192326936},
{0.6779393965475505,-0.665336180788286,0.16015212725326392},
{0.6916566700915023,-0.6298853666277563,0.1621015938933926},
{0.67495279644104,-0.622387666288321,0.15135263075789282},
{0.673573538034503,-0.6631801481465542,0.16398435692883695},
{0.641410566066155,-0.6784541977546705,0.1613700059710485},
{0.6529793380205168,-0.6386106284663012,0.15423379613441854},
{0.6347950746918993,-0.6280241208841455,0.16713986777624168},
{0.6281785074530519,-0.6719193962247911,0.1749872241079738},
{0.6166237217383821,-0.668876851159513,0.18233215167539016},
{0.6405046880799583,-0.6140927502864489,0.19094229600262513},
{0.6080286395154306,-0.6420942780141692,0.17807710721528588},
{0.5963296879454751,-0.6640806468097925,0.1888088565173187},
{0.5774514919552225,-0.6573209895802514,0.19098640645088408},
{0.5908653716843199,-0.6367171067849401,0.1826000419587191},
{0.5759119297245249,-0.6252526936959714,0.19143181439184065},
{0.5665196318391368,-0.6571477753809906,0.20287471018897563},
{0.5561450695815425,-0.6467968821444133,0.20576233075305142},
{0.5561945593527599,-0.6069888163875695,0.20597212434842951},
{0.5305631613205162,-0.6159249476860842,0.18668402394874584},
{0.5424148856624905,-0.6008058225791703,0.18480341264248482},
{0.5009155607675219,-0.6129211337461067,0.18766521245636025},
{0.5234355584006197,-0.6358725530804693,0.19764923586717378},
{0.4966970957035347,-0.6252311764041378,0.19887356977250845},
{0.4751131002652006,-0.6275873198599224,0.21201417989531837},
{0.480601085547373,-0.5942989935286744,0.18913161589482347},
{0.4581650053524263,-0.6114267578282597,0.22913441314276184},
{0.46201014540309954,-0.5954523203709581,0.21988950870643423},
{0.43174607443907115,-0.5853693174177098,0.20153418290773922},
{0.4414579041081889,-0.5720673276061474,0.20153203117855586},
{0.4163784246114784,-0.5726396875689226,0.2098871955975621},
{0.4075369693970317,-0.5838663345831294,0.20989042319133716},
{0.3950612435918815,-0.5653991188668994,0.21613043782309557},
{0.39050495704610616,-0.5910315927637347,0.22805101749893758},
{0.35733712754912667,-0.5777629547545146,0.2693028935378194},
{0.3761066612156194,-0.5616368203897858,0.24876679021178394},
{0.3968407236265244,-0.5543564446978703,0.28097172089920763},
{0.3906340607971081,-0.5650548421975611,0.2942930762734202},
{0.41626545882935173,-0.5583253091765871,0.2831126914366558},
{0.4054099850992754,-0.5749129894511477,0.29619090141314813},
{0.43930187146645727,-0.5710893666923081,0.281654894914926},
{0.43652076149695795,-0.5929412524139712,0.29357547459076805},
{0.46646745240644016,-0.5832853677036208,0.2675901171078608},
{0.4604178658074095,-0.6099711130357133,0.27496839647761934},
{0.4673571924237616,-0.6159615270822014,0.25633227002049525},
{0.472329838566518,-0.5953296718075063,0.253507049602737},
{0.4940558481309542,-0.6027520616255237,0.26253570525613645},
{0.48621602285136395,-0.630499685309607,0.267558917034702},
{0.5154074568174849,-0.6075848453713616,0.26491013840997973},
{0.5069188851891101,-0.6380587099307681,0.26773535882773797},
{0.5330570154440363,-0.6155085880891031,0.2670500330828362},
{0.5262941306207201,-0.6372754805080232,0.26752018590940146},
{0.546574178173935,-0.6144961995083299,0.2575071141546125},
{0.53716466645508,-0.6426451206851106,0.2579783428457694},
{0.5438016751211693,-0.6354691038585883,0.24749189067064023},
{0.5513574721485553,-0.6142240057666343,0.23839437968337307},
{0.5564022012189546,-0.6443557453858858,0.2512681753874457},
{0.5657342506872085,-0.6160174720409689,0.2507872639149637},
{0.5722141831229122,-0.6212547808732792,0.25604071071614926},
{0.5641860815397775,-0.6481998095719672,0.2522117086343513},
{0.5915689871272802,-0.629943463315707,0.2606109835016165},
{0.5828932150599525,-0.6599988165489492,0.25458614178819455},
{0.6175694067144709,-0.6321124063325391,0.25461088667380327},
{0.6012453132648725,-0.6586087994964953,0.2455198308740862},
{0.6319354266072073,-0.6385622145596755,0.24985448931397497},
{0.6220568379263786,-0.671550374669844,0.24601688031544353},
{0.6452234301790777,-0.6326966008058226,0.24006842498803102},
{0.6329897739070561,-0.6717235888691049,0.234128576577352},
{0.6332200089296761,-0.6666143079232048,0.20999585792132203},
{0.6469803170572952,-0.6311591903043082,0.21195500734277586},
{0.667000005379323,-0.6378166403976395,0.21855328488356457},
{0.6526458199970951,-0.6709790905716606,0.2121368284587702},
{0.682051351016961,-0.6421512988375283,0.21599272715536025},
{0.671530471174898,-0.682969601445962,0.21239933941914071},
{0.6830927879417097,-0.6860153741050151,0.20496834268438976},
{0.6968455650171869,-0.6440415929251144,0.20448743121190766},
{0.6931241493945571,-0.6753944388559256,0.1773218502719248},
{0.6947712980844232,-0.6241983463961226,0.1968767650903457},
{0.7028908481578509,-0.6421007332017192,0.18114977648913108},
{0.726372668735913,-0.6313044320241854,0.1851670548744735},
{0.7270978014707069,-0.6552951365541133,0.18855280074449832},
{0.7094073599896717,-0.6912236345933501,0.1861181191735208},
{0.7427419484983621,-0.6646487033142009,0.18183402636944115},
{0.727917610289569,-0.7003641801642846,0.17972533176974348},
{0.7474918906706403,-0.6644539718231064,0.16272021603361},
{0.7325147796898283,-0.6948482224027286,0.16037805881751724},
{0.7360134913419797,-0.6861251122933667,0.14078871633216244},
{0.7490551219223548,-0.6556544753277352,0.14298132837001135},
{0.7710963598121542,-0.6868846726950946,0.14012490787909435},
{0.7607078113148679,-0.7192273140502536,0.14037020500599795},
{0.7892053126193538,-0.6950171331436225,0.11837630515823279},
{0.7744369193693281,-0.7207819383852349,0.12009876436951646},
{0.7740194839077554,-0.7153520497910134,0.1023878814612393},
{0.7945416009940989,-0.6760786887362357,0.10505602564861186},
{0.7745369747763547,-0.700030662140863,0.09094606152869601},
{0.7867609482670511,-0.6607562252214937,0.0883532278627412},
{0.7998628272645606,-0.6501471244829126,0.07833262505581048},
{0.7946631736929591,-0.6927212381049721,0.08187975061458765},
{0.7829125806226028,-0.7171842471906487,0.08163983281064247},
{0.8018015352587724,-0.6911752206867243,0.0673932338875829},
{0.7885382765725105,-0.72508862434574,0.06739646148135796},
{0.7870654179464972,-0.7165742319671646,0.049451040092094015},
{0.8022620053040125,-0.6890546915765182,0.05212133600864995},
{0.8034895668031222,-0.6636137215770024,0.03800599256577567},
{0.7830094084358543,-0.706783864182854,0.037776833407747304},
{0.8115897513138997,-0.6909159373201289,0.027064449668364743},
{0.7872343286873915,-0.7218868513208927,0.030189836307202376},
{0.7915281042727962,-0.7317977159394718,0.020172461094046704},
{0.8106741905463778,-0.6975884495177437,0.009915168076945835},
{0.7828932150599526,-0.7223085902408322,0.005824730899369006},
{0.7681258976745188,-0.6429797145731239,-0.09216501611107225},
{0.7998036547120179,-0.6587970758000399,-0.024686788920746435},
{0.7902112460125769,-0.6647347724815355,-0.025856253731905306},
{0.8028074686519955,-0.6633103277621479,-0.005341667697703567},
{0.7844951774369677,-0.6715815747430028,-0.008230364126371055},
{0.8147215931402874,-0.6402437909164752,0.0002011866786446258},
{0.8130496995648128,-0.6402384115935169,-0.001591203731098404},
{0.8103987692109071,-0.6335497614270268,0.013478431604598246},
{0.7998036547120179,-0.6587970758000399,0.024686788920746435},
{0.8028074686519955,-0.6633103277621479,0.005341667697703567},
{0.8228325362969816,-0.6343803288918057,0.006047434869847282},
{0.8228217776510649,-0.6391248917411254,0.027983238029661586},
{0.809802740227115,-0.6356089662555071,0.030870858593737397},
{0.7902112460125769,-0.6647347724815355,0.025856253731905306},
{0.7844951774369677,-0.6715815747430028,0.008230364126371055},
{0.8055885786214947,-0.6384686143401991,0.034937626750297206},
{0.7865328649736145,-0.6512488098247954,0.046593543736585315},
{0.7785456462449636,-0.6452368784864737,0.07595819190196722},
{0.7836753686181057,-0.6357057940687585,0.08904178120141801},
{0.7681258976745188,-0.6429797145731239,0.09216501611107225},
{0.7433046256798119,-0.6365847754401631,0.12417521530740142},
{0.7345083567782159,-0.6515468243166915,0.1413266486280037},
{0.7226286599568578,-0.6272989881493516,0.15202504612769438},
{0.7193461970876346,-0.6258261295233382,0.14512767823041792},
{0.6944797387800772,-0.6264953172993647,0.1513719963205431},
{0.8019510804370162,-0.6274237884419868,0.04706692415692561},
{0.80220928793902,-0.6227868120518352,0.062104283554871784},
{0.7954205823655035,-0.6244888298358768,0.07235727311360593},
{0.7897453966443783,-0.6384309590794903,0.08763992963845571},
{0.7845952328439944,-0.6148738279800104,0.09904947363324852},
{0.7794300069393266,-0.6078021700188814,0.1090668488464042},
{0.7724196732599234,-0.60940628412508,0.12151675390135398},
{0.7493585157372092,-0.6393002576695697,0.14226910601031753},
{0.7479050226738463,-0.6268126973539111,0.16105262591650216},
{0.7259584608681153,-0.6192902521288671,0.15422088575931833},
{0.7190266653039048,-0.6138474531595454,0.17277201891369953},
{0.7078333700920402,-0.627737940902758,0.15491374255636187},
{0.806580525775026,-0.6554941715035746,0.061893414094902025},
{0.7949558088618967,-0.638438490131632,0.10338843553150401},
{0.7885060006347601,-0.6237088280069071,0.11292812686595265},
{0.7797839663899901,-0.6174623581875985,0.12912526829373255},
{0.7513456376380468,-0.6401899976868911,0.16200691780932452},
{0.7500147931381357,-0.6442492347913091,0.17727989155284918},
{0.7407440679516076,-0.6235958622247804,0.17326799249046515},
{0.6964668606809146,-0.6273850573166861,0.17111088398414176},
{0.6738704766618073,-0.6195710527872962,0.17069882784552737},
{0.671893037542295,-0.6163552935227572,0.15949262225856256},
{0.6596755192391486,-0.6108694599697682,0.16228664260316197},
{0.6461583565092498,-0.6118818485505415,0.17182956153138565},
{0.6368381415515043,-0.6147748484375756,0.19932650876560679},
{0.6148926556103649,-0.6001721383346692,0.19858631392652923},
{0.6257481293404412,-0.600294786898121,0.18668940327170422},
{0.5950397263000479,-0.6030931107010872,0.19457871832251192},
{0.5760582473089937,-0.5969940343308391,0.19666159217200924},
{0.5800238841939354,-0.596350667305013,0.20575587556550134},
{0.5575092658837958,-0.6051544672587508,0.22124294636277078},
{0.5409689236512693,-0.5930725078941564,0.2060269934426053},
{0.5143864613199783,-0.5976320220337069,0.19269165182870085},
{0.49353405380398824,-0.5788603366380308,0.19837221687278442},
{0.49852176205102827,-0.581099210853322,0.2076999628826716},
{0.4710549390253743,-0.5829271047945905,0.23109356256421568},
{0.44185704987170316,-0.5793229584124543,0.23012205683792641},
{0.43778490239218487,-0.5656637815564532,0.2160927825623867},
{0.42112621505457326,-0.5770980704368548,0.2322909998547583},
{0.4111260536748845,-0.5702770889255878,0.24183284291839033},
{0.39505586426892314,-0.5583145505306703,0.22230805230853645},
{0.3809620381178825,-0.5519841632732104,0.2444568766575039},
{0.39542918928223697,-0.5418925534032287,0.2606798388354842},
{0.4217695820803994,-0.5489642113643577,0.27238201799921463},
{0.443928089210692,-0.5589127312436457,0.26848523644814065},
{0.4663340451970715,-0.5713949122363459,0.25395245754369355},
{0.47412438070544444,-0.5843042114719441,0.24010392851955653},
{0.49963313017423633,-0.5745127678230417,0.24223198868190451},
{0.5198389430706252,-0.5906625712087876,0.2515898589003588},
{0.5314023357020285,-0.5911015239621942,0.2527765375449846},
{0.5418930913355245,-0.5863096230708403,0.24275701060264557},
{0.5558050963705709,-0.5997299579874877,0.23604684314432187},
{0.5645109926464655,-0.6036364223198868,0.24796311936179713},
{0.5791545856038559,-0.5983775961957428,0.24484096031673455},
{0.5790577577906045,-0.6077440733309306,0.2496177991038048},
{0.600010220713621,-0.6077386940079722,0.253869615970134},
{0.6157167678875938,-0.6123692152105736,0.24480438092061735},
{0.6325002555178405,-0.6080711361668021,0.23980376229847714},
{0.6433783224043422,-0.6177065794499104,0.23270198012878102},
{0.6461852531240418,-0.6118893796026832,0.21099856372077008},
{0.6608449840503074,-0.6113891025675509,0.2102325481314922},
{0.6817458054729232,-0.613597852574275,0.2059420001398624},
{0.794971946830772,-0.6668606809147001,0.11554140195914943},
{0.7837366928998316,-0.6547335352372551,0.13557830411464414},
{0.674779582241779,-0.6081442949590364,0.18540804854301038},
{0.668700947298773,-0.6054148264899379,0.18689381754412393},
{0.6640919433880051,-0.6128512025476474,0.17804483127753543},
{0.6485790518405353,-0.6177173380958273,0.18978358983738308},
{0.6521390877744128,-0.6074826382351517,0.1983151960494252},
{0.6368220035826291,-0.6124348429506663,0.22743885054627025},
{0.6158340371280872,-0.6148469313652184,0.21457043416515598},
{0.5968945168561085,-0.6134257142396058,0.21909444477318085},
{0.6879126613124472,-0.6092879390199949,0.1911467102750448},
{0.6280999693378592,-0.6085176199723503,0.2350183165946734},
{0.6107139975362701,-0.6030425450652781,0.24173816683432225},
{0.5827565802568089,-0.611829131185549,0.2240939875307294},
{0.5918358015460174,-0.5968972065175877,0.24391571676788762},
{0.5375530535726774,-0.5843633840244867,0.22700850470959727},
{0.5305125956847071,-0.5977880223995008,0.21604759624953604},
{0.512398263554549,-0.5991608256184877,0.20342124940155032},
{0.49650774353539867,-0.5872735977449878,0.2207760211299806},
{0.5002818765230208,-0.5748043271273877,0.23581230466333505},
{0.4543456860519535,-0.5660155892779335,0.23513881342894183},
{0.5273452503267939,-0.5845312189007892,0.23248573134585285},
{0.5128081679639801,-0.599342646734482,0.2186931472804833},
{0.518836237271177,-0.5807108237357246,0.23795219933619155},
{0.45960989149905596,-0.5588750759829367,0.23748419823880965},
{0.43394406579987843,-0.5544328310838798,0.24991473773110917},
{0.4209174973237868,-0.5438323372620323,0.25897889691603415},
{0.41281516108382604,-0.5473687041748926,0.25396106446042704},
{0.3985352103584243,-0.5598734783240181,0.24658816441362694},
{0.39343130873548254,-0.5480776989408113,0.2542612306815064}
};


// normal array: 59kb.
const tgx::fVec3 skull_norm_array[5077] PROGMEM = {
{0.2971398876228087,-0.06542845339405869,-0.9525896307802043},
{0.3935367639920581,-0.17504176011210248,-0.9024905526394812},
{0.5634657089129104,0.009948599544781249,-0.8260795483767706},
{0.35402418430217353,0.06784843467693773,-0.9327719264863571},
{0.4700305654026611,0.1323100595930286,-0.8726770970512198},
{0.7021528187890876,-0.1478282421685665,-0.6965114714661133},
{0.8939489014882739,-0.34579774279975317,-0.285095216730313},
{0.7482394123623229,-0.18849394136997638,-0.6360878994718399},
{0.5327532440801133,-0.381425082244518,-0.7554395326939661},
{-0.027168525926562995,-0.23699599653100417,-0.9711306651667704},
{-0.07416424874289963,-0.318931298133042,-0.9448716797955022},
{0.0378284393333003,-0.7196359761208618,0.6933203235519505},
{-0.2532219158932341,-0.9268534707419388,-0.27716656559726305},
{-0.25591410962717354,-0.8288778383467656,-0.49746306153454684},
{-0.20685158075545748,-0.8721850910521528,-0.4432895109128079},
{0.43287314702762214,-0.4578697520763895,0.7765153757112014},
{-0.15508801504350084,-0.9742047874555352,-0.16392906907739802},
{-0.13652474007430251,-0.8377934203992937,-0.5286427717119534},
{-0.11316991726187668,-0.8334535285731758,-0.5408768672589561},
{0.2852009692360895,0.423156290861499,0.8599995120063346},
{0.14920854634940958,-0.5018856972509279,0.8519668752899058},
{-0.2244694057855052,-0.9081441665120207,0.3533944802858267},
{0.5104807900059891,0.10957775191093859,-0.8528787014112886},
{0.6382827678456172,0.07992768930435394,-0.7656413473381676},
{0.6425204437606298,0.10188901355520238,-0.7594643561526712},
{0.7441641193362192,0.0442207255985563,-0.6665315378285461},
{0.8896596428545036,-0.2926852161268865,-0.35048692434490997},
{0.7091457873892699,-0.6388510416052482,-0.29829783584186786},
{0.6112489536961729,-0.6252328529105929,-0.4852407611141244},
{0.9165475109747221,-0.3358061789759749,-0.21719776768557564},
{0.8496767260773274,-0.5268920998994764,-0.020836895786915506},
{0.8945014547672576,-0.4365187128154871,-0.09653269281010401},
{0.8734805066226874,-0.4260218365407812,-0.23566331776624386},
{0.7986133901473634,-0.5809157199294276,-0.15733270294573137},
{0.499512978565036,-0.7506638065089952,-0.4324241365170445},
{-0.3260956092888658,-0.6000955265675029,-0.73044302488024},
{-0.338665199931521,-0.23941016613427632,-0.9099388192108858},
{-0.31814982252230706,-0.04066203913016508,-0.9471680363076035},
{-0.29215974699431235,-0.30819453723502543,-0.9053501032499571},
{-0.40841329565727685,-0.7770682077674774,-0.4789191794106835},
{0.44041459168990116,0.7141249098850811,0.5441145104738913},
{0.15116050307271126,-0.8633339640264451,0.48146128491207857},
{0.06249082062553212,-0.9592698528917916,0.2754927343334265},
{0.7381229906660993,0.07293312399783172,-0.6707124645286163},
{0.8196588054888297,0.20873765569785988,-0.5334679312558408},
{0.9179854702219061,0.1237629401330964,-0.3768095156854157},
{0.9082373066612347,0.22134617165767864,-0.355120918957523},
{0.9278196800474844,0.10094351173774492,-0.3591114712100345},
{0.975747660212807,0.1414341369020418,-0.1670715071698554},
{0.971407146829391,-0.18689196774936684,0.14642249649405506},
{0.7914848752388989,-0.06882368181995789,-0.6073014021791896},
{0.6477627286926133,-0.027997158285379457,-0.7613275290206202},
{0.9426311778054715,-0.32457201259066953,-0.07809911185097944},
{0.9678273208513841,-0.18528832051897837,0.1702307706993315},
{0.792780869431022,-0.5801514716069435,-0.1868763309156365},
{0.9478673875068969,-0.0010834591753916207,-0.31866321064262443},
{0.8333057126789837,-0.5262957112956085,-0.16915795425702204},
{0.12034494106180106,0.6738105727502157,0.7290380012117735},
{0.03166253086286487,0.16991596023886216,0.9849497705951626},
{-0.0068805959751378895,0.03904223171583067,0.9992138717720418},
{0.043177540019486094,-0.2335919370931354,0.9713755746172241},
{0.8372537751459613,-0.31086846089635317,-0.44985210461191444},
{0.801600613109967,-0.25574042935160646,-0.5404010453883125},
{0.5615592869364816,0.13180758263864067,-0.816870815009539},
{0.7284002726002995,-0.07099540174071628,-0.6814636423225261},
{0.9150128465863786,0.09076751490149113,-0.3930810970022598},
{0.8501119701082918,0.31049283063531935,-0.4253279210240797},
{0.08270461561191271,0.9873929195208075,-0.13496358411313003},
{-0.13055051481671656,0.8169765930346532,0.5616990381998005},
{-0.04501302825835683,0.20995681330302335,0.9766739291261193},
{-0.03927287115505986,0.06306413217207973,0.9972364598351889},
{-0.023511510658867342,-0.05191006533628362,0.9983749566086485},
{-0.012777783977616418,-0.3080094155783133,0.9512974971856739},
{0.011537841770954904,-0.5292008555068048,0.8484181355547125},
{0.8624693534937258,0.20924658602977428,-0.46082803790459503},
{0.9951164888754039,0.09870751525739123,9.907018972265517e-17},
{-0.03234876212236672,0.9556606633713104,0.29268798074717267},
{-0.163197109317522,0.897779887883338,-0.4090940923828967},
{-0.03325236734200438,0.9730520503704088,0.22817534340085005},
{0.5134454200258058,-0.8573127118118792,0.03726546417644},
{-0.5676419370444202,-0.2566465760823686,0.7822500663430175},
{-0.15350591002279204,-0.11646624274142203,0.9812601846043539},
{-0.2675447390869318,0.1235547174532986,0.9555909398806276},
{-0.2430581270513063,-0.013903626989390547,0.9699120764434531},
{-0.117031837485918,-0.042266719805521914,0.9922283373354901},
{-0.07136366416072183,-0.09783146065614805,0.9926410392198383},
{-0.06013682515964564,-0.2381774214763912,0.9693580753047739},
{-0.003150051549378381,-0.535652794567265,0.8444324489546312},
{0.13714264807774013,-0.9827895530902656,-0.12376020529580994},
{0.02962276538052788,-0.6398490365771637,0.7679294903586432},
{0.7952672031267127,-0.2772175292237732,-0.539166502225502},
{0.5583831605113979,0.21948931150682086,-0.8000204298588656},
{0.5887861903935704,0.2721986367389543,-0.7610773444002135},
{0.6853538993202803,0.19468368588267654,-0.7017038514484742},
{0.6261569519038929,0.33785029954306117,-0.7026981191671783},
{0.22010837247260912,0.6054082682688312,-0.7648745865036922},
{0.28594387740601984,0.7229908496075094,-0.6289040708707669},
{0.3327885722538076,0.8530898334672808,-0.4018575645823274},
{0.42552736610488784,0.8876262657399532,-0.17619895874942829},
{0.9038574046007832,0.2788580522680849,-0.3244687640337448},
{0.6626095142100794,-0.7449502872722177,-0.07744482662723841},
{0.8866409570992845,-0.42654180516200035,-0.17868939991842522},
{0.8929380851762695,0.204254599568547,-0.401175316534841},
{0.93452541998871,0.2287725111551019,-0.27262681000722233},
{0.9942280482429865,0.0860930902011004,-0.06402005862670783},
{0.87420085827516,0.09951567420867985,-0.4752572881900555},
{0.9999939379008753,-0.0034819766656871624,0.0},
{0.9238954599699913,0.17918266410630962,0.33809873103962307},
{0.8455623367182553,0.1963960223001034,0.49644026543811},
{0.24445874864153536,0.8943533513315829,0.3746625190415781},
{-0.10556771387796186,0.9943097804626425,0.014265982718070046},
{0.015834614353841033,-0.055880793392338035,0.9983118760778658},
{0.11194619551024795,-0.07429602433375779,-0.9909329695186142},
{-0.04079258907557004,-0.09491773075292251,-0.9946489778133929},
{0.027228009920548125,-0.7479017038777135,0.6632508400391056},
{-0.512755597267504,-0.031081838730331768,0.8579718041823909},
{-0.0018375285437705314,0.08833409218353983,0.9960892086791026},
{0.01623458199835163,-0.003324292404828218,0.9998626842858703},
{0.21405004314495701,0.6228713956626244,0.7524717958135948},
{0.025107623287098688,-0.0008513787330760296,-0.9996843913991685},
{0.026427886223694488,0.0002769096133784381,-0.9996506840645955},
{-0.021057336622305658,0.11801226890016543,-0.9927888461115032},
{0.8720093071411091,0.14800995559451272,-0.4665756329944733},
{-0.26557873486039246,-0.8671991725450601,-0.4212285967584783},
{0.11264768286245529,-0.6413305761940421,-0.7589503222111034},
{0.48190173204670717,-0.7866210129342668,0.38600272364408483},
{-0.11812768418204905,-0.7457846673459984,0.6556302923000161},
{-0.25302466382264605,-0.9575154606444686,0.13835700966791664},
{0.9392654119947796,-0.3431535750235414,0.005109772875534398},
{0.25106802614790624,-0.713692869176958,-0.6539169173007804},
{0.9856812219401662,-0.15097450537054494,0.0750947897171317},
{0.9997554342979424,-0.0013593398783296236,-0.022073146282935028},
{0.9627176024365323,0.16201041320825943,0.2166274312522402},
{0.8799280713518854,0.24783711301100717,0.40534350205883457},
{0.9082373066612347,0.22134617165767864,0.355120918957523},
{0.0987477027183918,0.7712132277791087,-0.628871249546653},
{-0.08345682838089342,0.5201300221169464,-0.8499998340524704},
{-0.6672241235215712,-0.17173301984170278,-0.7247894445195241},
{0.6133197179449418,-0.7887679741193799,-0.041036649272890864},
{0.26365776047733186,-0.9505308382014793,0.16424284145152498},
{-0.1546601339431654,-0.9231106917192741,0.3520609234241218},
{-0.35591408375865285,-0.8660442567949822,0.35113033229082546},
{-0.3639602833689467,-0.7417115501754111,0.5633798793588431},
{-0.4680385752841148,-0.883708030451002,-9.467009388124944e-05},
{-0.11576632631417856,-0.9489236275712458,-0.29349975592621325},
{0.005867830498011277,-0.9635604326465688,-0.267426365946224},
{0.23275154458845515,-0.9339422953924837,-0.27125358498775054},
{0.6663221303869413,-0.7175863363040192,0.20269353345971056},
{0.7986271159087294,-0.6013962484599629,-0.022743835947074225},
{0.057754407580123374,-0.36203289730176347,0.9303744459497799},
{-0.277859983542151,-0.03637603886245999,0.9599326087505479},
{-0.2523960933476084,-0.049933215318025685,0.9663347691513894},
{-0.18244587257907577,-0.03728459927279013,0.9825087084784171},
{-0.09432142113822277,-0.09399095780317669,0.9910949345878564},
{-0.13408530938042929,-0.10697764546963622,0.9851786199355563},
{-0.19146378283306284,-0.23531645779553517,0.9528734357477996},
{0.1369837570682932,-0.6265392947088942,0.7672574290843563},
{0.17348973303342116,-0.9783581142195135,-0.11276840369903983},
{0.1108412580471364,-0.5763783525390749,-0.8096309098835531},
{0.3012056342913339,-0.9535592094207656,7.021733418713569e-17},
{0.3109858720931383,-0.9504141224819429,-0.0008849549979877234},
{0.06899083911734717,-0.79718809515009,0.5997761291255725},
{0.6787337948942768,-0.7008566643254005,0.21936356064553306},
{0.8619483439669028,-0.07711696754952795,-0.5010968226287997},
{0.7178562392193591,0.3190445240501179,-0.6187834932247885},
{0.6738952133236149,0.3573681947782693,-0.6466476744104478},
{0.8546388309756833,0.3094850068850098,-0.4169070629071938},
{0.612532208724435,0.24192637471103381,-0.7525130713112841},
{0.6269410361044663,0.2706279144060575,-0.7305514829171768},
{-0.04194782094055195,0.3141440130551272,-0.9484481637812154},
{0.17420020427938443,0.7606221856590994,-0.6253864241508565},
{0.218439093420419,0.8106326607002251,-0.5432854239455895},
{0.1874909884289189,0.8900747594086806,-0.4154684728370207},
{0.13847499470459834,0.97103467481419,-0.19472117540232156},
{0.27088501289278927,0.9571961029452428,0.10196533870150955},
{0.5178846584050022,0.8515423692554088,0.08167664263189969},
{0.8616976634103226,0.2926926565760634,-0.41449746158406964},
{0.8310226279404191,-0.43483779473292894,-0.3468681076761059},
{0.7855412400292784,-0.05613345156813207,-0.6162580594428861},
{0.8787778816793327,-0.3679053245673595,-0.3039656342848163},
{0.7925517821952682,-0.5759401846606597,-0.20038606795920058},
{-0.21641459222289505,-0.9041809393837683,0.36826831675842564},
{0.9540893822006503,-0.02562135167570853,-0.29842418988797004},
{0.8387481859582914,0.4135962178400166,-0.35417460261869255},
{0.7867216641012661,0.455723416270794,-0.4163954743944888},
{0.8495249392899467,0.41584314292133734,-0.3246257198832475},
{0.988001728478276,0.15443607660486705,-0.001443179418604622},
{0.8210085635118667,0.07668399219641517,-0.5657424360793533},
{0.6342318697366806,0.1589399435935838,-0.7566293873097865},
{0.49633444532958443,-0.07998465924738488,-0.8644388773444038},
{0.3217357309979908,0.16110397005354266,-0.9330228455038899},
{0.3226701679471443,0.7445329133681214,-0.5844268163153871},
{0.26680859500711684,0.8570913543137335,-0.44068989549452847},
{0.3331955561471544,0.7945408913768032,-0.507627317324377},
{0.3522437572063886,0.8549357526602559,-0.3808007278516792},
{0.24869061993306724,0.9311411530485334,-0.26670044742511106},
{0.37994134441378635,0.9241425564675998,-0.040063825710651216},
{0.38056073448839084,0.8798532880584751,0.2846607083149105},
{0.5572160151311839,0.8280921580559264,-0.061430369098704855},
{0.7034171877402333,0.2586559648010322,-0.6620433157010716},
{0.9956251540142871,-0.0882760210971965,-0.030625100706356063},
{0.9073765089071837,0.41838210897040046,0.040302381776906766},
{0.8535079589364036,0.52089921977748,-0.013717392880090636},
{0.8946849782785291,0.44311344545660486,0.05647356990951217},
{0.9129048418294937,0.40389701398371225,-0.058923270948821736},
{0.9967787486480275,-0.07772086384760565,-0.019788723214355045},
{0.9550328752818042,-0.2945483619907709,-0.03396276754805702},
{0.9144011514702061,-0.3315712700095311,-0.23223054728917167},
{0.7079306587858593,-0.12458946119860152,-0.6952061913628655},
{0.74128513327515,-0.5198901784488456,-0.4245121359132984},
{0.5062503767426532,-0.49515218700721486,-0.7060700161810398},
{0.31148168507580676,-0.03214454688658921,-0.94970831731},
{0.38359355560242314,0.19608204089312462,-0.90244546502239},
{0.8592408486773068,0.24854839276252816,0.44713405195697803},
{0.469659527602239,0.882661398776404,0.018132381049478136},
{0.9666770596845896,-0.25433522257275665,0.02913857989715305},
{0.9863528990711508,-0.16302029363532936,-0.023072545524659517},
{0.9453815066427409,-0.2740748048297343,-0.17645625025893602},
{0.9882077649256844,-0.15209187257568133,0.017705243206626628},
{0.9936106555323326,0.10739230185450094,0.03470963432535134},
{0.995704087167693,0.08703798269750256,-0.03158734502139491},
{0.9757604398606472,0.06417962923431936,-0.20921887867566227},
{0.9293666351715767,-0.23951086568707977,-0.28091315855204635},
{0.7760561628658115,-0.5134274443660092,-0.36623638739178},
{0.6772611561456515,-0.6343999791930346,-0.37263117526064915},
{0.3036755374747762,-0.6515411868696921,-0.6951800124801049},
{0.18320918226817345,-0.11217320094908449,-0.9766532488664866},
{0.26168454578330647,0.23521955879689785,-0.9360517921875782},
{0.8564645042636239,-0.020529877902790743,0.5157975155521413},
{0.8031091471895252,-0.12893966119049802,0.5817132123930081},
{0.7086024991438044,0.49147172597063243,0.5062983712975998},
{0.18770563433963,-0.7897293934229831,-0.5840326018305181},
{0.16220903136220147,-0.45668260229729085,-0.8747166574974496},
{0.13783802094020428,0.022522147483867213,-0.9901986835256866},
{0.4748769874494405,-0.3033621598620326,-0.8261133377175232},
{0.7803336090931063,-0.01619931280615535,0.6251536137497212},
{0.7121759433742219,-0.1525219276000441,0.6852317033531096},
{0.8229634173421368,-0.5666112647607038,0.0410230223512027},
{0.937373225862802,-0.34773824839801326,-0.020237243800621},
{0.9200787182729981,0.3583637581417237,0.15821052124197385},
{0.8775477852151806,-0.4240518953436406,-0.2238076735042777},
{0.11627876732200984,-0.9808625607034851,-0.15616621043066867},
{0.12695068934298814,-0.6818188954454862,-0.7204210687430215},
{0.9423507357441063,-0.17504929998963392,-0.28518911868386676},
{0.9370755728060628,-0.27752722000266733,-0.21182070958190166},
{0.07246307230800533,-0.9890202002731172,0.12879497895262781},
{0.04224682240807735,-0.9253284932498809,-0.3768055009900012},
{0.20495627027018373,-0.514680357269185,-0.832524508418941},
{0.49008882236610657,-0.8442455388981545,0.21693873845481731},
{0.5904450466977145,-0.646748683866559,0.48279476669388993},
{0.499124773653389,-0.45967533034673236,0.7345563633895466},
{0.4724528417700641,-0.7673542100774884,0.4335387278891523},
{0.7016372922402037,-0.119785890588634,-0.702393373084999},
{0.7657319082648055,-0.3660424197322059,-0.5288360725420789},
{0.9565987790952148,-0.21494758177806703,-0.19676461298034661},
{0.7825668436214689,0.26339041902772065,-0.5641051519253597},
{0.6701845736396935,0.12092040850272123,-0.732277878993294},
{0.6452595028798688,-0.17573851917887368,-0.7434757203971367},
{0.6185733570652037,-0.5192040190064946,-0.5897407808322124},
{0.24435608390323144,-0.9454406641748275,-0.2154809847391137},
{-0.755613012547276,-0.5866707931663175,-0.2913183065219796},
{-0.6735407240322041,-0.2868730776181158,-0.6812097550740777},
{-0.5536536896597278,-0.04944103503137615,-0.8312780377113279},
{-0.3414425039264666,-0.059541757765631524,-0.9380148162980176},
{-0.28479776667074613,-0.442896759107508,-0.8501368671404748},
{-0.09365379737458789,-0.5964372080490683,-0.7971772846060982},
{-0.42413629826238153,0.6809008031779392,-0.5970615518754506},
{-0.4479384618328705,0.3117906255574644,-0.8379365967812166},
{-0.38561204075151945,-0.33097512235550647,-0.8612542147410404},
{-0.4145790219430596,-0.6487053032738472,-0.638205032939354},
{-0.3363256581558327,-0.7925571798798527,-0.5086631186619891},
{0.9070568265724976,0.04415237638728644,-0.41868661434011173},
{0.8706296574209976,-0.026705159171065213,-0.49121363386274663},
{-0.1304269458207665,-0.8412746741780595,0.5246386703155483},
{0.2289897721482412,-0.9349579539823051,0.27095628528734766},
{0.3522656613347084,-0.9316942702297604,0.08862669273675174},
{0.2759611018819103,-0.9298779691166328,0.2432538443676659},
{0.6116351603784101,0.15705651224862985,-0.7753938886457465},
{0.2550141606150991,0.14420053617363598,-0.9561244601269294},
{0.7413425804085498,-0.20506940644481123,-0.6390287294117265},
{0.9130674017656245,-0.05842729937505758,-0.403601499651214},
{0.6244548349067003,0.06339197480740374,-0.7784841788319549},
{0.5456966723868992,0.03591917542438092,-0.8372126101431451},
{0.5498492146436571,-0.18142460745991792,-0.8153226066801829},
{0.5287591785997978,-0.5303235509080962,-0.6626995264814176},
{0.2615365651950505,-0.9505555100710639,-0.1674599872790953},
{-0.7112673348081309,-0.6839597363869161,0.16216614146139965},
{-0.9345125164289718,-0.21573146168375557,-0.28310120642162745},
{-0.7746349046817734,-0.04080934839209526,-0.6310906127748},
{-0.6762559479662472,0.12341009743896146,-0.726256043479418},
{-0.7300424862675721,0.09013886841172679,-0.6774311423648277},
{-0.7074637873640073,0.06292780081435773,-0.7039425270952475},
{-0.6012828410582345,0.047808298319149053,-0.7976047339758994},
{-0.259918274189359,-0.2932572074753723,-0.9200232067758789},
{0.2666610007997767,-0.38294395982418666,-0.8844466260247892},
{-0.2204031541328073,0.32997191705064893,0.9179003124556772},
{0.6155879568442866,-0.35270731821592455,-0.7047332935694235},
{0.3562232056515917,0.4547070192523359,-0.816300529460786},
{-0.1571359642447012,-0.983967535822341,-0.08435743706750476},
{-0.7957517850235429,-0.13097030263217385,0.5912917016670215},
{-0.9997530656426956,-0.02012827005844995,-0.00941596954573717},
{-0.9105606691698108,0.037692751714251134,-0.4116534030337101},
{-0.7690382167166505,0.16099190035754238,-0.6185966612006093},
{-0.7909941338520067,0.2354557881789678,-0.5647024455629129},
{-0.7836243688836066,0.21809310675823582,-0.5816942885023971},
{-0.9356992843633786,0.13999897224534177,-0.3238319579845525},
{-0.8476975612586508,0.12716529015837486,-0.5150124596697369},
{-0.7182866990470713,0.21428049063394441,-0.6619275559347397},
{-0.504521004010893,0.1209061261308915,-0.8548919611131347},
{0.003985917552944982,0.3453142929396893,-0.9384786367056117},
{-0.2598111318689943,0.7213218304497492,-0.6420225795667746},
{0.5512428847140725,0.15278557255631284,-0.8202364603397897},
{0.3781693419885915,-0.025178310768211087,-0.9253939709371222},
{0.14083753775860092,-0.47721092529181836,-0.8674298362059154},
{0.31171058724168893,-0.5001414517719215,-0.8078954375542148},
{-0.5092962659368314,-0.8475932042366617,-0.14900695834298763},
{-0.6989667176850382,0.04590702339745832,0.7136792506241088},
{-0.9713788962168125,0.09198172086530369,0.21900320319863884},
{-0.910741199607997,-0.22750760299629225,-0.34466035152809216},
{-0.8312812414381796,-0.28444898333506097,-0.4775565657727354},
{-0.8022854545728052,-0.031542000553611324,-0.596106661246109},
{-0.8209814311037452,0.11794744763792775,-0.5586393195779766},
{-0.9291726985698878,0.21556897726659063,-0.3002800564016676},
{-0.6653593519147609,0.34444482450820463,-0.6623101204791314},
{-0.6039630900915367,0.3445922462841548,-0.7186687481781316},
{-0.40003978182594147,0.31968507366934684,-0.8589351702134902},
{-0.3368226380327852,0.046151234301991924,-0.940436374286447},
{-0.12770775442516066,-0.8413029837315551,-0.5252618575758815},
{0.46788548441176747,-0.4889643197138622,0.736204501156795},
{0.2770242295066731,0.9209978027073913,0.27389892967003615},
{-0.6784066004665015,0.4845859290732701,-0.5522145975865544},
{0.7890610519432943,0.1785066358243181,-0.5878078234192077},
{0.6952188721342285,0.193403924987219,-0.6922901426627056},
{0.4050612132530527,0.12802134055588657,-0.9052822487380598},
{0.0911579726940699,-0.061739138438197026,-0.9939207728985325},
{-0.36907282958487164,0.18916016307437675,-0.9099470749268287},
{-0.7610525297068894,0.2120800943614491,-0.6130424786280173},
{-0.7064820959831527,0.1615781181537256,-0.6890395923233672},
{-0.4126104548550318,0.31133862890499975,-0.8560495725691817},
{-0.48432427029008784,0.6883703108768738,-0.5399780702132727},
{-0.3123115847346992,0.9401898638724073,-0.13603122403361984},
{-0.10046155176726093,0.9351897318029504,0.3395992375533841},
{0.354263390741616,0.6774936969260071,-0.6445926935715179},
{0.21171913838389889,0.49660393450820417,-0.8417597867996254},
{-0.08333247367048181,0.7741483627024786,-0.6274950289500549},
{-0.03891707382759091,-0.4031194438932003,-0.914319514896152},
{-0.5103310820866692,-0.8423948811759661,-0.17301170718994516},
{-0.6982036939578413,-0.6870540851995115,0.20116730786658002},
{0.8018758453670443,0.13458579315171984,-0.5821355451255407},
{0.7179309768552335,0.10667238993472257,-0.6878925160933972},
{0.6349377180428382,0.11273819157402419,-0.764293264635488},
{0.45781425168912515,-0.01013374211510395,-0.8889901114304202},
{0.3452899242605351,-0.18341569915993616,-0.9203985818686521},
{0.042944784586611724,-0.32167905340297265,-0.9458743743640468},
{-0.8424756580408883,0.06082078118676201,-0.5352901999704499},
{-0.8766074557129929,-0.00037859255551098717,-0.4812060112426591},
{-0.999201942582339,0.03153943989094423,0.024510032049055986},
{-0.9089316339812098,0.28824154640259075,0.301264162614293},
{-0.611445438438715,0.17191564193053205,0.7723855823823362},
{-0.478844776336781,0.16550740746959605,0.8621571656302992},
{-0.31543575312455424,0.49293988774147013,0.8108702440737187},
{-0.23589016748358882,0.5696683364550419,0.7872952529547664},
{-0.133634899342196,0.7287090465846854,-0.6716582755415437},
{0.05014448313905149,-0.5970625896112508,-0.8006258769846403},
{-0.05933268174102013,-0.9663846322393167,-0.250160699249701},
{-0.26219995158557874,-0.16709413572682397,0.9504371284804828},
{-0.482483815916285,0.018173594500323166,0.875716328408805},
{-0.883145135806912,0.06625868370445553,0.464396873303798},
{-0.8726657373099369,-0.3015598189182214,-0.3840783598945845},
{-0.5734467342036028,-0.7053622702884444,-0.41668082591445704},
{-0.4003048342680722,-0.8951096474514774,-0.19630272209244323},
{-0.40587156884545145,-0.4818051327047436,-0.7766157889859673},
{-0.3831053528254586,0.23262918011341144,-0.8939317385551555},
{-0.5187692089380602,0.31860642007928425,-0.7933274588352794},
{0.15284456223579704,0.37705869951781706,-0.9134907098120265},
{0.0262314423106359,0.198499419815895,-0.9797499128691244},
{-0.2002783071035686,0.17574085798358044,-0.9638484064099102},
{-0.790393650727684,0.3305012389483299,-0.5157972546873266},
{-0.9398947042946897,0.2658107897603329,-0.21434217710424155},
{-0.762351234242456,-0.5135072269019566,0.39386663170223774},
{-0.1913949234293598,-0.9715388529144077,0.13957163237286596},
{0.3388049105733891,-0.9405521936709442,-0.023933314691709267},
{-0.5442325204470858,0.6288561974116437,0.5552934779598805},
{-0.4654717072354439,-0.3513225368767066,-0.8123475640671525},
{0.3822394647842824,-0.9002351273824064,0.2084939015611915},
{0.1376933616583944,-0.9520115037852556,-0.27333977905849527},
{-0.4382664201461826,0.05053630508365967,-0.8974233264411735},
{0.45123792919789385,0.23606894980511106,-0.8606136079513899},
{0.30106275382726927,0.27861737290499,-0.9119942860421126},
{0.08616461308451183,0.1836922515334466,-0.9792000899604582},
{-0.8567426110173988,-0.46633233832315896,-0.22028674200038623},
{-0.881964262406731,-0.35759259977304475,0.30702861825065414},
{-0.9350355920195649,-0.31601468582266645,0.16075807911586626},
{-0.8888814002100955,0.29773629724816114,-0.34819958883016316},
{-0.5434090851400636,0.2294412120073528,-0.8075043630964702},
{-0.5454847592298915,-0.7877453655488929,-0.28618807889943376},
{-0.22147977688072693,-0.6655739111127842,0.7127117771433942},
{0.08974775049819624,-0.991825366727883,-0.09070712869236756},
{0.2650160546606254,-0.5690892589238691,0.7783982953151927},
{-0.47681394671234417,0.2523715343769102,0.841995884109205},
{-0.6475014798567509,0.40072527777148226,0.6481983379632238},
{-0.8448181836706352,0.5045854589538439,0.17797682756973643},
{-0.64442274903204,-0.21704140321359808,-0.7332205328692458},
{0.37515175930999045,-0.42429429121823414,-0.8241574557851401},
{0.3834419102630067,-0.46300136411159376,-0.7991257962828254},
{0.41711534281658896,-0.8744720512503925,-0.24761547279790547},
{0.7882063867186339,-0.5747630162248519,0.2199503742121523},
{0.4013101873170054,-0.32910809081191617,-0.8547736531490226},
{0.6662610415481318,0.0837791624941102,-0.7409974874768365},
{0.45177605401526255,0.1078809266701323,-0.8855846106833565},
{0.2852354954453785,0.12615667462265526,-0.9501185218625006},
{-0.5384515566900226,-0.04521095314070087,0.8414427436339329},
{-0.2500756102527332,0.07258402617403915,-0.9655018116508584},
{-0.47390979709436154,-0.10848178574007573,0.8738656683842347},
{-0.8112099220901623,-0.04647884266264896,0.5829049489301096},
{-0.9931055261397914,0.01846833815672152,0.11575981356384851},
{-0.38496919144947556,0.14208484620042203,-0.9119268710345909},
{-0.2223619540379284,-0.010059351877902748,-0.9749122887912691},
{-0.466952189025719,-0.16559723662693107,-0.8686387099281342},
{-0.22421193810870607,-0.11027864077086524,0.9682807589740013},
{-0.09327254449962531,-0.3503683850408112,0.9319561294430437},
{0.6580973182737414,-0.7045026767164464,0.2656763033849126},
{0.5691189034813441,-0.5114412030333211,0.6438412611350888},
{-0.3763618185506668,-0.21023210937035094,0.9023049604911455},
{-0.015865101556936417,-0.3256734949105797,0.9453491806022348},
{-0.6400734699137333,0.7075447735015723,-0.2994767880874945},
{-0.30389219167573195,-0.33103595937985775,-0.8933446868012243},
{0.36095290030387034,-0.5449303203361265,-0.7568117003195648},
{0.5581570144915916,-0.4168048815317661,-0.7174499549830103},
{0.6433981461015573,-0.40696165348197544,-0.6483988264859025},
{0.614535289476816,-0.4150685867984597,-0.6708684269219826},
{0.5841805313230317,-0.42485061175189376,-0.6915454175375484},
{0.7999323456876454,-0.5221716116314432,-0.2957110926713481},
{0.8964919821241584,-0.44179649764382717,0.033436217739833164},
{0.872214888570337,-0.465333941825636,-0.15068347866056953},
{0.7784470719552261,-0.27344132127129595,-0.5650221234480497},
{0.5083844489990669,-0.05038811303378221,-0.8596547505137222},
{-0.06996893417232977,0.04351715717644387,-0.9965995210123617},
{-0.5020887153226784,-0.31011058608266096,0.8073031316333977},
{-0.9007143520512382,-0.33017533954543804,0.28230816701784023},
{-0.44800483271349884,-0.19264131805250573,-0.8730297775244229},
{-0.2048575353640978,-0.05940398378072029,-0.9769874906648126},
{-0.9992518910100825,-0.028788070157973338,0.02582451024421732},
{-0.5051707136964653,-0.15483734126153115,-0.849015870154654},
{0.3282739778873141,-0.40122380886728276,-0.8551348727774288},
{0.43538491646610306,-0.40694630544249444,-0.8030159892558232},
{0.45507774000230317,-0.38739043503758214,-0.8017686083876002},
{0.4823396494694269,-0.2915553178084038,-0.8260411365103745},
{0.5823891233163224,-0.1953432098087569,-0.7890905774525871},
{0.6568541828579179,-0.37343352921349293,-0.6550496024891644},
{0.6903700154185015,-0.40229523913140897,-0.6012884352648573},
{0.02792134903643418,-0.7069652648589754,-0.7066969028875564},
{0.6014494834824603,-0.5854903089906985,-0.5435619715328308},
{0.472640761098155,-0.872554824355235,0.1235264726403279},
{0.6377851861368278,-0.7455033353014885,0.19353251251086565},
{0.4837391012927075,-0.8583828262850283,-0.17080809529835148},
{0.47196343366164023,-0.3043710955868124,-0.8274108734223875},
{0.1738705216437078,-0.22340651194599978,-0.959092577451972},
{-0.2768884369206954,-0.6147889100387713,0.7384899387215467},
{-0.4921964360652749,-0.7449790077456984,0.4502765220871241},
{-0.28170798587510515,-0.47389889123127,-0.8343023741929328},
{-0.07039779193789684,-0.1453646391647215,-0.9868704436605541},
{-0.5309275754984525,-0.27113990347604494,-0.8028692685103447},
{-0.4378004318594903,-0.20054559141743217,0.8764201319154392},
{0.37303431003000775,-0.2889529151669687,-0.8816754597679048},
{0.41755479971483905,-0.31087265283541127,-0.8538185890188704},
{0.4002547286120053,-0.2947065366899011,-0.8677235789443397},
{0.3902057576650582,-0.2616748126006218,-0.8827603067285409},
{0.36965228059092653,-0.2091561834043535,-0.9053236340655486},
{0.4498042969020858,-0.223447451962581,-0.8647238464965854},
{0.4504837134822755,-0.2502022701744191,-0.8570083126124192},
{0.5232186092731154,-0.3172617038420641,-0.7909407678110527},
{0.6657885717795109,-0.41837308904045356,-0.6178102751286577},
{0.3097361907932816,-0.7481509835260237,-0.5867994529325256},
{-0.8026996968875588,-0.5959211617697027,-0.023476915718830402},
{-0.5695173954959949,-0.8115901857721411,-0.13027396741406227},
{-0.24218158105743484,-0.9450596837597517,-0.21956838553953795},
{0.016800055460899428,-0.9998584604267187,0.000904018596371229},
{0.19595840081095134,-0.6658850648822524,-0.7198592817477406},
{0.246151670661119,-0.25964654271070314,-0.9338056692316228},
{0.17223577433377824,-0.1627719035018128,-0.9715143568007836},
{-0.6104144072376264,-0.7375323913974685,0.28886021373022014},
{-0.4369005132259454,-0.46873834850258567,0.7677254080633088},
{-0.6929581117198848,-0.44710830334380963,-0.565599876664265},
{-0.15400800230328449,-0.7371564348773322,-0.6579376305893235},
{-0.31322116616044066,-0.6641386907037347,-0.6788315701110421},
{-0.7638242955682686,-0.5597984137601033,-0.32124473762430833},
{-0.573248535535048,-0.17312428608920755,0.8008833236327404},
{-0.08861159214364107,-0.6685347558459734,-0.7383828722036647},
{0.07644618094586782,-0.8954982606234192,-0.438450506487588},
{-0.1367768577088837,-0.7967304303032533,-0.5886533042666767},
{0.49046209933406043,-0.8564803733386704,0.16089841267855312},
{0.23604078226182892,-0.07471229214562035,0.9688667723229913},
{0.39734970489954574,0.8232259070875982,0.4054778883195051},
{0.3142019406612988,0.8905832870229871,0.3288442630790534},
{0.30191662999267566,0.9168820991015234,0.26110067958749134},
{0.2572144881776804,0.5326463069451647,-0.8063055368588083},
{-0.3247689314208603,-0.4570804915660908,-0.8280112109225656},
{0.34881411853251715,-0.3230028037113049,-0.8797715041458317},
{0.39254818361805927,-0.36314680847924424,-0.8450031473488732},
{0.41629374015707743,-0.3083587215653358,-0.8553446210391595},
{0.4187960504516143,-0.42489864594919724,-0.8025403471456545},
{0.5391535070292153,-0.4317392080799463,-0.723128447832471},
{0.3320694365076854,-0.32032254921359704,-0.8871997259934039},
{0.5764743021661887,0.13637583411090345,-0.8056543991145093},
{0.6029735436176247,0.17518655231434288,-0.7782882355435027},
{0.7263358636730411,0.49159588229581036,-0.4803849515254836},
{0.5751373726763827,-0.26400361346150536,-0.7742861839334185},
{0.486143326568835,-0.621416571049406,-0.6144152596231524},
{0.6745058873353474,-0.48293525201993764,-0.5584042892979915},
{0.6015407520776149,-0.5872091143508531,-0.5416033415823652},
{0.5197465608326998,0.847932325225249,-0.10427983669283006},
{0.32281631729484167,0.08942993736482586,-0.9422271019192344},
{-0.2660439937640907,-0.6048117554219637,-0.7506153035246851},
{-0.3765972879014835,-0.5709743108902626,-0.7294949068010256},
{-0.5680121736769819,-0.8132584073212799,-0.1263840712906715},
{-0.5572818563616128,-0.8165586170382246,-0.15056213837076307},
{0.4155432761934472,-0.001463710286798428,-0.9095722308660333},
{0.29597299328604876,-0.12090418963667031,-0.947513674926962},
{0.1584964851221934,-0.22024440011443544,-0.962481827580211},
{0.35929259520214046,-0.5311534581371098,-0.7673231620001448},
{-0.10532365544496047,-0.8034280872352902,-0.5860121468409627},
{-0.26271143725240886,-0.9118560625744749,-0.31543814272048487},
{-0.3589743095363498,-0.9263037434870219,-0.11445007599311711},
{-0.3930132481352245,-0.8555489771557193,0.33701117856534524},
{-0.5151074607988381,-0.7448617850482192,0.42408162540265026},
{-0.43617509436476165,-0.8088350878876834,0.3943819058445948},
{-0.14019791159019715,-0.9892407251501669,-0.04180111589561947},
{0.8031918474959652,-0.5818841516957389,0.12764673956411246},
{0.9091782388575222,-0.051006776834930004,0.4132713862643356},
{0.3542346262877163,-0.24320386038337863,-0.9029782454928935},
{0.2801612215726287,-0.24051933537955167,-0.9293331691247821},
{0.19060502108808194,-0.20049050107436067,-0.9609751739326899},
{0.20217519839139184,-0.09674731304640079,-0.9745589497684084},
{0.31153743086339764,-0.22618203818267263,-0.9229225941402485},
{0.2807745580401512,-0.28705013318129385,-0.9158427095292941},
{0.2018142126165766,-0.15789714587714468,-0.9666123912457376},
{0.10143653843813638,-0.15000404966130496,-0.983468054262515},
{-0.005590834947174295,-0.11886424306041354,-0.9928947750322127},
{-0.07119005069589508,-0.0719913302881113,-0.994861409968878},
{-0.01627162129887613,-0.11102927330438847,-0.9936839209777955},
{-0.1215432881101565,-0.27749737218414977,-0.9530070501031264},
{0.12330407167820999,-0.37080805441375264,-0.9204876385315897},
{0.5894428459261511,-0.504586021697366,-0.6308328448123995},
{0.3717604655547688,-0.6494198627204428,-0.6633611370548192},
{0.469526791543942,-0.8135298886889135,-0.3430943197318422},
{0.20610200160503475,-0.9607314101496008,-0.18578784267641907},
{-0.06458211563109881,-0.9967609600903569,0.04792430260693806},
{-0.591955450146668,-0.7389517063727563,-0.32177495348526974},
{0.5618266674247699,-0.8271409137548406,0.013736977949473459},
{-0.012907285164733514,-0.9883258170926745,0.15180738209248507},
{0.2969458981996913,-0.9256780998401896,0.2343996352783737},
{0.23023432519443673,-0.7819545154491171,0.5792575344965301},
{-0.4262506432015874,-0.8989066192731648,0.10137691550408591},
{-0.5761164341936961,-0.7663424713810472,-0.2842693631215462},
{0.24882196171616577,-0.8988818744030206,0.36069239975002404},
{0.7262721175638819,-0.6454217015912367,-0.23655789643203062},
{0.8925585716923977,0.03109890249569687,-0.44985781571735545},
{0.6516442818425794,-0.7505722727966245,-0.10954904495603059},
{-0.2140023712745035,-0.9768304692631611,0.0022846023728635492},
{-0.7894042191893048,-0.3304824835494913,-0.5173222465669577},
{0.4499656668994678,-0.86652582158384,-0.21601828427280959},
{0.9466253314954614,-0.32195216816405237,-0.01572524039796509},
{0.8437533235820122,-0.47734874809279176,0.24539458355585755},
{0.8689293061265589,-0.4707150735443866,0.1529352166524098},
{0.42920070496710394,-0.9024100564376646,-0.03798479822128799},
{-0.20576292854657321,-0.9259246852627905,-0.31674136840163486},
{-0.24104576538270048,-0.9642729266995902,0.10988476612012602},
{-0.009455647388902573,-0.9946906004227881,-0.10247536368810727},
{0.7358072823453092,-0.5936482958622364,-0.32583637621891326},
{0.6804718065293945,-0.2853856524915543,-0.674917142966892},
{0.6077568723958171,-0.7132909598211917,-0.34906674246197905},
{0.1765292801618625,-0.9598798451404393,-0.2178717424052534},
{0.5710826857274821,-0.7344838501093095,-0.36660338240514273},
{0.1045725617984637,-0.9855064878048735,-0.13357223444042945},
{0.9321227142501796,-0.0687201729842158,-0.35556262936914174},
{0.9259120360746684,0.030001641081678573,-0.3765458843015922},
{0.5384172512260121,-0.35917489794283586,-0.7622993219661021},
{0.06395214126273063,0.2320104117751121,-0.9706087226353649},
{-0.44039658388114367,-0.30230357624713006,-0.8453776651260752},
{0.8558470518341935,-0.4384676640091558,-0.27435730623599835},
{0.9519131903807202,-0.30064329359421477,-0.058948180599756206},
{0.8376071996032591,-0.14716317252821476,0.5260771614736918},
{0.9552137041087477,0.28353440940382113,0.08470547896607405},
{0.978604482126081,-0.20529514858682113,-0.013680991537897882},
{0.8055267557904761,-0.461772520876654,-0.37133917739566763},
{0.6186486982278905,-0.6665408572539656,-0.415929169200821},
{0.21100202367261517,-0.8318217188503628,-0.5133719646171663},
{-0.17759685386547275,-0.8283696437010329,-0.5312843785504233},
{-0.4486689675691445,-0.8736588995475987,-0.18819214856554672},
{-0.5165990355930911,-0.7883355343724017,-0.33414446227652506},
{0.33121383069191046,-0.9429227418713316,-0.03455576970985374},
{-0.3086265663031493,-0.3215300751413686,-0.8951916294020591},
{-0.2086276949986367,-0.25623452535885793,-0.9438317397151235},
{-0.21624669100992372,-0.2613062915610138,-0.9407212077007135},
{0.23371006895795676,-0.181932290015818,-0.9551336270476857},
{0.6909960586314823,-0.11732586628076282,-0.713273501580723},
{0.8286697871259212,-0.05391928622886421,-0.5571347184274648},
{0.8271379605454031,0.15902918158032137,-0.5390292326309256},
{-0.31889294066469037,-0.3390739772830238,-0.8850627832666434},
{-0.3328779471361185,-0.29889124810761325,-0.8943468533601024},
{-0.3380292198490651,-0.32227649088917354,-0.8842364559032798},
{-0.2884450279681733,-0.26870767397152595,-0.9190188527931579},
{-0.2945640734193761,-0.37054122982745197,-0.8808695724388167},
{-0.28057481148237495,-0.28977215562642944,-0.9150463775051197},
{-0.22617798609105044,-0.20409525586209956,-0.9524645112246339},
{-0.3281706411873792,-0.20715581129539812,-0.9216238387266303},
{-0.346642472677688,-0.2626857338569308,-0.9004638812100928},
{-0.3001837504691535,-0.363283123084537,-0.881994948078626},
{-0.3150012471593104,-0.4053289261311357,-0.8581856884902354},
{-0.19620532232162735,-0.3402750316552704,-0.919628389255503},
{0.2814052258831572,-0.21685415250567183,-0.9347648770609088},
{0.720429385537195,-0.13874586603369685,-0.6795079728105177},
{0.8827758201817812,-0.21703195917339754,-0.416658109245146},
{0.8726606435302259,-0.1074066606005363,-0.4763687757316313},
{0.8990763734715513,-0.36475614712070825,-0.24210458030136478},
{0.7609830758289625,-0.46373697007089226,-0.4537100185045067},
{0.9988249123062639,-0.037181164281524064,0.031086260293815393},
{0.4495917678232571,-0.5233762289301437,-0.723840151757569},
{0.9953633220040206,0.056377063104833806,-0.07793256036339331},
{0.4886867382788636,0.08376698701477142,0.868428675088998},
{0.3690396351035272,-0.7752086553198223,0.5126999984785335},
{0.2843536706200749,-0.16034939773136211,0.9452148224885596},
{0.4606676548223916,-0.781540041801741,-0.42069047393656395},
{0.3169547980871655,-0.9021547825779819,0.2926711537565645},
{-0.18707686817596073,-0.40297075583875847,-0.895888840946361},
{0.3068520761411062,-0.262382208413623,-0.9148756090725574},
{0.17523392617062858,-0.4218142239805109,-0.889587450207424},
{0.6861772756884689,-0.2586462306551594,-0.6798991643594138},
{-0.16128925032529098,-0.5301008328565521,-0.8324535330781505},
{-0.03528356099778847,-0.5241719786573308,-0.8508811944765109},
{0.23037235182712953,-0.5729184875399003,-0.7865703949098456},
{0.5471234579515759,-0.5098521619538838,-0.6638574355311995},
{0.9529039598269152,-0.105324384388238,-0.2843955298513377},
{0.9614441991427487,-0.04512507187240096,-0.2712725194767599},
{0.9797671448747536,-0.1729122860813482,0.10078533199873616},
{0.8563138577095882,-0.5139320760259861,-0.050994100895527736},
{0.41030802420386897,-0.8909548318817766,-0.19454257328521352},
{0.15802127117972842,-0.647511902994227,-0.7454915246570797},
{0.2240637499396773,-0.6932864473571267,-0.6849447699441932},
{0.8146160385148057,-0.479536600079113,-0.32625964963355414},
{0.5259996102790288,-0.36198077164826437,0.7696066079129238},
{0.8969886004030294,-0.08051483948463627,0.43465941997128954},
{0.5968671580086822,-0.16810085338995423,0.7845327901242931},
{0.5304757350921465,-0.508089236541371,0.6785578989218632},
{-0.12800428712926973,-0.9288809554243806,0.34755585612447576},
{-0.7722049587605677,-0.4325109794092391,-0.46543931329019766},
{-0.32664860844028903,-0.34368201768761886,-0.8804449768850919},
{0.5558971348094804,-0.13824145629781695,-0.8196753474829342},
{0.7738700572961059,-0.12241154165856265,-0.6214020831066595},
{0.9741030533413926,-0.17102470140316864,0.14789791405200145},
{0.7669142609850216,0.12177886699222264,0.6300892189617981},
{-0.5297766822789902,0.0010366050348415289,0.8481365411084867},
{-0.7389141564858245,-0.09947714656801582,0.6664159111662387},
{-0.589736095206253,-0.4178651494221449,0.6910861414536467},
{-0.2138333294298635,-0.5708124062626276,0.7927474402870112},
{0.6143915555366377,-0.7673492341072656,-0.18357061148305695},
{0.3648859589010091,-0.7008488338039226,-0.6129185501782213},
{0.5063303883868228,-0.8222212511783066,-0.25996490514457793},
{0.39325720015529736,-0.052328317132603434,0.9179381905945989},
{0.6445859102341259,-0.34042312079299203,0.6845590574648788},
{0.5529882859294312,-0.8023344933246144,-0.22464041587916425},
{0.5562888345613286,-0.7297578743271627,0.39748732986083984},
{-0.4467936368298999,-0.45038552835990414,-0.7729995614049736},
{-0.5093298594434067,-0.32983166868022123,-0.7948548072541175},
{-0.48796113848016237,-0.26572663637927546,-0.8314344724941949},
{-0.39871944604698495,-0.28832361260614964,-0.8705700992784696},
{-0.5401104300799948,-0.3452036610849355,-0.7675383740845536},
{-0.5246271899344496,-0.3629567687652402,-0.7700835640298909},
{-0.4337285227548314,-0.4948582095178185,-0.752990651350819},
{-0.4107168744857654,-0.5327372393898697,-0.739934242199876},
{-0.34333957450837777,-0.45655068945689387,-0.8207797539735254},
{-0.3407180605379887,-0.5035103175705431,-0.7939701274753618},
{-0.31879411274270736,-0.6638675937506071,-0.6764984343280988},
{-0.14303065300487813,-0.7652499878235136,-0.6276421659171015},
{-0.24949628722320427,-0.9579190441595905,-0.14192500659930504},
{0.19218562374432704,-0.9660976384589388,0.17239500859962706},
{0.05134636028306884,-0.40241252803807925,0.9140173458768073},
{0.09322152306710142,-0.5222759041290151,0.8476659882307829},
{0.3772612390533713,-0.25379909764390646,0.8906514332459439},
{0.6522182323701132,-0.4004970287076708,0.6435942101668815},
{0.6135106739861907,-0.5273725780726223,0.5877778634841958},
{0.7614228277059606,-0.4528055037959772,0.4638991842850452},
{0.48571940068428254,-0.7259772023295734,0.48686113574265405},
{-0.6517675147956812,-0.6862409350159071,0.3229125048144699},
{-0.9131109493312289,-0.3397380782663166,-0.22540282249193772},
{-0.16654296793617734,-0.29266616015997443,-0.9415996806117904},
{-0.43165945160687225,-0.21967862418055256,-0.8748779457253417},
{-0.5192922853283057,-0.24246184234169185,-0.8194801873180206},
{-0.5650895896772365,-0.3996993354799548,-0.7217438582040688},
{-0.5535297797746689,-0.47998729318056477,-0.6806004564263831},
{-0.5998967492001452,-0.3536015385915514,-0.7176975980207719},
{-0.570296611249331,-0.30519162546498146,-0.7626400507077844},
{-0.535433508998271,-0.43256797813507075,-0.7253936184816732},
{-0.5974587372458847,-0.43423559796755845,-0.6741531745429296},
{-0.6095115311115265,-0.5286030870221415,-0.5908252447490248},
{-0.6070495923078317,-0.5979040213590031,-0.5234515963502528},
{-0.6225371270164081,-0.6530048135705642,-0.4313145475634103},
{-0.415016687467108,-0.5709684400318226,-0.7083475062506085},
{-0.40278504727337994,-0.6562417425833611,-0.6380524907749633},
{-0.37605062159256647,-0.7433655722414203,-0.5531668428295662},
{-0.41043590178741324,-0.7399560551242266,-0.5329234532359648},
{-0.3786696139995287,-0.8853624942507418,-0.26970831875853035},
{-0.40714783767227514,-0.7034689798622726,0.5825478801354651},
{-0.25034838416326477,-0.5955384733293481,0.7633214351316174},
{-0.035887563800959206,-0.6996152479216309,0.7136179563603954},
{0.33793363977357804,-0.914145736750505,0.22391611619143903},
{0.570895093817377,-0.5317516631070018,0.625554922159666},
{0.5318853132938736,-0.7304632942539474,0.42839396500178306},
{0.6861259742212689,-0.6194750883414356,0.38142071577627407},
{0.7063307866606754,-0.6429984001508804,0.29605721950109565},
{0.061340288221494434,-0.9402618538428846,0.33488059849571167},
{-0.5299152581251086,-0.41684174120056083,-0.738534211800025},
{-0.5075334337552978,-0.407712100526981,-0.7590656471639549},
{-0.5297875099441943,-0.36760419249385795,-0.7643247686475094},
{-0.5188966970432739,-0.2574987321526976,-0.8151322719272829},
{-0.5350306453912734,-0.3042418750725716,-0.7881491546303423},
{-0.6543828946300906,-0.3007604423020131,-0.6937767534025923},
{-0.6703054245067094,-0.36822282572947207,-0.6442845555254938},
{-0.6486224529775334,-0.3924146569464759,-0.6521500214728103},
{-0.6654681421383534,-0.46650592149706765,-0.582687203400847},
{-0.5560097153542488,-0.22907554486254428,-0.7989853510406907},
{-0.6201229987769806,-0.1937037987813678,-0.7602146438510062},
{-0.7679375155866248,-0.27629781139629594,-0.5778680572347455},
{-0.7853941922486891,-0.2378040419935893,-0.5714938323320211},
{-0.7263165557239953,-0.44323832834025684,-0.5253608713744934},
{-0.7046392838189279,-0.5710076535919724,-0.4212288442622826},
{-0.6652330428969954,-0.6909459872021539,-0.2829463578264354},
{-0.5918155388833191,-0.6029944940127725,-0.5349317789461819},
{-0.4999287118734923,-0.45517624168738025,-0.7368078935841162},
{-0.6609190210812605,-0.3727075818261368,-0.6513640349468965},
{-0.673250893561667,-0.39812311646860904,-0.6230820318800242},
{-0.7107769435624233,-0.5444713771137589,-0.445361713670929},
{-0.6738497108975576,-0.642732202872311,-0.36444736590375354},
{-0.6430621601509547,-0.6882730749556468,-0.3357845030269957},
{-0.5942360366285179,-0.7605595204352054,-0.26159653791172655},
{-0.44809134923053695,-0.7450780563779306,-0.49403727860237684},
{-0.47273250964778085,-0.5986408514260597,-0.6466475897473004},
{-0.5205061526033921,-0.6755776637522691,-0.5221763737867123},
{-0.5803305770718938,-0.7362073740153325,-0.34815962396701167},
{-0.6310201775305001,-0.7600552536586287,-0.1553368820830832},
{-0.6614114767238155,-0.7394172026772339,0.1256863510608689},
{-0.599512643384834,-0.7385117351668462,-0.30852067587535004},
{-0.48379345609970453,-0.8630118149766141,-0.14544586293832404},
{-0.296821366039447,-0.9006682662546078,0.3173227864878215},
{-0.3689809483164015,-0.7759004599077646,0.5116947684845414},
{-0.23979027987563167,-0.8284054622758674,0.5062064912154651},
{-0.23023375277017724,-0.8046511335315524,0.5472924011821733},
{0.1660670537212673,-0.9800659599955859,-0.10905249986253733},
{-0.15505772569388482,-0.5591096195586576,0.814465183429969},
{0.26849363149388716,-0.7252950430274744,0.6339229215030789},
{0.24585734640564472,-0.793593835695491,0.5565635535718206},
{0.3727315260376635,-0.8883155166166231,0.26826619696819165},
{0.4218949662026426,-0.828696710478353,0.3677858065983891},
{0.6268745795960474,-0.7783973284201642,-0.03355384575022519},
{-0.6977065252771222,-0.5015553169157089,-0.5115152672788049},
{-0.6694170789015004,-0.41130606339387726,-0.6186340571698379},
{-0.6740149370809871,-0.25570621147120076,-0.6930499246134858},
{-0.8038297383817481,-0.21238840703663198,-0.5556517940667268},
{-0.786913158638648,-0.35083162701533827,-0.5076266839392082},
{-0.7160607381666032,-0.5225051521698455,-0.46286648745860387},
{-0.5912095594569363,-0.7034071289335246,-0.39457530050958733},
{-0.70087951898028,-0.5973485204574834,-0.38979821059264314},
{-0.7338025008025744,-0.5752137837443979,-0.3614733638960702},
{-0.7020065572362821,-0.6099664523401037,-0.36759722607344375},
{-0.6446907780311535,-0.6481587174851348,-0.4052950501420063},
{-0.6068613659656115,-0.6627436998938543,-0.43873690379241753},
{-0.5948552172929511,-0.7359771586842401,-0.32324122935422217},
{-0.454634447981712,-0.8431542246824738,-0.287051340544615},
{-0.38974331984596355,-0.809178812751378,-0.43969284009376053},
{-0.42705393360536265,-0.8245134817888929,-0.3712175321028677},
{-0.45452879774303995,-0.8428768572055427,-0.28803155314925794},
{-0.45247426342493113,-0.8671828822759817,-0.2079925230040423},
{-0.46007214143658537,-0.883010025251466,-0.09288121435123534},
{-0.6029828258937668,-0.6920058763584126,0.3969125580812389},
{-0.2721924143839847,-0.7102619268122498,0.6491835525279174},
{-0.11538767347931446,-0.7626698886904317,0.6364120722408991},
{-0.3850129269412638,-0.918303346091959,-0.09210868929928728},
{-0.1295476704919518,-0.9546979619724371,-0.2678977463059064},
{-0.3841793196044581,-0.7276929426528072,0.5682158318821764},
{-0.11399721521214957,-0.9926867444062512,-0.03971979863988531},
{0.0352819504877154,-0.9978522058465628,0.055192021678240465},
{-0.8520681505987511,-0.3151689181094593,-0.41790958327482397},
{-0.69764284304806,-0.6217902386628378,-0.35590920562333206},
{-0.5496502566808256,-0.7475831771019041,-0.37283238679723846},
{-0.5911098802598067,-0.730929462946539,-0.34107364256993056},
{-0.6895249384720751,-0.6512348920423903,-0.31693607338328855},
{-0.7735560576242089,-0.5832746352501411,-0.24779371579341264},
{-0.7553128793251963,-0.5851422037039635,-0.2951458211968293},
{-0.7073984408784126,-0.6129891365419082,-0.35189737754691586},
{-0.6662371086744902,-0.6525767601801868,-0.3609316931190535},
{-0.5632401204280177,-0.6934441388124636,-0.4493281574605276},
{-0.5076590052827998,-0.7792849888211922,-0.36741970626686904},
{-0.4003755761997051,-0.8344285670978184,-0.3787193741992024},
{-0.3593268462131647,-0.8545426350527494,-0.3750214693422289},
{-0.38179138363033904,-0.8570611369828717,-0.34595020864173276},
{-0.3732851911080382,-0.87692719354136,-0.30274884529442814},
{-0.2636794534130091,-0.9367908540717108,-0.22999139456816953},
{-0.4242061044794091,-0.8885051291210588,0.17495089724827131},
{-0.3619589688499321,-0.8766723335075537,0.3169090161726458},
{-0.3626376525550623,-0.9266359387633465,-0.09919561452768609},
{-0.4787507490872199,-0.8726964000158164,0.09590992465777456},
{-0.2905564656535996,-0.8168611247040068,-0.4983119938494292},
{0.09448967292597665,-0.994702017104463,0.04049196066695669},
{0.30174273073861185,-0.9207203454538093,0.24743760812338877},
{-0.8955566630274479,-0.33076752094972317,-0.2976089890979715},
{-0.6872472530002091,-0.6684192776040029,-0.2844413517247613},
{-0.5278461501796742,-0.785068946376094,-0.3241067589181479},
{-0.5540749130511156,-0.7801183313688443,-0.29054497033968557},
{-0.5972608129540432,-0.7651214364025056,-0.24055915876732314},
{-0.7110321108034706,-0.6601746854141721,-0.242079991210881},
{-0.7886737937961387,-0.5997868299063962,-0.135090361055264},
{-0.7380145716997146,-0.6599433939525572,-0.14074519081399126},
{-0.6747576613399618,-0.7241262319630579,-0.14262993600927093},
{-0.5232639936476652,-0.8474005727642558,-0.0900392260667948},
{-0.4976938863137337,-0.7835699301373042,-0.37191257051967547},
{-0.5115680119695453,-0.7597887126079972,-0.40127207892277966},
{-0.3755991258859486,-0.8107359798661278,-0.4490350404859524},
{-0.9092094400105629,-0.3692067267919184,-0.19241774109285364},
{-0.8694319556422266,-0.47504440992952474,-0.13572355397219332},
{-0.6359307480277412,-0.6871127614319429,-0.35138033068207936},
{-0.46316945913624735,-0.8299951441074531,-0.3107766285959805},
{-0.510209103693968,-0.8239907472364635,-0.24642629522129442},
{-0.5327519069556408,-0.8194539255186346,-0.21135436969040458},
{-0.5647533628345085,-0.81044759914417,-0.15565451554184},
{-0.6823720813804174,-0.7199282578763319,-0.12677399600748943},
{-0.7252383728398402,-0.6880109388592829,-0.025889197951826495},
{-0.6722299009759964,-0.7400262809965837,-0.02163477913377844},
{-0.4579446858729693,-0.8861560018969431,-0.07081105127543658},
{-0.21282238436036596,-0.9737093031758198,-0.08122084476307763},
{-0.310938129574387,-0.9487344058339987,-0.056749508928195413},
{-0.44595260168209294,-0.8525470639843991,-0.27256151735810685},
{-0.5076682575191367,-0.7552750719338993,-0.41452684596142464},
{-0.29988874854204767,-0.7565583901756264,-0.5811076843002072},
{-0.6939096652204035,-0.7117880091140966,0.10884487399551028},
{-0.9063656197001143,-0.4224820370373603,0.0032080845360325724},
{-0.2636260458107119,-0.9568660465118966,-0.12210109337307946},
{-0.4487059959323898,-0.8919553177503007,-0.05548549676521209},
{-0.5043778375010882,-0.8322676401358855,-0.2300729715120183},
{-0.5291959261990552,-0.8236744998386312,-0.2037449140712591},
{-0.5275526910995174,-0.803146158989962,-0.2768472600791418},
{-0.6379027669996236,-0.7688514375937262,-0.04413079156648456},
{-0.6532033382607878,-0.7542705101357361,0.06634302091809569},
{-0.49532836713234035,-0.8636980580639015,0.09314222034423945},
{-0.23160924171655103,-0.9727873419621836,0.006476609424217605},
{-0.17008571890298427,-0.9827915873592431,-0.07205237012863806},
{-0.284516142552435,-0.9586599177106422,-0.004661201787869905},
{-0.41149691596126653,-0.9105882313631344,0.03872158386901698},
{-0.48827977124424443,-0.8594557215827573,-0.15138932469738428},
{-0.453717967746626,-0.8210034402579054,-0.3465448842914226},
{-0.3383156393878719,-0.8853362767748995,-0.31893918726292314},
{-0.23245215135611383,-0.7699180364230479,-0.594299768231818},
{-0.9541678911006193,-0.29850859149436965,-0.021360159096885486},
{-0.9588054517546282,-0.2792198111844415,-0.05223411459695821},
{-0.9677714852325481,-0.2506392387764226,0.024460669581258483},
{-0.9494373663446394,-0.26654228506668903,0.16590327802663368},
{-0.9163102886697438,-0.37594312926848084,0.137993544899003},
{-0.6502414404713956,-0.6815448708201965,0.33568237688679176},
{-0.4384031257067288,-0.8314133031172941,0.34140096480555027},
{-0.5007229351194004,-0.8317199006828833,0.23983025049702875},
{-0.5423974680153318,-0.8207572298777035,0.17933922129315572},
{-0.5031210574305235,-0.8122876389791011,0.2950559152631064},
{-0.36210361520017764,-0.5015534936296142,0.7857003658436784},
{-0.4793493263966959,-0.8315622289097504,-0.2805859631800598},
{-0.5561292641835776,-0.8295037508038432,0.0514175934966627},
{-0.5887749047752787,-0.7984973090237769,0.1254837000914799},
{-0.5102623574414802,-0.8597550386015432,0.021297891386757827},
{-0.5235930238406914,-0.8257176664827673,-0.2098587159105253},
{-0.45041565518039034,-0.8925077574991773,0.0235720252038229},
{-0.3124875061161462,-0.9281436291514069,0.20223986300175092},
{-0.20784462455249725,-0.9143917441725083,0.3474022887572699},
{-0.30832815201883684,-0.9463104923414809,0.09710923106004407},
{-0.4468823196779779,-0.8910066098652986,0.08002133175333244},
{-0.4925099589697628,-0.8661224008950549,0.08524040698746363},
{-0.410935283855276,-0.906714363262112,-0.09487494894315769},
{-0.2712555170822784,-0.9576171805569056,-0.09690087695510652},
{-0.2882495951658474,-0.9124452263764788,-0.29044083691778144},
{-0.20842151676872203,-0.792022312147991,-0.5738127990970361},
{0.7840495080116637,0.42045560147988287,0.45659988630184534},
{0.8378348996771638,0.4069785852748925,0.36386963601076155},
{0.9346019261382297,0.09225120535671717,-0.34352431466920047},
{0.9644761740871751,0.1583723912322168,-0.21143295701842424},
{0.634307868536721,-0.5624893656653049,-0.5303387987181823},
{0.5854857533476079,-0.6626884480290672,0.46695872780772646},
{0.33237886687395984,-0.5065680655029345,-0.7955583472431151},
{0.005169777944185103,-0.8578205004628229,-0.5139234012785564},
{-0.34837255892533203,-0.8844203963959022,-0.3105432701359525},
{-0.2699384481651148,-0.7224734716050271,0.6365259751409913},
{0.15920215731053625,-0.512444825209221,0.8438334991122137},
{0.36582051574289715,-0.10158422636590717,0.9251248538523008},
{0.14200848650258738,-0.9552435582208745,-0.2595059425885412},
{-0.06248434557919803,-0.9760054729540769,-0.20858816678140663},
{0.17921148980945267,-0.5412121271312544,0.8215672068469745},
{0.7448547989550557,-0.2565949566739651,-0.6159142445853233},
{0.20224671202369465,-0.9793346044512082,0.0},
{0.9541029371845487,-0.19244838789344965,0.22945850006706908},
{0.06967423411011713,-0.9008458520425945,0.42851167073817314},
{-0.24455577731082825,-0.9688238416833336,-0.039658991034108755},
{-0.12786216290580543,-0.8582476813498461,-0.4970535029095582},
{0.249347039523283,-0.8674025379179862,0.4306261616465156},
{-0.26557873486039246,-0.8671991725450601,0.4212285967584783},
{0.8720093071411091,0.14800995559451272,0.46657563299447324},
{0.911696901314147,0.10323570745529329,0.39768222092568783},
{0.8214292395190158,0.23216316048452806,0.5209167605069419},
{0.9060726042955597,0.10927063521083105,0.40876932862640697},
{0.977710327189389,0.12513896784680945,0.16859049449317423},
{-0.010103863730214933,0.22377799146667177,-0.9745877705331949},
{-0.05483605684762481,0.27017819420548883,-0.9612474968733418},
{-0.30345678756972266,0.022998847916433432,-0.95256759921403},
{-0.3151942850395048,-0.20250926231197613,-0.9271691115197348},
{-0.2535115573426904,-0.18368700362128138,-0.9497320543154891},
{0.8022590672334968,-0.5958953751338862,-0.03590391254006537},
{0.7208926898808625,-0.6645051581070269,0.19684162294974575},
{0.5364082305502976,-0.7143312691549564,0.4494408171332105},
{-0.3936984143609402,-0.908823339426619,0.13799165280237016},
{-0.4850499576208709,-0.6659912124971324,-0.5667294270536786},
{-0.5328705276944206,-0.7544224812144018,-0.38326977516231997},
{-0.4432494978594354,-0.8583979318764822,0.25823027165213724},
{-0.29476066505341986,-0.8138995251305685,0.5006832465037158},
{-0.40521576057546904,-0.9130265565011426,0.04671931618624071},
{-0.36080556409724623,-0.7490718737307774,-0.5556173799494847},
{-0.2966700519792021,-0.8746525495925225,-0.3833664014359602},
{-0.30137787402022514,-0.950877709202372,0.07073159967863582},
{-0.41797850368741185,-0.5955554783783303,0.6860084858285577},
{-0.13565527097725605,-0.24311640600284318,0.9604645025134182},
{-0.8642034345686576,-0.24173796707044348,0.44126542914257993},
{-0.17001886489495402,0.984400186168067,0.04527536915483028},
{-0.849043159725128,-0.2641269587807191,0.45756164892746326},
{0.28450520032622273,0.9563165387313884,-0.06719723756340494},
{-0.36913272334565217,0.8906818618240415,0.26538058250949914},
{-0.4111708270618892,0.9055857252396449,0.1041779497563117},
{0.05205732150325025,0.9986440984043851,0.0},
{-0.821115818426372,-0.5237340898783241,-0.22687312716430874},
{0.08698265068336758,0.981106270288428,0.17281349739191507},
{-0.603954575010683,0.7333693464052646,-0.3121029847290476},
{0.3095109088551996,0.9419668668318798,0.1300054579260413},
{-0.8490431597251281,-0.2641269587807192,-0.45756164892746326},
{-0.8642034345686576,-0.24173796707044348,-0.4412654291425799},
{0.4134131066199363,0.8422542138949165,-0.3459731816934798},
{-0.733850098860445,-0.19822011929144784,0.6497482718027031},
{0.4324674021308811,0.8095342494695911,0.3970217185871227},
{-0.6770229672237499,-0.7311429262194816,0.08408283588677894},
{0.3335100881537912,0.9427389856862282,0.0037717326194089797},
{0.42594483996172205,0.8803154175436739,0.2088438625980906},
{0.2597502062928406,0.9544400015834169,-0.14688129121257748},
{-0.6629265830039629,-0.7468416709102628,0.05249632500144084},
{-0.7433965636816052,-0.6538762486864046,-0.14073876690583983},
{-0.7653608984723277,-0.6131977840711512,0.1954767830200331},
{-0.6828447904398584,-0.5013427437226509,0.5313929294653726},
{-0.6524918798129676,-0.747775985865242,0.1228227248574354},
{-0.5996133449495711,-0.5225111370538386,-0.6061731998472807},
{-0.6940151802344495,-0.5423123820627749,-0.47354008263878095},
{-0.8135806562282138,-0.19412643883983108,-0.548088899317104},
{-0.7509408708211792,-0.6598107624894449,-0.027158170656844047},
{0.060333462630956736,0.939244847424462,0.3379038174888797},
{0.26824464370730516,0.9527941812653904,0.1422253819441348},
{0.33337504618578506,0.9424461957065071,-0.025617314046514333},
{0.43713103862955494,0.8829617326197089,-0.17115792063427335},
{-0.614015496303772,-0.7435624697132377,-0.26476371339891525},
{0.4255211166401446,0.7547363502135157,-0.499304337012714},
{0.41441139975725355,0.8375015672550531,0.3561661362293776},
{-0.733850098860445,-0.19822011929144784,-0.6497482718027031},
{-0.9742365855442027,0.21735317505294374,-0.06017202573935663},
{-0.8484580866009365,-0.4900032861979586,0.20003913316318742},
{-0.8240647774137482,-0.4465774710899904,0.34854813862779177},
{-0.05558031591699522,0.9976675861022971,0.03962595264952954},
{-0.5503849960669974,-0.4402540080018341,0.7094031044072561},
{0.3834245437616092,0.908471144015758,-0.16633039328968535},
{0.39875014712012347,0.8824842638291592,-0.24943905922206117},
{-0.7873870538925007,-0.4898506910898124,0.37425650001211924},
{-0.9931784534836023,0.10038133369132494,0.0593308299475973},
{-0.7133492617944971,-0.6773528634475976,0.17979412970557815},
{0.18270214070020874,0.9750347125585029,0.12620315800136972},
{0.14211602691035405,0.4379258913422814,-0.8877071299630773},
{-0.36618071824664333,0.2753654266679381,0.8888675735903278},
{-0.5435645080146418,-0.4949571289663455,0.6779049093436282},
{-0.6532696761401537,-0.64128120201666,0.4024886957118253},
{0.23521585272088089,-0.291829030445136,0.9270972546708575},
{0.8173877197234044,-0.5539303130805068,-0.15823565936888212},
{-0.04243921413781446,-0.3700301975523125,0.9280498725837752},
{-0.17952247950346445,-0.4007723410111909,0.8984170579599086},
{-0.342104569005117,-0.2659185490814476,0.9012501257255063},
{-0.43125351691894465,-0.06912749027726456,0.8995786759550318},
{0.42385082117607614,-0.7386188173005555,-0.5242067570318936},
{-0.3731837103191404,-0.30731187184612624,0.8753818205645294},
{-0.5471431415893817,-0.7357346318635111,0.3991602862113984},
{-0.538890538197159,-0.7821582591678903,0.3127705955761055},
{-0.5592953372425397,-0.783471251438952,0.27085332545020774},
{-0.3438258995010284,-0.16429630167813955,0.9245487959470796},
{-0.32384026889794265,-0.10792276707056535,0.9399362513425794},
{-0.6193192418100631,-0.5251107854469967,0.5836971301377513},
{-0.15859357883706698,-0.3998557601340234,0.9027532596669443},
{-0.18052151151848403,-0.22169807654081078,0.9582598534516545},
{-0.4572424675876123,-0.8837660043390444,0.09943327113693619},
{-0.3532441477978751,-0.8945942054003755,0.27371477802746397},
{-0.4852300265606733,-0.7732269172185459,0.4082547682668657},
{-0.032517455012995085,-0.36154820719546393,0.9317861927466105},
{0.06908326718751195,-0.6024760924393561,0.7951415347180044},
{-0.29615742266710393,-0.9539917151193897,-0.04680372295815164},
{0.08422413270815277,-0.7592921672899774,0.6452764525082629},
{0.05239848411548325,-0.4624902943687496,0.8850746445792619},
{-0.11545095330599346,-0.6593708715827618,-0.7429004853201581},
{0.3219407629133061,-0.7488289064051422,-0.579318059538003},
{-0.3249500381603806,-0.8380125578155475,0.4383405361622524},
{-0.2960025282225837,-0.8622987380175086,0.4108812355161169},
{-0.020416461292192756,-0.5640342900238403,0.8254989326374728},
{0.06745209861412449,-0.7240027101562097,0.6864912891501348},
{-0.24931038615059053,-0.8093068470077741,-0.5318521963325701},
{-0.06065374994471917,-0.477024469244878,0.876794604430984},
{-0.1350324491582935,-0.5731025071120744,0.808281976797805},
{0.05053931443203608,-0.7988285407208798,-0.5994320146826405},
{-0.2922915245654588,-0.8496743670889053,0.43888396482358294},
{-0.30323018870951873,-0.8126124997589639,0.4977071205947104},
{-0.36049376258052646,-0.4610108575950069,0.81087189883486},
{-0.2814139316824116,-0.09862559854833697,0.9545046832603962},
{0.24424592956679342,0.037103389068845416,-0.9690032324041333},
{-0.3359914067236414,-0.4013957333101607,0.8520511955793895},
{-0.4681739217479604,-0.3948852330799392,0.7904927777598836},
{-0.33004855331934885,-0.8069868116976976,0.4897348652054392},
{-0.18401524218362164,0.14849992137302448,-0.971640964552395},
{-0.4406790696051307,-0.7363691080421562,0.5133833794866715},
{-0.4638621907492775,-0.5080734922686224,0.7257363119255141},
{-0.3996457128035666,-0.3357991541081633,0.8529491381893596},
{0.40761021995779506,0.49098550257130247,-0.7699267139479987},
{0.36556207936874113,0.5980520009218806,-0.7132307973727279},
{-0.3842885990540401,-0.40337669251336467,0.830427309626834},
{0.0959272322333519,-0.06401753558437491,-0.9933276001671111},
{-0.40041103509551274,-0.5220832466014714,0.7530604800358384},
{-0.38000724328050084,-0.5965506651174491,0.7069100360033683},
{-0.38497104601221677,-0.06514692541450101,0.9206265105031993},
{-0.4345349926632615,-0.48438909615801995,0.7593066203282807},
{-0.3922902374417971,-0.5338773053069604,0.7490549996402381},
{-0.6538683793752902,-0.5503436998778649,0.5192089699320247},
{-0.7465837006967034,-0.6194564456317744,0.2426653865289889},
{-0.7443369176584044,-0.6619369407011063,0.08832915456431034},
{-0.7181425603491509,-0.647622776153714,0.2546684174021634},
{-0.6939691869384412,-0.6976847424262543,0.1778841414112287},
{-0.6780781950341065,-0.6640419562622177,0.3150527602525255},
{-0.6098493268851555,-0.6718569040959006,0.4203475929708588},
{-0.5326800275448008,-0.8324059669016389,0.15281457561835457},
{-0.5691544684095022,-0.7871366431643424,-0.23765331068063703},
{-0.6826977326038179,-0.648603404765919,-0.336507695638099},
{-0.7410769533838112,-0.6493344495606841,-0.17079145697924092},
{-0.35979434449522385,-0.7309804132018947,0.5798410689011598},
{-0.5529039237141129,-0.7836892745635816,0.28306955342379275},
{-0.6456766650158874,-0.7632355864541461,-0.023939169241165327},
{-0.6481505156765208,-0.7608301326038053,0.03222449922553013},
{-0.46791006315308115,-0.8257417504064324,-0.3149773554333721},
{-0.4358140887399662,-0.8717684290323188,-0.22379876272731242},
{-0.5021572045312104,-0.8359818363109589,-0.22129733684696087},
{-0.29074461217569725,-0.8107782589041512,-0.5080415193457684},
{-0.3316487926563495,-0.8075406763798995,-0.4877367469460141},
{-0.20607669773335882,-0.9731313576834931,-0.10270226552708116},
{-0.3955602899106023,-0.9162513788711212,-0.06336771861609883},
{-0.23419783804841482,-0.9721672298353478,-0.006499991362653784},
{-0.24358894627423386,-0.9624104945721045,0.12012687122573948},
{-0.10704848442274716,-0.9830634567984593,0.14875100635039903},
{-0.13790721231707678,-0.9813629732287736,0.13382195472535105},
{-0.2075764660164122,-0.9524744149860445,0.22294505949477678},
{-0.29540623134819216,-0.9373202993841321,0.18483997090212742},
{-0.15470997369956802,-0.9848765518077476,0.07799360061671912},
{-0.34310078764869956,-0.9392889024776759,0.004266989234232441},
{-0.3568801916862452,-0.9333717682227934,-0.03812703852444715},
{-0.39866765801579235,-0.9170947874985017,0.0011176740495728327},
{-0.3954887459882217,-0.9123216948091063,0.10610267186694083},
{-0.6178463904725036,-0.769219569652973,0.16299414542551416},
{-0.45438286695204555,-0.889049491203824,0.055921484338860836},
{-0.416722202119591,-0.9050894028953586,-0.08459183782802014},
{-0.3917942344879955,-0.9157781180495761,-0.08858733726409296},
{-0.6553832704690595,-0.7504030738380209,-0.08583702909426141},
{-0.7190457166935547,-0.6844621164582206,-0.12035309899701559},
{-0.7722130272077243,-0.6177635943498049,-0.14850987208496283},
{-0.9325576055583564,-0.3448962121359493,-0.1066907454727883},
{0.4131220542708668,0.8459290926405162,0.33724492360806835},
{-0.25935967802693105,-0.8997631522446153,0.35093991975351},
{-0.2780657422226711,-0.8879313772012318,-0.3664113977262156},
{-0.23975275687113948,-0.9336894428688587,-0.265974885746622},
{-0.41437282440502093,-0.9064755906796738,0.08122293947243132},
{-0.6652967089489995,-0.745525612299177,0.03964656942999661},
{-0.7435013137803475,-0.6522533841144263,-0.14755107359208208},
{-0.7165551424528486,-0.6881591727454048,-0.113954731322303},
{-0.7133964894511314,-0.6340052637402895,-0.2985008783712497},
{-0.9325454006850905,0.14287288105621973,-0.3315816875519204},
{-0.03448942495124651,0.9977455890059114,-0.05756925556040607},
{0.36683069115369304,0.9280243964917585,0.06485340040284134},
{-0.798092807465974,0.5978923510946643,0.07464989734470152},
{-0.8240647774137482,-0.44657747108999035,-0.3485481386277918},
{-0.9794178903992561,-0.20079382307432472,0.020553262054175125},
{-0.30266559833169704,-0.9480823161060001,0.09763942581558963},
{0.030303636384994066,-0.9531193375656395,-0.3010734428346056},
{0.0684095958805897,-0.9956532788885701,-0.06320344476287458},
{-0.11633058206597607,-0.9925717715365274,0.03561564298213264},
{-0.21391695781583678,-0.9536490783261907,0.2116434987577562},
{-0.17237311604238906,-0.9820901610645082,0.07606855070346344},
{-0.21375793780729405,-0.9713501219360453,-0.10385800228775405},
{-0.18491659423058732,-0.9751116518071913,-0.12232383123500991},
{-0.15598984122584436,-0.6769472694445122,0.7193118682643536},
{0.2831407875510798,-0.16867596855641204,0.9441290759512233},
{0.09220930649975427,-0.9872209732142522,0.12996997284272682},
{0.03391322233040015,-0.9436316514625375,-0.32925552343013664},
{0.09645041118267993,-0.9473922171021257,-0.3051971578455649},
{-0.06256831591775007,-0.9244110152543318,-0.3762306217198066},
{0.08154316679994354,-0.44362281134196485,-0.8924962258773357},
{0.45730786765212933,-0.880168013113505,0.127176188318755},
{0.35252306725461435,-0.9245110938781664,0.1449369668152152},
{0.21612862142498385,-0.9754342866012425,0.0426189103997393},
{0.2631886743076621,-0.9343467079803078,0.24026641671806123},
{0.2469734684759733,-0.9659014588780914,0.07770764187724546},
{0.08549433149297517,-0.9129270694578961,-0.39906751951716996},
{-0.06479312486465123,-0.9882868901184281,-0.13816972819803883},
{0.3684134266303107,-0.9168453038871859,0.153838343135014},
{0.5425971427155662,-0.8280310144544967,0.14125501696704557},
{0.054165661861412556,-0.891521878225448,0.44972749718077576},
{-0.2648598487301815,-0.9580334559085735,-0.10964104108636143},
{-0.2766036605973781,-0.5245820270459076,-0.8051733427309532},
{-0.3603317487181747,-0.2733420880973406,-0.8918773086811257},
{-0.3434632036406818,-0.4329821032810177,0.8334023793961868},
{-0.028649599429634368,-0.5152754457266373,0.8565456295398025},
{-0.7173416292863629,-0.6964504510879665,0.019435947935563157},
{-0.8219097857508391,-0.5474205781728065,0.15746432827774},
{-0.3933073603871717,-0.8903233580026672,0.22942022243065277},
{-0.3782797777866709,-0.9250971301600839,-0.03316186796975963},
{-0.5518341166470402,-0.7847946241529621,0.2820930796829154},
{-0.45152514623650486,-0.5000862092339633,0.7389443995661024},
{-0.05376808903446297,-0.9979443936590388,0.03487090142332949},
{0.23808294411507203,-0.8119743122230422,0.5329298528056174},
{0.2527937847363957,-0.7802385784011049,0.5721215458040991},
{0.10330180112830441,-0.9303327060235341,0.3518661591949087},
{-0.23249990244865867,-0.6527259250246759,-0.721035825851979},
{0.06173458098070759,-0.9300208156371199,-0.3622845897810209},
{-0.4631540918090674,-0.8552377936207171,-0.23250076043593002},
{0.4154876883346648,-0.4288724508908226,0.8021461224173657},
{0.17167926784940665,-0.905369015203844,0.3883724698012376},
{-0.16142984501484037,-0.6821125507977281,-0.7132060524018995},
{-0.5175231276755664,-0.8555648806854664,0.013362157706103571},
{-0.8537945131863646,-0.47677647269761175,0.20909118665042326},
{-0.26642471993171396,-0.9502764289738442,0.16122213602984656},
{-0.02649676069462117,-0.9608106988176766,0.27593608446555146},
{0.006964998503653446,-0.7762667734745208,0.6303660723700962},
{0.0778831095965266,-0.6992696727944724,0.7106026639054254},
{0.29610633898454886,-0.944638138615662,-0.14135000207253112},
{0.04200710218454374,-0.6548236190121438,-0.7546134317317019},
{0.10618135320484537,-0.5671822556743645,0.8167189290568253},
{0.13616544311795842,-0.9533404392115251,0.26944568852454553},
{0.0913987096948095,-0.8862534621387674,-0.454093687154063},
{0.9841529314975542,-0.0807874859639232,0.15784926207112632},
{0.8101222491279777,0.3704647211789193,0.45437631081478314},
{0.8113903197964774,0.4838834999719789,0.32787574993499935},
{0.852080171994458,0.42972791623706375,0.2988198428827073},
{0.9860263426096305,0.1465813856099645,0.07915774802594082},
{0.9731588374180847,-0.2126514298493459,-0.08798435393926698},
{0.9845245316727945,-0.1742387477668917,-0.01876979784360592},
{0.9975878323630983,0.06891478827629456,-0.008322780660820732},
{0.9791145146746398,0.2019867387722166,-0.023154362733803318},
{0.9715355868177288,0.23689004334337946,-0.0013080181585896464},
{0.9603061635404415,0.24637109222804263,-0.13081803079316043},
{0.9250308444842563,0.20616550134558384,-0.3190826269286179},
{0.9296633970036119,0.014004894428728846,-0.36814376431462886},
{0.8935611186286893,0.03779884537884193,-0.4473474874893924},
{0.7980889187574556,0.10364882711802194,-0.5935579149447964},
{0.7072539379689756,0.10274159523798898,-0.6994540955883592},
{0.6104531233718085,0.11900473646131374,-0.7830612088881538},
{0.5372105885494691,0.13710723531897773,-0.8322297696991616},
{0.4538691399507441,0.0909595327893054,-0.8864136546754698},
{0.4144019762798449,0.03128959348921921,-0.9095559154854848},
{-0.17668574381459715,-0.9830825880017493,-0.04827808095259683},
{-0.1333315640485675,-0.8954407915461872,-0.4247451975755588},
{0.48166141809668317,-0.6083026739065869,0.6308487419621196},
{0.3526691814432425,-0.23988303067967787,0.9044780705202787},
{0.008781230255391913,-0.9999581765319918,0.002556400206457119},
{0.3961649778800022,-0.6084470492437979,0.6876376215477544},
{0.4549924885901401,-0.1929128493618803,0.8693483006698935},
{0.3501514601614298,-0.9327777178637889,-0.08555515182407433},
{0.23911102323487465,-0.8378319144713652,-0.49077856683113047},
{0.3935993211656657,-0.8472072093684031,0.3568186076595919},
{0.3312687016454606,-0.7632481296559699,0.5547191540651852},
{0.5592808805258649,-0.7562152683100883,0.3396223853825223},
{-0.03120568118549344,-0.4749992521320686,-0.8794327239395433},
{0.27711074816946946,-0.5723972890558605,-0.7717324515209003},
{0.24273332567322645,-0.7042260601088601,-0.6671927674002226},
{-0.3519823604456803,-0.8821803786484653,-0.31283573559096095},
{-0.26887150260950055,-0.9631750265190614,-0.0014083232990164528},
{0.11654905772117567,-0.975565374830677,-0.18624853442587647},
{0.2666361860322561,-0.9417677434431639,-0.20488694860371873},
{0.3858689126042311,-0.8232537744339632,-0.4163633091013924},
{0.078721325631764,-0.9554410204531774,0.28449149253741984},
{-0.026235438842884023,-0.9090296420961945,0.41590481067088597},
{0.20803744581719724,-0.8437238577044816,0.4948236787767179},
{0.5963731883992014,-0.8020257752448976,0.03307077261558127},
{0.5404521089573653,-0.6853276684691993,-0.48809579464907044},
{0.8792630120859627,-0.4544909952135851,-0.14259905626365488},
{0.6007834770779429,-0.7571326938729755,0.25653322891740155},
{-0.15913449839419894,-0.9273415906688549,-0.33869423620218975},
{0.07219417918439747,-0.9973300182831305,-0.010992503048062438},
{0.6499690918137193,-0.7510861794775223,0.1158003915567991},
{-0.11146248345554366,-0.9639560393710339,-0.24158822186115037},
{0.35260707429081267,-0.9239324134503712,0.14838175944450127},
{0.3323657958391814,-0.9399661305876982,0.07743804687734461},
{0.7682280577824769,-0.6240809659010788,0.14264851641618911},
{0.8904922670364129,-0.44136816166219833,0.11053356150636463},
{0.48385220818279867,-0.2983728861122994,-0.8227154194918475},
{0.7530517943255391,-0.5510593332331204,-0.35950884039165826},
{0.7471861414983064,-0.617757994555449,-0.24512839516404972},
{0.5644398203682592,-0.8248964167439928,0.030880265956885235},
{0.7394196413778419,-0.3821016453090333,-0.5543076100837813},
{0.5359158890943995,-0.38089613315679427,-0.7534668510043164},
{0.3552499774032595,-0.43042506691097787,-0.8297781121056783},
{0.5520173772059741,-0.8054779893547183,-0.21559690147986232},
{0.30420928104479644,-0.912037687151031,-0.2750344897324811},
{-0.12945434254089422,-0.9755763933888454,-0.17746062622372757},
{-0.318637463857553,-0.9275242826994259,-0.19536855332765848},
{0.07676361838851077,-0.8240338361970964,-0.5613159392839298},
{0.07952010805966214,-0.7279113635102235,-0.6810444914151107},
{0.14208573421569665,-0.6224847910257599,-0.7696260969288934},
{0.19326894441223894,-0.9685431346301124,-0.1567523890939306},
{0.0566998452017389,-0.5557834642764995,0.8293912637536712},
{0.3584432918585713,-0.9199513298751842,0.15877013945471924},
{0.004568644971880356,-0.5506899894101146,-0.8346973481727427},
{0.032611179241969934,-0.6591748871129454,-0.7512822233941675},
{0.05612889051974382,-0.6750915808995991,-0.7355956124444346},
{0.8949521651137008,-0.14998036551245889,0.42019818195590586},
{0.6497991025361212,0.25831972960598976,0.7148650527473979},
{0.6741126777873043,0.3603415301866209,0.6447682368643748},
{0.695275701577712,0.3845157174669636,0.6072391306696947},
{0.7343705424859059,0.20629996326782762,0.646637635375988},
{0.9371175124112746,-0.05320160105384469,0.34493529476905105},
{0.8374337119372409,-0.3830231719706066,0.3898692445482066},
{0.9552023095841277,-0.25129654679633007,0.15632847895821178},
{0.9986711432780838,0.05084828739771031,-0.008390426232600603},
{0.9802833029005465,0.1974135794963366,-0.008516142603251247},
{0.9833232647944963,0.17851102541503577,-0.03477313214488279},
{0.9826378463244987,0.18062328349868453,-0.042403919970973356},
{0.9781625763735731,0.1732156176189508,-0.11486654863405293},
{0.9480426714015527,0.15342286670104568,-0.278705072029629},
{0.8978954481093209,0.14047416870637253,-0.41719392635897234},
{0.8705578983808735,0.14376819590956696,-0.4705949972232867},
{0.817213965803522,0.11848040750161844,-0.5640245802568629},
{0.6716519027931637,0.2272385734805694,-0.7051569698987867},
{0.5591424396787313,0.22970185785486685,-0.7966158350473199},
{0.498992069626743,0.23010707144423106,-0.8354984441164324},
{0.4594895166127484,0.23197812300642637,-0.8573537977809385},
{0.4112958946587233,0.2148997292369752,-0.8858068601059461},
{0.37587266418874254,0.19106836001566727,-0.9067594069633796},
{0.39982940938234834,-0.014378766602099592,-0.9164767833742244},
{0.3629124947853513,-0.05981758919294014,-0.9299012727982563},
{0.3104341557302403,-0.08476731535363757,-0.946807867100707},
{0.2556107871717328,-0.0760269396029734,-0.9637857801067895},
{0.2158466128800283,-0.05507446443644705,-0.974872834309818},
{0.31207016853625175,-0.16580765186714022,-0.935478504559063},
{0.3517548964257733,-0.2605912560545537,-0.8990888110239186},
{0.2928501950968313,-0.29173748543736877,-0.9105646615273564},
{0.244439307517705,-0.15559654926921704,-0.9570993359081266},
{0.14847906212088596,-0.005411502236200192,-0.9889007451484955},
{0.06604383451123179,-0.015789636479472804,-0.9976917857248796},
{-0.0315740674011019,-0.04107142789559937,-0.998657206491981},
{-0.10946058540350054,-0.05444088369283664,-0.9924991538665743},
{-0.20501453374755438,-0.07807919095534473,-0.9756396265486719},
{-0.20586639240081653,-0.07529345189895974,-0.9756792119241919},
{-0.18202136759381674,-0.12580925921146624,-0.9752129265119175},
{-0.34727412402596186,-0.2193535336202099,-0.9117481615393191},
{-0.3141804124939302,-0.21879945413903149,-0.9238059684119851},
{-0.4319070649059792,-0.15519375559045648,-0.8884656355256697},
{-0.47634742382256207,-0.19440715971563566,-0.8574957656273923},
{-0.5225220156575809,-0.21796889833449556,-0.8242938204984828},
{-0.5527219417927006,-0.3008617754686076,-0.7771619182144629},
{-0.6721413624750261,-0.28986573205485794,-0.6813250664921384},
{-0.6933262457691378,-0.2813900008542881,-0.6634141876285862},
{-0.6521207817941281,-0.28202548304745834,-0.7037045636231605},
{-0.7471263397864177,-0.21909536782547726,-0.627534423115393},
{-0.8036346042964625,-0.1753472657672899,-0.5687044567833134},
{-0.8550903125427676,-0.17183035382334688,-0.4891777661550607},
{-0.8621418485203806,-0.20257338672199993,-0.4644087165653121},
{-0.925015868298157,-0.20225714283472568,-0.3216173060781092},
{-0.9513578740607488,-0.21666058014553582,-0.21903513068367012},
{-0.9596660894212605,-0.2610133717448849,-0.10446538462702264},
{-0.9718562091768848,-0.20367854301413255,0.11836621055003656},
{-0.9788968516576108,-0.18941890107490367,-0.07669050612946451},
{-0.9536113585024936,-0.2739433619871556,0.12482151800952775},
{-0.9620499369986483,-0.21199856804011333,0.17180374230452172},
{-0.963027235381806,-0.16522151470800345,0.21279190536876336},
{-0.956025434362825,-0.23357915452916458,0.17735880982012844},
{-0.9093671818133199,-0.371336785208469,0.18751085459764663},
{-0.6428296210575561,-0.7017537326830572,0.30710222558033495},
{-0.5225240070501459,-0.78507636999996,0.332601496274363},
{-0.5596968405476462,-0.7752106334881093,0.292895750068087},
{-0.6321940823509425,-0.7426282751094597,0.22098390721588376},
{-0.6693322298794279,-0.7337337311717497,0.11674406959419908},
{-0.581537619131136,-0.8047544537188142,0.1190977193527343},
{-0.5285956400014707,-0.8253134125113176,0.19860619451658393},
{-0.15741979652356747,-0.9697552093414918,-0.1865310741338231},
{-0.1813341981054955,-0.9834173040714101,0.002883513543616261},
{0.04922393564673035,-0.9813460249533709,0.18584128569202393},
{0.26251805440667597,-0.9094331135588096,0.32251462458819263},
{0.3820238143446647,-0.8449066532520244,0.374420288665046},
{0.468465573349878,-0.7881998909108385,0.39910016105498186},
{0.3471628778563961,-0.7981732438120263,0.4923387137947338},
{0.6343980003504793,-0.6410254298058682,0.4320018234840163},
{-0.018718796479672395,-0.9867713839541011,-0.16103366873936847},
{0.15875860273680426,-0.9738129085822552,-0.1627394393981547},
{0.9840757712653893,-0.13905251818656608,-0.11072160400935283},
{0.8213281254896375,-0.2109024335362637,-0.5300379927968939},
{0.5473194469582987,-0.3455593919620956,-0.7622533237763209},
{0.8003087717366008,-0.23213591061275776,-0.5528279921326698},
{0.9594231855273482,-0.09608353649093297,-0.26509452104476083},
{0.87298658408259,-0.2778180625043835,-0.4008884485216822},
{0.7272206817226884,-0.43942499526812023,-0.5273099217807311},
{0.5560165153199155,-0.6916131703840585,-0.46099550674904577},
{0.48291690745474825,-0.5034725656522029,-0.716454210769907},
{0.6268566210758728,-0.762183785586477,-0.1616374139931934},
{0.6076823789272312,-0.7940951251330136,-0.011621470704019655},
{0.2780865527614333,-0.959997224191533,0.032759711809081424},
{-0.11108816973113561,-0.9927726295965806,-0.04540841848905204},
{-0.41833469662021666,-0.9081301518659707,0.017196187820571748},
{-0.4216604339781384,-0.7550366438945021,0.5021176603087119},
{-0.3626503318174889,-0.7341759191627398,0.5739951711941583},
{-0.11947974600667616,-0.9650610925030888,0.23319879508892127},
{0.09369874417256221,-0.6276075626592288,0.7728708123829149},
{0.25833320817582,-0.9474065251220185,0.18890428716630658},
{0.1199594504416348,-0.5855406981288029,-0.801718043382195},
{-0.023452224007094426,-0.24812819756001858,-0.9684432821620156},
{0.01474704506917151,-0.38125887278333664,-0.9243506891790081},
{0.7701535796653936,-0.16276394942139166,0.6167425398797548},
{0.7676970784490825,-0.16141866099556623,0.6201493462248765},
{-0.2894569069682615,-0.9565855703271586,-0.03404035326244474},
{-0.21227384155128387,-0.976036522684558,0.047880294264934314},
{-0.04377116732170698,-0.9874186464907355,-0.15194900945283984},
{0.1287630483611038,-0.929123428591319,-0.34662621340497035},
{0.3389530967492818,-0.9340708615094844,-0.11234956111619615},
{0.5059592302272201,-0.8624933620263641,0.010509890976519123},
{0.5842942803365646,-0.7970719226407538,0.15256652353563085},
{0.38929874678810245,-0.8733166271728041,0.2928558595157865},
{-0.0061218032095597605,-0.9015802300504527,0.4325686215014168},
{-0.10673477181338763,-0.9336389657081215,0.3419443963532859},
{-0.11112328528492672,-0.9782756151170507,0.1750098178241461},
{0.0992697787069582,-0.9776026891333354,-0.1855761117028343},
{0.5988138874780492,-0.7039375288857547,-0.3819605785806219},
{-0.4161753383734798,-0.9002281863244262,0.1280128910569306},
{-0.2852380134845147,-0.9311331494189239,0.227223092392925},
{-0.17102560809710757,-0.9673092156358833,0.1872514959109985},
{0.03908320950156047,-0.9987437267215163,0.03136034230479876},
{0.12090016364648547,-0.9810050498544503,-0.15169786613634567},
{0.2041121752500862,-0.8172923860782734,-0.5388611839547928},
{0.2874092423593767,-0.5802345561564474,-0.7620523520391097},
{0.48289599814820333,-0.5018295987762998,-0.7176200309108355},
{-0.16206793760331026,-0.6807856789071038,-0.7143282459737983},
{-0.5485668073112687,-0.7490625911689124,-0.37145617834091316},
{-0.3748371730118037,-0.8696056099268553,-0.32137700121860174},
{-0.21341682880475568,-0.8706684471037208,-0.44315878915002577},
{0.01985540375196783,-0.8276510519412027,-0.5608917000299318},
{0.37667401299349756,-0.67233128280749,-0.6372498207875851},
{-0.3708720998101753,-0.9096907184968188,0.18686006064200208},
{-0.38596383849483085,-0.9212412295995314,-0.04844081192836706},
{-0.295247419691341,-0.9335209764762522,-0.20339013654656354},
{-0.18077146138480776,-0.9583616866171201,0.2210532885373795},
{0.32604663469768935,-0.929261568436958,-0.1736851445242112},
{0.3460299641917251,-0.8050563378438523,0.4818169328478593},
{0.6057843278318236,-0.7582069386239486,0.24113810643663436},
{0.5624370558424693,-0.7355829428678045,0.3776007049479589},
{0.18495608583495585,-0.9529026896207878,-0.24034914276127728},
{0.3945442728412204,-0.7690532642348693,-0.5028835785128453},
{0.35692350279774154,-0.4359870797300518,-0.826148218819754},
{-0.22225720599454846,-0.5541752086508647,-0.8021792645663857},
{-0.25721365457473344,-0.798996289381443,-0.5435495059835813},
{-0.2623925848213985,-0.8970336701172815,-0.35564128852913773},
{-0.16741317606902276,-0.9199622244048818,-0.354460624253956},
{0.04560353123052624,-0.9185877580594464,-0.3925771881842176},
{0.37847499475990143,-0.8157160679858201,-0.43745168278479124},
{0.672930191605809,-0.6354677050719832,-0.3786102917723133},
{0.9080194007690185,-0.36049575555517666,-0.21340941416388992},
{0.9771573743843976,-0.004089843580862139,-0.21247761968187157},
{0.8173863697514119,-0.44157036752640605,-0.36999342300533283},
{0.5105952265902176,-0.7238606195450488,-0.4640240490051593},
{0.5532748584683892,-0.7701103636015126,-0.3175168638991166},
{0.7590915463733028,-0.6255657889837166,-0.18013180695748407},
{0.5916259217669988,-0.7575085730036063,0.27597016237156735},
{0.2771931372432973,-0.9090555304917136,0.3110980667693838},
{-0.227602454455269,-0.9648478344283119,0.1313993117369115},
{-0.3056278810940843,-0.9520061517889316,0.016609793917152765},
{0.09412687197925079,-0.872465896014889,0.4795241310532127},
{0.1317602761234755,-0.749739310743841,0.6484829955837053},
{-0.2613251929492016,-0.9645318115328424,0.037249537866071686},
{-0.3657643140260423,-0.9156691509628488,-0.16663274756191945},
{-0.3318504641683227,-0.9230875166788108,-0.19438288500538056},
{-0.22127238396093654,-0.9575591029411812,-0.18471355248255197},
{-0.22717940338697468,-0.9735573769412005,-0.023990674857275133},
{-0.14217123536348428,-0.9883451584164298,0.0544167958448748},
{0.5322849167315694,-0.7355862239325864,-0.41902944357248306},
{0.428270070470661,-0.8972102012061418,-0.10769680399477781},
{0.2708784571378055,-0.9595044937379594,0.0773045144561701},
{0.2830708890756955,-0.9586214981438487,0.030260453637356157},
{0.3179847604156858,-0.9395408642538465,-0.12707736439080664},
{0.47939754532285117,-0.7658692958222127,0.42851162791132374},
{0.4275956735561619,-0.8705128202833513,0.24365830517012538},
{0.13356726849424172,-0.9909946592007024,-0.009453582531020185},
{-0.21340742494821469,-0.9664663717457533,-0.14282865000262143},
{-0.2902514453628558,-0.9464107935096939,-0.1416358301882848},
{-0.2698793107632204,-0.962894155811768,4.822356326336636e-05},
{-0.07369804482775406,-0.9959199569369259,0.052077226916554226},
{0.3164602376452963,-0.9083402671335243,0.27344263949369746},
{0.42057153481903264,-0.8200902256449006,0.3880355729848224},
{0.6514085347898895,-0.7258075496725667,0.22106632860115527},
{0.9231290314673063,-0.3612864831511511,-0.13154796978481276},
{0.6450384226112924,-0.5668190087667437,-0.512485750685638},
{0.5597765261928197,-0.8223624747206449,0.10183418333170745},
{0.6760442124772628,-0.7202875231718,-0.155403046106025},
{0.5952109921922992,-0.7251065101778329,0.3463299347027097},
{0.3594203672256686,-0.5978186304838168,0.7165402184593822},
{0.20904557856169403,-0.7596609155499714,0.6158045464833675},
{-0.1495456027926287,-0.9851806666592636,0.08399503989045098},
{-0.17751671332129115,-0.9839871628467203,-0.01603370962904473},
{0.10551753190431228,-0.9909867279659499,0.08253093635820909},
{0.30114108226523695,-0.9371140272800433,0.17644077886673504},
{-0.361646950266678,-0.9284906470889246,-0.08435995276907848},
{-0.4045789143358421,-0.9143541412881772,-0.01650473822850099},
{-0.2900494624553038,-0.9550177584595255,-0.06174455730129177},
{-0.21317926973427095,-0.9583556896429092,-0.19002360665092843},
{-0.10784678075070878,-0.9701626562278759,-0.2171485490225084},
{0.3401445649011806,-0.9251439501709244,-0.16855369005253076},
{0.06865074315106695,-0.9361558069671255,0.34481789475973557},
{0.04193251656469846,-0.9192364767074858,0.39146642760900874},
{-0.3011730408702698,-0.6665150265103309,0.681947592479721},
{-0.5003118487952609,-0.43749505197647864,0.7471854745986208},
{-0.5719009652557255,-0.3489156401009261,0.7424198017513612},
{-0.42439983638576717,-0.4675304839447501,0.7754353780026558},
{0.13721877239997693,-0.609917604494495,0.7804944101201111},
{0.06722167535222746,-0.994025685411523,-0.08598943600810155},
{0.2369016364324838,-0.9377336720184796,0.2540338068414316},
{0.6329325933532319,-0.7407912539870514,0.2249992228596448},
{0.5544408309221438,-0.7248809284918563,0.40883126655766827},
{0.4748911613633341,-0.7371081880934695,0.4807805153129088},
{0.3190762977011302,-0.5354091054230924,0.7820021777945274},
{-0.13300544622975963,-0.8002599047922931,0.5847167143626496},
{-0.2661812644233281,-0.9515559866426805,0.15391146401250722},
{-0.809126104403154,-0.5847672240854362,0.05798483257533323},
{-0.3989442225196403,-0.8910583917140885,-0.2164681266932891},
{-0.07923071615635398,-0.9137502437459841,-0.39847582821484445},
{0.12261106001316846,-0.7985616389760323,-0.58929265795389},
{0.07995002343562674,-0.6636850620084803,-0.7437271893775582},
{-0.06430862584009257,-0.27039200470279257,-0.9606001064102399},
{-0.01789058904372855,-0.18591712958626638,-0.9824025385502991},
{0.012848159199716578,-0.1604323378105507,-0.9869632160267272},
{0.8967045147768035,-0.35004160351709585,0.27090937411997723},
{0.5478852307927297,0.1545063753055953,0.822161513249753},
{0.5792925750729058,0.19139928656793698,0.7923297454763935},
{-0.9565673036745768,-0.23076542088523466,-0.1781188200735966},
{-0.9673938661798159,-0.24373745793636378,0.06885607653931158},
{-0.9751555548226729,-0.2214803067891324,-0.0042564777782458365},
{-0.9745629965228024,-0.19852074877694106,-0.10400229859738103},
{-0.9226786455704596,-0.2672724701570275,0.2779020397629765},
{-0.9114593012002172,-0.26660666401543226,0.3133094779258586},
{-0.9045035912917598,-0.25502101354902385,0.341815061091137},
{-0.9131147588088389,-0.18047805742804127,0.3655805082775564},
{-0.9133444162022439,-0.21340616840404675,0.3467849256805806},
{-0.8904189112762136,-0.30944906158357377,0.33375955525906315},
{-0.7095088671068193,-0.6014579194160785,0.3672132060104591},
{-0.5532763030777673,-0.741442081866389,0.3796695559170282},
{-0.6004602037379432,-0.7261284664590457,0.3349402841176653},
{-0.7160310242744046,-0.6468057031970178,0.26256799993212937},
{-0.7665869792016509,-0.6140130531366813,0.18796907696815104},
{-0.7346196950715217,-0.6641927480160169,0.13849872597232118},
{-0.6906123391459399,-0.7216404135864832,0.04785091951156953},
{-0.651178479820484,-0.7578263418198454,0.04081449574151337},
{-0.5666892350561695,-0.8090603624301794,0.1558353002878366},
{-0.9500780727052122,-0.1818713652256369,-0.2535240861845529},
{-0.9386709663508194,-0.2296229760697007,-0.2572355064739558},
{-0.9918376415917637,-0.05437897358337202,-0.11533004792206993},
{-0.9883073128446219,-0.09635760362157873,0.11816880976869189},
{-0.9934390562011121,-0.09861594093189885,-0.057911465258271545},
{-0.9783376441522951,-0.08739298645001667,0.18766438115392198},
{-0.9542664557039783,-0.1197843071573191,0.27391102803101675},
{-0.9384394866397122,-0.11807651430613465,0.32463713078559947},
{-0.9223644854473813,-0.13165690156557874,0.36319446066196936},
{-0.8365667671845657,-0.2850464469328634,0.46787238338388265},
{-0.8445716899040582,-0.1882608615453234,0.5012549337640638},
{-0.8752043267148011,-0.17758680450676562,0.4499781254291895},
{-0.8311349899167317,-0.33216680211859784,0.44595946464495917},
{-0.7097346310249627,-0.5638330126144809,0.4223376462144225},
{-0.6269381827442296,-0.6901794516757602,0.3613873814923675},
{-0.6713642870825778,-0.68221248067083,0.2895792210208711},
{-0.7251158330942169,-0.6267628364450304,0.28526369458355527},
{-0.7508063010613468,-0.5631443484462704,0.3451931938778685},
{-0.6986060479232664,-0.5984958443678936,0.39211262932912144},
{-0.6584220495181969,-0.6105792945150754,0.44008332144916595},
{-0.6970523000411047,-0.7093996036375544,0.10426069904948093},
{-0.6829465096589808,-0.7299205182559666,0.028286073844855982},
{-0.6255390915605192,-0.7794364909694251,-0.0343453268278187},
{-0.5286125061666673,-0.844843711492245,0.08251012953694452},
{-0.913268082962487,-0.16029092674878115,-0.3744972996485302},
{-0.9255268644763431,-0.24255247712595987,-0.29080632553754704},
{-0.968977996998513,-0.1088915897188679,-0.22186541646062685},
{-0.9695012289841977,0.23909179120846638,0.053874691413105844},
{-0.9575458358107456,0.2881441557072593,-0.00888357209975756},
{-0.9554156573476631,0.2760649729334671,-0.10473324407358302},
{-0.970800294262049,0.22459389604334942,0.08428742801146677},
{-0.9713797254556412,0.18006694213622423,0.15491070112626973},
{-0.9568535477376475,0.148607361120771,0.24969409364780348},
{-0.9588883973681908,0.11734972464807486,0.25838359761734836},
{-0.9401267256444151,0.1196317151792668,0.31913945611969907},
{-0.8401048262341263,-0.161362450540902,0.5178668173319887},
{-0.7888280508727915,-0.28963180177985537,0.5420919899371206},
{-0.8160347741846821,-0.17413361779901992,0.5511485557212138},
{-0.8118193893843817,-0.19974112609083158,0.5486827512939844},
{-0.7388960609546705,-0.3907756373573196,0.5489326118510836},
{-0.7350432057750138,-0.4358821035420043,0.5193440838748316},
{-0.6763897605088587,-0.612380734263777,0.4092514241653},
{-0.701128869713347,-0.5902299682301869,0.4000586115277073},
{-0.6880151388509999,-0.6507651078643277,0.32115407999614365},
{-0.669136600427087,-0.6452133929897865,0.3687219650027488},
{-0.6185116066451942,-0.6910981541169975,0.3739341303241243},
{-0.5927955746074128,-0.6640046921190749,0.45573147309541806},
{-0.5808803648963764,-0.6634406932678935,0.47161896504919026},
{-0.5462808148116028,-0.7715592535769443,0.32599630302897553},
{-0.5388844039696791,-0.8345815934650853,0.11435542404067656},
{-0.45656912340233546,-0.889215437974317,0.02899207518903363},
{-0.4022045190667283,-0.9142298541097696,-0.04914568848567402},
{-0.895212405695923,-0.25954971571303526,-0.36225501205835764},
{-0.9582937255931782,-0.13919856027516045,-0.24959346206595484},
{-0.974439033010462,0.19011574831418865,-0.1196853089922554},
{-0.9417130978086761,0.33381805758973593,-0.04173662471502016},
{-0.9153917744367711,0.3923756520165255,0.0899958165589157},
{-0.9426028210829449,0.3210126250417748,-0.09192832126316007},
{-0.93140643664075,0.36316486954777993,-0.024358310912803875},
{-0.9166689018770475,0.39919423678869315,0.01902854819003258},
{-0.9408950338930634,0.3198256956161007,0.11148120747035509},
{-0.9395709549848322,0.28850063093839623,0.18431984835344692},
{-0.8583289035866479,0.4472676437469435,0.25144213673288784},
{-0.8450890935065956,0.18851883541260483,0.5002849915107148},
{-0.7996285661745689,-0.15507916590442894,0.580124649071206},
{-0.7795064420994221,-0.2843104165627081,0.5581552595465169},
{-0.7691788100133018,-0.1987239488034128,0.6073489527433957},
{-0.6926790128526589,-0.2728921590064683,0.6676268828516826},
{-0.6341970296218568,-0.3921707657141896,0.6663304121364715},
{-0.6933254292355375,-0.41189296714271356,0.5913070545780161},
{-0.7084618899250189,-0.5313893754496973,0.4644427652392175},
{-0.6909734859541146,-0.6174788732689088,0.3758663097099521},
{-0.6643489803987292,-0.6544651970022505,0.360992712053823},
{-0.6197004797362002,-0.7216247854412761,0.3085919384098612},
{-0.5090003308628526,-0.7695496256541648,0.3856319966458196},
{-0.48808830708606893,-0.7917420602665084,0.3673068397005423},
{-0.4478232065501852,-0.8672371876344757,0.21760982528129455},
{-0.3448482086077201,-0.93653752596967,0.06306485130923442},
{-0.22867752847666295,-0.9729613985417742,0.03244541442853937},
{-0.22603820858632387,-0.9740732515989403,-0.009382365296303694},
{-0.24129126315211283,-0.9680611714701954,-0.06808887293978844},
{-0.15847176258383053,-0.9723476129498607,-0.1715424730330125},
{-0.4377002045314773,-0.8973904893483948,-0.05575697786063531},
{-0.3417818229475991,-0.9371304409981537,-0.07051043934923582},
{-0.1815956390557203,-0.9832478280960358,0.01570771849674333},
{0.005695872580824759,-0.9931336742622195,0.11684631822169941},
{0.15884749499192305,-0.9440952958430914,0.28887981186254075},
{0.3210932929443598,-0.8450905780884554,0.42745878403919585},
{-0.021022572124646813,-0.9526095831909458,0.3034683401510555},
{0.46023814335563923,-0.8168882207392358,-0.3476700824316633},
{0.6434550975018933,-0.6909595061784272,-0.3294548502002859},
{0.29398721289794244,-0.9548092282558859,-0.04371334224123864},
{-0.7160791550839601,-0.29788212910961054,-0.6312660935068245},
{-0.7700315263154904,-0.295913839812106,-0.5652313224582404},
{-0.8010029099827742,-0.28989311262140094,-0.5237903411230521},
{-0.8467309475380991,-0.2742687052939138,-0.45587649618908116},
{-0.9325580348749661,-0.13550754822923908,-0.33462399191188},
{-0.9756192681912542,0.15959530044396353,-0.15065318984396794},
{-0.9471827734160557,0.30840977054338514,-0.08791022225683007},
{-0.7992481630675632,0.5985551529138177,-0.05416735874530207},
{-0.8073644436125426,0.5900511945177519,0.0014976776634775734},
{-0.8020213861613488,0.595326413434775,0.04845779201238974},
{-0.7429242191385249,0.6350692673786444,0.2115434476616205},
{-0.8010550714108794,0.44389585457016506,0.40158092940568507},
{-0.773192510813115,0.2145455187610772,0.5967776483767228},
{-0.7506169655347954,-0.12474415432683528,0.6488551972610056},
{-0.7278486122867887,-0.28902575664727814,0.6218524821745625},
{-0.702183645259118,-0.2638377720794305,0.6613076125032732},
{-0.6044608943599492,-0.3522657833189727,0.7145179109667167},
{-0.6744967096116297,-0.3109431810854267,0.6696032607892229},
{-0.7018616506177797,-0.3481269281410374,0.6214482000095992},
{-0.7300842645005082,-0.4803166473412389,0.48607909337434363},
{-0.7074728435181752,-0.6100988665793905,0.3567373665357342},
{-0.6417882544529687,-0.7211810554823296,0.2607790667588267},
{-0.5164158165304091,-0.8036143470820496,0.2958355718995301},
{-0.4636239476699735,-0.7990351376189712,0.3828781581614986},
{-0.3796601382291711,-0.8337292133641687,0.40094111565536783},
{-0.3265170999950825,-0.7870984183380614,0.5233188925125133},
{-0.44179911409999456,-0.8138574970656589,0.3774248498052043},
{-0.43890092156688315,-0.8856389240542977,0.15168941046654102},
{-0.36039961225437905,-0.9321172274691326,-0.035631358971423756},
{-0.29991296426369135,-0.9539336581084138,0.007924001165159114},
{-0.45903260845713423,-0.8870742445047897,-0.04887073878402103},
{-0.30263914922697716,-0.9530464216335695,-0.0105860080587436},
{-0.012358760771042688,-0.9993648792450164,0.03342303343202032},
{0.16533469431974065,-0.983582296883813,0.07232084147021854},
{0.3596803685532955,-0.9316500707661081,0.05155752242758943},
{0.4998519032304847,-0.8653914804006687,-0.03529391571930081},
{0.5736168004664339,-0.7918080361655414,-0.20977082753881665},
{0.33250682379319263,-0.7013010897606565,0.6305679928695067},
{0.12309412272260384,-0.825741755722752,0.5504528951754725},
{0.4535820911262163,-0.8405867210138682,0.29610344656001875},
{0.5698667962849215,-0.7786994209616372,-0.26244817828663014},
{0.3314730367375799,-0.942065991982483,0.05135457784879217},
{0.3427461801209137,-0.9390961037382046,0.02497126260815269},
{0.0010834604097184522,-0.9185866950742192,-0.3952180534162934},
{-0.33371866451138904,-0.6713787058842815,-0.6617268970216356},
{-0.5263242119877074,-0.43286151936848033,-0.7318563581233203},
{-0.46329552207127184,-0.425505256987223,-0.7773689828549536},
{-0.3459097113092042,-0.5870839800433664,-0.7319008621380515},
{0.2597759919923309,-0.5994189404507396,-0.7571085574825536},
{0.39785339847431,-0.5281426088553571,-0.7501853491197352},
{0.540850856765028,-0.6942064873365638,-0.4749291564816423},
{0.8339214506146876,-0.5506683762485595,0.036597180280316104},
{0.6551084598390057,-0.6669823039188385,0.35491902190004393},
{0.40850693235711144,-0.5610905879492911,0.719930162120536},
{0.3794699045265067,-0.5165438268963071,0.7675839149265452},
{-0.06164764330010519,-0.4499784918600966,0.8909090441447185},
{-0.8793626617705692,-0.2499276472143734,0.4052869110169574},
{-0.3273866948913877,-0.9221531276409272,-0.20603776641710447},
{-0.3735442633591896,-0.9046572241002334,-0.20508532418166947},
{-0.5454372636179455,-0.8361229815293699,0.058279938361366246},
{-0.5426630644360025,-0.8226504338439983,-0.16959676351041708},
{-0.2887802254130725,-0.3633232258132251,-0.8857777458228714},
{-0.15320500870476955,-0.2792882576855593,-0.9479062687981001},
{-0.07989742476368249,-0.08795961416438977,-0.992914652823788},
{-0.03195376167880876,0.045602502910016045,-0.9984484808155681},
{0.059162603191695064,0.004274674197843134,-0.9982392065753},
{0.884942932679825,-0.2658496671316876,0.38236103408428224},
{0.665613463382624,-0.093935181806536,0.740361330015798},
{0.9411652340371338,-0.18916332562238455,0.280045065086509},
{0.7641411740349076,0.035660109509187535,0.6440625922488792},
{0.5702199972091299,0.2559102471328639,0.7806145657078251},
{0.6698557370402919,0.21553135993940561,0.7105206009940019},
{0.5572366751172143,0.3117447841316892,0.7696119005518293},
{0.6486608570698397,0.17052159558635457,0.7417287091276061},
{0.6856384223447196,-0.10728164404519629,0.7199934740368165},
{0.676714654044413,-0.6027918441078548,0.4227283639390692},
{0.7511485422541805,-0.5554129013141327,0.3567805719531784},
{0.9322832402060005,-0.2606677085152159,0.25079933366822776},
{0.9951664401322464,0.08779099449776173,0.04400565554114966},
{0.9766957110374578,0.21461792517731712,0.0021527270190441804},
{0.9852225525986822,0.1712780612156349,-0.0005895737019446527},
{0.9704181583091667,0.23383779907153984,-0.06007063966051383},
{0.9673399978940141,0.24812080413659662,-0.0518593774453327},
{0.9615021731304194,0.2601240539671227,-0.08859485094061727},
{0.9417313193440968,0.23117329630856007,-0.24433794064831915},
{0.8829343326019635,0.2017610791972138,-0.42393328630092386},
{0.7894324327350699,0.20665927651595198,-0.578003786817952},
{-0.6851276189032359,-0.3114375805310194,-0.6584882529316428},
{-0.7396181249131178,-0.29438954770606,-0.6052270842431169},
{-0.8023299980529255,-0.15651801295166248,-0.5759936508730421},
{-0.8616344897608769,-0.16929488666207032,-0.4784613332387375},
{-0.8962509980703397,-0.13611335001483799,-0.42214606998722387},
{-0.9469241534243986,0.14133525298796684,-0.28871957662118036},
{-0.9128884469679804,0.3680855367338731,-0.1764871696178659},
{-0.7386887771737848,0.6432081582325251,-0.2015493876463574},
{-0.6174451580714748,0.7640175588088918,-0.1871861282408322},
{-0.706002152950696,0.707540774793999,-0.030773560614423438},
{-0.7020755317318476,0.7120940616844778,-0.003463388102232624},
{-0.6829350367595262,0.7280886865280771,0.05904743953876482},
{-0.5822247388739271,0.7827991811391204,0.21963559695802992},
{-0.5911657366162231,0.7235082185420277,0.3564532641920109},
{-0.6941772158837826,0.5203795391961881,0.49731592386912704},
{-0.6868802338149499,0.19949347959539696,0.6988547030629761},
{-0.6847033198398896,-0.0855620834221833,0.7237820760979711},
{-0.6511649348754518,-0.27528798533914856,0.7072487205478433},
{-0.6475069747536869,-0.3063915287702008,0.6977527848337027},
{-0.6931077524926265,-0.3030433545640885,0.6540385070385107},
{-0.7906242345713324,-0.2168220180999674,0.5726268699384899},
{-0.7091985140651457,-0.2672379055640799,0.6523966350905813},
{-0.6823074681488271,-0.4164154842614368,0.6008782433868365},
{-0.6481701501441738,-0.45802564425295433,0.6083485560669519},
{-0.581851094084809,-0.5731996828084889,0.576967440970943},
{-0.47608485495390185,-0.7510230532270901,0.4575014583637758},
{-0.41350073510000496,-0.8336674887929397,0.3660814939346555},
{-0.44222227436393396,-0.8233041634696674,0.35582258847619663},
{-0.45153587399052475,-0.8474731255276117,0.2791140555544884},
{-0.34005948473165476,-0.8754976266685339,0.34331247070534127},
{-0.23440486540401623,-0.7177665215738984,0.6556413498114891},
{-0.3848788976041816,-0.8767178033397056,0.28850325385719844},
{-0.38352317851916423,-0.920352777671341,0.07655544507874214},
{-0.5980405591732328,-0.2558392057251963,-0.7595352463168958},
{-0.6597453144566308,-0.27700964743760065,-0.6985712385140241},
{-0.7542558802986249,-0.13864585870495946,-0.6417751887529703},
{-0.8259039695473159,0.19873385874092403,-0.5276243801000183},
{-0.9091607599732738,0.14942329955046418,-0.3887150499739773},
{-0.9540270793329237,0.11236391864523756,-0.2778609034862189},
{-0.8917087393506624,0.3684610522866597,-0.2628535278695341},
{-0.7892909802868124,0.4766129661231885,-0.38711733229234124},
{-0.6046506290832261,0.7199911552229454,-0.34060292592693237},
{-0.527998975193649,0.8058439745149907,-0.26801599006839},
{-0.39836754985787143,0.8984869726190594,-0.184457190844038},
{-0.480610391197935,0.8763981346427037,-0.030658791028954906},
{-0.47845793558045024,0.8777278941673032,-0.025918095623038807},
{-0.44396329577440063,0.890967461050714,0.09525531667039029},
{-0.4801760482957486,0.8299567748663802,0.28390617199433255},
{-0.4730640541494987,0.7676565210328938,0.43233536333188644},
{-0.5815665988359832,0.5901929335726788,0.5598683704936566},
{-0.6503655436064688,0.264810972634287,0.7119689659401914},
{-0.6260150695518816,-0.06298984633454263,0.7772627689222632},
{-0.559485221242399,-0.2498194907875427,0.790295203853596},
{-0.588868741031088,-0.27944242140925024,0.7583835038774224},
{-0.6831679472606884,-0.2255860921462151,0.6945447939951869},
{-0.6082691962309421,-0.37509439366307706,0.6995089568826781},
{-0.5183302316988302,-0.33607160727107366,0.7863775465342804},
{-0.5271501606415072,-0.10102988353844278,0.8437450271070293},
{-0.5517580097260324,-0.33774722592143497,0.7625548570991747},
{-0.5162179315269362,-0.47808596046965857,0.7106003529212854},
{-0.5031557725856873,-0.5367570460436845,0.6772932467079219},
{-0.5130828050898029,-0.6927598747025006,0.5067837715666862},
{-0.5732205430122829,-0.7608536299145114,0.30417094357386465},
{-0.6345073364859997,-0.7629169610281851,0.12392800539410434},
{-0.6193372386581497,-0.773635854398384,-0.13382432365074923},
{-0.4419243640313389,-0.8871403105285299,0.13298468299334362},
{-0.37707596286504386,-0.8714328482944838,0.31371724393594186},
{-0.22734365196257403,-0.7172142915563559,0.6587249227861615},
{-0.29792429688686806,-0.9092832369601419,0.29059440515562507},
{-0.3258983141944084,-0.9433667852786272,0.062043510847720626},
{-0.13624061577127417,-0.9905845867019178,-0.013441398842922428},
{0.0719481104614476,-0.9854504056254846,-0.15398365969672045},
{0.22668222397595433,-0.9475483657211492,-0.22531592032631514},
{0.3731284894626303,-0.8615373692441812,-0.34427967083049094},
{0.4026201725120532,-0.8181610272354095,-0.41049912326272253},
{0.43988808241279975,-0.7772747633521089,-0.4498248739310809},
{0.39203537606604133,-0.8772249360873667,-0.27710047892285},
{0.2747697099015279,-0.4997219389186291,0.821449688224444},
{0.48972010566150787,-0.5901986113794683,0.6417474715467363},
{0.3564996625259032,-0.9322809488273504,-0.06132065779566013},
{0.09948817468198361,-0.9919175105354322,-0.07875122469928952},
{-0.1988776174504121,-0.9799617182753004,-0.01107808612389386},
{-0.34030998252718425,-0.9227644155891465,0.18081744693134236},
{-0.226029458584615,-0.9640010863288092,0.14004495495669142},
{-0.025297523157616932,-0.9992557474130755,-0.029120209202984974},
{0.23218316524715574,-0.9680223752469602,-0.09499294077480419},
{0.6424993822145681,-0.6378502797804076,-0.42466641548155654},
{0.8654707047859098,-0.29636721187455123,0.4038897558531106},
{0.980524636495437,-0.16380623787436263,0.10834645199054208},
{0.8974865337733771,-0.3644150270727726,0.24843431674991928},
{0.8030657306660498,-0.48102222659736893,0.3517144434752616},
{0.2725099116382383,-0.42810353689264047,0.8616644995350169},
{0.16479910083799462,-0.9861990956881599,-0.015893395698981044},
{-0.17265322289697646,-0.5814703371231836,-0.795036547379514},
{-0.4481293437428826,-0.15935177543927842,0.8796516941045036},
{0.06088827217692045,-0.4005464037378703,0.9142511672204571},
{-0.5585717446675953,-0.7293281694901292,0.3950671173954828},
{-0.862077961572641,-0.4485885630020978,-0.23577508204743153},
{-0.4499688558072846,-0.27314317911044644,-0.8502475124979325},
{-0.16301824540265092,-0.10298734517553913,-0.9812332334361366},
{-0.1355615897714578,-0.025377527786672058,-0.9904438583090269},
{-0.23748418565939533,0.08761677601138836,-0.9674319418558931},
{0.8131324550287911,-0.04448970897534109,0.580375978460636},
{0.8893257980513984,-0.3976822514829003,0.22571763727217822},
{0.9772806115648647,-0.09818466072796465,-0.18783604195451578},
{0.9350338451743574,0.18201015425349334,0.30427621025488544},
{0.9484921527480251,0.025116098915959426,0.3158034479714568},
{0.6801378354784081,0.27897207473287305,0.6779285406810823},
{-0.5650424986951812,-0.2534488199415023,-0.7851691985416686},
{-0.6701147787521553,-0.09433209815224143,-0.7362388461336077},
{-0.7518460064565542,0.18469705905555867,-0.6329412128717472},
{-0.6853424668338604,0.5257967202572664,-0.5038288520130431},
{-0.3857713931477352,-0.12239907557032423,-0.9144391169063064},
{-0.3681231693204598,-0.1549628828685404,-0.9167725111185059},
{-0.3912899239553068,-0.1721621295754621,-0.904020130611643},
{-0.47107859097913474,-0.21703665196302688,-0.8549737146987579},
{-0.6102451172522212,-0.058860478157337186,-0.7900230002860121},
{-0.6691669891521637,0.2500351377500259,-0.6997842314023327},
{-0.5639556539943642,0.5902613467473942,-0.5775340361084718},
{-0.46855152607938944,0.760322852228993,-0.4498540071923825},
{-0.3132694439296444,-0.10076399140012192,-0.9443033800305534},
{-0.33975846137167404,-0.1349703418382103,-0.9307777364926759},
{-0.393835613346866,-0.0023384419898979047,-0.9191779160471372},
{-0.4717381877084286,-0.028446290098509103,-0.8812796893365913},
{-0.5416353712246265,-0.03720991502228164,-0.8397895848737325},
{-0.6427022027474946,0.2777353861670826,-0.7140006539591821},
{-0.5009644031659227,0.5947676052967742,-0.6287178719029319},
{-0.36110030038588126,0.7913048872014571,-0.49339958304838055},
{-0.3016075919591008,0.8718592051321189,-0.38586835436327543},
{-0.4153573546992209,0.8510814204487441,-0.3211521191962053},
{-0.27112855591235147,0.9348547111918613,-0.2292072754762914},
{-0.24798561647937734,0.966152980149976,-0.07107427781316863},
{-0.26629274509518946,0.9638799833583256,-0.004852998127211793},
{-0.22297860964987887,0.9704144039708454,0.09260898554954423},
{-0.3742700702302589,0.9049553807149001,0.20242942830771185},
{-0.3688467687662447,0.8594112667503114,0.354068264256097},
{-0.3335810382880553,0.7923954890087648,0.5107182000802631},
{-0.47555063245795465,0.6250277039608988,0.6190250118130983},
{-0.6079435605215033,0.2972174595482839,0.7362515935195669},
{-0.5501730462568601,-0.045093818155396564,0.8338322173774619},
{-0.4516018457529875,-0.222449591738279,0.8640439526135045},
{-0.5216159357248776,-0.21667132135324607,0.8252092789716428},
{-0.5709198305829459,-0.25950969266375284,0.7789128747560313},
{-0.4751722127590772,-0.4759736025547857,0.7400408758255596},
{-0.5193509408452405,-0.5255099710167674,0.6738797152349372},
{-0.5759859704237529,-0.21417841857822548,0.7889028881239681},
{-0.5760834402567354,-0.19622344256313057,0.7934886454453134},
{-0.5604941872078127,-0.3641266133572856,0.7438131993660821},
{-0.571871794627733,-0.4995133054357181,0.6507296736755892},
{-0.5661004514644259,-0.49888699345620297,0.6562332257757173},
{-0.5706946418590155,-0.5765327659127593,0.5847372021535773},
{-0.5965356402093578,-0.6690117474068412,0.44336047612710866},
{-0.5705047816407666,-0.7685661275055707,0.28953480235735424},
{-0.5185317843422264,-0.8477559419062698,0.11151076893950783},
{-0.5487927797814454,-0.7719426043811533,-0.3208287711552632},
{-0.4838385709433031,-0.872530743823771,0.06775203576188071},
{-0.382649736949547,-0.8811458024357005,0.27777914547782045},
{-0.1985256984356523,-0.7988179181370069,0.5678710071168404},
{-0.17352850234633488,-0.9637161806629121,0.20282746855869246},
{0.04171063694041573,-0.9988197383999087,0.02488680270269236},
{0.22617740119927437,-0.9537743983446514,-0.19788425973038085},
{0.34223544961761776,-0.8991770016344071,-0.27268226337036455},
{0.13291202023346552,-0.8683159620732547,-0.477872142823012},
{-0.15088761637976636,-0.930030627503498,-0.33507604976882843},
{-0.16206793760331026,-0.680785678907104,0.7143282459737982},
{-0.29612962410361576,-0.5803048667798567,0.758652428533557},
{-0.16227820859007014,-0.8906521749943621,0.4247404927654178},
{-0.20357802416993465,-0.9129822883652182,0.35358072516255035},
{-0.13976910838180617,-0.9166872296574355,0.3743649547235038},
{0.09043075509965001,-0.899394127616375,0.4276826881477513},
{0.3573400812301663,-0.8123006202075059,0.460950939642083},
{0.6903118597073737,-0.5956344568308833,0.41071782306484544},
{0.9319752127065399,-0.1864298056969798,0.31091177277225474},
{0.6924121271285586,-0.2602402185356364,0.6729342277383645},
{0.8973613248969157,-0.3780723585915764,0.2276047983858307},
{0.6979353927635411,-0.6170628975304159,-0.3634825553164403},
{0.6902931842679026,-0.6490082307319525,-0.3198181298729954},
{0.5114173035551066,-0.3964486010550404,-0.7624177649726724},
{-0.367453776556548,-0.3841010419154372,-0.8470207268383733},
{-0.2846297893068258,-0.3870623672553754,-0.8770225806065752},
{-0.5340074703106183,-0.8386788905979679,0.10702214779108057},
{0.0011727873404112808,-0.26624177086562195,0.9639055679972969},
{0.11838933315448294,-0.12426027286240783,0.9851615859255765},
{-0.5899387050967378,-0.2591876087447065,0.7647183191881733},
{-0.5066434375043888,-0.0966147461083039,-0.856725170675033},
{-0.13917602888808261,-0.06920935051192112,-0.9878461918662549},
{-0.2378526489702403,-0.013519394050580395,-0.971207157800201},
{-0.13626467513073334,-0.016681056644817872,-0.9905320189982392},
{-0.020432598057559054,-0.34115369013118835,-0.9397854375582179},
{0.6752318324481121,-0.7320971089067039,0.08997663907487731},
{0.12813318717306532,-0.36051159257483195,-0.9239119427543031},
{-0.4450411120256414,-0.3744923194745668,-0.8134457027125657},
{-0.2918312254692824,-0.10806838708735376,-0.9503450739354808},
{-0.3163212171792,0.041691678923609324,-0.9477355598851401},
{-0.36937577374317987,0.44510791514417786,-0.8157453534330615},
{-0.5127836853212518,0.3600654789261483,-0.7793623951372294},
{-0.566169342761262,0.3491675911897605,-0.7466821737392831},
{-0.3839089681728755,0.6467991904623254,-0.6589876412905773},
{-0.23433183577590982,0.8148069200168526,-0.5302624575005687},
{-0.2307269579582243,0.8841010741399986,-0.40636235255722747},
{-0.18992735986684925,0.938567076080916,-0.2881309453545872},
{0.2808738422698038,-0.14757962078773842,-0.9483301852502347},
{0.18994856178615305,-0.011195598263460844,-0.9817302085883347},
{0.12112573234873676,0.15171605032700122,-0.9809744120190684},
{0.059347263999559925,0.1466558745714433,-0.9874056697778535},
{-0.0057965902731254015,0.1420989671371044,-0.989835482835291},
{-0.07494777731648931,0.12253443035910778,-0.9896303067569662},
{-0.1543269146149439,0.1115897000961092,-0.9816979893316947},
{-0.2514412253243109,0.07926742981026634,-0.9646211612745615},
{0.2065118838896528,-0.029644211093758862,-0.977994919496505},
{0.13410005423964586,0.15475287784731523,-0.9788098498947065},
{0.07948183492267033,0.3481884286075942,-0.9340489580857632},
{0.037919226637609986,0.40001721036115684,-0.9157228640074919},
{-0.001703548869085644,0.36399983112629036,-0.9313974559023032},
{-0.04500961220437603,0.44980283215716604,-0.8919930195873754},
{-0.10633928888837252,0.4225769770151168,-0.9000670275793247},
{-0.1738558751797863,0.4605912354384461,-0.8704193520957334},
{-0.27667591858031654,0.45819607617546143,-0.8446933123063948},
{0.16882042562004937,0.14235959845186694,-0.9753119545161376},
{0.11791675098668451,0.3878380531840907,-0.9141538625084504},
{0.04796926643320472,0.6176445718296598,-0.7849930779103828},
{-0.004002151069521586,0.6450778733188084,-0.7641063539464256},
{-0.06452125282125615,0.6659573140896805,-0.7431943647154722},
{-0.13951834422069007,0.6793224385310236,-0.7204551728832133},
{-0.24827255602439546,0.6847939548273569,-0.6851408449049154},
{0.17919755233780874,0.141729829647629,-0.9735506625873109},
{0.17581752010621823,0.3559467300278506,-0.9178181328597622},
{0.10521826364686038,0.6054161655098506,-0.7889235600072348},
{0.0754296338101136,0.7361035948582669,-0.672652858449296},
{0.03208211845634838,0.7688140685530743,-0.6386671008203114},
{-0.015941261047573093,0.7853127940662025,-0.6188939260262194},
{-0.07745078518703108,0.8042665434007624,-0.5892000534963502},
{-0.14128206080403977,0.8051474304224909,-0.5760008633492},
{0.26698453339204287,0.1716927338852198,-0.9482831138749925},
{0.2375348467677836,0.3514846782547518,-0.9055582353019376},
{0.17024367853742886,0.5665356116356715,-0.80625956779851},
{0.12150283118103412,0.7597282562192131,-0.6387879450311399},
{0.07574258378398609,0.863057668956958,-0.4993941540069404},
{0.015959458074724476,0.8756923174141645,-0.4826056992201511},
{-0.005254582581604998,0.8829231749640123,-0.4694880791600159},
{-0.08753008523159199,0.8989211601893188,-0.4292775698114673},
{-0.1347817172560392,0.8892433313245397,-0.4371271970357688},
{-0.09553304117053528,0.9450028341954131,-0.31279878741348366},
{-0.09019833404813386,0.9735392060481289,-0.20996588966334506},
{-0.16787489524563406,0.9766028751634784,-0.1344055198594708},
{-0.051305312011344396,0.9986830152553005,5.95175556476789e-18},
{-0.15475917050657573,0.9762065116868769,0.15188958385701085},
{-0.17203006890030617,0.9467486022628924,0.2721630752093598},
{-0.28928720380765466,0.9220005822017672,0.25734770279283775},
{-0.30829757272727604,0.8715847548173454,0.3811726929102579},
{-0.23704060619965753,0.8128477420925352,0.5320623076177883},
{-0.2587163209362253,0.6836773299012951,0.6823863816491793},
{-0.3712735166101992,0.6330925762587764,0.6792273299492017},
{-0.5055622212213715,0.3774067538997209,0.7758678899043242},
{-0.4676315428317126,-0.022417055302327255,0.883639188685294},
{-0.3801251671385309,-0.1940226895837243,0.9043561539761875},
{-0.4841427676150474,-0.1685965103805754,0.8585924511976184},
{-0.43009302159861584,-0.32973114037773216,0.8404149973896068},
{-0.548085483348812,-0.3702638810165972,0.7500046408901923},
{-0.5453027001297716,-0.3996629831837149,0.7368272966604005},
{-0.5618199226583267,-0.4148965134152131,0.7156949473484437},
{-0.5740498728991245,-0.26554234160599705,0.7745669811184202},
{-0.5055918052338122,-0.32652062160804785,0.7985995305189636},
{-0.475559506505019,-0.34259305212448177,0.8102303107195724},
{-0.45708864632080837,-0.4947491107793037,0.739116558323313},
{-0.4349822913954063,-0.5342745068718389,0.7248042201030945},
{-0.4306847236956775,-0.5747081104564042,0.6958600840332828},
{-0.41329465474659527,-0.7112182499078288,0.5686441148521083},
{-0.39012597476730093,-0.7387480853405493,0.5495934772334329},
{-0.39345472579762897,-0.6633281247785392,0.636544717694915},
{-0.4295750715958758,-0.8867105382482897,-0.1709083942433086},
{-0.33442020088957164,-0.7240405801903904,-0.6032647573615927},
{-0.41203672617094567,-0.9110565705203579,-0.014200760473061538},
{-0.2528723282812117,-0.961613063033001,0.10656407740851864},
{-0.18137410560694028,-0.9819760970742595,0.05316369616652805},
{-0.18937174480336566,-0.8690932343343454,0.4569631191949694},
{0.28120473278960134,0.19153646272534783,-0.9403391312198969},
{0.26493179640091846,0.3419566562143457,-0.9015967993102493},
{0.21563771205864896,0.5163131543409357,-0.8288070365245604},
{0.21096821303067,0.7538693747169934,-0.6222325762562219},
{0.15376192275849368,0.883391246782344,-0.44269309483879077},
{0.06103216424780846,0.9512531447315029,-0.30231197390387127},
{0.011132905842265176,0.9519492738856585,-0.30605332600067364},
{-0.015964012446049797,0.9473424188045592,-0.31982415768692285},
{-0.07546301199936141,0.9505028408774543,-0.3014128121096928},
{-0.04859157833392727,0.9709518828901665,-0.2342889233981371},
{0.3134377269679133,0.182636058817419,-0.931880282725645},
{0.234961703591618,0.33318796095295594,-0.913114878052776},
{0.24417109605882137,0.5459054907771004,-0.8014784282741781},
{0.29516478658648315,0.750813156482212,-0.5908953822907852},
{0.23810034904140634,0.8849209894873828,-0.4002787355718912},
{0.1565195278563011,0.9492156608052069,-0.2729308826090865},
{0.08525674362663908,0.9939759640317828,-0.06886995421277285},
{0.030679532709904773,0.9839271030051877,-0.17591538376310523},
{-0.005487520053884074,0.9764653842617387,-0.21560436095365354},
{0.09250477559932928,0.9956755776704969,-0.008544619467257007},
{0.0824489481901155,0.9949210063737196,0.05774393490790794},
{0.03885017580344004,0.9862218625782535,0.1608014353565362},
{0.0009372723412512967,0.9769622146371709,0.21341029190691033},
{-0.05485240838621108,0.9712931385244022,0.23147538173561447},
{-0.07822774982896583,0.9725670296503547,0.21907485477293587},
{-0.09787554134037614,0.9478905127755144,0.3031896340535087},
{-0.14882503190613944,0.896933503587987,0.4163669055286638},
{-0.22681345888796664,0.8809138479461393,0.415387105437811},
{-0.1377561153503461,0.8166083539495388,0.5605123093593993},
{-0.14594417366947246,0.6926955761410425,0.7063095192382474},
{-0.22920059702408374,0.4608381907261243,0.8573769581065704},
{-0.30839933203153164,0.4542550171462997,0.8357883891272481},
{-0.42101259126776913,0.3861584572158984,0.8207496840783038},
{-0.3688178188894883,0.001651194189143338,0.9295002367010726},
{-0.35908649854555746,-0.1614640428236772,0.9192313361919976},
{-0.44755978287527887,-0.14348530062929488,0.8826676663705055},
{-0.4656427061751369,-0.21327858734339894,0.8588883014494372},
{-0.5131749726165025,-0.26950870790367604,0.814872078208686},
{-0.5073845813300062,-0.3882226966142588,0.7693139960134142},
{-0.4564994181140163,-0.4016854301708796,0.7938873323400494},
{-0.46300016470211436,-0.23813094974970656,0.8537707527534061},
{-0.3721046442955658,-0.3355664201252784,0.8654093316910649},
{-0.31760364292564475,-0.29732157274763654,0.9004042472019061},
{-0.2979182379758228,-0.3607112719796284,0.8838167806441669},
{-0.32974306391061947,-0.4203257016236933,0.8453376936806895},
{-0.3401376203124445,-0.4776486982499665,0.8100358759390227},
{-0.33338402964154557,-0.6547932437122244,0.678307376319017},
{-0.19631919639877407,-0.7581252139581769,0.6218560388757256},
{-0.2886840175267977,-0.8601750758944937,0.4204288011476966},
{-0.33693446746923805,-0.8279868023655285,-0.44823322025450996},
{-0.18955974889006377,-0.5943991850719593,-0.7815092516320753},
{-0.328374008482412,-0.9434650394167652,0.04521316126433177},
{-0.28699495967231986,-0.9442685861394612,0.16121640844798057},
{-0.28241198975715376,-0.9544768737663524,-0.09600711164604304},
{-0.15806915431039914,-0.9817153033971624,0.1060622719510221},
{0.29402198739791624,0.3604374345104636,-0.8852321315508688},
{0.26823895056958563,0.5411659916203433,-0.796986345498402},
{0.3490030829415473,0.5659074900460389,-0.7469575361471947},
{0.33993387887782206,0.7575573166128335,-0.5572718098355965},
{0.2727620321115862,0.882744031504672,-0.3825752849848467},
{0.16134930029645872,0.9583320186644837,-0.23572472355758312},
{0.1570283371000571,0.9661832342292467,-0.20452887141404652},
{0.25246780461077856,0.9547346097385245,-0.15729536739027286},
{0.27304366553909754,0.961720794630198,-0.023243706348899083},
{0.2504427916553397,0.958895971904108,0.13340510924981944},
{0.18672661983849695,0.9612889722944349,0.20262448319193468},
{0.15647090906075553,0.9537502412547668,0.25666579811921736},
{0.14716075702924064,0.9516967991386567,0.2694752569343172},
{0.07558212200314343,0.9544913390202115,0.2885023857248074},
{0.02279268096158263,0.948868141323721,0.3148487638143918},
{-0.01926846857765847,0.9471440995362967,0.3202292629230649},
{-0.05015140855970978,0.9519012773150853,0.30227271538361855},
{-0.07358104099585881,0.8850909947331302,0.4595647521821965},
{0.599778659835762,0.4818320311144617,-0.6388297527492984},
{0.5230511265017801,0.46184937369534296,-0.7163188361912859},
{0.45623183149312946,0.4124052302384382,-0.7885267541462404},
{0.44186469118765503,0.42190520511818447,-0.7916764443734706},
{0.41310265754076214,0.38675024982637535,-0.8244819213251411},
{0.3776592370247626,0.3455490996127012,-0.8590514073364444},
{0.9705084522913873,0.24106507853065998,0.0009858721939040229},
{0.9049411329464866,0.42077587114139314,-0.0634760755460761},
{0.8950141357866845,0.4369042313391916,-0.08980194530144979},
{0.8747214745224343,0.4754706449841009,-0.09375504129219546},
{0.8317386344650732,0.5226017953535383,-0.18734515587928502},
{0.7712794167418049,0.5321913105372615,-0.34914247850849267},
{0.6775744881176714,0.48531545021536154,-0.5525954459044488},
{0.6006010349614355,0.6840895401605112,-0.41388391832279847},
{0.5253616902004804,0.6338391468370979,-0.5676645403814776},
{0.44628824009867163,0.6147450464136778,-0.6503194097206968},
{0.4016786001993906,0.5966408800978413,-0.6947474090185091},
{0.9007058256831064,0.4344254617894134,0.0018798216852377824},
{0.8251261508344294,0.5586423257922288,-0.08417592911639184},
{0.7747607629678126,0.619936851573932,-0.12419364003898736},
{0.7716283918856993,0.6131761196003788,-0.16912915534499595},
{0.7047154166150578,0.6639934321726315,-0.24997780624822366},
{0.8198074865191539,0.5726010800352571,0.006609704199462354},
{0.6167199534825262,0.78718193826747,-0.0010464425353637413},
{0.5920983737054097,0.7958514989002915,-0.12664875662069597},
{0.49339214192239156,0.8212378119760577,-0.28658794543736804},
{0.4449924788070186,0.8145027919017918,-0.3722457465027258},
{0.376380271758538,0.7877037162508889,-0.4877096948344461},
{0.4339805534519792,0.9007931994896954,-0.01524765485678521},
{0.4048199035025382,0.9027021443002401,-0.14577271488157165},
{0.3832836832414554,0.8932729418058155,-0.23485542275716773},
{0.41062850267095236,0.9058939856680138,0.10363551285506346},
{0.394219495446339,0.886420845783268,0.24258827995373058},
{0.36407434559371576,0.8841243801875976,0.2928719024392815},
{0.28653040828331694,0.8836528998857477,0.37021328670444076},
{0.23595961248618255,0.8840790456672415,0.40339472268173004},
{0.1903795159498646,0.8771564806937667,0.44085388541286635},
{0.07683143287998079,0.872580861019903,0.4823894400827758},
{0.024162133731705435,0.8817409751103854,0.47111468254016237},
{-0.008821516371914783,0.876887591233103,0.4806145370151704},
{-0.015980077388450285,0.7708684489460392,0.6367939003682328},
{-0.06092013016220679,0.768579707384855,0.6368468977212892},
{-0.04986753200476167,0.6706219833678746,0.7401211959371872},
{-0.11999208399588614,0.45958974393688623,0.8799881630149076},
{-0.2503355108199686,0.07046058529176104,0.9655917553204604},
{-0.30975828016898077,0.03158963855390668,0.9502904306593795},
{0.3527035440155994,0.8820350356415093,-0.3124330423302208},
{0.2788824317231845,-0.10424838586282018,0.9546501261305945},
{0.5701681972915846,0.001060763370655444,0.8215272981333828},
{0.42105402906306943,-0.14865042517279248,0.8947717897350721},
{-0.25821105389641785,-0.8746664886169269,0.41022626114893773},
{0.15494481490688694,0.8150663053121616,-0.5582642942892306},
{0.015204149960469175,-0.8441726657806461,-0.5358557120837447},
{-0.08773763943765109,-0.38501436994377697,0.9187306686742884},
{0.011996312315360972,-0.2941674894098455,0.9556785948555826},
{0.5487133739351978,-0.31750002437564484,0.7733740154583142},
{0.7529445419437394,-0.15433896252478815,0.6397296314881034},
{0.8266432766941785,-0.3650691307660933,0.42823524242873934},
{0.8884920551786322,-0.3687141260383222,0.2731881423931989},
{0.7356512494692108,-0.14526497084970183,0.6616005799562333},
{0.5088551460644993,0.11838013089792,0.852673785765851},
{0.35299810479843674,0.0731475736880858,0.9327602963635717},
{-0.1550880150435008,-0.9742047874555352,0.163929069077398},
{0.43287314702762214,-0.45786975207638947,-0.7765153757112013},
{-0.20685158075545748,-0.8721850910521529,0.4432895109128078},
{-0.2585842269069161,-0.8299671920804245,0.49425566022564504},
{0.514731377044314,0.08581163944855456,0.8530462894950166},
{-0.044669325544673,-0.7163978554024221,-0.6962605576436126},
{0.2852009692360895,0.423156290861499,-0.8599995120063346},
{-0.11316991726187668,-0.8334535285731758,0.5408768672589561},
{-0.13652474007430251,-0.8377934203992937,0.5286427717119534},
{0.6272419540194943,0.08033059058768123,0.7746705927900198},
{-0.06248434557919803,-0.9760054729540769,0.20858816678140663},
{-0.2490654185332513,-0.8696799870394962,-0.42617266152797506},
{0.7856934007270918,0.07125247357500278,0.6144989544851488},
{-0.134661513972015,-0.5508083578507518,-0.823696806826713},
{0.36582051574289715,-0.10158422636590717,-0.9251248538523008},
{0.14200848650258738,-0.9552435582208745,0.2595059425885412},
{0.6697490059742974,0.13682532338007355,0.7298733450937764},
{0.6987777877038237,0.0688542185446615,0.712017345294589},
{-0.19078991080387214,-0.954182569095333,0.23050994505678202},
{-0.38657258987762483,-0.5589719751234384,-0.7335611520397654},
{0.8309862943962073,-0.4635910089849711,0.3074819586804343},
{0.9305930161549221,-0.23209597895347983,0.2830690637235207},
{0.9766037567702304,0.11226077969681962,0.1834192454573264},
{0.9695861909423035,0.2436494941331983,0.02318495940543802},
{0.9842811685010892,0.1728503333417823,0.036240082750531075},
{0.9667728488359879,0.24935013511896167,0.05634508736086572},
{0.8983706523190104,0.4330249548625733,0.07361765765210226},
{0.7724480468503883,0.6286182454538296,0.09034996624000036},
{0.5932654498577367,0.7895093673595247,0.1571975345120285},
{0.5173997720064305,0.8093381942883323,0.2779733138159047},
{0.4499667101462458,0.8209313156487839,0.35157038377446054},
{0.38254465645663777,0.7940557340480205,0.4723717572441566},
{0.32741987331650535,0.7705266067482428,0.5468866197398162},
{0.3021092583279753,0.7492746846650327,0.589336442919184},
{0.1945597756004953,0.7501085249222121,0.6320472249423361},
{0.13099836542566218,0.7415871961714193,0.6579421393484519},
{0.09093393157663616,0.767243697499922,0.634876467302627},
{0.026469571933308664,0.770236894759562,0.6372083550243318},
{0.05128700081271322,0.6190593881358141,0.7836677341249595},
{-0.014047042515797758,0.6487881649717102,0.7608394032837679},
{-0.02358376362975767,0.44072243886889895,0.8973335711821471},
{-0.052055073225010434,0.4117776683568163,0.9097963624867725},
{-0.15414006160087343,0.10671481952294803,0.9822692037847179},
{-0.29580488758436985,-0.09970076342088387,0.9500311712014987},
{-0.3510204121783551,-0.13179454909722907,0.9270463133319693},
{0.792780869431022,-0.5801514716069435,0.1868763309156365},
{0.9478673875068969,-0.0010834591753916115,0.31866321064262443},
{0.2931253391460598,0.8368603543926436,0.46232270417569427},
{0.3468361354344989,0.6805568431427698,0.6454045850537548},
{-0.04186175312858007,0.6406610087478701,0.7666818541580095},
{0.2937701703185169,0.16211144163835084,0.9420291755147318},
{0.7091457873892699,-0.6388510416052482,0.29829783584186786},
{0.8259948494018252,-0.5373617732813488,0.17021995587351224},
{0.7694252288481648,-0.6033652800321149,0.20960714697671196},
{0.8678140934854924,0.41461644278569293,0.27384649809645417},
{0.26200928036744653,0.9525770959831807,0.1547514562438192},
{0.22021634678892926,0.8967762465598967,0.38379307473283236},
{0.19889522555870717,0.851277405886764,0.4855589227649439},
{0.22113700119022844,0.6843959226579223,0.6947666138738995},
{0.24492243412865064,0.1783989413292275,0.9529883624646774},
{0.21531467888318293,-0.07900807936704962,0.9733433682170757},
{0.6021959996820616,0.005012885949331479,0.7983325428299797},
{0.6112489536961729,-0.6252328529105929,0.4852407611141244},
{0.8496767260773274,-0.5268920998994764,0.020836895786915506},
{0.8920302374767549,-0.43985787067268284,0.10395724618542833},
{0.9015465260003144,-0.3914187597573155,0.18440503237929617},
{0.8655742903334245,-0.3740497178347724,0.3329684016562465},
{0.9041803173489724,0.07728645044784545,0.420100890615438},
{0.4006302245964622,0.9147258221479497,0.05265067364759391},
{0.2696783056700458,0.9540295279061626,0.1307718292832132},
{0.3938046263698452,0.8414773126426497,0.3699105953570555},
{0.2910182773917892,0.8460362220157992,0.446689011798084},
{0.30213688065498967,0.8157736268894316,0.49318018514507966},
{0.39387702685445997,0.5864657163692646,0.7077562089023142},
{0.35470223301446957,0.11224971108498172,0.9282167463776372},
{0.40115026138200677,0.0764635377599515,0.9128153127475349},
{0.18841010991451723,-0.18132597918113708,0.9652059468092813},
{0.47308539108793135,-0.5007057588923711,0.7249027215780016},
{0.2784866835048019,-0.7076585549359997,0.6493570179311139},
{0.23777152471687338,-0.8233747797658857,0.5152850415830956},
{0.14413790002212318,-0.9843904336849866,0.10099376142463791},
{0.9208969096777059,-0.3110076221017493,0.23499604409578184},
{0.9305769160024854,-0.11938368585074478,0.3460840056344619},
{0.9416124633643689,0.060664885587027303,0.3311883761450539},
{0.9643955258575435,0.2287977350037917,0.13263810222966438},
{0.9825349995899104,0.18063903317424823,0.04465998516264499},
{0.966368823880362,0.2503884774303541,0.05862513626589392},
{0.88298550531334,0.46123324913773606,0.08718077366250386},
{0.8111665538630946,0.5649486335382536,0.15113524855946547},
{0.7605453592691105,0.6226934119777179,0.1839121289468633},
{0.6832296217723951,0.6836178413366193,0.25663969088784905},
{0.6562527969115425,0.6662932798697139,0.35409819506210005},
{0.5181772814185791,0.6668358756266385,0.5355578586846662},
{0.44046397939544457,0.6084703623659725,0.6601176417710342},
{0.4020085273226371,0.5967900961833865,0.694428344076845},
{0.35081044047253174,0.5438721260485343,0.7623222057390927},
{0.30485856791182614,0.5661016806327702,0.7658917291337618},
{0.20818099613663443,0.5127446775430833,0.8329187046157616},
{0.16859091732900697,0.5444168534112382,0.8216978716754537},
{0.20112838320047582,0.564738025047611,0.8003863670356253},
{0.09157172818984888,0.5801058532231129,0.8093774259593656},
{0.1401500047373843,0.3872450389414586,0.9112624517598316},
{0.14054177320592498,0.35643156949626276,0.9236907200197289},
{0.06741495200431964,0.39153850004089075,0.9176888509903478},
{0.026662233066575995,0.3584436582276154,0.9331705466871036},
{-0.017393941788006066,0.12431231508093316,0.9920906708100294},
{-0.09082318746181481,0.12307146328120805,0.9882330512308817},
{-0.2147747836662116,-0.06604644726294187,0.9744278624429187},
{-0.31149838130487273,-0.09919743983730894,0.9450548271789143},
{-0.38387951765485767,-0.12056145996906081,0.9154788093097527},
{0.9428563718272793,-0.1310828705173587,0.3063317534334773},
{0.8257607362488542,0.11792884265596289,0.551554162834055},
{0.8675467776716248,0.1154174967802438,0.48377824464165675},
{0.9290968291215012,0.19365034591858213,0.31508510856907496},
{0.9725556027418301,0.1825038295519017,0.14431892382624584},
{0.9633929951716826,0.2443070664547949,0.1103992487944845},
{0.8512893323372445,0.5076695863063655,0.13258229062862115},
{-0.09476162529465208,-0.958088780629939,-0.2703444521394007},
{0.9049205827089979,-0.05721987119393237,0.42171628535089495},
{0.775234113989726,-0.08159472933545137,0.6263819670546389},
{0.5755186414214182,0.2129583598338672,0.789573954961354},
{0.7922716362072365,0.15798345431797017,0.5893614193542619},
{0.8747357531756628,0.15564072227243742,0.4589262769625639},
{0.9452988101576443,0.15145258568771514,0.2889156863222342},
{0.9419103493821479,0.22766501484097987,0.24692819754790407},
{0.8129620732603544,0.5354598529378033,0.22885675286530752},
{0.22561449764067618,-0.9669475934092105,-0.11878741538766406},
{0.191447667138996,-0.9790088466573745,0.06992473749420497},
{0.3165522938435576,-0.8023246159451041,-0.5060334533515775},
{-0.028655936841700997,-0.8810491725877017,-0.47215589879429737},
{0.17195350181185798,-0.7739053543383152,-0.6095100456441438},
{0.5982145377470003,-0.25945410510057104,0.7581707816676955},
{0.4814904197223055,0.06493215833715596,0.8740427852967592},
{0.6387184808063476,0.20033743302149043,0.7429021572231375},
{0.8103624319141522,0.12340827805440549,0.5727854099484617},
{0.8985082029284559,0.116634586187257,0.42317771984735225},
{0.8838582175740461,0.2188825540512443,0.4133824848234795},
{0.7805601828655823,0.4995632954338969,0.375715736668128},
{0.08341748772676194,-0.7327601493884224,0.6753547854347465},
{0.28588021985685697,-0.9563116500159574,-0.06115985561094894},
{0.3919881488440991,-0.9114984845117413,-0.12456244979356852},
{0.45826240203144997,-0.8724173285365425,-0.16995168652746015},
{0.7652901579395417,-0.15450614601818133,-0.6248670458613413},
{0.6351709792680539,-0.24630756422267108,-0.7320453612327286},
{0.12739907746908677,-0.4464808367490731,0.885677332596851},
{0.3050076797738072,-0.45391767924453486,0.8372150594370925},
{0.3413477987578068,-0.15086178449096505,0.9277512609872334},
{0.7910464617741565,0.02822043152598856,-0.6111048212533386},
{0.7730820800101893,-0.29020299207184497,-0.5640268796428659},
{0.7407832741259273,-0.6588080497614079,-0.1311948716407826},
{0.8996768204742455,-0.28407679306819983,0.33148453107413534},
{0.9025649903107694,-0.08190767370261655,0.42269086961270697},
{-0.32857660983505355,0.2592193239086186,0.9082085407997778},
{0.43213764719819237,0.15489664231111386,0.8884053602240103},
{0.7301815661253444,0.10025565589532201,0.6758577394331874},
{0.8215398811943079,0.0982367874883115,0.561624213501536},
{0.7838364123602655,0.22284190039181515,0.5796050086808708},
{0.6721880419991207,0.4929931982659101,0.5523775363435204},
{0.5647277954374984,0.4728403956416027,0.6763907726379741},
{0.49244442453771586,0.4198399552079269,0.7623863198882335},
{0.4564158096875473,0.431286832791577,0.7782520649043412},
{0.43457336640478866,0.3978879708676647,0.8079796729190789},
{0.394021247936048,0.35141915772977744,0.8492654660089584},
{0.3524392937910164,0.36532833592992986,0.8615809603042294},
{0.2913078496212946,0.3436372844005635,0.8927783339210374},
{0.20511237838689308,0.33296471400636385,0.9203604790836755},
{0.2664574372660203,0.3474323919834115,0.8990501471699508},
{0.2121863314101182,0.3556777604812076,0.9102034341078857},
{0.15317017073877778,0.14172207123342376,0.9779845363405097},
{0.16091540531954038,0.13831372905308018,0.9772285017774908},
{0.1152012169342149,0.1532109667792581,0.9814555921056444},
{0.06135232366810096,0.13833575455753022,0.9884832377898592},
{-0.013730988502903536,-0.03557749950049659,0.9992725861765774},
{-0.11356110897775679,-0.049663814695593715,0.9922889599494816},
{-0.20363332425093275,-0.08770932646664531,0.9751105287634227},
{-0.2508701943204285,-0.22415610459224314,0.9417102454447769},
{-0.37279295522099953,-0.20971411031741607,0.9039056391412593},
{0.9165475109747221,-0.3358061789759749,0.21719776768557564},
{0.8674348710163228,-0.49223990854857713,0.0725025308315785},
{0.8775881592087447,-0.36049168237629264,0.31604551848446955},
{0.8433473600284358,-0.1963218321424759,0.5002229188644692},
{0.6985956816408379,0.29280192235145763,0.6528637743511766},
{0.5501203892354983,0.8317752026136264,-0.07428034507488998},
{0.3722650720966801,0.9233713087653896,-0.09383039084297208},
{0.2806045416252098,0.9168674671086853,0.2839280524657788},
{0.3060999756463278,0.9475367491987371,0.09207015709342069},
{0.33025894907786735,0.9435045647147364,0.026984494000038124},
{0.7222517575113714,0.6432127448889653,-0.25422384542787846},
{0.8547907306089193,-0.0004824721292245981,-0.5189726140035854},
{0.4611972832764133,-0.7666190829269752,0.44675748185190955},
{0.7303200153128683,-0.6660765633005366,0.1515740315989456},
{0.6497839248617435,-0.5504502066739031,0.5241997910758124},
{0.6270082225103869,-0.16394116782103682,0.7615667944427723},
{0.6766393748865157,0.031101964342733022,0.7356574095101662},
{0.8831200839260863,0.22951404507499987,0.40917260475219164},
{0.7761515803785146,0.6305368568026728,0.0034635948579407284},
{0.3786820599175866,0.8930360598915345,-0.24307713432154957},
{0.030250373069813628,-0.9826606293303937,0.1829289547696916},
{0.03875755942697207,-0.9975118095358831,0.05889007916205131},
{-0.1900220553397591,-0.9804611960959516,-0.0508670957943305},
{0.5098597007300448,-0.4953351292035081,0.7033393173628311},
{0.5776698547328647,-0.1259974976358797,0.8064875507547573},
{0.5549901722400162,0.07427301433692662,0.8285345062568631},
{0.5282692245271214,-0.04302136122947912,0.8479863140967998},
{0.49160660869283407,0.02118396057594419,0.8705596947388775},
{0.7427934010142144,0.12501126276612948,0.6577462638368645},
{0.9445680855882888,-0.15717678631164778,-0.2882474449718811},
{0.6823192204394781,0.5932606917823957,-0.42717939206466443},
{0.8496904364529388,-0.032055562732027316,-0.5263065675994815},
{-0.29066447661069195,-0.11042752229775678,0.9504314411654378},
{-0.2670601245798184,-0.22070956203827294,0.9380651251828337},
{-0.35818697258893745,-0.46326885082048636,0.8106072196366363},
{-0.49829194439918356,0.33988094294302246,0.797612739850012},
{-0.22589903709117273,-0.34884588337389794,0.9095472360984701},
{-0.178841565738784,-0.4778826926597628,0.860025480099488},
{-0.32031211542205945,-0.2128150013415766,0.9230980034199131},
{-0.6949118205671209,-0.20808897603601922,0.6883288020186069},
{-0.6545701385425642,-0.7011680119999164,0.2826682732045697},
{-0.7355670368475221,-0.6470544315809075,-0.2006531755912791},
{-0.6806948438940127,-0.5218511236758895,-0.5141263796133371},
{-0.7189168519679687,0.018060346295484753,-0.6948614134114462},
{-0.5225999512202596,-0.8513653188821195,0.04545750531352413},
{0.2762298149908299,-0.49784480042431234,0.8220995341201749},
{0.3655887218840692,-0.056711730491900314,0.9290471818243606},
{0.532108076453222,0.23675492901882852,0.8129010386009736},
{-0.27634296508247524,0.9337051179417798,-0.22766053320405094},
{-0.4710693171817295,0.6819160449068942,0.5595392802194299},
{-0.05008031078239837,0.08664977162804534,0.9949792859897868},
{-0.9128916860339436,0.15570668159984702,0.37733830825304204},
{-0.5480084368738162,0.19906076897285296,0.8124417292157344},
{-0.9218492755326885,0.08828998004371243,0.37735764550852613},
{-0.7824476863143898,0.14974059542741278,0.6044446808950363},
{-0.025892414865598547,-0.028459592339073633,0.9992595430899428},
{0.590561908566781,0.057597335085082635,0.8049342700749282},
{0.7099713400940324,0.10570208940205923,0.6962526585522836},
{0.6660083209089557,0.22539180427965075,0.7110776687842173},
{0.5627791940090484,0.22975560496781028,0.7940352264077466},
{0.4878358755473084,0.2386681379605549,0.8396747456315644},
{0.45171635810377275,0.22345380892713385,0.8637249140191686},
{0.4159202632880065,0.2026019304792848,0.8865454259949133},
{0.3739473454108045,0.19262596686242142,0.9072257821240145},
{0.33095373657885085,0.1753949833264478,0.9272034426534512},
{0.2706953516045694,0.16892946721188618,0.9477272084978815},
{0.23852149667698389,0.16603841815818499,0.9568378855994882},
{0.21546741118136392,0.1430048610825393,0.9659831284373267},
{0.1983146700292864,-0.01625689361422695,0.9800035740042946},
{0.18172688930375167,-0.0036804712379219567,0.9833421540010622},
{0.13841372562768506,-0.004902142484026033,0.9903623627526089},
{0.06780291584408088,-0.020645835688014678,0.997485094661461},
{0.00335926097499077,-0.0835260371215163,0.9964999330097705},
{-0.08484262531584484,-0.07109013762154504,0.9938550806141029},
{-0.3043699640240942,-0.1861393567146597,0.9341900582225354},
{-0.318016403232063,-0.2901364625428167,0.902599800785754},
{-0.3125262327637754,-0.271839809574475,0.9101815597807921},
{0.002814696446867417,-0.09937148676414528,0.9950464235914801},
{0.12278687607612593,-0.419523202594333,0.899401837639028},
{-0.5215482219278275,0.11428721698150794,0.8455328995601197},
{-0.38121662778733184,-0.13546147988126225,0.9145075561015521},
{-0.49782206561987496,0.024152655165114667,0.8669428125490377},
{-0.6244427062882967,0.04393201157032572,0.7798341393672971},
{-0.7751545353152874,0.0033951222254974,0.6317625499546604},
{-0.9188862475688412,-0.0953668329769288,0.3828227151003516},
{-0.9439159740392101,-0.15706104767964385,0.2904383949401004},
{-0.9264428642751346,-0.07935162415650066,-0.3679768185326489},
{-0.9353077773808677,0.07798379933667454,-0.3451345949218634},
{-0.6666279979097514,0.17951501305793965,-0.7234510850704726},
{-0.5197589547648864,-0.09047433814671285,-0.849508695116552},
{-0.5074568900906858,-0.8057642068961361,0.30533841485232477},
{0.06653995659971182,-0.4838861643510197,0.8725976244096509},
{-0.133165216562456,-0.5194128403808453,0.8440837199859839},
{-0.0018404709379332672,-0.45210810473476165,0.8919612515686252},
{-0.09888339920992863,0.9403473034234694,0.3255288348286513},
{0.18874564577227368,0.6080118810155256,0.7711657628201408},
{-0.11400611000536114,0.896540714928732,-0.42803896242809925},
{-0.3492475511539505,0.17956609750316274,-0.9196641586146834},
{-0.8918255215248422,0.2507547265587126,-0.3765226504015509},
{-0.9641482370308755,0.1053235246963814,-0.2435675105094796},
{-0.9961574770339073,-0.05705120848719484,-0.06644878147559106},
{-0.8784525729781478,-0.25587654543776595,0.4035446326280487},
{-0.8576487404986566,-0.21969230337942205,0.46494508251718514},
{-0.6524400021387335,-0.19197478001661664,0.7331219049017571},
{-0.6817032310931211,-0.00032052024454227583,0.7316287323389995},
{0.1256698722242971,-0.32353032506627394,0.9378353863965894},
{0.42478142096286886,-0.07873085899836897,0.9018659524819332},
{0.6038504901297039,0.11894982836117543,0.7881722679103619},
{0.5121978409618785,0.11005018721374901,0.8517877247344018},
{0.45730758830834584,0.06788572731657824,0.8867137631176725},
{0.4218821022950857,0.00979273570739706,0.906597812754059},
{0.4120945749420199,-0.04250122211189763,0.9101492775486618},
{0.38351193041638776,-0.06519663042540831,0.9212317833257103},
{0.3174404732715435,-0.06304028990536306,0.9461804625851172},
{0.25395969107592226,-0.05255815312369024,0.9657857504896461},
{0.21814078315727786,-0.036587133118696734,0.9752312445844238},
{0.2729127337245046,-0.17219839920180313,0.9465021664440891},
{0.2568032502204201,-0.16777251045335612,0.9517901425274412},
{0.20904743114338237,-0.15651150351525572,0.9652996015744266},
{0.09798963089626257,-0.12235930118183272,0.9876366911223519},
{0.17124225691202274,-0.1340852992136847,0.9760620994498523},
{-0.005316083535565558,-0.09625952856199674,0.9953420730667748},
{-0.333732487638741,-0.2809648364736229,0.8998229755678656},
{-0.32989652855390333,-0.3448306165897202,0.8787833215932338},
{-0.2462436403070081,-0.3273047427241026,0.9122695188367645},
{-0.8732772489798265,-0.1522064949149538,0.4628390965766941},
{-0.7196069122599454,-0.5441823646215945,0.4313136281901573},
{-0.7528524594385828,-0.3624974118328237,0.549371277672742},
{-0.12260329154085473,-0.9896913790467298,-0.07402301766295598},
{0.5083892986459391,-0.821574487742111,-0.25798387956145247},
{-0.4348238736159437,-0.434088855738606,0.7889835639968514},
{-0.6968197556312558,0.18111215558021648,0.6940033251095303},
{-0.7948735330211438,0.21295799344497474,0.5681768734561226},
{-0.726407854279616,-0.23408162537149035,0.6461713564561069},
{0.16705692844978284,-0.9106287215829953,0.3779514705422427},
{0.774860491472865,-0.5726035962391279,-0.2677990670791218},
{0.8249619303446094,-0.4836147172201559,-0.2924972115596396},
{0.4932084589311431,-0.6078908395192701,0.6222653318861047},
{0.35361299513515454,-0.4135237626566479,0.8390208265530918},
{-0.791542729062561,0.182499408648304,0.5832272918093019},
{-0.8879720432648296,0.11542377113759812,0.4451774965521719},
{-0.15595939104971032,0.17473585682511297,0.9721851925857526},
{0.35219765500264544,-0.32537890641400213,0.8775450866317159},
{0.7642796394764869,-0.640121001034548,0.07824152807952574},
{0.8609316738120589,-0.5070391823662425,-0.04132699568730949},
{0.3693438020354582,-0.8738102835712486,-0.31629218172937285},
{0.6668195771572849,-0.682404179107183,0.29945982678287825},
{0.4065188131282048,-0.4268547946828265,0.8077978947912143},
{0.5946419703279718,-0.40398396512004414,0.6951243651681002},
{0.6040552810431022,-0.4264320394758542,0.6732554739119484},
{0.37388497608846727,-0.49092724070179194,0.7868929209188829},
{-0.06102340561887869,-0.47282994130556283,0.8790381053012729},
{0.34590595041581484,-0.4216722213400115,0.8381775535154303},
{0.3818765013042956,-0.2245741443620127,0.8965136872550581},
{-0.5038503527634207,-0.8622044420035913,0.052328980588697345},
{-0.04715173646469582,-0.9643621658462366,0.260350392418985},
{0.024906870061963418,-0.7219195224091768,0.6915286335273635},
{-0.191165996089154,0.13408766257732807,0.9723559331252062},
{0.18268639284353802,0.8651347139851894,-0.4670841557231214},
{0.040954031683078825,0.4866580141793395,-0.872632078555403},
{-0.3980788577917851,0.16554546052740704,-0.9022903764742015},
{-0.43016846912214834,0.571782651216798,-0.6985840593232835},
{0.13523950973769547,-0.9385557131926613,0.3175270826863795},
{0.15652490289187615,-0.9852925341772522,0.06854616597051379},
{-0.22243099644727815,-0.7070712266696421,0.6712486366729981},
{-0.3488421092077375,-0.49610021605410004,0.7951061303213379},
{0.15971999207964105,0.9191257899745897,0.3601351223272535},
{0.3488746971037308,0.9184020834794696,-0.18661205422305793},
{0.8478623394410807,0.21758407141309288,-0.48351486556754364},
{0.5539863820204495,-0.09467730941285352,-0.8271247158791928},
{0.5465267329661523,-0.42322661153268737,0.7226256053060282},
{0.4863580728467641,-0.40996760624450845,0.7716102557683701},
{0.6308764449090014,-0.3650410583497446,0.6846458478497317},
{0.5780811283484326,-0.31939865172792326,0.7508706348777983},
{0.48839474856243165,-0.24490464371164064,0.8375513626429806},
{0.46278689925927796,-0.2700001871767845,0.844350747496847},
{0.4614411260294383,-0.34677905211714877,0.81658825378609},
{0.5443835211469193,-0.31563345287959765,0.7771885905795224},
{0.37460566575724485,-0.2988848717367738,0.8776892551635024},
{0.43886549532085406,-0.25904439894927994,0.8604028570325577},
{0.4249098725842287,-0.26751501007835254,0.8648047869682691},
{0.3981199155395064,-0.27475851044809807,0.8752189976155446},
{0.4084866420191016,-0.2707310146392949,0.8716899569252454},
{0.3966156399689403,-0.36968560943441514,0.8402550709809095},
{0.33814105721479776,-0.32698623103763014,0.8824628208244609},
{0.3491982269040346,-0.2782129878182474,0.8947950221901786},
{0.3641048833720434,-0.22174989276169996,0.9045742749850922},
{0.4444906339963104,-0.2773074119495225,0.85177971070425},
{0.4058346024530552,-0.3531672686055329,0.8429538278206452},
{0.5764743021661887,0.13637583411090345,0.8056543991145094},
{0.3495563096672986,-0.2801665619377324,0.894045347811715},
{0.2966818232074153,-0.28304472168214173,0.9120666539821544},
{0.30101629169900423,-0.18552625846605142,0.9353978830162959},
{0.5407539106367898,0.8376562604646027,0.07692332179174456},
{0.6783472264496262,0.6655292539275613,0.3113131101234301},
{0.8888803309608622,-0.030606461339938575,0.4571159609499049},
{0.8036596327987021,-0.588772588742255,0.08647562289800832},
{0.0065202229825356145,-0.9651981809860647,-0.2614382491401175},
{0.46152339822370053,0.7801712447450708,0.4222901629981147},
{0.6522821103761774,0.129951123839257,0.7467534759852908},
{0.5586038874111349,-0.22038122007738314,0.7996210444994379},
{0.5697918807329962,-0.3503121966439209,0.7433831969672612},
{0.5656468920570243,-0.8180425868660056,0.10416294724998347},
{0.08608184562416807,-0.8719120006174331,-0.4820366988448518},
{-0.2514858732003931,-0.7116665284757026,-0.6559615902078244},
{-0.44509567197219846,-0.7676007988921217,-0.46117117899083143},
{-0.5139209278399938,-0.8536749602922293,0.08440581791642444},
{-0.5279419646598408,-0.8471199967244064,0.060539186488994055},
{-0.2771358845840521,-0.9207763410535843,0.27452983668772396},
{-0.35662429323671174,-0.5142631740361978,0.7799695515234112},
{0.3202099612603784,0.2316100772149629,0.9185980365982206},
{0.39745181892609016,-0.09072400846427459,0.9131271575856873},
{0.29489387822484403,-0.2625600751959365,0.918749044896709},
{0.3956695455413962,-0.40823995501314764,0.8226698911847499},
{0.5628386736553533,-0.5197302160597231,0.642723214107283},
{0.6564262223883701,-0.6388409949450219,0.4012316011215821},
{-0.11959918899208859,-0.866709899465871,0.48426230925015684},
{-0.44554776492193066,-0.7355949233531281,0.5102815868813783},
{-0.4225018722411412,-0.8804410934658258,-0.21521070811981277},
{0.05383082976996038,-0.7792786326126007,-0.6243613172832803},
{0.49868402629870406,-0.6719079998040104,-0.54758915412368},
{-0.553589837331611,-0.8320069856159239,-0.03609249076281809},
{0.06929967133451366,-0.9878048653875426,-0.13942418538269158},
{0.6131601468269567,-0.7860242475348493,-0.07874335927821945},
{-0.3004439779992243,-0.8286494685080878,0.4723065470912563},
{-0.12444326293831488,-0.6264961226597533,0.7694260735129534},
{0.25213457939575884,-0.15375783217679576,0.955398703640117},
{0.3172581907204259,-0.12208603453560908,0.9404478936082381},
{0.27003698817115473,-0.23619939306375232,0.9334290930412263},
{0.27467066657573685,-0.5512013499409498,0.7878661667733392},
{0.3210730431683113,-0.217428091128477,0.9217576287391748},
{0.3717604655547688,-0.6494198627204428,0.6633611370548192},
{0.556282781633993,-0.5911384175462538,0.5840418119950471},
{-0.03965711226006354,-0.30999182960511906,0.9499117743376295},
{0.25453083929312165,-0.1820247402706191,0.9497794721819127},
{0.39775353619549747,-0.8941172683213642,0.20578249423485734},
{0.06250950032937248,-0.9279044454993484,0.3675403411751141},
{-0.07306785272750647,-0.98416281440563,0.16150741047698328},
{0.09980079280188577,-0.9936411454409544,-0.052125577626567006},
{0.5694087142346703,-0.8203735996616758,0.05254401137869423},
{0.9414216677667491,-0.140224275817634,0.3066959339976534},
{0.8924830446329438,0.011219734115020774,0.45094138489286956},
{0.21129686399989395,-0.36350831847050763,0.9073121500710515},
{-0.30862656630314933,-0.32153007514136867,0.8951916294020593},
{-0.2177287167565378,-0.2575095205473521,0.9414260739574958},
{0.24879040300197414,-0.14431436677262618,0.9577456337238668},
{-0.2310357676152171,-0.30347990571673483,0.9244038191767757},
{-0.21738293576999576,-0.21812339800408528,0.9514025659410266},
{-0.3281706411873792,-0.20715581129539812,0.9216238387266303},
{-0.2592687665813516,-0.2669427776010643,0.9281816956620149},
{-0.19300122732382696,-0.3410616800244536,0.9200149219824609},
{0.23932194274795254,-0.2086358009667264,0.9482595163109718},
{0.7002748044252413,-0.09443555309165702,0.707599551017002},
{0.6821042752313289,-0.14734626257659786,0.7162561250110551},
{0.18832668610918493,-0.2544876385660238,0.9485615958472182},
{-0.09848940758921254,-0.3894343851697674,0.9157732777495591},
{0.3432080731882333,-0.34323875822664657,0.8742970738538761},
{-0.1050915675166875,-0.4464621404051165,0.8886097679081452},
{0.18676350688804177,-0.6273738881150694,0.7559903418736648},
{0.13979846034857224,-0.6072791354821607,0.7820923488260246},
{0.18815264499379386,-0.6275846085324266,0.7554708077186307},
{0.36415426024355096,0.10449283186715375,-0.9254582231710164},
{0.6594864475888579,-0.0710052491431531,-0.7483554503314234},
{-0.8214398431211836,-0.10648009851727287,-0.5602665193930448},
{0.3028551264668219,0.13078421284344044,-0.9440202656954387},
{-0.6434214115478812,-0.11517856743395469,-0.7567977172042699},
{-0.8568617493109222,-0.35552995131746945,0.3733448757971964},
{-0.3944495660555831,-0.3458239649504489,0.8513608665568984},
{0.4213152389424885,-0.20784770935606608,0.8827756221998148},
{0.9360007743159693,-0.016822710182494684,0.3515957151360375},
{0.9948665738538507,0.07132666685396008,-0.07178444694921612},
{0.9468549505330977,-0.31882793929820624,0.042596335215888646},
{0.4337544463367318,-0.789655141099745,-0.4339375973776148},
{-0.4873071901119019,-0.4608750603573392,-0.7417047129456991},
{-0.45976580426316216,-0.8569145274357289,-0.23305127740445694},
{-0.08556501605473067,-0.9470881001002108,0.3093586246997596},
{-0.22656272280924097,-0.36292683803109654,0.9038547686824545},
{0.5989502522851491,-0.15472864315341978,0.7856956422657937},
{0.48388328661279184,-0.5171254917406203,0.7060015515059613},
{0.9988249123062639,-0.037181164281524064,-0.031086260293815393},
{0.6750846725493147,-0.5593195414629408,0.4810637540146527},
{0.22761520697567553,-0.7526264107163705,0.6178550019588848},
{-0.11471567130824754,-0.8912291373809822,0.4388062664085921},
{0.8037756239137347,-0.5771765051580544,0.1442637456037415},
{0.8349894283954316,-0.36992100791265436,-0.407370964076671},
{-0.1946366585769678,-0.41417018746597073,-0.8891454475800883},
{-0.06123890469950446,-0.5747485475119918,-0.8160354794272494},
{0.3302216252551445,-0.7222222657076738,-0.6077406331075167},
{0.6284767726480509,-0.48897251115910995,-0.6049155557370336},
{0.6889308893418985,-0.7116783317662522,-0.13743428176763384},
{0.5028733409606922,-0.8263442791384553,-0.2535222579699418},
{0.37780377958534245,-0.9045874231586849,0.19744846921199558},
{0.7840495080116637,0.4204556014798828,-0.45659988630184534},
{0.7440000755305917,0.511403882670972,-0.43003483161196215},
{0.9346019261382298,0.09225120535671716,0.34352431466920036},
{0.9954834093628636,-0.07578614237345911,0.05717728838830276},
{0.72182297157937,-0.5746997151949136,-0.3856058026731615},
{0.5614574174396545,-0.6011758916882062,0.5686414649450772},
{0.17921148980945267,-0.5412121271312544,-0.8215672068469745},
{-0.21641459222289505,-0.9041809393837683,-0.36826831675842564},
{0.3562232056515917,0.4547070192523359,0.816300529460786},
{0.18304606644376478,-0.8405085804774363,0.5099406472358035},
{0.3972827482163964,0.5834626413276771,-0.708334500179511},
{-0.03222434280519231,0.9581268518466322,-0.28452509116286284},
{-0.3154726930759606,0.6125748659264073,0.7247268544483809},
{-0.46100282298573547,0.2726466456196698,0.8444762896798967},
{-0.7440655356776141,0.19578487094924896,0.6387759880616766},
{-0.6904448030191136,0.032161810976626695,0.7226697668358635},
{-0.7214186977947781,0.07470529382680048,0.6884578284443703},
{-0.7905972663009483,0.12568440079875198,0.5992990855268561},
{-0.9133693870155778,0.18760665840713808,0.3613310180210038},
{-0.4253461318441514,0.31844158160356434,0.8471573804382738},
{0.5955414682083974,0.029984110110606754,0.8027647929406604},
{0.7061173794947906,-0.2365425622781853,0.6674173076915829},
{0.3840911655895683,-0.9038641399037798,0.18842397170224137},
{0.133978660015048,-0.987221431670861,0.0862760888677037},
{0.11820607644238067,-0.9399475396958281,0.32019673032661927},
{-0.18831095028618086,-0.97279229219684,-0.13495978010034462},
{-0.16978807895848289,-0.9854769800572754,0.002670209875773193},
{0.3067659446185299,-0.6938352748497231,0.6515268732727073},
{0.332910530030165,-0.6739153890284717,0.6595518383157144},
{0.6002160755781184,-0.4151260472705757,0.6836746503236099},
{0.6620488520032158,-0.400829629275784,0.6332668678020836},
{0.6729820615199708,-0.3745977513781792,0.6377865391608246},
{0.46442251549832353,-0.416850250840649,0.7813754510299755},
{0.6448995346053176,-0.5621044695275971,0.5178254103488389},
{0.5770390975129174,-0.7103310569474865,0.4030578984182603},
{0.159131791598019,-0.9744395477187757,-0.1585706175318505},
{-0.23400825280289597,-0.9616902998292238,0.1428002270114214},
{0.6928580081233607,-0.7148935308065173,-0.09420732556611523},
{0.9452176072697426,-0.28898153147501043,-0.15183329468077797},
{0.9582294960746092,-0.2565761189736025,0.1263523961982682},
{0.7797306509287516,-0.6084156125492057,-0.1478193302941127},
{-0.38561204075151945,-0.33097512235550647,0.8612542147410404},
{-0.4145790219430596,-0.6487053032738472,0.638205032939354},
{-0.39475952679926796,-0.7864157411391381,0.47509493587050405},
{-0.3731758470356575,-0.8607481391402648,0.3461970943780302},
{0.32518068007041007,-0.4824071485055917,-0.8133516265304014},
{-0.1614174438033738,0.9547917128592206,0.24963412004639948},
{0.299034331603763,-0.5550394521554652,0.7762149670505276},
{0.3323788668739599,-0.5065680655029345,0.7955583472431152},
{0.7448547989550557,-0.2565949566739651,0.6159142445853233},
{0.7698324854962273,-0.1832198667075052,0.611382388295889},
{0.14211602691035402,0.4379258913422814,0.8877071299630773},
{0.1827021407002087,0.9750347125585029,-0.12620315800136972},
{-0.48536211681999275,-0.22916135878238225,-0.843746814629263},
{-0.5433861342483589,-0.7248520354828293,-0.42346314569632115},
{-0.648131308962898,-0.5586109978173712,-0.5175708255490465},
{-0.5227594037683716,-0.39987898114833154,-0.7528740971819318},
{-0.472384368207778,-0.43388811902511304,-0.7671988717678014},
{-0.305438154164426,0.27947005311147777,-0.9102768938045698},
{-0.7026887259226257,-0.6089758005359922,-0.36793617493090375},
{-0.4498748880020041,-0.5351795520144974,-0.7149793229532907},
{-0.36398249245446684,-0.5061765296920075,-0.7818580855728169},
{-0.39193119817242844,-0.7766688837721959,-0.4931281586759937},
{0.3500057187287669,0.538146665461538,0.7667425665174636},
{-0.4281429397726276,-0.31590902263828374,-0.8466965882407798},
{-0.4292408038661144,-0.31943422726743553,-0.8448160194660305},
{0.4076102199577951,0.4909855025713023,0.7699267139479988},
{-0.2910088700718243,-0.6298206170325868,-0.720166527894911},
{-0.33091202557314897,-0.6629466070680166,-0.6715646115662143},
{0.3336657349034158,0.20048778341934073,0.9211253042072849},
{-0.28185715976357656,-0.1615088713273285,-0.9457649951085005},
{-0.12273884840407324,-0.19813079319737226,-0.972460469057443},
{0.4079305208308686,0.010487439617775577,0.9129527390752052},
{-0.14460177656801954,-0.5536909964200302,-0.8200710985620496},
{-0.20942947102212278,-0.9195960125467024,0.3323890346801454},
{0.053398036679757295,-0.7875112377498564,-0.6139826545566547},
{-0.059870320089964985,-0.506880614599746,0.8599346413043893},
{0.19433313434611937,-0.6335225630694274,-0.748921754909788},
{0.10800935690748911,-0.7040386392517812,0.7018999738288434},
{-0.04696628785652632,-0.6131032820515797,-0.7886054357805045},
{-0.31725078880264457,-0.9375730974820475,-0.14250832916717188},
{-0.363901504437283,-0.9306107274307494,-0.0392347939856131},
{-0.15434343124800393,-0.2743989125683408,-0.949148745988691},
{-0.3537813617022313,-0.16505191497963664,-0.9206501037167538},
{-0.35324414779787516,-0.8945942054003755,-0.27371477802746397},
{-0.614081049309917,-0.5421635098900973,-0.5735531304265381},
{0.38103680947199003,-0.8962659324034795,-0.2269764927042619},
{-0.4239498540583939,-0.07298447976771401,-0.9027401547272076},
{-0.06595100165382677,-0.32236888341387204,-0.9443139141129662},
{0.7163908883973642,-0.5855077231088007,-0.3794269378960633},
{0.8049404455348383,-0.4000126615047312,-0.43824736140458115},
{-0.7140690549680265,0.6163287927649177,-0.3320304262353202},
{-0.018448606775827887,-0.28206160229048,-0.9592189017223117},
{-0.5098393757735454,0.8582881114551432,0.05835519381859049},
{-0.6962364929724028,0.439872688804368,-0.5672448884719059},
{-0.12299011477662206,-0.12932626945777212,-0.9839451954734925},
{-0.36911453204142913,-0.3381307801234539,-0.86569165282388},
{0.5652437225018645,-0.7485957094571197,-0.3465602371228226},
{0.9231675493657069,0.04236666428552675,0.38205594034831175},
{0.558280109408756,-0.8288061390673324,0.03746602838371359},
{-0.5052124089084008,0.7392619851053664,0.44525513951333995},
{-0.33987955991862984,0.012761825800352913,-0.9403823799666602},
{-0.1251051896224494,-0.4521170613293213,-0.8831414690662361},
{0.14509645646465044,-0.1895747170673679,-0.9710862191228073},
{-0.3580399166060401,-0.26863790391931364,-0.8942265343270561},
{-0.31215169836666645,-0.27321890529839155,-0.909897107916249},
{-0.7846124803681623,0.6171163730155811,-0.05958722855288745},
{0.05227169021589196,-0.7668506802535273,-0.6396934457978105},
{-0.10508305428939198,-0.9795546518236592,0.17155242869700954},
{-0.8195336333887849,-0.16784724631578093,-0.5478977328377862},
{-0.9780297134897488,0.05108192166085144,-0.20211016008749982},
{-0.6897519148776928,0.23993652286812683,0.68313451158356},
{-0.11899457378549626,0.03170115645136978,0.9923886980862155},
{-0.3518639054657949,0.36127285465173786,0.8635240103912237},
{-0.4180194684721406,0.379764599679153,0.8252506121226459},
{-0.8673678456461255,0.10717417467459352,0.48599044910576067},
{-0.902534719513388,0.13235056226390002,0.40977360669193874},
{-0.5773674821834692,0.30557177031786775,0.7571477291136294},
{0.4618054999645525,0.21240633498272654,0.8611731701938323},
{0.4837733289046455,-0.0018818957640781566,0.8751913074915968},
{0.5248815915442804,-0.21957549861763362,0.8223660470038636},
{0.3351265250240617,-0.4921396637801398,0.8034231534874184},
{-0.039134912431908066,-0.9738968374504517,0.22359205851942732},
{-0.050241870495001506,-0.9841807064458329,0.16989435396429384},
{0.0792170149681739,-0.9962955976384129,-0.03346261594450841},
{0.35697963557640855,-0.8708960066796767,-0.33779533053777816},
{0.25626058222889186,-0.963468695781878,0.0778369208285914},
{-0.449122561706569,-0.8522627153091018,0.26821108974105806},
{-0.22081122211843282,-0.9743458690313016,-0.043503237674936406},
{0.39025589863714294,-0.6235715806604486,0.6773911848935928},
{0.6934534974164842,-0.5103024092639709,0.5086390645833574},
{-0.33690601445409846,-0.2055307095987372,-0.9188315758812897},
{-0.5622539399983609,-0.7746489546400942,-0.28946416709383693},
{-0.5316183830468403,-0.8146569227117497,0.23176710958305768},
{-0.3628161381071614,-0.7283655251516575,0.5812470315619302},
{-0.2601004773434167,-0.9069752318376741,0.3312758224180028},
{-0.051351390131009644,-0.9845246646493323,-0.16755363149968594},
{-0.11787236947240608,-0.9844976965224621,-0.12988606567652528},
{-0.369209190871907,-0.9241747813929229,0.09790580581893456},
{-0.22200098472225507,-0.20139730207384532,-0.9540202773000821},
{-0.5319551381668941,-0.7650617730674437,-0.36291075262210143},
{-0.46355736993698987,-0.8801054916652802,0.10261037139449507},
{-0.13666258164315595,-0.3043247839662767,-0.9427140418188893},
{-0.37225545002475663,-0.8223188334373404,-0.4303691625815186},
{-0.280376166951827,-0.9581912224455543,0.057085779610121894},
{-0.27765079204004106,-0.9558253551775873,-0.09647760402900278},
{-0.171024084591571,-0.9793860269163618,-0.10748847738524644},
{-0.2283626796789644,-0.9558915677806689,-0.1847208628597691},
{-0.180677349847208,-0.9366292429680743,-0.30013556348630505},
{-0.233367827124263,-0.9499714203849551,-0.20759036036167697},
{-0.49820040074632765,-0.77042955571422,-0.39778720489501457},
{0.004873611614664724,-0.42165864820249377,-0.9067415465863882},
{-0.2998894609696121,-0.8514865506459763,-0.43015923245743837},
{-0.2540187509413915,-0.8695265930969447,-0.42355398483238904},
{-0.3344043272532644,-0.8271449014376573,-0.4516691908244129},
{-0.38894604671109634,-0.7671313199989882,-0.5101279355459959},
{-0.35405677442864847,-0.7191982100829042,-0.5978275128285149},
{-0.36220022418344977,-0.5277589237335621,-0.7682978042536961},
{0.039792993665100536,-0.5422853982987621,-0.8392514905837953},
{-0.0792342666374165,-0.57890830573087,-0.8115337975378747},
{-0.2652165220134178,-0.5130664557202163,-0.8163473577257427},
{-0.305141698667361,-0.45298054665496557,-0.8376736644341674},
{-0.48322052579287644,-0.4855125493051034,-0.7285434015346756},
{-0.514737091895387,-0.4661862051617788,-0.7195249462971661},
{-0.2999206397538107,-0.9349665809978078,0.18943363552161085},
{0.03465764690353293,-0.7472025269403637,0.6636921208248934},
{0.15083799402744313,-0.9860439415856102,-0.07046449332884604},
{-0.36367021411324446,-0.7477279836894486,-0.5555599317576265},
{-0.260210975979856,-0.6255591211052558,-0.7355039319960368},
{-0.11340805467696491,-0.7399933825533231,-0.6629844695855837},
{-0.08287376358793186,-0.9882763837100226,0.12822530448321082},
{-0.4793773215955582,-0.7117409376723577,-0.5134415460216887},
{-0.276220519934647,-0.7760899451506396,-0.5669097118616953},
{-0.09526791835686425,-0.880280089339862,-0.46479133817634155},
{-0.19926137186070386,-0.5020521104668957,-0.8415691201915183},
{0.014610373601484058,-0.358992494862355,-0.933226084941761},
{-0.00729227478529318,-0.7739295276129766,-0.6332297442612836},
{0.05773054956688269,-0.9970871082068542,0.04984458139455976},
{0.26882734984246004,-0.8119782177066087,-0.51809577294809},
{-0.07778507015623198,-0.5859681877210436,-0.806592069040916},
{0.22115976258444586,-0.8440205765052413,-0.48858737790629797},
{0.2521773385850589,-0.9593731095924014,-0.12652994307737037},
{0.31330430996557185,-0.7246260364021757,0.6138057646561081},
{0.5605701470605453,-0.6105270937736728,-0.5594799174168733},
{0.07076895148693028,-0.8034185410934801,-0.5911940487967251},
{-0.16588802105103106,-0.912727843582791,-0.37337521077393593},
{-0.6636211729523729,-0.7338212912794275,0.14530399607137603},
{-0.3379190361855839,-0.6892618057741091,0.6408813369762146},
{-0.1540769274252107,-0.8115934069600784,0.5635392108932075},
{0.040545058488837785,-0.7772426724290887,0.627893244419324},
{0.27743937370171884,-0.638359087861426,0.7180007443343818},
{0.5002290813718242,-0.41307039195933704,0.7610149258959777},
{0.7963345455260221,-0.31815461745545587,0.5144209667127075},
{0.8331565321948667,-0.5126299732777794,0.20751073070626283},
{0.7381918115461145,-0.6668529279625041,0.10188239216911445},
{0.6039699325499023,-0.783558844986104,0.14579388539890675},
{0.2694381814322058,-0.9085348542321119,-0.31932348023899065},
{0.5139980992349706,-0.4880885500231687,-0.7053903325954488},
{-0.4041220637849081,-0.9100731018788849,-0.09193642802921763},
{-0.425377168457379,-0.6251787752403825,0.6543743298327938},
{-0.2962516902021954,-0.32777683242726335,-0.89710494602153},
{-0.403751533147163,-0.2412943632356925,-0.8824747757029642},
{-0.8817888686136367,-0.364159984078828,-0.2997263705194966},
{-0.3439736448321019,-0.08362092646564326,0.9352484548599622},
{-0.08573930212236401,-0.056531999905566156,0.9947124735612032},
{-0.5739819556938566,-0.2751784021368349,0.7712467578766695},
{-0.21539658503820458,-0.07178687900769243,-0.9738844670474082},
{-0.2795452180778069,-0.09437665895922989,-0.9554828712716542},
{-0.26920909311335706,-0.7055575523547089,-0.6555265093802966},
{0.12782122654289607,-0.9046920028298049,0.4064407878902732},
{0.8708952335762007,-0.3770549533861019,0.3152317469121082},
{0.556872290955305,-0.298059287203841,-0.7752766686014281},
{0.9888931846610207,0.0006230517372677734,0.1486266501591059},
{0.7316165567420323,-0.2619281386938209,0.6293892786355064},
{0.9415555489132696,-0.08736892379228531,0.3253303236189477},
{0.8755923377766225,-0.1617182022568819,-0.455176098983318},
{0.19010602551517558,-0.6734158826699297,-0.7144023712381581},
{0.41509086175654886,-0.5696620054047608,0.7093551833069467},
{0.9013808506760972,-0.18398892059755023,0.3919957131548555},
{0.9601763089722887,-0.23112457379758047,-0.15698053087959327},
{0.5237069603543881,-0.4075311602721756,-0.7480971682098401},
{0.9247379970986154,-0.10723938345560034,0.3651839965799488},
{0.7447765402406593,0.04119798704917834,0.6660410129791177},
{0.8697130158698736,0.09618802749427444,0.4840941369127392},
{0.954123329335282,-0.2859172584732256,-0.08888190887526964},
{0.6432729799057498,-0.2196365055089592,-0.7334573462519752},
{0.4579566295794386,-0.2677377208318532,-0.8476981999910141},
{0.4107236944515312,-0.769331730391845,-0.48932068771754855},
{0.5302661395294331,-0.8145792399342359,-0.2351137663700581},
{0.7007345652382294,-0.6538888786492572,-0.2853075594147596},
{0.644195653515705,-0.540388642429037,0.5412874237641},
{0.6246494410711795,-0.7182321119170285,0.3065219554626844},
{0.4503047214558153,-0.2727183053281012,-0.8502060831195981},
{0.4305571603520495,-0.8420754342793283,-0.32485303546813327},
{-0.050961191466426026,-0.9347911010913025,-0.35152319167422313},
{0.10968335005560433,-0.9905561201390458,0.08226867918995845},
{0.6125599090030862,-0.7844798065334777,0.09675634874946465},
{0.9817317630580528,-0.07773420407100197,0.17366674673170798},
{0.8213281254896375,-0.2109024335362637,0.5300379927968938},
{0.41898068796654053,-0.4342240375197719,0.7974363099026228},
{0.04596737865462956,-0.8735251531571862,0.48460376278082706},
{0.2005888210827939,-0.9688326320746713,0.14535286678933917},
{0.28368039935922845,-0.9271466898912668,-0.24479470264500366},
{0.06270217949762409,-0.9008981120614923,0.42947762266535694},
{0.7645635827604045,-0.5657337003381394,0.30884932931494324},
{0.5909987451269886,-0.5425017159849667,-0.5970028236212047},
{0.5981107530079861,-0.3380273713391146,-0.7266367891607113},
{0.7164976423122964,-0.6974984247532174,-0.011272800348661509},
{0.6576651052020349,-0.6252712963711728,-0.4201338064639754},
{0.22189307207154915,-0.26449704636777016,-0.9385120015372078},
{0.894090522757105,-0.04423443319629774,-0.4456965919049964},
{0.83166059747263,-0.5530538833528703,0.04971974175091709},
{-0.12690889464037924,-0.8411057218715605,0.5257711451725723},
{0.5920783791239681,-0.46314552023060934,-0.6594993707838187},
{0.32145560616297847,-0.7722597534605113,0.5479791660743155},
{0.4878643546041764,-0.7132943284248326,0.503189400269538},
{0.8239398915084807,-0.5434151392032126,0.16069549360746274},
{0.8144718657609106,-0.4162882979232399,-0.4041529820453057},
{0.6955542918689583,-0.54301919604314,-0.470461879211625},
{0.05933359259047769,0.711378808425896,-0.70029973276652},
{0.25324322608044747,-0.786621652254402,0.5631112187205313},
{0.28665458288435236,-0.8851189408436262,0.36659734133140626},
{-0.050859061596309936,-0.5961207871714153,0.8012823241253204},
{-0.35696867974405544,-0.5447332148591564,0.7588406198346225},
{-0.17194271248274015,-0.3118760892558536,0.9344351280717954},
{0.151287320368826,-0.2904221102089963,0.9448635587201857},
{0.31322451108346816,-0.2159938926772799,0.9247902702681501},
{0.32697980881653166,-0.2320612840782254,0.9160959366017675},
{0.11012480062759626,-0.01620813514694446,0.9937856029555824},
{0.053336852109698116,-0.05720065048784675,0.9969369417324223},
{-0.40670245288458573,0.07654406522260798,0.9103483514000882},
{-0.3287520960179092,-0.03246869805002158,-0.9438579570098289},
{-0.6200484400129724,-0.09770214298143276,-0.7784563078903753},
{-0.9203475022939519,-0.02153338792398099,0.390508371518204},
{-0.2730714155026422,-0.016471594575576298,0.961852737485069},
{-0.14246748789358796,-0.012368136586650912,0.9897222055156003},
{-0.8674218593551984,-0.28244663094551,-0.40963791155153245},
{-0.2659909734646577,-0.4538610313489691,0.8504463335556065},
{-0.3348924493653507,0.17137838878665554,0.9265400667078385},
{0.4096176338344914,-0.430633401846972,0.8042190418446563},
{-0.7931379403554492,-0.23510373565856588,0.5618348877099953},
{-0.6713688678323017,-0.6977582267489197,0.24979451617234702},
{0.5865851507521227,-0.6816270353968796,0.43738135023474695},
{0.1627905856095344,-0.9866388244720472,0.006561652331676078},
{-0.29731688975528425,-0.9346143244273201,0.19518896393369325},
{0.14557706666380466,-0.8486030110067151,0.5086061810201473},
{0.1344124540946674,-0.8130187756045074,0.5665101611611186},
{0.7517553192943843,0.4568236344622331,-0.4755797587254047},
{0.1426087652624296,-0.9868862231142811,0.07561959202187161},
{0.07173304674247681,-0.9388205131452042,-0.33685369836594775},
{-0.38595948715038564,-0.7461517757772228,0.5424876051884581},
{-0.37479709011831547,-0.7896694194410979,0.4857461777908323},
{0.11741895036172607,-0.9898780667808214,-0.07971325487153458},
{0.4732741921676344,-0.8559953734582879,-0.2080467727365152},
{0.19851950464161766,-0.9768212261508448,-0.08006433924043113},
{-0.02053440275530541,-0.9208176907695884,0.38945233170343907},
{-0.15486008160000406,-0.9464931946509402,0.28314128559130636},
{-0.07635829488104921,-0.9730012982334202,0.21780239768867984},
{0.18640898592802885,-0.8369904608667903,0.5144887349430327},
{0.5792979073743063,-0.8079829012613589,-0.10759909749169369},
{-0.5553308624676613,0.3191006258801746,0.7679729316543679},
{0.3388198837229301,0.2878004674682738,0.8957521852158794},
{0.3415981876411317,0.09508529142458207,0.9350237780693048},
{0.11504103071384114,-0.692991176454063,0.7117083606429748},
{0.009757853010910533,-0.9469467952975755,0.3212422001858867},
{0.023728843324482326,-0.9860236910590466,-0.16490670897442514},
{0.03817051524494951,-0.8390420565048632,-0.5427259337658602},
{0.40419202866692644,-0.8800992527884792,-0.24910662215861548},
{0.2913004191360429,-0.950320730257967,0.10970221261729451},
{0.366563870699168,-0.9183702323705139,0.1490873736899674},
{0.10048481040315177,-0.9731710881208542,-0.20698027955318687},
{0.4510260383294392,-0.6967160625888609,-0.5578191829612223},
{0.339502759706645,-0.9096245595490824,-0.23941812132065077},
{0.21434792546807768,0.31798281882192064,0.9235485335279339},
{0.18178885976136228,0.17587994713797905,0.9674807774118334},
{0.06641181012276301,0.2702022819789962,0.9605103842695096},
{0.03302043843217502,0.15553918787102744,0.9872776770909835},
{-0.932328445776977,-0.3586816626668758,0.045947078923604744},
{-0.41548286783094823,-0.10820350012133303,0.9031422861877655},
{-0.4852186398020979,-0.49012050577387045,-0.7241165385547877},
{-0.9057891889044152,0.06879290748061442,-0.41810702116114373},
{-0.9259244306035489,0.29567743220014003,0.23502937029023724},
{-0.45663740967601624,0.11052280944664872,0.8827610008809849},
{-0.10182364108732797,-0.012459809592559809,0.9947244338311169},
{0.34850571338899894,-0.7730498729996228,-0.5300355286115186},
{0.3852151619616468,-0.16613582527297746,-0.9077489556896933},
{0.45392834189152403,-0.3464826506879109,-0.8209134139480794},
{-0.17900871733126147,-0.7913204629784376,-0.5846091035820498},
{0.04017059438240522,-0.9958443950585906,-0.08173288308480277},
{0.4801221090957773,-0.7932982730471739,-0.37438030174916237},
{-0.2834012563795111,0.0971350040028933,-0.9540694518114877},
{-0.8099647635641716,0.1567951979836891,-0.5651303811278344},
{-0.5382557133360436,0.42153232419328784,-0.7297885219166657},
{-0.051035804398163125,-0.054685398450924405,-0.9971985027393975},
{-0.09527856112130631,0.24120398061376774,-0.9657860195336888},
{-0.48890222141332706,0.4936225619758521,-0.7192436195097668},
{-0.8299032512570487,0.48082642995272906,-0.2829603113722727},
{-0.9706741643506637,-0.005005497641848842,0.24034685697029237},
{-0.4688391728099305,-0.8737791663332918,-0.12922770028441083},
{-0.7357062358942041,-0.6547324932279862,-0.17338309253744036},
{-0.416346085294543,-0.8778175602650158,-0.23683806313657535},
{-0.028926125228124648,-0.941806023926173,-0.33490997682311563},
{0.5599431105265829,-0.24400574416493093,-0.7917858989577505},
{0.6598186277918358,-0.08301644266768719,-0.7468250455533089},
{0.7508387426151876,-0.05284882728002562,-0.6583678182013228},
{0.042067517593183286,0.35481624565309533,-0.9339891625624943},
{0.8486430254259952,-0.23139573546377215,-0.4756690330523879},
{0.13202572044922153,-0.9602134888943995,-0.24608792104674437},
{0.15232455066275774,-0.0801023566714511,-0.9850791053113798},
{0.8400174689800168,-0.19882751127392737,-0.5048150875013768},
{0.8331210392851405,-0.14978211526970792,-0.5324233765019897},
{0.4577474915314041,-0.4335726128702765,-0.7761971549584219},
{-0.5174766295358209,0.031440395806902895,-0.8551195468446223},
{-0.45089299469134914,-0.5248152516413586,-0.7219864673128469},
{-0.6155576523038498,0.16582667843160043,-0.7704481094859764},
{-0.37242313723318743,0.34092441778799376,-0.8631752708513537},
{-0.5034247236000926,0.41774604480763017,-0.7563410538346784},
{-0.037895983764045446,0.27515397423951554,-0.9606529992014574},
{0.49872532367227673,0.25420732281629976,-0.8286444886406669},
{0.7067209326162498,0.002195962118966182,-0.7074890113297803},
{0.8176202018766675,0.0624073281355159,-0.572365731746882},
{0.8474249423380618,0.03866732055434095,-0.5295052458894816},
{0.24039441749916673,0.31289992198893274,-0.9188602520811072},
{-0.17550724633396084,0.21094776968687173,-0.9616123153061242},
{-0.36795512346891734,0.11796986785470145,-0.9223297335504902},
{-0.43558549363084886,0.23087171496299044,-0.8700365101353033},
{-0.196457555463941,0.029511385690455683,-0.9800681134573055},
{-0.2596515944699907,0.12763479568219088,-0.9572305931280909},
{-0.18205781623238954,0.3516672962821177,-0.918251089993537},
{-0.1340671903513524,0.11013164205702926,-0.9848334934846177},
{-0.07421662921493861,-0.10266798440656576,-0.9919431319011516},
{0.5973989718212633,-0.14917184990355706,-0.7879481122911888},
{0.5518499630926967,0.04378996412743127,-0.8327929258082752},
{0.9025229427684206,-0.19819056489163514,-0.3823255651464661},
{0.9692172556412382,-0.13448363264785412,-0.20623303304054813},
{0.8259214534835896,-0.007409726945555567,-0.5637365063770013},
{-0.26124990581020563,0.09082886701468307,-0.9609883472919887},
{0.16819704019280815,-0.19066537642547457,-0.9671382889240354},
{-0.37684845803853273,0.19590199632494038,-0.9053218474718719},
{-0.3231778783316727,-0.005037924468985029,-0.9463248270409497},
{0.584650012687124,-0.04879055642886729,-0.8098171671854748},
{0.5514214468267365,0.09577233609916178,-0.8287110760799675},
{0.8818999419504033,-0.0494812452560577,-0.46883269804460653},
{0.7438582345550739,-0.2140729515572768,-0.6331253416948056},
{-0.07923515444496866,0.07284746794730171,-0.9941906440485893},
{0.2585004739407968,-0.1867338536450855,-0.9477911019181597},
{-0.6043994690123036,0.34918219087327373,-0.716081754714213},
{-0.45958914948853447,0.08825206884898525,-0.883736038654235},
{-0.002344108406283855,0.2503530750613934,-0.9681517664927767},
{0.034350615343853,-0.018789397504817375,-0.9992332028945519},
{0.6758079020192181,-0.02732522888739959,-0.7365711177032629},
{0.46030168756859263,0.0641941272270072,-0.8854385751993576},
{0.9683506908646234,-0.06762486508069425,-0.2402578138684031},
{0.9764808140629172,-0.007534044130753598,-0.2154726385090655},
{0.9992958087906084,0.030079725168219048,0.022429816480037983},
{0.23204233252506948,-0.01133851371390585,-0.9726396013031161},
{-0.19153427598036357,0.28286070655740464,-0.9398427750483184},
{-0.13110353074238773,0.10607998292132834,-0.9856768747669239},
{-0.21902235135095752,0.19686840667569647,-0.9556526775255069},
{0.2284314697348094,0.09066402341799111,-0.9693292002681322},
{0.03604131358459974,0.17380639120601518,-0.9841200953598286},
{0.5289467067766206,0.2828886041567399,-0.8001183781343977},
{0.8624014551425244,0.01922910558783808,-0.5058596363284464},
{0.9572853153500716,0.22069871619482992,-0.18680712428884436},
{0.9878565364966133,0.1416606190818102,0.06381012695704213},
{0.991646113301535,0.08743283801466664,0.09483398552555126},
{0.9279779945286007,0.1641672840423403,0.3345234588498063},
{0.9865687253192811,0.16275654827587624,-0.013872858941523352},
{0.9738746686551153,0.1553547120907377,-0.16562923408352023},
{-0.5419225742490499,0.47154041221808257,-0.6956792099556257},
{-0.5727252580568064,0.323759085372499,-0.7531041318586211},
{-0.4758665268618507,0.12905330845687293,-0.8699978690713988},
{-0.27428343247421494,-0.042192256140156086,-0.9607228592013236},
{-0.352331843817919,-0.0060260399636096,-0.9358557360374635},
{0.1608652680915922,-0.3560749163978644,-0.920506936114049},
{0.5855863476145818,-0.3396520856828168,-0.736019762084366},
{0.31564164852743903,-0.5125288782115544,-0.7985515003517846},
{-0.7840827078904274,-0.2813782747253133,-0.5532093398523028},
{-0.4132458071800457,-0.06720357397469438,-0.9081363237384243},
{-0.03756371395170529,-0.2431479863182261,-0.9692615870566347},
{0.017143013174221806,-0.46458507569557334,-0.8853625384780219},
{0.6582902154845754,-0.48186449891654465,-0.5783256840926042},
{0.440762343786436,-0.485957376968062,-0.7547012548487041},
{0.04896490168441271,0.020737150067800903,-0.9985852036807381},
{-0.2874794883114612,-0.24964263144504276,-0.9246805396272678},
{0.33180893275161344,-0.48562640878882923,-0.8087458335182323},
{0.6756529675274995,-0.3140937432734926,-0.6669619088881531},
{0.6268234022318732,-0.20213748273652962,-0.752484458635126},
{-0.45666001234565384,-0.12398946626373512,-0.8809587081016348},
{-0.09695021644719044,-0.46956291713516823,-0.8775598682610515},
{0.4953774633535544,-0.4352195099191742,-0.7517879667746165},
{0.7633633198546808,-0.46669417282749975,-0.44662399280524134},
{0.43511497017470085,0.07146510193822414,-0.8975342344082639},
{0.005534108474221255,-0.23668193084932945,-0.971571426737545},
{0.22021141035410408,-0.31297902105146125,-0.9238782750619939},
{0.6908347531624114,-0.4837318010195977,-0.5373554582446952},
{0.9727593732895005,-0.2221645369922509,-0.06619758440031588},
{0.9751149859439833,0.06475450311675487,-0.21203211670303077},
{0.40684967430735747,0.283942444129895,-0.8682453748437353},
{-0.22394128029615065,-0.046294196719899275,-0.9735025168582668},
{0.07364877409083902,0.23065817712359127,-0.970243610337599},
{-0.2679121788967515,0.280371253703417,-0.9217456398028521},
{0.4310796669933932,0.14133614779460438,-0.891175860328054},
{0.6225303057886498,0.3043298798125449,-0.7209988506426154},
{0.6574885377200416,0.271923561101832,-0.702685135522632},
{0.8799125486047327,0.40826742566774,-0.2430465304145698},
{0.8402561212519821,0.24086047318393503,-0.4857529033944989},
{0.9695902555997792,0.19372821710668545,0.1495463611814736},
{0.8965150630215498,0.11672735434604764,0.42735870942668147},
{0.8999884946692974,0.2793615720538207,-0.33463087353457044},
{0.7843383043749388,0.4495667310751848,-0.42743792368087596},
{0.3106932347043303,0.2990289823171264,-0.9022479601768816},
{0.4631645436765316,0.14993565611992218,-0.8734975125922217},
{0.9259911985031419,0.13572879423647738,-0.35230383862488196},
{0.6443762608845575,0.3989253974368536,-0.6524091980408349},
{0.8192323837066239,0.5430253619406776,-0.1843414163327359},
{0.9902911159511942,0.13679157213896279,-0.024729970883310977},
{0.816692844228601,0.551290917961836,0.17056119710706255},
{-0.4423353742574294,-0.8899495261169673,-0.11103719036757581},
{0.0016931775846374944,-0.9759654479718534,-0.21791874062311972},
{0.3129129830947122,-0.8656755416191153,-0.39075736928843713},
{-0.8082449879341851,-0.3089281733340066,-0.501301728702169},
{-0.5390641664041795,-0.6744271539841201,-0.5045372518138248},
{-0.27781648209071474,-0.9606272335169168,-0.003649726616414785},
{-0.15514702448457104,-0.9878866952566157,-0.003046002059480596},
{-0.19359887468074036,-0.9361576744492023,0.29347620736988644},
{-0.5761021893320835,-0.8078838430738463,0.12421740436433686},
{-0.09094050189737354,-0.961882184850877,0.25790015040933445},
{0.4786199712561694,-0.8244215269884467,0.3020795738754633},
{-0.45881046968177114,-0.8145303376833223,0.3550116644617267},
{-0.4468837382868561,-0.8886661875856049,0.10279752670580695},
{0.06524590836670473,-0.980415000430435,0.18582087711663042},
{-0.15228235959572112,-0.9437114214325978,-0.2936304412243823},
{-0.31655362535376014,-0.7668265331591264,-0.5583644601141324},
{-0.5192078894413021,-0.8048899758672844,-0.2873591729704673},
{0.0015605240847861484,-0.8404574439147386,-0.541875308288618},
{-0.15616613834294513,-0.9604898452432925,0.2303722952517687},
{0.16080075785686956,-0.8974479609533219,0.4107679072826664},
{0.25424544809616983,-0.6995428787642062,0.6678315752438371},
{0.13262473675118222,-0.8860494144798451,0.4442151666721921},
{-0.43738395915857203,-0.8246247665765981,-0.3587328624746603},
{0.09077678643453321,-0.023039842241127022,-0.9956047110746931},
{0.6021924732768877,-0.05041559786329139,-0.796757486705178},
{0.9095033440577815,-0.0842551443938183,-0.4070684681855},
{0.9460336204852595,-0.28493216136603694,0.15438281099536538},
{0.8833959771249709,0.10456177014590659,0.45681329208263277},
{0.38043002028831163,0.08968039991612846,-0.9204512075793686},
{0.6728004179409447,-0.19062534722700797,-0.7148437413960291},
{0.89176540708384,-0.21815395092429574,-0.39643828324811525},
{0.8881412544468332,-0.3612674285746033,-0.2840615377003713},
{0.9860714119249161,-0.16453558175233482,-0.024314870384667286},
{0.9644888246692386,0.0917866663442063,0.24766209837108363},
{0.984146919962431,-0.17172823588497435,0.04431989314399444},
{0.9386167592009114,0.31347324285501327,0.14398994881984054},
{0.6424166724723495,0.33510353688967065,0.6892071085628668},
{0.8131510683484432,0.3970973364366827,-0.4255573350779865},
{0.8833645461863024,0.17198721851678309,-0.43599022375269847},
{0.6366648281815301,0.40517860211665,-0.6561159935128698},
{0.7230226292794742,0.16422966214771176,-0.6710192960121523},
{0.9948615067163156,0.06400110960284729,0.07845024170610669},
{0.9532748932631631,-0.3019664886161463,-0.009122369590176576},
{0.9024160032608888,-0.34039474177938916,0.26415294211419715},
{0.92571952364177,-0.1677417416289399,0.3389779810898406},
{0.9085332288262504,0.2749080880335774,0.3146313958464267},
{0.8192323837066237,0.5430253619406776,0.1843414163327359},
{0.7350639092555852,0.43896770234591787,0.516709207975862},
{0.864658892804468,-0.4646022912635579,0.19107514240948192},
{-0.5998030495114159,-0.730477998668689,-0.32655504169709687},
{-0.7724388474079,-0.6209281960872755,-0.13336567144117983},
{-0.24810138300474957,-0.9445266239769275,-0.21520957309069286},
{-0.4183753843893082,-0.8997121496694527,-0.124418991614106},
{-0.4200414946838562,-0.8910641058047314,-0.1719590128204004},
{-0.23133578074317576,-0.9469157086466335,0.22323619165849676},
{-0.3620470178810627,-0.8522547843807828,-0.37760262094362484},
{0.3195281740796388,-0.8999548371849729,-0.29661934696964926},
{0.03723273926905054,-0.9979320097758775,-0.05239682233877288},
{-0.6043506955890657,-0.795020046638953,0.0519938667845472},
{-0.43285949986629363,-0.8594013218419616,-0.27214338388392173},
{-0.3353063172752192,-0.8251976269052878,-0.4545531323676162},
{-0.3644935205749364,-0.9182947380117872,-0.15452911569911823},
{-0.5085475556232715,-0.7085361142092114,-0.48924018491013915},
{0.11943480642584503,-0.954705138460205,-0.27253151306170403},
{-0.27122831111344853,-0.8970956115981594,-0.3487902907219045},
{-0.8881828333625313,-0.15449887416965868,-0.43273704764026616},
{-0.3510632867679709,-0.9336431287487892,-0.07116935312226261},
{-0.13197611985488317,-0.9570522666237737,-0.25813419521316167},
{-0.38776067668009356,-0.9194540613741626,-0.06516046840802654},
{0.0989673344560979,-0.9722994871141565,0.21175262470204043},
{-0.18553637835378062,-0.8542025461557093,0.4857100600651236},
{-0.49595119077805616,-0.8403584583983167,0.21870088651908293},
{-0.1795993653199813,-0.9825197356602516,0.048979965442711396},
{0.2658970661824578,-0.797867992814883,0.5410225653677593},
{-0.19457028884530897,-0.9439203870215946,0.26675214275363557},
{-0.45753302707238436,-0.8808923000118203,0.12121173589164515},
{-0.1698192703733343,-0.9849840954711654,-0.03110863350773259},
{0.02567543046197162,-0.8649884462373777,0.5011344731171861},
{-0.7550705052175891,-0.5381792237009698,0.37447517317851153},
{-0.6563561233613668,-0.5923672584774758,0.46722336244019075},
{-0.5460367934253669,-0.8329821769664584,0.08935610265652125},
{-0.6572649619859354,-0.7536189203047454,0.007828965725848885},
{-0.8532171982207502,-0.5195548346873725,0.04564193700217162},
{-0.8376387818206682,-0.5361193076881253,0.104581829750642},
{-0.5316075578729854,-0.8462440634500399,-0.03555825484870294},
{-0.642969452698164,-0.7654769294040403,-0.025206218422946035},
{-0.7208503103823147,-0.6929973339203944,-0.011380913888875651},
{-0.45318037611577855,-0.8089027427137764,0.3745716213672513},
{0.39356019850332247,-0.11773954981564862,0.9117279027008188},
{0.5505330962528526,0.14101976511855235,0.8228163438922173},
{0.14258449759728786,0.2453927535587762,0.9588806273701491},
{0.8466768569720052,0.225979131618382,0.4817382400650882},
{0.7039115685999218,0.23566711637205648,0.6700518740008697},
{0.9159183128653865,0.1961796871047475,-0.3501530729913809},
{0.9483173848923653,0.16929441110789936,-0.2683906478969322},
{0.9013565713958523,0.24194834930106374,0.3591898209470924},
{0.9179016228095835,0.3913021537272819,0.06587287250396548},
{0.6888327907634199,0.4413596048769149,0.5750748521296791},
{0.4677535020663134,0.2744754177148702,0.840160643195661},
{0.066392142178869,0.338004674591173,0.9387997248675651},
{-0.15567850884905748,0.212504445648435,0.9646792536704547},
{-0.043589218943539794,0.21871240472794512,0.974815297382028},
{-0.040983536630759126,0.20257074233187644,0.9784096504411369},
{-0.42076814834667087,-0.8394107455553013,-0.3440112869997254},
{-0.863532125032663,-0.4828120962167605,0.1456185042614807},
{-0.8341898559285728,-0.5322872484669058,0.14421362413238747},
{-0.794851231372033,-0.606803416658825,-0.0010646678070137848},
{-0.7635544483540864,-0.6371012980677034,0.10529264171410184},
{-0.796687783658625,-0.5414323719382681,0.2685880898074387},
{-0.8997269484749907,-0.4355007535229598,0.02881860282552857},
{-0.8814984897029962,-0.4598555814740647,-0.10720660818478855},
{-0.7761374766155568,-0.6179079862017669,-0.12569939530846125},
{-0.817558195841531,-0.5758327862516466,0.003898549731178311},
{-0.7737837259686289,-0.59650461437888,-0.21316892468371076},
{-0.8483436602151704,-0.5214556099117941,-0.09163558841545451},
{-0.13699139921758607,-0.9594944199921813,-0.2461784201433492},
{0.9590340452714009,-0.28239139480898023,-0.02255659877311362},
{0.8771499315911773,0.3662581821442982,-0.31058483788161195},
{-0.21558095549407433,-0.9736620004849762,0.07421024484433532},
{-0.7090751571321404,-0.5436893337537011,0.4490148437418155},
{-0.8409647417428057,-0.5141735328204918,0.16853451068653813},
{-0.7676827637865845,-0.6404342643797832,-0.02251948474803338},
{-0.859982839322366,-0.49915110962120357,-0.10619644925779273},
{-0.8962666608706317,-0.27862613071095804,0.3450703578936448},
{-0.1919408622332718,-0.866260508720199,0.4612498633462888},
{-0.42218452098424947,-0.8959284134298484,0.13810325213540176},
{-0.7167875812510378,-0.5630228229216293,0.41136463658613937},
{-0.21499454325563222,-0.9704521144572384,-0.10954469369064451},
{-0.6992454366511669,-0.6397492378087372,0.31902465742581565},
{-0.7545618289167517,-0.27409742898006195,0.5962441159192488},
{-0.5853237937773447,-0.7199984009818355,0.3728248369163413},
{-0.27701252224141915,-0.9331401484958908,-0.22915829853294434},
{-0.5901434416255762,-0.8065666796474287,-0.03436436510168835},
{-0.6196437598553336,-0.7567862055629662,-0.20812556292285067},
{-0.18820779439049534,-0.9477174041697523,0.2577005005125357},
{0.5763999935172227,-0.7615599289729776,0.2962929665989708},
{-0.6481626548874225,-0.2964439925952158,0.7014314877901445},
{-0.8613587427791075,-0.5073449059887088,0.025734463377024536},
{-0.5415557618239196,-0.7889435616317473,-0.29031950226453507},
{-0.47067770947273185,-0.8658780140240095,0.16946314831059744},
{-0.012066297083430736,-0.9958736793472458,-0.08994453434241288},
{0.44970316674149713,-0.8719293730835481,0.19366525288961947},
{0.4168818330916292,-0.8658296715216178,0.27667402688169035},
{-0.9107558222500831,-0.40900325873030113,-0.05692246116929149},
{-0.7033289196468592,-0.44979747745278825,0.5504640406652286},
{-0.8221026153080776,-0.5175936273393469,0.23715844248374593},
{-0.7861337148030397,-0.49105820690150587,0.3753073672133961},
{-0.6529606230622665,-0.4806081857900078,0.5853701363084507},
{-0.81649232461473,-0.5637191717067291,0.12474365432964425},
{-0.44038689408572396,-0.7080166791892336,0.5520613783877472},
{-0.004996175825501846,-0.461127147745021,0.8873200053191984},
{0.09700134536209443,-0.3072447167733354,0.946673873629571},
{-0.31585006199031984,-0.4684664418420656,0.8250926803750871},
{-0.3617599527616372,-0.6143031406840823,0.701257005614611},
{-0.330487857044558,-0.4195617742877936,0.8454263385432076},
{-0.04690786726381379,-0.01944041864914133,0.9987100290432186},
{0.048653498337995704,-0.13781948610276107,0.9892616571715722},
{-0.46041556892677005,-0.6015702277846686,0.6527869215394413},
{-0.5650506828865822,-0.5472493015574786,0.6174430562523633},
{-0.5968224383585052,-0.16862677987559968,0.7844539414016569},
{-0.7541199536110517,-0.5219073662395713,0.3986424420838043},
{0.1095179311136583,-0.6392271778875973,0.7611796357066065},
{0.26241665558919847,-0.35887444402125557,0.8957380377642867},
{-0.4004005417712412,-0.030919732729511405,0.9158184188348868},
{0.46978354646003084,0.6403678631888169,0.6076449779850276},
{-0.9018826058740265,-0.3244758099058722,0.2851722532221598},
{-0.6951447039324908,-0.5165120807343335,-0.4999891109315273},
{-0.783887175978964,-0.6180336153166758,-0.059626719466393516},
{-0.8261465922923347,-0.5633809519839633,-0.00914937076558973},
{-0.8741532246924327,-0.46594025820871876,0.13695187308034124},
{-0.6853069075871511,-0.5354206599468595,-0.4936386930897997},
{-0.20902637851768718,-0.8385350002372546,-0.5031570594366019},
{0.9393922354833673,-0.2797411631991111,0.19820976142856853},
{0.9995843221507622,-0.02857010414093383,-0.003864202346870369},
{-0.5400797817540692,-0.7180674193675428,0.4389681202357574},
{0.5175694601337192,-0.8521622239024494,0.07708046503830952},
{0.5153891741243497,-0.749376427040076,0.4157029826595791},
{0.06943186076829172,-0.7152480221959386,0.6954131746343684},
{0.1748014902461874,-0.13712958402698244,0.9750076492993779},
{0.162723770642036,-0.06114481083548477,0.9847752467319286},
{-0.5606119977963454,-0.7828100115245596,0.2700419852239818},
{-0.5135429841250488,-0.10026434973431547,0.852185815200121},
{-0.41773166185116833,0.024970015389254765,0.9082272606669113},
{-0.7191789466680123,-0.6806726586881688,0.13952194946985147},
{0.40939691591956917,-0.6704273996869456,0.6188063242926221},
{0.1170745475317417,-0.7196725837040618,0.6843719183199717},
{0.41369429006229796,-0.1280511393215179,0.9013655973512149},
{-0.1722548145341926,-0.23804005656805086,0.9558583631160372},
{-0.7793963446006086,-0.11317949741095511,0.6162237737940766},
{-0.6661192774747327,0.11426505704177205,0.7370404364183695},
{0.0195748046844398,-0.9320337742620377,0.3618423284476636},
{-0.4568052791030011,-0.8888432528984817,0.03586932896605855},
{0.3037443515418082,-0.8789875006557561,0.36758719046968075},
{0.4744594060214334,-0.6442578081489031,0.5998501051737508},
{-0.32865039094370574,-0.9019951303179142,0.27998875944458596},
{-0.668285187519298,-0.7433686860741971,0.028247207058729285},
{-0.3346494429190871,-0.7657199662612253,0.5492564825496851},
{-0.3386013276839101,-0.07873104651245234,0.9376302913226233},
{-0.20825369343839728,0.027476324036441825,0.9776888312682673},
{0.4278059536268107,-0.07995857127688809,0.9003269922205009},
{-0.6957679624908456,-0.039785717691261324,0.7171638857605204},
{-0.8578429274315523,-0.508663644246729,0.07325850720088105},
{-0.7913547104425741,-0.2504566764784395,0.5576998973172973},
{-0.19606894168038536,-0.28290543260967427,0.9388937566669971},
{0.40518174140751034,-0.19846379937109562,0.8924348025313485},
{0.5363366694890326,-0.2170213545296721,0.8156253482080597},
{-0.43283037543038544,-0.24274244841970635,0.8681785356941265},
{-0.867777144407105,-0.223496206988821,0.44386064604362085},
{-0.5598820906815275,-0.24172825922732888,0.7925272823221969},
{-0.540092207219763,0.06518304219763356,0.839077814454861},
{-0.41800029630033936,-0.47036626405951426,0.7771945251528242},
{-0.610559320144659,-0.0013912061727587661,0.7919693056740752},
{0.19004586585448485,0.007969673146029924,0.9817428651034672},
{0.45249103290577825,-0.015675595392185347,0.8916311686168011},
{-0.7463706938458029,-0.6562188820216502,0.11093947109297957},
{-0.7053995107143404,-0.6918873484218067,0.1539591743866233},
{-0.17710308065212035,-0.5304298054295444,0.829022750191757},
{0.0966323851235104,-0.7831952784168573,0.6142209195484009},
{-0.27277316620316144,-0.35401150003632753,0.8945784804261345},
{-0.08126804408841624,-0.10329044107182069,0.9913256729214834},
{0.47686619731974556,-0.4641309990947189,0.7464456078865651},
{0.38893102651055855,-0.35870588710762197,0.8485651083869623},
{-0.20958234964853675,-0.34303167103197935,0.9156443148869577},
{0.12205912172936224,-0.2458134344448684,0.9616014383563886},
{-0.5907604961806096,-0.2263721840641949,0.7744402303822073},
{-0.2965827324576706,0.047147360237800126,0.9538426543358968},
{-0.5826278986973571,-0.08732408968509627,0.8080341793638259},
{-0.4339523233408526,-0.08008883590108686,0.8973690207663093},
{-0.5289572308197046,0.006276157970831033,0.8486252752567973},
{-0.9616579015376084,-0.0036641678189683023,-0.27422737697844457},
{-0.5423176225748896,0.017473576794013505,-0.8399918275547347},
{-0.7013940045195542,-0.6901564567184457,-0.17813061408377742},
{-0.7507522937003784,-0.5816155765699735,0.3132001190849037},
{-0.8262554565879853,-0.18663709746508542,0.5314776705642376},
{-0.958479103335721,-0.23435999011380032,0.16245985197153145},
{-0.7345268895379855,-0.19831743226617524,0.6489533454763934},
{-0.83458761544948,0.41495191506163975,0.36232364030660297},
{-0.8506084917797265,0.42162280328339985,0.3141646152316751},
{-0.3322884574668085,0.015070242623407658,0.9430574048389634},
{-0.5049859862277252,0.4781813489229565,0.7185622807076875},
{-0.8213440441584757,0.17515496850760104,0.5428763193698001},
{-0.7450155501708514,-0.6641424085008245,0.062182724565167054},
{-0.6500178612000154,-0.7405133735813925,0.17063623199093084},
{-0.897911822825342,0.43961026991375046,-0.022297287207895714},
{-0.502937569123277,0.4471928938256195,0.739643371684109},
{-0.10483263022921965,0.39723276589739076,0.9117106171021223},
{-0.1610129048789851,0.3035241514884316,0.9391208303118713},
{0.1581352081221338,-0.2078422354510242,0.965295219668517},
{0.09223839651869457,-0.7281172050594369,0.6792182373170602},
{-0.3792034157605099,-0.8773973521266382,0.29390245993649994},
{-0.7424266419592315,-0.6687651221513475,-0.039444805780130994},
{-0.5941139544284005,-0.7834038509268768,0.18250209726572497},
{-0.40360647035626523,-0.8721336255921514,0.27655877530471956},
{-0.9533473332914728,-0.21533382138725754,-0.21156608299252025},
{-0.83458761544948,0.4149519150616397,-0.36232364030660286},
{-0.8248385273437019,0.4689771251802666,-0.31575601319234736},
{0.7079419864892184,-0.2867323402555058,0.6454476809295236},
{0.5870872513614853,-0.048178825619438294,0.8080887080331886},
{0.13198535352568908,-0.9318130630395204,0.3380891628011841},
{-0.0732804522358356,-0.9727375117191858,0.22002660887828623},
{0.016586364080808064,-0.8990536631374784,0.4375241745614296},
{-0.1835498833602759,-0.9830103960520546,-3.9648602096408786e-05},
{-0.5269511580066624,-0.8198020684578776,-0.2241585278940393},
{-0.651066446659896,-0.5750554448697279,-0.4954025810987829},
{-0.5853237937773447,-0.7199984009818355,-0.3728248369163413},
{-0.7545618289167516,-0.274097428980062,-0.5962441159192489},
{-0.27400500008790724,-0.2781469384755337,-0.920627796964394},
{-0.18536990715653082,-0.4792530492641363,-0.8578779122298268},
{-0.08126804408841624,-0.10329044107182069,-0.9913256729214834},
{0.8222832353548808,-0.1219898135469028,0.5558495895879583},
{0.8665120719999571,-0.17180064132316436,0.4686591178237021},
{0.8698921461089308,-0.22435926142258608,0.4392613982037462},
{-0.39226964474926096,-0.07939666974736467,0.9164173146778255},
{-0.23133578074317576,-0.9469157086466335,-0.22323619165849676},
{-0.3622780997851569,-0.9036501229230113,0.22840979347935716},
{0.3422938675656172,-0.935832523299602,-0.08397854822317259},
{0.5988797039932924,-0.7309573740953136,-0.3271764316092927},
{0.05374165061913592,-0.7678661605866697,-0.6383520928254387},
{0.7951579970599032,-0.14025965556265688,0.5899584635659767},
{-0.6377736893490967,0.5557150924441382,0.5333155324982056},
{-0.6565135447357493,0.18703352771530246,0.7307588008973074},
{-0.2657284207265082,-0.840037273157639,0.4729966026559535},
{-0.7896914263841343,-0.5979268047177672,-0.13737171213678853},
{-0.3918514371595877,-0.9101579708595625,0.13440580075565753},
{-0.8789711929169807,-0.40137198541016483,-0.2575076141592753},
{-0.5135940368851575,-0.16008914774687902,-0.8429665652027282},
{0.04518299222363811,-0.40918966932715,-0.911329968633566},
{-0.6189820448701923,0.08195390775676081,-0.781117651273937},
{-0.615842618448152,-0.1517968732939523,-0.7731077405906007},
{-0.38265692451667127,-0.0020739772314677662,-0.9238881841098987},
{-0.09854034353490093,-0.424316503638986,-0.9001362704810923},
{-0.03684786114420573,-0.19290502842764248,-0.9805253108086645},
{0.33395293611122706,-0.2772336521029318,-0.9008978513707097},
{0.4810865148387525,-0.5563187940882779,-0.677543478003048},
{-0.42767195274994846,-0.11450096794205677,-0.8966527918717354},
{-0.2388201697094189,-0.568130926029263,-0.787522810735725},
{-0.7603634423032348,-0.08956183064202768,-0.6432931789633899},
{-0.08455967704470042,0.002307645798382732,-0.9964157444505607},
{0.05968768758708086,-0.25801551543609014,-0.9642952731112787},
{0.41140405148400816,-0.017284647442246677,-0.9112891678196008},
{0.3324536809409437,-0.32701561955194636,-0.8846102727178076},
{0.4393251519367429,-0.27838513497657924,-0.8541048691465407},
{-0.5181185755471538,0.06584822170969111,-0.8527702817117044},
{-0.49385371357897173,-0.13680124187270912,-0.8587164431908496},
{-0.8468710114643512,-0.23817515052274418,-0.4754809014196204},
{-0.5594588458645037,-0.07365119825584365,-0.8255793727918812},
{-0.25001825558731944,0.07892359994740962,-0.9650191382788297},
{0.005069247292202848,-0.24477615783831136,-0.9695663645598503},
{0.25097720114641947,-0.02067658544118871,-0.967772144318694},
{0.30569569902413163,-0.2482178022082344,-0.9192051252386821},
{0.4420447135005967,-0.1841202130989367,-0.8778930563540057},
{-0.012247052473423526,-0.10910452775208332,-0.993954833847951},
{-0.7881811796069732,0.06663505974921721,-0.6118252993507038},
{-0.7855179562986271,-0.016442631564371177,-0.618620384565257},
{-0.5803392128552227,0.07286043307981767,-0.8111089663627211},
{-0.37465864286442774,-0.14965537492297726,-0.9150050109609501},
{-0.00026723662032066914,-0.001689709677913493,-0.999998536731826},
{0.1682239612038969,-0.2529104358491588,-0.9527523341957543},
{0.22353972124133617,-0.13962322056709126,-0.9646426018509753},
{0.2760400522772976,-0.34813187887935654,-0.8958828519659675},
{-0.572875572199097,0.050182578499051694,-0.8181046923180085},
{-0.6735694048816274,-0.2594218750172806,-0.6921015442620604},
{0.21966695857895024,-0.5737859308047734,-0.788996915658847},
{-0.7728899815469991,-0.5032977714911115,-0.38643554396090507},
{-0.5955244757905555,-0.42716336880072503,-0.6803543599398773},
{-0.3566095813533518,-0.08007045272057565,-0.9308159480198592},
{-0.2977829336127889,-0.3959294061144608,-0.8686571416979264},
{0.10954447725184213,-0.12033381114083956,-0.9866710603843316},
{-0.013230760644615711,-0.3793595527238348,-0.9251547312368548},
{-0.4620587678352433,-0.4322525348734841,-0.7743768082542402},
{0.10453004450610792,-0.4551692190648844,-0.8842479583303624},
{-0.39215676454560183,-0.6222620429943788,-0.6774976176117428},
{-0.7548957548796605,-0.598713840830315,-0.26772025710222197},
{-0.8279760760220463,-0.4833607906087525,-0.28428500424260233},
{-0.7123193086156883,-0.5979290821756682,-0.3675350531062726},
{-0.7403202494802934,-0.5047806561071592,-0.4439847040489818},
{-0.9303518573657268,-0.2337462394941512,-0.28250330443817},
{-0.9078892677607215,-0.3372645724614635,-0.24897727937963923},
{0.6630897589848677,-0.339853805549066,0.6669417983476578},
{-0.3373893889390075,-0.2342327330550468,0.9117584257888305},
{-0.5066656925998149,0.38157289498389485,0.7731054273227936},
{-0.5748378506989902,0.4337659666210216,0.6938360985168587},
{-0.4915196130688858,0.008859932079767412,0.8708214349521689},
{-0.6618084231996386,-0.7100546461293168,0.24048286943601382},
{-0.17296183358485875,-0.8383777380269462,0.5169206636455781},
{-0.17840483424887799,-0.2640850805483342,0.9478558884917107},
{-0.3518164437862706,0.3069303215861757,0.8843183632451544},
{-0.49951868186425286,-0.8660573147389574,-0.020635262434620473},
{-0.5716991102512702,-0.8191767736446697,0.045929738285946736},
{-0.25762996265676236,-0.8893717998581616,0.3776832058200752},
{-0.5864084928231758,-0.7815936229473721,-0.21268871176640355},
{-0.7272208977325006,-0.6786724093610179,0.1027303590631647},
{-0.029757732159565963,0.29636234758827673,0.9546118773138562},
{0.3339727584620894,-0.409203986460714,0.8491256055907646},
{0.14974262200972963,-0.9458756998520195,0.2879171887593785},
{-0.3592611098859555,-0.9188966787512487,0.16297346011984876},
{-0.5234413301055282,-0.7915993816321919,0.3152452901105534},
{-0.035951989230506486,-0.9990826797830222,0.023264853920549743},
{0.7129079412589451,-0.21418733167480478,0.6677469986753665},
{0.5403182386830513,0.1074415577211073,0.8345732518005279},
{0.030744605870551257,-0.8529597939883493,0.5210703974025174},
{-0.5160828726139784,-0.8494856834538707,0.10969294508497074},
{0.22251198976402028,-0.9464744259460866,0.2338259511715548},
{0.44786822585779185,-0.8940812770991432,-0.005720332836364031},
{-0.1985003254299901,0.21765189879597274,0.9556282079107418},
{0.1469665849200344,0.08267535678402607,0.9856802769141605},
{0.8601187561791601,0.07921222780332988,0.5039058922410492},
{0.8694951540572788,-0.004347731457258564,0.4939223363061084},
{0.13809114128994635,-0.5198077978025598,0.8430484505892252},
{-0.1865098376033205,-0.20596099578147056,0.9606217511038817},
{-0.8394217044132,-0.32874079821802576,0.4327824970432767},
{-0.8739488468247915,-0.4722559487221316,0.11483785103430168},
{-0.03493326257744406,-0.9986955229321118,-0.03724137002113197},
{-0.7870292731739498,0.06339342427027146,0.6136498976831769},
{-0.5073146966076121,0.24406733031163186,0.8264762167663867},
{-0.38816584642127094,-0.20663795920346115,0.8981247293601746},
{-0.2522565662636133,-0.9675424910094848,0.015104729989393781},
{-0.255288147610856,-0.9414470480814919,0.2202394545672114},
{-0.4143717025689367,-0.8159431883626079,-0.40315357554507986},
{-0.7920023563958393,-0.5286602854856071,-0.30536956301130336},
{0.6670175972505384,0.10984965330700364,0.7368993001940289},
{-0.6432734536855026,0.2555384756955794,0.7217335735731746},
{-0.44421928835376806,0.214145094890167,0.8699489078037589},
{-0.03772080808120667,0.04798903233197692,0.9981353582623658},
{-0.05441182483293861,-0.37799904844651494,0.9242056441571209},
{-0.3292612884247002,-0.9399481310616428,0.08991393028130414},
{-0.08866633525920559,-0.9867789949811027,0.13566685688032742},
{0.11473610934737631,-0.9920415898176614,0.051856622372399526},
{0.3186867031979599,-0.49486355363562484,0.8084236813007996},
{-0.11406873802077637,-0.03154856392670269,0.9929718078175785},
{-0.11694656663115804,-0.9904383438129889,0.07318051419720835},
{-0.14715619250452874,-0.9381613128458938,-0.31336624911888483},
{-0.239497609619566,-0.9683577377164825,0.07017255012560093},
{0.29692185547866967,-0.9465683842527104,-0.12587972701081437},
{-0.11171060714089283,0.19416174212748574,0.9745880966573688},
{-0.29654346443656326,0.01921678660459909,0.9548259992336584},
{0.5286228427075005,-0.012179848077868071,0.8487694277415047},
{0.6745342515999634,-0.18646158371091087,0.7143077916546172},
{0.9113735386692972,-0.2097240288049759,0.3541385389296297},
{0.7576325000513762,-0.3583964162382032,0.5454768589899246},
{0.2415646065134676,-0.3285577947881715,0.9130697215240068},
{-0.32680195214806135,-0.8309035338086883,-0.45033298966037355},
{-0.17040658396313543,-0.9760170774700796,-0.1354705157175526},
{-0.3997168070080069,-0.7198668419109789,-0.5674664784041761},
{0.3684849373761326,-0.9292631671185164,-0.02624532651295765},
{-0.6140597681457308,-0.7301021585024872,-0.29980233370475984},
{-0.1671698915300146,-0.9114834283094895,-0.37583531936610604},
{0.30165224860487816,-0.593283926987888,-0.7463377940915569},
{-0.35002136531882666,-0.6278344155062066,-0.6952042797094422},
{-0.4741759994769012,-0.8525732695587876,-0.21971786808068336},
{-0.4080481560102593,-0.7487543900505756,-0.5223634422091745},
{0.1275104928704379,-0.8108007953711908,-0.5712645135428791},
{0.40405331123323734,-0.8718987074126126,-0.2766470055751049},
{0.5175694601337192,-0.8521622239024494,-0.07708046503830959},
{-0.27170726023106717,-0.7332583801387075,-0.6233035477952021},
{-0.5546996245585495,-0.7414609337586007,-0.3775500102296756},
{-0.6487700922077898,-0.613279278457343,-0.45053955883089397},
{-0.457227503018617,-0.6501723556152093,-0.6068104469083656},
{-0.1906095035719225,-0.5881411186903829,-0.785975853098357},
{-0.12063549673273782,-0.5254179436630962,-0.8422488120531183},
{0.36699379924187736,-0.7918390061099776,-0.4881665081924152},
{-0.241522357840963,-0.9439996340876938,-0.2247924409432885},
{-0.5109514022512986,-0.7935725124953928,0.3304108532557325},
{-0.3474558426612867,-0.9362492301617032,0.05207510366915591},
{-0.22103030218245903,-0.9747009614515735,0.033221096648198646},
{-0.63968940633669,-0.47726836779230153,-0.6025050775931149},
{-0.7354901412808007,-0.20142158502494845,-0.6469030817400588},
{0.7357183521691912,-0.06924162190108024,0.673738899038758},
{0.017102458852947505,-0.04035892745319525,0.9990388695521366},
{0.07906727228646414,-0.04814950941553843,0.9957057754157205},
{0.9699043576540985,0.18298977265733196,-0.1606246559728878},
{0.9998323949923437,0.007097658823714506,-0.016876171458490068},
{0.989963251362577,0.09543498530403689,0.10423494870557232},
{0.9579100723833244,0.2060775325513933,-0.1998508038615399},
{0.9845005960094183,0.16263213949627114,-0.06564574365460123},
{0.946154763518311,0.07530108447443122,0.31483473466024003},
{0.9394284400755706,0.15889404446670502,0.3036888022469598},
{0.6944793783122152,-0.4296175759744702,0.5771716655492534},
{0.9245269416953324,-0.31780972206205493,0.21034950592362875},
{0.8483262082509108,-0.2938737753028678,0.4404325698490884},
{0.4031702177645242,0.03374720820103998,0.914502543160128},
{0.555034427262425,0.20719658636106578,0.8056093092521915},
{0.025997593732923867,0.24209472779417254,0.9699042570761112},
{-0.20279338787018347,0.13349103391646205,0.9700798862465129},
{-0.4477791331150962,0.15266706489609133,0.881014537475237},
{-0.27282421920377325,0.25108539789151263,0.928721200566409},
{0.9846992902160286,-0.08272703242292037,0.15337387637582395},
{0.9970833502664433,0.0044244866327429085,0.0761919716209105},
{0.9515646881423792,-0.0870577229237346,0.2948653882025342},
{0.9822123788153151,-0.009554127005666872,0.18753016173170492},
{0.5980092375164413,0.08242737355119012,0.7972394119299779},
{0.5807769638778707,-0.1052552894767418,0.8072294855033293},
{-0.15356630561427653,0.04106833017889072,0.9872845496797265},
{-0.11800614471012034,0.2875285108050234,0.9504745684577255},
{-0.4707945092624377,0.29741232101080217,0.8306012529242343},
{-0.5981668324717792,0.15940994022874358,0.7853565505469136},
{0.15344735191114653,0.017805685058414383,0.9879963905658042},
{-0.2406933671450448,0.05440361180795012,0.9690753066891296},
{0.8394173670334627,-0.162876994089636,0.5185070575401395},
{0.7801023303317559,0.0191849841451696,0.625357730098792},
{0.4484231710705044,-0.09476922448167095,0.8887831308807654},
{0.34079435661728663,0.23490390593286964,0.9103182748222136},
{-0.325917038568917,0.07473055527201067,0.942440145621569},
{-0.43377181276242976,0.23034425070463582,0.8710818220007321},
{0.14717839016316797,-0.14381262008714146,0.9785992293950827},
{-0.4221220819456743,0.17285822820694074,0.8899061640841727},
{0.9363116793128944,-0.1389785203957629,0.3224986977506614},
{0.856564593799443,-0.18628472877590577,0.4812432820041049},
{0.5247511234818124,-0.5793597139400412,0.6236814734044047},
{0.004218306862697875,-0.4912912673549513,0.8709851299006073},
{0.06708703998681863,-0.16871454583802842,0.9833792407247952},
{0.10241763688034689,0.14241383850465486,0.984494248971631},
{0.9356169146279235,-0.20195045808167963,0.28954619932357023},
{0.6098996636073164,-0.5214265323973594,0.5967719594985574},
{0.10484562639428403,-0.4435667789276471,0.890087584037516},
{-0.40750566444007563,-0.2382756554029241,0.8815689680856282},
{0.4740271669867783,-0.2308738641567631,0.8497031857112303},
{-0.3829590186286209,-0.9150878423831047,-0.12631955815960388},
{-0.5584935316066031,-0.6885990838811955,-0.46251083969087975},
{0.6407198991869439,-0.41218445668845527,0.6477514835570162},
{0.5037037405385663,-0.4303885789279507,0.7490315166238574},
{0.15018652297342985,-0.49933306331737776,0.8532939119642394},
{-0.5121154289480735,0.005637165809071258,0.8588981370307958},
{-0.22834357580932077,0.2604326454817706,0.9381012997293946},
{-0.45089299469134914,-0.5248152516413586,0.7219864673128469},
{-0.16008014925128833,-0.9653698283033614,0.20599864178490074},
{-0.2557758714923353,-0.8235133834327465,0.5063639114999081},
{0.0804266482683594,-0.9948979023006715,-0.060907456407579434},
{-0.1760380416322303,-0.9629239621897766,-0.2044212585301021},
{-0.523765544494204,-0.8517779151547549,-0.012001568868656337},
{0.12250049086091779,-0.952041425771255,-0.28037609269385},
{0.2873948503288968,-0.9538750867830471,-0.08675551175035012},
{0.09908899043926457,-0.9282592708553805,-0.35849141976449644},
{-0.6352984328306622,-0.7457223043066787,-0.2007340182989463},
{-0.47208627026144273,-0.881182989328094,-0.025516519148270904},
{-0.5989404045915587,-0.7527468299298283,0.2732079826401382},
{0.03357666382464656,-0.8779031328459278,-0.47765960367788274},
{0.26739556514961554,-0.943699220672541,-0.1947598332314864},
{0.18723946089764726,-0.9042412664456285,-0.38378264205089346},
{-0.260003303789502,-0.9497809676491491,-0.17411029696715286},
{-0.2525890491996825,-0.9260029033797387,-0.2805662045876065},
{-0.7355191347943434,-0.6024344429874098,-0.30997474776799117},
{-0.7343972057551598,-0.6597498770103841,-0.15934504687562975},
{-0.9763909560391218,0.007573967934535836,-0.21587805811322372},
{-0.8021761892340801,-0.5939282166678701,0.061340320113387345},
{-0.8775942723821489,-0.4690590850495121,-0.0990548727451667},
{0.925064134779077,0.05364637737725788,0.376003208416809},
{0.9997696303317936,-0.021463603290892544,0.0},
{0.8285647151202493,-0.35534449579610944,-0.43267863613207097},
{0.9135355402126593,0.029007932215730035,-0.4057232512895118},
{0.7924657634349566,-0.5914486304010481,-0.1489514396713767},
{0.729497973415069,-0.428779408139961,-0.5328986075591229},
{0.9591573806235215,-0.22835994048749905,-0.16693968005232052},
{0.9541900308440446,0.07408435071093168,0.28988427694095587},
{0.9353769098626942,-0.2503726605223757,0.24976702616371196},
{0.9877484517002555,-0.08939408991824145,0.12791283302091733},
{0.9880716796118222,-0.03359871896737884,-0.15028466998607481},
{0.9379678397464329,-0.2633087192020161,-0.22557670534344598},
{0.9880798677762608,-0.00038054950169788565,-0.15394164503903435},
{0.9377796133316538,-0.3371157367693234,0.08320082236378493},
{0.9711645152516554,0.0727232293551493,0.22704804828092195},
{0.894694235927804,-0.2930825353437182,0.3370828557996702},
{0.9264626905923721,0.14373031188437427,0.347862732102712},
{0.8898521688034612,-0.044309001909071666,0.4540923144313262},
{0.8975455381501803,0.19070405456779527,0.39754744436118106},
{0.9734642761435535,-0.11139680042479326,0.1998951123149992},
{0.9954001754980064,0.07623698063238582,0.05802080146460542},
{0.6675753518730867,-0.62974908274449,0.3971891770353241},
{0.9262520476076177,0.07871686807221047,0.36859299909737536},
{0.6429731046028103,-0.5262412280288616,0.5564672107861337},
{0.6639679773227029,0.3863936314263753,0.6401925387593466},
{0.6237955582178025,0.03017549592056247,0.7810048277659289},
{0.7375082630145237,0.41676734604952564,0.5314005469061311},
{0.9152378885587158,0.17630996684422826,0.36229049523548223},
{0.7556152093558228,-0.31174239312015906,0.5760749393280984},
{0.6756026395814652,-0.26968431970885964,0.6861715828375048},
{0.7438852082922942,-0.0035221921140210113,0.6682981303629706},
{0.25910716058058253,0.2025486732213931,0.9443714916875251},
{0.41257815428315786,-0.13778505516372644,0.900441305795015},
{0.555802474981979,0.49979098529865074,0.6642985622580486},
{0.7008289191627858,0.16780060993312004,0.6933121817559492},
{0.6788045452724318,0.31919796391539335,0.661314637029723},
{0.5461778612754191,-0.24341984770569952,0.8015213793752123},
{0.497740298622542,-0.009854194320793404,0.8672701366825856},
{0.5479882014952582,0.3469846519731703,0.7611245511196247},
{0.5674666293764233,0.1521929204265526,0.8092088355401207},
{0.3273804756661408,0.7543419485618393,0.5690257013462034},
{0.5424995656722775,0.18272748351465146,0.8199420028354403},
{0.41335691900773996,0.8022817571103121,0.430673936657907},
{0.6366692215458455,0.3047810942200598,0.7083507513529085},
{0.7489844383534751,0.40530763087102456,0.5241641302703256},
{0.4425986711572321,0.05857944863170192,0.8948043721886133},
{0.44588719281404526,0.31307148826482584,0.8385528334696971},
{0.4077844704507842,0.24741980245957942,0.8789170990543056},
{0.30862843821898167,0.4701133802316859,0.8268868706477631},
{0.34105781771367644,0.4333100831870601,0.8342193577140294},
{0.36112453027434205,0.4731944143853872,0.8035397437766264},
{0.4292649315828535,0.5424401984121576,0.7221428180489973},
{0.2833801983392991,0.6327466209355609,0.7206437239606053},
{0.332581200189561,0.6762845420318045,0.657289101909733},
{0.3278916611253198,0.6791098334202893,0.6567319793617067},
{0.28642661774558215,0.7136915302159891,0.6392215518462953},
{0.50021358007088,0.6426522562753584,0.5803313293428715},
{0.5094279632634384,0.6498382715410921,0.5640863152796306},
{0.5994625058415738,0.6308364405837591,0.492635858745336},
{0.43447755345274086,0.7927754585544715,0.42747669861580534},
{0.43290263681615954,0.8545813377453005,0.2868554413203078},
{0.25030406441634884,0.9466932301197337,-0.20278018488531166},
{0.5649389920472236,0.8165475129569537,-0.11871855098711578},
{0.5282846383416048,0.8020855087881944,-0.27852141297261745},
{0.5779365270581035,0.7895163101043505,-0.20652691536753515},
{0.5968132817831352,0.7939976701211289,-0.11567889405359645},
{0.4242357896629083,0.8622412556356703,-0.27670202718612513},
{0.49252507694513076,0.8236013161067371,-0.28124708120697617},
{0.17262918060623778,0.6412941094795311,-0.7476235892145685},
{0.46304338414735713,0.7585970442775909,-0.4583899527811072},
{0.22982990904703265,0.5053217265901404,-0.8317620846993401},
{0.5292061382998259,0.589729202544856,-0.6100494495133928},
{0.4837561558949439,0.20007333616395784,-0.8520273715028001},
{0.5170192919915151,0.44191650153171297,-0.7330762971086735},
{0.9410823422777177,-0.026887972375860304,-0.3371068999510386},
{-0.41927842959018685,0.3927728770611014,-0.8184956111828161},
{-0.6395736222930953,-0.7678864929425818,0.03599882808136001},
{-0.6585991332290783,0.06007564699291772,-0.7500920599155075},
{-0.41320753080542955,-0.38182222631990625,-0.8267232450909978},
{-0.42940798900280114,-0.3318548809459664,-0.8399292333124907},
{0.007224952181299877,-0.35685074113176407,-0.9341334747345738},
{-0.00771506659078773,-0.5819691493868814,-0.8131742660152308},
{0.11767650964472819,-0.050324626541031287,-0.9917760185855171},
{-0.21560464790096007,0.13801559406974015,-0.9666779875413942},
{-0.3153850692299804,0.2583756995887238,-0.9131124005120279},
{-0.2944038804357147,0.0819477759630772,-0.9521611823631011},
{-0.19013352240485465,-0.07153609190317321,-0.979148523571957},
{-0.20539901893884938,-0.1808036610016339,-0.9618322510642718},
{-0.09886238829512486,-0.055367978347503816,-0.9935595679949414},
{-0.004797041319595675,-0.30693629803311645,-0.9517179715358453},
{-0.025713623867624984,0.16936586996452838,-0.985217748337266},
{0.1378532827466757,-0.16802585478629406,-0.9760961963655529},
{0.04995138051527225,-0.4947636688679703,-0.8675907857699527},
{0.6291305311571469,-0.39085778804050986,0.6718816594416059},
{0.7047105157917567,-0.5334289945975134,0.4677997399050178},
{0.771793466741418,-0.5362526350005754,-0.3417132659850994},
{0.7456216227653684,-0.6273915148070236,-0.2245624252026306},
{0.7037079434125397,-0.6891402822399583,-0.17286064263540368},
{0.7587230937381073,-0.631904174797563,0.15822888769717824},
{0.7423275095257923,-0.6671207819231119,-0.06244782564293312},
{0.7444414322434024,-0.6336568584370992,0.210442247932818},
{0.6122227976491206,-0.609534034156413,0.5036382702334012},
{0.601244619875311,-0.6069888764521909,0.5196820286812888},
{0.6831824415152502,-0.6147009874697756,0.39421370804291483},
{0.8213969484960536,-0.5518567148612691,0.1440875402798561},
{0.6362253374580525,-0.44323803830907393,0.6314723757792664},
{0.571665520055538,-0.29537508609763485,0.7654750758139981},
{0.6605564586749909,-0.37552291808592303,0.6501136076832942},
{0.6400272308448678,0.0006948776929883359,0.7683519121613755},
{0.6194819250276218,0.09262765431182707,0.7795269477194234},
{0.6270821401416558,0.24654054508997586,0.7389084849574394},
{0.5697505745162058,0.5004202275111093,0.6518925361868955},
{0.6252081613947654,0.6259381195064596,0.4661718840450316},
{0.6931541100685745,0.7112056813444484,0.11714887331264216},
{0.6495206368165997,0.7119949902000519,-0.26680718933227227},
{0.6071063091021206,0.501026517259814,-0.6167611842933224},
{0.4903364374908564,0.32787777226386566,-0.8075062504551033},
{0.3557837202421982,0.5370082719255482,-0.7648791148241386},
{-0.15441051254056576,0.44920516493110796,-0.8799841552074537},
{-0.5125737742557326,0.31328303905634214,-0.7994509762235928},
{-0.6074215825778688,0.2777171349991095,-0.7442527890081996},
{-0.6784691188640594,0.23050181599960812,-0.697530334515073},
{-0.6129326725926241,0.13429652785968546,-0.7786385435317826},
{-0.48757050918748546,-0.15679578338356737,-0.8588888641051238},
{-0.3261881602692112,-0.24624076134857859,-0.9126701329344901},
{-0.42069686911982007,0.008206982923857352,-0.9071641470781726},
{-0.3406509018132468,0.06735294997816096,-0.9377742496054481},
{-0.2470957659861496,0.05399403370227807,-0.9674855692754675},
{-0.22685495604306513,0.13629394315158053,-0.964344746436093},
{-0.2122942845810918,0.17363205074087265,-0.9616564083339337},
{-0.03127680953393071,0.33570016799923086,-0.941449498587506},
{-0.2082309972235001,0.3175798856740119,-0.9250853301239775},
{0.9634742371234808,-0.14890395345723212,0.22258707744191517},
{0.7739225285148501,-0.4897255099981901,0.4015131936987798},
{0.7393047191505839,-0.6051739223626084,0.2952847031831009},
{0.8498539352563592,-0.35054217900274265,0.39353331430679295},
{0.9436580616754874,-0.10388943058485349,-0.31419173898690717},
{0.9870574547513902,-0.034937703495626506,0.15651497658102628},
{0.8957515266220635,-0.41245947473864053,-0.1658504876464568},
{0.9361843557838655,-0.32730108723584567,0.12819067937951772},
{0.8016503629141125,-0.5609035785569082,-0.20674590975815194},
{0.8816630844805644,-0.4119100992403483,0.23021788724602538},
{0.8973516694515582,-0.4283352759505888,0.10624910686134884},
{0.8393957602660332,-0.4515162003491855,0.30256879956406973},
{0.754621401137122,-0.3954211882802693,0.5236302367175397},
{0.9513499242929851,-0.17450613273284857,0.25393095751868605},
{0.913586415775739,-0.09402874389489836,0.3956241350468729},
{0.8609222299127647,-0.20874791470413148,0.4639366574746054},
{0.757309192483545,-0.2626538403302078,0.5979094807240595},
{0.7870725190530135,-0.20540527577458212,0.5816575645820414},
{0.6951776946242589,-0.0566576205324159,0.7166016235904752},
{0.6555514943199398,0.0730391486915458,0.7516099527369952},
{0.6789118598028278,0.24635341376142036,0.6916564769791143},
{0.650633733523479,0.47501393952697296,0.5924841787392842},
{0.7250189791681135,0.4457618722934015,0.525017935936962},
{0.7902770511444458,0.541066696810542,0.2875917454256434},
{0.8522030312869283,0.4856879815553935,-0.19456921143392233},
{0.6730904435803371,0.26531041258718996,-0.6903329919203052},
{0.5269799811843257,0.12018693635403299,-0.8413365555833168},
{0.20677761342632028,0.20818694239681076,-0.9559818071496874},
{0.42599798689361434,0.32700107343506896,-0.8435615052471874},
{-0.20548403153711342,0.4018902587883761,-0.8923343166517057},
{-0.37748084280807703,0.30008315021958604,-0.8760469829108444},
{-0.43626613257961805,0.12651939093215642,-0.8908786142242833},
{-0.5937807409890405,0.10736875618425741,-0.7974311141571738},
{-0.7257220720669746,0.000913334852091978,-0.6879873835574783},
{-0.770359088022952,-0.10036910061657164,-0.6296609557070107},
{-0.6427133149632613,-0.1865132270357934,-0.7430561290438497},
{-0.6049698917318638,-0.17303664617184678,-0.7772192413852965},
{0.9962913581490775,0.0497982854147012,-0.0701687996706686},
{0.9429858182284862,-0.16370208193173222,-0.2897919512187477},
{0.9855210560049866,0.05670841746587746,-0.1597886214951857},
{0.9790562248890019,-0.20260040297080953,-0.020049569126583466},
{0.7604548081395683,-0.5719485819780195,-0.3075439876680165},
{0.9101899013790028,-0.28575038329421554,-0.29983505778159103},
{0.9748062899381542,0.2123478811340274,-0.06827206218432438},
{0.9731534431587975,0.2296752024619305,0.014888836161645203},
{0.9778811308853792,0.17931330059581788,0.10768116867756193},
{0.9801361257776946,0.07414232192871463,0.18394589162172126},
{0.9504453573558158,0.05747804532964263,0.30553215376758486},
{0.9376984619530238,0.07674912664038104,0.3388674755872453},
{0.7799867626749529,0.07344245583096184,0.6214715244750671},
{0.7163839610185879,-0.29502604402970933,0.6322607482198292},
{0.659398780131233,-0.3256351654724574,0.6776097606802659},
{0.7267005038577603,-0.17586767972157888,0.6640609436807929},
{0.6719672004801861,-0.13103419036565533,0.7288965100986825},
{0.6655291247705504,-0.14203688828480623,0.7327322201517513},
{0.6992883765052673,-0.22161142719488572,0.6796205866667616},
{0.6139404768240037,0.10591429101955387,0.7822143273265583},
{0.60437523305943,0.23670593628345793,0.7607239166692022},
{0.523490885284135,0.1975659559723872,0.828809378605931},
{0.48540133431879984,0.1800789255617652,0.8555449288085628},
{0.47760115995093166,0.13867683179652007,0.8675631782967764},
{0.4550460157146464,0.11996877657015918,0.8823494864454134},
{0.5542536146703445,0.040519481691411764,0.8313609939300236},
{0.6426177073074405,-0.05252838868906292,0.7643842297147813},
{0.8247332951109462,-0.02404217167005849,0.5650105892076966},
{0.8540465404974148,-0.10122466572046697,0.510252950715797},
{0.3893442990500939,0.006115096368740915,-0.9210719963138561},
{-0.009399773078315049,0.10957115805981207,-0.9939345076953047},
{-0.06324133006483575,0.2881451071580765,-0.9554961702657375},
{0.08107333227600563,0.36041111049517,-0.9292636580784287},
{0.1643236678784079,0.3754106849427077,-0.9121757230960676},
{0.2515853246832689,0.36049516565358786,-0.8981915496955015},
{-0.1727125827860946,0.43216477657376023,-0.8851011070133786},
{-0.30411412551828176,0.39882900433423535,-0.8651300618762552},
{-0.5667393111976856,0.28056857896817555,-0.7746533583732479},
{-0.5688885351297847,0.1629452252795206,-0.8061108411108823},
{-0.4347149810480002,-0.004979371111202603,-0.9005543243557126},
{-0.5304516303812277,-0.06642468461267549,-0.8451087676151537},
{-0.6704034501807736,-0.11750821897111353,-0.7326329452460844},
{-0.7022285232441262,-0.18964019583454633,-0.6862300614707931},
{-0.5970271086467016,-0.27974982895130834,-0.7518634615026011},
{-0.6038792948970988,-0.3065421159615045,-0.7357728782283472},
{-0.6457743338604417,-0.1744989909226636,-0.743320665590615},
{-0.550863811407403,-0.12381332810735297,-0.8253601159885848},
{-0.4961163900380083,-0.08023534245896553,-0.8645408130077767},
{-0.426454181140212,-0.021819695155703867,-0.9042459467928752},
{-0.35341375176508005,0.05681547120682531,-0.9337401792227198},
{-0.29713855711406467,0.24631286900025512,-0.9225175599635135},
{-0.37422795773190665,0.35889690897833887,-0.8550710171544817},
{-0.41054169178109323,0.2562841269390426,-0.8750851190533471},
{-0.24477612965761184,0.2828406865347432,-0.927408104552896},
{-0.10359548917563696,0.40655229535689097,-0.9077352068541265},
{-0.24209833253214777,0.38383343076413795,-0.8911006086929723},
{-0.2948513368139729,0.45837908394276244,-0.8384219132291373},
{-0.38871148225273805,0.3131245154226403,-0.8665197178404056},
{-0.45130712762047814,0.40605234929927275,-0.7946341083715793},
{-0.3401330913756244,0.28687227338331944,-0.8955522200939191},
{-0.2530145639922817,0.10314547121022288,-0.9619483573334988},
{-0.24062653538972326,0.4226175783720654,-0.8737810097028142},
{-0.28023520320061057,0.3519075758404307,-0.8931009399576422},
{-0.10982901408815798,0.3349260064983248,-0.9358216485182992},
{-0.0388863623292048,0.2816057062381642,-0.958741924106225},
{-0.3818074141386558,0.4591242255152274,-0.8021396661765304},
{-0.3573246761388883,0.49109402534782204,-0.7944468101074554},
{-0.4061593095420395,0.5601261279259525,-0.7220064654052712},
{-0.28223531327942036,0.551701544413205,-0.7848366924591077},
{-0.4648300508424936,0.6604755888934823,-0.5896651764430154},
{-0.5998677270285886,0.5962927181464855,-0.5334732461473873},
{-0.5552696737951596,0.6396895771540596,-0.5314817346286488},
{-0.695875670685839,0.49532818156435976,-0.5200067725478953},
{-0.6753736875811625,0.5680909363577463,-0.4702585141719409},
{-0.734197486073163,0.42626553005376944,-0.528442758803474},
{-0.5875737116038589,0.6165757963083496,-0.5240147143342349},
{-0.4837025523688619,0.5734603289942429,-0.6611921747129674},
{-0.6044243298285166,0.6390062085231867,-0.47575444819798623},
{-0.7634596700237345,0.5803476385805283,-0.28341833151942536},
{-0.7346336374483331,0.5745294832287715,-0.36087295774318123},
{-0.7002135695420768,0.5159972014592403,-0.4934043424164154},
{-0.6487140205986962,0.6195283406229481,-0.4419895413283562},
{-0.5574910063257179,0.6515132224554026,-0.5145233705398768},
{-0.7178774267107149,0.6922640136265653,0.07363786836160158},
{-0.6996217538820538,0.6909356566281165,-0.18203658943979448},
{-0.7531400024377866,0.6576644669786664,-0.016049473563876874},
{-0.641344785506809,0.7381654622887994,-0.20925729709424276},
{-0.7351107015017894,0.6672176269504493,-0.12013698358190225},
{-0.5542435389965463,0.8320396355172672,0.022894200332774055},
{-0.7521735546204265,0.6374296156741718,0.16708808692168886},
{-0.759026626701523,0.627180367719157,0.1747093766967586},
{-0.7112242543715694,0.6889562132641249,0.13964023846428558},
{-0.6949542663735926,0.7121226167113974,-0.09959892779168839},
{-0.6431399848169713,0.6907098914222625,0.33059159974365976},
{-0.6432468687439953,0.5818655645158276,0.49766045722130925},
{-0.6672352870174736,0.5581010839423644,0.493275026593753},
{-0.7394659687064722,0.47796704161447234,0.4740649620624877},
{-0.6917997118389003,0.6068110825566426,0.3913993724906186},
{-0.6436236848012857,0.6868753459024513,0.3375660106619197},
{-0.6698536916387474,0.6350798054965517,0.3846682628556764},
{-0.6145513985275826,0.5555701255348245,0.5600610807590647},
{-0.6123851518461038,0.5758545506906321,0.54164191330372},
{-0.6404661266689234,0.366053966009785,0.6751352713036208},
{-0.6348572982617837,0.556225632808703,0.5362548426357625},
{-0.6722817277722307,0.5940193518946366,0.4417898686912821},
{-0.5141310492926847,0.6442690274683017,0.5662037481315816},
{-0.5702589271651788,0.5982697502569826,0.562919232142469},
{-0.3859705257706986,0.509229697100811,0.7692280993482405},
{-0.3593703926331884,0.6049550580536848,0.7105507009594255},
{-0.4142331183315298,0.5466585087214727,0.7277193130045074},
{-0.26088818849447754,0.3491365564558037,0.9000227875172124},
{0.017631338081312682,0.2959885429863571,0.9550287526238546},
{-0.213852820491464,0.3965647396438783,0.8927504569805769},
{-0.18220068580875398,0.4337901306824154,0.8823995878361189},
{-0.2406265353897232,0.4226175783720653,0.8737810097028142},
{-0.357644947339978,0.2587342078604607,0.8972996719741985},
{-0.2946605302009936,0.24336961507756635,0.9240922044897179},
{-0.4740730003886386,0.27764955258835305,0.8355629935857626},
{-0.4221336437342502,0.47844508468922,0.7699957712639532},
{-0.3053312117268392,0.3225264578138822,0.8959629094753031},
{-0.21100605658234822,0.44814937039562125,0.8686993645097106},
{-0.27672873259608716,0.3373928529005274,0.8997706770991186},
{-0.2230838107131581,0.3332284661223684,0.9160744526311329},
{-0.30420735907190516,0.2325561463038196,0.9237832654377397},
{-0.34961755633379393,0.20714825354311156,0.9137051851430117},
{-0.13798129286997235,0.34967030725887166,0.9266562680084872},
{-0.3311428503544574,0.47460470439385505,0.8155334372215199},
{0.06521172170712346,-0.1267485513032953,0.9897889856401255},
{-0.004050809601386131,0.2999159413078673,0.9539570320989249},
{-0.024224894510550016,0.051966999503661154,0.9983549396124302},
{0.02270541463185497,-0.3618919656369438,0.931943490429449},
{0.04995138051527224,-0.4947636688679702,0.8675907857699527},
{0.9540311493679828,-0.04335545305469327,0.2965550045540079},
{0.9282269522567543,-0.3350208597092102,0.16172738996174654},
{0.7333451899305157,-0.665438519944432,0.13927098972844104},
{0.8523549692307328,-0.5158080586826506,0.08621515542937802},
{0.9806030836026439,0.10679737256900883,-0.164353015309554},
{0.9736035481918759,0.14217179630598356,-0.17855898544548127},
{0.9806616830492382,0.1948620732645819,0.018205378382887858},
{0.9688972932613773,0.1689094748214078,0.18085249355851543},
{0.9514750929546829,0.10586755281554246,0.2889415317113926},
{0.945900029090124,0.0560103096648877,0.31958720277655944},
{0.940106663845311,0.02372087879510421,0.3400540846730519},
{0.7868842407363932,0.24728497714593203,0.5653877711435275},
{0.5600830283030529,0.46954266219905977,0.6825222998422112},
{0.78152191224622,-0.2575552765341827,0.5682330333660761},
{0.7908774716165079,-0.252974496624537,0.557240279365232},
{0.7095830150058946,-0.1005541052826792,0.6974100778781048},
{0.6300508927712131,0.010328643316425535,0.7764851522375938},
{0.5702490901346563,-0.28972472912206165,0.7686843022566188},
{0.4811880816593729,-0.2772762355428712,0.8316104372073183},
{0.3990099774387472,-0.06677119488560089,0.9145122445532807},
{0.33014421601653043,0.02058134978956761,0.9437061007918037},
{0.3310301786818418,0.04491437928596701,0.9425506455014627},
{0.33890510107779265,0.03092809053715004,0.9403120682407393},
{0.35902905755723724,0.03287687847602691,0.9327471504599919},
{0.4181570676573852,0.008397690197455428,0.9083359211038198},
{0.4898495768087561,-0.10162493133332637,0.8658635951648385},
{0.5516862222879011,-0.16890343690440104,0.816770433561099},
{0.5434786973167351,-0.060048254079391745,0.8372724244503228},
{0.516166127839636,-0.05675926607113715,0.8546057068532262},
{0.7427856591270477,-0.13530714475762942,0.6557144509409069},
{0.7597859823843937,-0.17206936062561315,0.626990746427788},
{0.2657153702891736,0.016108677672369915,-0.9639169323628126},
{-0.16671210492022928,0.17703169312302036,-0.9699829141294516},
{-0.3431923330684721,0.21974403068016196,-0.9131985455000764},
{-0.2788188801959538,0.28172130297194514,-0.9180921192876366},
{-0.3283597293546777,0.4797040086166987,-0.813673123714427},
{-0.3101254026701464,0.4596886653197349,-0.8321709954061367},
{-0.31657496129189916,0.41214706047207245,-0.8543506858587182},
{0.999084709730015,0.032008624091422744,-0.028375883553923866},
{0.9157972396108623,-0.3488619058786172,-0.1990245877972455},
{0.7298102121119815,-0.6367788719791035,-0.2487764508511307},
{0.9157923703422762,-0.37100082949980884,-0.15389190665310837},
{0.8816630844805644,-0.4119100992403484,-0.23021788724602538},
{0.8781694910566962,-0.43990761231229014,0.1878819778662206},
{0.9144875475964281,0.0704568812268913,-0.3984323696423903},
{0.9505753607757491,0.0840323829055707,-0.2989064102846676},
{0.9820812474533215,-0.04688096860108142,-0.1825338275048007},
{0.9959764790774186,-0.0870837385218764,-0.021148891450894883},
{0.9807788135513578,0.029871830676808975,0.1928226973693894},
{0.9343262113349555,0.09676948395280137,0.34303089917378676},
{0.919060040289,0.018386545923519387,0.39368842664343573},
{0.9219591022659898,-0.08153303091346573,0.37860768431049335},
{0.7817393309390654,-0.10459103074501129,0.6147717745233905},
{0.6620562279999725,0.0636266381401771,0.7467484194060456},
{0.7043648817541852,0.2537499303581729,0.6629336966806221},
{0.780229045253882,-0.06849189370049007,0.6217326575301771},
{0.6830193295775946,-0.14760611546550656,0.7153300148187244},
{0.6043415648864454,-0.10252422338865134,0.790101295131932},
{0.5167114593829907,-0.03793849686016141,0.855318617942046},
{0.42422015909596195,-0.22816950780347106,0.8763423602253394},
{0.3169677737322589,-0.23787626193240965,0.9181210783030086},
{0.28405730557339026,-0.1125927839360472,0.9521734674710887},
{0.2981762783943819,-0.07060264495000432,0.9518960938720883},
{0.2920646056227726,-0.03324401768646168,0.9558206429192019},
{0.28190981707262003,-0.040240679233194736,0.9585966528070777},
{0.32284938194286933,-0.10670943003206772,0.9404155326882572},
{0.3855983775548095,-0.10360135313608478,0.9168318552796204},
{0.39784002837612303,-0.18395334609100622,0.8988239417614597},
{0.3957505791727845,-0.1002671159659037,0.9128679995159681},
{0.37479481957893895,0.014623982245983227,0.9269924392140746},
{0.37076056087236436,-0.029169883600853305,0.9282702862810608},
{0.5031341522038674,-0.12406095205092212,0.8552572157323868},
{0.45214130009819176,-0.06774096192481951,0.8893702304569325},
{0.7141428843085142,-0.17592181515437133,0.6775333613515332},
{0.06327508831147534,0.14147607826408645,-0.9879173965864702},
{-0.18764739057705238,0.19526731578825954,-0.9626313584100984},
{-0.3439370854451302,0.20425346430519223,-0.9165084852715968},
{-0.46911128160484855,0.3715018190252978,-0.8011997278656248},
{-0.40085419382120374,0.44065569044805497,-0.803205128078563},
{-0.20546603470532007,0.516417816207196,-0.8313220481174928},
{-0.2511461248246988,0.4282831525735998,-0.8680432968505404},
{0.9129791788827837,0.11342310161186227,-0.3919237412396234},
{0.9194542913069363,-0.13783205702325343,-0.36824737643871724},
{0.6600482207178742,-0.522317694793134,-0.539926450577442},
{0.7975357466753461,-0.542931450738196,-0.26298701978294625},
{0.826338925121791,-0.42395800354689556,-0.37070688158853166},
{0.7960041396617956,-0.2766894904187724,-0.5383496405990111},
{0.8613566161072964,-0.01686006926418934,-0.5077209055697769},
{0.86936889128364,0.09009016445292385,-0.48588218030413466},
{0.9529079778484539,0.05545877553628257,-0.29814545102816276},
{0.9830923643334714,-0.16439162704832955,-0.08065231643064051},
{0.956251331127647,-0.29056737600036886,-0.03397045364523701},
{0.9703876268818096,-0.22116083703994274,0.09713772570161404},
{0.9463336540378802,-0.0876125026076522,0.31108948008915027},
{0.8540829296348481,-0.027881165034127915,0.5193890545079812},
{0.8114204805719969,-0.22041251680351434,0.5413087161173835},
{0.7097590845135161,-0.2339443576035922,0.6644637533349567},
{0.6374718832141607,-0.1912011197300993,0.7463723801999559},
{0.649318793930622,-0.1580648310074879,0.7439090085803886},
{0.6420203402823611,-0.19545784625712648,0.7413542425859898},
{0.507939247633191,-0.30879782355943636,0.8041403017376899},
{0.390271287456953,-0.3808050682541511,0.838257610868308},
{0.3104720425101246,-0.33762900819494984,0.8886021402432507},
{0.23180151881664005,-0.30781563201297885,0.9227771088202986},
{0.2104431985343222,-0.3427334220782659,0.9155585516946281},
{0.24397921447009352,-0.33685124582047404,0.9093983621580537},
{0.2965191948864153,-0.12528807704512043,0.9467730798952028},
{0.30618172552660156,-0.017662302261327874,0.9518092214474402},
{0.2884626606004346,0.019969747296507183,0.9572828749289481},
{0.2168644924632043,-0.09007482060944037,0.9720372002145051},
{0.12503107981914338,-0.1723568320719661,0.9770672195490825},
{0.1040383814717378,-0.16219624802784763,0.9812585756600705},
{0.15375876970408744,-0.14454986269509112,0.9774781726125221},
{0.2085097853323712,-0.02819332415374381,0.9776138327037984},
{0.2387076767824937,-0.013954130119485014,0.9709912086613931},
{0.2852999441746004,0.026298335243133828,0.9580774182796553},
{0.32364153842558324,-0.009509261228803844,0.9461319826305439},
{0.2874639496087453,-0.08826170228963255,0.9537160738837722},
{0.44623274067963165,-0.13365487578094867,0.8848800570278007},
{0.6958542254116558,-0.23349184245643897,0.6791674730749713},
{0.27616256188133187,0.15969396113530604,-0.9477510634085592},
{-0.16599969406559528,0.192204161355005,-0.967213348712655},
{-0.29929119246602676,0.27577242324345075,-0.9134409409976645},
{-0.574985873977442,0.2714975268724175,-0.7718033024213863},
{-0.5773747047316814,0.340014553227722,-0.7423129757247655},
{-0.1105475031800465,0.5526344825739951,-0.8260595488285518},
{-0.12992188829081577,0.5725595610913717,-0.8095034601197234},
{-0.13810951852639217,0.41327957496667533,-0.9000698605151558},
{-0.30534623739978434,0.32550352880952904,-0.8948805104807784},
{-0.5098514989641769,0.2954612801221281,-0.8079319779242404},
{-0.5064510644689242,0.22570183695801158,-0.8322055035218601},
{-0.4512978033131953,0.012816036818715227,-0.8922813692580082},
{-0.5030785375520376,-0.07787705790216205,-0.8607247811623681},
{-0.4969941037654365,-0.16150495294403786,-0.8525919369762622},
{-0.5270129808557714,-0.2310287343083205,-0.817852701856153},
{-0.6065873731275055,-0.2657748444818842,-0.7492766450403366},
{-0.6402425809903513,-0.313376523917111,-0.7013448450972188},
{-0.5776284621302186,-0.30600912766237687,-0.7567719428760488},
{-0.6112059430754069,-0.30016394744082925,-0.7323447957117205},
{-0.7317644554579399,-0.27974011031505724,-0.6215032199508417},
{-0.7018633589508098,-0.2988194483078218,-0.6466024765459036},
{-0.6743198743037485,-0.34154153069830745,-0.6547076369855738},
{-0.5927982659280137,-0.3623622422079126,-0.7192244582429009},
{-0.5184141154298789,-0.25176778386415044,-0.8172268888938925},
{-0.29483506035290824,0.14416747494082155,-0.944609986373151},
{-0.2635941986957143,0.22127638671364822,-0.9389115288976466},
{0.9183689367078681,0.1844016323030441,-0.35013502266130514},
{0.9149378868583589,-0.06957466876140617,-0.3975525482975824},
{0.7622949270990503,-0.5038093149850053,-0.4063036035446809},
{0.657263439417457,-0.5141197368405321,-0.5510768253121855},
{0.9603406280504555,0.14044963627145726,-0.2408729494710272},
{0.9686572470533048,0.038721519682908934,-0.24536458922297447},
{0.6633764622224605,-0.6736093779444451,-0.32585591189129953},
{0.7728289516967003,-0.5000512948951642,-0.39074814637186533},
{0.879947195230403,-0.2879748705040132,-0.37784045252506243},
{0.8656077794799282,-0.09345532776346581,-0.4919240528948053},
{0.8771367251219462,0.07936477479648699,-0.47363741191321707},
{0.8652726865883252,0.07173277722707727,-0.4961427078124926},
{0.9547869178833028,-0.0652263622166448,-0.29004734632622703},
{0.8581728704095167,-0.5111037787483672,-0.048085879863334985},
{0.8703429926738112,-0.49232988501327984,0.010693896689464993},
{0.8272960872036684,-0.5612433860451476,0.024229026354307112},
{0.7976474515532683,-0.5464942037777583,0.25515216688848685},
{0.7486939546409479,-0.3925356925165702,0.5342032313498628},
{0.6940000083737387,-0.24384250517764705,0.677425140547603},
{0.6325228506209871,-0.35126141964538227,0.6903117111211506},
{0.5624662146040827,-0.3102187265782812,0.7664177053729275},
{0.5218535335005584,-0.3733354155206766,0.7670003631622253},
{0.38272098150873063,-0.4473767259962497,0.808318449220275},
{0.2662913004129004,-0.471041710337485,0.8409569848968159},
{0.18651051259213314,-0.5496693394437882,0.8142956747816172},
{0.1645687781660781,-0.46484913730870464,0.869961146716494},
{0.15743142800399415,-0.4378909241948382,0.8851366470689223},
{0.20571458277510096,-0.37445586986213214,0.9041373302543481},
{0.228355754145101,-0.4209883490250788,0.8778510463250361},
{0.20292843257252166,-0.446568264230267,0.8714337821292137},
{0.18913479507410894,-0.18989197968910335,0.9634153130099334},
{0.1522086996502289,-0.010141378559355865,0.9882963443176861},
{0.12913437973437228,0.041206340097758684,0.9907705836904761},
{0.024675365649875273,-0.07920605351167823,0.9965528221911522},
{-0.054307950922992454,-0.1412484808579631,0.9884834409952771},
{-0.04860971850884347,-0.14144229760212362,0.9887523308268473},
{-0.03599655931687255,-0.12047213352429315,0.9920638652634475},
{0.05991318544912746,-0.1106511410318934,0.9920517805022471},
{0.18973980479041605,-0.1335500759780809,0.9727091979026123},
{0.44520263761248147,-0.06621088301906843,0.8929785722136476},
{0.31677840650640693,0.061583641225090135,0.9464982283685062},
{0.5080776674295635,0.5215493949005308,0.6854511744378472},
{0.06074165894105458,0.08906953038147465,0.9941715493951293},
{-0.6590359357436923,0.7520505874753484,-0.009568138607860984},
{-0.8647862354166311,0.4999915542722201,0.046402722876794616},
{0.36781846433138665,-0.11889681183753462,0.9222652142587675},
{0.4791556029719623,-0.14994129883609084,0.8648280262826369},
{0.6161801478410526,-0.1618075693860794,0.7708049921322173},
{0.5803619002884666,0.5386328434076771,-0.6107820599003548},
{-0.21254726164496981,0.474312066446641,-0.8543135988560301},
{-0.4838234776645955,0.4351880452259339,-0.7592932290972753},
{-0.8296616378339554,0.5538162904251129,-0.0703497204432651},
{-0.20686762232439218,0.4130846153372943,-0.8868860622455922},
{-0.46290114528297743,0.15742420619710767,-0.8723188344859456},
{0.16949143457600127,0.397571820205396,-0.9017811826512779},
{0.026755295816274803,0.45713247013670916,-0.8889960961064419},
{-0.15554483881877432,0.24145400911125772,-0.9578652121258722},
{-0.1512665962644082,0.22102728851701267,-0.9634652845771859},
{-0.20322978381452597,0.18368899240730535,-0.9617463330000743},
{-0.3085615706617711,0.06379302345978112,-0.949062804701881},
{-0.7420224974886744,-0.028867562376256654,-0.6697531463629888},
{-0.7061874919184683,-0.13494271215066464,-0.6950465385104267},
{-0.6892195734961996,-0.23744122664706724,-0.6845422144747926},
{-0.6376996716248126,-0.3823549168401683,-0.6686881533104608},
{-0.5908090434612051,-0.48897375220756617,-0.6417548938781141},
{-0.5916620011646787,-0.5892768287164889,-0.5501716963963572},
{-0.6071829644806807,-0.6945997295482789,-0.3858238760832598},
{-0.651942063108815,-0.6038993455724412,-0.4585598398972583},
{-0.6328530118549169,-0.6425088020046702,-0.4320642368128654},
{-0.6809487425733508,-0.3639485831049629,-0.6354921233529668},
{-0.6546907658443011,-0.442575199529492,-0.6127864178322109},
{-0.6680820995431328,-0.439575787844736,-0.6003660841609219},
{-0.6426918398845601,-0.4256748051180619,-0.6369836412605108},
{-0.6134140378591734,-0.37343722410328545,-0.6958935678761063},
{-0.4680145997426991,-0.08826212326876247,-0.8793020709766189},
{-0.335950489295522,0.221908141517058,-0.915365525607418},
{-0.41551929948673066,0.28068555196260564,-0.8651932342971158},
{0.7761486726968884,0.30393560631334665,-0.5524639219766273},
{0.6189363533354715,-0.4893163071535656,-0.6143999854112839},
{0.6834462132646427,-0.7022184416757278,-0.19947564699665174},
{0.7699660255116137,-0.28283694617521066,-0.5719751580585732},
{0.7751169258887859,-0.2159940313436524,-0.5937510670513657},
{0.6140920532090566,-0.04077812849386551,-0.7881802423443657},
{0.7884367879675578,0.08112625919518512,-0.6097425370173842},
{0.8746918932906002,0.09503411424675134,-0.47527108994871614},
{0.8670721582464831,-0.010533657087910616,-0.4980711941702112},
{0.8060437896108559,-0.5331182582078349,-0.25705705980426735},
{0.5340036906845264,-0.8438143048408739,-0.053079914103334805},
{0.6018403419049357,-0.7985723938360767,0.008386576099208082},
{0.5967656653678849,-0.7999028800080975,0.06345173908394212},
{0.4663866959588241,-0.8673155901185563,0.17391698298300717},
{0.4008647122361555,-0.8228616987137024,0.40274819338368767},
{0.40734528234029505,-0.6738613061231702,0.6164257952625609},
{0.34508708629994117,-0.6192526035230509,0.705295055915565},
{0.23652466928325316,-0.6395537657595608,0.7314554405588988},
{0.13434418448403973,-0.709915346737777,0.691355075602617},
{0.03931641292338282,-0.6786621188034876,0.7333975376124457},
{-0.05049304490895624,-0.6893355376862036,0.7226804057802416},
{-0.09466892153174236,-0.7695364905828574,0.6315468192916788},
{-0.10064052371030383,-0.7752353785659929,0.6236037145551311},
{-0.0361348616026557,-0.7075012511822186,0.705787681496746},
{0.06133468404947786,-0.6847515751287415,0.7261909782497014},
{0.127759532264955,-0.5287212128429674,0.8391253666796765},
{0.0351062174861695,-0.48881557366722056,0.8716804967613992},
{-0.09138199861366805,-0.28962788057636457,0.9527670340236457},
{-0.13960128048467008,-0.09307549102570688,0.9858237344765868},
{-0.156675268835363,-0.014606594931858898,0.9875421548064991},
{-0.22364540281241216,-0.029466981215943072,0.9742250411577877},
{-0.3109383167097108,-0.09679175524619617,0.9454886140605249},
{-0.29267303867798883,-0.15599642401791106,0.943402145495025},
{-0.2467443541203426,-0.2005761376542864,0.9480962170125053},
{-0.16585884904553724,-0.223031771923957,0.9605975592857551},
{-0.21285420647015565,-0.3404002463023874,0.9158715843966524},
{0.09858585438325392,-0.3689895619161504,0.9241902036444941},
{0.7627871055804087,-0.007583939589994736,0.646605223780753},
{0.616573943237897,0.08795459140411958,0.7823685591656946},
{0.5573719177352826,0.7523825250643212,-0.35107987879958263},
{0.6540574898415874,0.45132528775574726,-0.6070537740713862},
{0.5954997697893977,-0.11298893013370995,-0.7953700559161213},
{0.7917656356605306,0.3280774050620207,-0.5152401328262839},
{0.8577374400355146,-0.24542956189912798,-0.45171984028524176},
{0.5682169688283852,-0.40691315108258147,-0.7152280502130253},
{0.5265834881467745,-0.32880730863610863,-0.7839614683124768},
{0.7117353111803748,-0.578821206981371,-0.3979935391028403},
{0.7739500899450161,-0.2805527628754185,-0.5677071476712887},
{0.7229728545577351,-0.39071629706578276,-0.5697815605825123},
{0.8628753932373058,-0.10463229684034148,-0.49446752997894583},
{0.8257966859969325,0.17695466359237194,-0.5354875165952931},
{0.8002311101032304,0.04239566508320786,-0.5981912553733163},
{0.8023219501171761,-0.04209338489077404,-0.5954054377553236},
{0.7094075743105941,-0.4323455410070681,-0.5566131750884672},
{0.4416955661794887,-0.8701470154650212,-0.21851589940939614},
{0.2553442125517452,-0.9665258967565302,-0.025040447586139453},
{0.18104479574061016,-0.9832605776457376,-0.02052847736708885},
{0.38961059240502305,-0.9196138416333478,0.050139491044115046},
{0.36278381612604704,-0.9033218934439732,0.22890491384375694},
{0.08211415122096166,-0.9673294459534562,0.23985622602017373},
{-0.007604873203414731,-0.9445236263105878,0.3283554251792666},
{-0.06564018802673677,-0.888107360499675,0.4549249190164405},
{-0.11750570326554122,-0.8311728228374161,0.5434557463828603},
{-0.1726798452935716,-0.8517537384166628,0.49466881862780376},
{-0.2373145173085515,-0.8635901044196856,0.4448527300388361},
{-0.26653351168334366,-0.8152464881135751,0.5141333005828619},
{-0.26331599566039976,-0.8427700197428977,0.4694713838477571},
{-0.2971939209537762,-0.8753617055057246,0.3813366726165079},
{-0.31559021644006413,-0.8721285415145199,0.3738911905395335},
{-0.28935645239626784,-0.9243219266364346,0.24880076245010974},
{-0.3096262415653196,-0.9104892951529937,0.2741182845888596},
{-0.45920077276846727,-0.8053943230351834,0.37479945932663916},
{-0.7264811716927967,-0.6299284122411608,0.27461846738191414},
{-0.8585491678784679,-0.32091983230739873,0.39987971637353825},
{-0.8468401262685239,-0.10380322053433164,0.5216192979062522},
{-0.7950835195835045,0.018869927729270163,0.6062063367486349},
{-0.6266518113866094,-0.06107813014343548,0.7769021619895667},
{-0.5452163499345286,-0.17485825170490327,0.8198559163504124},
{-0.5858425599424845,-0.24801691938451845,0.7715413810412567},
{-0.6497807673802748,-0.2528536710255185,0.7168332967933481},
{-0.7830006233509585,-0.18627154511771749,0.5934753030341435},
{-0.7526458954237607,-0.2693422517404595,0.6008152024783863},
{0.4944154317509532,-0.054801873289561126,0.8674964758029126},
{0.9452605995021842,0.2852786013849802,-0.1584251199166378},
{0.9512602469427238,0.1344437313115707,-0.27754067395156756},
{0.7201567967469643,-0.055939849103474736,-0.6915525441941719},
{0.20945402221647264,0.07836180798512761,-0.974673504116452},
{0.8277946097626662,-0.010542529168167449,-0.5609322054639165},
{0.5503214176812875,-0.3451791131027334,-0.7602616109727415},
{0.6402149487463661,-0.2512459699181116,-0.7259478507452138},
{0.25910716058058253,0.2025486732213931,-0.9443714916875251},
{0.3925147968517493,0.07207287777334996,-0.9169174633203894},
{0.555802474981979,0.49979098529865074,-0.6642985622580486},
{0.7008289191627858,0.16780060993312004,-0.6933121817559492},
{0.5492878943214791,-0.2157751785552638,-0.8072941728213574},
{0.7193862478626931,0.35988242038129803,-0.5941111595371142},
{0.3527322020869071,0.1675755056251752,-0.9205967866147416},
{0.4941437739602343,0.1050575818484573,-0.8630091744312408},
{0.6246079239796645,0.06891281775909089,-0.7778920007625197},
{0.3864741040917574,0.5446662119871359,-0.7442959655849665},
{0.5792538686329538,0.1400017640359585,-0.8030345333424812},
{0.6334156692431165,0.1727006153392641,-0.7542937673206205},
{0.6761994344519654,-0.0038522066078742804,-0.7367085484444257},
{0.801041841187769,-0.11826963411812966,-0.5868085397402397},
{0.6963147237958994,-0.27374122103341564,-0.6634844002176501},
{0.8249010496599322,-0.10696590572167923,-0.5550644586740201},
{0.8134976647502543,0.04863111523771076,-0.5795313314020384},
{0.7141585817089001,-0.1257970932590476,-0.6885874029483162},
{0.7419815334700501,-0.1252927061176485,-0.6586084890002173},
{0.6887965290862424,-0.27656370996547347,-0.6701282383610457},
{0.4271155993330353,-0.786813027091074,-0.4455306108520074},
{0.3834740187729819,-0.9025523238204662,-0.19582384863028005},
{-0.5276616901363528,-0.8443415741413974,0.0930615223326739},
{-0.44233137833836544,-0.8966907023291096,-0.01699223628043384},
{-0.4896301670392803,-0.8704453383843198,-0.05086464794032646},
{-0.5223838717182148,-0.8419733227100864,-0.13489260325616212},
{-0.5404926756641378,-0.8130640100355053,-0.2163205564397538},
{-0.6048805984181012,-0.7462728177150222,-0.2778422991501495},
{-0.6818256382529434,-0.6751953252033807,-0.28146948652468085},
{-0.6697856878218454,-0.6749758025910191,-0.3095073477409334},
{-0.5907346102342867,-0.7448872274364863,-0.3101219738640426},
{-0.6257729438998865,-0.7159064609386027,-0.3096549077105584},
{-0.6454571737398608,-0.6648469721404918,-0.37598343115537886},
{-0.6286216715008707,-0.6601931033739642,-0.4110716000612374},
{-0.8348982146987779,0.014816883692937457,-0.5502048991516011},
{-0.9617517360980669,-0.06758750406645198,-0.2654534373603433},
{-0.9709151674212899,-0.19509721531726665,0.138783335623325},
{-0.9419456428115525,-0.24346562625200907,0.2312204463754193},
{-0.972201905174554,-0.22526562945658998,0.06386588886482114},
{-0.9592241795486889,-0.26136392409978676,0.10760052299271478},
{-0.9369431124200848,-0.06546657341264997,0.34329540028111455},
{-0.8884044268983581,0.13201135242983533,0.4396709873269393},
{-0.4467967504170598,0.32203521960469145,0.8346651910502281},
{0.5475197406513485,0.6061522550401603,0.5768895711544877},
{0.9741170850990735,0.20143544893641663,0.10256541536925985},
{0.8547277684467793,0.49658535516518704,-0.1511404210707837},
{0.8193497666148498,0.437766697855344,-0.37017060687880005},
{0.8744690863872641,0.0713552252539828,-0.47980438595533603},
{0.6954420841647432,-0.12730489737339498,-0.7072155051166142},
{-0.43236062628446814,-0.39067634513799393,-0.8126723092295698},
{-0.38167427299961015,-0.27067581742540514,-0.8837756226505162},
{-0.44115673322896753,-0.06778132477055702,-0.8948667100407153},
{-0.05344947898413418,0.1854799386038499,-0.9811933273172198},
{-0.4194987589135895,0.11400013855964967,-0.9005691309823687},
{-0.37173151590955417,0.20886912795055546,-0.9045382067490347},
{-0.3097154487163016,0.16552175596628252,-0.9363113206238074},
{0.4452507971939741,0.7711499194804513,-0.4550599183441936},
{0.5878815426543902,0.4189892983332845,-0.6919850140635101},
{0.6529606274933041,0.27537051561687753,-0.705558996875843},
{0.4642709582986983,0.0899188673676393,-0.8811169471595295},
{0.5674048368939271,0.42359621477298987,-0.7061288819325912},
{0.7216199224939757,0.13735096710474953,-0.678527375494297},
{0.7038632012325178,-0.17716993673735412,-0.6878861878735423},
{0.6743066720474316,-0.12187302277378516,-0.7283251185784394},
{0.8144563770758194,0.4847727616954458,-0.3188356619932924},
{0.40947672950849123,0.29855906210991623,-0.8620854333667152},
{0.34637587542031306,0.41863621140069024,-0.8395043034022448},
{0.3716794559240932,0.41032760250761663,-0.8327578523582478},
{0.40883001772727595,0.4720141206189764,-0.7810638172015201},
{0.5674279198772222,0.5907681168456521,-0.5736014189857366},
{0.6292744255138998,0.37870135416125417,-0.6786744298635272},
{0.6427432704685277,-0.14578197955641872,-0.7520829094614723},
{0.6483998963227955,-0.10992182074121902,-0.7533224859072796},
{0.7087785135418446,-0.07457622678665483,-0.7014780147229694},
{0.2730998985101049,0.4397438300867803,-0.8555944187139017},
{0.3214715642040694,0.5500563398329212,-0.7707749713228877},
{0.4092124052247533,0.6132274935820049,-0.6756458010861197},
{0.33279691354245733,0.676551630492779,-0.6569049441237115},
{0.5480923005413165,0.6351561589287179,-0.5442163943343167},
{0.6897095103850552,0.6742847960217367,-0.26389544357251093},
{0.68487715918438,0.43705180599099286,-0.5830343006269398},
{0.6106055435548642,0.060763063470036086,-0.7896003547984292},
{0.5842942581575284,-0.18018756891134982,-0.7912854477961547},
{0.5964676783312826,-0.08878104499946075,-0.7977118745229341},
{0.6980079683698124,-0.11400381271869398,-0.7069568634491415},
{0.7424887045667908,-0.10164903939362911,-0.6621011979909729},
{0.7102543899239222,-0.1477946117999993,-0.6882553699875393},
{0.6043871080208314,-0.2899383976208798,-0.7420592626220984},
{0.6644438329889263,-0.24928313605519023,-0.704536947846934},
{0.4200195825190863,-0.6789547572543377,-0.6021660799996922},
{0.18694230798616507,-0.917950203563255,-0.3498856917094277},
{-0.5326319528070432,-0.8298963161391794,0.166058144357857},
{-0.8346793377781585,-0.5073414145839787,0.2142780719862445},
{-0.8372440845677523,-0.5459728091733583,0.030594680904664395},
{-0.8254320897773442,-0.5641867289153842,0.018846752546927636},
{-0.8544368694908536,-0.513663277811513,-0.07802354184861392},
{-0.8504928206850437,-0.4481421561428546,-0.27537350971150354},
{-0.8268103180681465,-0.31698768201787525,-0.46465418042344664},
{-0.755518901738371,-0.23219582164156422,-0.6125979836142499},
{-0.6643416067195413,-0.2564779072112331,-0.7020465174714879},
{0.33258120018956105,0.6762845420318045,-0.6572891019097331},
{0.2759518111647176,0.7142357421411814,-0.6432090659831747},
{0.5549128773418931,0.6311218236064767,-0.5419934891931603},
{0.43082562148070896,0.6308588927951024,-0.6452955456665561},
{0.46983883008506583,0.7768343213102732,-0.4192611489020941},
{0.47503867258621635,0.8785875115671888,-0.04921629878099697},
{0.6097015331328467,0.7881406007829952,0.08425220408319165},
{0.692551847266825,0.7172508942781817,0.0769616365760041},
{0.7508574624333216,0.5243639304375408,-0.4015663576101549},
{0.5940315221976539,0.24314085816406397,-0.7668174970139772},
{0.6320107670609896,0.1934292745600373,-0.750431546553153},
{0.5715870075591375,-0.17632675489845318,-0.8013720536034253},
{0.5604461098140462,-0.134058073417741,-0.8172689832275697},
{0.41548107647861254,-0.31721083598110483,-0.8524979534429052},
{0.5357255959745043,-0.27450482797403786,-0.798526884479606},
{0.664465223052382,-0.20016172594050094,-0.7200147573643667},
{0.5532117385977195,-0.3743777423266075,-0.7441761070661437},
{0.30294469619124625,-0.6089904723820233,-0.7330450979288476},
{0.38191480329378974,-0.5934993700671721,-0.7084487142729076},
{0.06199513558277547,-0.9164424501977365,-0.39533509664541866},
{-0.5775443751131456,-0.7738660921805766,0.2599495453897339},
{-0.8250375044520084,-0.40184117101486316,0.39728678498662107},
{-0.9483422749450724,-0.2113833588521154,0.2365671261025135},
{-0.9561993638505749,-0.28842536909849775,0.04993578909110196},
{-0.9448360766607369,-0.3275317401553751,0.002783420761912896},
{-0.9482517415835298,-0.31699714416100755,-0.018205635873757932},
{-0.9567068881288501,-0.23544815082414336,-0.17110259635757508},
{-0.9353907974496971,-0.13739510471095556,-0.3258322286820092},
{-0.8551230705605332,-0.016771444753368968,-0.5181536961520298},
{-0.6139256447935995,0.02079017146765997,-0.7890900274589133},
{0.31131316211787036,0.9345325065930487,-0.17243291220960716},
{0.4962082076876092,0.8275188306840855,0.2626594743897396},
{0.5818631603395424,0.7800546858714944,0.2301085606612762},
{0.606395064224826,0.7818683079135622,0.14479977611913686},
{0.4780188905162065,0.8421253779828912,0.2496453245442972},
{0.4901122404842839,0.7231828545596961,0.48661745817260293},
{0.6606458550656489,0.5801128321691252,0.47646212455692016},
{0.826992029084207,0.540485376943351,-0.15478934440584094},
{0.5122897203831852,0.21669980036530095,-0.8310237294514259},
{0.29072511283241853,-0.0044614401383984035,-0.9567962188054826},
{0.391396523383665,-0.09252463186117031,-0.9155588206020054},
{0.3882445097197866,-0.20814026545581735,-0.8977437443772163},
{0.33260274340367174,-0.33917896395473596,-0.8799619568429895},
{0.16976372252645372,-0.5227395989150704,-0.8354182127773326},
{0.26814050894068026,-0.4615754890608334,-0.8456055435977731},
{0.4057222814909713,-0.41980978271206026,-0.8118800260143205},
{0.10945022194051705,-0.7047386632721402,-0.7009736552871075},
{-0.21882771252180985,-0.8592188794938763,-0.462447131414781},
{-0.0710088683858014,-0.8904909931164966,-0.4494257800671469},
{-0.6321798089228222,-0.704670535851258,0.32216164435482514},
{-0.796986422868022,-0.2799962600721768,0.5351772940901252},
{-0.9227261666848352,-0.08808530209566161,0.3752564468064818},
{-0.7591104438125541,0.42694494781420067,0.4913953048520474},
{-0.8282226045385247,0.5153454067402485,0.22015092342107104},
{-0.8540516423027148,0.5182018389073432,-0.04541636745803834},
{-0.8366268030685092,0.48997381951755803,-0.24491069510076774},
{-0.7252840631177371,0.43855034379970326,-0.5306944730639169},
{-0.6584540407598782,0.3887647643112685,-0.6444379211661839},
{-0.7036482844725327,0.39363018963756985,-0.5915525044869241},
{-0.6359996994044325,0.3579864178570405,-0.6836300951445569},
{0.25719800607496335,0.9026771355696638,0.3449973544692914},
{0.1726291806062378,0.6412941094795311,0.7476235892145687},
{0.22982990904703265,0.5053217265901403,0.8317620846993401},
{0.5368084461033398,0.5360232081652586,0.6515487798318262},
{0.510162826875868,0.5038621056643094,0.6970343381423554},
{0.5518995755308663,0.3207312118379925,0.7697651253998081},
{0.768782652463211,0.40161565559720425,0.4976726820419798},
{0.5107568258590597,0.1174154484383329,-0.8516695822362117},
{0.42864117597065166,0.1403289446864764,-0.8925102405830853},
{0.3064743375516089,0.028625830900436248,-0.9514483917835805},
{0.28597921340367827,-0.10548678912180695,-0.9524118997690993},
{0.2773642503907951,-0.17178953014626097,-0.9452816669846502},
{0.2057486125243186,-0.3200128925974292,-0.9248022799581238},
{0.11255069786306814,-0.5400067695789278,-0.8341013303067364},
{-0.12224058433513296,-0.7707569233436277,-0.6252927351723114},
{-0.09042297013143676,-0.7077107593326937,-0.7006919206023082},
{0.0021111433004843846,-0.7194130467142441,-0.6945793052569978},
{-0.1982661249296178,-0.8574319150095621,-0.47486951347546863},
{-0.64214343472954,-0.7117875812525023,0.28462299346409364},
{-0.6848645551301827,-0.662769856201998,0.3028145617970175},
{-0.7089698324580281,-0.2239064779510818,0.6687508248936799},
{-0.8241634259938376,-0.0280871146664656,0.565655161068838},
{-0.68252401361374,0.3788797551062839,0.6249888815100582},
{-0.6542684180516696,0.5612157984824848,0.5069217539954594},
{-0.7449141544353224,0.5708260699149674,0.3453411363092174},
{-0.7830781292651671,0.6217164613203282,0.016040111904073572},
{-0.7713228392221209,0.6070797002591912,-0.19108980932414082},
{-0.6895025284122991,0.553765795510677,-0.4668294196336321},
{-0.6037691905606031,0.53523071453565,-0.5907544724735072},
{-0.48402641377993105,0.5349448008738692,-0.6924972857573923},
{-0.5019338346834195,0.5109178873921071,-0.6978720068485224},
{0.4837561558949439,0.20007333616395784,0.8520273715028001},
{0.4329392562532344,0.45425335146585244,0.778599700152098},
{0.9410823422777177,-0.02688797237586037,0.3371068999510386},
{-0.45747011203072,0.3325049999455929,0.8247190561699069},
{-0.16200642967330006,0.521887455465884,0.8374887465344564},
{-0.6395736222930954,-0.7678864929425817,-0.03599882808136001},
{-0.6666804741977204,0.12124871619090112,0.7354154568307367},
{-0.6076736521799811,0.28492423002572737,0.7413170142324333},
{-0.5547580935031947,0.3061021986784876,0.7736568371422153},
{-0.4180342074606241,0.29612617148477843,0.8588112085636374},
{-0.15747411473184456,0.39778845960687986,0.9038618503914232},
{0.3444650328061515,0.3634760360129969,0.865580159441132},
{0.2935808677138139,0.33100291975406715,0.8967983838225216},
{0.32168399977490597,0.1877810832395165,0.9280396915359882},
{0.5215911868395708,0.21263440489536165,0.8262743150226101},
{0.6545776708269324,0.02472261821036072,-0.7555904082263173},
{0.46507677392868274,0.08123167671335439,-0.8815355971544349},
{0.3607157353384776,0.04160585860067945,-0.9317473427970274},
{0.37914296141739345,0.04496845769907954,-0.9242448012403506},
{0.3378334950346968,-0.05434918130074597,-0.9396354059551929},
{0.24659719079604767,-0.32336247484456887,-0.9135789705076914},
{0.1695308657949753,-0.3298263465647294,-0.9286947112235372},
{0.10658714275193117,-0.41203082292803545,-0.9049142401118602},
{-0.0784215980929203,-0.7437972756496006,-0.6637888713203803},
{-0.26193225843372736,-0.8635738956770371,-0.430849879536937},
{-0.27983825200210893,-0.8190229838043955,-0.5008911106383793},
{-0.22724154682862657,-0.8374552011280079,-0.49702119220268764},
{-0.6063561494556745,-0.7426022305632878,0.2843838025973298},
{-0.6163452797524466,-0.4002820307825204,0.6781539588909733},
{-0.6386045573549228,-0.29600159446082797,0.7103289909627583},
{-0.6601871387122389,0.0009314711318914481,0.7511005753163004},
{-0.652317926792294,0.43817583581135544,0.6184523096378761},
{-0.5421331145715078,0.556119631285095,0.6299386015988593},
{-0.5274924240938128,-0.2995700647754079,0.7949902633454645},
{-0.431385686376334,-0.33390566366768365,0.8381010663161472},
{-0.018671398477160404,-0.534433821649506,0.8450040645795799},
{0.12571747071581096,-0.3492074414482879,0.9285737883410019},
{-0.1604611686493234,-0.18364394083489857,0.9698077728861125},
{-0.43621859525026346,-0.07824418249185182,0.8964324765781685},
{-0.5490718709292743,-0.2179219927509827,0.8068643539218144},
{-0.6394814208082461,-0.08043188085567561,0.7645876175972807},
{-0.7177390947580241,0.004439659740545919,0.6962979831058828},
{-0.6186924034533378,0.08831584272890014,0.7806535863186799},
{-0.6061944505954757,0.18760099976531497,0.7728739567059454},
{-0.5878673047495293,0.1672506890314131,0.7914791462982721},
{-0.2948195312610008,0.38502883541976823,0.8745480203409877},
{-0.2320796244133953,0.41407296299051016,0.8801605701531948},
{-0.2023308810266055,0.4383496005728353,0.8757350297096911},
{0.11420295915839676,0.37713192960829517,0.9190915034910231},
{0.0012087635602495838,0.31530805271698975,0.9489886041373076},
{0.06475128062624494,0.133938853882319,0.9888719103493396},
{0.5093307152862945,0.08864182322804495,0.8559934869149178},
{0.6855170734887976,-0.10976616895197308,-0.719734485841106},
{0.5516637965171406,-0.12257860426600622,-0.8250100250230251},
{0.40281261203994667,0.002580003123962935,-0.9152788335613558},
{0.2724639176738449,-0.03971319704761255,-0.9613460748066108},
{0.29291263427028963,-0.040962442476694054,-0.9552613605664071},
{0.26705308531426364,-0.20663944633555315,-0.9412665875522559},
{0.24722140286040117,-0.4174093597499272,-0.8744432539398375},
{0.19579436709063708,-0.43324770304615684,-0.8797505291960931},
{0.015640295779967832,-0.6575405568105503,-0.753256793727867},
{-0.2891317821339938,-0.8629371874008294,-0.4144179329623257},
{-0.6304049858345478,-0.6504322919095612,0.42370672342578974},
{-0.6432417039328595,-0.6523251273483051,0.4008890601545134},
{-0.6464477598528712,-0.6753631906121144,0.35495049591095035},
{-0.6556695613569192,-0.4339363069546111,0.6178970042139861},
{-0.4885666916412287,-0.21894597507715055,0.8446095238725765},
{-0.5223169677114402,-0.0459830546227489,0.8515107421097443},
{-0.5859994014903633,0.45119642102465396,0.6730724263461393},
{-0.5247292279309239,0.611700527871709,0.5920149504501463},
{-0.22754552435884595,0.12312019374998577,0.9659526138663449},
{0.11767650964472819,-0.050324626541031287,0.9917760185855171},
{-0.30169110798579835,0.3687707995114575,0.8791988243793221},
{-0.33949315650604756,0.0678672387587304,0.9381569349468275},
{-0.2957758866302021,0.038837742934035926,0.954467524126362},
{-0.379954109671391,0.0652940521218546,0.922697979460955},
{-0.30392536193966063,-0.00894203709102084,0.9526538796134245},
{-0.1449949428233684,-0.0641778033707516,0.9873488117733029},
{-0.2097371427861133,0.06762539195981669,0.9754163917518501},
{-0.5127336994760512,-0.16442253108738308,0.8426561485519589},
{-0.5625361633041184,-0.14193052351512295,0.8144991046464111},
{-0.5955681118788665,-0.05723398227967105,0.8012633121424269},
{-0.6381563188682612,-0.07474973418728127,0.7662695282519336},
{-0.7142268652559235,-0.16876622862618695,0.6792627952582054},
{-0.547461026782532,-0.032372826514581204,0.8362047741179623},
{-0.4718751311795851,-0.018412205695776628,0.8814731143124366},
{-0.4012264432033552,0.183595735458543,0.8973906324426513},
{-0.3480904221056076,0.28255870351457996,0.893864440005586},
{-0.31749441388389466,0.17113564688121943,0.932689598697803},
{-0.37445664784764104,0.31398743418848374,0.8724643889892816},
{-0.2875356649192164,0.4146192428154629,0.8633736878586215},
{-0.3232185475331401,0.4426448732656321,0.8364181291090118},
{-0.31415763900516197,0.49107046408117905,0.8124990936375239},
{-0.284909572666153,0.37301087538754923,0.8830002390972521},
{-0.32481854119367964,0.2535371722388793,0.9111596005036234},
{-0.0959276820527822,0.1332844213013216,0.986424423285612},
{0.3321200228658997,0.006852391500759082,0.9432122428924861},
{0.8445230031761265,-0.1374225323933378,-0.5175866542879349},
{0.7826397167949781,-0.10743672091321556,-0.6131332846082427},
{0.5710860970760339,-0.1546398645568697,-0.8061930178414447},
{0.3924072932055565,-0.14474372574635033,-0.9083313107540407},
{0.3595366807466337,-0.091625172096685,-0.9286216684075093},
{0.3106558965090987,-0.011984604859340497,-0.9504468860543936},
{0.2797980945103156,-0.06466379008303638,-0.957878708689411},
{0.277025835421777,-0.3059418756275576,-0.9108546839350165},
{0.12188086991821402,-0.5869990885048435,-0.8003606209968492},
{0.09420606223353363,-0.6539220258888365,-0.7506738318976435},
{-0.31806151831970547,-0.88090514510478,-0.3504896516191171},
{-0.6355845914820082,-0.6486082773064552,0.4187356322074839},
{-0.6640441733654626,-0.32219263250597197,0.6747127117360774},
{-0.6507240783196636,-0.43970369068100273,0.6190467173780418},
{-0.6636734419221615,-0.4425877491828169,0.6030370193947294},
{-0.574387935125402,-0.33152254684722865,0.7484459238410642},
{-0.3111126911190639,0.07040186162593191,0.9477618220334986},
{-0.35242749936196144,0.1737760781503195,0.9195633378708444},
{-0.45836755115294786,0.3824609990960925,0.802261037456306},
{-0.2178265543314838,0.16510916930807293,0.9619202432834394},
{-0.49847050377201146,-0.006715328758670665,0.8668806499333921},
{-0.6878707332015702,-0.2449424767908279,0.683254738343108},
{-0.6120309676357926,-0.36103413434206927,0.7036138489929459},
{-0.6288061661895432,-0.2822888938469756,0.7245107216409289},
{-0.6597570136104666,-0.17311509556256136,0.7312672881239554},
{-0.6263992207702938,-0.09083878951616961,0.77419140432945},
{-0.5297140548620002,-0.18122557813853557,0.8285893493824376},
{-0.5246120482969598,-0.0961410417738527,0.8458954420425178},
{-0.483255677097337,-0.08056876572619688,0.8717640876650927},
{-0.3978051574958955,0.06263454284621196,0.9153294328885703},
{-0.3156777724742942,0.17711460613959443,0.9321898735009323},
{-0.3345932133014668,0.2132370334105866,0.9179201213585262},
{-0.2769620724521185,0.17164161676867168,0.9454264465393719},
{-0.22993392283564887,0.35706410335047284,0.9053372947293913},
{-0.24338548091007303,0.43811640023020065,0.8653424336824719},
{-0.17187453415384085,0.5326047141157138,0.8287287632338575},
{-0.34906006576520554,0.43311390753713713,0.8310050623106352},
{-0.420211280913822,0.420481000106462,0.8041257413752121},
{-0.40793685520017964,0.25057860401164606,0.8779509584145132},
{-0.16425695518785505,0.18365280222262398,0.9691704189192903},
{0.16739129213262033,0.06160405611770727,0.9839639706757651},
{0.7581015114535835,-0.20954087134268132,-0.6175554400770363},
{0.7599710753257831,-0.1694604973321454,-0.6274767760739156},
{0.5408132797120361,-0.07684770892853829,-0.8376248719561434},
{0.5679376518044631,-0.12764063803042178,-0.8131141932016801},
{0.3899913063188131,-0.13547192545949305,-0.9107986267051809},
{0.17367588763571842,-0.11772007060072459,-0.9777416177251051},
{0.28300851477499006,-0.07679448810867721,-0.95603806784091},
{0.18998101470203732,0.005711324522395437,-0.9817711519620977},
{0.2776172396640672,-0.15515125088354098,-0.9480805649260913},
{0.02268583704903198,-0.5633079173432194,-0.8259355562365803},
{-0.2558856171195484,-0.8896080137168525,-0.37831221614177923},
{-0.2566645962429132,-0.9112009538748717,-0.3222361039563791},
{-0.6137592252168226,-0.7178741188965578,0.3285671360311867},
{-0.6134984942272564,-0.30812201899354275,0.7271041321518067},
{-0.7369712321953574,-0.21997926981888413,0.6391263754269628},
{-0.6074432793034492,-0.41963206320621027,0.6744787572328509},
{-0.38028525136596936,0.03380386180504665,0.9242512788850157},
{-0.3274929252660632,0.287260528018384,0.9001276425836926},
{-0.32997852419318063,0.231900756811701,0.9150607698734826},
{-0.49172552327676405,0.3400815134632794,0.8015925236419799},
{-0.1293449177518507,0.5423622495024212,0.8301283530674279},
{-0.07194244110431752,0.4701898470352388,0.8796282128904975},
{-0.2442816825650248,0.4857163737552102,0.83928902282187},
{-0.46563383763188426,0.14892042680093595,0.872357630638737},
{-0.5788589490247308,0.2837401924676715,0.7644696333487634},
{-0.3307228613975866,0.168000350196685,0.9286540105350237},
{-0.2479822594011305,0.26013057067129663,0.9331864150449984},
{-0.22712985764195182,0.22629725419249536,0.947207253198836},
{0.16030516022793578,0.1195793409587238,0.9797974468328509},
{0.7029357962241337,-0.1956169508826534,-0.6838240087289393},
{0.4680674162491752,-0.09952092668323485,-0.878070884950601},
{0.5245854827504224,-0.10995229548038514,-0.8442277915385754},
{0.37218281404680525,-0.01735772459830177,-0.9279971240930495},
{0.4202942541239439,-0.11100254155163371,-0.900572693189992},
{0.10542760642627426,-0.15397863653399024,-0.9824335088413668},
{-0.03059565619450054,-0.05358595396758519,-0.9980944100431641},
{0.07562652510126232,-0.010205307587712297,-0.9970839886379422},
{-0.2155511153940129,-0.07588864669556648,-0.9735392287705269},
{-0.15870302639749756,-0.38671458418546606,-0.908441071171123},
{-0.46940668141660497,-0.836189754497931,-0.2836266241278135},
{-0.5906531718301178,-0.5265806126396405,0.6114259472733244},
{-0.630608433818015,-0.5617763331861019,0.5354814232721504},
{-0.5879428076983843,-0.3268130925806441,0.7399435501398848},
{-0.5728032295160072,0.39748533832371313,0.7168694902656381},
{-0.28705489727552613,0.41697522504334245,0.8623984854173801},
{0.42901314515077726,0.1974189882493046,0.8814609828951359},
{0.6756068001272009,-0.1941358825471158,-0.7112430742928446},
{0.39826007266171876,-0.0965932443712845,-0.9121724944687337},
{0.30051834199575284,0.005444388085047196,-0.9537604965411931},
{0.34761934770243896,-0.036258179984811775,-0.9369344339318092},
{0.19797721285163877,-0.027875654054016714,-0.9798101709528012},
{0.13107274988666093,-0.12886448535377698,-0.9829617890089396},
{-0.07362704588428208,-0.12644863148626181,-0.9892369795502013},
{-0.22124803153108297,-0.04311252915728756,-0.9742641419929622},
{-0.19132940203120935,-0.01975206745702247,-0.981327119644389},
{-0.9116048748956825,-0.33363296580254814,-0.240136619856745},
{-0.7911129781129299,-0.5941271689339634,-0.14544126991952666},
{-0.5830693353656919,-0.4588435725588232,0.6704421869763763},
{-0.5647008426402336,-0.2706143895364532,0.7796671151826418},
{-0.6236959051182747,-0.29745019543623363,0.7228601518783855},
{-0.6118786086287906,0.7313650811911276,-0.3011804879416836},
{0.17105503024758517,-0.011550408123288107,-0.9851937701280816},
{0.30084288279486965,-0.08438165130941996,-0.9499333117613928},
{0.37936115520426517,-0.1279582384750854,-0.9163579012200629},
{-0.7154391568692797,0.4317266010753114,0.5493259094036372},
{-0.5163311647492089,0.6967600025219296,-0.49792331457199934},
{0.14652244764203226,0.9404090186796851,-0.3068583548201017},
{0.5787505134850696,0.6521011019239377,0.48970603019602926},
{0.5704151462528905,-0.10099662473177866,-0.8151234524402311},
{0.4432700309498069,-0.13143463239538253,-0.8866998460972281},
{0.23606731598960906,0.05243127045708018,-0.9703211757968175},
{0.24331518007095082,-0.025361083037642652,-0.9696156654129504},
{-0.008781890227396057,-0.08256573602068391,-0.9965469269629988},
{-0.06717230439459825,-0.1384645246908185,-0.9880867658887377},
{-0.27089056866084277,-0.09022782950800298,-0.9583721816668512},
{-0.6719838202188969,0.00031180160533634713,-0.7405657622006138},
{-0.8105111015569527,-0.13911879839433744,-0.568961961985378},
{-0.6837101926172314,-0.20482876828849886,0.7004181238322753},
{-0.6682165906011718,-0.30435973470737476,0.6788606189301324},
{0.5447918528589284,0.6066846617327429,-0.5789089378103978},
{0.2671421556532649,0.009638475772450528,-0.9636089292123182},
{0.18949433264324086,-0.061943199203941826,-0.9799259859644878},
{0.04689170560653325,-0.10111962468710947,-0.9937685794230207},
{-0.24157425950703704,-0.17374857002962413,-0.9547006397590229},
{-0.27108605764775207,-0.14810388165462077,-0.9510928396259924},
{-0.6399309853435657,-0.06041671156612787,-0.7660536240765058},
{-0.7864830537042798,-0.01150852447773356,0.6175046235457159},
{-0.7118837949693628,-0.13185751310876506,0.6898079868316909},
{0.7037798308755229,0.14654844190212973,-0.6951384781673925},
{0.5573719177352826,0.7523825250643212,0.3510798787995827},
{0.34846999278832846,-0.1892784765492876,-0.9180099794889395},
{-0.060586490431304874,-0.2982694133478691,-0.9525568929141899},
{-0.1867291369944476,-0.25325966350068296,-0.949205863994123},
{-0.5517837313727645,-0.2663615480085096,-0.7903076866226592},
{-0.6089539136974976,-0.1812406250531888,-0.7722220968237247},
{-0.9233674052655817,-0.0013372703966171063,0.38391515547187394},
{0.9452605995021842,0.2852786013849802,0.15842511991663785},
{0.7627871055804087,-0.007583939589994736,-0.646605223780753},
{-0.0587613320163401,-0.4685366953887067,-0.8814876465010135},
{-0.6603058920730691,-0.3049569124178533,-0.6862925108597341},
{-0.6115288381778882,-0.2707295708884284,-0.7434635024823811},
{-0.9555219443229931,-0.21405109792492794,-0.2028791300117869},
{-0.9896581445703265,-0.14310776757589835,0.009844985782704908},
{0.4944154317509532,-0.05480187328956112,-0.8674964758029126},
{-0.7730263779754478,-0.20008488710866612,-0.6019935688235152},
{-0.939734333752748,-0.21230751495833758,-0.2680016810740079},
{-0.9465559091874767,-0.24156834717268447,-0.21372094990086188},
{-0.4444498053909489,-0.02269856138942552,0.895516133745673},
{-0.39805516022239384,0.1524944631258008,0.9045979925559741},
{-0.22155875927729887,0.1617126708571957,0.961644803590045},
{-0.09498776010612257,0.40717185314180265,0.9083988151902732},
{0.08537783965748645,0.4726471817815424,0.8771061885823095},
{0.9426831354165153,0.313488742379613,-0.11433859629423823},
{0.36910724631744113,0.6565278991571939,-0.6578228928398564},
{-0.4674101907464203,0.19912862231243753,-0.8613219522120318},
{-0.8969235806885097,-0.051703483844628924,-0.4391524110866645},
{-0.9680688344651056,-0.2506837282181945,0.0006325693623631548},
{-0.5364679470385654,-0.26825938877906724,0.8001493873846985},
{-0.09618936365576992,0.14167457025660074,0.9852288680616832},
{0.9364666880761614,0.27907160625768385,0.21248336571228785},
{0.3650121277966389,0.9279061584312512,-0.07587033482678206},
{-0.5583962259198633,0.759691475256429,-0.3332604346470845},
{-0.9376562591888465,0.1628470751391928,-0.30705304056887106},
{-0.9654410925502983,0.0033744544906221404,0.26059952009199294},
{-0.39997715406988504,-0.2998344545158825,0.8660932837214008},
{-0.34193750513398696,-0.35042566826041543,0.8719407053274816},
{0.17968128693697735,0.0335649891143718,0.9831520872329081},
{0.9512602469427238,0.1344437313115707,0.27754067395156756},
{0.8477458511899263,0.4314650356304765,0.3084880788922951},
{0.1702442418886522,0.9623652005091505,0.21182568057896206},
{-0.677022574524172,0.7314754377579327,-0.08114257539357969},
{-0.8301709319736025,0.33874481134768264,0.4427958632271797},
{-0.27180900772300487,0.7393065697998411,0.6160727710030919},
{0.5814048470957519,0.47345516881584987,0.6616710715265709},
{0.8744690863872642,0.0713552252539828,0.47980438595533603},
{0.8440808407947505,-0.038992858269701815,0.534796308146556},
{0.6669797951546089,0.0031656462704475904,0.7450690783673728},
{0.24149490735551513,0.39707683144646067,0.8854435044935336},
{0.5973724968490826,0.5277630965298786,0.6038312793732094},
{0.38080706107307205,-0.12003767325944284,-0.9168298311220838},
{0.29084510653123913,-0.14553388875435835,-0.9456368284023556},
{-0.42847667872421585,-0.0018635302319281138,0.9035509188997263},
{-0.2530063065804538,0.2049061943418943,0.945516398774151},
{0.74432717702991,0.5504898572014972,-0.3780713830124678},
{0.58190568890751,0.3693212977059612,-0.7245602447539203},
{-0.4698617355649862,-0.27333732446105174,-0.839354904976633},
{0.0643397662238558,0.7507120220979612,-0.6574890526539966},
{-0.7450545500140043,0.5275366217987378,-0.408165199600119},
{-0.9654410925502983,0.0033744544906221404,-0.2605995200919929},
{-0.7001214848799407,0.6889675239595986,0.18749308610849347},
{-0.5588635562196329,0.7433467929868697,0.36756913755874726},
{0.12071566534104068,0.978589669590591,0.16670328944519228},
{0.1884523517705943,0.9513594530682731,-0.24372300295574992},
{0.39619263420044515,-0.11505476553639735,0.9109301825785974},
{0.5778192580192554,-0.10454376596101318,0.8094414778480072},
{0.44430203377220545,0.20741469046710082,0.8715359137547454},
{-0.47563283115653754,0.8226606101237974,-0.3114529346093213},
{0.9037770770518953,-0.4255302087593627,-0.04594601646221124},
{0.628653189213996,-0.34012431149392036,0.6993644403469899},
{0.8463660309115935,-0.31931627304564464,0.42626477626845377},
{0.8945430286401127,-0.01316796677636476,0.4467878406608118},
{0.937601060057186,-0.07783301470352186,-0.3388897667410486},
{0.8007737041589861,-0.34159318768593133,-0.49201175682503845},
{0.7645689045599542,-0.5417451802899094,0.3492084618285263},
{0.8971460483946795,-0.4145131361854557,0.1526690138158667},
{0.49954534346765106,-0.28798139378866816,-0.8170196855959606},
{0.8738850214760754,-0.21474656827178745,-0.43612943108124447},
{0.8907615876324391,-0.42388988773255076,0.16389373714886762},
{0.9496706911576092,-0.23544115196735432,0.20662294721669758},
{0.8159634963865369,-0.4111499548293022,0.4063979419344057},
{0.9059955685250755,-0.40267424746668773,-0.13048172377793799},
{0.9776091613451487,-0.158867900216738,-0.13799028203014754},
{0.702517650101662,-0.1717599378677085,-0.6906283190250163},
{0.6337545809993678,-0.31136310288985847,-0.7081017929797349},
{0.7000063423312013,-0.2225801521559054,-0.6785640696075406},
{0.9760522159931198,-0.2001778299940889,-0.08515226382062847},
{0.8279421054490596,-0.3750534847873151,0.41694934173526355},
{0.8968545917238173,-0.2816697777303819,0.34104835084958585},
{0.8653277956789149,-0.40252663932886074,-0.2986303913805214},
{0.822454174833645,-0.26394411260125406,-0.5038875228876427},
{0.4018159032904465,-0.12724685860058532,-0.9068363782067663},
{0.3867486852503856,-0.11728742512674523,-0.9146961869190428},
{0.2809940791736947,-0.14858860692521014,-0.9481369908200781},
{0.6177244951481887,-0.06748101055435038,-0.7834939446533579},
{0.9078857062017571,-0.41649486384669676,-0.0477029649378129},
{0.9422140034575075,-0.32820913474052754,-0.0671679652918711},
{0.7401356307386333,-0.2361379146433207,-0.6296333324872732},
{0.5513001014437924,-0.28643098231467107,-0.7835977861877333},
{-0.03842286102647077,-0.014227339929568095,-0.9991602807102918},
{-0.08662251304518861,-0.024837822493113386,-0.9959315352008573},
{0.5828729202436508,-0.14649461891287266,-0.7992487006409275},
{0.2798236377380521,0.31078211831901514,-0.9083574223268004},
{0.9352418152791427,0.3221515765235846,-0.14676889553560993},
{0.9006587004181127,-0.06798686147785862,-0.4291755957968099},
{0.776863754529721,-0.2599172300415674,-0.573520479517083},
{0.4149584187598642,0.04337222690691794,-0.9088060082511822},
{0.14711386939413326,-0.15829988843477916,-0.9763701422889899},
{0.04483591396489137,0.020265448460595095,-0.9987887926972467},
{-0.18350903839069194,-0.06791536628904275,-0.9806691265920167},
{0.06167482234873608,-0.35009267071718925,-0.9346824798819959},
{0.9180960862027131,-0.25201164853009306,-0.30592434604719687},
{0.9478963317828024,0.06310478043424737,-0.3122664421276366},
{0.9567155403169606,-0.11715175887919169,-0.2664035290823642},
{0.8719299283579884,-0.3205954791056752,-0.3700766661255955},
{0.4963271018108501,-0.005690143859103692,-0.8681169450430655},
{0.2225894012102543,-0.25078406933916497,-0.9421047229658437},
{0.20504273498179726,-0.052753978014224726,-0.9773302894287371},
{0.1336314494935816,-0.3254699522573755,-0.9360619348546473},
{0.08376318221321204,-0.04314755322728959,-0.9955511126788088},
{-0.009871240423173284,-0.17479585384052793,-0.984555213328673},
{-0.23592921528421826,0.059601803835557625,-0.9699407354858959},
{-0.17444966479271062,-0.08739676967168485,-0.9807798525177123},
{-0.3897266853234945,0.21487897464698147,-0.8955111037845503},
{-0.5398503815721861,0.24643386081754273,-0.8048800642076588},
{0.4567763569907108,0.17586635758790276,-0.8720243023924613},
{0.3384813888566682,0.26611109332784477,-0.9025603777064003},
{0.7847389963815236,-0.2268384344032415,-0.5768266916809637},
{0.800588742152621,0.13986242601273716,-0.5826629967041974},
{0.3180615057331893,0.22531694668946742,-0.9209067010860937},
{0.1314865579728731,0.012453315998109503,-0.9912397288209838},
{0.018163689594667014,0.350854500521499,-0.9362538116579915},
{-0.011062013937348649,0.12408853976492853,-0.9922094870271386},
{-0.11880472521652545,0.41990745058420614,-0.899757284055038},
{-0.20173331512105513,0.2146215569368501,-0.9556365715418553},
{0.37277721633920813,0.25589418206212683,-0.8919390755904497},
{0.3149901897049552,0.05383666348638276,-0.9475667755120429},
{0.7359083901094364,0.08851257695179357,-0.671270709243216},
{0.7432744123302569,0.27433306258900536,-0.6101512261281197},
{0.511232795026935,0.37936709159697274,-0.7711819753483623},
{0.468546640443649,0.38528975577352587,-0.7949942451520933},
{0.20647015549173017,0.6043599967437414,-0.7694927350060725},
{0.2524911034748621,0.5367980027567683,-0.8050441894097438},
{-0.40988368209311365,0.8015510697900226,-0.43532889827377846},
{-0.3249167901775778,0.8055271258927598,-0.4955351944228075},
{-0.8471656733973013,0.47645252446687414,0.23516656596216975},
{-0.7869089147874846,0.6158792189166294,0.03830336192328159},
{-0.7345301633357051,0.0591082791152038,0.6759967828991951},
{-0.7622952545510542,-0.15655901651690948,0.6280089324493734},
{-0.4436567445342338,0.06076779494741136,0.8941342002890365},
{-0.018839149821980424,0.9060869737057752,0.4226718378537834},
{0.28124655843649593,0.43777920728306957,0.8539612046447038},
{0.22661641216007572,-0.3046170428239507,0.9251234830880072},
{0.006193277731657746,0.6357651240520966,0.7718577267540703},
{-0.6004919325835997,-0.3433706306795564,0.7221537570966013},
{-0.5797059097473671,0.0399709589920277,0.8138448136108228},
{-0.62619437919365,-0.3786071781715725,0.6815696619592441},
{-0.23037840568107332,-0.2097999027181553,0.9502156550043255},
{-0.21308375904713983,-0.528476380408376,0.8217712741272976},
{0.28430924447808575,-0.3046717519873833,0.9090343101584442},
{-0.2053950290637216,-0.4140671563926872,0.886770134833592},
{0.6606030650374725,-0.07231126721384461,-0.7472447196849402},
{-0.7615426069629694,0.6205961485268177,0.18685095186732273},
{-0.4396432060466798,0.8937882157797702,-0.08863676838768302},
{0.24736558460294242,0.31341925040568047,-0.9168307592076008},
{0.8946477401380927,0.23764986397988402,0.3783225650369619},
{0.9898284321124424,0.03679044512165043,-0.13742684646594613},
{0.8389086493434448,0.031409525934095114,-0.543365180829019},
{0.8791068772825303,0.4662004729387283,-0.09913736604461486},
{0.9851627700750307,0.07418815031468617,0.15475928020954935},
{0.929149007770579,0.058014786411149794,-0.36512519211445416},
{0.5692946221911731,0.04116470249125257,-0.8211023690216805},
{0.564387076218175,0.28224103615419477,-0.7757623513090247},
{-0.2548949889012452,0.7713284108874184,-0.5831646655884801},
{0.5846942356642448,0.634016157662427,0.5061187238227578},
{0.9953104804377981,0.07974094500595325,-0.05475791468123275},
{0.7948475628127707,0.10127628404394023,-0.5982979744081118},
{0.07354653529347581,0.3323089264571648,-0.9402987209090587},
{0.13314777293869515,0.9017638590990557,-0.41120993784713433},
{0.6054800641559999,0.7004440781445291,0.37785180335934215},
{0.45373781837343113,0.8178486026281904,-0.35390062921226295},
{0.03889498049760732,0.9986333471299482,-0.03490871656373877},
{0.46280665727434744,0.6571069996288913,-0.5949961252153336},
{0.11412617870015465,0.5979696491162635,-0.7933520744732903},
{0.38616634103585884,0.8308485633579836,-0.4007071521909131},
{0.2430461713979393,0.9687425341857587,0.04966347780972882},
{-0.6993312598300101,0.5566279344116365,0.448443008259919},
{-0.09319287708162308,0.9725328885433456,-0.2132952609946735},
{-0.7301783698451743,0.6529877530647871,0.2011132580354779},
{-0.45034558523071233,0.5686534917666899,0.6883473397673288},
{-0.3998577798984784,0.6385944064268457,0.6575035664808249},
{0.9120826039575181,0.3484917376653683,-0.21600655623625284},
{0.7115797462327166,0.6661021153078036,-0.22352234056991305},
{-0.44068577588765306,0.8892269156407956,-0.12276619823980292},
{-0.6736278128835156,0.6422141429066486,0.3657684573065999},
{0.17496219433191704,0.8339260991970574,0.5234075769728025},
{0.27806248051106924,0.7507593048135359,0.5992009038443845},
{0.575079458499019,0.71361507991311,-0.40004641497341364},
{-0.1770951625842692,0.9731259884487066,-0.14718394611838306},
{-0.17472119098864636,0.6470779754780414,0.7421338148007731},
{0.18471204609151032,0.8225739938030028,0.5378229120701955},
{0.34843585351338213,0.9004065279946868,0.2605005572565135},
{0.0018928817497322868,0.9921265762410866,0.12522489255264266},
{0.19560119527760952,0.9478790857374889,0.2515261641011379},
{-0.1856456406536295,0.9243412612664064,0.3333600588353868},
{-0.5034894321274269,0.7442853230010686,0.4387912370378378},
{-0.7769808599894811,0.1859198134966507,0.6014437348242785},
{-0.7616438162192963,0.06295622801558334,0.6449303920338664},
{0.0900917929330971,-0.0944463868027942,0.9914450811144291},
{0.1541276094528623,-0.11318840947408028,0.9815462617549282},
{-0.45473181846405347,0.10804052176435293,0.8840510273356745},
{-0.1705726344350594,0.6959910110295253,0.6974965870511357},
{-0.3114516781684607,0.9480024853319378,0.06549152594434635},
{-0.22530777008299652,0.9531457738164248,0.20186515944094066},
{-0.15140388556495463,0.9875153406758209,-0.04347775713800448},
{0.14882916758697498,0.969615716065423,-0.19415262561785027},
{0.0464895574487152,0.9904574721615372,0.12974096071634525},
{0.11298798951385257,0.9158863154314215,0.3852089970796014},
{0.4256034584673733,0.44868424736001467,-0.7858397688534143},
{0.37249841849381843,0.4536887587277687,-0.8095748504145004},
{0.17983285229575602,0.44639186200645325,-0.8765811147689554},
{-0.11705746989031407,0.3977065736319911,-0.910014851545171},
{-0.2047661151279468,0.8500641676986754,-0.48524400963862174},
{0.44028789030866217,0.7847870445323425,-0.4361832967706794},
{0.6328870332837593,0.6178964080414143,-0.4665383500108},
{0.27917147049923235,0.6800540810608433,-0.6779304808693796},
{0.14232538310331896,0.6820433592786475,-0.7173286146449138},
{-0.0808252743969837,0.7187054069943128,-0.690601051965454},
{0.44676739670389676,0.781730594368091,-0.4350817981383895},
{0.6595125257114767,0.7045856937326883,-0.261920271489045},
{0.5570431182124256,0.7474657639516318,-0.3619363150781931},
{0.24960353222807455,0.7761458095913567,-0.5790472855933669},
{-0.314181231544506,0.8730400856190308,-0.3729492762394007},
{0.10789883517107045,0.9548728500852064,0.2767231134887024},
{0.29218241674839107,0.9391847978857737,0.1804476399494548},
{0.06084106165265877,0.9381139474880223,0.34094073787891266},
{0.31369551003768703,0.9495203131074101,-0.0025103741954201828},
{0.12707974919476372,0.8506895599607959,0.510076474578375},
{0.0971784885541225,0.8952067955900762,0.43492658517465205},
{0.2638221007764673,0.9269392045030111,-0.26679881989472215},
{-0.06792106620982477,0.9196157417857465,0.38690259268292804},
{0.04792897491179829,0.7813242671216153,0.6222822534596136},
{0.2659447679401926,0.457022891962212,0.8487658432263478},
{0.06602531336191773,0.26387400290059315,0.9622947410168459},
{0.4146533011598719,0.004280154113260159,0.9099694061439577},
{-0.5800588616257525,-0.04300140819062327,0.8134387475053421},
{-0.5574108471655042,0.002636486165740366,0.8302326158390386},
{-0.3283763145724745,0.07141245261180859,0.9418435420173382},
{-0.4401424972083052,-0.07756707998630447,0.8945713667749685},
{-0.29278180899821654,-0.2603275513077501,0.9200588993916872},
{-0.006769847440562823,0.07968645706461777,0.9967969892240447},
{-0.04577544319966381,0.0453080245066761,0.9979237404306888},
{-0.3448954730033287,0.30274063341490903,0.8884791621537053},
{-0.8002155425344816,0.13957445449061326,0.5832444231537005},
{-0.8251945580298747,0.25631942531620416,0.5033431171710311},
{-0.10933612933766637,-0.17813220200503357,0.977913354766308},
{0.07502334334835815,-0.2972810730199329,0.9518379387148589},
{0.0871828774122636,0.5113310144972149,0.8549501386042154},
{0.17878022822133097,0.8447215617468203,-0.5044631930251618},
{0.07728116932129883,0.9482470987275226,-0.30798548768272965},
{0.2190818685559223,0.9721683281775493,-0.08301732685719541},
{0.18798234369116798,0.953281761977007,0.23646674341731164},
{0.18252437309672856,0.9399077502332072,0.28854509920842064},
{0.23393075997098545,0.9436850980865061,0.23395477167362597},
{-0.19734111001646296,0.9013757661115903,-0.3854584472601605},
{0.2776753875562976,0.9528773790799588,0.12215187097694587},
{0.29428874227487384,0.8917926106873896,0.34365691567847567},
{-0.020323930716123893,0.9852731942642092,0.16977535305411046},
{0.2902774737338729,0.9053899777425969,0.30985153936351606},
{0.12401381541623131,0.9425551728765548,0.3101778839143061},
{0.1860355143904033,0.39013365514641885,0.9017685504094679},
{0.28798448608641886,0.8464077374001268,0.4479496376187164},
{0.1555388759155667,0.8828960785470252,0.44306001011737356},
{0.303939829335601,0.9456088398066779,0.11595043002470709},
{0.11702842555573043,0.6622517802168641,0.7400857566603622},
{0.15647077339304502,0.5745078587890912,0.8034037697592388},
{0.27496561205971787,0.8173584278379172,0.5062796782678058},
{0.11367659598700652,0.9902469375765331,0.08055205860252442},
{0.26689243751363323,0.939339194048688,0.21543051158550544},
{-0.294218047292923,0.9413253429120668,0.16535519174981797},
{0.23945208408122387,0.871691468802659,0.42757067561494616},
{0.012066058043145027,0.5500422465998703,0.8350496615164075},
{0.49428149846219305,0.8688584099081739,-0.027764434260561244},
{-0.28262956274651024,0.42507042580495213,0.8599044501383355},
{0.12881778993054283,0.9308599974460201,-0.3419146708642465},
{-0.05106902257187081,0.7893673010674607,0.6117934446682365},
{-0.509126317658755,0.018305514755525436,0.8604971242234175},
{-0.22054608599730668,0.22536906875563212,0.9489827220763756},
{-0.33931720055790127,0.0965556275761382,0.9357033975512364},
{-0.5017379853057201,-0.06014157031854711,0.8629264079983741},
{0.16695737162964355,0.924240197178331,0.34337340313175246},
{-0.5099243538397108,0.4988395275535182,0.700811157952937},
{-0.837847313873321,0.34338895292628435,0.42437707954536213},
{-0.7449790263496671,0.4308750955008404,0.509267024630737},
{-0.6846052044617641,0.3878775899172857,0.617143977742491},
{-0.6590495664784266,0.3304254216334773,0.6756276412810066},
{-0.7160543592109676,0.43869803700873894,0.5429642593943452},
{-0.6705422193374141,0.23787163308878156,0.7027020835729259},
{-0.9012297675085815,0.41794969910997537,0.11446814041605245},
{-0.8084469602559479,0.5458115605403672,0.2202345405094463},
{-0.7656380752994767,0.3853355668621431,0.5150872145207486},
{-0.6912993231296151,0.28653348706658477,0.6633278274201974},
{-0.7523750871293885,0.3964475743312765,0.526080838915363},
{-0.7320057817148493,0.3764023501468139,0.5678809790264047},
{-0.8037495678133376,0.5000650205401788,-0.322368744564394},
{-0.7332518732392387,0.6622363558109394,-0.15422288881159693},
{-0.837623331131942,0.4777945076368938,0.26476322179533784},
{-0.7050358640007115,0.402135491639831,0.584133098562615},
{-0.8464158077489217,0.49077668439097355,0.20668460622635512},
{-0.8371328432658174,0.479607793989656,-0.2630303531345084},
{-0.6523240594248276,0.3835579047305561,-0.6537252138431097},
{-0.8655711416440482,0.47048426964466883,-0.17155509543566924},
{-0.7878069856666317,0.5677572578119819,0.23877154256040306},
{-0.8337014735628472,0.474030801104167,0.28326075016436514},
{-0.779906115494993,0.36819473368117084,-0.5061413726449977},
{-0.7564977639662237,0.43246992460178474,-0.4905923943856349},
{-0.6805305333108265,0.39045766676964627,-0.6200169382303083},
{-0.8311257919127418,0.3472374864446215,-0.43434553759079747},
{-0.8671354714457052,0.480926941367152,-0.1295582927792359},
{-0.9152218668554606,0.4017192788413908,-0.0314730906769335},
{-0.7438263384026473,0.33356899728350575,-0.5791839969731439},
{-0.7227271370879399,0.47219409012510366,-0.5046763582411956},
{-0.6111415064328163,0.4144027134489589,-0.6743711516673647},
{-0.6858921540031048,0.32229969262947483,-0.6524376301286791},
{-0.803538886362166,0.38999125134087576,-0.44970221478377004},
{-0.8730301846703779,0.2549208996772713,-0.4157326443306278},
{-0.4952115223244987,0.1380074941719114,-0.8577409164249087},
{-0.28727534582936665,0.5660176526277761,-0.7727204491873888},
{-0.22054608599730677,0.2253690687556322,-0.9489827220763758},
{-0.43158570274098396,0.01771690793983927,-0.901897938994553},
{-0.5957234076295082,-0.022856356313713487,-0.8028643774501066},
{-0.7388796500339497,0.13601662872436662,-0.6599669230167263},
{-0.6823233340275868,0.018798970628752704,-0.7308087756347604},
{-0.23531721776073153,-0.021493798595366907,-0.9716809268722374},
{0.10210181428418648,0.7295440611583178,-0.6762696816718211},
{0.1541276094528623,-0.11318840947408028,-0.9815462617549281},
{0.07502334334835817,-0.29728107301993295,-0.9518379387148589},
{-0.2596200007190523,-0.14598092398378396,-0.9546135474942099},
{-0.3607177954828625,0.1437094458127166,-0.9215369049615895},
{-0.7523608843928687,0.24184828076342008,-0.6127499561218737},
{-0.6535229114942955,-0.036647958199624714,-0.7560190019515499},
{-0.5002476372452815,0.12206028982613876,-0.8572360159711397},
{-0.20650755426451406,0.5247864288175126,-0.8258049613320634},
{0.03916580792734349,-0.03568579031142975,-0.9985952953320214},
{-0.28768242362861457,-0.29212236760279126,-0.9120873562775148},
{-0.46355318313692034,-0.14177520866367446,-0.8746532093418513},
{-0.2584803731242948,0.2113558841817463,-0.9426115779743411},
{-0.5435202197532467,0.021640617129804206,-0.8391170683579399},
{-0.6016932070586405,-0.10680008510829718,-0.7915548157900048},
{-0.008762458100581402,-0.03682282939049083,-0.999283392518716},
{0.14432940887473192,0.3260717078549211,-0.9342624165995577},
{0.37431961473868997,-0.23721730231394236,-0.8964445200372272},
{0.2659447679401926,0.457022891962212,-0.8487658432263478},
{-0.22660886661553556,-0.24789317401618183,-0.9419115647699656},
{-0.1588246466483475,-0.5207304400332717,-0.83881734629166},
{-0.32217341639727026,-0.5746116877692177,-0.7523467937367196},
{-0.62619437919365,-0.3786071781715725,-0.6815696619592441},
{-0.5797059097473671,0.0399709589920277,-0.8138448136108228},
{-0.6004919325835997,-0.3433706306795564,-0.7221537570966013},
{-0.02365160293899212,0.6925816161998367,-0.7209516672984663},
{0.14111396996063197,-0.2205368064262152,-0.9651167621035684},
{0.40351633348495064,0.4604812378973156,-0.7906526406427906},
{0.04533173164476597,0.8829556205026337,-0.4672626738023229},
{-0.4807048074445736,0.00764077587190798,-0.876849192645891},
{-0.7345301633357051,0.0591082791152038,-0.6759967828991951},
{-0.7622952545510542,-0.15655901651690948,-0.6280089324493734},
{-0.8471656733973013,0.47645252446687414,-0.23516656596216975},
{-0.7869089147874846,0.6158792189166294,-0.03830336192328159},
{-0.4302605415494247,0.8083686407701176,0.4017661098264367},
{-0.2178562178438048,0.7640819905354416,0.6072210306685616},
{0.26566263397106243,0.5964293649910949,0.7574268132881729},
{0.29434163917890743,0.4530377880998851,0.8414985216855925},
{0.4627156725051272,0.4767612897797185,0.7473907137406158},
{0.5194545005273735,0.2745988821833384,0.8091739465563123},
{0.7545353483478605,0.19907481465621682,0.6253364104729274},
{0.7706914691277221,0.001466139509250712,0.637206803046462},
{0.288456898489205,0.10857591708365183,0.9513169229775282},
{0.2623312848097677,0.49451680430171074,0.8286346766056076},
{-0.11967747114403898,0.4311405548862017,0.8943126549663635},
{-0.13111484646808771,0.18298669269255902,0.9743329858590896},
{0.0007710965219956283,0.3104679239135254,0.9505835437408852},
{-0.013082796580300145,0.07878134636039624,0.9968060693531525},
{0.2580134125397263,0.2644440970648296,0.9292461452581723},
{0.41154547970646166,-0.11526598478014931,0.9040708328918928},
{0.8168055705498043,0.026965366620925222,0.5762825079089317},
{0.741869461986505,-0.23749158886389968,0.6270785011390154},
{0.7811574702149464,-0.05979313935340444,0.621464228426423},
{0.333846978077063,0.25660763500536343,0.9070274069099385},
{-0.3897266853234945,0.21487897464698147,0.8955111037845503},
{-0.49728504191741385,0.26881671474356417,0.8248909994415463},
{-0.2320651891266063,0.19448011184137184,0.9530599320576855},
{-0.21986643390213684,-0.09842237561471281,0.9705523103993486},
{0.05707540404451918,0.0364502135794592,0.9977042548687294},
{0.13589635728125685,-0.3013019564999934,0.9437951637336149},
{0.2817162776089462,-0.04733057993873572,0.9583296693376565},
{0.13522428535587389,-0.31814491497885455,0.9383486589339224},
{0.34246813496336986,-0.02389074531243174,0.9392256431886469},
{0.4040446211428673,-0.2357174241454409,0.8838468419809822},
{0.9253848137139887,-0.2427885535652457,0.2910612732831732},
{0.9154768051063583,-0.323406989272818,0.2393953604432345},
{0.6988485603053894,-0.31342809956593076,0.6429413007122606},
{0.6531577996802389,-0.050343186314235865,0.7555464593978316},
{-0.04501657455225698,0.08546479777067831,0.9953237043081001},
{-0.043762661513107017,-0.13367554370643114,0.990058421746959},
{0.3769368608934309,-0.011794508635272887,0.9261638583241407},
{0.16647133095977687,-0.128967493986354,0.9775759210738367},
{0.776863754529721,-0.2599172300415674,0.573520479517083},
{0.920098144171365,-0.1252470723762618,0.3711233972058154},
{0.474582884125945,-0.10649848473846092,0.8737443326529287},
{0.8988411579574019,0.1532362219926013,0.4106132402044908},
{0.6111203462008686,0.35293661795969405,0.7084967651037677},
{-0.061558218946398055,0.27678682115330727,0.9589575805613063},
{-0.01801169666136737,0.05161200404898973,0.9985047720574128},
{0.03049757908261418,-0.07292628136272854,0.9968709320452191},
{0.6630957809280865,-0.2387347680671376,0.709443229463289},
{0.7659126564135161,-0.37329184522846776,0.5234797045077458},
{0.9337113395424235,-0.3515514095396216,0.06778451785325582},
{0.8960081912368428,-0.4433798323318821,0.02415875654568122},
{0.4975607139471419,-0.25186318459923984,0.8300591979973114},
{0.5290697958650558,-0.006154843588788334,0.8485559904942666},
{0.4137053775331938,-0.09251709527398382,0.905697768398588},
{0.4871034260244937,-0.19278067412505498,0.8518015402892214},
{0.8705133118731143,-0.3210012142893988,0.3730479785180904},
{0.8473222606329982,-0.4690317650760502,0.24910678430229524},
{0.8421207963288285,-0.4381366614726574,-0.3144341429681162},
{0.8962452795977194,-0.24817097490209647,-0.36763509899756414},
{0.8922820908719767,-0.27607240118505105,0.35723479619579823},
{0.9758541683872738,-0.18311674686987542,-0.11906678402046615},
{0.7590556309178335,0.030774117565973143,0.6502980108073264},
{0.7389972271785158,-0.11966488719496958,0.6629957865590703},
{0.7347667172171002,-0.3268944713544172,0.5943550082803393},
{0.9387824803524022,-0.30044778685999635,0.16857811825477714},
{0.9253979713089657,-0.3619049741509206,0.11253170389748895},
{0.8381177263580013,-0.3891453840061781,-0.3822624057779928},
{0.9671171868669977,-0.17492429133902276,-0.18462350653696688},
{0.8819580996101991,-0.21250897993011822,0.42070160919709676},
{0.7191804625668052,-0.36442610674106735,0.5915852220836354},
{0.8334352969724265,-0.2856116848594883,0.47308727654863836},
{0.5441351695579711,-0.35100538768840844,0.7620447067356534},
{0.830658091293128,-0.5567702105757509,-0.0037507312208776636},
{0.7731729885493899,-0.3407483755441909,-0.5348776255757947},
{0.507659234426609,-0.37619225419845354,-0.7750880527930201},
{-0.5799978967382067,0.49847565045438474,0.6443015331995839},
{-0.871843708605794,0.4462410246341802,0.20188485752510618},
{-0.5854195722077551,0.8067469084044594,0.08027048184691486},
{-0.7039628527110057,0.6700281400081997,0.2355813948514085},
{-0.6007826778628785,0.7389339363226715,0.30501936287814707},
{-0.9205427484289112,0.3815355229133605,-0.08385519107470348},
{-0.8976671603741204,0.3909264205982871,0.203396663846963},
{-0.7750910717089005,0.5972443245574353,-0.2062354172810312},
{-0.8705365511168881,0.4528894613079463,-0.19250259480254234},
{-0.7145284894597564,0.6678391270006739,-0.20842249925892387},
{0.9997683739255977,0.01673676938848039,-0.013530670663458857},
{0.8500484285819098,-0.005224770267534055,0.5266786219708156},
{-0.6159974930507923,0.7874422489993371,-0.021949784645985945},
{-0.5389432920685653,0.8401195200723754,-0.061149978966952956},
{-0.5970805538778989,0.7397654205804742,-0.31022884246029653},
{-0.3731259019535997,0.8855630725583729,-0.27668593352804693},
{-0.7073892539623632,0.5143198156097544,-0.4848459246500062},
{-0.7338854351444118,0.6280634912501478,-0.25874392561289744},
{-0.567241423047594,0.6482419760211139,-0.507956207269074},
{-0.5787083952794423,0.48709039641931295,-0.6540944419188787},
{-0.6705346780542079,0.6028088336560157,-0.4324404647960385},
{-0.15681970897127273,0.9552663869139817,-0.25074630388197644},
{0.22397649503194728,0.9119306674668206,-0.3438269730645388},
{0.15707438581110103,0.9417826295454503,-0.2972761611843818},
{-0.5321466909332481,0.6964736402613773,-0.4813983462267604},
{0.9375309950136114,0.2552806864335231,-0.23636286620959945},
{-0.020796855669677105,0.9919273655569572,-0.12509033637131742},
{0.14866855728445766,0.8884429856230458,0.4342426986975906},
{0.9610444370489304,0.23379314023468056,0.14742576978436167},
{0.38370760092503464,0.6473392249626242,-0.6585745248771345},
{-0.5192662248584412,0.6786271482935148,-0.5194494983347993},
{-0.3501536097596069,0.8613921884901027,0.36796188278210057},
{-0.03492877880923391,0.7326693360543681,0.679687887501717},
{0.6648665630399724,0.627604732973112,-0.4050490741887496},
{0.27806248051106924,0.7507593048135359,-0.5992009038443845},
{-0.1736585370744716,0.9683628663949104,0.1792095742101606},
{-0.21765835991156596,0.9539524239786488,-0.20639673240113907},
{0.9917320282123792,-0.012434235485622714,0.1277222533689754},
{0.9833929586846608,0.10738924328931841,-0.14630734511697208},
{0.8897698501635589,0.34050896707146056,0.3039132394020454},
{0.5643870762181747,0.2822410361541947,0.7757623513090247},
{0.9962397861154431,-0.07807104764722278,0.037565943085746546},
{0.6772251046790403,0.17923910412368182,0.7136101885100876},
{0.5130906069351893,0.7491062629244568,0.41902009011768643},
{-0.013070049643058834,0.9595682208357348,0.28117255087307214},
{0.36229560470751304,0.8523801083532525,-0.37708095376631634},
{0.2329312830956443,0.8412421664097814,-0.48790842871341583},
{-0.22988146580647056,0.7619237814812214,-0.6054970378887287},
{-0.3499245137194984,0.9263401860896646,-0.1394514049177641},
{0.1001920071019237,0.9862536222919244,0.13139769491488887},
{0.21287405954735295,0.8611999877490696,0.4615400479620727},
{-0.005114998288871003,0.41633203852180795,-0.909198256978521},
{-0.0005795760584357155,0.883404230386596,-0.468611384653274},
{-0.28262956274651024,0.42507042580495213,-0.8599044501383355},
{0.10400821173325456,0.9360317576760613,0.33619464676569993},
{0.24230340448826418,0.964530902127413,-0.10473394394691397},
{0.19722231817625777,0.9800887878506425,-0.0230070672325084},
{0.08143943135542318,0.7116598115160688,-0.6977878844558844},
{-0.06792106620982474,0.9196157417857465,-0.38690259268292804},
{0.09023836812242873,0.9953037341402573,0.035035891954696925},
{-0.038046961307602795,0.8532211558211086,-0.5201596754791254},
{0.3378961731533316,0.8282715745103816,-0.446981403445856},
{0.3312297424774159,0.9200473483831632,0.20928386089580614},
{-0.07961454847293044,0.9231740775311051,-0.37604673412495504},
{0.3412454647747827,0.8429507528521663,-0.41591532916761886},
{0.22647104394470552,0.9484842276940543,-0.2215593285560525},
{0.10789883517107045,0.9548728500852064,-0.2767231134887024},
{-0.37012435229864726,0.8743765671648022,0.3138050073351333},
{0.2629657674380417,0.8618848088309907,0.43359379776709017},
{0.47974656118763553,0.7749141076629228,0.41152322264194785},
{0.7633414306394112,0.525509181424529,0.375699295325262},
{0.4605839711943781,0.8795876531650406,0.11911324812308834},
{-0.036059416277946295,0.7265015988301083,0.6862180013632624},
{0.13860935347404746,0.689687077097787,0.7107173719656905},
{0.12177773488945705,0.754210825640578,0.6452412058848619},
{0.6498718728228564,0.5304169833563052,0.5443568431469472},
{0.44028789030866217,0.7847870445323425,0.4361832967706794},
{-0.19767138128704917,0.9009452489757322,0.38629481405802707},
{-0.010714483836340166,0.9993714774945721,-0.033791268198116654},
{-0.16110661574257454,0.5171303688220454,0.8406074232398555},
{0.14225436303896283,0.4408216031788616,0.8862505347627143},
{0.3278789928659196,0.422072448190899,0.8451924127175843},
{0.4510070065707001,0.4793927117375957,0.7528448100086834},
{0.8467237644152741,0.34005188947978293,0.4091742651189796},
{0.3618100438568576,0.814738621129164,0.4530943294777008},
{0.05928067343107229,0.6224504869856327,0.7804109129227417},
{0.3880285473291034,0.5814527965685015,0.7150849542679069},
{0.8978031263053735,0.0032637648001635484,0.44038493870207096},
{0.5241000447021019,0.06891191108277807,0.8488641184866833},
{0.5492180482314869,0.722230418603209,-0.42040784714492385},
{0.05121720099669624,0.9986487427568845,0.008802665059968604},
{-0.10547088853717301,0.9629564555779497,-0.24817485032116265},
{-0.1268962062436509,0.9895051069406009,-0.06911581714368145},
{-0.3237754156728137,0.9303124382965626,-0.17230277814533623},
{0.08682077997453266,0.9911243941384901,-0.10067068842629633},
{0.15271993308805396,0.9772641415060334,0.14707623793140812},
{0.04292325581892938,0.9986980596894062,0.027564101337032364},
{0.6593721553937759,0.7297816939202824,-0.18068491887871985},
{0.10447974084440152,0.9639830058239947,-0.24458280445612435},
{0.22493866312850413,0.9532865411362044,-0.20161192504049208},
{0.2412166952765152,0.9656917891047095,-0.09619706011943528},
{0.07870785206443662,0.9968237069648691,-0.012147891019422416},
{0.3487259887894676,0.8718122655935845,-0.3439964510040609},
{-0.01946953748366368,0.9526248113954973,-0.3035241437247872},
{0.3666232118298046,0.9212942909000312,0.12963120805811776},
{0.41663475453977356,0.8895850037872247,-0.18722714105189506},
{0.07877993853826014,0.8592014177590842,-0.5055359977337791},
{0.01892235865557929,0.5248626214142079,-0.850976599552018},
{-0.019166321394342076,0.9637550050721824,-0.2660994970354635},
{0.1957619339421847,0.8197162251612282,-0.5382774149327114},
{0.34229779884684425,0.9036974243644988,-0.25722204824154615},
{0.5337667220022739,0.8400137272711021,-0.09731405077920388},
{0.05696771847817809,0.8650147307838906,-0.4985019504257375},
{0.16927288192186596,0.8609441600765169,-0.47971016736776295},
{0.08150364904287487,0.5355541552152827,-0.8405586844619125},
{0.15647077339304502,0.5745078587890912,-0.8034037697592388},
{0.11702842555573045,0.6622517802168641,-0.7400857566603622}
};


// face array: 24kb.
const uint16_t skull_1_face[12406] PROGMEM = {
52, // chain 0
0,0, 1,1, 2,2, 
3,3, 32772,4, 32773,5, 32774,6, 32775,7, 32769,1, 8,8, 32777,9, 32778,10, 32779,11, 32780,12, 32781,13, 32768,0, 14,14, 32783,15, 32784,16, 
32771,3, 17,17, 32786,18, 32787,19, 32788,20, 32789,21, 32790,22, 32772,4, 23,23, 32792,24, 32773,5, 25,25, 32794,26, 32795,27, 32796,28, 32797,29, 
32774,6, 30,30, 32799,31, 32800,32, 32775,7, 8,8, 33,33, 32802,34, 32803,35, 32777,9, 36,36, 32805,37, 32778,10, 38,38, 32807,39, 32808,40, 
32809,41, 32810,42, 32779,11, 
7, // chain 1
43,43, 23,23, 44,44, 
45,45, 32814,46, 32815,47, 32793,25, 32792,24, 32791,23, 
15, // chain 2
48,48, 46,46, 47,47, 
49,49, 32818,50, 32793,25, 26,26, 51,51, 32820,52, 32821,53, 32822,54, 32795,27, 55,55, 32824,56, 32798,30, 32796,28, 29,29, 
17, // chain 3
57,57, 46,46, 48,48, 
58,58, 32817,49, 59,59, 32828,60, 32829,61, 32818,50, 51,51, 62,62, 32831,63, 32832,64, 32820,52, 65,65, 32821,53, 66,66, 32823,55, 32822,54, 
12, // chain 4
67,67, 46,46, 57,57, 
68,68, 32837,69, 32826,58, 59,59, 70,70, 32839,71, 32828,60, 72,72, 32841,73, 32830,62, 32829,61, 
43, // chain 5
74,74, 46,46, 67,67, 
75,75, 32844,76, 32845,77, 32846,78, 32836,68, 79,79, 32848,80, 32837,69, 81,81, 32850,82, 32838,70, 83,83, 32852,84, 32839,71, 85,85, 32840,72, 
86,86, 32855,87, 32841,73, 88,88, 32857,89, 32858,90, 32830,62, 63,63, 91,91, 32860,92, 32861,93, 32832,64, 65,65, 94,94, 32863,95, 32864,96, 
32834,66, 97,97, 32823,55, 98,98, 32867,99, 32868,100, 32824,56, 101,101, 32799,31, 32798,30, 
32, // chain 6
102,102, 46,46, 74,74, 
103,103, 32872,104, 32873,105, 32843,75, 106,106, 32875,107, 32876,108, 32877,109, 32844,76, 110,110, 32845,77, 32879,111, 32880,112, 32845,77, 113,113, 32882,114, 
32883,115, 32884,116, 32885,117, 32879,111, 112,112, 118,118, 32887,119, 32888,120, 32881,113, 119,119, 32889,121, 32882,114, 118,118, 32884,116, 32883,115, 
95, // chain 7
122,122, 46,46, 102,102, 
123,123, 32892,124, 32893,125, 32894,126, 32895,127, 32871,103, 104,104, 128,128, 32897,129, 32898,130, 32873,105, 106,106, 107,107, 131,131, 32900,132, 32876,108, 
133,133, 32902,134, 32877,109, 135,135, 32878,110, 136,136, 32905,137, 32906,138, 32907,139, 32908,140, 141,141, 32910,142, 32845,77, 143,143, 32912,144, 32846,78, 
145,145, 32914,146, 32847,79, 147,147, 32916,148, 32848,80, 149,149, 32849,81, 150,150, 32850,82, 83,83, 151,151, 32920,152, 32852,84, 153,153, 32853,85, 
154,154, 32854,86, 155,155, 32924,156, 32855,87, 88,88, 157,157, 32926,158, 32927,159, 32928,160, 32929,161, 32857,89, 162,162, 32858,90, 163,163, 32859,91, 
164,164, 32933,165, 32860,92, 166,166, 32861,93, 167,167, 32862,94, 168,168, 32863,95, 169,169, 32938,170, 32939,171, 32864,96, 172,172, 32865,97, 173,173, 
32866,98, 174,174, 32943,175, 32944,176, 32867,99, 177,177, 32868,100, 101,101, 178,178, 32947,179, 32799,31, 180,180, 32801,33, 32800,32, 
3, // chain 8
45,45, 46,46, 122,122, 
181,181, 32891,123, 
34, // chain 9
161,161, 162,162, 163,163, 
182,182, 32932,164, 183,183, 32952,184, 32933,165, 185,185, 32934,166, 186,186, 32955,187, 32935,167, 188,188, 32936,168, 189,189, 32937,169, 190,190, 32938,170, 
191,191, 32960,192, 32939,171, 193,193, 32940,172, 194,194, 32941,173, 195,195, 32942,174, 196,196, 32965,197, 32943,175, 198,198, 32967,199, 32944,176, 178,178, 
32945,177, 
30, // chain 10
160,160, 161,161, 182,182, 
200,200, 32951,183, 201,201, 32970,202, 32952,184, 203,203, 32953,185, 204,204, 32954,186, 205,205, 32974,206, 32975,207, 32955,187, 208,208, 32956,188, 189,189, 
209,209, 32978,210, 32979,211, 32958,190, 212,212, 32959,191, 213,213, 32982,214, 32960,192, 193,193, 196,196, 32962,194, 195,195, 
6, // chain 11
205,205, 206,206, 215,215, 
32984,216, 32975,207, 217,217, 32977,209, 32976,208, 
22, // chain 12
215,215, 216,216, 218,218, 
32987,219, 32988,220, 32985,217, 221,221, 32990,222, 32991,223, 32992,224, 32977,209, 210,210, 225,225, 32994,226, 32979,211, 227,227, 32980,212, 228,228, 32981,213, 
229,229, 32998,230, 32982,214, 197,197, 32964,196, 
17, // chain 13
223,223, 224,224, 225,225, 
231,231, 33000,232, 32994,226, 233,233, 32995,227, 234,234, 32996,228, 235,235, 33004,236, 32997,229, 237,237, 33006,238, 33007,239, 32998,230, 198,198, 32965,197, 
7, // chain 14
222,222, 223,223, 240,240, 
32999,231, 241,241, 33010,242, 33000,232, 234,234, 33001,233, 
48, // chain 15
222,222, 240,240, 243,243, 
33012,244, 33013,245, 33009,241, 246,246, 33010,242, 247,247, 33002,234, 248,248, 33003,235, 249,249, 33018,250, 33004,236, 251,251, 33005,237, 252,252, 33021,253, 
33006,238, 254,254, 33007,239, 255,255, 32966,198, 199,199, 178,178, 256,256, 33025,257, 32947,179, 180,180, 258,258, 33027,259, 32801,33, 34,34, 35,35, 
260,260, 33029,261, 32804,36, 262,262, 33031,263, 32805,37, 264,264, 33033,265, 33034,266, 33035,267, 32806,38, 268,268, 33037,269, 33038,270, 32807,39, 
53, // chain 16
243,243, 244,244, 271,271, 
33040,272, 33041,273, 33013,245, 274,274, 33014,246, 275,275, 33015,247, 248,248, 274,274, 33044,276, 33017,249, 250,250, 273,273, 33019,251, 272,272, 33020,252, 
277,277, 33046,278, 33021,253, 279,279, 33022,254, 280,280, 33023,255, 281,281, 33024,256, 257,257, 282,282, 33051,283, 33026,258, 284,284, 33053,285, 33027,259, 
286,286, 33028,260, 287,287, 33029,261, 288,288, 33030,262, 289,289, 33058,290, 33059,291, 33031,263, 292,292, 33032,264, 293,293, 33033,265, 294,294, 33034,266, 
295,295, 33064,296, 33065,297, 33035,267, 
23, // chain 17
284,284, 285,285, 298,298, 
33054,286, 299,299, 33068,300, 33055,287, 301,301, 33056,288, 302,302, 33057,289, 303,303, 33072,304, 33058,290, 305,305, 33074,306, 33059,291, 307,307, 33060,292, 
308,308, 33061,293, 309,309, 33062,294, 310,310, 33063,295, 
34, // chain 18
311,311, 282,282, 283,283, 
312,312, 33081,313, 33082,314, 33052,284, 298,298, 315,315, 33067,299, 316,316, 33085,317, 33068,300, 301,301, 318,318, 33087,319, 33070,302, 320,320, 33071,303, 
321,321, 33090,322, 33072,304, 305,305, 323,323, 33092,324, 33074,306, 325,325, 33075,307, 326,326, 33076,308, 327,327, 33077,309, 328,328, 33097,329, 33078,310, 
330,330, 
27, // chain 19
272,272, 277,277, 331,331, 
33100,332, 33101,333, 33046,278, 334,334, 33103,335, 33104,336, 33047,279, 337,337, 33048,280, 281,281, 338,338, 33050,282, 339,339, 33108,340, 33079,311, 341,341, 
33110,342, 33080,312, 343,343, 33112,344, 33113,345, 33081,313, 346,346, 33115,347, 33083,315, 33082,314, 
39, // chain 20
271,271, 272,272, 331,331, 
348,348, 33100,332, 349,349, 33118,350, 33101,333, 351,351, 33102,334, 352,352, 33121,353, 33103,335, 354,354, 33104,336, 355,355, 33124,356, 33105,337, 357,357, 
33106,338, 339,339, 340,340, 358,358, 33109,341, 359,359, 33128,360, 33110,342, 343,343, 344,344, 361,361, 33130,362, 33131,363, 33113,345, 364,364, 33114,346, 
361,361, 33133,365, 33115,347, 366,366, 33084,316, 33083,315, 
1, // chain 21
273,273, 274,274, 276,276, 
27, // chain 22
317,317, 318,318, 367,367, 
33136,368, 33137,369, 33087,319, 370,370, 33088,320, 371,371, 33089,321, 372,372, 33141,373, 33090,322, 323,323, 374,374, 33143,375, 33092,324, 376,376, 33093,325, 
377,377, 33094,326, 378,378, 33095,327, 379,379, 33096,328, 380,380, 33149,381, 33150,382, 33097,329, 
35, // chain 23
367,367, 368,368, 356,356, 
33123,355, 33151,383, 33137,369, 384,384, 33138,370, 385,385, 33139,371, 386,386, 33140,372, 387,387, 33156,388, 33141,373, 374,374, 389,389, 33143,375, 390,390, 
33159,391, 33144,376, 392,392, 33145,377, 393,393, 33146,378, 394,394, 33147,379, 395,395, 33148,380, 396,396, 33165,397, 33149,381, 398,398, 33150,382, 399,399, 
33168,400, 33169,401, 
4, // chain 24
316,316, 317,317, 367,367, 
358,358, 33125,357, 33124,356, 
43, // chain 25
355,355, 383,383, 402,402, 
33171,403, 33172,404, 33173,405, 33152,384, 406,406, 33153,385, 407,407, 33154,386, 408,408, 33155,387, 409,409, 33178,410, 33156,388, 389,389, 411,411, 33180,412, 
33158,390, 411,411, 33181,413, 33182,414, 33159,391, 415,415, 33160,392, 416,416, 33161,393, 417,417, 33162,394, 418,418, 33163,395, 419,419, 33164,396, 151,151, 
33188,420, 33165,397, 421,421, 33166,398, 422,422, 33191,423, 33167,399, 424,424, 33193,425, 33168,400, 
35, // chain 26
355,355, 402,402, 426,426, 
33171,403, 427,427, 33196,428, 33197,429, 33198,430, 33199,431, 33172,404, 432,432, 33201,433, 33173,405, 406,406, 434,434, 33175,407, 435,435, 33176,408, 436,436, 
33177,409, 437,437, 33178,410, 411,411, 438,438, 33181,413, 439,439, 33182,414, 440,440, 33183,415, 416,416, 441,441, 33185,417, 442,442, 33186,418, 419,419, 
152,152, 32919,151, 
39, // chain 27
355,355, 426,426, 443,443, 
33212,444, 33213,445, 33195,427, 446,446, 33196,428, 447,447, 33216,448, 33217,449, 33197,429, 430,430, 450,450, 33219,451, 33220,452, 33199,431, 432,432, 453,453, 
33222,454, 33201,433, 434,434, 455,455, 33203,435, 456,456, 33204,436, 457,457, 33205,437, 438,438, 458,458, 33227,459, 33228,460, 33207,439, 461,461, 33208,440, 
462,462, 33209,441, 463,463, 33210,442, 153,153, 32920,152, 
48, // chain 28
354,354, 355,355, 443,443, 
353,353, 33212,444, 464,464, 33233,465, 33213,445, 466,466, 33214,446, 467,467, 33215,447, 468,468, 33237,469, 33216,448, 470,470, 33239,471, 33217,449, 472,472, 
33218,450, 473,473, 33219,451, 474,474, 33243,475, 33220,452, 453,453, 476,476, 33245,477, 33222,454, 455,455, 478,478, 33224,456, 479,479, 33225,457, 458,458, 
480,480, 33249,481, 33250,482, 33227,459, 483,483, 33252,484, 33228,460, 485,485, 33229,461, 486,486, 33230,462, 487,487, 33231,463, 154,154, 32921,153, 
6, // chain 29
488,488, 363,363, 489,489, 
490,490, 33259,491, 33260,492, 33132,364, 33131,363, 
5, // chain 30
366,366, 316,316, 358,358, 
359,359, 360,360, 365,365, 33129,361, 
9, // chain 31
492,492, 364,364, 361,361, 
493,493, 33130,362, 494,494, 33263,495, 33264,496, 33265,497, 33256,488, 33131,363, 
6, // chain 32
498,498, 470,470, 499,499, 
500,500, 33269,501, 33270,502, 33239,471, 33238,470, 
12, // chain 33
503,503, 498,498, 500,500, 
504,504, 33273,505, 33274,506, 33275,507, 33269,501, 508,508, 33277,509, 33270,502, 510,510, 33240,472, 33239,471, 
11, // chain 34
494,494, 495,495, 496,496, 
511,511, 33272,504, 33280,512, 33281,513, 33282,514, 33265,497, 515,515, 33284,516, 33258,490, 33256,488, 
21, // chain 35
517,517, 504,504, 512,512, 
518,518, 33287,519, 33288,520, 33289,521, 33281,513, 522,522, 33291,523, 33282,514, 515,515, 524,524, 33293,525, 33284,516, 526,526, 33295,527, 33258,490, 491,491, 
528,528, 33297,529, 33261,493, 33260,492, 
8, // chain 36
530,530, 504,504, 517,517, 
531,531, 33300,532, 33286,518, 533,533, 33302,534, 33288,520, 33287,519, 
42, // chain 37
503,503, 504,504, 530,530, 
535,535, 33299,531, 536,536, 33305,537, 33300,532, 538,538, 33301,533, 539,539, 33308,540, 33302,534, 541,541, 33310,542, 33311,543, 33312,544, 33288,520, 545,545, 
33314,546, 33289,521, 522,522, 547,547, 33316,548, 33317,549, 33318,550, 33291,523, 524,524, 551,551, 33320,552, 33293,525, 553,553, 33294,526, 554,554, 33323,555, 
33295,527, 528,528, 556,556, 33325,557, 33297,529, 506,506, 33261,493, 511,511, 33262,494, 
2, // chain 38
511,511, 504,504, 505,505, 
506,506, 
36, // chain 39
544,544, 545,545, 558,558, 
33314,546, 547,547, 559,559, 33316,548, 560,560, 33329,561, 33317,549, 562,562, 33331,563, 33318,550, 551,551, 564,564, 33320,552, 565,565, 33321,553, 566,566, 
33322,554, 567,567, 33323,555, 556,556, 568,568, 33337,569, 33325,557, 570,570, 33274,506, 507,507, 508,508, 571,571, 33340,572, 33277,509, 573,573, 33278,510, 
574,574, 33241,473, 33240,472, 
31, // chain 40
544,544, 558,558, 543,543, 
33343,575, 33344,576, 33345,577, 33327,559, 560,560, 578,578, 33347,579, 33329,561, 580,580, 33330,562, 581,581, 33350,582, 33331,563, 583,583, 33352,584, 33332,564, 
585,585, 33354,586, 33333,565, 587,587, 33334,566, 588,588, 33357,589, 33335,567, 568,568, 590,590, 33359,591, 33337,569, 571,571, 33338,570, 
12, // chain 41
541,541, 542,542, 592,592, 
33361,593, 33362,594, 33363,595, 33364,596, 33365,597, 33311,543, 575,575, 598,598, 33344,576, 578,578, 33345,577, 
42, // chain 42
541,541, 592,592, 599,599, 
600,600, 33369,601, 33370,602, 33371,603, 33372,604, 33373,605, 33374,606, 33360,592, 593,593, 605,605, 33375,607, 33376,608, 33362,594, 609,609, 33378,610, 33363,595, 
611,611, 33380,612, 33364,596, 613,613, 33382,614, 33365,597, 598,598, 615,615, 33384,616, 33346,578, 579,579, 580,580, 617,617, 33386,618, 33387,619, 33388,620, 
33389,621, 33349,581, 622,622, 33350,582, 623,623, 33392,624, 33353,585, 33351,583, 584,584, 
6, // chain 43
625,625, 610,610, 626,626, 
627,627, 33396,628, 33380,612, 33379,611, 33378,610, 
17, // chain 44
629,629, 625,625, 627,627, 
630,630, 33399,631, 33396,628, 632,632, 33401,633, 33380,612, 634,634, 33381,613, 635,635, 33404,636, 33382,614, 615,615, 637,637, 33384,616, 618,618, 33385,617, 
41, // chain 45
638,638, 630,630, 631,631, 
632,632, 639,639, 33408,640, 33401,633, 641,641, 33410,642, 33402,634, 635,635, 643,643, 33412,644, 33404,636, 637,637, 645,645, 33414,646, 33415,647, 33386,618, 
648,648, 33387,619, 649,649, 33418,650, 33419,651, 33388,620, 652,652, 33421,653, 33422,654, 33389,621, 655,655, 33390,622, 656,656, 33391,623, 657,657, 33426,658, 
33392,624, 659,659, 33428,660, 33429,661, 33430,662, 33353,585, 587,587, 33354,586, 
49, // chain 46
663,663, 664,664, 603,603, 
604,604, 665,665, 33434,666, 33373,605, 607,607, 667,667, 33436,668, 33376,608, 669,669, 33377,609, 670,670, 33439,671, 33378,610, 625,625, 672,672, 33397,629, 
630,630, 673,673, 33406,638, 674,674, 33407,639, 675,675, 33444,676, 33408,640, 641,641, 677,677, 33446,678, 33447,679, 33410,642, 643,643, 680,680, 33449,681, 
33412,644, 645,645, 682,682, 33451,683, 33452,684, 33421,653, 33414,646, 685,685, 33415,647, 686,686, 33416,648, 649,649, 685,685, 33418,650, 652,652, 33419,651, 
49, // chain 47
603,603, 664,664, 602,602, 
33455,687, 33456,688, 33457,689, 33458,690, 33431,663, 691,691, 33433,665, 692,692, 33434,666, 667,667, 693,693, 33462,694, 33436,668, 695,695, 33437,669, 696,696, 
33438,670, 697,697, 33466,698, 33439,671, 672,672, 699,699, 33441,673, 700,700, 33469,701, 33442,674, 702,702, 33443,675, 703,703, 33472,704, 33444,676, 677,677, 
705,705, 33446,678, 706,706, 33475,707, 33447,679, 680,680, 708,708, 33477,709, 33449,681, 682,682, 710,710, 33451,683, 711,711, 33452,684, 654,654, 33421,653, 
6, // chain 48
712,712, 689,689, 713,713, 
714,714, 33483,715, 33484,716, 33458,690, 33457,689, 
10, // chain 49
717,717, 712,712, 714,714, 
718,718, 33487,719, 33483,715, 720,720, 33489,721, 33484,716, 722,722, 33459,691, 33458,690, 
14, // chain 50
723,723, 717,717, 718,718, 
724,724, 33493,725, 33487,719, 726,726, 33488,720, 727,727, 33496,728, 33489,721, 729,729, 33490,722, 693,693, 33460,692, 33459,691, 
51, // chain 51
730,730, 723,723, 724,724, 
731,731, 33493,725, 732,732, 33494,726, 733,733, 33495,727, 734,734, 33503,735, 33496,728, 736,736, 33497,729, 737,737, 33461,693, 694,694, 738,738, 33463,695, 
739,739, 33464,696, 740,740, 33465,697, 741,741, 33510,742, 33466,698, 699,699, 743,743, 33468,700, 744,744, 33469,701, 745,745, 33470,702, 703,703, 746,746, 
33515,747, 33472,704, 705,705, 748,748, 33474,706, 749,749, 33518,750, 33475,707, 708,708, 751,751, 33477,709, 710,710, 752,752, 33521,753, 33522,754, 33479,711, 
655,655, 33422,654, 
49, // chain 52
731,731, 755,755, 756,756, 
730,730, 33525,757, 33526,758, 33527,759, 33523,755, 760,760, 33529,761, 33530,762, 33499,731, 732,732, 763,763, 33501,733, 764,764, 33502,734, 765,765, 33534,766, 
33535,767, 33503,735, 768,768, 33504,736, 769,769, 33505,737, 738,738, 770,770, 33507,739, 771,771, 33508,740, 772,772, 33509,741, 773,773, 33542,774, 33510,742, 
743,743, 775,775, 33512,744, 776,776, 33513,745, 746,746, 777,777, 33546,778, 33515,747, 748,748, 779,779, 33517,749, 780,780, 33549,781, 33519,751, 33518,750, 
46, // chain 53
759,759, 760,760, 782,782, 
33551,783, 33552,784, 33529,761, 785,785, 33554,786, 33530,762, 763,763, 787,787, 33532,764, 788,788, 33533,765, 789,789, 33534,766, 790,790, 33559,791, 33535,767, 
792,792, 33561,793, 33536,768, 769,769, 770,770, 794,794, 33539,771, 795,795, 33540,772, 796,796, 33541,773, 797,797, 33566,798, 33542,774, 775,775, 799,799, 
33544,776, 777,777, 800,800, 33569,801, 33546,778, 779,779, 780,780, 802,802, 33571,803, 33572,804, 33549,781, 752,752, 33519,751, 
24, // chain 54
782,782, 783,783, 805,805, 
33574,806, 33575,807, 33552,784, 808,808, 33553,785, 809,809, 33578,810, 33554,786, 787,787, 811,811, 33556,788, 812,812, 33557,789, 813,813, 33558,790, 814,814, 
33583,815, 33559,791, 816,816, 33560,792, 817,817, 33562,794, 33561,793, 
29, // chain 55
805,805, 806,806, 818,818, 
33587,819, 33588,820, 33589,821, 33575,807, 822,822, 33576,808, 823,823, 33577,809, 824,824, 33593,825, 33578,810, 811,811, 826,826, 33580,812, 827,827, 33581,813, 
828,828, 33582,814, 829,829, 33598,830, 33583,815, 831,831, 33584,816, 832,832, 33585,817, 833,833, 33563,795, 33562,794, 
32, // chain 56
834,834, 835,835, 820,820, 
836,836, 33589,821, 837,837, 33590,822, 838,838, 33591,823, 839,839, 33592,824, 840,840, 33609,841, 33593,825, 826,826, 842,842, 33595,827, 843,843, 33596,828, 
844,844, 33597,829, 845,845, 33614,846, 33598,830, 847,847, 33599,831, 848,848, 33600,832, 849,849, 33601,833, 850,850, 33619,851, 33564,796, 33563,795, 
46, // chain 57
820,820, 835,835, 819,819, 
33620,852, 33621,853, 33622,854, 33623,855, 33624,856, 33602,834, 857,857, 33626,858, 33604,836, 859,859, 33605,837, 860,860, 33629,861, 33630,862, 33631,863, 33606,838, 
864,864, 33607,839, 865,865, 33608,840, 866,866, 33635,867, 33609,841, 842,842, 868,868, 33611,843, 869,869, 33612,844, 870,870, 33613,845, 871,871, 33614,846, 
872,872, 33615,847, 873,873, 33616,848, 874,874, 33617,849, 850,850, 875,875, 33644,876, 33619,851, 877,877, 33565,797, 33564,796, 
2, // chain 58
878,878, 879,879, 128,128, 
129,129, 
15, // chain 59
880,880, 881,881, 882,882, 
883,883, 32813,45, 33652,884, 885,885, 43,43, 33654,886, 887,887, 23,23, 33656,888, 889,889, 890,890, 891,891, 22,22, 32789,21, 
2, // chain 60
892,892, 883,883, 45,45, 
181,181, 
1, // chain 61
893,893, 124,124, 125,125, 
54, // chain 62
129,129, 130,130, 894,894, 
33663,895, 33664,896, 32899,131, 132,132, 897,897, 33666,898, 32901,133, 899,899, 33668,900, 33669,901, 32902,134, 902,902, 33671,903, 33672,904, 33673,905, 32903,135, 
906,906, 32904,136, 907,907, 33676,908, 32905,137, 909,909, 33678,910, 32906,138, 911,911, 33680,912, 33681,913, 32907,139, 914,914, 32909,141, 915,915, 33684,916, 
33685,917, 33686,918, 32910,142, 143,143, 919,919, 33688,920, 32912,144, 921,921, 32913,145, 146,146, 922,922, 33691,923, 32915,147, 924,924, 33190,422, 32916,148, 
421,421, 32917,149, 420,420, 32918,150, 151,151, 
11, // chain 63
925,925, 926,926, 927,927, 
33696,928, 33697,929, 33698,930, 33699,931, 932,932, 33701,933, 33702,934, 935,935, 33704,936, 33705,937, 
28, // chain 64
938,938, 939,939, 940,940, 
941,941, 33710,942, 33711,943, 944,944, 928,928, 945,945, 33697,929, 946,946, 33715,947, 33716,948, 33698,930, 932,932, 949,949, 33718,950, 33719,951, 33720,952, 
33701,933, 935,935, 953,953, 33722,954, 33723,955, 956,956, 33725,957, 958,958, 33727,959, 960,960, 33729,961, 
13, // chain 65
962,962, 963,963, 964,964, 
965,965, 966,966, 33735,967, 33736,968, 969,969, 33738,970, 33706,938, 941,941, 971,971, 33715,947, 33713,945, 33710,942, 
7, // chain 66
972,972, 973,973, 974,974, 
33730,962, 966,966, 975,975, 33744,976, 33737,969, 33735,967, 
7, // chain 67
977,977, 978,978, 979,979, 
424,424, 33748,980, 33749,981, 33750,982, 33751,983, 33746,978, 
10, // chain 68
424,424, 980,980, 984,984, 
33753,985, 33754,986, 33749,981, 987,987, 33756,988, 33750,982, 989,989, 33758,990, 33751,983, 
4, // chain 69
991,991, 992,992, 989,989, 
993,993, 33762,994, 33758,990, 
7, // chain 70
989,989, 992,992, 988,988, 
33763,995, 33764,996, 33759,991, 997,997, 33766,998, 33761,993, 
4, // chain 71
999,999, 1000,1000, 997,997, 
1001,1001, 33770,1002, 33766,998, 
8, // chain 72
997,997, 1000,1000, 996,996, 
33771,1003, 33772,1004, 33773,1005, 33767,999, 1006,1006, 33775,1007, 33769,1001, 
3, // chain 73
1008,1008, 1009,1009, 1006,1006, 
1010,1010, 33775,1007, 
8, // chain 74
1006,1006, 1009,1009, 1005,1005, 
33779,1011, 33780,1012, 33781,1013, 33776,1008, 1014,1014, 33783,1015, 33778,1010, 
4, // chain 75
1016,1016, 1017,1017, 1014,1014, 
1015,1015, 1018,1018, 33787,1019, 
16, // chain 76
1014,1014, 1017,1017, 1013,1013, 
33788,1020, 33789,1021, 33784,1016, 1022,1022, 33786,1018, 1023,1023, 1024,1024, 1025,1025, 33794,1026, 1027,1027, 33796,1028, 975,975, 33797,1029, 974,974, 33740,972, 
29, // chain 77
1022,1022, 1025,1025, 1030,1030, 
33799,1031, 33795,1027, 1032,1032, 33743,975, 1033,1033, 33744,976, 1034,1034, 33803,1035, 33737,969, 970,970, 971,971, 1036,1036, 33805,1037, 33715,947, 1038,1038, 33716,948, 
949,949, 1039,1039, 33808,1040, 33718,950, 1041,1041, 33719,951, 1042,1042, 33720,952, 953,953, 958,958, 33722,954, 956,956, 
11, // chain 78
1022,1022, 1030,1030, 1021,1021, 
33811,1043, 33799,1031, 1044,1044, 33800,1032, 1033,1033, 1045,1045, 33802,1034, 1046,1046, 33804,1036, 33803,1035, 
6, // chain 79
985,985, 986,986, 1047,1047, 
33816,1048, 33755,987, 1049,1049, 33763,995, 33756,988, 
11, // chain 80
985,985, 1047,1047, 921,921, 
33688,920, 33818,1050, 33816,1048, 1051,1051, 33817,1049, 1052,1052, 33821,1053, 33763,995, 1003,1003, 33764,996, 
4, // chain 81
1003,1003, 1004,1004, 1054,1054, 
33823,1055, 33779,1011, 33773,1005, 
10, // chain 82
1003,1003, 1054,1054, 1053,1053, 
33820,1052, 33824,1056, 33823,1055, 1057,1057, 33779,1011, 1012,1012, 1058,1058, 33788,1020, 33781,1013, 
2, // chain 83
1043,1043, 1059,1059, 1020,1020, 
1021,1021, 
28, // chain 84
1020,1020, 1059,1059, 1058,1058, 
33828,1060, 33829,1061, 33811,1043, 1044,1044, 1062,1062, 33813,1045, 1063,1063, 33814,1046, 1064,1064, 33833,1065, 33804,1036, 1037,1037, 1038,1038, 1039,1039, 1066,1066, 33835,1067, 
33808,1040, 1068,1068, 33837,1069, 33809,1041, 1070,1070, 33810,1042, 1071,1071, 33840,1072, 33726,958, 1073,1073, 33728,960, 
22, // chain 85
1065,1065, 1066,1066, 1064,1064, 
33842,1074, 33843,1075, 33835,1067, 1076,1076, 33836,1068, 1077,1077, 33837,1069, 1078,1078, 33847,1079, 33848,1080, 33838,1070, 1071,1071, 1081,1081, 33850,1082, 33840,1072, 1073,1073, 
1083,1083, 1084,1084, 33853,1085, 33854,1086, 33855,1087, 
11, // chain 86
920,920, 1050,1050, 919,919, 
33856,1088, 33819,1051, 1089,1089, 33820,1052, 1090,1090, 33824,1056, 1091,1091, 33828,1060, 33825,1057, 1058,1058, 
3, // chain 87
1092,1092, 1093,1093, 1060,1060, 
1062,1062, 33829,1061, 
8, // chain 88
1060,1060, 1093,1093, 1091,1091, 
33862,1094, 33844,1076, 33863,1095, 33860,1092, 1074,1074, 33831,1063, 33830,1062, 
3, // chain 89
1074,1074, 1075,1075, 1096,1096, 
33863,1095, 33844,1076, 
1, // chain 90
1074,1074, 1096,1096, 1095,1095, 
1, // chain 91
1063,1063, 1064,1064, 1074,1074, 
1, // chain 92
977,977, 424,424, 1097,1097, 
12, // chain 93
473,473, 474,474, 574,574, 
33866,1098, 33867,1099, 33243,475, 476,476, 1100,1100, 33869,1101, 33245,477, 478,478, 1102,1102, 33248,480, 33247,479, 
7, // chain 94
924,924, 422,422, 423,423, 
424,424, 984,984, 923,923, 33753,985, 922,922, 33689,921, 
13, // chain 95
571,571, 572,572, 1103,1103, 
33872,1104, 33341,573, 1105,1105, 33342,574, 1098,1098, 1106,1106, 33875,1107, 33867,1099, 1100,1100, 1108,1108, 33870,1102, 33869,1101, 
32, // chain 96
571,571, 1103,1103, 591,591, 
33877,1109, 33878,1110, 33872,1104, 1111,1111, 33873,1105, 1106,1106, 1112,1112, 33881,1113, 33875,1107, 1108,1108, 1114,1114, 33870,1102, 1115,1115, 33248,480, 481,481, 1116,1116, 
33250,482, 1117,1117, 33251,483, 1118,1118, 33887,1119, 33888,1120, 33252,484, 1121,1121, 33253,485, 1122,1122, 33254,486, 1123,1123, 33255,487, 155,155, 32922,154, 
84, // chain 97
591,591, 1109,1109, 590,590, 
33892,1124, 33893,1125, 33878,1110, 1126,1126, 33879,1111, 1112,1112, 1127,1127, 33896,1128, 33881,1113, 1114,1114, 1129,1129, 33898,1130, 33883,1115, 1116,1116, 1131,1131, 33885,1117, 
1118,1118, 1132,1132, 33901,1133, 33902,1134, 33887,1119, 1120,1120, 1135,1135, 33904,1136, 33889,1121, 1137,1137, 33890,1122, 1138,1138, 33891,1123, 1139,1139, 32923,155, 156,156, 
157,157, 1140,1140, 33909,1141, 32926,158, 114,114, 32927,159, 1142,1142, 33911,1143, 32928,160, 1144,1144, 32968,200, 1145,1145, 32969,201, 1146,1146, 33915,1147, 32970,202, 
1148,1148, 32971,203, 1149,1149, 32972,204, 205,205, 215,215, 1150,1150, 32986,218, 1151,1151, 33920,1152, 32987,219, 1153,1153, 33922,1154, 32988,220, 1155,1155, 32989,221, 
1156,1156, 33925,1157, 32990,222, 243,243, 1158,1158, 33039,271, 348,348, 1159,1159, 33117,349, 1160,1160, 33929,1161, 33118,350, 1162,1162, 33119,351, 1163,1163, 33120,352, 
1164,1164, 33232,464, 33121,353, 
5, // chain 98
798,798, 799,799, 1165,1165, 
33568,800, 877,877, 33570,802, 33569,801, 
2, // chain 99
798,798, 1165,1165, 797,797, 
33645,877, 
7, // chain 100
589,589, 590,590, 1166,1166, 
33892,1124, 1167,1167, 33893,1125, 1168,1168, 33895,1127, 33894,1126, 
32, // chain 101
589,589, 1166,1166, 588,588, 
33937,1169, 33935,1167, 1170,1170, 33939,1171, 33936,1168, 1172,1172, 33895,1127, 1173,1173, 33896,1128, 1129,1129, 1174,1174, 33943,1175, 33898,1130, 1131,1131, 1132,1132, 1176,1176, 
33945,1177, 33901,1133, 1178,1178, 33947,1179, 33902,1134, 1180,1180, 33903,1135, 1181,1181, 33904,1136, 1182,1182, 33905,1137, 1183,1183, 33906,1138, 1140,1140, 33907,1139, 
30, // chain 102
656,656, 657,657, 1184,1184, 
33953,1185, 33954,1186, 33426,658, 1187,1187, 33427,659, 1188,1188, 33428,660, 1189,1189, 33429,661, 1190,1190, 33959,1191, 33430,662, 1192,1192, 33355,587, 588,588, 1169,1169, 
1193,1193, 33938,1170, 1194,1194, 33963,1195, 33939,1171, 1196,1196, 33940,1172, 1197,1197, 33941,1173, 1174,1174, 1198,1198, 33944,1176, 33943,1175, 
175, // chain 103
1192,1192, 1193,1193, 1191,1191, 
33967,1199, 33962,1194, 1200,1200, 33969,1201, 33963,1195, 1196,1196, 1202,1202, 33971,1203, 33965,1197, 1198,1198, 1204,1204, 33973,1205, 33944,1176, 1177,1177, 1206,1206, 33946,1178, 
1207,1207, 33976,1208, 33947,1179, 1209,1209, 33948,1180, 1210,1210, 33949,1181, 1211,1211, 33950,1182, 1212,1212, 33951,1183, 1213,1213, 33908,1140, 1141,1141, 1214,1214, 32882,114, 
1142,1142, 1215,1215, 33911,1143, 1216,1216, 33985,1217, 33986,1218, 33987,1219, 33912,1144, 1145,1145, 1220,1220, 33914,1146, 1221,1221, 33990,1222, 33915,1147, 1223,1223, 33916,1148, 
1149,1149, 1224,1224, 33993,1225, 33918,1150, 1226,1226, 33995,1227, 33919,1151, 1228,1228, 33920,1152, 1229,1229, 33921,1153, 1230,1230, 33999,1231, 33922,1154, 1232,1232, 33923,1155, 
1233,1233, 33924,1156, 1234,1234, 34003,1235, 33925,1157, 1158,1158, 1159,1159, 1236,1236, 33928,1160, 1237,1237, 34006,1238, 33929,1161, 1239,1239, 33930,1162, 1240,1240, 33931,1163, 
1241,1241, 33932,1164, 1242,1242, 34011,1243, 33232,464, 465,465, 1244,1244, 33234,466, 1245,1245, 33235,467, 1246,1246, 33236,468, 1247,1247, 34016,1248, 33237,469, 1249,1249, 
33238,470, 498,498, 1250,1250, 33271,503, 535,535, 1251,1251, 33304,536, 1252,1252, 34021,1253, 33305,537, 1254,1254, 33306,538, 1255,1255, 33307,539, 1256,1256, 34025,1257, 
33308,540, 1258,1258, 33309,541, 600,600, 1259,1259, 33369,601, 1260,1260, 33370,602, 687,687, 1261,1261, 34030,1262, 33456,688, 1263,1263, 34032,1264, 33457,689, 712,712, 
1265,1265, 33485,717, 1266,1266, 33491,723, 1267,1267, 33498,730, 757,757, 1268,1268, 34037,1269, 33526,758, 1270,1270, 34039,1271, 33527,759, 782,782, 1272,1272, 33573,805, 
1273,1273, 33586,818, 1274,1274, 33587,819, 852,852, 1275,1275, 34044,1276, 33621,853, 1277,1277, 33622,854, 1278,1278, 33623,855, 1279,1279, 34048,1280, 33624,856, 1281,1281, 
33625,857, 1282,1282, 34051,1283, 33626,858, 1284,1284, 33627,859, 1285,1285, 33628,860, 1286,1286, 34055,1287, 33629,861, 1288,1288, 33631,863, 33630,862, 
19, // chain 104
1289,1289, 1290,1290, 876,876, 
877,877, 802,802, 803,803, 1291,1291, 34060,1292, 33572,804, 1293,1293, 34062,1294, 34063,1295, 33520,752, 753,753, 1185,1185, 33952,1184, 33522,754, 1296,1296, 33423,655, 
656,656, 1184,1184, 
5, // chain 105
876,876, 1290,1290, 875,875, 
34065,1297, 34066,1298, 34059,1291, 34057,1289, 
46, // chain 106
1191,1191, 1199,1199, 1190,1190, 
34067,1299, 34068,1300, 33968,1200, 1301,1301, 34070,1302, 33969,1201, 1303,1303, 34072,1304, 33970,1202, 1305,1305, 33971,1203, 1204,1204, 1306,1306, 34075,1307, 33973,1205, 1206,1206, 
1308,1308, 33975,1207, 1309,1309, 34078,1310, 33976,1208, 1311,1311, 33977,1209, 1312,1312, 33978,1210, 1313,1313, 33979,1211, 1314,1314, 33980,1212, 1315,1315, 33981,1213, 1214,1214, 
1215,1215, 1316,1316, 33984,1216, 1317,1317, 34086,1318, 33985,1217, 1319,1319, 34088,1320, 33986,1218, 1321,1321, 34090,1322, 33988,1220, 33987,1219, 
27, // chain 107
874,874, 875,875, 1323,1323, 
34065,1297, 1324,1324, 34093,1325, 34066,1298, 1326,1326, 34095,1327, 34059,1291, 1292,1292, 1328,1328, 34061,1293, 1329,1329, 34062,1294, 1330,1330, 34063,1295, 1331,1331, 33953,1185, 
1332,1332, 33954,1186, 1333,1333, 33955,1187, 1334,1334, 33956,1188, 1335,1335, 33957,1189, 1299,1299, 33958,1190, 
30, // chain 108
874,874, 1323,1323, 873,873, 
34104,1336, 34092,1324, 1337,1337, 34106,1338, 34093,1325, 1339,1339, 34094,1326, 1340,1340, 34109,1341, 34095,1327, 1328,1328, 1342,1342, 34097,1329, 1343,1343, 34098,1330, 1344,1344, 
34099,1331, 1345,1345, 34100,1332, 1346,1346, 34101,1333, 1347,1347, 34102,1334, 1348,1348, 34103,1335, 1349,1349, 34067,1299, 1301,1301, 34068,1300, 
60, // chain 109
873,873, 1336,1336, 872,872, 
34118,1350, 34105,1337, 1351,1351, 34120,1352, 34121,1353, 34106,1338, 1354,1354, 34123,1355, 34107,1339, 1356,1356, 34108,1340, 1357,1357, 34126,1358, 34109,1341, 1342,1342, 1359,1359, 
34111,1343, 1360,1360, 34112,1344, 1361,1361, 34113,1345, 1362,1362, 34114,1346, 1363,1363, 34115,1347, 1364,1364, 34116,1348, 1365,1365, 34117,1349, 1366,1366, 34069,1301, 1367,1367, 
34070,1302, 1368,1368, 34071,1303, 1369,1369, 34072,1304, 1370,1370, 34073,1305, 1306,1306, 1371,1371, 34140,1372, 34075,1307, 1308,1308, 1373,1373, 34077,1309, 1374,1374, 34143,1375, 
34078,1310, 1376,1376, 34079,1311, 1377,1377, 34080,1312, 1378,1378, 34081,1313, 1379,1379, 34082,1314, 1316,1316, 34083,1315, 
64, // chain 110
872,872, 1350,1350, 871,871, 
34148,1380, 34119,1351, 1381,1381, 34150,1382, 34120,1352, 1383,1383, 34121,1353, 1354,1354, 1384,1384, 34153,1385, 34154,1386, 34155,1387, 34123,1355, 1388,1388, 34124,1356, 1389,1389, 
34125,1357, 1390,1390, 34159,1391, 34126,1358, 1359,1359, 1392,1392, 34128,1360, 1393,1393, 34129,1361, 1394,1394, 34130,1362, 1395,1395, 34131,1363, 1396,1396, 34132,1364, 1397,1397, 
34133,1365, 1398,1398, 34134,1366, 1399,1399, 34135,1367, 1400,1400, 34136,1368, 1401,1401, 34137,1369, 1370,1370, 1402,1402, 34139,1371, 1403,1403, 34172,1404, 34140,1372, 1373,1373, 
1405,1405, 34142,1374, 1406,1406, 34175,1407, 34143,1375, 1408,1408, 34144,1376, 1409,1409, 34145,1377, 1378,1378, 1410,1410, 34179,1411, 34147,1379, 1317,1317, 34084,1316, 
6, // chain 111
866,866, 867,867, 1412,1412, 
1413,1413, 34182,1414, 34183,1415, 33636,868, 33635,867, 
5, // chain 112
1415,1415, 868,868, 869,869, 
1416,1416, 33638,870, 1380,1380, 33639,871, 
5, // chain 113
1390,1390, 1391,1391, 1417,1417, 
1418,1418, 34187,1419, 34160,1392, 34159,1391, 
52, // chain 114
1419,1419, 1392,1392, 1393,1393, 
1420,1420, 34162,1394, 1421,1421, 34163,1395, 1422,1422, 34164,1396, 1423,1423, 34165,1397, 1424,1424, 34166,1398, 1418,1418, 34167,1399, 1425,1425, 34168,1400, 1426,1426, 34169,1401, 
1427,1427, 34170,1402, 1403,1403, 1428,1428, 34197,1429, 34172,1404, 1405,1405, 1430,1430, 34174,1406, 1431,1431, 34200,1432, 34175,1407, 1433,1433, 34176,1408, 1434,1434, 34177,1409, 
1435,1435, 34178,1410, 1436,1436, 34179,1411, 1437,1437, 34085,1317, 1318,1318, 1438,1438, 34087,1319, 1439,1439, 34088,1320, 1440,1440, 34209,1441, 34089,1321, 1442,1442, 34211,1443, 
34090,1322, 1221,1221, 33988,1220, 
1, // chain 115
653,653, 685,685, 652,652, 
2, // chain 116
118,118, 114,114, 159,159, 
114,114, 
1, // chain 117
121,121, 118,118, 119,119, 
1, // chain 118
945,945, 946,946, 947,947, 
34, // chain 119
1444,1444, 1274,1274, 1275,1275, 
1445,1445, 34214,1446, 34044,1276, 1447,1447, 34045,1277, 1448,1448, 34046,1278, 1449,1449, 34047,1279, 1450,1450, 34219,1451, 34048,1280, 1452,1452, 34049,1281, 1453,1453, 34222,1454, 
34050,1282, 1455,1455, 34051,1283, 1456,1456, 34052,1284, 1457,1457, 34053,1285, 1458,1458, 34054,1286, 1459,1459, 34228,1460, 34055,1287, 1461,1461, 34056,1288, 1462,1462, 33632,864, 
33631,863, 
44, // chain 120
1463,1463, 1273,1273, 1444,1444, 
1464,1464, 34213,1445, 1465,1465, 34234,1466, 34214,1446, 1467,1467, 34215,1447, 1468,1468, 34216,1448, 1469,1469, 34217,1449, 1470,1470, 34218,1450, 1471,1471, 34240,1472, 34219,1451, 
1473,1473, 34220,1452, 1474,1474, 34221,1453, 1475,1475, 34244,1476, 34222,1454, 1477,1477, 34223,1455, 1478,1478, 34224,1456, 1479,1479, 34225,1457, 1480,1480, 34226,1458, 1481,1481, 
34227,1459, 1482,1482, 34251,1483, 34228,1460, 1484,1484, 34229,1461, 1485,1485, 34230,1462, 1486,1486, 33633,865, 33632,864, 
1, // chain 121
1444,1444, 1273,1273, 1274,1274, 
54, // chain 122
1487,1487, 1272,1272, 1463,1463, 
1488,1488, 34232,1464, 1489,1489, 34233,1465, 1490,1490, 34259,1491, 34234,1466, 1492,1492, 34235,1467, 1493,1493, 34236,1468, 1494,1494, 34237,1469, 1495,1495, 34238,1470, 1496,1496, 
34239,1471, 1497,1497, 34266,1498, 34240,1472, 1499,1499, 34241,1473, 1500,1500, 34242,1474, 1501,1501, 34243,1475, 1502,1502, 34271,1503, 34244,1476, 1504,1504, 34245,1477, 1505,1505, 
34246,1478, 1506,1506, 34247,1479, 1507,1507, 34248,1480, 1508,1508, 34249,1481, 1509,1509, 34250,1482, 1510,1510, 34279,1511, 34251,1483, 1512,1512, 34252,1484, 1513,1513, 34253,1485, 
1514,1514, 34254,1486, 1413,1413, 33634,866, 33633,865, 
1, // chain 123
1463,1463, 1272,1272, 1273,1273, 
86, // chain 124
1270,1270, 1271,1271, 1487,1487, 
1515,1515, 34256,1488, 1516,1516, 34257,1489, 1517,1517, 34258,1490, 1518,1518, 34287,1519, 34259,1491, 1520,1520, 34260,1492, 1521,1521, 34261,1493, 1522,1522, 34262,1494, 1523,1523, 
34263,1495, 1524,1524, 34264,1496, 1497,1497, 1525,1525, 34294,1526, 34266,1498, 1527,1527, 34267,1499, 1528,1528, 34268,1500, 1529,1529, 34269,1501, 1530,1530, 34270,1502, 1531,1531, 
34300,1532, 34271,1503, 1533,1533, 34272,1504, 1534,1534, 34273,1505, 1535,1535, 34274,1506, 1507,1507, 1536,1536, 34276,1508, 1509,1509, 1510,1510, 1537,1537, 34306,1538, 34279,1511, 
1539,1539, 34280,1512, 1540,1540, 34281,1513, 1541,1541, 34282,1514, 1542,1542, 34181,1413, 1414,1414, 1543,1543, 34312,1544, 34183,1415, 1416,1416, 1380,1380, 1543,1543, 34149,1381, 
1545,1545, 34314,1546, 34150,1382, 1547,1547, 34151,1383, 1548,1548, 34152,1384, 1549,1549, 34153,1385, 1550,1550, 34319,1551, 34154,1386, 1552,1552, 34155,1387, 1388,1388, 1553,1553, 
34322,1554, 34193,1425, 34186,1418, 34157,1389, 1390,1390, 
1, // chain 125
1487,1487, 1271,1271, 1272,1272, 
163, // chain 126
1555,1555, 1267,1267, 1268,1268, 
1556,1556, 34325,1557, 34037,1269, 1558,1558, 34038,1270, 1515,1515, 1559,1559, 34284,1516, 1560,1560, 34285,1517, 1561,1561, 34286,1518, 1562,1562, 34287,1519, 1563,1563, 34288,1520, 
1521,1521, 1522,1522, 1564,1564, 34291,1523, 1524,1524, 1525,1525, 1565,1565, 34334,1566, 34294,1526, 1567,1567, 34295,1527, 1568,1568, 34296,1528, 1569,1569, 34297,1529, 1570,1570, 
34298,1530, 1571,1571, 34299,1531, 1572,1572, 34341,1573, 34300,1532, 1533,1533, 1574,1574, 34302,1534, 1575,1575, 34303,1535, 1576,1576, 34304,1536, 1577,1577, 34346,1578, 34305,1537, 
1579,1579, 34348,1580, 34306,1538, 1581,1581, 34307,1539, 1582,1582, 34308,1540, 1583,1583, 34309,1541, 1584,1584, 34310,1542, 1543,1543, 1545,1545, 1585,1585, 34354,1586, 34314,1546, 
1587,1587, 34315,1547, 1588,1588, 34316,1548, 1589,1589, 34317,1549, 1590,1590, 34318,1550, 1591,1591, 34360,1592, 34319,1551, 1593,1593, 34320,1552, 1553,1553, 1594,1594, 34363,1595, 
34322,1554, 1596,1596, 34193,1425, 1597,1597, 34366,1598, 34367,1599, 34368,1600, 34369,1601, 34370,1602, 34371,1603, 34372,1604, 34373,1605, 34374,1606, 34194,1426, 1607,1607, 34195,1427, 
1428,1428, 1608,1608, 34377,1609, 34197,1429, 1430,1430, 1610,1610, 34199,1431, 1611,1611, 34380,1612, 34200,1432, 1613,1613, 34201,1433, 1614,1614, 34202,1434, 1615,1615, 34203,1435, 
1616,1616, 34204,1436, 1617,1617, 34205,1437, 1438,1438, 1618,1618, 34207,1439, 1619,1619, 34208,1440, 1620,1620, 34209,1441, 1621,1621, 34390,1622, 34210,1442, 1623,1623, 34392,1624, 
34393,1625, 34211,1443, 1221,1221, 1222,1222, 1223,1223, 1224,1224, 1626,1626, 34395,1627, 34396,1628, 34397,1629, 33993,1225, 1226,1226, 1630,1630, 34399,1631, 33995,1227, 1632,1632, 
34401,1633, 33996,1228, 1634,1634, 33997,1229, 1635,1635, 33998,1230, 1636,1636, 34405,1637, 33999,1231, 1638,1638, 34000,1232, 1639,1639, 34001,1233, 1640,1640, 34002,1234, 1641,1641, 
34004,1236, 34003,1235, 
63, // chain 127
1642,1642, 1266,1266, 1555,1555, 
1643,1643, 34324,1556, 1644,1644, 34413,1645, 34325,1557, 1646,1646, 34326,1558, 1559,1559, 1647,1647, 34328,1560, 1648,1648, 34329,1561, 1562,1562, 1649,1649, 34418,1650, 34419,1651, 
34331,1563, 1652,1652, 34332,1564, 1653,1653, 34333,1565, 1654,1654, 34423,1655, 34424,1656, 34334,1566, 1567,1567, 1657,1657, 34336,1568, 1658,1658, 34337,1569, 1659,1659, 34338,1570, 
1660,1660, 34339,1571, 1661,1661, 34340,1572, 1662,1662, 34431,1663, 34341,1573, 1664,1664, 34342,1574, 1665,1665, 34343,1575, 1666,1666, 34344,1576, 1667,1667, 34345,1577, 1668,1668, 
34346,1578, 1669,1669, 34347,1579, 1670,1670, 34439,1671, 34348,1580, 1672,1672, 34349,1581, 1673,1673, 34350,1582, 1674,1674, 34351,1583, 1585,1585, 34352,1584, 
1, // chain 128
1555,1555, 1266,1266, 1267,1267, 
153, // chain 129
1675,1675, 1265,1265, 1642,1642, 
1676,1676, 34411,1643, 1677,1677, 34412,1644, 1678,1678, 34447,1679, 34413,1645, 1680,1680, 34414,1646, 1647,1647, 1648,1648, 1681,1681, 34417,1649, 1682,1682, 34451,1683, 34452,1684, 
34418,1650, 1685,1685, 34454,1686, 34419,1651, 1652,1652, 1687,1687, 34421,1653, 1688,1688, 34422,1654, 1689,1689, 34423,1655, 1690,1690, 34459,1691, 34424,1656, 1692,1692, 34425,1657, 
1658,1658, 1693,1693, 34427,1659, 1694,1694, 34428,1660, 1695,1695, 34429,1661, 1696,1696, 34430,1662, 1697,1697, 34466,1698, 34431,1663, 1699,1699, 34432,1664, 1700,1700, 34433,1665, 
1701,1701, 34434,1666, 1702,1702, 34435,1667, 1703,1703, 34436,1668, 1704,1704, 34437,1669, 1705,1705, 34438,1670, 1706,1706, 34475,1707, 34439,1671, 1708,1708, 34440,1672, 1709,1709, 
34478,1710, 34441,1673, 1674,1674, 1711,1711, 34353,1585, 1586,1586, 1712,1712, 34355,1587, 1713,1713, 34356,1588, 1714,1714, 34357,1589, 1715,1715, 34358,1590, 1716,1716, 34359,1591, 
1717,1717, 34486,1718, 34360,1592, 1719,1719, 34361,1593, 1594,1594, 1720,1720, 34363,1595, 1721,1721, 34364,1596, 1597,1597, 1722,1722, 34366,1598, 1723,1723, 34367,1599, 1724,1724, 
34368,1600, 1725,1725, 34369,1601, 1726,1726, 34370,1602, 1727,1727, 34371,1603, 1728,1728, 34372,1604, 1605,1605, 1729,1729, 34498,1730, 34374,1606, 1731,1731, 34375,1607, 1608,1608, 
1732,1732, 34501,1733, 34377,1609, 1610,1610, 1734,1734, 34379,1611, 1735,1735, 34504,1736, 34380,1612, 1613,1613, 1737,1737, 34506,1738, 34382,1614, 1739,1739, 34383,1615, 1740,1740, 
34384,1616, 1741,1741, 34385,1617, 1618,1618, 1742,1742, 34387,1619, 1743,1743, 33676,908, 33675,907, 33674,906, 34388,1620, 905,905, 34389,1621, 1744,1744, 34390,1622, 1745,1745, 
34391,1623, 1746,1746, 34515,1747, 34516,1748, 34392,1624, 1749,1749, 34394,1626, 34393,1625, 
1, // chain 130
1642,1642, 1265,1265, 1266,1266, 
12, // chain 131
1263,1263, 1264,1264, 1675,1675, 
1750,1750, 34444,1676, 1751,1751, 34445,1677, 1752,1752, 34446,1678, 1753,1753, 34450,1682, 34447,1679, 1681,1681, 34448,1680, 
1, // chain 132
1675,1675, 1264,1264, 1265,1265, 
16, // chain 133
1754,1754, 1260,1260, 1261,1261, 
1755,1755, 34524,1756, 34030,1262, 1757,1757, 34031,1263, 1750,1750, 1758,1758, 34519,1751, 1759,1759, 34520,1752, 1753,1753, 1760,1760, 34529,1761, 34451,1683, 34450,1682, 
147, // chain 134
1762,1762, 1259,1259, 1754,1754, 
1763,1763, 34523,1755, 1764,1764, 34533,1765, 34524,1756, 1766,1766, 34525,1757, 1758,1758, 1767,1767, 34527,1759, 1760,1760, 1768,1768, 34537,1769, 34529,1761, 1770,1770, 34539,1771, 
34451,1683, 1684,1684, 1685,1685, 1772,1772, 34541,1773, 34454,1686, 1687,1687, 1774,1774, 34456,1688, 1775,1775, 34544,1776, 34457,1689, 1777,1777, 34458,1690, 1778,1778, 34547,1779, 
34459,1691, 1780,1780, 34460,1692, 1693,1693, 1781,1781, 34462,1694, 1782,1782, 34463,1695, 1783,1783, 34464,1696, 1784,1784, 34465,1697, 1785,1785, 34554,1786, 34466,1698, 1787,1787, 
34467,1699, 1788,1788, 34468,1700, 1789,1789, 34469,1701, 1790,1790, 34470,1702, 1791,1791, 34471,1703, 1792,1792, 34472,1704, 1793,1793, 34473,1705, 1794,1794, 34474,1706, 1795,1795, 
34564,1796, 34475,1707, 1797,1797, 34476,1708, 1798,1798, 34477,1709, 1799,1799, 34568,1800, 34478,1710, 1711,1711, 1712,1712, 1801,1801, 34481,1713, 1802,1802, 34482,1714, 1715,1715, 
1716,1716, 1803,1803, 34485,1717, 1804,1804, 34486,1718, 1805,1805, 34574,1806, 34487,1719, 1720,1720, 1807,1807, 34489,1721, 1722,1722, 1808,1808, 34491,1723, 1809,1809, 34492,1724, 
1810,1810, 34493,1725, 1811,1811, 34494,1726, 1812,1812, 34495,1727, 1813,1813, 34496,1728, 1729,1729, 1814,1814, 34583,1815, 34498,1730, 1816,1816, 34499,1731, 1732,1732, 1817,1817, 
34586,1818, 34501,1733, 1734,1734, 1819,1819, 34503,1735, 1820,1820, 34589,1821, 34590,1822, 34504,1736, 1737,1737, 1823,1823, 34592,1824, 34506,1738, 1825,1825, 34507,1739, 1826,1826, 
34508,1740, 1827,1827, 34509,1741, 1742,1742, 1828,1828, 34511,1743, 908,908, 909,909, 1829,1829, 33678,910, 1830,1830, 33679,911, 1831,1831, 33680,912, 1832,1832, 34601,1833, 
33682,914, 33681,913, 
1, // chain 135
1754,1754, 1259,1259, 1260,1260, 
20, // chain 136
1257,1257, 1258,1258, 1762,1762, 
1834,1834, 34531,1763, 1835,1835, 34532,1764, 1836,1836, 34605,1837, 34533,1765, 1838,1838, 34534,1766, 1767,1767, 1768,1768, 1839,1839, 34537,1769, 1840,1840, 34609,1841, 34538,1770, 
1842,1842, 34540,1772, 34539,1771, 
1, // chain 137
1762,1762, 1258,1258, 1259,1259, 
15, // chain 138
1843,1843, 1250,1250, 1251,1251, 
1844,1844, 34020,1252, 1845,1845, 34614,1846, 34021,1253, 1847,1847, 34022,1254, 1848,1848, 34023,1255, 1849,1849, 34024,1256, 1850,1850, 34602,1834, 34025,1257, 
19, // chain 139
1248,1248, 1249,1249, 1843,1843, 
1851,1851, 34612,1844, 1852,1852, 34613,1845, 1853,1853, 34622,1854, 34614,1846, 1855,1855, 34615,1847, 1856,1856, 34616,1848, 1857,1857, 34617,1849, 1858,1858, 34618,1850, 1859,1859, 
34603,1835, 34602,1834, 
1, // chain 140
1843,1843, 1249,1249, 1250,1250, 
18, // chain 141
1247,1247, 1248,1248, 1851,1851, 
1860,1860, 34620,1852, 1861,1861, 34621,1853, 1862,1862, 34622,1854, 1863,1863, 34623,1855, 1856,1856, 1864,1864, 34625,1857, 1858,1858, 1865,1865, 34627,1859, 1866,1866, 34604,1836, 
34603,1835, 
19, // chain 142
1867,1867, 1247,1247, 1860,1860, 
1868,1868, 34629,1861, 1869,1869, 34630,1862, 1870,1870, 34639,1871, 34631,1863, 1872,1872, 34632,1864, 1873,1873, 34633,1865, 1874,1874, 34634,1866, 1840,1840, 34607,1839, 34604,1836, 
1837,1837, 1838,1838, 
83, // chain 143
1875,1875, 1246,1246, 1867,1867, 
1876,1876, 34636,1868, 1877,1877, 34637,1869, 1878,1878, 34638,1870, 1879,1879, 34639,1871, 1880,1880, 34640,1872, 1881,1881, 34641,1873, 1882,1882, 34651,1883, 34642,1874, 1840,1840, 
1841,1841, 1884,1884, 34610,1842, 1885,1885, 34654,1886, 34540,1772, 1773,1773, 1887,1887, 34542,1774, 1775,1775, 1888,1888, 34657,1889, 34658,1890, 34544,1776, 1891,1891, 34545,1777, 
1778,1778, 1892,1892, 34661,1893, 34662,1894, 34547,1779, 1895,1895, 34548,1780, 1781,1781, 1896,1896, 34550,1782, 1897,1897, 34551,1783, 1898,1898, 34552,1784, 1899,1899, 34553,1785, 
1900,1900, 34669,1901, 34554,1786, 1902,1902, 34555,1787, 1903,1903, 34556,1788, 1904,1904, 34557,1789, 1905,1905, 34558,1790, 1906,1906, 34559,1791, 1907,1907, 34560,1792, 1908,1908, 
34561,1793, 1909,1909, 34562,1794, 1910,1910, 34563,1795, 1911,1911, 34680,1912, 34564,1796, 1913,1913, 34565,1797, 1914,1914, 34566,1798, 1915,1915, 34567,1799, 1916,1916, 34685,1917, 
34569,1801, 34568,1800, 
1, // chain 144
1867,1867, 1246,1246, 1247,1247, 
22, // chain 145
1918,1918, 1245,1245, 1875,1875, 
1919,1919, 34644,1876, 1920,1920, 34645,1877, 1921,1921, 34646,1878, 1922,1922, 34647,1879, 1923,1923, 34648,1880, 1924,1924, 34649,1881, 1925,1925, 34650,1882, 1926,1926, 34651,1883, 
1884,1884, 1927,1927, 34653,1885, 1887,1887, 34654,1886, 
1, // chain 146
1875,1875, 1245,1245, 1246,1246, 
89, // chain 147
1928,1928, 1244,1244, 1918,1918, 
1929,1929, 34687,1919, 1930,1930, 34688,1920, 1921,1921, 1931,1931, 34700,1932, 34690,1922, 1933,1933, 34691,1923, 1934,1934, 34703,1935, 34692,1924, 1936,1936, 34693,1925, 1926,1926, 
1927,1927, 1887,1887, 1935,1935, 34702,1934, 34705,1937, 34706,1938, 34707,1939, 34708,1940, 34709,1941, 34710,1942, 34656,1888, 1943,1943, 34657,1889, 1944,1944, 34713,1945, 34658,1890, 
1891,1891, 1892,1892, 1946,1946, 34715,1947, 34661,1893, 1948,1948, 34717,1949, 34662,1894, 1950,1950, 34663,1895, 1896,1896, 1951,1951, 34665,1897, 1952,1952, 34666,1898, 1953,1953, 
34667,1899, 1954,1954, 34668,1900, 1955,1955, 34724,1956, 34669,1901, 1957,1957, 34670,1902, 1958,1958, 34671,1903, 1959,1959, 34672,1904, 1960,1960, 34673,1905, 1961,1961, 34674,1906, 
1962,1962, 34675,1907, 1963,1963, 34676,1908, 1964,1964, 34677,1909, 1910,1910, 1965,1965, 34679,1911, 1966,1966, 34680,1912, 1967,1967, 34681,1913, 1968,1968, 34682,1914, 1969,1969, 
34683,1915, 1916,1916, 1970,1970, 34739,1971, 34685,1917, 1972,1972, 34570,1802, 34569,1801, 
1, // chain 148
1918,1918, 1244,1244, 1245,1245, 
35, // chain 149
1242,1242, 1243,1243, 1928,1928, 
1973,1973, 34697,1929, 1974,1974, 34698,1930, 1931,1931, 1975,1975, 34744,1976, 34745,1977, 34700,1932, 1978,1978, 34701,1933, 1934,1934, 1937,1937, 1979,1979, 34748,1980, 34749,1981, 
34750,1982, 34751,1983, 34706,1938, 1984,1984, 34753,1985, 34707,1939, 1986,1986, 34708,1940, 1987,1987, 34756,1988, 34709,1941, 1989,1989, 34710,1942, 1943,1943, 1990,1990, 34712,1944, 
1946,1946, 34713,1945, 
1, // chain 150
1928,1928, 1243,1243, 1244,1244, 
15, // chain 151
1641,1641, 1236,1236, 1237,1237, 
1991,1991, 34760,1992, 34006,1238, 1993,1993, 34007,1239, 1994,1994, 34008,1240, 1995,1995, 34009,1241, 1996,1996, 34010,1242, 1973,1973, 1975,1975, 34742,1974, 
23, // chain 152
1997,1997, 1635,1635, 1636,1636, 
1998,1998, 34767,1999, 34405,1637, 2000,2000, 34406,1638, 2001,2001, 34407,1639, 2002,2002, 34408,1640, 2003,2003, 34409,1641, 1991,1991, 2004,2004, 34773,2005, 34760,1992, 2006,2006, 
34761,1993, 1994,1994, 2007,2007, 34763,1995, 1975,1975, 34764,1996, 
11, // chain 153
2008,2008, 1997,1997, 1998,1998, 
2009,2009, 34767,1999, 2010,2010, 34768,2000, 2011,2011, 34769,2001, 2012,2012, 34770,2002, 2004,2004, 34771,2003, 
15, // chain 154
2008,2008, 2009,2009, 2013,2013, 
34782,2014, 34778,2010, 2015,2015, 34779,2011, 2012,2012, 2016,2016, 34772,2004, 2017,2017, 34773,2005, 2006,2006, 2018,2018, 34775,2007, 1976,1976, 34743,1975, 
37, // chain 155
1981,1981, 2019,2019, 2020,2020, 
2021,2021, 34784,2016, 34783,2015, 34787,2019, 2014,2014, 34790,2022, 34749,1981, 1982,1982, 2023,2023, 34792,2024, 34751,1983, 2025,2025, 34752,1984, 1985,1985, 2026,2026, 34754,1986, 
2027,2027, 34796,2028, 34755,1987, 2029,2029, 34756,1988, 2030,2030, 34757,1989, 1990,1990, 2031,2031, 34800,2032, 34714,1946, 2033,2033, 34715,1947, 2034,2034, 34716,1948, 2035,2035, 
34804,2036, 34717,1949, 1951,1951, 34718,1950, 
5, // chain 156
1978,1978, 1979,1979, 1977,1977, 
34748,1980, 2037,2037, 34789,2021, 34749,1981, 
5, // chain 157
1976,1976, 1977,1977, 2018,2018, 
34805,2037, 2017,2017, 34789,2021, 2016,2016, 
5, // chain 158
1423,1423, 1424,1424, 1418,1418, 
1422,1422, 34189,1421, 34188,1420, 34187,1419, 
20, // chain 159
2038,2038, 2039,2039, 2040,2040, 
2041,2041, 34810,2042, 34811,2043, 34812,2044, 34813,2045, 34814,2046, 34815,2047, 34807,2039, 2048,2048, 34817,2049, 34818,2050, 34819,2051, 34820,2052, 34806,2038, 2053,2053, 34822,2054, 
34823,2055, 34824,2056, 34809,2041, 
6, // chain 160
2057,2057, 2051,2051, 2052,2052, 
2058,2058, 34827,2059, 34828,2060, 34829,2061, 34821,2053, 
4, // chain 161
2062,2062, 2051,2051, 2057,2057, 
2063,2063, 34832,2064, 34826,2058, 
5, // chain 162
2065,2065, 903,903, 2062,2062, 
2066,2066, 34835,2067, 34836,2068, 34831,2063, 
6, // chain 163
2069,2069, 2051,2051, 2062,2062, 
903,903, 904,904, 2070,2070, 34512,1744, 33673,905, 
4, // chain 164
902,902, 903,903, 2065,2065, 
2071,2071, 34840,2072, 34834,2066, 
49, // chain 165
1631,1631, 1632,1632, 2073,2073, 
34842,2074, 34843,2075, 34401,1633, 2076,2076, 34402,1634, 2077,2077, 34403,1635, 1997,1997, 2078,2078, 34776,2008, 2079,2079, 34781,2013, 2080,2080, 34782,2014, 2081,2081, 34790,2022, 
2023,2023, 2082,2082, 34792,2024, 2083,2083, 34793,2025, 2084,2084, 34853,2085, 34794,2026, 2086,2086, 34795,2027, 2087,2087, 34796,2028, 2088,2088, 34857,2089, 34797,2029, 2090,2090, 
34798,2030, 2031,2031, 2091,2091, 34860,2092, 34800,2032, 2033,2033, 2093,2093, 34862,2094, 34802,2034, 2095,2095, 34803,2035, 2096,2096, 34865,2097, 34804,2036, 1952,1952, 34719,1951, 
11, // chain 166
1745,1745, 1746,1746, 2098,2098, 
34867,2099, 34515,1747, 2100,2100, 34869,2101, 34516,1748, 1749,1749, 2102,2102, 34871,2103, 34395,1627, 34394,1626, 
18, // chain 167
1745,1745, 2098,2098, 2104,2104, 
34867,2099, 2105,2105, 34874,2106, 34875,2107, 34876,2108, 34868,2100, 2109,2109, 34878,2110, 34869,2101, 2111,2111, 34870,2102, 2112,2112, 34871,2103, 2113,2113, 34882,2114, 34396,1628, 
34395,1627, 
29, // chain 168
1745,1745, 2104,2104, 2050,2050, 
34883,2115, 34884,2116, 34873,2105, 2117,2117, 34886,2118, 34887,2119, 34874,2106, 2120,2120, 34875,2107, 2121,2121, 34876,2108, 2122,2122, 34877,2109, 2123,2123, 34892,2124, 34878,2110, 
2125,2125, 34879,2111, 2126,2126, 34880,2112, 2127,2127, 34881,2113, 2128,2128, 34897,2129, 34882,2114, 2130,2130, 34397,1629, 34396,1628, 
4, // chain 169
1744,1744, 1745,1745, 2050,2050, 
2070,2070, 34819,2051, 2069,2069, 
61, // chain 170
1629,1629, 1630,1630, 2130,2130, 
34899,2131, 34399,1631, 2132,2132, 34841,2073, 2133,2133, 34902,2134, 34842,2074, 2135,2135, 34904,2136, 34843,2075, 2137,2137, 34844,2076, 2138,2138, 34845,2077, 2078,2078, 2139,2139, 
34847,2079, 2140,2140, 34909,2141, 34848,2080, 2081,2081, 2142,2142, 34850,2082, 2143,2143, 34851,2083, 2144,2144, 34913,2145, 34852,2084, 2146,2146, 34853,2085, 2147,2147, 34854,2086, 
2148,2148, 34917,2149, 34855,2087, 2150,2150, 34919,2151, 34856,2088, 2152,2152, 34857,2089, 2153,2153, 34858,2090, 2091,2091, 2154,2154, 34923,2155, 34924,2156, 34860,2092, 2157,2157, 
34861,2093, 2158,2158, 34927,2159, 34862,2094, 2095,2095, 2160,2160, 34864,2096, 2161,2161, 34930,2162, 34865,2097, 1953,1953, 34720,1952, 
15, // chain 171
2133,2133, 2134,2134, 2163,2163, 
34903,2135, 2164,2164, 34933,2165, 34904,2136, 2166,2166, 34905,2137, 2167,2167, 34906,2138, 2139,2139, 2168,2168, 34908,2140, 2169,2169, 34910,2142, 34909,2141, 
17, // chain 172
2133,2133, 2163,2163, 2170,2170, 
34939,2171, 34932,2164, 2172,2172, 34941,2173, 34942,2174, 34933,2165, 2175,2175, 34934,2166, 2176,2176, 34935,2167, 2168,2168, 2177,2177, 34937,2169, 2178,2178, 34911,2143, 34910,2142, 
23, // chain 173
2132,2132, 2133,2133, 2179,2179, 
34948,2180, 34938,2170, 2181,2181, 34950,2182, 34939,2171, 2172,2172, 2183,2183, 34952,2184, 34941,2173, 2185,2185, 34954,2186, 34942,2174, 2187,2187, 34943,2175, 2188,2188, 34944,2176, 
2177,2177, 2189,2189, 34946,2178, 2190,2190, 34912,2144, 34911,2143, 
10, // chain 174
2132,2132, 2179,2179, 2191,2191, 
34960,2192, 34961,2193, 34948,2180, 2194,2194, 34949,2181, 2195,2195, 34964,2196, 34951,2183, 34950,2182, 
7, // chain 175
2131,2131, 2132,2132, 2191,2191, 
2197,2197, 34966,2198, 34960,2192, 2193,2193, 2195,2195, 34962,2194, 
66, // chain 176
2130,2130, 2131,2131, 2197,2197, 
2129,2129, 34967,2199, 34966,2198, 2195,2195, 2128,2128, 34968,2200, 34964,2196, 2201,2201, 34970,2202, 34951,2183, 2184,2184, 2203,2203, 34953,2185, 2204,2204, 34973,2205, 34974,2206, 
34954,2186, 2207,2207, 34955,2187, 2208,2208, 34956,2188, 2189,2189, 2209,2209, 34958,2190, 2210,2210, 34912,2144, 2145,2145, 2211,2211, 34914,2146, 2212,2212, 34981,2213, 34915,2147, 
2214,2214, 34916,2148, 2215,2215, 34984,2216, 34917,2149, 2217,2217, 34918,2150, 2218,2218, 34919,2151, 2219,2219, 34920,2152, 2220,2220, 34921,2153, 2154,2154, 2221,2221, 34990,2222, 
34923,2155, 2223,2223, 34924,2156, 2224,2224, 34925,2157, 2158,2158, 2225,2225, 34994,2226, 34927,2159, 2160,2160, 2227,2227, 34929,2161, 2228,2228, 34997,2229, 34930,2162, 1954,1954, 
34721,1953, 
28, // chain 177
2230,2230, 2049,2049, 2050,2050, 
2115,2115, 2116,2116, 2049,2049, 34885,2117, 2231,2231, 35000,2232, 34886,2118, 2233,2233, 34887,2119, 2234,2234, 34888,2120, 2235,2235, 34889,2121, 2236,2236, 34890,2122, 2237,2237, 
34891,2123, 2238,2238, 35007,2239, 34892,2124, 2240,2240, 34893,2125, 2126,2126, 2241,2241, 34895,2127, 2200,2200, 34896,2128, 
4, // chain 178
2047,2047, 2048,2048, 2046,2046, 
35010,2242, 34999,2231, 34817,2049, 
14, // chain 179
2242,2242, 2231,2231, 2243,2243, 
35000,2232, 2244,2244, 35013,2245, 35014,2246, 35001,2233, 2234,2234, 2247,2247, 35016,2248, 35003,2235, 2249,2249, 35004,2236, 2238,2238, 35005,2237, 
21, // chain 180
2242,2242, 2243,2243, 2250,2250, 
35019,2251, 35012,2244, 2252,2252, 35021,2253, 35013,2245, 2254,2254, 35023,2255, 35024,2256, 35014,2246, 2257,2257, 35026,2258, 35015,2247, 2204,2204, 34971,2203, 35027,2259, 35016,2248, 
2260,2260, 35017,2249, 2239,2239, 35006,2238, 
3, // chain 181
2261,2261, 2259,2259, 2260,2260, 
2240,2240, 35007,2239, 
5, // chain 182
2203,2203, 2259,2259, 2202,2202, 
34969,2201, 35029,2261, 2241,2241, 35008,2240, 
5, // chain 183
2262,2262, 2263,2263, 2044,2044, 
2045,2045, 2264,2264, 35010,2242, 34814,2046, 
81, // chain 184
2265,2265, 2263,2263, 2262,2262, 
2266,2266, 35035,2267, 35036,2268, 35032,2264, 2269,2269, 35038,2270, 35010,2242, 2250,2250, 2251,2251, 2271,2271, 35040,2272, 35020,2252, 2273,2273, 35042,2274, 35021,2253, 2275,2275, 
35022,2254, 2276,2276, 35045,2277, 35023,2255, 2278,2278, 35047,2279, 35024,2256, 2257,2257, 2280,2280, 35026,2258, 2281,2281, 35050,2282, 34972,2204, 2205,2205, 2283,2283, 35052,2284, 
35053,2285, 34974,2206, 2286,2286, 34975,2207, 2287,2287, 34976,2208, 2209,2209, 2288,2288, 34978,2210, 2211,2211, 2289,2289, 34980,2212, 2290,2290, 34981,2213, 2291,2291, 34982,2214, 
2292,2292, 34983,2215, 2293,2293, 34984,2216, 2294,2294, 34985,2217, 2295,2295, 34986,2218, 2296,2296, 34987,2219, 2297,2297, 34988,2220, 2221,2221, 2298,2298, 35067,2299, 34990,2222, 
2300,2300, 34991,2223, 2301,2301, 34992,2224, 2225,2225, 2302,2302, 35071,2303, 34994,2226, 2227,2227, 2304,2304, 34996,2228, 2305,2305, 35074,2306, 34997,2229, 1955,1955, 34722,1954, 
38, // chain 185
2265,2265, 2266,2266, 2307,2307, 
35076,2308, 35035,2267, 2309,2309, 35078,2310, 35036,2268, 2269,2269, 2311,2311, 35080,2312, 35081,2313, 35082,2314, 35083,2315, 35038,2270, 2316,2316, 35039,2271, 2272,2272, 2273,2273, 
2317,2317, 35086,2318, 35087,2319, 35042,2274, 2320,2320, 35043,2275, 2321,2321, 35044,2276, 2322,2322, 35091,2323, 35092,2324, 35093,2325, 35045,2277, 2326,2326, 35046,2278, 2327,2327, 
35086,2318, 35047,2279, 2328,2328, 35049,2281, 35048,2280, 
9, // chain 186
2315,2315, 2316,2316, 2317,2317, 
2314,2314, 35097,2329, 35086,2318, 2328,2328, 2330,2330, 35049,2281, 2283,2283, 35050,2282, 
51, // chain 187
2314,2314, 2329,2329, 2331,2331, 
35098,2330, 2332,2332, 35051,2283, 2333,2333, 35102,2334, 35052,2284, 2285,2285, 2335,2335, 35104,2336, 35054,2286, 2337,2337, 35055,2287, 2288,2288, 2289,2289, 2338,2338, 35058,2290, 
2339,2339, 35059,2291, 2340,2340, 35060,2292, 2341,2341, 35061,2293, 2342,2342, 35062,2294, 2343,2343, 35063,2295, 2344,2344, 35064,2296, 2345,2345, 35065,2297, 2298,2298, 2346,2346, 
35115,2347, 35067,2299, 2348,2348, 35068,2300, 2349,2349, 35069,2301, 2302,2302, 2350,2350, 35119,2351, 35071,2303, 2304,2304, 2352,2352, 35073,2305, 2353,2353, 35122,2354, 35074,2306, 
1956,1956, 34723,1955, 
7, // chain 188
2355,2355, 2314,2314, 2356,2356, 
2357,2357, 35126,2358, 35127,2359, 35128,2360, 35099,2331, 35082,2314, 
16, // chain 189
2313,2313, 2314,2314, 2355,2355, 
2361,2361, 35130,2362, 35125,2357, 2363,2363, 35132,2364, 35126,2358, 2365,2365, 35127,2359, 2366,2366, 35135,2367, 35128,2360, 2368,2368, 35101,2333, 35100,2332, 35099,2331, 
29, // chain 190
2312,2312, 2313,2313, 2361,2361, 
2369,2369, 35130,2362, 2370,2370, 35131,2363, 2371,2371, 35140,2372, 35132,2364, 2373,2373, 35133,2365, 2374,2374, 35134,2366, 2375,2375, 35144,2376, 35135,2367, 2377,2377, 35136,2368, 
2378,2378, 35147,2379, 35148,2380, 35101,2333, 2381,2381, 35102,2334, 2335,2335, 2382,2382, 35151,2383, 35104,2336, 2338,2338, 35105,2337, 
16, // chain 191
2384,2384, 2320,2320, 2322,2322, 
2323,2323, 2385,2385, 35154,2386, 35092,2324, 2387,2387, 35156,2388, 35157,2389, 35158,2390, 35159,2391, 35093,2325, 2326,2326, 2327,2327, 2390,2390, 35087,2319, 35086,2318, 
1, // chain 192
2322,2322, 2320,2320, 2321,2321, 
17, // chain 193
2392,2392, 2385,2385, 2386,2386, 
2393,2393, 35162,2394, 35155,2387, 2395,2395, 35164,2396, 35156,2388, 2397,2397, 35166,2398, 35167,2399, 35157,2389, 2392,2392, 35153,2385, 35158,2390, 2384,2384, 35087,2319, 2320,2320, 
4, // chain 194
2379,2379, 2380,2380, 2400,2400, 
35169,2401, 35150,2382, 35149,2381, 
6, // chain 195
2402,2402, 2379,2379, 2403,2403, 
2404,2404, 35173,2405, 35174,2406, 35168,2400, 35147,2379, 
10, // chain 196
2407,2407, 2402,2402, 2404,2404, 
2408,2408, 35177,2409, 35173,2405, 2410,2410, 35179,2411, 35174,2406, 2412,2412, 35169,2401, 35168,2400, 
18, // chain 197
2413,2413, 2407,2407, 2408,2408, 
2414,2414, 35183,2415, 35177,2409, 2416,2416, 35178,2410, 2343,2343, 35110,2342, 35179,2411, 2341,2341, 35180,2412, 2340,2340, 35185,2417, 35169,2401, 2382,2382, 2383,2383, 2339,2339, 
35106,2338, 
9, // chain 198
2418,2418, 2413,2413, 2414,2414, 
2419,2419, 35188,2420, 35189,2421, 35183,2415, 2422,2422, 35184,2416, 2344,2344, 35111,2343, 
9, // chain 199
2396,2396, 2397,2397, 2423,2423, 
35192,2424, 35166,2398, 2425,2425, 35194,2426, 35195,2427, 35161,2393, 35167,2399, 2392,2392, 
32, // chain 200
2396,2396, 2423,2423, 2428,2428, 
35187,2419, 35197,2429, 35192,2424, 2430,2430, 35193,2425, 2431,2431, 35200,2432, 35201,2433, 35194,2426, 2434,2434, 35195,2427, 2435,2435, 35204,2436, 35161,2393, 2394,2394, 2437,2437, 
35163,2395, 2438,2438, 35207,2439, 35164,2396, 2428,2428, 2440,2440, 35187,2419, 2441,2441, 35188,2420, 2442,2442, 35189,2421, 2346,2346, 35190,2422, 2345,2345, 35112,2344, 
32, // chain 201
2419,2419, 2429,2429, 2418,2418, 
35198,2430, 2443,2443, 35199,2431, 2444,2444, 35213,2445, 35200,2432, 2446,2446, 35215,2447, 35201,2433, 2448,2448, 35202,2434, 2449,2449, 35203,2435, 2450,2450, 35219,2451, 35204,2436, 
2437,2437, 2452,2452, 35206,2438, 2453,2453, 35222,2454, 35207,2439, 2455,2455, 35208,2440, 2456,2456, 35209,2441, 2457,2457, 35226,2458, 35210,2442, 2347,2347, 35114,2346, 
8, // chain 202
2459,2459, 2456,2456, 2460,2460, 
2461,2461, 35230,2462, 35231,2463, 35118,2350, 35232,2464, 35225,2457, 35224,2456, 
16, // chain 203
2459,2459, 2461,2461, 2465,2465, 
2466,2466, 35235,2467, 35236,2468, 35237,2469, 35229,2461, 2462,2462, 2470,2470, 35239,2471, 35240,2472, 35231,2463, 2473,2473, 35121,2353, 35120,2352, 35119,2351, 35118,2350, 
14, // chain 204
2472,2472, 2473,2473, 2474,2474, 
2475,2475, 35244,2476, 34729,1961, 34728,1960, 35245,2477, 35246,2478, 35241,2473, 2353,2353, 2477,2477, 35247,2479, 35122,2354, 1957,1957, 34724,1956, 
3, // chain 205
2480,2480, 2481,2481, 2476,2476, 
1962,1962, 34729,1961, 
8, // chain 206
2476,2476, 2481,2481, 2475,2475, 
35250,2482, 35251,2483, 35252,2484, 35253,2485, 35248,2480, 1963,1963, 34730,1962, 
7, // chain 207
2486,2486, 2484,2484, 2487,2487, 
2488,2488, 35257,2489, 34732,1964, 34731,1963, 35253,2485, 35252,2484, 
3, // chain 208
2490,2490, 2488,2488, 2489,2489, 
1965,1965, 34732,1964, 
49, // chain 209
2491,2491, 2492,2492, 2493,2493, 
2494,2494, 35263,2495, 35264,2496, 35265,2497, 35260,2492, 2498,2498, 35267,2499, 35268,2500, 35259,2491, 2494,2494, 2501,2501, 35270,2502, 35263,2495, 2503,2503, 35272,2504, 35264,2496, 
2505,2505, 35274,2506, 35265,2497, 2498,2498, 2507,2507, 35267,2499, 2500,2500, 2508,2508, 35269,2501, 2509,2509, 35278,2510, 35279,2511, 35280,2512, 35221,2453, 35281,2513, 35270,2502, 
2514,2514, 35283,2515, 35284,2516, 35271,2503, 2517,2517, 35272,2504, 2518,2518, 35273,2505, 2519,2519, 35288,2520, 35289,2521, 35274,2506, 2507,2507, 2508,2508, 2510,2510, 35277,2509, 
2, // chain 210
2522,2522, 2523,2523, 895,895, 
896,896, 
7, // chain 211
2524,2524, 2525,2525, 2526,2526, 
2527,2527, 33670,902, 35296,2528, 2529,2529, 901,901, 33668,900, 
65, // chain 212
2265,2265, 2307,2307, 2530,2530, 
35299,2531, 35076,2308, 2532,2532, 35301,2533, 35302,2534, 35303,2535, 35077,2309, 2536,2536, 35305,2537, 35078,2310, 2311,2311, 2538,2538, 35080,2312, 2539,2539, 35137,2369, 2540,2540, 
35138,2370, 2541,2541, 35139,2371, 2542,2542, 35311,2543, 35140,2372, 2544,2544, 35141,2373, 2545,2545, 35142,2374, 2546,2546, 35143,2375, 2547,2547, 35316,2548, 35144,2376, 2549,2549, 
35145,2377, 2378,2378, 2550,2550, 35319,2551, 35147,2379, 2552,2552, 35170,2402, 2407,2407, 2553,2553, 35181,2413, 2554,2554, 35186,2418, 2443,2443, 2444,2444, 2555,2555, 35324,2556, 
35213,2445, 2557,2557, 35214,2446, 2558,2558, 35215,2447, 2448,2448, 2449,2449, 2559,2559, 35218,2450, 2560,2560, 35329,2561, 35330,2562, 35219,2451, 2452,2452, 2513,2513, 35221,2453, 
7, // chain 213
2263,2263, 2265,2265, 2563,2563, 
2564,2564, 2565,2565, 2044,2044, 35334,2566, 2567,2567, 35336,2568, 
1, // chain 214
2043,2043, 2044,2044, 2567,2567, 
3, // chain 215
902,902, 2071,2071, 2569,2569, 
2570,2570, 2527,2527, 
2, // chain 216
899,899, 2571,2571, 2572,2572, 
898,898, 
8, // chain 217
2573,2573, 2574,2574, 2575,2575, 
1085,1085, 35344,2576, 35345,2577, 35346,2578, 35347,2579, 35348,2580, 35342,2574, 
39, // chain 218
1084,1084, 1085,1085, 2576,2576, 
1082,1082, 33849,1081, 35345,2577, 1079,1079, 35349,2581, 35346,2578, 2582,2582, 35351,2583, 35347,2579, 2584,2584, 2585,2585, 2586,2586, 35355,2587, 35356,2588, 2589,2589, 2590,2590, 
2591,2591, 2592,2592, 35361,2593, 35362,2594, 2595,2595, 35364,2596, 2597,2597, 35366,2598, 2599,2599, 35368,2600, 2601,2601, 35370,2602, 2603,2603, 2604,2604, 35373,2605, 35374,2606, 
2607,2607, 2608,2608, 2609,2609, 35378,2610, 35379,2611, 35380,2612, 
10, // chain 219
2613,2613, 2614,2614, 2615,2615, 
2616,2616, 2617,2617, 2618,2618, 35387,2619, 35388,2620, 2621,2621, 35302,2534, 35390,2622, 2533,2533, 
1, // chain 220
2615,2615, 2614,2614, 2623,2623, 
3, // chain 221
2614,2614, 2624,2624, 2610,2610, 
2625,2625, 35379,2611, 
56, // chain 222
2610,2610, 2624,2624, 2626,2626, 
33684,916, 33683,915, 35395,2627, 35382,2614, 2628,2628, 35381,2613, 2618,2618, 2629,2629, 35398,2630, 35399,2631, 35387,2619, 2632,2632, 35389,2621, 2633,2633, 35402,2634, 35302,2534, 
2535,2535, 2635,2635, 35304,2536, 2636,2636, 35405,2637, 35305,2537, 2538,2538, 2638,2638, 35307,2539, 2540,2540, 2639,2639, 35309,2541, 2640,2640, 35310,2542, 2641,2641, 35410,2642, 
35311,2543, 2643,2643, 35312,2544, 2644,2644, 35313,2545, 2645,2645, 35314,2546, 2646,2646, 35315,2547, 2647,2647, 35416,2648, 35316,2548, 2649,2649, 35317,2549, 2550,2550, 2650,2650, 
35419,2651, 35319,2551, 2552,2552, 2652,2652, 35321,2553, 2555,2555, 35322,2554, 
20, // chain 223
2609,2609, 2610,2610, 2626,2626, 
2653,2653, 35422,2654, 33684,916, 917,917, 2655,2655, 35424,2656, 33686,918, 919,919, 1088,1088, 2657,2657, 33857,1089, 2658,2658, 33858,1090, 2659,2659, 33859,1091, 1094,1094, 
2660,2660, 33845,1077, 33844,1076, 
8, // chain 224
2605,2605, 2609,2609, 2653,2653, 
2661,2661, 35430,2662, 35422,2654, 2655,2655, 2663,2663, 35425,2657, 35424,2656, 
18, // chain 225
2604,2604, 2605,2605, 2661,2661, 
2664,2664, 35430,2662, 2665,2665, 35431,2663, 2666,2666, 35425,2657, 2658,2658, 2667,2667, 35436,2668, 35427,2659, 2669,2669, 35438,2670, 35439,2671, 35428,2660, 2672,2672, 33846,1078, 
33845,1077, 
20, // chain 226
2601,2601, 2604,2604, 2664,2664, 
2673,2673, 35433,2665, 2674,2674, 35434,2666, 2667,2667, 2675,2675, 35436,2668, 2676,2676, 35437,2669, 2677,2677, 35438,2670, 2678,2678, 35439,2671, 2672,2672, 2679,2679, 35350,2582, 
35349,2581, 33846,1078, 1079,1079, 
16, // chain 227
2599,2599, 2601,2601, 2673,2673, 
2680,2680, 35442,2674, 2675,2675, 2681,2681, 35444,2676, 2682,2682, 35445,2677, 2683,2683, 35452,2684, 35446,2678, 2685,2685, 35447,2679, 2586,2586, 35351,2583, 35350,2582, 
11, // chain 228
2597,2597, 2599,2599, 2680,2680, 
2681,2681, 2595,2595, 35450,2682, 2593,2593, 35451,2683, 2592,2592, 35452,2684, 2587,2587, 35453,2685, 2586,2586, 
1, // chain 229
1081,1081, 1079,1079, 1080,1080, 
3, // chain 230
2466,2466, 2454,2454, 2455,2455, 
2459,2459, 35224,2456, 
18, // chain 231
1966,1966, 1967,1967, 2686,2686, 
2687,2687, 35456,2688, 35457,2689, 34735,1967, 1968,1968, 2690,2690, 34737,1969, 1970,1970, 2691,2691, 35460,2692, 34739,1971, 2693,2693, 34740,1972, 2694,2694, 35463,2695, 34571,1803, 
34570,1802, 
77, // chain 232
2688,2688, 2689,2689, 2696,2696, 
35458,2690, 2691,2691, 2697,2697, 35466,2698, 35460,2692, 2699,2699, 35461,2693, 2694,2694, 2700,2700, 35469,2701, 35463,2695, 2702,2702, 34571,1803, 2703,2703, 34572,1804, 2704,2704, 
35473,2705, 35474,2706, 34573,1805, 2707,2707, 35476,2708, 34574,1806, 1807,1807, 2709,2709, 34576,1808, 2710,2710, 34577,1809, 2711,2711, 34578,1810, 2712,2712, 34579,1811, 2713,2713, 
34580,1812, 2714,2714, 34581,1813, 1814,1814, 2715,2715, 35484,2716, 34583,1815, 2717,2717, 34584,1816, 1817,1817, 2718,2718, 35487,2719, 34586,1818, 1819,1819, 2720,2720, 34588,1820, 
2721,2721, 35490,2722, 34589,1821, 2723,2723, 34590,1822, 2724,2724, 34591,1823, 2725,2725, 34592,1824, 2726,2726, 34593,1825, 2727,2727, 34594,1826, 2728,2728, 34595,1827, 1828,1828, 
2729,2729, 34597,1829, 1830,1830, 2730,2730, 34599,1831, 2731,2731, 35397,2629, 34600,1832, 2627,2627, 34601,1833, 915,915, 33682,914, 
26, // chain 233
2732,2732, 2733,2733, 2734,2734, 
2735,2735, 35504,2736, 35501,2733, 2737,2737, 35506,2738, 35466,2698, 35465,2697, 35456,2688, 35500,2732, 2739,2739, 35503,2735, 2490,2490, 35256,2488, 35254,2486, 35251,2483, 35504,2736, 
2482,2482, 35508,2740, 35505,2737, 2741,2741, 35510,2742, 35506,2738, 2700,2700, 35467,2699, 35466,2698, 
47, // chain 234
2740,2740, 2741,2741, 2743,2743, 
2744,2744, 35239,2471, 35513,2745, 35514,2746, 35509,2741, 2747,2747, 35510,2742, 2748,2748, 35468,2700, 2701,2701, 2749,2749, 35470,2702, 2750,2750, 35519,2751, 35471,2703, 2752,2752, 
35472,2704, 2753,2753, 35473,2705, 2754,2754, 35474,2706, 2755,2755, 35475,2707, 2756,2756, 35476,2708, 2709,2709, 2757,2757, 35478,2710, 2758,2758, 35479,2711, 2759,2759, 35480,2712, 
2713,2713, 2760,2760, 35529,2761, 35482,2714, 2715,2715, 2762,2762, 35531,2763, 35484,2716, 2764,2764, 35485,2717, 2718,2718, 2765,2765, 35488,2720, 35487,2719, 
72, // chain 235
2745,2745, 2746,2746, 2766,2766, 
35535,2767, 35515,2747, 2768,2768, 35516,2748, 2749,2749, 2750,2750, 2520,2520, 35287,2519, 35519,2751, 2518,2518, 35285,2517, 35537,2769, 35520,2752, 2770,2770, 35521,2753, 2515,2515, 
35539,2771, 35540,2772, 35541,2773, 35542,2774, 35522,2754, 2775,2775, 35523,2755, 2776,2776, 35524,2756, 2757,2757, 2777,2777, 35526,2758, 2778,2778, 35527,2759, 2779,2779, 35528,2760, 
2761,2761, 2780,2780, 35530,2762, 2781,2781, 35550,2782, 35531,2763, 2783,2783, 35532,2764, 2765,2765, 2784,2784, 35553,2785, 35554,2786, 35488,2720, 2721,2721, 2787,2787, 35556,2788, 
35557,2789, 35490,2722, 2790,2790, 35559,2791, 35560,2792, 35561,2793, 35491,2723, 2794,2794, 35492,2724, 2795,2795, 35493,2725, 2726,2726, 2796,2796, 35495,2727, 2797,2797, 35566,2798, 
35496,2728, 2729,2729, 2730,2730, 2799,2799, 35499,2731, 2630,2630, 35397,2629, 
9, // chain 236
2745,2745, 2766,2766, 2800,2800, 
2801,2801, 35570,2802, 35278,2510, 35534,2766, 2521,2521, 35535,2767, 2520,2520, 35536,2768, 
5, // chain 237
2802,2802, 2510,2510, 2511,2511, 
2512,2512, 2803,2803, 35222,2454, 35221,2453, 
19, // chain 238
2555,2555, 2556,2556, 2804,2804, 
35573,2805, 35325,2557, 2806,2806, 35326,2558, 2807,2807, 35576,2808, 35327,2559, 2773,2773, 35328,2560, 2561,2561, 2772,2772, 35577,2809, 35330,2562, 2772,2772, 35281,2513, 2514,2514, 
2771,2771, 35283,2515, 
13, // chain 239
2652,2652, 2555,2555, 2804,2804, 
2810,2810, 35579,2811, 35573,2805, 2812,2812, 35574,2806, 2813,2813, 35575,2807, 2814,2814, 35583,2815, 35542,2774, 35541,2773, 35576,2808, 
15, // chain 240
2651,2651, 2652,2652, 2810,2810, 
2650,2650, 35584,2816, 35579,2811, 2817,2817, 35580,2812, 2818,2818, 35581,2813, 2819,2819, 35582,2814, 2820,2820, 35589,2821, 35583,2815, 2775,2775, 35542,2774, 
38, // chain 241
2638,2638, 2639,2639, 2822,2822, 
35591,2823, 35408,2640, 2824,2824, 35409,2641, 2790,2790, 35557,2789, 35410,2642, 2788,2788, 35411,2643, 2787,2787, 35412,2644, 2825,2825, 35413,2645, 2826,2826, 35414,2646, 2827,2827, 
35415,2647, 2828,2828, 35597,2829, 35416,2648, 2830,2830, 35417,2649, 2650,2650, 2816,2816, 2831,2831, 35585,2817, 2832,2832, 35586,2818, 2833,2833, 35587,2819, 2834,2834, 35588,2820, 
2778,2778, 35545,2777, 35589,2821, 2776,2776, 35543,2775, 
9, // chain 242
2637,2637, 2638,2638, 2822,2822, 
2636,2636, 35603,2835, 35591,2823, 2836,2836, 35592,2824, 2792,2792, 35559,2791, 35558,2790, 
1, // chain 243
2627,2627, 2628,2628, 2629,2629, 
17, // chain 244
2636,2636, 2835,2835, 2837,2837, 
35606,2838, 35604,2836, 2792,2792, 2839,2839, 35561,2793, 2840,2840, 35609,2841, 35562,2794, 2842,2842, 35563,2795, 2843,2843, 35564,2796, 2844,2844, 35565,2797, 2799,2799, 35566,2798, 
5, // chain 245
2635,2635, 2636,2636, 2837,2837, 
2845,2845, 35608,2840, 35606,2838, 2839,2839, 
5, // chain 246
2634,2634, 2635,2635, 2845,2845, 
2633,2633, 35610,2842, 35609,2841, 35608,2840, 
9, // chain 247
2830,2830, 2831,2831, 2829,2829, 
35614,2846, 35600,2832, 2833,2833, 2847,2847, 35616,2848, 35602,2834, 2779,2779, 35546,2778, 
6, // chain 248
2632,2632, 2633,2633, 2842,2842, 
2843,2843, 2631,2631, 35612,2844, 2630,2630, 35567,2799, 
8, // chain 249
2829,2829, 2846,2846, 2828,2828, 
35617,2849, 35615,2847, 2782,2782, 35549,2781, 35616,2848, 2780,2780, 35547,2779, 
4, // chain 250
1965,1965, 1966,1966, 2687,2687, 
2490,2490, 35507,2739, 35456,2688, 
4, // chain 251
2482,2482, 2740,2740, 2744,2744, 
2475,2475, 35240,2472, 35239,2471, 
5, // chain 252
2470,2470, 2745,2745, 2801,2801, 
2469,2469, 35618,2850, 35571,2803, 35570,2802, 
4, // chain 253
1959,1959, 1960,1960, 2477,2477, 
2479,2479, 1958,1958, 34725,1957, 
1, // chain 254
2471,2471, 2745,2745, 2470,2470, 
1, // chain 255
2483,2483, 2484,2484, 2486,2486, 
5, // chain 256
2454,2454, 2466,2466, 2467,2467, 
2803,2803, 35236,2468, 2850,2850, 35237,2469, 
8, // chain 257
2849,2849, 2782,2782, 2784,2784, 
2828,2828, 35595,2827, 35553,2785, 2826,2826, 35593,2825, 35554,2786, 2787,2787, 
1, // chain 258
2784,2784, 2782,2782, 2783,2783, 
5, // chain 259
2769,2769, 2770,2770, 2851,2851, 
35283,2515, 2516,2516, 2769,2769, 35285,2517, 
1, // chain 260
118,118, 116,116, 117,117, 
1, // chain 261
2697,2697, 2688,2688, 2696,2696, 
1, // chain 262
2201,2201, 2241,2241, 2200,2200, 
1, // chain 263
2129,2129, 2199,2199, 2128,2128, 
3, // chain 264
2457,2457, 2458,2458, 2464,2464, 
35116,2348, 35115,2347, 
2, // chain 265
2349,2349, 2350,2350, 2464,2464, 
2348,2348, 
1, // chain 266
2339,2339, 2340,2340, 2417,2417, 

 0};


// face array: 4kb.
const uint16_t skull_2_face[2544] PROGMEM = {
19, // chain 0
2852,2852, 2853,2853, 2854,2854, 
2855,2855, 35624,2856, 35625,2857, 35626,2858, 35621,2853, 2859,2859, 35628,2860, 35629,2861, 35620,2852, 2862,2862, 35623,2855, 2863,2863, 35632,2864, 35624,2856, 2865,2865, 35634,2866, 
35635,2867, 35625,2857, 
65, // chain 1
2864,2864, 2865,2865, 2868,2868, 
2869,2869, 35638,2870, 35639,2871, 35633,2865, 2866,2866, 2872,2872, 35641,2873, 2874,2874, 35643,2875, 2876,2876, 35645,2877, 2878,2878, 35647,2879, 35648,2880, 2881,2881, 35650,2882, 
35651,2883, 2884,2884, 35653,2885, 2886,2886, 35655,2887, 2888,2888, 35657,2889, 2890,2890, 2891,2891, 2892,2892, 35661,2893, 35662,2894, 2895,2895, 2896,2896, 35665,2897, 35666,2898, 
35667,2899, 2900,2900, 2901,2901, 35670,2902, 35671,2903, 2904,2904, 35673,2905, 2906,2906, 35675,2907, 2908,2908, 2909,2909, 35678,2910, 2911,2911, 35680,2912, 35681,2913, 2914,2914, 
2915,2915, 35684,2916, 35685,2917, 2918,2918, 35687,2919, 35688,2920, 2921,2921, 35690,2922, 2923,2923, 2924,2924, 35693,2925, 2926,2926, 2927,2927, 35696,2928, 2929,2929, 35698,2930, 
5, // chain 2
2870,2870, 2871,2871, 2872,2872, 
2931,2931, 35642,2874, 2878,2878, 35644,2876, 
75, // chain 3
2932,2932, 2870,2870, 2931,2931, 
2933,2933, 35646,2878, 2934,2934, 35703,2935, 35647,2879, 2936,2936, 35705,2937, 35649,2881, 2938,2938, 35650,2882, 2939,2939, 35652,2884, 2940,2940, 35654,2886, 2941,2941, 35656,2888, 
2942,2942, 35660,2892, 2893,2893, 2943,2943, 35664,2896, 2944,2944, 35665,2897, 2945,2945, 35666,2898, 2946,2946, 35669,2901, 2947,2947, 35670,2902, 2948,2948, 35717,2949, 35672,2904, 
2906,2906, 2950,2950, 35677,2909, 2951,2951, 35679,2911, 2952,2952, 35680,2912, 2953,2953, 35683,2915, 2954,2954, 35684,2916, 2918,2918, 2919,2919, 2955,2955, 35724,2956, 35689,2921, 
2924,2924, 2957,2957, 35726,2958, 35695,2927, 2929,2929, 2959,2959, 35728,2960, 2961,2961, 35730,2962, 35731,2963, 2964,2964, 2965,2965, 2966,2966, 35735,2967, 2968,2968, 35737,2969, 
35738,2970, 2971,2971, 35740,2972, 2973,2973, 2974,2974, 35743,2975, 35744,2976, 2977,2977, 2978,2978, 35747,2979, 
74, // chain 4
2934,2934, 2935,2935, 2936,2936, 
2980,2980, 35749,2981, 35705,2937, 2982,2982, 35706,2938, 2983,2983, 35707,2939, 2940,2940, 2984,2984, 35709,2941, 2985,2985, 35710,2942, 2986,2986, 35711,2943, 2944,2944, 2987,2987, 
35756,2988, 35713,2945, 2946,2946, 2989,2989, 35715,2947, 2990,2990, 35759,2991, 35716,2948, 2949,2949, 2992,2992, 35718,2950, 2951,2951, 2993,2993, 35720,2952, 2953,2953, 2994,2994, 
35722,2954, 2995,2995, 35723,2955, 2956,2956, 2994,2994, 35764,2996, 35765,2997, 35725,2957, 2998,2998, 35767,2999, 35726,2958, 3000,3000, 35769,3001, 35727,2959, 2961,2961, 3002,3002, 
35771,3003, 35730,2962, 3004,3004, 35734,2966, 3005,3005, 35736,2968, 2969,2969, 3006,3006, 35775,3007, 35739,2971, 3008,3008, 35742,2974, 3009,3009, 35743,2975, 3010,3010, 35779,3011, 
35780,3012, 35746,2978, 3013,3013, 3014,3014, 35783,3015, 35784,3016, 3017,3017, 3018,3018, 35787,3019, 
11, // chain 5
3020,3020, 3014,3014, 3015,3015, 
3018,3018, 3014,3014, 35789,3021, 3022,3022, 35791,3023, 35792,3024, 35793,3025, 35794,3026, 3027,3027, 35796,3028, 
8, // chain 6
2932,2932, 2933,2933, 3029,3029, 
3030,3030, 35799,3031, 35800,3032, 35801,3033, 35701,2933, 2980,2980, 35702,2934, 
48, // chain 7
2870,2870, 2932,2932, 3030,3030, 
3034,3034, 35799,3031, 3035,3035, 35804,3036, 35805,3037, 35800,3032, 3038,3038, 35807,3039, 35801,3033, 2980,2980, 3040,3040, 35809,3041, 35749,2981, 3042,3042, 35811,3043, 35750,2982, 
3044,3044, 35751,2983, 3045,3045, 35752,2984, 3046,3046, 35753,2985, 3047,3047, 35816,3048, 35754,2986, 3049,3049, 35755,2987, 3050,3050, 35756,2988, 3051,3051, 35757,2989, 3052,3052, 
35821,3053, 35758,2990, 3054,3054, 35759,2991, 2992,2992, 3055,3055, 35761,2993, 3056,3056, 35825,3057, 35762,2994, 3058,3058, 35764,2996, 3059,3059, 35766,2998, 35765,2997, 
4, // chain 8
2863,2863, 2864,2864, 2869,2869, 
3035,3035, 35802,3034, 35638,2870, 
29, // chain 9
3012,3012, 3014,3014, 3060,3060, 
3061,3061, 35830,3062, 35831,3063, 35832,3064, 35782,3014, 3022,3022, 3065,3065, 35791,3023, 3066,3066, 35792,3024, 3067,3067, 35836,3068, 35837,3069, 35793,3025, 3027,3027, 3070,3070, 
3071,3071, 3072,3072, 35841,3073, 35842,3074, 3075,3075, 35844,3076, 3077,3077, 3078,3078, 35847,3079, 3080,3080, 35849,3081, 35850,3082, 
25, // chain 10
3011,3011, 3012,3012, 3061,3061, 
3083,3083, 35852,3084, 35853,3085, 35854,3086, 35830,3062, 3087,3087, 35831,3063, 3088,3088, 35857,3089, 35832,3064, 3065,3065, 3090,3090, 35834,3066, 3091,3091, 35860,3092, 35861,3093, 
35862,3094, 35835,3067, 3095,3095, 35864,3096, 35836,3068, 3097,3097, 35840,3072, 35837,3069, 
12, // chain 11
3010,3010, 3011,3011, 3083,3083, 
3009,3009, 35866,3098, 35852,3084, 3099,3099, 35868,3100, 35853,3085, 3101,3101, 35854,3086, 3087,3087, 3102,3102, 35871,3103, 
3, // chain 12
3098,3098, 3006,3006, 3007,3007, 
3009,3009, 35776,3008, 
6, // chain 13
3005,3005, 3006,3006, 3104,3104, 
3105,3105, 35874,3106, 35867,3099, 35866,3098, 35774,3006, 
5, // chain 14
3004,3004, 3005,3005, 3107,3107, 
3002,3002, 35876,3108, 35873,3105, 35773,3005, 
1, // chain 15
3002,3002, 3003,3003, 3004,3004, 
30, // chain 16
3109,3109, 2859,2859, 3110,3110, 
35879,3111, 35880,3112, 35628,2860, 2861,2861, 2862,2862, 3113,3113, 35631,2863, 3035,3035, 3114,3114, 35804,3036, 3115,3115, 35805,3037, 3116,3116, 35806,3038, 3117,3117, 35807,3039, 
3118,3118, 35808,3040, 3119,3119, 35809,3041, 3042,3042, 3120,3120, 35811,3043, 3121,3121, 35812,3044, 3122,3122, 35891,3123, 35814,3046, 35813,3045, 
10, // chain 17
3108,3108, 3105,3105, 3106,3106, 
3124,3124, 35893,3125, 35894,3126, 35895,3127, 35867,3099, 3100,3100, 3128,3128, 35870,3102, 35869,3101, 
6, // chain 18
3001,3001, 3002,3002, 3129,3129, 
3130,3130, 35899,3131, 35900,3132, 35876,3108, 35770,3002, 
9, // chain 19
3000,3000, 3001,3001, 3130,3130, 
3133,3133, 35902,3134, 35899,3131, 3135,3135, 35904,3136, 35900,3132, 3124,3124, 35876,3108, 
6, // chain 20
2999,2999, 3000,3000, 3133,3133, 
3137,3137, 35906,3138, 35902,3134, 3139,3139, 35903,3135, 
9, // chain 21
2998,2998, 2999,2999, 3137,3137, 
3059,3059, 35908,3140, 35906,3138, 3139,3139, 3141,3141, 35910,3142, 35911,3143, 35912,3144, 
19, // chain 22
3088,3088, 3089,3089, 3145,3145, 
35858,3090, 3146,3146, 35859,3091, 3147,3147, 35860,3092, 3093,3093, 3148,3148, 35862,3094, 3149,3149, 35918,3150, 35863,3095, 3151,3151, 35920,3152, 35921,3153, 35864,3096, 3073,3073, 
35865,3097, 3072,3072, 
9, // chain 23
3059,3059, 3140,3140, 3154,3154, 
35909,3141, 3155,3155, 35924,3156, 35910,3142, 3157,3157, 35926,3158, 35927,3159, 35911,3143, 
11, // chain 24
3059,3059, 3154,3154, 3058,3058, 
35825,3057, 35923,3155, 3056,3056, 35924,3156, 3157,3157, 3160,3160, 35929,3161, 35926,3158, 3162,3162, 35927,3159, 
4, // chain 25
3163,3163, 3164,3164, 3054,3054, 
3055,3055, 3160,3160, 35824,3056, 
11, // chain 26
3054,3054, 3164,3164, 3053,3053, 
35820,3052, 35933,3165, 35934,3166, 35935,3167, 35931,3163, 3168,3168, 35928,3160, 3161,3161, 3169,3169, 35930,3162, 
20, // chain 27
3170,3170, 3171,3171, 3047,3047, 
3048,3048, 3172,3172, 35817,3049, 3173,3173, 35818,3050, 3174,3174, 35819,3051, 3175,3175, 35820,3052, 3176,3176, 35933,3165, 3177,3177, 35934,3166, 3178,3178, 35947,3179, 35935,3167, 
3180,3180, 35936,3168, 3169,3169, 
18, // chain 28
3047,3047, 3171,3171, 3046,3046, 
35949,3181, 35950,3182, 35951,3183, 35938,3170, 3184,3184, 35940,3172, 3185,3185, 35941,3173, 3174,3174, 3186,3186, 35943,3175, 3187,3187, 35956,3188, 35944,3176, 3177,3177, 3189,3189, 
35946,3178, 
13, // chain 29
3046,3046, 3181,3181, 3123,3123, 
35950,3182, 3190,3190, 35959,3191, 35951,3183, 3192,3192, 35952,3184, 3193,3193, 35953,3185, 3186,3186, 3189,3189, 35955,3187, 3188,3188, 
8, // chain 30
3110,3110, 3111,3111, 3194,3194, 
35880,3112, 3195,3195, 35881,3113, 3114,3114, 3196,3196, 35965,3197, 35883,3115, 
5, // chain 31
3198,3198, 3109,3109, 3110,3110, 
3194,3194, 3195,3195, 3196,3196, 3199,3199, 
4, // chain 32
3122,3122, 3123,3123, 3190,3190, 
3200,3200, 35969,3201, 35959,3191, 
4, // chain 33
3121,3121, 3122,3122, 3200,3200, 
3202,3202, 35971,3203, 35969,3201, 
6, // chain 34
3120,3120, 3121,3121, 3202,3202, 
3119,3119, 35972,3204, 35973,3205, 35974,3206, 35971,3203, 
5, // chain 35
3118,3118, 3119,3119, 3204,3204, 
3117,3117, 35884,3116, 35975,3207, 35973,3205, 
4, // chain 36
3208,3208, 3088,3088, 3145,3145, 
3209,3209, 35914,3146, 3210,3210, 
3, // chain 37
3102,3102, 3211,3211, 3128,3128, 
35980,3212, 3127,3127, 
3, // chain 38
3126,3126, 3127,3127, 3213,3213, 
3214,3214, 3125,3125, 
1, // chain 39
3213,3213, 3127,3127, 3215,3215, 
1, // chain 40
3116,3116, 3207,3207, 3115,3115, 
2, // chain 41
3216,3216, 2858,2858, 2859,2859, 
3217,3217, 
21, // chain 42
3218,3218, 3219,3219, 3220,3220, 
3221,3221, 35990,3222, 35991,3223, 35987,3219, 3224,3224, 35993,3225, 35994,3226, 35986,3218, 3227,3227, 35996,3228, 35997,3229, 35989,3221, 3230,3230, 35999,3231, 35990,3222, 3232,3232, 
36001,3233, 35991,3223, 3234,3234, 36003,3235, 
19, // chain 43
3236,3236, 3237,3237, 3227,3227, 
3238,3238, 35996,3228, 3239,3239, 35997,3229, 3230,3230, 3240,3240, 36009,3241, 35999,3231, 3242,3242, 36000,3232, 3243,3243, 36012,3244, 36001,3233, 3245,3245, 3246,3246, 3243,3243, 
36015,3247, 36016,3248, 
19, // chain 44
3227,3227, 3237,3237, 3226,3226, 
35993,3225, 36017,3249, 36018,3250, 36004,3236, 3251,3251, 36020,3252, 36006,3238, 3253,3253, 36007,3239, 3254,3254, 36008,3240, 3255,3255, 36009,3241, 3256,3256, 36025,3257, 36010,3242, 
3247,3247, 36011,3243, 
64, // chain 45
3251,3251, 3252,3252, 3258,3258, 
36027,3259, 36028,3260, 36029,3261, 36030,3262, 36021,3253, 3254,3254, 3263,3263, 36032,3264, 36023,3255, 3265,3265, 36024,3256, 3266,3266, 3267,3267, 3268,3268, 36037,3269, 3270,3270, 
36039,3271, 3272,3272, 3273,3273, 36042,3274, 3275,3275, 36044,3276, 36045,3277, 3278,3278, 36047,3279, 3280,3280, 36049,3281, 36050,3282, 3283,3283, 36052,3284, 36053,3285, 36054,3286, 
3287,3287, 36056,3288, 3289,3289, 36058,3290, 3291,3291, 36060,3292, 3293,3293, 36062,3294, 3295,3295, 36064,3296, 3297,3297, 36066,3298, 3299,3299, 36068,3300, 3301,3301, 3302,3302, 
36071,3303, 36072,3304, 36073,3305, 3306,3306, 36075,3307, 3308,3308, 36077,3309, 3310,3310, 36079,3311, 36080,3312, 36081,3313, 3314,3314, 36083,3315, 36084,3316, 36085,3317, 
13, // chain 46
3251,3251, 3258,3258, 3250,3250, 
36086,3318, 36087,3319, 36027,3259, 3320,3320, 36089,3321, 36028,3260, 3322,3322, 36091,3323, 36029,3261, 3324,3324, 36031,3263, 36030,3262, 
12, // chain 47
3325,3325, 3326,3326, 3322,3322, 
3323,3323, 3327,3327, 36096,3328, 36092,3324, 3329,3329, 36098,3330, 36099,3331, 36031,3263, 3264,3264, 3268,3268, 36033,3265, 
16, // chain 48
3322,3322, 3326,3326, 3321,3321, 
36088,3320, 36100,3332, 36093,3325, 3333,3333, 36102,3334, 36095,3327, 3335,3335, 36104,3336, 36096,3328, 3329,3329, 3337,3337, 36038,3270, 36098,3330, 3268,3268, 36099,3331, 
9, // chain 49
3338,3338, 3339,3339, 3333,3333, 
3340,3340, 36102,3334, 3341,3341, 36110,3342, 36103,3335, 3343,3343, 36105,3337, 36104,3336, 
19, // chain 50
3333,3333, 3339,3339, 3332,3332, 
36112,3344, 36113,3345, 36114,3346, 36115,3347, 36106,3338, 3348,3348, 36117,3349, 36108,3340, 3350,3350, 36109,3341, 3351,3351, 36120,3352, 36110,3342, 3343,3343, 3275,3275, 36041,3273, 
36105,3337, 3270,3270, 
12, // chain 51
3353,3353, 3354,3354, 3348,3348, 
3355,3355, 36117,3349, 3350,3350, 3356,3356, 36125,3357, 36119,3351, 3358,3358, 36127,3359, 36044,3276, 36120,3352, 3275,3275, 
18, // chain 52
3348,3348, 3354,3354, 3347,3347, 
36128,3360, 36129,3361, 36130,3362, 36121,3353, 3355,3355, 3363,3363, 36132,3364, 36133,3365, 36124,3356, 3366,3366, 36125,3357, 3367,3367, 36126,3358, 3280,3280, 36046,3278, 36127,3359, 
3276,3276, 
10, // chain 53
3368,3368, 3369,3369, 3364,3364, 
3370,3370, 36133,3365, 3371,3371, 36140,3372, 36134,3366, 3373,3373, 36135,3367, 3281,3281, 36048,3280, 
64, // chain 54
3364,3364, 3369,3369, 3363,3363, 
36142,3374, 36143,3375, 36144,3376, 36145,3377, 36136,3368, 3378,3378, 36147,3379, 36138,3370, 3380,3380, 36149,3381, 36150,3382, 36139,3371, 3383,3383, 36152,3384, 36140,3372, 3373,3373, 
3383,3383, 36049,3281, 3283,3283, 3284,3284, 3385,3385, 36053,3285, 3287,3287, 3386,3386, 36057,3289, 3387,3387, 36059,3291, 3388,3388, 36061,3293, 3389,3389, 36063,3295, 3390,3390, 
36065,3297, 3391,3391, 36067,3299, 3302,3302, 3392,3392, 36161,3393, 36162,3394, 36071,3303, 3395,3395, 36164,3396, 36072,3304, 3397,3397, 36074,3306, 3398,3398, 36076,3308, 3399,3399, 
36078,3310, 3311,3311, 3400,3400, 36169,3401, 36080,3312, 3402,3402, 36171,3403, 36082,3314, 3404,3404, 35919,3151, 35918,3150, 36083,3315, 3405,3405, 36174,3406, 36084,3316, 
15, // chain 55
3152,3152, 3153,3153, 3075,3075, 
3407,3407, 35846,3078, 3408,3408, 35848,3080, 3081,3081, 3409,3409, 36178,3410, 3411,3411, 36180,3412, 36181,3413, 3414,3414, 3415,3415, 36184,3416, 36185,3417, 
1, // chain 56
3075,3075, 3153,3153, 3073,3073, 
35, // chain 57
3411,3411, 3412,3412, 3418,3418, 
36187,3419, 36183,3415, 3420,3420, 36184,3416, 3421,3421, 3422,3422, 3423,3423, 36192,3424, 3425,3425, 36194,3426, 3427,3427, 36196,3428, 36197,3429, 3430,3430, 3431,3431, 36200,3432, 
36201,3433, 3434,3434, 3435,3435, 36204,3436, 3437,3437, 36206,3438, 36207,3439, 3440,3440, 36209,3441, 3442,3442, 36211,3443, 3444,3444, 3445,3445, 36214,3446, 36146,3378, 36215,3447, 
3376,3376, 3377,3377, 
16, // chain 58
3419,3419, 3420,3420, 3448,3448, 
36217,3449, 36218,3450, 36191,3423, 3451,3451, 36193,3425, 3427,3427, 3452,3452, 36196,3428, 3453,3453, 36199,3431, 3454,3454, 36200,3432, 3455,3455, 36205,3437, 36203,3435, 
6, // chain 59
3455,3455, 3437,3437, 3456,3456, 
3457,3457, 36226,3458, 36227,3459, 36206,3438, 36205,3437, 
10, // chain 60
3459,3459, 3438,3438, 3460,3460, 
36208,3440, 3461,3461, 36210,3442, 3462,3462, 36213,3445, 3380,3380, 36214,3446, 3379,3379, 36146,3378, 
3, // chain 61
3363,3363, 3374,3374, 3463,3463, 
3362,3362, 36129,3361, 
1, // chain 62
3347,3347, 3360,3360, 3346,3346, 
4, // chain 63
3332,3332, 3344,3344, 3320,3320, 
36232,3464, 3319,3319, 36086,3318, 
1, // chain 64
3318,3318, 3249,3249, 3250,3250, 
23, // chain 65
3465,3465, 3466,3466, 3452,3452, 
3453,3453, 3467,3467, 36222,3454, 3455,3455, 3457,3457, 3468,3468, 36237,3469, 36226,3458, 3470,3470, 36239,3471, 36227,3459, 3460,3460, 3461,3461, 3472,3472, 36241,3473, 36230,3462, 
3380,3380, 3381,3381, 3474,3474, 36150,3382, 3385,3385, 36151,3383, 
20, // chain 66
3452,3452, 3466,3466, 3451,3451, 
36218,3450, 36217,3449, 36233,3465, 3475,3475, 36164,3396, 36163,3395, 36235,3467, 3476,3476, 36236,3468, 3393,3393, 36160,3392, 36159,3391, 36237,3469, 3390,3390, 36157,3389, 36238,3470, 
3477,3477, 36240,3472, 36239,3471, 
22, // chain 67
3404,3404, 3151,3151, 3152,3152, 
3407,3407, 3403,3403, 36176,3408, 3402,3402, 36177,3409, 3401,3401, 36179,3411, 3418,3418, 3400,3400, 36187,3419, 3478,3478, 36216,3448, 3479,3479, 36217,3449, 3475,3475, 3396,3396, 
3397,3397, 3398,3398, 3478,3478, 36167,3399, 3400,3400, 
5, // chain 68
3480,3480, 3477,3477, 3472,3472, 
3473,3473, 3474,3474, 3386,3386, 36153,3385, 
3, // chain 69
3150,3150, 3405,3405, 3481,3481, 
36250,3482, 36251,3483, 
3, // chain 70
3150,3150, 3481,3481, 3149,3149, 
36252,3484, 36250,3482, 
2, // chain 71
3394,3394, 3395,3395, 3476,3476, 
3393,3393, 
4, // chain 72
3389,3389, 3477,3477, 3388,3388, 
36248,3480, 3387,3387, 36154,3386, 
2, // chain 73
3484,3484, 3485,3485, 3148,3148, 
3149,3149, 
1, // chain 74
3148,3148, 3485,3485, 3147,3147, 

 0};


// face array: 8kb.
const uint16_t skull_3_face[4443] PROGMEM = {
91, // chain 0
3486,3486, 3487,3487, 3488,3488, 
36257,3489, 3490,3490, 36259,3491, 36260,3492, 3493,3493, 3494,3494, 36263,3495, 36264,3496, 3497,3497, 36266,3498, 3499,3499, 36268,3500, 3501,3501, 36270,3502, 3503,3503, 36272,3504, 
3505,3505, 36274,3506, 3507,3507, 36276,3508, 3509,3509, 36278,3510, 3511,3511, 36280,3512, 3513,3513, 3514,3514, 36283,3515, 36284,3516, 3517,3517, 3518,3518, 36287,3519, 3520,3520, 
36289,3521, 3522,3522, 36291,3523, 36292,3524, 3525,3525, 36294,3526, 3527,3527, 36296,3528, 3529,3529, 36298,3530, 3531,3531, 36300,3532, 3533,3533, 36302,3534, 3535,3535, 36304,3536, 
3537,3537, 36306,3538, 3539,3539, 3540,3540, 36309,3541, 3542,3542, 3543,3543, 36312,3544, 36313,3545, 3546,3546, 36315,3547, 3548,3548, 36317,3549, 3550,3550, 3551,3551, 36320,3552, 
3553,3553, 36322,3554, 3555,3555, 36324,3556, 3557,3557, 36326,3558, 3559,3559, 36328,3560, 3561,3561, 36330,3562, 3563,3563, 36332,3564, 3565,3565, 36334,3566, 36335,3567, 3568,3568, 
3569,3569, 36338,3570, 3571,3571, 36340,3572, 36341,3573, 3574,3574, 36343,3575, 3576,3576, 36345,3577, 36346,3578, 
84, // chain 1
3486,3486, 3488,3488, 3579,3579, 
36348,3580, 36349,3581, 36258,3490, 3582,3582, 36259,3491, 3583,3583, 36262,3494, 3584,3584, 36263,3495, 3497,3497, 3585,3585, 36267,3499, 3586,3586, 36269,3501, 3587,3587, 36271,3503, 
3505,3505, 3507,3507, 3588,3588, 36357,3589, 36277,3509, 3590,3590, 36359,3591, 36279,3511, 3592,3592, 36282,3514, 3593,3593, 36283,3515, 3518,3518, 3594,3594, 36288,3520, 3522,3522, 
3595,3595, 36291,3523, 3525,3525, 3527,3527, 3596,3596, 36297,3529, 3531,3531, 3533,3533, 3597,3597, 36303,3535, 3537,3537, 3598,3598, 36308,3540, 3543,3543, 3544,3544, 3599,3599, 
36314,3546, 3548,3548, 3551,3551, 3600,3600, 36321,3553, 3555,3555, 3557,3557, 3601,3601, 36327,3559, 3602,3602, 36371,3603, 36329,3561, 3604,3604, 36373,3605, 36374,3606, 36375,3607, 
36376,3608, 36331,3563, 3609,3609, 36333,3565, 3610,3610, 36334,3566, 3569,3569, 3611,3611, 36380,3612, 36339,3571, 3613,3613, 36340,3572, 3574,3574, 3614,3614, 36344,3576, 3615,3615, 
36384,3616, 36385,3617, 36345,3577, 
69, // chain 2
3618,3618, 3486,3486, 3579,3579, 
3619,3619, 36348,3580, 3620,3620, 36389,3621, 36390,3622, 36349,3581, 3623,3623, 36350,3582, 3624,3624, 36351,3583, 3625,3625, 36352,3584, 3626,3626, 36353,3585, 3627,3627, 36396,3628, 
36397,3629, 36354,3586, 3587,3587, 3630,3630, 36356,3588, 3631,3631, 36357,3589, 3632,3632, 36358,3590, 3633,3633, 36359,3591, 3634,3634, 36360,3592, 3593,3593, 3635,3635, 36362,3594, 
3636,3636, 36363,3595, 3637,3637, 36364,3596, 3638,3638, 36365,3597, 3639,3639, 36366,3598, 3640,3640, 36367,3599, 3641,3641, 36368,3600, 3642,3642, 36369,3601, 3643,3643, 36370,3602, 
3644,3644, 36413,3645, 36414,3646, 36371,3603, 3604,3604, 3647,3647, 36416,3648, 36373,3605, 3649,3649, 36418,3650, 36374,3606, 3651,3651, 36375,3607, 3652,3652, 36376,3608, 3653,3653, 
36377,3609, 3654,3654, 36379,3611, 36378,3610, 
174, // chain 3
3655,3655, 3619,3619, 3656,3656, 
3657,3657, 36426,3658, 36427,3659, 36387,3619, 3620,3620, 3660,3660, 36389,3621, 3661,3661, 36390,3622, 3662,3662, 36391,3623, 3663,3663, 36392,3624, 3625,3625, 3664,3664, 36394,3626, 
3627,3627, 3628,3628, 3629,3629, 3665,3665, 36398,3630, 3631,3631, 3632,3632, 3666,3666, 36401,3633, 3667,3667, 36402,3634, 3668,3668, 36403,3635, 3669,3669, 36404,3636, 3670,3670, 
36439,3671, 36405,3637, 3672,3672, 36406,3638, 3673,3673, 36442,3674, 36443,3675, 36407,3639, 3640,3640, 3676,3676, 36445,3677, 36409,3641, 3678,3678, 36410,3642, 3679,3679, 36448,3680, 
36411,3643, 3681,3681, 36450,3682, 36412,3644, 3683,3683, 36452,3684, 36413,3645, 3685,3685, 36454,3686, 36455,3687, 36456,3688, 36457,3689, 36414,3646, 3647,3647, 3690,3690, 36459,3691, 
36416,3648, 3692,3692, 36417,3649, 3693,3693, 36462,3694, 36418,3650, 3695,3695, 36419,3651, 3696,3696, 36420,3652, 3697,3697, 36421,3653, 3698,3698, 36422,3654, 3699,3699, 36468,3700, 
36379,3611, 3612,3612, 3701,3701, 36381,3613, 3702,3702, 36382,3614, 3703,3703, 36383,3615, 3704,3704, 36473,3705, 36474,3706, 36384,3616, 3617,3617, 3707,3707, 3708,3708, 36477,3709, 
3710,3710, 36479,3711, 3712,3712, 36481,3713, 3714,3714, 36483,3715, 3716,3716, 3717,3717, 36486,3718, 3719,3719, 36488,3720, 3721,3721, 36490,3722, 36491,3723, 3724,3724, 36493,3725, 
3726,3726, 36495,3727, 3728,3728, 36497,3729, 3730,3730, 36499,3731, 3732,3732, 36501,3733, 3734,3734, 36503,3735, 3736,3736, 36505,3737, 3738,3738, 3739,3739, 36508,3740, 36509,3741, 
3742,3742, 36511,3743, 3744,3744, 36513,3745, 3746,3746, 36515,3747, 3748,3748, 36517,3749, 3750,3750, 36519,3751, 3752,3752, 36521,3753, 3754,3754, 36523,3755, 3756,3756, 36525,3757, 
3758,3758, 36527,3759, 3760,3760, 36529,3761, 3762,3762, 3763,3763, 36532,3764, 36533,3765, 3766,3766, 36535,3767, 36536,3768, 3769,3769, 3770,3770, 36539,3771, 3772,3772, 36541,3773, 
3774,3774, 36543,3775, 3776,3776, 36545,3777, 3778,3778, 36547,3779, 3780,3780, 36549,3781, 3782,3782, 3783,3783, 36552,3784, 36553,3785, 36554,3786, 
1, // chain 4
3655,3655, 3618,3618, 3619,3619, 
70, // chain 5
3787,3787, 3657,3657, 3658,3658, 
3788,3788, 36557,3789, 36427,3659, 3790,3790, 36428,3660, 3791,3791, 36429,3661, 3792,3792, 36561,3793, 36430,3662, 3794,3794, 36431,3663, 3795,3795, 36432,3664, 3796,3796, 36433,3665, 
3797,3797, 36434,3666, 3798,3798, 36435,3667, 3799,3799, 36436,3668, 3800,3800, 36437,3669, 3801,3801, 36438,3670, 3802,3802, 36439,3671, 3803,3803, 36440,3672, 3804,3804, 36441,3673, 
3805,3805, 36442,3674, 3806,3806, 36443,3675, 3807,3807, 36444,3676, 3808,3808, 36445,3677, 3809,3809, 36446,3678, 3810,3810, 36447,3679, 3811,3811, 36448,3680, 3812,3812, 36449,3681, 
3813,3813, 36450,3682, 3814,3814, 36451,3683, 3815,3815, 36584,3816, 36452,3684, 3817,3817, 36586,3818, 36453,3685, 3819,3819, 36588,3820, 36589,3821, 36454,3686, 3822,3822, 36591,3823, 
36455,3687, 3824,3824, 36456,3688, 3690,3690, 36457,3689, 
83, // chain 6
3825,3825, 3787,3787, 3788,3788, 
3826,3826, 36595,3827, 36557,3789, 3828,3828, 36597,3829, 36598,3830, 36558,3790, 3791,3791, 3829,3829, 36596,3828, 36599,3831, 36600,3832, 36560,3792, 3833,3833, 36602,3834, 36561,3793, 
3835,3835, 36562,3794, 3836,3836, 36563,3795, 3837,3837, 36564,3796, 3838,3838, 36565,3797, 3839,3839, 36566,3798, 3840,3840, 36567,3799, 3841,3841, 36568,3800, 3842,3842, 36569,3801, 
3843,3843, 36570,3802, 3844,3844, 36571,3803, 3845,3845, 36572,3804, 3846,3846, 36573,3805, 3847,3847, 36574,3806, 3848,3848, 36575,3807, 3849,3849, 36576,3808, 3850,3850, 36577,3809, 
3851,3851, 36578,3810, 3852,3852, 36579,3811, 3853,3853, 36580,3812, 3854,3854, 36581,3813, 3855,3855, 36582,3814, 3856,3856, 36583,3815, 3857,3857, 36626,3858, 36584,3816, 3817,3817, 
3859,3859, 36628,3860, 36586,3818, 3861,3861, 36587,3819, 3862,3862, 36631,3863, 36588,3820, 3864,3864, 36633,3865, 36589,3821, 3822,3822, 3866,3866, 36591,3823, 3867,3867, 36592,3824, 
3691,3691, 36458,3690, 
122, // chain 7
3868,3868, 3825,3825, 3826,3826, 
3869,3869, 36638,3870, 36595,3827, 3871,3871, 36640,3872, 36596,3828, 3831,3831, 3871,3871, 36641,3873, 36642,3874, 36643,3875, 36600,3832, 3876,3876, 36601,3833, 3877,3877, 36646,3878, 
36602,3834, 3879,3879, 36603,3835, 3880,3880, 36604,3836, 3881,3881, 36605,3837, 3882,3882, 36606,3838, 3883,3883, 36607,3839, 3884,3884, 36608,3840, 3885,3885, 36609,3841, 3886,3886, 
36610,3842, 3887,3887, 36611,3843, 3888,3888, 36612,3844, 3889,3889, 36613,3845, 3890,3890, 36614,3846, 3891,3891, 36615,3847, 3892,3892, 36616,3848, 3893,3893, 36617,3849, 3894,3894, 
36618,3850, 3895,3895, 36619,3851, 3896,3896, 36620,3852, 3897,3897, 36621,3853, 3898,3898, 36622,3854, 3899,3899, 36623,3855, 3900,3900, 36624,3856, 3901,3901, 36625,3857, 3902,3902, 
36671,3903, 36626,3858, 3859,3859, 3904,3904, 36673,3905, 36628,3860, 3906,3906, 36629,3861, 3907,3907, 36630,3862, 3908,3908, 36631,3863, 3909,3909, 36678,3910, 36679,3911, 36632,3864, 
3912,3912, 36681,3913, 36633,3865, 3866,3866, 3914,3914, 36683,3915, 36635,3867, 3916,3916, 36459,3691, 3692,3692, 3917,3917, 36461,3693, 3918,3918, 36687,3919, 36462,3694, 3920,3920, 
36463,3695, 3921,3921, 36464,3696, 3922,3922, 36465,3697, 3923,3923, 36466,3698, 3924,3924, 36467,3699, 3925,3925, 36694,3926, 36468,3700, 3701,3701, 3927,3927, 36470,3702, 3928,3928, 
36471,3703, 3929,3929, 36472,3704, 3930,3930, 36699,3931, 36473,3705, 3932,3932, 36476,3708, 36474,3706, 
7, // chain 8
3933,3933, 3868,3868, 3869,3869, 
3934,3934, 36638,3870, 3935,3935, 36704,3936, 36641,3873, 36639,3871, 
141, // chain 9
3937,3937, 3933,3933, 3934,3934, 
3935,3935, 3938,3938, 36707,3939, 36704,3936, 3940,3940, 36709,3941, 36641,3873, 3874,3874, 3942,3942, 36711,3943, 36643,3875, 3944,3944, 36644,3876, 3945,3945, 36645,3877, 3946,3946, 
36715,3947, 36646,3878, 3948,3948, 36647,3879, 3949,3949, 36648,3880, 3950,3950, 36649,3881, 3951,3951, 36650,3882, 3952,3952, 36651,3883, 3953,3953, 36652,3884, 3954,3954, 36653,3885, 
3955,3955, 36654,3886, 3956,3956, 36655,3887, 3957,3957, 36656,3888, 3958,3958, 36657,3889, 3959,3959, 36658,3890, 3960,3960, 36659,3891, 3961,3961, 36660,3892, 3962,3962, 36661,3893, 
3963,3963, 36662,3894, 3964,3964, 36663,3895, 3965,3965, 36664,3896, 3966,3966, 36665,3897, 3967,3967, 36666,3898, 3968,3968, 36667,3899, 3969,3969, 36668,3900, 3970,3970, 36669,3901, 
3971,3971, 36670,3902, 3972,3972, 36741,3973, 36671,3903, 3904,3904, 3974,3974, 36743,3975, 36744,3976, 36745,3977, 36746,3978, 36673,3905, 3979,3979, 36674,3906, 3980,3980, 36675,3907, 
3981,3981, 36676,3908, 3982,3982, 36677,3909, 3983,3983, 36678,3910, 3984,3984, 36745,3977, 36744,3976, 36753,3985, 36754,3986, 36679,3911, 3912,3912, 3985,3985, 36755,3987, 36756,3988, 
36681,3913, 3914,3914, 3989,3989, 36758,3990, 36683,3915, 3991,3991, 36684,3916, 3917,3917, 3992,3992, 36686,3918, 3993,3993, 36762,3994, 36687,3919, 3995,3995, 36688,3920, 3996,3996, 
36689,3921, 3997,3997, 36690,3922, 3998,3998, 36691,3923, 3999,3999, 36768,4000, 36692,3924, 3925,3925, 4001,4001, 36770,4002, 36694,3926, 3927,3927, 4003,4003, 36696,3928, 4004,4004, 
36697,3929, 4005,4005, 36698,3930, 4006,4006, 36775,4007, 36699,3931, 4008,4008, 36700,3932, 4009,4009, 36480,3712, 36478,3710, 36476,3708, 
79, // chain 10
4010,4010, 3938,3938, 3939,3939, 
4011,4011, 36780,4012, 36708,3940, 4013,4013, 36709,3941, 3942,3942, 4014,4014, 36783,4015, 36784,4016, 36711,3943, 4017,4017, 36712,3944, 4018,4018, 36713,3945, 4019,4019, 36714,3946, 
4020,4020, 36789,4021, 36715,3947, 4022,4022, 36716,3948, 4023,4023, 36717,3949, 4024,4024, 36718,3950, 4025,4025, 36719,3951, 4026,4026, 36720,3952, 4027,4027, 36721,3953, 4028,4028, 
36722,3954, 4029,4029, 36723,3955, 4030,4030, 36724,3956, 4031,4031, 36725,3957, 4032,4032, 36726,3958, 4033,4033, 36727,3959, 4034,4034, 36728,3960, 4035,4035, 36729,3961, 4036,4036, 
36730,3962, 4037,4037, 36731,3963, 4038,4038, 36732,3964, 4039,4039, 36733,3965, 4040,4040, 36734,3966, 4041,4041, 36735,3967, 4042,4042, 36736,3968, 4043,4043, 36737,3969, 4044,4044, 
36738,3970, 4045,4045, 36739,3971, 4046,4046, 36740,3972, 4047,4047, 36816,4048, 36741,3973, 3974,3974, 4049,4049, 36818,4050, 36753,3985, 36743,3975, 3976,3976, 
89, // chain 11
4010,4010, 4011,4011, 4051,4051, 
4052,4052, 36821,4053, 36822,4054, 36823,4055, 36779,4011, 4056,4056, 36780,4012, 4013,4013, 4055,4055, 36825,4057, 36782,4014, 4058,4058, 36783,4015, 4059,4059, 36828,4060, 36829,4061, 
36784,4016, 4017,4017, 4062,4062, 36786,4018, 4063,4063, 36787,4019, 4064,4064, 36788,4020, 4065,4065, 36834,4066, 36789,4021, 4067,4067, 36790,4022, 4068,4068, 36791,4023, 4069,4069, 
36792,4024, 4070,4070, 36793,4025, 4071,4071, 36794,4026, 4072,4072, 36795,4027, 4073,4073, 36796,4028, 4074,4074, 36797,4029, 4075,4075, 36798,4030, 4076,4076, 36799,4031, 4077,4077, 
36800,4032, 4078,4078, 36801,4033, 4079,4079, 36802,4034, 4080,4080, 36803,4035, 4081,4081, 36804,4036, 4082,4082, 36805,4037, 4083,4083, 36806,4038, 4084,4084, 36807,4039, 4085,4085, 
36808,4040, 4086,4086, 36809,4041, 4087,4087, 36810,4042, 4088,4088, 36811,4043, 4089,4089, 36812,4044, 4090,4090, 36813,4045, 4091,4091, 36814,4046, 4092,4092, 36815,4047, 4093,4093, 
36816,4048, 4049,4049, 4050,4050, 4094,4094, 36863,4095, 36864,4096, 36755,3987, 36753,3985, 
6, // chain 12
4097,4097, 4052,4052, 4053,4053, 
4098,4098, 36822,4054, 4099,4099, 36825,4057, 36823,4055, 
5, // chain 13
4100,4100, 4098,4098, 4101,4101, 
4102,4102, 36871,4103, 36867,4099, 36866,4098, 
1, // chain 14
4100,4100, 4097,4097, 4098,4098, 
2, // chain 15
4103,4103, 4104,4104, 4105,4105, 
4102,4102, 
5, // chain 16
4106,4106, 4105,4105, 4104,4104, 
4107,4107, 36876,4108, 36867,4099, 36871,4103, 
106, // chain 17
4109,4109, 4106,4106, 4107,4107, 
4110,4110, 36876,4108, 4111,4111, 36880,4112, 36881,4113, 36867,4099, 4057,4057, 4058,4058, 4114,4114, 36827,4059, 4115,4115, 36884,4116, 36828,4060, 4117,4117, 36886,4118, 36829,4061, 
4062,4062, 4119,4119, 36831,4063, 4120,4120, 36832,4064, 4121,4121, 36833,4065, 4122,4122, 36891,4123, 36834,4066, 4124,4124, 36835,4067, 4125,4125, 36836,4068, 4126,4126, 36837,4069, 
4127,4127, 36838,4070, 4128,4128, 36839,4071, 4129,4129, 36840,4072, 4130,4130, 36841,4073, 4131,4131, 36842,4074, 4132,4132, 36843,4075, 4133,4133, 36844,4076, 4001,4001, 36845,4077, 
4000,4000, 36846,4078, 3999,3999, 36847,4079, 3998,3998, 36848,4080, 3997,3997, 36849,4081, 3996,3996, 36850,4082, 3995,3995, 36851,4083, 3994,3994, 36852,4084, 3993,3993, 36853,4085, 
4134,4134, 36854,4086, 4135,4135, 36855,4087, 4136,4136, 36856,4088, 4137,4137, 36857,4089, 4138,4138, 36858,4090, 4139,4139, 36859,4091, 4140,4140, 36909,4141, 36910,4142, 36860,4092, 
4143,4143, 36912,4144, 36861,4093, 4145,4145, 36862,4094, 4146,4146, 36915,4147, 36916,4148, 36863,4095, 4149,4149, 36918,4150, 36864,4096, 4151,4151, 36920,4152, 36755,3987, 3988,3988, 
3989,3989, 4153,4153, 36922,4154, 36758,3990, 4155,4155, 36759,3991, 3992,3992, 4134,4134, 36761,3993, 
12, // chain 18
4156,4156, 4109,4109, 4110,4110, 
4157,4157, 36879,4111, 4158,4158, 36927,4159, 36928,4160, 36929,4161, 36880,4112, 4162,4162, 36931,4163, 36882,4114, 36881,4113, 
18, // chain 19
4156,4156, 4157,4157, 4158,4158, 
4164,4164, 36933,4165, 36927,4159, 4166,4166, 36935,4167, 36928,4160, 4168,4168, 36937,4169, 36938,4170, 36929,4161, 4171,4171, 36930,4162, 4172,4172, 36941,4173, 36931,4163, 4115,4115, 
36882,4114, 
57, // chain 20
4174,4174, 4166,4166, 4167,4167, 
4168,4168, 4175,4175, 36944,4176, 36937,4169, 4177,4177, 36946,4178, 36947,4179, 36948,4180, 36938,4170, 4181,4181, 36939,4171, 4182,4182, 36940,4172, 4183,4183, 36952,4184, 36941,4173, 
4185,4185, 36883,4115, 4116,4116, 4186,4186, 36885,4117, 4187,4187, 36956,4188, 36886,4118, 4119,4119, 4189,4189, 36888,4120, 4190,4190, 36889,4121, 4191,4191, 36890,4122, 4192,4192, 
36961,4193, 36891,4123, 4194,4194, 36892,4124, 4195,4195, 36893,4125, 4196,4196, 36894,4126, 4197,4197, 36895,4127, 4198,4198, 36896,4128, 4199,4199, 36897,4129, 4006,4006, 36898,4130, 
4005,4005, 36899,4131, 4004,4004, 36900,4132, 4003,4003, 36901,4133, 4002,4002, 36769,4001, 
54, // chain 21
4200,4200, 4176,4176, 4177,4177, 
4201,4201, 36946,4178, 4202,4202, 36971,4203, 36972,4204, 36947,4179, 4205,4205, 36974,4206, 36975,4207, 36976,4208, 36948,4180, 4209,4209, 36978,4210, 36949,4181, 4211,4211, 36950,4182, 
4212,4212, 36951,4183, 4213,4213, 36982,4214, 36952,4184, 4215,4215, 36953,4185, 4186,4186, 4216,4216, 36955,4187, 4217,4217, 36986,4218, 36956,4188, 4189,4189, 4219,4219, 36958,4190, 
4220,4220, 36959,4191, 4221,4221, 36960,4192, 4222,4222, 36991,4223, 36961,4193, 4224,4224, 36962,4194, 4225,4225, 36963,4195, 4226,4226, 36964,4196, 4227,4227, 36965,4197, 4228,4228, 
36966,4198, 4229,4229, 36967,4199, 4007,4007, 36774,4006, 
1, // chain 22
4200,4200, 4175,4175, 4176,4176, 
57, // chain 23
4230,4230, 4203,4203, 4204,4204, 
4205,4205, 4231,4231, 36974,4206, 4232,4232, 37001,4233, 36975,4207, 4234,4234, 37003,4235, 37004,4236, 37005,4237, 36976,4208, 4238,4238, 36977,4209, 4239,4239, 37008,4240, 36978,4210, 
4211,4211, 4241,4241, 36980,4212, 4242,4242, 36981,4213, 4243,4243, 37012,4244, 36982,4214, 4245,4245, 36983,4215, 4216,4216, 4246,4246, 36985,4217, 4247,4247, 37016,4248, 36986,4218, 
4219,4219, 4249,4249, 36988,4220, 4250,4250, 36989,4221, 4251,4251, 36990,4222, 4252,4252, 37021,4253, 36991,4223, 4254,4254, 36992,4224, 4255,4255, 36993,4225, 4256,4256, 36994,4226, 
4257,4257, 36995,4227, 4258,4258, 36996,4228, 4259,4259, 36997,4229, 4008,4008, 36775,4007, 
59, // chain 24
4232,4232, 4233,4233, 4234,4234, 
4260,4260, 37029,4261, 37003,4235, 4262,4262, 37031,4263, 37004,4236, 4264,4264, 37033,4265, 37034,4266, 37005,4237, 4267,4267, 37036,4268, 37006,4238, 4269,4269, 37007,4239, 4270,4270, 
37039,4271, 37008,4240, 4241,4241, 4272,4272, 37010,4242, 4273,4273, 37011,4243, 4274,4274, 37043,4275, 37012,4244, 4276,4276, 37013,4245, 4246,4246, 4277,4277, 37015,4247, 4278,4278, 
37047,4279, 37016,4248, 4249,4249, 4280,4280, 37018,4250, 4281,4281, 37019,4251, 4282,4282, 37020,4252, 4283,4283, 37052,4284, 37021,4253, 4285,4285, 37022,4254, 4286,4286, 37023,4255, 
4287,4287, 37024,4256, 4288,4288, 37025,4257, 4289,4289, 37026,4258, 4290,4290, 37027,4259, 4009,4009, 36776,4008, 
6, // chain 25
4291,4291, 4263,4263, 4292,4292, 
4293,4293, 37062,4294, 37063,4295, 37032,4264, 37031,4263, 
1, // chain 26
4291,4291, 4262,4262, 4263,4263, 
79, // chain 27
4296,4296, 4293,4293, 4294,4294, 
4297,4297, 37066,4298, 37067,4299, 37063,4295, 4300,4300, 37069,4301, 37032,4264, 4302,4302, 37033,4265, 4303,4303, 37072,4304, 37073,4305, 37034,4266, 4306,4306, 37075,4307, 37035,4267, 
4308,4308, 37077,4309, 37036,4268, 4269,4269, 4310,4310, 37038,4270, 4311,4311, 37080,4312, 37039,4271, 4272,4272, 4313,4313, 37041,4273, 4314,4314, 37042,4274, 4315,4315, 37084,4316, 
37043,4275, 4317,4317, 37044,4276, 4277,4277, 4318,4318, 37046,4278, 4319,4319, 37088,4320, 37047,4279, 4280,4280, 4321,4321, 37049,4281, 4322,4322, 37050,4282, 4323,4323, 37051,4283, 
3756,3756, 36522,3754, 36520,3752, 36518,3750, 36516,3748, 36514,3746, 37052,4284, 3744,3744, 37053,4285, 3742,3742, 37054,4286, 3740,3740, 36507,3739, 37055,4287, 3736,3736, 36502,3734, 
36500,3732, 36498,3730, 37056,4288, 3728,3728, 36494,3726, 37057,4289, 3724,3724, 36490,3722, 37058,4290, 3721,3721, 36485,3717, 36777,4009, 3714,3714, 36480,3712, 
66, // chain 28
4324,4324, 4297,4297, 4325,4325, 
4326,4326, 37095,4327, 37096,4328, 37097,4329, 37098,4330, 37065,4297, 4331,4331, 37066,4298, 4332,4332, 37101,4333, 37067,4299, 4334,4334, 37068,4300, 4335,4335, 37104,4336, 37069,4301, 
4337,4337, 37070,4302, 4303,4303, 4338,4338, 37107,4339, 37072,4304, 4340,4340, 37109,4341, 37110,4342, 37073,4305, 4306,4306, 4343,4343, 37112,4344, 37113,4345, 37075,4307, 4308,4308, 
4346,4346, 37115,4347, 37077,4309, 4310,4310, 4348,4348, 37079,4311, 4349,4349, 37118,4350, 37080,4312, 4313,4313, 4351,4351, 37082,4314, 4352,4352, 37083,4315, 4353,4353, 37122,4354, 
37084,4316, 4355,4355, 37085,4317, 4318,4318, 4356,4356, 37087,4319, 4357,4357, 37126,4358, 37088,4320, 4321,4321, 4359,4359, 37090,4322, 4360,4360, 37091,4323, 3760,3760, 36526,3758, 
36524,3756, 
1, // chain 29
4324,4324, 4296,4296, 4297,4297, 
8, // chain 30
4327,4327, 4328,4328, 4361,4361, 
4362,4362, 37131,4363, 37132,4364, 37133,4365, 37134,4366, 37097,4329, 37096,4328, 
1, // chain 31
4362,4362, 4326,4326, 4327,4327, 
77, // chain 32
4367,4367, 4363,4363, 4364,4364, 
4368,4368, 37133,4365, 4369,4369, 37138,4370, 37139,4371, 37134,4366, 4372,4372, 37097,4329, 4373,4373, 37098,4330, 4374,4374, 37099,4331, 4332,4332, 4375,4375, 37144,4376, 37101,4333, 
4377,4377, 37102,4334, 4378,4378, 37103,4335, 4379,4379, 37148,4380, 37104,4336, 4381,4381, 37105,4337, 4338,4338, 4382,4382, 37107,4339, 4340,4340, 4383,4383, 37152,4384, 37109,4341, 
4385,4385, 37154,4386, 37155,4387, 37110,4342, 4388,4388, 37157,4389, 37111,4343, 4390,4390, 37112,4344, 4391,4391, 37160,4392, 37113,4345, 4346,4346, 4393,4393, 37162,4394, 37115,4347, 
4348,4348, 4395,4395, 37117,4349, 4396,4396, 37165,4397, 37118,4350, 4351,4351, 4398,4398, 37120,4352, 4399,4399, 37121,4353, 4400,4400, 37169,4401, 37122,4354, 4402,4402, 37123,4355, 
4356,4356, 4403,4403, 37125,4357, 4404,4404, 37173,4405, 37126,4358, 4359,4359, 4406,4406, 37128,4360, 3764,3764, 36531,3763, 36528,3760, 
86, // chain 33
3785,3785, 4367,4367, 4368,4368, 
3784,3784, 37137,4369, 4407,4407, 37176,4408, 37138,4370, 4409,4409, 37178,4410, 37139,4371, 4411,4411, 37140,4372, 4412,4412, 37141,4373, 4413,4413, 37142,4374, 4375,4375, 4414,4414, 
37183,4415, 37144,4376, 4416,4416, 37145,4377, 4417,4417, 37146,4378, 4418,4418, 37147,4379, 4419,4419, 37188,4420, 37148,4380, 4421,4421, 37149,4381, 4422,4422, 37150,4382, 4383,4383, 
4423,4423, 37192,4424, 37152,4384, 4385,4385, 4425,4425, 37194,4426, 37154,4386, 4427,4427, 37196,4428, 37155,4387, 4429,4429, 37198,4430, 37156,4388, 4431,4431, 37200,4432, 37157,4389, 
4390,4390, 4433,4433, 37159,4391, 4434,4434, 37203,4435, 37160,4392, 4393,4393, 4436,4436, 37205,4437, 37162,4394, 4395,4395, 4438,4438, 37164,4396, 4439,4439, 37208,4440, 37165,4397, 
4398,4398, 4441,4441, 37167,4399, 4442,4442, 37168,4400, 4409,4409, 37211,4443, 37169,4401, 4444,4444, 37170,4402, 4403,4403, 4445,4445, 37172,4404, 4446,4446, 37215,4447, 37173,4405, 
4406,4406, 3770,3770, 36535,3767, 36534,3766, 36532,3764, 
43, // chain 34
4425,4425, 4426,4426, 4448,4448, 
4449,4449, 37218,4450, 37219,4451, 37220,4452, 37221,4453, 37222,4454, 37194,4426, 4427,4427, 4455,4455, 37224,4456, 37225,4457, 37196,4428, 4458,4458, 37197,4429, 4459,4459, 37228,4460, 
37198,4430, 4431,4431, 4461,4461, 37230,4462, 37200,4432, 4433,4433, 4463,4463, 37202,4434, 4464,4464, 37233,4465, 37203,4435, 4436,4436, 4466,4466, 37235,4467, 37205,4437, 4438,4438, 
4468,4468, 37207,4439, 4469,4469, 37238,4470, 37208,4440, 4441,4441, 4442,4442, 4471,4471, 37178,4410, 37177,4409, 
36, // chain 35
4454,4454, 4455,4455, 4453,4453, 
37240,4472, 37224,4456, 4473,4473, 37242,4474, 37225,4457, 4475,4475, 37226,4458, 4476,4476, 37227,4459, 4477,4477, 37246,4478, 37228,4460, 4461,4461, 4479,4479, 37248,4480, 37230,4462, 
4463,4463, 4481,4481, 37232,4464, 4482,4482, 37251,4483, 37233,4465, 4466,4466, 4484,4484, 37253,4485, 37235,4467, 4468,4468, 4486,4486, 37237,4469, 4487,4487, 37256,4488, 37238,4470, 
4471,4471, 4411,4411, 37178,4410, 
43, // chain 36
4451,4451, 4453,4453, 4489,4489, 
4490,4490, 37259,4491, 37260,4492, 37261,4493, 37221,4453, 4472,4472, 4494,4494, 37263,4495, 37241,4473, 4496,4496, 37242,4474, 4497,4497, 37243,4475, 4498,4498, 37244,4476, 4492,4492, 
37259,4491, 37245,4477, 4499,4499, 37268,4500, 37246,4478, 4479,4479, 4501,4501, 37270,4502, 37248,4480, 4481,4481, 4503,4503, 37250,4482, 4504,4504, 37273,4505, 37251,4483, 4484,4484, 
4506,4506, 37275,4507, 37253,4485, 4486,4486, 4414,4414, 37255,4487, 4413,4413, 37180,4412, 37256,4488, 4411,4411, 
1, // chain 37
4451,4451, 4452,4452, 4453,4453, 
22, // chain 38
4508,4508, 4451,4451, 4490,4490, 
4509,4509, 37259,4491, 4499,4499, 4510,4510, 37279,4511, 37268,4500, 4501,4501, 4512,4512, 37281,4513, 37270,4502, 4503,4503, 4514,4514, 37272,4504, 4515,4515, 37284,4516, 37273,4505, 
4506,4506, 4416,4416, 37183,4415, 37275,4507, 4414,4414, 
18, // chain 39
4517,4517, 4518,4518, 4508,4508, 
4519,4519, 37277,4509, 4510,4510, 4520,4520, 37289,4521, 37279,4511, 4512,4512, 4522,4522, 37291,4523, 37281,4513, 4514,4514, 4524,4524, 37283,4515, 4418,4418, 37185,4417, 37284,4516, 
4416,4416, 
15, // chain 40
4518,4518, 4517,4517, 4525,4525, 
37294,4526, 37287,4519, 4527,4527, 37288,4520, 4528,4528, 37297,4529, 37289,4521, 4522,4522, 4530,4530, 37299,4531, 37291,4523, 4524,4524, 4419,4419, 37186,4418, 
22, // chain 41
4532,4532, 4525,4525, 4526,4526, 
4527,4527, 4533,4533, 37296,4528, 4534,4534, 37303,4535, 37297,4529, 4530,4530, 4536,4536, 37305,4537, 37299,4531, 4419,4419, 4420,4420, 4538,4538, 37189,4421, 4539,4539, 37190,4422, 
4423,4423, 4540,4540, 37217,4449, 37193,4425, 37192,4424, 
13, // chain 42
4541,4541, 4525,4525, 4532,4532, 
4542,4542, 37311,4543, 37301,4533, 4544,4544, 37313,4545, 37302,4534, 4546,4546, 37303,4535, 4536,4536, 4547,4547, 37306,4538, 37305,4537, 
17, // chain 43
4548,4548, 4525,4525, 4541,4541, 
4549,4549, 37310,4542, 4550,4550, 37311,4543, 4544,4544, 4551,4551, 37313,4545, 4552,4552, 37321,4553, 37322,4554, 37314,4546, 4555,4555, 37315,4547, 4540,4540, 37307,4539, 37306,4538, 
36, // chain 44
4556,4556, 4525,4525, 4548,4548, 
4557,4557, 37317,4549, 4558,4558, 37318,4550, 4559,4559, 37319,4551, 4552,4552, 4560,4560, 37321,4553, 4561,4561, 37330,4562, 37331,4563, 37332,4564, 37333,4565, 37322,4554, 4555,4555, 
4566,4566, 37308,4540, 4449,4449, 4450,4450, 4567,4567, 37219,4451, 4508,4508, 4518,4518, 4525,4525, 4556,4556, 4565,4565, 37332,4564, 37331,4563, 37325,4557, 4562,4562, 37326,4558, 
4561,4561, 37327,4559, 4560,4560, 
6, // chain 45
4568,4568, 4492,4492, 4494,4494, 
4569,4569, 37263,4495, 4568,4568, 37265,4497, 37264,4496, 
2, // chain 46
4498,4498, 4492,4492, 4568,4568, 
4497,4497, 
9, // chain 47
4444,4444, 4445,4445, 4570,4570, 
37339,4571, 37214,4446, 3778,3778, 36544,3776, 36542,3774, 37215,4447, 3772,3772, 36538,3770, 
6, // chain 48
4443,4443, 4444,4444, 4570,4570, 
4408,4408, 37175,4407, 37339,4571, 3780,3780, 36546,3778, 
1, // chain 49
4409,4409, 4443,4443, 4408,4408, 
1, // chain 50
4565,4565, 4566,4566, 4567,4567, 
2, // chain 51
3783,3783, 3784,3784, 4407,4407, 
3780,3780, 
1, // chain 52
4052,4052, 4572,4572, 4010,4010, 
1, // chain 53
4494,4494, 4492,4492, 4493,4493, 
11, // chain 54
4146,4146, 4147,4147, 4573,4573, 
37342,4574, 36916,4148, 4149,4149, 4139,4139, 36906,4138, 36918,4150, 4151,4151, 4137,4137, 36921,4153, 36920,4152, 
14, // chain 55
4146,4146, 4573,4573, 4575,4575, 
37342,4574, 4576,4576, 37345,4577, 36907,4139, 4140,4140, 4578,4578, 36909,4141, 4579,4579, 36910,4142, 4580,4580, 36911,4143, 4145,4145, 36912,4144, 
4, // chain 56
4146,4146, 4575,4575, 4581,4581, 
37344,4576, 4578,4578, 37345,4577, 
4, // chain 57
4145,4145, 4146,4146, 4581,4581, 
4580,4580, 37346,4578, 4579,4579, 
13, // chain 58
4582,4582, 3984,3984, 3978,3978, 
3979,3979, 3980,3980, 4583,4583, 36749,3981, 4584,4584, 36750,3982, 3983,3983, 4585,4585, 36752,3984, 4584,4584, 37350,4582, 4583,4583, 
5, // chain 59
4136,4136, 4137,4137, 4153,4153, 
4154,4154, 4135,4135, 36923,4155, 4134,4134, 
1, // chain 60
3721,3721, 3717,3717, 3719,3719, 
1, // chain 61
3977,3977, 3978,3978, 3984,3984, 

 0};


// face array: 3kb.
const uint16_t skull_4_face[1956] PROGMEM = {
6, // chain 0
4586,4586, 4587,4587, 4588,4588, 
4589,4589, 37358,4590, 37359,4591, 37360,4592, 37355,4587, 
86, // chain 1
4591,4591, 4592,4592, 4593,4593, 
4594,4594, 4595,4595, 37364,4596, 4597,4597, 37366,4598, 4599,4599, 4600,4600, 37369,4601, 37370,4602, 4603,4603, 4604,4604, 37373,4605, 4606,4606, 37375,4607, 4608,4608, 37377,4609, 
37378,4610, 4611,4611, 4612,4612, 37381,4613, 4614,4614, 37383,4615, 37384,4616, 4617,4617, 37386,4618, 4619,4619, 4620,4620, 37389,4621, 37390,4622, 37391,4623, 4624,4624, 37393,4625, 
4626,4626, 37395,4627, 4628,4628, 37397,4629, 4630,4630, 37399,4631, 37400,4632, 4633,4633, 37402,4634, 4635,4635, 37404,4636, 4637,4637, 37406,4638, 4639,4639, 37408,4640, 4641,4641, 
4642,4642, 37411,4643, 37412,4644, 4645,4645, 4646,4646, 37415,4647, 37416,4648, 4649,4649, 37418,4650, 4651,4651, 37420,4652, 4653,4653, 37422,4654, 4655,4655, 4656,4656, 37425,4657, 
37426,4658, 4659,4659, 37428,4660, 4661,4661, 37430,4662, 4663,4663, 4664,4664, 37433,4665, 37434,4666, 4667,4667, 4668,4668, 37437,4669, 37438,4670, 4671,4671, 37440,4672, 4673,4673, 
37442,4674, 4675,4675, 37444,4676, 4677,4677, 37446,4678, 
45, // chain 2
4679,4679, 4586,4586, 4589,4589, 
4680,4680, 37449,4681, 37358,4590, 4682,4682, 37359,4591, 4595,4595, 4683,4683, 37365,4597, 4600,4600, 4684,4684, 37453,4685, 37369,4601, 4604,4604, 4686,4686, 37455,4687, 37374,4606, 
4688,4688, 37376,4608, 4689,4689, 37377,4609, 4612,4612, 4690,4690, 37459,4691, 37460,4692, 37461,4693, 37382,4614, 4694,4694, 37383,4615, 4695,4695, 37385,4617, 4620,4620, 4696,4696, 
37465,4697, 37389,4621, 4698,4698, 37467,4699, 37468,4700, 37390,4622, 4624,4624, 4701,4701, 37394,4626, 4702,4702, 37398,4630, 37396,4628, 
14, // chain 3
4683,4683, 4684,4684, 4703,4703, 
4704,4704, 37473,4705, 37452,4684, 4685,4685, 4686,4686, 4706,4706, 37475,4707, 37476,4708, 37477,4709, 37455,4687, 4688,4688, 4690,4690, 37457,4689, 
22, // chain 4
4708,4708, 4709,4709, 4710,4710, 
4711,4711, 37477,4709, 4690,4690, 4691,4691, 4712,4712, 37481,4713, 37460,4692, 4714,4714, 37483,4715, 37461,4693, 4694,4694, 4695,4695, 4716,4716, 37464,4696, 4717,4717, 37486,4718, 
37487,4719, 37465,4697, 4720,4720, 37467,4699, 37466,4698, 
91, // chain 5
4714,4714, 4715,4715, 4716,4716, 
4721,4721, 37490,4722, 37485,4717, 4723,4723, 37492,4724, 37493,4725, 37494,4726, 37495,4727, 37486,4718, 4728,4728, 37497,4729, 37487,4719, 4720,4720, 4730,4730, 37499,4731, 37467,4699, 
4732,4732, 37468,4700, 4701,4701, 4733,4733, 37470,4702, 4734,4734, 37398,4630, 4735,4735, 37504,4736, 37399,4631, 4633,4633, 4737,4737, 37403,4635, 4738,4738, 37405,4637, 4739,4739, 
37407,4639, 4642,4642, 4740,4740, 37509,4741, 37411,4643, 4742,4742, 37414,4646, 4743,4743, 37415,4647, 4744,4744, 37417,4649, 4745,4745, 37419,4651, 4746,4746, 37421,4653, 4656,4656, 
4747,4747, 37516,4748, 37425,4657, 4749,4749, 37427,4659, 4750,4750, 37429,4661, 4664,4664, 4751,4751, 37520,4752, 37433,4665, 4668,4668, 4753,4753, 37522,4754, 37437,4669, 4671,4671, 
4755,4755, 37524,4756, 37525,4757, 37526,4758, 37441,4673, 4759,4759, 37443,4675, 4760,4760, 37445,4677, 4761,4761, 37530,4762, 4763,4763, 4764,4764, 37533,4765, 37534,4766, 4767,4767, 
4768,4768, 37537,4769, 4770,4770, 37539,4771, 4772,4772, 37496,4728, 37541,4773, 4727,4727, 37542,4774, 4726,4726, 
51, // chain 6
4731,4731, 4732,4732, 4733,4733, 
4730,4730, 37538,4770, 37543,4775, 37544,4776, 37545,4777, 37502,4734, 4778,4778, 37503,4735, 4779,4779, 37548,4780, 37504,4736, 4737,4737, 4781,4781, 37506,4738, 4782,4782, 37507,4739, 
4740,4740, 4783,4783, 37509,4741, 4784,4784, 37510,4742, 4785,4785, 37511,4743, 4786,4786, 37512,4744, 4787,4787, 37513,4745, 4755,4755, 37514,4746, 4788,4788, 37557,4789, 37515,4747, 
4790,4790, 37516,4748, 4791,4791, 37517,4749, 4750,4750, 4792,4792, 37519,4751, 4793,4793, 37562,4794, 37520,4752, 4753,4753, 4790,4790, 37557,4789, 37556,4788, 37563,4795, 37522,4754, 
4755,4755, 4788,4788, 
3, // chain 7
4779,4779, 4780,4780, 4781,4781, 
4783,4783, 37550,4782, 
12, // chain 8
4783,4783, 4784,4784, 4796,4796, 
4761,4761, 37528,4760, 37527,4759, 37565,4797, 37552,4784, 4798,4798, 37553,4785, 4786,4786, 4756,4756, 37555,4787, 4755,4755, 
5, // chain 9
4794,4794, 4790,4790, 4799,4799, 
4793,4793, 37560,4792, 37559,4791, 37558,4790, 
5, // chain 10
4800,4800, 4758,4758, 4759,4759, 
4797,4797, 4798,4798, 4757,4757, 37524,4756, 
1, // chain 11
4800,4800, 4757,4757, 4758,4758, 
5, // chain 12
4761,4761, 4764,4764, 4801,4801, 
4802,4802, 37571,4803, 37533,4765, 37532,4764, 
9, // chain 13
4783,4783, 4761,4761, 4802,4802, 
4779,4779, 37546,4778, 37571,4803, 4777,4777, 37544,4776, 37543,4775, 37536,4768, 37533,4765, 
1, // chain 14
4770,4770, 4775,4775, 4768,4768, 
3, // chain 15
4730,4730, 4770,4770, 4772,4772, 
4729,4729, 37496,4728, 
5, // chain 16
4724,4724, 4725,4725, 4804,4804, 
4805,4805, 37574,4806, 37575,4807, 37493,4725, 
156, // chain 17
4723,4723, 4724,4724, 4805,4805, 
4808,4808, 37577,4809, 37574,4806, 4810,4810, 4811,4811, 37580,4812, 37581,4813, 4814,4814, 37583,4815, 4816,4816, 4817,4817, 37586,4818, 37587,4819, 4820,4820, 37589,4821, 4822,4822, 
4823,4823, 37592,4824, 37593,4825, 4826,4826, 37595,4827, 4828,4828, 37597,4829, 4830,4830, 37599,4831, 4832,4832, 4833,4833, 37602,4834, 37603,4835, 4836,4836, 37605,4837, 4838,4838, 
4839,4839, 37608,4840, 37609,4841, 4842,4842, 37611,4843, 4844,4844, 4845,4845, 37614,4846, 37615,4847, 37616,4848, 4849,4849, 37618,4850, 4851,4851, 4852,4852, 37621,4853, 37622,4854, 
4855,4855, 4856,4856, 37625,4857, 37626,4858, 4859,4859, 4860,4860, 37629,4861, 37630,4862, 4863,4863, 4864,4864, 37633,4865, 37634,4866, 4867,4867, 4868,4868, 37637,4869, 4870,4870, 
37639,4871, 37640,4872, 4873,4873, 4874,4874, 4875,4875, 37644,4876, 4877,4877, 37646,4878, 4879,4879, 37648,4880, 37649,4881, 4882,4882, 37651,4883, 4884,4884, 4885,4885, 37654,4886, 
37655,4887, 4888,4888, 37657,4889, 4890,4890, 37659,4891, 4892,4892, 37661,4893, 4894,4894, 4895,4895, 37664,4896, 37665,4897, 4898,4898, 37667,4899, 4900,4900, 37669,4901, 4902,4902, 
37671,4903, 4904,4904, 4905,4905, 37674,4906, 4907,4907, 37676,4908, 37677,4909, 4910,4910, 37679,4911, 4912,4912, 37681,4913, 4914,4914, 37683,4915, 4916,4916, 37685,4917, 4918,4918, 
4919,4919, 37688,4920, 37689,4921, 4922,4922, 37691,4923, 4924,4924, 4925,4925, 37694,4926, 4927,4927, 37696,4928, 37697,4929, 37698,4930, 37699,4931, 4932,4932, 37701,4933, 4934,4934, 
37703,4935, 4936,4936, 4937,4937, 37706,4938, 37707,4939, 4940,4940, 37709,4941, 4942,4942, 4943,4943, 37712,4944, 4945,4945, 37714,4946, 37715,4947, 37716,4948, 4949,4949, 37718,4950, 
4951,4951, 4952,4952, 37721,4953, 37722,4954, 4955,4955, 37724,4956, 4957,4957, 4958,4958, 37727,4959, 4586,4586, 37355,4587, 
33, // chain 18
4721,4721, 4722,4722, 4723,4723, 
4808,4808, 4809,4809, 4713,4713, 37480,4712, 37579,4811, 4960,4960, 37580,4812, 4814,4814, 4707,4707, 37474,4706, 37585,4817, 4704,4704, 37586,4818, 4820,4820, 4683,4683, 37450,4682, 
37729,4961, 37730,4962, 37591,4823, 4963,4963, 37732,4964, 37592,4824, 4826,4826, 4963,4963, 37733,4965, 4966,4966, 37735,4967, 37736,4968, 37737,4969, 37734,4966, 37448,4680, 37447,4679, 
1, // chain 19
4713,4713, 4714,4714, 4721,4721, 
5, // chain 20
4961,4961, 4962,4962, 4963,4963, 
4966,4966, 4680,4680, 4681,4681, 4682,4682, 
1, // chain 21
4705,4705, 4706,4706, 4704,4704, 
3, // chain 22
4707,4707, 4708,4708, 4960,4960, 
37480,4712, 37479,4711, 
3, // chain 23
4970,4970, 4958,4958, 4679,4679, 
4967,4967, 37734,4966, 
1, // chain 24
4679,4679, 4958,4958, 4586,4586, 
10, // chain 25
4971,4971, 4955,4955, 4970,4970, 
4972,4972, 37735,4967, 4968,4968, 4833,4833, 37741,4973, 37737,4969, 4974,4974, 37594,4826, 37734,4966, 
1, // chain 26
4970,4970, 4955,4955, 4958,4958, 
21, // chain 27
4975,4975, 4953,4953, 4971,4971, 
4972,4972, 4833,4833, 4976,4976, 37602,4834, 4977,4977, 37604,4836, 4839,4839, 4978,4978, 37747,4979, 37608,4840, 4980,4980, 37610,4842, 4845,4845, 4981,4981, 37750,4982, 37751,4983, 
37614,4846, 4984,4984, 37617,4849, 37615,4847, 
1, // chain 28
4971,4971, 4953,4953, 4955,4955, 
24, // chain 29
4985,4985, 4952,4952, 4953,4953, 
4975,4975, 4976,4976, 4986,4986, 37745,4977, 4987,4987, 37746,4978, 4988,4988, 37757,4989, 37747,4979, 4990,4990, 37748,4980, 4991,4991, 37749,4981, 4992,4992, 37761,4993, 37762,4994, 
37750,4982, 4995,4995, 37764,4996, 37751,4983, 4984,4984, 4852,4852, 37617,4849, 
103, // chain 30
4952,4952, 4985,4985, 4997,4997, 
37754,4986, 4946,4946, 37755,4987, 4988,4988, 4945,4945, 37766,4998, 37757,4989, 4999,4999, 37758,4990, 4991,4991, 5000,5000, 37760,4992, 4937,4937, 37761,4993, 5001,5001, 37770,5002, 
37771,5003, 37762,4994, 4995,4995, 4929,4929, 37772,5004, 37764,4996, 4852,4852, 5005,5005, 37774,5006, 37621,4853, 4856,4856, 5007,5007, 37625,4857, 5008,5008, 37628,4860, 5009,5009, 
37778,5010, 37779,5011, 37629,4861, 4864,4864, 5012,5012, 37781,5013, 37633,4865, 4868,4868, 5014,5014, 37783,5015, 37784,5016, 37638,4870, 5017,5017, 37639,4871, 4875,4875, 5018,5018, 
37645,4877, 5019,5019, 37788,5020, 37789,5021, 37790,5022, 37647,4879, 4880,4880, 5023,5023, 37792,5024, 37793,5025, 37650,4882, 4885,4885, 5026,5026, 37795,5027, 37654,4886, 5028,5028, 
37656,4888, 5029,5029, 37658,4890, 5030,5030, 37660,4892, 4895,4895, 5031,5031, 37800,5032, 37664,4896, 5033,5033, 37666,4898, 5034,5034, 37668,4900, 5035,5035, 37670,4902, 4905,4905, 
5036,5036, 37675,4907, 5037,5037, 37806,5038, 37807,5039, 37676,4908, 5040,5040, 37678,4910, 5041,5041, 37680,4912, 5042,5042, 37682,4914, 5043,5043, 37684,4916, 4919,4919, 5044,5044, 
37813,5045, 37688,4920, 5046,5046, 37690,4922, 4927,4927, 37693,4925, 
3, // chain 31
4952,4952, 4997,4997, 4949,4949, 
37715,4947, 37714,4946, 
10, // chain 32
4943,4943, 4945,4945, 4998,4998, 
5047,5047, 37767,4999, 5000,5000, 5048,5048, 37705,4937, 4938,4938, 5047,5047, 37708,4940, 4943,4943, 
6, // chain 33
4934,4934, 4937,4937, 5001,5001, 
4932,4932, 37770,5002, 4930,4930, 37697,4929, 37771,5003, 
18, // chain 34
4929,4929, 5004,5004, 4928,4928, 
37817,5049, 37773,5005, 5050,5050, 37819,5051, 37774,5006, 5007,5007, 5052,5052, 37776,5008, 5009,5009, 5053,5053, 37812,5044, 37822,5054, 37823,5055, 37778,5010, 5056,5056, 37780,5012, 
37779,5011, 
7, // chain 35
4928,4928, 5049,5049, 5057,5057, 
37818,5050, 5046,5046, 37813,5045, 37821,5053, 37819,5051, 5052,5052, 
2, // chain 36
4928,4928, 5057,5057, 4927,4927, 
37814,5046, 
1, // chain 37
5053,5053, 5044,5044, 5045,5045, 
10, // chain 38
5043,5043, 5044,5044, 5054,5054, 
5042,5042, 37826,5058, 37823,5055, 5056,5056, 5059,5059, 37828,5060, 37780,5012, 5014,5014, 37781,5013, 
7, // chain 39
5058,5058, 5059,5059, 5041,5041, 
37808,5040, 37829,5061, 37828,5060, 5038,5038, 37783,5015, 37782,5014, 
1, // chain 40
5058,5058, 5041,5041, 5042,5042, 
2, // chain 41
5061,5061, 5038,5038, 5039,5039, 
5040,5040, 
17, // chain 42
5038,5038, 5015,5015, 5037,5037, 
37804,5036, 37830,5062, 37831,5063, 37784,5016, 5064,5064, 37785,5017, 5018,5018, 5019,5019, 5065,5065, 37788,5020, 5066,5066, 37799,5031, 37835,5067, 37789,5021, 5023,5023, 37790,5022, 
11, // chain 43
5035,5035, 5036,5036, 5062,5062, 
5034,5034, 37836,5068, 37831,5063, 5069,5069, 37832,5064, 5065,5065, 5066,5066, 5070,5070, 37800,5032, 37799,5031, 
2, // chain 44
5070,5070, 5033,5033, 5068,5068, 
5069,5069, 
1, // chain 45
5068,5068, 5033,5033, 5034,5034, 
1, // chain 46
5070,5070, 5032,5032, 5033,5033, 
10, // chain 47
5030,5030, 5031,5031, 5071,5071, 
37835,5067, 5072,5072, 37791,5023, 5024,5024, 5073,5073, 37842,5074, 37843,5075, 37794,5026, 37793,5025, 
9, // chain 48
5071,5071, 5072,5072, 5029,5029, 
37796,5028, 37841,5073, 5027,5027, 37844,5076, 37842,5074, 5075,5075, 5026,5026, 5027,5027, 
1, // chain 49
5071,5071, 5029,5029, 5030,5030, 
4, // chain 50
4830,4830, 4833,4833, 4973,4973, 
4974,4974, 4828,4828, 37594,4826, 

 0};


// mesh info for object skull_4 (with tag [g lteeth])
const tgx::Mesh3D<tgx::RGB565> skull_4 = 
    {
    1, // version/id
    
    5077, // number of vertices
    0, // number of texture coords
    5077, // number of normal vectors
    850, // number of triangles
    1956, // size of faces
    
    skull_vert_array, // array of vertices
    nullptr, // array of texture coords
    skull_norm_array, // array of normal vectors        
    skull_4_face, // array of face vertex indexes   
    
    nullptr, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    nullptr, // next mesh to draw after this one    
    
    { // mesh bounding box
    0.35733712754912667, 0.8228325362969816, 
    -0.7317977159394718, -0.5418925534032287, 
    -0.29619090141314813, 0.29619090141314813
    },
    
    "skull" // model name    
    };
    

// mesh info for object skull_3 (with tag [g jaw])
const tgx::Mesh3D<tgx::RGB565> skull_3 = 
    {
    1, // version/id
    
    5077, // number of vertices
    0, // number of texture coords
    5077, // number of normal vectors
    2066, // number of triangles
    4443, // size of faces
    
    skull_vert_array, // array of vertices
    nullptr, // array of texture coords
    skull_norm_array, // array of normal vectors        
    skull_3_face, // array of face vertex indexes   
    
    nullptr, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &skull_4, // next mesh to draw after this one    
    
    { // mesh bounding box
    0.09527157511955543, 0.7915281042727962, 
    -1.0, -0.1644340683281602, 
    -0.5192714244985127, 0.5192714244985127
    },
    
    "skull" // model name    
    };
    

// mesh info for object skull_2 (with tag [g uteeth])
const tgx::Mesh3D<tgx::RGB565> skull_2 = 
    {
    1, // version/id
    
    5077, // number of vertices
    0, // number of texture coords
    5077, // number of normal vectors
    1084, // number of triangles
    2544, // size of faces
    
    skull_vert_array, // array of vertices
    nullptr, // array of texture coords
    skull_norm_array, // array of normal vectors        
    skull_2_face, // array of face vertex indexes   
    
    nullptr, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &skull_3, // next mesh to draw after this one    
    
    { // mesh bounding box
    0.3266362555608751, 0.8243161535689119, 
    -0.6349397784794806, -0.42780249277825894, 
    -0.25993749226722324, 0.25993749226722324
    },
    
    "skull" // model name    
    };
    

// mesh info for object skull_1 (with tag [ | g skull])
const tgx::Mesh3D<tgx::RGB565> skull_1 = 
    {
    1, // version/id
    
    5077, // number of vertices
    0, // number of texture coords
    5077, // number of normal vectors
    5535, // number of triangles
    12406, // size of faces
    
    skull_vert_array, // array of vertices
    nullptr, // array of texture coords
    skull_norm_array, // array of normal vectors        
    skull_1_face, // array of face vertex indexes   
    
    nullptr, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &skull_2, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.860172568680506, 0.860172568680506, 
    -0.5784611908745165, 1.0, 
    -0.67750098172644, 0.67750098172644
    },
    
    "skull" // model name    
    };
    
                
/** end of skull.h */
    
    
    