// 3D model [nanosuit]
//
// - vertices   : 4834
// - textures   : 6295
// - normals    : 4790
// - triangles  : 8807
//
// - memory size: 228kb
//
// - model bounding box: [-0.55,0.55]x[-1.0,1.0]x[-0.25,0.25]
//
// object [nanosuit_1] (tagged [ | o Nanosuit | g nanosuit_hands]) with 2444 triangles (272 chains)
// object [nanosuit_2] (tagged [g nanosuit_helmet]) with 827 triangles (121 chains)
// object [nanosuit_3] (tagged [g nanosuit_visor]) with 30 triangles (5 chains)
// object [nanosuit_4] (tagged [g nanosuit_helmet_pt]) with 26 triangles (26 chains)
// object [nanosuit_5] (tagged [g nanosuit_torso]) with 1528 triangles (195 chains)
// object [nanosuit_6] (tagged [g nanosuit_legs]) with 2803 triangles (292 chains)
// object [nanosuit_7] (tagged [g nanosuit_arms]) with 1149 triangles (137 chains)

#pragma once

#include <tgx.h>

#include "nanosuit_hands_texture.h" // texture for object [nanosuit_1]

#include "nanosuit_helmet_texture.h" // texture for object [nanosuit_2]

#include "nanosuit_visor_texture.h" // texture for object [nanosuit_3]

#include "nanosuit_helmet_pt_texture.h" // texture for object [nanosuit_4]

#include "nanosuit_torso_texture.h" // texture for object [nanosuit_5]

#include "nanosuit_legs_texture.h" // texture for object [nanosuit_6]

#include "nanosuit_arms_texture.h" // texture for object [nanosuit_7]


// vertex array: 56kb.
const tgx::fVec3 nanosuit_vert_array[4834] PROGMEM = {
{-0.44993339541139654,0.1914871144909168,0.1262267422811964},
{-0.4428488442271713,0.17931722752472337,0.11125472051938647},
{-0.44809907486441986,0.18561933645448034,0.11574190829690559},
{-0.4500190760714933,0.18915918712225074,0.12141946449048568},
{-0.45247363837803817,0.19323790986610098,0.124979792297147},
{-0.45807683022511925,0.18278864143883164,0.1344806458705155},
{-0.4631821042739022,0.18662163851598945,0.1401183255304657},
{-0.4644974910116138,0.19808775855082222,0.1326791965201797},
{-0.44654820102946124,0.16743563711923293,0.11781548804566189},
{-0.4419451557555849,0.1752164110257539,0.10647546407663193},
{-0.4439950251329937,0.1701089814886665,0.100798985627204},
{-0.4504803505686179,0.16413289016493812,0.10800208866816689},
{-0.457698542027711,0.15311080072079522,0.12128366872731348},
{-0.4549325116611918,0.15505343455506418,0.1268744665166447},
{-0.4564440478345965,0.1612321417793988,0.1369686182457774},
{-0.4519644042661425,0.17883062604002323,0.13081362139279032},
{-0.4562134105860342,0.17113283843321872,0.1361285166791685},
{-0.4638454557995569,0.17758960364881074,0.14334185828957693},
{-0.44927381599027444,0.16531679211608602,0.08492165877757948},
{-0.44338879404740356,0.17094800531112325,0.09131052611158533},
{-0.4554395902847832,0.14441448315701444,0.10621141675935268},
{-0.4613300009484149,0.14152720657337708,0.10240967426260747},
{-0.45585991050412566,0.1464659691506515,0.11253561944422891},
{-0.4573849184794324,0.1429401291568592,0.12300590388246554},
{-0.44984879249545195,0.134874291922092,0.13537679013303677},
{-0.4450948630402732,0.14447968667822014,0.1656376904373917},
{-0.4502410913668383,0.15510193304191125,0.15808863152358538},
{-0.4628129769017874,0.16907380823051668,0.14771588293111923},
{-0.4468327254856316,0.1610672469241182,0.07796158704292871},
{-0.4550591465990706,0.16199895674366074,0.07466207332109016},
{-0.4610578705499944,0.1358577334609383,0.09391327823905228},
{-0.46384114482294825,0.1292048188096532,0.09603266211427537},
{-0.461875339489408,0.12270278833967059,0.1074271121629894},
{-0.46330927808385713,0.12439646327479022,0.11590518653595785},
{-0.45272475276549157,0.11743639154013961,0.13739109395342422},
{-0.4464398877421692,0.1292958881905108,0.1491826927222093},
{-0.4468440417992292,0.11910366174353144,0.1912066315753171},
{-0.447326871179397,0.1387008225343369,0.18557541838027988},
{-0.4572496615883363,0.16438723778484782,0.1675760132950519},
{-0.4522871886397145,0.15642109188415548,0.06812393842201013},
{-0.4587482648319151,0.15752470189596746,0.06612364527560075},
{-0.4820798091099558,0.14973261167584917,0.04684549675383461},
{-0.47313776587948236,0.14181119215747126,0.06193553150030608},
{-0.4687147038790168,0.13099602959054357,0.08381481553331092},
{-0.47397840631816734,0.15415513480423848,0.05223852849124442},
{-0.49007074312614785,0.12824778200253492,0.06904810403248754},
{-0.4830196020106396,0.12276799186087631,0.06940268185854824},
{-0.4688154729572438,0.10852290852969836,0.07998074071200091},
{-0.461828457618789,0.11570284007138974,0.09269704396333946},
{-0.49966051059206956,0.1284503979031409,0.06757967762516921},
{-0.48405261978048514,0.10558551684298571,0.06762709836786426},
{-0.47102915944578094,0.0889068872162301,0.08309326582343965},
{-0.4636821775605046,0.09470245639447153,0.12014557090263228},
{-0.460436012174198,0.10723177103541036,0.11013009449660728},
{-0.46769354129484497,0.10211571954510569,0.12845713380409202},
{-0.45620748299319736,0.10373503013372663,0.14717970521541954},
{-0.44888690583964896,0.10960819689092369,0.1669902593483528},
{-0.4484391031444264,0.10974237603786773,0.1860356151332523},
{-0.4538897941939768,0.10122927497995395,0.1829026128829225},
{-0.46719777898485126,0.08913698559271616,0.16660766017433593},
{-0.46236948518317345,0.09456450514299512,0.17570597630687257},
{-0.45774757938663435,0.09606149177034577,0.18687194459532866},
{-0.46648970107688204,0.09553501375201538,0.19153588241380204},
{-0.46829653914797864,0.09134582223256858,0.1884637727080693},
{-0.47149851702404666,0.09883991619461481,0.1966239125561505},
{-0.4761867040859437,0.10144859591491859,0.20080071001784747},
{-0.4684371847598356,0.08603523792279909,0.19438813231249408},
{-0.4766431287343835,0.06608403817800892,0.181675062293612},
{-0.4747802479673746,0.07103627255718507,0.19312501616616232},
{-0.4766803109076331,0.07624231568419515,0.20824846098135072},
{-0.477177689833855,0.07284257175620563,0.2001330475155842},
{-0.4815086047093109,0.06759180224688101,0.18759564979350424},
{-0.4861628428304149,0.06020548270005092,0.17850811110248918},
{-0.4927597147857876,0.062032797910038545,0.18357728072217483},
{-0.4924423191329765,0.05908085667727174,0.17979817085262498},
{-0.4993883801936491,0.06026960847710444,0.18678788055146014},
{-0.500443491718614,0.10010249346887039,0.06549478156281524},
{-0.4968400541458663,0.08253256942827836,0.0700218458739643},
{-0.4854477595854565,0.07168830776924211,0.07979213548537287},
{-0.47565375960270045,0.07450714759921717,0.09472104748109637},
{-0.47801725252838784,0.07018269918867429,0.1108096121845443},
{-0.47764165869136,0.07499698231637403,0.1329664153367304},
{-0.47497909176344816,0.08855015390186496,0.14341783925230422},
{-0.4767800022417079,0.07402970693981023,0.1616969189450178},
{-0.49962710052335263,0.06518627729925937,0.07784357405826718},
{-0.5016042221704906,0.04701497202176185,0.09255370399110216},
{-0.49146318857073884,0.056702814205530194,0.11061400162092722},
{-0.4904409482424149,0.05094119396808152,0.12430674107412293},
{-0.48191868635920787,0.05995706267297796,0.14281969124785532},
{-0.48569456299630126,0.05565524688963036,0.16952241923385328},
{-0.4894952277488943,0.05238806549235666,0.16632636895062208},
{-0.4943860307113974,0.04834975815421234,0.15533499521481597},
{-0.49617454713190734,0.04807870549994396,0.15800241199141254},
{-0.5003545778260609,0.047265547537139074,0.1554481583507928},
{-0.5121973694420735,0.04413739513549397,0.1588651461852168},
{-0.49602366295060485,0.04506694946673216,0.10233746540441273},
{-0.5101281006699259,0.038256145297155666,0.10050206711328384},
{-0.5065111912952761,0.039717027495408806,0.09525560858056785},
{-0.492075886121242,0.04727848046696501,0.1094548877852789},
{-0.4941165946733574,0.04916453273324545,0.12300159290585691},
{-0.5009257822267057,0.04252993973254701,0.13244370942293268},
{-0.49556508281386075,0.04382754369174791,0.1401716738659976},
{-0.49072762818688953,0.045346085202141666,0.14398634929256873},
{-0.45299095557107516,0.13019418794133628,0.19750820163299795},
{-0.49559418190596904,0.04638071958821557,0.14757469844718624},
{-0.5117786658389593,0.041001698524783775,0.12909731383047515},
{-0.49950585430623456,0.20437962891113365,0.139044353482838},
{-0.5073065664795703,0.20437100695791635,0.13859816740384368},
{-0.49255440452480115,0.20705728425717573,0.14427949570195633},
{-0.4950655483993345,0.20590517575851647,0.14140084107153636},
{-0.488706319029513,0.2052261969426554,0.14174787468853195},
{-0.48209004767940133,0.20284977108714206,0.13807600036212206},
{-0.4769739961890967,0.20339295413983088,0.139488384073528},
{-0.49164586620453,0.19380049231352878,0.14864274290197702},
{-0.500941409516912,0.19221728615400546,0.14475639748928723},
{-0.5086402748678687,0.19256916961968568,0.1456185928110154},
{-0.512772345947251,0.18284630075097213,0.14935189855409847},
{-0.5152360690790893,0.20138296129605204,0.13251645715320348},
{-0.526614891837597,0.1942278178698602,0.11656153272462345},
{-0.517117810368761,0.1976210953329367,0.12374038652216275},
{-0.5245283791590147,0.1942790107170878,0.1143268302251192},
{-0.5323506462153937,0.18482450014226234,0.09426731719303691},
{-0.52716023037859,0.18691047394876834,0.09864457506703571},
{-0.5297910038540131,0.18460517920729771,0.09266632825500289},
{-0.530389151858462,0.17946972832225408,0.08171159782037024},
{-0.5365948026866006,0.14381417966426127,0.10892625427864429},
{-0.5264618521679902,0.17196054594207766,0.0668834549028737},
{-0.5247913487321418,0.17441025839993807,0.07115509384996078},
{-0.5240024400127605,0.1703256080632506,0.0631302108929757},
{-0.5200557409275498,0.16747874688531939,0.05671008897855721},
{-0.5223389419139013,0.16571124647577676,0.054980848486416115},
{-0.5089592871369081,0.16162551839493722,0.047875281291223724},
{-0.518974224670857,0.1297916505005044,0.07190466490778823},
{-0.49505962080649757,0.1574325547709578,0.047567585335781974},
{-0.47420042161351234,0.1901835829388789,0.14499457894691464},
{-0.4806426372830502,0.18288994938913475,0.14881625971047482},
{-0.4898557331677919,0.18555898278195954,0.1519821331574455},
{-0.5056328298112656,0.18462242311373228,0.14954427588525906},
{-0.5029373916867128,0.17829552606847554,0.16042140874093616},
{-0.5149499280066907,0.1644281920626299,0.16243086271263896},
{-0.5264128148090669,0.1619089651069555,0.14283531853806164},
{-0.5298729124095773,0.1541492072114017,0.13032109231525313},
{-0.5352740272281283,0.15294806135381925,0.12114463973168482},
{-0.5388666873593545,0.1516499185225422,0.13484546226602176},
{-0.5454446987920644,0.1381899718062131,0.10578894105170586},
{-0.5404622875766276,0.12936648043247712,0.08428525085572887},
{-0.5356792590293405,0.13583617857789496,0.09289157678280438},
{-0.5304333393687006,0.12684563686057448,0.07813025400274179},
{-0.5175004095427779,0.12321202245156616,0.06873124725175242},
{-0.47296748230344104,0.20241328470551717,0.13739109395342422},
{-0.47373645275600745,0.1824195140667166,0.1493535151703267},
{-0.48120629747462995,0.17630762697981597,0.15745491796211514},
{-0.488026801341576,0.1796761163273929,0.16052756653992395},
{-0.4682205581852514,0.19868806204357536,0.13208158738780684},
{-0.47308980626471125,0.174175849046843,0.15465871075933543},
{-0.47765836372571846,0.1663562763508446,0.17080331815869568},
{-0.4893351827422985,0.1766508884922791,0.15944766689945944},
{-0.49611365458731027,0.16086786425596866,0.18221824534630077},
{-0.506705185242665,0.1612402248605399,0.1770035802660735},
{-0.51116542941638,0.1685236198408388,0.16075065957942114},
{-0.512214613348508,0.15217747428502465,0.17808509652276627},
{-0.5156558504263556,0.15574696291697931,0.16457341808713347},
{-0.5154823336178578,0.16334667580593717,0.1555074342791616},
{-0.5255339144529803,0.1597259943267549,0.1527300875990447},
{-0.5258723261167585,0.15563433865307838,0.15622251752411995},
{-0.5398636007001026,0.14813862807480419,0.13696430726916878},
{-0.5464340679237475,0.13415920867713377,0.10805112602709019},
{-0.5416876826776339,0.12392279471991588,0.08597084270970747},
{-0.5345012846710294,0.12451986498021259,0.07672810886078132},
{-0.48081723183570013,0.16234652923273243,0.1795890884871059},
{-0.49327110438598765,0.1448768353982912,0.1941736612262142},
{-0.5209308691791039,0.05792228171369944,0.08459941327608357},
{-0.5354793374891148,0.11640876249105478,0.08285723985411655},
{-0.5327407895984757,0.07362501401067396,0.08986904330807101},
{-0.5241641016355846,0.04669811524102673,0.09345577584646027},
{-0.5150717130958848,0.043244484105429214,0.09269542734711121},
{-0.5206010794685428,0.04372246363691232,0.09710825077813129},
{-0.5252073579748757,0.05888093513704595,0.10422836751937785},
{-0.5318931438228017,0.04183425588232762,0.10531796685721184},
{-0.533550175456748,0.04331453747531973,0.11239335721614375},
{-0.5299672150228913,0.04430875645568747,0.12072054740780978},
{-0.5392816188579361,0.07390307200193129,0.10557015898881734},
{-0.5365436098393731,0.05423316348085502,0.12092747428502455},
{-0.5287682246536131,0.03849163239440269,0.12933872852055905},
{-0.5349970469810231,0.04381784399437855,0.13007051679987586},
{-0.5433312425096782,0.07394402627971348,0.12359920203822977},
{-0.5334747333660967,0.06217074916151507,0.1367417531017477},
{-0.5423510342032885,0.04430875645568747,0.13942102506401802},
{-0.5421150082339654,0.04660381262771269,0.1476819339903262},
{-0.536630907115698,0.0538139210056646,0.15301568979936717},
{-0.543504759318176,0.0771438486674772,0.13925666908081358},
{-0.5392212651854151,0.06205974151384261,0.156128753782882},
{-0.5248678685669452,0.046812356121155765,0.16000971047481097},
{-0.5310600475931818,0.05071971754481263,0.16195180543700372},
{-0.52716023037859,0.07322193769776605,0.16700157566195048},
{-0.5368771716544667,0.04744984178715851,0.17659242087202437},
{-0.5338487105868964,0.04921195347594042,0.1872389164791392},
{-0.524677646724089,0.05972049783157875,0.18803429166343344},
{-0.5241700292284215,0.06972896890061482,0.1887294366415768},
{-0.5095951561866826,0.0641069165308709,0.18990687212781185},
{-0.5350557840373158,0.07256020278833968,0.0898588047386255},
{-0.5417933016045456,0.0806686109171173,0.09593889837303744},
{-0.5405792228171371,0.09637727080692858,0.10293076356017693},
{-0.5393980152263694,0.11329138753093135,0.1101047675090315},
{-0.5409725994326755,0.1202142770923325,0.08866304760180373},
{-0.5406902304648096,0.1162691946233499,0.0975986243673642},
{-0.5421581180000518,0.12097893656829009,0.10878506979471131},
{-0.5422481096367572,0.12822407163118743,0.11298126665114716},
{-0.5487215798867076,0.08413409723838833,0.12932310123035273},
{-0.5366325237319263,0.07453786330755373,0.13200614529715562},
{-0.5410593578369245,0.08636879973789263,0.15491736935585387},
{-0.5300539734271402,0.08572053663036834,0.1626593444728969},
{-0.5371207418328549,0.09506350068544542,0.17097360173473702},
{-0.5298858453394032,0.07563770121483322,0.18515078718432876},
{-0.5193288024969177,0.06924506177629484,0.19478528103256515},
{-0.5363981143788314,0.14136500607847702,0.1390696804704138},
{-0.53774691118526,0.1282111387013614,0.13684090556374642},
{-0.5388273496978007,0.12035653932041766,0.12327102894389697},
{-0.543565112990697,0.10005291723787103,0.1618090043368425},
{-0.5325290128725763,0.13051697231490816,0.14986221041014633},
{-0.526399881879241,0.1377534854245882,0.15867438547028445},
{-0.5269888690583966,0.10703885483217375,0.1860248376917307},
{-0.5263988041350888,0.08628311907779589,0.19021618469948184},
{-0.5134965900175026,0.09450469034255024,0.19276774397972118},
{-0.5242427769586923,0.07485525896036489,0.2094523011993137},
{-0.5185124113016564,0.07885368976487946,0.21801497848822673},
{-0.507640128294664,0.08695024270798299,0.21460661260702},
{-0.50990069665382,0.09239015631601184,0.21436627566108826},
{-0.4975610649836614,0.08121502720226234,0.21720235939749793},
{-0.49765913970150805,0.11259300932033153,0.20674446901701113},
{-0.4856471422536062,0.12016146762887668,0.20208807540760285},
{-0.4833310700706139,0.0752044480656648,0.21136745255770245},
{-0.5229985213350233,0.1501911918125933,0.15808378167490067},
{-0.5168370580171232,0.13793239095384668,0.17980194295715754},
{-0.5275234301578681,0.11826625453730293,0.18911365243182193},
{-0.5190615219471819,0.16289186777372539,0.15940186277299262},
{-0.5158417612926033,0.11113589922661088,0.1994282028400714},
{-0.5055945698938639,0.12391417276669858,0.1998404399782727},
{-0.48457694231051107,0.14285822060129508,0.19694885241802682},
{-0.48128281730943334,0.12393842201012223,0.2033608912513041},
{-0.4740996525352854,0.10830089323435342,0.20369822517093025},
{-0.47528247674228125,0.1178766500262971,0.2032493447315555},
{-0.47153516032522014,0.11679136166507154,0.2142843671055241},
{-0.4731383047515585,0.13562925170068021,0.20590867842701088},
{-0.46899815059103495,0.1274039083313935,0.21225120276247383},
{-0.4654146512851022,0.14124807083796756,0.20830773690971954},
{-0.4535152781011011,0.13106716070458604,0.2085286744609124},
{-0.4622390781407621,0.1425462136692446,0.1989513010527405},
{-0.45393721493667183,0.14694448755421052,0.18815553788055148},
{-0.48021962270332724,0.15261288292249722,0.18702821749739187},
{-0.44438732400438,0.104868816981799,0.18784029771604463},
{-0.43103407395911475,0.09511307691644477,0.20916023253407828},
{-0.4403436279454748,0.09567027064311148,0.192853963511894},
{-0.4363823793142099,0.08739535104282516,0.20304996206340586},
{-0.4261276437064053,0.08271632480622151,0.20724292568738523},
{-0.43821292775665405,0.08017985394411252,0.19870773087435228},
{-0.42692786873938426,0.06556133226421114,0.20807171094039645},
{-0.42162267315037555,0.06975645137649479,0.21699597139235927},
{-0.42445282929394834,0.05963158393902554,0.22154890156316015},
{-0.4348363553279361,0.06052880594569895,0.2054851249752119},
{-0.44107218299233514,0.05589989481217083,0.22628882034436082},
{-0.44709785054706297,0.0596272729624169,0.21175436270832795},
{-0.4560048670925912,0.07298645060051903,0.2238908396058043},
{-0.45532804376503455,0.06953820818568236,0.21291509316020452},
{-0.45632226274540244,0.08098385108162397,0.20977185234042922},
{-0.45854564893130895,0.08302833173827197,0.22230170585344405},
{-0.46557577403585015,0.09008540044661716,0.21022935473302123},
{-0.4474308734900805,0.08218769129958697,0.20186875447263825},
{-0.4510946647353492,0.07425818870006819,0.20186228800772527},
{-0.4430961865100921,0.12354720088288795,0.20708341955286552},
{-0.43903524654475234,0.09704654992542007,0.2266498646353345},
{-0.4465368847158636,0.0938197839338524,0.22864315244475486},
{-0.4302025943457231,0.0948635791452195,0.21434795401050155},
{-0.42860268315184125,0.07741274583344107,0.2229327250545339},
{-0.43471726459912235,0.08966454135519862,0.2227128652474932},
{-0.4448157273048637,0.07341808713345924,0.22820774380728215},
{-0.4417188294836313,0.07135851805868104,0.22979526094341415},
{-0.4433392178164042,0.11785940611986252,0.19214750222015298},
{-0.4504717286154006,0.1297765620823742,0.194205993550779},
{-0.44466322650733303,0.12713555003750543,0.20940488045661867},
{-0.4410732607364873,0.11831313640792199,0.20077430528611953},
{-0.4601762758335274,0.1387385435796625,0.20271370588793186},
{-0.4597979876361191,0.13911305967253815,0.20773114378831384},
{-0.44873548278627046,0.12776495262236715,0.2141954532129709},
{-0.4698344800531113,0.13592024262176347,0.2115253420759939},
{-0.4664568298802411,0.12024984264935373,0.21882921419518378},
{-0.47207726563375674,0.10952628833535955,0.21340762223774176},
{-0.47180998508402094,0.1359175482613832,0.20676063517929355},
{-0.4765784640852539,0.1184063612770837,0.20270400619056242},
{-0.4751827854082064,0.10730667425398543,0.20302571281998225},
{-0.460590668460033,0.12400416440340387,0.20594262736780392},
{-0.44889983876947487,0.08781351577386338,0.23199493675797317},
{-0.4319199796521905,0.09318068165162131,0.22601776769009255},
{-0.4497367071036273,0.09593539570454286,0.23113435805247323},
{-0.46262221618685506,0.09202156781597298,0.2210375119629601},
{-0.4434707026029677,0.09796424907098451,0.22818996102877148},
{-0.43603103472060567,0.10125244647922552,0.2245417970737091},
{-0.42883655363286005,0.0948819007958064,0.2105063349801264},
{-0.4323058120586638,0.09039471301828729,0.22152195795935614},
{-0.42966480001379515,0.07312763508445203,0.222186926101239},
{-0.4409918910529992,0.06907100609572092,0.22598543536552773},
{-0.4493217756050456,0.0837983799349904,0.22728303932472865},
{-0.46060629575023926,0.08371269927489365,0.22156183449298605},
{-0.4328231292517007,0.10229947492304908,0.21014475181707667},
{-0.5357784114913393,0.05546233068639375,0.19319722502435704},
{-0.5278807023443092,0.07014336152712032,0.18786131372701176},
{-0.5371110421354854,0.0951200822534336,0.1676487610253227},
{-0.5410173258149902,0.053327319520964325,0.18769695774380732},
{-0.5394729184449446,0.09614771130251844,0.15994774018606178},
{-0.544378809825578,0.04901903727270382,0.1754780334186907},
{-0.5397401989946803,0.08819827043618453,0.15744467939266962},
{-0.536206814791823,0.05909109524671726,0.1580875537794332},
{-0.535359169016149,0.03941472026072785,0.16376780433339372},
{-0.5215613495081176,0.04825922764543079,0.15810210332548738},
{-0.5251470043023547,0.03793551641188793,0.16447588224136298},
{-0.5354884983144081,0.03826207288999254,0.17555239776518974},
{-0.5342075993895657,0.043804911064552615,0.18853598156626403},
{-0.5251771811386152,0.05281108007207957,0.19690897588439688},
{-0.5192404274764406,0.05047722511057654,0.19405834260193305},
{-0.5146632480622161,0.05982611675849049,0.19006098954157077},
{-0.49443183483786424,0.036490800375917176,0.18672052154195012},
{-0.49065757481699906,0.051154048438133246,0.1815424997628963},
{-0.5020390919358872,0.044167033099678454,0.19359922359311282},
{-0.5166867127078969,0.039519261443487406,0.20111110033366963},
{-0.4962726218497539,0.00987752515454849,0.20322293999982757},
{-0.5080879309898866,0.007977462214290047,0.20826247165532882},
{-0.4858982566410595,7.274773027081353e-05,0.20457604778286476},
{-0.4755583792452343,-0.019273837545157418,0.21304226697015943},
{-0.47937844339256624,-0.011555033927385846,0.20869841916487764},
{-0.4665198779131425,-0.013171650155626253,0.20270993378339933},
{-0.4661432063319625,-0.028244440995663138,0.21392817266323516},
{-0.4571920022761957,-0.022773272807221686,0.20243834225705495},
{-0.4558577550158213,-0.03832080994628523,0.203636254882181},
{-0.46051522636938175,-0.019128880956691945,0.19182633446280922},
{-0.4605216928342947,-0.0414775225679625,0.19347312752731005},
{-0.4620655613322643,-0.027779933266082125,0.18692529293086058},
{-0.4750550727261755,-0.03799425346818062,0.18697433028978386},
{-0.4713293111921575,-0.021875511928472244,0.1843230796754697},
{-0.484576403438435,-0.02483930834691291,0.184331701628687},
{-0.48082477604476526,-0.016433981704215273,0.18734022442944226},
{-0.49967667675435196,-0.0008023805212833313,0.17905937723631915},
{-0.5018316261865964,-0.01939508376227552,0.18317528215341905},
{-0.5140360009656588,-0.0035473948768354018,0.18209969348956315},
{-0.5247159066414906,0.02603129337920218,0.1673663920574567},
{-0.5076131846908599,0.03095227317796575,0.16347142469154963},
{-0.5071179612529423,0.03576008984075259,0.16005443685712561},
{-0.49801641188794915,0.029176689687281744,0.17037114275367946},
{-0.49239274290197704,0.03175842580378157,0.17799941586266954},
{-0.4910746618038851,0.01988168524697592,0.19359221825612374},
{-0.49545892501487293,0.012366575273962623,0.17569519886535098},
{-0.4901952225757224,0.005149461559021646,0.18884367752170578},
{-0.49108490037333064,0.007295789038048663,0.1958506311269755},
{-0.4768910098893804,-0.010620629747462978,0.19493832070217187},
{-0.4938282981126545,0.0005275557624824669,0.18303894751817076},
{-0.5216691239233336,-0.0030672598570480325,0.1866806450083202},
{-0.5214298647215541,-0.010626018468223815,0.19664331195088935},
{-0.4918894363829182,-0.0293162575549865,0.18840180241932009},
{-0.4827528603329799,-0.03637817611201637,0.1935151595492443},
{-0.47556430683807116,-0.039964369778329574,0.19775554391591874},
{-0.4759447505237837,-0.03022641249148584,0.21289299940508527},
{-0.48526508195166534,-0.01855174896321012,0.21390500116396371},
{-0.5123698085064191,-0.0028581774915289178,0.2109395881292948},
{-0.5189920074493676,-0.005899032616849043,0.20696378995197573},
{-0.4937517782778511,-0.029756516041143988,0.20841012260417477},
{-0.49498471758792245,-0.03229514239155736,0.20182564470655184},
{-0.5258480768733349,0.008623030961434042,0.20371546907736482},
{-0.5277362846279197,0.00365678590827964,0.1875697839338524},
{-0.529998469603304,0.002597902278782216,0.19666917781054125},
{-0.5219040721485045,0.003363639498892123,0.21135451962787652},
{-0.5184596018382005,-0.004701119991722901,0.21144828336911445},
{-0.5237470146486986,-0.00908107222610203,0.20274765482872492},
{-0.5263535388806981,-0.00877714837519284,0.1883662368622988},
{-0.5272895596768492,0.005956153056913503,0.18124342576067184},
{-0.5088110973159861,-0.005825746014502074,0.17982295896812467},
{-0.5102326418526854,-0.01263008371916578,0.18302601458834486},
{-0.5226751980893752,-0.012761029633653243,0.19227467603010787},
{-0.5217429493977566,0.016953454385556486,0.20654400860470934},
{-0.5032914306406974,-0.00019291620323660496,0.21236436589845067},
{-0.5019663442056164,0.0064082667287447374,0.20889834070510335},
{-0.4875202615900606,-0.03104280368674718,0.21401439219540797},
{-0.4834841097402206,-0.014572717553434518,0.21449129398273886},
{-0.491242251019546,-0.0129970556029763,0.2146389449315848},
{-0.4959988748351052,-0.02707616633472148,0.21395296077873485},
{-0.496051145426485,-0.02798416578291644,0.20900611512031939},
{-0.4980174896321013,-0.03124218635489681,0.20211771337178727},
{-0.4999876059422502,-0.03428627471267339,0.19927408542631248},
{-0.49746945673072784,-0.02477733805816365,0.18590413034668876},
{-0.4912810498090238,-0.03760141572471822,0.19686532724623437},
{-0.4900922980091911,-0.026892949828854235,0.18451761249493462},
{-0.4871780778217498,-0.03477233732529763,0.19482246320581467},
{-0.47285916901614894,-0.037500107774415245,0.19657649181345546},
{-0.47073655190846936,-0.03261307691644468,0.20814553641481942},
{-0.48392814033091064,-0.027220584051110913,0.2119111744824673},
{-0.5171609201348474,0.0006003034927532804,0.19699681203279795},
{-0.5457739496305494,0.06398620918582895,0.14776707577834683},
{-0.5374408318460464,0.060037354612313874,0.1540605627548865},
{-0.5435096091668608,0.07967762516920578,0.13727308096876267},
{-0.5451019761516774,0.08131148530388076,0.12863981143788314},
{-0.5476761680591121,0.04521298379934994,0.1533072195925265},
{-0.549127350559996,0.041036186337652936,0.13900717130958848},
{-0.5442160704586018,0.07169639085038323,0.12474646068820433},
{-0.53890440840468,0.04969963270479301,0.12497278696015797},
{-0.5389906279368529,0.03335887586973959,0.12958553193140376},
{-0.5253593199003302,0.04131963304967109,0.12708893760292458},
{-0.5294073269358441,0.03210869265323366,0.13194686936878683},
{-0.54182293956873,0.03247243130458773,0.1410198585137477},
{-0.5404191778105413,0.03689064345636864,0.15454770311166294},
{-0.5357794892354915,0.04485355612460452,0.16238398084201996},
{-0.529621259150048,0.04275572713242455,0.16077275333454044},
{-0.5248543967650432,0.05284772337325299,0.15778901864928482},
{-0.5000819085555642,0.03253494046541303,0.150418326392661},
{-0.5064405990533096,0.03370213738220262,0.15827184802945263},
{-0.5128515601424347,0.03946375761965117,0.16184510876593985},
{-0.5277303570350828,0.03376895751963656,0.1669897204762767},
{-0.5034827302277058,0.027709879896191728,0.14177805152479242},
{-0.5032181440383505,0.0102730572583913,0.14482914521955806},
{-0.49929677194071553,0.016533134166213992,0.15253609365165588},
{-0.5027902796099429,0.005474940292973942,0.16401730210461882},
{-0.509020179681505,0.007061918557029869,0.16949547563004927},
{-0.5218641956148746,0.005155389151858518,0.171168673426278},
{-0.4933018200943242,-0.01471012993283501,0.1788788550908323},
{-0.4872885465973462,-0.01244632834122238,0.1687847033616996},
{-0.4779418104377366,-0.016497029737116604,0.1736049140822362},
{-0.49212923445677387,-0.02201454092410096,0.18091471379426297},
{-0.48085064190441706,-0.031056814360725306,0.18270161359854464},
{-0.4700446401627825,-0.025864243035617327,0.1744288494865627},
{-0.4709310847279343,-0.040607783037169186,0.17599858384418407},
{-0.46719346800824263,-0.03316757628273109,0.1689571424260452},
{-0.4721661795263099,-0.04292439409223763,0.16438696834880975},
{-0.4713481717148203,-0.029342662286714404,0.15885275212746697},
{-0.48171768707483,-0.036194420734073085,0.1548494714742678},
{-0.4788282550028884,-0.023017381857686,0.15509411939680817},
{-0.49079229283601916,-0.02619672710655869,0.15212978410629144},
{-0.48541273290051135,-0.014260171749308038,0.15991648560564914},
{-0.49727115180673037,-0.00968029797470312,0.14903989162204806},
{-0.5081913944284939,-0.01929485355612461,0.14779078614969435},
{-0.5071675374839417,-0.00123671141460383,0.1459305997430658},
{-0.5212439538553064,-0.003904128191200406,0.14564553641481942},
{-0.5286491339247994,0.023782041333643714,0.13201476725037292},
{-0.5126354724399266,0.02974519972754628,0.13198297379788418},
{-0.5033485510807618,0.02984058008501251,0.13720518308717658},
{-0.5003852935343973,0.0031313856341015555,0.15565724071631187},
{-0.4731140555081349,-0.018940275730063866,0.16469574204840368},
{-0.5358624755352078,0.036653000870817354,0.1587142620039144},
{-0.5310789081158447,-0.00659040549045979,0.16643899321452285},
{-0.5308870696567601,-0.010830789857134164,0.15662451609287567},
{-0.5285478259744963,-0.00559187553348328,0.14895367208987526},
{-0.5256152841364683,-0.004805661174482458,0.17212139925678765},
{-0.5046283722614522,-0.03030616555874572,0.17184280239345423},
{-0.5040604010932637,-0.03227143202020987,0.16526694644904857},
{-0.49894003862635045,-0.028537587405050774,0.15387519076071493},
{-0.49172400265556165,-0.03009654432115045,0.17901572859815665},
{-0.4900335609528983,-0.03807993412827737,0.15794690816757628},
{-0.486695248441582,-0.03681520136571741,0.17651159006061234},
{-0.536233758395627,0.005498650664321551,0.1642015963546382},
{-0.5347680263486891,0.0021824319081245255,0.14830756447065518},
{-0.5386549106334549,0.00032009001319157954,0.15609372709793679},
{-0.5339122974918739,0.0006396411543071232,0.17163318115585907},
{-0.5338842761439178,-0.010055352939654896,0.16467688152574086},
{-0.5313844485829821,-0.013617836234620616,0.1531202309821267},
{-0.533737702939224,-0.006240138641007693,0.14674106334549028},
{-0.5333432485795333,0.004777639826526323,0.1431096044247864},
{-0.5158891820352983,-0.005944297871239759,0.14434362147900986},
{-0.5176863204090255,-0.012643016648991595,0.14659395126872043},
{-0.5291556736763147,-0.006824275971478584,0.1726915259132804},
{-0.5170666175215334,-0.003269875757654119,0.1757544747937198},
{-0.5331557210970574,0.013173805643930635,0.16819409956631579},
{-0.5154090470155109,0.0034380038453911636,0.17343193614581448},
{-0.500315779036583,-0.03211354250191835,0.17855175974065168},
{-0.49570734504194586,-0.01810394626798753,0.18088130372554598},
{-0.5027207651121286,-0.015895648500211253,0.17950071346662877},
{-0.5073006388867335,-0.028893781847339626,0.17470475198951574},
{-0.5004386418699293,-0.038699098143693454,0.16205957985221975},
{-0.5087151780864437,-0.034410754162247946,0.16242924609641068},
{-0.5070516799875845,-0.03160430839002265,0.1649339235060311},
{-0.5028576386194529,-0.024901817507738205,0.15095827621289326},
{-0.49605976737970225,-0.02739679521998909,0.1510337183035445},
{-0.49601989084607234,-0.035572023486200546,0.1605297220282283},
{-0.48353099161083957,-0.039316645542881314,0.1649705668072045},
{-0.48388988041350894,-0.03567333143650365,0.1763741776812119},
{-0.4961341317262013,-0.029609403964374014,0.17758394549201179},
{-0.526897260805463,-0.001504530836415631,0.1591070997473768},
{-0.5389529068915273,0.0445280773906521,0.11718770207702854},
{-0.5328146150728987,0.057393648207064905,0.11953880094496609},
{-0.5374316710207532,0.0761803453954459,0.10402090177008701},
{-0.5378519912400955,0.07653815645396309,0.09716159911366322},
{-0.5375475285171103,0.04133472146780129,0.10274646931015753},
{-0.5276797030599313,0.05151293724080251,0.09274985342679531},
{-0.5350988938034023,0.07282640559392325,0.09340943284791738},
{-0.5305082425872758,0.043588823362044435,0.1257255912504419},
{-0.5318505729287913,0.03729048653682009,0.11764197123716408},
{-0.5302792219549417,0.03431375718855349,0.10537562616935242},
{-0.5251944250450498,0.03681035151703272,0.09580795245854996},
{-0.5147850331514102,0.04708233103127183,0.09684150910047162},
{-0.5177267358147315,0.03681196813326095,0.09960430623453438},
{-0.5213878326996199,0.051813088987179214,0.12470820077080262},
{-0.5244119827905814,0.042774048783011324,0.12529341584542564},
{-0.5021080675616255,0.03543245561849579,0.12753943465852757},
{-0.4949669348094118,0.036508044282351756,0.12055188044799671},
{-0.4954702413284706,0.032857185966908994,0.11337572101083782},
{-0.4942863393773226,0.016677551882603548,0.11562012320771149},
{-0.4928712613055362,0.014433149685729882,0.12518025270944882},
{-0.4964024900200892,0.011384211479268503,0.13202446694774234},
{-0.5028280006552686,0.011025322676599116,0.13587039695472614},
{-0.5031362354827864,0.033893436969210995,0.10349065164722418},
{-0.4960128855090833,0.005973935835424119,0.11520195847667332},
{-0.49188674202253785,0.00922872317494804,0.1252589280325565},
{-0.492856172887406,0.00297457385996222,0.13965435667296072},
{-0.4930900433684247,-0.006093026564237839,0.14446702318443222},
{-0.5136178362346207,0.007605640481794725,0.1349467702163248},
{-0.5224499495615738,0.032141024977798444,0.13151631057999882},
{-0.5159484579636672,0.025405124026797028,0.10021915927334178},
{-0.507479005543916,0.0014495658846555538,0.11233839226438358},
{-0.4888528922342068,-0.015859544071113865,0.11973117827612668},
{-0.4825276118051784,-0.010008471069035954,0.12321283075968031},
{-0.48230829087021376,-0.0034261486597172994,0.13395632334048957},
{-0.47709524240621476,-0.006414733193657646,0.14302446263676574},
{-0.4905519558900874,-0.013456174611796599,0.14641235137908143},
{-0.479558426665977,-0.02048306648388127,0.14974850840209342},
{-0.4696113870136141,-0.013976725037289882,0.1450495438986748},
{-0.4689210918841555,-0.027112270763818867,0.14551566824448411},
{-0.46521203538449607,-0.022655798694636315,0.13959669736082012},
{-0.46839353612167306,-0.028237435658674075,0.13268781847339697},
{-0.46745266547683717,-0.015871938128863644,0.1310038432356466},
{-0.47652134364518944,-0.018717721562642783,0.12355501452799118},
{-0.47355646948259666,-0.007526965158687039,0.12978329798332516},
{-0.5203429597441005,0.03285018062991993,0.10049128967176225},
{-0.46712557012665656,-0.012532547873395165,0.13781572514937535},
{-0.5120049921109129,-0.004451083348421717,0.11461997663450679},
{-0.5170148858022298,-0.006308575394669861,0.11975273315916989},
{-0.5195066302820242,-0.0032628704206650555,0.12828038376313772},
{-0.4998162446220567,-0.021655652121431578,0.1332854276057698},
{-0.48327772173508193,-0.02492498900700966,0.12529934343826252},
{-0.4804216997318573,-0.027719040721485056,0.13263662562616937},
{-0.48749547347456096,-0.02095350180629916,0.14530065828612815},
{-0.5156057353232801,-0.0020450195287240337,0.1347053555262409},
{-0.5252871110421355,0.0061097315985963845,0.12499003086659255},
{-0.5207966900321599,0.004862781614547037,0.11267788167231406},
{-0.5250661734909428,0.0023947475061000937,0.11818838752230931},
{-0.5204771388910444,-0.004580412646680953,0.13357695739892916},
{-0.5207913013113992,-0.007040902546062797,0.12562967202089964},
{-0.5182936292387678,-0.004182186182457724,0.11216056447927715},
{-0.5189817688799221,0.007862682462084972,0.10826451936921791},
{-0.5024965943284793,0.0008665062983368543,0.1120506345757568},
{-0.5034638697050431,-0.005367165877757931,0.11345385746186942},
{-0.5156105851719649,-0.008718411318900153,0.11626245872239899},
{-0.5242761870274093,0.013279424570842264,0.13056951234232606},
{-0.5093682910426529,0.0007921419518378138,0.13926313554572656},
{-0.5085696826259022,0.00679625462352245,0.13766753532845333},
{-0.4953215126354725,-0.02412476397403071,0.14228836338084033},
{-0.49343653811334426,-0.010689066501125147,0.14610627203986795},
{-0.49939053568195346,-0.009264288731969274,0.14373092392850678},
{-0.5011079209884207,-0.020832255589181174,0.1379687648189821},
{-0.49912002189976123,-0.023805751704991204,0.12790317330988163},
{-0.49181345542019095,-0.02704598949846096,0.12725329358612902},
{-0.49340743902123596,-0.015138533233318636,0.1185677534638697},
{-0.487085391824664,-0.0165994154315719,0.11988314020158129},
{-0.48793195985618587,-0.024480419544243525,0.12761864885371135},
{-0.4781481984428753,-0.02698671357009212,0.13318950837622756},
{-0.47981708526249545,-0.02472776182716429,0.14336502978884838},
{-0.4920036772630472,-0.020709931627911002,0.14252331160601125},
{-0.5153190553788056,0.002179198675667952,0.12305979109007356},
{-0.5204394178457188,0.09343502927153126,0.21638327384185613},
{-0.5100181707664055,0.09523055102903015,0.2143301712319909},
{-0.5211016916272213,0.11301817938835859,0.19334325935697474},
{-0.5245213738220257,0.11328707655432259,0.187735217661209},
{-0.5309549675383463,0.08641029288775086,0.2028996167541795},
{-0.5263573109852306,0.10567712509591921,0.18661651923126665},
{-0.5261870274091893,0.08079686247122435,0.19090647982894046},
{-0.5304290283920919,0.07108908202064101,0.20615817619823598},
{-0.5245348456239277,0.06373671141460392,0.19835045868791118},
{-0.514494581102403,0.06899233077261324,0.18991279972064873},
{-0.5171700809601407,0.06188891906572514,0.19832189846787893},
{-0.524092970521542,0.06580490244259941,0.21046538070234433},
{-0.5189009380685101,0.07299507255373633,0.22118516291180604},
{-0.5276349766776166,0.07888871644982454,0.21656271824319084},
{-0.5190356560875301,0.08250832018485471,0.2231493516291181},
{-0.5078384332186614,0.08126945328194662,0.2251049183932128},
{-0.5031793452488728,0.07746447755274481,0.22163134899080042},
{-0.49897290982299136,0.085469961114991,0.214566197201314},
{-0.48832910857625694,0.06902035212056937,0.21880011510307545},
{-0.4839071243199435,0.05939124699309384,0.21349976936275145},
{-0.4781519705474079,0.06536194959606151,0.1996448294146556},
{-0.48459310847279347,0.05354125173516812,0.20443055232232313},
{-0.48110714501263124,0.0453724899338697,0.220841901399343},
{-0.48481835700059495,0.03684483932990176,0.23376836476035281},
{-0.5006342524335463,0.06819264461171032,0.22956839579938443},
{-0.4841857211832769,0.0586023382737126,0.1917724472552012},
{-0.4930641775087729,0.04978046351620496,0.19884083227714408},
{-0.4902167774587656,0.03432453463007516,0.20761205305950012},
{-0.4831279152979317,0.028979462507436493,0.21979325633929112},
{-0.48182438374589387,0.03233825215764381,0.22614871360458},
{-0.4617373882379315,0.012804139399739695,0.2321318102652975},
{-0.47798923118043163,0.02068622125656351,0.24194359302656424},
{-0.4952552313701147,0.038161842683841624,0.24088740375744724},
{-0.5023925920177957,0.05250176750040954,0.19478204780010866},
{-0.49504884336497595,0.024399588732831577,0.2137751329936284},
{-0.492856172887406,0.021723011130941675,0.21411623901778712},
{-0.46828037298569625,0.01716738659976028,0.21768896088219827},
{-0.45647907451954167,0.015373481458489623,0.2208677672589949},
{-0.4510240724933827,0.0012981428312770545,0.23054590974539374},
{-0.4480759033651484,0.006711112835501736,0.21722930300130194},
{-0.4456499012786357,-0.008497473767707295,0.2177886522162731},
{-0.4522505453385411,0.006324741556952371,0.20948948337256323},
{-0.45526876783666576,-0.011804531698610994,0.20947547269858516},
{-0.4579178629626756,0.0014511825008837807,0.20524478802928017},
{-0.47069613650276343,-0.0025504815360871185,0.20780389151858464},
{-0.46461765948457967,0.01111154220877202,0.20797633058293027},
{-0.4742117379271101,0.011037177862272981,0.21243711362872147},
{-0.47850277626893606,0.001747023270651716,0.21138146323168053},
{-0.4977157212694965,0.00887630083719168,0.2184142826966021},
{-0.5075361259839805,0.02349751687747349,0.22054067190881424},
{-0.517669076502591,0.05039316106670802,0.2030219407154497},
{-0.5219277825198521,0.06001202762473815,0.20820966219187298},
{-0.5130714199494754,0.02462106515610047,0.22686595233784265},
{-0.49874227257442905,0.007441823370666446,0.23422856151332525},
{-0.483674870455153,-0.0011052266280403298,0.2178991209918695},
{-0.473901886483364,-0.008626803065966533,0.21461954553684595},
{-0.46620140451617914,-0.0107321762672116,0.21904099092108328},
{-0.45859037531362357,-0.003432615124630327,0.23144852047282793},
{-0.46509456127191057,0.005759464749144288,0.23666372442513128},
{-0.49269073916004935,0.011388522455877148,0.24225344447031033},
{-0.5009354819240751,0.03094095686436804,0.24524741772501144},
{-0.512766418354414,0.023554098445461913,0.2358500275902503},
{-0.50743859013821,0.027807415741962223,0.24392448677823475},
{-0.4805558788788013,-0.0030505548226894873,0.23472701818369937},
{-0.4665872369226525,-0.0034191433227283557,0.22631630282024093},
{-0.5118745850685015,0.04122748592466143,0.24015884871058693},
{-0.518321650586724,0.03404755438296991,0.22689720691825527},
{-0.5187112550977299,0.03451798970538792,0.23507890164937967},
{-0.5071001784744317,0.03716115723856085,0.24740775587801664},
{-0.5050680918755336,0.028698171283722602,0.24833138261641796},
{-0.5126252338704811,0.023942086340239505,0.24229116551563593},
{-0.5148028159299208,0.01872149366717539,0.23361963606735472},
{-0.5201150168559187,0.02963958080063465,0.2239910698119552},
{-0.5188319624427719,0.035396890061474555,0.22061557512738939},
{-0.5037785709974738,0.020811778450290138,0.21742168033246254},
{-0.5052286757542054,0.015210742091513414,0.2222030922635214},
{-0.5064890975401568,0.04861003336695892,0.24021165817404277},
{-0.4900825983118216,0.030569135131872836,0.24498498702396043},
{-0.48911532293525783,0.03588079718579454,0.24026931748618335},
{-0.46993848236379476,-0.002347326763404996,0.23879711897433248},
{-0.46712557012665656,0.013643163222196332,0.23776302346033473},
{-0.47393529655208094,0.014941844925549421,0.24080657294603522},
{-0.47779523723304285,0.001311614633179026,0.24200394669908523},
{-0.4796489571747585,0.00015681177413933575,0.23766548761456424},
{-0.4836710983506204,-0.003058637903830742,0.2322789223420674},
{-0.4863509091849668,-0.006096798668770448,0.2306773945319573},
{-0.4896633558366313,0.002692204892096256,0.21772129320676306},
{-0.47955249907314007,-0.008996469310157473,0.22514964477552746},
{-0.48343668899752557,0.0009678142486399575,0.2136344873817715},
{-0.47667007233818753,-0.006384556357397129,0.2217773833234181},
{-0.46406585447867366,-0.008304018692394536,0.21798264616366195},
{-0.4572167903916954,-0.0035883491546174714,0.22690205676694},
{-0.4676795306208669,0.0014705818956226246,0.23567866627005685},
{-0.5066367484890028,0.030860126052956093,0.23383302940948245},
{0.44809907486441986,0.18561933645448034,0.11574190829690559},
{0.44284884422717125,0.17931722752472337,0.11125472051938647},
{0.4499339342834726,0.1914871144909168,0.1262267422811964},
{0.4465476621573851,0.16743563711923293,0.11781441030150971},
{0.4419451557555849,0.1752164110257539,0.10647546407663193},
{0.44399502513299366,0.1701089814886665,0.100798985627204},
{0.4504808894406939,0.16413289016493812,0.10800262754024298},
{0.4558593716320496,0.14646543027857534,0.11253454170007675},
{0.4554395902847832,0.14441394428493828,0.10621141675935268},
{0.44338825517532743,0.17094800531112325,0.09131052611158533},
{0.44927381599027444,0.16531679211608602,0.08492165877757948},
{0.46133000094841486,0.14152720657337708,0.10240967426260747},
{0.4468327254856315,0.16106670805204204,0.07796104817085264},
{0.45505914659907054,0.16199895674366074,0.07466207332109016},
{0.4522871886397145,0.15642109188415548,0.06812393842201013},
{0.45874826483191505,0.15752470189596746,0.06612364527560075},
{0.4820798091099558,0.14973261167584917,0.04684549675383461},
{0.47397840631816734,0.15415513480423848,0.05223852849124442},
{0.4500190760714933,0.18915918712225074,0.12141946449048568},
{0.4524725606338861,0.19323737099402508,0.124979792297147},
{0.4580762913530431,0.18278810256675548,0.1344806458705155},
{0.4519644042661425,0.17883008716794707,0.13081362139279032},
{0.4564435089625204,0.1612321417793988,0.13696754050162527},
{0.45493197278911574,0.15505343455506418,0.12687392764456862},
{0.4576980031556349,0.15311080072079522,0.12128366872731348},
{0.4573843796073563,0.1429401291568592,0.12300752049869378},
{0.4618748006173319,0.12270332721174651,0.10742818990714156},
{0.47313776587948236,0.14181119215747126,0.06193553150030608},
{0.4900712819982239,0.12824778200253492,0.06904810403248754},
{0.49966051059206956,0.1284503979031409,0.06757967762516921},
{0.48301960201063954,0.12276799186087631,0.06940268185854824},
{0.48405261978048514,0.10558551684298571,0.06762709836786426},
{0.5004434917186139,0.10010249346887039,0.06549478156281524},
{0.49684005414586624,0.0825320305562022,0.0700218458739643},
{0.4854477595854565,0.07168830776924211,0.07979213548537287},
{0.49962710052335263,0.06518627729925937,0.07784357405826718},
{0.5016042221704906,0.04701497202176185,0.09255370399110216},
{0.47565375960270045,0.07450714759921717,0.09472104748109637},
{0.49146318857073884,0.056702814205530194,0.11061400162092722},
{0.492076424993318,0.04727848046696501,0.1094548877852789},
{0.49602366295060485,0.04506694946673216,0.10233692653233666},
{0.5065111912952761,0.039717027495408806,0.09525560858056785},
{0.5101281006699259,0.038256145297155666,0.10050206711328384},
{0.4687147038790168,0.13099602959054357,0.083815354405387},
{0.4610578705499944,0.1358577334609383,0.09391381711112837},
{0.4638411448229482,0.12920535768172914,0.09603104549804713},
{0.4618279187467129,0.11570284007138974,0.0926986605795677},
{0.46881547295724374,0.10852290852969836,0.07998074071200091},
{0.46043547330212187,0.10723230990748651,0.11012740013622688},
{0.4636821775605046,0.09470191752239561,0.12014503203055621},
{0.47102915944578083,0.08890580947207778,0.08309326582343965},
{0.47801617478423564,0.07018377693282635,0.1108096121845443},
{0.47764165869136,0.07499698231637403,0.1329664153367304},
{0.49044094824241485,0.05094065509600549,0.12430674107412293},
{0.49411659467335733,0.04916453273324545,0.12300159290585691},
{0.5009257822267057,0.04252993973254701,0.13244370942293268},
{0.5117786658389591,0.041001698524783775,0.12909731383047515},
{0.4676930024227689,0.10211625841718185,0.12845659493201592},
{0.47497909176344816,0.08855015390186496,0.14341783925230422},
{0.4819186863592078,0.05995706267297796,0.14281969124785532},
{0.4907276281868895,0.045346085202141666,0.14398634929256873},
{0.4955650828138607,0.04382754369174791,0.1401716738659976},
{0.46330873921178106,0.12439700214686637,0.11590518653595785},
{0.44984879249545195,0.13487483079416815,0.13537679013303677},
{0.4527258305096437,0.11743477492391138,0.13738947733719598},
{0.4450943241681971,0.14447807006199193,0.1656382293094678},
{0.446439348870093,0.12929534931843464,0.14918484821051362},
{0.44888636696757284,0.10960873576299984,0.16699187596458104},
{0.4562069441211212,0.10373503013372663,0.14717970521541954},
{0.46719777898485126,0.08913698559271616,0.16660712130225983},
{0.47678000224170786,0.07402970693981023,0.1616969189450178},
{0.48569456299630126,0.05565524688963036,0.16952241923385328},
{0.4943860307113974,0.04834975815421234,0.15533499521481597},
{0.495594181905969,0.04638071958821557,0.14757469844718624},
{0.45621287171395813,0.17113283843321872,0.1361285166791685},
{0.4628124380297113,0.16907380823051668,0.14771588293111923},
{0.45024109136683826,0.15510139416983532,0.15808809265150928},
{0.44732633230732094,0.13869974479018482,0.18557487950820378},
{0.4468440417992292,0.1191042006156076,0.19120717044739316},
{0.44843910314442637,0.10974237603786773,0.1860356151332523},
{0.45388979419397674,0.10122927497995395,0.1829026128829225},
{0.4623689463110974,0.09456450514299512,0.1757054374347965},
{0.46843664588775946,0.08603523792279909,0.194387593440418},
{0.4766431287343835,0.06608403817800892,0.181675062293612},
{0.48616284283041483,0.06020548270005092,0.17850811110248918},
{0.4924423191329764,0.05908085667727174,0.17979817085262498},
{0.4894952277488943,0.05238806549235666,0.16632636895062208},
{0.4961745471319073,0.04807870549994396,0.15800241199141254},
{0.5003545778260607,0.047265547537139074,0.1554481583507928},
{0.45724912271626017,0.16438669891277166,0.16757709103920404},
{0.4638449169274808,0.17758960364881074,0.14334185828957693},
{0.4631821042739022,0.18662163851598945,0.1401183255304657},
{0.4644974910116138,0.19808829742289813,0.1326791965201797},
{0.45299041669899903,0.13019418794133628,0.19750820163299795},
{0.45774704051455817,0.09606149177034577,0.18687194459532866},
{0.466489701076882,0.09553501375201538,0.19153588241380204},
{0.46829653914797864,0.09134582223256858,0.1884637727080693},
{0.47618670408594366,0.10144859591491859,0.20080071001784747},
{0.47149851702404666,0.09883991619461481,0.1966239125561505},
{0.47478024796737456,0.07103627255718507,0.19312501616616232},
{0.476680310907633,0.07624231568419515,0.20824846098135072},
{0.48150860470931084,0.06759180224688101,0.18759564979350424},
{0.4927597147857876,0.062032797910038545,0.18357728072217483},
{0.4993883801936491,0.06026960847710444,0.18678788055146014},
{0.477177689833855,0.07284257175620563,0.2001330475155842},
{0.5121973694420735,0.04413739513549397,0.1588651461852168},
{0.5073065664795703,0.20437100695791635,0.13859816740384368},
{0.49950585430623456,0.20437962891113365,0.139044353482838},
{0.49255440452480104,0.20705728425717573,0.14427949570195633},
{0.500941409516912,0.19221728615400546,0.14475639748928723},
{0.49164586620453,0.19380049231352878,0.14864274290197702},
{0.4769739961890967,0.20339295413983088,0.139488384073528},
{0.48209004767940133,0.20284977108714206,0.13807600036212206},
{0.4887057801574369,0.2052261969426554,0.14174787468853195},
{0.4950655483993344,0.20590517575851647,0.14140084107153636},
{0.47420042161351234,0.1901835829388789,0.14499457894691464},
{0.47296748230344104,0.20241382357759333,0.13739109395342422},
{0.4682205581852513,0.19868806204357536,0.13208158738780684},
{0.517117810368761,0.1976210953329367,0.12374038652216275},
{0.5152360690790891,0.20138296129605204,0.13251645715320348},
{0.5266148918375969,0.19422835674193636,0.11656153272462345},
{0.512772345947251,0.18284630075097213,0.14935189855409847},
{0.5086402748678687,0.19256916961968568,0.1456185928110154},
{0.5056328298112654,0.18462242311373228,0.14954427588525906},
{0.4898562720398679,0.18555898278195954,0.1519821331574455},
{0.4806426372830502,0.18288994938913475,0.14881625971047482},
{0.4737364527560074,0.1824195140667166,0.1493535151703267},
{0.5245283791590147,0.1942790107170878,0.1143268302251192},
{0.5323506462153936,0.18482450014226234,0.09426731719303691},
{0.5298729124095773,0.1541492072114017,0.13032109231525313},
{0.5264128148090669,0.1619089651069555,0.14283531853806164},
{0.5149499280066907,0.16442873093470606,0.16243032384056286},
{0.5029368528146366,0.17829552606847554,0.16042194761301226},
{0.52716023037859,0.18691047394876834,0.09864457506703571},
{0.5297910038540131,0.18460517920729771,0.09266632825500289},
{0.530389151858462,0.17946972832225408,0.08171159782037024},
{0.5365948026866006,0.14381417966426127,0.10892625427864429},
{0.5352740272281283,0.15294806135381925,0.12114410085960876},
{0.5388666873593544,0.1516499185225422,0.13484546226602176},
{0.5255339144529803,0.1597259943267549,0.1527300875990447},
{0.5154817947457817,0.16334667580593717,0.1555074342791616},
{0.5156558504263556,0.15574696291697931,0.16457341808713347},
{0.512214613348508,0.15217747428502465,0.17808509652276627},
{0.51116542941638,0.1685236198408388,0.16075065957942114},
{0.506705185242665,0.16124076373261606,0.1770035802660735},
{0.49611365458731027,0.16086786425596866,0.18221824534630077},
{0.4893351827422985,0.1766508884922791,0.15944766689945944},
{0.48802626246949987,0.1796761163273929,0.16052756653992395},
{0.47308980626471125,0.174175849046843,0.15465871075933543},
{0.48120629747462995,0.17630762697981597,0.1574543790900391},
{0.47765836372571846,0.1663562763508446,0.17080331815869568},
{0.48081723183570013,0.16234599036065628,0.1795890884871059},
{0.46223853926868597,0.1425462136692446,0.1989513010527405},
{0.5264618521679902,0.17196054594207766,0.0668834549028737},
{0.5247913487321418,0.17441025839993807,0.07115509384996078},
{0.5356792590293405,0.13583617857789496,0.09289157678280438},
{0.5404622875766276,0.12936648043247712,0.08428525085572887},
{0.5454446987920644,0.1381899718062131,0.10578894105170586},
{0.5398636007001026,0.14813862807480419,0.13696430726916878},
{0.5258723261167585,0.15563433865307838,0.15622251752411995},
{0.5190615219471819,0.16289240664580154,0.15940186277299262},
{0.5229985213350232,0.1501911918125933,0.15808378167490067},
{0.5168370580171232,0.13793239095384668,0.17980194295715754},
{0.5055945698938639,0.12391417276669858,0.1998404399782727},
{0.49327110438598765,0.1448768353982912,0.1941736612262142},
{0.5240024400127605,0.1703256080632506,0.0631302108929757},
{0.5200557409275498,0.16747874688531939,0.05671008897855721},
{0.5223389419139012,0.16571124647577676,0.054980848486416115},
{0.5304333393687006,0.12684563686057448,0.07813025400274179},
{0.5345012846710294,0.12451986498021259,0.07672810886078132},
{0.5416876826776339,0.12392279471991588,0.08597084270970747},
{0.5464340679237475,0.13415920867713377,0.10805112602709019},
{0.5363986532509075,0.14136500607847702,0.1390696804704138},
{0.508959287136908,0.16162551839493722,0.047875281291223724},
{0.518974224670857,0.1297916505005044,0.07190466490778823},
{0.5175004095427779,0.12321202245156616,0.06873124725175242},
{0.5354793374891148,0.11640876249105478,0.08285723985411655},
{0.5409731383047516,0.1202142770923325,0.08866304760180373},
{0.5422481096367572,0.12822407163118743,0.11298126665114716},
{0.53774691118526,0.1282111387013614,0.13684090556374642},
{0.543565112990697,0.10005291723787103,0.1618090043368425},
{0.5325290128725763,0.13051697231490816,0.14986221041014633},
{0.526399881879241,0.1377534854245882,0.15867438547028445},
{0.5275234301578681,0.11826625453730293,0.18911365243182193},
{0.5158417612926033,0.11113589922661088,0.1994282028400714},
{0.49765913970150805,0.11259300932033153,0.20674446901701113},
{0.48564714225360617,0.12016146762887668,0.20208807540760285},
{0.48457694231051107,0.14285822060129508,0.19694885241802682},
{0.4950596208064975,0.1574325547709578,0.047567585335781974},
{0.5209308691791038,0.05792228171369944,0.08459941327608357},
{0.5327407895984757,0.07362501401067396,0.08986904330807101},
{0.5350557840373158,0.07256020278833968,0.0898588047386255},
{0.5417933016045455,0.0806686109171173,0.09593889837303744},
{0.5405792228171371,0.09637727080692858,0.10293076356017693},
{0.5406902304648096,0.1162691946233499,0.0975986243673642},
{0.5421581180000518,0.12097893656829009,0.10878506979471131},
{0.5393980152263694,0.11329138753093135,0.1101047675090315},
{0.5487215798867076,0.08413409723838833,0.12932310123035273},
{0.5388273496978006,0.12035653932041766,0.12327102894389697},
{0.5410593578369245,0.08636933860996879,0.15491736935585387},
{0.5300539734271402,0.08572053663036834,0.1626593444728969},
{0.5371207418328549,0.09506350068544542,0.17097360173473702},
{0.5269888690583965,0.10703885483217375,0.1860248376917307},
{0.5134965900175026,0.09450469034255024,0.19276774397972118},
{0.50990069665382,0.09239015631601184,0.21436627566108826},
{0.4975610649836614,0.08121448833018642,0.21720235939749793},
{0.4740996525352854,0.10830089323435342,0.20369822517093025},
{0.48128281730943334,0.12393842201012223,0.2033608912513041},
{0.4731383047515585,0.13562925170068021,0.20590867842701088},
{0.48021962270332724,0.15261288292249722,0.18702821749739187},
{0.4654146512851022,0.14124807083796756,0.20830773690971954},
{0.45393613719251963,0.14694448755421052,0.18815446013639933},
{0.5150711742238088,0.043244484105429214,0.09269542734711121},
{0.5241641016355846,0.04669811524102673,0.09345577584646027},
{0.5252073579748757,0.05888093513704595,0.10422836751937785},
{0.539281618857936,0.07390307200193129,0.10557015898881734},
{0.5206010794685428,0.04372246363691232,0.09710825077813129},
{0.5318931438228016,0.04183425588232762,0.10531796685721184},
{0.533550175456748,0.04331453747531973,0.11239335721614375},
{0.5299672150228913,0.044308217583611434,0.12072054740780978},
{0.5365441487114492,0.05423316348085502,0.12092747428502455},
{0.543330703637602,0.07394348740763733,0.12359920203822977},
{0.5366325237319263,0.07453786330755373,0.13200614529715562},
{0.543504759318176,0.07714438753955324,0.13925666908081358},
{0.5392212651854151,0.06205974151384261,0.156128753782882},
{0.52716023037859,0.07322193769776605,0.16700157566195048},
{0.5298858453394032,0.07563770121483322,0.18515078718432876},
{0.5263988041350888,0.08628311907779589,0.19021618469948184},
{0.5193288024969177,0.06924506177629484,0.19478528103256515},
{0.5242427769586923,0.07485525896036489,0.2094523011993137},
{0.5185124113016564,0.0788531508928033,0.21801497848822673},
{0.5076401282946639,0.08695024270798299,0.21460661260702},
{0.5334747333660967,0.06217074916151507,0.1367417531017477},
{0.536630907115698,0.0538139210056646,0.15301568979936717},
{0.5248678685669452,0.046812356121155765,0.16000971047481097},
{0.5310600475931818,0.05071971754481263,0.16195180543700372},
{0.5368771716544667,0.04744984178715851,0.17659242087202437},
{0.5338487105868964,0.04921195347594042,0.1872389164791392},
{0.5246776467240889,0.05972049783157875,0.18803429166343344},
{0.5241700292284214,0.06972896890061482,0.1887294366415768},
{0.5349970469810231,0.04381784399437855,0.13007051679987586},
{0.5423510342032885,0.04430875645568747,0.13942102506401802},
{0.5421150082339654,0.04660381262771269,0.1476819339903262},
{0.5287682246536131,0.03849163239440269,0.12933872852055905},
{0.5095951561866826,0.0641069165308709,0.18990687212781185},
{0.4833310700706139,0.0752044480656648,0.21136745255770245},
{0.4715351603252201,0.11679136166507154,0.2142849059776002},
{0.47528247674228125,0.1178766500262971,0.2032493447315555},
{0.46899815059103495,0.1274039083313935,0.21225120276247383},
{0.45351527810110104,0.1310676995766622,0.2085286744609124},
{0.4443862462602278,0.10486935585387516,0.18784029771604463},
{0.44034308907339875,0.09567027064311148,0.1928545023839701},
{0.4474303346180044,0.08218769129958697,0.20186875447263825},
{0.4563222627454024,0.08098385108162397,0.20977239121250532},
{0.46557577403585015,0.09008540044661716,0.21022881586094516},
{0.4310335350870386,0.09511361578852069,0.20916023253407828},
{0.43638237931420987,0.08739535104282516,0.20304996206340586},
{0.438212388884578,0.08017985394411252,0.19870773087435228},
{0.4510941258632731,0.07425764982799203,0.20186228800772527},
{0.4553275048929585,0.06953820818568236,0.21291509316020452},
{0.4560054059646673,0.07298806721674726,0.2238913784778804},
{0.45854457118715675,0.08302725399411989,0.22230224472552015},
{0.42612710483432925,0.08271578593414561,0.20724292568738523},
{0.4269273298673082,0.06556133226421114,0.20807171094039645},
{0.43483581645585995,0.06052880594569895,0.2054851249752119},
{0.44709677280291077,0.0596272729624169,0.21175436270832795},
{0.441071644120259,0.05589989481217083,0.22628882034436082},
{0.4244522904218722,0.05963158393902554,0.22154890156316015},
{0.4216221342782994,0.06975591250441876,0.21699651026443534},
{0.443096186510092,0.12354720088288795,0.20708288068078945},
{0.43020205547364704,0.09486411801729566,0.21434795401050155},
{0.4286021442797652,0.07741274583344107,0.2229327250545339},
{0.4417182906115552,0.07135851805868104,0.22979526094341415},
{0.4448151884327876,0.07341808713345924,0.22820774380728215},
{0.4465368847158636,0.09381924506177625,0.22864315244475486},
{0.43903470767267616,0.09704654992542007,0.2266498646353345},
{0.43471726459912235,0.08966454135519862,0.22271340411956925},
{0.4504717286154005,0.1297765620823742,0.194205993550779},
{0.4433386789443281,0.11785940611986252,0.19214750222015298},
{0.4446626876352569,0.1271350111654295,0.20940434158454257},
{0.46017573696145125,0.1387380047075866,0.20271370588793186},
{0.45979744876404305,0.13911305967253815,0.20773114378831384},
{0.44873548278627046,0.12776495262236715,0.2141954532129709},
{0.4698344800531113,0.13592024262176347,0.2115253420759939},
{0.466456291008165,0.12024984264935373,0.21882921419518378},
{0.47207726563375674,0.10952628833535955,0.21340762223774176},
{0.47180998508402094,0.1359175482613832,0.20676063517929355},
{0.4765784640852539,0.1184063612770837,0.20270400619056242},
{0.4751827854082064,0.10730667425398543,0.20302571281998225},
{0.4410732607364873,0.11831313640792199,0.20077484415819563},
{0.4605901295879569,0.12400416440340387,0.20594262736780392},
{0.43191944078011435,0.09318068165162131,0.22601776769009255},
{0.44889983876947487,0.08781351577386338,0.23199493675797317},
{0.4497367071036273,0.09593539570454286,0.23113435805247323},
{0.43603049584852954,0.10125190760714936,0.2245417970737091},
{0.44347016373089165,0.09796424907098451,0.22819049990084755},
{0.4626216773147789,0.09202156781597298,0.2210375119629601},
{0.46060629575023926,0.08371269927489365,0.22156129562090998},
{0.4493217756050456,0.0837983799349904,0.22728303932472865},
{0.4409913521809231,0.06907100609572092,0.22598543536552773},
{0.4296642611417191,0.07312763508445203,0.222186926101239},
{0.43230527318658774,0.09039471301828729,0.22152195795935614},
{0.4288360147607839,0.0948819007958064,0.2105063349801264},
{0.4328225903796246,0.10229947492304908,0.21014475181707667},
{0.5371110421354854,0.0951200822534336,0.1676487610253227},
{0.5278807023443092,0.07014336152712032,0.18786131372701176},
{0.5357784114913393,0.05546233068639375,0.19319722502435704},
{0.5251771811386151,0.05281108007207957,0.19690897588439688},
{0.5146632480622161,0.05982611675849049,0.19006098954157077},
{0.5192404274764406,0.05047722511057654,0.19405834260193305},
{0.5342075993895657,0.043804911064552615,0.18853598156626403},
{0.5410173258149902,0.053327319520964325,0.18769695774380732},
{0.544378809825578,0.04901903727270382,0.1754780334186907},
{0.5354884983144081,0.03826207288999254,0.17555239776518974},
{0.535359169016149,0.03941472026072785,0.16376780433339372},
{0.5251470043023547,0.03793551641188793,0.16447588224136298},
{0.5215618883801937,0.04825922764543079,0.15810210332548738},
{0.536206814791823,0.05909109524671726,0.1580875537794332},
{0.5397401989946803,0.08819827043618453,0.15744467939266962},
{0.5394729184449446,0.09614771130251844,0.15994774018606178},
{0.49443183483786424,0.036490800375917176,0.18672052154195012},
{0.49065757481699906,0.05115458731020928,0.1815424997628963},
{0.5020390919358872,0.044167033099678454,0.19359922359311282},
{0.49627262184975385,0.00987752515454849,0.20322293999982757},
{0.4910746618038851,0.01988168524697592,0.19359221825612374},
{0.49239274290197704,0.03175842580378157,0.17799941586266954},
{0.49801641188794915,0.029176689687281744,0.17037114275367946},
{0.5071179612529423,0.03576008984075259,0.16005443685712561},
{0.5247164455135667,0.02603129337920218,0.1673663920574567},
{0.5076131846908599,0.03095227317796575,0.16347142469154963},
{0.49967667675435196,-0.0008023805212833313,0.17905937723631915},
{0.5140360009656588,-0.0035473948768354018,0.18209969348956315},
{0.5018316261865964,-0.01939508376227552,0.18317528215341905},
{0.484576403438435,-0.02483930834691291,0.184331701628687},
{0.4808247760447652,-0.016433981704215273,0.18734022442944226},
{0.4713293111921575,-0.021875511928472244,0.1843230796754697},
{0.4750550727261754,-0.03799425346818062,0.18697433028978386},
{0.4620655613322643,-0.027779933266082125,0.18692529293086058},
{0.4605216928342947,-0.0414775225679625,0.19347312752731005},
{0.46051522636938175,-0.019128880956691945,0.19182633446280922},
{0.45585721614374525,-0.03832134881836126,0.20363571601010497},
{0.45719200227619566,-0.02277381167929784,0.20243834225705495},
{0.4661426674598864,-0.028244979867739176,0.21392817266323516},
{0.4665193390410664,-0.013171650155626253,0.20270939491132323},
{0.4755583792452342,-0.019273837545157418,0.21304226697015943},
{0.4793784433925662,-0.011555033927385846,0.20869841916487764},
{0.4858982566410595,7.274773027081353e-05,0.20457658665494083},
{0.5080884698619625,0.007977462214290047,0.20826247165532882},
{0.5166867127078969,0.039519261443487406,0.20111110033366963},
{0.4954589250148729,0.012366575273962623,0.17569519886535098},
{0.49019522257572234,0.005150000431097682,0.18884367752170578},
{0.4938282981126545,0.0005275557624824669,0.18303894751817076},
{0.4768910098893804,-0.010620629747462978,0.19493832070217187},
{0.49108490037333064,0.007295789038048663,0.1958506311269755},
{0.5216691239233336,-0.0030672598570480325,0.1866806450083202},
{0.5214298647215541,-0.010626018468223815,0.19664331195088935},
{0.5189920074493676,-0.005899032616849043,0.20696378995197573},
{0.5123698085064191,-0.0028581774915289178,0.2109395881292948},
{0.4918894363829182,-0.0293162575549865,0.18840180241932009},
{0.49613736495865773,-0.0312707465749291,0.20583377520843574},
{0.48526508195166534,-0.01855174896321012,0.21390500116396371},
{0.4827528603329798,-0.03637817611201637,0.1935151595492443},
{0.4759447505237837,-0.03022641249148584,0.21289299940508527},
{0.47556430683807116,-0.039964369778329574,0.19775554391591874},
{0.5277362846279197,0.00365678590827964,0.1875697839338524},
{0.5258480768733349,0.008623030961434042,0.20371546907736482},
{0.529998469603304,0.002597902278782216,0.19666917781054125},
{0.5272895596768492,0.005956153056913503,0.18124342576067184},
{0.5263535388806981,-0.00877714837519284,0.1883662368622988},
{0.5237470146486986,-0.00908107222610203,0.20274765482872492},
{0.5184596018382005,-0.004701119991722901,0.21144828336911445},
{0.5219035332764285,0.0033641783709681588,0.21135451962787652},
{0.5217429493977566,0.016953454385556486,0.20654400860470934},
{0.5032914306406974,-0.00019291620323660496,0.21236436589845067},
{0.5019663442056164,0.0064082667287447374,0.20889834070510335},
{0.5102326418526854,-0.01263008371916578,0.18302601458834486},
{0.5088110973159861,-0.005825746014502074,0.17982295896812467},
{0.5226751980893752,-0.012761029633653243,0.19227467603010787},
{0.491242251019546,-0.0129970556029763,0.2146389449315848},
{0.4834841097402206,-0.014572717553434518,0.21449129398273886},
{0.4875202615900606,-0.03104280368674718,0.21401439219540797},
{0.48392814033091064,-0.027220584051110913,0.2119111744824673},
{0.4707360130363933,-0.03261307691644468,0.20814553641481942},
{0.47285916901614894,-0.037500107774415245,0.19657649181345546},
{0.49128104980902376,-0.03760141572471822,0.19686532724623437},
{0.48717807782174977,-0.03477233732529763,0.19482246320581467},
{0.4900922980091911,-0.026892949828854235,0.18451761249493462},
{0.49746945673072784,-0.02477733805816365,0.18590413034668876},
{0.4999876059422502,-0.03428627471267339,0.19927408542631248},
{0.4980174896321013,-0.03124218635489681,0.20211771337178727},
{0.4959988748351052,-0.02707616633472148,0.21395296077873485},
{0.496051145426485,-0.02798416578291644,0.20900611512031939},
{0.5171609201348474,0.0006003034927532804,0.19699681203279795},
{0.5435096091668606,0.07967762516920578,0.13727308096876267},
{0.5374408318460464,0.060037354612313874,0.1540605627548865},
{0.5457739496305494,0.06398620918582895,0.14776707577834683},
{0.5476761680591121,0.04521298379934994,0.1533072195925265},
{0.5357794892354915,0.04485355612460452,0.16238398084201996},
{0.5248543967650432,0.05284772337325299,0.15778901864928482},
{0.5296212591500479,0.04275572713242455,0.16077275333454044},
{0.5404191778105413,0.03689064345636864,0.15454770311166294},
{0.54182293956873,0.03247243130458773,0.1410198585137477},
{0.549127350559996,0.041036186337652936,0.1390066324375124},
{0.5389906279368528,0.03335887586973959,0.12958553193140376},
{0.5294073269358441,0.03210869265323366,0.13194686936878683},
{0.5253598587724063,0.04131963304967109,0.12708893760292458},
{0.53890440840468,0.04969963270479301,0.12497278696015797},
{0.5442160704586018,0.07169639085038323,0.12474646068820433},
{0.5451019761516774,0.08131148530388076,0.12863981143788314},
{0.5000819085555642,0.032534401593336995,0.150418326392661},
{0.5034827302277058,0.027709341024115573,0.14177805152479242},
{0.503349089952838,0.02984058008501251,0.13720518308717658},
{0.5126354724399266,0.02974519972754628,0.13198297379788418},
{0.5286491339247993,0.023782041333643714,0.13201476725037292},
{0.5071675374839417,-0.00123671141460383,0.1459305997430658},
{0.5212439538553064,-0.003904128191200406,0.14564553641481942},
{0.5081913944284938,-0.01929485355612461,0.14779078614969435},
{0.4972711518067303,-0.00968029797470312,0.14903989162204806},
{0.4907922928360191,-0.02619672710655869,0.15212978410629144},
{0.48541273290051135,-0.014260171749308038,0.15991648560564914},
{0.4788282550028884,-0.023017381857686,0.15509465826888424},
{0.48171768707483,-0.036194420734073085,0.1548494714742678},
{0.4713481717148203,-0.029342662286714404,0.15885275212746697},
{0.4721661795263099,-0.04292439409223763,0.16438696834880975},
{0.4671940068803187,-0.03316811515480712,0.1689571424260452},
{0.4709310847279343,-0.040607783037169186,0.17599858384418407},
{0.4700446401627825,-0.025864243035617327,0.1744288494865627},
{0.48085064190441706,-0.031056814360725306,0.18270161359854464},
{0.4779418104377366,-0.016497029737116604,0.1736049140822362},
{0.49212923445677387,-0.02201454092410096,0.18091471379426297},
{0.4933018200943242,-0.01471012993283501,0.1788788550908323},
{0.48728854659734616,-0.01244632834122238,0.1687847033616996},
{0.509020179681505,0.007061918557029869,0.16949547563004927},
{0.5218641956148746,0.005155389151858518,0.171168673426278},
{0.5277303570350828,0.03376895751963656,0.1669897204762767},
{0.5128515601424347,0.03946375761965117,0.16184510876593985},
{0.5064405990533096,0.03370213738220262,0.15827184802945263},
{0.49929677194071553,0.016533134166213992,0.15253609365165588},
{0.5032181440383505,0.0102730572583913,0.14482914521955806},
{0.5027902796099428,0.005474940292973942,0.16401730210461882},
{0.5003852935343973,0.0031313856341015555,0.15565724071631187},
{0.4731135166360588,-0.018940814602139904,0.16469628092047975},
{0.5358630144072839,0.036653539742893385,0.1587142620039144},
{0.5256152841364683,-0.004805122302406422,0.17212139925678765},
{0.5046283722614522,-0.03030616555874572,0.17184280239345423},
{0.4917240026555616,-0.03009654432115045,0.17901572859815665},
{0.486695248441582,-0.03681520136571741,0.17651159006061234},
{0.4900335609528983,-0.03807993412827737,0.15794636929550024},
{0.49894003862635045,-0.028537587405050774,0.15387519076071493},
{0.5308870696567601,-0.010830789857134164,0.15662451609287567},
{0.5285478259744963,-0.00559187553348328,0.14895367208987526},
{0.5310789081158447,-0.00659040549045979,0.16643899321452285},
{0.5040604010932637,-0.03227143202020987,0.16526694644904857},
{0.534768026348689,0.0021824319081245255,0.14830756447065518},
{0.536233758395627,0.005498650664321551,0.1642015963546382},
{0.5386549106334549,0.00032009001319157954,0.15609372709793679},
{0.5333432485795332,0.004777639826526323,0.1431096044247864},
{0.533737702939224,-0.006240138641007693,0.14674106334549028},
{0.5313844485829821,-0.013617836234620616,0.1531202309821267},
{0.5338842761439176,-0.010055352939654896,0.16467688152574086},
{0.5339122974918739,0.0006396411543071232,0.17163318115585907},
{0.5331557210970573,0.013173805643930635,0.16819409956631579},
{0.5170666175215334,-0.003269875757654119,0.1757544747937198},
{0.5154090470155109,0.0034380038453911636,0.17343193614581448},
{0.5176863204090255,-0.012643016648991595,0.14659395126872043},
{0.5158891820352983,-0.005944297871239759,0.14434362147900986},
{0.5291556736763147,-0.006824275971478584,0.1726915259132804},
{0.5027207651121286,-0.015895648500211253,0.17950071346662877},
{0.49570734504194586,-0.01810394626798753,0.18088130372554598},
{0.500315779036583,-0.03211354250191835,0.17855175974065168},
{0.4961341317262013,-0.029609403964374014,0.17758394549201179},
{0.48388988041350894,-0.03567333143650365,0.1763741776812119},
{0.5004386418699293,-0.038699098143693454,0.16205957985221975},
{0.4835309916108395,-0.039316645542881314,0.1649705668072045},
{0.49601989084607234,-0.035572023486200546,0.1605297220282283},
{0.4960597673797022,-0.02739679521998909,0.1510337183035445},
{0.5028576386194529,-0.024901817507738205,0.15095827621289326},
{0.5087151780864437,-0.034410754162247946,0.16242924609641068},
{0.5070516799875844,-0.03160430839002265,0.1649339235060311},
{0.5073006388867335,-0.028893781847339626,0.17470475198951574},
{0.526897260805463,-0.001504530836415631,0.1591070997473768},
{0.5374316710207531,0.07617980652336985,0.10402090177008701},
{0.5328146150728986,0.057393648207064905,0.11953880094496609},
{0.5389534457636034,0.0445280773906521,0.11718770207702854},
{0.5305082425872758,0.043588823362044435,0.1257255912504419},
{0.5213878326996199,0.051813088987179214,0.12470820077080262},
{0.5244119827905814,0.042774048783011324,0.12529341584542564},
{0.5318505729287913,0.03729048653682009,0.11764197123716408},
{0.5302792219549417,0.03431375718855349,0.10537562616935242},
{0.5375475285171103,0.04133472146780129,0.10274646931015753},
{0.5251944250450498,0.03681035151703272,0.09580795245854996},
{0.5177272746868076,0.03681196813326095,0.09960430623453438},
{0.5147850331514101,0.04708286990334787,0.09684150910047162},
{0.5276797030599312,0.05151293724080251,0.09274985342679531},
{0.5378519912400955,0.07653815645396309,0.09716159911366322},
{0.5350988938034023,0.07282640559392325,0.09340943284791738},
{0.5021080675616254,0.03543245561849579,0.12753943465852757},
{0.4949669348094118,0.036508044282351756,0.12055188044799671},
{0.4928712613055362,0.014433149685729882,0.12518025270944882},
{0.4942858005052465,0.016677551882603548,0.11562012320771149},
{0.4954702413284706,0.032857185966908994,0.11337572101083782},
{0.5031362354827863,0.033893436969210995,0.10349065164722418},
{0.5159484579636672,0.025405662898873183,0.10021915927334178},
{0.5203429597441005,0.03285018062991993,0.10049128967176225},
{0.5028280006552684,0.011025322676599116,0.13587039695472614},
{0.4964024900200892,0.011384211479268503,0.13202446694774234},
{0.4918867420225378,0.009228184302872004,0.1252589280325565},
{0.4960128855090833,0.005973935835424119,0.11520195847667332},
{0.507479005543916,0.0014495658846555538,0.11233839226438358},
{0.48885289223420675,-0.015859005199037827,0.11973117827612668},
{0.4825276118051784,-0.010008471069035954,0.12321283075968031},
{0.47652134364518944,-0.018717721562642783,0.12355501452799118},
{0.47355646948259666,-0.007526965158687039,0.12978329798332516},
{0.4674526654768371,-0.015871399256787606,0.1310038432356466},
{0.468393536121673,-0.028237435658674075,0.13268781847339697},
{0.465212035384496,-0.022655798694636315,0.13959615848874407},
{0.4689210918841555,-0.027112270763818867,0.14551566824448411},
{0.4696113870136141,-0.013976725037289882,0.1450495438986748},
{0.479558426665977,-0.02048306648388127,0.14974850840209342},
{0.47709524240621476,-0.006414733193657646,0.14302446263676574},
{0.4905519558900874,-0.013456174611796599,0.14641235137908143},
{0.4930900433684247,-0.006093026564237839,0.14446702318443222},
{0.48230829087021376,-0.0034261486597172994,0.1339557844684135},
{0.4928561728874059,0.00297457385996222,0.13965435667296072},
{0.5136178362346207,0.007605640481794725,0.1349467702163248},
{0.5224499495615738,0.032141024977798444,0.13151631057999882},
{0.46712557012665656,-0.012532547873395165,0.13781572514937535},
{0.5120049921109128,-0.004451083348421717,0.11461997663450679},
{0.5170148858022297,-0.006308575394669861,0.11975273315916989},
{0.5195066302820242,-0.0032628704206650555,0.12828038376313772},
{0.5156057353232801,-0.0020450195287240337,0.1347053555262409},
{0.4998162446220567,-0.021655652121431578,0.1332854276057698},
{0.48749547347456096,-0.02095350180629916,0.14530065828612815},
{0.4804216997318573,-0.027719040721485056,0.13263662562616937},
{0.483278260607158,-0.02492498900700966,0.12529934343826252},
{0.5207966900321599,0.004862781614547037,0.11267788167231406},
{0.5252871110421355,0.0061097315985963845,0.12499003086659255},
{0.5250667123630187,0.0023947475061000937,0.11818838752230931},
{0.5189817688799221,0.007862682462084972,0.10826451936921791},
{0.5182936292387678,-0.004182186182457724,0.11216056447927715},
{0.5207913013113991,-0.007040902546062797,0.12562967202089964},
{0.5204771388910444,-0.004580412646680953,0.13357695739892916},
{0.5242761870274092,0.013279424570842264,0.13056951234232606},
{0.5093682910426529,0.0007921419518378138,0.13926313554572656},
{0.5085696826259022,0.00679625462352245,0.13766753532845333},
{0.5034638697050431,-0.005367165877757931,0.11345385746186942},
{0.5024965943284793,0.0008665062983368543,0.1120506345757568},
{0.5156105851719649,-0.008718411318900153,0.11626245872239899},
{0.49939053568195346,-0.009264288731969274,0.14373092392850678},
{0.4934365381133442,-0.010689066501125147,0.14610627203986795},
{0.49532151263547247,-0.02412476397403071,0.14228836338084033},
{0.4920036772630472,-0.020709392755834846,0.14252331160601125},
{0.47981708526249545,-0.02472776182716429,0.14336502978884838},
{0.4781481984428753,-0.02698671357009212,0.13318950837622756},
{0.4918134554201909,-0.02704598949846096,0.12725329358612902},
{0.48793195985618587,-0.024480419544243525,0.12761864885371135},
{0.487085391824664,-0.0165994154315719,0.11988314020158129},
{0.4934074390212359,-0.015138533233318636,0.1185677534638697},
{0.49912002189976123,-0.023805751704991204,0.12790317330988163},
{0.5011079209884207,-0.020832255589181174,0.1379687648189821},
{0.5153190553788056,0.002179198675667952,0.12305979109007356},
{0.5211016916272213,0.11301817938835859,0.19334325935697474},
{0.5100181707664054,0.09523055102903015,0.2143301712319909},
{0.5204394178457188,0.09343502927153126,0.21638327384185613},
{0.5190356560875301,0.08250832018485471,0.2231493516291181},
{0.5078384332186614,0.08126945328194662,0.2251049183932128},
{0.4989729098229913,0.085469961114991,0.214566197201314},
{0.5031793452488726,0.07746447755274481,0.22163134899080042},
{0.5189009380685101,0.07299507255373633,0.22118516291180604},
{0.5276349766776166,0.07888871644982454,0.21656271824319084},
{0.5304290283920919,0.07108908202064101,0.20615817619823598},
{0.5240929705215419,0.06580490244259941,0.21046538070234433},
{0.5245348456239277,0.06373671141460392,0.19835045868791118},
{0.5171700809601407,0.06188891906572514,0.198322437339955},
{0.514494581102403,0.06899233077261324,0.18991279972064873},
{0.5261870274091893,0.08079686247122435,0.19090647982894046},
{0.5309549675383461,0.08641029288775086,0.2028996167541795},
{0.5263573109852306,0.10567712509591921,0.18661651923126665},
{0.5245213738220257,0.11328707655432259,0.187735217661209},
{0.4883291085762569,0.06902035212056937,0.21880011510307545},
{0.4839071243199435,0.05939124699309384,0.21349976936275145},
{0.48481835700059495,0.03684483932990176,0.23376836476035281},
{0.4811071450126312,0.0453724899338697,0.220841901399343},
{0.48459310847279347,0.05354125173516812,0.20443055232232313},
{0.4781519705474079,0.06536194959606151,0.1996448294146556},
{0.4841857211832769,0.05860179940163644,0.19177298612727728},
{0.493064716380849,0.04978046351620496,0.19884083227714408},
{0.5023925920177957,0.05250176750040954,0.19478204780010866},
{0.517669076502591,0.05039316106670802,0.2030219407154497},
{0.4950488433649759,0.024399588732831577,0.2137751329936284},
{0.5075361259839805,0.02349751687747349,0.22054067190881424},
{0.4928561728874059,0.021723011130941675,0.21411623901778712},
{0.4977157212694965,0.00887630083719168,0.2184142826966021},
{0.478502776268936,0.001747023270651716,0.21138146323168053},
{0.4742117379271101,0.011037177862272981,0.21243711362872147},
{0.4706955976306873,-0.002549942664011083,0.20780389151858464},
{0.46461712061250354,0.01111154220877202,0.20797633058293027},
{0.45791786296267556,0.0014517213729598165,0.20524478802928017},
{0.45526876783666576,-0.011804531698610994,0.20947547269858516},
{0.45225000646646496,0.00632366381280018,0.20948948337256323},
{0.4456499012786357,-0.008497473767707295,0.2177886522162731},
{0.4480759033651484,0.0067105739634257,0.21722930300130194},
{0.4510240724933827,0.0012981428312770545,0.2305464486174698},
{0.4564785356474656,0.015373481458489623,0.2208672283869188},
{0.4617368493658554,0.01280360052766354,0.2321318102652975},
{0.46828037298569625,0.017167925471836435,0.21768949975427437},
{0.48182438374589387,0.03233825215764381,0.22614871360458},
{0.47798923118043163,0.020685682384487356,0.24194359302656424},
{0.4952552313701146,0.038161842683841624,0.24088740375744724},
{0.5006342524335463,0.06819264461171032,0.22956839579938443},
{0.4902167774587656,0.03432453463007516,0.20761205305950012},
{0.48312791529793164,0.028979462507436493,0.21979325633929112},
{0.5219277825198521,0.06001202762473815,0.20820966219187298},
{0.5130714199494754,0.02462106515610047,0.22686595233784265},
{0.512766418354414,0.023554098445461913,0.2358500275902503},
{0.5074385901382099,0.027807415741962223,0.24392448677823475},
{0.5009354819240751,0.03094095686436804,0.24524741772501144},
{0.49874227257442905,0.007441823370666446,0.23422856151332525},
{0.49269073916004935,0.011388522455877148,0.24225344447031033},
{0.46509456127191057,0.005759464749144288,0.23666372442513128},
{0.4585898364415475,-0.003432615124630327,0.23144852047282793},
{0.46620086564410307,-0.0107321762672116,0.21904099092108328},
{0.473901886483364,-0.008626803065966533,0.21461954553684595},
{0.48367487045515295,-0.0011057655001163657,0.2178991209918695},
{0.4805558788788012,-0.0030505548226894873,0.23472701818369937},
{0.46658723692265247,-0.003419682194804391,0.22631630282024093},
{0.5183211117146479,0.03404755438296991,0.22689720691825527},
{0.5118745850685015,0.04122748592466143,0.24015884871058693},
{0.5187112550977299,0.03451798970538792,0.23507890164937967},
{0.5201150168559185,0.029639041928558495,0.2239910698119552},
{0.5148028159299208,0.01872149366717539,0.23361963606735472},
{0.5126252338704811,0.023942086340239505,0.24229116551563593},
{0.5050680918755336,0.028698171283722602,0.24833138261641796},
{0.5071001784744317,0.03716115723856085,0.24740775587801664},
{0.5064890975401568,0.04861003336695892,0.24021165817404277},
{0.49008259831182155,0.030569135131872836,0.24498498702396043},
{0.4891153229352578,0.03588079718579454,0.24026931748618335},
{0.5188319624427719,0.035396890061474555,0.22061557512738939},
{0.5037785709974738,0.020811778450290138,0.21742168033246254},
{0.5052286757542054,0.015210742091513414,0.2222030922635214},
{0.47393529655208094,0.014941844925549421,0.24080657294603522},
{0.46712557012665656,0.013643163222196332,0.23776302346033473},
{0.46993848236379476,-0.002347326763404996,0.23879711897433248},
{0.46767899174879085,0.0014705818956226246,0.23567866627005685},
{0.4572167903916953,-0.0035883491546174714,0.22690205676694},
{0.4640658544786736,-0.008304018692394536,0.21798264616366195},
{0.47955249907314007,-0.008996469310157473,0.22514964477552746},
{0.47667007233818753,-0.006384556357397129,0.2217773833234181},
{0.48343668899752557,0.0009678142486399575,0.2136344873817715},
{0.48966389470870736,0.002692204892096256,0.21772129320676306},
{0.4863509091849668,-0.006096798668770448,0.2306773945319573},
{0.4836710983506204,-0.003058637903830742,0.2322789223420674},
{0.4777952372330428,0.001311614633179026,0.24200394669908523},
{0.47964895717475836,0.00015681177413933575,0.23766548761456424},
{0.5066367484890028,0.030860126052956093,0.23383302940948245},
{-0.014301126027090189,0.7950421613512326,-0.16040901468318633},
{1.8860522662793683e-05,0.7769360595949408,-0.15914913176931103},
{-0.019099242992507533,0.795624143193399,-0.1649387733547158},
{0.014569484320978066,0.7666031875361045,0.07911154005328368},
{0.029403015959235397,0.8009056284110603,0.07566329763844702},
{0.01684729658656871,0.8082579990170975,0.08778199175741273},
{0.009693230904529102,0.7751658648250176,0.08744896881439522},
{0.0011235482786270301,0.7808601260529562,0.09345685359061244},
{0.0011235482786270301,0.8125662812653579,0.09363037039911022},
{-0.014599122285162492,0.8082585378891736,0.08778253062948882},
{-0.007445056603122883,0.7751674814412458,0.08745004655854738},
{-0.012321848891647925,0.7666037264081806,0.07911154005328368},
{-0.02715484165782918,0.8009056284110603,0.07566275876637094},
{0.006966538199563719,0.7597002362415182,0.07969998836036316},
{0.014414289163066992,0.761265659622531,0.07878713906348345},
{-0.004503353939801533,0.7596576653475079,0.07978674676461207},
{-0.012166653733736852,0.761265659622531,0.07878713906348345},
{0.08480122086857557,0.7523839700645786,-0.03895263745548917},
{0.09027831664985386,0.7564449100299184,-0.05272512997594476},
{0.08952659010372209,0.7683518274229846,-0.041508507712337155},
{0.08006076321529879,0.7540657898140245,-0.02054584508074459},
{0.09631583939025547,0.7794579809109957,-0.04096424691549624},
{0.09081611098178181,0.7765416052352501,-0.05449478587379185},
{0.09403802712466482,0.7768789391548762,-0.06219311235267238},
{0.08956053904451515,0.768394937189071,-0.06752363492925689},
{0.0901279713406275,0.7885158816378263,-0.07540841114646112},
{0.09039579076243932,0.8132883698473053,-0.06759314942707122},
{0.0850981393824957,0.8219103230645872,-0.08259480915306555},
{0.07164358138692739,0.7458625401998571,-0.008484271401843373},
{0.05461468491071967,0.7383743738306475,0.02632363148047559},
{0.06475410189424312,0.7386265659622532,-0.010719512773423692},
{0.08114174059991551,0.759348352775838,0.004991841476768148},
{0.0874346887043791,0.7624280066906358,-0.011690560254520059},
{0.09605933628204133,0.7841725727046206,-0.015617321072915857},
{0.09677980824776045,0.8081890233913591,-0.056856123311174914},
{0.08875708077907969,0.796119905503393,-0.06134600544907444},
{0.08918548407956338,0.778343593457662,0.005607772259727719},
{0.08650621211729305,0.7808444987627499,0.004987530500159506},
{0.08223241768190166,0.8044681117060258,0.002206950587586113},
{0.0939679737547744,0.8137685048670926,-0.029193125285602202},
{0.07601598941224144,0.776695722649009,0.024940885733254016},
{0.06882689704525663,0.801427256580706,0.030701967098626524},
{0.0705809256528974,0.7960854176905238,0.022483090194252604},
{0.043625466663217885,0.7608658165420794,0.061773869877482054},
{0.06426911702577101,0.7847017450833312,0.03444982238776373},
{0.030561052050731563,0.7713468784218377,0.06675412560461448},
{0.022150336687273127,0.7564853254356243,0.07311443271858808},
{0.020449117543088202,0.7581148745936905,0.07012099833596304},
{0.01056620366777889,0.7356250484984869,0.0807313895139805},
{-0.008127807523516387,0.7358034151556694,0.08049805790503782},
{-0.019903240130019064,0.7564853254356243,0.07311443271858808},
{-0.018201482113758063,0.7581148745936905,0.07012099833596304},
{-0.028312877749325345,0.7713474172939139,0.06675412560461448},
{-0.04137837010596382,0.7608652776700036,0.061773869877482054},
{-0.07336581654207947,0.7766736288938897,0.024943041221558333},
{-0.060400554391591886,0.7928845175586077,0.041290264521524705},
{-0.04578634368829916,0.7846656406542339,0.056881450298750684},
{-0.040793155031340816,0.7911784485657382,0.0650545230766578},
{-0.05319799022270506,0.8058454687324867,0.05875564737935733},
{-0.04680535078416666,0.8065961175344665,0.05957581067915126},
{0.06425833958424941,0.7561528413646829,0.03557390953846685},
{0.03228059284550321,0.7281918470810378,0.06169627229852651},
{0.04658387436089771,0.7246676237034737,0.030765554003603982},
{0.00794459101764913,0.7231027391945374,0.036682369398963646},
{0.0011160040695619084,0.7266291180604055,0.06564297138373727},
{0.08470368502280506,0.8141721200520766,-0.01529507557141995},
{0.018694011191295268,0.7238248277764846,0.02645673288326738},
{0.02272423544829845,0.7268247286240227,0.016160504125604616},
{0.04426187458506849,0.7362512178508921,-0.000434600329358612},
{-0.030030801927868753,0.7281848417440487,0.06169735004267867},
{-0.062008548666614954,0.7561496081322263,0.03557552615469509},
{-0.07889410517058536,0.759348352775838,0.004991841476768148},
{-0.08693946526646147,0.7783398213531295,0.005603461283119081},
{-0.06657926161592649,0.801427256580706,0.030701967098626524},
{0.0011235482786270301,0.7208718087995656,0.03220757567919437},
{-0.005697494460395069,0.7231027391945374,0.036682369398963646},
{-0.04433516118741541,0.7246676237034737,0.030765554003603982},
{-0.052367049481389524,0.7383738349585717,0.02632147599217127},
{-0.06939594595759724,0.7458630790719329,-0.008483732529767295},
{-0.08518651440297287,0.7624274678185596,-0.01169109912659614},
{-0.08426019330419116,0.7808461153789781,0.004981602907322627},
{-0.06833329022356727,0.7960854176905238,0.022483090194252604},
{-0.06011225783088902,0.8928393600786322,0.06677298612727728},
{-0.07895499771518241,0.8958715932507351,0.027711765948457964},
{-0.0868144469448109,0.8946591310795547,0.04140881637826233},
{-0.06406596225308883,0.8913294405214558,0.07409571876912996},
{-0.0769336885578059,0.8821454437288225,0.0553445871377702},
{-0.08337159325073504,0.886084059732892,0.0348706814791823},
{-0.07276389643309797,0.8809841744048698,0.05465590862453981},
{-0.05864490916772287,0.8784487812869128,0.07196879068484174},
{-0.05578349844373746,0.8787893484389955,0.08043824310459292},
{-0.04671535914746128,0.8771770431873639,0.08158873498702397},
{-0.03128529612098326,0.8761413310571379,0.08941315753170724},
{-0.021427170361173635,0.8776135295689887,0.09750701611443058},
{-0.014145930869179115,0.8757651983480338,0.0940021921316055},
{0.0011235482786270301,0.8757759757895555,0.09600248527801489},
{0.03043495598492882,0.8776846606830312,0.09506915884224414},
{0.016393027426433178,0.8757651983480338,0.0940021921316055},
{0.03353239267823732,0.8761407921850617,0.08941315753170724},
{0.058033828233448,0.8787893484389955,0.08043554874421252},
{0.0489635334488675,0.8771770431873639,0.08158873498702397},
{0.06089308346912909,0.8784487812869128,0.07196879068484174},
{0.07918186285921212,0.8821449048567463,0.05534350939361804},
{0.0750120707345042,0.8809841744048698,0.05465590862453981},
{0.08561922868006518,0.886084059732892,0.0348706814791823},
{0.08906369899036927,0.8946596699516309,0.04140504427372978},
{0.05939178586516989,0.8902479242647631,0.0820349210660183},
{0.062359354388143086,0.8928393600786322,0.06677352499935336},
{0.0812042497607408,0.8958715932507351,0.02770745497184933},
{-0.03926814705603409,0.8879340075700751,0.09369180181578336},
{-0.021821085848788196,0.8892105955183088,0.09027912495796798},
{-0.007655216712794127,0.886386905839649,0.10139605588750077},
{0.02773466801169136,0.8870410965400103,0.098787915039273},
{-0.004269483458782764,0.8891955071001787,0.0935904938654803},
{0.026456463447229326,0.8893609408275351,0.08943686790305476},
{-0.09987077847615601,0.9010792529939733,-0.08430033927385912},
{-0.10568035832837573,0.8856416457584303,-0.052435216799013654},
{-0.09421046618901048,0.9279043049412414,-0.06317655389151859},
{-0.07860419199365426,0.9479244803117698,-0.1060131118353552},
{-0.07900080184164922,0.9174340205030049,-0.12011054421768708},
{-0.06297851840355916,0.9240125708077909,-0.13321752972418374},
{-0.06656848417440489,0.9523588586258331,-0.11455962296198581},
{-0.0757740358500815,0.9485786710121311,-0.10621949984049388},
{-0.09919934386936019,0.8982620297802265,-0.0015743147702680551},
{-0.10629305587887881,0.8684489321710942,-0.026791372442513128},
{-0.10303988515558317,0.874669671417363,-0.035293157186829106},
{-0.10092589000112087,0.8686310709328091,-0.02734748842502781},
{-0.08987039048826122,0.898265263012683,-0.0027566001051878286},
{-0.0948005311123182,0.9135509083227715,-0.03456029116336015},
{-0.0900282800065527,0.9091300018106102,-0.10313607382116345},
{-0.09499614167593529,0.9029987153289707,-0.08993909667796143},
{-0.031540721485045234,0.9288263150634146,-0.1441318447531104},
{-0.03539042359656158,0.9571429649172725,-0.12671873248665752},
{-0.006041833717010262,0.9587029995775245,-0.1304924536354466},
{0.0011235482786270301,0.9308045144547047,-0.14762535242233776},
{0.03586193666313166,0.9573224093186071,-0.12730610304958487},
{0.03378835691437537,0.9288263150634146,-0.14413238362518646},
{0.06881450298750678,0.9523588586258331,-0.11456070070613797},
{0.0652261538328893,0.9240125708077909,-0.13321752972418374},
{0.08085290516713656,0.9479234025676178,-0.10601095634705088},
{0.07802167127941163,0.9485786710121311,-0.10621896096841779},
{-0.004369174792857584,0.8463896648646785,0.10209281748187235},
{-0.01913750290990922,0.8402400567324522,0.09543235862152212},
{0.00112300940655095,0.8173299104179061,0.10337694963917127},
{0.010863122181699034,0.844395299311106,0.10049344516006657},
{0.021385138339239364,0.8402400567324522,0.09543235862152212},
{0.01815190588275867,0.8107508212410441,0.0952706969986981},
{-0.015904270453428532,0.8107508212410441,0.09527015812662201},
{-0.018906865661346934,0.8325390358931912,0.08676136804531699},
{-0.03679580197097852,0.8239467206400939,0.07876450643628809},
{-0.025411590491710004,0.8433822198080754,0.09293684203719511},
{0.0011235482786270301,0.8540351818801033,0.10133893544743626},
{0.027660842537268384,0.8433806031918472,0.09293576429304296},
{0.039042898528232575,0.8239461817680177,0.07876450643628809},
{0.021154501090677073,0.8325390358931912,0.0867608291732409},
{0.0389421294500056,0.8162042066509749,0.07085440323150807},
{0.03273809523809523,0.8009783761413312,0.07698838407352802},
{-0.05004235534517991,0.8136219316623989,0.06313613848581258},
{-0.0347637153720804,0.8296016442064786,0.07758760982212912},
{-0.024056866092444593,0.8495501495908884,0.08640786796340844},
{0.0011235482786270301,0.8595613150203049,0.09318741755257237},
{0.026303962649698656,0.8495501495908884,0.08640786796340844},
{0.03701135080141055,0.8296016442064786,0.07758760982212912},
{0.05229106851866221,0.8136224705344749,0.06313613848581258},
{0.05544508677995913,0.8058454687324867,0.05875564737935733},
{0.0490529862134968,0.8065966564065424,0.05957634955122734},
{-0.03048992093668901,0.8009783761413312,0.07698838407352802},
{-0.036694494020675456,0.8162042066509749,0.07085440323150807},
{-0.034228615400532854,0.7935985230594139,0.07696305708595226},
{-0.054628156712621695,0.8315351172154541,0.0658509760051042},
{-0.058914345205762934,0.8294933309191864,0.06526306657010081},
{-0.06836562254813207,0.8489293689592441,0.054639742462257404},
{-0.08859272479587528,0.8399388272419234,0.03610954838209048},
{-0.08882928963727445,0.8618763094591451,0.028347634998232504},
{-0.08049078313201075,0.8593296000275903,0.03690438469430866},
{-0.0840042290680531,0.8639348007897709,0.03124676676754352},
{-0.08600344447031032,0.8827996344291839,0.02870760154505402},
{-0.10186244966934813,0.8899483113904625,0.003724953225903798},
{-0.08437712854470054,0.8174123578455464,0.015489608390884872},
{-0.07686201857168724,0.8145854349344301,0.04323020399541313},
{-0.0941177801919247,0.834218700154333,0.01762893053292293},
{-0.09449121854064821,0.8357340084322703,-0.002308258537889173},
{-0.1018980152263694,0.8621748445892933,0.008665332419406296},
{-0.10580860988248281,0.8776517894863902,-0.01853585223696576},
{-0.09188846641318127,0.8323719855496065,-0.0012854793374891143},
{-0.004513053637170974,0.6942601501944251,0.02617220842709708},
{-0.005044381504185969,0.7034123535345699,0.031864853038807414},
{-0.012327237612408726,0.7010343110628283,0.024284539544588438},
{-0.012948557116129099,0.6834008001172586,0.024468294922531754},
{-0.02748409249631413,0.712823215471233,0.016121166464050766},
{-0.02047660001896831,0.7268247286240227,0.016160504125604616},
{-0.016445836889889046,0.7238248277764846,0.02645673288326738},
{0.0011235482786270301,0.7028950363415329,0.03228625100230206},
{0.00112462602277919,0.6765673633204868,0.02391056232378884},
{-0.021440642163075636,0.6691670330996785,0.029953473784951244},
{-0.023909754015674724,0.6790871291482373,0.02866772501142409},
{-0.04753282808687482,0.6932508427959271,0.01715202874559203},
{-0.0625059275928369,0.7386265659622532,-0.010718973901347613},
{-0.042013700283662275,0.7362512178508921,-0.000434600329358612},
{-0.05638541855271895,0.6796276178405457,0.01299355293448178},
{-0.08222056249622792,0.7521975203262546,-0.0385452501659726},
{-0.06586579498719641,0.6564809066846005,0.0008473763396359817},
{-0.07677687678366658,0.703972780493693,-0.03184491477199245},
{-0.08136752799979309,0.7224819585628929,-0.053871849753843244},
{-0.08803014234844764,0.7564449100299184,-0.05272512997594476},
{-0.08731398135933716,0.7683200339704956,-0.06749669132545287},
{-0.070174616107533,0.668127009992844,-0.018063800298319582},
{-0.0611862298785167,0.6410648543321004,0.015579600027590252},
{-0.04749456816947313,0.6505705577541536,0.027878816292042804},
{-0.03564692670477571,0.6579315503134082,0.03335752868954933},
{-0.00013364027486787884,0.6643117956941966,0.024695160066561486},
{0.015688182750920383,0.6837974099652537,0.02433627126389213},
{0.021762348792495445,0.6690107601976152,0.0296565552710311},
{0.026300190545166094,0.6800835036169095,0.028313147185363378},
{0.03568680323840562,0.6579315503134082,0.03335752868954933},
{0.04943666313166584,0.6913152142986472,0.01807565548399335},
{0.058377628617987114,0.678566578722744,0.013625111007647675},
{0.047534444703103036,0.6505813351956753,0.02787773854789064},
{0.061226106412146604,0.6410648543321004,0.015578522283438093},
{0.06481822767129665,0.6578453307812353,-0.0014277415655742649},
{0.07211455558142141,0.6864120172783943,-0.007841397015079797},
{0.07021341489701076,0.668127009992844,-0.018063800298319582},
{0.07676124949346025,0.7039199710302373,-0.031827670865557885},
{0.08386681668865265,0.7226565531155429,-0.05387993283498444},
{0.0011235482786270301,0.7192551925713252,0.03221511988825949},
{0.014574873041738866,0.7010343110628283,0.024284539544588438},
{0.007292555805592189,0.7034123535345699,0.031864853038807414},
{0.006760689066501116,0.6942601501944251,0.02617220842709708},
{0.029731189053568186,0.7128248320874613,0.01612062759197469},
{-0.06722429149099439,0.9240502918531165,0.05299187165360441},
{-0.06716555443470165,0.907735400877715,0.05597668408301218},
{-0.041076062871282876,0.9232242009604857,0.07817120828052389},
{-0.0033453178483053656,0.9323909538466847,0.08413059456989387},
{0.02773682349999568,0.9252309605718081,0.08329157074743714},
{0.04899263254097583,0.9225872541665591,0.07457531491684127},
{0.06947138804824844,0.9240508307251926,0.05299294939775657},
{0.06941426760818395,0.9077359397497909,0.05597668408301218},
{-0.01818747143977998,0.951738077994189,0.07103276988869059},
{0.02398735159463024,0.9513635619013133,0.06988173913418347},
{0.06172132985006423,0.9458816162713503,0.053276396109774714},
{0.07979078830518266,0.9473834527473853,0.02431148314839244},
{0.07085413379547002,0.9616980505763776,0.02351556909202211},
{0.08619905503392739,0.9558297336678652,-0.004222871024201823},
{0.07623099937059741,0.9709165351818803,-0.013249517170619833},
{0.0874152893096402,0.9580283317382722,-0.036172057542915775},
{0.07517642671770863,0.973255778864144,-0.0449896213238147},
{0.08546780562668665,0.9544125001077746,-0.07364522171352698},
{0.06499928868885957,0.9733080494555237,-0.08273599363699853},
{0.037060927032409915,0.9774110214427979,-0.10245763387737859},
{0.04005705577541536,0.9645282067199503,-0.11885605002457257},
{0.01080654061371062,0.9761532940172267,-0.11185825724459621},
{-0.03311153358681877,0.9674348826983267,-0.11767376468965281},
{-0.03481221385892762,0.9774115603148738,-0.10245763387737859},
{-0.06275111438745336,0.9733075105834476,-0.08273707138115069},
{-0.08322124794150869,0.9544135778519266,-0.07363552201615753},
{-0.07292609692799808,0.9732579343524482,-0.0449896213238147},
{-0.08516765388031007,0.9580288706103482,-0.036167746566307134},
{-0.07398120845296295,0.9709181517981085,-0.013247900554391592},
{-0.083949802988369,0.9558318891561696,-0.004220176663821421},
{-0.06860649836613988,0.9616975117043016,0.023516107964098188},
{-0.07754315287585252,0.9473834527473853,0.02431148314839244},
{-0.05947423329281017,0.9458821551434262,0.05327531836562255},
{-0.03547233215212576,0.9745943371011271,0.039835309916108404},
{-0.011709151341144834,0.9558744600501798,0.05990613926178837},
{0.017617344783287196,0.9557230369968013,0.05800877068191029},
{0.03771942870937981,0.9745943371011271,0.03983584878818448},
{0.04384317098195424,0.986783084589983,-0.0019585305605131784},
{0.044944625505462,0.990071281998224,-0.04040920867713372},
{0.04208052042109619,0.9879050162523819,-0.07244084262348793},
{0.022432166783063024,0.9960748557978325,-0.06385068285869482},
{-0.005878555477957988,0.9941963477406172,-0.07821054594207773},
{-0.0014037617581887105,0.9819898174732504,0.0316078110585172},
{-0.027419427847184513,0.9690795202745232,0.041726212031073524},
{-0.04041001698524785,0.9859025676176683,0.003827877792435098},
{-0.019325030392385104,0.993084654647664,-0.0003047321590233033},
{0.0011235482786270301,0.9949092754972713,0.004527872619263168},
{0.03242554943396877,0.9730256804876578,0.03635689066501126},
{0.02157320469379132,0.993084654647664,-0.0003047321590233033},
{0.0011235482786270301,1.0,-0.04412419276963003},
{-0.02093464128363641,0.9964833208315014,-0.05327208513316607},
{-0.04269645120405578,0.9900718208703,-0.04041028642128588},
{-0.03983342386384212,0.9879050162523819,-0.07243976487933577},
{-0.08392124276833675,0.9149923911262858,0.018976649595199298},
{-0.01509650121138444,0.7990082598311824,-0.1547142145831717},
{-0.022246255916815408,0.802349266702879,-0.15975374623867292},
{-0.03131816731762415,0.8086249709009079,-0.15187220325392517},
{0.0004941456937654553,0.8011696757283395,-0.15215834432632372},
{0.031591914332272826,0.8086573032254729,-0.15171916358431842},
{-0.002049869377408769,0.8383701706284544,-0.14513845779122805},
{-0.058310269608477114,0.8346697360820121,-0.12723497193554228},
{-0.04941618599277482,0.8109291878982267,-0.142420925911556},
{-0.06383748049283086,0.8090210418768269,-0.1314381741289672},
{-0.07949548640749077,0.8270813395066519,-0.09896250959192296},
{-0.07057661467628878,0.8145924402714192,-0.11023463567936682},
{-0.07518720415923025,0.7931453316434306,-0.1135109779019339},
{-0.08084859419052795,0.7850406956191857,-0.10714043221851478},
{-0.08707364441340543,0.7515514127070347,-0.09572981600751834},
{-0.08200285817749156,0.7753517756912651,-0.10526407964960383},
{-0.08338452618056096,0.7635612546666323,-0.10853934412801877},
{-0.08758718950190977,0.7895930869179105,-0.07573011777588096},
{-0.0828499650810895,0.8219103230645872,-0.08259480915306555},
{-0.08884222256710037,0.7379432761697835,-0.07603458049886622},
{-0.10659751860186409,0.8635365743255479,-0.04076917522395524},
{-0.1010606080201409,0.8518058681013598,-0.027137328315356566},
{-0.10467859513894279,0.8339648914064994,-0.03760168516075632},
{-0.10425504168714383,0.837775794728538,-0.05062299000715623},
{-0.10139578645146274,0.8494143538277164,-0.046843341265530296},
{-0.1023237241664727,0.8719930938154732,-0.051046004586879114},
{-0.10674570842278612,0.8815898666183838,-0.0545098742919221},
{-0.10577951079037448,0.8851787546450774,-0.07475475931817595},
{-0.09460869265323368,0.8844949259805317,-0.0994329449143409},
{-0.08832975522274818,0.8790189079434056,-0.10635314011536175},
{-0.08410769250666048,0.888115607459714,-0.11381813498529958},
{-0.07398390281334336,0.8997918876042179,-0.12892756912650993},
{-0.05086144090082169,0.902744367709061,-0.1448474668701448},
{-0.021186833415241902,0.9019349818507887,-0.1545126764267177},
{0.0011235482786270301,0.9044763025615823,-0.156478481760258},
{0.02343500771664812,0.9019349818507887,-0.1545126764267177},
{0.05311230956260831,0.902744367709061,-0.1448463891259926},
{0.0762315382426735,0.8997918876042179,-0.12892703025443386},
{0.08124735952682721,0.917435098247157,-0.12011216083391532},
{0.0863558668080667,0.888115607459714,-0.11381867385737567},
{0.09227645430795892,0.9091294629385341,-0.10313499607701129},
{0.09057739065207833,0.8790189079434056,-0.10635314011536175},
{0.09724377710526542,0.9029987153289707,-0.08993855780588536},
{0.09685686695463991,0.884496003724684,-0.0994329449143409},
{0.10802768509178069,0.8851787546450774,-0.07475475931817595},
{0.10211625841718182,0.9010814084822776,-0.0843057279946199},
{0.10792853262978196,0.8856416457584303,-0.052435216799013654},
{0.10899388272419233,0.8815898666183838,-0.0545098742919221},
{0.1088456929032703,0.8635365743255479,-0.04077025296810739},
{0.10528752058491331,0.8746702102894391,-0.035293696058905186},
{0.1033093211936232,0.8518069458455119,-0.027137328315356566},
{0.10692623056827294,0.8339670468948036,-0.037599529672451996},
{0.09874453583714855,0.8306723830216499,-0.022023432313356267},
{0.09903660450238397,0.8447234724054389,-0.023690163644672066},
{0.10479229714699567,0.8317495883017341,-0.07111575618840692},
{0.09086892044523766,0.8228350275471406,-0.08464791176293078},
{0.07716755903882465,0.8282382978539958,-0.10367332928101533},
{0.07822644266832209,0.8307645301466595,-0.11223977867446092},
{0.06055844390988334,0.8346697360820121,-0.12723497193554228},
{0.06212440616297216,0.8416836950242709,-0.12840378546856007},
{0.041091690161489176,0.8374535492270421,-0.13833735331902092},
{0.03054003603976444,0.8461132234896495,-0.14406448574360037},
{0.0011235482786270301,0.845678892596329,-0.14892565074191907},
{-0.02829293948251038,0.8461132234896495,-0.1440639468715243},
{-0.03441129303432401,0.8386886440254175,-0.14138251942094962},
{-0.05987677073364202,0.8416836950242709,-0.12840378546856007},
{-0.07598096272729625,0.8307639912745833,-0.11223708431408053},
{-0.08862128501590752,0.8228350275471406,-0.08464791176293078},
{-0.08814761646103311,0.8132883698473053,-0.06759261055499513},
{-0.09453163394635423,0.8081895622634353,-0.056856123311174914},
{-0.10254412284558946,0.8317490494296579,-0.071116295060483},
{-0.09172087719752035,0.8137685048670926,-0.029193125285602202},
{-0.09649743927989449,0.8306723830216499,-0.022023432313356267},
{-0.082456588465551,0.8141721200520766,-0.01529507557141995},
{-0.09678896907305383,0.8447234724054389,-0.023690163644672066},
{-0.10147284515834219,0.8808990326168492,-0.07167672201960631},
{-0.10790967210711916,0.8616871653604408,-0.06353220946173146},
{-0.10543894363829183,0.8572592535112906,-0.07900376563806766},
{-0.09917778898631698,0.8663349370166318,-0.08928867808213273},
{-0.1030905391307347,0.8727485924661373,-0.09315831846046403},
{-0.09771097919522691,0.8446620409887656,-0.08680124457894692},
{-0.10152242138934156,0.8443133907555418,-0.09313676357742084},
{-0.09465826888423305,0.869921669555021,-0.10293992438547028},
{-0.09161471939853257,0.8298683858841382,-0.08867220842709708},
{-0.08417020166748578,0.8472879646155042,-0.10910947078451154},
{-0.08285912590638285,0.8596178965882932,-0.11190945009182382},
{-0.08676756507419192,0.8704195873533193,-0.10385223481027392},
{-0.08147638015916128,0.8343124638955711,-0.10384253511290449},
{-0.07942327754929604,0.837003052171439,-0.10659778803790212},
{-0.06954467465059537,0.8684963529137892,-0.12881117275807663},
{-0.07221478578757233,0.898622535199124,-0.12521204616193754},
{-0.04646963348076875,0.8717823948337258,-0.142770653888932},
{-0.020631256304803305,0.8747192476483623,-0.15383962520369365},
{0.0011235482786270301,0.8757576541389688,-0.1570798629971634},
{0.02287781398998128,0.8747181699042103,-0.15383962520369365},
{0.04871619116594673,0.8717818559616497,-0.1427711927610081},
{0.07446296008897856,0.898622535199124,-0.12521150728986147},
{0.07179284895200158,0.8684785701352784,-0.12880955614184839},
{-0.10003405671520829,0.8365773432313358,-0.0655475910262711},
{-0.0844838252157644,0.8072745574782512,0.008507981773190901},
{-0.0930012372502867,0.8216516644680688,-0.010392417423243061},
{-0.07998424338049542,0.8044681117060258,0.002206950587586113},
{-0.09381116198063512,0.7841698783442403,-0.015616243328763699},
{-0.09406712621677317,0.7794574420389195,-0.04096424691549624},
{-0.08856901442452775,0.7765410663631741,-0.05449478587379185},
{-0.08727841580231588,0.7683518274229846,-0.041508507712337155},
{-0.07781312778596866,0.7540657898140245,-0.02054584508074459},
{-0.0917898528232586,0.7768794780269523,-0.062194190096824545},
{-0.08650998422182563,0.796119905503393,-0.06134600544907444},
{0.10144697929869033,0.8982620297802265,-0.0015748536423441358},
{0.10854123018028505,0.868448393299018,-0.026791372442513128},
{0.10317352543045102,0.8686310709328091,-0.02734748842502781},
{0.09645756274626455,0.9279053826853938,-0.06317870937982291},
{0.09704762766957226,0.9135492917065433,-0.034557057930903676},
{0.09211802591759137,0.898265263012683,-0.0027566001051878286},
{0.09690644318563928,0.8699222084270971,-0.10293938551339421},
{0.10533817456006483,0.8727491313382135,-0.09315885733254012},
{0.10372155833182449,0.8808990326168492,-0.07167564427545417},
{0.10457189846787891,0.8719930938154732,-0.051046004586879114},
{0.10364342188079287,0.8494148926997922,-0.046843341265530296},
{0.10650213824439789,0.8377747169843857,-0.050624067751308385},
{0.1022822310166145,0.8365773432313358,-0.06554812989834717},
{0.09995861462455706,0.8446620409887656,-0.08680340006725124},
{0.10377059569074779,0.8443133907555418,-0.09313676357742084},
{0.09386289369993878,0.8298689247562143,-0.08867274729917315},
{0.08372347671641533,0.8343119250234949,-0.10384253511290449},
{0.08167091297862616,0.8370025132993628,-0.10659778803790212},
{0.08510837795194122,0.8596195132045215,-0.11190891121974773},
{0.08901573937559815,0.8704195873533193,-0.10385223481027392},
{0.08641837596889199,0.847287425743428,-0.10910947078451154},
{0.10142488554357103,0.8663349370166318,-0.08928867808213273},
{0.1076860401955459,0.8572581757671384,-0.0790026878939155},
{0.1101578464085254,0.8616860876162887,-0.06353274833380755},
{0.09673885396997836,0.8357340084322703,-0.002308797409965252},
{0.09636649336540701,0.8342203167705612,0.017624619556314287},
{0.10414618952777563,0.8621748445892933,0.008665332419406296},
{0.10805678418388902,0.8776517894863902,-0.01853585223696576},
{0.10411062397075434,0.8899483113904625,0.003724953225903798},
{0.09413664071458748,0.8323741410379109,-0.0012865570816412736},
{0.08662530284610676,0.8174134355896986,0.015489069518808796},
{0.07911127061724563,0.8145859738065063,0.043228587379184884},
{0.09083712699274893,0.8399361328815431,0.036113320486623045},
{0.09107746393868066,0.8618763094591451,0.028348173870308583},
{0.06274842002707293,0.7932385565125926,0.0413991166808929},
{0.06116144176301699,0.8294938697912626,0.06526306657010081},
{0.07061433572161438,0.8489293689592441,0.054639203590181325},
{0.0827378796892648,0.8593296000275903,0.03690438469430866},
{0.08625240336945932,0.8639342619176951,0.03124676676754352},
{0.08825054102756438,0.8827996344291839,0.0287081404171301},
{0.05687686988610399,0.8315361949596062,0.0658509760051042},
{0.03647678970193907,0.7936001396756421,0.07696305708595226},
{0.043040790460670955,0.7911779096936621,0.06505506194873388},
{0.08617157255804729,0.914993468870438,0.018969644258210256},
{0.0820416569669693,0.7753517756912651,-0.105265157393756},
{0.08088847072415785,0.7850406956191857,-0.10714150996266694},
{0.08793530086305751,0.7514549546054163,-0.09564521309157377},
{0.08342440271419087,0.7635612546666323,-0.10854042187217093},
{0.08469506306958778,0.8102060215721271,-0.10034417759499238},
{0.07522600294870799,0.7931453316434306,-0.1135109779019339},
{0.06470183130286335,0.8092392850676394,-0.13136380978246814},
{0.049692627367803895,0.8111291094384523,-0.1425788154298475},
{0.022285054706293154,0.802349266702879,-0.15975374623867292},
{0.015135300000862186,0.7990082598311824,-0.1547142145831717},
{0.014339924816567937,0.7950421613512326,-0.16040901468318633},
{0.08888102135657812,0.7379432761697835,-0.07603565824301838},
{0.08673199951717062,0.8072745574782512,0.008507981773190901},
{0.09524833380754075,0.8216516644680688,-0.010392417423243061},
{0.0480339791176293,0.78466617952631,0.05688198917082676},
{0.019045355784899503,0.795602588310356,-0.1649387733547158},
{0.04441383651052309,0.8231960718381144,0.07257071079382324},
{0.05256427666123483,0.8146571049205488,0.06313236638128002},
{0.057263780036729515,0.8317441995809732,0.0661004737763293},
{0.06089308346912909,0.8784487812869128,0.07196879068484174},
{0.07061110248915789,0.8489401464007658,0.05370426053818233},
{0.07583385065052638,0.8805455325349405,0.052951456247898404},
{0.08561653431968479,0.8864063052343879,0.03529261831475303},
{0.08552600381090332,0.8630968547114665,0.031082949656415164},
{0.08797894950122001,0.8829753067259858,0.028202678409766955},
{0.03204187251579972,0.8402535285343542,0.08221167110697257},
{0.036224597570333576,0.8295838614279681,0.07769807859772554},
{0.026599264547390557,0.8488970366346794,0.08606460645094541},
{0.03917384444272005,0.8766090720191753,0.08707175836113913},
{0.0011235482786270301,0.875570665528569,0.09679031625324402},
{0.020400080184164913,0.8526368088426752,0.08848521981669728},
{0.009577373408171877,0.8570016726589242,0.09149428148952865},
{0.0011235482786270301,0.8588446151591184,0.09272075433468699},
{-0.007330276850917818,0.8570016726589242,0.09149428148952865},
{-0.018152983626910854,0.8526368088426752,0.08848521981669728},
{-0.024352167990136498,0.8488970366346794,0.08606460645094541},
{-0.036924592397161664,0.8766090720191753,0.08707283610529129},
{-0.04195172999491306,0.8233809049602099,0.07271674512644094},
{-0.05864490916772287,0.8784487812869128,0.07196879068484174},
{-0.05504686031573594,0.8317792262659183,0.06613819482165491},
{-0.06836292818775168,0.8489401464007658,0.05370426053818233},
{-0.07358567634912014,0.8805455325349405,0.052951456247898404},
{-0.08336836001827856,0.8864063052343879,0.03529261831475303},
{-0.08327836838157318,0.8630963158393903,0.031082949656415164},
{-0.08573185294396594,0.8829753067259858,0.028202678409766955},
{-0.03397642326892736,0.8295838614279681,0.07769807859772554},
{-0.029793698214393503,0.8402535285343542,0.08221167110697257},
{-0.05031610235982861,0.8146571049205488,0.06313236638128002},
{0.07093765896726244,0.8290126570273231,0.05664434658527544},
{0.06479020632334048,0.8263398515299656,0.06175177612236276},
{0.07048285093505081,0.8274499280066907,0.05655704930895046},
{0.07539305329229283,0.8283121233284189,0.0511791059896709},
{0.07612160833915314,0.8283875654190701,0.05019943655535726},
{0.07707110093720632,0.8312759197468595,0.05017464843985757},
{0.07017353836338083,0.8195716182543995,0.05370857151479096},
{0.0741989127716993,0.8221582042195841,0.050070107257098026},
{0.07514840536975245,0.8248417871584629,0.050210213996878854},
{-0.06790919789969221,0.8195716182543995,0.05370857151479096},
{-0.06788656527249684,0.8209295758861213,0.054196789615719554},
{-0.07288406490606383,0.8248417871584629,0.050210213996878854},
{-0.07312871282860421,0.8283121233284189,0.0511791059896709},
{-0.07303494908736627,0.8306723830216499,0.05210381047222439},
{-0.0748067604735177,0.8312759197468595,0.05017464843985757},
{-0.06867331850357382,0.8290126570273231,0.05664434658527544},
{-0.0682185104713622,0.8274499280066907,0.05655704930895046},
{-0.06252586585965186,0.8263398515299656,0.06175177612236276},
{0.07093765896726244,0.8290126570273231,0.05664434658527544},
{0.07048285093505081,0.8274499280066907,0.05655704930895046},
{0.07539305329229283,0.8283121233284189,0.0511791059896709},
{0.07539305329229283,0.8283121233284189,0.0511791059896709},
{0.07529928955105489,0.8306723830216499,0.052102732728072226},
{0.07093765896726244,0.8290126570273231,0.05664434658527544},
{0.07707110093720632,0.8312759197468595,0.05017464843985757},
{0.07529928955105489,0.8306723830216499,0.052102732728072226},
{0.07539305329229283,0.8283121233284189,0.0511791059896709},
{0.07707110093720632,0.8312759197468595,0.05017464843985757},
{0.07612160833915314,0.8283875654190701,0.05019943655535726},
{0.07918024624298388,0.8313513618375107,0.04774002440012761},
{0.07756470775889569,0.825412991559108,0.04742208987524034},
{0.07918024624298388,0.8313513618375107,0.04774002440012761},
{0.07612160833915314,0.8283875654190701,0.05019943655535726},
{0.07612160833915314,0.8283875654190701,0.05019943655535726},
{0.07514840536975245,0.8248417871584629,0.050210213996878854},
{0.07756470775889569,0.825412991559108,0.04742208987524034},
{0.07677148806290576,0.8243029150823828,0.04795772871886398},
{0.07756470775889569,0.825412991559108,0.04742208987524034},
{0.07514840536975245,0.8248417871584629,0.050210213996878854},
{0.0741989127716993,0.8221582042195841,0.050070107257098026},
{0.07677148806290576,0.8243029150823828,0.04795772871886398},
{0.07514840536975245,0.8248417871584629,0.050210213996878854},
{0.07514840536975245,0.8248417871584629,0.050210213996878854},
{0.07015090573618547,0.8209295758861213,0.054196789615719554},
{0.07017353836338083,0.8195716182543995,0.05370857151479096},
{0.07017353836338083,0.8195716182543995,0.05370857151479096},
{0.07015090573618547,0.8209295758861213,0.054196789615719554},
{0.06181994343998689,0.8162521662657458,0.05916411241302606},
{-0.06790919789969221,0.8195716182543995,0.05370857151479096},
{-0.05955560297629827,0.8162521662657458,0.05916411241302606},
{-0.06788656527249684,0.8209295758861213,0.054196789615719554},
{-0.07288406490606383,0.8248417871584629,0.050210213996878854},
{-0.07193457230801067,0.8221582042195841,0.050070107257098026},
{-0.06790919789969221,0.8195716182543995,0.05370857151479096},
{-0.07193457230801067,0.8221582042195841,0.050070107257098026},
{-0.07288406490606383,0.8248417871584629,0.050210213996878854},
{-0.07450714759921714,0.8243029150823828,0.04795772871886398},
{-0.07450714759921714,0.8243029150823828,0.04795772871886398},
{-0.07288406490606383,0.8248417871584629,0.050210213996878854},
{-0.07530036729520707,0.825412991559108,0.04742208987524034},
{-0.07530036729520707,0.825412991559108,0.04742208987524034},
{-0.07288406490606383,0.8248417871584629,0.050210213996878854},
{-0.07385726787546452,0.8283875654190701,0.05019943655535726},
{-0.07385726787546452,0.8283875654190701,0.05019943655535726},
{-0.07691590577929526,0.8313513618375107,0.04774002440012761},
{-0.07530036729520707,0.825412991559108,0.04742208987524034},
{-0.0748067604735177,0.8312759197468595,0.05017464843985757},
{-0.07691590577929526,0.8313513618375107,0.04774002440012761},
{-0.07385726787546452,0.8283875654190701,0.05019943655535726},
{-0.0748067604735177,0.8312759197468595,0.05017464843985757},
{-0.07385726787546452,0.8283875654190701,0.05019943655535726},
{-0.07312871282860421,0.8283121233284189,0.0511791059896709},
{-0.06867331850357382,0.8290126570273231,0.05664434658527544},
{-0.07303494908736627,0.8306723830216499,0.05210381047222439},
{-0.07312871282860421,0.8283121233284189,0.0511791059896709},
{-0.07312871282860421,0.8283121233284189,0.0511791059896709},
{-0.0682185104713622,0.8274499280066907,0.05655704930895046},
{-0.06867331850357382,0.8290126570273231,0.05664434658527544},
{0.1745304268729038,0.5704510574825621,-0.20547650302199463},
{0.19788622039436815,0.556526603036652,-0.1911823823318935},
{0.18068650147004303,0.5527221661795264,-0.1936752045558401},
{0.19143807713199348,0.5468053507841668,-0.19292078364932794},
{0.18958112395782142,0.5419662795409672,-0.1889676180992042},
{0.19453982480191062,0.5531424863988688,-0.18535178646870665},
{0.194300026728055,0.5262953406964815,-0.20751828931826216},
{0.17747159066414908,0.5512871498409251,-0.2026528133433348},
{0.17257486010880907,0.5342102937499461,-0.22204843597768642},
{0.19419063569661071,0.5044548554529543,-0.22066299587008442},
{0.16637405912935518,0.5161268246208497,-0.23489568514351242},
{0.15686781683522585,0.4892338747919954,-0.23812622323961272},
{0.18892801100161233,0.4808474086719605,-0.23026354077752775},
{0.18592649353784607,0.47694489709698845,-0.22208238491847945},
{0.17123145202314133,0.4486131588250002,-0.22023297595337252},
{0.15010874438495297,0.45779446125725337,-0.22936146892216966},
{0.11403179776346534,0.4293991360802877,-0.21747610641214662},
{0.12906040109326367,0.4823352344740177,-0.2343600462998888},
{0.10858811205090402,0.4132642283782968,-0.22213950535854396},
{0.10495018666528716,0.4005834906839796,-0.20508797625514086},
{0.08702083494994957,0.35800613020873745,-0.18312408930619142},
{0.07881165774294509,0.34654054904598086,-0.16326557555848703},
{0.06946061060672684,0.3355119931369253,-0.16339544372882234},
{0.05352831880534215,0.35368653164687924,-0.17123279920333154},
{0.08159493201589887,0.4295295431226991,-0.2255171555314141},
{0.04955790934878387,0.4159968486760991,-0.19805623453437143},
{0.03790048972694273,0.3813716234275714,-0.1795395122561065},
{0.13612285852236966,0.5270718553581129,-0.2334795293275739},
{0.13211149478802928,0.49470719846874117,-0.24450161877171656},
{0.08712429838855694,0.4726640973246079,-0.2418261189139788},
{0.04498557978324409,0.4713093729253427,-0.22015753386272127},
{0.03644122414491778,0.45309495788175846,-0.21483617211143016},
{0.03450236241518153,0.4380394109481562,-0.20764707974444532},
{0.1724191260788219,0.5676381452454239,-0.20997824034556792},
{0.13651138528922344,0.5540898235086177,-0.22416997534121383},
{0.14166569669692972,0.5819829199106767,-0.2056316981799057},
{0.14750168128087737,0.5846233930834691,-0.22002173809954909},
{0.10923206418181974,0.5663831121802335,-0.2291917242182044},
{0.13806118138002985,0.5277120353844961,-0.23996539363527417},
{0.10685563832630644,0.5111352525801195,-0.24833138261641796},
{0.061497697938490976,0.5061959511307693,-0.23802868739384223},
{0.033389052706000004,0.4992827612667373,-0.22553008846124004},
{0.047054848555391736,0.5266192028142055,-0.2275939685126269},
{0.07276174094479362,0.5593702309821268,-0.24178354801996846},
{0.034435003405671516,0.5571958821551436,-0.22634701852857747},
{0.052202154626109,0.588341610408422,-0.22099278558064545},
{0.08452477949354648,0.58469614081374,-0.23409114913392481},
{0.06889748928722311,0.6105646948259659,-0.21918001991671196},
{0.0402456610020434,0.6164831268375538,-0.2188049649517602},
{0.09117068880784253,0.628496202029608,-0.21041526559926887},
{0.09359022442944225,0.6076553244872095,-0.21855977815714372},
{0.09911312433718734,0.6240817619823595,-0.21783553408689205},
{0.12843530948501072,0.6340913107955478,-0.2132249446039506},
{0.1506228283455334,0.6606555486579931,-0.1876646254192425},
{0.1645332721174655,0.6524997197865204,-0.19443878628764563},
{0.14850128898200599,0.6644330419113146,-0.17733013674417805},
{0.18734103273755637,0.6585733469560195,-0.17315872800324186},
{0.17994285800505247,0.6501825698593761,-0.17959824931239926},
{0.15793208918548407,0.6456344895372598,-0.1964417737944354},
{0.14195776536216514,0.6395344576360329,-0.20494463628290355},
{0.13168255261546952,0.6308155074450567,-0.20971688738866906},
{0.12787164929343092,0.6036455773690973,-0.21888579576317221},
{0.13239494150004744,0.6185831113180381,-0.21232125613236424},
{0.133696856435857,0.6043137787434365,-0.21222533690282197},
{0.10206506556995422,0.5500601381236907,-0.23773661872860682},
{0.10745971392359226,0.5767159842390696,-0.23083582292232485},
{0.14010296767629737,0.1795451704129053,0.09649393661139995},
{0.17580970918151798,0.20332451738616872,0.05908220385746188},
{0.16364036108740077,0.299296556391885,0.06461264797427209},
{0.12744486260917548,0.24906936792460976,0.10211383349283948},
{0.15805764637921074,0.31351900709586755,0.09716591009027187},
{0.17077556624677756,0.3152315425536502,0.056960664493934464},
{0.18533481199831012,0.3272473121060845,0.007145174292784288},
{0.1912424665683764,0.29564677582059445,0.0259954583861428},
{0.19482650474638527,0.2415639576489657,0.008609828595570041},
{0.1854727632497866,0.18855241716458446,0.02834547950992818},
{0.17388485812575982,0.16072506315580734,0.050442467861669386},
{0.15764972021761808,0.15242643318417354,0.07013931998654976},
{0.12632400869092886,0.13997848822672293,0.0947528409335851},
{0.11287376167196916,0.12999857737771914,0.10238542501918386},
{0.058839980859263855,0.15666035108593498,0.13393961830613108},
{0.056395118250088375,0.1925772527008268,0.13148505599958615},
{0.10333249269289464,0.258030271677746,0.12777222739539418},
{0.12774393661139996,0.3226442668322082,0.1264870174939431},
{0.1328756153919109,0.34465288016347234,0.1213483333764431},
{0.16784302440874957,0.3453857461869413,0.08669885888449169},
{0.18520386608382264,0.3238524180267798,0.045319411034375735},
{0.19948990369278258,0.34295920522835244,-0.010966316184268386},
{0.1902967460748558,0.3354920548701104,-0.0302935020649578},
{0.19892139365251804,0.3088087262788512,-0.03290649276187028},
{0.19654712328530907,0.2476235741444867,-0.030974097497046986},
{0.1816165946733573,0.17551386841175004,-0.0021875511928472263},
{0.17904294163799866,0.165477914866834,0.034989772207996005},
{0.12362102635731098,0.1343526637524465,0.0956473685798781},
{0.16242089357923145,0.36903145288533656,0.11071962054783892},
{0.13523318072476137,0.37720183130286333,0.1318638830690705},
{0.08346050714328825,0.3705090401179483,0.14985682168938552},
{0.11003067259857048,0.4361247984618437,0.1434270000775976},
{0.1363502625384755,0.4282723545692041,0.1354005005043843},
{0.1692672633058293,0.3988434727503168,0.11776698955881466},
{0.18716697705698251,0.3778597941077573,0.09265932291801386},
{0.1857163334281748,0.33641891484096803,-0.06478778139899814},
{0.18848721364337878,0.311954661459007,-0.08860484941758708},
{0.19002623229266358,0.24612766526128838,-0.06371596483967479},
{0.17567121905796537,0.17078149383961444,-0.03156416242035471},
{0.20378794737159758,0.4008787925816716,0.058141333212626},
{0.20294299595630394,0.35821090159764807,0.025034649474491952},
{0.20437262357414449,0.3711583809696249,-0.004997230197528947},
{0.1969119396808153,0.38687889604511017,-0.0397162191872947},
{0.19348471327694575,0.35954730434632665,-0.0672924588086185},
{0.18459655725408036,0.3484486950673807,-0.06846827767862533},
{0.20990737866756334,0.3610205806023298,-0.08094370511195607},
{0.21661741375891294,0.35456866523542246,-0.08173261383133737},
{0.19729884983144083,0.31394794926842723,-0.09402913573540951},
{0.18017565074191907,0.2829520274522991,-0.09992008527111733},
{0.17339125130407043,0.2874354431252856,-0.09332752429235319},
{0.17119049774535924,0.23509479837562403,-0.08492704749834029},
{0.16386614848727832,0.18016756766077796,-0.06220658415457438},
{0.0002516532595294035,0.41471379426295246,0.15412468853194003},
{0.06852674529888,0.41432903960063105,0.1492942392419579},
{0.03918084977970909,0.4341487545588579,0.16152232439236786},
{0.016671085417690513,0.46768815257408425,0.1721531927092764},
{0.05102418026779786,0.444958528405025,0.15072117249941802},
{0.06741343558969849,0.4419817990567585,0.15675761749566747},
{0.07113596389125992,0.42946056749696077,0.15763166800306944},
{0.05205127044480656,0.3939785356474656,0.1540061366752024},
{1.993826681495394e-05,0.3859714354689912,0.15877461567643536},
{0.03289436814015846,0.3647204762766957,0.14618063638636697},
{1.993826681495394e-05,0.3682770319788245,0.14172955303794524},
{2.047713889103413e-05,0.31256197028874927,0.14816314675426573},
{0.03489573903072001,0.3122542743333076,0.1522203146150729},
{0.05675670141313812,0.2820467223644846,0.14209436943345147},
{-0.020836027693713746,0.27765114283989895,0.14175865213005356},
{0.026080330738125407,0.23525915435882847,0.15118136925239045},
{-0.02642035901813198,0.2529217643965063,0.14805483346697362},
{-0.027721196209789377,0.22590702947845817,0.14959924083701925},
{0.025684259762206525,0.1857287274859248,0.13920870946604244},
{-0.022693519739961903,0.18475498564444787,0.1393348055318452},
{0.024720756490175275,0.15337484803807452,0.13868169257563612},
{-0.018073769431727078,0.14477768293629248,0.13727308096876267},
{0.016212505280946338,0.0817172559771691,0.12489303389289812},
{1.993826681495394e-05,0.08095044101290712,0.12462467559901022},
{0.2007309260839951,0.43068003500513014,0.003939424312183685},
{0.21461496512419925,0.43409863945578236,-0.054411260701999434},
{0.21346285662553993,0.3951344162506575,-0.05729422630902805},
{0.2043187363665365,0.45229850495331225,0.021684481777501877},
{0.2043914840968073,0.45834195528655075,-0.01633725416655889},
{0.21551973133993776,0.4702283955407259,-0.07238426105549951},
{0.2220093677521706,0.4083642645905003,-0.07476607563177362},
{0.22924803635015475,0.4121185863445507,-0.07415122259296623},
{0.2325664105946561,0.3836187199848254,-0.11693012122466225},
{0.21811170602588312,0.3526729132717725,-0.12425177612236277},
{0.19791154738194391,0.3256770388763872,-0.1262752407680436},
{0.17275861548675236,0.3023190898666185,-0.12294285584956417},
{0.14523033548019967,0.3013415759206092,-0.13272931162325513},
{0.1598235301725253,0.2681966322650735,-0.10091484312356122},
{0.1535365096608986,0.26364693532672895,-0.09748815559176777},
{0.14336961020149505,0.25130029831958145,-0.09676822249812474},
{0.1391594026710811,0.22064602139968803,-0.10094555883189779},
{0.14223797884172681,0.18908051179914306,-0.09043270349965082},
{0.19317378408904753,0.48060491623772456,-0.013426267211574111},
{0.19801554969262739,0.47146510695532984,0.03374982756093566},
{0.20133122957674834,0.5031540182612969,-0.013310948587292966},
{0.20159258253364717,0.4796295577800196,-0.03577167559038825},
{0.201362484157161,0.4984065552710311,-0.05279195011337869},
{0.19436576912133674,0.5490152651681712,-0.07355415233266945},
{0.22119782640559393,0.468688299147289,-0.07181628988731108},
{0.2400006897562574,0.4836053559573387,-0.1073866967572834},
{0.24677592836881268,0.45333583369976643,-0.1255412970004225},
{0.24054980040178303,0.41441633687695606,-0.10936327953234527},
{0.23560834346412837,0.40080335049102034,-0.15383100325047638},
{0.21956073303846255,0.3779982842313098,-0.16597825758947435},
{0.19288764301664899,0.354277135442263,-0.17512183897640174},
{0.16575220075355873,0.3317986256606572,-0.16957091772070046},
{0.13003144857436005,0.3286052697378064,-0.1673663920574567},
{0.09846540010173904,0.32195504944690184,-0.15214595026857386},
{0.11719928782666426,0.30484909426381457,-0.13705483777795022},
{0.13204952449928006,0.28831434348137236,-0.11842603010786065},
{0.2011345412689791,0.4454219583904538,0.061992651940370576},
{0.1895078373554745,0.43604827862704015,0.09688946871524276},
{0.1806358474948915,0.4560377382892322,0.09088373942732988},
{0.19427469974047923,0.4625688678513231,0.06110027978238191},
{0.21009813938249572,0.4984679866877042,0.047625244647922546},
{0.2071149435693162,0.5344544028004105,0.008939618306131072},
{0.2033255951303208,0.5345513997741048,-0.013530269522257573},
{0.18131374856660026,0.5484004121293639,-0.05640077640688722},
{0.1648199520619401,0.4345151875705923,0.11957221101368307},
{0.15166500694067236,0.45011876740556817,0.12027651681711977},
{0.1476584930550167,0.4486158531853808,0.13433730589827822},
{0.18265338454773547,0.4672678323547417,0.10659724916582604},
{0.2047983325142478,0.4905740496452066,0.07551887992205755},
{0.21730717001629551,0.5357261408999595,0.0511333018632041},
{0.21598262245329058,0.5350471620840986,0.029747624651888644},
{0.2263936309631584,0.504855776277558,-0.09338195037203728},
{0.21076526301268292,0.5507709103920404,-0.09290397084055423},
{0.23683427743721064,0.505911965546675,-0.12407287059310416},
{0.24684382625039877,0.47653319883086315,-0.1572614628868024},
{0.24744520748730417,0.43514836225998643,-0.15290252666339033},
{0.2325798823965581,0.4199548640749075,-0.17942527137597752},
{0.2128819525275256,0.4104852650819518,-0.2026641296569325},
{0.18441711285274567,0.3946138658251641,-0.2099135756964383},
{0.14703986791167672,0.3758724338911738,-0.21075313839097112},
{0.11166345498909323,0.3687447729408621,-0.19741928774044473},
{0.13676519403705717,0.4002181354163974,-0.21712045084193377},
{0.13485758688773353,0.41314352103325497,-0.22668111921574716},
{0.1836761637481355,0.45337409361716796,-0.22313587982721608},
{0.21164416336876957,0.49468779907400223,-0.21145852193856},
{0.22022354569204108,0.5147963494650079,-0.20145436184613266},
{0.2207430183733823,0.5305960787356769,-0.1846318533750636},
{0.22597438848796808,0.5454581705939665,-0.16956067915125494},
{0.2019062060819258,0.5442942069096335,0.06805496279627188},
{0.20399487424881232,0.5193029366372659,0.07972315985963462},
{0.17522988282765578,0.4932522438633249,0.12669178888285354},
{0.19043846943086487,0.5408917686212635,0.09332590767612496},
{0.18598038074545406,0.5560847279342663,0.08638307984790876},
{0.1643301173447833,0.5691825526154695,0.09977620642680395},
{0.13033698904149746,0.5444154531267514,0.14239775441228458},
{0.12309993705974151,0.5869028219652881,0.11604583214781478},
{0.07298968383297552,0.571526646146418,0.14794382581930113},
{0.08560306251778277,0.5964710345481665,0.1231266112275075},
{0.03590666304544631,0.599722588655234,0.13017613572678755},
{0.05286927825629617,0.6001321314330549,0.12233339153151755},
{0.01857007061379684,0.6003800125880517,0.11489156816085117},
{0.01837823215471232,0.5946356362570376,0.12448025788262075},
{0.010548420889268245,0.5916384297698801,0.13084272048489864},
{0.014456321185001241,0.6056717363751585,0.11945365915694543},
{1.993826681495394e-05,0.602217566367485,0.12050769293775812},
{0.029162679013303664,0.6293971961408137,0.10024286964468933},
{1.993826681495394e-05,0.6169772725313194,0.10317756697102164},
{1.993826681495394e-05,0.6434175698162662,0.08762140787874087},
{0.030405318020744414,0.6517399101592475,0.06703487795625221},
{1.993826681495394e-05,0.6673095410534303,0.049887968495382955},
{0.010693916349809877,0.6648075580041902,0.041964393488700936},
{0.034355789210487736,0.6610785632377159,0.043259841959597534},
{0.021762348792495445,0.6690107601976152,0.0296565552710311},
{0.03568680323840562,0.6579315503134082,0.03335752868954933},
{0.1314308993559401,0.4694039212643234,0.15979955036513974},
{0.10326782804376503,0.4574819154531268,0.16605747178465813},
{0.14859774708362433,0.5204011579283171,0.14237134968055665},
{0.09294681117060258,0.4995802186527337,0.1726920647853565},
{0.08336027693713734,0.5347346162799721,0.1658273734081719},
{0.05384355896984903,0.48457640343843494,0.1724722049783158},
{0.02866206685462524,0.4758897855720235,0.16194372235586252},
{0.020089150996266684,0.51650619056241,0.15847877490666737},
{0.044218225946906005,0.5239679521998915,0.1696269604166128},
{0.037157924006104334,0.5649976720726314,0.15231946707707167},
{0.00898138089202727,0.5185145667899606,0.1645809622961986},
{-0.007578158005914671,0.5612848434684393,0.14695715104799845},
{-0.00854974435908712,0.5198159428536941,0.1637602601243286},
{1.993826681495394e-05,0.4668582895769207,0.16813967348663167},
{0.09299584852952587,0.34144120259003485,0.13192639222989577},
{0.06467165446660286,0.354277135442263,0.1428654953743221},
{0.061928795599355074,0.31982488813015714,0.1491341942353621},
{0.0667328401576093,0.24518895010475675,0.1419876727623876},
{0.05676316787805109,0.11992921376408623,0.12646869584335638},
{0.05614723709509152,0.08829688402610733,0.11270698076442238},
{0.07516888250864351,0.09276251692058332,0.10705960140710277},
{0.10236575618840693,0.10387837010596387,0.10312475750756578},
{-0.03085581507634741,0.8085996439133322,-0.15224887483510516},
{-0.022246255916815408,0.802349266702879,-0.15975374623867292},
{-0.04178360190717607,0.7957200624229414,-0.16249013864100775},
{-0.019099242992507533,0.795624143193399,-0.1649387733547158},
{-0.01509650121138444,0.7990082598311824,-0.1547142145831717},
{-0.014301126027090189,0.7950421613512326,-0.16040901468318633},
{-0.04488211634463673,0.7637654871834667,-0.16318420587499896},
{-0.057955691782416406,0.7723594190527923,-0.15031162972159715},
{1.8860522662793683e-05,0.7769360595949408,-0.15914913176931103},
{1.8860522662793683e-05,0.7655874136726933,-0.16154172378710674},
{-0.013707827871325982,0.7733816593811164,-0.17624969823163741},
{1.8860522662793683e-05,0.7459827086728227,-0.18666124561358133},
{-0.004640227447125882,0.7205404024727762,-0.2066614827172948},
{1.8860522662793683e-05,0.7109781174827345,-0.1938400994111206},
{-0.02398411836217378,0.7401095419156256,-0.19648650017675007},
{-0.020552042109619525,0.7054277350991094,-0.21329930895044966},
{-0.028972457170447406,0.6800684151987793,-0.20222387117077506},
{-0.027190946086926543,0.6640579869463629,-0.2011525934835278},
{1.8860522662793683e-05,0.6978312554426079,-0.20249169059258684},
{-0.036028448134640435,0.7266991714302959,-0.18318013200210376},
{-0.03221862255675402,0.6964070165455283,-0.20084166429562955},
{-0.055234926670287905,0.6908534009294466,-0.1903099484407198},
{-0.037060927032409936,0.6500343800384539,-0.21083989679522},
{-0.048000030176836274,0.719893217109404,-0.18014735995792489},
{-0.0698690756403956,0.7821690463257547,-0.14751218928636095},
{-0.07115213005354235,0.7983389807126906,-0.14223555391738443},
{-0.04407273048636439,0.8080305950009917,-0.15345271505306812},
{-0.05021102230499299,0.8117067803040101,-0.14302176827638532},
{-0.06535332764284423,0.8096930153556988,-0.13153193787020512},
{-0.08831736116499833,0.7850234517127511,-0.12128151323900918},
{-0.08763730460498524,0.773089590715881,-0.12465970228395541},
{-0.07572068751454956,0.7676335109455696,-0.13584183673469388},
{-0.08951311830182011,0.7821076149090815,-0.11005842451048861},
{-0.09145790762439325,0.7646977358750852,-0.11272691903123735},
{-0.08338452618056096,0.7635612546666323,-0.10853934412801877},
{-0.08200285817749156,0.7753517756912651,-0.10526407964960383},
{-0.08084859419052795,0.7850406956191857,-0.10714043221851478},
{-0.07518720415923025,0.7931453316434306,-0.1135109779019339},
{-0.193445914487468,0.35954730434632665,-0.06729030332031419},
{-0.18455668072045045,0.3484481561953045,-0.06846773880654923},
{-0.1856764568945449,0.33641891484096803,-0.06478670365484597},
{-0.1902568695412259,0.3354920548701104,-0.03029134657665348},
{-0.19888205599096423,0.3088081874067753,-0.032907570506022436},
{-0.18844841485390101,0.3119541225869309,-0.0886037716734349},
{-0.20986534664562911,0.36101842511402543,-0.08093993300742351},
{-0.21341974685945359,0.3951344162506575,-0.05728991533241941},
{-0.1968720631471854,0.38687889604511017,-0.03971514144314253},
{-0.19945002715915267,0.34295920522835244,-0.010964160695964063},
{-0.1852949354646802,0.3272473121060845,0.007146252036936449},
{-0.1912025900347465,0.29564677582059445,0.025996536130294963},
{-0.19478662821275536,0.2415634187768898,0.008611984083874364},
{-0.19650670787960306,0.24762249640033462,-0.030971403136666582},
{-0.18998635575903366,0.24612820413336453,-0.06371380935137046},
{-0.17335137477044052,0.2874354431252856,-0.09332644654820103},
{-0.18013685195244133,0.2829520274522991,-0.09991900752696516},
{-0.19725789555365875,0.31394794926842723,-0.09402482475880086},
{-0.21657107076037008,0.354559504410129,-0.08172830285472872},
{-0.22196625798608421,0.4083669589508808,-0.07475799255063241},
{-0.21457185535811285,0.4340991783278585,-0.054405871981238633},
{-0.20069158842244125,0.43067895726097805,0.003939424312183685},
{-0.2043327470405146,0.3711583809696249,-0.004996152453376788},
{-0.20290204167852188,0.35821090159764807,0.025035727218644114},
{-0.18516291180604058,0.3238513402826277,0.04531994990645181},
{-0.17073515084107155,0.3152310036815741,0.056960664493934464},
{-0.16359940680961868,0.2992949397756568,0.06461588120672858},
{-0.175769293775812,0.20332343964201666,0.05908382047369012},
{-0.1854328867161567,0.18855241716458446,0.02834655725408034},
{-0.1815767181397274,0.17551386841175004,-0.0021864734486950668},
{-0.17563242026848763,0.17078149383961444,-0.03156362354827863},
{-0.16382734969780058,0.18016756766077796,-0.062205506410422225},
{-0.1711516989558815,0.23509587611977611,-0.0849265086262642},
{-0.15349717199934476,0.26364693532672895,-0.09748707784761561},
{-0.15978365363889538,0.2681966322650735,-0.10091430425148515},
{-0.1452006975160153,0.30132379314209845,-0.13270721786813586},
{-0.1727176612089703,0.3023083124250968,-0.12294070036125986},
{-0.1978684376158575,0.3256587172258003,-0.12624721942008743},
{-0.21806697964356847,0.35266051921402286,-0.12423507108800429},
{-0.23252276195649366,0.3836068647991516,-0.11692527137597752},
{-0.22920061560745977,0.41209864807773555,-0.07413882853521638},
{-0.22088743608977182,0.46969868428993905,-0.07163522886974816},
{-0.21578323978514097,0.4680378805514601,-0.07203183871774313},
{-0.20380842451048864,0.45901985635825954,-0.014118717829337058},
{-0.20427885983290658,0.45230012156954047,0.021683942905425795},
{-0.20374753196589157,0.40087340386091075,0.05814079434054992},
{-0.1871271005233526,0.3778624884681375,0.09266147840631818},
{-0.1678020701309675,0.3453857461869413,0.08669993662864385},
{-0.15802046420596125,0.3135260124328566,0.09716537121819578},
{-0.1274044472034695,0.24906936792460976,0.10211491123699165},
{-0.1400603967822871,0.17953924282006856,0.09649555322762819},
{-0.15760876593983605,0.15242643318417354,0.07014039773070192},
{-0.17384390384797777,0.16072506315580734,0.050443545605821545},
{-0.17900306510436875,0.165477914866834,0.03499084995214816},
{-0.1894679608218446,0.4360488174991163,0.09689054645939492},
{-0.16922630902804725,0.3988434727503168,0.11776806730296682},
{-0.16237993930144937,0.36903145288533656,0.11072069829199108},
{-0.1328346611141288,0.34465288016347234,0.12134941112059526},
{-0.12770298233361788,0.3226448057042844,0.12648809523809523},
{-0.10329261615926474,0.2580291939335937,0.12777276626747022},
{-0.05635470284438238,0.19257671382875088,0.13148451712751008},
{-0.05880225981393827,0.15666035108593498,0.133939079434055},
{-0.11283280739418709,0.12999857737771914,0.10238650276333601},
{-0.12628305441314677,0.13997848822672293,0.0947528409335851},
{-0.21969437331333044,0.5361572385608235,0.027793674504022144},
{-0.21016819275238616,0.5352411560314874,0.0071742733848926135},
{-0.2092828259313865,0.4972404360983937,0.04903601174310029},
{-0.20141906572514942,0.5034547088797497,-0.01324466732193511},
{-0.2040584611537898,0.5345513997741048,-0.01651993180035005},
{-0.18204661459006927,0.5484004121293639,-0.0593904386849797},
{-0.20145085917763814,0.49782888440547335,-0.05280003319451989},
{-0.19603034496434826,0.5489888604364432,-0.07743618676875061},
{-0.23878014450393595,0.4852941810437737,-0.10496823887983585},
{-0.21156872127811838,0.5509789150134072,-0.09292121474698879},
{-0.2329851141977704,0.51386948949415,-0.11874396463274792},
{-0.22796174870455155,0.5595265038841899,-0.1157661575403292},
{-0.22861001181207594,0.5378519912400955,-0.13603151970547409},
{-0.238894924256141,0.5060811713785642,-0.14044649862479847},
{-0.22756621660070878,0.531673284015761,-0.14971563720545253},
{-0.23702342153591477,0.49654259675987006,-0.18531729865583751},
{-0.2403999939646328,0.5153783313071744,-0.17174634429183588},
{-0.2207171525137305,0.5305745238526336,-0.18460275428295528},
{-0.22594636714001193,0.5454366157109232,-0.16953912426821174},
{-0.22507662760921862,0.5391856996283938,-0.1529989847650087},
{-0.19313444642749372,0.48060437736564837,-0.01342572833949803},
{-0.19797513428692137,0.47146510695532984,0.03375252192131606},
{-0.20155270600001726,0.4796295577800196,-0.03576952010208393},
{-0.20109358699119703,0.4454219583904538,0.061993729684522735},
{-0.18059489321710942,0.4560377382892322,0.09088481717148204},
{-0.16477899778415805,0.4345151875705923,0.11957328875783522},
{-0.13630823051654126,0.42827019908089975,0.13540103937646034},
{-0.1351922264469793,0.37720560340739595,0.13186496081322266},
{-0.08341578076097361,0.3705095789900244,0.1498584383056138},
{-0.0929548942517438,0.34144120259003485,0.13192746997404795},
{-0.061887841321573,0.3198286602346897,0.14913527197951426},
{-0.06736817033530777,0.28675646430942475,0.13994049774535927},
{-0.06669188587982723,0.24518625574437644,0.1419876727623876},
{-0.05671628600743214,0.119927597147858,0.1264708513316607},
{-0.10232426303854877,0.10387837010596387,0.10312583525171794},
{-0.19423374546269714,0.4625688678513231,0.06110243527068623},
{-0.20475899485269394,0.4905745885172828,0.07551834104998147},
{-0.18261243026995339,0.4672678323547417,0.10659940465413036},
{-0.14761753877723463,0.4486163920574567,0.13433784477035426},
{-0.15162513040704245,0.4501193062776443,0.12027705568919585},
{-0.10998917944871232,0.4361247984618437,0.14342807782174974},
{-0.05202271022477433,0.39397799677538947,0.15400505893105024},
{-0.032854491606528556,0.3647204762766957,0.14618063638636697},
{-0.06463070018882079,0.354277135442263,0.1428654953743221},
{-0.034856401369166186,0.3122585853099161,0.152220853487149},
{-0.044177271669123934,0.5239679521998915,0.16962588267246062},
{-0.053802604692066956,0.48457640343843494,0.1724722049783158},
{-0.02004927446263678,0.516505651690334,0.15847877490666737},
{-0.03711696972832227,0.5649976720726314,0.15231946707707167},
{-0.01833727787693025,0.5946356362570376,0.12448025788262075},
{-0.02862111257684317,0.4758897855720235,0.16194372235586252},
{-0.05098322599001579,0.444958528405025,0.15072117249941802},
{-0.06737355905606857,0.4419817990567585,0.15675815636774357},
{-0.10322687376598295,0.4574819154531268,0.16605854952881025},
{-0.09290693463697268,0.4995796797806576,0.17269260365743255},
{-0.08332686686842039,0.5347383883845047,0.1658252179198676},
{-0.07295950699671505,0.5715309571230268,0.14793951484269247},
{-0.03586570876766424,0.599722588655234,0.13017613572678755},
{-0.018529116336014773,0.6003800125880517,0.11489156816085117},
{-0.014409978186458372,0.6055499512859643,0.11934911797418588},
{-0.0291217247355216,0.6293966572687378,0.10024394738884149},
{-0.030364902615038422,0.6517404490313237,0.06703380021210005},
{-0.005303578972780504,0.6662517351680851,0.03937888526766854},
{-0.034315912676857824,0.6610785632377159,0.043259841959597534},
{-0.019756666925325277,0.6692338532371124,0.029427534638697055},
{-2.9099092108336512e-05,0.6642395868360019,0.024895081606787207},
{-0.13138940620608194,0.46940338239224727,0.15980062810929188},
{-0.14856649250321172,0.520400080184165,0.1423648832156437},
{-0.13031705077468253,0.5444143753825992,0.14238266599415433},
{-0.12307137683970928,0.5868990498607555,0.11604313778743437},
{-0.08556641921660935,0.5964602571066451,0.1231266112275075},
{-0.05282832397851411,0.6001321314330549,0.12233339153151755},
{-0.17518892854987372,0.4932522438633249,0.12669394437115786},
{-0.20395391997103027,0.5193034755093419,0.07972423760378677},
{-0.1904007483855393,0.5408971573420244,0.09332105782744024},
{-0.16429239629945772,0.5691820137433936,0.09977620642680395},
{-0.2172672934826656,0.5357261408999595,0.05113653509566058},
{-0.18594050421182418,0.5560847279342663,0.0863841575920609},
{-0.20186525180414375,0.5442834294681118,0.0680571182845762},
{-0.21283992050559136,0.4104658656872129,-0.20264634687842187},
{-0.1843810084236483,0.39460308838364244,-0.2099001038945363},
{-0.21951762327237617,0.37798750678978815,-0.1659631691713441},
{-0.23556415595388983,0.40079257304949867,-0.15381052611158533},
{-0.19284453325056264,0.354277135442263,-0.17511321702318444},
{-0.14700053025012288,0.375861117577576,-0.21074667192605814},
{-0.20110328668856645,0.41221396670201677,-0.20465633972220068},
{-0.19177002233085885,0.4324098143693474,-0.21578512583740722},
{-0.19763995585559957,0.4368183268237588,-0.22152788555219302},
{-0.23781394687152432,0.4562241880275559,-0.1925990770199081},
{-0.23253892811877605,0.41994408663338606,-0.17940263874878218},
{-0.24740209772121782,0.43512357414448666,-0.1528820495244993},
{-0.24050722950777273,0.4144077149237388,-0.10935465757912798},
{-0.2468055663329971,0.47651703266858086,-0.1572339804109223},
{-0.24673120198649803,0.4533148176887993,-0.125511120164162},
{1.8860522662793683e-05,0.678406533716148,-0.19845984971935543},
{-0.00261730167352113,0.680995275169637,-0.20948140029142204},
{-0.0030214557305812163,0.7073245648069113,-0.18915029573299535},
{-0.006937977979531494,0.7111721114301234,-0.19934575541243116},
{-0.018773764258555144,0.7086286352310254,-0.20031895838183184},
{-0.014738690152867242,0.6802839640292113,-0.20980903451367874},
{-0.021449802988368998,0.7041991067656468,-0.191306861781468},
{-0.017667998758438747,0.6776327134148971,-0.20020256201339853},
{-0.10490977125958117,0.40057702421906666,-0.20508204866230398},
{-0.11399677107852015,0.42939374735952685,-0.21746802333100543},
{-0.10854877438935019,0.41325614529715565,-0.22212872791702234},
{-0.08698203616047182,0.35800613020873745,-0.18312301156203928},
{-0.053488981143788326,0.353684915030651,-0.17123172145917936},
{-0.08155613322642112,0.4295230766577862,-0.22551446117103371},
{-0.08710220463343768,0.4726452368019451,-0.2418228856815223},
{-0.13208562892837747,0.4946964210272195,-0.24449191907434714},
{-0.1290361518498401,0.48232769026495276,-0.2343492688583672},
{-0.150081800781149,0.4577836838157317,-0.2293442250157351},
{-0.17120450841933735,0.4486045368717829,-0.22021519317486185},
{-0.18890645611856913,0.4808258537889174,-0.2302355194295716},
{-0.18590224429442248,0.4769190312373366,-0.22205598018675152},
{-0.19417177517394796,0.5044289895933026,-0.2206344356500522},
{-0.15685272841709563,0.4892155531414088,-0.238107901589026},
{-0.16634765439762728,0.5161144305630998,-0.2348773634929257},
{-0.17257270462050475,0.5341790391695336,-0.22202310899011066},
{-0.1942806273333161,0.5262727080692862,-0.20749134571445815},
{-0.17745596337394273,0.5512623617254252,-0.20262910297198727},
{-0.19141975548140677,0.5467837959011235,-0.1928916845572196},
{-0.18955633584232173,0.5419447246579241,-0.188946063216161},
{-0.19784742160489038,0.556526603036652,-0.19118130458774132},
{-0.19450210375658505,0.5531424863988688,-0.18535070872455447},
{-0.0787733978255434,0.346541087918057,-0.16326503668641096},
{-0.0694218118172491,0.3355119931369253,-0.16339598260089844},
{-0.0495196494313822,0.4159973875481752,-0.19805677340644753},
{-0.037861690937464984,0.3813716234275714,-0.17953843451195434},
{-0.03640350309959219,0.45309495788175846,-0.21483563323935406},
{-0.04494893648207066,0.4713093729253427,-0.22015861160687344},
{-0.06146428786977404,0.5061959511307693,-0.23802760964969008},
{-0.10683192795495894,0.5111271694989783,-0.24832814938396147},
{-0.13803908762491057,0.527697485838442,-0.2399562328099808},
{-0.13610453687178295,0.5270503004750697,-0.2334655186535958},
{-0.18066063561039122,0.5527113887380047,-0.19365688290525337},
{-0.17238032728934416,0.5676381452454239,-0.20997824034556792},
{-0.17449162808342605,0.5704510574825621,-0.20547650302199463},
{-0.034464641369855935,0.4380394109481562,-0.20764707974444532},
{-0.033350253916522264,0.4992827612667373,-0.22553008846124004},
{-0.04701820525421831,0.5266192028142055,-0.2275939685126269},
{-0.07272455877154413,0.5593691532379745,-0.24178193140374024},
{-0.10203488873369375,0.5500601381236907,-0.23773338549615033},
{-0.10919811524102672,0.5663809566919291,-0.22918849098574795},
{-0.13648713604579985,0.5540817404274766,-0.2241597367717683},
{-0.05216551132493556,0.588341610408422,-0.22099278558064545},
{-0.03439728236034593,0.5571958821551436,-0.22634701852857747},
{-0.15058402955605565,0.6606560875300691,-0.18766300880301426},
{-0.09113512325082126,0.62849727977376,-0.21041364898304063},
{-0.12839651069553298,0.6340913107955478,-0.21322386685979844},
{-0.16449447332798775,0.6524997197865204,-0.19443770854349346},
{-0.15789329039600633,0.6456344895372598,-0.19644015717820718},
{-0.14192004431683955,0.6395344576360329,-0.20494355853875137},
{-0.13164375382599175,0.6308155074450567,-0.2097158096445169},
{-0.12783285050395318,0.6036455773690973,-0.2188836402748679},
{-0.09907755878016608,0.6240806842382075,-0.21783499521481597},
{-0.09355304225619274,0.6076467025339922,-0.21856301138960021},
{-0.06885869049774537,0.6105646948259659,-0.2191789421725598},
{-0.04020740108464173,0.6164836657096299,-0.2188049649517602},
{-0.08448975280860127,0.5846966796858162,-0.23409007138977267},
{-0.10742199287826666,0.5767132898786893,-0.2308336674340205},
{-0.1474639602355518,0.5846233930834691,-0.22002066035539694},
{-0.14162689790745198,0.5819829199106767,-0.2056263094591449},
{-0.13365805764637925,0.6043137787434365,-0.21222318141451768},
{-0.13235614271056967,0.6185831113180381,-0.21232125613236424},
{-0.17990405921557473,0.6501825698593761,-0.1795971715682471},
{-0.18730223394807863,0.6585733469560195,-0.17315765025908972},
{-0.14846195132045215,0.6644330419113146,-0.17732959787210198},
{-0.017094638869489504,0.5971575575730926,-0.22497612796702968},
{-0.04840095100143988,0.5933315658329238,-0.22630821973909973},
{-0.01776930670874181,0.6143583542415698,-0.23729366588206893},
{-0.018205254218290626,0.6841439047101731,-0.22045283576041316},
{-0.02086135468128951,0.685730344102153,-0.2067288417268048},
{-0.005848378641697501,0.7036494572480451,-0.2069082861281395},
{-0.005606963951613609,0.6989558814653873,-0.21628573799608564},
{1.8860522662793683e-05,0.624359819973617,-0.23852876068044457},
{1.8860522662793683e-05,0.606152949139098,-0.22971335238784996},
{1.8860522662793683e-05,0.6600008190855557,-0.23154928955105492},
{-0.015233374718708788,0.3116200218997612,-0.15914751515308279},
{-0.04578095496753836,0.34765170326685807,-0.17669803979893609},
{-0.005923820732348717,0.34787910728296384,-0.1679979501306226},
{-0.0028425502013226184,0.3413393557676556,-0.15696292775665402},
{-0.015173021046187816,0.2861868765250081,-0.14313062043575353},
{-0.024556939379046943,0.31153380236758854,-0.14860933283326008},
{-0.03248428649026151,0.3241865187139495,-0.15971279196089086},
{-0.034664024038005586,0.3761337868480726,-0.18829618349240837},
{1.8860522662793683e-05,0.37103336264797426,-0.17761250571204404},
{-0.016171012131088187,0.0817172559771691,0.12489303389289812},
{-0.05610736056146161,0.08829688402610733,0.1127064418923463},
{-0.07512792823086144,0.09276251692058332,0.10706067915125494},
{-0.12358007207952891,0.1343526637524465,0.09564844632403026},
{-0.14219918005224907,0.18908051179914306,-0.09043162575549867},
{-0.13912060388160336,0.22064602139968803,-0.10094448108774563},
{-0.1433308114120173,0.2512997594475053,-0.09676714475397258},
{-0.13180757093712012,0.18901584715001352,-0.10294315761792677},
{-0.1657042411387876,0.33181910279954824,-0.16960001681280878},
{-0.12999264978488229,0.3286052697378064,-0.16736531431330454},
{-0.09842606244018522,0.32195397170274953,-0.15214487252442171},
{-0.11162357845546332,0.3687447729408621,-0.19741659338006434},
{-0.13200964796565015,0.2883159600976006,-0.11842656897993672},
{-0.11715995016511042,0.30485017200796666,-0.13705483777795022},
{-0.13672639524757943,0.4002073579748757,-0.21711236776079257},
{-0.14724086719605461,0.38751476509488453,-0.20424571920022763},
{-0.13482094358656013,0.4131327435917333,-0.22667357500668203},
{-0.1836449091677229,0.45336062181526604,-0.22311863592078152},
{-0.21162206961365032,0.4946646275747309,-0.2114256507419191},
{-0.1369139227300553,0.41421048774389363,-0.2183738672908961},
{-0.22578147228473142,0.4785733685109026,-0.20153950363415332},
{-0.22020091306484574,0.5147747945819647,-0.20142310726572002},
{-0.07109500961347785,0.42946056749696077,0.15763274574722158},
{-0.039138817757774856,0.4341487545588579,0.16152232439236786},
{-0.06385580214341759,0.4148167188294838,0.14903773613374377},
{-0.01663013113990845,0.46768815257408425,0.1721531927092764},
{-0.03564692670477571,0.6579315503134082,0.03335752868954933},
{-0.22373268065147484,0.6806180647163811,-0.026616777889863167},
{-0.21064240017933664,0.6710369192036765,0.0018669223075795606},
{-0.19120312890682256,0.6720672426131417,0.005881519274376418},
{-0.19314953484562394,0.6616174353137961,0.025835952251623086},
{-0.20776697878137318,0.6263752015381566,-0.17880233525602893},
{-0.18996264538768615,0.6511956493624066,-0.17745677168205687},
{-0.18471942008742662,0.6447507393324884,-0.17995067165015563},
{-0.16135931558935362,0.6627490666735644,-0.16911018209565196},
{-0.19260958502539166,0.6772409534155868,-0.14904420259865672},
{-0.18446022261883208,0.676266133829958,-0.14798909107369188},
{-0.19131305881034294,0.6830688549183933,-0.13073225170930225},
{-0.2115116008380539,0.6890519515791107,-0.094113199779278},
{-0.2270014786649768,0.6854786908426237,-0.09104486217807783},
{-0.2171293422311891,0.6797127596285663,-0.12341760214859075},
{-0.204638287507652,0.673709724701034,-0.14326749394307786},
{-0.193869467939267,0.6658637472733072,-0.16011155729719012},
{-0.21528747747514723,0.6882323271513929,-0.06266624203547072},
{-0.2301474138451325,0.6854894682841451,-0.05759222256710036},
{-0.20954902873697012,0.6834880973935836,-0.03343835950096135},
{-0.15316199356802293,0.6580657294603519,0.05790422949915075},
{-0.1430786192804118,0.6486737280463517,0.059116152798254926},
{-0.12180448858884493,0.6510776363777451,0.046555583576903516},
{-0.14220995749377066,0.6370556460860644,0.05395483605355958},
{-0.11691637998672222,0.6441040928411923,0.05965286938603072},
{-0.1055375572282145,0.6473804350637593,0.059869495960614916},
{-0.1322111861221041,0.6697005164549977,0.048126395678677054},
{-0.09059517343058898,0.6513179733236769,0.05985710190286508},
{-0.11367398670494816,0.6789567221058259,0.032189792900683724},
{-0.07308183095798523,0.6710951173878932,0.03889390039919644},
{-0.06261585749635724,0.6452642844209929,0.08008959287136909},
{-0.17563996447755276,0.6617596975418814,0.042183714423665544},
{-0.14974877783813145,0.6783224696722795,0.020471480734245536},
{-0.11147646637869345,0.7100636515696268,-0.02164622186010019},
{-0.08278260607157947,0.7212420139158325,-0.04765380486795479},
{-0.06678942172559774,0.661461701283809,0.03100211884500315},
{-0.04749456816947313,0.6505705577541536,0.027878816292042804},
{-0.16565250941948392,0.6924263685195244,-0.0014751623082693139},
{-0.11348322599001581,0.7400060784770182,-0.0697696537423588},
{-0.08884222256710037,0.7379432761697835,-0.07603458049886622},
{-0.07677687678366658,0.703972780493693,-0.03184491477199245},
{-0.070174616107533,0.668127009992844,-0.018063800298319582},
{-0.06477835113766674,0.6578453307812353,-0.0014277415655742649},
{-0.0611862298785167,0.6410648543321004,0.015579600027590252},
{-0.19703480251416158,0.6994306277644138,-0.03578676400851849},
{-0.15289579076243934,0.7066240311080074,-0.031085105144719488},
{-0.12171072484760699,0.7394311019718407,-0.0732168184130433},
{-0.12428599449919386,0.748559056068562,-0.08234800574222084},
{-0.08738619021753191,0.7515228524870026,-0.09569478932257315},
{-0.1851747669917143,0.7225018968297078,-0.09476254063095454},
{-0.1790704241138788,0.7216181466249366,-0.06663880698033332},
{-0.18023869877482046,0.7093183914884079,-0.05073076442237225},
{-0.1414258986230741,0.7411856694515575,-0.08531988524180267},
{-0.13357129924213032,0.7522217695696783,-0.10294639085038326},
{-0.10412140141227597,0.7583988601777847,-0.15086990119241614},
{-0.07089023822456741,0.7637444711724996,-0.15973111361147757},
{-0.08224265625134719,0.7289063914539201,-0.17795361173620275},
{-0.0814866187286068,0.6933763999896538,-0.1871004263555866},
{-0.10120933671313902,0.6633019494236225,-0.1945072230413078},
{-0.09233950234086032,0.654090470155109,-0.20785454549373616},
{-0.0916923169774881,0.6379808894406941,-0.21580829733667867},
{-0.11006138830690707,0.6826178189907144,-0.18530921557469632},
{-0.1572191614288301,0.6785051473060709,-0.16595400834605073},
{-0.16692801962356554,0.6882905253356095,-0.1495890022675737},
{-0.16771638947087075,0.702587340386091,-0.14827684876231864},
{-0.18125339489407932,0.7193640447306933,-0.12621704258382696},
{-0.1340579007268307,0.7496621272082977,-0.13569364691377186},
{-0.1050471836389816,0.7419201520912547,-0.16450875343800386},
{-0.14362395782140489,0.7347633920488349,-0.14953511505996572},
{-0.12047293568885097,0.7177113240733558,-0.17047083408775426},
{-0.11359100040523182,0.6939206607864947,-0.17620766620970316},
{-0.01458888371571697,0.600642982161179,-0.24012651638602212},
{-0.01750633713561471,0.5419711293896519,-0.24283488744040077},
{-0.018342666597691053,0.6015978634799929,-0.2322821555745239},
{-0.01981917608615057,0.5292273436624334,-0.2319157225627894},
{1.8860522662793683e-05,0.5349932748764905,-0.2308778549442591},
{-0.042420009829026675,0.309325504599812,-0.1665020412474242},
{-0.016233521291913484,0.2630460929618997,-0.15445286162627284},
{-0.01029030116482589,0.20535606511299065,-0.14502152255071865},
{-0.020976134433494574,0.1650074795444161,-0.14720179897053878},
{-0.01253362561754741,0.16940090358069732,-0.14116535397428934},
{-0.11789119957235114,0.2565284352017107,-0.13820425191622912},
{-0.1384394695774381,0.22246740901683879,-0.11117927842873525},
{-0.1128031694300027,0.22333607080347978,-0.13631981626617695},
{-0.08442023831078695,0.2712256322047196,-0.16154926799617186},
{-0.05674646284369263,0.2976982618142315,-0.1680362100480243},
{-0.03525462783338939,0.23460442478639126,-0.1651721049636585},
{-0.054862027193640465,0.20699154186389387,-0.15897507608873718},
{-0.03549873688385368,0.16526667701301048,-0.1489278062302234},
{-0.07003019839114355,0.18266793409378956,-0.13979661890104586},
{-0.09869118750161664,0.18674396247725975,-0.13412822353275913},
{-0.12445520033108302,0.19554697671210447,-0.1141807958925015},
{-0.1588433218661356,0.3882664916410163,-0.21979433408344326},
{-0.19542896372744284,0.4084984437374443,-0.21459098531681367},
{-0.18936557512738939,0.4240718467361597,-0.22287344912616505},
{-0.15168225084710693,0.4085992128156713,-0.2309134205012804},
{-0.03484185182311202,0.3844108619366631,-0.1940114607313141},
{-0.027562228947345745,0.415047356078046,-0.20802644568600573},
{1.8860522662793683e-05,0.37392441133614424,-0.19430352939654952},
{-0.027523969029944056,0.4285121526430598,-0.22068778398558414},
{-0.021684751213539927,0.47174693705111964,-0.23338630445841202},
{-0.02112755748687309,0.47252722381728357,-0.22295535768172925},
{1.8860522662793683e-05,0.4788508876300839,-0.22658951096281352},
{1.8860522662793683e-05,0.4747797090952986,-0.23580099023132703},
{0.027325125233870474,0.42899067104661903,-0.22104990602070995},
{1.8860522662793683e-05,0.4223797884172681,-0.20881104342877838},
{1.8860522662793683e-05,0.4183274704051457,-0.2141900644922101},
{-0.021660501970116323,0.48712634610244615,-0.23707380607502826},
{-0.017244445306639777,0.5279124957967979,-0.24128886345412692},
{0.014742462257399782,0.530389151858462,-0.24192473250390145},
{-0.13066085115922163,0.7424913564918998,-0.06360495719200228},
{-0.1449409611753447,0.7447007320038281,-0.07539332272833088},
{-0.1734850150453084,0.726767069311882,-0.04833224481173966},
{-0.15517521964425823,0.7239326021917006,-0.03321796082184458},
{-0.0066394428493831105,0.24521373822025652,-0.15031270746574932},
{0.0026625669279118393,0.3417084831397706,-0.15793020313321782},
{-0.003532845330781246,0.1721211298207497,-0.14799178543407224},
{0.022285054706293154,0.802349266702879,-0.15975374623867292},
{0.030894074993749077,0.8085996439133322,-0.15224887483510516},
{0.041822400696653814,0.7957200624229414,-0.16249067751308383},
{0.019138041781985284,0.795624143193399,-0.1649387733547158},
{0.02402345602372761,0.7401138528922342,-0.19648434468844572},
{0.044920915134114475,0.7637649483113905,-0.163184744747075},
{0.05799449057189415,0.7723594190527923,-0.15031109084952107},
{0.14728074372968453,0.3875255425364062,-0.20425434115344493},
{0.20114208547804419,0.41222528301561434,-0.204671967012407},
{0.19181367096902133,0.43242705827578176,-0.21579751989515708},
{0.197676599156773,0.43683664847434545,-0.22154459058655152},
{0.13695164377538085,0.4142212651854151,-0.21838141149996124},
{0.23407363579145218,0.5180295819214886,-0.13415570600863921},
{0.2242936464826742,0.5561440038626351,-0.10407317236146678},
{0.22406354810618798,0.5355860341601787,-0.1307899110214428},
{0.22327517825888277,0.5300652897407381,-0.14456132579774622},
{0.2370525206280231,0.49657439021235866,-0.18535340308493486},
{0.23784843468439343,0.45623819870153404,-0.19262925385616858},
{0.22580949363268757,0.4785949233939457,-0.20157075821456596},
{0.2404290930567411,0.5154106636317392,-0.1717786766164007},
{0.2243372951208367,0.5390994800962211,-0.1499166364898304},
{0.2285351085935008,0.5594149573644415,-0.11561850659148325},
{0.13184636972659786,0.18901584715001352,-0.10294423536207893},
{0.021488601777846745,0.7041991067656468,-0.191306861781468},
{0.017705719803764338,0.6776327134148971,-0.20020256201339853},
{0.01477641119819283,0.6802839640292113,-0.20980903451367874},
{0.018811485303880732,0.7086286352310254,-0.20031895838183184},
{0.0026561004629988777,0.680995275169637,-0.20948140029142204},
{0.006976776769009242,0.7111721114301234,-0.19934575541243116},
{0.003059176775906804,0.7073245648069113,-0.18915029573299535},
{0.00467794849245147,0.7205404024727762,-0.2066614827172948},
{0.013746087788727648,0.7733832759973446,-0.17624862048748527},
{0.020589763154945113,0.7054277350991094,-0.21329930895044966},
{0.03606724692411818,0.7266980936861439,-0.18318067087417986},
{0.0480393678383901,0.719892139365252,-0.18014843770207706},
{0.03225634360207961,0.6964070165455283,-0.20084166429562955},
{0.05527264771561349,0.6908534009294466,-0.19031048731279585},
{0.029011255959925153,0.6800684151987793,-0.20222387117077506},
{0.037099186949811604,0.6500343800384539,-0.21083989679522},
{0.027228667132252134,0.6640590646905151,-0.2011520546114517},
{0.015135300000862186,0.7990082598311824,-0.1547142145831717},
{0.014339924816567937,0.7950421613512326,-0.16040901468318633},
{0.1613981143788314,0.6627490666735644,-0.16911072096772803},
{0.19264730607071726,0.6772409534155868,-0.14904689695903708},
{0.1844974047920816,0.6762655949578819,-0.1479928631782244},
{0.19135239647189675,0.6830683160463171,-0.13073279058137832},
{0.21154986075545554,0.6890519515791107,-0.09411535526758232},
{0.22704027745445457,0.6854786908426237,-0.09104647879430608},
{0.2301872903787624,0.6854894682841451,-0.057594378055404676},
{0.21538124121638516,0.6881611960373505,-0.0626506147452644},
{0.22543874964434443,0.6815018149211522,-0.027974735521585064},
{0.2092909090125277,0.6838529137890899,-0.033594632403024585},
{0.19099404654130347,0.6718780985144377,0.006331477457903315},
{0.21068227671296655,0.6710369192036765,0.001865844563427399},
{0.19318941137925386,0.6616174353137961,0.025834335635394844},
{0.19390826672874473,0.6658637472733072,-0.16011263504134227},
{0.20467708629712975,0.673709724701034,-0.14326964943138218},
{0.217169218764819,0.6797127596285663,-0.12341975763689507},
{0.13225106265573403,0.6697005164549977,0.048126395678677054},
{0.1532083365665658,0.6580678849486563,0.05790045739461818},
{0.17567984101118267,0.6617596975418814,0.04218263667951338},
{0.11371763534311063,0.6789561832337498,0.03219087064483588},
{0.149759016407577,0.6783219308002036,0.020488724640680103},
{0.14146685290085617,0.7411851305794817,-0.08532096298595485},
{0.1802774975642982,0.7093183914884079,-0.050731842166524405},
{0.1791097617754326,0.7216192243690887,-0.06664042359656157},
{0.19707414017571542,0.6994306277644138,-0.035788380624746735},
{0.15293566729606925,0.7066240311080074,-0.03108618288887165},
{0.16568538061612478,0.6924322961123613,-0.0014805510290301148},
{0.12174952363708474,0.7394311019718407,-0.07321789615719546},
{0.11352256365156964,0.7400055396049423,-0.06977019261443487},
{0.12432479328867162,0.748559056068562,-0.08234908348637301},
{0.13361117577576023,0.7522217695696783,-0.10294746859453542},
{0.1852157212694964,0.7225008190855557,-0.09476254063095454},
{0.11151903727270376,0.7100717346507679,-0.02165969366200219},
{0.0828219437331333,0.7212403972996043,-0.04765111050757439},
{0.08888102135657812,0.7379432761697835,-0.07603565824301838},
{0.08742498900700965,0.7515228524870026,-0.09569478932257315},
{0.09149670641387099,0.7646977358750852,-0.11272799677538951},
{0.1041602002017537,0.7583988601777847,-0.1508709789365683},
{0.13409616064423233,0.7496621272082977,-0.1356952635300001},
{0.18129273255563316,0.7193635058586174,-0.1262181203279791},
{0.15726119345076434,0.6785056861781468,-0.16595293060189856},
{0.11010234258468914,0.6826280575601599,-0.1853038268539355},
{0.10124544114223635,0.6633014105515463,-0.19450937852961211},
{0.0923718346654251,0.654089931283033,-0.20785616210996444},
{0.09172896027866152,0.6379808894406941,-0.21580883620875477},
{0.0815238009018563,0.6933769388617298,-0.18710096522766267},
{0.08228361052912926,0.7289031582214637,-0.17795522835243097},
{0.07092903701404517,0.7637444711724996,-0.15973111361147757},
{0.07576056404817948,0.7676329720734937,-0.1358412978626178},
{0.16775195502789203,0.7025878792581672,-0.1482806208668512},
{0.16695873533190211,0.6882916030797619,-0.14959600760456276},
{0.11359746687014477,0.6939276661234838,-0.17622113801160516},
{0.1436665287154152,0.7347617754326067,-0.14953511505996572},
{0.12050257365303536,0.7177134795616599,-0.1704746061922868},
{0.10508598242845935,0.7419201520912547,-0.164509831182156},
{0.08342440271419087,0.7635612546666323,-0.10854042187217093},
{0.0768167533172965,0.703972780493693,-0.03184491477199245},
{0.06682929825922765,0.661461701283809,0.031000502228774908},
{0.07021341489701076,0.668127009992844,-0.018063800298319582},
{0.06481822767129665,0.6578453307812353,-0.0014288193097264242},
{0.061226106412146604,0.6410648543321004,0.015578522283438093},
{0.047534444703103036,0.6505813351956753,0.02787773854789064},
{0.07312170749161515,0.6710951173878932,0.03889336152712036},
{0.09063612770837105,0.6513179733236769,0.05985602415871292},
{0.0626568117741393,0.6452642844209929,0.08008851512721692},
{0.121845442866627,0.651077097505669,0.046555044704827436},
{0.1055774337618444,0.6473804350637593,0.059869495960614916},
{0.1431184958140417,0.6486737280463517,0.05911507505410277},
{0.14224983402740057,0.6370556460860644,0.05395375830940742},
{0.11695625652035212,0.6441040928411923,0.05965179164187856},
{0.017926657354957184,0.5406837639998965,-0.24242588353465597},
{0.0183814653871688,0.6015978634799929,-0.2322821555745239},
{0.017133437658967254,0.5971575575730926,-0.22497612796702968},
{0.016859690644318557,0.5982568566082961,-0.2401701650241846},
{0.019855819387323996,0.5292273436624334,-0.2319157225627894},
{0.021166356276350835,0.47252722381728357,-0.22295535768172925},
{0.022041484527904942,0.4862576843158049,-0.2362924415647121},
{0.13070072769285154,0.7424913564918998,-0.06360711268030661},
{0.15521509617788815,0.7239326021917006,-0.03321903856599674},
{0.14498191545312675,0.7447007320038281,-0.0753954782166352},
{0.1735248915789383,0.726767069311882,-0.04833332255589182},
{0.18940114068441066,0.42408262417768117,-0.2228885375442953},
{0.19546560702861626,0.408509221178966,-0.21460607373494395},
{0.1517156609158239,0.40860352379228004,-0.2309236590707259},
{0.15888158178353723,0.388277269082538,-0.21980511152496487},
{0.021722472258865515,0.47174693705111964,-0.23338684333048812},
{0.027600488864747412,0.415047356078046,-0.20802644568600573},
{0.03488065061258977,0.3844108619366631,-0.1940114607313141},
{0.015211819835665562,0.2861868765250081,-0.14313062043575353},
{0.010329099954303637,0.20535606511299065,-0.14502152255071865},
{0.004553469042876963,0.17189480354879602,-0.14694421811817251},
{0.012572424407025159,0.16940090358069732,-0.14116535397428934},
{0.006278398558409413,0.26874197080606643,-0.15238467059827734},
{0.017808105498219557,0.6143583542415698,-0.23729366588206893},
{0.01824297526361621,0.6841439047101731,-0.22045283576041316},
{0.00598848538147831,0.6990043799522344,-0.21685802014088273},
{0.005886099687023089,0.7036494572480451,-0.2069082861281395},
{0.02090015347076726,0.6857292663580008,-0.2067288417268048},
{0.04843867204676547,0.5933315658329238,-0.22630821973909973},
{0.0699062578136451,0.7821690463257547,-0.14751434477466527},
{0.044110451531689986,0.8080305950009917,-0.15345325392514422},
{0.07119038997094401,0.7983389807126906,-0.14223609278946053},
{0.08835615995447609,0.7850234517127511,-0.12128259098316134},
{0.06539212643232198,0.8096935542277748,-0.1315330156143573},
{0.050250359966546816,0.8117067803040101,-0.14302122940430925},
{0.08767664226653907,0.773089590715881,-0.12465970228395541},
{0.08955191709129785,0.7821076149090815,-0.11006004112671686},
{0.07522600294870799,0.7931453316434306,-0.1135109779019339},
{0.08088847072415785,0.7850406956191857,-0.10714150996266694},
{0.0820416569669693,0.7753517756912651,-0.105265157393756},
{0.19000252192131606,0.6511956493624066,-0.17746000491451333},
{0.18475929662105653,0.6447507393324884,-0.17995282713845998},
{0.20780793305915524,0.6263752015381566,-0.1787861690937465},
{0.1128403516032522,0.22333768741970803,-0.13632251062655734},
{0.1179267651293724,0.25652897407378683,-0.13820802402076168},
{0.13847719062276367,0.2224636369123062,-0.11118143391703958},
{0.09872998629109439,0.18674396247725975,-0.13412930127691128},
{0.12449399912056078,0.19554697671210447,-0.11418187363665366},
{0.08446011484441686,0.2712288654371761,-0.16154980686824796},
{0.05490082598311821,0.20699100299181772,-0.15897453721666108},
{0.07006899718062129,0.18266793409378956,-0.13979661890104586},
{0.03553699680125535,0.16526667701301048,-0.14892888397437556},
{0.021014933222972324,0.1650074795444161,-0.14720179897053878},
{0.035293426622867136,0.23460442478639126,-0.16517318270781065},
{0.01627232008139123,0.2630460929618997,-0.15445286162627284},
{0.05678580050524646,0.2976998784304597,-0.1680362100480243},
{0.04245826974642835,0.3093217324952796,-0.16650311899157635},
{0.03252308527973927,0.3241865187139495,-0.159713869705043},
{0.02459573816852469,0.31153380236758854,-0.14860933283326008},
{0.04581921488494003,0.34765116439478216,-0.17669857867101213},
{0.009636649336540692,0.3474226826345241,-0.16927076597432386},
{0.03470282282748333,0.3761337868480726,-0.18829726123656054},
{0.015272173508186536,0.3116200218997612,-0.15914751515308279},
{0.27261699990515853,-0.6679146943948683,-0.03559169231697749},
{0.270804234241225,-0.6646205693937906,-0.0384665748428649},
{0.2606238629799195,-0.68363844270281,-0.019747775536069944},
{0.25999661588336226,-0.7719547261236561,-0.05541194614728021},
{0.2523246941362096,-0.7684887009303087,-0.03402411344766044},
{0.2515578791719476,-0.7891037910728297,-0.02673425200244864},
{0.23269897312537183,-0.7769021106541476,-0.016751107920988422},
{0.23970915996309805,-0.6976582775061864,-0.00734725132131433},
{0.26643290396006314,-0.6211228154126037,-0.02086862945431658},
{0.2599535061172758,-0.6538420501280361,-0.027019854202771098},
{0.281048192407508,-0.6253879878947777,-0.060762406990679675},
{0.29678595138942776,-0.5631606571652742,-0.11995858229223248},
{0.2678566039850668,-0.7174262607451093,-0.08198157273048635},
{0.27510551115249654,-0.7186979988446583,-0.07386023167188295},
{0.27255341300018104,-0.7473207280377296,-0.08406323556038385},
{0.2649650164248209,-0.7920002284817602,-0.09481103911780175},
{0.27661435296552084,-0.8115839174706638,-0.054224810963675714},
{0.26354993835303453,-0.7957890380486795,-0.03194352836191511},
{0.25963503272031246,-0.8363138347861325,-0.02679245018666529},
{0.26033987739582526,-0.8352533345404068,-0.016676743574489367},
{0.23654490313235563,-0.825393053292293,-0.004839879551313553},
{0.21107565332850503,-0.7724671934680083,-0.011713192881715424},
{0.21679039169533468,-0.6894291620323669,-0.0003036544148711439},
{0.21665944578084723,-0.637557874860971,0.005713391186639423},
{0.24689286360932206,-0.6022973194347447,0.00030365441487114573},
{0.2502311761206384,-0.5377824767422812,0.003556286266090721},
{0.2813046955157221,-0.5311414172766699,-0.02928150030607934},
{0.2943550994542304,-0.567510971435469,-0.06841546821516947},
{0.29405548657992986,-0.5302415009096161,-0.07540463904192857},
{0.28807831751204915,-0.5264958011087832,-0.1224896644335808},
{0.2611573463352388,-0.5401664468068597,-0.1622341744048697},
{0.27209321624720867,-0.5720240250726399,-0.1582373602165835},
{0.26572159281963736,-0.6732247398325616,-0.12628494046541305},
{0.2583789219109697,-0.7333919626152109,-0.10675298319581318},
{0.2693886172973626,-0.7419530232878957,-0.10558955838355621},
{0.2587313442487261,-0.7710973806506126,-0.12148520688376746},
{0.2634534802514162,-0.7971793280049663,-0.10742118457015254},
{0.26783343248579533,-0.8385744031452885,-0.10598670710362727},
{0.2778715415190157,-0.850388634541269,-0.08199396678823621},
{0.27932487950820384,-0.8564261572816707,-0.06038789089780399},
{0.26958099462852314,-0.8312753808747835,-0.031965622117034395},
{0.26868323374977365,-0.8488259055206367,-0.03998134424872611},
{0.2744049774535924,-0.8557466395937336,-0.035763053637170965},
{0.2894944733279878,-0.8975410189424313,0.00014307053619927159},
{0.2743575567108973,-0.9032945560987387,0.03937349654690774},
{0.2424972840847366,-0.8639498892079013,0.030127529465525122},
{0.21191575489511397,-0.8652173163308416,0.038690206754438156},
{0.19940637852099016,-0.81969663657605,0.00036885793607683946},
{0.20265523826767717,-0.7768476845744636,-0.012394327185880691},
{0.1723329065466491,-0.7191247855289138,-0.031683792021244495},
{0.18444028435201712,-0.6996510264435306,-0.020927905382685394},
{0.19503882034436082,-0.649274570411181,-0.006032942327754929},
{0.20891854840795634,-0.6261898295439849,0.011777857530845039},
{0.21751517463766243,-0.5940030004397195,0.008083889449315849},
{0.21570240897372894,-0.5336180733383341,0.01770545036772631},
{0.24692034608520216,-0.49917121474698883,-0.004548888630230292},
{0.27194879853081916,-0.49184902097721217,-0.035650968245346304},
{0.24081276997491013,-0.7393163222196356,-0.12898684505487876},
{0.25269813248493317,-0.7503556555702129,-0.13224594337101128},
{0.2151123440504212,-0.7593736797634136,-0.15234641068087568},
{0.22398918375968893,-0.7954042833863584,-0.13871240828397266},
{0.24433052688756113,-0.7997788468999768,-0.13639525835682814},
{0.2565559176775907,-0.8180406826862557,-0.11834196606399214},
{0.25494846227464374,-0.8505368243621911,-0.10958583369976635},
{0.27040816326530615,-0.8662034522300682,-0.08934202641766467},
{0.27171223368942005,-0.8603195080313495,-0.056976830656216865},
{0.23977166912392334,-0.6288637127854944,-0.1653854983057862},
{0.20730031556348777,-0.6478314709914385,-0.16565547321590235},
{0.21594005155928025,-0.739083529482769,-0.14179044558254228},
{0.15584072665821713,-0.6139202512437169,-0.16433900873403862},
{0.17290303320314185,-0.692699576662097,-0.14320660139848082},
{0.1766632825500289,-0.7390075485200418,-0.12030292154884768},
{0.17651024288042214,-0.7412810498090238,-0.13428180207444196},
{0.1809882698326479,-0.7412260848572636,-0.1433079093487839},
{0.18537468853194006,-0.7711830613107094,-0.15347211444780703},
{0.2104947492304907,-0.7756287559383704,-0.1579738517713803},
{0.2095237017493943,-0.8407740789598477,-0.13909392971383738},
{0.23336286352310254,-0.8282544640162783,-0.13947437339954993},
{0.24905320176232726,-0.8309913952906893,-0.12632373925489082},
{0.2514695041514705,-0.859636757110956,-0.12082616633472147},
{0.26598779562522096,-0.8825442090651217,-0.11800032116775735},
{0.27859794107757174,-0.8691122836967488,-0.08951069337747773},
{0.2838417052499074,-0.8682107507134667,-0.05847705051602391},
{0.23786513971875192,-0.593675366217463,-0.18412100264693965},
{0.19493535690575345,-0.606953174172077,-0.18689080511799144},
{0.1849629902658148,-0.5710233396273592,-0.1935911405119716},
{0.14907626548718347,-0.5806853159514757,-0.17242963408430548},
{0.1614735564694826,-0.6292527784244243,-0.14869124138882422},
{0.22595283360492488,-0.5566925756360847,-0.18929956329806957},
{0.17105739634256745,-0.5370452997422036,-0.18699049645206628},
{0.20644889768328117,-0.5084699912918272,-0.1764776411198193},
{0.1599668701447626,-0.4899726684083012,-0.1671174331583077},
{0.1499508548666615,-0.5133182233603201,-0.16544800746661148},
{0.15691685419414914,-0.46391928127397986,-0.14411082874214326},
{0.18662918272505455,-0.46243846080891166,-0.15662236060457135},
{0.17676243501202762,-0.4432362932498728,-0.13879970556029766},
{0.15378924066458016,-0.4326377572575292,-0.13342283998517024},
{0.19206532422855074,-0.4223652388712139,-0.12598909969564506},
{0.1508227498857591,-0.37708759042273443,-0.1211807441607822},
{0.23827360475242063,-0.4937760275212747,-0.15483977177689837},
{0.2122202176180992,-0.44586706672529597,-0.14199413922730056},
{0.23455646517162,-0.43872808946138664,-0.11755413508876301},
{0.2091281696455515,-0.4089661846994818,-0.10999699309381547},
{0.20356323771587218,-0.387201680418682,-0.1035278338204737},
{0.2210523309450523,-0.40739806695808867,-0.0881080093634412},
{0.23089967926334035,-0.3886862729882828,-0.07299480311769828},
{0.20337086038471155,-0.3584296836605365,-0.10173069544674651},
{0.23451712751006615,-0.3533141710423079,-0.06564836010449808},
{0.23851232508212414,-0.41364898304061803,-0.04636805609442764},
{0.246818499262823,-0.4083179215919575,-0.02507829811265444},
{0.24588301733874793,-0.36509014252088673,-0.04040597544467724},
{0.24336109602269299,-0.46902563306691497,-0.1373161907348491},
{0.27523376270660355,-0.5296023986273851,-0.1403915336730383},
{0.2730448643335661,-0.5282002534854247,-0.12899870024055252},
{0.24087959011234406,-0.47540372295939926,-0.1311741268116879},
{0.25022363191157326,-0.4596578808963383,-0.11986912952760319},
{0.26134056284110607,-0.4624546269711941,-0.10473005742220844},
{0.2494465783778657,-0.43934024813981365,-0.08488555434848212},
{0.282178207151048,-0.5245456230654493,-0.1121805027460921},
{0.2794563642947674,-0.4839470008535734,-0.08135378676185304},
{0.28987383926954813,-0.5240089064776735,-0.10728431106282818},
{0.25597178034711987,-0.46946265832061596,-0.10245817274945468},
{0.25630103118560477,-0.4563556728141194,-0.04519223722442083},
{0.24375070053369893,-0.4698339411810352,-0.11573490295991655},
{0.23226733659243168,-0.4353111016269626,-0.01487798858453394},
{0.2352122724882095,-0.4365187139494581,-0.016030097083193227},
{0.2119276100807877,-0.4454074088443996,0.0072825866721847165},
{0.2097247010337722,-0.4426235956993697,0.014416714087409363},
{0.22060129501737324,-0.4795692041074986,0.006781435641430209},
{0.21492643318417357,-0.4742758637041636,0.021861770690532238},
{0.19700893665450972,-0.45217725873619413,0.01686373218488917},
{0.19457970133554056,-0.49751472198511854,0.023476770302544345},
{0.17337993499047274,-0.45458386142796786,0.019211058948294148},
{0.1687720398679117,-0.5014317831061449,0.007754099738754818},
{0.1444575929231008,-0.45089366545097126,0.012178778355448646},
{0.16115777743289963,-0.44809907486441986,0.012080164765525984},
{0.19081352439581664,-0.5709522085133166,0.0046302583137183915},
{0.1772404145435107,-0.5655311554279506,0.008060179077968323},
{0.14288139210056647,-0.5506022434322272,-0.004222332152125742},
{0.14095977427726475,-0.48195425191622915,-0.003211947009475525},
{0.11652084788287939,-0.4466931576179268,-0.02628213833061742},
{0.11797526361621963,-0.431897347024995,-0.02398923764689653},
{0.12573771587215368,-0.44104847262098756,-0.0230251955027892},
{0.15254606278506336,-0.63784671029375,-0.01842430571721718},
{0.12180610520507316,-0.5804439012613918,-0.04796581180000518},
{0.12522309303949716,-0.5345605605993983,-0.0350657531707233},
{0.10579459920850469,-0.4539258986230741,-0.05273967952199892},
{0.09874238034884422,-0.4222860246760301,-0.04022706991541865},
{0.08881743445160066,-0.3946073993602511,-0.06636505996568463},
{0.1006478320098635,-0.4035979410775718,-0.08339611193019668},
{0.10526111585318539,-0.3826600665614789,-0.09639424527732514},
{0.1406342955433124,-0.6471853633722184,-0.03979058353379375},
{0.15989573903072002,-0.6992016071320798,-0.04301357742082891},
{0.1257565763948165,-0.6171189958873283,-0.046224716122190326},
{0.13389731684815878,-0.6215776234448152,-0.06832709319469232},
{0.08558959071588076,-0.594153884621022,-0.08149928222239466},
{0.08849141684557219,-0.5484462162558307,-0.07261705379236613},
{0.08828664545666175,-0.5266477630342378,-0.11536846994818206},
{0.10179347404360985,-0.4441459093142961,-0.09233276643990931},
{0.15534334773199523,-0.6756205650828139,-0.050474261314158116},
{0.12347391428054111,-0.6508755593492149,-0.05338686488537114},
{0.12220271505306812,-0.6687445573920316,-0.08480041256046145},
{0.13215244906581136,-0.6441515135838873,-0.09160205590474466},
{0.09481292517006804,-0.6144596621918731,-0.0851215803178052},
{0.08554755869394652,-0.5842084615848874,-0.12824320158988817},
{0.1708235258615487,-0.7164929343093386,-0.05094739099695646},
{0.1650942379486649,-0.7262610684324428,-0.05820599786175561},
{0.14591739737720183,-0.7070804557564472,-0.05484289723493961},
{0.14882191786727367,-0.7175555900433684,-0.07452088883715717},
{0.14757550675530035,-0.7171449695213955,-0.09747791702232225},
{0.12651153617340472,-0.6710498521335024,-0.12047374399696509},
{0.13483064328392952,-0.6390548614883217,-0.12480088676788842},
{0.09308637903830734,-0.6055434848210514,-0.1319937512394058},
{0.1053338635834562,-0.5675282153419036,-0.1617944547907883},
{0.10757072157126477,-0.5296244923825044,-0.15369736297560851},
{0.130455002026159,-0.41583410930912285,-0.11659925376994905},
{0.1751759956200478,-0.7458291301311399,-0.023667531017476703},
{0.1565849089952838,-0.7493716751592907,-0.0625094302613314},
{0.1669910676564669,-0.7384002396902996,-0.11422660001896831},
{0.16772555029616412,-0.732087892191097,-0.09387825155410708},
{0.15572325254563169,-0.6899771949337402,-0.11886359423363771},
{0.1427725399411983,-0.6179671805350785,-0.14998237888311222},
{0.11514995732133158,-0.5928465809644518,-0.16242385737564988},
{0.1672653535431917,-0.7633672607192433,-0.13562682677633794},
{0.1586412448376055,-0.6918330703637602,-0.12932202348620056},
{-0.21128150246156768,-0.3345468732486658,-0.09508316951622221},
{-0.203333139339386,-0.3584313002767648,-0.1017285399584422},
{-0.23447832872058838,-0.3533136321702319,-0.06564620461619376},
{-0.21575952941379342,-0.3036598035919057,-0.07804726770302545},
{-0.23036188493141238,-0.314255106351793,-0.05293367346938776},
{-0.2458442185492702,-0.36508960364881055,-0.040403819956372926},
{-0.24432190493434386,-0.3509501392445445,-0.0176838954846831},
{-0.2505571937266669,-0.38225321814403834,-0.014664595242406216},
{-0.24678023934542134,-0.4083173827198813,-0.025076142624350123},
{-0.24417748721795438,-0.42470825465801026,0.023020345654104487},
{-0.2351740125708078,-0.4365170973332299,-0.016027941594888906},
{-0.2385511238716019,-0.43565274652319735,0.01740368200512144},
{-0.2239956502246019,-0.4474707500237104,0.006029709095298453},
{-0.2322285378029539,-0.4353100238828105,-0.0148763719683057},
{-0.21188881129130996,-0.4454063311002474,0.007284742160489039},
{-0.22102323185294398,-0.4444325892587707,0.026208312856194443},
{-0.20599947837183039,-0.4439379046929292,0.023328580481622306},
{-0.21669770569824892,-0.42118510902459844,0.05509347275031687},
{-0.20101706715639364,-0.4186976755214126,0.03349009122026504},
{-0.18616952484415822,-0.41559377236319117,0.03055162178940017},
{-0.1853757662760922,-0.4192942069096333,0.06699661803885053},
{-0.16140350309959223,-0.4276704344602226,0.06369333221247943},
{-0.17157633015183263,-0.4226540743039928,0.034147515153082786},
{-0.15525605045567026,-0.44690816757628277,0.03866272427855807},
{-0.16783116922307584,-0.4419710216152368,0.029484655078761544},
{-0.1611189786434219,-0.44809799712026765,0.012082320253830306},
{-0.13949027012579432,-0.45332559513032084,0.013230117775880951},
{-0.14441879413362305,-0.45089366545097126,0.012180933843752965},
{-0.11203904882612109,-0.44336185044359955,-0.012798481242940776},
{-0.1256999948268281,-0.44104739487683536,-0.023023040014484884},
{-0.11793646482674187,-0.431896808152919,-0.02398708215859221},
{-0.09491369424829503,-0.41220642249295153,-0.02964901106196598},
{-0.08508628419682196,-0.4046056318598415,-0.048861417190450326},
{-0.0887786356621229,-0.39460686048817506,-0.06636344334945639},
{-0.08535410361863378,-0.3417537483941612,-0.07596560487312796},
{-0.10522285593578372,-0.3826595276894028,-0.09639208978902081},
{-0.10833591991929854,-0.3105983204435133,-0.10666353043118389},
{-0.09196714173628895,-0.3251101454523508,-0.08661371709647105},
{-0.08258484001965807,-0.32017192174715264,-0.04114530793305916},
{-0.06718764818982094,-0.28061817249079607,-0.0418867959097454},
{-0.08824138020227104,-0.3407239638567721,-0.017094369433451457},
{-0.07214365467352976,-0.2887330470844865,0.01904454747678539},
{-0.06593962046161939,-0.2515713509738496,0.029053018545821374},
{-0.055448320012415626,-0.2408779734961158,-0.006597141391410809},
{-0.2457024951932611,-0.3832080994628524,0.022605953027598876},
{-0.23773527154841662,-0.33494994956157365,0.00868042083753654},
{-0.2192104661890105,-0.325091823801764,0.03836903899709441},
{-0.23555661174482473,-0.3676023641395722,0.04590408723692266},
{-0.23841694472465796,-0.40157178207151045,0.0536563009234112},
{-0.2302724321667831,-0.31626617693972386,0.02827542614003777},
{-0.22633704939517,-0.30075636084598606,0.04233028762835933},
{-0.19445037203728135,-0.2899579033134166,0.0730540790460671},
{-0.1992646551649811,-0.3203691489269979,0.06484005199037791},
{-0.22198565738082307,-0.38985616426545266,0.07205878232154712},
{-0.1823704767077934,-0.38911144305630996,0.08375607847701819},
{-0.14838543148564878,-0.39549546054163115,0.07693449686592001},
{-0.14293959028478315,-0.42691170257710187,0.056226181854237264},
{-0.12484857694662152,-0.44593334799065387,0.015840952984489107},
{-0.11177769586922225,-0.42058965538052995,0.024087312364743114},
{-0.09726317650000432,-0.42005724976936276,-0.016487599475785247},
{-0.08576741850098724,-0.38288208185682393,-0.020472019606321615},
{-0.08684031280446274,-0.3433590483088039,-0.04136732322840417},
{-0.0931289499323177,-0.35031534793892216,0.002638587120526287},
{-0.07511283981273119,-0.2978383685540123,0.05045971176810395},
{-0.07289592009173759,-0.20563412310424797,0.06987958364587915},
{-0.05547849684867611,-0.23149567177948488,0.014639268254830452},
{-0.058824353569057554,-0.2034770181836993,0.044846281351577394},
{-0.057508966831345994,-0.1787266237293397,0.06294645551503239},
{-0.08401392876542253,-0.14211080503177193,0.08757829811265445},
{-0.0580316727451437,-0.14216199787899952,0.08143838967779761},
{-0.05988593155893538,-0.06497126734090337,0.08932532138330619},
{-0.10616264883646744,-0.01551143270996615,0.10496015579869464},
{-0.06398728692998114,-0.012422079097798855,0.08404491390979714},
{-0.110854608002897,0.003453631135597517,0.10207611244751387},
{-0.08877055258098171,0.039707866670115485,0.08229950725537365},
{-0.10201063949027014,0.060561677142339884,0.08322960045868791},
{-0.11816979643568457,0.04259029340506804,0.09946904934343828},
{-0.1352364139572179,0.08370461619375251,0.09524267565074193},
{-0.09461192588569016,0.0651453230214773,0.09912471008682308},
{-0.10526273246941364,0.10109024598432523,0.10403922342067373},
{-0.14794463412741526,0.11086322995611428,0.08406485217661211},
{-0.12358114982368107,0.1343526637524465,0.0956473685798781},
{-0.11283280739418709,0.12999857737771914,0.10238542501918386},
{-0.10185652207651123,0.1036347999275756,0.10192145616167889},
{-0.19078011432709968,-0.3687873438348724,0.08046464783632085},
{-0.17152944828121366,-0.35690359794107757,0.08028735892329049},
{-0.1467882146521473,-0.37211272341636276,0.07338117439624774},
{-0.12431186035884573,-0.4061468059974307,0.04873532112464759},
{-0.24345485976393094,-0.24994665166446806,0.02500177827785107},
{-0.2524152246449911,-0.2158349715044446,-0.005030640266245914},
{-0.2218002853866515,-0.2733240000689756,0.05482295896812465},
{-0.19398101445901558,-0.2560967986687705,0.07957227567833218},
{-0.1845927851495478,-0.24654582999232647,0.09055125535638844},
{-0.17792478208013246,-0.2958488528491245,0.07747875766276092},
{-0.17869105817231837,-0.32136121241906135,0.07274961632308184},
{-0.11896355500375057,-0.37477690696050286,0.04539862522955951},
{-0.09540622332583225,-0.38629421984256324,0.009641768621263461},
{-0.14475235594871663,-0.3376529318951916,0.06083461584887442},
{-0.11093705543053725,-0.35206344895372593,0.03167894217255978},
{-0.10388321995464854,-0.3392318270781063,0.0524341390548615},
{-0.09382247829423279,-0.30846007604562736,0.07524782726778925},
{-0.08887239940336085,-0.24064086978264057,0.09857883267375392},
{-0.07526102963365322,-0.20603935490546027,0.09010722476569842},
{-0.08722452859470786,-0.13630014743540006,0.10848006819964996},
{-0.09776163317037843,-0.07974983402740056,0.10468209780743731},
{-0.10943575782657805,-0.11465581162756606,0.11670271720855643},
{-0.12015607890811586,-0.08276967314175349,0.1288580546286956},
{-0.1339732978108861,-0.05310961520222792,0.12525569480010001},
{-0.12499838338377178,0.013845779122802538,0.10059636972659787},
{-0.13806172025210595,0.041777135442263164,0.11490234560237278},
{-0.16564496521041877,0.07022904218721707,0.10346748014795272},
{-0.17588461240009315,0.0821979298690325,0.07905010863661055},
{-0.173381551606701,0.12762754024296666,0.04854348266556306},
{-0.15760876593983605,0.15242643318417354,0.07013931998654976},
{-0.12628305441314677,0.13997848822672293,0.09475176318943294},
{-0.13381001957183383,-0.3318956226343516,0.06915749506393179},
{-0.12449831009716944,-0.3018265607890812,0.09108527758378383},
{-0.10739289378615834,-0.19603519481303297,0.11672211660329533},
{-0.0896947181914591,-0.180895044963486,0.1102486463533449},
{-0.2553413000181062,-0.18881538673771156,0.0630057314434012},
{-0.21677799763758485,-0.20004009208246032,0.08538832199546487},
{-0.20516476552598228,-0.1874822172214893,0.10891224360466621},
{-0.18515806195735585,-0.1911158316304976,0.10965804255796109},
{-0.17057833906693226,-0.223861471077658,0.11462752084357192},
{-0.16194021968736802,-0.2782406688911306,0.08996765689799369},
{-0.1521219704611883,-0.3240205461145168,0.06969313390755542},
{-0.13560554132933275,-0.22448710155798698,0.10662365389755396},
{-0.11833469129096508,-0.16908943552072292,0.11645429718148351},
{-0.1627124233723908,-0.17655443039066068,0.12979676978522717},
{-0.16759568212582882,-0.11421016442064787,0.12380990101997708},
{-0.18310064837088197,-0.11194744057318742,0.118630262624695},
{-0.17717197778984853,-0.06617726304717066,0.12203755076174959},
{-0.15346753403516034,-0.027095026857384286,0.12452175103247892},
{-0.14335829388789736,-0.0488374373830648,0.12087951467025342},
{-0.1468318632903098,-0.10881767155531409,0.13391429131855534},
{-0.13187924092323877,-0.1551838415974755,0.1340888858712053},
{-0.14532463809351373,-0.20918475121353997,0.1233103666054508},
{-0.256006268159989,-0.1261526473707354,0.0626694752679272},
{-0.2628898200598364,-0.11249762896286519,0.02361957140270557},
{-0.25330813567505583,-0.09406065975186015,0.04482903744514283},
{-0.2446155902158075,-0.0965739591146978,0.06448924626884975},
{-0.22715451833458353,-0.13280286766164004,0.08826158790512403},
{-0.20877359181949082,-0.142474543683126,0.1149314446944811},
{-0.2075325694282783,-0.08188969504151467,0.11092978065751016},
{-0.18391488407783904,-0.05632344826396965,0.11389303820387471},
{-0.1844763887811145,0.019502858177491533,0.09572119405430107},
{-0.17279579766000192,0.009768134123104252,0.11670756705724117},
{-0.23794758714639216,-0.08428713690799518,0.0683524201822681},
{-0.21286740298147147,-0.03393816335152568,0.0837830220808222},
{-0.2648620918582896,-0.17406106929463802,0.02744825750325479},
{-0.24980331169223077,-0.1438071743272721,-0.011354304079046067},
{-0.23917136563117014,-0.07314326237465837,-0.012827041462973022},
{-0.25269867135700924,-0.06388382349137378,0.01930805592198857},
{-0.2351794012915686,-0.022412767388324192,0.018570878921910974},
{-0.2383048593328333,-0.03780403162532443,0.03183413733047085},
{-0.2218951268720416,-0.007569536052697336,0.04929898131622738},
{-0.229336950242708,-0.03358035229300848,0.04662294258641353},
{-0.22304292439409226,-0.04019339041066357,0.0642656143572765},
{-0.21920615521240183,-0.027795021684212322,0.07248772449410691},
{-0.22553413000181063,0.00019722717984536987,0.060792583826940166},
{-0.203777169930076,0.056066406283679524,0.07448424553598373},
{-0.1918012769112715,0.014341002560720106,0.08441889113059674},
{-0.22679401291568596,-0.06774753627686815,-0.02063529784537389},
{-0.22170382728503318,-0.026818046610279037,-0.007297136218238879},
{-0.219288063767966,0.027319736513109753,-0.008909980341946665},
{-0.21158596518455292,-0.062243496891785884,-0.04976348904580844},
{-0.20542719622703332,0.031086452324909666,-0.03361834277437211},
{-0.21106810911943993,0.028671227679918657,-0.0015748536423441358},
{-0.21215986394557826,0.015107817524982085,0.011989095384668446},
{-0.23227326418526856,-0.0830913797711733,-0.015372134278299407},
{-0.20485383633808407,-0.06619827905813784,-0.05100990015778174},
{-0.19928189907141566,-0.01866976194787165,-0.04811831259753585},
{-0.1985032289214799,0.04310491623772446,-0.033323040876680206},
{-0.20327601889932148,0.04664746126587518,-0.0009966439047101715},
{-0.2004000586292819,0.040750584137330514,0.027158344326323688},
{-0.25254347619909817,-0.18775811972444237,-0.008634077838993646},
{-0.2292992291973824,-0.14077063017856062,-0.042381480475586944},
{-0.21674997628962867,-0.11036261779743588,-0.04588468784218377},
{-0.24721888121535057,-0.25616900752696514,-0.007503524223377563},
{-0.24004110516196345,-0.1942676944034902,-0.03643233275566247},
{-0.21723118905356822,-0.1666203236681238,-0.04685681306743229},
{-0.20054663183397572,-0.14107670951777418,-0.06323690756403956},
{-0.17582803083210471,-0.11634571445815332,-0.08508278152832743},
{-0.1943889406206082,-0.07820219342489847,-0.06251966883077693},
{-0.23043624927791145,-0.3276449996982317,0.008525764551701544},
{-0.24048405800850128,-0.30496171852771525,0.0016497568609192736},
{-0.23846652095565732,-0.29141878551166983,-0.026739101851133356},
{-0.23164817257701564,-0.22248195856289282,-0.03867026848762319},
{-0.17864525404585158,-0.03254517903485855,-0.08276185949665037},
{-0.1775330220808222,0.03295364406852729,-0.0857773876343947},
{-0.16195746359380256,0.08694862609175476,-0.11127196442582103},
{-0.18479701766638218,0.11620614659044858,-0.06843486760990836},
{-0.20111945285084887,0.11704247605252503,-0.02389116292904995},
{-0.2073240259348353,0.112972914133968,0.015867896588293115},
{-0.18801246734435223,0.086599975858531,0.016522087288654373},
{-0.20477785537535675,0.08869079951372191,0.04055578188182752},
{-0.1946195778691705,0.09662353534569716,0.06809861143443437},
{-0.22677784675340357,-0.2949742634696464,-0.031551229490528784},
{-0.18195823956959212,-0.08271740255037371,-0.06722725528741282},
{-0.17155746962916982,-0.06398620918582895,-0.08416292689445869},
{-0.1691761939249718,-0.11091657829164614,-0.08343598846382659},
{-0.14071458748264834,-0.11501362268608327,-0.09792302535716442},
{-0.1363745117818991,-0.10824431166636488,-0.11168366269194625},
{-0.15834863730029403,-0.0927635946647354,-0.1103273216764526},
{-0.11983221679039172,-0.10894700085357333,-0.11108389807126907},
{-0.15796549925420109,-0.44927112162989413,0.024454823120629753},
{-0.173341136200995,-0.45458386142796786,0.019213214436598472},
{-0.16587937456351365,-0.4252131777932973,0.0574472659786348},
{-0.16449716768836817,-0.45746305493046396,0.030566171335454334},
{-0.17089735133597167,-0.4308713345921385,0.0606724153539743},
{-0.20968590224429445,-0.4426235956993697,0.014418330703637605},
{-0.2115789598475639,-0.43606175042894224,0.027574892441133623},
{-0.20963740375744724,-0.4508521723011132,0.024643967219333866},
{-0.19696906012087984,-0.452176719864118,0.016865887673193487},
{-0.1984105429243941,-0.45881670158557725,0.02675957899002441},
{-0.17805465025046777,-0.46167757343748655,0.03006178707224335},
{-0.20373675452436998,-0.425695468301389,0.056843190381349},
{-0.18654350206495784,-0.4202129837993499,0.060270416785218536},
{-0.2064300371606184,-0.41918481587818907,0.05225631126975505},
{-0.1920259865669969,-0.4223636222549857,-0.12598640533526465},
{-0.2035244389263944,-0.38720060267452994,-0.10352567833216937},
{-0.1671543458955192,-0.35343918936395846,-0.10916228024796738},
{-0.15078502884043354,-0.37709082365519087,-0.12117966641663004},
{-0.14294713449384827,-0.32612969142029435,-0.11441682186182459},
{-0.19368679030547584,-0.30487657673969465,-0.10412867618530303},
{-0.15808943983169949,-0.2830759680297975,-0.12176703697955735},
{-0.13052505539604944,-0.2785914746126588,-0.1191265638067648},
{-0.1270687299000716,-0.2256823198227326,-0.13595176663821423},
{-0.1601921186725641,-0.2039700861333126,-0.13001716846434394},
{-0.2029128191200435,-0.20463397653104337,-0.10532712768250521},
{-0.21146364122328276,-0.2625352422337756,-0.09238126492675651},
{-0.18324506608727142,-0.1601603252200753,-0.1091347977720873},
{-0.20319303259960517,-0.1560950742781269,-0.0781324094910461},
{-0.2240716311873292,-0.20189003991964335,-0.07387424234586104},
{-0.22932509505703425,-0.2539262219463197,-0.06541933947216402},
{-0.22501842942500197,-0.2920093893070536,-0.05608499737030428},
{-0.23771263892122124,-0.22554436857125618,-0.043713572247656984},
{-0.16434035591422883,-0.1333751498064372,-0.10517408801289846},
{-0.1364720476276696,-0.1359994568169473,-0.12708893760292458},
{-0.09862813946871526,-0.1400560858056784,-0.1330100639748929},
{-0.0956325495977859,-0.10290624488071527,-0.11991655027029824},
{-0.22056357397204765,-0.4795708207237268,0.006782513385582371},
{-0.24688046955157225,-0.4991669037703802,-0.004547272014002051},
{-0.25626223239612705,-0.4563556728141194,-0.04519008173611651},
{-0.23847352629264637,-0.41364898304061803,-0.04636643947819939},
{-0.21566361018425118,-0.5336153789779536,0.017706528111878467},
{-0.2501923773311606,-0.5377824767422812,0.0035573640102428824},
{-0.2812658967262444,-0.5311414172766699,-0.02928042256192718},
{-0.27190999974134145,-0.49184902097721217,-0.03564881275704199},
{-0.2494067018442358,-0.43934024813981365,-0.0848833988601778},
{-0.2308608804738626,-0.3886862729882828,-0.07299264762939396},
{-0.22101353215557457,-0.40739806695808867,-0.08810585387513688},
{-0.20908937085607376,-0.4089651069553297,-0.10999591534966331},
{-0.23451766638214225,-0.43872808946138664,-0.1175519796004587},
{-0.21218141882862146,-0.44586706672529597,-0.14199198373899624},
{-0.17672363622254986,-0.4432362932498728,-0.13879755007199335},
{-0.15375044187510242,-0.43263667951337703,-0.13342068449686592},
{-0.2613012251795522,-0.46245408809911803,-0.1047284408059802},
{-0.2501848331220955,-0.4596578808963383,-0.11986805178345103},
{-0.24332229723321525,-0.46902563306691497,-0.13731403524654479},
{-0.23823480596294289,-0.4937760275212747,-0.15483761628859402},
{-0.1865903839355768,-0.46243846080891166,-0.15662020511626704},
{-0.1568780554046714,-0.46391928127397986,-0.14410867325383894},
{-0.2943163006647527,-0.567510971435469,-0.06841331272686516},
{-0.2940166877904521,-0.5302404231654639,-0.07540248355362425},
{-0.2967466137278739,-0.5631579628048939,-0.11995696567600425},
{-0.28100939361803023,-0.6253879878947777,-0.06076132924652751},
{-0.27076543545174725,-0.6646200305217144,-0.03846495822663667},
{-0.26781780519558906,-0.7174273384892614,-0.08198157273048635},
{-0.27205387858565483,-0.5720240250726399,-0.15823574360035522},
{-0.2611185475457611,-0.5401653690627075,-0.16223309666071753},
{-0.28803951872257144,-0.5264958011087832,-0.12248750894527648},
{-0.28983504048007036,-0.5240089064776735,-0.10728215557452386},
{-0.2794175655052896,-0.4839470008535734,-0.08135163127354872},
{-0.26639518291473757,-0.6211136545873103,-0.02086755171016442},
{-0.259914168455722,-0.6538409723838838,-0.027018776458618936},
{-0.26058506419044175,-0.6836400593190383,-0.019746697791917782},
{-0.2725776622436047,-0.6679152332669444,-0.035590614572825335},
{-0.2750667123630188,-0.7186969211005061,-0.07385807618357863},
{-0.26934766301958046,-0.7419745781709389,-0.10560303018545822},
{-0.25834012312149196,-0.7333919626152109,-0.10675082770750886},
{-0.2656827940301596,-0.6732247398325616,-0.1262827849771087},
{-0.24077989877826925,-0.7393308717656898,-0.1289771453575093},
{-0.2397328703344456,-0.6288637127854944,-0.16538442056163402},
{-0.23782634092927415,-0.593675366217463,-0.18411884715863533},
{-0.2259140348154471,-0.5566925756360847,-0.18929740780976526},
{-0.20641009889380343,-0.5084689135476751,-0.176475485631515},
{-0.27519496391712583,-0.5296023986273851,-0.140389378184734},
{-0.2821383306174181,-0.5245450841933732,-0.11217834725778779},
{-0.2559329815576421,-0.4694621194485399,-0.10245655613322643},
{-0.15992807135528486,-0.4899726684083012,-0.16711635541415554},
{-0.14991259494925985,-0.5133155289999397,-0.1654453131062311},
{-0.1710185975530897,-0.5370447608701275,-0.18698834096376196},
{-0.18492419147633707,-0.5710233396273592,-0.19358898502366725},
{-0.1490380055697818,-0.5806853159514757,-0.17242747859600116},
{-0.15580138899666332,-0.6139170180112603,-0.16433846986196254},
{-0.16143475768000487,-0.6292517006802723,-0.14869016364467208},
{-0.17662448376055115,-0.7390075485200418,-0.12030076606054337},
{-0.1728642344136641,-0.692698498917945,-0.1432044459101765},
{-0.1764714440909444,-0.7412799720648716,-0.1342807243302898},
{-0.20726259451816215,-0.6478303932472863,-0.1656538565996741},
{-0.21594436253588892,-0.7390317977634654,-0.14173278627040173},
{-0.18094947104317013,-0.7412250071131116,-0.1433068316046317},
{-0.1668019235577628,-0.7615329401722667,-0.13583159816524834},
{-0.1844198072131261,-0.7726299328349845,-0.15477241276738835},
{-0.17191689730391524,-0.7871945673072778,-0.13514076416371365},
{-0.19194084477897624,-0.8200878577032842,-0.1441776488795772},
{-0.16932115051343732,-0.7964787943060622,-0.12472167257270464},
{-0.17260395920091742,-0.8258128346395593,-0.12971486122966297},
{-0.15762008225343374,-0.8351924419958098,-0.11056011441331921},
{-0.1648420458170594,-0.8526556693653381,-0.12705983851081626},
{-0.16010104929170657,-0.8520510548959762,-0.10438194606106069},
{-0.1615662424665684,-0.8747079313347647,-0.12561188924238897},
{-0.18240819775311903,-0.8548725890863317,-0.14314570885388378},
{-0.16459685902244298,-0.8921102661596959,-0.13743851469611928},
{-0.19268610486019505,-0.8734642145831717,-0.16185588620746144},
{-0.1897115310002328,-0.9066749006319893,-0.16178475509341889},
{-0.17643372304561877,-0.9201149090815033,-0.14898708215859222},
{-0.21240505074019472,-0.932185643585698,-0.1597386578205427},
{-0.18400810894700087,-0.9320202098583414,-0.15459189062190148},
{-0.18507938663424814,-0.9388358638766027,-0.1698516700723382},
{-0.18981714992714452,-0.9662730745022978,-0.1632418651871395},
{-0.1838615357423071,-0.9734551615322936,-0.15481498366139868},
{-0.21436169524844162,-0.9734088185337507,-0.16085681737840893},
{-0.2075298750678979,-0.9665047894950123,-0.1665828720588362},
{-0.22440142089789025,-0.9523270651733445,-0.17027145141960462},
{-0.24350120276247383,-0.9641811731029548,-0.16202670865557883},
{-0.2539256830742437,-0.98205448212238,-0.15640896726244366},
{-0.22221629462938539,-0.9962623832803084,-0.14452683798487712},
{-0.2568549916798152,-0.9864419785658244,-0.14024064949173587},
{-0.26815406137106307,-0.9951253631997793,-0.1300769832647888},
{-0.2349627747169844,-0.999998922255848,-0.11154571144046974},
{-0.2670493736150988,-0.9926400851848978,-0.11196603165981223},
{-0.27699695213953773,-0.9962817826750473,-0.1002110761922006},
{-0.2736074467809938,-0.9955246674081547,-0.08139474103963512},
{-0.27512006069855066,-0.9518280696308943,-0.09581118569100645},
{-0.2809889164791392,-0.9609921281567126,-0.07549085857410139},
{-0.2865872584775355,-0.9912023744859161,-0.0682985329746601},
{-0.279413793400757,-0.986748596777114,-0.057204773544398756},
{-0.2869822517093023,-0.9543834010156661,-0.05923362691084038},
{-0.28943735288792327,-0.9812569514497815,-0.049656253502668495},
{-0.2900559780312632,-0.9777930817447386,-0.03787435443125286},
{-0.29996475776622444,-0.9661609891104732,-0.022640440840468},
{-0.2860273703904883,-0.9879238767750447,-0.016388447013786504},
{-0.3085037246837899,-0.9782856108222757,0.003680226843589148},
{-0.31698611003336696,-0.9875601381236907,0.019568870006811345},
{-0.29367612063836945,-0.9976289628652475,0.01565719760654579},
{-0.3139872869299812,-0.9887882275850772,0.03689091289240665},
{-0.32353448350189257,-0.9941036617435315,0.05187317322366209},
{-0.2967757128199823,-0.9994622056680721,0.0536832445272152},
{-0.31574131553762197,-0.9925824258727574,0.0671356470344792},
{-0.32380553615616087,-0.9957353663899021,0.0811139886879974},
{-0.29486810567065863,-0.9999698231637396,0.08473305355095144},
{-0.31513670106826003,-0.9921109128061872,0.09280697386685981},
{-0.319461688350879,-0.9938514696119259,0.10660802660734764},
{-0.28993203745376483,-0.999878214910806,0.11230498219566662},
{-0.31025829216350675,-0.9893712871713959,0.11860116353258668},
{-0.313078209737634,-0.9869388186199703,0.135573478440806},
{-0.2776608425372684,-0.9965043368424683,0.13872911331833115},
{-0.3020760585603063,-0.9848878714984093,0.14100315347938924},
{-0.3008991619461473,-0.9795492658406836,0.15531667356422926},
{-0.2842722640386954,-0.9772353491459956,0.16280699542174284},
{-0.25682373709940254,-0.9921206125035567,0.14740603148737316},
{-0.2732313140718899,-0.9739541570747438,0.17070362682462087},
{-0.2664824801910625,-0.9684641283636396,0.16432984790874525},
{-0.24363538190941778,-0.9677819163153221,0.16768486545442005},
{-0.23499726252985353,-0.9761646103308245,0.17553299837045086},
{-0.21833911004198894,-0.9959611537897797,0.14029507557141996},
{-0.21763857634308478,-0.979995451919678,0.1622066919289896},
{-0.20904195011337873,-0.9774018606175044,0.16669549632273697},
{-0.19942631678780512,-0.9804378658941397,0.15776638602208948},
{-0.2015058241293983,-0.9844815619530449,0.14709402455532278},
{-0.1859184104567049,-0.9871764612055216,0.13940970875042033},
{-0.20358102049438284,-0.9986625195071692,0.11440550554822691},
{-0.18595882586241091,-0.9885850728123949,0.1231804984351155},
{-0.17425236888164647,-0.9921383952820673,0.11189490054576966},
{-0.19617907365734635,-0.9988144814326239,0.08677106774268645},
{-0.17673010268746284,-0.9889703663467923,0.09739546959468198},
{-0.16605612460446792,-0.992984424441513,0.08565021382443981},
{-0.19044870800031044,-0.9992703672089877,0.0557212587189502},
{-0.17154238121103957,-0.9891250226326274,0.07190197054740782},
{-0.16371580317805198,-0.9906672745143685,0.05845334014467638},
{-0.19250504384263215,-0.9949421466939121,0.020200966952053322},
{-0.1713306044851401,-0.9835714070165456,0.04600970616383436},
{-0.16463619668399682,-0.9808312425096781,0.028619765396652962},
{-0.20286970935395707,-0.9794732848779564,-0.010441454782166352},
{-0.17810099324901066,-0.9672290335652639,0.010919434313649418},
{-0.17434505487873225,-0.9501467887535243,-0.01217015640223136},
{-0.17148094979436643,-0.9372655906469052,0.023827037151996418},
{-0.15415297931593427,-0.9255990101997708,-0.0573497301328643},
{-0.1698831940887889,-0.9609253080192788,-0.04905056128915446},
{-0.2730060655440884,-0.5282002534854247,-0.12899762249640034},
{-0.24371190174422117,-0.4698339411810352,-0.11573382521576439},
{-0.2408413301949424,-0.4754031840873232,-0.13117197132338362},
{-0.19489655811627568,-0.606953174172077,-0.18688972737383927},
{-0.21444198718777754,-0.7597368795426916,-0.15327973711664644},
{-0.20918960106222467,-0.7769069605028324,-0.15948484907270896},
{-0.20879245234215363,-0.8224572782218085,-0.14536532293525778},
{-0.21531118784649475,-0.8416184915030651,-0.1379525986566997},
{-0.1909040549045981,-0.8406307389876103,-0.1332213018287163},
{-0.25233601044980736,-0.7506757455834044,-0.13308227283308763},
{-0.25822803772966735,-0.771933171240613,-0.12255109585025392},
{-0.22280582068061702,-0.7965563918850177,-0.1403236357914522},
{-0.23473483182880253,-0.8256393178310616,-0.1376680742005294},
{-0.2194534974953226,-0.8536078563237717,-0.14817769630031988},
{-0.24685406481984432,-0.6022913918419079,0.0003058099031754665},
{-0.2396703611736203,-0.6976582775061864,-0.007346173577162171},
{-0.21488709552261973,-0.4742747859600114,0.021863387306760473},
{-0.19454090254606282,-0.49751472198511854,0.02347892579084866},
{-0.2088797496184786,-0.6261898295439849,0.01177947414707328},
{-0.2174763758481847,-0.5940030004397195,0.008084967193468011},
{-0.21662118586344553,-0.6375584137330472,0.005714468930791584},
{-0.216752131777933,-0.6894226955674538,-0.00030096005449074245},
{-0.2110368545390273,-0.7724671934680083,-0.011712115137563263},
{-0.2326601743358941,-0.7769021106541476,-0.016750030176836263},
{-0.2515190803824699,-0.7891037910728297,-0.026733174258296476},
{-0.2522858953467319,-0.7684881620582327,-0.03402249683143219},
{-0.2599572782218084,-0.7719525706353518,-0.05540871291482373},
{-0.2725146142107033,-0.7473196502935776,-0.0840621578162317},
{-0.19499948268280698,-0.6492724149228767,-0.006030786839450608},
{-0.18440148556253938,-0.6996510264435306,-0.020926827638533232},
{-0.17229410775717136,-0.7191237077847616,-0.03168163653294018},
{-0.20261643947819943,-0.7768476845744636,-0.012393249441728529},
{-0.1993675797315124,-0.8196977143202022,0.0003710134243811602},
{-0.23650718208703003,-0.8253919755481408,-0.004838262935085313},
{-0.2603005397342714,-0.8352527956683309,-0.016676204702413284},
{-0.2595962339308347,-0.8363143736582086,-0.02679083357043705},
{-0.26351113956355676,-0.7957890380486795,-0.03194137287361079},
{-0.2765755541760431,-0.8115860729589681,-0.054224272091599635},
{-0.26492621763534313,-0.7920002284817602,-0.09481103911780175},
{-0.2634211479268514,-0.7971410680875646,-0.10738184690859869},
{-0.2431827293655105,-0.8008921566091582,-0.13823712311287},
{-0.24901440297284952,-0.8309913952906893,-0.12632266151073865},
{-0.2458598458394765,-0.8451583421708354,-0.13419881577472562},
{-0.23631642137209766,-0.8650718208703,-0.13724128751627396},
{-0.23761618081960292,-0.8953117051636879,-0.15173802410698123},
{-0.20525529603476375,-0.8726742281196382,-0.16327473638378037},
{-0.21642072545114374,-0.9140822361897866,-0.16441121759223337},
{-0.2409388660407129,-0.9289335506065545,-0.15336272341636276},
{-0.2371495176017175,-0.945099712888958,-0.166870629747463},
{-0.26565261719389915,-0.9490135407775278,-0.1197931485648759},
{-0.17078472707207096,-0.7164918565651862,-0.0509463132528043},
{-0.15985747911331835,-0.6992010682600037,-0.04301249967667676},
{-0.16505543915918713,-0.7262610684324428,-0.05820438124552737},
{-0.17513719683057005,-0.7458291301311399,-0.02366537552917238},
{-0.17568361311571526,-0.7935128423993173,-0.031273171499271446},
{-0.173852525801195,-0.8203799263685196,-0.023597477647586285},
{-0.1772113154514024,-0.8456336273419381,-0.008518220342636421},
{-0.21187587836148405,-0.8652162385866894,0.038691284498590314},
{-0.24245848529525882,-0.8639552779286621,0.030133457058362},
{-0.27431929679349565,-0.9032934783545865,0.03937511316313598},
{-0.28945567453851,-0.8975404800703553,0.00014307053619927159},
{-0.2743661786641146,-0.8557471784658097,-0.03576089814886664},
{-0.26864443496029594,-0.8488259055206367,-0.039980266504573946},
{-0.26954219583904543,-0.8312753808747835,-0.031964544372882236},
{-0.27928554184665,-0.8564245406654425,-0.060384118793271435},
{-0.2778332816016141,-0.8503891734133451,-0.0819918112999319},
{-0.2677951725683937,-0.8385760197615169,-0.10598455161532296},
{-0.2565149633998086,-0.8180794814757336,-0.11833011087831838},
{-0.25490966348516597,-0.8505373632342671,-0.10958367821146203},
{-0.25143070536199275,-0.859636757110956,-0.12082508859056931},
{-0.2659489968357432,-0.8825442090651217,-0.11799924342360518},
{-0.2766628514523681,-0.9162172473552159,-0.09900130838140074},
{-0.15530454894251747,-0.6756205650828139,-0.05047318357000595},
{-0.14059549675383462,-0.6471853633722184,-0.03978950578964159},
{-0.12343511549106337,-0.6508755593492149,-0.05338578714121898},
{-0.14587913745980016,-0.7070809946285231,-0.054841280618711366},
{-0.14878311907779593,-0.7175555900433684,-0.07451981109300501},
{-0.16768675150668635,-0.732087892191097,-0.09387717380995492},
{-0.16695604097152172,-0.738377068191028,-0.11415169680039318},
{-0.15654611020580605,-0.7493716751592907,-0.06250835251717925},
{-0.16401918815688507,-0.7783058724123363,-0.06359687411086108},
{-0.15034800358673256,-0.8401883250131486,-0.0608917362889389},
{-0.15367122767991864,-0.8450882888009451,-0.04386984514972022},
{-0.1639372796013209,-0.8953014665942423,-0.008859326366795133},
{-0.16546228757662765,-0.916789529500013,0.011189948095841633},
{-0.18904871834665427,-0.9204538596173577,0.065688236638128},
{-0.21905096005449076,-0.902226511643948,0.07919506522507609},
{-0.24773673728046355,-0.8980507919264031,0.06064870498262677},
{-0.2659279808247761,-0.9130723899192125,0.08764889035462095},
{-0.3018572764974178,-0.9224045765327679,0.05369509971288896},
{-0.311699236094945,-0.9314339170395662,0.038401910193735296},
{-0.3073246725813266,-0.9351876999215404,3.09851443746077e-05},
{-0.2874278989162205,-0.9103861126199531,-0.04439093444728969},
{-0.28601928730934706,-0.8823415931645155,-0.050042624781217945},
{-0.2838023675883535,-0.8682102118413906,-0.058473278411491345},
{-0.2716734348999423,-0.8603184302871973,-0.05697413629583647},
{-0.1525067251235095,-0.637840243828837,-0.018420533612684618},
{-0.12571723873326265,-0.6171200736314806,-0.04622309950596209},
{-0.13385851805868104,-0.6215776234448152,-0.06832493770638802},
{-0.12216391626359037,-0.6687445573920316,-0.08479879594423322},
{-0.14753563022167046,-0.7171433529051673,-0.0974768392781701},
{-0.15568391488407787,-0.689975039445436,-0.11886305536156162},
{-0.15860244604812776,-0.6918330703637602,-0.12932094574204842},
{-0.15665927334178287,-0.7598193269703319,-0.10519779838424598},
{-0.16315268185854825,-0.7852853435417261,-0.10060876378434772},
{-0.15093645189381205,-0.837756934205875,-0.08673819654604556},
{-0.15018310873145205,-0.8818867851323039,-0.07685636041488839},
{-0.14927510928325707,-0.90319540363674,-0.05001298681703354},
{-0.1689703447919092,-0.952027452299044,0.05711909288430201},
{-0.17077017752601678,-0.9473252545631689,0.08361651060931344},
{-0.19406022865419936,-0.9192931291654811,0.08830900864781908},
{-0.22382967762516925,-0.9107811058517197,0.10078497495322593},
{-0.19077634222256715,-0.5709554417457731,0.00463187492994663},
{-0.177202154626109,-0.5655349275324831,0.008061256822120484},
{-0.1428425933110887,-0.5506022434322272,-0.004221254407973581},
{-0.12176730641559541,-0.5804428235172397,-0.04796365631170085},
{-0.08555079192640302,-0.594153884621022,-0.0814982044782425},
{-0.09477412638059028,-0.6144596621918731,-0.08512050257365304},
{-0.13211365027633362,-0.6441515135838873,-0.09159990041644035},
{-0.1347918444944518,-0.6390537837441694,-0.12479873127958409},
{-0.12647273738392698,-0.6710498521335024,-0.12047266625281293},
{-0.16873324107843396,-0.5014301664899167,0.007755177482906979},
{-0.140920975487787,-0.48195425191622915,-0.0032097915211712047},
{-0.12518429425001942,-0.5345567884948657,-0.03506413655449506},
{-0.08845154031194229,-0.548448910616211,-0.07261651492029005},
{-0.08824784666718401,-0.5266520740108465,-0.11536793107610599},
{-0.08550875990446878,-0.5842084615848874,-0.12824104610158388},
{-0.09304758024882959,-0.6055424070768992,-0.13199159575110148},
{-0.11648204909340164,-0.4466936964900029,-0.026279982842313098},
{-0.10575687816317911,-0.45392158764646545,-0.05273644628954243},
{-0.1017546752541321,-0.4441448315701439,-0.09233061095160498},
{-0.13041620323668127,-0.41583357043704683,-0.11659709828164473},
{-0.10753138390971094,-0.5296250312545804,-0.15369574635938027},
{-0.10529506479397845,-0.5675282153419036,-0.16179337704663618},
{-0.11511115853185383,-0.5928455032202995,-0.1624217018873456},
{-0.1427342800237966,-0.6179666416630023,-0.14998130113896002},
{-0.09870358155936648,-0.4222860246760301,-0.040224914427114324},
{-0.10060903322038577,-0.4035979410775718,-0.08339395644189235},
{-0.15473927213470942,-0.9031205004181648,-0.08718222713673557},
{-0.2703688256037523,-0.8662029133579922,-0.08934094867351251},
{-0.2785586034160179,-0.8691122836967488,-0.08950961563332557},
{-0.2722527223817284,-0.9228717786227293,0.1518630424286318},
{-0.29741373735806115,-0.9224455308105499,0.1077639072105395},
{-0.3037330901942526,-0.938858496503798,0.14567086340239518},
{-0.3133697395307934,-0.9281123095626084,0.10061145814472812},
{-0.23774281575748174,-0.9214313735633671,0.16052325556331534},
{-0.21616907219161433,-0.9259191002129623,0.1583639951544623},
{-0.22794773803057347,-0.9369034686117793,0.17096444090944363},
{-0.3134516480863575,-0.9584702068406578,0.12911132450445326},
{-0.3201325840855988,-0.9496677314778891,0.11055742005293881},
{-0.322636183751067,-0.9635776363777451,0.090891283636395},
{-0.3230796754696809,-0.94925657208384,0.07913201719217472},
{-0.28551975289482084,-0.9398985196106328,0.16319713880482487},
{-0.1812189070812102,-0.9475833742876112,0.11591326961709907},
{-0.20414791391841913,-0.9499247734581793,0.15828100885474597},
{-0.1735604571359596,-0.9627585508221034,0.09515376175818871},
{-0.1902083710543787,-0.9601256218583758,0.134261863807627},
{-0.3185509945423036,-0.9561800005173173,0.04596120767698715},
{-0.28509134959433713,-0.9297494029297398,-0.05205100100876853},
{-0.2864315244475484,-0.8971228542113932,-0.0758454364001621},
{-0.20902147297448767,-0.938690368416061,-0.17399667408154645},
{-0.1298018890699499,-0.36046069251528245,-0.11196441504358398},
{-0.10687503772104534,-0.2643081313640792,-0.11516800953588027},
{-0.10323010699843944,-0.17594227171223367,-0.1380021748876991},
{-0.0790827103972134,-0.24752172732210756,-0.11027990093375754},
{-0.0667118241466422,-0.1825806368174646,-0.12461551477371685},
{-0.06463824439788592,-0.14264913823577596,-0.12403568841985464},
{-0.07220077511359425,-0.09837971944164232,-0.11155918324237174},
{-0.04036690721916144,-0.11865208694377626,-0.0907339329901796},
{-0.04319975772311461,-0.14515058241293988,-0.09842094315546245},
{-0.02319790400317289,-0.18511495219126944,-0.05211081580921342},
{-0.04450975574006537,-0.2059445134200702,-0.09468602079615117},
{-0.037923661226214204,-0.22426400851848974,-0.05995463774863558},
{-0.022835781968047055,-0.19771432020209856,-0.038200910909357406},
{-0.07371069467077074,-0.2873055749549503,-0.0820624035418984},
{-0.10482409059948443,0.11700852711173201,-0.17444717113714941},
{-0.0796598423906952,0.11579983704508433,-0.18531675978376144},
{-0.10261848719208852,0.0835968417785365,-0.1919168649715907},
{-0.07900080184164922,0.07953697955734883,-0.19810742738159906},
{-0.021490757266151087,0.10541523326694428,-0.18498643120112432},
{-0.017138826379728075,0.13194929429312924,-0.16776300190545168},
{-0.03490867196054596,0.14746881008423654,-0.16239691377184587},
{-0.08256005190415838,0.16377507910642092,-0.15275110361001182},
{-0.06090386091065072,0.1660491192674788,-0.13679725692558392},
{-0.08254496348602813,0.1693470163730892,-0.13821125725321814},
{-0.07003019839114355,0.18266793409378956,-0.13979661890104586},
{-0.030280838571169928,0.15583210470499992,-0.1584512924307873},
{-0.03568464775010132,0.16526236603640196,-0.14901240914616798},
{-0.02101008337428762,0.1650252623229266,-0.1471177349266703},
{-0.0038814955640050805,0.17203760464895712,-0.14869339687712854},
{-0.01253362561754741,0.16940090358069732,-0.1411664317184415},
{-0.12155229645723944,0.07794461257253231,-0.1829651220437478},
{-0.1285969711078348,0.02103648810601561,-0.18665316253244013},
{-0.08835292672201962,0.028527887707681294,-0.20081364294767337},
{-0.06133441969943872,0.035243311519791674,-0.199620580171232},
{-0.03739610546373177,0.039204021278980504,-0.1896153423346525},
{1.8860522662793683e-05,0.056917285291810026,-0.18448420242621766},
{1.8860522662793683e-05,0.11191403050447045,-0.1747478617556021},
{-0.0021161506427666227,0.13720545252321473,-0.1526357849857307},
{-0.019197856582430197,0.13506936361363298,-0.15606786123828492},
{-0.0021878206288852777,0.15870968159126767,-0.14693775165325954},
{-0.16304382969918008,0.06273009837648628,-0.12136288292249726},
{-0.13436020796151163,0.13856448789908873,-0.14066366407145878},
{-0.1562384142503643,0.0361707103627256,-0.14859909426381454},
{-0.14007710181664557,0.049959907917539716,-0.1744266939982584},
{-0.14789990774510062,-0.028083318244915157,-0.15942018442357933},
{-0.11702146004155783,-0.009600006035367207,-0.1869301427795453},
{-0.06824868730762268,-0.015234991334937059,-0.18921981023080972},
{-0.030737263219609786,0.013235775932679775,-0.1843985217661209},
{1.8860522662793683e-05,0.00826737539122111,-0.1784121918729469},
{1.8860522662793683e-05,-0.014163174775613699,-0.15822281067052932},
{-0.021497762603140128,-0.006466464912961389,-0.1644457054051025},
{-0.021308618504436005,-0.04496564151642918,-0.1324431705508566},
{1.8860522662793683e-05,-0.040592155746962955,-0.12982533000525942},
{-0.007117422380866172,-0.05908085667727162,-0.09516076709517775},
{-0.04106259106938087,-0.07806531991757414,-0.1082079378012295},
{-0.04181377874343656,-0.06493300742350172,-0.1384429722459326},
{-0.07236459222472261,-0.08321370373244359,-0.1376551412707035},
{-0.08264519369217906,-0.06350176318943294,-0.16285387729236184},
{-0.12333757964529288,-0.08497258218876905,-0.14223932602191702},
{-0.1449625160583879,-0.09533724770009397,-0.12089729744876405},
{-0.13650330220808224,-0.06406973435762132,-0.1523103062517783},
{-0.15933908417612927,-0.04734422286024676,-0.1307414125345956},
{-0.05298244139227302,-0.044520533181586885,-0.16719503073726324},
{-0.10313849874550582,-0.038629583645879095,-0.1795481342093238},
{-0.15697343576213757,-0.9873268065147479,-0.11739247346593898},
{-0.149382344826397,-0.9922962848003587,-0.11034833768741972},
{-0.1866690592586845,-0.9973778484777942,-0.13429904598087652},
{-0.14890598191114218,-0.9841140511971582,-0.12563398299750828},
{-0.14947826405593925,-0.974318434598174,-0.13725422044609986},
{-0.15849197727253136,-0.967504936068217,-0.1405677448419165},
{-0.1695884310631731,-0.9576128613676144,-0.15964651069553298},
{-0.15367014993576647,-0.9541107317451696,-0.14929370036988182},
{-0.15642971383737275,-0.9399992886888596,-0.12934196175301554},
{-0.15197378064026626,-0.9279253209522085,-0.11743127225541675},
{-0.19176032263348944,-0.9995764465482011,-0.10187403541898384},
{-0.1525509126337481,-0.9941101282084444,-0.09712010596380505},
{-0.15499200313839098,-0.9634903391014201,-0.09292444797944527},
{-0.152577317365476,-0.9521874973056398,-0.11038336437236493},
{-0.16134207168291909,-0.9924342360518352,-0.08568470163730892},
{-0.19979059431123528,-0.9993048550218567,-0.06879591190088204},
{-0.16277870463774868,-0.9943127441090505,-0.06588061396928861},
{-0.16116532164196481,-0.9643115801453661,-0.07132106644939344},
{-0.17185762137554644,-0.9914351672227827,-0.057024251398911915},
{-0.17707605856030628,-0.9867044092668753,-0.035146045110059226},
{-0.18053022856797982,-0.9795088504349776,-0.0349870778476156},
{-0.09871435900088808,0.1867310295474337,-0.13413630661390033},
{-0.11258169300673376,0.18141397877275128,-0.12451582343964203},
{-0.1450465801022564,0.18905895691609972,-0.09331890233913592},
{-0.1390435451747239,0.18837997810023888,-0.08952200969107542},
{-0.1248706707017408,0.18700693205038674,-0.11240898450635008},
{-0.1593056741074123,0.16271942870937983,-0.09502227697162516},
{-0.12445520033108302,0.19554697671210447,-0.11418295138080582},
{-0.1777577317365476,0.17297254770095613,-0.04007941896657269},
{-0.1889775872326117,0.1575026081408482,-0.004526794875111007},
{-0.18611940974108276,0.1536949380512661,0.017224776475862843},
{-0.19092129881103267,0.12349493029150829,0.02782385134028263},
{-0.1881380245380789,0.1139401895105318,0.03193436753662175},
{-0.16390818050921258,0.18023546554236397,-0.0621791016786943},
{-0.1744301966667529,0.17169649862479858,-0.030664246053300915},
{-0.18011853030185462,0.16490293836165654,0.0034646780131571036},
{-0.17830468689376897,0.16419108834915477,0.039350863919712376},
{-0.18368748006173322,0.13810429114611636,0.03671039074691981},
{-0.1802791141805265,0.17607213988256906,-0.0027883935576765557},
{-0.2624517170619832,-0.4777122509333265,-0.13576154479535796},
{-0.268442896803842,-0.4705409413448523,-0.11625275902502955},
{-0.27837808127053104,-0.5171652311114561,-0.13190753170723296},
{-0.28507949440866337,-0.5074418233706665,-0.11559425734805964},
{-0.25169852478380456,-0.08613277376856958,0.06664527344524629},
{-0.24515500116396374,-0.04416218325099365,0.06772571195778693},
{-0.2542797220282283,-0.041461356405680105,0.047375746876697454},
{-0.2579273471112146,-0.08559228507626117,0.05199441944078012},
{-0.03793228317943149,-0.22664582309476392,0.009972097203900573},
{-0.0435985230594139,-0.2376393523188743,-0.0032367351249752113},
{-0.017417962115137575,-0.2096169266185562,-0.02146462197046119},
{-0.01562567359009511,-0.19777898485122822,-0.0038779928955105483},
{-0.02717154669218766,-0.19374175525723597,-0.03563803531552038},
{-0.04210800289697629,-0.21757498943810727,-0.023284931843459818},
{-0.0403464300802704,-0.20478054973573717,0.00845463343765897},
{-0.026615430709672983,-0.17814787511962965,-0.004641035755239992},
{-0.025713358854314868,-0.1825483044928998,-0.021543297293568887},
{-0.0776735599182639,0.020316555012372572,0.10050799470612073},
{-0.07078569704180787,0.02398088512971731,0.11258411793107613},
{-0.08314688359500963,0.04272447255201196,0.09949383745893796},
{-0.084353418173353,0.042854340722347235,0.08869537992636853},
{-0.07852605554262264,0.053150030607933954,0.10258157445487702},
{-0.051316248933033305,0.014885802229637153,0.12028837200279352},
{-0.05505817662933362,-0.00643413258839661,0.11340212574256574},
{-0.061051511859496664,-0.010241802677978713,0.10204485786710121},
{-0.0522404145435107,-0.02898377348404502,0.09260381909417761},
{-0.06213572247656986,0.04721920453859617,0.11669355638326308},
{-0.04351230352724107,0.01160784339084178,0.13056843459817388},
{-0.040060289007871855,-0.03491298293715458,0.1065627613529569},
{-0.03955051602390006,-0.024913133821335916,0.10805974798030747},
{-0.04294487123112871,-0.02943750377210448,0.0978535108593501},
{-0.03322038574618696,-0.04887839166084687,0.08719300457825717},
{-0.04845968805773262,-0.0407554339860152,0.08085533009147892},
{-0.06648226464223207,0.07269653742358798,0.1161153466456291},
{-0.052457579990170984,0.08351116111843974,0.1189584357190278},
{-0.05195750670356864,0.06864853038807417,0.11899992886888598},
{-0.016026594414698718,0.03751142408801295,0.1389802277057845},
{-0.009607550244432385,0.009198007466611487,0.1410333303156497},
{-0.005318667390910748,-0.021179289206176698,0.12912749066673565},
{3.3410068716956855e-05,-0.046977250976436236,0.10424830578619282},
{0.0006924506177629379,-0.06215566074338475,0.06554274117758638},
{-0.025132454756300507,-0.058386250571204425,0.06293082822482607},
{-0.013478268366915853,0.05274372106256959,0.1313702762473811},
{-0.013900744074562663,0.07355603838493577,0.13237096169266185},
{-0.018148672650302212,0.08188807842528643,0.12468502927153119},
{1.8860522662793683e-05,0.08095044101290712,0.12462359785485806},
{-0.04952665476837124,0.08616726158143874,0.11358588112050906},
{-0.00822211013683041,-0.06934367536621741,0.029657633015183264},
{-0.004217751739479071,-0.07261085676349123,-0.024555053326780648},
{0.008235581938732391,-0.06921434606795816,0.029478188613848585},
{-0.14924547131907265,-0.16801169136856267,-0.13385393764603434},
{-0.0398749170137003,-0.07361369769707626,-0.09390357854168285},
{-0.020337571023339638,-0.0683774777338058,-0.06092622410180803},
{-0.012998133347128469,-0.13135006854452805,-0.059287514118448396},
{-0.01782481053257806,-0.186309631583939,-0.03289032659958788},
{-0.0103307165705319,-0.15397191829837134,-0.013440816757628274},
{-0.011419238164213733,-0.10909034082581069,-0.043839668313459736},
{0.0188556728141193,-0.06833975668848018,-0.0574203223748308},
{-0.018571148357949024,-0.17651293724080258,-0.0045817598268711795},
{-0.04019123492235933,-0.19544081891311654,0.030850695791624635},
{-0.008284080425579621,-0.142171697576369,0.015452426217635344},
{-0.04390352465447524,-0.16977811403395324,0.06343790684841745},
{-0.01651265702732298,-0.12604002310683457,0.05275207357974876},
{-0.03636685979841875,-0.10604894682841454,0.08221975418811378},
{0.04040516713656311,-0.11865208694377626,-0.09073447186225568},
{0.07223903503099592,-0.09837971944164232,-0.11155918324237174},
{0.06467704318736366,-0.14264806049162376,-0.12403568841985464},
{0.09567134838726364,-0.10290570600863923,-0.1199176280144504},
{0.09866693825819302,-0.14005500806152624,-0.13301114171904505},
{0.10326944465999327,-0.17594173284015763,-0.1380037915039273},
{0.06675062293611994,-0.18257955907331253,-0.12461551477371685},
{0.07912150918669116,-0.24751795521757497,-0.11028259529413793},
{0.10691383651052308,-0.2643081313640792,-0.11517016502418459},
{0.13056385418552718,-0.27859363010096305,-0.11912710267884087},
{0.1083747187087763,-0.3105929317227525,-0.10666622479156429},
{0.142985933283326,-0.32612861367614215,-0.11441897735012892},
{0.12984014898735158,-0.36046069251528245,-0.11196657053188831},
{0.09200647939784279,-0.32510960658027477,-0.08661641145685145},
{0.07375003233232456,-0.28730611382702637,-0.08206402015812662},
{0.06722698585137477,-0.2806187113628721,-0.04188895139804972},
{0.03796246001569195,-0.22426239190226152,-0.05995571549278774},
{0.02287404188544872,-0.19771432020209856,-0.038201449781433486},
{0.05548711880189337,-0.24087743462403977,-0.0065987580076390506},
{0.043238556512592355,-0.14514950466878768,-0.09842094315546245},
{0.023236702792650638,-0.18511333557504123,-0.05211189355336558},
{0.044548015657467036,-0.20594289680384198,-0.09468709854030333},
{0.16719422242914908,-0.3534429614684911,-0.10916389686419563},
{0.15812823862117723,-0.2830759680297975,-0.12176811472370952},
{0.1271080675616254,-0.22568178095065655,-0.1359528443823664},
{0.16023091746204185,-0.20396900838916052,-0.13001824620849609},
{0.1492842701085504,-0.16801169136856267,-0.13385501539018652},
{0.13651084641714734,-0.1359994568169473,-0.12708893760292458},
{0.11986939896364122,-0.10894592310942126,-0.11108443694334516},
{0.19372558909495358,-0.3048760378676185,-0.10413029280153127},
{0.2029526956536734,-0.2046366708914238,-0.10532874429873346},
{0.18328386487674916,-0.1601603252200753,-0.10913587551623946},
{0.1643791547037066,-0.1333751498064372,-0.10517516575705062},
{0.14075446401627825,-0.11501308381400722,-0.0979235642292405},
{0.217269987843046,-0.1666208625401998,-0.04685842968366054},
{0.23775143771069898,-0.22554436857125618,-0.04371464999180915},
{0.2241098911047309,-0.20188950104756734,-0.0738753200900132},
{0.20058596949552954,-0.14107724838985022,-0.06323744643611565},
{0.2032318313890829,-0.1560950742781269,-0.07813348723519827},
{0.2115024400127605,-0.2625352422337756,-0.09238234267090867},
{0.229363893846512,-0.2539262219463197,-0.06542149496046835},
{0.2268166455428813,-0.2949742634696464,-0.03155230723468094},
{0.23168697136649338,-0.2224787253304364,-0.03867188510385143},
{0.21579832820327116,-0.3036592647198297,-0.07804942319132976},
{0.2250572282144797,-0.2920093893070536,-0.05608607511445643},
{0.23040068372089015,-0.314255106351793,-0.052934751213539924},
{0.21132030125104542,-0.3345468732486658,-0.09508424726037439},
{0.21161775863704163,-0.43606175042894224,0.0275727369528293},
{0.20967674141900106,-0.450851633429037,0.024642889475181715},
{0.20377555331384772,-0.425695468301389,0.05684103489304468},
{0.20646829707802006,-0.41918481587818907,0.05225415578145074},
{0.20603827716130815,-0.4439379046929292,0.023326424993317992},
{0.17093561125337334,-0.4308729512083668,0.0606697209935939},
{0.1659181733529914,-0.4252131777932973,0.05744511049033048},
{0.15800429804367883,-0.44927166050197015,0.024453206504401512},
{0.16786996801255358,-0.4419710216152368,0.029482499590457224},
{0.17160381262771268,-0.42267940129156867,0.034158831466680466},
{0.1645359664778459,-0.45746251605838795,0.03056401584715002},
{0.17809398791202158,-0.46167757343748655,0.03006124820016727},
{0.19844880284179578,-0.4588172404576533,0.026757423501720085},
{0.18658014536613127,-0.420213522671426,0.06026987791314246},
{0.18636836864023176,-0.41563580438512543,0.030771481596440862},
{0.2010617935387083,-0.4186917479285758,0.03350679625462352},
{0.006418505298190242,0.17182636679513386,-0.1468003392738591},
{0.0049225964149918425,0.13901929593130025,-0.15108922212738074},
{0.019206478535647456,0.1350639748928724,-0.15604792297147},
{0.030319637360647675,0.15583210470499992,-0.1584512924307873},
{0.02104888216376537,0.1650252623229266,-0.1471177349266703},
{0.012572424407025159,0.16940090358069732,-0.1411664317184415},
{0.021529556055628833,0.10541523326694428,-0.18498643120112432},
{0.017177625169205825,0.13194929429312924,-0.16776300190545168},
{0.03466941275876636,0.14743647775967175,-0.1622589625203694},
{0.060942659700128465,0.1660491192674788,-0.13679725692558392},
{0.07006899718062129,0.18266793409378956,-0.13979661890104586},
{0.03572344653957907,0.16526236603640196,-0.14901240914616798},
{0.07903960063112697,0.07953697955734883,-0.19810742738159906},
{0.07969001922695568,0.1158283972651165,-0.18530274910978334},
{0.08259885069363614,0.16377507910642092,-0.15275110361001182},
{0.08258376227550589,0.1693470163730892,-0.13821125725321814},
{0.030776062009087533,0.01323523706060374,-0.1843985217661209},
{0.037434904253209514,0.039202943534828436,-0.1896153423346525},
{0.06137321848891648,0.03524385039186783,-0.199620580171232},
{0.1028620573704767,0.08347397894519029,-0.19190069880930827},
{0.10486504487726649,0.11700852711173201,-0.17444609339299724},
{0.12152696946966365,0.07862197477216493,-0.18272478509781606},
{0.1275801195002716,0.020139804971418238,-0.18638695972685654},
{0.13837157169585199,0.05312901459696676,-0.17407481053257806},
{0.13457845115232406,0.13906671667399548,-0.1402692097117681},
{0.15597382806100896,0.03160323064587058,-0.14989454273471114},
{0.1631591483234612,0.06274303130631209,-0.12133055059793248},
{0.16199249027874776,0.0869513204521353,-0.11128381961149479},
{0.17760738642732124,0.0331589543295138,-0.08568955148599365},
{0.17874063440331775,-0.03255918970883667,-0.08270312244035766},
{0.14759975599872394,-0.02765275945612715,-0.16010724632058146},
{0.15937896070975918,-0.047345300604398954,-0.13073925704629127},
{0.17159680729072363,-0.06398620918582895,-0.08416346576653476},
{0.15838851383392394,-0.09276413353681143,-0.1103273216764526},
{0.1692160704586017,-0.11091496167541791,-0.08343652733590268},
{0.08848279489235492,0.028568841985463365,-0.20081687618012986},
{0.11793808144297009,-0.01110292025555473,-0.1858486265228525},
{0.06828748609710043,-0.015234991334937059,-0.18921981023080972},
{0.10282972504591191,-0.039341972530457035,-0.17899632920341774},
{0.13654210099755998,-0.06406865661346925,-0.1523103062517783},
{0.12330039747204333,-0.08485995792486824,-0.14238104937792606},
{0.14500131484786563,-0.09533724770009397,-0.12089729744876405},
{0.13641654380383333,-0.10824431166636488,-0.11168366269194625},
{0.08268507022580895,-0.06350176318943294,-0.16285495503651398},
{0.07240446875835252,-0.08321370373244359,-0.1376551412707035},
{0.04110570083546727,-0.07806316442926975,-0.10820470456877301},
{0.041854733021218615,-0.06493192967934953,-0.1384408167576283},
{0.021347417293913755,-0.044964563772276984,-0.1324431705508566},
{0.01841918643249441,-0.06363863669675728,-0.09600571851047138},
{0.021538178008846116,-0.006466464912961389,-0.16444624427717855},
{0.05302231792590293,-0.044520533181586885,-0.16719503073726324},
{0.18670785804816223,-0.9973789262219465,-0.13430012372502867},
{0.19179912142296718,-0.9995775242923532,-0.10187619090728814},
{0.14942114361587475,-0.992297362544511,-0.11034941543157188},
{0.1570122345516153,-0.9873278842589001,-0.11739355121009115},
{0.15503080192786875,-0.9634914168455724,-0.09292552572359743},
{0.15258971142322583,-0.9941112059525966,-0.0971211837079572},
{0.16138087047239683,-0.9924353137959875,-0.08568577938146109},
{0.19982939310071304,-0.9993059327660089,-0.0687969896450342},
{0.16281750342722642,-0.9943138218532027,-0.06588169171344077},
{0.17189642016502418,-0.9914362449669349,-0.05702586801514015},
{0.17711485734978402,-0.9867054870110276,-0.03514712285421139},
{0.16992199287826665,-0.9609263857634309,-0.04905163903330661},
{0.18056902735745756,-0.9795099281791297,-0.03498815559176776},
{0.1764725218350965,-0.9201159868256555,-0.1489881599027444},
{0.18404690773647864,-0.9320212876024936,-0.15459296836605366},
{0.16962722985265083,-0.9576139391117665,-0.15964704956760906},
{0.18390033453178484,-0.9734562392764458,-0.15481606140555082},
{0.1585307760620091,-0.9675060138123691,-0.14056882258606865},
{0.149517062845417,-0.974319512342326,-0.13725529819025203},
{0.14894478070061995,-0.9841151289413104,-0.12563506074166042},
{0.15261611615495374,-0.9521885750497918,-0.11038498098859316},
{0.15419177810541201,-0.9256000879439229,-0.05735134674909254},
{0.16120412043144255,-0.9643126578895184,-0.07132322193769777},
{0.15370894872524424,-0.9541118094893218,-0.14929477811403397},
{0.1564685126268505,-0.9400003664330118,-0.1293430394971677},
{0.16463565781192072,-0.8921102661596959,-0.1374395924402714},
{0.152012579429744,-0.9279263986963607,-0.1174323499995689},
{0.15477807092418716,-0.903121578162317,-0.0871838437529638},
{0.16160881336057872,-0.8748065449246872,-0.12567278178698604},
{0.1502219075209298,-0.8818867851323039,-0.07685743815904054},
{0.1601975073933249,-0.8516873162446221,-0.10454199106765648},
{0.3231184742591587,-0.949257110955916,0.07913093944802256},
{0.3157801143270997,-0.9925835036169095,0.06713510816240313},
{0.32357328229137033,-0.9941047394876835,0.05187209547950993},
{0.31402608571945895,-0.9887893053292294,0.036889835148254495},
{0.29371491942784717,-0.9976300406093997,0.01565611986239363},
{0.29681451160946,-0.9994632834122243,0.05368216678306304},
{0.32384487381771465,-0.9957364441340542,0.08111183319969306},
{0.3226749825405448,-0.9635787141218973,0.09089020589224284},
{0.32017246061922866,-0.9496698869661935,0.11055634230878664},
{0.3134085383202711,-0.9281123095626084,0.10061199701680419},
{0.3117380348844227,-0.9314339170395662,0.03840083244958314},
{0.31859033220385746,-0.9561816171335455,0.04596012993283499},
{0.31702490882284473,-0.9875612158678427,0.019568870006811345},
{0.2860661691799661,-0.9879249545191969,-0.016389524757938662},
{0.3085414457291155,-0.978286688566428,0.003679149099436987},
{0.30000247881154996,-0.9661631445987775,-0.02264097971254408},
{0.290094776820741,-0.9777941594888907,-0.03787543217540502},
{0.28702051162670394,-0.9543844787598184,-0.059235243527068625},
{0.28947615167740104,-0.9812580291939337,-0.04965733124682066},
{0.27945259219023477,-0.9867496745212662,-0.057206390160626994},
{0.281027715268617,-0.9609932059008649,-0.07549193631825354},
{0.28662605726701323,-0.9912034522300683,-0.06829907184673616},
{0.27364678444254764,-0.9955257451523069,-0.0813958187837873},
{0.2751583206159523,-0.9518307639912746,-0.09581334117931077},
{0.2770357509290155,-0.9962828604191994,-0.10021215393635276},
{0.23500157350646214,-1.0000000000000002,-0.1115467891846219},
{0.26708817240457655,-0.99264116292905,-0.11196710940396438},
{0.2681928601605408,-0.9951264409439315,-0.13007806100894098},
{0.22225509341886313,-0.9962634610244606,-0.14452791572902923},
{0.2568937904692929,-0.9864430563099765,-0.14024172723588804},
{0.2539644818637214,-0.9820555598665323,-0.1564100450065958},
{0.21440049403791936,-0.9734098962779029,-0.16085789512256107},
{0.24354000155195157,-0.9641822508471071,-0.162027786399731},
{0.224440219687368,-0.9523286817895728,-0.1702725291637568},
{0.2124433106575964,-0.9321867213298501,-0.1597402744367709},
{0.20756867385737568,-0.9665058672391644,-0.16658394980298838},
{0.18985594871662229,-0.96627415224645,-0.16324294293129166},
{0.18511710767957373,-0.9388369416207549,-0.16985274781649037},
{0.18975032978971057,-0.9066759783761414,-0.16178583283757106},
{0.19272490364967282,-0.8734642145831717,-0.1618569639516136},
{0.1819528508488313,-0.855446487847357,-0.1432265396652958},
{0.16459147030168214,-0.8534930765715666,-0.12697900769940423},
{0.1590669537777088,-0.8323870739677367,-0.11227103325487356},
{0.17136132019347666,-0.8288289016493797,-0.13081739349732288},
{0.1704059000025866,-0.7948783442401042,-0.12348442228602469},
{0.19474567393497322,-0.822192692032453,-0.14218974979091764},
{0.2974514584033867,-0.9224449919384737,0.1077639072105395},
{0.3018960752868955,-0.9224045765327679,0.0536940219687368},
{0.26597216833501464,-0.9130745454075166,0.08764619599424055},
{0.30736347137080433,-0.9351876999215404,2.990740022244826e-05},
{0.2874666977056982,-0.9103861126199531,-0.04439255106351793},
{0.28513014838381484,-0.9297520972901201,-0.05205261762499677},
{0.27670165024184584,-0.9162199417155963,-0.09900184725347681},
{0.2860580860988248,-0.8823426709086678,-0.050042085909141866},
{0.2864703232370261,-0.8971239319555453,-0.07584651414431426},
{0.23756606571652744,-0.8953785253011217,-0.15183448220859955},
{0.24097820370226672,-0.9289351672227828,-0.15336541777674315},
{0.26569249372752907,-0.9490140796496039,-0.11979207082072373},
{0.21645736875231716,-0.9140806195735584,-0.1644128342084616},
{0.20540671908814223,-0.8724495184639129,-0.16323216548977004},
{0.23718831639119525,-0.94510079063311,-0.16687170749161517},
{0.19082645732564257,-0.8420835381047224,-0.13384262133243666},
{0.2190137778812412,-0.8539225576162025,-0.14819547907883052},
{0.21739877826922913,-0.8428692135916471,-0.1379860087254167},
{0.23635522016157542,-0.8650718208703,-0.1372423652604261},
{0.24589864462895425,-0.8451583421708354,-0.1341998935188778},
{0.20906027176396544,-0.9386914461602133,-0.1739977518256986},
{0.24777607494201737,-0.8980524085426314,0.06064978272677893},
{0.2190897588439685,-0.9022259727718718,0.07919290973677177},
{0.15371002646939638,-0.8450877499288689,-0.043871461765948465},
{0.17389132459067277,-0.8203799263685196,-0.023598555391738444},
{0.15039650207357974,-0.8402707724407888,-0.06075216842123415},
{0.1493139080727348,-0.903195942508816,-0.05001514230533785},
{0.15105500375054964,-0.840043368424683,-0.08596114301233802},
{0.16355899140391264,-0.7849167550416871,-0.10003540389539849},
{0.16405798694636284,-0.7783058724123363,-0.0635990295991654},
{0.175722411905193,-0.7935139201434693,-0.031274249243423605},
{0.1772506531129562,-0.8456341662140142,-0.00851929808678858},
{0.16397607839079867,-0.8953025443383945,-0.008860404110947294},
{0.1566980721312606,-0.7598193269703319,-0.10519887612839814},
{0.189087517136132,-0.9204543984894339,0.06568715889397585},
{0.1655010863661054,-0.9167906072441652,0.011188870351689474},
{0.1715197485838442,-0.9372655906469052,0.02382595940784426},
{0.17438385366821,-0.9501478664976765,-0.012171234146383523},
{0.1940990274436771,-0.9192931291654811,0.08830793090366693},
{0.1708095151875706,-0.9473263323073209,0.08361597173723737},
{0.16900914358138694,-0.952027452299044,0.05711801514014985},
{0.223868476414647,-0.9107811058517197,0.10078389720907376},
{0.21620894872524424,-0.9259196390850385,0.1583639951544623},
{0.18125770587068796,-0.9475828354155351,0.11591219187294691},
{0.17359925592543735,-0.9627585508221034,0.09515160626988439},
{0.1715811800005173,-0.9891255615047033,0.07190197054740782},
{0.16375460196752972,-0.9906667356422926,0.05844956804014382},
{0.17136940327461783,-0.9835730236327738,0.04600916729175828},
{0.16467499547347456,-0.9808323202538304,0.02861814878042472},
{0.1781397920384884,-0.967230111309416,0.010918356569497255},
{0.2029085081434348,-0.9794743626221084,-0.010443610270470673},
{0.19254384263210989,-0.9949421466939121,0.020199889207901164},
{0.19048750678978818,-0.9992703672089877,0.05572018097479804},
{0.16609546226602176,-0.992984424441513,0.08564967495236372},
{0.19621787244682412,-0.9988144814326239,0.08676998999853429},
{0.17676890147694058,-0.9889703663467923,0.09739439185052982},
{0.1742911676711242,-0.9921383952820673,0.1118938228016175},
{0.20361981928386058,-0.9986625195071692,0.11440442780407475},
{0.18599762465188865,-0.9885861505565471,0.12317995956303944},
{0.18595720924618264,-0.9871775389496737,0.13940863100626819},
{0.21837844770354276,-0.9959611537897797,0.1402939978272678},
{0.20154462291887604,-0.9844826396971971,0.1470929468111706},
{0.19946511557728286,-0.980438943638292,0.15776423053378513},
{0.20908074890285647,-0.9774029383616565,0.16669334083443263},
{0.21767791400463862,-0.9799965296638301,0.16220453644068528},
{0.23503606131933127,-0.9761656880749766,0.17553192062629872},
{0.25686361363303245,-0.9921216902477088,0.14740387599906885},
{0.24367418069889552,-0.9677829940594743,0.1676837877102679},
{0.2665212789805403,-0.9684652061077917,0.1643287701645931},
{0.27327011286136765,-0.973955234818896,0.1707025490804687},
{0.2843116017002492,-0.9772364268901478,0.16280537880551463},
{0.2776996413267462,-0.9965054145866206,0.13872857444625508},
{0.30093796073562507,-0.9795503435848358,0.15531559582007712},
{0.30211485734978405,-0.9848889492425614,0.14100207573523707},
{0.3131170085271118,-0.9869404352361986,0.13557078408042558},
{0.28997083624324255,-0.9998792926549581,0.11230282670736229},
{0.3102970909529845,-0.989372364915548,0.11859900804428236},
{0.319501564884509,-0.9938525473560781,0.10660587111904332},
{0.2949069044601364,-0.9999709009078918,0.08473197580679928},
{0.31517496098566167,-0.9921119905503393,0.09280643499478373},
{0.23778107567488338,-0.9214313735633671,0.16052217781916317},
{0.22798653682005124,-0.9369045463559316,0.1709633631652915},
{0.20418725157997294,-0.9499269289464836,0.1582799311105938},
{0.19024716984385645,-0.9601256218583758,0.13426078606347486},
{0.2722888268108258,-0.9228712397506532,0.15186034806825138},
{0.2855585516842986,-0.9398995973547848,0.16319498331652055},
{0.3037724278558065,-0.9388590353758741,0.14566870791409087},
{0.31349044687583527,-0.9584712845848099,0.1291102467603011},
{0.22174262607451092,-0.026818046610279037,-0.00729767509031496},
{0.23922686945500637,-0.07320577153548367,-0.012823269358440461},
{0.2323152962072028,-0.0831037738289232,-0.015371595406223326},
{0.22683335057723977,-0.06774699740479212,-0.020635836717449972},
{0.20489371287171396,-0.06619827905813784,-0.05101097790193391},
{0.21678823620703036,-0.11035884569290327,-0.04588522671425985},
{0.24984264935378464,-0.14381256304803294,-0.011355381823198228},
{0.26292807997723805,-0.11248900700964802,0.023619032530629497},
{0.252777885552193,-0.06403847977720874,0.01934901019977066},
{0.235209039255753,-0.022394445737737422,0.018572495538139208},
{0.21219920160713207,0.015107278652906049,0.011989634256744524},
{0.21110798565306985,0.028671227679918657,-0.0015748536423441358},
{0.21932686255744377,0.027319736513109753,-0.008909980341946665},
{0.21162638059025893,-0.06224403576386192,-0.04976348904580844},
{0.19932177560504558,-0.01866976194787165,-0.04811939034168801},
{0.1944298948983903,-0.07820488778527888,-0.062520207702853},
{0.17586682962158245,-0.11634463671400114,-0.08508385927247959},
{0.22933802798686015,-0.14077063017856062,-0.042381480475586944},
{0.25258173611649987,-0.1877586585965184,-0.008636233327297967},
{0.26490142951984347,-0.1740556805738772,0.027447718631178713},
{0.2553795599355078,-0.18881861997016802,0.06300519257132511},
{0.2560461446936189,-0.12615372511488757,0.0626694752679272},
{0.25334747333660973,-0.09405742651940369,0.04482418759645811},
{0.23834365812231106,-0.0378051093694765,0.031833059586318685},
{0.22193446453359547,-0.007570613796849528,0.049298442444151304},
{0.20045232922066164,0.040744117672417486,0.027151877861410725},
{0.20331158445634276,0.04667332712552705,-0.0010068824741556945},
{0.1985630437219248,0.04307366165731187,-0.033307413586473884},
{0.20546707276066323,0.031086452324909666,-0.03361942051852427},
{0.18199811610322203,-0.08271686367829767,-0.06722671641533674},
{0.24465546674943742,-0.09657557573092602,0.0644881685246976},
{0.22719439486821344,-0.13280286766164004,0.08826051016097188},
{0.23798800255209818,-0.08428929239629944,0.06835134243811594},
{0.20757244596190821,-0.08188861729736259,0.110928702913358},
{0.21290674064302528,-0.033939241095677745,0.08378248320874611},
{0.21924387625772743,-0.027795021684212322,0.07248826336618298},
{0.22308280092772217,-0.04019446815481576,0.0642656143572765},
{0.22937682677633792,-0.033581430037160555,0.04662186484226137},
{0.18773925920177958,0.08649327918746706,0.017280280299699094},
{0.20452350775544692,0.08915099626669429,0.040650084495141535},
{0.1881779010717088,0.1139401895105318,0.03193436753662175},
{0.19100051300621643,0.12359839373011554,0.027759725563229098},
{0.20734611968995456,0.11277245372166617,0.016015008665062988},
{0.20118088426752198,0.11702038229740576,-0.023788238362518647},
{0.18483743307208816,0.11620075786968773,-0.06844025633066915},
{0.19466915410016986,0.0966450902287405,0.06808621737668452},
{0.20379603045273878,0.05619088573325408,0.07446646275747308},
{0.1733653854444186,0.12762754024296666,0.04859736987317107},
{0.18372196787460232,0.13810213565781196,0.03671631833975669},
{0.18615551417018011,0.15369978789995078,0.017228548580395405},
{0.18901746376624162,0.1575026081408482,-0.004526794875111007},
{0.17779760827017752,0.17297254770095613,-0.04007941896657269},
{0.15934608951311832,0.1627215841976842,-0.0950185048670926},
{0.12491108610744678,0.18700693205038674,-0.11240898450635008},
{0.11262156954036368,0.18141343990067513,-0.12451582343964203},
{0.17592987765448387,0.08218984678789136,0.07905010863661055},
{0.14791984601191555,0.11085999672365783,0.08409449014079651},
{0.15764864247346597,0.15242643318417354,0.07013931998654976},
{0.17833055275342077,0.16418731624462216,0.039368107826146935},
{0.1801584068354845,0.16490293836165654,0.0034652168852331803},
{0.17447007320038282,0.17169649862479858,-0.030664246053300915},
{0.1639480570428425,0.18023546554236397,-0.0621791016786943},
{0.14508645663588632,0.18905895691609972,-0.09331890233913592},
{0.1390834217083538,0.18837997810023888,-0.08952200969107542},
{0.12449507686471294,0.19554697671210447,-0.11418295138080582},
{0.09875315779036582,0.1867310295474337,-0.13413630661390033},
{0.1803189907141564,0.17607213988256906,-0.0027883935576765557},
{0.2624899769793849,-0.47771171206125035,-0.13576370028366228},
{0.26848169559331975,-0.4705409413448523,-0.11625437564125778},
{0.28511829319814114,-0.5074434399868947,-0.11559695170844005},
{0.2784163411879327,-0.5171646922393799,-0.13191022606761338},
{0.2543195985618582,-0.0414624341498323,0.04737682462084961},
{0.24519433882551755,-0.04416218325099365,0.06772517308571084},
{0.25173732357328227,-0.0861343903847978,0.0666447345731702},
{0.2579661459006924,-0.08559228507626117,0.05199334169662796},
{0.04038576774182423,-0.20478054973573717,0.008454094565582888},
{0.02665422949915073,-0.17814787511962965,-0.0046421134993921516},
{0.01659187122250674,-0.20033216074769578,-0.0014509130648457087},
{0.043205146443875395,-0.22997874688531936,0.01066616443789176},
{0.043636782976815565,-0.2376393523188743,-0.0032388906132795317},
{0.0162378322685221,-0.20754765784640852,-0.022281552037798642},
{0.025753235387944776,-0.1825483044928998,-0.02154437503772105},
{0.02721034548166541,-0.19374175525723597,-0.035639113059672545},
{0.042146801686454044,-0.21757498943810727,-0.02328600958761198},
{0.05551729563815386,-0.23149621065156104,0.014638729382754371},
{0.24421628600743212,-0.42470879353008634,0.023019806782028408},
{0.2505959925161446,-0.3822537570161145,-0.014666750730710536},
{0.24574129398273886,-0.3832070217187002,0.022605414155522793},
{0.2443607037238216,-0.3509501392445445,-0.01768605097298742},
{0.22403444901407965,-0.4474707500237104,0.006027553606994129},
{0.23858992266107965,-0.4356522076511213,0.017402065388893204},
{0.22106203064242172,-0.4444336670029229,0.02620615736789013},
{0.2167408154643353,-0.4212535457782606,0.05503743005440452},
{0.23845412689790746,-0.40158202064095594,0.0536563009234112},
{0.23559594940637854,-0.3676039807558004,0.04590193174861834},
{0.21924980385056433,-0.325091823801764,0.03836742238086616},
{0.23777299259374218,-0.33494994956157365,0.008679343093384377},
{0.24052285679797902,-0.30496279627186745,0.0016486791167671124},
{0.23850531974513506,-0.29141878551166983,-0.026740179595285518},
{0.23031123095626083,-0.31626617693972386,0.028274348395885607},
{0.2304750480673892,-0.3276455385703077,0.008523609063397226},
{0.2472576800048283,-0.25617008527111734,-0.0075046019675297235},
{0.2400799039514412,-0.1942687721476423,-0.03643341049981463},
{0.18458631868463482,-0.4193604881749912,0.06707798772233863},
{0.22202391729822477,-0.38985562539337665,0.07205824344947105},
{0.19930345395445886,-0.3203691489269979,0.06483789650207358},
{0.1944891708267591,-0.2899595199296449,0.07305300130191494},
{0.22637584818464776,-0.30075636084598606,0.04232920988420717},
{0.2524534845623928,-0.21583712699274887,-0.005032256882474156},
{0.18242274729917315,-0.3891195261374512,0.08375338411663778},
{0.1908199908607296,-0.3687911159394049,0.08046249234801653},
{0.17873201245010045,-0.3213601346749093,0.0727479997068536},
{0.17796250312545805,-0.2958499305932766,0.07747767991860877},
{0.18463104506694947,-0.2465447522481743,0.09055071648431237},
{0.19402035212056942,-0.2560957209246183,0.07957119793418002},
{0.22183962304820534,-0.2733234611968996,0.054820803479820324},
{0.24349419742548478,-0.24994503504823984,0.024999622789546747},
{0.16143960752868955,-0.42718167748721797,0.06396923471543244},
{0.14842423027512652,-0.39549546054163115,0.07693234137761569},
{0.1715682470706914,-0.3568965926040885,0.08028466456291009},
{0.14479115473819437,-0.33765347076726765,0.06083246036057009},
{0.15216076925066604,-0.3240205461145168,0.06969205616340327},
{0.16197955734892183,-0.2782390522749023,0.0899671180259176},
{0.17061713785641,-0.22386254882181006,0.11462644309941976},
{0.1851968607468336,-0.19111367614219324,0.10965804255796109},
{0.20520302544338395,-0.18748383383771755,0.10891116586051405},
{0.21681679642706259,-0.20004116982661252,0.0853872442513127},
{0.155294849245148,-0.44690816757628277,0.03866164653440591},
{0.1428943250303924,-0.42651455385703085,0.05641047610425667},
{0.12435065914832347,-0.4061468059974307,0.048733165636343265},
{0.14682755231370115,-0.372114340032591,0.07337955778001949},
{0.11900235379322832,-0.37477690696050286,0.04539646974125519},
{0.110975854220015,-0.35206344895372593,0.031676786684255456},
{0.10392201874412631,-0.33923290482225843,0.05243306131070934},
{0.13384881836131157,-0.3318967003785038,0.06915533957562746},
{0.12453710888664718,-0.3018265607890812,0.09108419983963167},
{0.10743169257563609,-0.19603411706888077,0.11672103885914316},
{0.13564595673503876,-0.22448925704629125,0.10662203728132572},
{0.14536397575506757,-0.20918690670184423,0.12330874998922257},
{0.16275176103394465,-0.176549580541976,0.12979730865730324},
{0.1676360975315348,-0.11421339765310431,0.12380990101997708},
{0.1831394471603597,-0.11194744057318742,0.118630262624695},
{0.20881346835312073,-0.14247562142727818,0.11493036695032895},
{0.1395252968107395,-0.45332613400239696,0.013224729055120149},
{0.12488683686402319,-0.44593227024650167,0.01584149185656519},
{0.11181649465869999,-0.42059073312468215,0.02408515687643879},
{0.09544394437115783,-0.38629368097048705,0.009639074260883061},
{0.08580621729046498,-0.38288100411267173,-0.020473097350473778},
{0.09316774872179544,-0.350314809066846,0.002638048248450206},
{0.08687911159394049,-0.34335850943672774,-0.041370556460860644},
{0.08828017899174878,-0.3407239638567721,-0.017095986049679695},
{0.07218245346300751,-0.2887330470844865,0.01904346973263323},
{0.07515163860220894,-0.2978378296819361,0.05045647853564748},
{0.09386127708371055,-0.30846007604562736,0.07524567177948494},
{0.13191803971271654,-0.15518438046955155,0.13408780812705312},
{0.11837349008044282,-0.16909051326487498,0.11645429718148351},
{0.10947617323228404,-0.1146612003483269,0.11670325608063252},
{0.12019487769759361,-0.08276697878137307,0.12885697688454342},
{0.14686850659148323,-0.10880904960209681,0.13391321357440317},
{0.1340137132165921,-0.053115542795064793,0.1252567725442522},
{0.14339978703775555,-0.0488449815921299,0.12088005354232947},
{0.15352842657975738,-0.02696300319874463,0.1245142068234138},
{0.17720969883517415,-0.06617079658225775,0.12203593414552133},
{0.183955299483545,-0.05631590405490455,0.1138908827155704},
{0.08973351698093686,-0.18089612270763816,0.11024756860919274},
{0.0872633273841856,-0.13629853081917181,0.10847845158342172},
{0.09780043195985619,-0.07974983402740056,0.10468209780743731},
{0.10620144762594518,-0.01551520481449864,0.10495961692661857},
{0.1250382599174017,0.013845779122802538,0.10059636972659787},
{0.11089394566445082,0.0034503979031409436,0.10207611244751387},
{0.1182085952251623,0.04259029340506804,0.09946904934343828},
{0.13744578946914632,0.03997029737116645,0.11532536018209566},
{0.17306523369804197,0.010378676185303049,0.11653027814421081},
{0.1845378201977876,0.01950339704956769,0.09570987774070339},
{0.1918395368286732,0.014344774665252715,0.08441835225852065},
{0.22557346766336447,0.00020207702853005088,0.060788811722407604},
{0.08880935137045946,0.03970732779803945,0.08229950725537365},
{0.06402662459153496,-0.012422079097798855,0.08404491390979714},
{0.059925808092565286,-0.06497342282920776,0.08932532138330619},
{0.08405326642697636,-0.14211242164800017,0.08757668149642621},
{0.05807047153462145,-0.14216199787899952,0.08143838967779761},
{0.05754776562082374,-0.1787266237293397,0.06294537777088023},
{0.0729357966253675,-0.20563142874386767,0.06987958364587915},
{0.05886369123061138,-0.2034770181836993,0.044845203607425235},
{0.0659794969952493,-0.2515745842063061,0.029054096289973536},
{0.1020494382797479,0.060561677142339884,0.08322960045868791},
{0.1352762904908478,0.08370461619375251,0.09524267565074193},
{0.16565143167533172,0.0702770018019882,0.1034518528577464},
{0.09730143641740599,-0.42005671089728674,-0.016489754964089567},
{0.09495249303777277,-0.4122080391091798,-0.0296511665502703},
{0.08512454411422363,-0.40460455411568946,-0.04886411155083073},
{0.08539290240811152,-0.34175320952208516,-0.07596614374520405},
{0.08262363880913583,-0.32017192174715264,-0.041147463421363474},
{0.11207838648767492,-0.44336185044359955,-0.012800636731245096},
{0.07529982842313097,-0.20603989377753631,0.09010560814947019},
{0.0889111981928386,-0.2406451807592492,0.0985766771854496},
{0.12632293094677668,0.13997848822672293,0.09475176318943294},
{0.12362102635731098,0.1343526637524465,0.0956473685798781},
{0.10530207013096747,0.10109024598432523,0.10403922342067373},
{0.112872683927817,0.12999857737771914,0.10238542501918386},
{0.1018947819939129,0.1036347999275756,0.10192145616167889},
{0.09464964693101575,0.06514316753317304,0.09912524895889915},
{0.05509697541881137,-0.00643413258839661,0.11340212574256574},
{0.07082449583128562,0.02398088512971731,0.11258411793107613},
{0.05135558659458713,0.014884724485484961,0.12028783313071745},
{0.039590392557529976,-0.024913133821335916,0.10805974798030747},
{0.03726300406093996,-0.02443245992947239,0.1186361902175319},
{0.0435516411887949,0.011606765646689589,0.13056843459817388},
{0.062174521266047604,0.04721920453859617,0.11669355638326308},
{0.07856485433210039,0.053150030607933954,0.10258157445487702},
{0.08318568238448738,0.042723933679935926,0.09949383745893796},
{0.07771235870774165,0.020316555012372572,0.10050799470612073},
{0.06109031064897442,-0.010241802677978713,0.10204485786710121},
{0.04298367002060646,-0.02943750377210448,0.09785458860350224},
{0.04171570402558995,-0.035561246044678994,0.10451396971970031},
{0.021033793745635125,0.008116491209918766,0.13818916349809887},
{0.025046235224127664,0.0389297353922558,0.13680965098333378},
{0.06652268004793806,0.07269599855151195,0.1161153466456291},
{0.08439275583490684,0.04285487959442339,0.08869591879844461},
{0.052280291077140606,-0.028983234611968983,0.09260328022210153},
{0.0333459429399136,-0.048816960244173646,0.08722910900735453},
{0.02516478708086529,-0.058395411396497746,0.06292597837614133},
{0.04849956459136252,-0.0407554339860152,0.08085533009147892},
{0.024797815197054734,0.0589940982730228,0.12702858393040362},
{0.05249530103549657,0.08351116111843974,0.11895897459110388},
{0.019295392428200674,0.07423717268910099,0.13227127035858705},
{0.01818747143977996,0.08188807842528643,0.12468502927153119},
{0.04956707017407723,0.08616780045351466,0.11358588112050906},
{0.01860994714742677,-0.1765118594966504,-0.004582837571023339},
{0.01786468706620797,-0.1863107093280912,-0.032891943215816115},
{0.010369515360009648,-0.15397299604252343,-0.013441894501780434},
{0.040230033711837074,-0.19544081891311654,0.030850156919548562},
{0.04394340118810515,-0.16977811403395324,0.06343790684841745},
{0.036406736332048655,-0.10604894682841454,0.08221975418811378},
{0.014123298241983731,-0.13161142150142693,-0.060071572989144964},
{0.004046929291361655,-0.07237267530586379,-0.02152282015467784},
{0.00832287921505737,-0.142171697576369,0.015451348473483187},
{0.016551455816800727,-0.12604110085098677,0.052750995835596594},
{0.03992233775639533,-0.07361585318538065,-0.09390573402998716},
{-0.4298350835898365,0.3158124466516644,-0.0936637804678272},
{-0.4278326349551228,0.31854991679815137,-0.0952243540001552},
{-0.4206322262745403,0.32622884388229306,-0.1087742923531897},
{0.4298760378676186,0.3158124466516644,-0.09364761430554479},
{0.3588386875662813,0.28596270574135857,-0.09730709457420485},
{0.4206694084477898,0.32622776613814103,-0.10876135942336378},
{0.17475729201693352,0.5703535216367915,-0.20569205185242667},
{0.13262719536483794,0.6171852771526862,-0.21314357492046251},
{0.18641848374330722,0.6246685936732107,-0.19903913720114155},
{0.22945550209944562,0.5872644051283379,-0.17886915539346288},
{0.20780793305915524,0.6263752015381566,-0.17878509134959433},
{0.18475929662105653,0.6447507393324884,-0.17993666097617755},
{0.17994285800505247,0.6501825698593761,-0.17958100540596467},
{0.14289163067001198,0.6402764844847953,-0.20485464464619818},
{0.13168255261546952,0.6308155074450567,-0.20970018235431057},
{0.14166569669692972,0.5819829199106767,-0.20561553201762328},
{0.133696856435857,0.6043137787434365,-0.21220917074053958},
{0.19903186242811446,0.5559365381133442,-0.19130793952562014},
{0.23076873334885284,0.5523088512971729,-0.17013511678435636},
{0.24490388677651034,0.5755487873222801,-0.16370529517256843},
{0.24852941810437737,0.6144445737737427,-0.16486925885690146},
{0.22678485209039256,0.6370017588784564,-0.1672149690040782},
{0.19000252192131606,0.6511956493624066,-0.1774427610080788},
{0.18719877050947123,0.6583362432425441,-0.17269907012234553},
{0.20493035617288743,0.6744695343283068,-0.14404400860470934},
{0.19390826672874473,0.6658637472733072,-0.16009646887905987},
{0.21745697645344578,0.6801206857901589,-0.12309212341463836},
{0.24727815714371934,0.6481348559702717,-0.14934435434503332},
{0.2692943146840485,0.6249741341403483,-0.14571882301716632},
{0.2597573566815827,0.6542672201960633,-0.12410412517351682},
{0.2795382728503315,0.65934447289689,-0.10511804531698613},
{0.2271798453221593,0.6866281049809024,-0.09163977695007028},
{0.2792677590681393,0.6723194347447472,-0.06580678849486563},
{0.2539159833768742,0.6816095893363683,-0.03335052335256029},
{0.23018621263461025,0.6854894682841451,-0.05757713414897011},
{0.22543874964434443,0.6815018149211522,-0.027957491615150497},
{0.24339504496348605,0.6755957769673142,-0.001307034220532318},
{0.21068227671296655,0.6710369192036765,0.001883088469861965},
{0.21044948397609994,0.6525918669115304,0.04524396894372452},
{0.19318941137925386,0.6616174353137961,0.025851040669753328},
{0.1757331893467146,0.6610570083546727,0.04153599018821724},
{0.20352605554262265,0.6282396989213936,0.06706128268798013},
{0.15200287973237459,0.6575020692687721,0.05844902916806773},
{0.1872995395876982,0.6161581869756775,0.07127418457877449},
{0.1431184958140417,0.6486737280463517,0.05913124121638517},
{0.14224983402740057,0.6370556460860644,0.05397100221584199},
{0.18254237690006295,0.6064692670477569,0.06920922678323549},
{0.22435453902727123,0.5875009699697371,0.06660647465576852},
{0.21881816731762413,0.5729622013570955,0.06333121017735359},
{0.24979792297146997,0.5565411525827061,0.05285068716967143},
{0.2429650250467741,0.5957839726511646,0.058196298164386165},
{0.2744604812774286,0.563515773863411,0.04203552460274351},
{0.282090909874723,0.5315056948001,0.033667919005371486},
{0.3009007785623755,0.5193331134735263,0.02600515808351224},
{0.32426088306044853,0.519815403981618,0.004953581559366459},
{0.3141694256916962,0.5181578334755957,0.019424452290421872},
{0.3462775794728538,0.49459942405352514,0.0007239746342136353},
{0.3368796504660166,0.5129706508712484,-0.021399418449255494},
{0.34779504323909544,0.5116385590991785,-0.031678403300483694},
{0.3504285110748989,0.5003588888026694,-0.03746211729305157},
{0.371421889414828,0.44385599613736504,-0.011782168507453679},
{0.22597438848796808,0.5454581705939665,-0.16954451298897252},
{0.2243372951208367,0.5390994800962211,-0.14990047032754802},
{0.23374384608089116,0.5362973453006044,-0.1435751898985196},
{0.24773943164084394,0.5380325133855824,-0.13748377995051},
{0.26465139287654227,0.5441363173913419,-0.13907237483079418},
{0.2749982756093565,0.5775878792581672,-0.14797831363217026},
{0.2950373115025478,0.5798829354301923,-0.12830301639033306},
{0.28827392807566626,0.6231387358492194,-0.12075180198822241},
{0.30595701525223523,0.6269647275893881,-0.1026500112085392},
{0.30675562366898596,0.649838769474837,-0.06409479190915911},
{0.2804198675667986,0.672782864730176,-0.028219383444125435},
{0.26871233284188206,0.6640746919807213,0.005397612150056476},
{0.24362837657242872,0.6420208133950666,0.03732470491365115},
{0.22280905391307348,0.5294100212962245,-0.14424931886569584},
{0.26370028366226084,0.5303643637429625,-0.15144972754627836},
{0.29920171490649494,0.5349232215066002,-0.13424354215704026},
{0.30446865057810196,0.5465359147461266,-0.11223654544200444},
{0.3258737271841563,0.5472666252812912,-0.09180898278195944},
{0.3255196882301717,0.5732758249053742,-0.0918316154091548},
{0.33546888337083886,0.5355466964986249,-0.06858197968667822},
{0.34043620616814535,0.5686781683522586,-0.0513256791943647},
{0.32709265582024954,0.6077162170318064,-0.06159981419690817},
{0.32622614952191276,0.5392061767672848,-0.09671702965089711},
{0.34133558366312305,0.5207869903347905,-0.06887566496814189},
{0.3365250726399559,0.5598999422329134,-0.01142004647232784},
{0.3313718389764017,0.5980310692084185,-0.028131547295724375},
{0.30516864540493005,0.6511735556072874,-0.02720468732486658},
{0.2955416957657588,0.6412674702327066,0.007901211815524691},
{0.2696925411482718,0.6229054042402766,0.03398962563479131},
{0.32044081891311654,0.5729271746721503,0.009880488950966956},
{0.32441985032289217,0.5964575627462646,0.0014390578791719474},
{-0.3589798720502143,0.3620368933378168,0.03371587862014261},
{-0.3829580628195512,0.3670548701102748,0.012591015493649936},
{-0.37603840649060644,0.3472319219195916,0.022069775311899163},
{-0.35543948251036794,0.3327222523990584,0.021012508298629974},
{-0.3653326349551228,0.32726078390798646,0.024294239241957876},
{-0.34134959433710116,0.3226814490054577,0.006921542381211041},
{-0.3184168153953597,0.3614926325409759,0.04117494589724357},
{-0.31303941094815624,0.33977985997947974,0.012133513101057916},
{-0.3245421742841623,0.3220321081537813,-0.017700061646965505},
{-0.29282470275816286,0.35274673874619555,-0.0402852680996353},
{-0.31140177870894875,0.32647456954898574,-0.045426107705439596},
{-0.3067496960761491,0.3467453204348914,-0.06720893363682609},
{-0.26339797642757995,0.3827980178129555,-0.0446156441030151},
{-0.28543083900226757,0.3627584430476882,0.0160796733141926},
{-0.2587000896683135,0.3952960778734814,-0.0063859035375874035},
{-0.24552251191985033,0.415794771647569,-0.04643056525525293},
{-0.22569094177594995,0.47550179767724593,-0.04558453609580715},
{-0.2309223118905357,0.4839189795056172,-0.014060519645120406},
{-0.21136233327297968,0.5145161359854463,-0.007129547002577964},
{-0.20481827078106277,0.5146670201667487,-0.05402435055137391},
{-0.1812727942888182,0.5484004121293639,-0.05640077640688722},
{-0.1945118034539545,0.5489996378779649,-0.07381388867334007},
{-0.34325558487019653,0.3775564091289241,0.049303292292836025},
{-0.28558818964848304,0.41661601269151527,0.0506725662381556},
{-0.3577167559038825,0.41169880499728423,0.04013546166248502},
{-0.3146344722933534,0.4381283248407094,0.06215593017942285},
{-0.2544176732797048,0.4758757748980454,0.04494974479018477},
{-0.25926806083650195,0.4058127053102611,0.023709024167334867},
{-0.226410874869593,0.49216695550209955,0.016580285472871027},
{-0.23460496365846722,0.5099249458972436,0.03633156367743549},
{-0.21847652242138937,0.5193444297871241,0.025370905649965945},
{-0.20707398929153414,0.5344544028004105,0.008939618306131072},
{-0.20328464085253875,0.5345513997741048,-0.013531347266409732},
{-0.38553602683151844,0.40095207918401843,-0.018629615978203704},
{-0.3713814740091221,0.44385491839321295,-0.011799412413888244},
{-0.32950680272108845,0.4728101316572257,0.04343874748885613},
{-0.2820919876188752,0.4972652242138935,0.05406368821292777},
{-0.38153651828285184,0.42164476690549474,-0.051513745548916655},
{-0.37972860246760304,0.44195162222049783,-0.07357786270401698},
{-0.3503870179250408,0.5003594276747456,-0.03747882232741005},
{-0.34129624600156927,0.520790223567247,-0.06889398661872861},
{-0.3904462291887605,0.41733055706439737,-0.06627614607313141},
{-0.3952567402119277,0.42033854099307655,-0.07456399860324359},
{-0.34623662519507176,0.49459942405352514,0.0007078084719312326},
{-0.31412847141391415,0.5181583723476716,0.019408825000215554},
{-0.2727657285981567,0.5233827371252685,0.04321888768181544},
{-0.25706730727779076,0.5259962666942569,0.043434975384323574},
{-0.2159416681755085,0.5350471620840986,0.029746546907736482},
{-0.3008555133079848,0.5193341912176787,0.025990608537458076},
{-0.42747482389660557,0.23979969047187955,0.09315239086762717},
{-0.40094237948664896,0.31760904615331564,0.05921961623686231},
{-0.44086148401058783,0.25471028081701635,0.09750162739366977},
{-0.44933955838355627,0.18458739642878697,0.12373176456894545},
{-0.4550715406568205,0.18974547994102578,0.12957206012950176},
{-0.46509563901606277,0.19426230568272937,0.13444238595311384},
{-0.4677307234680945,0.2477674529888001,0.10193007811489616},
{-0.4559261917694835,0.2771645413551986,0.08250212315597977},
{-0.43278163610184256,0.3044206909633308,0.07603889147547487},
{-0.43019505013665804,0.34277760533871343,0.05162151996413268},
{-0.39784979264202514,0.3729328867161568,0.022288557374787684},
{-0.39020643111490483,0.376648409680729,0.00802946336963176},
{-0.39620192183337216,0.3177200538009881,0.04249518248363985},
{-0.40663125199382677,0.27656262124621717,0.06269749661588336},
{-0.42190073114163285,0.24831279152979333,0.08339988403472924},
{-0.4504501737323574,0.18207517481010163,0.11878815214298649},
{-0.4798052300768217,0.19942901114818548,0.14131516041143963},
{-0.4934020503004751,0.2028314494365554,0.14423207495926127},
{-0.4866526775475717,0.24583451885190072,0.094657999448195},
{-0.4746072700309529,0.290713940836157,0.058865038410801596},
{-0.4560253442314822,0.30965852754282963,0.06122960908064113},
{-0.45492281196382234,0.33937193381788705,0.03357038315960098},
{-0.4260532793599062,0.37353642344136645,0.01747319650293578},
{-0.4089246915496237,0.400566246777545,-0.0491464805186967},
{-0.39549815490201157,0.40222597277187183,-0.016490832708241726},
{-0.4133940965486322,0.38531239491994523,-0.0797016049765914},
{-0.4996642826966021,0.21657376512075047,0.12788916263590355},
{-0.5143372304561876,0.19832647888052557,0.13785829604338568},
{-0.5018391703956615,0.23861363303242727,0.0787882168076356},
{-0.4927360044144401,0.2714401032909996,0.050847699662881635},
{-0.4737116646405077,0.3199008690928843,0.01729590758990542},
{-0.4487602709017701,0.36390139072105404,-0.0005563854185527183},
{-0.4408851943819353,0.3613449815921299,-0.057462893268841124},
{-0.4268330272539942,0.3600635437952115,-0.08207156436719175},
{-0.4207755662467776,0.3605027245372167,-0.08684758757748981},
{-0.5016818197494461,0.2459067277100955,0.0174915181535225},
{-0.49817915125492535,0.22631603338420297,-0.003918947173292637},
{-0.5301418095755412,0.18085301294155173,0.09647561496081324},
{-0.526123979376288,0.18955471922609357,0.11511088909581578},
{-0.43427431175258446,0.34888841468146203,-0.05944540363673987},
{-0.460025930524301,0.3377569342058751,-0.02141504573946182},
{-0.4822899692196271,0.3001910840381781,-0.002729656501383822},
{-0.45667953493184354,0.3349639602355518,-0.044846281351577394},
{-0.4504792728244657,0.2991235784554633,-0.08005564393057604},
{-0.42542926549580545,0.33222541234491276,-0.09343422096341707},
{-0.41881514963399813,0.3413043290827105,-0.10175979453885484},
{-0.4169641240526629,0.3526906960502833,-0.10077850848831295},
{-0.2949958183526897,0.5798834743022685,-0.12831918255261549},
{-0.3044276963003199,0.5465359147461266,-0.11225271160428685},
{-0.3254787339523896,0.5732774415216024,-0.09184724269936112},
{-0.28823405154203635,0.6231381969771432,-0.12076796815050482},
{-0.3059230663114422,0.6269587999965514,-0.10266294413836512},
{-0.32705331815869576,0.6077113671831218,-0.061615441487114495},
{-0.3403952518903633,0.5686781683522586,-0.05134292310079926},
{-0.33542792909305674,0.5355461576265488,-0.06859652923273238},
{-0.32583277290637425,0.5472666252812912,-0.0918256878163179},
{-0.32619273945319577,0.5392088711276654,-0.09672134062750576},
{-0.2991607606287129,0.5349232215066002,-0.13425970831932266},
{-0.2646109774708363,0.5441368562634179,-0.13908907986515265},
{-0.27495678245949845,0.5775884181302434,-0.14799501866652873},
{-0.26925336040626646,0.6249741341403483,-0.14573498917944872},
{-0.2597164024038006,0.6542672201960633,-0.12412029133579922},
{-0.2794951630842451,0.6593455506410424,-0.1051347503513446},
{-0.30671359164705175,0.6498420027072934,-0.0641061082227568},
{-0.3051136804531699,0.6512015769552436,-0.02722354784752938},
{-0.3313308846986197,0.5980305303363423,-0.02814879120215894},
{-0.33648411836217385,0.5598999422329134,-0.011436212634610244},
{-0.3368381573161584,0.5129711897433245,-0.02141612348361398},
{-0.3477540889613134,0.5116385590991785,-0.031694569462766095},
{-0.32421885103851433,0.5198170205978464,0.004936876525007977},
{-0.27441791038341834,0.5635184682237916,0.04201989731253719},
{-0.28205049446901703,0.5315051559280242,0.033651213971013},
{-0.24975858530991613,0.5565406137106299,0.052833443263236864},
{-0.24293700369881796,0.5957775061862514,0.058173665537190805},
{-0.22431466249364132,0.5875009699697371,0.06659030849348613},
{-0.21877829078399422,0.5729622013570955,0.06331504401507118},
{-0.18250142262228086,0.6064692670477569,0.06919306062095308},
{-0.1872596630540683,0.6161581869756775,0.07125801841649208},
{-0.1422088797496185,0.6370556460860644,0.05395483605355958},
{-0.1430786192804118,0.6486737280463517,0.05911507505410277},
{-0.15195869222213604,0.6575004526525439,0.05843394074993749},
{-0.20348617900899274,0.6282396989213936,0.06704511652569775},
{-0.17569223506893256,0.6610570083546727,0.04151874628178268},
{-0.21040960744247003,0.6525924057836062,0.04522726390936604},
{-0.1931484571014718,0.6616174353137961,0.025834335635394844},
{-0.21064132243518452,0.6710369192036765,0.0018669223075795606},
{-0.243354090685704,0.6755957769673142,-0.001324278126966882},
{-0.22539779536656238,0.6815018149211522,-0.027973657777432902},
{-0.25387502909909215,0.6816095893363683,-0.033366689514842694},
{-0.23014633610098034,0.6854894682841451,-0.05759330031125252},
{-0.2271388910443772,0.6866286438529786,-0.09165594311235269},
{-0.2792268047903572,0.6723194347447472,-0.06582295465714803},
{-0.2174160221756637,0.6801206857901589,-0.12310828957692077},
{-0.24723720286593728,0.6481456334117933,-0.14936052050731574},
{-0.20488724640680103,0.6744663010958504,-0.14406448574360037},
{-0.2267438978126105,0.6370017588784564,-0.1672311351663606},
{-0.18715835510376524,0.6583362432425441,-0.17271523628462793},
{-0.19386731245096267,0.6658637472733072,-0.16011263504134227},
{-0.3204009423794867,0.5729266358000743,0.00986432278868455},
{-0.26964404266142455,0.6229242647629394,0.033973459472508905},
{-0.24359658311994004,0.6420240466275231,0.03730099454230362},
{-0.3243778183009579,0.5964602571066451,0.0014228917168895463},
{-0.2955012803600528,0.6412701645930868,0.007882890164937968},
{-0.2686724563082521,0.6640746919807213,0.005381445987774072},
{-0.2803799910331687,0.672782864730176,-0.02823554960640784},
{-0.2227680996352914,0.5294100212962245,-0.14426548502797826},
{-0.2636593293844788,0.5303638248708863,-0.15146589370856076},
{-0.23370289180310913,0.5362973453006044,-0.14359135606080203},
{-0.2476984773630619,0.5380325133855824,-0.13750102385694457},
{-0.2448629324987283,0.5755487873222801,-0.1637214613348508},
{-0.2484884638265953,0.6144445737737427,-0.16488542501918385},
{-0.22941454782166357,0.5872644051283379,-0.17888532155574524},
{-0.20776697878137318,0.6263752015381566,-0.17880233525602893},
{-0.189961567643534,0.6511956493624066,-0.17745892717036119},
{-0.1428506763922299,0.6402764844847953,-0.20487081080848057},
{-0.13164159833768743,0.6308155074450567,-0.2097158096445169},
{-0.13258624108705588,0.6171852771526862,-0.2131597410827449},
{-0.18638884577912282,0.624663743824526,-0.19905207013096748},
{-0.17471633773915146,0.5703642990783132,-0.20570875688678517},
{-0.14162474241914766,0.5819829199106767,-0.2056316981799057},
{-0.1336559021580749,0.6043137787434365,-0.21222533690282197},
{-0.17990190372727038,0.6501825698593761,-0.1795971715682471},
{-0.18471834234327447,0.6447615167740101,-0.17995282713845998},
{-0.1989892915341042,0.5559376158574965,-0.19132572230413078},
{-0.23072885681522293,0.5523099290413251,-0.17015128294663875},
{-0.225933434210186,0.5454581705939665,-0.16956067915125494},
{-0.2242963408430546,0.5390994800962211,-0.1499166364898304},
{-0.39670953932903963,0.33692922669701597,-0.12954080554908912},
{-0.3601562297922972,0.3180773259874291,-0.13121184785701354},
{-0.3958301001008769,0.36118547545761015,-0.1266222743850392},
{-0.4284711983652777,0.32155628411060233,-0.09680648241552642},
{-0.35554564030935576,0.2868459170740541,-0.10103501159652709},
{-0.3349542605381824,0.3449244716898166,-0.12712126992748937},
{-0.36669705905175765,0.34888518144900554,-0.12954242216531736},
{-0.39226168921307436,0.36403072001931314,-0.11876336402748679},
{-0.3782143719338179,0.40542687290378765,-0.12296656622091169},
{-0.4202049007182087,0.36644917789676085,-0.09090583318244916},
{-0.3931616055801282,0.41357407982204286,-0.09235863229956115},
{-0.3837378107136391,0.44718945879999666,-0.09267010035953546},
{-0.3581753360406267,0.5066168102221879,-0.09939037402033057},
{-0.33774723450850563,0.4861741591440125,-0.14064534242087204},
{-0.28502722381728357,0.49780032418544096,-0.16152825198520473},
{-0.24066026917737945,0.486762068579016,-0.15682012665649278},
{-0.2151613814093445,0.5101943819352837,-0.12679794668184133},
{-0.22402259382840592,0.5355860341601787,-0.13079098876559497},
{-0.20920468948035492,0.5136754955467613,-0.08468078295957167},
{-0.22091114646111934,0.5543711147323316,-0.09937259124181994},
{-0.2111888164644819,0.550856052180061,-0.09297186872214032},
{-0.22266463619668403,0.4750599225748602,-0.08859299423191332},
{-0.24308681013596825,0.423091099557694,-0.09428887207608012},
{-0.26733174258296477,0.4140213436451894,-0.12985119586491126},
{-0.29100708724554464,0.3919615374666977,-0.1155414478846038},
{-0.303217389617444,0.37422617969874894,-0.0990481902520197},
{-0.3013151711888812,0.3678540173991016,-0.10119343998689465},
{-0.3210319615805765,0.3337056939379047,-0.11058382478466673},
{-0.32086706672529597,0.31069639516136,-0.047466816257554986},
{-0.33485456920410755,0.30443146840485247,-0.08171159782037024},
{-0.33791482372416654,0.3012445789469146,-0.06475275471405292},
{-0.3273761025322677,0.31178383901088946,-0.04864101851133356},
{-0.3587982721605753,0.28596324461343475,-0.09732326073648725},
{-0.3823949415000475,0.22624113016562766,0.050937152427510936},
{-0.40625404154057065,0.22954549373615094,0.0756476703482407},
{-0.4147477432037454,0.2012697981600752,0.07667907150185803},
{-0.3853910702430529,0.20839368700585434,0.024950585430623454},
{-0.4488367907365735,0.16266769699007608,0.08482627842011331},
{-0.4442159626841865,0.1700049791779831,0.10211652785321987},
{-0.44457323487062766,0.17804333393687022,0.11454184018347519},
{-0.4484832906546649,0.17952954312269895,0.11418402912495798},
{-0.4169290973677177,0.2252619996033901,0.07998451281653346},
{-0.3680027460920997,0.282440098980023,0.02885417474974781},
{-0.3578245303190985,0.28076420682341385,0.024669294206909637},
{-0.3510056430683808,0.26189290671908805,0.009503278497710871},
{-0.35667673279704787,0.24100622505022284,-0.0126217312019865},
{-0.39944700947552664,0.196236732969487,-0.00346629462938534},
{-0.457066445082469,0.15577121216040296,0.0683416427407465},
{-0.3359668011691369,0.2997492089357924,-0.011289100557840373},
{-0.3317657544640163,0.2887475966305408,-0.03416799229197383},
{-0.3468627945474768,0.2736252295595045,-0.06507553908762491},
{-0.3749682065475113,0.22136972659786355,-0.032603107783037176},
{-0.399940616297216,0.21384707241578516,-0.048387748635575906},
{-0.4256237983152704,0.18591463835217234,-0.012328584792598914},
{-0.4720487054137245,0.15170272798599801,0.05402165619099351},
{-0.49412252226619424,0.15662209116853346,0.04691608899580112},
{-0.4530593923247373,0.1900143771069898,-0.019988112482001674},
{-0.5153066613210557,0.17195515722131705,0.04666066363173914},
{-0.5064012613917558,0.16133937732253864,0.05059335204297182},
{-0.5199064733624756,0.16570424113878768,0.058322933102264995},
{-0.5261379900502661,0.17101159221610074,0.07061460515765243},
{-0.48370504729141345,0.20436130726054677,-0.014712015985101266},
{-0.3398633851512722,0.30391576782804375,-0.07330788779390082},
{-0.3483112826879802,0.2884700775113595,-0.08571649508979765},
{-0.3778069846443014,0.2497143977996776,-0.0741706219877051},
{-0.43046664166300236,0.21780239345421304,-0.05796997189243251},
{-0.4658403602252055,0.23972370950915214,-0.058755647379357324},
{-0.4817219980514386,0.2629307743376184,-0.04208779519412328},
{-0.4349813119164016,0.2840297716044592,-0.08940561332264212},
{-0.427383215643672,0.31202956467758214,-0.09680756015967858},
{-0.40096986196252904,0.24125410620521967,-0.0786745147995827},
{-0.425796237379616,0.251291137494288,-0.08299896321012563},
{-0.42459024167334874,0.271174439357492,-0.10174039514411597},
{-0.41245699800832886,0.3089396721933388,-0.12276017821577301},
{-0.41941114215014275,0.3395335954407112,-0.08812202003741929},
{-0.3808160463171328,0.25532567272789974,-0.09818114508160679},
{-0.3914091935887156,0.25848723519826194,-0.09066226300406094},
{-0.41714680168645407,0.26868269487769775,-0.09278757447212092},
{-0.39158055490890914,0.28772643404636883,-0.12252253563022168},
{-0.3992244553081056,0.31737571454437286,-0.13174802557271326},
{-0.4072175448126019,0.3450408680582499,-0.10517085478044197},
{-0.367136778665839,0.2871455299483546,-0.12022855720234862},
{-0.3703834829242217,0.3038074545407516,-0.13265279178845177},
{-0.37225983549313263,0.34622477000939805,-0.12198420242621764},
{-0.39029265064707763,0.35166899459403544,-0.11896597992809292},
{-0.36362494934602485,0.43075386047955316,-0.12070976996628817},
{-0.3433676702620212,0.4009326797892795,-0.1321015256546218},
{-0.35040210634317104,0.3824773889276878,-0.13299228119638223},
{-0.3299287395566592,0.3812670822448119,-0.13380867239164362},
{-0.2709750566893424,0.4441933300569912,-0.15413600484553774},
{-0.30950710448945107,0.45849499495615736,-0.14718671055240856},
{-0.34394426338342693,0.46545722217911256,-0.13005381176551736},
{-0.3718007164843124,0.47517416345498914,-0.10658862721260876},
{-0.2994937835717304,0.47584667580593704,-0.15930271031099388},
{-0.24033101833889453,0.44534651629980254,-0.13321375761965118},
{-0.22027312192304047,0.48123539656673836,-0.13101192631678782},
{-0.3064301449350336,0.3732777648448479,-0.12443553150030609},
{-0.2172672934826656,0.5357261408999595,0.0511333018632041},
{-0.24746245139373876,0.542731477889001,0.05957634955122734},
{-0.18578584792598918,0.5559516265314747,0.08681902735745756},
{-0.20186525180414375,0.5442942069096335,0.06805496279627188},
{-0.1726961063259271,0.5930405749118406,0.08408425157135098},
{-0.16759837648620923,0.5737489545881724,0.10263761715078935},
{-0.15845156186682532,0.5718197925558056,0.10226148444168544},
{-0.12216391626359037,0.5906264280110016,0.11935235120664237},
{-0.11941027995482098,0.5875440797358236,0.11646076364639646},
{-0.0849634213634757,0.5963492494589724,0.12303931395118252},
{-0.07705116267039137,0.6041461895277757,0.1285050934188631},
{-0.05282832397851411,0.6001321314330549,0.12233339153151755},
{-0.05185350439288518,0.6057175405016254,0.12796191036617438},
{-0.018529116336014773,0.6003800125880517,0.11489156816085117},
{-0.014416444651371334,0.6056717363751585,0.11945365915694543},
{-0.02919123923333593,0.6303580050524646,0.10058882551753276},
{-0.06289660984799499,0.6447399618909669,0.07937774285886726},
{-0.09679705215419503,0.6377297750532406,0.08322906158661184},
{-0.09122188165507016,0.6506567772863265,0.05885964969004079},
{-0.11528359759619947,0.6447744497038361,0.06002954096721072},
{-0.13787958149039084,0.6183039755826286,0.08676298466154524},
{-0.3220940784425304,0.31709496219273514,-0.011397413845132476},
{-0.36416220480587674,0.5014673486631661,-0.0631382939741169},
{-0.35065645396308087,0.5053509997154756,-0.05981938085753947},
{-0.36422579171085423,0.5014883646741333,-0.07936750428942173},
{-0.38804070424113885,0.462999426640111,-0.06968127872188166},
{-0.38501278204564465,0.4656000232792737,-0.08615244259934647},
{-0.38138832846192977,0.4546366708914238,-0.09192861238284923},
{-0.3560505634446428,0.49577416517937983,-0.08517977850202185},
{-0.35152403800556986,0.5065516067009822,-0.07982877878654632},
{-0.3728989377753637,0.44769599855151193,-0.056682067630601046},
{-0.35526704344602233,0.49154024727761836,-0.05558492408370192},
{-0.3833983213057086,0.4626205995706269,-0.056737571454437294},
{-0.3762668882508644,0.4462841537121821,-0.07367809291016787},
{-0.35549175310174774,0.3366360802876283,-0.11760586680806671},
{-0.35341224576015456,0.31085482355172744,-0.09385669667106387},
{-0.37126399989653663,0.2268597553089677,-0.014771291913470078},
{-0.36112242742470885,0.23786998956743663,-0.020518362604864507},
{-0.3569634127415225,0.23046534837001975,-0.012738127570419804},
{-0.35649351629118065,0.24404546355931475,-0.014345044101290706},
{-0.35338530215635056,0.23912286714432285,0.00022929006837209027},
{-0.35509999310243745,0.2488198701533845,-0.0060356366881353304},
{-0.36269270065440634,0.24368980798910195,0.007992281196382232},
{-0.3720415923023202,0.21868452704275626,0.03224637446867214},
{-0.38262881198106624,0.22329888863023034,0.032189792900683724},
{-0.37613863669675734,0.20560179077968332,0.02243620832363364},
{-0.3964799798246295,0.21115271203538466,0.027022009691075415},
{-0.39138979419397674,0.20721894587999964,0.009512978195080317},
{-0.38256145297155625,0.20072930946776693,0.00808335057723977},
{-0.4542265892415268,0.3040434805100749,-0.06246955372770148},
{-0.4771119474405732,0.27950055180500594,-0.0391142990783132},
{-0.4684172464930206,0.3051368519524414,-0.0659921604890372},
{-0.4701378650319444,0.31944336670029244,-0.05769245277325126},
{-0.48890785718596697,0.2840152220584052,-0.032513116146331796},
{-0.4847030383763138,0.2743516291180603,-0.027447179759102627},
{-0.48613428261038266,0.27935236198408403,-0.018941622910254093},
{-0.48756660458860357,0.29530782528474003,-0.021904880456618644},
{-0.4854849417587061,0.2882475233439384,-0.011989634256744524},
{-0.46829923350835906,0.32720312459584594,-0.043439825233008295},
{-0.45508662907495073,0.3236260917548261,-0.04116255183949372},
{-0.4499694998404939,0.31898101445901567,-0.05697521403998863},
{0.37042497607407987,0.30380799341282777,-0.13263662562616937},
{0.3992659484579637,0.31737679228852517,-0.13173239828250694},
{0.3916215091866912,0.28772643404636883,-0.12250636946793927},
{0.36717719407154503,0.2871444522042023,-0.12021185216799014},
{0.38085700059491484,0.25532567272789974,-0.0981649789193244},
{0.4246311959511308,0.271174439357492,-0.10172422898183356},
{0.41249579679780657,0.3089429054257952,-0.12274562866971885},
{0.407258499090384,0.3450408680582499,-0.10515468861815956},
{0.39033360492485975,0.3516582171525138,-0.11894981376581051},
{0.3722857013527845,0.34621830354448513,-0.12196749739185916},
{0.3559266228671443,0.3371948906305235,-0.11831502246018814},
{0.3524886190217532,0.32475772311459455,-0.10729939948095843},
{0.3534532000379366,0.3108440461102058,-0.09384053050878147},
{0.34835223696576223,0.2884700775113595,-0.08570032892751525},
{0.37784793892208346,0.2497143977996776,-0.0741544558254227},
{0.40101081624031115,0.24125410620521967,-0.07865727089314814},
{0.39145014786649773,0.25848723519826194,-0.09064609684177855},
{0.41718775596423613,0.26868269487769775,-0.09277140830983852},
{0.425836652785322,0.25129059862221187,-0.08298279704784323},
{0.43502226619418366,0.2840297716044592,-0.08938944716035971},
{0.42742416992145404,0.31202956467758214,-0.09679031625324401},
{0.4194520964279248,0.3395335954407112,-0.08810477613098472},
{0.42787358923290486,0.31854991679815137,-0.0952081878378728},
{0.45052022710224776,0.2991235784554633,-0.08003947776829362},
{0.4254696809015115,0.33222810670529307,-0.09341751592905857},
{0.4817634912012968,0.2629313132096946,-0.04207001241561264},
{0.482329845753257,0.30019539501478665,-0.0027140292111775},
{0.5017238517713803,0.24590457222179113,0.017511456420337468},
{0.49277534207599394,0.2714330979540105,0.05087679875498996},
{0.4737493856858333,0.3198997913487322,0.017308840519731344},
{0.46006742367415915,0.3377558564617228,-0.021397801833027252},
{0.4567204892096256,0.3349639602355518,-0.044830115189294986},
{0.4343152660303666,0.34888841468146203,-0.05942923747445747},
{0.42687398153177625,0.3600635437952115,-0.08205539820490934},
{0.4208170593966358,0.3605027245372167,-0.0868314214152074},
{0.41885556503970417,0.3413000181061017,-0.10174308950449636},
{0.41700507833044503,0.3526901571782071,-0.10076234232603055},
{0.5018790469292914,0.23861363303242727,0.07880546071407017},
{0.48669363182535375,0.24583451885190072,0.09467416561047741},
{0.47464499107627844,0.29072471827767865,0.05887473810817103},
{0.4560652207651122,0.30965852754282963,0.06124577524292353},
{0.4549637662416044,0.33937193381788705,0.03358654932188339},
{0.4488012251795522,0.36390139072105404,-0.0005402192562703137},
{0.4409266875317935,0.3613439038479778,-0.057445110490330485},
{0.41343505082641424,0.38531239491994523,-0.07968543881430899},
{0.46588131450298753,0.23972370950915214,-0.058738403472922765},
{0.4837460015691955,0.20436076838847084,-0.01469423320659062},
{0.4982184889164792,0.2263192666166594,-0.003907630859694955},
{0.5301827638533233,0.18085301294155173,0.09649231999517173},
{0.5261638559099179,0.1895563358423218,0.11513082736263074},
{0.5143776458618936,0.19832647888052557,0.13787500107774417},
{0.4997052369743842,0.21657376512075047,0.12790532879818595},
{0.4934456989386376,0.2028314494365554,0.14424877999361976},
{0.4677668278971918,0.24776799186087625,0.10194570540510249},
{0.45596606830311337,0.27715376391367713,0.08251828931826218},
{0.4328225903796246,0.3044206909633308,0.07605505763775726},
{0.4302349266702879,0.34277760533871343,0.05163768612641509},
{0.4260942336376883,0.37353642344136645,0.017489362665218184},
{0.40896564582740574,0.400566246777545,-0.0491303143564143},
{0.39048664459446647,0.4173310959364735,-0.06626051878292509},
{0.39529661674555755,0.42033907986515273,-0.07454783244096116},
{0.4409008216721417,0.2547189027702337,0.09751402145141962},
{0.400983333764431,0.31760904615331564,0.05923578239914471},
{0.39789074691980725,0.3729328867161568,0.02230472353707009},
{0.3955391091797936,0.40222597277187183,-0.016474666545959322},
{0.3815774725606339,0.42164476690549474,-0.051497579386634254},
{0.4275120060698551,0.23980831242509684,0.09316424605330093},
{0.40667220627160877,0.2765642378624454,0.06271258503401361},
{0.3962428761111542,0.3177200538009881,0.04251134864592225},
{0.3902473853926869,0.3766489485528052,0.00804562953191416},
{0.3855775199813766,0.4009510014398661,-0.01861237207176914},
{0.4219433020356432,0.24831117491356486,0.08341928342946812},
{0.45049058913806334,0.18207517481010163,0.1188043183052689},
{0.44937997378926225,0.1845868575567108,0.12374739185915179},
{0.4551173447832872,0.18973901347611288,0.12959361501254496},
{0.46513443780554053,0.1942612279385773,0.13445855211539623},
{0.4798472620987559,0.1994300888923378,0.1413318654457981},
{0.2159815447091384,0.5350471620840986,0.029762713070018886},
{0.2071149435693162,0.5344544028004105,0.008955784468413476},
{0.21851747669917146,0.5193444297871241,0.02538814955640051},
{0.21140328755076174,0.5145161359854463,-0.0071123030961434},
{0.20332451738616866,0.5345513997741048,-0.01351518110412733},
{0.18131374856660026,0.5484004121293639,-0.05638461024460481},
{0.20485922505884482,0.5146670201667487,-0.05400818438909151},
{0.19455275773173655,0.5489996378779649,-0.07379718363898158},
{0.25710772268349674,0.5259962666942569,0.04345114154660597},
{0.23464591793624928,0.5099249458972436,0.036347729839717895},
{0.22645452350775547,0.49215078933981704,0.01659699050722951},
{0.23096326616831778,0.4839189795056172,-0.014044353482838003},
{0.22573081830957986,0.47550179767724593,-0.04556836993352474},
{0.27280668287593873,0.5233827371252685,0.04323505384409784},
{0.2821345585128855,0.49726414646974143,0.05408039324728624},
{0.25445916642956296,0.4758746971538933,0.04496591095246718},
{0.25931009285843615,0.40580947207780466,0.023725729201693354},
{0.2587410439460956,0.39529661674555755,-0.006368659631152841},
{0.24556346619763242,0.415794771647569,-0.04641439909297053},
{0.26343785296120986,0.3827980178129555,-0.044597861324504454},
{0.2854712544079736,0.36275898191976413,0.016096378348551082},
{0.2928656570359449,0.35274673874619555,-0.04026910193735289},
{0.30679065035393116,0.3467458593069674,-0.06719222860246761},
{0.3114427329867308,0.32647456954898574,-0.04540994154315719},
{0.32458258968986836,0.3220321081537813,-0.01768443435675918},
{0.3130803652259383,0.33977985997947974,0.01214967926334032},
{0.3413905486148832,0.3226814490054577,0.0069377085434934455},
{0.3184572308010657,0.3614926325409759,0.041191650931602056},
{0.35548043678815,0.3327222523990584,0.02102867446091238},
{0.36537358923290486,0.32726078390798646,0.02431040540424028},
{0.3760782830242363,0.3472319219195916,0.022085941474181567},
{0.35902082632799637,0.3620368933378168,0.033732044782425016},
{0.3829995559694094,0.3670559478544269,0.012606103911780178},
{0.35775501582128416,0.4116977272531319,0.04015432218514783},
{0.3797695567453851,0.44195162222049783,-0.07356169654173456},
{0.2856264495658847,0.41661924592397176,0.05068981014459016},
{0.31467434882698325,0.4381223972478726,0.06217263521378133},
{0.3432965391479786,0.3775564091289241,0.049320536199270584},
{0.3295456015105662,0.47281713699421474,0.04345329703491029},
{0.24750340567152082,0.542731477889001,0.05959251571350975},
{0.1858278799479234,0.5559500099152461,0.08683627126389212},
{0.17273706060370916,0.5930405749118406,0.08410041773363339},
{0.13791999689609685,0.6183039755826286,0.08677968969590372},
{0.11532724623436194,0.6447739108317599,0.06004516825741705},
{0.09684016192028141,0.6377292361811646,0.08324468887681816},
{0.09126283593285223,0.6506567772863265,0.058876893596475355},
{0.06293648638162488,0.6447399618909669,0.07939390902114966},
{0.07709103920402129,0.6041461895277757,0.12852125958114552},
{0.029232193511118002,0.6303580050524646,0.10060445280773908},
{0.05189445867066725,0.6057175405016254,0.12797807652845677},
{0.014456321185001241,0.6056717363751585,0.11946982531922783},
{0.018568992869644682,0.6003800125880517,0.11490773432313357},
{0.05286820051214401,0.6001321314330549,0.12234955769379997},
{0.08500437564125776,0.5963492494589724,0.12305548011346491},
{0.12220487054137244,0.5906264280110016,0.11936851736892476},
{0.11945123423260305,0.5875333022943019,0.11647692980867887},
{0.15849143840045524,0.5718197925558056,0.10227765060396783},
{0.1676393307639913,0.5737489545881724,0.10265378331307176},
{0.20190512833777366,0.5442834294681118,0.06807112895855427},
{0.21730717001629551,0.5357261408999595,0.0511494680254865},
{0.3013561254666632,0.3678540173991016,-0.10117727382461224},
{0.33499683143219267,0.34491584973659933,-0.12710510376520698},
{0.3210729158583586,0.3337051550658286,-0.11056496426200392},
{0.3209080210030781,0.31069639516136,-0.047450650095272585},
{0.3348955234818896,0.30443146840485247,-0.08169543165808783},
{0.3555865945871378,0.28684645594613,-0.10101884543424469},
{0.3601961063259271,0.3180767871153532,-0.13119514282265507},
{0.3667380133295397,0.3488846425769294,-0.12952625600303494},
{0.35044521610925744,0.38247200020692695,-0.13297611503409984},
{0.3299702327065173,0.38126546562858366,-0.13379304510143727},
{0.3064710992128157,0.3732777648448479,-0.12441936533802368},
{0.2910485803954028,0.3919604597225457,-0.1155247428502453},
{0.30325834389522605,0.37422617969874894,-0.0990320240897373},
{0.3379557780019486,0.3012445789469146,-0.06473604967969444},
{0.33990433942905424,0.30391576782804375,-0.07329172163161844},
{0.39587213212281114,0.36118547545761015,-0.1266061082227568},
{0.39675372683927823,0.3369308433132442,-0.12952410051473062},
{0.3923026434908564,0.36403072001931314,-0.11874719786520439},
{0.3782553262116,0.40542687290378765,-0.12294932231447712},
{0.34340862453980325,0.4009326797892795,-0.1320853594923394},
{0.27101547209504845,0.4441874024641542,-0.15411983868325532},
{0.4202458549959908,0.36644917789676085,-0.09088858927601459},
{0.32741705681004973,0.31178383901088946,-0.04862485234905116},
{0.39320255985791025,0.413574618694119,-0.09234192726520267},
{0.36366590362380696,0.43075386047955316,-0.12069360380400576},
{0.343985217661209,0.46545722217911256,-0.13003764560323497},
{0.3095480587672331,0.45849499495615736,-0.14717054439012614},
{0.29953473784951246,0.47584667580593704,-0.15928654414871146},
{0.24070391781554196,0.4867512911374943,-0.1568055771104386},
{0.2403719726166766,0.44534651629980254,-0.13319759145736876},
{0.26738024106981195,0.4140067940991354,-0.1298339519584767},
{0.33778926653043984,0.48617308139986043,-0.14062809851443747},
{0.3718411318900184,0.47517470232706527,-0.10657192217825026},
{0.3582184458067131,0.5066141158618074,-0.09937474673012425},
{0.2850681780950657,0.49780032418544096,-0.16151208582292234},
{0.38377876499142116,0.44718945879999666,-0.09265393419725305},
{0.22031407620082252,0.48123539656673836,-0.1309957601545054},
{0.2227055904744661,0.4750599225748602,-0.08857682806963091},
{0.2431277644137503,0.423091099557694,-0.09427270591379772},
{0.21520233568712657,0.510183604493762,-0.1267817805195589},
{0.20924564375813695,0.5136754955467613,-0.08466461679728926},
{0.21124378141624206,0.5508506634593001,-0.09296863548968384},
{0.2209521007389014,0.5543711147323316,-0.09935642507953753},
{0.22406354810618798,0.5355860341601787,-0.13077482260331255},
{0.4285121526430598,0.32155843959890673,-0.0967908551253201},
{0.43050759594078447,0.21780239345421304,-0.05795380573015012},
{0.39998157057499806,0.21384707241578516,-0.048371582473293505},
{0.4256647525930525,0.18591463835217234,-0.012311879758240434},
{0.45310034660251935,0.19001383823491386,-0.019970868575567107},
{0.39948796375330875,0.196236732969487,-0.003450128467102937},
{0.45710632161609893,0.15577175103247887,0.06835942551925714},
{0.4720891208194305,0.15170218911392186,0.054038361225351994},
{0.4941634765439763,0.15662209116853346,0.04693225515808352},
{0.5153476155988378,0.17195515722131705,0.046677907538173705},
{0.5261789443280481,0.17101213108817664,0.070631849064087},
{0.5199474276402577,0.16570424113878768,0.0583390992645474},
{0.5064411379253857,0.16133937732253864,0.05061059594940639},
{0.35786548459688056,0.2807534293818922,0.02468546036919204},
{0.36804801134649046,0.2824379434917186,0.02887411301656278},
{0.33600829431899504,0.2997492089357924,-0.011274012139710129},
{0.3318056309976462,0.28874867437469287,-0.03415020951346318},
{0.346904287697335,0.2736241518153522,-0.06505883405326643},
{0.4062874516092876,0.2295546545614444,0.07565629230145798},
{0.38243589577782955,0.22623035272410622,0.05095331858979334},
{0.35104659734616284,0.26189290671908805,0.009519444659993275},
{0.3567176870748299,0.24100622505022284,-0.012605565039704093},
{0.3750091608252934,0.22136972659786355,-0.03258586387660261},
{0.41697166826172805,0.22526092185923804,0.08000283446712018},
{0.44852370606037095,0.17952900425062304,0.11420073415931646},
{0.4446131114042575,0.17804333393687022,0.1145580063457576},
{0.41478869748152747,0.2012697981600752,0.0766963154082926},
{0.385432024520835,0.20838290956433267,0.02496675159290586},
{0.44425637808989255,0.1700049791779831,0.10213215514342619},
{0.44887936163058384,0.16266769699007608,0.08484082796616747},
{0.3554772035556935,0.23046534837001975,-0.012738127570419804},
{0.3518990929705216,0.239123406016399,0.0002287511962960096},
{0.35500730710535167,0.24404546355931475,-0.014345044101290706},
{0.35963621823887987,0.23786998956743663,-0.020518362604864507},
{0.36977779071070765,0.22686029418104386,-0.014770214169317918},
{0.38107524378572727,0.20072930946776693,0.00808335057723977},
{0.38990358500814776,0.20721894587999964,0.009514055939232477},
{0.37465242751092837,0.20560179077968332,0.022437286067785802},
{0.39499377063880053,0.21115271203538466,0.027022009691075415},
{0.38114260279523726,0.22329888863023034,0.03219087064483588},
{0.37055484424441515,0.21868452704275626,0.03224583559659606},
{0.36120649146857736,0.24368980798910195,0.007992281196382232},
{0.35361378391660847,0.24883064759490617,-0.0060356366881353304},
{0.47562573825474425,0.27950055180500594,-0.0391142990783132},
{0.45274145779985,0.3040434805100749,-0.06246955372770148},
{0.4669310373071916,0.3051368519524414,-0.06599269936111328},
{0.4686516558461154,0.31944336670029244,-0.05769299164532734},
{0.4484832906546649,0.31898101445901567,-0.05697521403998863},
{0.45360041988912175,0.3236260917548261,-0.04116255183949372},
{0.4668130243225301,0.32720312459584594,-0.04343874748885613},
{0.48399927144495314,0.2882475233439384,-0.011989095384668443},
{0.4860803954027746,0.29530782528474003,-0.021904880456618644},
{0.4846480734245537,0.27935236198408403,-0.01894054516610193},
{0.48742218687221406,0.2840152220584052,-0.03251203840217963},
{0.4832168291904848,0.2743516291180603,-0.027447179759102627},
{0.38191265099195576,0.4626211384427028,-0.056737571454437294},
{0.38655449505530987,0.4630015821284154,-0.06968073984980558},
{0.3626765344921239,0.5014668097910902,-0.0631382939741169},
{0.35378083426019336,0.49154024727761836,-0.05558492408370192},
{0.3491707836493279,0.5053509997154756,-0.05981938085753947},
{0.36273958252502525,0.5014878258020572,-0.07936750428942173},
{0.3835265728598157,0.4656000232792737,-0.08615190372727038},
{0.3799021192761008,0.4546366708914238,-0.09192861238284923},
{0.3747806790650354,0.44627337627066044,-0.07367809291016787},
{0.3714138063336868,0.44769599855151193,-0.056682067630601046},
{0.35456543200296603,0.49577416517937983,-0.08517977850202185},
{0.3500378288197409,0.5065516067009822,-0.07982770104239416},
{0.3221339549761603,0.31709496219273514,-0.011381247682850074}
};


// texture array: 49kb.
const tgx::fVec2 nanosuit_tex_array[6295] PROGMEM = {
{0.060803,0.0181},
{0.129327,0.003674},
{0.099644,0.0039},
{0.0765,0.0039},
{0.055599,0.010388},
{0.03615,0.047285},
{0.004,0.046609},
{0.006179,0.008719},
{0.133405,0.057088},
{0.150952,0.011877},
{0.177662,0.002145},
{0.169454,0.051104},
{0.1529,0.11552},
{0.128882,0.113309},
{0.073018,0.114875},
{0.061584,0.046706},
{0.049507,0.08433},
{0.004,0.083684},
{0.250719,0.004439},
{0.215833,0.006128},
{0.216834,0.109074},
{0.238414,0.114941},
{0.194103,0.112539},
{0.165588,0.1453},
{0.139289,0.187333},
{0.049381,0.222138},
{0.034173,0.174876},
{0.01319,0.115593},
{0.278111,0.019791},
{0.29,0.0039},
{0.276618,0.114263},
{0.279639,0.147572},
{0.244327,0.184538},
{0.219044,0.195263},
{0.162623,0.243719},
{0.108561,0.229355},
{0.031316,0.323474},
{0.008242,0.270272},
{0.004,0.167461},
{0.324514,0.024029},
{0.3291,0.0039},
{0.428032,0.0181},
{0.3813,0.051372},
{0.327528,0.115519},
{0.402352,0.0039},
{0.414311,0.108899},
{0.400406,0.137953},
{0.35371,0.189917},
{0.3032,0.185622},
{0.4507,0.112979},
{0.414051,0.189955},
{0.364923,0.25323},
{0.25792,0.292642},
{0.266159,0.228871},
{0.223336,0.282802},
{0.162508,0.301088},
{0.101008,0.311741},
{0.046872,0.344812},
{0.066823,0.365953},
{0.140723,0.385353},
{0.098357,0.385956},
{0.0773,0.3857},
{0.0618,0.4053},
{0.072704,0.4183},
{0.033389,0.416316},
{0.0383,0.4248},
{0.063916,0.437864},
{0.142077,0.483528},
{0.097994,0.491509},
{0.0605,0.4917},
{0.069439,0.506878},
{0.119171,0.509122},
{0.164646,0.507348},
{0.1545,0.5349},
{0.170917,0.532255},
{0.159673,0.567117},
{0.4507,0.183617},
{0.4507,0.264549},
{0.412463,0.308001},
{0.361321,0.30988},
{0.326811,0.35708},
{0.260615,0.373742},
{0.210018,0.356115},
{0.183278,0.431342},
{0.4507,0.328277},
{0.432808,0.404523},
{0.359102,0.402367},
{0.330612,0.441047},
{0.257389,0.437522},
{0.189889,0.495695},
{0.21,0.5105},
{0.252703,0.505821},
{0.247662,0.522797},
{0.262236,0.527429},
{0.267102,0.552996},
{0.403275,0.428198},
{0.445831,0.458067},
{0.441434,0.437324},
{0.37121,0.427963},
{0.34789,0.451108},
{0.331544,0.492983},
{0.301114,0.496924},
{0.284972,0.487139},
{0.007565,0.326699},
{0.2727,0.5122},
{0.352781,0.510708},
{0.4663,0.996},
{0.491561,0.98677},
{0.434165,0.9837},
{0.4453,0.9885},
{0.4248,0.989},
{0.405,0.996},
{0.375579,0.989746},
{0.425468,0.943486},
{0.461288,0.940886},
{0.490625,0.945609},
{0.514194,0.909932},
{0.52541,0.988219},
{0.605428,0.982822},
{0.5562,0.996},
{0.603,0.996},
{0.692245,0.983215},
{0.6665,0.996},
{0.6909,0.996},
{0.736859,0.988227},
{0.731983,0.858213},
{0.800409,0.983824},
{0.7808,0.996},
{0.8159,0.9906},
{0.8438,0.996},
{0.853505,0.983665},
{0.903315,0.995959},
{0.918533,0.881729},
{0.984237,0.9837},
{0.9604,0.996},
{0.9961,0.996},
{0.364069,0.941198},
{0.3909,0.912789},
{0.426197,0.912466},
{0.481502,0.912883},
{0.475621,0.870489},
{0.526682,0.83592},
{0.594714,0.863767},
{0.651987,0.857836},
{0.679772,0.864242},
{0.65629,0.825715},
{0.755351,0.832659},
{0.826085,0.840229},
{0.802201,0.858352},
{0.862315,0.857806},
{0.929047,0.858427},
{0.990848,0.894549},
{0.350319,0.989425},
{0.318206,0.944342},
{0.317626,0.913561},
{0.362918,0.911837},
{0.395058,0.872537},
{0.422444,0.875533},
{0.3169,0.992233},
{0.3279,0.996},
{0.363885,0.871315},
{0.317476,0.863517},
{0.388529,0.818118},
{0.438543,0.862978},
{0.453449,0.780498},
{0.486457,0.791694},
{0.511988,0.843594},
{0.510606,0.764349},
{0.539331,0.798518},
{0.550824,0.836244},
{0.583401,0.823402},
{0.581364,0.805167},
{0.657076,0.810396},
{0.755009,0.816205},
{0.829512,0.824237},
{0.856692,0.844456},
{0.419999,0.787095},
{0.456698,0.716598},
{0.979212,0.809004},
{0.945628,0.648168},
{0.993032,0.690582},
{0.9961,0.748587},
{0.857748,0.810919},
{0.894819,0.686001},
{0.946786,0.605987},
{0.975564,0.594066},
{0.9961,0.613614},
{0.9961,0.5862},
{0.9961,0.5688},
{0.952356,0.571315},
{0.903498,0.604333},
{0.9136,0.5552},
{0.8901,0.553},
{0.880026,0.543165},
{0.851365,0.64933},
{0.851875,0.571175},
{0.891676,0.504863},
{0.8633,0.5234},
{0.845039,0.528685},
{0.806552,0.619773},
{0.7939,0.5598},
{0.814,0.5085},
{0.7866,0.5034},
{0.755111,0.518348},
{0.759014,0.606076},
{0.733093,0.537258},
{0.754788,0.474939},
{0.732323,0.490889},
{0.6772,0.5393},
{0.6948,0.4609},
{0.6655,0.4585},
{0.62951,0.467915},
{0.612121,0.497541},
{0.58399,0.463841},
{0.571908,0.432937},
{0.890725,0.674413},
{0.864758,0.68301},
{0.8247,0.719},
{0.785596,0.754066},
{0.829133,0.808184},
{0.811967,0.783753},
{0.771,0.7773},
{0.752569,0.791306},
{0.773235,0.640972},
{0.7866,0.5996},
{0.699105,0.604935},
{0.6729,0.5798},
{0.640863,0.60662},
{0.617962,0.5308},
{0.587153,0.495285},
{0.656442,0.788355},
{0.687086,0.753222},
{0.732712,0.75327},
{0.661903,0.64078},
{0.638241,0.742144},
{0.596298,0.750147},
{0.577824,0.617878},
{0.59069,0.554852},
{0.548725,0.566803},
{0.5488,0.4888},
{0.522,0.4922},
{0.492965,0.52081},
{0.493151,0.540587},
{0.458746,0.505337},
{0.45716,0.602183},
{0.42303,0.626598},
{0.385158,0.568035},
{0.388283,0.50047},
{0.411713,0.488383},
{0.38278,0.476805},
{0.577994,0.787144},
{0.536632,0.72121},
{0.554656,0.646738},
{0.554532,0.821694},
{0.51594,0.618109},
{0.486475,0.648636},
{0.42737,0.705473},
{0.417896,0.643149},
{0.392033,0.595053},
{0.366858,0.565711},
{0.361625,0.541408},
{0.40004,0.620568},
{0.3877,0.6304},
{0.399272,0.672908},
{0.3853,0.6453},
{0.373254,0.676252},
{0.3435,0.6587},
{0.32358,0.670833},
{0.366407,0.702688},
{0.339373,0.729046},
{0.3169,0.716977},
{0.333132,0.80807},
{0.41517,0.750469},
{0.157269,0.969544},
{0.1575,0.9851},
{0.200706,0.988412},
{0.181461,0.891054},
{0.147904,0.930391},
{0.145217,0.884033},
{0.169954,0.848021},
{0.128125,0.869819},
{0.135129,0.804084},
{0.155574,0.788114},
{0.122053,0.763627},
{0.104227,0.812501},
{0.058997,0.776107},
{0.068375,0.816758},
{0.026503,0.853588},
{0.0511,0.8517},
{0.058899,0.891986},
{0.026226,0.887946},
{0.035758,0.936857},
{0.075389,0.97382},
{0.052371,0.98459},
{0.009593,0.994759},
{0.1348,0.9828},
{0.106879,0.972181},
{0.102688,0.892701},
{0.08473,0.869698},
{0.948232,0.037695},
{0.969528,0.131781},
{0.98851,0.026407},
{0.9609,0.0161},
{0.921612,0.01303},
{0.905886,0.130588},
{0.875794,0.13092},
{0.867517,0.007254},
{0.840373,0.026287},
{0.821809,0.142217},
{0.8076,0.082},
{0.800698,0.023338},
{0.950324,0.145381},
{0.967107,0.186705},
{0.942346,0.235114},
{0.913757,0.202556},
{0.917994,0.155587},
{0.868647,0.190344},
{0.823383,0.187764},
{0.86755,0.20432},
{0.855085,0.24873},
{0.912408,0.252341},
{0.287956,0.80415},
{0.259334,0.829865},
{0.293851,0.856906},
{0.304986,0.820757},
{0.241279,0.871025},
{0.249728,0.884962},
{0.293985,0.873513},
{0.250515,0.915874},
{0.299319,0.929899},
{0.304748,0.96718},
{0.240396,0.926473},
{0.264155,0.973228},
{0.28944,0.991887},
{0.1333,0.7168},
{0.188048,0.712668},
{0.1832,0.7012},
{0.158762,0.688703},
{0.1343,0.6875},
{0.113247,0.686959},
{0.090984,0.696404},
{0.080473,0.711158},
{0.0919,0.7261},
{0.117131,0.754362},
{0.121842,0.75261},
{0.138163,0.753859},
{0.144259,0.7531},
{0.1707,0.7334},
{0.961547,0.270323},
{0.959355,0.323139},
{0.984165,0.276806},
{0.991765,0.23164},
{0.991504,0.296775},
{0.983734,0.32214},
{0.967836,0.36564},
{0.950338,0.333963},
{0.90282,0.314},
{0.903588,0.275859},
{0.949909,0.258915},
{0.96851,0.228749},
{0.991195,0.362676},
{0.3132,0.6379},
{0.3396,0.6375},
{0.345003,0.602262},
{0.306213,0.602595},
{0.325157,0.578642},
{0.370295,0.594361},
{0.368525,0.577032},
{0.280729,0.596063},
{0.280697,0.579069},
{0.038603,0.654995},
{0.084463,0.686358},
{0.176899,0.634546},
{0.038665,0.634418},
{0.186635,0.612941},
{0.039822,0.602051},
{0.170257,0.597991},
{0.083391,0.55209},
{0.025696,0.556537},
{0.042729,0.513201},
{0.010514,0.53153},
{0.004769,0.584374},
{0.004073,0.642225},
{0.025671,0.687183},
{0.013092,0.703271},
{0.042563,0.723488},
{0.769113,0.361418},
{0.733049,0.420757},
{0.768137,0.404686},
{0.800824,0.41256},
{0.773982,0.42693},
{0.80486,0.373086},
{0.849387,0.421754},
{0.849088,0.354187},
{0.79251,0.266349},
{0.8297,0.266339},
{0.780578,0.226819},
{0.805295,0.156967},
{0.79019,0.183234},
{0.767389,0.153002},
{0.7944,0.1016},
{0.764644,0.117148},
{0.755241,0.074942},
{0.740556,0.132996},
{0.710172,0.076827},
{0.714676,0.119623},
{0.68008,0.123534},
{0.709445,0.152928},
{0.682681,0.175904},
{0.711804,0.185473},
{0.691075,0.26373},
{0.663746,0.218034},
{0.649756,0.264081},
{0.624599,0.353455},
{0.670138,0.372231},
{0.667079,0.394246},
{0.6195,0.413646},
{0.666,0.4141},
{0.697706,0.423058},
{0.70378,0.359993},
{0.737063,0.35498},
{0.76745,0.30299},
{0.705618,0.302478},
{0.738949,0.259004},
{0.76349,0.260597},
{0.746444,0.186232},
{0.714309,0.254952},
{0.589268,0.390809},
{0.6035,0.3936},
{0.60245,0.340929},
{0.574807,0.236492},
{0.6035,0.23013},
{0.597939,0.161062},
{0.548847,0.213123},
{0.581904,0.113606},
{0.599344,0.098789},
{0.581875,0.057298},
{0.558077,0.087745},
{0.54893,0.056409},
{0.5576,0.0117},
{0.514581,0.00857},
{0.502047,0.0717},
{0.483238,0.04625},
{0.476836,0.112038},
{0.463292,0.082928},
{0.488806,0.206893},
{0.459,0.231724},
{0.460011,0.338734},
{0.517511,0.376479},
{0.4853,0.3936},
{0.549239,0.384384},
{0.514795,0.214287},
{0.5181,0.11767},
{0.543014,0.116978},
{0.981298,0.484108},
{0.985558,0.429991},
{0.973668,0.453635},
{0.954979,0.498365},
{0.926833,0.496897},
{0.9289,0.462248},
{0.949754,0.426157},
{0.986802,0.410369},
{0.940726,0.365887},
{0.922212,0.379364},
{0.926221,0.427449},
{0.993184,0.510287},
{0.92523,0.544544},
{0.943822,0.556138},
{0.251829,0.803444},
{0.250005,0.768465},
{0.176614,0.772162},
{0.176612,0.803626},
{0.213386,0.884212},
{0.1938,0.8561},
{0.176645,0.74461},
{0.249309,0.742788},
{0.224419,0.714597},
{0.194039,0.71578},
{0.227942,0.874926},
{0.688023,0.044827},
{0.735484,0.037106},
{0.7316,0.014121},
{0.687686,0.018014},
{0.677262,0.00951},
{0.64655,0.009521},
{0.637869,0.016546},
{0.590185,0.011946},
{0.632128,0.045255},
{0.586059,0.034233},
{0.622255,0.057032},
{0.640643,0.096884},
{0.679635,0.097884},
{0.699241,0.05658},
{0.265604,0.608908},
{0.2581,0.5774},
{0.229351,0.578497},
{0.222418,0.608711},
{0.235239,0.6365},
{0.196534,0.636033},
{0.194913,0.620718},
{0.254673,0.635312},
{0.29131,0.63415},
{0.292797,0.617217},
{0.26,0.6716},
{0.281353,0.641748},
{0.241612,0.642049},
{0.2128,0.6541},
{0.210582,0.667654},
{0.229071,0.705019},
{0.240221,0.698372},
{0.2792,0.698418},
{0.291524,0.705983},
{0.309087,0.666865},
{0.3069,0.6548},
{0.107188,0.653724},
{0.087458,0.685078},
{0.176591,0.636594},
{0.18527,0.612403},
{0.036318,0.641611},
{0.038004,0.601739},
{0.162925,0.595221},
{0.082921,0.553306},
{0.025785,0.557479},
{0.043277,0.513424},
{0.010357,0.531751},
{0.004967,0.589662},
{0.003304,0.652989},
{0.025717,0.68725},
{0.013413,0.703747},
{0.042743,0.72339},
{0.745653,0.360619},
{0.755208,0.406667},
{0.771461,0.402722},
{0.775499,0.358311},
{0.80332,0.390909},
{0.804378,0.372135},
{0.850773,0.3478},
{0.855,0.3921},
{0.726436,0.408591},
{0.70669,0.360588},
{0.706574,0.298839},
{0.7373,0.309357},
{0.763675,0.260769},
{0.792536,0.266044},
{0.830693,0.268584},
{0.796593,0.187661},
{0.762893,0.187931},
{0.767883,0.152899},
{0.804936,0.151955},
{0.7944,0.1016},
{0.764237,0.117254},
{0.757656,0.072578},
{0.74103,0.097779},
{0.710264,0.07698},
{0.714696,0.119991},
{0.680012,0.123728},
{0.709604,0.153006},
{0.680261,0.174417},
{0.730782,0.1838},
{0.699083,0.227531},
{0.6616,0.2285},
{0.691109,0.262456},
{0.649639,0.264263},
{0.623793,0.346861},
{0.669806,0.372473},
{0.618648,0.395526},
{0.66014,0.404061},
{0.698988,0.371074},
{0.7012,0.4077},
{0.735959,0.257473},
{0.7407,0.143408},
{0.495914,0.345809},
{0.482369,0.3936},
{0.522243,0.384824},
{0.514788,0.219631},
{0.549094,0.216771},
{0.5493,0.386275},
{0.574959,0.230966},
{0.589709,0.391817},
{0.601779,0.325848},
{0.6035,0.377124},
{0.459,0.3687},
{0.4597,0.325385},
{0.490122,0.21045},
{0.518022,0.116305},
{0.54317,0.114547},
{0.582421,0.11345},
{0.596573,0.17085},
{0.6035,0.230468},
{0.459,0.235898},
{0.459,0.143873},
{0.469589,0.092686},
{0.500165,0.087162},
{0.566606,0.069318},
{0.599395,0.099392},
{0.587461,0.051319},
{0.5576,0.0117},
{0.511721,0.057458},
{0.514555,0.008578},
{0.483277,0.045725},
{0.980943,0.485242},
{0.985604,0.428647},
{0.973517,0.452699},
{0.955009,0.498906},
{0.928932,0.470448},
{0.926401,0.428503},
{0.9565,0.4189},
{0.986904,0.41021},
{0.940987,0.36595},
{0.922085,0.379329},
{0.926967,0.500725},
{0.925088,0.544262},
{0.993368,0.510314},
{0.944899,0.555325},
{0.249145,0.80566},
{0.249313,0.768851},
{0.176791,0.803714},
{0.213052,0.884131},
{0.1938,0.8561},
{0.175281,0.772234},
{0.176715,0.744492},
{0.249425,0.743059},
{0.229971,0.716676},
{0.196835,0.714738},
{0.227804,0.874893},
{0.689994,0.044854},
{0.735362,0.037314},
{0.731803,0.014192},
{0.682667,0.014449},
{0.633738,0.045212},
{0.639084,0.016569},
{0.645075,0.008701},
{0.590026,0.012003},
{0.586138,0.033803},
{0.622184,0.056978},
{0.640532,0.096867},
{0.679671,0.09793},
{0.70005,0.056193},
{0.2581,0.5774},
{0.229351,0.578497},
{0.222235,0.608756},
{0.266169,0.609115},
{0.253987,0.635367},
{0.23429,0.6365},
{0.196411,0.636025},
{0.193924,0.621691},
{0.291537,0.634126},
{0.292632,0.617064},
{0.26,0.6716},
{0.281263,0.641765},
{0.241788,0.642211},
{0.2128,0.6541},
{0.210716,0.667727},
{0.228948,0.704641},
{0.239315,0.698534},
{0.279179,0.698437},
{0.291524,0.70598},
{0.308828,0.667149},
{0.3069,0.6548},
{0.039913,0.647532},
{0.085106,0.685358},
{0.17545,0.634428},
{0.185621,0.615384},
{0.040597,0.60446},
{0.083208,0.553037},
{0.175375,0.597611},
{0.025865,0.685252},
{0.003378,0.652521},
{0.005027,0.591205},
{0.025027,0.555798},
{0.043175,0.513383},
{0.010071,0.532154},
{0.043186,0.723152},
{0.012812,0.702855},
{0.754371,0.403303},
{0.775644,0.358141},
{0.74532,0.360233},
{0.708748,0.364476},
{0.70654,0.298969},
{0.734424,0.277902},
{0.763666,0.262129},
{0.79236,0.265287},
{0.818194,0.37493},
{0.708006,0.404087},
{0.676577,0.400478},
{0.666949,0.375312},
{0.688573,0.260569},
{0.733294,0.253275},
{0.780714,0.226829},
{0.797977,0.194456},
{0.830224,0.267828},
{0.8511,0.3472},
{0.855,0.3921},
{0.642671,0.390214},
{0.623974,0.347145},
{0.649758,0.264096},
{0.669407,0.193659},
{0.696648,0.18181},
{0.746093,0.18547},
{0.766981,0.153088},
{0.804838,0.148663},
{0.7944,0.1016},
{0.76486,0.117476},
{0.758647,0.072837},
{0.736438,0.089452},
{0.704213,0.081717},
{0.714914,0.120389},
{0.682806,0.139411},
{0.723229,0.156081},
{0.6177,0.3872},
{0.625204,0.404766},
{0.740527,0.122787},
{0.549256,0.386604},
{0.594631,0.393285},
{0.592904,0.353241},
{0.576518,0.216387},
{0.6035,0.229606},
{0.6035,0.3242},
{0.548937,0.21689},
{0.590802,0.119325},
{0.52228,0.386497},
{0.514907,0.22099},
{0.526241,0.118823},
{0.569032,0.075139},
{0.5928,0.0615},
{0.562409,0.016508},
{0.54927,0.056431},
{0.513671,0.008837},
{0.501742,0.073391},
{0.483059,0.045418},
{0.470746,0.093703},
{0.488185,0.208378},
{0.459004,0.156119},
{0.459,0.23435},
{0.460623,0.32563},
{0.473574,0.376132},
{0.980376,0.478855},
{0.985703,0.429601},
{0.973742,0.452584},
{0.930792,0.499041},
{0.928429,0.467898},
{0.952134,0.424497},
{0.98632,0.410397},
{0.940821,0.365973},
{0.921916,0.379149},
{0.927334,0.428202},
{0.988304,0.509145},
{0.925392,0.544686},
{0.944249,0.555936},
{0.252084,0.803234},
{0.250073,0.768928},
{0.176609,0.7725},
{0.176536,0.803589},
{0.228873,0.872225},
{0.204397,0.876963},
{0.2151,0.8851},
{0.176944,0.744276},
{0.249208,0.742551},
{0.229532,0.716761},
{0.197614,0.714393},
{0.688332,0.044834},
{0.735464,0.037233},
{0.73207,0.014233},
{0.682844,0.014453},
{0.642158,0.013272},
{0.631976,0.045222},
{0.59011,0.011962},
{0.58595,0.034217},
{0.621987,0.056828},
{0.639311,0.096615},
{0.677806,0.098182},
{0.700005,0.056215},
{0.2288,0.5786},
{0.222315,0.608815},
{0.256759,0.577264},
{0.266138,0.609104},
{0.254429,0.635301},
{0.235354,0.6365},
{0.19648,0.636029},
{0.194859,0.620771},
{0.291845,0.634092},
{0.292726,0.617152},
{0.26,0.6716},
{0.281249,0.64178},
{0.243925,0.641827},
{0.212735,0.654121},
{0.210531,0.667626},
{0.229075,0.705032},
{0.239954,0.69842},
{0.267676,0.6978},
{0.291091,0.705562},
{0.309045,0.666911},
{0.3069,0.6548},
{0.075677,0.654214},
{0.08414,0.686127},
{0.17964,0.633611},
{0.186094,0.614134},
{0.077133,0.598104},
{0.172069,0.598369},
{0.083158,0.552763},
{0.031048,0.583504},
{0.02329,0.549525},
{0.042478,0.513099},
{0.010049,0.532185},
{0.004758,0.584168},
{0.004179,0.64266},
{0.033661,0.6219},
{0.032636,0.653301},
{0.026087,0.685208},
{0.013135,0.703335},
{0.042887,0.723313},
{0.797488,0.401171},
{0.806601,0.374399},
{0.771645,0.36039},
{0.76758,0.417669},
{0.752154,0.39958},
{0.736954,0.357958},
{0.768161,0.306465},
{0.792334,0.265198},
{0.849357,0.355263},
{0.842,0.40662},
{0.727559,0.425943},
{0.719964,0.397196},
{0.702437,0.362334},
{0.70608,0.300721},
{0.739144,0.256778},
{0.763543,0.258233},
{0.797222,0.1661},
{0.812948,0.214543},
{0.829631,0.266696},
{0.692026,0.417773},
{0.6675,0.4058},
{0.668848,0.37199},
{0.691065,0.266088},
{0.694527,0.252924},
{0.745769,0.184916},
{0.767402,0.152999},
{0.7944,0.1016},
{0.76467,0.117823},
{0.754745,0.074605},
{0.740494,0.121459},
{0.70496,0.082372},
{0.714839,0.120286},
{0.683554,0.139808},
{0.72384,0.156103},
{0.711651,0.183392},
{0.680578,0.17447},
{0.6616,0.2285},
{0.650632,0.262747},
{0.623887,0.347009},
{0.619503,0.406302},
{0.6392,0.4072},
{0.549285,0.3857},
{0.596874,0.392687},
{0.5747,0.349318},
{0.601804,0.325824},
{0.575065,0.229077},
{0.6035,0.226504},
{0.595102,0.171159},
{0.5483,0.1782},
{0.582157,0.11422},
{0.599531,0.100137},
{0.572605,0.072418},
{0.5928,0.0615},
{0.562215,0.016315},
{0.551128,0.059447},
{0.515266,0.008369},
{0.504948,0.061449},
{0.483096,0.045034},
{0.488663,0.099361},
{0.463625,0.079394},
{0.466941,0.160119},
{0.5146,0.1768},
{0.491561,0.214338},
{0.459,0.232751},
{0.45972,0.339333},
{0.517965,0.380103},
{0.4924,0.3936},
{0.459,0.3936},
{0.549158,0.220185},
{0.514758,0.217519},
{0.529867,0.116579},
{0.528806,0.076387},
{0.981555,0.484857},
{0.985451,0.430222},
{0.973422,0.451123},
{0.955015,0.499012},
{0.926756,0.496766},
{0.928637,0.462305},
{0.926156,0.427743},
{0.973012,0.415197},
{0.991763,0.409576},
{0.940769,0.365895},
{0.922122,0.379046},
{0.993323,0.510436},
{0.925243,0.54483},
{0.943618,0.556394},
{0.252217,0.803124},
{0.249283,0.769001},
{0.176602,0.803621},
{0.214038,0.884534},
{0.1938,0.8561},
{0.175481,0.771658},
{0.177114,0.744258},
{0.249325,0.742825},
{0.224438,0.714935},
{0.193957,0.71588},
{0.2269,0.877149},
{0.688113,0.044831},
{0.735468,0.037127},
{0.73165,0.014162},
{0.687642,0.01802},
{0.677292,0.009491},
{0.646519,0.009473},
{0.638573,0.016598},
{0.590307,0.011931},
{0.631985,0.045224},
{0.585843,0.034172},
{0.622241,0.057022},
{0.639311,0.096615},
{0.678171,0.098046},
{0.699255,0.056574},
{0.265576,0.608907},
{0.257063,0.577295},
{0.2288,0.5786},
{0.222409,0.608717},
{0.23522,0.6365},
{0.196617,0.636038},
{0.194882,0.620748},
{0.25469,0.635313},
{0.291361,0.634145},
{0.292805,0.617224},
{0.26,0.6716},
{0.281151,0.641762},
{0.241391,0.64227},
{0.2128,0.6541},
{0.210587,0.667657},
{0.229029,0.704891},
{0.240405,0.698339},
{0.278814,0.698402},
{0.291523,0.705986},
{0.309082,0.66687},
{0.3069,0.6548},
{0.099643,0.0039},
{0.129327,0.003674},
{0.060802,0.0181},
{0.133407,0.057087},
{0.150952,0.011877},
{0.177662,0.002145},
{0.169453,0.051106},
{0.194104,0.11254},
{0.216834,0.109075},
{0.215834,0.006128},
{0.250719,0.004439},
{0.238414,0.114941},
{0.278111,0.019791},
{0.29,0.0039},
{0.324514,0.024029},
{0.3291,0.0039},
{0.428032,0.0181},
{0.402352,0.0039},
{0.0765,0.0039},
{0.0556,0.010388},
{0.03615,0.047285},
{0.061584,0.046706},
{0.073019,0.114877},
{0.128884,0.113309},
{0.1529,0.11552},
{0.165584,0.1453},
{0.244326,0.184537},
{0.3813,0.051372},
{0.414311,0.108899},
{0.4507,0.112979},
{0.400406,0.137953},
{0.414051,0.189955},
{0.4507,0.183617},
{0.4507,0.264549},
{0.412463,0.308001},
{0.4507,0.328277},
{0.432808,0.404523},
{0.361322,0.309881},
{0.359102,0.402367},
{0.37121,0.427963},
{0.403276,0.428198},
{0.441434,0.437324},
{0.445831,0.458067},
{0.327528,0.115519},
{0.276618,0.114263},
{0.279643,0.147572},
{0.303197,0.185624},
{0.35371,0.189917},
{0.266164,0.228869},
{0.257921,0.292643},
{0.364924,0.253229},
{0.326809,0.357077},
{0.260615,0.373742},
{0.330612,0.441047},
{0.34789,0.451108},
{0.331544,0.492983},
{0.352781,0.510708},
{0.223336,0.282799},
{0.210018,0.356115},
{0.257389,0.437522},
{0.284972,0.487139},
{0.301114,0.496924},
{0.219044,0.195261},
{0.139289,0.187333},
{0.162631,0.243718},
{0.049378,0.222142},
{0.108558,0.229362},
{0.101003,0.311742},
{0.162508,0.301087},
{0.140725,0.385352},
{0.183277,0.431342},
{0.189889,0.495695},
{0.252703,0.505821},
{0.2727,0.5122},
{0.049508,0.08433},
{0.013189,0.115593},
{0.034173,0.174876},
{0.008245,0.270275},
{0.031316,0.323474},
{0.046872,0.344811},
{0.066823,0.365953},
{0.098357,0.385956},
{0.063916,0.437863},
{0.142077,0.483528},
{0.164646,0.507348},
{0.170917,0.532255},
{0.21,0.5105},
{0.247662,0.522797},
{0.262236,0.527429},
{0.004,0.167464},
{0.004,0.083684},
{0.004,0.046609},
{0.006178,0.008719},
{0.007566,0.326703},
{0.0773,0.3857},
{0.0618,0.4053},
{0.072703,0.4183},
{0.0383,0.4248},
{0.033389,0.416316},
{0.097994,0.491509},
{0.0605,0.4917},
{0.119172,0.509122},
{0.1545,0.5349},
{0.159673,0.567117},
{0.069439,0.506878},
{0.267102,0.552996},
{0.491561,0.98677},
{0.4663,0.996},
{0.434166,0.9837},
{0.461288,0.940886},
{0.425468,0.943486},
{0.375579,0.989746},
{0.405,0.996},
{0.4248,0.989},
{0.4453,0.9885},
{0.364069,0.941198},
{0.35032,0.989425},
{0.318206,0.944342},
{0.3169,0.992234},
{0.3279,0.996},
{0.5562,0.996},
{0.52541,0.988219},
{0.605428,0.982823},
{0.514194,0.909932},
{0.490625,0.945609},
{0.481502,0.912883},
{0.426197,0.912466},
{0.3909,0.91279},
{0.362918,0.911837},
{0.317626,0.913561},
{0.603,0.996},
{0.692245,0.983215},
{0.651988,0.857836},
{0.594714,0.863768},
{0.526682,0.835921},
{0.475621,0.870488},
{0.6665,0.996},
{0.6909,0.996},
{0.736859,0.988227},
{0.731983,0.858213},
{0.679772,0.864243},
{0.65629,0.825715},
{0.583402,0.823402},
{0.550823,0.836245},
{0.539331,0.798518},
{0.510606,0.764349},
{0.511988,0.843594},
{0.486457,0.791694},
{0.453449,0.780498},
{0.438543,0.862978},
{0.422443,0.875533},
{0.363885,0.871315},
{0.395058,0.872538},
{0.388529,0.818118},
{0.317476,0.863517},
{0.419999,0.787095},
{0.366408,0.702689},
{0.333132,0.808069},
{0.800408,0.983824},
{0.7808,0.996},
{0.802201,0.858352},
{0.826085,0.84023},
{0.755351,0.832659},
{0.657076,0.810396},
{0.581364,0.805167},
{0.554532,0.821694},
{0.577994,0.787144},
{0.536632,0.72121},
{0.486475,0.648636},
{0.456697,0.716598},
{0.8159,0.9906},
{0.8438,0.996},
{0.853505,0.983665},
{0.862315,0.857806},
{0.856692,0.844456},
{0.829512,0.824237},
{0.755009,0.816205},
{0.656443,0.788355},
{0.903315,0.995959},
{0.918533,0.881729},
{0.929047,0.858427},
{0.857748,0.810919},
{0.829132,0.808184},
{0.752569,0.791306},
{0.687086,0.753222},
{0.661903,0.64078},
{0.638241,0.742144},
{0.596298,0.750148},
{0.554655,0.646738},
{0.51594,0.618108},
{0.45716,0.602183},
{0.42303,0.626598},
{0.42737,0.705473},
{0.984238,0.9837},
{0.9604,0.996},
{0.990848,0.894549},
{0.979212,0.809004},
{0.945628,0.648168},
{0.894819,0.686001},
{0.890725,0.674414},
{0.864758,0.68301},
{0.8247,0.719},
{0.811967,0.783753},
{0.771,0.7773},
{0.785596,0.754067},
{0.773235,0.640972},
{0.732712,0.75327},
{0.699105,0.604936},
{0.6729,0.5798},
{0.640863,0.60662},
{0.577824,0.617878},
{0.548725,0.566803},
{0.493152,0.540587},
{0.458746,0.505337},
{0.385158,0.568035},
{0.392033,0.595052},
{0.417895,0.643149},
{0.399272,0.672908},
{0.41517,0.750469},
{0.373254,0.676252},
{0.323581,0.670832},
{0.339373,0.729048},
{0.3169,0.716976},
{0.9961,0.996},
{0.993032,0.690582},
{0.9961,0.748586},
{0.975564,0.594066},
{0.946786,0.605987},
{0.903498,0.604333},
{0.851365,0.64933},
{0.9961,0.613614},
{0.9961,0.5862},
{0.9961,0.5688},
{0.952356,0.571315},
{0.9136,0.5552},
{0.8901,0.553},
{0.880027,0.543165},
{0.851875,0.571175},
{0.806552,0.619772},
{0.7866,0.5996},
{0.759014,0.606077},
{0.733093,0.537258},
{0.6772,0.5393},
{0.617962,0.5308},
{0.59069,0.554853},
{0.587153,0.495285},
{0.5488,0.4888},
{0.522,0.4922},
{0.492965,0.52081},
{0.7939,0.5598},
{0.755111,0.518348},
{0.754788,0.474939},
{0.732323,0.490889},
{0.6948,0.4609},
{0.6655,0.4585},
{0.62951,0.467915},
{0.612121,0.497541},
{0.845039,0.528685},
{0.814,0.5085},
{0.7866,0.5034},
{0.8633,0.5234},
{0.891676,0.504863},
{0.58399,0.463841},
{0.571908,0.432937},
{0.411713,0.488383},
{0.388283,0.50047},
{0.382779,0.476805},
{0.361625,0.541408},
{0.366858,0.565711},
{0.3877,0.6304},
{0.40004,0.620568},
{0.3853,0.6453},
{0.3435,0.6587},
{0.200706,0.988411},
{0.1575,0.9851},
{0.157271,0.969545},
{0.1348,0.9828},
{0.106879,0.972181},
{0.147904,0.930391},
{0.102688,0.892701},
{0.075389,0.97382},
{0.058898,0.891985},
{0.035759,0.936857},
{0.052371,0.98459},
{0.009593,0.99476},
{0.181461,0.891055},
{0.145218,0.884034},
{0.128125,0.869819},
{0.084731,0.869696},
{0.0511,0.8517},
{0.026503,0.853595},
{0.026226,0.887942},
{0.169954,0.84802},
{0.135129,0.804084},
{0.104227,0.812501},
{0.068376,0.816756},
{0.058997,0.776107},
{0.122053,0.763627},
{0.155572,0.78811},
{0.98851,0.026408},
{0.969528,0.131779},
{0.948233,0.037695},
{0.950324,0.145379},
{0.967107,0.186706},
{0.942344,0.235117},
{0.913757,0.202556},
{0.912408,0.252341},
{0.867551,0.20432},
{0.855085,0.24873},
{0.823382,0.187758},
{0.868647,0.190344},
{0.821807,0.142221},
{0.875794,0.130921},
{0.840373,0.026287},
{0.8076,0.082},
{0.800697,0.023338},
{0.9609,0.0161},
{0.921612,0.01303},
{0.905886,0.130588},
{0.917993,0.155586},
{0.867517,0.007254},
{0.259334,0.829865},
{0.287956,0.804149},
{0.293852,0.856905},
{0.241279,0.871025},
{0.249728,0.884963},
{0.293984,0.873513},
{0.250516,0.915872},
{0.299319,0.9299},
{0.304748,0.96718},
{0.240396,0.926473},
{0.264155,0.973228},
{0.28944,0.991887},
{0.304986,0.820756},
{0.1832,0.7012},
{0.188048,0.712668},
{0.1333,0.7168},
{0.1707,0.7334},
{0.144259,0.753099},
{0.138163,0.753859},
{0.121842,0.752609},
{0.117131,0.754362},
{0.0919,0.7261},
{0.080473,0.711158},
{0.090984,0.696404},
{0.113247,0.686959},
{0.1343,0.6875},
{0.158763,0.688704},
{0.959355,0.323139},
{0.961547,0.270323},
{0.984165,0.276806},
{0.983734,0.32214},
{0.991504,0.296775},
{0.991765,0.231641},
{0.968511,0.228749},
{0.94991,0.258915},
{0.903588,0.275859},
{0.90282,0.314},
{0.950338,0.333963},
{0.967835,0.36564},
{0.991195,0.362676},
{0.345002,0.602262},
{0.3396,0.6375},
{0.3132,0.6379},
{0.306213,0.602595},
{0.325157,0.578642},
{0.280729,0.596063},
{0.280697,0.579069},
{0.370296,0.59436},
{0.368524,0.577032},
{0.176899,0.634546},
{0.084464,0.686358},
{0.038603,0.654995},
{0.025671,0.687183},
{0.042563,0.723488},
{0.013092,0.703271},
{0.004073,0.642225},
{0.038665,0.634418},
{0.039822,0.602051},
{0.004769,0.584374},
{0.025696,0.556537},
{0.010514,0.53153},
{0.042729,0.513201},
{0.083391,0.55209},
{0.170257,0.597991},
{0.186636,0.612941},
{0.733049,0.420758},
{0.769113,0.361418},
{0.768138,0.404686},
{0.773982,0.42693},
{0.800825,0.41256},
{0.80486,0.373087},
{0.79251,0.266349},
{0.76745,0.30299},
{0.737063,0.35498},
{0.70378,0.359993},
{0.697706,0.423058},
{0.667079,0.394246},
{0.666,0.4141},
{0.6195,0.413646},
{0.624599,0.353455},
{0.670138,0.372231},
{0.691075,0.26373},
{0.649757,0.264081},
{0.663746,0.218034},
{0.682681,0.175904},
{0.711804,0.185473},
{0.709445,0.152928},
{0.68008,0.123534},
{0.714675,0.119623},
{0.710172,0.076827},
{0.740556,0.132996},
{0.755239,0.074941},
{0.764644,0.117147},
{0.7944,0.1016},
{0.767388,0.153003},
{0.805295,0.156968},
{0.79019,0.183234},
{0.780579,0.226819},
{0.8297,0.266339},
{0.849088,0.354187},
{0.849387,0.421754},
{0.705618,0.302478},
{0.738949,0.259005},
{0.71431,0.254952},
{0.746444,0.186232},
{0.76349,0.260597},
{0.60245,0.340929},
{0.6035,0.3936},
{0.589268,0.390809},
{0.574807,0.236492},
{0.549239,0.384384},
{0.548847,0.213123},
{0.517511,0.376479},
{0.514795,0.214287},
{0.488806,0.206893},
{0.460011,0.338734},
{0.4853,0.3936},
{0.6035,0.23013},
{0.597939,0.161062},
{0.581904,0.113606},
{0.529631,0.11735},
{0.476836,0.112038},
{0.463292,0.082929},
{0.459,0.231724},
{0.599344,0.098789},
{0.581875,0.057299},
{0.558077,0.087744},
{0.502047,0.0717},
{0.483238,0.046249},
{0.514583,0.00857},
{0.54893,0.056409},
{0.5576,0.0117},
{0.985558,0.429991},
{0.981298,0.484108},
{0.973668,0.453635},
{0.986802,0.410369},
{0.949754,0.426157},
{0.9289,0.462248},
{0.926833,0.496897},
{0.954979,0.498365},
{0.993183,0.510287},
{0.92523,0.544544},
{0.943822,0.556138},
{0.922212,0.379364},
{0.940726,0.365887},
{0.926221,0.427449},
{0.250005,0.768465},
{0.251829,0.803444},
{0.176614,0.772162},
{0.176645,0.74461},
{0.249309,0.742788},
{0.224419,0.714597},
{0.194039,0.71578},
{0.176612,0.803626},
{0.213386,0.884212},
{0.227942,0.874926},
{0.1938,0.8561},
{0.7316,0.014121},
{0.735484,0.037107},
{0.688023,0.044827},
{0.699241,0.05658},
{0.679635,0.097884},
{0.640642,0.096884},
{0.632127,0.045255},
{0.622255,0.057032},
{0.586059,0.034233},
{0.590185,0.011946},
{0.637869,0.016546},
{0.64655,0.009521},
{0.687686,0.018014},
{0.677262,0.00951},
{0.22935,0.578498},
{0.2581,0.5774},
{0.265605,0.608908},
{0.222418,0.608711},
{0.235239,0.6365},
{0.254673,0.635312},
{0.291309,0.63415},
{0.292797,0.617217},
{0.196534,0.636033},
{0.194913,0.620718},
{0.241612,0.642049},
{0.281353,0.641748},
{0.26,0.6716},
{0.3069,0.6548},
{0.309087,0.666865},
{0.291524,0.705983},
{0.2792,0.698418},
{0.240221,0.698372},
{0.229071,0.705019},
{0.210582,0.667654},
{0.2128,0.6541},
{0.176592,0.636593},
{0.087458,0.685078},
{0.107188,0.653723},
{0.036317,0.641611},
{0.025717,0.68725},
{0.042743,0.72339},
{0.013413,0.703747},
{0.003304,0.652988},
{0.004967,0.589662},
{0.038004,0.601739},
{0.025785,0.557479},
{0.010357,0.531751},
{0.043277,0.513424},
{0.082921,0.553306},
{0.162925,0.595221},
{0.18527,0.612403},
{0.771461,0.402722},
{0.755208,0.406667},
{0.745653,0.360618},
{0.726435,0.408591},
{0.70669,0.360587},
{0.698988,0.371074},
{0.7012,0.4077},
{0.66014,0.404061},
{0.669806,0.372473},
{0.618648,0.395526},
{0.623793,0.346861},
{0.691109,0.262456},
{0.649639,0.264263},
{0.6616,0.2285},
{0.699083,0.227531},
{0.680261,0.174417},
{0.730782,0.1838},
{0.709604,0.153006},
{0.680012,0.123729},
{0.714696,0.119991},
{0.710264,0.07698},
{0.74103,0.097778},
{0.757656,0.072578},
{0.764237,0.117254},
{0.7944,0.1016},
{0.767883,0.152899},
{0.804936,0.151956},
{0.796593,0.187661},
{0.762893,0.187931},
{0.792536,0.266044},
{0.830694,0.268584},
{0.850773,0.3478},
{0.804378,0.372135},
{0.80332,0.390909},
{0.855,0.3921},
{0.775499,0.358311},
{0.7373,0.309357},
{0.706574,0.298839},
{0.763675,0.260769},
{0.73596,0.257473},
{0.7407,0.143405},
{0.522243,0.384824},
{0.482369,0.3936},
{0.495914,0.345809},
{0.459,0.3687},
{0.4597,0.325385},
{0.490122,0.21045},
{0.459,0.235898},
{0.459,0.143873},
{0.469589,0.092686},
{0.518022,0.116305},
{0.500165,0.087162},
{0.483277,0.045725},
{0.511721,0.057458},
{0.514555,0.008578},
{0.5576,0.0117},
{0.566605,0.069318},
{0.587461,0.051319},
{0.599395,0.099392},
{0.582421,0.11345},
{0.596573,0.17085},
{0.549094,0.216771},
{0.574959,0.230966},
{0.6035,0.230468},
{0.601779,0.325848},
{0.589709,0.391817},
{0.6035,0.377124},
{0.5493,0.386275},
{0.514788,0.219631},
{0.54317,0.114547},
{0.985604,0.428647},
{0.980943,0.485242},
{0.973517,0.452699},
{0.986904,0.41021},
{0.9565,0.4189},
{0.926401,0.428503},
{0.928932,0.470449},
{0.955009,0.498906},
{0.993368,0.510314},
{0.925088,0.544262},
{0.944899,0.555325},
{0.922085,0.37933},
{0.940987,0.365951},
{0.926967,0.500725},
{0.249313,0.768851},
{0.249145,0.80566},
{0.176791,0.803714},
{0.175281,0.772234},
{0.176714,0.744492},
{0.249425,0.743059},
{0.229971,0.716675},
{0.196835,0.714738},
{0.213052,0.884131},
{0.227804,0.874893},
{0.1938,0.8561},
{0.731803,0.014192},
{0.735361,0.037314},
{0.689994,0.044854},
{0.70005,0.056193},
{0.67967,0.097929},
{0.633738,0.045212},
{0.640532,0.096867},
{0.622184,0.056978},
{0.586138,0.033803},
{0.590026,0.012003},
{0.639084,0.016569},
{0.645075,0.008701},
{0.682667,0.014449},
{0.222235,0.608756},
{0.229351,0.578497},
{0.2581,0.5774},
{0.266169,0.609115},
{0.253987,0.635367},
{0.291537,0.634126},
{0.292632,0.617064},
{0.23429,0.6365},
{0.196411,0.636025},
{0.193924,0.621691},
{0.241788,0.642211},
{0.281263,0.641765},
{0.26,0.6716},
{0.3069,0.6548},
{0.308828,0.667149},
{0.291524,0.70598},
{0.279179,0.698437},
{0.239315,0.698534},
{0.228948,0.704641},
{0.210716,0.667727},
{0.2128,0.6541},
{0.175449,0.634428},
{0.085106,0.685358},
{0.039913,0.647533},
{0.025865,0.685252},
{0.043186,0.723152},
{0.012812,0.702855},
{0.003378,0.65252},
{0.005027,0.591205},
{0.040597,0.60446},
{0.025027,0.555798},
{0.010071,0.532154},
{0.043176,0.513383},
{0.083208,0.553037},
{0.185621,0.615384},
{0.175375,0.597611},
{0.775644,0.358141},
{0.754371,0.403303},
{0.74532,0.360233},
{0.734424,0.277902},
{0.70654,0.298969},
{0.708748,0.364477},
{0.708006,0.404087},
{0.676577,0.400478},
{0.666948,0.375313},
{0.642671,0.390214},
{0.623974,0.347145},
{0.6177,0.3872},
{0.625204,0.404766},
{0.818195,0.37493},
{0.79236,0.265288},
{0.763666,0.262129},
{0.733294,0.253275},
{0.688573,0.260569},
{0.649758,0.264096},
{0.669407,0.193659},
{0.696648,0.18181},
{0.682806,0.139411},
{0.723229,0.156081},
{0.714914,0.12039},
{0.704213,0.081717},
{0.736438,0.089452},
{0.758647,0.072837},
{0.76486,0.117476},
{0.7944,0.1016},
{0.766981,0.153088},
{0.804838,0.148663},
{0.797977,0.194456},
{0.746092,0.18547},
{0.780714,0.226829},
{0.830225,0.267828},
{0.8511,0.3472},
{0.855,0.3921},
{0.740527,0.122787},
{0.592905,0.353241},
{0.594631,0.393285},
{0.549256,0.386603},
{0.576518,0.216387},
{0.548937,0.21689},
{0.52228,0.386497},
{0.514907,0.22099},
{0.473574,0.376132},
{0.488185,0.208377},
{0.460623,0.32563},
{0.459,0.23435},
{0.459004,0.156119},
{0.470746,0.093702},
{0.526241,0.118823},
{0.501742,0.073391},
{0.483059,0.045418},
{0.513671,0.008837},
{0.54927,0.056431},
{0.562409,0.016509},
{0.569032,0.07514},
{0.5928,0.0615},
{0.590803,0.119326},
{0.6035,0.229606},
{0.6035,0.3242},
{0.985703,0.429601},
{0.980376,0.478855},
{0.973742,0.452584},
{0.98632,0.410397},
{0.952134,0.424497},
{0.928429,0.467898},
{0.930792,0.499041},
{0.988304,0.509145},
{0.925392,0.544686},
{0.944249,0.555936},
{0.921916,0.379149},
{0.940821,0.365973},
{0.927334,0.428202},
{0.250073,0.768928},
{0.252084,0.803234},
{0.176609,0.772501},
{0.176944,0.744276},
{0.249208,0.742551},
{0.229532,0.716761},
{0.197614,0.714393},
{0.176536,0.803589},
{0.228873,0.872225},
{0.204397,0.876963},
{0.2151,0.8851},
{0.73207,0.014233},
{0.735464,0.037233},
{0.688331,0.044834},
{0.700005,0.056215},
{0.677806,0.098181},
{0.639311,0.096615},
{0.631976,0.045222},
{0.621987,0.056828},
{0.58595,0.034217},
{0.59011,0.011962},
{0.642158,0.013272},
{0.682844,0.014453},
{0.2288,0.5786},
{0.256759,0.577264},
{0.222315,0.608815},
{0.266138,0.609104},
{0.25443,0.635301},
{0.291845,0.634092},
{0.292726,0.617152},
{0.235354,0.6365},
{0.19648,0.636029},
{0.194859,0.620771},
{0.243925,0.641827},
{0.281249,0.64178},
{0.26,0.6716},
{0.3069,0.6548},
{0.309045,0.666911},
{0.291091,0.705562},
{0.267676,0.6978},
{0.239954,0.69842},
{0.229075,0.705032},
{0.210531,0.667626},
{0.212735,0.654121},
{0.17964,0.633611},
{0.08414,0.686126},
{0.075677,0.654214},
{0.032636,0.653301},
{0.026087,0.685208},
{0.042888,0.723313},
{0.013135,0.703335},
{0.004179,0.64266},
{0.033661,0.621899},
{0.031048,0.583504},
{0.004758,0.584168},
{0.02329,0.549525},
{0.010049,0.532185},
{0.042478,0.513099},
{0.083158,0.552763},
{0.077133,0.598104},
{0.172069,0.598369},
{0.186094,0.614135},
{0.806601,0.374399},
{0.797488,0.401171},
{0.771645,0.36039},
{0.792334,0.265198},
{0.768161,0.306466},
{0.736954,0.357958},
{0.752154,0.399579},
{0.76758,0.417669},
{0.727558,0.425943},
{0.719965,0.397193},
{0.692026,0.417773},
{0.702437,0.362334},
{0.6675,0.4058},
{0.668848,0.37199},
{0.6392,0.4072},
{0.619503,0.406302},
{0.623887,0.347009},
{0.691065,0.266088},
{0.650632,0.262747},
{0.694527,0.252924},
{0.6616,0.2285},
{0.680578,0.174471},
{0.711651,0.183392},
{0.683556,0.139808},
{0.72384,0.156103},
{0.714839,0.120287},
{0.70496,0.082371},
{0.740494,0.121456},
{0.754746,0.074605},
{0.76467,0.117822},
{0.7944,0.1016},
{0.767401,0.153},
{0.797222,0.166098},
{0.745769,0.184916},
{0.763543,0.258233},
{0.812948,0.214542},
{0.829631,0.266696},
{0.849357,0.355263},
{0.842,0.40662},
{0.70608,0.300721},
{0.739144,0.256778},
{0.5747,0.349318},
{0.596874,0.392687},
{0.549285,0.3857},
{0.575065,0.229077},
{0.549158,0.220185},
{0.517965,0.380102},
{0.514758,0.217519},
{0.491561,0.214338},
{0.45972,0.339333},
{0.4924,0.3936},
{0.459,0.3936},
{0.601804,0.325824},
{0.6035,0.226505},
{0.595102,0.171159},
{0.5483,0.1782},
{0.5146,0.1768},
{0.466941,0.160118},
{0.459,0.23275},
{0.488663,0.099361},
{0.463626,0.07939},
{0.483096,0.045036},
{0.504948,0.061448},
{0.515266,0.008369},
{0.551127,0.059447},
{0.562215,0.016315},
{0.572605,0.072417},
{0.5928,0.0615},
{0.599531,0.100139},
{0.582157,0.11422},
{0.529868,0.116579},
{0.528806,0.076387},
{0.985451,0.430222},
{0.981555,0.484857},
{0.973422,0.451123},
{0.973012,0.415197},
{0.926156,0.427743},
{0.928637,0.462305},
{0.926756,0.496766},
{0.955015,0.499011},
{0.993323,0.510436},
{0.925243,0.54483},
{0.943618,0.556394},
{0.991764,0.409576},
{0.940769,0.365895},
{0.922122,0.379046},
{0.249283,0.769},
{0.252217,0.803124},
{0.176602,0.803621},
{0.175481,0.771658},
{0.177114,0.744258},
{0.249325,0.742825},
{0.224438,0.714935},
{0.193957,0.71588},
{0.214038,0.884534},
{0.2269,0.877149},
{0.1938,0.8561},
{0.73165,0.014162},
{0.735468,0.037127},
{0.688113,0.044831},
{0.699255,0.056574},
{0.678171,0.098046},
{0.639311,0.096615},
{0.631985,0.045224},
{0.622241,0.057022},
{0.585843,0.034172},
{0.590308,0.011931},
{0.638573,0.016598},
{0.646518,0.009472},
{0.687642,0.01802},
{0.677292,0.009491},
{0.2288,0.5786},
{0.257063,0.577295},
{0.265576,0.608907},
{0.222409,0.608717},
{0.235219,0.6365},
{0.25469,0.635313},
{0.291361,0.634145},
{0.292805,0.617224},
{0.196618,0.636038},
{0.194882,0.620748},
{0.241391,0.64227},
{0.281151,0.641762},
{0.26,0.6716},
{0.3069,0.6548},
{0.309082,0.66687},
{0.291523,0.705986},
{0.278814,0.698402},
{0.240405,0.698339},
{0.229029,0.704891},
{0.210587,0.667657},
{0.2128,0.6541},
{0.075203,0.438657},
{0.050938,0.422645},
{0.07462,0.420594},
{0.244278,0.139659},
{0.064698,0.207768},
{0.025103,0.105303},
{0.195698,0.098316},
{0.161031,0.045212},
{0.004611,0.036327},
{0.025101,0.105303},
{0.195689,0.098315},
{0.244276,0.139659},
{0.064698,0.207769},
{0.289147,0.102344},
{0.273847,0.131716},
{0.289275,0.099918},
{0.273847,0.131716},
{0.393514,0.460169},
{0.428212,0.453271},
{0.413494,0.425359},
{0.362454,0.445699},
{0.415051,0.392859},
{0.443082,0.413641},
{0.460211,0.420258},
{0.461976,0.444372},
{0.495979,0.414464},
{0.504148,0.36061},
{0.548156,0.365066},
{0.327119,0.467788},
{0.251396,0.49263},
{0.325941,0.497502},
{0.309394,0.428643},
{0.343366,0.419642},
{0.36754,0.37661},
{0.464531,0.345313},
{0.47009,0.379793},
{0.311886,0.386677},
{0.314401,0.375548},
{0.32461,0.329162},
{0.401458,0.320736},
{0.264676,0.393981},
{0.244438,0.338544},
{0.270325,0.338508},
{0.171847,0.4451},
{0.232572,0.381895},
{0.141624,0.428979},
{0.123344,0.461308},
{0.119668,0.45221},
{0.101546,0.461192},
{0.111725,0.511472},
{0.090895,0.473957},
{0.110848,0.511592},
{0.090794,0.474246},
{0.101547,0.461192},
{0.123344,0.461308},
{0.119667,0.45221},
{0.141624,0.428979},
{0.171847,0.445102},
{0.263862,0.394807},
{0.216828,0.358398},
{0.175775,0.387825},
{0.151387,0.384379},
{0.167577,0.345584},
{0.154218,0.361992},
{0.23917,0.443305},
{0.168822,0.512905},
{0.235337,0.517841},
{0.173374,0.583605},
{0.113292,0.551399},
{0.365207,0.312187},
{0.210813,0.577384},
{0.241218,0.575707},
{0.295687,0.537651},
{0.16882,0.512909},
{0.239168,0.443314},
{0.309393,0.428643},
{0.311897,0.386685},
{0.244438,0.338544},
{0.168665,0.601074},
{0.173374,0.583605},
{0.235337,0.517843},
{0.2514,0.492629},
{0.327118,0.467787},
{0.343367,0.419642},
{0.314413,0.37556},
{0.270325,0.338508},
{0.58979,0.11531},
{0.744512,0.131313},
{0.74193,0.084908},
{0.585006,0.07921},
{0.677202,0.035441},
{0.761531,0.032762},
{0.665256,0.016685},
{0.569703,0.017594},
{0.539375,0.039003},
{0.504909,0.022525},
{0.432822,0.030513},
{0.384823,0.048192},
{0.358336,0.037144},
{0.294104,0.042366},
{0.413616,0.046593},
{0.358336,0.037144},
{0.432822,0.030513},
{0.539389,0.039004},
{0.504909,0.022525},
{0.569703,0.017594},
{0.677205,0.035437},
{0.665256,0.016685},
{0.761531,0.032762},
{0.741948,0.08491},
{0.544157,0.079193},
{0.589785,0.11531},
{0.74451,0.131309},
{0.461134,0.081369},
{0.405185,0.126143},
{0.333316,0.092713},
{0.404135,0.08523},
{0.313167,0.132477},
{0.416109,0.125319},
{0.866735,0.523795},
{0.848715,0.611873},
{0.959178,0.554852},
{0.976353,0.412019},
{0.882751,0.407799},
{0.89121,0.343842},
{0.982609,0.357041},
{0.981928,0.406103},
{0.931725,0.740471},
{0.831595,0.703642},
{0.828856,0.675278},
{0.820793,0.699915},
{0.95066,0.740439},
{0.95298,0.64915},
{0.873347,0.463322},
{0.864812,0.503342},
{0.889942,0.259008},
{0.983308,0.279902},
{0.985504,0.189887},
{0.889849,0.165422},
{0.982665,0.267949},
{0.889942,0.259008},
{0.982609,0.357041},
{0.891211,0.343842},
{0.976353,0.412027},
{0.981928,0.406103},
{0.971094,0.057172},
{0.924697,0.060875},
{0.950982,0.126193},
{0.959576,0.056701},
{0.924697,0.060876},
{0.91361,0.124552},
{0.943905,0.152052},
{0.91361,0.124552},
{0.906712,0.074047},
{0.864591,0.057717},
{0.917774,0.042576},
{0.978922,0.03792},
{0.917768,0.042577},
{0.864593,0.057719},
{0.906712,0.074048},
{0.840676,0.084627},
{0.845071,0.136633},
{0.856302,0.150114},
{0.910247,0.145832},
{0.800826,0.062243},
{0.79122,0.080981},
{0.864117,0.047273},
{0.917077,0.020788},
{0.975645,0.013802},
{0.917077,0.020788},
{0.864117,0.047273},
{0.800827,0.062243},
{0.79122,0.080982},
{0.796217,0.088533},
{0.910247,0.145832},
{0.856301,0.150115},
{0.845071,0.136633},
{0.840676,0.084627},
{0.796217,0.088534},
{0.819905,0.139421},
{0.798995,0.216528},
{0.787589,0.224734},
{0.771261,0.222287},
{0.786951,0.12968},
{0.770793,0.183822},
{0.156542,0.603973},
{0.185118,0.64691},
{0.173133,0.652185},
{0.186472,0.721724},
{0.117882,0.756214},
{0.151259,0.820847},
{0.16956,0.788743},
{0.166574,0.817213},
{0.189006,0.872105},
{0.123112,0.936931},
{0.212713,0.918365},
{0.212304,0.87276},
{0.026725,0.729079},
{0.029027,0.644167},
{0.057638,0.610894},
{0.091606,0.67795},
{0.116467,0.600592},
{0.065597,0.774965},
{0.026361,0.807431},
{0.024752,0.920476},
{0.095746,0.860197},
{0.049448,0.93664},
{0.121691,0.971215},
{0.195087,0.964268},
{0.131261,0.993661},
{0.017975,0.789615},
{0.010532,0.922144},
{0.171521,0.292293},
{0.176314,0.306596},
{0.188092,0.29564},
{0.175839,0.270989},
{0.215306,0.286161},
{0.223322,0.314514},
{0.206947,0.322663},
{0.188118,0.333714},
{0.175752,0.333837},
{0.167515,0.308711},
{0.155176,0.270995},
{0.169189,0.246238},
{0.182699,0.255216},
{0.226003,0.25141},
{0.293793,0.293863},
{0.264405,0.307491},
{0.229226,0.227585},
{0.346175,0.294107},
{0.233903,0.189009},
{0.30698,0.23343},
{0.352767,0.244151},
{0.370077,0.29162},
{0.393838,0.299257},
{0.265301,0.19437},
{0.203357,0.176443},
{0.1846,0.200793},
{0.172771,0.220164},
{0.149138,0.265016},
{0.176529,0.271383},
{0.169379,0.246073},
{0.183956,0.256064},
{0.172771,0.220164},
{0.223365,0.249676},
{0.22765,0.226622},
{0.1846,0.200793},
{0.203357,0.176443},
{0.235586,0.190748},
{0.266672,0.222778},
{0.265301,0.19437},
{0.306901,0.23337},
{0.346679,0.29466},
{0.370077,0.29162},
{0.352596,0.243801},
{0.393838,0.299257},
{0.174977,0.331483},
{0.188092,0.29564},
{0.206947,0.322663},
{0.176314,0.306596},
{0.171521,0.292293},
{0.188118,0.333714},
{0.215306,0.286162},
{0.293793,0.293863},
{0.223322,0.314514},
{0.264405,0.307491},
{0.407928,0.956764},
{0.367163,0.974343},
{0.317936,0.973464},
{0.348074,0.88337},
{0.238633,0.879074},
{0.217226,0.831574},
{0.318376,0.779697},
{0.327869,0.843534},
{0.243026,0.886566},
{0.355265,0.899874},
{0.317935,0.973462},
{0.407929,0.956761},
{0.367163,0.974343},
{0.389403,0.79136},
{0.392828,0.800359},
{0.445684,0.895739},
{0.518112,0.945003},
{0.534361,0.902849},
{0.594678,0.949437},
{0.62689,0.910987},
{0.683633,0.96116},
{0.717065,0.911195},
{0.782377,0.969728},
{0.804106,0.899811},
{0.868813,0.968116},
{0.894526,0.931573},
{0.865318,0.835337},
{0.920118,0.867025},
{0.951306,0.866984},
{0.921196,0.780505},
{0.991928,0.785385},
{0.918425,0.851755},
{0.945366,0.877708},
{0.894524,0.931573},
{0.865318,0.835335},
{0.804107,0.899813},
{0.868815,0.968116},
{0.782349,0.969728},
{0.717064,0.911187},
{0.683624,0.961159},
{0.626889,0.910979},
{0.594666,0.949436},
{0.534361,0.90285},
{0.518105,0.945005},
{0.445689,0.895735},
{0.494858,0.810192},
{0.417226,0.764624},
{0.420314,0.774199},
{0.494857,0.810192},
{0.603956,0.814724},
{0.706724,0.82062},
{0.791707,0.82426},
{0.775769,0.767202},
{0.825668,0.741057},
{0.506815,0.715396},
{0.48144,0.790263},
{0.592167,0.810874},
{0.605941,0.753344},
{0.593667,0.699547},
{0.51249,0.78549},
{0.60594,0.753344},
{0.730987,0.704825},
{0.747655,0.764172},
{0.70673,0.820618},
{0.791704,0.82426},
{0.81999,0.325122},
{0.782621,0.367486},
{0.749109,0.233655},
{0.881639,0.300044},
{0.448307,0.294536},
{0.34229,0.219789},
{0.427532,0.159548},
{0.318442,0.154831},
{0.248954,0.154162},
{0.550597,0.345518},
{0.543448,0.167534},
{0.657451,0.173156},
{0.689222,0.279788},
{0.647387,0.376011},
{0.07437,0.540639},
{0.083824,0.52406},
{0.072841,0.500577},
{0.051697,0.547501},
{0.072854,0.499683},
{0.010989,0.515673},
{0.026574,0.446155},
{0.069143,0.462429},
{0.066439,0.427799},
{0.0254,0.392249},
{0.047064,0.400345},
{0.076088,0.382773},
{0.081826,0.362057},
{0.119556,0.313473},
{0.094434,0.350301},
{0.113938,0.34305},
{0.052771,0.317369},
{0.012074,0.359225},
{0.119942,0.273175},
{0.072971,0.291239},
{0.114049,0.233583},
{0.334204,0.538027},
{0.384923,0.496766},
{0.354648,0.566602},
{0.313244,0.601128},
{0.349534,0.639581},
{0.383015,0.624921},
{0.37601,0.59607},
{0.377333,0.540187},
{0.383928,0.51375},
{0.435737,0.502662},
{0.429702,0.472925},
{0.485827,0.450679},
{0.505121,0.49631},
{0.53377,0.514574},
{0.524915,0.434798},
{0.558094,0.489529},
{0.587267,0.41061},
{0.604769,0.458667},
{0.643529,0.40046},
{0.67565,0.458774},
{0.736443,0.402213},
{0.751317,0.471273},
{0.81165,0.398941},
{0.810826,0.470508},
{0.751317,0.471273},
{0.736441,0.402214},
{0.675644,0.458774},
{0.643529,0.40046},
{0.604768,0.458666},
{0.587285,0.410604},
{0.558094,0.489529},
{0.524915,0.434798},
{0.533769,0.514573},
{0.485826,0.450679},
{0.505121,0.49631},
{0.435736,0.502662},
{0.429702,0.472925},
{0.384923,0.496766},
{0.383928,0.51375},
{0.354649,0.566601},
{0.334205,0.538026},
{0.313244,0.60113},
{0.349528,0.639578},
{0.308215,0.656629},
{0.301415,0.618692},
{0.285803,0.709217},
{0.330125,0.700173},
{0.406893,0.710614},
{0.436024,0.641452},
{0.484925,0.668002},
{0.44867,0.700328},
{0.489949,0.680561},
{0.549498,0.657777},
{0.564572,0.644591},
{0.627169,0.639557},
{0.62131,0.62529},
{0.689048,0.631749},
{0.707374,0.618647},
{0.776956,0.651488},
{0.791103,0.627177},
{0.70737,0.618647},
{0.69661,0.636309},
{0.627169,0.639558},
{0.621309,0.62529},
{0.564563,0.644593},
{0.549495,0.657778},
{0.484925,0.668002},
{0.489949,0.680561},
{0.448669,0.70033},
{0.406897,0.710617},
{0.436024,0.641452},
{0.330125,0.700173},
{0.308215,0.656629},
{0.285803,0.709217},
{0.301416,0.61869},
{0.427622,0.520404},
{0.410071,0.561336},
{0.449205,0.572935},
{0.473395,0.549322},
{0.479721,0.533845},
{0.466004,0.600155},
{0.482873,0.600431},
{0.518638,0.536982},
{0.491154,0.645202},
{0.544177,0.59386},
{0.55746,0.566186},
{0.535119,0.536268},
{0.538838,0.632266},
{0.564809,0.618609},
{0.611086,0.545011},
{0.602089,0.468704},
{0.684742,0.542943},
{0.748556,0.541723},
{0.804279,0.545756},
{0.748555,0.541726},
{0.684742,0.542946},
{0.602087,0.468704},
{0.611086,0.545042},
{0.418337,0.626795},
{0.222395,0.726661},
{0.232516,0.789959},
{0.247377,0.728133},
{0.225542,0.670731},
{0.257077,0.678249},
{0.254345,0.619531},
{0.268253,0.602076},
{0.267792,0.659576},
{0.301262,0.585932},
{0.303672,0.564702},
{0.206782,0.728452},
{0.21041,0.781415},
{0.197157,0.678688},
{0.32461,0.329162},
{0.367537,0.376614},
{0.41505,0.39286},
{0.464535,0.345316},
{0.401458,0.320736},
{0.365207,0.312187},
{0.443082,0.413641},
{0.413495,0.425359},
{0.362454,0.4457},
{0.39353,0.460105},
{0.428212,0.453271},
{0.460212,0.420257},
{0.504147,0.360608},
{0.47009,0.379793},
{0.325941,0.497501},
{0.295687,0.537651},
{0.241218,0.575707},
{0.210813,0.577384},
{0.495904,0.414901},
{0.461978,0.444378},
{0.548156,0.365066},
{0.866739,0.523777},
{0.864813,0.503343},
{0.873347,0.463322},
{0.882756,0.407797},
{0.848715,0.611872},
{0.931725,0.74047},
{0.831595,0.703642},
{0.828856,0.675278},
{0.820793,0.699915},
{0.959181,0.554849},
{0.95298,0.64915},
{0.95066,0.740439},
{0.518636,0.53698},
{0.47972,0.533844},
{0.42762,0.520404},
{0.377333,0.540187},
{0.37601,0.596069},
{0.383018,0.624924},
{0.418337,0.626795},
{0.466014,0.60014},
{0.482873,0.600431},
{0.491154,0.645202},
{0.538839,0.632268},
{0.564809,0.618609},
{0.557461,0.566182},
{0.535119,0.536268},
{0.544177,0.59386},
{0.473395,0.549322},
{0.449204,0.572938},
{0.410073,0.561335},
{0.026358,0.807431},
{0.010532,0.922144},
{0.024752,0.920476},
{0.065595,0.774977},
{0.095746,0.860197},
{0.049448,0.93664},
{0.12169,0.971216},
{0.123112,0.936931},
{0.212721,0.918361},
{0.195073,0.964276},
{0.131261,0.993661},
{0.017975,0.789615},
{0.026724,0.729082},
{0.091604,0.677957},
{0.117885,0.7562},
{0.151259,0.820847},
{0.029027,0.644167},
{0.057639,0.610894},
{0.116465,0.600591},
{0.173135,0.652183},
{0.186472,0.721724},
{0.16956,0.788743},
{0.166574,0.817213},
{0.189006,0.872104},
{0.212304,0.87276},
{0.156542,0.603973},
{0.185118,0.646913},
{0.819907,0.139417},
{0.798994,0.216529},
{0.787589,0.224734},
{0.771261,0.222286},
{0.786952,0.129678},
{0.770793,0.183822},
{0.782622,0.36749},
{0.81999,0.325122},
{0.749098,0.233649},
{0.881639,0.300044},
{0.6892,0.279788},
{0.657451,0.173156},
{0.550583,0.345509},
{0.543448,0.167535},
{0.427526,0.159548},
{0.448298,0.29453},
{0.342261,0.219768},
{0.31844,0.15483},
{0.248957,0.154164},
{0.647377,0.37601},
{0.094434,0.350301},
{0.081826,0.362057},
{0.119733,0.313302},
{0.113938,0.34305},
{0.043084,0.374115},
{0.076088,0.382773},
{0.021303,0.396712},
{0.066563,0.42776},
{0.026574,0.446155},
{0.069079,0.462428},
{0.018556,0.491658},
{0.083824,0.52406},
{0.074234,0.540593},
{0.050938,0.579748},
{0.075166,0.563747},
{0.055558,0.316362},
{0.012074,0.359225},
{0.119942,0.273175},
{0.072971,0.291239},
{0.114135,0.233268},
{0.222395,0.726661},
{0.247377,0.728133},
{0.232517,0.789959},
{0.206782,0.728452},
{0.21041,0.781415},
{0.225542,0.670731},
{0.257076,0.678247},
{0.254343,0.619531},
{0.197157,0.678688},
{0.267792,0.659576},
{0.268253,0.602075},
{0.301262,0.585932},
{0.303672,0.564701},
{0.216417,0.357441},
{0.175775,0.387825},
{0.167576,0.345584},
{0.151387,0.384377},
{0.154218,0.361992},
{0.075203,0.563736},
{0.075166,0.438646},
{0.074852,0.420599},
{0.439728,0.44995},
{0.541843,0.370784},
{0.565844,0.52134},
{0.564845,0.928596},
{0.717087,0.668997},
{0.758604,0.941527},
{0.918725,0.977994},
{0.936613,0.779733},
{0.975124,0.945713},
{0.315978,0.599006},
{0.362668,0.504477},
{0.26254,0.675297},
{0.354385,0.91618},
{0.071008,0.900642},
{0.210291,0.707038},
{0.116667,0.740604},
{0.059564,0.75336},
{0.116667,0.740604},
{0.210291,0.707038},
{0.26254,0.675297},
{0.354368,0.916179},
{0.439794,0.451546},
{0.564845,0.928596},
{0.566001,0.521501},
{0.717087,0.668997},
{0.758604,0.941527},
{0.918725,0.977994},
{0.936612,0.779732},
{0.975124,0.945713},
{0.362668,0.504477},
{0.315978,0.599006},
{0.541843,0.370784},
{0.47029,0.203959},
{0.148256,0.35176},
{0.460782,0.286122},
{0.757825,0.241795},
{0.807475,0.239468},
{0.833744,0.088418},
{0.539822,0.701441},
{0.759746,0.565904},
{0.780976,0.423108},
{0.539822,0.701441},
{0.524246,0.630513},
{0.780976,0.423108},
{0.757825,0.241795},
{0.726939,0.11851},
{0.833744,0.088418},
{0.47029,0.203959},
{0.460782,0.286122},
{0.148256,0.35176},
{0.47029,0.203959},
{0.460782,0.286122},
{0.757825,0.241795},
{0.757825,0.241795},
{0.726939,0.11851},
{0.47029,0.203959},
{0.833744,0.088418},
{0.726939,0.11851},
{0.757825,0.241795},
{0.833744,0.088418},
{0.807475,0.239468},
{0.965199,0.084981},
{0.931511,0.395502},
{0.965199,0.084981},
{0.807475,0.239468},
{0.807475,0.239468},
{0.780976,0.423108},
{0.931511,0.395502},
{0.893719,0.453358},
{0.931511,0.395502},
{0.780976,0.423108},
{0.759746,0.565904},
{0.893719,0.453358},
{0.780976,0.423108},
{0.780976,0.423108},
{0.524246,0.630513},
{0.539822,0.701441},
{0.539822,0.701441},
{0.524246,0.630513},
{0.147768,0.89881},
{0.539822,0.701441},
{0.147768,0.89881},
{0.524246,0.630513},
{0.780976,0.423108},
{0.759746,0.565904},
{0.539822,0.701441},
{0.759746,0.565904},
{0.780976,0.423108},
{0.893719,0.453358},
{0.893719,0.453358},
{0.780976,0.423108},
{0.931511,0.395502},
{0.931511,0.395502},
{0.780976,0.423108},
{0.807475,0.239468},
{0.807475,0.239468},
{0.965199,0.084981},
{0.931511,0.395502},
{0.833744,0.088418},
{0.965199,0.084981},
{0.807475,0.239468},
{0.833744,0.088418},
{0.807475,0.239468},
{0.757825,0.241795},
{0.47029,0.203959},
{0.726939,0.11851},
{0.757825,0.241795},
{0.757825,0.241795},
{0.460782,0.286122},
{0.47029,0.203959},
{0.863992,0.93727},
{0.861035,0.977741},
{0.856953,0.96514},
{0.851382,0.980356},
{0.849599,0.990319},
{0.863566,0.987797},
{0.820056,0.987076},
{0.846773,0.956788},
{0.817801,0.950194},
{0.788822,0.985809},
{0.789388,0.945328},
{0.752739,0.943016},
{0.75668,0.979764},
{0.751313,0.98467},
{0.710205,0.977904},
{0.712416,0.94952},
{0.659395,0.9241},
{0.731515,0.915472},
{0.641312,0.913922},
{0.617241,0.924136},
{0.556507,0.917408},
{0.528249,0.925934},
{0.512249,0.909897},
{0.530731,0.884518},
{0.643943,0.876179},
{0.610318,0.84572},
{0.555712,0.850362},
{0.789579,0.906813},
{0.746864,0.905193},
{0.703324,0.866818},
{0.678027,0.818277},
{0.653116,0.817029},
{0.631414,0.819154},
{0.857675,0.933908},
{0.828191,0.899235},
{0.873893,0.900604},
{0.864501,0.893089},
{0.826934,0.856293},
{0.788029,0.902204},
{0.758237,0.873524},
{0.730109,0.825073},
{0.70625,0.794467},
{0.744015,0.79523},
{0.791021,0.810663},
{0.774526,0.761842},
{0.820876,0.771093},
{0.828208,0.813556},
{0.854033,0.782639},
{0.845954,0.749127},
{0.887663,0.799009},
{0.86389,0.813906},
{0.883308,0.813531},
{0.912753,0.839928},
{0.967436,0.829704},
{0.964745,0.853299},
{0.981139,0.827327},
{0.99051,0.8663},
{0.982941,0.871141},
{0.9532,0.854046},
{0.931076,0.846752},
{0.91341,0.847562},
{0.881411,0.862622},
{0.90349,0.861191},
{0.88919,0.872674},
{0.801224,0.852947},
{0.837398,0.850297},
{0.202524,0.189377},
{0.271958,0.21095},
{0.276311,0.334726},
{0.194724,0.280285},
{0.235219,0.363821},
{0.291773,0.358448},
{0.360848,0.3588},
{0.334022,0.319999},
{0.343813,0.25006},
{0.308971,0.186059},
{0.274244,0.154399},
{0.241249,0.14802},
{0.189685,0.136695},
{0.170214,0.125187},
{0.094164,0.166528},
{0.092249,0.213248},
{0.1541,0.295571},
{0.181655,0.379428},
{0.191231,0.407868},
{0.256173,0.40285},
{0.310252,0.36923},
{0.391007,0.378604},
{0.412628,0.360549},
{0.409721,0.31999},
{0.393087,0.24976},
{0.34478,0.161957},
{0.295154,0.15694},
{0.186268,0.129933},
{0.231286,0.439579},
{0.188674,0.452952},
{0.119565,0.448262},
{0.152055,0.533318},
{0.190968,0.51779},
{0.233471,0.478622},
{0.270306,0.449321},
{0.458343,0.352371},
{0.482303,0.315624},
{0.434136,0.239261},
{0.37953,0.149541},
{0.323813,0.471279},
{0.351016,0.410017},
{0.392311,0.418502},
{0.44018,0.427777},
{0.466658,0.382035},
{0.464679,0.363476},
{0.493944,0.386273},
{0.501333,0.380246},
{0.502363,0.320155},
{0.504254,0.274082},
{0.492512,0.275197},
{0.461622,0.21473},
{0.423165,0.148928},
{0.011809,0.506041},
{0.099809,0.504849},
{0.060261,0.535592},
{0.02906,0.58118},
{0.076784,0.54878},
{0.101304,0.544492},
{0.102212,0.527217},
{0.078112,0.476969},
{0.011742,0.46823},
{0.053896,0.434679},
{0.010325,0.437188},
{0.013801,0.365114},
{0.052297,0.366968},
{0.087793,0.330107},
{0.015199,0.318854},
{0.052152,0.265521},
{0.015947,0.286498},
{0.016976,0.250918},
{0.051933,0.200782},
{0.01868,0.195805},
{0.051012,0.159274},
{0.020304,0.128298},
{0.045522,0.064963},
{0.022231,0.063571},
{0.39676,0.498445},
{0.473943,0.488105},
{0.471287,0.437243},
{0.382573,0.526367},
{0.426782,0.531714},
{0.504396,0.531923},
{0.49837,0.450974},
{0.50741,0.45756},
{0.551081,0.40915},
{0.549972,0.370393},
{0.546361,0.325473},
{0.542757,0.280704},
{0.56895,0.252653},
{0.506667,0.242745},
{0.499997,0.241797},
{0.50678,0.214723},
{0.497298,0.177609},
{0.469059,0.142803},
{0.424208,0.560212},
{0.360849,0.56093},
{0.428987,0.591575},
{0.454839,0.554118},
{0.477415,0.571654},
{0.524856,0.633206},
{0.512862,0.528712},
{0.573995,0.537607},
{0.583298,0.494304},
{0.55158,0.451388},
{0.597509,0.421572},
{0.605714,0.385961},
{0.614568,0.342346},
{0.612006,0.297595},
{0.631016,0.259576},
{0.635572,0.224938},
{0.592412,0.23188},
{0.547738,0.234447},
{0.322907,0.52935},
{0.274312,0.521149},
{0.278153,0.549766},
{0.323395,0.554673},
{0.352901,0.604924},
{0.411501,0.636874},
{0.439562,0.631276},
{0.502009,0.640115},
{0.233472,0.522637},
{0.221861,0.544805},
{0.206363,0.550967},
{0.264513,0.570852},
{0.312303,0.599856},
{0.351238,0.65501},
{0.383006,0.648091},
{0.556692,0.563846},
{0.564527,0.633064},
{0.601312,0.561186},
{0.630198,0.509198},
{0.60795,0.463647},
{0.633833,0.433882},
{0.65996,0.407077},
{0.672912,0.363394},
{0.687462,0.319712},
{0.701074,0.273251},
{0.686154,0.216202},
{0.742536,0.29332},
{0.71291,0.325248},
{0.73233,0.340785},
{0.769139,0.33555},
{0.728116,0.424484},
{0.739637,0.410068},
{0.743702,0.460082},
{0.721508,0.494393},
{0.744084,0.503895},
{0.711096,0.526339},
{0.74202,0.537954},
{0.738156,0.570245},
{0.702381,0.555478},
{0.735958,0.584987},
{0.689356,0.581027},
{0.735306,0.594853},
{0.321715,0.673853},
{0.309526,0.638337},
{0.241017,0.606369},
{0.287021,0.664514},
{0.287926,0.692811},
{0.244884,0.712184},
{0.185418,0.677434},
{0.186559,0.73983},
{0.114411,0.710511},
{0.13748,0.753765},
{0.071259,0.757429},
{0.094028,0.763176},
{0.048114,0.777064},
{0.045833,0.761997},
{0.03134,0.756362},
{0.037399,0.781323},
{0.017534,0.777175},
{0.050924,0.825349},
{0.013881,0.806873},
{0.015878,0.845816},
{0.045066,0.87762},
{0.00987,0.906096},
{0.023021,0.917125},
{0.054651,0.908294},
{0.040051,0.932663},
{0.061175,0.919748},
{0.175009,0.580947},
{0.14112,0.568367},
{0.205807,0.640674},
{0.128153,0.617532},
{0.120138,0.662759},
{0.079657,0.602795},
{0.046829,0.591958},
{0.036101,0.647964},
{0.069928,0.652229},
{0.066183,0.707695},
{0.020028,0.649106},
{0.011192,0.711568},
{0.008518,0.650517},
{0.009425,0.579677},
{0.136904,0.404866},
{0.096653,0.421992},
{0.091468,0.377506},
{0.097459,0.280046},
{0.093926,0.112114},
{0.097026,0.071515},
{0.122572,0.07653},
{0.157262,0.091616},
{1.621017,0.2205},
{1.62537,0.196595},
{1.590149,0.202418},
{1.6213,0.180624},
{1.63964,0.189316},
{1.6328,0.179042},
{1.545029,0.180896},
{1.541353,0.217846},
{1.64279,0.138782},
{1.63487,0.119974},
{1.603889,0.13956},
{1.592184,0.085791},
{1.548731,0.058299},
{1.56115,0.036803},
{1.545953,0.104259},
{1.51627,0.055055},
{1.54859,0.031828},
{1.47886,0.032015},
{1.469825,0.00758},
{1.53193,0.004057},
{1.511785,0.113369},
{1.48886,0.059382},
{1.449459,0.076651},
{1.44179,0.003871},
{1.488578,0.117884},
{1.405926,0.884772},
{1.431984,0.920449},
{1.494139,0.889468},
{1.408087,0.84808},
{1.520203,0.879957},
{1.488999,0.921235},
{1.452442,0.953222},
{1.372603,0.952926},
{1.352356,0.933615},
{1.361226,0.891253},
{1.355461,0.971713},
{1.31545,0.95085},
{1.30856,0.971636},
{1.33636,0.987879},
{1.36318,0.990519},
{1.39383,0.986448},
{1.46666,0.382035},
{1.464679,0.363476},
{1.45834,0.352371},
{1.41263,0.360549},
{1.409726,0.31999},
{1.482301,0.315623},
{1.493942,0.38627},
{1.47129,0.437243},
{1.44018,0.427777},
{1.391008,0.378604},
{1.36085,0.3588},
{1.334019,0.319999},
{1.343812,0.250059},
{1.393088,0.249759},
{1.434131,0.239261},
{1.49251,0.275197},
{1.50425,0.274082},
{1.50236,0.320155},
{1.501335,0.380233},
{1.49837,0.450978},
{1.473947,0.488105},
{1.396755,0.498445},
{1.39231,0.418501},
{1.35102,0.410017},
{1.310249,0.369229},
{1.291772,0.358447},
{1.276305,0.334724},
{1.271959,0.210949},
{1.30897,0.186059},
{1.34478,0.161957},
{1.379527,0.149541},
{1.42316,0.148928},
{1.461621,0.214731},
{1.5,0.241797},
{1.506667,0.242744},
{1.568915,0.252648},
{1.54276,0.280704},
{1.546331,0.325467},
{1.549964,0.370392},
{1.551091,0.409152},
{1.507407,0.457545},
{1.513923,0.529682},
{1.503542,0.530926},
{1.423855,0.532026},
{1.382576,0.526369},
{1.323811,0.471272},
{1.270304,0.449325},
{1.25617,0.40285},
{1.235225,0.363829},
{1.194719,0.280286},
{1.202519,0.189369},
{1.24125,0.14802},
{1.27424,0.154399},
{1.29515,0.15694},
{1.274316,0.521149},
{1.233473,0.478622},
{1.23129,0.439579},
{1.19123,0.407868},
{1.181655,0.379428},
{1.154102,0.29557},
{1.092254,0.213248},
{1.094167,0.166528},
{1.17021,0.125187},
{1.18969,0.136695},
{1.38301,0.648091},
{1.4115,0.636874},
{1.352806,0.603011},
{1.42895,0.591503},
{1.43956,0.631276},
{1.50201,0.640115},
{1.477763,0.571259},
{1.526169,0.63335},
{1.570732,0.538478},
{1.566097,0.63307},
{1.59855,0.573951},
{1.624537,0.629626},
{1.640052,0.592987},
{1.624704,0.549656},
{1.658803,0.579182},
{1.675406,0.519619},
{1.67103,0.545114},
{1.70238,0.555478},
{1.68936,0.581027},
{1.66884,0.587265},
{1.424211,0.560212},
{1.360844,0.560929},
{1.45484,0.554118},
{1.32291,0.52935},
{1.27815,0.549766},
{1.23347,0.522637},
{1.190969,0.517788},
{1.188673,0.452956},
{1.119558,0.448263},
{1.1369,0.404866},
{1.09147,0.377513},
{1.10228,0.333446},
{1.097462,0.280042},
{1.05195,0.254737},
{1.048014,0.200196},
{1.041285,0.149463},
{1.093916,0.112113},
{1.157264,0.091616},
{1.3234,0.554673},
{1.312305,0.599857},
{1.26451,0.570852},
{1.206362,0.550968},
{1.221867,0.544806},
{1.152056,0.533318},
{1.078127,0.476968},
{1.011739,0.46823},
{1.0539,0.434679},
{1.09665,0.421992},
{1.052297,0.366974},
{1.042158,0.321047},
{1.04975,0.288916},
{1.06993,0.652229},
{1.07966,0.602795},
{1.036103,0.647963},
{1.06618,0.707695},
{1.04583,0.761997},
{1.02176,0.71054},
{1.019212,0.649206},
{1.04683,0.591958},
{1.07678,0.54878},
{1.101309,0.544492},
{1.14112,0.568367},
{1.12815,0.617532},
{1.120152,0.662762},
{1.114431,0.710513},
{1.07126,0.757429},
{1.04834,0.77699},
{1.037388,0.781277},
{1.01753,0.777175},
{1.050928,0.825349},
{1.01388,0.806873},
{1.019316,0.847765},
{1.04507,0.877621},
{1.011395,0.905597},
{1.01513,0.919891},
{1.05465,0.908294},
{1.037603,0.933312},
{1.01093,0.941468},
{1.175006,0.580947},
{1.205822,0.640678},
{1.18545,0.677441},
{1.186563,0.739827},
{1.137481,0.753765},
{1.09403,0.763176},
{1.24102,0.606369},
{1.309523,0.638337},
{1.287032,0.664516},
{1.244883,0.712183},
{1.35124,0.65501},
{1.28793,0.692811},
{1.32171,0.673853},
{1.659966,0.407077},
{1.672906,0.363394},
{1.60571,0.385961},
{1.59751,0.421572},
{1.61457,0.342346},
{1.687459,0.319711},
{1.67469,0.399812},
{1.698691,0.405389},
{1.702025,0.417724},
{1.661409,0.469822},
{1.63383,0.433882},
{1.607957,0.463649},
{1.551598,0.45139},
{1.630208,0.509201},
{1.58329,0.494304},
{1.38653,0.129716},
{1.39003,0.114315},
{1.33491,0.133347},
{1.33372,0.113076},
{1.33614,0.091918},
{1.38899,0.093046},
{1.33822,0.07382},
{1.38776,0.074877},
{1.617237,0.924136},
{1.659394,0.924102},
{1.6413,0.913922},
{1.55651,0.917408},
{1.530729,0.884518},
{1.643943,0.876182},
{1.703319,0.866836},
{1.74686,0.905193},
{1.731515,0.915472},
{1.71242,0.94952},
{1.71021,0.977904},
{1.75668,0.979764},
{1.75131,0.98467},
{1.78882,0.985808},
{1.752738,0.943023},
{1.789384,0.945316},
{1.817804,0.950217},
{1.820053,0.987077},
{1.84677,0.956794},
{1.85138,0.980356},
{1.8496,0.990319},
{1.86103,0.977741},
{1.86357,0.987797},
{1.52825,0.925934},
{1.512251,0.909897},
{1.61032,0.84572},
{1.55571,0.850362},
{1.65312,0.817029},
{1.67803,0.818277},
{1.73011,0.825073},
{1.758237,0.873529},
{1.788029,0.902205},
{1.78958,0.906813},
{1.85695,0.96514},
{1.85767,0.933908},
{1.86399,0.93727},
{1.63141,0.819154},
{1.706253,0.794467},
{1.74402,0.79523},
{1.79102,0.810659},
{1.80122,0.852947},
{1.826931,0.856291},
{1.828188,0.899232},
{1.82088,0.771093},
{1.774525,0.761842},
{1.967432,0.829704},
{1.887662,0.799009},
{1.912752,0.839928},
{1.96475,0.853299},
{1.9532,0.854046},
{1.93108,0.846752},
{1.91341,0.847562},
{1.88141,0.862622},
{1.883312,0.813532},
{1.863881,0.813914},
{1.85403,0.782639},
{1.84595,0.749127},
{1.828208,0.813556},
{1.837398,0.850298},
{1.8645,0.893089},
{1.87389,0.900604},
{1.88919,0.872674},
{1.90349,0.861191},
{1.98294,0.871141},
{1.99051,0.8663},
{1.98114,0.827327},
{1.75155,0.687758},
{1.80061,0.634821},
{1.73996,0.62998},
{1.74591,0.617597},
{1.697912,0.642709},
{1.71433,0.6931},
{1.642005,0.646939},
{1.588752,0.690311},
{1.580455,0.670876},
{1.60743,0.647548},
{1.533173,0.666811},
{1.5424,0.698048},
{1.55976,0.708757},
{1.54133,0.722495},
{1.69745,0.722657},
{1.73828,0.719739},
{1.6338,0.721082},
{1.79122,0.269532},
{1.812731,0.352815},
{1.862628,0.297693},
{1.851759,0.275692},
{1.76122,0.233234},
{1.76603,0.279201},
{1.78213,0.317203},
{1.79356,0.37454},
{1.85916,0.381195},
{1.85899,0.371295},
{1.908011,0.337786},
{1.013801,0.365114},
{1.045525,0.064962},
{1.02223,0.063571},
{1.097025,0.071515},
{1.12257,0.07653},
{1.18627,0.129933},
{1.46906,0.142803},
{1.497298,0.177609},
{1.50678,0.214723},
{1.48772,0.134737},
{1.612063,0.29761},
{1.63102,0.259576},
{1.63557,0.224938},
{1.701076,0.273251},
{1.54774,0.234447},
{1.59241,0.23188},
{1.742535,0.293316},
{1.686157,0.216202},
{1.712911,0.325248},
{1.696,0.33347},
{1.769134,0.335552},
{1.73233,0.340785},
{1.728113,0.424487},
{1.739633,0.410067},
{1.743705,0.460082},
{1.721505,0.494391},
{1.72099,0.340234},
{1.68882,0.486446},
{1.7111,0.526339},
{1.74408,0.503895},
{1.74202,0.537954},
{1.73816,0.570245},
{1.73596,0.584987},
{1.73531,0.594853},
{1.10221,0.527217},
{1.06026,0.535592},
{1.093826,0.505084},
{1.011458,0.506035},
{1.01032,0.437188},
{1.02906,0.58118},
{1.00943,0.579677},
{1.06118,0.919748},
{1.91292,0.418094},
{1.92345,0.354349},
{1.960741,0.339769},
{1.94149,0.294831},
{1.84143,0.764773},
{1.90686,0.751362},
{1.90748,0.769313},
{1.92635,0.773095},
{1.92914,0.746353},
{1.98348,0.747565},
{1.94294,0.678653},
{1.958976,0.682843},
{1.95508,0.621655},
{1.942451,0.556579},
{1.90791,0.544412},
{1.90788,0.613394},
{1.91679,0.663237},
{1.92378,0.709297},
{1.93591,0.488976},
{1.90822,0.478555},
{1.940547,0.430492},
{1.98529,0.76821},
{1.466548,0.669169},
{1.48267,0.670694},
{1.497816,0.69607},
{1.49657,0.664695},
{1.51836,0.693245},
{1.521,0.710611},
{1.47299,0.702609},
{1.530307,0.729097},
{1.47109,0.737279},
{1.516168,0.773895},
{1.56166,0.803754},
{1.591954,0.787566},
{1.575014,0.741384},
{1.629201,0.752075},
{1.432874,0.659045},
{1.431827,0.709024},
{1.409227,0.783506},
{1.402048,0.835246},
{1.519976,0.791449},
{1.53815,0.813712},
{1.55168,0.814547},
{1.385704,0.712527},
{1.350315,0.83548},
{1.36524,0.860625},
{1.42908,0.828566},
{1.47443,0.836778},
{1.49487,0.827082},
{1.51984,0.826224},
{1.378135,0.673965},
{1.40376,0.649072},
{1.325581,0.711474},
{1.36312,0.752464},
{1.338774,0.828752},
{1.32871,0.841559},
{1.34848,0.885819},
{1.322625,0.902874},
{1.33614,0.907198},
{1.31647,0.690858},
{1.281833,0.711261},
{1.277882,0.777622},
{1.309899,0.762629},
{1.324478,0.74527},
{1.320704,0.821573},
{1.305099,0.848313},
{1.27285,0.912305},
{1.305785,0.945733},
{1.27543,0.957612},
{1.29064,0.978168},
{1.26417,0.982833},
{1.219029,0.942073},
{1.209786,0.976468},
{1.17239,0.935319},
{1.163815,0.966875},
{1.132616,0.906862},
{1.107448,0.993049},
{1.112457,0.918981},
{1.090633,0.920298},
{1.060745,0.986212},
{1.076933,0.918037},
{1.134135,0.842738},
{1.14671,0.841845},
{1.156739,0.89632},
{1.170266,0.830746},
{1.15187,0.821842},
{1.183322,0.789441},
{1.208045,0.780521},
{1.194264,0.815252},
{1.211538,0.820036},
{1.244862,0.801184},
{1.246704,0.735903},
{1.270997,0.867362},
{1.24464,0.910364},
{1.2431,0.858611},
{1.210904,0.887865},
{1.179055,0.89194},
{1.86407,0.5916},
{1.850315,0.69119},
{1.85542,0.586622},
{1.883305,0.572548},
{1.84653,0.570064},
{1.819361,0.65848},
{1.83853,0.712399},
{1.88576,0.716748},
{1.78923,0.708953},
{1.80337,0.757106},
{1.820529,0.24142},
{1.85437,0.25583},
{1.858534,0.209613},
{1.837202,0.198727},
{1.84958,0.127698},
{1.87062,0.187953},
{1.873543,0.150873},
{1.831629,0.06756},
{1.80091,0.008112},
{1.81835,0.007243},
{1.69548,0.19234},
{1.73549,0.208943},
{1.716755,0.167606},
{1.66015,0.176606},
{1.662712,0.135512},
{1.706566,0.126079},
{1.774391,0.170267},
{1.77484,0.223691},
{1.81677,0.191312},
{1.81186,0.10362},
{1.775917,0.083009},
{1.78144,0.016291},
{1.74088,0.051051},
{1.705701,0.070413},
{1.66732,0.094503},
{1.64806,0.090792},
{1.64933,0.136737},
{1.64981,0.174731},
{1.97812,0.983238},
{1.952769,0.867984},
{1.956948,0.962593},
{1.95174,0.883634},
{1.91087,0.883481},
{1.909339,0.871655},
{1.904765,0.96115},
{1.88792,0.982884},
{1.93302,0.983061},
{1.90815,0.06868},
{1.929149,0.132015},
{1.9798,0.044196},
{1.96614,0.006456},
{1.88842,0.047008},
{1.878066,0.133157},
{1.92816,0.179443},
{1.89384,0.188721},
{1.89557,0.22241},
{1.942607,0.26893},
{1.92999,0.276999},
{1.987771,0.29411},
{1.98932,0.273325},
{1.98312,0.180343},
{1.98173,0.153287},
{1.98482,0.141174},
{1.83852,0.410193},
{1.78761,0.385879},
{1.78619,0.421825},
{1.820245,0.462312},
{1.84949,0.438301},
{1.8629,0.513106},
{1.84805,0.516227},
{1.87928,0.542299},
{1.89452,0.518622},
{1.88607,0.405999},
{2.88756,0.983975},
{2.913397,0.865254},
{2.91075,0.883485},
{2.95208,0.88364},
{2.956097,0.870891},
{2.95741,0.965709},
{2.974585,0.984898},
{2.90443,0.965511},
{1.1594,0.045297},
{1.077448,0.04468},
{1.08656,0.056322},
{1.321829,0.043294},
{1.409057,0.041553},
{1.39602,0.005975},
{1.978677,0.533544},
{1.96026,0.60315},
{1.985226,0.704866},
{1.988856,0.617672},
{1.96444,0.483774},
{1.982424,0.394659},
{1.96142,0.389624},
{0.625366,0.196595},
{0.621017,0.2205},
{0.590149,0.202417},
{0.621299,0.180624},
{0.545954,0.104266},
{0.545029,0.180893},
{0.541353,0.217846},
{0.695998,0.33347},
{0.674693,0.399813},
{0.69868,0.405399},
{0.702025,0.417727},
{0.720994,0.340234},
{0.623884,0.571703},
{0.601853,0.632204},
{0.640074,0.592996},
{0.658812,0.579232},
{0.675407,0.519619},
{0.661407,0.469818},
{0.688816,0.486446},
{0.671027,0.545114},
{0.668836,0.587265},
{0.624563,0.629623},
{0.487722,0.134737},
{0.338216,0.07382},
{0.387761,0.074877},
{0.38899,0.093046},
{0.336136,0.091918},
{0.390031,0.114315},
{0.333724,0.113076},
{0.33491,0.133347},
{0.386529,0.129716},
{0.548727,0.058299},
{0.603893,0.139562},
{0.516272,0.055055},
{0.511783,0.113368},
{0.488574,0.117884},
{0.488858,0.059382},
{0.449458,0.076649},
{0.478861,0.032015},
{0.441788,0.003871},
{0.469826,0.00758},
{0.548589,0.031828},
{0.531926,0.004057},
{0.592185,0.085791},
{0.634872,0.119974},
{0.561154,0.036803},
{0.642794,0.138782},
{0.639638,0.189316},
{0.632799,0.179042},
{0.929137,0.746353},
{0.985294,0.76821},
{0.983481,0.747565},
{0.942941,0.678657},
{0.958974,0.68285},
{0.955076,0.621655},
{0.942453,0.556579},
{0.907908,0.544412},
{0.908221,0.478555},
{0.935843,0.488959},
{0.912922,0.418094},
{0.941879,0.431019},
{0.961125,0.338634},
{0.923451,0.354349},
{0.941485,0.294831},
{0.923776,0.709297},
{0.916794,0.663237},
{0.907884,0.613394},
{0.472995,0.702609},
{0.466543,0.669167},
{0.43287,0.659045},
{0.471095,0.737278},
{0.431833,0.709016},
{0.378972,0.67384},
{0.403761,0.649072},
{0.320702,0.821572},
{0.32448,0.74527},
{0.309899,0.76263},
{0.325577,0.711474},
{0.363118,0.752464},
{0.385705,0.712538},
{0.338771,0.828752},
{0.35031,0.835479},
{0.328707,0.841559},
{0.305098,0.848311},
{0.277883,0.777619},
{0.28183,0.711195},
{0.316465,0.690858},
{0.409219,0.783502},
{0.402054,0.835239},
{0.365242,0.860625},
{0.348476,0.885819},
{0.322629,0.902874},
{0.272851,0.912305},
{0.270997,0.867363},
{0.244859,0.801184},
{0.246704,0.735903},
{0.151866,0.821842},
{0.146707,0.841844},
{0.170271,0.83074},
{0.156739,0.896316},
{0.132612,0.906865},
{0.112451,0.918988},
{0.134132,0.842738},
{0.090633,0.920299},
{0.076933,0.918037},
{0.060747,0.986212},
{0.107449,0.993049},
{0.163812,0.966876},
{0.172389,0.935319},
{0.209784,0.976467},
{0.219022,0.942071},
{0.264165,0.982833},
{0.275434,0.957612},
{0.290643,0.978168},
{0.305788,0.945731},
{0.211535,0.820042},
{0.208045,0.780521},
{0.194265,0.815264},
{0.17905,0.891985},
{0.18332,0.789444},
{0.2431,0.858606},
{0.210904,0.887878},
{0.244636,0.910364},
{0.336142,0.907198},
{0.429075,0.828566},
{0.519971,0.791449},
{0.474435,0.836778},
{0.494874,0.827082},
{0.519845,0.826224},
{0.538145,0.813712},
{0.561659,0.803754},
{0.551681,0.814547},
{0.516163,0.773895},
{0.530304,0.729097},
{0.591956,0.787565},
{0.575012,0.741383},
{0.629201,0.752075},
{0.497819,0.696069},
{0.521003,0.710611},
{0.482672,0.670694},
{0.496567,0.664695},
{0.518361,0.693245},
{0.819361,0.65848},
{0.849173,0.691186},
{0.855423,0.586622},
{0.846526,0.570064},
{0.883301,0.572548},
{0.859809,0.592279},
{0.886939,0.691323},
{0.885756,0.716748},
{0.838533,0.712399},
{0.78923,0.708953},
{0.803367,0.757106},
{0.886699,0.58799},
{0.786189,0.421825},
{0.78761,0.385879},
{0.838522,0.410193},
{0.820246,0.462312},
{0.848716,0.43831},
{0.886065,0.405999},
{0.888502,0.437857},
{0.868357,0.514058},
{0.848052,0.516227},
{0.879281,0.542299},
{1.91075,0.883485},
{1.90443,0.965511},
{1.95208,0.88364},
{1.913397,0.865254},
{1.956098,0.870893},
{1.95741,0.965709},
{1.974584,0.984898},
{1.88756,0.983975},
{0.910865,0.883481},
{0.951742,0.883634},
{0.90476,0.961152},
{0.90935,0.871637},
{0.88792,0.982884},
{0.933018,0.983061},
{0.956951,0.962594},
{0.952771,0.867982},
{0.978116,0.983238},
{0.89557,0.22241},
{0.928685,0.179452},
{0.942607,0.26893},
{0.92999,0.276999},
{0.987769,0.29411},
{0.989317,0.273325},
{0.893843,0.188721},
{0.878066,0.133156},
{0.929146,0.132015},
{0.908155,0.06868},
{0.888416,0.047008},
{0.966142,0.006456},
{0.979797,0.044196},
{0.98482,0.141174},
{0.98173,0.153287},
{0.96026,0.60315},
{0.964442,0.483774},
{0.979409,0.394482},
{0.961419,0.389624},
{0.977409,0.572172},
{0.988167,0.483712},
{0.988886,0.395072},
{0.984839,0.705637},
{0.086564,0.056322},
{0.077449,0.04468},
{0.1594,0.0453},
{0.396024,0.005975},
{0.409055,0.041554},
{0.321828,0.043296},
{0.75155,0.687758},
{0.73828,0.719739},
{0.697447,0.722657},
{0.714327,0.6931},
{0.588753,0.690311},
{0.633802,0.721082},
{0.559655,0.708006},
{0.560948,0.717699},
{0.541327,0.722495},
{0.5424,0.698048},
{0.580459,0.670875},
{0.533168,0.666811},
{0.607428,0.647548},
{0.642001,0.646939},
{0.697911,0.642708},
{0.739964,0.62998},
{0.745914,0.617597},
{0.800606,0.634821},
{0.010873,0.941487},
{0.008274,0.922297},
{0.405928,0.884769},
{0.494136,0.889469},
{0.431987,0.920448},
{0.372603,0.952926},
{0.452442,0.953222},
{0.488999,0.921236},
{0.520198,0.879957},
{0.408088,0.848081},
{0.361225,0.891256},
{0.352358,0.933617},
{0.355462,0.971713},
{0.393833,0.986448},
{0.363182,0.990519},
{0.336355,0.987879},
{0.308565,0.971636},
{0.315448,0.95085},
{0.926349,0.773095},
{0.906862,0.751362},
{0.907484,0.769313},
{0.840796,0.764807},
{0.706567,0.12608},
{0.71676,0.167607},
{0.662716,0.135507},
{0.705696,0.070413},
{0.667323,0.094503},
{0.648056,0.090792},
{0.649332,0.136737},
{0.649805,0.174731},
{0.660146,0.176606},
{0.695478,0.19234},
{0.735494,0.208943},
{0.774839,0.223691},
{0.77439,0.170272},
{0.775914,0.083009},
{0.740879,0.051051},
{0.781438,0.016291},
{0.800906,0.008112},
{0.811856,0.10362},
{0.849579,0.127698},
{0.831625,0.06756},
{0.818346,0.007243},
{0.816767,0.191314},
{0.820529,0.241421},
{0.837202,0.198721},
{0.858535,0.209613},
{0.870625,0.187953},
{0.873544,0.150873},
{0.854374,0.25583},
{0.812727,0.352815},
{0.85571,0.302462},
{0.858993,0.371295},
{0.859157,0.381195},
{0.908014,0.337786},
{0.8735,0.290199},
{0.858334,0.271893},
{0.851153,0.276044},
{0.791217,0.269532},
{0.782128,0.317203},
{0.793562,0.37454},
{0.766032,0.279201},
{0.761215,0.233234},
{0.258431,0.53388},
{0.256662,0.527888},
{0.278341,0.549501},
{0.238993,0.633166},
{0.264787,0.632669},
{0.276008,0.658754},
{0.304494,0.648859},
{0.308,0.563799},
{0.279449,0.48829},
{0.272978,0.518779},
{0.2411,0.486699},
{0.193607,0.421722},
{0.210146,0.567883},
{0.2194,0.574199},
{0.2104,0.602299},
{0.208108,0.64869},
{0.232102,0.675556},
{0.2605,0.664399},
{0.258653,0.710429},
{0.267834,0.716796},
{0.299658,0.711455},
{0.330437,0.642543},
{0.330071,0.563292},
{0.336459,0.501314},
{0.307389,0.469022},
{0.3041,0.404499},
{0.2674,0.399899},
{0.236,0.431299},
{0.2284,0.397499},
{0.186351,0.392556},
{0.1485,0.396499},
{0.155282,0.425228},
{0.1712,0.518899},
{0.178,0.577299},
{0.187102,0.59102},
{0.165334,0.620796},
{0.185128,0.645696},
{0.176974,0.685612},
{0.198081,0.702463},
{0.215536,0.714965},
{0.248695,0.699771},
{0.238,0.720699},
{0.231539,0.731075},
{0.236847,0.791983},
{0.268796,0.816675},
{0.299424,0.772441},
{0.329721,0.776056},
{0.336164,0.705973},
{0.344,0.645599},
{0.3886,0.585899},
{0.3753,0.563799},
{0.35939,0.511167},
{0.342804,0.487713},
{0.334,0.457299},
{0.33224,0.396239},
{0.296916,0.365403},
{0.2624,0.361899},
{0.148978,0.577286},
{0.1576,0.592999},
{0.121521,0.598553},
{0.1274,0.634099},
{0.1446,0.642499},
{0.165103,0.663863},
{0.15712,0.696124},
{0.182978,0.715184},
{0.215398,0.723337},
{0.1295,0.472699},
{0.095993,0.490325},
{0.119816,0.576366},
{0.050167,0.457982},
{0.0692,0.535799},
{0.073164,0.583668},
{0.0848,0.578399},
{0.0908,0.581899},
{0.094968,0.605963},
{0.1132,0.612199},
{0.094913,0.670525},
{0.123068,0.666034},
{0.1426,0.674099},
{0.1388,0.701399},
{0.142,0.725599},
{0.175557,0.723756},
{0.204802,0.73356},
{0.1214,0.437899},
{0.0866,0.446499},
{0.078,0.411199},
{0.043738,0.422665},
{0.0447,0.478799},
{0.1122,0.404499},
{0.069746,0.370449},
{0.1092,0.357199},
{0.0788,0.326299},
{0.058554,0.343646},
{0.0881,0.292599},
{0.113,0.307899},
{0.117,0.282399},
{0.1059,0.261799},
{0.145754,0.269921},
{0.1292,0.228299},
{0.1446,0.350099},
{0.1458,0.300199},
{0.1807,0.300299},
{0.1751,0.265799},
{0.182935,0.245767},
{0.2036,0.267699},
{0.224835,0.254871},
{0.192392,0.2238},
{0.234362,0.221796},
{0.259441,0.278119},
{0.277684,0.267237},
{0.2609,0.242399},
{0.165839,0.328271},
{0.1691,0.390099},
{0.1744,0.385099},
{0.172425,0.331963},
{0.1845,0.321899},
{0.199473,0.330337},
{0.2174,0.304899},
{0.188763,0.386306},
{0.2227,0.354199},
{0.1984,0.389999},
{0.194227,0.336886},
{0.2561,0.324099},
{0.1833,0.330999},
{0.291776,0.297578},
{0.2992,0.289299},
{0.320187,0.305465},
{0.330025,0.308325},
{0.319436,0.342278},
{0.333444,0.339023},
{0.350167,0.313906},
{0.351826,0.359711},
{0.374297,0.317985},
{0.378688,0.365072},
{0.403586,0.314942},
{0.3884,0.310699},
{0.360032,0.432961},
{0.371235,0.426579},
{0.404495,0.41155},
{0.4113,0.347099},
{0.449243,0.314415},
{0.445907,0.30001},
{0.4347,0.293499},
{0.399373,0.496277},
{0.442056,0.445704},
{0.438847,0.398254},
{0.475069,0.324216},
{0.4705,0.290799},
{0.495798,0.269333},
{0.5138,0.282999},
{0.5308,0.271599},
{0.4199,0.507099},
{0.405059,0.550878},
{0.433978,0.472034},
{0.458,0.485551},
{0.4856,0.452599},
{0.482645,0.414323},
{0.52168,0.400763},
{0.5155,0.321899},
{0.4189,0.537099},
{0.442127,0.510716},
{0.469501,0.531517},
{0.48,0.509199},
{0.4859,0.467799},
{0.5247,0.451199},
{0.408803,0.578335},
{0.421665,0.593564},
{0.430315,0.565057},
{0.4444,0.579099},
{0.466299,0.581825},
{0.4976,0.539599},
{0.5149,0.514999},
{0.5243,0.468399},
{0.5579,0.445799},
{0.559603,0.410946},
{0.55318,0.298753},
{0.3763,0.612799},
{0.4183,0.616599},
{0.478901,0.615939},
{0.4606,0.603299},
{0.500167,0.571376},
{0.5524,0.530299},
{0.545173,0.511863},
{0.5552,0.470199},
{0.586335,0.474346},
{0.5992,0.432899},
{0.598298,0.396104},
{0.5903,0.342299},
{0.5814,0.312999},
{0.5754,0.274899},
{0.4948,0.629799},
{0.483161,0.644952},
{0.49048,0.618193},
{0.5085,0.576099},
{1.5295,0.258699},
{1.51271,0.237411},
{1.5593,0.234999},
{1.5554,0.263499},
{1.5813,0.268699},
{1.587035,0.208873},
{1.6163,0.222799},
{1.611642,0.185074},
{1.594929,0.152438},
{1.647473,0.140276},
{1.610226,0.119204},
{1.641059,0.126152},
{1.6336,0.106599},
{1.6054,0.108599},
{1.6361,0.091999},
{1.654,0.106699},
{1.6565,0.091599},
{1.690672,0.118941},
{1.689258,0.092835},
{1.71165,0.085779},
{1.727137,0.110052},
{1.753566,0.094723},
{1.735809,0.067881},
{1.769,0.061699},
{1.7581,0.048799},
{1.7773,0.031999},
{1.796138,0.045003},
{1.8035,0.027299},
{1.834843,0.042216},
{1.8363,0.026899},
{1.851676,0.031049},
{1.873761,0.054154},
{1.897022,0.050739},
{1.917301,0.046801},
{1.962276,0.082939},
{1.952951,0.032133},
{1.9923,0.060799},
{1.977627,0.085943},
{1.9483,0.121399},
{1.970648,0.143308},
{1.915053,0.121717},
{1.9278,0.188099},
{1.94503,0.222285},
{1.9802,0.178699},
{1.650231,0.177006},
{1.649304,0.235942},
{1.694099,0.23288},
{1.68324,0.185909},
{1.677377,0.150524},
{1.6779,0.248099},
{1.697741,0.264438},
{1.750258,0.253584},
{1.7328,0.226199},
{1.703908,0.156076},
{1.741707,0.145026},
{1.7709,0.130099},
{1.774477,0.091304},
{1.808332,0.05555},
{1.8201,0.082399},
{1.857902,0.058323},
{1.882381,0.086767},
{1.92891,0.100882},
{1.886574,0.128568},
{1.898819,0.200122},
{1.940538,0.290326},
{1.9638,0.242499},
{1.965858,0.277049},
{1.9674,0.310699},
{1.944937,0.362095},
{1.9723,0.355699},
{1.9754,0.427499},
{1.949775,0.489629},
{1.9742,0.491499},
{1.943021,0.519412},
{1.9699,0.531499},
{1.957931,0.577907},
{1.9369,0.560599},
{1.923941,0.605808},
{1.9662,0.590199},
{1.95297,0.62399},
{1.902949,0.636646},
{1.9322,0.658099},
{1.9469,0.653699},
{1.9571,0.627299},
{1.739954,0.170282},
{1.761799,0.176327},
{1.783278,0.152562},
{1.8012,0.107099},
{1.687277,0.31984},
{1.662197,0.364414},
{1.712876,0.286445},
{1.76379,0.286936},
{1.781336,0.292688},
{1.771278,0.23994},
{1.763044,0.214846},
{1.822441,0.13395},
{1.856043,0.102581},
{1.804327,0.18234},
{1.8497,0.147499},
{1.8536,0.171799},
{1.8654,0.207599},
{1.888692,0.273649},
{1.919825,0.298812},
{1.923024,0.366889},
{1.9389,0.430799},
{1.914166,0.398547},
{1.908458,0.433581},
{1.903617,0.465204},
{1.9295,0.531899},
{1.912224,0.56057},
{1.891875,0.592046},
{1.869795,0.613222},
{1.8575,0.667699},
{1.8883,0.683399},
{1.9295,0.663299},
{1.8199,0.190799},
{1.835,0.225199},
{1.885098,0.322378},
{1.9077,0.331099},
{1.73025,0.375829},
{1.7664,0.349499},
{1.793523,0.359939},
{1.808075,0.347193},
{1.8125,0.313399},
{1.801434,0.254179},
{1.7989,0.201899},
{1.846595,0.301115},
{1.8855,0.349299},
{1.838828,0.356223},
{1.851931,0.41664},
{1.8367,0.421399},
{1.855169,0.463276},
{1.88736,0.495001},
{1.894298,0.472371},
{1.874784,0.41551},
{1.873559,0.369151},
{1.841896,0.32234},
{1.744758,0.434495},
{1.713763,0.460675},
{1.744795,0.469809},
{1.759458,0.462111},
{1.778,0.417899},
{1.8043,0.400099},
{1.820194,0.456226},
{1.847442,0.475435},
{1.853965,0.551837},
{1.874886,0.535062},
{1.769895,0.47323},
{1.810653,0.509931},
{1.70038,0.400341},
{1.665941,0.452733},
{1.696445,0.513794},
{1.73165,0.506493},
{1.747708,0.546987},
{1.7554,0.529299},
{1.784736,0.549702},
{1.7732,0.527799},
{1.7871,0.513999},
{1.802555,0.518163},
{1.801074,0.550259},
{1.838311,0.59433},
{1.841582,0.552074},
{1.6851,0.529052},
{1.720441,0.560387},
{1.7412,0.607499},
{1.661994,0.552131},
{1.7247,0.627699},
{1.7495,0.608699},
{1.754813,0.590028},
{1.685335,0.509189},
{1.6543,0.550499},
{1.6806,0.597399},
{1.730728,0.642502},
{1.763412,0.626588},
{1.784608,0.606227},
{1.660383,0.397231},
{1.6361,0.463199},
{1.639223,0.50085},
{1.6446,0.324799},
{1.6304,0.401299},
{1.613146,0.441309},
{1.598547,0.483104},
{1.5866,0.529199},
{1.63244,0.549968},
{1.653715,0.244499},
{1.6428,0.270199},
{1.611646,0.292002},
{1.615106,0.373812},
{1.637436,0.605869},
{1.675856,0.657383},
{1.705312,0.741703},
{1.754726,0.727357},
{1.786576,0.696454},
{1.812102,0.670733},
{1.803071,0.64875},
{1.82279,0.634074},
{1.850234,0.628772},
{1.599219,0.294471},
{1.618895,0.554665},
{1.613893,0.581701},
{1.584457,0.540624},
{1.554932,0.550432},
{1.546038,0.565895},
{1.5761,0.562299},
{1.5322,0.568599},
{1.457706,0.908849},
{1.476022,0.897956},
{1.4548,0.896999},
{1.4464,0.919599},
{1.459625,0.956147},
{1.439162,0.943298},
{1.466877,0.91032},
{1.467874,0.952902},
{1.5361,0.913199},
{1.525955,0.901859},
{1.5182,0.922399},
{1.513069,0.911694},
{1.503618,0.897836},
{1.501254,0.908324},
{1.479884,0.908078},
{1.499381,0.951682},
{1.485231,0.962096},
{1.4657,0.965299},
{1.494425,0.980993},
{1.4742,0.9883},
{1.5059,0.958999},
{1.9663,0.695499},
{1.939882,0.685247},
{1.962269,0.73049},
{1.986549,0.714398},
{1.9795,0.763799},
{1.927152,0.713215},
{1.913524,0.775899},
{1.9532,0.806399},
{1.982571,0.816104},
{1.973473,0.872162},
{1.934959,0.888104},
{1.887431,0.879338},
{1.8843,0.816499},
{1.880059,0.770244},
{1.9051,0.739599},
{1.893,0.928399},
{1.8519,0.934599},
{1.849074,0.87887},
{1.8492,0.821199},
{1.8495,0.779099},
{1.851,0.754099},
{1.824091,0.772031},
{1.821955,0.850836},
{1.816166,0.855434},
{1.813558,0.920754},
{1.83722,0.953831},
{1.9035,0.958099},
{1.9223,0.986099},
{1.9447,0.956099},
{1.9538,0.989599},
{1.9897,0.958299},
{1.9901,0.993199},
{1.319436,0.34228},
{1.320187,0.305465},
{1.291776,0.297578},
{1.296916,0.3654},
{1.2561,0.324099},
{1.259441,0.27812},
{1.277683,0.267236},
{1.2992,0.289299},
{1.33224,0.396236},
{1.3041,0.404499},
{1.2674,0.399899},
{1.2624,0.361899},
{1.2174,0.304899},
{1.224835,0.25487},
{1.234362,0.221796},
{1.2609,0.242399},
{1.192392,0.2238},
{1.182935,0.245767},
{1.2036,0.267699},
{1.1751,0.265799},
{1.145754,0.269919},
{1.1807,0.300299},
{1.1458,0.300199},
{1.117,0.282399},
{1.1059,0.261799},
{1.1292,0.228299},
{1.199473,0.330337},
{1.1845,0.321899},
{1.165839,0.328271},
{1.1446,0.350099},
{1.113,0.307899},
{1.0881,0.292599},
{1.236,0.431299},
{1.2284,0.397499},
{1.193607,0.421721},
{1.2411,0.486699},
{1.256662,0.527888},
{1.210146,0.567883},
{1.155282,0.425227},
{1.1485,0.396499},
{1.186351,0.392556},
{1.1984,0.389999},
{1.2227,0.354199},
{1.279447,0.488282},
{1.272978,0.518778},
{1.278341,0.549503},
{1.258431,0.533881},
{1.2194,0.574199},
{1.187109,0.591039},
{1.178,0.577299},
{1.1712,0.518899},
{1.14898,0.577302},
{1.1295,0.472699},
{1.1214,0.437899},
{1.1122,0.404499},
{1.1092,0.357199},
{1.1691,0.390099},
{1.188763,0.386306},
{1.194227,0.336886},
{1.0788,0.326299},
{1.058555,0.343643},
{1.069746,0.370449},
{1.078,0.411199},
{1.043738,0.422666},
{1.050166,0.45798},
{1.0447,0.478799},
{1.073164,0.583668},
{1.0692,0.535799},
{1.0848,0.578399},
{1.095993,0.490324},
{1.119821,0.576331},
{1.0908,0.581899},
{1.0752,0.594099},
{1.095068,0.606276},
{1.076154,0.613403},
{1.086159,0.645055},
{1.064598,0.619146},
{1.058187,0.646922},
{1.0392,0.640899},
{1.038863,0.663432},
{1.019893,0.650664},
{1.022551,0.678027},
{1.058966,0.675971},
{1.0191,0.701399},
{1.0562,0.699199},
{1.042,0.726399},
{1.0213,0.735499},
{1.056793,0.751222},
{1.026,0.753099},
{1.0337,0.761999},
{1.0366,0.786399},
{1.0337,0.795299},
{1.0536,0.788699},
{1.0506,0.784499},
{1.062034,0.77067},
{1.078068,0.78283},
{1.080794,0.795364},
{1.0592,0.818299},
{1.0885,0.801999},
{1.09559,0.807668},
{1.0832,0.835899},
{1.1056,0.813499},
{1.114198,0.818574},
{1.123675,0.826076},
{1.134035,0.788859},
{1.1474,0.803799},
{1.135319,0.827732},
{1.143869,0.833587},
{1.162421,0.809098},
{1.1551,0.833599},
{1.1598,0.839999},
{1.173843,0.843056},
{1.1506,0.864199},
{1.1782,0.871699},
{1.182953,0.888616},
{1.1623,0.899399},
{1.190292,0.902559},
{1.198855,0.915061},
{1.1864,0.933899},
{1.207736,0.926976},
{1.217403,0.936267},
{1.2124,0.960499},
{1.226854,0.944523},
{1.237458,0.952108},
{1.2428,0.979399},
{1.2493,0.958299},
{1.263515,0.96179},
{1.290517,0.991814},
{1.2726,0.966899},
{1.284109,0.965149},
{1.299563,0.969923},
{1.3356,0.986699},
{1.3098,0.969899},
{1.3166,0.965299},
{1.3342,0.957099},
{1.345488,0.95964},
{1.388026,0.962441},
{1.36139,0.954272},
{1.363,0.947499},
{1.3717,0.945399},
{1.380872,0.944495},
{1.39003,0.934778},
{1.418,0.936999},
{1.399838,0.926592},
{1.407643,0.917163},
{1.4358,0.912399},
{1.413903,0.906905},
{1.421646,0.896858},
{1.45,0.883399},
{1.425868,0.886424},
{1.432195,0.876616},
{1.4635,0.851999},
{1.433999,0.864625},
{1.438184,0.851104},
{1.4736,0.822999},
{1.4417,0.831599},
{1.4416,0.807399},
{1.4083,0.820202},
{1.446364,0.76553},
{1.4692,0.791899},
{1.1744,0.385099},
{1.1833,0.330999},
{1.172425,0.331963},
{1.0866,0.446499},
{1.121534,0.598379},
{1.1132,0.612199},
{1.106141,0.652027},
{1.099382,0.67291},
{1.072078,0.665339},
{1.1576,0.592999},
{1.165531,0.621015},
{1.1274,0.634099},
{1.123782,0.665134},
{1.096831,0.688095},
{1.307389,0.469017},
{1.308,0.563799},
{1.333445,0.339022},
{1.351826,0.359711},
{1.342804,0.487713},
{1.334,0.457299},
{1.336459,0.501314},
{1.330069,0.563292},
{1.330437,0.642543},
{1.304494,0.648859},
{1.276008,0.658754},
{1.264788,0.632668},
{1.238993,0.633164},
{1.2104,0.602299},
{1.359389,0.511165},
{1.3753,0.563799},
{1.3886,0.585899},
{1.344,0.645599},
{1.336164,0.705975},
{1.299658,0.711456},
{1.267834,0.716795},
{1.258653,0.710429},
{1.2605,0.664399},
{1.232102,0.675558},
{1.208108,0.64869},
{1.185122,0.645683},
{1.1446,0.642499},
{1.1426,0.674099},
{1.1298,0.685299},
{1.1144,0.701299},
{1.096888,0.728035},
{1.066557,0.69953},
{1.066796,0.736421},
{1.087311,0.75433},
{1.0748,0.768099},
{1.12197,0.7779},
{1.408803,0.578335},
{1.405059,0.550878},
{1.421665,0.593565},
{1.3763,0.612799},
{1.377,0.659599},
{1.3707,0.690899},
{1.36637,0.725099},
{1.329721,0.776056},
{1.299424,0.772449},
{1.268796,0.816674},
{1.236847,0.791983},
{1.231539,0.731075},
{1.238,0.720699},
{1.248695,0.699772},
{1.215538,0.714965},
{1.198082,0.702464},
{1.176974,0.685613},
{1.165094,0.663898},
{1.157119,0.696125},
{1.1388,0.701399},
{1.142,0.725599},
{1.15091,0.758272},
{1.4189,0.537099},
{1.4199,0.507099},
{1.442127,0.510716},
{1.430315,0.565057},
{1.4444,0.579099},
{1.4606,0.603299},
{1.478866,0.61588},
{1.4183,0.616599},
{1.4123,0.643999},
{1.410036,0.699153},
{1.400359,0.710589},
{1.3933,0.766999},
{1.3981,0.795999},
{1.367881,0.838893},
{1.331892,0.837873},
{1.299382,0.823035},
{1.291269,0.858619},
{1.2478,0.850599},
{1.2307,0.854699},
{1.2081,0.834899},
{1.196874,0.780046},
{1.205192,0.748504},
{1.204805,0.733561},
{1.2154,0.723337},
{1.399373,0.49627},
{1.433978,0.472034},
{1.458,0.485551},
{1.469501,0.531517},
{1.4663,0.581824},
{1.500169,0.571375},
{1.5085,0.576099},
{1.49048,0.618193},
{1.4948,0.629799},
{1.4835,0.644099},
{1.457,0.631699},
{1.4489,0.651899},
{1.432278,0.694008},
{1.4272,0.728099},
{1.425969,0.753327},
{1.4037,0.854999},
{1.389446,0.87086},
{1.3605,0.856299},
{1.3311,0.861499},
{1.360031,0.432964},
{1.371234,0.426582},
{1.404495,0.41155},
{1.442057,0.445704},
{1.4856,0.452599},
{1.4859,0.467799},
{1.48,0.509199},
{1.5149,0.514999},
{1.4976,0.539599},
{1.5524,0.530299},
{1.378688,0.365071},
{1.4113,0.347099},
{1.438848,0.39825},
{1.482646,0.414325},
{1.52168,0.400768},
{1.5247,0.451199},
{1.5243,0.468399},
{1.330024,0.308325},
{1.350168,0.313907},
{1.374297,0.317984},
{1.403586,0.314942},
{1.449243,0.314415},
{1.475069,0.324211},
{1.5155,0.321899},
{1.55318,0.298753},
{1.559603,0.410948},
{1.5579,0.445799},
{1.5552,0.470199},
{1.545173,0.511864},
{1.586334,0.474348},
{1.5992,0.432899},
{1.598297,0.396102},
{1.5903,0.342299},
{1.5814,0.312999},
{1.5754,0.274899},
{1.445907,0.30001},
{1.4705,0.290799},
{1.5138,0.282999},
{1.3884,0.310699},
{1.4347,0.293499},
{1.495798,0.269333},
{1.5308,0.271599},
{1.4796,0.653899},
{1.471918,0.668354},
{1.452216,0.694292},
{1.446717,0.707017},
{1.4471,0.749199},
{1.182978,0.715183},
{1.175557,0.723755},
{1.303238,0.916997},
{1.275618,0.8896},
{1.28258,0.929161},
{1.262261,0.896958},
{1.327476,0.915265},
{1.339265,0.912904},
{1.3365,0.926099},
{1.2691,0.936899},
{1.259115,0.92077},
{1.2419,0.919299},
{1.242284,0.902769},
{1.2997,0.937099},
{1.375631,0.896656},
{1.355408,0.926114},
{1.3939,0.890099},
{1.3727,0.917399},
{1.22193,0.884599},
{1.176991,0.792794},
{1.1778,0.753799},
{1.0503,0.761499},
{1.551341,0.813407},
{1.513488,0.865653},
{1.551368,0.866909},
{1.5299,0.891799},
{1.4928,0.877299},
{1.562211,0.889403},
{1.5792,0.843699},
{1.584669,0.793909},
{1.5684,0.771199},
{1.600316,0.687948},
{1.54767,0.743721},
{1.5656,0.680299},
{1.5754,0.643199},
{1.6077,0.653799},
{1.6153,0.617499},
{1.591039,0.598207},
{1.547671,0.609806},
{1.5445,0.634599},
{1.485801,0.666073},
{1.529085,0.693145},
{1.493108,0.705969},
{1.4685,0.707399},
{1.483091,0.780005},
{1.4583,0.752399},
{1.520307,0.818104},
{1.514707,0.777267},
{1.346734,0.048236},
{1.325037,0.072058},
{1.359804,0.083958},
{1.339492,0.097869},
{1.2802,0.106099},
{1.2608,0.082299},
{1.2688,0.060499},
{1.2936,0.017499},
{1.2692,0.021799},
{1.2819,0.005599},
{1.2632,0.004499},
{1.2499,0.051699},
{1.2462,0.038999},
{1.2337,0.047199},
{1.217161,0.056086},
{1.2228,0.045999},
{1.379455,0.077999},
{1.406782,0.12225},
{1.37101,0.135547},
{1.345281,0.144598},
{1.3262,0.154799},
{1.286882,0.159547},
{1.2572,0.110999},
{1.2399,0.082387},
{1.253398,0.073406},
{1.224741,0.067101},
{1.444,0.053399},
{1.436639,0.026902},
{1.392818,0.038533},
{1.440611,0.087896},
{1.404875,0.092292},
{1.455498,0.145459},
{1.413673,0.149689},
{1.3799,0.179499},
{1.335849,0.183225},
{1.314,0.201899},
{1.330714,0.228529},
{1.342252,0.210124},
{1.369,0.254399},
{1.3496,0.261899},
{1.370299,0.295112},
{1.4104,0.275699},
{1.3976,0.247399},
{1.4327,0.238499},
{1.4433,0.258699},
{1.468483,0.240513},
{1.4233,0.209699},
{1.472514,0.203349},
{1.494888,0.23101},
{1.5042,0.200899},
{1.507315,0.21871},
{1.519066,0.192393},
{1.4684,0.178499},
{1.496973,0.149229},
{1.538783,0.146366},
{1.5351,0.181699},
{1.499459,0.059909},
{1.528318,0.109732},
{1.3892,0.214299},
{1.420591,0.177418},
{1.108811,0.914321},
{1.1075,0.922399},
{1.1383,0.901099},
{1.1082,0.906299},
{1.1097,0.899099},
{1.1218,0.870799},
{1.106524,0.891615},
{1.107928,0.872818},
{1.0908,0.855499},
{1.077263,0.857804},
{1.098635,0.884307},
{1.080403,0.888981},
{1.0524,0.859799},
{1.064189,0.890622},
{1.0335,0.872999},
{1.031347,0.895459},
{1.011,0.885799},
{1.0201,0.865599},
{1.1292,0.939399},
{1.1027,0.927199},
{1.0768,0.918899},
{1.078016,0.90535},
{1.096049,0.938287},
{1.11,0.970299},
{1.0881,0.949099},
{1.0657,0.933799},
{1.0384,0.920099},
{1.0529,0.949599},
{1.082435,0.956536},
{1.072853,0.965865},
{1.0687,0.967699},
{1.5114,0.976199},
{1.50707,0.953705},
{1.51938,0.943462},
{1.5283,0.921199},
{1.535181,0.036214},
{1.5285,0.057599},
{1.532442,0.070299},
{1.5472,0.078299},
{1.5508,0.029199},
{1.5625,0.082599},
{1.5669,0.026499},
{1.58,0.085299},
{1.5849,0.024899},
{1.6016,0.085599},
{1.6053,0.027999},
{1.6208,0.083099},
{1.6337,0.086699},
{1.6246,0.035499},
{1.6404,0.024699},
{1.647,0.064199},
{1.6463,0.041399},
{1.6637,0.039799},
{1.6639,0.064899},
{1.683,0.064699},
{1.6831,0.039499},
{1.7017,0.040699},
{1.703,0.061699},
{1.7197,0.041699},
{1.7195,0.059399},
{1.6495,0.019799},
{1.6279,0.019799},
{1.7783,0.910299},
{1.7696,0.891599},
{1.7912,0.881099},
{1.784928,0.85999},
{1.7543,0.889699},
{1.7101,0.890999},
{1.708119,0.854583},
{1.737699,0.812804},
{1.7034,0.825099},
{1.7959,0.811899},
{1.8036,0.820199},
{1.793629,0.839915},
{1.77252,0.784171},
{1.8046,0.851599},
{1.813217,0.749087},
{1.8257,0.720199},
{1.838685,0.705282},
{1.831045,0.673734},
{1.8308,0.663099},
{1.80631,0.780712},
{1.8166,0.750799},
{1.836236,0.724355},
{1.858554,0.706038},
{1.845892,0.682359},
{1.8363,0.738199},
{2.653308,0.745899},
{2.628198,0.749133},
{2.677628,0.769749},
{2.656353,0.684537},
{2.6728,0.677399},
{2.617937,0.675326},
{2.62962,0.691209},
{2.606761,0.77153},
{2.6422,0.784699},
{1.631685,0.682821},
{1.62504,0.665788},
{1.608898,0.691447},
{1.626501,0.746428},
{1.6067,0.773899},
{1.651747,0.74772},
{1.6422,0.784699},
{1.6776,0.770899},
{1.665555,0.671746},
{1.6578,0.684899},
{2.657117,0.693909},
{2.631732,0.682816},
{2.626512,0.746312},
{2.65119,0.749608},
{2.6067,0.773899},
{2.6081,0.719999},
{2.6169,0.675799},
{2.671349,0.676626},
{2.6788,0.721899},
{2.6776,0.770899},
{2.6422,0.784699},
{1.1498,0.129799},
{1.1325,0.118299},
{1.168452,0.097598},
{1.179516,0.106485},
{1.1631,0.080499},
{1.099627,0.127483},
{1.101,0.160399},
{1.1163,0.172099},
{1.104666,0.210733},
{1.137884,0.205986},
{1.188999,0.118028},
{1.190403,0.070423},
{1.1238,0.079999},
{1.078293,0.126639},
{1.074778,0.205029},
{1.0791,0.192399},
{1.090346,0.203346},
{1.066997,0.246022},
{1.099058,0.231944},
{1.216687,0.089531},
{1.138439,0.042581},
{1.205401,0.011608},
{1.110221,0.020592},
{1.088217,0.041323},
{1.035871,0.080131},
{1.021841,0.121349},
{1.016957,0.172384},
{1.017145,0.229867},
{1.0141,0.296799},
{1.0598,0.290199},
{1.034681,0.053713},
{1.039195,0.023521},
{1.0497,0.009499},
{1.0195,0.002999},
{1.106368,0.009183},
{1.198925,0.002834},
{1.0263,0.363699},
{1.018927,0.447015},
{1.0131,0.366499},
{1.989825,0.924419},
{1.9392,0.924499},
{1.63232,0.806334},
{1.6611,0.830899},
{1.611474,0.863801},
{1.595069,0.828717},
{1.578,0.898099},
{1.589848,0.913394},
{1.6201,0.908999},
{1.6392,0.864499},
{1.682818,0.8642},
{1.6808,0.829099},
{1.667593,0.799019},
{1.628,0.793599},
{1.5943,0.793999},
{1.572235,0.915365},
{1.5881,0.920399},
{1.5981,0.928799},
{1.6052,0.926599},
{1.610593,0.965622},
{1.6433,0.923299},
{1.59326,0.956104},
{1.573399,0.978995},
{1.607346,0.990937},
{1.6351,0.991299},
{1.643,0.980399},
{1.6717,0.945099},
{1.705207,0.904376},
{1.731217,0.935865},
{1.6998,0.965999},
{1.741881,0.974949},
{1.7606,0.956299},
{1.785,0.974099},
{1.6727,0.9905},
{1.5528,0.985099},
{1.554302,0.968505},
{1.5625,0.942299},
{1.574,0.919599},
{0.547671,0.609807},
{0.591039,0.598207},
{0.5754,0.643199},
{0.6153,0.617499},
{0.6077,0.653799},
{0.600316,0.687948},
{0.5656,0.680299},
{0.547672,0.743718},
{0.5684,0.771199},
{0.584669,0.793912},
{0.551343,0.813402},
{0.5792,0.843699},
{0.551368,0.866909},
{0.562212,0.8894},
{0.5299,0.891799},
{0.513488,0.865653},
{0.4928,0.877299},
{0.520307,0.818104},
{0.514707,0.777267},
{0.483091,0.780005},
{0.493108,0.705968},
{0.4685,0.707399},
{0.4583,0.752399},
{0.5445,0.634599},
{0.4858,0.666073},
{0.529085,0.693143},
{0.962268,0.730487},
{0.9663,0.695499},
{0.986548,0.714401},
{0.9795,0.763799},
{0.927152,0.713217},
{0.9532,0.806399},
{0.982571,0.816101},
{0.973473,0.872162},
{0.989825,0.924419},
{0.934959,0.888104},
{0.9392,0.924499},
{0.9447,0.956099},
{0.9897,0.958299},
{0.9538,0.989599},
{0.9901,0.993199},
{0.939882,0.685247},
{0.913524,0.7759},
{0.887431,0.879335},
{0.893,0.928399},
{0.9035,0.958099},
{0.9223,0.986099},
{0.813557,0.920755},
{0.821955,0.850836},
{0.849074,0.87887},
{0.837219,0.95383},
{0.8519,0.934599},
{0.8843,0.816499},
{0.8492,0.821199},
{0.824091,0.772031},
{0.816166,0.855437},
{0.880059,0.770245},
{0.8495,0.779099},
{0.851,0.754099},
{0.9051,0.739599},
{0.525956,0.901859},
{0.5361,0.913199},
{0.5182,0.922399},
{0.513069,0.911694},
{0.499381,0.951682},
{0.50707,0.953706},
{0.5283,0.921199},
{0.467873,0.9529},
{0.459625,0.956146},
{0.457706,0.908849},
{0.4464,0.919599},
{0.439163,0.943277},
{0.466877,0.91032},
{0.476021,0.897956},
{0.4548,0.896999},
{0.479883,0.908079},
{0.501254,0.908324},
{0.503618,0.897837},
{0.485229,0.962096},
{0.5059,0.958999},
{0.494579,0.980954},
{0.5114,0.976199},
{0.4657,0.965299},
{0.4742,0.9883},
{0.519379,0.943475},
{0.218275,0.055184},
{0.2399,0.078999},
{0.2231,0.068699},
{0.2142,0.058899},
{0.2399,0.085999},
{0.253392,0.073426},
{0.2499,0.051699},
{0.2337,0.047199},
{0.2228,0.045999},
{0.286882,0.159547},
{0.2572,0.110999},
{0.2802,0.106099},
{0.2608,0.082299},
{0.2688,0.060499},
{0.2692,0.021799},
{0.2632,0.004499},
{0.2462,0.038999},
{0.339492,0.097869},
{0.325031,0.072057},
{0.2936,0.017499},
{0.2819,0.005599},
{0.330714,0.228529},
{0.314,0.201899},
{0.335849,0.183225},
{0.3262,0.154799},
{0.345281,0.144598},
{0.35982,0.084024},
{0.346735,0.048235},
{0.379233,0.077362},
{0.4074,0.122305},
{0.403976,0.089372},
{0.392659,0.038044},
{0.44098,0.09191},
{0.444,0.053399},
{0.436632,0.026899},
{0.499525,0.059731},
{0.52843,0.109695},
{0.455368,0.145134},
{0.496973,0.14923},
{0.538783,0.146366},
{0.519066,0.192394},
{0.5351,0.181699},
{0.371,0.13548},
{0.416033,0.149877},
{0.3799,0.179499},
{0.421447,0.177438},
{0.4684,0.178499},
{0.472342,0.203369},
{0.5042,0.200899},
{0.507317,0.218708},
{0.494887,0.23101},
{0.468484,0.240513},
{0.4233,0.209699},
{0.4327,0.238499},
{0.4433,0.258699},
{0.4104,0.275699},
{0.3976,0.247399},
{0.369,0.254399},
{0.3832,0.291299},
{0.3629,0.297299},
{0.3496,0.261899},
{0.342252,0.210124},
{0.3892,0.214299},
{0.1383,0.901099},
{0.1292,0.939399},
{0.1075,0.922399},
{0.108811,0.914321},
{0.0768,0.918899},
{0.1027,0.927199},
{0.096049,0.938287},
{0.11,0.970299},
{0.0881,0.949099},
{0.082435,0.956536},
{0.072853,0.965866},
{0.0529,0.949599},
{0.0687,0.967699},
{0.077263,0.857804},
{0.0908,0.855499},
{0.107928,0.872818},
{0.1218,0.870799},
{0.106524,0.891615},
{0.1097,0.899099},
{0.1082,0.906299},
{0.078016,0.90535},
{0.0384,0.920099},
{0.0657,0.933799},
{0.098635,0.884307},
{0.080403,0.888981},
{0.0524,0.859799},
{0.064189,0.890622},
{0.031347,0.895458},
{0.0335,0.872999},
{0.011,0.885799},
{0.0201,0.865599},
{0.242285,0.902769},
{0.207736,0.926976},
{0.198855,0.915061},
{0.190292,0.902559},
{0.1623,0.899399},
{0.1864,0.933899},
{0.217403,0.936267},
{0.2419,0.919299},
{0.259114,0.920771},
{0.262262,0.896959},
{0.2307,0.854699},
{0.22193,0.884599},
{0.182954,0.888618},
{0.1506,0.864199},
{0.1782,0.871699},
{0.173843,0.843056},
{0.1598,0.839999},
{0.162421,0.809097},
{0.1551,0.833599},
{0.143869,0.833587},
{0.1474,0.803799},
{0.135319,0.827732},
{0.123675,0.826076},
{0.134034,0.78886},
{0.114198,0.818574},
{0.0832,0.835899},
{0.1056,0.813499},
{0.09559,0.807668},
{0.0592,0.818299},
{0.0885,0.801999},
{0.080794,0.795364},
{0.0536,0.788699},
{0.078068,0.78283},
{0.062034,0.770671},
{0.056792,0.751222},
{0.0506,0.784499},
{0.0366,0.786399},
{0.0337,0.795299},
{0.026,0.753099},
{0.0337,0.761999},
{0.0213,0.735499},
{0.042,0.726399},
{0.0191,0.701399},
{0.0562,0.699199},
{0.058976,0.675936},
{0.022571,0.678032},
{0.038766,0.663811},
{0.019828,0.650678},
{0.0392,0.640899},
{0.058044,0.648411},
{0.064674,0.619111},
{0.085049,0.645093},
{0.075249,0.59568},
{0.27562,0.889601},
{0.2478,0.850599},
{0.291264,0.858619},
{0.2081,0.834899},
{0.196874,0.780045},
{0.176991,0.792795},
{0.15091,0.758272},
{0.205192,0.748505},
{0.1778,0.753799},
{0.096757,0.728107},
{0.087311,0.75433},
{0.12197,0.777899},
{0.066795,0.736419},
{0.066786,0.699451},
{0.0748,0.768099},
{0.073146,0.665673},
{0.09741,0.688012},
{0.1017,0.673599},
{0.1144,0.701299},
{0.1298,0.685299},
{0.0503,0.761499},
{0.299382,0.823038},
{0.331892,0.837872},
{0.400359,0.710588},
{0.3707,0.690899},
{0.410038,0.699211},
{0.425969,0.753327},
{0.4272,0.728099},
{0.431274,0.695489},
{0.4489,0.651899},
{0.4123,0.643999},
{0.377,0.659599},
{0.36637,0.7251},
{0.3933,0.766999},
{0.446364,0.76553},
{0.4471,0.749199},
{0.446888,0.706968},
{0.454034,0.693326},
{0.471979,0.668313},
{0.457,0.631699},
{0.367881,0.838894},
{0.3981,0.795999},
{0.4083,0.820202},
{0.4416,0.807399},
{0.4692,0.791899},
{0.3605,0.856299},
{0.389447,0.87086},
{0.4037,0.854999},
{0.3311,0.861499},
{0.339265,0.912905},
{0.375631,0.896656},
{0.3939,0.890099},
{0.425868,0.886425},
{0.432196,0.876615},
{0.433999,0.864626},
{0.438184,0.851104},
{0.4417,0.831599},
{0.4736,0.822999},
{0.4635,0.851999},
{0.45,0.883399},
{0.421645,0.896858},
{0.4358,0.912399},
{0.413904,0.906905},
{0.407643,0.917162},
{0.418,0.936999},
{0.399838,0.926592},
{0.390029,0.934779},
{0.388025,0.962441},
{0.380872,0.944495},
{0.3717,0.945399},
{0.363,0.947499},
{0.36139,0.954273},
{0.345488,0.95964},
{0.3356,0.986699},
{0.3342,0.957099},
{0.3166,0.965299},
{0.3098,0.969899},
{0.299563,0.969923},
{0.290519,0.991815},
{0.284109,0.965149},
{0.2726,0.966899},
{0.263514,0.96179},
{0.2428,0.979399},
{0.2493,0.958299},
{0.237457,0.952107},
{0.2124,0.960499},
{0.226854,0.944523},
{0.327476,0.915265},
{0.3365,0.926099},
{0.355407,0.926115},
{0.3727,0.917399},
{0.303238,0.916995},
{0.2997,0.937099},
{0.28258,0.92916},
{0.2691,0.936899},
{0.720441,0.560387},
{0.696409,0.513737},
{0.685328,0.509178},
{0.6851,0.529052},
{0.6543,0.550499},
{0.639225,0.500853},
{0.665936,0.45273},
{0.713765,0.460684},
{0.731589,0.506339},
{0.747714,0.547004},
{0.754812,0.590027},
{0.7495,0.608699},
{0.7412,0.607499},
{0.661994,0.55213},
{0.6806,0.597399},
{0.632439,0.549966},
{0.5866,0.529199},
{0.598547,0.483104},
{0.613146,0.441309},
{0.6361,0.463199},
{0.660383,0.39723},
{0.70038,0.400346},
{0.730249,0.375826},
{0.744758,0.434495},
{0.744796,0.469813},
{0.7554,0.529299},
{0.784735,0.549702},
{0.784619,0.606243},
{0.763404,0.626602},
{0.730708,0.642487},
{0.7247,0.627699},
{0.67609,0.657409},
{0.637545,0.605891},
{0.618895,0.554666},
{0.584457,0.540624},
{0.554934,0.550431},
{0.759458,0.462111},
{0.778,0.417899},
{0.769894,0.473228},
{0.820194,0.456228},
{0.810653,0.50993},
{0.802556,0.518164},
{0.7871,0.513999},
{0.7732,0.527799},
{0.803019,0.648628},
{0.822919,0.634473},
{0.8308,0.663099},
{0.831095,0.67383},
{0.811976,0.670648},
{0.786572,0.69645},
{0.754723,0.727354},
{0.705314,0.741717},
{0.850239,0.628785},
{0.838349,0.59444},
{0.8575,0.667699},
{0.845889,0.68236},
{0.83869,0.705283},
{0.8257,0.720199},
{0.813216,0.749087},
{0.772523,0.784168},
{0.738165,0.812956},
{0.793629,0.839915},
{0.784927,0.85999},
{0.708119,0.854581},
{0.7034,0.825099},
{0.869793,0.613214},
{0.902991,0.636616},
{0.8883,0.683399},
{0.858566,0.706028},
{0.836236,0.724355},
{0.8166,0.750799},
{0.80631,0.780712},
{0.7959,0.811899},
{0.8036,0.820199},
{0.8046,0.851599},
{0.7912,0.881099},
{0.7696,0.891599},
{0.7543,0.889699},
{0.7101,0.890999},
{0.8363,0.738199},
{0.7783,0.910299},
{0.6246,0.035499},
{0.6279,0.019799},
{0.6404,0.024699},
{0.6495,0.019799},
{0.7197,0.041699},
{0.7195,0.059399},
{0.703,0.061699},
{0.7017,0.040699},
{0.683,0.064699},
{0.6831,0.039499},
{0.6637,0.039799},
{0.6639,0.064899},
{0.647,0.064199},
{0.6463,0.041399},
{0.6337,0.086699},
{0.6053,0.027999},
{0.6208,0.083099},
{0.6016,0.085599},
{0.5849,0.024899},
{0.58,0.085299},
{0.5669,0.026499},
{0.5625,0.082599},
{0.5508,0.029199},
{0.5472,0.078299},
{0.535181,0.036214},
{0.532442,0.070298},
{0.5285,0.057599},
{1.653308,0.745899},
{1.628197,0.749133},
{1.62962,0.691209},
{1.656354,0.684538},
{1.617937,0.675326},
{1.606762,0.77153},
{1.6422,0.784699},
{1.677628,0.769749},
{1.6728,0.677399},
{0.665553,0.671754},
{0.6776,0.770899},
{0.651746,0.747718},
{0.6422,0.784699},
{0.6067,0.773899},
{0.626501,0.74643},
{0.608898,0.691444},
{0.631686,0.682821},
{0.625041,0.665788},
{0.6578,0.684899},
{1.6788,0.721899},
{1.6776,0.770899},
{1.653261,0.746895},
{1.6578,0.684899},
{1.631731,0.682816},
{1.628189,0.747857},
{1.6422,0.784699},
{1.6067,0.773899},
{1.6081,0.719999},
{1.6169,0.675799},
{1.67135,0.676626},
{0.647475,0.140275},
{0.594929,0.152437},
{0.611642,0.185074},
{0.65023,0.177008},
{0.6163,0.222799},
{0.587036,0.208873},
{0.6054,0.108599},
{0.610226,0.119203},
{0.6336,0.106599},
{0.64106,0.126152},
{0.6361,0.091999},
{0.654,0.106699},
{0.690638,0.118929},
{0.677374,0.150518},
{0.68324,0.185908},
{0.694098,0.232879},
{0.649304,0.235942},
{0.6428,0.270199},
{0.611646,0.292002},
{0.5813,0.268699},
{0.5593,0.234999},
{0.5554,0.263499},
{0.5295,0.258699},
{0.512709,0.237412},
{0.6779,0.248099},
{0.653715,0.244499},
{0.6446,0.324799},
{0.6304,0.401299},
{0.615106,0.373816},
{0.599219,0.294471},
{0.728086,0.109627},
{0.711485,0.085854},
{0.703909,0.156078},
{0.7328,0.226199},
{0.750258,0.253583},
{0.697741,0.264438},
{0.662197,0.364412},
{0.6565,0.091599},
{0.689278,0.092838},
{0.741697,0.14503},
{0.739953,0.170279},
{0.76304,0.214848},
{0.771278,0.239939},
{0.781337,0.292689},
{0.763789,0.286938},
{0.712877,0.286446},
{0.687277,0.319842},
{0.753564,0.094729},
{0.7709,0.130099},
{0.761802,0.176334},
{0.804327,0.18234},
{0.7989,0.201899},
{0.801435,0.254182},
{0.8125,0.313399},
{0.808076,0.347195},
{0.793523,0.359939},
{0.7664,0.349499},
{0.735828,0.067855},
{0.769,0.061699},
{0.77453,0.091295},
{0.8012,0.107099},
{0.783277,0.15256},
{0.822441,0.13395},
{0.8497,0.147499},
{0.8536,0.171799},
{0.8199,0.190799},
{0.835,0.225199},
{0.885098,0.322379},
{0.846593,0.301113},
{0.841894,0.322338},
{0.838831,0.356228},
{0.85193,0.416638},
{0.8367,0.421399},
{0.8043,0.400099},
{0.7581,0.048799},
{0.7773,0.031999},
{0.796142,0.045002},
{0.808331,0.055552},
{0.8201,0.082399},
{0.856043,0.102582},
{0.882381,0.086768},
{0.886574,0.128569},
{0.92891,0.100882},
{0.915053,0.121717},
{0.9278,0.188099},
{0.898819,0.200122},
{0.8654,0.207599},
{0.873559,0.369151},
{0.8855,0.349299},
{0.914164,0.398543},
{0.90846,0.433585},
{0.874789,0.415518},
{0.903614,0.465198},
{0.894294,0.472365},
{0.887411,0.495113},
{0.855171,0.463283},
{0.847443,0.475443},
{0.9077,0.331099},
{0.923023,0.366889},
{0.9389,0.430799},
{0.949774,0.489629},
{0.9295,0.531899},
{0.943022,0.51941},
{0.9369,0.560599},
{0.911625,0.558942},
{0.875032,0.535612},
{0.854031,0.551851},
{0.841585,0.552079},
{0.801075,0.550264},
{0.9699,0.531499},
{0.9742,0.491499},
{0.9754,0.427499},
{0.944937,0.362094},
{0.9723,0.355699},
{0.9674,0.310699},
{0.940538,0.290329},
{0.965858,0.277049},
{0.9638,0.242499},
{0.945027,0.222287},
{0.970647,0.143308},
{0.9802,0.178699},
{0.957931,0.577907},
{0.923941,0.605808},
{0.891892,0.592097},
{0.613893,0.581701},
{0.546039,0.565894},
{0.5761,0.562299},
{0.5322,0.568599},
{0.857903,0.058324},
{0.87376,0.054153},
{0.897023,0.050739},
{0.962275,0.08294},
{0.9483,0.121399},
{0.834843,0.042216},
{0.851675,0.031049},
{0.917301,0.046801},
{0.952952,0.032133},
{0.9923,0.060799},
{0.977627,0.085942},
{0.8035,0.027299},
{0.8363,0.026899},
{0.919824,0.298811},
{0.888691,0.273646},
{0.9295,0.663299},
{0.9322,0.658099},
{0.95297,0.623989},
{0.9469,0.653699},
{0.9571,0.627299},
{0.9662,0.590199},
{0.101,0.160399},
{0.1325,0.118299},
{0.099626,0.127484},
{0.0791,0.192399},
{0.06447,0.187628},
{0.078292,0.126641},
{0.1238,0.079999},
{0.1631,0.080499},
{0.168451,0.097598},
{0.1498,0.129799},
{0.1163,0.172099},
{0.090344,0.203346},
{0.076,0.208099},
{0.018186,0.229688},
{0.009,0.170099},
{0.0074,0.117999},
{0.0393,0.125399},
{0.050158,0.07833},
{0.138439,0.042581},
{0.190399,0.070422},
{0.179516,0.106484},
{0.104667,0.210732},
{0.067128,0.245875},
{0.0141,0.296799},
{0.0598,0.290199},
{0.026258,0.363708},
{0.137883,0.205986},
{0.099058,0.231943},
{0.188998,0.118029},
{0.216688,0.089531},
{0.057403,0.049088},
{0.110219,0.020592},
{0.205401,0.011609},
{0.0482,0.024999},
{0.0497,0.009499},
{0.10637,0.009184},
{0.198925,0.002834},
{0.0195,0.002999},
{0.0159,0.019699},
{0.0102,0.058299},
{0.0091,0.076099},
{0.5981,0.928799},
{0.59326,0.956104},
{0.6052,0.926599},
{0.589849,0.913394},
{0.6201,0.908999},
{0.610593,0.965623},
{0.573399,0.978995},
{0.607346,0.990936},
{0.6351,0.991299},
{0.643,0.980399},
{0.6727,0.9905},
{0.6998,0.965999},
{0.74188,0.97495},
{0.731214,0.935867},
{0.7606,0.956299},
{0.785,0.974099},
{0.5881,0.920399},
{0.572235,0.915365},
{0.578,0.898099},
{0.612222,0.865352},
{0.682831,0.864026},
{0.6433,0.923299},
{0.6717,0.945099},
{0.705404,0.904153},
{0.632312,0.80633},
{0.5943,0.793999},
{0.595069,0.828718},
{0.662713,0.830752},
{0.6559,0.800099},
{0.6743,0.798399},
{0.574,0.919599},
{0.5625,0.942299},
{0.554303,0.968505},
{0.5528,0.985099},
{0.628,0.793599},
{0.6886,0.860499},
{0.0097,0.449899},
{0.0193,0.446899},
{0.774296,0.988588},
{0.785871,0.990422},
{0.773438,0.97779},
{0.774296,0.988588},
{0.657183,0.970696},
{0.773438,0.977784},
{0.86457,0.636489},
{0.93983,0.669488},
{0.927686,0.594028},
{0.874039,0.550762},
{0.928236,0.552584},
{0.961592,0.580249},
{0.971166,0.589964},
{0.962403,0.647804},
{0.955262,0.6655},
{0.893877,0.65909},
{0.92251,0.670292},
{0.838182,0.607203},
{0.825705,0.551075},
{0.844054,0.521059},
{0.888024,0.506559},
{0.928763,0.521282},
{0.970905,0.559803},
{0.985278,0.554827},
{0.990915,0.501452},
{0.988744,0.532269},
{0.989819,0.465367},
{0.925097,0.482751},
{0.8865,0.470901},
{0.924756,0.448134},
{0.915316,0.419113},
{0.993286,0.418884},
{0.930877,0.372573},
{0.963801,0.337059},
{0.994845,0.37103},
{0.997775,0.326421},
{0.970125,0.294153},
{0.999302,0.279389},
{0.971802,0.218454},
{0.997504,0.236515},
{0.996266,0.201759},
{0.951666,0.176611},
{0.996666,0.158417},
{0.945717,0.15631},
{0.995899,0.143054},
{0.991793,0.134713},
{0.936366,0.144724},
{0.892334,0.16137},
{0.87721,0.1521},
{0.837839,0.166723},
{0.893962,0.185369},
{0.841064,0.200569},
{0.795426,0.194998},
{0.769149,0.20809},
{0.752505,0.243966},
{0.757348,0.219558},
{0.710712,0.253649},
{0.737919,0.278524},
{0.725883,0.297513},
{0.711421,0.303623},
{0.675147,0.262607},
{0.813082,0.568062},
{0.799513,0.553486},
{0.792579,0.537951},
{0.78887,0.51816},
{0.787017,0.489103},
{0.829098,0.481042},
{0.820202,0.445496},
{0.872728,0.433531},
{0.866988,0.407077},
{0.891383,0.363711},
{0.932642,0.328363},
{0.937413,0.286168},
{0.939981,0.232908},
{0.789958,0.552342},
{0.770099,0.502506},
{0.762825,0.451997},
{0.774364,0.425956},
{0.767586,0.382227},
{0.798546,0.389062},
{0.749744,0.342899},
{0.795883,0.334149},
{0.839215,0.355058},
{0.756586,0.394097},
{0.737014,0.349029},
{0.790891,0.284798},
{0.831118,0.3154},
{0.896719,0.322467},
{0.896918,0.281401},
{0.900276,0.240544},
{0.811628,0.250574},
{0.836753,0.281013},
{0.211106,0.920472},
{0.251431,0.931412},
{0.208955,0.954867},
{0.17341,0.958605},
{0.176554,0.972693},
{0.140017,0.964406},
{0.168448,0.887572},
{0.129801,0.91936},
{0.100232,0.959222},
{0.051412,0.908265},
{0.066417,0.954967},
{0.013567,0.935429},
{0.027377,0.843445},
{0.115905,0.872222},
{0.074657,0.820809},
{0.020232,0.790499},
{0.03196,0.694577},
{0.077078,0.690141},
{0.101332,0.641629},
{0.024546,0.631431},
{0.047402,0.581831},
{0.016658,0.586374},
{0.206146,0.883267},
{0.164184,0.802872},
{0.247719,0.856104},
{0.209552,0.793645},
{0.16111,0.716606},
{0.115493,0.804055},
{0.118178,0.682706},
{0.159027,0.664676},
{0.157321,0.645958},
{0.145701,0.615677},
{0.113727,0.607951},
{0.313404,0.905105},
{0.333252,0.824729},
{0.252069,0.764553},
{0.210055,0.703879},
{0.372313,0.883639},
{0.417379,0.853217},
{0.369611,0.753411},
{0.416261,0.723736},
{0.394702,0.890356},
{0.42133,0.89463},
{0.316852,0.750018},
{0.267394,0.706176},
{0.227185,0.666602},
{0.202737,0.651027},
{0.177723,0.619299},
{0.266318,0.685068},
{0.062043,0.14174},
{0.034115,0.285737},
{0.091593,0.165488},
{0.088176,0.04436},
{0.104919,0.048731},
{0.125241,0.052924},
{0.141162,0.149379},
{0.123034,0.210244},
{0.084684,0.25409},
{0.081992,0.32504},
{0.03475,0.393097},
{0.016997,0.394722},
{0.005563,0.299518},
{0.010957,0.215312},
{0.043508,0.154857},
{0.078676,0.042715},
{0.150349,0.054581},
{0.187728,0.054962},
{0.184612,0.15846},
{0.161194,0.253635},
{0.126107,0.275319},
{0.129001,0.341122},
{0.081865,0.396449},
{0.085764,0.512871},
{0.042623,0.470723},
{0.029038,0.478808},
{0.039005,0.542501},
{0.061233,0.559922},
{0.13401,0.551368},
{0.071598,0.582109},
{0.192849,0.085442},
{0.217227,0.054225},
{0.227286,0.172358},
{0.208879,0.24244},
{0.179723,0.338774},
{0.130275,0.4078},
{0.17263,0.495005},
{0.175998,0.535744},
{0.17499,0.551986},
{0.276255,0.258134},
{0.322056,0.267964},
{0.291711,0.088032},
{0.25289,0.072414},
{0.198672,0.494722},
{0.189977,0.416656},
{0.225703,0.340737},
{0.226148,0.44181},
{0.224219,0.487492},
{0.310137,0.454054},
{0.281803,0.522881},
{0.235391,0.524515},
{0.242438,0.540812},
{0.27352,0.545003},
{0.260385,0.553902},
{0.820203,0.445497},
{0.774364,0.425956},
{0.798543,0.389063},
{0.872726,0.433531},
{0.866976,0.407075},
{0.83921,0.355057},
{0.795883,0.334149},
{0.749746,0.342897},
{0.767586,0.382227},
{0.75658,0.394077},
{0.762825,0.451997},
{0.787017,0.489102},
{0.829099,0.481043},
{0.8865,0.470901},
{0.924756,0.448134},
{0.915319,0.419114},
{0.891386,0.363712},
{0.896747,0.32247},
{0.831118,0.3154},
{0.790891,0.284798},
{0.737918,0.278522},
{0.725883,0.297513},
{0.737014,0.349029},
{0.710712,0.253649},
{0.711421,0.303623},
{0.752506,0.243966},
{0.757347,0.219557},
{0.769153,0.20809},
{0.841064,0.200568},
{0.795427,0.194997},
{0.83784,0.166724},
{0.893962,0.18538},
{0.892334,0.16137},
{0.87721,0.1521},
{0.936366,0.144724},
{0.945717,0.15631},
{0.991793,0.134713},
{0.995899,0.143054},
{0.996665,0.158411},
{0.951666,0.176611},
{0.996266,0.201759},
{0.971802,0.218455},
{0.997504,0.236515},
{0.999302,0.279389},
{0.970125,0.294153},
{0.997775,0.326421},
{0.963801,0.337059},
{0.994845,0.37103},
{0.993286,0.418884},
{0.930877,0.372573},
{0.989819,0.465367},
{0.925097,0.482751},
{0.990916,0.501452},
{0.928763,0.521282},
{0.985278,0.554827},
{0.988744,0.532269},
{0.675147,0.262607},
{0.811627,0.250574},
{0.900291,0.240544},
{0.939981,0.232922},
{0.836756,0.281013},
{0.89692,0.281401},
{0.937413,0.286168},
{0.932642,0.328363},
{0.789958,0.552342},
{0.770099,0.502506},
{0.792579,0.537951},
{0.78887,0.51816},
{0.844054,0.521059},
{0.888024,0.506559},
{0.874038,0.550763},
{0.928236,0.552584},
{0.970905,0.559803},
{0.962403,0.647804},
{0.955262,0.6655},
{0.93983,0.669488},
{0.927674,0.594019},
{0.86457,0.636489},
{0.893877,0.65909},
{0.92251,0.670292},
{0.971166,0.589964},
{0.961592,0.580249},
{0.838181,0.607205},
{0.825706,0.551074},
{0.813082,0.568062},
{0.799513,0.553486},
{0.749423,0.938994},
{0.692078,0.926189},
{0.761203,0.909768},
{0.80115,0.941169},
{0.795038,0.955009},
{0.788398,0.986707},
{0.648061,0.957661},
{0.676203,0.87716},
{0.731813,0.900913},
{0.757292,0.900203},
{0.778676,0.847373},
{0.821303,0.933329},
{0.82634,0.939108},
{0.839442,0.912702},
{0.863972,0.858384},
{0.830414,0.855267},
{0.84858,0.808853},
{0.875497,0.81817},
{0.860714,0.709747},
{0.900381,0.691118},
{0.859095,0.648494},
{0.797732,0.630323},
{0.792813,0.718044},
{0.74194,0.662293},
{0.740133,0.611185},
{0.685292,0.643276},
{0.676916,0.583223},
{0.645034,0.599226},
{0.661089,0.569454},
{0.594164,0.579929},
{0.621563,0.529176},
{0.605517,0.530603},
{0.570882,0.52424},
{0.552447,0.569167},
{0.587513,0.63794},
{0.528878,0.63176},
{0.591892,0.716094},
{0.526918,0.726579},
{0.547055,0.772824},
{0.646483,0.743849},
{0.576382,0.853495},
{0.640422,0.792716},
{0.617604,0.820563},
{0.622295,0.829157},
{0.541687,0.892528},
{0.635338,0.878764},
{0.554503,0.915058},
{0.605052,0.931309},
{0.57523,0.939691},
{0.552021,0.927143},
{0.657183,0.970696},
{0.596109,0.265828},
{0.620838,0.220345},
{0.582293,0.188733},
{0.554618,0.276889},
{0.530823,0.124422},
{0.565474,0.114513},
{0.594254,0.108564},
{0.599483,0.107269},
{0.627602,0.203737},
{0.656147,0.354691},
{0.643849,0.363533},
{0.604421,0.369435},
{0.561324,0.366926},
{0.508977,0.287115},
{0.489787,0.134878},
{0.640604,0.450536},
{0.598272,0.460291},
{0.538786,0.473674},
{0.519115,0.360807},
{0.470467,0.359936},
{0.464067,0.277828},
{0.452344,0.141649},
{0.406548,0.145793},
{0.419177,0.275496},
{0.357348,0.151084},
{0.380439,0.140079},
{0.353711,0.128541},
{0.327175,0.11538},
{0.362032,0.268029},
{0.617186,0.491037},
{0.578703,0.49774},
{0.555706,0.52614},
{0.519885,0.517251},
{0.481902,0.441904},
{0.421212,0.357144},
{0.358264,0.360983},
{0.311437,0.354387},
{0.346672,0.463348},
{0.323012,0.512181},
{0.31078,0.510832},
{0.307448,0.520229},
{0.442732,0.423751},
{0.394247,0.422268},
{0.379401,0.467963},
{0.362013,0.531572},
{0.292161,0.554782},
{0.454693,0.471913},
{0.438038,0.459984},
{0.394835,0.458047},
{0.411932,0.52336},
{0.382015,0.560845},
{0.325595,0.582763},
{0.449825,0.53584},
{0.426993,0.560926},
{0.403593,0.623627},
{0.362459,0.616609},
{0.787757,0.807759},
{0.735309,0.820854},
{0.731616,0.847346},
{0.698272,0.830807},
{0.686992,0.709643},
{0.739277,0.727761},
{0.788238,0.751077},
{0.837944,0.763289},
{0.74049,0.696143},
{0.643514,0.688659},
{0.644593,0.635775},
{0.658522,0.822442},
{0.646246,0.965541},
{0.602096,0.94421},
{0.792461,0.987719},
{0.800578,0.973824},
{0.520035,0.039118},
{0.542608,0.007652},
{0.574214,0.029118},
{0.519846,0.065053},
{0.576559,0.049005},
{0.668119,0.019941},
{0.618974,0.024387},
{0.491662,0.106916},
{0.534261,0.088845},
{0.590785,0.072772},
{0.644377,0.077337},
{0.719125,0.069606},
{0.717949,0.024967},
{0.730992,0.013205},
{0.805869,0.015634},
{0.809473,0.009013},
{0.873768,0.008251},
{0.87803,0.016479},
{0.93153,0.009954},
{0.931557,0.017861},
{0.992114,0.009073},
{0.998002,0.022047},
{0.973451,0.073355},
{0.917072,0.115712},
{0.858888,0.106974},
{0.869605,0.149396},
{0.830062,0.145276},
{0.787127,0.088646},
{0.781986,0.149372},
{0.71858,0.104846},
{0.453557,0.832709},
{0.50484,0.899066},
{0.450354,0.882789},
{0.438688,0.918306},
{0.556143,0.94548},
{0.395943,0.940765},
{0.463021,0.977683},
{0.610293,0.966453},
{0.625236,0.981092},
{0.7412,0.971927},
{0.739342,0.98542},
{0.351555,0.944308},
{0.294614,0.935463},
{0.345118,0.928669},
{0.347363,0.979488},
{0.290047,0.974851},
{0.292506,0.985611},
{0.436632,0.835107},
{0.399204,0.770019},
{0.949694,0.96139},
{0.968292,0.994061},
{0.909878,0.957857},
{0.932329,0.853171},
{0.9059,0.858516},
{0.876309,0.846124},
{0.876309,0.96139},
{0.906142,0.994061},
{0.992056,0.841273},
{0.990565,0.958514},
{0.964061,0.857505},
{0.932329,0.801579},
{0.443626,0.618635},
{0.498974,0.570175},
{0.49907,0.537227},
{0.99257,0.961226},
{0.966769,0.994061},
{0.949774,0.96139},
{0.932329,0.994061},
{0.90962,0.957474},
{0.906142,0.994061},
{0.876309,0.96139},
{0.901739,0.858358},
{0.876309,0.846124},
{0.932329,0.849994},
{0.932329,0.801579},
{0.992056,0.841273},
{0.967343,0.857315},
{0.992056,0.841273},
{0.99299,0.961795},
{0.966463,0.857366},
{0.932329,0.850977},
{0.949839,0.96139},
{0.966769,0.994061},
{0.932329,0.994061},
{0.910299,0.958482},
{0.906227,0.994154},
{0.902084,0.858371},
{0.876309,0.846124},
{0.932329,0.801579},
{0.426993,0.560927},
{0.382014,0.560846},
{0.411932,0.52336},
{0.449825,0.535839},
{0.454693,0.471913},
{0.3794,0.467963},
{0.36201,0.531575},
{0.325595,0.582763},
{0.362459,0.616609},
{0.403593,0.623626},
{0.441771,0.619849},
{0.47429,0.598561},
{0.498974,0.570175},
{0.499069,0.537227},
{0.519885,0.517251},
{0.481902,0.441904},
{0.442732,0.423751},
{0.438038,0.459984},
{0.394835,0.458047},
{0.394248,0.422268},
{0.346672,0.463348},
{0.323012,0.512181},
{0.292161,0.554782},
{0.307448,0.520229},
{0.31078,0.510832},
{0.310137,0.454054},
{0.281803,0.522881},
{0.311436,0.354387},
{0.225698,0.340741},
{0.276256,0.258128},
{0.208866,0.242437},
{0.179715,0.338784},
{0.189978,0.416656},
{0.226148,0.44181},
{0.224219,0.487492},
{0.235391,0.524515},
{0.242438,0.540812},
{0.27352,0.545003},
{0.260385,0.553902},
{0.227286,0.172358},
{0.184612,0.15846},
{0.161196,0.253655},
{0.126107,0.275319},
{0.129001,0.341122},
{0.130275,0.4078},
{0.172631,0.495005},
{0.198672,0.494722},
{0.175998,0.535744},
{0.13401,0.551368},
{0.17499,0.551986},
{0.358264,0.360983},
{0.362032,0.268028},
{0.322055,0.267973},
{0.291711,0.088032},
{0.25289,0.072412},
{0.217227,0.054225},
{0.192849,0.085442},
{0.187729,0.05496},
{0.141154,0.149377},
{0.123034,0.210244},
{0.084684,0.25409},
{0.081992,0.32504},
{0.081865,0.396449},
{0.085764,0.512871},
{0.061233,0.559922},
{0.071597,0.58211},
{0.091591,0.165503},
{0.034115,0.285737},
{0.03475,0.393097},
{0.042623,0.470723},
{0.039005,0.542501},
{0.062039,0.141755},
{0.010957,0.215312},
{0.005563,0.299518},
{0.016997,0.394722},
{0.029038,0.478808},
{0.043509,0.154851},
{0.078676,0.042715},
{0.088176,0.04436},
{0.104919,0.048732},
{0.125241,0.052924},
{0.150349,0.054581},
{0.177723,0.619299},
{0.145701,0.615677},
{0.157321,0.645958},
{0.101332,0.641629},
{0.113727,0.607951},
{0.047402,0.581831},
{0.024546,0.631431},
{0.016658,0.586374},
{0.202737,0.651027},
{0.159027,0.664676},
{0.118178,0.682717},
{0.077078,0.690141},
{0.03196,0.694577},
{0.227185,0.666602},
{0.210055,0.703881},
{0.16111,0.716608},
{0.115492,0.80406},
{0.074656,0.820809},
{0.020232,0.790499},
{0.027379,0.843445},
{0.115904,0.872222},
{0.051412,0.908265},
{0.013567,0.935428},
{0.066417,0.954967},
{0.100232,0.959222},
{0.129801,0.91936},
{0.140017,0.964406},
{0.168448,0.887571},
{0.17341,0.958605},
{0.176554,0.972693},
{0.208955,0.954866},
{0.211106,0.920472},
{0.251431,0.931412},
{0.247719,0.856097},
{0.313404,0.905106},
{0.333252,0.824729},
{0.372313,0.883639},
{0.417379,0.853217},
{0.394702,0.890356},
{0.42133,0.89463},
{0.164184,0.802867},
{0.209552,0.793644},
{0.206146,0.883267},
{0.25207,0.764543},
{0.267394,0.706176},
{0.316852,0.750018},
{0.266318,0.685068},
{0.416262,0.723726},
{0.369611,0.753412},
{0.534261,0.088845},
{0.590785,0.072772},
{0.519846,0.065053},
{0.491662,0.106916},
{0.576559,0.049005},
{0.644377,0.077337},
{0.668118,0.019942},
{0.719125,0.069606},
{0.71858,0.104846},
{0.787127,0.088646},
{0.781986,0.149372},
{0.830058,0.145276},
{0.858884,0.106974},
{0.869605,0.149396},
{0.917072,0.115712},
{0.87803,0.016479},
{0.973451,0.073355},
{0.931557,0.017861},
{0.998002,0.022047},
{0.992114,0.009073},
{0.93153,0.009954},
{0.873768,0.008251},
{0.805869,0.015634},
{0.809473,0.009013},
{0.730992,0.013205},
{0.717949,0.024967},
{0.618974,0.024387},
{0.574214,0.029118},
{0.520035,0.039118},
{0.542608,0.007652},
{0.622294,0.829157},
{0.676204,0.877163},
{0.635336,0.878764},
{0.541687,0.892528},
{0.554503,0.915058},
{0.605052,0.931309},
{0.648061,0.957661},
{0.692076,0.926189},
{0.731812,0.900913},
{0.731615,0.847354},
{0.698273,0.830804},
{0.658522,0.822442},
{0.640422,0.792716},
{0.617604,0.820563},
{0.576382,0.853495},
{0.57523,0.939691},
{0.602096,0.94421},
{0.646246,0.965541},
{0.761203,0.909768},
{0.749428,0.938992},
{0.757292,0.900203},
{0.778676,0.847373},
{0.735309,0.820854},
{0.686993,0.709647},
{0.80115,0.941169},
{0.821302,0.933329},
{0.552021,0.927143},
{0.82634,0.939108},
{0.839442,0.912702},
{0.863972,0.858383},
{0.830415,0.855267},
{0.787757,0.807759},
{0.788238,0.751077},
{0.739277,0.727761},
{0.74049,0.696143},
{0.685292,0.643284},
{0.643514,0.688659},
{0.646481,0.74385},
{0.792813,0.718046},
{0.837944,0.763288},
{0.860715,0.709748},
{0.797732,0.630323},
{0.74194,0.662293},
{0.740133,0.611185},
{0.84858,0.808853},
{0.875497,0.81817},
{0.900381,0.691107},
{0.859077,0.648479},
{0.644593,0.635775},
{0.587513,0.63794},
{0.591892,0.716094},
{0.547055,0.772824},
{0.645034,0.599226},
{0.594164,0.579929},
{0.552447,0.569167},
{0.528878,0.63176},
{0.526918,0.726579},
{0.570882,0.52424},
{0.605542,0.530608},
{0.621563,0.529176},
{0.661089,0.569454},
{0.676916,0.583223},
{0.795039,0.955009},
{0.788397,0.986706},
{0.800578,0.973824},
{0.792461,0.987719},
{0.785871,0.990422},
{0.421212,0.357144},
{0.470467,0.359936},
{0.464067,0.277828},
{0.419176,0.275493},
{0.508977,0.287115},
{0.489787,0.134878},
{0.452344,0.141649},
{0.406548,0.145793},
{0.357348,0.151084},
{0.327175,0.115379},
{0.353711,0.128541},
{0.380439,0.140079},
{0.643849,0.363533},
{0.656147,0.354691},
{0.640604,0.450536},
{0.598275,0.46029},
{0.617186,0.491037},
{0.578703,0.49774},
{0.538786,0.473671},
{0.555706,0.52614},
{0.620843,0.220368},
{0.596109,0.265828},
{0.604421,0.369435},
{0.561324,0.366926},
{0.519115,0.360807},
{0.627602,0.203734},
{0.599483,0.107269},
{0.594254,0.108564},
{0.582293,0.188733},
{0.554618,0.276889},
{0.565473,0.114513},
{0.530823,0.124422},
{0.949775,0.96139},
{0.909621,0.957475},
{0.932329,0.994061},
{0.966769,0.994061},
{0.99257,0.961226},
{0.967343,0.857315},
{0.992056,0.841273},
{0.932329,0.849994},
{0.932329,0.801579},
{0.876309,0.846124},
{0.90174,0.858358},
{0.876309,0.96139},
{0.906142,0.994061},
{0.99299,0.961795},
{0.992056,0.841273},
{0.966463,0.857366},
{0.932329,0.850977},
{0.932329,0.801579},
{0.876309,0.846124},
{0.902083,0.858371},
{0.906227,0.994154},
{0.910299,0.958482},
{0.932329,0.994061},
{0.949839,0.96139},
{0.966769,0.994061},
{0.964058,0.857506},
{0.932329,0.853176},
{0.949694,0.96139},
{0.990565,0.958514},
{0.96829,0.994061},
{0.909878,0.957857},
{0.905898,0.858516},
{0.876309,0.846124},
{0.932329,0.801579},
{0.992056,0.841273},
{0.876309,0.96139},
{0.906142,0.994061},
{0.438689,0.918306},
{0.395944,0.940765},
{0.55614,0.94548},
{0.463021,0.977684},
{0.347362,0.979489},
{0.351555,0.944308},
{0.345118,0.928669},
{0.294614,0.935463},
{0.290047,0.974851},
{0.292506,0.985611},
{0.50484,0.899066},
{0.450354,0.882789},
{0.453557,0.832709},
{0.436632,0.835107},
{0.399204,0.770019},
{0.610298,0.966453},
{0.62524,0.981092},
{0.7412,0.971927},
{0.739342,0.98542}
};


// normal array: 56kb.
const tgx::fVec3 nanosuit_norm_array[4790] PROGMEM = {
{0.6865062987241862,0.6106056023321023,0.3948036223398525},
{0.944675580451864,0.0030999198681071006,0.32799152152875133},
{0.604639919645286,0.7354485559165452,-0.3058201909155283},
{0.38829580254506163,0.8266910635179048,-0.40719559823937446},
{0.5543158619753389,0.694819882555413,0.45821311195580056},
{0.7008281423190935,0.1944078066022143,0.6863275600365211},
{0.626525193084531,0.30621231304466634,0.7167288202453048},
{0.599188339908357,0.6197879390440583,0.5067901379598722},
{0.907558244205754,-0.3650832029082424,0.20749045358384086},
{0.9358080058717355,-0.3106026572170988,0.16670142613680092},
{0.8888074971228576,-0.4475037747102596,0.09880083338854447},
{0.8471271678039142,-0.4392140858216021,0.29910959259845443},
{0.9624724448083519,-0.26259248208485525,-0.06849803892921777},
{0.9220471915829287,-0.37081897900103034,0.11100568141616603},
{0.9761045828217745,0.13560063664648359,0.1698007972166144},
{0.79080551588771,0.07460052034044407,0.6075042373568335},
{0.773901079592759,0.12120016907435378,0.6216008671338145},
{0.6882010426253693,0.32670049495162473,0.6478009814192303},
{0.9829990170014746,-0.17359982640026042,-0.059799940200089705},
{0.8677540237084213,-0.47542959879103774,-0.14480901536588614},
{0.6625825411800568,-0.7486802725347247,0.021499433497390915},
{0.9089316768209155,-0.39351371419191356,-0.13780480258105637},
{0.9510192821114192,-0.2753055818772594,0.1406028507516988},
{0.9799560107619932,-0.03729832571573709,-0.19569121561849193},
{0.9287440885283484,0.024401158350481,-0.36991756040339846},
{0.9593999376390062,0.2775999819560018,0.049899996756500316},
{0.8758546900743256,0.4818300864099224,-0.026801673548746206},
{0.729397498170872,0.5808980075232513,0.36129876074737594},
{0.9335788780168246,0.25899414032386203,-0.2476943959776858},
{0.295909342005393,0.8058254403107321,-0.5129161930198245},
{0.8908570216397114,-0.45417808870665266,-0.009799527233212674},
{0.9756817451653205,-0.08069849014537395,-0.20379618700901128},
{0.9986213807126442,-0.03290070441162226,-0.04090087569712311},
{0.9767400032060137,-0.2096085846953829,-0.04520185127972951},
{0.8617544042728669,-0.33812134627440676,-0.37822387802715357},
{0.9804688706075295,-0.09429700611758289,-0.17259452021097357},
{0.9664752440536815,0.21169457751284465,-0.14529627828349706},
{0.8884119892006919,0.2926039487169321,0.35370477327812333},
{0.5296047240952084,0.8002071378795049,0.28140251012158546},
{0.7571898499380919,0.06359914745914244,-0.6500912855847247},
{0.33189488553922036,0.6919893365264854,-0.6410901208773553},
{0.243509348503337,-0.20290778977957732,-0.9484364111727508},
{0.49131081387002123,-0.6755148682458769,-0.5498121014975323},
{0.7899020300508258,-0.3174008157211446,-0.5247013484841985},
{0.6362267443533101,-0.29751250620105274,-0.7118299223996953},
{0.28358638534445163,-0.30408540121032346,-0.9094563380492903},
{0.4262887077616951,0.2351937697995559,-0.8734768619043881},
{0.7806055852529438,-0.05930042429605376,-0.6222044518887799},
{0.9661974685659486,-0.0013999963320144152,-0.25779932456665444},
{-0.0576991420201372,-0.29229565359594634,-0.9545858054146096},
{0.4005781971220798,-0.08349545546603511,-0.9124503366797249},
{0.8044686665556446,-0.34338662535140874,-0.4846811220379378},
{0.9384819343966427,-0.2611949720451817,0.22589565155056107},
{0.986577087013228,-0.16329620748962106,0.0},
{0.9315029342388643,-0.3617011393603835,0.038400120960571535},
{0.7747830169424008,-0.578787313121143,-0.2543944237353469},
{0.9114953058112625,-0.4021979286860009,-0.08609955658842534},
{0.8787016080254141,-0.06590012059733104,-0.47280086522637504},
{0.7044754071927948,-0.6473774004494185,-0.2908898452127523},
{0.796382854061726,-0.5912872697221229,-0.12709726362537088},
{0.6049600134646214,-0.7843481563002462,0.13719093197908436},
{0.25140574594398607,-0.8657197862518248,-0.43280989198312325},
{0.006700292306627954,-0.9919432744692936,0.1265055189236472},
{0.8753762732476661,0.045598764062249914,0.481286954893879},
{-0.28470200715622573,-0.8075056929352029,0.5166036420685148},
{0.4744079606323697,-0.08880149010150597,0.8758146962939067},
{0.9489968066311186,-0.06829977017166007,0.30779896425822795},
{0.7032967859410324,-0.7107967516662672,0.011899945617372792},
{0.6641882937844822,-0.7064875482666918,0.24439569256387753},
{0.641209178975096,-0.36920528521148693,0.6727096299072787},
{0.69028303995406,-0.6543839219845529,0.30869241552052484},
{0.38768341913473786,-0.8891619713557104,0.24308960327999685},
{0.46421580681733776,-0.815127755572624,0.3465117989276336},
{0.3620993156329402,-0.9275982468409703,0.09189982630949241},
{0.6764007778613418,-0.3965004559757866,0.6207007138062314},
{0.34229025513515243,-0.8897746684757775,0.30189140527403596},
{-0.10520507416309328,-0.13570654528452242,-0.9851475148104866},
{-0.008100145034395273,-0.3473062185735158,-0.9377167899694379},
{0.5615829590236587,-0.5192842425587357,-0.6441804526407424},
{0.8081971349462349,-0.559298017292043,-0.18439934630547603},
{0.7768273875323296,-0.6290221765677592,0.029501040077502216},
{0.9167886823135748,-0.3941951336911117,0.06409920870015287},
{0.8736104790205441,-0.47830573731172876,-0.08960107477133786},
{0.8927400447528312,-0.434019468379891,-0.12100542782020003},
{0.10809555195955341,-0.49617958263025347,-0.861464551463046},
{0.5072776143328084,-0.6015734531492559,-0.6170727691795309},
{0.889208478643266,-0.43300412871405103,-0.1477014083396428},
{0.7634957129836073,-0.6286964698792324,-0.147699170671485},
{0.8964946120835722,-0.4410973490128987,-0.041599749986253876},
{0.6816246888933557,-0.6820247033821429,0.26500959882150715},
{0.8050897552980454,-0.5929924542190297,-0.013799824398351788},
{0.44361614792168186,-0.8832321502354135,0.1520055331021092},
{0.4648015942722026,-0.8441028952778963,-0.26730091684371715},
{0.492484587935977,-0.7846754439662155,0.3764882179855743},
{0.9141271774049825,0.2707080482699144,-0.3018089729141491},
{0.798620964075464,-0.28230741066679627,-0.531513952424379},
{0.1485979374749417,-0.5675921218760223,-0.809788760210012},
{0.24349038475455528,-0.8232674898087284,-0.5127797507274577},
{0.9584069916045057,-0.17020124162258646,-0.22910167130278825},
{0.6650134965858712,-0.733514886835694,0.14040284950474632},
{0.5009107246134222,-0.6929148354654426,-0.5186111035825928},
{0.6819872162694455,-0.7174865508406555,-0.14179734203373512},
{0.5600080501735824,-0.8143117058149073,0.15260219367230118},
{0.7927985689998743,0.5623989848707485,0.23489957600664796},
{0.49738663540065775,-0.7956786204027008,0.3456907114153747},
{0.8267764868110679,-0.5409846146163374,0.15419561473907434},
{0.011899518733697028,0.8837642568774313,-0.46778108097676213},
{-0.43658905921526237,0.5139871196441705,0.7383814963915477},
{0.0014999427407787855,0.8852662056076391,0.4650822458241421},
{-0.15150530656629535,0.9561334891619471,-0.2507087812288465},
{-0.12450000311250012,0.7043000176075007,-0.6989000174725006},
{0.043901747982894604,0.8596342270181366,-0.5090202670454067},
{0.3949268519895312,0.5675385882604683,0.7224491209856606},
{-0.06419728162366324,0.3303860101005972,0.9416601262461632},
{-0.16870636794203922,0.4279161519999916,0.8879335156830861},
{-0.19210464322534082,0.49971207818689645,0.8446204147221388},
{-0.5912875742221902,0.510289276383534,0.6244868765461827},
{-0.7474908694547941,0.4736942138605163,0.4656943115787259},
{-0.7278060262588462,0.6832056569662596,0.05940049183810864},
{-0.05259706095834818,0.9279481477062188,-0.368979382008184},
{-0.2698888996978285,0.9287618008126828,-0.2540895495117385},
{-0.7477262979963589,0.6301221617861519,-0.20940736498654214},
{-0.02229971244706198,0.9124882335400922,-0.4084947324943865},
{-0.1535918007205719,0.9158511085935667,-0.3709801957508606},
{-0.9572830849573319,0.11929789202487172,-0.263395345845358},
{-0.8045640810383852,0.5482755227856656,-0.22818981269321337},
{-0.6863024638302678,0.5548019917427255,-0.470301688386092},
{-0.09370546084485075,0.8790512282030288,-0.4674272401161498},
{-0.1586916260638331,0.8627544736476068,-0.4800746671282059},
{-0.18169911512746398,0.7977961147423817,-0.5748972002574521},
{-0.6086257788908089,0.2802118686250487,-0.7423314421141102},
{-0.37590832646164773,-0.3895086277116568,-0.840818624338796},
{-0.3845899431044801,-0.11829690657633904,-0.9154760606140184},
{0.04729817219745247,0.1719933534452817,-0.9839619755241698},
{0.3675949474421708,0.398694519981484,0.8401884516890966},
{0.22040675997899442,0.5973183200338175,0.7711236507250571},
{0.12329986128773408,0.6743992413012803,0.7279991810013821},
{-0.12970062191597312,0.6684032050010519,0.7324035118832593},
{-0.24890447907640184,0.7248130431280677,0.6424115603000423},
{-0.8013188232002381,0.3573083932727381,0.47981127089913167},
{-0.8548911519223662,-0.15149843199934318,0.49619486440972993},
{-0.792639232649754,0.6065300209463486,0.06200306891784601},
{-0.9183098305593546,-0.05990064123979673,0.3913041889337639},
{-0.7182358660034757,0.6955347323940648,0.019200958823818896},
{-0.7963715461529748,0.5468804603102235,-0.2582907714356019},
{-0.6519660301949719,0.49847402768741333,-0.5713702295297652},
{-0.7305998502270461,0.5497998872910346,-0.4048999169955255},
{-0.5287997250242145,0.08379995642403398,-0.8445995608083424},
{-0.36700409945868656,0.10290114941225845,-0.9245103268380265},
{0.5320063787947229,0.5189062217228979,0.6691080226532877},
{0.3657824629802085,0.547173766382641,0.7528639048053554},
{0.35399592730028445,0.6925920317745113,0.6284927692322847},
{0.2294078309699675,0.3279111934396354,0.9164312829157726},
{0.21040963592992115,0.8787402428309017,-0.428419619925752},
{0.5388872877988196,0.5913860493676413,0.5998858488597362},
{0.2706050793050083,0.8367157053011842,0.4761089366486122},
{0.1546917853108558,0.30238394232710275,0.9405500534155847},
{-0.1333919853833301,0.6669599269166507,0.7330559556560668},
{-0.5351662213741266,0.5663642522165645,0.6267604401294892},
{0.16600645362632954,-0.034001321827079545,0.9855383135466732},
{-0.7278048435573509,0.398802654040494,0.5579037128615637},
{-0.8280964019289504,0.29319872605430297,0.4777979239725305},
{-0.8238194876804743,-0.18000425805108689,0.5375127150136622},
{-0.6125839811383372,0.7734797737683705,0.16269574556187963},
{-0.7645033103065004,0.15900068847447166,0.6247027049685688},
{-0.9186636170479059,0.07739693475509733,0.3873846579344277},
{-0.9892051240958143,-0.13360069205337727,0.06020031183842298},
{-0.894771273829373,-0.22259285377114263,-0.3870875727529619},
{-0.14940086951559087,-0.06240036317117048,-0.9868057432261385},
{0.15229857982236467,0.7819927079519973,0.6043943640488327},
{-0.23449661154844448,0.4940928604097502,0.8371879027222079},
{-0.41661953783135064,-0.37871776038581967,-0.8264387567542683},
{-0.6527872805637561,-0.21229586345540044,-0.7271858309221253},
{-0.25961138940148504,-0.17490767336794968,-0.9497416660808565},
{-0.7350914215331658,-0.623692721548409,-0.26579689816829744},
{-0.1814022276330331,-0.732808998949761,-0.6558080533723435},
{-0.5605923367551345,-0.5772921084708156,-0.5936918842874124},
{-0.9123365398101437,-0.32191289286954433,-0.2530101332587596},
{-0.8473212426098317,-0.0664016647106017,-0.5269132098797596},
{-0.9890918598074906,0.1265989580948623,0.07529938028865034},
{-0.8372196874524285,-0.10230240566935431,0.5372126327035888},
{-0.9090812231212526,-0.3488927936937686,-0.22769529700221014},
{-0.8333664743410923,-0.4462820464344006,-0.32608688178861317},
{-0.12630143352940587,-0.316903596876237,-0.9400106691816431},
{-0.783286962297018,-0.2927951264656797,-0.5483908721099},
{-0.9628011553620797,-0.26400031680057023,0.057600069120124414},
{-0.9927908415467298,-0.11939889855024129,-0.010499903138840314},
{-0.9464144755201055,0.032600498628439806,-0.3213049143962488},
{-0.9543622032333966,0.19559225372218395,0.22569106168249958},
{-0.8882201450613375,-0.03840087094162954,0.4578103832572397},
{-0.9056163691638102,-0.42150761881906584,-0.046800845932935424},
{-0.8798689147803515,-0.2167923408618936,0.42288505973475465},
{-0.997482678863671,-0.02879949990102629,0.06479887477730915},
{-0.863632404095714,-0.33801268247377414,-0.3740140332697974},
{-0.941492477505157,-0.07179942632487549,0.3292973689245334},
{-0.9975095262614639,0.004300041065588265,-0.07040067232963114},
{-0.8153732521191891,0.23139240929651747,0.5306825912431365},
{-0.500705540337456,0.33370369245178555,0.7987088377621849},
{-0.7649854730637985,-0.3962924744773638,0.5076903590516215},
{-0.43780574842721554,-0.8717114456464224,0.22010288996991806},
{-0.5644997008152378,-0.4064997845551713,-0.7183996192483028},
{-0.9468270228288528,-0.22720648456560558,-0.2278065016903387},
{-0.9871003800337195,0.0009000003465002001,0.1601000616385356},
{-0.9784091530604405,-0.1072010028700728,-0.17670165305169647},
{-0.9395593367518391,-0.20479113683139277,-0.27438812473893637},
{-0.9978318662694822,-0.06270200242042145,0.020000638730596956},
{-0.9850910652645568,-0.14019872840330003,0.09969909573330252},
{-0.9646867211786739,-0.20119723053918231,0.1699976599983151},
{-0.9761963685562633,-0.20479923814825113,-0.07139973439348209},
{-0.887519725345096,-0.4461099149030393,0.11530256262793193},
{-0.8907053709695805,-0.099300598784416,0.44360267493219474},
{-0.8894100815204113,-0.28560323733104287,0.35690404553028426},
{-0.9423696561855982,-0.1149962971788453,0.3141898832486364},
{-0.8744048923090588,-0.36330203268055933,0.32160179936710126},
{-0.9006210747797276,-0.4330101325556541,-0.03720087051055504},
{-0.9026375098811008,-0.0433017994436646,0.42821779496021206},
{-0.9945794820369264,0.09829797213375212,0.03389930066464086},
{-0.9624922952800143,0.13999887931345664,0.23239813966033798},
{-0.9372941841076313,0.02559984115347846,0.3475978431620747},
{-0.7638982506750089,0.3508991964417602,0.5415987597402603},
{-0.9164704443047492,0.25599174439936256,0.3074900836047031},
{-0.8173290933468758,0.02940104654887819,0.575420482456616},
{-0.6157912681417261,0.08239883159285195,0.7835888887883349},
{-0.7990099996727191,0.08410105253125867,0.5954074515708848},
{-0.9754067498380634,0.20260140200655283,0.08680060066223488},
{-0.6150620364674124,0.49496944895361594,0.6137621167024838},
{-0.46227722416223443,0.342883106565499,0.8177597099716101},
{-0.6545312251569119,0.032501550523452466,0.7553360341650353},
{0.3192206702076156,0.44452878417069275,0.8369541945387013},
{-0.06780176659804336,0.36730957037553585,0.927624169562611},
{-0.023700422582301997,0.178703186306218,0.9836175380570568},
{0.6381812345566927,0.03939884149409855,0.7688773914927},
{-0.801839142733152,0.1448070689296089,0.5797283001277229},
{-0.6837699216227071,0.4584798319157813,0.5676750285247306},
{-0.8300052124491013,0.19380121707546488,0.5230032844709398},
{-0.20379494187231334,0.8223795887919062,0.5311868161068344},
{-0.6803870693666189,0.1511971265259153,0.7170863719030017},
{-0.43153127204673436,0.3951286340339855,0.8109587682565397},
{-0.1924035392956583,0.51190941666033,0.8372154007189457},
{-0.29838669075848145,0.04759787694404732,0.9532574808983257},
{-0.6697860953849881,-0.2861940586730123,0.6851857756909435},
{-0.5245689254572565,-0.005599668285475861,0.8513495675453837},
{-0.7208702250702674,0.05879757141646792,0.6905714765342305},
{-0.5390888463671519,0.3330931083748809,0.7735839947127224},
{-0.2877956989254191,0.3431948709909793,0.8940866379750425},
{0.12039500009946663,0.6598725960601166,0.7416691991177277},
{0.47931339699667175,0.7120199012343631,0.5131143417462806},
{0.5954290070306335,0.6621322565585865,0.45502216694480724},
{0.6096560027138689,0.5894574603900701,0.5299617540402666},
{-0.15120191347232256,0.6085077007136791,0.779009858432138},
{0.674028239004622,-0.010500439925146189,-0.7386309455917119},
{0.8873163134603858,0.2913053556981972,-0.35750657281876247},
{0.629073485111392,-0.2974874611677621,-0.718169729783821},
{0.549628422020573,0.02790144282091337,-0.8349431760279774},
{0.8266135896391215,0.2190036004487873,-0.5184085227061704},
{0.14010028440386602,0.12030024420974363,-0.982801995090075},
{0.6968895955160078,-0.36049461785553283,-0.6199907436072963},
{0.9937406547617964,-0.00680027820507217,0.11150456174493338},
{0.7078629585005471,-0.6063682695786577,0.36228104232906944},
{0.16969220536756555,-0.7126672643810488,-0.6806687341997754},
{-0.14610253855366126,-0.8148141575189813,0.5610097476290483},
{-0.5018893324556067,-0.8088828073786417,-0.30629348980106064},
{-0.7950725784196474,-0.26639081233932094,0.5448812073712311},
{-0.8872238444612341,-0.4300115567158822,-0.167104490993544},
{-0.8175310872106479,-0.4787182036057947,-0.32011217249679313},
{-0.7891265703389425,-0.23470790274813053,0.5676191120572599},
{-0.8444685103563622,-0.5231804909632312,0.11469572307622823},
{-0.24469489327086558,-0.272294317276897,-0.9305805789859727},
{-0.5638187049958124,-0.1905063201520083,-0.8036266607567132},
{0.773600549256585,0.6149004365794649,0.1531001087011158},
{0.4781014462590624,0.23850072146577364,0.8453025570441026},
{-0.062601801392753,0.13600391356892025,0.9887284510705253},
{0.8916961924653873,0.38829834196961965,0.23259900680436144},
{0.6109787199817681,0.2114926338398428,0.7628734295811636},
{0.6532272630087443,0.22700947443812763,0.7223301470777955},
{-0.16770648198079524,0.1870072279690442,0.9679374115039459},
{0.007500235886127987,0.16460517691422222,0.9863310205984044},
{0.40941423762767454,-0.5047175518580541,-0.7600264303786827},
{0.07229827426078984,0.4660888745913436,-0.8817789521876138},
{0.8560856778064145,0.029499506477384918,0.5159913675366311},
{0.8140184906400246,-0.5521125413788178,0.18040409792562712},
{-0.4494975839569794,0.7760958284961328,-0.4422976226566674},
{-0.1457942674821017,0.9813614136278094,0.1251950774263315},
{0.597099349162064,-0.13689985077924396,0.7903991384654085},
{-0.4133840498841469,0.8344678026809883,0.36438594043972694},
{0.016699543691202873,-0.3025917317938916,0.9529739603422958},
{-0.1510010230353966,-0.7692052113829607,0.62090420664025},
{-0.4026938992336396,0.8273874651748532,-0.39149406890978367},
{-0.7925303901604772,0.1295049659631316,-0.5959228510998466},
{-0.33189006667895415,-0.8192754794518444,-0.46758600536028616},
{0.03480118169418698,-0.7187244047014995,-0.6944235795529724},
{-0.19120912758556316,-0.19220917532398138,0.9625459482275341},
{0.7694984417672333,0.15239969139093743,0.6201987440988148},
{-0.2625951840484864,0.6075888569225452,0.7495862527141868},
{-0.8317310324637427,0.3295122943330567,-0.4468166710410006},
{-0.41287552959252,0.09569432836523169,-0.9057463180065504},
{0.257293920216497,0.8593796930977753,0.4418895582731055},
{0.5388777825270302,-0.316986930898253,-0.7804678219750362},
{0.48587995543589924,-0.40088346189391233,-0.7766679592242497},
{0.6707089506706704,-0.6969093003166694,-0.2539033883633267},
{-0.1500956270276089,-0.9884712013110686,0.01989942023883689},
{-0.5768241780921477,-0.6992293088107311,-0.42231770181746525},
{-0.5913009135606172,-0.6979010782579987,-0.4041006243359469},
{0.05049942986465522,0.5947932848217212,-0.8022909421863937},
{-0.5240769673234181,0.08149641831112112,0.847762741646239},
{0.32900105774010097,0.7916025450062733,0.5149016554114833},
{0.14050171904904893,0.947811596545826,0.2862035017212655},
{-0.8508654470557783,-0.08789643059842862,0.51797896530132},
{-0.11589950221270699,0.8702962620855814,-0.47869794399674576},
{-0.9607811592661982,-0.27729456230694915,-0.002699947054557385},
{-0.16230360155687826,0.22680503285951933,-0.9603213097662981},
{-0.17990465419360677,0.18080467747751028,-0.9669250146736985},
{-0.4859936505344334,-0.6761911656201315,-0.553692766051267},
{0.6231917427641123,-0.030099601182926473,-0.7814896453307986},
{0.4320956034496022,-0.8386914663577444,-0.3314966270389797},
{-0.30610965638141824,-0.9279292719905847,0.2127067099389992},
{-0.28610950900755044,-0.7684255390471924,0.5724190246624322},
{0.032700336978708854,-0.10710110368256019,0.9937102402367887},
{0.620705840869444,-0.4863045761475924,0.6150057872316869},
{0.8867748292537023,0.34579018488490104,0.3066912946911485},
{0.8937963622562084,0.16529932723310722,0.41689830322735877},
{0.9067720627831117,0.0602981422428558,0.4172871435811563},
{0.48721563743682933,0.3434110219536272,0.802925770316154},
{-0.11940067342169716,0.34600195145650936,0.9306052486284035},
{0.5256130958134253,0.4116102553972715,0.7445185499107595},
{0.15409820784826403,0.2858966750410038,0.9457890005378853},
{0.6321289584908979,0.629428834795398,0.4519207029616149},
{0.27390413735324226,0.40930618261658297,0.8703131461793603},
{0.678382626843387,0.6574831620718262,0.32789160280357693},
{0.4945190220400312,0.8281318547044486,0.2639101514992199},
{0.3686875072354725,-0.08379716058131975,0.925768630861406},
{0.9001178810193114,0.3635072211426727,0.24010476972862646},
{0.7616556005808586,-0.5622672235875237,0.32208122482223256},
{0.7223287600921361,0.5278210156121133,-0.44681779040449443},
{0.5149848596676853,-0.7817770160935852,-0.3515896634158411},
{0.6427881920893659,-0.038299296448386304,-0.7650859455002704},
{-0.10479692215959359,-0.6962795505698952,-0.71007914528175},
{0.19170564198006645,0.30600900597757086,-0.9325274446865517},
{-0.010299990627012794,-0.1681998469382089,-0.9856991030142245},
{0.3616083876038268,0.4151096285795036,-0.8348193638597197},
{0.2448952845866925,-0.2274956196140161,-0.9424818526866381},
{-0.348212354793526,-0.5386191105450692,-0.7672272217047478},
{-0.3329917002853043,-0.4301892776658796,-0.8390790862144109},
{-0.5675177011531527,-0.4184130505065711,-0.7091221178637895},
{0.19460144005598465,-0.5150038110423026,-0.8348061775885713},
{0.12510327211887393,-0.4222110430742493,-0.8978234828802961},
{0.6673337345729455,-0.30811557563603253,-0.6780342754989617},
{0.980847430024246,-0.06270303207842601,-0.1844089173087999},
{0.8805840527672052,0.2468955287624608,0.40449267470399103},
{0.5944062739913332,-0.24880262612557819,-0.7647080715362928},
{0.9180243417381362,0.20990556571986357,-0.33640892000077227},
{0.9063856248379842,0.3759940367818646,0.19259694543666786},
{0.5657919714688868,0.7592892257623292,-0.32149543801210173},
{0.5018268685298308,0.41622228513773535,-0.7582405972883972},
{-0.738792715539737,-0.4697953678405095,-0.4831952357184636},
{-0.8289954405376155,-0.5589969255253644,0.016999906500771367},
{-0.4035033773374026,-0.7101059436116222,-0.5770048295506351},
{-0.41840768203556394,-0.9066166456344222,-0.05460100248360849},
{-0.3131008422423985,-0.9245024869150348,0.21740058480835975},
{-0.14170124272534806,-0.5706050042278307,0.8089070941463236},
{-0.07349827097351279,0.042798993165528536,0.9963765605171175},
{-0.28139174408734097,-0.02059939562259852,0.959371852442768},
{-0.7023163746971663,-0.26220611340680194,0.661815430406642},
{-0.34630145793220685,-0.6625027891426134,0.6642027962996586},
{-0.439394479043056,-0.8898888186172407,0.12259845956003339},
{-0.824784477702193,0.5635893933474249,-0.04579913806833225},
{0.4074922373468171,0.8867831069427177,0.21809584531371978},
{-0.9860236007573295,0.12530299916317789,0.10980262815735779},
{-0.5254153817604549,0.03250095147928204,0.8502248906980181},
{-0.09449641629136694,-0.7263724528470789,0.6807741821287049},
{-0.5012900519976261,-0.7281855493011598,0.46739072472310084},
{-0.7453309095137396,-0.5456226274395496,-0.38311588814532893},
{-0.42959633985477663,0.6641943410883209,-0.6117947875306153},
{0.7453827967635736,0.09939770592742048,-0.6591847861907},
{0.5644664999073163,-0.7785537942034304,-0.27428372174415744},
{-0.12529717207473903,-0.9820778347534015,0.14079682225158227},
{-0.2692862209765999,0.9608508345206641,0.06519666397205463},
{0.7344384708946846,-0.445223321408379,0.5122268311441414},
{0.9144486819714116,0.40242142347473314,0.04290228396388184},
{0.04539760216197903,-0.5571705710276369,0.8291562051258372},
{0.6674221153981966,0.738924484668456,0.09240306182618126},
{-0.22119061065786216,0.963859085050241,0.14849369657636766},
{-0.7352744312762208,-0.14949480140866997,0.6610770114466336},
{-0.4695840719784132,0.779173570880706,-0.4151859171325323},
{-0.4837130846159108,0.8714235723264515,-0.08150220466445468},
{-0.8779707026064728,-0.4774840666225407,0.03429885546628931},
{-0.38080983263681967,0.6226160761546321,-0.6836176512356352},
{-0.16210377219866912,-0.9652224609880038,-0.20510477284359677},
{0.4778203077946311,0.39501678857027894,-0.7846333476259262},
{0.37879794502672237,0.19549893942113045,-0.904595092584934},
{0.7815829225997096,-0.32329293612651755,-0.5334883434070433},
{0.9546078850936965,0.027400226326804195,0.2966024499463549},
{0.693795986401828,0.6867960268964767,0.21669874640137812},
{0.9112112398599659,0.2645032626678676,-0.315803895465076},
{-0.7640002368401102,0.36170011212705216,0.534300165633077},
{0.1771879968057208,0.7705478010072712,0.6122585239511448},
{0.11409967082292452,0.9409972852267483,0.3185990808429777},
{-0.10130172518306992,0.8920151911480589,-0.44050750190663673},
{-0.8512120362232889,-0.10980155260493082,0.5132072568019171},
{-0.9340366850112198,-0.3164124273421306,-0.16570650825091982},
{-0.05969774675107252,0.2743896433583634,-0.9597637743999899},
{-0.0008000154524476975,0.2052039635528344,-0.978718904138202},
{-0.36141933464447407,-0.6796363581194924,-0.6383341485986934},
{0.7579217299275,0.017200493145207812,-0.6521186965110473},
{0.4984657989425181,-0.8256433504249492,-0.26428186692178035},
{-0.38857933590036065,-0.9137514079921502,0.11859369335507661},
{-0.29040730383553837,-0.8015201584854821,0.5227131464009501},
{-0.20429052726787078,-0.0867959753639314,0.9750547877577131},
{0.528315073044054,-0.4707134296457245,0.7066201601607582},
{0.7843956034749637,0.4323975764183763,0.44469750747745584},
{0.9514851093745564,-0.16889735677704948,0.2571959749144886},
{0.6734286853057889,0.12250521822090754,0.7290310537391151},
{0.3894910067564798,0.38829103446352015,0.8351807158999023},
{-0.2846849562209723,0.2885847501418075,0.914151692930147},
{0.8352634580230499,-0.3445849247393068,-0.428481254355174},
{0.6951918176404592,-0.23509723292185264,-0.6792920047801553},
{0.99969751575476,0.023799940857220453,0.006199984593057429},
{0.7848066159476589,0.4423037286361487,0.43410365950927454},
{0.361589307962243,0.3846886249255389,0.8492748873128678},
{-0.034600764339326476,0.18290404039487898,0.9825217041441694},
{0.2126011501753337,0.48390261792024447,0.8489045925862689},
{0.5322745339341213,0.8245605498442165,0.19179082398753422},
{0.46989991776752155,0.7596998670525349,0.44949992133752065},
{-0.1013018432038058,0.0696012664065635,0.9924180572108279},
{0.12360186084002253,-0.11780177351905059,0.9853148340264902},
{0.7947491297362562,0.35167748984428954,0.49466833729306237},
{0.49801361587838977,-0.6676182529325562,0.5534151305765078},
{0.9988702041462088,-0.043898690521592315,-0.018199457118291122},
{0.42422139826700656,-0.8612434422148656,-0.27981411417988783},
{0.7564091828632203,0.04700057059039048,-0.6524079202802286},
{0.15850668753822383,-0.47492003729906934,-0.8656365219753095},
{0.4002857140577934,0.35228742708608696,-0.8459698078763258},
{0.16659326893495027,-0.14259423859618195,-0.9756605792306782},
{0.5988233725323538,0.665525975985774,-0.4455173888830388},
{0.5116949086609882,0.1850981582824876,-0.8389916520745927},
{-0.170892127181047,-0.4952771831057494,-0.8517607602856396},
{0.41799133094969315,-0.11779755690400444,-0.9007813179891953},
{-0.13760449010776954,-0.3823124750595951,-0.9137298154903272},
{-0.36650317026613427,-0.346702998993912,-0.863407468506904},
{0.30481721046556803,-0.31201761701199876,-0.8998508070108862},
{0.5919315685523487,-0.6138327365727854,-0.5223278564873995},
{0.9259402376073068,0.28021217688472555,-0.25321100352324233},
{0.7107851447457105,0.6703859890792409,-0.21299554843955593},
{-0.7287908428005899,0.1611979745601744,0.6654916381500996},
{-0.8336854814937585,-0.32249438380920853,0.4482921930594362},
{-0.7960244025020938,-0.5790177500611963,-0.17630540472502404},
{-0.5864869772012552,-0.46298971942741884,-0.6645852430485152},
{-0.4832098165071345,-0.10880221033935478,0.8687176481782859},
{-0.4428037527777073,-0.7240061359780038,0.5289044824844837},
{-0.46072405503088615,-0.8870463138971044,-0.029701550758448707},
{-0.28350007654503095,-0.6639001792530727,-0.6920001868400756},
{-0.4445890610207287,-0.5142873461155213,0.7333819553589799},
{-0.322598893487693,-0.8526970752540478,-0.41089859062025125},
{-0.43971712731566986,-0.7749301841185186,0.4540176843332139},
{-0.8136940844655087,0.555695960105055,-0.1705987597515249},
{0.30110453617400645,0.875513189705555,0.3779056931921522},
{-0.9895610021693416,0.10649580308309911,-0.09709617351520117},
{-0.666806264674285,0.013600127773800654,0.745107000313152},
{-0.5762838844465041,-0.7467791166140019,0.3319907160094384},
{-0.24020069418100928,-0.9707028053351612,-0.006300018207078928},
{-0.6242850828861646,-0.41968997162794053,-0.6588842561487969},
{-0.2986978762656496,0.7256948403280277,-0.6197955932689977},
{0.8563790703512777,0.15859612395809508,-0.4913879906242618},
{0.6218746249236344,-0.7533692593945428,-0.21379127642494458},
{-0.07379960554216256,-0.7404960420592326,0.6679964295686258},
{0.6337166226050193,-0.4824126538498679,0.6047158619050894},
{-0.2952037727283234,0.952212169349287,0.07840100197120783},
{0.8656642877564475,0.4170827936042674,0.27688857719736665},
{-0.24819584399538813,-0.5507907770856558,0.7968866562446608},
{0.6812360213069651,0.6684353444532817,0.29851578443941434},
{-0.37979494116507534,0.9215877245332633,0.08019893175734344},
{-0.9454989930441087,0.28679969455848797,0.15419983577726235},
{-0.2156002156003234,-0.9442009442014163,-0.24900024900037349},
{-0.9062953099339067,-0.3978979408834839,-0.14249926256822432},
{-0.37930425961075326,0.9219103531113985,-0.07880088493890682},
{-0.17540350108882297,0.6896137648281203,-0.7026140243158895},
{0.662326424039791,0.3966158233039123,-0.6356253587795428},
{0.6091793613528501,0.1873936512106437,-0.7705738933987301},
{0.8779668749347014,-0.32608769694328715,-0.3504867763833859},
{0.8540478235420323,-0.07829521669984911,0.5142685817207203},
{0.5977999372310099,0.6803999285580112,0.423899955490507},
{0.9497732880019071,0.2934917456607283,-0.10859694575385041},
{-0.90116769371726,-0.2298917585281825,0.36748682583343656},
{-0.15080542833909136,0.7479269221141011,0.646423268424328},
{-0.12340296664297756,0.8970215646576247,0.4244102029439196},
{-0.32850058637407004,0.8413015017245209,-0.42930076630255176},
{-0.8299958458811869,-0.41949790041826257,-0.3675981601758124},
{0.06449779389068931,0.3339885761161276,-0.9403678352682826},
{0.13420240627071683,0.3163056714115331,-0.9391168385158732},
{-0.3543916205091984,-0.2527940227559971,0.900278713161488},
{-0.2647957633016805,-0.891985728342519,0.3663941377406939},
{-0.2523073864068572,-0.9670283101681764,-0.0346010129594818},
{-0.06959683132840278,-0.6528702754930198,-0.7542656590662962},
{0.8446790099873994,0.2668933677822149,-0.46398847002977783},
{0.6862057710148015,-0.6915058155883638,-0.22570189816094535},
{0.6005674110936315,0.4478756966847113,0.6623640577895796},
{0.4476900121472423,-0.48968907515859855,0.7481833082165885},
{0.4768102586830746,0.18730402988955508,0.8588184776783231},
{0.9488678054615318,-0.00729975232360542,0.3155892922369686},
{0.9391463339273546,-0.1284063350828158,-0.3186157192942766},
{0.8749206002480521,-0.047701123136166514,-0.48191134673623987},
{0.9682945485170377,0.15309913805427913,0.19739888864738533},
{0.6476696282449085,0.47507772175259533,0.5956720666133888},
{0.11029809351393026,0.36919361854345467,0.9227840498155471},
{0.4906976103084567,-0.2632987177383669,-0.8305959550075486},
{0.6389151232999549,-0.03840090896027276,-0.7683181863067075},
{0.9081147933104755,0.41340673445055676,-0.0665010833114708},
{0.41600414134184066,0.5740057142553282,0.7053070213663467},
{-0.04050075878882393,0.3622067860077044,0.9312174465222924},
{-0.2482932787919134,0.10129725792034164,0.9633739218208996},
{-0.5127181146509916,0.15780557536946843,0.8439298165671383},
{-0.28929172348218507,-0.38868887977022243,-0.8747749730460267},
{0.1269998425202929,-0.32019960295273847,-0.9387988358901651},
{0.0567003010793981,-0.4107021808343704,-0.910004832138488},
{0.5367032363302726,0.34480207916280603,-0.7701046437450028},
{0.5354085558970854,0.8428134682668352,0.054800875724991184},
{0.2984969583314918,0.7797920539594551,0.55029439252871},
{-0.3319917451278848,-0.033799159594344895,0.942676560638726},
{-0.06789812569810981,-0.22679373944523276,0.9715731800925403},
{0.6076973929837762,0.3851983475026338,0.6944970206141724},
{0.4331030966982121,-0.6528046675700597,0.6215044437726596},
{0.9818937060815159,-0.13389914170925243,0.13399914106825864},
{0.5566662865272537,-0.7467547741666124,-0.36397795634259095},
{0.8356275051320046,0.17840587232593302,-0.5195171001867835},
{0.43400987383694595,-0.11970272326793187,-0.8929203141682236},
{0.5359857590475706,0.71848091021582,-0.44328822198841056},
{-0.34892006697009376,-0.28441635725507214,-0.892951355109191},
{0.8506263783329945,0.5201161290512467,0.0769023847799286},
{-0.28160468594096144,-0.5440090523859482,-0.7904131525842895},
{-0.6756805845973484,-0.6342817741750749,-0.3756892047258011},
{-0.8694011476102723,-0.4284005654891197,0.2462003249846435},
{-0.49548716209394306,-0.8613776819933856,0.11189710078367755},
{-0.12839708734511,-0.8058817187805618,-0.5779868885161493},
{-0.337286665635256,-0.9406628116308489,-0.037298525431945},
{-0.459016566206817,-0.6641239686665515,0.5901212978619667},
{-0.6366913601568636,-0.23389682604160575,0.7347900289669599},
{-0.8689167441869922,0.44720861779309806,-0.21210408728514335},
{0.04849925626960761,0.885086427303705,0.46289290159178065},
{-0.9574352486275293,-0.02560094251604841,-0.287510584897028},
{-0.29369035096202617,-0.748875396103035,0.5940804818064002},
{-0.50608014686525,-0.8509666172343959,0.14049448850932156},
{-0.43628447945571014,-0.5314810928964243,-0.7260741703708253},
{-0.2950079638474775,0.7050190322456666,-0.6449174097804687},
{0.8964713223410902,0.3262895621638569,-0.2997904098581805},
{0.7741814276103247,-0.6224850667623704,-0.11469724844601425},
{0.008499741484294073,-0.9976696563388467,-0.06769794099843632},
{-0.4944799171059919,0.8626649635739924,0.10629568288850746},
{0.5602068429683805,-0.4313052684260309,0.7072086386062811},
{0.7271799846463801,0.5214856463051254,0.4463877133472829},
{-0.32959858767307776,-0.6754971055011044,0.6595971736321665},
{0.5181320604131378,0.709243885823195,0.4780295789953288},
{-0.4903252548526435,0.8697447973594618,0.05590287935195344},
{-0.9743525112158768,0.21158968736995026,-0.07659626678893285},
{-0.9121162996639137,0.016300291288808017,-0.4096073197482064},
{-0.06659908460187318,-0.90678753629097,-0.4162942780744715},
{-0.3202880550797245,0.7114734660918639,-0.6254766732824467},
{0.7290077967800801,0.5256056213821811,-0.4385046898327368},
{0.643771375342179,0.3906826286831148,-0.6579707439812889},
{0.9430759047184476,-0.23849390655853012,-0.23179407773696972},
{0.7747252022207491,-0.033301083301860004,0.6314205404442764},
{0.4355876708654617,0.6722809713564047,0.5985830573463393},
{0.8871843679491539,0.4455921487355083,0.11979788917978881},
{-0.4036916295408413,0.584687876622566,0.7036854092343078},
{0.5488698541511184,0.7989561185402506,0.24578650054717596},
{0.35400164080140767,0.9352043346821369,-0.008700040324780358},
{-0.10150083078770002,0.8037065783652659,-0.5863047989244189},
{-0.9856193873240249,0.15610307057759767,0.06470127268655074},
{-0.3114861781075129,0.11669482178217257,-0.9430581527229388},
{-0.34890008722503263,0.01730000432500162,-0.9370002342500878},
{-0.928232284480291,-0.35961250754052215,0.09520331122874781},
{-0.5704692924644578,-0.748959684585239,-0.33708185537207486},
{0.4042126035454709,-0.2760086060825086,-0.8720271902316937},
{0.2727079918248023,-0.9437276563442096,-0.1871054832065292},
{-0.3400860244519818,-0.8076668096144243,0.48168020575865816},
{-0.21090653187643987,-0.6106189111605225,0.763323640499225},
{-0.8094816614006891,-0.044099000948450144,0.585486735948244},
{-0.35820198086243127,0.20030110766818812,0.9119050428488304},
{0.2465110402441615,0.09630431308524444,0.9643431890768558},
{0.7034170228979336,-0.45981112756393216,0.5420131168761445},
{0.9586552606029571,0.28378675598114034,-0.02109901533193115},
{0.6912286174571564,0.33741396922749495,0.639026456242944},
{0.9630320213470736,0.05690189201936499,0.2633087551616661},
{0.958207507585233,-0.28530223535177096,-0.02100016453693372},
{0.8729081486356014,-0.40340376579173054,-0.27440256155986825},
{0.976794993938484,0.16199916975638248,0.14009928199301966},
{0.7191558847353349,0.4641715262710546,0.5170682814191347},
{0.14210504908209243,0.48421720454292155,0.8633306746838169},
{0.616994481009051,-0.6266943942437152,-0.4759957422371284},
{0.346499158008069,-0.6118985130884198,-0.7109982722762975},
{0.3883782630769063,-0.4886726497571682,-0.7812562743099559},
{0.7020995295934727,0.19729986780913283,-0.6841995415864607},
{0.9063129694313895,0.4112058843983089,-0.09750139525494922},
{0.605223637470751,0.5843228211734302,0.5406211143699405},
{0.40650469515634374,0.2099024243870026,0.8892102704379357},
{0.363706501311817,0.3984071215909482,0.8420150511535602},
{-0.18309790994928685,-0.6110930244129392,-0.7700912094590158},
{-0.0442987689543159,-0.4596872254695038,-0.8869753512974764},
{-0.06989986369539869,0.03329993506518994,-0.9969980558556866},
{0.3091989409954406,0.8385971278097558,-0.4484984638953917},
{0.4833920216805227,0.8747855617834531,0.03289945699894331},
{0.7128167014909762,-0.006900161672682009,0.7013164320365063},
{0.8884723245181301,0.4506859613509524,-0.08659730253603834},
{0.833508856078644,-0.5525058704060597,0.0005000053125846695},
{0.6214072829360342,0.3964046458896749,-0.6758079205152429},
{0.27220598179217553,-0.7839172267703395,-0.5580122624542027},
{0.22299720251764152,0.01599979928377697,-0.9746877726185883},
{-0.3608919143072389,-0.2531943272446464,-0.897579889947846},
{-0.03610018970699536,0.5842030699951993,-0.8108042607875856},
{-0.11669733758061429,0.39949088571941227,-0.9092792550304419},
{-0.41560970459990493,-0.193504518383257,-0.8887207518718372},
{-0.6158766402420451,-0.5435793824250296,-0.5702783697516454},
{-0.5872170471583221,-0.4751137927536084,-0.6553190241874123},
{-0.6998073970032797,-0.4471047259219296,-0.5571058886403646},
{-0.9741543473262437,-0.20279049644607086,-0.09949533726027639},
{-0.8642742925434966,-0.4651861632433584,-0.1913943070610034},
{-0.6138931336437001,-0.7359917679781126,0.2853968078545561},
{-0.5755942296967709,-0.7461925194574885,-0.3344966466879254},
{-0.4528825168079015,-0.8533670564006693,-0.25819003276617386},
{-0.23679718686612994,-0.9113891727609409,0.33659600126325734},
{0.05809980768995481,-0.6589978187208301,0.7498975178433238},
{0.3250986508433985,-0.2089991326553992,0.9222961724788263},
{-0.19000340109131958,-0.4246076005440752,0.8852158455054531},
{-0.0475991194244359,0.1717968217881951,0.9839817965051454},
{-0.855725282776975,-0.38191128373556943,0.3491103146166203},
{-0.5358135241040247,-0.08720220101133064,0.8398211973545352},
{-0.1396048234299757,-0.8257285294135455,0.546518882553594},
{-0.14640032061705324,-0.7929017364567044,0.5915012953892554},
{-0.7404740024141548,0.672076403811686,0.0033998806322864633},
{-0.5250838434187032,0.8507738220922351,-0.021699332321816527},
{-0.9149919938550805,0.28569750015781037,0.28489750715771844},
{-0.28041629826889686,0.28221640289401817,0.9174533239368259},
{-0.026200352528114916,-0.5736077179437677,0.8187110158308275},
{-0.4695102471729681,-0.5327116265581259,0.7041153674855949},
{-0.34160007856802715,-0.8863002038490703,0.3127000719210248},
{-0.9246571801174603,-0.22018980324631207,-0.31068561248242127},
{-0.4059995838506399,0.6932992893685926,-0.5953993897159384},
{0.5703874715767787,-0.14989670755497744,-0.8075822616504321},
{0.36218880129539327,-0.9105718455537964,-0.1991938410216519},
{-0.11659956391844642,0.9893962996647588,-0.08659967611781698},
{0.7872021962971915,-0.46270129093840257,0.4077011374877604},
{0.9343866477102056,0.2488964432952378,-0.25489635755707557},
{0.388896276335981,-0.5412948171269388,0.7454928619400202},
{0.6116966295608566,0.7702957556820791,-0.18019900710620623},
{-0.17980038747025248,0.9594020675136832,0.2173004682830137},
{-0.41718591604120764,-0.15919462568015402,0.8947697930816697},
{-0.6084143191995055,0.762917955485376,-0.21860514493262967},
{-0.49738577248346433,0.8630753120837917,0.08779748858875787},
{-0.7721836684881153,-0.5024893724621573,0.38889177502593636},
{-0.6460465105625035,0.5851421258980197,-0.49013528610941626},
{-0.191606736053211,-0.9747342673855155,-0.11480403600682998},
{0.11970261373510667,0.40100875612178594,-0.9082198311965236},
{-0.041700422427418796,0.17820180519342996,-0.9831099589543266},
{0.4870794310699296,-0.31058688419281494,-0.8162655298344972},
{0.9889746133475088,0.040298965538831756,-0.14249634216584428},
{0.7067665777987852,0.7052666487287539,-0.055497375591160976},
{0.8400566457952369,0.023898766616481566,-0.5419720295453142},
{-0.60470335913649,0.7354040851810397,-0.3058016987331547},
{-0.944675580451864,0.0030999198681071006,0.32799152152875133},
{-0.6865062987241862,0.6106056023321023,0.3948036223398525},
{-0.907558244205754,-0.3650832029082424,0.20749045358384086},
{-0.9358080058717355,-0.3106026572170988,0.16670142613680092},
{-0.8888074971228576,-0.4475037747102596,0.09880083338854447},
{-0.8471525039034445,-0.43922722195064673,0.2990185322478219},
{-0.9510192821114192,-0.2753055818772594,0.1406028507516988},
{-0.6625825411800568,-0.7486802725347247,0.021499433497390915},
{-0.8677127641486416,-0.4755069947593397,-0.14480213005499978},
{-0.9829990170014746,-0.17359982640026042,-0.059799940200089705},
{-0.9089191465834863,-0.39350828933942333,-0.13790290495528965},
{-0.9335788780168246,0.25899414032386203,-0.2476943959776858},
{-0.295909342005393,0.8058254403107321,-0.5129161930198245},
{-0.7571898499380919,0.06359914745914244,-0.6500912855847247},
{-0.3318965715261241,0.6918928527837459,-0.6411933765066309},
{-0.243509348503337,-0.20290778977957732,-0.9484364111727508},
{-0.6362267443533101,-0.29751250620105274,-0.7118299223996953},
{-0.38829580254506163,0.8266910635179048,-0.40719559823937446},
{-0.5543027410338317,0.6949034363059888,0.45810226532130305},
{-0.7008281423190935,0.1944078066022143,0.6863275600365211},
{-0.79080551588771,0.07460052034044407,0.6075042373568335},
{-0.9761178143126683,0.13550247294269702,0.1698030989348336},
{-0.9220621731752524,-0.3707847888660488,0.11099544650520878},
{-0.9624724448083519,-0.26259248208485525,-0.06849803892921777},
{-0.9799520417350512,-0.03730198097430086,-0.1957103934764257},
{-0.9986213807126442,-0.03290070441162226,-0.04090087569712311},
{-0.49131081387002123,-0.6755148682458769,-0.5498121014975323},
{-0.28358638534445163,-0.30408540121032346,-0.9094563380492903},
{0.0576991420201372,-0.29229565359594634,-0.9545858054146096},
{-0.4262887077616951,0.2351937697995559,-0.8734768619043881},
{-0.4005781971220798,-0.08349545546603511,-0.9124503366797249},
{0.10520507416309328,-0.13570654528452242,-0.9851475148104866},
{0.008100145034395273,-0.3473062185735158,-0.9377167899694379},
{-0.5615829590236587,-0.5192842425587357,-0.6441804526407424},
{-0.10809555195955341,-0.49617958263025347,-0.861464551463046},
{-0.5072776143328084,-0.6015734531492559,-0.6170727691795309},
{-0.8081971349462349,-0.559298017292043,-0.18439934630547603},
{-0.889208478643266,-0.43300412871405103,-0.1477014083396428},
{-0.9584069916045057,-0.17020124162258646,-0.22910167130278825},
{-0.798620964075464,-0.28230741066679627,-0.531513952424379},
{-0.24349038475455528,-0.8232674898087284,-0.5127797507274577},
{-0.1485979374749417,-0.5675921218760223,-0.809788760210012},
{-0.7899020300508258,-0.3174008157211446,-0.5247013484841985},
{-0.8908372511385009,-0.4542189935643321,-0.009700405630942365},
{-0.9756817451653205,-0.08069849014537395,-0.20379618700901128},
{-0.966222373138078,-0.001400032418125967,-0.25770596725075834},
{-0.7806055852529438,-0.05930042429605376,-0.6222044518887799},
{-0.9865609724198814,-0.16339353627955464,-0.0},
{-0.9385031299131574,-0.2612008711063577,0.22580075304676714},
{-0.8044333806557098,-0.34341425026997857,-0.48472011387844677},
{-0.7768273875323296,-0.6290221765677592,0.029501040077502216},
{-0.9167886823135748,-0.3941951336911117,0.06409920870015287},
{-0.7634957129836073,-0.6286964698792324,-0.147699170671485},
{-0.6650134965858712,-0.733514886835694,0.14040284950474632},
{-0.5009107246134222,-0.6929148354654426,-0.5186111035825928},
{-0.8267764868110679,-0.5409846146163374,0.15419561473907434},
{-0.931506506595673,-0.3617025265009715,0.03830026752830303},
{-0.8736104790205441,-0.47830573731172876,-0.08960107477133786},
{-0.8964946120835722,-0.4410973490128987,-0.041599749986253876},
{-0.5600080501735824,-0.8143117058149073,0.15260219367230118},
{-0.6819872162694455,-0.7174865508406555,-0.14179734203373512},
{-0.9767400032060137,-0.2096085846953829,-0.04520185127972951},
{-0.9287440885283484,0.024401158350481,-0.36991756040339846},
{-0.861725261846332,-0.3382099147689793,-0.37821108742054393},
{-0.9593999376390062,0.2775999819560018,0.049899996756500316},
{-0.9804688706075295,-0.09429700611758289,-0.17259452021097357},
{-0.9115319634287062,-0.402114100378149,-0.08610301925530621},
{-0.7748278594365381,-0.5787208082807493,-0.25440914744534754},
{-0.796382854061726,-0.5912872697221229,-0.12709726362537088},
{-0.8927400447528312,-0.434019468379891,-0.12100542782020003},
{-0.6816246888933557,-0.6820247033821429,0.26500959882150715},
{-0.44361614792168186,-0.8832321502354135,0.1520055331021092},
{-0.49738663540065775,-0.7956786204027008,0.3456907114153747},
{-0.773901079592759,0.12120016907435378,0.6216008671338145},
{-0.729397498170872,0.5808980075232513,0.36129876074737594},
{-0.8758779763251744,0.48178788559592306,-0.026799326139416227},
{-0.8884379815355833,0.2925125051769002,0.3537151216446824},
{-0.9664752440536815,0.21169457751284465,-0.14529627828349706},
{-0.878660061414592,-0.06589700471972415,-0.4728785057960174},
{-0.7044754071927948,-0.6473774004494185,-0.2908898452127523},
{-0.6050157608658585,-0.7843204318133766,0.13710357159456066},
{-0.9489968066311186,-0.06829977017166007,0.30779896425822795},
{-0.7032967859410324,-0.7107967516662672,0.011899945617372792},
{-0.46421580681733776,-0.815127755572624,0.3465117989276336},
{-0.6763856066674335,-0.39639156487724814,0.6207867897976681},
{-0.8050897552980454,-0.5929924542190297,-0.013799824398351788},
{-0.4648015942722026,-0.8441028952778963,-0.26730091684371715},
{-0.492484587935977,-0.7846754439662155,0.3764882179855743},
{-0.5296047240952084,0.8002071378795049,0.28140251012158546},
{-0.6882010426253693,0.32670049495162473,0.6478009814192303},
{-0.626525193084531,0.30621231304466634,0.7167288202453048},
{-0.5992187049038149,0.6198193479629247,0.5067158173811133},
{-0.7927985689998743,0.5623989848707485,0.23489957600664796},
{-0.25129030415066794,-0.8657665950403831,-0.43278330137846827},
{-0.006700292306627954,-0.9919432744692936,0.1265055189236472},
{-0.8753762732476661,0.045598764062249914,0.481286954893879},
{-0.4744121712003802,-0.08870227568607446,0.8758224695136868},
{0.28470200715622573,-0.8075056929352029,0.5166036420685148},
{-0.6641882937844822,-0.7064875482666918,0.24439569256387753},
{-0.641209178975096,-0.36920528521148693,0.6727096299072787},
{-0.38768341913473786,-0.8891619713557104,0.24308960327999685},
{-0.3620993156329402,-0.9275982468409703,0.09189982630949241},
{-0.34229025513515243,-0.8897746684757775,0.30189140527403596},
{-0.69028303995406,-0.6543839219845529,0.30869241552052484},
{-0.9141271774049825,0.2707080482699144,-0.3018089729141491},
{0.43658905921526237,0.5139871196441705,0.7383814963915477},
{-0.011899518733697028,0.8837642568774313,-0.46778108097676213},
{-0.0014999427407787855,0.8852662056076391,0.4650822458241421},
{0.16870636794203922,0.4279161519999916,0.8879335156830861},
{0.06419940230634677,0.33029692494994295,0.9416912328954323},
{-0.3949268519895312,0.5675385882604683,0.7224491209856606},
{-0.04389951315709862,0.859590467194578,-0.5090943541749181},
{0.12459845125087639,0.7042912457142234,-0.6988913128349719},
{0.15150530656629535,0.9561334891619471,-0.2507087812288465},
{-0.3675949474421708,0.398694519981484,0.8401884516890966},
{-0.5320063787947229,0.5189062217228979,0.6691080226532877},
{-0.21039160449053088,0.8786649375752351,-0.42858289774069164},
{0.05259706095834818,0.9279481477062188,-0.368979382008184},
{0.7474908694547941,0.4736942138605163,0.4656943115787259},
{0.7278060262588462,0.6832056569662596,0.05940049183810864},
{0.5912875742221902,0.510289276383534,0.6244868765461827},
{0.19209504305137026,0.4997871031602023,0.84457820594059},
{0.12970062191597312,0.6684032050010519,0.7324035118832593},
{-0.12329986128773408,0.6743992413012803,0.7279991810013821},
{-0.22040675997899442,0.5973183200338175,0.7711236507250571},
{-0.3657824629802085,0.547173766382641,0.7528639048053554},
{0.2698888996978285,0.9287618008126828,-0.2540895495117385},
{0.7477262979963589,0.6301221617861519,-0.20940736498654214},
{0.792639232649754,0.6065300209463486,0.06200306891784601},
{0.8548911519223662,-0.15149843199934318,0.49619486440972993},
{0.8013188232002381,0.3573083932727381,0.47981127089913167},
{0.24890447907640184,0.7248130431280677,0.6424115603000423},
{0.02229971244706198,0.9124882335400922,-0.4084947324943865},
{0.1535918007205719,0.9158511085935667,-0.3709801957508606},
{0.9572830849573319,0.11929789202487172,-0.263395345845358},
{0.8045640810383852,0.5482755227856656,-0.22818981269321337},
{0.9183098305593546,-0.05990064123979673,0.3913041889337639},
{0.7182358660034757,0.6955347323940648,0.019200958823818896},
{0.6125839811383372,0.7734797737683705,0.16269574556187963},
{0.8238516166152925,-0.17998942953119632,0.5374684354056557},
{0.8280964019289504,0.29319872605430297,0.4777979239725305},
{0.7278048435573509,0.398802654040494,0.5579037128615637},
{-0.1660070172649328,-0.03390143304386278,0.9855416597264536},
{0.5351662213741266,0.5663642522165645,0.6267604401294892},
{0.1333919853833301,0.6669599269166507,0.7330559556560668},
{-0.15469646213236607,0.302293086636162,0.9405784892159246},
{-0.2294078309699675,0.3279111934396354,0.9164312829157726},
{-0.5388872877988196,0.5913860493676413,0.5998858488597362},
{-0.35399592730028445,0.6925920317745113,0.6284927692322847},
{-0.2706050793050083,0.8367157053011842,0.4761089366486122},
{-0.15229857982236467,0.7819927079519973,0.6043943640488327},
{-0.5954290070306335,0.6621322565585865,0.45502216694480724},
{0.6863024638302678,0.5548019917427255,-0.470301688386092},
{0.09370546084485075,0.8790512282030288,-0.4674272401161498},
{0.7305596815237343,0.5498696535312093,-0.4048776554187791},
{0.6519085335385564,0.4985065254931283,-0.5714074797728657},
{0.7963715461529748,0.5468804603102235,-0.2582907714356019},
{0.9186636170479059,0.07739693475509733,0.3873846579344277},
{0.7645033103065004,0.15900068847447166,0.6247027049685688},
{0.20379494187231334,0.8223795887919062,0.5311868161068344},
{0.801839142733152,0.1448070689296089,0.5797283001277229},
{0.6837699216227071,0.4584798319157813,0.5676750285247306},
{0.43153127204673436,0.3951286340339855,0.8109587682565397},
{0.23449661154844448,0.4940928604097502,0.8371879027222079},
{0.15809457586815134,0.8629703919937673,-0.4798835354783418},
{0.18169911512746398,0.7977961147423817,-0.5748972002574521},
{0.6086257788908089,0.2802118686250487,-0.7423314421141102},
{0.5287997250242145,0.08379995642403398,-0.8445995608083424},
{0.14940086951559087,-0.06240036317117048,-0.9868057432261385},
{0.894771273829373,-0.22259285377114263,-0.3870875727529619},
{0.9892051240958143,-0.13360069205337727,0.06020031183842298},
{0.9026375098811008,-0.0433017994436646,0.42821779496021206},
{0.37590832646164773,-0.3895086277116568,-0.840818624338796},
{0.3845899431044801,-0.11829690657633904,-0.9154760606140184},
{0.36700409945868656,0.10290114941225845,-0.9245103268380265},
{0.6527872805637561,-0.21229586345540044,-0.7271858309221253},
{0.9395593367518391,-0.20479113683139277,-0.27438812473893637},
{0.9646867211786739,-0.20119723053918231,0.1699976599983151},
{0.9945794820369264,0.09829797213375212,0.03389930066464086},
{0.9372941841076313,0.02559984115347846,0.3475978431620747},
{0.763939622756078,0.35091820084449243,0.5415280870826237},
{0.9164704443047492,0.25599174439936256,0.3074900836047031},
{0.8300052124491013,0.19380121707546488,0.5230032844709398},
{0.6803870693666189,0.1511971265259153,0.7170863719030017},
{0.06780176659804336,0.36730957037553585,0.927624169562611},
{0.023700422582301997,0.178703186306218,0.9836175380570568},
{0.1924035392956583,0.51190941666033,0.8372154007189457},
{-0.04729817219745247,0.1719933534452817,-0.9839619755241698},
{0.41661953783135064,-0.37871776038581967,-0.8264387567542683},
{0.25961138940148504,-0.17490767336794968,-0.9497416660808565},
{0.5644997008152378,-0.4064997845551713,-0.7183996192483028},
{0.9468270228288528,-0.22720648456560558,-0.2278065016903387},
{0.9871003800337195,0.0009000003465002001,0.1601000616385356},
{0.9978318662694822,-0.06270200242042145,0.020000638730596956},
{0.9850910652645568,-0.14019872840330003,0.09969909573330252},
{0.9784091530604405,-0.1072010028700728,-0.17670165305169647},
{0.9761963685562633,-0.20479923814825113,-0.07139973439348209},
{0.9624922952800143,0.13999887931345664,0.23239813966033798},
{0.8907053709695805,-0.099300598784416,0.44360267493219474},
{0.8894100815204113,-0.28560323733104287,0.35690404553028426},
{0.9423696561855982,-0.1149962971788453,0.3141898832486364},
{0.8173290933468758,0.02940104654887819,0.575420482456616},
{0.7990099996727191,0.08410105253125867,0.5954074515708848},
{0.6545312251569119,0.032501550523452466,0.7553360341650353},
{-0.3192206702076156,0.44452878417069275,0.8369541945387013},
{0.6697860953849881,-0.2861940586730123,0.6851857756909435},
{0.29838669075848145,0.04759787694404732,0.9532574808983257},
{0.5390888463671519,0.3330931083748809,0.7735839947127224},
{0.15120191347232256,0.6085077007136791,0.779009858432138},
{-0.12039500009946663,0.6598725960601166,0.7416691991177277},
{-0.6097242492155965,0.589423441836432,0.5299210753802601},
{0.1814022276330331,-0.732808998949761,-0.6558080533723435},
{0.7350914215331658,-0.623692721548409,-0.26579689816829744},
{0.9123365398101437,-0.32191289286954433,-0.2530101332587596},
{0.9090812231212526,-0.3488927936937686,-0.22769529700221014},
{0.5605923367551345,-0.5772921084708156,-0.5936918842874124},
{0.8473212426098317,-0.0664016647106017,-0.5269132098797596},
{0.9890918598074906,0.1265989580948623,0.07529938028865034},
{0.8372196874524285,-0.10230240566935431,0.5372126327035888},
{0.8333664743410923,-0.4462820464344006,-0.32608688178861317},
{0.9628011553620797,-0.26400031680057023,0.057600069120124414},
{0.887519725345096,-0.4461099149030393,0.11530256262793193},
{0.9056163691638102,-0.42150761881906584,-0.046800845932935424},
{0.8798689147803515,-0.2167923408618936,0.42288505973475465},
{0.941492477505157,-0.07179942632487549,0.3292973689245334},
{0.8744048923090588,-0.36330203268055933,0.32160179936710126},
{0.6157912681417261,0.08239883159285195,0.7835888887883349},
{0.9006210747797276,-0.4330101325556541,-0.03720087051055504},
{0.9754067498380634,0.20260140200655283,0.08680060066223488},
{0.6150620364674124,0.49496944895361594,0.6137621167024838},
{0.46227722416223443,0.342883106565499,0.8177597099716101},
{0.9927908415467298,-0.11939889855024129,-0.010499903138840314},
{0.8882201450613375,-0.03840087094162954,0.4578103832572397},
{0.9974891374024404,-0.028799686373123086,0.06469929542850915},
{0.863632404095714,-0.33801268247377414,-0.3740140332697974},
{0.9975095262614639,0.004300041065588265,-0.07040067232963114},
{0.8153732521191891,0.23139240929651747,0.5306825912431365},
{0.500705540337456,0.33370369245178555,0.7987088377621849},
{0.7649854730637985,-0.3962924744773638,0.5076903590516215},
{0.783286962297018,-0.2927951264656797,-0.5483908721099},
{0.9464144755201055,0.032600498628439806,-0.3213049143962488},
{0.9543622032333966,0.19559225372218395,0.22569106168249958},
{0.12630143352940587,-0.316903596876237,-0.9400106691816431},
{0.43780574842721554,-0.8717114456464224,0.22010288996991806},
{-0.6381812345566927,0.03939884149409855,0.7688773914927},
{0.7208702250702674,0.05879757141646792,0.6905714765342305},
{0.5245689254572565,-0.005599668285475861,0.8513495675453837},
{0.2877956989254191,0.3431948709909793,0.8940866379750425},
{-0.47931339699667175,0.7120199012343631,0.5131143417462806},
{-0.674028239004622,-0.010500439925146189,-0.7386309455917119},
{-0.629073485111392,-0.2974874611677621,-0.718169729783821},
{0.24469489327086558,-0.272294317276897,-0.9305805789859727},
{0.8175310872106479,-0.4787182036057947,-0.32011217249679313},
{0.8444685103563622,-0.5231804909632312,0.11469572307622823},
{-0.8873163134603858,0.2913053556981972,-0.35750657281876247},
{-0.549628422020573,0.02790144282091337,-0.8349431760279774},
{-0.14010028440386602,0.12030024420974363,-0.982801995090075},
{0.5638187049958124,-0.1905063201520083,-0.8036266607567132},
{0.887185689810234,-0.4300930626548486,-0.16709730474221157},
{0.7950725784196474,-0.26639081233932094,0.5448812073712311},
{0.7891265703389425,-0.23470790274813053,0.5676191120572599},
{-0.8266135896391215,0.2190036004487873,-0.5184085227061704},
{-0.6968895955160078,-0.36049461785553283,-0.6199907436072963},
{-0.16969220536756555,-0.7126672643810488,-0.6806687341997754},
{0.5018893324556067,-0.8088828073786417,-0.30629348980106064},
{0.14610253855366126,-0.8148141575189813,0.5610097476290483},
{-0.7078629585005471,-0.6063682695786577,0.36228104232906944},
{-0.9937295688632388,-0.006800202343031119,0.11160332080621661},
{-0.773600549256585,0.6149004365794649,0.1531001087011158},
{-0.8916961924653873,0.38829834196961965,0.23259900680436144},
{-0.6109787199817681,0.2114926338398428,0.7628734295811636},
{-0.007500235886127987,0.16460517691422222,0.9863310205984044},
{0.16770648198079524,0.1870072279690442,0.9679374115039459},
{0.062601801392753,0.13600391356892025,0.9887284510705253},
{-0.4780900414881527,0.23859503011728347,0.8452823929511305},
{-0.6531800783114126,0.22699307681673403,0.7223779678079677},
{-0.07229827426078984,0.4660888745913436,-0.8817789521876138},
{-0.40938312148184475,-0.5046791925058306,-0.7600686630150225},
{-0.8560856778064145,0.029499506477384918,0.5159913675366311},
{0.4494975839569794,0.7760958284961328,-0.4422976226566674},
{0.1457960919881307,0.9813736946306684,0.12509664682932198},
{-0.5971075206165836,-0.1368017230285524,0.7904099552760805},
{0.4133840498841469,0.8344678026809883,0.36438594043972694},
{-0.016699543691202873,-0.3025917317938916,0.9529739603422958},
{0.1509916473730946,-0.7691574513866514,0.6209656491304089},
{0.4026938992336396,0.8273874651748532,-0.39149406890978367},
{0.7925303901604772,0.1295049659631316,-0.5959228510998466},
{0.33161141260315047,-0.8194282011068199,-0.46751608984310267},
{-0.8140184906400246,-0.5521125413788178,0.18040409792562712},
{-0.03480118169418698,-0.7187244047014995,-0.6944235795529724},
{-0.7694984417672333,0.15239969139093743,0.6201987440988148},
{0.19130547332788897,-0.19220549907799406,0.962527538306812},
{0.2625951840484864,0.6075888569225452,0.7495862527141868},
{-0.257293920216497,0.8593796930977753,0.4418895582731055},
{0.41280046852879765,0.09550010839268454,-0.9058010280847503},
{0.8317036220771612,0.32960143541737685,-0.44680194582671107},
{0.5913009135606172,-0.6979010782579987,-0.4041006243359469},
{0.5767998154240886,-0.6991997762561075,-0.4223998648320649},
{0.1500956270276089,-0.9884712013110686,0.01989942023883689},
{-0.6707089506706704,-0.6969093003166694,-0.2539033883633267},
{-0.48587995543589924,-0.40088346189391233,-0.7766679592242497},
{-0.5388777825270302,-0.316986930898253,-0.7804678219750362},
{-0.05049942986465522,0.5947932848217212,-0.8022909421863937},
{-0.14050171904904893,0.947811596545826,0.2862035017212655},
{-0.32900105774010097,0.7916025450062733,0.5149016554114833},
{0.5240769673234181,0.08149641831112112,0.847762741646239},
{-0.032700336978708854,-0.10710110368256019,0.9937102402367887},
{-0.8867748292537023,0.34579018488490104,0.3066912946911485},
{-0.620705840869444,-0.4863045761475924,0.6150057872316869},
{0.28610950900755044,-0.7684255390471924,0.5724190246624322},
{0.8508654470557783,-0.08789643059842862,0.51797896530132},
{0.9607811592661982,-0.27729456230694915,-0.002699947054557385},
{0.30610965638141824,-0.9279292719905847,0.2127067099389992},
{0.4859936505344334,-0.6761911656201315,-0.553692766051267},
{-0.4320956034496022,-0.8386914663577444,-0.3314966270389797},
{-0.6231917427641123,-0.030099601182926473,-0.7814896453307986},
{0.17990465419360677,0.18080467747751028,-0.9669250146736985},
{0.16229991966155966,0.22689988768458338,-0.960299524651853},
{0.11589950221270699,0.8702962620855814,-0.47869794399674576},
{-0.8937963622562084,0.16529932723310722,0.41689830322735877},
{-0.9067720627831117,0.0602981422428558,0.4172871435811563},
{-0.48721563743682933,0.3434110219536272,0.802925770316154},
{-0.5256130958134253,0.4116102553972715,0.7445185499107595},
{-0.8805840527672052,0.2468955287624608,0.40449267470399103},
{-0.980847430024246,-0.06270303207842601,-0.1844089173087999},
{-0.6673337345729455,-0.30811557563603253,-0.6780342754989617},
{-0.12510327211887393,-0.4222110430742493,-0.8978234828802961},
{0.5675177011531527,-0.4184130505065711,-0.7091221178637895},
{-0.19460144005598465,-0.5150038110423026,-0.8348061775885713},
{-0.2448952845866925,-0.2274956196140161,-0.9424818526866381},
{0.3329917002853043,-0.4301892776658796,-0.8390790862144109},
{0.348212354793526,-0.5386191105450692,-0.7672272217047478},
{0.010299990627012794,-0.1681998469382089,-0.9856991030142245},
{-0.3616083876038268,0.4151096285795036,-0.8348193638597197},
{-0.19170564198006645,0.30600900597757086,-0.9325274446865517},
{0.10479692215959359,-0.6962795505698952,-0.71007914528175},
{-0.6427881920893659,-0.038299296448386304,-0.7650859455002704},
{-0.5149667522449274,-0.7817495279710374,-0.351677294688429},
{-0.7222964824246959,0.5277974296327765,-0.4468978236128985},
{-0.7616801280246863,-0.5622853301671014,0.32199159934875804},
{-0.9001178810193114,0.3635072211426727,0.24010476972862646},
{-0.3686875072354725,-0.08379716058131975,0.925768630861406},
{-0.4945190220400312,0.8281318547044486,0.2639101514992199},
{-0.27390413735324226,0.40930618261658297,0.8703131461793603},
{-0.678382626843387,0.6574831620718262,0.32789160280357693},
{-0.6321289584908979,0.629428834795398,0.4519207029616149},
{-0.15409820784826403,0.2858966750410038,0.9457890005378853},
{0.11940067342169716,0.34600195145650936,0.9306052486284035},
{-0.5944062739913332,-0.24880262612557819,-0.7647080715362928},
{-0.9180400631208545,0.20988629697099156,-0.33637803859476684},
{-0.5018268685298308,0.41622228513773535,-0.7582405972883972},
{-0.5657919714688868,0.7592892257623292,-0.32149543801210173},
{-0.9063856248379842,0.3759940367818646,0.19259694543666786},
{0.738792715539737,-0.4697953678405095,-0.4831952357184636},
{0.8323249118574234,-0.5542165879507197,0.00890026638895959},
{0.7026107184082646,-0.2537038702820619,0.6648101417560692},
{0.28139174408734097,-0.02059939562259852,0.959371852442768},
{0.41489254237357565,-0.7236869918432314,-0.551490087054777},
{0.45302309570614363,-0.7810398184249409,0.4298219128796921},
{0.09170135260492646,0.018500272881037505,0.9956146854249158},
{0.42727979441627184,-0.9022573332595414,-0.05799725737454661},
{0.1468024273982057,-0.5663093640027513,0.8110134102176079},
{0.3131008422423985,-0.9245024869150348,0.21740058480835975},
{-0.4074922373468171,0.8867831069427177,0.21809584531371978},
{0.824784477702193,0.5635893933474249,-0.04579913806833225},
{0.9860236007573295,0.12530299916317789,0.10980262815735779},
{0.42959633985477663,0.6641943410883209,-0.6117947875306153},
{0.7453309095137396,-0.5456226274395496,-0.38311588814532893},
{0.5012900519976261,-0.7281855493011598,0.46739072472310084},
{0.09449641629136694,-0.7263724528470789,0.6807741821287049},
{0.5254153817604549,0.03250095147928204,0.8502248906980181},
{0.2692862209765999,0.9608508345206641,0.06519666397205463},
{-0.7344384708946846,-0.445223321408379,0.5122268311441414},
{-0.9144486819714116,0.40242142347473314,0.04290228396388184},
{-0.5644664999073163,-0.7785537942034304,-0.27428372174415744},
{-0.7453827967635736,0.09939770592742048,-0.6591847861907},
{0.12539559806479356,-0.9820655251948464,0.14079505747625942},
{0.22119061065786216,0.963859085050241,0.14849369657636766},
{-0.6673727984390921,0.738969880201512,0.0923962340062513},
{-0.04539760216197903,-0.5571705710276369,0.8291562051258372},
{-0.693795986401828,0.6867960268964767,0.21669874640137812},
{-0.9545769472450828,0.027499335899056964,0.2966928349545528},
{-0.7816246176550057,-0.32331018281456414,-0.5334168002266889},
{0.16210377219866912,-0.9652224609880038,-0.20510477284359677},
{-0.37879794502672237,0.19549893942113045,-0.904595092584934},
{-0.4778203077946311,0.39501678857027894,-0.7846333476259262},
{0.38080983263681967,0.6226160761546321,-0.6836176512356352},
{0.8779707026064728,-0.4774840666225407,0.03429885546628931},
{0.48378968329500444,0.8713814179893898,-0.0814982620680919},
{0.7352744312762208,-0.14949480140866997,0.6610770114466336},
{0.4695840719784132,0.779173570880706,-0.4151859171325323},
{-0.9112112398599659,0.2645032626678676,-0.315803895465076},
{-0.11409967082292452,0.9409972852267483,0.3185990808429777},
{-0.1771879968057208,0.7705478010072712,0.6122585239511448},
{0.7640002368401102,0.36170011212705216,0.534300165633077},
{0.8512120362232889,-0.10980155260493082,0.5132072568019171},
{0.20429052726787078,-0.0867959753639314,0.9750547877577131},
{-0.7843956034749637,0.4323975764183763,0.44469750747745584},
{-0.528315073044054,-0.4707134296457245,0.7066201601607582},
{0.29040730383553837,-0.8015201584854821,0.5227131464009501},
{0.38857933590036065,-0.9137514079921502,0.11859369335507661},
{0.9340366850112198,-0.3164124273421306,-0.16570650825091982},
{0.36141933464447407,-0.6796363581194924,-0.6383341485986934},
{-0.4984657989425181,-0.8256433504249492,-0.26428186692178035},
{-0.7579217299275,0.017200493145207812,-0.6521186965110473},
{0.0008000154524476975,0.2052039635528344,-0.978718904138202},
{0.05969774675107252,0.2743896433583634,-0.9597637743999899},
{0.10130172518306992,0.8920151911480589,-0.44050750190663673},
{-0.9514851093745564,-0.16889735677704948,0.2571959749144886},
{-0.8352634580230499,-0.3445849247393068,-0.428481254355174},
{-0.5919315685523487,-0.6138327365727854,-0.5223278564873995},
{-0.30481721046556803,-0.31201761701199876,-0.8998508070108862},
{0.36650317026613427,-0.346702998993912,-0.863407468506904},
{-0.41799133094969315,-0.11779755690400444,-0.9007813179891953},
{0.13760449010776954,-0.3823124750595951,-0.9137298154903272},
{0.170892127181047,-0.4952771831057494,-0.8517607602856396},
{-0.5116949086609882,0.1850981582824876,-0.8389916520745927},
{-0.16659326893495027,-0.14259423859618195,-0.9756605792306782},
{-0.5988233725323538,0.665525975985774,-0.4455173888830388},
{-0.4002857140577934,0.35228742708608696,-0.8459698078763258},
{-0.15850668753822383,-0.47492003729906934,-0.8656365219753095},
{-0.7564091828632203,0.04700057059039048,-0.6524079202802286},
{-0.42422139826700656,-0.8612434422148656,-0.27981411417988783},
{-0.9988702041462088,-0.043898690521592315,-0.018199457118291122},
{-0.49801361587838977,-0.6676182529325562,0.5534151305765078},
{-0.7947491297362562,0.35167748984428954,0.49466833729306237},
{-0.12360186084002253,-0.11780177351905059,0.9853148340264902},
{-0.46989991776752155,0.7596998670525349,0.44949992133752065},
{0.1013018432038058,0.0696012664065635,0.9924180572108279},
{-0.2126011501753337,0.48390261792024447,0.8489045925862689},
{-0.5322745339341213,0.8245605498442165,0.19179082398753422},
{-0.361589307962243,0.3846886249255389,0.8492748873128678},
{0.034600764339326476,0.18290404039487898,0.9825217041441694},
{0.2846849562209723,0.2885847501418075,0.914151692930147},
{-0.3894910067564798,0.38829103446352015,0.8351807158999023},
{-0.6734286853057889,0.12250521822090754,0.7290310537391151},
{-0.99969751575476,0.023799940857220453,0.006199984593057429},
{-0.6951918176404592,-0.23509723292185264,-0.6792920047801553},
{-0.7848066159476589,0.4423037286361487,0.43410365950927454},
{-0.9259402376073068,0.28021217688472555,-0.25321100352324233},
{-0.7107851447457105,0.6703859890792409,-0.21299554843955593},
{0.7287908428005899,0.1611979745601744,0.6654916381500996},
{0.4832098165071345,-0.10880221033935478,0.8687176481782859},
{0.4428037527777073,-0.7240061359780038,0.5289044824844837},
{0.4445088235877232,-0.5143102091589786,0.7334145584234785},
{0.43971712731566986,-0.7749301841185186,0.4540176843332139},
{0.322598893487693,-0.8526970752540478,-0.41089859062025125},
{0.28350007654503095,-0.6639001792530727,-0.6920001868400756},
{0.7960244025020938,-0.5790177500611963,-0.17630540472502404},
{0.5864869772012552,-0.46298971942741884,-0.6645852430485152},
{0.8337228526565913,-0.3225088400884619,0.4482122856671275},
{0.46072405503088615,-0.8870463138971044,-0.029701550758448707},
{-0.30110453617400645,0.875513189705555,0.3779056931921522},
{0.8136940844655087,0.555695960105055,-0.1705987597515249},
{0.9895610021693416,0.10649580308309911,-0.09709617351520117},
{0.2986978762656496,0.7256948403280277,-0.6197955932689977},
{0.6242850828861646,-0.41968997162794053,-0.6588842561487969},
{0.24020069418100928,-0.9707028053351612,-0.006300018207078928},
{0.5762838844465041,-0.7467791166140019,0.3319907160094384},
{0.666806264674285,0.013600127773800654,0.745107000313152},
{0.2952037727283234,0.952212169349287,0.07840100197120783},
{-0.6337166226050193,-0.4824126538498679,0.6047158619050894},
{-0.8656642877564475,0.4170827936042674,0.27688857719736665},
{-0.6218746249236344,-0.7533692593945428,-0.21379127642494458},
{-0.8563790703512777,0.15859612395809508,-0.4913879906242618},
{0.07379960554216256,-0.7404960420592326,0.6679964295686258},
{0.37979494116507534,0.9215877245332633,0.08019893175734344},
{-0.6812896104126612,0.6683898071331612,0.2984954479791272},
{0.24819584399538813,-0.5507907770856558,0.7968866562446608},
{-0.5977845982782356,0.6804824675950808,0.423789081214982},
{-0.854091740972797,-0.07829924284998245,0.5141950277581223},
{0.2156002156003234,-0.9442009442014163,-0.24900024900037349},
{-0.8779668749347014,-0.32608769694328715,-0.3504867763833859},
{-0.6091793613528501,0.1873936512106437,-0.7705738933987301},
{-0.6622843239155772,0.3965906128112909,-0.6356849535152235},
{0.17540350108882297,0.6896137648281203,-0.7026140243158895},
{0.9062953099339067,-0.3978979408834839,-0.14249926256822432},
{0.37930425961075326,0.9219103531113985,-0.07880088493890682},
{0.9454989930441087,0.28679969455848797,0.15419983577726235},
{-0.9497732880019071,0.2934917456607283,-0.10859694575385041},
{0.12350144435783769,0.8970104905990317,0.4244049634450714},
{0.15080542833909136,0.7479269221141011,0.646423268424328},
{0.90116769371726,-0.2298917585281825,0.36748682583343656},
{0.3543916205091984,-0.2527940227559971,0.900278713161488},
{-0.6005674110936315,0.4478756966847113,0.6623640577895796},
{-0.4476900121472423,-0.48968907515859855,0.7481833082165885},
{0.2647957633016805,-0.891985728342519,0.3663941377406939},
{0.2523073864068572,-0.9670283101681764,-0.0346010129594818},
{0.8299958458811869,-0.41949790041826257,-0.3675981601758124},
{0.06959683132840278,-0.6528702754930198,-0.7542656590662962},
{-0.6862057710148015,-0.6915058155883638,-0.22570189816094535},
{-0.8446790099873994,0.2668933677822149,-0.46398847002977783},
{-0.06449779389068931,0.3339885761161276,-0.9403678352682826},
{0.32850058637407004,0.8413015017245209,-0.42930076630255176},
{-0.13420240627071683,0.3163056714115331,-0.9391168385158732},
{-0.4768102586830746,0.18730402988955508,0.8588184776783231},
{-0.9488678054615318,-0.00729975232360542,0.3155892922369686},
{-0.9682945485170377,0.15309913805427913,0.19739888864738533},
{-0.8749206002480521,-0.047701123136166514,-0.48191134673623987},
{-0.9391463339273546,-0.1284063350828158,-0.3186157192942766},
{-0.4906976103084567,-0.2632987177383669,-0.8305959550075486},
{0.28929172348218507,-0.38868887977022243,-0.8747749730460267},
{0.3488889107422053,-0.28439096077696524,-0.8929716173482067},
{-0.11029809351393026,0.36919361854345467,0.9227840498155471},
{-0.6476696282449085,0.47507772175259533,0.5956720666133888},
{-0.9081147933104755,0.41340673445055676,-0.0665010833114708},
{-0.6389151232999549,-0.03840090896027276,-0.7683181863067075},
{-0.1269998425202929,-0.32019960295273847,-0.9387988358901651},
{-0.0567003010793981,-0.4107021808343704,-0.910004832138488},
{-0.5367032363302726,0.34480207916280603,-0.7701046437450028},
{-0.43400987383694595,-0.11970272326793187,-0.8929203141682236},
{-0.5359857590475706,0.71848091021582,-0.44328822198841056},
{-0.8356275051320046,0.17840587232593302,-0.5195171001867835},
{-0.5566662865272537,-0.7467547741666124,-0.36397795634259095},
{-0.9818937060815159,-0.13389914170925243,0.13399914106825864},
{-0.4331030966982121,-0.6528046675700597,0.6215044437726596},
{-0.6076973929837762,0.3851983475026338,0.6944970206141724},
{0.06789812569810981,-0.22679373944523276,0.9715731800925403},
{-0.2984969583314918,0.7797920539594551,0.55029439252871},
{0.3319928655499782,-0.033699275810344174,0.9426797420300134},
{0.04050075878882393,0.3622067860077044,0.9312174465222924},
{-0.5354085558970854,0.8428134682668352,0.054800875724991184},
{-0.41600414134184066,0.5740057142553282,0.7053070213663467},
{0.2482932787919134,0.10129725792034164,0.9633739218208996},
{0.5127181146509916,0.15780557536946843,0.8439298165671383},
{-0.8506263783329945,0.5201161290512467,0.0769023847799286},
{0.28160468594096144,-0.5440090523859482,-0.7904131525842895},
{0.6756805845973484,-0.6342817741750749,-0.3756892047258011},
{0.8694011476102723,-0.4284005654891197,0.2462003249846435},
{0.6366913601568636,-0.23389682604160575,0.7347900289669599},
{0.49548716209394306,-0.8613776819933856,0.11189710078367755},
{0.459016566206817,-0.6641239686665515,0.5901212978619667},
{0.337286665635256,-0.9406628116308489,-0.037298525431945},
{0.12839708734511,-0.8058817187805618,-0.5779868885161493},
{-0.04849925626960761,0.885086427303705,0.46289290159178065},
{0.8689167441869922,0.44720861779309806,-0.21210408728514335},
{0.9574352486275293,-0.02560094251604841,-0.287510584897028},
{0.2950079638474775,0.7050190322456666,-0.6449174097804687},
{0.43628447945571014,-0.5314810928964243,-0.7260741703708253},
{0.50608014686525,-0.8509666172343959,0.14049448850932156},
{0.29369035096202617,-0.748875396103035,0.5940804818064002},
{0.4944799171059919,0.8626649635739924,0.10629568288850746},
{-0.5602068429683805,-0.4313052684260309,0.7072086386062811},
{-0.7271799846463801,0.5214856463051254,0.4463877133472829},
{-0.7741814276103247,-0.6224850667623704,-0.11469724844601425},
{-0.8964713223410902,0.3262895621638569,-0.2997904098581805},
{-0.008499741484294073,-0.9976696563388467,-0.06769794099843632},
{0.4903252548526435,0.8697447973594618,0.05590287935195344},
{-0.518180441648338,0.7091732327614846,0.4780819551371486},
{0.32959858767307776,-0.6754971055011044,0.6595971736321665},
{-0.4355876708654617,0.6722809713564047,0.5985830573463393},
{-0.77476517896153,-0.0332985034323941,0.631371623640049},
{-0.9430759047184476,-0.23849390655853012,-0.23179407773696972},
{0.06659908460187318,-0.90678753629097,-0.4162942780744715},
{-0.6437128164497645,0.39070777906932264,-0.6580131011712678},
{-0.7290929606414475,0.5254949263709787,-0.4384957663438139},
{0.3202880550797245,0.7114734660918639,-0.6254766732824467},
{0.9121162996639137,0.016300291288808017,-0.4096073197482064},
{0.9743731222881273,0.21149416601389462,-0.07659788707642708},
{-0.8871843679491539,0.4455921487355083,0.11979788917978881},
{-0.35400164080140767,0.9352043346821369,-0.008700040324780358},
{-0.5488698541511184,0.7989561185402506,0.24578650054717596},
{0.4036916295408413,0.584687876622566,0.7036854092343078},
{0.35820198086243127,0.20030110766818812,0.9119050428488304},
{-0.2465110402441615,0.09630431308524444,0.9643431890768558},
{-0.9586552606029571,0.28378675598114034,-0.02109901533193115},
{-0.7034170228979336,-0.45981112756393216,0.5420131168761445},
{0.21090653187643987,-0.6106189111605225,0.763323640499225},
{0.8094816614006891,-0.044099000948450144,0.585486735948244},
{0.928232284480291,-0.35961250754052215,0.09520331122874781},
{0.3400860244519818,-0.8076668096144243,0.48168020575865816},
{0.5704692924644578,-0.748959684585239,-0.33708185537207486},
{-0.2727079918248023,-0.9437276563442096,-0.1871054832065292},
{-0.4042126035454709,-0.2760086060825086,-0.8720271902316937},
{0.34890008722503263,0.01730000432500162,-0.9370002342500878},
{0.9856193873240249,0.15610307057759767,0.06470127268655074},
{0.31148254189277663,0.11679345391035734,-0.9430471436888528},
{0.10150083078770002,0.8037065783652659,-0.5863047989244189},
{-0.6912286174571564,0.33741396922749495,0.639026456242944},
{-0.9630320213470736,0.05690189201936499,0.2633087551616661},
{-0.7191076010075141,0.4642049066717954,0.5171054658336609},
{-0.976794993938484,0.16199916975638248,0.14009928199301966},
{-0.8729320983033928,-0.4034148338361652,-0.274310086567328},
{-0.958207507585233,-0.28530223535177096,-0.02100016453693372},
{-0.616994481009051,-0.6266943942437152,-0.4759957422371284},
{-0.346499158008069,-0.6118985130884198,-0.7109982722762975},
{0.18309790994928685,-0.6110930244129392,-0.7700912094590158},
{0.6998073970032797,-0.4471047259219296,-0.5571058886403646},
{0.0442987689543159,-0.4596872254695038,-0.8869753512974764},
{0.5872170471583221,-0.4751137927536084,-0.6553190241874123},
{0.06989986369539869,0.03329993506518994,-0.9969980558556866},
{0.6158766402420451,-0.5435793824250296,-0.5702783697516454},
{0.41560970459990493,-0.193504518383257,-0.8887207518718372},
{0.11669733758061429,0.39949088571941227,-0.9092792550304419},
{0.3608919143072389,-0.2531943272446464,-0.897579889947846},
{0.03610018970699536,0.5842030699951993,-0.8108042607875856},
{-0.22299720251764152,0.01599979928377697,-0.9746877726185883},
{-0.27220598179217553,-0.7839172267703395,-0.5580122624542027},
{-0.6214072829360342,0.3964046458896749,-0.6758079205152429},
{-0.833508856078644,-0.5525058704060597,0.0005000053125846695},
{-0.8884723245181301,0.4506859613509524,-0.08659730253603834},
{-0.7128167014909762,-0.006900161672682009,0.7013164320365063},
{-0.4833920216805227,0.8747855617834531,0.03289945699894331},
{-0.6051909161525222,0.5842912298544594,0.540691884275725},
{-0.3091989409954406,0.8385971278097558,-0.4484984638953917},
{-0.9063129694313895,0.4112058843983089,-0.09750139525494922},
{-0.40650469515634374,0.2099024243870026,0.8892102704379357},
{-0.363706501311817,0.3984071215909482,0.8420150511535602},
{-0.14210504908209243,0.48421720454292155,0.8633306746838169},
{-0.3883782630769063,-0.4886726497571682,-0.7812562743099559},
{-0.7020995295934727,0.19729986780913283,-0.6841995415864607},
{0.9741543473262437,-0.20279049644607086,-0.09949533726027639},
{0.8642742925434966,-0.4651861632433584,-0.1913943070610034},
{0.855725282776975,-0.38191128373556943,0.3491103146166203},
{0.5358135241040247,-0.08720220101133064,0.8398211973545352},
{0.0475991194244359,0.1717968217881951,0.9839817965051454},
{0.6138931336437001,-0.7359917679781126,0.2853968078545561},
{0.19000340109131958,-0.4246076005440752,0.8852158455054531},
{-0.3250986508433985,-0.2089991326553992,0.9222961724788263},
{-0.05809980768995481,-0.6589978187208301,0.7498975178433238},
{0.23679718686612994,-0.9113891727609409,0.33659600126325734},
{0.4528825168079015,-0.8533670564006693,-0.25819003276617386},
{0.5755942296967709,-0.7461925194574885,-0.3344966466879254},
{0.1396048234299757,-0.8257285294135455,0.546518882553594},
{0.14640032061705324,-0.7929017364567044,0.5915012953892554},
{0.5250838434187032,0.8507738220922351,-0.021699332321816527},
{0.7404740024141548,0.672076403811686,0.0033998806322864633},
{0.9149919938550805,0.28569750015781037,0.28489750715771844},
{0.9246426778677183,-0.22021016403468696,-0.31071434135139525},
{0.34160007856802715,-0.8863002038490703,0.3127000719210248},
{0.4695102471729681,-0.5327116265581259,0.7041153674855949},
{0.026200352528114916,-0.5736077179437677,0.8187110158308275},
{0.28041629826889686,0.28221640289401817,0.9174533239368259},
{0.11659956391844642,0.9893962996647588,-0.08659967611781698},
{-0.7872021962971915,-0.46270129093840257,0.4077011374877604},
{-0.9343866477102056,0.2488964432952378,-0.25489635755707557},
{0.4059995838506399,0.6932992893685926,-0.5953993897159384},
{-0.5703874715767787,-0.14989670755497744,-0.8075822616504321},
{-0.36218880129539327,-0.9105718455537964,-0.1991938410216519},
{0.17980038747025248,0.9594020675136832,0.2173004682830137},
{-0.6116966295608566,0.7702957556820791,-0.18019900710620623},
{-0.388896276335981,-0.5412948171269388,0.7454928619400202},
{-0.7067704964814236,0.705270559095003,-0.05539768747180372},
{-0.9889746133475088,0.040298965538831756,-0.14249634216584428},
{-0.4870794310699296,-0.31058688419281494,-0.8162655298344972},
{0.19170306535652276,-0.974715585826827,-0.11480183569602928},
{0.041700422427418796,0.17820180519342996,-0.9831099589543266},
{-0.11970261373510667,0.40100875612178594,-0.9082198311965236},
{0.6461047715013564,0.585104321011366,-0.49010361942859426},
{0.7721836684881153,-0.5024893724621573,0.38889177502593636},
{0.49738577248346433,0.8630753120837917,0.08779748858875787},
{0.41718591604120764,-0.15919462568015402,0.8947697930816697},
{0.6084010160305452,0.7629012740461915,-0.2187003652299149},
{-0.8400566457952369,0.023898766616481566,-0.5419720295453142},
{0.6379191601897188,0.4616138647806462,-0.6164185144081245},
{0.5538057873007161,-0.08290086631857957,0.8285086579607137},
{0.004700149020587084,-0.4013127238216163,0.9159290399905767},
{0.1637007620288209,-0.6880032026623626,0.7070032911079801},
{0.5346168487154851,-0.2934092469381282,0.7925249768182229},
{0.00010000138702885723,-0.22990318877934274,0.9732134985648384},
{0.0,-0.6597144017225861,0.7515164057822094},
{-0.1637007620288209,-0.6880032026623626,0.7070032911079801},
{-0.5352999732350021,-0.2924999853750011,0.792399960380003},
{-0.5538057873007161,-0.08290086631857957,0.8285086579607137},
{-0.004700149020587084,-0.4013127238216163,0.9159290399905767},
{0.09219955329424644,-0.22409891424339073,0.9701952994151615},
{0.47792125363073396,-0.16670741364353076,0.8624383534863883},
{-0.09029691460714091,-0.22799220963929265,0.9694668738828695},
{-0.47979649270045754,-0.17029875512065012,0.860693708351988},
{0.92546345879673,-0.18139283784519375,0.3325868680667665},
{0.9826111379603736,-0.1769020051955934,0.056400639304869805},
{0.9337075957421872,-0.3452028082362676,0.09500077283443054},
{0.7961158786895522,-0.595911885581088,0.10530210027133508},
{0.9520303702532243,-0.27480876653948116,-0.13460429394546639},
{0.9822070277164251,0.15030107540804183,0.11260080566164678},
{0.9985165106070055,-0.03820063165266661,-0.038800641573912685},
{0.9784681122438246,-0.14619523557490766,-0.14569525186911111},
{0.9792256511519024,0.030900809457305743,-0.20040524968427414},
{0.6881981108987784,-0.5294985465284846,-0.495998638485606},
{0.6832214124946066,-0.5752180276154826,-0.4498140973947219},
{0.7119087351737712,-0.6928085008124577,0.11490140984894832},
{0.7995664628880564,-0.5221780976990283,0.2966875557014587},
{0.8045748936321602,-0.3268897995629545,0.4957845292851417},
{0.8030015859296983,-0.5116010104129933,0.30570060375928865},
{0.8581077144230291,-0.5020045130408585,0.10790097003408093},
{0.9662860565928043,-0.05909914720545869,0.25059638392026984},
{0.9006366476508045,-0.34011383951370044,-0.27051100731683614},
{0.9119720484850644,0.07309775958800242,0.40368762716383827},
{0.9734596704012656,0.22499067882926016,0.04189826419087111},
{0.8923602640821409,0.4266810003180743,0.14709345007449903},
{0.920251218006847,-0.3007167368557475,0.2504139371755211},
{0.9380163872894303,-0.14650255942206986,0.31410548747079964},
{0.7913091080202502,-0.08480097606485179,0.6055069694253273},
{0.8484746691668723,-0.5264842820463856,0.05389839088755972},
{0.9031485319903348,0.4274229681903101,0.04040217106899516},
{0.6372837430990677,0.026299329112671396,0.7701803529497911},
{0.5612984676572749,-0.31359914387550575,0.7658979091015622},
{0.6465966991322764,-0.15169922557743012,0.7475961835312246},
{0.4858807643613009,0.28408875314888987,0.8265672768492515},
{0.36361225939399167,0.4556153613308653,0.8125273948229325},
{0.24461189331938682,-0.4384213165626295,0.8648420496427053},
{-0.25091379311032136,-0.43622397989128003,0.8641475034939364},
{-0.4830942149814132,0.2802966434677916,0.8294900669159228},
{-0.36369903619883115,0.4555987926647992,0.8124978468835586},
{-0.6534166296648402,-0.1523038761829739,0.7415188718954377},
{-0.6397010427135494,0.05290008622721083,0.766801249887056},
{-0.8116679640976731,-0.08379669260981275,0.5780771837438274},
{-0.7592079679294352,-0.30660321781765654,0.5741060252743531},
{-0.7131151538580309,-0.503010689090716,0.4883103767057587},
{-0.7366031600343348,-0.2781011930566773,0.6165026448020193},
{-0.5257712910424575,-0.33738157778190403,0.7808573624478035},
{-0.34519273376943044,-0.2540946513638826,0.9034809819254935},
{0.7975043264727066,-0.3071016660310573,0.5193028172254252},
{0.4677822433230587,-0.7021733460056687,0.5367796242321888},
{0.5286961563929146,-0.8410938852696811,0.11419916977505361},
{0.1751896343359954,-0.8708484734201964,0.4592728256308373},
{-0.0026000301995261522,-0.9440109647510337,0.3299038318552607},
{0.9750595797429151,-0.09889590035542438,0.1986917634036686},
{0.5497028749535541,-0.8044042070450044,0.225301178328244},
{0.6460870590058109,-0.6273874335555576,0.4346912932205943},
{0.4635872770217708,-0.6856811817381973,0.5611845985000384},
{-0.46590017238309567,-0.7018002596661441,0.5389001993931107},
{-0.7950958456350598,-0.3449981973891279,0.49879739379042615},
{-0.8031257205130558,-0.5097163239266648,0.308509880187122},
{-0.9734919541222485,0.2237981503159314,0.04719960989683629},
{-0.8366828523606595,-0.5472887834313241,0.02089957166766796},
{0.0,-0.5593990014736736,0.8288985204174616},
{-0.175197679522102,-0.870888465158668,0.45919391801683357},
{-0.5286961563929146,-0.8410938852696811,0.11419916977505361},
{-0.799590181092864,-0.522193587502118,0.29659635781908883},
{-0.7119087351737712,-0.6928085008124577,0.11490140984894832},
{-0.8581077144230291,-0.5020045130408585,0.10790097003408093},
{-0.8925300118262298,0.4261143283351894,0.14770496666300745},
{-0.9031706067908951,0.42738609094600155,0.04029868850052378},
{-0.45042521325698787,0.7215403893537228,0.5258294341263859},
{-0.6453918648868143,0.6856913569149188,0.3365957572372199},
{-0.7704928421547445,0.5032953244081543,0.3911963658026425},
{-0.5641783895606739,0.5730780486657607,0.5943772328161372},
{-0.7013987480043523,-0.636898863136544,0.3199994288015294},
{-0.650504377909195,-0.6310042466728703,0.4227028447997183},
{-0.2668951812510034,-0.9636826008677105,0.009099835703949535},
{-0.2961903828544006,-0.9454693011101813,0.1354956005292751},
{-0.5286905127338727,-0.6323886518874619,0.566189839814486},
{-0.19980591634077557,-0.9485280863324606,0.24570727550014293},
{-0.2413946942029315,-0.8621810494687967,0.44539021043076094},
{-0.18820342909771753,-0.6076110707745652,0.7716140589362319},
{-0.060901317005220515,-0.9295201010895315,0.3637078652676306},
{0.04220165138292856,-0.3071120175283734,0.9507372030746487},
{0.2529978697669048,-0.6371946348437618,0.7279938703174178},
{0.0755974350225438,-0.8460712932880199,0.5276820960502164},
{0.20039616044634842,-0.9129825074227351,0.35539319073169773},
{0.5070845569749726,-0.6586799402078769,0.5558830708388626},
{0.1998010060005978,-0.9485047757335686,0.24580123761234704},
{0.2961031653597566,-0.945510107557075,0.1354014474492099},
{0.7069006150038025,-0.6237005426197081,0.33360029023237875},
{0.26680254397438524,-0.9637091890109261,0.009000085816227387},
{0.6506306031301443,-0.630929676475266,0.42261987839348136},
{0.7689149709202271,0.502809789801912,0.3949076889275558},
{0.4904888292441195,0.5458875675522219,0.6792845294710099},
{0.47041333875933344,0.7068200421664474,0.5283149805836647},
{0.6453918648868143,0.6856913569149188,0.3365957572372199},
{-0.3609013407509713,0.44900166804429514,0.8174030366579217},
{-0.17319633347243016,0.7142848787491737,0.678085645078839},
{-0.0016999100601380141,0.3581810491420216,0.9336506018534493},
{0.18750082688046982,0.43980193953083,0.878303873328622},
{-0.02249964158356434,0.6830891184770134,0.7299883713778652},
{0.1823021849047792,0.7095085035103722,0.6807081583361667},
{-0.91353857498076,0.09410397362418119,-0.3957167094908448},
{-0.9750478272689201,0.2143105121884406,0.05790284020396972},
{-0.9526797891126588,0.29829367176687954,-0.0584987589619928},
{-0.6775959581521643,0.6298962426801186,-0.3795977357062597},
{-0.7861363635785155,0.18780868729175065,-0.5888272368337741},
{-0.5160724914889923,0.3133832955486343,-0.7971575086514718},
{-0.5198677614003842,0.5940631603153841,-0.6138619325325944},
{-0.4129997067703123,0.9048993575216844,-0.10289992694107782},
{-0.6337020595350402,0.7466024264618291,0.2025006581282084},
{-0.8029950013716748,-0.43889726787301125,-0.40319749010343614},
{-0.7235295676399347,-0.6479264780565497,-0.2381097305529626},
{-0.7514225805878251,-0.5513165673117754,-0.36251089361603217},
{-0.5797037043185059,0.7488047848778632,0.32130205312667925},
{-0.4908840416192062,0.7613752480930202,0.4234862326863594},
{-0.824006011145777,0.5290038590972282,-0.2029014801716968},
{-0.6971978665777924,-0.42919868665402827,-0.5741982429560648},
{-0.2422884055657708,0.38888139052632387,-0.8888574647437626},
{-0.2649945663421252,0.5750882079371931,-0.7739841296181317},
{-0.034599261659634194,0.6265866287840112,-0.7785833852078377},
{0.0017999871391378359,0.4191970048481005,-0.907893513124023},
{0.2271018327191851,0.5863047314982749,-0.7776062753079627},
{0.2423959447497662,0.388293503904019,-0.8890851257302687},
{0.5208031326402642,0.593303568731699,-0.6138036920403115},
{0.5161136307409842,0.3134082772219036,-0.7971210522449884},
{0.6776386400569155,0.6298359142677766,-0.37962164664345505},
{0.41311151357832737,0.9048252178302363,-0.10310287351712794},
{-0.22339470895897673,0.15089642606047265,0.9629771921553025},
{-0.4868755838016932,-0.18499072294786043,0.853657190165343},
{0.0,-0.4075019376763204,0.9132043422969714},
{0.3211899003423731,0.12839596265243058,0.9382704965480968},
{0.4934084324221657,-0.19990341637857909,0.846514467055864},
{0.385079025316721,-0.5577696191162477,0.7352599514811347},
{-0.38510733829024735,-0.5578106291828095,0.7352140096364317},
{-0.6481464672859194,-0.4315309375619105,0.6274449831433201},
{-0.5707984474303346,-0.2671992732189653,0.7763978882006163},
{-0.6922796092044119,0.24189287515029212,0.6798799744302754},
{0.012099999697500011,0.5707999857300006,0.8209999794750008},
{0.692887715209713,0.2420957076811539,0.6791879581042533},
{0.5707984474303346,-0.2671992732189653,0.7763978882006163},
{0.6481464672859194,-0.4315309375619105,0.6274449831433201},
{0.47280579427051345,-0.3741045846797781,0.7978097772187301},
{0.2861040541231706,-0.09260131216989023,0.9537135142162453},
{-0.5820183309560047,-0.1799056662181877,0.7930249767149687},
{-0.8847627345784128,0.37858405437543746,0.2717885525072475},
{-0.6562412723114642,0.6117384734424303,0.44172778113376066},
{0.0,0.8182959371707579,0.574797146139254},
{0.6561721395224213,0.6117740246263598,0.4417812423666652},
{0.8847721743526681,0.3784880967365335,0.2718914491483843},
{0.5818955717915479,-0.17999863021563606,0.7930939645778943},
{0.5260704198919108,-0.3373810295980435,0.7806561049412939},
{0.34519273376943044,-0.2540946513638826,0.9034809819254935},
{-0.2861040541231706,-0.09260131216989023,0.9537135142162453},
{-0.47272814234399557,-0.37412227216181243,0.7978474972753112},
{-0.545611520708891,-0.11850250220675142,0.8296175175588268},
{-0.17799915628599877,0.09119956771507354,0.9797953557810203},
{-0.42151056740238885,-0.03810095520292056,0.9060227142741739},
{-0.6710676788036068,0.13839333444556576,0.7283649191484834},
{-0.8348762815017591,-0.04749865058250516,0.5483844206199122},
{-0.7392739447489678,0.18259356460322135,0.6481771553987299},
{-0.5338845469354303,0.5121851750146608,0.6727805266494802},
{-0.5748183369974299,0.25040798814223464,0.7790248512891405},
{-0.8138017740898013,-0.24580053584575223,0.526601147991754},
{-0.9415539855454363,0.21681243129713285,0.25781478223432125},
{-0.8732781901495481,-0.41908953336960447,0.24849379394499338},
{-0.7712932319315845,-0.42309628734636767,0.4754958275424198},
{-0.9211965501253797,-0.349898689631861,0.17019936260458057},
{-0.8576824262671268,-0.5019897143361287,-0.1112977195330899},
{-0.9512471069231311,-0.04960245637446099,0.3044150750077808},
{-0.8136946214963279,0.4356971200515547,-0.38479745649721886},
{-0.9073206236321654,-0.42020955147165867,-0.01390031595777262},
{-0.3485082004944376,-0.23900562386849522,0.9063213259917039},
{-0.3415204884286697,-0.30311818460535805,0.889653371906719},
{-0.5371951222904343,-0.10739902482128191,0.8365924037754605},
{0.05770294927310795,0.15800807599915173,0.9857503829896448},
{-0.35289900835517973,0.2760992241622701,0.8939974878705885},
{-0.6460870590058109,-0.6273874335555576,0.4346912932205943},
{-0.5497028749535541,-0.8044042070450044,0.225301178328244},
{-0.0,-0.24571093683720335,0.9693431464236923},
{0.04699973656721481,-0.0009999943950471236,0.9988944012125718},
{0.1739028633342174,0.1669027480763708,0.9705159796771592},
{0.03330156021464494,0.2850133531884026,0.9579448807690206},
{-0.476471081465289,0.280482976602337,0.8332494274607039},
{-0.8049070711396801,-0.3271028736113671,0.4951043495108158},
{-0.4635872770217708,-0.6856811817381973,0.5611845985000384},
{-0.7379300454334622,0.14540592032257135,0.6590268328237587},
{-0.9280489976402798,-0.20201066543462987,0.31291652086384003},
{-0.9065001541050394,0.07550001283500328,0.41540007061801804},
{-0.9784379788072354,-0.08660336157472054,0.18750727823625984},
{-0.981372320784033,-0.1061970047557207,0.16009548457053563},
{-0.979022845764662,-0.1932045084798087,0.06470150982734793},
{-0.9870644169691409,-0.12369554085612677,-0.10199632309882724},
{-0.9812932585384706,-0.12419914675479268,0.14709898943341387},
{-0.7980735602609157,0.13869540509734243,0.586380573533393},
{-0.6267215501910114,0.19470669510481875,0.7545259448206766},
{-0.38298263213144035,0.2570883413080765,0.8872597636820548},
{0.05209987365795956,0.09619976671584855,0.9939975895587678},
{-0.06630288788517412,0.14060612423311436,0.9878430264400453},
{-0.2002100938463283,0.20131014930702243,0.9588483415577401},
{-0.020600696212292942,0.2922098753996116,0.956132313037538},
{0.35700394491538706,0.2317025603274375,0.9049099993107389},
{0.47341975621864907,0.2703112803250968,0.8383349844488669},
{0.7476953530878209,0.09849938782820697,0.6566959186475483},
{0.6113315302367789,0.15800814948046962,0.7754399943490895},
{0.83058515757585,0.09169836136492349,0.5492901842721098},
{0.9423405686347384,-0.03310142504702307,0.33301433657579105},
{0.9339337436357474,-0.05420195835213354,0.3533127654208262},
{0.9712255144294004,-0.1849048575144112,0.15010394328238574},
{0.9823310961830323,-0.15340485610758134,0.10720339357713637},
{0.9786869395099378,-0.1645978034569692,0.12279836126680327},
{-0.0,-0.22409260842721448,0.9745678544094746},
{-1.0,-0.0,0.0},
{-0.0,-0.5636905047134214,0.8259860863815612},
{0.5350945393880883,-0.10539892440946458,0.8381914462999356},
{0.3415204884286697,-0.30311818460535805,0.889653371906719},
{0.3493046195841412,-0.24090318596570173,0.905511975475064},
{0.3537082238118066,0.2766064311742881,0.893520774599517},
{-0.8092682004308338,0.15769380354373222,0.5658777642701208},
{-0.860704380996449,0.030300154228177535,0.5082025867577499},
{-0.45310469872008874,0.26290272631540795,0.8518088333034023},
{-0.04740121633081677,0.37840971011774405,0.9244237210170259},
{0.26369407486070606,0.3182928480400559,0.9105795395076183},
{0.5277996885982756,0.2602998464231359,0.8084995229854222},
{0.8180999468235053,0.15639998983400102,0.5533999640290035},
{0.860704380996449,0.030300154228177535,0.5082025867577499},
{-0.12760010080411943,0.687900543441644,0.7145005644556689},
{0.15659806445988483,0.6869915088374259,0.7095912295066046},
{0.6120127759000467,0.47110983452044447,0.6352132602152119},
{0.8648928603389068,0.31809737411701494,0.3882967946231905},
{0.6382029836059225,0.6650031088968011,0.3879018134452168},
{0.8955312321963438,0.39901391585297735,0.1970068707344274},
{0.6471011453700409,0.7491013259105203,0.14180025098666638},
{0.8912633029889836,0.4534813282907036,0.0020999135378400825},
{0.6480023814131276,0.7593027904428824,-0.059600219031207415},
{0.8430273777586463,0.5058164266551878,-0.18290593996685223},
{0.5559205527627604,0.7789287975299769,-0.2902107292889964},
{0.2701091879202933,0.841428621681358,-0.46801591983227425},
{0.28371490961026036,0.7211378967922408,-0.6320332142181337},
{0.04759978960939489,0.813796403027848,-0.5791974399529731},
{-0.22701291172654212,0.7474425120018394,-0.6243355100919834},
{-0.26379358857474355,0.8395795942659391,-0.47488845797629164},
{-0.5559896447892979,0.7788854933927771,-0.29019459517599683},
{-0.843042793938358,0.5058256763630149,-0.18280927963455734},
{-0.6480023814131276,0.7593027904428824,-0.059600219031207415},
{-0.8912633029889836,0.4534813282907036,0.0020999135378400825},
{-0.6454270149130756,0.7507314225212982,0.14080589355401466},
{-0.8954778506292936,0.3990901286277511,0.1970951249123772},
{-0.6400377729437883,0.6626391068008657,0.3889229529653738},
{-0.8648928603389068,0.31809737411701494,0.3882967946231905},
{-0.6130875513836525,0.4683904894276673,0.6361870823524379},
{-0.020499233855451708,0.8998663681229753,0.4356837166253809},
{0.0985012554065003,0.86011096218407,0.5005063789944507},
{-0.09729716382901096,0.8625748563094024,0.4964855276578001},
{0.05029784704673476,0.8883619744795063,0.45638046505228125},
{0.36950017181761985,0.9021004194767925,0.22290010364857227},
{0.3695043361588274,0.9292109043539443,0.005800068064198102},
{0.36089511531767104,0.9024877849104962,-0.23509681798610269},
{0.1889091708183015,0.9661469027398679,-0.1757085299776367},
{-0.053996699552606685,0.9424423949691074,-0.3299798305992631},
{-0.020300456054867966,0.8403188779756431,0.54171216970059},
{0.2331961173169697,0.8990850303588657,0.3704938313290621},
{-0.3529056130084127,0.8983142878023721,0.2617041624378056},
{-0.20809210409491236,0.9487639998330266,0.23779097719255243},
{0.004999817859952983,0.9568651420378018,0.2904894176632683},
{-0.1739960590338938,0.8916798036811674,0.417890534886576},
{0.20970741014225838,0.9470334640186872,0.24320859392750235},
{0.011200248088242762,0.9999221485208872,-0.005500121829047785},
{-0.2122949962659063,0.9743770342039525,-0.07429824881091304},
{-0.38171565638872673,0.9242379083952351,0.008800360954206957},
{-0.3513162065904236,0.907841879711889,-0.22891055988769704},
{-0.944856296682722,0.03789824705712262,0.32528495429240073},
{0.1216042160912591,0.6767234624091697,-0.7261251751962436},
{0.4899944606439334,0.8629902439504379,-0.12309860837809838},
{-0.11089928414743125,0.4732969448780812,-0.8738943590301187},
{0.039800190842372636,0.2394011479312565,-0.9701046516629571},
{0.10189788003665852,0.41219142444662066,-0.9053811637408304},
{-0.04210136347473455,-0.08910288564367812,-0.9951322278790582},
{-0.5892062073200913,-0.033000347660493916,-0.8073085050399011},
{-0.4634324761686911,0.3477243676388734,-0.8150571171287943},
{-0.7934353046893408,0.21230944691901565,-0.5704253816420468},
{-0.571718927068376,-0.6753223569166947,-0.4659154243854406},
{-0.8804295785285443,-0.0711023887248745,-0.4688157501296929},
{-0.8285889756970171,0.18389755325933071,-0.5287929644564116},
{-0.9295917359662006,0.09589914746036858,-0.3558968360911906},
{-0.9895886692746049,0.060699304996936654,-0.13049850580066283},
{-0.9291950752791514,0.05139972758216571,-0.3659980602154212},
{-0.9784859343657895,0.1530977992349539,-0.13829801198036656},
{-0.9758111340685599,0.05050057621486194,-0.2127024269485373},
{-0.6811926806239699,-0.5881936798928641,-0.43589531632998896},
{-0.985903125317861,-0.011800037406177867,0.16690052907551575},
{-0.9999616572053677,-0.008699666417686698,-0.0009999616572053678},
{-0.9405719431573971,-0.05389839223493909,0.33528999844851715},
{-0.9544952991222277,-0.22459889385317167,0.1961990337221384},
{-0.9788565690975223,0.0907959714721167,-0.18329186752025317},
{-0.8172682456592105,0.1518940982694654,-0.555878401764291},
{-0.9297159447651803,-0.23250398747757817,-0.2856048981660057},
{-0.9931799925905719,-0.09569807218175365,-0.06659865838354016},
{-0.9919212223815816,-0.09380200691540716,-0.08540182719163936},
{-0.7004077255398193,0.3007033167758762,-0.6473071398371288},
{-0.7635255823532122,-0.008500284806813758,-0.6457216352658405},
{-0.8051757082153191,-0.02989909795782171,-0.5922821311176522},
{-0.521724195520614,-0.4720218905227712,-0.7106329563675451},
{-0.3700924020809771,-0.40039178004113274,-0.8382827902309731},
{-0.23090944669870062,0.10640435309112925,-0.9671395664890141},
{-0.0,0.16859743312362088,-0.9856849930602202},
{0.23090944669870062,0.10640435309112925,-0.9671395664890141},
{0.37012342770380824,-0.4004253457244118,-0.8382530589065984},
{0.521724195520614,-0.4720218905227712,-0.7106329563675451},
{0.7861215950568283,0.187905161825694,-0.588816175002494},
{0.8051757082153191,-0.02989909795782171,-0.5922821311176522},
{0.8240816932285253,0.5288882508780087,-0.20289549272669308},
{0.7635255823532122,-0.008500284806813758,-0.6457216352658405},
{0.6971978665777924,-0.42919868665402827,-0.5741982429560648},
{0.7004077255398193,0.3007033167758762,-0.6473071398371288},
{0.991930522171758,-0.09370288328207857,-0.08540262787929039},
{0.9134834341281317,0.0938982971698211,-0.3958928205487984},
{0.9750478272689201,0.2143105121884406,0.05790284020396972},
{0.9931799925905719,-0.09569807218175365,-0.06659865838354016},
{0.9999607823071618,-0.008799654884303024,-0.0009999607823071618},
{0.7235295676399347,-0.6479264780565497,-0.2381097305529626},
{0.9405288652738196,-0.05390165426715458,0.3354102938998821},
{0.954476567887884,-0.22459448627304215,0.1962951810124585},
{0.6853931700910898,-0.13739863082946563,0.7150928741350135},
{0.8660139732481885,-0.2647042710378701,0.42420684463265773},
{0.9756274545428617,-0.10440293794001103,-0.1930054312492541},
{0.4278073134285351,-0.7841134045332268,-0.44960768610909163},
{0.6135874277224076,-0.5780881550950517,-0.5378889787677363},
{0.5598172034469969,-0.552516979107656,-0.6175189766497332},
{0.6129934747191922,-0.05019946562953255,-0.7884916065515222},
{0.5478723304066616,-0.20458966745976082,-0.8111590334474975},
{0.3887077567406794,0.05980119334471991,-0.9194183471761788},
{0.2571902989648811,-0.308588360266572,-0.9157654579783753},
{0.016299535632844635,-0.37228939362626123,-0.927973562409805},
{-0.2629019586268877,-0.22380166732863244,-0.9385069919031347},
{-0.26869229132874106,-0.5419844506891613,-0.796277155136124},
{-0.5507076383679167,-0.203102817055609,-0.809611229385628},
{-0.5574734927656134,-0.5573734975202743,-0.6152707445716268},
{-0.42629741238256025,-0.7841952399493403,-0.45089726306191985},
{-0.6870009171468366,-0.5303007079519176,-0.4968006632293281},
{-0.9006366476508045,-0.34011383951370044,-0.27051100731683614},
{-0.9756172637002231,-0.10450184917658191,-0.1930034152256489},
{-0.9380163872894303,-0.14650255942206986,0.31410548747079964},
{-0.6853931700910898,-0.13739863082946563,0.7150928741350135},
{-0.9750499324714186,-0.09899491674153466,0.1986897975408377},
{-0.8660618897850415,-0.2645883570455167,0.42418133431106647},
{-0.9305099983836492,-0.36350390587045295,-0.04490048245827604},
{-0.9974703256992091,0.0268991997607105,0.06579804253735133},
{-0.9434245010524426,-0.082702147802668,-0.3211083392918585},
{-0.9686142338907514,-0.04310063336846106,0.24480359741529623},
{-0.9663045706314287,0.00030000141901006784,-0.25740121751063827},
{-0.9707513811345833,0.17829107051534424,0.16079194693700144},
{-0.9345194662432249,-0.21970457649399305,-0.2800058325822397},
{-0.588294643601655,0.05759947555916255,-0.8065926560073005},
{-0.6231068199414665,-0.5401059114915521,-0.5657061916881522},
{-0.37842515475608274,-0.2707179952232336,-0.8851588384635539},
{-0.687838478760783,-0.11780659028499599,-0.7162400675901028},
{-0.6057102093316181,0.02740046183867647,-0.7952134034348732},
{-0.7747931469849223,-0.16279856005310447,-0.6108945966611887},
{-0.6728780880818367,-0.17159441211895254,-0.7195765673706191},
{-0.6181069382893237,-0.10750120670781799,-0.7787087410546778},
{-0.22570505020699821,-0.6480144994866408,-0.7274162761212694},
{-0.46259654441671977,-0.10529921341781365,-0.8802934242326813},
{-0.24760792234221501,-0.13050417554789606,-0.9600307166741778},
{-0.0,-0.11589549754737874,-0.9932614125436695},
{0.24760792234221501,-0.13050417554789606,-0.9600307166741778},
{0.46259654441671977,-0.10529921341781365,-0.8802934242326813},
{0.22569042415845014,-0.6480725028670427,-0.7273691383821739},
{0.6181002905072048,-0.10760005057203566,-0.778700365989258},
{-0.9567533833270685,0.2560875224394463,-0.13799327644140413},
{-0.7716730343569634,-0.6069787894967951,0.18999336079800835},
{-0.8971953345963901,-0.4039978992163861,-0.17839907232723584},
{-0.9202235396192191,-0.3008076947592492,0.25040640547777926},
{-0.9662803412264347,-0.05919879561275477,0.2505949016985869},
{-0.9520303702532243,-0.27480876653948116,-0.13460429394546639},
{-0.9822217859208202,0.15020333154684098,0.11260249755109383},
{-0.9328302568400789,-0.34751127171089985,0.0952030879622379},
{-0.7959833163645317,-0.5963874998490034,0.1035978286122682},
{-0.9983325012436256,-0.03640118505986975,-0.04480145853522431},
{-0.9119720484850644,0.07309775958800242,0.40368762716383827},
{0.6337020595350402,0.7466024264618291,0.2025006581282084},
{0.8029950013716748,-0.43889726787301125,-0.40319749010343614},
{0.7514661133996571,-0.5512751408080253,-0.3624836541681646},
{0.9526797891126588,0.29829367176687954,-0.0584987589619928},
{0.4908840416192062,0.7613752480930202,0.4234862326863594},
{0.5797037043185059,0.7488047848778632,0.32130205312667925},
{0.588294643601655,0.05759947555916255,-0.8065926560073005},
{0.9663045706314287,0.00030000141901006784,-0.25740121751063827},
{0.9305099983836492,-0.36350390587045295,-0.04490048245827604},
{0.9297159447651803,-0.23250398747757817,-0.2856048981660057},
{0.8172350356169815,0.15190651237178107,-0.5559238329655898},
{0.9788656130550094,0.09089680685126197,-0.18319356452311547},
{0.9567778795511342,0.2559940814852533,-0.13799680955064436},
{0.9707126872977351,0.17840233173371375,0.1609021030042295},
{0.9345582915941484,-0.21969019544536103,-0.2798875088992105},
{0.6231068199414665,-0.5401059114915521,-0.5657061916881522},
{0.77480575682816,-0.16270120887447292,-0.6109045390375876},
{0.6728780880818367,-0.17159441211895254,-0.7195765673706191},
{0.6878911640947455,-0.11779848688815385,-0.7161908005882494},
{0.6057085466078894,0.027500388033212742,-0.7952112205094827},
{0.3783916584478333,-0.27069403261582575,-0.8851804864112632},
{0.9686142338907514,-0.04310063336846106,0.24480359741529623},
{0.9434245010524426,-0.082702147802668,-0.3211083392918585},
{0.9974703256992091,0.0268991997607105,0.06579804253735133},
{0.8576033746759191,-0.502101975775162,-0.11140043836158743},
{0.9211965501253797,-0.349898689631861,0.17019936260458057},
{0.9512471069231311,-0.04960245637446099,0.3044150750077808},
{0.8136946214963279,0.4356971200515547,-0.38479745649721886},
{0.941533566269967,0.21690773289851922,0.2578091910614949},
{0.9072824941531613,-0.42029189054620714,-0.013899731807262143},
{0.8730923430137275,-0.41929632278737367,0.24879781805270348},
{0.7709338987088057,-0.4246186708934478,0.4747208739357505},
{0.8348723119189051,-0.04759842142452975,0.5483818132187418},
{0.7392739447489678,0.18259356460322135,0.6481771553987299},
{0.7566640668766758,-0.35968291906375083,0.5459740723069446},
{0.42151056740238885,-0.03810095520292056,0.9060227142741739},
{0.6710676788036068,0.13839333444556576,0.7283649191484834},
{0.5338216148747883,0.5123207442869128,0.6727272392773886},
{0.5748996838052608,0.2502998623351136,0.7789995715503535},
{0.8138217740928527,-0.24570657396733092,0.5266140897484594},
{0.1779006991511215,0.0913003588111152,0.9798038506366995},
{0.545611520708891,-0.11850250220675142,0.8296175175588268},
{0.7366031600343348,-0.2781011930566773,0.6165026448020193},
{0.944856296682722,0.03789824705712262,0.32528495429240073},
{0.884711899455072,0.03100041695841215,-0.46510625572120945},
{0.8382753089644064,0.0198994138713965,-0.5448839506795956},
{0.9875508898085615,0.018500953378692037,-0.1562080496081998},
{0.9689759309368096,0.16479590652052242,-0.18419542464247712},
{0.8927127792749036,0.16120230762755064,-0.4208060238813481},
{0.8102624492569137,0.07859635753621302,-0.5807730846950703},
{0.7732298704468542,0.17630681086365804,-0.6091235308965065},
{0.45018216413597845,0.33238683109462286,-0.8287671648953774},
{-0.4865079058177048,0.8659140712179869,-0.11620188829602734},
{-0.2988117345672292,0.5439213602112315,-0.7841307934208983},
{0.029700363089158164,0.3989048766419256,-0.9165112044179615},
{-0.710186787097738,0.529390150787866,-0.4640913656604621},
{0.9948989006373221,-0.052399942098095974,0.08619990474915787},
{0.7716730343569634,-0.6069787894967951,0.18999336079800835},
{0.8971953345963901,-0.4039978992163861,-0.17839907232723584},
{0.7045879481262202,-0.4082930162076862,0.5803900725127139},
{0.4430071058909682,0.5156082704229868,-0.7334117640190431},
{-0.6419975443640893,0.4653982198552136,-0.6092976694408716},
{0.5233263606126928,-0.21661091096638496,0.8241415130535451},
{0.5776833918412234,-0.29139162261127316,0.7624780790703355},
{0.5936227183761567,-0.18010689282268502,0.7843300168841302},
{0.6824801708267008,-0.1424958598429375,0.716879171378259},
{0.802021105463089,-0.12710334476852694,0.5836153580402229},
{0.8484205659637815,-0.12800310283281946,0.513612450116688},
{0.900718095608313,-0.09580192468000043,0.4237085123895218},
{0.8713142766013842,-0.09050148287894556,0.4823079026797287},
{0.9366982483759132,-0.06579987695434514,0.34389935690880385},
{0.7463869532700842,0.17899687116203788,0.6409887956137782},
{0.38189431554541936,-0.22899659141110507,0.8953866722685742},
{0.3436111108449067,-0.17090552631954176,0.9234298595872724},
{0.42541703191181574,-0.16710669025026895,0.8894356092674398},
{0.0,-0.17879743874503481,0.9838859059353454},
{0.30989246815509114,-0.08259799248018887,0.9471769791432796},
{0.16409843368792565,-0.20079808339144103,0.9657907815709847},
{0.0,-0.23638985318332345,0.9716582924629248},
{-0.16409843368792565,-0.20079808339144103,0.9657907815709847},
{-0.30989246815509114,-0.08259799248018887,0.9471769791432796},
{-0.34331477143581834,-0.1709073534470765,0.9235397361519903},
{-0.4256044390774495,-0.16730174496630004,0.8893092755441161},
{-0.5198109265405151,-0.21640454887142643,0.8264173714757246},
{-0.6822754555819702,-0.14249487383911877,0.7170742037195234},
{-0.5910947570127577,-0.18029840076027784,0.7861930264987823},
{-0.8024841831926224,-0.1265975047877707,0.5830885074387765},
{-0.8484205659637815,-0.12800310283281946,0.513612450116688},
{-0.9006799285714352,-0.09579786516836182,0.42379055593269044},
{-0.8713142766013842,-0.09050148287894556,0.4823079026797287},
{-0.9366215378598974,-0.0658015131231916,0.34410791285243514},
{-0.38079937358554566,-0.22959962230893194,0.8956985265771357},
{-0.7534118851662335,0.1883029705027897,0.6300099384851701},
{-0.5725074941721483,-0.29260383020920633,0.7659100258278575},
{0.67969179616953,-0.23659714428970255,0.6942916199507205},
{0.785457625704109,-0.2533863301762206,0.5646695369002042},
{0.7378044563523746,-0.29280176852802287,0.6082036735612825},
{-0.7098902213295514,-0.2276968634973079,0.6664908191521989},
{-0.7518724744525562,-0.21439215124701164,0.6234771749184318},
{-0.67969179616953,-0.23659714428970255,0.6942916199507205},
{0.7347015061396314,-0.24910051065657024,0.6310012935539776},
{0.7424888516135889,-0.21829672229932182,0.6332904912146611},
{0.7517239728597479,-0.21420683116477052,0.6237198907444789},
{0.7378786534793278,-0.23719313810177062,0.63188171992626},
{0.736929120329546,-0.23440926286503677,0.6340250539950227},
{0.75998961481287,-0.206697175502395,0.6161915797995926},
{0.7565088020311177,-0.24880289483852228,0.604807036970813},
{0.7408968511950735,-0.29369875178295735,0.6039974330163644},
{0.7098902213295514,-0.2276968634973079,0.6664908191521989},
{0.5986094551110158,-0.26220414154712385,0.7569119555187569},
{-0.5986094551110158,-0.26220414154712385,0.7569119555187569},
{-0.7378044563523746,-0.29280176852802287,0.6082036735612825},
{-0.7408968511950735,-0.29369875178295735,0.6039974330163644},
{-0.7565088020311177,-0.24880289483852228,0.604807036970813},
{-0.7599473689958103,-0.20671288481567834,0.6162384113373053},
{-0.736929120329546,-0.23440926286503677,0.6340250539950227},
{-0.7378961518816018,-0.23709876353317225,0.6318967046672777},
{-0.7855019755399527,-0.25340063730340423,0.5646014199743569},
{-0.7423953192122685,-0.2185986217400349,0.633296007081263},
{-0.7347938791924794,-0.24909792502292682,0.6308947446686654},
{0.6757954924590979,0.2610982584804239,-0.6892954024149989},
{0.4060840432410251,-0.6486745108358852,-0.6436747072993053},
{0.5868006308110172,0.21560023177037374,-0.7805008390388529},
{0.8476873737906003,0.020699691680388613,-0.5300921043369083},
{0.8668956872046842,0.17029915276382251,-0.4684976692298934},
{0.6562059682204217,-0.4816043802117571,-0.5809052833575783},
{0.5544041663629654,0.5460041032362538,-0.6281047202247088},
{0.6893832964450883,0.37909081474083695,-0.6172850433645968},
{0.4695931205111764,0.5016926502565102,-0.7264893570088792},
{0.5149919533135938,0.1959969375717755,-0.8344869612430952},
{0.30599351759599386,0.2173953945273499,-0.9268803642474729},
{0.08920307577507999,-0.06880237234669848,-0.9936342610999943},
{0.7711061148957368,-0.21220168276601653,-0.6003047604356254},
{0.8054401401095985,-0.2654132271977743,-0.5299264095406957},
{-0.1639978221233832,0.6115918781137877,-0.7739897214847475},
{0.06380318864403071,-0.37691883698957956,-0.9240461803618242},
{0.5269957919554019,-0.31359749593399244,-0.7898936927240454},
{0.6356251045092637,-0.3063120980352226,-0.7086279878150791},
{0.5318022442102059,-0.5236022096059868,-0.66560280884978},
{0.3751984842011857,-0.5709976931739793,-0.7301970500098769},
{0.5711758226391307,-0.6578721528611415,-0.49087922152232005},
{0.34359147731910633,-0.669683388709562,-0.6583836689956333},
{0.16360471024741302,-0.251507240997704,-0.9539274639670371},
{0.12350040137695671,-0.4115013373815197,-0.9030029347643069},
{-0.2804963283270932,-0.3896948989271594,-0.877188517677455},
{-0.05649990027776402,-0.4317992378750178,-0.9001984111512066},
{0.35669269144162774,-0.32469334710147607,-0.875982051311651},
{0.8268403838705465,0.04980243241019982,-0.5602273621725691},
{0.72597621740867,-0.19539359901054287,-0.6593783991174615},
{-0.18469912268125088,-0.23209889753285506,-0.9549954637823205},
{-0.1997070957191686,-0.23910849567577971,-0.950233762405378},
{0.26889082963463024,-0.25219139915899497,-0.9295682976138054},
{0.5758086487108559,-0.2264034006046158,-0.7856117999778542},
{0.6237180943243783,0.25020725861786025,-0.7405214828398303},
{0.3498066166547316,0.27930528310939545,-0.8942169142729017},
{0.660218341120278,0.6726186856066328,0.33420928446288534},
{0.6280872782210181,0.5252893603717573,-0.5740883719577877},
{0.22669575856203558,0.2542952421805278,-0.94018240935168},
{0.836193021998347,0.10649911126862467,-0.5379955104461979},
{0.010699629692224417,0.03679872641811763,-0.9992654160224169},
{-0.36418771069305045,-0.06479781343467783,-0.9290686491073947},
{0.21989313394408724,-0.13619574735418224,-0.9659698380627023},
{-0.24488916266990376,0.013499402597156802,-0.969457097625446},
{-0.16449853843697892,0.19259828877180632,-0.9673914047655527},
{0.19599239564257076,0.07719700481431868,-0.9775620713274344},
{0.167194320505397,0.19089351545741798,-0.9672671424932449},
{0.11760533234665564,0.38201732105801406,-0.9166415614706169},
{-0.016500565154034953,0.3426117346528712,-0.9393321726778807},
{0.2795059968654948,0.15700336854340852,-0.9472203228300418},
{0.08949965497949507,0.06449975135393779,-0.9938961685376553},
{-0.14060259976610476,0.3315061296050052,-0.9329172497994247},
{-0.2432080746421194,0.4400146087275187,-0.8644286995092434},
{0.23670902115269746,0.41171569078396936,-0.880033538717253},
{0.18199621269822022,0.8558821892769598,-0.48408992619345276},
{0.4815139881845381,0.3283095375305999,-0.8126236070586826},
{0.30879387050250523,0.7124858572960977,-0.6300874928873981},
{0.2136019608750013,0.7102065197257768,-0.6708061580287962},
{0.5081731335966213,0.0962949090227364,-0.8558547521553487},
{0.5711042775870588,-0.33590251591926634,-0.7490056100730292},
{0.28660668374579834,-0.9456220521633877,0.1538035867414647},
{0.685730546547559,-0.06290280206772855,-0.7251323017378374},
{0.37449222936686005,0.28019418603095914,-0.8838816596458414},
{0.562098386779945,0.18419947134827583,-0.806297685928962},
{0.7701958216990009,0.40159782133772887,-0.49549731193437413},
{0.21640966940004802,0.30981384279175084,-0.9258413675164715},
{-0.25180791066977254,-0.09370294372421639,-0.9632302603539511},
{0.6047294843047785,-0.08540416398152487,0.7918386070324518},
{0.8448429824801283,-0.03850195883698501,0.5336271489718234},
{0.885292466193169,-0.12579892945566548,0.4476961901216331},
{0.6469915341711627,-0.13139828066474618,0.7510901720493978},
{0.8163361114266011,-0.20220894491052152,0.5410239327230077},
{0.8642279971194573,-0.40541313357119646,0.2979096509394658},
{0.9555193351293715,-0.2702054676629578,0.11820239184959885},
{0.9055912339192832,0.19319812985115453,0.37759634488507215},
{0.9847313297256408,-0.08520271076736528,0.15180482974748882},
{0.9747760110575482,-0.16029605516262307,0.15529617820808087},
{0.8702246102999739,-0.15140428177363371,0.4688132582264166},
{0.7377087714094384,-0.1817021604515317,0.6502077310158829},
{0.617605715967352,-0.23580218235929665,0.7503069441229019},
{0.47448602659227224,-0.159595299987622,0.8656745062611804},
{0.2891848572314163,-0.07969582683728864,0.953950047713593},
{0.31878522624102684,-0.06699689510084317,0.9454561838484659},
{0.500713632114204,-0.21250578554876842,0.8391228454304545},
{0.4903138000761075,-0.027100762761702042,0.8711245181445996},
{0.5087937698584319,-0.1651979771631544,0.8448896543895227},
{0.7397078816294684,-0.36020383799234085,0.5684060563987966},
{0.7432168080381728,-0.6402144786141526,0.1943043942435643},
{0.9026247864169572,-0.4206115501517529,-0.0914025099473852},
{0.986573126114062,-0.13859622469025845,-0.08639764656016112},
{0.9897113520543125,0.14240163335610195,-0.013900159435743097},
{0.9871663184598113,-0.13339544862493802,-0.08779700441731304},
{0.9699056982127156,-0.23320137006207367,-0.07000041125362418},
{0.9603110772521646,-0.21720250544535055,0.17500201865992793},
{0.5667307544788603,-0.14330777680751844,0.8113440287783649},
{0.5929259203231728,-0.38541684886583033,0.7070309085317644},
{0.41530612581053394,-0.19960294416513982,0.8875130909146373},
{0.18199472495934446,-0.24389293086584682,0.9525723900894041},
{0.3173153616084922,-0.3385163879750224,0.885842884692097},
{0.37470372832064525,0.11400113431692972,0.9201091551316406},
{0.6116000917400206,-0.12330001849500416,0.7815001172250263},
{0.8065163966450174,-0.2822057373009596,0.5195105617570819},
{0.9876040244945997,0.032800133660817,-0.15350062551632346},
{0.8820037661641223,-0.3011012857052349,0.36250154788491423},
{0.8998270447082491,-0.1912057467750803,-0.3921117850968043},
{0.9211865830151268,-0.29129575730819196,-0.2579962423120959},
{0.9736172088362506,-0.08000141403748978,0.21370377724764456},
{0.9630680363023041,-0.23389223724546665,0.1333955726744132},
{0.9915782202235865,-0.05359882271478846,-0.11789741041182014},
{0.9726594944387635,-0.18299237944103394,0.1429940451369828},
{0.831844667098632,-0.46242483056793393,0.3069164803228783},
{0.9028168783193118,-0.4169077941640685,-0.10540197050825814},
{0.32979123261661974,-0.3071918334136616,0.892676268516848},
{0.6192013467643938,-0.37500081562766097,0.6899015005373955},
{0.7996455730998534,-0.5519314554699963,0.2365134792872878},
{0.7094765202630863,-0.7036767122045579,0.03849872590574887},
{0.826267334166653,-0.5632777312550836,0.000699972327141059},
{0.6406933528409463,-0.21009782024642237,-0.738492338181737},
{0.7837709461495295,-0.34608717078636403,-0.5156808840639351},
{-0.0011999829303642223,-0.10099856330565539,0.9948858478494708},
{0.10609467099851026,-0.10729461072705138,0.988550346363122},
{0.1784031524115549,-0.1509026664736751,0.9723171809963836},
{0.15589533100475358,0.0024999251283635915,0.9877704167190223},
{-0.001200045482585701,0.15800598854045067,0.9874374245876013},
{0.003200117430463706,-0.1186043522665611,0.9929364364710668},
{0.23819420123275564,-0.21519476114730904,0.9470769436924554},
{0.0965035639424258,0.06300232671888939,0.993336684601156},
{-9.999499737541882e-05,-0.2326883588925996,0.9725513444733235},
{-0.026598769037452764,-0.24658858814420498,0.9687551670482796},
{0.0,-0.334200686783117,0.9425019368434703},
{0.011600432182151569,-0.06470241053320745,0.9978371751164514},
{-0.011999973120090317,-0.11919973299289714,0.9927977761354722},
{0.17600598694547065,-0.06660226551459288,0.982133407836061},
{0.005600255349464121,0.008800401263443619,0.9999455935587811},
{0.10319968524144,-0.04809985329567116,0.9934969698388628},
{-0.056797993646311044,0.14039504063278294,0.988465083087649},
{-0.13600242018460096,-0.12400220663890088,0.9829174911723845},
{0.12109609895200739,-0.1068965563829033,0.986868208552734},
{-0.1039020775428109,-0.1272025434402844,0.9864197236595638},
{0.07499736388898814,-0.11029612315940523,0.991065164671682},
{-0.06540260634579535,-0.13750547970255142,0.9883393861093203},
{0.10529946613306006,-0.23979878422324596,0.9650951069802113},
{-0.001199955398486742,-0.19469276340447392,0.9808635419797044},
{0.9954410727460098,-0.013600561170731097,-0.09440389518507467},
{0.960189217135637,-0.011899866365251073,0.27909686575979614},
{0.8364723048604716,-0.25209165338353245,0.4865838894741249},
{0.9885701604600529,0.15039546038154153,0.010499683071849642},
{0.9608504411678984,0.21011103006804274,0.18060948134359125},
{0.5411822711591905,0.10619652105895422,0.8341726729508439},
{0.5233907648514305,-0.12219784383806806,0.8432851203653257},
{0.5931726286805598,-0.1220943660854625,0.7957632803506228},
{0.9424230236757061,-0.3303080695247089,0.05230127773582282},
{0.8363726803325882,-0.5318826263377614,-0.1325956688332152},
{0.7177149178596032,-0.626713026365631,-0.3035063084441822},
{0.4702879349177925,-0.686082398781836,-0.5550857594575094},
{0.09370155124202133,-0.7496124099361706,-0.6552108471053615},
{0.5060049335721536,-0.8127079239408878,-0.288902816816196},
{0.5261061528474366,-0.35580416115399716,-0.7724090333764683},
{0.8488218913988724,-0.4523116652682728,-0.27370705899607845},
{0.8414861871176067,-0.16429730308190468,-0.5146915514075249},
{0.6835882833972331,-0.24759575624510666,-0.686588231978555},
{0.9918045970249608,0.008200038007264246,0.1275005909666087},
{0.9986933137706463,-0.04969966726184152,-0.011899920330300082},
{0.9898288588810771,-0.09510277276176039,-0.10580308473390378},
{0.6342989312072013,0.47079920670400505,0.6131989667606115},
{0.9443947255701864,0.26899849764758593,0.18909894388534756},
{0.7574579357415254,0.2860841127599346,0.5868674092233681},
{0.4489116943019569,0.07380192256512456,0.8905231984314826},
{0.9305531035280724,0.1781101641465338,0.31991825665623896},
{0.9859651319596515,0.014799476625763534,0.16629411911246456},
{0.9654870915238788,-0.18679750253408656,0.18149757339366546},
{0.9020962743500804,-0.36309850040629,-0.2331990368899665},
{0.7479895581386521,-0.4945930955285793,-0.4425938214333789},
{0.535794671548487,-0.5963940688904772,-0.59769405596217},
{0.2646059417931352,-0.7167160940405896,-0.6452144884540092},
{-0.0894998769377538,-0.7234990051895517,-0.6844990588144411},
{0.16399482358508902,-0.3791880311186936,-0.9106712551154912},
{0.4042971962086664,-0.3716974222873146,-0.8356942044807878},
{0.4408990278187155,-0.40019911756191867,-0.8033982285088592},
{0.9410706484642045,0.20709354085318962,0.26739166018417626},
{0.8048535653130352,0.21368767164541638,0.5536680570428968},
{0.8724642951293178,-0.0615974791747461,0.48478016077787195},
{0.9624947929172556,-0.022099880439970233,0.27039853714787104},
{0.9611978757550418,-0.2742993937990095,-0.02929993524721465},
{0.9678414777353116,-0.1368058629408872,-0.21110904727208543},
{0.940353538279482,-0.06209693186639285,-0.33448347357984554},
{0.9186738227623753,0.30609127805329606,0.2496928851026071},
{0.5649369452595924,0.2306150815664047,0.7922518110013261},
{0.5466125476350481,-0.583813401590452,0.600313780360994},
{0.525000866252144,-0.7329012092879931,0.43270071395676707},
{0.7910083926435693,-0.4037042833251693,0.45970487749462546},
{0.9154913120286732,-0.24229770060573183,0.32119695185539027},
{0.9756717937361588,-0.03579896506687966,0.21629374703815837},
{0.9292657246658569,-0.27178997521164305,-0.2501907718835654},
{0.8173072985867648,0.26020232361712486,0.5141045909744962},
{0.7563848686720518,0.13479730340691776,0.6400871951837392},
{0.9531427923062624,0.2556114759348239,0.16180726450021327},
{0.9855182815336853,0.14470268425968974,-0.0884016398656294},
{0.9768290659812938,-0.16970504964887956,-0.13040388022518498},
{0.8280948906702869,-0.35519780843628296,-0.4336973240957655},
{0.5524218293798905,-0.39051543152217094,-0.736429100570875},
{0.16710278980436388,-0.08560142912778904,-0.982216398239654},
{0.07149855967602284,-0.3101937512098222,-0.9479809031170581},
{-0.35880565302759554,-0.45480716554334016,-0.8151128422039943},
{-0.2711891472274876,-0.46858124775368987,-0.8407663532038038},
{0.08629933247724493,-0.3616972022829605,-0.9282928196828095},
{0.026599162671538442,0.09019716063807397,-0.9955686599918674},
{0.5367813364373926,0.06929759056466338,-0.8408707634318244},
{0.6293065385289032,0.4108042682785213,-0.6597068543898259},
{0.6542866330606285,0.5238892970509909,-0.545388857819451},
{0.9257927140400106,-0.015899874868477177,-0.37769702753608986},
{0.8130660552007782,0.32578639870177534,0.4824798568864537},
{0.8667330881672233,0.08760334432150543,0.4910187449983923},
{0.7386890342426795,-0.024799631852197714,0.6735900006306604},
{0.7527392262631475,0.32931716116441406,0.5700297050219132},
{0.7153892120120237,0.45299316891451874,0.5319919776214658},
{0.5754934537991944,0.44009499394791557,0.6892921593462809},
{0.4366982073575382,0.4273982455338032,0.7915967505020088},
{0.39429510682808616,0.5432932577725063,0.7411908018792226},
{0.16249780466948827,0.5418926790793581,0.8245888598797539},
{0.23219576710974804,0.6460882219190707,0.727086745329448},
{-0.12489993942354408,0.829999597450293,0.5435997363541919},
{0.08089648188850235,0.9708577783133118,0.22559018929599664},
{0.2775077564501907,0.7848219360796744,0.5541154877443267},
{-0.1116987679693839,0.727091980219687,0.6773925284016173},
{0.17010098488755376,0.530403071042672,0.8305048086367631},
{0.21599621469950575,0.5895896675316139,0.7782863606510432},
{-0.03370128690821136,0.641324489443203,0.7665292704790505},
{-0.047400643468102646,0.7360099914034504,0.6753091673841712},
{0.0,0.6713975930439435,0.7410973431707871},
{0.0,0.7461611707829824,0.6657653544724064},
{0.08810072110735341,0.8841072364473457,0.4589037561426161},
{-0.013800210316807855,0.9772148928684519,0.21180322790579012},
{0.1114014031095083,0.9807123521498635,0.16060202279521574},
{0.1650931240145742,0.9759593521394574,0.1422940735752508},
{0.09940138765305752,0.969413533107384,0.22440313268959866},
{0.5238911960824242,0.8295860589234187,-0.19319675335583958},
{0.47691365423338383,-0.2127060898625304,0.8528244167125807},
{0.18559661289272178,-0.4234922713365715,0.8866838181679764},
{0.5418204351430743,0.2718102515169576,0.795329996436484},
{0.1994982105090776,0.08399924653013793,0.9762912427068292},
{0.18399448668780835,0.34928953369593185,0.9187724693954256},
{-0.1798047424126225,-0.16640438897363952,0.9695255715741798},
{0.21440672282819306,-0.005200163053668862,0.9767306258689187},
{0.053899026053398746,0.22579591990459066,0.9726824237874019},
{-0.23339053853934755,0.19139224111581457,0.9533613515141987},
{-0.29440246710301154,0.41720349617994706,0.8598072052145697},
{0.22620038906500378,0.2576004430731431,0.9394016157721686},
{-0.22350079342922502,0.4172014810678867,0.8809031272116524},
{-0.2327995041375843,0.26009944598877005,0.9370980039833774},
{-0.0012000384438473326,-0.08320266544008173,0.996531924411556},
{0.2954893478010142,-0.06879751989411093,0.9528656498124753},
{0.13699553401838532,-0.1611947451369614,0.9773681383180277},
{0.22969137065730355,0.00039998497284684994,0.9732634351795977},
{0.3255145264098688,-0.095104244121593,0.9407419815476608},
{0.28169449433491184,-0.2663947933646451,0.9217819839471839},
{0.33499237566029394,-0.3813913196323466,0.8615803906534605},
{0.31350139038174957,-0.40220178376886656,0.8602038150123794},
{0.38688436825289474,-0.2493899236037011,0.8877641306149392},
{-0.2126009683996166,0.6338028869787253,-0.7437033875766457},
{0.14389509254155186,0.6799768097863466,-0.718975479759387},
{-0.6198032074898981,0.5769029854806748,-0.5320027531213711},
{0.24829416639708993,0.6082857084951663,-0.7538822877437218},
{0.5781001907730944,0.679800224334111,-0.4513001489290737},
{0.508121580381788,0.7384313618459205,-0.44331882815045587},
{-0.5480029126432211,0.30110160035925887,-0.7804041478590689},
{-0.4655047248969367,0.39480400728101095,-0.7921080399374082},
{0.0,0.41700245823673693,-0.9089053580128783},
{0.0,0.5212882059877578,-0.8533806924802465},
{0.44611445211176803,0.48861582896617317,-0.7498242909513645},
{0.0,0.5854869028044748,-0.8106818652495092},
{0.5852200470560738,0.11810404572338055,-0.8022274807730388},
{0.0,-0.20009519277073987,-0.9797764611532779},
{-0.41469507137836487,0.37479554558141104,-0.8291901451336874},
{-0.06210182550999169,-0.11320332766072558,-0.9916291493672748},
{0.02120002915006012,0.02340003217506636,-0.9995013743153345},
{-0.3324012863954675,0.6435024903594565,-0.6895026683804899},
{0.000400006302148936,0.9952156797465526,-0.0977015392998776},
{-0.6369133434743202,0.28070588084980636,-0.7180150425727145},
{-0.6196282494958565,0.12710579488528623,-0.7745353118698206},
{-0.23080734671477077,0.3333106094455507,-0.9141290971922529},
{-0.393580789790464,0.3324837718631334,-0.857058168011704},
{-0.23520451949826365,0.366207036735817,-0.900317299763124},
{-0.5647923979454852,-0.04879934316526147,-0.8237889118758688},
{-0.6686295005843631,0.4478197582436102,-0.5936261913653574},
{-0.1206995208238535,0.514097959035154,-0.8491966286960762},
{-0.39540280341581435,0.7721054742472186,-0.497503527312513},
{-0.6227070335156656,0.722408159646245,-0.3006033953345255},
{-0.9086339562854314,0.3643136146541742,-0.2041076276445703},
{-0.8687181259928003,-0.13230276052589784,-0.4773099591761984},
{-0.6653097036127913,0.49450721244029056,-0.5593081575689677},
{-0.818371795302104,0.33058860646001414,0.4700837988410546},
{-0.5638171487593732,0.742722590251129,0.36121098639922955},
{-0.41280303411345115,0.3775027746555906,0.8289060924821697},
{-0.554374230512828,-0.025998791474266824,0.8318613318247143},
{-0.42858647188151916,0.5630822265900222,0.7065776972269749},
{-0.47288896762907634,0.7555823724688732,0.4532894248810749},
{-0.831844667098632,-0.46242483056793393,0.3069164803228783},
{-0.9028168783193118,-0.4169077941640685,-0.10540197050825814},
{-0.9876040244945997,0.032800133660817,-0.15350062551632346},
{-0.986573126114062,-0.13859622469025845,-0.08639764656016112},
{-0.9897113520543125,0.14240163335610195,-0.013900159435743097},
{-0.8820037661641223,-0.3011012857052349,0.36250154788491423},
{-0.32970210680319373,-0.30720196302681557,0.8927057044076768},
{-0.8364723048604716,-0.25209165338353245,0.4865838894741249},
{-0.9726594944387635,-0.18299237944103394,0.1429940451369828},
{-0.9026247864169572,-0.4206115501517529,-0.0914025099473852},
{-0.9555193351293715,-0.2702054676629578,0.11820239184959885},
{-0.9055912339192832,0.19319812985115453,0.37759634488507215},
{-0.9847313297256408,-0.08520271076736528,0.15180482974748882},
{-0.9871663184598113,-0.13339544862493802,-0.08779700441731304},
{-0.8998813501522751,-0.19119603750318367,-0.3919918760525523},
{-0.826267334166653,-0.5632777312550836,0.000699972327141059},
{-0.7094765202630863,-0.7036767122045579,0.03849872590574887},
{-0.799626655998874,-0.5519183985064764,0.23660788745539468},
{-0.6190969633368423,-0.37499816063853314,0.6899966155749009},
{-0.5228025277563325,-0.12320059567632013,0.8435040783520782},
{-0.959693963543954,-0.013999911940830839,0.2806982344136583},
{-0.9954362544485925,-0.009000327797907708,-0.09500346008902581},
{-0.9915782202235865,-0.05359882271478846,-0.11789741041182014},
{-0.9630680363023041,-0.23389223724546665,0.1333955726744132},
{-0.7431836612868079,-0.6402859234687072,0.19419573065379186},
{-0.8642279971194573,-0.40541313357119646,0.2979096509394658},
{-0.885292466193169,-0.12579892945566548,0.4476961901216331},
{-0.8447978964558567,-0.03849990413535805,0.5336986710919635},
{-0.9747608690103545,-0.16029356514398832,0.15539376184264372},
{-0.9699056982127156,-0.23320137006207367,-0.07000041125362418},
{-0.9212103452502661,-0.29130327135410605,-0.2579028962657877},
{-0.7837709461495295,-0.34608717078636403,-0.5156808840639351},
{-0.6406933528409463,-0.21009782024642237,-0.738492338181737},
{-0.5261061528474366,-0.35580416115399716,-0.7724090333764683},
{-0.5060049335721536,-0.8127079239408878,-0.288902816816196},
{-0.09370155124202133,-0.7496124099361706,-0.6552108471053615},
{-0.4702879349177925,-0.686082398781836,-0.5550857594575094},
{-0.7178083804617631,-0.6266073156831162,-0.3035035434245543},
{-0.8364171634562929,-0.5318109128718994,-0.13260272103575374},
{-0.9424279481152082,-0.33030979548222966,0.052201548059861914},
{-0.5934256009326483,-0.12300530656339018,0.7954343157765899},
{-0.45288935948949677,0.10569751666601855,0.8852792006095196},
{-0.5599952288609751,0.11699900317273942,0.8201930119853067},
{-0.9605505791224005,0.22101163767418067,0.168808888866071},
{-0.9886910326130011,0.14979864133248463,0.007099935603876108},
{-0.9736172088362506,-0.08000141403748978,0.21370377724764456},
{-0.8065163966450174,-0.2822057373009596,0.5195105617570819},
{-0.7397345242158866,-0.36011680704358623,0.5684265290851831},
{-0.8163361114266011,-0.20220894491052152,0.5410239327230077},
{-0.6469915341711627,-0.13139828066474618,0.7510901720493978},
{-0.6047294843047785,-0.08540416398152487,0.7918386070324518},
{-0.7377087714094384,-0.1817021604515317,0.6502077310158829},
{-0.8702246102999739,-0.15140428177363371,0.4688132582264166},
{-0.9603110772521646,-0.21720250544535055,0.17500201865992793},
{-0.8048535653130352,0.21368767164541638,0.5536680570428968},
{-0.6116000917400206,-0.12330001849500416,0.7815001172250263},
{-0.5929259203231728,-0.38541684886583033,0.7070309085317644},
{-0.5087937698584319,-0.1651979771631544,0.8448896543895227},
{-0.4910228208159084,-0.026601236321187705,0.8707404686036894},
{-0.5057063845834083,-0.21490271316388065,0.8355105483872606},
{-0.31819040829471074,-0.07479774525595338,0.9450715112486837},
{-0.2782973714937393,-0.07959924818865127,0.9571909593740828},
{-0.47448602659227224,-0.159595299987622,0.8656745062611804},
{-0.6176993390620609,-0.23589974758740512,0.7501991972872883},
{-0.9114349952184749,-0.35621367708670265,-0.2059079059858284},
{-0.945013891806315,-0.22680333403351563,-0.2356034633963681},
{-0.9557859404922223,-0.2936956797683257,-0.014699783767771151},
{-0.985148527334135,-0.12849328640117372,-0.11389404919139057},
{-0.9167543422242508,-0.11800699507195549,-0.3816226213513408},
{-0.9143161926831599,0.30600541940396686,0.26530469858781836},
{-0.948687297162136,0.25299661239803983,0.18969745996801643},
{-0.7503178165080819,0.26890638525792776,0.6039143401162611},
{-0.9147080769079788,0.19400171304268932,0.3545031302764606},
{-0.7621095188073352,0.14100176112299467,0.6319078925788677},
{-0.9408970973369319,0.25699920715866886,0.2205993194521492},
{-0.9177567700854938,0.07559643911360137,0.3898816350581108},
{-0.973089266884579,0.21689760763258165,-0.07779914188019756},
{-0.9570391054167873,0.2892118174362956,0.020800849940093184},
{-0.9397527081349146,0.3293834241962555,-0.09149539561007096},
{-0.8926974379620296,0.19579943805641917,-0.40589883507201496},
{-0.9894210699460291,0.029200621833863,0.14210302611616207},
{-0.6360212911690888,0.5176173275300634,-0.5723191587045118},
{-0.8984822731196254,0.10449793827601653,-0.4263915873769708},
{-0.9032815280816243,0.3834921576655628,0.19239606554068914},
{-0.9913571693387281,0.011399507494917794,0.13069435347243472},
{-0.9989631689069309,-0.044298366749326364,-0.010499612886409184},
{-0.9575720345170919,0.18329464695800224,0.22239350509252429},
{-0.9410706484642045,0.20709354085318962,0.26739166018417626},
{-0.8724642951293178,-0.0615974791747461,0.48478016077787195},
{-0.564892187595068,0.2305968108681584,0.7922890427183084},
{-0.3747079982275841,0.11390243127334355,0.9201196401633311},
{-0.41530612581053394,-0.19960294416513982,0.8875130909146373},
{-0.18199472495934446,-0.24389293086584682,0.9525723900894041},
{-0.2954893478010142,-0.06879751989411093,0.9528656498124753},
{-0.22399565452645287,-0.0041999185223709915,0.9745810933101829},
{-0.22449222933597,-0.09669665290328863,0.9696664355772388},
{-0.30939174553834214,-0.09699741214356557,0.9459747617300311},
{-0.27740721684262043,-0.26450688123602417,0.9236240283916519},
{-0.38688436825289474,-0.2493899236037011,0.8877641306149392},
{-0.9627162748561909,-0.020900353323459426,0.2697045593941152},
{-0.9164806578798209,-0.24199489275168212,0.3185932761598592},
{-0.7910083926435693,-0.4037042833251693,0.45970487749462546},
{-0.525000866252144,-0.7329012092879931,0.43270071395676707},
{-0.5466125476350481,-0.583813401590452,0.600313780360994},
{-0.31478988753729176,-0.33948909408802586,0.8863715257720945},
{-0.09620390018517186,0.0708028704065506,0.9928402505596531},
{0.026598769037452764,-0.24658858814420498,0.9687551670482796},
{-0.13699553401838532,-0.1611947451369614,0.9773681383180277},
{-0.019300346444328043,-0.09150164246922361,0.9956178715011915},
{0.23341279020426844,0.19141048862509416,0.9533522403673056},
{0.1798047424126225,-0.16640438897363952,0.9695255715741798},
{-0.032699558885925926,0.2139971131984143,0.9762868299794947},
{0.29440246710301154,0.41720349617994706,0.8598072052145697},
{0.00570006287204022,0.6216068563614388,0.7833086399419481},
{-0.2104982265599118,-0.002199981465234233,0.9775917638240845},
{0.001200045482585701,0.15800598854045067,0.9874374245876013},
{-0.003200117430463706,-0.1186043522665611,0.9929364364710668},
{-0.18559661289272178,-0.4234922713365715,0.8866838181679764},
{-0.1994982105090776,0.08399924653013793,0.9762912427068292},
{-0.18399448668780835,0.34928953369593185,0.9187724693954256},
{-0.16259975528755244,0.5419991842918415,0.8244987591303012},
{0.12480149762695733,0.8300099601792835,0.5436065233174199},
{-0.37169219826263683,0.8434822954924245,0.3877918603342765},
{-0.1672018651472086,0.6296070233055177,0.7587084634401148},
{0.046397930466466286,0.7354671952173698,0.6759698490373106},
{-0.08670238738310533,0.8852243749887525,0.45701258401475364},
{-0.01699943052861578,0.9977665753795779,0.06459783600873996},
{-0.15579350899866853,0.9786592250128171,0.1339944172389062},
{-0.10290461691920945,0.9719436072281793,0.2115094895861302},
{0.05120223528237294,0.9985435923720584,-0.01700074218360039},
{-0.47691365423338383,-0.2127060898625304,0.8528244167125807},
{-0.5418204351430743,0.2718102515169576,0.795329996436484},
{-0.4368137052450065,0.42741341030612584,0.7915248344812789},
{-0.39429510682808616,0.5432932577725063,0.7411908018792226},
{-0.2321976455278115,0.6461934476316614,0.726992628332123},
{-0.08110358080214038,0.9707428592433742,0.22600997856083505},
{-0.7386890342426795,-0.024799631852197714,0.6735900006306604},
{-0.8667254907715308,0.0877025793707895,0.4910144409470655},
{-0.7527577714734973,0.32938152221489114,0.569968025690613},
{-0.5755187794841669,0.44001435790275134,0.6893224929599239},
{-0.9605759042556588,-0.05049873325516424,0.2733931420190476},
{-0.7154272690300485,0.4530172670822085,0.5319202745276528},
{-0.8131052811359516,0.325802116091616,0.4824031332185254},
{-0.55246973377468,-0.3905786027373575,-0.7363596596410397},
{-0.16729576579775082,-0.08569783101534516,-0.9821751414617504},
{-0.7479895581386521,-0.4945930955285793,-0.4425938214333789},
{-0.9020962743500804,-0.36309850040629,-0.2331990368899665},
{-0.5358979823478947,-0.5963977545666811,-0.5975977500487065},
{-0.07150077721767256,-0.3101033708419617,-0.9480103049280222},
{-0.3706983633703385,-0.23049898234923938,-0.8996960278508055},
{-0.2932952677190327,-0.5136917116510982,-0.8062869906643575},
{-0.303303926294739,-0.2949038175546275,-0.9061117296922618},
{-0.8284141452922973,-0.06770115600710831,-0.5560094939431643},
{-0.8280948906702869,-0.35519780843628296,-0.4336973240957655},
{-0.9767958925819075,-0.16989928557500622,-0.13039945167145855},
{-0.9654870915238788,-0.18679750253408656,0.18149757339366546},
{-0.9869829993642526,0.13519767124016913,-0.08709849974126281},
{-0.9854420595646723,0.02020086219119787,0.16880720484525746},
{0.9674466272138249,0.1638078949117475,-0.192909297487644},
{0.611030368964025,0.31221551749683896,-0.7274361544753385},
{0.9427962193947405,0.21269914707813037,-0.2566989706391916},
{0.5787675609872844,0.3328813425236126,-0.7444582742830569},
{-0.557528964382069,0.191609954395703,-0.8077419632850172},
{-0.5633100861573898,0.18910338592643777,-0.8043144013782861},
{-0.9531988847579572,-0.03509995893307207,-0.3002996486496166},
{-0.9531702567861983,-0.035098904755765374,-0.30039062645674985},
{-0.3752844016280128,-0.5709762678646291,-0.7301696511291631},
{-0.5269957919554019,-0.31359749593399244,-0.7898936927240454},
{-0.5318022442102059,-0.5236022096059868,-0.66560280884978},
{-0.5712133979673759,-0.6578154292418414,-0.49091151446460923},
{-0.12350040137695671,-0.4115013373815197,-0.9030029347643069},
{0.2804963283270932,-0.3896948989271594,-0.877188517677455},
{0.1845059356514264,-0.23210746701732285,-0.9550307238325865},
{-0.7259147289592774,-0.19550396681573046,-0.6594133796332106},
{-0.6355800621661699,-0.3062903918211105,-0.7086777691270683},
{-0.06400238061282117,-0.37691401957769216,-0.9240343700976056},
{0.16380521154570932,0.6112194462560289,-0.7743246355301754},
{-0.7712064743055278,-0.212401783120454,-0.6001050379029399},
{-0.805376076658959,-0.26549211367389325,-0.529984257051463},
{-0.5151919604921843,0.19589694305205532,-0.8343869794927768},
{-0.08950068692040818,-0.06880052804607914,-0.9936076259677941},
{-0.3061125187274353,0.21740889111840717,-0.9268379038111304},
{-0.46990817177416133,0.501508721312496,-0.7264126324255179},
{-0.5546077728824057,0.5459076509493425,-0.6280088016050321},
{-0.6894063391204325,0.3795034895506297,-0.6170056733932504},
{-0.8485890108434639,0.019499747479905193,-0.5286931534679935},
{-0.8670165038162267,0.17020323984950608,-0.46830891434502764},
{-0.40569806279637527,-0.6484969034346791,-0.6440969244445287},
{-0.6567069315782443,-0.4820050875905494,-0.5800061219969266},
{-0.34359147731910633,-0.669683388709562,-0.6583836689956333},
{-0.16360471024741302,-0.251507240997704,-0.9539274639670371},
{0.056497253452783475,-0.4316790144348075,-0.9002562351069197},
{-0.35669269144162774,-0.32469334710147607,-0.875982051311651},
{-0.2689945219823392,-0.2512948824318284,-0.9297810652014088},
{0.19959211027981785,-0.23909054893739706,-0.9502624368682911},
{0.36410097215089343,-0.06480017301669293,-0.9291024807069352},
{-0.010899599229104382,0.03679864693862764,-0.9992632577655055},
{-0.8361179474643655,0.10650228609610683,-0.5381115506884047},
{-0.8265137285070466,0.049800827198609704,-0.5607093134590454},
{-0.5868100433398384,0.21480367639638256,-0.7807133620235376},
{-0.6236719073316371,0.250188730502446,-0.7405666419269047},
{-0.6757601921395869,0.26128460817708504,-0.6892593969248555},
{-0.5782930894388716,-0.230497245574373,-0.7825906480976326},
{-0.23259050468646533,-0.14329415013572866,-0.9619607287548566},
{0.24479516044751645,0.013499733112914511,-0.9694808335533791},
{0.16449853843697892,0.19259828877180632,-0.9673914047655527},
{-0.21650498724982262,0.3098071364895845,-0.9258213265398881},
{-0.22691256449655386,0.2542140762231115,-0.9401520576606889},
{-0.3500016712619704,0.27910133271204557,-0.8942042698355828},
{-0.167194320505397,0.19089351545741798,-0.9672671424932449},
{-0.19789599165728303,0.07589846269220708,-0.9772802053899076},
{-0.18199621269822022,0.8558821892769598,-0.48408992619345276},
{-0.08949965497949507,0.06449975135393779,-0.9938961685376553},
{-0.23670902115269746,0.41171569078396936,-0.880033538717253},
{-0.4815139881845381,0.3283095375305999,-0.8126236070586826},
{-0.5711042775870588,-0.33590251591926634,-0.7490056100730292},
{-0.28668897128740783,-0.9456636210202357,0.15339409904251258},
{-0.685730546547559,-0.06290280206772855,-0.7251323017378374},
{-0.3745027207721497,0.2801020349486759,-0.8839064216034795},
{0.2432080746421194,0.4400146087275187,-0.8644286995092434},
{0.140401886312014,0.33160445513578235,-0.9329125337640872},
{0.016500565154034953,0.3426117346528712,-0.9393321726778807},
{-0.2795059968654948,0.15700336854340852,-0.9472203228300418},
{-0.11770395197653255,0.382012826295968,-0.9166307763949849},
{0.25201476597772066,-0.09390550208455543,-0.9631564329886617},
{-0.6281202697681634,0.525216949024422,-0.5741185271038093},
{-0.6601739335468407,0.6726734400135713,0.334186804894508},
{-0.7701958216990009,0.40159782133772887,-0.49549731193437413},
{-0.5617340477324809,0.18421116537711052,-0.8065488864095528},
{-0.508221518554653,0.09620407336670134,-0.8558362368734201},
{-0.21369739611309246,0.7101913463711665,-0.6707918264513917},
{-0.30879387050250523,0.7124858572960977,-0.6300874928873981},
{-0.7386944228781608,0.2620980211674102,-0.6209953115030971},
{-0.5544941362555135,0.19469794108015956,-0.8090914439032209},
{-0.27140104082498734,-0.2501009591390175,-0.9294035642695035},
{-0.5855110604083976,0.4666088143237547,-0.6629125225358272},
{-0.7582603364391741,0.5396717705080077,0.3657808665032967},
{-0.055700964470549785,0.977216920657473,0.20480354620410407},
{-0.2413013307805089,0.778204291808504,-0.5798031976234523},
{-0.0,-0.03209950791831538,-0.9994846780173281},
{0.01839968821992465,0.25869561643991884,-0.965783634934958},
{-0.00039999573606818014,0.22399761219818087,-0.974589610930121},
{0.20450278636944655,-0.5701077677712543,-0.7957108416340763},
{-0.4258161642884004,-0.433816467985693,-0.7940301419562938},
{0.1972992640751175,-0.5080981047976036,-0.8383968727854968},
{0.3031906073004765,-0.5045843682184051,-0.8083749569317453},
{0.12619975517271245,0.03999992240022582,-0.9911980770775958},
{0.20650131232000968,-0.35900228146674806,-0.9102057843761395},
{-0.0941019079355253,-0.3992080940261604,-0.9120184913623706},
{-0.21049266866802321,0.32788857983964287,-0.9209679232458403},
{-0.005299998781000421,-0.6845998425420543,-0.7288998323530579},
{-0.10489784646931774,-0.2367951386457049,0.9658801706836416},
{-0.33499237566029394,-0.3813913196323466,0.8615803906534605},
{-0.31341121405386185,-0.4022143914883958,0.8602307796079514},
{-0.566701003061663,-0.14310025328767248,0.811401436181813},
{-0.6835882833972331,-0.24759575624510666,-0.686588231978555},
{-0.8414861871176067,-0.16429730308190468,-0.5146915514075249},
{-0.8488218913988724,-0.4523116652682728,-0.27370705899607845},
{-0.7807806329765956,-0.21159475145728435,-0.5878854176830692},
{-0.2645148264715473,-0.7166401688072241,-0.6453361721061983},
{0.08959907444634144,-0.7234925263608039,-0.6844929292245615},
{-0.16399482358508902,-0.3791880311186936,-0.9106712551154912},
{0.3588927755611412,-0.4547908451524297,-0.8150835925324219},
{-0.4408990278187155,-0.40019911756191867,-0.8033982285088592},
{-0.40439587316117154,-0.3715962078800478,-0.8356914718120452},
{0.2711092043137323,-0.4685159063850372,-0.8408285466137444},
{-0.28589374757211017,-0.18779589294873134,-0.9396794494351589},
{-0.08639858566672885,-0.3616940791163869,-0.9282848041021342},
{-0.026601089868978352,0.09050370801287748,-0.9955407881416524},
{-0.5369013717847574,0.0692001768066776,-0.8408021482522331},
{-0.41518990893189367,-0.4713885430406904,-0.7780810889689461},
{-0.6419183045614356,0.04200119768122807,-0.7656218320178144},
{-0.6294946807924209,0.41069652962898695,-0.6595944264506447},
{-0.25250249347443465,-0.26000256753803175,0.9320092036363291},
{-0.18149502891923594,-0.1606955986078304,0.9701734273137339},
{-0.08979509507689348,-0.12609311235185153,0.9879460349217233},
{-0.15499773937445668,0.007599889156424973,0.9878855917937146},
{-0.5062802503926408,0.8391672647234922,-0.19869224916653708},
{-0.08720353007034731,0.9628389765106697,0.2556103473162933},
{-0.12889893916609596,0.911792495978637,0.38989679116261305},
{-0.28559254042026505,0.8341782115496678,0.4717876770668104},
{-0.3231156343282096,0.8509411737848145,0.4141200376827967},
{-0.20810222046253857,0.2011021457713431,-0.9572102134874672},
{-0.17030125767943197,0.34850257370101023,-0.9217068068299028},
{-0.19540454516258132,0.21160492198772882,-0.9576222745531621},
{-0.3432915637134813,0.7754809427899934,-0.5298869781875145},
{-0.17409137746760575,0.8564575807065155,-0.4859759302082504},
{-0.1004947568228406,0.8796541052443072,-0.46487574574068247},
{-0.5149227523644809,0.6949307061916445,-0.501922177921408},
{-0.5468877908663519,0.8101819128906897,-0.21099528958273947},
{-0.234389592161235,0.9648571564691795,-0.11879472503734949},
{-0.15400074998547864,0.9585046679290992,-0.23990116832153457},
{-0.46399576837788853,0.7067935540721801,-0.5339951299866217},
{-0.48272758867006127,0.6375364362485271,-0.6004343158017501},
{-0.4448051931309449,0.8905103967695738,0.09560111614954662},
{-0.15109911531726972,0.9828942451710416,0.10529938347391463},
{-0.40649271368341017,0.8551846709521584,0.32159423547499316},
{0.024800126356965685,0.6929035303524808,0.7206036714850594},
{0.48058100541113424,0.20369194923480657,0.8529662871737359},
{-0.2889084983684711,0.19140563027942323,0.9380275924874555},
{0.3092068010783854,0.0511011239815831,0.9496208871411215},
{-0.2823916399192484,0.7990763436950122,0.5307842863637999},
{-0.23909268028963768,0.39488791069166834,0.8870728426806256},
{-0.039999295018637894,0.6893878496462241,0.7232872521745197},
{0.017399193566066888,0.7362658748675316,0.676468646404842},
{-0.005999618136458036,0.8436463036216074,0.5368658295773866},
{0.3369947867309736,0.833687102960275,0.4374932320320503},
{-0.011699842696672407,0.9069878056309294,0.42099433976915246},
{-0.25349297580695923,0.8758757298197855,0.4105886227468934},
{-0.1877004636207177,0.8424020807357091,0.5051012476016223},
{0.018499869576379224,0.854393976543698,0.5192963389737153},
{0.653895599297425,0.6972953072183735,0.29359802409194674},
{0.6860250232190912,0.6228227178729592,-0.3761137189981052},
{0.18410019698731617,0.7048007541372103,-0.6851007330581765},
{-0.25270020089673956,0.8004006363187588,0.5436004321625153},
{-0.004399930987623685,0.8494866759059818,0.5275917247886944},
{0.23319186524366897,0.8271711446379202,0.5112821642327956},
{0.9025580275148729,0.41038091567926416,0.13029394082116988},
{0.9746483388830801,0.2206109414709701,-0.037301850031129576},
{0.9128747913107023,0.40808873078529695,0.011099693486196511},
{0.8080694636319431,0.4800818580493699,-0.3413870992252757},
{-0.5126049184677891,0.7749074352725124,0.36980354828206874},
{-0.45628000396697965,0.7469672648769095,0.4835788076231237},
{-0.10549563942786451,0.8310656486113573,0.5460774283559888},
{-0.2193002752220181,0.8230010328669444,0.524000657621238},
{0.10899710889002952,0.8088785447811456,0.577784674464762},
{-0.6444808140917425,0.7644772418512601,-0.01479955942367384},
{-0.38789298114000886,0.8422847589951777,0.3742932272253295},
{-0.2902859809770649,0.7834621636084407,0.5494734638198318},
{-0.29579198118808353,0.9306747697489834,0.21529416345434205},
{-0.37099818211336144,0.9207954881131623,0.12039941004433616},
{-0.3471899837134527,0.8180763988363355,-0.4584867728474023},
{-0.23629895319795602,0.7465966925839779,-0.6218972450013069},
{-0.14279886903743583,0.36999706963481266,-0.9179927295263731},
{-0.14180186896094943,0.3004039593502765,-0.9432124316217736},
{-0.1907906619795685,0.5593726221769949,-0.806660518967075},
{-0.09349904537961999,0.6388934769309007,-0.7635922037633991},
{-0.27890698810213144,-0.030800771723003405,-0.9598240486928138},
{-0.2887034096074013,0.4238050051666667,-0.8585101390646139},
{-0.46409475111804716,0.4965943835492829,-0.7334917042557372},
{-0.5637100031227589,0.2991053076707773,-0.7699136622391557},
{-0.5800098805524735,0.2183037188355258,-0.7848133694096228},
{-0.7023838980337042,0.5746868254555378,-0.41999037183108734},
{-0.4390140816025047,0.8506272843077233,-0.2893092797439741},
{-0.2787866715278438,0.5612731661713728,-0.7792627443387685},
{-0.4966149979994128,0.5810175469948828,-0.6448194738421695},
{-0.38440837634978203,0.27090590310394363,-0.8825192303035447},
{-0.360017389259862,0.3352161913330715,-0.8706420530267663},
{-0.4360879227122184,0.5196856075063975,-0.7346796533287477},
{-0.34578872747122363,-0.3283892946834871,-0.8789713460011729},
{-0.7172311966493622,0.6966303005939009,-0.016900735113460987},
{-0.5328926114951621,0.13959806448625375,-0.8345884285116574},
{-0.04959875483888946,-0.019699505450123434,-0.9985749310910286},
{0.2565972236330603,0.11879871460486191,-0.9591896216244407},
{0.7879678121722958,0.050097953540395965,-0.6136749318910381},
{-0.056801516336718184,-0.08060215170315996,-0.9951265652582441},
{0.3675015526973402,-0.1603006772717922,-0.9161038705470296},
{0.18910635691703345,-0.11640391298330352,-0.9750327762776712},
{-0.6587886524631912,-0.052599093988409,-0.750487072971501},
{-0.8767671174658777,-0.20059247692022703,-0.43708360748669606},
{-0.5716878260373655,-0.2146954281095371,-0.7918831370281436},
{-0.3687966882206096,-0.07359933908090258,-0.9265916792440805},
{-0.07320159141989639,0.013800300021783746,-0.997221679834982},
{0.22730805366701465,-0.10230362468163484,-0.9684343122355346},
{-0.20460369108388105,-0.2624047338240977,-0.9430170121803509},
{-0.03709939342987609,-0.2501959093303234,-0.9674841817629412},
{-0.30959349860479324,-0.4621902941057346,-0.8309825495496872},
{-0.46830570165662677,-0.29740362091112704,-0.8320101297849957},
{-0.6735860535451405,-0.27339433942880254,-0.6866857823180641},
{-0.12749861664751402,-0.8791904608352497,-0.4590950188460682},
{-0.6920980413653145,-0.5333984904844079,-0.4862986237768421},
{-0.41669687061825245,0.24929812777809054,-0.8741934348319564},
{0.20340067427435282,0.07900026188630223,-0.9759032351245867},
{-0.48892235893072256,-0.6423293743939519,-0.5902269916975096},
{-0.20009483161724811,-0.49578719398216703,-0.8450781719127256},
{-0.0,-0.8146109321520647,-0.5800077837566874},
{-0.3871910753485686,-0.4114905152529338,-0.8250809821025411},
{-0.5217909470056036,0.46609191337545386,-0.7144876037476116},
{-0.6029043077666685,0.2047014625971754,-0.7711055095685488},
{-0.0017000125631392623,0.05080037541616149,-0.9987073804748127},
{-0.0006999896857279706,0.44669341802097784,-0.8946868168868791},
{0.3863975483153339,-0.40979739984374697,-0.8262947571763986},
{0.0019000284816404114,-0.16000239845392938,-0.9871147969617105},
{-0.0,0.2687989678139454,-0.9631963013333045},
{-0.41549891347176193,-0.4032989453746368,-0.8152978679988628},
{-0.4459888637971048,0.4864878525499809,-0.7512812407416252},
{0.38028086094589086,0.561571736805712,-0.7348630152751384},
{0.42858688329915184,0.7680764933786247,0.47578543880946444},
{-0.3275000163750012,0.9322000466100034,-0.15410000770500054},
{-0.7642056207530111,0.6043044446755359,0.2254016578352901},
{0.010199744142627233,0.46418835598113345,0.8856777830514647},
{-0.41642728312721033,-0.044902941912612265,-0.9080594934666355},
{-0.3280911974312578,-0.5353856357960848,-0.77827911905135},
{-0.2685006417173006,-0.04110009822935215,-0.9624023001442461},
{-0.14390543828927135,0.6800256986567376,-0.7189271687710714},
{0.2126009683996166,0.6338028869787253,-0.7437033875766457},
{0.6198032074898981,0.5769029854806748,-0.5320027531213711},
{-0.24829416639708993,0.6082857084951663,-0.7538822877437218},
{0.41469507137836487,0.37479554558141104,-0.8291901451336874},
{0.547986410105542,0.3011925305178636,-0.7803806467999361},
{0.4655047248969367,0.39480400728101095,-0.7921080399374082},
{0.28579655045645386,-0.1878977320880605,-0.939688658026346},
{0.3705958326732922,-0.23029741032018133,-0.8997898819196665},
{0.29289094834510987,-0.5137841217470723,-0.8063750793632524},
{0.3032041766663006,-0.2950040637089666,-0.9061124817854055},
{0.41520947934062125,-0.47131076014748263,-0.7781177646313521},
{0.9160870924238009,0.38789453460451084,-0.10159856848625495},
{0.8752021705040742,-0.10600026288097791,0.4720011705643545},
{0.8372875286951393,0.45169327207881815,-0.3080954109530305},
{0.9113317240094788,0.39901388991526615,-0.10130352643713399},
{0.8952975513645455,0.19869945655772944,-0.3986989095599735},
{0.8283367002705262,-0.06770299964785056,-0.5561246396480015},
{0.6418103556936343,0.04200067768640175,-0.7657123548685195},
{0.987660425239625,0.09579616152471,0.12389503562538173},
{0.994916063049508,-0.08390135459830508,0.055700899298278816},
{0.91348404614045,-0.326194303066245,0.24319575262327034},
{0.7807806329765956,-0.21159475145728435,-0.5878854176830692},
{0.9531702567861983,-0.035098904755765374,-0.30039062645674985},
{0.5633100861573898,0.18910338592643777,-0.8043144013782861},
{0.5574839307572905,0.19159447736878363,-0.8077767161717296},
{-0.6109859199917087,0.3121928055996914,-0.72748323534201},
{-0.5787010561303911,0.3329006075441631,-0.7445013587162196},
{-0.9427720142281303,0.2126936862816327,-0.2567923772314211},
{-0.9674121072382836,0.1639020512470071,-0.19300241544034394},
{-0.5852200470560738,0.11810404572338055,-0.8022274807730388},
{-0.44611445211176803,0.48861582896617317,-0.7498242909513645},
{0.06210182550999169,-0.11320332766072558,-0.9916291493672748},
{0.6369133434743202,0.28070588084980636,-0.7180150425727145},
{0.23520451949826365,0.366207036735817,-0.900317299763124},
{0.6196282494958565,0.12710579488528623,-0.7745353118698206},
{0.23080734671477077,0.3333106094455507,-0.9141290971922529},
{-0.02120002915006012,0.02340003217506636,-0.9995013743153345},
{0.393580789790464,0.3324837718631334,-0.857058168011704},
{0.3324012863954675,0.6435024903594565,-0.6895026683804899},
{-0.5781001907730944,0.679800224334111,-0.4513001489290737},
{-0.508121580381788,0.7384313618459205,-0.44331882815045587},
{0.3432915637134813,0.7754809427899934,-0.5298869781875145},
{0.17409137746760575,0.8564575807065155,-0.4859759302082504},
{0.10050359708811084,0.8796314825741521,-0.4649166396643057},
{0.5148869683757435,0.6949824102177933,-0.5018872973932524},
{0.5468993273142412,0.8101990034558386,-0.2108997405934786},
{0.23441220850573674,0.9648502507096195,-0.11880618758737851},
{0.15259981840632414,0.9840988289230903,0.09089989182919307},
{0.4404719230121228,0.8931430684095983,0.09099419975959858},
{0.07590366851295098,0.9667467239982835,0.2442118030416684},
{0.39948593434787305,0.8583697773322008,0.3218886664995753},
{0.2837120339011323,0.8342353848442883,0.4728200550879639},
{0.1295996338815514,0.9069974377358575,0.4006988680272967},
{0.32040124796529124,0.8527033212859045,0.4126016070863894},
{0.48272758867006127,0.6375364362485271,-0.6004343158017501},
{0.46391729283939187,0.7068263474431606,-0.5340199059629991},
{0.15400444386234238,0.9585276587146441,-0.2398069197285046},
{0.040002052557976474,0.6893353707053296,0.7233371153796097},
{-0.0246003147630411,0.6930088671051822,0.7205092189744355},
{0.2536952381850685,0.8762835523120833,0.40959231202445434},
{0.006000124293862134,0.8436174757170161,0.5369111222290966},
{0.187690982603356,0.8423595298085621,0.5051757294151064},
{0.29579834797083987,0.9306948020840454,0.21519879811806875},
{0.2902859809770649,0.7834621636084407,0.5494734638198318},
{0.38789298114000886,0.8422847589951777,0.3742932272253295},
{0.5132832107807586,0.7742746738896189,0.37018789135210756},
{0.4562008211622171,0.7470013446036304,0.4836008704823503},
{0.2524005590678575,0.8009017739993941,0.5430012027489962},
{0.10549563942786451,0.8310656486113573,0.5460774283559888},
{0.004399930987623685,0.8494866759059818,0.5275917247886944},
{0.2193002752220181,0.8230010328669444,0.524000657621238},
{0.37099818211336144,0.9207954881131623,0.12039941004433616},
{0.6444808140917425,0.7644772418512601,-0.01479955942367384},
{-0.018499869576379224,0.854393976543698,0.5192963389737153},
{-0.6537927560163949,0.6973922729364236,0.29359674696606536},
{-0.23319186524366897,0.8271711446379202,0.5112821642327956},
{-0.10899710889002952,0.8088785447811456,0.577784674464762},
{0.5638171487593732,0.742722590251129,0.36121098639922955},
{0.3471020357594096,0.8181047981987122,-0.4585026891261576},
{0.4390140816025047,0.8506272843077233,-0.2893092797439741},
{0.7023838980337042,0.5746868254555378,-0.41999037183108734},
{0.46409475111804716,0.4965943835492829,-0.7334917042557372},
{0.2887950717541504,0.42379276803811966,-0.8584853500725005},
{0.1907906619795685,0.5593726221769949,-0.806660518967075},
{0.09339991920910481,0.638899447352217,-0.7635993394868569},
{0.27890698810213144,-0.030800771723003405,-0.9598240486928138},
{0.14180186896094943,0.3004039593502765,-0.9432124316217736},
{0.14279886903743583,0.36999706963481266,-0.9179927295263731},
{0.23629895319795602,0.7465966925839779,-0.6218972450013069},
{0.6653097036127913,0.49450721244029056,-0.5593081575689677},
{0.5800098805524735,0.2183037188355258,-0.7848133694096228},
{0.5636249099533552,0.29921322402065986,-0.7699340279863169},
{0.3598990030811422,0.3351990714998579,-0.8706975881710212},
{0.4966149979994128,0.5810175469948828,-0.6448194738421695},
{0.38440837634978203,0.27090590310394363,-0.8825192303035447},
{0.2787866715278438,0.5612731661713728,-0.7792627443387685},
{0.4128859889516933,0.3774871901895477,0.8288718727102412},
{-0.9025580275148729,0.41038091567926416,0.13029394082116988},
{-0.6859822950254452,0.6228839235733962,-0.37609029323479576},
{-0.9746483388830801,0.2206109414709701,-0.037301850031129576},
{-0.9128747913107023,0.40808873078529695,0.011099693486196511},
{-0.8080347583627125,0.48012065283408206,-0.3414146862686015},
{-0.1839062326878405,0.7050238936646414,-0.6849232124410111},
{-0.3369947867309736,0.833687102960275,0.4374932320320503},
{-0.017399193566066888,0.7362658748675316,0.676468646404842},
{0.011700335219406123,0.9070259866667824,0.42091205930325104},
{0.2889084983684711,0.19140563027942323,0.9380275924874555},
{0.23899839632614095,0.3948973502476697,0.8870940476189106},
{-0.4806024078240948,0.2039010215466769,0.852904273061112},
{-0.3092972379879971,0.05109954368311235,0.9495915201855868},
{0.2823916399192484,0.7990763436950122,0.5307842863637999},
{0.3507198916427478,-0.35582018091385703,-0.8662491307127121},
{0.6768419519643144,0.7358456091243241,-0.02040126450956267},
{0.7386944228781608,0.2620980211674102,-0.6209953115030971},
{0.554682086831254,0.4144866143709298,-0.7214767002861903},
{0.555306002890337,0.0877009480523727,-0.8270089400149626},
{0.6037713396547436,0.2022903975027404,-0.7710633984891898},
{0.42960021265215786,-0.41230020408865153,-0.8034003976832952},
{-0.42860727352714817,0.7681130349888066,0.4757080728344946},
{-0.010199744142627233,0.46418835598113345,0.8856777830514647},
{0.3275000163750012,0.9322000466100034,-0.15410000770500054},
{0.7642056207530111,0.6043044446755359,0.2254016578352901},
{0.41639684996974496,0.24909811557988343,-0.874393385239061},
{0.6920122764066761,-0.533409462767805,-0.48640862896561743},
{-0.20359720462957054,0.07869891947125345,-0.9758866011689483},
{0.12740609015666773,-0.879242028773487,-0.4590219417732377},
{0.5221152590414214,0.46751366328646726,-0.7133208471063894},
{0.2015069500945652,-0.493417018246444,-0.8461291834988169},
{0.48889350020412187,-0.6422914607917928,-0.590292152118006},
{-0.10380501701771162,0.04110198650701298,-0.9937480290028905},
{-0.11809836907278459,-0.04489937994384444,-0.9919863007637791},
{0.37270809903498897,-0.04150090182439507,-0.927020144366608},
{-0.19990578835590397,-0.11680338209089337,-0.9728281686474406},
{0.4130054723587634,-0.06350084139172271,-0.9085120378642532},
{0.27140104082498734,-0.2501009591390175,-0.9294035642695035},
{0.5965795824131819,0.45548441131277967,-0.6607773852809765},
{0.23289174296962692,0.772872598287783,-0.5902790720264954},
{0.04500194592621368,0.9754421790317517,0.2156093231487038},
{0.7600936684461127,0.5352955410067151,0.3683969312663438},
{0.5546082498590754,0.19470289622712225,-0.8090120341435125},
{0.5647923979454852,-0.04879934316526147,-0.8237889118758688},
{0.1206995208238535,0.514097959035154,-0.8491966286960762},
{0.6686295005843631,0.4478197582436102,-0.5936261913653574},
{0.9086339562854314,0.3643136146541742,-0.2041076276445703},
{0.6226883122500675,0.7223864409337543,-0.30069435601990574},
{0.39538313133854447,0.7720670604615332,-0.497578771254577},
{0.8687066282568605,-0.13240101022356202,-0.4773036418406809},
{0.8184102629290462,0.3306041458019827,0.47000589391086467},
{0.47288896762907634,0.7555823724688732,0.4532894248810749},
{0.4286106039575145,0.5630139291369124,0.7066174819327572},
{0.554374230512828,-0.025998791474266824,0.8318613318247143},
{0.17029149500366778,0.3483826004655188,-0.9217539641478623},
{0.19549027460075188,0.21138948363477725,-0.9576523579802562},
{0.20850160755359137,0.20070154741489585,-0.957207380097351},
{0.5716878260373655,-0.2146954281095371,-0.7918831370281436},
{0.6587320480937287,-0.05260255917675745,-0.7505365144896665},
{0.8767671174658777,-0.20059247692022703,-0.43708360748669606},
{0.46830570165662677,-0.29740362091112704,-0.8320101297849957},
{0.6735860535451405,-0.27339433942880254,-0.6866857823180641},
{0.3687966882206096,-0.07359933908090258,-0.9265916792440805},
{0.20460369108388105,-0.2624047338240977,-0.9430170121803509},
{0.30959349860479324,-0.4621902941057346,-0.8309825495496872},
{0.03709939342987609,-0.2501959093303234,-0.9674841817629412},
{-0.3675015526973402,-0.1603006772717922,-0.9161038705470296},
{-0.22730805366701465,-0.10230362468163484,-0.9684343122355346},
{-0.7879678121722958,0.050097953540395965,-0.6136749318910381},
{0.07320159141989639,0.013800300021783746,-0.997221679834982},
{-0.2565972236330603,0.11879871460486191,-0.9591896216244407},
{0.0941019079355253,-0.3992080940261604,-0.9120184913623706},
{-0.20659704568336992,-0.3589948664101152,-0.9101869844191834},
{0.43110394461914,-0.4332039638344037,-0.7915072423244011},
{-0.2555004471261737,-0.45640079870209654,-0.8523014915289152},
{0.21278885760319974,0.33148264236588687,-0.9191518698724681},
{-0.1937961163647417,-0.5689885975827556,-0.799183984513424},
{0.7979795560256586,0.43398888134728797,0.4181892861277324},
{0.9274778428189995,0.15919619684828543,0.33829191830260646},
{0.737305356542873,-0.07570054996649328,0.6713048770476477},
{0.9696547579503159,0.08030453492513445,0.23091304002756594},
{0.9815964809829236,0.030599890299589916,0.18849932423113397},
{0.5778766513655929,0.16059351135025818,0.8001676698784347},
{0.3696208675351317,0.04970280605112567,0.9278523833849978},
{0.4196852042589312,-0.12609555457958355,0.898868310956286},
{0.8266198680472956,-0.14060337944283782,0.5449130971436866},
{0.9932941296490406,-0.025799847523351706,0.11269933394890454},
{0.9620858670624184,-0.211596891664492,0.17209747190670638},
{0.9574633585783874,-0.026998966769312228,-0.28728900566012605},
{0.8892830104103777,0.2263956747519504,-0.3973924078905702},
{0.9751507122528422,0.158591984170735,-0.1546921812812907},
{0.9895869919644854,-0.1421981308178555,0.022299706872279734},
{0.99685240143422,0.02419884453275968,-0.07549639513319652},
{0.9710837927467476,0.20759653524274,0.1178980322982613},
{0.7356975758804813,0.24069920689741992,0.6330979139458104},
{0.8958781721942486,0.2945928223333247,0.3325918964971616},
{0.811380279641952,0.4722885211669879,0.3443916296631603},
{0.3898730782440907,0.46086817584688733,0.7972449481508425},
{-0.02910002124302326,0.10730007832908578,0.9938007254747944},
{-0.13719854227323247,-0.12209870270817556,0.9829895557914543},
{0.08180336668683542,-0.2279093798035427,0.9702399310460602},
{0.49498143854407534,-0.09059660269109743,0.8641675943228079},
{0.5604753116062736,0.06439716336742912,0.8256636303181091},
{0.8588960276150585,0.10999949125352944,0.5001976865910492},
{0.975559524874952,-0.0950960545465436,0.19809178134248462},
{0.9780383740884259,0.1813071137241632,0.10280403359538873},
{0.6365847030533763,0.6884834559413283,-0.347491649875979},
{0.6290727837547535,0.26558850956169533,-0.7305683926422237},
{0.7527719785846361,-0.04299839941437214,-0.6568755482628154},
{0.8892879146593591,-0.19499735000402005,-0.41369437793160563},
{0.7728302607613018,0.26041019656087344,-0.5787226603294064},
{0.8694009215654653,0.21140022408435633,-0.44660047339675274},
{0.7953101681054993,-0.08850113149419928,-0.5997076673115402},
{0.9340789367574616,-0.007299835390567893,-0.35699194992229283},
{0.7728706082896395,-0.12019542905474791,-0.6230763048586807},
{0.9646533746059304,-0.09529539400844321,-0.24568812495146378},
{0.8747243439172415,-0.4405122596267805,0.20200562189468707},
{0.7401029382144971,-0.06010023859842086,0.6698026591218351},
{0.952250012947571,0.16989108180173507,0.25368668306709935},
{0.8561020503668659,0.5168012377404466,-0.0024000057480206495},
{0.8713142286775324,0.4797078336928869,0.10340168856336149},
{0.5348059363788409,0.7560083917397227,0.3774041892097505},
{0.38490077942486756,0.6587013338715516,0.6465013091664766},
{-0.22301441054172078,0.6624428051248243,0.7151462106654014},
{-0.3309833850510952,0.4027797809624808,0.8533571625456334},
{-0.36499673329385546,0.18769832010755252,0.9118918386045666},
{-0.8492037619809983,0.19510086429874327,0.49070217381544506},
{-0.7409025894590753,-0.01680005871630782,0.6714023465553018},
{-0.4062992300636885,-0.2540995184818687,0.8776983367632277},
{-0.07829759669215372,-0.2140934285030666,0.9736701136545349},
{0.45291323884746015,-0.10520307513082978,0.8853258784536464},
{0.3098925533714127,-0.013399678009606099,0.9506771555024267},
{0.6131952354915302,0.24889806606953993,0.7496941748988915},
{0.81520566977515,0.3871026923085875,0.43080299624525836},
{0.5467119539875623,0.22430490448035528,-0.8067176390740196},
{0.6082851762708791,0.23289432443446945,-0.758781508719946},
{0.29720648957455065,0.22950501129663312,-0.926820237340826},
{0.4676135422842797,-0.05160149440091709,-0.8824255554141325},
{0.4913826446714798,0.09479665184138437,-0.8657694215640359},
{0.7883964916434182,-0.045299798416345564,-0.6134972699432232},
{0.7961831808079564,0.009099807768591314,-0.6049872197799718},
{0.8108966874937974,0.582997618459593,-0.05059979330026656},
{0.9829604022377777,0.15589371994798532,0.09739607647808703},
{0.4340095982283984,-0.3284072628069264,-0.8389185528889479},
{-0.0061998644724439314,-0.34879237548200703,-0.9371795134797505},
{0.21501182597565194,0.14720809666798124,-0.9654531013809041},
{-0.8477524042773552,-0.31708219791973263,-0.4251761291563239},
{-0.6154028431677032,-0.27360126404075985,-0.7392034151276669},
{-0.7287151209956426,0.45600946229451494,-0.510910601504973},
{-0.7943355155348671,0.3528157747459412,-0.49452211057785694},
{-0.38790491478640576,0.7091089844677502,-0.5888074602377822},
{-0.44547515431613277,-0.008899503644025997,-0.8952500688198286},
{0.29700994405939346,-0.009000301335133135,-0.9548319683094575},
{-0.020599903592676782,0.17699917164581505,-0.9839953949123278},
{0.28711030888071387,0.054701964109282644,-0.9563343378008592},
{0.80059055308721,-0.0381995492479783,-0.5979929437248958},
{0.8048242336225171,0.17950540498911757,-0.5657170339963443},
{0.7970220897733313,0.1591044096398206,-0.5826161474302921},
{0.8007943584236172,0.5487961337448566,-0.2398983099223599},
{0.8714147923916523,0.48350820762148716,-0.08280140556578933},
{0.4241879235417227,-0.2108939959334024,-0.8806749275417142},
{-0.11829782688887988,-0.3522935284273236,-0.9283829457619279},
{-0.18170292634919347,-0.06630106778729514,-0.9811158009972136},
{-0.34838056787387084,-0.25938553187853647,-0.9007497575797442},
{-0.8321169295911506,-0.3469070578958901,-0.4327088035501633},
{0.3110978674314281,0.14729899026888255,-0.938893563906679},
{-0.23079713697927354,0.20159749919853356,-0.9518881919002187},
{0.19560821473947057,0.38921634548365003,-0.9001378020807642},
{-0.47861254699238126,0.40311056768204945,-0.7800204485040898},
{-0.4791242754463888,0.33051674605516906,-0.8131411988425356},
{-0.2852024584557879,0.45160389284233454,-0.8454072874422268},
{-0.03399971627355155,0.5336955463292488,-0.8449929485632663},
{-0.0837978527075362,0.5174867395721955,-0.851578178588757},
{-0.22179628494334055,0.2850952246949793,-0.9324843810174259},
{0.23429933693381472,0.4670986781126114,-0.8525975871522425},
{-0.060402193243455735,0.18890685933259582,-0.9801355893693867},
{0.4782986201104715,0.40119884254300886,-0.7811977462477531},
{0.28670171734843036,0.5843034999884474,-0.7592045476488606},
{0.6004215615254185,0.6201222689905262,-0.5049181319356826},
{0.5796170380932558,0.47571398381808455,-0.6616194485895411},
{0.6044795991577868,0.23139219064534633,-0.7622742736773876},
{0.6892205080613306,0.4048120453616173,-0.6009178805775589},
{0.8652036598192216,0.12990054948048646,-0.48430204860199844},
{0.5090041993019664,0.009900081676010742,-0.8607071008628733},
{0.876569601093342,0.08679698993258281,-0.4733835833419896},
{0.9923491274596125,0.10190504493412729,-0.06970345075474653},
{0.9456325066761351,-0.2590089035840937,-0.19670676191116307},
{0.9592751598913478,0.059698454128545256,-0.2760928506681967},
{0.808471950552255,0.3564876318761644,-0.4682837531770204},
{0.7601502818033898,0.445329457291211,-0.4731312963046754},
{0.6052766428250214,0.6684742040781874,-0.43218332236737855},
{0.9070458205769688,0.4159210107805527,-0.06540330393134924},
{0.8623247878822966,0.10610304997600797,-0.4951142322631626},
{0.7737525356065101,0.2559842971249245,-0.579464453843335},
{0.8333671118158854,0.5270791992298455,-0.16639343341272297},
{0.6431088813949786,0.6489089614946378,-0.4066056152623205},
{0.8949863202386419,0.44609318151783034,-0.0005999908292102626},
{0.8796900199733347,0.35159601116587985,-0.32019636739281776},
{0.5184241280203902,0.20800968099583556,-0.8294386029708943},
{0.8883865277204599,0.386094144926688,0.24839623309968736},
{0.8295856109623656,0.26369542624249737,-0.4921914630131104},
{0.7745107386658379,-0.5309073610815925,-0.34390476827266836},
{0.2734062720118207,-0.6580150950394223,-0.70161609525784},
{0.724404299352275,-0.566103359833411,0.39340233484978604},
{0.7320713436281194,-0.5701776808315172,0.3727854076008236},
{0.7627272679872547,0.15640559159985135,0.627522434328048},
{0.5658015701015355,0.14550040376418066,0.8116022521993748},
{0.3334956679194104,-0.725690573340678,0.6017921827703183},
{-0.18319207711399352,-0.0794965618480485,0.979857622074248},
{-0.38131524910172343,-0.8147325818074327,0.43681746867986576},
{-0.41831267088270446,-0.13820418626820405,0.8977271925685006},
{-0.3774961136975142,-0.9152905771320126,-0.14049855357483643},
{-0.2720053068753062,-0.47530927337438617,0.8367163244947379},
{-0.30091140174902253,-0.12790484640644728,0.9450358080851654},
{-0.07660114289757812,-0.0852012712124498,0.993414821859714},
{-0.6545968383049064,-0.09569953777234884,0.7498963780092414},
{-0.6821943582759854,-0.17989851224545556,0.7086941391237039},
{-0.8195795066706503,-0.142796429419923,0.5548861252459051},
{-0.898847150263933,-0.43292270955636025,-0.06820357771250582},
{0.4833904676339664,-0.28479438391012335,-0.8277836762668543},
{-0.5819886862499078,-0.2707947358015035,0.7667850938426621},
{-0.7602657089885266,-0.21959009561210108,0.611372424668664},
{-0.8041991756962674,-0.06849992978760797,0.5903993948409305},
{-0.9596416109623966,-0.09240400672459925,0.26561151716508186},
{-0.8511086004958622,0.1313013268066111,0.5083051364493558},
{-0.8811916948074144,-0.3029971442653729,-0.3628965797158542},
{-0.8804110580323338,-0.1676021050956601,-0.4436055717209715},
{-0.7239732134866422,-0.09699641119917722,-0.682974730402454},
{-0.7021678519808287,-0.3302848782530158,0.6307711208053357},
{-0.7758558511788973,-0.5491687504413589,0.31058232681552456},
{-0.9668456651991766,-0.07230341497093552,0.24491156744650222},
{-0.9482801858925216,-0.23289513370702128,0.21569549308975736},
{-0.8796802821874597,-0.274293851772218,0.38849129206528143},
{-0.913681315408148,0.01889961350685564,0.40599169755467673},
{-0.960503779589809,0.18280071932224579,-0.20980082556787288},
{-0.9497374298896825,0.14900587243715138,-0.2753108502144146},
{-0.810268428505763,-0.35278625395141694,0.4679817654457572},
{-0.9047103363746399,-0.11250128533452747,0.4109046946129541},
{-0.9931634820501352,-0.11669570917765885,-0.0028998933728809823},
{-0.9937961391094993,-0.10979957342948582,-0.01769993123590072},
{-0.7117432290378133,-0.5958361892099608,0.3720225954785254},
{-0.9559655046071383,-0.10089635922056513,-0.27559005551226706},
{-0.7784248087939907,-0.022900729857891045,0.6273199930067708},
{-0.9123162621823114,-0.1665029679418556,0.3741066685107998},
{-0.6249879753470303,-0.41179207719665134,0.6631872404002408},
{-0.7366070530462996,-0.6665063818291591,0.11480109922578766},
{-0.639774895725628,-0.6629739854112088,-0.3887847443859396},
{-0.7969174925309437,-0.2620057510893553,-0.544311947778382},
{-0.9386677244651819,-0.21919246319672725,-0.26619084718507663},
{-0.7587050264374503,-0.5309035172474527,-0.3775025009623533},
{-0.6448249777792808,-0.0010000387372507457,-0.7643296068807449},
{-0.670201105832737,0.2721004489661112,-0.6905011393278198},
{-0.5913143513734639,0.1624039415914942,-0.7899191715709439},
{-0.6043952222746518,0.1037991794707294,0.7898937559145391},
{-0.981309258696534,0.05700053780261127,0.183801734177543},
{-0.9186476606769859,0.14920774109841747,-0.3658189791809726},
{-0.9847564353389295,-0.0419981420432931,-0.16879253278352083},
{-0.6945050629603635,-0.38690282053184255,-0.6066044221623564},
{-0.3099060277308596,-0.522210157086334,-0.7945154534758566},
{-0.41201156738713385,-0.40721143262145854,-0.8151228848962447},
{-0.8573218191179484,0.016600422486128478,-0.5145130945248856},
{-0.722501510029734,-0.23390048885253256,-0.6506013597582628},
{-0.7083895584148628,0.08739871175248308,-0.7003896763322557},
{-0.5090041993019664,0.009900081676010742,-0.8607071008628733},
{-0.876569601093342,0.08679698993258281,-0.4733835833419896},
{-0.8513607318918415,0.07979631947964404,-0.5184760858420481},
{-0.9149115050845151,0.21280267601047634,-0.34300431330635994},
{-0.9592751598913478,0.059698454128545256,-0.2760928506681967},
{-0.9857346294658104,0.16830591269057105,0.0006000210791107702},
{-0.9991940598089716,0.03689978063145622,-0.01579990606983762},
{-0.9456325066761351,-0.2590089035840937,-0.19670676191116307},
{-0.8784672074312083,-0.39038542718399977,0.27548971616084},
{-0.27349879524046045,-0.6579971015291516,-0.7015969094724206},
{-0.7395960320779319,-0.6403965642816489,0.20709888891744144},
{-0.17739289200922292,-0.9712610823481298,-0.15869364127318872},
{-0.7745773787979735,-0.5308844957446994,-0.34378995976083565},
{-0.724404299352275,-0.566103359833411,0.39340233484978604},
{-0.2253014655908005,-0.87470568997902,0.4291027913227363},
{0.9199292772151284,-0.387512332776239,0.05970190004320379},
{-0.20380328839258754,-0.7527121451084428,0.6260101007544642},
{-0.4932141949087972,-0.6154177119766296,0.6148176947078842},
{0.04700223712471519,-0.14340682561030124,0.9885470510166163},
{-0.15460748241017122,-0.8093391689168925,0.5666274225976909},
{-0.10110268380636292,-0.745919800703918,0.6583174752693246},
{0.4452116001393644,-0.783820422707174,0.4329112796503388},
{-0.17900247204120845,-0.8603118809891153,0.47730659164954636},
{-0.09170557724427532,0.8462514663479365,0.5248319186237262},
{0.2720053068753062,-0.47530927337438617,0.8367163244947379},
{0.04540189829305228,-0.9961416495530699,-0.0751031401279345},
{0.37700594731572873,-0.9156144439317804,-0.139702203819648},
{0.5672120590565648,-0.7958169192475567,-0.21200450726373715},
{-0.48352088130014814,-0.28471229556598177,-0.8277357465400882},
{0.898847150263933,-0.43292270955636025,-0.06820357771250582},
{0.8698142302772119,-0.4932080689500126,-0.013000212685219309},
{0.8494256657842435,-0.5161155946682929,-0.11000332380064372},
{0.8811916948074144,-0.3029971442653729,-0.3628965797158542},
{0.9433774488316253,0.004399894821771414,-0.33169207099581316},
{0.7239732134866422,-0.09699641119917722,-0.682974730402454},
{0.5253018989697972,-0.12820046344551303,-0.8412030409544895},
{0.8231979708195027,-0.17379957158458403,-0.5404986676724262},
{0.9597740240675532,-0.27029268462748446,-0.07599794314350285},
{0.9178675723114952,-0.39688597826607735,0.0007999717374977625},
{0.9511230031880016,-0.30290732590226654,0.06010145357123215},
{0.9683636967255019,-0.24709073674191603,0.03489869167257333},
{0.9575241538514252,-0.19770498717120286,0.20990529492784768},
{0.7731359477916082,-0.6226289498060474,0.12080561698774579},
{-0.9709018884060094,0.11990023320618039,0.20730040319967635},
{-0.9106298645961222,0.20530673314472206,0.3586117608655495},
{-0.8189028456923332,0.036000125100652085,0.5728019904903755},
{-0.8656753718859999,0.3004914511398209,0.4003886091061041},
{-0.8072292827733585,-0.2060074730566301,0.5531200647942822},
{-0.9764149343806329,0.09010137811111739,0.1962030009478494},
{-0.8187999304020088,-0.21769998149550238,0.5311999548480058},
{-0.5126740234653299,-0.20168978063771606,0.8345577140319178},
{-0.6078206966470873,0.0885030135789194,0.7891268702274047},
{-0.5433246593492596,-0.08950406223404883,0.8347378854386655},
{-0.053903065554509605,-0.19331099390884426,0.9796557146047794},
{0.4478759698594884,-0.17969035897242702,0.8758530073675506},
{0.49419531999247934,-0.5552947413836985,0.6688936656069799},
{0.5830922886554734,-0.7321903168470891,0.35199534489234546},
{0.8037886465655503,-0.38089461990149054,0.4569935450117647},
{0.8975337209753574,-0.43351628751288857,0.08060302831266164},
{0.9922906179365609,-0.12389882854211419,-0.002899972580888871},
{0.9938245278920264,-0.08860218672895304,0.06680164868503456},
{0.9444318420563415,-0.2011067804294052,0.26000876634333836},
{0.9077113873107813,-0.32210404082053834,0.26890337341397935},
{0.9367706373845495,-0.11619635788224236,0.3300896535019639},
{0.7580387481409422,-0.4584234329126753,0.4639237140667323},
{0.749208263812725,-0.428904730845272,0.5047055669331051},
{0.5333811239760278,-0.4188851759159319,0.7348739932695592},
{0.7791753745514248,-0.02309926995910923,0.6263802035664945},
{0.30060094088241746,-0.2833008867331632,0.9107028505043832},
{0.3891091247159631,0.017700415079600483,0.92102159820972},
{0.4164847777595543,0.17689353465946014,0.891767406496928},
{-0.2822968989855969,-0.14179844235266612,0.9487895776037348},
{0.2932082788526318,0.23770671174376046,0.926026146717384},
{-0.18180434153951455,-0.1350032239154811,0.9740232599531748},
{-0.11519799902813517,-0.3428940439821836,0.9322838063709238},
{0.5510241408964306,0.15830693557877487,0.8193358958919157},
{-0.01759914382247905,0.2094898085687137,0.9776524383657822},
{-0.5056802156485866,-0.45598216004697545,0.7323713465315895},
{-0.15489957092878281,0.11079969308527522,0.9816972807022987},
{-0.5223825945019219,0.2597913438966296,0.8121729388485088},
{-0.4357028015780212,-0.03990025655947452,0.8992057819117666},
{-0.5071801265361049,-0.08369672040826494,0.8577663890825528},
{0.21939632623927546,0.4487924850327567,0.8662854941708492},
{-0.24158938721132459,0.15289328354557752,0.9582579046548525},
{0.1722953739313141,0.19289482084358958,0.96597406394457},
{0.556085883939002,0.14499631931515067,0.8183792257070298},
{0.746625415561726,-0.21940746875735692,0.6280213782115777},
{-0.9381628307249555,-0.33238683109462286,0.09679616501191184},
{-0.9448253736261176,-0.15020403378349162,-0.29110781780542216},
{-0.715291280652433,-0.2229972816797044,0.6622919267106198},
{-0.6186808521239356,-0.22949289730474096,0.7513767452495962},
{-0.4965930551946842,-0.3170955654495255,0.8079887003570376},
{-0.2558097363038491,-0.29681129685294144,0.9200350171991446},
{-0.07650213826464716,-0.01680046957968722,0.9969278645232257},
{0.7636236688824312,0.04160128945195015,0.6443199710070068},
{0.9032763073731823,-0.11489698629157385,0.41338915694461814},
{0.30748667842822935,-0.29958702067348786,0.9031608714028513},
{0.7106845001400761,-0.39919129373282447,0.5792873658803237},
{0.4868176766707657,-0.7185260901560089,0.4967180361593453},
{0.5894207096604572,-0.4784168094699062,0.6509228705768436},
{0.5961242925598927,-0.24520999251079637,0.7645311552793793},
{0.9185249428834906,-0.035000950463714944,0.3938106940745984},
{0.7890836621919097,0.11519761485807628,0.6033875069910003},
{0.8058971874237238,0.11439960074609011,0.5808979726696131},
{0.5774207961844686,0.026100940042283742,0.8160293898277214},
{0.4698289470531694,0.09570589662194191,0.8775540677717244},
{-0.02890070590836282,0.25870631897901253,0.9655235832015331},
{0.3344132028938805,0.06420253476610983,0.9402371212943376},
{0.2987064909625737,0.18460401148875494,0.9363203464621953},
{-0.4598989629290078,0.3904991194254785,0.7974982016435828},
{-0.53807734204018,0.39808323706782317,0.7429687142461507},
{-0.7627740928178987,0.2419917808887408,0.5996796322271812},
{-0.7589017796267598,0.05230012264393139,0.6491015221448541},
{-0.49281464420473203,0.04770141746868043,0.8688258175427581},
{0.007700310752310742,-0.6980281694951814,0.7160288959291546},
{0.048402309813337756,-0.43102056879232586,0.9010429987978785},
{0.11610229536506927,-0.12750252074975307,0.9850194740275042},
{0.5898992154345652,-0.043599942012115686,0.8062989276231395},
{-0.8129094216747961,-0.15850183704693713,0.5604064951489184},
{-0.6784798460555049,-0.2789917126742607,0.6795798133814608},
{-0.4749719181154875,-0.250985160941026,0.8434501324850815},
{-0.3758006971109397,-0.18910035078147602,0.9072016828606825},
{-0.4377029566934587,-0.3222021764830532,0.8394056702044534},
{-0.17349469548077726,-0.38308828725467303,0.9072722605746929},
{-0.10939716883790525,-0.48938733481966024,0.8651776094931958},
{0.22640257987209653,-0.3525040168061574,0.9080103468368537},
{0.32099653807100526,-0.14189846963325747,0.9363899010893749},
{-0.36520764570209496,-0.10470219196333336,0.9250193654831267},
{-0.3794038452774579,0.02440024729775955,0.9249093740040084},
{-0.2684037093648953,-0.013400185191839036,0.9632133116999522},
{-0.4639076243844606,0.04740077903820529,0.8846145387594178},
{0.1623073153555583,0.07810352020498525,0.9836443338492123},
{0.008099911468451472,0.14909837036371784,0.9887891925931871},
{-0.19769517135440873,0.11599716680380079,0.9733762255760318},
{0.3503894306622337,-0.12759615112015132,0.9278720111629186},
{0.2671056386595488,-0.35240743939956937,0.8969189341585522},
{-0.8576821561083613,0.09359805271276975,0.5055894813202606},
{-0.987950183867936,0.1237937578571361,-0.09289531587179277},
{-0.9847631213116474,0.06349762205858003,0.1618939371855765},
{-0.7249856889237496,-0.028199443348482397,0.6881864153342407},
{-0.743716194596458,0.038000827477027564,0.6674145331096895},
{-0.4982127743393032,-0.07480191794576452,0.8638221486838421},
{-0.5646755020847515,0.13519413472969435,0.8141646782316357},
{-0.5064880622170586,0.16669607101990852,0.8459800604849587},
{-0.8238854956235232,0.22999595095692482,0.5179908808508132},
{-0.5331064452958857,0.16140195136138802,0.8305100409270927},
{-0.5112934887188815,0.054299308502709295,0.8576890773991486},
{-0.7685889016563895,0.21539688969136914,0.6023913015324084},
{-0.99791342202579,-0.06250084064195999,-0.01620021789439603},
{-0.873918190796464,0.07900164443634358,-0.4796099831857011},
{-0.5874035068094036,0.20190120535379394,-0.783704678730898},
{-0.9465728290169091,0.3196908234066193,-0.04239878296040244},
{-0.9021304474164091,0.40801377069714545,-0.1403047353647292},
{-0.8966189816247637,0.4427093722566171,-0.009100192653117723},
{-0.9794938585927597,0.2004987428768232,0.01979987585516758},
{-0.7139086169290098,0.5739069270984153,0.40120484257167494},
{-0.7980956823140382,0.4704974546156558,0.37639796369252465},
{-0.9240999214515101,0.09559999187400105,0.369999968550004},
{-0.9911358500320552,0.07580274183475914,0.1091039463611111},
{-0.6745735538622211,0.23149092457619952,0.7009725189110836},
{-0.6531822206219288,0.2515931517276137,0.7141805602697205},
{-0.8937212574129144,0.12550298512400218,-0.43071024456500195},
{-0.9638667182568179,0.22929208268107518,-0.1355953179745041},
{-0.8206206470752239,0.547613778135989,0.16340411129916108},
{-0.6071914022306162,-0.2407965903444209,-0.7571892782757289},
{-0.7055029878114801,0.3628015364677604,-0.6088025782843786},
{-0.860380861040617,0.445690085734313,0.2471945012194799},
{-0.9280952713666386,0.36969811639289546,-0.044299774293224965},
{-0.6020830546108886,0.1237965157960937,-0.7887778001612173},
{-0.6431285201666042,-0.006100270522494613,-0.7657339572252664},
{-0.7146158432088678,0.1143025341152723,-0.6901153000258042},
{-0.9261643711419499,0.16129379514704872,-0.3408868863337192},
{-0.9749170319493236,0.2153037613895675,0.05640098533382075},
{-0.9479093227340338,0.24760243518192507,-0.20040197096307666},
{-0.9229132115971866,0.0014000200414303406,-0.38500551139334366},
{-0.6338149138403861,0.11210263780610175,-0.7653180081445999},
{-0.7355022248975955,0.12810038750425828,-0.6653020125416319},
{-0.9939742713089764,-0.10959716311414872,0.0018999508204095123},
{-0.7154862413318677,-0.007499855779160037,-0.6985865663094937},
{-0.7219113304872486,0.17300271529892508,-0.6700105158975712},
{-0.7561752243246559,0.24249205487798076,-0.6077800864116978},
{-0.409186243389742,0.012199589856683414,-0.9123693266588481},
{-0.6117090717128008,0.0599008883367611,-0.7888116981642262},
{-0.7994881756573224,0.4261936966418397,0.42329373953188815},
{-0.8194019747611387,0.07790018773967868,0.5679013686439476},
{-0.8457824713399202,0.0529989016091461,-0.5308889974395409},
{-0.9857285569699491,0.07660221919843573,-0.1499043427917169},
{-0.8833642023910324,-0.052997852305552096,-0.4656811286546342},
{-0.9281817892519406,0.06039881498687483,-0.3671927957480205},
{-0.8883012036489465,0.13620018455137511,-0.43860059430420795},
{-0.8990826973199835,0.12419760983999771,-0.4197919211822145},
{-0.9618048619358657,0.1776008977748074,-0.20830105296448412},
{-0.8980940815795034,0.06209959076504528,0.4353971307423626},
{-0.9518997572655927,-0.028299992783502755,0.3050999221995297},
{-0.9266308526878689,0.33281108112942237,-0.17490582358634607},
{-0.5988301997684806,0.5109257666361335,0.616731102533771},
{-0.703974819271064,0.32348842902583697,-0.6322773838424627},
{-0.5156245314206374,0.09930472453465729,-0.8510404892144345},
{-0.8710765378694245,-0.1354963504549501,-0.47208728450023574},
{-0.5019995958904879,0.2430998043047363,-0.8299993318508068},
{-0.5850023253888651,-0.04640018444109973,-0.8097032185766908},
{-0.18060458289943734,-0.747518968534493,-0.6392162203173885},
{-0.7466391958534065,-0.3901204799121536,-0.5388282865333718},
{-0.29100228001179584,-0.18930148318293114,-0.9378073477493546},
{0.9854487678503047,-0.06819645455848886,-0.15569190578822165},
{0.38128418275376086,-0.8147662001252671,0.4367818804795247},
{0.7691269468346319,0.42261480656912676,0.4794167966617117},
{0.5722048179848513,-0.8054067815536512,0.1546013017484411},
{0.30510871860620303,-0.3030086585961308,0.9028257986157985},
{-0.7321130829776902,-0.570110187960089,0.3728066621145785},
{-0.6400229612356089,0.6624237648788552,-0.3893139668890977},
{-0.7893195319534803,-0.6139151915193735,-0.009100225187858444},
{-0.3335157373113563,-0.7257342445782646,0.6017283932241172},
{-0.3475868944832106,-0.9358647138861819,0.05779782077425079},
{0.032701216834918063,-0.9902368473986504,0.1355050422364342},
{-0.5683272320517513,-0.15620748486095998,0.8078387085191002},
{0.00019999760804291164,0.6107926949630521,0.7917905302418871},
{-0.7145225435418787,0.6152194104786057,0.33311050980237905},
{-0.23429933693381472,0.4670986781126114,-0.8525975871522425},
{-0.6044795991577868,0.23139219064534633,-0.7622742736773876},
{-0.2893103791960338,0.1324047501056166,-0.9480340113302457},
{0.060402193243455735,0.18890685933259582,-0.9801355893693867},
{0.061901496177244116,-0.06710162186580099,-0.9958240693586381},
{-0.5857960693215623,0.016299890628100826,-0.810294562941724},
{-0.1570962336629463,-0.14769645901984196,-0.9764765892544055},
{0.2231031468920805,-0.21970309893406584,-0.9497133958019223},
{0.15279671185014107,-0.180796109309591,-0.9715790918429128},
{-0.3621992593032721,-0.002199995501013801,-0.9320980938613471},
{-0.6862721310546254,0.10119589051832738,-0.7202707503987275},
{-0.7786778118918707,-0.08169767205800159,-0.6220822740181492},
{-0.6321738127421994,0.36198500508174025,-0.6850716214958571},
{-0.7892115028414814,0.44700651516743817,-0.42110613766668503},
{-0.8888144477962744,0.20510333398179104,-0.4098066614614235},
{-0.9216907693131678,-0.11169888134130503,-0.37149627948339137},
{-0.965990098652233,0.006499933376024342,-0.2584973504157373},
{-0.9685294534285249,0.09820298639822524,0.22870695508425776},
{-0.5384812342559736,0.6403776832266026,-0.5476809136527331},
{-0.3073056252809566,0.46490851022817026,-0.8303151990588294},
{0.04869919695686323,0.2584957374404342,-0.9647840908415121},
{0.07010091622496262,-0.3361043929131232,-0.9392122755846634},
{-0.7627272679872547,0.15640559159985135,0.627522434328048},
{-0.6131952354915302,0.24889806606953993,0.7496941748988915},
{-0.8883865277204599,0.386094144926688,0.24839623309968736},
{-0.9923491274596125,0.10190504493412729,-0.06970345075474653},
{-0.3098925533714127,-0.013399678009606099,0.9506771555024267},
{-0.5604753116062736,0.06439716336742912,0.8256636303181091},
{-0.8588960276150585,0.10999949125352944,0.5001976865910492},
{-0.81520566977515,0.3871026923085875,0.43080299624525836},
{-0.8333671118158854,0.5270791992298455,-0.16639343341272297},
{-0.8652036598192216,0.12990054948048646,-0.48430204860199844},
{-0.6892205080613306,0.4048120453616173,-0.6009178805775589},
{-0.5796170380932558,0.47571398381808455,-0.6616194485895411},
{-0.6004215615254185,0.6201222689905262,-0.5049181319356826},
{-0.28670171734843036,0.5843034999884474,-0.7592045476488606},
{0.0837978527075362,0.5174867395721955,-0.851578178588757},
{0.22179628494334055,0.2850952246949793,-0.9324843810174259},
{-0.7737525356065101,0.2559842971249245,-0.579464453843335},
{-0.8623247878822966,0.10610304997600797,-0.4951142322631626},
{-0.808471950552255,0.3564876318761644,-0.4682837531770204},
{-0.4782986201104715,0.40119884254300886,-0.7811977462477531},
{0.03399971627355155,0.5336955463292488,-0.8449929485632663},
{0.2852024584557879,0.45160389284233454,-0.8454072874422268},
{-0.975559524874952,-0.0950960545465436,0.19809178134248462},
{-0.9780383740884259,0.1813071137241632,0.10280403359538873},
{-0.9574633585783874,-0.026998966769312228,-0.28728900566012605},
{-0.9620858670624184,-0.211596891664492,0.17209747190670638},
{-0.9274612236568415,0.1590933484461493,0.33838585238326163},
{-0.8893031392456223,0.2263007988432299,-0.397401402829428},
{-0.7527719785846361,-0.04299839941437214,-0.6568755482628154},
{-0.6290727837547535,0.26558850956169533,-0.7305683926422237},
{-0.6365847030533763,0.6884834559413283,-0.347491649875979},
{-0.8796900199733347,0.35159601116587985,-0.32019636739281776},
{-0.8949464435325822,0.446173299557808,-0.0004999700801858001},
{-0.8266198680472956,-0.14060337944283782,0.5449130971436866},
{-0.9933053191642263,-0.025800138160109773,0.11260060297784344},
{-0.737350989908497,-0.07569496872263795,0.6712553831374749},
{-0.7980141848282041,0.43390771277814255,0.4182074337032017},
{-0.9751507122528422,0.158591984170735,-0.1546921812812907},
{-0.8699757628128674,0.21159410507034798,-0.44538759167454156},
{-0.7728861422757024,0.2600953365324236,-0.5787896223951049},
{-0.8893247013366242,-0.19500541635065977,-0.41361148821863014},
{-0.5467923340252151,0.23439671378110905,-0.8037887309609874},
{-0.4340095982283984,-0.3284072628069264,-0.8389185528889479},
{-0.4241879235417227,-0.2108939959334024,-0.8806749275417142},
{-0.31110244838590323,0.14720115847767584,-0.93890738923023},
{-0.19560821473947057,0.38921634548365003,-0.9001378020807642},
{-0.7601164262934602,0.4454096254060087,-0.47311022402241293},
{-0.6432092494155104,0.6488093299452474,-0.40660584703412084},
{-0.5184241280203902,0.20800968099583556,-0.8294386029708943},
{0.47861254699238126,0.40311056768204945,-0.7800204485040898},
{0.4791242754463888,0.33051674605516906,-0.8131411988425356},
{0.23079713697927354,0.20159749919853356,-0.9518881919002187},
{0.18170292634919347,-0.06630106778729514,-0.9811158009972136},
{0.34838056787387084,-0.25938553187853647,-0.9007497575797442},
{0.8477524042773552,-0.31708219791973263,-0.4251761291563239},
{0.8321169295911506,-0.3469070578958901,-0.4327088035501633},
{0.7292955768357398,0.45699722832021544,-0.5091969117300956},
{0.6154028431677032,-0.27360126404075985,-0.7392034151276669},
{0.7845078686533841,0.3785037964121171,-0.491204926810124},
{0.0061998644724439314,-0.34879237548200703,-0.9371795134797505},
{-0.21690434572210024,0.157403153603774,-0.9634193022990842},
{0.37780387250953995,0.7229074098389264,-0.5785059297161695},
{0.860353916376671,0.0860953884240253,-0.502373091106043},
{0.45481799068143913,0.016300644784756943,-0.8904352218618149},
{0.8448640898150274,-0.228390292476923,-0.4837794373920112},
{0.3789006403426233,-0.30250051122629595,-0.8746014780777469},
{0.8987784116018268,-0.03259921697621223,-0.4371894988343554},
{0.6446230746959455,0.04580163949902932,-0.7631273166312069},
{0.9314150843894385,0.006200100411439252,-0.3639058935036683},
{0.8374996566252111,0.07759996818401957,-0.5408997782311364},
{0.9607839742569629,-0.06059898921728971,-0.2705954865049273},
{0.9058285974602398,0.14810467573842076,-0.3969125307263956},
{0.42900639009777114,0.41250614432477994,-0.803611969889438},
{0.8034242597617908,0.11690352995538131,-0.5838176286394492},
{0.37588647772719125,0.31448868647300254,-0.8716686422846306},
{0.41581249743241827,-0.11360341440193054,-0.9023271198491366},
{0.5847719667038581,0.08279603085341905,-0.8069613152018016},
{-0.10680371683401986,0.22000765639966638,-0.9696337438414387},
{0.3084867261017576,0.4033826428183112,-0.8614629320475338},
{0.6741722482705882,0.30868729314911086,-0.6709723799904549},
{0.4881038413923477,-0.38270301188455536,-0.7844061733008759},
{0.3242954047666714,-0.5060928287154253,-0.7991886755767},
{0.02559991270444652,-0.478898366959353,-0.8774970077403054},
{-0.2377030259787812,-0.36460464144662863,-0.900311461037849},
{0.15499833377686778,0.021099773178657487,-0.9876893823962084},
{-0.5222912412493258,-0.058099025687508764,-0.8507857324428995},
{-0.6088034306169974,-0.400502256836576,-0.6848038588806172},
{0.005200080367863133,-0.8602132946992053,-0.5099078806871946},
{-0.7091979220531326,-0.40209882185217793,-0.5790983032444571},
{-0.7331269978988055,-0.5505202732823523,-0.39931470503477434},
{-0.06009919527716282,-0.9973866450822328,-0.04009946307178418},
{-0.6916982188793795,-0.6774982554442383,-0.25009935599498745},
{-0.77340347645644,-0.5893026489213604,-0.2336010500390799},
{-0.5691207704415329,-0.8218299932329145,0.026400963520745856},
{-0.9457722514492078,-0.049798538932301274,-0.32099058227447214},
{-0.9486911108059375,-0.10879898055832823,-0.29689721808609976},
{-0.8335723842043594,-0.5472818688520225,0.07509751206063747},
{-0.5186239506070713,-0.8098373991546595,0.27421266343320283},
{-0.9558628272174601,-0.028898876144559677,-0.2923886292273097},
{-0.8134110950030042,-0.5530075430743316,-0.18040246070634616},
{-0.6936718583035514,-0.7035714566849918,-0.15429374042992358},
{-0.9149145518316711,-0.2123033767120601,-0.3433054603167698},
{-0.28659413491104296,-0.8660822758075866,-0.40959161779331194},
{-0.8747391760712702,-0.1597071526450004,-0.4575204905140118},
{-0.8599988605022647,-0.45409939831869583,-0.23279969154061306},
{-0.2058068184928469,-0.9539316042775833,-0.21830723263842797},
{-0.9094974261259261,-0.2949991651535439,-0.2928991710965187},
{-0.8473153111260093,-0.5199093948476481,-0.10840195884109455},
{-0.11109683267445002,-0.9933716793771254,-0.029499158990965575},
{-0.8047080672388113,-0.5831058456654044,-0.11150111780430902},
{-0.8301522925185841,-0.5568679977157305,0.027298431204236744},
{-0.10140178418008912,-0.994617500448882,0.021300374783391498},
{-0.7316307693790229,-0.6617278295490698,0.16380688904358115},
{-0.8066425716851107,-0.5680299785731997,0.16330861883979492},
{-0.14479897120696433,-0.9813930272273121,0.12609910406904834},
{-0.7210117489821752,-0.6071098929363087,0.33400544266303267},
{-0.7770129723398607,-0.41190687684271377,0.4760079470190137},
{-0.12319797710582375,-0.9201848906881414,0.37159389847828006},
{-0.5582872181604587,-0.5520873601045839,0.6192858216134194},
{-0.6407750294836422,-0.4310832010149783,0.635275243806114},
{-0.33791416058960544,-0.4897205221684812,0.8037336811656286},
{-0.04300059577738177,-0.8077111909160758,0.5880081469093136},
{0.1000014000294007,-0.2644037016777354,0.9592134290820115},
{0.27548951782326647,-0.10759590605366051,0.9552636529094971},
{-0.43081843080671334,-0.10560451785791301,0.896238341896417},
{-0.0711020914987826,-0.33640989564262264,0.9390276219037534},
{0.12250589880104432,-0.9303447971805023,0.34561664184196667},
{0.15199151834997113,-0.5434696725211139,0.8255539312482643},
{0.07370051074630922,-0.21510149065849543,0.9738067485041508},
{0.8564269093562447,-0.37521178933963445,0.3546111420571279},
{0.646423963380492,-0.5297196370709261,0.5491203562689174},
{0.7739257798970998,-0.3721123952703331,0.5124170688968521},
{0.15420142482774815,-0.9792090479334046,0.1318012178488794},
{0.7278493571384181,-0.5377364651460942,0.4255288560901304},
{0.8248604158984387,-0.5025758819621231,0.2588875762833141},
{0.13250210216252636,-0.989915705137244,0.050100794855415624},
{0.8106121673799492,-0.5291079419698139,0.25090376609379383},
{0.8660582873071134,-0.47857694989629895,0.1445930358441388},
{0.1775956338650115,-0.9829758338361841,-0.04709884208920069},
{0.8916162543124755,-0.45270825294667755,0.008700158605337075},
{0.8886226557234151,-0.4568116465613955,-0.04090104278537889},
{0.303810364667389,-0.8942305071941382,-0.3287112141743606},
{0.9530442365748847,-0.2264105090876746,-0.20110933470641063},
{0.9143069990468667,-0.3398026011988683,-0.2204016871813731},
{0.33239619408536647,-0.9154895177050331,-0.22669740432958058},
{0.8852979018464591,-0.22439946817389067,-0.4072990347024317},
{0.869619027472484,-0.48181054212999397,0.10780235874141418},
{0.98771155135414,-0.07260084907189487,0.13840161861639463},
{0.9710040539503879,-0.1964008199751351,0.13630056905606372},
{0.912572162410772,-0.26039205686145633,0.3152903822135837},
{-0.6053027995319218,0.6685030918339496,-0.43210199847636444},
{-0.8295856109623656,0.26369542624249737,-0.4921914630131104},
{-0.9070458205769688,0.4159210107805527,-0.06540330393134924},
{0.11839642389002379,-0.3522893592606029,-0.9283719589484636},
{-0.29169200045657967,0.24359331954481594,-0.9249746329185334},
{-0.2867007841277169,-0.005800015863065078,-0.9580026201407491},
{-0.10740306425313532,-0.26830765492659414,-0.9573273129378628},
{0.1668060284788058,0.22980830542223965,-0.9588346529105455},
{0.12469645555362563,0.16739524185787433,-0.9779722015352514},
{-0.6052100798578207,0.24130401895190373,-0.7586126347986498},
{-0.7942251693944335,-0.08730276666851429,-0.6013190561028366},
{-0.4701964053622214,-0.057399561182032134,-0.8806932671257091},
{-0.37109328141695935,-0.0047999130983600235,-0.9285831881535663},
{-0.19719936501906693,0.4275986231346502,-0.8821971593297203},
{-0.49498143854407534,-0.09059660269109743,0.8641675943228079},
{-0.4196852042589312,-0.12609555457958355,0.898868310956286},
{-0.5658015701015355,0.14550040376418066,0.8116022521993748},
{0.18309543457225771,-0.07949801774164111,0.9798755671073476},
{0.07829759669215372,-0.2140934285030666,0.9736701136545349},
{-0.45291323884746015,-0.10520307513082978,0.8853258784536464},
{-0.08180336668683542,-0.2279093798035427,0.9702399310460602},
{0.13719854227323247,-0.12209870270817556,0.9829895557914543},
{0.02910002124302326,0.10730007832908578,0.9938007254747944},
{-0.36961902847739164,0.04980256390198621,0.9278477668325864},
{-0.5778100424258068,0.1606027913007694,0.8002139078385784},
{-0.9815964809829236,0.030599890299589916,0.18849932423113397},
{-0.9696323620201327,0.08030268014667559,0.23100771001098458},
{-0.9895632235661816,-0.142394707999014,0.02209917869928518},
{0.4062992300636885,-0.2540995184818687,0.8776983367632277},
{0.7409025894590753,-0.01680005871630782,0.6714023465553018},
{0.8492037619809983,0.19510086429874327,0.49070217381544506},
{0.36499673329385546,0.18769832010755252,0.9118918386045666},
{0.3309833850510952,0.4027797809624808,0.8533571625456334},
{-0.38989104430556726,0.46078941578867755,0.797281686649984},
{-0.811380279641952,0.4722885211669879,0.3443916296631603},
{-0.8959079646572088,0.29460261902892476,0.3325029559644178},
{-0.7356051161513742,0.2407016740859649,0.6332044039519442},
{-0.9710837927467476,0.20759653524274,0.1178980322982613},
{-0.9968517728412686,0.024201256924918438,-0.07550392139798934},
{-0.9352846708098671,-0.008499860688424966,-0.35379420136055917},
{-0.46749554712612035,0.06779935421422664,-0.8813916047849464},
{-0.7999047554479067,-0.03830022769553048,-0.5989035604922507},
{-0.724436639309573,-0.0030001517365112083,-0.689334863992392},
{-0.650225056905361,0.160806196786192,-0.7425286138914651},
{-0.6208062422381487,0.17180172747505468,-0.7649076911855025},
{-0.10159947320809712,0.34659820289297705,-0.9324951650251041},
{-0.16099624561132803,-0.07399827438036195,-0.9841770492588139},
{-0.6391857942535824,0.19089575738893752,-0.7449834429269694},
{-0.3846075845363513,0.35420698503061787,-0.8524168098252363},
{-0.8942270194775965,0.041201244914422924,-0.445713467435881},
{0.7784248087939907,-0.022900729857891045,0.6273199930067708},
{0.7758558511788973,-0.5491687504413589,0.31058232681552456},
{0.9123162621823114,-0.1665029679418556,0.3741066685107998},
{0.6043952222746518,0.1037991794707294,0.7898937559145391},
{0.8124343017003419,0.10660450093704635,0.5732242020367257},
{0.7771914159682158,0.25609717142236244,0.5747936514391797},
{0.7541205613774128,0.3025082479998241,0.582915893418504},
{0.22301441054172078,0.6624428051248243,0.7151462106654014},
{-0.38490077942486756,0.6587013338715516,0.6465013091664766},
{-0.5348059363788409,0.7560083917397227,0.3774041892097505},
{-0.8713142286775324,0.4797078336928869,0.10340168856336149},
{-0.8561020503668659,0.5168012377404466,-0.0024000057480206495},
{-0.952250012947571,0.16989108180173507,0.25368668306709935},
{-0.7401029382144971,-0.06010023859842086,0.6698026591218351},
{-0.8747243439172415,-0.4405122596267805,0.20200562189468707},
{-0.9646533746059304,-0.09529539400844321,-0.24568812495146378},
{-0.772830338050392,-0.12020471872885237,-0.6231244612308479},
{-0.7905903509036505,-0.04629943491884521,-0.6105925477634316},
{-0.7961831808079564,0.009099807768591314,-0.6049872197799718},
{-0.8048097825223602,0.17960218307780307,-0.5657068762088707},
{-0.79710499387843,0.15910099677086714,-0.5825036493967952},
{-0.9114657887736656,-0.02009924558897496,-0.41088457773680653},
{0.810268428505763,-0.35278625395141694,0.4679817654457572},
{0.7021678519808287,-0.3302848782530158,0.6307711208053357},
{0.9047103363746399,-0.11250128533452747,0.4109046946129541},
{0.6249879753470303,-0.41179207719665134,0.6631872404002408},
{0.7366070530462996,-0.6665063818291591,0.11480109922578766},
{0.9847689113361959,-0.04209867096593608,-0.16869467439319277},
{0.9202987944093689,0.1572997939374049,-0.358199530758922},
{0.981309258696534,0.05700053780261127,0.183801734177543},
{0.9751631590317644,-0.030398851553082074,0.2193917115377042},
{0.9761845080747843,0.1610974434038596,0.14529769414389077},
{0.9075972000669565,0.2295992916872777,0.3514989156275179},
{0.9415665514423796,0.12319562355320854,0.3134888635059324},
{0.9555161388038776,0.04740080060628341,0.2911049168035676},
{0.7773355483674588,0.5590255648236324,0.28851319401005},
{0.19820525548202458,0.841722318563169,0.5022133163626273},
{-0.360291877311188,0.7877822396496083,0.49958873689888844},
{-0.235705542681005,0.952222391772817,0.19420456677408218},
{-0.5554102168649097,0.8266152057265653,0.09070166847253747},
{-0.889735692463219,0.4522181410946023,-0.06220249530314963},
{-0.9515912787058958,0.1955982073506444,-0.23709782700837315},
{-0.986871928827221,0.0627982137302153,-0.14879576756458657},
{-0.9826775853799135,0.1852957734516108,0.003199927010497327},
{-0.8714147923916523,0.48350820762148716,-0.08280140556578933},
{-0.9829757207995408,0.15579615188257218,0.09739759430913049},
{0.5819886862499078,-0.2707947358015035,0.7667850938426621},
{0.9668521855074693,-0.07229642466872482,0.24488788936888947},
{0.9482801858925216,-0.23289513370702128,0.21569549308975736},
{0.9931634820501352,-0.11669570917765885,-0.0028998933728809823},
{0.639774895725628,-0.6629739854112088,-0.3887847443859396},
{0.6943842897331652,-0.38699124442214133,-0.6066862738783285},
{0.7224676991912377,-0.23408953409089098,-0.6505709136246631},
{0.9885903118624153,0.04079960016587755,-0.14499857902088834},
{0.9915028852775942,-0.03670010679746617,-0.12480036316958523},
{0.9843059747554002,0.059600361775293965,-0.16610100823618},
{0.9883813691867848,-0.0366993082245599,-0.14749721970361265},
{0.9777843262428744,-0.14209772219176975,0.1540975298363949},
{0.9803732900935621,0.1932947337567172,0.038798942937199314},
{0.9344630614052595,0.31908738672489917,0.15799375463031673},
{0.6250132972993515,0.7498159525040861,0.21710461894990274},
{0.1206990452743278,0.9561924365477402,0.26669789042803},
{0.3010023463224344,-0.12790099699215737,0.9450073663611313},
{0.07660114289757812,-0.0852012712124498,0.993414821859714},
{0.6545968383049064,-0.09569953777234884,0.7498963780092414},
{0.7602657089885266,-0.21959009561210108,0.611372424668664},
{0.8796802821874597,-0.274293851772218,0.38849129206528143},
{0.7117432290378133,-0.5958361892099608,0.3720225954785254},
{0.9937961391094993,-0.10979957342948582,-0.01769993123590072},
{0.9386677244651819,-0.21919246319672725,-0.26619084718507663},
{0.7969174925309437,-0.2620057510893553,-0.544311947778382},
{0.41831267088270446,-0.13820418626820405,0.8977271925685006},
{0.6821943582759854,-0.17989851224545556,0.7086941391237039},
{0.8041991756962674,-0.06849992978760797,0.5903993948409305},
{0.913683037631858,0.01879965098771909,0.405992462819891},
{0.960503779589809,0.18280071932224579,-0.20980082556787288},
{0.9559655046071383,-0.10089635922056513,-0.27559005551226706},
{0.7587050264374503,-0.5309035172474527,-0.3775025009623533},
{0.8195795066706503,-0.142796429419923,0.5548861252459051},
{0.9596327384293167,-0.09250315579899104,0.2656090614076975},
{0.9497374298896825,0.14900587243715138,-0.2753108502144146},
{0.5913143513734639,0.1624039415914942,-0.7899191715709439},
{0.670201105832737,0.2721004489661112,-0.6905011393278198},
{0.6448249777792808,-0.0010000387372507457,-0.7643296068807449},
{0.41201156738713385,-0.40721143262145854,-0.8151228848962447},
{0.3099060277308596,-0.522210157086334,-0.7945154534758566},
{0.8511086004958622,0.1313013268066111,0.5083051364493558},
{0.8804110580323338,-0.1676021050956601,-0.4436055717209715},
{0.9953725380505075,-0.006099831707964735,-0.09589735422849475},
{-0.8109398546185069,0.5829286487324302,-0.05070249183519337},
{-0.8007943584236172,0.5487961337448566,-0.2398983099223599},
{-0.24559505744920276,0.8532828278558823,0.45999074277945146},
{-0.34150196364193647,0.926505327420949,0.15800090850783588},
{-0.7302852374331364,0.4702904931737698,0.4954899837712161},
{-0.7029930228288724,0.6996930555808848,0.1273987355738241},
{-0.028801076892397887,0.8117303511652557,0.5833218108102669},
{0.500905655256772,0.681907698781379,0.5330060176719095},
{0.1804052083735497,0.2839081965479532,0.9417271880563844},
{-0.9350058064040867,-0.015300095013885054,0.3543022002234951},
{-0.9616689482109853,0.13879551836506682,0.23649236378485808},
{-0.9900425628446847,-0.10210438956206293,0.09690416599964641},
{-0.9823291657859047,0.1837054542959083,-0.035801062949338686},
{-0.3969997221002918,0.3693997414202715,0.8401994118606174},
{0.8693621792210716,0.3492848046951004,0.3495847916444521},
{0.7091619580271151,0.1555916535096152,0.6876631113018148},
{0.95653570814449,-0.007800291190305302,0.2915108823043584},
{0.8745692463131707,0.031398895877239374,0.48388298455401696},
{-0.9866210843178602,0.05710122026611576,-0.15270326330360556},
{-0.967682296414329,0.03229940908771606,-0.2500954245460615},
{-0.9769918030731581,0.01569986827865771,-0.2126982154694583},
{-0.4644966881504203,0.32849765782004964,-0.8223941363507118},
{0.40530468940238473,0.011400131900289134,-0.9141105763205524},
{0.3386069398203482,-0.25640525507955486,-0.9053185546939196},
{0.1283057193549132,-0.024001069871534816,-0.991444194609984},
{0.5207945603292259,-0.3084967777679842,-0.7959916859102607},
{0.5476056376290592,-0.13540139396452633,-0.8257085007127725},
{0.5367127658649559,0.1385032943400343,-0.8323197969618089},
{0.5539776723798631,-0.3089875465079019,-0.7730688420882167},
{0.7310304846068253,0.012600525452867304,-0.6822284495195298},
{0.8448972160682596,0.015699948268755683,-0.5346982381722079},
{0.91145801009669,-0.20499055630260168,-0.356683567966527},
{0.8203825055296023,-0.2242952169554971,-0.5259887834087894},
{0.8963843089300071,-0.3933931137138162,-0.20429642382240124},
{0.8872674423185453,-0.3880857594543305,0.24929085244000151},
{0.856012305265333,-0.3914056264963217,-0.33770485454217636},
{-0.4212809374688596,0.46547893755460273,-0.7783647797905537},
{-0.12039499889561664,0.4583809592504208,-0.8805634221551497},
{-0.34028850694976337,0.23889193156126498,-0.9094692831936815},
{-0.061001525057189886,0.12700317511906747,-0.9900247509281637},
{0.2144907931802999,0.3113866340155962,-0.925760262593574},
{0.29340864247884824,0.6928204073256511,-0.6587194028657714},
{0.3911956108098699,0.771991338305776,-0.5009943788746033},
{-0.08360010533619908,0.7434009366857703,-0.6636008361375803},
{-0.22269152786198065,0.2847891654022995,-0.932364528866236},
{0.0412012729329912,0.6066187417755452,-0.7939245286772261},
{-0.1846091226852018,-0.11510568808811877,-0.9760482326151514},
{-0.22021073113039835,0.13150640846343042,-0.9665471009878747},
{0.17319432884455144,0.744575619270514,-0.6446788903353483},
{-0.2773985949796746,0.8638956243797437,-0.42039787069017737},
{0.11259956874447757,0.24129907582630938,-0.963896308284209},
{-0.38569597914037607,0.9143904675290637,-0.12299871774505122},
{-0.5764144307159118,0.2511062865245757,-0.7776194679470732},
{-0.5551033889165341,-0.042300258243864866,-0.830705071469942},
{-0.11080338121676753,-0.05480167229854568,-0.9923302814205633},
{0.2090894140709416,-0.016899144417976623,-0.9777504977454169},
{0.26600859221629514,-0.050801640919502976,-0.9626310934864875},
{0.0,-0.014799859032014077,-0.9998904760885726},
{-0.0015999718327438248,0.4323923877990186,-0.9016841259906917},
{0.12439577496925353,0.5423815783225331,-0.8308717799192343},
{0.2958074219013244,0.6893172951879072,-0.6613165926414667},
{0.13799347996210407,0.09089570527938592,-0.9862534006277045},
{-0.9218081488200536,0.16280143917108347,-0.3518031099532381},
{-0.6720778856410036,0.3717877665248105,-0.640378928678022},
{-0.9007833311586839,0.06489879905883501,-0.4293920541735556},
{-0.7578022393089258,0.13340039419874727,-0.6387018873668657},
{-0.75970020132058,-0.19830005254952088,-0.6193001641145651},
{-0.34331136207754503,-0.2596085918885252,-0.90262987302998},
{0.1711965581277979,-0.3705925493116934,-0.912881646698988},
{0.2862958616232301,-0.3120954886923161,-0.9058869054994207},
{0.0,-0.45491722804164514,-0.8905337251507693},
{0.0,-0.673702462387,-0.7390027010598086},
{0.26438538914519216,-0.6245654843422354,-0.7348593891180094},
{0.4695018662736276,-0.6862027276612637,-0.5556022085231683},
{-0.013299705680769892,-0.8115820398881838,-0.5840870742960672},
{0.15429672508676467,-0.9413800194211295,-0.2999936327027181},
{0.5524176058296512,-0.8255263099427534,-0.11550368116097884},
{0.5654348544786783,-0.6634408957572605,-0.4900302063929118},
{0.3344034895186198,-0.7536078639390906,-0.5659059052589323},
{0.14370142911781889,-0.6279062445586533,-0.7649076070439782},
{-0.20108839150222818,-0.6840605103265754,-0.7011595232290523},
{-0.4865887866906146,-0.5386875860876162,-0.687784150196886},
{-0.5176008048698774,-0.4547007070601492,-0.7248011270666289},
{-0.8805233782060412,-0.16910448978380643,-0.442811756808217},
{0.4157077592577405,-0.5407100924480641,-0.7313136500966697},
{-0.12639696018966073,-0.4514891418167074,-0.8832787574013237},
{0.852499339313268,-0.4116996809328709,-0.32209975037279015},
{0.8527993774566817,-0.41509969697733184,-0.3168997686632533},
{0.2066051486644579,-0.8864220899137245,-0.4142103222498474},
{0.8321689190712983,-0.5544792905852377,-0.0068997422994375845},
{0.8083256647472901,-0.06050192096648651,-0.5856185936855289},
{0.777938718973589,0.016200806334197376,-0.628131262870949},
{0.25440084970025706,-0.1610005377426941,-0.9536031850399571},
{0.8954912107968989,-0.0496995122016816,-0.44229565888941197},
{0.9493868178555506,0.10789850183970287,-0.294995904010309},
{0.9809864183370565,0.04619936037428339,-0.1884973902716974},
{0.09519601232256396,-0.9954583011251305,-0.000699970678842382},
{0.7072908724701857,-0.6403917357979738,0.29939613631779105},
{0.982731536361011,-0.09580307436998559,0.15830508009153152},
{0.9994722100615434,-0.025599288221686355,-0.019999443923192462},
{0.6535015357304135,-0.7059016588708475,0.27320064202226313},
{0.02290012446251468,-0.9794053230823965,0.20060109026988843},
{0.7038797637476842,-0.6109824345075082,0.3622895843241739},
{0.929073215205303,-0.18589464073476034,0.31979078056469257},
{0.5753881902785906,-0.6609864333926805,0.4816901134118823},
{0.4434082341673634,-0.4659086520040023,0.7657142194450839},
{0.4777956473014795,-0.3416968871555369,0.8092926273777467},
{-0.45180165133805344,-0.13130047990413107,-0.8824032251896821},
{-0.5214103918126642,0.2987059532689736,-0.7993159305252446},
{-0.4265061523956228,0.8613124245213362,-0.27610398282867865},
{-0.051000005100000766,0.996200099620015,0.07060000706000105},
{-0.7170851780025543,0.21869547961115415,-0.6617863210181154},
{-0.7974964870357119,0.339998502309896,-0.4983978045625063},
{-0.7633902592024385,-0.05499929821343217,-0.6435917878211808},
{-0.6717917739600915,0.7372909719273228,-0.07139912572305826},
{-0.8762921922713501,0.4757957606786585,0.07569932552201439},
{-0.8996088297039956,0.3985039113350848,0.17860175298480838},
{-0.7844016786213883,0.08500018190058391,0.6144013148202205},
{-0.9474868963468347,0.20789712480264586,0.2429966393797159},
{-0.7751173201900317,0.5517123281497103,-0.30790688025610985},
{-0.23580137590504263,0.958705594063462,0.15900092777312033},
{-0.9256711843045419,0.3715884326321354,0.07109778676034668},
{-0.908177745377021,0.16639592251787744,0.3840905879754611},
{-0.8416637503228935,0.12649455199696572,0.5249773897107273},
{-0.9897406494832286,-0.08040330223143537,-0.11810485066582731},
{-0.2641959261302284,0.45539297789442096,-0.8501868902192284},
{-0.6268214972118766,0.7786267034607005,0.028900991176488887},
{-0.5493958355953492,-0.17139870080277186,-0.8177938011464809},
{-0.9633795717527691,0.15009681723073556,0.2221952883988637},
{-0.6337060899447867,-0.2325022343572083,0.7378070903602076},
{-0.39191464612399357,0.5258196502475014,0.7549282121944444},
{-0.8229760805478233,0.5566838202198946,-0.11319670998543573},
{-0.978121924848671,-0.20800466247676472,-0.0034000762135625003},
{0.5743061049063429,-0.3903041489551552,0.719607649469971},
{0.46868084540526445,-0.8821639466962328,-0.046098116008497315},
{0.8282901682540539,-0.3900953695954442,-0.40219522597100144},
{0.8942926042307445,0.10329914571959735,0.43539639928666685},
{0.6233088167655703,-0.5841082622698052,0.519907354141537},
{0.894818952466122,-0.2712057441984938,0.3546075106666147},
{0.7847079962152224,-0.24520249862619156,0.5693058012556724},
{0.7506385312647401,-0.6253320991204929,-0.21331094953206642},
{0.77385129146339,-0.614161342830875,0.15479025703389684},
{-0.9114935375337283,-0.39879717253807,0.10069928604459291},
{-0.5830825019566704,-0.05749827450267288,0.8103756809907148},
{-0.9227277652961929,0.06570197700223245,0.3798114286978369},
{-0.7898115945193119,-0.3798055755867748,0.48160707004368275},
{-0.6923894965310058,-0.39729397309614184,0.6022908633169046},
{-0.6542777091381681,-0.2121927707154505,0.7258752698508272},
{-0.4369995367807365,-0.4255995488647173,0.7923991600573355},
{-0.8073183707385416,-0.5078115553834156,0.30060684038648033},
{-0.7256900036890482,-0.5208928247507583,0.4494938082654364},
{-0.5485188968014978,-0.062102139455557,0.833828725894419},
{-0.5571928011155141,-0.20059740829822706,0.8057895892657595},
{-0.6339874059652695,-0.5206896566027064,0.5717886415314528},
{-0.9307347449765571,-0.26220978847410903,-0.25490951594984895},
{-0.6783115415690705,0.07620129657609195,0.7308124348793701},
{-0.37729568942137237,-0.8565902135127155,0.3519959784689188},
{-0.052098249007275804,-0.42948556523272474,0.9015696987516288},
{-0.3254044060054862,-0.032600441412965114,0.9450127955598784},
{-0.11660312675476645,0.499513394631268,0.8584230189218828},
{-0.277808195462651,0.04400129805743932,0.9596283094526994},
{-0.13719804631373064,0.21919687865867174,0.9659862444538179},
{-0.08599832390900036,-0.1756965757071089,0.9806808867157751},
{-0.05290017827390118,-0.5179017453318228,0.8538028773205449},
{0.0018001013305559256,-0.8293466852389051,0.5587314518786642},
{0.005499814824352243,-0.9577677525026507,0.2874903203638673},
{0.36659534243576136,-0.6508917304730963,0.6647915538769616},
{-0.05599993616010916,0.25919970451250524,0.9641989008138795},
{-0.09250286624571662,0.2907090077581602,0.952329508386983},
{-0.04639876348942929,0.6802818707297144,0.7314805063042571},
{-0.006200231613977991,0.719826889635703,0.6941259295584071},
{0.06330002595301595,0.880500361005222,0.4698001926181185},
{0.6409156866033968,-0.7120174268397854,0.28680701968771133},
{0.6576922721612029,-0.7410912922284741,-0.13499841377795713},
{-0.6344736762332484,-0.7171702452237758,0.2882880391773767},
{-0.3231086561968508,0.16410439641567076,-0.9320249692833952},
{0.7021803076294049,-0.6622814265778336,-0.26139266934538086},
{0.6513791822539973,-0.6469793228712561,-0.39638733166331674},
{0.9038140092257154,-0.0916014198330112,-0.4180064791506406},
{0.8862692204044538,-0.44838442787922494,0.11609596805704285},
{0.9775082355415768,-0.21010177011486986,0.018300154179448445},
{0.9759646658388984,0.003999855187864338,-0.2178921113589098},
{-0.641007775471475,-0.6585079877503374,-0.3943047829460259},
{0.8153972358080559,-0.5298982036481344,0.2330992097950182},
{0.7741702182445451,-0.4858813085055857,0.4056843936215603},
{0.9517311554293177,-0.2542083216456158,0.17200563069648275},
{0.5705178146969002,-0.47311477323944523,0.671320962324328},
{0.8693120183217306,-0.18850260606654345,0.4569063167734944},
{0.5413679492593181,-0.07019584417806451,0.8378503965356162},
{-0.7329021950453612,0.0134000401331803,-0.6802020372081522},
{-0.5539947869335824,-0.30889709329202814,-0.7730927252316832},
{-0.5367127658649559,0.1385032943400343,-0.8323197969618089},
{-0.07009855983988197,-0.33619309298385625,-0.93918070473063},
{-0.04869919695686323,0.2584957374404342,-0.9647840908415121},
{-0.1283057193549132,-0.024001069871534816,-0.991444194609984},
{-0.5476056376290592,-0.13540139396452633,-0.8257085007127725},
{-0.5207945603292259,-0.3084967777679842,-0.7959916859102607},
{-0.3386069398203482,-0.25640525507955486,-0.9053185546939196},
{-0.2231031468920805,-0.21970309893406584,-0.9497133958019223},
{-0.5252951620538361,-0.12829881837332413,-0.8411922526550294},
{-0.061901496177244116,-0.06710162186580099,-0.9958240693586381},
{-0.40530468940238473,0.011400131900289134,-0.9141105763205524},
{-0.8231979708195027,-0.17379957158458403,-0.5404986676724262},
{-0.856012305265333,-0.3914056264963217,-0.33770485454217636},
{-0.9178675723114952,-0.39688597826607735,0.0007999717374977625},
{-0.8963843089300071,-0.3933931137138162,-0.20429642382240124},
{-0.8872674423185453,-0.3880857594543305,0.24929085244000151},
{-0.7731359477916082,-0.6226289498060474,0.12080561698774579},
{-0.8448972160682596,0.015699948268755683,-0.5346982381722079},
{-0.9131020727440577,-0.20090045604455284,-0.35480080539874237},
{-0.820400902441489,-0.2242002466204069,-0.5260005786009547},
{0.2893103791960338,0.1324047501056166,-0.9480340113302457},
{0.1570962336629463,-0.14769645901984196,-0.9764765892544055},
{-0.15279671185014107,-0.180796109309591,-0.9715790918429128},
{0.3621992593032721,-0.002199995501013801,-0.9320980938613471},
{0.3231086561968508,0.16410439641567076,-0.9320249692833952},
{0.3073056252809566,0.46490851022817026,-0.8303151990588294},
{0.2910993173729012,-0.18919955632756064,-0.9377978008667355},
{0.5857960693215623,0.016299890628100826,-0.810294562941724},
{0.6862721310546254,0.10119589051832738,-0.7202707503987275},
{0.6321738127421994,0.36198500508174025,-0.6850716214958571},
{0.5384812342559736,0.6403776832266026,-0.5476809136527331},
{0.584999608050394,-0.04649996884503132,-0.8096994575015453},
{0.7219592104568812,0.17299022632831085,-0.6699621482079091},
{0.9685072977299827,0.09820073994536323,0.22880172402748583},
{0.8888144477962744,0.20510333398179104,-0.4098066614614235},
{0.7561752243246559,0.24249205487798076,-0.6077800864116978},
{0.7892115028414814,0.44700651516743817,-0.42110613766668503},
{0.7787262513044046,-0.08170275424626924,-0.6220209686802873},
{0.9216907693131678,-0.11169888134130503,-0.37149627948339137},
{0.7039975888123874,0.3233988923606905,-0.6322978343836257},
{0.9857210010096421,0.0767016341457234,-0.14990319372156372},
{0.8513607318918415,0.07979631947964404,-0.5184760858420481},
{0.965990098652233,0.006499933376024342,-0.2584973504157373},
{0.9149115050845151,0.21280267601047634,-0.34300431330635994},
{0.7083895584148628,0.08739871175248308,-0.7003896763322557},
{0.6400229612356089,0.6624237648788552,-0.3893139668890977},
{0.7893572258908621,-0.6138667354628835,-0.009099506911080371},
{0.5683949299398373,-0.15619860671464214,0.8077927945204092},
{0.7144296280110232,0.615325518078363,0.3331138145163379},
{-0.919940243666208,-0.38751695229987565,0.05950260299830348},
{-0.3050994721783697,-0.3030994756383607,0.902798438160053},
{-0.7690423778133648,0.4231682931876427,0.47906410507136016},
{-0.9854420429305674,-0.06829598328986072,-0.15569084331231794},
{0.09270383662766989,0.8463350262998601,0.5245217077800739},
{-0.4137981854989349,-0.7612966617214575,0.49919781102239796},
{-0.5722048179848513,-0.8054067815536512,0.1546013017484411},
{-0.032700773545947456,-0.9902234240121458,0.1356032077318188},
{0.3475868944832106,-0.9358647138861819,0.05779782077425079},
{-0.0006000144245201503,0.6110146889696865,0.7916190307502516},
{-0.22039429516750345,-0.17559545477047914,0.9594751643068037},
{0.5026115702515224,-0.6216143097261168,0.6008138308935825},
{0.05820067338568663,0.3801043978333245,-0.9231106804523597},
{-0.0978032212021363,0.41351361929533087,-0.9052298142349058},
{-0.3310090548765459,0.7115194638811554,-0.6198169553247225},
{0.20279007975194188,0.12699378761586103,-0.9709525021653627},
{0.2858054703690548,0.8622165029818021,-0.41820800457781215},
{0.4192904675395795,0.9052794187063709,-0.06829844725245238},
{-0.2144907931802999,0.3113866340155962,-0.925760262593574},
{-0.2743048346653168,0.695112251461399,-0.6645117121221401},
{-0.3951096348659207,0.7739188722418022,-0.4949120685779402},
{0.22279290527289558,0.28469093416155017,-0.9323703091402507},
{0.1846091226852018,-0.11510568808811877,-0.9760482326151514},
{-0.17319432884455144,0.744575619270514,-0.6446788903353483},
{0.0603983254796388,0.12769645966473303,-0.9899725533914306},
{0.12009846214903822,0.4587941251788404,-0.8803887266945315},
{0.08319868172733196,0.7431882242758787,-0.6638894807545155},
{-0.0412012729329912,0.6066187417755452,-0.7939245286772261},
{-0.2862958616232301,-0.3120954886923161,-0.9058869054994207},
{-0.26600859221629514,-0.050801640919502976,-0.9626310934864875},
{-0.20899378775198724,-0.016899497669897533,-0.9777709361908762},
{0.34369093527112177,0.23549378893322423,-0.9090760234360686},
{0.4206957131325247,0.4657952535705491,-0.7784920672062525},
{0.585375095746316,0.2452895643774706,-0.7727671233220925},
{0.5601995574425244,-0.037699970217035285,-0.8274993462757746},
{0.7554248349996826,0.139004569850352,-0.6403210509005782},
{0.6720804225824311,0.37108919032932625,-0.6407813343115933},
{0.8883027803920539,0.052900165577777394,-0.45620142791270407},
{0.9195915535903701,0.16049852582781038,-0.3585967063043788},
{0.8889737756604212,0.13699595867882758,-0.43698710907042077},
{0.9282640304657158,0.0609976363873841,-0.3668857834513316},
{0.8834907366481891,-0.053399440109805664,-0.46539512035774444},
{0.7547877234775157,-0.19699679587317248,-0.6256898232377869},
{0.8804098562435113,-0.16840188526965846,-0.44330496282683846},
{0.8710822083275905,-0.1357972263699768,-0.4719903596953538},
{0.7466834462114942,-0.3900913517705958,-0.5387880552012227},
{0.5020743898385449,0.24308760041774602,-0.8299576649392397},
{0.11790396105010835,-0.05620188813414834,-0.9914333077614708},
{0.3517173031583538,-0.25941276212475683,-0.8994442492482894},
{-0.16729391563093074,-0.3706865183764855,-0.9135667741806236},
{0.12189405049658933,-0.45237791997257604,-0.88345687952204},
{0.5167942429442002,-0.4549949313846964,-0.725191921406993},
{0.20070241045042433,-0.6835082089828851,-0.7018084287698446},
{0.48607859843045625,-0.5396762385783116,-0.687369735776786},
{0.18060458289943734,-0.747518968534493,-0.6392162203173885},
{-0.14370560103495264,-0.6270244387537599,-0.765629841004591},
{-0.3344034895186198,-0.7536078639390906,-0.5659059052589323},
{-0.5698007806276042,-0.8141011153192921,-0.1121001535773156},
{-0.5653973398117743,-0.6634968782545316,-0.48999769456627057},
{-0.45828082364014383,-0.6895711454991124,-0.560776534796842},
{-0.36028472965534347,-0.9017617796369379,-0.23878987910545663},
{-0.26440481749966266,-0.6246113805230307,-0.7348133884219067},
{-0.41542916207358355,-0.5407379584332851,-0.7314513460294151},
{-0.2066051486644579,-0.8864220899137245,-0.4142103222498474},
{-0.09519601232256396,-0.9954583011251305,-0.000699970678842382},
{-0.8527993774566817,-0.41509969697733184,-0.3168997686632533},
{-0.852499339313268,-0.4116996809328709,-0.32209975037279015},
{-0.982731536361011,-0.09580307436998559,0.15830508009153152},
{-0.7072908724701857,-0.6403917357979738,0.29939613631779105},
{-0.6535015357304135,-0.7059016588708475,0.27320064202226313},
{-0.02290012446251468,-0.9794053230823965,0.20060109026988843},
{-0.7038797637476842,-0.6109824345075082,0.3622895843241739},
{-0.5753881902785906,-0.6609864333926805,0.4816901134118823},
{-0.4434082341673634,-0.4659086520040023,0.7657142194450839},
{-0.912572162410772,-0.26039205686145633,0.3152903822135837},
{-0.4777956473014795,-0.3416968871555369,0.8092926273777467},
{-0.5847719667038581,0.08279603085341905,-0.8069613152018016},
{-0.3084867261017576,0.4033826428183112,-0.8614629320475338},
{-0.25440084970025706,-0.1610005377426941,-0.9536031850399571},
{-0.3242954047666714,-0.5060928287154253,-0.7991886755767},
{-0.777938718973589,0.016200806334197376,-0.628131262870949},
{-0.8083256647472901,-0.06050192096648651,-0.5856185936855289},
{-0.8321689190712983,-0.5544792905852377,-0.0068997422994375845},
{-0.9994722100615434,-0.025599288221686355,-0.019999443923192462},
{-0.9710040539503879,-0.1964008199751351,0.13630056905606372},
{-0.929073215205303,-0.18589464073476034,0.31979078056469257},
{-0.8954912107968989,-0.0496995122016816,-0.44229565888941197},
{-0.9493868178555506,0.10789850183970287,-0.294995904010309},
{-0.8037713983036779,0.11519590082680231,-0.5836792301441364},
{-0.9809864183370565,0.04619936037428339,-0.1884973902716974},
{-0.9953725380505075,-0.006099831707964735,-0.09589735422849475},
{-0.9073958441365507,0.14519933498856863,-0.3943981936604095},
{-0.98841007194995,-0.035900365826591674,-0.14750150304797413},
{-0.9608249577524206,-0.03750097410045355,-0.2746071330129212},
{0.9823291657859047,0.1837054542959083,-0.035801062949338686},
{0.8047080672388113,-0.5831058456654044,-0.11150111780430902},
{0.8473153111260093,-0.5199093948476481,-0.10840195884109455},
{0.9094974261259261,-0.2949991651535439,-0.2928991710965187},
{0.2058068184928469,-0.9539316042775833,-0.21830723263842797},
{0.11109683267445002,-0.9933716793771254,-0.029499158990965575},
{0.8301985180969679,-0.5567990061146612,0.027299951269630477},
{0.9900445442079908,-0.10209428134899087,0.09689457260251925},
{0.9616689482109853,0.13879551836506682,0.23649236378485808},
{0.7029930228288724,0.6996930555808848,0.1273987355738241},
{0.8897565275580694,0.4521779071271735,-0.06219696113071692},
{0.9866210843178602,0.05710122026611576,-0.15270326330360556},
{0.8599988605022647,-0.45409939831869583,-0.23279969154061306},
{0.28659413491104296,-0.8660822758075866,-0.40959161779331194},
{0.8747391760712702,-0.1597071526450004,-0.4575204905140118},
{0.9149145518316711,-0.2123033767120601,-0.3433054603167698},
{0.6937206627776659,-0.7035209546837076,-0.15430459603084018},
{0.9558628272174601,-0.028898876144559677,-0.2923886292273097},
{0.8134110950030042,-0.5530075430743316,-0.18040246070634616},
{0.5186097266166348,-0.8098151882262841,0.27430514464123207},
{0.9486911108059375,-0.10879898055832823,-0.29689721808609976},
{0.8335661203935409,-0.5472777563476308,0.07519694368233479},
{0.5691207704415329,-0.8218299932329145,0.026400963520745856},
{0.9457722514492078,-0.049798538932301274,-0.32099058227447214},
{0.77340347645644,-0.5893026489213604,-0.2336010500390799},
{0.06009919527716282,-0.9973866450822328,-0.04009946307178418},
{0.6916982188793795,-0.6774982554442383,-0.25009935599498745},
{0.7331269978988055,-0.5505202732823523,-0.39931470503477434},
{-0.005200080367863133,-0.8602132946992053,-0.5099078806871946},
{0.7091979220531326,-0.40209882185217793,-0.5790983032444571},
{0.6088034306169974,-0.400502256836576,-0.6848038588806172},
{-0.02559991270444652,-0.478898366959353,-0.8774970077403054},
{0.5222912412493258,-0.058099025687508764,-0.8507857324428995},
{-0.15499833377686778,0.021099773178657487,-0.9876893823962084},
{0.10680371683401986,0.22000765639966638,-0.9696337438414387},
{0.2377030259787812,-0.36460464144662863,-0.900311461037849},
{-0.4881038413923477,-0.38270301188455536,-0.7844061733008759},
{-0.6741722482705882,0.30868729314911086,-0.6709723799904549},
{-0.415503450770488,-0.11330094096822213,-0.9025074953558735},
{-0.3744808083503455,0.31398390873700527,-0.8724552878122201},
{-0.4432909547403518,0.39959184641156004,-0.8023836275291185},
{-0.8522827925841249,0.06529868163292661,-0.518989521707334},
{-0.9305089841076125,0.04880047117082375,-0.36300350481575855},
{-0.618474686349121,0.10999549797639985,-0.7780681543221519},
{-0.8721161386584702,-0.06970128983430268,-0.4843089622202696},
{-0.34110203638523584,-0.22660135281411445,-0.9123054464797733},
{0.34150196364193647,0.926505327420949,0.15800090850783588},
{0.5554102168649097,0.8266152057265653,0.09070166847253747},
{0.235705542681005,0.952222391772817,0.19420456677408218},
{0.9515912787058958,0.1955982073506444,-0.23709782700837315},
{0.986871928827221,0.0627982137302153,-0.14879576756458657},
{0.967682296414329,0.03229940908771606,-0.2500954245460615},
{0.9114488640834403,-0.02010107764765981,-0.41092203012056794},
{0.9826775853799135,0.1852957734516108,0.003199927010497327},
{0.9769918030731581,0.01569986827865771,-0.2126982154694583},
{0.6199190752034206,0.1727053142242793,-0.7654235524450687},
{0.6393047500519394,0.19080141765979985,-0.744905534668684},
{0.8942270194775965,0.041201244914422924,-0.445713467435881},
{0.16039356112973008,-0.07419702142036143,-0.9842604876558187},
{0.10370022347422238,0.3542007633034674,-0.9294020028634743},
{0.3846075845363513,0.35420698503061787,-0.8524168098252363},
{-0.16790193843906898,0.24250279971098407,-0.9555110314385373},
{0.20820853151937208,0.4235173539791262,-0.881636125780396},
{-0.07840217765072678,0.3667101855168561,-0.9270257484977518},
{0.6440992431838338,0.16149981023783444,-0.7476991214540484},
{0.7272033415070314,-0.005100023434661524,-0.6864031540297393},
{0.4644966881504203,0.32849765782004964,-0.8223941363507118},
{0.360291877311188,0.7877822396496083,0.49958873689888844},
{-0.19820525548202458,0.841722318563169,0.5022133163626273},
{-0.9074949044304174,0.22969871024536292,0.3516980252211326},
{-0.7771071377618407,0.256102352310909,0.5749052805292526},
{-0.9765307172568245,0.16280512111562828,0.14100443536427265},
{-0.9777843262428744,-0.14209772219176975,0.1540975298363949},
{-0.9819372603162775,0.05410205294134903,-0.18130687982008464},
{-0.9895872888329119,-0.04319944510669139,-0.13729823641547978},
{-0.9757192121004312,-0.031800626160493714,0.21670426694902475},
{-0.8124343017003419,0.10660450093704635,0.5732242020367257},
{-0.7541205613774128,0.3025082479998241,0.582915893418504},
{-0.9415665514423796,0.12319562355320854,0.3134888635059324},
{-0.9864208876834475,0.023800503981007755,-0.16250344104679665},
{-0.7773355483674588,0.5590255648236324,0.28851319401005},
{-0.9555439512548302,0.047402180313426426,0.29101338546850397},
{-0.98771155135414,-0.07260084907189487,0.13840161861639463},
{-0.869619027472484,-0.48181054212999397,0.10780235874141418},
{-0.6249997250001815,0.7497996700882178,0.21719990443206308},
{-0.9344630614052595,0.31908738672489917,0.15799375463031673},
{-0.9803732900935621,0.1932947337567172,0.038798942937199314},
{-0.1206990452743278,0.9561924365477402,0.26669789042803},
{-0.500905655256772,0.681907698781379,0.5330060176719095},
{-0.8693621792210716,0.3492848046951004,0.3495847916444521},
{-0.9565442111857764,-0.0077995451047972566,0.2914829997497949},
{-0.8916162543124755,-0.45270825294667755,0.008700158605337075},
{-0.8886190166504366,-0.4568097758338054,-0.04100087742816554},
{-0.9530442365748847,-0.2264105090876746,-0.20110933470641063},
{-0.9143069990468667,-0.3398026011988683,-0.2204016871813731},
{-0.8852979018464591,-0.22439946817389067,-0.4072990347024317},
{-0.33239619408536647,-0.9154895177050331,-0.22669740432958058},
{-0.303810364667389,-0.8942305071941382,-0.3287112141743606},
{-0.1775956338650115,-0.9829758338361841,-0.04709884208920069},
{-0.8660582873071134,-0.47857694989629895,0.1445930358441388},
{-0.13250210216252636,-0.989915705137244,0.050100794855415624},
{-0.8106121673799492,-0.5291079419698139,0.25090376609379383},
{-0.8248817661900854,-0.5025888903953654,0.25879427941567956},
{-0.15420142482774815,-0.9792090479334046,0.1318012178488794},
{-0.7278102148880495,-0.5378075481819085,0.4255059720182262},
{-0.7739257798970998,-0.3721123952703331,0.5124170688968521},
{-0.12250589880104432,-0.9303447971805023,0.34561664184196667},
{-0.6463897192532724,-0.5297915737320293,0.5490912667728526},
{-0.8564269093562447,-0.37521178933963445,0.3546111420571279},
{-0.07369892510901588,-0.21519686137666508,0.9737857974377159},
{-0.1520040661631555,-0.5435145392083883,0.8255220830110848},
{0.0711020914987826,-0.33640989564262264,0.9390276219037534},
{0.04300059577738177,-0.8077111909160758,0.5880081469093136},
{0.43081843080671334,-0.10560451785791301,0.896238341896417},
{-0.27548951782326647,-0.10759590605366051,0.9552636529094971},
{-0.1000014000294007,-0.2644037016777354,0.9592134290820115},
{0.33791416058960544,-0.4897205221684812,0.8037336811656286},
{0.12319797710582375,-0.9201848906881414,0.37159389847828006},
{0.6407750294836422,-0.4310832010149783,0.635275243806114},
{0.5583217917248049,-0.5521215497246369,0.6192241687909711},
{0.7769809641995629,-0.4119899063709393,0.475988338428561},
{0.14479897120696433,-0.9813930272273121,0.12609910406904834},
{0.7209876640066023,-0.607089612785587,0.3340942836957085},
{0.8066425716851107,-0.5680299785731997,0.16330861883979492},
{0.10140199966715034,-0.9946196140921867,0.021200418076366738},
{0.7316892186387945,-0.6616902500659974,0.1636975879338126},
{0.028799396802950877,0.811682999477612,0.583387781070887},
{-0.180410329689148,0.28381625036463526,0.9417539216644715},
{-0.7091729881153144,0.15549407734338885,0.6876738070035274},
{-0.8745692463131707,0.031398895877239374,0.48388298455401696},
{0.24559505744920276,0.8532828278558823,0.45999074277945146},
{0.3969997221002918,0.3693997414202715,0.8401994118606174},
{0.7302852374331364,0.4702904931737698,0.4954899837712161},
{0.9350058064040867,-0.015300095013885054,0.3543022002234951},
{0.9639018796104979,0.22920044694130728,-0.13550026422577288},
{0.5879804499750522,0.20189328715980107,-0.7832739565739087},
{0.6021230888525215,0.12390475121877997,-0.7887302444410957},
{0.8937212574129144,0.12550298512400218,-0.43071024456500195},
{0.6431285201666042,-0.006100270522494613,-0.7657339572252664},
{0.7355022248975955,0.12810038750425828,-0.6653020125416319},
{0.8739250907495384,0.07890226531655632,-0.479613769909004},
{0.9879624087455072,0.12369529348362272,-0.09289646535673848},
{0.9466899414728074,0.3193966064290849,-0.04199955375711198},
{0.9021732013430753,0.4078878838703618,-0.14039582960382152},
{0.9280870300743814,0.3696948335508014,-0.04449937812553601},
{0.8604192047709782,0.4456099461249975,0.24720551768873292},
{0.8206206470752239,0.547613778135989,0.16340411129916108},
{0.6073005040596275,-0.24080019986424883,-0.7571006283937824},
{0.714714087153488,0.11430225291960779,-0.6900136003020941},
{0.6115982324836622,0.059899826889750436,-0.7888977200888835},
{0.409186243389742,0.012199589856683414,-0.9123693266588481},
{0.6338149138403861,0.11210263780610175,-0.7653180081445999},
{0.9229132115971866,0.0014000200414303406,-0.38500551139334366},
{0.9979196542211368,-0.06240122900430798,-0.01620031906842611},
{0.8129094216747961,-0.15850183704693713,0.5604064951489184},
{0.8577255177137336,0.09360278472426893,0.5055150392961318},
{0.9847471746546854,0.06349659381658461,0.1619913102092395},
{0.8966173317805366,0.44270855763912953,-0.00930017977421257},
{0.9795115485092357,0.20040236275778545,0.019900234625149355},
{0.9473137645689995,0.25130365146858397,-0.19860288572089443},
{0.975004738534544,0.21480104393561028,0.05680027605001241},
{0.9261676680510526,0.16169435534858045,-0.34068810678578454},
{0.7048924682642147,0.36299612140716403,-0.6093934886653603},
{0.5156928190274923,0.09939861588391068,-0.8509881500725148},
{0.7249877296865116,-0.028099524419573762,0.6881883525106998},
{0.743716194596458,0.038000827477027564,0.6674145331096895},
{0.5112934887188815,0.054299308502709295,0.8576890773991486},
{0.5646755020847515,0.13519413472969435,0.8141646782316357},
{0.7686352004550256,0.21540986492065126,0.6023275842233436},
{0.9240999214515101,0.09559999187400105,0.369999968550004},
{0.7980293281167223,0.47051729182821783,0.3765138371377769},
{0.7139086169290098,0.5739069270984153,0.40120484257167494},
{0.9592676492440347,-0.02499915691764919,0.2813905102650593},
{0.9244565792941819,0.3354842426751737,-0.18119148963559303},
{0.9489330756387871,0.20380710382040768,0.24080839352283692},
{0.7827744467452722,0.08919708820858237,0.6158798949289896},
{0.8973924798825278,0.06379946536272038,0.43659634133798936},
{0.9620026070305975,0.17770048156895757,-0.20730056178528367},
{0.8991092653687197,0.12430128093130002,-0.419704325075355},
{0.599903437456545,0.5103029240441321,0.6162035308563477},
{0.6755912815507671,0.23209700480747933,0.6997909692558123},
{0.7623868070104561,0.2421958088377918,0.6000896155390539},
{0.8411870374076296,0.12669804759812966,0.5256918991502506},
{0.8995729772336398,0.39858802659551895,0.17859463509774132},
{0.8761504945149217,0.4760731002494342,0.07559572858403114},
{0.6718961668433023,0.7371957943099902,-0.07139959266648577},
{0.7977010768971807,0.3401004591359298,-0.4980006723013614},
{0.7169898259865534,0.2192968881992345,-0.6616906106768512},
{0.5210879161113365,0.29909306411226394,-0.7993814625588225},
{0.5377842189536387,0.39808831826969804,0.7431781917559397},
{0.5220778356559709,0.2594889836290451,0.8124655075090526},
{0.7590595052555631,0.05169724202570493,0.6489653786205513},
{0.9080379931044639,0.16640696261297663,0.3844160843054581},
{0.9256092839076766,0.37170372820709097,0.07130071514975946},
{0.23580137590504263,0.958705594063462,0.15900092777312033},
{0.7751173201900317,0.5517123281497103,-0.30790688025610985},
{0.4265061523956228,0.8613124245213362,-0.27610398282867865},
{0.051000005100000766,0.996200099620015,0.07060000706000105},
{0.7633902592024385,-0.05499929821343217,-0.6435917878211808},
{0.45180165133805344,-0.13130047990413107,-0.8824032251896821},
{0.989762325414111,-0.08029694355501425,-0.11799550858644685},
{0.26420635423923006,0.45551095517020934,-0.8501204456425795},
{0.6268214972118766,0.7786267034607005,0.028900991176488887},
{0.9634009730354741,0.1501001516012297,0.22210022432133983},
{0.5493260139493504,-0.17140811722359123,-0.817838729670087},
{0.8229760805478233,0.5566838202198946,-0.11319670998543573},
{0.39191464612399357,0.5258196502475014,0.7549282121944444},
{0.6337060899447867,-0.2325022343572083,0.7378070903602076},
{0.9781019024100502,-0.2081004047556809,-0.003300006418518726},
{-0.7318995572009017,-0.25819984378914174,0.6305996184873461},
{-0.7447226808746243,-0.6202188890539035,-0.246407504454824},
{-0.8703829667720088,0.040699203524380466,0.4906903972828869},
{-0.5052029175552734,-0.4675026998358874,0.7254041892212892},
{-0.48942505675718745,-0.8709445891496415,-0.04380224251320966},
{-0.8597095342316022,-0.3242035954378102,-0.3947043772958164},
{-0.7718970552183516,-0.6000977106316009,0.20989919923608238},
{-0.6288617820865052,-0.6034633256307933,0.49027020473368343},
{-0.895552281767965,-0.26358595519655603,0.3584808988541932},
{-0.7561152850249817,-0.45600921831952346,0.4694094892087375},
{0.8784914040036675,-0.39039617999206816,0.2753973052505521},
{0.9991940598089716,0.03689978063145622,-0.01579990606983762},
{0.9709018884060094,0.11990023320618039,0.20730040319967635},
{0.9857346294658104,0.16830591269057105,0.0006000210791107702},
{0.17750697793645673,-0.9712381801233058,-0.15870623886487709},
{0.7395960320779319,-0.6403965642816489,0.20709888891744144},
{0.22530108820688408,-0.8748042253146124,0.42890207160200877},
{0.20309661542310573,-0.7525874582345119,0.6263895613049405},
{0.8071846313509273,-0.20599607787201563,0.5531894673728109},
{0.8656753718859999,0.3004914511398209,0.4003886091061041},
{0.8189028456923332,0.036000125100652085,0.5728019904903755},
{0.9106298645961222,0.20530673314472206,0.3586117608655495},
{0.819322572647819,0.07790214623369351,0.5680156490466998},
{0.8457824713399202,0.0529989016091461,-0.5308889974395409},
{0.9764149343806329,0.09010137811111739,0.1962030009478494},
{0.7994881756573224,0.4261936966418397,0.42329373953188815},
{0.9939742713089764,-0.10959716311414872,0.0018999508204095123},
{0.7154862413318677,-0.007499855779160037,-0.6985865663094937},
{0.15120511006304332,-0.8101273787174035,0.5664191424583845},
{0.5429980967950061,-0.08999968455165845,0.834897073690885},
{0.6078206966470873,0.0885030135789194,0.7891268702274047},
{0.5126003049972722,-0.20170012001160711,0.8346004965874432},
{0.8187999304020088,-0.21769998149550238,0.5311999548480058},
{0.9448253736261176,-0.15020403378349162,-0.29110781780542216},
{0.054999754426644724,-0.1927991391537655,0.9796956256687971},
{0.24158938721132459,0.15289328354557752,0.9582579046548525},
{0.07650213826464716,-0.01680046957968722,0.9969278645232257},
{0.2557862019854908,-0.2967839904194436,0.9200503692214623},
{0.4965177111026381,-0.3171113115622287,0.8080288229021785},
{0.6186808521239356,-0.22949289730474096,0.7513767452495962},
{0.715291280652433,-0.2229972816797044,0.6622919267106198},
{0.9381628307249555,-0.33238683109462286,0.09679616501191184},
{0.09630251063917897,-0.7429193681603952,0.6624172694433245},
{-0.44841030234504586,-0.1790041126667333,0.8757201199008846},
{-0.1722953739313141,0.19289482084358958,0.96597406394457},
{-0.30748667842822935,-0.29958702067348786,0.9031608714028513},
{0.10939716883790525,-0.48938733481966024,0.8651776094931958},
{0.17349469548077726,-0.38308828725467303,0.9072722605746929},
{0.4377029566934587,-0.3222021764830532,0.8394056702044534},
{0.3758006971109397,-0.18910035078147602,0.9072016828606825},
{0.4750119799532035,-0.2510063304594823,0.8434212713526987},
{0.6784798460555049,-0.2789917126742607,0.6795798133814608},
{0.17809633036291891,-0.8587823049729072,0.48039010166393176},
{-0.4948908198604366,-0.5529897421354243,0.6702875662809672},
{-0.7468404350357588,-0.21921186845184568,0.6278339918525032},
{-0.5560939441699219,0.14489842206477554,0.8183910877695811},
{-0.7636236688824312,0.04160128945195015,0.6443199710070068},
{-0.7106845001400761,-0.39919129373282447,0.5792873658803237},
{-0.4868176766707657,-0.7185260901560089,0.4967180361593453},
{-0.007599782003379804,-0.6980799758630845,0.7159794624236763},
{-0.048402309813337756,-0.43102056879232586,0.9010429987978785},
{-0.11610229536506927,-0.12750252074975307,0.9850194740275042},
{-0.22640257987209653,-0.3525040168061574,0.9080103468368537},
{-0.2671056386595488,-0.35240743939956937,0.8969189341585522},
{0.36520764570209496,-0.10470219196333336,0.9250193654831267},
{0.3794038452774579,0.02440024729775955,0.9249093740040084},
{0.2684037093648953,-0.013400185191839036,0.9632133116999522},
{0.49828794905167656,-0.07479819102762474,0.8637791097548428},
{-0.04530175910145953,-0.9961386808159787,-0.07520292018608735},
{-0.5830089638317288,-0.7320112547595635,0.3525054198124947},
{-0.8036198576920284,-0.38110941733005477,0.4571112953596642},
{-0.9032763073731823,-0.11489698629157385,0.41338915694461814},
{-0.9922906179365609,-0.12389882854211419,-0.002899972580888871},
{-0.9444318420563415,-0.2011067804294052,0.26000876634333836},
{-0.9938245278920264,-0.08860218672895304,0.06680164868503456},
{-0.9511230031880016,-0.30290732590226654,0.06010145357123215},
{-0.9683876192434315,-0.24699684216555923,0.03489955381205675},
{-0.9077113873107813,-0.32210404082053834,0.26890337341397935},
{-0.5894207096604572,-0.4784168094699062,0.6509228705768436},
{-0.3503894306622337,-0.12759615112015132,0.9278720111629186},
{-0.32099653807100526,-0.14189846963325747,0.9363899010893749},
{-0.5773736781340072,0.026098810182365064,0.816062796545139},
{-0.4699068724382645,0.09570139964320475,0.8775128337190404},
{0.19769517135440873,0.11599716680380079,0.9733762255760318},
{0.02890070590836282,0.25870631897901253,0.9655235832015331},
{-0.00749984126753934,0.14919684228224928,0.9887790727123866},
{-0.16090367910468456,0.07750177209827877,0.983922497645116},
{0.4637881063065187,0.04739878447375805,0.8846773127412184},
{0.5064880622170586,0.16669607101990852,0.8459800604849587},
{-0.5898992154345652,-0.043599942012115686,0.8062989276231395},
{-0.7891221785904983,0.11530324064311805,0.6033169564613453},
{-0.8058971874237238,0.11439960074609011,0.5808979726696131},
{-0.4164921429498341,0.17679666476237857,0.8917831766690566},
{-0.34400239254496023,0.057500399916672135,0.9372065182940021},
{-0.29329968030352266,0.23769974090742357,0.9259989906616503},
{-0.5579105920331355,0.1621030775561414,0.8139154523315452},
{-0.3136183597561859,0.1730101283093755,0.9336546577435433},
{0.5377837645532184,0.16249509434715137,0.8272750249439896},
{0.8257200239533743,0.230105580127978,0.5150124892042967},
{0.6536690756475293,0.25178808818731513,0.7136662372489547},
{0.9911132661398514,0.07610101861895137,0.1091014603328199},
{0.18180434153951455,-0.1350032239154811,0.9740232599531748},
{0.2822968989855969,-0.14179844235266612,0.9487895776037348},
{-0.3891091247159631,0.017700415079600483,0.92102159820972},
{-0.7791753745514248,-0.02309926995910923,0.6263802035664945},
{-0.30060094088241746,-0.2833008867331632,0.9107028505043832},
{-0.53330957032611,-0.4189075173628492,0.7349131881354927},
{-0.9367706373845495,-0.11619635788224236,0.3300896535019639},
{-0.749208263812725,-0.428904730845272,0.5047055669331051},
{-0.9575241538514252,-0.19770498717120286,0.20990529492784768},
{0.11519799902813517,-0.3428940439821836,0.9322838063709238},
{0.01779968129955947,0.20839626869821312,0.9778824911707419},
{0.4575883019045907,0.3903900198067138,0.7988795769046713},
{-0.8975337209753574,-0.43351628751288857,0.08060302831266164},
{-0.8698142302772119,-0.4932080689500126,-0.013000212685219309},
{-0.8494256657842435,-0.5161155946682929,-0.11000332380064372},
{-0.9433774488316253,0.004399894821771414,-0.33169207099581316},
{-0.9597740240675532,-0.27029268462748446,-0.07599794314350285},
{-0.5672120590565648,-0.7958169192475567,-0.21200450726373715},
{-0.9185249428834906,-0.035000950463714944,0.3938106940745984},
{-0.5961887530052609,-0.2451953744328916,0.764485578115602},
{0.49289035423015054,0.04769906653840167,0.8687829980830895},
{0.4356217794553094,-0.03990199495010754,0.8992449588756066},
{0.15499888556201918,0.11069920407558402,0.981692941653124},
{0.5072193837591326,-0.08380320260058224,0.8577327788844796},
{-0.21939632623927546,0.4487924850327567,0.8662854941708492},
{0.5057172503096171,-0.4560155549558738,0.7323249800311105},
{0.4369995367807365,-0.4255995488647173,0.7923991600573355},
{0.5830825019566704,-0.05749827450267288,0.8103756809907148},
{0.6551776293417627,-0.21249274455910344,0.7249752461428235},
{0.8826102162723803,-0.2572029771416907,0.3935045548415836},
{0.5675843746172473,-0.5002862273097406,0.6538819988763531},
{0.5803904787722929,-0.17959705373450002,0.7942869698291389},
{0.5809103461053969,-0.10540187722415018,0.8071143748350248},
{0.6923894965310058,-0.39729397309614184,0.6022908633169046},
{0.9227277652961929,0.06570197700223245,0.3798114286978369},
{0.9114935375337283,-0.39879717253807,0.10069928604459291},
{0.8073350915824,-0.5077220686193292,0.3007130707776882},
{0.701176647700616,0.012599580377963151,0.7128762580515817},
{0.6875744708338382,-0.4938816625143,0.5322802368017046},
{0.1790992182336186,-0.22139903359532753,0.9585958157383964},
{0.19769080067263106,0.20469047495036713,0.9586553900093647},
{0.36269953030441243,-0.0036999952085093077,0.9318987931918442},
{0.7898115945193119,-0.3798055755867748,0.48160707004368275},
{0.7294981543720042,-0.516498693259959,0.44839886555230524},
{0.37619366307111785,-0.8574855557774683,0.35099408755439226},
{-0.36361705222150525,-0.6531306292790569,0.6642311498501755},
{0.05260181979143407,-0.42971486624295097,0.9014311855513055},
{0.15070465157085722,0.1613049787550051,0.9753301040282485},
{0.11729569649984167,0.5127811864033999,0.8504687968722535},
{0.12589433928829802,0.21459035116178515,0.9685564498383276},
{0.022600831047836722,0.7187264280566484,0.6949255528823779},
{-0.06329705200845245,0.880458993577289,0.4698781159363635},
{-0.8153972358080559,-0.5298982036481344,0.2330992097950182},
{-0.8883758853638832,-0.4446879291099942,0.11419690016721687},
{-0.9769915344050315,-0.21279815611196592,0.014299876092110492},
{-0.7741702182445451,-0.4858813085055857,0.4056843936215603},
{-0.5705178146969002,-0.47311477323944523,0.671320962324328},
{-0.5412972556298709,-0.0701996440887067,0.8378957518793069},
{-0.8900230118424607,-0.10770278469149777,-0.4430114542092248},
{-0.6459835502383371,-0.7581806931744693,-0.08869774134077477},
{-0.9514771553077485,-0.2548938800714084,0.1723958608250718},
{-0.8693925406440017,-0.1883983835488037,0.45679608070644123},
{-0.7085061392322948,-0.6549056747822581,-0.2629022780581091},
{-0.8360815269827397,0.5292883055040835,-0.14429681179716464},
{0.31911676364390285,-0.6783356339067983,-0.6618347670934972},
{0.3121991117947904,-0.03429990241691643,-0.9493972989685266},
{0.2091950159881154,0.10259755564235488,-0.9724768310154983},
{0.4248977459234368,0.348198152813699,-0.8355955671772742},
{0.5445873276003284,-0.006299853404116909,-0.8386804841321986},
{0.4924074206357439,0.35670537559051557,-0.7939119643434547},
{0.578191590264479,0.5868914637257396,-0.5667917560738613},
{0.4322902973531626,0.6135862282116599,-0.660785168843326},
{0.24301322878517317,0.34981904291791593,-0.9047492513660336},
{0.19600080752499052,0.25300104236644183,-0.9474039033121225},
{-0.04809788999184807,-0.2206903185280846,-0.9741572646581785},
{0.6309867967394159,-0.003899918395061366,-0.7757837668945149},
{0.48560553350658164,-0.14770168307026793,-0.8616098180998162},
{0.6327126607070124,-0.41100822435685486,-0.656313132957187},
{0.580731816264105,-0.21371170851668542,-0.785543037154218},
{0.5095111202015489,0.185104039939758,-0.8403183401479128},
{0.3979054394045352,0.42640582900752405,-0.8123111043686956},
{0.4130099330083347,0.5441130860770822,-0.7303175643486364},
{0.425100044635507,0.6333000664965104,-0.6467000679035108},
{0.4045988549868606,0.706298001179485,-0.5808983560599785},
{0.2949990825542799,0.7428976895917782,-0.6008981312097179},
{0.41789336181667086,0.8055872033489113,-0.4199933284589657},
{0.49968368809224895,0.6001804074303938,-0.6245796109313962},
{0.6741207059354791,0.35261083060799575,-0.6490199349534579},
{0.5311974396345115,0.6385969219702542,-0.5567973162434036},
{0.557316011919037,0.6793195171300948,-0.47741371629310647},
{0.3396947993124335,0.9162859717691575,-0.21219675129260637},
{0.4817118936134818,0.865821377393715,-0.1353033406807226},
{0.2009910309753596,0.9714566497142381,0.12599437762634483},
{0.10849984647282586,0.9926985953324815,0.052699925429658276},
{-0.012300168882478141,0.9795134488119789,0.20100275978683793},
{0.1311967555443526,0.9088775237367537,0.39589020975616757},
{-0.07130274913049012,0.9308358890695679,0.35841381891118734},
{0.20310102972483104,0.7539038223020685,0.6248031677600908},
{0.11519603444477017,0.9358677833060799,0.33298853706691384},
{0.2393901121956194,0.7943671893408524,0.5582769408471776},
{0.2419899902910731,0.3846840878718009,0.8907631543441651},
{0.05219930053405924,0.4285942568754365,0.9019879134429393},
{-0.07530288490878236,0.04730181216713685,0.9960381589528182},
{-0.2933005118098397,-0.04190007311569138,0.9551016666538625},
{0.010199710026365869,0.4380875453481261,0.8988744453627724},
{0.17190597985351563,0.24510852624838095,0.9541331901002865},
{0.21330976874454458,-0.07040322418947932,0.9744446257134752},
{0.3106885528911492,0.057597877845285465,0.9487650433959522},
{0.4763741312051883,0.09069507493767963,0.8745525087154863},
{0.45558540099973377,0.15169513900715453,0.8771718914770993},
{0.5018984867783436,0.007099978593596811,0.8648973923382932},
{0.44990523242827996,0.05770067106270672,0.8912103648368149},
{0.37800129654667075,0.8767030070964715,0.2975010204302501},
{0.7813130831971181,0.3179053233692101,0.5371089939654066},
{0.4477043561845786,0.7525073219318638,0.4830046996585916},
{0.8085407919119539,0.46382340048084625,0.362118269327543},
{0.8000839864792644,0.4920901509141932,0.34309313305966205},
{0.813114754101071,0.5437098657050206,0.20790377244817693},
{0.9395729218985807,0.3381902534973393,0.05319846684227809},
{0.9079107769648842,0.32320383645230816,0.2669031681594092},
{0.7057169903410662,-0.5340128565142828,-0.46561120972481285},
{0.27290520571644905,-0.7470142494327132,-0.6062115635958645},
{0.14799560089614408,-0.2578923342642943,-0.9547716198353944},
{0.22799428653476828,0.21959449703085573,-0.948576228977549},
{0.29039320342660974,0.13329688022302713,-0.947577822200604},
{0.6136859989136504,-0.15749640676046917,-0.7736823486385714},
{0.7244721119828135,-0.006499749796947256,-0.689273466928576},
{0.7015942294111945,0.33579723807907513,-0.6284948306512766},
{0.775275431910838,0.3526888234682737,-0.5239833952293037},
{0.7872675731164812,0.6002752751706131,-0.14099419256880966},
{0.4767073914054061,0.860913348564955,0.17770275530258162},
{0.3829890466698956,0.7497785566399157,0.5395845681020252},
{0.3973128612254802,0.5466176943011515,0.7371238610855813},
{-0.5598860422149492,0.0383990427237972,-0.8276793662105975},
{0.02019900936387803,0.49727561171567053,-0.8673574614964259},
{0.4215077874283098,0.6376117799864538,-0.6448119130101404},
{0.6547944473666294,0.3163973169621282,-0.6863941794020378},
{0.8466958130995563,0.1461992770463625,-0.5115974701567652},
{0.8593107328580805,0.10620132646285134,-0.5003062488640727},
{0.9626254232731475,0.1901050207398975,-0.19290509469082706},
{0.9877901962309533,0.11499885864199194,-0.10509895689802916},
{0.9225359657657017,0.3487135948644989,-0.1653064445973664},
{0.7382233245344137,0.5251165913208083,-0.42341337795701817},
{0.8886948322545756,0.4584973338457555,0.001299992440565937},
{0.922450604092691,0.01609913791424642,0.3857793420693335},
{0.9343351410054922,0.3355126188668978,0.12020452097705252},
{0.7690082284320665,0.6136065656253785,0.17920191747077546},
{0.6249181197635776,0.5082147358999042,0.5926171831843432},
{0.4976657145016084,0.3364768192280314,0.7994449241391117},
{0.6861121923219873,0.06470114974964665,0.7246128764852237},
{0.7882714532662207,0.2804898422442914,0.5476801661219194},
{-0.44620905367354946,-0.26330534251960014,0.855317354565188},
{-0.3803186303644238,0.3537173272676747,0.854541860758349},
{-0.06280049110176063,0.2066016156309514,0.976407635537565},
{0.1883937360124147,-0.4124862850590289,0.8912703657529999},
{0.4487103428926069,0.14750339999255518,0.881420316972462},
{0.5721834727190823,-0.47328632932181347,0.6697806536652242},
{0.24380899062229683,-0.5270194341999608,0.8141300215980799},
{0.521014523482266,-0.7610212137620046,0.3865107741379958},
{0.8926705512842616,0.06299792173284248,0.44628527729154915},
{0.7341389360909908,-0.676635886335873,-0.0566030020198203},
{0.8592826856283252,-0.5114896935865103,0.0033999314920706456},
{0.8951737315122675,-0.4252875201208304,-0.1333960855493035},
{0.7854706789268232,-0.6139770806633602,-0.07789709215582372},
{0.6664918088660031,-0.639192144376818,0.3836952844139316},
{0.8750891445864917,-0.46759419952993203,0.12479845188480648},
{0.920398357090399,-0.38789930760035396,0.04899991253523419},
{0.9096983852867994,-0.3938993008293616,0.13149976658812149},
{0.895691325271522,-0.4257958761869086,0.1281987584010373},
{0.8754879402366843,-0.43469401213122405,0.21109709215758318},
{0.8868306760036336,-0.46171597103166173,-0.018700646866562864},
{0.809987522238329,-0.5383917061396498,-0.23249641842026111},
{0.7958084356141264,-0.3410036146574732,-0.5004053043243388},
{-0.28431399712262595,-0.2832139429656267,0.9159450930869263},
{0.42089030700784313,-0.2794935633373537,0.8629801257965518},
{-0.7242106133843093,0.1581023170064337,0.6712098366522348},
{-0.1284016371313102,0.028500363381949695,0.9913126393167274},
{0.5446123056540709,-0.13210298490066613,0.8282187138132604},
{0.7850753725718376,-0.4066872424213047,0.467185344625605},
{0.8931014557565593,-0.2972004844371845,0.33770055045234587},
{0.6097016431481425,-0.05940016008364714,0.7904021301366111},
{0.7004300455912222,-0.4642199131402704,0.5421232548757875},
{0.9047091783211713,-0.34210347065731483,0.25390257585469816},
{0.913102689091379,-0.2707007972150217,0.3049008979344666},
{-0.4444926903778096,0.6819887847866506,0.5807904489795991},
{-0.9079107769648842,0.32320383645230816,0.2669031681594092},
{-0.60839389175599,0.3765962189929419,0.6985929861616282},
{-0.049901975907854876,0.25581012900259076,0.9654382272834289},
{-0.8337327246516765,0.5150202149401624,0.1991078151351191},
{-0.8640806664113811,0.4336902962881796,0.25549428337936336},
{-0.9395729218985807,0.3381902534973393,0.05319846684227809},
{-0.888632933346776,0.4586169966608502,0.0014000518868844097},
{-0.7593878271106964,0.5676908999878093,0.31789490418552857},
{-0.8720052233269316,0.4289025691340837,0.2359014130536963},
{-0.8085407919119539,0.46382340048084625,0.362118269327543},
{-0.4477043561845786,0.7525073219318638,0.4830046996585916},
{-0.3845193591144642,0.2815141731878327,0.8791442616320558},
{0.26878614174378834,-0.5301726650020706,0.8041585386545931},
{0.6040739921541397,-0.589674612106102,0.5360769197050725},
{-0.3781195303781291,0.8765452747326902,0.29781538256177426},
{0.7822132625383005,-0.0005000084777156102,0.6230105632336502},
{0.710871555043826,0.24009039297513382,0.6610735476712244},
{0.2532936259461036,0.3819903873328526,0.8887776341922499},
{0.9252348218677938,-0.12120456161951644,0.35951353054633794},
{0.655505014632543,0.21410163788379477,0.7242055401935737},
{0.46249969937529306,0.4016997388952545,0.7903994862405008},
{-0.1351039646840163,0.623918309151427,0.7697225878407652},
{-0.32829180265603025,0.52508688874408,0.7851803942903288},
{-0.027900046593116717,0.4815008041070143,0.8760014629236647},
{-0.19049688921119856,0.6095900454758354,0.7694874343727941},
{0.38041271360533657,0.6770226264742715,0.6300210556555258},
{0.5326015951441662,0.5786017329147851,0.6177018500198113},
{0.7452110515618425,0.1949028904312978,0.6377094573013782},
{0.7567884628478251,0.06529900452426397,0.6503900848787334},
{0.8540445438548074,-0.12870671287366947,0.5040262881766077},
{0.9199355975966869,-0.28541104419403673,0.26881040181975147},
{0.39667717783509104,0.5182701821828275,0.7576564094924337},
{-0.051798316582066184,0.6679782910583053,0.7423758731761763},
{-0.5155861283418229,0.675381829096329,0.5272858135660266},
{-0.651818378278267,0.5586157503931266,0.5129144618271297},
{-0.5082186011412089,0.5800212291654883,0.6366233008392239},
{-0.671106211116726,0.5748053198478529,0.46820433325115646},
{-0.3228875400102419,0.8325678718257274,0.4500826316463607},
{-0.681890607021582,0.7312899265506422,0.015499786491911602},
{-0.33638985968051754,0.7812764487764221,0.5257841504756723},
{-0.8111100821609823,0.5253065296007446,-0.2572031970556092},
{-0.36479238321455687,0.7515843070835004,0.5495885247114047},
{-0.6327869362485503,0.6483866141965233,0.4232912612421165},
{-0.8164988201600573,0.5341992280826731,0.2189996835456859},
{-0.873981939349833,0.4392909221468898,0.2077957059461045},
{-0.8614919580101079,0.48689545485214336,0.14409865484533552},
{-0.7397954835623592,0.6635959487590991,0.11109932174071115},
{-0.8890970570936114,0.22339926054967135,-0.3994986776615654},
{-0.7917795169288422,0.2526934629046709,-0.5560856142512367},
{-0.8453177476324193,0.22960482060381338,-0.4824101283069668},
{-0.960258911400253,0.23818980807616397,-0.14549377445458378},
{-0.903156992687988,-0.07459644780173151,-0.4227798677020387},
{-0.9414007248788372,0.32850025294529217,-0.07650005890506803},
{-0.8595283391165186,0.49701638690041855,0.11910392692120694},
{-0.8590678585773458,0.062097676658890905,-0.5080809905053537},
{-0.8695036084474627,0.4648019289320076,-0.16710069346931686},
{-0.9211703664259604,0.35568855768314606,-0.15789492060210503},
{-0.7772137023983611,0.5243092436534491,-0.3479061336392046},
{-0.7471073328944586,0.14360140945475072,-0.6490063700287829},
{-0.8650835895199587,0.3042942275932533,-0.398792434979262},
{-0.9355298719457245,0.22170707922006108,-0.2750087811705764},
{-0.862736399616566,0.20480864105885327,-0.4623195056714251},
{-0.7244721119828135,-0.006499749796947256,-0.689273466928576},
{-0.6547944473666294,0.3163973169621282,-0.6863941794020378},
{-0.8593107328580805,0.10620132646285134,-0.5003062488640727},
{-0.7015942294111945,0.33579723807907513,-0.6284948306512766},
{-0.775275431910838,0.3526888234682737,-0.5239833952293037},
{-0.9225508570247346,0.3486814262351235,-0.1652911951725435},
{-0.9877901962309533,0.11499885864199194,-0.10509895689802916},
{-0.9626256831958461,0.19020507473909196,-0.19280514410986818},
{-0.8466834305673939,0.14629713699304328,-0.511589988281893},
{-0.7383000775215122,0.5251000551355087,-0.423300044446507},
{-0.4215077874283098,0.6376117799864538,-0.6448119130101404},
{-0.2904847644736446,0.1332930089650149,-0.9475503022899333},
{-0.6136859989136504,-0.15749640676046917,-0.7736823486385714},
{-0.6741207059354791,0.35261083060799575,-0.6490199349534579},
{-0.5312987939531065,0.6385985503829359,-0.5566987362953029},
{-0.557316011919037,0.6793195171300948,-0.47741371629310647},
{-0.7872675731164812,0.6002752751706131,-0.14099419256880966},
{-0.7688320917212766,0.6138256216161806,0.17920748027634337},
{-0.9343351410054922,0.3355126188668978,0.12020452097705252},
{-0.922450604092691,0.01609913791424642,0.3857793420693335},
{-0.8000839864792644,0.4920901509141932,0.34309313305966205},
{-0.813114754101071,0.5437098657050206,0.20790377244817693},
{-0.7813130831971181,0.3179053233692101,0.5371089939654066},
{-0.5018981279234743,0.007199973144150259,0.8648967739410498},
{-0.44990523242827996,0.05770067106270672,0.8912103648368149},
{-0.4763741312051883,0.09069507493767963,0.8745525087154863},
{-0.45558540099973377,0.15169513900715453,0.8771718914770993},
{-0.2133112695320619,-0.0703037142433378,0.9744514816316978},
{-0.3106885528911492,0.057597877845285465,0.9487650433959522},
{-0.17190597985351563,0.24510852624838095,0.9541331901002865},
{0.07530288490878236,0.04730181216713685,0.9960381589528182},
{-0.010199710026365869,0.4380875453481261,0.8988744453627724},
{0.2933005118098397,-0.04190007311569138,0.9551016666538625},
{-0.05219930053405924,0.4285942568754365,0.9019879134429393},
{-0.2419899902910731,0.3846840878718009,0.8907631543441651},
{-0.23929584346729818,0.7943862016315155,0.5582903025816656},
{-0.20310102972483104,0.7539038223020685,0.6248031677600908},
{-0.11519603444477017,0.9358677833060799,0.33298853706691384},
{0.07130274913049012,0.9308358890695679,0.35841381891118734},
{-0.1311967555443526,0.9088775237367537,0.39589020975616757},
{0.012200182455092934,0.9795146487511088,0.20100300602243276},
{-0.2009910309753596,0.9714566497142381,0.12599437762634483},
{-0.10849984647282586,0.9926985953324815,0.052699925429658276},
{-0.3396947993124335,0.9162859717691575,-0.21219675129260637},
{-0.4817118936134818,0.865821377393715,-0.1353033406807226},
{-0.41779470657460127,0.805689791975003,-0.4198946799681069},
{-0.4996849022487644,0.6002818627575209,-0.6244811315876594},
{-0.4045152201714938,0.7063265760373945,-0.5809218575960957},
{-0.3979054394045352,0.42640582900752405,-0.8123111043686956},
{-0.425100044635507,0.6333000664965104,-0.6467000679035108},
{-0.2950168090615581,0.7429423303451915,-0.6008342335057087},
{-0.6861121923219873,0.06470114974964665,0.7246128764852237},
{-0.49757373626347867,0.336582233975657,0.7994578017336238},
{-0.39720692337701224,0.5467095292301425,0.7371128479889116},
{-0.7882714532662207,0.2804898422442914,0.5476801661219194},
{-0.6249790635520507,0.5081829761554434,0.5925801488975124},
{-0.38292437391212397,0.7498477293270058,0.5395343424538805},
{-0.4765975407630345,0.8609955572743867,0.177599083591093},
{0.5598860422149492,0.0383990427237972,-0.8276793662105975},
{-0.02019900936387803,0.49727561171567053,-0.8673574614964259},
{-0.14799560089614408,-0.2578923342642943,-0.9547716198353944},
{-0.22799428653476828,0.21959449703085573,-0.948576228977549},
{-0.580731816264105,-0.21371170851668542,-0.785543037154218},
{-0.509520549378143,0.18500746150138656,-0.8403338913492711},
{-0.5445873276003284,-0.006299853404116909,-0.8386804841321986},
{-0.4924074206357439,0.35670537559051557,-0.7939119643434547},
{-0.4130099330083347,0.5441130860770822,-0.7303175643486364},
{-0.24310732493405207,0.3498105399503555,-0.9047272598430148},
{-0.19600080752499052,0.25300104236644183,-0.9474039033121225},
{-0.2091950159881154,0.10259755564235488,-0.9724768310154983},
{-0.4249125393540572,0.34811027288573154,-0.8356246596475646},
{-0.3121991117947904,-0.03429990241691643,-0.9493972989685266},
{0.04799812498987019,-0.220691378859674,-0.974161945106907},
{-0.6309867967394159,-0.003899918395061366,-0.7757837668945149},
{-0.4318813647211598,0.6136735205588696,-0.6609714796959635},
{-0.5775930660368631,0.5870929519914168,-0.5671931908866149},
{-0.48560553350658164,-0.14770168307026793,-0.8616098180998162},
{-0.6327126607070124,-0.41100822435685486,-0.656313132957187},
{-0.7056793027295718,-0.5340843355361546,-0.4655863445527684},
{-0.27290520571644905,-0.7470142494327132,-0.6062115635958645},
{-0.3852959043263054,-0.16789821525145776,-0.9073903544917974},
{0.12580006730305401,-0.4423002366306899,-0.8880004750803813},
{-0.6965399999580293,-0.22191274370522138,-0.6823391844527831},
{-0.25650403868788396,0.39950629027606105,-0.8801138575017805},
{-0.9854216598061264,-0.07480164415820809,-0.15280335865473524},
{-0.6839690784569287,0.26908783481397586,-0.6780693451778411},
{0.2570092203711742,-0.8855317690220806,-0.3870138843721573},
{0.3847106431671668,-0.28870798721695107,-0.8767242549120228},
{-0.05310138437113607,0.07150186407789508,-0.9960259667354335},
{0.4790931274583796,0.19779716262005317,-0.855187732419967},
{-0.5349162456530745,0.29150885325831216,-0.7930240845071752},
{-0.9444012985526783,0.24050033068818205,-0.22420030827563583},
{-0.836917215564188,0.37250766256142914,-0.40100824882451835},
{-0.9310873093664596,0.364695029240627,-0.008599882784396468},
{-0.8180930503290561,0.551295316766176,-0.16369860938621988},
{-0.5937198127607333,0.15740525270092542,-0.789126333585135},
{-0.14450638515569525,0.18870833826214323,-0.9713429197351336},
{0.45459546088698444,-0.10909891065281566,-0.8839911733922002},
{0.9607293939654694,-0.006600201936267407,-0.2774084874425119},
{0.9506985454323383,0.27889957328397935,-0.13559979253247614},
{0.9540365498403499,-0.19530748237297732,-0.2273087083634293},
{0.8617552200534547,0.06629655498902767,-0.5029738636422462},
{0.6033120995454858,-0.1428028639401548,-0.7846157356263685},
{0.9299113170895938,-0.3674044713396245,-0.016700203242710203},
{0.838668944663958,-0.5205807232527203,-0.16009407182627836},
{0.4479117332015288,-0.6666174622731393,-0.5958156075942641},
{0.4763922205785564,-0.6338896486665552,-0.6092900503747153},
{0.8816236234214886,-0.4684125512824696,-0.05770154613364325},
{0.9660471200974521,-0.25821259462646184,-0.00890043412926224},
{0.7298138738936153,-0.451308579457644,-0.5135097619133618},
{0.5837272898887184,-0.8116379449609111,-0.02250105194876848},
{0.651098941965079,-0.7529987763779826,-0.09519984530037709},
{0.7700762743154768,-0.5980815733905813,-0.22199316049608603},
{0.33599756570645467,-0.9331932390394747,0.1274990762725386},
{0.5958951792274999,-0.6763945279904027,-0.43289649788149814},
{-0.72471553082024,0.06870147228832688,-0.6856146928803043},
{0.8016648197113135,-0.31218630000482983,0.509777628899623},
{0.45900299270926875,0.28640186734626266,0.8410054833736275},
{0.7914941627520744,-0.4242968708221165,0.4398967557733892},
{0.7441717629381729,-0.6531752157366495,0.13989469179662775},
{0.6926719438911076,-0.7143710649860073,0.09939597404760517},
{0.7921431531736857,-0.5708310968710261,0.2160117675615656},
{0.5761028747605176,0.11600057884433267,0.8091040374392203},
{0.6391077620109047,0.12610153151240036,0.7587092145793669},
{0.4629043189174433,0.319802983775758,0.8267077132189466},
{0.5839075528930453,0.21940283799406432,0.7816101101921634},
{0.6855027248787471,0.3236012863176697,0.6522025925104579},
{0.9057217873996469,-0.24680593698822223,0.3446082896521126},
{0.8390186390061006,-0.54361207647642,0.023100513183600627},
{0.56091013573773,-0.8151147292562377,-0.14480261660692334},
{0.5196283387041979,-0.851946462167256,-0.06460352324921323},
{0.8311890865589399,-0.37889502514097967,0.4068946575082201},
{0.954144259007955,-0.2989138654412302,0.01610074685046439},
{0.7942822916737085,-0.4998888551022118,-0.34529230179394627},
{0.6542898618571352,-0.7098890003551587,-0.26069596054738675},
{0.3093038322982234,-0.7677095119797804,-0.5612069533972291},
{0.23079739085024462,-0.890589931937729,-0.3918955696456277},
{0.1833995616755714,-0.9200978009688835,-0.34609917282396546},
{-0.29410089847961723,-0.7618023273096649,-0.5772017633540806},
{-0.20189171655280125,-0.7776680929327069,-0.5953755722413961},
{-0.7751030771653246,-0.3058012140332296,-0.5529021950260713},
{-0.46019709846644125,-0.6210960840015355,-0.6343960001458285},
{-0.8318209039219767,-0.2809070592831008,-0.4787120301844798},
{-0.9500971829660287,0.10259969579235297,-0.2945991265148848},
{-0.6276957128529218,-0.4868966745070696,-0.6073958515005013},
{0.45009554182573724,-0.864791434283265,-0.22259779517975808},
{0.8124051587891377,-0.22650143828869973,-0.5373034118874983},
{0.5441282219421155,-0.7285377865922278,-0.41612158270559507},
{-0.11519452608617747,-0.6955669474439675,-0.7091663012180301},
{-0.6064057730104387,-0.35720340059256056,-0.7104067631045773},
{-0.8815095291695157,0.08580092751303965,-0.46430501916438593},
{-0.6951157028410928,-0.13600307234410677,-0.70591594682136},
{-0.7285096091051166,0.19360255363452375,-0.6571086673204833},
{-0.6662209429845192,0.0550017290065274,-0.7437233793118987},
{0.13149683490927516,-0.7534818639098009,-0.644184494665818},
{-0.264595017722724,-0.4884908018048022,-0.8314843432972222},
{-0.539497253965966,-0.5312972957036474,-0.6531966752373847},
{-0.6577703056298134,0.008899598236706201,-0.7531659990884394},
{-0.7718161890143487,0.36590767499397536,-0.5200109073431735},
{-0.6602944997697253,0.2535978875383952,-0.7068941115965756},
{0.25409568803276084,-0.7911865736777661,-0.5562905598292989},
{-0.4304923157807444,-0.6816878319807977,-0.5915894402227373},
{-0.018300851558434982,-0.8567398650334016,-0.5154239832359229},
{-0.157103778391306,-0.49301185707774575,-0.8557205803274383},
{-0.3591035569383473,0.11070109649979129,-0.9267091790998787},
{-0.7444012319850584,0.3782006259225538,-0.550300910748761},
{0.5932947374990175,-0.4926956298091453,-0.6365943534331274},
{0.387994397401352,-0.19779714382986452,-0.9001870013935491},
{0.14079705737225107,0.2939938555926265,-0.9453802417594187},
{-0.3636994362663107,0.4069993691514667,-0.8378987012580195},
{-0.5659120512254476,0.15680333916266156,-0.809417236723586},
{-0.25000938802878403,0.0419015734336242,-0.9673363241609712},
{-0.15329670262338949,0.001699963434179792,-0.9881787445038062},
{0.09349882659708926,-0.17739777367191054,-0.979687704996453},
{0.1878031091062071,-0.37180615530185196,-0.9091150505242431},
{-0.3713104451097335,-0.21770612415941012,-0.9026253912093871},
{-0.5594961255027463,-0.07319949309526547,-0.8255942827793875},
{-0.8562894077655385,0.30159626927722344,-0.41929481335523805},
{-0.2696917866617039,-0.13189598316899795,-0.9538709503025561},
{0.739927888407681,-0.48901843145202867,-0.46191740999528025},
{0.9018361192598789,-0.27711109852174814,-0.33151327737264347},
{0.6197279286684223,-0.3337150392071204,-0.7103320118334362},
{0.0635968262795748,-0.9113545199874917,0.40667970515570867},
{-0.3664045690934651,-0.21230264743052027,0.9059112967843068},
{-0.5285152584557706,0.07010202387464431,0.8460244250777331},
{-0.6293006859381215,-0.29180031806252005,0.7203007851282837},
{-0.5165893428717837,0.4492907312278212,0.7288849632583104},
{-0.4697740222148374,-0.038397876656129745,0.8819512294454802},
{-0.08609844249326282,-0.5850894158282006,0.8063854126198274},
{-0.252686493004515,-0.03109833768278756,0.9670483078142716},
{0.019700298855800477,-0.6746102339148733,0.7379111941977246},
{0.028898639050640107,-0.5962719192351799,0.8022622183504692},
{-0.06960175607445891,0.11670294445243326,0.9907249963069892},
{0.10769767321690495,-0.7065847344017181,0.6993848899526771},
{0.09529934910766838,0.026599818323861265,0.9950932035366296},
{0.15469301035423716,-0.7117678394967422,0.6851690413362851},
{0.2216034548247913,-0.00650010133736978,0.9751152021645035},
{0.028899504377749845,0.736987360775143,0.6752884189029228},
{-0.09190094336802553,0.8119083342818273,0.5765059178636205},
{-0.20869463870359667,0.8086792252975498,0.5499858710444571},
{-0.16569629341537395,0.8863801718973294,0.43229032977348325},
{-0.293284822903112,0.8264572319448417,0.4805751308804488},
{-0.3822013644613067,0.68890245938617,0.6159021987747745},
{0.8678997135931418,0.025199991684004115,0.496099836287081},
{-0.567811523851816,0.705614320587956,0.4239086033124072},
{-0.3705104540999457,0.7966224770202881,0.477613476054343},
{-0.5651129723171711,0.7102163032023622,-0.41980963684082173},
{-0.9931260152767097,-0.03400089066499661,0.11200293395528295},
{-0.8162970246027679,0.25479907125907786,-0.5183981104423311},
{-0.8627978214382515,-0.18109954272423195,-0.47199880820451395},
{-0.3083061014381218,0.4247084050625051,-0.8512168457480676},
{-0.3631056336276089,0.8840137155791966,-0.29440456772230256},
{-0.6018336374220196,-0.4447248563668529,0.663337074945207},
{-0.31508801112926044,0.3027884791175502,0.8994657759783237},
{-0.689085784306903,-0.04329910674864156,0.7233850767197992},
{-0.8032799905446503,-0.5881853484854516,0.0936976660202088},
{0.6787302075600962,0.054902443487622334,-0.7323325931873558},
{0.9302146323912521,-0.1875029494445923,-0.3155049629321007},
{0.20090136412489362,-0.6744045792226394,-0.710504824344136},
{0.6371336861485035,-0.3588189712605291,-0.6821360654871986},
{0.7537984584837286,-0.5025989721861529,-0.4232991343541554},
{0.9450086279681602,-0.04070037159608902,-0.3245029627255746},
{0.9641814686102582,0.021199592547746813,0.2643949183785027},
{0.9730811175441193,0.21879575430958104,0.07239859511889246},
{0.658185911681339,0.415391108648478,0.6278865602320158},
{0.4661747573203181,-0.1580914395803138,0.870452866253404},
{0.07799793308215963,-0.07439802847836764,0.9941736547472193},
{0.37329136400418955,-0.8216809906301702,0.43069003610127093},
{-0.08319766675415335,-0.7980776182270409,0.5967832634480617},
{-0.474189269218255,-0.8688803374604424,-0.14209678438615359},
{-0.07080144825843634,-0.9722198869611837,-0.22310456365052467},
{0.15029765687779376,-0.047799254815426094,-0.9874846052350056},
{-0.49299610041626846,-0.5608955633336409,-0.6650947391214203},
{-0.2860058274281014,-0.07460152002145581,-0.955319464832396},
{-0.46512110302317705,0.6410290841493367,-0.6105277002701561},
{-0.9256671856798911,-0.20249282175670086,-0.3195886707824276},
{-0.8344980723116795,-0.49259886209794285,-0.24689942966297626},
{-0.9771016561887108,-0.16040027187869124,0.1398002369616025},
{-0.8706234897386339,0.4202113374548288,0.2558069017633156},
{-0.8894213419211521,0.2293055022515406,0.3954094879644969},
{-0.27580816817985276,0.9568283368908018,0.09170271581614395},
{0.12759390498473483,0.9816531075510516,0.14169323147599472},
{0.0410982028148855,0.7264682322387912,-0.6859700031876267},
{-0.38789464321196565,-0.19889725324789886,-0.8999875712574609},
{0.3591035569383473,0.11070109649979129,-0.9267091790998787},
{0.157103778391306,-0.49301185707774575,-0.8557205803274383},
{-0.5888897269083203,-0.49719132657296117,-0.6371888843368682},
{-0.25409568803276084,-0.7911865736777661,-0.5562905598292989},
{0.539497253965966,-0.5312972957036474,-0.6531966752373847},
{0.657819846724168,0.008900268525152166,-0.7531227220552917},
{0.7443730765127249,0.37828631763133247,-0.5502800967288455},
{0.3636135194019817,0.4072151405403932,-0.8378311511413099},
{-0.1277981744161176,0.2937958031569276,-0.9472864681094538},
{-0.6226663426804949,0.06409653535541951,-0.7798578459234271},
{-0.8972566904648016,-0.21738950686174957,-0.38428145118201634},
{-0.9325594998203651,-0.24528934731496416,-0.26488849614241344},
{-0.6223163235712537,-0.6633173990435683,-0.41561090161692604},
{-0.8123867541419597,-0.226596305377361,-0.5372912395377585},
{-0.5441055771107483,-0.728507467239809,-0.41620426611559164},
{-0.13150530568858917,-0.7535304017973532,-0.6441259877872265},
{0.4304923157807444,-0.6816878319807977,-0.5915894402227373},
{0.018300851558434982,-0.8567398650334016,-0.5154239832359229},
{0.2646040908108661,-0.48860755393117605,-0.8314128537420791},
{0.6951157028410928,-0.13600307234410677,-0.70591594682136},
{0.7285096091051166,0.19360255363452375,-0.6571086673204833},
{0.7718161890143487,0.36590767499397536,-0.5200109073431735},
{0.6601914175673572,0.25359670326428624,-0.7069908091792206},
{0.666175055542059,0.05489794438495803,-0.7437721499732566},
{0.7471073328944586,0.14360140945475072,-0.6490063700287829},
{0.8650239182420136,0.3043084142439824,-0.3989110300424731},
{0.7103600185115055,0.3178821085090197,-0.6279646560039773},
{0.8815095291695157,0.08580092751303965,-0.46430501916438593},
{0.9211849065089592,0.3556941719987373,-0.1577974145105447},
{0.9602728774756082,0.23819327232603338,-0.14539589335098763},
{0.8739199212316593,0.43941001646548933,0.20780473696296925},
{0.8614919580101079,0.48689545485214336,0.14409865484533552},
{0.8695181339897785,0.4648096937072444,-0.167003482893954},
{0.7771729509661542,0.5243817492108226,-0.34788789197262615},
{0.8590678585773458,0.062097676658890905,-0.5080809905053537},
{0.7917795169288422,0.2526934629046709,-0.5560856142512367},
{0.8453177476324193,0.22960482060381338,-0.4824101283069668},
{0.9355248759371811,0.22160589257902655,-0.2751073152007681},
{0.862736399616566,0.20480864105885327,-0.4623195056714251},
{0.8164988201600573,0.5341992280826731,0.2189996835456859},
{0.5155861283418229,0.675381829096329,0.5272858135660266},
{0.6518153928022536,0.5587131941678722,0.5128121102009753},
{0.5082927695867786,0.579991749676041,0.6365909445582202},
{0.6711611677382195,0.5747667449581773,0.46817291229891894},
{0.7397954835623592,0.6635959487590991,0.11109932174071115},
{0.8890970570936114,0.22339926054967135,-0.3994986776615654},
{0.8111100821609823,0.5253065296007446,-0.2572031970556092},
{0.6064057730104387,-0.35720340059256056,-0.7104067631045773},
{0.6276957128529218,-0.4868966745070696,-0.6073958515005013},
{0.9031385603240172,-0.07460318525099288,-0.422818052602142},
{0.9414007248788372,0.32850025294529217,-0.07650005890506803},
{0.8595283391165186,0.49701638690041855,0.11910392692120694},
{0.6328137195501614,0.6484140577691603,0.42320917527438107},
{0.3648124311953931,0.7516256120791048,0.5495187251695957},
{0.051798316582066184,0.6679782910583053,0.7423758731761763},
{0.13500578512184136,0.6239267358334579,0.7697329837650466},
{0.3283003381495224,0.5252005409568358,0.7851008086542494},
{0.027999968500053155,0.48149945831341406,0.875999014501663},
{0.19049688921119856,0.6095900454758354,0.7694874343727941},
{0.3228875400102419,0.8325678718257274,0.4500826316463607},
{0.681890607021582,0.7312899265506422,0.015499786491911602},
{0.7593878271106964,0.5676908999878093,0.31789490418552857},
{0.8720052233269316,0.4289025691340837,0.2359014130536963},
{-0.253190367555696,0.3820854638350373,0.8887661875335806},
{-0.7108886187643196,0.23999615769227275,0.6610894160431731},
{-0.38041271360533657,0.6770226264742715,0.6300210556555258},
{0.33638985968051754,0.7812764487764221,0.5257841504756723},
{0.8337327246516765,0.5150202149401624,0.1991078151351191},
{-0.7822132625383005,-0.0005000084777156102,0.6230105632336502},
{-0.7567884628478251,0.06529900452426397,0.6503900848787334},
{-0.7452110515618425,0.1949028904312978,0.6377094573013782},
{-0.5326015951441662,0.5786017329147851,0.6177018500198113},
{0.4444124437226388,0.6820190968020694,0.5808162630830526},
{-0.854001494503923,-0.1287002252255912,0.5041008821773157},
{-0.9199355975966869,-0.28541104419403673,0.26881040181975147},
{-0.9251794889980908,-0.12109731530227928,0.3596920257161838},
{-0.655505014632543,0.21410163788379477,0.7242055401935737},
{-0.4625968821075219,0.4015972932433653,0.7903946727578584},
{-0.3965929129479679,0.5182907382272611,0.7576864602639316},
{-0.6041063733558585,-0.5897062214334544,0.5360056548894888},
{-0.9047091783211713,-0.34210347065731483,0.25390257585469816},
{-0.7004300455912222,-0.4642199131402704,0.5421232548757875},
{-0.875525994752682,-0.43461290384867574,0.21110626783813957},
{-0.9130779676944561,-0.27079346583250324,0.3048926430292845},
{-0.8099686872158166,-0.5383791866629575,-0.23259100820543077},
{-0.8868306760036336,-0.46171597103166173,-0.018700646866562864},
{-0.7958084356141264,-0.3410036146574732,-0.5004053043243388},
{-0.2688003911048536,-0.5301007712971834,0.8042011701135539},
{-0.6097016431481425,-0.05940016008364714,0.7904021301366111},
{-0.8931014557565593,-0.2972004844371845,0.33770055045234587},
{-0.8957028035541627,-0.4258013327602573,0.12810040095488245},
{-0.9096983852867994,-0.3938993008293616,0.13149976658812149},
{0.38450853233899995,0.2816062489119958,0.8791195078783222},
{0.049901975907854876,0.25581012900259076,0.9654382272834289},
{-0.5446123056540709,-0.13210298490066613,0.8282187138132604},
{-0.7850753725718376,-0.4066872424213047,0.467185344625605},
{-0.8750891445864917,-0.46759419952993203,0.12479845188480648},
{-0.920398357090399,-0.38789930760035396,0.04899991253523419},
{-0.7854706789268232,-0.6139770806633602,-0.07789709215582372},
{-0.6664918088660031,-0.639192144376818,0.3836952844139316},
{-0.7341389360909908,-0.676635886335873,-0.0566030020198203},
{-0.8951538630284563,-0.42532559261088426,-0.13340802740252047},
{-0.8592826856283252,-0.5114896935865103,0.0033999314920706456},
{-0.8926705512842616,0.06299792173284248,0.44628527729154915},
{-0.521014523482266,-0.7610212137620046,0.3865107741379958},
{-0.5721834727190823,-0.47328632932181347,0.6697806536652242},
{-0.24380899062229683,-0.5270194341999608,0.8141300215980799},
{-0.1883937360124147,-0.4124862850590289,0.8912703657529999},
{-0.4487103428926069,0.14750339999255518,0.881420316972462},
{0.06280178830638339,0.20650588033866513,0.9764278041775916},
{0.44620905367354946,-0.26330534251960014,0.855317354565188},
{0.3803051759886681,0.3538048153163049,0.8545116299824267},
{0.7242106133843093,0.1581023170064337,0.6712098366522348},
{0.8640806664113811,0.4336902962881796,0.25549428337936336},
{-0.42089030700784313,-0.2794935633373537,0.8629801257965518},
{0.12830328268148164,0.028500729200485013,0.9913253633838874},
{0.28440591428248185,-0.28320588932770346,0.9159190467346173},
{0.60839389175599,0.3765962189929419,0.6985929861616282},
{0.3664045690934651,-0.21230264743052027,0.9059112967843068},
{0.5285152584557706,0.07010202387464431,0.8460244250777331},
{0.5165893428717837,0.4492907312278212,0.7288849632583104},
{0.3822013644613067,0.68890245938617,0.6159021987747745},
{0.29330906192345435,0.8264255328112604,0.4806148488251352},
{0.20869463870359667,0.8086792252975498,0.5499858710444571},
{0.16569629341537395,0.8863801718973294,0.43229032977348325},
{0.09190094336802553,0.8119083342818273,0.5765059178636205},
{0.06960175607445891,0.11670294445243326,0.9907249963069892},
{-0.028899504377749845,0.736987360775143,0.6752884189029228},
{-0.09529934910766838,0.026599818323861265,0.9950932035366296},
{-0.2216034548247913,-0.00650010133736978,0.9751152021645035},
{-0.15470402080975196,-0.7117184978041401,0.6852178090422886},
{-0.10769767321690495,-0.7065847344017181,0.6993848899526771},
{-0.02890036212380613,-0.5962074705264088,0.8023100530079467},
{0.252902824940332,-0.030500340690708283,0.9670108015709806},
{-0.019200662050241436,-0.6736232269293038,0.7388254751415819},
{0.08610347994246423,-0.5850236442083806,0.8064325926318601},
{0.4697740222148374,-0.038397876656129745,0.8819512294454802},
{0.6300949246058234,-0.2900976632727335,0.720294198053602},
{-0.06350302186319476,-0.9113433673059744,0.40671935420096544},
{-0.9660471200974521,-0.25821259462646184,-0.00890043412926224},
{-0.3847847301209717,-0.28878853965420126,-0.8766652102314343},
{-0.7298606068368404,-0.4512756430544815,-0.5134722860812679},
{-0.5837272898887184,-0.8116379449609111,-0.02250105194876848},
{-0.651098941965079,-0.7529987763779826,-0.09519984530037709},
{-0.2569992726930874,-0.8854974940456377,-0.38709890451165035},
{-0.12580006730305401,-0.4423002366306899,-0.8880004750803813},
{0.05310176380437763,0.07140237166916315,-0.9960330837883261},
{0.15329670262338949,0.001699963434179792,-0.9881787445038062},
{-0.09349882659708926,-0.17739777367191054,-0.979687704996453},
{-0.6196839070178993,-0.3336913341485767,-0.7103815516306531},
{-0.47620856945031154,-0.6339114073384134,-0.6094109664490127},
{-0.8816185318163102,-0.4684098460784479,-0.057801214994308896},
{-0.7700762743154768,-0.5980815733905813,-0.22199316049608603},
{-0.45009554182573724,-0.864791434283265,-0.22259779517975808},
{0.2565974571317997,0.3994960410138503,-0.8800912783386473},
{0.3853023715433953,-0.16780103281853553,-0.9074055850985645},
{-0.4790931274583796,0.19779716262005317,-0.855187732419967},
{0.5349162456530745,0.29150885325831216,-0.7930240845071752},
{0.25000938802878403,0.0419015734336242,-0.9673363241609712},
{-0.1878031091062071,-0.37180615530185196,-0.9091150505242431},
{0.761065379923283,-0.045597925797532135,-0.6470705654294527},
{0.9443785817366466,0.24059454337763359,-0.22419491531698027},
{-0.33599756570645467,-0.9331932390394747,0.1274990762725386},
{0.836917215564188,0.37250766256142914,-0.40100824882451835},
{0.5659120512254476,0.15680333916266156,-0.809417236723586},
{0.5594961255027463,-0.07319949309526547,-0.8255942827793875},
{0.3713104451097335,-0.21770612415941012,-0.9026253912093871},
{0.2696917866617039,-0.13189598316899795,-0.9538709503025561},
{-0.45459546088698444,-0.10909891065281566,-0.8839911733922002},
{-0.7400073113083538,-0.4890048313916014,-0.4618045626516186},
{-0.4476953014624666,-0.6666930030936487,-0.5958937461279514},
{0.5937198127607333,0.15740525270092542,-0.789126333585135},
{0.8562894077655385,0.30159626927722344,-0.41929481335523805},
{0.8180930503290561,0.551295316766176,-0.16369860938621988},
{0.144601569658558,0.18880204945737034,-0.971310543633177},
{0.9310873093664596,0.364695029240627,-0.008599882784396468},
{-0.9018361192598789,-0.27711109852174814,-0.33151327737264347},
{-0.9299113170895938,-0.3674044713396245,-0.016700203242710203},
{-0.8387126017515126,-0.5205078206887591,-0.16010240555671537},
{-0.9607287550419641,-0.0067002005400032885,-0.277408302954763},
{-0.9540365498403499,-0.19530748237297732,-0.2273087083634293},
{-0.6030179551269248,-0.14290425503754156,-0.7848233684636993},
{-0.8617552200534547,0.06629655498902767,-0.5029738636422462},
{-0.9507250566890579,0.27880734806448865,-0.135603573879285},
{0.9854543252505124,-0.07459654253037871,-0.15269292284703526},
{0.7794980902320183,0.23239943062209245,-0.5816985748402375},
{0.11519452608617747,-0.6955669474439675,-0.7091663012180301},
{-0.3093038322982234,-0.7677095119797804,-0.5612069533972291},
{-0.23079739085024462,-0.890589931937729,-0.3918955696456277},
{0.20189171655280125,-0.7776680929327069,-0.5953755722413961},
{-0.5609020108373133,-0.815102922149214,-0.14490051946929344},
{-0.5195840697966263,-0.8519738788813042,-0.0645980194550848},
{-0.1833995616755714,-0.9200978009688835,-0.34609917282396546},
{0.29410089847961723,-0.7618023273096649,-0.5772017633540806},
{0.7751030771653246,-0.3058012140332296,-0.5529021950260713},
{0.9500971829660287,0.10259969579235297,-0.2945991265148848},
{0.8318209039219767,-0.2809070592831008,-0.4787120301844798},
{0.46030511171664856,-0.6211068974303942,-0.634307044018836},
{-0.6856974046402351,0.3231987766949453,0.6521975314370152},
{-0.5840977950349855,0.2192991721471877,0.7814970498542051},
{-0.831186750988783,-0.3787939620723665,0.4069935125751139},
{-0.9541532190144795,-0.2988853460107188,0.016099210675050428},
{-0.7942822916737085,-0.4998888551022118,-0.34529230179394627},
{-0.45900299270926875,0.28640186734626266,0.8410054833736275},
{-0.8017056841134506,-0.3122022135215408,0.5097036138114329},
{-0.9057709569198921,-0.24679208673860603,0.34448895413877545},
{-0.8390186390061006,-0.54361207647642,0.023100513183600627},
{-0.6542898618571352,-0.7098890003551587,-0.26069596054738675},
{-0.462997689647293,0.31969840470894073,0.8266958747978771},
{-0.6391077620109047,0.12610153151240036,0.7587092145793669},
{-0.5761028747605176,0.11600057884433267,0.8091040374392203},
{-0.7914941627520744,-0.4242968708221165,0.4398967557733892},
{-0.7441821696088217,-0.6531843498904627,0.1397966505123801},
{-0.7920979326270938,-0.5708985099568334,0.2159994362422071},
{-0.6926130316367864,-0.7144134418153628,0.09950187214533679},
{-0.7537984584837286,-0.5025989721861529,-0.4232991343541554},
{-0.9641855373254093,0.020999685007087324,0.2643960340892328},
{-0.9450086279681602,-0.04070037159608902,-0.3245029627255746},
{-0.6371336861485035,-0.3588189712605291,-0.6821360654871986},
{-0.20090136412489362,-0.6744045792226394,-0.710504824344136},
{0.07080144825843634,-0.9722198869611837,-0.22310456365052467},
{0.4741960049154878,-0.8688926796100113,-0.14199880366511863},
{-0.37329136400418955,-0.8216809906301702,0.43069003610127093},
{0.08329697054427096,-0.7980709746864664,0.5967782955680782},
{-0.07799793308215963,-0.07439802847836764,0.9941736547472193},
{-0.46621533640574075,-0.1581052009561296,0.8704286332208424},
{-0.6582132499660841,0.4153083602414383,0.6279126400086663},
{-0.9730882938182377,0.21869736908647477,0.0725991266377598},
{0.4930994427979444,-0.560799366297074,-0.6650992484382738},
{-0.15029765687779376,-0.047799254815426094,-0.9874846052350056},
{0.2860058274281014,-0.07460152002145581,-0.955319464832396},
{0.46512110302317705,0.6410290841493367,-0.6105277002701561},
{-0.0410982028148855,0.7264682322387912,-0.6859700031876267},
{-0.12759571221813515,0.9816670116343517,0.14159524177184904},
{0.27580816817985276,0.9568283368908018,0.09170271581614395},
{0.8894213419211521,0.2293055022515406,0.3954094879644969},
{0.8706234897386339,0.4202113374548288,0.2558069017633156},
{0.9771016561887108,-0.16040027187869124,0.1398002369616025},
{0.9256859250525135,-0.20239692257818812,-0.3195951405928306},
{0.8344980723116795,-0.49259886209794285,-0.24689942966297626},
{0.689085784306903,-0.04329910674864156,0.7233850767197992},
{0.9931327490923609,-0.0338011146101317,0.11200369338268495},
{0.567811523851816,0.705614320587956,0.4239086033124072},
{0.31508801112926044,0.3027884791175502,0.8994657759783237},
{0.3705967239394405,0.7965929581493748,0.4775957780719827},
{0.565072837601529,0.7102658583407646,-0.4197798216689469},
{0.8162970246027679,0.25479907125907786,-0.5183981104423311},
{0.8628797139363852,-0.18099574484005762,-0.47188890602222755},
{0.8034850954897167,-0.5878890947584374,0.09379826005841373},
{0.6019241797799624,-0.44461786065820114,0.6633266463665876},
{0.3082930064524721,0.42479036373989665,-0.8511806911850283},
{0.3631056336276089,0.8840137155791966,-0.29440456772230256},
{-0.8678997135931418,0.025199991684004115,0.496099836287081}
};


// face array: 18kb.
const uint16_t nanosuit_1_face[9237] PROGMEM = {
6, // chain 0
0,0,0, 1,1,1, 2,2,2, 
3,3,3, 4,4,4, 5,5,5, 32774,6,6, 32775,7,7, 
13, // chain 1
1,1,1, 0,0,0, 8,8,8, 
9,9,9, 32778,10,10, 32779,11,11, 32780,12,12, 32781,13,13, 32782,14,14, 32783,15,15, 32768,0,0, 5,5,5, 16,16,16, 32785,17,17, 32774,6,6, 
5, // chain 2
18,18,18, 19,19,19, 20,20,20, 
21,21,21, 32790,22,22, 32778,10,10, 32787,19,19, 
11, // chain 3
22,22,22, 10,10,10, 11,11,11, 
12,12,12, 23,23,23, 32781,13,13, 14,14,14, 24,24,24, 32793,25,25, 32794,26,26, 32795,27,27, 32784,16,16, 32783,15,15, 
17, // chain 4
28,28,28, 29,29,29, 18,18,18, 
21,21,21, 30,30,30, 32799,31,31, 32800,32,32, 32790,22,22, 23,23,23, 33,33,33, 32792,24,24, 34,34,34, 32803,35,35, 32793,25,25, 36,36,36, 32805,37,37, 32794,26,26, 38,38,38, 32795,27,27, 
7, // chain 5
29,29,29, 28,28,28, 39,39,39, 
40,40,40, 32809,41,41, 32810,42,42, 32811,43,43, 32798,30,30, 32796,28,28, 
1, // chain 6
40,40,40, 41,41,41, 44,44,44, 
7, // chain 7
41,41,41, 42,42,42, 45,45,45, 
32811,43,43, 46,46,46, 32815,47,47, 32816,48,48, 32799,31,31, 32798,30,30, 
40, // chain 8
41,41,41, 45,45,45, 49,49,49, 
32814,46,46, 50,50,50, 32815,47,47, 51,51,51, 32816,48,48, 52,52,52, 32821,53,53, 32799,31,31, 32,32,32, 33,33,33, 52,52,52, 32822,54,54, 32802,34,34, 55,55,55, 32824,56,56, 32803,35,35, 
36,36,36, 57,57,57, 58,58,58, 55,55,55, 32827,59,59, 32828,60,60, 32829,61,61, 62,62,62, 63,63,63, 32832,64,64, 65,65,65, 66,66,66, 60,60,60, 32827,59,59, 32835,67,67, 32836,68,68, 
32837,69,69, 70,70,70, 71,71,71, 72,72,72, 32841,73,73, 74,74,74, 32843,75,75, 
16, // chain 9
49,49,49, 50,50,50, 76,76,76, 
32845,77,77, 32846,78,78, 32819,51,51, 79,79,79, 32820,52,52, 80,80,80, 32849,81,81, 32822,54,54, 82,82,82, 32823,55,55, 59,59,59, 83,83,83, 32835,67,67, 72,72,72, 32836,68,68, 
18, // chain 10
77,77,77, 78,78,78, 84,84,84, 
32853,85,85, 32847,79,79, 86,86,86, 32848,80,80, 81,81,81, 87,87,87, 32856,88,88, 32850,82,82, 83,83,83, 89,89,89, 32840,72,72, 74,74,74, 90,90,90, 91,91,91, 32860,92,92, 93,93,93, 
32862,94,94, 
12, // chain 11
95,95,95, 96,96,96, 97,97,97, 
85,85,85, 98,98,98, 32854,86,86, 87,87,87, 99,99,99, 32868,100,100, 32869,101,101, 32870,102,102, 32856,88,88, 91,91,91, 32857,89,89, 
1, // chain 12
27,27,27, 16,16,16, 17,17,17, 
1, // chain 13
103,103,103, 36,36,36, 37,37,37, 
3, // chain 14
91,91,91, 93,93,93, 104,104,104, 
102,102,102, 32869,101,101, 
1, // chain 15
99,99,99, 100,100,100, 105,105,105, 
29, // chain 16
106,106,106, 107,107,107, 108,108,108, 
109,109,109, 32878,110,110, 32879,111,111, 32880,112,112, 32881,113,113, 32882,114,114, 32875,107,107, 115,115,115, 32884,116,116, 32885,117,117, 118,118,118, 32887,119,119, 120,120,120, 121,121,121, 32890,122,122, 123,123,123, 
124,124,124, 125,125,125, 32894,126,126, 32895,127,127, 128,128,128, 129,129,129, 130,130,130, 32899,131,131, 132,132,132, 32809,133,41, 32901,134,133, 44,135,44, 
27, // chain 17
112,112,112, 113,113,113, 134,136,134, 
32903,137,135, 32904,138,136, 32882,114,114, 137,139,137, 32883,115,115, 116,116,116, 138,140,138, 32907,141,139, 32908,142,140, 32886,118,118, 141,143,141, 32889,121,121, 142,144,142, 32893,125,125, 141,143,141, 32911,145,143, 
32912,146,144, 32913,147,145, 32914,148,146, 32894,126,126, 147,149,147, 32898,130,130, 132,132,132, 148,150,148, 32817,151,49, 32809,133,41, 
10, // chain 18
149,152,149, 112,112,112, 134,136,134, 
6,153,6, 32785,154,17, 32918,155,150, 32903,137,135, 151,156,151, 32920,157,152, 32904,138,136, 138,140,138, 32905,139,137, 
2, // chain 19
7,158,7, 153,159,153, 149,152,149, 
6,153,6, 
5, // chain 20
17,154,17, 150,155,150, 154,160,154, 
27,161,27, 32923,162,155, 32919,156,151, 32918,155,150, 
22, // chain 21
151,156,151, 152,157,152, 156,163,156, 
32906,140,138, 157,164,157, 32926,165,158, 32927,166,159, 32907,141,139, 160,167,160, 32929,168,161, 32930,169,162, 32908,142,140, 141,143,141, 163,170,163, 32911,145,143, 164,171,164, 32933,172,165, 32912,146,144, 166,173,166, 
32935,174,167, 32913,147,145, 168,175,168, 32915,149,147, 32914,148,146, 
7, // chain 22
155,162,155, 151,156,151, 156,163,156, 
169,176,169, 32925,164,157, 170,177,170, 32926,165,158, 160,167,160, 32927,166,159, 
4, // chain 23
148,150,148, 49,151,49, 76,178,76, 
171,179,171, 32852,180,84, 32845,181,77, 
36, // chain 24
147,149,147, 148,150,148, 172,182,172, 
32939,179,171, 173,183,173, 32942,184,174, 32943,185,175, 32852,180,84, 85,186,85, 97,187,97, 96,188,96, 176,189,176, 174,184,174, 32945,190,177, 32946,191,178, 179,192,179, 180,193,180, 181,194,181, 32950,195,182, 
32873,196,105, 183,197,183, 184,198,184, 185,199,185, 32954,200,186, 32955,201,187, 188,202,188, 189,203,189, 190,204,190, 32959,205,191, 32960,206,192, 193,207,193, 194,208,194, 32963,209,195, 196,210,196, 197,211,197, 
198,212,198, 32967,213,199, 32843,214,75, 
7, // chain 25
200,215,200, 174,184,174, 177,190,177, 
201,216,201, 32949,194,181, 202,217,202, 32971,218,203, 32953,199,185, 32950,195,182, 
24, // chain 26
173,183,173, 174,184,174, 200,215,200, 
172,182,172, 32972,219,204, 32969,216,201, 202,217,202, 205,220,205, 32971,218,203, 206,221,206, 32975,222,207, 32976,223,208, 32953,199,185, 209,224,209, 32954,200,186, 190,204,190, 208,223,208, 32978,225,210, 32959,205,191, 
194,208,194, 211,226,211, 32980,227,212, 32981,228,213, 32966,212,198, 214,229,214, 32967,213,199, 
6, // chain 27
147,149,147, 172,182,172, 168,175,168, 
32972,219,204, 167,174,167, 32975,222,207, 32973,220,205, 206,221,206, 
28, // chain 28
167,174,167, 207,222,207, 166,173,166, 
32983,230,215, 32984,231,216, 32985,232,217, 32976,223,208, 216,231,216, 32978,225,210, 218,233,218, 32979,226,211, 212,227,212, 219,234,219, 32988,235,220, 32989,236,221, 32990,237,222, 32981,228,213, 214,229,214, 223,238,223, 
32992,239,224, 225,240,225, 226,241,226, 227,242,227, 32996,243,228, 229,244,229, 32998,245,230, 32833,246,65, 32837,247,69, 32999,248,231, 70,249,70, 
6, // chain 29
166,173,166, 215,230,215, 165,172,165, 
33000,250,232, 32988,235,220, 32987,234,219, 32986,233,218, 32984,231,216, 
8, // chain 30
165,172,165, 232,250,232, 164,171,164, 
32929,168,161, 33001,251,233, 33002,252,234, 32988,235,220, 221,236,221, 223,238,223, 32990,237,222, 
4, // chain 31
235,253,235, 162,169,162, 163,170,163, 
164,171,164, 161,168,161, 162,169,162, 
11, // chain 32
234,252,234, 223,238,223, 236,254,236, 
32995,242,227, 229,244,229, 237,255,237, 32938,177,170, 32998,245,230, 238,256,238, 33007,257,239, 33008,258,240, 32833,246,65, 64,259,64, 
4, // chain 33
234,252,234, 236,254,236, 233,251,233, 
33005,255,237, 160,167,160, 32938,177,170, 
1, // chain 34
66,260,66, 65,246,65, 69,247,69, 
13, // chain 35
241,261,241, 240,258,240, 242,262,242, 
243,263,243, 33012,264,244, 245,265,245, 33014,266,246, 103,267,103, 247,268,247, 33016,269,248, 32805,270,37, 38,271,38, 247,268,247, 32923,162,155, 32795,161,27, 
8, // chain 36
239,257,239, 240,258,240, 241,261,241, 
243,263,243, 238,256,238, 33017,272,249, 32937,176,169, 33013,265,245, 247,268,247, 155,162,155, 
2, // chain 37
238,256,238, 249,272,249, 169,176,169, 
170,177,170, 
1, // chain 38
233,251,233, 160,167,160, 161,168,161, 
20, // chain 39
250,273,250, 57,274,57, 36,275,36, 
251,276,251, 252,277,252, 33021,278,253, 33022,279,254, 255,280,255, 33024,281,256, 33025,282,257, 258,283,258, 259,284,259, 33028,285,260, 261,286,261, 33030,287,262, 263,288,263, 33032,289,264, 33033,290,265, 266,291,266, 
62,292,62, 32832,293,64, 33008,294,240, 
9, // chain 40
57,274,57, 250,273,250, 58,295,58, 
32829,296,61, 33020,277,252, 267,297,267, 33021,278,253, 255,280,255, 268,298,268, 33027,284,259, 33024,281,256, 
6, // chain 41
62,292,62, 61,296,61, 267,297,267, 
264,289,264, 33036,298,268, 263,288,263, 33029,286,261, 33027,284,259, 
10, // chain 42
269,299,269, 251,300,251, 36,301,36, 
103,302,103, 246,303,246, 270,304,270, 33039,305,271, 33012,306,244, 242,307,242, 265,308,265, 33034,309,266, 33008,310,240, 
7, // chain 43
251,300,251, 269,299,269, 272,311,272, 
254,312,254, 33025,313,257, 33041,314,273, 33042,315,274, 33038,304,270, 33037,299,269, 
10, // chain 44
274,315,274, 270,304,270, 271,305,271, 
273,314,273, 33043,316,275, 33033,308,265, 262,317,262, 276,318,276, 33028,319,260, 258,320,258, 273,314,273, 33025,313,257, 
1, // chain 45
275,316,275, 276,318,276, 273,314,273, 
2, // chain 46
277,321,277, 278,322,278, 279,323,279, 
280,324,280, 
9, // chain 47
279,323,279, 278,322,278, 281,325,281, 
282,326,282, 283,327,283, 33052,328,284, 285,329,285, 33054,330,286, 33055,331,287, 288,332,288, 289,333,289, 
13, // chain 48
290,334,290, 277,335,277, 280,336,280, 
279,337,279, 283,338,283, 285,339,285, 286,340,286, 289,341,289, 288,342,288, 287,343,287, 284,344,284, 282,345,282, 281,346,281, 278,347,278, 277,335,277, 
13, // chain 49
291,348,291, 292,349,292, 293,350,293, 
294,351,294, 33063,352,295, 33064,353,296, 33060,349,292, 297,354,297, 33066,355,298, 33067,356,299, 33059,348,291, 300,357,300, 33069,358,301, 33070,359,302, 33062,351,294, 
2, // chain 50
295,352,295, 296,353,296, 303,360,303, 
33065,354,297, 
5, // chain 51
299,361,299, 300,362,300, 301,363,301, 
298,364,298, 33063,365,295, 33070,366,302, 294,367,294, 
2, // chain 52
297,368,297, 298,364,298, 295,365,295, 
303,369,303, 
19, // chain 53
304,370,304, 305,371,305, 306,372,306, 
307,373,307, 33076,374,308, 309,375,309, 33078,376,310, 311,377,311, 312,378,312, 33081,379,313, 314,380,314, 315,381,315, 309,375,309, 33084,382,316, 307,373,307, 33072,370,304, 33085,383,317, 33086,384,318, 319,385,319, 
305,371,305, 304,370,304, 
4, // chain 54
320,386,320, 90,387,90, 321,388,321, 
75,389,75, 32842,390,74, 32858,387,90, 
35, // chain 55
320,386,320, 75,389,75, 322,391,322, 
32965,392,197, 323,393,323, 324,394,324, 33093,395,325, 326,396,326, 33095,397,327, 328,398,328, 33097,399,329, 33098,400,330, 331,401,331, 33100,402,332, 333,403,333, 33102,404,334, 335,405,335, 33104,406,336, 337,407,337, 
33106,408,338, 339,409,339, 33108,410,340, 33109,411,341, 342,412,342, 343,413,343, 344,414,344, 33113,415,345, 32960,416,192, 94,417,94, 92,418,92, 346,419,346, 32858,387,90, 347,420,347, 33088,386,320, 348,421,348, 
33092,394,324, 33090,391,322, 
15, // chain 56
345,415,345, 346,419,346, 344,414,344, 
33108,410,340, 33117,422,349, 33115,420,347, 350,423,350, 33116,421,348, 351,424,351, 33092,394,324, 326,396,326, 350,423,350, 33120,425,352, 33096,398,328, 329,399,329, 333,403,333, 33099,401,331, 
7, // chain 57
340,410,340, 349,422,349, 350,423,350, 
353,426,353, 33120,425,352, 339,409,339, 33105,407,337, 33101,403,333, 335,405,335, 
1, // chain 58
339,409,339, 340,410,340, 353,426,353, 
21, // chain 59
193,427,193, 192,428,192, 343,429,343, 
354,430,354, 33110,431,342, 341,432,341, 355,433,355, 33124,434,356, 33106,435,338, 336,436,336, 357,437,357, 33126,438,358, 33102,439,334, 332,440,332, 359,441,359, 33098,442,330, 360,443,360, 33095,444,327, 361,445,361, 
33093,446,325, 323,447,323, 196,448,196, 32965,449,197, 
11, // chain 60
195,450,195, 193,427,193, 354,430,354, 
355,433,355, 196,448,196, 33130,451,362, 33131,452,363, 33132,453,364, 33124,434,356, 357,437,357, 363,452,363, 33127,441,359, 33126,438,358, 
4, // chain 61
196,448,196, 362,451,362, 361,445,361, 
33128,443,360, 33131,452,363, 359,441,359, 
7, // chain 62
365,454,365, 366,455,366, 367,456,367, 
368,457,368, 33137,458,369, 33138,459,370, 33139,460,371, 33140,461,372, 33134,455,366, 
5, // chain 63
372,461,372, 373,462,373, 374,463,374, 
371,460,371, 33143,464,375, 370,459,370, 33137,458,369, 
3, // chain 64
365,454,365, 368,457,368, 376,465,376, 
33145,466,377, 33137,458,369, 
1, // chain 65
378,467,378, 376,465,376, 377,466,377, 
4, // chain 66
305,468,305, 319,469,319, 313,470,313, 
311,471,311, 308,472,308, 33078,473,310, 
4, // chain 67
314,474,314, 313,470,313, 319,469,319, 
318,475,318, 316,476,316, 315,477,315, 
1, // chain 68
305,468,305, 308,472,308, 306,478,306, 
14, // chain 69
379,479,379, 380,480,380, 381,481,381, 
382,482,382, 33151,483,383, 384,484,384, 385,485,385, 33154,486,386, 387,487,387, 33156,488,388, 389,489,389, 390,490,390, 379,479,379, 33159,491,391, 392,492,392, 380,480,380, 
2, // chain 70
379,479,379, 382,482,382, 385,485,385, 
387,487,387, 
5, // chain 71
392,493,392, 391,494,391, 390,495,390, 
389,496,389, 384,497,384, 33154,498,386, 33156,499,388, 
3, // chain 72
392,493,392, 384,497,384, 383,500,383, 
381,501,381, 380,502,380, 
10, // chain 73
393,503,393, 369,504,369, 375,505,375, 
374,506,374, 373,507,373, 372,508,372, 366,509,366, 365,510,365, 376,511,376, 378,512,378, 377,513,377, 369,504,369, 
19, // chain 74
394,514,394, 395,515,395, 396,516,396, 
397,517,397, 398,518,398, 33167,519,399, 33168,520,400, 401,521,401, 402,522,402, 33171,523,403, 404,524,404, 405,525,405, 399,519,399, 33166,518,398, 33174,526,406, 407,527,407, 33176,528,408, 409,529,409, 395,515,395, 
398,518,398, 33162,514,394, 
6, // chain 75
410,530,410, 104,531,104, 93,532,93, 
411,533,411, 32862,534,94, 412,535,412, 33181,536,413, 32960,537,192, 
44, // chain 76
101,538,101, 104,531,104, 410,530,410, 
414,539,414, 33183,540,415, 33184,541,416, 33179,533,411, 417,542,417, 33186,543,418, 33180,535,412, 413,536,413, 419,544,419, 420,545,420, 421,546,421, 33190,547,422, 33191,548,423, 424,549,424, 425,550,425, 33194,551,426, 
427,552,427, 33196,553,428, 429,554,429, 33198,555,430, 431,556,431, 33200,557,432, 433,558,433, 33202,559,434, 33203,560,435, 436,561,436, 33205,562,437, 438,563,438, 439,564,439, 32951,565,183, 105,566,105, 440,567,440, 
32868,568,100, 101,538,101, 414,539,414, 439,564,439, 33204,561,436, 33183,540,415, 416,541,416, 441,569,441, 33185,542,417, 421,546,421, 33186,543,418, 
10, // chain 77
434,559,434, 436,561,436, 441,569,441, 
433,558,433, 33189,546,421, 422,547,422, 442,570,442, 33193,550,425, 427,552,427, 429,554,429, 431,556,431, 433,558,433, 
8, // chain 78
443,571,443, 189,572,189, 188,573,188, 
444,574,444, 33213,575,445, 32955,576,187, 446,577,446, 32952,578,184, 438,579,438, 32951,580,183, 
12, // chain 79
192,581,192, 189,572,189, 443,571,443, 
413,582,413, 33215,583,447, 33212,574,444, 448,584,448, 33213,575,445, 449,585,449, 33218,586,450, 33203,587,435, 33214,577,446, 437,588,437, 33206,579,438, 
10, // chain 80
413,582,413, 447,583,447, 419,589,419, 
33188,590,420, 33191,591,423, 33216,584,448, 451,592,451, 33217,585,449, 452,593,452, 33218,586,450, 432,594,432, 33203,587,435, 
7, // chain 81
452,593,452, 432,594,432, 430,595,430, 
428,596,428, 453,597,453, 33194,598,426, 424,599,424, 451,592,451, 33191,591,423, 
1, // chain 82
451,592,451, 452,593,452, 453,597,453, 
7, // chain 83
454,600,454, 455,601,455, 456,602,456, 
457,603,457, 33226,604,458, 33227,605,459, 33228,606,460, 33229,607,461, 33223,601,455, 
3, // chain 84
461,607,461, 462,608,462, 463,609,463, 
460,606,460, 33227,605,459, 
5, // chain 85
458,604,458, 459,605,459, 464,610,464, 
457,603,457, 33233,611,465, 466,612,466, 33235,613,467, 
1, // chain 86
454,600,454, 457,603,457, 466,612,466, 
3, // chain 87
395,614,395, 409,615,409, 401,616,401, 
397,617,397, 33168,618,400, 
5, // chain 88
403,619,403, 401,616,401, 409,615,409, 
404,620,404, 33176,621,408, 406,622,406, 405,623,405, 
1, // chain 89
395,614,395, 397,617,397, 396,624,396, 
14, // chain 90
468,625,468, 469,626,469, 470,627,470, 
471,628,471, 472,629,472, 33241,630,473, 33242,631,474, 475,632,475, 472,629,472, 33244,633,476, 477,634,477, 478,635,478, 479,636,479, 468,625,468, 33248,637,480, 469,626,469, 
6, // chain 91
479,638,479, 478,639,478, 477,640,477, 
480,641,480, 33239,642,471, 33242,643,474, 33243,644,475, 33244,645,476, 
2, // chain 92
480,641,480, 471,642,471, 470,646,470, 
469,647,469, 
10, // chain 93
481,648,481, 464,649,464, 459,650,459, 
463,651,463, 462,652,462, 461,653,461, 455,654,455, 454,655,454, 466,656,466, 467,657,467, 465,658,465, 464,649,464, 
5, // chain 94
482,659,482, 483,660,483, 484,661,484, 
485,662,485, 486,663,486, 33255,664,487, 33256,665,488, 
9, // chain 95
483,660,483, 482,659,482, 489,666,489, 
33258,667,490, 33259,668,491, 33254,663,486, 492,669,492, 33255,664,487, 493,670,493, 494,671,494, 491,668,491, 
3, // chain 96
495,672,495, 483,660,483, 489,666,489, 
496,673,496, 33258,667,490, 
9, // chain 97
99,674,99, 497,675,497, 498,676,498, 
499,677,499, 33268,678,500, 33269,679,501, 33265,675,497, 502,680,502, 33271,681,503, 32873,682,105, 32867,674,99, 
15, // chain 98
99,674,99, 499,677,499, 98,683,98, 
32863,684,95, 33272,685,504, 33273,686,505, 33268,678,500, 501,679,501, 506,687,506, 33270,680,502, 507,688,507, 33271,681,503, 508,689,508, 33277,690,509, 33278,691,510, 32873,682,105, 180,692,180, 
22, // chain 99
96,693,96, 95,684,95, 504,685,504, 
511,694,511, 33273,686,505, 512,695,512, 33281,696,513, 33282,697,514, 33274,687,506, 515,698,515, 33275,688,507, 508,689,508, 516,699,516, 33285,700,517, 518,701,518, 519,702,519, 33288,703,520, 521,704,521, 33290,705,522, 
523,706,523, 33292,707,524, 525,708,525, 33282,697,514, 33281,696,513, 
2, // chain 100
511,694,511, 526,709,526, 96,693,96, 
32944,710,176, 
7, // chain 101
525,708,525, 514,697,514, 515,698,515, 
516,699,516, 527,711,527, 33287,702,519, 521,704,521, 523,706,523, 525,708,525, 
4, // chain 102
178,712,178, 176,713,176, 526,714,526, 
528,715,528, 33280,716,512, 33279,717,511, 
3, // chain 103
178,712,178, 528,715,528, 529,718,529, 
33281,719,513, 33280,716,512, 
20, // chain 104
179,720,179, 178,712,178, 529,718,529, 
530,721,530, 33299,722,531, 33281,719,513, 532,723,532, 33292,724,524, 522,725,522, 533,726,533, 33288,727,520, 534,728,534, 33286,729,518, 517,730,517, 531,722,531, 33303,731,535, 33276,732,508, 509,733,509, 510,734,510, 
180,735,180, 530,721,530, 32947,720,179, 
1, // chain 105
531,722,531, 535,731,535, 530,721,530, 
2, // chain 106
531,722,531, 532,723,532, 534,728,534, 
33301,726,533, 
6, // chain 107
536,736,536, 537,737,537, 538,738,538, 
539,739,539, 33308,740,540, 33309,741,541, 33310,742,542, 33305,737,537, 
5, // chain 108
542,742,542, 543,743,543, 544,744,544, 
541,741,541, 33313,745,545, 540,740,540, 33307,739,539, 
3, // chain 109
536,736,536, 539,739,539, 546,746,546, 
33315,747,547, 548,748,548, 
5, // chain 110
483,749,483, 495,750,495, 493,751,493, 
487,752,487, 484,753,484, 33256,754,488, 485,755,485, 
4, // chain 111
494,756,494, 493,751,493, 495,750,495, 
496,757,496, 490,758,490, 491,759,491, 
12, // chain 112
549,760,549, 550,761,550, 551,762,551, 
552,763,552, 553,764,553, 554,765,554, 33323,766,555, 556,767,556, 557,768,557, 558,769,558, 549,760,549, 33327,770,559, 560,771,560, 550,761,550, 
6, // chain 113
558,772,558, 557,773,557, 559,774,559, 
33328,775,560, 33320,776,552, 33321,777,553, 33323,778,555, 33324,779,556, 
2, // chain 114
560,775,560, 552,776,552, 551,780,551, 
550,781,550, 
10, // chain 115
561,782,561, 539,783,539, 545,784,545, 
544,785,544, 543,786,543, 542,787,542, 537,788,537, 536,789,536, 546,790,546, 548,791,548, 547,792,547, 539,783,539, 
23, // chain 116
562,793,562, 563,794,563, 564,795,564, 
565,796,565, 566,797,566, 33335,798,567, 568,799,568, 569,800,569, 33338,801,570, 33339,802,571, 572,803,572, 573,804,573, 569,800,569, 33342,805,574, 575,806,575, 33344,807,576, 33345,808,577, 33346,809,578, 579,810,579, 
563,794,563, 576,807,576, 33330,793,562, 575,806,575, 33334,797,566, 569,800,569, 
10, // chain 117
231,811,231, 580,812,580, 581,813,581, 
70,814,70, 33350,815,582, 33351,816,583, 33352,817,584, 33353,818,585, 33348,812,580, 586,819,586, 32996,820,228, 32999,811,231, 
13, // chain 118
71,821,71, 70,814,70, 582,815,582, 
587,822,587, 33351,816,583, 588,823,588, 33357,824,589, 33358,825,590, 33352,817,584, 591,826,591, 33353,818,585, 592,827,592, 33361,828,593, 33362,829,594, 33354,819,586, 
31, // chain 119
73,830,73, 71,821,71, 587,822,587, 
588,823,588, 75,831,75, 33363,832,595, 33364,833,596, 33357,824,589, 590,825,590, 597,834,597, 33366,835,598, 33359,826,591, 592,827,592, 599,836,599, 33368,837,600, 601,838,601, 33370,839,602, 603,840,603, 33372,841,604, 
605,842,605, 33374,843,606, 607,844,607, 33376,845,608, 33377,846,609, 597,834,597, 33378,847,610, 611,848,611, 596,833,596, 33380,849,612, 595,832,595, 32982,850,214, 199,851,199, 75,831,75, 
5, // chain 120
597,834,597, 598,835,598, 608,845,608, 
33375,844,607, 33367,836,599, 603,840,603, 33369,838,601, 
1, // chain 121
605,842,605, 607,844,607, 603,840,603, 
25, // chain 122
224,852,224, 214,853,214, 613,854,613, 
33380,855,612, 614,856,614, 33379,857,611, 610,858,610, 615,859,615, 33384,860,616, 33377,861,609, 617,862,617, 33374,863,606, 604,864,604, 618,865,618, 33370,866,602, 619,867,619, 33368,868,600, 620,869,620, 33360,870,592, 
593,871,593, 621,872,621, 33390,873,622, 33362,874,594, 586,875,586, 225,876,225, 32994,877,226, 32996,878,228, 
14, // chain 123
224,852,224, 613,854,613, 614,856,614, 
623,879,623, 33383,859,615, 624,880,624, 33389,872,621, 33393,881,625, 33384,860,616, 617,862,617, 626,882,626, 33386,865,618, 619,867,619, 620,869,620, 625,881,625, 33389,872,621, 
4, // chain 124
225,876,225, 224,852,224, 623,879,623, 
624,880,624, 622,873,622, 33389,872,621, 
11, // chain 125
627,883,627, 628,884,628, 629,885,629, 
630,886,630, 33399,887,631, 33400,888,632, 33401,889,633, 33402,890,634, 33396,884,628, 635,891,635, 636,892,636, 637,893,637, 633,889,633, 
1, // chain 126
633,889,633, 631,887,631, 632,888,632, 
3, // chain 127
627,883,627, 630,886,630, 638,894,638, 
33407,895,639, 33399,887,631, 
1, // chain 128
640,896,640, 638,894,638, 639,895,639, 
3, // chain 129
563,897,563, 579,898,579, 568,899,568, 
565,900,565, 33335,901,567, 
5, // chain 130
571,902,571, 568,899,568, 579,898,579, 
572,903,572, 33346,904,578, 574,905,574, 573,906,573, 
1, // chain 131
563,897,563, 565,900,565, 564,907,564, 
14, // chain 132
641,908,641, 642,909,642, 643,910,643, 
644,911,644, 33413,912,645, 646,913,646, 647,914,647, 33416,915,648, 649,916,649, 33418,917,650, 651,918,651, 652,919,652, 641,908,641, 33421,920,653, 654,921,654, 642,909,642, 
2, // chain 133
641,908,641, 644,911,644, 647,914,647, 
649,916,649, 
5, // chain 134
654,922,654, 653,923,653, 652,924,652, 
651,925,651, 646,926,646, 33416,927,648, 33418,928,650, 
3, // chain 135
654,922,654, 646,926,646, 645,929,645, 
643,930,643, 642,931,642, 
10, // chain 136
655,932,655, 631,933,631, 633,934,633, 
637,935,637, 636,936,636, 635,937,635, 628,938,628, 627,939,627, 638,940,638, 640,941,640, 639,942,639, 631,933,631, 
16, // chain 137
656,943,656, 657,944,657, 658,945,658, 
33427,946,659, 33428,947,660, 661,948,661, 662,949,662, 33431,950,663, 33432,951,664, 33433,952,665, 666,953,666, 667,954,667, 33436,955,668, 33437,956,669, 670,957,670, 33439,958,671, 672,959,672, 33441,960,673, 
14, // chain 138
674,961,674, 656,943,656, 658,945,658, 
675,962,675, 33444,963,676, 33445,964,677, 33427,946,659, 678,965,678, 33447,966,679, 33448,967,680, 33430,949,662, 663,950,663, 681,968,681, 33450,969,682, 33435,954,667, 33432,951,664, 
16, // chain 139
683,970,683, 670,957,670, 672,959,672, 
684,971,684, 33453,972,685, 686,973,686, 33455,974,687, 33456,975,688, 689,976,689, 690,977,690, 33459,978,691, 692,979,692, 693,980,693, 33462,981,694, 33463,982,695, 33464,983,696, 33465,984,697, 698,985,698, 
8, // chain 140
670,957,670, 683,970,683, 699,986,699, 
700,987,700, 33469,988,701, 33470,989,702, 33471,990,703, 33454,973,686, 33452,971,684, 33451,970,683, 
11, // chain 141
668,955,668, 670,957,670, 700,987,700, 
667,954,667, 33469,988,701, 682,969,682, 33472,991,704, 33470,989,702, 705,992,705, 33474,993,706, 33471,990,703, 687,974,687, 33454,973,686, 
11, // chain 142
706,993,706, 687,974,687, 690,977,690, 
693,980,693, 705,992,705, 33475,994,707, 33462,981,694, 708,995,708, 33477,996,709, 33463,982,695, 710,997,710, 711,998,711, 33480,999,712, 
8, // chain 143
705,992,705, 707,994,707, 708,995,708, 
713,1000,713, 33482,1001,714, 33483,1002,715, 33477,996,709, 716,1003,716, 33485,1004,717, 33479,998,711, 
7, // chain 144
704,991,704, 705,992,705, 718,1005,718, 
682,969,682, 33449,968,681, 33487,1006,719, 33488,1007,720, 33481,1000,713, 33473,992,705, 
18, // chain 145
679,966,679, 680,967,680, 681,968,681, 
678,965,678, 33487,1006,719, 721,1008,721, 33490,1009,722, 33488,1007,720, 723,1010,723, 33492,1011,724, 33481,1000,713, 714,1001,714, 725,1012,725, 33494,1013,726, 33483,1002,715, 727,1014,727, 33496,1015,728, 33484,1003,716, 729,1016,729, 
33485,1004,717, 
24, // chain 146
730,1017,730, 677,964,677, 678,965,678, 
731,1018,731, 33500,1019,732, 33489,1008,721, 733,1020,733, 33502,1021,734, 33490,1009,722, 723,1010,723, 735,1022,735, 33504,1023,736, 33492,1011,724, 725,1012,725, 737,1024,737, 33506,1025,738, 33507,1026,739, 33494,1013,726, 740,1027,740, 
33495,1014,727, 741,1028,741, 33510,1029,742, 33496,1015,728, 743,1030,743, 33512,1031,744, 33497,1016,729, 
2, // chain 147
745,1032,745, 731,1018,731, 732,1019,732, 
733,1020,733, 
5, // chain 148
731,1018,731, 746,1033,746, 730,1017,730, 
33444,963,676, 33515,1034,747, 675,962,675, 33516,1035,748, 
1, // chain 149
749,1036,749, 733,1020,733, 734,1021,734, 
7, // chain 150
736,1023,736, 737,1024,737, 750,1037,750, 
33519,1038,751, 33520,1039,752, 33506,1025,738, 753,1040,753, 754,1041,754, 751,1038,751, 
7, // chain 151
755,1042,755, 756,1043,756, 738,1025,738, 
739,1026,739, 740,1027,740, 757,1044,757, 33526,1045,758, 33509,1028,741, 759,1046,759, 
2, // chain 152
760,1047,760, 756,1043,756, 755,1042,755, 
757,1044,757, 
1, // chain 153
743,1030,743, 744,1031,744, 761,1048,761, 
8, // chain 154
762,1049,762, 763,1050,763, 764,1051,764, 
765,1052,765, 33534,1053,766, 33535,1054,767, 33536,1055,768, 33537,1056,769, 33538,1057,770, 33531,1050,763, 
5, // chain 155
771,1058,771, 766,1053,766, 767,1054,767, 
772,1059,772, 747,1060,747, 33516,1061,748, 33541,1062,773, 
13, // chain 156
774,1063,774, 775,1064,775, 776,1065,776, 
33545,1066,777, 33530,1049,762, 778,1067,778, 33533,1052,765, 779,1068,779, 33548,1069,780, 33534,1053,766, 781,1070,781, 33539,1058,771, 782,1071,782, 33514,1072,746, 33515,1060,747, 
9, // chain 157
783,1073,783, 774,1063,774, 776,1065,776, 
784,1074,784, 33553,1075,785, 33554,1076,786, 33545,1066,777, 787,1077,787, 33556,1078,788, 33547,1068,779, 33546,1067,778, 
22, // chain 158
789,1079,789, 783,1073,783, 784,1074,784, 
790,1080,790, 33559,1081,791, 33560,1082,792, 33561,1083,793, 33553,1075,785, 792,1082,792, 33562,1084,794, 33563,1085,795, 33564,1086,796, 33554,1076,786, 787,1077,787, 797,1087,797, 33566,1088,798, 33567,1089,799, 33556,1078,788, 800,1090,800, 
33569,1091,801, 33570,1092,802, 33571,1093,803, 33548,1069,780, 33547,1068,779, 
5, // chain 159
782,1071,782, 746,1072,746, 804,1094,804, 
805,1095,805, 33574,1096,806, 33499,1097,731, 33514,1072,746, 
8, // chain 160
781,1070,781, 782,1071,782, 805,1095,805, 
803,1093,803, 33570,1092,802, 33574,1096,806, 807,1098,807, 33576,1099,808, 33513,1100,745, 33499,1097,731, 
1, // chain 161
803,1093,803, 780,1069,780, 781,1070,781, 
20, // chain 162
809,1101,809, 810,1102,810, 791,1081,791, 
792,1082,792, 811,1103,811, 33580,1104,812, 33581,1105,813, 33562,1084,794, 814,1106,814, 33583,1107,815, 33563,1085,795, 816,1108,816, 33564,1086,796, 797,1087,797, 815,1107,815, 33585,1109,817, 33586,1110,818, 33566,1088,798, 819,1111,819, 
33588,1112,820, 33568,1090,800, 33567,1089,799, 
14, // chain 163
821,1113,821, 810,1102,810, 809,1101,809, 
822,1114,822, 33591,1115,823, 33592,1116,824, 33579,1103,811, 812,1104,812, 825,1117,825, 33594,1118,826, 33581,1105,813, 827,1119,827, 33582,1106,814, 828,1120,828, 33585,1109,817, 33583,1107,815, 
27, // chain 164
829,1121,829, 822,1114,822, 823,1115,823, 
830,1122,830, 33592,1116,824, 831,1123,831, 33600,1124,832, 33593,1117,825, 833,1125,833, 33594,1118,826, 834,1126,834, 33595,1119,827, 828,1120,828, 835,1127,835, 33604,1128,836, 33605,1129,837, 33606,1130,838, 33585,1109,817, 839,1131,839, 
33586,1110,818, 840,1132,840, 33587,1111,819, 841,1133,841, 33588,1112,820, 842,1134,842, 33611,1135,843, 33575,1098,807, 33569,1091,801, 33568,1090,800, 
49, // chain 165
672,1136,672, 844,1137,844, 829,1121,829, 
830,1122,830, 685,1138,685, 33599,1123,831, 688,1139,688, 33613,1140,845, 33600,1124,832, 846,1141,846, 33615,1142,847, 33601,1125,833, 848,1143,848, 33617,1144,849, 33618,1145,850, 33602,1126,834, 851,1146,851, 33620,1147,852, 33621,1148,853, 
33622,1149,854, 33603,1127,835, 853,1148,853, 33623,1150,855, 33604,1128,836, 856,1151,856, 33625,1152,857, 33605,1129,837, 838,1130,838, 858,1153,858, 33607,1131,839, 859,1154,859, 33608,1132,840, 860,1155,860, 33609,1133,841, 861,1156,861, 
33610,1134,842, 753,1157,753, 33630,1158,862, 33631,1159,863, 33611,1135,843, 864,1160,864, 33633,1161,865, 33575,1098,807, 864,1160,864, 33634,1162,866, 33576,1099,808, 749,1163,749, 33635,1164,867, 33513,1100,745, 733,1165,733, 749,1163,749, 
1, // chain 166
672,1136,672, 673,1166,673, 844,1137,844, 
13, // chain 167
691,1167,691, 689,1168,689, 688,1139,688, 
845,1140,845, 868,1169,868, 33637,1170,869, 33614,1141,846, 847,1142,847, 870,1171,870, 33616,1143,848, 871,1172,871, 33617,1144,849, 852,1147,852, 33618,1145,850, 851,1146,851, 
31, // chain 168
691,1167,691, 868,1169,868, 692,1173,692, 
33465,1174,697, 33466,1175,698, 33640,1176,872, 33637,1170,869, 870,1171,870, 873,1177,873, 33642,1178,874, 33643,1179,875, 33639,1172,871, 876,1180,876, 33645,1181,877, 33620,1147,852, 853,1148,853, 878,1182,878, 33647,1183,879, 33623,1150,855, 
880,1184,880, 33649,1185,881, 33624,1151,856, 857,1152,857, 882,1186,882, 33651,1187,883, 33626,1153,858, 859,1154,859, 884,1188,884, 33653,1189,885, 33654,1190,886, 33655,1191,887, 33628,1155,860, 861,1156,861, 
14, // chain 169
877,1181,877, 878,1182,878, 888,1192,888, 
33647,1183,879, 889,1193,889, 33648,1184,880, 890,1194,890, 33659,1195,891, 33649,1185,881, 892,1196,892, 33661,1197,893, 33662,1198,894, 33663,1199,895, 33650,1186,882, 884,1188,884, 33651,1187,883, 
5, // chain 170
876,1180,876, 877,1181,877, 896,1200,896, 
33656,1192,888, 897,1201,897, 33666,1202,898, 33657,1193,889, 
3, // chain 171
876,1180,876, 896,1200,896, 899,1203,899, 
712,1204,712, 875,1179,875, 
2, // chain 172
894,1198,894, 895,1199,895, 900,1205,900, 
759,1206,759, 
1, // chain 173
884,1188,884, 900,1205,900, 895,1199,895, 
2, // chain 174
901,1207,901, 861,1156,861, 756,1208,756, 
760,1209,760, 
2, // chain 175
738,1210,738, 756,1208,756, 753,1157,753, 
33629,1156,861, 
1, // chain 176
753,1157,753, 862,1158,862, 754,1211,754, 
8, // chain 177
902,1212,902, 862,1158,862, 903,1213,903, 
33631,1159,863, 864,1160,864, 902,1212,902, 33672,1214,904, 33634,1162,866, 905,1215,905, 33517,1163,749, 
1, // chain 178
807,1098,807, 801,1091,801, 802,1092,802, 
1, // chain 179
730,1017,730, 676,963,676, 677,964,677, 
10, // chain 180
734,1216,734, 735,1217,735, 906,1218,906, 
33504,1219,736, 750,1220,750, 907,1221,907, 33676,1222,908, 33519,1223,751, 909,1224,909, 33678,1225,910, 33522,1226,754, 862,1227,862, 
11, // chain 181
911,1228,911, 734,1216,734, 906,1218,906, 
907,1221,907, 912,1229,912, 33676,1222,908, 913,1230,913, 33682,1231,914, 33677,1224,909, 915,1232,915, 33684,1233,916, 33685,1234,917, 33678,1225,910, 
14, // chain 182
918,1235,918, 911,1228,911, 912,1229,912, 
913,1230,913, 919,1236,919, 33688,1237,920, 33682,1231,914, 921,1238,921, 33683,1232,915, 916,1233,916, 922,1239,922, 920,1237,920, 33691,1240,923, 919,1236,919, 33692,1241,924, 918,1235,918, 
15, // chain 183
734,1242,734, 911,1243,911, 925,1244,925, 
33694,1245,926, 33686,1246,918, 924,1247,924, 927,1248,927, 33691,1249,923, 928,1250,928, 33690,1251,922, 916,1252,916, 929,1253,929, 33685,1254,917, 930,1255,930, 33670,1256,902, 33678,1257,910, 862,1258,862, 
9, // chain 184
734,1242,734, 925,1244,925, 749,1259,749, 
33673,1260,905, 33699,1261,931, 33694,1245,926, 932,1262,932, 33695,1248,927, 930,1255,930, 33697,1253,929, 33696,1250,928, 
2, // chain 185
905,1260,905, 931,1261,931, 930,1255,930, 
33700,1262,932, 
2, // chain 186
904,1263,904, 905,1260,905, 930,1255,930, 
902,1256,902, 
10, // chain 187
933,1264,933, 934,1265,934, 935,1266,935, 
936,1267,936, 33705,1268,937, 33706,1269,938, 939,1270,939, 33708,1271,940, 941,1272,941, 942,1273,942, 33711,1274,943, 33712,1275,944, 
1, // chain 188
934,1265,934, 945,1276,945, 935,1266,935, 
13, // chain 189
945,1277,945, 934,1278,934, 946,1279,946, 
33701,1280,933, 936,1281,936, 937,1282,937, 939,1283,939, 942,1284,942, 943,1285,943, 944,1286,944, 941,1287,941, 940,1288,940, 938,1289,938, 935,1290,935, 945,1277,945, 
15, // chain 190
947,1291,947, 948,1292,948, 949,1293,949, 
950,1294,950, 33719,1295,951, 33720,1296,952, 33716,1292,948, 953,1297,953, 33722,1298,954, 33723,1299,955, 33724,1300,956, 33715,1291,947, 957,1301,957, 33726,1302,958, 33718,1294,950, 959,1303,959, 33719,1295,951, 
5, // chain 191
954,1304,954, 955,1305,955, 956,1306,956, 
957,1307,957, 951,1308,951, 33726,1309,958, 959,1310,959, 
2, // chain 192
953,1311,953, 954,1304,954, 951,1308,951, 
952,1312,952, 
19, // chain 193
960,1313,960, 961,1314,961, 962,1315,962, 
33731,1316,963, 33732,1317,964, 965,1318,965, 966,1319,966, 962,1315,962, 33735,1320,967, 33736,1321,968, 33737,1322,969, 970,1323,970, 33739,1324,971, 972,1325,972, 973,1326,973, 968,1321,968, 33742,1327,974, 975,1328,975, 967,1320,967, 
33728,1313,960, 962,1315,962, 
39, // chain 194
742,1329,742, 976,1330,976, 977,1331,977, 
741,1332,741, 33527,1333,759, 33744,1330,976, 978,1334,978, 33747,1335,979, 33748,1336,980, 33749,1337,981, 33510,1329,742, 982,1338,982, 33511,1339,743, 983,1340,983, 33529,1341,761, 890,1342,890, 984,1343,984, 985,1344,985, 33754,1345,986, 
33755,1346,987, 988,1347,988, 989,1348,989, 990,1349,990, 33759,1350,991, 33760,1351,992, 993,1352,993, 33762,1353,994, 995,1354,995, 33764,1355,996, 997,1356,997, 33766,1357,998, 999,1358,999, 33768,1359,1000, 1001,1360,1001, 33770,1361,1002, 
33771,1362,1003, 979,1335,979, 33772,1363,1004, 978,1334,978, 33662,1364,894, 759,1333,759, 
10, // chain 195
983,1340,983, 985,1344,985, 982,1338,982, 
33754,1345,986, 1005,1365,1005, 33774,1366,1006, 33775,1367,1007, 33758,1349,990, 1008,1368,1008, 33759,1350,991, 995,1354,995, 33761,1352,993, 
7, // chain 196
981,1337,981, 982,1338,982, 1005,1365,1005, 
1006,1366,1006, 980,1336,980, 33777,1369,1009, 33770,1361,1002, 33776,1368,1008, 33775,1367,1007, 
2, // chain 197
979,1335,979, 980,1336,980, 1009,1369,1009, 
1002,1361,1002, 
4, // chain 198
1002,1361,1002, 1008,1368,1008, 1001,1360,1001, 
33767,1358,999, 33763,1354,995, 997,1356,997, 
9, // chain 199
984,1370,984, 890,1371,890, 891,1372,891, 
1010,1373,1010, 33660,1374,892, 1011,1375,1011, 33661,1376,893, 1012,1377,1012, 33781,1378,1013, 33772,1379,1004, 33662,1380,894, 
11, // chain 200
987,1381,987, 984,1370,984, 1010,1373,1010, 
988,1382,988, 33779,1375,1011, 1014,1383,1014, 33783,1384,1015, 33780,1377,1012, 1016,1385,1016, 33781,1378,1013, 1000,1386,1000, 33771,1387,1003, 33772,1379,1004, 
8, // chain 201
989,1388,989, 988,1382,988, 1014,1383,1014, 
992,1389,992, 33785,1390,1017, 33783,1384,1015, 1018,1391,1018, 33784,1385,1016, 998,1392,998, 33768,1386,1000, 
6, // chain 202
998,1392,998, 996,1393,996, 1018,1391,1018, 
33787,1394,1019, 33762,1395,994, 992,1389,992, 1017,1390,1017, 1018,1391,1018, 
10, // chain 203
1020,1396,1020, 1021,1397,1021, 1022,1398,1022, 
1023,1399,1023, 33792,1400,1024, 33793,1401,1025, 33794,1402,1026, 33795,1403,1027, 33789,1397,1021, 1028,1404,1028, 1029,1405,1029, 33798,1406,1030, 
5, // chain 204
1031,1407,1031, 1032,1408,1032, 1023,1399,1023, 
1024,1400,1024, 1033,1409,1033, 33793,1401,1025, 1026,1402,1026, 
1, // chain 205
1026,1402,1026, 1027,1403,1027, 1029,1405,1029, 
5, // chain 206
964,1410,964, 961,1411,961, 972,1412,972, 
971,1413,971, 965,1414,965, 33734,1415,966, 33737,1416,969, 
3, // chain 207
973,1417,973, 972,1412,972, 961,1411,961, 
975,1418,975, 33728,1419,960, 
1, // chain 208
974,1420,974, 973,1417,973, 975,1418,975, 
16, // chain 209
1034,1421,1034, 1035,1422,1035, 1036,1423,1036, 
33805,1424,1037, 1038,1425,1038, 1039,1426,1039, 1040,1427,1040, 33809,1428,1041, 1042,1429,1042, 1043,1430,1043, 1044,1431,1044, 33813,1432,1045, 1046,1433,1046, 33815,1434,1047, 1034,1421,1034, 1036,1423,1036, 1044,1431,1044, 33808,1427,1040, 
6, // chain 210
1039,1435,1039, 1038,1436,1038, 1037,1437,1037, 
1041,1438,1041, 33813,1439,1045, 33815,1440,1047, 33802,1441,1034, 33803,1442,1035, 
2, // chain 211
1045,1439,1045, 1043,1443,1043, 1041,1438,1041, 
33810,1444,1042, 
10, // chain 212
1033,1445,1033, 1026,1446,1026, 1048,1447,1048, 
33797,1448,1029, 1030,1449,1030, 1028,1450,1028, 1021,1451,1021, 1020,1452,1020, 1023,1453,1023, 1032,1454,1032, 1031,1455,1031, 1033,1445,1033, 
19, // chain 213
1049,1456,1049, 1050,1457,1050, 1051,1458,1051, 
33820,1459,1052, 33821,1460,1053, 33822,1461,1054, 1055,1462,1055, 1056,1463,1056, 1052,1459,1052, 33825,1464,1057, 1058,1465,1058, 33827,1466,1059, 33828,1467,1060, 1061,1468,1061, 1062,1469,1062, 1058,1465,1058, 33831,1470,1063, 1064,1471,1064, 1052,1459,1052, 
33819,1458,1051, 33817,1456,1049, 
33, // chain 214
744,1472,744, 729,1473,729, 1065,1474,1065, 
33485,1475,717, 1066,1476,1066, 33835,1477,1067, 33479,1478,711, 712,1479,712, 1068,1480,1068, 33667,1481,899, 1069,1482,1069, 1070,1483,1070, 33839,1484,1071, 1072,1485,1072, 1073,1486,1073, 33842,1487,1074, 1075,1488,1075, 33844,1489,1076, 33845,1490,1077, 
1078,1491,1078, 33847,1492,1079, 1080,1493,1080, 33849,1494,1081, 1082,1495,1082, 33851,1496,1083, 1084,1497,1084, 33853,1498,1085, 1086,1499,1086, 1087,1500,1087, 33856,1501,1088, 33857,1502,1089, 1090,1503,1090, 1091,1504,1091, 33529,1505,761, 33658,1506,890, 
8, // chain 215
761,1505,761, 744,1472,744, 1092,1507,1092, 
33833,1474,1065, 1093,1508,1093, 33862,1509,1094, 33834,1476,1066, 1070,1483,1070, 33836,1480,1068, 33835,1477,1067, 
7, // chain 216
1091,1504,1091, 761,1505,761, 1092,1507,1092, 
1088,1501,1088, 33863,1510,1095, 33861,1508,1093, 1096,1511,1096, 33838,1483,1070, 33862,1509,1094, 
10, // chain 217
1096,1511,1096, 1070,1483,1070, 1073,1486,1073, 
1075,1488,1075, 1087,1500,1087, 33852,1497,1084, 33865,1512,1097, 33844,1489,1076, 1078,1491,1078, 1080,1493,1080, 1082,1495,1082, 1084,1497,1084, 
2, // chain 218
1087,1500,1087, 1088,1501,1088, 1095,1510,1095, 
1096,1511,1096, 
24, // chain 219
898,1513,898, 889,1514,889, 1098,1515,1098, 
33658,1516,890, 1090,1517,1090, 1099,1518,1099, 33857,1519,1089, 1086,1520,1086, 1085,1521,1085, 1100,1522,1100, 33869,1523,1101, 33851,1524,1083, 1102,1525,1102, 33849,1526,1081, 1079,1527,1079, 1103,1528,1103, 33845,1529,1077, 1074,1530,1074, 1104,1531,1104, 
33840,1532,1072, 1105,1533,1105, 33874,1534,1106, 33839,1535,1071, 1069,1536,1069, 896,1537,896, 33667,1538,899, 
12, // chain 220
1106,1534,1106, 896,1537,896, 897,1539,897, 
1105,1533,1105, 33666,1513,898, 1107,1540,1107, 33866,1515,1098, 1099,1518,1099, 1100,1522,1100, 1105,1533,1105, 33876,1541,1108, 33869,1523,1101, 1103,1528,1103, 33870,1525,1102, 
2, // chain 221
1105,1533,1105, 1108,1541,1108, 1104,1531,1104, 
33871,1528,1103, 
10, // chain 222
1109,1542,1109, 1110,1543,1110, 1111,1544,1111, 
1112,1545,1112, 33881,1546,1113, 33882,1547,1114, 33883,1548,1115, 33884,1549,1116, 33878,1543,1110, 1117,1550,1117, 1118,1551,1118, 33887,1552,1119, 
3, // chain 223
1120,1553,1120, 1121,1554,1121, 1112,1545,1112, 
1113,1546,1113, 1114,1547,1114, 
3, // chain 224
1122,1555,1122, 1114,1547,1114, 1115,1548,1115, 
1116,1549,1116, 1118,1551,1118, 
6, // chain 225
1054,1556,1054, 1050,1557,1050, 1062,1558,1062, 
1061,1559,1061, 1060,1560,1060, 1055,1561,1055, 33824,1562,1056, 33825,1563,1057, 
2, // chain 226
1062,1558,1062, 1050,1557,1050, 1064,1564,1064, 
33817,1565,1049, 
1, // chain 227
1063,1566,1063, 1062,1558,1062, 1064,1564,1064, 
14, // chain 228
1123,1567,1123, 1124,1568,1124, 1125,1569,1125, 
33894,1570,1126, 1127,1571,1127, 1128,1572,1128, 33897,1573,1129, 1130,1574,1130, 1131,1575,1131, 1132,1576,1132, 1133,1577,1133, 33902,1578,1134, 1135,1579,1135, 1128,1572,1128, 33893,1569,1125, 33891,1567,1123, 
5, // chain 229
1130,1580,1130, 1129,1581,1129, 1127,1582,1127, 
1126,1583,1126, 1135,1584,1135, 33891,1585,1123, 33892,1586,1124, 
3, // chain 230
1130,1580,1130, 1135,1584,1135, 1134,1587,1134, 
1132,1588,1132, 1131,1589,1131, 
10, // chain 231
1114,1590,1114, 1122,1591,1122, 1136,1592,1136, 
33886,1593,1118, 1119,1594,1119, 1117,1595,1117, 1110,1596,1110, 1109,1597,1109, 1112,1598,1112, 1121,1599,1121, 1120,1600,1120, 1114,1590,1114, 
15, // chain 232
1137,1601,1137, 1138,1602,1138, 1139,1603,1139, 
33908,1604,1140, 33909,1605,1141, 1142,1606,1142, 1143,1607,1143, 1139,1603,1139, 33912,1608,1144, 1145,1609,1145, 33914,1610,1146, 33915,1611,1147, 1148,1612,1148, 1149,1613,1149, 1145,1609,1145, 33918,1614,1150, 33919,1615,1151, 
2, // chain 233
1150,1614,1150, 1137,1601,1137, 1139,1603,1139, 
1145,1609,1145, 
12, // chain 234
1152,1616,1152, 710,1617,710, 1153,1618,1153, 
1154,1619,1154, 33923,1620,1155, 33924,1621,1156, 33478,1617,710, 695,1622,695, 696,1623,696, 1157,1624,1157, 33466,1625,698, 1158,1626,1158, 33927,1627,1159, 33640,1628,872, 
31, // chain 235
712,1629,712, 710,1617,710, 1152,1616,1152, 
1160,1630,1160, 33929,1631,1161, 33922,1619,1154, 1162,1632,1162, 33931,1633,1163, 33923,1620,1155, 1156,1621,1156, 1157,1624,1157, 1158,1626,1158, 1164,1634,1164, 1165,1635,1165, 1166,1636,1166, 33935,1637,1167, 1168,1638,1168, 33937,1639,1169, 33938,1640,1170, 
1171,1641,1171, 33940,1642,1172, 1173,1643,1173, 33942,1644,1174, 1175,1645,1175, 33944,1646,1176, 1177,1647,1177, 1178,1648,1178, 33947,1649,1179, 33928,1630,1160, 33948,1650,1180, 1181,1651,1181, 712,1629,712, 33643,1652,875, 
5, // chain 236
1179,1649,1179, 1160,1630,1160, 1161,1631,1161, 
1162,1632,1162, 1178,1648,1178, 33934,1636,1166, 33931,1633,1163, 
7, // chain 237
1178,1648,1178, 1166,1636,1166, 1168,1638,1168, 
1175,1645,1175, 33950,1653,1182, 33937,1639,1169, 1171,1641,1171, 1173,1643,1173, 1175,1645,1175, 
26, // chain 238
1159,1654,1159, 872,1655,872, 873,1656,873, 
1183,1657,1183, 33952,1658,1184, 33642,1659,874, 1185,1660,1185, 33643,1661,875, 1186,1662,1186, 33949,1663,1181, 1180,1664,1180, 1177,1665,1177, 1176,1666,1176, 1187,1667,1187, 33956,1668,1188, 33942,1669,1174, 1172,1670,1172, 1189,1671,1189, 33938,1672,1170, 
1190,1673,1190, 33935,1674,1167, 1165,1675,1165, 1187,1667,1187, 33952,1658,1184, 33951,1657,1183, 33932,1676,1164, 1159,1654,1159, 33926,1677,1158, 
2, // chain 239
1185,1660,1185, 1186,1662,1186, 1187,1667,1187, 
1184,1658,1184, 
2, // chain 240
1187,1667,1187, 1188,1668,1188, 1190,1673,1190, 
33957,1671,1189, 
9, // chain 241
1191,1678,1191, 1192,1679,1192, 1193,1680,1193, 
1194,1681,1194, 33963,1682,1195, 33964,1683,1196, 33965,1684,1197, 33960,1679,1192, 1198,1685,1198, 1199,1686,1199, 33968,1687,1200, 
5, // chain 242
1201,1688,1201, 1202,1689,1202, 1194,1681,1194, 
1195,1682,1195, 1203,1690,1203, 33964,1683,1196, 1197,1684,1197, 
5, // chain 243
1141,1691,1141, 1138,1692,1138, 1148,1693,1148, 
1147,1694,1147, 1142,1695,1142, 33911,1696,1143, 33912,1697,1144, 
4, // chain 244
1149,1698,1149, 1148,1693,1148, 1138,1692,1138, 
1137,1699,1137, 1151,1700,1151, 33918,1701,1150, 
12, // chain 245
1204,1702,1204, 1205,1703,1205, 1206,1704,1206, 
33975,1705,1207, 1208,1706,1208, 1209,1707,1209, 1210,1708,1210, 33979,1709,1211, 1212,1710,1212, 1213,1711,1213, 1214,1712,1214, 1206,1704,1206, 33983,1713,1215, 1204,1702,1204, 
5, // chain 246
1209,1714,1209, 1208,1715,1208, 1211,1716,1211, 
33975,1717,1207, 1215,1718,1215, 33972,1719,1204, 33973,1720,1205, 
3, // chain 247
1215,1718,1215, 1214,1721,1214, 1211,1716,1211, 
33981,1722,1213, 1212,1723,1212, 
10, // chain 248
1203,1724,1203, 1197,1725,1197, 1216,1726,1216, 
33967,1727,1199, 1200,1728,1200, 1198,1729,1198, 1192,1730,1192, 1191,1731,1191, 1194,1732,1194, 1202,1733,1202, 1201,1734,1201, 1203,1724,1203, 
20, // chain 249
1217,1735,1217, 1218,1736,1218, 1219,1737,1219, 
33988,1738,1220, 33989,1739,1221, 33990,1740,1222, 1223,1741,1223, 1224,1742,1224, 1220,1738,1220, 33993,1743,1225, 33994,1744,1226, 33995,1745,1227, 1228,1746,1228, 33997,1747,1229, 1230,1748,1230, 1231,1749,1231, 1226,1744,1226, 34000,1750,1232, 34001,1751,1233, 
1234,1752,1234, 1219,1737,1219, 33985,1735,1217, 
3, // chain 250
1220,1738,1220, 1225,1743,1225, 1219,1737,1219, 
34000,1750,1232, 33994,1744,1226, 
7, // chain 251
1235,1753,1235, 901,1754,901, 1236,1755,1236, 
1237,1756,1237, 34006,1757,1238, 34007,1758,1239, 34008,1759,1240, 33528,1760,760, 33669,1754,901, 
34, // chain 252
1240,1759,1240, 760,1760,760, 757,1761,757, 
1241,1762,1241, 33526,1763,758, 1242,1764,1242, 33527,1765,759, 1243,1766,1243, 33668,1767,900, 884,1768,884, 1244,1769,1244, 1245,1770,1245, 34014,1771,1246, 1247,1772,1247, 34016,1773,1248, 1249,1774,1249, 1250,1775,1250, 34019,1776,1251, 1252,1777,1252, 
34021,1778,1253, 34022,1779,1254, 1255,1780,1255, 34024,1781,1256, 1257,1782,1257, 34026,1783,1258, 1259,1784,1259, 34028,1785,1260, 1261,1786,1261, 34030,1787,1262, 34005,1756,1237, 34031,1788,1263, 1264,1789,1264, 1265,1790,1265, 1235,1753,1235, 33629,1791,861, 
901,1754,901, 
5, // chain 253
1239,1758,1239, 1240,1759,1240, 1241,1762,1241, 
1242,1764,1242, 1266,1792,1266, 34013,1770,1245, 34011,1766,1243, 
9, // chain 254
1267,1793,1267, 1239,1758,1239, 1266,1792,1266, 
1245,1770,1245, 1247,1772,1247, 1261,1786,1261, 34018,1775,1250, 1252,1777,1252, 1259,1784,1259, 34023,1780,1255, 34021,1778,1253, 
3, // chain 255
1238,1757,1238, 1239,1758,1239, 1267,1793,1267, 
1262,1787,1262, 34029,1786,1261, 
1, // chain 256
1237,1756,1237, 1238,1757,1238, 1262,1787,1262, 
1, // chain 257
1255,1780,1255, 1257,1782,1257, 1259,1784,1259, 
9, // chain 258
1268,1794,1268, 884,1795,884, 885,1796,885, 
1269,1797,1269, 34038,1798,1270, 33654,1799,886, 1271,1800,1271, 34040,1801,1272, 34033,1802,1265, 33655,1803,887, 861,1804,861, 
12, // chain 259
1244,1805,1244, 884,1795,884, 1268,1794,1268, 
1269,1797,1269, 1246,1806,1246, 34016,1807,1248, 34041,1808,1273, 34038,1798,1270, 1271,1800,1271, 1274,1809,1274, 34040,1801,1272, 1263,1810,1263, 34032,1811,1264, 34033,1802,1265, 
22, // chain 260
1274,1809,1274, 1263,1810,1263, 1275,1812,1275, 
34028,1813,1260, 1258,1814,1258, 1276,1815,1276, 34024,1816,1256, 1277,1817,1277, 34022,1818,1254, 1278,1819,1278, 34019,1820,1251, 1249,1821,1249, 1279,1822,1279, 34016,1807,1248, 1273,1808,1273, 1280,1823,1280, 34042,1809,1274, 1275,1812,1275, 1281,1824,1281, 
34044,1815,1276, 1277,1817,1277, 1278,1819,1278, 1280,1823,1280, 34047,1822,1279, 
10, // chain 261
1282,1825,1282, 1283,1826,1283, 1284,1827,1284, 
1285,1828,1285, 34054,1829,1286, 34055,1830,1287, 34056,1831,1288, 34057,1832,1289, 34051,1826,1283, 1290,1833,1290, 1291,1834,1291, 34060,1835,1292, 
4, // chain 262
1293,1836,1293, 1282,1825,1282, 1285,1828,1285, 
1294,1837,1294, 34063,1838,1295, 34054,1829,1286, 
1, // chain 263
1286,1829,1286, 1287,1830,1287, 1288,1831,1288, 
1, // chain 264
1288,1831,1288, 1289,1832,1289, 1291,1834,1291, 
6, // chain 265
1222,1839,1222, 1218,1840,1218, 1231,1841,1231, 
1230,1842,1230, 1229,1843,1229, 1223,1844,1223, 33992,1845,1224, 33995,1846,1227, 
2, // chain 266
1231,1841,1231, 1218,1840,1218, 1234,1847,1234, 
33985,1848,1217, 
1, // chain 267
1233,1849,1233, 1231,1841,1231, 1234,1847,1234, 
16, // chain 268
1296,1850,1296, 1297,1851,1297, 1298,1852,1298, 
34067,1853,1299, 1300,1854,1300, 1301,1855,1301, 1302,1856,1302, 34071,1857,1303, 1304,1858,1304, 1305,1859,1305, 1306,1860,1306, 34075,1861,1307, 1308,1862,1308, 34077,1863,1309, 1296,1850,1296, 1298,1852,1298, 1306,1860,1306, 34070,1856,1302, 
6, // chain 269
1301,1864,1301, 1300,1865,1300, 1299,1866,1299, 
1303,1867,1303, 34075,1868,1307, 34077,1869,1309, 34064,1870,1296, 34065,1871,1297, 
2, // chain 270
1307,1868,1307, 1305,1872,1305, 1303,1867,1303, 
34072,1873,1304, 
10, // chain 271
1286,1874,1286, 1288,1875,1288, 1310,1876,1310, 
34059,1877,1291, 1292,1878,1292, 1290,1879,1290, 1283,1880,1283, 1282,1881,1282, 1293,1882,1293, 1294,1883,1294, 1295,1884,1295, 1286,1874,1286, 

 0};


// face array: 6kb.
const uint16_t nanosuit_2_face[3329] PROGMEM = {
1, // chain 0
1311,1885,1311, 1312,1886,1311, 1313,1887,1311, 
8, // chain 1
1314,1888,1312, 1315,1889,1313, 1316,1890,1314, 
1317,1891,1315, 34086,1892,1316, 34087,1893,1317, 1320,1894,1318, 1321,1895,1319, 34090,1896,1320, 34091,1897,1321, 
3, // chain 2
1317,1891,1315, 1318,1892,1316, 1324,1898,1322, 
1325,1899,1323, 1314,1888,1312, 
4, // chain 3
1326,1900,1324, 1324,1898,1322, 1318,1892,1316, 
1321,1895,1319, 1327,1901,1325, 34090,1896,1320, 
10, // chain 4
1328,1902,1326, 1329,1903,1327, 1330,1904,1328, 
1331,1905,1329, 34100,1906,1330, 34101,1907,1331, 34102,1908,1332, 34097,1903,1327, 1335,1909,1333, 1336,1910,1334, 1337,1911,1335, 34106,1912,1336, 
3, // chain 5
1339,1913,1337, 1340,1914,1338, 1341,1915,1339, 
1331,1905,1329, 34096,1902,1326, 
10, // chain 6
1342,1916,1340, 1340,1914,1338, 1339,1913,1337, 
1343,1917,1341, 34099,1905,1329, 1332,1906,1330, 1344,1918,1342, 34113,1919,1343, 34114,1920,1344, 34101,1907,1331, 1337,1911,1335, 34102,1908,1332, 
6, // chain 7
1342,1916,1340, 1343,1917,1341, 1347,1921,1345, 
34116,1922,1346, 34112,1918,1342, 1349,1923,1347, 34118,1924,1348, 34113,1919,1343, 
5, // chain 8
1351,1925,1349, 1342,1916,1340, 1347,1921,1345, 
1352,1926,1350, 34121,1927,1351, 34116,1922,1346, 1349,1923,1347, 
19, // chain 9
1354,1928,1352, 1355,1929,1353, 1356,1930,1354, 
1357,1931,1355, 34126,1932,1356, 1325,1933,1323, 1359,1934,1357, 34092,1935,1322, 1360,1936,1358, 34094,1937,1324, 1327,1938,1325, 1361,1939,1359, 34130,1940,1360, 1363,1941,1361, 1364,1942,1362, 34133,1943,1363, 34134,1944,1364, 34135,1945,1365, 34136,1946,1366, 
1369,1947,1367, 34138,1948,1368, 
8, // chain 10
1371,1949,1369, 1354,1928,1352, 1372,1950,1370, 
1340,1914,1338, 34141,1951,1371, 34142,1952,1372, 34143,1953,1373, 34127,1934,1357, 34125,1931,1355, 34122,1928,1352, 
4, // chain 11
1354,1928,1352, 1371,1949,1369, 1355,1929,1353, 
34119,1925,1349, 34110,1916,1340, 34108,1914,1338, 
1, // chain 12
1349,1923,1347, 1350,1924,1348, 1376,1954,1374, 
1, // chain 13
1346,1920,1344, 1337,1911,1335, 1345,1919,1343, 
5, // chain 14
1374,1952,1372, 1377,1955,1375, 1373,1951,1371, 
34146,1956,1376, 1379,1957,1377, 1341,1915,1339, 1340,1914,1338, 
10, // chain 15
1375,1953,1373, 1359,1934,1357, 1360,1936,1358, 
1380,1958,1378, 34129,1939,1359, 1364,1942,1362, 1381,1959,1379, 34133,1943,1363, 1382,1960,1380, 34151,1961,1381, 34152,1962,1382, 34134,1944,1364, 
13, // chain 16
1385,1963,1383, 1374,1952,1372, 1375,1953,1373, 
1386,1964,1384, 34148,1958,1378, 1387,1965,1385, 34156,1966,1386, 34149,1959,1379, 1382,1960,1380, 1389,1967,1387, 34158,1968,1388, 34151,1961,1381, 1391,1969,1389, 34160,1970,1390, 34152,1962,1382, 
25, // chain 17
1393,1971,1391, 1394,1972,1392, 1395,1973,1393, 
1396,1974,1394, 34165,1975,1395, 34166,1976,1396, 1399,1977,1397, 1400,1978,1398, 1401,1979,1399, 34170,1980,1400, 1403,1981,1401, 1404,1982,1402, 34173,1983,1403, 1406,1984,1404, 1407,1985,1405, 34176,1986,1406, 1409,1987,1407, 1410,1988,1408, 34179,1989,1409, 
1412,1990,1410, 1413,1991,1411, 34182,1992,1412, 1415,1993,1413, 1416,1994,1414, 1417,1995,1415, 34186,1996,1416, 34187,1997,1417, 
11, // chain 18
1401,1979,1399, 1404,1982,1402, 1420,1998,1418, 
1396,1974,1394, 34161,1971,1391, 34189,1999,1419, 34190,2000,1420, 34172,1982,1402, 1423,2001,1421, 34175,1985,1405, 1417,1995,1415, 34178,1988,1408, 1413,1991,1411, 
1, // chain 19
1396,1974,1394, 1397,1975,1395, 1401,1979,1399, 
5, // chain 20
1424,2002,1422, 1421,1999,1419, 1422,2000,1420, 
1425,2003,1423, 34191,2001,1421, 1418,1996,1416, 34185,1995,1415, 
6, // chain 21
1426,2004,1424, 1427,2005,1425, 1428,2006,1426, 
1429,2007,1427, 1430,2008,1428, 34199,2009,1429, 34200,2010,1430, 34201,2011,1431, 
4, // chain 22
1434,2012,1432, 1428,2006,1426, 1427,2005,1425, 
1435,2013,1433, 34204,2014,1434, 1437,2015,1435, 
2, // chain 23
1438,2016,1436, 1439,2017,1437, 1434,2012,1432, 
34196,2006,1426, 
2, // chain 24
1440,2018,1438, 1441,2019,1439, 1426,2004,1424, 
1430,2008,1428, 
10, // chain 25
1442,2020,1440, 1431,2009,1429, 1432,2010,1430, 
1443,2021,1441, 1444,2022,1442, 1445,2023,1443, 34214,2024,1444, 1447,2025,1445, 34216,2026,1446, 1449,2027,1447, 34218,2028,1448, 34219,2029,1449, 
23, // chain 26
1452,2030,1450, 1453,2031,1451, 1454,2032,1452, 
1455,2033,1453, 34224,2034,1454, 34225,2035,1455, 34087,2036,1317, 34226,2037,1456, 34221,2031,1451, 1459,2038,1457, 34228,2039,1458, 34229,2040,1459, 34220,2030,1450, 1462,2041,1460, 34223,2033,1453, 1463,2042,1461, 34224,2034,1454, 1464,2043,1462, 34233,2044,1463, 
34225,2035,1455, 1466,2045,1464, 34235,2046,1465, 34083,2047,1313, 34084,2048,1314, 34087,2036,1317, 
15, // chain 27
1468,2049,1466, 1369,2050,1367, 1460,2039,1458, 
1469,2051,1467, 34229,2040,1459, 1470,2052,1468, 34239,2053,1469, 34230,2041,1460, 1463,2042,1461, 1472,2054,1470, 34241,2055,1471, 34232,2043,1462, 1474,2056,1472, 34243,2057,1473, 34244,2058,1474, 34234,2045,1464, 34233,2044,1463, 
8, // chain 28
1320,2059,1318, 1319,2036,1317, 1458,2037,1456, 
1323,2060,1321, 34245,2061,1475, 34246,2062,1476, 34227,2038,1457, 1460,2039,1458, 1370,2063,1368, 34137,2050,1367, 
7, // chain 29
1478,2062,1476, 1370,2063,1368, 1479,2064,1477, 
1477,2061,1475, 34090,2065,1320, 34095,2066,1325, 34130,2067,1360, 34136,2068,1366, 34138,2063,1368, 
1, // chain 30
1323,2060,1321, 1477,2061,1475, 1322,2065,1320, 
1, // chain 31
1368,2068,1366, 1363,2069,1361, 1362,2067,1360, 
10, // chain 32
1468,2070,1466, 1480,2071,1478, 1481,2072,1479, 
34250,2073,1480, 1483,2074,1481, 34252,2075,1482, 34253,2076,1483, 1486,2077,1484, 1487,2078,1485, 1488,2079,1486, 34163,2080,1393, 34166,2081,1396, 
5, // chain 33
1489,2082,1487, 1384,2083,1382, 1366,2084,1364, 
1490,2085,1488, 34137,2086,1367, 1481,2072,1479, 34236,2070,1466, 
13, // chain 34
1490,2085,1488, 1483,2074,1481, 1491,2087,1489, 
1489,2082,1487, 34260,2088,1490, 34203,2089,1433, 34261,2090,1491, 34251,2074,1481, 1484,2075,1482, 1488,2079,1486, 1494,2091,1492, 34202,2092,1432, 34163,2080,1393, 1394,2093,1392, 1438,2094,1436, 
1, // chain 35
1490,2085,1488, 1481,2072,1479, 1483,2074,1481, 
2, // chain 36
1493,2090,1491, 1494,2091,1492, 1435,2089,1433, 
34202,2092,1432, 
1, // chain 37
1489,2082,1487, 1492,2088,1490, 1495,2095,1493, 
1, // chain 38
1435,2089,1433, 1437,2096,1435, 1492,2088,1490, 
19, // chain 39
1496,2097,1494, 1497,2098,1495, 1498,2099,1496, 
1499,2100,1497, 34268,2101,1498, 34269,2102,1499, 34270,2103,1500, 34265,2098,1495, 1386,2104,1384, 34153,2105,1383, 34271,2106,1501, 34264,2097,1494, 1504,2107,1502, 34267,2100,1497, 1505,2108,1503, 34274,2109,1504, 34268,2101,1498, 1507,2110,1505, 34276,2111,1506, 
34277,2112,1507, 34269,2102,1499, 
7, // chain 40
1507,2110,1505, 1508,2111,1506, 1510,2113,1508, 
34279,2114,1509, 1512,2115,1510, 34281,2116,1511, 34282,2117,1512, 34283,2118,1513, 1516,2119,1514, 
1, // chain 41
1513,2116,1511, 1517,2120,1515, 1512,2115,1510, 
6, // chain 42
1510,2113,1508, 1512,2115,1510, 1518,2121,1516, 
1519,2122,1517, 1520,2123,1518, 1507,2110,1505, 34274,2109,1504, 34273,2108,1503, 
17, // chain 43
1505,2108,1503, 1521,2124,1519, 1504,2107,1502, 
34290,2125,1520, 34291,2126,1521, 1524,2127,1522, 34293,2128,1523, 1526,2129,1524, 34295,2130,1525, 34296,2131,1526, 1529,2132,1527, 1530,2133,1528, 1531,2134,1529, 34300,2135,1530, 1533,2136,1531, 1328,2137,1326, 34097,2138,1327, 34302,2139,1532, 1335,2140,1333, 
1, // chain 44
1503,2106,1533, 1535,2141,1534, 1385,2105,1535, 
6, // chain 45
1536,2142,1536, 1377,2143,1375, 1537,2144,1537, 
1538,2145,1538, 34271,2106,1501, 34153,2105,1383, 34142,2146,1372, 34145,2143,1375, 
10, // chain 46
1503,2106,1501, 1504,2107,1502, 1538,2145,1538, 
34290,2125,1520, 1536,2142,1536, 34307,2147,1539, 34292,2127,1522, 1526,2129,1524, 1341,2148,1339, 34295,2130,1525, 1328,2137,1326, 34299,2134,1529, 
3, // chain 47
1536,2142,1536, 1539,2147,1539, 1378,2149,1376, 
34147,2150,1377, 34109,2148,1339, 
1, // chain 48
1536,2142,1536, 1378,2149,1376, 1377,2143,1375, 
11, // chain 49
1540,2151,1540, 1541,2152,1541, 1393,2153,1391, 
1542,2154,1542, 34189,2155,1419, 1424,2156,1422, 1543,2157,1543, 34312,2158,1544, 34193,2159,1423, 1545,2160,1545, 34186,2161,1416, 1546,2162,1546, 34315,2163,1547, 
56, // chain 50
1542,2154,1542, 1543,2157,1543, 1548,2164,1548, 
34317,2165,1549, 34312,2158,1544, 1550,2166,1550, 34313,2160,1545, 1546,2162,1546, 1551,2167,1551, 1552,2168,1552, 34321,2169,1553, 1554,2170,1554, 34323,2171,1555, 1556,2172,1556, 34325,2173,1557, 1558,2174,1558, 34219,2175,1449, 1448,2176,1446, 1559,2177,1559, 
34328,2178,1560, 34214,2179,1444, 1561,2180,1561, 34212,2181,1442, 1562,2182,1562, 34211,2183,1441, 1432,2184,1430, 1563,2185,1563, 34332,2186,1564, 34201,2187,1431, 1565,2188,1565, 1566,2189,1566, 34335,2190,1567, 1568,2191,1568, 34337,2192,1569, 1570,2193,1570, 
34339,2194,1571, 1572,2195,1572, 34308,2151,1540, 1542,2154,1542, 1548,2164,1548, 1573,2196,1573, 34342,2197,1574, 34317,2165,1549, 1575,2198,1575, 34344,2199,1576, 34318,2166,1550, 1552,2168,1552, 1577,2200,1577, 34322,2170,1554, 1578,2201,1578, 34324,2172,1556, 
1579,2202,1579, 34326,2174,1558, 1559,2177,1559, 1580,2203,1580, 34349,2204,1581, 34329,2180,1561, 34328,2178,1560, 
15, // chain 51
1574,2197,1574, 1582,2205,1582, 1583,2206,1583, 
1573,2196,1573, 34352,2207,1584, 34350,2205,1582, 1585,2208,1585, 34354,2209,1586, 34355,2210,1587, 34342,2197,1574, 1575,2198,1575, 1576,2199,1576, 1577,2200,1577, 1588,2211,1588, 34346,2201,1578, 1580,2203,1580, 34347,2202,1579, 
3, // chain 52
1585,2208,1585, 1586,2209,1586, 1589,2212,1589, 
34356,2211,1588, 34355,2210,1587, 
4, // chain 53
1590,2213,1590, 1585,2208,1585, 1589,2212,1589, 
1581,2204,1581, 34348,2203,1580, 34356,2211,1588, 
6, // chain 54
1584,2207,1584, 1585,2208,1585, 1591,2214,1591, 
1568,2191,1568, 34334,2189,1566, 34360,2215,1592, 34358,2213,1590, 34353,2208,1585, 
4, // chain 55
1564,2186,1564, 1566,2189,1566, 1592,2215,1592, 
1563,2185,1563, 34349,2204,1581, 34358,2213,1590, 
2, // chain 56
1563,2185,1563, 1581,2204,1581, 1561,2180,1561, 
1562,2182,1562, 
3, // chain 57
1584,2207,1584, 1568,2191,1568, 1570,2193,1570, 
1573,2196,1573, 34340,2195,1572, 
2, // chain 58
1541,2216,1541, 1540,2217,1540, 1394,2218,1392, 
1393,2219,1391, 
3, // chain 59
1567,2220,1567, 1565,2221,1565, 1428,2222,1426, 
34197,2223,1427, 34201,2224,1431, 
8, // chain 60
1569,2225,1569, 1567,2220,1567, 1428,2222,1426, 
1439,2226,1437, 1438,2227,1436, 1593,2228,1593, 34162,2218,1392, 1540,2217,1540, 1571,2229,1571, 1569,2225,1569, 
15, // chain 61
1594,2230,1594, 1595,2231,1595, 1596,2232,1596, 
1597,2233,1597, 34366,2234,1598, 34367,2235,1599, 34368,2236,1600, 34369,2237,1601, 1602,2238,1602, 1603,2239,1603, 34372,2240,1604, 34373,2241,1605, 1603,2239,1603, 34374,2242,1606, 1607,2243,1607, 34376,2244,1608, 1609,2245,1609, 
2, // chain 62
1603,2239,1603, 1607,2243,1607, 1610,2246,1610, 
1611,2247,1611, 
3, // chain 63
1607,2243,1607, 1612,2248,1612, 1610,2246,1610, 
34284,2249,1514, 34282,2250,1512, 
78, // chain 64
1436,2251,1434, 1427,2252,1425, 1613,2253,1613, 
1614,2254,1614, 34383,2255,1615, 34384,2256,1616, 34385,2257,1617, 34386,2258,1618, 34387,2259,1619, 34195,2252,1425, 1620,2260,1620, 34194,2261,1424, 1441,2262,1439, 1621,2263,1621, 34390,2264,1622, 34208,2265,1438, 1623,2266,1623, 34198,2267,1428, 1624,2268,1624, 
34199,2269,1429, 1625,2270,1625, 34210,2271,1440, 1626,2272,1626, 34213,2273,1443, 1627,2274,1627, 34396,2275,1628, 34215,2276,1445, 1629,2277,1629, 34217,2278,1447, 1630,2279,1630, 34399,2280,1631, 1632,2281,1632, 34401,2282,1633, 1634,2283,1634, 34403,2284,1635, 
1636,2285,1636, 34405,2286,1637, 34406,2287,1638, 1639,2288,1639, 1640,2289,1640, 34409,2290,1641, 34410,2291,1642, 1643,2292,1643, 1644,2293,1644, 34413,2294,1645, 34414,2295,1646, 1376,2296,1374, 1350,2297,1348, 1644,2293,1644, 34113,2298,1343, 1647,2299,1647, 
34416,2300,1648, 34105,2301,1335, 1338,2302,1336, 1649,2303,1649, 1650,2304,1650, 34419,2305,1651, 1652,2306,1652, 34421,2307,1653, 1654,2308,1654, 34367,2309,1599, 1655,2310,1655, 34424,2311,1656, 34425,2312,1657, 34368,2313,1600, 1658,2314,1658, 34427,2315,1659, 
34371,2316,1603, 1660,2317,1660, 34379,2318,1611, 1661,2319,1661, 1662,2320,1662, 1663,2321,1663, 34383,2255,1615, 34432,2322,1664, 1665,2323,1665, 34434,2324,1666, 1667,2325,1667, 1614,2254,1614, 1615,2255,1615, 
7, // chain 65
1618,2258,1618, 1619,2259,1619, 1668,2326,1668, 
1669,2327,1669, 34438,2328,1670, 34439,2329,1671, 34440,2330,1672, 34388,2260,1620, 34387,2259,1619, 
6, // chain 66
1673,2331,1673, 1670,2328,1670, 1671,2329,1671, 
1672,2330,1672, 1674,2332,1674, 34443,2333,1675, 34389,2263,1621, 34388,2260,1620, 
9, // chain 67
1663,2321,1663, 1673,2331,1673, 1674,2332,1674, 
1660,2317,1660, 34444,2334,1676, 34445,2335,1677, 34443,2333,1675, 1678,2336,1678, 34447,2337,1679, 34390,2264,1622, 34389,2263,1621, 
8, // chain 68
1676,2334,1676, 1677,2335,1677, 1680,2338,1680, 
34449,2339,1681, 34446,2336,1678, 1658,2314,1658, 34450,2340,1682, 34391,2266,1623, 34390,2264,1622, 34447,2337,1679, 
4, // chain 69
1683,2341,1683, 1682,2340,1682, 1623,2266,1623, 
1624,2268,1624, 1626,2272,1626, 34393,2270,1625, 
10, // chain 70
1683,2341,1683, 1626,2272,1626, 1684,2342,1684, 
34453,2343,1685, 34395,2274,1627, 1686,2344,1686, 34455,2345,1687, 34396,2275,1628, 1688,2346,1688, 34457,2347,1689, 34398,2279,1630, 34397,2277,1629, 
12, // chain 71
1682,2340,1682, 1683,2341,1683, 1684,2342,1684, 
1656,2311,1656, 34453,2343,1685, 1655,2310,1655, 34454,2344,1686, 1687,2345,1687, 1654,2308,1654, 34456,2346,1688, 1690,2348,1690, 34457,2347,1689, 1632,2281,1632, 34398,2279,1630, 
2, // chain 72
1658,2314,1658, 1682,2340,1682, 1656,2311,1656, 
1657,2312,1657, 
3, // chain 73
1676,2334,1676, 1680,2338,1680, 1659,2315,1659, 
34449,2339,1681, 1658,2314,1658, 
1, // chain 74
1659,2315,1659, 1660,2317,1660, 1676,2334,1676, 
5, // chain 75
1615,2255,1615, 1616,2256,1616, 1663,2321,1663, 
34459,2349,1691, 34385,2257,1617, 1669,2327,1669, 34386,2258,1618, 
3, // chain 76
1669,2327,1669, 1670,2328,1670, 1691,2349,1691, 
34441,2331,1673, 1663,2321,1663, 
8, // chain 77
1692,2350,1692, 1384,2351,1382, 1489,2352,1487, 
1693,2353,1693, 34263,2354,1493, 1667,2355,1667, 34382,2356,1614, 34260,2357,1490, 1437,2358,1435, 1436,2359,1434, 
3, // chain 78
1692,2350,1692, 1693,2353,1693, 1694,2360,1694, 
1384,2351,1382, 34160,2361,1390, 
2, // chain 79
1666,2362,1666, 1694,2360,1694, 1693,2353,1693, 
1667,2355,1667, 
7, // chain 80
1391,1969,1389, 1694,2363,1694, 1695,2364,1695, 
1390,1968,1388, 34464,2365,1696, 34430,2366,1662, 34432,2367,1664, 34462,2363,1694, 1666,2368,1666, 
1, // chain 81
1391,1969,1389, 1392,1970,1390, 1694,2363,1694, 
11, // chain 82
1696,2365,1696, 1697,2369,1697, 1698,2370,1698, 
1699,2371,1699, 34279,2372,1509, 34283,2373,1513, 34468,2374,1700, 34465,2369,1697, 1661,2375,1661, 34469,2376,1701, 34464,2365,1696, 1662,2366,1662, 1661,2375,1661, 
8, // chain 83
1699,2371,1699, 1511,2372,1509, 1508,2377,1506, 
1389,1967,1387, 34156,1966,1386, 34155,1965,1385, 34277,2378,1507, 1501,2379,1499, 1502,2380,1500, 1386,1964,1384, 
2, // chain 84
1699,2371,1699, 1389,1967,1387, 1390,1968,1388, 
1696,2365,1696, 
3, // chain 85
1610,2381,1610, 1516,2382,1514, 1700,2374,1700, 
1661,2375,1661, 1611,2383,1611, 
1, // chain 86
1700,2374,1700, 1516,2382,1514, 1515,2373,1513, 
1, // chain 87
1369,1947,1367, 1366,1944,1364, 1367,1945,1365, 
4, // chain 88
1638,2384,1638, 1635,2385,1635, 1633,2386,1633, 
1631,2387,1631, 1450,2028,1448, 34217,2027,1447, 
3, // chain 89
1639,2388,1639, 1702,2389,1702, 1703,2390,1703, 
1642,2391,1642, 34472,2392,1704, 
3, // chain 90
1702,2389,1702, 1639,2388,1639, 1705,2393,1705, 
1706,2394,1706, 1707,2395,1707, 
2, // chain 91
1639,2388,1639, 1638,2384,1638, 1705,2393,1705, 
34218,2028,1448, 
23, // chain 92
1708,2396,1708, 1634,2283,1634, 1636,2285,1636, 
1709,2397,1709, 34405,2286,1637, 1710,2398,1710, 34408,2289,1640, 1711,2399,1711, 34409,2290,1641, 1712,2400,1712, 34481,2401,1713, 34412,2293,1644, 1647,2299,1647, 1714,2402,1714, 34483,2403,1715, 34484,2404,1716, 34416,2300,1648, 1717,2405,1717, 34418,2304,1650, 
1718,2406,1718, 34487,2407,1719, 34420,2306,1652, 1720,2408,1720, 34458,2348,1690, 34422,2308,1654, 
14, // chain 93
1634,2283,1634, 1708,2396,1708, 1721,2409,1721, 
34488,2408,1720, 34490,2410,1722, 34484,2404,1716, 34477,2397,1709, 1715,2403,1715, 34491,2411,1723, 34478,2398,1710, 1724,2412,1724, 34493,2413,1725, 34479,2399,1711, 1712,2400,1712, 1714,2402,1714, 34481,2401,1713, 
4, // chain 94
1719,2407,1719, 1720,2408,1720, 1722,2410,1722, 
1718,2406,1718, 34485,2405,1717, 34484,2404,1716, 
2, // chain 95
1632,2281,1632, 1634,2283,1634, 1720,2408,1720, 
1690,2348,1690, 
1, // chain 96
1720,2408,1720, 1634,2283,1634, 1721,2409,1721, 
9, // chain 97
1726,2414,1726, 1704,2415,1704, 1703,2416,1703, 
1727,2417,1727, 34496,2418,1728, 34497,2419,1729, 34470,2420,1702, 1730,2421,1730, 34184,2422,1414, 34187,2423,1417, 34475,2424,1707, 
8, // chain 98
1731,2425,1731, 1726,2414,1726, 1732,2426,1732, 
34495,2417,1727, 1733,2427,1733, 34502,2428,1734, 34496,2418,1728, 1735,2429,1735, 34498,2421,1730, 34497,2419,1729, 
13, // chain 99
1352,2430,1350, 1732,2426,1732, 1736,2431,1736, 
34501,2427,1733, 1475,2432,1473, 34505,2433,1737, 34502,2428,1734, 1738,2434,1738, 34503,2429,1735, 1739,2435,1739, 34508,2436,1740, 34509,2437,1741, 34498,2421,1730, 1416,2422,1414, 1415,2438,1413, 
3, // chain 100
1474,2439,1472, 1475,2432,1473, 1737,2433,1737, 
1742,2440,1742, 34506,2434,1738, 
4, // chain 101
1743,2441,1743, 1314,2442,1312, 1325,2443,1323, 
1358,2444,1356, 1744,2445,1744, 34124,2446,1354, 
4, // chain 102
1476,2058,1474, 1466,2045,1464, 1743,2441,1743, 
34235,2046,1465, 1314,2442,1312, 34083,2047,1313, 
1, // chain 103
1743,2441,1743, 1744,2445,1744, 1476,2058,1474, 
2, // chain 104
1546,2447,1546, 1547,2448,1547, 1419,2449,1417, 
34186,2450,1416, 
9, // chain 105
1745,2451,1745, 1546,2447,1546, 1419,2449,1417, 
1707,2452,1707, 1553,2453,1553, 34474,2454,1706, 1705,2455,1705, 1555,2456,1555, 34325,2457,1557, 34218,2458,1448, 1451,2459,1449, 
2, // chain 106
1551,2460,1551, 1546,2447,1546, 1745,2451,1745, 
1553,2453,1553, 
2, // chain 107
1746,2461,1746, 1747,2462,1747, 1748,2463,1748, 
1749,2464,1749, 
9, // chain 108
1750,2465,1750, 1748,2463,1748, 1747,2462,1747, 
1751,2466,1751, 1649,2467,1649, 34520,2468,1752, 1651,2469,1651, 34521,2470,1753, 1598,2234,1598, 1653,2471,1653, 34367,2235,1599, 
4, // chain 109
1598,2234,1598, 1754,2472,1754, 1755,2473,1755, 
1597,2233,1597, 34080,2474,1756, 34524,2475,1757, 
3, // chain 110
1748,2463,1748, 1750,2465,1750, 1336,2476,1334, 
34106,2477,1336, 34417,2467,1649, 
3, // chain 111
1757,2478,1758, 1748,2463,1748, 1336,2476,1334, 
1335,2479,1333, 1534,2480,1532, 
3, // chain 112
1724,2412,1724, 1725,2413,1725, 1714,2402,1714, 
1715,2403,1715, 1723,2411,1723, 
3, // chain 113
1758,2481,1759, 1732,2482,1732, 1352,2483,1350, 
1349,2484,1347, 34121,2485,1351, 
6, // chain 114
1758,2481,1759, 1349,2484,1347, 1759,2486,1760, 
1732,2482,1732, 34499,2487,1731, 34414,2488,1646, 34144,2489,1374, 34117,2484,1347, 
3, // chain 115
1726,2490,1726, 1731,2487,1731, 1643,2491,1643, 
1704,2492,1704, 34410,2493,1642, 
1, // chain 116
1731,2487,1731, 1646,2488,1646, 1643,2491,1643, 
6, // chain 117
1351,1925,1349, 1352,1926,1350, 1736,2494,1736, 
1355,1929,1353, 34528,2495,1761, 34243,2496,1473, 1744,2497,1744, 34244,2498,1474, 
2, // chain 118
1356,1930,1354, 1355,1929,1353, 1760,2495,1761, 
1744,2497,1744, 
2, // chain 119
1597,2233,1597, 1312,2474,1756, 1311,2499,1762, 
1594,2230,1594, 
1, // chain 120
1312,1886,1756, 1756,2500,1757, 1761,2501,1763, 

 0};


// face array: 0kb.
const uint16_t nanosuit_3_face[126] PROGMEM = {
7, // chain 0
1762,2502,1764, 1763,2503,1765, 1764,2504,1766, 
1765,2505,1767, 34534,2506,1768, 1767,2507,1769, 34536,2508,1770, 34537,2509,1771, 1770,2510,1772, 
4, // chain 1
1771,2511,1773, 1772,2512,1774, 1762,2502,1764, 
1773,2513,1775, 34542,2514,1776, 34533,2505,1767, 
16, // chain 2
1773,2513,1775, 1774,2514,1776, 1775,2515,1777, 
1776,2516,1778, 34545,2517,1779, 34546,2518,1780, 34547,2519,1781, 34548,2520,1782, 34549,2521,1783, 34550,2522,1784, 1783,2523,1785, 34552,2524,1786, 1785,2525,1787, 34554,2526,1788, 34555,2527,1789, 1788,2528,1790, 1789,2529,1791, 34558,2530,1792, 
2, // chain 3
1791,2531,1793, 1792,2532,1794, 1783,2523,1785, 
34549,2521,1783, 
1, // chain 4
1785,2525,1787, 1793,2533,1795, 1783,2523,1785, 

 0};


// face array: 0kb.
const uint16_t nanosuit_4_face[261] PROGMEM = {
1, // chain 0
1794,2534,1796, 1795,2535,1796, 1796,2536,1796, 
1, // chain 1
1797,2537,1797, 1798,2538,1797, 1799,2539,1797, 
1, // chain 2
1800,2540,1798, 1801,2541,1798, 1802,2542,1798, 
1, // chain 3
1803,2543,1799, 1804,2544,1799, 1805,2545,1799, 
1, // chain 4
1806,2546,1800, 1807,2547,1800, 1808,2548,1800, 
1, // chain 5
1809,2549,1801, 1810,2550,1801, 1811,2551,1801, 
1, // chain 6
1812,2552,1802, 1813,2553,1802, 1814,2554,1802, 
1, // chain 7
1815,2555,1803, 1816,2556,1803, 1817,2557,1803, 
1, // chain 8
1818,2558,1804, 1819,2559,1804, 1820,2560,1804, 
1, // chain 9
1821,2561,1805, 1822,2562,1805, 1823,2563,1805, 
1, // chain 10
1824,2564,1806, 1825,2565,1806, 1826,2566,1806, 
1, // chain 11
1827,2567,1807, 1828,2568,1807, 1829,2569,1807, 
1, // chain 12
1830,2570,1808, 1831,2571,1808, 1832,2572,1808, 
1, // chain 13
1833,2573,1809, 1834,2574,1809, 1835,2575,1809, 
1, // chain 14
1836,2576,1810, 1837,2577,1810, 1838,2578,1810, 
1, // chain 15
1839,2579,1811, 1840,2580,1811, 1841,2581,1811, 
1, // chain 16
1842,2582,1812, 1843,2583,1812, 1844,2584,1812, 
1, // chain 17
1845,2585,1813, 1846,2586,1813, 1847,2587,1813, 
1, // chain 18
1848,2588,1814, 1849,2589,1814, 1850,2590,1814, 
1, // chain 19
1851,2591,1815, 1852,2592,1815, 1853,2593,1815, 
1, // chain 20
1854,2594,1816, 1855,2595,1816, 1856,2596,1816, 
1, // chain 21
1857,2597,1817, 1858,2598,1817, 1859,2599,1817, 
1, // chain 22
1860,2600,1818, 1861,2601,1818, 1862,2602,1818, 
1, // chain 23
1863,2603,1819, 1864,2604,1819, 1865,2605,1819, 
1, // chain 24
1866,2606,1820, 1867,2607,1820, 1868,2608,1820, 
1, // chain 25
1869,2609,1821, 1870,2610,1821, 1871,2611,1821, 

 0};


// face array: 11kb.
const uint16_t nanosuit_5_face[5950] PROGMEM = {
4, // chain 0
1872,2612,1822, 1873,2613,1823, 1874,2614,1824, 
34643,2615,1825, 34644,2616,1826, 34645,2617,1827, 
22, // chain 1
1875,2615,1825, 1876,2616,1826, 1878,2618,1828, 
1879,2619,1829, 34648,2620,1830, 34649,2621,1831, 1882,2622,1832, 34651,2623,1833, 34652,2624,1834, 34653,2625,1835, 1886,2626,1836, 1887,2627,1837, 34656,2628,1838, 1889,2629,1839, 34658,2630,1840, 34659,2631,1841, 1892,2632,1842, 34661,2633,1843, 1894,2634,1844, 
1895,2635,1845, 1890,2630,1840, 34664,2636,1846, 34665,2637,1847, 34666,2638,1848, 
10, // chain 2
1887,2627,1837, 1889,2629,1839, 1883,2623,1833, 
34667,2639,1849, 34668,2640,1850, 34658,2630,1840, 1901,2641,1851, 34664,2636,1846, 1902,2642,1852, 34671,2643,1853, 34665,2637,1847, 1904,2644,1854, 
7, // chain 3
1875,2615,1825, 1879,2619,1829, 1874,2614,1824, 
34673,2645,1855, 34674,2646,1856, 34648,2620,1830, 1882,2622,1832, 1899,2639,1849, 34651,2623,1833, 
1, // chain 4
1887,2627,1837, 1883,2623,1833, 1884,2624,1834, 
38, // chain 5
1872,2612,1822, 1874,2614,1824, 1905,2645,1855, 
1907,2647,1857, 34676,2648,1858, 34674,2646,1856, 1909,2649,1859, 34678,2650,1860, 34667,2639,1849, 1900,2640,1850, 1911,2651,1861, 34669,2641,1851, 1912,2652,1862, 34670,2642,1852, 1913,2653,1863, 1914,2654,1864, 1915,2655,1865, 34684,2656,1866, 1917,2657,1867, 
1918,2658,1868, 34687,2659,1869, 34688,2660,1870, 1921,2661,1871, 1922,2662,1872, 34691,2663,1873, 34692,2664,1874, 34693,2665,1875, 1926,2666,1876, 34695,2667,1877, 1928,2668,1878, 1929,2669,1879, 1930,2670,1880, 1924,2664,1874, 34699,2671,1881, 1932,2672,1882, 
1933,2673,1883, 34702,2674,1884, 1935,2675,1885, 1908,2648,1858, 34675,2647,1857, 
5, // chain 6
1912,2652,1862, 1915,2655,1865, 1911,2651,1861, 
34704,2676,1886, 34686,2658,1868, 1922,2662,1872, 34687,2659,1869, 
7, // chain 7
1911,2651,1861, 1936,2676,1886, 1910,2650,1860, 
34677,2649,1859, 34690,2662,1872, 1937,2677,1887, 34691,2663,1873, 1933,2673,1883, 34692,2664,1874, 
2, // chain 8
1933,2673,1883, 1908,2648,1858, 1909,2649,1859, 
1937,2677,1887, 
35, // chain 9
1938,2678,1888, 1939,2679,1889, 1940,2680,1890, 
1941,2681,1891, 34710,2682,1892, 34711,2683,1893, 34712,2684,1894, 34713,2685,1895, 34707,2679,1889, 1946,2686,1896, 34715,2687,1897, 34716,2688,1898, 34717,2689,1899, 34706,2678,1888, 1950,2690,1900, 34719,2691,1901, 34720,2692,1902, 34709,2681,1891, 1953,2693,1903, 
34722,2694,1904, 34723,2695,1905, 34710,2682,1892, 1956,2696,1906, 34725,2697,1907, 34711,2683,1893, 1958,2698,1908, 34712,2684,1894, 1959,2699,1909, 34728,2700,1910, 34729,2701,1911, 34713,2685,1895, 1946,2686,1896, 1962,2702,1912, 34731,2703,1913, 34715,2687,1897, 
1964,2704,1914, 34716,2688,1898, 
1, // chain 10
1951,2691,1901, 1965,2705,1915, 1950,2690,1900, 
9, // chain 11
1956,2696,1906, 1966,2706,1916, 1967,2707,1917, 
1968,2708,1918, 34737,2709,1919, 34738,2710,1920, 34739,2711,1921, 34734,2706,1916, 1972,2712,1922, 34725,2697,1907, 34724,2696,1906, 
6, // chain 12
1973,2713,1923, 1960,2700,1910, 1961,2701,1911, 
1974,2714,1924, 34730,2702,1912, 1975,2715,1925, 34744,2716,1926, 34731,2703,1913, 
20, // chain 13
1972,2712,1922, 1957,2697,1907, 1958,2698,1908, 
1977,2717,1927, 34746,2718,1928, 34727,2699,1909, 1979,2719,1929, 34748,2720,1930, 34749,2721,1931, 34728,2700,1910, 1973,2713,1923, 1982,2722,1932, 34742,2714,1924, 1983,2723,1933, 34752,2724,1934, 34753,2725,1935, 34754,2726,1936, 34755,2727,1937, 34743,2715,1925, 
1988,2728,1938, 34757,2729,1939, 34744,2716,1926, 
26, // chain 14
1990,2730,1940, 1991,2731,1941, 1992,2732,1942, 
1993,2733,1943, 34762,2734,1944, 34763,2735,1945, 34764,2736,1946, 34759,2731,1941, 1969,2709,1919, 34765,2737,1947, 34758,2730,1940, 1998,2738,1948, 1968,2708,1918, 34767,2739,1949, 34768,2740,1950, 2001,2741,1951, 2002,2742,1952, 34771,2743,1953, 34772,2744,1954, 
2005,2745,1955, 34774,2746,1956, 2007,2747,1957, 2008,2748,1958, 34777,2749,1959, 2010,2750,1960, 34779,2751,1961, 2012,2752,1962, 34781,2753,1963, 
6, // chain 15
1979,2719,1929, 1980,2720,1930, 2014,2754,1964, 
34783,2755,1965, 34784,2756,1966, 34749,2721,1931, 1983,2723,1933, 34750,2722,1932, 
26, // chain 16
1977,2717,1927, 1978,2718,1928, 1979,2719,1929, 
2017,2757,1967, 34782,2754,1964, 2018,2758,1968, 34783,2755,1965, 2019,2759,1969, 34788,2760,1970, 34784,2756,1966, 1983,2723,1933, 1984,2724,1934, 2021,2761,1971, 34790,2762,1972, 34791,2763,1973, 34792,2764,1974, 34753,2725,1935, 2025,2765,1975, 34754,2726,1936, 
2026,2766,1976, 34795,2767,1977, 34755,2727,1937, 2028,2768,1978, 34756,2728,1938, 2029,2769,1979, 34798,2770,1980, 34799,2771,1981, 34757,2729,1939, 
28, // chain 17
2017,2757,1967, 2018,2758,1968, 2032,2772,1982, 
2033,2773,1983, 34802,2774,1984, 34803,2775,1985, 34786,2758,1968, 2036,2776,1986, 34787,2759,1969, 2037,2777,1987, 34806,2778,1988, 34788,2760,1970, 2021,2761,1971, 2039,2779,1989, 34808,2780,1990, 34809,2781,1991, 34790,2762,1972, 2042,2782,1992, 34791,2763,1973, 
2043,2783,1993, 34812,2784,1994, 34792,2764,1974, 2045,2785,1995, 34793,2765,1975, 2026,2766,1976, 2046,2786,1996, 34815,2787,1997, 34816,2788,1998, 34817,2789,1999, 34795,2767,1977, 
13, // chain 18
2017,2757,1967, 2033,2773,1983, 2050,2790,2000, 
1977,2717,1927, 34819,2791,2001, 34820,2792,2002, 34821,2793,2003, 34801,2773,1983, 2054,2794,2004, 34802,2774,1984, 2055,2795,2005, 34824,2796,2006, 34825,2797,2007, 34804,2776,1986, 34803,2775,1985, 
13, // chain 19
1977,2717,1927, 2051,2791,2001, 1972,2712,1922, 
34739,2711,1921, 34826,2798,2008, 34820,2792,2002, 2059,2799,2009, 34828,2800,2010, 34829,2801,2011, 34830,2802,2012, 34821,2793,2003, 2054,2794,2004, 2063,2803,2013, 34832,2804,2014, 34823,2795,2005, 
36, // chain 20
2038,2778,1988, 2039,2779,1989, 2065,2805,2015, 
34834,2806,2016, 34835,2807,2017, 34836,2808,2018, 34808,2780,1990, 2069,2809,2019, 34809,2781,1991, 2042,2782,1992, 2070,2810,2020, 34839,2811,2021, 34811,2783,1993, 2072,2812,2022, 34812,2784,1994, 2073,2813,2023, 34813,2785,1995, 2046,2786,1996, 2074,2814,2024, 
34815,2787,1997, 1893,2815,1843, 1891,2816,1841, 2073,2813,2023, 34843,2817,2025, 34844,2818,2026, 34656,2819,1838, 2077,2820,2027, 34654,2821,1836, 1885,2822,1835, 2078,2823,2028, 34649,2824,1831, 2079,2825,2029, 34646,2826,1828, 1876,2827,1826, 2080,2828,2030, 
34645,2829,1827, 2081,2830,2031, 34641,2831,1823, 
1, // chain 21
2037,2777,1987, 2057,2797,2007, 2036,2776,1986, 
28, // chain 22
2063,2803,2013, 2082,2832,2032, 2083,2833,2033, 
2062,2802,2012, 34829,2801,2011, 34852,2834,2034, 34853,2835,2035, 34850,2832,2032, 2086,2836,2036, 2087,2837,2037, 2088,2838,2038, 34857,2839,2039, 2090,2840,2040, 34859,2841,2041, 2092,2842,2042, 34861,2843,2043, 2094,2844,2044, 2095,2845,2045, 34864,2846,2046, 
34865,2847,2047, 2098,2848,2048, 34867,2849,2049, 2100,2850,2050, 34869,2851,2051, 34870,2852,2052, 2103,2853,2053, 34872,2854,2054, 34873,2855,2055, 2106,2856,2056, 34875,2857,2057, 
3, // chain 23
2108,2858,2058, 2109,2859,2059, 2060,2800,2010, 
2084,2834,2034, 34829,2801,2011, 
6, // chain 24
2108,2858,2058, 2084,2834,2034, 2110,2860,2060, 
2111,2861,2061, 34880,2862,2062, 34856,2838,2038, 34853,2835,2035, 34852,2834,2034, 
6, // chain 25
1969,2709,1919, 2059,2799,2009, 2060,2800,2010, 
2109,2859,2059, 1995,2735,1945, 34881,2863,2063, 34879,2861,2061, 34876,2858,2058, 
3, // chain 26
1970,2710,1920, 1971,2711,1921, 2058,2798,2008, 
2059,2799,2009, 1969,2709,1919, 
1, // chain 27
1969,2709,1919, 1995,2735,1945, 1996,2736,1946, 
9, // chain 28
1994,2734,1944, 1995,2735,1945, 2113,2863,2063, 
2114,2864,2064, 34883,2865,2065, 34884,2866,2066, 34879,2861,2061, 2112,2862,2062, 2117,2867,2067, 34858,2840,2040, 34856,2838,2038, 
4, // chain 29
2116,2866,2066, 2117,2867,2067, 2115,2865,2065, 
34863,2845,2045, 34860,2842,2042, 34858,2840,2040, 
5, // chain 30
1994,2734,1944, 2114,2864,2064, 1993,2733,1943, 
34886,2868,2068, 34883,2865,2065, 2096,2846,2046, 34863,2845,2045, 
2, // chain 31
2118,2868,2068, 2096,2846,2046, 2119,2869,2069, 
34866,2848,2048, 
4, // chain 32
2119,2869,2069, 2120,2870,2070, 2118,2868,2068, 
34889,2871,2071, 1993,2733,1943, 34758,2730,1940, 
1, // chain 33
1997,2737,1947, 1968,2708,1918, 1969,2709,1919, 
21, // chain 34
2122,2872,2072, 1956,2696,1906, 1968,2708,1918, 
2123,2873,2073, 34767,2739,1949, 2002,2742,1952, 2124,2874,2074, 34771,2743,1953, 1955,2695,1905, 34722,2694,1904, 34893,2875,2075, 34773,2745,1955, 1953,2693,1903, 34776,2748,1958, 1952,2692,1902, 34778,2750,1960, 2126,2876,2076, 34780,2752,1962, 2127,2877,2077, 
2128,2878,2078, 2129,2879,2079, 1952,2692,1902, 34719,2691,1901, 
3, // chain 35
1955,2695,1905, 1956,2696,1906, 2122,2872,2072, 
2124,2874,2074, 34891,2873,2073, 
1, // chain 36
1953,2693,1903, 1954,2694,1904, 2125,2875,2075, 
4, // chain 37
2130,2880,2080, 2131,2881,2081, 2132,2882,2082, 
34901,2883,2083, 34902,2884,2084, 2135,2885,2085, 
2, // chain 38
2136,2886,2086, 2137,2887,2087, 2132,2882,2082, 
34898,2880,2080, 
4, // chain 39
2138,2888,2088, 2139,2889,2089, 2140,2890,2090, 
34909,2891,2091, 2142,2892,2092, 34911,2893,2093, 
8, // chain 40
2133,2883,2083, 2138,2888,2088, 2140,2890,2090, 
2144,2894,2094, 34910,2892,2092, 2145,2895,2095, 34911,2896,2093, 2146,2897,2096, 34915,2898,2097, 34916,2899,2098, 
9, // chain 41
2132,2882,2082, 2133,2883,2083, 2144,2894,2094, 
2136,2886,2086, 34917,2900,2099, 34913,2895,2095, 2150,2901,2100, 34914,2897,2096, 2151,2902,2101, 34920,2903,2102, 34915,2898,2097, 
3, // chain 42
2150,2901,2100, 2151,2902,2101, 2153,2904,2103, 
2149,2900,2099, 34904,2886,2086, 
11, // chain 43
2154,2905,2104, 2155,2906,2105, 2156,2907,2106, 
2137,2908,2087, 34898,2909,2080, 34925,2910,2107, 34923,2906,2105, 2158,2911,2108, 34927,2912,2109, 34922,2905,2104, 2160,2913,2110, 34929,2914,2111, 34905,2908,2087, 
4, // chain 44
2162,2915,2112, 2158,2911,2108, 2159,2912,2109, 
2160,2913,2110, 2163,2916,2113, 34929,2914,2111, 
4, // chain 45
2164,2917,2114, 2165,2918,2115, 2162,2915,2112, 
34934,2919,2116, 2167,2920,2117, 2158,2911,2108, 
1, // chain 46
2162,2915,2112, 2163,2916,2113, 2164,2917,2114, 
81, // chain 47
2168,2921,2118, 2169,2922,2119, 2170,2923,2120, 
2171,2924,2121, 34940,2925,2122, 34941,2926,2123, 34937,2922,2119, 2174,2927,2124, 34936,2921,2118, 2175,2928,2125, 34944,2929,2126, 34945,2930,2127, 34939,2924,2121, 2178,2931,2128, 34940,2925,2122, 2179,2932,2129, 34948,2933,2130, 34949,2934,2131, 34941,2926,2123, 
2182,2935,2132, 34951,2936,2133, 34952,2937,2134, 34953,2938,2135, 34954,2939,2136, 34942,2927,2124, 2187,2940,2137, 34943,2928,2125, 2188,2941,2138, 34944,2929,2126, 2189,2942,2139, 34958,2943,2140, 34945,2930,2127, 2191,2944,2141, 34960,2945,2142, 34946,2931,2128, 
2193,2946,2143, 34962,2947,2144, 34947,2932,2129, 2195,2948,2145, 34948,2933,2130, 2196,2949,2146, 34965,2950,2147, 34949,2934,2131, 2198,2951,2148, 34950,2935,2132, 2199,2952,2149, 34968,2953,2150, 34951,2936,2133, 2201,2954,2151, 34970,2955,2152, 34952,2937,2134, 
2203,2956,2153, 34972,2957,2154, 34953,2938,2135, 2205,2958,2155, 34954,2939,2136, 2206,2959,2156, 34975,2960,2157, 34976,2961,2158, 34955,2940,2137, 2209,2962,2159, 34978,2963,2160, 34956,2941,2138, 2211,2964,2161, 34957,2942,2139, 2212,2965,2162, 34958,2943,2140, 
2213,2966,2163, 34959,2944,2141, 2192,2945,2142, 2214,2967,2164, 34983,2968,2165, 34961,2946,2143, 2216,2969,2166, 34962,2947,2144, 2217,2970,2167, 34986,2971,2168, 34963,2948,2145, 2219,2972,2169, 34988,2973,2170, 34964,2949,2146, 2221,2974,2171, 34965,2950,2147, 
15, // chain 48
2222,2975,2172, 2213,2966,2163, 2214,2967,2164, 
2223,2976,2173, 34992,2977,2174, 34983,2968,2165, 2225,2978,2175, 34984,2969,2166, 2226,2979,2176, 34985,2970,2167, 2227,2980,2177, 34996,2981,2178, 34997,2982,2179, 34986,2971,2168, 2230,2983,2180, 34999,2984,2181, 34987,2972,2169, 
20, // chain 49
2232,2985,2182, 2233,2986,2183, 2234,2987,2184, 
35003,2988,2185, 35004,2989,2186, 2237,2990,2187, 2238,2991,2188, 35007,2992,2189, 2210,2963,2160, 34977,2962,2159, 35008,2993,2190, 35009,2994,2191, 2242,2995,2192, 35011,2996,2193, 2244,2997,2194, 2245,2998,2195, 35014,2999,2196, 2247,3000,2197, 35016,3001,2198, 
35017,3002,2199, 35018,3003,2200, 35019,3004,2201, 
33, // chain 50
2252,3005,2202, 2253,3006,2203, 2235,2988,2185, 
2254,3007,2204, 35006,2991,2188, 2210,2963,2160, 2211,2964,2161, 2252,3005,2202, 34980,2965,2162, 2253,3006,2203, 35023,3008,2205, 34981,2966,2163, 2222,2975,2172, 2256,3009,2206, 35025,3010,2207, 34991,2976,2173, 2258,3011,2208, 35027,3012,2209, 34992,2977,2174, 
2225,2978,2175, 2260,3013,2210, 35029,3014,2211, 34994,2979,2176, 2262,3015,2212, 35031,3016,2213, 34995,2980,2177, 2264,3017,2214, 34996,2981,2178, 2007,3018,1957, 34777,3019,1959, 34997,2982,2179, 2011,3020,1961, 35033,3021,2215, 35034,3022,2216, 34998,2983,2180, 
25, // chain 51
2234,2987,2184, 2235,2988,2185, 2253,3006,2203, 
2267,3023,2217, 35023,3008,2205, 2256,3009,2206, 2268,3024,2218, 35037,3025,2219, 35038,3026,2220, 35039,3027,2221, 35025,3010,2207, 2258,3011,2208, 2272,3028,2222, 35027,3012,2209, 2260,3013,2210, 2273,3029,2223, 34766,3030,1948, 35042,3031,2224, 35043,3032,2225, 
35029,3014,2211, 2262,3015,2212, 2276,3033,2226, 35031,3016,2213, 2004,3034,1954, 34774,3035,1956, 35032,3017,2214, 2007,3018,1957, 
30, // chain 52
2277,3036,2227, 2278,3037,2228, 2279,3038,2229, 
2280,3039,2230, 35049,3040,2231, 34887,3041,2069, 34888,3042,2070, 35050,3043,2232, 35046,3037,2228, 2283,3044,2233, 35052,3045,2234, 35053,3046,2235, 35054,3047,2236, 35045,3036,2227, 2287,3048,2237, 35048,3039,2230, 2288,3049,2238, 35057,3050,2239, 35049,3040,2231, 
2290,3051,2240, 35059,3052,2241, 34887,3041,2069, 2098,3053,2048, 2292,3054,2242, 34868,3055,2050, 2101,3056,2051, 2293,3057,2243, 34871,3058,2053, 2294,3059,2244, 2295,3060,2245, 35064,3061,2246, 35065,3062,2247, 
10, // chain 53
2298,3063,2248, 2285,3046,2235, 2286,3047,2236, 
2299,3064,2249, 35055,3048,2237, 2300,3065,2250, 35056,3049,2238, 2301,3066,2251, 35070,3067,2252, 35057,3050,2239, 2303,3068,2253, 35058,3051,2240, 
9, // chain 54
2298,3063,2248, 2299,3064,2249, 2304,3069,2254, 
2270,3026,2220, 35037,3025,2219, 35073,3070,2255, 35074,3071,2256, 35067,3064,2249, 2300,3065,2250, 2307,3072,2257, 35069,3066,2251, 
4, // chain 55
2234,2987,2184, 2267,3023,2217, 2268,3024,2218, 
2308,3073,2258, 35073,3070,2255, 35037,3025,2219, 
2, // chain 56
2309,3074,2259, 2310,3075,2260, 2306,3071,2256, 
2307,3072,2257, 
2, // chain 57
2305,3070,2255, 2306,3071,2256, 2310,3075,2260, 
2308,3073,2258, 
1, // chain 58
2234,2987,2184, 2308,3073,2258, 2232,2985,2182, 
17, // chain 59
2311,3076,2261, 2312,3077,2262, 2313,3078,2263, 
2314,3079,2264, 34974,2959,2156, 35083,3080,2265, 35080,3077,2262, 2316,3081,2266, 35085,3082,2267, 35079,3076,2261, 2318,3083,2268, 35087,3084,2269, 35088,3085,2270, 35089,3086,2271, 35082,3079,2264, 2322,3087,2272, 35091,3088,2273, 34975,2960,2157, 34974,2959,2156, 
5, // chain 60
2324,3089,2274, 2322,3087,2272, 2325,3090,2275, 
2240,2993,2190, 34976,2961,2158, 35091,3088,2273, 35090,3087,2272, 
2, // chain 61
2245,2998,2195, 2324,3089,2274, 2240,2993,2190, 
2242,2995,2192, 
4, // chain 62
2321,3086,2271, 2322,3087,2272, 2320,3085,2270, 
35092,3089,2274, 2247,3000,2197, 35013,2998,2195, 
1, // chain 63
2208,2961,2158, 2209,2962,2159, 2240,2993,2190, 
6, // chain 64
2326,3091,2276, 2327,3092,2277, 2328,3093,2278, 
35097,3094,2279, 35098,3095,2280, 35099,3096,2281, 2332,3097,2282, 35101,3098,2283, 
22, // chain 65
2334,3099,2284, 2335,3100,2285, 2336,3101,2286, 
2337,3102,2287, 35106,3103,2288, 35107,3104,2289, 35108,3105,2290, 35109,3106,2291, 35110,3107,2292, 35103,3100,2285, 2343,3108,2293, 35112,3109,2294, 2345,3110,2295, 35114,3111,2296, 2347,3112,2297, 2348,3113,2298, 35117,3114,2299, 35118,3115,2300, 35119,3116,2301, 
2352,3117,2302, 35121,3118,2303, 35122,3119,2304, 2355,3120,2305, 35124,3121,2306, 
3, // chain 66
2357,3122,2307, 2334,3099,2284, 2337,3102,2287, 
2358,3123,2308, 35106,3103,2288, 
14, // chain 67
2359,3124,2309, 2360,3125,2310, 2338,3103,2288, 
2339,3104,2289, 2361,3126,2311, 35130,3127,2312, 35108,3105,2290, 2363,3128,2313, 35132,3129,2314, 35109,3106,2291, 2365,3130,2315, 35134,3131,2316, 35110,3107,2292, 2348,3113,2298, 35111,3108,2293, 2345,3110,2295, 
5, // chain 68
2352,3117,2302, 2353,3118,2303, 2367,3132,2317, 
2368,3133,2318, 35137,3134,2319, 35123,3120,2305, 35121,3118,2303, 
1, // chain 69
2361,3126,2311, 2370,3135,2320, 2359,3124,2309, 
11, // chain 70
2371,3136,2321, 2362,3127,2312, 2363,3128,2313, 
2372,3137,2322, 35141,3138,2323, 35132,3129,2314, 2374,3139,2324, 35133,3130,2315, 2375,3140,2325, 35144,3141,2326, 35134,3131,2316, 2349,3114,2299, 35116,3113,2298, 
2, // chain 71
2377,3142,2327, 2378,3143,2328, 2373,3138,2323, 
35140,3137,2322, 
25, // chain 72
2379,3144,2329, 2380,3145,2330, 2381,3146,2331, 
2382,3147,2332, 35151,3148,2333, 35152,3149,2334, 35153,3150,2335, 35154,3151,2336, 35155,3152,2337, 35148,3145,2330, 2388,3153,2338, 35157,3154,2339, 35158,3155,2340, 2377,3142,2327, 2391,3156,2341, 35141,3138,2323, 2374,3139,2324, 2388,3153,2338, 35143,3140,2325, 
2392,3157,2342, 35154,3151,2336, 35161,3158,2343, 35144,3141,2326, 2368,3133,2318, 35120,3117,2302, 35118,3115,2300, 35117,3114,2299, 
1, // chain 73
2389,3154,2339, 2391,3156,2341, 2388,3153,2338, 
2, // chain 74
2387,3152,2337, 2388,3153,2338, 2392,3157,2342, 
2386,3151,2336, 
5, // chain 75
2393,3158,2343, 2368,3133,2318, 2394,3159,2344, 
2395,3160,2345, 2386,3151,2336, 35164,3161,2346, 2385,3150,2335, 
4, // chain 76
2382,3147,2332, 2383,3148,2333, 2397,3162,2347, 
2398,3163,2348, 2399,3164,2349, 2379,3144,2329, 
1, // chain 77
2368,3133,2318, 2369,3134,2319, 2394,3159,2344, 
13, // chain 78
2400,3165,2350, 2378,3166,2328, 2401,3167,2351, 
35145,3168,2327, 2390,3169,2340, 2400,3165,2350, 35170,3170,2352, 34920,3171,2102, 2403,3172,2353, 35172,3173,2354, 34915,3174,2097, 2148,3175,2098, 2405,3176,2355, 2406,3177,2356, 34916,3178,2098, 
6, // chain 79
2407,3179,2357, 2408,3180,2358, 2400,3165,2350, 
2402,3170,2352, 2403,3172,2353, 2409,3181,2359, 35174,3177,2356, 35172,3173,2354, 
12, // chain 80
2410,3182,2360, 2411,3183,2361, 2412,3184,2362, 
2413,3185,2363, 2414,3186,2364, 2415,3187,2365, 2416,3188,2366, 2411,3183,2361, 35106,3189,2288, 2360,3190,2310, 2417,3191,2367, 35186,3192,2368, 2412,3184,2362, 2411,3183,2361, 
3, // chain 81
2274,3031,2224, 2275,3032,2225, 2276,3033,2226, 
2001,3193,1951, 34772,3034,1954, 
5, // chain 82
2419,3194,2369, 2013,3195,1963, 2011,3020,1961, 
2265,3021,2215, 2420,3196,2370, 35189,3197,2371, 35034,3022,2216, 
1, // chain 83
2231,2984,2181, 2422,3198,2372, 2230,2983,2180, 
4, // chain 84
2423,3199,2373, 2199,2952,2149, 2200,2953,2150, 
2424,3200,2374, 35193,3201,2375, 34969,2954,2151, 
1, // chain 85
2424,3200,2374, 2426,3202,2376, 2423,3199,2373, 
4, // chain 86
2427,3203,2377, 2203,2956,2153, 2204,2957,2154, 
2205,2958,2155, 2315,3080,2265, 34974,2959,2156, 
6, // chain 87
2203,2956,2153, 2427,3203,2377, 2428,3204,2378, 
2429,3205,2379, 35198,3206,2380, 35084,3081,2266, 35195,3203,2377, 2315,3080,2265, 
3, // chain 88
2202,2955,2152, 2203,2956,2153, 2431,3207,2381, 
35200,3208,2382, 35197,3205,2379, 
3, // chain 89
2430,3206,2380, 2316,3081,2266, 2334,3209,2284, 
2357,3210,2307, 2429,3205,2379, 
3, // chain 90
2433,3211,2383, 2334,3209,2284, 2316,3081,2266, 
2434,3212,2384, 35085,3082,2267, 
10, // chain 91
2335,3213,2285, 2435,3214,2385, 2436,3215,2386, 
2344,3216,2294, 35114,3217,2296, 35205,3218,2387, 35087,3084,2269, 35203,3214,2385, 2438,3219,2388, 35201,3211,2383, 35102,3209,2284, 35103,3213,2285, 
1, // chain 92
2438,3219,2388, 2318,3083,2268, 2319,3084,2269, 
6, // chain 93
2319,3084,2269, 2320,3085,2270, 2437,3218,2387, 
35207,3220,2389, 35015,3000,2197, 2440,3221,2390, 35017,3002,2199, 35016,3001,2198, 
8, // chain 94
2437,3218,2387, 2439,3220,2389, 2440,3221,2390, 
2347,3222,2297, 35119,3223,2301, 35122,3224,2304, 35017,3002,2199, 2356,3225,2306, 35018,3003,2200, 2355,3226,2305, 
1, // chain 95
2437,3218,2387, 2347,3222,2297, 2346,3217,2296, 
5, // chain 96
2441,3227,2391, 2442,3228,2392, 2284,3045,2234, 
2272,3028,2222, 35053,3046,2235, 2270,3026,2220, 35066,3063,2248, 
5, // chain 97
2441,3227,2391, 2272,3028,2222, 2443,3229,2393, 
2442,3228,2392, 34758,3230,1940, 35041,3029,2223, 35040,3028,2222, 
1, // chain 98
2273,3029,2223, 1998,3030,1948, 1990,3230,1940, 
1, // chain 99
2270,3026,2220, 2271,3027,2221, 2272,3028,2222, 
2, // chain 100
2001,3193,1951, 2000,3231,1950, 2274,3031,2224, 
34766,3030,1948, 
7, // chain 101
2283,3044,2233, 2284,3045,2234, 2442,3228,2392, 
2444,3232,2394, 34758,3230,1940, 2121,3233,2071, 2120,3042,2070, 2282,3043,2232, 2283,3044,2233, 
1, // chain 102
2296,3061,2246, 2445,3234,2395, 2295,3060,2245, 
2, // chain 103
2446,3235,2396, 2447,3236,2397, 2448,3237,2398, 
35217,3238,2399, 
3, // chain 104
2450,3239,2400, 2451,3240,2401, 2452,3241,2402, 
35165,3242,2347, 35166,3243,2348, 
9, // chain 105
2453,3244,2403, 2398,3243,2348, 2454,3245,2404, 
2455,3246,2405, 35224,3247,2406, 35225,3248,2407, 35226,3249,2408, 35227,3250,2409, 35228,3251,2410, 35229,3252,2411, 35166,3243,2348, 
4, // chain 106
2462,3253,2412, 2457,3248,2407, 2463,3254,2413, 
2446,3235,2396, 2464,3255,2414, 35216,3237,2398, 
1, // chain 107
2453,3244,2403, 2399,3256,2349, 2398,3243,2348, 
1, // chain 108
2457,3248,2407, 2458,3249,2408, 2463,3254,2413, 
12, // chain 109
2465,3257,2415, 2466,3258,2416, 2467,3259,2417, 
35236,3260,2418, 2469,3261,2419, 2470,3262,2420, 2471,3263,2421, 35240,3264,2422, 2473,3265,2423, 35242,3266,2424, 35063,3267,2245, 35061,3268,2243, 35243,3269,2425, 2292,3270,2242, 
11, // chain 110
2467,3259,2417, 2471,3263,2421, 2465,3257,2415, 
35244,3271,2426, 35241,3265,2423, 2477,3272,2427, 35246,3273,2428, 35247,3274,2429, 35242,3266,2424, 2480,3275,2430, 35063,3267,2245, 2481,3276,2431, 35213,3277,2395, 
10, // chain 111
2477,3272,2427, 2478,3273,2428, 2482,3278,2432, 
35251,3279,2433, 35247,3274,2429, 2484,3280,2434, 35253,3281,2435, 35248,3275,2430, 2486,3282,2436, 35255,3283,2437, 35256,3284,2438, 35249,3276,2431, 
10, // chain 112
2448,3285,2398, 2449,3286,2399, 2476,3271,2426, 
2477,3272,2427, 2482,3278,2432, 2489,3287,2439, 35258,3288,2440, 35259,3289,2441, 35251,3279,2433, 2492,3290,2442, 35261,3291,2443, 35252,3280,2434, 
2, // chain 113
2163,3292,2113, 2492,3290,2442, 2493,3291,2443, 
2164,3293,2114, 
6, // chain 114
2464,3294,2414, 2448,3285,2398, 2489,3287,2439, 
2462,3295,2412, 35262,3296,2444, 35263,3297,2445, 35264,3298,2446, 35258,3288,2440, 
33, // chain 115
2497,3299,2447, 2491,3289,2441, 2492,3290,2442, 
2498,3300,2448, 34931,3292,2113, 2499,3301,2449, 34929,3302,2111, 2500,3303,2450, 34905,3304,2087, 2136,3305,2086, 2501,3306,2451, 34921,3307,2103, 2502,3308,2452, 34919,3309,2101, 2503,3310,2453, 34920,3311,2102, 2504,3312,2454, 35273,3313,2455, 35158,3314,2340, 
2380,3315,2330, 2379,3316,2329, 2504,3312,2454, 35167,3317,2349, 2503,3310,2453, 35274,3318,2456, 35275,3319,2457, 35221,3320,2403, 2455,3321,2405, 2456,3322,2406, 2508,3323,2458, 35277,3324,2459, 35278,3325,2460, 35225,3326,2407, 2494,3296,2444, 35230,3295,2412, 
7, // chain 116
2497,3299,2447, 2498,3300,2448, 2495,3297,2445, 
35262,3296,2444, 35279,3327,2461, 35267,3301,2449, 2512,3328,2462, 35269,3306,2451, 35268,3303,2450, 
1, // chain 117
2495,3297,2445, 2496,3298,2446, 2497,3299,2447, 
8, // chain 118
2513,3329,2463, 2510,3325,2460, 2511,3327,2461, 
2512,3328,2462, 2514,3330,2464, 35269,3306,2451, 2502,3308,2452, 2515,3331,2465, 35274,3318,2456, 35271,3310,2453, 
1, // chain 119
2510,3325,2460, 2494,3296,2444, 2511,3327,2461, 
6, // chain 120
2510,3325,2460, 2513,3329,2463, 2509,3324,2459, 
35282,3330,2464, 2515,3331,2465, 2508,3323,2458, 35275,3319,2457, 35274,3318,2456, 
7, // chain 121
2516,3332,2466, 2517,3333,2467, 2518,3334,2468, 
2408,3335,2358, 35168,3336,2350, 35146,3337,2328, 35285,3333,2467, 2519,3338,2469, 35288,3339,2470, 
2, // chain 122
2372,3340,2322, 2378,3337,2328, 2519,3338,2469, 
2371,3341,2321, 
8, // chain 123
2358,3342,2308, 2338,3343,2288, 2416,3344,2366, 
2521,3345,2471, 35290,3346,2472, 35183,3347,2365, 2414,3348,2364, 2523,3349,2473, 2524,3350,2474, 35293,3351,2475, 
7, // chain 124
2431,3352,2381, 2432,3353,2382, 2526,3354,2476, 
2201,3355,2151, 35295,3356,2477, 35296,3357,2478, 35297,3358,2479, 35197,3359,2379, 35200,3353,2382, 
17, // chain 125
2529,3358,2479, 2429,3359,2379, 2358,3342,2308, 
2530,3360,2480, 35289,3345,2471, 2531,3361,2481, 35290,3346,2472, 2524,3350,2474, 2532,3362,2482, 35301,3363,2483, 2534,3364,2484, 2535,3365,2485, 2528,3357,2478, 35295,3356,2477, 35304,3366,2486, 2426,3367,2376, 2424,3368,2374, 2425,3369,2375, 2201,3355,2151, 
3, // chain 126
2532,3362,2482, 2528,3357,2478, 2529,3358,2479, 
2530,3360,2480, 2531,3361,2481, 
9, // chain 127
2434,3370,2384, 2317,3371,2267, 2537,3372,2487, 
35306,3373,2488, 35307,3374,2489, 35086,3375,2268, 2540,3376,2490, 35206,3377,2388, 2433,3378,2383, 2537,3372,2487, 35202,3370,2384, 
2, // chain 128
2540,3376,2490, 2537,3372,2487, 2538,3373,2488, 
2539,3374,2489, 
18, // chain 129
2541,3379,2491, 2542,3380,2492, 2543,3381,2493, 
2418,3382,2368, 2360,3383,2310, 2359,3384,2309, 2542,3380,2492, 35312,3385,2494, 35138,3386,2320, 2361,3387,2311, 2545,3388,2495, 35314,3389,2496, 2547,3390,2497, 2548,3391,2498, 2544,3385,2494, 35317,3392,2499, 2550,3393,2500, 2542,3380,2492, 35319,3394,2501, 
2543,3381,2493, 
8, // chain 130
2546,3395,2496, 2361,3396,2311, 2362,3397,2312, 
2371,3398,2321, 2552,3399,2502, 35321,3400,2503, 35287,3401,2469, 2520,3402,2470, 2554,3403,2504, 2552,3399,2502, 
1, // chain 131
2547,3404,2497, 2546,3395,2496, 2552,3399,2502, 
10, // chain 132
2490,3405,2440, 2491,3406,2441, 2555,3407,2505, 
35324,3408,2506, 35265,3409,2447, 2557,3410,2507, 35264,3411,2446, 2558,3412,2508, 35258,3405,2440, 2555,3407,2505, 2556,3408,2506, 2557,3410,2507, 
1, // chain 133
2431,3413,2381, 2201,3414,2151, 2202,3415,2152, 
1, // chain 134
2429,3416,2379, 2357,3417,2307, 2358,3418,2308, 
2, // chain 135
2559,3419,2509, 2414,3420,2364, 2413,3421,2363, 
2560,3422,2510, 
3, // chain 136
2523,3423,2473, 2414,3420,2364, 2559,3419,2509, 
2561,3424,2511, 2525,3425,2475, 
6, // chain 137
2562,3426,2512, 2563,3427,2513, 2564,3428,2514, 
2565,3429,2515, 35334,3430,2516, 35335,3431,2517, 35336,3432,2518, 35331,3427,2513, 
9, // chain 138
2073,2813,2023, 2075,2817,2025, 2569,3433,2519, 
2570,3434,2520, 2072,2812,2022, 34839,2811,2021, 35339,3435,2521, 2572,3436,2522, 35341,3437,2523, 2076,2818,2026, 34843,2817,2025, 
14, // chain 139
2067,2807,2017, 2068,2808,2018, 2574,3438,2524, 
2575,3439,2525, 35344,3440,2526, 35345,3441,2527, 35346,3442,2528, 34836,2808,2018, 2579,3443,2529, 34837,2809,2019, 2070,2810,2020, 2071,2811,2021, 2572,3436,2522, 2078,2823,2028, 34845,2820,2027, 34844,2818,2026, 
9, // chain 140
2580,3444,2530, 2578,3442,2528, 2579,3443,2529, 
2078,2823,2028, 2079,2825,2029, 2578,3442,2528, 34848,2828,2030, 2581,3445,2531, 35345,3441,2527, 34849,2830,2031, 2582,3446,2532, 
1, // chain 141
2581,3445,2531, 2577,3441,2527, 2578,3442,2528, 
1, // chain 142
2576,3440,2526, 2583,3447,2533, 2575,3439,2525, 
1, // chain 143
2067,2807,2017, 2575,3439,2525, 2066,2806,2016, 
2, // chain 144
2037,2777,1987, 2038,2778,1988, 2065,2805,2015, 
2066,2806,2016, 
1, // chain 145
2031,2771,1981, 2584,3448,2534, 2030,2770,1980, 
6, // chain 146
2585,3449,2535, 2586,3450,2535, 2587,3451,2536, 
2588,3452,2537, 35357,3453,2538, 2590,3454,2539, 35359,3455,2540, 35094,3456,2541, 
12, // chain 147
2592,3457,2542, 2593,3458,2543, 2566,3430,2516, 
2594,3459,2544, 35363,3460,2545, 35335,3431,2517, 2596,3461,2546, 2597,3462,2547, 35366,3463,2548, 2599,3464,2549, 35368,3465,2550, 2601,3466,2551, 2143,3467,2093, 34916,3468,2098, 
3, // chain 148
2141,3469,2091, 2139,3470,2089, 2593,3458,2543, 
2592,3457,2542, 2143,3471,2093, 
4, // chain 149
2595,3460,2545, 2597,3462,2547, 2594,3459,2544, 
35367,3464,2549, 2143,3467,2093, 2592,3457,2542, 
3, // chain 150
2593,3458,2543, 2139,3470,2089, 2138,3472,2088, 
2565,3429,2515, 2566,3430,2516, 
2, // chain 151
2602,3473,2552, 2562,3426,2512, 2565,3429,2515, 
2603,3474,2553, 
13, // chain 152
1928,3475,1878, 1927,3476,1877, 2604,3477,2554, 
2605,3478,2555, 35374,3479,2556, 2607,3480,2557, 2608,3481,2558, 2609,3482,2559, 35378,3483,2560, 35379,3484,2561, 2612,3485,2562, 35381,3486,2563, 2614,3487,2564, 2615,3488,2565, 35384,3489,2566, 
4, // chain 153
2617,3490,2567, 1928,3475,1878, 2605,3478,2555, 
2618,3491,2568, 35387,3492,2569, 35377,3482,2559, 
5, // chain 154
2620,3493,2570, 2621,3494,2571, 2622,3495,2572, 
2623,3496,2573, 35392,3497,2574, 35382,3498,2564, 35384,3499,2566, 
31, // chain 155
2625,3500,2575, 2626,3501,2576, 2627,3502,2577, 
35396,3503,2578, 35397,3504,2579, 2630,3505,2580, 35399,3506,2581, 2632,3507,2582, 35401,3508,2583, 35393,3500,2575, 2634,3509,2584, 35395,3502,2577, 2635,3510,2585, 35396,3503,2578, 2611,3511,2561, 35381,3512,2563, 35382,3498,2564, 35398,3505,2580, 2624,3497,2574, 
35404,3513,2586, 35400,3507,2582, 2637,3514,2587, 35406,3515,2588, 35407,3516,2589, 35401,3508,2583, 2640,3517,2590, 35402,3509,2584, 2641,3518,2591, 35410,3519,2592, 35403,3510,2585, 2643,3520,2593, 35376,3521,2558, 35379,3511,2561, 
21, // chain 156
2604,3522,2554, 1927,3523,1877, 2644,3524,2594, 
35413,3525,2595, 35414,3526,2596, 35415,3527,2597, 34693,3528,1875, 2648,3529,2598, 34689,3530,1871, 1920,3531,1870, 2600,3532,2550, 2647,3527,2597, 35414,3526,2596, 35366,3533,2548, 2649,3534,2599, 35364,3535,2546, 2650,3536,2600, 35335,3537,2517, 2651,3538,2601, 
35336,3539,2518, 2652,3540,2602, 2641,3518,2591, 35408,3517,2590, 
6, // chain 157
2653,3541,2603, 2607,3542,2557, 2654,3543,2604, 
2655,3544,2605, 35412,3524,2594, 35375,3542,2557, 2606,3545,2556, 2604,3522,2554, 
2, // chain 158
2607,3542,2557, 2653,3541,2603, 2643,3520,2593, 
2608,3521,2558, 
3, // chain 159
2644,3524,2594, 2645,3525,2595, 2655,3544,2605, 
35417,3534,2599, 35414,3526,2596, 
9, // chain 160
2656,3546,2606, 2642,3519,2592, 2643,3520,2593, 
2653,3541,2603, 2657,3547,2607, 35423,3544,2605, 2649,3534,2599, 2650,3536,2600, 2658,3548,2608, 35409,3518,2591, 35419,3538,2601, 
3, // chain 161
2658,3548,2608, 2641,3518,2591, 2642,3519,2592, 
2656,3546,2606, 2657,3547,2607, 
1, // chain 162
2659,3549,2609, 2639,3516,2589, 2640,3517,2590, 
8, // chain 163
2637,3514,2587, 2638,3515,2588, 2660,3550,2610, 
2661,3551,2611, 35430,3552,2612, 2663,3553,2613, 2664,3554,2614, 2665,3555,2615, 2105,3556,2055, 34875,3557,2057, 
7, // chain 164
2666,3558,2616, 2623,3496,2573, 2637,3514,2587, 
2661,3551,2611, 2105,3556,2055, 2667,3559,2617, 34870,3560,2052, 2668,3561,2618, 34867,3562,2049, 
2, // chain 165
2636,3513,2586, 2637,3514,2587, 2623,3496,2573, 
2624,3497,2574, 
5, // chain 166
2621,3494,2571, 2620,3493,2570, 2669,3563,2619, 
35438,3564,2620, 35435,3559,2617, 35391,3496,2573, 2666,3558,2616, 
4, // chain 167
2671,3565,2621, 2621,3494,2571, 2669,3563,2619, 
2672,3566,2622, 35441,3567,2623, 35438,3564,2620, 
11, // chain 168
1916,3568,1866, 2674,3569,2624, 2675,3570,2625, 
2676,3571,2626, 35176,3572,2358, 35445,3573,2627, 35442,3569,2624, 2517,3574,2467, 35288,3575,2470, 35446,3576,2628, 34684,3568,1866, 1914,3577,1864, 1913,3578,1863, 
2, // chain 169
2517,3574,2467, 2516,3579,2466, 2677,3573,2627, 
35176,3572,2358, 
9, // chain 170
1902,3580,1852, 1903,3581,1853, 2679,3582,2629, 
1913,3583,1863, 35448,3584,2630, 35315,3585,2497, 2552,3586,2502, 2554,3587,2504, 1913,3583,1863, 35446,3588,2628, 35288,3589,2470, 
9, // chain 171
2681,3590,2631, 2682,3591,2632, 2683,3592,2633, 
2631,3593,2581, 35393,3594,2575, 35452,3595,2634, 35450,3591,2632, 2626,3596,2576, 35397,3597,2579, 35449,3590,2631, 2631,3593,2581, 
1, // chain 172
2625,3594,2575, 2684,3595,2634, 2626,3596,2576, 
9, // chain 173
2685,3598,2635, 2686,3599,2636, 2687,3600,2637, 
2571,3601,2521, 35341,3602,2523, 34843,3603,2025, 35456,3604,2638, 35454,3599,2636, 2570,3605,2520, 35453,3598,2635, 2571,3601,2521, 
2, // chain 174
2688,3604,2638, 2570,3605,2520, 2569,3606,2519, 
2075,3603,2025, 
5, // chain 175
1903,3607,1853, 2549,3608,2499, 2689,3609,2639, 
2679,3610,2629, 35315,3611,2497, 35316,3612,2498, 35317,3608,2499, 
11, // chain 176
2549,3608,2499, 1903,3607,1853, 1904,3613,1854, 
1897,3614,1847, 2690,3615,2640, 35459,3616,2641, 34666,3617,1848, 2418,3618,2368, 2543,3619,2493, 2690,3615,2640, 35319,3620,2501, 2550,3621,2500, 2549,3608,2499, 
2, // chain 177
2692,3622,2642, 2693,3623,2643, 2694,3624,2644, 
35463,3625,2645, 
3, // chain 178
2696,3626,2646, 2692,3622,2642, 2694,3624,2644, 
2559,3627,2509, 35329,3628,2511, 
2, // chain 179
2692,3622,2642, 2696,3626,2646, 2560,3629,2510, 
35327,3627,2509, 
1, // chain 180
2027,3630,1977, 2028,3631,1978, 2049,3632,1999, 
1, // chain 181
1894,3633,1844, 1893,3634,1843, 2047,3635,1997, 
20, // chain 182
2676,3636,2626, 2408,3637,2358, 2407,3638,2357, 
2697,3639,2647, 35466,3640,2648, 35177,3641,2359, 2699,3642,2649, 35174,3643,2356, 2148,3644,2098, 2700,3645,2650, 2701,3646,2651, 34916,3647,2098, 2601,3648,2551, 2600,3649,2550, 2698,3640,2648, 35465,3639,2647, 34688,3650,1870, 2676,3636,2626, 35470,3651,2652, 
34685,3652,1867, 1916,3653,1866, 2676,3636,2626, 
1, // chain 183
2701,3646,2651, 2698,3640,2648, 2699,3642,2649, 
1, // chain 184
2208,2961,2158, 2323,3088,2273, 2207,2960,2157, 
3, // chain 185
2104,2854,2054, 2106,2856,2056, 2297,3654,2247, 
2294,3655,2244, 2103,2853,2053, 
20, // chain 186
2703,3656,2653, 2704,3657,2654, 2705,3658,2655, 
2706,3659,2656, 35475,3660,2657, 35476,3661,2658, 35472,3657,2654, 2563,3662,2513, 35336,3663,2518, 35471,3656,2653, 2652,3664,2602, 35477,3665,2659, 35474,3659,2656, 2710,3666,2660, 35475,3660,2657, 2711,3667,2661, 2712,3668,2662, 2713,3669,2663, 2659,3670,2609, 
2640,3671,2590, 2709,3665,2659, 35420,3664,2602, 
3, // chain 187
1929,3672,1879, 1928,3475,1878, 2714,3673,2664, 
2715,3674,2665, 35484,3675,2666, 
22, // chain 188
2717,3676,2667, 2718,3677,2668, 2719,3678,2669, 
2720,3679,2670, 35489,3680,2671, 35352,3681,2534, 34798,3682,1980, 34797,3683,1979, 34796,3684,1978, 35486,3677,2668, 2049,3685,1999, 34816,3686,1998, 34815,3687,1997, 35490,3688,2672, 35485,3676,2667, 2723,3689,2673, 35488,3679,2670, 2724,3690,2674, 2725,3691,2675, 
2726,3692,2676, 2727,3693,2677, 35496,3694,2678, 35461,3695,2643, 35463,3696,2645, 
5, // chain 189
2722,3688,2672, 2723,3689,2673, 2729,3697,2679, 
1894,3698,1844, 35498,3699,2680, 35495,3693,2677, 35491,3689,2673, 
5, // chain 190
2730,3699,2680, 2727,3693,2677, 2728,3694,2678, 
2731,3700,2681, 35500,3701,2682, 35460,3702,2642, 35461,3695,2643, 
1, // chain 191
1894,3698,1844, 2047,3687,1997, 2722,3688,2672, 
2, // chain 192
1894,3698,1844, 2730,3699,2680, 2731,3700,2681, 
1895,3703,1845, 
12, // chain 193
2733,3704,2683, 2734,3705,2684, 2735,3706,2685, 
1898,3707,1848, 35186,3708,2368, 35502,3705,2684, 2412,3709,2362, 35181,3710,2363, 35328,3711,2510, 35504,3712,2686, 35501,3704,2683, 2731,3713,2681, 34663,3714,1845, 34666,3707,1848, 
3, // chain 194
2731,3713,2681, 2732,3715,2682, 2736,3712,2686, 
35460,3716,2642, 2560,3711,2510, 

 0};


// face array: 20kb.
const uint16_t nanosuit_6_face[10454] PROGMEM = {
36, // chain 0
2737,3717,2687, 2738,3718,2688, 2739,3719,2689, 
2740,3720,2690, 35509,3721,2691, 35510,3722,2692, 35511,3723,2693, 35512,3724,2694, 35513,3725,2695, 35514,3726,2696, 35506,3718,2688, 2747,3727,2697, 35516,3728,2698, 35517,3729,2699, 35505,3717,2687, 2750,3730,2700, 35508,3720,2690, 2751,3731,2701, 35520,3732,2702, 
35521,3733,2703, 35522,3734,2704, 35509,3721,2691, 2742,3722,2692, 2755,3735,2705, 35524,3736,2706, 35525,3737,2707, 35511,3723,2693, 2758,3738,2708, 35512,3724,2694, 2759,3739,2709, 35528,3740,2710, 35529,3741,2711, 35513,3725,2695, 2762,3742,2712, 35531,3743,2713, 
35532,3744,2714, 35515,3727,2697, 35514,3726,2696, 
47, // chain 1
2764,3744,2714, 2747,3727,2697, 2748,3728,2698, 
2765,3745,2715, 35534,3746,2716, 35535,3747,2717, 35536,3748,2718, 35517,3729,2699, 2769,3749,2719, 35538,3750,2720, 35539,3751,2721, 35518,3730,2700, 2751,3731,2701, 2772,3752,2722, 35541,3753,2723, 35520,3732,2702, 2774,3754,2724, 35543,3755,2725, 35521,3733,2703, 
2776,3756,2726, 35545,3757,2727, 35522,3734,2704, 2755,3735,2705, 2778,3758,2728, 35524,3736,2706, 2779,3759,2729, 35548,3760,2730, 35549,3761,2731, 35550,3762,2732, 35525,3737,2707, 2783,3763,2733, 35552,3764,2734, 35526,3738,2708, 2785,3765,2735, 35554,3766,2736, 
35527,3739,2709, 2787,3767,2737, 35528,3740,2710, 2788,3768,2738, 35557,3769,2739, 35558,3770,2740, 35529,3741,2711, 2791,3771,2741, 35530,3742,2712, 2792,3772,2742, 35531,3743,2713, 2793,3773,2743, 35533,3745,2715, 35532,3744,2714, 
18, // chain 2
2768,3748,2718, 2769,3749,2719, 2794,3774,2744, 
35538,3750,2720, 2771,3751,2721, 2795,3775,2745, 35540,3752,2722, 2796,3776,2746, 35565,3777,2747, 35566,3778,2748, 35541,3753,2723, 2799,3779,2749, 35542,3754,2724, 2800,3780,2750, 35569,3781,2751, 35543,3755,2725, 2776,3756,2726, 2802,3782,2752, 35546,3758,2728, 
35545,3757,2727, 
5, // chain 3
2803,3783,2753, 2768,3748,2718, 2794,3774,2744, 
2804,3784,2754, 35573,3785,2755, 35564,3776,2746, 35563,3775,2745, 
24, // chain 4
2806,3786,2756, 2804,3784,2754, 2807,3787,2757, 
2808,3788,2758, 35577,3789,2759, 35572,3784,2754, 2805,3785,2755, 2810,3790,2760, 35564,3776,2746, 2811,3791,2761, 35580,3792,2762, 35565,3777,2747, 2813,3793,2763, 35582,3794,2764, 35566,3778,2748, 2815,3795,2765, 35567,3779,2749, 2800,3780,2750, 2816,3796,2766, 
35585,3797,2767, 35586,3798,2768, 35569,3781,2751, 2819,3799,2769, 35570,3782,2752, 2779,3759,2729, 35546,3758,2728, 
8, // chain 5
2768,3748,2718, 2803,3783,2753, 2820,3800,2770, 
35589,3801,2771, 35572,3784,2754, 2806,3786,2756, 2822,3802,2772, 35591,3803,2773, 35592,3804,2774, 35576,3788,2758, 
3, // chain 6
2821,3801,2771, 2822,3802,2772, 2825,3805,2775, 
35594,3806,2776, 35591,3803,2773, 
12, // chain 7
2820,3800,2770, 2821,3801,2771, 2825,3805,2775, 
2767,3747,2717, 35595,3807,2777, 35594,3806,2776, 2828,3808,2778, 35597,3809,2779, 2830,3810,2780, 2831,3811,2781, 35600,3812,2782, 35601,3813,2783, 2834,3814,2784, 35603,3815,2785, 
3, // chain 8
2836,3816,2786, 2767,3747,2717, 2827,3807,2777, 
2831,3811,2781, 35596,3808,2778, 
13, // chain 9
2837,3817,2787, 2836,3816,2786, 2831,3811,2781, 
2832,3812,2782, 2834,3814,2784, 2838,3818,2788, 35607,3819,2789, 35608,3820,2790, 2841,3821,2791, 35610,3822,2792, 35611,3823,2793, 2844,3824,2794, 2845,3825,2795, 35614,3826,2796, 35615,3827,2797, 
11, // chain 10
2837,3817,2787, 2838,3818,2788, 2848,3828,2798, 
2836,3816,2786, 35617,3829,2799, 35618,3830,2800, 35619,3831,2801, 35620,3832,2802, 35606,3818,2788, 2853,3833,2803, 35622,3834,2804, 35609,3821,2791, 35607,3819,2789, 
4, // chain 11
2767,3747,2717, 2836,3816,2786, 2849,3829,2799, 
2766,3746,2716, 35623,3835,2805, 35618,3830,2800, 
9, // chain 12
2853,3833,2803, 2856,3836,2806, 2857,3837,2807, 
2858,3838,2808, 35623,3835,2805, 35534,3746,2716, 35533,3745,2715, 35624,3836,2806, 2793,3773,2743, 35622,3834,2804, 35621,3833,2803, 
1, // chain 13
2767,3747,2717, 2768,3748,2718, 2820,3800,2770, 
4, // chain 14
2859,3839,2809, 2793,3773,2743, 2854,3834,2804, 
2845,3825,2795, 35610,3822,2792, 35609,3821,2791, 
3, // chain 15
2853,3833,2803, 2858,3838,2808, 2860,3840,2810, 
2852,3832,2802, 35619,3831,2801, 
3, // chain 16
2859,3839,2809, 2845,3825,2795, 2861,3841,2811, 
35614,3826,2796, 2862,3842,2812, 
12, // chain 17
2863,3843,2813, 2864,3844,2814, 2865,3845,2815, 
2861,3841,2811, 35560,3772,2742, 35559,3771,2741, 35634,3846,2816, 35632,3844,2814, 2867,3847,2817, 2868,3848,2818, 35637,3849,2819, 2870,3850,2820, 35639,3851,2821, 35640,3852,2822, 
2, // chain 18
2861,3841,2811, 2792,3772,2742, 2859,3839,2809, 
35561,3773,2743, 
3, // chain 19
2789,3769,2739, 2790,3770,2740, 2791,3771,2741, 
2868,3848,2818, 35634,3846,2816, 
9, // chain 20
2789,3769,2739, 2868,3848,2818, 2873,3853,2823, 
35638,3850,2820, 2874,3854,2824, 35643,3855,2825, 35644,3856,2826, 35639,3851,2821, 2877,3857,2827, 35646,3858,2828, 35647,3859,2829, 
14, // chain 21
2788,3768,2738, 2789,3769,2739, 2873,3853,2823, 
2874,3854,2824, 2880,3860,2830, 35643,3855,2825, 2881,3861,2831, 35650,3862,2832, 35644,3856,2826, 2877,3857,2827, 2883,3863,2833, 35652,3864,2834, 35646,3858,2828, 2885,3865,2835, 2886,3866,2836, 35655,3867,2837, 
12, // chain 22
2888,3868,2838, 2889,3869,2839, 2880,3860,2830, 
2890,3870,2840, 35649,3861,2831, 2891,3871,2841, 35660,3872,2842, 35650,3862,2832, 2893,3873,2843, 35651,3863,2833, 2894,3874,2844, 35663,3875,2845, 35654,3866,2836, 35652,3864,2834, 
11, // chain 23
2889,3869,2839, 2888,3868,2838, 2896,3876,2846, 
35665,3877,2847, 35658,3870,2840, 2891,3871,2841, 2898,3878,2848, 35667,3879,2849, 35668,3880,2850, 35660,3872,2842, 2901,3881,2851, 35662,3874,2844, 35661,3873,2843, 
22, // chain 24
2889,3869,2839, 2896,3876,2846, 2902,3882,2852, 
2788,3768,2738, 35555,3767,2737, 35671,3883,2853, 35672,3884,2854, 35664,3876,2846, 2897,3877,2847, 2898,3878,2848, 2905,3885,2855, 35674,3886,2856, 35675,3887,2857, 35676,3888,2858, 35667,3879,2849, 2900,3880,2850, 2909,3889,2859, 35669,3881,2851, 2910,3890,2860, 
35662,3874,2844, 2911,3891,2861, 35680,3892,2862, 35663,3875,2845, 2886,3866,2836, 
7, // chain 25
2786,3766,2736, 2787,3767,2737, 2903,3883,2853, 
2913,3893,2863, 35682,3894,2864, 35683,3895,2865, 35684,3896,2866, 35673,3885,2855, 35672,3884,2854, 
17, // chain 26
2905,3885,2855, 2906,3886,2856, 2916,3896,2866, 
35685,3897,2867, 35675,3887,2857, 2824,3898,2774, 35686,3899,2868, 35676,3888,2858, 2909,3889,2859, 2919,3900,2869, 35678,3890,2860, 2823,3901,2773, 35594,3902,2776, 35679,3891,2861, 2829,3903,2779, 35680,3892,2862, 2830,3904,2780, 35601,3905,2783, 35603,3906,2785, 
1, // chain 27
2788,3768,2738, 2880,3860,2830, 2889,3869,2839, 
5, // chain 28
2809,3907,2759, 2920,3908,2870, 2915,3895,2865, 
2808,3909,2758, 35689,3910,2871, 35685,3897,2867, 35684,3896,2866, 
2, // chain 29
2921,3910,2871, 2917,3897,2867, 2824,3898,2774, 
2808,3909,2758, 
2, // chain 30
2824,3898,2774, 2918,3899,2868, 2823,3901,2773, 
35687,3900,2869, 
42, // chain 31
2922,3911,2872, 2923,3912,2873, 2924,3913,2874, 
2925,3914,2875, 35694,3915,2876, 35695,3916,2877, 2928,3917,2878, 35697,3918,2879, 35698,3919,2880, 2931,3920,2881, 35700,3921,2882, 2933,3922,2883, 35702,3923,2884, 35703,3924,2885, 2936,3925,2886, 2937,3926,2887, 35706,3927,2888, 2939,3928,2889, 35708,3929,2890, 
2941,3930,2891, 2942,3931,2892, 35711,3932,2893, 35712,3933,2894, 2945,3934,2895, 35714,3935,2896, 2947,3936,2897, 2948,3937,2898, 35717,3938,2899, 2950,3939,2900, 35719,3940,2901, 2952,3941,2902, 2953,3942,2903, 35722,3943,2904, 35723,3944,2905, 2956,3945,2906, 
35725,3946,2907, 2958,3947,2908, 2959,3948,2909, 2960,3949,2910, 35729,3950,2911, 2962,3951,2912, 35731,3952,2913, 35732,3953,2914, 35733,3954,2915, 
11, // chain 32
2929,3918,2879, 2931,3920,2881, 2966,3955,2916, 
2928,3917,2878, 35735,3956,2917, 35736,3957,2918, 35737,3958,2919, 35738,3959,2920, 35699,3920,2881, 2939,3928,2889, 35705,3926,2887, 35701,3922,2883, 2934,3923,2884, 
50, // chain 33
2971,3960,2921, 2967,3956,2917, 2968,3957,2918, 
2972,3961,2922, 35741,3962,2923, 35742,3963,2924, 35737,3958,2919, 2975,3964,2925, 35738,3959,2920, 2939,3928,2889, 2942,3931,2892, 2976,3965,2926, 35745,3966,2927, 35711,3932,2893, 2978,3967,2928, 35713,3934,2895, 2979,3968,2929, 35716,3937,2898, 2950,3939,2900, 
2980,3969,2930, 35749,3970,2931, 35721,3942,2903, 2982,3971,2932, 35751,3972,2933, 35722,3943,2904, 2956,3945,2906, 2960,3949,2910, 2962,3951,2912, 2984,3973,2934, 35731,3952,2913, 2985,3974,2935, 35732,3953,2914, 2986,3975,2936, 35755,3976,2937, 2988,3977,2938, 
2989,3978,2939, 2990,3979,2940, 35759,3980,2941, 2992,3981,2942, 2993,3982,2943, 35762,3983,2944, 2995,3984,2945, 35764,3985,2946, 2997,3986,2947, 2998,3987,2948, 35767,3988,2949, 35768,3989,2950, 3001,3990,2951, 3002,3991,2952, 35771,3992,2953, 35772,3993,2954, 
35773,3994,2955, 
8, // chain 34
2975,3964,2925, 2976,3965,2926, 3006,3995,2956, 
35775,3996,2957, 35745,3966,2927, 3008,3997,2958, 35777,3998,2959, 35746,3967,2928, 2980,3969,2930, 35747,3968,2929, 
10, // chain 35
3010,3999,2960, 3011,4000,2961, 2972,3961,2922, 
3012,4001,2962, 35741,3962,2923, 3013,4002,2963, 35782,4003,2964, 35783,4004,2965, 35784,4005,2966, 35742,3963,2924, 3006,3995,2956, 35743,3964,2925, 
7, // chain 36
3017,4006,2967, 3008,3997,2958, 3009,3998,2959, 
3018,4007,2968, 35748,3969,2930, 2981,3970,2931, 2982,3971,2932, 2984,3973,2934, 35751,3972,2933, 
32, // chain 37
3016,4005,2966, 3006,3995,2956, 3007,3996,2957, 
3019,4008,2969, 35776,3997,2958, 3017,4006,2967, 3020,4009,2970, 35786,4007,2968, 2984,3973,2934, 3021,4010,2971, 35790,4011,2972, 35753,3974,2935, 3023,4012,2973, 35792,4013,2974, 35754,3975,2936, 2990,3979,2940, 3025,4014,2975, 35794,4015,2976, 35761,3982,2943, 
3027,4016,2977, 35796,4017,2978, 35797,4018,2979, 35763,3984,2945, 3030,4019,2980, 35766,3987,2948, 3031,4020,2981, 35767,3988,2949, 3032,4021,2982, 35770,3991,2952, 3033,4022,2983, 35802,4023,2984, 35803,4024,2985, 35804,4025,2986, 35771,3992,2953, 
11, // chain 38
3019,4008,2969, 3020,4009,2970, 3021,4010,2971, 
3037,4026,2987, 35806,4027,2988, 35790,4011,2972, 3023,4012,2973, 3039,4028,2989, 35808,4029,2990, 35792,4013,2974, 3025,4014,2975, 3027,4016,2977, 35794,4015,2976, 
19, // chain 39
3041,4030,2991, 3012,4001,2962, 3013,4002,2963, 
3042,4031,2992, 35811,4032,2993, 35782,4003,2964, 3044,4033,2994, 35783,4004,2965, 3045,4034,2995, 35814,4035,2996, 35815,4036,2997, 35784,4005,2966, 3019,4008,2969, 3037,4026,2987, 3038,4027,2988, 3046,4035,2996, 35807,4028,2989, 3048,4037,2998, 35817,4038,2999, 
35795,4016,2977, 35808,4029,2990, 
12, // chain 40
3044,4033,2994, 3050,4039,3000, 3051,4040,3001, 
3052,4041,3002, 35821,4042,3003, 35822,4043,3004, 35823,4044,3005, 35797,4018,2979, 35824,4045,3006, 35818,4039,3000, 3057,4046,3007, 35826,4047,3008, 35813,4034,2995, 35812,4033,2994, 
7, // chain 41
3041,4030,2991, 3042,4031,2992, 3059,4048,3009, 
3060,4049,3010, 35829,4050,3011, 35830,4051,3012, 35831,4052,3013, 35811,4032,2993, 35810,4031,2992, 
13, // chain 42
3064,4053,3014, 3063,4052,3013, 3043,4032,2993, 
3044,4033,2994, 3052,4041,3002, 3065,4054,3015, 35834,4055,3016, 35821,4042,3003, 3067,4056,3017, 35836,4057,3018, 35822,4043,3004, 3031,4020,2981, 35798,4019,2980, 35823,4044,3005, 3029,4018,2979, 
4, // chain 43
3069,4058,3019, 3063,4052,3013, 3065,4054,3015, 
3070,4059,3020, 35835,4056,3017, 35834,4055,3016, 
1, // chain 44
3063,4052,3013, 3064,4053,3014, 3065,4054,3015, 
23, // chain 45
3010,3999,2960, 3012,4001,2962, 3041,4030,2991, 
3071,4060,3021, 35828,4049,3010, 3072,4061,3022, 35841,4062,3023, 35842,4063,3024, 35829,4050,3011, 3075,4064,3025, 35844,4065,3026, 3077,4066,3027, 35846,4067,3028, 3079,4068,3029, 3080,4069,3030, 35837,4058,3019, 3070,4059,3020, 3081,4070,3031, 35850,4071,3032, 
35851,4072,3033, 35835,4056,3017, 3033,4022,2983, 35800,4021,2982, 35836,4057,3018, 3031,4020,2981, 
1, // chain 46
3069,4058,3019, 3062,4051,3012, 3063,4052,3013, 
23, // chain 47
3084,4073,3034, 3085,4074,3035, 3086,4075,3036, 
3087,4076,3037, 35856,4077,3038, 35857,4078,3039, 35853,4074,3035, 3090,4079,3040, 35843,4064,3025, 35841,4062,3023, 35859,4080,3041, 35852,4073,3034, 3092,4081,3042, 35855,4076,3037, 3093,4082,3043, 35856,4077,3038, 3094,4083,3044, 35857,4078,3039, 3095,4084,3045, 
35858,4079,3040, 3096,4085,3046, 35843,4064,3025, 3077,4066,3027, 3081,4070,3031, 35848,4069,3030, 
5, // chain 48
3071,4060,3021, 3072,4061,3022, 3097,4086,3047, 
35866,4087,3048, 35867,4088,3049, 35859,4080,3041, 35841,4062,3023, 
11, // chain 49
3071,4060,3021, 3097,4086,3047, 3011,4000,2961, 
35868,4089,3050, 35869,4090,3051, 35866,4087,3048, 3102,4091,3052, 35867,4088,3049, 3103,4092,3053, 35872,4093,3054, 35873,4094,3055, 35860,4081,3042, 35859,4080,3041, 
1, // chain 50
3011,4000,2961, 3010,3999,2960, 3071,4060,3021, 
10, // chain 51
3011,4000,2961, 3100,4089,3050, 3106,4095,3056, 
2972,3961,2922, 35739,3960,2921, 35735,3956,2917, 35875,4096,3057, 35868,4089,3050, 3108,4097,3058, 35869,4090,3051, 3109,4098,3059, 35870,4091,3052, 
17, // chain 52
3105,4094,3055, 3092,4081,3042, 3093,4082,3043, 
3110,4099,3060, 35879,4100,3061, 35862,4083,3044, 3112,4101,3062, 35881,4102,3063, 35882,4103,3064, 35883,4104,3065, 35863,4084,3045, 3116,4105,3066, 35864,4085,3046, 3117,4106,3067, 35849,4070,3031, 3082,4071,3032, 3118,4107,3068, 35801,4022,2983, 35851,4072,3033, 
5, // chain 53
2928,3917,2878, 2967,3956,2917, 3107,4096,3057, 
3108,4097,3058, 2926,3915,2876, 35887,4108,3069, 35877,4098,3059, 
5, // chain 54
3120,4109,3070, 3121,4110,3071, 3122,4111,3072, 
3104,4093,3054, 35891,4112,3073, 35892,4113,3074, 35893,4114,3075, 
1, // chain 55
3104,4093,3054, 3123,4112,3073, 3103,4092,3053, 
3, // chain 56
3104,4093,3054, 3105,4094,3055, 3120,4109,3070, 
35878,4099,3060, 3121,4110,3071, 
1, // chain 57
3123,4112,3073, 3124,4113,3074, 3126,4115,3076, 
4, // chain 58
3127,4116,3077, 3128,4117,3078, 2947,4118,2897, 
2946,4119,2896, 3129,4120,3079, 35712,4121,2894, 
3, // chain 59
3128,4117,3078, 3127,4116,3077, 3130,4122,3080, 
35899,4123,3081, 35897,4120,3079, 
13, // chain 60
2936,4124,2886, 3132,4125,3082, 3133,4126,3083, 
35902,4127,3084, 35903,4128,3085, 3136,4129,3086, 35896,4117,3078, 3137,4130,3087, 35898,4122,3080, 3131,4123,3081, 3138,4131,3088, 35907,4132,3089, 35897,4133,3079, 2941,4134,2891, 35712,4135,2894, 
2, // chain 61
3139,4132,3089, 2941,4134,2891, 3140,4136,3090, 
3138,4131,3088, 
3, // chain 62
3133,4126,3083, 3134,4127,3084, 3138,4131,3088, 
35904,4129,3086, 3137,4130,3087, 
5, // chain 63
3141,4137,3091, 3142,4138,3092, 3143,4139,3093, 
3144,4140,3094, 35913,4141,3095, 35691,4142,2873, 35910,4138,3092, 
11, // chain 64
2923,4142,2873, 3146,4143,3096, 3147,4144,3097, 
3145,4141,3095, 35916,4145,3098, 35917,4146,3099, 35918,4147,3100, 35914,4143,3096, 3151,4148,3101, 35920,4149,3102, 35693,4150,2875, 35690,4151,2872, 35691,4142,2873, 
23, // chain 65
3150,4147,3100, 3151,4148,3101, 3153,4152,3103, 
35922,4153,3104, 35923,4154,3105, 35920,4149,3102, 3156,4155,3106, 35925,4156,3107, 35693,4150,2875, 2926,4157,2876, 3119,4158,3069, 3156,4155,3106, 35926,4159,3108, 35877,4160,3059, 3102,4161,3052, 3155,4154,3105, 35871,4162,3053, 3154,4153,3104, 35921,4152,3103, 
35927,4163,3109, 35891,4164,3073, 3160,4165,3110, 35894,4166,3076, 3161,4167,3111, 35930,4168,3112, 
1, // chain 66
3158,4159,3108, 3155,4154,3105, 3156,4155,3106, 
6, // chain 67
3163,4169,3113, 2936,4170,2886, 2935,4171,2885, 
3164,4172,3114, 35933,4173,3115, 35934,4174,3116, 35698,4175,2880, 35700,4176,2882, 
11, // chain 68
3167,4177,3117, 3163,4169,3113, 3164,4172,3114, 
3168,4178,3118, 35937,4179,3119, 35938,4180,3120, 35933,4173,3115, 3171,4181,3121, 35934,4174,3116, 3172,4182,3122, 35692,4183,2874, 35698,4175,2880, 2927,4184,2877, 
10, // chain 69
2924,4183,2874, 2923,4185,2873, 3172,4182,3122, 
35910,4186,3092, 3173,4187,3123, 35942,4188,3124, 35909,4189,3091, 3175,4190,3125, 35944,4191,3126, 35945,4192,3127, 35946,4193,3128, 35912,4194,3094, 
11, // chain 70
3173,4187,3123, 3174,4188,3124, 3175,4190,3125, 
3171,4181,3121, 35947,4195,3129, 35948,4196,3130, 35949,4197,3131, 35944,4191,3126, 3182,4198,3132, 35951,4199,3133, 35945,4192,3127, 3184,4200,3134, 35946,4193,3128, 
1, // chain 71
3171,4181,3121, 3172,4182,3122, 3173,4187,3123, 
41, // chain 72
3185,4201,3135, 3186,4202,3136, 3187,4203,3137, 
3188,4204,3138, 35957,4205,3139, 35958,4206,3140, 35959,4207,3141, 35960,4208,3142, 35961,4209,3143, 35954,4202,3136, 3194,4210,3144, 35963,4211,3145, 35938,4180,3120, 35937,4179,3119, 35953,4201,3135, 3196,4212,3146, 35956,4204,3138, 3197,4213,3147, 35957,4205,3139, 
3198,4214,3148, 35967,4215,3149, 35958,4206,3140, 3200,4216,3150, 35969,4217,3151, 35970,4218,3152, 35971,4219,3153, 35959,4207,3141, 3204,4220,3154, 35973,4221,3155, 35974,4222,3156, 35960,4208,3142, 3207,4223,3157, 35976,4224,3158, 35950,4198,3132, 35977,4225,3159, 
35961,4209,3143, 3210,4226,3160, 35962,4210,3144, 3211,4227,3161, 35947,4195,3129, 35963,4211,3145, 3171,4181,3121, 35938,4180,3120, 
108, // chain 73
3208,4224,3158, 3182,4198,3132, 3183,4199,3133, 
3212,4228,3162, 35952,4200,3134, 3213,4229,3163, 3214,4230,3164, 3208,4224,3158, 35975,4223,3157, 35983,4231,3165, 35984,4232,3166, 3217,4233,3167, 35986,4234,3168, 3219,4235,3169, 3220,4236,3170, 35989,4237,3171, 3222,4238,3172, 35991,4239,3173, 35992,4240,3174, 
35993,4241,3175, 3226,4242,3176, 35995,4243,3177, 3228,4244,3178, 35997,4245,3179, 3230,4246,3180, 35999,4247,3181, 3232,4248,3182, 36001,4249,3183, 3234,4250,3184, 3235,4251,3185, 36004,4252,3186, 3237,4253,3187, 36006,4254,3188, 36007,4255,3189, 3240,4256,3190, 
36009,4257,3191, 3242,4258,3192, 36011,4259,3193, 36012,4260,3194, 3245,4261,3195, 3246,4262,3196, 36008,4256,3190, 36015,4263,3197, 36016,4264,3198, 36017,4265,3199, 36018,4266,3200, 3251,4267,3201, 36020,4268,3202, 36021,4269,3203, 3254,4270,3204, 36023,4271,3205, 
36024,4272,3206, 3257,4273,3207, 36026,4274,3208, 36027,4275,3209, 36028,4276,3210, 3258,4274,3208, 36029,4277,3211, 36030,4278,3212, 36031,4279,3213, 3261,4277,3211, 36032,4280,3214, 36033,4281,3215, 3266,4282,3216, 36035,4283,3217, 36036,4284,3218, 3269,4285,3219, 
36038,4286,3220, 36039,4287,3221, 3272,4288,3222, 36041,4289,3223, 36042,4290,3224, 3275,4291,3225, 36044,4292,3226, 36045,4293,3227, 3278,4294,3228, 36047,4295,3229, 36048,4296,3230, 3281,4297,3231, 36050,4298,3232, 36051,4299,3233, 36052,4300,3234, 3285,4301,3235, 
36054,4302,3236, 36055,4303,3237, 36056,4304,3238, 36057,4305,3239, 3290,4306,3240, 36059,4307,3241, 36060,4308,3242, 36061,4309,3243, 36062,4310,3244, 36063,4311,3245, 3296,4312,3246, 36065,4313,3247, 36066,4314,3248, 3299,4315,3249, 36068,4316,3250, 36069,4317,3251, 
3302,4318,3252, 36071,4319,3253, 36072,4320,3254, 3305,4321,3255, 36074,4322,3256, 36075,4323,3257, 3308,4324,3258, 36077,4325,3259, 3310,4326,3260, 36079,4327,3261, 36080,4328,3262, 
3, // chain 74
3181,4197,3131, 3182,4198,3132, 3209,4225,3159, 
3313,4329,3263, 35978,4226,3160, 
5, // chain 75
3314,4330,3264, 3211,4227,3161, 3179,4195,3129, 
3180,4196,3130, 3315,4331,3265, 35949,4197,3131, 3313,4329,3263, 
4, // chain 76
3207,4223,3157, 3215,4231,3165, 3316,4332,3266, 
35985,4233,3167, 3222,4238,3172, 35988,4236,3170, 
16, // chain 77
3206,4222,3156, 3207,4223,3157, 3316,4332,3266, 
3205,4221,3155, 35990,4238,3172, 3204,4220,3154, 35991,4239,3173, 3317,4333,3267, 35992,4240,3174, 3226,4242,3176, 3318,4334,3268, 35996,4244,3178, 3319,4335,3269, 36088,4336,3270, 36089,4337,3271, 35998,4246,3180, 3235,4251,3185, 36000,4248,3182, 
13, // chain 78
3202,4218,3152, 3203,4219,3153, 3204,4220,3154, 
3201,4217,3151, 36090,4338,3272, 36085,4333,3267, 3323,4339,3273, 36092,4340,3274, 36086,4334,3268, 3319,4335,3269, 3325,4341,3275, 36088,4336,3270, 3326,4342,3276, 36003,4251,3185, 36089,4337,3271, 
5, // chain 79
3168,4178,3118, 3169,4179,3119, 3196,4212,3146, 
3327,4343,3277, 36096,4344,3278, 35966,4214,3148, 35965,4213,3147, 
6, // chain 80
3329,4345,3279, 3163,4169,3113, 3167,4177,3117, 
3330,4346,3280, 36099,4347,3281, 36100,4348,3282, 36095,4343,3277, 35936,4178,3118, 
15, // chain 81
3333,4349,3283, 3332,4348,3282, 3327,4343,3277, 
3328,4344,3278, 3334,4350,3284, 36103,4351,3285, 36104,4352,3286, 35966,4214,3148, 3337,4353,3287, 36106,4354,3288, 36107,4355,3289, 35967,4215,3149, 3200,4216,3150, 3340,4356,3290, 35969,4217,3151, 3323,4339,3273, 36090,4338,3272, 
46, // chain 82
3331,4347,3281, 3332,4348,3282, 3333,4349,3283, 
3341,4357,3291, 36110,4358,3292, 36102,4350,3284, 3343,4359,3293, 36103,4351,3285, 3344,4360,3294, 36113,4361,3295, 36114,4362,3296, 36104,4352,3286, 3337,4353,3287, 3347,4363,3297, 36116,4364,3298, 36117,4365,3299, 36106,4354,3288, 3339,4355,3289, 3350,4366,3300, 
36119,4367,3301, 36108,4356,3290, 3352,4368,3302, 36091,4339,3273, 3353,4369,3303, 36092,4340,3274, 3325,4341,3275, 3354,4370,3304, 36123,4371,3305, 36094,4342,3276, 3356,4372,3306, 36125,4373,3307, 36126,4374,3308, 36003,4251,3185, 3237,4253,3187, 3238,4254,3188, 
3359,4375,3309, 36008,4256,3190, 3360,4376,3310, 36015,4263,3197, 3361,4377,3311, 36016,4264,3198, 3362,4378,3312, 36017,4265,3199, 3251,4267,3201, 3257,4273,3207, 36020,4268,3202, 3254,4270,3204, 3255,4271,3205, 
40, // chain 83
3363,4379,3313, 3364,4380,3314, 3341,4357,3291, 
3342,4358,3292, 3365,4381,3315, 36111,4359,3293, 3366,4382,3316, 36112,4360,3294, 3367,4383,3317, 36113,4361,3295, 3368,4384,3318, 36137,4385,3319, 36138,4386,3320, 36114,4362,3296, 3371,4387,3321, 36115,4363,3297, 3372,4388,3322, 36141,4389,3323, 36142,4390,3324, 
36143,4391,3325, 36116,4364,3298, 3376,4392,3326, 36117,4365,3299, 3350,4366,3300, 3377,4393,3327, 36146,4394,3328, 36119,4367,3301, 3379,4395,3329, 36120,4368,3302, 3380,4396,3330, 36121,4369,3303, 3354,4370,3304, 3381,4397,3331, 36150,4398,3332, 36123,4371,3305, 
3356,4372,3306, 3357,4373,3307, 3383,4399,3333, 36152,4400,3334, 36128,4376,3310, 36127,4375,3309, 36126,4374,3308, 
38, // chain 84
3364,4380,3314, 3363,4379,3313, 3385,4401,3335, 
3386,4402,3336, 36155,4403,3337, 36156,4404,3338, 36131,4379,3313, 3365,4381,3315, 3389,4405,3339, 36158,4406,3340, 36159,4407,3341, 36160,4408,3342, 36134,4382,3316, 3393,4409,3343, 36135,4383,3317, 3368,4384,3318, 3394,4410,3344, 36163,4411,3345, 36137,4385,3319, 
3396,4412,3346, 36165,4413,3347, 36166,4414,3348, 36138,4386,3320, 3399,4415,3349, 36139,4387,3321, 3400,4416,3350, 36140,4388,3322, 3401,4417,3351, 36170,4418,3352, 36141,4389,3323, 3403,4419,3353, 36172,4420,3354, 36173,4421,3355, 36174,4422,3356, 36142,4390,3324, 
3407,4423,3357, 36176,4424,3358, 36143,4391,3325, 3377,4393,3327, 36144,4392,3326, 
37, // chain 85
3409,4425,3359, 3341,4357,3291, 3364,4380,3314, 
3386,4402,3336, 3410,4426,3360, 36155,4403,3337, 3411,4427,3361, 36180,4428,3362, 36156,4404,3338, 3389,4405,3339, 3413,4429,3363, 36158,4406,3340, 3414,4430,3364, 36159,4407,3341, 3415,4431,3365, 35987,4432,3169, 35989,4433,3171, 35993,4434,3175, 36184,4435,3366, 
36160,4408,3342, 3393,4409,3343, 3417,4436,3367, 36162,4410,3344, 3418,4437,3368, 36187,4438,3369, 36188,4439,3370, 36163,4411,3345, 3396,4412,3346, 3311,4327,3261, 36165,4413,3347, 3310,4326,3260, 36166,4414,3348, 3421,4440,3371, 36190,4441,3372, 36191,4442,3373, 
36167,4415,3349, 3424,4443,3374, 36169,4417,3351, 36168,4416,3350, 
18, // chain 86
3331,4347,3281, 3341,4357,3291, 3425,4444,3375, 
36194,4445,3376, 36177,4425,3359, 3427,4446,3377, 36196,4447,3378, 36178,4426,3360, 3411,4427,3361, 3429,4448,3379, 36198,4449,3380, 36199,4450,3381, 36180,4428,3362, 3432,4451,3382, 36201,4452,3383, 36181,4429,3363, 3414,4430,3364, 3218,4453,3168, 36183,4431,3365, 
3219,4432,3169, 
15, // chain 87
3330,4346,3280, 3331,4347,3281, 3425,4444,3375, 
3434,4454,3384, 36194,4445,3376, 3427,4446,3377, 3435,4455,3385, 36204,4456,3386, 36196,4447,3378, 3429,4448,3379, 3437,4457,3387, 36206,4458,3388, 36207,4459,3389, 36198,4449,3380, 3440,4460,3390, 36200,4451,3382, 36199,4450,3381, 
33, // chain 88
3163,4169,3113, 3329,4345,3279, 3132,4461,3082, 
35903,4462,3085, 36098,4346,3280, 3128,4463,3078, 36202,4454,3384, 2949,4464,2899, 36203,4455,3385, 3441,4465,3391, 36204,4456,3386, 3442,4466,3392, 36205,4457,3387, 3438,4458,3388, 3443,4467,3393, 36212,4468,3394, 36213,4469,3395, 36214,4470,3396, 36207,4459,3389, 
3440,4460,3390, 3447,4471,3397, 36216,4472,3398, 36200,4451,3382, 3433,4452,3383, 3218,4453,3168, 3216,4473,3166, 3447,4471,3397, 36214,4470,3396, 35982,4474,3164, 3445,4469,3395, 35981,4475,3163, 3444,4468,3394, 35952,4476,3134, 3178,4477,3128, 3144,4478,3094, 
6, // chain 89
2952,4479,2902, 2949,4464,2899, 3441,4465,3391, 
3449,4480,3399, 36210,4466,3392, 3450,4481,3400, 36211,4467,3393, 3444,4468,3394, 
1, // chain 90
3132,4461,3082, 2936,4170,2886, 3163,4169,3113, 
1, // chain 91
3128,4463,3078, 2949,4464,2899, 2947,4482,2897, 
1, // chain 92
2949,4464,2899, 2952,4479,2902, 2951,4483,2901, 
3, // chain 93
2955,4484,2905, 2952,4479,2902, 3449,4480,3399, 
3450,4481,3400, 2957,4485,2907, 
7, // chain 94
3227,4486,3177, 3225,4434,3175, 3416,4435,3366, 
3417,4436,3367, 3229,4487,3179, 35999,4488,3181, 36186,4437,3368, 3233,4489,3183, 36187,4438,3369, 
2, // chain 95
3451,4490,3401, 3419,4438,3369, 3420,4439,3370, 
3311,4327,3261, 
7, // chain 96
3408,4424,3358, 3377,4393,3327, 3452,4491,3402, 
3407,4423,3357, 36221,4492,3403, 36149,4397,3331, 36147,4395,3329, 36146,4394,3328, 36145,4393,3327, 
5, // chain 97
3454,4493,3404, 3401,4417,3351, 3455,4494,3405, 
3456,4495,3406, 36225,4496,3407, 36170,4418,3352, 36169,4417,3351, 
5, // chain 98
3424,4443,3374, 3401,4417,3351, 3458,4497,3408, 
3459,4498,3409, 36228,4499,3410, 36222,4493,3404, 36169,4417,3351, 
8, // chain 99
3461,4500,3411, 3456,4495,3406, 3462,4501,3412, 
3278,4294,3228, 36044,4292,3226, 36043,4291,3225, 36231,4502,3413, 36232,4503,3414, 36225,4496,3407, 36224,4495,3406, 
6, // chain 100
3454,4493,3404, 3456,4495,3406, 3465,4504,3415, 
36050,4298,3232, 36229,4500,3411, 3281,4297,3231, 36047,4295,3229, 36046,4294,3228, 
6, // chain 101
3454,4493,3404, 3465,4504,3415, 3460,4499,3410, 
36055,4303,3237, 36054,4302,3236, 36053,4301,3235, 36051,4299,3233, 36050,4298,3232, 
8, // chain 102
3423,4442,3373, 3424,4443,3374, 3459,4498,3409, 
3422,4441,3372, 36234,4505,3416, 36235,4506,3417, 36228,4499,3410, 3290,4306,3240, 36056,4304,3238, 36055,4303,3237, 
13, // chain 103
3422,4441,3372, 3466,4505,3416, 3468,4507,3418, 
3302,4318,3252, 36068,4316,3250, 36067,4315,3249, 36234,4505,3416, 3297,4313,3247, 36064,4312,3246, 36237,4508,3419, 36235,4506,3417, 3293,4309,3243, 36060,4308,3242, 36059,4307,3241, 36058,4306,3240, 
2, // chain 104
3464,4503,3414, 3457,4496,3407, 3403,4419,3353, 
36170,4418,3352, 
6, // chain 105
3464,4503,3414, 3470,4509,3420, 3269,4285,3219, 
3270,4286,3220, 3272,4288,3222, 3463,4502,3413, 36041,4289,3223, 3275,4291,3225, 
2, // chain 106
3266,4282,3216, 3267,4283,3217, 3470,4509,3420, 
36037,4285,3219, 
4, // chain 107
3264,4280,3214, 3266,4282,3216, 3470,4509,3420, 
3404,4420,3354, 36171,4419,3353, 36232,4503,3414, 
6, // chain 108
3264,4280,3214, 3404,4420,3354, 3405,4421,3355, 
3471,4510,3421, 36240,4511,3422, 36174,4422,3356, 3453,4492,3403, 36175,4423,3357, 
7, // chain 109
3261,4277,3211, 3264,4280,3214, 3471,4510,3421, 
3384,4400,3334, 36240,4511,3422, 3383,4399,3333, 36221,4492,3403, 3381,4397,3331, 3382,4398,3332, 
5, // chain 110
3258,4274,3208, 3261,4277,3211, 3257,4273,3207, 
36152,4400,3334, 3362,4378,3312, 36128,4376,3310, 3361,4377,3311, 
4, // chain 111
3473,4512,3423, 3246,4262,3196, 3240,4256,3190, 
3242,4258,3192, 3246,4262,3196, 36011,4259,3193, 
1, // chain 112
3379,4395,3329, 3380,4396,3330, 3381,4397,3331, 
3, // chain 113
2958,4513,2908, 2957,4514,2907, 3474,4515,3424, 
36212,4516,3394, 36218,4517,3400, 
20, // chain 114
3474,4515,3424, 3444,4516,3394, 3144,4518,3094, 
3145,4519,3095, 2958,4513,2908, 35916,4520,3098, 3475,4521,3425, 36244,4522,3426, 3477,4523,3427, 36246,4524,3428, 36247,4525,3429, 35929,4526,3111, 3162,4527,3112, 3480,4528,3430, 3481,4529,3431, 3482,4530,3432, 36251,4531,3433, 3484,4532,3434, 36253,4533,3435, 
36254,4534,3436, 2961,4535,2911, 35733,4536,2915, 
7, // chain 115
2959,4537,2909, 2958,4513,2908, 3475,4521,3425, 
3477,4523,3427, 3487,4538,3437, 36252,4532,3434, 36246,4524,3428, 3482,4530,3432, 36247,4525,3429, 
3, // chain 116
2959,4537,2909, 3487,4538,3437, 2961,4535,2911, 
36253,4533,3435, 36252,4532,3434, 
14, // chain 117
3488,4539,3438, 3489,4540,3439, 3490,4541,3440, 
36259,4542,3441, 36260,4543,3442, 36261,4544,3443, 36262,4545,3444, 36263,4546,3445, 3496,4547,3446, 36265,4548,3447, 3498,4549,3448, 3499,4550,3449, 36268,4551,3450, 3501,4552,3451, 3502,4553,3452, 36271,4554,3453, 
18, // chain 118
3488,4539,3438, 3490,4541,3440, 3504,4555,3454, 
36273,4556,3455, 36274,4557,3456, 36275,4558,3457, 36259,4542,3441, 3508,4559,3458, 36277,4560,3459, 36260,4543,3442, 3510,4561,3460, 36261,4544,3443, 3511,4562,3461, 36280,4563,3462, 36262,4545,3444, 3496,4547,3446, 3499,4550,3449, 3511,4562,3461, 36281,4564,3463, 
36270,4553,3452, 
35, // chain 119
3514,4565,3464, 3112,4566,3062, 3515,4567,3465, 
3516,4568,3466, 36285,4569,3467, 36272,4555,3454, 3505,4556,3455, 3518,4570,3468, 36287,4571,3469, 36274,4557,3456, 3520,4572,3470, 36275,4558,3457, 3521,4573,3471, 36276,4559,3458, 3509,4560,3459, 3522,4574,3472, 3523,4575,3473, 3524,4576,3474, 36293,4577,3475, 
36294,4578,3476, 3527,4579,3477, 3528,4580,3478, 3529,4581,3479, 36298,4582,3480, 36248,4583,3430, 3162,4584,3112, 3531,4585,3481, 36300,4586,3482, 35894,4587,3076, 3533,4588,3483, 35892,4589,3074, 3125,4590,3075, 3532,4586,3482, 36302,4591,3484, 36303,4592,3485, 
35889,4593,3071, 35890,4594,3072, 
5, // chain 120
3111,4595,3061, 3112,4566,3062, 3514,4565,3464, 
3516,4568,3466, 3110,4596,3060, 36286,4570,3468, 36285,4569,3467, 
7, // chain 121
3520,4572,3470, 3521,4573,3471, 3536,4597,3486, 
3537,4598,3487, 36299,4585,3481, 36297,4581,3479, 36293,4577,3475, 36292,4576,3474, 36289,4573,3471, 
7, // chain 122
3537,4598,3487, 3531,4585,3481, 3532,4586,3482, 
3534,4591,3484, 3519,4571,3469, 36286,4570,3468, 36303,4592,3485, 3110,4596,3060, 35889,4593,3071, 
1, // chain 123
3520,4572,3470, 3537,4598,3487, 3519,4571,3469, 
1, // chain 124
3529,4581,3479, 3530,4582,3480, 3531,4585,3481, 
16, // chain 125
3538,4599,3488, 3539,4600,3489, 3540,4601,3490, 
3541,4602,3491, 36310,4603,3492, 36012,4604,3194, 3543,4605,3493, 36312,4606,3494, 36009,4607,3191, 3239,4608,3189, 3545,4609,3495, 36314,4610,3496, 36004,4611,3186, 3547,4612,3497, 36002,4613,3184, 3451,4614,3401, 36187,4615,3369, 36001,4616,3183, 
11, // chain 126
3548,4617,3498, 3540,4601,3490, 3539,4600,3489, 
3549,4618,3499, 36318,4619,3500, 36306,4599,3488, 3551,4620,3501, 36309,4602,3491, 3542,4603,3492, 3543,4605,3493, 3546,4610,3496, 36313,4609,3495, 36312,4606,3494, 
10, // chain 127
3549,4618,3499, 3550,4619,3500, 3552,4621,3502, 
3548,4617,3498, 36321,4622,3503, 36322,4623,3504, 36323,4624,3505, 36318,4619,3500, 3311,4625,3261, 36319,4620,3501, 3547,4612,3497, 36314,4610,3496, 
4, // chain 128
3555,4624,3505, 3311,4625,3261, 3312,4626,3262, 
3556,4627,3506, 36325,4628,3507, 36326,4629,3508, 
3, // chain 129
3557,4628,3507, 3553,4622,3503, 3556,4627,3506, 
36322,4623,3504, 3555,4624,3505, 
1, // chain 130
2941,4134,2891, 2940,4630,2890, 3140,4136,3090, 
2, // chain 131
3469,4508,3419, 3293,4309,3243, 3294,4310,3244, 
3296,4312,3246, 
5, // chain 132
3306,4322,3256, 3308,4324,3258, 3421,4440,3371, 
3305,4321,3255, 36190,4441,3372, 3303,4319,3253, 36070,4318,3252, 
1, // chain 133
3310,4326,3260, 3421,4440,3371, 3308,4324,3258, 
3, // chain 134
3140,4631,3090, 2940,4632,2890, 2938,4633,2888, 
3133,4126,3083, 35704,4124,2886, 
1, // chain 135
3138,4131,3088, 3140,4631,3090, 3133,4126,3083, 
1, // chain 136
3547,4612,3497, 3451,4614,3401, 3311,4625,3261, 
23, // chain 137
3289,4634,3239, 3284,4635,3234, 3280,4636,3230, 
3277,4637,3227, 3295,4638,3245, 36042,4639,3224, 3298,4640,3248, 36039,4641,3221, 3301,4642,3251, 36036,4643,3218, 3304,4644,3254, 36033,4645,3215, 3263,4646,3213, 3307,4647,3257, 36326,4648,3508, 36028,4649,3210, 3557,4650,3507, 36321,4651,3503, 36024,4652,3206, 
3253,4653,3203, 3548,4654,3498, 36308,4655,3490, 36018,4656,3200, 3244,4657,3194, 36013,4658,3195, 
2, // chain 138
3312,4659,3262, 3309,4660,3259, 3558,4648,3508, 
36075,4647,3257, 
7, // chain 139
3498,4661,3448, 3497,4662,3447, 3559,4663,3509, 
36328,4664,3510, 36263,4665,3445, 3489,4666,3439, 3488,4667,3438, 3515,4668,3465, 36272,4669,3454, 
6, // chain 140
3561,4670,3511, 3562,4671,3512, 3563,4672,3513, 
3564,4673,3514, 36283,4668,3465, 36328,4664,3510, 36333,4674,3515, 36330,4671,3512, 
1, // chain 141
3565,4674,3515, 3559,4663,3509, 3560,4664,3510, 
14, // chain 142
3564,4673,3514, 3515,4668,3465, 3112,4101,3062, 
3113,4102,3063, 3566,4675,3516, 35882,4103,3064, 3567,4676,3517, 36336,4677,3518, 35883,4104,3065, 3569,4678,3519, 35884,4105,3066, 3570,4679,3520, 35885,4106,3067, 3034,4023,2984, 35886,4107,3068, 3033,4022,2983, 
13, // chain 143
3571,4680,3521, 3561,4670,3511, 3564,4673,3514, 
3566,4675,3516, 3572,4681,3522, 36341,4682,3523, 36335,4676,3517, 3568,4677,3518, 3574,4683,3524, 36343,4684,3525, 36337,4678,3519, 3570,4679,3520, 3034,4023,2984, 3574,4683,3524, 35803,4024,2985, 
1, // chain 144
3562,4671,3512, 3561,4670,3511, 3571,4680,3521, 
2, // chain 145
3576,4685,3526, 3572,4681,3522, 3573,4682,3523, 
3574,4683,3524, 
8, // chain 146
3028,4017,2978, 3029,4018,2979, 3056,4045,3006, 
3057,4046,3007, 3027,4016,2977, 35817,4038,2999, 35826,4047,3008, 3048,4037,2998, 35814,4035,2996, 35813,4034,2995, 
9, // chain 147
3577,4686,3527, 3578,4687,3528, 3315,4688,3265, 
3579,4689,3529, 36081,4690,3263, 3210,4691,3160, 3580,4692,3530, 35979,4693,3161, 3578,4687,3528, 36082,4694,3264, 3315,4688,3265, 
2, // chain 148
3578,4687,3528, 3577,4686,3527, 3580,4692,3530, 
36347,4689,3529, 
10, // chain 149
3581,4695,3531, 3062,4696,3012, 3069,4697,3019, 
3582,4698,3532, 35847,4699,3029, 3583,4700,3533, 35846,4701,3028, 3076,4702,3026, 3061,4703,3011, 3584,4704,3534, 36349,4695,3531, 35830,4696,3012, 
2, // chain 150
3583,4700,3533, 3584,4704,3534, 3581,4695,3531, 
3582,4698,3532, 
13, // chain 151
3585,4705,3535, 3586,4706,3536, 3587,4707,3537, 
3588,4708,3538, 36357,4709,3539, 36358,4710,3540, 36354,4706,3536, 2965,4711,2915, 35755,4712,2937, 36353,4705,3535, 3591,4713,3541, 36360,4714,3542, 36356,4708,3538, 3593,4715,3543, 36357,4709,3539, 
27, // chain 152
3594,4716,3544, 3595,4717,3545, 3596,4718,3546, 
3597,4719,3547, 36366,4720,3548, 36363,4717,3545, 3599,4721,3549, 36368,4722,3550, 36362,4716,3544, 3601,4723,3551, 36365,4719,3547, 3602,4724,3552, 35762,4725,2944, 35764,4726,2946, 35768,4727,2950, 36366,4720,3548, 3603,4728,3553, 36367,4721,3549, 3604,4729,3554, 
36373,4730,3555, 36374,4731,3556, 36368,4722,3550, 3601,4723,3551, 3607,4732,3557, 36370,4724,3552, 3605,4730,3555, 36376,4733,3558, 36377,4734,3559, 35762,4725,2944, 
1, // chain 153
3000,4727,2950, 2997,4735,2947, 2996,4726,2946, 
15, // chain 154
3000,4727,2950, 3603,4728,3553, 3610,4736,3560, 
3001,4737,2951, 36379,4738,3561, 36380,4739,3562, 36371,4728,3553, 3604,4729,3554, 3613,4740,3563, 36382,4741,3564, 36383,4742,3565, 36373,4730,3555, 3616,4743,3566, 36376,4733,3558, 3617,4744,3567, 36386,4745,3568, 36377,4734,3559, 
5, // chain 155
3612,4739,3562, 3613,4740,3563, 3619,4746,3569, 
3611,4738,3561, 36388,4747,3570, 3621,4748,3571, 36390,4749,3572, 
2, // chain 156
3623,4750,3573, 3005,4751,2955, 3611,4738,3561, 
35769,4737,2951, 
1, // chain 157
3621,4748,3571, 3623,4750,3573, 3611,4738,3561, 
3, // chain 158
3624,4752,3574, 3625,4753,3575, 3626,4754,3576, 
3617,4744,3567, 3618,4745,3568, 
1, // chain 159
3606,4731,3556, 3607,4732,3557, 3605,4730,3555, 
5, // chain 160
3160,4165,3110, 3161,4167,3111, 3476,4755,3426, 
3627,4756,3577, 35918,4147,3100, 35917,4146,3099, 35916,4145,3098, 
3, // chain 161
3159,4163,3109, 3160,4165,3110, 3627,4756,3577, 
3153,4152,3103, 35918,4147,3100, 
14, // chain 162
3628,4757,3578, 3629,4758,3579, 3630,4759,3580, 
3481,4760,3431, 36251,4761,3433, 36399,4762,3581, 36400,4763,3582, 36401,4764,3583, 36397,4758,3579, 3625,4765,3575, 36402,4766,3584, 36295,4767,3477, 36396,4757,3578, 3528,4768,3478, 36248,4769,3430, 36249,4760,3431, 
9, // chain 163
3486,4770,3436, 3483,4761,3433, 3631,4762,3581, 
3593,4771,3543, 36360,4772,3542, 36403,4773,3585, 36400,4763,3582, 3636,4774,3586, 36405,4775,3587, 36393,4765,3575, 36401,4764,3583, 
10, // chain 164
3591,4776,3541, 3592,4772,3542, 3635,4773,3585, 
3636,4774,3586, 2987,4777,2937, 35756,4778,2938, 35757,4779,2939, 36406,4780,3588, 36405,4775,3587, 3639,4781,3589, 36392,4782,3574, 36393,4765,3575, 
5, // chain 165
3639,4781,3589, 3624,4782,3574, 3618,4783,3568, 
3640,4784,3590, 35760,4785,2942, 36377,4786,3559, 2994,4787,2944, 
3, // chain 166
3638,4780,3588, 3639,4781,3589, 3640,4784,3590, 
2991,4788,2941, 35760,4785,2942, 
1, // chain 167
3638,4780,3588, 2991,4788,2941, 2989,4779,2939, 
1, // chain 168
2987,4777,2937, 2964,4789,2914, 2965,4790,2915, 
3, // chain 169
2965,4790,2915, 3486,4770,3436, 3590,4791,3540, 
36357,4792,3539, 36361,4771,3543, 
1, // chain 170
3074,4063,3024, 3075,4064,3025, 3073,4062,3023, 
15, // chain 171
3641,4793,3591, 3642,4794,3592, 3643,4795,3593, 
36412,4796,3594, 3645,4797,3595, 3646,4798,3596, 3647,4799,3597, 36416,4800,3598, 36417,4801,3599, 36418,4802,3600, 3651,4803,3601, 36420,4804,3602, 3653,4805,3603, 35603,4806,2785, 2912,4807,2862, 2887,4808,2837, 35654,4809,2836, 
7, // chain 172
3649,4801,3599, 3651,4803,3601, 3654,4810,3604, 
3648,4800,3598, 36423,4811,3605, 36424,4812,3606, 3657,4813,3607, 36426,4814,3608, 36427,4815,3609, 
10, // chain 173
3643,4795,3593, 3647,4799,3597, 3660,4816,3610, 
3641,4793,3591, 36429,4817,3611, 36430,4818,3612, 36415,4799,3597, 3648,4800,3598, 3655,4811,3605, 3657,4813,3607, 3661,4817,3611, 36426,4814,3608, 
1, // chain 174
3653,4805,3603, 2887,4808,2837, 3651,4803,3601, 
13, // chain 175
3663,4819,3613, 2834,4820,2784, 2835,4821,2785, 
3652,4822,3602, 2843,4823,2793, 36432,4824,3614, 36418,4825,3600, 3665,4826,3615, 36414,4827,3596, 3666,4828,3616, 36435,4829,3617, 36436,4830,3618, 36413,4831,3595, 3669,4832,3619, 36412,4833,3594, 
2, // chain 176
2840,4834,2790, 2834,4820,2784, 3663,4819,3613, 
2843,4823,2793, 
9, // chain 177
3664,4824,3614, 3665,4826,3615, 3666,4828,3616, 
3670,4835,3620, 36439,4836,3621, 36440,4837,3622, 36435,4829,3617, 3673,4838,3623, 36436,4830,3618, 3674,4839,3624, 36437,4832,3619, 
10, // chain 178
3675,4840,3625, 3676,4841,3626, 3677,4842,3627, 
3678,4843,3628, 36447,4844,3629, 36439,4836,3621, 36448,4845,3630, 36449,4846,3631, 36444,4841,3626, 3682,4847,3632, 36451,4848,3633, 36443,4840,3625, 
4, // chain 179
3671,4836,3621, 3672,4837,3622, 3679,4844,3629, 
36446,4843,3628, 36441,4838,3623, 3674,4839,3624, 
7, // chain 180
3671,4836,3621, 3680,4845,3630, 3670,4835,3620, 
36452,4849,3634, 36453,4850,3635, 36449,4846,3631, 3682,4847,3632, 3686,4851,3636, 3684,4849,3634, 
3, // chain 181
2843,4823,2793, 3664,4824,3614, 3670,4835,3620, 
3687,4852,3637, 36452,4849,3634, 
6, // chain 182
2864,4853,2814, 2863,4854,2813, 3688,4855,3638, 
3689,4856,3639, 36458,4857,3640, 36459,4858,3641, 36460,4859,3642, 35631,4854,2813, 
3, // chain 183
3693,4860,3643, 3694,4861,3644, 3695,4862,3645, 
36464,4863,3646, 36465,4864,3647, 
4, // chain 184
3698,4865,3648, 3693,4860,3643, 3695,4862,3645, 
2869,4866,2819, 35640,4867,2822, 36464,4863,3646, 
5, // chain 185
3699,4868,3649, 3698,4865,3648, 2869,4866,2819, 
3700,4869,3650, 35635,4870,2817, 3689,4856,3639, 35632,4853,2814, 
7, // chain 186
3700,4869,3650, 3689,4856,3639, 3690,4857,3640, 
3699,4868,3649, 36461,4860,3643, 36469,4871,3651, 36459,4872,3641, 3702,4873,3652, 36471,4874,3653, 
1, // chain 187
3698,4865,3648, 3699,4868,3649, 3693,4860,3643, 
3, // chain 188
3693,4860,3643, 3701,4871,3651, 3694,4875,3644, 
36470,4873,3652, 3697,4876,3647, 
1, // chain 189
3692,4859,3642, 3703,4877,3653, 3691,4858,3641, 
2, // chain 190
3704,4878,3654, 3705,4879,3655, 3513,4880,3463, 
3502,4881,3452, 
6, // chain 191
3511,4882,3461, 3513,4880,3463, 3705,4879,3655, 
3706,4883,3656, 36475,4884,3657, 36472,4878,3654, 3708,4885,3658, 36477,4886,3659, 
10, // chain 192
3509,4887,3459, 3510,4888,3460, 3710,4889,3660, 
36479,4890,3661, 36279,4882,3461, 3706,4883,3656, 3712,4891,3662, 36481,4892,3663, 36475,4884,3657, 3714,4893,3664, 36483,4894,3665, 36476,4885,3658, 
8, // chain 193
3716,4895,3666, 3509,4887,3459, 3710,4889,3660, 
3717,4896,3667, 36479,4890,3661, 3712,4891,3662, 3718,4897,3668, 36481,4892,3663, 3719,4898,3669, 36482,4893,3664, 
23, // chain 194
3523,4899,3473, 3522,4900,3472, 3720,4901,3670, 
36277,4887,3459, 3721,4902,3671, 36484,4895,3666, 3722,4903,3672, 36491,4904,3673, 36485,4896,3667, 3724,4905,3674, 3725,4906,3675, 3726,4907,3676, 36495,4908,3677, 36496,4909,3678, 3729,4910,3679, 36498,4911,3680, 36499,4912,3681, 3732,4913,3682, 3729,4910,3679, 
36501,4914,3683, 3734,4915,3684, 36503,4916,3685, 36504,4917,3686, 3737,4918,3687, 36506,4919,3688, 
6, // chain 195
3739,4920,3689, 3722,4903,3672, 3723,4904,3673, 
3726,4907,3676, 3740,4921,3690, 36502,4915,3684, 36495,4908,3677, 3729,4910,3679, 
33, // chain 196
3721,4902,3671, 3722,4903,3672, 3720,4901,3670, 
36509,4922,3691, 36507,4920,3689, 3740,4921,3690, 3742,4923,3692, 36511,4924,3693, 36502,4915,3684, 3735,4916,3685, 3737,4918,3687, 3744,4925,3694, 36513,4926,3695, 36514,4927,3696, 3669,4928,3619, 3744,4925,3694, 36412,4929,3594, 3747,4930,3697, 36516,4931,3698, 
36410,4932,3592, 3749,4933,3699, 3750,4934,3700, 36519,4935,3701, 36520,4936,3702, 3527,4937,3477, 3526,4938,3476, 3523,4899,3473, 3753,4939,3703, 36488,4901,3670, 3754,4940,3704, 36509,4922,3691, 3742,4923,3692, 3747,4930,3697, 36512,4925,3694, 36511,4924,3693, 
4, // chain 197
3747,4930,3697, 3748,4931,3698, 3750,4934,3700, 
3754,4940,3704, 36519,4935,3701, 3753,4939,3703, 
12, // chain 198
3755,4941,3705, 3756,4942,3706, 3757,4943,3707, 
3758,4944,3708, 36527,4945,3709, 36528,4946,3710, 36524,4942,3706, 3761,4947,3711, 36530,4948,3712, 3763,4949,3713, 36532,4950,3714, 36533,4951,3715, 3766,4952,3716, 36535,4953,3717, 
13, // chain 199
3768,4954,3718, 3769,4955,3719, 3770,4956,3720, 
36539,4957,3721, 3772,4958,3722, 36541,4959,3723, 36523,4941,3705, 3774,4960,3724, 36526,4944,3708, 3775,4961,3725, 36527,4945,3709, 3776,4962,3726, 36545,4963,3727, 36529,4947,3711, 36528,4946,3710, 
6, // chain 200
3778,4964,3728, 3768,4954,3718, 3770,4956,3720, 
3772,4958,3722, 3779,4965,3729, 36543,4961,3725, 36541,4959,3723, 3774,4960,3724, 
9, // chain 201
3768,4954,3718, 3778,4964,3728, 3779,4965,3729, 
3780,4966,3730, 36549,4967,3731, 36543,4961,3725, 3776,4962,3726, 3782,4968,3732, 3783,4969,3733, 36552,4970,3734, 3785,4971,3735, 
1, // chain 202
3783,4969,3733, 3780,4966,3730, 3781,4967,3731, 
4, // chain 203
3766,4952,3716, 3776,4962,3726, 3777,4963,3727, 
3764,4950,3714, 36531,4949,3713, 36529,4947,3711, 
61, // chain 204
3786,4972,3736, 3787,4973,3737, 3788,4974,3738, 
3789,4975,3739, 36558,4976,3740, 36559,4977,3741, 36555,4973,3737, 3792,4978,3742, 36561,4979,3743, 36554,4972,3736, 3794,4980,3744, 36563,4981,3745, 36564,4982,3746, 36565,4983,3747, 36557,4975,3739, 3798,4984,3748, 36558,4976,3740, 3799,4985,3749, 3800,4986,3750, 
36569,4987,3751, 36570,4988,3752, 3803,4989,3753, 36572,4990,3754, 36573,4991,3755, 3803,4989,3753, 36574,4992,3756, 36575,4993,3757, 36576,4994,3758, 3806,4992,3756, 36577,4995,3759, 36578,4996,3760, 36579,4997,3761, 3812,4998,3762, 36581,4999,3763, 36582,5000,3764, 
3815,5001,3765, 36584,5002,3766, 36585,5003,3767, 3818,5004,3768, 36587,5005,3769, 36588,5006,3770, 36589,5007,3771, 36590,5008,3772, 36539,5009,3721, 3769,5010,3719, 3823,5011,3773, 36588,5006,3770, 36536,5012,3718, 3824,5013,3774, 36548,5014,3730, 3825,5015,3775, 
36594,5016,3776, 36551,5017,3733, 3827,5018,3777, 36553,5019,3735, 3828,5020,3778, 3829,5021,3779, 36598,5022,3780, 3831,5023,3781, 35688,5024,2870, 2811,3791,2761, 35578,3790,2760, 35577,3789,2759, 
6, // chain 205
3832,5025,3782, 3795,4981,3745, 3833,5026,3783, 
3834,5027,3784, 35549,3761,2731, 35548,3760,2730, 36564,4982,3746, 36563,4981,3745, 
9, // chain 206
3797,4983,3747, 3798,4984,3748, 3800,4986,3750, 
3801,4987,3751, 3835,5028,3785, 36604,5029,3786, 36605,5030,3787, 36571,4989,3753, 3838,5031,3788, 36577,4995,3759, 36574,4992,3756, 
9, // chain 207
2779,3759,2729, 2780,3760,2730, 3839,5032,3789, 
2819,3799,2769, 35586,3798,2768, 36608,5033,3790, 36604,5029,3786, 35548,3760,2730, 3835,5028,3785, 36564,4982,3746, 3797,4983,3747, 
11, // chain 208
3840,5033,3790, 3836,5029,3786, 3837,5030,3787, 
3838,5031,3788, 2817,3797,2767, 36609,5034,3791, 36610,5035,3792, 36611,5036,3793, 36577,4995,3759, 3815,5001,3765, 36581,4999,3763, 36580,4998,3762, 36578,4996,3760, 
11, // chain 209
3841,5034,3791, 3842,5035,3792, 3844,5037,3794, 
3845,5038,3795, 36592,5013,3774, 36588,5006,3770, 36610,5035,3792, 3819,5005,3769, 36614,5039,3796, 36611,5036,3793, 3818,5004,3768, 36584,5002,3766, 36583,5001,3765, 
1, // chain 210
3846,5039,3796, 3818,5004,3768, 3819,5005,3769, 
4, // chain 211
3826,5016,3776, 3829,5021,3779, 3847,5040,3797, 
2813,3793,2763, 36599,5023,3781, 36597,5021,3779, 
2, // chain 212
2812,3792,2762, 2813,3793,2763, 3831,5023,3781, 
2811,3791,2761, 
3, // chain 213
3848,5041,3798, 2813,3793,2763, 3849,5042,3799, 
2814,3794,2764, 35581,3793,2763, 
8, // chain 214
3850,5043,3800, 3841,5034,3791, 3848,5041,3798, 
3851,5044,3801, 35582,3794,2764, 2815,3795,2765, 2816,3796,2766, 3850,5043,3800, 36609,5034,3791, 35585,3797,2767, 
4, // chain 215
3848,5041,3798, 3841,5034,3791, 3845,5038,3795, 
3826,5016,3776, 36593,5015,3775, 36592,5013,3774, 
1, // chain 216
2813,3793,2763, 3848,5041,3798, 3826,5016,3776, 
3, // chain 217
3852,5045,3802, 3820,5006,3770, 3821,5007,3771, 
3823,5011,3773, 36590,5008,3772, 
1, // chain 218
3823,5011,3773, 3820,5006,3770, 3852,5045,3802, 
1, // chain 219
3827,5018,3777, 3829,5021,3779, 3826,5016,3776, 
1, // chain 220
2817,3797,2767, 2818,3798,2768, 3840,5033,3790, 
4, // chain 221
3834,5027,3784, 2781,3761,2731, 3853,5046,3803, 
3854,5047,3804, 35550,3762,2732, 35549,3761,2731, 
16, // chain 222
3855,5048,3805, 3856,5049,3806, 3857,5050,3807, 
3858,5051,3808, 36552,5052,3734, 36627,5053,3809, 36628,5054,3810, 36629,5055,3811, 36624,5049,3806, 3862,5056,3812, 35552,3764,2734, 36631,5057,3813, 36623,5048,3805, 3864,5058,3814, 36626,5051,3808, 3776,5059,3726, 36550,5060,3732, 36552,5052,3734, 
3, // chain 223
2784,3764,2734, 2785,3765,2735, 3862,5056,3812, 
35681,3893,2863, 35554,3766,2736, 
10, // chain 224
3785,5061,3735, 3784,5052,3734, 3859,5053,3809, 
3828,5062,3778, 36628,5054,3810, 3830,5063,3780, 35688,3908,2870, 36633,5064,3815, 36629,5055,3811, 2914,3894,2864, 35681,3893,2863, 36630,5056,3812, 
8, // chain 225
2783,3763,2733, 2784,3764,2734, 3863,5057,3813, 
3866,5065,3816, 36635,5066,3817, 36632,5058,3814, 3776,5059,3726, 3868,5067,3818, 36637,5068,3819, 36534,5069,3716, 
7, // chain 226
2782,3762,2732, 2783,3763,2733, 3854,5047,3804, 
36634,5065,3816, 3870,5070,3820, 36639,5071,3821, 36640,5072,3822, 36636,5067,3818, 36635,5066,3817, 
49, // chain 227
3873,5073,3823, 3854,5047,3804, 3870,5070,3820, 
3874,5074,3824, 36639,5071,3821, 3875,5075,3825, 36644,5076,3826, 36645,5077,3827, 36646,5078,3828, 36647,5079,3829, 36640,5072,3822, 3880,5080,3830, 36649,5081,3831, 36636,5067,3818, 3869,5068,3819, 3882,5082,3832, 3880,5080,3830, 36651,5083,3833, 3879,5079,3829, 
36646,5078,3828, 36652,5084,3834, 3877,5077,3827, 36653,5085,3835, 36654,5086,3836, 3887,5087,3837, 36656,5088,3838, 36657,5089,3839, 3890,5090,3840, 36659,5091,3841, 36660,5092,3842, 3893,5093,3843, 36662,5094,3844, 36663,5095,3845, 36664,5096,3846, 36665,5097,3847, 
36666,5098,3848, 3899,5099,3849, 36668,5100,3850, 36669,5101,3851, 36670,5102,3852, 36671,5103,3853, 3904,5104,3854, 36673,5105,3855, 36674,5106,3856, 36675,5107,3857, 3908,5108,3858, 36677,5109,3859, 36678,5110,3860, 3911,5111,3861, 36560,4978,3742, 36559,4977,3741, 
11, // chain 228
3912,5112,3862, 3873,5073,3823, 3874,5074,3824, 
3913,5113,3863, 36682,5114,3864, 36643,5075,3825, 3915,5115,3865, 36658,5090,3840, 36656,5088,3838, 36655,5087,3837, 36644,5076,3826, 3885,5085,3835, 36645,5077,3827, 
13, // chain 229
3916,5116,3866, 3834,5027,3784, 3912,5112,3862, 
3913,5113,3863, 3917,5117,3867, 36667,5099,3849, 36665,5097,3847, 36664,5096,3846, 36682,5114,3864, 3895,5095,3845, 36662,5094,3844, 36661,5093,3843, 36683,5115,3865, 3891,5091,3841, 36658,5090,3840, 
2, // chain 230
3873,5073,3823, 3912,5112,3862, 3834,5027,3784, 
3854,5047,3804, 
8, // chain 231
3834,5027,3784, 3916,5116,3866, 3832,5025,3782, 
36686,5118,3868, 36685,5117,3867, 3904,5104,3854, 36670,5102,3852, 36669,5101,3851, 36668,5100,3850, 36667,5099,3849, 
4, // chain 232
3794,4980,3744, 3908,5108,3858, 3909,5109,3859, 
3911,5111,3861, 3793,4979,3743, 36560,4978,3742, 
8, // chain 233
3908,5108,3858, 3794,4980,3744, 3919,5119,3869, 
3906,5106,3856, 36673,5105,3855, 36672,5104,3854, 36686,5118,3868, 36562,4980,3744, 3795,4981,3745, 3832,5025,3782, 
52, // chain 234
3920,5120,3870, 3921,5121,3871, 3922,5122,3872, 
3923,5123,3873, 36692,5124,3874, 36693,5125,3875, 36694,5126,3876, 36689,5121,3871, 3927,5127,3877, 36696,5128,3878, 36697,5129,3879, 36688,5120,3870, 3930,5130,3880, 36699,5131,3881, 36700,5132,3882, 36691,5123,3873, 3933,5133,3883, 36692,5124,3874, 3934,5134,3884, 
36703,5135,3885, 36693,5125,3875, 3936,5136,3886, 36446,5137,3628, 36443,5138,3625, 36705,5139,3887, 36694,5126,3876, 3938,5140,3888, 36707,5141,3889, 36695,5127,3877, 3940,5142,3890, 36709,5143,3891, 36710,5144,3892, 36696,5128,3878, 3929,5129,3879, 3943,5145,3893, 
36712,5146,3894, 36713,5147,3895, 36698,5130,3880, 3946,5148,3896, 36699,5131,3881, 3947,5149,3897, 36716,5150,3898, 36700,5132,3882, 3933,5133,3883, 3934,5134,3884, 3947,5149,3897, 36500,5151,3682, 36501,5152,3683, 36703,5135,3885, 3949,5153,3899, 36704,5136,3886, 
3738,5154,3688, 36442,5155,3624, 36446,5137,3628, 
10, // chain 235
3942,5144,3892, 3950,5156,3900, 3941,5143,3891, 
36719,5157,3901, 36720,5158,3902, 3953,5159,3903, 36722,5160,3904, 36723,5161,3905, 36724,5162,3906, 3944,5146,3894, 36725,5163,3907, 3943,5145,3893, 
11, // chain 236
3945,5147,3895, 3946,5148,3896, 3958,5164,3908, 
3959,5165,3909, 36728,5166,3910, 36729,5167,3911, 36730,5168,3912, 36714,5148,3896, 3947,5149,3897, 3963,5169,3913, 36732,5170,3914, 36499,5171,3681, 36500,5151,3682, 
18, // chain 237
3965,5172,3915, 3966,5173,3916, 3959,5165,3909, 
3967,5174,3917, 36728,5166,3910, 3968,5175,3918, 36729,5167,3911, 3969,5176,3919, 36730,5168,3912, 3963,5169,3913, 3970,5177,3920, 36739,5178,3921, 36732,5170,3914, 3972,5179,3922, 36499,5171,3681, 3728,5180,3678, 3973,5181,3923, 36742,5182,3924, 36492,5183,3674, 
36493,5184,3675, 
23, // chain 238
3966,5173,3916, 3965,5172,3915, 3975,5185,3925, 
36735,5174,3917, 3976,5186,3926, 36745,5187,3927, 36746,5188,3928, 36736,5175,3918, 3969,5176,3919, 3979,5189,3929, 36738,5177,3920, 3971,5178,3921, 3980,5190,3930, 36749,5191,3931, 36740,5179,3922, 3982,5192,3932, 36741,5181,3923, 3983,5193,3933, 36752,5194,3934, 
36742,5182,3924, 3985,5195,3935, 36487,5196,3669, 36486,5197,3668, 36485,5198,3667, 36492,5183,3674, 
2, // chain 239
3986,5199,3936, 3978,5188,3928, 3979,5189,3929, 
3980,5190,3930, 
1, // chain 240
3981,5191,3931, 3982,5192,3932, 3983,5193,3933, 
1, // chain 241
3714,5200,3664, 3985,5195,3935, 3719,5196,3669, 
2, // chain 242
3882,5201,3832, 3869,5202,3819, 3767,5203,3717, 
36534,5204,3716, 
23, // chain 243
3771,5205,3721, 3817,5206,3767, 3814,5207,3764, 
3755,5208,3705, 36579,5209,3761, 3756,5210,3706, 36530,5211,3712, 36576,5212,3758, 3805,5213,3755, 3765,5214,3715, 36535,5203,3717, 36570,5215,3752, 3882,5201,3832, 36651,5216,3833, 36567,5217,3749, 3790,5218,3740, 3884,5219,3834, 36559,5220,3741, 3886,5221,3836, 
36678,5222,3860, 3889,5223,3839, 36675,5224,3857, 3892,5225,3842, 36671,5226,3853, 3898,5227,3848, 
11, // chain 244
3987,5228,3937, 3988,5229,3938, 3989,5230,3939, 
3990,5231,3940, 35623,5232,2805, 35626,5233,2808, 36756,5229,3938, 2860,5234,2810, 35619,5235,2801, 36755,5228,3937, 3990,5231,3940, 2850,5236,2800, 35623,5232,2805, 
12, // chain 245
3942,5237,3892, 3943,5238,3893, 3991,5239,3941, 
36725,5240,3907, 3956,5241,3906, 3992,5242,3942, 36720,5243,3902, 3993,5244,3943, 36718,5245,3900, 3942,5237,3892, 3994,5246,3944, 36759,5239,3941, 3993,5244,3943, 36760,5242,3942, 
13, // chain 246
3995,5247,3945, 3996,5248,3946, 3997,5249,3947, 
3998,5250,3948, 36767,5251,3949, 36768,5252,3950, 36764,5248,3946, 4001,5253,3951, 4002,5254,3952, 4003,5255,3953, 3999,5251,3949, 36427,5256,3609, 4004,5257,3954, 3998,5250,3948, 36763,5247,3945, 
5, // chain 247
4005,5258,3955, 2846,5259,2796, 4006,5260,3956, 
4007,5261,3957, 36776,5262,3958, 35615,5263,2797, 35614,5259,2796, 
4, // chain 248
2861,5264,2811, 2862,5265,2812, 4009,5266,3959, 
36778,5267,3960, 36773,5258,3955, 35614,5259,2796, 
19, // chain 249
2863,5268,2813, 2861,5264,2811, 4009,5266,3959, 
4011,5269,3961, 36778,5267,3960, 4005,5258,3955, 4012,5270,3962, 36781,5271,3963, 36775,5261,3957, 4014,5272,3964, 36783,5273,3965, 36784,5274,3966, 36776,5262,3958, 4017,5275,3967, 36786,5276,3968, 36454,5277,3636, 35615,5263,2797, 2844,5278,2794, 3684,5279,3634, 
36455,5280,3637, 35611,5281,2793, 
9, // chain 250
4019,5282,3969, 4015,5273,3965, 4016,5274,3966, 
4020,5283,3970, 36785,5275,3967, 4021,5284,3971, 36786,5276,3968, 4022,5285,3972, 36451,5286,3633, 36450,5287,3632, 36454,5277,3636, 
17, // chain 251
4023,5288,3973, 3702,5289,3652, 4012,5270,3962, 
4024,5290,3974, 36781,5271,3963, 4014,5272,3964, 4025,5291,3975, 36783,5273,3965, 4026,5292,3976, 36795,5293,3977, 36787,5282,3969, 4020,5283,3970, 4028,5294,3978, 36789,5284,3971, 3938,5140,3888, 36790,5285,3972, 3937,5139,3887, 36443,5138,3625, 36451,5286,3633, 
2, // chain 252
4011,5269,3961, 4012,5270,3962, 3692,5295,3642, 
2863,5268,2813, 
2, // chain 253
3702,5289,3652, 3703,5296,3653, 4012,5270,3962, 
36460,5295,3642, 
14, // chain 254
4029,5297,3979, 4023,5288,3973, 4024,5290,3974, 
4030,5298,3980, 36793,5291,3975, 4031,5299,3981, 36794,5292,3976, 4032,5300,3982, 36801,5301,3983, 36802,5302,3984, 36803,5303,3985, 36795,5293,3977, 4036,5304,3986, 36796,5294,3978, 3939,5141,3889, 36706,5140,3888, 
20, // chain 255
3702,5289,3652, 4023,5288,3973, 4037,5305,3987, 
36806,5306,3988, 36797,5297,3979, 4039,5307,3989, 36798,5298,3980, 4031,5299,3981, 4040,5308,3990, 36809,5309,3991, 36800,5300,3982, 4042,5310,3992, 36811,5311,3993, 36812,5312,3994, 36801,5301,3983, 4045,5313,3995, 36802,5302,3984, 4046,5314,3996, 36708,5142,3890, 
36803,5303,3985, 4036,5304,3986, 3939,5141,3889, 
29, // chain 256
3697,5315,3647, 3702,5289,3652, 4037,5305,3987, 
4047,5316,3997, 36816,5317,3998, 36806,5306,3988, 4049,5318,3999, 36818,5319,4000, 36807,5307,3989, 4040,5308,3990, 4051,5320,4001, 36820,5321,4002, 36821,5322,4003, 36822,5323,4004, 36809,5309,3991, 4055,5324,4005, 36810,5310,3992, 4056,5325,4006, 36825,5326,4007, 
36826,5327,4008, 36811,5311,3993, 4059,5328,4009, 36812,5312,3994, 4060,5329,4010, 36829,5330,4011, 36830,5331,4012, 36813,5313,3995, 3951,5157,3901, 36709,5143,3891, 36814,5314,3996, 3940,5142,3890, 
10, // chain 257
3696,5332,3646, 3697,5315,3647, 4047,5316,3997, 
2872,5333,2822, 36831,5334,4013, 36832,5335,4014, 36816,5317,3998, 4065,5336,4015, 36817,5318,3999, 4066,5337,4016, 36819,5320,4001, 36818,5319,4000, 
10, // chain 258
4067,5338,4017, 4066,5337,4016, 4068,5339,4018, 
4069,5340,4019, 36838,5341,4020, 36839,5342,4021, 36840,5343,4022, 36841,5344,4023, 36821,5322,4003, 36820,5321,4002, 36834,5337,4016, 4051,5320,4001, 
16, // chain 259
4058,5327,4008, 4059,5328,4009, 4074,5345,4024, 
4075,5346,4025, 36844,5347,4026, 36845,5348,4027, 36846,5349,4028, 36827,5328,4009, 4060,5329,4010, 4079,5350,4029, 36848,5351,4030, 36849,5352,4031, 36850,5353,4032, 36829,5330,4011, 4083,5354,4033, 36721,5159,3903, 36830,5331,4012, 3951,5157,3901, 
10, // chain 260
4057,5326,4007, 4058,5327,4008, 4075,5346,4025, 
4056,5325,4006, 36844,5347,4026, 4084,5355,4034, 36853,5356,4035, 36854,5357,4036, 36855,5358,4037, 36845,5348,4027, 4079,5350,4029, 36846,5349,4028, 
20, // chain 261
4080,5351,4030, 4081,5352,4031, 4088,5359,4038, 
4079,5350,4029, 36857,5360,4039, 36858,5361,4040, 36859,5362,4041, 36849,5352,4031, 4092,5363,4042, 36850,5353,4032, 4093,5364,4043, 36851,5354,4033, 3953,5159,3903, 3954,5160,3904, 4094,5365,4044, 36734,5173,3916, 36863,5366,4045, 36723,5161,3905, 3944,5146,3894, 
3945,5147,3895, 3959,5165,3909, 3966,5173,3916, 
14, // chain 262
4096,5367,4046, 4097,5368,4047, 4089,5360,4039, 
36855,5358,4037, 36866,5369,4048, 4099,5370,4049, 36868,5371,4050, 4101,5372,4051, 4102,5373,4052, 36871,5374,4053, 4004,5375,3954, 4104,5376,4054, 4072,5343,4022, 36839,5342,4021, 36424,5377,3606, 36427,5378,3609, 
10, // chain 263
4105,5379,4055, 4096,5367,4046, 4089,5360,4039, 
4090,5361,4040, 4106,5380,4056, 36859,5362,4041, 4107,5381,4057, 36860,5363,4042, 4093,5364,4043, 3975,5185,3925, 36862,5365,4044, 3966,5173,3916, 
2, // chain 264
3736,5382,3686, 3733,5152,3683, 3949,5153,3899, 
3738,5154,3688, 
3, // chain 265
3746,5383,3696, 3737,5384,3687, 3738,5154,3688, 
3674,5155,3624, 3669,5385,3619, 
9, // chain 266
4066,5337,4016, 4067,5338,4017, 4108,5386,4058, 
36877,5387,4059, 36837,5340,4019, 4110,5388,4060, 36879,5389,4061, 36880,5390,4062, 36838,5341,4020, 3656,5377,3606, 36839,5342,4021, 
12, // chain 267
4065,5336,4015, 4066,5337,4016, 4108,5386,4058, 
4113,5391,4063, 36877,5387,4059, 2878,5392,2828, 36878,5388,4060, 2885,5393,2835, 36879,5389,4061, 2887,5394,2837, 36419,5395,3601, 36422,5396,3604, 36880,5390,4062, 3656,5377,3606, 
5, // chain 268
4065,5336,4015, 4113,5391,4063, 4064,5335,4014, 
36831,5334,4013, 35639,5397,2821, 35647,5398,2829, 35646,5392,2828, 
1, // chain 269
2871,5397,2821, 2872,5333,2822, 4063,5334,4013, 
6, // chain 270
4114,5399,4064, 4102,5373,4052, 4072,5343,4022, 
4115,5400,4065, 36841,5344,4023, 4055,5324,4005, 36821,5322,4003, 4054,5323,4004, 
4, // chain 271
4086,5357,4036, 4087,5358,4037, 4099,5370,4049, 
4085,5356,4035, 36882,5399,4064, 36870,5373,4052, 
4, // chain 272
4085,5356,4035, 4114,5399,4064, 4084,5355,4034, 
36883,5400,4065, 4056,5325,4006, 36823,5324,4005, 
1, // chain 273
4089,5360,4039, 4087,5358,4037, 4079,5350,4029, 
5, // chain 274
3976,5186,3926, 3977,5187,3927, 4116,5401,4066, 
4117,5402,4067, 4118,5403,4068, 36887,5404,4069, 4120,5405,4070, 
5, // chain 275
4121,5406,4071, 4105,5379,4055, 4106,5380,4056, 
4118,5403,4068, 36744,5186,3926, 36875,5381,4057, 3975,5185,3925, 
37, // chain 276
4122,5407,4072, 4123,5408,4073, 4124,5409,4074, 
4125,5410,4075, 36894,5411,4076, 36895,5412,4077, 36896,5413,4078, 36897,5414,4079, 36891,5408,4073, 4130,5415,4080, 36899,5416,4081, 36890,5407,4072, 4132,5417,4082, 36893,5410,4075, 4133,5418,4083, 36902,5419,4084, 36894,5411,4076, 3616,5420,3566, 36383,5421,3565, 
36382,5422,3564, 36903,5423,4085, 36895,5412,4077, 4136,5424,4086, 36896,5413,4078, 4137,5425,4087, 36889,5426,4071, 36897,5414,4079, 4138,5427,4088, 36898,5415,4080, 4131,5416,4081, 4132,5417,4082, 4139,5428,4089, 36901,5418,4083, 4134,5419,4084, 4140,5429,4090, 
36384,5420,3566, 3617,5430,3567, 4141,5431,4091, 36394,5432,3576, 
4, // chain 277
4138,5427,4088, 4139,5428,4089, 4097,5433,4047, 
36910,5434,4092, 36908,5429,4090, 4141,5431,4091, 
3, // chain 278
4097,5433,4047, 4096,5435,4046, 4138,5427,4088, 
36889,5426,4071, 36873,5436,4055, 
4, // chain 279
4143,5437,4093, 4136,5424,4086, 4137,5425,4087, 
4144,5438,4094, 36886,5439,4068, 36889,5426,4071, 
5, // chain 280
4145,5440,4095, 4143,5437,4093, 4144,5438,4094, 
4146,5441,4096, 36915,5442,4097, 36888,5443,4070, 36886,5439,4068, 
8, // chain 281
4145,5440,4095, 4146,5441,4096, 3622,5444,3572, 
3620,5445,3570, 4143,5437,4093, 36387,5446,3569, 4136,5424,4086, 36381,5447,3563, 4135,5423,4085, 36382,5422,3564, 
2, // chain 282
3865,5064,3815, 2914,3894,2864, 2915,3895,2865, 
2920,3908,2870, 
15, // chain 283
3996,5448,3946, 3995,5449,3945, 4148,5450,4098, 
4149,5451,4099, 36918,5452,4100, 36919,5453,4101, 36763,5449,3945, 4004,5454,3954, 4103,5455,4053, 4101,5456,4051, 4152,5457,4102, 36868,5458,4050, 4153,5459,4103, 36866,5460,4048, 4141,5461,4091, 36910,5462,4092, 36865,5463,4047, 
15, // chain 284
4001,5464,3951, 3996,5448,3946, 4149,5451,4099, 
3658,5465,3608, 36429,5466,3611, 36922,5467,4104, 36918,5452,4100, 4155,5468,4105, 36924,5469,4106, 36919,5453,4101, 4152,5457,4102, 4157,5470,4107, 36921,5459,4103, 4141,5461,4091, 3626,5471,3576, 4156,5469,4106, 36923,5468,4105, 
3, // chain 285
4158,5472,4108, 3642,5473,3592, 3641,5474,3591, 
4154,5467,4104, 36429,5466,3611, 
3, // chain 286
4158,5472,4108, 4154,5467,4104, 3634,5475,3584, 
3752,5476,3702, 36295,5477,3477, 
3, // chain 287
4002,5478,3952, 4001,5464,3951, 3658,5465,3608, 
4003,5479,3953, 36427,5480,3609, 
1, // chain 288
4004,5454,3954, 3659,5480,3609, 4104,5481,4054, 
2, // chain 289
3749,5482,3699, 3642,5473,3592, 4158,5472,4108, 
3752,5476,3702, 
2, // chain 290
4155,5468,4105, 3625,5483,3575, 3634,5475,3584, 
4154,5467,4104, 
1, // chain 291
3626,5432,3576, 3625,5484,3575, 4155,5485,4105, 

 0};


// face array: 8kb.
const uint16_t nanosuit_7_face[4407] PROGMEM = {
1, // chain 0
4159,5486,4109, 4160,5487,4109, 4161,5488,4109, 
1, // chain 1
4162,5489,4110, 4163,5490,4110, 4164,5491,4110, 
8, // chain 2
4165,5492,4111, 4166,5493,4112, 4167,5494,4113, 
4168,5495,4114, 36937,5496,4115, 36938,5497,4116, 36939,5498,4117, 36940,5499,4118, 36934,5493,4112, 4173,5500,4119, 
2, // chain 3
4174,5501,4120, 4175,5502,4121, 4166,5493,4112, 
4165,5492,4111, 
10, // chain 4
4176,5503,4122, 4165,5492,4111, 4168,5495,4114, 
4177,5504,4123, 36946,5505,4124, 36947,5506,4125, 36948,5507,4126, 36937,5496,4115, 4181,5508,4127, 4182,5509,4128, 4183,5510,4129, 36952,5511,4130, 
37, // chain 5
4183,5510,4129, 4185,5512,4131, 4186,5513,4132, 
4180,5507,4126, 36947,5506,4125, 36955,5514,4133, 36956,5515,4134, 36953,5512,4131, 4189,5516,4135, 36958,5517,4136, 4191,5518,4137, 36960,5519,4138, 36961,5520,4139, 4194,5521,4140, 4195,5522,4141, 36964,5523,4142, 4197,5524,4143, 36966,5525,4144, 4199,5526,4145, 
4200,5527,4146, 36969,5528,4147, 4202,5529,4148, 36971,5530,4149, 4204,5531,4150, 4205,5532,4151, 4206,5533,4152, 36975,5534,4153, 4208,5535,4154, 4209,5536,4155, 36978,5537,4156, 36979,5538,4157, 4212,5539,4158, 4213,5540,4159, 36982,5541,4160, 4215,5542,4161, 
4216,5543,4162, 36985,5544,4163, 36986,5545,4164, 36987,5546,4165, 
26, // chain 6
4176,5503,4122, 4177,5504,4123, 4220,5547,4166, 
36989,5548,4167, 36990,5549,4168, 36991,5550,4169, 36946,5505,4124, 4224,5551,4170, 36993,5552,4171, 36947,5506,4125, 4187,5514,4133, 4226,5553,4172, 36995,5554,4173, 36956,5515,4134, 4189,5516,4135, 4228,5555,4174, 36997,5556,4175, 36959,5518,4137, 4230,5557,4176, 
36960,5519,4138, 4231,5558,4177, 36963,5522,4141, 4232,5559,4178, 36965,5524,4143, 4200,5527,4146, 4209,5536,4155, 36974,5533,4152, 36970,5529,4148, 
8, // chain 7
4233,5560,4179, 4221,5548,4167, 4222,5549,4168, 
4234,5561,4180, 36991,5550,4169, 4224,5551,4170, 4235,5562,4181, 37004,5563,4182, 36994,5553,4172, 36993,5552,4171, 
8, // chain 8
4237,5564,4183, 4236,5563,4182, 4238,5565,4184, 
4239,5566,4185, 37008,5567,4186, 37009,5568,4187, 36996,5555,4174, 36995,5554,4173, 36994,5553,4172, 37004,5563,4182, 
12, // chain 9
4236,5563,4182, 4237,5564,4183, 4242,5569,4188, 
37007,5566,4185, 4243,5570,4189, 36985,5544,4163, 36984,5543,4162, 37008,5567,4186, 4244,5571,4190, 37013,5572,4191, 37009,5568,4187, 4246,5573,4192, 36997,5556,4175, 36996,5555,4174, 
1, // chain 10
4236,5563,4182, 4242,5569,4188, 4235,5562,4181, 
1, // chain 11
4217,5544,4163, 4218,5545,4164, 4243,5570,4189, 
17, // chain 12
4246,5573,4192, 4229,5556,4175, 4230,5557,4176, 
4247,5574,4193, 36999,5558,4177, 4248,5575,4194, 37000,5559,4178, 4209,5536,4155, 4210,5537,4156, 4249,5576,4195, 36981,5540,4159, 4216,5543,4162, 4244,5571,4190, 4250,5577,4196, 37013,5572,4191, 4246,5573,4192, 4247,5574,4193, 4249,5576,4195, 37016,5575,4194, 
20, // chain 13
4251,5578,4197, 4252,5579,4198, 4253,5580,4199, 
4254,5581,4200, 37023,5582,4201, 4256,5583,4202, 4257,5584,4203, 37026,5585,4204, 37027,5586,4205, 4260,5587,4206, 37029,5588,4207, 4262,5589,4208, 4263,5590,4209, 4264,5591,4210, 37033,5592,4211, 37034,5593,4212, 4267,5594,4213, 4268,5595,4214, 37037,5596,4215, 
37038,5597,4216, 4271,5598,4217, 37040,5599,4218, 
6, // chain 14
4254,5581,4200, 4257,5584,4203, 4251,5578,4197, 
37041,5600,4219, 37042,5601,4220, 37032,5591,4210, 37026,5585,4204, 4260,5587,4206, 
15, // chain 15
4251,5578,4197, 4273,5600,4219, 4275,5602,4221, 
37044,5603,4222, 37042,5601,4220, 4277,5604,4223, 37046,5605,4224, 37032,5591,4210, 4265,5592,4211, 4279,5606,4225, 37036,5595,4214, 4269,5596,4215, 4280,5607,4226, 37049,5608,4227, 37050,5609,4228, 37051,5610,4229, 37039,5598,4217, 
10, // chain 16
4252,5579,4198, 4251,5578,4197, 4275,5602,4221, 
4284,5611,4230, 37053,5612,4231, 37054,5613,4232, 37044,5603,4222, 4287,5614,4233, 37045,5604,4223, 4280,5607,4226, 37047,5606,4225, 37046,5605,4224, 
4, // chain 17
4288,5615,4234, 4284,5611,4230, 4285,5612,4231, 
4289,5616,4235, 37058,5617,4236, 4291,5618,4237, 
2, // chain 18
4292,5619,4238, 4288,5615,4234, 4289,5616,4235, 
4293,5620,4239, 
9, // chain 19
4294,5621,4240, 4285,5612,4231, 4286,5613,4232, 
4295,5622,4241, 37064,5623,4242, 37055,5614,4233, 4297,5624,4243, 37048,5607,4226, 4281,5608,4227, 4298,5625,4244, 37050,5609,4228, 
1, // chain 20
4299,5626,4245, 4295,5622,4241, 4296,5623,4242, 
17, // chain 21
4300,5627,4246, 4301,5628,4247, 4302,5629,4248, 
4303,5630,4249, 37072,5631,4250, 37073,5632,4251, 37074,5633,4252, 37075,5634,4253, 37076,5635,4254, 37069,5628,4247, 4309,5636,4255, 37078,5637,4256, 37079,5638,4257, 37080,5639,4258, 37081,5640,4259, 37068,5627,4246, 4314,5641,4260, 37083,5642,4261, 37071,5630,4249, 
20, // chain 22
4316,5643,4262, 4305,5632,4251, 4306,5633,4252, 
4317,5644,4263, 37086,5645,4264, 37087,5646,4265, 37075,5634,4253, 4320,5647,4266, 37076,5635,4254, 4321,5648,4267, 37077,5636,4255, 4322,5649,4268, 37078,5637,4256, 4323,5650,4269, 37092,5651,4270, 37079,5638,4257, 4284,5652,4230, 4288,5653,4234, 4323,5650,4269, 
37060,5654,4238, 4325,5655,4271, 37061,5656,4239, 
15, // chain 23
4326,5657,4272, 4327,5658,4273, 4317,5644,4263, 
4318,5645,4264, 4328,5659,4274, 37097,5660,4275, 37087,5646,4265, 4330,5661,4276, 37088,5647,4266, 4321,5648,4267, 4331,5662,4277, 37090,5649,4268, 4323,5650,4269, 4332,5663,4278, 37093,5655,4271, 4333,5664,4279, 37102,5665,4280, 
5, // chain 24
4335,5666,4281, 4336,5667,4282, 4337,5668,4283, 
4338,5669,4284, 4328,5659,4274, 37095,5658,4273, 4326,5657,4272, 
13, // chain 25
4333,5664,4279, 4339,5670,4285, 4332,5663,4278, 
37108,5671,4286, 4331,5662,4277, 37098,5661,4276, 37109,5672,4287, 37110,5673,4288, 37107,5674,4285, 4343,5675,4289, 37112,5676,4290, 37101,5677,4279, 4334,5678,4280, 4345,5679,4291, 37114,5680,4292, 
30, // chain 26
4347,5681,4293, 4348,5682,4294, 4349,5683,4295, 
4350,5684,4296, 37119,5685,4297, 37120,5686,4298, 37121,5687,4299, 37122,5688,4300, 37123,5689,4301, 37116,5682,4294, 4356,5690,4302, 37125,5691,4303, 37126,5692,4304, 37115,5681,4293, 4359,5693,4305, 37128,5694,4306, 37118,5684,4296, 4361,5695,4307, 37130,5696,4308, 
37119,5685,4297, 4363,5697,4309, 37120,5686,4298, 4364,5698,4310, 37133,5699,4311, 37121,5687,4299, 4366,5700,4312, 37135,5701,4313, 37122,5688,4300, 4368,5702,4314, 37059,5703,4237, 37124,5690,4302, 37123,5689,4301, 
3, // chain 27
4294,5704,4240, 4367,5701,4313, 4368,5702,4314, 
4290,5705,4236, 37059,5703,4237, 
33, // chain 28
4367,5701,4313, 4294,5704,4240, 4369,5706,4315, 
37063,5707,4241, 4299,5708,4245, 4370,5709,4316, 37139,5710,4317, 4372,5711,4318, 4373,5712,4319, 37142,5713,4320, 37143,5714,4321, 4376,5715,4322, 4377,5716,4323, 37146,5717,4324, 4379,5718,4325, 4380,5719,4326, 4381,5720,4327, 37150,5721,4328, 4383,5722,4329, 
37152,5723,4330, 4385,5724,4331, 4386,5725,4332, 37155,5726,4333, 4388,5727,4334, 37157,5728,4335, 4390,5729,4336, 4391,5730,4337, 37130,5696,4308, 37160,5731,4338, 4361,5695,4307, 37161,5732,4339, 37162,5733,4340, 4395,5734,4341, 37164,5735,4342, 37165,5736,4343, 
1, // chain 29
4290,5705,4236, 4285,5737,4231, 4294,5704,4240, 
8, // chain 30
4398,5738,4344, 4367,5701,4313, 4369,5706,4315, 
4370,5709,4316, 4399,5739,4345, 37141,5712,4319, 4400,5740,4346, 37149,5720,4327, 37142,5713,4320, 4377,5716,4323, 
9, // chain 31
4366,5700,4312, 4367,5701,4313, 4398,5738,4344, 
4401,5741,4347, 37170,5742,4348, 37167,5739,4345, 4403,5743,4349, 37168,5740,4346, 4386,5725,4332, 37151,5722,4329, 37149,5720,4327, 
7, // chain 32
4366,5700,4312, 4401,5741,4347, 4365,5699,4311, 
37132,5698,4310, 37170,5742,4348, 4404,5744,4350, 37171,5743,4349, 4388,5727,4334, 37154,5725,4332, 
3, // chain 33
4404,5744,4350, 4388,5727,4334, 4391,5730,4337, 
4363,5697,4309, 37130,5696,4308, 
4, // chain 34
4405,5745,4351, 4406,5746,4352, 4407,5747,4353, 
37176,5748,4354, 37126,5692,4304, 37125,5691,4303, 
6, // chain 35
4408,5748,4354, 4358,5692,4304, 4409,5749,4355, 
37127,5693,4305, 4410,5750,4356, 37128,5694,4306, 4393,5732,4339, 37129,5695,4307, 
3, // chain 36
4411,5751,4357, 4409,5749,4355, 4410,5750,4356, 
4395,5734,4341, 37161,5732,4339, 
3, // chain 37
4412,5752,4358, 4411,5751,4357, 4395,5734,4341, 
4413,5753,4359, 37164,5735,4342, 
5, // chain 38
4414,5754,4360, 4415,5755,4361, 4416,5756,4362, 
4417,5757,4363, 37186,5758,4364, 37187,5759,4365, 37188,5760,4366, 
11, // chain 39
4421,5761,4367, 4414,5754,4360, 4417,5757,4363, 
4422,5762,4368, 37180,5752,4358, 37179,5751,4357, 37186,5758,4364, 4423,5763,4369, 4424,5764,4370, 37193,5765,4371, 4426,5766,4372, 4407,5747,4353, 37173,5745,4351, 
3, // chain 40
4411,5751,4357, 4424,5764,4370, 4409,5749,4355, 
37176,5748,4354, 37175,5747,4353, 
6, // chain 41
4427,5767,4373, 4428,5768,4374, 4161,5488,4375, 
4429,5769,4376, 37114,5770,4292, 37113,5771,4291, 37198,5772,4377, 36928,5487,4378, 
47, // chain 42
4431,5773,4379, 4161,5488,4375, 4428,5768,4374, 
4432,5774,4380, 37201,5775,4381, 37195,5767,4373, 4429,5769,4376, 4434,5776,4382, 37203,5777,4383, 37204,5778,4384, 37114,5770,4292, 4334,5779,4280, 4325,5780,4271, 4293,5781,4239, 4437,5782,4385, 37206,5783,4386, 37057,5784,4235, 4439,5785,4387, 37059,5786,4237, 
4356,5787,4302, 4357,5788,4303, 4440,5789,4388, 37209,5790,4389, 37174,5791,4352, 4442,5792,4390, 37173,5793,4351, 4443,5794,4391, 37212,5795,4392, 4445,5796,4393, 37214,5797,4394, 4447,5798,4395, 4272,5799,4218, 4270,5800,4216, 4448,5801,4396, 37035,5802,4213, 
4449,5803,4397, 37034,5804,4212, 4263,5805,4209, 4450,5806,4398, 37030,5807,4208, 4451,5808,4399, 37220,5809,4400, 37221,5810,4401, 37029,5811,4207, 4454,5812,4402, 37223,5813,4403, 4456,5814,4404, 37225,5815,4405, 37226,5816,4406, 
2, // chain 43
4161,5488,4375, 4431,5773,4379, 4459,5817,4407, 
4159,5486,4408, 
17, // chain 44
4460,5818,4409, 4461,5819,4410, 4462,5820,4411, 
4463,5821,4412, 37232,5822,4413, 37233,5823,4414, 37234,5824,4415, 37229,5819,4410, 4467,5825,4416, 37236,5826,4417, 37237,5827,4418, 37238,5828,4419, 37228,5818,4409, 4471,5829,4420, 37231,5821,4412, 4472,5830,4421, 37241,5831,4422, 37242,5832,4423, 37232,5822,4413, 
20, // chain 45
4475,5833,4424, 4469,5827,4418, 4470,5828,4419, 
4476,5834,4425, 37239,5829,4420, 4472,5830,4421, 4477,5835,4426, 37246,5836,4427, 37241,5831,4422, 4479,5837,4428, 37248,5838,4429, 37242,5832,4423, 4481,5839,4430, 4482,5840,4431, 4483,5841,4432, 37252,5842,4433, 37253,5843,4434, 4486,5844,4435, 4487,5845,4436, 
4488,5846,4437, 37104,5667,4282, 37105,5668,4283, 
13, // chain 46
4458,5847,4406, 4475,5833,4424, 4476,5834,4425, 
4457,5848,4405, 37245,5835,4426, 4489,5849,4438, 37258,5850,4439, 37259,5851,4440, 37246,5836,4427, 4479,5837,4428, 4492,5852,4441, 37248,5838,4429, 4483,5841,4432, 4488,5846,4437, 37252,5842,4433, 
7, // chain 47
4493,5853,4442, 4492,5852,4441, 4488,5846,4437, 
4494,5854,4443, 37104,5667,4282, 4335,5666,4281, 4341,5672,4287, 37097,5660,4275, 37096,5659,4274, 
5, // chain 48
4495,5855,4444, 4493,5853,4442, 4343,5675,4289, 
4496,5856,4445, 36927,5857,4446, 37112,5676,4290, 4160,5858,4378, 
3, // chain 49
4493,5853,4442, 4494,5854,4443, 4343,5675,4289, 
37109,5672,4287, 4342,5673,4288, 
10, // chain 50
4491,5851,4440, 4492,5852,4441, 4497,5859,4447, 
37266,5860,4448, 37261,5853,4442, 4495,5855,4444, 4499,5861,4449, 37268,5862,4450, 37264,5856,4445, 4501,5863,4451, 36928,5858,4452, 36927,5857,4446, 
12, // chain 51
4502,5864,4453, 4491,5851,4440, 4497,5859,4447, 
4503,5865,4454, 37266,5860,4448, 4504,5866,4455, 37267,5861,4449, 4503,5865,4454, 37270,5864,4453, 37273,5867,4456, 37268,5862,4450, 4506,5868,4457, 37275,5869,4458, 37269,5863,4451, 
6, // chain 52
4508,5870,4459, 4502,5864,4453, 4505,5867,4456, 
4509,5871,4460, 37274,5868,4457, 4510,5872,4461, 37279,5873,4462, 37275,5869,4458, 
1, // chain 53
4329,5660,4275, 4330,5661,4276, 4341,5672,4287, 
1, // chain 54
4363,5697,4309, 4364,5698,4310, 4404,5744,4350, 
3, // chain 55
4512,5874,4463, 4513,5875,4464, 4435,5777,4383, 
4437,5782,4385, 37204,5778,4384, 
22, // chain 56
4514,5876,4465, 4435,5777,4383, 4513,5875,4464, 
4515,5877,4466, 37284,5878,4467, 37285,5879,4468, 37286,5880,4469, 37280,5874,4463, 4519,5881,4470, 37205,5782,4385, 4438,5783,4386, 4439,5785,4387, 4440,5789,4388, 4518,5880,4469, 37285,5879,4468, 37288,5882,4471, 37209,5790,4389, 4442,5792,4390, 4516,5878,4467, 
37289,5883,4472, 37290,5884,4473, 37211,5794,4391, 4448,5801,4396, 37213,5796,4393, 
8, // chain 57
4523,5885,4474, 4432,5774,4380, 4515,5877,4466, 
4451,5808,4399, 37284,5878,4467, 4450,5806,4398, 37289,5883,4472, 4449,5803,4397, 37216,5801,4396, 37290,5884,4473, 
3, // chain 58
4453,5810,4401, 4432,5774,4380, 4523,5885,4474, 
4451,5808,4399, 4452,5809,4400, 
6, // chain 59
4432,5774,4380, 4453,5810,4401, 4454,5812,4402, 
4431,5773,4379, 37224,5814,4404, 4459,5886,4407, 37257,5887,4438, 37225,5815,4405, 
4, // chain 60
4515,5877,4466, 4432,5774,4380, 4514,5876,4465, 
37201,5775,4381, 4434,5776,4382, 4435,5777,4383, 
2, // chain 61
4430,5772,4377, 4160,5888,4378, 4344,5889,4290, 
4345,5771,4291, 
5, // chain 62
4297,5890,4243, 4298,5891,4244, 4524,5892,4475, 
4296,5893,4242, 37293,5894,4476, 37294,5895,4477, 37295,5896,4478, 
27, // chain 63
4299,5897,4245, 4296,5893,4242, 4371,5898,4317, 
37140,5899,4318, 37293,5894,4476, 4375,5900,4321, 37294,5895,4477, 4528,5901,4479, 37297,5902,4480, 37298,5903,4481, 4531,5904,4482, 37300,5905,4483, 4533,5906,4484, 4534,5907,4485, 37303,5908,4486, 4536,5909,4487, 37305,5910,4488, 4538,5911,4489, 4539,5912,4490, 
4534,5907,4485, 37308,5913,4491, 4541,5914,4492, 37310,5915,4493, 4543,5916,4494, 4544,5917,4495, 37146,5918,4324, 4376,5919,4322, 4528,5901,4479, 37143,5900,4321, 
4, // chain 64
4544,5917,4495, 4528,5901,4479, 4529,5902,4480, 
4531,5904,4482, 4534,5907,4485, 4541,5914,4492, 
1, // chain 65
4517,5879,4468, 4520,5882,4471, 4516,5878,4467, 
9, // chain 66
4311,5920,4257, 4312,5921,4258, 4253,5922,4199, 
37023,5923,4201, 37081,5924,4259, 4256,5925,4202, 37237,5926,4418, 37082,5927,4260, 4468,5928,4417, 37083,5929,4261, 4467,5930,4416, 
4, // chain 67
4545,5931,4496, 4261,5932,4207, 4259,5933,4205, 
4256,5925,4202, 4475,5934,4424, 37237,5926,4418, 
3, // chain 68
4455,5935,4403, 4261,5932,4207, 4545,5931,4496, 
4475,5934,4424, 4458,5936,4406, 
2, // chain 69
4253,5922,4199, 4252,5937,4198, 4311,5920,4257, 
37052,5938,4230, 
7, // chain 70
4546,5939,4497, 4547,5940,4498, 4548,5941,4499, 
4549,5942,4500, 37318,5943,4501, 37319,5944,4502, 37320,5945,4503, 37321,5946,4504, 37315,5940,4498, 
5, // chain 71
4554,5947,4505, 4555,5948,4506, 4556,5949,4507, 
4549,5942,4500, 37314,5939,4497, 37323,5948,4506, 4547,5940,4498, 
3, // chain 72
4557,5950,4508, 4554,5947,4505, 4549,5942,4500, 
4551,5944,4502, 37318,5943,4501, 
6, // chain 73
4508,5870,4459, 4509,5871,4460, 4558,5951,4509, 
4559,5952,4510, 4459,5953,4407, 4502,5864,4453, 37258,5850,4439, 37257,5849,4438, 
1, // chain 74
4558,5951,4509, 4509,5871,4460, 4510,5872,4461, 
1, // chain 75
4491,5851,4440, 4502,5864,4453, 4490,5850,4439, 
16, // chain 76
4560,5954,4511, 4561,5955,4512, 4562,5956,4513, 
37331,5957,4514, 4564,5958,4515, 37333,5959,4516, 4566,5960,4517, 4567,5961,4518, 37336,5962,4519, 4569,5963,4520, 37338,5964,4521, 4571,5965,4522, 4572,5966,4523, 37328,5954,4511, 4562,5956,4513, 4569,5963,4520, 37332,5958,4515, 4567,5961,4518, 
13, // chain 77
4573,5967,4524, 4574,5968,4525, 4575,5969,4526, 
4576,5970,4527, 37345,5971,4528, 37342,5968,4525, 4578,5972,4529, 4579,5973,4530, 4580,5974,4531, 37349,5975,4532, 4582,5976,4533, 37351,5977,4534, 4576,5970,4527, 37352,5978,4535, 4573,5967,4524, 
2, // chain 78
4580,5974,4531, 4582,5976,4533, 4576,5970,4527, 
4577,5971,4528, 
28, // chain 79
4585,5979,4536, 4586,5980,4537, 4587,5981,4538, 
4588,5982,4539, 37357,5983,4540, 37358,5984,4541, 37359,5985,4542, 37354,5980,4537, 4592,5986,4543, 37361,5987,4544, 37362,5988,4545, 37353,5979,4536, 4595,5989,4546, 37364,5990,4547, 37356,5982,4539, 4597,5991,4548, 36931,5992,4549, 37357,5983,4540, 4598,5993,4550, 
37367,5994,4551, 37368,5995,4552, 37369,5996,4553, 37358,5984,4541, 4602,5997,4554, 37371,5998,4555, 37372,5999,4556, 37359,5985,4542, 4605,6000,4557, 37374,6001,4558, 37360,5986,4543, 
5, // chain 80
4605,6000,4557, 4606,6001,4558, 4607,6002,4559, 
4162,6003,4560, 4608,6004,4561, 37377,6005,4562, 37375,6002,4563, 
13, // chain 81
4610,6006,4564, 4608,6004,4561, 4611,6007,4565, 
4612,6008,4566, 37381,6009,4567, 37382,6010,4568, 37383,6011,4569, 37384,6012,4570, 37376,6004,4561, 4617,6013,4571, 37377,6005,4562, 4618,6014,4572, 37387,6015,4573, 37388,6016,4574, 4621,6017,4575, 
13, // chain 82
4612,6008,4566, 4613,6009,4567, 4622,6018,4576, 
37391,6019,4577, 37392,6020,4578, 37382,6010,4568, 4625,6021,4579, 37394,6022,4580, 37395,6023,4581, 37383,6011,4569, 4628,6024,4582, 37385,6025,4571, 4618,6026,4572, 4629,6027,4583, 37387,6028,4573, 
27, // chain 83
4604,5999,4556, 4605,6000,4557, 4608,6004,4561, 
4630,6029,4584, 37378,6006,4564, 4631,6030,4585, 37400,6031,4586, 37380,6008,4566, 4633,6032,4587, 37402,6033,4588, 37390,6018,4576, 4635,6034,4589, 37404,6035,4590, 37391,6019,4577, 4637,6036,4591, 37406,6037,4592, 37392,6020,4578, 4639,6038,4593, 37393,6021,4579, 
4640,6039,4594, 37394,6022,4580, 4641,6040,4595, 37410,6041,4596, 37395,6023,4581, 4643,6042,4597, 37396,6024,4582, 4629,6027,4583, 4644,6043,4598, 37413,6044,4599, 
1, // chain 84
4616,6012,4570, 4617,6013,4571, 4615,6011,4569, 
9, // chain 85
4646,6045,4600, 4639,6038,4593, 4640,6039,4594, 
4647,6046,4601, 37409,6040,4595, 4648,6047,4602, 37410,6041,4596, 4643,6042,4597, 4649,6048,4603, 37418,6049,4604, 37412,6043,4598, 
8, // chain 86
4651,6050,4605, 4646,6045,4600, 4647,6046,4601, 
4652,6051,4606, 37421,6052,4607, 37422,6053,4608, 37416,6047,4602, 4649,6048,4603, 4655,6054,4609, 37418,6049,4604, 
9, // chain 87
4652,6051,4606, 4656,6055,4610, 4651,6050,4605, 
37425,6056,4611, 4658,6057,4612, 4646,6045,4600, 37427,6058,4613, 4660,6059,4614, 4638,6037,4592, 37429,6060,4615, 4637,6036,4591, 
6, // chain 88
4662,6061,4616, 4663,6062,4617, 4664,6063,4618, 
37433,6064,4619, 37434,6065,4620, 4667,6066,4621, 4668,6067,4622, 37437,6068,4623, 
7, // chain 89
4670,6069,4624, 4662,6061,4616, 4664,6063,4618, 
4671,6070,4625, 37433,6064,4619, 4672,6071,4626, 37441,6072,4627, 37442,6073,4628, 37436,6067,4622, 
30, // chain 90
4675,6074,4629, 4670,6069,4624, 4676,6075,4630, 
37439,6070,4625, 4677,6076,4631, 37440,6071,4626, 4678,6077,4632, 37447,6078,4633, 37441,6072,4627, 4674,6073,4628, 4680,6079,4634, 4681,6080,4635, 4682,6081,4636, 37451,6082,4637, 37452,6083,4638, 4685,6084,4639, 4686,6085,4640, 4687,6086,4641, 37456,6087,4642, 
4689,6088,4643, 37458,6089,4644, 37459,6090,4645, 4692,6091,4646, 4693,6092,4647, 37462,6093,4648, 4695,6094,4649, 37423,6095,4609, 4219,6096,4165, 37418,6097,4604, 4696,6098,4650, 37412,6099,4598, 4645,6100,4599, 
7, // chain 91
4677,6076,4631, 4678,6077,4632, 4697,6101,4651, 
4698,6102,4652, 37467,6103,4653, 37457,6088,4643, 37450,6081,4636, 37446,6077,4632, 4679,6078,4633, 
7, // chain 92
4676,6075,4630, 4677,6076,4631, 4698,6102,4652, 
4700,6104,4654, 37463,6094,4649, 37467,6103,4653, 4693,6092,4647, 37457,6088,4643, 4690,6089,4644, 
5, // chain 93
4676,6075,4630, 4700,6104,4654, 4675,6074,4629, 
36982,6105,4160, 36983,6106,4161, 36987,6096,4165, 37463,6094,4649, 
1, // chain 94
4675,6074,4629, 4214,6105,4160, 4212,6107,4158, 
2, // chain 95
4683,6082,4637, 4687,6086,4641, 4682,6081,4636, 
37457,6088,4643, 
2, // chain 96
4696,6098,4650, 4243,6108,4189, 4218,6109,4164, 
4219,6096,4165, 
2, // chain 97
4211,6110,4157, 4208,6111,4154, 4675,6112,4629, 
4212,6113,4158, 
29, // chain 98
4701,6114,4655, 4675,6112,4629, 4208,6111,4154, 
4207,6115,4153, 4702,6116,4656, 37471,6117,4657, 36973,6118,4151, 4704,6119,4658, 36972,6120,4150, 4705,6121,4659, 4706,6122,4660, 37475,6123,4661, 4708,6124,4662, 4709,6125,4663, 37478,6126,4664, 4711,6127,4665, 37480,6128,4666, 4713,6129,4667, 4714,6130,4668, 
4709,6125,4663, 37483,6131,4669, 4716,6132,4670, 37485,6133,4671, 4718,6134,4672, 4719,6135,4673, 37470,6116,4656, 4703,6117,4657, 4704,6119,4658, 4716,6132,4670, 37477,6125,4663, 37474,6122,4660, 
5, // chain 99
4702,6116,4656, 4720,6136,4674, 4721,6137,4675, 
4701,6114,4655, 37443,6112,4629, 37438,6138,4624, 37430,6139,4616, 
16, // chain 100
4722,6140,4676, 4723,6141,4677, 4724,6142,4678, 
4685,6143,4639, 37493,6144,4679, 37494,6145,4680, 37495,6146,4681, 37491,6141,4677, 4728,6147,4682, 37497,6148,4683, 37498,6149,4684, 37499,6150,4685, 37500,6151,4686, 37490,6140,4676, 4733,6152,4687, 37502,6153,4688, 37452,6154,4638, 37453,6143,4639, 
4, // chain 101
4735,6155,4689, 4725,6144,4679, 4726,6145,4680, 
4736,6156,4690, 36931,6157,4549, 37495,6146,4681, 
9, // chain 102
4737,6158,4691, 4738,6159,4692, 4729,6148,4683, 
4739,6160,4693, 37498,6149,4684, 4740,6161,4694, 37509,6162,4695, 37499,6150,4685, 4742,6163,4696, 37501,6152,4687, 37500,6151,4686, 
7, // chain 103
4728,6147,4682, 4729,6148,4683, 4738,6159,4692, 
4164,5491,4697, 37505,6158,4691, 4621,6164,4575, 37511,6165,4698, 37508,6161,4694, 37507,6160,4693, 
1, // chain 104
4735,6155,4689, 4744,6166,4699, 4725,6144,4679, 
17, // chain 105
4619,6167,4573, 4621,6164,4575, 4743,6165,4698, 
4629,6168,4583, 37413,6169,4599, 37513,6170,4700, 37508,6161,4694, 4746,6171,4701, 37509,6162,4695, 4747,6172,4702, 37516,6173,4703, 37510,6163,4696, 4749,6174,4704, 37518,6175,4705, 37519,6176,4706, 37520,6177,4707, 37501,6152,4687, 4684,6154,4638, 37502,6153,4688, 
7, // chain 106
4747,6172,4702, 4748,6173,4703, 4753,6178,4708, 
4754,6179,4709, 37523,6180,4710, 37003,6181,4181, 37524,6182,4711, 37517,6174,4704, 37516,6173,4703, 
3, // chain 107
4234,6183,4180, 4235,6181,4181, 4756,6182,4711, 
4750,6175,4705, 37517,6174,4704, 
3, // chain 108
4754,6179,4709, 4757,6184,4712, 4745,6170,4700, 
4746,6171,4701, 4747,6172,4702, 
5, // chain 109
4754,6179,4709, 4755,6180,4710, 4757,6184,4712, 
37464,6185,4650, 37011,6186,4189, 37010,6187,4188, 37003,6181,4181, 
6, // chain 110
4750,6175,4705, 4751,6176,4706, 4758,6188,4713, 
37527,6189,4714, 37528,6190,4715, 37520,6177,4707, 4681,6191,4635, 37452,6154,4638, 
8, // chain 111
4750,6175,4705, 4758,6188,4713, 4761,6192,4716, 
37527,6189,4714, 4762,6193,4717, 37436,6194,4622, 37442,6195,4628, 37528,6190,4715, 4680,6196,4634, 37449,6191,4635, 
8, // chain 112
4762,6193,4717, 4668,6194,4622, 4669,6197,4623, 
4763,6198,4718, 4764,6199,4719, 4765,6200,4720, 4761,6192,4716, 37001,6201,4179, 4750,6175,4705, 37002,6183,4180, 
2, // chain 113
4757,6184,4712, 4696,6185,4650, 4645,6169,4599, 
4745,6170,4700, 
4, // chain 114
4621,6164,4575, 4620,6202,4574, 4164,5491,4697, 
37534,6203,4721, 37377,6204,4562, 4607,6205,4563, 
2, // chain 115
4766,6203,4721, 4607,6206,4563, 4164,5491,4697, 
36930,5489,4722, 
4, // chain 116
4600,5995,4552, 4601,5996,4553, 4603,5998,4555, 
4767,6207,4723, 37398,6029,4584, 37372,5999,4556, 
1, // chain 117
4601,5996,4553, 4602,5997,4554, 4603,5998,4555, 
6, // chain 118
4599,5994,4551, 4600,5995,4552, 4767,6207,4723, 
4768,6208,4724, 37537,6209,4725, 37538,6210,4726, 37399,6030,4585, 37398,6029,4584, 
10, // chain 119
4768,6208,4724, 4769,6209,4725, 4771,6211,4727, 
37540,6212,4728, 37541,6213,4729, 37542,6214,4730, 37538,6210,4726, 4775,6215,4731, 37399,6030,4585, 4776,6216,4732, 37400,6031,4586, 4633,6032,4587, 
3, // chain 120
4775,6215,4731, 4776,6216,4732, 4777,6217,4733, 
4778,6218,4734, 4774,6214,4730, 
1, // chain 121
4635,6034,4589, 4636,6035,4590, 4637,6036,4591, 
1, // chain 122
4638,6037,4592, 4639,6038,4593, 4646,6045,4600, 
8, // chain 123
4779,6219,4735, 4780,6220,4736, 4781,6221,4737, 
4782,6222,4738, 37512,6223,4699, 4735,6224,4689, 4783,6225,4739, 37504,6226,4690, 4598,5993,4550, 36931,5992,4549, 
9, // chain 124
4780,6220,4736, 4779,6219,4735, 4784,6227,4740, 
37553,6228,4741, 37554,6229,4742, 37550,6222,4738, 4787,6230,4743, 37551,6225,4739, 4788,6231,4744, 37367,5994,4551, 37366,5993,4550, 
12, // chain 125
4789,6232,4745, 4780,6220,4736, 4784,6227,4740, 
4790,6233,4746, 37559,6234,4747, 37560,6235,4748, 37553,6228,4741, 4793,6236,4749, 37554,6229,4742, 4787,6230,4743, 4771,6211,4727, 37556,6231,4744, 4768,6208,4724, 37367,5994,4551, 
5, // chain 126
4794,6237,4750, 4791,6234,4747, 4792,6235,4748, 
4795,6238,4751, 37561,6236,4749, 4772,6212,4728, 37539,6211,4727, 
13, // chain 127
4796,6239,4752, 4797,6240,4753, 4798,6241,4754, 
4799,6242,4755, 4800,6243,4756, 4801,6244,4757, 37570,6245,4758, 4803,6246,4759, 37572,6247,4760, 4805,6248,4761, 4806,6249,4762, 37575,6250,4763, 4797,6240,4753, 37576,6251,4764, 4798,6241,4754, 
2, // chain 128
4797,6240,4753, 4796,6239,4752, 4803,6246,4759, 
37569,6244,4757, 
1, // chain 129
4803,6246,4759, 4806,6249,4762, 4797,6240,4753, 
15, // chain 130
4809,6252,4765, 4810,6253,4766, 4811,6254,4767, 
37580,6255,4768, 37581,6256,4769, 4814,6257,4770, 4815,6258,4771, 37584,6259,4772, 4817,6260,4773, 37586,6261,4774, 4819,6262,4775, 37588,6263,4776, 4809,6252,4765, 4811,6254,4767, 4812,6255,4768, 4817,6260,4773, 37583,6258,4771, 
11, // chain 131
4821,6264,4777, 4822,6265,4778, 4823,6266,4779, 
4824,6267,4780, 37593,6268,4781, 37594,6269,4782, 37590,6265,4778, 4827,6270,4783, 37596,6271,4784, 37597,6272,4785, 37598,6273,4786, 37589,6264,4777, 4824,6267,4780, 
4, // chain 132
4826,6269,4782, 4827,6270,4783, 4828,6271,4784, 
4831,6274,4787, 4832,6275,4788, 4825,6268,4781, 
9, // chain 133
4691,6276,4645, 4688,6277,4642, 4652,6278,4606, 
37548,6279,4736, 37549,6280,4737, 37601,6281,4789, 37454,6282,4640, 4685,6283,4639, 4725,6284,4679, 4781,6280,4737, 37512,6285,4699, 
5, // chain 134
4691,6276,4645, 4652,6278,4606, 4653,6286,4607, 
4692,6287,4646, 37422,6288,4608, 4694,6289,4648, 37423,6290,4609, 
4, // chain 135
4656,6291,4610, 4652,6278,4606, 4780,6279,4736, 
4789,6292,4745, 4657,6293,4611, 37558,6294,4746, 
2, // chain 136
4164,5491,4697, 4163,5490,4549, 4727,6146,4681, 
4728,6147,4682, 

 0};


// mesh info for object nanosuit_7 (with tag [g nanosuit_arms])
const tgx::Mesh3D<tgx::RGB565> nanosuit_7 =
    {
    1, // version/id
    
    4834, // number of vertices
    6295, // number of texture coords
    4790, // number of normal vectors
    1149, // number of triangles
    4407, 
    
    nanosuit_vert_array, // array of vertices
    nanosuit_tex_array, // array of texture coords
    nanosuit_norm_array, // array of normal vectors        
    nanosuit_7_face, // array of face vertex indexes   
    
    &nanosuit_arms_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    nullptr, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.5301418095755412, 0.5301827638533233, 
    0.15170218911392186, 0.6866286438529786, 
    -0.2131597410827449, 0.14424877999361976
    },
    
    "nanosuit" // model name    
    };
    

// mesh info for object nanosuit_6 (with tag [g nanosuit_legs])
const tgx::Mesh3D<tgx::RGB565> nanosuit_6 =
    {
    1, // version/id
    
    4834, // number of vertices
    6295, // number of texture coords
    4790, // number of normal vectors
    2803, // number of triangles
    10454,
    
    nanosuit_vert_array, // array of vertices
    nanosuit_tex_array, // array of texture coords
    nanosuit_norm_array, // array of normal vectors        
    nanosuit_6_face, // array of face vertex indexes   
    
    &nanosuit_legs_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &nanosuit_7, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.32380553615616087, 0.32384487381771465, 
    -1.0000000000000002, 0.19554697671210447, 
    -0.20081687618012986, 0.17553299837045086
    },
    
    "nanosuit" // model name    
    };
    

// mesh info for object nanosuit_5 (with tag [g nanosuit_torso])
const tgx::Mesh3D<tgx::RGB565> nanosuit_5 =
    {
    1, // version/id
    
    4834, // number of vertices
    6295, // number of texture coords
    4790, // number of normal vectors
    1528, // number of triangles
    5950,
    
    nanosuit_vert_array, // array of vertices
    nanosuit_tex_array, // array of texture coords
    nanosuit_norm_array, // array of normal vectors        
    nanosuit_5_face, // array of face vertex indexes   
    
    &nanosuit_torso_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &nanosuit_6, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.24740209772121782, 0.24744520748730417, 
    0.08095044101290712, 0.8117067803040101, 
    -0.24833138261641796, 0.17269260365743255
    },
    
    "nanosuit" // model name    
    };
    

// mesh info for object nanosuit_4 (with tag [g nanosuit_helmet_pt])
const tgx::Mesh3D<tgx::RGB565> nanosuit_4 =
    {
    1, // version/id
    
    4834, // number of vertices
    6295, // number of texture coords
    4790, // number of normal vectors
    26, // number of triangles
    261, 
    
    nanosuit_vert_array, // array of vertices
    nanosuit_tex_array, // array of texture coords
    nanosuit_norm_array, // array of normal vectors        
    nanosuit_4_face, // array of face vertex indexes   
    
    &nanosuit_helmet_pt_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &nanosuit_5, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.07691590577929526, 0.07918024624298388, 
    0.8162521662657458, 0.8313513618375107, 
    0.04742208987524034, 0.06175177612236276
    },
    
    "nanosuit" // model name    
    };
    

// mesh info for object nanosuit_3 (with tag [g nanosuit_visor])
const tgx::Mesh3D<tgx::RGB565> nanosuit_3 =
    {
    1, // version/id
    
    4834, // number of vertices
    6295, // number of texture coords
    4790, // number of normal vectors
    30, // number of triangles
    126, 
    
    nanosuit_vert_array, // array of vertices
    nanosuit_tex_array, // array of texture coords
    nanosuit_norm_array, // array of normal vectors        
    nanosuit_3_face, // array of face vertex indexes   
    
    &nanosuit_visor_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &nanosuit_4, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.08573185294396594, 0.08797894950122001, 
    0.8146571049205488, 0.8864063052343879, 
    0.028202678409766955, 0.09679031625324402
    },
    
    "nanosuit" // model name    
    };
    

// mesh info for object nanosuit_2 (with tag [g nanosuit_helmet])
const tgx::Mesh3D<tgx::RGB565> nanosuit_2 =
    {
    1, // version/id
    
    4834, // number of vertices
    6295, // number of texture coords
    4790, // number of normal vectors
    827, // number of triangles
    3329, 
    
    nanosuit_vert_array, // array of vertices
    nanosuit_tex_array, // array of texture coords
    nanosuit_norm_array, // array of normal vectors        
    nanosuit_2_face, // array of face vertex indexes   
    
    &nanosuit_helmet_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &nanosuit_3, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.10790967210711916, 0.1101578464085254, 
    0.6410648543321004, 1.0, 
    -0.1649387733547158, 0.10337694963917127
    },
    
    "nanosuit" // model name    
    };
    

// mesh info for object nanosuit_1 (with tag [ | o Nanosuit | g nanosuit_hands])
const tgx::Mesh3D<tgx::RGB565> nanosuit_1 =
    {
    1, // version/id
    
    4834, // number of vertices
    6295, // number of texture coords
    4790, // number of normal vectors
    2444, // number of triangles
    9237, 
    
    nanosuit_vert_array, // array of vertices
    nanosuit_tex_array, // array of texture coords
    nanosuit_norm_array, // array of normal vectors        
    nanosuit_1_face, // array of face vertex indexes   
    
    &nanosuit_hands_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    &nanosuit_2, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.549127350559996, 0.549127350559996, 
    -0.04292439409223763, 0.20705728425717573, 
    0.04684549675383461, 0.24833138261641796
    },
    
    "nanosuit" // model name    
    };
    
                
/** end of nanosuit.h */
    
    
    