// 3D model [dennis]
//
// - vertices   : 3832
// - textures   : 4595
// - normals    : 3839
// - triangles  : 7657
//
// - memory size: 183kb
//
// - model bounding box: [-0.34,0.34]x[-1.0,1.0]x[-0.24,0.24]
//
// object [dennis] (tagged [ | o rp_dennis_posed_004_100k.001_rp_dennis_posed_004_100k | usemtl rp_dennis_posed_004]) with 7657 triangles (970 chains)

#pragma once

#include <tgx.h>

#include "dennis_texture.h" // texture for object [dennis]


// vertex array: 44kb.
const tgx::fVec3 dennis_vert_array[3832] PROGMEM = {
{0.07011262892710851,0.46270595751682164,0.1636933570086988},
{0.048189411470586356,0.5509693438205799,0.14971677168870742},
{0.027511928495268137,0.49463030745923586,0.16350745838114347},
{0.026673247905435293,0.44752957818105665,0.16811539390209765},
{0.023318525546103933,0.44571119045634894,0.1638012636833142},
{0.02484097120280686,0.42237770754940734,0.1669551300542525},
{0.025556787757186485,0.4256864894433083,0.15837922037961782},
{0.027340987228550613,0.4114011414603084,0.1549668053427693},
{0.023944597935456856,0.38917129810661166,0.16365382684077034},
{0.025781148169753233,0.39701643386602903,0.15648925099947225},
{0.06206343203054721,0.4436652371703237,0.16821368513046026},
{0.0258313621668515,0.37494043765237794,0.1744306053243931},
{0.07212332557687337,0.3903945965465591,0.1713622095868136},
{0.030736308138727388,0.32579375508817354,0.17982914420391582},
{0.024015111207977835,0.3292841620779621,0.17484834304493405},
{0.02276403481218897,0.36970642974207085,0.16622115099028412},
{0.029275828691209562,0.23604531652980676,0.1771357508701979},
{0.03300769022023646,0.22075675698775835,0.17702036551516356},
{0.02639974187868726,0.2210804770116046,0.18764970715624246},
{0.04311352423199294,0.21049707583595606,0.17523189251213148},
{0.03988059752519782,0.20699491663408096,0.17993491411269733},
{0.045387043079335984,0.19625232640380177,0.1738461998688026},
{0.05134327784152463,0.19487411244089176,0.17536116684508662},
{0.02948416336002154,0.19747989837541682,0.18852471276525276},
{0.03436881005647473,0.18077359470253013,0.19004288489028778},
{0.06041705395547408,0.17610582973822475,0.18272659867477783},
{0.0423026215980017,0.1729177751139431,0.19280999664527765},
{0.05509650702889122,0.1629999764955757,0.19539441492146317},
{0.04660286283886436,0.17202353861242684,0.20146496665576918},
{0.059485424051863585,0.1679327004232933,0.19908460951672768},
{0.07457205922260185,0.18011653920858464,0.18657598232467304},
{0.07145558625375803,0.20027051455458042,0.17051711869947883},
{0.08263835024583491,0.19245956704850659,0.18094560435216467},
{0.07558702299373715,0.20772996408096633,0.17771908794287145},
{0.08066291023233056,0.3278482554375349,0.16565490804428235},
{0.07926226022816386,0.3540749192836707,0.1668376079333842},
{0.07536373096408738,0.3374049406299613,0.17195943563740795},
{0.08322809761601035,0.3052679824870671,0.16954382186210595},
{0.0774449408863732,0.2708393429872413,0.17795413218460804},
{0.027649749891559137,0.2725167041669071,0.1860193548249241},
{0.07775156678354776,0.3958016824894177,0.16627457013613337},
{0.07491287337311993,0.3886520640089572,0.15587493082220613},
{0.07675049199033329,0.36946711196866633,0.15685036442541297},
{0.07584343489381341,0.3440096838227595,0.15582044329343991},
{0.07684985160161283,0.32805445334051275,0.15731511099430126},
{0.07554535605997474,0.3160981801165392,0.15824674089791174},
{0.0768786979403714,0.2960424959989059,0.15934290177073784},
{0.07535091036908358,0.2747635134413255,0.166919873417992},
{0.08293322393092263,0.27746438545546215,0.17200858125158922},
{0.08431784819133456,0.26425276230403183,0.17228101889542027},
{0.0854952061658515,0.2231691656143095,0.17920307181456294},
{0.08453366154056544,0.20069359418970636,0.18818817214640265},
{0.026017260794406808,0.21581869114545604,0.19951837298102337},
{0.029192494823684773,0.24029320700773715,0.19214759923674726},
{0.024424301865182903,0.2568232274993214,0.18310694299322433},
{0.026471323534125225,0.2821428342489375,0.17614749667198723},
{0.07062438434434408,0.5046186193501239,0.15426594614922748},
{0.07493210426562565,0.5300824577935328,0.14150838573751542},
{0.06847907144703919,0.5621061673472265,0.13570492973245554},
{0.07428893774960098,0.5514896463011514,0.1308192146530854},
{0.0730175620783894,0.4525552514225519,0.1563802759419398},
{0.0746660769192965,0.4977232760039059,0.15219755682194544},
{0.024124086265510252,0.1953709104972895,0.19899593373461796},
{0.08241078468451722,0.1874167996803399,0.187335602578649},
{0.03180682782154587,0.24856249078519735,0.17379919102045527},
{0.05989034117740071,0.5989546941540221,0.11180520387951205},
{0.05941277401350864,0.6146738120116155,0.11099323286260383},
{0.06350788573431027,0.601941892789911,0.12063325192255507},
{0.06976540447908854,0.5848082359502305,0.12217172332301277},
{0.05125353367649793,0.6090786906753675,0.1371857084553961},
{0.052439438714350736,0.6179548159496747,0.13628719842221212},
{0.0560633935687622,0.630574554965096,0.12988865313239187},
{0.059833716882800536,0.6278897086947139,0.1185744780415259},
{0.05598540161582233,0.6216236428865998,0.10651884520627271},
{0.033086750556093315,0.5995668775654545,0.12428818988155908},
{0.027335645313965692,0.5965775421637317,0.13367607057310196},
{0.033248076376557974,0.6177229768566892,0.12089821088596724},
{0.038149817199682905,0.617252888373216,0.11232764312591749},
{0.03720964023273654,0.6257358487340731,0.11472188924287977},
{0.0474693213845388,0.6271664134599153,0.13180640046837908},
{0.02682923181131503,0.5587461030733103,0.1483107797699558},
{0.023362329245700298,0.521923217456522,0.1512979784058445},
{0.023351645416530453,0.5427502740402183,0.1465383325106785},
{0.07027502313049015,0.4097237802806429,0.1551740716286643},
{0.07238614777445156,0.419231319858888,0.15570292117257162},
{0.07249832798073493,0.4493789490103568,0.162712581490907},
{0.06942245356273652,0.43113951585159727,0.15427128806381238},
{0.07120558465118368,0.5791319175122916,0.12017171050241776},
{0.03773955815956085,0.6285414222740744,0.10611072293198462},
{0.04622572366916883,0.8288995442278475,0.23240960946330852},
{0.06934339322687967,0.8696530105962218,0.23559980085342427},
{0.03278974010517162,0.8756840321625993,0.23373013074870141},
{0.014679581279367181,0.8624606567990821,0.22577922508050266},
{0.004220112522088819,0.8772684440284874,0.21866913676797073},
{-0.011265029476684677,0.847974452827689,0.1997235025010844},
{-0.01110370365622001,0.8811178276783826,0.1931657681566335},
{0.10346540682953097,0.8127220900988681,0.19928546550512077},
{0.11074857317461437,0.8489071511142163,0.1993335427363851},
{0.09545039818631317,0.8393226879659486,0.2180655004198745},
{0.09434034833556626,0.8249678950933446,0.21968623730494},
{0.08221527061070905,0.8407169276726132,0.22638713496026686},
{0.09859464911099858,0.8821327914495178,0.21888708688303557},
{0.06922266595726041,0.8283706946839403,0.23137648318258452},
{0.03746605213281282,0.8179796024333488,0.2250858445673797},
{0.008429541215007793,0.8348173172050247,0.2213133844875074},
{-0.017465923926862772,0.8359690339895341,0.19310487033036539},
{-0.018750120193078156,0.8570802804291481,0.16364741654326845},
{-0.018129389718310157,0.8244294301031844,0.17214106073329533},
{-0.005732942732538879,0.8298322425143752,0.2034970309638737},
{-0.011081267614963336,0.8222958694179663,0.19010805624822383},
{-0.01054921292230505,0.8151366354912529,0.18440182308860956},
{-0.023767246371237418,0.7973822481768046,0.15935785913157566},
{-0.008246847736203433,0.8057359342047062,0.1853655044797296},
{-0.008834458340544917,0.7881225734352997,0.19221811250926824},
{-0.016638995549116766,0.7768863902973736,0.17926183287499708},
{-0.019331320499917735,0.7718671273533804,0.16203950025320674},
{-0.021587745220589014,0.7541373128460225,0.1433801926080723},
{-0.022754419365936102,0.7529695703177584,0.1282337279939829},
{0.036196813227435225,0.7265944012461618,0.20170107928042275},
{0.072355164669859,0.722649931516655,0.18377254555050565},
{0.05611040241710952,0.7403316687927485,0.19485060801671808},
{0.03475449628950613,0.7387322995660228,0.19762092492045888},
{0.03885494992489268,0.7438584008017144,0.21023104848962706},
{0.07214148808646209,0.7520999066233329,0.19988162317279812},
{0.06718205458582001,0.7419363799340594,0.1893730088013385},
{0.07561480094957874,0.7415293260426883,0.1916946048799458},
{0.08777406692777946,0.7673841926337135,0.20793188845227642},
{0.09470359852734099,0.7391746100936544,0.17829815148387704},
{0.07616394976890878,0.7083389423436475,0.16731624348019325},
{0.0553668079068883,0.6922255911896871,0.182300313890901},
{0.04324600371369903,0.6994403810280835,0.18921061459795682},
{0.04901206631666443,0.7144842808821423,0.1896614721889243},
{0.023112327643125926,0.7140708166932694,0.18793069186340938},
{0.01341461590565752,0.7308807535091036,0.19425765549779167},
{0.022854847360132657,0.7406329527753382,0.19407923555065526},
{0.015173174187014022,0.7496020273634232,0.20117543488526635},
{0.032737389342239374,0.7582067833768165,0.21414560349745831},
{0.05389137109853268,0.7662794846975515,0.2101829712583628},
{0.055537749173605815,0.7768158770248528,0.2133314957147161},
{0.07388936253864875,0.7667698724564473,0.2134361972405806},
{-0.00808979544740671,0.7371083575322064,0.16252134094876677},
{-0.0017553531326055494,0.7571554945865038,0.17583446047731074},
{0.0037628446336194507,0.752162941215435,0.17196477755199288},
{0.0035619886452263622,0.7297322418733453,0.17300645089605274},
{0.003438056226856161,0.7015910358399733,0.16842736171385714},
{-0.0030299339525680703,0.714096457883277,0.14340262864932896},
{0.07854003337628232,0.804659004224386,0.21520116581943902},
{0.06726859360209575,0.8165372854954197,0.22129415359500168},
{0.06116919552903117,0.8012679568458771,0.21167550219339012},
{0.08555610399211962,0.7942956899296362,0.20862313219956538},
{0.05059327303380151,0.7868308984886656,0.21793729446983634},
{0.04722893522821728,0.8078545375290866,0.21119793502949805},
{0.0538422254843514,0.8125393966200638,0.21104195112361834},
{0.04952275335098302,0.8170031004472251,0.21323854640093848},
{0.07067780349019331,0.8228866851710587,0.2241766507050259},
{0.08031995931597852,0.8172413498377125,0.22275783819127049},
{0.08795141849199889,0.8116494336502156,0.21240093419402262},
{0.10728594414066758,0.7919805041485307,0.1910054978984908},
{0.03923422586042219,0.7647826802308562,0.2340196625192042},
{0.04332079051788794,0.781139622689889,0.22301425009134676},
{0.032392301660053385,0.7748682149671898,0.23883486432605336},
{0.013013972311788328,0.6997160238206656,0.18193920046496026},
{0.01481740267565818,0.7915157575796425,0.20812206061149965},
{0.02429395914931079,0.8127039275892795,0.2060632867304705},
{0.030954258253792232,0.814108851125114,0.22378455417449258},
{0.025415761212144526,0.7844035325012767,0.2345421017656096},
{0.016691346312049014,0.7853405043194721,0.2077759045463967},
{0.011596228180949884,0.7747528296121555,0.19790297801054282},
{-0.005817344982980658,0.7773660942270996,0.19280358634777575},
{0.012937048741765444,0.746579572091274,0.18446485768071164},
{0.011404987638809655,0.6909948140693208,0.1672083368055778},
{0.017721267444022082,0.6893484359942477,0.17609835105780594},
{0.04050453314871677,0.6850172116487925,0.17321585394778172},
{0.04536781218683026,0.6883121045647728,0.18342104757081776},
{0.05093942909890449,0.693471325670891,0.1486750983446475},
{0.019886879616749686,0.7647549022750145,0.20795859802520103},
{0.01209516300318165,0.7746994104663064,0.2106338288493302},
{0.016887928768774166,0.7681480864193574,0.2155815101378855},
{0.0251625544608192,0.7702143389808053,0.2175281038126313},
{0.02248411848793903,0.7655305482727452,0.2200505558796317},
{0.023693527949965494,0.759560424532636,0.2315313987055473},
{0.03437094682230869,0.760161924114898,0.22219373201110265},
{0.03620642867368808,0.767830776693013,0.21871507723340108},
{0.045050502460485864,0.7650893061280307,0.21880588978134477},
{-0.0026955300995519177,0.8247104148103511,0.2040216069761131},
{-0.00624469814977446,0.8222103987846077,0.19247666117517848},
{0.00016132582046466675,0.8121419581749455,0.1990418742000483},
{0.0052949057365752365,0.8245202426511281,0.2076412882988566},
{0.01814968899373287,0.8179817391991828,0.20276839381449027},
{0.019081318897343363,0.8238065628625824,0.21025775806255168},
{0.027523680707354965,0.8192007641074622,0.22068197018356958},
{0.021413598805120553,0.7693874106030593,0.23695451039216064},
{0.1031395500398507,0.7356436045530207,0.16996476473139785},
{0.11205413709916945,0.7459257217460794,0.15917730241860525},
{0.007969068177787468,0.8289721942662024,0.20920540088932196},
{0.079458842684889,0.708444712252429,0.14147740263292288},
{0.2471020113376795,0.04052055889247146,0.05574715222533479},
{0.2502131423919384,0.08701124152505253,0.034519452047769544},
{0.25230183099464315,0.08655397363658306,0.006312006273544496},
{0.2552644568234412,0.019898631828836395,0.028886937309427204},
{0.25569074160731803,0.07462761513428505,0.005590847804579951},
{0.25090011260755946,0.0839001104707936,0.0016164633533975721},
{0.25549309076767585,0.07388936253864864,-0.008385737515411416},
{0.2513691327081157,0.07470881223597584,-0.006508588730269631},
{0.26579123370448954,0.008230821992448598,0.026406152176189173},
{0.2740476968869459,-0.0064273916285788385,0.051122122577708845},
{0.250928958946318,0.015836639978461315,0.06029205315418689},
{0.25455825571531443,0.022004414558212924,0.04929091425799739},
{0.248241975910102,0.03149699677562034,0.06431771998538453},
{0.24974946420596714,0.018305672899612584,0.08301335264969648},
{0.2605465419650126,0.010705196828184708,0.07803468825654866},
{0.2731224772808373,0.00604918407596624,0.07934559409568866},
{0.2869954294578812,-0.010945582984506375,0.07644386609315872},
{0.29297303187840945,-0.02593179016104812,0.053639232730124345},
{0.2902668179496878,-0.03206003457287123,0.044014171031010886},
{0.28330309809678267,-0.018118705889140375,0.021963816007367576},
{0.28608730397844434,-0.0027339918845634575,0.00638145116314849},
{0.26046107133165386,0.009176340873979916,0.022370869898738675},
{0.24398767513466965,0.03383141344923148,0.05841383598612813},
{0.25177618659948675,0.04375775913093451,0.07392568755782623},
{0.2475037233144657,0.021711677638959172,0.08844928493131367},
{0.24377720370002373,-0.033555770656649615,0.11815887708681895},
{0.259827520261882,-0.020549277025280168,0.10081474881249239},
{0.26915877665882476,0.007242567794237975,0.08122274288083044},
{0.2793116195189285,0.008086590298655693,0.0931309388735398},
{0.3218994993557651,0.06073543206473535,-0.04214770607503893},
{0.3378857129426043,0.08145137682506515,-0.019449911003703007},
{0.3241943858614479,0.01946593674745768,-0.021084536866689308},
{0.3171772468626936,-0.00038889138178239496,-0.017644343873999182},
{0.32252236659636707,-0.007506458374733265,-0.006050252458883276},
{0.32841984029812155,0.009024630499768142,0.016099462176039598},
{0.3290320237095537,0.014705222469374802,0.03295320269147025},
{0.3369113477223145,0.06500362181808855,0.015446680213762063},
{0.32455763605322263,0.04739773972910078,0.057112545593240985},
{0.32977454983685794,0.0871522680700945,0.028250181090904436},
{0.31830118569136123,0.09233392521746916,0.05172255377705414},
{0.33133652566148925,0.1087432184394344,0.026745897943790245},
{0.29436086128757233,-0.03673955174926344,0.07815221037741696},
{0.29199011959478377,-0.019251191781143904,0.09360530088868092},
{0.29730532460678166,-0.0375878477853491,0.07398872214992833},
{0.29416855236251516,-0.03515941341504334,0.04990096090359554},
{0.28936617115066976,-0.05122575572065641,0.05214242826342905},
{0.27589279418457807,-0.06116171684861233,0.056930920497353626},
{0.26904980160129227,-0.06399613672737225,0.05316059718331529},
{0.28467169661343983,-0.04619580894749328,0.039799400423507},
{0.2934367100643807,-0.03792011487253135,0.022390100791244396},
{0.2907401115819119,-0.022018303536133887,0.01515714844325926},
{0.29661835439116063,-0.007616501815182632,0.00041560095470698205},
{0.31172315207148765,-0.01200328207232109,-0.006866497007459443},
{0.29184588790099086,-0.01117421692874111,-0.009792797817080017},
{0.2684643277627848,0.025612343668869577,-0.009216939424825365},
{0.2593787994367485,0.08156462541426544,-0.032963886520640084},
{0.25030822847155004,0.05415312491319381,0.06558268535909419},
{0.2576159676237241,0.055472577815669666,0.07752506960514705},
{0.26446750727034574,0.05061891422380907,0.08511272508157106},
{0.2510945582984506,0.026687136883356062,0.0995455099071148},
{0.2448263557245025,-0.0225140332096146,0.1255841383598613},
{0.23923657630283957,-0.03158460417481309,0.12553071921401207},
{0.24266181193469188,-0.03959427090344606,0.13148374882744976},
{0.2550454383254594,-0.03785921704626314,0.12065461958089475},
{0.26731902127577745,-0.01755032617730464,0.1041331461526463},
{0.271347893255726,0.002751086011235108,0.0934482485998842},
{0.29193349530018353,-0.022030055748220697,0.11001779925939698},
{0.2872764141650481,-0.03741904328446556,0.11349645403709854},
{0.2951717639215636,-0.027816417626608782,0.11854349493693338},
{0.29824015965914313,0.008958390758915096,0.10560751457808491},
{0.314663341859029,0.0043376346429570625,0.10649320401626507},
{0.29781280649234926,-0.04750778316955027,0.12629033946798804},
{0.29522304630157886,-0.04215197960670699,0.12432344651781957},
{0.2754942873565429,-0.0504864347421031,0.12050184082376597},
{0.27366307903683146,-0.051435158772385345,0.10425066827351459},
{0.2882785573411796,-0.03755045438325463,0.10304873749190702},
{0.28999758545460763,-0.0030961736934211836,0.10054124278574436},
{0.2839793844832339,0.02670743615877876,0.09832648499883546},
{0.300387609322282,0.031133746583845594,0.09680403934213254},
{0.2925809353478762,0.04689773652395201,0.08680611200499148},
{0.31698600632055335,0.0351262935446167,0.07495026677521438},
{0.3229700190385835,0.008525695677536381,0.08295459158926233},
{0.32330121774284876,-0.003177370795111969,0.09760318976403695},
{0.31572210932976075,-0.03418291142891953,0.10590025149733866},
{0.30766757051861443,-0.05413175725485422,0.1145552215078302},
{0.281002869676515,-0.0648305437855372,0.12531704263061516},
{0.25412983416560364,-0.06794381160563003,0.12539610296647202},
{0.2554343297072417,-0.060571969478436884,0.12349972328882451},
{0.3204219257815755,-0.0310397288871511,0.08052508883603955},
{0.3297670711564391,-0.01308662235014334,0.07115643903700239},
{0.3236708782321255,-0.008157103571176801,0.08553153118502897},
{0.31279367175430606,-0.026901881849670073,0.09267687613382138},
{0.32411212037684006,0.021498001055562294,0.059295251892640344},
{0.3250501605779524,-0.016020401840182833,0.059083712075077406},
{0.31361205306871626,-0.03568185266144873,0.06622798864095283},
{0.30697953192007643,-0.06584978108834043,0.08446207988512747},
{0.31301482701812194,-0.047432996365361337,0.09304546824018103},
{0.30538229945918455,-0.04951954820223207,0.1004215838990421},
{0.29555210824001005,0.10071325243537874,0.06217668061974757},
{0.27055408474840653,0.031238448109710003,0.1011106908804971},
{0.2533338888924502,-0.009699848503302435,0.12180526798248709},
{0.264658747812486,0.006550255664032032,0.1115819118498623},
{0.25924631995504244,-0.034166885685164655,0.12588542234245093},
{0.2536618824479644,-0.035534415818904895,0.13542501340820562},
{0.24252933245298583,-0.03298098064731191,0.13585770848958434},
{0.2582826385639224,0.08644713534488462,0.05026741624412123},
{0.25508924202505573,-0.06868206420126632,0.0874118851189217},
{0.2547185131528621,-0.06172582302878012,0.10095577535753435},
{0.27259896965151487,-0.05909439590424728,0.07972807517996912},
{0.2687634749795405,-0.06991711485330046,0.0823637758361699},
{0.2573648976382327,-0.07933704703235285,0.09075699203200022},
{0.27901674583384084,-0.07854751205670125,0.09182216980023378},
{0.2656694380519533,-0.07997380325087555,0.10082863779041319},
{0.2550411647937914,-0.07649087494150611,0.10411605202597454},
{0.26079120165300207,-0.0648123812759484,0.10591307209234249},
{0.2643756263394851,-0.07067139319269151,0.10843659254225989},
{0.2507398551700118,-0.06852394352955257,0.1144163317286222},
{0.2641138725248239,-0.07279427004873969,0.11503919896922417},
{0.25594929027322827,-0.05585399051703331,0.11102314758427939},
{0.264935458987985,-0.05854524708491723,0.10342587666160254},
{0.29481385564437373,-0.0383164849347325,0.0973798977343872},
{0.296454891804862,-0.026613418462084263,0.09432111744306053},
{0.2937155580057137,-0.03631326696538658,0.09088626636495534},
{0.283557373231025,-0.06697906183159302,0.10840454105475035},
{0.30846137902593396,-0.01676079120165304,0.009928482447537064},
{0.30227223678784265,-0.04288382190484131,0.02154073637224171},
{0.31187699921153345,-0.004840842996856885,0.004419900127564927},
{0.3172851535373091,-0.014245817815071537,-0.0022200997014938054},
{0.31796143992376025,-0.01484624901441678,-0.011285328752107377},
{0.31220606114996463,-0.0016688141163298733,-0.009114374664794853},
{0.3060019615510356,-0.012975510526776958,-0.010283185575975906},
{0.301694241629754,0.05094904454515729,-0.04678235116891774},
{0.28667064105111784,0.014755436466472977,-0.02013260768765611},
{0.2708735312405849,0.04448425951448399,-0.021358042893437342},
{0.29731814520178546,-0.06171834434836125,0.1049664848278942},
{0.26912031487381327,-0.0003237200238463636,0.10695474543640238},
{0.2762752752688586,0.0133921798644008,0.10063312371660503},
{0.2747784708021633,0.12197300410045363,0.048335779930213235},
{0.28763859597390584,-0.07077075280397108,0.08109346854787532},
{0.2675626125808499,-0.07787229405316708,0.07689686044996016},
{0.26417156520234103,-0.06370233142520149,0.07552612516746902},
{0.2910520793936713,-0.04904625457000796,0.0760934364963878},
{0.29363756605277386,-0.04303553227905308,0.07021412530422204},
{0.28635012617602246,-0.05028771551954396,0.05745335974375904},
{0.2689814250946053,-0.06328352532174361,0.061939499612177006},
{0.27453701626292476,-0.07019382602879934,0.0586841368641252},
{0.2730327331158106,-0.07360944621439883,0.04259856366600641},
{0.27170580153291585,-0.06066278202638057,0.04074812445378924},
{0.2912465250845625,-0.05992987134532923,0.02692218112509269},
{0.28335224371096396,-0.06960942057320885,0.057450154595008095},
{0.3029805746618034,-0.06244804988066166,0.03815943264593577},
{0.29247623382201166,-0.06275360739491924,0.05369799379055849},
{0.3025692472387643,-0.05707728895698052,0.04905480163334381},
{0.31193682865488453,-0.033077135109840554,0.04112846877223573},
{0.3109902413904363,-0.039809015869759955,0.029034374151971066},
{0.28278065885037723,-0.0649042622068091,0.031349559933076504},
{0.3183556732201275,-0.03563698057893539,0.05006656025572814},
{0.311214601803003,-0.05715314414408647,0.062222621085177905},
{0.3016205232084821,-0.06097047630647206,0.07617036006641069},
{0.3044357121947363,-0.06783590493101457,0.09554655264884178},
{0.2816503097242076,-0.07911589176853699,0.06379100720731117},
{0.30330749983440064,-0.06881881721464035,0.06445874653042648},
{0.3021312102428007,-0.06688718090073233,0.055550569768609635},
{0.26639166490383487,-0.07630818146270173,0.06640534020517226},
{0.3206420126624744,-0.01894349750105241,0.03126515768263473},
{0.32381297316008434,-0.0014925309350274603,0.009510744726996121},
{0.3101761336076941,0.03995324756355274,-0.041198982044756687},
{0.30948702662623906,0.011088746295382146,-0.02254608469712412},
{0.3260352096274121,-0.017687079190678676,0.04699282260356371},
{0.32477558616828744,0.011660331155968926,0.037783361859157226},
{0.3163161302316041,0.0019455252918287526,0.015444543447928092},
{0.3225832644226352,0.00666243587031531,0.025660420900133984},
{0.28371015198815375,0.06598546571879732,-0.04226522819590723},
{-0.030426477092801867,0.8797791438834008,0.11814498810889813},
{-0.02504075880828295,0.8603954726205508,0.09126447391756787},
{-0.023440321198640156,0.8397949132152557,0.11563963016856946},
{-0.026016192411489815,0.8631989093947183,0.14659602518819564},
{-0.023679638972044687,0.847633638677171,0.13537373102819036},
{-0.01781528514071671,0.8049784507165644,0.09899101917319983},
{-0.019054609324418742,0.8363376260958938,0.10417053955474075},
{-0.026271535928649108,0.8566401066673504,0.08822706128458088},
{-0.02674376117795627,0.8628570268612832,0.07855285397128615},
{-0.021757618104389552,0.8652619568074154,0.08351976615234714},
{-0.02289544591097806,0.8878657341820567,0.07570561349752243},
{-0.033187178550289846,0.9030036517328102,0.10807013720173421},
{-0.03233354059961923,0.9193071750459938,0.14311950717632804},
{-0.034092098880975724,0.9136372669055571,0.15303303226302734},
{-0.021677489385615714,0.8986980685773626,0.15067831631399348},
{-0.01218277040237437,0.9023519381534496,0.17362931813665472},
{0.13793998679478714,0.9406353032177556,0.16472541490650583},
{0.12148475310739172,0.9355380483208227,0.19307816075744078},
{0.14378297296777545,0.9224183061002528,0.1695010865454266},
{0.1633760472823544,0.9245903285704822,0.13108951553108247},
{0.1537798319219995,0.9102601085049691,0.15820293719831538},
{0.1363577116947331,0.8919234525007639,0.18741038938283794},
{0.12487686886881753,0.9161511719092217,0.1905717344341951},
{0.09763737801738046,0.9300722013175298,0.21441163084378748},
{0.10208719286662093,0.9399152131317079,0.206925471744477},
{0.13391325158067255,0.9477229554890308,0.16060038846402863},
{0.15707472483797974,0.9381459710211817,0.12397301692104865},
{0.16394870052585808,0.9291950589426855,0.1006908163941222},
{0.16781197315367408,0.9148199667946589,0.1007933811541527},
{0.16513887909537883,0.897910670367545,0.12880851800332055},
{0.15493475385525976,0.8872642345997944,0.1615042404117975},
{0.13361303598099988,0.8694094192911491,0.1806859873033374},
{0.10547610347929581,0.9008294924967467,0.21887106113928081},
{0.09161169836558782,0.9277997508531037,0.2250933232477986},
{0.08125158921958903,0.9430210022713819,0.21618514648598175},
{0.08648559712989613,0.9486118500759619,0.2042972497686951},
{0.10199103840409234,0.951436654508469,0.19614014619751835},
{0.13416432156616387,0.9623491176225488,0.14714837915627665},
{0.14915693904020755,0.9557625369393393,0.125536061128597},
{0.1552958672812005,0.9467582057149937,0.0972623756135189},
{0.16133543591091395,0.9186811026566409,0.07237119041361377},
{0.15915166122859764,0.8929149118477255,0.06690213826157006},
{0.16338886787735818,0.9005549180870817,0.09461812789398223},
{0.16233223717246054,0.8786562734376502,0.09861388000350431},
{0.15819011660331156,0.8715258858496955,0.14095816853526838},
{0.1490148441122486,0.8557063399979058,0.1573482308647278},
{0.11167379278072297,0.8770697248059283,0.2034500221155264},
{0.08138086355254415,0.902320955048857,0.23634553212947945},
{0.07656031983111003,0.91454325561916,0.24119492218967217},
{0.07642570358357,0.9255347790690966,0.23334123936691903},
{0.06997267076498354,0.9361651890930924,0.23264144855629418},
{0.042677624001863264,0.9451171695545055,0.2222097577548574},
{0.06794915352021488,0.9559783502885703,0.2108645995593989},
{0.08436913057134983,0.9674837659215765,0.1887789878994951},
{0.10701564326267049,0.9586300766885256,0.17905884012077},
{0.12542708607106456,0.9648459284995416,0.1554283467629066},
{0.12659376021641164,0.9733716241770781,0.13320277694087784},
{0.14338980805432514,0.9637113058417042,0.13027540774834026},
{0.14364621995440144,0.9640841714797317,0.10414062483306517},
{0.14394323040532314,0.9590681136844893,0.08070244040025898},
{0.1525095246337049,0.9339376107111799,0.06223116814851378},
{0.14469537197888022,0.9224054855052488,0.04164556610405623},
{0.15298922856343097,0.9039940426968549,0.04576631901486549},
{0.14779688758688622,0.8792150377032332,0.04572892561277103},
{0.15644865244862682,0.8628271121396077,0.07351863366645514},
{0.14844112248582791,0.8410855197789728,0.0714235347662485},
{0.15192725594394837,0.8428045478924009,0.10697824986057604},
{0.1538962856599508,0.8467586330681606,0.12727859366619873},
{0.14851270414126586,0.8369647668681636,0.13444851142208178},
{0.13264187590946097,0.8244732338027807,0.15250631948495397},
{0.1275157746737693,0.8207135943179121,0.16479699656194377},
{0.1298875847494749,0.8033288674927404,0.1410682119757178},
{0.1243896862586726,0.7812550080449233,0.1343181687062097},
{0.12149971046822951,0.7753692865552557,0.1225766404485499},
{0.10876458609777413,0.7337087630903617,0.1335478646230638},
{0.09762669418821061,0.7254448212274864,0.12298476272283798},
{0.09023668955142876,0.7087534749154375,0.10835005352598415},
{0.06359228798475204,0.6952224052718285,0.12406810300066028},
{0.11961935653433677,0.8305704951100115,0.02147449663138867},
{0.0903435278431272,0.8394701248084924,0.007507526757650164},
{0.12552324053359318,0.8621978346015037,0.02136017965927133},
{0.133744447079789,0.8269444034897658,0.039373115639630175},
{0.13721241802832068,0.8626305296828827,0.03658143107754965},
{0.1430479255208901,0.8948914202441468,0.03154400562396768},
{0.12333626070252587,0.8969694250176817,0.01228426677948791},
{0.10545046228928819,0.8635728434156628,0.010812035119883255},
{0.07821417658660204,0.848656081128725,0.0030694641204965065},
{0.05721404197035451,0.7937251734519665,0.005286358673239366},
{0.10636606644914391,0.8040254531546142,0.02351083447116115},
{0.11604988920869153,0.7848159283072327,0.0425996320489234},
{0.13006386793077734,0.7981557574087014,0.061127528595268786},
{0.13479359910426778,0.9246939617134298,0.03461988004196608},
{0.12560764278403494,0.9225272811577853,0.023031130541435102},
{0.10118547768468601,0.9207494919839229,0.008073769703651954},
{0.09163092925809355,0.9076810321433684,0.005800250856308915},
{0.08747278294518983,0.8941403470535068,0.0017927465347000165},
{0.04811889819806538,0.8867279063754682,-0.0027339918845633547},
{0.052210804770116054,0.8558655290525368,0.0018162509588736757},
{0.039573971628023265,0.8213236409635104,0.008714799453842662},
{0.038862428605311576,0.7957518958454861,0.006591922597794438},
{0.03289764677978706,0.7858490545879567,0.011848366549358232},
{0.06302390827291628,0.7809441086160808,0.008299198499135687},
{0.08782855445654567,0.7724034555777065,0.017757592463199558},
{0.10070684213787696,0.768658773453676,0.02991151652681535},
{0.11153062946984703,0.7661096118137509,0.05272256018735164},
{0.13079250508016077,0.8024570670324808,0.09359782220826203},
{0.14748598815804376,0.8315320397352973,0.10114381075092362},
{0.156847159276662,0.8246441750694984,0.10009465872644484},
{0.1587734536759851,0.8400021795011505,0.11107977187887957},
{0.15726810214595394,0.8403900025000159,0.12373156238181016},
{0.14041863516219125,0.8352233027134789,0.12874655179413544},
{0.13866862394417057,0.8241110519939231,0.128363002326938},
{0.13503825879225723,0.8173759660852526,0.13353824917681098},
{0.004228659585424697,0.9746162902753649,0.07638617341564156},
{-0.000502139970982718,0.9695938221826207,0.1006149612070163},
{0.0192789697369855,0.9917616993271324,0.11104131009386814},
{0.01828003170960498,0.9833150639854529,0.08496635662194416},
{0.03272350036431858,0.9896217283444124,0.0816597114938771},
{0.04057397803832076,1.0,0.12430635239114782},
{0.019125122596939728,0.9882349673181665,0.12321339666707266},
{-0.011363320705047248,0.9714976805406873,0.12633841669925236},
{-0.01584625542471426,0.9583052882817625,0.10266732479054354},
{-0.014947745391530284,0.9416032581405436,0.08609884251394774},
{-0.009377196862373042,0.9474067141456034,0.0828605738925677},
{-0.005685933884191558,0.9461705951106525,0.06356451002891045},
{0.008501122870445757,0.9547048378515246,0.052227898896787806},
{0.021262956813825732,0.9626653589659763,0.0590773017775755},
{0.03282820189018306,0.9751130883317627,0.06559977948576594},
{0.04460712354993729,0.9942820146282989,0.0865091015540698},
{0.04907403252584953,0.9950106517776824,0.11470052158454008},
{0.04893193759789059,0.9879048369968182,0.13169208349626174},
{0.04575990871736358,0.9893044186180681,0.1425297598061526},
{0.03859746964189942,0.9888514242612667,0.1546356066385041},
{0.027890136047880654,0.9927969623736904,0.14645072511148577},
{0.012726577307119496,0.9895586937523103,0.1369923311474219},
{0.005261785866148721,0.983373825045887,0.14402549588993094},
{-0.008520353762951467,0.97006177390026,0.14821889883909511},
{-0.024187120857612328,0.9490562973694274,0.12255099925854226},
{-0.0278730419212089,0.921376632756193,0.11876358181783218},
{-0.022215954375775906,0.9174481887704408,0.07992572601961125},
{-0.004987211456483694,0.9122740103034848,0.04914134064961956},
{0.009685959525381578,0.9078583837075879,0.029760874535520534},
{0.019715938350032165,0.9389675574843428,0.022752282600102144},
{0.027845263965367302,0.9501898516443482,0.02671170969044674},
{0.04587208892364695,0.9566236535704289,0.03436560490772377},
{0.048489627070259,0.9857541821849286,0.05983799041446848},
{0.05346829146340683,0.9961730523913616,0.0775218644563961},
{0.06546836838697685,0.9949679164610029,0.0904888279198371},
{0.08220992869612412,0.9908941723985409,0.11603386346493676},
{0.056125359777947297,0.9846836625021099,0.12981279794528597},
{0.06995878178706275,0.989932627773255,0.14041115648177233},
{0.07663831178404991,0.9901623301004066,0.1517787507184875},
{0.06402498306613078,0.9900298506187004,0.16408652192214906},
{0.044697936097880975,0.9889657412333839,0.17479599228200182},
{0.028257659771323326,0.9839614356502285,0.16578631914307143},
{0.04920223847588767,0.9398147851375116,0.011463748699243806},
{0.058675589800789324,0.9538009859037558,0.029957456992245682},
{0.07032630551050542,0.9158210415878734,0.0032649781943046717},
{0.038189347367611336,0.9273446197304682,0.006224398874351765},
{0.07575369072878672,0.9287046711837896,0.020893296324549098},
{0.08856573866926497,0.9332891022805702,0.0239210935112832},
{0.08118748624456995,0.961932448284925,0.03189657198657257},
{0.07005920978125929,0.9771248533644445,0.044920159744613754},
{0.019808887663809817,0.914460990134552,0.013174229749336007},
{0.03182285356530064,0.882055867879495,0.010094081799669663},
{0.031038660504234008,0.8476047923384125,0.009573779319098207},
{0.009680617610796654,0.8355096293352307,0.027440346839830175},
{0.004922040098547647,0.8036077154340732,0.035698946788120446},
{0.008602619247559283,0.7939965427128804,0.030014081286845865},
{0.016977672933800866,0.776314805436787,0.0192170035278004},
{0.041630608743218445,0.7762902326296962,0.007271414132996587},
{0.02738479092814698,0.6953516796047837,0.14117932379908418},
{0.020768295523261905,0.7040675474415434,0.11790567033549362},
{0.04748107359662562,0.6960012564183102,0.12191531142293648},
{0.03491261696121984,0.6867843169934849,0.11045476787244363},
{0.056701218170201954,0.670294895052746,0.10219296277540241},
{0.07075152191146525,0.6765556189462753,0.10090662974335306},
{0.09140977399427774,0.6922063602971812,0.09380081496248908},
{0.10384788791381143,0.7049051596484592,0.08220031324987127},
{0.11172400677782122,0.7563146772308369,0.11062677752207815},
{0.1200712825082212,0.7736534635905785,0.09994829026681797},
{0.11053062305954954,0.7201766250638358,0.06618632170719044},
{0.10979023369807928,0.7357472376959682,0.04732081615907795},
{0.0940273121408898,0.7576554977916524,0.02154287313807568},
{0.10573465214520605,0.749136212411618,0.024352720209744945},
{0.11486398417083872,0.7341425265546573,0.04453233674574837},
{-0.007636801090605276,0.7398081611634262,0.09433180127223038},
{0.00440707953256111,0.7198838881445822,0.10435857494813001},
{-0.019624057419171486,0.7609322281980438,0.10663529894422401},
{0.012339822691171102,0.9385060160642056,0.21196610234680993},
{0.0014380434062611586,0.9502742538947899,0.19144674004320542},
{-0.005414564623277496,0.9348297104468618,0.20145428282659933},
{0.010407117994346122,0.9193349530018355,0.21662425186486237},
{0.0006570554939454787,0.9165325846105851,0.20223740750474897},
{-0.018771487851417846,0.9290027500176282,0.17932700423293313},
{-0.00934300860902954,0.9435423731348704,0.19240187437098955},
{-0.017900755774075475,0.9484419771921614,0.17117737934217528},
{-0.012321660181582355,0.9573928892706576,0.15868798304262635},
{-0.00013247948170607836,0.967169661343983,0.161538428665141},
{0.005368624157847167,0.9612091530501263,0.1836058778154561},
{0.01547552655252064,0.9627177097289085,0.18712406276108606},
{0.029083519766152352,0.9671995760656584,0.19819678331271356},
{0.025448881082571047,0.9549088989886687,0.20322566170295964},
{0.020226625384350758,0.9399600852142214,0.21914884069769677},
{0.01580672525678584,0.91937234640393,0.2253978123791392},
{0.019275764588234545,0.905156443310534,0.21740737654301204},
{0.0026656153778763583,0.9038765205759866,0.20251198191441397},
{-0.007456244377634898,0.9182035354927488,0.1826400596585021},
{-0.028167915606296622,0.923370235279286,0.16831731827340776},
{0.11165349350530025,0.941090434340391,0.028702107064788884},
{0.10450921693942483,0.9730500409190657,0.04683363354893302},
{0.1210242800701714,0.944254984540499,0.0387438381015263},
{0.13326474315006293,0.9384226821966807,0.05008258599948291},
{0.1231001480778723,0.9479782990061902,0.048085778327638856},
{0.12168774586161878,0.9645393026023671,0.05750143697502335},
{0.1109878909480189,0.9770297672848329,0.06327070472673971},
{0.08665333324786272,0.9833129272196188,0.06233266452562731},
{0.13329786302048946,0.7984955031763025,0.1056908484456097},
{0.14161095049754593,0.8178909266512393,0.10054124278574436},
{0.14619751836016046,0.793143973145127,0.10554661675181679},
{0.15324350369767328,0.8116772116060573,0.11276354335604716},
{0.15216443695151893,0.83577565668156,0.11499646365254479},
{0.15062276040231026,0.8202135911127635,0.11579134054278126},
{0.13771135285055244,0.8191964905757941,0.11717382803735922},
{0.13221986465725208,0.8099357474513725,0.1276535960700603},
{0.13657352504396397,0.8056878569734421,0.13419957820242437},
{0.1337775669502155,0.7962508306677178,0.1308395139285081},
{0.13796455960187778,0.7802272236787843,0.12006166706196836},
{0.12842069500445516,0.7791182422109543,0.12182984078957772},
{0.12208304754090304,0.785833028844202,0.11885439436577587},
{0.1252443925922602,0.976198565375419,0.0841981893046323},
{0.11101032698927558,0.9861131588450353,0.09444398147851375},
{0.1317284085154392,0.9707840007521414,0.09598886317647336},
{0.11455094797616225,0.9796002965830978,0.11771122464460243},
{0.11317700754492016,0.9854753342435956,0.11179024651867427},
{0.0985861020476627,0.9906666068372232,0.11367594236715194},
{0.0970903659638844,0.9933877781267829,0.08924950373613508},
{0.08026974531888026,0.9893193759789058,0.0648722107192995},
{0.06598332895296338,0.9842498990378143,0.0599127772186574},
{-0.010595153387735387,0.7495657023442458,0.07562655316166557},
{-0.005560933082904371,0.7798372639140848,0.0574223766391665},
{-0.00038995976469934345,0.7680401797447418,0.04103765622429204},
{-0.005631446355425353,0.7568168172018196,0.057086904403233364},
{-0.006903890409553902,0.7340378250287929,0.08404541054750353},
{-0.001720096496345055,0.7210323997803405,0.09646002004286353},
{0.011847298166441244,0.7086947138550032,0.10556264249557155},
{0.03342435955786042,0.9143445363966007,0.23653356752286875},
{0.03821498855761896,0.9021489453992226,0.2281617189853781},
{0.06112539182943481,0.9151554390305919,0.2433156622798864},
{0.05305803242328477,0.9006467990179424,0.22869163691220243},
{0.0707066498289519,0.8961179238328449,0.2274523127285004},
{-0.024878364604901306,0.9421342444502849,0.14321673002177365},
{-0.0019786451622553058,0.8687577057117887,0.040415857366607064},
{0.02712303711348578,0.8617662079030421,0.013762908736594474},
{0.0055876426558289964,0.9767284833022434,0.15916875535526936},
{0.01703429722840104,0.9733256837116477,0.17297546779146022},
{0.046929788011461616,0.9822798009388949,0.1809082109500702},
{0.04825137767977145,0.9777434470733787,0.18891360414703515},
{0.051845417812507344,0.9699378414818899,0.19657070451306313},
{0.05725784566995088,0.9635927153379187,0.20452374694709582},
{0.04554195860229874,0.9581728088000564,0.20772462216638143},
{0.03550556948014625,0.950617204811142,0.21850353741583814},
{0.02955681339837649,0.936811560757868,0.23196729893567694},
{0.026384784517849477,0.9233125426017688,0.23210405194905095},
{0.047352867646587485,0.9374098551913794,0.2349715916982374},
{-0.004417763361730944,0.8195191422167235,0.05000566242946002},
{-0.010876138094902312,0.8070564554900992,0.07433594659794827},
{-0.007362226680940257,0.7937732506832308,0.06859766195082449},
{-0.009674207313294736,0.82286852266147,0.08701551505672045},
{-0.02054927702528007,0.8184528960655731,0.07909879764186523},
{-0.019318499904913914,0.8126430297630113,0.09106575469500874},
{-0.01707596416216343,0.8340982955018942,0.09483500962613009},
{-0.02203432927988854,0.7990393100810474,0.08176120787099064},
{-0.018522554631760457,0.8035179712690464,0.07221413812481706},
{-0.026401878644521225,0.8289807413295383,0.06974190005491489},
{-0.013972311788323422,0.8253044357121946,0.07566501494667702},
{-0.011595159798032887,0.8358579221661676,0.0783829810874856},
{-0.01797554257826438,0.8418761231375413,0.08971211353918936},
{-0.021253341367572863,0.8573644702850658,0.07970457075579544},
{-0.020080256924723868,0.8511315243473783,0.06514571674604752},
{-0.02384844347292824,0.8620119359739485,0.06639251961016844},
{-0.014892189479847086,0.8605557300580986,0.06627072395763221},
{-0.011866529058946957,0.8472586362733094,0.062449118263578615},
{-0.01206738504734004,0.833500001068383,0.06601858558922387},
{-0.01097656608909886,0.8240213078288964,0.06626004012846237},
{-0.013761840353677477,0.7912166103628868,0.09261170477588533},
{-0.011017164639944267,0.7571223747160771,0.0884471481654797},
{-0.006158159133498717,0.7899142515870828,0.08553153118502897},
{0.1359335636766902,0.7838832300207051,0.11180093034784411},
{-0.02201723515321679,0.8396549550531306,0.05720549490701864},
{-0.021337743618014642,0.8485193281153511,0.05881982149458224},
{-0.021133682480870598,0.81734498298066,0.0625741190648658},
{0.06339143199635895,0.9782349032151915,0.1738237638275459},
{0.08596529464932469,0.9956997587591374,0.0984215710784471},
{0.07922379844315242,0.9919764442934462,0.10319724271736785},
{0.14400733338034222,0.7999239311363107,0.11736506857949945},
{0.14420605260290129,0.8131195285439864,0.11053489659121747},
{0.1345628283941991,0.9600948296677114,0.06661688002273519},
{0.09337453017861226,0.9731590159765982,0.1635801084194984},
{0.07352824911270799,0.9801088468515824,0.16716880663764938},
{0.1349570616905664,0.8046322946514615,0.114430220706543},
{0.13201473513719106,0.8016440276326556,0.12667495731810247},
{0.06590213185127256,0.7707421201417957,0.005611147080002657},
{0.1263693998038449,0.8047904153231752,0.12626362989506343},
{0.06687008677406052,0.9753524061051672,0.18750227031369862},
{0.05523326004226524,0.9565755763391646,0.2063175618647128},
{-0.02197984175112233,0.8404626525383709,0.07755071079515469},
{0.019401833772438717,0.6996572627602312,0.10936715406295341},
{-0.19881644540456456,-0.03247349876174426,-0.05596296557456564},
{-0.19765724993963638,-0.03167648510567379,-0.054444793449530654},
{-0.196647628083086,-0.03305576745150084,-0.052017427462141844},
{-0.19977692164693361,-0.051282380015256555,-0.056709765233537816},
{-0.1889029203178653,-0.046859274738940644,-0.045443667373936146},
{-0.19687626202732067,0.005442342579119025,-0.043177627207012},
{-0.19733673506454102,-0.03156109975063947,-0.05417662933736754},
{-0.2084981313982782,0.013599446150295826,-0.057295239072045326},
{-0.20126731581612703,-0.050837932721791025,-0.06543738528238428},
{-0.21199067515390055,-0.04808150479597096,-0.06504742551768494},
{-0.20384746056064462,-0.04363382671256442,-0.056524934988899496},
{-0.2016209505616489,-0.04417336008564169,-0.04583896905322042},
{-0.19907178892172386,-0.05325888841167792,-0.037665839738288916},
{-0.19474697487377057,-0.05574394707658394,-0.0498133535044028},
{-0.1847768254924711,-0.0552268497447634,-0.03937845755421509},
{-0.1870396605106443,0.0028611294516844746,-0.02770957933491026},
{-0.17711224644602425,0.00036004504302369536,-0.02298839522475571},
{-0.1812105633155768,0.005248965271144842,-0.0635388688389028},
{-0.19882926599956838,0.01570202373092131,-0.06215424457849088},
{-0.214169107921632,0.016316343908187394,-0.07219918076397926},
{-0.21454838385716146,-0.0244723790964473,-0.07920456755064668},
{-0.21669049160571544,-0.03784746483417633,-0.0785549907371201},
{-0.22763393782438776,-0.0462898266441879,-0.0692365549351812},
{-0.23434765607471844,-0.03082391553792019,-0.06532199992734995},
{-0.21200456413182137,-0.0293677096220703,-0.06228672406019696},
{-0.20545430846778934,-0.026777949431299866,-0.057560198035457484},
{-0.2151808665440163,-0.03839981880225731,-0.04425242042149842},
{-0.2105739994059791,-0.04869048305865209,-0.035741682104799805},
{-0.1912384053743934,-0.06014888984331107,-0.029806815000950854},
{-0.17880777013527863,-0.05259435423731354,-0.02775979333200853},
{-0.17520945647087482,-0.04604516695619852,-0.031822853565300624},
{-0.15544544088957835,-0.042090013397521886,-0.03142968865185033},
{-0.16052346489400574,-0.0005042767368167189,-0.023312115248602012},
{-0.14981078938540202,0.0030651905888284536,-0.03354615521039664},
{-0.12684269343606902,0.001487189020442384,-0.06841176332326916},
{-0.14029683950965496,0.004722252493071515,-0.11231589091383064},
{-0.19371171182721258,0.010979771237849795,-0.08144817167631416},
{-0.2066701282273177,0.01175648561849745,-0.09714271672681661},
{-0.20773530599555126,-0.03518398622213398,-0.1148917621266803},
{-0.21769370316476389,-0.035395526039696944,-0.08759885212939399},
{-0.23167883554809113,-0.02868928646978508,-0.09820468934629921},
{-0.23038929736729083,-0.034382699034395565,-0.08201761977106689},
{-0.23642459246533634,-0.04091372380592192,-0.08028577106263501},
{-0.24633277563745068,-0.043701134836334476,-0.0756030487374919},
{-0.25774310519084526,-0.040263078609478385,-0.08000158120671713},
{-0.2447590476007325,-0.0067211969307496055,-0.06555918093492051},
{-0.22418412938544477,-0.014385775977196499,-0.06394058081568899},
{-0.2116220830475409,-0.01843067370089981,-0.06380382780231497},
{-0.21799071361568556,-0.017957380068675702,-0.05432833971157934},
{-0.2133763677972295,-0.026411494090774198,-0.05070011132549994},
{-0.26174206244911824,-0.002516041769498637,-0.07882635999803418},
{-0.2553210811180413,0.04629837370752366,-0.07392355079199224},
{-0.24853471282935574,0.08740761158725367,-0.0811479560766415},
{-0.25594074320989235,0.014359066404271712,-0.087597783746477},
{-0.24182313134485903,0.08515332363241629,-0.08381891336910278},
{-0.2436725021741592,0.12189501214751376,-0.07740434233552777},
{-0.24207847486201833,0.1204612422729206,-0.05799182473391923},
{-0.24506460511499004,0.08616508225480066,-0.06384335797024339},
{-0.23603890623230492,0.05622685615506071,-0.05479735981213554},
{-0.2373711797297846,0.005381444752850935,-0.0594629880106069},
{-0.26568119026404013,-0.03681433855345237,-0.08456464464515796},
{-0.2617260367053635,-0.03467543595364932,-0.09188413600941886},
{-0.250581734498298,-0.03634745521873012,-0.09000591884136008},
{-0.23744596653397348,0.01814968899373275,-0.08602191894392484},
{-0.22943416303950667,0.06589251640501961,-0.08394605093622394},
{-0.22266916240916074,0.10304766910898999,-0.0791212336831219},
{-0.2189212751363791,0.13457030707461787,-0.07741716293053161},
{-0.23837759643758402,0.13982461426034767,-0.07772592559354012},
{-0.24261159793759363,0.14357677506479746,-0.06472584225967261},
{-0.23191708493857865,0.1339591920461027,-0.04965523283268909},
{-0.23785408880826162,0.10399959828802317,-0.0494960437780584},
{-0.22387536672243624,0.07498659179439172,-0.03920217437291264},
{-0.2208080393677737,0.030587802913266467,-0.044055837964773276},
{-0.22584653320427267,0.01777148144112027,-0.05402278219732177},
{-0.2416810364169001,-0.00010897505753246976,-0.055177704130582025},
{-0.23814041543001346,-0.002008559883930991,-0.06092026230937377},
{-0.23437116049889206,-0.0036966048927664264,-0.055433047647741325},
{-0.05457406778248579,-0.0020331326910216297,-0.13001579069951302},
{-0.07743318867428638,-0.0005256443951564305,-0.0995583305021186},
{-0.12379459697391224,0.0008141077827421217,-0.12512046017389},
{-0.18531208533388033,0.010044936185488273,-0.11275499629271127},
{-0.1862597409812456,-0.03397243999427358,-0.13254678982984935},
{-0.194232014307784,-0.03645749865917949,-0.13536411558193748},
{-0.21160285215503516,-0.03858464904689561,-0.1139804314984925},
{-0.22608478259476023,-0.033913678933839404,-0.10828167701929713},
{-0.22084009085528325,0.0028109154545861823,-0.10986715726810214},
{-0.23982525529009802,-0.019483030874129566,-0.08558495033087819},
{-0.24130923916178948,-0.03153866370938286,-0.08690333485043707},
{0.11874541930824344,-0.007500048077231292,-0.1585512300292523},
{0.12036401942747497,0.051190499084395734,-0.15030651905888287},
{0.16523717032374138,-0.010700923296516885,-0.14802765829695488},
{0.16099248499456192,-0.06303672886792021,-0.15445398154261672},
{0.16804274386374274,-0.07693318546913773,-0.144088530482033},
{0.1752041145562899,-0.01266247433210051,-0.14052654183680663},
{0.17921268726081577,0.03465299991239259,-0.14026906155381338},
{0.16599358542896644,0.08816402669247864,-0.14078295373688293},
{0.12179031062164929,0.09497603617117205,-0.14857787549920193},
{0.08073556027068549,0.11370372032299343,-0.1468823518099475},
{0.07869174375049412,0.05311893024955284,-0.1550907377611395},
{0.040815432577559256,0.03035916896903185,-0.14998279903503653},
{0.09984358874095348,-0.06680705218195844,-0.15688455267875648},
{0.13725835849375104,-0.07716395617920638,-0.157538403023951},
{0.16265809396214082,-0.08317147332141021,-0.15486744573148972},
{0.16646153714660564,-0.08799842734034626,-0.14580862697837804},
{0.17620839449825532,-0.0841137870541906,-0.14013444530627334},
{0.20181753301837407,-0.02528435011335551,-0.14375305824609988},
{0.1864808962450614,0.11738216270617119,-0.12156274506033157},
{0.17598617085152257,0.16077132973074598,-0.12693030083526177},
{0.15738348750098824,0.14159599313670815,-0.13794532870937204},
{0.11347188123000788,0.1482616341557744,-0.14478938967557484},
{0.0758519819571493,0.23326217903106214,-0.14155539458586272},
{0.03664980758423665,0.22634653640942146,-0.1343908187445646},
{0.03446496451900333,0.1508674200902997,-0.14337378231057035},
{0.0007724408489798027,0.10765987816161203,-0.13671455158900592},
{0.0018408237659643142,-0.030127329876046306,-0.14671461569198094},
{0.03216687286456965,-0.05833904918193922,-0.15924354215945827},
{0.07082737709857115,-0.06372476746645821,-0.1566227988640953},
{0.10981160135641894,-0.0732675636809638,-0.15366658333279912},
{0.1226866838889993,-0.0753509103690836,-0.15040267352141146},
{0.14725414906505813,-0.07936696175402845,-0.14903193823892033},
{0.15752451404603024,-0.08564371139131241,-0.14360134787188808},
{0.16456943100062607,-0.09202302578862687,-0.13181067400004698},
{0.17381842191296099,-0.09134139748759083,-0.13372735295311722},
{0.1814466759402304,-0.09509783182370835,-0.13525407214148807},
{0.19243178909266512,-0.08432746363758747,-0.14276587243080618},
{0.2123411047506715,-0.07337333358974533,-0.149811857768319},
{0.22983694339920985,-0.014960565986534207,-0.13255320012735122},
{0.20630687803554296,0.13290576648995606,-0.11603813699660467},
{0.1905995123900367,0.16460682440272037,-0.12056594379878503},
{0.18246270809428264,0.20394575178900703,-0.12198796146129141},
{0.1312796876903057,0.22547580433207906,-0.1375222490742462},
{0.1329356812116317,0.18273300897227962,-0.1353854832402772},
{0.07720134958130075,0.2879847520390088,-0.1401515394329451},
{0.06450148184710586,0.32874890223655273,-0.14022418947130003},
{-0.011415671467979489,0.3314412271873538,-0.12226146748803945},
{-0.026126235851939218,0.2667527783297756,-0.12552430891651015},
{-0.017371906230168137,0.218645632343797,-0.1335895315568262},
{0.006544913749447115,0.21429945063750405,-0.13409701344239386},
{-0.03146174013935987,0.16096043350705236,-0.13763015574886164},
{-0.0273409872285506,0.054201202144458074,-0.14866975643006258},
{-0.00770197244854133,0.03815302234843379,-0.14121671720117862},
{-0.006472263711092159,-0.058298450631093825,-0.14934817958234775},
{0.016854808898347645,-0.058669179503287434,-0.15063023908272916},
{0.05637536138052168,-0.06497370709641308,-0.15296038222467237},
{0.057796310660111073,-0.06563824127077746,-0.1567873298333109},
{0.07239789998653838,-0.06269591471740207,-0.1524967040387011},
{0.07957209127408937,-0.028144411182122967,-0.13546988549071895},
{0.13646454998643154,-0.03528334583341355,-0.12892604012418882},
{0.14612166317305453,-0.03906648974245572,-0.12478071440628892},
{0.1576003692331361,-0.049849678523580285,-0.11013852652901619},
{0.17681630437801954,-0.044647722100782807,-0.1078553922354203},
{-0.11941850054594366,-0.0466680341968005,-0.14864732038880593},
{-0.1475800058547384,-0.04322463605535944,-0.14759068968390823},
{-0.12641961380094316,-0.046303715622108735,-0.15466658974309663},
{-0.1620341583386218,-0.04405583796477333,-0.15129797840584447},
{-0.14591867041882747,-0.0020395429885234836,-0.12802111979350295},
{-0.20169360060000385,0.035743818870633715,-0.11495800186753333},
{-0.173263931179046,0.015260781586206711,-0.15034177569514331},
{-0.19181746891539903,-0.029949978311826875,-0.14638341698771573},
{-0.17706310083184293,-0.03691690331348287,-0.1560693765130973},
{-0.1428395908520781,0.052178753282606474,-0.1593471753024058},
{-0.18674051329388863,0.07345773584018693,-0.1283074464152548},
{-0.208305822473221,0.10804770116047753,-0.09118114005004305},
{-0.1330382459716622,0.5200973510513955,-0.0931298704906228},
{-0.09046959702733136,0.3804511567381841,-0.10611072293198459},
{-0.12858843112242171,0.2806278672726533,-0.12705637001946593},
{-0.14033102776299847,0.31830225407427815,-0.12072299608758176},
{-0.14670072671406012,0.258860633722011,-0.1291493321538386},
{-0.126982651598194,0.21564240796415363,-0.13638228450182371},
{-0.08886274912018667,0.18773090425793312,-0.13059164909176765},
{-0.08345673156024504,0.27735968392959776,-0.11821977491308704},
{-0.04992019179610124,0.36923206772692985,-0.11781485778754992},
{-0.11002420955689886,0.4788716594337143,-0.09535103857503359},
{-0.1167678425289051,0.5604501738259006,-0.09137344897510026},
{-0.1366686111235756,0.5787056327284148,-0.08423558270672675},
{-0.14905651104601098,0.48462169629292495,-0.0963788229411727},
{-0.17509193435000653,0.43757331777767794,-0.09549206512007555},
{-0.15488453985816147,0.33174785308452825,-0.11446868249155442},
{-0.16631730545281273,0.2687955264670499,-0.11738429947200515},
{-0.1487669792755082,0.2024735201294025,-0.13786092645893028},
{-0.14396566644657977,0.11615672750038994,-0.15233644660115342},
{-0.1180018247980222,0.08929010228698042,-0.1563044207548339},
{-0.07777934473938934,0.07798340587653334,-0.14401374367784409},
{-0.07087759109566942,0.18336976519080242,-0.12892497174127182},
{-0.10987463594852102,0.5890988617448403,-0.08419818930463228},
{-0.08069496171984009,0.6841400692739482,-0.04419365936106427},
{-0.06305061784584089,0.6531740588080693,-0.06857095237789984},
{-0.06192133710258826,0.6076609465445292,-0.08857108058384988},
{-0.03135703861349539,0.6243234465178196,-0.08227082652239223},
{-0.050487503125020025,0.6782693051451183,-0.05629523266174783},
{-0.04769795532877347,0.7044062248262274,-0.03945751789007194},
{-0.08410737675668861,0.7055226849744762,-0.019155037318615283},
{-0.13287157823661264,0.6866849573822055,-0.01238469477368444},
{-0.12702645529779039,0.6486697564300626,-0.04800458122594802},
{-0.07409662882454375,0.5665506402818821,-0.09372389139246619},
{-0.044672294907873326,0.5409340230813445,-0.10548678730846564},
{-0.022002277792379003,0.5358228792064905,-0.10580837056647799},
{-0.020120855475569282,0.5883360363421132,-0.0960401455564886},
{-0.009540659448671673,0.6084836013906072,-0.10284360797184597},
{-0.021828131376910535,0.6423150148398387,-0.08579542176552413},
{-0.031063233311324635,0.6758248450310579,-0.06464891868964971},
{-0.04577379769528436,0.726851881529155,-0.010582332792731571},
{-0.06595768776295574,0.715754588170437,-0.009605830806607726},
{-0.08559456577713104,0.7207706459656792,0.030990583272969708},
{-0.13395491851443492,0.7150953959106575,0.03517971269046597},
{-0.12781492189052493,0.7049297324555499,0.010136817116349044},
{-0.162505315205012,0.69401726934147,0.006558802727367918},
{-0.14707466073500472,0.6505490419810381,-0.04113274230390365},
{-0.16577136178223364,0.6098190800368378,-0.05595121336247881},
{-0.16060359361277957,0.5806137646181492,-0.07211584689645445},
{-0.17664749987713596,0.5130983745622301,-0.07934773086152261},
{-0.20003867546159482,0.49954486887736455,-0.07471201738472681},
{-0.1975301123725152,0.42314480648380226,-0.07546415895828391},
{-0.1848249027237354,0.3714607144917596,-0.09134780778509263},
{-0.18986980685773625,0.294450605452599,-0.09028263001685907},
{-0.17331200841031033,0.20307608809458177,-0.11419731323064036},
{-0.1670715837922038,0.1800406840214788,-0.13110447289192023},
{-0.16690918958882214,0.11896016427455726,-0.13220170214766333},
{-0.08059987564022845,-0.008904971613065995,-0.16444763534808984},
{-0.05789139673972269,0.0053344359045035695,-0.15405974824624943},
{-0.05866063243995154,0.11093874533383748,-0.137260495259585},
{-0.0274243210960754,-0.05085930038013074,-0.1627275388517448},
{-0.018349476599208964,-0.05131015797109812,-0.15865379478928282},
{-0.0319831110028483,-0.05467129062793149,-0.1593204657294812},
{-0.00509404974818214,-0.06402391468321382,-0.144363104891698},
{-0.004150667632484816,-0.06103778443024212,-0.13885986448631082},
{0.016622969805362004,-0.013572736577371274,-0.12895915999461535},
{0.07424086051833666,0.5425130930326477,-0.12435015609074417},
{0.11390671307722058,0.5366423289038178,-0.1380115684502251},
{0.12012577003698743,0.47418039004523527,-0.14048380652012726},
{0.08576016512926365,0.49297004040624187,-0.12482879163755323},
{0.09886708675482964,0.4469793609788096,-0.12684696696773695},
{0.14539088925783714,0.3826979660126027,-0.1408192787560604},
{0.14893151024472379,0.46729252537943605,-0.13845815250952462},
{0.141881251375543,0.5396444849005443,-0.13923700365600633},
{0.100635260482439,0.5863232029265144,-0.12605315846041748},
{0.06266065808114156,0.5848637918619136,-0.12168454071286781},
{0.06240317779814828,0.4889871088917237,-0.1343235106207946},
{0.07096413011194518,0.4033466026491622,-0.1386119996495704},
{0.11925396957672806,0.3375993863208524,-0.12730957677079124},
{0.13036622029628395,0.3449274247484491,-0.12814291544603917},
{0.16399570937420538,0.3136697457462334,-0.13229144631269002},
{0.18379498159176236,0.33166131406825256,-0.12197941439795554},
{0.17524043957546737,0.3844992596106384,-0.1380927655519159},
{0.16627136498738243,0.38553772780594736,-0.13769105357512976},
{0.16641666506409228,0.47195067489748865,-0.14732893586924703},
{0.15150203954298855,0.5495419842434887,-0.1387284533875217},
{0.12624974091714264,0.5923371303662204,-0.1212924441823345},
{0.10002628221975783,0.6161813003074804,-0.11588535823947589},
{0.07332418797556395,0.6079333841883601,-0.11516633653634531},
{0.05585292213411625,0.6561933089314675,-0.09047814409066725},
{0.039046190467032914,0.6042784462293562,-0.09945042382750316},
{0.039931879905213075,0.5214242826342903,-0.12052320848210565},
{0.050630666435895956,0.4581631933538036,-0.13824020239445978},
{0.09929443992162344,0.29015677450923827,-0.1383897760028376},
{0.13500300215599673,0.2754643726348673,-0.12756705705378452},
{0.15042510956266814,0.29046874232099773,-0.1267476073564574},
{0.1715000309831046,0.2843575920358464,-0.12496020273634233},
{0.19204396609379976,0.30426263416218485,-0.10940561584796483},
{0.205338923112755,0.31095498475417566,-0.09130079893674531},
{0.20420536883783444,0.34673833379273783,-0.10086282604375668},
{0.18752897988662323,0.3796584166137815,-0.13076686389015316},
{0.19291576655405912,0.44754774069064535,-0.1458203791904649},
{0.18635162191210627,0.4622775359671108,-0.14938236783569125},
{0.07143528697833534,0.6789819165507469,-0.07238935292320249},
{0.1058425588198215,0.6713590044380626,-0.08489263820067221},
{0.124776440874621,0.6646987053335811,-0.08790761479240251},
{0.13827225388196934,0.6867928640568208,-0.06667243593441836},
{0.12892069820960392,0.7057876439378884,-0.038920121282828735},
{0.11238533580343464,0.7081829584377677,-0.04453447351158233},
{0.09770682290698446,0.7163432671576955,-0.03883465064946997},
{0.0792590550794129,0.7201114537058997,-0.04385070844471224},
{0.05085075331679477,0.6878388109325487,-0.07451970845966961},
{-0.20352587730263227,0.1503033139101318,-0.0942270997463659},
{-0.1947640690004423,0.706374186159313,0.04138915420397995},
{-0.2005386786667436,0.6832116445190887,0.011700929706814368},
{-0.20328121761464282,0.6431098917300752,-0.029370914770821172},
{-0.1660010641093853,0.6654487101413041,-0.018761872405164984},
{-0.1886945856490533,0.571793195255525,-0.06317989217879601},
{-0.2100910903275021,0.5665025630506179,-0.059634997660241405},
{-0.20606328673047047,0.4968803218824052,-0.06927608510310963},
{-0.21267337183785365,0.460609790233698,-0.05674822701854925},
{-0.20889343307756247,0.4279407773981457,-0.05364030111304132},
{-0.20477695369842117,0.36011876144505184,-0.06431451483663356},
{-0.2150686863377329,0.29560445900294224,-0.050421263384166984},
{-0.20403442757111692,0.2750156518097337,-0.06380062265356401},
{-0.19814763769853225,0.2168881424453576,-0.0735549586856326},
{-0.2086028329241427,0.19891794178167804,-0.07513296025401872},
{-0.1987630262587153,0.18323621732617942,-0.091736699166875},
{-0.22704312207129534,0.20189659335423088,-0.07204319685809951},
{-0.2419769784849048,0.18642106680171017,-0.06392028154026627},
{-0.24401224794176032,0.17002459417474888,-0.048267403423526214},
{-0.23936050872120973,0.1558460844834474,-0.049028092060419186},
{-0.24263510236176725,0.13134485904824175,-0.04416588140522268},
{-0.20890091175798137,-0.017656096086086065,-0.026270467545732125},
{-0.2234159620681329,0.007027822827924081,-0.052170206219270626},
{-0.2221830481819328,0.019135806426109462,-0.030711735331636736},
{-0.2224704431866016,0.018723410620153442,-0.023930708957536045},
{-0.21310393015339843,0.009511813109913092,-0.0033162605743199134},
{-0.2038613495385654,-0.014005431658749989,-0.013360128376891298},
{-0.0026068543174422036,0.49718694777957967,-0.11656591815759502},
{0.014366545084690718,0.5321668728645697,-0.12329886730043141},
{0.01719348628303173,0.4862445699438245,-0.13047092182214845},
{-0.002795958093748458,0.4539452175975487,-0.11869520531114515},
{-0.004615414201373083,0.3820900561328385,-0.11879777007117566},
{0.02723628570268613,0.3352329181597316,-0.13043352842005398},
{0.03715515270397033,0.4129748694970266,-0.13723271730374337},
{0.027002309843866527,0.600005982944335,-0.10052949057365752},
{0.012512900723722593,0.5874268424797595,-0.11000391028147616},
{-0.007072694910437454,0.564831612168454,-0.11303277585112724},
{-0.024704218189432837,0.47227012138966706,-0.1165947644963536},
{-0.026387989666600425,0.3919565723711903,-0.11208512020376198},
{0.22914035773733593,0.01832169864336734,-0.12561512146445383},
{0.24699944657764902,-0.06118308450695204,-0.12577431051908453},
{0.22655273431239942,-0.07945670591905511,-0.14451161011715888},
{0.25130075620142867,-0.0886597563659597,-0.12321339666707265},
{0.2570988702919036,-0.08480930433314747,-0.11058404220539873},
{0.24505392128582024,-0.004418831744647966,-0.09100806201749156},
{0.24092996322626,0.01903965196358094,-0.1044141308598132},
{0.2329160229659592,0.05021720224702285,-0.11341632531832468},
{0.2205911576356259,0.1431515586638375,-0.10561392487558681},
{0.2275142789376855,-0.04216052667004287,-0.10399639313927225},
{0.23356559977948577,-0.048162701897661746,-0.07897913875516295},
{0.19592753799703844,-0.040884877467163336,-0.11714284493276665},
{0.19931965375846428,-0.08341506462648268,-0.13910345579138325},
{0.21413598805120546,-0.08685739438500684,-0.1459560638209219},
{0.19772669482924038,0.4030581392615764,-0.12490251005882516},
{0.2017096263437586,0.38741167144233823,-0.11997085451402466},
{0.2035579287901418,0.3627192054649922,-0.10175278901360478},
{0.12004029940362866,0.7011647510560964,0.05225674523554639},
{0.1288736893612566,0.6979617390709768,0.05227383936221814},
{0.11939926965343796,0.7290901437402376,0.031181823815109935},
{0.12787688809971004,0.720849706301536,0.017119767861759807},
{0.10625815977452847,0.7460827740348763,0.013973380171240422},
{0.12243988743517588,0.7243347713767395,-0.004507507526757643},
{0.14115154584324258,0.7121317016989424,0.011909264375626347},
{0.15343474423981351,0.6816560789919593,0.040757739900042105},
{0.17252461020049276,0.6717831524561054,0.03975987025557857},
{0.16190274723983275,0.68601721805909,0.023599510253270863},
{0.1741763301901508,0.6669433778421656,0.036214975737023966},
{0.08958070244040027,0.7287610818018063,-0.020380472524396516},
{0.060190556777073356,0.735412833842952,-0.0215471466697436},
{0.07915221678771446,0.7365987388808047,-0.02313583206729957},
{0.0816597114938771,0.7605390632845936,0.00040598550845412156},
{0.058987557612548806,0.7676502199800426,-0.006083372329309796},
{0.04806120552054821,0.742374416930023,-0.024192462772197252},
{0.026422177919943935,0.7399673502180568,-0.017908234454494357},
{0.053318717855028994,0.7255110609683395,-0.031688237317760576},
{0.12915894760009144,0.7155163387799494,-0.02058346527862357},
{0.12604461139708162,0.7185858029004458,-0.004590841394282434},
{0.14727979025506574,0.7032577131904691,0.011209473565001495},
{0.19464975202832496,0.6862490571520758,0.015994760650175115},
{0.17385474693213845,0.6990920881971464,-0.000913467394021749},
{0.264383105019904,0.6684134727359364,-0.027745904354087733},
{0.2740444917381949,0.6567574151116352,-0.011831272422686464},
{0.2769066895727964,0.6421195007660304,0.003951948409925712},
{0.22356553567651075,0.6520661457231564,0.035328217915926816},
{-0.008320566157475364,0.6475351337722249,-0.08012230847633638},
{-0.012207343209465017,0.6993880302651513,-0.04459002942326553},
{0.007946632136530794,0.7087812528712789,-0.052674482956087315},
{0.025331358961702747,0.6927106370339979,-0.06650149466770086},
{0.03136665405974825,0.7192193539702176,-0.049243905409650054},
{-0.011697724558063399,0.7274298766872436,-0.030638016910364805},
{0.011158191184986234,0.6253330683743699,-0.09490659128156805},
{0.02531746998378195,0.7265132041444708,-0.030742718436229288},
{-0.01636335275653476,0.7334641034023722,-0.011047079361619833},
{-0.04981228512148582,0.7351436013478717,0.005257512334480784},
{-0.09559890341177402,0.7210313313974234,0.058282424887339035},
{-0.1504614345818456,0.7160334361117698,0.055778135329927335},
{-0.19658031995931596,0.7101145947516758,0.06353032177556694},
{-0.2003656006341921,0.7058090115962282,0.048374241715224676},
{-0.20505045972516917,0.6914884069769677,0.025660420900133984},
{-0.2064906398972643,0.6643717801609839,-0.0006346194526887917},
{-0.21123105489992458,0.6341269281640695,-0.030086731325200795},
{-0.21131652553328334,0.6144099214311202,-0.044509900704491685},
{-0.21454090517674257,0.5930914087056113,-0.048457575582749456},
{0.2399919230251476,0.10350386861454233,-0.07037758789052065},
{0.23155490312972093,0.1509069502582282,-0.08138086355254413},
{0.21711570800667526,0.1836560918125542,-0.09402090184338788},
{0.12551148832150633,-0.036178650717846574,-0.10314168680568464},
{0.0651959307431458,-0.022990531990589754,-0.11680309916516558},
{0.15432257044382763,-0.04318510588743094,-0.10525281144964604},
{0.16064098701487406,-0.05263281602232502,-0.06323010617589428},
{0.20237950243270791,-0.05900999365380557,-0.039771622467665385},
{-0.01028532234180988,-0.01508129325615337,-0.11699113455855485},
{-0.027542911599860682,-0.052978972087427995,-0.14979903717331522},
{-0.008418857385837942,-0.011720160599320118,-0.10957228358301442},
{0.01936978228492918,-0.00964749774037023,-0.1244719517432804},
{0.03080254787958043,-0.015993692267258164,-0.1271418406528247},
{0.07550796265788029,-0.02334523511902861,-0.1306450682376169},
{0.017109084032589955,-0.013830216860364591,-0.10401135050011004},
{0.03081430009166726,-0.01335051293063851,-0.07926119184524687},
{0.06780171667767101,-0.02111338320544796,-0.08325480718893497},
{0.08543430833958339,-0.029566428844629438,-0.09428265565804908},
{0.11151994564067719,-0.03183246901155351,-0.08914587059318754},
{0.1255617023186046,-0.04247569963055323,-0.08507426329655958},
{0.1494133509402838,-0.05046506708376339,-0.07307952828757448},
{0.1593386282390699,0.22224074085944992,-0.12952433455770015},
{0.1958677085536873,0.23602181210563314,-0.11074536802586342},
{0.18843924213189403,0.2739686365510889,-0.11306589572155376},
{0.21059323029848484,0.2955467663254251,-0.08967899366876284},
{0.20589448222958695,0.25082212065461945,-0.09440231454475136},
{0.2095825400590175,0.2777581907576329,-0.08514584495199755},
{0.2109885319777691,0.25725699096361726,-0.09223563398910677},
{0.21259858503366474,0.25099733545300495,-0.09305828883518484},
{0.2153005254307186,0.23352179607988938,-0.08152402686342006},
{0.20689342025696747,0.217341136802159,-0.09754229193776882},
{0.21825033066451283,0.22451960162137782,-0.08183385790934557},
{0.22793949533864535,0.19155785186657184,-0.07866289741173554},
{0.22292236916048608,0.20997891012121875,-0.07772165206187219},
{-0.23073759019822776,0.22331873922268736,-0.06231984393062348},
{-0.22966920728124324,0.2521821721079408,-0.043928700397652114},
{-0.22373006664572634,0.2769633138673966,-0.04466161107870349},
{-0.21794904668192316,0.2660187992658071,-0.0592834996805535},
{-0.22447472953886455,0.2785861875182959,-0.031828195479885545},
{-0.2205270546606068,0.28915997324769166,-0.03282179159268114},
{-0.2176296001897448,0.3157648446464399,-0.036394464067077345},
{-0.20965305333153844,0.2870509853695643,-0.022421083895836934},
{-0.22014136842757537,0.28998155971085277,-0.028416848825954005},
{0.19386021705267342,0.6034141244495157,-0.11994200817526607},
{0.17413145810763744,0.5207928683303524,-0.13665472214565477},
{0.17775754972788288,0.49045613540257726,-0.1436536986348203},
{0.20112949441983605,0.5489436898099774,-0.14142291510415664},
{0.21399816665491447,0.5808936809423991,-0.1266461109793439},
{0.21521078126569188,0.6367904067761117,-0.09300166454058464},
{0.19381107143849213,0.620642867368808,-0.11145156913399017},
{0.1496291642895147,0.6076417156520234,-0.12108945142810744},
{0.2451105455804204,-0.08928369198947857,-0.1138703880580431},
{0.2244394729026041,-0.08623239037857085,-0.13609916302882283},
{0.25161058724735413,-0.0937805156870664,-0.11608621422786897},
{0.21280798808539372,-0.04572251531526918,-0.11987470005149606},
{-0.2135323517031092,0.05254200347438122,-0.03163054464024341},
{-0.23623548868903005,0.03199913674660302,-0.026326023457415318},
{-0.2247567826289485,0.055240738722684,-0.011039600681200941},
{-0.2231274986805471,0.0489490317245623,-0.004215838990420872},
{-0.25775058387126415,0.0035245952431318373,-0.02335805571403235},
{-0.2550593273033801,0.0005299179268242541,-0.04108359668972236},
{0.003126088415096683,-0.01231845503283145,-0.08013085553967227},
{-0.028053598634179267,-0.01121054194791856,-0.07998128193129443},
{-0.013859063199123068,-0.015527877315452927,-0.0711543022711684},
{0.0030780111838323767,-0.01570843402842328,-0.06417776182325954},
{0.012070590196091007,-0.008430609597924871,-0.06562435229285657},
{0.025517257589258054,-0.011601570095534868,-0.061758942899206616},
{0.03463483740280387,-0.018366570725880795,-0.07032310036175445},
{0.048316549037707504,-0.01771592552943726,-0.07688297147203935},
{-0.0363698912599867,-0.0059722605059435155,-0.12783522116594764},
{-0.05676852629397197,-0.04891698023705291,-0.1532018367639109},
{-0.08650589640531883,-0.0036869894465136454,-0.13204785500761757},
{-0.09539591065754696,-0.048562277108614056,-0.15234178851573835},
{-0.09254867018378322,-0.04538490631350209,-0.16047538766274144},
{-0.15658326869616684,-0.038394476887672474,-0.1589379846452007},
{-0.2077235537834644,0.3780953724062332,-0.036758782641769065},
{-0.2073325256358481,0.38933262392707635,-0.03875238516486216},
{-0.2080846672094052,0.4098402340185941,-0.041503471176097276},
{-0.20621072357301434,0.40304211351782177,-0.032633756199291875},
{-0.2054222569802798,0.39216597542291937,-0.029932884185155027},
{-0.20759748459926022,0.38023534338895343,-0.017765071143618433},
{-0.20204616696260874,0.379569740831672,-0.01948837278871445},
{-0.20150770197244855,0.36250018696701036,-0.02957924943963315},
{-0.2107737870114552,0.3505182725530291,-0.04289023220234317},
{-0.19573202392323027,0.3273973978465673,0.0016378310117372624},
{0.23912012256488827,-0.021247999452987963,-0.058570888274924834},
{0.2568072017555668,-0.08844073786797786,-0.08450267843597288},
{-0.055111464389728984,-0.0492353583463142,-0.16548076162881387},
{0.1635192105932303,0.6690534341032099,-0.07862977754130902},
{0.14108744286822353,0.6624080923595663,-0.09051233234401074},
{0.17539962863009806,0.6896967288251846,-0.04007183806733803},
{0.18293600172650681,0.6947106498545931,-0.010490451861870902},
{0.11729776045572941,0.7181445607557312,0.04184001179494742},
{0.11079130849129375,0.736099804058573,0.027110216518481965},
{0.09899315593903381,0.7490261689711687,0.015524672166701932},
{-0.22037107075472706,0.014674239364782191,-0.011119729399974779},
{-0.22325143109891732,0.0034380562268560943,0.0009978696444635407},
{-0.24227933085041145,0.0005694480947526316,-0.019781109707968206},
{-0.234100859620895,0.014392186274698236,-0.025275803050019544},
{-0.2449385359307859,0.0013643249849891908,-0.03398312382344331},
{-0.24765543368867748,0.0034102782710145286,-0.007617570198099552},
{-0.2144917595625613,0.046379570809214565,0.005920978125928165},
{-0.22736897886097562,0.056819808673987206,-0.0029070699171148454},
{-0.22387964025410417,0.05790421733472647,0.004783150319339661},
{-0.24288724073017562,0.058703367756630855,0.007736160701884849},
{-0.24796205958585207,0.05440098974993423,-0.0029444633192093035},
{-0.2419160806586367,0.0614074449195186,-0.013387906332732895},
{-0.2221339025677515,0.06189569591258056,-0.01771485714652016},
{-0.212579354141159,0.061878601785908795,-0.027646544742808175},
{-0.2068229069844465,0.06727927743126552,-0.023806776539165842},
{-0.2155953991158063,0.06592670465836314,-0.0193537565411744},
{-0.21135605570121177,0.07921525137981644,-0.023270448314839615},
{-0.21847575945999656,0.08035414756932194,-0.024830287373637006},
{-0.2193208503473313,0.0921191802511554,-0.03160917698190373},
{-0.24051970418613794,0.084138359861281,-0.025146528717064416},
{0.19733459829870706,0.506957309555403,-0.1497381393470471},
{-0.23447906717350753,0.2265580762269843,-0.049575104113915254},
{-0.2306446408844501,0.23780066966241237,-0.04320006324826868},
{-0.23674617572334866,0.2101103212200077,-0.0528069624377934},
{0.21613920602055142,0.6701389111468663,-0.06627179234054918},
{0.2566982266980344,0.6711549433009185,-0.049571898965164306},
{0.25658925164050195,0.6589379846452007,-0.07371628450609725},
{0.2289897157460411,0.6366023713827225,-0.09554655264884176},
{0.23936798740162865,0.6136834210475707,-0.11593557223657415},
{0.2493028801466676,0.631329901687404,-0.09754870223527073},
{0.26101235691681784,0.6566869018391143,-0.0688027914708855},
{0.2674482956087325,0.665470077799644,-0.04235817750968489},
{0.2246392605080802,0.5720442652410164,-0.14082675743647927},
{0.2384545200076069,0.5939290209125272,-0.12411511184900757},
{-0.08472490208270565,0.4851494774539153,-0.10250386220424489},
{-0.046719316576815655,0.46512584482379155,-0.10583935367107053},
{0.23419487731758964,0.03670963702758773,-0.05323752075333815},
{0.23609766729273907,0.07513402863693568,-0.08833924149086425},
{0.24516930664085454,0.09090442887454406,-0.04193830302330997},
{0.24191714904155368,0.10815133430342504,-0.05366594230304894},
{0.24330818359946751,0.1330841864370925,-0.05931768793389701},
{-0.01273512437045536,0.7568061333726499,0.03713805857729858},
{-0.03537308999844016,0.7287322354630478,0.05940529533308975},
{-0.013279999658117462,0.7513060981160135,0.04968514755436467},
{-0.0032863458526443496,0.7619162088645868,0.03411987683681734},
{-0.009017151819349265,0.7578937471821401,0.04789240101966466},
{-0.01780353292862988,0.7383070831650629,0.06188180693465985},
{0.2037684002247878,0.5080064615798818,-0.1491857853789661},
{0.21012848372959655,0.48357147588552923,-0.1397273914149022},
{0.21337743618014646,0.501852575978051,-0.1390468314967831},
{0.21942020995861086,0.5206667991461484,-0.13636198522640103},
{0.21693087776203696,0.5489821515949889,-0.14663662373904104},
{0.08206356023649725,0.761351034301502,0.005652814013765053},
{-0.006392134992318322,0.7384758876659465,-0.004813065041015212},
{-0.024032205334649573,0.7362750188569585,0.009185956320232832},
{-0.038101739968418605,0.7350987292653586,0.013480855646510562},
{-0.06858484135582066,0.7300356626217689,0.04365305760507013},
{-0.09920362737367974,0.716300531841016,0.0787558467255132},
{-0.15252341361162572,0.7119436663055532,0.07691395457663192},
{-0.1884050538785505,0.709615659929444,0.08005606873548336},
{-0.19427368124154643,0.7043570792120462,0.0835016036427584},
{-0.18772449396043137,0.6999916666132474,0.09298991232849783},
{0.011646442178048154,0.7475282961215562,-0.013691327081156496},
{0.03498847214832575,0.7703842118646059,-0.003511774648128079},
{0.015221251418278325,0.7695369842114371,0.0053686241578471735},
{0.0010171005369692557,0.7660796970920752,0.019241576334891042},
{-0.01659839699827135,0.7426286920642653,0.0031228832663457323},
{-0.04256651217849687,0.7322578990890968,0.025064263232456627},
{-0.05416060359361277,0.7265741019707391,0.04480584277249641},
{-0.06607948341549198,0.7102481426162988,0.06914040047265262},
{-0.013053502479716742,0.7419865939311575,0.06968100222864676},
{0.22872582516554593,0.5593561497189083,-0.13657566180979794},
{0.05592877732122215,0.7685220204403018,-0.0013162477537249093},
{-0.05729310230621136,-0.052188368728859375,-0.15774994284151395},
{-0.2301830994643128,0.11054237527163634,-0.042843223353995846},
{0.03264871356012966,0.7707485304392975,0.003394252527259798},
{0.008373985303324599,0.7681929585018706,0.019073840216924477},
{-0.24462229458735846,0.1818975335311979,-0.0431712169095101},
{-0.05897046348587704,0.7157759558287766,0.06563183097327548},
{-0.05113280640687868,0.6983848187061027,0.08545140246625514},
{-0.04876099633117306,0.7318828966852352,0.04334963685664652},
{-0.19656749936431214,-0.045429778396015426,-0.022601640608807313},
{-0.20352267215388134,-0.049193691412551796,-0.026917907593424734},
{-0.22630273270982507,0.016754380904151066,-0.045525932858543956},
{-0.23706134868385909,0.009586599914101905,-0.040085727045258826},
{-0.2595903392543114,0.00040919065720497266,-0.036265189734122225},
{-0.10614597956824509,0.0025085630890795303,-0.07995991427295474},
{-0.08788411036822885,-0.0027777955841597774,-0.08613516753312521},
{-0.0742312450720838,-0.0047115686639017185,-0.09587775135310696},
{-0.061091203576091296,-0.0004433789105486298,-0.09340871843195575},
{0.23153994576888312,0.17435475013728718,-0.07290217672335506},
{-0.1468332061957662,-0.05882730017500118,-0.03726626452733671},
{0.23481026587777273,-0.045911619091575415,-0.09112451575544286},
{0.20031431825417684,0.42798137594899105,-0.1301482701812191},
{0.20670645324649517,0.46552648841766076,-0.1371760930091432},
{0.21336568396805963,0.49228200180770376,-0.13426368117744344},
{-0.22755060395686294,0.26955087318935794,-0.040850689213819735},
{0.014027867700006627,-0.012978715675527885,-0.05823114250732375},
{-0.2484631311739178,-0.002445528496977648,-0.05044369942542366},
{0.08757641608813732,-0.037191477723147834,-0.09268969672882517},
{-0.21226524956356557,0.49146041534454266,-0.05597044425498453},
{-0.21136353438163064,0.5062714077226991,-0.05605484650542631},
{-0.21168618602255998,0.5211849648608857,-0.056046299442090435},
{-0.21395543133823508,0.5406017559941624,-0.05373111366098499},
{-0.2121274281672746,0.6683696690363399,0.0007542783393910719},
{-0.21070220535601725,0.42055931982469963,-0.042715017403957715},
{-0.19580360557866822,0.3951606527392268,-0.00207907315645185},
{-0.19527689280059488,0.4034609196212796,0.006626110851137942},
{-0.1856870877377419,0.39085506958377925,0.016394335861127325},
{-0.017519343072712,0.7172866492733928,0.07624194172184866},
{-0.2121445222939463,0.47154682615486854,-0.05603882076167154},
{-0.16446152432601063,-0.04988600354275786,-0.028234155347149653},
{-0.2402216253522993,0.10585537941482513,-0.03546710769513479},
{-0.2127737998320502,0.4424857424299728,-0.04982083218482169},
{0.2470272245334906,0.11725395675613291,-0.04755692878373151},
{-0.2395421338170971,0.1983185789652497,-0.04630585238794265},
{0.32047641331034177,0.2309576770791266,-0.020080256924723868},
{0.3286249698181827,0.266242091295457,-0.04430583956734765},
{0.3068961980525516,0.2513531069643607,-0.014863343141088505},
{0.3244956698440375,0.20416156513823794,-0.018907172481874877},
{0.2982348177445582,0.21561142485956103,-0.011519304610926985},
{0.2834740393635002,0.25372491704006644,-0.016040701115605432},
{0.30323164464729474,0.27505304521182816,-0.02272877817592847},
{0.3137744472720979,0.29769742113731495,-0.03963273268845739},
{0.33208866723504643,0.3126825599309396,-0.058509990448656714},
{0.33838464776483607,0.29979679356918953,-0.0694427528381592},
{0.331912384053744,0.2604151308662234,-0.08722171295969845},
{0.33907909666087604,0.21443299850212702,-0.054765308324626005},
{0.3347542826129228,0.20114552016359064,-0.029985234948087268},
{0.3250768701508771,0.19290935625655709,-0.012129351256525141},
{0.3173813079998376,0.18689649719976828,0.007904965202768401},
{0.30861522616597964,0.1936593610642802,0.007540646628076683},
{0.30562802753009105,0.2073143631262594,-0.008493644190026852},
{0.29193776883185146,0.20320429404461982,-1.0683829169837257e-05},
{0.2622805274392785,0.2370752376617798,-0.018989437966482683},
{0.2576565661745695,0.2609760318976404,-0.030956395019626187},
{0.28844415669331214,0.27441735737622247,-0.03075767579706707},
{0.2899302773308376,0.2861043981051161,-0.029271555159541614},
{0.27051241781464413,0.29826259570039976,-0.035982068261121325},
{0.29436940835090825,0.3162605743199207,-0.03926093543334679},
{0.31457466607691936,0.31663985025545033,-0.04492015974461374},
{0.33138246612691963,0.3253215298388663,-0.06859979871665843},
{0.34100966459186705,0.31755545441530597,-0.09325914482357792},
{0.33030767291243324,0.27461393983294763,-0.10240129744421438},
{0.3300149359931795,0.24163509595146962,-0.1108009239375466},
{0.33719446919531537,0.2261777319085378,-0.07142780829791644},
{0.33306089568950226,0.19220529191426433,-0.07008057743959896},
{0.32825424094598893,0.16991134558554857,-0.03569039972478455},
{0.322119586236664,0.17767421586035803,0.002832283112925945},
{0.3217766353203119,0.16664316224249304,0.008294924967467747},
{0.27302098090372373,0.16997758532640161,0.014145389820874928},
{0.2310816094974968,0.34490285194135856,-0.13746455639672905},
{0.20953018929608525,0.3626070252587088,-0.10426135210268442},
{0.21123212328284155,0.3785430248484499,-0.11989927285858669},
{0.2311425073237649,0.3748421464240154,-0.14546994959369397},
{0.2087620219787734,0.40362758735632925,-0.1283277456906775},
{0.21544582550742847,0.33504808791509333,-0.11088532618798838},
{0.23864576054974712,0.3207616715491765,-0.142157962551042},
{0.26326557648873816,0.3155351423192884,-0.15675527834580136},
{0.2574535734203424,0.345978713538762,-0.15699566450212288},
{0.23182199885896707,0.41785096913014397,-0.14378831488236035},
{0.2019863375192576,0.4133851285371486,-0.12483199678630418},
{0.28573153246708843,0.38922685401829504,-0.009517155024498012},
{0.25452620422780486,0.43384572978031916,0.018486229612582995},
{0.24479644100282694,0.3607063720493934,-0.005802387622142869},
{0.25038194689282195,0.33639425039049387,-0.016431729263221766},
{0.244931057250367,0.31999457261478165,-0.022852710594298675},
{0.23922268732491875,0.2923672587644791,-0.02922134116244334},
{0.2243689596300831,0.34003743613741116,-0.0196091000583337},
{0.22329630318143065,0.38839031019429615,-0.002990403784639637},
{0.22534973514787487,0.4159759571108362,0.007041711805844916},
{0.2896076256899083,0.4754464238018619,-0.11108831894221542},
{0.29822092876663736,0.5103472885509949,-0.05956127923896947},
{0.30983745622300995,0.4249258008064153,-0.10359681792832005},
{0.283488996724338,0.44706696837800247,-0.1319762733521796},
{0.3050585794353383,0.37759109566941673,-0.1337583360577098},
{0.31836528866638036,0.41945461188853767,-0.07959773246409697},
{0.31220712953288166,0.4610082970617332,-0.07563723699083541},
{0.3073117990072585,0.49258328579029353,-0.04739132943159891},
{0.2950360792911066,0.5403944897082673,-0.017118699478842803},
{0.2947764622422793,0.5861586719572988,-0.008845142169714756},
{0.3007978683624041,0.5473507308807534,-0.05440846843035318},
{0.2992636704936143,0.5261230307031882,-0.07293636497669856},
{0.29030955326636704,0.500276711175499,-0.1056288822364246},
{0.2759494184791783,0.47279362901898936,-0.1333149571471612},
{0.27351884734303855,0.4310732761107442,-0.14407998341869713},
{0.30321882405229095,0.32849355871939334,-0.15165802344886825},
{0.3044827210430836,0.3588559328371764,-0.14224663833315168},
{0.3211462893992911,0.37793511496868565,-0.10692910424639473},
{0.32451276397070916,0.38188278984694346,-0.08791402508990442},
{0.30011624006136794,0.4587272995339713,-0.02739974828898475},
{0.30096774124620457,0.5050523828144198,-0.017011861187144355},
{0.33282264629901476,0.12896663867503416,0.008711594305091708},
{0.30314617401393595,0.14087162951899246,0.03434423724938408},
{0.282108645995594,0.137592762346767,0.04075560313420813},
{0.2637185708455396,0.15768797663232875,0.019815297961311727},
{0.31322102492109993,0.15814524452079823,0.014888984331096148},
{0.3340790646093885,0.15730656393096534,0.003819468928219633},
{0.34155453987952916,0.12805851319559733,-0.011462680316326806},
{0.33971478449648185,0.10006367562185221,-0.017338786359741617},
{0.3261335008557748,0.10237672463712365,-0.05973435727152097},
{0.31320179402859427,0.08755184328104658,-0.06636367327140985},
{0.29735767536971397,0.10903809212452206,-0.07275580826372818},
{0.285283880024872,0.13666647435774149,-0.09438628880099659},
{0.26918228108299835,0.09356790748658629,-0.06110829770276304},
{0.24894604025239478,0.23411688536464964,-0.021925354222356117},
{0.24352613371453236,0.1964083103096815,-0.02619461235862622},
{0.28326356792885427,0.19149054374280167,0.0016186001192315413},
{0.26263950409938525,0.1745630848060991,0.0094156586473845},
{0.2540400900005769,0.16218907386158452,0.01094344621867235},
{0.24016606944061608,0.1719487518082379,-0.013434915181080212},
{0.23624296736944897,0.17903319893076225,-0.023698869864550408},
{0.2295997623916393,0.1915140481669753,-0.037361350606948326},
{0.3108994288424926,0.2829815148387704,-0.1418043278055201},
{0.3037861353812097,0.276378908411806,-0.14562272835082277},
{0.3200202138047894,0.21342978694307854,-0.11667916674679538},
{0.3284497550197971,0.19439227174533152,-0.10214595392705508},
{0.3342232963031814,0.1691036481003083,-0.0807975264798706},
{0.3413729147836418,0.14657786267860679,-0.03749596685448838},
{0.24698983113139614,0.12195056805919689,0.007001113254999505},
{0.24889262110654556,0.1347978726359356,0.002828009581258007},
{0.24455071293192052,0.15778840462652535,-0.0003205148750953457},
{0.26946112902433134,0.394254664025624,-0.1510266091449304},
{0.23530385878541957,0.45286935600014533,-0.142155825785208},
{0.28253065724780285,0.3181003297029681,-0.1604892766406622},
{0.32624033914747325,0.3195351679604784,-0.13020596285873626},
{0.3228856167881418,0.3328568345523583,-0.12599439739998333},
{0.3245063536732073,0.3368600653422992,-0.10070684213787695},
{0.3230672418840292,0.3457255067874366,-0.09232430977121647},
{0.31962491212550503,0.357977722079415,-0.07821951850118695},
{0.30583208866723505,0.38294583084934286,-0.05614672743628698},
{0.29883845409265447,0.4088466379057984,-0.044397720498208317},
{0.2830872847475518,0.44963215576168214,-0.013685985166571572},
{0.26442584033658334,0.517036433994235,0.027060002521383693},
{0.2790156774509238,0.5393891413833848,0.022374075047489627},
{0.28808945356487325,0.552409523992675,0.007094062568777158},
{0.271895973692139,0.6395959803161131,-0.07953469787199491},
{0.28823261687574925,0.6203864554687317,-0.04290412118026397},
{0.27723361474539365,0.6117250751607382,-0.07534877360324958},
{0.263621348000094,0.5729481171887854,-0.11123896093351025},
{0.27889708694713855,0.5797024339899614,-0.09104866056833696},
{0.2824793748677876,0.5805069263264507,-0.06678568452361874},
{0.29015677450923827,0.6114430220706542,-0.013506496836518176},
{0.2868426507007524,0.646630213441539,-0.013650728530311084},
{0.279690895454458,0.6577296435660913,-0.04910501563044207},
{0.2668019239439569,0.6564817723190534,-0.07059446962266852},
{0.25683284294557446,0.6309538309006253,-0.09922499503201944},
{0.24939582946044525,0.5989632412173581,-0.12029030100620303},
{0.2621555266379913,0.5414019747989837,-0.12647623809554334},
{0.2745477000920946,0.5396850834513897,-0.11156374934027354},
{0.28535011976572505,0.5374361374111372,-0.07977935755998435},
{0.2870189338820548,0.6303309636600234,0.004476524422165107},
{0.2774066927779451,0.6623578783624682,-0.03319252046487477},
{0.3112605422684333,0.1382701171161352,-0.08789693096323267},
{0.3203076088094582,0.16922544375284448,-0.09665553411667169},
{0.32599674784240074,0.12355634758342465,-0.07512654995651681},
{0.283486859958504,0.21834434836120747,-0.13232990809770148},
{0.2799911110541307,0.2072470550024892,-0.12964078829565145},
{0.2748489840746843,0.1582681085562513,-0.1046139184652893},
{0.2770210065449138,0.1271311568236549,-0.08724201223512117},
{0.25777195152960386,0.12156381344324853,-0.07286905685292853},
{0.2525796105530591,0.0932890595452535,-0.03740194915779373},
{0.256729209802627,0.07946738974822491,-0.0220439447261414},
{0.24196415788990103,0.45094306160082226,0.025461701677574864},
{0.25523774725051657,0.47278187680690253,0.025701019450979395},
{0.2827646331066225,0.4110400280343677,-0.0033985260589277206},
{0.31029045057981136,0.37697357034339946,-0.03331965803199592},
{0.305629095913008,0.3636422883052668,-0.032805765848926374},
{0.28654350348399665,0.3547608211163745,-0.030332459396107233},
{0.2829259589270871,0.33705237426735624,-0.04515947751801827},
{0.26310852419994146,0.3173310940027392,-0.03183246901155349},
{0.2557163827973256,0.2860402951300968,-0.031051481099237808},
{0.24911591313619533,0.27470047884922333,-0.03778229347624022},
{0.2585369136981647,0.27200067521800353,-0.033327136712414815},
{0.24751227037780157,0.25730934172654946,-0.0481648386634957},
{0.23932097855328133,0.2626608717577249,-0.05195652963587373},
{0.23655920871287636,0.24885522770445098,-0.0506691282209074},
{0.23614894967275432,0.22819911238747248,-0.035368816466772215},
{0.25322705060075174,0.5190054637102375,-0.13546133842738306},
{0.26246749444975076,0.5202939335081207,-0.11736293181366546},
{0.2584001606847907,0.5100566883975751,-0.12493349316341772},
{0.3377457547804793,0.33075853050340065,-0.10336070530366648},
{0.33816562926685434,0.34069662839719045,-0.0870539768417319},
{0.24541930824342892,0.17990606777393867,-0.09830404895757879},
{0.2367087823212542,0.16425425804011554,-0.07153678335544884},
{0.23890003568398943,0.15109819080036835,-0.06675790656777714},
{0.23786263587159748,0.2249661856806774,-0.10940347908213086},
{0.2241061374325049,0.24443639595980313,-0.11527317482804376},
{0.2463530749128734,0.2993106793419615,-0.13670600452567003},
{0.22694483084293277,0.28791530714940483,-0.11450287074489793},
{0.21493620685602685,0.3118855462748692,-0.09933503847246883},
{0.2275623561689498,0.3190276860749107,-0.12295698476699636},
{0.22117769985705038,0.3224422378775932,-0.10475067147866332},
{0.21917555027062138,0.2789547796246556,-0.0872601747447099},
{0.23879747092395892,0.25606788077701337,-0.13193994833300213},
{0.2622228347617613,0.2845445590463187,-0.14891762126680297},
{0.25494180518251186,0.23731989734976927,-0.13233097648061848},
{0.2725167041669071,0.2618478323578997,-0.14700521584540072},
{0.26848142188945656,0.18514862274758168,-0.1173672053453334},
{0.25143109891730075,0.10738103022027924,0.01140071410714172},
{0.32255014455220865,0.3640418635162191,-0.05499073712010974},
{0.2927102096808313,0.4104748534712829,-0.029446769957927072},
{0.2484556524934989,0.5206197902978009,0.03844255411893667},
{0.26721645651574694,0.5648893048459711,0.03534851719134952},
{0.2768522020440302,0.5954771077592378,0.029034374151971066},
{0.3063117925969611,0.33207370987420853,-0.05521296076684252},
{0.32909826345040677,0.33892845466958116,-0.07433380983211431},
{0.22984976399421364,0.4934144876997074,-0.13825622813821456},
{0.24803364124129001,0.4929785874695778,-0.13435449372538713},
{0.2432558328365353,0.5053333675215865,-0.13921029408308172},
{0.3067647869537625,0.3454562742923566,-0.053219358243749425},
{0.32615166336536344,0.35271807297910024,-0.06126534999155977},
{0.2202236339121832,0.32225633925003777,-0.02894356160402737},
{0.22335933777353273,0.29805639779742166,-0.037128443131045706},
{0.23050575110524213,0.28301142956044584,-0.03830259595681168},
{0.23320555473646198,0.49151169772455794,0.03344786398203408},
{0.2660679448799886,0.5968360908296421,0.029081383000318387},
{0.2818864223488612,0.617185580249446,0.018912514396459818},
{0.2299298927129875,0.47822849291768965,0.029996987160174113},
{0.2290516819552262,0.45375077190665736,0.021700993809789387},
{0.22943416303950667,0.44281053083673594,0.0203687203123097},
{0.24193958508281038,0.5227490774513512,0.04070004722252493},
{-0.22019051404175669,0.4713064399985469,0.09043006685940295},
{-0.21930161945482557,0.5224937339341917,0.09879764186522563},
{-0.2329491428363857,0.4672027812144094,0.0874888086889446},
{-0.23283482586426835,0.41429111725075146,0.07286478332126062},
{-0.2560422395870059,0.442679119737947,0.06867244875501338},
{-0.25188409327410216,0.4728085863798271,0.07463295704886998},
{-0.2266926924745244,0.5603636348096248,0.09788631123703785},
{-0.20284531738451314,0.5699128413216323,0.11397829473265855},
{-0.1719754613811627,0.5714694752316788,0.12250933232477987},
{-0.1745908627619408,0.512271446184484,0.10499212601790184},
{-0.18716679807776546,0.471435714331502,0.08712449011425288},
{-0.20754833898507896,0.44814069320957184,0.07917999474355607},
{-0.21505907089148008,0.4085154392015334,0.06099184396481175},
{-0.2423423654425135,0.38503558783496467,0.05806126962352323},
{-0.23821413385128537,0.4014780009273563,0.06608482533007691},
{-0.26082432152342855,0.41131353406111576,0.053742865873071845},
{-0.2978427212140249,0.4307014788556336,0.04004299172857946},
{-0.2823298012594098,0.4642850274681246,0.04365198922215314},
{-0.2770135278644949,0.49577134041457516,0.04586995215781298},
{-0.27403914982361,0.5157340752184308,0.042775915230225836},
{-0.2673179528928604,0.5374735308132317,0.03695963863016217},
{-0.2557879644527636,0.5728989715746041,0.05073429957884346},
{-0.22299715596467498,0.6206097474983814,0.09546535554715095},
{-0.2115184499045934,0.6349794977318229,0.10831800203847461},
{-0.18793496539507734,0.6457936696175401,0.12566854061030305},
{-0.17872550465067083,0.6281760353164657,0.12879249225956577},
{-0.16966668589755918,0.6194281159921964,0.12345057767464322},
{-0.1619177046006705,0.5631424987767014,0.1146022303561775},
{-0.1629454889668096,0.5261743130832036,0.1056214035560057},
{-0.16513567394662787,0.49083113780643883,0.08575054968301081},
{-0.17269448308429328,0.46747094532657246,0.06432519866580341},
{-0.1754647999880341,0.4532091017677464,0.056163821562958745},
{-0.1894937360709577,0.43627416415062487,0.06343844084470628},
{-0.20241048553730043,0.39253349914636193,0.019989444376780203},
{-0.21992662346126152,0.36475981683643266,-0.0059936281642830975},
{-0.213891328363216,0.3702502366468161,-0.01301717746053927},
{-0.23651540501328003,0.3952482601384197,-0.04892125376872073},
{-0.22881236418182166,0.3820024487336456,-0.03857823874939369},
{-0.23763507031027978,0.3777417376607115,-0.05433154486033029},
{-0.25236272882091126,0.37804409002621814,-0.06535511979777647},
{-0.24348874031243792,0.3688378344305625,-0.0520825988200779},
{-0.23029741643643012,0.3569990833274573,-0.03927802956001854},
{-0.21798537170110063,0.370537631651485,-0.025368752363797195},
{-0.2182108004965844,0.3896456601217529,-0.023150789428137353},
{-0.22199821793729446,0.4005047040899835,-0.02508349412496233},
{-0.22481554368938264,0.4053081536847457,-0.03222242877625283},
{-0.22641170776735747,0.4071009002194458,-0.044314386630683524},
{-0.26096855321722146,0.4018252253753764,-0.07181135776511388},
{-0.28100286967651494,0.3773977183614423,-0.07781139622689888},
{-0.2720263164080112,0.36463695280097935,-0.08280074444921653},
{-0.2591864905116913,0.3637512633627992,-0.07269063690579212},
{-0.2352408241933175,0.3598388451208019,-0.06176321643087455},
{-0.22888928775184456,0.3502436981433641,-0.060180941330820484},
{-0.22579845597300838,0.3368087829622839,-0.037654087526202085},
{-0.22947476159035204,0.34817530881608216,-0.030977762677965877},
{-0.21229943781690908,0.3886435169456213,-0.023731989734976925},
{-0.22870125235845526,0.41745032553627476,-0.04503554509964807},
{-0.2701459624741184,0.40924407635091664,-0.07582634076714166},
{-0.2909163947632143,0.38981232785680253,-0.08248877663745706},
{-0.3132188881552659,0.3791594817915498,-0.0815144114171672},
{-0.2958630076688526,0.36665833327991404,-0.08473344914604153},
{-0.27303486988164455,0.3460631157892037,-0.07832422002705144},
{-0.2309651557595455,0.3372339993632436,-0.06474079962051038},
{-0.2860744833834405,0.4709239589142666,-0.057724729004673105},
{-0.2795936726090124,0.49899785682386844,-0.04739026104868193},
{-0.2450881095391637,0.5016805663284167,-0.059834785265717505},
{-0.22915638348109071,0.48935356423224935,-0.06251642638734863},
{-0.24716931946144954,0.5401776079761196,-0.04611461184580242},
{-0.24459131148276592,0.5769898097637376,-0.029916858441400258},
{-0.2663318354604837,0.5407107310516949,-0.030605965422855267},
{-0.28399861537573956,0.5172682730872206,-0.02350976608824415},
{-0.30727440560516406,0.4693961713429787,-0.03364658320459318},
{-0.3235074156458268,0.42486810812889814,-0.051524902937411986},
{-0.28475716724679856,0.4409750489853567,-0.07106990002072662},
{-0.25191828152744566,0.4483426175808819,-0.07081135135481637},
{-0.20848317403744043,0.2123229422410828,0.01070412844526782},
{-0.21391803793614061,0.2152278753923636,0.03567864751269774},
{-0.2005942345784268,0.19076404335925218,0.037321820439019916},
{-0.20061773900260044,0.1972993416624466,0.023843101558343332},
{-0.31736528225608285,0.307761588215309,-0.07488936894894624},
{-0.3370267330773488,0.2939879956495446,-0.026588845654993507},
{-0.3312852432814741,0.3344668876082539,-0.05927708938305159},
{-0.31893366837821613,0.34460477310751975,-0.07430923702502365},
{-0.3285544565456617,0.3751680032136957,-0.07452611875717152},
{-0.3385652044778065,0.35165396359378365,-0.054842231894648895},
{-0.34155453987952916,0.32779590467460246,-0.03358675376124205},
{-0.3372713927653382,0.3138032936108564,-0.026412562473691066},
{-0.323566176706261,0.28341527830306595,-0.0031410457759344537},
{-0.3320897356179633,0.2680572738714136,-0.006656025572813493},
{-0.32667196584593494,0.2792838415630868,-0.039110293442051976},
{-0.301700651927256,0.2239116917416136,-0.05195011933837182},
{-0.29907990863189293,0.23992675166721147,-0.06618311655843946},
{-0.30802120526413623,0.29970811778707973,-0.08001119665296999},
{-0.28004453019997994,0.3219165934824369,-0.08640119487945436},
{-0.31390906351963793,0.36049483223183054,-0.08384775970786137},
{-0.31648707149832156,0.40451968709201125,-0.07189469163263866},
{-0.33719660596114925,0.38077273999619654,-0.061756806133372644},
{-0.34144449643907976,0.34967745519736243,-0.019064224770671597},
{-0.3294048893475812,0.30887056968313903,-0.011265029476684672},
{-0.32858116611858623,0.313824661269196,0.005576958826659153},
{-0.3196729893567694,0.2839323756348864,0.014885779182345195},
{-0.31316226386066576,0.26276129975192153,0.01278640675047063},
{-0.31930867078207764,0.2452163154892017,0.013669959422816822},
{-0.3147541544069727,0.23243845580206698,0.006013927439705818},
{-0.32035354927488857,0.24386481109921646,-0.014945608625696313},
{-0.3155789460188847,0.22258903369038693,-0.03136024376224633},
{-0.28826466836325876,0.18932493157007405,-0.04930800838466912},
{-0.2890488614243254,0.21459325593967482,-0.06657734985480676},
{-0.26452519994786294,0.2272835082276169,-0.06935194029021553},
{-0.29284268916253736,0.2712880638123749,-0.07810092799740168},
{-0.2755947153507395,0.27530518358023665,-0.072009008604756},
{-0.2562270698316442,0.2901332700850647,-0.06956454849069545},
{-0.26691410415024025,0.32358540759876653,-0.0791896101898089},
{-0.18746808206035506,0.14325091827511718,0.061331589732412824},
{-0.21779840469062833,0.1536665833327992,0.07171734006841925},
{-0.18832599354269364,0.1306749829592923,0.07129426043329339},
{-0.17647549022750145,0.13330641008382527,0.06348438131013662},
{-0.1749060357224512,0.12805958157851444,0.07095130951694135},
{-0.18876082538990635,0.11692809996645265,0.07905499394226886},
{-0.19510060961929243,0.11379987478552195,0.0812259480295814},
{-0.23862652965724138,0.15271038062209796,0.07119703758784779},
{-0.21157080066752562,0.17403530364510877,0.05028771551954394},
{-0.21077058186270423,0.16212283412073147,0.058585845635762634},
{-0.1937982508434883,0.15271038062209796,0.04657829003177371},
{-0.17494449750746266,0.14113872524823867,0.046055850785368294},
{-0.21508578046440469,0.29784058444819095,0.000950860796116222},
{-0.23042241723771734,0.3015425312555421,0.013908208813304367},
{-0.23086259099951492,0.27559471535073937,0.027483082156509558},
{-0.21039664784175965,0.2690476648354584,-0.008706252390506769},
{-0.21455052062299546,0.2514556717243913,-0.000332267087182175},
{-0.2342953053117862,0.24890116816988134,0.028947835135695325},
{-0.24184663576903273,0.26799637604514553,0.035210695795058526},
{-0.2689109118220843,0.29464932467515814,0.047113549873182954},
{-0.23870772675893223,0.3246815684715926,0.02533776925920466},
{-0.22068838048107145,0.3262392707645562,-0.007633595941854321},
{-0.22292771107507098,0.3306303245533624,-0.020910390451220832},
{-0.21075669288478344,0.2866108116077666,-0.00896480105641702},
{-0.21126844830201905,0.6618771060498251,0.09544612465464523},
{-0.20554084748406506,0.6923548655226421,0.09095784802039329},
{-0.2301147229576258,0.6482862069628651,0.040626328801253005},
{-0.22606875685100547,0.6438171612211189,0.06170445537044042},
{-0.23568099795511507,0.6263864939305165,0.03257820028760869},
{-0.2410752633029699,0.609740019700981,-0.003961563856178557},
{-0.22267450432374566,0.6580106282732581,-0.0018258664051265206},
{-0.21525351658237124,0.6926711068660697,0.03795109797712379},
{-0.20425130930326474,0.7077438530588872,0.07220665944439815},
{-0.19152045846447735,0.6921914029363435,0.10276134248723817},
{-0.187679621877918,0.6739156447584066,0.11619412090248443},
{-0.19917008015008644,0.6683846263971778,0.11260969621600139},
{-0.2328957236905365,0.6326429442923779,0.07953042434032698},
{-0.25099733545300507,0.6165210460750816,0.04179620809535105},
{-0.2528146547947957,0.6112507131455972,0.021677489385615725},
{-0.24800586328544838,0.5918809308606677,-0.021692446746453493},
{-0.22525678583409722,0.5973051109301981,-0.04487849281085134},
{-0.2278166313031921,0.6261332871791914,-0.02661982875958606},
{-0.20598849992628157,0.706917993064058,0.054997147417611664},
{-0.2444257121306333,0.36485917644771215,0.029192494823684776},
{-0.2713072947048806,0.3636433566881839,0.04454729410658616},
{-0.251410799641878,0.35393602950446246,0.031016224462977336},
{-0.25363410449212276,0.33521475565014297,0.0412684269343607},
{-0.30337160280941977,0.36568396805962416,0.05537321820439021},
{-0.27016198821787324,0.37903875452193075,0.05683903956649295},
{-0.2841684882595401,0.39168520311027627,0.056480062906386165},
{-0.32628200608123553,0.4020143291516825,0.013893251452466584},
{-0.29712904142547925,0.40941608600055124,0.03385705463923915},
{-0.3227606159868546,0.41579753716369977,0.01528749115913137},
{-0.3218289860832441,0.4295967709194716,-0.005924183274679104},
{-0.30988980698594215,0.45924653363162576,0.0015726596538012073},
{-0.3080906501537404,0.4689784336224377,-0.010149637711352842},
{-0.2822678350502247,0.5268388472575678,-0.006736154291587332},
{-0.2752442857539686,0.543650920839236,0.010381476804338497},
{-0.2555742878693667,0.574685307811802,0.0035812195377320872},
{-0.23907631886529188,0.6107004959433501,0.06287006113287053},
{-0.17462184586653334,0.6448673816285146,0.122361895482236},
{-0.23156345019305682,0.5850817419769785,-0.04268723944811611},
{-0.23101430137372675,0.5688829201896592,-0.03956542456468737},
{-0.25078045372085717,0.5850155022361255,-0.01580565687386884},
{-0.2570433143802204,0.567252567858341,-0.02454502913480214},
{-0.3174966933548719,0.4564708748133001,-0.025508710525922167},
{-0.28213962910018653,0.42503584424686486,-0.07454107611800931},
{-0.24672594055090097,0.43898465161101463,-0.06821411248362702},
{-0.2151605672685936,0.4276843654980694,-0.0500889962969848},
{-0.24983813998807686,0.4220614662059799,-0.0716158436913057},
{-0.29524334557700155,0.4060837996824765,-0.08081996252112726},
{-0.29371235285696273,0.28062359374098544,0.041673344059897824},
{-0.29131490159124956,0.25848883646690035,0.041485308666508555},
{-0.2757079639399398,0.2585625548881724,0.04241373342136809},
{-0.2541597488872792,0.24285518924266614,0.04882509930619214},
{-0.27477099212174433,0.22821727489706115,0.038291912127641846},
{-0.293762566854061,0.23801114109705832,0.027854879411620168},
{-0.31221460821330055,0.32789633266879903,0.03491902725872175},
{-0.29388115735784626,0.3137263700408334,0.04506652820424063},
{-0.26928164069427796,0.3157092887347568,0.04596503823742461},
{-0.24380925518753324,0.34926399100848926,0.014586631965589531},
{-0.22884868920099916,0.34445840464789307,-0.014616546687265081},
{-0.2771641698557897,0.14271459005079096,-0.04177270367117737},
{-0.25882003517116564,0.14921035818605663,-0.05030694641204964},
{-0.2628296762586085,0.17308551123190963,-0.05902922454631119},
{-0.2819537304726312,0.20252052897774975,-0.06289463393996114},
{-0.2990564042077193,0.18151825759566828,-0.0361839926324314},
{-0.2830477545796234,0.12793992269181206,-0.014672102598948276},
{-0.260104231437381,0.09293862994848247,-0.019338799180336617},
{-0.3003769254931122,0.21334431630971995,0.030296134376929774},
{-0.30788658901659627,0.18566785684523612,0.009075912879783423},
{-0.30433635258345676,0.19769464334173084,0.021253341367572877},
{-0.2982967839537433,0.17874366716025955,0.022955275354329202},
{-0.275620356540747,0.1595501680566328,0.05304093829661302},
{-0.28908839159225375,0.15859930726051655,0.03681754370220323},
{-0.2818404818834308,0.1315136635491252,0.016837714771675893},
{-0.2691705288709116,0.1955076635106634,0.0460483721049494},
{-0.2729088006974404,0.17568595525184974,0.05179199866665812},
{-0.24881356077068872,0.19466684615499674,0.0590089252708885},
{-0.2547569749378735,0.17367525860208494,0.05167768169454079},
{-0.3102616042410528,0.3858432853202049,0.04439344696654039},
{-0.32561533514103724,0.3780846885770635,0.013439188712748166},
{-0.3241441718643496,0.36314121671720123,0.034024790757205714},
{-0.30898381827233934,0.3480716756731347,0.03552800552140292},
{-0.3293899319867435,0.35078109475060726,0.027404021820652703},
{-0.33638570332715806,0.35875443646006266,0.0030085662942283898},
{-0.3381709711814392,0.3773442992155932,-0.022948865056827278},
{-0.3325683711647724,0.4038583580663979,-0.008808817150537282},
{-0.22877710754556121,0.2995670912420378,-0.03885708669072664},
{-0.2635732707688297,0.20183142199629472,-0.05353559958717684},
{-0.18833881413769746,0.17013463761519823,0.039986367433979285},
{-0.1930268783774255,0.1782158859992692,0.03832823714681932},
{-0.19508351549262068,0.18758774094705735,0.03824062974762659},
{-0.2139329952969784,0.19418714222527053,0.05109541300478423},
{-0.2283497543787674,0.22261253811456055,0.04083573185298197},
{-0.21309431470714554,0.22730380750303958,0.030502332279907785},
{-0.20475772280591542,0.2163464723064464,0.006848334497870721},
{-0.2928544413746242,0.2234095517706309,0.043782331938025255},
{-0.22984228531379475,0.17849473394060225,0.05495548048384926},
{-0.23868956424934346,0.20575345568454484,0.06237646822522367},
{-0.24130496563012155,0.21656869595317915,0.059242901129708106},
{-0.25613625728370054,0.22354416801817104,0.04402806000893169},
{-0.23524402934206842,0.23604531652980676,0.0393506795983735},
{-0.21318405887217226,0.23906136150445403,0.010185962730530332},
{-0.20525986277689814,0.2238080585986661,-0.00041453257178998256},
{-0.21819156960407865,0.38934223937332935,0.04343190234125433},
{-0.22144586396921345,0.37375666938035923,0.01793280726158502},
{-0.24928258087124489,0.218299476278694,-0.06162325826874958},
{-0.26947074447058417,0.21812960339489346,0.054941591505928464},
{-0.21792233710899855,0.5570698102765617,-0.049001382487494576},
{-0.2285548838988284,0.541099622433477,-0.051730032457473006},
{-0.2695636937843619,0.1448566977993447,0.05626318117423831},
{-0.2570572033581412,0.14808107744280416,0.06471836357925372},
{-0.24063188439242134,0.11252743073139346,0.0630848060991844},
{-0.26936497456180275,0.12478178278920589,0.04249279375722495},
{-0.26415126592691834,0.08231142507323762,0.0038280159915555093},
{-0.28004453019997994,0.33599360679662466,0.03948422746299656},
{-0.2278529563223696,0.27675284243275067,-0.04413917183229806},
{-0.23960516840919918,0.26096000615388554,-0.053239657519172125},
{-0.17186755470654724,0.45677109041297276,0.06167774579751581},
{-0.1604508148556508,0.4806206022688178,0.08548772748543261},
{-0.2046284484729603,0.23497907037865615,-0.0009091938623538108},
{-0.18583559296320273,0.4211127421756976,0.0373089998440161},
{-0.1910268655568305,0.4083124464473062,0.021908260095684383},
{-0.2145344948792407,0.5688113385342213,-0.04514131500842953},
{-0.24276010316305446,0.0746233416026171,0.04706760940775262},
{-0.22468413259059353,0.08251762297621551,0.0632226274954754},
{-0.2254458896104035,0.09007429534804706,0.06693632651491357},
{-0.21094472827817273,0.1048115693049315,0.07869922243091303},
{-0.2079671450885369,0.09780190898659608,0.0715688348429584},
{-0.251895845486189,0.05678134688897572,0.0017713788763603262},
{-0.2509246854146501,0.0628444199428628,0.015755442876770585},
{-0.2446062688436037,0.06905706660512775,0.03716690491605716},
{-0.23587117011433834,0.06494486075765438,0.027099532689312117},
{-0.23298867300431414,0.05817879174439144,0.017229811302209214},
{-0.3257958918540076,0.33557907422483485,0.01400650004166694},
{-0.258517682805659,0.5869781216546259,0.002337621822362117},
{-0.21077806054312312,0.2510731906401108,-0.00978211398791017},
{-0.17996162368562194,0.6707478894095474,0.1155135609843653},
{-0.17780455857623018,0.44404985502043803,0.052907390431989956},
{-0.2337130366220296,0.06979745596659796,0.04310711393449104},
{-0.1580352010803488,0.5036848526806796,0.09724314472101317},
{-0.029898695931811523,0.582628734799582,0.15031292935638477},
{-0.026992694397613655,0.6284751825332214,0.12772304095966427},
{-0.04836569465188879,0.6690780069103006,0.10937676950920626},
{-0.05218516358010842,0.5610644940031667,0.15916982373818636},
{-0.08519285380034486,0.5876469293606582,0.15727344406053886},
{-0.08193108075479115,0.6264153402692751,0.1428278386399913},
{-0.07953790302074586,0.6629433522009757,0.12325506360083506},
{-0.057217247119105454,0.6710288741167145,0.10994301245520806},
{-0.07188187103763485,0.6893591198234176,0.10080192821748858},
{-0.024931783750750534,0.7034275860742697,0.08684884732167086},
{-0.02352899698074987,0.6828825825806575,0.099531620929194},
{-0.026843120789235824,0.6605170545965037,0.11216524892253583},
{-0.18053000339745767,0.34569345529992707,0.03678015030010877},
{-0.19072451319132389,0.28571230157458277,0.017801396162795923},
{-0.20550772761363856,0.28857663617501816,-0.011278918454605472},
{0.2243561390350793,0.12032021572787863,0.03718399904272891},
{0.20668829073690642,0.1271407722699077,0.08754970651521271},
{0.22111573364786527,0.0742632965595933,0.06914040047265262},
{0.2327846118671701,0.07164469003006427,0.031312166530982045},
{0.2241969499804486,0.028432874569708777,0.06963399338029946},
{0.17828853603762418,0.16826496751047543,0.12331382466126921},
{0.19493501026715984,0.19822990318313993,0.09589911901144667},
{0.21220648850313142,0.16916881945824422,0.07158913411838111},
{0.2198646572520764,0.1659967905777172,0.039122045654138814},
{0.23841071630801053,0.12455421722788818,0.009706258800804285},
{0.24801654711461826,0.09279226148885554,0.004074812445378931},
{0.24509772498541657,0.07841503257499503,0.00884514216971477},
{0.23865430761308298,0.034701077143656854,0.04101735694886934},
{0.23302820317224257,0.005337641053254497,0.05753135169669892},
{0.2125676019290722,-0.0013888977920799481,0.08982856727714067},
{0.18341036374164793,0.1107955820229617,0.12583520834535267},
{0.16346899659613204,0.16431729263221767,0.17625860849535363},
{0.15599138456015743,0.2410175706254526,0.1575255824289472},
{0.16495832238240846,0.25311487039446817,0.13217392419182175},
{0.1871582510144296,0.25213516325959356,0.09745468453857611},
{0.2042972497686951,0.20039872050461846,0.06897159597176905},
{0.2134500862185014,0.21657937978234906,0.00697867721374283},
{0.22351745844524645,0.2080974878044089,-0.017547121028553596},
{0.23667138891915973,0.15788135394030295,0.0038974608811595023},
{0.24035837836567328,0.13974341715865687,0.0004519259738844556},
{0.2481981722105056,0.10033290811693223,0.0014433853208460814},
{0.250034722444802,0.011646442178048085,0.01636014760778382},
{0.2352600550858232,-0.04745650078953508,0.058263193994833304},
{0.20826949745404352,-0.03161558727940571,0.10281048810141946},
{0.19329397410667162,0.03342542794077732,0.12764077547505648},
{0.18578110543443657,0.02275228260010212,0.15939204738491916},
{0.17898939523116603,0.11001245734481196,0.16304057504642125},
{0.15919119139652607,0.14986314014833432,0.1942758180073804},
{0.15117084083872334,0.19282815915486629,0.19600552994997833},
{0.14491759562561296,0.20647034062184155,0.19969892969399378},
{0.14447207994923042,0.24656140958168535,0.18040393421325351},
{0.1468139753032605,0.28299860896544216,0.17735370098526274},
{0.15623711263106388,0.31913452436660916,0.1454752915082789},
{0.1809167580134061,0.3017252247343466,0.11230307031882684},
{0.19765083964213445,0.2990083269764548,0.06408908604114984},
{0.20299595937580797,0.2630721991807638,0.03707822913394745},
{0.21009963739083798,0.2537868832492514,0.005378239604100034},
{0.2292119393927739,0.230723701220307,-0.03864554687316371},
{0.22901322017021478,0.21430158740333807,-0.04387741801763686},
{0.22941813729575192,0.20147351371910494,-0.037549386000337595},
{0.20212522729846558,-0.06374934027354885,-0.025921106331878187},
{0.23276751774049834,-0.05637536138052168,-0.039254525135844875},
{0.23782417408658602,-0.05050993916627672,-0.06319698630546777},
{0.2508723346517179,-0.09343863315363136,-0.08262125611916316},
{0.22835616467626932,-0.06256664038444691,0.020860176454122577},
{0.21119045634907918,-0.06249612711192604,0.02484951826614274},
{0.21519689228777106,-0.06434122440955821,0.009226554871078242},
{0.22802389758908712,-0.061040989578993045,0.00025961704882724364},
{0.21192016188137958,-0.06374292997604687,0.000483977461393991},
{0.21081438556230062,-0.09066511110113964,0.01330029893354018},
{0.19022985190076006,0.3938647042609247,0.11741100904492978},
{0.1981935781639626,0.3656572584866996,0.09759464270070109},
{0.21124173872909444,0.3597832892091188,0.04441695139071405},
{0.21499069438479307,0.33698933967525435,-0.004875031250200314},
{-0.050888146718889214,0.3777310538315416,0.17608339369696815},
{-0.080977014809924,0.3916777244298575,0.1814124876868869},
{-0.07600582909719507,0.32664418789009325,0.17558873240640432},
{-0.06655064028188215,0.3041985311871656,0.1703280149231726},
{-0.07391179857990542,0.2964410028269411,0.17330987164447637},
{-0.07731566655341808,0.3190971309645147,0.16317946482562923},
{-0.07842037448958006,0.34009940234659614,0.16296471985931535},
{-0.08459990128141846,0.3660760645901575,0.17155451851187078},
{-0.08593217477889814,0.39849507582313565,0.17514642187877272},
{-0.08689265102126723,0.4775767793383291,0.1751902255783691},
{-0.08145137682506512,0.44118658880291955,0.1833441240007949},
{-0.044235326294826675,0.4254973856670022,0.17921375564373276},
{-0.03897888234326289,0.39155699716023823,0.16557477932550851},
{-0.04423959982649461,0.37759216405233365,0.16908762235655359},
{-0.05059647818255245,0.33108118214432997,0.16277134255134115},
{-0.05766810471007292,0.29823481774455807,0.15686745855208475},
{-0.06282518905035715,0.2932807261585009,0.15735570954514666},
{-0.06518631529689292,0.28189283264636306,0.16548930869214976},
{-0.07109019929614933,0.2610433400214104,0.16455233687395435},
{-0.07544706483161218,0.2672228668132488,0.1613610771009216},
{-0.07581993046963977,0.290038184005453,0.14586845642172921},
{-0.08895676681688129,0.3305117340495771,0.16064526054654196},
{-0.10554768513473375,0.3520364446780642,0.16622435613903508},
{-0.09864593149101383,0.4325626018970207,0.1725128579884059},
{-0.11041310093868123,0.4442923779425935,0.1638568195949974},
{-0.13631177122930277,0.4507368636978441,0.13920281540266286},
{-0.12901257914046457,0.5221529197836737,0.14883108225052727},
{-0.08638944266736753,0.4992702944676996,0.17283871477808618},
{-0.0825144178274647,0.48410887249277235,0.18116675961598044},
{-0.05513069528223471,0.4997318358878369,0.17753212093239915},
{-0.040943638527597394,0.46571986572563495,0.18173193417906525},
{-0.035395526039696826,0.43485962516853727,0.166574785735806},
{-0.03442222920232394,0.46360660431583955,0.17542099628843774},
{-0.032767304063914926,0.49445188751209945,0.17569022878351787},
{-0.034366673290640755,0.522284330882463,0.17462611939820127},
{-0.026568546379570804,0.5536509849422111,0.15469436769893824},
{-0.10162244629773269,0.6360788637534,0.1330329040570773},
{-0.1423577501565181,0.6454143936820108,0.12922839248969545},
{-0.13098481400521797,0.5675666724359344,0.13675835528860228},
{-0.11521227700177564,0.56614038124176,0.1518973412222728},
{-0.132016871903025,0.5497481821464668,0.14482250954600137},
{-0.1466547862486298,0.5545056912757986,0.12506383587928985},
{-0.15773284871484217,0.5962367280132137,0.12346126150381306},
{-0.14761739925683284,0.6794990138825676,0.11774220774919499},
{-0.08877941525266186,0.6424923664040582,0.13077861610223998},
{-0.08907001540608166,0.6117891781357572,0.14316865279050936},
{-0.08922706769487838,0.5769417325324735,0.15221678771445118},
{-0.0871704305796832,0.5373624189898651,0.16374463938871403},
{-0.1506131449560574,0.5332170932719654,0.12547836845107982},
{-0.214926591409774,0.028729885020630473,0.049632796791432426},
{-0.22311681485137724,0.06344805629095909,0.0586841368641252},
{-0.2206573973764789,0.03628121547787695,0.022337750028312155},
{0.23315640912228072,0.6341130391861486,0.041678685974482745},
{0.19296491216824038,0.6235082703521603,0.06398972642987029},
{0.22939997478616314,0.5678818453964448,0.06791710203270536},
{0.24105496402754717,0.6077806054312314,0.0432684397549557},
{0.24379109267794452,0.5809460317053313,0.04300134402570958},
{0.2309833182691342,0.5176219078327425,0.0645752002683778},
{0.21334217954388596,0.5621499710468228,0.08332852561020691},
{0.1912811406910728,0.5767804067120088,0.0910059252516576},
{0.19095421551847555,0.6137592762346765,0.07775370354938174},
{0.18869565403197028,0.637945328709372,0.05708797278615035},
{0.23525471317123828,-0.11190563187370862,0.029378393451240083},
{0.22475891939478246,-0.0668316249890492,0.04306117346906071},
{0.2392686277903491,-0.10867056840107961,0.01000540601755995},
{0.24158488195437153,-0.10754449280657793,-0.00906629743353055},
{0.23438077594514495,-0.0586638375887026,-0.017928533729917064},
{-0.22982091765545504,0.003991478577854091,0.0036025871960717773},
{-0.20728872193625172,0.007424192890125346,0.009025698882685153},
{-0.19219567646801156,0.0077350923189677635,0.012649653737096613},
{-0.18502362194629454,0.0009572710936180113,0.013887909537881661},
{-0.18694136928228172,-0.03045532343156049,-0.006274612871450023},
{-0.1723472586362733,-0.04205368837834431,-0.011587681117613994},
{0.14226480084274046,0.18051290927078578,0.17262717496052324},
{0.13541753472778673,0.21748323173011785,0.14113017818490292},
{0.14338126099098925,0.1745524009769292,0.13255533689318522},
{0.14694004448746467,0.13674767145943229,0.1357765113878935},
{0.1434389536685064,0.16089846729786714,0.12252963160020258},
{0.13594638427169406,0.1742222706555811,0.12833308760526244},
{0.14174342997925202,0.18654286245424634,0.12794633298931404},
{0.13275191934991037,0.19292645038322886,0.1309922926856369},
{0.13055211892383925,0.2252749483436859,0.13700515174242572},
{0.13799020079188543,0.24421844584473817,0.12635016891133918},
{0.13746241963089506,0.2579578501571591,0.13659596108522062},
{0.13551048404156438,0.25283709083605227,0.17333764960031794},
{0.1371643407970564,0.21942020995861086,0.20034423297585244},
{0.14825629224118958,0.18225651019130457,0.19557604001735054},
{0.15389949080870177,0.15554586888377478,0.1947672741491933},
{0.15940807312867392,0.12651256311472076,0.19350444554131757},
{0.15627984794774324,0.0780111838323749,0.15640591713194743},
{0.1518353750130877,0.10375707536586772,0.13174550264211096},
{0.1554230048483217,0.10220898851915712,0.11408726979019097},
{0.15021143297927123,0.11661720053761011,0.11753173631454904},
{0.14205646617392848,0.1472028666850428,0.11581163981820397},
{0.1456205915849888,0.12748585995209374,0.11319944358617684},
{0.12988437960072394,0.1310425066827351,0.11749754806120553},
{0.22606875685100547,0.2730049551599689,-0.04181437060493977},
{0.2236937416265489,0.28200073932097863,-0.035948948390694804},
{0.21936465404692765,0.44630521135819234,0.03832823714681932},
{0.22680273591497382,0.48730120064872207,0.05604095752750553},
{0.2115045609266726,-0.11388748218471495,0.06894488639884444},
{0.2038848539627391,-0.0734117953747567,0.07033805772259225},
{0.20923104207932958,-0.07290538187210607,0.07552505678455204},
{0.21749818909095572,-0.07049083647972104,0.07211050498186955},
{0.21950461220905262,-0.0680859065335889,0.05497684814218895},
{0.20710602845744738,-0.06868313258418333,0.05737750455665315},
{0.20993510642162236,-0.06856026854873003,0.03932824355711683},
{0.21319367431842512,0.3989854635820315,0.016846261835011773},
{0.21338812000931628,0.4124374728897835,0.08424519815297962},
{0.21190306775470785,0.4340775688733047,0.09629548907364792},
{0.21981230648914418,0.45786297775413076,0.07023121943089379},
{0.21564988664457252,0.41568428857449946,0.03533035468176079},
{0.21756549721472576,0.3807823554424493,-0.0026645469949593617},
{-0.2039019480894108,0.0452951621484753,0.08394711931914094},
{-0.19918076397925627,0.07068741893644614,0.08946424870244896},
{-0.185405034647658,0.05778028491635626,0.10586606324399517},
{-0.19195208516293907,0.027629450616136333,0.08849095186507606},
{-0.21010604768833988,0.03733891456569155,0.06922052919142646},
{-0.2022491597168358,0.018909309247708755,0.06576644722081552},
{-0.20522994805522257,0.009475488090735522,0.0452342643222072},
{-0.2016273608591508,0.016010786393929815,0.02287407825263838},
{0.18356527926461066,0.4921110605409863,0.13988230693786502},
{0.13996777757122372,0.5543732117940925,0.1304046820812954},
{0.141603471817127,0.5088761252743073,0.14830757462120484},
{0.17761224965117298,0.44710970369468167,0.1590106346835557},
{0.14614516759722818,0.420200343164593,0.17442740017564218},
{0.13950303100233552,0.43590877719301613,0.16588781552018497},
{0.14474985950764643,0.39302816043692584,0.17895520697782252},
{0.13960025384778108,0.4002867539749186,0.16761111716528096},
{0.14176159248884074,0.42403156430489924,0.15003087626630085},
{-0.15717942636384422,0.12320805475248765,0.09273350042842156},
{-0.155608903475877,0.12665252127684584,0.07866823932632047},
{-0.14860992698671147,0.12455955914247313,0.08372382728949118},
{-0.14261523043951135,0.12119201618813791,0.08359455295653606},
{-0.14703726733291025,0.11362679675297047,0.10184146479571451},
{-0.17092951450543487,0.11026032218155238,0.09731579475936812},
{-0.18631102336126085,0.08872813287264654,0.09756793312777647},
{-0.15010993660215768,0.4550445836191257,0.1190178569520745},
{-0.1608300907911803,0.4009641087442868,0.09024309984893066},
{-0.17721267444022076,0.40159552304822466,0.04314878086825344},
{-0.17393380726799532,0.4372869911559262,0.05011997940157737},
{-0.18117103314764837,0.41984777680198787,0.03936991049087922},
{-0.1657948662064073,0.1875610313741328,0.07757421521932834},
{-0.16403951307380174,0.1865599565809181,0.10059679869742755},
{-0.15167084404387207,0.21147357782208,0.09722925574309238},
{-0.15696147624877937,0.23525043963957018,0.08096526259783716},
{-0.1406611580843467,0.2320816159077941,0.11129451684519347},
{-0.1417145836404934,0.22064030324980713,0.11023361260862784},
{-0.15884503533142308,0.20569042109244273,0.11038211783408869},
{-0.1502210484255241,0.21393406367989526,0.12699974572486578},
{-0.14139727391414902,0.18847877229982243,0.11743344508618646},
{-0.14725201229922413,0.14725308068214096,0.09495253174699839},
{-0.16610897078400075,0.16386109312666533,0.08644179343029977},
{-0.1708098556187326,0.16551922341382527,0.07115109712241746},
{-0.1847565262170484,0.18497127118336212,0.05564672423113824},
{-0.1707895563433099,0.1945322299074566,0.07477077844516097},
{-0.16227454449494333,0.23172904954518928,0.0764524131564946},
{-0.17409406470554298,0.23953251837084413,0.04986143073566712},
{-0.16503310918659736,0.31856080274018844,0.06634230561307018},
{-0.13604894903172454,0.28530845283196266,0.10572076316728526},
{-0.13602864975630186,0.2492879227858297,0.11122079842392153},
{-0.13730536734209833,0.27512676363310024,0.1366696795064926},
{-0.1505650677247931,0.223683057797379,0.12534375220353977},
{-0.13282136423951435,0.2792859783289208,0.14718149902670316},
{-0.12935232490806564,0.24848770398100842,0.14306288288172786},
{-0.1235894674538512,0.231687382611427,0.13384380669106857},
{-0.11529026895471553,0.20344254343510745,0.1118575546424443},
{-0.12194843129336298,0.18525759780511414,0.10303271174815225},
{-0.1297209170144253,0.17647442184458445,0.10352950980455003},
{-0.1336386771710075,0.15539629527539692,0.09315551168063044},
{-0.15215268473943208,0.1360201026929659,0.08550802676085531},
{-0.16516772543413738,0.13038331442295556,0.056928783731519654},
{-0.18547020600559405,0.2048966125851233,0.03703763058310204},
{0.13617608659884575,0.2925488838603665,0.17916674679538547},
{0.13243995153815089,0.26529870917975973,0.1926059355081336},
{0.13513441325478584,0.2653051194772616,0.1998014944540243},
{0.1407167139960299,0.24127611929136292,0.20180578080628722},
{0.16254911890460838,0.1104066906411793,0.19213371025882645},
{0.16467733767524154,0.07668638901531409,0.18493921969585275},
{0.1708931894862574,0.02670636777586174,0.17379919102045527},
{0.16056406344485114,0.038690418955677035,0.13752759098883113},
{0.15556189462752965,0.0748188556764252,0.12665679480851375},
{0.1571174601546591,0.08565653198631612,0.11873794062782454},
{0.1466077774002825,0.10088419370209642,0.11328598260245258},
{0.19065506830171988,0.5782440913082775,0.0997249982371682},
{0.16700213890259982,0.5935614971890845,0.1051320841800268},
{0.18620845860123036,0.5194798257253785,0.13113331923067884},
{0.1379164823706135,0.5890262117064852,0.11436718611444091},
{0.14815906939574403,0.618841573770772,0.09720895646766968},
{0.16906945984696484,0.617670626093757,0.0828189069588053},
{0.16014312057555924,0.6541366718162723,0.06435725015331295},
{0.16360361284367206,0.6519913589189674,0.05606659871751315},
{-0.0799556407412868,0.2515251166139953,0.13625194178595162},
{-0.09846964830971139,0.20205578240886152,0.12229672412429994},
{-0.09364162590785838,0.20218078321014862,0.14036842116509293},
{-0.08047594322185825,0.2469054288809543,0.15521680694534365},
{-0.08276441943003908,0.23020660388848635,0.15245183195618778},
{-0.07917144768022016,0.21335713690472366,0.13468569242965234},
{-0.08453686668931638,0.20094893770686553,0.12646341750053955},
{-0.08868967108763516,0.1877661608941938,0.12733308119496495},
{-0.10285215503518184,0.18203428654457182,0.13296132240163933},
{-0.11118233663891007,0.18358985207170117,0.10941416291130071},
{-0.09372816492413413,0.245551787725135,0.1267636331002122},
{-0.0803210276988955,0.269278435545527,0.13879041959670682},
{-0.07613724019598415,0.22625251871272672,0.13575407534663686},
{-0.13363333525642257,0.2798821359965982,0.12431703622031766},
{-0.13506603674809883,0.29650296903612633,0.14354151842853693},
{-0.13304572465208112,0.33141131246567807,0.11508834458340546},
{-0.1271065840165642,0.3839928461079879,0.12944741098767729},
{-0.13039399825212553,0.3316655875999204,0.1497733959833076},
{-0.11052314437913062,0.09629121554197996,0.1082282578734479},
{-0.11680203078224861,0.10090021944585106,0.1045882772752817},
{-0.12683521475565013,0.09754656546943667,0.11703280149231726},
{-0.11325713626369399,0.088417233443804,0.12028923262328606},
{-0.13629040357096306,0.09151127037139116,0.1168789543522715},
{-0.1341429539078242,0.11214815479586408,0.09452838372895553},
{-0.136707072908587,0.12104137419684315,0.0877516308865228},
{-0.1307892999314098,0.12065782472964572,0.10221753558249307},
{-0.1224388190522589,0.11562787795648247,0.09762669418821061},
{-0.11925931149131298,0.12477857764045497,0.09835746810342802},
{-0.11521761891636056,0.1435639544697935,0.1143062882881728},
{-0.1124216608226121,0.13890687333465804,0.10272074393639277},
{-0.10629341641078896,0.151598194005517,0.10399318799052132},
{-0.1026128372617773,0.15970615196251253,0.11311824648448603},
{-0.10750282587281541,0.16755769801943174,0.12698585674694496},
{-0.09582005867558979,0.17212289822370652,0.11818344989390958},
{0.21071823109977203,0.5016869766259185,0.09948247531501271},
{0.20845219093284786,0.474620563807033,0.10363848486208246},
{0.22521725566616882,0.48056290959130066,0.06961689925362771},
{0.21118511443449425,0.46919958888625357,0.10550174466930344},
{0.18434840394276034,0.4596503823742459,0.12901044237463064},
{0.1836678440246412,0.46488011675288515,0.12503605792344824},
{0.17777891738622256,0.48454049919123415,0.12975190011901788},
{0.1885225759994188,0.5430814727444835,0.10648038342126125},
{0.19084524046094314,-0.039111361824969056,0.15343367585689655},
{0.20504511781058427,-0.08590119167430561,0.13233204486353548},
{0.18607277397077332,-0.04333788464455973,0.15622642880189402},
{0.18016888997151692,-0.010002200868809086,0.16653632395079457},
{0.18058983284080882,0.024733064528191306,0.16960578807129106},
{0.16612499652775553,-0.0074861590993105685,0.1312049008861168},
{0.17658446528503388,-0.03822887753553986,0.12943565877559046},
{0.19448308429327538,-0.08726337989346089,0.12277963320277695},
{0.1775566937394898,-0.05624822381340054,0.11892811278704779},
{0.16634187825990338,-0.038166911326354754,0.12229565574138296},
{0.14440477182546044,0.35569886131748707,0.1860610217586865},
{0.13240576328480738,0.38641807532954275,0.15457043528056805},
{0.1352465934610692,0.3530471349175314,0.15735570954514666},
{0.1408823133481625,0.3097925841404965,0.18951189858054648},
{0.1344111180199873,0.3064976912245164,0.15882580443891736},
{0.13718250330664514,0.3223428782663135,0.13724233274999628},
{0.135192105932303,0.3462703820750987,0.13715472535080356},
{0.24170026730940586,-0.11226460853381542,0.019255465312811842},
{0.25320461455949506,-0.09565445932345726,-0.036470319254183245},
{0.24667893170255367,-0.10062350827035219,-0.02748949245401145},
{0.24627935649160143,-0.09893760002735065,-0.053597565796361935},
{0.2510187031113447,-0.10016837714771686,-0.055623219806964566},
{0.24563084806099184,-0.028451037079297564,-0.018490503144250915},
{0.2419844571653237,0.009390017457376795,-0.023334551289858688},
{0.24483062925617044,0.07688724500370726,-0.0167810904770757},
{0.24769923738827385,0.0830902762197193,-0.022929634164321557},
{0.25009775703690407,0.08623773229315557,-0.01629283948401378},
{0.1793152520208463,-0.0923040104957938,0.10735432064735458},
{0.2126445254990951,-0.11720801629070281,0.106015636852373},
{0.19745318880249232,-0.10429660873894499,0.11466099141661165},
{0.2049810148355652,-0.10421968516892213,0.11910225920251627},
{0.2167407056028137,-0.1142507323764897,0.10555516381515267},
{0.22151958239048541,-0.12315356722372153,0.0843221217230025},
{0.20457823447586204,-0.12356382626384364,0.0707344277847935},
{0.18999587604194043,-0.11252422558264265,0.09162986087517656},
{0.16199676493652734,0.3495310867377355,0.1899082686427477},
{0.15636852372985297,0.32001807703895524,0.19625766831838665},
{0.14783321260606375,0.30945711190456343,0.19833139956025359},
{0.14983108866082476,0.3013566326279869,0.1968965613027434},
{0.13582993053374273,0.2838554520648637,0.13874768428002746},
{0.17124148231719435,0.04932296574550684,0.18052572986578974},
{0.1598770932292301,0.020474490221091116,0.13057455496509593},
{0.1565522855915743,0.03550663786306321,0.12864291865118793},
{0.1583589211041951,0.04778022081338121,0.12521234110475069},
{0.15057895670271393,0.07659237131861948,0.1228170266048714},
{0.18061547403081646,0.49918696060017476,0.12682025739481237},
{0.18241035733135041,0.4758598879907348,0.14304258360630517},
{0.17305880165898502,0.463231601911978,0.1401793173887867},
{0.17922550785581962,0.4582711000284189,0.1500757483488142},
{-0.11620159958290331,0.15401808131248687,0.11796977331051269},
{-0.12280420600986758,0.17553317649472094,0.10614277441949416},
{-0.12390464041436162,0.15281508214796236,0.10084573191708494},
{-0.14039299397218358,0.13123908913946022,0.08323557629642926},
{-0.11549646685769353,0.16980664405968418,0.12104992126017904},
{0.18912514396459806,0.5428453601198299,0.11504347250089211},
{-0.06755064669217964,0.25077938533794025,0.14872958587341373},
{-0.06719914871249175,0.2709707540860305,0.14946035978863115},
{0.14131500842954123,0.26674957318102466,0.19647668681636848},
{0.1345446658846104,0.66732799569228,0.07316072538926532},
{-0.10810218868924373,0.0793317051177679,0.127465560676671},
{-0.09730297416436429,0.08668965826704007,0.11866208544071866},
{0.25033493804447465,-0.01069451299901503,0.011397508958390767},
{0.24364686098415161,-0.050879599655553435,0.030036517328102537},
{0.24205817558659565,-0.11175605826533076,0.034998087594578606},
{0.22795017916781518,-0.0832815167618597,0.07179960555302707},
{-0.0839770340408165,0.5200492738201311,0.17602142748778304},
{-0.08522383690493741,0.5574052825124947,0.1663055532407259},
{-0.08965762601042314,0.6592948245394734,0.11946337262845703},
{-0.07248550738573109,0.6660630303185703,0.11039921196076044},
{-0.06279206917993063,0.670371818622769,0.10433293375812239},
{-0.07926867052566576,0.6884007803468826,0.09659356790748659},
{-0.06994489280914194,0.7001519240507952,0.08800270087201414},
{-0.10775496424122377,0.6966925001655992,0.10112564824133488},
{-0.14155966811753068,0.6995237148956083,0.10063526048243901},
{0.1354891163832247,0.6219217217204384,0.09793332008538518},
{-0.16435682280014616,0.09694613427009144,0.09761280521028981},
{-0.12697730968360907,0.07728468344882543,0.11866208544071866},
{-0.11331910247287909,0.06806453887524919,0.11770801949585148},
{-0.12559268542319715,0.06968313899448064,0.1106716496045915},
{-0.18879928717491778,0.241897918149048,0.017612292386489665},
{-0.20748850954172782,0.26836496815150523,-0.008884672337643184},
{-0.2033581411846657,0.24352399694869822,-0.005584437507078028},
{-0.1020903980153719,0.07571843409252617,0.12171338705162642},
{-0.08885099690809985,0.2655615313773379,0.13681391120028547},
{-0.11291525373025896,0.22471832084393698,0.12002534204279089},
{0.22901963046771667,-0.11634796804253021,0.06189035399799572},
{0.21384218274903471,-0.1255510184894348,0.07040429746344529},
{0.22534011970162202,-0.11474005175246856,0.06188287531757683},
{0.2039457517890072,-0.1216300531841017,0.06357946738974823},
{0.23116173821627062,-0.11749006938078664,0.04466374784453747},
{-0.19640190001217955,-0.006704102804077836,0.0577193870900882},
{-0.19663694425391615,0.01150221048425518,0.06176214804795758},
{-0.19360914706718205,0.00848509712669087,0.02807282952668501},
{-0.2020151838580162,0.010271433363888978,0.018753325341829122},
{-0.20656970023312116,0.02911557125366182,0.013719105036998108},
{-0.21650031944649217,0.011486184740500425,0.013070596606388511},
{0.15168793817054385,0.3778069090186474,0.15442513520385814},
{0.17149148391976873,0.4101703643399422,0.1353448846894318},
{0.15823712545165888,0.4091874520563166,0.154987104618192},
{0.14844539601749585,0.3852065291016821,0.16999895298474135},
{0.15901704498105756,0.40289788182402864,0.1642232749355231},
{0.16037816481729583,0.43541411590245244,0.1514913557138187},
{0.1482627025386915,0.3540620986886667,0.1669049160571542},
{0.1501377145579993,0.36923313610984676,0.1730459810639812},
{0.16886433032690382,0.385913798592726,0.17417846695598477},
{0.17335047019532177,0.41582852026829237,0.16333758549734295},
{0.16463567074147914,0.4383521689241596,0.1553813379145593},
{0.16820513806712437,0.44748470609854324,0.1477862037577164},
{-0.1905834866462819,0.003119678117594688,0.022491597168357927},
{-0.18333878208620996,-0.016032154052269647,0.033044015239413936},
{-0.1918676829124973,-0.021589881986422994,0.059663843999},
{-0.1927010215877452,-0.01242743009036392,0.06815107789152496},
{-0.19065186315296892,-0.0017051391355073235,0.06989361042912669},
{-0.19358136911134044,0.011845161400607224,0.0829845063109379},
{-0.19378970378015242,-0.008632533969234938,0.07518744778278494},
{-0.18729820917655454,0.06827714707572904,0.09858503366474572},
{-0.1751133020083462,0.07479641963516859,0.09882648820398422},
{-0.15781618258236696,0.08627619407816715,0.08914800735902154},
{-0.14527550390280278,0.08345245802857715,0.09699207473552181},
{0.1504710500280985,0.34277890670239325,0.18185052468285054},
{0.14814090688615525,0.3582287920649063,0.17802571384004598},
{0.16341237230153186,0.34642102406639347,0.18629713438334006},
{0.16799359824956145,0.3744970587418296,0.1807981675096208},
{0.14523597373487437,0.3044987467868382,0.18354818513793894},
{-0.03898208749201383,0.4067643596005956,0.16931625630078825},
{0.16874894497186949,-0.060690559982222135,0.11603920537952168},
{0.17193699959615127,-0.09761601035904077,0.10696222411682127},
{-0.015612279565894647,0.6994136714551589,0.08483815067190602},
{-0.017819558672384644,0.6903591262337151,0.08740761158725378},
{0.17610262458947387,0.4198883753528333,0.16753098844650713},
{-0.19088263386303758,0.020753338162424025,0.08258279433415172},
{-0.11038532298283962,0.4216266343587671,0.16132795723049506},
{0.16157902721598644,0.0058290971950673886,0.12467494449750748},
{0.1566559187345218,-0.024017247973811856,0.12674440220770647},
{-0.1939499612177001,0.22354523640108792,0.015457364042931906},
{-0.19414120175984034,0.23695557877507764,0.01427359577091307},
{0.19798738026098459,-0.08478579990897385,0.13792716619978335},
{0.15474244493020256,0.02211232123282838,0.12962155740314574},
{-0.1750791137550027,-0.020380472524396624,0.0014102654504195616},
{-0.17342953053117863,0.1354549281298811,0.04941164152761664},
{0.1292187770434426,0.2795178174219066,0.12888437319042645},
{0.1283341559881794,0.25464158958283917,0.12737795327747828},
{-0.01649796900407481,0.6734177783190918,0.08795889717241778},
{-0.02241574198125201,0.6601270948318044,0.10857334555563392},
{0.20265087169362198,-0.1266076491943325,0.056054846505426324},
{0.19250443913102008,-0.0569512197727764,-0.03148097103186558},
{0.17819238157509557,-0.10994942275270995,-0.0615046677649643},
{0.1829295914290049,-0.05593625600164111,-0.046676581260136275},
{0.1753472778671658,-0.05358260843552416,-0.052212941535950005},
{-0.025813199657262757,0.6028553601839327,0.13545920166154912},
{-0.021748002658136697,0.6118757171520329,0.11876251343491519},
{-0.021270435494244618,0.6314880223591175,0.1144035111336184},
{-0.024298232680978717,0.5775218644563961,0.13966222005696619},
{0.006211578279347948,-0.9054641375906256,-0.2367985264862809},
{0.004695542920146927,-0.9060485430462162,-0.2375773776327626},
{0.004955159968974164,-0.9062526041833603,-0.24089791173875044},
{0.004695542920146927,-0.9060485430462162,-0.2375773776327626},
{0.005244691739476967,-0.9060805945337258,-0.24222698008747917},
{0.004634645093878809,-0.9063060233292095,-0.24231672425250586},
{0.0048002444460114105,-0.906328459370466,-0.2433156622798864},
{-0.017551394560221537,-0.9191629433522011,-0.021618728325181562},
{-0.013667822656982843,-0.8769671600458977,-0.044031265157682624},
{-0.025821746720598632,-0.8826627093763423,-0.031345286401408545},
{-0.026854873001322655,-0.9093722823009549,-0.019988375993863203},
{-0.037406222689461685,-0.9090496306600258,-0.022369801515821675},
{-0.013355854845223366,-0.926132005119691,-0.013104784859731999},
{-0.006575896854039656,-0.9299066019653972,-0.02281211204345326},
{-0.008315224242890443,-0.9406427818981746,-0.004947681288555261},
{-0.010532118795633304,-0.9469163263867078,0.003197670070534648},
{-0.0361914713128503,-0.9378778069090188,0.0023750152244565747},
{-0.03106430169424162,-0.939584014427443,0.010683829169845114},
{-0.024942467579920382,-0.953864020495858,0.024457421735609424},
{-0.04383040916928954,-0.9553469359846325,0.05108686594144835},
{-0.045818669777797714,-0.9810201774797702,0.06527712784483662},
{-0.02950125748669329,-0.9765158751017635,0.041577189597369224},
{-0.04074598768795525,-0.9885992858928583,0.061831592937561575},
{-0.06875791938837214,-0.9876559037771611,0.0723070874385947},
{-0.06928463216644551,-0.9818866360254447,0.07296521131545716},
{-0.055862537580369104,-0.9792317044767381,0.0691414688555696},
{0.02099158755291167,-0.882053731113661,-0.2153603548740697},
{0.023666818377040884,-0.8726583717416992,-0.21220542012021443},
{0.032352771492124954,-0.8857941397060238,-0.19509206255595654},
{0.0367502355784332,-0.8874234236544253,-0.20195642279758205},
{0.03660279873588934,-0.896265360675389,-0.18018598409818867},
{0.027998042722496088,-0.8935174798129049,-0.17900542097492078},
{0.03311666527776888,-0.884056949083007,-0.1756592456789253},
{0.03164016008649628,-0.8681572745124435,-0.18693282221894583},
{0.01715716126385426,-0.8411741955610827,-0.18775440868210694},
{0.004849390060192695,-0.8398558110415238,-0.20117436650234938},
{0.00929599976068223,-0.8715622108688732,-0.22181979799015805},
{0.013987269149161216,-0.8829725404222677,-0.21502701940397054},
{0.0032115590484554407,-0.8800355557834774,-0.2234992959356577},
{0.019368713902012197,-0.9048754586033673,-0.232720508892151},
{0.031015156080060346,-0.9021115519971283,-0.223823015959504},
{0.044909475915443905,-0.9127291414261204,-0.19875341081246248},
{0.03933892738628667,-0.9198189304632296,-0.18302040397694855},
{0.029022621939884235,-0.9128594841419925,-0.14809282965489093},
{0.02554610392801664,-0.898960890774941,-0.16194334579067815},
{0.02793180298164305,-0.8943732545294095,-0.14920822142022278},
{0.021429624548875318,-0.8582907582740915,-0.13791755075353046},
{0.0208238514349451,-0.8455150353527907,-0.16531516227668125},
{0.009712669098306191,-0.8677277845798157,-0.07140003034207483},
{0.023113396026042905,-0.864404045325077,-0.08651337508573773},
{0.030638016910364815,-0.8888764244215241,-0.07175045993884575},
{0.002436981433641674,-0.9770735709844295,-0.06171620758252723},
{-0.09041617788148214,-0.9997553403120106,-0.08113727224747166},
{-0.008884672337643187,-0.9512934911975933,-0.13575728049538777},
{0.020678551358235205,-0.9446940899193799,-0.12304886569785703},
{-9.2949313777649e-05,-0.9352944570157502,-0.14432464310668658},
{-0.018706316493481794,-0.9379825084348833,-0.15185781105434434},
{-0.05341487231755759,-0.9490830069423523,-0.15434714325091825},
{-0.08943326559785639,-0.9826836496815152,-0.10958724094385221},
{-0.09459355508689159,-0.9957724087974923,-0.08746850941352188},
{-0.1031587809323564,-1.0000000000000002,-0.07943961179238328},
{-0.05434970736991904,-0.9904764346780001,-0.034034406203458566},
{-0.006027816417626603,-0.9800265813669746,-0.03896606174825906},
{0.006631452765722861,-0.9754613811626998,-0.028492704013059904},
{0.01182058859351663,-0.9621867234191673,-0.06804851313149443},
{0.01474582102022022,-0.9512454139663289,-0.08913411838110072},
{0.018573837011775722,-0.9381887063378611,-0.10376241728045266},
{0.016454165304478453,-0.9331747853084529,-0.12159693331367509},
{0.017083442842582328,-0.936887415944974,-0.13354038594264492},
{0.011681698814308642,-0.9341459453799918,-0.14153509531044},
{0.021208469285059525,-0.9403233354059962,-0.14488661252102042},
{-0.008866509828054446,-0.9441032741662875,-0.15823712545165888},
{-0.02516041769498522,-0.9449761430094638,-0.16579272944057333},
{-0.02352899698074987,-0.9359333500001069,-0.1555458688837749},
{-0.03470962420699277,-0.93621219794144,-0.15702451084088145},
{-0.04385284521054622,-0.9388158471101311,-0.16164740372267342},
{-0.05810614170603657,-0.9376929766643805,-0.1634369451086225},
{-0.06935835058771743,-0.958484776611816,-0.14163231815588562},
{-0.08833069442752839,-0.9618747556074078,-0.1124216608226121},
{-0.10251668279924869,-0.9775586168287405,-0.08232424566824147},
{-0.11424539046190467,-0.9981260563636093,-0.050097543360320684},
{-0.10937570112628926,-0.9956036042966088,-0.012004350455237954},
{-0.0011453064870073917,-0.9857851652895212,-0.0027542911599860603},
{0.006161364282249674,-0.9799165379265252,-0.018814223168097225},
{0.0027927529449975163,-0.9721803772246405,-0.016335574800693156},
{0.004200881629583101,-0.9675745784695201,-0.03453227264277334},
{-0.00011645373795130951,-0.9581546462904678,-0.04783470834214749},
{0.0030748060350814276,-0.9514366545084691,-0.06996946561623257},
{0.010853702053645648,-0.9309717797336309,-0.1063041002399588},
{0.015275738947044539,-0.9144471011566314,-0.1232155334329066},
{0.01776079761195051,-0.9236982288348002,-0.1276600063675622},
{0.013494744624431357,-0.9295251892640338,-0.1329495701895525},
{0.024223445876789814,-0.9275540227821975,-0.13347094105304091},
{0.024928578601999592,-0.9401150007371842,-0.13668143171857938},
{0.03431218576187455,-0.9312922946087262,-0.1665267085045417},
{0.032478840676329127,-0.9182345185973415,-0.1987715733220512},
{-0.03234849796045701,-0.9178167808768005,-0.22239779314824668},
{-0.04824924091393747,-0.9301587403338056,-0.20190727718340074},
{-0.047213977867379485,-0.9460242266510256,-0.17050322972155801},
{-0.07812122727282439,-0.9149332153838593,-0.04486033030126261},
{-0.08068534627358721,-0.934758128791424,-0.03870751308234881},
{-0.07163614296672842,-0.9461118340502184,-0.019400765389521717},
{-0.05358154005260718,-0.938342553477907,-0.00575751553962952},
{-0.06068308130180322,-0.9359183926392691,0.0017991568322019234},
{-0.08484990288399284,-0.9451673835516041,-0.004867552569781423},
{-0.09004010709470359,-0.9439964358745889,-0.03204187206328245},
{-0.09622390741820995,-0.9419633031835675,-0.05065630762590358},
{-0.09486812949655658,-0.9321181546035552,-0.06396622200569661},
{-0.09148242403263268,-0.9217783447329791,-0.058053790943104325},
{-0.0747408637234854,-0.9046040893424531,-0.038907300687824914},
{-0.0577386179825939,-0.8950815924033702,-0.03518825975380183},
{-0.046168030991651655,-0.9167815178302425,-0.019261875610313735},
{-0.055850785368282266,-0.9421481334282058,0.028094197185024698},
{-0.08628367275858606,-0.9518597341435949,0.056054846505426324},
{-0.10487994581161846,-0.9583191772596833,0.00044765244221651746},
{-0.0996277753917226,-0.9465049989636686,-0.025715976811817164},
{-0.10597931183319552,-0.9496300189958483,-0.06746838120757184},
{-0.09856259762348904,-0.9326309784037078,-0.06990002072662858},
{-0.07802079927862784,-0.8761081801806423,-0.06766816881304794},
{-0.0751073190640111,-0.8847759707861376,-0.055487535176507535},
{-0.06862223475791511,-0.8903604082932156,-0.03782609717583659},
{-0.052942647068250435,-0.8865548283429168,-0.029126255082831717},
{-0.049134930352117634,-0.8939117131092722,-0.023839896409592363},
{-0.10356797158956146,-0.9743951350115493,0.04304301095947197},
{-0.10503913486624913,-0.9607412013324872,0.024618747556074086},
{-0.10949322324715756,-0.9747915050737506,0.005444479344953073},
{-0.10233505770336136,-0.9798727342269289,0.0397021775780614},
{-0.10653700771586143,-0.9812765893798465,0.0199274781675951},
{-0.10554982190056773,-0.9807434663042712,0.0043686177475496715},
{-0.10576456686688163,-0.9824411267593596,-0.010678487255260176},
{-0.11303063908529329,-0.9768833988252063,-0.024166821582189624},
{-0.11129238007935946,-0.9618501828003171,-0.026646538332510673},
{-0.08930399126490127,-0.9672690209552627,0.0657749942841514},
{-0.09072494054449066,-0.9796643995581169,0.06204420113804149},
{-0.10232437387419151,-0.9918525118750762,0.04714239621194154},
{-0.10579127643980624,-0.9933941884242848,0.01735801725224735},
{-0.10828701893388205,-0.9837060921330694,-0.020742654333254264},
{-0.10556050572973759,-0.9834058765333966,-0.03625130075620142},
{-0.1092709996004248,-0.980618465502984,-0.05542450058440545},
{-0.10775389585830679,-0.963375833605771,-0.07433594659794826},
{-0.07430175834460477,-0.912687474492358,-0.1412124436695107},
{-0.09187131541441505,-0.9227623253995219,-0.1081727019617647},
{-0.07988512746876582,-0.8850409297495497,-0.1259281576591303},
{-0.06841924200368805,-0.8691743750494129,-0.15317299042515228},
{-0.0748519755468518,-0.876888099710041,-0.1245061399966239},
{-0.08078577426778377,-0.8811092806150467,-0.105807302183561},
{-0.08280608636380146,-0.8805633369444678,-0.08939266704701099},
{-0.09391299516877244,-0.9469419675767152,-0.10342373989576854},
{-0.07141178255416167,-0.938407724835843,-0.13571775032745936},
{-0.06299933546582563,-0.9235123302072451,-0.1576826347177439},
{-0.05854311031908324,-0.8918924693961714,-0.18452575550697972},
{-0.05292234779282773,-0.8582725957645029,-0.18483986008457318},
{-0.06923228140351327,-0.863916862714932,-0.16341237230153186},
{-0.01108233599788032,-0.9892905296401473,0.021921080690688197},
{-0.018896488652705032,-0.9878962899334826,0.03880153077904347},
{0.0005267127780733715,-0.951649262708949,-0.038750248399028187},
{-0.004204086778334043,-0.9578554990737121,-0.011699861323897366},
{-0.002770316903740834,-0.9601845738327384,-0.03655044797295708},
{-0.001662403818827893,-0.9684218061226889,-0.02344779987905905},
{-0.010450921693942482,-0.972554311245585,0.004142120569148955},
{-0.0029754464238018574,-0.9307185729823055,-0.034404066692735207},
{-0.00218056953356538,-0.9452987946503931,-0.05691168960484788},
{-0.004538490631350195,-0.9483971051096483,-0.06745983414423595},
{-0.001740395771767766,-0.9381149879165892,-0.08045991747810348},
{-0.0020480900518593014,-0.9328702961771124,-0.09016083436432284},
{0.004919903332713677,-0.9191298234817745,-0.10798466656837544},
{0.009673138930377762,-0.9087045429778396,-0.11149750959942051},
{0.014018252253753768,-0.9100111752853117,-0.12660764919433243},
{0.025781148169753233,-0.9101222871086782,-0.12790359767263465},
{0.024596311514817407,-0.9164150624897168,-0.1344794945266743},
{-0.07979431492082213,-0.9663972204950032,0.07005814139834231},
{-0.07032416874467143,-0.9519484099257047,0.06268202573948124},
{-0.06185830251048617,-0.9326096107453681,-0.17075643647288338},
{-0.0658775590441819,-0.9281662061936294,-0.15671574817787293},
{-0.07418423622373647,-0.9403126515768264,-0.14031607040216068},
{-0.0837078015457364,-0.9552486447562699,-0.11077100921587103},
{-0.10170471178234049,-0.9749934294450606,-0.07662762795488005},
{-0.05839033156195445,-0.9159695468133343,-0.17238785718711871},
{-0.05408795355525782,-0.9110560537781226,-0.19060912783628953},
{-0.05158793752951407,-0.9106041278042382,-0.18397446992181574},
{-0.01705459650382374,-0.8425994183723401,-0.20991267038036568},
{-0.015667835477577847,-0.875369927585006,-0.22358797171776743},
{-0.04048316549037707,-0.8510001132485893,-0.199061105092554},
{-0.03727481159067258,-0.8757331777767807,-0.20957506137859858},
{-0.023223439466492298,-0.8901691677510755,-0.21637638702812195},
{-0.006251108447276366,-0.8822887753553976,-0.22420549704378445},
{-0.031573920345643235,-0.8942332963672845,-0.22076316728526035},
{-0.02139116276386387,-0.908475909033605,-0.23069592326446536},
{0.006447690904001527,-0.9043145575719503,-0.23479530851693492},
{0.020721286674914588,-0.9121062741855184,-0.13679895383944768},
{0.02242215227875393,-0.9033156195445698,-0.15420932185462727},
{0.029164716867843173,-0.9024577080622312,-0.13115361850610152},
{0.02714440477182547,-0.877988534114535,-0.1217272760295472},
{0.022065312384481103,-0.8690547161627106,-0.12312151573621198},
{0.025946747521885825,-0.857087759109567,-0.1337626095893777},
{0.026926454656760624,-0.8658655931555118,-0.11701998089731343},
{0.022460614063765368,-0.8752673628249754,-0.1082838137851311},
{0.012658200800432486,-0.8990185834524581,-0.11027848469114118},
{0.01742746214185134,-0.8635792537131649,-0.08953903550663786},
{0.009412453498633544,-0.8778613965474139,-0.0891351867640177},
{0.004441267785904612,-0.8896819851409304,-0.08461485864225625},
{0.0021324923023010884,-0.8776765663027756,-0.07135729502539545},
{0.0027756588183257616,-0.9176180616542414,-0.0795411081694968},
{-0.0031047207567569866,-0.9088103128866212,-0.05174392143539381},
{-0.013878294091628787,-0.8722064457678149,-0.04897360453165297},
{-0.00483550108227189,-0.8701498086526196,-0.060083718485374894},
{-0.042702196808953895,-0.9008690226646753,-0.20273954747573167},
{-0.06957416393694832,-0.8792364053615729,-0.04574495135652579},
{-0.05035929717498189,-0.8731273918422554,-0.03493077947080857},
{-0.050751393705515194,-0.8504798107680178,-0.19722989677284256},
{-0.05778669521385821,-0.9450648187915736,-0.1748729158520247},
{-0.08888198001269237,-0.8756594593555087,-0.1037720327267055},
{-0.08024410412887262,-0.8737673532095291,-0.1245958841616506},
{-0.07696630533956414,-0.8689884764218575,-0.14317613147092823},
{-0.0689961687788597,-0.8747598809394077,-0.050471477381265256},
{0.09377624215539844,0.5938189774720777,0.11166097218571915},
{0.0936480362053603,0.5372021615523176,0.13785024262976045},
{0.12198582469545745,0.5977687891161695,0.09235208772705808},
{0.12667068378643453,0.6210274852189223,0.08743432116017838},
{0.13045810122714463,0.6059867905136144,0.09376128479456065},
{0.131398278194091,0.5909503693399745,0.09521642232749356},
{0.10509255401209838,0.5197469214546248,0.1412263326474315},
{0.07448552020632611,0.5146924018743709,0.14471673963721993},
{0.06880599661963645,0.6003232926706794,0.10715880657354641},
{0.09967264747423595,0.6144323574723769,0.09934038038705377},
{0.1121342658179433,0.6250809300059617,0.08389476855620871},
{0.12938437639557518,0.6263758101013468,0.07571736570960926},
{0.1294324536268395,0.628912151146268,0.08648773389573011},
{0.13073694916847758,0.5530772633157904,0.12219950127885436},
{0.09987884537721398,0.49901174580178925,0.15148708218215073},
{0.0942612879997094,0.20843937033784404,0.15512919954615093},
{0.09717690498016014,0.18691252294352317,0.1457808490225365},
{0.11130947420603124,0.16830556606132083,0.13968679286405683},
{0.0821362102748522,0.17808126975172908,0.15690271518834525},
{0.07548766338245758,0.20895646766966447,0.1654519152900553},
{0.07542035525868757,0.2328081162913436,0.16031299345935981},
{0.09044502422024074,0.239414996249976,0.14742829548052658},
{-0.01067848725526018,0.3933390598657684,0.16837714771675888},
{0.010772504951954826,0.363901905354094,0.16773825473240214},
{0.02476725278153493,0.3403686348416762,0.16284078744094513},
{0.0034017312076786883,0.34287078763325396,0.1687008677406052},
{-0.03719040934023081,0.4191287550988574,0.16366130552118927},
{0.12561298469861987,0.6568289967670732,0.07605604309429334},
{0.12552965083109507,0.6338256441814797,0.07630818146270169},
{0.11473043630621566,0.6305275461167484,0.08517041775908821},
{0.12386511024643321,0.6486996711517381,0.06849509719079395},
{0.12514289621514668,0.6562584802894034,0.06077389384974691},
{0.12453071280371457,0.6696741645779781,0.0693262991002079},
{0.10777740028248045,0.6632820295856596,0.07093635215610358},
{0.098772000675218,0.6425874524836698,0.09621001844028916},
{0.10795047831503195,0.6286204826099312,0.080080641542574},
{0.0839631450628957,0.6488748859501235,0.09585424692893331},
{0.08531464945288111,0.6550426605298751,0.10670581221674498},
{0.10062671341910312,0.6783996478609906,0.08832535251294348},
{0.11409474847060985,0.6811603493184785,0.0671542766299784},
{0.13580108419498416,0.4497389940533806,0.15023280063761094},
{0.13664083316773398,0.43137669685916774,0.13888230052756748},
{0.12865894439494271,0.44905416060359366,0.14700201069664978},
{0.13231815588561466,0.47174340861159364,0.14897745071015414},
{0.13215683006515,0.5100727141413299,0.14021030049337926},
{0.007278892813415474,0.660361070690624,0.1037528018341998},
{0.026459571322038394,0.6586879830426263,0.1173479744528277},
{0.004504302378006701,0.6454336245745166,0.1107891717254598},
{-0.020583465278623578,0.6422851001181632,0.1047538766274143},
{-0.004149599249567837,0.16078735547450088,0.1599935469671814},
{0.010448784928108518,0.14872424395882883,0.15119648202873096},
{0.025670036346386843,0.16893591198234179,0.16693162563007882},
{0.015925315760571122,0.1860043974640863,0.1672104735714118},
{0.026657222161680528,0.18422447152438995,0.16991134558554863},
{0.06085509095143773,0.19309311811827848,0.17006519272559442},
{0.0447994324749945,0.1607382098603196,0.1614380006709445},
{0.029055741810310756,0.15522108047701164,0.15374671205157298},
{0.019499056617884307,0.15422000568379696,0.15170823744596654},
{0.07550368912621236,0.23229422410827408,0.17061327316200744},
{0.07437334000004274,0.2223828357874088,0.17267097866011963},
{0.02819676194505521,0.6544069726942693,0.11431590373442566},
{0.024321737105152386,0.6443321217871055,0.09887777058399948},
{0.03740835945529566,0.6399026062132875,0.11705951106524189},
{0.04595969632283968,0.6440586157603575,0.12464823492458287},
{0.05490633486966798,0.6521719156319377,0.1222315527663639},
{0.06804744474857745,0.6522028987365303,0.11131267935478219},
{0.06818633452778544,0.6395019626194186,0.10188099496364293},
{0.0599117088357404,0.6251033660472181,0.10374104962211297},
{0.06724081564625416,0.6211353918935376,0.10274104321181546},
{-0.03939982521255478,0.17415175738306,0.14680115470825666},
{-0.049827242482323605,0.19340829107878885,0.15079263328611084},
{-0.0196646559700169,0.2117780669534207,0.16689957414256928},
{0.02073838080158634,0.20481755224926654,0.1612082983437928},
{-0.0719342218005671,0.1654711461825609,0.13882460785005032},
{-0.06729957670668828,0.18409306042560097,0.1345980850304596},
{-0.035915828520268284,0.16246364827124948,0.14910245151144133},
{-0.05101207913725943,0.15531402979078923,0.14239407517569558},
{-0.09588843518227681,0.1549956516815277,0.1189612326574743},
{-0.09474099192943546,0.1475030822847154,0.11202742752624484},
{0.0012585550762077592,0.4995897409598778,0.16738889351854822},
{-0.00737397889302709,0.5525152939014566,0.15009177409256896},
{-0.008774628897193784,0.4623854426417264,0.1704861355948863},
{0.009966944232548503,0.4440445131058531,0.16493909148990274},
{0.01444774218638154,0.42159244610542357,0.15480441113938764},
{0.09302623734767532,0.6862522623008267,0.09578159689057837},
{0.06335938050884943,0.6652147342824846,0.10874749197110238},
{0.07564364728833732,0.6582360570687418,0.10701457487975351},
{0.04506118628965571,0.6640544704346395,0.11573685301401505},
{0.09584569986559745,0.3310555409543223,0.15774673769276298},
{0.11630630110876779,0.35886875343218005,0.14331608963305323},
{0.08618324476438952,0.310526563204465,0.15453945217597548},
{0.10161283085147982,0.2871524817466778,0.14371352807817145},
{0.08338835505355804,0.27884687295004024,0.14630863018352683},
{0.07267674792787134,0.26703483141985956,0.16346579144738108},
{0.09572817774472915,0.4568565610463313,0.15329371769477154},
{0.080701372017342,0.4337025664694431,0.15042190441391717},
{0.13243033609189803,0.3054485392000376,0.1247967401500437},
{0.13096878826146321,0.32808223129635444,0.13465791447381073},
{0.1303074592358498,0.3533206409442795,0.14170710496007455},
{0.13397308102402367,0.3583698186099483,0.14378297296777545},
{0.13641433598933325,0.37492654867445735,0.13728186291792469},
{0.1345980850304596,0.3977835328004239,0.13574766504913494},
{0.029904037846396458,0.30293570257928987,0.16460682440272054},
{0.02538050457588404,0.3147156926219611,0.16615704801526504},
{0.014665692301446381,0.28276676987245636,0.1515244755842452},
{0.002101509197708536,0.2939655596082881,0.1532841022485187},
{-0.0018643281901379674,0.2358220245001571,0.1746111620373635},
{-0.025626232646790464,0.23565428838219032,0.16276600063675623},
{-0.04020431754904412,0.21845118665290592,0.16088564670286348},
{-0.05464671782084073,0.2598146996668782,0.15744759047600732},
{-0.02228112573371197,0.2642474203894469,0.15781190905069906},
{0.0033194657230708803,0.26648675098344654,0.1667200858125159},
{-0.028951040284446266,0.2839857947807357,0.15860678594093552},
{-0.05308581037912636,0.27759793332008537,0.14754581760139487},
{-0.0608155607835093,0.2890317672976536,0.1475180396455533},
{0.11388107188721296,0.3946318031953196,0.14353403974811804},
{0.08783496475404758,0.37937208999202976,0.15521360179659274},
{0.10270151304388704,0.3723367884836867,0.14612166317305453},
{0.13183631519005465,0.38590631991230706,0.12793885430889515},
{0.08368643388739673,0.403356218095415,0.14680222309117366},
{0.13560022820659107,0.4105774182313135,0.13696134804282933},
{0.11596869210700068,0.16222433049784496,0.12754141586377693},
{0.13206388075137235,0.16199142302194228,0.11940781671677383},
{0.1122987967871589,0.7057181990482844,0.07806460297822423},
{-0.02180569533565386,0.29294418553965096,0.15456723013181708},
{0.02231104045538754,0.27818768069026073,0.15740699192516194},
{0.03292542473562865,0.25421316803312827,0.16921796507242567},
{0.10817911225926662,0.24910095577535737,0.13325512770381007},
{0.07566715171251098,0.24869817541565437,0.1561260008076975},
{0.07293850174253254,0.25696532242728054,0.15506723333696587},
{0.021735182063132887,0.47753938593623463,0.15938456870450027},
{0.022198860249104165,0.5018536443609681,0.15855764032675423},
{0.008659243542159464,0.537099596792287,0.15395611510330195},
{0.02427045472513713,0.5680367609194076,0.13807673980816118},
{0.02632602345741533,0.5872665850422117,0.13103609638523325},
{0.027625177084468495,0.6115915272961152,0.11073468419669358},
{0.01476718867855991,0.5989504206223544,0.11982021252272985},
{-0.016843056686260804,0.6344955202704289,0.1063949127879025},
{-0.002629290358698878,0.6355500142094928,0.09973568206633804},
{0.025155075780400306,0.6228351891144601,0.09774207954324494},
{0.01633771156652714,0.6401964115154583,0.09345252213155214},
{-0.022445656702927575,0.6516056726859359,0.09959038198962815},
{0.03502159201875226,0.6335841896422412,0.1001245734481204},
{0.01928003811990248,0.46195915785784947,0.1569401085904397},
{-0.018481956080915043,0.5930529469205998,0.13344423148011633},
{0.08529969209204331,0.6295478389818738,0.08033277991098234},
{0.06913612694098467,0.6358470246604144,0.087115943050917},
{0.0807975264798706,0.6488780910988745,0.08660311925076443},
{0.09252730252544354,0.6440767782699461,0.08134667529920066},
{0.061738643623783916,0.6334378211826145,0.09547817614215476},
{0.121810609897072,0.6689049288777492,0.06317134511546015},
{0.11941636378010971,0.6883569766472862,0.05469693181793901},
{0.07678254347784282,0.23805921832832247,0.15093686497990375},
{0.0308805398325203,0.26660640987014866,0.16672222257834987},
{0.030455323431560464,0.2733340170984001,0.1589401214110347},
{0.030987378124218746,0.2818565076271857,0.16555982196467073},
{-0.00012393241837020113,0.1460757227076241,0.14569431000626074},
{0.07523552501404925,0.1681688130479469,0.15767301927149108},
{-0.023120874706461788,0.32009286384314417,0.16233010040662657},
{-0.05123750793274316,0.14779581920396928,0.13161515992623884},
{-0.0855347363337799,0.15277341521420007,0.11963110874642359},
{-0.09491086481323598,0.13753506966924986,0.1191546099654485},
{-0.0809631258320032,0.14706718205458577,0.11765566873291923},
{0.10997826909146854,0.1552606106449399,0.1323096088222788},
{0.048757791182422114,0.15533432906621192,0.15168259625595892},
{0.07090323228567705,0.15681403940623545,0.14770607503894256},
{0.08872065419222773,0.15781511419944988,0.1464913236623312},
{0.09716301600223932,0.16100423720664866,0.13804361993773467},
{0.05679523586689659,-0.6944040239574186,-0.0263409808182531},
{0.03429936516687074,-0.7193935003856863,-0.03258567896802757},
{0.05808797919644784,-0.7346841966935687,-0.005915636211343228},
{0.10144082120184532,-0.6968880142394076,0.013294957018955257},
{0.10354874069705576,-0.7153667651715716,0.015499030976694304},
{0.10375387021711678,-0.7316916561430951,-0.00021901849798181713},
{0.08588837107930179,-0.7391660630303187,-0.007725476872714988},
{0.03799703844255413,-0.7600903424594603,-0.02115291337337632},
{0.02394993985004178,-0.7595059370038697,-0.029383735365824986},
{0.010379340038504525,-0.7327098250629813,-0.056193736284634296},
{0.023658271313705008,-0.7003688057829431,-0.046710769513479786},
{0.03621177058827301,-0.6517573830601479,-0.047599664100410895},
{0.05514137911140456,-0.6518407169276726,-0.01992854655051207},
{0.09275166293801029,-0.6554593298674992,0.002655999931623501},
{0.10827526672179523,-0.665331188020436,0.019971281867191465},
{0.11188640098120287,-0.7031241653258462,0.018418921488812967},
{0.10826030936095744,-0.7151541569710917,-0.001170947677015016},
{0.10979771237849816,-0.7476682542836813,-0.005351530031175405},
{0.09771964350198827,-0.7394417058229007,-0.00044017376179761054},
{0.06977929345700935,-0.7706075038942558,-0.01307166498930548},
{0.03760066838035287,-0.777828704030154,-0.028237360495900605},
{0.01622659974316075,-0.7856492669824806,-0.037014126158928365},
{0.012364395498261745,-0.7950884300540388,-0.04518618709094288},
{0.01948516763996351,-0.7980115257149085,-0.03255255909760105},
{0.023015104797680333,-0.8101024151864221,-0.054926634145090664},
{0.02956429207879538,-0.8181751165071571,-0.05590206774829753},
{0.021743729126468766,-0.8192680722312324,-0.06691816400532481},
{0.013104784859732014,-0.8167947657784131,-0.0618561657446522},
{0.16087389449077666,-0.4220433036963913,0.026972395122190962},
{0.1750385152041573,-0.40973339572689577,-0.00495943350064209},
{0.1793622608691936,-0.3361378384904178,0.03445428068983349},
{0.13653185811020155,-0.45943777417376613,0.046158415545398804},
{0.1561804883364637,-0.3554542016294977,0.05720976843868658},
{0.16921262315784077,-0.29712904142547936,0.0633401496163437},
{0.1842255399073071,-0.27990029850618703,0.0487449705874183},
{0.19007066284612936,-0.2755808263728186,0.028159368542960757},
{0.18864757680070599,-0.33965709181896464,-0.0008728688431763373},
{0.17699792947390688,-0.421168298087381,-0.045813327863212794},
{0.17569877584685373,-0.42901450222971527,-0.04214663769212195},
{0.15002446596879893,-0.44473575685314226,0.002228646764829697},
{0.12428498473280812,-0.5008760739919274,0.024738406442776348},
{0.11639497689087751,-0.5098269860704235,0.044513105853242654},
{0.12854462742282538,-0.40176966946369325,0.06466921796507244},
{0.1255488817236008,-0.3573110511392168,0.07074938514563128},
{0.12686085594565777,-0.2976172924185412,0.0832889954422785},
{0.14127013634702787,-0.30109274204749187,0.07848981937918406},
{0.12942070141475268,-0.2709269503864342,0.0940892783500749},
{0.17834516033222436,-0.22240099829699772,0.07663510663529895},
{0.18701081417188573,-0.19933995303388707,0.07153571497253187},
{0.18665931619219783,-0.24457101220734326,0.04787317012715894},
{0.1828398472639782,-0.2511212678713753,0.007841930610666315},
{0.18807171840845133,-0.29479782990061915,-0.0071677809900490734},
{0.18432810466733762,-0.3454594794411076,-0.01758665119648202},
{0.17857272589354206,-0.39302495528817494,-0.03864982040483165},
{0.17037181862276896,-0.4328072615850102,-0.06573332735038899},
{0.16719978974224195,-0.4689389034545094,-0.07107417355239455},
{0.15817729600830774,-0.4564997211520588,-0.029341000049145607},
{0.15692515122960188,-0.4819646279783846,-0.011932768799799992},
{0.15197105964354474,-0.5235535697878406,0.0005940209018433953},
{0.12161082229159588,-0.5195097404470542,0.028636935706852832},
{0.11257550796265789,-0.518830248911852,0.04480370600666245},
{0.11273790216603953,-0.49358542896642504,0.045653070425665125},
{0.11604134214535564,-0.4362517281093683,0.05716596473909021},
{0.11708408387233252,-0.40443635322448657,0.06681132571362637},
{0.10653700771586143,-0.36715726810214605,0.06685726617905671},
{0.07803575663946563,-0.30434596802970965,0.07209234247228082},
{0.16700641243426773,-0.5580975946427008,-0.04519793930302972},
{0.16292839484013788,-0.5135652578969524,-0.029253392649952876},
{0.15782579802861987,-0.5512973373760943,-0.0053814447528509725},
{0.1514347314192185,-0.5809567155345013,-0.003450876821859961},
{0.1342177407120131,-0.5870240621200564,0.018313151580031505},
{0.14370177586608462,-0.558084774047697,0.005782088346720179},
{0.16265595719630685,-0.5240492994613214,-0.015017190281134272},
{0.16362177535326083,-0.49446150295835234,-0.044924433276281685},
{0.16291130071346613,-0.5202779077643661,-0.0816030871992769},
{0.1565170289553138,-0.5398720504618619,-0.09763417286862949},
{0.1620512524652936,-0.5795176037453232,-0.0837291692040761},
{0.1695758733496155,-0.5914920394788856,-0.04924176864381608},
{0.1588621294580948,-0.603321175135738,-0.032209608181249016},
{0.13180212693671114,-0.6381910567802785,-0.0017809943226131718},
{0.10862996985023408,-0.6418374476759467,0.023410406476964605},
{0.11298469861986295,-0.5966950642846002,0.02956749722754634},
{0.10741735523945667,-0.5785817003100447,0.021598429049758876},
{0.11397722634974156,-0.5710560110428058,0.01980888766380982},
{0.0725966192090975,-0.560773893849747,0.026598461101246383},
{0.0785560591200371,-0.5194050389211897,0.018450972976322505},
{0.09698886958677086,-0.48085350974472063,0.035333559830511736},
{0.08935313687908257,-0.40653145212469316,0.055430910881907366},
{0.06685619779613973,-0.38271185499052357,0.048119966580982367},
{0.05275674844069514,-0.3483174037440412,0.045487471073532536},
{0.05441701549368907,-0.3084239856238395,0.05457086263373484},
{0.05712002427365988,-0.286667435902367,0.06635192105932304},
{0.08517255452492219,-0.2660070470537204,0.08887022780060556},
{0.10153270213270599,-0.19777690882633864,0.10816308651551186},
{0.13830644213531285,-0.14417186434955787,0.12108945142810745},
{0.1835161336504294,-0.11785118280672748,0.09156789466599145},
{0.19933033758763413,-0.14426054013166753,0.05723754639452818},
{0.20165086528332446,-0.18939651322551218,0.02382600743167158},
{0.03589339247901162,-0.9122932411959906,-0.10373463932461104},
{0.022957412120163168,-0.8588185394350819,-0.09834251074259022},
{0.01810695367705349,-0.5902644675072704,-0.0605388496080103},
{0.0342181680651799,-0.5547813340683808,-0.09718865719224695},
{0.02154180475515869,-0.6258480289403565,-0.08985100331839734},
{0.016109077622292457,-0.6353309957115111,-0.07083592416190701},
{0.010497930542289806,-0.711900930988874,-0.07004745756917245},
{0.024515114413126586,-0.6584379814400521,-0.09116511430628828},
{0.06746838120757186,-0.633748720611457,-0.12076038948967621},
{0.029707455389671306,-0.6190349510787463,-0.09940020983040489},
{0.04813919747348808,-0.5568133983764854,-0.11745481274452613},
{0.028285437727164922,-0.5107180174231887,-0.07608168428430097},
{0.02287087310388742,-0.5614865052553757,-0.06186898633965602},
{0.10564490798017936,-0.7577003698741659,-0.12957882208646634},
{0.08134026500169873,-0.7303615194114493,-0.14276800919664015},
{0.11146652649482797,-0.7069671386782395,-0.12913864832466873},
{0.14026371963922848,-0.7265281615053089,-0.10360322822582195},
{0.13422308262659804,-0.6953345854781121,-0.11660437994260646},
{0.12265249563565579,-0.6518001183768273,-0.12808949630018995},
{0.0820047991760631,-0.6890375365654053,-0.14128402532494866},
{0.08008277830840796,-0.7161990354639025,-0.1444272078667171},
{0.06972266916240917,-0.6801122656769168,-0.12032342087662953},
{0.06942245356273652,-0.7434513469103435,-0.12211616741132957},
{0.07862657239255808,-0.7633286110808404,-0.1437284854390092},
{0.08505930593572182,-0.7730327331158106,-0.1432402344459473},
{0.1255008044923365,-0.7614023166815173,-0.10366412605209006},
{0.14715478945377858,-0.7627260431156611,-0.07919388372147684},
{0.1448695183943487,-0.7388872150889857,-0.08762769846815256},
{0.14127547826161277,-0.7104297677121862,-0.10599961110861822},
{0.13542608179112262,-0.6555960828808732,-0.11697938234646803},
{0.1327220046282348,-0.6097325410205622,-0.12328284155667664},
{0.11962363006600471,-0.5977730626478375,-0.13228503601518812},
{0.08572704525883713,-0.5991053361453171,-0.13838016055658475},
{0.08772278454776421,-0.62870595324329,-0.13770494255305057},
{0.08320138804308574,-0.6522157193315342,-0.13978294732658542},
{0.021462744419301835,-0.34680243676775707,-0.005411359474526539},
{0.024944604345754358,-0.3039720340087651,0.016926390553785607},
{0.019260807227396762,-0.33036857073870135,-0.009885747130857669},
{0.009810960326668765,-0.3313002006423118,-0.016577029339931656},
{0.019764015581296465,-0.3048395609373565,-0.00923937546608204},
{0.025023664681611213,-0.2757912978074646,0.027733083759083937},
{0.04262527323893102,-0.39927713211836835,0.018796060658508505},
{0.0320461455949504,-0.42019500125000814,-0.018613367179704136},
{0.024086692863415794,-0.42029329247837066,-0.033402991899520715},
{0.020458464477336395,-0.3973978465673925,-0.035660485003108984},
{0.00701713899875427,-0.3247531501270308,-0.022461682446682344},
{0.012027854879411624,-0.34433019869785503,-0.039896623268952575},
{0.13279358628367277,0.016637927166199728,0.139328884586867},
{0.13500727568766469,0.05510825924097803,0.1309922926856369},
{0.07764152334309837,0.009017151819349154,0.15137169682711643},
{0.0499244653277692,-0.03484210368869895,0.160643123780708},
{0.02949271042335742,0.006305595976042542,0.16508332318369565},
{0.06574614794539282,0.07159981794755094,0.14573384017418914},
{0.0968275437663062,0.049336854723427685,0.14352121915311425},
{0.08338194475605613,-0.03527586715299468,0.15234178851573835},
{0.05198644435754931,-0.06481985995636727,0.15048387062310228},
{0.02962305313922953,-0.03443291303149386,0.16269441898131826},
{0.023783272114992194,-0.03018929608523141,0.16074462015782154},
{0.024635841682745834,0.03115190909343426,0.15653625984781955},
{0.030953189870875246,0.05714673384658438,0.1577253700344233},
{0.02852689226640342,0.0907548552661662,0.14331929478180416},
{0.07473338504306654,0.09460744406481235,0.13489830063013222},
{0.11184900757910841,0.11399218371057923,0.12776150274467574},
{0.12260441840439149,0.113937696181813,0.1258469605574395},
{0.16054269578651142,-0.4668106846838762,-0.09127302098090372},
{0.15274884240710943,-0.4291170669897458,-0.0803210276988955},
{0.15604053017433872,-0.4916399036745963,-0.09865875208601764},
{0.160989279845811,-0.4956848013982996,-0.07373658378151997},
{0.03663698698923284,-0.8944533832481832,-0.11458513622950574},
{0.04314984925117042,-0.8838742556042026,-0.11834263894854026},
{0.0538283365064306,-0.9005335504287421,-0.1252037940414148},
{0.04126415340269276,-0.9167697656181557,-0.11466740171411355},
{0.05420547567612613,-0.9104940843637886,-0.12913971670758573},
{0.05566595512364396,-0.885236443823358,-0.11994414494110005},
{0.051011010754342445,-0.8779970811778709,-0.10968766893804874},
{0.047950093697181825,-0.8724703363483101,-0.11290777504984006},
{0.03907396842287451,-0.8629221982192193,-0.11383085789011467},
{0.031289730489725366,-0.8437265623497587,-0.11099323286260382},
{0.024830287373637017,-0.8579478073577395,-0.10588529413650086},
{0.21143725280290257,-0.1400895732237601,0.015646467819238164},
{0.20593187563168142,-0.1356376216086856,0.0329980747739836},
{0.08137552163795923,-0.4972061786720856,-0.1284602251723836},
{0.040202180783210154,-0.7026134782915275,-0.09300380130641862},
{0.05426851026822822,-0.7136306429314718,-0.09948033854917872},
{0.04400776073350898,-0.7521020433891672,-0.08873988508473345},
{0.049398820932612816,-0.773423761263427,-0.1034354921078554},
{0.0462203817545839,-0.7944399216234294,-0.12823372799398286},
{0.07142780829791644,-0.7808981681506507,-0.14499024566396793},
{0.08118428109581899,-0.7996461515778948,-0.13752652260591414},
{0.12075397919217432,-0.7906866924360626,-0.0892879655211465},
{0.15243366944659903,-0.7982027662570487,-0.05003985068280351},
{0.1493642053261025,-0.7714098594649113,-0.05860507652826834},
{0.13890259980299022,-0.7526330296989084,-0.05279841537445752},
{0.13857781139622688,-0.7263582886215083,-0.07520988382404159},
{0.139261576463097,-0.6859103797673918,-0.08837877165879267},
{0.1411323149507369,-0.640509447710135,-0.0990273441923773},
{0.1336183778955848,-0.586981326803377,-0.12588969587411886},
{0.12070590196091002,-0.5241860524746954,-0.13193781156716816},
{0.10322288390737548,-0.515449885362513,-0.13379038754521932},
{0.11531056823013823,-0.4503618612939827,-0.12316745620164232},
{0.08668217958662129,-0.44520798210244944,-0.12111722938394903},
{0.05106336151727469,-0.4997029895490784,-0.11170691265114947},
{0.04437101092528371,-0.47635561766421586,-0.09486385596488867},
{0.03142862026893335,-0.477723147797956,-0.06192881578300715},
{0.02801300008333387,-0.48386848633645096,-0.053246067816674035},
{0.027732015376166947,-0.4963760451455886,-0.051752468498729685},
{0.08599841451975121,-0.0846981925097811,-0.09862456383267414},
{0.04320754192868758,-0.07700904065624356,-0.0826800171795973},
{0.022661470052158458,-0.14570285706959668,0.09143541518428537},
{0.055512107983598194,-0.10740560302736987,0.12666961540351754},
{0.016130445280632146,-0.10422930061517492,0.11749647967828854},
{0.015343047070814563,-0.11983196473481678,0.10327096113863979},
{0.012383626390767467,-0.13505748968476305,0.09452090504853665},
{0.08520674277826568,-0.4125368325010631,-0.1199740596627756},
{0.030678615461210226,-0.3610332972219908,-0.06498225415974887},
{0.05692023666818378,-0.37011027848469125,-0.10049423393739702},
{0.08047166969019032,-0.37358038619905687,-0.11183725536702158},
{0.04631867298294648,-0.3526838847257568,-0.08713517394342271},
{0.03328333301281846,-0.3467896161727533,-0.07411906486580042},
{0.023413611625715553,-0.3784778534905139,-0.05522257621309538},
{0.03239871195755529,-0.3922899078412897,-0.061148896253608455},
{0.06521088810398358,-0.4063925623454852,-0.09470039337859003},
{0.10420686457391823,-0.40302715615698403,-0.11429774122483691},
{0.10677205195759802,-0.370679726579444,-0.1122635401508984},
{0.08118962301040392,-0.35958563836947677,-0.09959465552129608},
{0.037625241187443516,-0.3312019094139493,-0.0764994220048419},
{0.016548183001173087,-0.30249659720040944,-0.047116755021933895},
{0.014815265909824214,-0.28821338598324353,-0.04659324739261148},
{0.08804970972036145,-0.8190351647553297,-0.13464082034713898},
{0.1253074271843623,-0.8350769342538521,-0.11389282409929977},
{0.10671329089716387,-0.8447041327187995,-0.11304239129738011},
{0.09012344096222841,-0.842403904298532,-0.11575822067235472},
{0.0816180445601147,-0.8602149159075807,-0.12760658722171295},
{0.11295798904693834,-0.8598623495449758,-0.11376248138342766},
{0.11918772983587503,-0.862052534524794,-0.10196860236283566},
{0.11950183441346847,-0.8523227712998162,-0.09768331848281078},
{0.1312882347536416,-0.8535428645910124,-0.09844187035386978},
{0.1516473396196984,-0.8471977384470414,-0.10008076974852402},
{0.14931719647775518,-0.8356837757506994,-0.10300600217522762},
{0.11148896253608463,-0.8188011888965101,-0.12148582149030869},
{0.0657814045816533,-0.806526537563275,-0.14275946213330426},
{0.07059340123975155,-0.8223535620954836,-0.13797738019688158},
{0.06963185661446548,-0.8405278238963071,-0.11759904443831903},
{0.06489678352639014,-0.8495353602694036,-0.11994414494110005},
{0.07256670448742195,-0.8631241225905294,-0.1242443861819627},
{0.07224832637816055,-0.8749788994373896,-0.12520913595599972},
{0.08148877022715958,-0.8726017474470992,-0.11993025596317924},
{0.09731152122770018,-0.8754201415821041,-0.10245792173881456},
{0.1144035111336184,-0.8733079485552259,-0.08601871379517388},
{0.13540257736694894,-0.8638506229740789,-0.09700275856469165},
{0.03232499353628336,-0.42468541465009396,-0.05853028972407942},
{0.06348331292721962,-0.4327933726070894,-0.09833289529633736},
{0.02994997831182679,-0.4555509971217765,-0.05930059380722525},
{0.15841127186712736,-0.17606950471904742,-0.07615647108848989},
{0.1920129829892072,-0.1346942394929883,-0.04390519597347845},
{0.2067673510727633,-0.15940700474575692,0.0034829283093695124},
{0.15224563405320973,-0.21495757451436656,-0.07803148310779769},
{0.20433784831954052,-0.18403857289683487,-0.001269238905377591},
{0.2098357468103428,-0.12475186806753041,-0.008033171152806527},
{0.2005653882396682,-0.07640433592523037,-0.023896520704192542},
{0.14486738162851473,-0.10803060703380588,-0.08694927531586741},
{0.13869747028292914,-0.2020012948800954,-0.09103477159041617},
{0.12065568796381174,-0.23139678245800727,-0.09823674083380875},
{0.181956294591632,-0.24240433165169864,-0.047224661696549326},
{0.18448515695613432,-0.22791812768030567,-0.04492122812753072},
{0.19349376171214772,-0.2300442096851049,-0.022912540037649805},
{0.19797455966598076,-0.1232101915183218,0.0686233031408321},
{0.14861740566713036,-0.3008694500178421,-0.07151221054835821},
{0.08929864935031635,-0.2711021651848196,-0.10193975602407707},
{0.12437152374908386,-0.2635209200058975,-0.09417474898343364},
{0.17014745821020222,-0.3016034290818104,-0.06393310213527009},
{0.1713835772451533,-0.27515133644019096,-0.06573546411622297},
{0.07716716132795724,-0.23810836394250398,-0.10308292574525049},
{0.08060628593773038,-0.2873148759500596,-0.1013649660147394},
{0.07913298589520873,-0.33276281685566367,-0.09877200067521799},
{0.10245364820714664,-0.3494862146552223,-0.0948884287719793},
{0.13980110983617416,-0.339496834381417,-0.0909364803620536},
{0.16769445103280578,-0.3211697938234647,-0.06624615115054155},
{0.18225223665963672,-0.29149973183588784,-0.0506199826067261},
{0.1806389784549901,-0.2689974508383601,-0.05452171701955354},
{0.18189860191411483,-0.2568905356230917,-0.02450229381812276},
{0.06995771340414576,-0.4674143210319725,0.03045104989989253},
{0.06252176830193357,-0.5215503518184946,0.0061709797285025405},
{0.03091152293711285,-0.5373228888219369,-0.02150120620431327},
{0.04312954997574771,-0.5057446949446258,0.0027617698404049673},
{0.05079733417094555,-0.4792381147742401,0.008456250787932409},
{0.0557044169086554,-0.46012474438938716,0.0182447750733445},
{0.06286258245245162,-0.4316769124588406,0.03438590418314648},
{0.0965027553595429,-0.0543347500090813,0.1356119804186779},
{0.06996091855289671,-0.07783703741690652,0.1347369748096676},
{0.04204620969792541,-0.09935747451372555,0.12646769103220748},
{0.018569563480107784,-0.07384769560488647,0.14213445812686834},
{0.020987314021243732,-0.06060936288053135,0.1470009423137328},
{0.02797774344707338,-0.7188667876076128,-0.0802729504676312},
{0.027870905155374933,-0.7416115915272963,-0.08273236794252954},
{0.03502693393333718,-0.7539118840505389,-0.08597918362724546},
{0.0362331382466127,-0.7758906574187442,-0.10023568527148677},
{0.028253386239655388,-0.791416397968363,-0.09463201687190301},
{0.026869830362160448,-0.7970318185800337,-0.10344190240535729},
{0.031249131938879956,-0.801154708256677,-0.11880524875159455},
{0.036469250871266276,-0.8153289444163104,-0.13104678021440308},
{0.040708594285860815,-0.819911238747257,-0.13433098930121345},
{0.15662814077868023,-0.650992420891587,-0.01673835516039632},
{0.16781731506825898,-0.6232678841958389,-0.041974628042487444},
{0.16743162883522758,-0.6643931478193237,-0.044766312604567975},
{0.15584715286636452,-0.6640416498396358,-0.019882606085081734},
{0.13241537873106024,-0.6774316929382027,0.006172048111419525},
{0.10767590390536691,-0.604501738259006,0.026353801413256932},
{0.08077295367277995,-0.5821671933794448,0.027233080553935182},
{0.03985922986685813,-0.5937997465795721,-0.01433663036301514},
{0.023717032374139153,-0.5657151648408003,-0.031563236516473386},
{0.03204187206328246,-0.5171881443684468,-0.01639006232945937},
{0.03182926386280255,-0.4446769957927081,-0.014020389019587725},
{0.12763757032630552,-0.8446859702092108,-0.04878450075534672},
{0.13120703765195077,-0.8487800135470954,-0.02712196873056878},
{0.14356822800146155,-0.8517287503979727,-0.03359850597332888},
{0.14381929798695292,-0.8428900185257598,-0.08143535108131035},
{0.15299777562676684,-0.8537308999844018,-0.06814253082818907},
{0.15291657852507604,-0.85743391517467,-0.036938270971822465},
{0.14472101316888786,-0.8568228001461549,-0.020756543311175064},
{0.13950837291692042,-0.8491304431438664,-0.016418908668217953},
{0.12402216253522994,-0.8454263595706811,0.0013247948170608008},
{0.1192796107667357,-0.8452607602185485,-0.010379340038504513},
{0.12841535308987026,-0.8386602905574182,-0.03279508201975653},
{0.12705530163654896,-0.8385128537148743,-0.055091165114306284},
{0.13808956040316497,-0.8366015166763889,-0.0744855202063261},
{0.14954903557074087,-0.8308600268805142,-0.0817013784276395},
{0.1536558995036293,-0.857785413154358,-0.09012130419639441},
{0.15046357134767957,-0.8587533680771459,-0.05485612087256969},
{0.1454827701886978,-0.8795494415562494,-0.04767551928751679},
{0.14360027948897108,-0.881572958801018,-0.028801466676068428},
{0.13522522580272953,-0.8926446109697286,-0.011447722955489023},
{0.13090468528644417,-0.884053743934256,0.012464823492458293},
{0.12854035389115742,-0.8535247020814236,0.011766101064750423},
{0.11545693668976512,-0.834536332497858,0.008618644991314055},
{0.11270478229561301,-0.833360042906258,-0.0024711696869851654},
{0.12958843753271923,-0.8174016072752603,-0.013300298933540166},
{0.1330948702662624,-0.8238215202234204,-0.046002431639519045},
{0.15422641598129905,-0.816395190567461,-0.045455419586022984},
{0.14932681192400807,-0.825353581326376,-0.08893219400979066},
{0.05955059540979964,-0.6178372938288066,-0.01600117094767701},
{0.03128438857514044,-0.6208875270567975,-0.039999188028983085},
{0.021898644649431517,-0.5901116887501416,-0.04161992491404858},
{0.0567599792306361,-0.14862915787921718,0.10551349688139026},
{0.030886950130022208,-0.19357175366508766,0.07299085250546479},
{0.047201157272375685,-0.2095633091665118,0.0739278243236602},
{0.08154859967051072,-0.158163407030387,0.11112891749306086},
{0.06141065006826967,-0.22773329743566736,0.08422276211172296},
{0.04276202625230504,-0.24812231702339976,0.06140637653660174},
{0.019759742049628527,-0.24935523090959988,0.035611339388927715},
{0.011945589394803816,-0.19556856133693173,0.04811569304931443},
{0.012582345613326584,-0.1804605585078537,0.06027282226168117},
{0.03119571279303073,-0.169685916790065,0.07856887971504092},
{0.05702921172571619,-0.12153710387032399,0.11164280967613041},
{0.10552631747639409,-0.08759885212939406,0.1267486757393744},
{0.09063840152821492,-0.13919319995641005,0.11826892052726834},
{0.11492381361418985,-0.12327429449334082,0.12576576345574866},
{0.02213368889116811,-0.16972865210674432,-0.057377504556653136},
{0.012597302974164367,-0.12552430891651026,-0.04923108481464624},
{0.04153231751485587,-0.14279258200373082,-0.08229753609531684},
{0.03578762257023016,-0.18963903614766764,-0.07807101327572612},
{0.07464791440970776,-0.16080124445242172,-0.10175278901360478},
{0.03418077466308546,-0.10550174466930352,-0.0733124357634771},
{0.013468035051506743,-0.08804009427410867,-0.06425789054203337},
{3.205148750953772e-05,-0.13600087180046033,-0.02948416336002153},
{0.0025256572157513883,-0.15175204114556293,-0.018461656805492336},
{0.0033386966155765987,-0.1677371863494852,-0.022145441103254927},
{0.1106919488800142,-0.06655811896230113,0.13803720964023275},
{0.015313132349138996,-0.09394611503919902,0.1257273016707372},
{0.04534751291140755,-0.8585984525541832,-0.11617702677581265},
{0.057749301811763756,-0.8726989702925446,-0.11800075641510521},
{0.06504635713476796,-0.8767417312504141,-0.1255488817236008},
{0.06521302486981755,-0.9093071109430189,-0.1298939950469768},
{0.0912334908129753,-0.9080688551422338,-0.12013645386615725},
{0.0942826556580491,-0.8988551208661595,-0.11507552398840162},
{0.09257644813962483,-0.8832642089586045,-0.1065177768233557},
{0.10965241230178827,-0.9085015502236126,-0.10201026929659805},
{0.13088438601102145,-0.8913636198522641,-0.06929317922978138},
{0.12666213672309867,-0.8699307901546378,-0.07328252104180154},
{0.16147432569012196,-0.6581837063058097,-0.07022480913339188},
{0.15909824208274842,-0.6257743105190846,-0.08603260277309469},
{0.1673418846702009,-0.6401707703254509,-0.06163607886375339},
{0.15063558099731408,-0.5810261604241054,-0.10854129406812436},
{0.143400491883495,-0.49639527603809436,-0.11536612414182142},
{0.12773158802300016,-0.7864911527210645,0.010159253157605718},
{0.0928542276980408,-0.7617495411295372,0.009869721387102915},
{0.0956758269817969,-0.792252941792362,0.023353782182364426},
{0.08617042416938571,-0.7882539845340889,0.018004388917022978},
{0.048702235270738914,-0.8455428133086325,-0.11459582005867558},
{0.032396575191721316,-0.8399573074186374,-0.11006694487357824},
{0.031294004021393304,-0.8393867909409677,-0.12745915037916908},
{0.055044156265958974,-0.837426308288301,-0.12252963160020257},
{0.03372564354045005,-0.8321100348933861,-0.12478819308670781},
{0.02880146667606844,-0.8229582668264969,-0.12648478515887923},
{0.028541849627241205,-0.818044773791285,-0.12015675314157996},
{0.027677527847400737,-0.812803287200559,-0.12413434274151329},
{0.024980929364931834,-0.797492291617254,-0.12032235249371256},
{0.026969189973440007,-0.7814740265429053,-0.105324393105084},
{0.025827088635183564,-0.7669824806569273,-0.10404660713637053},
{0.020189231982256303,-0.7451650331091867,-0.08835206208586807},
{0.01727788853347351,-0.7590860625174948,-0.10910753701412615},
{-0.0005406017559941545,-0.7615283858657214,-0.058075158601444014},
{0.0771628877962893,-0.8300662183731947,0.009097280538123115},
{0.04744474857744815,-0.8236078436400234,-0.010664598277339376},
{0.057960841629326694,-0.8415053942653479,0.0015940273121408976},
{0.08670995754246288,-0.8282702666897438,0.012442387451201619},
{0.059502518178535344,-0.8417147973170769,0.02308989160186925},
{0.0404746184270412,-0.8440267779494314,-0.004126094825394173},
{0.03486453972995553,-0.8301484838578026,-0.02340399617946268},
{0.038400887185174266,-0.8170469041468216,-0.02663692288625781},
{0.050904172462644,-0.8152872774825479,-0.008182744761184359},
{0.07072694910437462,-0.8097979260550816,0.023316388780269967},
{0.09275700485259522,-0.8224091180071668,0.021886892437344693},
{0.09157644172932734,-0.834395305952816,0.03496069419248414},
{0.05607300901501506,-0.8573495129242282,0.02951835161336505},
{0.025994824753150132,-0.850669982927241,-0.008270352160377088},
{0.015124028572832737,-0.8524926441836167,-0.037924388404199164},
{0.036447883212926586,-0.8240501541676549,-0.04064876484250966},
{0.03553227905307085,-0.8026269399162816,-0.017980884492849306},
{0.07404748321036247,-0.8033107049831517,0.024277933405556028},
{0.09367047224661697,-0.8063694852744784,0.0195482022320656},
{0.11097613873593208,-0.8205907302824592,0.02250655452919571},
{0.10954557401008981,-0.8358857001220095,0.022146509486171927},
{0.09370786564871143,-0.8712684055667024,0.05341059878588966},
{0.06567242952412089,-0.8789041382743907,0.04456118308450696},
{0.04851633664318362,-0.8864885886020637,0.022484118487939034},
{0.03843721220435174,-0.8861445693027947,-0.0010940241069921312},
{0.024820671927384155,-0.8586636239121191,-0.00787505048109282},
{0.016846261835011766,-0.8724917040066497,-0.03623420662952967},
{0.020753338162424122,-0.8672822689034332,-0.05147896247198165},
{0.016968057487548,-0.8504531011950932,-0.047176584465285026},
{0.027025814268040186,-0.8347553509958398,-0.05341700908339155},
{0.11938324390968319,-0.810112030632675,0.0010683829169845184},
{0.13275085096699338,-0.7977732763244211,0.00443699425423668},
{0.11713429786943079,-0.8227830520281113,0.006679529996987168},
{0.1431152336446601,-0.6819744571012208,-0.021146503075874408},
{0.1512296018991575,-0.7126958078791104,-0.02135911127635433},
{0.16490169808780827,-0.6795353389017452,-0.04767765605335076},
{0.16457797806396196,-0.6688504413489831,-0.06326108928048683},
{0.1605544479985983,-0.7075590228142489,-0.044109257110622496},
{0.15324670884642425,-0.7376874210732121,-0.029310016944553055},
{0.1424966399357261,-0.7544033401923518,-0.008691295029668986},
{0.14025089904422464,-0.7481223170233997,-0.008658175159242467},
{0.12410976993442266,-0.6976818227467271,-0.007149618480460337},
{0.05805058579435339,-0.309217794131159,-0.09293435641681463},
{0.03539445765677986,-0.2707528039709657,-0.0752376617798832},
{0.13723164892082643,-0.3556187325987133,-0.09435210054765307},
{0.165263879896666,-0.33890601862832465,-0.04376523781135348},
{0.18732064521781125,-0.2759665126058501,-0.01429175828050179},
{0.10825389906345553,-0.8027583510150706,-0.10667696587798639},
{0.1277561608300908,-0.8059282431297637,-0.08042252407600903},
{0.14657465752985596,-0.8101440821201845,-0.0626018970207074},
{0.11623365107041285,-0.09877306905813506,-0.09847285345846232},
{0.04999177345153922,0.15061421333897432,0.15941127827742485},
{0.08031889093306153,0.15349671044899862,0.15081400094445052},
{0.006354741590223875,-0.7254661888858263,-0.06585939653459316},
{0.007002181637916487,-0.7175248986638804,-0.06957416393694832},
{0.01597232460891844,-0.6465618369348521,-0.06767885264221778},
{0.11579988760611713,0.12448263557245016,0.12317279811622725},
{0.11758301869456428,0.13062263219636008,0.12660017051391356},
{0.12888223642459248,0.14133103417329596,0.12415998393152095},
{0.09716728953390727,0.13036194676461596,0.13620172778885337},
{0.09226982224245027,0.1471868409412879,0.14251480244531484},
{0.025443539167986123,-0.07945991106780605,-0.06906134013679574},
{0.14187804622679207,-0.061267486757393755,0.13213653078972729},
{0.046121022143304345,-0.2340453037092119,-0.08396741859456364},
{0.09549099673715859,0.12244950288142865,0.1409293221965098},
{0.08555183046045167,0.1187379406278245,0.14488340737226948},
{0.08350053525984141,0.13520492652730665,0.14948706936155576},
{0.07727186285382172,0.11819520210599642,0.14365583540065427},
{0.09510851565287812,0.11664497849345179,0.1339356876219292},
{0.09821323640963511,0.1247027224533489,0.13506603674809883},
{0.10354019363371987,0.12301467744451347,0.12596982459289272},
{0.07312012683841991,0.11543450064850828,0.137952807389791},
{0.04927061498257468,0.11132122641811802,0.141537232076274},
{0.047041968217744985,0.1109622497580111,0.15128622619375767},
{0.04982403733357266,0.12081487701844233,0.1534913685344137},
{0.07966183543911606,0.12738543195789717,0.145123793528591},
{0.07320773423761263,0.1359773673762865,0.1506825898456614},
{0.07847379363542929,0.14293681369752373,0.1479315038344263},
{0.04897787806332092,0.14103936563695924,0.15900636115188774},
{0.027909366940386374,0.148712491746742,0.15545398795291424},
{0.02127577740882955,0.14066115808434676,0.15232255762323263},
{0.1014077013314188,-0.1867618809522284,-0.10374318638794693},
{0.1679273585087084,-0.347296029675404,-0.0348944544516311},
{0.14345177426351025,-0.39387111455842666,-0.07246200296155744},
{0.1263843571646827,-0.41026651880247106,-0.1072143624852296},
{0.13417714216116772,-0.4434269877798363,-0.10738316698611315},
{0.026266194014064197,0.10188526849531088,0.14600520943510323},
{0.015430654470007292,0.1047335773519914,0.13836199804699603},
{0.021625138622683483,0.09229973696412587,0.1382145612044522},
{0.024456353352692438,0.06513503291687764,0.15145823584339216},
{0.006703034421160825,0.08521208469285059,0.13588441806250895},
{0.014981933644873796,-0.06842351553535611,-0.06772051957598019},
{0.1368737406436366,-0.7874110304125881,-0.00884621055263174},
{0.1547018463793571,-0.8057840114359708,-0.03581219537732079},
{0.1430148056504636,-0.8100960048889203,-0.021793943123567024},
{0.13895708733175638,-0.7772475037233146,-0.0261892704440413},
{0.10030192501233984,-0.8774511375072918,0.04917873405171402},
{0.11341953046707565,-0.8812844954134322,0.04240518635803221},
{0.11623258268749587,-0.8757609557326224,0.042793009356897595},
{0.08993326880300515,-0.8766263458953797,0.051646698589948234},
{0.02503541689369804,-0.20948852236232288,-0.05799930341433812},
{0.0007606886368929761,-0.2334202997027759,-0.009207323978572504},
{0.010245792173881461,-0.20387523851648628,-0.011201994884582586},
{-3.9530167928421944e-05,-0.1832917732378627,-0.007172054521717012},
{0.04458896104034856,-0.8284347976589594,-0.1324175154968942},
{0.012851578108406684,-0.7305004091906573,-0.07320452908886167},
{0.01681314196458525,-0.7197214939412006,-0.06964147206071833},
{0.008205180802441044,-0.29770810496648487,-0.02315506295980529},
{0.008413515471253024,-0.2821631335243603,-0.015208430823274503},
{0.08202403006856883,-0.9115795614074449,-0.11899862605956875},
{0.062082662923052936,-0.9144321437957936,-0.12061402103004933},
{0.05444479344953067,-0.9162537366692523,-0.12334908129752967},
{0.13819533031194647,-0.8992162342921003,-0.039283371474603465},
{0.13193353803550023,-0.9024171095113859,-0.038756658696530104},
{0.1293833080126582,-0.9069919251619135,-0.05493411282550956},
{0.1257005920978126,-0.9061094408724844,-0.07401863687160387},
{0.12097299769015615,-0.9093551881742833,-0.07299939956880065},
{0.12852325976448567,-0.9179727647826802,-0.06630598059389269},
{0.1145402641469924,-0.9113584061436292,-0.0918606315852452},
{0.10328591849947757,-0.9126949531727768,-0.10520152906963078},
{0.12724226864702126,-0.8909854122996516,0.0050299467731630835},
{0.13127007224405285,-0.897301692104864,-0.01393598676914595},
{0.12425613839404955,-0.8858593110639599,0.019952050974685744},
{0.02572666064098702,-0.8240715218259946,-0.06460618337297033},
{0.016973399402132924,-0.8331068361549328,-0.061498257467462396},
{0.03928337147460347,-0.9022472366275853,-0.05734758983497757},
{0.038291912127641846,-0.9076585961021119,-0.07979324653790515},
{0.037701096374549416,-0.9196308950698403,-0.06283800964536097},
{0.05706126321322573,-0.8475791511484049,-0.12080312480635559},
{0.04256010188099497,-0.850113355427492,-0.11256909766515598},
{0.04786462306382307,-0.8929544420156541,0.008113299871580382},
{0.0427096754893728,-0.8911285756105275,0.006232945937687643},
{0.0430269852157172,-0.8943198353835603,-0.007117566992950802},
{0.02802902582708864,-0.888266377775926,-0.02796385446915257},
{0.12035119883247115,-0.3811990247800734,-0.10359254439665211},
{0.024160411284687724,-0.8416068906424615,-0.11621442017790712},
{0.02544460755090311,-0.8433494231800631,-0.11447509278905633},
{0.030098483537287637,-0.4303125874738514,-0.022838821616377875},
{0.033041878473579964,-0.4505669908140438,-0.03501945525291828},
{0.037440410942805195,-0.9014299236960921,-0.03206003457287119},
{0.03060596542285528,-0.8964662166637821,-0.024855928563644634},
{0.026846325937986786,-0.8355630484810801,-0.13591219601835053},
{-0.0012094094620264597,-0.07432205762002758,-0.07339897477975287},
{0.03552586875556895,-0.9254546503503229,-0.10852847347312054},
{0.02486233886114655,0.1198682897539941,0.14601803003010705},
{0.026065338025671108,0.11124537123101219,0.14557785626830944},
{0.02074692786492222,0.12891535629501885,0.15024455284969776},
{0.028451037079297522,0.10784791355500126,0.14103509210529128},
{0.014734068808133391,-0.15988350352673208,0.07781460137564986},
{0.01450222971514775,-0.17529279033839965,0.06803355577065666},
{0.017811011609048782,-0.012929570061346608,0.16307155815101382},
{0.011451996487156972,0.12744419301833124,0.14800629063861523},
{0.01235798520075984,0.10799321363171129,0.14138872685081316},
{0.041423342457323445,-0.8971072464139728,-0.020311027634792523},
{0.140847056711902,-0.7170398528195695,-0.06701004493618548},
{0.061824114257142675,-0.8854137953875774,0.03873208588943947},
{-0.013059912777218656,-0.6272219693715986,0.0152853543932974},
{-0.005470120534960686,-0.589326427306158,-0.0037820755261251597},
{-0.02172129308521208,-0.6188298215586852,0.03342863308952836},
{-0.020895433090383057,-0.6670395323046943,0.015827024532208547},
{-0.06663824768107487,-0.5630324553362522,0.08946424870244896},
{-0.02377686181749028,-0.5776169505360078,0.045057981140904764},
{-0.005239349824892038,-0.5641371632724143,0.017287503979726376},
{-0.007943426987779834,-0.541110306262647,0.024097376692585642},
{-0.007989367453210168,-0.5385119990085407,0.0023632630123697454},
{-0.010446648162274539,-0.517663574766505,0.03160917698190374},
{-0.01969670745752643,-0.49214631717724694,0.02599161960439918},
{-0.021364453190939253,-0.49890597589300795,0.05056549507795991},
{-0.021994799111960114,-0.4808129111938752,0.042428690782205875},
{-0.03010596221770652,-0.47392290976224216,0.06105167340816288},
{-0.022862326040551537,-0.463725194819625,0.05116699466022218},
{-0.026741624412122297,-0.459171746827437,0.07674728684158233},
{-0.03281431291226225,-0.44421118084090283,0.0573604104299814},
{-0.032943587245217384,-0.4428895911725931,0.08173236153223205},
{-0.031063233311324635,-0.42264159812990265,0.0856469165400633},
{-0.026942480400515386,-0.4189321726421324,0.11332978630204894},
{-0.020116581943901347,-0.4003893187349492,0.09893973679318459},
{-0.028043983187926412,-0.4027301457060623,0.07761588215309073},
{-0.027631587381970395,-0.3850569554933045,0.08526443545578284},
{-0.014916762286937732,-0.38693089912969536,0.10560751457808491},
{-0.014878300501926288,-0.3849020399703418,0.11652318284091566},
{-0.020078120158889906,-0.3659937991055499,0.08903796391857213},
{-0.023163610023141174,-0.3511336611132123,0.06109547710775925},
{-0.15546894531375202,-0.44450925967474153,0.10898680974450692},
{-0.1550341134665393,-0.4460252950339426,0.04992980724235412},
{-0.15709716087923642,-0.4823075788947365,0.028657234982275535},
{-0.1625662130312801,-0.48139090635196385,0.06579422517665712},
{-0.15872537644472082,-0.500273506026748,0.019003326944403497},
{-0.15069434205774823,-0.49773930174766084,-0.00552781321247785},
{-0.14800842740444917,-0.4527315346038544,0.019931751699263037},
{-0.16140381241760096,-0.423511261824328,0.08005713711840035},
{-0.1580832783116131,-0.4278157765968586,0.1532573926755941},
{-0.16249997329042706,-0.4631653621711251,0.10066197005536362},
{-0.1624497592933288,-0.4612177001134623,0.11492915552877477},
{-0.15342619717647762,-0.4894689495872837,0.07580817825755294},
{-0.15505441274196202,-0.5253602053004613,0.02330677333401711},
{-0.14398810248783647,-0.5539832520293935,-0.021393299529697832},
{-0.13584702466041448,-0.5453720857184983,-0.034261971764776265},
{-0.13788015735143602,-0.5078344519302475,-0.029613437692976658},
{-0.12411190670025662,-0.4578287895007874,-0.014810992378156264},
{-0.1342722282407793,-0.4417421479197517,0.011382551597552984},
{-0.13376260958937772,-0.41873131665373936,0.03418184304600244},
{-0.15752665081186418,-0.4143744511182765,0.07553360384788793},
{-0.1701891251439646,-0.4038359220251413,0.13737588061461933},
{-0.16775000694448894,-0.4022995873905175,0.15966982694333512},
{-0.16379699015164628,-0.3981799028626253,0.17534834625008283},
{-0.15634181415692835,-0.4313596027324962,0.1691399731194858},
{-0.031302551084729166,0.14130432460037143,0.14001799156832204},
{-0.07059126447391756,0.1429667284191992,0.12505315205012},
{-0.04769581856293951,0.1254409750489852,0.13256602072235507},
{0.0008333386752479214,0.12303390833701927,0.14242933181195608},
{-0.019494783086216355,0.12281702660487122,0.13591326440126753},
{-0.053680899663886734,0.12282343690237331,0.1266247433210042},
{-0.08463836306642991,0.12387045216101812,0.1174451972982733},
{-0.08452297771139558,0.13707993854661465,0.11831592937561566},
{0.008057743959897183,0.14390476862031154,0.14691012976578913},
{0.009693438205800469,0.12280313762695062,0.14218039859229867},
{0.008464797851268281,0.11424004854731966,0.1402199159396321},
{-0.028160436925877722,0.11683942418434311,0.13569638266911968},
{-0.05602065825208281,0.1152080034701077,0.12687047139191066},
{-0.07484770201518386,0.11691100583978087,0.12077748361634798},
{-0.08353899704485285,0.10305514778940875,0.12478498793795688},
{-0.0874674410306049,0.12261403385064426,0.12370485280888553},
{-0.11118661017057802,-0.26501131417509094,-0.0013119742220569716},
{-0.07579749442838309,-0.28301142956044595,-0.003929512368669022},
{-0.11339816280873594,-0.30441007100472867,0.007574834881420188},
{-0.14113445171657082,-0.2584813577864816,0.008765013450940932},
{-0.1345564180966972,-0.3116259292260421,0.01845417812507346},
{-0.12897411735545314,-0.32692730936309433,0.022124073444915255},
{-0.1122763607459022,-0.3264112804141908,0.021944585114861855},
{-0.07179426363844212,-0.32655871725673463,0.029303606647051166},
{-0.056388181975525475,-0.3123000788466594,0.015110139594911942},
{-0.06790321305478454,-0.24940437652378114,-0.017827037352803537},
{-0.06626965557471522,-0.1447594749538993,-0.06391921315734929},
{-0.11810011602638479,-0.2110494298040373,-0.019877264170496813},
{-0.1560490772376746,-0.21719583672544918,0.013896456601217536},
{-0.17568168172018198,-0.24552828330096138,0.05374072910723787},
{-0.15266764530541863,-0.30901373299401497,0.03384957595882025},
{-0.1587446073372265,-0.337497889943739,0.05000352566362606},
{-0.12998267082908652,-0.34474793641839585,0.04818300117308445},
{-0.1041662660230728,-0.3457532847432784,0.03591369175443433},
{-0.07011476569294246,-0.35062938437639557,0.031648707149832166},
{-0.04025666831197635,-0.3562010012884699,0.05473859875170141},
{-0.03922567879708631,-0.3411175712664825,0.045430846778932346},
{-0.03830580110556264,-0.3262136295745487,0.03613805216700108},
{-0.053923422586042206,-0.2914890480067181,0.0062874334664538515},
{-0.04338168834415605,-0.2525817473188931,0.0018087722784547841},
{-0.026019397560240763,-0.21662211509902848,-0.0015331294858727648},
{-0.05869375231037806,-0.10349318478537266,-0.07671309858823881},
{-0.08496101470735923,-0.065182041765225,-0.08834244663961521},
{-0.10321967875862453,-0.13696989510616528,-0.05184541781250734},
{-0.1344752209950064,-0.13145383410577421,-0.027691416825321523},
{-0.1703483141985953,-0.14891014258638413,0.01676613311623793},
{-0.18227253593505943,-0.13855537535497034,0.04539879529142282},
{-0.192234138253023,-0.23388718303749814,0.0944076564593363},
{-0.18992108923775153,-0.30286518930676914,0.09053370000235045},
{-0.19545638113064828,-0.35858883710793027,0.10062991856785408},
{-0.16377562249330657,-0.3665055545227855,0.08110094722829421},
{-0.12409160742483392,-0.3591465329905962,0.04890843317371693},
{-0.10985219990726436,-0.3713079357346308,0.04357613403504724},
{-0.09199952136445319,-0.3643826776667372,0.041897704472464575},
{-0.0733818806530811,-0.370603871392338,0.03627587356329209},
{-0.04254407613724019,-0.3753004826954019,0.0607471842768223},
{-0.021542873138075666,-0.32304907937444055,0.07162225398880762},
{-0.02489118519990512,-0.29403286773205817,0.05153665514949883},
{-0.027264063658527727,-0.2671598322211468,0.029144417592420473},
{-0.01776827629236939,-0.2445346871881658,0.027876247069959857},
{-0.01881315478518024,-0.20847996888868955,0.007661373897695933},
{-0.009906046406280377,-0.18803218824052298,0.0008632533969234921},
{-0.027193550386006744,-0.17934516674252193,-0.022867667955136457},
{-0.021135819246704567,-0.08519712733201286,-0.07804750885155246},
{-0.0648711423363825,-0.06335190182843058,-0.09485317213571881},
{-0.06736154291587339,-0.03381859285422777,-0.09820468934629921},
{-0.11381376376344292,-0.04969903653228553,-0.07699515167832272},
{-0.16292732645722088,-0.10274424836056645,-0.008076974852402892},
{-0.16998292724098657,-0.0408506892138198,-0.007008591935418382},
{-0.1890332630337374,-0.12973373760942916,0.07711481056502499},
{-0.19216255659758502,-0.17413252649055455,0.08685098408750484},
{-0.1920055043087883,-0.2104233574146844,0.09484996698696788},
{-0.17376072923544383,-0.24392357215965063,0.14757145879140252},
{-0.17075964162163432,-0.3010756479208201,0.16095615997538448},
{-0.18998198706401964,-0.27580732355121945,0.09764913022946729},
{-0.19390081560351882,-0.3145586403331646,0.10446113970816052},
{-0.19693929661942278,-0.3650354596290148,0.10749214204364559},
{-0.19220422353134742,-0.37776631046780224,0.09658395246123373},
{-0.19044246010123997,-0.37386350767205784,0.09398778197296137},
{-0.16128522191381567,-0.3745184264001693,0.07882742838095116},
{-0.12463007241499412,-0.371503449808439,0.04415626595896983},
{-0.1100477139810725,-0.3817716780235772,0.023299294653598215},
{-0.08020564234386118,-0.3792513627224107,0.03075447064831613},
{-0.07135729502539546,-0.38922899078412904,0.029822840744705637},
{-0.04800030769428009,-0.3921659754229195,0.05168943390662761},
{-0.02689119802050013,-0.6545853926414059,-0.0939087216371045},
{-0.01429710019508672,-0.690790752932177,-0.08641401547445816},
{-0.037623104421609536,-0.686233031408321,-0.12568990826864274},
{-0.04353553548420182,-0.6372113496454038,-0.09831366440383164},
{-0.06401323085404394,-0.6931091438620334,-0.12400293164272419},
{-0.03393504659217901,-0.7230142500913468,-0.14408639371619902},
{-0.030077115878947937,-0.7169436983570409,-0.13793250811436825},
{-0.0066143586390511,-0.7188967023292886,-0.07895242918223834},
{-0.0059145678284262425,-0.7104970758359563,-0.0801351290713402},
{0.0007489364248061496,-0.7167193379444742,-0.07189576001555564},
{-0.008193428590354207,-0.6426077517590926,-0.057810199638031856},
{-0.012440250685367636,-0.6078682128304241,-0.03951734733342307},
{-0.048130650410152194,-0.6018713795173901,-0.07844815244542165},
{-0.0919845640036154,-0.6064590157629215,-0.07815327876033393},
{-0.0896597627762571,-0.6532445720805904,-0.09575595570057073},
{-0.09411705630591649,-0.6709156255275142,-0.10450708017359084},
{-0.08605503881435136,-0.6896892501447659,-0.11414816761645907},
{-0.054623213396667064,-0.7138592768757066,-0.13224550584725972},
{-0.0678989395231166,-0.7460453806327819,-0.12685658241398984},
{-0.034667957273230375,-0.7447579792178156,-0.15212811193234144},
{-0.022941386376408395,-0.7336799167516032,-0.14608640653679403},
{-0.0024124086265510207,-0.7327728596550834,-0.10256369164759602},
{-0.13760237779302004,-0.5600388464028617,0.07158058705504523},
{-0.1506067346585555,-0.5098814735991898,0.08227296328822621},
{-0.15082254800778636,-0.5456317027673255,0.032891236482285154},
{-0.14260775175909246,-0.6044857125152512,0.005065203409423572},
{-0.14819859956367243,-0.5832430549768483,9.829122836258246e-05},
{-0.14958963412158624,-0.4832071573108375,0.09329119631108747},
{-0.14512486191150797,-0.48382681940268857,0.1257956781774242},
{-0.1345361188212745,-0.49862926471750896,0.13093246324228575},
{-0.12531276909894723,-0.5221796293565985,0.13678399647860992},
{-0.11744626568119026,-0.5826191193533292,0.1036288694158296},
{-0.12330955112960125,-0.602780573379744,0.08230715154156973},
{-0.1358320672995767,-0.6075060310215664,0.055855058899950225},
{-0.14178509691301439,-0.6236033564317721,0.02161338641059666},
{-0.13271025241614795,-0.6199323927290133,-0.04192761919414013},
{-0.18630033953209102,-0.18589542240655396,0.116361857020451},
{-0.17590924728149965,-0.2264736739765427,0.14995502107919495},
{-0.16323822588606338,-0.25005929525189274,0.16689530061090138},
{-0.15238986574700264,-0.283554168082274,0.17983021258683282},
{-0.14888556977929346,-0.3643100276283823,0.1895279243243012},
{-0.16211642382322963,-0.3662576896860451,0.1696378395588006},
{-0.17646694316416556,-0.37835285268922664,0.15728946980429365},
{-0.1841977619514655,-0.3824949732583756,0.12506704102804078},
{-0.17066241877618873,-0.3912225933072221,0.11315777665241444},
{-0.15906619059523885,-0.39454419579612693,0.08383387072994058},
{-0.1732019649698609,-0.3850665709395574,0.07275687664664518},
{-0.18053855046079353,-0.3784255027275817,0.07829216853954193},
{-0.14038231014301372,-0.37571715203302586,0.03934854283253954},
{-0.1171385714010987,-0.3956104419472775,0.010283185575975922},
{-0.1019931751699263,-0.4614335134626932,-0.02041466077774002},
{-0.06868847449876815,-0.44169727583723833,-0.006904958792470884},
{-0.06804210283399252,-0.4160924108487875,0.012973373760942921},
{-0.05839567347653938,-0.41136481644113104,0.04519473415427877},
{-0.04296074547486415,-0.41797169639976334,0.0665891020668936},
{-0.04585926832864312,-0.4311234901078426,0.028620909963098063},
{-0.0343143225277085,-0.45882986429400197,0.036343181687062104},
{-0.027546116748611637,-0.47330431605330814,0.023259764485669788},
{-0.08397810242373348,-0.8529317495624972,-0.14171672040632738},
{-0.06960942057320879,-0.8597533744874433,-0.16165060887142438},
{-0.05892559140336369,-0.8482073603035918,-0.18258664051265286},
{-0.09168969031852768,-0.8282189843097286,-0.1566601922661897},
{-0.09017365495932665,-0.8553270640623766,-0.12132449566984403},
{-0.08630397203400876,-0.8696594208937237,-0.10689384761013423},
{-0.08701017314213552,-0.8739575253687524,-0.08495887794152526},
{-0.011183832374993855,-0.24988728560225815,0.04180796030743788},
{-0.004661354666803418,-0.19847349448821264,0.04406011149644122},
{0.0028504456225146783,-0.21192123026429657,0.0705346401793174},
{-0.01516249035784417,-0.2625828798047852,0.05316487071498322},
{-0.007075900059188411,-0.24320882398818797,0.07703040831458323},
{-0.017752250548614627,-0.30801800011538544,0.08577298572426748},
{-0.09562133945303068,-0.7133037177588746,0.03843507543851778},
{-0.13319850340920988,-0.7094404451310586,-0.017377248144753055},
{-0.12926471750887292,-0.7459855511894308,-0.053743934255988814},
{-0.0774791291397167,-0.7576800705987432,0.012657132417515505},
{-0.07741288939886366,-0.7877347504364345,-0.012988331121780687},
{-0.09624634345946662,-0.7808650482802241,-0.03713699019438158},
{-0.10787355474500905,-0.7759536920108463,-0.05642878052637089},
{-0.12491746741966295,-0.7650177244725928,-0.07626117261435436},
{-0.1298181398598709,-0.7482398391442681,-0.07626224099727133},
{-0.13399017515069542,-0.7131808537234213,-0.036307925050801604},
{-0.13685023621946293,-0.6821368513046024,-0.008767150216774886},
{-0.13246345596232453,-0.6836977587463168,0.005735079498372861},
{-0.10773359658288406,-0.6559208712876365,0.06664572636149378},
{-0.10224104000666671,-0.6762190783274252,0.05337106861796123},
{-0.08584777252845638,-0.7177107972914357,0.038959651450757166},
{-0.04177377205409436,-0.7630903616903527,0.0033034399793161143},
{-0.06328245693882652,-0.7969687839879317,-0.01088789030698914},
{-0.06346942394929882,-0.8036792970895114,-0.021268298728410646},
{-0.04963066002559845,-0.809077835969034,-0.03559424526225594},
{-0.07352504396395702,-0.7915702451084089,-0.059102942967583116},
{-0.11687468082060354,-0.7766075423560409,-0.10080085983457157},
{-0.1211546227860435,-0.7698991660202951,-0.10535003429509163},
{-0.11331696570704512,-0.7588820013803508,-0.10778487896289933},
{-0.12187898640375898,-0.7393840131453835,-0.08122808479541535},
{-0.12354139022258688,-0.7064842295997624,-0.06398224774945138},
{-0.12571020754406545,-0.662166637820328,-0.021854840949835138},
{-0.12797838447682358,-0.6459026446750729,-0.01440714363553612},
{-0.13795921768729286,-0.6531783323397373,0.020120855475569296},
{-0.08984993493548035,-0.5907527185003324,0.08714585777259257},
{-0.08253364871997043,-0.6782757154426204,0.03137947465475207},
{-0.08600055128558516,-0.690445665249991,0.037903020745859495},
{-0.06957736908569927,-0.72569161768131,0.028549328307660098},
{-0.05228131804263702,-0.7420806116278524,0.00974258381998176},
{-0.017356948869330355,-0.7787614023166817,-0.0235407491928367},
{-0.027111284901398938,-0.7869612412045376,-0.013465898285672765},
{-0.03925879866751283,-0.8011653920858468,-0.030857035408346625},
{-0.050552674482956084,-0.8143930409810319,-0.038756658696530104},
{-0.06006662435870315,-0.8058224732209822,-0.05443410962036081},
{-0.06544913749447111,-0.8216099675852624,-0.06131983752032598},
{-0.08992792688842022,-0.7880114616119335,-0.09131255114883213},
{-0.10122287108678046,-0.795970914343468,-0.11878494947617184},
{-0.11349965918584948,-0.7861759797605541,-0.13040575046421238},
{-0.10904770757077502,-0.7786470853445642,-0.1375564373275897},
{-0.09771216482156936,-0.7650914428938648,-0.13282884291993324},
{-0.09208392361489495,-0.7381372102812626,-0.09978375929760233},
{-0.10919728117915285,-0.7191167892101873,-0.08247488765953627},
{-0.0996480746671453,-0.6952587302910062,-0.09292260420472781},
{-0.11194195689288608,-0.6784904604089343,-0.06026213843251131},
{-0.11642702837838703,-0.6503813058630719,-0.06705598540161581},
{0.010004337634642962,-0.8590129851259731,-0.0856875150909087},
{0.015511851571698114,-0.8583655450782804,-0.0816383438355374},
{0.01889755703562203,-0.8583933230341221,-0.09665980764833962},
{-0.098979266961113,-0.012284266779487912,0.1623268952578756},
{-0.08477832122855487,0.012046017389000276,0.15954909967371586},
{-0.14709389162751044,0.027454235817750937,0.14493468975228474},
{-0.1047250302886557,0.035440398122210164,0.1559123242243006},
{-0.05388816594978173,0.030881608215437235,0.16227133934619242},
{-0.010225492898458748,0.014824881356076949,0.16032795082019757},
{-0.018207381671250022,0.04531225627514695,0.16252347771460074},
{0.0019455252918287973,0.057333700857056705,0.1575042147706075},
{-0.033270512417814646,0.08204967125857636,0.13450406733376497},
{-0.03515513988337531,0.11316311856699937,0.13250832804483792},
{-0.022541811165456182,-0.8063502543819726,-0.045655207191499084},
{-0.0022820659106789136,-0.8130447417397976,-0.05974717786652478},
{-0.0014476588525140065,-0.7994581161845056,-0.040124188830270274},
{0.00790282843693443,-0.7979474227398894,-0.04718192637986995},
{-0.013820601414111625,-0.8189176426344613,-0.056834766034825006},
{-0.02799483757374512,-0.8185896490789472,-0.05315525526873035},
{-0.03788272147043677,-0.8191858067466244,-0.0432267728211933},
{-0.04987318294775394,-0.8272681235136123,-0.030937164127120463},
{-0.060102949377880625,-0.8255950358656147,-0.040368848518259726},
{-0.08242040013077007,-0.8360074957745456,-0.0675057746096663},
{-0.0924685414650094,-0.8157659130293571,-0.10411925717472546},
{-0.08447703724596525,-0.5346038542982113,-0.06010081261204665},
{-0.052164864304685706,-0.5680388976852416,-0.06606879958632213},
{-0.0227063421346718,-0.5527268337190197,-0.036286557392461914},
{-0.05803776519934956,-0.5193772609653482,-0.04609324418746273},
{-0.09036916903313483,-0.47137481650523405,-0.02922775145994525},
{-0.11664284172761791,-0.5086880898809182,-0.04497571565629694},
{-0.11661185862302535,-0.543737459855512,-0.05231230114722957},
{-0.10660217907379749,-0.6518535375226764,-0.08285416359506577},
{-0.03655792665337598,-0.42893223674510733,0.1218939437645968},
{-0.05169798096996348,-0.411029344205198,0.16194868770526308},
{-0.038956446302006204,-0.4512753286880045,0.11957341606890644},
{-0.04797146135552151,-0.47675091934350017,0.10550601820097139},
{-0.05623753998423066,-0.46406921411889396,0.1309078904351951},
{-0.07657420880903083,-0.4354397570924601,0.16750855240525048},
{-0.10666094013423164,-0.4193541838943413,0.19989230700196797},
{-0.06948441977192162,-0.3863176473353463,0.1856261899114738},
{-0.05794161073682095,-0.35141571420329626,0.18181419966367304},
{-0.03766049782370399,-0.3668292745466318,0.1502851514005432},
{-0.03734425648027658,-0.38243407543210756,0.15181614412058198},
{-0.03026194612358625,-0.40088611679134706,0.13659916623397161},
{-0.05103985709310102,-0.8417778319091789,-0.03305149391983281},
{-0.05043194721333683,-0.8664564089086042,-0.030952121487958246},
{-0.025496958313835343,-0.8726370040833595,-0.03947888554841163},
{-0.02278006055594373,-0.8485449693053588,-0.04269044459686707},
{-0.009333393162776678,-0.8663570492973247,-0.048690483058652076},
{-0.06337113272093624,-0.8674297057459771,-0.042084671482936854},
{-0.075597706822907,-0.8684222334758557,-0.05360183932802987},
{-0.010230834813043667,-0.8302425015544972,-0.04610499639954956},
{0.0015138985933670533,-0.8279604356438183,-0.055330482887710815},
{0.0028899757904431076,-0.8572704525883713,-0.06274933386325125},
{-0.09842584461011501,-0.8292531789733696,-0.11604027376243864},
{-0.08978903710921222,-0.8513430641649413,-0.08816402669247879},
{-0.08310843872930809,-0.8710568657491394,-0.06752927903383996},
{-0.09794400391455502,-0.8070756863826051,-0.12379459697391221},
{-0.15780656713611413,-0.1584700329275616,0.1674359023668955},
{-0.11125819182601598,-0.12301467744451358,0.17968384412720595},
{-0.12722303775451552,-0.07687121925995263,0.16511110113953723},
{-0.1522135825657002,-0.12513221238597694,0.15977987038378452},
{-0.1498535247020814,-0.06909659677305625,0.14102333989320445},
{-0.14863770494255304,-0.04920651200755562,0.14399558116825537},
{-0.12020376198992729,-0.0474896206599616,0.15742729120058463},
{-0.10205941491077934,-0.02933138460289285,0.1566206620982613},
{-0.10219830468998732,-0.0995775613946244,0.17569984422977072},
{-0.05273644916527243,-0.10056367882700111,0.15919973845986193},
{-0.05795015780015684,-0.12272514567401076,0.17090494169834422},
{-0.09834785265717515,-0.14202227792058503,0.18205565420291156},
{-0.12219309098135245,-0.1778344732979058,0.18401613685557813},
{-0.1482755231336953,-0.20039444697295075,0.17578104133146155},
{-0.17023506560939494,-0.15648711423363826,0.14781825524522593},
{-0.1728451250755881,-0.12407985521274717,0.14541759883076175},
{-0.16856945664181608,-0.058266399143584315,0.11257978149432583},
{-0.1609550915924675,-0.04772145975294715,0.1330681606933378},
{-0.1382808009453052,-0.030486306536153102,0.1521922149073605},
{-0.028948903518612294,-0.04789881131716658,0.15361423256986692},
{0.010507545988542666,-0.06609978269091475,0.14826590768744247},
{-0.06261151246696024,-0.08073128673901764,0.16608867150857806},
{0.015895401038895553,-0.08354861249110579,0.1348747962059586},
{-0.029932884185155034,-0.11479347089831778,0.15637600241027186},
{-0.0507994709367795,-0.1379891324089685,0.1582232364737381},
{-0.08352617644984904,-0.15452235804930384,0.17726929873482097},
{-0.10069829507454107,-0.21709434034833558,0.18854073850900757},
{-0.12691320670859002,-0.24836697671138924,0.1899029267281628},
{-0.16045295162148474,-0.2216413780430217,0.1696378395588006},
{-0.17555240738722683,-0.19057707634878007,0.14235347662485015},
{-0.17891354004406013,-0.11964286095851054,0.11794306373758807},
{-0.18742320997784173,-0.07372589995235017,0.10521862319630254},
{-0.19228114710137031,-0.0410344510755412,0.07480176154975353},
{-0.16896368993818334,-0.031914734496161314,0.11807447483637716},
{-0.16012709483180446,-0.016537499172003263,0.13272414139406877},
{-0.15683754383040915,0.01976401558129639,0.13983636647243466},
{-0.14963984811868453,0.04128658944394932,0.13794639709228906},
{-0.144226351878324,0.061814498810889774,0.12244629773267778},
{-0.11545586830684812,0.052296275403474715,0.12929890576221642},
{-0.09657754216373182,0.050959728374327086,0.13610129979465682},
{-0.04084748406506878,0.04422036893398881,0.15678626145039393},
{-0.016970194253381962,-0.1212518456314891,0.13344423148011633},
{-0.07142994506375042,-0.17883234294236933,0.17681950952677047},
{-0.024548234283553096,-0.15167511757554009,0.1472402600871373},
{0.003804511567381844,-0.11571334858984143,0.11604561567702358},
{0.007897486522349504,-0.13796242283604385,0.10785752900125428},
{-0.025567471586356316,-0.16910792163197638,0.13841862234159621},
{-0.07468103428013427,-0.19939016703098525,0.17968384412720595},
{-0.0008846210552631698,-0.10166197646566122,0.1398064517507591},
{-0.003005361145477424,-0.10737248315694335,0.12209800490174083},
{0.008300266882052668,-0.10288848005435935,0.12200185043921222},
{0.012271446184484091,-0.11124109769934425,0.10725068750440708},
{0.008923134122654637,-0.1582948181291761,0.08786381109280617},
{-0.004759645895165988,-0.1855791810631266,0.10856266172646407},
{-0.04979839614356502,-0.21250136218821924,0.16472434652358883},
{-0.057425581787917436,-0.2967561757874517,0.18042209672284223},
{-0.08270245322085397,-0.33827887785605476,0.19793396111513537},
{-0.10385322982839633,-0.3339583373397693,0.20016153949704807},
{-0.12974442143859896,-0.32632046786624713,0.19523949939850044},
{-0.18816894125389694,-0.09258713196879478,0.0735143601347872},
{-0.13600194018337725,0.07813618463366213,0.10501028852749056},
{-0.1537381649882371,0.06844381481077869,0.10138099175849419},
{-0.17612933416239848,0.06784552037726735,0.10525387983256304},
{-0.16541986380254575,0.038765205759865966,0.1198170073739789},
{-0.18234625435633134,0.011633621583044257,0.10426028371976745},
{-0.18898304903663912,0.03864127334149575,0.10077628702748095},
{-0.02820530900839107,-0.7381243896862587,-0.032393370042970354},
{-0.015441338299177125,-0.7530593144827853,-0.06439037002373946},
{0.004667764964305332,-0.7308177189170018,-0.05423325363196772},
{-0.013566326279869308,-0.6968217744985545,-0.007495774545563319},
{-0.0021613386410596616,-0.6859050378528069,-0.024499088669371807},
{0.00033974576760108054,-0.7486308672918844,-0.06292348027871973},
{-0.01620950561648899,-0.7651010583401177,-0.06473118417425752},
{-0.035525868755568936,-0.7553723634980567,-0.03369893396752543},
{-0.04061030305749822,-0.7389844379344314,-0.02431532680765047},
{-0.040026965984824685,-0.6694252313583208,0.022944591525159354},
{-0.011101566890386046,-0.6632125846960558,-0.006151748835996804},
{-0.011357978790462327,-0.6683312072513286,-0.039276961177101555},
{-0.0028889074075261144,-0.6825545890251434,-0.05524394387143506},
{-0.14705756660833294,-0.39600894877531273,0.037657292674953054},
{-0.15537813276580834,-0.38281869328222196,0.04428126676025702},
{-0.1232657474300049,-0.40001111118233673,0.01382380656286259},
{-0.07118849052451191,-0.46797308529755544,-0.019030036517328097},
{-0.05457727293123673,-0.43361282230441656,0.009221212956493318},
{0.009516086641581042,-0.8503612202642324,-0.06083906520768295},
{0.004318403750451396,-0.863989512753287,-0.06910621221930908},
{0.010887890306989154,-0.8632726278159903,-0.0595388431977128},
{0.006789573437436568,-0.2680294959155722,0.004159214695820707},
{-0.0030331391013190194,-0.2253668292745467,0.013128289283905675},
{0.004500028846338766,-0.18322660187992665,0.035286550982164426},
{0.0017510796009376146,-0.18734308125906796,0.048710782334074804},
{0.002209415872323976,-0.18273621412103078,0.05762643777631054},
{0.007797058528152965,-0.1824317249896902,0.061288854415733444},
{0.011885759951452683,-0.17869558992899529,0.06863185020416798},
{-0.010975497706181874,-0.19009630403613698,0.03309316085359522},
{0.025647600305130167,-0.8385513154998858,-0.15653198631615162},
{0.019412517601608562,-0.8147659066190596,-0.13911948153513803},
{0.012760765560462997,-0.8229849763994214,-0.17774472913287906},
{0.024231992940125693,-0.83922653350342,-0.1693066408545354},
{0.01624262548691552,-0.8352521490522377,-0.18652576832757475},
{0.0043440449404590275,-0.8335438047679793,-0.20341262871343194},
{-0.016710577204554725,-0.8367382696897631,-0.21425457855499075},
{-0.034428639499825844,-0.8423739895768564,-0.20928552960809577},
{-0.04471823537330367,-0.8379017386863592,-0.19709741729113647},
{-0.05136250873403034,-0.8302296809594935,-0.1946732564524986},
{-0.07721203341047059,-0.8191003361132657,-0.1758932215377449},
{-0.09762989933696155,-0.8076600918381955,-0.15280012478712468},
{-0.02450015705228879,-0.5563913871242766,0.05636254078551787},
{-0.05580163975410099,-0.5031175413517609,0.10729662796983742},
{-0.025344179556706554,-0.5279350081303941,0.06463930324339687},
{-0.008412447088336035,-0.2264320070427803,0.10227522826001022},
{-0.01962833095083942,-0.2639803246602009,0.1258320031966017},
{-0.0249755874503469,-0.21992555507834458,0.13696027965991237},
{-0.025848456293523243,-0.7677944516738355,-0.1581366974574623},
{-0.027102737838063058,-0.7516330232886109,-0.15268580781500735},
{-0.011534261971764768,-0.7550881736421388,-0.12759162986087516},
{-0.012197727763212153,-0.7663831178404991,-0.14007888939459012},
{0.004384643491304435,-0.7513926371322894,-0.11365136956006128},
{-0.040577183187071715,-0.7738863710664813,-0.1553033459616194},
{-0.019015079156490314,-0.7706577178913541,-0.15980978510546007},
{0.00468165394222613,-0.7634995523475578,-0.14990908061376462},
{-0.1095605313709276,0.11543129549975736,0.1050690495879247},
{-0.09566834830137799,0.10172928458943116,0.12373156238181016},
{-0.09651878110329767,0.11108190864471348,0.1207550475750913},
{-0.0741062442707966,0.08874736376515234,0.1357156135616254},
{-0.0844663534167954,0.08852620850133648,0.13319422987754195},
{-0.012513969106639567,-0.18743068865826074,0.01872234223723657},
{-0.008230821992448664,-0.18155565099776286,0.01681955226208716},
{-0.0024626226236492913,-0.1871112421660823,0.008819500979707143},
{-0.007638937856439247,-0.1693963850195622,-0.013913550727889273},
{-0.030393357222375357,-0.06293843763955753,-0.08726231151054387},
{-0.031352765081827445,-0.7801235905358368,-0.1850257587121285},
{-0.004841911379773796,-0.7714803727374322,-0.16847330217928747},
{-0.024084556097581814,-0.7961461291418536,-0.1964531823921948},
{-0.015137917550753525,-0.7902807069276085,-0.18405353025767257},
{0.0036944681269324405,-0.8021194580307139,-0.15489522368733133},
{0.009798139731664952,-0.7712592174736164,-0.15512065248281504},
{-0.005276743226986497,-0.6257155494586504,-0.015822751000540595},
{-0.01335799161105733,-0.8238279305209222,-0.20921715310140876},
{-0.008745782558435203,-0.8079891537766268,-0.18442746427861717},
{-0.029369846387904196,-0.8267980350301392,-0.202787624706996},
{-0.06214569751515501,-0.7887465090588188,-0.17783981521249068},
{-0.09523885836875023,-0.7867144447507144,-0.15522642239159654},
{-0.05762643777631053,-0.7757079639399399,-0.15416979168669884},
{-0.05901854071714135,-0.7555956555277064,-0.14661632446361836},
{-0.14565371145541534,-0.404542123133268,0.05625249734506846},
{-0.17547868896595492,-0.3890836907074191,0.14933429060442696},
{-0.14771355371936143,-0.40338826958292473,0.19862520486242433},
{-0.1519379397731182,-0.414888343301346,0.19147131285029606},
{-0.12919420423635194,-0.4630884386011022,0.1729626471964564},
{-0.13612266745299648,-0.459031788665312,0.1696709594292271},
{-0.1498556614679154,-0.47261627745477003,0.11644946441964373},
{-0.173128246548589,-0.0017446693034358198,0.12193667908127617},
{-0.17374577187460602,0.0003579082771897835,0.11147400517524685},
{-0.15147960350173184,0.025705292982647295,0.12984698619862947},
{-0.1499731835887837,0.034089962115141696,0.12869740617995415},
{-0.15005224392464053,0.04262420485601396,0.12328497832251063},
{-0.10086068927792272,-0.45148900527140134,0.17302675017147548},
{-0.06751539005591917,-0.46424442891727946,0.15092297600198293},
{-0.1334517101605352,-0.4252206744915032,0.19752797560668123},
{-0.11584689645446446,-0.40630495494629243,0.20576520789663183},
{-0.07562655316166557,-0.35682921044365673,0.1953634318168706},
{-0.036190402929933314,-0.29377218230031393,0.15684074897916014},
{-0.035427577527206364,-0.3429338222253562,0.15203302585272985},
{-0.026422177919943928,-0.32485892003581224,0.13398803838486148},
{-0.023834554495007442,-0.33350641136588494,0.11521014023594169},
{-0.02861449966559615,-0.3679500082265485,0.12298583110575496},
{-0.1019237302803223,-0.4727017480881288,0.1592285847986205},
{-0.018961660010641087,-0.3533911542168006,0.07310837462633307},
{-0.11762361724540969,-0.6291386483246687,-0.06753889448009281},
{-0.006426323245661824,-0.184995843990453,0.02528114496460448},
{-0.004443404551738576,-0.18824800158975388,0.0169477582121253},
{0.005620762526255512,-0.1908067786759317,0.0029978824650585445},
{0.012549225742900065,-0.7864334600435473,-0.15153943294508299},
{-0.004553447992187979,-0.6200573935303004,-0.029563223695878386},
{-0.16244441737874388,-0.048281292401447115,-0.020393293119400333},
{-0.15573604104299815,-0.059790981566121164,-0.0275065865806832},
{-0.088909757968534,0.0626083073182092,0.12953074485520205},
{-0.03246174654965736,0.06688183898614725,0.15199029053605045},
{-0.06303245533625215,0.09688950997549117,0.12435122447366116},
{-0.000991459346961624,0.11272721833686973,0.1356686047132781},
{-0.0029711728921339225,-0.7815466765812602,-0.04968621593728164},
{-0.015161421974927185,-0.7760338207296201,-0.03929832883544125},
{0.005673113289187753,-0.7813885559095466,-0.052572986578973795},
{-0.05365953200554704,-0.46013222306980606,0.0063034592102086204},
{-0.03948636422883052,-0.4975095994205092,-0.018103748528302523},
{-0.00268164112163112,-0.18014538554734333,0.03474701760908725},
{-0.0927644835330141,0.1231428833945515,0.11292273241067786},
{-0.09507005386786668,0.11697190366604897,0.1140926117047759},
{-0.06699829272409866,-0.6906689572796408,0.014472314993472188},
{-0.05137319256320018,-0.7367365602770958,-0.011071652168710474},
{-0.09039587860605944,0.07475475270140618,0.12700188249069974},
{0.014055645655848227,-0.12250612717602892,0.0977869516257583},
{-0.04185924268745312,-0.4918578537896611,0.1054910608401336},
{-0.007262867069660702,-0.6501996807671845,-0.04495434799795724},
{0.012465891875375276,-0.1498503195533305,0.07611907768639543},
{0.010985113152434741,-0.14095068985484957,0.08364369857071735},
{-0.0175332320506328,-0.7745744096650193,-0.05724929860661499},
{-0.13339401748301805,-0.37364876270574393,0.20084530456391816},
{-0.02639226319826836,-0.5034060047393467,0.08081355222362538},
{-0.046840043846434906,-0.23606454742231256,0.1650993489274504},
{0.09164268147018037,-0.967524364472422,0.15806832095077533},
{0.08734030346348375,-0.9783962290356563,0.1559956580918254},
{0.08736914980224232,-0.9784154599281619,0.15599886324057632},
{0.09164802338476528,-0.9775372491704007,0.1635801084194984},
{0.08547597527334577,-0.9813577864815374,0.15280653508462663},
{0.07144597080750519,-0.9827819409098777,0.11160968980570389},
{0.08536913698164732,-0.9797327760648039,0.14927232439524185},
{0.08529648694329238,-0.9797156819381322,0.14928728175607964},
{0.11589924721739671,-0.9034854924283704,0.06392455507193423},
{0.10739598758111697,-0.8946841539582518,0.05953029613437694},
{0.09421534753427908,-0.8993818336442327,0.06869702156210404},
{0.10068440609662029,-0.9215336850449897,0.0990551221482189},
{0.08104004940202608,-0.920545430846779,0.09268755996299123},
{0.08536486344997939,-0.9068466250852036,0.07573552821919799},
{0.08870569683138994,-0.8978583196046129,0.0763498483964641},
{0.09511278918454606,-0.8879586834958345,0.06883484295839505},
{0.10148462490144168,-0.8882204373104956,0.06285403538911576},
{0.11461825609993227,-0.8906841283170619,0.06308160095043346},
{0.12205740635089542,-0.9314215689416813,0.11910546435126722},
{0.16264527336713697,-0.936413053929833,0.14232783543484254},
{0.15196785449479377,-0.9327057652078967,0.07676010743658614},
{0.12616640704961785,-0.925852088795441,0.09459034993814064},
{0.12524332420934323,-0.9114225091186482,0.06598653410171433},
{0.14330006388929847,-0.9242943865024776,0.05881982149458224},
{0.16610469725233282,-0.9388446934488897,0.04809859892264267},
{0.1728996126043543,-0.9417838148535141,0.09914700307907957},
{0.1703953230469426,-0.9488511678493666,0.1427434363895495},
{0.15531723493954022,-0.9527069617967637,0.17566565597642722},
{0.1482146253074272,-0.93364701055776,0.1735983350320622},
{0.13662053389231127,-0.9308211377423361,0.17680882569760062},
{0.18369882712923374,-0.9818460374745993,0.07640006239356235},
{0.18178001141032954,-0.9787872571832726,0.12340677397504686},
{0.1030284382164843,-0.9778802000867528,0.17333658121740098},
{0.10532652987091798,-0.9611332978630206,0.17420410814599238},
{0.12563328397404258,-0.9573469488052274,0.19623095874546204},
{0.1345628283941991,-0.9664249984508448,0.19731643578911834},
{0.16271578663965797,-0.9724036692542902,0.1789755062532452},
{0.17271691912554996,-0.9749154374921207,0.1501676292796749},
{0.17075002617538146,-0.9590905497257461,0.13857246948164198},
{0.17310794727316628,-0.9601535907281458,0.11947191969179291},
{0.17530454255048644,-0.9620456968741253,0.10559362560016411},
{0.18148513772524183,-0.9681044963963444,0.08387981119537093},
{0.1781069109417368,-0.9695639074609453,0.060745047510988325},
{0.17378102851086652,-0.9825565121143939,0.04115624672807733},
{0.17261435436551942,-0.9844731910674642,0.045372085718498205},
{0.08320245642600273,-0.985319350337716,0.05901640395130739},
{0.06963613014613342,-0.9848150736008993,0.07364683961649328},
{0.06693846328074753,-0.9834528853817439,0.10010106902394675},
{0.06875364585670422,-0.982765915166123,0.1068361549326171},
{0.06867458552084736,-0.9827327952956965,0.1068297446351152},
{0.16320617439855384,-0.9688748004794903,0.1839092985638797},
{0.16230339083370196,-0.9568907492996751,0.1745556061256803},
{0.14216223608270992,-0.9511054558042039,0.18943070147885566},
{0.16641666506409228,-0.9591589262324333,0.15042297279683417},
{0.17481949670617547,-0.9560146753077478,0.12080098804052163},
{0.17886439442987884,-0.9542849633651498,0.09780404575243004},
{0.17688788603345748,-0.9621867234191673,0.08383814426160853},
{0.17452569140400473,-0.9632775423774085,0.06788932407686377},
{0.1708857108058385,-0.9653320427267696,0.045893456581986646},
{0.16655555484330029,-0.9714645606702608,0.02776940877826141},
{0.16288779628929245,-0.9828086504828023,0.018000115385355044},
{0.1468417532591021,-0.9845159263841435,0.013948807364149777},
{0.07526223458697386,-0.9873450043483186,0.004039555809118442},
{0.06613931285884311,-0.9863054677700926,0.01137934644880203},
{0.07112225078365887,-0.9823567245089179,0.05093942909890449},
{0.07097908747278296,-0.9680329147409065,0.05312640892997178},
{0.0685891148874886,-0.9650414425733499,0.06775470782932369},
{0.0721895653177264,-0.9663865366658334,0.08167039532304696},
{0.07473979534056843,-0.9651643066088031,0.09120998638880164},
{0.0794940993211495,-0.9657017032160463,0.11913324230710881},
{0.0703968187830264,-0.9825565121143939,0.1119398201270521},
{0.10298356613397094,-0.9320038376314379,0.12628392917048614},
{0.089324290540324,-0.9375466082047536,0.13258097808319286},
{0.06566281407786802,-0.9398414947104363,0.08439584014427444},
{0.07662762795488007,-0.9173552394566632,0.07560732226915985},
{0.07093848892193755,-0.916472755167234,0.07436479293670688},
{0.06267882059073028,-0.9379803716690492,0.06744380840048121},
{0.062286724060196974,-0.9362955318089646,0.057286692008709464},
{0.07520561029237369,-0.9087130900411755,0.07568958775376766},
{0.08663303397244,-0.8799084182163561,0.05602600016666774},
{0.09598993155939035,-0.8800494447613981,0.056902074158595044},
{0.10160214702230998,-0.8847225516402883,0.050942634247655445},
{0.11643023352713801,-0.8872118838368623,0.05440846843035319},
{0.1091737767549792,-0.8812663329038435,0.052863586732393594},
{0.1209484248830655,-0.9891185199905129,-0.09243542159458287},
{0.09550061218341142,-0.9939764571140414,-0.08082530443571219},
{0.10847825947602228,-0.9857723446945174,-0.10583721690523656},
{0.10897612591533708,-0.9664474344921016,-0.10922826428374541},
{0.09600595730314511,-0.9889529206383803,-0.11802426083927889},
{0.07995457235836984,-0.9880159488201848,-0.12745594523041814},
{0.05540633807481672,-0.9927414064620073,-0.08921104195112362},
{0.060445900294232656,-0.9884187291798879,-0.037408359455295644},
{0.0861843131473065,-0.989042664803407,-0.03306965642942155},
{0.11145477428274114,-0.9918055030267289,-0.038697897636095956},
{0.1332871791913196,-0.9881954371502382,-0.07006562007876117},
{0.12849013989405914,-0.9697230965155761,-0.07620454831975418},
{0.10285642856684979,-0.9606055167020302,-0.1094216415917196},
{0.09465017938149177,-0.9681258640546841,-0.1204783363995923},
{0.07118421699284398,-0.9678363322841814,-0.13225725805934652},
{0.07085729182024672,-0.9885661660224317,-0.12782667410261175},
{0.03636241257956782,-0.9904892552730039,-0.0999792733714105},
{0.03789340529960663,-0.990491392038838,-0.09493223247157566},
{0.03619467646160125,-0.9870608144924006,-0.07379961837362205},
{0.05039669057707635,-0.9891890332630338,-0.02041893430940796},
{0.06452925980294746,-0.9903322029842072,-0.020104829731814513},
{0.08326869616685578,-0.9874988514883642,-0.027921119152473195},
{0.11132229480103505,-0.979523373013075,-0.0341626121534967},
{0.1317284085154392,-0.9865832473285086,-0.04723427714280219},
{0.13479253072135078,-0.9711248149026597,-0.05717130665367512},
{0.1295136507285303,-0.9657529855960616,-0.0634918599905555},
{0.1178159261704669,-0.9626696324976444,-0.08778795590570024},
{0.09755083900110471,-0.9547454364023702,-0.11913537907294278},
{0.0853424274087227,-0.9619847990478573,-0.12185120844791739},
{0.06606238928882023,-0.9623982632367302,-0.12924121308469924},
{0.051011010754342445,-0.9714367827144191,-0.12425079647946462},
{0.03829084374472486,-0.9805180375087875,-0.10737034639110933},
{0.03264550841137871,-0.9687262952540294,-0.08388515310995583},
{0.03331752126616197,-0.9813438975036165,-0.060280300942100046},
{0.045778071226952315,-0.9775532749141554,-0.020015085566787813},
{0.053320854620862966,-0.9805073536796176,-0.013857994816206079},
{0.06669059844400713,-0.978895163857888,-0.017626181364410447},
{0.08215544116735791,-0.9736547456500789,-0.024961698472426096},
{0.09451983666561967,-0.9750147971034003,-0.028851680673166704},
{0.12607666288459113,-0.9902242963095919,-0.017770413058203354},
{0.12864291865118793,-0.9740553892439482,-0.04070111560544191},
{0.12980104573319914,-0.9680371882725745,-0.047832571576313515},
{0.13442928052957606,-0.9587978128064923,-0.05263922631982683},
{0.10615986854616591,-0.9341160306583163,-0.10532118795633304},
{0.0776522071722682,-0.9229877541950057,-0.12074756889467239},
{0.033042946856496946,-0.944897082673607,-0.10806800043590022},
{0.04323104635286124,-0.9246106278459051,-0.12081487701844242},
{0.0421925781575523,-0.9363478825718969,-0.02927582869120955},
{0.03421923644809689,-0.9637850242629761,-0.0587525133708122},
{0.0501520308890869,-0.9652700765175846,-0.01581740908595567},
{0.046086833889960835,-0.9709848567405348,-0.033187178550289846},
{0.1711869947884281,-0.948061632873715,0.04757402291040328},
{0.16577670369681857,-0.9636204932937605,0.040296198479904795},
{0.1593973892995041,-0.9652636662200827,0.03151088575354116},
{0.15625634352356962,-0.964829902755787,0.013706284441994294},
{0.15714096457883278,-0.9696504464772211,0.006263929042280193},
{0.15498603623527502,-0.9804945330846139,0.0013034271587211105},
{0.1487263807246628,-0.980418677897508,-0.018142210313313967},
{0.0601328640995562,-0.9885907388295225,-0.004114342613307342},
{0.05904418190714899,-0.9740233377564387,0.009411385115716563},
{0.06420553977910115,-0.9716002453007179,0.03272136359848461},
{0.056960835219029185,-0.9672156018094134,0.020641157956140754},
{0.058287766801923956,-0.9451513578078493,0.03171067335901726},
{0.07002715829374975,-0.9558960848039625,0.09476129120485817},
{0.07568210907334877,-0.9595082874462871,0.11890140321412317},
{0.09129866217091136,-0.9468180351583452,0.15096891646741328},
{0.09745682130441007,-0.9620360814278724,0.16415596681175307},
{0.0402748308215651,-0.9093519830255322,-0.015110139594911925},
{0.05299072429951474,-0.9147515902879719,0.027331371782297758},
{0.049490701863473485,-0.9432955766810471,-0.01393598676914595},
{0.053677694515135786,-0.9726280296668569,-0.008465866234185255},
{0.13928187573851972,-0.9381822960403593,0.18574798556401004},
{0.10944621439881025,-0.9503928443985753,0.17970521178554566},
{0.120569148947536,-0.9559495039498117,0.18685696703183993},
{0.11484261651249902,-0.9333916670406007,0.1726218330459383},
{0.13727972615209075,-0.9706258800804279,-0.04207719280251796},
{0.13565257896952332,-0.9596664081180009,-0.04550563358312125},
{0.14579366961754028,-0.9337527804665415,-0.019773631027549313},
{0.12117278529563225,-0.9019448842620786,0.0665260674747915},
{0.13409808182531083,-0.9102611768878861,0.061870054722573016},
{0.14662273476112025,-0.922746299655767,0.053281324452934535},
{0.15644117376820793,-0.9348339839785299,0.011595159798032901},
{0.14111949435573307,-0.9592037983149465,-0.022666811966743368},
{0.14585349906089143,-0.9619442004970118,-0.007802400442737874},
{0.14631931401269668,-0.964759389483266,-0.01883238567768596},
{0.1404891484347122,-0.961382231082678,-0.03985175118643922},
{0.16107581886208674,-0.9594943984683663,0.01777468658987131},
{0.07965863029036512,-0.9423692886920216,0.12400079487689024}
};


// texture array: 35kb.
const tgx::fVec2 dennis_tex_array[4595] PROGMEM = {
{0.748991,0.885931},
{0.710938,0.87892},
{0.729968,0.898717},
{0.749341,0.908892},
{0.748471,0.911627},
{0.758487,0.91596},
{0.755778,0.918292},
{0.76044,0.92319},
{0.769943,0.925185},
{0.764394,0.924815},
{0.756965,0.895615},
{0.778895,0.92494},
{0.782809,0.902792},
{0.79853,0.932551},
{0.796487,0.935129},
{0.7785,0.928926},
{0.835217,0.960501},
{0.840998,0.965883},
{0.844193,0.960876},
{0.847603,0.970033},
{0.850498,0.968589},
{0.855059,0.97221},
{0.858361,0.97235},
{0.853059,0.963141},
{0.859072,0.963004},
{0.868572,0.967104},
{0.865232,0.960882},
{0.8721,0.956766},
{0.866174,0.956932},
{0.870323,0.953679},
{0.873609,0.944815},
{0.876875,0.948695},
{0.88445,0.943909},
{0.87777,0.936676},
{0.87116,0.936549},
{0.87617,0.932737},
{0.810134,0.910017},
{0.798966,0.905527},
{0.805805,0.911444},
{0.819744,0.914527},
{0.833257,0.924598},
{0.823026,0.944827},
{0.781669,0.897783},
{0.78511,0.894871},
{0.79387,0.899225},
{0.803505,0.902945},
{0.811717,0.906463},
{0.817014,0.907732},
{0.823566,0.91203},
{0.829853,0.914626},
{0.829227,0.918094},
{0.835915,0.921702},
{0.857359,0.928701},
{0.865995,0.935374},
{0.846259,0.954722},
{0.836605,0.950516},
{0.828601,0.95174},
{0.819263,0.948054},
{0.733805,0.878276},
{0.719575,0.869404},
{0.708033,0.865348},
{0.714184,0.866888},
{0.75624,0.885964},
{0.738107,0.877903},
{0.853938,0.958681},
{0.870313,0.939952},
{0.8325,0.9562},
{0.690676,0.853212},
{0.683889,0.852364},
{0.690852,0.857045},
{0.698617,0.85856},
{0.690142,0.867854},
{0.682874,0.864491},
{0.67979,0.859363},
{0.680107,0.855405},
{0.679534,0.85309},
{0.677908,0.878755},
{0.684367,0.878228},
{0.674408,0.871149},
{0.670092,0.871637},
{0.670306,0.867896},
{0.677925,0.863585},
{0.702314,0.885969},
{0.716982,0.895791},
{0.7086,0.8911},
{0.7068,0.8617},
{0.776319,0.890801},
{0.771971,0.890553},
{0.758032,0.889053},
{0.767255,0.888319},
{0.701667,0.858021},
{0.667433,0.869067},
{0.077198,0.756375},
{0.090347,0.771146},
{0.098537,0.755357},
{0.095854,0.743872},
{0.103537,0.739154},
{0.093081,0.725548},
{0.104067,0.727269},
{0.055926,0.781136},
{0.068465,0.791349},
{0.071768,0.781321},
{0.066124,0.77651},
{0.075702,0.773778},
{0.088,0.7833},
{0.073499,0.766123},
{0.071327,0.750508},
{0.083837,0.738138},
{0.08737,0.720382},
{0.093765,0.711188},
{0.081975,0.710792},
{0.083431,0.726582},
{0.079781,0.720221},
{0.07616,0.716372},
{0.066856,0.701844},
{0.070542,0.716989},
{0.06333,0.717847},
{0.058259,0.710347},
{0.054132,0.702883},
{0.044772,0.695292},
{0.049,0.6891},
{0.029032,0.733351},
{0.018404,0.749186},
{0.03015,0.744498},
{0.034246,0.734286},
{0.037895,0.738297},
{0.034964,0.75412},
{0.027562,0.750274},
{0.026994,0.753451},
{0.03882,0.765035},
{0.02087,0.762037},
{0.007706,0.749295},
{0.009053,0.736166},
{0.015642,0.731539},
{0.020833,0.736589},
{0.024673,0.724686},
{0.032633,0.723185},
{0.036837,0.72762},
{0.043233,0.727653},
{0.044749,0.737979},
{0.044216,0.747819},
{0.048245,0.752407},
{0.042155,0.758387},
{0.037575,0.706082},
{0.046182,0.713628},
{0.042979,0.71353},
{0.032721,0.713703},
{0.019795,0.711894},
{0.024004,0.698442},
{0.058578,0.767567},
{0.065945,0.764078},
{0.058739,0.761601},
{0.050014,0.76856},
{0.05411,0.75305},
{0.063667,0.754592},
{0.064601,0.757895},
{0.067345,0.756156},
{0.068493,0.766037},
{0.065166,0.769736},
{0.059479,0.773375},
{0.041772,0.779586},
{0.051124,0.743493},
{0.054389,0.749215},
{0.05531,0.742772},
{0.019549,0.718708},
{0.062654,0.729286},
{0.072364,0.735198},
{0.070721,0.745407},
{0.059114,0.74082},
{0.060142,0.729922},
{0.054777,0.725823},
{0.058171,0.717818},
{0.039896,0.720477},
{0.014149,0.712911},
{0.013637,0.719288},
{0.006989,0.726424},
{0.010641,0.730214},
{0.0005,0.7284},
{0.048964,0.730349},
{0.05529,0.729931},
{0.052092,0.732543},
{0.049644,0.733872},
{0.050287,0.734697},
{0.05114,0.738526},
{0.047334,0.740727},
{0.045829,0.742112},
{0.04607,0.744909},
{0.080492,0.726925},
{0.079203,0.721965},
{0.074786,0.724726},
{0.079566,0.730123},
{0.074397,0.733155},
{0.076852,0.736701},
{0.074198,0.742788},
{0.054805,0.73921},
{0.015643,0.765547},
{0.030547,0.775805},
{0.080648,0.733292},
{0.036179,0.691953},
{0.0015,0.745},
{0.332084,0.959628},
{0.324045,0.981606},
{0.33525,0.989311},
{0.347222,0.960351},
{0.33924,0.986796},
{0.337713,0.991766},
{0.343196,0.991089},
{0.340745,0.992403},
{0.354379,0.95406},
{0.349766,0.942008},
{0.338929,0.947737},
{0.340497,0.953373},
{0.331177,0.953039},
{0.328103,0.942382},
{0.333292,0.938088},
{0.336618,0.93233},
{0.34571,0.926556},
{0.357055,0.930561},
{0.363687,0.933114},
{0.366734,0.946417},
{0.368958,0.956946},
{0.353649,0.95833},
{0.33332,0.956409},
{0.325025,0.955537},
{0.324226,0.944137},
{0.308195,0.921745},
{0.319877,0.92269},
{0.334152,0.931721},
{0.335514,0.926417},
{0.393838,0.994736},
{0.412251,0.990056},
{0.390732,0.977129},
{0.385271,0.968809},
{0.388161,0.963243},
{0.399121,0.959225},
{0.407266,0.955396},
{0.419304,0.976449},
{0.425461,0.956082},
{0.431736,0.977355},
{0.44296,0.970599},
{0.4362,0.9771},
{0.353437,0.9167},
{0.3469,0.9195},
{0.354963,0.918745},
{0.361054,0.928443},
{0.364846,0.922943},
{0.370273,0.91693},
{0.371823,0.918916},
{0.368369,0.9294},
{0.373199,0.938478},
{0.373774,0.946773},
{0.376165,0.956594},
{0.382517,0.961459},
{0.374296,0.962472},
{0.360773,0.974659},
{0.352696,0.98625},
{0.324619,0.961698},
{0.319988,0.959159},
{0.318671,0.955566},
{0.318782,0.94529},
{0.305289,0.92911},
{0.304426,0.923967},
{0.302009,0.919958},
{0.309044,0.917245},
{0.322257,0.920731},
{0.332315,0.926278},
{0.425731,0.905056},
{0.419808,0.897898},
{0.420748,0.904546},
{0.433483,0.919513},
{0.42521,0.92298},
{0.411411,0.901366},
{0.415419,0.901184},
{0.41266,0.891385},
{0.418806,0.887129},
{0.425191,0.895988},
{0.433366,0.901455},
{0.434591,0.91193},
{0.442792,0.915552},
{0.442425,0.92596},
{0.43608,0.931994},
{0.441488,0.940245},
{0.427673,0.944096},
{0.419786,0.933652},
{0.420065,0.925019},
{0.412703,0.913672},
{0.407433,0.90512},
{0.404765,0.893444},
{0.403186,0.882065},
{0.406844,0.8838},
{0.40608,0.924182},
{0.409185,0.932761},
{0.414651,0.928113},
{0.410375,0.919422},
{0.416037,0.948037},
{0.404132,0.935443},
{0.399309,0.926588},
{0.394759,0.911468},
{0.403447,0.914134},
{0.404428,0.910072},
{0.452506,0.964846},
{0.456588,0.940075},
{0.4534,0.937594},
{0.449657,0.926941},
{0.4558,0.928293},
{0.463014,0.911534},
{0.454112,0.916881},
{0.466516,0.900978},
{0.472008,0.902701},
{0.470457,0.909105},
{0.475233,0.905272},
{0.4763,0.9017},
{0.472075,0.898992},
{0.317389,0.97735},
{0.421177,0.872743},
{0.417304,0.877208},
{0.431032,0.883718},
{0.427939,0.876124},
{0.425879,0.869072},
{0.418674,0.869197},
{0.418453,0.864919},
{0.415478,0.866635},
{0.414192,0.871913},
{0.413497,0.877759},
{0.41115,0.874814},
{0.407504,0.878809},
{0.406873,0.875937},
{0.4115,0.882279},
{0.416358,0.881096},
{0.428271,0.894965},
{0.431847,0.898642},
{0.431285,0.893781},
{0.436176,0.894535},
{0.398013,0.887135},
{0.397404,0.896367},
{0.39361,0.888946},
{0.388201,0.892377},
{0.390193,0.889818},
{0.38263,0.950024},
{0.378871,0.938306},
{0.385648,0.955941},
{0.385819,0.960158},
{0.385155,0.962832},
{0.382827,0.966268},
{0.379861,0.962507},
{0.383682,0.992776},
{0.371055,0.973595},
{0.360169,0.987524},
{0.400681,0.903768},
{0.452165,0.912402},
{0.45607,0.904798},
{0.447499,0.911263},
{0.445535,0.918577},
{0.4642,0.9659},
{0.463665,0.958493},
{0.386542,0.906335},
{0.387122,0.89961},
{0.37633,0.902318},
{0.377176,0.905833},
{0.371478,0.90624},
{0.366686,0.906052},
{0.358774,0.913929},
{0.358842,0.918325},
{0.363955,0.920357},
{0.371494,0.91307},
{0.375245,0.915213},
{0.37548,0.920961},
{0.37206,0.92333},
{0.376896,0.930777},
{0.380048,0.91715},
{0.382062,0.928523},
{0.383121,0.921009},
{0.38626,0.925322},
{0.390409,0.936223},
{0.384759,0.937743},
{0.375601,0.926642},
{0.395139,0.932842},
{0.392072,0.92188},
{0.392652,0.914473},
{0.396784,0.906734},
{0.380193,0.912272},
{0.388182,0.917398},
{0.385961,0.920714},
{0.375683,0.90963},
{0.392941,0.943453},
{0.392703,0.958505},
{0.384142,0.98924},
{0.382366,0.973328},
{0.399774,0.939488},
{0.406405,0.950382},
{0.392547,0.954215},
{0.399465,0.953725},
{0.300103,0.923125},
{0.31069,0.914892},
{0.369793,0.997813},
{0.439122,0.903885},
{0.315411,0.940985},
{0.829115,0.881311},
{0.814369,0.866341},
{0.808695,0.878068},
{0.828823,0.893241},
{0.817055,0.889694},
{0.797566,0.895502},
{0.7897,0.865732},
{0.805604,0.872754},
{0.812351,0.864351},
{0.812799,0.858877},
{0.815104,0.860877},
{0.821553,0.85556},
{0.832966,0.873092},
{0.848374,0.882964},
{0.848806,0.887006},
{0.845169,0.892066},
{0.858663,0.899193},
{0.862703,0.910204},
{0.831256,0.902817},
{0.8121,0.904},
{0.910804,0.831484},
{0.916858,0.842158},
{0.916441,0.827986},
{0.905259,0.81538},
{0.915604,0.818791},
{0.928898,0.8269},
{0.924127,0.838853},
{0.919988,0.855925},
{0.915137,0.853648},
{0.907662,0.833213},
{0.901272,0.81764},
{0.894417,0.810562},
{0.895936,0.805265},
{0.907015,0.805152},
{0.920852,0.812295},
{0.932816,0.816808},
{0.930739,0.852066},
{0.921296,0.860756},
{0.91299,0.864485},
{0.910816,0.85919},
{0.910325,0.851356},
{0.901515,0.832341},
{0.898145,0.823884},
{0.890529,0.814837},
{0.88466,0.802544},
{0.883443,0.793972},
{0.894477,0.799152},
{0.898235,0.794703},
{0.915435,0.80135},
{0.924816,0.800914},
{0.947981,0.816914},
{0.939673,0.835869},
{0.940935,0.85383},
{0.929244,0.86921},
{0.923429,0.871175},
{0.919684,0.869489},
{0.914419,0.870996},
{0.902488,0.878329},
{0.905212,0.866654},
{0.90267,0.856433},
{0.906874,0.84646},
{0.901784,0.837984},
{0.895507,0.833029},
{0.897217,0.827451},
{0.89007,0.822777},
{0.883588,0.816551},
{0.879042,0.807082},
{0.871792,0.802102},
{0.874143,0.796147},
{0.873532,0.7893},
{0.885404,0.785696},
{0.882591,0.776871},
{0.900956,0.782438},
{0.911369,0.789378},
{0.917175,0.787702},
{0.92598,0.787055},
{0.934652,0.787005},
{0.949708,0.786171},
{0.944511,0.773204},
{0.926346,0.746822},
{0.923032,0.772365},
{0.915866,0.759808},
{0.908231,0.755062},
{0.91398,0.737828},
{0.929633,0.739088},
{0.929109,0.722479},
{0.920006,0.720116},
{0.908784,0.730309},
{0.903402,0.720107},
{0.914052,0.708122},
{0.927816,0.707261},
{0.93288,0.712568},
{0.952295,0.829312},
{0.851204,0.7759},
{0.837038,0.784032},
{0.856296,0.784713},
{0.863731,0.772465},
{0.865581,0.783731},
{0.866247,0.793609},
{0.856673,0.795544},
{0.846282,0.787146},
{0.830883,0.791938},
{0.81254,0.778903},
{0.84355,0.766389},
{0.85802,0.755671},
{0.871353,0.761411},
{0.868191,0.803854},
{0.861991,0.803122},
{0.852546,0.805653},
{0.847415,0.804473},
{0.842083,0.801403},
{0.829612,0.810482},
{0.823588,0.800716},
{0.810858,0.797397},
{0.8036,0.78979},
{0.797081,0.790703},
{0.814644,0.770143},
{0.833986,0.758751},
{0.849231,0.750558},
{0.863296,0.748131},
{0.889272,0.763121},
{0.896339,0.776955},
{0.900443,0.776},
{0.904192,0.782775},
{0.910094,0.786272},
{0.915324,0.783729},
{0.916145,0.780533},
{0.919547,0.778275},
{0.849991,0.851419},
{0.853433,0.86009},
{0.863419,0.856679},
{0.856202,0.85034},
{0.859477,0.846942},
{0.871655,0.855255},
{0.865382,0.859659},
{0.857995,0.868052},
{0.848545,0.864094},
{0.841205,0.86128},
{0.842352,0.856014},
{0.839798,0.849892},
{0.842544,0.843519},
{0.847731,0.84249},
{0.853752,0.841415},
{0.863254,0.845862},
{0.871825,0.850692},
{0.877194,0.85418},
{0.878989,0.857421},
{0.879625,0.861924},
{0.874106,0.86313},
{0.868287,0.864531},
{0.868408,0.868402},
{0.864993,0.873642},
{0.850749,0.871668},
{0.842567,0.875088},
{0.831746,0.859719},
{0.82708,0.845213},
{0.826786,0.832585},
{0.83678,0.831968},
{0.841703,0.832506},
{0.84782,0.831424},
{0.858055,0.837896},
{0.863738,0.841357},
{0.869963,0.840962},
{0.879639,0.843163},
{0.878492,0.851911},
{0.88422,0.850882},
{0.888568,0.851397},
{0.889148,0.857531},
{0.88621,0.86442},
{0.879844,0.867508},
{0.841992,0.822829},
{0.849911,0.824813},
{0.841481,0.811393},
{0.836549,0.822418},
{0.848124,0.814837},
{0.851966,0.812927},
{0.856763,0.821547},
{0.85827,0.829265},
{0.83,0.826768},
{0.823393,0.816232},
{0.814514,0.809089},
{0.805962,0.819552},
{0.792115,0.821858},
{0.788951,0.814751},
{0.784688,0.803801},
{0.798919,0.7824},
{0.927656,0.695094},
{0.938371,0.704205},
{0.937382,0.694109},
{0.933603,0.68226},
{0.921711,0.687221},
{0.916971,0.699995},
{0.912303,0.692078},
{0.902677,0.697646},
{0.901127,0.703382},
{0.895976,0.713061},
{0.889612,0.718129},
{0.902376,0.74389},
{0.892469,0.749947},
{0.877309,0.726082},
{0.861848,0.734173},
{0.839757,0.746946},
{0.848831,0.738335},
{0.859779,0.732842},
{0.75922,0.860152},
{0.750687,0.863066},
{0.748818,0.878348},
{0.768279,0.877347},
{0.771973,0.866955},
{0.888897,0.888345},
{0.879034,0.883737},
{0.879642,0.891726},
{0.890305,0.895476},
{0.880219,0.898247},
{0.866595,0.890771},
{0.876207,0.8875},
{0.866491,0.884217},
{0.865564,0.878565},
{0.870314,0.875655},
{0.879208,0.878534},
{0.882842,0.876237},
{0.890669,0.875431},
{0.891648,0.880306},
{0.894152,0.886258},
{0.896659,0.89365},
{0.896267,0.899612},
{0.878837,0.902957},
{0.867926,0.896456},
{0.858536,0.889849},
{0.86051,0.811506},
{0.866035,0.82161},
{0.866039,0.811289},
{0.872527,0.808731},
{0.869514,0.812727},
{0.87255,0.818167},
{0.872336,0.823691},
{0.866934,0.829601},
{0.897478,0.762216},
{0.895161,0.770617},
{0.902652,0.765451},
{0.905427,0.773071},
{0.907109,0.781476},
{0.907889,0.777009},
{0.912362,0.776435},
{0.917153,0.774198},
{0.919697,0.773224},
{0.916277,0.767642},
{0.908634,0.761472},
{0.908241,0.758024},
{0.903813,0.756481},
{0.8403,0.9154},
{0.880433,0.824551},
{0.880678,0.830804},
{0.88477,0.824267},
{0.888034,0.833827},
{0.885501,0.833791},
{0.88253,0.838435},
{0.875801,0.833581},
{0.866745,0.832196},
{0.862872,0.834389},
{0.765268,0.849009},
{0.77883,0.834344},
{0.773898,0.825195},
{0.767755,0.83738},
{0.757674,0.853575},
{0.750847,0.859468},
{0.744423,0.864532},
{0.745886,0.868922},
{0.908444,0.88997},
{0.912149,0.893616},
{0.918566,0.879548},
{0.920322,0.88622},
{0.930594,0.875106},
{0.940081,0.873756},
{0.913895,0.902879},
{0.884354,0.912685},
{0.854628,0.879333},
{0.814539,0.834763},
{0.816548,0.816575},
{0.871761,0.872214},
{0.879601,0.873627},
{0.889364,0.865921},
{0.891918,0.866716},
{0.896132,0.868288},
{0.900045,0.868443},
{0.89788,0.873751},
{0.898153,0.879537},
{0.901166,0.885266},
{0.902349,0.889107},
{0.90791,0.878894},
{0.7957,0.832428},
{0.78994,0.847158},
{0.784264,0.843522},
{0.799052,0.863398},
{0.795831,0.857398},
{0.794639,0.86448},
{0.803126,0.868256},
{0.789664,0.855918},
{0.79098,0.851319},
{0.800249,0.854336},
{0.7995,0.85878},
{0.802745,0.860935},
{0.806846,0.865526},
{0.810451,0.859938},
{0.807446,0.852884},
{0.81098,0.85264},
{0.811423,0.849623},
{0.805911,0.843857},
{0.800454,0.843093},
{0.796273,0.842705},
{0.784682,0.859293},
{0.769598,0.855665},
{0.783035,0.85295},
{0.904788,0.761353},
{0.803246,0.847963},
{0.806193,0.849591},
{0.795948,0.848701},
{0.892551,0.859479},
{0.87618,0.837963},
{0.876223,0.841218},
{0.909058,0.76854},
{0.909265,0.773974},
{0.877766,0.816407},
{0.897646,0.848914},
{0.893544,0.855333},
{0.911651,0.771498},
{0.916131,0.770245},
{0.819191,0.760372},
{0.91614,0.772084},
{0.897639,0.861002},
{0.90098,0.870592},
{0.804671,0.858992},
{0.9173,0.6874},
{0.919204,0.683313},
{0.708992,0.053265},
{0.709,0.0522},
{0.708248,0.052167},
{0.701413,0.056952},
{0.703305,0.04922},
{0.722849,0.042808},
{0.709051,0.052164},
{0.725206,0.048864},
{0.70411,0.060219},
{0.703084,0.065726},
{0.698694,0.061104},
{0.694661,0.057483},
{0.69366,0.051055},
{0.698875,0.050724},
{0.697992,0.0447},
{0.720674,0.036393},
{0.721192,0.032203},
{0.733053,0.042053},
{0.728934,0.046966},
{0.727858,0.053124},
{0.717113,0.065957},
{0.713019,0.069986},
{0.705938,0.072728},
{0.699194,0.07655},
{0.694874,0.069621},
{0.692982,0.066553},
{0.694706,0.063217},
{0.694781,0.062317},
{0.688559,0.059417},
{0.689731,0.054059},
{0.692867,0.045323},
{0.696268,0.036973},
{0.699921,0.036834},
{0.708831,0.02445},
{0.722769,0.026377},
{0.729678,0.022904},
{0.755506,0.027606},
{0.758717,0.049545},
{0.73459,0.050095},
{0.733627,0.058421},
{0.732807,0.077123},
{0.718158,0.072661},
{0.719145,0.083781},
{0.713009,0.077049},
{0.710095,0.07785},
{0.705368,0.079681},
{0.704966,0.083338},
{0.690945,0.088186},
{0.689925,0.077201},
{0.691382,0.071007},
{0.687583,0.07161},
{0.687899,0.065388},
{0.694715,0.063178},
{0.698736,0.095947},
{0.697169,0.117545},
{0.700847,0.13752},
{0.70352,0.103669},
{0.705217,0.137234},
{0.701246,0.154793},
{0.692558,0.15467},
{0.692328,0.135887},
{0.683681,0.120291},
{0.685151,0.095507},
{0.704707,0.085909},
{0.706917,0.086852},
{0.709394,0.084642},
{0.712089,0.106948},
{0.712187,0.129125},
{0.712882,0.147274},
{0.714578,0.16197},
{0.706275,0.168124},
{0.697889,0.166159},
{0.687403,0.163196},
{0.684841,0.146238},
{0.676598,0.131512},
{0.67639,0.109652},
{0.681195,0.103284},
{0.682392,0.090043},
{0.686283,0.08893},
{0.682944,0.083744},
{0.794585,0.045493},
{0.782794,0.03209},
{0.766695,0.053184},
{0.743659,0.058986},
{0.745043,0.077329},
{0.743247,0.082153},
{0.730055,0.079428},
{0.724235,0.083228},
{0.725056,0.10081},
{0.71395,0.09065},
{0.712998,0.083626},
{0.885813,0.085203},
{0.889025,0.112907},
{0.905843,0.083077},
{0.900378,0.060752},
{0.904204,0.053968},
{0.910775,0.081994},
{0.915166,0.100627},
{0.911717,0.127464},
{0.892211,0.133584},
{0.872694,0.146811},
{0.869602,0.115879},
{0.852497,0.105714},
{0.870918,0.058581},
{0.889786,0.055764},
{0.899412,0.052598},
{0.902575,0.049613},
{0.907961,0.049852},
{0.922058,0.074164},
{0.92658,0.140352},
{0.92087,0.160588},
{0.910282,0.154857},
{0.890111,0.157716},
{0.87503,0.201248},
{0.854999,0.197926},
{0.853493,0.16335},
{0.834402,0.146386},
{0.83084,0.083204},
{0.842325,0.06837},
{0.860368,0.06109},
{0.877589,0.055437},
{0.882775,0.052734},
{0.892974,0.049658},
{0.898413,0.047797},
{0.902682,0.044496},
{0.905933,0.045097},
{0.908907,0.045015},
{0.914698,0.04702},
{0.92325,0.052404},
{0.936013,0.075223},
{0.936529,0.145816},
{0.931444,0.159966},
{0.92632,0.181603},
{0.900537,0.192677},
{0.90154,0.173941},
{0.878065,0.222729},
{0.866806,0.245455},
{0.835742,0.248879},
{0.819001,0.22028},
{0.827677,0.197366},
{0.840433,0.191646},
{0.821166,0.170105},
{0.820821,0.121691},
{0.829538,0.113647},
{0.825354,0.068131},
{0.835397,0.063008},
{0.853565,0.060258},
{0.854221,0.061662},
{0.860959,0.058563},
{0.858421,0.03952},
{0.881477,0.032064},
{0.88648,0.030195},
{0.894977,0.027005},
{0.904157,0.021024},
{0.775644,0.075046},
{0.763516,0.076239},
{0.77366,0.078589},
{0.758852,0.081118},
{0.759324,0.058186},
{0.733539,0.117388},
{0.749556,0.108324},
{0.746154,0.087188},
{0.753066,0.085688},
{0.766059,0.123144},
{0.741871,0.133471},
{0.721083,0.149072},
{0.78473,0.340129},
{0.798816,0.273524},
{0.776641,0.227876},
{0.770124,0.245913},
{0.766307,0.218876},
{0.773976,0.19635},
{0.792869,0.186178},
{0.798126,0.226524},
{0.818318,0.266942},
{0.793248,0.320826},
{0.79471,0.357936},
{0.786409,0.368019},
{0.774822,0.322933},
{0.760942,0.303196},
{0.761788,0.253885},
{0.756676,0.224219},
{0.761419,0.190836},
{0.765384,0.152034},
{0.777149,0.139068},
{0.796791,0.136985},
{0.804239,0.181981},
{0.799994,0.372924},
{0.814493,0.418927},
{0.820848,0.399976},
{0.820105,0.374897},
{0.834912,0.38436},
{0.828461,0.412537},
{0.830937,0.426987},
{0.810858,0.43498},
{0.789351,0.42821},
{0.791954,0.404977},
{0.815666,0.35809},
{0.827081,0.346178},
{0.836162,0.343402},
{0.839482,0.367297},
{0.84865,0.375025},
{0.842728,0.392023},
{0.838522,0.410046},
{0.831532,0.443918},
{0.820777,0.441172},
{0.807481,0.457922},
{0.785252,0.45426},
{0.788498,0.441291},
{0.775173,0.435153},
{0.781515,0.407736},
{0.772005,0.388076},
{0.773351,0.371676},
{0.761115,0.341048},
{0.748932,0.335474},
{0.74552,0.301826},
{0.74724,0.273129},
{0.741467,0.236606},
{0.746022,0.19456},
{0.750367,0.178594},
{0.752931,0.154062},
{0.791251,0.091054},
{0.805214,0.100713},
{0.809447,0.14856},
{0.814258,0.073611},
{0.819259,0.071941},
{0.81328,0.070277},
{0.825939,0.064966},
{0.825514,0.062423},
{0.830242,0.041406},
{0.887509,0.338678},
{0.904729,0.336977},
{0.906634,0.308836},
{0.892533,0.317098},
{0.893693,0.295927},
{0.915161,0.265269},
{0.920286,0.304028},
{0.915469,0.336672},
{0.899632,0.357746},
{0.882635,0.361614},
{0.878244,0.316006},
{0.880204,0.277101},
{0.89818,0.244786},
{0.907124,0.250412},
{0.922568,0.234346},
{0.930837,0.241097},
{0.929014,0.266004},
{0.922628,0.265915},
{0.92811,0.306143},
{0.924072,0.343499},
{0.913293,0.363706},
{0.900865,0.374422},
{0.88639,0.373409},
{0.880207,0.396629},
{0.870287,0.372891},
{0.868131,0.334598},
{0.869471,0.303968},
{0.889864,0.225466},
{0.904681,0.216511},
{0.914254,0.222792},
{0.923227,0.219825},
{0.936817,0.225991},
{0.946564,0.226227},
{0.944944,0.2397},
{0.936933,0.262158},
{0.939579,0.29367},
{0.937284,0.302603},
{0.888347,0.409683},
{0.901395,0.406712},
{0.910971,0.400047},
{0.919342,0.411574},
{0.914774,0.429219},
{0.907121,0.42939},
{0.899657,0.432857},
{0.890067,0.433052},
{0.877254,0.414477},
{0.726576,0.16973},
{0.757885,0.454067},
{0.755793,0.435177},
{0.756016,0.411287},
{0.77338,0.418424},
{0.759064,0.371958},
{0.748874,0.368828},
{0.744789,0.336345},
{0.736236,0.316369},
{0.733227,0.304502},
{0.73059,0.273013},
{0.719658,0.241274},
{0.726792,0.230775},
{0.726679,0.202185},
{0.722385,0.193332},
{0.7298,0.184201},
{0.712607,0.19485},
{0.70331,0.188169},
{0.693681,0.180498},
{0.691222,0.173746},
{0.684647,0.166395},
{0.677769,0.061114},
{0.679688,0.077984},
{0.670713,0.074117},
{0.667999,0.072488},
{0.661701,0.064928},
{0.671975,0.05748},
{0.844844,0.322994},
{0.855962,0.338515},
{0.856191,0.315541},
{0.843752,0.3034},
{0.839998,0.271445},
{0.853014,0.252754},
{0.862396,0.283124},
{0.865156,0.370928},
{0.858004,0.364606},
{0.845875,0.35407},
{0.835113,0.3133},
{0.828965,0.274835},
{0.94093,0.091248},
{0.942383,0.053107},
{0.929662,0.048119},
{0.942213,0.041185},
{0.947529,0.041227},
{0.95625,0.079637},
{0.950667,0.090759},
{0.946918,0.105964},
{0.943924,0.149751},
{0.926189,0.019539},
{0.931586,0.008421},
{0.913588,0.023012},
{0.917005,0.043861},
{0.924404,0.046095},
{0.942775,0.2716},
{0.9423,0.26448},
{0.943696,0.255105},
{0.927816,0.476198},
{0.929148,0.472627},
{0.916227,0.467084},
{0.919363,0.460167},
{0.904345,0.463524},
{0.912783,0.450512},
{0.924784,0.454468},
{0.940197,0.464253},
{0.9456,0.462659},
{0.943217,0.456609},
{0.9483,0.4631},
{0.896127,0.444709},
{0.881677,0.445751},
{0.89102,0.448677},
{0.891244,0.462817},
{0.880323,0.462867},
{0.87619,0.449169},
{0.865745,0.448503},
{0.879194,0.439508},
{0.916035,0.440629},
{0.915594,0.449217},
{0.930314,0.453052},
{0.952307,0.448666},
{0.93938,0.442904},
{0.980656,0.422802},
{0.98723,0.429775},
{0.991859,0.438669},
{0.9724,0.4489},
{0.848762,0.396588},
{0.84615,0.424666},
{0.857504,0.425447},
{0.865282,0.415463},
{0.869373,0.430383},
{0.849033,0.436988},
{0.855886,0.384198},
{0.865715,0.440202},
{0.843932,0.448589},
{0.828393,0.451689},
{0.800014,0.468496},
{0.776191,0.463066},
{0.75535,0.464408},
{0.754305,0.455544},
{0.751967,0.440832},
{0.752422,0.425641},
{0.749664,0.406917},
{0.750959,0.393629},
{0.747813,0.386221},
{0.964732,0.130358},
{0.959023,0.153263},
{0.94784,0.169048},
{0.876595,0.020517},
{0.850411,0.027982},
{0.892398,0.023119},
{0.894433,0.002505},
{0.9042,0.0005},
{0.817091,0.039743},
{0.815268,0.065447},
{0.816624,0.036005},
{0.830606,0.038039},
{0.83565,0.038725},
{0.855504,0.036377},
{0.828088,0.030636},
{0.832651,0.01648},
{0.848167,0.016962},
{0.858087,0.018458},
{0.871703,0.015351},
{0.877939,0.011622},
{0.889573,0.005963},
{0.91523,0.191352},
{0.93599,0.195528},
{0.933784,0.21165},
{0.946694,0.219914},
{0.943657,0.201274},
{0.948083,0.212784},
{0.946254,0.20397},
{0.9474,0.1993},
{0.950611,0.193045},
{0.942838,0.186555},
{0.950247,0.187275},
{0.954446,0.174149},
{0.953606,0.183974},
{0.710459,0.204945},
{0.708034,0.221848},
{0.713015,0.233428},
{0.71825,0.226907},
{0.710647,0.236588},
{0.709561,0.240874},
{0.716209,0.256381},
{0.703913,0.245014},
{0.708103,0.240586},
{0.942189,0.365927},
{0.932818,0.329968},
{0.933872,0.314587},
{0.947581,0.341453},
{0.95359,0.357309},
{0.95287,0.387868},
{0.944335,0.377855},
{0.92339,0.372944},
{0.941556,0.034595},
{0.928969,0.041492},
{0.943758,0.037732},
{0.920374,0.024216},
{0.669729,0.119274},
{0.667348,0.105705},
{0.656599,0.115464},
{0.654535,0.111698},
{0.666659,0.090562},
{0.674567,0.090507},
{0.820412,0.018881},
{0.806291,0.021672},
{0.811936,0.016373},
{0.81876,0.012415},
{0.823475,0.012554},
{0.829304,0.012031},
{0.83406,0.013361},
{0.840121,0.014784},
{0.804145,0.043721},
{0.802038,0.068289},
{0.78377,0.050192},
{0.786045,0.072433},
{0.787677,0.077027},
{0.762125,0.083721},
{0.720104,0.282921},
{0.723506,0.287692},
{0.726332,0.297193},
{0.72194,0.294522},
{0.719655,0.290194},
{0.712896,0.286572},
{0.711375,0.284688},
{0.715531,0.276258},
{0.722071,0.268477},
{0.704063,0.263984},
{0.969054,0.070691},
{0.960395,0.050986},
{0.803009,0.077207},
{0.930424,0.402384},
{0.919478,0.399099},
{0.937869,0.422168},
{0.941851,0.435506},
{0.914599,0.475963},
{0.921049,0.4724},
{0.910545,0.468102},
{0.901684,0.465793},
{0.663717,0.069975},
{0.659014,0.070794},
{0.663015,0.083595},
{0.667876,0.078097},
{0.671104,0.084974},
{0.659682,0.088322},
{0.651959,0.108287},
{0.651142,0.113947},
{0.649503,0.110578},
{0.6471,0.1136},
{0.648423,0.117851},
{0.65178,0.119452},
{0.659679,0.120593},
{0.667867,0.123637},
{0.666276,0.126273},
{0.662527,0.12634},
{0.666493,0.130926},
{0.664988,0.133961},
{0.671982,0.138777},
{0.6649,0.1411},
{0.944894,0.321489},
{0.705097,0.210123},
{0.705553,0.216665},
{0.703525,0.201992},
{0.953515,0.408776},
{0.974369,0.415026},
{0.973766,0.401826},
{0.960842,0.386705},
{0.965555,0.373433},
{0.970845,0.385371},
{0.976679,0.40282},
{0.982624,0.418294},
{0.959111,0.351174},
{0.966587,0.364695},
{0.805078,0.320805},
{0.822657,0.309596},
{0.973748,0.09967},
{0.957222,0.116794},
{0.975897,0.122243},
{0.973036,0.131223},
{0.9725,0.1406},
{0.843929,0.473669},
{0.82602,0.480503},
{0.840684,0.479013},
{0.848881,0.475074},
{0.844672,0.480156},
{0.834177,0.484449},
{0.948471,0.321178},
{0.950754,0.309968},
{0.953552,0.318713},
{0.957257,0.326611},
{0.955398,0.340284},
{0.8915,0.465334},
{0.893179,0.468189},
{0.904559,0.469368},
{0.849231,0.452416},
{0.839057,0.457326},
{0.832333,0.45778},
{0.814367,0.466826},
{0.795786,0.477697},
{0.773987,0.472487},
{0.758622,0.471258},
{0.754956,0.473054},
{0.7577,0.4757},
{0.859721,0.45291},
{0.870005,0.464316},
{0.861407,0.466228},
{0.853345,0.469541},
{0.84457,0.456802},
{0.829457,0.462342},
{0.820263,0.47036},
{0.810389,0.48122},
{0.836953,0.489026},
{0.84429,0.484308},
{0.836,0.4945},
{0.962832,0.34595},
{0.883695,0.468299},
{0.879294,0.465533},
{0.802777,0.070958},
{0.680114,0.149792},
{0.868999,0.467245},
{0.861374,0.473868},
{0.873198,0.47074},
{0.877857,0.472983},
{0.856719,0.471295},
{0.695828,0.186544},
{0.814287,0.48056},
{0.815596,0.485385},
{0.823544,0.470786},
{0.690945,0.042303},
{0.685284,0.046855},
{0.68787,0.049738},
{0.675277,0.077406},
{0.673618,0.081512},
{0.671651,0.090079},
{0.767629,0.029905},
{0.774929,0.028718},
{0.783985,0.02869},
{0.790589,0.02916},
{0.956437,0.165345},
{0.7169,0.0142},
{0.930225,0.014492},
{0.945082,0.286816},
{0.949507,0.302083},
{0.9533,0.3136},
{0.71021,0.231123},
{0.823476,0.009448},
{0.678625,0.089551},
{0.864529,0.013693},
{0.7424,0.3381},
{0.741906,0.342503},
{0.742564,0.349321},
{0.744294,0.358742},
{0.750039,0.427248},
{0.7281,0.3005},
{0.699708,0.28869},
{0.703472,0.289398},
{0.697709,0.282564},
{0.828396,0.49101},
{0.737647,0.324217},
{0.7399,0.3321},
{0.697935,0.033261},
{0.675698,0.150832},
{0.734046,0.313324},
{0.850106,0.479308},
{0.9771,0.128},
{0.6988,0.195},
{0.250623,0.534407},
{0.240038,0.553486},
{0.257869,0.546391},
{0.251638,0.522294},
{0.263358,0.530227},
{0.266768,0.549383},
{0.257528,0.558803},
{0.246971,0.569205},
{0.23404,0.573495},
{0.228664,0.567672},
{0.22092,0.549422},
{0.235134,0.527742},
{0.242938,0.520923},
{0.251744,0.515255},
{0.260307,0.51024},
{0.263829,0.51432},
{0.261012,0.524597},
{0.26983,0.521964},
{0.276619,0.544761},
{0.279061,0.558623},
{0.262988,0.561612},
{0.260466,0.566583},
{0.2661,0.576125},
{0.252678,0.580239},
{0.243123,0.577971},
{0.229999,0.579963},
{0.217817,0.57575},
{0.211491,0.557178},
{0.208453,0.541926},
{0.225876,0.532964},
{0.223739,0.518538},
{0.238798,0.507236},
{0.256659,0.506141},
{0.258952,0.500827},
{0.281529,0.505947},
{0.150419,0.581921},
{0.132208,0.586305},
{0.136967,0.594834},
{0.151851,0.596375},
{0.1365,0.607196},
{0.132229,0.600249},
{0.129034,0.586097},
{0.129447,0.578712},
{0.1376,0.573135},
{0.155595,0.571812},
{0.168368,0.571309},
{0.165057,0.584751},
{0.150513,0.616078},
{0.134496,0.611849},
{0.132376,0.608425},
{0.248614,0.622579},
{0.259528,0.650707},
{0.271224,0.615267},
{0.269464,0.602087},
{0.273995,0.591515},
{0.281567,0.579548},
{0.282127,0.604857},
{0.2791,0.6238},
{0.274366,0.634467},
{0.182176,0.645896},
{0.200144,0.668424},
{0.195846,0.627968},
{0.176854,0.631447},
{0.193365,0.605556},
{0.208529,0.625166},
{0.202107,0.643279},
{0.207364,0.661519},
{0.213548,0.687614},
{0.211314,0.707464},
{0.196029,0.686466},
{0.192456,0.672484},
{0.181195,0.657409},
{0.171025,0.64373},
{0.169874,0.622612},
{0.185865,0.579345},
{0.188788,0.592728},
{0.203044,0.603763},
{0.21116,0.607961},
{0.226271,0.650737},
{0.220768,0.671954},
{0.258519,0.471129},
{0.253846,0.482245},
{0.270157,0.485881},
{0.269057,0.463673},
{0.279841,0.469272},
{0.280307,0.486046},
{0.286547,0.499397},
{0.264127,0.496468},
{0.253384,0.494757},
{0.243531,0.482896},
{0.25514,0.462792},
{0.237601,0.470091},
{0.244923,0.454988},
{0.233616,0.462277},
{0.217448,0.475659},
{0.219605,0.454791},
{0.211575,0.469017},
{0.211036,0.450844},
{0.200818,0.477074},
{0.20024,0.455031},
{0.193943,0.491541},
{0.190462,0.466223},
{0.196805,0.44774},
{0.284995,0.545023},
{0.294095,0.529533},
{0.277783,0.521288},
{0.285502,0.511855},
{0.290905,0.505501},
{0.297905,0.516584},
{0.299492,0.522541},
{0.301564,0.528925},
{0.193385,0.560763},
{0.187644,0.555224},
{0.202071,0.530564},
{0.209598,0.520318},
{0.219685,0.506003},
{0.235427,0.491664},
{0.285983,0.47855},
{0.303959,0.48955},
{0.302464,0.496822},
{0.296895,0.508433},
{0.166933,0.6047},
{0.149568,0.631572},
{0.1773,0.573769},
{0.200385,0.575555},
{0.200802,0.582937},
{0.210454,0.586549},
{0.214119,0.591351},
{0.220313,0.59873},
{0.226889,0.611614},
{0.228054,0.627856},
{0.237074,0.649749},
{0.242248,0.685607},
{0.232867,0.694594},
{0.22221,0.698094},
{0.170392,0.722947},
{0.189525,0.719213},
{0.176399,0.711366},
{0.161358,0.691014},
{0.173681,0.695079},
{0.185214,0.695387},
{0.202575,0.718134},
{0.197986,0.734295},
{0.181715,0.734384},
{0.170558,0.732049},
{0.159684,0.717878},
{0.153057,0.699908},
{0.144148,0.681117},
{0.160417,0.67637},
{0.169433,0.675531},
{0.182237,0.678326},
{0.207723,0.729863},
{0.203159,0.738951},
{0.195229,0.741122},
{0.186934,0.739369},
{0.181145,0.740553},
{0.168887,0.734343},
{0.157038,0.719227},
{0.148337,0.699667},
{0.204008,0.492359},
{0.207765,0.508487},
{0.215312,0.487554},
{0.186832,0.533347},
{0.184139,0.524998},
{0.185894,0.500989},
{0.187525,0.486125},
{0.181055,0.47801},
{0.183912,0.455747},
{0.174128,0.468334},
{0.179577,0.45712},
{0.182692,0.450422},
{0.262943,0.662273},
{0.252442,0.669087},
{0.24967,0.636305},
{0.237318,0.612413},
{0.242265,0.60704},
{0.251462,0.6036},
{0.251158,0.592885},
{0.265503,0.586282},
{0.274517,0.574258},
{0.281527,0.568139},
{0.276178,0.566396},
{0.287728,0.560884},
{0.290459,0.564453},
{0.293027,0.558821},
{0.294122,0.544781},
{0.141886,0.663104},
{0.156955,0.66514},
{0.166027,0.664961},
{0.162635,0.657962},
{0.212736,0.581563},
{0.219927,0.586091},
{0.170825,0.476491},
{0.169607,0.5052},
{0.163921,0.491858},
{0.166458,0.485871},
{0.164713,0.475278},
{0.160769,0.48651},
{0.159958,0.49627},
{0.155497,0.503798},
{0.149943,0.51126},
{0.160018,0.525508},
{0.146055,0.517912},
{0.152906,0.533508},
{0.142703,0.531261},
{0.14321,0.521697},
{0.15892,0.562344},
{0.147225,0.552385},
{0.136296,0.562759},
{0.146243,0.567943},
{0.138254,0.567324},
{0.130217,0.560643},
{0.132776,0.552267},
{0.137005,0.545084},
{0.16133,0.543506},
{0.16952,0.557355},
{0.171269,0.533757},
{0.17584,0.548655},
{0.179203,0.514396},
{0.303753,0.484636},
{0.302479,0.474872},
{0.294436,0.470389},
{0.229932,0.602219},
{0.236445,0.628995},
{0.248968,0.691655},
{0.23642,0.709269},
{0.225923,0.720696},
{0.134468,0.619658},
{0.241162,0.58727},
{0.227026,0.587649},
{0.139146,0.53515},
{0.133527,0.543204},
{0.13908,0.638049},
{0.145164,0.651154},
{0.156349,0.650991},
{0.15193,0.65689},
{0.139592,0.654272},
{0.139889,0.649932},
{0.139118,0.646148},
{0.240032,0.594233},
{0.228835,0.596835},
{0.2847,0.5963},
{0.2892,0.585084},
{0.28654,0.578737},
{0.259953,0.682842},
{0.233094,0.718329},
{0.1706,0.465372},
{0.215581,0.727707},
{0.223244,0.728479},
{0.2179,0.7319},
{0.263278,0.676271},
{0.267524,0.664664},
{0.267925,0.659555},
{0.252834,0.693756},
{0.187577,0.237991},
{0.20173,0.258816},
{0.192825,0.231545},
{0.178581,0.2116},
{0.19446,0.21523},
{0.203207,0.226369},
{0.219136,0.26813},
{0.207725,0.282304},
{0.196636,0.290947},
{0.181521,0.266793},
{0.17517,0.243761},
{0.176641,0.230239},
{0.169157,0.210617},
{0.173547,0.192705},
{0.179112,0.201727},
{0.189759,0.198043},
{0.211787,0.1982},
{0.216127,0.213725},
{0.222795,0.225539},
{0.230585,0.234025},
{0.236674,0.241624},
{0.238664,0.258569},
{0.232101,0.29035},
{0.231278,0.3011},
{0.224777,0.313731},
{0.215494,0.310954},
{0.208523,0.309799},
{0.190124,0.290262},
{0.180567,0.275075},
{0.169869,0.257516},
{0.163096,0.245489},
{0.158704,0.237246},
{0.164091,0.227492},
{0.148989,0.199905},
{0.140776,0.181091},
{0.137073,0.185762},
{0.141977,0.204304},
{0.133758,0.189699},
{0.294669,0.153363},
{0.298461,0.145306},
{0.291204,0.145472},
{0.284573,0.146647},
{0.289718,0.140211},
{0.297065,0.132621},
{0.306682,0.138197},
{0.307524,0.14766},
{0.30683,0.15218},
{0.304574,0.15509},
{0.300944,0.159376},
{0.280373,0.15887},
{0.269385,0.149782},
{0.271506,0.14259},
{0.278068,0.140448},
{0.286276,0.135557},
{0.287677,0.129629},
{0.295934,0.121123},
{0.299468,0.126648},
{0.310413,0.137654},
{0.31089,0.146593},
{0.313726,0.150516},
{0.312633,0.155893},
{0.309057,0.161929},
{0.307198,0.167131},
{0.299898,0.164261},
{0.276175,0.163205},
{0.265726,0.155992},
{0.25634,0.153219},
{0.261336,0.145763},
{0.267712,0.134213},
{0.2833,0.12517},
{0.267657,0.192958},
{0.267265,0.207577},
{0.283322,0.208095},
{0.292757,0.202629},
{0.299724,0.211971},
{0.297902,0.219872},
{0.282609,0.226407},
{0.276813,0.24643},
{0.268105,0.229077},
{0.258916,0.219058},
{0.251375,0.196349},
{0.249118,0.175062},
{0.268789,0.181562},
{0.283898,0.18254},
{0.30172,0.1866},
{0.3005,0.204883},
{0.128565,0.103502},
{0.139135,0.099876},
{0.13257,0.086625},
{0.130209,0.093715},
{0.241577,0.125368},
{0.219208,0.126306},
{0.236833,0.139772},
{0.246753,0.13921},
{0.248702,0.152947},
{0.236868,0.145352},
{0.224788,0.139643},
{0.22001,0.134539},
{0.205021,0.12541},
{0.206696,0.117019},
{0.222867,0.116495},
{0.226061,0.090933},
{0.235956,0.098461},
{0.246271,0.119908},
{0.260917,0.125947},
{0.25341,0.144957},
{0.255343,0.164678},
{0.242832,0.157035},
{0.221149,0.150351},
{0.211707,0.134809},
{0.2054,0.13985},
{0.197208,0.127141},
{0.195471,0.117622},
{0.195234,0.108709},
{0.197942,0.102353},
{0.2085,0.105824},
{0.214637,0.095031},
{0.223863,0.074033},
{0.233863,0.084311},
{0.245995,0.083131},
{0.246491,0.105811},
{0.254853,0.103876},
{0.267879,0.106968},
{0.269064,0.123189},
{0.129939,0.057053},
{0.14422,0.062949},
{0.132603,0.050034},
{0.126958,0.052135},
{0.128238,0.047916},
{0.133333,0.046167},
{0.1381,0.042401},
{0.152684,0.063699},
{0.138904,0.075987},
{0.139074,0.06932},
{0.128806,0.066202},
{0.124127,0.056436},
{0.138451,0.145985},
{0.147777,0.146539},
{0.149588,0.132353},
{0.130023,0.133572},
{0.132512,0.12385},
{0.147977,0.119499},
{0.156466,0.127043},
{0.169231,0.138203},
{0.155683,0.157093},
{0.139329,0.161878},
{0.133865,0.164223},
{0.123848,0.14839},
{0.131218,0.141735},
{0.24243,0.308822},
{0.247474,0.318949},
{0.26348,0.291666},
{0.25244,0.293301},
{0.261398,0.280797},
{0.272975,0.266727},
{0.282547,0.287182},
{0.271736,0.310016},
{0.260133,0.323685},
{0.253511,0.327557},
{0.243657,0.326445},
{0.233863,0.322503},
{0.234286,0.317042},
{0.241808,0.291505},
{0.253595,0.275009},
{0.261154,0.269081},
{0.276228,0.254068},
{0.290122,0.257381},
{0.287082,0.269739},
{0.292667,0.275131},
{0.284479,0.294568},
{0.276965,0.310633},
{0.267344,0.320585},
{0.263046,0.326525},
{0.162051,0.178352},
{0.176506,0.174687},
{0.16367,0.172159},
{0.166055,0.160883},
{0.191168,0.171931},
{0.181713,0.184094},
{0.190378,0.185424},
{0.215546,0.17663},
{0.205113,0.188533},
{0.219433,0.184452},
{0.230005,0.185977},
{0.234197,0.200079},
{0.242815,0.204608},
{0.251499,0.227083},
{0.25104,0.237986},
{0.261133,0.251585},
{0.243201,0.278463},
{0.221732,0.320167},
{0.287076,0.248802},
{0.286769,0.241878},
{0.272133,0.251768},
{0.27013,0.241507},
{0.243945,0.192877},
{0.27029,0.172263},
{0.287121,0.17703},
{0.303829,0.180131},
{0.304323,0.172419},
{0.307332,0.172346},
{0.284854,0.169921},
{0.264798,0.163003},
{0.179787,0.130809},
{0.178163,0.119382},
{0.169502,0.121027},
{0.160725,0.113373},
{0.171213,0.105872},
{0.181338,0.108752},
{0.193656,0.147875},
{0.181613,0.144944},
{0.17247,0.149617},
{0.154626,0.170745},
{0.139381,0.170735},
{0.1342,0.1701},
{0.130537,0.165923},
{0.223869,0.04009},
{0.215883,0.053587},
{0.224044,0.050266},
{0.233503,0.048471},
{0.231675,0.060866},
{0.234644,0.076227},
{0.214581,0.074583},
{0.200799,0.051464},
{0.202163,0.033412},
{0.215043,0.029821},
{0.2235,0.0318},
{0.226994,0.035233},
{0.185368,0.094424},
{0.194191,0.079967},
{0.189117,0.087338},
{0.186415,0.079432},
{0.170121,0.070729},
{0.180012,0.068837},
{0.188984,0.05424},
{0.169914,0.085471},
{0.169299,0.076502},
{0.157721,0.086262},
{0.161151,0.075945},
{0.20031,0.176203},
{0.212965,0.167934},
{0.200877,0.164759},
{0.192824,0.159337},
{0.202882,0.157714},
{0.214582,0.157157},
{0.226933,0.161129},
{0.228079,0.173289},
{0.286018,0.104571},
{0.240916,0.070589},
{0.242933,0.058715},
{0.238532,0.05314},
{0.128371,0.071254},
{0.130752,0.07919},
{0.130458,0.083581},
{0.141354,0.087058},
{0.147581,0.102436},
{0.139223,0.106517},
{0.1287,0.10734},
{0.178506,0.10008},
{0.1489,0.077525},
{0.153685,0.09137},
{0.154384,0.096212},
{0.161026,0.104088},
{0.148417,0.11014},
{0.133381,0.11551},
{0.1298,0.1115},
{0.162059,0.199049},
{0.152522,0.187652},
{0.250686,0.075558},
{0.249224,0.062725},
{0.268145,0.078106},
{0.262261,0.074839},
{0.254014,0.067622},
{0.165529,0.098529},
{0.29779,0.23993},
{0.29633,0.22854},
{0.294416,0.236684},
{0.290075,0.228864},
{0.168865,0.061891},
{0.162376,0.061841},
{0.159942,0.045045},
{0.17515,0.052287},
{0.1896,0.031616},
{0.189475,0.016691},
{0.196058,0.015477},
{0.206232,0.022427},
{0.212593,0.022144},
{0.178972,0.158315},
{0.296305,0.253411},
{0.285448,0.094013},
{0.27938,0.093472},
{0.268702,0.090691},
{0.277812,0.089506},
{0.281,0.0921},
{0.159159,0.241564},
{0.16272,0.253699},
{0.1294,0.1194},
{0.152303,0.218838},
{0.147272,0.209396},
{0.313559,0.142012},
{0.294126,0.242462},
{0.271602,0.083465},
{0.165836,0.029238},
{0.156087,0.031113},
{0.154751,0.033654},
{0.145082,0.039589},
{0.145218,0.035513},
{0.188062,0.019106},
{0.182151,0.021882},
{0.184024,0.016491},
{0.171833,0.025023},
{0.173925,0.018847},
{0.1772,0.0176},
{0.2889,0.0953},
{0.289825,0.097613},
{0.204558,0.149926},
{0.264,0.255591},
{0.1285,0.1254},
{0.3042,0.1248},
{0.309535,0.132798},
{0.244693,0.329569},
{0.232611,0.326172},
{0.15699,0.232387},
{0.270294,0.322282},
{0.165905,0.023424},
{0.207538,0.013469},
{0.202645,0.011192},
{0.1982,0.0105},
{0.302324,0.19484},
{0.176,0.2711},
{0.479489,0.838913},
{0.50141,0.831444},
{0.51688,0.814484},
{0.466003,0.833543},
{0.470158,0.813966},
{0.488011,0.807059},
{0.504994,0.80289},
{0.515882,0.809936},
{0.522732,0.80131},
{0.533473,0.806401},
{0.539127,0.817356},
{0.529253,0.821999},
{0.5174,0.826231},
{0.334735,0.781498},
{0.350276,0.765692},
{0.340978,0.76013},
{0.320347,0.770192},
{0.30382,0.78523},
{0.300096,0.770541},
{0.31087,0.765008},
{0.299981,0.766782},
{0.297604,0.769851},
{0.297216,0.765893},
{0.825133,0.590562},
{0.834532,0.614262},
{0.850482,0.589275},
{0.84255,0.573684},
{0.869237,0.57854},
{0.835172,0.642836},
{0.813932,0.641002},
{0.817356,0.620051},
{0.806893,0.606195},
{0.813752,0.579301},
{0.825635,0.56398},
{0.834843,0.560765},
{0.861715,0.568146},
{0.878365,0.569984},
{0.887041,0.584715},
{0.855576,0.628581},
{0.851881,0.659206},
{0.825538,0.682061},
{0.811451,0.674786},
{0.798734,0.660935},
{0.804448,0.631454},
{0.779172,0.618194},
{0.773212,0.606793},
{0.797406,0.59037},
{0.804261,0.582582},
{0.812282,0.575526},
{0.821996,0.568021},
{0.816963,0.565921},
{0.826368,0.560069},
{0.829396,0.559673},
{0.832347,0.549441},
{0.867191,0.555084},
{0.902325,0.560938},
{0.904642,0.585119},
{0.883485,0.60835},
{0.894617,0.617417},
{0.865823,0.640281},
{0.863944,0.663961},
{0.85136,0.678183},
{0.848346,0.684396},
{0.830473,0.690192},
{0.819011,0.70251},
{0.79745,0.702039},
{0.787417,0.682002},
{0.769551,0.668888},
{0.775421,0.644274},
{0.766623,0.631276},
{0.756781,0.608455},
{0.762066,0.602303},
{0.766529,0.598526},
{0.769979,0.595507},
{0.779866,0.591999},
{0.785641,0.59096},
{0.795269,0.586874},
{0.800751,0.580702},
{0.948398,0.477637},
{0.933208,0.484683},
{0.953836,0.494919},
{0.955153,0.501699},
{0.93949,0.501124},
{0.933582,0.489984},
{0.925705,0.482335},
{0.911969,0.492176},
{0.911751,0.482517},
{0.909269,0.485116},
{0.906983,0.493896},
{0.905932,0.485906},
{0.949746,0.525412},
{0.956633,0.526551},
{0.953956,0.520068},
{0.946363,0.516958},
{0.956241,0.514686},
{0.9592,0.5195},
{0.762865,0.716678},
{0.760105,0.699918},
{0.744899,0.681882},
{0.737726,0.655988},
{0.388738,0.868327},
{0.388313,0.853222},
{0.363143,0.869311},
{0.3555,0.879629},
{0.350751,0.877227},
{0.356348,0.86592},
{0.364584,0.861373},
{0.374462,0.854513},
{0.389496,0.848047},
{0.418022,0.828911},
{0.409645,0.843584},
{0.409327,0.863088},
{0.3968,0.8715},
{0.38931,0.873216},
{0.371371,0.880114},
{0.354643,0.885895},
{0.351424,0.886683},
{0.345448,0.884359},
{0.335676,0.885076},
{0.337408,0.880072},
{0.341075,0.869701},
{0.357088,0.860685},
{0.368863,0.84832},
{0.401509,0.836244},
{0.404723,0.827098},
{0.400863,0.810885},
{0.429805,0.80482},
{0.431049,0.827747},
{0.426859,0.834816},
{0.438413,0.843816},
{0.427106,0.856382},
{0.418659,0.864186},
{0.425631,0.861632},
{0.440422,0.855098},
{0.451497,0.847846},
{0.455629,0.850922},
{0.486097,0.794943},
{0.487224,0.777081},
{0.456324,0.791612},
{0.455406,0.803365},
{0.445837,0.797748},
{0.444428,0.786155},
{0.446974,0.775947},
{0.463887,0.775435},
{0.473334,0.766888},
{0.487181,0.761007},
{0.498818,0.755736},
{0.502718,0.771077},
{0.49514,0.801618},
{0.480031,0.806661},
{0.464195,0.812154},
{0.448977,0.819329},
{0.434927,0.787699},
{0.429403,0.779023},
{0.186109,0.868567},
{0.198998,0.855701},
{0.185458,0.846243},
{0.177918,0.859982},
{0.179771,0.847595},
{0.173133,0.848234},
{0.176955,0.844268},
{0.670798,0.79502},
{0.689898,0.802398},
{0.697255,0.772633},
{0.674885,0.781998},
{0.678619,0.770692},
{0.702876,0.751044},
{0.707195,0.775742},
{0.709465,0.786079},
{0.698321,0.800787},
{0.687268,0.811097},
{0.667451,0.806233},
{0.648483,0.790889},
{0.93295,0.539995},
{0.952124,0.534627},
{0.928515,0.532062},
{0.924444,0.523544},
{0.941055,0.509902},
{0.145707,0.858395},
{0.153938,0.864037},
{0.153884,0.860846},
{0.157885,0.869176},
{0.153277,0.868071},
{0.161614,0.87641},
{0.14866,0.87286},
{0.159991,0.880823},
{0.14204,0.882411},
{0.134133,0.877538},
{0.135196,0.888789},
{0.128056,0.883648},
{0.126953,0.889202},
{0.865694,0.683189},
{0.866258,0.703567},
{0.881824,0.691876},
{0.887769,0.676632},
{0.889123,0.690213},
{0.884414,0.69445},
{0.880153,0.69757},
{0.878499,0.70183},
{0.868537,0.710462},
{0.864014,0.719506},
{0.856673,0.722122},
{0.846159,0.708099},
{0.846603,0.690078},
{0.856152,0.676555},
{0.863478,0.66743},
{0.87277,0.658712},
{0.895177,0.651734},
{0.899338,0.667451},
{0.906606,0.671053},
{0.902234,0.675499},
{0.895502,0.687602},
{0.901322,0.680932},
{0.902311,0.685558},
{0.747827,0.61116},
{0.743359,0.623439},
{0.741646,0.628567},
{0.73889,0.626788},
{0.732616,0.625157},
{0.735497,0.621363},
{0.741539,0.616135},
{0.714852,0.690408},
{0.7073,0.682},
{0.706684,0.694613},
{0.708175,0.705391},
{0.713141,0.713366},
{0.706106,0.711319},
{0.701428,0.723574},
{0.70917,0.734444},
{0.699533,0.732161},
{0.690441,0.746705},
{0.663755,0.772942},
{0.686,0.7505},
{0.948281,0.559432},
{0.959097,0.554867},
{0.96071,0.547926},
{0.958153,0.545603},
{0.956372,0.539653},
{0.962677,0.547937},
{0.961495,0.540669},
{0.959119,0.533013},
{0.722717,0.688049},
{0.739352,0.712979},
{0.739856,0.724654},
{0.724154,0.72707},
{0.722891,0.699578},
{0.717627,0.678118},
{0.721171,0.675844},
{0.205663,0.849631},
{0.204323,0.872608},
{0.215695,0.864967},
{0.216159,0.874596},
{0.201623,0.881269},
{0.197394,0.870807},
{0.189816,0.878319},
{0.180289,0.875594},
{0.169603,0.870325},
{0.170558,0.853016},
{0.748303,0.764252},
{0.740534,0.797559},
{0.758781,0.782266},
{0.767973,0.75417},
{0.787409,0.755939},
{0.7849,0.765274},
{0.797654,0.749085},
{0.799302,0.757195},
{0.793628,0.76751},
{0.241627,0.846823},
{0.232205,0.849745},
{0.246182,0.859618},
{0.25087,0.854},
{0.252789,0.859319},
{0.253476,0.862489},
{0.246547,0.867985},
{0.238028,0.8615},
{0.22489,0.863953},
{0.225363,0.850708},
{0.216948,0.850318},
{0.211705,0.849581},
{0.403014,0.780696},
{0.39921,0.799016},
{0.367881,0.796382},
{0.360743,0.773081},
{0.37695,0.77188},
{0.387116,0.772161},
{0.383221,0.770634},
{0.379549,0.770438},
{0.369557,0.768093},
{0.367132,0.769461},
{0.360424,0.764399},
{0.365,0.7672},
{0.276118,0.833546},
{0.279985,0.842748},
{0.29179,0.836845},
{0.29752,0.826491},
{0.304045,0.837826},
{0.299022,0.839587},
{0.289654,0.842706},
{0.297853,0.848346},
{0.28749,0.8551},
{0.266097,0.856354},
{0.267227,0.843161},
{0.26541,0.837289},
{0.268443,0.823729},
{0.277399,0.829664},
{0.29401,0.822581},
{0.29378,0.810748},
{0.329537,0.803821},
{0.324852,0.82818},
{0.311883,0.835124},
{0.325682,0.843713},
{0.301614,0.846109},
{0.329554,0.846657},
{0.317406,0.852509},
{0.30934,0.859172},
{0.29606,0.866866},
{0.286282,0.865993},
{0.281001,0.863256},
{0.269796,0.862654},
{0.257163,0.854724},
{0.247865,0.841777},
{0.249433,0.834052},
{0.258143,0.821424},
{0.263784,0.812812},
{0.273558,0.810613},
{0.832711,0.71832},
{0.837602,0.706811},
{0.83367,0.70389},
{0.838862,0.69455},
{0.875504,0.652637},
{0.886684,0.6434},
{0.901134,0.62829},
{0.91205,0.641488},
{0.909452,0.657873},
{0.909103,0.663802},
{0.910139,0.67319},
{0.71285,0.788881},
{0.717026,0.801092},
{0.738072,0.773606},
{0.72865,0.809549},
{0.713018,0.815973},
{0.704161,0.808921},
{0.691509,0.824429},
{0.688735,0.822383},
{0.677177,0.825061},
{0.67263,0.82801},
{0.665386,0.826419},
{0.32396,0.875268},
{0.298241,0.875713},
{0.30189,0.884282},
{0.326079,0.883609},
{0.31821,0.885925},
{0.307611,0.890761},
{0.300558,0.890666},
{0.29435,0.888638},
{0.291024,0.88164},
{0.287062,0.870981},
{0.317669,0.869917},
{0.331414,0.871759},
{0.315293,0.892054},
{0.325815,0.835899},
{0.338127,0.84272},
{0.346337,0.825971},
{0.371733,0.824179},
{0.353784,0.834256},
{0.252628,0.888876},
{0.252698,0.881225},
{0.246641,0.881847},
{0.247802,0.889694},
{0.242357,0.880521},
{0.252703,0.871192},
{0.254697,0.865212},
{0.257877,0.872525},
{0.255916,0.876051},
{0.25985,0.877803},
{0.270456,0.877935},
{0.264952,0.880865},
{0.2723,0.8845},
{0.277534,0.884642},
{0.282943,0.880416},
{0.286045,0.887018},
{0.720412,0.750838},
{0.732535,0.743447},
{0.716542,0.735398},
{0.733983,0.740142},
{0.750843,0.7467},
{0.748051,0.748581},
{0.74578,0.757619},
{0.723447,0.774711},
{0.917253,0.604619},
{0.929901,0.58831},
{0.920552,0.606377},
{0.910337,0.616476},
{0.897847,0.622794},
{0.925533,0.626266},
{0.930278,0.613028},
{0.939052,0.592323},
{0.939226,0.60823},
{0.932741,0.62008},
{0.81087,0.737765},
{0.807979,0.7562},
{0.821085,0.745315},
{0.823493,0.720953},
{0.834332,0.729752},
{0.838521,0.739831},
{0.8293,0.7475},
{0.928328,0.536699},
{0.91417,0.513385},
{0.920669,0.51602},
{0.917935,0.504849},
{0.915343,0.504571},
{0.880467,0.511678},
{0.884035,0.532693},
{0.86661,0.532931},
{0.852722,0.525698},
{0.834484,0.541742},
{0.832556,0.52886},
{0.831598,0.539152},
{0.8295,0.532358},
{0.827144,0.540234},
{0.830714,0.541927},
{0.827523,0.546668},
{0.824384,0.538508},
{0.948527,0.593148},
{0.940992,0.577103},
{0.942136,0.585266},
{0.937865,0.584909},
{0.938654,0.575441},
{0.940708,0.566308},
{0.949994,0.56594},
{0.950481,0.578073},
{0.806233,0.730083},
{0.814531,0.72011},
{0.819915,0.717986},
{0.820021,0.714032},
{0.849052,0.729134},
{0.893042,0.633669},
{0.921052,0.635878},
{0.917762,0.643098},
{0.914968,0.648382},
{0.912222,0.659516},
{0.741384,0.762424},
{0.754081,0.759448},
{0.755991,0.752338},
{0.761199,0.754485},
{0.275186,0.876427},
{0.281787,0.867352},
{0.271117,0.867941},
{0.257558,0.861273},
{0.282357,0.875418},
{0.726112,0.777729},
{0.32877,0.891598},
{0.34313,0.890937},
{0.830239,0.702206},
{0.698455,0.837191},
{0.68044,0.835139},
{0.678861,0.829318},
{0.245747,0.894074},
{0.250212,0.895436},
{0.880247,0.546144},
{0.900159,0.547997},
{0.928101,0.545209},
{0.921794,0.564332},
{0.441406,0.828007},
{0.456292,0.820603},
{0.503372,0.798828},
{0.511146,0.803935},
{0.515859,0.806705},
{0.52196,0.797516},
{0.529443,0.799373},
{0.540935,0.798506},
{0.537858,0.795804},
{0.518056,0.785073},
{0.53124,0.783032},
{0.518112,0.768496},
{0.52509,0.763381},
{0.522614,0.753209},
{0.514131,0.751382},
{0.716301,0.821331},
{0.233971,0.868698},
{0.240002,0.88746},
{0.240331,0.89528},
{0.2373,0.8929},
{0.286441,0.794502},
{0.292254,0.775606},
{0.291866,0.774002},
{0.284136,0.778224},
{0.28293,0.783084},
{0.278982,0.785119},
{0.281045,0.777355},
{0.245842,0.897407},
{0.732178,0.645421},
{0.737029,0.634153},
{0.328085,0.867604},
{0.306061,0.865173},
{0.938202,0.555393},
{0.945426,0.562767},
{0.941378,0.555156},
{0.951095,0.564459},
{0.934916,0.546739},
{0.646515,0.788148},
{0.180825,0.884997},
{0.186659,0.881094},
{0.169247,0.876954},
{0.165297,0.871716},
{0.169342,0.862459},
{0.161249,0.865017},
{0.150148,0.856341},
{0.784331,0.724569},
{0.768112,0.731523},
{0.776562,0.735967},
{0.786909,0.731212},
{0.781073,0.737163},
{0.767668,0.74365},
{0.795403,0.720583},
{0.792736,0.727587},
{0.790377,0.738233},
{0.778582,0.745124},
{0.768467,0.745945},
{0.763278,0.748026},
{0.166093,0.878879},
{0.16894,0.886353},
{0.178604,0.891196},
{0.18433,0.889582},
{0.18723,0.887572},
{0.194857,0.886837},
{0.189032,0.890302},
{0.762607,0.59662},
{0.754748,0.60484},
{0.219131,0.871417},
{0.224802,0.871505},
{0.231297,0.874263},
{0.234034,0.877241},
{0.80298,0.721727},
{0.796759,0.724821},
{0.804796,0.727385},
{0.796771,0.736647},
{0.81417,0.710266},
{0.415407,0.781554},
{0.411144,0.777614},
{0.40269,0.86841},
{0.943412,0.605208},
{0.951835,0.594211},
{0.548094,0.817244},
{0.550821,0.814209},
{0.542519,0.820084},
{0.536719,0.822069},
{0.727728,0.655152},
{0.77933,0.748382},
{0.198348,0.884543},
{0.392631,0.831254},
{0.354852,0.759666},
{0.924831,0.632008},
{0.9281,0.6285},
{0.271813,0.791589},
{0.26635,0.803439},
{0.277408,0.796499},
{0.275224,0.788696},
{0.283153,0.793453},
{0.263448,0.809121},
{0.806255,0.578017},
{0.932171,0.592511},
{0.687759,0.843292},
{0.679024,0.843378},
{0.920196,0.638902},
{0.544851,0.807641},
{0.249785,0.825206},
{0.193647,0.848693},
{0.1921,0.8466},
{0.149336,0.885739},
{0.817765,0.557549},
{0.260362,0.81689},
{0.245245,0.83973},
{0.248006,0.836881},
{0.852164,0.729606},
{0.8573,0.726},
{0.5297,0.8264},
{0.520354,0.827741},
{0.831003,0.521352},
{0.8294,0.5276},
{0.953278,0.565098},
{0.350557,0.758503},
{0.959966,0.495949},
{0.974656,0.478099},
{0.959811,0.48719},
{0.960068,0.482726},
{0.961531,0.475025},
{0.491489,0.83814},
{0.49876,0.838538},
{0.50696,0.834215},
{0.27576,0.782571},
{0.482782,0.842426},
{0.269884,0.792562},
{0.47127,0.845797},
{0.824527,0.533705},
{0.817319,0.533067},
{0.973305,0.49008},
{0.9733,0.4922},
{0.972375,0.49347},
{0.9733,0.4922},
{0.9989,0.4427},
{0.9991,0.4429},
{0.9995,0.442473},
{0.9989,0.4424},
{0.610787,0.937863},
{0.594951,0.953682},
{0.604722,0.953526},
{0.612369,0.942816},
{0.615588,0.943661},
{0.616225,0.932384},
{0.609888,0.930176},
{0.619679,0.924706},
{0.625047,0.922102},
{0.629951,0.929035},
{0.634868,0.924329},
{0.638866,0.915595},
{0.651974,0.9065},
{0.653522,0.888851},
{0.643171,0.902092},
{0.649505,0.888251},
{0.656381,0.872147},
{0.658582,0.877287},
{0.658457,0.884379},
{0.507047,0.912184},
{0.507839,0.918622},
{0.518303,0.918434},
{0.516666,0.914522},
{0.52683,0.917401},
{0.526779,0.92096},
{0.526094,0.924475},
{0.517295,0.9275},
{0.507397,0.93612},
{0.497639,0.931888},
{0.499988,0.914462},
{0.504445,0.911161},
{0.498394,0.90991},
{0.508684,0.897146},
{0.512645,0.903066},
{0.523266,0.907553},
{0.530354,0.907905},
{0.543422,0.918582},
{0.535515,0.922393},
{0.539983,0.927421},
{0.536127,0.944585},
{0.520108,0.941269},
{0.989638,0.448055},
{0.993,0.4469},
{0.989296,0.444789},
{0.593198,0.903727},
{0.591411,0.864105},
{0.561578,0.893795},
{0.56258,0.908157},
{0.552773,0.896911},
{0.55184,0.886412},
{0.554513,0.869751},
{0.580336,0.859788},
{0.589621,0.860357},
{0.593506,0.860029},
{0.6072,0.881807},
{0.604028,0.902205},
{0.607457,0.908227},
{0.588861,0.91046},
{0.578151,0.911361},
{0.569374,0.914},
{0.560652,0.914312},
{0.55583,0.908426},
{0.55325,0.902781},
{0.549678,0.905307},
{0.546904,0.890061},
{0.544904,0.881405},
{0.550499,0.883543},
{0.550642,0.87847},
{0.549645,0.872659},
{0.550103,0.865084},
{0.562428,0.86375},
{0.575131,0.854333},
{0.590083,0.852512},
{0.603839,0.857513},
{0.618028,0.859159},
{0.620993,0.903881},
{0.612285,0.906999},
{0.613665,0.910117},
{0.605269,0.911734},
{0.599143,0.916023},
{0.58751,0.915648},
{0.567392,0.917837},
{0.557754,0.922834},
{0.556244,0.917114},
{0.556343,0.912738},
{0.55255,0.914362},
{0.551637,0.908681},
{0.53905,0.907031},
{0.524564,0.902143},
{0.519201,0.873709},
{0.531356,0.868816},
{0.545209,0.871608},
{0.601399,0.817044},
{0.607754,0.824728},
{0.619789,0.825546},
{0.628895,0.819209},
{0.632597,0.824187},
{0.624416,0.831971},
{0.611424,0.830991},
{0.601814,0.832432},
{0.593454,0.829482},
{0.593854,0.823711},
{0.60093,0.811751},
{0.606329,0.803946},
{0.621069,0.808991},
{0.637273,0.813111},
{0.643084,0.81559},
{0.646246,0.82852},
{0.648621,0.847768},
{0.624153,0.842966},
{0.613657,0.83545},
{0.594114,0.837678},
{0.590162,0.831569},
{0.581605,0.805639},
{0.589379,0.806262},
{0.600232,0.804877},
{0.60706,0.799553},
{0.611745,0.800452},
{0.620504,0.80316},
{0.6319,0.8066},
{0.640142,0.854907},
{0.63406,0.847697},
{0.625574,0.851054},
{0.638819,0.857224},
{0.6308,0.856302},
{0.624777,0.854185},
{0.618983,0.853546},
{0.613447,0.849049},
{0.612614,0.843006},
{0.650614,0.855747},
{0.648715,0.860963},
{0.640703,0.862547},
{0.629514,0.861298},
{0.614517,0.853723},
{0.60877,0.85234},
{0.600903,0.850352},
{0.591674,0.845167},
{0.552857,0.843408},
{0.570864,0.835119},
{0.552449,0.826626},
{0.534847,0.830251},
{0.550342,0.823474},
{0.560266,0.818758},
{0.572028,0.812399},
{0.576632,0.844874},
{0.559955,0.852411},
{0.54738,0.854012},
{0.528446,0.847728},
{0.517871,0.838736},
{0.5249,0.8324},
{0.630718,0.900645},
{0.638247,0.898165},
{0.602839,0.919465},
{0.61621,0.917336},
{0.604696,0.916654},
{0.611132,0.91296},
{0.624894,0.91044},
{0.604042,0.928415},
{0.59376,0.922584},
{0.589128,0.919344},
{0.581925,0.921343},
{0.577119,0.922328},
{0.566496,0.924726},
{0.563353,0.928319},
{0.557216,0.925116},
{0.552246,0.925094},
{0.550452,0.919531},
{0.658757,0.863692},
{0.65451,0.855523},
{0.664203,0.857261},
{0.654735,0.846747},
{0.659963,0.835317},
{0.6646,0.8414},
{0.544702,0.862134},
{0.549597,0.857087},
{0.55963,0.855046},
{0.573797,0.850756},
{0.591538,0.850071},
{0.53931,0.855187},
{0.530998,0.858971},
{0.532338,0.856395},
{0.488566,0.929287},
{0.492042,0.912663},
{0.498525,0.848588},
{0.502325,0.864392},
{0.507273,0.842699},
{0.511214,0.854584},
{0.50983,0.865339},
{0.502027,0.871025},
{0.513756,0.866835},
{0.513589,0.876361},
{0.505248,0.890023},
{0.548711,0.921673},
{0.539869,0.922107},
{0.548944,0.928137},
{0.548371,0.939569},
{0.546016,0.943901},
{0.540528,0.947209},
{0.548658,0.947076},
{0.554369,0.944113},
{0.561157,0.933465},
{0.561408,0.94596},
{0.568317,0.947935},
{0.573194,0.942208},
{0.579099,0.950254},
{0.578809,0.932699},
{0.593106,0.938352},
{0.587175,0.952073},
{0.5842,0.9532},
{0.521784,0.859652},
{0.594193,0.801625},
{0.605849,0.795604},
{0.612294,0.791633},
{0.621051,0.800126},
{0.514952,0.83671},
{0.543677,0.867332},
{0.504342,0.891708},
{0.495078,0.907601},
{0.559491,0.814227},
{0.549267,0.820334},
{0.537785,0.825481},
{0.590939,0.800614},
{0.122649,0.519403},
{0.139565,0.496286},
{0.1091,0.514183},
{0.100147,0.519535},
{0.103666,0.513288},
{0.107886,0.50985},
{0.138141,0.487216},
{0.150915,0.48903},
{0.147979,0.495038},
{0.143196,0.505994},
{0.136311,0.520152},
{0.131814,0.534162},
{0.127495,0.53212},
{0.113002,0.526564},
{0.102251,0.526849},
{0.096503,0.522164},
{0.095738,0.5188},
{0.096485,0.514003},
{0.105584,0.503556},
{0.118391,0.493193},
{0.144043,0.476216},
{0.154873,0.480257},
{0.153349,0.489586},
{0.181052,0.331993},
{0.197493,0.347176},
{0.198542,0.337659},
{0.195837,0.327862},
{0.205535,0.337986},
{0.207336,0.351481},
{0.202188,0.361494},
{0.193899,0.362635},
{0.177745,0.349377},
{0.137184,0.720528},
{0.121258,0.712769},
{0.132222,0.724189},
{0.140084,0.733684},
{0.129322,0.734756},
{0.106286,0.720083},
{0.107701,0.714725},
{0.10626,0.707548},
{0.10752,0.70157},
{0.136822,0.707107},
{0.137192,0.711295},
{0.083729,0.521996},
{0.093639,0.523384},
{0.098863,0.527989},
{0.086871,0.525704},
{0.083283,0.526983},
{0.077991,0.525176},
{0.077188,0.521026},
{0.083842,0.534644},
{0.097603,0.538879},
{0.102585,0.530355},
{0.101812,0.545053},
{0.09713,0.548317},
{0.081123,0.545092},
{0.074833,0.534329},
{0.139018,0.434639},
{0.134053,0.441268},
{0.137598,0.447717},
{0.143027,0.441179},
{0.141542,0.448748},
{0.135758,0.457708},
{0.13295,0.446578},
{0.125325,0.471861},
{0.128021,0.475354},
{0.116025,0.491403},
{0.053355,0.576977},
{0.059691,0.582489},
{0.064793,0.572532},
{0.055925,0.573949},
{0.068342,0.583508},
{0.087155,0.581341},
{0.079831,0.567871},
{0.098307,0.574875},
{0.096525,0.587225},
{0.08936,0.597517},
{0.07823,0.588296},
{0.071542,0.586289},
{0.073438,0.589938},
{0.145386,0.818115},
{0.150927,0.824837},
{0.157285,0.813511},
{0.151149,0.80513},
{0.157113,0.80634},
{0.167711,0.801401},
{0.170664,0.807765},
{0.164726,0.819005},
{0.158066,0.822194},
{0.154375,0.822386},
{0.20823,0.362912},
{0.208768,0.377807},
{0.215398,0.360768},
{0.209942,0.358325},
{0.21333,0.354309},
{0.218269,0.352378},
{0.101888,0.575782},
{0.106263,0.583219},
{0.115787,0.584908},
{0.110822,0.574683},
{0.116454,0.57918},
{0.111217,0.568973},
{0.119223,0.567378},
{0.118331,0.56313},
{0.106399,0.563683},
{0.10502,0.554803},
{0.119605,0.555139},
{0.111391,0.549464},
{0.120145,0.546011},
{0.123075,0.546059},
{0.120739,0.539742},
{0.126833,0.542491},
{0.128008,0.817415},
{0.121144,0.810008},
{0.133308,0.798154},
{0.152842,0.797062},
{0.161495,0.794587},
{0.103974,0.826497},
{0.10505,0.837456},
{0.117365,0.830348},
{0.113586,0.820944},
{0.130312,0.821996},
{0.126821,0.828258},
{0.111394,0.842609},
{0.10675,0.844794},
{0.112328,0.847659},
{0.107594,0.850262},
{0.116353,0.661277},
{0.108934,0.635932},
{0.103567,0.668186},
{0.104401,0.681703},
{0.116937,0.679289},
{0.126638,0.685095},
{0.106156,0.695351},
{0.129935,0.696026},
{0.102238,0.70024},
{0.082201,0.550022},
{0.090318,0.557324},
{0.09812,0.558388},
{0.100767,0.552359},
{0.098611,0.566845},
{0.094696,0.56077},
{0.180098,0.40523},
{0.165042,0.412511},
{0.185721,0.414523},
{0.188671,0.406674},
{0.187182,0.396811},
{0.191621,0.400153},
{0.195479,0.390139},
{0.183138,0.383068},
{0.19128,0.379771},
{0.201191,0.377922},
{0.202323,0.382078},
{0.20626,0.383207},
{0.155656,0.461103},
{0.164532,0.462386},
{0.165524,0.452388},
{0.170235,0.453811},
{0.1676,0.4599},
{0.166108,0.385576},
{0.169578,0.37504},
{0.163679,0.378959},
{0.159785,0.3918},
{0.162794,0.395484},
{0.159377,0.402904},
{0.159312,0.406974},
{0.156057,0.409106},
{0.153129,0.40401},
{0.144377,0.418254},
{0.152225,0.417323},
{0.150251,0.426098},
{0.1388,0.4225},
{0.14501,0.750863},
{0.153804,0.757991},
{0.142966,0.74548},
{0.138636,0.760413},
{0.132169,0.757221},
{0.146574,0.74104},
{0.154732,0.754605},
{0.139437,0.784647},
{0.127764,0.789479},
{0.122705,0.798321},
{0.11429,0.785447},
{0.124931,0.774901},
{0.136159,0.77183},
{0.15398,0.780448},
{0.157046,0.786542},
{0.119492,0.76535},
{0.105226,0.762112},
{0.108546,0.772074},
{0.104316,0.777626},
{0.10452,0.768239},
{0.10256,0.76545},
{0.104189,0.776444},
{0.159907,0.429353},
{0.174469,0.429058},
{0.168918,0.421233},
{0.153803,0.42179},
{0.181397,0.425517},
{0.178212,0.435216},
{0.170532,0.439277},
{0.147266,0.433595},
{0.102919,0.810699},
{0.102397,0.803457},
{0.175453,0.444316},
{0.195424,0.32198},
{0.189542,0.316741},
{0.184611,0.322424},
{0.1808,0.3257},
{0.066605,0.543146},
{0.057241,0.541569},
{0.066194,0.54661},
{0.079623,0.552774},
{0.12168,0.759402},
{0.143208,0.76217},
{0.151131,0.771477},
{0.152522,0.774464},
{0.183942,0.363755},
{0.199987,0.368842},
{0.199338,0.373203},
{0.213592,0.348473},
{0.217449,0.342507},
{0.219534,0.344952},
{0.2204,0.3457},
{0.128514,0.669549},
{0.128904,0.655898},
{0.126082,0.657485},
{0.125771,0.647622},
{0.117849,0.64078},
{0.124119,0.637095},
{0.122003,0.623227},
{0.126,0.631713},
{0.124108,0.615326},
{0.121415,0.613953},
{0.122327,0.608454},
{0.115843,0.597948},
{0.114316,0.608206},
{0.092237,0.602609},
{0.093013,0.598157},
{0.09993,0.592941},
{0.111922,0.591051},
{0.120101,0.592101},
{0.1213,0.6007},
{0.105292,0.587458},
{0.082717,0.598906},
{0.085413,0.595037},
{0.077159,0.592557},
{0.112111,0.58429},
{0.128486,0.676338},
{0.132012,0.683791},
{0.135328,0.693295},
{0.136792,0.700173},
{0.096422,0.609505},
{0.100082,0.618445},
{0.10925,0.536478},
{0.111226,0.543173},
{0.105136,0.542556},
{0.103857,0.538574},
{0.11494,0.546088},
{0.1321,0.6724},
{0.078143,0.528117},
{0.068919,0.530606},
{0.063009,0.531872},
{0.066094,0.526662},
{0.199104,0.364107},
{0.096516,0.61677},
{0.098986,0.625826},
{0.099756,0.638107},
{0.096891,0.630092},
{0.102411,0.818773},
{0.056114,0.536367},
{0.053523,0.537239},
{0.087937,0.565294},
{0.157453,0.770309},
{0.149992,0.76629},
{0.146983,0.763487},
{0.148407,0.75984},
{0.142633,0.827205},
{0.212365,0.332489},
{0.222303,0.328329},
{0.172436,0.449007},
{0.118461,0.747611},
{0.107222,0.744617},
{0.129324,0.833826},
{0.116762,0.841361},
{0.116328,0.846372},
{0.104648,0.787187},
{0.0857,0.6028},
{0.0824,0.6008},
{0.119359,0.8423},
{0.1949,0.3181},
{0.18605,0.315383},
{0.188367,0.312742},
{0.170885,0.359227},
{0.172195,0.364181},
{0.169078,0.365542},
{0.13559,0.525036},
{0.2178,0.3244},
{0.2134,0.325},
{0.20682,0.327188},
{0.2027,0.3277},
{0.1989,0.3242},
{0.073977,0.568119},
{0.0812,0.5637},
{0.400694,0.583849},
{0.385403,0.587106},
{0.39198,0.603867},
{0.418505,0.605043},
{0.41289,0.612427},
{0.407845,0.620061},
{0.396895,0.614167},
{0.374122,0.603},
{0.368682,0.597201},
{0.371724,0.578001},
{0.386165,0.573964},
{0.406606,0.563069},
{0.417643,0.571733},
{0.429189,0.585606},
{0.432835,0.598782},
{0.423785,0.61044},
{0.416109,0.61922},
{0.404716,0.629249},
{0.401426,0.622646},
{0.380362,0.617804},
{0.367527,0.607732},
{0.355988,0.601584},
{0.34879,0.600506},
{0.351009,0.607075},
{0.339715,0.604788},
{0.337118,0.608746},
{0.332651,0.604746},
{0.336925,0.602005},
{0.543143,0.541212},
{0.556627,0.553855},
{0.578287,0.525955},
{0.520719,0.538858},
{0.563107,0.513635},
{0.58894,0.498384},
{0.60153,0.504306},
{0.610244,0.51276},
{0.586685,0.53777},
{0.558668,0.571281},
{0.553197,0.57307},
{0.536433,0.557544},
{0.506253,0.556893},
{0.496741,0.550646},
{0.537966,0.517093},
{0.553185,0.503007},
{0.573423,0.48217},
{0.578039,0.487686},
{0.585178,0.473787},
{0.61758,0.475364},
{0.631811,0.476691},
{0.616211,0.497522},
{0.623077,0.512829},
{0.605358,0.529067},
{0.587615,0.545651},
{0.570979,0.564797},
{0.558091,0.582469},
{0.542397,0.592612},
{0.54021,0.573793},
{0.523934,0.570296},
{0.502303,0.57354},
{0.495835,0.559174},
{0.488815,0.551338},
{0.499375,0.541586},
{0.521591,0.52482},
{0.53384,0.514094},
{0.54184,0.497398},
{0.556237,0.469038},
{0.50024,0.603602},
{0.514384,0.585848},
{0.491733,0.587113},
{0.480021,0.593936},
{0.470024,0.584143},
{0.485749,0.579484},
{0.507531,0.583512},
{0.525703,0.588287},
{0.523897,0.607306},
{0.519801,0.620377},
{0.502141,0.623225},
{0.48801,0.613437},
{0.476478,0.606712},
{0.453857,0.602707},
{0.443712,0.590917},
{0.461064,0.576919},
{0.467855,0.570577},
{0.473556,0.570405},
{0.46341,0.552453},
{0.47586,0.537563},
{0.497177,0.531866},
{0.523263,0.506736},
{0.522553,0.492586},
{0.530419,0.473445},
{0.542516,0.461795},
{0.553028,0.454644},
{0.571562,0.458564},
{0.60029,0.440874},
{0.630394,0.432314},
{0.658225,0.426276},
{0.65784,0.441869},
{0.658168,0.465951},
{0.645697,0.491019},
{0.284119,0.642044},
{0.296625,0.631593},
{0.284967,0.624433},
{0.283015,0.630202},
{0.55004,0.705144},
{0.552333,0.681787},
{0.529557,0.705751},
{0.530632,0.715841},
{0.504431,0.735387},
{0.515425,0.71233},
{0.510622,0.686975},
{0.528695,0.699247},
{0.544518,0.674185},
{0.573166,0.678181},
{0.55995,0.69662},
{0.452633,0.699229},
{0.468526,0.703623},
{0.471854,0.68499},
{0.450547,0.67582},
{0.467907,0.671201},
{0.488011,0.667637},
{0.485059,0.692203},
{0.474161,0.699728},
{0.494231,0.698859},
{0.472344,0.715585},
{0.457216,0.71426},
{0.452277,0.711708},
{0.441487,0.687128},
{0.433303,0.674855},
{0.443627,0.670713},
{0.459943,0.670188},
{0.482712,0.660799},
{0.501953,0.65112},
{0.510676,0.654752},
{0.517701,0.667198},
{0.506342,0.674395},
{0.498302,0.681705},
{0.505621,0.457208},
{0.524889,0.447787},
{0.50822,0.451265},
{0.503619,0.448943},
{0.513273,0.441875},
{0.533993,0.438128},
{0.500266,0.484601},
{0.482836,0.483164},
{0.477146,0.47933},
{0.48129,0.46857},
{0.501578,0.445024},
{0.492283,0.450941},
{0.670574,0.364301},
{0.681356,0.348685},
{0.647019,0.350323},
{0.625172,0.361811},
{0.627051,0.342532},
{0.655381,0.324796},
{0.666377,0.341299},
{0.691047,0.346599},
{0.688104,0.351574},
{0.6841,0.3612},
{0.681359,0.367658},
{0.679114,0.376109},
{0.637673,0.370158},
{0.619081,0.374584},
{0.617188,0.357356},
{0.615185,0.354069},
{0.629349,0.329086},
{0.638278,0.322178},
{0.644741,0.307639},
{0.665398,0.317555},
{0.685235,0.318348},
{0.690914,0.320977},
{0.69928,0.328707},
{0.54816,0.600849},
{0.566063,0.59189},
{0.540045,0.609035},
{0.532514,0.599338},
{0.407794,0.76617},
{0.410906,0.759992},
{0.402085,0.75993},
{0.397393,0.76825},
{0.397347,0.760186},
{0.408393,0.755012},
{0.41294,0.755862},
{0.415958,0.756077},
{0.41981,0.758671},
{0.429318,0.759516},
{0.425146,0.76557},
{0.422642,0.76931},
{0.669327,0.483308},
{0.693524,0.476137},
{0.696308,0.462508},
{0.667716,0.473802},
{0.695764,0.457371},
{0.667357,0.461334},
{0.694753,0.452883},
{0.557471,0.643963},
{0.50001,0.717324},
{0.48994,0.717546},
{0.480477,0.732745},
{0.46824,0.735205},
{0.453498,0.736592},
{0.449115,0.722989},
{0.44071,0.719842},
{0.429621,0.692615},
{0.412248,0.675766},
{0.423773,0.670018},
{0.428447,0.660973},
{0.445041,0.662754},
{0.463471,0.657171},
{0.482758,0.648496},
{0.512035,0.645312},
{0.537727,0.636006},
{0.545406,0.640603},
{0.566833,0.622342},
{0.57726,0.629781},
{0.564805,0.657711},
{0.57832,0.658402},
{0.587784,0.670331},
{0.58725,0.676011},
{0.577359,0.683889},
{0.726467,0.55995},
{0.738593,0.577256},
{0.762723,0.568479},
{0.75794,0.559766},
{0.748755,0.552162},
{0.75275,0.552439},
{0.582976,0.398845},
{0.609514,0.393926},
{0.595328,0.387579},
{0.590318,0.390103},
{0.586383,0.392286},
{0.58886,0.622253},
{0.626624,0.637697},
{0.611332,0.622952},
{0.605423,0.614275},
{0.623521,0.623562},
{0.630164,0.630467},
{0.639547,0.64365},
{0.624144,0.646056},
{0.615894,0.646879},
{0.598977,0.632681},
{0.588435,0.611104},
{0.600278,0.603351},
{0.614465,0.609773},
{0.634713,0.624208},
{0.650893,0.632506},
{0.660233,0.626537},
{0.6511,0.6451},
{0.432161,0.724153},
{0.415182,0.71427},
{0.413711,0.723644},
{0.419739,0.730295},
{0.413332,0.738871},
{0.406977,0.725858},
{0.402729,0.721245},
{0.406507,0.71909},
{0.404286,0.714584},
{0.404123,0.706596},
{0.408661,0.704512},
{0.425727,0.714173},
{0.442478,0.730104},
{0.434992,0.732096},
{0.424732,0.738682},
{0.422326,0.74259},
{0.413823,0.744234},
{0.407669,0.744678},
{0.406156,0.739927},
{0.399091,0.732475},
{0.392931,0.723395},
{0.399409,0.714157},
{0.604173,0.655064},
{0.588861,0.640938},
{0.620239,0.65549},
{0.5941,0.665683},
{0.673956,0.533604},
{0.686043,0.510848},
{0.66372,0.496365},
{0.657594,0.546926},
{0.656361,0.505527},
{0.680261,0.492716},
{0.704957,0.490804},
{0.702426,0.517517},
{0.708169,0.534508},
{0.667711,0.551058},
{0.6583,0.566222},
{0.639107,0.535316},
{0.645455,0.531476},
{0.637684,0.52073},
{0.66384,0.454557},
{0.6669,0.4587},
{0.66646,0.454583},
{0.661499,0.44109},
{0.661793,0.429115},
{0.622609,0.569219},
{0.648412,0.586412},
{0.643669,0.570336},
{0.617653,0.556658},
{0.628255,0.549931},
{0.665624,0.585817},
{0.642922,0.593535},
{0.62479,0.604424},
{0.613374,0.597582},
{0.607634,0.580333},
{0.607364,0.562197},
{0.617983,0.54551},
{0.627854,0.542507},
{0.626323,0.52808},
{0.492885,0.520284},
{0.468514,0.531317},
{0.449232,0.526626},
{0.468233,0.521808},
{0.476872,0.515722},
{0.489102,0.508758},
{0.504168,0.505141},
{0.639159,0.386437},
{0.670321,0.386222},
{0.622185,0.385672},
{0.606347,0.386985},
{0.605247,0.372258},
{0.608301,0.365189},
{0.495407,0.73106},
{0.488277,0.737224},
{0.481167,0.737257},
{0.469476,0.741096},
{0.465031,0.744296},
{0.461687,0.746347},
{0.455679,0.745327},
{0.447524,0.745512},
{0.442878,0.743865},
{0.455347,0.616735},
{0.473717,0.618795},
{0.458659,0.630449},
{0.450176,0.621724},
{0.437534,0.61107},
{0.455602,0.576824},
{0.457608,0.562846},
{0.435036,0.548967},
{0.437361,0.530814},
{0.456037,0.519911},
{0.449605,0.505704},
{0.477854,0.493775},
{0.391249,0.687668},
{0.383291,0.683634},
{0.38204,0.690418},
{0.400784,0.698726},
{0.393016,0.701291},
{0.380625,0.695763},
{0.376288,0.690618},
{0.377021,0.685072},
{0.373656,0.675267},
{0.378894,0.675637},
{0.387417,0.680611},
{0.395071,0.687853},
{0.39988,0.693895},
{0.40594,0.695595},
{0.399425,0.706782},
{0.387019,0.700685},
{0.377119,0.706915},
{0.370771,0.700601},
{0.361589,0.698331},
{0.357242,0.688071},
{0.366653,0.675965},
{0.37415,0.667123},
{0.378502,0.669285},
{0.390157,0.666965},
{0.396379,0.680674},
{0.404847,0.678621},
{0.41076,0.69732},
{0.430586,0.564283},
{0.418832,0.552476},
{0.424301,0.537645},
{0.41718,0.532215},
{0.427425,0.522931},
{0.597277,0.410538},
{0.570968,0.416226},
{0.571661,0.425858},
{0.597773,0.417865},
{0.573419,0.439162},
{0.556881,0.438559},
{0.547859,0.427673},
{0.556383,0.416423},
{0.56652,0.409599},
{0.578281,0.408919},
{0.604225,0.401179},
{0.632278,0.401081},
{0.611563,0.415451},
{0.627523,0.417382},
{0.708446,0.605438},
{0.723142,0.604279},
{0.709602,0.588906},
{0.690288,0.598841},
{0.69567,0.574344},
{0.72826,0.587449},
{0.739425,0.596015},
{0.72558,0.610622},
{0.71783,0.619699},
{0.7151,0.6222},
{0.641206,0.39253},
{0.596732,0.382989},
{0.422266,0.754162},
{0.412672,0.750977},
{0.408992,0.748292},
{0.395681,0.755838},
{0.389716,0.746458},
{0.39237,0.742222},
{0.397567,0.736246},
{0.384482,0.737646},
{0.379067,0.71927},
{0.388869,0.715248},
{0.468781,0.639279},
{0.483973,0.636693},
{0.472199,0.630796},
{0.50714,0.634079},
{0.54208,0.619825},
{0.393948,0.649656},
{0.391556,0.629409},
{0.381552,0.641176},
{0.378742,0.636233},
{0.42814,0.749704},
{0.431425,0.757029},
{0.437795,0.75478},
{0.429673,0.745004},
{0.439914,0.750607},
{0.444546,0.75054},
{0.447984,0.750378},
{0.450171,0.748677},
{0.458088,0.748602},
{0.468031,0.747094},
{0.474553,0.74571},
{0.486526,0.741724},
{0.4788,0.7458},
{0.3646,0.5872},
{0.357082,0.641685},
{0.350366,0.628889},
{0.348467,0.639157},
{0.36155,0.646433},
{0.348855,0.647655},
{0.341634,0.635146},
{0.341433,0.623696},
{0.346891,0.619518},
{0.354734,0.627115},
{0.366732,0.638999},
{0.366275,0.650823},
{0.359742,0.657566},
{0.342124,0.652312},
{0.334478,0.633314},
{0.324014,0.624439},
{0.339833,0.616145},
{0.354718,0.618061},
{0.370239,0.63823},
{0.37529,0.647055},
{0.373438,0.657248},
{0.368605,0.662667},
{0.346356,0.669955},
{0.338796,0.664284},
{0.330148,0.65744},
{0.324112,0.64866},
{0.33101,0.636458},
{0.317342,0.631631},
{0.312276,0.626068},
{0.322338,0.619682},
{0.33039,0.613573},
{0.385187,0.658517},
{0.393849,0.656344},
{0.380226,0.66287},
{0.441707,0.624733},
{0.432608,0.636346},
{0.452642,0.634678},
{0.462165,0.638886},
{0.441558,0.642671},
{0.427231,0.646147},
{0.412842,0.645152},
{0.414649,0.641304},
{0.429138,0.620341},
{0.637685,0.609717},
{0.659137,0.612643},
{0.5989,0.585303},
{0.598461,0.557816},
{0.616312,0.52921},
{0.42981,0.704987},
{0.421501,0.693419},
{0.412275,0.684266},
{0.716276,0.547219},
{0.737411,0.537268},
{0.732509,0.5284},
{0.730437,0.519113},
{0.730318,0.514269},
{0.669025,0.285798},
{0.680833,0.292208},
{0.679308,0.288134},
{0.671391,0.282651},
{0.662931,0.2786},
{0.6715,0.28},
{0.6741,0.2809},
{0.3725,0.5737},
{0.374976,0.569466},
{0.398281,0.551681},
{0.40341,0.546388},
{0.698725,0.314827},
{0.69103,0.315008},
{0.692496,0.311662},
{0.699207,0.30879},
{0.7056,0.307315},
{0.7028,0.3027},
{0.694347,0.299146},
{0.684008,0.307088},
{0.685299,0.298587},
{0.684672,0.293554},
{0.690313,0.293599},
{0.698284,0.297887},
{0.741994,0.589379},
{0.770326,0.578661},
{0.76632,0.574262},
{0.65322,0.400492},
{0.671296,0.600389},
{0.680112,0.308789},
{0.675889,0.307301},
{0.677623,0.300258},
{0.683093,0.288358},
{0.671986,0.306354},
{0.679792,0.31279},
{0.682973,0.309648},
{0.685709,0.313473},
{0.669291,0.309085},
{0.658601,0.304991},
{0.659241,0.300645},
{0.66154,0.296992},
{0.674604,0.303114},
{0.674723,0.297579},
{0.677415,0.29628},
{0.665629,0.290035},
{0.660721,0.280591},
{0.656542,0.2826},
{0.656141,0.276528},
{0.659761,0.276203},
{0.681437,0.56735},
{0.591395,0.555092},
{0.581528,0.582442},
{0.579019,0.602218},
{0.566373,0.607259},
{0.647164,0.302409},
{0.643706,0.299074},
{0.64205,0.304406},
{0.636064,0.318645},
{0.638001,0.308524},
{0.748078,0.591233},
{0.771637,0.584075},
{0.40354,0.656807},
{0.405713,0.672235},
{0.397378,0.6683},
{0.411023,0.658996},
{0.346323,0.674132},
{0.349496,0.678883},
{0.351952,0.677481},
{0.3448,0.6721},
{0.688869,0.61515},
{0.687209,0.630015},
{0.698341,0.631668},
{0.702917,0.61714},
{0.706285,0.626274},
{0.438784,0.744478},
{0.665348,0.408124},
{0.6683,0.4041},
{0.670846,0.396422},
{0.67511,0.384886},
{0.492086,0.740238},
{0.499935,0.737022},
{0.6598,0.6415},
{0.666495,0.640634},
{0.389312,0.749936},
{0.39202,0.759369},
{0.393683,0.762229},
{0.367688,0.710682},
{0.365331,0.712009},
{0.369574,0.719738},
{0.376264,0.725441},
{0.374396,0.726976},
{0.371329,0.727756},
{0.3783,0.734069},
{0.381817,0.739595},
{0.355951,0.69285},
{0.358865,0.698534},
{0.354494,0.688245},
{0.332229,0.607533},
{0.327663,0.609234},
{0.703558,0.480392},
{0.710257,0.488019},
{0.715068,0.491129},
{0.301805,0.640782},
{0.291908,0.642082},
{0.2963,0.6458},
{0.425257,0.746271},
{0.426861,0.753989},
{0.32412,0.655424},
{0.324696,0.653034},
{0.319946,0.650764},
{0.31607,0.639513},
{0.593323,0.596839},
{0.433642,0.760379},
{0.431975,0.761936},
{0.701267,0.468652},
{0.702332,0.47185},
{0.478771,0.485824},
{0.468517,0.489746},
{0.460977,0.487491},
{0.310395,0.645116},
{0.31479,0.644063},
{0.456904,0.491251},
{0.453704,0.497885},
{0.4385,0.7585},
{0.4397,0.7573},
{0.748545,0.598934},
{0.516898,0.432206},
{0.509852,0.436358},
{0.379072,0.56484},
{0.402832,0.773562},
{0.3963,0.7737},
{0.651316,0.29262},
{0.649906,0.296136},
{0.651778,0.28801},
{0.649108,0.299841},
{0.575405,0.402056},
{0.569247,0.40721},
{0.620853,0.339761},
{0.648187,0.287119},
{0.6457,0.2905},
{0.314657,0.649074},
{0.771371,0.590015},
{0.703964,0.318416},
{0.682085,0.370827},
{0.445926,0.656956},
{0.336634,0.666127},
{0.3419,0.6688},
{0.33326,0.66188},
{0.471645,0.369998},
{0.491334,0.362366},
{0.470773,0.359128},
{0.459362,0.378471},
{0.459784,0.318419},
{0.47874,0.341653},
{0.494311,0.34826},
{0.499929,0.33929},
{0.506066,0.344299},
{0.505128,0.329832},
{0.510622,0.325154},
{0.50636,0.316635},
{0.514338,0.31441},
{0.511034,0.305937},
{0.517798,0.30422},
{0.513801,0.295913},
{0.522444,0.297639},
{0.516875,0.287636},
{0.525109,0.282497},
{0.518373,0.270472},
{0.529907,0.269806},
{0.535605,0.274418},
{0.539327,0.267071},
{0.531908,0.262458},
{0.52841,0.258314},
{0.543984,0.256535},
{0.546863,0.260964},
{0.424259,0.245252},
{0.399453,0.244927},
{0.392452,0.2615},
{0.40937,0.261296},
{0.39057,0.271932},
{0.378723,0.270928},
{0.385261,0.247817},
{0.411798,0.232195},
{0.442896,0.237315},
{0.422885,0.251216},
{0.429025,0.25062},
{0.414438,0.265962},
{0.393252,0.282392},
{0.375473,0.299229},
{0.366629,0.293439},
{0.367228,0.276414},
{0.366952,0.251935},
{0.378653,0.240716},
{0.385944,0.228238},
{0.407643,0.228104},
{0.434925,0.22602},
{0.446456,0.222869},
{0.453881,0.222949},
{0.450512,0.237003},
{0.625559,0.034058},
{0.613756,0.023409},
{0.615497,0.034643},
{0.632556,0.048009},
{0.624169,0.043268},
{0.611711,0.033626},
{0.602809,0.024122},
{0.607487,0.020106},
{0.61197,0.018156},
{0.620886,0.026449},
{0.638312,0.038357},
{0.640886,0.042122},
{0.635587,0.050879},
{0.631835,0.054296},
{0.619387,0.043393},
{0.608317,0.035819},
{0.602116,0.029293},
{0.593878,0.028705},
{0.600481,0.022677},
{0.609225,0.016903},
{0.385077,0.134213},
{0.368705,0.138982},
{0.38098,0.151793},
{0.398646,0.133465},
{0.391687,0.160035},
{0.386487,0.166371},
{0.377225,0.166489},
{0.359878,0.167955},
{0.35607,0.155698},
{0.365823,0.120493},
{0.378078,0.066007},
{0.39485,0.105066},
{0.418627,0.117384},
{0.427312,0.138407},
{0.402136,0.161727},
{0.401457,0.177616},
{0.387778,0.182727},
{0.375169,0.180709},
{0.356697,0.17912},
{0.338971,0.178664},
{0.341484,0.169571},
{0.34234,0.161079},
{0.355076,0.142193},
{0.352113,0.123851},
{0.344863,0.102978},
{0.380811,0.048395},
{0.398299,0.032348},
{0.398374,0.069041},
{0.41111,0.073097},
{0.435577,0.084844},
{0.452948,0.092652},
{0.448611,0.141984},
{0.431318,0.16898},
{0.42463,0.195481},
{0.407417,0.195474},
{0.384512,0.190828},
{0.37356,0.194437},
{0.364659,0.19016},
{0.35529,0.191801},
{0.334146,0.187941},
{0.331308,0.174994},
{0.325355,0.162597},
{0.332446,0.147754},
{0.33931,0.131595},
{0.334232,0.120464},
{0.339087,0.100966},
{0.335673,0.087799},
{0.350649,0.082453},
{0.366169,0.034835},
{0.386807,0.029741},
{0.391746,0.015703},
{0.3993,0.0148},
{0.401709,0.016612},
{0.411145,0.030675},
{0.435458,0.064552},
{0.452763,0.040308},
{0.467751,0.096449},
{0.460492,0.116487},
{0.454643,0.132395},
{0.469038,0.156547},
{0.463288,0.181513},
{0.440736,0.160564},
{0.434016,0.179054},
{0.427717,0.199262},
{0.422308,0.203597},
{0.420186,0.201691},
{0.406304,0.198912},
{0.381808,0.197735},
{0.371264,0.207518},
{0.357721,0.199032},
{0.348116,0.203855},
{0.336157,0.197288},
{0.320015,0.195735},
{0.322312,0.188448},
{0.3212,0.1861},
{0.303201,0.345426},
{0.290009,0.35834},
{0.307039,0.36443},
{0.316035,0.339701},
{0.318397,0.368919},
{0.30673,0.385259},
{0.303423,0.381405},
{0.278218,0.366965},
{0.280529,0.363278},
{0.273451,0.364362},
{0.290612,0.32949},
{0.297371,0.310126},
{0.319211,0.319593},
{0.339014,0.324612},
{0.335391,0.34879},
{0.33695,0.358208},
{0.333091,0.366557},
{0.319,0.381579},
{0.324425,0.3941},
{0.305712,0.395723},
{0.30045,0.390601},
{0.281388,0.380913},
{0.26933,0.371275},
{0.41811,0.299722},
{0.418704,0.275583},
{0.398569,0.292857},
{0.389481,0.321788},
{0.384638,0.309693},
{0.422625,0.262899},
{0.436556,0.262523},
{0.441789,0.270599},
{0.445963,0.281437},
{0.439155,0.309054},
{0.424164,0.321142},
{0.412433,0.32138},
{0.397059,0.329711},
{0.366954,0.329628},
{0.469104,0.126713},
{0.474168,0.14994},
{0.478012,0.162528},
{0.478865,0.180448},
{0.466536,0.211788},
{0.458874,0.208011},
{0.44646,0.211857},
{0.432655,0.210704},
{0.425629,0.216613},
{0.412258,0.218399},
{0.409652,0.209755},
{0.412053,0.204665},
{0.386221,0.20538},
{0.371942,0.217399},
{0.358102,0.247633},
{0.345058,0.236426},
{0.345861,0.218711},
{0.337352,0.207973},
{0.324817,0.207489},
{0.316403,0.201374},
{0.314673,0.218075},
{0.330589,0.219372},
{0.319326,0.230405},
{0.309644,0.227357},
{0.315438,0.239751},
{0.306923,0.245356},
{0.306182,0.236148},
{0.336787,0.457445},
{0.338577,0.450391},
{0.327448,0.453674},
{0.327608,0.457209},
{0.310734,0.454376},
{0.316342,0.450538},
{0.334391,0.437825},
{0.348229,0.451135},
{0.35279,0.458413},
{0.345158,0.459783},
{0.353647,0.461114},
{0.36173,0.461061},
{0.36158,0.464517},
{0.3543,0.4647},
{0.329362,0.12538},
{0.320432,0.104918},
{0.311686,0.115442},
{0.327169,0.133854},
{0.314745,0.128517},
{0.321663,0.15466},
{0.413152,0.375558},
{0.384011,0.371725},
{0.372034,0.389837},
{0.40816,0.399226},
{0.398317,0.413435},
{0.385022,0.4108},
{0.374114,0.405718},
{0.364198,0.401739},
{0.361043,0.392466},
{0.37611,0.374874},
{0.38646,0.359739},
{0.396132,0.358787},
{0.422096,0.345355},
{0.420766,0.357605},
{0.416049,0.379203},
{0.419381,0.412157},
{0.403589,0.420295},
{0.399716,0.425397},
{0.398801,0.43433},
{0.381255,0.425216},
{0.355511,0.410217},
{0.352394,0.40671},
{0.347439,0.401475},
{0.357292,0.389682},
{0.361541,0.372775},
{0.377249,0.349501},
{0.379893,0.340314},
{0.396353,0.342084},
{0.443245,0.325605},
{0.430083,0.366392},
{0.42385,0.371042},
{0.420154,0.38723},
{0.423109,0.401393},
{0.424393,0.429769},
{0.418428,0.426524},
{0.407865,0.436144},
{0.397631,0.439476},
{0.387098,0.433864},
{0.382099,0.438708},
{0.364119,0.420693},
{0.350578,0.423406},
{0.342859,0.416986},
{0.339495,0.414707},
{0.334255,0.407628},
{0.342212,0.38896},
{0.349275,0.377933},
{0.344353,0.366919},
{0.358346,0.357689},
{0.355382,0.344983},
{0.409021,0.493416},
{0.414612,0.495822},
{0.413447,0.492132},
{0.415382,0.491814},
{0.418068,0.49495},
{0.414604,0.499576},
{0.408656,0.502435},
{0.414475,0.504759},
{0.409093,0.509424},
{0.414878,0.510618},
{0.4109,0.5125},
{0.554548,0.077326},
{0.60356,0.101022},
{0.565982,0.071079},
{0.543388,0.052674},
{0.56347,0.056911},
{0.582878,0.069148},
{0.59641,0.085459},
{0.611473,0.088687},
{0.600174,0.073406},
{0.610586,0.073075},
{0.617579,0.078166},
{0.622026,0.063983},
{0.607137,0.05331},
{0.614857,0.043151},
{0.631066,0.059338},
{0.630471,0.063506},
{0.414851,0.444426},
{0.422153,0.45416},
{0.42638,0.444687},
{0.432107,0.448254},
{0.426819,0.459319},
{0.416719,0.45365},
{0.410682,0.448971},
{0.404424,0.445223},
{0.396417,0.44735},
{0.387921,0.442678},
{0.374397,0.445352},
{0.358674,0.433631},
{0.339981,0.289177},
{0.322508,0.302715},
{0.310032,0.288422},
{0.330056,0.278133},
{0.348492,0.256031},
{0.356461,0.277836},
{0.356322,0.294994},
{0.343918,0.347283},
{0.510502,0.27158},
{0.502253,0.252454},
{0.504525,0.278433},
{0.49705,0.292914},
{0.492944,0.278824},
{0.486231,0.25728},
{0.476236,0.241777},
{0.497011,0.23709},
{0.508047,0.226347},
{0.518422,0.240316},
{0.51548,0.247834},
{0.51725,0.257811},
{0.392709,0.454266},
{0.388626,0.464283},
{0.395953,0.471368},
{0.402682,0.46266},
{0.404206,0.474249},
{0.401109,0.47579},
{0.398514,0.476165},
{0.39202,0.473291},
{0.387081,0.467169},
{0.382476,0.461945},
{0.375653,0.460935},
{0.410018,0.459619},
{0.419105,0.462085},
{0.413968,0.476266},
{0.40653,0.478758},
{0.350942,0.439373},
{0.359822,0.450148},
{0.369314,0.460861},
{0.348401,0.431385},
{0.500575,0.129288},
{0.527104,0.123592},
{0.527102,0.099947},
{0.506478,0.112209},
{0.516891,0.086753},
{0.523075,0.083714},
{0.536639,0.087835},
{0.548065,0.0866},
{0.539069,0.113591},
{0.556642,0.125703},
{0.548037,0.132933},
{0.527836,0.133553},
{0.51268,0.143142},
{0.493745,0.147387},
{0.489877,0.121862},
{0.496178,0.10883},
{0.502941,0.075321},
{0.516832,0.076415},
{0.532428,0.076823},
{0.576556,0.106905},
{0.588326,0.122573},
{0.555486,0.112577},
{0.590685,0.13193},
{0.563918,0.13521},
{0.552279,0.142753},
{0.532871,0.142259},
{0.514137,0.165071},
{0.496708,0.17118},
{0.487315,0.153253},
{0.478619,0.133679},
{0.484722,0.100293},
{0.49265,0.078674},
{0.488301,0.059211},
{0.493921,0.044641},
{0.513297,0.066991},
{0.52559,0.064978},
{0.536666,0.051412},
{0.544852,0.044457},
{0.552879,0.034293},
{0.563394,0.042061},
{0.571285,0.046955},
{0.587822,0.067722},
{0.572048,0.144941},
{0.532308,0.154279},
{0.561863,0.153599},
{0.584831,0.147846},
{0.58263,0.159913},
{0.559297,0.163844},
{0.528435,0.163069},
{0.581292,0.136977},
{0.582839,0.143301},
{0.587189,0.14198},
{0.590892,0.148839},
{0.592036,0.16038},
{0.588359,0.170573},
{0.572499,0.17666},
{0.541053,0.174857},
{0.518089,0.20573},
{0.497513,0.213544},
{0.490479,0.209263},
{0.481655,0.200996},
{0.474621,0.080561},
{0.562894,0.026422},
{0.5567,0.0185},
{0.556162,0.024224},
{0.552915,0.019503},
{0.545632,0.025009},
{0.548524,0.015618},
{0.536682,0.021168},
{0.540805,0.016948},
{0.532779,0.019773},
{0.530091,0.023786},
{0.533099,0.03631},
{0.517933,0.042128},
{0.522617,0.029397},
{0.514617,0.030163},
{0.511369,0.033941},
{0.511463,0.029687},
{0.443731,0.41482},
{0.4464,0.428893},
{0.459815,0.424046},
{0.454997,0.395722},
{0.46607,0.399856},
{0.465936,0.42615},
{0.460671,0.428487},
{0.451865,0.431701},
{0.443016,0.431784},
{0.435708,0.419015},
{0.43759,0.40961},
{0.448376,0.375029},
{0.466883,0.385629},
{0.475706,0.398172},
{0.476546,0.407892},
{0.470087,0.423388},
{0.469336,0.425885},
{0.389915,0.216442},
{0.392896,0.209894},
{0.375623,0.220099},
{0.339419,0.251272},
{0.338109,0.228413},
{0.427856,0.462403},
{0.423816,0.467443},
{0.417951,0.473884},
{0.412906,0.481079},
{0.408504,0.483144},
{0.413559,0.484959},
{0.418092,0.479989},
{0.421,0.4861},
{0.422227,0.478957},
{0.424717,0.475659},
{0.295484,0.064106},
{0.294053,0.054112},
{0.291245,0.071842},
{0.309716,0.07399},
{0.299555,0.084324},
{0.317766,0.095462},
{0.310695,0.096331},
{0.314469,0.100958},
{0.306086,0.102034},
{0.310191,0.103429},
{0.307432,0.10362},
{0.304511,0.105019},
{0.324148,0.099379},
{0.257057,0.446088},
{0.266457,0.445427},
{0.261953,0.438877},
{0.252157,0.444742},
{0.255479,0.434861},
{0.262636,0.425459},
{0.276235,0.437097},
{0.268243,0.442556},
{0.276236,0.445458},
{0.275303,0.448204},
{0.284553,0.447788},
{0.284168,0.451325},
{0.29406,0.450674},
{0.29444,0.454018},
{0.301378,0.452035},
{0.30709,0.456559},
{0.307751,0.448236},
{0.310323,0.444729},
{0.323208,0.436223},
{0.334722,0.428855},
{0.485445,0.3309},
{0.481333,0.296448},
{0.49127,0.319983},
{0.583056,0.195965},
{0.592758,0.184247},
{0.567663,0.194187},
{0.574736,0.206208},
{0.559072,0.232173},
{0.550819,0.206193},
{0.55374,0.185722},
{0.593349,0.173967},
{0.594117,0.181718},
{0.596037,0.184188},
{0.298825,0.407302},
{0.300253,0.397996},
{0.28758,0.394193},
{0.289058,0.401742},
{0.278031,0.390602},
{0.269161,0.382574},
{0.307127,0.410036},
{0.295299,0.409214},
{0.283574,0.40628},
{0.271396,0.393035},
{0.592489,0.011634},
{0.585904,0.009689},
{0.590268,0.024882},
{0.593399,0.020594},
{0.591735,0.039191},
{0.587456,0.034906},
{0.581367,0.026928},
{0.584052,0.015142},
{0.32909,0.094115},
{0.328111,0.090984},
{0.330107,0.08576},
{0.333856,0.080153},
{0.341025,0.076312},
{0.345659,0.052487},
{0.357534,0.026594},
{0.372811,0.024569},
{0.396224,0.003625},
{0.37718,0.003686},
{0.3873,0.0016},
{0.299145,0.422963},
{0.288511,0.414934},
{0.296764,0.430351},
{0.291265,0.424738},
{0.276424,0.424123},
{0.280632,0.410371},
{0.3605,0.0026},
{0.368246,0.013763},
{0.48303,0.377688},
{0.292522,0.444549},
{0.28631,0.43332},
{0.299501,0.445013},
{0.313587,0.424952},
{0.330583,0.41963},
{0.314628,0.410808},
{0.316416,0.402022},
{0.397064,0.222215},
{0.441899,0.216003},
{0.464289,0.22733},
{0.459485,0.231479},
{0.462324,0.253913},
{0.452428,0.251905},
{0.431644,0.256997},
{0.52192,0.052796},
{0.518808,0.048704},
{0.499919,0.042504},
{0.536806,0.046203},
{0.540004,0.043582},
{0.541495,0.039141},
{0.472643,0.25713},
{0.484084,0.27128},
{0.465314,0.238202},
{0.475899,0.233802},
{0.499308,0.223661},
{0.532944,0.210993},
{0.522353,0.230629},
{0.535461,0.228911},
{0.540163,0.237762},
{0.530508,0.248223},
{0.466365,0.266763},
{0.550337,0.253209},
{0.433408,0.040083},
{0.43812,0.012263},
{0.422122,0.010486},
{0.410301,0.016081},
{0.354167,0.334922},
{0.314811,0.06667},
{0.324627,0.093506},
{0.324531,0.089007},
{0.328923,0.080699},
{0.33015,0.074817},
{0.4236,0.5189},
{0.415406,0.500487},
{0.4164,0.5051},
{0.261426,0.411433},
{0.274931,0.415942},
{0.489522,0.379997},
{0.4977,0.3695},
{0.475378,0.038512},
{0.4775,0.0319},
{0.473848,0.02956},
{0.462652,0.034888},
{0.451011,0.038494},
{0.444799,0.040924},
{0.442622,0.037777},
{0.439027,0.042747},
{0.439035,0.033443},
{0.560806,0.029801},
{0.566663,0.032828},
{0.574812,0.032094},
{0.577662,0.041929},
{0.600843,0.060871},
{0.600241,0.038539},
{0.627981,0.05236},
{0.632849,0.057545},
{0.635986,0.057948},
{0.43613,0.4395},
{0.431924,0.432514},
{0.438682,0.443078},
{0.434719,0.450118},
{0.4315,0.4546},
{0.4971,0.0403},
{0.486988,0.045462},
{0.331415,0.240789},
{0.320492,0.261231},
{0.298833,0.270207},
{0.295178,0.289956},
{0.320489,0.096545},
{0.609073,0.012041},
{0.606746,0.009238},
{0.600383,0.006233},
{0.599177,0.016305},
{0.595805,0.005442},
{0.595736,0.017935},
{0.592655,0.006897},
{0.588427,0.005717},
{0.436559,0.378716},
{0.432726,0.403874},
{0.248165,0.439556},
{0.244185,0.442927},
{0.247172,0.444686},
{0.409638,0.485518},
{0.580747,0.035835},
{0.451226,0.44525},
{0.447773,0.436671},
{0.590889,0.138395},
{0.591591,0.144133},
{0.592479,0.152336},
{0.592299,0.155317},
{0.491047,0.297192},
{0.639319,0.049741},
{0.485074,0.394473},
{0.489823,0.393197},
{0.342066,0.066661},
{0.338473,0.072056},
{0.36911,0.464359},
{0.377145,0.465141},
{0.379297,0.467238},
{0.59415,0.17009},
{0.5932,0.16585},
{0.59721,0.16484},
{0.256485,0.421963},
{0.255884,0.426991},
{0.253649,0.42364},
{0.438984,0.433195},
{0.268158,0.369173},
{0.269082,0.364892},
{0.605178,0.01624},
{0.473419,0.218343},
{0.290085,0.316128},
{0.558215,0.240445},
{0.593602,0.127061},
{0.595839,0.122065},
{0.494894,0.309125},
{0.318114,0.457599},
{0.6097,0.0143},
{0.324827,0.071017},
{0.3209,0.1808},
{0.324278,0.175218},
{0.601626,0.110144},
{0.6439,0.048},
{0.645084,0.044013},
{0.643642,0.040328},
{0.287209,0.047662},
{0.2858,0.0412},
{0.2802,0.04258},
{0.2789,0.0447},
{0.251293,0.435521},
{0.264837,0.395361},
{0.263567,0.401119},
{0.303161,0.050664},
{0.535129,0.183737},
{0.267566,0.366068},
{0.2818,0.3438},
{0.328057,0.459568},
{0.1429,0.349876},
{0.1387,0.3483},
{0.138696,0.348299},
{0.138601,0.351922},
{0.138195,0.34681},
{0.135496,0.329242},
{0.138,0.3456},
{0.138,0.3456},
{0.183081,0.308419},
{0.181288,0.304985},
{0.174311,0.305399},
{0.169475,0.3242},
{0.162072,0.315831},
{0.167254,0.306819},
{0.170497,0.303221},
{0.175895,0.299815},
{0.179346,0.300799},
{0.184288,0.304127},
{0.07081,0.383693},
{0.093107,0.37667},
{0.068281,0.35925},
{0.061368,0.371852},
{0.049067,0.360979},
{0.056279,0.352289},
{0.064695,0.343433},
{0.079765,0.36138},
{0.09715,0.373521},
{0.111048,0.382863},
{0.104146,0.389863},
{0.100597,0.393101},
{0.087977,0.343448},
{0.099188,0.358142},
{0.137533,0.357933},
{0.143558,0.360298},
{0.141301,0.373196},
{0.133603,0.376388},
{0.117762,0.374675},
{0.107901,0.366565},
{0.098229,0.368834},
{0.09289,0.362754},
{0.088657,0.357901},
{0.085632,0.348841},
{0.080352,0.340244},
{0.081675,0.330862},
{0.08407,0.33115},
{0.120802,0.31163},
{0.129074,0.314895},
{0.133978,0.324553},
{0.134883,0.327097},
{0.1349,0.327095},
{0.118264,0.377233},
{0.112268,0.379482},
{0.11949,0.387578},
{0.102822,0.372767},
{0.091133,0.365018},
{0.083775,0.35694},
{0.082707,0.350383},
{0.078546,0.344251},
{0.074948,0.335357},
{0.075217,0.326943},
{0.078983,0.320852},
{0.08321,0.314346},
{0.108179,0.291201},
{0.114574,0.291261},
{0.124383,0.305994},
{0.13117,0.303206},
{0.135813,0.309039},
{0.13789,0.314362},
{0.140211,0.318994},
{0.143069,0.331879},
{0.135502,0.32921},
{0.164744,0.337703},
{0.157563,0.338895},
{0.150571,0.312974},
{0.160548,0.306297},
{0.159262,0.303329},
{0.148875,0.303441},
{0.146628,0.298533},
{0.163538,0.302412},
{0.165249,0.279952},
{0.176252,0.292294},
{0.180145,0.29454},
{0.182897,0.296519},
{0.186459,0.299377},
{0.186086,0.296365},
{0.183961,0.29202},
{0.188462,0.294857},
{0.067249,0.271747},
{0.07649,0.269496},
{0.067768,0.265341},
{0.06066,0.262353},
{0.069765,0.26008},
{0.072635,0.254328},
{0.088133,0.259471},
{0.098616,0.27275},
{0.093462,0.280733},
{0.080968,0.286541},
{0.06736,0.280736},
{0.060179,0.278655},
{0.058239,0.259762},
{0.06413,0.255226},
{0.070898,0.24738},
{0.074591,0.252366},
{0.089797,0.250695},
{0.090827,0.253496},
{0.09832,0.261603},
{0.107667,0.275774},
{0.103148,0.279569},
{0.09487,0.283218},
{0.082371,0.291314},
{0.071165,0.288217},
{0.063103,0.287574},
{0.058733,0.285388},
{0.056247,0.272039},
{0.058724,0.254063},
{0.063901,0.25085},
{0.071487,0.24434},
{0.079817,0.244622},
{0.087186,0.246544},
{0.098634,0.248655},
{0.102339,0.258639},
{0.112295,0.273337},
{0.111155,0.278816},
{0.104894,0.28314},
{0.096751,0.286785},
{0.091263,0.288624},
{0.081888,0.300613},
{0.069973,0.292858},
{0.063352,0.29129},
{0.057892,0.290727},
{0.036824,0.261626},
{0.048708,0.256741},
{0.055832,0.238549},
{0.090384,0.237285},
{0.101884,0.225241},
{0.089921,0.227018},
{0.07985,0.226975},
{0.083904,0.224176},
{0.072151,0.225074},
{0.062637,0.229202},
{0.04924,0.237715},
{0.040933,0.2524},
{0.043786,0.24122},
{0.0393,0.2474},
{0.125659,0.259729},
{0.119248,0.24114},
{0.107963,0.253589},
{0.118039,0.272857},
{0.112805,0.266814},
{0.068511,0.338965},
{0.072888,0.332341},
{0.071898,0.328565},
{0.068989,0.321331},
{0.070829,0.317626},
{0.075561,0.313942},
{0.072616,0.306212},
{0.111204,0.285388},
{0.119573,0.286333},
{0.126177,0.295704},
{0.125401,0.288881},
{0.137169,0.288416},
{0.144819,0.318567},
{0.146225,0.330444},
{0.151835,0.347052},
{0.14563,0.35257},
{0.13899,0.258691},
{0.147765,0.28026},
{0.127469,0.267816},
{0.116906,0.276917},
{0.1258,0.3858},
{0.153394,0.265981},
{0.153605,0.375284},
{0.148768,0.361451},
{0.144113,0.369093},
{0.145773,0.378487},
{0.156249,0.361713},
{0.159302,0.369787},
{0.1596,0.3734},
{0.065682,0.295571},
{0.060795,0.293974},
{0.049974,0.309772},
{0.037323,0.285088},
{0.038502,0.359804},
{0.04393,0.362559},
{0.044433,0.360535},
{0.049417,0.355548},
{0.172493,0.339785},
{0.175758,0.325829},
{0.110525,0.391956},
{0.031079,0.33912},
{0.034975,0.356067},
{0.055584,0.348473},
{0.029723,0.305831},
{0.02928,0.31323},
{0.033407,0.304653},
{0.032428,0.317756},
{0.054909,0.326556},
{0.031697,0.330468},
{0.033687,0.291926},
{0.061113,0.304931},
{0.064404,0.311615},
{0.065248,0.306364},
{0.061537,0.297274},
{0.066522,0.324693},
{0.031086,0.351984},
{0.02838,0.344262},
{0.027365,0.338421},
{0.0335,0.3565},
{0.178725,0.289917},
{0.180756,0.288232},
{0.1763,0.285},
{0.153054,0.33192},
{0.148718,0.260011},
{0.142899,0.252346},
{0.137432,0.247646},
{0.1248,0.2354},
{0.0503,0.3715},
{0.1618,0.273}
};


// normal array: 44kb.
const tgx::fVec3 dennis_norm_array[3839] PROGMEM = {
{0.5949200312946862,0.09520320554589701,0.7981268733842479},
{0.23289010936707832,0.23469003292594798,0.9437599193673187},
{-0.3118093653349339,0.13130394377317775,0.9410282642083797},
{-0.44018370029936127,0.11989556034959886,0.8898670488332613},
{-0.4411967792752669,0.1545988714323578,0.8839935468706618},
{-0.9876087996336073,0.04310038402613252,0.15090134453696977},
{-0.7407224960838142,-0.2486075503259568,0.6241189547804893},
{-0.7546684366526918,0.07699677967703361,0.6515727485396765},
{-0.9996629231897556,0.007999703296506996,0.02469908392796535},
{-0.636756415514986,0.2814807333031855,0.7178508647899001},
{0.18559446194388213,0.14159577484511698,0.9723709848827101},
{-0.603280508321659,0.07729750255803787,0.7937743535649477},
{0.3686893192251309,0.0814976390475947,0.9259731749456772},
{-0.21529224423659954,0.08359698847273442,0.9729649495690262},
{-0.9262064973613686,-0.012700089091437466,0.376802643279814},
{-0.5314007625606414,0.11410016373385243,0.8394012045415927},
{-0.8860501297041722,0.012300695931559049,0.46342621908003767},
{-0.7271676272178382,-0.6117727644827743,0.3113861373977377},
{-0.917962309241358,-0.16959303665286962,-0.35858527679079627},
{-0.9104294210021172,-0.36801189249646216,0.18890610459940682},
{-0.6897854594757697,-0.1715963827863759,-0.7033851727968345},
{-0.18851108383502072,-0.4450261660826749,0.8754514736826372},
{-0.22640816329349397,-0.616222218292628,-0.7543271977574315},
{-0.746294488635552,-0.20019852153937762,-0.6347953120539307},
{-0.717898847773274,-0.5917990501632867,-0.3665994116084166},
{0.11659828543481893,-0.5443919947745749,-0.8306877848259355},
{-0.6384042485944116,-0.704204686497783,-0.3107020677291411},
{-0.06959642944677849,-0.9942489913639635,-0.08139582409436451},
{-0.27850964356336544,-0.4975172268322237,0.8215284459149181},
{0.4557888241950444,-0.44858900073255137,0.7687811497173106},
{0.5582068548222661,-0.7014086133506583,-0.44320544259625283},
{0.5541044716411293,-0.5792046742005813,-0.597904825111408},
{0.756305619371628,-0.3516026124171155,-0.5517040991766854},
{0.7189176172920703,-0.08630211485923726,-0.6897169017197675},
{0.9969778224750058,0.06899846514621405,0.035699205879997704},
{0.9669751007117309,0.06849823619312675,0.2454936786191623},
{0.493184080274829,0.06659785025609005,0.8673720016836712},
{0.9921943246646943,0.04259975633009068,0.11719932962175184},
{0.4584942826119435,0.13299834152102177,0.8786890428159537},
{-0.5589990133676123,0.14829973825119297,0.8157985601168122},
{0.945929258044434,0.14980463352897366,0.28770889897387003},
{0.8668414620187163,0.24871189617449785,0.4321206688258967},
{0.8032795086011001,0.06819826028456992,0.5916849063105576},
{0.8627463091509989,0.1270068172738807,0.4894262706601355},
{0.8392706134539459,-0.03349882705910543,0.5426809983575079},
{0.9622623810875527,0.00429983190135766,0.2720893628742836},
{0.9440900823857765,-0.1653982625003786,0.28519700402120907},
{0.7732040322695425,-0.13230068994989716,-0.6202032343683009},
{0.9983391057086709,0.026601041983222124,-0.051102001704610926},
{0.9902780457790851,0.06879847475472185,-0.12089731973613185},
{0.9815675450056777,-0.07659746734661257,-0.1750942106056379},
{0.813137218142231,-0.016900773566109584,0.5818266308143525},
{-0.6152384997537208,0.15250954358329394,0.7734484000479969},
{-0.1994011355927008,0.29390167377479826,0.934805323731478},
{-0.9981406151679636,0.030101224843758843,0.053002156701635175},
{-0.9850526644315388,-0.013899332083644694,-0.1716917495512082},
{0.5325123171523453,0.20700478807612294,0.8207189834496333},
{0.34531543939845094,0.2800125196396359,0.8957400494329353},
{0.6952056694253513,0.2424019767961812,0.6767055185560058},
{0.43019520550115187,0.3568960224159951,0.8291907587204909},
{0.7144934445527192,-0.02769974585599765,0.6990935858457747},
{0.4549825176326336,0.2587900561831331,0.8520672599445429},
{-0.8772021359898018,-0.08520020746275776,0.4725011505417024},
{0.8562201342531883,-0.47471116296424726,0.20380479252604508},
{-0.913168181209079,0.2755903972199104,0.30028953659339297},
{0.8516993314162873,0.3567997199123298,0.3837996987173547},
{0.6024887606770035,0.4390918088187091,0.6664875667904113},
{0.9781961801513748,0.19389924282493515,0.07439970946970177},
{0.9434847628441192,0.3086950146157706,0.12059805235718153},
{0.341310975030856,0.21500691365846483,0.9150294232441643},
{0.25170916993209397,0.18200663062233255,0.9505346286072918},
{0.5882057262106171,0.2700026284883826,0.7623074210988667},
{0.9799615029685189,-0.1400944964958056,0.14159443757177784},
{0.8893871039804877,0.07599889802396792,0.4507934635421676},
{-0.9076460012074394,0.4148753177271859,0.0636962105066805},
{-0.9291498920429658,0.32661753819958306,0.17320930072311017},
{-0.9408446676609209,0.33651597647523374,-0.03960188014389081},
{-0.9237489735160157,0.3709795076579799,0.09519474158770806},
{-0.9822167076482969,0.17550298533117095,0.0667011345959493},
{-0.38401375561909384,0.4350155825372547,0.8144291733754948},
{-0.5659972718997242,0.2329988769481197,0.7907961883715581},
{-0.25930281734041566,0.28330307810466554,0.9233100318179939},
{-0.36561481135601814,0.29091178507512494,0.8841358170674388},
{0.9861255557749211,-0.0490012698843638,0.1586041102787775},
{0.9881087200979324,-0.03050026916606309,0.15070132994510516},
{0.8895149172902455,0.02700045280139025,0.45610764898941086},
{0.9180114935758498,0.07900098909857531,0.3886048653633717},
{0.6288198427232107,0.42161330421772514,0.6533206158573052},
{-0.9466285270805018,-0.035101057786314824,0.3204096556904636},
{-0.10359499233910255,-0.3115849383481115,0.9445543413466821},
{0.23979892930017102,0.0699996874520933,0.9682956765694563},
{-0.25180379722989354,0.11080167090179588,0.9614144982399511},
{-0.49902194497255586,-0.038401688751395074,0.8657380716688209},
{-0.6636809294024865,0.14269589969223268,0.734278900798924},
{-0.8509751689068517,0.08059764819493802,0.5189848562428391},
{-0.9047684965094178,0.17959374665461034,0.38618655321832135},
{0.7557792465868292,-0.20719431052234852,0.6211829425505931},
{0.7780828590234214,-0.16579634754669487,0.6058866524640676},
{0.6910028054770854,-0.048800198129206614,0.7212029280898321},
{0.6572961844067242,-0.2363986277099492,0.7155958459781712},
{0.4676759363537764,-0.0600969077931622,0.8818546253375997},
{0.6009971001959873,-0.15079927239526603,0.7848962128849093},
{0.16920104820374043,-0.4236026242263856,0.8899055129817294},
{0.07569933611973334,-0.24409785927116126,0.9667915212755375},
{-0.5333773079451399,-0.38678354464413217,0.7522679954389365},
{-0.8868138610089722,-0.19210300259339597,0.42030656944302097},
{-0.9715870731199877,-0.03929947712393528,0.23339689467497438},
{-0.9645919553366387,-0.0695994195432615,0.25439787833054206},
{-0.6867288397832028,-0.349414673977357,0.6374267692992769},
{-0.8287519627846754,-0.26448466959042793,0.4931714141474444},
{-0.8325878567946624,-0.23749653613828045,0.5003927018256654},
{-0.9827200968314724,-0.005900120658701219,0.18500378336605516},
{-0.783443979862249,0.025601437177015032,0.6209348571565872},
{-0.7355973628881812,0.06699975980629165,0.6740975833644955},
{-0.8157565050226974,-0.25818623387700473,0.5175724037751265},
{-0.9493156590909462,-0.1846030450523424,0.2544041964318305},
{-0.9440261593273174,-0.26330729634627403,0.1987055062058665},
{-0.9655193829961725,-0.25040502693137395,-0.07120142938304244},
{-0.04240121354009753,-0.23100661150383323,0.9720278198343112},
{0.474283888849939,-0.4346852339933976,0.7655739938931336},
{0.4025874374550183,-0.5002843888692141,0.7665760793666592},
{-0.16280104437204948,-0.4003025679492101,0.9018057851026672},
{-0.0075001623802733175,-0.6309136594285916,0.7758167966154721},
{0.16049641294525557,-0.6132862932045186,0.7733827150894744},
{0.16929130711456378,-0.4760755541479257,0.8629556883630746},
{-0.374813583490403,-0.3948143083298055,0.8388303997645412},
{0.5311026634865361,-0.2876014423248499,0.7970039969850673},
{0.635176009855153,-0.4262838995611646,0.6440756737211966},
{0.6680897983466684,-0.6737897113096618,0.3156951793714162},
{0.4993034501987614,-0.6940047955897063,0.5187035842541509},
{0.05369959537507326,-0.2806978849494053,0.9582927792911119},
{0.2014974420062105,-0.33149579168763665,0.9216882992413112},
{-0.36221185538804346,-0.3489114200576708,0.8643282899279016},
{-0.6297604617305763,-0.08919440010537855,0.7716515533780339},
{-0.500104868544593,-0.25160244936176684,0.8286080665387918},
{-0.6481205911182749,-0.48061526938966664,0.5907187674333668},
{-0.09300302962303575,-0.6539213018333665,0.7508244585051101},
{0.4730890859606789,-0.3541918288887602,0.806681390074994},
{0.28488372505766785,-0.385677966847113,0.8775498670081058},
{0.09569907842231215,-0.40139613457383594,0.910891228159709},
{-0.8059113432819855,-0.30100423666444676,0.5098071755864949},
{-0.49338084239382757,-0.5550784467223625,0.6696739970635311},
{-0.5345940312909607,-0.5005944108946033,0.6808923978788162},
{-0.7653762086503253,-0.11849631659924686,0.632580336545853},
{-0.8552769292159973,-0.43308831760019695,0.28449232592301094},
{-0.7919402870271277,-0.6031306820382127,-0.09520484319356302},
{0.23439999062400058,-0.41859998325600106,0.8773999649040022},
{-0.22949411928853888,-0.3787902936230873,0.8965770255080783},
{-0.040698827483670055,0.0006999798338714751,0.9991712142919684},
{0.4570003518904065,-0.08390006460307463,0.8855006818357876},
{0.5167052213326425,0.10330104386232238,0.8499085883696784},
{0.5518913629677537,0.04879923629792786,0.832486971680839},
{-0.19210499287364802,-0.29200758937587307,0.9369243509803271},
{0.20879960223713664,-0.6500987615630389,0.7305986082109771},
{-0.06719861269896109,-0.6952856459760067,0.7155852268954845},
{0.219808633153604,-0.6550257266406307,0.7229283935702472},
{0.508980236681107,-0.477081475285965,0.7164721799253698},
{0.7914262520441777,-0.16590550317681207,0.5883195148819684},
{0.5400060643021534,-0.5377060384727183,0.6475072715474894},
{0.6818206867534589,-0.04980151100076599,0.7298221431397394},
{0.2553969786716134,0.016899800076547632,0.9666885641419288},
{-0.5650955866207027,-0.3480972813708487,0.7479941581884367},
{-0.7599024506893552,0.06770021833355619,0.646502084972586},
{-0.7771857426583253,-0.03689932308812687,0.6281884759881111},
{-0.6365932012209162,0.27159709935846815,0.7217922912994931},
{-0.546801998564957,0.3543012949735997,0.7586027726982014},
{-0.8410545758690029,0.14349225019284498,0.5215718306661181},
{-0.7257047787817024,-0.3497023027972459,0.5925039016510386},
{-0.4980922746487298,-0.6014906709520398,0.6245903126793749},
{-0.8134044371333069,-0.20520111937515928,0.5443029691807953},
{-0.558467034663887,-0.8289510684626004,-0.030898176134492583},
{-0.3990090376570556,-0.8259187072705819,0.39830902180151684},
{0.09220278548822504,-0.9957300814601482,-0.004500135951160657},
{0.13029845857835246,-0.7753908271807712,0.617892690372709},
{0.2319896198566841,-0.9656567926534475,-0.116994765186345},
{-0.6626791292494812,-0.441286101913077,0.6050809432757825},
{-0.9751831099748016,-0.06579886037360741,0.2113963386471217},
{-0.5619040625810587,-0.8217059409554297,0.09520068830346468},
{-0.3842975904616617,-0.881394473673975,-0.27469827764719873},
{-0.23329587186607068,-0.7254871626182352,-0.6474885427916021},
{-0.39420984551383914,-0.8421210322354235,0.3680091911443247},
{0.45409452592348476,-0.8908892603946984,-0.010699871013832386},
{0.2821988966044714,-0.9592962491589986,-0.010699958163245371},
{0.29089175915319315,-0.9403733596000785,0.17629500563323464},
{-0.6031115014459999,-0.36350693214329455,0.7100135400873153},
{-0.5333016905690386,-0.4669014800800378,0.7054022361286328},
{-0.45458659898459,-0.44878676996102945,0.7693773190909449},
{-0.2611929661681303,-0.34409073376130805,0.9018757128140764},
{-0.3891871648189529,-0.32058942713503674,0.8635715198809037},
{-0.5474892008820178,-0.6851864848298788,0.4803905243903586},
{-0.6446784487596809,-0.4445851377672625,0.6218792109254623},
{-0.6498921688465478,-0.15529812866882423,0.7439910349620427},
{0.7604597195154575,-0.3787799365581267,0.5274720605449097},
{0.8877528393830784,-0.3669805046785196,0.2778852377388572},
{-0.42822067285198495,-0.6814328969671708,0.5935286532873728},
{-0.31080137840716987,-0.6125027164555712,0.7268032233794435},
{0.6103035946987592,-0.7863046313479181,0.09620056662300612},
{-0.9857396768205041,0.15740633573252244,-0.05950239501960028},
{-0.9398828425953112,0.2722950292996098,0.2060962377475196},
{-0.9569886023336189,-0.19709765258093656,0.2128974644062983},
{-0.9348199212247843,-0.24970532127709524,-0.2525053809470026},
{-0.9591072077177492,-0.22600169840914536,-0.17040128057043527},
{-0.12509705587543454,-0.5058880940638076,0.8534799135865979},
{-0.8834991253362988,-0.44179956261864956,-0.1556998458572289},
{0.7893756323503383,-0.6122810991741982,-0.04469862017489247},
{-0.6319310759747604,-0.77483810360064,0.017000836036668663},
{-0.7372158871735547,-0.669514428191393,0.09090195895832355},
{-0.9006701207643574,-0.40848644868684353,-0.14809508702698052},
{-0.8857166029133339,-0.45690856483132236,-0.08210153900777319},
{-0.9576920080935385,-0.22439812740544013,0.18019849624982315},
{-0.8894147377243071,-0.37350618904882926,-0.2635043663035248},
{-0.46658736498523207,-0.8701764359411679,-0.15839571070223052},
{-0.4798130582900744,-0.8203223253758818,0.311208469653754},
{-0.8552697368157846,-0.4787830585612039,0.19819298706522684},
{-0.8485704448061022,-0.44008467211780056,0.2936897709634129},
{-0.956541371308983,-0.12980561421422476,0.2611112933076586},
{-0.8267432439363408,-0.4545237744878032,-0.3315173404680017},
{-0.5146202738650412,-0.8554337004744583,-0.05830229686422834},
{-0.7262145934288838,-0.6869138036715785,-0.027600554638718255},
{-0.9890865979673957,-0.11649842145708383,0.09019877781484087},
{-0.9002568517231206,0.2610874863766598,0.3483833023884652},
{-0.995092307966189,0.09759924556074771,-0.016299874002460937},
{-0.5521111610399319,-0.620412541766299,-0.5570112600964355},
{0.03979980776739272,-0.6980966282014286,-0.7148965470580164},
{-0.0019000880616218713,-0.9279430065152285,-0.3727172739823533},
{-0.06280089900130384,-0.7652109540732118,0.6407091718174422},
{0.690890445051217,-0.3358953545993686,-0.6401911462176713},
{0.9651156446514007,-0.14590236509650747,-0.2174035241396897},
{0.8506810683034849,-0.26689406033878,-0.45288992104695935},
{0.10149743519221863,-0.5449862283720114,-0.8322789685761928},
{0.9112999544350036,-0.3620999818950014,-0.19599999020000078},
{0.9768547824386571,-0.2138900992564528,-0.002399888911713355},
{0.9170183222091184,-0.34200683336479665,0.20520410001887796},
{0.9899801164490398,-0.015099696725636871,0.14039718015095473},
{0.9282477317255795,0.06840351739929933,0.36561880060210283},
{0.9420710317611531,0.06779791524615877,0.32848989909090204},
{0.7123195926198462,0.2987082160824766,0.6351174691462366},
{0.8682410123328491,0.2023095563175943,0.45302139897118254},
{-0.8821547923357809,0.15440959067752474,-0.4449276353136707},
{-0.9800808200060269,-0.19679614873705348,0.026699477496338046},
{-0.9735963976999928,0.0799997040016428,-0.21379920894439036},
{-0.9189423412438318,0.08900410095842967,0.38421770323852444},
{-0.6957077015268841,0.6351070306737445,0.33560371515369025},
{-0.7852623593509351,0.6186703447477697,0.024698816090625363},
{-0.9526944648612388,0.11629932430288871,0.280798368566218},
{-0.8215256278916995,0.37441167995453717,-0.43001341447770025},
{-0.6929063539803991,-0.3110028519092281,-0.6505059651670511},
{-0.49551947182022527,-0.4596180610465702,-0.737028962122111},
{-0.316597673015655,-0.20249851164140917,-0.9266931888300931},
{-0.37019539479793284,-0.9019887793293773,-0.2221972358835783},
{-0.3983940141749052,-0.856487131377526,-0.3281950689061343},
{-0.7700856726893383,-0.36559319820182057,-0.5227902735774393},
{-0.8064110801643627,-0.4370060045037531,-0.398405474128822},
{-0.9169208556020436,0.23030523835222014,0.3259074128484088},
{-0.6589999176250155,0.39929995008750935,0.6373999203250149},
{-0.3565028270786281,0.5342042362563904,0.7665060784173029},
{-0.658708978264561,0.4679063776073905,0.5892080309601934},
{-0.5101084831746134,0.5372089338588557,0.6717111706496526},
{-0.994839187487408,-0.08130320259622664,-0.06070239111427991},
{-0.515571157178395,-0.8017551470629113,0.30228308924559505},
{0.3178059620957739,-0.894016771911963,-0.31580592457471807},
{0.8781627052218469,-0.4132824482671252,-0.24088976962872116},
{0.7768083740394084,-0.593406396955439,-0.21080227246074573},
{-0.9197175391807099,0.24790472758823312,0.3044058050740547},
{-0.7864384735112093,0.5494268786203693,0.28221380623710995},
{-0.44219927479378396,0.33699944732135956,0.8311986368353533},
{-0.2410922887864628,0.2375924007285921,0.9409699035589443},
{0.5281790607561963,0.31618746499642036,0.7880687576333932},
{0.31420594483271486,-0.05740108603882187,0.9476179291008294},
{-0.20860613206737952,0.4134121524288336,0.8863260539372888},
{-0.4059015708421187,0.7959030801508803,0.4492017384140915},
{-0.5308918004394629,0.809787492928757,-0.24979614192838168},
{-0.7721951583515355,0.4402972393449639,-0.45809712774001354},
{-0.8468927633322557,-0.05219955395671715,0.52919547804396},
{0.061597577722883136,-0.057197750742677196,0.996460814948913},
{0.5486080179647742,0.5609081977332152,0.6200090614986512},
{0.27301580124675895,0.49622872006828495,0.8241476989284031},
{0.7808998321065541,0.3120999328985216,0.5410998836635376},
{0.9368779742577349,0.23709442597556724,0.2569939581430653},
{0.9248857106261554,0.056699124005301124,0.3759941909346247},
{0.9606107685070727,-0.19590219607592707,0.19710220952815327},
{0.786626714296834,-0.539418318957173,0.3004102021036981},
{0.2728981306542075,-0.6204957496186727,0.7351949639317455},
{-0.49198951827496856,-0.47348991240487315,0.7305844350644147},
{-0.5980965131074928,0.5536967719572291,0.5793966221275395},
{0.9234241709440159,-0.3472090883168316,0.16350427978053564},
{0.9862234526725602,-0.16540393335230322,-0.0022000523178661857},
{0.9373034633426955,-0.12940047813565006,0.3236011957086272},
{0.9527903101718181,-0.26649728973634507,0.14549852028757299},
{0.9855976148566581,0.06479984318456923,0.15619962199737214},
{0.9731764056240649,-0.18729545907664133,-0.13359676098579437},
{0.9163773382686335,-0.39909013062310306,0.031299225979712166},
{0.67079351681199,-0.7029932056035018,-0.23629771619360948},
{0.8690327414253114,-0.20580775395319806,0.4499169509404461},
{0.8992551687510649,-0.36888160986574875,0.23508827996594617},
{0.1398935741362547,0.4568790137444944,0.8784596488827716},
{0.04250031407848157,0.4371032302048069,0.8984066392495962},
{0.014600096871964119,0.4034026765856387,0.914906070421916},
{0.5928862778058985,0.16979607011543527,0.7871817808885196},
{0.853577154313193,-0.40238923019637873,0.33089114381705204},
{0.5232896572821347,-0.2707946477966789,0.8079840303534586},
{-0.44211183549225636,0.13380358196983466,0.8869237432664152},
{-0.682505443002612,0.45320361431323625,0.5734045729197036},
{-0.7918081675433726,0.08930092114375243,-0.6042062324194313},
{-0.8662892840678338,0.44529449174120556,0.22639719948396347},
{-0.6472117987786387,0.6643121105201633,-0.3739068163833946},
{-0.6494029190726819,-0.7059031730418942,-0.28280127119457105},
{-0.47730952003331656,-0.8119161938299805,-0.3361067037150591},
{0.23689660529596895,-0.9583862664232023,-0.15929771728006692},
{0.07330066154145563,-0.9175082805495981,0.3909035279202593},
{-0.7182145188532494,-0.4303086987782696,0.5468110538971829},
{-0.9917843299313797,0.11799813564418511,0.049399219498497834},
{-0.17269722909518856,-0.9393849276897518,0.2961952475853784},
{-0.8707050370432089,-0.440502548314613,-0.2187012651904787},
{-0.02420120754937676,-0.9976497789776141,0.06410319850888639},
{-0.7112807174411218,0.5962838349643482,-0.3721899100683052},
{-0.5997209726091246,0.8001279809647501,0.011400398678912824},
{-0.8510228162275586,0.4667125127302017,-0.2407064534265257},
{-0.9382945672901831,-0.3437980094152882,0.03749978287688571},
{-0.884026994176407,0.4398134299081265,0.15830483391190636},
{0.3109980998074153,-0.8710946776277796,0.3800976776102847},
{0.4905042625005618,-0.47190410086445483,-0.7326063663769858},
{0.29489919492629674,-0.4603987431131469,-0.8372977141803604},
{0.3063877125671763,-0.9129633863375716,0.26948919235265667},
{0.14039835664685313,-0.9009894539801615,0.41049519518186045},
{0.14610100736991874,-0.8294057187721465,-0.5392037178224517},
{-0.12340209970458986,-0.47200803128497903,-0.872914852772581},
{0.1781942506552524,-0.8926711984284166,-0.413986642936445},
{-0.1407989911788423,-0.40369710752058685,-0.9039935229096124},
{-0.5503033320967639,-0.37740228517775515,-0.7448045098049604},
{-0.5515159004326174,-0.39721145177123424,-0.7335211477195376},
{0.576409969096624,-0.6669115343347304,0.4722081669108707},
{0.8733862137074241,-0.11849812952178813,0.4723925433425546},
{0.7044637245744805,-0.12149374384073722,0.6992639923277987},
{-0.463725554300774,0.37832084794475485,0.8011441482647187},
{0.34099158272666935,-0.9385768315168674,-0.052898694211849874},
{-0.49969336911298756,-0.7461900981230964,0.43989416264319237},
{-0.8944204779912681,0.39220897972738744,0.21490492030447622},
{-0.6938262236576941,0.5814219752588403,-0.42491606000598764},
{-0.8552851395497993,0.48789152295843224,0.17449696814151758},
{-0.7529256224949077,0.6267213276896781,-0.20080683357282172},
{-0.7755330810691244,0.37881615874788443,-0.5050215421533306},
{-0.5473907683325374,-0.6668887530160198,-0.5055914732717044},
{-0.4539272682300285,-0.843750685626074,-0.28641720559832595},
{-0.8543117340522514,0.3048041865142529,-0.42100578255413534},
{-0.173394550294925,-0.5080840311698466,-0.8436734837591017},
{0.3106857491715207,-0.8114627790559674,0.4949772959121428},
{0.7106221682043111,-0.6850213695749411,-0.16050500703179274},
{0.4447935305251474,-0.8362878362818813,-0.3205953369747353},
{0.7328926308016457,-0.6252937127033279,-0.2680973042951579},
{0.8009996956201736,-0.5329997974601155,-0.27259989641205906},
{0.8660242966524686,-0.395811104636313,-0.30550857116319763},
{-0.2993996586845836,-0.4123995298648039,-0.8603990191456773},
{0.8585926805285976,-0.48469586798533804,-0.16699857634320497},
{0.9124955561574621,-0.3942980797730272,0.10899946917387768},
{0.7000666741191989,-0.7023665646355168,-0.12879386891380207},
{0.6562067852132388,-0.6842070747377293,0.31820329023903166},
{0.09020278324981643,-0.951629362976999,-0.2937090625329389},
{0.6601218470940503,-0.747424736430985,0.0748024756288971},
{0.47527138239528766,-0.6524607132609408,-0.5902644582956834},
{-0.6927044263954271,-0.6033038551239513,-0.39520252535220557},
{0.8763610334729507,-0.29738677699093513,-0.3788831533351221},
{0.5828747241856166,-0.7445677125212046,0.32538588994681705},
{0.18539314336138685,-0.42088443387706426,-0.8879671591419175},
{0.03139807912427696,-0.5457666110200754,-0.8373487725690933},
{0.9706385302612033,-0.23200920978837747,-0.06350252078259469},
{0.9247624137955214,-0.36548514515815644,0.10599569189265276},
{0.3891101831467412,-0.8977234937312505,0.20660540693425014},
{0.3032864236871087,-0.8457621403051648,0.4389803494844731},
{-0.36472050333940903,-0.5172290768498556,-0.7742435253231984},
{-0.989822429630386,-0.1270028779178208,0.06420145482144955},
{-0.9986313125757165,-0.00020000627129495622,0.05230163994363105},
{-0.9823241507361224,-0.14730362150405255,-0.11550283967222046},
{-0.9646511995301925,-0.12219381837108897,0.23348818813133615},
{-0.9902807441781424,-0.09279819555663094,0.10359798555675609},
{-0.9974597533109146,-0.07019716760142977,-0.012099511794548438},
{-0.960833029203078,-0.12060414583877103,-0.24950857700475434},
{-0.9701458065156575,-0.24161140795194608,-0.0210009915852271},
{-0.911172355450097,0.3849883196315708,-0.14679554629068728},
{-0.8943880644709189,0.32829561892419795,-0.30379594587015335},
{-0.915232541671539,-0.03710131916085456,-0.4012142654268154},
{-0.9856477755055463,0.07990387303459126,-0.14870720801306284},
{-0.975035623577273,0.2212080819849157,-0.019300705164144998},
{-0.9644776484894915,-0.12429711944763482,0.23309459809528302},
{-0.8406365937074034,-0.27031176692732706,0.4693204299629841},
{-0.9269934322747984,0.11989915051752786,0.3553974820177598},
{0.7456233048205939,0.520716275241528,0.41581299643830866},
{0.6454774280490048,0.38648648480393555,0.6587769629724004},
{0.7909862171852472,0.2511956229544046,0.5578902788465858},
{0.9242855211807153,0.27199573922011744,0.26779580501157146},
{0.8818919660007843,0.17189843401239915,0.4389960007646494},
{0.7497852143813571,-0.057398868105481324,0.6591870009605103},
{0.7307017061904759,0.16280038013933143,0.6630015481104222},
{0.5765855480643544,0.44008896930822466,0.6883827459027082},
{0.49418647677209215,0.49498645488099074,0.7146804430372607},
{0.7165998530970452,0.540699889156534,0.4405999096770278},
{0.8629523447726036,0.44867522259497944,0.23238716677306268},
{0.9366703501693407,0.3418891776693686,-0.07589759749957613},
{0.9978318662694822,0.011500367270093249,-0.06480206948713413},
{0.9825211195184486,-0.08100174115113927,0.16760360267815977},
{0.8789836290823612,-0.06209884341981186,0.4727911943460072},
{0.7272042105245684,-0.24370141103525486,0.6417037154752689},
{0.6916800349439328,0.0059998268174983336,0.7221791545995494},
{0.595807346349871,0.39030481248800714,0.7019086545870669},
{0.3734003024543675,0.6801005508816693,0.6309005110296209},
{0.4134110630280719,0.5366143599924126,0.7356196854461774},
{0.5087355491385375,0.6334442634644184,0.5830407413952572},
{0.6919144957605309,0.5895123504131131,0.41680873223441145},
{0.8652369766923151,0.4605196807290929,0.19820847061999175},
{0.8794392414544501,0.463220669367411,-0.1096048906793356},
{0.948107480597533,0.17940141548275226,-0.2625020711495121},
{0.9548146421948079,-0.11270172829425518,-0.2750042172220069},
{0.9797305141820537,-0.17990560324727106,-0.0881027440026936},
{0.9817685986335511,-0.1786942845547113,-0.06479792747143422},
{0.9541291872582642,-0.2276069626034807,0.19450595002801846},
{0.8311773756597477,-0.3295910286542984,0.447787811381659},
{0.706699367504349,-0.17589984256971133,0.6852993866573234},
{0.21569337939332772,-0.4372865776944933,0.8730732014293668},
{0.36561345116630717,0.19950734001006096,0.9091334476348191},
{0.4058180816274493,0.3715165532888059,0.8350372059115825},
{0.20290814591102968,0.5789232413400447,0.7897317044156734},
{-0.030899042453511324,0.7338772574961799,0.6785789711635205},
{0.1900054684360735,0.6820196288073797,0.7062203253134479},
{0.3516870669459152,0.8470688496158225,0.39848534597084795},
{0.4235910856194037,0.7807835685826969,0.4592903343366197},
{0.5498101468398907,0.6833126106505955,0.48040886602743454},
{0.46352172809026826,0.8570401746998055,0.22501054761663508},
{0.7332828927096673,0.6280853469397819,0.260393925080591},
{0.6737990634199528,0.7364989762671346,-0.059699917017173025},
{0.698905832393507,0.660105508603454,-0.2753022974072578},
{0.7955701428127998,0.40668473740820227,-0.44908314622577733},
{0.6749192860941542,0.41221177911988494,-0.6120174886496108},
{0.8679801234827559,0.06139859398829633,-0.49278871526762913},
{0.8592271520070118,-0.23960757171890137,-0.45201428387705933},
{0.9440296005121934,-0.2527079237811772,-0.2120066475726536},
{0.9276331310089216,-0.29551055434792617,-0.2284081577430333},
{0.93918070473063,0.10369786954915494,-0.3273932737742848},
{0.9731864046808892,-0.08509881117791171,0.2136970146735574},
{0.8084448133380394,-0.5723317252268184,0.13730761117183674},
{0.8653984509381591,-0.4208992465910229,0.27189951330030676},
{0.8607344731059856,-0.2854114309567193,0.42151688208919824},
{0.8800095305548241,-0.2553027649439166,0.4005043374854626},
{0.8623720940905455,-0.43138604057358687,0.26499142501622747},
{0.8524493574879627,-0.438373956976801,-0.284883075599203},
{0.8249160323988861,-0.5564108139492547,-0.09960193578243308},
{0.817178340975105,-0.5760847310765516,-0.018599507026599304},
{0.7588482870528066,-0.5163328553049078,0.39692525715769494},
{0.322519466249846,-0.8530514874763369,0.4102247598625948},
{0.5874168914155725,-0.230306622562149,-0.7758223090912515},
{0.3291904239898472,-0.1474957094122189,-0.9326728689408581},
{0.6352109098410655,-0.15060258662163803,-0.7575130103976813},
{0.8330191388345746,-0.2524057990898519,-0.49231131098230624},
{0.8304176507147509,-0.18870401094637945,-0.5242111422262432},
{0.7875596425401504,-0.036298139949476206,-0.6151684764991119},
{0.5110747075385704,0.05039750588914879,-0.8580575357833051},
{0.38881121930960205,-0.13190380613924,-0.9118263111278169},
{0.17010572075158495,-0.11030370957613062,-0.979232932157272},
{0.06360247545651809,-0.15260593953875254,-0.9862383851449393},
{0.5546847297395825,-0.25389301042163337,-0.7923781861287997},
{0.8011833475771791,-0.34819276288863427,-0.48668988425588255},
{0.8901082335392405,-0.43070398403027854,-0.1490013782691235},
{0.6251053946828343,0.4597039672623563,-0.6308054438744711},
{0.5747924012946819,0.38739487867355565,-0.7207904712129554},
{0.057198592359962816,0.4356892778188077,-0.8982778936530524},
{0.15910346372010817,0.3082067097331071,-0.9379204187497766},
{0.19319738315916757,0.060599179189676784,-0.9792867356509978},
{-0.25490270070842114,-0.032800347521523,-0.9664102391707264},
{-0.1851090242849062,-0.11430557253249475,-0.9760475834795702},
{-0.3561056033657538,-0.039400619973632964,-0.9336146905427344},
{-0.3178062910377973,-0.08740173013437219,-0.9441186890144254},
{-0.4303032810750274,-0.017900136489061094,-0.9025068816412088},
{0.1712059435174956,0.08870307938085198,-0.9812340641318147},
{0.5247879037782253,-0.024499435294524616,-0.8508803874331018},
{0.7812012733591134,-0.14710023977358624,-0.606700988923418},
{0.9291296118326011,-0.2263072125257966,-0.2924093192335083},
{0.8832116408061391,-0.4454058704880598,-0.14680193486225232},
{0.7198409277194514,-0.08480482171521184,-0.6889391707501111},
{0.7263160045494923,-0.02180048037887778,-0.6870151385453687},
{0.9713720346016799,0.23089335267606328,-0.05589839070849691},
{0.9061224222767622,-0.3339082626621906,0.2597064265150371},
{0.8477243046042244,-0.5224149778521255,-0.09190263488631382},
{0.878298340017706,-0.46079912909046905,0.12749975902568317},
{0.9255062471882528,-0.3563024050493512,0.12840086670877543},
{-0.564187700842181,0.7039846533018351,-0.4313905957875166},
{-0.7132002710161545,0.6730002557401458,-0.19600007448004245},
{-0.5593943920993287,0.8287916914049404,0.013499864664535104},
{-0.3602828257270367,0.8344602222292871,-0.4169801230312914},
{-0.2894848053413409,0.8271565836903532,-0.4816747175575956},
{0.14609286645949193,0.9865518278503405,0.07329642102314003},
{-0.5163764718420785,0.8563609808008444,0.001099949881925419},
{-0.7333813796831519,0.6768828141635198,-0.06309839795201375},
{-0.7590365371030913,0.5127246805965151,-0.40121931315646936},
{-0.8197220754127403,0.3707099833542794,-0.4366117581129711},
{-0.849919777863349,0.4176097178912043,-0.3213074769119826},
{-0.8890653360183098,0.2813890288556432,-0.3610859215343737},
{-0.5329920744667787,0.6542902707760099,-0.5364920224229395},
{-0.28019791953817114,0.7583943689427158,-0.5884956304361659},
{-0.4589226460967213,0.6959343417274098,-0.552327255260883},
{-0.25670131046353484,0.9427048125203519,-0.21310108788383048},
{0.2915982824911742,0.9470944216302849,0.13409921015797824},
{0.5136890328562216,0.8300822779325472,0.21699536719836496},
{0.32628990148382114,0.9410708743071532,0.08899724557787336},
{0.007899714154014912,0.9813644899683841,0.19199305285707124},
{-0.18719465660478973,0.936573265897682,0.2962915424786282},
{-0.5142010669683209,0.8514017666604987,-0.10350021476316844},
{-0.5472823394838527,0.819873543107639,0.16819457244871922},
{-0.7346100568805185,0.6015082347041001,0.3139042973792469},
{-0.9465325849451148,0.31891097869941587,-0.04870167658407511},
{-0.9460581000146051,0.2830874623339337,-0.15759302035968897},
{-0.8891327340241658,0.2600095724286167,-0.37661386529468094},
{-0.810700506687975,0.13990008743758195,-0.568500355312833},
{-0.8152175885092102,-0.007000151029887723,-0.5791124944868542},
{-0.6238302190677352,0.41982033658966855,-0.6592319339683409},
{-0.2994106217802148,0.7537267389303538,-0.5850207539793776},
{-0.1860110670576617,0.767445660537901,-0.6135365034401906},
{-0.35510346050008396,0.8079078731005852,-0.47030458314049417},
{-0.0381997843628259,0.9533946181025712,-0.2992983104658061},
{0.1261975114096123,0.9897804817213489,-0.06639869063073103},
{-0.013199345856628616,0.9897509491584096,0.14219295309186283},
{0.1669928353260972,0.921560461296594,0.35048496276525193},
{-0.10179880438006378,0.9923883444673408,-0.0692991860858391},
{0.40139863926091934,0.8570970944457748,0.32289890537456617},
{0.2196023925811008,0.8838096291583648,0.41310450079805444},
{-0.09760132689905886,0.8753118999461702,0.473606438723302},
{-0.355591137001364,0.8556786724748795,0.3759906285503736},
{0.054096643136961976,0.6038625284734073,-0.7952506522518643},
{0.024899310174167303,0.6197828291545742,-0.7843782691010777},
{0.2181011101374759,0.40350205383068105,-0.8886045230085331},
{-0.24240154046668452,0.3488022166451302,-0.9053057532363429},
{0.26409807605252394,0.5839957456064898,-0.7675944080951055},
{-0.029699203329555886,0.466587483958612,-0.8839762876541213},
{0.05069695954102456,0.5410675504467137,-0.8394496555165704},
{-0.0018000022590042523,0.7495009406242708,-0.6620008308115639},
{-0.6853180275278243,0.047101239014388625,-0.7267191165977964},
{-0.6180183646885642,-0.07960236541943319,-0.7821232411374208},
{-0.48897586230232143,-0.030698484606710163,-0.8717569667794761},
{-0.6980021149496124,-0.058500177255805634,-0.7137021625208286},
{-0.8149776454697729,-0.0030999149704985227,-0.579484104968998},
{-0.7489301150854035,0.07290293148581375,-0.6586264839033873},
{-0.5710787962379363,0.4087848221013278,-0.7118735686250863},
{-0.11889935200029741,0.5274971251485019,-0.8411954154974783},
{-0.2573017625231099,-0.9274063527552746,-0.2715018597941094},
{-0.5816075231419681,-0.8074104439216386,0.09910128188337179},
{-0.16950410374402808,-0.9143221360068723,0.36780890476137773},
{0.003699845460682594,-0.16929292878204408,0.9855588340672337},
{0.17570783410842947,0.24471091067918435,0.953542514640794},
{0.23509665930020684,0.05549921136180978,0.9703862109099137},
{0.521903512422458,-0.06780045629860634,0.8503057225767694},
{0.71248118005819,0.08369778915209894,0.6966815973986539},
{0.9379166669272583,-0.34470612548227525,0.0386006859402838},
{0.937853174159992,-0.34428281038840525,0.043597823215028954},
{0.9306657474774847,0.18339325033562984,0.31658834818026393},
{0.9196638901062687,0.37098543354292235,0.12879494296584473},
{0.7555909178517508,0.43719474495074834,-0.4877941367497142},
{0.7551773299168286,0.6217813344045076,-0.20759376812861977},
{0.8443066953786416,0.49140389684835306,0.21370169466115801},
{-0.9458120260763678,-0.3222040968511374,-0.04030051242427324},
{-0.8201045802968715,-0.5519030823873227,0.1511008439005698},
{-0.9506999144370116,-0.13599998776000166,-0.2786999749170034},
{-0.5720846826376808,0.46348759028590286,0.6766818820851573},
{-0.5074200409502838,0.6876271583709404,0.5193205109686291},
{-0.7169750317792698,0.1670941810464658,0.6767764316711434},
{-0.7963667882156317,-0.14459396983422948,0.587275508185636},
{-0.8007832277709397,-0.23949498383009496,0.5489885015562511},
{-0.8417055763179148,-0.08310055054297102,0.5335035344726239},
{-0.6386803896197004,0.50058462978491,0.5843820568244136},
{-0.7886906698445634,0.5300937290282782,0.3113963162033689},
{-0.7194820383551158,0.6281843175742651,0.296192605643899},
{-0.6717903901072038,0.6655904787963007,0.3250953495442869},
{-0.5735972782873717,0.6561968863531613,0.49029767354305853},
{-0.4386013070338424,0.7558022522940678,0.4862014488824765},
{-0.31061259093656557,0.7639309665693576,0.5656229279900885},
{-0.10879821898773265,0.5780905367353698,0.8086867619060606},
{-0.5518755993597995,0.5740746178518952,0.6048732561202079},
{-0.6395976175033121,-0.1434994654654867,0.7551971868957181},
{-0.6359017201164794,-0.08830023885246914,0.766702073931915},
{-0.8015375529140516,0.12170570204571439,0.585427427917512},
{-0.8002159844739364,-0.3924078384248596,0.45350905893392923},
{-0.8483846740692932,0.28659482271129116,0.44509195948637714},
{0.34049083751484205,0.5300857355847806,-0.7765791025375223},
{0.3150800355860475,0.7515523793921719,-0.5795632771363795},
{0.6271296200314477,0.5507260114037924,-0.550826016127127},
{0.5815144420905062,0.5822144594756539,-0.568214111772701},
{0.7482227575412612,0.4613140310796362,-0.4768145025336452},
{0.629290390809098,0.5816911176444499,-0.5153921300222614},
{0.45801335357398804,0.8112236515703474,-0.36351059830599264},
{0.31770023192125396,0.8075005894756455,-0.4970003628103973},
{0.42878318345331096,-0.5349790185343316,-0.7279714495196138},
{0.47240440282955165,-0.3026028202714275,-0.8278077152038588},
{0.6697068645305423,-0.517105300356493,-0.5330054633339989},
{0.7220676412637189,-0.26008834440201256,0.6410712710347185},
{0.6917826606849121,-0.5582860067366096,0.4579885206615926},
{0.4983158541711047,-0.29620942405274175,0.8148259240991693},
{0.6093872608924651,-0.6270868908855676,0.4851898572120513},
{0.9693808839974495,-0.13179740098087872,-0.20719591413685942},
{0.9912141050770735,-0.03370047956123626,0.12790182005584919},
{0.8777782620905056,-0.17619563656908985,0.44548896760232426},
{0.5937071156224214,-0.7853094119897044,0.17550210340531402},
{0.10230549855678388,-0.9571514434867825,-0.27091456069435726},
{0.4918945572168365,-0.6925923365081946,-0.5275941622028927},
{0.6049757621316255,0.7772688593469629,-0.17279307718404116},
{0.5096957720911057,0.8594928705362083,-0.03849968064647355},
{0.5781045265761647,0.8128063642987488,-0.07170056141759386},
{0.8591193389939835,0.2996067442237195,-0.4149093397143566},
{0.7425073619969915,0.6696066391827413,0.017600174506595352},
{0.27338597429237416,0.9398517821411941,0.20478949354454365},
{0.29580555528049274,0.9428177062827875,-0.15360288468926192},
{0.08300275366202987,0.908430137669734,-0.4097135924738992},
{0.0233992545116267,0.9119709450685278,-0.40958695076761953},
{-0.9524246252570332,-0.2202056934918088,-0.21070544785978254},
{-0.9613035279904216,0.06210022790825463,-0.26840098503342263},
{-0.8706727048385483,0.3809880562116537,-0.31109024747361014},
{-0.8990182817226401,0.4283087097461699,0.09120185460857039},
{-0.9716960209129415,-0.07229970393331858,0.22489907904015696},
{-0.76808559853004,-0.04169921814698954,0.6389880190869621},
{-0.7623323007038858,-0.43911860584950313,0.4754201439782596},
{-0.4019201708699253,-0.2071103940959481,0.8919447633712029},
{-0.30351017838450106,-0.22520755246190985,0.9258310482648141},
{-0.035400261785903865,-0.07430054945459483,0.9966073699387511},
{-0.0898015347213427,-0.6313107891935817,0.7703131647644798},
{0.018000015390019736,-0.31020026522134014,0.9505008126785423},
{-0.9292793051803079,0.36109195857162285,0.07779826745187554},
{-0.7882005635636045,0.03870002767052968,-0.614200439153471},
{-0.6903062921705299,0.021200193240642085,-0.72320659205813},
{-0.5164872067703306,0.7359817699573346,0.4376891585738116},
{-0.4092030424359308,0.736005472221029,0.5393040097402186},
{0.03219943442190153,0.7697864788192483,0.6374888026075224},
{-0.028299986699009374,0.8256996119212735,0.5633997352021867},
{0.038100704679049614,0.7536139382186822,0.6562121367557049},
{0.04829843201685644,0.6819778599481593,0.7297763081967252},
{-0.05599682283040635,0.7537572330278626,0.6547628498098228},
{-0.22598674400638347,0.666360912415283,0.7105583198713986},
{-0.4548046185643524,0.4377044449112072,0.7756078763379765},
{-0.5032941366574616,0.04599946410936467,0.8628899473906689},
{-0.08610311225323959,0.6115221038659235,0.7865284295838901},
{-0.8975999820480004,-0.10219999795600006,-0.4287999914240002},
{-0.45836741581857293,-0.5358619069310063,-0.7090495954558248},
{-0.984013909134909,-0.022200313803653438,-0.17670249770745775},
{-0.9365581011840163,0.2988185377830049,-0.18321136586963352},
{-0.8544333833644449,0.3065119756568379,0.41951639082559056},
{-0.9820399698401754,0.18620757880268907,0.03040123735554107},
{-0.9434943107464593,-0.07409955318104147,-0.3229980523276167},
{-0.9284713246059526,-0.3713885298423811,0.003399894995864554},
{-0.3405031922323909,-0.7656071776009352,-0.5458051169469572},
{-0.9848130390109554,-0.050200664661200205,0.16620220053170265},
{-0.6038081393885788,0.33480451319525695,0.7234097516291783},
{-0.8010067605255884,-0.46060388751321596,0.3824032274968602},
{-0.8732848530055859,-0.4717918168419048,-0.12159789090287329},
{-0.8709414708654764,-0.4836230282587488,-0.08700414280089153},
{-0.9928179503108139,-0.11560209010468381,0.03080055687910261},
{-0.5671754503419365,0.5952742341124027,-0.5691753637775568},
{-0.6490121820729874,0.30050564054381,-0.6989131187223588},
{-0.4054943454207794,0.014199801985141968,-0.9139872545366027},
{-0.19459316795380757,-0.1990930099671279,-0.9604662786209259},
{-0.4387115953006977,-0.16080425011249647,-0.8841233676894161},
{-0.8782964780381846,-0.3227987055797859,-0.35269858568150714},
{-0.9734803845678743,-0.09459809386761266,-0.20829580288185745},
{-0.8810761672120109,-0.22999377875242596,-0.41328882068859846},
{-0.012300255171440325,-0.7209149555358805,-0.6929143746578049},
{-0.13310152202460657,-0.5674064883302913,-0.8126092922403855},
{-0.4470975566185296,0.1123993857390354,-0.8873951503987546},
{-0.42098761262174517,0.1663951038961007,-0.8916737628855349},
{-0.3362066603199121,-0.486309633889272,-0.8065159772397653},
{0.21640257845208347,0.8465100862277665,0.4864057955595813},
{0.02889922247687875,0.9991731176089014,0.028599230548053023},
{-0.13430039014320005,0.9721028239628055,0.19230055863393428},
{0.7512043231933201,0.08630049666078744,0.654403766104511},
{0.08879943301743026,-0.13619913037132883,0.9866936999808382},
{0.6439134869092265,0.6019126071915878,-0.47230989263430295},
{0.3610918791349563,0.846880953861519,0.3903912202001854},
{0.40338295944680963,0.7917665525284676,0.4586806234463351},
{0.5965428243637756,0.32832356955344094,0.7323525738165848},
{0.7779821960811616,0.618385848401787,-0.11109745756377513},
{0.35159789569289146,0.534596800447724,-0.7684954005687914},
{0.9644011331719972,0.062300073202629015,-0.2570003019755322},
{0.6774839810806488,-0.7049833308662101,-0.20979503945493744},
{0.22240375420705677,0.8632145711849434,0.4532076502097038},
{0.0488007522693944,0.8217126667983888,0.567808752839388},
{-0.7513743184646849,-0.33318861180786935,0.5695805320701152},
{-0.6248995313255272,-0.297499776875251,0.721799458650609},
{0.867585763034442,0.07949869543711173,-0.4908919445292849},
{-0.32870983843269863,-0.2558076564377375,0.9091272105846253},
{0.6017997893701106,-0.09889996538501816,-0.7924997226251456},
{0.1038039856305439,-0.962636961155699,-0.2501096031425725},
{0.8131277321942179,0.045301545035540604,-0.5803197921440224},
{0.5089083639776936,-0.5986098382335377,-0.6186101669416412},
{0.5865961167465606,-0.48819676814809226,-0.6461957221984785},
{0.5769155596224673,-0.5883158670929062,-0.5666152818202288},
{0.5397936493650726,-0.684991941117219,-0.4892942434870879},
{-0.33721200327488865,-0.660923525991619,0.6704238641621748},
{-0.7977219097331303,-0.08970246371199925,0.596316378054238},
{-0.8059995325204068,-0.3849997767001943,-0.4495997392322269},
{-0.5836028421527619,-0.7683037416483327,-0.2629012803323528},
{0.050200963616745024,-0.8434161895291385,-0.5349102677011338},
{0.665887311638164,-0.5802889426995442,-0.46889106536587327},
{0.4058841586504258,-0.6414749637207394,-0.6509745929574458},
{0.14940512692489716,-0.5101175049825304,-0.8470290663011237},
{-0.23750206746449593,-0.9653084030462229,-0.10850094450483287},
{-0.2592000194400022,-0.9511000713325081,-0.16800001260000144},
{0.6917422702029206,-0.7221441279652002,-0.0007000427774209114},
{0.980214620010087,-0.047300705495283736,-0.19220286672713602},
{0.4362006346723852,-0.6008008741659079,-0.6699009747066274},
{-0.17929815413500474,-0.9312904124145562,0.3170967355059119},
{-0.28341028089441256,-0.2095076000260389,0.9358339479922063},
{-0.34701042261456716,-0.01580047457438087,0.937728165088414},
{-0.8469291263934936,-0.5056173884809899,0.16450565744684106},
{-0.8860432399651912,-0.3284160270931928,-0.32721596852890583},
{-0.7750697651181825,-0.6279755031534235,0.07009726555900476},
{-0.10100021159566494,-0.9440019776862149,0.3141006580415679},
{0.39039793675235634,-0.9079952012580419,0.15209919615787246},
{0.37469340920089766,-0.2102963009205999,-0.902984116649081},
{-0.33178949239316124,0.0358988631010081,-0.9426701461092016},
{-0.300095410075804,-0.460692953755158,-0.8352872243796039},
{-0.51351852294719,-0.6744243269242162,-0.5305191361703687},
{-0.45949547399187174,-0.734892761341951,-0.4987950868925911},
{-0.10289862425459054,-0.9931867211823062,0.054699268675666685},
{-0.22849071775313312,-0.9731604661590773,0.027398886942826467},
{0.5781749742378485,-0.7132691268140043,0.39618285159639494},
{0.7372490910217184,-0.5040651929798566,0.44986893537321465},
{0.3876014709503734,-0.9216034974919095,0.020300077038938543},
{-0.7706273500499885,-0.467116578261549,-0.4335153857340644},
{0.10340005531904439,-0.712900381401806,-0.6936003710762978},
{0.19019193793462283,-0.7074700109818384,-0.6806711469616075},
{-0.28718334097757087,-0.8982478941509467,0.3326807017522208},
{-0.4779185890050361,-0.8058313434196653,0.3496135984853748},
{-0.4936015351031612,-0.12190037911076854,0.8611026780334929},
{-0.35417987607114626,-0.5159706833786321,0.779955684177002},
{-0.5589194227874186,-0.5480190439926739,0.6223216260522645},
{-0.7437269643098955,-0.6384231464507694,0.19820718613180216},
{-0.9131316907852526,-0.28270981161427106,-0.29371019338914545},
{-0.958791423649073,0.05569950177018499,0.27859750795643695},
{-0.9389578745999129,0.06829693592670293,0.33718487254003265},
{-0.8432170795349208,0.1907038627458603,-0.5026101804723093},
{-0.5102853193025425,0.09559724970668836,-0.8546754113421186},
{-0.11530484694111388,0.0922038758713851,-0.9890415752364409},
{-0.859605497194732,0.13930089083204533,-0.49160314381215703},
{-0.9021871258815698,0.08789874569384835,0.4222939739079882},
{-0.9060061019716452,0.021800146824483294,0.422702846913261},
{-0.7056891959811137,-0.05619913959775909,0.7062891867953247},
{-0.8321938417883561,0.27999792802299894,0.47859645839931175},
{-0.858508855564518,-0.504405202966503,0.09240095312074718},
{-0.42670386382098047,-0.3244029374818984,-0.8442076443348293},
{0.13840803758812087,-0.5009290897968913,-0.8543496135226276},
{-0.3669003320449508,0.08130007357659988,-0.9267008386646386},
{-0.3032931790131051,0.13849688524007603,-0.9427787971432756},
{-0.2853083610840341,0.1289037775805538,-0.949727832181939},
{-0.3924960475847012,0.07499924476140786,-0.9166907689704346},
{-0.5196179245294652,0.13460464326725563,-0.8437291049374709},
{-0.9985004293552769,-0.03650001569501012,0.040800017544011316},
{-0.9790043565790801,-0.12010053444856744,-0.16470073291989223},
{-0.7898815248871969,0.01459965851798085,0.6130856600941136},
{-0.7508891835192165,-0.0933986546020706,0.6537905822144943},
{-0.9567203305230377,0.28810612232014965,0.04100087127777208},
{-0.8652828199801622,0.3258935294482086,0.38089243745573076},
{-0.7540258635306862,0.005400185229530114,-0.6568225293991442},
{-0.7782882829580995,-0.44589328712709314,0.44209334433480124},
{-0.16660699347532978,-0.7343308241832812,0.6580276212891176},
{-0.15379802755294486,-0.8435891810381294,0.5144934016644352},
{-0.10850352696446688,-0.9693315086327904,-0.2205071677019811},
{-0.0008999999730000012,-0.7769999766900011,0.6294999811150007},
{0.21040073009180013,-0.8227028547838592,0.5281018325165383},
{0.2680074011265746,-0.671418541479038,0.6909190799938447},
{-0.25260152445480016,-0.9519057447685046,-0.17340104647847326},
{0.12580030632411884,-0.9910024130938138,-0.04570011127990645},
{-0.7532950508677736,-0.5324965015094776,-0.3859974640049922},
{-0.7376432788007881,0.14990879540704735,-0.658338625860302},
{-0.27390127364388367,0.045000209251459526,-0.9607044672861593},
{0.04649891682034886,-0.3884909502087211,-0.9202785623605818},
{0.06599932285042133,0.053399452124431805,-0.9963897770933303},
{0.11399644051671644,0.09029718051455697,-0.9893691074319231},
{0.4212933246601557,0.03659942008678305,-0.9061856416022622},
{0.5386805297441222,0.03979856150699103,-0.841569582017177},
{0.6178961165351113,-0.020399871787208725,-0.7859950600365715},
{0.37727892201542407,-0.03729791622362925,-0.9253483022344908},
{0.32879580294836286,0.11649851290597409,-0.9371880368710636},
{0.37641201338111363,0.1089034757098918,-0.9200293632056975},
{0.08680177077418588,0.0720014688449468,-0.993620270060266},
{0.016399482768470093,0.0925970795341665,-0.9955686002615137},
{-0.026599071575609694,0.06599769639061052,-0.9974651840853636},
{-0.15069927513822987,0.05229974843881501,-0.9871952516022596},
{-0.05330222328210061,-0.27051128326094215,-0.9612400941605087},
{-0.2658891772013086,-0.6061753261355143,-0.7495694893948888},
{0.4588827899236898,-0.4757821561248456,-0.7503718578311982},
{0.2531062492704427,-0.7101175330183379,-0.6570162219307817},
{0.1324980748169593,-0.2958957006667038,-0.9459862549195733},
{0.08810154663622692,0.11180196270068296,-0.9898173763965653},
{0.40861173345439167,0.08190235185980096,-0.9090261030593294},
{0.3680965159829642,0.07939924848966955,-0.926391231748487},
{0.28820844174889004,0.13270388695377416,-0.9483277769273852},
{0.11330328924223075,0.09160265926379821,-0.9893287206296458},
{-0.04789982923741315,0.02259991943143084,-0.9985964400100371},
{-0.1249982944099091,0.06249914720495455,-0.9901864889975359},
{-0.10980386461502388,0.07740272423682011,-0.990934876566732},
{-0.011799405442939217,0.06749659893206757,-0.997649729696649},
{-0.131801074842148,0.10770087830424385,-0.9854080360353008},
{-0.18620483394023446,-0.430811184003507,-0.8830229235726478},
{0.007099997089001791,-0.7144997070551803,-0.6995997131641765},
{-0.3236143655605379,-0.9451419557826465,0.04450197548653874},
{-0.23219076363513025,-0.890364582001378,0.3915844230814686},
{-0.5057321124800053,-0.5526350906791593,0.6624420630942366},
{-0.6193108070678758,-0.783513672432877,0.05060088299311241},
{-0.38799939084143453,-0.841698678534112,0.3754994104663883},
{-0.15050526551882287,-0.4933172590062148,-0.8567299732224289},
{0.07649692909242113,-0.9969599778450179,0.014799405889775592},
{-0.015400697282354546,-0.6350287515776062,-0.7723349682572996},
{0.07609981621916576,-0.02009995145867584,-0.9968975924952213},
{0.5120254739010056,0.16310811483057425,-0.84334195730609},
{0.3988935160385947,0.10569828188839174,-0.9108851936815141},
{0.48461149512099794,0.08260195934171366,-0.8708206561109473},
{0.5000917460538464,0.05559908234471878,-0.8641857367321218},
{0.18849326148635065,0.05259811965083313,-0.980664941854982},
{0.19309259890252337,0.0628975891816091,-0.9791624694218067},
{0.08179609310291718,0.019799054320755016,-0.9964524055874936},
{-0.0803004440626835,0.011400063042522939,-0.9967055117967204},
{-0.1276058980809171,0.08180378105814279,-0.9884456870155052},
{-0.10949509308735247,0.09269584592874497,-0.9896556495758242},
{-0.08689622835106085,0.11839486118257313,-0.989157066569268},
{-0.0430984784350778,0.046998340752869065,-0.9979647674758154},
{-0.057901803669276886,0.07850244538926142,-0.9952310019285727},
{0.14309876506298627,0.09339919396843407,-0.9852914969710717},
{0.21549242557435927,0.07309743067046712,-0.9737657727346221},
{0.16140479379356454,-0.3842114112483736,-0.9090269985027892},
{0.10479367432076866,-0.8986457548862099,0.425974286838239},
{-0.07800087985488717,-0.8100091369545975,0.5812065560469285},
{0.04519912111163489,-0.8336837891763277,-0.5503892977841559},
{-0.04230186745715925,-0.7281321441030177,0.6841302015943888},
{-0.11190409240749037,-0.6051221297209332,0.7882288260552629},
{-0.3065870531021154,-0.83326481196997,0.4600805712077082},
{-0.5961044976254019,-0.7157054000176147,0.363902745656574},
{-0.4552240273582627,-0.5522291474236218,0.6984368644705858},
{0.13069682541266564,-0.9227775860046505,0.36249119519580175},
{-0.030701204431875257,-0.8303325745858641,0.5564218288565275},
{0.0012999846407722036,-0.7662909463259535,0.6424924089970314},
{-0.0550986498241289,-0.9529766475933726,-0.2979926977784103},
{-0.11390270009550901,-0.9713230254852319,-0.20870494740941817},
{0.06200153455697067,-0.5751142342534489,0.8157201893245318},
{-0.6852846052542625,0.19099570932958432,-0.7027842121300096},
{-0.5427091338715853,0.16470277197097863,-0.8236138615379356},
{-0.6459863795207803,-0.20109575994060203,-0.7363844734970628},
{-0.40962181703897876,-0.45542425654187235,-0.7904421000674042},
{-0.24969591126292934,0.10249832160372549,-0.9628842328997783},
{-0.6895667567879636,0.14249313057175872,-0.7100657685544272},
{-0.7483835956113742,0.115197474899025,-0.6531856823267633},
{-0.05729902334647051,0.11779799215033554,-0.9913831020190378},
{-0.043199329551608004,0.09239856598538378,-0.9947845610634176},
{0.07310205638976977,0.13730386241197523,-0.9878277879865195},
{-0.16919411130143244,0.14359500226291785,-0.9750660634162339},
{-0.2596086477080851,0.13710456702919288,-0.9559318426200253},
{0.10859777268252317,0.1614966877369014,-0.980879882359917},
{0.19489843497185072,0.14129886537466654,-0.9705922061758765},
{0.05290084403970004,0.11620185401537134,-0.991815824547722},
{-0.11780220999018932,0.0870016321659293,-0.9892185579142213},
{-0.07059910269110714,0.08249895144499066,-0.9940873652298813},
{-0.1350988509891585,0.15899864772225167,-0.977991682216114},
{-0.26978780451793893,0.29888648914163063,-0.9153586221487076},
{-0.24191014713393677,0.16630697589240878,-0.9559400977483676},
{-0.4721958895526721,0.07959930709104765,-0.8778923579802855},
{-0.40529528644322776,0.12139858814262978,-0.9060894622408308},
{-0.6117017678206635,0.09130026385814384,-0.7858022709718447},
{-0.34680976283223747,0.16150454641697334,-0.9239260088832302},
{-0.34049787189495095,0.10109936813092375,-0.9347941575547728},
{0.13349447678028248,0.1444940216835267,-0.9804594343300895},
{0.22040780698278745,0.17360614923871098,-0.9598339979223203},
{-0.017600734317953937,0.1198049983688001,-0.9926414138636976},
{-0.17429750320614973,0.34039512387477544,-0.9239867639844082},
{-0.3106863021429011,0.5919739004460812,-0.7436672124353897},
{-0.170195791961065,0.45248881235242017,-0.8753783565376986},
{-0.0958991378706258,0.29909731112725935,-0.9493914650090942},
{-0.3362007648576101,0.2610005937770263,-0.9049020586545251},
{-0.23889902290499446,0.5098979145217944,-0.826396620044736},
{-0.01359998225203474,0.7301990470908652,-0.683099108556245},
{-0.31078654634160696,0.8036652100860666,-0.5074780317514979},
{-0.30349692559171554,0.7059928483286694,-0.6398935179114952},
{-0.26689697473993695,0.5284940095543523,-0.8058908652788128},
{-0.1648945470274932,0.15429489755210554,-0.974167784804026},
{-0.13759206116709938,0.150791299593013,-0.9789435165885922},
{-0.25049358118422216,0.15159611539931372,-0.9561754983167795},
{-0.6015059338853068,0.1579015577065502,-0.7831077253958167},
{-0.3098926401371941,0.2694935996030133,-0.9117783455214379},
{-0.28928519187003254,0.3864802165840566,-0.8757551712401469},
{-0.07619947384444965,0.5470962223136274,-0.8335942440516172},
{-0.3517053512376289,0.7522114449842038,-0.5572084779914894},
{-0.3931935988603154,0.8165867060766367,-0.42259312024000323},
{0.28399328363826204,0.9586773275493022,0.01689960032917827},
{-0.17340648725803476,0.9459353881048158,-0.2741102546564437},
{-0.27230218659533756,0.8369067203879471,-0.4748038126899239},
{-0.2309990425109532,0.7747967884739677,-0.5884975606826666},
{-0.3279008312296608,0.5576014135213749,-0.7626019331983509},
{-0.275592379976039,0.4536874557152718,-0.8474765675968544},
{-0.3773994923980241,0.30119959488681736,-0.8756988221858764},
{-0.33489827025490115,0.17639908890105874,-0.9255952193130383},
{-0.5138780938437791,0.10779540477983926,-0.8510637199269127},
{-0.7900032153196295,-0.0005000020350124238,-0.6131024953322339},
{-0.6946142362646598,0.03730076448700232,-0.718414724060656},
{-0.8021042110581621,0.014700077175607756,-0.5970031342746823},
{-0.7394813283321865,0.18279538447481228,-0.6478836411445891},
{-0.6462872876540765,0.14189720890935087,-0.7497852518691422},
{-0.6464979667670918,0.11099965090664686,-0.7547976261651986},
{0.080398352654631,0.08789819898435404,-0.9928796561042675},
{0.13240298373485807,0.20090452743453918,-0.970621873210372},
{-0.03119887779654812,0.11849573778496642,-0.9924643017010901},
{0.24669394497143007,-0.3215921066186133,-0.9141775617871154},
{0.41409020067135033,-0.2563939325093799,-0.8733793317226692},
{-0.07779644711738837,-0.9358572603748558,-0.34368430429622604},
{-0.10569862909767085,-0.9943871028829129,0.004699939042185932},
{-0.03409945339014319,-0.6780891303183607,0.7341882310569834},
{0.17450100949125985,-0.6203035884666389,0.7647044238278878},
{-0.026800938585304173,0.08940313095246988,-0.9956348677436132},
{-0.18880575016668333,0.09980303954785485,-0.9769297528486914},
{-0.1975978175441578,-0.0462994886249722,-0.9791891849151787},
{-0.05679918181367893,-9.999855953112487e-05,-0.9983856183587506},
{-0.40249303491829563,-0.09399837337222308,-0.9105842424760249},
{-0.11909765260840041,-0.10809786941199064,-0.9869805468051319},
{-0.16660581381131118,-0.027700966642096755,-0.9856343943122947},
{-0.0742031707692319,0.14970639709102446,-0.9859421302073549},
{-0.055797869678002765,0.2463905929867362,-0.9675630591475891},
{-0.32299072868419776,0.22209362489399478,-0.9199735925370338},
{0.05449952640117335,0.15319866870935336,-0.986691425688766},
{0.18780903946660954,0.0497023922337087,-0.9809472141256512},
{0.14350417746741,0.025200733604032976,-0.9893287997805486},
{-0.18979993357003486,-0.10209996426501874,-0.9764996582251794},
{0.16430386365078117,-0.11380267610139316,-0.9798230408097102},
{0.6081907282030223,-0.10139845419234868,-0.7872879978859577},
{0.21289354197235494,-0.18149449444801513,-0.9600708766916767},
{0.016400551969864976,0.26780901326401463,-0.9633324214982274},
{-0.21790181621920732,0.02660022171377198,-0.9756081317276671},
{0.017599926608459066,0.19169920061600015,-0.9812959080045953},
{-0.02539940286705781,0.3454918775814359,-0.9380779460467296},
{-0.010700067464138043,0.4259026853248965,-0.9047057041874473},
{-0.1786016752915714,0.38420360384670615,-0.9058084965235462},
{-0.08889790425661044,0.4344897570247158,-0.8962788704746899},
{-0.2503952863531012,0.2792947423259631,-0.9269825497177508},
{-0.08689591164353348,0.2404886852735305,-0.9667545152700595},
{-0.021099514400264054,0.07609824861896182,-0.9968770571385419},
{0.1936050095944357,0.05520142835543828,-0.9795253455462282},
{0.18359875704062228,0.08529942252486426,-0.9792933702063256},
{-0.0013999757736288545,-0.042799259365224974,-0.9990827110232774},
{0.3763984849991468,-0.04219983014602549,-0.9254962748849903},
{0.7300906512490657,-0.03219958768691949,-0.6825912594748833},
{0.16560497484816777,-0.1370041156654528,-0.9766293383859943},
{0.0854992946337289,-0.10959909581118932,-0.990291830126102},
{0.5925981481336807,-0.22819928687834276,-0.7724975859488159},
{0.4599818471745949,-0.18629264810571092,-0.868165738515181},
{0.056900514951990486,-0.05230047332142535,-0.9970090229724871},
{0.10529784194284385,0.565088418631539,-0.8182832294570667},
{-0.035800315581172776,0.6187054539126144,-0.7848069181034748},
{0.02560125295598025,0.5774282600305858,-0.8160399379718704},
{0.12990290596050985,0.7950177847467694,-0.5925132546697621},
{0.2799092861446043,0.8308275631616194,-0.48101595796911284},
{0.24259469208620507,0.7657832448459021,-0.5955869686996856},
{0.24359918881605183,0.7880973756401085,-0.5652981175604027},
{0.193002364293444,0.7705094387984383,-0.6075074420117473},
{0.04280239336273919,0.5072283624668532,-0.8607481300773275},
{-0.7346214586062133,0.12890376533397888,-0.6661194576335403},
{-0.3710987920753977,0.8560972134081055,-0.3596988291822166},
{-0.45929264907997674,0.6403897506440608,-0.6155901475585319},
{-0.3884949690227265,0.5782925111604704,-0.7173907098504608},
{-0.2447890606213158,0.6352716103460863,-0.7324672667692559},
{-0.27528893773630114,0.2591895846758055,-0.9257627989693702},
{-0.6053797291991461,0.17449415716096955,-0.7765739968550657},
{-0.8048005714086085,-0.00730000518300552,-0.5935004213854488},
{-0.3341055712568515,-0.10000166754170951,-0.9372156282009015},
{-0.8360042469123614,-0.17220087478266582,-0.5210026467001678},
{-0.9085185294243634,0.048600991227324225,-0.41500846418394144},
{-0.9001986992138195,0.12179982399938148,-0.4180993958468095},
{-0.7117984162502857,0.09149979641317947,-0.6963984505151715},
{-0.5766149114544178,0.18660482566318828,-0.7954205698419076},
{-0.4495032881285791,0.22140161955877066,-0.8654063304704612},
{-0.7565277083347359,0.14830543178591055,-0.6369233277440758},
{-0.4097926463369416,0.1792967825481055,-0.8943839504240131},
{-0.881403701903322,0.1860007812049216,-0.434201823651489},
{-0.46278808567409946,0.25739337349289804,-0.8482781613598501},
{-0.6876868171700711,-0.45269132199053536,-0.5675891194208701},
{-0.24359407342828937,-0.2938928496739501,-0.9242775126016742},
{-0.9253031043971228,-0.1974006622803329,0.323801086354467},
{-0.4729041166482532,-0.445303876387116,0.7603066184979211},
{-0.43341221156109355,-0.8972252796783875,0.08450238088812277},
{-0.3377873838768139,-0.9324651730761663,-0.1280952157330369},
{-0.32368694435039413,-0.944661897830761,-0.05329785027456289},
{-0.7142141272951582,-0.40980810608450835,0.5674112235050025},
{-0.3786019365538582,0.09660049411279109,-0.9205047083936251},
{-0.10349923100357045,0.18699861060548478,-0.9768927417138935},
{-0.3332990084369248,0.07909976467855012,-0.9394972049999726},
{-0.31799478174844686,0.0038999360025752912,-0.9480844420619575},
{-0.3021017068794658,0.02270012825608697,-0.9530053844956335},
{-0.25130426969581354,0.07730131336047108,-0.9648163923697608},
{-0.25780431439130225,-0.01870031295235591,-0.9660161664158186},
{0.13030626397266737,0.2889138884244329,-0.9484455928755007},
{0.1387008786728496,0.27700175481167516,-0.9508060233752372},
{-0.41600012480005616,0.16320004896002205,-0.8946002683801207},
{-0.2511002184572851,0.04080003549604633,-0.967100841378098},
{-0.117794741171168,0.06579706255571183,-0.9908557642318367},
{0.7120887989312885,0.17359726933642983,-0.6802892991334862},
{0.8175147603622488,0.13100236526905762,-0.5608101255182252},
{0.48448974346069523,-0.189695984178522,-0.8539819213940841},
{0.7036186426229076,-0.357809480287772,-0.6139162659269514},
{0.9746733479216967,-0.1307964234207017,-0.18139503982045327},
{0.9929868678355087,0.11369849634732863,0.03239957151849998},
{0.9495499951233995,0.12340649752314639,-0.2883151801938663},
{0.8724887362431223,0.14509812679527453,-0.46659397631064853},
{0.7310994078097195,0.17289985995117016,-0.6599994654006496},
{-0.44819795398101014,-0.867496039889617,0.21579901487974562},
{0.07969998286450551,-0.9774997898375678,-0.19529995801051353},
{0.19390350871573558,-0.8716157720300937,0.45020814659011943},
{0.11780035988064914,-0.8109024773108522,0.5732017511340246},
{-0.07330196671815092,-0.7993214460821014,-0.5964160020560056},
{0.3659095851271253,-0.1772046419363941,-0.9136239326923795},
{0.18360879415379905,-0.35061679319347466,-0.9183439851385276},
{0.2768062545079817,-0.28360640815918936,-0.9181207451726084},
{0.6646147379952243,0.33070733351643194,0.6700148577442075},
{0.37650828703859757,0.5442119782374629,0.7497165014417971},
{0.6114120571646522,0.6524128657085689,0.4478088308772182},
{0.7219148391120286,0.6742138586082971,0.15580320256774352},
{0.5757029188211976,0.816104137658467,0.05040025552994331},
{0.6378054723944299,0.5418046487038288,-0.5474046967524473},
{0.6924957238521078,0.7210955472487436,-0.02169986600374114},
{0.4879179801088566,0.6567242007327037,0.57502118992128},
{0.8075924248185825,0.4509957696795205,0.3799964356501503},
{0.5600874709834096,0.7026842811284447,0.43879018437336215},
{0.5225885972412109,0.5561878641132061,0.6461859003774789},
{0.3472012412466562,0.6074021714666445,-0.7145025543511977},
{0.008799828185032017,0.09349817446596516,-0.995580561479304},
{0.18500919518550676,0.16580824087436227,-0.9686481430090911},
{0.4898163087055021,0.7836260912650702,-0.3821127226549047},
{0.16869988022312757,0.850199396358643,-0.4986996459233771},
{-0.11419476257731881,-0.0027998715868344367,-0.9934544362571476},
{-0.23300053007680888,0.3526008021677374,-0.906302061839536},
{0.03210146048916818,0.8452384549982851,-0.5334242686891686},
{0.35621787546149725,0.8926447940396756,-0.2762138607593081},
{0.5774910662823064,0.7462884550069009,-0.3309948795488198},
{0.5799999710000022,0.8038999598050031,0.13169999341500052},
{0.2968964298418966,0.7861905461155242,0.5419934825675581},
{0.34999165279861993,0.9272778846861722,0.13289683044839024},
{0.5238946301075619,0.8464913235084007,0.09479902831493961},
{0.5407752087288207,0.7262667050660918,0.42438054471988074},
{0.5311286100131384,0.565530463118866,0.6309339861745227},
{0.3788815375525016,0.5963709395521561,0.7076655162995655},
{-0.026999640232190845,0.526592983195248,-0.8496886779737985},
{-0.34240044340886133,0.5381006968408537,-0.7702009974109375},
{-0.2922143889907796,0.5392265521691594,-0.7898388926246328},
{-0.18619761109997432,0.48389379168247887,-0.8550890292781311},
{-0.0507010092136327,0.7771154686373564,-0.6273124867793253},
{-0.25860831051158956,0.755124266308203,-0.60241935905716},
{0.054398455921742674,0.3949887884023595,-0.9170739692248201},
{-0.026899540290784615,0.8463855353947991,-0.5318909100620199},
{-0.16399918656605195,0.931595379298378,-0.3243983909879711},
{-0.2875008783165249,0.9358028588821008,-0.20400062322285592},
{-0.18359997613200468,0.9788998727430249,0.08969998833900228},
{-0.12410431021754209,0.992234460901251,-0.008300288274017723},
{-0.1925000510125203,0.9809002599386033,-0.02790000739350294},
{-0.36710760104157014,0.8567177385244161,-0.36230750165448344},
{-0.32699156372648236,0.7885796549073516,-0.5207865638799756},
{-0.24399558371990168,0.6775877357729728,-0.6937874425609335},
{-0.5306983813724052,0.4843985225867592,-0.6954978787347048},
{-0.5274176002189839,0.3685122974605528,-0.7655255460137128},
{-0.46759476998174654,0.16189818917888102,-0.8689902803980705},
{0.9687359359260771,0.04260158033493433,-0.2444090665224871},
{0.8778817665850601,0.11529760529360683,-0.46479034640475675},
{0.7465756396343116,0.16669456084521797,-0.6440789840456203},
{-0.25920874973902364,-0.9519321330114838,-0.16320550909494083},
{-0.20210104890716576,-0.978905080530552,-0.030000155701212138},
{-0.31601171477140394,-0.947535125778181,0.048101783166153565},
{0.4307119610372393,-0.5746159573067047,-0.695919325948026},
{-0.11639470823488242,-0.9685559656040129,-0.21989000292827013},
{-0.13429405224813598,-0.7234679583136737,0.6771700088044504},
{-0.396006237147353,-0.6805107181282164,0.6165097101044019},
{-0.057402540405639725,-0.995244045499872,0.07870348309971859},
{-0.15940580167973012,-0.9587348937914509,0.23540856785074324},
{-0.24890936663570304,-0.9683364391858227,0.01920072253678384},
{-0.15740290489741507,-0.9448174367666947,0.2873053022682805},
{-0.14179995391502248,-0.9889996785751567,-0.042099986317506666},
{-0.20790099480864024,-0.9779046792850856,-0.021900104792252146},
{-0.43108640805982745,-0.6376798942698956,-0.6383798721999393},
{-0.2656038712046344,-0.777011325022594,-0.5707083181343556},
{-0.10569662463218771,-0.7616756762756611,-0.6392795849324276},
{0.03250018411406451,-0.5111028954061038,-0.8589048657098464},
{0.559582974946977,0.536983662520598,-0.6312807935740289},
{0.25720869122851736,0.006700226404475375,-0.9663326529320231},
{0.7049223146690619,0.03880122827232175,-0.7082224191355222},
{0.6774755266386423,0.037798634548989934,-0.7345734640129101},
{-0.047297419996106906,-0.23498718179883976,-0.9708470417382704},
{0.6513249234250514,0.02670102173414536,-0.7583290180150721},
{0.3043111547298187,0.016200593843651207,-0.9524349121415685},
{-0.39489192651709265,0.2987938912213403,-0.8687822379287164},
{-0.5436005544728484,-0.28960029539245197,-0.7878008035572295},
{-0.1264948606182175,-0.22989065973223877,-0.9649607944393667},
{0.7472244944203972,0.09020295690139164,-0.6584215834132622},
{-0.031101307059894365,-0.17350729179715987,-0.9843413678152418},
{-0.008300182730534242,-0.1528033640030882,-0.9882217559414382},
{0.21269858449563026,-0.04889967457374856,-0.9758935054503317},
{-0.8030944345748525,0.24199832295743282,-0.5444962266542238},
{-0.2822053097428547,0.12080227291614758,-0.9517179067408745},
{-0.7701963916383577,0.4161980501167028,-0.483297735755412},
{-0.6289828132794376,0.26659271545357405,-0.7302800453703867},
{0.06490152325662646,0.713916755822891,-0.697216363860092},
{-0.871988433150151,0.48379358252069155,0.07469900912421591},
{-0.9896592813065386,0.11539525216002279,0.08519649466233918},
{-0.5708726501464815,0.7184655791386354,0.3973809619341596},
{0.6698680145659385,0.5617731759712558,-0.48547681903532336},
{0.13119670634803018,0.4093897224000271,-0.9028773335490584},
{0.11249915738446677,0.18279863084338244,-0.9766926845991883},
{-0.21328765740038902,0.1757898273370295,-0.9610443859705292},
{-0.39258357857235526,0.27428852675088394,-0.8778632797469961},
{-0.20320289667793834,0.5170073699925892,-0.8315118532859535},
{0.05010131242106853,0.5892154347004706,-0.8064211244780372},
{0.2109009585470349,0.4933022420637853,-0.8439038355516488},
{-0.07500301593190715,0.3947158718443167,-0.9157368225179651},
{-0.6963002994091932,-0.6616002844881835,0.2783001196690772},
{-0.5308083098691371,-0.5223081767985122,0.667410448392355},
{0.3320023887657808,-0.9360067345926832,-0.11690084110457763},
{-0.27061226713210995,-0.6493294347704324,0.7107322182216945},
{-0.9727359481212065,0.22680838185863023,0.048401788721153895},
{-0.7507132614668968,0.5877103819955978,-0.3017053296717234},
{-0.8819334876503012,-0.3794144066385353,-0.2797106208139123},
{-0.8903877260897932,-0.025399649868239834,0.4544937348470474},
{-0.9497763081254869,-0.29359267642202885,0.10829729855758079},
{-0.8189818310896136,-0.3870914124722704,-0.4235906027467159},
{0.038798093314554936,-0.9990509028497897,-0.019799027000726492},
{0.21340387865074203,-0.6760122866349654,-0.7053128191769839},
{0.3250106247709885,-0.48491585215831484,-0.8119265423125094},
{0.4882708852751407,-0.44187365185968597,-0.7525551264756725},
{0.19630679724053374,-0.9655334321738936,-0.17090591771985336},
{-0.4615999953840001,-0.5914999940850001,-0.6610999933890002},
{-0.5499014132484481,-0.41610106938112246,-0.7242018612011748},
{-0.3644894244927703,-0.5772832503694822,-0.7306787996621873},
{-0.31051090222916927,-0.7817274469325012,0.5408189884880346},
{-0.09980192569673467,-0.637912308636744,0.7636147340884427},
{0.03270017233036228,-0.6279033090591583,0.7776040979843947},
{-0.04099764680260836,-0.9337464044945288,0.3555795903172569},
{-0.12229699030810233,-0.5002876880714929,-0.8571789050867155},
{-0.13159630153791718,-0.4105884605734711,-0.9022746419275279},
{-0.9928785490906679,-0.08679812474677205,0.08159823708913133},
{-0.9983178450909729,0.01060018948008045,0.05700101890231941},
{-0.7147833850533195,-0.36639148332895394,-0.5956861534362933},
{-0.7357650667039296,-0.5243751032611317,-0.42857965152120714},
{-0.9292998420190403,-0.18369996877100794,-0.3203999455320139},
{0.21960626106375566,-0.9599273679193947,-0.17410496380327808},
{-0.508119179320392,-0.6791256340808467,0.5297199946585547},
{-0.8961802080786544,-0.00019999558314631876,0.44369020121010816},
{-0.9856922179906582,0.14129888444971087,0.09189927445809219},
{-0.9092129745617211,0.10790153976595876,0.4021057380898241},
{0.9900849656739434,0.1289980411796169,0.05559915573323023},
{0.944444479660179,-0.3274154199923153,0.028701351721989767},
{-0.09169503530671633,-0.4891735144170734,-0.8673530384410658},
{0.17929862747426,0.710094564246916,-0.6808947877703493},
{0.0877987036617106,0.5744915176953614,-0.8137879845091125},
{0.23719856139508774,0.9026945251743073,-0.3589978226848082},
{0.2784844637851361,0.9437473498039907,-0.17829005347536717},
{0.8739251825169566,0.3596103623218876,0.3270094229122838},
{0.7426774786469349,0.6549801380284669,0.1393957728872798},
{0.599398738266984,0.7815983547371949,-0.17269963646764783},
{0.07930506815232559,-0.9067579482183304,-0.4141264655974531},
{0.237902394499651,-0.9639097017999732,-0.11950120278565908},
{0.22459643680579489,-0.9670846573236164,-0.11959810259115347},
{0.5919099116144557,-0.7749129760264263,-0.221703712459748},
{0.36700191391997167,-0.9141047670687904,0.172400899073033},
{-0.6256968871657296,-0.45849771897952213,0.6310968603009299},
{-0.9173829322493168,-0.36469321494585333,0.15939703444576095},
{-0.4464201697189122,-0.8892401767788007,0.0998045092695955},
{-0.5583704601921846,-0.8294561187847729,-0.014999206487970575},
{-0.05290227458219455,-0.9446406156964265,0.3238139226789148},
{-0.3103173565351401,-0.9283519241752193,-0.2046114442381233},
{-0.32030881822315016,-0.6238171739232005,-0.7129196269474984},
{-0.48989915247519933,-0.07669986730934433,-0.8683984976718985},
{-0.9475784854747281,0.28029363600524093,0.15339651717161598},
{-0.9904249491187064,0.13450338818302304,-0.031100783438602352},
{-0.33999535909502226,0.06629909502352933,-0.9380871951971776},
{-0.7748045713604567,-0.4846028591653036,-0.40600239542119954},
{0.028501151327262268,-0.42861731434612654,-0.9030364788953624},
{-0.8000846945261891,-0.5643892033378092,-0.20329611098259498},
{-0.2815061411234536,-0.44060961200352994,-0.8524185957145005},
{-0.1263055657773867,0.10570465797838301,-0.9863434641823949},
{-0.2149017514564116,0.4388035762637199,-0.8725071109619317},
{-0.40608688157518263,0.1995935522344409,-0.891771191796966},
{-0.5650118201709182,-0.010400217574827522,-0.8250172595416063},
{0.11449573454086305,0.7954703653035506,-0.5950778307883633},
{0.39041754966329495,0.8835397160028715,-0.25871162934911474},
{0.48998500178863935,0.6568798932141984,-0.573082458214427},
{-0.08429605714413847,0.6274706507467009,-0.7740637940127829},
{0.3167875108985694,0.481881002215974,-0.8169677916797069},
{0.17449938314577085,0.6160978220980483,-0.7680972847808974},
{0.33178016013961775,0.7955524273872209,-0.5069696841193074},
{0.49478849877501735,0.8595800192946744,-0.1276970317169962},
{0.169707571672219,0.3178141795959411,-0.9328416196573123},
{0.3516093599657451,0.28960770945984016,-0.8902236980702681},
{-0.15900624906838498,0.07740304199932703,-0.9842386813402799},
{-0.22889270072815882,0.04589853631901481,-0.9723689916472767},
{0.9984129944296843,0.0121001574845745,-0.055000715838975},
{0.9950230947540469,-0.08770203558786926,-0.04730109787122253},
{0.8968284971782539,-0.23860758187637307,-0.3725118367516721},
{0.9542060639988051,-0.06410040735938316,-0.2922018569487014},
{0.1726983231074239,-0.37379637045486425,-0.9112911514058796},
{-0.5105022206894899,0.8469036840390384,0.14880064728422351},
{-0.37919402205336306,0.7134887519384878,0.5891907114816496},
{-0.6737852004706056,0.6589855255418955,0.3342926573424213},
{-0.6339007321557685,0.7728008925855464,-0.03080003557406163},
{-0.7605018137989888,0.6463015414310145,0.06270014954003499},
{-0.6498889422337211,0.5850900447775813,0.4850917462341561},
{0.38628194174132546,-0.052997522423738674,-0.9208569509437915},
{0.4644079042897971,-0.07760132078571977,-0.882215015427345},
{0.46230145394035893,-0.13810043432654892,-0.8759027547184953},
{0.43239420379454696,-0.03279956032484076,-0.9010879209973781},
{0.2383134853501136,0.05630318600592277,-0.9695548638142474},
{0.5343114851488112,0.8316178758183631,-0.15140325444793193},
{-0.44900095861807,0.6223013286147548,-0.6412013689663841},
{-0.5289115013056452,0.623913567148028,-0.5753125103065564},
{-0.02450093521854628,0.9970380576690057,0.0729027827523275},
{-0.0654967691240667,0.9639524493984777,0.25788727873430234},
{0.08600317830618254,0.8560316352336308,0.5097188370076889},
{-0.06469853427130892,0.9420786574497704,0.32909254449285574},
{-0.26750103656852503,0.8968034751201991,0.3524013655579373},
{-0.40550098739610646,0.7778018939499177,0.4802011692912708},
{-0.15349391101732252,0.7594698724277292,0.6321749221182494},
{-0.42051203732935527,0.2845081441621916,-0.861524661496408},
{-0.03530107970003419,0.8757267845133128,-0.48151472735315753},
{-0.3304018073028289,0.8757047901183029,-0.3521019260028029},
{-0.4929972885223697,0.8577952821389223,-0.14539920030659748},
{-0.6238654107411756,0.4351758723426184,-0.6491640080993288},
{-0.42000730819074433,0.9074157891720985,-0.013800240126267313},
{-0.2556084032643883,0.9208302727928352,0.2945096821649544},
{-0.11759809492629318,0.8441863242923189,0.5229915276058787},
{-0.7229053965089275,0.5225039005061759,0.4521033749642912},
{0.5508695983457778,0.007899564035091023,-0.8345539422388566},
{0.12340324431394009,0.909523911697962,-0.3969104349125026},
{-0.1773025053021,-0.9786138279110833,0.10430147379023706},
{-0.9512055122519153,-0.30590177270590924,-0.040400234120035086},
{-0.08920404415701487,0.9410426631362219,-0.3263147938165241},
{-0.43089155891704045,0.8918825281924074,-0.13739730841309203},
{-0.32979359547056336,0.2001961122292504,-0.9225820836299022},
{-0.32611272190542717,0.8299323762935111,0.45261765695920375},
{-0.005700078405117698,0.6960095736775294,0.7180098762937731},
{-0.614689227665677,0.7885861801482883,0.016999702082831476},
{-0.37741569893250243,-0.43981829462245514,0.8149338978804881},
{-0.6861990358910319,-0.11289984137583431,0.7185989903691279},
{-0.10130147850586826,-0.8556124877553888,0.5076074085841928},
{0.7696683326479163,-0.6047751170397034,0.20459158225251875},
{-0.9369424585095328,-0.22501019656809146,-0.2674121180547007},
{-0.29689668962036597,-0.7294918662110373,-0.6161931294849091},
{-0.4827215950335915,-0.42301892417486886,-0.7668343050999751},
{-0.08150313181801132,-0.3393130383540029,-0.9371360101430479},
{0.0803024564897166,-0.8408257212522257,-0.5353163755783972},
{0.2829990590296931,-0.12379958836705302,-0.9510968376082723},
{-0.7026262927678222,-0.15520580791000002,-0.694425985906598},
{-0.6704879682013649,-0.7407867067018212,0.040999264274803826},
{0.3163052222423292,-0.22200366531077168,-0.9223152275501113},
{0.3424169226624873,-0.14140698850606223,-0.9288459046989433},
{0.349289614027738,0.03729889093396687,-0.9362721603612113},
{-0.06819913217156463,-0.04859938157680412,-0.9964873197795332},
{0.12110209387330476,-0.3990068988889232,-0.9089157152885772},
{-0.6581307650416847,-0.5663264735497736,-0.49612319182066517},
{-0.12210035531255095,-0.015100043941191806,-0.9924028878966057},
{-0.36591778769600036,0.0019000923657349021,-0.9306452397646842},
{-0.5079218792061804,0.06380274836257985,-0.8590370038159262},
{-0.6427737689377236,0.05229786576764615,-0.7642688108262323},
{-0.6067131112120014,0.09670208975473962,-0.789017050842705},
{-0.16889372909225606,0.7027739064892691,-0.6910743408860756},
{-0.3568167779193559,-0.4336203893100693,-0.8274389070921387},
{-0.5540166983149346,-0.5626169575306537,0.6136184947401513},
{0.027200946065356512,-0.9068315401494591,0.42061462923121135},
{-0.918091562777307,-0.16009852870128183,0.36259666775193494},
{-0.3863920172233854,0.47439019919972575,0.790983658446423},
{-0.234410359994795,0.034001502729620436,-0.9715429382890075},
{-0.35431523233926443,-0.8123349230290277,-0.46321991425217973},
{-0.3085928561580689,-0.45468947406051174,-0.8354806588466188},
{-0.2579949111005673,-0.23519536081726133,-0.9370815162493862},
{0.041699727701667154,-0.5340965123611614,-0.8443944861220083},
{-0.6901591541391576,-0.09969409977930167,-0.7167575799579081},
{0.7095443266186691,0.16091005236496664,0.6860428584360916},
{0.9087893445074031,0.09999882752062095,0.40509525028603544},
{0.3293171496371126,0.2406125302237756,0.9130475481891401},
{0.6634854764618786,0.3191930129414192,0.6766851875233659},
{0.21089842143122337,0.3579973204000852,0.9095931917204398},
{-0.2126109061561541,0.33791733391422607,0.916847030874704},
{0.10870399494522272,0.43951615251541293,0.891632768106353},
{0.3957851721862809,0.31598816172527733,0.862267695745907},
{0.7985725774885254,0.3003896847953331,0.5215820891785811},
{0.9814857980032536,0.0037999450151934423,0.19149722905514321},
{0.9982768701928733,0.013099696483548674,-0.057198674722059854},
{0.9978977796799103,-0.010199977305075745,0.06399985760047526},
{0.9429439280661073,0.004900228282451931,0.33291550923025465},
{0.9112759927502024,0.14719612216924152,0.3845898681133851},
{0.5483956293042516,0.31969745202146105,0.772693841654623},
{0.17708913591475725,0.5297674997608041,0.8294491148576574},
{0.36260062729962783,0.6883011907620901,0.6283010869618206},
{-0.026700038848584788,0.5306007720246849,0.8472012326786903},
{-0.25840367452637786,0.3168045049920918,0.9126129774488096},
{-0.4962921139809628,0.3304947484801697,0.8027872438120429},
{-0.3050033337046562,0.21950239917433456,0.9267101289970653},
{-0.06090109440249972,0.34420618544072906,0.9369168365468306},
{0.1399040118050586,0.13420384835052798,0.981028131385007},
{0.24730503889150163,0.2786056766484932,0.9280189085778954},
{0.43570897134008074,0.41880862335833335,0.7967164045596565},
{0.7665221298133361,0.37001068236260193,0.5249151545192696},
{0.9979707299477295,-0.026499222789193217,-0.05789830186770895},
{0.9570392920547195,-0.06080249629772931,-0.28351163980931343},
{0.9079153847565432,-0.03230054733741199,-0.41790708149549444},
{0.992747469355148,0.03080147280763429,-0.11620555650152936},
{0.9946374736727442,-0.09150344745732565,-0.04820181603762947},
{0.9764630757469228,0.18629295546508112,0.1086958897426426},
{0.8781654712124946,0.26658951790622987,0.39718438301708364},
{0.45108841168755376,0.24009383206868024,0.8595779177269368},
{-0.0600996832755037,0.45629759531800895,0.8877953213309848},
{-0.7300857379144134,-0.15089705225487604,-0.6664869803040084},
{-0.6347921032353533,-0.297796295437127,-0.7129911304455054},
{-0.6918878159628403,-0.38309325378720066,-0.6119892229646745},
{-0.5816937497342385,-0.0901990308166208,-0.8083913138819984},
{-0.6724267732049733,-0.34101357772590113,-0.6569261560356142},
{-0.770168608567259,-0.21979104149971895,-0.598775594404148},
{-0.6803975709850073,-0.21269924066506624,-0.7012974963724069},
{-0.36488776551832985,-0.16469447788673316,-0.9163692746533227},
{-0.3131040782071781,-0.003500045588390685,-0.949712370084181},
{-0.3322049150080766,0.04540067170790692,-0.9421139386788349},
{-0.04690114862319485,-0.20790509165804286,-0.9770239276089844},
{0.5149935497461838,-0.2606967347938449,0.8165897722771529},
{0.3173826063228776,-0.24028683144104443,0.91734972602586},
{-0.0035000674469495606,-0.3411065731869986,0.9400181143235962},
{0.3255054327310088,-0.44810747897623665,0.8326138964418983},
{0.5044733771200152,-0.2538866014881504,0.8252564482401359},
{-0.22009877405324277,-0.34929805441525535,0.9107949268863859},
{0.2428906173166761,-0.35978610173133,0.9008652002494586},
{0.24130090608660354,-0.37420140512891437,0.8954033622459379},
{0.3688130820320336,-0.3981141213583313,0.8399297928381373},
{0.8732828270620571,0.1661967317734042,-0.4579909936956626},
{0.984885960550698,0.12669819393011822,-0.11809831652049693},
{0.8877061163162122,0.197701362167078,-0.41580286489160867},
{0.7258954305026475,0.2076986925408457,-0.6556958724074748},
{0.8086596852763107,0.23088848934128867,-0.5410730254767055},
{0.9902927758405503,0.1338990232101885,-0.03729972789947746},
{0.9102060574414684,0.2933019519309852,-0.2924019459414254},
{0.9791887344984141,0.20209767487962574,-0.018599786010692915},
{0.9855911198640148,0.09049918460602002,0.1428987124884007},
{0.9768203473797561,0.07810162687383185,0.19930415154871559},
{0.9798662049973744,0.1283955717130961,-0.15289472675180993},
{0.9424751708186829,0.1449961801259512,-0.30119206519956215},
{0.7998193518633303,0.27290660305514236,-0.5346129351164496},
{0.5216880065305932,0.26699386188167223,-0.8102813718453895},
{0.33339153029575785,0.21699448732507337,-0.9174766918007135},
{0.5576915175765259,0.08969863569412656,-0.8251874489943505},
{0.6959098506736549,0.233203301016089,-0.6792096142801357},
{0.9036768029141998,0.24139380350059517,-0.3536909208705904},
{0.9901923557445205,0.06319951210164987,0.12459903809913882},
{0.8123158443750683,-0.17510341542542712,0.5563108509489727},
{0.9083133114291192,-0.008400123104706156,0.4182061288557279},
{0.8371585281937445,0.22178901284444877,0.4999752318405067},
{0.34940287035637,0.5860048140493211,0.7311060060605098},
{-0.047201397890098085,0.6142181903410644,0.7877233287718275},
{-0.2862910993480797,0.5242837002731338,0.8019750669827452},
{0.2574089193735871,0.5325184520840526,0.8063279397471768},
{0.8240851418788366,0.34329381046839536,0.4505918759017155},
{0.9874112664268253,0.0441005031896121,0.15190173320866393},
{0.9935707844806173,-0.09169730368042735,-0.06639804759411533},
{0.8442034570202348,-0.28110115111157075,-0.45640186896948015},
{0.2818076413177929,-0.41781132910778523,-0.8637234201780615},
{-0.042501136920619145,-0.49241317222853803,-0.8693232547080993},
{0.05620175661335485,-0.4919153750553248,-0.8688271556171299},
{-0.4337889623802766,-0.5748853722278031,-0.6937823469327706},
{-0.5702107742343697,0.2819053266514711,0.7716145797952292},
{-0.6468373494668685,0.2478143092113327,0.7212416456949683},
{-0.5354940158878084,0.5036943712468518,0.6778924245944824},
{-0.36480786169413015,0.5755124024259098,0.7319157729548625},
{-0.6877044804092849,0.29080189458051486,0.6652043338203524},
{-0.5097979098328547,0.595997556415028,0.6203974563756434},
{0.12219283115688788,0.7202577437177279,0.682859937782641},
{0.34069243160169704,0.46648963704781826,0.8162818664997514},
{0.6822149099697878,-0.13320291118143615,-0.7189157120745829},
{0.4152938163211121,-0.20629692826160712,-0.885986807754648},
{0.5684076593448149,-0.26320354669168766,-0.779510503974812},
{0.8152103695418512,-0.21840277810100628,-0.5364068231381857},
{0.9519060779397116,-0.08590054847675305,-0.29410187784648506},
{0.9876432547835357,0.13330583825703252,-0.08240360894508236},
{-0.4184115880693996,0.06220172270056561,0.9061250954820339},
{-0.7018178614918653,0.22310567811176282,0.676517217582284},
{-0.3560936865149067,0.323994255632771,0.8764844600682832},
{0.09269633764004832,0.14029445707549926,-0.9857610533501578},
{-0.09259773092040534,0.11029729719784782,-0.9895757507433383},
{0.14149448323764574,-0.05929768802821479,-0.9881614723352758},
{0.8119872356609823,0.07379883989135529,-0.5789908983346167},
{0.8087088190177574,0.33870369358391794,-0.4809052443002838},
{0.7118192193783883,0.597616135853505,-0.36900996340351966},
{0.8715254401989045,0.4264124471610016,-0.24210706720843922},
{0.9248702658989194,0.37548792825715666,0.06019806466333111},
{0.9104998452150396,0.33529994299901456,0.24199995886001052},
{0.8668755501199085,-0.05759837546072987,0.495186033474886},
{0.7911205654464017,-0.07360191330660493,0.6072157847794907},
{0.6251052821619515,-0.19220162411058564,0.7565063925060251},
{0.73212788728235,-0.11710446059385765,0.6710255598503714},
{0.8954233663776223,-0.001900049582440789,0.4452116179487575},
{0.7827255250955668,0.31251019112350154,-0.5382175515605393},
{0.9826743427078636,0.06979817759337426,-0.17169551708857247},
{0.9003350327176979,0.1600062259633807,-0.4047157477961261},
{0.6847228598542707,0.22950766224120805,-0.6917230935609743},
{0.8861222463782465,0.15230382363548914,-0.4377109888723152},
{0.9607607393145655,0.11549528038179883,-0.2521896944786984},
{0.9912199038955073,0.12440249802724083,-0.04480089961109638},
{0.8648061833863169,0.4629033097704973,0.19450139068991518},
{0.7672976482363122,0.5779982284381447,-0.27779914854691456},
{0.3286956990449168,0.7921896342664531,-0.514193271825057},
{0.33169060333830924,0.5370847846035752,-0.7755780281856878},
{0.4275172164649676,0.34391384968959615,-0.8360336677537143},
{0.589096645104159,0.15169913607588006,-0.7936954799171126},
{0.8786254585414972,-0.09720281649241239,-0.4675135464012633},
{0.7895991077535123,0.3076996522995893,-0.5308994000840168},
{0.844894985563141,0.3280980527438354,0.4224974924848231},
{0.5127149022752051,0.8557248720048625,0.06970202591882542},
{0.30010837013916636,-0.38891084687478117,-0.871024293206311},
{0.5198058114614584,-0.3448038549286473,-0.7816087384345438},
{0.7273199943014688,-0.29780818685958677,-0.6183169977679062},
{0.1295043060897674,-0.3086102614617932,-0.9423313330377439},
{0.05059910794559031,-0.34269395835877076,-0.9380834617343533},
{-0.3036969493794652,-0.4911950659703434,-0.8163917993855626},
{-0.2629147486164971,-0.5244294186933856,-0.809845429553592},
{-0.6570135411886273,-0.24570506403355513,-0.7127146892011182},
{0.14369475380030639,-0.6036779601200067,-0.7841713704258891},
{-0.6804076954545536,-0.6889077915911845,-0.24990282641695025},
{-0.004300006686515596,-0.23160036013884003,0.9728015127075283},
{0.5541097247110037,-0.1585027817482297,0.8172143422375605},
{0.7436030041622053,0.0050000202001224126,0.668602701160369},
{0.8637498311651813,0.17180991199974316,0.47372733011803453},
{0.5457097082620657,-0.43070766235747066,0.7188127877932433},
{0.44838730185141484,-0.547184503954269,0.706779984274264},
{0.47421288691030505,-0.14950406282811177,0.8676235779911022},
{0.37240887833349046,0.061601468596517224,0.9260220766294635},
{-0.032300850977128634,-0.1579041600398951,0.9869260009079953},
{-0.3881060525610849,-0.3896060759541321,0.8352130252486939},
{-0.25239826729184256,0.021099855149991593,0.9673933588673871},
{-0.7412998109685722,0.2370999395395231,0.6278998398855612},
{-0.01960039504994339,-0.26070525456735927,0.9652194541941509},
{0.06170293435281639,0.3826181958409651,0.9218438393261935},
{-0.6637046824530521,0.16660117537543842,0.7292051445604424},
{0.5122740847095653,0.07249633250330564,-0.8557567083631583},
{0.8596901394106511,-0.18459788267442848,-0.47629453693299184},
{0.7257970786726374,0.14709940792607465,-0.6719972952163301},
{0.840306919955979,0.4062033450983204,-0.35900295640151897},
{0.8618913552730596,0.5060949238933699,0.031799681050798584},
{-0.6658011418499373,-0.40180068908877264,-0.6287010782232738},
{-0.04649932529968481,-0.17989738970781288,-0.9825857427843075},
{0.7273078040546065,-0.08830094747424963,-0.6806073029555413},
{-0.6718060798725343,-0.4121037295556288,-0.6155055703506176},
{-0.7589218534694104,-0.21740626030339946,-0.6138176751344369},
{-0.6916095823171451,-0.17070236509765277,-0.7018097236410821},
{-0.8327777984398365,-0.09619743541055747,-0.5451854655492301},
{-0.7085989512743283,-0.2015997016326624,-0.6761989992262217},
{-0.817496881255347,-0.31569879561139214,-0.48169816232501617},
{-0.6568134451088334,-0.26510542676362936,-0.7059144502166953},
{-0.6493299283061094,-0.04220194513247777,-0.7593349985566438},
{-0.6470852433892849,-0.1851957766584694,-0.7395831339989415},
{-0.43170003237750365,-0.15500001162500132,-0.8886000666450075},
{-0.4285992692388689,-0.3678993727321042,-0.8251985930375982},
{-0.10750316171447973,-0.27180799399065664,-0.9563281260237857},
{-0.3292034484241834,-0.42040440375919413,-0.8455088567516619},
{-0.9313067287154225,0.02310016689930877,0.36350262631596275},
{0.9235872684372562,0.3593950457734408,0.1334981597405519},
{0.9190541862906917,0.22078899394297108,0.3264837251919387},
{0.3838137695659792,-0.12410445232709229,0.9150328273915346},
{0.2859948221106181,0.04889911468954275,0.9569826739855298},
{0.5398212990695405,0.18440727593261072,0.8213324063093991},
{0.492688653510963,0.29939310505618494,0.8170811828370365},
{0.7565959862689393,-0.01559991724265854,0.6536965321490954},
{0.06000242264672252,-0.12890520465270888,-0.9898399655954326},
{0.2909974072246524,0.039899644495751306,-0.955891483044829},
{0.19050345385892797,0.018200329974973697,-0.9815177950789387},
{0.510093774343476,-0.4363946738355086,0.7411909538196126},
{0.9014924500323462,-0.03349971944102452,0.4314963862328979},
{0.4501022437652778,-0.28610142621916457,0.8459042168430314},
{0.3691075335616407,-0.19860405355009986,0.9079185308063226},
{-0.39388682273676423,-0.08869703269040617,0.9148693935563992},
{0.5815248752585702,-0.28961238843487863,0.7602325196415564},
{0.3158016358567106,0.22400116032901576,0.9220047759971095},
{0.5400188955917409,0.3331116557807572,0.7729270451904751},
{0.5307725040426238,-0.3180835221099446,0.7855593051542674},
{0.3763128663568549,-0.2063070537587541,0.903230881991792},
{0.3803802017257369,-0.34948180994517625,0.8562554330645333},
{0.6349061268736866,-0.12130117056194392,0.7630073630565805},
{-0.05490188838292695,-0.28740988563302744,0.9562328901958972},
{-0.3920098395704614,-0.1078027058818769,0.9136229322234019},
{-0.3693056190277406,-0.172202620082797,0.9132138946551116},
{-0.04750198823732738,-0.40101678490880593,0.914838291358044},
{-0.5108975451431933,-0.19939904188990554,0.836195982087959},
{-0.6472165268850237,-0.011500293663748103,0.7622194635225047},
{-0.6882145421269144,0.029300619128623348,0.7249153176224937},
{-0.4089872806933526,-0.10419675953116711,0.9065718060552408},
{0.17300580617228434,-0.1378046248008138,0.9752327293596051},
{0.22610470641844665,-0.395008222181718,0.8904185342546878},
{0.3858118561805134,-0.4877149877118621,0.7831240657723174},
{0.171004934418575,-0.4060117156370845,0.8977259042547063},
{0.4718905198146844,-0.5640886675725015,0.6775863874262135},
{0.29289957676041734,-0.6207991029459443,0.7271989491982775},
{-0.26440627972371605,-0.27850661461064646,0.9233219291562292},
{-0.47320391577860466,0.06000049650616289,0.878907272987776},
{-0.6936746293143907,0.051098131120030796,0.7184737223041513},
{-0.7835784949833037,0.181195027170718,0.5942836901079345},
{-0.8231330864993811,0.1450058286264248,0.5490220683855671},
{-0.8721198801992563,0.2944067110774694,0.39080890859060813},
{-0.901881827264269,0.25499486190529835,0.3486929739073629},
{-0.9195766936240464,0.2521936082339979,0.3012923638418064},
{-0.8226371634733088,0.09350422414874103,0.5608253358568339},
{-0.7048106215761013,0.108101629103826,0.7011105658158409},
{-0.2102891766946061,0.18409052510450302,0.9601505823212592},
{0.10349982870792522,0.032499946212633524,0.9940983547685842},
{0.17110896206658852,-0.0010000523791150703,0.9852516039041671},
{-0.11150320409060498,-0.2522072472793773,0.9612276212725517},
{-0.25408864122118563,-0.3681835407227098,0.8943600185290376},
{-0.1355013584079271,-0.5303053163374446,0.8369083900486656},
{-0.05899890941523909,-0.5308901865856006,0.8453843732142904},
{0.04900064142259436,-0.5181067820621661,0.853911177770476},
{0.6475895706539463,-0.49909196218867297,0.5757907269650128},
{0.7547583384895412,-0.6143660879278936,0.22998730505113207},
{0.801793004386555,-0.572495005002872,0.17139850455457165},
{0.8243101473203707,-0.55550683833127,-0.10920134427682213},
{0.727615276443095,-0.09400197359215356,-0.6795142665517909},
{0.8202653486222558,0.015399349468222282,-0.571775845839578},
{0.7361242115234821,-0.24990821961651702,-0.6290206888306891},
{0.5909003840853745,0.22580014677014312,-0.7745005034254908},
{0.7749841672351935,0.11249770169543132,-0.6218872949723443},
{0.9322086276307733,0.09510088016271888,-0.34920323189086677},
{0.8639705520655907,-0.17109416835465574,-0.4735838581692868},
{0.3605105667195681,0.007200211041278475,-0.9327273386389492},
{0.3186180884623376,-0.4093232379398455,-0.8549485368061909},
{0.4841994480129439,-0.7679991244814971,-0.4191995221128172},
{0.5477059207330048,-0.4510048753890546,-0.7047076179305249},
{0.5417073618530717,-0.05430073795204319,-0.8388113995243799},
{0.26968824454562484,0.18779181433321596,-0.9444588319367544},
{0.27069387968056985,0.1071975762901998,-0.9566783697465872},
{0.5477147501568352,0.5989161290285351,-0.5842157331415432},
{0.6984604333371454,0.5863667832625655,-0.41027675847992945},
{0.8665889163986386,0.24789682941982746,-0.43309446075727015},
{0.9834126221820092,0.12940166088097618,-0.12710163135990782},
{0.9966836794383728,0.01189980514228618,-0.0804986818448771},
{-0.11659779515654019,-0.3850927179655543,-0.9154826883860424},
{0.4112934419783511,-0.369194113246796,-0.8333867117548208},
{0.34281141409605165,-0.03810126860285755,-0.9386312522478241},
{0.11090483444710263,-0.05250228862464281,-0.9924432615446767},
{-0.2603104217363555,0.15600624583508052,-0.9528381476388764},
{0.06269915168621648,0.09409872685283846,-0.9935865568648278},
{0.23860224645072559,-0.004000037660531862,-0.9711091430356228},
{0.7435070447626239,-0.12360117112664465,-0.6572062270585022},
{-0.48051356268671297,0.3867109150696189,-0.7871222168381099},
{-0.5844948038642903,0.4116963400358055,-0.6991937841948876},
{-0.14760215795932416,0.2512036726245408,-0.9566139857987093},
{0.16029813574352186,0.13789839625097733,-0.9773886330362962},
{-0.33740333187435345,0.33820333977447053,-0.8785086753160034},
{-0.6696318584935197,0.2438115996127839,-0.7015333762443311},
{-0.7882505703565508,0.46217101816414785,-0.4062745233234385},
{-0.8319988601623424,0.4656993619923111,-0.30149958694584883},
{-0.8051110542506628,0.4862066756634856,-0.3397046641770589},
{-0.7933966042698005,0.3953983076988645,-0.46279801922871655},
{-0.27049019490814863,0.30638889360390664,-0.9126669164239085},
{0.1441992400720072,0.04109978340471218,-0.9886947895921882},
{0.7742589111698474,0.22618799652152846,0.5910686328199622},
{0.7354574219250508,0.39227728976369464,0.552468015790062},
{0.5650779595640224,0.7491707791636268,0.3455865206606373},
{-0.03210020752851251,0.7571048946989665,0.6525042184534084},
{-0.7149056835227761,-0.13530107564782712,-0.6860054537650363},
{-0.9860666468597453,-0.16499441915815638,0.021199282946381303},
{-0.8311904081180351,-0.17419798976679704,-0.5279939069854699},
{-0.6076923765469541,-0.17259783477374407,-0.7751902752989942},
{-0.66583631237347,0.07770423771615893,-0.7420404682804367},
{-0.9297937611047944,-0.10529929344411149,-0.35269763340681975},
{-0.9858920833183563,-0.1524987754397498,-0.06899944593667369},
{-0.8829748664781335,-0.01119968120561166,0.46928664194585284},
{-0.9032897296541603,-0.010799877206094247,0.42889512349016873},
{-0.9535804708719327,-0.08799819781536292,0.2879941019411877},
{-0.8810886075979552,-0.29609617150125356,-0.3687952315084847},
{-0.8043486444552047,-0.29901808366543103,-0.5134310506817134},
{-0.5758117783503904,-0.29080594849651537,-0.7641156301450736},
{-0.34559533276654625,-0.183397523233173,-0.9202875716002676},
{0.16540077573145728,-0.015500072695511414,-0.9861046248415358},
{-0.366405246960705,-0.09480135756516056,-0.9256132548767154},
{-0.5297989589460685,0.37299926705716036,-0.7616985032639116},
{-0.9158623725673688,0.17899264623819083,-0.3593852349609262},
{-0.9891272112638779,-0.013900382404780004,0.1464040276302009},
{-0.9479326426225827,-0.15060518617888066,0.2806096629601189},
{-0.9208291262859039,-0.15390486808796766,0.3583113335667239},
{-0.8684628870315172,-0.1748925261275905,0.4638801765042266},
{-0.7421140631947476,-0.018700354375073145,0.6700126968609095},
{-0.8321182194278738,-0.07420162466235818,0.5496120338872245},
{-0.9386732059557484,-0.279592019159718,0.20179423986563338},
{-0.9579937730607125,-0.28619813971813773,-0.018399880401166087},
{-0.9194304888205224,-0.2684089005867177,-0.2874095306580576},
{-0.6405121346173365,-0.3381064054865285,-0.6895130629487175},
{-0.4440097283597237,-0.2813061634855637,-0.8507186394495877},
{0.23129669941964873,-0.1590977296915958,-0.9597863039471632},
{-0.027798703359721972,-0.11169479011801958,-0.993353666098842},
{0.3123863474530203,-0.11259507913959695,-0.9432587757760373},
{0.5419909379872746,-0.1239979267719964,-0.8311861026845436},
{0.4916029766650356,-0.032700198000298344,-0.8702052691088568},
{0.4857914987231579,0.7105875648264224,0.5089910927338152},
{0.17230079430849266,0.5485025286024853,0.8182037719280829},
{0.2773995034553332,0.5120990833434612,0.8128985449129069},
{0.4208100574805621,0.7634182459141186,0.49001171141985606},
{0.09009677234094529,0.8519694787401264,0.5157815224579311},
{-0.15679521781878367,0.5873820851196017,0.7939757841078715},
{-0.12919527541516554,0.24029121271102383,0.9620648179329004},
{-0.18329361324531776,0.3133890801477501,0.9317675331259525},
{0.38950840957734517,0.35960776401543854,0.8479183067538664},
{0.5969904930020977,0.4157933785431696,0.6860890741184913},
{0.5016916092780017,0.4883918317149213,0.7139880586495778},
{-0.2614988886320849,0.3360985715841061,0.9047961546245141},
{0.9193042563885606,0.2409011153747463,0.3112014408660068},
{0.7119079235792845,0.21730241858937843,0.6678074327380897},
{0.7021773586560993,0.10459662733612643,0.7042772909448743},
{0.5621896164536753,-0.014299735886317246,0.826884727580121},
{0.8581799316969431,0.22319478065108098,0.462289189493704},
{0.7368807639787313,0.18859507678977977,0.6491830532975876},
{0.48848231481793225,0.06199775541189723,0.8703684888792799},
{0.21269963947441664,-0.020699964913589206,0.9768983441587099},
{0.7916239232364458,0.13000392877809241,0.5970180421578551},
{0.928283453494911,0.29759469542183076,0.22299602513127778},
{0.9632514822447282,0.25628709114432036,-0.08039595055795302},
{0.7779634365777012,0.5261752703434271,0.34338386133776677},
{-0.8656365263038573,0.32161357077093405,0.38371619124629164},
{-0.727098305862921,0.4835988732159381,0.48729886459496824},
{-0.9601496938333898,0.2668138093060602,0.08320430635031563},
{-0.8580885660460357,0.5051932683445487,0.09199877412450214},
{-0.8345943706799546,0.5462963152437804,-0.07079952245883152},
{-0.7994269651263083,0.5203175506069779,-0.3003101296315116},
{-0.7476850987844703,0.5188896586321541,-0.4143917412548943},
{-0.7790769903008822,0.6000822768316767,-0.1814946396349764},
{-0.580684992390305,0.7667801828222591,0.27359292908212063},
{-0.11009971924607387,0.6296983942711418,0.7689980390575005},
{-0.05149835130667395,0.513283567489626,0.8566725740665548},
{-0.6163813485825835,0.323390214360168,0.7179782743061244},
{-0.8867045310717308,0.24830126882272555,0.3900019929152757},
{-0.9379045113315493,0.29690142809930375,0.179400862920226},
{-0.8250238064054056,0.5348154323219527,-0.18250526626543823},
{-0.8253932070418589,0.34729714175628495,-0.4450963368722212},
{-0.4662908747768701,0.31569382193235657,-0.8263838278267327},
{-0.719368028398451,0.41668148100310615,-0.555775299115734},
{-0.5500261131095945,0.8133386141673331,-0.18960900190105293},
{0.5227839586203408,-0.6106812615329803,0.594781749402025},
{0.35370668688812407,-0.3633068683812708,0.8619162946815779},
{0.7757877581657634,-0.027599564482308676,0.630390052523456},
{0.5622785804054614,0.07129728398169909,0.8238686153228875},
{-0.3646896028476322,-0.23619326622596848,0.9006743221411084},
{-0.0846008629332029,-0.07200073441123651,0.9938101369150951},
{-0.3138933172824118,0.34159272756824427,0.8858811397912986},
{-0.8586673326227336,0.13519485660951855,0.4943811916253401},
{-0.49221817303042864,-0.3646134617775178,0.7904291831841747},
{-0.7999055873600417,0.2779019411518384,0.5319037153604277},
{-0.8750153085267351,0.37600657829263134,0.3049053343654875},
{-0.8824716775260075,0.3136899322831825,0.3504887512440404},
{-0.881298576703948,0.4504992724442625,0.14269976954005828},
{-0.890166824100687,0.45528303191759467,-0.01789933290429375},
{-0.9390133528648174,0.3284046699476103,0.10200145047093863},
{-0.9796500685084799,0.1868904744352709,0.07319626928122969},
{-0.9171460367147529,0.07099582272868235,0.39217692498858053},
{0.07960185275468455,0.19270448524909187,0.9780227637447423},
{-0.537780992466726,0.034698773593520624,-0.8423702269504834},
{-0.3957912827929936,0.10789762358101064,-0.9119799138635932},
{-0.8629175087738813,0.3101062921205013,-0.39900809595640124},
{-0.75191569264426,0.4636096756348968,-0.4687097820752289},
{-0.9022265754751767,0.42881263086206584,-0.04590135204423699},
{-0.031799242392074906,0.2394942941164132,-0.9703768810462103},
{0.33200464809761027,-0.029600414408702605,-0.9428131994771897},
{0.05990025307910389,-0.4565019287247233,-0.8877037505562692},
{0.4283787507990868,-0.2456878129582998,-0.8695568667014144},
{-0.12500289635066306,0.3129072501449798,-0.9415218153131941},
{-0.47450587679167633,-0.08930110600104678,0.8757108457459873},
{-0.4863789572696108,-0.18209212195476177,0.8545630281303647},
{-0.001799988759105299,0.14179911446729523,0.9898938181324086},
{0.13699523949813974,0.10429637576391224,0.9850657695592515},
{-0.25219675046580525,0.37469517208381137,0.8921885042251841},
{-0.4689753419247653,0.26038630924778017,0.8439556259797483},
{-0.691301676408598,-0.20150048863927744,0.6939016827136208},
{-0.2814118899035279,0.05950251403432804,0.9577404653895121},
{0.06440083721632575,0.15500201503929334,0.9858128156499057},
{0.829458283444675,-0.12469372868661961,0.5444726164383671},
{0.9864152698265662,0.06180095668621431,0.15220235611070904},
{-0.573111041090561,-0.41450798557326385,-0.7069136188220512},
{-0.11199956880249017,-0.3400986906225617,-0.9336964052757596},
{0.09979584558542061,-0.10109579146979983,-0.989858793036151},
{-0.11820223758953657,-0.3669069456142214,-0.922717467206983},
{-0.8404882752703394,-0.30269577742335724,-0.4493937310011785},
{-0.8810922772600347,-0.43239621006382817,-0.19159832064807925},
{-0.630325396321837,-0.47021894550297916,-0.6177248886371549},
{-0.7487931710374202,-0.25159770543938953,0.6131944076925027},
{-0.9453972110823409,-0.2784991784286355,0.16929950056720997},
{-0.89217710256849,-0.029999230079639876,0.4506884332297898},
{-0.816325065645967,-0.1993061197883636,0.5421166459471747},
{-0.6105966264629582,0.08379953700883704,0.7874956490985581},
{-0.8590942827465724,-0.18529876684080998,0.4770968249311951},
{-0.8960000134400004,-0.4014000060210001,0.1899000028485001},
{-0.5779973614480675,-0.0347998411390878,0.8152962781809853},
{-0.46222443151800896,0.13680723113730772,0.8761463099371},
{-0.10329574327012794,-0.21669107034498283,0.9707599958048423},
{-0.1235983957032356,0.11719847877361822,0.9853872097570255},
{-0.6281983792502722,0.3995989690359898,0.6675982775986656},
{-0.9224142375736363,0.18390283856222,0.33960524184736224},
{-0.8053140568795454,0.016800293251678082,0.5926103441038353},
{-0.3927860936545269,-0.24509132269532727,0.886368618674574},
{-0.8444850231909193,-0.1600971607020322,0.5110909358826274},
{-0.9640941913499957,0.03679977828200378,0.2629984154393205},
{-0.9810534942613807,0.16759205548691,0.09719539256162084},
{-0.9665553461744862,0.20279063128924665,0.15699274710262193},
{0.7790938490783422,-0.02769978131108982,-0.6262950554200561},
{0.363793164390661,-0.2382955224691988,-0.9004830800818863},
{-0.2999074962815555,-0.016600414932556925,0.9538238411248672},
{0.052597693115768805,0.15599315829011282,0.986356739342098},
{-0.22489218625673038,0.46518383746834585,0.8561702528813364},
{0.5173087244852083,0.22270375593051592,0.8263139359020445},
{0.4712816910619465,0.42998329547345,0.770070083358381},
{0.747222768224627,0.4021122525470055,0.5291161224138786},
{0.1678948574592728,0.5522830838282095,0.8165749886911386},
{-0.46029295296883466,0.18019724120135566,0.8692866913226329},
{0.016699393238569813,0.4136849690297205,0.9102669260521019},
{0.2070081345444735,0.028001100324856323,0.977938428845607},
{0.20569825774313533,0.608294847764459,0.7665935069804937},
{-0.08399811006378513,0.4995887593793696,0.8621806011547087},
{0.5423898980822215,0.4709912278700706,0.6956870429494865},
{0.7651938287366568,0.4777961465896166,0.4314965199945993},
{0.11810274296805853,0.4115095574204579,0.9037209891637128},
{0.5744023148459934,-0.6697026989073149,0.470701896932467},
{0.6254169928105451,-0.6719182562670376,0.3967107787782911},
{0.3664876843882957,-0.24359181423462165,-0.8979698242310765},
{-0.26591042123361625,0.38001489307549513,0.8859347204620557},
{-0.6444233253243978,0.1524055164175019,-0.749327122386051},
{-0.21070091233692564,-0.2993012959774174,-0.9306040295241718},
{-0.6327174062952741,-0.2812077361312329,0.7215198492840844},
{-0.4323113223818017,0.0012000314292347027,0.9017236164507763},
{-0.5694913865079182,-0.28559568039800076,0.7707883419144923},
{-0.7753868883185768,-0.41209303156575383,0.47849190877023345},
{-0.8937825267224023,-0.4484912320821184,-0.002899943306662527},
{-0.10599550588582363,-0.08919621816052328,0.9903580097105634},
{0.6210169229417284,0.12650344726590765,-0.7735210787365973},
{0.6125953687965178,-0.08699934228745844,-0.7855940609313489},
{-0.7374769394566492,-0.24979218912036738,0.6274803789953184},
{-0.8372873654289827,-0.1374979251719636,0.5291920145527501},
{-0.05399905151499013,0.3716934712615154,0.9267837211869047},
{0.14590769464517103,-0.7014369912551265,0.6976367908462735},
{-0.04269945985524923,-0.8300894994342478,0.555992966733456},
{-0.6622769895857383,0.14459497613482977,-0.7351744568072396},
{-0.5632972229515362,-0.5860971105483673,0.5823971287892326},
{-0.6827800631132315,-0.3839887876910968,0.621581850074963},
{-0.5509919555761725,-0.21779682018963767,0.8055882384975762},
{-0.103804197407585,-0.3538143067707473,0.9295375866122374},
{-0.3461841208985532,-0.19509105137870517,0.9176579079971181},
{-0.6589024346489941,-0.7492027683093433,0.06740024904438033},
{-0.5704737188811428,-0.7241666384114348,0.3874821491085764},
{-0.5471944487404761,-0.7468924228148055,0.37779616727732435},
{-0.5000972144662731,-0.8047955173014528,0.3196982192858778},
{-0.6223726535463916,-0.7825656148223106,0.015599314581175625},
{-0.8975221017538869,-0.2259055629929839,0.3787093258319743},
{-0.9890200525848514,0.13110265813334077,-0.06820138279705446},
{0.3653178827480515,0.22991125443136334,0.9020441561421912},
{0.021600019656026828,0.4031003668215007,0.9149008325601363},
{0.4404090372861686,-0.4814098786320653,0.7578155505346471},
{-0.49803392473621444,-0.7509511527799667,0.43362953768197304},
{-0.6898709225534086,-0.31978652128218593,0.6494726253057529},
{0.5168090106436516,0.30080524458515945,0.8015139745179697},
{0.5699079987148934,0.2984041881321709,0.7656107454222185},
{0.13390034479383175,0.5258013539402296,0.8400021630083546},
{0.07949848199097945,0.3354935938109887,0.9386820760368855},
{-0.40830587352223624,0.29250420770329194,0.8647124389779027},
{-0.06649908564385856,0.39819452486292445,0.914887420384454},
{-0.17399704729516088,0.7662869962200103,0.6184895043221668},
{-0.06410041857709997,0.5902038540437504,0.8047052547424703},
{-0.22178710456369685,0.4380745288970045,0.8711493484936551},
{0.1077013602767705,0.5627071070356431,0.8196103517441142},
{0.5136114202768961,0.3984088587194615,0.7599168969400573},
{0.3639816758037858,0.4086794255522178,0.8369578644169471},
{-0.9267004309158006,0.008700004045502821,0.37570017470062184},
{-0.8841968655276675,0.02759990215852027,0.46629834697528993},
{-0.7770954850883474,0.3039982337753926,0.5510967981369042},
{0.9125301003017959,0.11430377037204961,0.39271295385042765},
{0.8772172769644064,0.06690131763442635,0.47540936327961564},
{0.9169015358113587,0.08480014204035687,0.39000065325164124},
{0.8904972884398852,0.14279956517598608,0.4319986845660083},
{0.862227380465207,0.07380234363063358,0.501115913188489},
{0.8939956686014784,0.10119950968956333,0.4364978851728695},
{0.8663689758824505,0.1170958068742324,0.48548261517882013},
{0.9378205947663941,0.11700256940463652,0.3268071767644035},
{0.9386732059557484,0.1761949705863459,0.2963915396242504},
{0.7419059834958854,0.18490149123654026,0.6445051979553823},
{0.14720665241893763,-0.0683030866862326,0.9867445919956912},
{0.8919151582269222,0.050200853170749515,0.44940763774770587},
{0.8845554504865761,0.15739207314784884,0.4390778863991132},
{0.8866288779728411,0.05570181423763506,0.45911495361756294},
{0.8753024727329782,0.05950016808821228,0.47990135572324494},
{0.9479954022334487,0.121699409759294,0.29409857362537684},
{0.937657853226725,0.16939238598337125,0.3034863585947649},
{0.9065977244425675,0.17389956351264338,0.3844990349086336},
{0.8846902950006954,0.03589960618348024,0.46479490122790007},
{0.9093657130121742,0.05239802436973601,0.4126844400265277},
{0.9425712425900763,0.1964940050593571,0.2700917596261188},
{0.9513480014744021,0.16780846698980834,0.25841303855879905},
{0.9440304926773782,0.19340624712267473,0.26720863097817316},
{0.7652785342381676,0.2944917396225537,0.572383944855517},
{0.4397953799737999,0.19759792424470865,0.8760907967145205},
{-0.15200754432164168,0.15750781730696423,0.9757484275962223},
{0.9904804382045164,0.035499298895770144,0.13299737332781492},
{0.9088660544867856,0.009299652664459352,0.41698442592253226},
{0.9136456788576004,0.0807040348990897,0.3984199195018257},
{0.9417497872399807,0.11679377272205325,0.31538318421691436},
{0.9238927890449221,0.04979961131555051,0.37939703881766795},
{0.9504462213236418,0.1163056560815862,0.2883140210517739},
{0.5600168399595702,0.05690171106017775,0.8265248539760441},
{0.7015366562479585,0.0715037361678247,0.7090370481536743},
{0.40588966212195693,-0.01629958485486055,0.9137767264031639},
{0.9438418650344059,0.07940352202133062,0.32071422559497137},
{0.9745526378926695,-0.04199795894879143,0.2201892990600922},
{0.8751156209532522,-0.01980035343946337,0.48350863070608785},
{0.8687821206479337,-0.07559844420002737,0.4893899284589074},
{0.96188890948481,-0.07519913295899544,0.26289696881542424},
{0.9730975818555135,0.03939990209136495,0.22699943590710264},
{0.9611331692780175,0.04490154957921443,0.2724094010106461},
{0.5790179324630569,0.1525047231444148,0.8009248050253234},
{0.25199533812936653,0.03799929701950765,0.9669821109964183},
{0.3996877957194837,0.2542922353051406,0.8806731090571661},
{0.38780633292912553,-0.7415121089916107,-0.5475089408940078},
{-0.5058811461610173,-0.8422686092338899,-0.18619306071393837},
{-0.5629277361328556,-0.802139522387926,-0.19920981530940637},
{-0.31779003267193545,-0.938970549650558,-0.13169586942383227},
{-0.5946913800109197,-0.7916885245580042,-0.1398979721935895},
{0.6114920842862032,-0.7907897632927708,-0.026999650491786563},
{0.6439965192082205,-0.763495873315957,-0.04839973840012092},
{-0.4634880189895616,-0.8698775139568924,-0.16879563668918662},
{0.6865972261528095,-0.6943971946410005,-0.21539912978927347},
{0.9972393219217103,-0.023900942432740553,0.07030277209295652},
{0.7626071761672917,-0.08610081021243617,0.6411060328361536},
{0.905159440714172,-0.16129277263278385,0.3932823774114934},
{0.9833035644818818,-0.11190040563970567,0.14350052019032852},
{0.9498342421416549,-0.08310299591700518,0.30151086966278057},
{0.46580750654845254,-0.12980209177756363,0.8753141058004734},
{-0.3953966351889517,-0.054499536210920255,0.9168921972806016},
{-0.5663016252879969,-0.18310052549926228,0.8036023063419288},
{0.5949913726876436,-0.14799785404667437,0.7899885452491402},
{-0.4652933603111222,-0.16209768688251214,0.8701875825117956},
{-0.8649861084346468,-0.1773971510246316,0.46939246161759907},
{-0.7117139283778688,-0.2579050472511626,0.6534127874133757},
{-0.5663984339104954,-0.17239952331597705,0.8058977716957418},
{-0.5699985151558019,-0.029999921850305367,0.821097861042858},
{-0.6845709542706023,0.020099147211275356,0.7286690832266841},
{-0.4712985554721412,-0.03699988659552138,0.8811972991344172},
{0.5172833721932469,-0.08099739638053935,0.8519726137804878},
{0.3583189376562959,-0.07540398520592997,0.9305491808238441},
{0.4446957531758357,-0.06259940217856379,0.8934914671972323},
{0.3672955024941078,-0.21719734043484948,0.9043889258254045},
{0.3106077559725012,-0.4339108348888225,0.8457211179199751},
{0.8378148587782818,-0.3980070587177801,0.3737066277458151},
{0.8634750847858875,-0.17109506312317932,0.4744863088950823},
{0.29938762057782836,-0.34528572273054153,0.8894632214561734},
{-0.9000287248751389,-0.04390140113557622,0.43361383900651135},
{-0.7173415137546362,-0.22041275565526533,0.6609382496032888},
{-0.06669807978992387,-0.2064940551217283,0.9761718964156474},
{-0.3031041010262305,-0.1317017819371645,0.9438127698731652},
{-0.4366809938733535,-0.009999564778414325,0.8995608474661526},
{-0.6562962131817749,0.024799856905238487,0.7540956488806589},
{-0.7501072535722132,-0.07710074556781447,0.6568063513481265},
{-0.6435738843016519,-0.0047998052278557,0.7653689419584903},
{-0.6921096723002561,0.06100085249287042,0.7192100510306951},
{-0.4373967173499544,0.1179991144199694,0.8914933093678196},
{0.012699513998898716,0.15859393072640443,0.9872622181978506},
{0.38349264851639125,-0.03749928114567059,0.9227823104326619},
{0.5393210716859141,-0.21710848259412566,0.8136317892150191},
{0.4477964086872034,-0.17119862699251726,0.8775929617326703},
{0.3972883496899655,0.0779977127506099,0.9143731863994576},
{0.44781068265125346,0.18290436323562811,0.875220878643093},
{0.5962254444637752,0.3489148902606696,0.7230308560001838},
{-0.06569799164309273,0.2935910250595438,0.9536708467278164},
{-0.12849772689531666,0.18029681057763106,0.9751827491697495},
{-0.5902879730050739,0.17549642429678206,0.7878839470281174},
{-0.42160419498261015,0.2573025601732106,0.8695086516541262},
{-0.6489263372098544,0.17210698510373854,0.7411300793746695},
{-0.7090388067558697,0.05850320196786796,0.7027384619285608},
{-0.4103021807618861,-0.10220054319733064,0.9062048164913995},
{-0.04680068586907715,0.49660727783298536,0.8667127017677173},
{-0.18180856883977886,0.45152128069945086,0.8735411709656044},
{-0.4585104312309671,0.2733062177871828,0.8456192380565011},
{-0.5760078193592221,0.20310275713864237,0.791810748903875},
{-0.6608875721260582,0.1487972018949273,0.735586167432181},
{-0.8063302419828491,-0.05690213415456295,0.588722080435698},
{-0.8728822937622549,-0.42539137102355734,0.23899515203251107},
{-0.8563214339937426,-0.25320633783395496,0.45011126642599975},
{-0.7822938238146414,-0.5504956538539691,-0.2914976986347539},
{0.48541448983878577,0.391511686798279,0.7817233347898204},
{0.6383893868646643,0.4161930808475459,0.647489235580937},
{0.7156101724709031,0.14860211239404164,0.6825097019443702},
{0.6150939536561532,0.18929813920843733,0.7653924762289378},
{0.7127913253823549,0.010899867349421532,0.7012914653348001},
{0.8954162788159247,-0.10020182168567753,0.43380788669907094},
{0.61779851419636,0.2605993732592609,0.7418982157369366},
{0.8673779775527214,0.1990949450435172,0.4560884200620201},
{0.7546108174236021,0.3981057068862126,0.5216074772967809},
{0.39468730311368494,0.5439825003644404,0.7404761792644634},
{-0.8362583302855768,-0.4328784302052209,-0.33658322847557715},
{-0.5999211595924547,-0.7448262704858482,-0.29211030291207873},
{-0.8309833638795809,-0.5279894297574234,-0.1751964926013268},
{-0.3953873319928211,-0.8765719150857538,-0.2743912086465102},
{-0.6255118785833624,-0.7596144252149036,-0.17810338221534272},
{-0.3371972535395548,-0.6921943620998809,0.6380948027389973},
{-0.009599587946530902,-0.9884575713693539,0.1511935101578617},
{-0.5287110343144303,-0.8284172892492419,0.1849038589838059},
{-0.8060606934086556,-0.5763718939098735,0.13439344646337092},
{-0.3905131429409922,-0.4870163908124538,0.7812262926133242},
{-0.26678221155518045,-0.7625491549174686,0.5893607027384684},
{-0.9706439226312711,-0.20650934475928032,0.12330557970372526},
{-0.9382308120058077,-0.0652021412734797,0.339811159581724},
{-0.9235340836542975,-0.1463053995004047,0.3545130835467769},
{-0.9864030134658092,-0.15580047597118113,0.05230015977723217},
{-0.729491457705045,-0.3550958418520377,0.5845931544542416},
{-0.018799965690093925,-0.3444993712892211,0.9385982870596892},
{-0.626912055634746,-0.16080309227319692,0.7623146594518533},
{0.23450674099315616,-0.20650593609845094,0.9499273060528745},
{0.16640017555227782,0.32830034635704813,0.9298009809405524},
{-0.6243986981300716,0.1214997466732923,0.7715983912190316},
{-0.9461702244915455,-0.11249645979211464,0.30349044930583813},
{-0.9985962053416296,-0.014999943000324898,-0.05079980696110032},
{-0.710063180628378,-0.15589191643425454,0.6866643939410044},
{-0.5494050518026771,-0.22530207166207344,0.8046073983990425},
{-0.5731016018212157,-0.14020039186064287,0.8074022566924611},
{-0.5014711411662148,-0.1545911035379797,0.8512510119138559},
{-0.975068983548942,-0.14439540685516072,0.16849464027073813},
{-0.9876744491924949,-0.13969638610123675,-0.07059817364887125},
{-0.7149032849881418,-0.1056004852353445,0.6912031760858913},
{-0.8404747062943153,-0.21749345463297273,0.49628506452572124},
{-0.2289921319655162,-0.1803938017754547,0.9565671329179598},
{-0.4466968619655669,-0.13399905865991935,0.8845937857504825},
{0.4642934976150986,-0.10539852390400901,0.8793876842617223},
{0.5972943555950094,-0.24559767911289854,0.763492785027272},
{0.7854939595746762,-0.0871993294397349,0.6126952883913483},
{0.9532310901390155,-0.17530571768922518,0.24620803020585985},
{0.9637113043999014,-0.15090177008814476,0.22020258299144785},
{0.09859787178790592,0.05549880207128579,-0.9935785538383705},
{0.8208991052204628,-0.45309950612180744,-0.34759962111661946},
{0.3376998058226675,-0.376899783282687,-0.8624995040629279},
{-0.4832184568814476,-0.6644253782119904,-0.5701217762171219},
{-0.5269912915408603,-0.8161865126293173,-0.23689608532453474},
{0.6244006681090722,-0.7811008357783413,0.0023000024610039496},
{0.7581148174989134,-0.6521127456681723,-0.003300064500390996},
{0.9445753280146442,-0.2141944053151988,0.24879350159860625},
{0.9611990724433426,-0.14149986345269763,0.23679977148833076},
{0.8849633367284232,-0.08689639995672314,0.457481046952829},
{0.9779842888085994,-0.1492976015532964,0.14579765777944154},
{0.9694982064299772,-0.20309962426604267,0.13719974618070432},
{0.7555133538165442,-0.26620470520974726,0.5986105805355173},
{-0.7577912399838985,-0.20579762099325194,0.6191928421721166},
{-0.6898248306916791,0.09340336211453006,0.7179258422057936},
{-0.5849225462740776,0.15910613286408914,0.795330656611},
{-0.9233352813151615,-0.18550708836127203,0.336212846938327},
{-0.8315003908052755,-0.32000015040010604,0.45410021342715046},
{-0.799698808449663,-0.4654993064065502,0.37919943499326275},
{-0.7990773904251023,-0.6002830152323725,-0.03369904649896877},
{-0.8311290775594264,-0.5549194141953143,0.035901256027413564},
{0.8929791536449845,0.10369757920826976,0.4379897752480439},
{-0.20640553896695826,0.3956106163533367,0.8949240156081927},
{-0.20709997307700528,0.3060999602070078,0.9291998792040237},
{0.7846117967270464,0.08660130206036479,0.6139092301946645},
{-0.22441073157778219,0.22381070288372396,0.9484453557413932},
{-0.8750679468481497,0.06669755691323458,0.4793824405427985},
{-0.5069152811914808,0.16970511583782658,0.8451254766914981},
{-0.9327128995086008,0.11040152686367485,0.34330474793749616},
{-0.9899374846925503,-0.0001000037867150773,0.14150535820183438},
{-0.01959969581508141,0.819187286311974,0.573191104143095},
{-0.5414217628851475,0.675827165418882,0.500120102731552},
{0.0703043118956769,0.41662555242871974,0.9063555884929156},
{-0.05140102263351804,0.5351106461322083,0.8432167759646383},
{0.03960024770032406,0.6947043453892707,0.7182044923831499},
{-0.3816987442131973,0.359998815605845,0.8512971992368218},
{-0.3964079658981129,0.1589031931917511,0.9042181704467046},
{-0.8885048956754628,-0.0077000424273506625,0.458802528008894},
{-0.882411414065462,-0.06890089123879231,0.4654060200658046},
{-0.920996223923223,-0.046399809761169974,0.38679841412975313},
{-0.6962149235268305,-0.24750530533308032,0.6738144433673919},
{-0.6603749854693167,-0.25539032599767336,0.7061732506638878},
{-0.8816677051034324,0.08909673644631487,0.4633830265905983},
{-0.8998746913802025,-0.03179910566272968,0.4349877661411135},
{-0.8963870517825548,0.36279475946754897,0.25469632093821587},
{-0.8319121002494978,0.1331019359817384,0.5387078355624527},
{-0.9765329634265301,0.21300719017905878,0.03180107346335244},
{-0.9260535225400263,0.37738105971990704,0.0028998544599568897},
{-0.9409489964899042,0.32331683554595175,0.10040522823635496},
{-0.5654733300793153,-0.20779019980633376,0.7981623555602291},
{-0.03920200150928189,-0.5010255805140365,0.8645441404279132},
{-0.14540497802463548,-0.4634158653137282,0.8741299263503017},
{-0.842146951001314,-0.27471531580579617,0.46402587016341257},
{-0.9094347910934126,-0.18320700871818035,0.3733142814110083},
{-0.857626646873884,-0.012700394607390772,0.5141159738314642},
{-0.7027651823615385,-0.02549873669638479,0.7109647761227289},
{-0.7505961344398615,0.2712986028157932,0.6024968971489695},
{-0.8861086617545032,0.10680104398530746,0.4510044085896411},
{-0.857420278229373,-0.03370079703327487,0.5135121447058351},
{-0.9165178126967863,0.012200237113912486,0.3998077703395255},
{-0.9700945820368888,0.19539890870014234,0.14399919576673745},
{-0.9830262225742354,0.17620470032307253,0.051101363147043166},
{-0.9678976673694325,0.2278994507629855,0.1059997445409235},
{-0.6314966088723155,-0.06679964128688944,0.7724958517084145},
{-0.06350173901893488,-0.3003082240533251,0.9517260633751231},
{0.35499980652515817,-0.44529975731169835,0.8219995520103662},
{0.08349854296313783,-0.36109369896992893,0.9287837928642205},
{-0.013399548643805772,-0.16699437488922117,0.9858667916364261},
{0.13019931189845493,-0.38019799065892906,0.9156951605638647},
{-0.15669440689296715,-0.33948788219631365,0.9274668946600321},
{-0.705717089146223,-0.31780769580653206,0.6332153334949531},
{-0.5243022912060188,0.5806025372386316,0.6229027220908433},
{-0.8460322978994702,0.29221115537378867,0.44591702320729765},
{-0.9919316927238819,0.10350330698348803,0.07320233885209008},
{-0.9943273742094231,0.029800820427879723,0.10210281092907784},
{-0.4242968644577575,0.17979867129272872,0.8874934414477016},
{0.4979982072096811,0.03679986752071539,0.8663968809768428},
{0.1848943367731956,-0.1109966002262018,0.9764700911791537},
{-0.7103056220912484,-0.1788014152188022,0.6808053885959761},
{-0.7074160797502412,-0.24570558495141964,0.6627150636845982},
{-0.9591162139966476,-0.1087018376200976,0.26130441738851423},
{-0.9232447415242877,-0.012200591254978672,0.3840186099927713},
{-0.7934016582111986,0.21490044914240808,0.5695011902587315},
{0.12259695902014679,0.10029751215106625,0.9873755084542655},
{0.8266643963311585,0.23059006869960705,0.5132778935971739},
{0.33550735104659307,0.47121032433131044,0.8157178725743843},
{0.828007576303985,0.07330067070420544,0.5559050865548131},
{-0.4162998272356076,0.3784998429225978,0.8266996569197137},
{0.31719481549311085,0.49539190288552054,0.8086867821225685},
{0.38210342939366826,0.5410048555403678,0.7492067241605241},
{0.5921312031758987,0.5598295009928527,0.5796305444363299},
{0.7400738869535902,0.5239815116385371,0.4215851246313115},
{-0.8667284551622821,0.07690252475133205,0.49281617942075995},
{-0.8554456595404119,0.20458700402334104,0.4757697776847784},
{-0.3222988816248211,-0.2286992064151306,0.9185968124745911},
{-0.88899336368931,0.16069880038793266,0.42879679904384266},
{0.08590032169730713,-0.38310143471755953,0.9197034442958483},
{0.10100044187789983,-0.38730169444861984,0.9164040092763109},
{0.16309995677851719,-0.35739990528903764,0.9195997563060969},
{0.07619942469651529,-0.23709820991527267,0.9684926879078093},
{-0.26558654970977624,-0.1567920594672173,0.9512518250711979},
{-0.6766378081938288,0.2487138972772764,0.6930387246206374},
{-0.12720255298085775,-0.3221064647416217,0.9381188282338259},
{-0.6614217445972864,-0.1677055134093815,0.7310240328101245},
{0.22120287565607544,-0.33300432908441735,0.9166119160323631},
{-0.995720168516272,0.07500151917115637,-0.054001093803232585},
{-0.9644049136555526,0.023300118714407275,0.2634013420332565},
{-0.9452255734238383,0.01420038419659173,0.32610882299356075},
{-0.8831760088495749,-0.02279938066323631,0.4684872737160619},
{-0.8508917251182097,0.05919942428839818,0.5219949236240515},
{-0.2457974916493965,0.3865960548073909,0.8888909289143554},
{-0.1545974854923475,0.6023902022030411,0.7830872631892455},
{0.04469812405909903,0.6011747692243923,0.7978665142450809},
{-0.006099782028183766,0.609878206391685,0.7924716815304318},
{-0.38021392939245957,0.05870215059268116,0.923033815963283},
{-0.2005981484876342,0.5202951976974879,0.8300923382830765},
{-0.7234961401583883,0.24889867212912625,0.6438965648209899},
{-0.4659801380199164,-0.3060869533216661,0.8301646149874132},
{-0.2049917943427054,0.21049157419092432,0.9558617376204492},
{0.022900773830221807,-0.19800669075912306,0.9799331124993165},
{0.38280184893739555,-0.5133024792569623,0.7681037099498786},
{0.21631075199314836,-0.3439170948240579,0.9137454188448435},
{0.14790218453139842,-0.49430730097275344,0.8566126522623115},
{0.06290090137637513,-0.5833083588686744,0.8098116046834433},
{0.05729756060828455,-0.4630802847765546,0.8844623448172372},
{-0.04310118163509201,-0.3690101165510198,0.9284254531327012},
{0.7787922393740018,0.07149928751314986,0.6231937899048251},
{0.6827176211692065,0.2965076529612857,0.6678172365853172},
{0.9419883900646383,0.21029740810041767,0.26159677583960655},
{0.7733699435612038,0.19389246451579703,0.6035765424535074},
{0.7150170891126472,0.2512060038952405,0.6524155929190084},
{0.6072624146559813,0.3454786172627063,0.715455718238687},
{0.8952917185899044,-0.02959972620379892,0.44449588843204796},
{0.91759360898277,0.03359976597844493,0.3960972411923226},
{0.7922807834626429,-0.06309846956518082,0.6068852801760418},
{0.7944045241466475,-0.21250121019783813,0.5690032404826818},
{-0.2601126066629803,-0.37651824839912373,0.8891430933643052},
{-0.1742967467815817,-0.30279434839623026,0.936982511384636},
{0.8098074138208105,-0.02140019591969047,0.5863053676502115},
{-0.7953854048117314,-0.13229757236182055,0.591489146273748},
{-0.7852246564413244,-0.3346105069348792,0.5210163601705681},
{-0.7386933739501534,-0.445196006609731,0.506095460344081},
{-0.4947920116474574,-0.3426944672424892,0.7985871069152374},
{-0.22089384487876748,-0.2925918470417717,0.9303740754875748},
{-0.6334168332760195,0.12270326088248752,0.7640203041093763},
{-0.9892411335015142,0.08280344303874382,0.12060501486077903},
{-0.9891058851975254,-0.02650015767640726,0.1448008615676895},
{-0.8826195678927327,0.08730193550536545,0.46191024066355446},
{-0.9994256006146438,0.009600245913448649,0.03250083251948762},
{-0.9367052923998531,-0.10340058421495123,0.33450188994101726},
{-0.483682594994973,-0.27119024139474196,0.832170054899352},
{0.28900229902243313,-0.9425074976769662,-0.16780133486492832},
{0.9445767825880225,-0.3187921641849053,0.07839807299904823},
{-0.4059986642665919,-0.8696971387011206,-0.2806990765015575},
{-0.7132629647820556,-0.6849644341451117,-0.14859228454593224},
{0.36699590251362246,-0.9192897361873928,-0.14219841236358888},
{0.9940037275209672,0.04830018112601883,-0.09810036787706931},
{0.9347708729933891,0.03219899669489423,-0.35378897610725407},
{0.9072162892147106,-0.2708048623449555,-0.32190577987016683},
{0.3990255224886537,-0.8712557272985341,-0.28581828152194794},
{0.040599600907884593,-0.9582905800498969,-0.28289721913400373},
{-0.21438765055507444,-0.43557490942999266,0.8742496402999141},
{0.10700234284194507,-0.8361183070107502,0.5380117798968828},
{-0.5563973626827512,-0.6743968033667279,0.48539769922035847},
{-0.032800228126379935,-0.6520045347073085,0.7575052684674634},
{0.7772869650068944,-0.36239392270487397,0.514291375405951},
{0.5107125279319671,-0.8122199239991065,0.281906915261448},
{-0.19910777829729173,-0.9775381882752521,0.06910269954968788},
{0.03100103204153528,-0.8039267631674261,0.5939197719183162},
{0.48557981486663526,0.09269614670127078,0.8692638654521542},
{0.8878392921973335,-0.06920306264930781,0.4549201329359845},
{-0.35810410747766924,-0.04870055859861071,0.9324106948120046},
{0.6682051151297346,-0.031600241900777634,0.7433056900268358},
{-0.9652434900251867,0.004600207267007728,0.2613117736671998},
{0.17909544834701965,-0.21489453852470422,0.9600755999886854},
{-0.6051163565161779,-0.21080569815503272,0.7677207517723844},
{-0.35861331735281443,0.1104040999323779,0.9269344223489228},
{-0.5885022981059611,0.059500232348860975,0.806303148619943},
{-0.05439920332950081,0.338795038382994,0.9392862442536786},
{0.9562087589123477,-0.2118019401146572,-0.20200185034542378},
{0.9616231705894464,-0.20930504326577698,-0.1774042746074956},
{0.9833098282308499,-0.1804018031250334,-0.02360023588553652},
{0.8708795432797897,-0.33559211703375524,-0.35909156503820466},
{-0.6862191732315538,-0.14780412970507673,0.7122198997020004},
{-0.598006156505072,0.19460200343793815,0.7775080044861095},
{-0.8212255815753053,-0.009900308399410038,0.5705177719053965},
{-0.17120478267240685,-0.2270063415107264,0.9587267824067551},
{-0.7798700106753482,0.14929425899965312,0.6078766245538456},
{0.9895433775847055,-0.07880345442513874,0.12080529561620255},
{0.16369578079562433,-0.3734903734096865,0.9130764657573889},
{0.6579185436954847,0.01590044816044719,0.7529212213836912},
{0.7969945645156049,-0.0619995771643256,0.6007959025859164},
{0.1763929849904776,0.5772770421485415,0.7972682932704523},
{0.037299137094444865,-0.04529895202086736,0.9982769051309466},
{-0.3931086445541417,0.19800435416362264,0.8979197454723068},
{0.998319876746621,-0.0440008760661638,0.03770075062941762},
{0.9794837896774201,-0.019299680592929257,0.20059668015241497},
{0.8598098491782339,-0.48680557638981653,0.15410176524583138},
{0.9192626189456354,0.022799072894550732,0.39298401962975604},
{-0.5306951017068168,0.25939760577114807,0.8068925524161116},
{-0.5135996507523563,0.21979985053615247,0.8293994360085754},
{0.016000099120921082,0.6456039995291657,0.7635047299264529},
{-0.03620150782420197,0.8751364501922415,0.48252009738059254},
{-0.41211817687304536,0.5183228611339465,0.7493330500630256},
{0.02660074509730541,0.6349177842962107,0.7721216274296807},
{-0.31280242579221806,0.814806318847504,0.4881037852595321},
{0.16470069750893093,0.6420027188872718,0.748803171188145},
{-0.039402498788693535,0.758448098511299,0.6505412553818565},
{-0.3568065849262878,0.393807267780191,0.8471156336632802},
{-0.2313028057200502,-0.2743033273195407,0.9334113223480106},
{-0.45192207015320707,-0.3974194084507291,0.798639002488053},
{-0.43880165647937985,0.10350039071471241,0.8926033695840803},
{-0.3791043862631237,0.16060185817424866,0.9113105439239901},
{-0.8565163167912538,0.23540448449814494,0.4593087499150296},
{-0.4728944529805996,0.007199915545485974,0.8810896648788461},
{-0.5532068376787709,0.2898035819944103,0.7810096533389733},
{0.021699215153581586,0.0662976020590995,0.9975639187655756},
{0.13210193002329654,-0.4134060399063648,0.9009131624374555},
{0.4003150901617408,-0.42961619468769385,0.8094305120582389},
{-0.37368110155617107,-0.8664561800867602,-0.3310832558877395},
{0.021300322595828588,-0.9311141018298592,-0.3641055144197741},
{-0.6450424967995799,-0.3918258143350006,-0.6560432215512007},
{0.7631854957974772,-0.5660892415761949,-0.31159407821081486},
{-0.3211059067974838,-0.9274170599937293,-0.19180352825835376},
{-0.9527687115892587,-0.2877905491135481,0.09699681467690816},
{-0.8560097243257028,-0.47720542108437547,0.19880225840648333},
{-0.787734909246022,-0.6122271314465084,-0.06820302248391355},
{-0.5763883772455581,-0.6630866289929382,0.477590369487298},
{-0.8719836766183592,-0.24119548486278466,0.4259920255039231},
{-0.3656922510632991,-0.31949323001018337,0.874181476290774},
{0.8763416053053412,-0.08560406414942053,0.47402250475263236},
{0.7358910148255631,-0.060499261308529104,0.6743917657268104},
{0.9663057688626603,-0.1721010274462008,0.19140114266823258},
{0.8384034123088321,-0.26570108140560195,-0.4759019369248249},
{0.5056238963500256,-0.4556215331824993,-0.7326346251305949},
{0.9596381079859172,-0.2789110757787331,0.036101433616393924},
{0.9938095356482419,-0.006600063327911448,0.11090106410081509},
{0.6692125210834053,-0.16850315272348146,-0.7237135408070239},
{0.6760808164789948,-0.3124911331898918,-0.6672810661683674},
{0.6245933106414643,-0.24509737502117018,-0.7414920586625773},
{0.4800986029150983,-0.4265987585994187,-0.7664977694947361},
{0.8560061204656421,-0.5157036872945463,0.03610025811776831},
{-0.7708077505108972,-0.6106061396756018,-0.18170182702105608},
{-0.9173551378439488,-0.25268764261299964,-0.30758495792544},
{-0.9776877105427173,-0.14329819875296246,-0.15359806928440356},
{-0.9841554538013607,-0.07490422059721767,0.16070905540684755},
{-0.9971276906204581,-0.02410066928487919,0.07180199396905917},
{-0.9363526170746891,-0.059496989231038015,0.34598249199897735},
{-0.9868209948400002,-0.15640332751618974,0.04150088294067694},
{-0.4615152741007487,0.32201065711904897,0.8266273576851114},
{-0.04410079426245706,0.36460656662339785,0.9301167515535446},
{-0.10469894778086218,-0.1475985166423616,0.9834901159740015},
{-0.7131229415340496,-0.24260780481862357,0.6577211592300442},
{0.7688222769482165,-0.2390069253259934,-0.5931171858194422},
{0.7790956137040423,-0.22819871524484975,-0.5838967126707615},
{0.9041408635697644,-0.259211715338218,-0.3396153492625727},
{0.8192026050684262,0.024000076320364046,0.5730018221486916},
{0.9965485146509515,0.010099478223935992,-0.08239574313389364},
{0.5425269913892491,-0.038801930444060585,0.8391417483404957},
{0.19210471238639296,-0.2137052422538895,0.9578234956985278},
{0.43188006919469946,-0.2514883940784138,0.8661600276370656},
{-0.2249945934448785,0.19089541283834355,0.955477040162584},
{0.6519156363840602,0.20190484274573056,0.7309175312672336},
{0.9018224691867331,0.06420159960278139,0.4273106465773909},
{-0.9851849415632515,-0.030299536875118275,0.16879741995115394},
{-0.7999132866700384,0.0026000431870760086,0.6001099679093511},
{-0.43118215805144205,-0.16759306514244363,0.8865633147690365},
{0.15430384298506492,-0.1231030659200356,0.9803244152835978},
{-0.8317774092323438,0.1797951168309394,0.5251857361491067},
{-0.8104086511585269,0.27800296769752036,0.515705505185652},
{-0.2451933197990019,-0.47758698831975255,0.8436770143328626},
{0.18170129190077813,-0.04080029009109383,0.982506985649502},
{-0.755005405858059,-0.5062036244309264,0.41680298432005164},
{0.28170190149425267,0.6515043976695265,0.704404754748142},
{-0.23730638481417632,0.03710099821578568,0.9707261177375514},
{-0.11639933594368267,-0.13419923439555168,0.9840943857575438},
{0.2932067834174025,0.23180536287910605,0.9275214584571649},
{0.8490766252422562,0.16209553757127515,0.5027861584875827},
{0.9505129983541293,-0.1968026912952053,0.24040328753743576},
{0.3609145180784904,-0.714528742496762,-0.5993241082971442},
{0.7224325390943577,0.05000225215215654,-0.689631061682543},
{0.4343243184994082,-0.7748433846956977,-0.45932571836697716},
{0.038198789690522685,0.9866687378963019,0.15819498767122223},
{0.8355812079899461,0.23389473976645328,0.49708882059813564},
{0.5742103186521401,0.30910555467672673,0.7581136234242205},
{0.7482419401361499,0.32291810006677735,0.5795324837060931},
{0.5146098162758691,0.2938056043953563,0.8055153653521425},
{-0.13619874084846126,0.3361968918741019,-0.9318913847039725},
{0.3024070038273139,-0.947421942546287,0.10460242262016214},
{-0.13190614301212344,0.31391461934424225,-0.9402437881728466},
{-0.32101066415139756,0.943431341309746,-0.08300275739740187},
{-0.13380406436018336,0.3185096748783139,-0.9384285051987747},
{-0.12950334770480781,0.3197082645654599,-0.9386242637508311},
{-0.12800874329576087,0.32542222709719204,-0.9368639899958497},
{0.590903066794875,0.5700029583230306,0.570902962994067},
{0.6994339163729274,0.4075197611123361,0.5871284705498222},
{0.33179791465665953,0.4736970228235673,0.815794872745337},
{0.07800339439156204,0.0044001914784983715,0.9969433829352332},
{-0.221007884596927,0.16370584031003146,0.961434299780478},
{0.5117156638562097,0.6742206382096082,0.5325163005734446},
{0.8719885726646324,0.4260944160692659,0.24099684175708302},
{0.8428303761541448,0.35981296789304856,0.40021442398776547},
{0.7547674362614285,0.2592888132254748,0.6025740025054808},
{0.08220099710414235,0.9181111367556337,0.3877047028865692},
{0.30200617155917436,0.9133186638575959,0.2732055830131339},
{0.7387102422885146,0.4387060827020053,0.5117070948680559},
{0.5330103271751345,0.5925114800211392,0.6040117028401149},
{0.5193068055602805,0.15770206669912623,0.8399110071058726},
{0.7367285156290568,0.3719143952252562,0.5647218579825279},
{0.5502046630042786,-0.5910050087886743,0.5899049994660558},
{-0.07010156713805024,-0.6208138784493807,0.7808174553693243},
{-0.0163004803822354,0.038401131698026954,0.9991294447786129},
{0.3549098648567925,0.10640295751130661,0.9288258170723833},
{0.6184311387917769,0.32751649087048346,-0.714335967721485},
{0.7576698074597471,0.23209075136783328,-0.609975692952944},
{0.8704336167954335,0.49141897896745873,0.029201127769332102},
{0.704279572667238,0.683580173044617,-0.19159444288377506},
{0.7477810140810758,0.5412862569164032,0.3844902379167874},
{0.9126255493098844,0.2907081384882571,0.28740804610087745},
{0.9890301856619066,-0.13360407765867616,0.06300192284802843},
{0.9503193201881711,0.28700583488793546,-0.1205024498397081},
{0.8678996051057696,0.3408998448906059,-0.36129983560861223},
{0.5805180340728471,0.16610516013695073,-0.7971247630654029},
{0.34300030870041676,0.250200225180304,-0.9054008148611},
{0.15369554443074948,0.6697805833423291,-0.7264789396808035},
{0.19029260347025187,0.2657896689563476,-0.9450632661047559},
{0.4050063343486042,-0.2704042291552162,-0.8734136602964714},
{0.7107874049587752,-0.04139926641149872,-0.7021875573467248},
{0.9208779636539915,-0.2791933189838141,-0.2720934888807157},
{0.8903874278182781,-0.4537935924797109,0.03579949451470615},
{0.8338925366951947,0.36249675566855505,0.4161962750600072},
{0.9461730628363461,0.11669667769287843,0.30189140527403596},
{0.9804941415650062,-0.19629882711801197,-0.00989994084803015},
{0.9502407044323803,-0.21300912444127235,-0.2273097370211324},
{0.9866478422404436,-0.10699434389351116,-0.12279350869273992},
{-0.12379635301315957,-0.9851709772905074,0.11879650030665072},
{-0.7105196496926222,-0.631217456560145,-0.3110086010617952},
{-0.8795805394958431,-0.4719895573465642,0.05969867918133451},
{0.5537918759327697,-0.81908798406741,-0.149697803949324},
{0.08659824467137059,-0.9752802312700661,-0.20329587923429146},
{0.3268893533871375,-0.7471756648848855,-0.5786811526617817},
{0.8653358472799757,-0.39451634317803125,-0.3091128052631925},
{0.1564067819451009,-0.9856427383957254,-0.0636027578753735},
{-0.02320083188074089,-0.9851353226602524,-0.17020610284922844},
{0.049499556980947525,-0.7226935319218338,-0.6893938299528327},
{-0.5195213163969266,-0.5995245989989558,-0.6088249806014416},
{-0.4362017775258651,-0.6925028219547492,-0.5746023415093124},
{-0.6362028883676698,-0.6828030999331105,-0.3592016307791056},
{0.15889835223263102,-0.9872897618582541,-0.0031999668165161687},
{0.26830631466342425,-0.9600225943976418,-0.07980187815930398},
{0.9709623613735778,-0.23819076671388903,0.022299135590762912},
{0.9975729362133559,-0.031099156291334567,0.062298309869779536},
{0.9518854648199275,0.10529839210582874,0.2877956053946582},
{0.8435978319563577,0.42069891880516797,0.33369914239430604},
{0.9603291272241498,0.2737083016986877,0.05340161969568843},
{0.6117851307430937,-0.777881093829769,0.14359650992923875},
{-0.07809746109280914,-0.9853679662081194,0.1514950749751675},
{0.041699988741004564,-0.9990997302431093,0.007799997894000853},
{0.04570018874216926,-0.9913040940943629,0.12340050964515725},
{-0.012600149123647323,-0.9946117712999705,0.10290121784311981},
{-0.24959667913827593,-0.9616872048368589,0.11339849124311095},
{0.15820204714773523,-0.9748126141568413,-0.15720203420748405},
{0.09609951421818345,-0.9920949849725265,0.08069959206459316},
{-0.6289832315305681,-0.6963814347184223,-0.34559078667243937},
{-0.46537355357240434,-0.5638679562945398,-0.6822612281960712},
{-0.913114020973439,0.2598039893208843,-0.31420482465212407},
{-0.9218142098755687,0.23430361181801448,-0.3088047602620695},
{-0.832488332757774,-0.553692240057633,0.01969972391030408},
{-0.732790004812501,-0.673790809556036,0.09499870422651145},
{0.7387129497515147,-0.6535114561562405,0.1650028925260592},
{0.8848814796244452,-0.4620903285506341,0.058798769354635974},
{0.7148197864855386,0.610416896573549,0.34120944480815024},
{0.7235841066496442,0.6148864941664818,0.31359311200294143},
{0.9053148744455818,0.4004065787341334,0.14170232818837836},
{0.5964112812260777,0.6736127415055094,0.436508256631762},
{0.712874661320487,0.5197815246940514,0.47078326630619344},
{0.8030920855664949,0.16589836507966815,0.5722943600668722},
{0.8722082467679599,-0.23090218319046316,0.43120407705382297},
{0.8266794242051942,-0.1979950719639875,0.5266868909264253},
{0.7000281802016024,-0.16100648144636856,0.6957280070946498},
{0.4658182674215425,-0.7333287580511315,0.4952194204103646},
{0.7879777793399295,-0.613782691572143,-0.04859862953797027},
{0.30159865788895857,-0.849696218860239,-0.43249807538784674},
{-0.41028537563842343,-0.5321810307452326,-0.740573602724388},
{-0.5583651479351649,-0.5487657471110645,-0.6221611659119978},
{-0.08880152295917824,-0.9849168914695343,0.14850254684051767},
{-0.6478352237586997,0.05290287640758755,0.7599413191328124},
{-0.7633381945821227,0.3690184643008035,0.5302265305482006},
{-0.42828794386406793,0.8689755386828742,0.2478930219096485},
{-0.30750625935361436,0.9220187678830324,0.23520478764217917},
{-0.10949841775929497,0.9916856702455967,-0.06759902320117206},
{-0.32301737072617875,0.9453508376082254,0.04440238780260786},
{-0.02479966471079965,0.9959865343530827,0.08599883730357943},
{-0.6534700880913107,0.7116674241692209,0.25788819543802455},
{-0.7912988565739784,0.316399542802991,0.5231992439776386},
{-0.8448821351561261,0.08479820696087051,0.5281888315652336},
{-0.4476256362543034,-0.08310475954587268,0.8903509918614976},
{-0.47109582846490833,-0.07949929603685038,0.8784922209858246},
{-0.2942167870176886,0.540030812337022,0.7885449917180403},
{0.055701303147230874,0.9496222166716416,0.3084072152712029},
{-0.48279244677125494,0.7610880928699298,0.4331932227450448},
{-0.7782197825983137,0.6136155983067659,0.13360339624149922},
{-0.5407956195732221,0.833393249542018,0.11399907661121918},
{-0.9406451525801829,0.3372803337570912,-0.037797796074764446},
{-0.8384289221045106,0.39811373317009263,0.37221283970336216},
{-0.896147631512456,-0.24601307594248875,0.3693196298600045},
{-0.8606071086440762,0.32340267131709766,0.39340324952426164},
{-0.6309714365695852,0.20849056184589304,0.7472661720260713},
{-0.42009769156952725,0.29469838063684767,0.8582952836803743},
{-0.39620904753690195,0.06550149574373317,0.9158209130093257},
{-0.9220276520239326,-0.0031000929731824192,0.3871116096512628},
{-0.8330960761267221,0.5304975013626528,0.156599262419211},
{-0.991094435020371,-0.11789933799707572,0.06189965243442736},
{-0.9450358080851653,-0.12790484640644725,0.3009114017490225},
{-0.9957889418252012,-0.04959944920117491,0.07709914381876182},
{-0.9898118877121576,-0.14130169704357232,0.01750021017878638},
{-0.9161069349557465,0.4001030287913919,0.025800195308217727},
{-0.9645700553874387,-0.2637918107103528,-0.004299866512716137},
{-0.9359295290424693,0.34751096414388083,0.05720180474541003},
{-0.6406935866892957,0.2107978899236827,0.7382926097279646},
{-0.6064770361817793,-0.2297912991171853,0.7611711787989618},
{-0.7216869195431239,-0.5789895059103072,0.3793931235619526},
{-0.6506016362651728,-0.7425018673945448,0.15940040089251234},
{-0.9821392225130422,-0.17140684526905145,-0.07760309914164758},
{-0.9750678525428437,-0.20729316565699057,0.07919738890513099},
{-0.9960593566271623,0.058797600812847246,-0.06639729071382751},
{-0.9397194570927908,-0.07550156327605162,-0.33350690533196314},
{-0.8862465557543928,-0.0923048489010725,-0.4539238452459027},
{-0.943588993098593,0.10539877053051261,-0.3138963384205684},
{-0.9253465118907757,0.299782671563491,-0.23208658462270265},
{-0.7885196264977584,-0.4574113851110649,-0.411110232661038},
{-0.9397911237147545,-0.17389835753776953,-0.2941972213203669},
{-0.9540880262704051,-0.16899787908992608,-0.24729689644342437},
{-0.9745042780831712,-0.20040087976179322,0.10090044295391686},
{-0.8601296319762411,-0.16970584646711792,-0.48101657130632713},
{-0.9345902195645281,0.2610972676313913,-0.24159747169568802},
{-0.9618729284673869,0.13079631878941075,-0.24019323985639499},
{-0.8562047733549172,-0.062000345652890525,-0.5129028594414121},
{-0.7265656560531384,-0.35168337631969276,-0.5902720984973405},
{-0.712839349818195,-0.46202550451179303,-0.5276291259316493},
{0.6101226207155023,-0.7820289942624534,0.12720471620228144},
{0.7570077820799999,-0.3212033019869167,0.569005849410198},
{0.9992795899228115,-0.023999509815017993,0.029399399523397037},
{0.9552865066733892,0.012999816378890462,0.29539582756340327},
{0.9731130884590603,0.15430207537687082,0.17100229999640254},
{0.7435711760220315,0.6155761376535268,0.2610898790470043},
{0.759024296756615,0.5027160921996711,0.41371324317287433},
{0.927935252929901,0.2615099349511468,0.2656100907190233},
{0.9899738006900425,-0.1236967264094528,-0.06819819515864738},
{0.9294114318309177,0.2948036261069018,0.2220027306503806},
{0.9439839099313816,0.19529667119660893,0.26599546614591896},
{0.9891209794784644,0.000600012726404892,0.14710312009026602},
{0.914338178987762,0.02080086855840036,0.4044168867796685},
{0.9374991234387294,-0.23689977849881066,0.25489976166883427},
{0.5514298993397353,-0.07040381739847183,0.8312450713296844},
{0.7734115045816967,-0.504507504604947,0.3838057091523858},
{0.939805911397774,0.1217007655002225,0.3193020084159494},
{-0.19680651046705117,0.28980958705971255,0.9366309842654478},
{0.0892032996910845,0.7293269783039004,0.6783250917092222},
{-0.9494210109194601,-0.23930529588479754,-0.20330449917835078},
{-0.968651664414319,0.14160755284025148,-0.2041108865444585},
{-0.9199167564363291,0.3200058289592622,-0.22660412763177754},
{-0.9284146969209792,0.0983015561259503,-0.3583056720236825},
{-0.9370292123410492,0.15370479182157873,-0.3136097769371964},
{-0.9480007915809915,-0.024800020708025936,-0.31730026494583186},
{-0.8678819959747383,0.4237912085425672,-0.2591946230633162},
{-0.8836972649611974,0.3740988421658752,-0.2812991293805418},
{0.010900045889289792,-0.1811007624358148,-0.9834041401401451},
{-0.26381118055475283,0.0892037805363304,-0.960440704339593},
{-0.47639193951657455,-0.3517940476950691,-0.8057863662100246},
{-0.6391944614039878,0.06499943678232042,-0.766293360096802},
{-0.6204859678685032,0.514688360454341,-0.5916866191584098},
{-0.1548965915380044,0.23579481139226233,-0.9593788890998155},
{-0.6100905863748778,0.6246903611020918,-0.4873924795920594},
{-0.25040401025233655,-0.28050449231541696,-0.9266148398554914},
{0.06060316326466206,-0.25191314894997313,-0.9658504138780629},
{0.9870247499559117,0.13540339528270562,-0.08630216405389583},
{0.9462009935115647,0.11850012442519596,0.3011003161554979},
{0.9675275265497011,-0.24580699330844086,0.058901675776514104},
{0.9563114232081757,0.21790260286213686,0.1949023281222142},
{0.9998405943522127,-0.01760071460351965,-0.003000121807418122},
{0.8747645814991282,-0.40148374425228617,-0.2712890157301251},
{0.9458192901811369,-0.3154064327797955,-0.07710157250260695},
{0.9171473902300115,-0.1844095286865272,0.3533182564259765},
{0.8129835575738203,-0.3370931823593295,0.474790397461316},
{0.4190060253499671,-0.7960114467269066,0.4368062813194884},
{0.8284349772631256,-0.26201106234058297,0.49502090022362044},
{0.9495067130361919,-0.13440095021807708,0.28350200436625633},
{0.9138972902985515,-0.11739965191054813,0.3885988478061244},
{0.9855815106642883,-0.10459803775921729,0.13299750499020938},
{0.9316530412119067,0.1533922684575577,0.32938339784823667},
{0.7683115017092714,-0.014600218566907932,0.6399095795181087},
{0.7693320164180587,-0.32121336757244306,0.5522229812375562},
{-0.8330191596610108,0.2816064770234582,-0.4762109529778792},
{-0.7277002583336376,0.4344001542120821,0.5308001884341004},
{-0.2553017245689742,-0.022200149962519497,0.9666065294491597},
{-0.6220065933048338,-0.2046021687944839,-0.7558080116073848},
{-0.6634014395826858,-0.7443016151362573,0.07690016687354317},
{-0.9167268513227187,-0.2613076538132719,-0.302208851826907},
{-0.7784298611422211,-0.5734219968897092,-0.25540979770776373},
{-0.7042976018707484,-0.5915979856122885,-0.3923986638848242},
{-0.7744823845984912,0.03199927218483114,0.6317856301992598},
{0.22290200278349254,0.44390398849525503,0.8679077981866001},
{0.1943092444822146,0.3550168903303458,0.9144435056846991},
{0.19929339452990566,0.24979172079061931,0.9475685933594511},
{-0.4000812966365631,0.548174373447048,0.7344656645327559},
{-0.6927677420211217,0.16399236387336022,0.7022672996845176},
{-0.544993988749456,0.2958967362769982,0.7844913471081618},
{0.11979378525962692,0.41357854410168354,0.9025531767557533},
{0.50418849454983,0.2371945872812766,0.8303810509206244},
{0.24340113181789447,0.5385025040424657,0.8067037511811646},
{0.20050643535731585,0.546017524713688,0.8134261073298789},
{0.006200188953637587,0.5494167437304016,0.8355254630264846},
{-0.5207001197610414,0.2849000655270226,0.8048001851040638},
{-0.9235917569803533,0.1091990254030474,0.36749672010640955},
{-0.42360835363910143,0.4478088308772182,0.7874155279873194},
{0.09109911360993685,0.24829758407626035,0.9643906165249516},
{0.4501011500099074,-0.04580011701944847,0.8918022785577325},
{0.4836102865001919,-0.10370220576937532,0.869118486346809},
{0.4389880816353732,-0.4358881657969457,0.7856786691136963},
{0.4852059947570981,-0.1596019718945442,0.8597106217903487},
{0.8330736336367365,-0.12869592683837233,0.5379829731083474},
{0.8971759156358129,0.1831950821940269,0.40188921142892686},
{0.44332511507917405,0.2491141127142392,0.8610487797951022},
{0.10359642339522236,0.16719422771893028,0.9804661499904973},
{0.1017003574773848,-0.004800016872088958,0.9948034967404367},
{-0.6407437674978594,-0.001900129792798397,0.7677524431217524},
{0.03959897519178288,-0.09619751044064426,0.9945742607511933},
{0.7039332651524357,-0.006800321356778751,0.7102335628800397},
{-0.7416538460239029,0.3018219130663618,0.5990434921363509},
{-0.3104814492875911,0.18428898906184552,0.9325442821436633},
{0.28089819944831224,-0.11849924042230332,0.9523938951746979},
{-0.4195196801298032,0.5132240759061144,0.7487351239885188},
{-0.4208019146530675,0.31010141096462984,0.8525038789014735},
{-0.6646367221933798,0.2335129019442585,0.7097392141749047},
{0.7233827402937225,0.12199708918417768,0.679583785324321},
{0.32419987518307203,-0.3346998711405744,0.8847996593521967},
{-0.276413709077861,0.033701671475846295,0.9604476345816849},
{-0.00020000270605491951,-0.9147123761421744,0.4041054675839649},
{0.30309747520854724,-0.3416971536745648,0.8895925897245913},
{0.7833057847345806,-0.08850065357974005,0.6153045440408367},
{0.8253281895657302,0.006200211771849663,0.5646192849010193},
{-0.8437909841415014,-0.2217976301049834,0.4886947783241903},
{-0.44579763504981906,-0.26309860426560655,0.8555954610781185},
{-0.04389920960184661,-0.24079566451309026,0.9695825428234732},
{-0.34740029181636767,0.08340007005608827,0.9340007845609886},
{-0.21500821347063487,0.3096118273977142,0.9262353828674512},
{-0.4570128011078411,0.27670775069264686,0.8453236778478295},
{-0.12830644499460217,-0.24361223695000073,0.9613482897374207},
{-0.07089860012096078,-0.2971941319597961,0.9521811993678259},
{0.5542005292617582,0.3147003005389305,0.7706007359240542},
{-0.23709268461807245,-0.37528842065441836,0.8960723521141067},
{-0.16559691578616495,-0.556489635477058,0.8141848359486444},
{-0.027199553387000048,-0.3979934650009566,0.9169849432308473},
{-0.15800716341713394,0.05780262054120469,0.9857446897485376},
{-0.2427021333611284,-0.03920034457254319,0.9693085202593398},
{0.26809097754997324,-0.3012898602603765,0.9150692038641571},
{0.1185963627053329,-0.6076813626984048,0.7852759159569808},
{-0.12239656070496559,-0.2659925257150396,0.9561731319124845},
{0.068997622037934,-0.2756904984907015,0.9587669566662479},
{0.8637245214872525,-0.1148032593107984,-0.49071393156627857},
{0.8965433223226874,-0.1431909477544154,-0.4191735006889032},
{-0.46520200967702274,-0.4464019284604965,0.7644033022293985},
{-0.33708252946523504,-0.6689653284255184,0.6624656652943286},
{-0.7606239258018851,-0.24120758730398983,0.6027189588230294},
{-0.3599017833177545,0.24880123281316288,0.899204455569116},
{0.2517043331273925,0.39880686551928535,0.8818151805790017},
{0.7056196129697175,0.019600544804714376,0.7083196880193465},
{0.7706992370081331,-0.5714994342158403,0.2817997210184143},
{0.7973599894795667,-0.06879654787583922,0.599569914336529},
{0.3515833880773608,0.49647654203756997,0.793662500332768},
{-0.36368982773777525,-0.1014971611641028,0.925974100866593},
{-0.44698286077079935,-0.28248916816051634,0.8487674546359161},
{-0.10699629050291129,-0.059697930308633684,0.9924655918143874},
{-0.22480800667973938,-0.0707025181150248,0.9718346125060976},
{-0.41380886181166454,-0.1512032380520147,0.8977192248630529},
{-0.41308717384237514,0.005999813708676473,0.9106717240819439},
{-0.30399838121293005,-0.04529975877942675,0.9515949327704745},
{-0.29378487928138514,-0.5684707415638783,0.7684604483585584},
{-0.6154835698854,-0.20329457312380472,0.7614796725714574},
{-0.8707127386205497,-0.18880276220461673,0.45410664362879477},
{0.27621180278250473,0.1447061834273296,0.9501406003752996},
{0.1911899044836336,0.3803799145689028,0.9048522205399584},
{0.2390006787628915,-0.0346000982644186,0.9704027559477403},
{0.14710637205051105,-0.12300532809118189,0.9814425121031376},
{0.03600123126316416,-0.16620568433160784,0.9854337024089435},
{0.4537198506777102,0.27841218079937075,0.8465370368055581},
{0.1712065847318756,0.5292203542062417,0.8310319621039055},
{0.201085889292811,-0.40827135056317615,0.8904375157396727},
{0.13669994395303445,0.4032998346471017,0.9047996290322281},
{0.26169015409317486,-0.03899853270780978,0.9643637164977372},
{0.23400196445473745,0.2615021953201446,0.936407861176992},
{0.39741985559199045,-0.08760437682400192,0.9134456368840567},
{0.3999110516946225,-0.20460565435538827,0.8934246901324725},
{0.5572770824512165,-0.21139130671126355,0.8029669786619898},
{0.9888525312735771,-0.10959473903082621,-0.10079516144440952},
{0.1329027949751678,-0.0868018254615844,0.9873207635739892},
{0.24379092505171931,-0.09799635215368538,0.9648640836029695},
{-0.2911860903726864,-0.07329649870988295,0.953854435461901},
{0.042598653690824814,-0.23579254789428386,0.9708693161601365},
{0.2253977415259448,-0.2531974629741314,0.9407905733256826},
{-0.8238400025225072,-0.04380212686390607,0.5651274404290713},
{-0.9355368187760187,0.20020787933613995,0.29101145298110254},
{-0.5808074895608671,-0.19390250038886386,0.7906101949841969},
{-0.9434101652992969,-0.2620028230956284,0.20330219059290552},
{-0.8208447003152666,-0.19111040720059388,0.538229310075142},
{-0.21919110430954372,0.2377903494744959,0.9462615967523779},
{-0.038501172378548665,-0.23910728092755806,0.9702295439394263},
{-0.25689110915256574,-0.14189508909594814,0.955966914557621},
{-0.28651007100599685,-0.14040493532021628,0.9477333134114598},
{-0.3970151861213093,-0.08850338531923393,0.9135349433798893},
{-0.3195959571367132,0.20329742830379785,0.9254882926471466},
{-0.2498061253212902,0.17460428134946868,0.9524233537069529},
{-0.0653002043899596,0.4063012717249707,0.9114028526953933},
{-0.09649562643484551,0.07159675495062112,0.9927550043991152},
{-0.17970284382000534,0.02010031809005068,0.9835155642569575},
{0.22230495078638163,-0.44961001292648306,0.8651192664205971},
{0.3673090175470725,-0.01190029215575868,0.9300228323408044},
{0.29421233658191476,0.08950375297104476,0.9515398989044591},
{0.42818546549105674,-0.027599063165700995,0.9032693390426706},
{-0.1941023505936986,-0.09960120617791025,0.975911818363681},
{0.3471875205688557,0.11859573715284069,0.9302665621693735},
{-0.43471195691681475,-0.028300778423615957,0.900124758271969},
{0.4789795192736244,-0.33938548818678105,0.8095653837242721},
{0.17449584181363378,-0.3364919814916205,0.9253779485062277},
{0.7347888165993164,0.2691959028695372,0.6225905242443309},
{0.10739996133602088,0.03499998740000681,0.9935996423041932},
{-0.3519110273048136,0.1896059413952619,0.9166287230110605},
{-0.815634314457429,0.3865162610811627,0.4305181122779833},
{0.39979939630336736,0.16129975643755168,0.902298637530086},
{0.879109094430623,0.06250064657253321,0.472504888088351},
{0.8711899247467803,0.19629772982988172,0.44999479584027907},
{-0.06290277942071441,-0.0901039813323747,0.993943918382322},
{-0.009300043617306849,0.21620101398513342,0.9763045788792125},
{0.2389950122261417,0.35069268112011676,0.9054811028065745},
{-0.49322109798370906,0.3439147112664183,0.7990341794180525},
{-0.8282140549117689,0.37090629433322275,0.42010712927847627},
{-0.14240034104922522,0.6487015536420815,0.7476017905084325},
{0.08150179550433266,0.5037110968776977,0.8600189464260869},
{0.3533132335950011,0.4638173726050425,0.8124304301516527},
{0.4197843570273976,-0.07799709349246549,0.9042663031440582},
{-0.08810205015856107,0.5092118494976083,0.8561199221423851},
{0.08990239593077774,-0.35370942648182524,0.9310248121418697},
{0.7288168759501462,0.3304076506777282,0.5997138865358159},
{-0.8012327230126254,-0.3158128980621407,0.508220756159531},
{-0.14649615745618422,0.05859846298247369,0.9874740988940747},
{0.37521533911660104,0.4556186260701584,0.8072330003595959},
{0.24220808504082023,0.4046135062242604,0.8818294359578666},
{0.6837775246021434,-0.1402953885663655,0.7160764629534877},
{0.33989096411882674,-0.8509773770671419,0.40038935579046253},
{-0.31591266993169653,-0.6557262984305583,0.6857275016529417},
{0.9057268008525617,-0.1777052583763942,0.38481138673740284},
{-0.32791384317509065,-0.13200557273288185,0.9354394904116491},
{0.42388920579880973,0.300592345513381,0.8543782435350391},
{0.48987649139125367,0.33738380933947537,0.8038614236158987},
{-0.9579889400815297,-0.11779864002255136,-0.2614969810347808},
{-0.6373857322800727,0.0674984890632333,0.7675828178509315},
{-0.9798724365760332,-0.10529703803597949,0.1695952293532965},
{-0.17489789599096675,-0.43579475742060214,0.8828893789046572},
{0.3025039174510966,-0.46070596618089327,0.834410805689901},
{-0.03520125811544797,-0.24120862095017187,0.9698346625102682},
{-0.3477987670555562,-0.3824986440447103,0.8559969654961359},
{-0.1801103836629359,-0.6262361035520847,0.758543731306701},
{-0.8393083553562666,0.08220081831321947,0.5374053498968875},
{-0.1629953416597021,-0.13039627332776166,0.9779720499582125},
{0.4417957742436289,0.06169940984796718,0.8949914394478222},
{0.21379500794484604,0.062498540676112616,0.974877236882275},
{0.1356064007731783,0.088004153894098,0.9868465802579082},
{0.43448932690077546,-0.21279477276060993,0.8751785015041627},
{0.6712188984341318,-0.29130820189788825,0.6816191912584986},
{-0.6201261295649655,0.16740705384482377,0.7664322943050952},
{-0.6510911094116011,0.24929659587822475,0.7168902109310041},
{-0.39838975155546014,-0.10849720894519937,0.9107765705740792},
{-0.5363124265028848,0.05660131146758024,0.8421195121351469},
{0.19920446521813234,-0.43980985844846693,0.8757196294754945},
{0.32440176961647993,-0.27420149577323916,0.905304938451909},
{-0.2746054798070249,-0.29020579111434314,0.9167182932960659},
{-0.3193146105742678,-0.2684122814849154,0.9088415849981041},
{-0.6605712756826019,0.051897743275699425,0.748967431859323},
{-0.4962907963725211,0.26039517101632986,0.8281846414582349},
{-0.7150806001264742,0.1686954233552457,0.6783815957569572},
{-0.7606593096185688,-0.043897651757927134,0.6476653540685513},
{-0.658412243289497,-0.09440175541696312,0.7467138852737962},
{-0.6597204945354991,-0.05730178010744899,0.7493232780892064},
{-0.10370357731660038,-0.01860064164020026,0.9944343036029644},
{0.3098035054464963,-0.34420389468910273,0.8863100286547116},
{0.7367438486150143,-0.328819570279105,0.590835164601263},
{0.337794804755854,0.22639651804832844,0.9135859491561522},
{-0.16630243385392932,0.22520329587435287,0.9600140499084313},
{-0.5636091840864826,0.3398055371763428,0.7529122688053811},
{-0.3577094400766871,-0.03370088937820619,0.9332246281229086},
{-0.8037954505306248,0.12419929703396818,0.5817967070399571},
{-0.6768242408942892,-0.262309394779214,0.6878246348804552},
{-0.7311115114413722,-0.3001047251860974,0.6127096471893432},
{-0.48610848266703444,-0.7190125468784155,0.4967086676418762},
{-0.8501060272731,-0.27500194977073583,0.4491031841528635},
{-0.14389354579975147,-0.29288686285439336,0.9452576014211611},
{0.199198995043605,-0.32839834323453765,0.9232953419867496},
{0.8682121984670832,-0.34450484032701006,0.3571050173607411},
{0.922090474854592,-0.3252966397030677,0.20959783486554873},
{0.8819076638108979,-0.19300167719186223,0.4301037376177199},
{0.7183105233262507,-0.3166046382919267,0.6195090758744428},
{0.6188058879660361,-0.20170191920289185,0.7592072238911032},
{0.6664016226899269,-0.21440052206590685,0.7141017388398511},
{0.8947009886451387,-0.15770017425878882,0.41790046178026535},
{0.9981609227647957,0.013499471506035607,0.059097686370866986},
{0.994617182160234,-0.0955016498052507,0.04020069447299558},
{0.9858348350893578,-0.0820028976235822,-0.14630516978451313},
{0.9463075042482632,-0.29070230527842134,0.14140112131533805},
{0.9047853018821553,-0.3571941974273938,0.2318962328762951},
{0.870833209857699,-0.14300545361696249,0.4703179359164858},
{0.5837941124660635,-0.20269795580142355,0.7861920712929413},
{0.36029356701579085,-0.1870966594189688,0.9138836827525153},
{0.15370742655372524,-0.14880718979306645,0.9768471975125492},
{0.040298887564562964,-0.30539156978207266,0.9513737376904516},
{0.37011558774622383,-0.25801086635645976,0.8924375858004058},
{0.17219472575632386,-0.29109108401664274,0.941071175431338},
{0.6769967233437886,-0.19819904071896435,0.7087965694329059},
{0.873872303056275,-0.15229517308098256,0.4616853671141803},
{0.9995567401204111,0.015199342186704929,0.025598892103924093},
{0.9987193703500337,-0.050400977536439066,0.004400085340482776},
{0.9775755218153968,-0.020399489203185447,-0.20959475181312107},
{0.8713922925692582,0.07579932955789509,-0.48469571288537927},
{0.8488059374182985,0.1379009646206213,-0.5104035702854612},
{0.8318724571589078,0.16939439144454738,-0.5284825022340218},
{0.9845340162379016,-0.12640436734633903,-0.12130419113220667},
{0.9458270084758461,-0.15550444049269832,0.28500813852359497},
{0.9171258357986968,0.04620130150899552,0.3959111529742711},
{0.7182963007835764,0.03209983468627704,0.6949964207776494},
{0.794122767826135,-0.1404040254411149,0.5913169533000802},
{0.28279215828217474,-0.24609317593084587,0.9270742925862949},
{-0.4770068546377521,-0.08150117118024486,0.8751125754580646},
{-0.2539944325030586,-0.21599526543567188,0.942779334503479},
{-0.0639012106199029,-0.20190382510420024,0.9773185154746652},
{-0.2520032811040801,-0.1436018697085155,0.9570124603833519},
{-0.3773079952411297,-0.25870548202724686,0.8892188427469189},
{0.9978996158087218,0.006999997305001556,0.06439997520601431},
{0.9907431478036507,0.0671029223959069,0.118005139235723},
{0.8564235990774133,-0.0552015210988711,0.5133141445661329},
{0.851504759924912,-0.2244012544065182,0.47390264912321295},
{0.5712182678523136,0.016800537289773928,0.8206262440469336},
{0.48277852407502414,0.12229455984750509,0.867161425181982},
{0.9759491250981285,-0.03549814952969627,0.21508878771373716},
{0.995911343494804,0.03790043168837542,0.08200093399595736},
{0.9782730293843646,0.026699263911440802,-0.20559433184240558},
{0.8979424691933946,-0.00900042568519941,-0.4400208112764156},
{0.9529897554151937,0.017499811878033466,-0.30249674817743555},
{0.9953859651568364,0.011999830803578498,0.09519865770838942},
{0.8491665010422879,-0.0698972426081676,0.5234793491470062},
{0.6910076253112182,-0.014200156699593776,0.7227079751265085},
{-0.05270274008668751,-0.17670918734948166,0.9828510997570491},
{0.16999971015074128,0.009499983802541424,0.9853983198972969},
{0.21700386270313446,0.12120215741760322,0.9686172415403504},
{0.5562839403144613,-0.26419237287629094,0.7878772543119972},
{-0.5178958076504057,-0.054699557208876586,0.8536930893824122},
{-0.6769838168952834,0.08049807571649972,0.7315825117290833},
{-0.48198204891287616,-0.19949257003759088,0.8531682243412156},
{-0.40449431891718596,-0.19279729218104685,0.8939874440345222},
{-0.547697606566689,-0.1887991749494082,0.8150964380363488},
{-0.7101138970649495,-0.1661032506724238,0.6842133901870702},
{-0.6837826321417125,-0.19559503194928193,0.7029821444802924},
{-0.6365077304333294,-0.2561031103911637,0.7275088356484638},
{-0.3200007280024843,-0.2731006213046202,0.9072020638870429},
{-0.15259893181121598,-0.20499856501506733,0.966793232471059},
{0.2939070038873549,-0.1872044611354639,0.9373223366574269},
{0.6367680063952579,-0.3415828376014763,0.6912652682491234},
{0.9295699707271358,-0.1210960880540621,0.3481887519440498},
{0.9567211485547358,-0.238105263375021,0.16730369828912647},
{-0.9792215773851891,-0.08350183998331628,-0.18480407220259698},
{-0.6179035900302872,-0.7411043058285253,-0.2626015257192967},
{-0.9963097090854228,0.08110079033105269,-0.028100273838502842},
{-0.8815517936582097,0.10839407263220273,-0.45947487430347933},
{-0.8472088787955748,0.007600079649252089,-0.5312055670635144},
{-0.9885530646147117,0.009199563215107573,0.15059285002121747},
{-0.3480879180780416,-0.11099614739058494,-0.9308676901432028},
{-0.6392631187782625,-0.08869488289634268,-0.7638559306033391},
{-0.616621381717123,-0.052201810129149886,-0.7855272386292573},
{-0.6606956361197349,-0.14459904492646236,-0.7365951348052018},
{-0.647404748731248,0.058400428368713134,-0.7599055739278272},
{-0.9474413614554712,0.11430499009326615,-0.29881304496822336},
{-0.9870174703638396,0.097801731105961,-0.12740225503987151},
{0.6461092232749939,-0.21200302636480217,-0.7332104666541177},
{-0.2922110633202899,-0.015000567932253074,-0.9562362037880261},
{0.4952884153394463,-0.06649844461957032,-0.8661797402928091},
{0.8054579763263492,-0.1540919604616889,-0.5722701425841957},
{0.6766029905918276,-0.0918004057586902,-0.7306032292734101},
{0.46940738383622205,-0.04730074404655583,-0.8817138694682509},
{-0.31800177286482556,0.0713003975008241,-0.9454052706490758},
{-0.40690839664139794,-0.03940081304416584,-0.9126188320839022},
{-0.7716928502988628,-0.015999851762060133,-0.6357941093948645},
{-0.8339021473007939,0.10920028119108612,-0.5410013930803809},
{-0.36458311836954677,0.1490930964040028,-0.91915743940013},
{0.44889647393204585,-0.1464988492560586,-0.881493075899083},
{0.7073817639331855,-0.35159093610249936,-0.6131841923152804},
{0.896895528986932,-0.1789991076916722,-0.404397984081074},
{0.9926677338597077,0.116396216602468,-0.03259894038866371},
{0.9397152141124757,-0.0433007010440249,-0.3392054917813683},
{0.8494422098321359,-0.034901734310267885,-0.5265261637351302},
{0.7517790482098855,-0.08369766737851478,-0.6540817709950599},
{0.33621558563471654,-0.039801845057292444,-0.9409436184524236},
{-0.193691851555204,-0.04209822896476039,-0.9801587655880792},
{-0.18000123121263223,0.022600154585586046,-0.9834067265250143},
{-0.30301056767782486,0.037901321831648724,-0.9522332097122932},
{-0.7531952850122737,-0.0011999924880705369,0.6577958822106661},
{-0.9092428763587758,-0.11790555996777351,0.3992188256075927},
{-0.814634194988017,0.029501238340469558,0.5792243134508465},
{-0.8539021603751986,-0.08030020315977099,0.5142013009309371},
{-0.8901411210189002,-0.06640306756056058,0.45082082614910707},
{-0.8125161814208811,-0.28340564407960334,0.5094101450040576},
{-0.8268022778434132,-0.15080041545571687,0.5419014929406697},
{-0.9237351672672396,-0.06240237570366542,0.377914387474602},
{-0.9601200235118876,-0.1748036455680429,0.2182045507033579},
{-0.9706528807995746,-0.16259210715773237,-0.1771913984523381},
{-0.9948836541958412,-0.009299847204765626,0.10059834718273356},
{-0.9431923318775126,-0.08609930001553628,-0.3208973911148153},
{0.30548717744483445,0.02529893809935945,0.9518600465130538},
{0.2949957506168183,0.16589761026213615,0.940986445187885},
{0.22571030391056565,0.10100461096573829,0.9689442333138992},
{0.1678941397573259,-0.1535946388726936,0.9737660112905536},
{-0.3066848210104168,0.04269788672039387,0.9508529386984198},
{0.1618943354163039,0.2620908296023055,0.9513667122610967},
{0.23999374944419252,0.11469701275520368,0.96397489360084},
{0.2932130981216462,-0.23011027925576666,0.9279414520705167},
{0.14189993543554408,-0.4708997857406462,0.8706996038317705},
{-0.17260921412578162,-0.23781269478048014,0.9558510246895833},
{-0.22710035087031313,-0.2165003344932752,0.9495014669808998},
{-0.2816946971472388,0.12759759799782633,0.950982097930508},
{-0.1456033474594376,0.20850479358030727,0.9671222343957561},
{-0.23241148489729632,0.1030050901222957,0.9671477927890503},
{0.12120453010397055,0.20590769594395655,0.971036293159698},
{0.21899812866898574,0.27149768006223574,0.9371919917286459},
{0.33319165531948747,0.22719430998975856,0.9150770821814616},
{0.8266067864695755,0.13190108291233607,-0.5471044917463159},
{0.6848805393959556,0.2998914787046972,-0.6640811304027656},
{0.8869855200795762,0.00209996571833947,-0.46179246129960344},
{0.9906323694415159,-0.040201313599383136,-0.13050426429650497},
{-0.7454359905184542,-0.1192057553928089,-0.6558316643171483},
{-0.23999600409979735,0.18029699807997276,-0.9538841179616528},
{-0.44911903855957536,0.2096088855089891,-0.8685368180560926},
{-0.779291217437469,0.009299895190771797,-0.6265929383373773},
{-0.3762911986517941,-0.2964930651083097,-0.8777794689783281},
{-0.4581245309347809,0.39972140365560344,-0.7939425127900515},
{-0.09050111769570535,0.11170137952055566,-0.989612221786409},
{0.06300167933214419,-0.1912050966397773,-0.9795261096164324},
{-0.21799936780275003,0.02619992402033051,-0.9755971707723071},
{0.14699459804778078,-0.03649865869893877,-0.988463674627424},
{0.44639419244933415,-0.6408916620537147,-0.624491875413551},
{0.990999499545379,-0.10549994672254034,0.08239995838803152},
{0.9661964009251099,-0.012599953065262251,0.2574990408178595},
{-0.30440909435754293,0.15080450535189707,-0.9405280986966792},
{-0.5601134596881564,-0.17730426067257657,-0.8092194457769258},
{-0.6835294094855283,-0.08690373911381478,-0.7247311822299376},
{-0.5631211343327648,0.1917071949060398,-0.8038301683123358},
{-0.6445787163621728,0.4357856105967033,-0.6281792578633524},
{-0.5945057399806294,0.5262050805345789,-0.6080058703250171},
{-0.18120314480786745,0.09110158108165962,-0.9792169944584095},
{0.5096172635772105,-0.0340011518085266,-0.8597291238173623},
{0.7584894608621614,-0.20229718910008607,-0.6194913922269072},
{0.9547832627961035,0.028899493396321103,-0.2958948130093915},
{0.9547114518325476,0.2566030779723805,0.15060180647950316},
{0.9993769096632502,0.034799195973865424,-0.005899863685224311},
{0.9962125324324874,0.06460081268333537,0.058200732169816076},
{0.9937536076957117,-0.008199617209805632,-0.1112948043233374},
{0.84936280721699,-0.1498934363101328,-0.5060778393366124},
{0.6171793495244415,-0.06919768468420505,-0.783773775368207},
{0.3373933652247086,0.05789886143008485,-0.9395815233110143},
{0.004400044264667956,0.09560096175051286,-0.9954100138751097},
{0.32079940652164696,0.19949963092602424,-0.9258982870897534},
{-0.36138745103864023,0.12299572904746195,-0.9242679053542202},
{-0.6905943509613136,0.155198730479577,-0.7063942217188994},
{-0.8108876381121848,0.2031969022868368,-0.548791633735315},
{-0.9576181135179274,0.14040265574135025,-0.25150475725747573},
{-0.9903140080907173,0.10390146969668337,-0.09210130278214185},
{-0.9940224055175333,0.059401338921269094,0.09160206473380891},
{-0.13259597444732274,0.10139692163618799,-0.9859700664031692},
{-0.4824881044024271,0.056498607044014784,-0.8740784498614748},
{-0.3540954622957259,-0.5598928250194207,0.7490904004680267},
{0.026700609047838653,-0.50651155366031,0.8618196583306124},
{-0.04749993848761948,-0.6602991449131609,0.7494990293993853},
{-0.7333057601393689,-0.4512035442177598,0.5086039951000724},
{0.5168115560355909,-0.507011336900241,0.6898154244453377},
{-0.3191112408914441,0.06430226508718224,-0.9455333069973689},
{-0.8031182992589253,-0.13590309658733402,-0.5801132180302608},
{-0.6358993831778975,0.0687999332640971,-0.768699254362085},
{-0.18990187434074968,0.35850353844738675,-0.9140090213135608},
{-0.4951946692580781,0.269297101032311,-0.8259911082535794},
{-0.7901027693150597,-0.028700100594028874,-0.6123021461227832},
{-0.8277828319620957,-0.1591966982947157,-0.5379888422271171},
{-0.8012946994530946,-0.10769928757156906,-0.5884961071111272},
{-0.7536211242961752,-0.04570128102486094,-0.6557183800437926},
{0.24759273821148084,0.13169613740893388,-0.9598718473715688},
{0.14659930145599284,0.32409845567453804,-0.9345955466628302},
{-0.1284010419786835,0.461103741872048,-0.8780071250567298},
{-0.6632016679542924,0.09170023062637005,-0.7428018681490476},
{-0.744065204604291,-0.031398531681998035,-0.6673687912282003},
{-0.8905716758182688,-0.015299513406714028,-0.45458554213674496},
{0.3487124248450498,-0.2413085979785217,-0.905632268252587},
{0.3366861372336933,-0.36388501734286005,-0.8684642417210057},
{0.4267082227466793,-0.21640417014853855,-0.8781169214761169},
{0.13099967119123798,-0.1278996789722087,-0.9830975324282905},
{0.09229727450172534,0.017899471436412608,-0.9955706012342119},
{0.6927134006703551,-0.14290276448071856,-0.7069136753773265},
{0.49419407464856724,-0.39449527003006835,-0.7746907115140531},
{0.34330402011361344,-0.17000199073496736,-0.9237108167169961},
{0.0851984830545137,-0.2975947013735126,-0.9508830696776652},
{0.7496150486731546,-0.16870338675448396,-0.6400128483868983},
{0.7498980990107285,0.24149938779982788,-0.6158984386994368},
{0.5983860667426519,0.3223924931781935,-0.7334829210490227},
{0.0021000834694762742,-0.14830589453491974,-0.9889393061738513},
{0.08079847696306375,-0.47089112378597425,-0.8784834407432116},
{0.11500320748418572,-0.31190869925493503,-0.9431263041594395},
{-0.03300098987953738,0.09500284965321366,-0.9949298433682344},
{-0.3565070909965606,0.13410266732858,-0.9246183908426926},
{0.2229035820893465,0.015600250698043092,-0.974715663806577},
{0.48511720741252573,-0.4777169449205598,-0.7324259796102534},
{0.642928659183739,-0.40701814323811125,-0.6488289221938246},
{0.6497788695347385,-0.4439855618242904,-0.6169799361387098},
{0.3126088938495468,-0.6797193382902654,-0.663518877380596},
{-0.843305376088909,0.05700036337847481,-0.5344034068325778},
{-0.6791646809591262,0.19039009902034396,-0.708863136531102},
{-0.9837454599280792,-0.04700217202055477,-0.17330800874813065},
{0.7337045159651937,-0.08600052933488708,-0.6740041485083013},
{0.838198742702829,-0.13259980110044753,-0.5289992065017854},
{0.9305731719621729,-0.10309702775553409,-0.3512898724589634},
{0.680381024437839,-0.10089718601672244,-0.7258797554959249},
{0.9631558451323966,-0.1023953057948063,-0.24868859913250316},
{0.9572983055834987,-0.06999987610032896,-0.2804995035163182},
{0.8532951063665974,-0.01169993290107722,-0.5212970103702183},
{0.5097774938204609,0.06989691411936096,-0.857462143882003},
{0.5126038804260623,-0.05430041105566755,-0.8569064868066578},
{0.35539691516816446,-0.08979922054614849,-0.9303919242331463},
{0.03660088465407327,0.18570448853173238,-0.9819237333834573},
{0.8183112477654013,0.0731010047802161,-0.570107836186063},
{0.968401375130929,-0.21320030274464485,-0.12940018374839138},
{0.1435956218362343,-0.9600707278897531,0.24009267968579287},
{0.31291061097873046,-0.01690057310815131,-0.9496322025739932},
{0.17099085821814156,-0.10879418347446666,-0.9792476459241287},
{0.37030475104043403,-0.1304016730641982,-0.919711799978091},
{0.640803793569687,-0.012400073408651869,-0.7676045442323528},
{0.6492027461334242,0.053900227998446654,-0.7587032093213631},
{-0.2193053357637295,-0.03780091970756486,-0.9749237201826716},
{-0.0543017045572595,-0.048801531904130085,-0.9973313067210846},
{-0.07759695942271637,-0.006899729639391017,-0.9969609348511368},
{0.06249885940622366,0.4015926710006308,-0.9136833254314649},
{0.3497184323957319,0.280914806005036,-0.8937471061826298},
{0.8388810289200439,-0.23889459745976696,-0.48908893937870246},
{0.9341038251629961,-0.15120061916780322,-0.3234013243311347},
{0.8937384449860843,0.039801712107470244,-0.4468192203421534},
{0.9920892557315404,-0.12549864085707924,-0.0029999675105277907},
{-0.4960165151448122,-0.23950797455077122,0.8346277893948796},
{-0.5104005461288765,-0.2851003050574896,0.8113008680923933},
{-0.5493989314201176,-0.1936996232545992,0.8127984191086123},
{-0.7264861569381681,-0.11849774204703774,0.6768871020391548},
{-0.8332975459423407,-0.005399984097070251,0.5527983720111915},
{-0.7547159020315855,-0.17560370000893918,0.6321133187679411},
{-0.6330653564462768,-0.18298998614700465,0.7521588392337536},
{0.18409695598199904,-0.21149650293423572,0.959884128447153},
{0.1475992531496686,-0.36559815007804086,0.9189953498952942},
{-0.12029598097841215,-0.44228522349752036,0.8887703066800725},
{-0.012800376272590881,-0.513615097937709,0.8579252190824779},
{0.023798825675919823,-0.31148463017012706,0.9499531257194885},
{-0.6491020868665639,-0.03260010480950544,-0.7600024434117834},
{-0.08859971382338654,0.35489885367855395,-0.9306969938535649},
{0.04389875439051601,0.43268772266005184,-0.9004744493999923},
{0.1906955120339358,0.081298086672045,-0.9782769765222831},
{0.34120421389806266,0.36050445225747824,-0.8681107212336112},
{0.4022954661556445,0.7764912489929354,-0.4849945341424001},
{-0.19550183968096715,0.6907064995787416,-0.6962065513344723},
{-0.5797938078351983,0.21239773160433967,-0.7865915992465798},
{-0.38039068814992977,-0.10559741500692056,-0.9187775086018808},
{0.7767353383780975,0.022401019157550387,0.6294286365072417},
{0.9577180531554546,0.020100378895713308,0.2870054101029711},
{0.9793059003358242,-0.11150067179357134,0.16890101763169685},
{0.814117397874691,-0.301806449672745,0.4961106019968482},
{0.7170784090941482,-0.18899430946701162,0.6708798001133233},
{-0.4255209574232423,-0.253412480872032,0.8687427866358887},
{-0.26360557531687756,-0.20070424493967118,0.9435199556580955},
{-0.7088938432837064,-0.28539752133329077,0.6449943982479767},
{-0.9158100693870697,0.012900141837839265,0.40140441346578926},
{-0.921287111283469,0.07019901792260884,0.38249464893729174},
{-0.9567131883822033,-0.08770120896949853,0.27750382541660024},
{0.7754068003474587,0.6189054278244032,0.125301098895456},
{0.5369314409410634,0.828848534646961,0.15720920565456353},
{0.49051514243617406,0.8576264753379468,0.1545047696358591},
{0.8338687096637438,0.29298900579383247,0.46778244679301995},
{0.9561073142489311,0.2665020387483947,0.1218009317806922},
{0.9345261951363796,0.3160088578524301,0.16370458870393295},
{0.9288054381717608,0.1971011540306353,0.3138018373151363},
{0.612633659017865,0.7820429666209117,0.11440628565400549},
{0.6256286669622954,0.7780356504102713,0.057002611919518595},
{0.7083744989770472,0.6899751613412796,0.14879464348924987},
{0.9882872857658525,-0.03799951113943377,0.1477980985896924},
{0.9504675183275824,-0.052898192235170026,0.3062895327340752},
{0.7876860383887032,-0.33039414381570087,0.5199907832450498},
{0.9437491422972925,-0.26841397667965805,0.19311005550239183},
{0.8306439380731873,-0.518827444103503,-0.20211069092775238},
{0.81727027642056,-0.5395803758185908,-0.20229264275037234},
{0.8980358323445801,-0.35761426909401095,-0.25621022299185015},
{0.9006310903218661,-0.3936135877755791,0.18420635891326642},
{0.7912532847903571,-0.539836353804139,0.2872193420017575},
{0.8528100888030262,-0.3375039926958506,0.39850471433865614},
{0.7969767724504455,0.39748841536894863,0.45478674543345365},
{0.9425062441245511,0.29410194843186255,0.1587010513979483},
{0.9903136218575536,-0.0036000495190217034,0.13880190923339236},
{0.7361977987718724,-0.5076984819838083,0.44749866198100097},
{0.6881665937635391,-0.675667200531856,0.26438716563655873},
{0.8806356224314056,-0.4443179730255206,0.1645066544287602},
{0.8492570541566294,0.4335780745111439,-0.30128476441468555},
{-0.5869785023060224,-0.28448958075990355,0.7579722397750682},
{-0.7792049518632036,-0.24640156588692683,0.5763036624214121},
{-0.9158237201415315,-0.10200264190263836,0.38841005995083083},
{-0.4573053825160285,-0.22410263770356872,0.8606101294408356},
{-0.5879845803065696,-0.39728958121734714,0.704581522591852},
{-0.6117884709548963,-0.2661949836028006,0.7448859627562966},
{-0.29589982985764673,-0.2402998618276192,0.9244994684129585},
{-0.5917861109429623,-0.16569611115790614,0.7888814851688122},
{-0.7217819953726853,-0.1851953803588547,0.6668833648019449},
{-0.7578758203576711,-0.26039169233558196,0.5981809153423391},
{-0.7737932641589532,-0.4228963187035685,0.47159589477560393},
{-0.1567015372496207,-0.8118079638751886,0.5625055182062005},
{-0.4937994148480402,-0.3426995939012219,0.7991990529496835},
{-0.05049967023823001,-0.5283965495817967,0.8474944658792066},
{0.03689923933002174,-0.3010937930154348,0.9528803565739218},
{-0.23239049890867422,-0.1974919257076728,0.9523610635138612},
{-0.08659943970343767,-0.14729904697824905,0.9852936251708677},
{-0.8519195176997283,-0.04040092559580822,-0.5221119617220662},
{-0.7786057889555613,-0.16510122753219006,-0.6054045011991998},
{-0.6386689933730393,0.005399737849090985,-0.7694626434954653},
{-0.7178677469266797,-0.02079906551897888,-0.6958687353200674},
{-0.279901603840785,0.02070011861201947,-0.9598054997012699},
{-0.6708837010784711,-0.06529841359431235,-0.7386820539374968},
{-0.21980283437582404,-0.3096039923692226,-0.9251119293952449},
{0.0024000212882832406,-0.5793051384593673,-0.8151072300331957},
{-0.3404922675084064,-0.3413922470701026,-0.8760801044467396},
{-0.8115766553332592,-0.10689692515417126,-0.5743834780968754},
{0.09660473712943057,-0.16140791483116038,0.9821481608158773},
{0.27720164519664636,-0.6610039230699252,0.6973041385123431},
{-0.279607666947343,-0.01300035647466187,-0.9600263242827226},
{-0.577987397122207,0.02749940038211193,-0.8155822164236541},
{-0.33991251750894014,0.19350712603112658,-0.9203338919196165},
{0.11330087581915513,-0.454703514871755,-0.8834068287611795},
{0.5230188159403613,-0.3592129229173571,-0.7729278065780214},
{0.6816011723550246,0.25940044616915114,-0.6842011768270362},
{0.7168176052565803,0.17080419500254454,-0.6760166031716635},
{0.7436970921500546,-0.17129933022092828,-0.6461974733728187},
{0.869011201626584,-0.10690137796764305,-0.48310622727940467},
{0.7071102319590852,-0.5297076649253676,-0.4684067778951146},
{0.8004103213576413,-0.1834023649887449,-0.570707359318848},
{0.8477823069678784,-0.13029728072412664,-0.514089271068868},
{0.9785369845042572,-0.04540171599028439,-0.20100759722570843},
{0.7994865887249603,-0.040899313919763446,-0.599289946995458},
{0.6526166386733071,0.10470266942858607,-0.7504191321796655},
{0.5107974230335013,0.08789955654785583,0.8551956855486497},
{-0.4485872939448459,0.4837862969472057,0.7514787146668562},
{0.1532068722483855,0.1153051721294964,0.9814440236590439},
{-0.42787804827983505,0.48957488300492463,0.7597610214606654},
{-0.40038833285396846,-0.2643922957207524,-0.8773744336814983},
{0.03829797064430192,-0.6277667355220038,-0.777458803549471},
{0.7640668898787252,-0.45548026219049775,-0.45688020152544107},
{0.019400048403181148,-0.5716014261473373,-0.8203020466561596},
{0.1438932983256921,-0.14129341941223275,-0.9794543829743948},
{0.38129130093820246,0.2264948325793414,-0.8962795516152922},
{0.18679955728557382,0.15989962103834718,-0.9692977027671666},
{0.40380805201283654,0.20220403198859718,-0.8922177910001307},
{0.8496259309791262,0.3106094799459941,-0.4262130082195193},
{0.829722124835442,-0.022700605319711385,-0.5577148716653321},
{0.6114896964854205,0.32729448513438775,-0.720387861566798},
{0.4662776798216876,0.6296698584252985,-0.621370255717771},
{0.7185943051626974,0.5329957760252125,-0.44669645994458235},
{-0.6133917775383327,0.1782976099365581,0.7693896864003803},
{-0.37138452844281095,0.12099495945498148,0.9205616502004623},
{-0.6768003079442102,0.25740011711708,0.6897003138137142},
{-0.42969719193802597,0.7536950746187809,0.49729675017635633},
{-0.81992623395954,0.2520080631269717,0.5140164462192994},
{-0.5274970433873577,0.6949961045577508,0.4885972614200246},
{-0.4886727108344239,0.7155600406652624,0.4991721245110382},
{-0.7965643864024081,0.4830784020474559,0.36348374900486485},
{-0.9203944914554527,-0.12899922794193114,0.3690977909563316},
{-0.7254880331735883,-0.27549545573993606,0.630689596860899},
{-0.4414056036797083,-0.2836036003705602,0.8513108074593014},
{-0.17300723185344036,0.1998083521636843,0.9644403144477335},
{0.12220266099191497,0.5819126712863774,0.8040175076718464},
{-0.6493964900214572,0.27289852498745865,0.709796163562104},
{-0.7853970429856998,0.3900985312817946,0.48059819055121894},
{-0.9782856731112253,0.20359701834349941,0.03879943178648221},
{-0.9584788274365502,0.1667963155100851,0.23129489075229429},
{-0.6369371631829605,-0.6839399056379756,0.355720755132955},
{-0.23059460645523178,0.2198948567194513,0.9478778293968526},
{0.2508088323885516,0.050201767886384724,0.966734044138807},
{0.5513193599192413,0.2472086808852466,0.7968279811058433},
{0.6304015633978158,0.20320050393787464,0.7492018580229118},
{0.11440389437484791,0.0934031794983461,0.989033667279061},
{-0.5074181252991593,-0.10040358648016476,0.855830570813994},
{-0.7851128681053632,-0.4075066790892058,0.4664076444839401},
{-0.8547136883493293,-0.3428054900738856,0.38980624279696796},
{-0.8637861536189354,-0.0630989885313207,0.49989198679567703},
{-0.9102164523110646,-0.41340747240759623,-0.024500442849506792},
{-0.891053143994309,-0.44242638709661314,0.10140604803706278},
{-0.9508712175638601,0.2537923178228076,0.17729463337267054},
{-0.7292119846974535,0.5168084938173945,0.44850737127922097},
{0.6894009617150124,-0.2863003993893357,0.6654009282349423},
{0.6979083923988783,-0.3123037554752396,0.6445077502522955},
{0.9261509153021991,-0.15599173265724794,0.3433818012467881},
{0.7456740920037522,-0.25979097371942445,0.6135786815790564},
{0.7198118122087583,0.03450056615893604,0.6933113773330538},
{0.9706873277596537,-0.18609757051207534,0.15209801437338347},
{0.8711030924214671,-0.20880074124394712,-0.4445015779834028},
{0.9672911735083125,-0.23639784287952553,-0.09199916051149049},
{0.9704758063397181,-0.23309418903430015,0.061998454397797546},
{0.8019109822461034,0.0384005258988033,0.5962081651267325},
{0.316596376575205,0.259797026640045,0.9122895589057471},
{0.7048853843530816,-0.33749300215514977,0.6238870638358457},
{-0.5181012978453767,-0.04170010445889251,-0.8543021400295412},
{-0.703536479312203,-0.02140110967630582,-0.7103368319196273},
{0.6877623082195187,-0.0610966516897537,-0.7233603573218957},
{0.9072511413053921,-0.24608674735507222,-0.3410816315433366},
{0.9927624097630181,0.07449717921771237,-0.09419643331957726},
{0.74909839318567,0.3461992574033893,-0.564798788507898},
{0.7305074292983341,0.3979040467047325,-0.555005644436106},
{0.7806814707451851,0.43228973972479,-0.4512892887758448},
{0.23300521354998044,0.08870198472911271,-0.9684216686772578},
{0.02229917728703071,0.36108667795277083,0.9322656046950104},
{0.225706115590054,0.2714073538818815,0.9356253511123372},
{0.1500009900098011,0.6518043019225891,0.7434049064885742},
{-0.6303925235890051,0.6415923907593681,-0.4369948172722006},
{-0.86236743330881,0.13159503040751322,0.4888815377373344},
{0.3618940468918926,-0.11749806717269239,0.9247847874153696},
{0.40120851774724864,-0.44770950497368694,0.7991169654332662},
{0.5130076105243536,-0.13430199238483564,0.8478125773928791},
{0.6976565164244546,-0.04439723280671605,0.7150554319838434},
{0.6059126667366985,-0.05370112263370311,0.793716592818811},
{-0.41418794316445917,-0.030699106362020515,-0.9096735197892527},
{0.3048902878745672,-0.07189770973493402,0.9496697487519726},
{-0.6315131577137129,-0.015200316701897762,-0.7752161517967858},
{0.7236496248847343,-0.2384833985560441,0.6476549150723262},
{0.16920154566317946,-0.6778061917878431,0.7155065361820622},
{0.30171642287185757,-0.1659090306743161,0.9388511030563469},
{0.2059104965550997,-0.6868350123071513,0.697035532291911},
{0.5070871125447999,-0.57608535897665,0.6410837070646248},
{0.7579901727211156,-0.24329684567684356,0.6051921537345899},
{0.4224842881014828,-0.3397873635429204,0.8402687509862156},
{0.24160567780014325,-0.6312148337228908,0.7370173201105363},
{0.20410617736693845,-0.6915209291976381,0.6929209715705617},
{0.051698338700578356,-0.7826748491478274,0.6202800676202853},
{0.050698303156189575,-0.23419216171951868,0.9708675056083719},
{-0.050898009417776745,-0.3169876028572736,0.9470629610918734},
{0.2817873522585344,-0.12979417431922557,0.9506573307032955},
{-0.004099889898935127,-0.037898982236497875,0.9992731648794808},
{0.003899823985416537,-0.14749334303818953,0.9890553599937172},
{-0.4288136514998967,0.09830312952994366,0.8980285891952128},
{-0.3117036485125589,-0.11730137302060686,0.9429110368382797},
{0.11909761449867215,0.002199955935323919,-0.9928801128105087},
{0.8180494542857812,0.02589839978731418,-0.5745644987563988},
{0.7799429526411354,0.1531084319135246,-0.6068334192366214},
{0.5936898301803127,0.18309686357759017,-0.7835865772768958},
{0.6129988199784073,-0.7322985903265704,-0.2965994290466486},
{-0.3215102402642312,0.11140354825951898,0.9403299499858682},
{-0.2761947454449514,-0.2999942926628726,0.91308262876823},
{-0.490425478265411,0.01550080528775259,0.8713452675625053},
{-0.20430651952505874,0.39871272312599565,0.8940285289055434},
{-0.1282037897600388,0.3008088920422751,0.9450279354386634},
{0.10539548442720251,0.023299001775652927,-0.9941574062383751},
{0.9612217190501157,0.05160116594151682,0.27090612119296326},
{0.9612265590567451,-0.047101301426937886,0.2717075073821449},
{0.6466704510688422,-0.632671090754997,0.42608053069496465},
{0.8849780262684082,0.34789136196472226,0.30949231540121164},
{0.2228979705232175,0.770192987424774,0.5975945589263113},
{0.7608007227610301,0.333900317205452,0.5565005286757534},
{0.6847581317440127,0.102993702642572,0.7214558879283078},
{-0.12349679221248287,0.4246889688472994,0.8968767039301692},
{-0.8686055026332888,-0.024400154575468857,-0.4949031352212925},
{-0.9571288913716356,0.017900540335965186,-0.28910872687863326},
{-0.9395971765147267,0.011199966344151702,-0.3420989719941337},
{-0.5784011972917177,-0.6471013395011592,-0.49670102817219247},
{-0.22319737075045878,-0.5443935870813161,-0.808590474860309},
{0.19620138812973154,0.5929041948120175,-0.7810055256336409},
{-0.3674878547270986,0.017199431568179855,-0.9298692683285142},
{-0.9944794443223266,-0.006999855314485958,0.10469783591809712},
{-0.9676817013120407,-0.21969584559083946,0.123797659008402},
{0.4210141673651018,-0.45971546968583676,-0.781926312263119},
{0.23319854367964207,-0.27749826702873365,-0.9319941797145216},
{-0.1144951237565166,-0.2761882373934488,-0.9542593589593344},
{0.7580955196687181,-0.648896165034997,0.06499961585340545},
{0.9248862886624052,-0.3789943814499422,0.030799543400153617},
{0.956558840158643,-0.179292285218947,-0.22989010804147192},
{0.810710352837309,-0.514906575398952,-0.2786035577901496},
{0.9140886745114838,-0.2693966621960329,-0.3030962446607928},
{0.9007850741149818,0.16549725773315885,-0.40149334731035213},
{0.8636683082728813,-0.15609427222576908,-0.47928241305452357},
{0.6603147284842801,-0.26490590879219417,-0.702715674247923},
{0.9657454007584596,-0.12570590957371686,0.22701067202254357},
{0.988840879526957,-0.08520352238642469,0.12220505206128048},
{0.9322185326886465,-0.018800373755145414,0.3614071848462528},
{-0.6375987439317116,0.17469965584201697,0.7502985219133677},
{-0.11790296058051072,0.31890800788061807,0.9404236143334375},
{-0.9739611884199468,-0.22489103827068382,0.02869885637335983},
{-0.9840350224296834,-0.1579056199610234,0.08210292209499698},
{-0.9972016304259986,0.05400008829021653,0.05170008452970731},
{-0.21159384165085685,-0.2225935215098333,-0.9516723019807204},
{-0.15029321441455032,0.22388989159958628,-0.9629565234944243},
{-0.8088736190171166,-0.4470854185468573,0.3818875449408294},
{-0.7146006074107745,-0.6317005369456846,0.30050025542532566},
{-0.9038258995022306,-0.31600905536922425,0.28850826732285184},
{-0.9016786214533251,-0.36729129162671215,0.2281945895704212},
{0.6833777632493698,0.04659848371000971,-0.728576292513156},
{0.8970803093033138,-0.4274906166839445,-0.11179754607079531},
{0.8418147571420401,-0.0793013901655545,-0.5339093595131091},
{-0.9611653794465373,-0.10359626852961014,0.25579078658179805},
{-0.9979866270687953,-0.03659950956985762,0.0517993058939515},
{-0.9301190955410492,-0.36530749983995836,0.037800776057898784},
{-0.7762436972053108,-0.583257694937341,0.23928264426282478},
{0.9490018031051389,0.11280021432061083,-0.2944005593615942},
{0.36799125479174366,-0.1971953137090539,-0.9086784055142865},
{-0.9008932523348099,0.12909903305186363,-0.4143968961788714},
{0.25420167646558445,-0.1671011020354019,0.9526062824591492},
{-0.09799778723494608,-0.5099884845900255,0.8545807037855604},
{-0.22930091605898947,-0.21460085733213757,0.9494037928757287},
{-0.07830026543834975,-0.10670036171483933,0.9912033601850866},
{0.19850474233494225,-0.3354080129931467,0.9209220010894122},
{0.2895089372788428,-0.6951214587306517,0.6580203134006168},
{0.21140406956750915,0.01250024063194827,0.9773188135682435},
{-0.5644935506980246,-0.1725980280787937,0.8071907778980434},
{-0.6340049959790526,-0.6118048210409848,0.47300372728405654},
{-0.78336134990447,-0.5413732893008426,0.30538493267912326},
{0.8972157014121633,-0.19540341958976448,-0.39600693018191785},
{-0.7923143172490702,0.0016000289127836834,0.6101110248058282},
{0.928245837911242,-0.11100548158602441,0.3550175311985465},
{0.9995869154929137,0.017099776165394983,-0.02309969762693708},
{0.7736397158142432,-0.17860916913705255,0.6079312089496878},
{0.6656481513565464,-0.3420733552337007,0.6632483382827058},
{0.5249870119819835,-0.36519096528727685,0.7687809805938074},
{0.767785162695095,-0.19909615250402893,0.6089882314161407},
{0.9897905920851332,-0.006099942020326645,0.1423986465072974},
{0.9752976446590322,0.02649993600273183,0.2192994703924185},
{0.9460349566374835,0.20870771189243428,-0.24790916041271902},
{0.9736500420298982,0.16670856820705016,0.1556079976785663},
{0.9345637115956044,0.30188827790574896,-0.18829268873684177},
{0.9359956710300323,0.26979875218365673,0.2260989542947546},
{0.9694764468558318,0.015499623441222684,0.24469405523014134},
{0.9324218329128294,-0.13450314942811623,0.33540785366684145},
{0.9687858122356692,0.24789636958425101,0.0011999824263860476},
{0.980871035305985,-0.07239786212269683,0.18069466416534966},
{0.9015162003916828,0.3855069276217346,-0.1966035329972322},
{0.9931490975392353,0.0806039847564821,0.08460418251114621},
{0.9570478949457508,-0.14479211700777844,-0.2511863245328311},
{0.9092003636802183,-0.34600013840008303,0.2316000926400556},
{0.9606802053882999,-0.21259561951238948,-0.17859632006073733},
{0.8637768985957665,-0.11279698328502252,-0.49108686605739854},
{0.866271664717263,0.029799025289823894,-0.49868368832332804},
{0.9794574777766335,-0.1372940395086593,-0.147693588022061},
{0.9646988182446715,0.03799995345008554,0.2605996807655866},
{0.9522688565563111,0.2735910523509469,0.13539557196022736},
{0.8051623796666946,-0.23038923531446398,-0.5464744665770598},
{-0.9885914932068013,0.11589900269337272,-0.09619917220968469},
{-0.9864975781514184,0.057099859820016204,-0.1534996231588877},
{-0.9576618379361221,0.1999920304763751,-0.2070917475582864},
{-0.9921293128935805,-0.1085032057745726,0.06250184664433907},
{-0.9831467050616387,0.030298357570552947,-0.1802902267317061},
{-0.8826628848060245,0.169492872974534,-0.4383815664426885},
{-0.8415055287094855,0.35250231594782366,-0.40940268978450783},
{-0.9891325924558909,-0.017300570063175525,-0.1460048109377819},
{-0.9763541417229195,-0.1966907616518827,0.08969578708781839},
{-0.9684036750989206,0.20930079429802156,-0.1356005146049294},
{-0.9184029388941067,-0.3320010624050996,0.21520068864330552},
{-0.8934839799758573,-0.3643934664837184,0.2624952935015809},
{-0.9889142355228813,-0.14800213050600305,-0.012000172743729977},
{-0.9193462488763539,-0.010100508118841698,-0.3933197864495485},
{-0.7885208566524914,0.04820127494058349,-0.6131162171384178},
{-0.7315146231234758,0.19410388017534744,-0.6536130658557809},
{-0.5076176146368472,0.4110142624423644,-0.7572262762076845},
{-0.7864572414821394,0.39397857996689506,-0.4756741383001319},
{-0.8747168909462478,0.13480260306339797,-0.46550898906536914},
{-0.9166740309925477,0.204094218092701,-0.3435902662256348},
{-0.9410666774189184,-0.33688807100460477,-0.029998937756420728},
{-0.892606208097766,-0.3702025747678613,0.2573017895401694},
{-0.8848301334032983,-0.1618055103804856,0.43691487938958073},
{-0.8712723375424175,-0.36698834830490906,0.3258896531677653},
{-0.23239468984200495,0.08749800069352597,0.9686778659636412},
{-0.4223180312532748,0.18940808695091224,0.8864378472718512},
{-0.3624012665946401,-0.5295018506122018,0.7670026806790535},
{-0.059502891613278625,-0.24201176084728449,0.968447062828555},
{-0.3374049312091047,-0.33400488151701535,0.8801128629434886},
{-0.28769273585012856,-0.36949067047835416,0.8835776899449899},
{0.3582931405434858,0.07259861011291396,0.9307821803457343},
{0.3252130591925931,0.002300092362063235,0.9456379728552153},
{-0.3249976242760498,-0.3440974846565807,0.8808935606916068},
{-0.5123946173228173,-0.24789739585153478,0.8221913629250984},
{-0.3699927704118985,-0.32379367313343976,0.8707829850667059},
{-0.1747950900748787,-0.11829667709301002,0.9774725431818875},
{-0.26599469877847953,0.04149917292972519,0.963080805990803},
{-0.17719454780764463,0.18269437858045529,0.9670702437063946},
{-0.00909959539548591,0.35358427822459537,0.9353584102129143},
{0.326501082352882,0.08460028045039454,0.941403120756518},
{-0.28389193048656225,-0.2729922403058524,-0.919173872853991},
{0.022399255237144842,-0.4044865510457629,-0.9142696010411397},
{-0.15950655665176955,-0.3977163484665125,-0.9035371406575158},
{-0.6169088897211518,-0.2114030463398468,-0.7581109244571327},
{-0.49731952017425785,-0.28611123008617567,-0.8190321476427048},
{-0.29459211092890253,-0.5557851162738765,-0.7773791820642526},
{0.028900253600838026,-0.5418047543575794,-0.8400073710970223},
{0.17559685860029922,-0.48609130390435906,-0.8560846847819826},
{0.2816938098465422,-0.5504879031612405,-0.7858827304167466},
{0.33361611237923045,-0.3698178607848904,-0.8671418796283894},
{0.12539604256334405,-0.3713882791708611,-0.919970966174454},
{-0.46330578672541456,-0.28620357470497226,-0.83871047555926},
{-0.7547689456705824,-0.16739311275206079,-0.6342739033371096},
{-0.8763255408800888,-0.1051030632734193,-0.4701137016635054},
{-0.7331963486912753,-0.1805991006187184,-0.6555967351363885},
{-0.5479869005297124,-0.49338820569591263,-0.6754838527514977},
{-0.3728945073043608,-0.5896913139109187,-0.7163894476611533},
{-0.23389659799872298,-0.5131925356688526,-0.8257879890010493},
{0.2837127248010674,-0.23941073781239172,-0.9285416460267574},
{0.46119208139994294,-0.3556938927882908,-0.8128860428664648},
{0.31609654508364327,-0.5487940017143417,-0.7738915414116784},
{0.6941006732779795,-0.296900287993419,-0.6558006361269255},
{0.5490705843313957,-0.34848133061280523,-0.7596593023430364},
{0.6526351127136214,-0.3220173249981399,-0.6858368990177774},
{0.703984758894953,-0.33529274099073547,-0.6260864453751849},
{0.1208038845113607,-0.40471301375618934,-0.9064291466978256},
{-0.3627834556377499,-0.2198899721464752,-0.9055587029370075},
{-0.49219558748633724,-0.2929973732903226,-0.8196926514883189},
{-0.6702995508994515,-0.22549984891515187,-0.7069995263104761},
{-0.8541172063644351,-0.12710256050687238,-0.5043101594304936},
{-0.9563203650590132,-0.03340071127572,-0.2904061842655416},
{-0.9995394076179833,-0.029301155220817318,-0.007900311475920027},
{-0.9301990698013952,-0.0063999936000096,-0.36699963300055044},
{-0.9010260400288408,-0.0522015086454001,-0.43061244487948813},
{-0.5228137763245116,-0.23110608972569746,-0.8205216210295749},
{-0.49919068269286043,-0.0037999290749857165,-0.8664838272302957},
{-0.16010494251586435,0.4800148182861642,-0.8625266266079514},
{-0.1657931222149844,0.0016999294798882598,-0.9861590900387069},
{0.25430031914710083,0.1514001900073577,-0.9552011987782567},
{0.7074936821096279,-0.14399871409722462,-0.691893821415762},
{0.9435194602895548,0.020100414575325968,-0.33070682089852227},
{0.8910126658350679,-0.21910311457291062,-0.39760565200451514},
{0.7876905674619316,-0.34249589863617064,-0.512093867712651},
{0.8439336483053503,-0.2571102511900765,-0.4708187719186621},
{0.9092692399419104,-0.3238890430190089,-0.26139115728672097},
{0.5656999264590143,-0.7410999036570188,-0.3615999529920092},
{0.44409651163560154,-0.4762962587075817,-0.7588940389107364},
{0.3290007813777837,-0.40240095570340473,-0.8543020289697282},
{-0.05270082266626278,-0.24450381673436908,-0.9682151139558942},
{-0.007999925441042333,0.044199588061758895,-0.9989906894501613},
{-0.5653745219712382,-0.11439484491246843,-0.8168631888898203},
{-0.8072667816553882,-0.16249331353771906,-0.567376652931088},
{-0.9449906399140673,-0.32349679578010665,0.0483995206051226},
{-0.9991379379877717,0.036701393578371766,0.019400736659956733},
{-0.9993442019716015,0.03440152161295216,-0.011300499832161609},
{-0.986068125862989,0.006999773735970919,0.16619462784548095},
{-0.9235893880188971,-0.05009942436092112,0.38009563272626984},
{-0.8815051347823651,-0.021100122908573916,0.4717027476765079},
{-0.9796176283778354,-0.0137002465381547,0.2004036062953432},
{-0.9779829734646466,0.13409766537996842,0.15989721621369835},
{-0.9827841330782562,-0.1522975411760464,0.10459831127389661},
{-0.8380309029593304,-0.4975183463272874,-0.22400826045690933},
{-0.6985295134954309,0.18620786744860307,-0.6909291923750798},
{-0.47460939498596155,0.6350125701982419,-0.6095120654107534},
{-0.2561851468157689,0.7185583391952052,-0.6465625133921786},
{-0.0018999568619691679,0.7693825313679356,-0.6387854965399498},
{0.17220179004691136,0.5509057266947935,-0.8166084886893601},
{0.6383885984814457,0.32999410635789017,-0.6953875804887176},
{0.7107829982740194,-0.06519844047195562,-0.700383247033094},
{0.7419844110712834,0.347892690851347,-0.5730879595484536},
{0.8483995079284282,0.15419991056407784,-0.5063997062882555},
{0.3788971563875119,0.4435966708194782,-0.8121939045076199},
{0.2769061501538931,0.4831107300084715,-0.8306184482406054},
{-0.2718017164332589,0.34780219637780524,-0.897305666503176},
{-0.03950127729445231,0.3822123590364474,-0.9232298531199588},
{0.6767925384033959,0.4669948514101447,-0.5690937257762598},
{0.7243050882611177,0.37450263089022306,-0.5789040668153541},
{0.6300739312303818,-0.04069831614200371,-0.7754679156787194},
{0.7346010872104136,0.38280056654525774,-0.5602008290978406},
{0.920293659198532,0.21629850970840211,-0.32599775388321356},
{0.82961738481445,0.3063064187182571,-0.46680978210147694},
{0.3807943300146388,0.42829362275543537,-0.8194877979175328},
{-0.24350624114494182,0.2868073509666091,-0.9265237471079614},
{-0.36610363542714974,0.41820415278785583,-0.8313082549319574},
{-0.6005965645974757,0.2427986111959159,-0.761795642541387},
{-0.604822971612701,0.04600174717953745,-0.7950301958202668},
{-0.5231722281393842,0.07229616226008694,-0.8491549238072728},
{-0.539989154426749,0.518389588249679,-0.6630866820377357},
{-0.22259083723677384,0.33138635876130657,-0.9168622581419494},
{0.6235002961627111,0.3234001536151095,-0.7118003381052409},
{0.6754163959320193,0.6010145898062534,-0.4273103730852115},
{-0.9251671340213355,-0.24489130039107768,0.28998969829894866},
{-0.9533747692705925,-0.19009496920320917,0.23439379685024844},
{-0.9680932717751417,-0.19899861696441815,0.15229894152603457},
{-0.9851964335953655,-0.1713993795353691,-0.0031999884160629007},
{-0.9836990704048177,-0.1681998410512253,-0.0635999398980852},
{-0.8684680279380664,-0.4126848072884744,0.2746898874779353},
{-0.8954844410930028,-0.3192944523070863,0.31009461215292033},
{-0.8695809868195825,-0.3528922840945614,0.34539244807668323},
{-0.4518949252484841,-0.4776946355193646,0.7533915394605176},
{-0.3453934272256192,-0.4558913244706422,0.820284390136582},
{-0.8132922127643439,-0.28989722424736664,0.5044951694818781},
{-0.9265360197879174,-0.17840693570444088,0.3312128761508454},
{-0.9940180863236225,-0.09810178497821667,0.0480008733838369},
{-0.9272115253108899,-0.15730195527545618,-0.33990422503577594},
{-0.9353407677158107,0.1115048600452399,0.33571463244113936},
{-0.8980973012216649,-0.013199960334178794,0.4395986790079544},
{-0.8023716125945107,0.007399738201893545,0.5967788863364956},
{-0.6015889398890093,0.053899009075827134,0.7969853475590766},
{-0.681506099506886,0.08960080193076594,0.726306500472269},
{-0.8255885656775476,0.22029694890838628,0.5194928050744743},
{-0.8906583048074179,-0.013299377404219891,0.45447872407653694},
{-0.7675819428471893,-0.6259852738696463,0.1376967607218056},
{-0.6883277091896614,-0.7122286713422589,-0.1376055394224864},
{-0.8204156454755402,-0.5291100902256318,-0.21670413258721302},
{-0.6680356573548425,-0.6970372053537801,-0.2605139053008031},
{-0.7542884971881262,0.3259950286137202,-0.5698913092238009},
{-0.3158018727106578,0.8083047932616361,-0.49690294664321044},
{-0.20110179081942092,0.5223046511436278,-0.8287073796720741},
{-0.06239690019899525,0.5427730357053625,-0.8375583911326671},
{0.37468595328691195,0.45828281929915066,-0.8059697847591435},
{0.663109744469293,0.5154075739699496,-0.5428079766218251},
{0.820599376344711,0.3853997070963339,-0.42199967928036564},
{0.8488035819586738,0.13340056295156347,-0.5116021589656663},
{0.8197245470190963,0.46391389210950196,-0.33591005897732634},
{0.7810185962741686,0.4883116268382542,-0.38930926956406375},
{0.7678732707966572,0.49748268292920556,-0.40358595141754244},
{-0.8415083940880967,-0.4074040638758058,-0.3548035391829551},
{-0.8543475799416272,-0.16820936784054982,-0.4917273850606323},
{-0.7686183663552987,-0.13400320204476976,-0.6255149468582348},
{-0.8668955745093881,-0.2531987074238979,-0.42939780792978577},
{-0.9194136579913349,-0.3647054177392211,-0.14720218670472537},
{-0.9857844345866659,-0.03869938894147288,-0.16349741839614512},
{-0.9142627216975187,-0.35088569292755034,0.20249174356748062},
{0.8981243125542158,-0.3215087033584015,-0.30000812132976806},
{0.8622145198147716,-0.16120271467657293,-0.4802080867722725},
{0.9757315507898005,-0.2122068618198172,-0.0540017461746943},
{0.9254863260405485,-0.29809559567011074,-0.2336965471590234},
{0.9739121447601683,-0.22430279707331938,0.034400428976024015},
{0.994367280882925,-0.10339659779092363,-0.023299233351339658},
{-0.5122928945468285,-0.4828933023163449,0.7101901497309343},
{-0.8980860752833533,-0.33379482455136766,0.2863955594712753},
{-0.8957818337286162,-0.37939230600205065,0.2315953032948733},
{-0.31627876259411375,-0.5769612583522087,0.7530494344281601},
{-0.6183136679746976,-0.6011132877560904,0.5063111921326046},
{-0.6633316483079291,-0.7100338765243928,0.2363112746798789},
{-0.6180122831161916,-0.7589150835871808,0.2052040784715898},
{-0.8496799945200408,-0.5181877994118926,0.09759770208915616},
{-0.9578591433895896,0.00929960333387951,-0.28708775453299007},
{-0.9934439658355836,0.01520067272065721,-0.11330501442437249},
{-0.9973982994373493,0.005199991134022675,-0.07189987741081354},
{-0.8527124752747707,-0.3439050313674136,0.39320575264224206},
{-0.19469876658722052,-0.5052967989549179,0.8406946742161082},
{0.8184889218274141,-0.09209875345180799,0.5670923244573324},
{0.13850791110527064,-0.3164180727343511,0.9384536013082019},
{0.535287439627592,-0.17099598762622495,0.8271805904351655},
{-0.10689790161478674,-0.70818609844333,0.6978863006263767},
{-0.2364065946539381,-0.9295259294874597,0.283007894615332},
{-0.27529568615039673,-0.7437883449279517,0.6090904556273398},
{-0.6588118949561461,-0.7154129168968228,0.23270420151228777},
{-0.706577061348049,-0.6983773275480858,0.11409629592387827},
{-0.9668071543994139,-0.059000436604846315,-0.24860183966042024},
{-0.6105897391256503,0.5764903121617055,-0.542990875115015},
{-0.6440867899154068,0.41299152963058994,-0.6438867940172807},
{-0.8264536620422176,0.26828495768412214,-0.49497224768408676},
{-0.9009806966953576,0.14839682063217655,-0.4076912653082101},
{-0.9588188697410365,-0.11520226720292803,-0.2596051090788205},
{-0.9652918288392531,-0.20719824607427043,0.15899865408208977},
{0.4080963985651739,-0.4109963729730126,0.815192805955231},
{0.6728947312548814,-0.22529823592171908,0.7045944830467965},
{0.7625112471238432,0.08080119182636923,0.6419094682344852},
{0.6489128291334493,-0.02300045472348487,0.7605150355308801},
{0.8492256087843552,0.3703111669016095,0.3764113508554302},
{0.8059711266015749,0.3282882392844876,0.4925823535532702},
{0.47936957537854546,-0.4546711429383075,0.7506523576067462},
{0.25479905087530325,-0.7599971690158182,0.5978977728349443},
{-0.39058920231075106,0.06629816721250074,0.9181746174135474},
{-0.7718934929652814,-0.21939815048138714,0.5966949698826057},
{-0.8312021403482671,0.29460075859793006,0.4715012141171895},
{-0.6888007439052052,-0.6462006978971306,0.328600354888575},
{-0.7999874802938993,-0.4872923739340214,0.35009452106361766},
{-0.9448939432492355,-0.27449824047191784,-0.17839885646699505},
{-0.7311561173267175,0.3305801591742517,-0.5967641832885463},
{-0.4337882943808121,0.6816816050700775,-0.5891841010815455},
{-0.5808195245764834,0.402213520634748,-0.707723790535085},
{-0.8102897782589206,-0.21669726638122683,-0.5444931312624735},
{-0.8565701362027928,0.08439705754788199,-0.5090822511567147},
{-0.9029313954704403,0.12660440211159346,-0.4107142807838186},
{-0.8947723832765787,-0.1836943303619887,-0.4069874385265618},
{0.5374309461648459,-0.7648440409878566,0.35522045418264475},
{-0.2987819705459647,-0.9144448194922514,-0.27298352730605213},
{0.6083986098107649,-0.7924981891437066,-0.042399903116332065},
{-0.15839696831103953,-0.03959924207775988,0.9865811170181288},
{-0.09719567051528319,0.08699612484392631,0.9914558365833671},
{-0.4202906402316619,0.17789603829934011,0.8897801848159238},
{-0.16780509799631688,0.42641295462234513,0.8888270029745318},
{-0.04809899329860528,0.1572967078143578,0.9863793552961383},
{0.03439923187372829,0.02569942613822143,0.9990776908442424},
{-0.013199766036220494,0.2039963841961349,0.9788826494588062},
{0.08770391431304564,0.374816728443894,0.9229411917846045},
{-0.021099716949195678,0.4888934415384723,0.8720883010139122},
{-0.2097041920286984,-0.17030340439908126,0.9628192469491217},
{0.25129932274923783,-0.7206980577213516,0.6460982587675389},
{0.13540346231079747,-0.43391109524856003,0.89072277607258},
{0.4462710245630322,-0.5275657462681062,0.7228530666740219},
{0.31390190382082006,-0.17650107048223873,0.9329056580899745},
{0.3243940798620633,0.13329756734159381,0.9364829093428554},
{0.5016880674912204,0.10879741228432285,0.8581795884412304},
{0.5219078208472936,0.16890253102339123,0.8361125292401267},
{-0.1460972431710318,0.1877964563143037,0.9712816720877699},
{-0.7213170990245009,0.2581061184780586,0.6427152357452471},
{-0.8335866877268947,0.26569575687264385,0.48429226591426955},
{-0.9128110268238064,0.09320112587640093,0.3976048030950323},
{0.0012000379938043352,0.34601095488024997,-0.9382297048226895},
{0.38499879688063965,0.31499901562961424,-0.8674972890752076},
{0.7684963304387833,0.27509868640690865,-0.5776972415022578},
{0.40362080718892973,0.44152276108501604,-0.8013413102093394},
{0.06760081594677274,0.5073061232218611,-0.8591103695247406},
{-0.360384193895876,0.33658523769520493,-0.8699618443102445},
{-0.5608233952359085,0.15480645788608888,-0.813333928932533},
{-0.7695837157808593,0.07099849768768322,-0.6345865722901941},
{0.8886876962040186,-0.31199568044970605,0.33599534817660653},
{0.692123238427852,-0.29881003271527545,0.6570220598859973},
{0.868379949338452,-0.31489272921082284,0.38309115452736175},
{0.9499224326831248,-0.007000165310855747,0.31240737758733367},
{0.8132561463446807,-0.19858929136118722,0.5469705054107221},
{0.6368432272011193,-0.3051207107711392,0.7080480603932041},
{0.3076838870167444,-0.3752803470828215,0.8743542112689024},
{0.5948124763225376,-0.20450428952245955,0.7774163064780443},
{0.7113816430335492,-0.054598591101534706,0.700681919136362},
{0.865852818632954,-0.0356021717987216,0.49903044178545164},
{0.7138783055679357,0.02339928890641504,0.6998787310085421},
{0.8265519043439886,-0.28888319037621374,0.48307189086448205},
{-0.2254980945491516,-0.01719985466184216,0.9740917689593284},
{-0.19749609257846215,-0.1445971391739019,0.9695808170333007},
{0.4009976882549908,0.29229831490507185,0.8681949948702818},
{0.3589936027909969,-0.025799540256288913,0.9329833743844015},
{0.6402256959739723,-0.3020121214997495,0.7063283490571957},
{-0.6311807808378308,-0.13109600818732514,0.7644767220382156},
{-0.784651788551983,-0.1891883756773738,0.5903637262152298},
{0.4641225267335158,0.30761493045298305,0.8306403161061371},
{0.4185055870868817,0.17440232828662405,0.8913118990932799},
{0.5862834113455608,-0.36088978876788824,0.7252794785074794},
{-0.9962029985755386,-0.04850014598565913,0.07230021762398259},
{-0.979840384953716,-0.08830363950950512,0.17920738618463553},
{-0.8703227984043103,-0.3354087861482313,0.36060944628816993},
{-0.9537287362797426,-0.27910840966307665,0.11180336868624853},
{-0.6514949411614227,0.06579948906895106,0.7557941312813558},
{-0.10510126069718313,0.16300195522017938,0.9810117673067237},
{-0.4141156828578704,0.24570930518758455,0.8764331911534354},
{-0.621671593365547,0.2842870098018739,0.7298666495054089},
{-0.7597814083764028,0.056898607708103864,0.647684151362722},
{-0.6301978699347994,-0.007599974312130237,0.7763973757813047},
{-0.2669973407197296,0.2193978148086467,0.9383906536756338},
{-0.06629848907465077,-0.06349855288446946,0.9957773064937745},
{0.05910103250405685,0.14600255068684093,0.9875172520770921},
{0.267598466665179,0.2530985497494649,0.9296946728647867},
{0.38777653247436045,0.04719714371529091,0.9205442903452714},
{0.1286972233873578,0.06609857393865075,0.9894786522283648},
{-0.165995733964455,0.10259736328164507,0.9807747944116714},
{-0.5180061902109597,0.08730104325370036,0.8509101684372696},
{-0.8905230336761529,0.00490012674341735,0.4549117664450107},
{-0.7855195989584941,0.18760468079517947,0.5897147135656575},
{-0.8044101517201725,0.14380181479035406,0.5764072743057029},
{-0.8153475606103561,-0.01660096836272772,0.5787337585247309},
{-0.46818545370392667,0.13489580885232744,0.8732728678334881},
{-0.02450153065843184,-0.3445215229318273,0.9384586273417322},
{0.22799258580166262,-0.2501918638928771,0.9409694001726514},
{0.24560468495404866,0.010000190755458008,0.9693184899265447},
{0.43290216018716904,-0.5365026771550385,0.7244036147830567},
{0.5796839835527987,-0.34739040173579827,0.7370796347710331},
{0.5604085070657064,-0.14280216775335988,0.8158123841259872},
{0.30441055409686896,0.01990068996888204,0.9523330179581089},
{0.09980399323765575,0.11150446138275166,0.9887395602612249},
{-0.2784931338364269,0.09349769484275013,0.9558764331570572},
{-0.6703956256828136,0.06449957914161915,0.7391951767672074},
{-0.8870049317611308,0.08320046259585805,0.4542025253730616},
{-0.9838495233121652,-0.07170360929201286,0.1640082555633209},
{-0.9228338270939096,0.1277046811008802,0.36341332115943514},
{-0.9739399031352639,0.05590229036375527,0.21980900575945272},
{-0.8550972594176753,-0.09759968719350383,0.5091983680218457},
{-0.6566256450153588,-0.10530411273243571,0.7468291679827445},
{-0.7682891172617303,0.23299669962512454,0.5961915550064345},
{-0.7509127843989825,0.3933066961035022,0.5305090319931551},
{-0.3161946500317818,0.6971882036753899,0.6433891139482872},
{-0.09690301421513646,0.7517233827194849,0.65232029073822},
{-0.17440462876027174,0.6680177294258115,0.7234191998003474},
{-0.19481162670483299,0.5796345936248521,0.791247223043449},
{0.6826911967537764,-0.20929730112870282,0.7000909723851162},
{0.3859983595104581,0.09969957627770121,0.9170961023498474},
{0.6268734117281004,-0.01989915599519732,0.7788669650582508},
{0.6683176638692873,-0.20760548708553647,0.714318879697489},
{0.8827820532232851,-0.15609682658377297,0.4430909920516964},
{0.7655170329434766,-0.19700438339629642,0.6125136285798556},
{0.4208136682499207,0.088402871371894,0.9028293243726911},
{0.6551019227269649,-0.5466016042780628,0.5216015309027398},
{0.5618012668632851,-0.5896013295524972,0.5803013085809263},
{0.4128101119075383,-0.7131174680263216,0.5666138793769652},
{0.1508974626804974,-0.6160896405397908,0.7730870006513753},
{0.9338013960341306,-0.1356002027224546,0.33110049499561006},
{0.8690118707832328,-0.13920190151096204,0.4748064859008964},
{0.6469888783567708,0.10169825182207663,0.75568700985195},
{0.6174724428198017,0.04899781327638912,0.7850649633325122},
{0.30140594378381774,0.05980117929088354,0.9516187661071033},
{-0.002500025962904438,0.09670100424514365,0.9953103363515148},
{-0.2785852562654579,0.1094942051725328,0.9541495029737973},
{-0.9202202542706972,0.008500187091176838,0.3913086127973525},
{-0.5651809848056439,-0.04049863744626429,0.8239722779190561},
{-0.327299808529668,0.5657996690072905,0.7567995572723886},
{-0.13859742141896153,0.552089728466152,0.8221847033958888},
{-0.44529025047669757,0.2020955751658221,0.8722809016187363},
{-0.7825151692035839,-0.14830287487909455,0.6047117224503606},
{-0.8518754961537747,0.15139564516689927,0.5013855778512766},
{0.5688072438063752,-0.5122065229916057,0.6435081951290478},
{0.43781251286042894,-0.30700877443616187,0.8450241511353641},
{0.7075161103252503,-0.2205050209564914,0.6714152883001738},
{0.6462917630639693,-0.39879491739116657,0.650591708261517},
{0.9622485514755279,0.13830697845465134,0.23441182754714585},
{-0.42390342091441024,0.0004000032280390755,0.9057073090874767},
{0.35592063331718743,0.24491419808760664,0.9018522818922159},
{0.8853176091423705,0.2582051357512256,0.3867076916924824},
{0.604297480084762,-0.33089862015563093,0.7247969776029051},
{0.27559009822565295,-0.5060818168069774,0.8172706359935638},
{0.9754777447291281,0.05429876118789508,0.21329513372703537},
{0.9744775385516016,0.1363968560887003,0.17829589032709137},
{0.9789694321567138,0.20389363352068843,0.006799787679944489},
{-0.7845673587540443,-0.3546852436274019,-0.5085788410174701},
{-0.7202331170801025,0.2860131511870443,-0.6320290613643776},
{-0.7118958247432318,0.21239875428495916,-0.669396074003539},
{0.4854068588473736,0.42630602374667365,-0.7633107856576026},
{0.7173928619765348,0.38669615239242544,-0.5794942340610565},
{-0.6637754208512403,0.13809488644103088,0.7350727807588834},
{0.2091978902499152,-0.5406945471229883,0.8147917828663045},
{-0.7067622811035593,-0.33208227724178274,0.6246666624298154},
{-0.8641147159989213,-0.3793064596440121,0.33080563366791244},
{-0.964008652016478,-0.1318011829209251,0.23090207235539914},
{-0.6934043129882402,-0.6936043142322519,0.1952012141553281},
{0.39608735313271853,-0.8935714687184985,-0.21129325351412123},
{0.7231967528538695,-0.6856969212277356,-0.0824996295774948},
{0.6086881398271421,-0.6941864739083325,-0.38419251408179395},
{0.8834397998594956,-0.4135186294338934,0.22030992518569945},
{0.8757958793900812,-0.34759836455354215,-0.3348984243066204},
{0.9816691858878749,0.04249866598781164,-0.18579416801259768},
{0.8376988355994278,0.3904994572061318,-0.3817994692991065},
{0.7491027492121345,0.5692020889754998,-0.3389012437698469},
{0.940522525784242,-0.08390200947719076,-0.32920788462325623},
{0.8581923621219655,0.33839698828020637,-0.3859965646458619},
{0.6423184380153987,0.24530704163969685,-0.7261208435979776},
{0.037700436762089846,-0.10730124309210187,-0.9935115098975137},
{-0.3970994083223224,-0.21639967756472064,-0.8918986710719701},
{-0.6078256386261672,0.019400818343776976,-0.7938334846025856},
{-0.4919922757819048,-0.00479992464177468,-0.8705863319018827},
{-0.6681239626956408,-0.0279010006873348,-0.7435266670621299},
{-0.8907239340736671,-0.18960509475734508,-0.41311110044440535},
{0.7701519908650242,-0.2253152104166861,0.5967402843126346},
{0.6984883039112756,-0.21299643340458368,0.6831885601033407},
{0.8435019189690485,-0.19520044408151543,0.5004011384138848},
{0.9363013342303519,-0.15750022443797973,0.3139004473084561},
{0.9392209777348092,-0.06900154116663312,0.3363075115121553},
{0.819833687658353,0.031701302633288346,0.5717234926009763},
{0.13390236875385506,0.35450627127140866,-0.9254163707603994},
{0.5426972485319248,0.23009883340187195,-0.8077959044851463},
{0.7068057781608548,0.4115033640537517,-0.5754047039526823},
{0.19759827991446,0.8725924041161831,-0.4466961115272737},
{0.22349395457029222,0.926774931077167,-0.30189183393633656},
{-0.20050388379784412,0.6590127652008941,-0.7249140417209835},
{-0.07989976229856073,0.8936973412543646,-0.4414986865433613},
{0.28121231596307233,0.894939194720318,-0.3464151715846666},
{-0.5570023672650913,0.0035000148750948287,0.8305035296475015},
{-0.5128175053243215,0.08550291869194518,0.8542291596100534},
{-0.6759409294624559,0.23031394593165203,0.7000423888500061},
{-0.07299900430037196,0.5087930601099898,0.8577882998473845},
{-0.45429583412630153,0.1603985291522315,0.876291964439529},
{0.8924213603608934,-0.4389105054486734,-0.10460250369088912},
{0.03180118286699552,-0.9971370892038123,-0.06860255171936767},
{-0.7424582378986443,-0.6359642280182327,-0.21048816037395907},
{0.17239973795259747,-0.529199195617834,-0.8307987371868792},
{0.3418096579683308,-0.07800220398341078,-0.936526461929028},
{-0.09980119911861116,0.754809069085448,-0.6483077894648859},
{0.4223806364035759,0.6451704228399318,-0.6366708124956364},
{0.16240763658661267,0.4272200883608432,-0.8894418225377666},
{0.7979932889046604,0.1280989226925902,-0.5888950474134768},
{0.8215850596115353,0.23589571027551262,-0.5189905622424377},
{0.7575130103976813,0.3102053278222584,-0.5744098655741626},
{0.9809366828131436,-0.1386051832377426,0.13620509348470808},
{0.17130144065117384,0.46100387705890916,-0.8707073226793758},
{0.7185074329978418,0.5135053122399328,-0.46910485291480525},
{-0.4041184383243825,0.3215146694414476,-0.8563390713614667},
{-0.43879927817578107,0.498399180134023,-0.747698770036535},
{-0.5927722677981614,0.39868134812943146,-0.6997672621544422},
{-0.2316036686311669,0.6976110502465546,-0.6780107397751778},
{-0.3549010540576958,0.5151015298538155,-0.7802023172043231},
{-0.9100950809493812,-0.24959865092293762,-0.33079821204049586},
{-0.9117028308416846,-0.3637011292937597,0.1911005933682636},
{-0.5616053886295559,-0.056000537327733496,0.8255079207865},
{-0.7109872307840017,-0.30339455108279345,0.6343886064829405},
{-0.1989045887817954,-0.5649130326939981,0.8008184750953331},
{-0.7006291432753344,-0.4374181947882262,0.5637234485645247},
{-0.8241963529392073,-0.4910978268969239,0.2819987521582825},
{-0.8885661373897439,0.17249342640077742,0.4250838003650463},
{-0.8214123212772294,0.3910058651319658,0.4152062281401335},
{-0.8895924118090907,0.3678968618531525,0.2706976909585441},
{-0.9725781901786251,0.17799600848426408,0.1496966430904176},
{-0.8416992130116038,0.23669977868581038,0.4852995462451364},
{0.27150984919842275,-0.5784209826017227,0.7692279042483491},
{0.5669257531872711,-0.4627210195797325,0.6815309592470017},
{-0.2587060085168225,-0.4435103006463502,0.8581199300668164},
{0.06360028683794047,-0.146900662523482,0.9871044518511168},
{0.47278842391715886,-0.0592985480928247,0.8791784735786083},
{0.8211622520388907,-0.00489977476253113,0.5706737667299012},
{0.874304992295759,-0.07400042254361909,0.4797027391104605},
{0.9508181180118597,-0.07900150538802789,0.2995057071356247},
{0.9816490586438683,-0.09369513781698122,0.1660913809114256},
{0.9285806485809234,0.2105956112331924,0.3055936314950788},
{0.37169951307395677,-0.4821993683192412,0.7932989607790419},
{0.9531226559948027,-0.23270553147622558,-0.19340459728191672},
{-0.7941774615634567,0.03659896133621571,-0.606582785424821},
{0.252811321144447,-0.9662432693424234,0.049602221237201614},
{-0.9471858633564834,-0.31949523156925297,0.027599588079221853},
{-0.8382892280526288,-0.2658965832508577,-0.4759938835178949},
{0.8003106201923953,-0.1116014809614786,-0.5891078175126079},
{0.9824938594325677,0.10319935500604681,-0.15509903063408778},
{-0.7294758912201863,-0.6816774709318725,0.0563981360724037},
{-0.7669497728205632,-0.3154204698756104,-0.5588362668563446},
{-0.2713111538308057,0.33031357947038376,0.9040371657318406},
{-0.027799398288535993,0.5657877536566066,0.8240821629346228},
{-0.03340117557506191,0.3878136493415871,0.9211324198260338},
{-0.12030005413503654,-0.3970001786501206,0.9099004094552764},
{0.4745840400070973,0.7530746745245364,0.4556846755820359},
{0.6253196290912406,0.7703241808555615,0.12480391765646381},
{-0.4202802683045938,0.2249894369938939,0.8790587291614761},
{0.7421274369585259,0.3442127257797125,-0.5751212626261262},
{0.6579894558034555,0.46969247323842406,-0.5885905679117233},
{0.18559467722098485,-0.9809718661303133,-0.05699836531032402},
{-0.9570286490814217,0.20480613096329697,0.20530614593146906},
{-0.8422447707107122,0.4007213009068896,0.36061916922142345},
{0.39611073078504744,-0.4335117439922193,0.8094219275370296},
{0.8676277601942882,0.27000863906461253,0.41751335855361377},
{-0.6325058886572352,0.13720127734983822,0.7623070971121113},
{-0.1886979894336338,-0.3328964530071897,0.9238901560028314},
{0.8683970127194144,-0.01639994358429111,0.4955982951447971},
{0.9977893985439603,-0.02959968550501225,0.0594993678225753},
{0.1775034844275993,-0.24930489390310145,0.952018688310279},
{0.4206168649713083,-0.7269291468084736,0.5428217648750027},
{0.5207832284461876,0.7203768006386972,0.4580852476021477},
{-0.3087028076648036,0.10260093315973065,0.9456086003493305},
{0.8931188182117517,0.09530200803446415,0.43960926266474754},
{0.7021009513474336,0.07420010054120435,0.7082009596129505},
{-0.8372448398481294,0.31971712290903836,0.4436237589066294},
{-0.19919642047248584,-0.127097716074563,0.9716825390216592},
{-0.7465011869378309,0.04440007059616837,0.6639010556035176},
{-0.6635931882508836,-0.5128947351625652,0.5445944097670754},
{0.746108494493565,-0.6351072307369832,-0.19990227590036674},
{-0.05779994682407337,-0.9827990958252476,0.17539983863222267},
{-0.9345308680643666,-0.031201030587060714,0.354511709715161},
{-0.9334919113276324,-0.16419857722549253,0.31879723763390383},
{-0.9228683507726061,0.3286887278133661,0.20069311734755882},
{-0.9073377369612367,0.2993124486636153,0.2952122781339767},
{-0.03509970130281287,0.44949617480382864,0.892592404070962},
{0.06499964380292794,0.06139966353076578,0.995994541964865},
{0.543189350877163,0.3815925189519982,0.7478853378516757},
{0.06489836295944126,0.8911775203305708,0.44898867440353046},
{-0.5699066081054317,0.6918080215605152,0.4434051413124205},
{-0.20920210458375824,0.6690067302415595,0.7132071749002694},
{0.14459666274753522,0.3209925915764786,0.9359783978678629},
{0.18030583028328484,0.5182167568097515,0.8360270333711931},
{0.5047003154377957,0.45750028593776804,0.7321004575629289},
{0.15490490591605677,0.5413171437854198,0.8264261733313707},
{0.09470349130856183,0.9843362882261605,0.14870548212864987},
{0.5728014062291784,0.802501970144755,0.16700040998650978},
{0.4360965744748613,0.8944929737852864,0.09849922629161623},
{0.3529999329300191,0.8632998359730467,0.36069993146701956},
{0.5042024000091361,0.5230024894977751,0.6872032710953557},
{0.6793004823035137,0.6295004469454759,0.3772002678122852},
{0.7802908472420425,0.6248926700519702,-0.025599699717283465},
{0.7378915954625912,0.6740923221321761,0.03339961958049945},
{0.9148715204928437,0.2492922396533675,0.31759011357364425},
{0.6803120450313869,0.6007106356759578,0.419907434526943},
{0.5890680115301772,0.7247606429418986,0.3573805929738335},
{0.042498394865938295,0.9272649778631666,0.37198595035597753},
{0.8097223364987327,-0.5793159806517425,-0.09350257930422566},
{0.8432805330935876,-0.5137881393377035,0.15779635731313663},
{-0.4034997800926798,-0.679999629400303,0.6121996663512728},
{-0.7350307028737019,0.07450311205998747,0.6739281505667861},
{-0.38709922967329935,0.38589923206129223,0.8373983335789741},
{0.10350098429904103,-0.3748035643988462,0.9213087616879856},
{0.4257166692625339,-0.8394328686374699,0.3378132273358796},
{0.9570636561977208,0.08449679129527471,0.2772894701323038},
{0.9632618844813317,0.1412944090908462,0.22839096274840248},
{0.9946955785879797,-0.003599983998106692,0.10279954305704667},
{0.9874816873219113,0.12279772273734756,0.0989981640960701},
{0.915393020154832,0.40249693097260203,-0.0071999451006279115},
{0.888074450465585,0.3812890304723877,-0.25679261218281974},
{0.8577944715324464,-0.363797655331667,-0.3630976598431234},
{0.3278933012082838,-0.9413807677873692,-0.07929837995064624},
{-0.05099791167827428,-0.9986591057469123,0.00889963556738512},
{-0.6881036503995481,-0.7247038445640932,-0.0363001925730324},
{-0.8433023148680315,-0.5131014084652994,0.15990043892730726},
{-0.35590300739311875,-0.9098076879074444,0.21350180409786695},
{-0.39472001478578744,-0.8921452373711705,0.2197111407358437},
{0.6844343286646529,-0.18680936965890876,0.704735346887757},
{0.7592750772046295,0.5995803190990331,0.2529916956838816},
{0.34269175664893947,0.38289078967283025,0.8578793639600968},
{0.9136674466088056,0.1565944206401871,0.37508663590124003},
{0.9848322587089596,-0.05080166403575868,0.16590543432150323},
{0.9928033705731646,0.08240027974942463,0.08690029502700243},
{0.9321413413852561,0.34601534612090823,-0.10670473245982921},
{0.920591051898463,0.35879651251484745,-0.1541985011978525},
{0.9058403787348431,0.19890886656034476,-0.3740166721647509},
{0.8412926261024483,0.42599626615909064,-0.3327970830463506},
{0.6777912429937103,-0.6217919664996888,-0.39239493029025074},
{0.12670168641066926,-0.9905131838182155,-0.05320070810613736},
{0.003800083488751382,-0.9961218850382241,-0.08790193122664382},
{-0.5066184893791611,-0.8421307341219729,0.18480674464522098},
{-0.7625771916572912,-0.6294811724996916,0.14909554061906916},
{-0.9807074435977454,-0.14920113244089286,0.126300958627914},
{-0.987041269058207,-0.15870663566315854,0.023700990959148436},
{-0.9825839348839959,-0.10049835686529776,0.15629744455767203},
{-0.9691443442139774,0.01180053994605813,0.2462112656541959},
{-0.9381522633365893,-0.005299730330083056,0.34618238495750076},
{-0.8914060927814663,0.4026027517992129,0.20810142237808296},
{-0.8762395455830584,-0.13790622384832657,0.4617208379316344},
{0.14360648541532534,0.6774305934564163,0.7214325806310286},
{-0.4853955125392298,0.8061925467843574,0.3382968724598711},
{-0.9526396877961075,0.16960706597755598,0.252410515641127},
{-0.5967062475471179,0.327903433166918,0.7324076683484316},
{-0.7361248593562578,0.2645089326174843,0.6230210397757759},
{-0.9927795638430154,0.03129935570939402,0.11579761633060151},
{-0.9810097709059775,-0.05220051991976762,0.18680186055579676},
{-0.5097206288112806,0.14440584422277594,0.8481343246906944},
{0.05300096462633437,-0.14080256262996,0.9886179930112107},
{-0.37639052825153335,0.7428813056271629,0.5535860691818514},
{0.25800783710708003,0.7831237877463347,0.5658171869580847},
{0.4122959883795495,0.24889757823834557,0.8763914727524549},
{0.49769774543431977,0.7788964716069755,0.3815982713637461},
{0.36449880080091807,0.5187982931564233,0.7732974558555554},
{0.6225064398624308,-0.6095063053753439,-0.4909050784393048},
{0.05129930797700305,-0.997986537252418,-0.03729949683318156},
{0.5981057837108928,-0.590705712151855,-0.5416052373479678},
{0.7241014119991301,0.3315006464268908,-0.6048011793634497},
{0.4238989127006834,-0.6635982978725489,-0.6163984189400831},
{0.2265937030484872,-0.6480819900517412,-0.7270797947332526},
{-0.07340248508319946,-0.9972337619205245,-0.011700396123616261},
{-0.032498659295465575,-0.9994587681790105,-0.005099789612519213},
{-0.01319967601792816,-0.9828758756076961,0.18379548879509058},
{0.27760948330192714,-0.8036274523826681,0.526417982745441},
{0.7942078468122901,-0.580805738389043,-0.17860176459415136},
{0.8467733355274898,0.3992874266368997,-0.35148893178780427},
{0.7430195862544439,0.08980236722160034,-0.6632174826432667},
{0.5302084489389514,0.19970318229556502,-0.8240131307538586},
{0.06219687095413146,0.252287307744813,-0.9656514192991119},
{-0.10409902876059246,-0.7343931481438916,-0.6706937424565741},
{-0.6986311701249982,-0.6580293586347679,-0.2809125331922588},
{-0.2504923676138364,-0.9562708628707057,0.15099539924027663},
{-0.6220973280977137,-0.7812966443381187,0.05069978224490289},
{-0.3919074286757165,-0.7892149597113433,0.4728089621788179},
{0.057699172888284925,-0.8346880348327803,0.547692148889318},
{0.319213962724101,-0.5698249246873207,0.7572331221011569},
{0.13579348342709174,-0.8974569320752197,0.41967986004676294},
{0.737982786752246,-0.5507871530394812,0.38989090590067854},
{0.9430155127327777,0.32570535789720645,0.0681011202726428},
{0.9086409942632052,0.3150142121867815,-0.27411236685840257},
{0.8495803919108295,0.2741936716830855,-0.4505896005120289},
{0.6153915568857589,-0.13719811765473858,-0.7761893507551609},
{0.4211119744892443,0.06840194503696108,-0.9044257177109298},
{-0.120502220273863,0.18290337002563936,-0.9757179777693621},
{-0.5609966648847409,-0.1999988110106028,-0.8032952244240862},
{-0.8314611467283988,-0.23998878558606818,-0.5010765852382448},
{-0.9995921782218081,-0.028499776990117576,0.0017999859151653205},
{-0.9571159552559623,-0.17350289231732258,0.23200386753670804},
{-0.8950979188997579,-0.04079990514033083,0.44399896770360014},
{-0.5791836382933241,-0.6518815846053487,0.4894861722109498},
{0.22119590791355506,-0.9215829508731118,0.3189940986637616},
{0.14319731650743273,-0.9879814854004436,0.058198909362657716},
{0.041998203145316826,-0.9093610938178838,0.4138822924249198},
{0.08079897789939432,-0.9620878296659315,-0.2604967047375275},
{0.6931321412826043,-0.7162332125041135,-0.08110376086858924},
{0.9900651057702599,-0.114795954087896,0.08119713825729229},
{0.931261306896531,-0.20459149939979623,-0.3014874734557115},
{0.7482325712727568,0.09410409644047903,-0.6567285880176682},
{0.2953155561566416,0.129006795611943,-0.9466498660950794},
{-0.9427875882830999,-0.011499848605489658,-0.3331956135086221},
{-0.5856948195522316,0.16579853351845653,-0.793392982470105},
{-0.9627147729715377,-0.09810150537915016,0.2521038685635449},
{-0.9470133056304169,-0.27430385399622315,0.1671023478044801},
{-0.954017873692297,-0.03820071569711294,0.29730557007203345},
{-0.9406743669727453,0.10239720971405243,0.3234911849853121},
{0.9538891018792662,0.20419766705498077,-0.2199974865430743},
{0.8645962779210352,0.217199064960038,-0.4530980494170958},
{0.8766183127478319,0.06250130566591318,-0.47710996693131486},
{0.9321172117032227,0.11650215123208395,-0.34290633182387625},
{0.8841310291229602,0.33741184167637905,-0.3232113433011432},
{0.7288767819999082,-0.6150804069257011,-0.30069042165917464},
{0.7833665431293991,-0.48147943645239427,-0.39308321177453004},
{-0.4314994239486536,-0.9020987956989117,-0.0050999931915136345},
{-0.8230133781911946,-0.5068082382348693,0.2565041695091633},
{-0.8761330045519339,-0.39641493323180754,0.2743103334648961},
{-0.9164251058096652,-0.3125085612893064,0.2500068490314451},
{-0.955316288281574,-0.15100257461584599,0.2541043325158044},
{-0.946489801627331,-0.22609756381187485,0.23029751855760627},
{-0.9175715465475055,-0.21489333626096221,0.334489627637468},
{-0.8441873499473409,0.30719539671147017,0.43929341723746373},
{-0.8323369982018733,0.12910573887764248,0.5390239601475546},
{-0.9785755310247662,-0.03379915486269885,0.20309492167497448},
{-0.9530575231727672,-0.0012999420628733577,0.3027865051061944},
{-0.944119085560224,-0.1610032547136914,0.28760581401029595},
{-0.9192250538202675,-0.2118057728450094,0.3319090463043372},
{0.21061061398934472,0.5237263938566944,0.8254415991776122},
{-0.6400216811016772,0.1949066025729951,0.7432251771793226},
{-0.4816147858008896,0.571017530507284,0.6648204102998991},
{-0.4269956681509198,0.7851920342672184,0.448495450036739},
{0.47229358393524307,-0.4617937265748364,-0.750789800589838},
{0.9048524919670811,-0.18999002483561211,-0.380979997170359},
{0.9438114720981655,0.06660080953775994,-0.32370393464523856},
{0.0718988571767477,0.2416961582700962,0.9676846187752258},
{0.6346314118591142,0.43372146757531954,0.6396316593524888},
{0.7138391587211069,0.6063332613233499,0.35041922277371235},
{0.9247966522421782,0.27719899654144875,-0.26059905663312244},
{0.9389933331710015,0.2437982690384347,-0.24259827755834398},
{0.9347861232030009,0.065099033612019,-0.3491948162414291},
{0.8914747983636704,0.3889890034363071,-0.23229343315746567},
{0.86782294120268,0.33980898296919876,-0.36250958306749426},
{0.8955967176440448,-0.30259889097709686,-0.32609880485007037},
{-0.8291184978400326,0.45011004206705907,0.33160739824358315}
};


// face array: 58kb.
const uint16_t dennis_face[29762] PROGMEM = {
8, // chain 0
0,0,0, 1,1,1, 2,2,2, 
3,3,3, 32772,4,4, 5,5,5, 32774,6,6, 7,7,7, 8,8,8, 32777,9,9, 
8, // chain 1
10,10,10, 3,3,3, 11,11,11, 
12,12,12, 32781,13,13, 32782,14,14, 32783,15,15, 32776,8,8, 32773,5,5, 32771,3,3, 
18, // chain 2
16,16,16, 17,17,17, 18,18,18, 
32787,19,19, 20,20,20, 32789,21,21, 22,22,22, 23,23,23, 32792,24,24, 32793,25,25, 26,26,26, 32795,27,27, 28,28,28, 32797,29,29, 32798,30,30, 32793,31,25, 22,32,22, 31,33,31, 32,34,32, 
32801,35,33, 
27, // chain 3
34,36,34, 35,37,35, 36,38,36, 
37,39,37, 32806,40,38, 32807,41,39, 32781,13,13, 32780,12,12, 32808,42,40, 32803,37,35, 41,43,41, 32810,44,42, 32811,45,43, 32802,36,34, 44,46,44, 32813,47,45, 32805,39,37, 46,48,46, 32815,49,47, 
32816,50,48, 32806,40,38, 49,51,49, 32818,52,50, 32819,53,51, 32820,54,52, 32821,55,53, 32807,41,39, 54,56,54, 32823,57,55, 
3, // chain 4
56,58,56, 57,59,57, 1,1,1, 
32826,60,58, 32827,61,59, 
3, // chain 5
0,0,0, 60,62,60, 61,63,61, 
56,58,56, 1,1,1, 
5, // chain 6
54,56,54, 16,16,16, 18,18,18, 
52,54,52, 32830,64,62, 32791,23,23, 32788,20,20, 
6, // chain 7
51,53,51, 52,54,52, 29,29,29, 
63,65,63, 32798,30,30, 32,34,32, 51,53,51, 32818,52,50, 
1, // chain 8
64,66,64, 16,16,16, 54,56,54, 
8, // chain 9
65,67,65, 66,68,66, 67,69,67, 
68,70,68, 32837,71,69, 32838,72,70, 32839,73,71, 32840,74,72, 32841,75,73, 32834,68,66, 
3, // chain 10
28,28,28, 52,54,52, 62,64,62, 
24,24,24, 32791,23,23, 
1, // chain 11
13,13,13, 14,14,14, 39,41,39, 
11, // chain 12
74,76,74, 75,77,75, 76,78,76, 
77,79,77, 32846,80,78, 32847,81,79, 32843,77,75, 80,82,80, 69,71,69, 32769,1,1, 32770,2,2, 32849,83,81, 32850,84,82, 
3, // chain 13
58,60,58, 59,85,59, 68,70,68, 
69,71,69, 1,1,1, 
4, // chain 14
40,42,40, 41,43,41, 83,86,83, 
84,87,84, 85,88,85, 32854,89,86, 
1, // chain 15
28,28,28, 29,29,29, 52,54,52, 
4, // chain 16
40,42,40, 85,88,85, 12,12,12, 
32778,10,10, 32768,0,0, 32828,62,60, 
2, // chain 17
70,72,70, 71,73,71, 79,81,79, 
69,71,69, 
1, // chain 18
3,3,3, 10,10,10, 0,0,0, 
1, // chain 19
59,85,59, 87,90,87, 68,70,68, 
1, // chain 20
88,91,88, 77,79,77, 78,80,78, 
1, // chain 21
52,54,52, 53,55,53, 54,56,54, 
1, // chain 22
28,28,28, 24,24,24, 26,26,26, 
5, // chain 23
89,92,89, 90,93,90, 91,94,91, 
92,95,92, 32861,96,93, 94,97,94, 32863,98,95, 
5, // chain 24
96,99,96, 97,100,97, 98,101,98, 
99,102,99, 32868,103,100, 32858,93,90, 32869,104,101, 
18, // chain 25
102,105,102, 90,93,90, 89,92,89, 
103,106,103, 32872,107,104, 32860,95,92, 94,97,94, 105,108,105, 32874,109,106, 107,110,107, 108,111,108, 32877,112,109, 32878,113,110, 32879,114,111, 112,115,112, 32881,116,113, 32882,117,114, 32883,118,115, 32884,119,116, 
32885,120,117, 
28, // chain 26
118,121,118, 119,122,119, 120,123,120, 
121,124,121, 32890,125,122, 32891,126,123, 32892,127,124, 32887,122,119, 125,128,125, 32894,129,126, 32895,130,127, 32896,131,128, 32897,132,129, 32898,133,130, 32899,134,131, 32886,121,118, 132,135,132, 32901,136,133, 32902,137,134, 
32889,124,121, 122,125,122, 135,138,135, 32904,139,136, 32905,140,137, 32891,126,123, 138,141,138, 32907,142,139, 32894,129,126, 32893,128,125, 32892,127,124, 
8, // chain 27
114,117,114, 115,118,115, 140,143,140, 
141,144,141, 32910,145,142, 32911,146,143, 32912,147,144, 32913,148,145, 32884,119,116, 32883,118,115, 
25, // chain 28
146,149,146, 147,150,147, 148,151,148, 
149,152,149, 32918,153,150, 32919,154,151, 32920,155,152, 32915,150,147, 153,156,153, 32922,157,154, 32923,158,155, 32924,159,156, 32914,149,146, 96,99,96, 32917,152,149, 157,160,157, 32894,129,126, 32907,142,139, 32918,153,150, 
138,141,138, 32926,161,158, 32927,162,159, 32928,163,160, 32871,106,103, 32919,154,151, 153,156,153, 32920,155,152, 
2, // chain 29
132,135,132, 161,164,161, 130,133,130, 
131,134,131, 
22, // chain 30
112,115,112, 113,116,113, 162,165,162, 
163,166,163, 32932,167,164, 32933,168,165, 32934,169,166, 32935,170,167, 32936,171,168, 32881,116,113, 114,117,114, 167,170,167, 32909,144,141, 135,138,135, 32902,137,134, 32937,172,169, 32910,145,142, 133,136,133, 32911,146,143, 
132,135,132, 32929,164,161, 32912,147,144, 170,173,170, 32913,148,145, 
4, // chain 31
155,158,155, 96,99,96, 99,102,99, 
102,105,102, 32868,103,100, 90,93,90, 
6, // chain 32
171,174,171, 172,175,172, 173,176,173, 
161,164,161, 32898,133,130, 32897,132,129, 32940,175,172, 174,177,174, 
14, // chain 33
135,138,135, 136,139,136, 175,178,175, 
167,170,167, 32944,179,176, 32945,180,177, 32946,181,178, 32904,139,136, 179,182,179, 32948,183,180, 32949,184,181, 32950,185,182, 32951,186,183, 32905,140,137, 158,161,158, 32906,141,138, 
14, // chain 34
184,187,184, 185,188,185, 186,189,186, 
187,190,187, 32956,191,188, 32931,166,163, 189,192,189, 32958,193,190, 32932,167,164, 103,106,103, 32928,163,160, 32933,168,165, 191,194,191, 32934,169,166, 176,179,176, 32935,170,167, 
4, // chain 35
128,131,128, 192,195,192, 127,130,127, 
32961,196,193, 126,129,126, 32925,160,157, 
4, // chain 36
158,161,158, 160,163,160, 191,194,191, 
180,183,180, 32945,180,177, 32944,179,176, 
10, // chain 37
112,115,112, 163,166,163, 186,189,194, 
110,113,110, 32877,112,109, 32953,188,185, 184,187,184, 108,111,108, 32955,190,187, 194,197,195, 32957,192,189, 32956,191,188, 
1, // chain 38
116,119,116, 117,198,117, 145,148,145, 
5, // chain 39
104,107,104, 105,108,105, 108,111,108, 
194,197,195, 189,192,189, 190,193,190, 103,106,103, 
3, // chain 40
182,185,182, 183,186,183, 181,184,181, 
32926,161,158, 180,183,180, 
2, // chain 41
170,173,170, 172,175,172, 171,174,171, 
161,164,161, 
3, // chain 42
154,157,154, 155,158,155, 102,105,102, 
103,106,103, 153,156,153, 
1, // chain 43
160,163,160, 158,161,158, 159,162,159, 
2, // chain 44
179,182,179, 180,183,180, 177,180,177, 
178,181,178, 
1, // chain 45
195,199,196, 128,131,128, 129,132,129, 
1, // chain 46
134,137,134, 169,172,169, 133,136,133, 
1, // chain 47
156,159,156, 96,99,96, 155,158,155, 
6, // chain 48
196,200,197, 197,201,198, 198,202,199, 
199,203,200, 32968,204,201, 32969,205,202, 202,206,203, 32971,207,204, 
27, // chain 49
204,208,205, 205,209,206, 206,210,207, 
207,211,208, 32976,212,209, 32977,213,210, 32973,209,206, 210,214,211, 32979,215,212, 32980,216,213, 32981,217,214, 32982,218,215, 32983,219,216, 32972,208,205, 216,220,217, 32985,221,218, 32975,211,208, 218,222,219, 32976,212,209, 
219,223,220, 32988,224,221, 32977,213,210, 221,225,222, 32990,226,223, 32978,214,211, 223,227,224, 32979,215,212, 224,228,225, 32980,216,213, 
11, // chain 50
225,229,226, 226,230,227, 227,231,228, 
228,232,229, 32997,233,230, 32998,234,231, 32999,235,232, 32994,230,227, 232,236,233, 233,237,234, 33002,238,235, 235,239,236, 33004,240,237, 
38, // chain 51
237,241,238, 238,242,239, 212,216,213, 
239,243,240, 32981,217,214, 240,244,241, 32982,218,215, 241,245,242, 33010,246,243, 33011,247,244, 33012,248,245, 33013,249,246, 32983,219,216, 246,250,247, 32984,220,217, 247,251,248, 33016,252,249, 33017,253,250, 32985,221,218, 
250,254,251, 33019,255,252, 32967,203,200, 32986,222,219, 196,200,197, 32987,223,220, 252,256,253, 33021,257,254, 33022,258,255, 33023,259,256, 32988,224,221, 256,260,257, 33025,261,258, 32989,225,222, 258,262,259, 33027,263,260, 
32990,226,223, 260,264,261, 32991,227,224, 261,265,262, 32992,228,225, 
29, // chain 52
262,266,263, 263,267,264, 264,268,265, 
265,269,266, 33034,270,267, 33035,271,268, 33036,272,269, 33031,267,264, 269,273,270, 33038,274,271, 33039,275,272, 33030,266,263, 238,276,239, 33040,277,273, 33033,269,266, 224,278,225, 33041,279,274, 33042,280,275, 33034,270,267, 
275,281,276, 33044,282,277, 33045,283,278, 33046,284,279, 33047,285,280, 33035,271,268, 280,286,281, 33049,287,282, 33050,288,283, 33051,289,284, 33037,273,270, 33036,272,269, 
15, // chain 53
284,290,285, 285,291,286, 286,292,287, 
287,293,288, 33046,284,279, 33045,283,278, 33053,291,286, 288,294,289, 33057,295,290, 33052,290,285, 290,296,291, 33059,297,292, 33060,298,293, 33055,293,288, 293,299,294, 33047,285,280, 33046,284,279, 
13, // chain 54
294,300,295, 253,301,254, 254,302,255, 
275,281,276, 33063,303,296, 33023,304,256, 296,305,297, 297,306,298, 33066,307,299, 33067,308,300, 33024,309,257, 300,310,301, 258,311,259, 259,312,260, 298,307,299, 
3, // chain 55
197,201,198, 196,200,197, 252,256,253, 
301,313,302, 33021,257,254, 
25, // chain 56
302,314,303, 303,315,304, 237,316,238, 
304,317,305, 305,318,306, 306,319,307, 33075,320,308, 308,321,309, 309,322,310, 302,314,303, 33071,315,304, 33078,323,311, 33079,324,312, 312,325,313, 33081,326,314, 282,288,283, 283,289,284, 314,327,315, 33037,273,270, 
270,274,271, 315,328,316, 33084,329,317, 33039,275,272, 317,330,318, 33006,276,239, 318,331,319, 33005,332,238, 
5, // chain 57
281,287,282, 282,288,283, 313,333,314, 
319,334,320, 33079,335,312, 308,336,309, 33077,337,310, 
6, // chain 58
318,331,319, 237,316,238, 303,315,304, 
316,329,317, 33083,328,316, 33078,323,311, 314,327,315, 33080,325,313, 
15, // chain 59
320,338,321, 321,339,322, 246,250,247, 
247,251,248, 322,340,323, 33016,252,249, 323,341,324, 33092,342,325, 32996,232,229, 33093,343,326, 33094,344,327, 33017,253,250, 327,345,328, 33096,346,329, 33018,254,251, 329,347,330, 33019,255,252, 
4, // chain 60
235,239,236, 275,281,276, 276,282,277, 
233,237,234, 33056,294,289, 33045,283,278, 
4, // chain 61
279,285,280, 280,286,281, 293,299,294, 
33098,348,331, 33087,334,320, 33049,287,282, 
9, // chain 62
331,349,332, 297,306,298, 298,307,299, 
260,350,261, 261,351,262, 224,278,225, 332,352,333, 33041,279,274, 295,303,296, 33042,280,275, 275,281,276, 
2, // chain 63
294,300,295, 333,353,334, 301,354,302, 
253,301,254, 
22, // chain 64
334,355,335, 307,356,308, 305,357,306, 
335,358,336, 33104,359,337, 33072,360,305, 337,361,338, 33005,241,238, 239,243,240, 338,362,339, 33008,244,241, 339,363,340, 33009,245,242, 242,246,243, 340,364,341, 33109,365,342, 33011,247,244, 342,366,343, 33111,367,344, 
33012,248,245, 344,368,345, 33013,249,246, 321,339,322, 33014,250,247, 
11, // chain 65
345,369,346, 342,366,343, 346,370,347, 
347,371,348, 33116,372,349, 33117,373,350, 33118,374,351, 33089,339,322, 33112,368,345, 33119,375,352, 33110,366,343, 343,367,344, 344,368,345, 
13, // chain 66
352,376,353, 289,295,290, 290,296,291, 
353,377,354, 33122,378,355, 33059,297,292, 334,355,335, 33123,379,356, 33060,298,293, 293,299,294, 330,348,331, 319,334,320, 308,336,309, 307,356,308, 334,355,335, 
9, // chain 67
334,355,335, 356,380,357, 357,381,358, 
354,378,355, 33121,377,354, 33126,382,359, 33124,380,357, 341,365,342, 33127,383,360, 33103,358,336, 33102,355,335, 
7, // chain 68
358,382,359, 347,371,348, 348,372,349, 
352,376,353, 33117,373,350, 360,384,361, 33118,374,351, 320,338,321, 33089,339,322, 
4, // chain 69
322,340,323, 323,341,324, 361,385,362, 
32997,233,230, 33092,342,325, 228,232,229, 
3, // chain 70
340,364,341, 341,365,342, 359,383,360, 
336,359,337, 33103,358,336, 
2, // chain 71
339,363,340, 340,364,341, 337,361,338, 
33104,359,337, 
7, // chain 72
362,386,363, 363,387,364, 327,345,328, 
225,229,226, 228,232,229, 363,387,364, 33093,343,326, 326,344,327, 327,345,328, 
11, // chain 73
289,295,290, 352,376,353, 364,388,365, 
33128,384,361, 365,389,366, 33134,390,367, 33088,338,321, 322,340,323, 367,391,368, 33129,385,362, 231,235,232, 32998,234,231, 32997,233,230, 
2, // chain 74
300,392,301, 256,260,257, 257,261,258, 
258,262,259, 
4, // chain 75
365,389,366, 366,390,367, 367,391,368, 
231,235,232, 288,294,289, 33001,237,234, 
3, // chain 76
341,365,342, 342,366,343, 345,369,346, 
358,382,359, 33115,371,348, 
2, // chain 77
202,206,203, 251,255,252, 199,203,200, 
200,204,201, 
1, // chain 78
298,393,299, 259,263,260, 260,264,261, 
1, // chain 79
235,239,236, 294,300,295, 275,281,276, 
2, // chain 80
327,345,328, 328,346,329, 329,347,330, 
368,394,369, 
2, // chain 81
238,276,239, 272,277,273, 212,395,213, 
32992,278,225, 
1, // chain 82
338,362,339, 339,363,340, 337,361,338, 
2, // chain 83
297,306,298, 331,349,332, 332,352,333, 
295,303,296, 
2, // chain 84
364,388,365, 365,389,366, 288,294,289, 
289,295,290, 
1, // chain 85
318,331,319, 316,329,317, 317,330,318, 
1, // chain 86
256,260,257, 296,396,297, 255,259,256, 
1, // chain 87
352,376,353, 353,377,354, 358,382,359, 
23, // chain 88
369,397,370, 370,398,371, 371,399,372, 
372,400,373, 33141,401,374, 32879,402,111, 33142,403,375, 33143,404,376, 33138,398,371, 376,405,377, 33145,406,378, 33146,407,379, 33147,408,380, 33148,409,381, 33137,397,370, 381,410,382, 33150,411,383, 33151,412,384, 33140,400,373, 
384,413,385, 32863,414,95, 32874,415,106, 33141,401,374, 107,416,107, 32879,402,111, 
100, // chain 89
385,417,386, 386,418,387, 387,419,388, 
388,420,389, 33157,421,390, 33158,422,391, 33159,423,392, 33154,418,387, 392,424,393, 33161,425,394, 33162,426,395, 33153,417,386, 395,427,396, 33156,420,389, 396,428,397, 33165,429,398, 33166,430,399, 33157,421,390, 399,431,400, 
33158,422,391, 400,432,401, 33169,433,402, 33159,423,392, 402,434,403, 33160,424,393, 403,435,404, 33161,425,394, 404,436,405, 33173,437,406, 33162,426,395, 406,438,407, 33175,439,408, 33163,427,396, 396,428,397, 408,440,409, 
33177,441,410, 33165,429,398, 410,442,411, 33179,443,412, 33166,430,399, 412,444,413, 33181,445,414, 33167,431,400, 414,446,415, 33168,432,401, 97,447,97, 33183,448,416, 33169,433,402, 101,449,101, 33184,450,417, 33185,451,418, 
33186,452,419, 33170,434,403, 419,453,420, 33171,435,404, 420,454,421, 33189,455,422, 33172,436,405, 405,437,406, 422,456,423, 33191,457,424, 33174,438,407, 424,458,425, 33193,459,426, 33194,460,427, 33175,439,408, 427,461,428, 
33176,440,409, 428,462,429, 33197,463,430, 33177,441,410, 430,464,431, 33199,465,432, 33178,442,411, 432,466,433, 33201,467,434, 33179,443,412, 412,444,413, 434,468,435, 33203,469,436, 33204,470,437, 33181,445,414, 414,446,415, 
437,471,438, 33206,472,439, 33207,473,440, 32865,447,97, 96,474,96, 157,475,157, 193,476,193, 440,477,441, 33209,478,442, 33210,479,443, 33211,480,444, 32960,481,192, 128,482,128, 195,483,196, 444,484,445, 33213,485,446, 
33214,486,447, 32942,487,174, 32897,488,129, 
2, // chain 90
98,489,98, 97,447,97, 415,448,416, 
101,449,101, 
56, // chain 91
447,490,448, 448,491,449, 449,492,450, 
450,493,451, 33219,494,452, 33220,495,453, 33221,496,454, 33222,497,455, 33216,491,449, 455,498,456, 33224,499,457, 33225,500,458, 33215,490,448, 450,493,451, 458,501,459, 33227,502,460, 33202,468,435, 33219,494,452, 432,466,433, 
33220,495,453, 431,465,432, 33198,464,431, 33228,503,461, 33221,496,454, 461,504,462, 33230,505,463, 33231,506,464, 33232,507,465, 33222,497,455, 455,498,456, 465,508,466, 33234,509,467, 33235,510,468, 33224,499,457, 468,511,469, 
33237,512,470, 33238,513,471, 33225,500,458, 471,514,472, 33240,515,473, 33226,501,459, 473,516,474, 33227,502,460, 474,517,475, 33243,518,476, 33202,468,435, 435,469,436, 476,519,477, 33245,520,478, 33204,470,437, 478,521,479, 
33205,471,438, 479,522,480, 33248,523,481, 33249,524,482, 33206,472,439, 440,477,441, 33207,473,440, 
62, // chain 92
482,525,483, 483,526,484, 484,527,485, 
485,528,486, 33254,529,487, 33255,530,488, 33256,531,489, 33251,526,484, 489,532,490, 33258,533,491, 33259,534,492, 33260,535,493, 33250,525,483, 493,536,494, 33262,537,495, 33253,528,486, 495,538,496, 33254,529,487, 496,539,497, 
33265,540,498, 33255,530,488, 498,541,499, 33267,542,500, 33268,543,501, 33269,544,502, 33270,545,503, 33256,531,489, 503,546,504, 33272,547,505, 33257,532,490, 505,548,506, 33274,549,507, 33258,533,491, 491,534,492, 507,550,508, 
33276,551,509, 33260,535,493, 509,552,510, 33261,536,494, 510,553,511, 33279,554,512, 33262,537,495, 512,555,513, 33281,556,514, 33263,538,496, 496,539,497, 514,557,515, 33265,540,498, 515,558,516, 33266,541,499, 516,559,517, 
33285,560,518, 33267,542,500, 518,561,519, 33268,543,501, 519,562,520, 33288,563,521, 33289,564,522, 33290,565,523, 33269,544,502, 523,566,524, 33270,545,503, 504,547,505, 33271,546,504, 
29, // chain 93
524,567,525, 525,568,526, 526,569,527, 
527,570,528, 33233,508,466, 33232,507,465, 33231,506,464, 33296,571,529, 33293,568,526, 529,572,530, 33298,573,531, 33299,574,532, 33281,556,514, 33292,567,525, 512,555,513, 33279,554,512, 33295,570,528, 532,575,533, 33233,508,466, 
533,576,534, 33234,509,467, 534,577,535, 33235,510,468, 535,578,536, 33304,579,537, 33305,580,538, 33236,511,469, 469,512,470, 538,581,539, 33307,582,540, 33238,513,471, 
20, // chain 94
540,583,541, 172,584,172, 170,585,170, 
145,586,145, 541,587,542, 542,588,543, 33311,589,544, 544,590,545, 446,486,447, 33313,591,546, 445,485,446, 33314,592,547, 547,593,548, 548,594,549, 33317,595,550, 33318,596,551, 551,597,552, 473,516,474, 33240,515,473, 
33320,598,553, 33321,599,554, 33322,600,555, 
5, // chain 95
555,601,556, 556,602,557, 145,603,145, 
117,604,117, 557,605,558, 33142,403,375, 32879,402,111, 
26, // chain 96
558,606,559, 559,607,560, 560,608,561, 
561,609,562, 33330,610,563, 33331,611,564, 33332,612,565, 33327,607,560, 565,613,566, 33334,614,567, 33335,615,568, 33336,616,569, 33337,617,570, 33338,618,571, 33326,606,559, 571,619,572, 33340,620,573, 33341,621,574, 33329,609,562, 
574,622,575, 33330,610,563, 575,623,576, 33344,624,577, 33331,611,564, 577,625,578, 33149,410,382, 33333,613,566, 33332,612,565, 
14, // chain 97
578,626,579, 579,627,580, 580,628,581, 
461,504,462, 33228,503,461, 33349,629,582, 33350,630,583, 33351,631,584, 33347,627,580, 584,632,585, 33353,633,586, 33298,573,531, 33346,626,579, 529,572,530, 33230,505,463, 33229,504,462, 
3, // chain 98
174,487,174, 172,584,172, 540,583,541, 
542,588,543, 446,486,447, 
27, // chain 99
586,634,587, 549,595,550, 474,517,475, 
587,635,588, 33243,518,476, 476,519,477, 588,636,589, 33357,637,590, 33358,638,591, 33245,520,478, 478,521,479, 479,522,480, 480,523,481, 591,639,592, 33360,640,593, 33361,641,594, 33249,524,482, 594,642,595, 33208,477,441, 
441,478,442, 595,643,596, 33364,644,597, 33365,645,598, 33210,479,443, 598,646,599, 33316,594,549, 33211,480,444, 444,484,445, 445,485,446, 
1, // chain 100
106,415,106, 94,647,94, 95,414,95, 
14, // chain 101
599,648,600, 584,632,585, 600,649,601, 
601,650,602, 33370,651,603, 33371,652,604, 33372,653,605, 33373,654,606, 33352,632,585, 585,633,586, 606,655,607, 33298,573,531, 531,574,532, 607,656,608, 33282,557,515, 33281,556,514, 
9, // chain 102
608,657,609, 609,658,610, 610,659,611, 
611,660,612, 612,661,613, 555,601,556, 33381,662,614, 556,602,557, 33382,663,615, 541,664,542, 145,603,145, 
16, // chain 103
615,665,616, 574,622,575, 616,666,617, 
617,667,618, 33386,668,619, 33387,669,620, 32858,670,90, 32859,671,91, 32861,672,93, 33342,622,575, 575,623,576, 95,414,95, 33152,413,385, 33344,624,577, 383,412,384, 33150,411,383, 33345,625,578, 381,410,382, 
13, // chain 104
505,548,506, 506,549,507, 620,673,621, 
33275,550,508, 381,410,382, 33148,409,381, 33276,551,509, 379,408,380, 33277,552,510, 621,674,622, 33390,675,623, 33278,553,511, 533,576,534, 33300,575,533, 33279,554,512, 
2, // chain 105
462,505,463, 463,506,464, 529,572,530, 
33296,571,529, 
31, // chain 106
620,673,621, 565,613,566, 566,614,567, 
505,548,506, 33335,615,568, 623,676,624, 33336,616,569, 624,677,625, 33337,617,570, 625,678,626, 33394,679,627, 33338,618,571, 627,680,628, 33396,681,629, 33397,682,630, 33339,619,572, 630,683,631, 33340,620,573, 420,454,421, 
33399,684,632, 33400,685,633, 33341,621,574, 574,622,575, 615,665,616, 617,667,618, 633,686,634, 33186,452,419, 33185,451,418, 33184,450,417, 33386,668,619, 619,669,620, 101,449,101, 32858,670,90, 
9, // chain 107
621,674,622, 534,577,535, 535,578,536, 
634,687,635, 33304,579,537, 635,688,636, 33404,689,637, 33377,658,610, 33305,580,538, 610,659,611, 33306,581,539, 
4, // chain 108
522,565,523, 523,566,524, 624,677,625, 
33391,676,624, 33272,547,505, 505,548,506, 
30, // chain 109
637,690,638, 638,691,639, 639,692,640, 
640,693,641, 33143,404,376, 33142,403,375, 33409,694,642, 33406,691,639, 642,695,643, 33411,696,644, 33412,697,645, 33405,690,638, 645,698,646, 33408,693,641, 646,699,647, 33143,404,376, 376,405,377, 647,700,648, 33145,406,378, 
648,701,649, 33417,702,650, 33418,703,651, 33146,407,379, 379,408,380, 621,674,622, 651,704,652, 33420,705,653, 33421,706,654, 33402,687,635, 635,688,636, 642,695,643, 33409,694,642, 
5, // chain 110
557,605,558, 374,403,375, 654,707,655, 
655,708,656, 33424,709,657, 33409,694,642, 33142,403,375, 
3, // chain 111
657,710,658, 598,646,599, 586,634,587, 
588,636,589, 33355,635,588, 
3, // chain 112
636,689,637, 655,708,656, 656,709,657, 
635,688,636, 33409,694,659, 
12, // chain 113
658,711,660, 643,696,644, 648,701,649, 
659,712,661, 33417,702,650, 650,703,651, 658,711,660, 33419,704,652, 652,705,653, 660,713,662, 33421,706,654, 642,695,643, 643,696,644, 658,711,660, 
3, // chain 114
661,714,663, 521,564,522, 522,565,523, 
625,678,626, 33392,677,625, 
2, // chain 115
598,646,599, 548,594,549, 549,595,550, 
586,634,587, 
7, // chain 116
517,560,518, 604,653,605, 662,715,664, 
663,716,665, 33284,559,517, 33375,656,608, 33374,655,607, 33373,654,606, 33372,653,605, 
2, // chain 117
607,656,608, 514,557,515, 515,558,516, 
516,559,517, 
7, // chain 118
596,644,597, 597,645,598, 657,710,658, 
588,636,589, 664,717,666, 33357,637,590, 665,718,667, 33359,639,592, 33358,638,591, 
2, // chain 119
604,653,605, 517,560,518, 519,562,520, 
33286,561,519, 
7, // chain 120
584,632,585, 599,648,600, 666,719,668, 
583,631,584, 33349,629,582, 33197,463,430, 33196,462,429, 33369,650,602, 33367,648,600, 
9, // chain 121
423,457,424, 424,458,425, 667,720,669, 
33193,459,426, 668,721,670, 33372,653,605, 33371,652,604, 33370,651,603, 33369,650,602, 33195,461,428, 33194,460,427, 
4, // chain 122
669,722,671, 670,723,672, 664,717,666, 
665,718,667, 592,640,593, 33359,639,592, 
3, // chain 123
470,513,471, 471,514,472, 671,724,673, 
33320,598,553, 33240,515,473, 
3, // chain 124
672,725,674, 670,723,672, 669,722,671, 
593,641,675, 670,723,672, 
11, // chain 125
625,678,626, 626,679,627, 661,714,663, 
33441,726,676, 33395,680,628, 422,456,423, 33396,681,629, 421,455,422, 33442,727,677, 33397,682,630, 421,455,422, 33398,683,631, 420,454,421, 
1, // chain 126
427,461,428, 428,462,429, 601,650,602, 
8, // chain 127
422,456,423, 423,457,424, 673,726,676, 
33435,720,669, 668,721,670, 661,714,663, 33289,564,522, 33288,563,521, 33372,653,605, 519,562,520, 
4, // chain 128
655,708,656, 636,689,637, 609,658,610, 
608,657,609, 555,601,556, 557,605,558, 
2, // chain 129
419,453,420, 420,454,421, 633,686,634, 
418,452,419, 
3, // chain 130
670,723,672, 594,642,595, 595,643,596, 
664,717,666, 33364,644,597, 
2, // chain 131
430,464,431, 460,503,461, 581,629,582, 
429,463,430, 
1, // chain 132
565,613,566, 620,673,621, 381,410,382, 
1, // chain 133
592,640,593, 593,641,594, 669,722,671, 
1, // chain 134
434,468,435, 432,466,433, 433,467,434, 
2, // chain 135
622,675,623, 533,576,534, 534,577,535, 
621,674,622, 
5, // chain 136
675,728,678, 643,696,644, 645,698,646, 
646,699,647, 647,700,648, 643,696,644, 33416,701,649, 
1, // chain 137
676,729,679, 541,587,542, 614,730,615, 
1, // chain 138
645,698,646, 643,696,644, 644,697,645, 
1, // chain 139
663,716,665, 516,559,517, 517,560,518, 
2, // chain 140
420,454,421, 631,684,632, 633,686,634, 
33400,685,633, 
1, // chain 141
549,595,550, 473,516,474, 474,517,475, 
1, // chain 142
593,641,594, 594,642,595, 670,723,672, 
1, // chain 143
598,646,599, 657,710,658, 597,645,598, 
1, // chain 144
583,631,584, 581,629,582, 582,630,583, 
77, // chain 145
677,731,680, 678,732,681, 679,733,682, 
680,734,683, 33449,735,684, 33450,736,685, 33451,737,686, 684,738,687, 33445,731,680, 685,739,688, 33448,734,683, 686,740,689, 33455,741,690, 33456,742,691, 33457,743,692, 33458,744,693, 33449,735,684, 691,745,694, 33460,746,695, 
33450,736,685, 693,747,696, 33462,748,697, 33463,749,698, 33452,738,687, 696,750,699, 33465,751,700, 33453,739,688, 698,752,701, 33467,753,702, 33454,740,689, 700,754,703, 33469,755,704, 33455,741,690, 702,756,705, 33446,757,681, 
33447,758,682, 33456,742,691, 703,759,706, 33457,743,692, 704,760,707, 33473,761,708, 33458,744,693, 691,745,694, 706,762,709, 33475,763,710, 33460,746,695, 693,747,696, 708,764,711, 33477,765,712, 33478,766,713, 33462,748,697, 
711,767,714, 33480,768,715, 33481,769,716, 33463,749,698, 696,750,699, 714,770,717, 33465,751,700, 715,771,718, 33484,772,719, 33466,752,701, 717,773,720, 33486,774,721, 33487,775,722, 33467,753,702, 720,776,723, 33468,754,703, 
721,777,724, 33490,778,725, 33469,755,704, 723,779,726, 33492,780,727, 33470,756,705, 725,781,728, 33494,782,729, 33471,759,706, 33447,758,682, 33451,783,686, 33446,757,681, 
40, // chain 146
727,784,730, 728,785,731, 729,786,732, 
730,787,733, 33499,788,734, 33500,789,735, 33501,790,736, 33502,791,737, 33496,785,731, 735,792,738, 33504,793,739, 33495,784,730, 722,778,725, 33505,794,740, 33498,787,733, 738,795,741, 33507,796,742, 33508,797,743, 33509,798,744, 
33499,788,734, 742,799,745, 33511,800,746, 33512,801,747, 33500,789,735, 745,802,748, 33501,790,736, 746,803,749, 33515,804,750, 33502,791,737, 748,805,751, 33503,792,738, 749,806,752, 33518,807,753, 33504,793,739, 751,808,754, 
33520,809,755, 33490,778,725, 723,779,726, 751,808,754, 33521,810,756, 33493,781,728, 33492,780,727, 
24, // chain 147
754,811,757, 755,812,758, 712,768,715, 
756,813,759, 33525,814,760, 33481,769,716, 714,770,717, 758,815,761, 33483,771,718, 759,816,762, 33528,817,763, 33484,772,719, 761,818,764, 33485,773,720, 762,819,765, 33508,797,743, 33531,820,766, 33532,821,767, 33486,774,721, 
719,775,722, 739,796,742, 33488,776,723, 721,777,724, 738,795,741, 33505,794,740, 33490,778,725, 
98, // chain 148
765,822,768, 766,823,769, 767,824,770, 
768,825,771, 33537,826,772, 33538,827,773, 33539,828,774, 33540,829,775, 33541,830,776, 33534,823,769, 774,831,777, 33543,832,778, 33533,822,768, 776,833,779, 33545,834,780, 33546,835,781, 33536,825,771, 779,836,782, 33548,837,783, 
33537,826,772, 781,838,784, 33538,827,773, 771,828,774, 782,839,785, 33551,840,786, 33540,829,775, 784,841,787, 33553,842,788, 33554,843,789, 33541,830,776, 774,831,777, 787,844,790, 33556,845,791, 33557,846,792, 33543,832,778, 
776,833,779, 790,847,793, 33559,848,794, 33560,849,795, 33561,850,796, 33545,834,780, 794,851,797, 33546,835,781, 795,852,798, 33564,853,799, 33565,854,800, 33547,836,782, 780,837,783, 798,855,801, 33567,856,802, 33549,838,784, 
800,857,803, 33569,858,804, 33570,859,805, 33550,839,785, 803,860,806, 33551,840,786, 804,861,807, 33573,862,808, 33552,841,787, 806,863,809, 33575,864,810, 33576,865,811, 33553,842,788, 786,843,789, 787,844,790, 807,864,810, 
33577,866,812, 33578,867,813, 33556,845,791, 811,868,814, 33580,869,815, 33581,870,816, 33582,871,817, 33557,846,792, 790,847,793, 815,872,818, 33584,873,819, 33585,874,820, 33559,848,794, 818,875,821, 33560,849,795, 819,876,822, 
33588,877,823, 33589,878,824, 33561,850,796, 820,877,823, 33590,879,825, 33562,851,797, 823,880,826, 33563,852,798, 824,881,827, 33564,853,799, 825,882,828, 33565,854,800, 826,883,829, 33566,855,801, 827,884,830, 33568,857,803, 
33567,856,802, 
9, // chain 149
828,885,831, 756,813,759, 829,886,832, 
830,887,833, 33599,888,834, 33527,816,762, 33526,815,761, 33525,814,760, 33600,889,835, 33524,813,759, 757,814,760, 
10, // chain 150
762,819,765, 833,890,836, 834,891,837, 
835,892,838, 33604,893,839, 33605,894,840, 33606,895,841, 33601,890,836, 839,896,842, 33509,798,744, 33530,819,765, 740,797,743, 
31, // chain 151
840,897,843, 841,898,844, 842,899,845, 
843,900,846, 33612,901,847, 33613,902,848, 33614,903,849, 33615,904,850, 33609,898,844, 812,869,815, 33616,905,851, 33617,906,852, 33608,897,843, 850,907,853, 33619,908,854, 33620,909,855, 33611,900,846, 853,910,856, 33622,911,857, 
33612,901,847, 855,912,858, 33624,913,859, 33613,902,848, 857,914,860, 33626,915,861, 33614,903,849, 859,916,862, 33628,917,863, 33615,904,850, 812,869,815, 813,870,816, 815,872,818, 33582,871,817, 
72, // chain 152
861,918,864, 862,919,865, 863,920,866, 
864,921,867, 33633,922,868, 33634,923,869, 33630,919,865, 867,924,870, 33636,925,871, 33637,926,872, 33638,927,873, 33629,918,864, 851,908,854, 33618,907,853, 33639,928,874, 33632,921,867, 872,929,875, 33633,922,868, 873,930,876, 
33642,931,877, 33643,932,878, 33644,933,879, 33634,923,869, 877,934,880, 33635,924,870, 878,935,881, 33647,936,882, 33636,925,871, 880,937,883, 33649,938,884, 33650,939,885, 33637,926,872, 883,940,886, 33652,941,887, 33638,927,873, 
851,908,854, 885,942,888, 33654,943,889, 33655,944,890, 33620,909,855, 853,910,856, 888,945,891, 33657,946,892, 33658,947,893, 33622,911,857, 855,912,858, 891,948,894, 33660,949,895, 33624,913,859, 893,950,896, 33625,914,860, 
894,951,897, 33605,894,840, 33626,915,861, 895,952,898, 33627,916,862, 896,953,899, 33665,954,900, 33628,917,863, 815,872,818, 816,873,819, 896,953,899, 33666,955,901, 33667,956,902, 33585,874,820, 818,875,821, 900,957,903, 
33669,958,904, 33587,876,822, 902,959,905, 33671,960,906, 33591,880,826, 33588,877,823, 822,879,825, 
54, // chain 153
904,961,907, 905,962,908, 906,963,909, 
907,964,910, 33676,965,911, 33677,966,912, 33678,967,913, 33679,968,914, 33673,962,908, 912,969,915, 33672,961,907, 913,970,916, 33682,971,917, 33675,964,910, 915,972,918, 33684,973,919, 33676,965,911, 917,974,920, 33677,966,912, 
918,975,921, 33687,976,922, 33688,977,923, 33689,978,924, 33678,967,913, 922,979,925, 33679,968,914, 923,980,926, 33692,981,927, 33680,969,915, 925,982,928, 33681,970,916, 926,983,929, 33695,984,930, 33696,985,931, 33697,986,932, 
33682,971,917, 930,987,933, 33683,972,918, 810,867,813, 33699,988,934, 33684,973,919, 932,989,935, 33701,990,936, 33685,974,920, 918,975,921, 934,991,937, 33687,976,922, 935,992,938, 33704,993,939, 33705,994,940, 33706,995,941, 
33688,977,923, 939,996,942, 33708,997,943, 33690,979,925, 33689,978,924, 
12, // chain 154
926,983,929, 941,998,944, 942,999,945, 
925,982,928, 33711,1000,946, 33712,1001,947, 33713,1002,948, 33714,1003,949, 33715,1004,950, 33709,998,944, 948,1005,951, 33717,1006,952, 33695,984,930, 33694,983,929, 
6, // chain 155
837,894,840, 838,895,841, 894,951,897, 
33718,1007,953, 33607,896,842, 743,800,746, 33510,799,745, 33509,798,744, 
39, // chain 156
882,939,885, 883,940,886, 881,938,884, 
33719,1008,954, 33720,1009,955, 33721,1010,956, 33722,1011,957, 33652,941,887, 885,942,888, 953,1010,956, 33654,943,889, 955,1012,958, 33655,944,890, 956,1013,959, 33656,945,891, 957,1014,960, 33657,946,892, 958,1015,961, 33727,1016,962, 
33728,1017,963, 33658,947,893, 891,948,894, 961,1018,964, 33730,1019,965, 33731,1020,966, 33660,949,895, 964,1021,967, 33661,950,896, 965,1022,968, 33662,951,897, 950,1007,953, 743,800,746, 964,1021,967, 33512,801,747, 966,1023,969, 
33735,1024,970, 33513,802,748, 968,1025,971, 33737,1026,972, 33514,803,749, 970,1027,973, 
8, // chain 157
726,782,729, 703,759,706, 971,1028,974, 
972,1029,975, 33741,1030,976, 33742,1031,977, 33743,1032,978, 33744,1033,979, 33472,760,707, 33471,759,706, 
22, // chain 158
977,1034,980, 978,1035,981, 979,1036,982, 
980,1037,983, 33749,1038,984, 33750,1039,985, 33751,1040,986, 33698,987,933, 33746,1035,981, 929,986,932, 33752,1041,987, 33753,1042,988, 33754,1043,989, 33745,1034,980, 873,930,876, 33755,1044,990, 33748,1037,983, 981,1038,984, 988,1045,991, 
33579,868,814, 33750,1039,985, 810,867,813, 33751,1040,986, 930,987,933, 
11, // chain 159
803,860,806, 989,1046,992, 990,1047,993, 
991,1048,994, 33760,1049,995, 33761,1050,996, 33762,1051,997, 33763,1052,998, 33757,1046,992, 996,1053,999, 33765,1054,1000, 33572,861,807, 33571,860,806, 
9, // chain 160
998,1055,1001, 999,1056,1002, 827,884,830, 
1000,1057,1003, 33568,857,803, 1001,1058,1004, 33569,858,804, 1002,1059,1005, 33570,859,805, 991,1048,994, 33571,860,806, 
4, // chain 161
938,995,941, 939,996,942, 1003,1060,1006, 
1004,1061,1007, 1005,1062,1008, 937,994,940, 
9, // chain 162
1006,1063,1009, 1007,1064,1010, 1008,1065,1011, 
33777,1066,1012, 1010,1067,1013, 33779,1068,1014, 33780,1069,1015, 33781,1070,1016, 1014,1071,1017, 1015,1072,1018, 33784,1073,1019, 
23, // chain 163
1017,1074,1020, 1018,1075,1021, 1019,1076,1022, 
1011,1068,1014, 33788,1077,1023, 33789,1078,1024, 33790,1079,1025, 33786,1075,1021, 1023,1080,1026, 33792,1081,1027, 33785,1074,1020, 948,1005,951, 33715,1004,950, 33793,1082,1028, 33794,1083,1029, 33779,1068,1014, 1012,1069,1015, 1027,1084,1030, 33783,1072,1018, 
1028,1085,1031, 1029,1086,1032, 33798,1087,1033, 33799,1088,1034, 33800,1089,1035, 33801,1090,1036, 
40, // chain 164
1034,1091,1037, 1035,1092,1038, 1036,1093,1039, 
1037,1094,1040, 33806,1095,1041, 33807,1096,1042, 33803,1092,1038, 878,935,881, 33645,934,880, 33802,1091,1037, 876,933,879, 33808,1097,1043, 33805,1094,1040, 928,985,931, 33695,984,930, 33717,1006,952, 33806,1095,1041, 948,1005,951, 33792,1081,1027, 
33809,1098,1044, 33807,1096,1042, 1042,1099,1045, 33811,1100,1046, 33646,935,881, 879,936,882, 1044,1101,1047, 33648,937,883, 1045,1102,1048, 33649,938,884, 1046,1103,1049, 33719,1008,954, 1047,1104,1050, 33720,1009,955, 1048,1105,1051, 33817,1106,1052, 
33721,1010,956, 1050,1107,1053, 33819,1108,1054, 33723,1012,958, 956,1013,959, 1052,1109,1055, 1050,1107,1053, 
5, // chain 165
996,1053,999, 997,1054,1000, 1053,1110,1056, 
33822,1111,1057, 33823,1112,1058, 33573,862,808, 33572,861,807, 
7, // chain 166
1056,1113,1059, 1057,1114,1060, 824,881,827, 
1058,1115,1061, 33593,882,828, 826,883,829, 827,884,830, 1059,1116,1062, 33828,1117,1063, 
20, // chain 167
1061,1118,1064, 1062,1119,1065, 902,959,905, 
903,960,906, 1063,1120,1066, 33832,1121,1067, 33833,1122,1068, 33834,1123,1069, 33591,880,826, 824,881,827, 1057,1114,1060, 1065,1122,1068, 33835,1124,1070, 33836,1125,1071, 33837,1126,1072, 33838,1127,1073, 33839,1128,1074, 33824,1113,1059, 1072,1129,1075, 
33826,1115,1061, 1059,1116,1062, 1073,1130,1076, 
8, // chain 168
1074,1131,1077, 932,989,935, 933,990,936, 
934,991,937, 806,863,809, 33843,1132,1078, 33844,1133,1079, 33703,992,938, 1077,1134,1080, 33704,993,939, 
9, // chain 169
1078,1135,1081, 1076,1133,1079, 1079,1136,1082, 
1080,1137,1083, 1081,1138,1084, 1082,1139,1085, 1083,1140,1086, 33852,1141,1087, 1055,1112,1058, 33853,1142,1088, 33854,1143,1089, 
9, // chain 170
1087,1144,1090, 1088,1145,1091, 1089,1146,1092, 
1090,1147,1093, 33729,1018,964, 33859,1148,1094, 1092,1149,1095, 960,1017,963, 33861,1150,1096, 33862,1151,1097, 33863,1152,1098, 
13, // chain 171
923,980,926, 1096,1153,1099, 1097,1154,1100, 
922,979,925, 33866,1155,1101, 33864,1153,1099, 1099,1156,1102, 33868,1157,1103, 33869,1158,1104, 33870,1159,1105, 33871,1160,1106, 33691,980,926, 924,981,927, 943,1000,946, 33693,982,928, 
8, // chain 172
1104,1161,1107, 998,1055,1001, 1105,1162,1108, 
1106,1163,1109, 33770,1059,1005, 33769,1058,1004, 33875,1164,1110, 33766,1055,1001, 1000,1057,1003, 1001,1058,1004, 
8, // chain 173
1108,1165,1111, 749,806,752, 1109,1166,1112, 
1110,1167,1113, 33879,1168,1114, 33880,1169,1115, 33881,1170,1116, 33519,808,754, 33517,806,752, 750,807,753, 
2, // chain 174
835,892,838, 759,816,762, 761,818,764, 
762,819,765, 
11, // chain 175
1067,1124,1070, 1068,1125,1071, 1114,1171,1117, 
1063,1120,1066, 33883,1172,1118, 33884,1173,1119, 33885,1174,1120, 33886,1175,1121, 33836,1125,1071, 1119,1176,1122, 33888,1177,1123, 33889,1178,1124, 33837,1126,1072, 
14, // chain 176
1063,1120,1066, 1115,1172,1118, 754,811,757, 
1122,1179,1125, 33891,1180,1126, 33892,1181,1127, 33524,813,759, 828,885,831, 1125,1182,1128, 33598,887,833, 1126,1183,1129, 33895,1184,1130, 33599,888,834, 836,893,839, 33527,816,762, 835,892,838, 
2, // chain 177
1122,1179,1125, 1062,1119,1065, 1061,1118,1064, 
1063,1120,1066, 
14, // chain 178
960,1017,963, 1128,1185,1131, 1129,1186,1132, 
959,1016,962, 33898,1187,1133, 33899,1188,1134, 33900,1189,1135, 33896,1185,1131, 1133,1190,1136, 33902,1191,1137, 33903,1192,1138, 33904,1193,1139, 33728,1017,963, 1093,1150,1096, 1135,1192,1138, 33905,1194,1140, 
2, // chain 179
994,1051,997, 1138,1195,1141, 1139,1196,1142, 
993,1050,996, 
4, // chain 180
895,952,898, 896,953,899, 898,955,901, 
1140,1197,1143, 33668,957,903, 33667,956,902, 
11, // chain 181
1102,1159,1105, 1103,1160,1106, 1141,1198,1144, 
33910,1199,1145, 33711,1000,946, 944,1001,947, 1141,1198,1144, 33911,1200,1146, 33713,1002,948, 1144,1201,1147, 33793,1082,1028, 33714,1003,949, 947,1004,950, 
7, // chain 182
554,1202,555, 1006,1063,1009, 1145,1203,1148, 
33776,1065,1011, 1146,1204,1149, 33778,1067,1013, 1147,1205,1150, 33788,1077,1023, 33779,1068,1014, 
5, // chain 183
809,866,812, 810,867,813, 931,988,934, 
807,864,810, 33700,989,935, 1074,1131,1077, 806,863,809, 
22, // chain 184
1148,1206,1151, 1149,1207,1152, 1150,1208,1153, 
1151,1209,1154, 33920,1210,1155, 33880,1169,1115, 33921,1211,1156, 1111,1168,1114, 33922,1212,1157, 1155,1213,1158, 33924,1214,1159, 1157,1215,1160, 1158,1216,1161, 1159,1217,1162, 1110,1167,1113, 33928,1218,1163, 1108,1165,1111, 33929,1219,1164, 33930,1220,1165, 
33931,1221,1166, 1164,1222,1167, 33933,1223,1168, 1166,1224,1169, 33935,1225,1170, 
2, // chain 185
1098,1155,1101, 1168,1226,1171, 940,997,943, 
922,979,925, 
7, // chain 186
1169,1227,1172, 1170,1228,1173, 1087,1144,1090, 
1171,1229,1174, 33735,1024,970, 33734,1023,969, 33858,1147,1093, 962,1019,965, 33729,1018,964, 
20, // chain 187
1172,1230,1175, 1173,1231,1176, 1174,1232,1177, 
1175,1233,1178, 33944,1234,1179, 33945,1235,1180, 33946,1236,1181, 33941,1231,1176, 1179,1237,1182, 33798,1087,1033, 33912,1201,1147, 33911,1200,1146, 33940,1230,1175, 1141,1198,1144, 33870,1159,1105, 33869,1158,1104, 33943,1233,1178, 1100,1157,1103, 33948,1238,1183, 
33944,1234,1179, 1181,1239,1184, 33945,1235,1180, 
7, // chain 188
848,905,851, 849,906,852, 1182,1240,1185, 
33618,907,853, 871,928,874, 1183,1241,1186, 33755,1044,990, 33640,929,875, 873,930,876, 
8, // chain 189
1138,1195,1141, 994,1051,997, 1184,1242,1187, 
33953,1243,1188, 33763,1052,998, 996,1053,999, 1053,1110,1056, 1186,1244,1189, 33955,1245,1190, 33956,1246,1191, 
5, // chain 190
1189,1247,1192, 1190,1248,1193, 1191,1249,1194, 
1192,1250,1195, 33961,1251,1196, 33962,1252,1197, 33958,1248,1193, 
1, // chain 191
760,817,763, 761,818,764, 759,816,762, 
9, // chain 192
940,997,943, 1168,1226,1171, 1195,1253,1198, 
939,996,942, 33964,1254,1199, 33965,1255,1200, 33966,1256,1201, 33967,1257,1202, 33936,1226,1171, 1099,1156,1102, 33866,1155,1101, 
5, // chain 193
1200,1258,1203, 552,1259,553, 553,1260,554, 
1147,1205,1150, 33914,1204,1149, 33322,1202,555, 1145,1203,1148, 
14, // chain 194
1041,1098,1044, 1042,1099,1045, 1023,1080,1026, 
33969,1261,1204, 33970,1262,1205, 33971,1263,1206, 33811,1100,1046, 1204,1264,1207, 33812,1101,1047, 1205,1265,1208, 33974,1266,1209, 33813,1102,1048, 1207,1267,1210, 33814,1103,1049, 1208,1268,1211, 1209,1269,1212, 
14, // chain 195
1023,1080,1026, 1201,1261,1204, 1210,1270,1213, 
1022,1079,1025, 33979,1271,1214, 33980,1272,1215, 33981,1273,1216, 33982,1274,1217, 33969,1261,1204, 1202,1262,1205, 1215,1275,1218, 33971,1263,1206, 1216,1276,1219, 33972,1264,1207, 1217,1277,1220, 33973,1265,1208, 
3, // chain 196
1193,1251,1196, 1194,1252,1197, 1218,1278,1221, 
611,1279,612, 33380,1280,613, 
2, // chain 197
972,1029,975, 753,810,756, 725,781,728, 
726,782,729, 
4, // chain 198
1219,1281,1222, 1198,1256,1201, 1199,1257,1202, 
1180,1238,1183, 33867,1156,1102, 1100,1157,1103, 
5, // chain 199
552,1259,553, 1200,1258,1203, 671,1282,673, 
33988,1283,1223, 33789,1078,1024, 33788,1077,1023, 33915,1205,1150, 
2, // chain 200
1063,1120,1066, 1064,1121,1067, 1067,1124,1070, 
33833,1122,1068, 
4, // chain 201
1062,1119,1065, 1122,1179,1125, 1123,1180,1126, 
1221,1284,1224, 33893,1182,1128, 33892,1181,1127, 
6, // chain 202
1222,1285,1225, 746,803,749, 747,804,750, 
1166,1224,1169, 33516,805,751, 1161,1219,1164, 33876,1165,1111, 33517,806,752, 
4, // chain 203
1223,1286,1226, 538,1287,539, 539,1288,540, 
1220,1283,1223, 33439,1282,673, 33238,1289,471, 
7, // chain 204
1224,1290,1227, 1192,1250,1195, 538,1287,539, 
1223,1286,1226, 1212,1272,1215, 33979,1271,1214, 33988,1283,1223, 1021,1078,1024, 1022,1079,1025, 
2, // chain 205
1171,1229,1174, 967,1024,970, 1225,1291,1228, 
33736,1025,971, 
8, // chain 206
1226,1292,1229, 1227,1293,1230, 1190,1248,1193, 
1228,1294,1231, 33957,1247,1192, 1215,1275,1218, 33981,1273,1216, 33960,1250,1195, 1224,1290,1227, 1212,1272,1215, 
4, // chain 207
811,868,814, 812,869,815, 848,905,851, 
988,1045,991, 33951,1241,1186, 33950,1240,1185, 
4, // chain 208
706,1295,709, 1229,1296,1232, 705,761,708, 
33998,1297,1233, 33472,760,707, 33744,1033,979, 
2, // chain 209
992,1049,995, 1106,1163,1109, 1002,1059,1005, 
991,1048,994, 
10, // chain 210
974,1031,977, 1148,1206,1151, 1151,1209,1154, 
973,1030,976, 33999,1298,1234, 34000,1299,1235, 33920,1210,1155, 753,810,756, 33881,1170,1116, 34001,1300,1236, 33880,1169,1115, 1113,1170,1116, 
5, // chain 211
1055,1112,1058, 805,862,808, 806,863,809, 
1083,1140,1086, 33843,1132,1078, 1078,1135,1081, 33844,1133,1079, 
1, // chain 212
1184,1242,1187, 1185,1243,1188, 1186,1244,1189, 
7, // chain 213
1234,1301,1237, 711,767,714, 712,768,715, 
755,812,758, 1235,1302,1238, 34004,1303,1239, 34005,1304,1240, 33522,811,757, 1115,1172,1118, 
2, // chain 214
1055,1112,1058, 1085,1142,1088, 1238,1305,1241, 
1054,1111,1057, 
2, // chain 215
1239,1306,1242, 708,764,711, 710,766,713, 
33477,765,712, 
2, // chain 216
998,1055,1001, 1104,1161,1107, 1240,1307,1243, 
999,1056,1002, 
2, // chain 217
964,1021,967, 966,1023,969, 963,1020,966, 
33730,1019,965, 
2, // chain 218
753,810,756, 972,1029,975, 1231,1298,1234, 
33741,1030,976, 
3, // chain 219
1003,1060,1006, 939,996,942, 1241,1308,1244, 
34010,1309,1245, 33964,1254,1199, 
1, // chain 220
1155,1213,1158, 1110,1167,1113, 1111,1168,1114, 
3, // chain 221
985,1042,988, 986,1043,989, 875,932,878, 
33642,931,877, 33641,930,876, 
1, // chain 222
1196,1254,1199, 1197,1255,1200, 1243,1310,1246, 
1, // chain 223
1088,1145,1091, 1087,1144,1090, 1170,1228,1173, 
1, // chain 224
1088,1145,1091, 1244,1311,1247, 1089,1146,1092, 
2, // chain 225
975,1032,978, 1149,1207,1152, 1148,1206,1151, 
974,1031,977, 
2, // chain 226
1118,1175,1121, 1119,1176,1122, 1245,1312,1248, 
1117,1174,1120, 
3, // chain 227
1246,1313,1249, 1113,1170,1116, 751,808,754, 
753,810,756, 1113,1170,1116, 
1, // chain 228
1024,1081,1027, 1041,1098,1044, 1023,1080,1026, 
4, // chain 229
1140,1197,1143, 900,957,903, 1221,1284,1224, 
33830,1119,1065, 33669,958,904, 902,959,905, 
3, // chain 230
1025,1082,1028, 1026,1083,1029, 1029,1086,1032, 
1144,1201,1147, 33798,1087,1033, 
2, // chain 231
1070,1127,1073, 1071,1128,1074, 1247,1314,1250, 
33840,1129,1075, 
6, // chain 232
1127,1184,1130, 836,893,839, 837,894,840, 
895,952,898, 1126,1183,1129, 33908,1197,1143, 1221,1284,1224, 1125,1182,1128, 
4, // chain 233
1248,1315,1251, 1249,1316,1252, 957,1014,960, 
34018,1317,1253, 1251,1318,1254, 956,1013,959, 
2, // chain 234
1048,1105,1051, 1049,1106,1052, 1252,1319,1255, 
33818,1107,1053, 
1, // chain 235
1219,1281,1222, 1180,1238,1183, 1181,1239,1184, 
1, // chain 236
1079,1136,1082, 1076,1133,1079, 1077,1134,1080, 
1, // chain 237
959,1016,962, 1130,1187,1133, 1253,1320,1256, 
4, // chain 238
1254,1321,1257, 1255,1322,1258, 1133,1190,1136, 
1134,1191,1137, 1135,1192,1138, 1256,1323,1259, 
1, // chain 239
1257,1324,1260, 1218,1278,1221, 1194,1252,1197, 
1, // chain 240
1232,1299,1235, 753,810,756, 1231,1298,1234, 
2, // chain 241
957,1014,960, 958,1015,961, 1258,1325,1261, 
1248,1326,1251, 
2, // chain 242
985,1042,988, 875,932,878, 1040,1097,1043, 
33644,933,879, 
3, // chain 243
1215,1275,1218, 1216,1276,1219, 1228,1294,1231, 
33994,1292,1229, 33985,1277,1220, 
2, // chain 244
1259,1327,1262, 706,762,709, 707,763,710, 
708,764,711, 
1, // chain 245
1260,1328,1263, 1222,1285,1225, 1166,1224,1169, 
1, // chain 246
959,1016,962, 1261,1329,1264, 958,1015,961, 
3, // chain 247
538,1287,539, 1192,1250,1195, 610,1330,611, 
33961,1251,1196, 611,1279,612, 
2, // chain 248
740,797,743, 763,820,766, 739,796,742, 
33532,821,767, 
1, // chain 249
1027,1084,1030, 1029,1086,1032, 1026,1083,1029, 
1, // chain 250
1213,1273,1216, 1214,1274,1217, 1215,1275,1218, 
1, // chain 251
1186,1244,1189, 1187,1245,1190, 1262,1331,1265, 
1, // chain 252
993,1050,996, 1106,1163,1109, 992,1049,995, 
1, // chain 253
1031,1088,1034, 1179,1237,1182, 1030,1087,1033, 
2, // chain 254
1162,1220,1165, 1164,1222,1167, 1161,1219,1164, 
33934,1224,1169, 
2, // chain 255
984,1041,987, 1040,1097,1043, 928,985,931, 
929,986,932, 
1, // chain 256
705,761,708, 1230,1297,1233, 704,760,707, 
1, // chain 257
984,1041,987, 985,1042,988, 1040,1097,1043, 
1, // chain 258
1183,1241,1186, 987,1044,990, 988,1045,991, 
1, // chain 259
1171,1229,1174, 1225,1291,1228, 1263,1332,1266, 
50, // chain 260
1264,1333,1267, 1265,1334,1268, 1266,1335,1269, 
1267,1336,1270, 34036,1337,1271, 34037,1338,1272, 34038,1339,1273, 34039,1340,1274, 34040,1341,1275, 34033,1334,1268, 1273,1342,1276, 34042,1343,1277, 34043,1344,1278, 34032,1333,1267, 1276,1345,1279, 34035,1336,1270, 1277,1346,1280, 34046,1347,1281, 34047,1348,1282, 
34048,1349,1283, 34036,1337,1271, 1281,1350,1284, 34050,1351,1285, 34037,1338,1272, 1283,1352,1286, 34052,1353,1287, 34038,1339,1273, 1285,1354,1288, 34039,1340,1274, 1286,1355,1289, 34055,1356,1290, 34056,1357,1291, 34040,1341,1275, 1289,1358,1292, 34041,1342,1276, 
1290,1359,1293, 34059,1360,1294, 34042,1343,1277, 1292,1361,1295, 34061,1362,1296, 34043,1344,1278, 1294,1363,1297, 34063,1364,1298, 34044,1345,1279, 1277,1346,1280, 1296,1365,1299, 34046,1347,1281, 1297,1366,1300, 34066,1367,1301, 34047,1348,1282, 1281,1350,1284, 
34048,1349,1283, 
18, // chain 261
1299,1368,1302, 1300,1369,1303, 1301,1370,1304, 
1302,1371,1305, 34071,1372,1306, 33772,1373,1007, 34068,1369,1303, 1005,1374,1008, 33705,1375,940, 34072,1376,1307, 34067,1368,1302, 1305,1377,1308, 34074,1378,1309, 34075,1379,1310, 34070,1371,1305, 1308,1380,1311, 34077,1381,1312, 34071,1372,1306, 1003,1382,1006, 
33772,1373,1007, 
7, // chain 262
1310,1383,1313, 1311,1384,1314, 1312,1385,1315, 
1313,1386,1316, 34082,1387,1317, 34083,1388,1318, 34084,1389,1319, 34085,1390,1320, 34086,1391,1321, 
26, // chain 263
1319,1392,1322, 1320,1393,1323, 1321,1394,1324, 
1322,1395,1325, 34091,1396,1326, 34092,1397,1327, 34093,1398,1328, 34088,1393,1323, 1326,1399,1329, 34095,1400,1330, 34096,1401,1331, 34097,1402,1332, 34098,1403,1333, 34087,1392,1322, 1331,1404,1334, 34100,1405,1335, 34090,1395,1325, 1333,1406,1336, 34102,1407,1337, 
34103,1408,1338, 34091,1396,1326, 1336,1409,1339, 34092,1397,1327, 1337,1410,1340, 34106,1411,1341, 34107,1412,1342, 34094,1399,1329, 34093,1398,1328, 
23, // chain 264
236,1413,237, 1340,1414,1343, 1341,1415,1344, 
235,1416,236, 33062,1417,295, 34110,1418,1345, 34111,1419,1346, 34112,1420,1347, 34113,1421,1348, 34108,1414,1343, 1346,1422,1349, 33004,1413,237, 234,1423,235, 1347,1424,1350, 33000,1425,233, 226,1426,227, 1348,1427,1351, 32993,1428,226, 1349,1429,1352, 
33095,1430,328, 1350,1431,1353, 33136,1432,369, 1351,1433,1354, 34120,1434,1355, 33097,1435,330, 
10, // chain 265
1353,1436,1356, 1354,1437,1357, 1355,1438,1358, 
1282,1351,1285, 34049,1350,1284, 34066,1367,1301, 34124,1439,1359, 34122,1437,1357, 1357,1440,1360, 34126,1441,1361, 34127,1442,1362, 34128,1443,1363, 
22, // chain 266
1361,1444,1364, 1291,1360,1294, 1292,1361,1295, 
1362,1445,1365, 34131,1446,1366, 34132,1447,1367, 34061,1362,1296, 1294,1363,1297, 1365,1448,1368, 34063,1364,1298, 1366,1449,1369, 34113,1421,1348, 34064,1365,1299, 1297,1366,1300, 1344,1420,1347, 34066,1367,1301, 1343,1419,1346, 34124,1439,1359, 1357,1440,1360, 
333,1450,334, 34135,1451,1370, 34136,1452,1371, 34137,1453,1372, 34126,1441,1361, 
25, // chain 267
1333,1406,1336, 1334,1407,1337, 1370,1454,1373, 
1371,1455,1374, 34076,1380,1311, 34075,1379,1310, 34140,1456,1375, 34102,1407,1337, 1361,1444,1364, 34141,1457,1376, 34142,1458,1377, 34103,1408,1338, 1336,1409,1339, 1337,1410,1340, 1375,1459,1378, 34144,1460,1379, 34145,1461,1380, 34146,1462,1381, 34147,1463,1382, 
34106,1411,1341, 1380,1464,1383, 34149,1465,1384, 34107,1412,1342, 1382,1466,1385, 34151,1467,1386, 34095,1400,1330, 34094,1399,1329, 
36, // chain 268
1384,1468,1387, 1385,1469,1388, 1386,1470,1389, 
1387,1471,1390, 34156,1472,1391, 34153,1469,1388, 1389,1473,1392, 34158,1474,1393, 34159,1475,1394, 34160,1476,1395, 34152,1468,1387, 1393,1477,1396, 34162,1478,1397, 34163,1479,1398, 34155,1471,1390, 1219,1480,1222, 34164,1481,1399, 34156,1472,1391, 1397,1482,1400, 
34157,1473,1392, 1398,1483,1401, 34097,1402,1332, 34158,1474,1393, 1328,1401,1331, 34167,1484,1402, 34159,1475,1394, 1032,1485,1035, 33799,1486,1034, 34168,1487,1403, 34160,1476,1395, 1179,1488,1182, 34161,1477,1396, 1178,1489,1181, 33945,1490,1180, 34162,1478,1397, 
1181,1491,1184, 34163,1479,1398, 1219,1480,1222, 
16, // chain 269
1401,1492,1404, 1351,1433,1354, 1402,1493,1405, 
1403,1494,1406, 34133,1448,1368, 34132,1447,1367, 34131,1446,1366, 34172,1495,1407, 34173,1496,1408, 34119,1433,1354, 1406,1497,1409, 34175,1498,1410, 34120,1434,1355, 1408,1499,1411, 33019,1500,252, 1262,1501,1265, 34177,1502,1412, 34178,1503,1413, 
23, // chain 270
1411,1504,1414, 1312,1385,1315, 1311,1384,1314, 
1412,1505,1415, 34181,1506,1416, 34078,1383,1313, 1414,1507,1417, 34183,1508,1418, 34184,1509,1419, 34081,1386,1316, 1417,1510,1420, 34082,1387,1317, 1418,1511,1421, 34187,1512,1422, 34083,1388,1318, 1420,1513,1423, 1421,1514,1424, 34051,1352,1286, 34190,1515,1425, 
34191,1516,1426, 1424,1517,1427, 1283,1352,1286, 34121,1436,1356, 34193,1518,1428, 1354,1437,1357, 
9, // chain 271
1198,1519,1201, 1219,1480,1222, 1396,1481,1399, 
1426,1520,1429, 34165,1482,1400, 1427,1521,1430, 34166,1483,1401, 1428,1522,1431, 34099,1404,1334, 34097,1402,1332, 1330,1403,1333, 
7, // chain 272
1374,1458,1377, 1375,1459,1378, 1429,1523,1432, 
1373,1457,1376, 34058,1359,1293, 34198,1524,1433, 34145,1461,1380, 34144,1460,1379, 34143,1459,1378, 
18, // chain 273
1408,1499,1411, 1262,1501,1265, 1188,1525,1191, 
1407,1498,1410, 34174,1497,1409, 34199,1526,1434, 34200,1527,1435, 34201,1528,1436, 33821,1529,1056, 1054,1530,1057, 1432,1527,1435, 34006,1531,1241, 1085,1532,1088, 1431,1526,1434, 33854,1533,1089, 1434,1534,1437, 33852,1535,1087, 1435,1536,1438, 33849,1537,1084, 
33850,1538,1085, 
16, // chain 274
1436,1539,1439, 1437,1540,1440, 1438,1541,1441, 
1439,1542,1442, 34208,1543,1443, 34072,1376,1307, 33704,1544,939, 33845,1545,1080, 34205,1540,1440, 1441,1546,1444, 34210,1547,1445, 34204,1539,1439, 1443,1548,1446, 34074,1378,1309, 34073,1377,1308, 34207,1542,1442, 1304,1376,1307, 34208,1543,1443, 
11, // chain 275
1404,1495,1407, 1444,1549,1447, 1445,1550,1448, 
1362,1445,1365, 34140,1456,1375, 34211,1548,1446, 34210,1547,1445, 34212,1549,1447, 1434,1534,1437, 34199,1526,1434, 34214,1551,1449, 34173,1496,1408, 34172,1495,1407, 
2, // chain 276
1291,1360,1294, 1361,1444,1364, 1373,1457,1376, 
1290,1359,1293, 
3, // chain 277
1447,1552,1450, 197,1553,198, 301,1554,302, 
333,1450,334, 1367,1451,1370, 
15, // chain 278
1377,1461,1380, 1378,1462,1381, 1448,1555,1451, 
34182,1507,1417, 34217,1556,1452, 34147,1463,1382, 1380,1464,1383, 1413,1506,1416, 34180,1505,1415, 34149,1465,1384, 1450,1557,1453, 34150,1466,1385, 1451,1558,1454, 34151,1467,1386, 1452,1559,1455, 34096,1401,1331, 34095,1400,1330, 
2, // chain 279
1284,1353,1287, 1285,1354,1288, 1421,1514,1424, 
1283,1352,1286, 
2, // chain 280
1241,1560,1244, 1308,1380,1311, 1309,1381,1312, 
1003,1382,1006, 
11, // chain 281
1419,1512,1422, 1421,1514,1424, 1285,1354,1288, 
1286,1355,1289, 1418,1511,1421, 34055,1356,1290, 1417,1510,1420, 34221,1561,1456, 34056,1357,1291, 1289,1358,1292, 1454,1562,1457, 34198,1524,1433, 34058,1359,1293, 
3, // chain 282
1441,1546,1444, 1435,1536,1438, 1080,1563,1083, 
1079,1564,1082, 1077,1545,1080, 
2, // chain 283
1442,1547,1445, 1434,1534,1437, 1435,1536,1438, 
1441,1546,1444, 
11, // chain 284
1242,1565,1245, 1455,1566,1458, 1456,1567,1459, 
1371,1455,1374, 34100,1405,1335, 34196,1522,1431, 34194,1520,1429, 34225,1568,1460, 34223,1566,1458, 1197,1569,1200, 34011,1570,1246, 33964,1571,1199, 34010,1565,1245, 
1, // chain 285
1333,1406,1336, 1371,1455,1374, 1332,1405,1335, 
2, // chain 286
333,1450,334, 294,1417,295, 1342,1418,1345, 
1343,1419,1346, 
4, // chain 287
1401,1492,1404, 1403,1494,1406, 1349,1429,1352, 
34116,1427,1351, 34134,1449,1369, 34133,1448,1368, 
1, // chain 288
937,1375,940, 1304,1376,1307, 936,1544,939, 
11, // chain 289
1453,1561,1456, 1454,1562,1457, 1458,1572,1461, 
34227,1573,1462, 34198,1524,1433, 1377,1461,1380, 1448,1555,1451, 1414,1507,1417, 1415,1508,1418, 1458,1572,1461, 34184,1509,1419, 1417,1510,1420, 1453,1561,1456, 
1, // chain 290
1353,1436,1356, 1282,1351,1285, 1283,1352,1286, 
2, // chain 291
1308,1380,1311, 1241,1560,1244, 1371,1455,1374, 
34010,1565,1245, 
2, // chain 292
1351,1433,1354, 1401,1492,1404, 1350,1431,1353, 
34117,1429,1352, 
1, // chain 293
1331,1404,1334, 1332,1405,1335, 1428,1522,1431, 
2, // chain 294
1457,1568,1460, 1197,1569,1200, 1426,1520,1429, 
33966,1519,1201, 
3, // chain 295
1316,1389,1319, 1460,1574,1463, 1461,1575,1464, 
1315,1388,1318, 34230,1576,1465, 
2, // chain 296
1450,1557,1453, 1463,1577,1466, 1411,1504,1414, 
1412,1505,1415, 
2, // chain 297
1452,1559,1455, 1464,1578,1467, 1451,1558,1454, 
34218,1557,1453, 
1, // chain 298
1187,1579,1190, 1188,1525,1191, 1262,1501,1265, 
2, // chain 299
1306,1378,1309, 1307,1379,1310, 1372,1456,1375, 
1443,1548,1446, 
1, // chain 300
1362,1445,1365, 1363,1446,1366, 1404,1495,1407, 
5, // chain 301
1399,1484,1402, 1032,1485,1035, 1465,1580,1468, 
1328,1401,1331, 34220,1559,1455, 34232,1581,1467, 33800,1582,1035, 
3, // chain 302
1411,1504,1414, 1463,1577,1466, 1466,1583,1469, 
1467,1584,1470, 1468,1585,1471, 
1, // chain 303
1449,1556,1452, 1413,1506,1416, 1414,1507,1417, 
3, // chain 304
1345,1421,1348, 1346,1422,1349, 1366,1449,1369, 
34115,1424,1350, 1348,1427,1351, 
1, // chain 305
1080,1563,1083, 1435,1536,1438, 1081,1537,1084, 
1, // chain 306
1400,1487,1403, 1179,1488,1182, 1031,1486,1034, 
2, // chain 307
1431,1526,1434, 1446,1551,1449, 1406,1497,1409, 
34173,1496,1408, 
1, // chain 308
1469,1586,1472, 1463,1577,1466, 1450,1557,1453, 
1, // chain 309
1361,1444,1364, 1362,1445,1365, 1372,1456,1375, 
1, // chain 310
1428,1522,1431, 1426,1520,1429, 1427,1521,1430, 
43, // chain 311
1470,1587,1473, 1471,1588,1474, 1472,1589,1475, 
1473,1590,1476, 34242,1591,1477, 34243,1592,1478, 34244,1593,1479, 34239,1588,1474, 1477,1594,1480, 34246,1595,1481, 34238,1587,1473, 1479,1596,1482, 34248,1597,1483, 34249,1598,1484, 34241,1590,1476, 1482,1599,1485, 34251,1600,1486, 34252,1601,1487, 34242,1591,1477, 
1485,1602,1488, 34254,1603,1489, 34243,1592,1478, 1487,1604,1490, 34256,1605,1491, 34244,1593,1479, 1489,1606,1492, 34258,1607,1493, 34259,1608,1494, 34260,1609,1495, 34261,1610,1496, 34245,1594,1480, 1494,1611,1497, 34263,1612,1498, 34246,1595,1481, 1496,1613,1499, 
34265,1614,1500, 34266,1615,1501, 34247,1596,1482, 1499,1616,1502, 34248,1597,1483, 1500,1617,1503, 34269,1618,1504, 34270,1619,1505, 34250,1599,1485, 34249,1598,1484, 
3, // chain 312
1503,1620,1506, 1504,1621,1507, 1505,1622,1508, 
1255,1623,1258, 33901,1624,1136, 
45, // chain 313
1506,1625,1509, 1507,1626,1510, 1508,1627,1511, 
1509,1628,1512, 34278,1629,1513, 34275,1626,1510, 1511,1630,1514, 34280,1631,1515, 34281,1632,1516, 34282,1633,1517, 34274,1625,1509, 1515,1634,1518, 34284,1635,1519, 34285,1636,1520, 34286,1637,1521, 34277,1628,1512, 1519,1638,1522, 34288,1639,1523, 34278,1629,1513, 
1521,1640,1524, 34290,1641,1525, 34279,1630,1514, 1523,1642,1526, 34292,1643,1527, 34280,1631,1515, 1505,1644,1508, 34293,1645,1528, 34281,1632,1516, 1514,1633,1517, 1132,1646,1135, 33899,1647,1134, 34283,1634,1518, 1516,1635,1519, 1130,1648,1133, 34021,1649,1256, 
34294,1650,1529, 34285,1636,1520, 1527,1651,1530, 34296,1652,1531, 34286,1637,1521, 1529,1653,1532, 34298,1654,1533, 34287,1638,1522, 1531,1655,1534, 34300,1656,1535, 34289,1640,1524, 34288,1639,1523, 
18, // chain 314
1533,1657,1536, 1534,1658,1537, 1535,1659,1538, 
1536,1660,1539, 34017,1661,1252, 34018,1662,1253, 34305,1663,1540, 34302,1658,1537, 1538,1664,1541, 34307,1665,1542, 34308,1666,1543, 34309,1667,1544, 34301,1657,1536, 1542,1668,1545, 34311,1669,1546, 34304,1660,1539, 1544,1670,1547, 33726,1671,961, 34016,1672,1251, 
34017,1661,1252, 
2, // chain 315
1545,1673,1548, 1546,1674,1549, 1547,1675,1550, 
1548,1676,1551, 
51, // chain 316
1549,1677,1552, 1550,1678,1553, 1551,1679,1554, 
1552,1680,1555, 34321,1681,1556, 34322,1682,1557, 34323,1683,1558, 34318,1678,1553, 1556,1684,1559, 34325,1685,1560, 34326,1686,1561, 34327,1687,1562, 34317,1677,1552, 1560,1688,1563, 34329,1689,1564, 34330,1690,1565, 34320,1680,1555, 1563,1691,1566, 34332,1692,1567, 
34321,1681,1556, 1529,1653,1532, 34333,1693,1568, 34334,1694,1569, 34322,1682,1557, 1567,1695,1570, 34323,1683,1558, 1568,1696,1571, 34324,1684,1559, 1557,1685,1560, 1569,1697,1572, 34338,1698,1573, 34339,1699,1574, 34326,1686,1561, 1572,1700,1575, 34341,1701,1576, 
34342,1702,1577, 34327,1687,1562, 1575,1703,1578, 34328,1688,1563, 1576,1704,1579, 34345,1705,1580, 34329,1689,1564, 1578,1706,1581, 34347,1707,1582, 34330,1690,1565, 1580,1708,1583, 34331,1691,1566, 1581,1709,1584, 34350,1710,1585, 34299,1655,1534, 34332,1692,1567, 
1530,1654,1533, 34297,1653,1532, 
13, // chain 317
1583,1711,1586, 1584,1712,1587, 1585,1713,1588, 
1586,1714,1589, 34355,1715,1590, 34356,1716,1591, 34357,1717,1592, 34352,1712,1587, 1590,1718,1593, 34359,1719,1594, 34360,1720,1595, 34361,1721,1596, 34351,1711,1586, 1594,1722,1597, 34354,1714,1589, 
14, // chain 318
1595,1723,1598, 1596,1724,1599, 1597,1725,1600, 
1598,1726,1601, 34367,1727,1602, 34368,1728,1603, 34369,1729,1604, 34370,1730,1605, 34364,1724,1599, 1603,1731,1606, 34372,1732,1607, 34363,1723,1598, 1605,1733,1608, 33863,1734,1098, 34374,1735,1609, 34366,1726,1601, 
31, // chain 319
1607,1736,1610, 1608,1737,1611, 1609,1738,1612, 
1610,1739,1613, 34379,1740,1614, 34380,1741,1615, 34381,1742,1616, 34382,1743,1617, 34376,1737,1611, 1615,1744,1618, 33976,1745,1211, 34384,1746,1619, 34385,1747,1620, 34386,1748,1621, 34375,1736,1610, 1619,1749,1622, 34388,1750,1623, 34378,1739,1613, 1611,1740,1614, 
1621,1751,1624, 34380,1741,1615, 1622,1752,1625, 34391,1753,1626, 34392,1754,1627, 34381,1742,1616, 1050,1755,1053, 34020,1756,1255, 34382,1743,1617, 1048,1757,1051, 34393,1758,1628, 34383,1744,1618, 1046,1759,1049, 33976,1745,1211, 
34, // chain 320
1626,1760,1629, 1483,1600,1486, 1627,1761,1630, 
1628,1762,1631, 34397,1763,1632, 34398,1764,1633, 34251,1600,1486, 1631,1765,1634, 34252,1601,1487, 1632,1766,1635, 34253,1602,1488, 1633,1767,1636, 34402,1768,1637, 34254,1603,1489, 1635,1769,1638, 34404,1770,1639, 34255,1604,1490, 1637,1771,1640, 34256,1605,1491, 
1638,1772,1641, 34257,1606,1492, 1639,1773,1642, 34258,1607,1493, 1640,1774,1643, 34259,1608,1494, 1641,1775,1644, 34410,1776,1645, 34260,1609,1495, 1619,1749,1622, 34261,1610,1496, 1618,1748,1621, 34262,1611,1497, 1617,1747,1620, 34263,1612,1498, 1643,1777,1646, 
34264,1613,1499, 
34, // chain 321
1644,1778,1647, 1645,1779,1648, 1538,1664,1541, 
1622,1752,1625, 34414,1780,1649, 34415,1781,1650, 34307,1665,1542, 1640,1774,1643, 34407,1773,1642, 34308,1666,1543, 1638,1772,1641, 34309,1667,1544, 1648,1782,1651, 34310,1668,1545, 1566,1694,1569, 34333,1693,1568, 34311,1669,1546, 1649,1783,1652, 34312,1670,1547, 
1650,1784,1653, 33726,1671,961, 1261,1785,1264, 1651,1786,1654, 33727,1787,962, 1253,1649,1256, 1526,1650,1529, 1652,1788,1655, 34295,1651,1530, 1653,1789,1656, 34296,1652,1531, 1529,1653,1532, 1565,1693,1568, 1649,1783,1652, 1652,1788,1655, 34418,1784,1653, 
1651,1786,1654, 
24, // chain 322
1654,1790,1657, 1655,1791,1658, 1656,1792,1659, 
1602,1730,1605, 34369,1729,1604, 34425,1793,1660, 34423,1791,1658, 1658,1794,1661, 34427,1795,1662, 34339,1699,1574, 34338,1698,1573, 34422,1790,1657, 1569,1697,1572, 34428,1796,1663, 34429,1797,1664, 34370,1730,1605, 1662,1798,1665, 34397,1763,1632, 34371,1731,1606, 
1663,1799,1666, 34372,1732,1607, 1664,1800,1667, 34373,1733,1608, 1524,1801,1527, 34291,1802,1526, 33863,1734,1098, 
13, // chain 323
970,1803,973, 1665,1804,1668, 1666,1805,1669, 
969,1806,972, 34435,1807,1670, 34436,1808,1671, 34344,1704,1579, 34433,1804,1668, 1669,1809,1672, 34438,1810,1673, 34439,1811,1674, 34028,1812,1263, 33738,1803,973, 1222,1813,1225, 33514,1814,749, 
11, // chain 324
1672,1815,1675, 1573,1701,1576, 1673,1816,1676, 
1674,1817,1677, 34443,1818,1678, 34444,1819,1679, 34445,1820,1680, 34446,1821,1681, 34438,1810,1673, 34437,1809,1672, 34343,1703,1578, 34342,1702,1577, 34341,1701,1576, 
5, // chain 325
1679,1822,1682, 1675,1818,1678, 1680,1823,1683, 
1681,1824,1684, 34450,1825,1685, 34444,1819,1679, 34443,1818,1678, 
13, // chain 326
1683,1826,1686, 1684,1827,1687, 1685,1828,1688, 
1630,1764,1633, 34454,1829,1689, 34455,1830,1690, 34456,1831,1691, 34452,1827,1687, 1689,1832,1692, 34458,1833,1693, 34401,1767,1636, 34451,1826,1686, 1632,1766,1635, 34398,1764,1633, 1631,1765,1634, 
2, // chain 327
1641,1775,1644, 1642,1776,1645, 1620,1750,1623, 
34387,1749,1622, 
4, // chain 328
1582,1710,1585, 1531,1655,1534, 1532,1656,1535, 
1691,1834,1694, 34290,1641,1525, 34289,1640,1524, 
3, // chain 329
1667,1807,1670, 1692,1835,1695, 1225,1836,1228, 
968,1837,971, 969,1806,972, 
10, // chain 330
1693,1838,1696, 1694,1839,1697, 1592,1720,1595, 
34359,1719,1594, 34463,1840,1698, 1696,1841,1699, 34315,1675,1550, 1546,1674,1549, 1697,1842,1700, 34466,1843,1701, 34467,1844,1702, 34313,1673,1548, 
2, // chain 331
1572,1700,1575, 1700,1845,1703, 1659,1795,1662, 
1571,1699,1574, 
16, // chain 332
1682,1825,1685, 1676,1819,1679, 1590,1718,1593, 
1701,1846,1704, 34359,1719,1594, 1696,1841,1699, 1682,1825,1685, 34449,1824,1684, 34470,1847,1705, 34471,1848,1706, 34465,1842,1700, 1704,1849,1707, 34425,1793,1660, 34473,1850,1708, 34466,1843,1701, 1706,1851,1709, 34475,1852,1710, 34467,1844,1702, 
9, // chain 333
1483,1600,1486, 1626,1760,1629, 1708,1853,1711, 
1482,1599,1485, 34270,1619,1505, 34271,1620,1506, 34477,1854,1712, 34394,1760,1629, 1663,1799,1666, 34396,1762,1631, 1629,1763,1632, 
3, // chain 334
1710,1855,1713, 1263,1856,1266, 1578,1706,1581, 
1580,1708,1583, 34347,1707,1582, 
4, // chain 335
1710,1855,1713, 1580,1708,1583, 1170,1857,1173, 
1169,1858,1172, 1171,1859,1174, 1263,1856,1266, 
6, // chain 336
1711,1860,1714, 1679,1822,1682, 1681,1824,1684, 
1702,1847,1705, 1703,1848,1706, 1704,1849,1707, 1658,1794,1661, 34425,1793,1660, 
3, // chain 337
1709,1854,1712, 1663,1799,1666, 1664,1800,1667, 
1504,1621,1507, 1503,1620,1506, 
5, // chain 338
956,1861,959, 1251,1862,1254, 1712,1863,1715, 
34413,1779,1648, 34481,1864,1716, 34305,1663,1540, 34018,1662,1253, 
14, // chain 339
1676,1819,1679, 1677,1820,1680, 1714,1865,1717, 
1715,1866,1718, 34484,1867,1719, 34485,1868,1720, 34445,1820,1680, 1678,1821,1681, 1718,1869,1721, 34438,1810,1673, 1671,1811,1674, 1158,1870,1161, 33927,1871,1162, 33935,1872,1170, 34028,1812,1263, 1166,1873,1169, 
5, // chain 340
1629,1763,1632, 1630,1764,1633, 1719,1874,1722, 
1662,1798,1665, 34429,1797,1664, 34454,1829,1689, 34398,1764,1633, 
3, // chain 341
1052,1875,1055, 1644,1778,1647, 1623,1753,1626, 
1050,1755,1053, 34392,1754,1627, 
6, // chain 342
1691,1834,1694, 1091,1876,1094, 1720,1877,1723, 
1581,1709,1584, 34489,1878,1724, 34012,1879,1247, 33857,1880,1092, 33859,1876,1094, 
2, // chain 343
1538,1664,1541, 1645,1779,1648, 1713,1864,1716, 
1537,1663,1540, 
2, // chain 344
1722,1881,1725, 1723,1882,1726, 1500,1617,1503, 
34267,1616,1502, 
3, // chain 345
1578,1706,1581, 1692,1835,1695, 1668,1808,1671, 
1577,1705,1580, 34344,1704,1579, 
2, // chain 346
1599,1727,1602, 1705,1850,1708, 1706,1851,1709, 
1724,1883,1727, 
2, // chain 347
1648,1782,1651, 1636,1770,1639, 1637,1771,1640, 
1638,1772,1641, 
3, // chain 348
1502,1619,1505, 1503,1620,1506, 1725,1884,1728, 
34494,1885,1729, 34023,1623,1258, 
2, // chain 349
1133,1886,1136, 1505,1644,1508, 1525,1645,1528, 
1132,1646,1135, 
5, // chain 350
1645,1779,1648, 1644,1778,1647, 1727,1887,1730, 
1712,1863,1715, 33724,1861,959, 33820,1875,1055, 34412,1778,1647, 
4, // chain 351
1700,1845,1703, 1672,1815,1675, 1679,1822,1682, 
1711,1860,1714, 1658,1794,1661, 1659,1795,1662, 
3, // chain 352
1721,1878,1724, 1088,1888,1091, 1170,1857,1173, 
1581,1709,1584, 34348,1708,1583, 
8, // chain 353
1728,1889,1731, 1729,1890,1732, 1730,1891,1733, 
1716,1867,1719, 34499,1892,1734, 34500,1893,1735, 1589,1717,1592, 1590,1718,1593, 1715,1866,1718, 34444,1819,1679, 
7, // chain 354
1733,1894,1736, 1734,1895,1737, 1718,1869,1721, 
1158,1870,1161, 1157,1896,1160, 1734,1895,1737, 34503,1897,1738, 34504,1898,1739, 34505,1899,1740, 
4, // chain 355
1092,1900,1095, 1091,1876,1094, 1095,1901,1098, 
34459,1834,1694, 1523,1642,1526, 34290,1641,1525, 
6, // chain 356
1568,1696,1571, 1569,1697,1572, 1567,1695,1570, 
34506,1902,1741, 34428,1796,1663, 1687,1830,1690, 34429,1797,1664, 1686,1829,1689, 
6, // chain 357
1647,1781,1650, 1640,1774,1643, 1641,1775,1644, 
1739,1903,1742, 34388,1750,1623, 1621,1751,1624, 1646,1780,1649, 34390,1752,1625, 
1, // chain 358
1599,1727,1602, 1740,1904,1743, 1598,1726,1601, 
2, // chain 359
1664,1905,1667, 1524,1643,1527, 1504,1906,1507, 
34273,1644,1508, 
8, // chain 360
1690,1833,1693, 1635,1769,1638, 1636,1770,1639, 
1648,1782,1651, 1566,1694,1569, 1689,1832,1692, 34335,1695,1570, 1688,1831,1691, 34506,1902,1741, 1687,1830,1690, 
3, // chain 361
1600,1728,1603, 1601,1729,1604, 1657,1793,1660, 
1705,1850,1708, 1599,1727,1602, 
2, // chain 362
1674,1817,1677, 1675,1818,1678, 1679,1822,1682, 
1672,1815,1675, 
4, // chain 363
1209,1907,1212, 1208,1745,1211, 1616,1746,1619, 
1741,1908,1744, 34385,1747,1620, 1643,1777,1646, 
2, // chain 364
1263,1856,1266, 1225,1836,1228, 1692,1835,1695, 
1578,1706,1581, 
2, // chain 365
1502,1619,1505, 1725,1884,1728, 1742,1909,1745, 
1501,1618,1504, 
2, // chain 366
1625,1758,1628, 1046,1759,1049, 1047,1910,1050, 
1048,1757,1051, 
3, // chain 367
1728,1889,1731, 1734,1895,1737, 1735,1897,1738, 
1743,1911,1746, 1729,1890,1732, 
3, // chain 368
1734,1895,1737, 1728,1889,1731, 1718,1869,1721, 
34485,1868,1720, 34484,1867,1719, 
2, // chain 369
1634,1768,1637, 1635,1769,1638, 1633,1767,1636, 
34458,1833,1693, 
3, // chain 370
1159,1871,1162, 1167,1872,1170, 1165,1912,1168, 
1163,1913,1166, 1160,1914,1163, 
1, // chain 371
1731,1892,1734, 1715,1866,1718, 1716,1867,1719, 
2, // chain 372
1700,1845,1703, 1572,1700,1575, 1672,1815,1675, 
34341,1701,1576, 
1, // chain 373
1248,1672,1251, 1258,1915,1261, 958,1671,961, 
1, // chain 374
1501,1618,1504, 1722,1881,1725, 1500,1617,1503, 
1, // chain 375
1692,1835,1695, 1667,1807,1670, 1668,1808,1671, 
1, // chain 376
1582,1710,1585, 1691,1834,1694, 1581,1709,1584, 
1, // chain 377
1647,1781,1650, 1739,1903,1742, 1646,1780,1649, 
1, // chain 378
1088,1888,1091, 1721,1878,1724, 1244,1879,1247, 
1, // chain 379
1575,1703,1578, 1576,1704,1579, 1669,1809,1672, 
1, // chain 380
1622,1752,1625, 1623,1753,1626, 1644,1778,1647, 
1, // chain 381
1744,1916,1747, 1498,1615,1501, 1499,1616,1502, 
1, // chain 382
1593,1721,1596, 1693,1838,1696, 1592,1720,1595, 
12, // chain 383
1745,1917,1748, 1746,1918,1749, 1747,1919,1750, 
1748,1920,1751, 34517,1921,1752, 34518,1922,1753, 34519,1923,1754, 34520,1924,1755, 34521,1925,1756, 33995,1926,1230, 34522,1927,1757, 34523,1928,1758, 34524,1929,1759, 34514,1918,1749, 
8, // chain 384
1757,1930,1760, 1256,1931,1259, 1135,1932,1138, 
1137,1933,1140, 1758,1934,1761, 34527,1935,1762, 33861,1936,1096, 1094,1937,1097, 1606,1938,1609, 33863,1939,1098, 
77, // chain 385
1760,1940,1763, 1761,1941,1764, 1762,1942,1765, 
1763,1943,1766, 34532,1944,1767, 34529,1941,1764, 1765,1945,1768, 34534,1946,1769, 34535,1947,1770, 34536,1948,1771, 34528,1940,1763, 1769,1949,1772, 34538,1950,1773, 34531,1943,1766, 1771,1951,1774, 34540,1952,1775, 34532,1944,1767, 1773,1953,1776, 34542,1954,1777, 
34533,1945,1768, 1775,1955,1778, 34544,1956,1779, 34545,1957,1780, 34546,1958,1781, 34547,1959,1782, 34534,1946,1769, 1780,1960,1783, 34535,1947,1770, 1768,1948,1771, 1781,1961,1784, 34550,1962,1785, 34551,1963,1786, 34552,1964,1787, 34537,1949,1772, 1367,1965,1370, 
34553,1966,1788, 34538,1950,1773, 1447,1967,1450, 32966,1968,199, 32969,1969,202, 34539,1951,1774, 203,1970,204, 34540,1952,1775, 1786,1971,1789, 34541,1953,1776, 1787,1972,1790, 34542,1954,1777, 1788,1973,1791, 34557,1974,1792, 34543,1955,1778, 1790,1975,1793, 
34559,1976,1794, 34544,1956,1779, 1792,1977,1795, 34561,1978,1796, 34545,1957,1780, 1794,1979,1797, 34563,1980,1798, 34546,1958,1781, 1796,1981,1799, 34565,1982,1800, 34566,1983,1801, 34547,1959,1782, 1799,1984,1802, 34568,1985,1803, 34548,1960,1783, 1781,1961,1784, 
1801,1986,1804, 34550,1962,1785, 1802,1987,1805, 34571,1988,1806, 34572,1989,1807, 34128,1990,1363, 34127,1991,1362, 34551,1963,1786, 1358,1992,1361, 34137,1993,1372, 34552,1964,1787, 1368,1994,1371, 
10, // chain 386
827,1995,830, 999,1996,1002, 1060,1997,1063, 
34573,1998,1808, 34574,1999,1809, 34575,2000,1810, 34008,2001,1243, 1808,2002,1811, 33872,2003,1107, 1106,2004,1109, 1139,2005,1142, 33761,2006,996, 
4, // chain 387
1809,2007,1812, 1810,2008,1813, 1811,2009,1814, 
1812,2010,1815, 34581,2011,1816, 34582,2012,1817, 
7, // chain 388
1797,1982,1800, 1798,1983,1801, 1815,2013,1818, 
34584,2014,1819, 34567,1984,1802, 1817,2015,1820, 34586,2016,1821, 34569,1986,1804, 34568,1985,1803, 
45, // chain 389
1819,2017,1822, 1820,2018,1823, 1821,2019,1824, 
1822,2020,1825, 34591,2021,1826, 34592,2022,1827, 34593,2023,1828, 34594,2024,1829, 34588,2018,1823, 1827,2025,1830, 34596,2026,1831, 34597,2027,1832, 34587,2017,1822, 1830,2028,1833, 34599,2029,1834, 34600,2030,1835, 34601,2031,1836, 34590,2020,1825, 1834,2032,1837, 
34603,2033,1838, 34604,2034,1839, 34591,2021,1826, 1837,2035,1840, 34606,2036,1841, 34607,2037,1842, 34592,2022,1827, 1840,2038,1843, 34593,2023,1828, 1841,2039,1844, 34594,2024,1829, 1827,2025,1830, 1842,2040,1845, 34596,2026,1831, 1843,2041,1846, 34612,2042,1847, 
34613,2043,1848, 34614,2044,1849, 34615,2045,1850, 34597,2027,1832, 1848,2046,1851, 34617,2047,1852, 34598,2028,1833, 1850,2048,1853, 1851,2049,1854, 1852,2050,1855, 1853,2051,1856, 34622,2052,1857, 
24, // chain 390
1855,2053,1858, 1856,2054,1859, 1857,2055,1860, 
1858,2056,1861, 34627,2057,1862, 34628,2058,1863, 34265,2059,1500, 34629,2060,1864, 34624,2054,1859, 1496,2061,1499, 34411,2062,1646, 34509,2063,1744, 34630,2064,1865, 34623,2053,1858, 1863,2065,1866, 34632,2066,1867, 34633,2067,1868, 34626,2056,1861, 1866,2068,1869, 
34614,2044,1849, 34613,2043,1848, 34627,2057,1862, 1867,2069,1870, 34628,2058,1863, 1498,2070,1501, 34265,2059,1500, 
5, // chain 391
1868,2071,1871, 1869,2072,1872, 1736,2073,1739, 
1870,2074,1873, 34505,2075,1740, 1156,2076,1159, 33925,2077,1160, 
12, // chain 392
1871,2078,1874, 1872,2079,1875, 1873,2080,1876, 
1874,2081,1877, 34643,2082,1878, 34644,2083,1879, 34645,2084,1880, 34646,2085,1881, 34640,2079,1875, 1879,2086,1882, 34648,2087,1883, 33801,2088,1036, 34639,2078,1874, 1032,2089,1035, 
8, // chain 393
1881,2090,1884, 1882,2091,1885, 1809,2007,1812, 
1883,2092,1886, 34652,2093,1887, 34580,2010,1815, 1885,2094,1888, 34574,1999,1809, 34573,1998,1808, 34581,2011,1816, 
11, // chain 394
1150,2095,1153, 1149,2096,1152, 1886,2097,1889, 
34655,2098,1890, 33743,2099,978, 1888,2100,1891, 33744,2101,979, 1889,2102,1892, 34658,2103,1893, 33997,2104,1232, 1891,2105,1894, 33474,2106,709, 1259,2107,1262, 
25, // chain 395
1892,2108,1895, 1893,2109,1896, 1894,2110,1897, 
1895,2111,1898, 34664,2112,1899, 34665,2113,1900, 34666,2114,1901, 34661,2109,1896, 1899,2115,1902, 34668,2116,1903, 34669,2117,1904, 34670,2118,1905, 34671,2119,1906, 34672,2120,1907, 34660,2108,1895, 1905,2121,1908, 34674,2122,1909, 34675,2123,1910, 34663,2111,1898, 
1908,2124,1911, 34677,2125,1912, 34678,2126,1913, 34679,2127,1914, 34664,2112,1899, 1912,2128,1915, 1913,2129,1916, 34682,2130,1917, 
8, // chain 396
1802,1987,1805, 1424,2131,1427, 1915,2132,1918, 
1801,1986,1804, 34684,2133,1919, 34230,2134,1465, 34083,2135,1318, 34188,2136,1423, 34191,2137,1426, 34192,2131,1427, 
12, // chain 397
1318,2138,1321, 1312,2139,1315, 1411,2140,1414, 
1468,2141,1471, 1917,2142,1920, 34235,2143,1470, 1466,2144,1469, 1918,2145,1921, 34231,2146,1466, 1876,2083,1879, 34237,2147,1472, 1875,2082,1878, 34232,2148,1467, 34218,2149,1453, 
9, // chain 398
1919,2150,1922, 1920,2151,1923, 1921,2152,1924, 
1922,2153,1925, 34691,2154,1926, 34688,2155,1923, 1924,2156,1927, 1925,2157,1928, 1882,2091,1885, 34577,2007,1812, 34578,2008,1813, 
11, // chain 399
1817,2015,1820, 1926,2158,1929, 1927,2159,1930, 
1816,2014,1819, 34696,2160,1931, 34697,2161,1932, 34698,2162,1933, 34694,2158,1929, 1318,2138,1321, 34085,2163,1320, 34699,2164,1934, 34586,2016,1821, 34585,2015,1820, 
13, // chain 400
1729,2165,1732, 1869,2072,1872, 1932,2166,1935, 
1933,2167,1936, 34702,2168,1937, 34703,2169,1938, 34704,2170,1939, 34637,2072,1872, 1868,2071,1871, 1937,2171,1940, 34706,2172,1941, 34638,2074,1873, 1939,2173,1942, 33922,2174,1157, 33924,2076,1159, 
7, // chain 401
1940,2175,1943, 1941,2176,1944, 1942,2177,1945, 
1943,2178,1946, 34712,2179,1947, 34713,2180,1948, 1946,2181,1949, 34715,2182,1950, 34716,2183,1951, 
13, // chain 402
1587,2184,1590, 1588,2185,1591, 1949,2186,1952, 
1950,2187,1953, 34719,2188,1954, 34720,2189,1955, 34721,2190,1956, 34722,2191,1957, 34356,2185,1591, 1955,2192,1958, 34357,2193,1592, 1933,2167,1936, 34500,2194,1735, 1730,2195,1733, 1729,2165,1732, 
14, // chain 403
1845,2043,1848, 1723,2196,1726, 1956,2197,1959, 
1844,2042,1847, 34725,2198,1960, 34726,2199,1961, 34727,2200,1962, 34491,2196,1726, 1722,2201,1725, 1501,2202,1504, 1742,2203,1745, 1725,2204,1728, 1960,2205,1963, 1958,2199,1961, 34494,2206,1729, 34493,2207,1728, 
48, // chain 404
1961,2208,1964, 1962,2209,1965, 1963,2210,1966, 
1964,2211,1967, 34733,2212,1968, 34734,2213,1969, 34735,2214,1970, 34730,2209,1965, 1968,2215,1971, 34737,2216,1972, 34738,2217,1973, 34739,2218,1974, 34740,2219,1975, 34729,2208,1964, 1973,2220,1976, 34742,2221,1977, 34743,2222,1978, 34732,2211,1967, 1976,2223,1979, 
34745,2224,1980, 34746,2225,1981, 34747,2226,1982, 34733,2212,1968, 1980,2227,1983, 34749,2228,1984, 34734,2213,1969, 1967,2214,1970, 1968,2215,1971, 1982,2229,1985, 34751,2230,1986, 34737,2216,1972, 1984,2231,1987, 34753,2232,1988, 34754,2233,1989, 34755,2234,1990, 
34738,2217,1973, 1988,2235,1991, 34719,2188,1954, 34757,2236,1992, 34739,2218,1974, 1990,2237,1993, 34740,2219,1975, 1594,2238,1597, 34741,2220,1976, 1693,2239,1696, 34463,2240,1698, 34759,2241,1994, 34744,2223,1979, 34743,2222,1978, 34742,2221,1977, 
23, // chain 405
1902,2118,1905, 1903,2119,1906, 1992,2242,1995, 
34761,2243,1996, 34672,2120,1907, 1994,2244,1997, 34763,2245,1998, 34562,1979,1797, 34673,2121,1908, 1793,1978,1796, 34560,1977,1795, 34674,2122,1909, 1907,2123,1910, 1996,2246,1999, 34765,2247,2000, 34676,2124,1911, 1998,2248,2001, 34767,2249,2002, 34768,2250,2003, 
34677,2125,1912, 2001,2251,2004, 34678,2126,1913, 2002,2252,2005, 34679,2127,1914, 1913,2129,1916, 
13, // chain 406
2003,2253,2006, 1879,2086,1882, 2004,2254,2007, 
2005,2255,2008, 34774,2256,2009, 34775,2257,2010, 34776,2258,2011, 34647,2086,1882, 2009,2259,2012, 34648,2087,1883, 2010,2260,2013, 33801,2088,1036, 1016,2261,1019, 33783,2262,1018, 33796,2263,1031, 
18, // chain 407
2011,2264,2014, 2012,2265,2015, 2013,2266,2016, 
2014,2267,2017, 34783,2268,2018, 34784,2269,2019, 34785,2270,2020, 34786,2271,2021, 34787,2272,2022, 34780,2265,2015, 2020,2273,2023, 34789,2274,2024, 34779,2264,2014, 2022,2275,2025, 34606,2036,1841, 34782,2267,2017, 1837,2035,1840, 34783,2268,2018, 2023,2276,2026, 
34784,2269,2019, 
11, // chain 408
2024,2277,2027, 2025,2278,2028, 2026,2279,2029, 
1978,2225,1981, 34745,2224,1980, 34795,2280,2030, 34796,2281,2031, 34793,2278,2028, 1982,2229,1985, 34748,2227,1983, 34792,2277,2027, 1979,2226,1982, 34746,2225,1981, 
19, // chain 409
2029,2282,2032, 2030,2283,2033, 2031,2284,2034, 
2032,2285,2035, 34801,2286,2036, 34721,2190,1956, 34798,2283,2033, 2034,2287,2037, 1952,2189,1955, 34803,2288,2038, 34804,2289,2039, 34805,2290,2040, 2038,2291,2041, 2039,2292,2042, 34808,2293,2043, 2041,2294,2044, 2042,2295,2045, 2043,2296,2046, 34812,2297,2047, 
2019,2272,2022, 34786,2271,2021, 
11, // chain 410
1918,2145,1921, 2045,2298,2048, 2046,2299,2049, 
2047,2300,2050, 34816,2301,2051, 34817,2302,2052, 34818,2303,2053, 34819,2304,2054, 34813,2298,2048, 2052,2305,2055, 34645,2084,1880, 34644,2083,1879, 34686,2145,1921, 
9, // chain 411
1788,1973,1791, 1790,1975,1793, 2053,2306,2056, 
2054,2307,2057, 34823,2308,2058, 34824,2309,2059, 34558,1975,1793, 2057,2310,2060, 34559,1976,1794, 1996,2246,1999, 34560,1977,1795, 
6, // chain 412
2056,2309,2059, 2058,2311,2061, 2059,2312,2062, 
2055,2308,2058, 34828,2313,2063, 34829,2314,2064, 34830,2315,2065, 34826,2311,2061, 
5, // chain 413
2063,2316,2066, 2064,2317,2067, 2065,2318,2068, 
2066,2319,2069, 34835,2320,2070, 34836,2321,2071, 34837,2322,2072, 
24, // chain 414
1881,2090,1884, 1883,2092,1886, 2070,2323,2073, 
34652,2093,1887, 2071,2324,2074, 34840,2325,2075, 34653,2094,1888, 1806,1999,1809, 2073,2326,2076, 34575,2000,1810, 1808,2002,1811, 2074,2327,2077, 33907,2005,1142, 2071,2324,2074, 33906,2328,1141, 2075,2329,2078, 34844,2330,2079, 33952,2331,1187, 2077,2332,2080, 
33954,2333,1189, 2078,2334,2081, 34177,2335,1412, 1410,2336,1413, 2079,2337,2082, 32970,2338,203, 33019,2339,252, 
10, // chain 415
2080,2340,2083, 2081,2341,2084, 2082,2342,2085, 
2060,2313,2063, 34851,2343,2086, 34849,2341,2084, 2054,2307,2057, 34852,2344,2087, 34853,2345,2088, 34854,2346,2089, 34855,2347,2090, 34848,2340,2083, 
14, // chain 416
1947,2182,1950, 2064,2317,2067, 2063,2316,2066, 
1946,2181,1949, 34856,2348,2091, 34857,2349,2092, 34858,2350,2093, 34834,2319,2069, 2091,2351,2094, 34762,2244,1997, 34761,2243,1996, 34760,2242,1995, 34835,2320,2070, 1902,2118,1905, 34860,2352,2095, 34836,2321,2071, 
13, // chain 417
2093,2353,2096, 2057,2310,2060, 1996,2246,1999, 
1997,2247,2000, 1998,2248,2001, 2056,2309,2059, 34826,2311,2061, 34767,2249,2002, 2094,2354,2097, 34863,2355,2098, 34864,2356,2099, 34768,2250,2003, 2097,2357,2100, 34769,2251,2004, 2002,2252,2005, 
5, // chain 418
2098,2358,2101, 1940,2175,1943, 2099,2359,2102, 
2100,2360,2103, 34869,2361,2104, 34711,2178,1946, 34708,2175,1943, 
14, // chain 419
2102,2362,2105, 2103,2363,2106, 2104,2364,2107, 
2035,2288,2038, 34873,2365,2108, 34756,2235,1991, 34871,2363,2106, 1987,2234,1990, 34754,2233,1989, 34788,2273,2023, 34874,2366,2109, 34870,2362,2105, 2043,2296,2046, 34807,2292,2042, 34804,2289,2039, 34803,2288,2038, 
4, // chain 420
1878,2085,1881, 2003,2253,2006, 2107,2367,2110, 
2052,2305,2055, 34773,2255,2008, 34771,2253,2006, 
3, // chain 421
2105,2365,2108, 1988,2235,1991, 1951,2188,1954, 
1952,2189,1955, 2035,2288,2038, 
2, // chain 422
2108,2368,2111, 2109,2369,2112, 1837,2035,1840, 
2023,2276,2026, 
5, // chain 423
1796,1981,1799, 2091,2351,2094, 2110,2370,2113, 
1795,1980,1798, 34763,2245,1998, 34762,2244,1997, 34859,2351,2094, 
6, // chain 424
2007,2257,2010, 2008,2258,2011, 2009,2259,2012, 
2111,2371,2114, 33781,2372,1016, 33782,2373,1017, 34778,2260,2013, 1016,2261,1019, 
2, // chain 425
2032,2285,2035, 2112,2374,2115, 2113,2375,2116, 
2029,2282,2032, 
7, // chain 426
2114,2376,2117, 1786,1971,1789, 1787,1972,1790, 
2115,2377,2118, 34884,2378,2119, 34885,2379,2120, 34556,1973,1791, 2084,2344,2087, 34822,2307,2057, 
29, // chain 427
1745,1917,1748, 1748,1920,1751, 1853,2051,1856, 
34616,2046,1851, 34886,2380,2121, 34887,2381,2122, 34517,1921,1752, 1865,2067,1868, 34632,2066,1867, 34518,1922,1753, 1863,2065,1866, 34519,1923,1754, 2120,2382,2123, 34889,2383,2124, 34520,1924,1755, 2122,2384,2125, 34521,1925,1756, 2123,2385,2126, 34892,2386,2127, 
33995,1926,1230, 1226,2387,1229, 1217,2388,1220, 2123,2385,2126, 34893,2389,2128, 33973,2390,1208, 2126,2391,2129, 33974,2392,1209, 1207,2393,1210, 1209,2394,1212, 1862,2064,1865, 34509,2063,1744, 
2, // chain 428
2006,2256,2009, 2007,2257,2010, 2127,2395,2130, 
34879,2371,2114, 
5, // chain 429
2033,2286,2036, 2128,2396,2131, 2129,2397,2132, 
2032,2285,2035, 34880,2374,2115, 34898,2398,2133, 34899,2399,2134, 
12, // chain 430
1977,2224,1980, 1957,2198,1960, 1757,1930,1760, 
1976,2223,1979, 34526,1934,1761, 2132,2400,2135, 34901,2401,2136, 34527,1935,1762, 1606,1938,1609, 1598,2402,1601, 1740,2403,1743, 2134,2404,2137, 34492,2405,1727, 34367,2406,1602, 
2, // chain 431
2130,2398,2133, 2135,2407,2138, 2112,2374,2115, 
34881,2375,2116, 
4, // chain 432
1818,2016,1821, 1801,1986,1804, 1916,2133,1919, 
1460,2408,1463, 34229,2409,1464, 34230,2134,1465, 
8, // chain 433
2136,2410,2139, 1840,2038,1843, 1983,2230,1986, 
1984,2231,1987, 2021,2274,2024, 34905,2411,2140, 34753,2232,1988, 2021,2274,2024, 34788,2273,2023, 34754,2233,1989, 
6, // chain 434
2138,2412,2141, 2085,2345,2088, 2139,2413,2142, 
2140,2414,2143, 34687,2150,1922, 34909,2415,2144, 34854,2346,2089, 34853,2345,2088, 
5, // chain 435
2140,2414,2143, 1919,2150,1922, 1922,2153,1925, 
1923,2154,1926, 2142,2416,2145, 34649,2090,1884, 34650,2091,1885, 
2, // chain 436
1871,2078,1874, 1874,2081,1877, 1464,2148,1467, 
1032,2417,1035, 
10, // chain 437
2143,2418,2146, 2144,2419,2147, 1938,2172,1941, 
2145,2420,2148, 34707,2173,1942, 2146,2421,2149, 34915,2422,2150, 33922,2174,1157, 2148,2423,2151, 33921,2424,1156, 1886,2097,1889, 33918,2095,1153, 
28, // chain 438
2149,2425,2152, 2150,2426,2153, 2151,2427,2154, 
2152,2428,2155, 34921,2429,2156, 34922,2430,2157, 34918,2426,2153, 2049,2302,2052, 34583,2013,1818, 34917,2425,2152, 1797,1982,1800, 34923,2431,2158, 34920,2428,2155, 2156,2432,2159, 34925,2433,2160, 34921,2429,2156, 2158,2434,2161, 34927,2435,2162, 34922,2430,2157, 
2160,2436,2163, 34817,2302,2052, 2100,2360,2103, 34818,2303,2053, 2051,2304,2054, 2098,2358,2101, 34820,2305,2055, 2005,2255,2008, 1940,2175,1943, 34709,2176,1944, 34774,2256,2009, 
3, // chain 439
1887,2098,1890, 1888,2100,1891, 2146,2421,2149, 
34929,2437,2164, 34657,2102,1892, 
1, // chain 440
1848,2046,1851, 1849,2047,1852, 1853,2051,1856, 
9, // chain 441
1815,2013,1818, 1816,2014,1819, 1928,2160,1931, 
2049,2302,2052, 34816,2301,2051, 34697,2161,1932, 2047,2300,2050, 34686,2145,1921, 34685,2142,1920, 34698,2162,1933, 1318,2138,1321, 
9, // chain 442
2075,2329,2078, 2114,2376,2117, 2115,2377,2118, 
2071,2324,2074, 34884,2378,2119, 2070,2323,2073, 34910,2416,2145, 34906,2412,2141, 34853,2345,2088, 34852,2344,2087, 34885,2379,2120, 
8, // chain 443
2161,2437,2164, 2162,2438,2165, 2143,2418,2146, 
34931,2439,2166, 2164,2440,2167, 2165,2441,2168, 2144,2419,2147, 34705,2171,1940, 34934,2442,2169, 34935,2443,2170, 
3, // chain 444
1354,2444,1357, 1425,2445,1428, 1803,1988,1806, 
1804,1989,1807, 1360,1990,1363, 
5, // chain 445
1955,2192,1958, 1933,2167,1936, 2168,2446,2171, 
2169,2447,2172, 2128,2396,2131, 34938,2448,2173, 2171,2449,2174, 
13, // chain 446
2172,2450,2175, 2173,2451,2176, 2174,2452,2177, 
2089,2349,2092, 34856,2348,2091, 34943,2453,2178, 34925,2433,2160, 34924,2432,2159, 34941,2451,2176, 2155,2431,2158, 34940,2450,2175, 2176,2454,2179, 34859,2351,2094, 34857,2349,2092, 2090,2350,2093, 
3, // chain 447
2125,2389,2128, 2120,2382,2123, 2121,2383,2124, 
2123,2385,2126, 34890,2384,2125, 
4, // chain 448
1867,2069,1870, 1498,2070,1501, 1744,2455,1747, 
1845,2043,1848, 34491,2196,1726, 34267,2456,1502, 
1, // chain 449
1830,2028,1833, 1831,2029,1834, 2177,2457,2180, 
2, // chain 450
2175,2453,2178, 1944,2179,1947, 1946,2181,1949, 
2088,2348,2091, 
3, // chain 451
2060,2313,2063, 2061,2314,2064, 2080,2340,2083, 
34946,2458,2181, 2179,2459,2182, 
4, // chain 452
1257,2460,1260, 1194,2461,1197, 1754,1927,1757, 
2180,2462,2183, 34949,2463,2184, 34523,1928,1758, 
2, // chain 453
1796,1981,1799, 1797,1982,1800, 2176,2454,2179, 
34923,2431,2158, 
2, // chain 454
1316,2464,1319, 1931,2164,1934, 1818,2016,1821, 
1460,2408,1463, 
7, // chain 455
2182,2465,2185, 2175,2453,2178, 2157,2433,2160, 
2158,2434,2161, 1943,2178,1946, 34869,2361,2104, 34927,2435,2162, 2160,2436,2163, 2100,2360,2103, 
2, // chain 456
2183,2466,2186, 1936,2170,1939, 1937,2171,1940, 
2166,2442,2169, 
5, // chain 457
2075,2329,2078, 2076,2330,2079, 2077,2332,2080, 
1786,1971,1789, 32971,1970,204, 34847,2337,2082, 34846,2334,2081, 
10, // chain 458
1977,2224,1980, 2027,2280,2030, 1957,2198,1960, 
34612,2042,1847, 34611,2041,1846, 34952,2467,2187, 34796,2281,2031, 1842,2040,1845, 34609,2039,1844, 34750,2229,1985, 1983,2230,1986, 1840,2038,1843, 
4, // chain 459
1726,2206,1729, 1255,2468,1258, 1256,1931,1259, 
1958,2199,1961, 34525,1930,1760, 1957,2198,1960, 
1, // chain 460
1881,2090,1884, 2070,2323,2073, 2142,2416,2145, 
2, // chain 461
2058,2311,2061, 2094,2354,2097, 2185,2469,2188, 
2186,2470,2189, 
7, // chain 462
1699,2471,1702, 1548,2472,1551, 2187,2473,2190, 
1707,2474,1710, 34956,2475,2191, 34759,2241,1994, 34316,2472,1551, 1695,2240,1698, 34315,2476,1550, 
1, // chain 463
1367,1965,1370, 1368,2477,1371, 1784,1964,1787, 
3, // chain 464
2125,2389,2128, 2126,2391,2129, 1862,2064,1865, 
1863,2065,1866, 2120,2382,2123, 
1, // chain 465
2144,2419,2147, 1937,2171,1940, 1938,2172,1941, 
4, // chain 466
2189,2478,2192, 2055,2308,2058, 2060,2313,2063, 
2083,2343,2086, 2054,2307,2057, 2055,2308,2058, 
2, // chain 467
2111,2371,2114, 1013,2372,1016, 1007,2479,1010, 
33777,2480,1012, 
1, // chain 468
1789,1974,1792, 1790,1975,1793, 1788,1973,1791, 
3, // chain 469
1953,2190,1956, 1954,2191,1957, 2033,2286,2036, 
34896,2396,2131, 34723,2192,1958, 
2, // chain 470
2161,2437,2164, 2143,2418,2146, 2145,2420,2148, 
2146,2421,2149, 
3, // chain 471
2022,2275,2025, 1838,2036,1841, 1839,2037,1842, 
2136,2410,2139, 34608,2038,1843, 
3, // chain 472
2132,2400,2135, 2134,2404,2137, 2188,2475,2191, 
1976,2223,1979, 34759,2241,1994, 
1, // chain 473
2190,2481,2193, 2094,2354,2097, 2095,2355,2098, 
2, // chain 474
1190,2482,1193, 1227,1926,1230, 1754,1927,1757, 
1194,2461,1197, 
1, // chain 475
2003,2253,2006, 1878,2085,1881, 1879,2086,1882, 
2, // chain 476
1989,2236,1992, 1990,2237,1993, 1950,2187,1953, 
1951,2188,1954, 
1, // chain 477
2183,2466,2186, 1935,2169,1938, 1936,2170,1939, 
1, // chain 478
1594,2238,1597, 1693,2239,1696, 1593,2483,1596, 
2, // chain 479
1837,2035,1840, 2109,2369,2112, 1836,2034,1839, 
34603,2033,1838, 
1, // chain 480
1875,2082,1878, 1464,2148,1467, 1874,2081,1877, 
3, // chain 481
1869,2072,1872, 1729,2165,1732, 1743,2484,1746, 
1736,2073,1739, 34503,2485,1738, 
1, // chain 482
1842,2040,1845, 1843,2041,1846, 2184,2467,2187, 
2, // chain 483
1889,2102,1892, 1890,2103,1893, 2191,2486,2194, 
34659,2105,1894, 
1, // chain 484
2114,2376,2117, 2075,2329,2078, 1786,1971,1789, 
1, // chain 485
197,2487,198, 1447,1967,1450, 198,1968,199, 
1, // chain 486
1693,2239,1696, 1695,2240,1698, 1694,2488,1697, 
2, // chain 487
1586,2489,1589, 1587,2184,1590, 1990,2237,1993, 
34718,2187,1953, 
3, // chain 488
1990,2237,1993, 1594,2238,1597, 2192,2490,2195, 
34354,2489,1589, 1990,2237,1993, 
2, // chain 489
2092,2352,2095, 2193,2491,2196, 2194,2492,2197, 
1902,2118,1905, 
2, // chain 490
2195,2493,2198, 1755,1928,1758, 2196,2494,2199, 
34524,1929,1759, 
1, // chain 491
1981,2228,1984, 1982,2229,1985, 1980,2227,1983, 
1, // chain 492
1794,1979,1797, 1795,1980,1798, 1995,2245,1998, 
2, // chain 493
1887,2098,1890, 2146,2421,2149, 2148,2423,2151, 
1886,2097,1889, 
1, // chain 494
1931,2164,1934, 1316,2464,1319, 1317,2163,1320, 
1, // chain 495
2142,2416,2145, 2138,2412,2141, 2140,2414,2143, 
1, // chain 496
1186,2333,1189, 1262,2495,1265, 1409,2496,1412, 
2, // chain 497
2141,2415,2144, 2197,2497,2200, 1920,2151,1923, 
1919,2150,1922, 
1, // chain 498
1496,2061,1499, 1497,2059,1500, 1861,2060,1864, 
1, // chain 499
1254,2498,1257, 1256,1931,1259, 1255,2468,1258, 
3, // chain 500
2118,2380,2121, 1866,2068,1869, 1846,2044,1849, 
1847,2045,1850, 1848,2046,1851, 
1, // chain 501
1934,2168,1937, 2168,2446,2171, 1933,2167,1936, 
6, // chain 502
2198,2499,2201, 2199,2500,2202, 2200,2501,2203, 
34969,2502,2204, 1059,2503,1062, 1060,1997,1063, 2198,2499,2201, 34573,1998,1808, 
1, // chain 503
2146,2421,2149, 2147,2422,2150, 2148,2423,2151, 
3, // chain 504
1746,1918,1749, 1745,1917,1748, 2202,2504,2205, 
2203,2505,2206, 2204,2506,2207, 
2, // chain 505
1944,2179,1947, 2175,2453,2178, 2182,2465,2185, 
1943,2178,1946, 
2, // chain 506
2106,2366,2109, 2043,2296,2046, 2019,2272,2022, 
2020,2273,2023, 
1, // chain 507
2052,2305,2055, 1877,2084,1880, 1878,2085,1881, 
1, // chain 508
203,1970,204, 2079,2337,2082, 202,2338,203, 
1, // chain 509
2056,2309,2059, 2057,2310,2060, 2093,2353,2096, 
3, // chain 510
1724,2405,1727, 1706,2507,1709, 1707,2474,1710, 
2188,2475,2191, 2134,2404,2137, 
1, // chain 511
1745,1917,1748, 2205,2508,2208, 2202,2504,2205, 
2, // chain 512
2072,2325,2075, 2073,2326,2076, 2074,2327,2077, 
2071,2324,2074, 
1, // chain 513
1447,1967,1450, 1367,1965,1370, 1785,1966,1788, 
1, // chain 514
2134,2404,2137, 2132,2400,2135, 2133,2401,2136, 
1, // chain 515
1548,2472,1551, 1699,2471,1702, 1545,2509,1548, 
1, // chain 516
2021,2274,2024, 2022,2275,2025, 2136,2410,2139, 
1, // chain 517
2091,2351,2094, 1796,1981,1799, 2176,2454,2179, 
2, // chain 518
1425,2445,1428, 1424,2131,1427, 1802,1987,1805, 
1803,1988,1806, 
1, // chain 519
1745,1917,1748, 1853,2051,1856, 1854,2510,1857, 
2, // chain 520
1866,2068,1869, 2118,2380,2121, 1865,2067,1868, 
34887,2381,2122, 
1, // chain 521
1352,2511,1355, 329,2512,330, 251,2339,252, 
2, // chain 522
2206,2513,2209, 2207,2514,2210, 2208,2515,2211, 
2209,2516,2212, 
2, // chain 523
2210,2517,2213, 2211,2518,2214, 2212,2519,2215, 
2211,2520,2214, 
17, // chain 524
2213,2521,2216, 2214,2522,2217, 2215,2523,2218, 
2216,2524,2219, 2217,2525,2220, 2218,2526,2221, 2219,2527,2222, 34988,2528,2223, 34989,2529,2224, 34990,2530,2225, 2223,2531,2226, 2224,2532,2227, 34993,2533,2228, 2226,2534,2229, 2227,2535,2230, 34996,2536,2231, 34997,2537,2232, 34998,2538,2233, 34999,2539,2234, 
28, // chain 525
2232,2540,2235, 2233,2541,2236, 2234,2542,2237, 
2235,2543,2238, 35004,2544,2239, 35005,2545,2240, 35006,2546,2241, 35007,2547,2242, 35001,2541,2236, 2240,2548,2243, 35009,2549,2244, 35010,2550,2245, 35000,2540,2235, 2243,2551,2246, 35012,2552,2247, 35013,2553,2248, 35014,2554,2249, 35003,2543,2238, 2247,2555,2250, 
35004,2544,2239, 2248,2556,2251, 35017,2557,2252, 35018,2558,2253, 35005,2545,2240, 2238,2546,2241, 2251,2559,2254, 35020,2560,2255, 35007,2547,2242, 2253,2561,2256, 35008,2548,2243, 
1, // chain 526
2254,2562,2257, 2255,2563,2258, 2256,2564,2259, 
69, // chain 527
2257,2565,2260, 2258,2566,2261, 2259,2567,2262, 
2260,2568,2263, 35029,2569,2264, 35030,2570,2265, 35031,2571,2266, 35032,2572,2267, 35026,2566,2261, 2265,2573,2268, 35034,2574,2269, 35035,2575,2270, 35025,2565,2260, 2268,2576,2271, 35037,2577,2272, 35038,2578,2273, 35039,2579,2274, 35028,2568,2263, 2272,2580,2275, 
35041,2581,2276, 35042,2582,2277, 35029,2569,2264, 2275,2583,2278, 35044,2584,2279, 35045,2585,2280, 35030,2570,2265, 2278,2586,2281, 35047,2587,2282, 35048,2588,2283, 35031,2571,2266, 2281,2589,2284, 35050,2590,2285, 35051,2591,2286, 35032,2572,2267, 2284,2592,2287, 
35053,2593,2288, 35033,2573,2268, 2266,2574,2269, 2286,2594,2289, 35055,2595,2290, 35035,2575,2270, 2288,2596,2291, 35057,2597,2292, 35036,2576,2271, 2269,2577,2272, 2290,2598,2293, 35059,2599,2294, 35038,2578,2273, 2292,2600,2295, 35061,2601,2296, 35039,2579,2274, 
2294,2602,2297, 35040,2580,2275, 2273,2581,2276, 2295,2603,2298, 35064,2604,2299, 35065,2605,2300, 35042,2582,2277, 2298,2606,2301, 35067,2607,2302, 35043,2583,2278, 2276,2584,2279, 2300,2608,2303, 35045,2585,2280, 2278,2586,2281, 2301,2609,2304, 35070,2610,2305, 
35071,2611,2306, 35072,2612,2307, 35048,2588,2283, 35047,2587,2282, 
39, // chain 528
2305,2613,2308, 2306,2614,2309, 2307,2615,2310, 
2308,2616,2311, 35077,2617,2312, 35078,2618,2313, 35079,2619,2314, 35080,2620,2315, 35074,2614,2309, 2313,2621,2316, 35073,2613,2308, 2314,2622,2317, 35083,2623,2318, 35084,2624,2319, 35085,2625,2320, 35076,2616,2311, 2222,2626,2225, 35077,2617,2312, 2223,2627,2226, 
35086,2628,2321, 35087,2629,2322, 35078,2618,2313, 2320,2630,2323, 35089,2631,2324, 35079,2619,2314, 2312,2620,2315, 2322,2632,2325, 35091,2633,2326, 35081,2621,2316, 2314,2622,2317, 2324,2634,2327, 35093,2635,2328, 35083,2623,2318, 2326,2636,2329, 35084,2624,2319, 
2327,2637,2330, 35096,2638,2331, 34985,2639,2220, 35085,2625,2320, 2218,2640,2221, 34990,2626,2225, 
29, // chain 529
2329,2641,2332, 2330,2642,2333, 2331,2643,2334, 
2332,2644,2335, 35101,2645,2336, 35102,2646,2337, 35103,2647,2338, 35104,2648,2339, 35105,2649,2340, 35088,2630,2323, 35098,2642,2333, 2319,2629,2322, 35106,2650,2341, 35097,2641,2332, 2339,2651,2342, 35100,2644,2335, 2340,2652,2343, 35101,2645,2336, 2341,2653,2344, 
35055,2595,2290, 35102,2646,2337, 2342,2654,2345, 35103,2647,2338, 2336,2648,2339, 2343,2655,2346, 35112,2656,2347, 35113,2657,2348, 35105,2649,2340, 2322,2632,2325, 35089,2631,2324, 35088,2630,2323, 
15, // chain 530
2346,2658,2349, 2347,2659,2350, 2348,2660,2351, 
2349,2661,2352, 35118,2662,2353, 35119,2663,2354, 35120,2664,2355, 35115,2659,2350, 2322,2632,2325, 35121,2665,2356, 35114,2658,2349, 2354,2666,2357, 35123,2667,2358, 35124,2668,2359, 35117,2661,2352, 2357,2669,2360, 35126,2670,2361, 
5, // chain 531
2287,2595,2290, 2288,2596,2291, 2228,2536,2231, 
35127,2671,2362, 35128,2672,2363, 35058,2598,2293, 35057,2597,2292, 
27, // chain 532
2361,2673,2364, 2362,2674,2365, 2363,2675,2366, 
2292,2600,2295, 35132,2676,2367, 35130,2674,2365, 2365,2677,2368, 34992,2532,2227, 34989,2529,2224, 34988,2528,2223, 34987,2527,2222, 35129,2673,2364, 2366,2678,2369, 35135,2679,2370, 35136,2680,2371, 35060,2600,2295, 2293,2601,2296, 2369,2681,2372, 35062,2602,2297, 
2370,2682,2373, 35139,2683,2374, 35063,2603,2298, 2372,2684,2375, 35141,2685,2376, 35142,2686,2377, 35143,2687,2378, 35064,2604,2299, 2298,2606,2301, 35065,2605,2300, 
2, // chain 533
2323,2633,2326, 2324,2634,2327, 2352,2664,2355, 
2322,2632,2325, 
11, // chain 534
2287,2595,2290, 2228,2536,2231, 2341,2653,2344, 
35108,2652,2343, 34997,2537,2232, 2339,2651,2342, 34998,2688,2233, 2338,2650,2341, 35144,2689,2379, 34999,2690,2234, 2377,2691,2380, 34993,2692,2228, 34994,2693,2229, 
16, // chain 535
2280,2588,2283, 2281,2589,2284, 2304,2612,2307, 
35050,2590,2285, 2378,2694,2381, 35147,2695,2382, 35051,2591,2286, 2380,2696,2383, 35052,2592,2287, 2354,2666,2357, 35149,2697,2384, 35150,2698,2385, 35053,2593,2288, 2344,2656,2347, 35054,2594,2289, 2343,2655,2346, 35055,2595,2290, 2342,2654,2345, 
8, // chain 536
2378,2694,2381, 2379,2695,2382, 2383,2699,2386, 
2384,2700,2387, 35153,2701,2388, 35124,2668,2359, 35123,2667,2358, 35147,2695,2382, 2354,2666,2357, 35148,2696,2383, 
5, // chain 537
2365,2677,2368, 2224,2532,2227, 2227,2535,2230, 
2290,2598,2293, 35128,2672,2363, 34996,2536,2231, 2359,2671,2362, 
4, // chain 538
2386,2702,2389, 2241,2549,2244, 2242,2550,2245, 
2387,2703,2390, 35012,2552,2247, 35011,2551,2246, 
44, // chain 539
2386,2704,2389, 2387,2705,2390, 2388,2706,2391, 
35157,2707,2392, 35158,2708,2393, 35159,2709,2394, 2392,2710,2395, 35161,2711,2396, 35162,2712,2397, 2245,2553,2248, 2302,2610,2305, 35069,2609,2304, 35014,2554,2249, 2247,2555,2250, 2248,2556,2251, 2300,2608,2303, 35017,2557,2252, 2299,2607,2302, 35066,2606,2301, 
35143,2687,2378, 35163,2713,2398, 35164,2714,2399, 35018,2558,2253, 2251,2559,2254, 2374,2686,2377, 35165,2715,2400, 35166,2716,2401, 35020,2560,2255, 2399,2717,2402, 35168,2718,2403, 2401,2719,2404, 2402,2720,2405, 2398,2716,2401, 35165,2715,2400, 35142,2686,2377, 
35171,2721,2406, 35172,2722,2407, 2405,2723,2408, 2406,2724,2409, 35175,2725,2410, 2408,2726,2411, 35177,2727,2412, 34981,2521,2216, 34982,2522,2217, 35178,2728,2413, 35179,2729,2414, 
3, // chain 540
2408,2726,2411, 2366,2678,2369, 2367,2679,2370, 
2369,2681,2372, 35136,2680,2371, 
6, // chain 541
2384,2700,2387, 2385,2701,2388, 2412,2730,2415, 
2392,2710,2395, 35158,2708,2393, 35157,2707,2392, 35124,2668,2359, 35153,2701,2388, 
7, // chain 542
2325,2635,2328, 2326,2636,2329, 2413,2731,2416, 
35095,2637,2330, 2414,2732,2417, 34983,2733,2218, 35096,2638,2331, 2216,2734,2219, 34985,2639,2220, 
3, // chain 543
2357,2669,2360, 2415,2735,2418, 2388,2706,2391, 
2389,2707,2392, 2356,2668,2359, 
5, // chain 544
2403,2721,2406, 2406,2724,2409, 2408,2726,2411, 
2372,2684,2375, 35139,2683,2374, 35137,2681,2372, 2370,2682,2373, 
3, // chain 545
2408,2726,2411, 2409,2727,2412, 2366,2678,2369, 
34981,2521,2216, 2219,2527,2222, 
7, // chain 546
2303,2611,2306, 2304,2612,2307, 2416,2736,2419, 
35146,2694,2381, 2303,2611,2306, 35152,2700,2387, 2302,2610,2305, 35160,2710,2395, 2393,2711,2396, 
2, // chain 547
2376,2689,2379, 2377,2691,2380, 2319,2629,2322, 
2338,2650,2341, 
2, // chain 548
2403,2721,2406, 2372,2684,2375, 2373,2685,2376, 
2374,2686,2377, 
3, // chain 549
2244,2552,2247, 2245,2553,2248, 2394,2737,2397, 
2391,2738,2394, 2387,2703,2390, 
3, // chain 550
2382,2698,2385, 2344,2656,2347, 2345,2657,2348, 
2353,2665,2356, 35090,2632,2325, 
3, // chain 551
2364,2676,2367, 2365,2677,2368, 2290,2598,2293, 
2291,2599,2294, 2292,2600,2295, 
3, // chain 552
2350,2662,2353, 2417,2739,2420, 2418,2740,2421, 
2419,2741,2422, 2349,2661,2352, 
2, // chain 553
2354,2666,2357, 2381,2697,2384, 2353,2665,2356, 
35150,2698,2385, 
2, // chain 554
2413,2731,2416, 2420,2742,2423, 2325,2635,2328, 
35092,2634,2327, 
3, // chain 555
2318,2628,2321, 2319,2629,2322, 2377,2691,2380, 
2225,2692,2228, 2223,2627,2226, 
2, // chain 556
2395,2713,2398, 2396,2714,2399, 2374,2686,2377, 
2375,2687,2378, 
1, // chain 557
2351,2663,2354, 2417,2739,2420, 2350,2662,2353, 
29, // chain 558
2421,2743,2424, 2422,2744,2425, 2423,2745,2426, 
2424,2746,2427, 35193,2747,2428, 35194,2748,2429, 35195,2749,2430, 35190,2744,2425, 2428,2750,2431, 32825,2751,57, 32827,2752,59, 32855,2753,87, 35189,2743,2424, 65,2754,65, 35197,2755,2432, 35198,2756,2433, 35192,2746,2427, 2431,2757,2434, 35200,2758,2435, 
35201,2759,2436, 34895,2760,2130, 35193,2747,2428, 2006,2761,2009, 35194,2748,2429, 2434,2762,2437, 35195,2749,2430, 2435,2763,2438, 35196,2750,2431, 61,2764,61, 32824,2765,56, 32825,2751,57, 
9, // chain 559
1899,2766,1902, 2436,2767,2439, 2437,2768,2440, 
2438,2769,2441, 35207,2770,2442, 35208,2771,2443, 35204,2767,2439, 2441,2772,2444, 35210,2773,2445, 34668,2774,1903, 34667,2766,1902, 
11, // chain 560
15,2775,15, 2443,2776,2446, 2444,2777,2447, 
2445,2778,2448, 35214,2779,2449, 34600,2780,1835, 34599,2781,1834, 35211,2776,2446, 2177,2782,2180, 35215,2783,2450, 32777,2784,9, 32783,2775,15, 8,2785,8, 
10, // chain 561
2433,2759,2436, 2448,2786,2451, 2449,2787,2452, 
2432,2758,2435, 35218,2788,2453, 35219,2789,2454, 35216,2786,2451, 2452,2790,2455, 35221,2791,2456, 34879,2792,2114, 34895,2760,2130, 35201,2759,2436, 
10, // chain 562
2450,2788,2453, 2454,2793,2457, 2455,2794,2458, 
2456,2795,2459, 35225,2796,2460, 35226,2797,2461, 35222,2793,2457, 2459,2798,2462, 35228,2799,2463, 35220,2790,2455, 35219,2789,2454, 35218,2788,2453, 
10, // chain 563
1948,2800,1951, 1945,2801,1948, 2461,2802,2464, 
2462,2803,2465, 35231,2804,2466, 35232,2805,2467, 34713,2806,1948, 1942,2807,1945, 2465,2808,2468, 35202,2762,2437, 34709,2809,1944, 2006,2761,2009, 
2, // chain 564
1218,2810,1221, 1257,2811,1260, 613,2812,614, 
612,2813,613, 
9, // chain 565
613,2812,614, 2180,2814,2183, 2466,2815,2469, 
676,2816,679, 35235,2817,2470, 35236,2818,2471, 35237,2819,2472, 34963,2820,2198, 34948,2814,2183, 2181,2821,2184, 1755,2822,1758, 
9, // chain 566
2470,2823,2473, 2471,2824,2474, 2472,2825,2475, 
2473,2826,2476, 35242,2827,2477, 32789,2828,21, 35243,2829,2478, 35244,2830,2479, 35245,2831,2480, 35246,2832,2481, 35239,2824,2474, 
4, // chain 567
2479,2833,2482, 49,2834,49, 50,2835,50, 
2480,2836,2483, 32801,2837,33, 32800,2838,32, 
16, // chain 568
2481,2839,2484, 2482,2840,2485, 88,2841,88, 
2483,2842,2486, 32846,2843,78, 2484,2844,2487, 32847,2845,79, 71,2846,71, 2485,2847,2488, 35254,2848,2489, 32840,2849,72, 2487,2850,2490, 35256,2851,2491, 32841,2852,73, 2489,2853,2492, 32834,2854,66, 2429,2755,2432, 32833,2754,65, 
7, // chain 569
2470,2823,2473, 2473,2826,2476, 2490,2855,2493, 
35259,2856,2494, 35260,2857,2495, 35261,2858,2496, 35242,2827,2477, 19,2859,19, 32789,2828,21, 
9, // chain 570
2018,2860,2021, 2044,2861,2047, 2494,2862,2497, 
2495,2863,2498, 35264,2864,2499, 35265,2865,2500, 35266,2866,2501, 34812,2861,2047, 2042,2867,2045, 2499,2868,2502, 34809,2869,2044, 
2, // chain 571
2464,2805,2467, 2465,2808,2468, 2435,2763,2438, 
35202,2762,2437, 
9, // chain 572
2500,2870,2503, 2501,2871,2504, 1852,2872,1855, 
1851,2873,1854, 2502,2874,2505, 35271,2875,2506, 34618,2876,1853, 2504,2877,2507, 35215,2783,2450, 34945,2782,2180, 34598,2878,1833, 
8, // chain 573
2505,2879,2508, 545,2880,546, 2506,2881,2509, 
2458,2797,2461, 35275,2882,2510, 35254,2848,2489, 35253,2847,2488, 35276,2883,2511, 33312,2884,545, 33313,2880,546, 
12, // chain 574
2509,2885,2512, 2510,2886,2513, 43,2887,43, 
44,2888,44, 2511,2889,2514, 32813,2890,45, 46,2891,46, 2512,2892,2515, 35281,2893,2516, 35282,2894,2517, 32815,2895,47, 2479,2833,2482, 32817,2834,49, 32816,2896,48, 
5, // chain 575
2515,2897,2518, 2435,2763,2438, 61,2764,61, 
60,2898,60, 2516,2899,2519, 32854,2900,86, 32853,2901,85, 
13, // chain 576
2517,2902,2520, 2511,2889,2514, 2193,2903,2196, 
2092,2904,2095, 2068,2905,2071, 2518,2906,2521, 34837,2907,2072, 2519,2908,2522, 35288,2909,2523, 34833,2910,2068, 2064,2911,2067, 2521,2912,2524, 35290,2913,2525, 34716,2800,1951, 34715,2914,1950, 
8, // chain 577
2523,2915,2526, 55,2916,55, 2524,2917,2527, 
2525,2918,2528, 35294,2919,2529, 35214,2779,2449, 35213,2778,2448, 32782,2920,14, 32823,2916,55, 39,2921,39, 
11, // chain 578
2493,2858,2496, 2527,2922,2530, 2528,2923,2531, 
2492,2857,2495, 35297,2924,2532, 35298,2925,2533, 35295,2922,2530, 2531,2926,2534, 35300,2927,2535, 32784,2928,16, 32785,2929,17, 35261,2858,2496, 19,2859,19, 
8, // chain 579
2533,2930,2536, 1834,2931,1837, 2534,2932,2537, 
2531,2926,2534, 35298,2925,2533, 34877,2933,2112, 35303,2934,2538, 34602,2931,1837, 1835,2935,1838, 2109,2936,2112, 
20, // chain 580
2536,2937,2539, 2537,2938,2540, 2538,2939,2541, 
2539,2940,2542, 35278,2886,2513, 32811,2887,43, 35305,2938,2540, 42,2941,42, 32809,2942,41, 35308,2943,2543, 35304,2937,2539, 2541,2944,2544, 35290,2913,2525, 35307,2940,2542, 2521,2912,2524, 35288,2909,2523, 35278,2886,2513, 2519,2908,2522, 35277,2885,2512, 
2518,2906,2521, 35285,2902,2520, 35279,2889,2514, 
4, // chain 581
2016,2945,2019, 2495,2863,2498, 2491,2856,2494, 
2023,2946,2026, 35297,2924,2532, 35260,2857,2495, 
7, // chain 582
41,2942,41, 2540,2943,2543, 83,2947,83, 
35284,2899,2519, 35231,2804,2466, 35230,2803,2465, 35309,2944,2544, 1948,2800,1951, 35290,2913,2525, 
4, // chain 583
2542,2948,2545, 2543,2949,2546, 1897,2950,1900, 
2438,2769,2441, 34667,2766,1902, 34666,2951,1901, 
4, // chain 584
2544,2952,2547, 550,2953,551, 547,2954,548, 
546,2955,547, 2505,2879,2508, 33313,2880,546, 
2, // chain 585
2487,2850,2490, 2457,2796,2460, 2507,2882,2510, 
2486,2848,2489, 
1, // chain 586
2458,2797,2461, 2507,2882,2510, 2457,2796,2460, 
3, // chain 587
2525,2918,2528, 2545,2956,2548, 2533,2930,2536, 
2532,2927,2535, 35299,2926,2534, 
4, // chain 588
2525,2918,2528, 2532,2927,2535, 2546,2957,2549, 
35315,2958,2550, 32832,2959,64, 32784,2928,16, 
15, // chain 589
2548,2960,2551, 2512,2892,2515, 2513,2893,2516, 
2442,2773,2445, 35317,2961,2552, 35318,2962,2553, 35282,2894,2517, 2549,2961,2552, 35247,2833,2482, 2441,2772,2444, 35248,2836,2483, 2440,2771,2443, 32801,2837,33, 31,2963,31, 2475,2964,2478, 32789,2965,21, 32790,2966,22, 
18, // chain 590
2551,2967,2554, 2,2968,2, 2552,2969,2555, 
32849,2970,81, 2553,2971,2556, 32850,2972,82, 2501,2871,2504, 35322,2973,2557, 32848,2974,80, 75,2975,75, 2555,2976,2558, 32842,2977,74, 2556,2978,2559, 2557,2979,2560, 34972,2980,2207, 35326,2981,2561, 35327,2982,2562, 35328,2983,2563, 32845,2984,77, 
32842,2985,74, 
13, // chain 591
2508,2883,2511, 676,2816,679, 2467,2817,2470, 
2481,2839,2484, 35250,2840,2485, 35236,2818,2471, 2561,2986,2564, 35327,2982,2562, 35326,2981,2561, 35237,2819,2472, 2204,2980,2207, 34964,2987,2199, 35330,2988,2565, 34963,2820,2198, 2196,2989,2199, 
5, // chain 592
88,2841,88, 2482,2840,2485, 2563,2990,2566, 
77,2984,77, 35328,2983,2563, 35329,2986,2564, 35250,2840,2485, 
7, // chain 593
2564,2991,2567, 2502,2874,2505, 2503,2875,2506, 
4,2992,4, 32774,2993,6, 35272,2877,2507, 7,2994,7, 32777,2784,9, 35215,2783,2450, 
3, // chain 594
2203,2995,2206, 2565,2996,2568, 2554,2973,2557, 
2557,2979,2560, 35323,2976,2558, 
4, // chain 595
2566,2997,2569, 2489,2853,2492, 2431,2757,2434, 
2456,2795,2459, 35218,2788,2453, 35200,2758,2435, 
6, // chain 596
2567,2998,2570, 2566,2997,2569, 2568,2999,2571, 
2457,2796,2460, 35337,3000,2572, 35334,2997,2569, 2456,2795,2459, 2457,2796,2460, 
5, // chain 597
2489,2853,2492, 2566,2997,2569, 2570,3001,2573, 
2488,2851,2491, 35255,2850,2490, 35335,2998,2570, 35334,2997,2569, 
2, // chain 598
2552,2969,2555, 2553,2971,2556, 2500,2870,2503, 
35269,2871,2504, 
5, // chain 599
2551,2967,2554, 2552,2969,2555, 2500,2870,2503, 
2502,2874,2505, 2564,2991,2567, 2,3002,2, 32772,2992,4, 
2, // chain 600
2463,2804,2466, 2464,2805,2467, 2515,2897,2518, 
35203,2763,2438, 
8, // chain 601
2460,2799,2463, 2571,3003,2574, 2572,3004,2575, 
2544,2952,2547, 33774,3005,1009, 33775,3006,1010, 35221,2791,2456, 35339,3003,2574, 2452,2790,2455, 35228,2799,2463, 
3, // chain 602
2549,2961,2552, 2441,2772,2444, 2573,3007,2576, 
35210,2773,2445, 2549,2961,2552, 
4, // chain 603
2565,2996,2568, 2202,3008,2205, 2205,3009,2208, 
2501,2871,2504, 34622,3010,1857, 34513,3011,1748, 
2, // chain 604
2495,2863,2498, 2016,2945,2019, 2017,3012,2020, 
2018,2860,2021, 
3, // chain 605
554,3013,555, 551,3014,552, 550,2953,551, 
2544,2952,2547, 1006,3005,1009, 
2, // chain 606
676,2816,679, 2508,2883,2511, 543,3015,544, 
33312,2884,545, 
6, // chain 607
64,2959,64, 54,3016,54, 2574,3017,2577, 
2547,2958,2550, 35343,3018,2578, 35344,3019,2579, 32823,2916,55, 32822,3016,54, 
2, // chain 608
2429,2755,2432, 2430,2756,2433, 2489,2853,2492, 
35199,2757,2434, 
5, // chain 609
2497,2865,2500, 2577,3020,2580, 2470,2823,2473, 
2496,2864,2499, 35258,2855,2493, 2495,2863,2498, 35259,2856,2494, 
3, // chain 610
2525,2918,2528, 2546,2957,2549, 2576,3019,2579, 
2523,2915,2526, 32823,2916,55, 
1, // chain 611
2453,2791,2456, 2111,2792,2114, 1007,3006,1010, 
1, // chain 612
2516,2899,2519, 2463,2804,2466, 2515,2897,2518, 
3, // chain 613
2439,2770,2442, 2440,2771,2443, 2475,2964,2478, 
2578,3021,2581, 35244,3022,2479, 
1, // chain 614
2180,2814,2183, 613,2812,614, 1257,2811,1260, 
1, // chain 615
2470,2823,2473, 2577,3020,2580, 2471,2824,2474, 
2, // chain 616
2546,2957,2549, 2547,2958,2550, 2575,3018,2578, 
2576,3019,2579, 
2, // chain 617
2516,2899,2519, 86,2900,86, 84,3023,84, 
83,2947,83, 
3, // chain 618
2458,2797,2461, 2459,2798,2462, 2505,2879,2508, 
35312,2952,2547, 35228,2799,2463, 
4, // chain 619
2579,3024,2582, 1832,2780,1835, 1833,3025,1836, 
2545,2956,2548, 34602,2931,1837, 2533,2930,2536, 
3, // chain 620
2481,2839,2484, 2483,2842,2486, 2484,2844,2487, 
2508,2883,2511, 35253,2847,2488, 
3, // chain 621
2497,2865,2500, 2498,2866,2501, 2580,3026,2583, 
35349,3027,2584, 35350,3028,2585, 
3, // chain 622
2108,3029,2111, 2023,2946,2026, 2529,2924,2532, 
2530,2925,2533, 2109,2933,2112, 
2, // chain 623
1746,3030,1749, 2204,2980,2207, 2196,2987,2199, 
1756,3031,1759, 
1, // chain 624
2581,3027,2584, 2583,3032,2586, 2580,3026,2583, 
1, // chain 625
2584,3033,2587, 2543,2949,2546, 2542,2948,2545, 
2, // chain 626
1897,2950,1900, 2543,2949,2546, 1896,3034,1899, 
34680,3035,1915, 
3, // chain 627
1900,2774,1903, 1901,3036,1904, 2548,2960,2551, 
34962,3037,2197, 34670,3038,1905, 
2, // chain 628
2193,2903,2196, 2512,2892,2515, 2548,2960,2551, 
2194,3037,2197, 
3, // chain 629
2526,2919,2529, 2446,2779,2449, 2579,3024,2582, 
2545,2956,2548, 2525,2918,2528, 
1, // chain 630
68,3039,68, 87,2753,87, 65,2754,65, 
1, // chain 631
2578,3021,2581, 2585,3040,2588, 2586,3041,2589, 
1, // chain 632
1832,2780,1835, 2579,3024,2582, 2446,2779,2449, 
1, // chain 633
15,2775,15, 2445,2778,2448, 14,2920,14, 
1, // chain 634
2497,2865,2500, 2580,3026,2583, 2577,3020,2580, 
1, // chain 635
2565,2996,2568, 2501,2871,2504, 2554,2973,2557, 
3, // chain 636
2439,2770,2442, 2578,3021,2581, 2587,3042,2590, 
2438,2769,2441, 35356,3043,2591, 
1, // chain 637
2438,2769,2441, 2588,3044,2591, 2542,2948,2545, 
1, // chain 638
2557,2979,2560, 2204,2980,2207, 2203,2995,2206, 
1, // chain 639
2512,2892,2515, 2193,2903,2196, 2511,2889,2514, 
1, // chain 640
2560,2983,2563, 2561,2986,2564, 2559,2982,2562, 
1, // chain 641
2567,2998,2570, 2457,2796,2460, 2487,2850,2490, 
1, // chain 642
676,2816,679, 614,3045,615, 613,2812,614, 
1, // chain 643
2501,2871,2504, 1854,3010,1857, 1852,2872,1855, 
1, // chain 644
2442,2773,2445, 1900,2774,1903, 2548,2960,2551, 
1, // chain 645
2565,2996,2568, 2203,2995,2206, 2202,3008,2205, 
1, // chain 646
543,3015,544, 541,3046,542, 676,2816,679, 
34, // chain 647
2589,3047,2592, 2590,3048,2593, 2591,3049,2594, 
2592,3050,2595, 35361,3051,2596, 35362,3052,2597, 35363,3053,2598, 35364,3054,2599, 35365,3055,2600, 35358,3048,2593, 2598,3056,2601, 35367,3057,2602, 35357,3047,2592, 2600,3058,2603, 35369,3059,2604, 35370,3060,2605, 35360,3050,2595, 2603,3061,2606, 35372,3062,2607, 
35361,3051,2596, 2605,3063,2608, 35362,3052,2597, 2606,3064,2609, 35375,3065,2610, 35363,3053,2598, 2608,3066,2611, 35377,3067,2612, 35364,3054,2599, 2610,3068,2613, 35365,3055,2600, 2611,3069,2614, 2612,3070,2615, 35381,3071,2616, 2614,3072,2617, 35383,3073,2618, 
35384,3074,2619, 
54, // chain 648
2617,3075,2620, 2618,3076,2621, 2619,3077,2622, 
2620,3078,2623, 35389,3079,2624, 35390,3080,2625, 35391,3081,2626, 35392,3082,2627, 35393,3083,2628, 35386,3076,2621, 2626,3084,2629, 35395,3085,2630, 35396,3086,2631, 35385,3075,2620, 2629,3087,2632, 35388,3078,2623, 2630,3088,2633, 35399,3089,2634, 35389,3079,2624, 
2632,3090,2635, 35401,3091,2636, 35402,3092,2637, 35390,3080,2625, 2635,3093,2638, 35404,3094,2639, 35391,3081,2626, 2637,3095,2640, 35406,3096,2641, 35392,3082,2627, 2639,3097,2642, 35408,3098,2643, 35393,3083,2628, 2641,3099,2644, 35394,3084,2629, 2642,3100,2645, 
35411,3101,2646, 35412,3102,2647, 35395,3085,2630, 2645,3103,2648, 35396,3086,2631, 2646,3104,2649, 35397,3087,2632, 2647,3105,2650, 35416,3106,2651, 35398,3088,2633, 2649,3107,2652, 35418,3108,2653, 35419,3109,2654, 35399,3089,2634, 2652,3110,2655, 35400,3090,2635, 
2653,3111,2656, 35401,3091,2636, 2654,3112,2657, 35403,3093,2638, 35402,3092,2637, 
52, // chain 649
2655,3113,2658, 2656,3114,2659, 2657,3115,2660, 
2658,3116,2661, 35427,3117,2662, 35428,3118,2663, 35415,3105,2650, 35429,3119,2664, 35424,3114,2659, 2646,3104,2649, 35430,3120,2665, 35423,3113,2658, 2663,3121,2666, 35432,3122,2667, 35433,3123,2668, 35434,3124,2669, 35426,3116,2661, 2667,3125,2670, 35427,3117,2662, 
2668,3126,2671, 35437,3127,2672, 35438,3128,2673, 35439,3129,2674, 35428,3118,2663, 2672,3130,2675, 35415,3105,2650, 2648,3106,2651, 2649,3107,2652, 2671,3129,2674, 35441,3131,2676, 35418,3108,2653, 2674,3132,2677, 35443,3133,2678, 35419,3109,2654, 2676,3134,2679, 
35420,3110,2655, 2653,3111,2656, 2677,3135,2680, 35422,3112,2657, 2678,3136,2681, 35447,3137,2682, 35448,3138,2683, 35449,3139,2684, 35403,3093,2638, 2682,3140,2685, 35451,3141,2686, 35404,3094,2639, 2179,3142,2182, 35405,3095,2640, 2684,3143,2687, 35453,3144,2688, 
35454,3145,2689, 35407,3097,2642, 35406,3096,2641, 
2, // chain 650
2687,3146,2690, 2256,3147,2259, 2255,3148,2258, 
2688,3149,2691, 
11, // chain 651
2689,3150,2692, 2690,3151,2693, 2691,3152,2694, 
2692,3153,2695, 35461,3154,2696, 35462,3155,2697, 35463,3156,2698, 35464,3157,2699, 35458,3151,2693, 2697,3158,2700, 35466,3159,2701, 35467,3160,2702, 35457,3150,2692, 
28, // chain 652
2700,3161,2703, 2701,3162,2704, 2702,3163,2705, 
2703,3164,2706, 35472,3165,2707, 35473,3166,2708, 35474,3167,2709, 35475,3168,2710, 35469,3162,2704, 2708,3169,2711, 35477,3170,2712, 35478,3171,2713, 35479,3172,2714, 35468,3161,2703, 2712,3173,2715, 35471,3164,2706, 2713,3174,2716, 35482,3175,2717, 35483,3176,2718, 
35472,3165,2707, 2716,3177,2719, 35473,3166,2708, 2717,3178,2720, 35486,3179,2721, 35487,3180,2722, 35488,3181,2723, 35489,3182,2724, 35474,3167,2709, 2708,3169,2711, 35475,3168,2710, 
16, // chain 653
2722,3183,2725, 2723,3184,2726, 2724,3185,2727, 
2725,3186,2728, 35494,3187,2729, 35491,3184,2726, 2727,3188,2730, 35448,3138,2683, 35447,3137,2682, 35446,3136,2681, 35490,3183,2725, 2728,3189,2731, 35493,3186,2728, 2729,3190,2732, 35498,3191,2733, 35499,3192,2734, 35500,3193,2735, 2733,3194,2736, 
28, // chain 654
2734,3195,2737, 2735,3196,2738, 2736,3197,2739, 
2737,3198,2740, 35506,3199,2741, 35507,3200,2742, 35508,3201,2743, 35503,3196,2738, 2097,3202,2100, 34864,3203,2099, 34863,3204,2098, 35502,3195,2737, 2190,3205,2193, 34953,3206,2188, 35509,3207,2744, 35505,3198,2740, 2742,3208,2745, 35511,3209,2746, 35506,3199,2741, 
2744,3210,2747, 35513,3211,2748, 35514,3212,2749, 35507,3200,2742, 2747,3213,2750, 35516,3214,2751, 35517,3215,2752, 35518,3216,2753, 35508,3201,2743, 2002,3217,2005, 34865,3202,2100, 
7, // chain 655
2751,3218,2754, 2752,3219,2755, 2643,3101,2646, 
2644,3102,2647, 2753,3220,2756, 35522,3221,2757, 35430,3120,2665, 35413,3103,2648, 2646,3104,2649, 
12, // chain 656
2755,3222,2758, 2756,3223,2759, 2757,3224,2760, 
2758,3225,2761, 35527,3226,2762, 35528,3227,2763, 35524,3223,2759, 2761,3228,2764, 35530,3229,2765, 35531,3230,2766, 35523,3222,2758, 2764,3231,2767, 35533,3232,2768, 35456,3233,2691, 
5, // chain 657
2766,3234,2769, 1814,3235,1817, 1925,3236,1928, 
2767,3237,2770, 34692,3238,1927, 2197,3239,2200, 34688,3240,1923, 
45, // chain 658
2697,3158,2700, 2768,3241,2771, 2719,3180,2722, 
2696,3157,2699, 35463,3156,2698, 35488,3181,2723, 2721,3182,2724, 2708,3169,2711, 2769,3242,2772, 35538,3243,2773, 35477,3170,2712, 2771,3244,2774, 35478,3171,2713, 2772,3245,2775, 35541,3246,2776, 35542,3247,2777, 35479,3172,2714, 2775,3248,2778, 35544,3249,2779, 
35480,3173,2715, 2713,3174,2716, 2777,3250,2780, 35546,3251,2781, 35482,3175,2717, 2779,3252,2782, 35548,3253,2783, 35483,3176,2718, 2781,3254,2784, 35484,3177,2719, 2782,3255,2785, 35485,3178,2720, 2783,3256,2786, 35486,3179,2721, 2784,3257,2787, 35553,3258,2788, 
35487,3180,2722, 2768,3241,2771, 2786,3259,2789, 35555,3260,2790, 35556,3261,2791, 35465,3158,2700, 2698,3159,2701, 2789,3262,2792, 35558,3263,2793, 35559,3264,2794, 35560,3265,2795, 35467,3160,2702, 
4, // chain 659
2793,3266,2796, 2794,3267,2797, 1121,3268,1124, 
1069,3269,1072, 1247,3270,1250, 33838,3271,1073, 
3, // chain 660
2795,3272,2798, 2796,3273,2799, 2797,3274,2800, 
2798,3275,2801, 2799,3276,2802, 
23, // chain 661
2800,3277,2803, 2801,3278,2804, 2802,3279,2805, 
2803,3280,2806, 35572,3281,2807, 35573,3282,2808, 35569,3278,2804, 2733,3283,2736, 35574,3284,2809, 35575,3285,2810, 35576,3286,2811, 35568,3277,2803, 2787,3260,2790, 35554,3259,2789, 35577,3287,2812, 35571,3280,2806, 2810,3288,2813, 35579,3289,2814, 35572,3281,2807, 
2812,3290,2815, 35573,3282,2808, 2813,3291,2816, 35501,3283,2736, 2814,3292,2817, 35500,3293,2735, 
29, // chain 662
2815,3294,2818, 2816,3295,2819, 2817,3296,2820, 
2818,3297,2821, 35587,3298,2822, 35588,3299,2823, 35589,3300,2824, 35590,3301,2825, 35584,3295,2819, 2823,3302,2826, 35592,3303,2827, 35593,3304,2828, 35594,3305,2829, 35583,3294,2818, 2775,3248,2778, 35595,3306,2830, 35596,3307,2831, 35586,3297,2821, 2829,3308,2832, 
35598,3309,2833, 35587,3298,2822, 2831,3310,2834, 35600,3311,2835, 35601,3312,2836, 35588,3299,2823, 2834,3313,2837, 35589,3300,2824, 2835,3314,2838, 35604,3315,2839, 35591,3302,2826, 35590,3301,2825, 
10, // chain 663
2789,3262,2792, 2837,3316,2840, 2838,3317,2841, 
2788,3261,2791, 35555,3260,2790, 35576,3286,2811, 35575,3285,2810, 35605,3316,2840, 2731,3318,2734, 35607,3319,2842, 35557,3262,2792, 2790,3263,2793, 
30, // chain 664
2840,3320,2843, 2841,3321,2844, 2842,3322,2845, 
2843,3323,2846, 35612,3324,2847, 35534,3234,2769, 35613,3325,2848, 35609,3321,2844, 2846,3326,2849, 34967,3327,2202, 35608,3320,2843, 2847,3328,2850, 35616,3329,2851, 35611,3323,2846, 2849,3330,2852, 35618,3331,2853, 35619,3332,2854, 35612,3324,2847, 2852,3333,2855, 
35454,3145,2689, 35534,3234,2769, 2685,3144,2688, 35535,3237,2770, 2197,3239,2200, 2684,3143,2687, 35621,3334,2856, 34909,3335,2144, 2086,3336,2089, 2087,3337,2090, 2684,3143,2687, 34848,3338,2083, 2179,3142,2182, 
23, // chain 665
2854,3339,2857, 2855,3340,2858, 2856,3341,2859, 
2857,3342,2860, 35626,3343,2861, 35618,3331,2853, 35617,3330,2852, 35627,3344,2862, 35623,3340,2858, 2860,3345,2863, 35622,3339,2857, 2861,3346,2864, 35630,3347,2865, 35631,3348,2866, 35625,3342,2860, 2864,3349,2867, 35633,3350,2868, 35634,3351,2869, 35626,3343,2861, 
2850,3331,2853, 2851,3332,2854, 2852,3333,2855, 2867,3352,2870, 35407,3097,2642, 35454,3145,2689, 
10, // chain 666
2675,3133,2678, 2868,3353,2871, 2869,3354,2872, 
2674,3132,2677, 35638,3355,2873, 35639,3356,2874, 35636,3353,2871, 2872,3357,2875, 35641,3358,2876, 35642,3359,2877, 35444,3134,2679, 35443,3133,2678, 
8, // chain 667
2875,3360,2878, 2186,3361,2189, 2741,3207,2744, 
2876,3362,2879, 35510,3208,2745, 2877,3363,2880, 35646,3364,2881, 35647,3365,2882, 35511,3209,2746, 2744,3210,2747, 
14, // chain 668
2880,3366,2883, 2770,3243,2773, 2771,3244,2774, 
2881,3367,2884, 35650,3368,2885, 35540,3245,2775, 2883,3369,2886, 35652,3370,2887, 35653,3371,2888, 35654,3372,2889, 35541,3246,2776, 2887,3373,2890, 35656,3374,2891, 35542,3247,2777, 2827,3306,2830, 35543,3248,2778, 
28, // chain 669
2667,3125,2670, 2668,3126,2671, 2889,3375,2892, 
2890,3376,2893, 35659,3377,2894, 35660,3378,2895, 35661,3379,2896, 35436,3126,2671, 2603,3061,2606, 35437,3127,2672, 2602,3060,2605, 35662,3380,2897, 35438,3128,2673, 2895,3381,2898, 35439,3129,2674, 2673,3131,2676, 2896,3382,2899, 35665,3383,2900, 35442,3132,2677, 
2870,3355,2873, 2898,3384,2901, 35639,3356,2874, 2872,3357,2875, 2792,3385,2795, 35667,3386,2902, 35641,3358,2876, 2728,3189,2731, 35642,3359,2877, 2677,3135,2680, 35444,3134,2679, 
41, // chain 670
2900,3387,2903, 2901,3388,2904, 2902,3389,2905, 
2903,3390,2906, 35672,3391,2907, 35673,3392,2908, 35674,3393,2909, 35675,3394,2910, 35669,3388,2904, 2908,3395,2911, 35677,3396,2912, 35678,3397,2913, 35668,3387,2903, 2911,3398,2914, 35671,3390,2906, 2912,3399,2915, 35681,3400,2916, 35592,3303,2827, 35672,3391,2907, 
2914,3401,2917, 35683,3402,2918, 35673,3392,2908, 2916,3403,2919, 35685,3404,2920, 35674,3393,2909, 2918,3405,2921, 35687,3406,2922, 35688,3407,2923, 35675,3394,2910, 2908,3395,2911, 2921,3408,2924, 35677,3396,2912, 2922,3409,2925, 35678,3397,2913, 2923,3410,2926, 
35692,3411,2927, 35679,3398,2914, 2912,3399,2915, 2925,3412,2928, 35681,3400,2916, 2926,3413,2929, 35593,3304,2828, 35592,3303,2827, 
9, // chain 671
2927,3414,2930, 2894,3380,2897, 2895,3381,2898, 
2896,3382,2899, 2928,3415,2931, 35697,3416,2932, 35665,3383,2900, 2689,3417,2692, 35467,3418,2702, 35560,3385,2795, 35666,3384,2901, 
22, // chain 672
2930,3419,2933, 2931,3420,2934, 2932,3421,2935, 
2933,3422,2936, 35702,3423,2937, 35703,3424,2938, 35704,3425,2939, 35705,3426,2940, 35699,3420,2934, 2938,3427,2941, 35707,3428,2942, 35698,3419,2933, 2940,3429,2943, 35709,3430,2944, 35710,3431,2945, 35701,3422,2936, 2943,3432,2946, 35450,3140,2685, 35449,3139,2684, 
35702,3423,2937, 2680,3138,2683, 35703,3424,2938, 2727,3188,2730, 35704,3425,2939, 
11, // chain 673
2944,3433,2947, 2945,3434,2948, 2946,3435,2949, 
2947,3436,2950, 35716,3437,2951, 35562,3267,2797, 35717,3438,2952, 35713,3434,2948, 2950,3439,2953, 35719,3440,2954, 35720,3441,2955, 35712,3433,2947, 2953,3442,2956, 
7, // chain 674
2186,3361,2189, 2875,3360,2878, 2954,3443,2957, 
35644,3362,2879, 2796,3273,2799, 35645,3363,2880, 2797,3274,2800, 35723,3444,2958, 35646,3364,2881, 
19, // chain 675
2956,3445,2959, 2830,3309,2833, 2831,3310,2834, 
2957,3446,2960, 35726,3447,2961, 35600,3311,2835, 2959,3448,2962, 35728,3449,2963, 35729,3450,2964, 35730,3451,2965, 35601,3312,2836, 2834,3313,2837, 2835,3314,2838, 2963,3452,2966, 35732,3453,2967, 35733,3454,2968, 35604,3315,2839, 2915,3402,2918, 35682,3401,2917, 
35592,3303,2827, 35591,3302,2826, 
12, // chain 676
2966,3455,2969, 2782,3255,2785, 2967,3456,2970, 
2968,3457,2971, 35434,3124,2669, 35433,3123,2668, 35737,3458,2972, 35550,3255,2785, 2783,3256,2786, 2664,3122,2667, 35738,3459,2973, 35552,3257,2787, 2786,3259,2789, 35553,3258,2788, 
5, // chain 677
2971,3460,2974, 2606,3064,2609, 2972,3461,2975, 
2973,3462,2976, 35742,3463,2977, 35375,3065,2610, 35374,3064,2609, 
18, // chain 678
2975,3464,2978, 2976,3465,2979, 2977,3466,2980, 
2978,3467,2981, 35747,3468,2982, 35748,3469,2983, 2888,3374,2891, 35655,3373,2890, 35749,3470,2984, 2982,3471,2985, 2886,3372,2889, 35751,3472,2986, 2885,3371,2888, 35752,3473,2987, 2884,3370,2887, 35651,3369,2886, 35753,3474,2988, 2882,3368,2885, 35754,3475,2989, 
35755,3476,2990, 
1, // chain 679
2597,3055,2600, 2598,3056,2601, 2988,3477,2991, 
48, // chain 680
2989,3478,2992, 2990,3479,2993, 2991,3480,2994, 
2992,3481,2995, 35761,3482,2996, 35762,3483,2997, 35758,3479,2993, 2995,3484,2998, 35764,3485,2999, 35765,3486,3000, 35757,3478,2992, 2992,3481,2995, 2998,3487,3001, 35767,3488,3002, 35761,3482,2996, 3000,3489,3003, 35769,3490,3004, 35770,3491,3005, 35762,3483,2997, 
2995,3484,2998, 3003,3492,3006, 35772,3493,3007, 35764,3485,2999, 3005,3494,3008, 35765,3486,3000, 2998,3487,3001, 2612,3070,2615, 35774,3495,3009, 35775,3496,3010, 35776,3497,3011, 35767,3488,3002, 3009,3498,3012, 35768,3489,3003, 2920,3407,2923, 35778,3499,3013, 
35779,3500,3014, 35769,3490,3004, 3012,3501,3015, 35781,3502,3016, 35782,3503,3017, 35770,3491,3005, 3003,3492,3006, 3015,3504,3018, 35784,3505,3019, 35785,3506,3020, 35772,3493,3007, 3018,3507,3021, 35382,3072,2617, 35773,3494,3008, 2612,3070,2615, 
8, // chain 681
3007,3496,3010, 3008,3497,3011, 3019,3508,3022, 
3020,3509,3023, 35691,3410,2926, 35789,3510,3024, 35776,3497,3011, 2921,3408,2924, 35777,3498,3012, 2920,3407,2923, 
17, // chain 682
3022,3511,3025, 3023,3512,3026, 3024,3513,3027, 
2892,3378,2895, 35659,3377,2894, 35793,3514,3028, 35794,3515,3029, 35791,3512,3026, 3027,3516,3030, 35796,3517,3031, 35797,3518,3032, 35374,3064,2609, 35373,3063,2608, 35798,3519,3033, 35790,3511,3025, 2892,3378,2895, 2893,3379,2896, 2604,3062,2607, 35371,3061,2606, 
14, // chain 683
3031,3520,3034, 3032,3521,3035, 2860,3345,2863, 
2861,3346,2864, 2812,3290,2815, 35579,3289,2814, 35630,3347,2865, 2810,3288,2813, 35631,3348,2866, 3033,3522,3036, 35632,3349,2867, 3034,3523,3037, 35633,3350,2868, 3035,3524,3038, 35635,3352,2870, 35634,3351,2869, 
2, // chain 684
3032,3521,3035, 3031,3520,3034, 2813,3291,2816, 
35580,3290,2815, 
6, // chain 685
3036,3525,3039, 2776,3249,2779, 3037,3526,3040, 
2826,3305,2829, 35694,3413,2929, 35806,3527,3041, 35545,3250,2780, 35544,3249,2779, 
1, // chain 686
2186,3361,2189, 2185,3206,2188, 2741,3207,2744, 
6, // chain 687
3039,3528,3042, 1247,3270,1250, 1072,3529,1075, 
2847,3328,2850, 33841,3530,1076, 2199,3327,2202, 33827,3531,1062, 2201,3532,2204, 
5, // chain 688
3040,3533,3043, 3041,3534,3044, 2586,3535,2589, 
2585,3536,2588, 2477,3537,2480, 35244,3538,2479, 35346,3539,2581, 
10, // chain 689
3042,3540,3045, 2598,3056,2601, 2599,3057,2602, 
3043,3541,3046, 35812,3542,3047, 35368,3058,2603, 2692,3543,2695, 35696,3415,2931, 35369,3059,2604, 2927,3414,2930, 35370,3060,2605, 2894,3380,2897, 
5, // chain 690
2974,3463,2977, 2607,3065,2610, 2608,3066,2611, 
3006,3495,3009, 35380,3070,2615, 35377,3067,2612, 2610,3068,2613, 
12, // chain 691
2750,3216,2753, 2002,3217,2005, 1914,3544,1917, 
3045,3545,3048, 35814,3546,3049, 35815,3547,3050, 34680,3548,1915, 2543,3549,2546, 2584,3550,2587, 3048,3551,3051, 35817,3552,3052, 35355,3553,2590, 35356,3554,2591, 35310,3555,2545, 
3, // chain 692
3050,3556,3053, 1119,3557,1122, 1120,3558,1123, 
2794,3267,2797, 33889,3268,1124, 
6, // chain 693
2796,3273,2799, 2795,3272,2798, 2940,3429,2943, 
2941,3430,2944, 2954,3443,2957, 35819,3559,3054, 35711,3432,2946, 35710,3431,2945, 
3, // chain 694
3052,3560,3055, 2947,3436,2950, 2859,3344,2862, 
3032,3521,3035, 35628,3345,2863, 
7, // chain 695
3048,3551,3051, 3049,3552,3052, 3053,3561,3056, 
35822,3562,3057, 35823,3563,3058, 35355,3553,2590, 3041,3534,3044, 35354,3535,2589, 35346,3564,2581, 
23, // chain 696
3054,3562,3057, 3056,3565,3059, 3057,3566,3060, 
3053,3561,3056, 35826,3567,3061, 35827,3568,3062, 35517,3215,2752, 35828,3569,3063, 35824,3565,3059, 3061,3570,3064, 35830,3571,3065, 35831,3572,3066, 35832,3573,3067, 35822,3562,3057, 3055,3563,3058, 3065,3574,3068, 35834,3575,3069, 35809,3534,3044, 3067,3576,3070, 
35808,3533,3043, 3068,3577,3071, 35245,3537,2480, 3069,3578,3072, 35239,3579,2474, 35246,3580,2481, 
5, // chain 697
2793,3266,2796, 1247,3270,1250, 3039,3528,3042, 
3070,3581,3073, 35617,3330,2852, 35616,3329,2851, 35615,3328,2850, 
19, // chain 698
2867,3352,2870, 2639,3097,2642, 3035,3524,3038, 
35408,3098,2643, 3034,3523,3037, 35839,3582,3074, 35409,3099,2644, 2642,3100,2645, 3072,3583,3075, 35411,3101,2646, 2752,3219,2755, 3073,3584,3076, 35842,3585,3077, 35554,3259,2789, 35519,3218,2754, 2970,3459,2973, 35521,3220,2756, 2664,3122,2667, 35431,3121,2666, 
35522,3221,2757, 2662,3120,2665, 
5, // chain 699
3075,3586,3078, 3076,3587,3079, 3077,3588,3080, 
2747,3213,2750, 35514,3212,2749, 35846,3589,3081, 35847,3590,3082, 
5, // chain 700
3080,3591,3083, 1245,3592,1248, 1119,3557,1122, 
3050,3556,3053, 2950,3439,2953, 35717,3438,2952, 35562,3267,2797, 
2, // chain 701
2806,3284,2809, 2807,3285,2810, 2731,3318,2734, 
2733,3283,2736, 
14, // chain 702
3006,3495,3009, 3007,3496,3010, 2973,3462,2976, 
35788,3509,3023, 2971,3460,2974, 35796,3517,3031, 35849,3593,3084, 35850,3594,3085, 35851,3595,3086, 35691,3410,2926, 2924,3411,2927, 2925,3412,2928, 3082,3594,3085, 35545,3250,2780, 35806,3527,3041, 35694,3413,2929, 
5, // chain 703
3081,3593,3084, 3082,3594,3085, 3084,3596,3087, 
2779,3252,2782, 35546,3251,2781, 35850,3594,3085, 2777,3250,2780, 
5, // chain 704
3085,3597,3088, 3086,3598,3089, 3087,3599,3090, 
3088,3600,3091, 35778,3499,3013, 35688,3407,2923, 35687,3406,2922, 
3, // chain 705
3089,3601,3092, 3090,3602,3093, 3091,3603,3094, 
2953,3604,2956, 35860,3605,3095, 
2, // chain 706
3045,3545,3048, 3059,3568,3062, 2749,3215,2752, 
2750,3216,2753, 
4, // chain 707
3093,3606,3096, 2978,3467,2981, 2979,3468,2982, 
2888,3374,2891, 2828,3307,2831, 35595,3306,2830, 
3, // chain 708
2178,3607,2181, 2061,3608,2064, 2062,3609,2065, 
2186,3361,2189, 34826,3610,2061, 
3, // chain 709
3094,3611,3097, 3095,3612,3098, 2881,3367,2884, 
2986,3475,2989, 35650,3368,2885, 
2, // chain 710
2880,3366,2883, 3095,3612,3098, 2769,3242,2772, 
2770,3243,2773, 
1, // chain 711
2814,3292,2817, 3096,3613,3099, 3097,3614,3100, 
2, // chain 712
2809,3287,2812, 3073,3584,3076, 3074,3585,3077, 
2786,3259,2789, 
5, // chain 713
2959,3448,2962, 2960,3449,2963, 3098,3615,3101, 
3099,3616,3102, 2759,3226,2762, 35868,3617,3103, 2758,3225,2761, 
8, // chain 714
3101,3618,3104, 3102,3619,3105, 3103,3620,3106, 
3104,3621,3107, 35873,3622,3108, 35874,3623,3109, 3107,3624,3110, 3104,3621,3107, 35731,3452,2966, 35876,3625,3111, 
3, // chain 715
3109,3626,3112, 3110,3627,3113, 2918,3405,2921, 
2919,3406,2922, 3111,3628,3114, 
3, // chain 716
2948,3437,2951, 2793,3266,2796, 3070,3581,3073, 
2859,3344,2862, 35617,3330,2852, 
1, // chain 717
2728,3189,2731, 2677,3135,2680, 2678,3136,2681, 
3, // chain 718
3112,3629,3115, 2615,3073,2618, 3113,3630,3116, 
3018,3507,3021, 35785,3506,3020, 
5, // chain 719
2766,3234,2769, 2845,3325,2848, 1813,3631,1816, 
35614,3326,2849, 1805,3632,1808, 34966,3633,2201, 34967,3327,2202, 
6, // chain 720
3089,3601,3092, 2953,3604,2956, 2944,3433,2947, 
2947,3436,2950, 3052,3560,3055, 3032,3521,3035, 2814,3292,2817, 35581,3291,2816, 
4, // chain 721
3114,3634,3117, 2256,3147,2259, 3115,3635,3118, 
3116,3636,3119, 35455,3146,2690, 35024,3147,2259, 
3, // chain 722
2694,3155,2697, 2695,3156,2698, 2769,3242,2772, 
2693,3154,2696, 35863,3612,3098, 
2, // chain 723
2923,3410,2926, 3021,3510,3024, 2922,3409,2925, 
35689,3408,2924, 
2, // chain 724
2776,3249,2779, 3036,3525,3039, 2775,3248,2778, 
35594,3305,2829, 
14, // chain 725
2830,3309,2833, 2956,3445,2959, 3117,3637,3120, 
2978,3467,2981, 35743,3464,2978, 35886,3638,3121, 35724,3445,2959, 2764,3231,2767, 35531,3230,2766, 35530,3229,2765, 35725,3446,2960, 2761,3228,2764, 35528,3227,2763, 35726,3447,2961, 2759,3226,2762, 35727,3448,2962, 
6, // chain 726
3119,3639,3122, 3012,3501,3015, 3120,3640,3123, 
35781,3502,3016, 3121,3641,3124, 35890,3642,3125, 35783,3504,3018, 35782,3503,3017, 
6, // chain 727
2810,3288,2813, 3033,3522,3036, 3123,3643,3126, 
3073,3584,3076, 35840,3583,3075, 35801,3522,3036, 3034,3523,3037, 3071,3582,3074, 
5, // chain 728
2977,3466,2980, 2976,3465,2979, 3124,3644,3127, 
35893,3645,3128, 35532,3231,2767, 35886,3638,3121, 35743,3464,2978, 
1, // chain 729
2764,3231,2767, 2765,3232,2768, 3125,3645,3128, 
4, // chain 730
2918,3405,2921, 3101,3618,3104, 2916,3403,2919, 
35732,3453,2967, 35872,3621,3107, 2963,3452,2966, 
1, // chain 731
2969,3458,2972, 2664,3122,2667, 2665,3123,2668, 
4, // chain 732
3058,3567,3061, 3059,3568,3062, 3045,3545,3048, 
3046,3546,3049, 3048,3551,3051, 35815,3547,3050, 
2, // chain 733
1925,3236,1928, 1814,3235,1817, 1810,3646,1813, 
34579,3647,1814, 
1, // chain 734
3030,3519,3033, 2604,3062,2607, 2605,3063,2608, 
7, // chain 735
2729,3190,2732, 2730,3191,2733, 3126,3648,3129, 
2728,3189,2731, 35667,3386,2902, 35895,3649,3130, 35498,3191,2733, 2839,3650,2842, 35499,3192,2734, 
2, // chain 736
3029,3518,3032, 2606,3064,2609, 2971,3460,2974, 
3028,3517,3031, 
3, // chain 737
3128,3651,3131, 3129,3652,3132, 3016,3505,3019, 
3114,3634,3117, 35024,3147,2259, 
2, // chain 738
3081,3593,3084, 2779,3252,2782, 3027,3516,3030, 
3028,3517,3031, 
3, // chain 739
2790,3653,2793, 2791,3654,2794, 3127,3649,3130, 
35667,3386,2902, 35560,3385,2795, 
1, // chain 740
2400,3655,2403, 3130,3656,3133, 2977,3466,2980, 
3, // chain 741
3131,3657,3134, 1245,3592,1248, 3080,3591,3083, 
2950,3439,2953, 2951,3440,2954, 
5, // chain 742
3025,3514,3028, 2966,3455,2969, 2968,3457,2971, 
2891,3377,2894, 35658,3376,2893, 35434,3124,2669, 2667,3125,2670, 
1, // chain 743
2766,3234,2769, 1813,3631,1816, 1814,3235,1817, 
2, // chain 744
2726,3187,2729, 3097,3658,3100, 3096,3659,3099, 
2725,3186,2728, 
2, // chain 745
3051,3559,3054, 2178,3607,2181, 2186,3361,2189, 
2954,3443,2957, 
4, // chain 746
2943,3432,2946, 2682,3140,2685, 2683,3141,2686, 
3051,3559,3054, 34946,3607,2181, 34947,3142,2182, 
1, // chain 747
2917,3404,2920, 2918,3405,2921, 2916,3403,2919, 
2, // chain 748
3112,3629,3115, 3018,3507,3021, 2614,3072,2617, 
2615,3073,2618, 
2, // chain 749
3044,3542,3047, 2692,3543,2695, 2693,3660,2696, 
3043,3541,3046, 
2, // chain 750
2755,3222,2758, 2758,3225,2761, 2687,3661,2690, 
35900,3662,3135, 
4, // chain 751
3065,3574,3068, 3066,3575,3069, 3067,3576,3070, 
3063,3572,3066, 35837,3578,3072, 35836,3577,3071, 
4, // chain 752
3133,3663,3136, 3134,3664,3137, 3062,3571,3065, 
3063,3572,3066, 3135,3665,3138, 35837,3578,3072, 
3, // chain 753
2829,3308,2832, 2830,3309,2833, 2978,3467,2981, 
3093,3606,3096, 2828,3307,2831, 
2, // chain 754
2963,3452,2966, 2960,3449,2963, 2961,3450,2964, 
2962,3451,2965, 
1, // chain 755
2726,3187,2729, 2727,3188,2730, 3097,3658,3100, 
6, // chain 756
2748,3214,2751, 3060,3569,3063, 3061,3570,3064, 
2747,3213,2750, 35843,3586,3078, 35904,3666,3139, 35902,3664,3137, 35830,3571,3065, 
1, // chain 757
2745,3211,2748, 2746,3212,2749, 3078,3589,3081, 
2, // chain 758
3016,3505,3019, 3129,3652,3132, 3122,3642,3125, 
3015,3504,3018, 
3, // chain 759
2939,3428,2942, 2795,3272,2798, 3137,3667,3140, 
3138,3668,3141, 2938,3427,2941, 
1, // chain 760
3139,3669,3142, 2744,3210,2747, 2745,3211,2748, 
3, // chain 761
3135,3665,3138, 3140,3670,3143, 3141,3671,3144, 
3134,3664,3137, 3133,3663,3136, 
3, // chain 762
3129,3652,3132, 3128,3651,3131, 3142,3672,3145, 
3121,3641,3124, 3122,3642,3125, 
1, // chain 763
1245,3592,1248, 3131,3657,3134, 1117,3673,1120, 
1, // chain 764
2002,3217,2005, 1913,3674,1916, 1914,3544,1917, 
1, // chain 765
2790,3653,2793, 3127,3649,3130, 2839,3650,2842, 
1, // chain 766
2793,3266,2796, 2948,3437,2951, 2794,3267,2797, 
2, // chain 767
2692,3543,2695, 2928,3415,2931, 2929,3416,2932, 
2689,3417,2692, 
1, // chain 768
2190,3205,2193, 2185,3206,2188, 2094,3675,2097, 
8, // chain 769
3027,3516,3030, 2779,3252,2782, 3026,3515,3029, 
35911,3676,3146, 35548,3253,2783, 2781,3254,2784, 2782,3255,2785, 2966,3455,2969, 3025,3514,3028, 3026,3515,3029, 
1, // chain 770
3053,3561,3056, 3058,3567,3061, 3048,3551,3051, 
1, // chain 771
2880,3366,2883, 2881,3367,2884, 3095,3612,3098, 
2, // chain 772
3136,3666,3139, 3134,3664,3137, 3076,3587,3079, 
3075,3586,3078, 
1, // chain 773
3144,3677,3147, 3088,3678,3091, 3011,3500,3014, 
2, // chain 774
2965,3454,2968, 2915,3402,2918, 2916,3403,2919, 
2964,3453,2967, 
1, // chain 775
2825,3304,2828, 2826,3305,2829, 2926,3413,2929, 
1, // chain 776
3073,3584,3076, 2809,3287,2812, 2810,3288,2813, 
1, // chain 777
2748,3214,2751, 2749,3215,2752, 3060,3569,3063, 
1, // chain 778
3063,3572,3066, 3064,3573,3067, 3065,3574,3068, 
1, // chain 779
2859,3344,2862, 2947,3436,2950, 2948,3437,2951, 
1, // chain 780
2974,3463,2977, 3006,3495,3009, 2973,3462,2976, 
1, // chain 781
3120,3640,3123, 3121,3641,3124, 3119,3639,3122, 
1, // chain 782
2814,3292,2817, 3090,3602,3093, 3089,3601,3092, 
1, // chain 783
2646,3104,2649, 2647,3105,2650, 2661,3119,2664, 
1, // chain 784
2795,3272,2798, 2939,3428,2942, 2940,3429,2943, 
1, // chain 785
3011,3500,3014, 3012,3501,3015, 3144,3679,3147, 
26, // chain 786
3145,3680,3148, 3146,3681,3149, 3147,3682,3150, 
3148,3683,3151, 35917,3684,3152, 35918,3685,3153, 35919,3686,3154, 35914,3681,3149, 3152,3687,3155, 35921,3688,3156, 3154,3689,3157, 35923,3690,3158, 3156,3691,3159, 35925,3692,3160, 3158,3693,3161, 35927,3694,3162, 3160,3695,3163, 35929,3696,3164, 3162,3697,3165, 
35931,3698,3166, 3164,3699,3167, 35933,3700,3168, 35934,3701,3169, 3167,3702,3170, 3168,3703,3171, 3169,3704,3172, 35938,3705,3173, 35939,3706,3174, 
32, // chain 787
3172,3707,3175, 3173,3708,3176, 3174,3709,3177, 
3175,3710,3178, 35944,3711,3179, 35945,3712,3180, 35946,3713,3181, 35941,3708,3176, 3179,3714,3182, 35940,3707,3175, 3180,3715,3183, 35949,3716,3184, 35943,3710,3178, 3182,3717,3185, 35951,3718,3186, 35952,3719,3187, 35944,3711,3179, 3185,3720,3188, 35945,3712,3180, 
3186,3721,3189, 35955,3722,3190, 35946,3713,3181, 3188,3723,3191, 35957,3724,3192, 35958,3725,3193, 35959,3726,3194, 35947,3714,3182, 3192,3727,3195, 35948,3715,3183, 3193,3728,3196, 35962,3729,3197, 35963,3730,3198, 35950,3717,3185, 35949,3716,3184, 
26, // chain 788
3196,3731,3199, 3197,3732,3200, 3198,3733,3201, 
3199,3734,3202, 35968,3735,3203, 35969,3736,3204, 35970,3737,3205, 35965,3732,3200, 3203,3738,3206, 35351,3739,2586, 35348,3740,2583, 35964,3731,3199, 2577,3741,2580, 35972,3742,3207, 35967,3734,3202, 3205,3743,3208, 35974,3744,3209, 35975,3745,3210, 35968,3735,3203, 
3201,3736,3204, 3208,3746,3211, 35977,3747,3212, 35970,3737,3205, 3210,3748,3213, 35979,3749,3214, 35971,3738,3206, 2581,3750,2584, 35351,3739,2586, 
113, // chain 789
3212,3751,3215, 3213,3752,3216, 3214,3753,3217, 
3215,3754,3218, 35984,3755,3219, 35985,3756,3220, 35986,3757,3221, 35987,3758,3222, 35988,3759,3223, 35981,3752,3216, 3221,3760,3224, 35990,3761,3225, 35991,3762,3226, 35980,3751,3215, 3215,3754,3218, 3224,3763,3227, 35993,3764,3228, 35994,3765,3229, 35984,3755,3219, 
3227,3766,3230, 35985,3756,3220, 3228,3767,3231, 35997,3768,3232, 35986,3757,3221, 3230,3769,3233, 35987,3758,3222, 3231,3770,3234, 36000,3771,3235, 35988,3759,3223, 3233,3772,3236, 36002,3773,3237, 35989,3760,3224, 3235,3774,3238, 36004,3775,3239, 36005,3776,3240, 
35990,3761,3225, 3238,3777,3241, 36007,3778,3242, 35991,3762,3226, 3240,3779,3243, 35992,3763,3227, 3241,3780,3244, 35993,3764,3228, 3242,3781,3245, 36011,3782,3246, 36012,3783,3247, 35994,3765,3229, 3245,3784,3248, 35995,3766,3230, 3246,3785,3249, 35996,3767,3231, 
3247,3786,3250, 35997,3768,3232, 3248,3787,3251, 36017,3788,3252, 35998,3769,3233, 3250,3789,3253, 36019,3790,3254, 35999,3770,3234, 3171,3791,3174, 36000,3771,3235, 3233,3772,3236, 3252,3792,3255, 36021,3793,3256, 36002,3773,3237, 3254,3794,3257, 36003,3774,3238, 
3236,3775,3239, 3255,3795,3258, 36024,3796,3259, 36025,3797,3260, 36026,3798,3261, 36005,3776,3240, 3259,3799,3262, 36028,3800,3263, 36006,3777,3241, 3261,3801,3264, 34004,3802,1239, 34003,3803,1238, 36030,3804,3265, 36007,3778,3242, 3240,3779,3243, 3263,3805,3266, 
36009,3780,3244, 3264,3806,3267, 36010,3781,3245, 3265,3807,3268, 36034,3808,3269, 36011,3782,3246, 3267,3809,3270, 36036,3810,3271, 36037,3811,3272, 36038,3812,3273, 36012,3783,3247, 3271,3813,3274, 36013,3784,3248, 3272,3814,3275, 36041,3815,3276, 36042,3816,3277, 
36014,3785,3249, 3275,3817,3278, 36015,3786,3250, 3276,3818,3279, 36016,3787,3251, 3277,3819,3280, 36046,3820,3281, 36017,3788,3252, 3250,3789,3253, 3279,3821,3282, 36019,3790,3254, 3280,3822,3283, 35934,3823,3169, 35935,3824,3170, 35936,3825,3171, 35939,3791,3174, 
30, // chain 790
3281,3826,3284, 3282,3827,3285, 3283,3828,3286, 
3284,3829,3287, 36053,3830,3288, 36054,3831,3289, 36055,3832,3290, 36056,3833,3291, 36050,3827,3285, 3289,3834,3292, 36058,3835,3293, 36059,3836,3294, 36049,3826,3284, 3292,3837,3295, 36052,3829,3287, 3293,3838,3296, 36062,3839,3297, 36063,3840,3298, 36053,3830,3288, 
3296,3841,3299, 36065,3842,3300, 36066,3843,3301, 36054,3831,3289, 3299,3844,3302, 36068,3845,3303, 36069,3846,3304, 36055,3832,3290, 3288,3833,3291, 3302,3847,3305, 35862,3848,3097, 36058,3835,3293, 36057,3834,3292, 
20, // chain 791
3303,3849,3306, 3304,3850,3307, 3305,3851,3308, 
3306,3852,3309, 36075,3853,3310, 35952,3719,3187, 36072,3850,3307, 3183,3718,3186, 36076,3854,3311, 36077,3855,3312, 36078,3856,3313, 36079,3857,3314, 36071,3849,3306, 3312,3858,3315, 36081,3859,3316, 36082,3860,3317, 36074,3852,3309, 3315,3861,3318, 36084,3862,3319, 
36075,3853,3310, 3185,3720,3188, 35952,3719,3187, 
42, // chain 792
3317,3863,3320, 3265,3807,3268, 3266,3808,3269, 
3267,3809,3270, 3318,3864,3321, 36036,3810,3271, 3319,3865,3322, 36037,3811,3272, 3320,3866,3323, 36089,3867,3324, 36090,3868,3325, 36038,3812,3273, 3271,3813,3274, 3323,3869,3326, 36040,3814,3275, 3324,3870,3327, 36041,3815,3276, 3325,3871,3328, 36094,3872,3329, 
36095,3873,3330, 36096,3874,3331, 36042,3816,3277, 3275,3817,3278, 3329,3875,3332, 36044,3818,3279, 3277,3819,3280, 3330,3876,3333, 36046,3820,3281, 3331,3877,3334, 36100,3878,3335, 36101,3879,3336, 36047,3821,3282, 3334,3880,3337, 36103,3881,3338, 36048,3822,3283, 
3166,3823,3169, 3163,3882,3166, 3161,3883,3164, 3336,3884,3339, 36105,3885,3340, 35927,3886,3162, 3338,3887,3341, 35923,3888,3158, 35925,3889,3160, 
14, // chain 793
2419,3890,2422, 3339,3891,3342, 3340,3892,3343, 
2358,3893,2361, 35183,3894,2418, 36109,3895,3344, 36110,3896,3345, 36107,3891,3342, 3343,3897,3346, 35187,3890,2422, 3344,3898,3347, 35186,3899,2421, 2417,3900,2420, 3345,3901,3348, 35120,3902,2355, 35119,3903,2354, 
6, // chain 794
3346,3904,3349, 3347,3905,3350, 3348,3906,3351, 
3349,3907,3352, 36118,3908,3353, 3351,3909,3354, 3253,3793,3256, 36020,3792,3255, 
81, // chain 795
3352,3910,3355, 3353,3911,3356, 3354,3912,3357, 
3355,3913,3358, 36124,3914,3359, 36125,3915,3360, 36126,3916,3361, 36127,3917,3362, 36128,3918,3363, 36129,3919,3364, 36121,3911,3356, 3362,3920,3365, 36131,3921,3366, 36120,3910,3355, 3364,3922,3367, 36133,3923,3368, 36134,3924,3369, 36123,3913,3358, 3367,3925,3370, 
36136,3926,3371, 36124,3914,3359, 3369,3927,3372, 36125,3915,3360, 3370,3928,3373, 36139,3929,3374, 36126,3916,3361, 3372,3930,3375, 36127,3917,3362, 3373,3931,3376, 36128,3918,3363, 3374,3932,3377, 36143,3933,3378, 36144,3934,3379, 36129,3919,3364, 3362,3920,3365, 
3377,3935,3380, 36146,3936,3381, 36147,3937,3382, 36131,3921,3366, 3364,3922,3367, 3313,3859,3316, 36080,3858,3315, 36148,3938,3383, 36133,3923,3368, 3381,3939,3384, 36150,3940,3385, 36134,3924,3369, 3383,3941,3386, 36135,3925,3370, 3384,3942,3387, 36153,3943,3388, 
36154,3944,3389, 36136,3926,3371, 3387,3945,3390, 36137,3927,3372, 3370,3928,3373, 3388,3946,3391, 36157,3947,3392, 36139,3929,3374, 3390,3948,3393, 36159,3949,3394, 36140,3930,3375, 3392,3950,3395, 36161,3951,3396, 36141,3931,3376, 3394,3952,3397, 36142,3932,3377, 
3395,3953,3398, 36067,3844,3302, 36164,3954,3399, 36143,3933,3378, 3376,3934,3379, 3397,3955,3400, 36166,3956,3401, 36167,3957,3402, 36145,3935,3380, 3378,3936,3381, 3400,3958,3403, 36084,3862,3319, 36083,3861,3318, 36147,3937,3382, 3314,3860,3317, 36081,3859,3316, 
9, // chain 796
2405,3959,2408, 2404,3960,2407, 3401,3961,3404, 
36170,3962,3405, 35023,3963,2258, 36171,3964,3406, 35170,3965,2405, 2765,3966,2768, 35169,3967,2404, 3125,3968,3128, 35168,3969,2403, 
15, // chain 797
3404,3970,3407, 3139,3971,3142, 3405,3972,3408, 
3406,3973,3409, 36175,3974,3410, 36176,3975,3411, 36177,3976,3412, 35907,3971,3142, 2745,3977,2748, 3410,3978,3413, 36179,3979,3414, 35846,3980,3081, 3079,3981,3082, 3412,3982,3415, 36181,3983,3416, 35844,3984,3079, 35845,3985,3080, 
21, // chain 798
3414,3986,3417, 3415,3987,3418, 3416,3988,3419, 
3387,3945,3390, 36154,3944,3389, 36153,3943,3388, 36185,3989,3420, 35384,3990,2619, 36183,3987,3418, 3418,3991,3421, 36182,3986,3417, 3419,3992,3422, 36155,3945,3390, 3420,3993,3423, 36156,3946,3391, 3421,3994,3424, 36190,3995,3425, 36157,3947,3392, 3390,3948,3393, 
3423,3996,3426, 36192,3997,3427, 36160,3950,3395, 36159,3949,3394, 
19, // chain 799
3294,3839,3297, 3425,3998,3428, 3426,3999,3429, 
3293,3838,3296, 36060,3837,3295, 36195,4000,3430, 36196,4001,3431, 36193,3998,3428, 3429,4002,3432, 36198,4003,3433, 36062,3839,3297, 3431,4004,3434, 36200,4005,3435, 36063,3840,3298, 3296,3841,3299, 3398,3956,3401, 36065,3842,3300, 3397,3955,3400, 36066,3843,3301, 
3396,3954,3399, 36067,3844,3302, 
16, // chain 800
3433,4006,3436, 3434,4007,3437, 3435,4008,3438, 
3162,3697,3165, 35928,3695,3163, 36204,4009,3439, 36205,4010,3440, 36202,4007,3437, 3438,4011,3441, 36207,4012,3442, 36208,4013,3443, 36209,4014,3444, 36210,4015,3445, 36211,4016,3446, 36212,4017,3447, 36201,4006,3436, 3164,3699,3167, 35930,3697,3165, 
20, // chain 801
3445,4018,3448, 3446,4019,3449, 3447,4020,3450, 
3448,4021,3451, 36217,4022,3452, 35178,4023,2413, 34982,4024,2217, 34983,4025,2218, 35182,4026,2417, 36214,4019,3449, 3450,4027,3453, 36213,4018,3448, 3451,4028,3454, 36190,3995,3425, 36189,3994,3424, 36216,4021,3451, 3452,4029,3455, 36217,4022,3452, 3453,4030,3456, 
36222,4031,3457, 35179,4032,2414, 35178,4023,2413, 
10, // chain 802
3423,3996,3426, 3455,4033,3458, 3456,4034,3459, 
3457,4035,3460, 36113,3901,3348, 36112,3898,3347, 36111,3897,3346, 36223,4033,3458, 3342,3896,3345, 36226,4036,3461, 36192,3997,3427, 36191,3996,3426, 
65, // chain 803
3459,4037,3462, 3460,4038,3463, 3461,4039,3464, 
3462,4040,3465, 36231,4041,3466, 36232,4042,3467, 36233,4043,3468, 36234,4044,3469, 36235,4045,3470, 36228,4038,3463, 3468,4046,3471, 36237,4047,3472, 36238,4048,3473, 36239,4049,3474, 36227,4037,3462, 3472,4050,3475, 36241,4051,3476, 36242,4052,3477, 36230,4040,3465, 
3475,4053,3478, 36231,4041,3466, 3476,4054,3479, 36232,4042,3467, 3477,4055,3480, 36233,4043,3468, 3466,4044,3469, 3404,3970,3407, 36246,4056,3481, 36247,4057,3482, 36248,4058,3483, 36235,4045,3470, 3481,4059,3484, 36236,4046,3471, 3469,4047,3472, 3482,4060,3485, 
36251,4061,3486, 36252,4062,3487, 36238,4048,3473, 3471,4049,3474, 3485,4063,3488, 36254,4064,3489, 36240,4050,3475, 3487,4065,3490, 36241,4051,3476, 3488,4066,3491, 36257,4067,3492, 36258,4068,3493, 36242,4052,3477, 3475,4053,3478, 3491,4069,3494, 34932,4070,2167, 
36260,4071,3495, 36244,4054,3479, 3477,4055,3480, 3493,4072,3496, 36172,3970,3407, 3406,3973,3409, 3494,4073,3497, 36263,4074,3498, 36175,3974,3410, 3496,4075,3499, 36265,4076,3500, 36266,4077,3501, 36267,4078,3502, 36176,3975,3411, 3410,3978,3413, 36177,3976,3412, 
40, // chain 804
3500,4079,3503, 3501,4080,3504, 3502,4081,3505, 
3503,4082,3506, 36272,4083,3507, 36273,4084,3508, 36274,4085,3509, 36269,4080,3504, 3485,4063,3488, 36252,4062,3487, 36251,4061,3486, 36268,4079,3503, 3482,4060,3485, 36275,4086,3510, 36276,4087,3511, 36271,4082,3506, 3509,4088,3512, 36278,4089,3513, 36272,4083,3507, 
2799,4090,2802, 36279,4091,3514, 36280,4092,3515, 36273,4084,3508, 3513,4093,3516, 36274,4085,3509, 3514,4094,3517, 36283,4095,3518, 36253,4063,3488, 3516,4096,3519, 36254,4064,3489, 3517,4097,3520, 36088,3866,3323, 36255,4065,3490, 3319,3865,3322, 36086,3864,3321, 
36256,4066,3491, 3317,3863,3320, 36033,3807,3268, 36257,4067,3492, 3518,4098,3521, 36259,4069,3494, 36258,4068,3493, 
15, // chain 805
2129,4099,2132, 2128,4100,2131, 3519,4101,3522, 
34939,4102,2174, 3496,4075,3499, 36288,4103,3523, 34938,4104,2173, 3521,4105,3524, 34937,4106,2172, 2168,4107,2171, 1934,4108,1937, 3522,4109,3525, 36291,4110,3526, 36292,4111,3527, 34703,4112,1938, 2166,4113,2169, 34951,4114,2186, 
21, // chain 806
3525,4115,3528, 3526,4116,3529, 3527,4117,3530, 
3528,4118,3531, 36297,4119,3532, 35810,4120,3045, 35366,4121,2601, 36294,4116,3529, 3530,4122,3533, 36299,4123,3534, 36300,4124,3535, 36293,4115,3528, 3533,4125,3536, 36296,4118,3531, 3534,4126,3537, 35916,3683,3151, 36297,4119,3532, 3535,4127,3538, 36304,4128,3539, 
36305,4129,3540, 35810,4120,3045, 3290,4130,3293, 35811,4131,3046, 
16, // chain 807
3538,4132,3541, 3326,3872,3329, 3327,3873,3330, 
3328,3874,3331, 3539,4133,3542, 36097,3875,3332, 3330,3876,3333, 3540,4134,3543, 35956,3723,3191, 36099,3877,3334, 3429,4002,3432, 36100,3878,3335, 3541,4135,3544, 36310,4136,3545, 36101,3879,3336, 3336,3884,3339, 36102,3880,3337, 3335,3881,3338, 
19, // chain 808
3421,3994,3424, 3452,4029,3455, 3420,3993,3423, 
36187,3992,3422, 36186,3991,3421, 36221,4030,3456, 2616,3990,2619, 35383,4137,2618, 35881,4138,3116, 36222,4031,3457, 3543,4139,3546, 36312,4140,3547, 35179,4032,2414, 2407,4141,2410, 2254,4142,2257, 3545,4143,3548, 35024,4144,2259, 3016,4145,3019, 3543,4139,3546, 
35785,4146,3020, 3113,4138,3116, 
20, // chain 809
3546,4147,3549, 3097,4148,3100, 2727,4149,2730, 
3547,4150,3550, 35704,4151,2939, 3548,4152,3551, 35705,4153,2940, 3549,4154,3552, 35706,4155,2941, 3550,4156,3553, 36319,4157,3554, 36320,4158,3555, 3348,3906,3351, 3550,4156,3553, 36317,4154,3552, 36115,3905,3350, 3553,4159,3556, 36023,3795,3258, 36114,3904,3349, 
3254,3794,3257, 36117,3907,3352, 3253,3793,3256, 
26, // chain 810
2252,4160,2255, 2253,4161,2256, 3554,4162,3557, 
2400,4163,2403, 35898,4164,3133, 36323,4165,3558, 36324,4166,3559, 36325,4167,3560, 35021,4161,2256, 3558,4168,3561, 35008,4169,2243, 3559,4170,3562, 35009,4171,2244, 3560,4172,3563, 35154,4173,2389, 3561,4174,3564, 35156,4175,2391, 2415,3894,2418, 3341,3895,3344, 
3562,4176,3565, 36331,4177,3566, 36332,4178,3567, 36110,3896,3345, 3565,4179,3568, 36226,4036,3461, 3393,3951,3396, 36160,3950,3395, 36192,3997,3427, 
6, // chain 811
3150,3685,3153, 3151,3686,3154, 3566,4180,3569, 
3149,3684,3152, 36335,4181,3570, 36336,4182,3571, 35920,3687,3155, 35919,3686,3154, 
11, // chain 812
3348,4183,3351, 3552,4184,3555, 3569,4185,3572, 
3350,4186,3353, 36119,4187,3354, 36338,4188,3573, 36339,4189,3574, 36280,4092,3515, 36320,4184,3555, 3511,4091,3514, 35905,4190,3140, 35906,4191,3141, 35706,4192,2941, 
16, // chain 813
3572,4193,3575, 3573,4194,3576, 3574,4195,3577, 
3575,4196,3578, 36344,4197,3579, 35754,4198,2989, 36070,3847,3305, 36069,3846,3304, 36341,4194,3576, 3300,3845,3303, 36340,4193,3575, 3577,4199,3580, 36346,4200,3581, 36343,4196,3578, 3579,4201,3582, 36344,4197,3579, 2987,4202,2990, 35754,4198,2989, 
9, // chain 814
3580,4203,3583, 2030,4204,2033, 3581,4205,3584, 
3582,4206,3585, 35979,3749,3214, 35978,3748,3213, 36351,4207,3586, 36352,4208,3587, 34881,4209,2116, 34797,4210,2032, 34798,4204,2033, 
15, // chain 815
3256,3796,3259, 3257,3797,3260, 3585,4211,3588, 
36354,4212,3589, 36355,4213,3590, 35860,4214,3095, 36356,4215,3591, 36026,3798,3261, 2951,4216,2954, 36027,3799,3262, 3131,4217,3134, 36357,4218,3592, 36028,3800,3263, 3261,3801,3264, 1236,4219,1239, 1115,4220,1118, 34005,4221,1240, 
8, // chain 816
3590,4222,3593, 3577,4199,3580, 3591,4223,3594, 
3592,4224,3595, 36361,4225,3596, 36362,4226,3597, 36363,4227,3598, 36347,4201,3582, 36346,4200,3581, 36345,4199,3580, 
3, // chain 817
1117,4228,1120, 3131,4217,3134, 1116,4229,1119, 
36357,4218,3592, 1115,4220,1118, 
3, // chain 818
3536,4128,3539, 3596,4230,3599, 3145,3680,3148, 
3535,4127,3538, 35916,3683,3151, 
24, // chain 819
3597,4231,3600, 3598,4232,3601, 3559,4170,3562, 
3560,4172,3563, 3599,4233,3602, 36329,4174,3564, 3562,4176,3565, 3563,4177,3566, 3592,4224,3595, 36368,4234,3603, 36332,4178,3567, 3601,4235,3604, 36333,4179,3568, 3393,3951,3396, 3394,3952,3397, 3395,3953,3398, 3602,4236,3605, 36371,4237,3606, 36067,3844,3302, 
3300,3845,3303, 3577,4199,3580, 3602,4236,3605, 36358,4222,3593, 3601,4235,3604, 36368,4234,3603, 36360,4224,3595, 
2, // chain 820
3540,4134,3543, 3190,3725,3193, 3538,4132,3541, 
3539,4133,3542, 
18, // chain 821
3604,4238,3607, 3538,4132,3541, 3190,3725,3193, 
3191,3726,3194, 3326,3872,3329, 35960,3727,3195, 3325,3871,3328, 36373,4239,3608, 35961,3728,3196, 3323,3869,3326, 35962,3729,3197, 3606,4240,3609, 36375,4241,3610, 35963,3730,3198, 3608,4242,3611, 36377,4243,3612, 36378,4244,3613, 35950,3717,3185, 3308,3854,3311, 
35951,3718,3186, 
10, // chain 822
3611,4245,3614, 3494,4073,3497, 3612,4246,3615, 
2167,4247,2170, 36291,4110,3526, 36381,4248,3616, 36262,4073,3497, 3495,4074,3498, 3614,4249,3617, 36383,4250,3618, 36288,4103,3523, 36264,4075,3499, 
4, // chain 823
2164,4070,2167, 3492,4071,3495, 2167,4247,2170, 
36379,4245,3614, 36261,4072,3496, 3494,4073,3497, 
19, // chain 824
3616,4251,3619, 3617,4252,3620, 3439,4012,3442, 
3608,4242,3611, 36386,4253,3621, 36387,4254,3622, 36388,4255,3623, 36208,4013,3443, 3441,4014,3444, 3514,4094,3517, 36389,4256,3624, 36390,4257,3625, 36210,4015,3445, 3623,4258,3626, 36392,4259,3627, 36211,4016,3446, 3625,4260,3628, 35937,3704,3172, 36212,4017,3447, 
3165,3700,3168, 35932,3699,3167, 
10, // chain 825
3617,4252,3620, 3616,4251,3619, 3568,4182,3571, 
36335,4181,3570, 36394,4261,3629, 36376,4242,3611, 3311,3857,3314, 36377,4243,3612, 3310,3856,3313, 36077,3855,3312, 36378,4244,3613, 3308,3854,3311, 
6, // chain 826
3351,4187,3354, 3570,4188,3573, 3623,4258,3626, 
3624,4259,3627, 3627,4262,3630, 36393,4260,3628, 3170,3705,3173, 35937,3704,3172, 
4, // chain 827
1239,4263,1242, 710,4264,713, 711,4265,714, 
3262,3804,3265, 34002,4266,1237, 1235,3803,1238, 
4, // chain 828
3431,4004,3434, 3432,4005,3435, 3628,4267,3631, 
36168,3958,3403, 36167,3957,3402, 36166,3956,3401, 
2, // chain 829
3547,4150,3550, 3090,4268,3093, 3097,4148,3100, 
3546,4147,3549, 
10, // chain 830
3255,3795,3258, 3256,3796,3259, 3585,4211,3588, 
3553,4159,3556, 36397,4269,3632, 36354,4212,3589, 3630,4270,3633, 36355,4213,3590, 3090,4268,3093, 36399,4271,3634, 35860,4214,3095, 3091,4272,3094, 
3, // chain 831
3515,4095,3518, 3516,4096,3519, 3619,4254,3622, 
3620,4255,3623, 3514,4094,3517, 
1, // chain 832
2687,4273,2690, 2688,4274,2691, 2755,4275,2758, 
3, // chain 833
2983,4276,2986, 3632,4277,3635, 3595,4227,3598, 
2987,4202,2990, 36347,4201,3582, 
3, // chain 834
3633,4278,3636, 3292,4279,3295, 3146,3681,3149, 
3596,4230,3599, 35913,3680,3148, 
9, // chain 835
2162,4280,2165, 2161,4281,2164, 1889,4282,1892, 
2191,4283,2194, 3264,3806,3267, 34659,4284,1894, 3634,4285,3637, 34027,4286,1262, 3635,4287,3638, 34007,4263,1242, 33476,4288,711, 
23, // chain 836
2131,4289,2134, 2129,4099,2132, 3519,4101,3522, 
3496,4075,3499, 3497,4076,3500, 2130,4290,2133, 34903,4291,2138, 36266,4077,3501, 3636,4292,3639, 36267,4078,3502, 3410,3978,3413, 3584,4208,3587, 36405,4293,3640, 36179,3979,3414, 3412,3982,3415, 3583,4207,3586, 36406,4294,3641, 36181,3983,3416, 3208,3746,3211, 
35975,3745,3210, 36407,4295,3642, 35844,3984,3079, 3206,3744,3209, 35909,4296,3144, 35902,4297,3137, 
2, // chain 837
3189,3724,3192, 3190,3725,3193, 3540,4134,3543, 
3188,3723,3191, 
6, // chain 838
3640,4298,3643, 3641,4299,3644, 3385,3943,3388, 
3417,3989,3420, 3642,4300,3645, 35379,4301,2614, 35381,4302,2616, 35384,3990,2619, 
1, // chain 839
2165,4303,2168, 2164,4070,2167, 2167,4247,2170, 
4, // chain 840
3518,4098,3521, 3491,4069,3494, 2163,4304,2166, 
3265,3807,3268, 36032,3806,3267, 34930,4280,2165, 
2, // chain 841
3401,3961,3404, 3402,3962,3405, 2254,4142,2257, 
35023,3963,2258, 
8, // chain 842
3643,4305,3646, 3542,4136,3545, 3337,3885,3340, 
3338,3887,3341, 3644,4306,3647, 35923,3888,3158, 3153,4307,3156, 3427,4000,3430, 35914,4308,3149, 3292,3837,3295, 
7, // chain 843
3630,4270,3633, 3090,4268,3093, 3547,4150,3550, 
3548,4152,3551, 3629,4269,3632, 36413,4309,3648, 36317,4154,3552, 3553,4159,3556, 3629,4269,3632, 
8, // chain 844
2499,4310,2502, 2041,4311,2044, 2040,4312,2043, 
3646,4313,3649, 34806,4314,2041, 3647,4315,3650, 34805,4316,2040, 3580,4203,3583, 34802,4317,2037, 2030,4204,2033, 
11, // chain 845
3312,3858,3315, 3380,3938,3383, 3626,4261,3629, 
35917,3684,3152, 35916,3683,3151, 36302,4126,3537, 36416,4318,3651, 36149,3939,3384, 3533,4125,3536, 36417,4319,3652, 36150,3940,3385, 3384,3942,3387, 36151,3941,3386, 
6, // chain 846
3559,4170,3562, 3598,4232,3601, 3556,4166,3559, 
36362,4226,3597, 36361,4225,3596, 36360,4224,3595, 36365,4231,3600, 3599,4233,3602, 
2, // chain 847
2400,4163,2403, 2977,4320,2980, 3124,4321,3127, 
3125,4322,3128, 
2, // chain 848
3401,3961,3404, 2254,4142,2257, 2407,4323,2410, 
2405,3959,2408, 
4, // chain 849
3584,4208,3587, 2113,4209,2116, 3650,4324,3653, 
34903,4291,2138, 3636,4292,3639, 3584,4208,3587, 
5, // chain 850
2611,4301,2614, 2597,4325,2600, 2988,4326,2991, 
3642,4300,3645, 36299,4123,3534, 36298,4122,3533, 35366,4121,2601, 
7, // chain 851
3188,3723,3191, 3429,4002,3432, 3430,4003,3433, 
3187,3722,3190, 36199,4004,3434, 3186,3721,3189, 36396,4267,3631, 3316,3862,3319, 36168,3958,3403, 
8, // chain 852
3508,4087,3511, 3509,4088,3512, 3507,4086,3510, 
35723,4327,2958, 35565,4328,2800, 36278,4089,3513, 2798,4329,2801, 36419,4330,3654, 35567,4090,2802, 2798,4329,2801, 
7, // chain 853
3160,3695,3163, 3436,4009,3439, 3158,3693,3161, 
35924,3691,3159, 36420,4331,3655, 36205,4010,3440, 3617,4252,3620, 36206,4011,3441, 3439,4012,3442, 
3, // chain 854
3140,4332,3143, 3204,3742,3207, 3205,3743,3208, 
3141,4296,3144, 35974,3744,3209, 
3, // chain 855
3263,3805,3266, 3264,3806,3267, 3635,4287,3638, 
1239,4263,1242, 3262,3804,3265, 
5, // chain 856
3536,4128,3539, 3537,4129,3540, 3653,4333,3656, 
3596,4230,3599, 36401,4278,3636, 36059,4334,3294, 36305,4129,3540, 
2, // chain 857
2952,4335,2955, 2953,4336,2956, 3588,4215,3591, 
2951,4216,2954, 
7, // chain 858
2352,3902,2355, 2324,4337,2327, 3345,3901,3348, 
36225,4035,3460, 35188,4338,2423, 3451,4028,3454, 36218,4027,3453, 35182,4026,2417, 35181,4339,2416, 
4, // chain 859
3511,4091,3514, 3137,4190,3140, 3654,4340,3657, 
3655,4341,3658, 35563,4342,2798, 35905,4190,3140, 
2, // chain 860
3559,4170,3562, 3556,4166,3559, 3558,4168,3561, 
36325,4167,3560, 
5, // chain 861
3632,4277,3635, 2983,4276,2986, 3594,4226,3597, 
35750,4343,2985, 3555,4165,3558, 35748,4344,2983, 35749,4345,2984, 
6, // chain 862
3385,3943,3388, 3641,4299,3644, 3532,4124,3535, 
36424,4346,3659, 36408,4298,3643, 3642,4300,3645, 3531,4123,3534, 3532,4124,3535, 
1, // chain 863
3312,3858,3315, 3626,4261,3629, 3311,3857,3314, 
2, // chain 864
3095,4347,3098, 3094,3848,3097, 3043,4348,3046, 
36058,3835,3293, 
4, // chain 865
3647,4315,3650, 3580,4203,3583, 3582,4206,3585, 
2582,4349,2585, 35979,3749,3214, 2581,3750,2584, 
1, // chain 866
3634,4285,3637, 3635,4287,3638, 3264,3806,3267, 
1, // chain 867
3583,4207,3586, 3584,4208,3587, 3637,4293,3640, 
6, // chain 868
3321,3867,3324, 3323,3869,3326, 3606,4240,3609, 
3657,4350,3660, 36387,4254,3622, 36386,4253,3621, 36375,4241,3610, 3608,4242,3611, 
1, // chain 869
3292,3837,3295, 3633,4351,3636, 3291,3836,3294, 
1, // chain 870
3632,4277,3635, 3594,4226,3597, 3595,4227,3598, 
2, // chain 871
2582,4349,2585, 2499,4310,2502, 3646,4313,3649, 
3647,4315,3650, 
1, // chain 872
3627,4262,3630, 3252,4352,3255, 3351,4187,3354, 
3, // chain 873
2878,4353,2881, 2879,4354,2882, 3479,4057,3482, 
3481,4059,3484, 36248,4058,3483, 
2, // chain 874
3623,4258,3626, 3570,4188,3573, 3621,4256,3624, 
3622,4257,3625, 
3, // chain 875
3658,4355,3661, 3652,4331,3655, 3568,4182,3571, 
3154,3689,3157, 35920,3687,3155, 
1, // chain 876
3617,4252,3620, 3568,4182,3571, 3652,4331,3655, 
2, // chain 877
2765,3966,2768, 2688,4274,2691, 3403,3964,3406, 
35023,3963,2258, 
1, // chain 878
3206,3744,3209, 3207,3745,3210, 3639,4295,3642, 
2, // chain 879
3517,4097,3520, 3320,3866,3323, 3657,4350,3660, 
36089,3867,3324, 
1, // chain 880
2358,3893,2361, 2415,3894,2418, 2357,4356,2360, 
2, // chain 881
3451,4028,3454, 3422,3995,3425, 3423,3996,3426, 
3457,4035,3460, 
3, // chain 882
3384,3942,3387, 3385,3943,3388, 3649,4319,3652, 
36300,4124,3535, 3533,4125,3536, 
1, // chain 883
2499,4310,2502, 2582,4349,2585, 2498,4357,2501, 
3, // chain 884
3522,4109,3525, 3523,4110,3526, 3613,4248,3616, 
3615,4250,3618, 36382,4249,3617, 
1, // chain 885
3631,4271,3634, 3091,4358,3094, 3090,4268,3093, 
2, // chain 886
3170,4359,3173, 3171,3791,3174, 3627,4360,3630, 
36020,3792,3255, 
2, // chain 887
3657,4350,3660, 3619,4254,3622, 3516,4096,3519, 
3517,4097,3520, 
3, // chain 888
3541,4135,3544, 3643,4305,3646, 3644,4306,3647, 
3428,4001,3431, 36195,4000,3430, 
3, // chain 889
3583,4207,3586, 3638,4294,3641, 3210,3748,3213, 
35977,3747,3212, 35976,3746,3211, 
4, // chain 890
3478,4056,3481, 3479,4057,3482, 2879,4354,2882, 
2744,4361,2747, 3404,3970,3407, 35907,3971,3142, 
1, // chain 891
3326,3872,3329, 3538,4132,3541, 3604,4238,3607, 
2, // chain 892
3324,3870,3327, 3325,3871,3328, 3605,4239,3608, 
3323,3869,3326, 
1, // chain 893
3643,4305,3646, 3541,4135,3544, 3542,4136,3545, 
4, // chain 894
3204,3742,3207, 3140,4332,3143, 3135,4362,3138, 
3069,4363,3072, 2471,4364,2474, 2577,3741,2580, 
2, // chain 895
3523,4110,3526, 3524,4111,3527, 2166,4113,2169, 
2167,4247,2170, 
2, // chain 896
3096,4365,3099, 2814,4366,2817, 2732,4367,2735, 
2725,4368,2728, 
2, // chain 897
3520,4103,3523, 3521,4105,3524, 3522,4109,3525, 
3615,4250,3618, 
1, // chain 898
3149,3684,3152, 3567,4181,3570, 3626,4261,3629, 
2, // chain 899
3130,4164,3133, 3555,4165,3558, 2980,4344,2983, 
2977,4369,2980, 
2, // chain 900
2987,4202,2990, 2985,4370,2988, 2984,4371,2987, 
2983,4276,2986, 
1, // chain 901
2814,4372,2817, 3097,4148,3100, 3090,4268,3093, 
4, // chain 902
3571,4189,3574, 3513,4093,3516, 3659,4373,3662, 
3621,4256,3624, 36282,4094,3517, 36281,4093,3516, 
2, // chain 903
2799,4090,2802, 3511,4091,3514, 3655,4341,3658, 
2795,4342,2798, 
1, // chain 904
3545,4143,3548, 3543,4139,3546, 3544,4140,3547, 
2, // chain 905
3507,4086,3510, 2955,4327,2958, 3481,4059,3484, 
35646,4353,2881, 
1, // chain 906
3571,4189,3574, 3621,4256,3624, 3570,4188,3573, 
1, // chain 907
2693,4374,2696, 3095,4347,3098, 3043,4348,3046, 
2, // chain 908
3658,4355,3661, 3154,3689,3157, 3156,3691,3159, 
3652,4331,3655, 
1, // chain 909
3555,4165,3558, 3556,4166,3559, 3594,4226,3597, 
1, // chain 910
3481,4059,3484, 3482,4060,3485, 3507,4086,3510, 
1, // chain 911
3316,3862,3319, 3185,3720,3188, 3186,3721,3189, 
1, // chain 912
3290,3835,3293, 3291,3836,3294, 3537,4375,3540, 
1, // chain 913
3513,4093,3516, 3571,4189,3574, 3512,4092,3515, 
1, // chain 914
3534,4126,3537, 3648,4318,3651, 3533,4125,3536, 
1, // chain 915
2163,4304,2166, 3491,4069,3494, 2164,4070,2167, 
1, // chain 916
3337,3885,3340, 3542,4136,3545, 3336,3884,3339, 
1, // chain 917
3094,3848,3097, 2986,4198,2989, 3302,3847,3305, 
1, // chain 918
3588,4215,3591, 2953,4336,2956, 3092,4214,3095, 
1, // chain 919
3323,3869,3326, 3321,3867,3324, 3322,3868,3325, 
1, // chain 920
2419,3890,2422, 2358,3893,2361, 2349,4376,2352, 
1, // chain 921
3429,4002,3432, 3541,4135,3544, 3428,4001,3431, 
9, // chain 922
3660,4377,3663, 3661,4378,3664, 3662,4379,3665, 
3663,4380,3666, 36432,4381,3667, 3665,4382,3668, 36434,4383,3669, 3667,4384,3670, 3660,4377,3663, 36432,4381,3671, 3661,4378,3672, 
10, // chain 923
3668,4385,3673, 3669,4386,3674, 3670,4387,3675, 
3671,4388,3676, 36440,4389,3677, 36441,4390,3678, 36442,4391,3679, 36443,4392,3680, 36444,4393,3681, 36437,4386,3674, 3677,4394,3682, 36436,4385,3673, 
12, // chain 924
3678,4395,3683, 3679,4396,3684, 3680,4397,3685, 
3681,4398,3686, 36450,4399,3687, 36451,4400,3688, 36452,4401,3689, 36453,4402,3690, 36447,4396,3684, 3686,4403,3691, 36455,4404,3692, 36456,4405,3693, 36457,4406,3694, 36446,4395,3683, 
23, // chain 925
3690,4407,3695, 3691,4408,3696, 3692,4409,3697, 
3665,4382,3668, 36431,4380,3666, 36461,4410,3698, 36462,4411,3699, 36463,4412,3700, 36464,4413,3701, 36459,4408,3696, 3697,4414,3702, 36466,4415,3703, 36467,4416,3704, 36468,4417,3705, 36469,4418,3706, 36458,4407,3695, 3702,4419,3707, 36471,4420,3708, 36472,4421,3709, 
36473,4422,3710, 36474,4423,3711, 36433,4382,3668, 3707,4424,3712, 36476,4425,3713, 36477,4426,3714, 
36, // chain 926
3710,4427,3715, 3697,4414,3702, 3711,4428,3716, 
3712,4429,3717, 36455,4404,3692, 36481,4430,3718, 36465,4414,3702, 3698,4415,3703, 3686,4403,3691, 36482,4431,3719, 36467,4416,3704, 3715,4432,3720, 36468,4417,3705, 3716,4433,3721, 36469,4418,3706, 3717,4434,3722, 36470,4419,3707, 3718,4435,3723, 36471,4420,3708, 
3719,4436,3724, 36488,4437,3725, 36472,4421,3709, 3721,4438,3726, 36490,4439,3727, 36473,4422,3710, 3723,4440,3728, 36492,4441,3729, 36474,4423,3711, 3725,4442,3730, 36494,4443,3731, 36495,4444,3732, 36475,4424,3712, 3728,4445,3733, 36497,4446,3734, 36477,4426,3735, 
3730,4447,3736, 3660,4377,3663, 36433,4382,3668, 
23, // chain 927
3731,4448,3737, 3671,4388,3676, 3672,4389,3677, 
3732,4449,3738, 36501,4450,3739, 36502,4451,3740, 36441,4390,3678, 3735,4452,3741, 3736,4453,3742, 36505,4454,3743, 36506,4455,3744, 36441,4390,3745, 3674,4391,3679, 3675,4392,3680, 3144,4456,3147, 36507,4457,3746, 36508,4458,3747, 36444,4393,3681, 3741,4459,3748, 
36445,4394,3682, 3742,4460,3749, 3743,4461,3750, 3740,4458,3747, 35853,4462,3088, 35854,4463,3089, 
73, // chain 928
3744,4464,3751, 3745,4465,3752, 3746,4466,3753, 
3747,4467,3754, 36516,4468,3755, 36513,4465,3752, 3749,4469,3756, 36518,4470,3757, 36519,4471,3758, 36520,4472,3759, 36521,4473,3760, 36522,4474,3761, 36512,4464,3751, 3755,4475,3762, 36515,4467,3754, 3756,4476,3763, 36525,4477,3764, 36516,4468,3755, 3749,4469,3756, 
3758,4478,3765, 36527,4479,3766, 36528,4480,3767, 36518,4470,3757, 3761,4481,3768, 36530,4482,3769, 36519,4471,3758, 3763,4483,3770, 36532,4484,3771, 36520,4472,3759, 3765,4485,3772, 36521,4473,3760, 3766,4486,3773, 36535,4487,3774, 36522,4474,3761, 3768,4488,3775, 
36523,4475,3762, 3769,4489,3776, 36538,4490,3777, 36524,4476,3763, 3771,4491,3778, 36540,4492,3779, 36525,4477,3764, 3758,4478,3765, 3773,4493,3780, 36542,4494,3781, 36527,4479,3766, 3775,4495,3782, 36528,4480,3767, 3776,4496,3783, 36545,4497,3784, 36529,4481,3768, 
3762,4482,3769, 3763,4483,3770, 3778,4498,3785, 36547,4499,3786, 36548,4500,3787, 36532,4484,3771, 3765,4485,3772, 3781,4501,3788, 36550,4502,3789, 36534,4486,3773, 3783,4503,3790, 36552,4504,3791, 36535,4487,3774, 3768,4488,3775, 3785,4505,3792, 36537,4489,3776, 
3786,4506,3793, 35875,4507,3110, 36555,4508,3794, 36538,4490,3777, 3771,4491,3778, 3788,4509,3795, 36541,4493,3780, 36540,4492,3779, 
12, // chain 929
3789,4510,3796, 2687,4511,2690, 3132,4512,3135, 
3790,4513,3797, 35526,4514,2761, 3100,4515,3103, 3774,4494,3781, 36541,4493,3780, 36556,4509,3795, 35867,4516,3102, 3098,4517,3101, 3108,4518,3111, 35728,4519,2963, 2963,4520,2966, 
7, // chain 930
3791,4521,3798, 3116,4522,3119, 3792,4523,3799, 
3793,4524,3800, 36562,4525,3801, 36544,4496,3783, 36557,4510,3796, 35455,4511,2690, 35884,4522,3119, 
37, // chain 931
3717,4434,3722, 3718,4435,3723, 3795,4526,3802, 
36564,4527,3803, 36487,4436,3724, 3797,4528,3804, 36566,4529,3805, 36567,4530,3806, 36488,4437,3725, 3800,4531,3807, 36489,4438,3726, 3801,4532,3808, 36551,4503,3790, 36490,4439,3727, 3782,4502,3789, 36548,4500,3787, 36570,4533,3809, 36491,4440,3728, 3779,4499,3786, 
36571,4534,3810, 36572,4535,3811, 36492,4441,3729, 3725,4442,3730, 3805,4536,3812, 36574,4537,3813, 36505,4454,3743, 36504,4453,3742, 36494,4443,3731, 3733,4450,3739, 36575,4538,3814, 36495,4444,3732, 3728,4445,3733, 3729,4446,3734, 3808,4539,3815, 36577,4540,3816, 
36578,4541,3817, 36428,4377,3663, 3693,4410,3698, 36431,4380,3666, 
11, // chain 932
3116,4522,3119, 3791,4521,3798, 3811,4542,3818, 
36580,4543,3819, 36581,4544,3820, 36561,4524,3800, 3806,4537,3813, 36573,4536,3812, 36582,4545,3821, 36546,4498,3785, 36562,4525,3801, 3776,4496,3783, 3777,4497,3784, 
2, // chain 933
3710,4427,3715, 3712,4429,3717, 3695,4412,3700, 
36462,4546,3699, 
5, // chain 934
3144,4456,3147, 3119,4547,3122, 3812,4543,3819, 
3738,4455,3744, 36505,4454,3743, 36574,4537,3813, 36581,4544,3820, 
11, // chain 935
3815,4548,3822, 3816,4549,3823, 3817,4550,3824, 
3712,4551,3717, 36462,4411,3699, 36461,4410,3698, 36584,4549,3823, 3810,4541,3817, 36577,4540,3816, 36586,4552,3825, 36583,4548,3822, 3689,4553,3694, 36456,4554,3693, 
8, // chain 936
3783,4503,3790, 3784,4504,3791, 3801,4532,3808, 
36587,4555,3826, 36588,4556,3827, 36553,4505,3792, 3786,4506,3793, 3821,4557,3828, 35874,4558,3109, 35875,4507,3110, 
4, // chain 937
3677,4559,3682, 3668,4560,3673, 3822,4561,3829, 
3823,4562,3830, 36450,4399,3687, 36436,4560,3673, 
6, // chain 938
3685,4402,3690, 3686,4403,3691, 3714,4431,3719, 
3715,4432,3720, 3684,4401,3689, 36563,4526,3802, 36485,4434,3722, 36484,4433,3721, 
1, // chain 939
3687,4404,3692, 3713,4430,3718, 3686,4403,3691, 
2, // chain 940
3787,4508,3794, 3788,4509,3795, 3108,4518,3111, 
3107,4507,3110, 
3, // chain 941
3671,4388,3676, 3731,4448,3737, 3678,4563,3683, 
3681,4564,3686, 3668,4385,3673, 
2, // chain 942
3732,4449,3738, 3818,4552,3825, 3678,4563,3683, 
3731,4448,3737, 
4, // chain 943
3804,4535,3811, 3805,4536,3812, 3803,4534,3810, 
36582,4545,3821, 3779,4499,3786, 36546,4498,3785, 
2, // chain 944
3712,4429,3717, 3687,4404,3692, 3815,4565,3822, 
36456,4405,3693, 
4, // chain 945
3111,4566,3114, 3742,4567,3749, 3823,4562,3830, 
3824,4568,3831, 36451,4400,3688, 36450,4399,3687, 
8, // chain 946
3101,4569,3104, 2918,4570,2921, 3102,4571,3105, 
35878,4572,3113, 3825,4573,3832, 36563,4526,3802, 36452,4401,3689, 36592,4568,3831, 35877,4574,3112, 3111,4566,3114, 
3, // chain 947
3102,4571,3105, 3825,4573,3832, 3821,4557,3828, 
3103,4575,3106, 35874,4558,3109, 
13, // chain 948
3826,4576,3833, 3827,4577,3834, 3828,4578,3835, 
3829,4579,3836, 36587,4555,3826, 36569,4532,3808, 36567,4530,3806, 36595,4577,3834, 3798,4529,3805, 36598,4580,3837, 36594,4576,3833, 3821,4557,3828, 36588,4556,3827, 36597,4579,3836, 3819,4555,3826, 
3, // chain 949
3790,4513,3797, 3774,4494,3781, 3789,4510,3796, 
36543,4495,3782, 3776,4496,3783, 
3, // chain 950
3742,4567,3749, 3111,4566,3114, 3086,4581,3089, 
35855,4582,3090, 35687,4583,2922, 
1, // chain 951
3823,4562,3830, 3742,4567,3749, 3677,4559,3682, 
2, // chain 952
3796,4527,3803, 3797,4528,3804, 3830,4580,3837, 
36566,4529,3805, 
2, // chain 953
3696,4413,3701, 3697,4414,3702, 3710,4427,3715, 
3695,4412,3700, 
1, // chain 954
3779,4499,3786, 3780,4500,3787, 3802,4533,3809, 
1, // chain 955
3780,4500,3787, 3781,4501,3788, 3782,4502,3789, 
1, // chain 956
3734,4451,3740, 3736,4453,3742, 3733,4450,3739, 
1, // chain 957
3742,4567,3749, 3086,4581,3089, 3743,4584,3750, 
2, // chain 958
3739,4457,3746, 3740,4458,3747, 3088,4585,3091, 
3144,4456,3147, 
1, // chain 959
3088,4585,3091, 3010,4586,3013, 3011,4587,3014, 
3, // chain 960
3796,4527,3803, 3830,4580,3837, 3795,4526,3802, 
36593,4573,3832, 36589,4557,3828, 
2, // chain 961
3732,4449,3738, 3831,4588,3838, 3809,4540,3816, 
3818,4552,3825, 
4, // chain 962
3808,4539,3815, 3809,4540,3816, 3831,4588,3838, 
3807,4538,3814, 36501,4450,3739, 36500,4449,3738, 
6, // chain 963
3812,4543,3819, 3119,4547,3122, 3811,4542,3818, 
35889,4589,3124, 3142,4590,3145, 3128,4591,3131, 3116,4522,3119, 35882,4592,3117, 
1, // chain 964
3085,4462,3088, 3088,4585,3091, 3740,4458,3747, 
1, // chain 965
3668,4593,3673, 3681,4398,3686, 3682,4399,3687, 
1, // chain 966
3683,4400,3688, 3684,4401,3689, 3824,4568,3831, 
1, // chain 967
3689,4553,3694, 3678,4563,3683, 3818,4552,3825, 
1, // chain 968
3800,4531,3807, 3801,4532,3808, 3799,4530,3806, 
1, // chain 969
3144,4456,3147, 3012,4594,3015, 3119,4547,3122, 

 0};


// mesh info for object dennis (with tag [ | o rp_dennis_posed_004_100k.001_rp_dennis_posed_004_100k | usemtl rp_dennis_posed_004])
const tgx::Mesh3D<tgx::RGB565> dennis = 
    {
    1, // version/id
    
    3832, // number of vertices
    4595, // number of texture coords
    3839, // number of normal vectors
    7657, // number of triangles
    29762,
    
    dennis_vert_array, // array of vertices
    dennis_tex_array, // array of texture coords
    dennis_norm_array, // array of normal vectors        
    dennis_face, // array of face vertex indexes   
    
    &dennis_texture, // pointer to texture image 
    
    { 0.75f , 0.75f, 0.75f }, // default color
    
    0.1f, // ambiant light strength 
    0.7f, // diffuse light strength
    0.6f, // specular light strength
    32, // specular exponent
    
    nullptr, // next mesh to draw after this one    
    
    { // mesh bounding box
    -0.34155453987952916, 0.34155453987952916, 
    -1.0000000000000002, 1.0, 
    -0.2433156622798864, 0.2433156622798864
    },
    
    "dennis" // model name    
    };
    
                
/** end of dennis.h */
    
    
    