// 3D model [buddha]
//
// - vertices   : 9996
// - textures   : 0
// - normals    : 9996
// - triangles  : 20000
//
// - memory size: 327kb
//
// - model bounding box: [-0.5,0.5]x[-1.0,1.0]x[-0.4,0.4]
//
// object [buddha] (tagged [ | g Group47867 | usemtl Acier_-_Satiné]) with 20000 triangles (1526 chains)

#pragma once

#include <tgx.h>


// vertex array: 117kb.
// *** NOT LOCATED IN PROGMEM TO IMPROVE FRAMERATE ***
const tgx::fVec3 buddha_vert_array[9996] PROGMEM = {
{-0.3370548606023502,-0.5086613527234205,0.16547221316220023},
{-0.3427209088161091,-0.50567641067395,0.15926392581277643},
{-0.340396628251415,-0.5522269457091904,0.15008763650643575},
{-0.3320899208011576,-0.5641363991625807,0.15538314024853114},
{-0.33683467339620277,-0.5610426803645188,0.14677053052989827},
{-0.3340256012734326,-0.5535090785793944,0.14012934705676455},
{-0.34359770335882445,-0.5384013462759544,0.14553158028759866},
{-0.3485425625899727,-0.4908740951185156,0.15853792412277992},
{-0.3398546515304795,-0.44763709849438177,0.18121839837752604},
{-0.33151446867249107,-0.4331395505557804,0.19656485796583117},
{-0.3359841405121788,-0.4763149445253749,0.18106149455507575},
{-0.33241410073352146,-0.5341067135600585,0.16683284840800042},
{-0.3236332810485088,-0.5589592359641954,0.1645600170663916},
{-0.31964489482111935,-0.5683613241147437,0.16174669956200682},
{-0.32493612343418143,-0.5716881574972028,0.1535374106584286},
{-0.32148039129918193,-0.5695414892080198,0.1407339590926321},
{-0.32340385408162514,-0.5581584099544459,0.12426177218730972},
{-0.33265769278375523,-0.5486039374642774,0.12935381739665688},
{-0.34507902919441363,-0.5482680444857922,0.1346238998446398},
{-0.34961510577194854,-0.542192464620913,0.14127779927686884},
{-0.3571217170866228,-0.5329521620567086,0.131576221551495},
{-0.3531177283381144,-0.47352712905809624,0.15505229370715046},
{-0.34468412796126474,-0.4394381946271606,0.17554193431758366},
{-0.3324606267588085,-0.3810073862314792,0.20589732015804788},
{-0.32808210101008106,-0.39280644170195783,0.21159445336196214},
{-0.3249779674282434,-0.4314774315956925,0.2050657746264302},
{-0.3310795252889284,-0.48933923136608376,0.18228877318515874},
{-0.3239102061438269,-0.49635002757923036,0.18481346317218222},
{-0.32568185191242105,-0.536405765126454,0.16998194733805008},
{-0.3223662853648024,-0.5331400478157565,0.17964583402149692},
{-0.31933805975868534,-0.5745150419493398,0.17036633179627342},
{-0.30214230301484685,-0.581525513065696,0.15325473049999583},
{-0.3108623922821333,-0.5730930080313,0.14991740052835953},
{-0.29877978547881656,-0.5782440710569813,0.1332967920645535},
{-0.31615252661514964,-0.5678780730479942,0.12041939160304069},
{-0.32542127939813686,-0.5542058300575259,0.11389378322608384},
{-0.332935408310485,-0.5509701023945303,0.10278764394153747},
{-0.3426654468787199,-0.5486832090231291,0.12204352204701438},
{-0.3542302520508509,-0.5423949404264355,0.12116296233101524},
{-0.356586104188478,-0.529634893531776,0.11433045302234011},
{-0.3612984150985926,-0.5242202386288103,0.12305754355710408},
{-0.36026141370754117,-0.5047095834436607,0.13364732502268045},
{-0.35763181838599123,-0.4390878741505959,0.15679976438599497},
{-0.3476705701305651,-0.4007830919798384,0.18434563189240818},
{-0.34148625388859116,-0.3893508933635097,0.198574968604561},
{-0.3323070270246518,-0.34737090260243114,0.22297824230395405},
{-0.3214227004302043,-0.35708845894128927,0.2302573708580397},
{-0.3217586550283425,-0.378523366277886,0.226566721232587},
{-0.3179060763914913,-0.4251111875776773,0.21667145168947566},
{-0.3189363506162806,-0.48973056715861746,0.19677562161469098},
{0.2520147163093935,0.315832666964151,0.048535340713513155},
{0.2528549151526355,0.291885369135764,0.0531075221581125},
{0.25610948674298295,0.30915346841470787,0.045965523892290326},
{0.25310114091183383,0.33344119782775067,0.038706668204062836},
{0.27128514408984833,0.3320908976851403,0.04505568634182312},
{0.27918396024664605,0.32432491012737746,0.047935312967352026},
{0.2689669829941482,0.2876662799897095,0.05760903754713294},
{0.2527227749938624,0.2783672932052239,0.05650471243547743},
{0.25133148078343925,0.2843817580607493,0.06474604249624126},
{0.2538906799009944,0.29161659058354417,0.07636497415914244},
{0.25693736590524324,0.3170399043332788,0.07522409584432603},
{0.2502717438652227,0.3460461863023284,0.05735076408335271},
{0.24886417781675932,0.3365636090735766,0.04084926109688106},
{0.24745304632768067,0.34774226725292506,0.03603369689638683},
{0.2822838388851988,0.37746831989015694,0.04354722023628248},
{0.2763163866377381,0.35119498002492433,0.042508227892992356},
{0.2910762706875908,0.353419217895645,0.04872000100244551},
{0.2985132549815257,0.3467860587887113,0.05070465210038164},
{0.2947575583754089,0.33013535762364576,0.05622816130770893},
{0.29132705523870805,0.31159833864044895,0.05783585417802381},
{0.27857112198709444,0.2774126241699289,0.06029281566706706},
{0.2639339768492914,0.26506109645174547,0.06167146509971826},
{0.25444661772298016,0.26156647912843883,0.06877889155294788},
{0.24852652230371505,0.2718538536473394,0.07942362606257174},
{0.2500289018749039,0.2772302501826067,0.11381527553844861},
{0.25792640170842324,0.29616184636456994,0.10264356338137143},
{0.25621216420832876,0.3208189452262367,0.11224011890735952},
{0.2496382970189445,0.349938217453258,0.09758784614472914},
{0.23954687299678862,0.3807935320382958,0.06167457051775114},
{0.23779488389752193,0.39876713597332986,0.03834794408170958},
{0.24031327168140787,0.3802652943751781,0.030890122783368498},
{0.24308388251658786,0.3605837753289357,0.026010995785922753},
{-0.061114666196201324,-0.9544457963223809,0.2256055279509219},
{-0.08103449287622332,-0.9799613504431216,0.26061910033554614},
{-0.06935660501664112,-0.9844292799339985,0.2548114884057266},
{-0.05773494934011136,-0.9639684953821321,0.23023487862226344},
{-0.057791763722644565,-0.9785569864918018,0.22999146930617326},
{-0.07316778374589558,-0.9977729255004226,0.2598916686446354},
{-0.09206873158731393,-0.9979387641725673,0.2844518047325741},
{-0.09473920411181738,-0.9764850522177078,0.2754108173106534},
{-0.07856946983670682,-0.9620805552672727,0.24452597841253512},
{-0.07093265407029185,-0.9430943279508289,0.2300429801489116},
{-0.05850376394009391,-0.9171530702072618,0.19951272729472105},
{-0.048866170787572764,-0.9215224369382465,0.19307954202291389},
{-0.04999685954906949,-0.9417525387571961,0.20670525898809505},
{-0.0512049330331448,-0.9654310569709553,0.20215793576146812},
{-0.04800359869822933,-0.988894292053025,0.20984602970331073},
{-0.04249579187835537,-0.9965339136384702,0.205761471133605},
{-0.05197722489389428,-0.9972287198478991,0.2234967929326469},
{-0.09254628921060175,-0.9990236079121844,0.27551758823329675},
{-0.1070056446507892,-0.9999596348776115,0.2875291295156975},
{-0.10393169407487497,-0.9979267685259682,0.29819746435244504},
{-0.09926101998929915,-0.9934419796855315,0.29627146878977934},
{-0.09741471244934709,-0.978967613485376,0.2863906883644006},
{-0.084997194332363,-0.963909162030678,0.2594518222490229},
{-0.07147489426836444,-0.9445127953658455,0.25234696257306577},
{-0.05992914125551628,-0.9154222166489961,0.21262721893306932},
{-0.053022526877176575,-0.8936916189079075,0.19327308191633438},
{-0.045821438551289076,-0.8933327056769639,0.17846341024921358},
{-0.03647775414536,-0.8977019098595534,0.1692300377711634},
{-0.04615866591398546,-0.9332906910814556,0.18798992866504716},
{-0.043359506056096016,-0.9361279499458713,0.1710324136857039},
{-0.045923958780278815,-0.9620873642389364,0.179494675700491},
{-0.0419007000788862,-0.9671867135019873,0.17937775347120916},
{-0.02412460944248761,-0.9766969303323619,0.18937422054558498},
{-0.0288014911769058,-0.995815764204608,0.20650724104574927},
{-0.032486766081240376,-0.9981987895468286,0.1993519435589433},
{-0.0010798599845733621,-0.9984703250473194,0.17386572145546902},
{-0.2834198704955794,-0.9987266213701624,0.15562987277625556},
{-0.0745502174751711,-0.9986945239053628,0.2299512656697722},
{-0.11196640493965149,-0.9981439958639529,0.2636094319798442},
{-0.11439190322135846,-0.9942008193385722,0.2794272086079527},
{-0.10739684233030733,-0.9921050531324517,0.29999547270847265},
{-0.10063393454458404,-0.9860985329625401,0.3045474970896653},
{-0.0946163600213945,-0.9838928564186935,0.30073925591800954},
{-0.08726538507665138,-0.9737369538040527,0.28510099752502593},
{-0.08613606257160024,-0.9702901586435632,0.2958059280612468},
{-0.08134448966430421,-0.9544243973042424,0.28476964315271136},
{-0.08801672731776677,-0.942088918318459,0.2799572693628749},
{-0.07074099888832878,-0.9252574644003915,0.23870855939620803},
{-0.06900291033286722,-0.9001674492292665,0.21405603101294615},
{-0.0566492567366531,-0.8701601358104378,0.1869985715007992},
{-0.03842550357037311,-0.8696295470388334,0.16939338403458237},
{-0.02249385913544065,-0.836854033388149,0.15142493808947294},
{-0.017160822650182175,-0.8449068753046359,0.14210004449050503},
{-0.027294992650631972,-0.8888903897760132,0.14857507481878193},
{-0.3991993186901944,-0.12522900950701424,0.2150318653366609},
{-0.39512037282095663,-0.14984509411511976,0.22285297061168202},
{-0.3873358239363198,-0.13647915923281112,0.22766611464718173},
{-0.37610962619463223,-0.11610275217173835,0.22535668760609956},
{-0.37543763731777,-0.13620340916053247,0.23670852038353077},
{-0.3675032368737354,-0.1463207293730925,0.24216978205477713},
{-0.3708288750474067,-0.15392825349373782,0.23674499603092145},
{-0.3906226969737668,-0.15717443737441383,0.21759939266905007},
{-0.4039829171644576,-0.1563169531560795,0.21280258209124361},
{-0.41849055691486,-0.16297402387562573,0.19820774734453173},
{-0.4214164492757621,-0.15607735363440117,0.19770511370967006},
{-0.4119409253724705,-0.11212893580507521,0.2058039143256726},
{-0.3984813307423197,-0.09808740517138448,0.21665807809994506},
{-0.3772906019050685,-0.08241536539722004,0.22277353650443518},
{-0.3610877725642233,-0.09750307768786103,0.2242812461756141},
{-0.3585000010509869,-0.11557645977732342,0.2312262857196785},
{-0.3646998592568346,-0.13628430195370442,0.2389023223952689},
{-0.35307639005017066,-0.1316009278451504,0.2438311318316095},
{-0.3523491612791519,-0.1401225125873135,0.24465475498817718},
{-0.33972058628875207,-0.1476586280293197,0.2441598716183001},
{-0.3498906136152462,-0.15247833668268643,0.2410473694501316},
{-0.3685709992205597,-0.164728060234745,0.23973198427783687},
{-0.3830172392363147,-0.1694618509059916,0.23289770606015567},
{-0.39781384010013116,-0.18084809188521236,0.2172370967316347},
{-0.4047692349331338,-0.16444460983064896,0.19848813801413082},
{-0.4163130065554137,-0.17620978405361246,0.19227491578042283},
{-0.4251126924783421,-0.17493924205263142,0.1877141679686904},
{-0.42532457059299617,-0.16727903206620828,0.18438156996144625},
{-0.4214121539609804,-0.1326596714120633,0.19439036734088183},
{-0.41395689200305713,-0.10812042757373685,0.19835867193581916},
{-0.39880105281150663,-0.08604015848725635,0.2119459690473147},
{-0.3866839368776582,-0.08064398416817092,0.2207701742801237},
{-0.38195367233793787,-0.07336586808872961,0.21804317103597273},
{-0.3584266460412372,-0.07241006333948416,0.2236590459784279},
{-0.35844443818485566,-0.07899434637505202,0.21908659574465225},
{-0.3537288646203521,-0.08632174436564331,0.22461466693112192},
{-0.3278434342824612,-0.10352029736684155,0.22561026947698443},
{-0.3437996532724804,-0.11618267286176284,0.2332277228610356},
{-0.34116709914517557,-0.12902725979561108,0.24463783508137196},
{-0.3395537744510521,-0.13783651057606608,0.24080699968278999},
{-0.3047600036185397,-0.15764431485163272,0.24710475239401636},
{-0.320959328076015,-0.15930254327431506,0.2435324029407769},
{-0.35652616313975577,-0.16477944890058507,0.24128384868006766},
{-0.37433017916547856,-0.18381082429938447,0.23836743830888274},
{-0.3895564145610238,-0.19620571737961584,0.23183894230749438},
{-0.40217643823094923,-0.20294773397813473,0.21938759393857013},
{-0.4195251466401794,-0.20995212599699387,0.19209493327308433},
{0.44705091126598434,0.15044357605791514,0.12933956625827403},
{0.4510343328616709,0.13749953287920544,0.13161091235376243},
{0.449141813769144,0.0895062140389597,0.11113984369428126},
{0.45548033744254274,0.1486682214236512,0.11658733124825212},
{0.46097049554385294,0.09540598453438391,0.0921663472106421},
{0.45356885118335816,0.05661187219937979,0.08656413270782663},
{0.4489194390653129,0.048238536905634864,0.09373283671880533},
{0.45519372531279995,0.045879827953402764,0.0974216069448396},
{0.454370852216147,0.11510379666682286,0.12803459693216285},
{0.44449771050293263,0.1745829742171382,0.14372247720679604},
{0.43533424870850757,0.19733940744317988,0.13709352310997996},
{0.4482532859945591,0.1863875414593426,0.12532143792420294},
{0.46171539321918403,0.17183374115194036,0.11215729996882538},
{0.47010157514818496,0.12852120202037304,0.09646199877562917},
{0.4734325019879417,0.09349421461231357,0.07667977515534674},
{0.46095699977742394,0.03697971474487313,0.050188614066162866},
{0.451617242030766,0.015287133142501706,0.05460682712109497},
{0.4461821612752173,-0.020506718284798442,0.04362077179147728},
{0.44117343114885216,-0.022044012826302938,0.05695089609368525},
{0.4457853147733657,0.016523874638961336,0.08148389934852723},
{0.45197878897067445,-0.0055803878655330446,0.07115631375637096},
{0.45834823508583333,0.022721685584956325,0.09569651694895116},
{0.4544582299466001,0.09649269279970989,0.12761146752346358},
{0.44721010457726834,0.14488180529566616,0.14357995094925816},
{0.4370252651610669,0.1881107764911923,0.15180547238178754},
{0.4249177533938341,0.21628964569501075,0.14907535734515684},
{0.4146428611043104,0.2311516186362817,0.13910802999223357},
{0.4364819923026015,0.21823440550444234,0.1280599969781191},
{0.452909708941752,0.2036544242813424,0.11717511368197842},
{0.4672005261315459,0.1626763584550123,0.10384395140733865},
{0.4716826398291136,0.13040054938085344,0.08629505668141953},
{0.47677639657744486,0.06323100858561018,0.0482486839626421},
{0.47541977510835653,0.051253226373826184,0.044542713354140395},
{0.46830855160960877,0.030473812970410956,0.03110750310807803},
{0.46339271098542245,0.012856933706229007,0.005998615324590234},
{0.4505418813432742,-0.005896746351588932,0.00876130165990452},
{0.44524078508645926,-0.02060285025561791,0.022247284375276302},
{0.433443513398696,-0.049352348256638916,-0.01715211356214786},
{0.43633232347734713,-0.05947801793218917,0.014255881502525899},
{0.43580663878020054,-0.05667682781297215,0.04046799693039998},
{0.4394569232832647,-0.03570182831869156,0.05417829430626665},
{0.4427958341177245,-0.01442732862550725,0.0665944716645927},
{0.44719186728477683,-0.04492202906469529,0.04699153892416353},
{0.45590279753432095,-0.0206035790673766,0.0682521582592912},
{0.45946282624417084,-0.04678411123583173,0.06191114536439023},
{0.46066763176181813,-0.07478166036087708,0.05497032357933729},
{0.45637972621218437,0.014800314510321391,0.1005684918170102},
{0.4464444559525639,0.0777434706050688,0.1318794083055045},
{0.44006013719045245,0.14942989876795643,0.15112850824914434},
{0.4279436682629611,0.19529097787950653,0.1578458631751359},
{0.41137207823316796,0.22652611813084889,0.15873458430794266},
{0.4129075486204601,0.23375949090531076,0.1492779659516559},
{0.39710618619303856,0.25120437165685716,0.13751146371892808},
{0.408019469774795,0.25310609013862345,0.12771705279898937},
{0.4251250525308208,0.23934541550915317,0.12601210074316704},
{0.4452835013173344,0.22265216172401547,0.11717459203974298},
{0.4577847796661736,0.19315346860806618,0.10934930194035256},
{0.4662594739771704,0.15542247802256587,0.09360185139732329},
{0.46716494290671695,0.12614433651864318,0.07809811614383388},
{0.4724999204110469,0.10180440782260025,0.06753652141990321},
{0.47425809059896057,0.039390948076895735,0.010492731043203894},
{0.47624734935957497,0.033514440062911106,0.019424169346054287},
{0.4732626102299963,0.015512790686470278,-0.018886569745302065},
{0.46824362574343503,0.0064579430922413385,-0.03214209708302874},
{0.453934936729437,-0.004868965597933117,-0.02967045843007025},
{0.4347915431758135,-0.03374401895411182,-0.03554684001752529},
{0.3879852780810933,0.09678189826692063,-0.13012994136238226},
{0.39101176133839954,0.09826845221135001,-0.1393365241650588},
{0.3759443537858512,0.11913394614528056,-0.14749542731577092},
{0.3924718910757426,0.11408501238251444,-0.13740003307562368},
{0.37735041971448474,0.14873022885556672,-0.15737177112612902},
{0.36300124340119994,0.14853942466226078,-0.1621300407357593},
{0.36383757189278465,0.15279207208385578,-0.17457012120743526},
{0.3896942481632586,0.10812444984971095,-0.15502781370635896},
{0.40966343324779286,0.07550828993389012,-0.12231349687043},
{0.393190973303663,0.0859041171669995,-0.12237366952405516},
{0.402640316291257,0.07418352263821243,-0.1086376459430341},
{0.408002244956948,0.09828523081791629,-0.11882871744345751},
{0.4041130908063717,0.1225924936609804,-0.12792675722726116},
{0.3837001284173225,0.16115089807411961,-0.1538493516528045},
{0.3674263355467112,0.23466544641763495,-0.17494927755681844},
{0.3366343245311188,0.2845664013511566,-0.19936250070536576},
{0.35908526026616094,0.1764877726191498,-0.1699436889703518},
{0.34911355579305464,0.17831216587317486,-0.1731990913636078},
{0.34204363021075374,0.20405127078319404,-0.19022605062954678},
{0.35823162621373555,0.1578827489119418,-0.18383646232469047},
{0.3886590093067662,0.0990101074180405,-0.16386721668291082},
{0.4138642043583625,0.06354971818015286,-0.1438501690640626},
{0.4203138537640237,0.06350675865788888,-0.13012592864807837},
{0.42365341266724854,0.057269230658270436,-0.10751084665653507},
{0.425567047115028,0.056451463493559464,-0.08455707436673912},
{0.4084609777762246,0.06521670084320155,-0.09433395237056542},
{-0.45457989476435223,-0.8422581513304407,-0.02585229330704769},
{-0.4516917731259629,-0.8273076660071741,-0.08616579883503893},
{-0.44363196075182515,-0.8397261456032274,-0.025214575581367405},
{-0.43919685859991436,-0.8391260126786931,0.006881284982502927},
{-0.4309719353029828,-0.8329364693902868,-0.017626311851935927},
{-0.4264592635695343,-0.8189255764730629,-0.06001606693144566},
{-0.44010439391265416,-0.8197148934189908,-0.09204473870050398},
{-0.4408189364719963,-0.7996324737226881,-0.145681491341834},
{-0.45116029405661245,-0.8075162355607975,-0.13227206998298685},
{-0.4627767322483802,-0.8159396623204448,-0.10702288381114182},
{-0.46125524314788674,-0.8378383680367633,-0.05284796318088042},
{-0.47250466299951716,-0.839296391019416,-0.024537753811370897},
{-0.4638504302676471,-0.8427078451840575,-0.010942159294867916},
{-0.4591232052766753,-0.8395239938320874,0.032820966112877895},
{-0.447813115564564,-0.8381090929200937,0.03995151905934726},
{-0.4294765463751934,-0.8312916953001287,0.0688395412276804},
{-0.4134465675980484,-0.8194352528093065,0.02833079298965254},
{-0.4065804553927047,-0.8073333749906978,-0.0032348400212692235},
{-0.39429061000964655,-0.7836055748657885,-0.08561494675924661},
{-0.4194642334883097,-0.7948563726603504,-0.13309255266206388},
{-0.4080378292441847,-0.7700283291945972,-0.1721883526936555},
{-0.4284142766767543,-0.7799997500048179,-0.16844388255088233},
{-0.4443298458190915,-0.7836198408778807,-0.16417802302574408},
{-0.45779199447762114,-0.7956678981791689,-0.14240673612788451},
{-0.46951477650409207,-0.7982258404682832,-0.12208336021512832},
{-0.470225550702927,-0.8277988606971298,-0.07034935977836504},
{-0.4729881573576554,-0.8320730686228506,-0.05038866545705978},
{-0.47214619597985424,-0.8336656423676005,-0.03705800888853829},
{-0.4780416307889999,-0.8319686689944422,-0.02779009753253773},
{-0.4874657660264514,-0.8234896379347592,-0.02249292156054711},
{-0.4863251565008113,-0.8242194600432458,-0.004315681670660345},
{-0.4767979581439784,-0.8307568919567363,0.03961394641411225},
{-0.4696810210160206,-0.8337144376959729,0.09094262020987283},
{-0.45711485823491244,-0.8370662355371855,0.09109143273443109},
{-0.4454079623924463,-0.8364562137207422,0.085112949506664},
{-0.4294234961035362,-0.8298861966972665,0.08681002168374873},
{-0.4189804140333811,-0.8239031823001834,0.060254979075269915},
{-0.402090357700434,-0.8004955504557419,0.051295936230254496},
{-0.4001032056945097,-0.7962309084499557,0.0005833144776752236},
{-0.3931238599398056,-0.7814764150573382,-0.031212657046032384},
{-0.3896144092786355,-0.7799999114908054,-0.055588644925603864},
{-0.38399739968463775,-0.7737888076982734,-0.09148079563565889},
{-0.37935572826990677,-0.7620897747360198,-0.1432524265571039},
{-0.3902303890780856,-0.7689243557399272,-0.15275846918718733},
{-0.3891572169506854,-0.7537188712937554,-0.17561907787358902},
{-0.4084343517116539,-0.7512998568869216,-0.19188784661766},
{-0.42777742481344033,-0.759439752499479,-0.18733438373629066},
{-0.4472783536550762,-0.7590305863166457,-0.17874882504535303},
{-0.4601703994082698,-0.7697016759768482,-0.15992821435782126},
{-0.47038486406629365,-0.7779248962340581,-0.13824272432759135},
{-0.47741401974883,-0.7951520620024343,-0.09956279852175451},
{-0.48150540641353995,-0.7962485784166756,-0.059356034392093575},
{-0.481248866799308,-0.797751991710665,-0.05028025417675552},
{-0.4853591791967712,-0.8115848866983424,-0.03727518204372458},
{-0.4959323955997514,-0.7949092210745233,-0.02519492528648674},
{-0.49066258619057607,-0.8117607757483835,0.012643788139055971},
{-0.4870205289736036,-0.8165025100428361,0.05952640848318528},
{-0.4817034243558857,-0.8214613101892864,0.08843084803942883},
{-0.46282317646826576,-0.8317666787092894,0.09496328132416643},
{-0.44424526540840603,-0.8354929529934759,0.09394227342030861},
{-0.4307333089468598,-0.8243739511375562,0.09281474850927438},
{-0.4183785791315327,-0.8177133139149869,0.07828878541134783},
{-0.41535967509155336,-0.8005704459568183,0.08557792078460957},
{-0.3994555342700439,-0.7655796909047606,0.06646057109607602},
{-0.39013340611860914,-0.7455815690186657,0.04792176726775598},
{-0.3950828443274248,-0.7807120636325717,0.010746571079186923},
{-0.38735017069140576,-0.773180244567755,-0.0083346864911759},
{-0.38340804701216613,-0.7819131411612087,-0.025044572270601865},
{-0.38615509151727234,-0.782362025460073,-0.04254172348647192},
{-0.36636755160830137,-0.7634396690388461,-0.07906033039940583},
{-0.3483281102611915,-0.7488218352878319,-0.12115047478959942},
{-0.37633333953230586,-0.7679534754238373,-0.12564243700757927},
{-0.37314782551211073,-0.7600197846682206,-0.15998592541254725},
{-0.37882813973796187,-0.7491016373835033,-0.1694846724881894},
{-0.37837390621576666,-0.7298659216534723,-0.18693153887993552},
{-0.39169781330746195,-0.716195786480102,-0.2074827810825003},
{-0.41115156805504577,-0.730332638467452,-0.20604506283794002},
{-0.43113250655719826,-0.7362598870785119,-0.19821500146506835},
{-0.4371797169462884,-0.7049908666420621,-0.200385236084325},
{-0.45579191403103925,-0.7388817013252506,-0.1735814296243863},
{-0.4702242131314924,-0.7462426554665667,-0.14729049947301945},
{-0.48304711844672443,-0.7365427701568364,-0.1135404571978206},
{-0.4827105763370665,-0.759406033800359,-0.10728974790448545},
{-0.48953583683724416,-0.7339754255585909,-0.06746087373409641},
{-0.4874459882426334,-0.7559950651560874,-0.0513490895554694},
{-0.48845391046947756,-0.7899145944118553,-0.044278009135877455},
{-0.4997935446804176,-0.766369817405441,-0.03155744556512279},
{-0.4962328679018026,-0.7908948770370767,0.04146979650102669},
{-0.49246047343211313,-0.8043239540028435,0.08056595775127423},
{-0.48594338556580413,-0.8099971755941453,0.08984050065683388},
{-0.48094255869114855,-0.8030048599648791,0.08864635427675895},
{-0.45591062004303656,-0.8257413539211154,0.09427571436156489},
{-0.4372081267935744,-0.8234745613055069,0.09486401418789536},
{0.15490002995081673,-0.05796690430638238,-0.2421089092744042},
{0.1605793306396157,-0.07967448179501242,-0.24357522010039415},
{0.15924098683451549,-0.09346263347771035,-0.2522882369188798},
{0.14922607954775627,-0.08109716378181717,-0.2522284796667089},
{0.15795257194692242,-0.11460930851265169,-0.25849346453380656},
{0.15887364445999566,-0.1582006776367431,-0.26205219710612665},
{0.1658219254102928,-0.12695937754491,-0.24794300490614776},
{0.1698557433829235,-0.08951280946665328,-0.24215316599660602},
{0.17292601590299447,-0.08456470882927228,-0.2346466566730816},
{0.16672682701406805,-0.06387542904217303,-0.2344227202297675},
{0.15566525254998878,-0.041162522664166604,-0.2489113120705184},
{0.1448483038589437,-0.03287656510087482,-0.25670947889848234},
{0.14329838472541567,-0.05798392514192972,-0.24682661084175414},
{0.1328389702599751,-0.11769313841880466,-0.2652338598980052},
{0.13666220625548173,-0.1319869133519456,-0.274099059198627},
{0.14965816505430607,-0.1221442074977138,-0.25969433914255147},
{0.15157319763076543,-0.2006064517012339,-0.2680551720211712},
{0.15338397187905542,-0.22196686937653837,-0.2684314099362962},
{0.16673085991412032,-0.17497336659153537,-0.2517641947042095},
{0.17642083614619303,-0.11835779136972875,-0.24602870220385492},
{0.18222052463855484,-0.12423057033229513,-0.23789371066575518},
{0.1804018258903992,-0.08632603968042499,-0.22574088933017936},
{0.16999284817339955,-0.050104217452028796,-0.25087759201257886},
{0.14995855555095577,-0.01071507812443202,-0.2747916566622158},
{0.14245628098496788,-0.01716140431845905,-0.26163816722033245},
{0.11420444242543519,0.014745359341458313,-0.30058543307821245},
{0.12304963021252045,-0.017704312771045113,-0.2746740449302643},
{0.12670321774147061,-0.0350703267411161,-0.26263672750954203},
{0.12648602015090468,-0.06547894558738108,-0.2734183968243921},
{0.12502333638518306,-0.10585250136899349,-0.28132604902695774},
{0.12782914585356428,-0.12055066058740843,-0.27640485917944085},
{0.12209610645284623,-0.13738081730553792,-0.2842764213886514},
{0.12425570212027896,-0.14230970854728003,-0.2839555232340171},
{0.1371731893533337,-0.14952200740039395,-0.27676316365070863},
{0.14543743342577495,-0.17727071618061693,-0.264264682621637},
{0.14460724565134028,-0.20570288359243458,-0.26573111456211745},
{0.13598742112125983,-0.25559346411367745,-0.2684628997038278},
{0.13792091409585103,-0.2923275570781931,-0.27589897245186057},
{0.13887979770293404,-0.3347016373928526,-0.27974786240879035},
{0.1562257300405529,-0.26435991792026364,-0.2646973152682097},
{0.16669037261483363,-0.25094267405270076,-0.25432140818156507},
{0.16962720777619372,-0.20580477062636868,-0.2523854026124998},
{0.1761655321122459,-0.2012288750040605,-0.25663271993410475},
{0.18174997784441477,-0.1575365920115903,-0.25220458823984493},
{0.1828085397395918,-0.14372647398498278,-0.24845006665676758},
{0.19487390260172088,-0.14699138067852005,-0.2289242955332765},
{0.1905809304292343,-0.10956069878426802,-0.2173607864986755},
{0.20279693421976516,-0.11248031019018884,-0.20737813922511106},
{0.19993394065093245,-0.10256238586290602,-0.21639910557182493},
{0.18756083118046712,-0.059680250446323,-0.23758290432292195},
{0.16292458419691577,-0.01921064449929254,-0.26913981284089605},
{0.14468382188157433,0.010749658436287012,-0.28884840522539784},
{0.12943373649306966,0.026154214733353696,-0.2949549277177858},
{0.13302484063140477,0.011443978062938145,-0.28094841298315276},
{0.1343909154051995,0.0012130173988258725,-0.27334275232580874},
{0.12880680433149125,0.00011528559004823159,-0.27813585510035316},
{0.11819829899064586,0.025326721225128898,-0.28865010362016635},
{0.1165274257901916,0.020662070991843962,-0.29647041846377575},
{0.09804048871122677,0.04802584817382071,-0.3220929666128003},
{0.0942658961197754,0.053990706021405925,-0.3303782346734225},
{0.10056168231414267,0.026481029437089913,-0.3144800114634228},
{0.11475256836278336,0.005861457413723616,-0.2941612750855792},
{0.10503615729954596,0.008377494089122814,-0.2923530336175117},
{0.09562441292439945,3.577073980774176e-05,-0.29310459790185966},
{0.07489312553243536,0.003117006246085137,-0.2942755221719918},
{0.07059957647250716,-0.00041035767319387085,-0.2921316512025764},
{0.10038617785572951,-0.0446408479636845,-0.2913889006534323},
{0.11200565559624573,-0.06593366569235391,-0.2886749065929326},
{0.10492385548183622,-0.10846004960364015,-0.3062336891483529},
{0.10537022718622671,-0.14964894069848308,-0.3114657671441045},
{0.11904532699129991,-0.14891628196113998,-0.29732895659065905},
{0.12032522030583732,-0.18014955662436535,-0.2971991866637133},
{0.13631578587799298,-0.1965542551358729,-0.2755006874498322},
{0.13986896630709036,-0.20826325773302917,-0.2672111633835173},
{0.13089589330451679,-0.25870225847858397,-0.27077392779348175},
{0.12799315187223412,-0.30912367000041224,-0.272352419322691},
{0.1183989718901125,-0.3603603360924775,-0.2771584909093899},
{0.12001951033327557,-0.39628906337866526,-0.2884380225856204},
{0.12278736528259261,-0.4159613426641715,-0.2915555297569886},
{0.12255159574107466,-0.4698352236666104,-0.2941675974744652},
{0.13942194653393483,-0.4639648754931166,-0.28086510852424884},
{0.15754401346135716,-0.370032338509196,-0.26452014814157154},
{0.16486681122612487,-0.30072131716211314,-0.25688603726544457},
{0.1694212663963901,-0.27904486503513526,-0.25585868253732114},
{0.1739470896761366,-0.27700713498053103,-0.26271283840515464},
{-0.17655588517755388,-0.5455601486461303,0.3174590975210366},
{-0.18257463578619065,-0.5601429675604946,0.3100776760932329},
{-0.19357436430434183,-0.516182472279168,0.2845888893373017},
{-0.19478281706800582,-0.4939438204985637,0.28213834585384745},
{-0.20293766819532508,-0.4670500015367995,0.25988733295835686},
{-0.20655056550509648,-0.5104586726391863,0.2527497872436725},
{-0.19842307137892215,-0.5244147708111266,0.27227302558694105},
{-0.1937203348880044,-0.5463700529306287,0.2890851075609743},
{-0.18369807148955863,-0.5745652959636373,0.3126671899552801},
{-0.17146153029362457,-0.5595100880399877,0.32913744115356997},
{-0.17079708026259252,-0.5451370404855873,0.3291518282801527},
{-0.17634069341293598,-0.5138853649190674,0.3142019920880589},
{-0.18835465698514683,-0.498194359040653,0.29675008032161615},
{-0.20338499181711456,-0.45001817856789966,0.26671591560776087},
{-0.2050308187534138,-0.4191922066242063,0.26589606187410825},
{-0.20084642147203444,-0.4155226712915985,0.26340101837706337},
{-0.19912683368620152,-0.4757830596162404,0.2553503437725119},
{-0.2103263023097608,-0.5381200844319499,0.24616702345127503},
{-0.20765771980875386,-0.564561776626209,0.2670793068876298},
{-0.1981925086980881,-0.5568336415963605,0.28126608885489485},
{-0.19420782177469811,-0.5851952098842913,0.298150290258393},
{-0.18096325636077007,-0.582097277576849,0.32756476630712844},
{-0.17738174788978806,-0.5713169245852775,0.33894873692085614},
{-0.1829074892159272,-0.5522087902221005,0.34024468959187154},
{-0.1729938910132527,-0.5468109946686948,0.33377542388837955},
{-0.16436872682151182,-0.5441525432885779,0.34244451014386157},
{-0.16216089252740004,-0.5258410193009545,0.3410026378847585},
{-0.16664960271506896,-0.5173464260916493,0.3256392169557435},
{-0.18139432833026778,-0.4835830102269198,0.3024766964047061},
{-0.19359995770851976,-0.45443358474139395,0.2828079028792292},
{-0.1951619734173889,-0.4424960869090047,0.2862266324125636},
{-0.20367918210177663,-0.41074867698395084,0.2729041223871403},
{-0.2102166958206686,-0.390793677168515,0.2693242351504786},
{-0.20552019035156505,-0.3963104613343958,0.2638170955227102},
{-0.17165468559541738,-0.38518886614100833,0.2649056279422485},
{-0.16858277059286983,-0.4190150193118198,0.2611729707119308},
{-0.17503266435232773,-0.4636871801521351,0.2539088167959476},
{-0.1817652882033855,-0.5336633410329198,0.24252334606239015},
{-0.21585230711303716,-0.5889101355282358,0.2358622828142885},
{-0.2223882410315135,-0.5867428799004824,0.23789184720245385},
{-0.21953098127763918,-0.5809578016403437,0.24796888303561915},
{-0.21339556235518745,-0.5577918781970862,0.25456688388084847},
{-0.21516982164699777,-0.5954402740121006,0.2631284905876769},
{-0.21445223953890702,-0.609157745827918,0.27082367610166097},
{-0.20444515476086353,-0.6025089427659606,0.2868320136316866},
{-0.10001112558772186,-0.8150728575983806,0.2947288048391958},
{-0.11025976578022455,-0.824206166134301,0.29183843408346966},
{-0.06307043361296741,-0.8000375889445364,0.26467782114727734},
{-0.0690307050460305,-0.7974621381746895,0.27601854963826317},
{-0.043596100026075744,-0.7849506065280618,0.26347561002950565},
{-0.023316231838014304,-0.7819980870401813,0.25060534788607797},
{-0.03748768432296777,-0.7833875369106437,0.24130852947593553},
{-0.08583538734965694,-0.8088559169373325,0.26018330596332656},
{-0.1099709098451838,-0.8240925267451565,0.27719233178540814},
{-0.1270678658497805,-0.8304934626278471,0.2937988367855171},
{-0.11610658799514152,-0.8212437577545113,0.30636435149786034},
{-0.09996234619546682,-0.7995186728475564,0.30486284310107686},
{-0.08059798987799352,-0.7809816538643596,0.2948517445463216},
{-0.06603161066210358,-0.7789260912946401,0.2936941333084748},
{-0.030429025575507394,-0.7896827759649881,0.2854005975902639},
{-0.013219869744350824,-0.7889746769090225,0.270455928949765},
{-0.005821020578807909,-0.7827528736074214,0.25202918471017377},
{-0.0001732000958701354,-0.7688732911084696,0.23484299282386178},
{-0.009191084397522968,-0.761510553184438,0.23040114331994047},
{-0.05589740029015705,-0.7797833322215856,0.23425485554592645},
{-0.07411097877682683,-0.7929334166464332,0.24144601992044712},
{-0.08553621224754361,-0.802156535826695,0.2434406077186438},
{-0.09785883928603197,-0.8145093607448162,0.25464569010507876},
{-0.11251248467955476,-0.8263862290882215,0.2649361445442247},
{-0.12902291932849727,-0.8305985103250202,0.2738133798629425},
{-0.13191398914856345,-0.8286359998058748,0.2830477860637932},
{-0.1346068072965652,-0.8244684618740554,0.28982761481872954},
{-0.1262822471454442,-0.8252075237432781,0.3007707669336972},
{-0.12287227185247615,-0.8195062567105695,0.3019278310315212},
{-0.11625198062895468,-0.8110510565205051,0.3085512637949412},
{-0.11209678256386534,-0.8054694272314445,0.3141053129772165},
{-0.11331998792239928,-0.7916438277982084,0.3189016178489047},
{-0.10037366587893395,-0.7802057923133636,0.3202899330678245},
{-0.08241194178804764,-0.7791642321303931,0.31223510444873026},
{-0.04374031551203388,-0.7832275329821996,0.2945943135719359},
{-0.017281452682726024,-0.7891782884284955,0.2856134286847248},
{0.0035876077542276235,-0.7804009736268528,0.27580257806631164},
{0.009860620174748556,-0.7746849550616821,0.25491872466299137},
{0.007226144151712874,-0.7745145767209592,0.24666863398741423},
{0.022125883565865357,-0.753208870923129,0.2324176570905499},
{0.0320241363501113,-0.7300836366366423,0.22375272484961073},
{0.03223057918640186,-0.717196981540684,0.21929176687879254},
{0.0038632409616469383,-0.7199787986534593,0.22391726738422538},
{-0.03783429912108614,-0.75772057055343,0.23088496171246126},
{-0.06208246128000678,-0.7643155520356593,0.2264250364020358},
{-0.0733462725078512,-0.7814044379905201,0.22857529137999022},
{-0.07067459415048165,-0.7847714739469726,0.21934119009018144},
{-0.08068851871001533,-0.8107279698057793,0.22998478251140797},
{-0.0936493096854648,-0.8326216503331497,0.24782983191403254},
{-0.10980996462341877,-0.8490415051544955,0.26832539013597556},
{-0.13219085368663627,-0.845797673444714,0.27741039098870923},
{-0.1402077681581631,-0.8305245879894992,0.2699952710475339},
{-0.12809165513728873,-0.8138265512443944,0.2663490598160187},
{-0.1289032507750229,-0.8080531456588802,0.27373927585568575},
{-0.1332109139227263,-0.8096419914146198,0.28617356089275015},
{-0.12771571044671956,-0.8077691279290128,0.294330397660269},
{-0.1139654814108516,-0.797982188923212,0.29954679132950013},
{-0.11517921327893067,-0.7900176968403257,0.31413909329598955},
{0.43268224189417487,-0.5120403853888799,0.009229664143584275},
{0.44073289525057013,-0.5576344686685177,-0.019044597595216872},
{0.4440827488854878,-0.5250690493497719,0.002632959435884899},
{0.45868907251027285,-0.5053742363945848,0.012097967626658693},
{0.46688976016020967,-0.5327864848705514,-0.0004752272317534684},
{0.4625699186317635,-0.5477580441151659,-0.008855806021956857},
{0.4498342284985894,-0.5622416511384655,-0.02322175031772993},
{0.4459077084028764,-0.5874415766473168,-0.04179980374023635},
{0.4376142119937545,-0.5858407341825701,-0.031570505744349005},
{0.43490737112504935,-0.5512952969263539,-0.006876395781754629},
{0.4299877207064514,-0.5068491187267975,0.016610512933577657},
{0.4257075962316287,-0.47582180456671636,0.022005891509212276},
{0.4411051013280507,-0.4666729328187659,0.021196186957382474},
{0.46483338697332993,-0.4944158865358742,0.011557136181344003},
{0.46631588889436637,-0.5250632135436636,-0.0015938300419871237},
{0.46541921457668306,-0.5553435222113158,-0.02494448920513161},
{0.46758310662130537,-0.555302021374977,-0.018982590163301324},
{0.461278789292212,-0.5687636834507289,-0.029055248876283437},
{0.45725342171131367,-0.5770256475960068,-0.03787876460642284},
{0.44775349855022417,-0.580496759146485,-0.04766461995625591},
{0.42275471233786865,-0.5836932552762271,-0.06392471520295417},
{0.42917275086150813,-0.5946154545843373,-0.05179201587132731},
{0.43521809672488887,-0.5998821033302736,-0.03573078424359273},
{0.4376617919275905,-0.6013660628748274,-0.025101453584827158},
{0.43635939575319865,-0.5653178603933869,-0.007121988345897333},
{0.4460447728218556,-0.549055576586597,0.015849823628537124},
{0.4375802903747426,-0.5019021527409592,0.03427129407575231},
{0.4226674557219062,-0.4606819737360689,0.031465886197523815},
{0.41844415200406365,-0.43869183826590435,0.03373483443858176},
{0.4150002752778321,-0.40017031427753197,0.042911223611256745},
{0.4255372189533136,-0.3538219310134317,0.053497975089754846},
{0.43246825596242305,-0.3797284958299158,0.04096415518965082},
{0.43854399731328964,-0.4240166164321387,0.027686684880986353},
{0.45196274023827454,-0.45960231773379534,0.014743642490435},
{0.46473060964164986,-0.4790902777632767,0.006893483548994042},
{0.46126120006848553,-0.49955738470402894,0.002946891382499429},
{0.4548593728256413,-0.5153516555593091,-0.01194487891065935},
{0.4592666728275343,-0.5411650079016396,-0.026840575863089265},
{0.44716029571184396,-0.5639835282401826,-0.048120342974202784},
{-0.2879084478822719,0.0872290470110723,0.21331051501626883},
{-0.29497049146101967,0.06655557266498408,0.23778700136276484},
{-0.2770160565501277,0.08470133766104872,0.24054255681684863},
{-0.271677431799781,0.09435283348219053,0.22714294360691686},
{-0.2550354848750819,0.1105544877999963,0.23979741585012873},
{-0.2694536390779333,0.08751014630668164,0.2436927096554473},
{-0.2946093291127391,0.055732746733926086,0.24404096374881867},
{-0.29987542965624464,0.054326113479521175,0.2361016602927342},
{-0.2969997509381431,0.07844419336359958,0.20444156754088819},
{-0.28911787381149123,0.10539191464808573,0.18799838861844975},
{-0.2711542002022709,0.10992809215436272,0.2017635412968453},
{-0.2543262511675735,0.1233394991534094,0.21717103621391845},
{-0.2424502741843222,0.1361105695915206,0.22668569072172148},
{-0.22354149533492557,0.1623463820256292,0.22296689472611994},
{-0.22557608384963132,0.14036905281922393,0.23084088772440303},
{-0.23796354007518253,0.11427784258751683,0.23480327577023838},
{-0.25957632422683546,0.0900543091664813,0.24067263059242847},
{-0.2823175990182234,0.06644274283059198,0.24085433632523714},
{-0.28608251626173586,0.04836214699208981,0.2354517185027753},
{-0.2929887502980791,0.03267446326290171,0.2428182651588109},
{-0.2993349328693906,0.037224177969512245,0.2403399397110871},
{-0.3002301888726456,0.03662882694253713,0.2313981227463266},
{-0.3003487121504993,0.05183868850889225,0.21148228222041313},
{-0.29756008606606055,0.10149818045743442,0.17477397601829717},
{-0.28902403239191327,0.13519326756377015,0.16428283911801433},
{-0.26954438145392523,0.14852572703834768,0.17011217303794693},
{-0.261465013339202,0.134121959962079,0.18991555875942573},
{-0.23863887234942735,0.16145242322231196,0.20724612124323627},
{-0.21813593889245725,0.20966645622297958,0.20410683896136445},
{-0.21235396180072022,0.181337229753645,0.22272202672410463},
{-0.2055090456936229,0.18665802305128426,0.21984685371212134},
{-0.20539119067028264,0.15547289352285065,0.2163925005824611},
{-0.21814414599280074,0.13050446242648397,0.22583280672921077},
{-0.24822363939833955,0.08961101844474403,0.23165599993199315},
{-0.2640674758276552,0.07507034843548356,0.22865944682755118},
{-0.2764436450326175,0.06041782281979405,0.22821455505724209},
{-0.27799581222107456,0.04866894062061916,0.23100198593289298},
{-0.28777855684083564,0.02475147201635429,0.24492092001718088},
{-0.2917989597900311,0.01584973757350436,0.24499881469550894},
{-0.29364517702531906,0.02063451213321484,0.2333990127476608},
{-0.29462177097061903,0.04840875376037048,0.19852072206170812},
{-0.29775992816261854,0.09448398028965993,0.17059523180888253},
{-0.29093114153091476,0.13543002939418403,0.1440357451485284},
{-0.2848936574853385,0.17580131587271125,0.13791159306091716},
{-0.27524501954120945,0.20408920511650983,0.13884603916352106},
{-0.2719984712546541,0.17548787475850564,0.1535819914150129},
{-0.2566297011023085,0.16941229489362622,0.17016721957388184},
{-0.2463844553027634,0.18433011542632186,0.17946498990142332},
{-0.23690349930833182,0.21360087957040177,0.18378454776698375},
{-0.23117597061693188,0.24107424411813017,0.18504917215645494},
{-0.22368889485709462,0.2680434441013404,0.18781543668127823},
{-0.2132606057533062,0.23483793151304796,0.2057131220165135},
{-0.20934768129035658,0.2279107042983504,0.2170593219077284},
{-0.20402814482115825,0.2370812990988217,0.2169605360421959},
{-0.19441679207917228,0.2284206228635752,0.20438900278960084},
{-0.19494590091669534,0.1837845318308665,0.2015733044293106},
{-0.189006726777952,0.17811455270820523,0.19658889069293406},
{-0.1964813511182391,0.1553868947977368,0.22234566663208122},
{-0.21749809474024737,0.11811905346078545,0.23721831783426506},
{-0.23926172167778637,0.0726265321182914,0.241775975101674},
{-0.23800844486614928,0.09244608874906837,0.23461867178892004},
{-0.26197815418731896,0.056020087675427724,0.24110512087635444},
{-0.2617562650038576,0.06878799638789204,0.2288983175374708},
{-0.27424481783193116,0.03968234104179024,0.23932818644167486},
{-0.28350471438340213,0.006041481354966767,0.2596684833236441},
{-0.282701801804711,0.0030783431010107058,0.25436491484385193},
{-0.2756754030704453,0.003273848448882359,0.2454251451389441},
{-0.28397327553734264,0.027400034504562173,0.21436538823152457},
{-0.2884935456114587,0.048786713838557975,0.18689366616627276},
{-0.2933293242453815,0.08709344127801825,0.16362628065220572},
{-0.2927480161248582,0.10895137603216441,0.15074689986253237},
{-0.2952566775652302,0.11303437392479515,0.14212209157740835},
{-0.2912287559559531,0.14419113291503174,0.13215003226009286},
{-0.28288368920925544,0.19143144897075287,0.12554920328526945},
{-0.27766397232839013,0.23872785590928744,0.11920358803972925},
{-0.27172059424193695,0.2692967209129775,0.12901730078478646},
{-0.25696610084931965,0.22397157979636254,0.14913404156543816},
{-0.2617925175456079,0.2043022178827065,0.14963839842577},
{-0.24479506240700077,0.2816326057385451,0.15886526578079063},
{-0.23508877290298316,0.322531075971641,0.1677101497192418},
{-0.22297702637821387,0.2920002249818526,0.1878335220494526},
{-0.2187460616376428,0.2750465399826696,0.20036752574610805},
{-0.2150429095970649,0.2619691614363989,0.2168912128700907},
{-0.21074302858658042,0.2656592841075771,0.21833563809516462},
{-0.20878149017058245,0.28627115686153387,0.21320667315196162},
{-0.19015107491668065,0.25124473677924564,0.19851362942715886},
{-0.18860434831862607,0.2221510781421508,0.1912789190812623},
{-0.18547602902296073,0.19017022959831734,0.1877395287055576},
{-0.1673731629919148,0.18578911051212213,0.20797697601211554},
{-0.17276789881082352,0.17467651178808205,0.21939452402472426},
{-0.18178121582129483,0.15068917287168912,0.24397370802231452},
{-0.18902313991623126,0.12344227754749734,0.2652381562751947},
{-0.20773725484474284,0.09799472815076778,0.2678476104694551},
{-0.23419440932228983,0.06798011917749792,0.2542322679165528},
{-0.23799284234503026,0.020833097401331914,0.27386004825087623},
{-0.24373520331188592,0.015262006135353024,0.26621797356579463},
{-0.25056326006942325,0.05382486734926126,0.25018785242600283},
{-0.26677139826210233,0.021497993643644818,0.26349692724224244},
{0.14920494400675516,-0.912476991653149,0.17027437402574513},
{0.16693526080259732,-0.8896641435099112,0.16736979887757986},
{0.15710781431176138,-0.8909435204942524,0.1564811153486976},
{0.1382453585677599,-0.9291844307073853,0.17345734464163962},
{0.14088836785033726,-0.9029377572782201,0.16296626829860206},
{0.1491580535755888,-0.8844855216256008,0.16754251770271147},
{0.1770880229397475,-0.8669526161372442,0.15126651502385227},
{0.20136845679834894,-0.8447869135266055,0.1442038138146693},
{0.18668158353811504,-0.8751939929439516,0.16688341583260222},
{0.16807607324812945,-0.9038376326306394,0.18325591488816018},
{0.1468496602573071,-0.9342876715702495,0.20636029835893918},
{0.13582948463841685,-0.9429683678182951,0.19978244926507752},
{0.13069132986764467,-0.9523916935009942,0.19154708037454374},
{0.1231891062972317,-0.9614243314599248,0.19070109565836058},
{0.12353023694622729,-0.9390906834224515,0.17956784903850492},
{0.114901699609685,-0.9313131049954656,0.1746671041669117},
{0.12142064244003284,-0.9204298110614108,0.17461518854679714},
{0.10537947757104099,-0.9315638895465828,0.19083508015709436},
{0.1275524736113052,-0.8915971499017248,0.17827882645364365},
{0.1634055457748316,-0.8571507619881783,0.16341237546344745},
{0.20638318527921748,-0.8283109678224461,0.13890061930242675},
{0.22274482227731116,-0.8291651288291464,0.1292529237140265},
{0.21338830717224305,-0.8467946528711001,0.14891499007324122},
{0.19540846159131672,-0.8818437681090567,0.16522926068146898},
{0.16426223956175423,-0.9223325037711401,0.1950726307636886},
{0.1515925695747995,-0.9448494989614908,0.21402318348823163},
{0.14031845830322306,-0.9492285920359896,0.21575268991339225},
{0.13087031052441706,-0.9578906451517597,0.21843073634318358},
{0.11261480623828378,-0.9853434212985099,0.22281511808376772},
{0.1124248732193832,-0.9800240877492035,0.2072895769099482},
{0.09996975648995172,-0.9755746388422069,0.20418174508651885},
{0.0994428967697655,-0.9523557044363811,0.183486101476629},
{0.08850408140348416,-0.9580209824044769,0.18963878558842465},
{-0.36551306656721877,-0.5188302241502157,0.10853982793101785},
{-0.3661466961476406,-0.5340345739448451,0.10455734444142886},
{-0.37027903650866645,-0.5080983424526339,0.11724603259061643},
{-0.3662255023718708,-0.4998287576561244,0.1319330567127595},
{-0.36797042008474445,-0.46638891508889846,0.13540256721466576},
{-0.3675091342994968,-0.42997531443923315,0.146765201492316},
{-0.3522761313661925,-0.388747031387557,0.18152600262321555},
{-0.34347227124297286,-0.3580256194958514,0.20676447016265084},
{-0.34864910934456783,-0.3532579475770898,0.22053337101580517},
{-0.3449349943177835,-0.336294536234393,0.23473267664635158},
{-0.33150251233498096,-0.33254459469139075,0.22764878890059256},
{-0.32102611740548986,-0.340790024583899,0.23931031461747057},
{-0.3052027684484103,-0.38741383388589545,0.24171319848650297},
{-0.3136284453878021,-0.3809736675323593,0.23444495005081442},
{-0.3108114498275741,-0.4102652633688062,0.2286695386393522},
{-0.31267957072471086,-0.4621348089813783,0.21205162550416384},
{-0.3120007133813476,-0.5091591938366447,0.2011821322475799},
{-0.31513238563606594,-0.5486710508281347,0.18779281164452546},
{-0.3188642513725641,-0.5595635845229256,0.17718651504952004},
{-0.26710982508321773,0.3392399737118023,-0.21780484746607603},
{-0.27513180511518964,0.373144426338318,-0.22344469457838884},
{-0.265588720574352,0.363531269627868,-0.20960405888739728},
{-0.26056264451564937,0.3249412543327068,-0.20838954721198458},
{-0.2556225278729714,0.35708859067985776,-0.21498819718838674},
{-0.2666796848453707,0.4050481908209836,-0.2113203638330928},
{-0.2724583992827187,0.4166484177319563,-0.21421231545164238},
{-0.27943284202537294,0.42452269545553284,-0.22659738019720999},
{-0.2834544805548531,0.3965317938161639,-0.225597745813703},
{-0.2825231961778961,0.31938305007348095,-0.2288489134494226},
{-0.2750623810143423,0.28204785208128336,-0.22904154179694083},
{-0.2657773776414711,0.24076534267250288,-0.22432931162981992},
{-0.2619363696880945,0.22743037060345125,-0.21553286817553202},
{-0.2593709905443001,0.2885867437431068,-0.20797288255481802},
{-0.24481814215429684,0.3202561782468389,-0.2174072710900579},
{-0.24235710101925764,0.3638708098523699,-0.22186737913462687},
{-0.24057090663809336,0.4040961969285579,-0.23105531986743583},
{-0.25278830855730405,0.43036913201641425,-0.23656274209568204},
{-0.258107176771989,0.41409396014046373,-0.22664787750289622},
{-0.262682200157484,0.4302359581348406,-0.22667432189573114},
{-0.2698381255273065,0.43717145300712695,-0.21887108950732215},
{-0.27513291958098385,0.4543040272960104,-0.23248825515202887},
{-0.2909143629243484,0.4240391192919931,-0.22214708030155633},
{-0.291876246771091,0.29040594819738075,-0.22284277787113893},
{-0.27618288978418976,0.18851467525609641,-0.2349150506336737},
{-0.2692634234585548,0.16792501213743816,-0.230238363319885},
{-0.2610770825637041,0.16736986474686413,-0.216459937980701},
{-0.2575682597855506,0.2194324838558275,-0.21357941574538705},
{-0.23519955547752264,0.27511568042063134,-0.2289929079545559},
{-0.22616711937607628,0.372423763247574,-0.23478973856990482},
{-0.23316911991495187,0.4452278624890446,-0.24140271511564448},
{-0.24989609346161726,0.4548486377259104,-0.24380592301905932},
{-0.26491944721185595,0.4645262337197564,-0.24061907248983744},
{-0.26686171461256186,0.4492919739580111,-0.22877671327696392},
{-0.2727600062363126,0.47257214555008903,-0.23692400537270467},
{-0.32424178362178185,0.43595781250611965,-0.20006472358372634},
{-0.3136347667142803,0.29758720349424395,-0.2075509079834098},
{-0.29549589143287297,0.18203843909495346,-0.2229839761189125},
{-0.28256714798905597,0.18166874561194693,-0.23409959420595272},
{-0.2935184264613735,0.0672568627492862,-0.24003446134342832},
{-0.2907824458712157,0.05277147300567907,-0.24136008069017076},
{-0.2820939271144544,0.08640755079494318,-0.23714698883621185},
{-0.27111642841735023,0.10803545194734539,-0.2279014581631674},
{-0.2642245198879366,0.12270305312987942,-0.21757021257610068},
{-0.2618639474724032,0.11408590374266822,-0.2165181759897015},
{-0.24656346570695442,0.1333979736597008,-0.22716174822517968},
{-0.271916463995688,-0.44013608075683475,0.27131651221168535},
{-0.2980871072722341,-0.3743475596260701,0.251032366769775},
{-0.268852411873353,-0.456640882519561,0.26989210806181824},
{-0.24017464764776142,-0.500213608511377,0.2932708222280398},
{-0.233758351472933,-0.5203876205099207,0.2932852306027788},
{-0.22256690721557368,-0.5623473469044037,0.2992128234339694},
{-0.2525311601833962,-0.5123091639410997,0.28083282832530554},
{-0.27294158979222294,-0.466959543886101,0.26521375914221246},
{-0.2949912211622367,-0.40710702560676243,0.25297137151609195},
{-0.32187057119201673,-0.31625637326029205,0.240636379113086},
{-0.3011974421284672,-0.3579677458927302,0.2571804102842502},
{-0.2936890884649821,-0.37659489849224304,0.2594848323221326},
{-0.2827710835429115,-0.40271058659992603,0.26681273708125},
{-0.26118855357850534,-0.44889977867755804,0.2804451408411964},
{-0.23422235277254672,-0.49908207726048576,0.29512769753849233},
{-0.20433485876910176,-0.5685552092907028,0.3199052649467155},
{-0.21052815023226681,-0.5654906705855902,0.31260009677717104},
{-0.20811793149970417,-0.5782231586216207,0.3093949069643079},
{-0.20613933081425423,-0.5912784093379945,0.30834216068949066},
{-0.20977464067921608,-0.6024346963960571,0.3031238015658084},
{-0.2278083269632113,-0.5665800539937855,0.2950083848916348},
{-0.23229558802662548,-0.566581026096933,0.2867046351847245},
{-0.25527257180228613,-0.5267845033068105,0.27024923751004654},
{-0.26821292630107446,-0.5074255833301083,0.26047457781373057},
{-0.2762528408393115,-0.4965473156474096,0.2511420954357654},
{-0.28476567134110825,-0.44726991866825716,0.2537729274000079},
{-0.29453431249717227,-0.4240451484563232,0.24714941389359427},
{0.3119139221000065,-0.6244755735257046,0.13348301621778433},
{0.31513424803695955,-0.6193053807849701,0.1456893138505497},
{0.308414684365128,-0.6301915920908752,0.13774954399743597},
{0.3039782042702857,-0.622094006869409,0.12633071365859885},
{0.29936530817112794,-0.6381693770202983,0.13030653053917096},
{0.2983381351147403,-0.6514856252140808,0.13997090380539545},
{0.3079564179428804,-0.6248446986205319,0.1518278126932468},
{0.3063484233487471,-0.61106416546425,0.15466642931484578},
{0.3267669782525159,-0.6203171128062261,0.1471829806152768},
{0.32143654041676417,-0.6320107965451491,0.1386086282019344},
{0.31499078048610074,-0.6253730170266433,0.12756909126308807},
{0.3165857053393375,-0.6179976343248398,0.12081480491675473},
{0.29657955908704253,-0.6087159945350997,0.12390639571197035},
{0.2879688946371125,-0.6294578794449831,0.12378032933865533},
{0.28511984198358165,-0.6607478123167932,0.1250859424839003},
{0.2902379969273031,-0.668966818002215,0.12995725334707717},
{0.2898095788525184,-0.6681872284622088,0.14337443559498697},
{0.28963717450009907,-0.6453528198148453,0.15051844606120404},
{0.28693937047223805,-0.642012694648257,0.15778868969876247},
{0.292380247724806,-0.6216825703210825,0.17028434366064782},
{0.3039779609788969,-0.6010421666053493,0.16112948418227196},
{0.3156853434041406,-0.5980045386901007,0.1554819771096386},
{0.3273824310976915,-0.609747665826161,0.1447654355184463},
{0.33898136080872643,-0.6225388380824728,0.1366595327062242},
{0.3446857885046741,-0.6278020818113733,0.13979601766832847},
{0.33324832140800836,-0.6343377310045563,0.14498741606897944},
{0.33434921388002514,-0.6389604766865339,0.14129765780368053},
{0.3260052212276249,-0.6375267700938697,0.13300932894615355},
{0.32075579729953557,-0.6289875961279802,0.12379386016454202},
{0.3355681642952741,-0.6396851110576771,0.12881618273644688},
{0.34303230160805437,-0.6356320220697546,0.1279633242417236},
{0.34487744474904486,-0.6264662909722439,0.12620591898743416},
{0.32209454694441986,-0.6002207521946216,0.12481143861598448},
{0.30538848583311506,-0.6008528210979683,0.12077412532165412},
{0.30569864304477556,-0.5903217950339966,0.11944155676541696},
{0.28515289242818825,-0.5900698747689289,0.13032090810408337},
{0.2801830889240347,-0.6240364155703537,0.12834405082985206},
{0.27328609464842774,-0.6632833834846217,0.12695204799341872},
{0.2681578075214084,-0.6922199576899383,0.11887472607614034},
{0.2833712568389429,-0.6963320549325247,0.12587914890482602},
{0.2832005746495858,-0.7005660581594366,0.13484328599529735},
{0.27853847738227183,-0.6988008367708783,0.1404138513694096},
{0.2736332746475018,-0.6808420651113,0.14842000577462205},
{0.2731320285172419,-0.6567579472177304,0.159672465175001},
{0.2772084809153462,-0.6360004990958169,0.16547255844473893},
{0.2846978886603296,-0.631244013268902,0.17541030092733662},
{0.2872870572398381,-0.6223071821840006,0.18027828857887926},
{0.29505584105496063,-0.6093542232789373,0.16946440918400152},
{0.29386783432962815,-0.5975256636811267,0.1635264610638727},
{0.30266176518944204,-0.5868613819301799,0.1633175821264704},
{0.3141989923796033,-0.5891477897812112,0.1595916531248227},
{0.3203624758668024,-0.5840014279100957,0.15080339552272207},
{0.31776813973569895,-0.5930839969113489,0.14832350939792324},
{0.3300691712106039,-0.604360893816207,0.13981294713680403},
{0.3335168162973427,-0.6006728789621267,0.14124634988083415},
{0.3483165788868061,-0.615154863688698,0.1342846124731971},
{0.3493579775837892,-0.6285571924129959,0.1324950640705721},
{0.34366526293396277,-0.6358447108015687,0.13941129855164455},
{0.34801071698992725,0.16078071800833543,-0.18865238243180155},
{0.36629820718804007,0.10234942302987647,-0.16929905603222675},
{0.339935868358034,0.1299262140404577,-0.18351295064684006},
{0.3726249774438205,0.05706407970987854,-0.15280327198700416},
{0.39199261128939217,0.06360978034336562,-0.14995351070746307},
{0.41212127228568857,0.051175170209510824,-0.1411105210421397},
{0.42742702253147424,0.03902790101715766,-0.12870130139257088},
{0.4446075815315699,0.026728734067961807,-0.10727227023357923},
{0.43655044323789366,0.04341137121183955,-0.11517629537587655},
{0.4292214240129819,0.05012898961496838,-0.11765616131492694},
{0.42224856213315115,0.05051335388744328,-0.11003279031936597},
{0.434900076633016,0.03760489499597039,-0.07184535640342264},
{0.443780939012002,0.04680693919247643,-0.03475507634640754},
{0.44113136298674205,0.05477297070428148,-0.03987812474050856},
{0.4191808223933028,0.05997663885274691,-0.07454016125403184},
{0.4214509785920422,0.08229326605467298,-0.09437983988875774},
{0.42379254346942097,0.10209636917567388,-0.09738330289360542},
{0.42373341410026666,0.12900534444727635,-0.11164090709039762},
{0.40826336461125495,0.14640102509307437,-0.1329963803197476},
{0.4074665916873062,0.19156535272649297,-0.14375280151295838},
{0.39569193334980984,0.24739234087653805,-0.16012594863728136},
{0.3534057162859733,0.3310589023596964,-0.19506280242902485},
{0.3165598484580224,0.36394157152465184,-0.2195446178131031},
{0.3209004398734339,0.3144278982354553,-0.21216143385074016},
{0.3315143868670896,0.2555169983738557,-0.1945114839562033},
{0.33445689634857073,0.2196825385327783,-0.18486339315209716},
{0.3231887526216713,0.25998427979596767,-0.1998603025095009},
{0.32443007415820607,0.25375753204841206,-0.20674159121043117},
{0.3274203654310073,0.22131847763957635,-0.20379833273144302},
{-0.0795187800870007,-0.8949641869205849,0.23776888624717174},
{-0.07885287030763574,-0.8946561768351114,0.22635901731822422},
{-0.06231909137185201,-0.8662685094368845,0.19617960233320245},
{-0.06483045557769651,-0.88247064927506,0.22958365981811518},
{-0.05232173824936146,-0.8601036065728492,0.20455294718861766},
{-0.03970953602574389,-0.8290435458167956,0.17851449506641953},
{-0.047090437936127924,-0.83583873486387,0.17326383449563784},
{-0.09912227377875434,-0.9134139907217239,0.26387269982274614},
{-0.08924217648159839,-0.9076649015261982,0.26696627519575356},
{-0.07620226055957523,-0.8952469074505147,0.26219582720538054},
{-0.0662743814710991,-0.8762595454825282,0.24277372583613127},
{-0.05318730951595667,-0.8543671621550956,0.2121164387551094},
{-0.034148456890980235,-0.8110988786833223,0.17836944665273727},
{-0.028485763761089893,-0.7902483795732426,0.15999733461003446},
{-0.03789531107688231,-0.8062890578594566,0.16011782334233932},
{-0.039488252414735144,-0.8379688678378755,0.16488488650142502},
{-0.02878717310683074,-0.8184773413053711,0.155941996504775},
{-0.017863966636115256,-0.7942016086013353,0.15107876100337297},
{-0.013665074924964259,-0.8166018844822962,0.13963282226681875},
{0.016074731643794783,-0.8249854316399249,0.14726194832549439},
{0.0029060391461295646,-0.8519309643643194,0.14816411422915507},
{0.003237545442761094,-0.8730089048010831,0.14516303208021286},
{-0.019567086038462907,-0.8730056623324426,0.1409716940886013},
{-0.026460308766339223,-0.9076963509222329,0.14718271713813955},
{-0.036273576362523416,-0.9358380964098956,0.16032183963918858},
{-0.01034381387147616,-0.9321740739114214,0.15744866289148304},
{-0.019166745277319288,-0.9517126119895828,0.16795735820566574},
{0.00484323248712802,-0.9482235064380019,0.1694709748642763},
{0.027747482761608638,-0.9525400247548138,0.18734176003372557},
{-0.006555905060516067,-0.9809035372490398,0.20446985521127597},
{0.023680467732093414,-0.9761439715018795,0.2165610547689718},
{0.003545350483526936,-0.9888897523844467,0.21195841196760243},
{-0.008516813468681845,-0.998521552227172,0.20344339184330634},
{0.014239857736709728,-0.9959143280269079,0.19213928029995006},
{0.04798800042674169,-0.9970669331991472,0.2099623442353244},
{0.07068310403705153,-0.9985110142040903,0.2170516821331562},
{0.09607052115165277,-0.9990878039041914,0.21867850259370852},
{0.033079354847905675,-0.9984698384645417,0.12358057329713004},
{-0.15052049278985277,-0.9988462591138104,-0.033774950957542293},
{-0.3321029703563057,-0.9991746950518668,0.04631174984914963},
{-0.35043135263108127,-0.9984301214109184,0.0683338244853499},
{-0.3582201575214107,-0.9984513578806614,0.11939814571983311},
{-0.3391835136422743,-0.9991163359283758,0.16174847272064413},
{-0.33073726955006055,-0.9986763673558651,0.17936296156725026},
{-0.3026823142813311,-0.9921544975919968,0.17262428836611404},
{-0.3001160023434783,-0.997368135375365,0.1840118063595242},
{-0.3097873970629286,-0.9991315740436155,0.23173200989886367},
{-0.202592393093457,-0.9993666338967155,0.2794119694303053},
{-0.1302239968571342,-0.9989117523057552,0.2447213222744195},
{-0.1223230516350823,-0.9954020583531964,0.2617584126612485},
{-0.12264042365819028,-0.9851078748626323,0.27465787508337397},
{-0.11816343607831284,-0.9801369165211877,0.28703558371725507},
{-0.11287736545517536,-0.9751004649877985,0.29936891557685175},
{-0.10796037955536844,-0.9675545424592847,0.30040551112811914},
{-0.09398930568291784,-0.976705522024333,0.30272679251556156},
{0.4579902950204449,-0.4871137781008268,-0.004877927007822712},
{0.442027875818438,-0.495038066547312,-0.017086098727967507},
{0.4394211775100406,-0.48927179396784387,-0.024637483095039957},
{0.4316726580615137,-0.4974418417764982,-0.031736365664649865},
{0.4354039968437372,-0.5146456643204412,-0.03830445229313207},
{-0.027770917353113597,-0.7118538171217589,0.2685239350325958},
{-0.01641050669501271,-0.6897385310738129,0.2594132812808468},
{-0.027913293811150038,-0.6895313541137247,0.2592486165693338},
{-0.04387083018685543,-0.7319599040768774,0.2798344305844911},
{-0.044456817151380355,-0.7109690173361843,0.2627664974364878},
{-0.02809213423009132,-0.6858268039444668,0.25016681887615166},
{-0.015012313208262,-0.6655806523307096,0.2529841374083544},
{-0.0102550390747511,-0.6528249825562332,0.27079956263156435},
{-0.016178100736625785,-0.6987246440698641,0.2789988914619102},
{-0.010756697419241788,-0.7200107346322715,0.2723843956730002},
{-0.01267528587464604,-0.7165838787415874,0.26241161710559635},
{-0.019975548907325003,-0.7538315375173443,0.27704047440006224},
{-0.04535618361045788,-0.7747828697528092,0.29546290207671555},
{-0.08368764496617663,-0.7740220848310657,0.31704774171570393},
{-0.07537716915541204,-0.7592155536414354,0.3027344121043853},
{-0.0634560239040567,-0.7397485060473148,0.28387732576946284},
{-0.07474772864899085,-0.7455460665368302,0.2767564768559433},
{-0.05431765405732251,-0.7236196394134874,0.2538025526418303},
{-0.04158394956434791,-0.7088797371297526,0.24952165898375214},
{-0.036799057077370356,-0.7014758224037647,0.24335886393681488},
{-0.014702388663912342,-0.6873143299920437,0.23247350361956684},
{-0.010393030975749628,-0.65298822789091,0.23787328481317213},
{-0.011110149874034565,-0.6364642974755386,0.258321506392668},
{-0.008306621395224582,-0.61087919813946,0.2614852569888454},
{-0.004942286079428919,-0.6051179507489401,0.2697749021696508},
{0.0030816965912675498,-0.6353107191377441,0.27708165120201866},
{-0.004309725281265396,-0.666059040756906,0.28411520312807875},
{-0.013562522823740134,-0.6935019280117471,0.2861803900501622},
{-0.009938186569062805,-0.7147607837499078,0.29137650022945705},
{-0.00806965027047177,-0.7327952604653146,0.28416582154825554},
{-0.00015902545084974458,-0.7467250969785637,0.26521955457682395},
{-0.015096339042069891,-0.7788664349712113,0.2848250445328553},
{-0.09598717207162062,-0.7702192948738905,0.3112345170854164},
{-0.09527409775987383,-0.7674269408004414,0.2958927788374254},
{-0.10380459929079844,-0.7790463771070529,0.29264321118786984},
{-0.09146739282991348,-0.7567952430970718,0.27739780676818254},
{-0.07591069442220741,-0.7431375901530783,0.26562102149024763},
{-0.06815467224971598,-0.7432713313604233,0.2510196008775125},
{-0.0568145110845015,-0.7432611184341319,0.2352640951584568},
{-0.039397482416140016,-0.7165089843029188,0.2394747147894385},
{-0.016579667516383748,-0.7243984193987413,0.22973034965186614},
{0.006239348966607265,-0.6723808665667321,0.21769278893975502},
{0.003749282850159089,-0.6542257800045299,0.21838913457810263},
{0.013966790244155,-0.6195036420187048,0.20771172252901404},
{0.0017042753020464958,-0.5850094308799334,0.22809246527636534},
{-0.008379763923411993,-0.6057351055714297,0.24359834128159483},
{-0.011527886500682864,-0.568439138050078,0.26171857449313457},
{-0.009983688433219576,-0.5539775781136818,0.269666814923729},
{-0.005724884358357267,-0.5449561251841903,0.27704576306614775},
{0.0024484569145125303,-0.5791916070862302,0.27700876152689036},
{0.017203755612250935,-0.6148103790182416,0.2729357343315702},
{0.01653327641688886,-0.658022247572819,0.28153079519797336},
{0.0016315991708882238,-0.6769640566810737,0.290684997045914},
{-0.006255598494083381,-0.6948391785992094,0.2928973805702744},
{-0.006087166484471094,-0.7086368951394338,0.2904435128127782},
{0.004271650710118594,-0.732334217971456,0.2900322993700922},
{-0.003320060532661045,-0.7352784698017478,0.29148183158951585},
{0.003282039081904803,-0.7610799879834665,0.2863450335135189},
{0.0017869699388666125,-0.7551969950322008,0.27935863549576245},
{-0.0011974355946591394,-0.7668582562095337,0.277816072473921},
{0.001946288614272303,-0.7775105423138814,0.2849397983877939},
{0.010761699235218171,-0.7700884721008036,0.2842944164521618},
{0.021373923003403687,-0.7634320494500223,0.2582757920469489},
{0.02397013428429431,-0.7577041967242398,0.24148938422008726},
{0.03470872296238992,-0.7408375654211276,0.24065802036020534},
{0.04723252435683185,-0.7018742901399367,0.22942420409210176},
{0.042120808666855664,-0.7060030841836881,0.2191002529970685},
{0.03554595875024574,-0.6771498356854316,0.21109226487597346},
{0.021796717753642354,-0.6883338430881107,0.21475425180108096},
{0.023753402028349822,-0.6647671815431883,0.20702921687722625},
{0.019253821283954014,-0.6556504072600374,0.20323550519479996},
{0.018960968570726516,-0.6486939192093968,0.19616753550527993},
{0.01932258669195817,-0.6417779577671318,0.1953362428267214},
{0.019428282457896424,-0.6248456717860872,0.19682028311426888},
{0.01331117732129852,-0.6118346777919151,0.20080881170430503},
{0.011430815361358206,-0.5912305861127696,0.20666086096565436},
{0.0065125428856915996,-0.5500386150976811,0.21776121968929862},
{-0.006219608367062585,-0.5323562437039622,0.24178369561923985},
{-0.011267872812907493,-0.547700981129205,0.2564065354358617},
{-0.0118787424307846,-0.5085846745020366,0.25580344370557234},
{-0.008720880761105953,-0.5075384121020927,0.2728280114915277},
{-0.002137357347123351,-0.5199116639352047,0.2798233454213864},
{0.0086026528326239,-0.5506948389050292,0.2779218287971044},
{0.02429449695080166,-0.5862246118722675,0.26828032385902145},
{0.03289391581404756,-0.6014069156424013,0.256920750378276},
{0.039383551062508564,-0.614485996165986,0.2555087668381326},
{0.029341844538705305,-0.6452827880167299,0.26925521582700745},
{0.023154085033014533,-0.6728041372756703,0.27810864152426273},
{0.0043995104278192546,-0.6853750012113441,0.29186860646531493},
{-0.003459698103359588,-0.6938767274266955,0.2844444496832954},
{0.0008540738892595666,-0.6934602656894209,0.2734713876012118},
{0.013368551592748273,-0.7046552976979595,0.2718825014739753},
{0.01911033248493889,-0.7388972634748728,0.2762755556495244},
{0.007294362419694184,-0.7584735744003624,0.29010079067688105},
{0.26216717353550173,-0.6920936735230219,-0.10548418051687936},
{0.27452844884535527,-0.6852790317889198,-0.08489134611090395},
{0.2699190172580707,-0.6910363886420342,-0.09129933319423901},
{0.26189176874576187,-0.6985346504937183,-0.10125869780061542},
{0.2732843926711139,-0.7159983358635276,-0.0884577790150414},
{0.27743807043062496,-0.7384271437686728,-0.08170733221053864},
{0.268145892617803,-0.6814772149973,-0.07721105449202867},
{0.2818783603198792,-0.6746332306218533,-0.07329099808544075},
{0.30336996517414977,-0.687272343635335,-0.09620555902773154},
{0.28210468611836104,-0.694891053847827,-0.11131281537247203},
{0.25324882303448065,-0.6942803829002108,-0.1257533608823576},
{0.25193236376788863,-0.7005245583855054,-0.12266075761249767},
{0.2694698089248237,-0.7589414248034771,-0.10500889219667672},
{0.2789450502276374,-0.7684757954754453,-0.09598900950593055},
{0.2898933295227032,-0.8044935217264063,-0.08669230371101616},
{0.2780426006610911,-0.7710214180835778,-0.07779197695851639},
{0.27106416645228915,-0.7245649061396511,-0.07685129027242799},
{0.26739542261350085,-0.701483766026971,-0.07385090718782572},
{0.2691743628741285,-0.6766785802652813,-0.07053774168186092},
{0.2781156921937035,-0.6668207988442049,-0.06217766948723422},
{0.30228242716832304,-0.6658518637968177,-0.06884638207157837},
{0.315448783431211,-0.6734961875992362,-0.08413440073099099},
{0.309513997036729,-0.6892980769809323,-0.1048040960924939},
{0.2999529588662856,-0.696170268283773,-0.1159858756259924},
{0.27414985982174345,-0.6966450902069464,-0.13460139592237758},
{0.24881224201089633,-0.6923185215122383,-0.13763164860259888},
{0.23663678607689748,-0.7131280063687566,-0.15080929188607567},
{0.23948968889633712,-0.7200001976715974,-0.1411617269738362},
{0.24671641630993835,-0.7248969085807306,-0.1304638285149193},
{0.24886559719359547,-0.7367792897582693,-0.12233664779904942},
{0.25837171950426463,-0.7526152218734677,-0.11819018378857803},
{0.26216170319768056,-0.8040353976668055,-0.12360067511533059},
{0.2756006286838596,-0.8206977693816799,-0.1184658424937849},
{0.2863433108192527,-0.8377187302931153,-0.11250912056521983},
{0.29261364597208883,-0.8178922839476811,-0.09929835565581316},
{0.30671371952582194,-0.8630697429416494,-0.09582924993128307},
{0.29012068904398575,-0.8321612559080559,-0.08339239068009144},
{0.2888035817086287,-0.8233729186253694,-0.07835338618073115},
{0.2814888284958093,-0.7907142857700622,-0.0763859110298828},
{0.27224714798867355,-0.732961585720237,-0.07044388007653454},
{0.27714209742565526,-0.6901031175624697,-0.05637234810865613},
{0.28106687517255735,-0.6631759049983759,-0.049927116194674895},
{0.3003955207762642,-0.6608911183816647,-0.05363243660959599},
{0.3190111228780509,-0.660783476284616,-0.07195439556674348},
{0.31424458561083185,-0.6778817645486083,-0.09351761414436087},
{0.30847109928232397,-0.6907155722928013,-0.12154789924130054},
{0.307466134798827,-0.6955137204420424,-0.12348068252747367},
{0.30299780053057385,-0.6983198539448062,-0.13660098978618182},
{0.2914625387948638,-0.698300725292161,-0.1520520317370387},
{0.2680087474558302,-0.6979850956178638,-0.1547643843774697},
{0.2701360841724758,-0.7234573672443658,-0.1795594995755147},
{0.2574136061428449,-0.731504859937522,-0.18130893570881043},
{0.23585995242275415,-0.7419746084437446,-0.19108047511338414},
{0.22286411580082818,-0.7292794056098572,-0.1691037737899955},
{0.21668523058758632,-0.7440799384449838,-0.171564672562388},
{0.22683616857052424,-0.7793962120632478,-0.15494475253884382},
{0.24078637037911116,-0.7854654695392412,-0.13884721418656057},
{0.25002959137757347,-0.7917500101469243,-0.13174895949996723},
{0.25287471312220194,-0.7942893103661709,-0.12532591597312823},
{0.2556827111506748,-0.8353971450570389,-0.1337184202910152},
{0.26409519510986396,-0.8398796645943905,-0.1350039974873439},
{0.27863254190749026,-0.8662534328076322,-0.13803854548234695},
{0.2880713479344101,-0.868774576477381,-0.12663293255909208},
{0.3032267812861766,-0.875373773593806,-0.12262243868755413},
{0.3007532982932575,-0.851142134001169,-0.10997291089029676},
{0.30990071135528285,-0.8646106039861767,-0.10838667865777325},
{0.32065289779095724,-0.882087744750918,-0.111303484244664},
{0.3432372496365542,-0.9125690705381678,-0.12453420860962447},
{0.3324390248207782,-0.9152990124023253,-0.11517832138757297},
{0.3048485765577808,-0.8949032333972184,-0.0947733429932268},
{0.29691397319385415,-0.8724099054656834,-0.0879410716639014},
{0.2989559178202465,-0.8387098749758011,-0.07124420994183606},
{0.28497758982725907,-0.7588461045122256,-0.05936745315125108},
{0.2907018356785217,-0.733892424948321,-0.03411752648116146},
{0.28970331576080893,-0.6734206440293949,-0.01668545305578206},
{0.2872294269281057,-0.665090268257914,-0.030882675304610217},
{0.31383809350846,-0.6608690712947616,-0.04217008473476261},
{0.32215744573648925,-0.6587246723086638,-0.047207650733946206},
{0.32277666800457994,-0.6544399284846769,-0.05134714428676663},
{0.31064366376191116,-0.6382449205901396,-0.08029579488167604},
{0.3136178659308157,-0.6611616807166001,-0.08709594856045334},
{0.3062519269720482,-0.6738721216657272,-0.09968389495132755},
{0.29976426142766976,-0.676131942761277,-0.11425244679119187},
{0.30095873290453495,-0.679112346204577,-0.13798152286788276},
{0.311234395439722,-0.6915144530338482,-0.15118332105536073},
{0.30060841242797026,-0.6947595819435675,-0.16510509283091307},
{0.28016397939473014,-0.6953530684448335,-0.16885049576774472},
{0.27772423634908716,-0.7110893031485972,-0.17398435522373512},
{0.2863783469040589,-0.7404852986134522,-0.21411385362049237},
{0.27787428976596923,-0.755736499530159,-0.2247916300754603},
{0.2609533917342555,-0.7606964343281518,-0.22153407949360954},
{0.22504523160088963,-0.75914341508863,-0.21714213978385472},
{0.21049135055049376,-0.7404883795961055,-0.18698807491162206},
{0.18818353814617927,-0.7503408107314434,-0.2049394288398608},
{0.19757596157286678,-0.7528651968698328,-0.1922512782690258},
{0.20400567170872264,-0.7814488561987092,-0.17895584051945404},
{0.1888031450058977,-0.8186422078743681,-0.18823932464915488},
{0.22730951162202415,-0.8292980594193311,-0.1585520573338957},
{0.2412767958858113,-0.8214065175688184,-0.14344539912475307},
{0.2521560558574059,-0.8404366765106737,-0.14275833361863854},
{0.2556474115887314,-0.8731128167843059,-0.15009422237245898},
{0.2635644044807753,-0.8813734858544616,-0.15698485388768318},
{0.26531953511994044,-0.909599529152332,-0.1782829400966896},
{0.2813872867444139,-0.8914638952771574,-0.14960424307703957},
{0.2934764794137539,-0.8940991649188285,-0.1399545915958584},
{0.3057880276635844,-0.8933122798243808,-0.1356533719515315},
{0.3318867140590608,-0.8959543584377154,-0.12644220910877976},
{-0.35084976069946644,-0.917127943200113,-0.12043088579315281},
{-0.3581251612645417,-0.9046726649846942,-0.09404591236472383},
{-0.33850050228436823,-0.8850439932902169,-0.09192171612556876},
{-0.3276025173750967,-0.9075334296219385,-0.11105635650123376},
{-0.3156209859261461,-0.873843773544335,-0.09131537236496853},
{-0.3296704814311993,-0.8714711236768009,-0.0864292887211734},
{-0.3355469076397825,-0.8593830252875068,-0.07187058433931344},
{-0.35174189534857137,-0.8924255358325112,-0.0786535748198967},
{-0.3800992480023064,-0.9288546975693909,-0.0766405468093166},
{-0.38205612563523544,-0.9243214374349642,-0.1072936278178129},
{-0.37100362944590504,-0.9228335873530049,-0.11979893906670436},
{-0.3651426442724536,-0.9375311792456484,-0.15614017593310808},
{-0.346814200378025,-0.9440104145840431,-0.15063546921922796},
{-0.3399955257438706,-0.9212818642510131,-0.12342108676129013},
{-0.329840596294785,-0.9345499662475961,-0.12969884814472832},
{-0.311232248313535,-0.9049323652621653,-0.1053088885400284},
{-0.3142435933219359,-0.895882381370897,-0.10184758407605782},
{-0.3036892835283684,-0.8717431446976615,-0.08744381699978916},
{-0.30224451408316344,-0.8469736229037943,-0.07803431218030918},
{-0.31658801607632736,-0.8490129741927188,-0.08225046376876512},
{-0.32622236888502354,-0.8523963839783614,-0.07700211393497332},
{-0.3194050520080522,-0.837581909165525,-0.08051075397898327},
{-0.32231400533880855,-0.8226165108238089,-0.06418247127413022},
{-0.33089265306693266,-0.8422597715023532,-0.05435755756351683},
{-0.3434267375065817,-0.876527027897218,-0.06182754130648344},
{-0.3504169453187501,-0.9005020460702216,-0.05464858612253202},
{-0.35666184961580344,-0.91506297938367,-0.050900650405477865},
{-0.3727762685658029,-0.9339804721019361,-0.05556206879420033},
{-0.4158245677513209,-0.9686734299948119,-0.0681164080387748},
{-0.41211559902797523,-0.945935315866663,-0.10584596012409837},
{-0.399440781675174,-0.9329591752231536,-0.11278441486454739},
{-0.39515547052541583,-0.9301613093779786,-0.1351561789070723},
{-0.37977044765837054,-0.9311140331445708,-0.14360319324494936},
{-0.38850180376049753,-0.9350953065516625,-0.15712003359520485},
{-0.37035458007850774,-0.9487286431056675,-0.1847273210220139},
{-0.35398609373725365,-0.9569435957052885,-0.1804067092479045},
{-0.33840965897963426,-0.9525208950397607,-0.15338968710187714},
{-0.32276990046682086,-0.938690594451959,-0.13159789254603307},
{0.25806443929295764,-0.6604848695706819,-0.20829744814121737},
{0.27275064323627035,-0.7011869420333443,-0.21718396359216824},
{0.2583470588941452,-0.6879966529096879,-0.20848344918880782},
{0.2522862507474763,-0.6770752642187378,-0.20994475501159798},
{0.256591624406346,-0.7101758109152585,-0.21319120130700342},
{0.2643128495357889,-0.7108106357044682,-0.20831363817385615},
{0.2699287850354892,-0.7196338274002251,-0.21069779816761947},
{0.2772463748771652,-0.7225119379698071,-0.22243602229162981},
{0.28553735762940513,-0.7117704924771066,-0.22422519566429738},
{0.27899879000196426,-0.6881694631018912,-0.22296316567470173},
{0.27522432914908146,-0.6620132473234247,-0.21043963731906726},
{0.26766365402569786,-0.6403998565369113,-0.2043026385961999},
{0.25821917367865704,-0.5990893824297177,-0.20407910799266987},
{0.25104671299365694,-0.6368326130156137,-0.204520089039825},
{0.24821056859503526,-0.6504917257079401,-0.20825969654204518},
{0.2332975310223068,-0.6340326393533408,-0.23519509602073407},
{0.23671609906965382,-0.6835608219460183,-0.24753446660633102},
{0.24517385222568905,-0.732268076710746,-0.26154456802973547},
{0.25649383082970945,-0.7325456095033323,-0.22846572526239495},
{0.2653912699577776,-0.7381523657995417,-0.22137942585090392},
{0.27019849638176757,-0.7313703081130168,-0.21579029914991774},
{0.277215593735644,-0.7399501722980851,-0.23197298736347347},
{0.2878228730578749,-0.7352667981895312,-0.23143832638272765},
{0.2901293827271068,-0.729102705942656,-0.2234888493094407},
{0.28582105132489,-0.7045967749636656,-0.20543893155890208},
{0.2843358753233921,-0.6849698870519038,-0.22167460948686968},
{0.28482820466489045,-0.6732916039766157,-0.21765394306053704},
{0.2957993214782713,-0.6724603006739791,-0.20275081456546598},
{0.2824424234368068,-0.6567365481995919,-0.20110032578369008},
{0.27780326461655,-0.6352210721042058,-0.19437991112320152},
{0.2675353842185819,-0.5940059193506714,-0.19849255444340305},
{0.2569474970261333,-0.4946687789040894,-0.20077837478291471},
{0.25149697523545295,-0.5450514465378495,-0.20422474391787188},
{0.2428075651185379,-0.5729978492260359,-0.20434721829037636},
{0.24540319844957897,-0.6239237482843568,-0.20567018267999798},
{0.22873598321749233,-0.5524057542558972,-0.22540898781784188},
{0.21776833197839246,-0.540478145315417,-0.25367476941749195},
{0.2113246798648268,-0.593597886756973,-0.2754020428845386},
{0.22133922274570678,-0.6737691817856519,-0.281702004341605},
{0.2233377616385542,-0.7164131763664817,-0.3046462223979525},
{0.2249946939237066,-0.7276689993499919,-0.3213525268006461},
{0.24378294366930145,-0.7483653314001435,-0.29769346127391444},
{0.2512617124624611,-0.7478987771345589,-0.26576353606129954},
{0.26545880828475965,-0.752799703677888,-0.2484915876788548},
{0.27042705217424584,-0.744589776267215,-0.22792413313308724},
{0.28008452510173487,-0.7496560559623187,-0.2415902768403099},
{0.2892121200084453,-0.7471887328098904,-0.23677922043615962},
{0.288518145664333,-0.7529225838901763,-0.23486595145666736},
{0.2824336288249437,-0.7042715814942496,-0.18038770277215754},
{0.285070479329438,-0.6914915953297847,-0.1903471268733714},
{0.2909489326121254,-0.6818341818971331,-0.2125961541286624},
{0.2975508038090119,-0.6780965610975203,-0.20736802722756165},
{0.30844548569239755,-0.6820844809278805,-0.18082649525922107},
{0.2954665487915285,-0.6671550705883696,-0.17879818769949665},
{0.2886941770770207,-0.6512701805964038,-0.18151295200565967},
{0.28142286996924293,-0.6086975139512193,-0.18027159009762808},
{0.26440196961505263,-0.49861098332632275,-0.1919329330803625},
{0.25933901313158314,-0.4418059818541416,-0.1979156840003082},
{0.24588786889316464,-0.431786089749931,-0.2065549420940758},
{0.2409924541215615,-0.48639254768431145,-0.20582037845952675},
{0.23594277029888044,-0.5118888116664196,-0.2049214348387582},
{0.2368838022675076,-0.5509506497075025,-0.20591646899644156},
{0.22102951068291934,-0.43912272750125847,-0.2278045166375956},
{0.20871502381308235,-0.44519879394891543,-0.25917092481089776},
{0.201133497873991,-0.5562369126264538,-0.28363665215348716},
{0.199015888563267,-0.6577348258883238,-0.3017880914696728},
{0.21247890733379424,-0.6923123606093395,-0.3027800053356139},
{0.19405469693683328,-0.6960405801622287,-0.32339098566700897},
{0.2106817085325189,-0.7220098822847949,-0.3385898236899124},
{0.2237969406691118,-0.736935239538505,-0.3415062340610973},
{0.23886211822766396,-0.7483076203454175,-0.32469775896158404},
{0.2560575913086168,-0.7639399420035508,-0.2991149693000875},
{0.26300913597571074,-0.7623549867852165,-0.27531182852522895},
{0.2807975686036551,-0.7603650799558371,-0.2515817994687312},
{-0.25266634095332563,0.7004798257046042,-0.11384825480173179},
{-0.2677238797997135,0.6890337254820627,-0.10159551294908088},
{-0.25556303303552996,0.7061386187354187,-0.09125574578895848},
{-0.24227083881700653,0.7041119536581707,-0.09766841490351863},
{-0.24842739221805155,0.7112419817751814,-0.05721358067469865},
{-0.25825086742848824,0.7080180075298036,-0.06469077922911286},
{-0.2644305823822307,0.6983430866788272,-0.056431275620326266},
{-0.2789035504537063,0.6835334755689515,-0.07371546400316681},
{-0.29012194693483445,0.6695270415773122,-0.10523663737199482},
{-0.2616201737504337,0.6771065213189585,-0.1345830778868925},
{-0.24403016384221127,0.6864379296026262,-0.1495098747031871},
{-0.23532109811837645,0.6830549256567677,-0.16124163407566475},
{-0.2304708707382179,0.6856050061280772,-0.1456679148324114},
{-0.2307641292912293,0.6941626203063501,-0.12680724180871747},
{-0.2275294151652858,0.7034900976811155,-0.12386330338872996},
{-0.24465507955376356,0.723638495027325,-0.08389682828341695},
{-0.2543992821429407,0.7480439169153129,-0.036980160956153946},
{-0.24704667640220704,0.71054895828606,-0.03306170559813789},
{-0.25620673424200435,0.7063676409249261,-0.03420000969882716},
{-0.26737363900373473,0.690557564628635,-0.037474455752103494},
{-0.2807238906219307,0.6788753910159413,-0.03510521515123642},
{-0.29440626579569673,0.6744796011402778,-0.06153457704043579},
{-0.3104358397954656,0.6656591238964792,-0.0744215667948548},
{-0.31152976180983133,0.6581997281097616,-0.10250500415460155},
{-0.30808142615801515,0.64807790860012,-0.1279227445129573},
{-0.28587718257920036,0.6505608353360752,-0.1444698364810263},
{-0.26580617208038493,0.6337915503359108,-0.1823626147776861},
{-0.24117574071719355,0.6389383987898041,-0.19732643331898647},
{-0.21789113144768718,0.6561868817709172,-0.20438095823765254},
{-0.22272332339283848,0.6718330646637664,-0.1778042478218591},
{-0.21807907882638816,0.6665833974442884,-0.17415872503060573},
{-0.2067830925779739,0.660098205185295,-0.1825393962502887},
{-0.215587175806834,0.6759012292185336,-0.15271024118458632},
{-0.20309262568666475,0.6798934857975801,-0.1600830093007658},
{-0.19010057761099447,0.6961409362665064,-0.16735796365456027},
{-0.18958076059219034,0.7024528328129268,-0.15961619155804388},
{-0.22326989927718974,0.7101837237286382,-0.12195737033517576},
{-0.226395593363153,0.726942389962727,-0.11814729544763743},
{-0.24562571657846471,0.7484910992368635,-0.07924045526939108},
{-0.2548623920824007,0.7605610410766599,-0.043888892713261914},
{-0.26007781258607643,0.7855083982516784,-0.02291203400531126},
{-0.25473543859856307,0.7650201355841768,0.00024181304835345355},
{-0.2515770999077772,0.7494290300370889,0.005641685609030521},
{-0.24814367833681825,0.7300138173200891,-0.010751770503016204},
{-0.24234559195543615,0.7046742744262878,-0.0038450594455656326},
{-0.24993007670028228,0.7026904870659023,-0.01096129857159127},
{-0.25733599618981035,0.6888250887736415,-0.00806118022419503},
{-0.26803675252574,0.6707962056353617,-0.00010782854961968513},
{-0.28792303792874663,0.6696146222276572,-0.019941894483877672},
{-0.30630659954043343,0.6674148218614155,-0.03505566020127895},
{-0.31403428835900116,0.6574476974283843,-0.05274549925950468},
{-0.3189093590834228,0.6463233452867262,-0.08476563989383701},
{-0.3173397843429751,0.6337926042444597,-0.11084603800124697},
{-0.3045944486092808,0.6237865319410606,-0.15526593435636368},
{-0.29388431014996813,0.6302371141407803,-0.16803412779412147},
{-0.27826625344151934,0.6041624806581551,-0.2042140242230543},
{-0.25390334592692254,0.5953222266929464,-0.22602746002601767},
{-0.2126710905324394,0.6085589600364884,-0.2414204254538614},
{-0.20834371122057108,0.6245369010166206,-0.23569368825628098},
{-0.19363145703772153,0.6236591534940983,-0.24926714431880884},
{-0.1972948017200121,0.6334989409140721,-0.23627890709995822},
{-0.18949152896010618,0.6262372794068145,-0.23586850427443237},
{-0.19669309749432445,0.6354518865756911,-0.21496357588735626},
{-0.18603171399188728,0.6330913949031514,-0.21948358354674288},
{-0.16510096059573034,0.628779416254918,-0.23130148400698108},
{-0.16987981754393106,0.6354408630322395,-0.2129232928667811},
{-0.1647405376832866,0.6588940477364128,-0.2010796364539698},
{-0.18499368950211342,0.6806028820534837,-0.1739029556620371},
{-0.16851409655193747,0.6923833347631838,-0.18495646432601182},
{-0.14950896368848868,0.6959440933472002,-0.19401378414321802},
{-0.15792922978489682,0.7013352021058405,-0.18372817322128454},
{-0.19075096561223412,0.71453035387005,-0.15923944687439273},
{-0.2026244501867598,0.7228220250625519,-0.1451866292201131},
{-0.20917029212048577,0.7324963785877573,-0.13045979561486704},
{-0.23088794123516848,0.7421648155638605,-0.10402724225260207},
{-0.24984970979897697,0.7931302701898176,-0.08623798838341946},
{-0.2562082131136779,0.7844840214526505,-0.06171764053042753},
{-0.26057032466171837,0.8230391026541556,-0.05564425984971788},
{-0.2629134512785799,0.8339248677487796,-0.017353925362788333},
{-0.2588381537177666,0.8113907688550723,0.016509330276022534},
{-0.25083937454758126,0.7946153038286687,0.03703825978973114},
{-0.25235245362783926,0.7667723881605807,0.014276768440099098},
{-0.26361228932565317,0.7530462439097982,0.011331843043254757},
{-0.25555719722942166,0.7348486440366128,0.004376466271184894},
{-0.24445165076843403,0.7193351080710627,0.0012158094065543993},
{-0.24610955621914168,0.6995970115592292,0.003471260818775628},
{-0.2539537826753635,0.6720827963687425,0.013322659293720767},
{-0.2665744140425571,0.6208602337403745,0.04810403713911256},
{-0.28663997332689195,0.6583526797751532,0.003726861264502239},
{-0.3007559744985345,0.6589152842061559,-0.0076297640345664285},
{-0.30330548764407256,0.6471038676207909,-0.0016236890135280584},
{-0.3083196679225104,0.6414870609466851,-0.016023778033953467},
{-0.3168771004290476,0.647105935066392,-0.05236088213397066},
{-0.34224487043599156,0.6322717239036423,-0.06129919315295335},
{-0.33594596394988196,0.6258580210662814,-0.09909954728205567},
{-0.3158325814403223,0.6074315615519839,-0.1436376418182358},
{-0.3036895470055056,0.6061902814493535,-0.15497950496076426},
{-0.2970256078194583,0.6010227638514886,-0.1742047644731151},
{-0.2916166665457027,0.614103383803992,-0.1833278409594035},
{-0.27460389254886225,0.5826767509190819,-0.21208988280945432},
{-0.2618862782221922,0.5821610369192456,-0.22826535621156244},
{-0.2312496910949687,0.561896405784016,-0.2564004956474536},
{-0.21601348606452073,0.5806571370424787,-0.2540374913804398},
{-0.1791011933129743,0.5628169502804072,-0.28148753182707537},
{-0.17394296647142035,0.599635421798124,-0.2743288909428868},
{0.11546052505610238,0.6285336972642456,-0.005186884761064009},
{0.12083114740491441,0.6533782760451763,-0.02145509999066522},
{0.1127441097682003,0.649602437249362,-0.008250049772876371},
{0.1032646538935986,0.6134533208995426,0.014889070183705957},
{0.09267961395408474,0.6047888348698841,0.02625607308227691},
{0.09346217186151623,0.6145663311950568,0.02706573195057082},
{0.10553164836669127,0.649127534583195,0.0037543999373829493},
{0.11287702017263679,0.6685363027344104,-0.019150602521828188},
{0.12947292659241869,0.6662574337292091,-0.019789515456296366},
{0.13552496031297273,0.6538798865813155,-0.02107190117955948},
{0.13665047408601988,0.6424761785552666,-0.016257704297918594},
{0.1362044466017604,0.6226494485469467,-0.002451790219021008},
{0.1364483021291313,0.5953922181195651,0.014020876894632148},
{0.10406379811178255,0.5983634211112179,0.019546000961832843},
{0.08542858077457295,0.5808018210502817,0.043457407467125536},
{0.06768965210101113,0.5739652533437667,0.05418417792072649},
{0.058844371884446266,0.5814685414468068,0.06374272899448323},
{0.0747879673448498,0.6042212052499335,0.04832159594833442},
{0.09324458967932255,0.6255382586255979,0.025870802575938833},
{0.10805155539374761,0.6517187504225561,0.018627555783277232},
{0.11906227770793162,0.6812402598086643,0.0077013108262210086},
{0.11150836056063666,0.6751754601958476,-0.013118549504984126},
{0.11668883740898589,0.6847208947827643,-0.011417812020949871},
{0.1256381103517672,0.6851254012449366,-0.015072984662354688},
{0.14632215246835598,0.6748387566002025,-0.0160313211294148},
{0.14602763814931133,0.6595313043771027,-0.023663294441025138},
{0.16302746351974573,0.6535269717048752,-0.025945537653435626},
{0.18607298003609984,0.6320681527556661,-0.01641473773412188},
{0.20833248369481963,0.6058943488158808,-0.005939497641921861},
{0.1772993337286302,0.5771799463945033,0.015334828878789201},
{0.17682315404827373,0.5502626216599107,0.03490826705355677},
{0.1356834035643418,0.5402255058002609,0.056059693176230954},
{0.11871075139850099,0.5654335767898025,0.04222247525116886},
{0.08074914713659169,0.5643797372973473,0.051971716840595775},
{0.0541422940863717,0.550815823781782,0.06899049875360998},
{0.037936668488166674,0.5551581989799089,0.07348916051524886},
{0.022284144083090856,0.5607373156744956,0.08268175884390319},
{0.03361829626972382,0.5754097805599907,0.07907743835239364},
{0.05227426880593789,0.5864111706839588,0.06750925684823784},
{0.04437812672960165,0.5854308880587374,0.08217202301282196},
{0.07361226011475039,0.6115704070360393,0.07325260797917381},
{0.09477292706056858,0.628814756188358,0.04702720501680187},
{0.1131692651885961,0.6607050249045947,0.033147518401884686},
{0.11520573841475933,0.6713527309688673,0.036411032278781154},
{0.12236727648504978,0.696255832484092,0.014774636113518563},
{-0.24940019761709586,0.001126288799545581,0.2759323076217605},
{-0.24153868578578166,-0.013719148826547848,0.28022090161165614},
{-0.22010248231165494,0.017916322624267712,0.3020805999627693},
{-0.22581817578003527,-0.05594424981862269,0.30934973869620386},
{-0.23843990248968253,-0.042290973994812436,0.2899613560260745},
{-0.25080152201966693,-0.0318570520048077,0.2870726670619139},
{-0.2593262483017285,0.006844900702184034,0.27518939452422125},
{0.22408940772830363,-0.8073936793828916,0.12873921022809917},
{0.22933455652735954,-0.7876046807879955,0.12455320658610888},
{0.21502341547613257,-0.8028814942322208,0.139629377940694},
{0.19596932367350858,-0.8090222421922547,0.14754768821842415},
{0.20436373288860157,-0.8072649644269025,0.14965253269929357},
{0.2361178699799175,-0.7790723147313618,0.144549372579423},
{0.23261506574201585,-0.7860112964260852,0.13751122042753927},
{0.24157155349624476,-0.7726096157705524,0.12645979408287497},
{0.24311668966980549,-0.7619399837338671,0.11468605791535894},
{0.23934176348230132,-0.7857243602619598,0.11314908315860571},
{0.25027364876242864,-0.802957037802062,0.10065063612658405},
{0.24584888065129987,-0.821253322612038,0.1075753571212544},
{0.043122981142624216,-0.42698469913204934,-0.3179663611291406},
{0.07016297254553516,-0.43214192306062926,-0.301383909041883},
{0.036429729062651114,-0.4846211653928545,-0.30720319152151143},
{0.017929453453613447,-0.45599924875868764,-0.32211639164263506},
{-0.005504264752230575,-0.5089064640168246,-0.31581795049114686},
{-0.02258365915570383,-0.5275613369609539,-0.3185814888775259},
{0.03168937271112974,-0.5096627092699898,-0.3080856401985993},
{0.05310184411956427,-0.49958478207667073,-0.3007580807220207},
{0.09206905455928864,-0.4121674694957579,-0.29369763925425263},
{0.09522948088142406,-0.36577174852680255,-0.2954225762634162},
{0.07660011953607127,-0.3516945539252891,-0.31254663960332213},
{0.049567225017340795,-0.30598131948478097,-0.33602255983466056},
{0.01855272774509694,-0.3777711730481137,-0.3375838871032679},
{-0.005273447093521752,-0.4674659766912964,-0.32662286210168817},
{-0.033850373944096984,-0.500490331749211,-0.3237919256261582},
{-0.07220384945207686,-0.5004262972431911,-0.32483652535787716},
{-0.07870767421926769,-0.5224047621635468,-0.3251146669101394},
{-0.028541702719586372,-0.5374486225093622,-0.3166392427249762},
{0.012913476643566464,-0.5342863316615176,-0.3090870785505701},
{0.026251292778329292,-0.5366006224055607,-0.30445412100470876},
{0.05796180209286794,-0.5114415486018754,-0.29820929745064906},
{0.06987773942113151,-0.4930137918876398,-0.2938773997183586},
{0.09092807956536142,-0.44198316916652813,-0.28927471548308453},
{0.11479780674980294,-0.31813474851762497,-0.28548069995202413},
{0.09979954069762392,-0.2851715095314722,-0.30527902011305796},
{0.08840027991067378,-0.22170319675626032,-0.3223354835063288},
{0.05208107419505618,-0.22549131486155932,-0.3434185298750344},
{0.02439874890452417,-0.27568706883941907,-0.35012074867693616},
{0.0032498608741115434,-0.3623267371490284,-0.34408638492310223},
{-0.03753086163883315,-0.46483216679795847,-0.33230244645337276},
{-0.08052905235992386,-0.4761651545856301,-0.33087417195184854},
{-0.11121805231411758,-0.4770963178480966,-0.3248189775680554},
{-0.12177267658039728,-0.4955083498643148,-0.3243099907344812},
{-0.09631560800967708,-0.5195971689124501,-0.32858144171193115},
{-0.07519831067553813,-0.5349448247719509,-0.31960051645322324},
{-0.053973338309708116,-0.540546393330817,-0.31736784837651866},
{-0.04641301803053351,-0.5460896017037843,-0.31726762401080943},
{-0.01713577001158035,-0.5483792520234563,-0.3120577545879485},
{0.008124476887989807,-0.5433737643657317,-0.30759813418856496},
{0.01420951218239107,-0.543423207762869,-0.3249304283971082},
{0.03859216773338725,-0.5325110588326551,-0.3256499557739017},
{0.04869641289301175,-0.5231011885448881,-0.3120168221397888},
{0.07262377038918555,-0.49891137488538023,-0.30635912232661233},
{0.0980802567604251,-0.4595968059620695,-0.2986213416962436},
{0.09165359573498814,-0.4553407556482544,-0.2895292088998716},
{0.11509117685563452,-0.3850700390145205,-0.28018286634959827},
{0.10913024991695174,-0.4706618247522736,-0.3002473919111326},
{0.0922395742002506,-0.5192288533723751,-0.3087400409141429},
{0.09764368258087187,-0.5406285833239267,-0.30854417009798407},
{0.11522857593307431,-0.5610892063898058,-0.2965218071296158},
{0.15023631144918245,-0.5174372077767302,-0.273845275470258},
{0.15968032646160196,-0.4531360512075551,-0.2664698725827061},
{0.16353831487902903,-0.3963684974859121,-0.26299063467487815},
{0.1657585612836021,-0.34114164226040145,-0.25959289938230595},
{0.16724395932833264,-0.42292609943480874,-0.27202444871925596},
{0.17654614820996198,-0.3851326137722074,-0.27521877647465487},
{0.18452229171931644,-0.274852685616537,-0.2638722737972138},
{0.19002837743853584,-0.19420502923576582,-0.2526208268714791},
{0.19550339835334837,-0.1797613836198864,-0.23988292905487274},
{0.2173749701741623,-0.19447810522758305,-0.21274089869371057},
{0.20953392562933582,-0.1533005617105742,-0.2103964759393191},
{0.21198781357258054,-0.12471179644975601,-0.20226152477271622},
{0.21379822341499127,-0.11569755726930425,-0.2068467610845027},
{0.2115108636465608,-0.08523989980327816,-0.21309821087608244},
{0.18819662913523205,-0.009285100583186011,-0.23678021378746336},
{0.16167191508254689,0.0037220028735804335,-0.26998657736441284},
{0.12311722059748521,0.04981376578045516,-0.3125615940556762},
{0.11303856352999961,0.05230054161991123,-0.31504496594050435},
{0.10741955767172419,0.04793206731148803,-0.30421598016895557},
{0.2988406571967817,-0.9496077685711211,0.11529926164319772},
{0.30860869065557767,-0.9523283081261473,0.1034286136975286},
{0.299528958283181,-0.9443728943180099,0.09903764184129002},
{0.29094433238630185,-0.9417029328116638,0.12711903725322313},
{0.2896479951236587,-0.9296597392133361,0.10743096633800743},
{0.3027788903386158,-0.9454288819990597,0.061229347276204875},
{0.3043186369173491,-0.9551736720997568,0.0860991848028529},
{0.3069332374150482,-0.9588156485737356,0.09441550491898827},
{0.3240623259439022,-0.9609483748852087,0.09901489569004679},
{0.326965969360417,-0.952263464065375,0.11038295993402136},
{0.312386191057209,-0.9510372595295895,0.11333646746116664},
{0.32417442484172015,-0.9517362803108063,0.12558835301312155},
{0.3026444808767574,-0.9562408458726533,0.1332277026221668},
{0.29130608224610216,-0.9544059167203621,0.12983876619108906},
{0.29187845445452326,-0.9486106265963398,0.13843638533550232},
{0.28243826942226413,-0.9434329768151768,0.14827824020107716},
{0.2741334466834643,-0.9198509146066195,0.1271305367553743},
{0.286659588562315,-0.9228262917985636,0.08012812568087226},
{0.3032515842589429,-0.9497416712644534,0.038508936049418345},
{0.3097420460606812,-0.9635282027752389,0.05319532378928235},
{0.3069713332343513,-0.9540038824811671,0.06633953522374825},
{0.32043753391627383,-0.9538090262644684,0.07708159160094041},
{0.31795095993430195,-0.956913767543574,0.08841872596630011},
{0.33018398562278783,-0.956808719846401,0.08969120792394485},
{0.33301625966975246,-0.9718115659386551,0.10108957628833339},
{0.34243520823226836,-0.9810546243887224,0.10987886123878772},
{0.3302779694050126,-0.9610333207641814,0.10700748314750695},
{0.3358675008833748,-0.9653363836860611,0.11564275402475815},
{-0.044818508578751054,-0.8352079620980533,-0.26064821880884254},
{-0.06097240341580066,-0.8391939366597106,-0.27996975159225174},
{-0.013765030501497222,-0.842007689751298,-0.2645931185596935},
{-0.005971565890506656,-0.8400255639967298,-0.25470834560575933},
{0.006655732085703806,-0.8388021153468072,-0.25083122853568696},
{0.013409628528370394,-0.8480156696695423,-0.26846717589526886},
{-0.008945728750322186,-0.855189711217366,-0.28429088925822776},
{-0.002011395089773868,-0.8659710363120849,-0.30337681504851416},
{-0.0347699431501171,-0.8581728694841211,-0.3118103336199623},
{-0.1028025989250954,-0.8288259933820206,-0.29157086986337827},
{-0.08808007657074816,-0.8226212119783747,-0.2618862362570836},
{-0.08767179112399061,-0.8414103127126266,-0.2554987961408221},
{-0.04003797196380046,-0.8527065008185251,-0.25395854385597055},
{-0.0010023626467668037,-0.846881219984393,-0.24984494755596215},
{0.0060698141776865736,-0.8571781593608201,-0.24813346487932283},
{0.01142810090939991,-0.8497525226447193,-0.2570736191758584},
{0.02216882183997304,-0.8507545283224613,-0.25920796778405975},
{0.058288191833479504,-0.8497815401892735,-0.2618160631587293},
{0.029683893108049975,-0.8585334028869771,-0.2825728823352183},
{0.041075027537650285,-0.8684941252505366,-0.29929106127002053},
{0.040915769419489816,-0.8740131797819105,-0.31988177829722775},
{-0.00463319658761901,-0.8692943031915211,-0.33681937419251395},
{-0.03883235795380861,-0.8595485399252689,-0.3406990846000541},
{-0.07875038088847246,-0.8413522765611102,-0.3218423435476704},
{-0.10630826528964102,-0.8329053440286346,-0.32510133369210564},
{-0.11961550107795908,-0.8244078323850713,-0.2899752151359749},
{-0.09682619482941528,-0.8214206210325155,-0.27048577623482006},
{-0.10522016420767423,-0.8148578985010733,-0.2571540668201574},
{-0.10281392100514211,-0.8310326430914227,-0.2525852234609016},
{-0.1038849608800647,-0.8465343034624563,-0.24511253482764708},
{-0.09835575397964452,-0.8662647803854663,-0.24986652824583622},
{-0.08939395206154284,-0.8751565451934135,-0.25370139548206266},
{-0.0389363432431704,-0.8795022436031747,-0.24936745048991954},
{-0.0028605935895866593,-0.8606763431871497,-0.24685437262027526},
{-0.0009462218307860537,-0.8788030602735628,-0.24525389456140792},
{0.013227805930702403,-0.8737445616532701,-0.2526555803558074},
{0.039467022319438945,-0.8752891517492158,-0.2528774281053641},
{0.06684655500925958,-0.8552762783306588,-0.25795748722978246},
{0.08600476171499814,-0.8477402436316462,-0.2572074825601017},
{0.0877582307483462,-0.8504495981572332,-0.26726032311776887},
{0.05899848901120716,-0.8612458373328097,-0.28397035657188074},
{0.09988142684209964,-0.864098983443638,-0.2890026944622241},
{0.09678102124927238,-0.8760776570155758,-0.31831173715975075},
{0.11004134110863646,-0.8784984541427171,-0.33780407430941534},
{0.05460602234717782,-0.8773203968665391,-0.3497210655462279},
{0.0074516933300845896,-0.8694593312465057,-0.36458068737901206},
{-0.03934884219930829,-0.8560375487727722,-0.3643765489052645},
{-0.09236169585336158,-0.8332256737950897,-0.35356288305435685},
{-0.11799681653642691,-0.8345985883503747,-0.34074646161399813},
{-0.13518406339369565,-0.8400615530613428,-0.3289117825471936},
{-0.13449932774791157,-0.8295519249531016,-0.2974406507111007},
{-0.12894589688698246,-0.8135911662945041,-0.26657457499734055},
{-0.14223446404523754,0.8055736749355356,0.18957189426779983},
{-0.175633040568251,0.7976862456656609,0.17141782124264965},
{-0.15909719524927413,0.7870914485728066,0.19687602977695154},
{-0.1425976428435443,0.7894796616523707,0.2065964121205881},
{-0.15599693201909348,0.7716418663702826,0.20739919402311843},
{-0.17381711895411447,0.767217705956422,0.19256731272069919},
{-0.19752386428101637,0.7808994330614232,0.1482118556489784},
{-0.1884914685510669,0.8148237845862474,0.15135505821567455},
{-0.16546840389899223,0.8258695323611593,0.17330683438939865},
{-0.14160425966759993,0.8158256277155942,0.18399061026127786},
{-0.1202747442483072,0.8226738064770807,0.19265507504278},
{-0.10422380204022659,0.8153473614662963,0.19570960374149307},
{-0.10874814538589171,0.8030906472708382,0.20174970131028547},
{-0.12005502343918902,0.7939487257947903,0.21148786517346232},
{-0.1260417467019417,0.7820109442995152,0.217410899212734},
{-0.1420587874767589,0.7680572769166475,0.21528072586723168},
{-0.15995731317657302,0.7490314940325676,0.2069194680254874},
{-0.17040161064126444,0.7314275835805402,0.19712126218484616},
{-0.18545617049614904,0.7380423024750905,0.18217499249577537},
{-0.19425117545026024,0.7575262094187712,0.16661162747905245},
{-0.21066602526840614,0.7637963628998715,0.12610191988677086},
{-0.21378288543341728,0.7884256999830171,0.11305017511617492},
{-0.21205774444195388,0.8409464027800845,0.1238006287647088},
{-0.19502480806966765,0.8818417314732818,0.14123350218317024},
{-0.16884563365839558,0.8547338054652753,0.16804706579644932},
{-0.15335438807113758,0.8593623253337083,0.18205303445346727},
{-0.13430164446402643,0.8402873827153767,0.18353883833798176},
{-0.1174190143616813,0.8365643519622386,0.19404833470765434},
{-0.10416805643995179,0.8371793989676304,0.19098598456263335},
{-0.10710247037390955,0.8308676851553536,0.1956019616444443},
{-0.08902001957136854,0.8345122751525487,0.19261615904464643},
{-0.08492800396123425,0.818938089512266,0.19233628470524372},
{-0.08360677235875315,0.8091894492456603,0.19657361220619757},
{-0.09316307431517296,0.7957503208395894,0.2122916298032183},
{-0.10164941474059884,0.777280071000119,0.22095222423306332},
{-0.11891042138499347,0.7632152375134919,0.22057296695493808},
{-0.13213179443639758,0.7493341548947103,0.21354447102765267},
{-0.14820887718867898,0.7313686571312777,0.20820441733879955},
{-0.15494781280454462,0.6974510327727158,0.20164926340060618},
{-0.17861760758776418,0.7032404870906298,0.1835764581985854},
{-0.19999939347138038,0.7301290779435539,0.15651189649021888},
{-0.22225445945267172,0.7440696957712735,0.09704323040279005},
{-0.2303206962068454,0.7886480343153516,0.08179456651593715},
{-0.23284487942534277,0.819536743565127,0.08912249783524978},
{-0.2368266181670559,0.8542696628654227,0.08479676313067357},
{-0.2142851440383215,0.8830754536067412,0.1168835528566497},
{-0.20740456396340146,0.9057639416036092,0.11646119369361373},
{-0.18635393909387807,0.9107002697000316,0.1374421819807275},
{-0.1799219394691885,0.8863031154696326,0.15400248605233974},
{-0.15557025735552754,0.8767824838554821,0.17293728326903884},
{-0.1408608504256127,0.8708719724170841,0.18438374895986756},
{-0.1224581399755322,0.8613164874522714,0.1847739692241992},
{-0.10662616426702361,0.8530958201610322,0.18679360328655092},
{-0.10957160705647213,0.8446631525782412,0.19425147983009816},
{-0.0899271447946931,0.8452981388534383,0.19174144044679464},
{-0.07655707502118235,0.8347182367181006,0.18471144439967946},
{-0.4355009808656215,-0.23979643843494225,-0.09841698001061483},
{-0.44167593410755307,-0.26812347634418526,-0.08372962123001115},
{-0.4377986544890855,-0.23809524942758814,-0.08779776559902992},
{-0.4322028409933341,-0.19599959326566868,-0.0975873595619515},
{-0.4388359597287711,-0.21687594925706355,-0.07556642170210949},
{-0.43818488328726957,-0.25439125193349793,-0.05736730258575364},
{-0.43461614070855,-0.25214877677028585,-0.07696620667576178},
{-0.44055964097190153,-0.25622099441085366,-0.07904634805019925},
{-0.443246826233687,-0.2747450445818961,-0.05647242161245609},
{-0.4477291428511466,-0.2881862797426572,-0.0612208522633445},
{-0.44258423966595617,-0.2909240037440335,-0.07666599785084781},
{-0.4331819889670128,-0.26375005758980746,-0.10122726859032916},
{-0.42436892945455373,-0.2248743225874649,-0.11279073725343333},
{-0.42327379098324386,-0.1916915858978344,-0.11344465988546175},
{-0.42261448725565043,-0.11734897672032299,-0.11930806841113112},
{-0.4480700610185799,-0.15608999841217314,-0.0797925131780494},
{-0.4457597426173439,-0.18180673220090657,-0.06985702937445888},
{-0.4451179877419801,-0.20823659023455388,-0.03482686111741189},
{-0.44031428638710857,-0.24810038999933667,-0.039232164855027014},
{-0.43995051051561185,-0.2671478948735296,-0.025520134692019854},
{-0.4335104249050693,-0.2807249790587336,-0.037236594329604744},
{-0.43172907297870966,-0.26851108308530064,-0.058991356536364926},
{0.3201202022646626,-0.6511122844850576,-0.017386419105701666},
{0.3194047269112619,-0.6440512342576136,0.023389824295909842},
{0.3035746104164234,-0.6533487623561741,-0.008161830615436613},
{0.2923449471004548,-0.6547829544692082,-0.0005486682965358907},
{0.29143437223896645,-0.6451159772414379,0.041016599888855455},
{0.30790052997995887,-0.6464778671908633,0.030131934386316127},
{0.31883498947421324,-0.6403063179035596,0.05390424727370976},
{0.322332281940389,-0.6377602097750572,0.014745853361090633},
{-0.27475852600581946,-0.9596991511593724,0.27717091258152143},
{-0.28625129355388695,-0.9688228959001741,0.27904560022134073},
{-0.27748974382175845,-0.9691180997218883,0.28477947148737515},
{-0.27066954994443365,-0.953232884633132,0.29047390830026387},
{-0.2780873652142266,-0.9718328024083982,0.3011317061763374},
{-0.2831500773438996,-0.9800806641523868,0.2931998788840221},
{-0.2934197818960799,-0.9807689854245345,0.29361471938697636},
{-0.3002375247985837,-0.9767058460587156,0.2713447403872357},
{-0.294747832031895,-0.9589832710285954,0.26503872001842066},
{-0.2862099956374401,-0.9543550146372998,0.2688387742754813},
{-0.28098965087355826,-0.9523156633483751,0.2653587066271526},
{-0.26851445251167466,-0.9568537861233549,0.266110494017141},
{-0.2696769667615713,-0.9517507078088858,0.27929144032650355},
{-0.2640129456219167,-0.9473378960352672,0.2845171757476207},
{-0.25746564393985777,-0.9462971464694571,0.2939707556175667},
{-0.25648858359752863,-0.9497698792542555,0.3008363196204797},
{-0.26540047040942477,-0.9603287882112387,0.3013413149879062},
{-0.2602911302633149,-0.9641980434635062,0.30897514220114747},
{-0.2757823142309198,-0.9772521595283374,0.31836586258811306},
{-0.28334325283144074,-0.9783650476469532,0.30896233487498037},
{-0.27930667897294714,-0.9896785827475972,0.29550894151922497},
{-0.27717885673593157,-0.9991756682174221,0.28450848312690735},
{-0.2943025142360535,-0.9864759257149565,0.2917421809981597},
{-0.3026790112554453,-0.9857765808993569,0.28266911523477983},
{-0.3025636284550822,-0.98767262612341,0.26466152912348867},
{-0.3003420657272308,-0.9724783267066772,0.25342078276923097},
{-0.29648940634738596,-0.9578617901556007,0.25792844949947974},
{-0.2887230341979954,-0.9546456787904356,0.2520840793217916},
{-0.27085463944612187,-0.9535094453225709,0.2505654077268141},
{-0.26276378245332555,-0.9578963194718807,0.2568873546511308},
{-0.26038213505403635,-0.9542014956461368,0.26756837463714706},
{-0.24564752037397916,-0.9484493265303657,0.2769693886933978},
{-0.24597095130883592,-0.9514548559184068,0.29313349433192337},
{-0.24964723399345434,-0.9635017785681524,0.3093699626913027},
{-0.30242782086454406,0.029406476649119044,0.1775066535825691},
{-0.2997708281703523,0.07250746170041482,0.16165254366971665},
{-0.30133000725036485,0.0627719931658556,0.15379719274130113},
{-0.30270442192547964,0.043527036612680446,0.16024545464236062},
{-0.3092168086372229,0.06401789368005778,0.15267970439686165},
{-0.3060892903970473,0.08641014519481878,0.1469734121752049},
{-0.2982242938681116,0.09673585882441124,0.14288901615389432},
{-0.2967042634535432,0.017741324934380544,0.1941687023254687},
{-0.2978370515328755,-0.0372725175249335,0.21614453141204418},
{-0.3013735957180533,-0.03748212633650223,0.20472238317361185},
{-0.3030635168281591,-0.010925091713376925,0.18326607681887674},
{-0.3064642927318877,0.017326159334635934,0.17324966091302524},
{-0.3070457421526499,0.036649415343515325,0.16151140704159614},
{-0.32397977154491314,0.06960446635266518,0.1578962595520801},
{-0.34029924051456234,0.10550433864269385,0.14818044662444058},
{-0.33039098091114033,0.11460182066239649,0.1473767839858345},
{-0.3220082241849235,0.1386275794324751,0.1415456864689349},
{-0.305325709217944,0.12788386357428144,0.13669032340941578},
{-0.3010426663088633,0.15334081634255017,0.1314181735158318},
{-0.28694632180654833,0.18707975326889587,0.12523760226139324},
{-0.2814895179984789,0.2510556345632536,0.11874463742685117},
{-0.2794889318457787,0.28749014658587185,0.11500040526342774},
{-0.2763899254440391,0.2852845518474265,0.11817508803598505},
{-0.27874204853024803,0.3275838992094049,0.1152068534117574},
{-0.27565080195516334,0.348647412148089,0.1300839422913697},
{-0.2605423610257131,0.3205943405284093,0.13701349086713527},
{-0.2569099292235124,0.26480139511186657,0.1420808340324583},
{-0.2469980436222299,0.34491903110921246,0.1490134317186428},
{-0.24341975637173224,0.3917668777832651,0.143875286509541},
{-0.2290757677957907,0.3528181118055553,0.16228967919591628},
{-0.22593469323194093,0.32672519959653423,0.17646421160111517},
{-0.23306887536349427,0.29879354950321785,0.20017549659659542},
{-0.2249875216085714,0.2799465751658448,0.2075974956283499},
{-0.2296434388496462,0.29263496902806857,0.21172985617512421},
{-0.22559162687591292,0.2937408059460398,0.21375663280519233},
{-0.21238711317406886,0.30684817520242014,0.2058407235691161},
{-0.19736055732668645,0.31471507662856174,0.2004957764298834},
{-0.19375232079998392,0.2920385640925445,0.20236505216431117},
{-0.18936415051314412,0.2679147280829437,0.20348233865126644},
{-0.17608989823774052,0.23509560684123043,0.20167154315482017},
{-0.18647852128348044,0.2328631820559146,0.18972305258880579},
{-0.18394609059314276,0.21626297819653534,0.18744720294660464},
{-0.17246768998590947,0.19849971294723662,0.19704055106340995},
{-0.14816678884082035,0.1950478925977989,0.2191183086178242},
{-0.13379339706628907,0.1836361198340532,0.23633355842018725},
{-0.15809687136309744,0.1523979804054592,0.2596451804707076},
{-0.15486828839263386,0.1257962853451638,0.286550995079071},
{-0.17885557525104404,0.08783250314724102,0.30069765521533637},
{-0.1979713493887932,0.04985445493722605,0.3089736420813177},
{-0.21900270324302462,0.06097880707888422,0.2809512506744172},
{-0.19912440183472113,-0.0029528185556795842,0.33115121922406493},
{-0.21726516182758596,-0.03437722250900122,0.3205771922039246},
{-0.20553494294643493,-0.07867823118038494,0.33596991540278737},
{-0.21683453500696126,-0.09857786998717374,0.31751934135598514},
{-0.23413422498217876,-0.09983463255884018,0.2944723661537059},
{-0.23746326711047794,-0.06989289201254235,0.29184092649219534},
{-0.24697088954097696,-0.07166265306967899,0.2934869765341349},
{-0.2561477663588374,-0.048449635212955366,0.2740784718600566},
{-0.25290701350689354,-0.03304783480175158,0.273879298018012},
{-0.2591606518585649,-0.0169415825805988,0.27556652486190797},
{-0.27245916952838206,-0.006831962699856194,0.2722060333375741},
{-0.27027081873112446,-0.003210817918244449,0.2759961381454806},
{0.012112789809240182,0.7680427676131665,0.19310003905682027},
{0.0316519504583791,0.7768772261437639,0.17028219653446086},
{0.03451426089898908,0.7827335515965543,0.16894358818981559},
{0.016262648212669234,0.7794246325346118,0.19248493043177556},
{0.03117551792496343,0.7923071336160273,0.16951622387537396},
{0.03947586792687713,0.7850185815046542,0.15758794561797254},
{0.026347060343269446,0.7810962759807294,0.15283854180152884},
{0.018175380676216796,0.7703789843296224,0.17494348318461472},
{0.0004130577826467501,0.7614693466350629,0.1940939183772126},
{-0.004625942467082354,0.7623269519678879,0.2046546621124863},
{-0.0022773348883215467,0.7688375559593235,0.20662488252511946},
{0.0043268778553813845,0.7849467659238234,0.1951989446780237},
{0.012469159635883336,0.7987089608588719,0.18099227337412047},
{0.018499662599730436,0.8103304040538393,0.1721297906502725},
{0.030926019949705858,0.8079878447627489,0.1694085817783252},
{0.042279686443019625,0.7966119590724664,0.16638481509779285},
{0.05668841283895214,0.7818954403846619,0.1559432331474675},
{0.045341504321727115,0.7821386871523568,0.14969514693901884},
{0.031897908490808896,0.7872325862633349,0.1436149466625675},
{0.025948106024319777,0.7783898802608973,0.14244098284368675},
{0.019497838297312362,0.7729876268443148,0.1537171307510377},
{0.014834712619236818,0.7621934944234285,0.16264840969271638},
{0.010191455029643371,0.763598304586029,0.17786479656784948},
{-0.006070035158511281,0.7529152585883163,0.19106109254527195},
{-0.021782901140054364,0.7566773986978096,0.1977276165695245},
{-0.03023222302769791,0.7615620735888466,0.20711116357894718},
{-0.01375757027384518,0.771328465627574,0.20957914542421865},
{-0.009150192320860055,0.7787729877049313,0.19930450598775404},
{-0.004147887636938704,0.7913847851511725,0.19458741318008013},
{-0.0012949497580413835,0.8005911246624602,0.18820849357446645},
{0.0024858685431852086,0.8081009784457752,0.18976425913818087},
{0.015463270264766743,0.8092024180578147,0.18725053213736378},
{0.0198640353962113,0.814357149577669,0.1797752087327368},
{0.017853924757481494,0.8205284959450807,0.1700678451344218},
{0.028690971017095834,0.8221495199086136,0.16843405421621854},
{0.0477684411036108,0.8157653222609929,0.16905189854137775},
{0.06091636884060115,0.8055876360365858,0.16613107174092065},
{0.06536978902799706,0.7945056155341751,0.1616508416924027},
{0.07495076646824585,0.7900886295602653,0.15369315858118007},
{0.07085805179377157,0.779443598638862,0.14929471374839567},
{0.06281840179507951,0.7686278249708565,0.1485565124295002},
{0.04626586392456906,0.7777327247218986,0.14124989619810877},
{0.03689010861403553,0.7745165729852367,0.1378997992718022},
{0.03461040774351793,0.7698173923732641,0.13958377408538736},
{0.029474385225223373,0.763891886111015,0.14621264743920973},
{0.018516831109963557,0.755863076921631,0.15136800684208052},
{0.0033709243690423375,0.746477442280859,0.16537399462243907},
{0.007202225102245785,0.7563359535761017,0.1768001353894268},
{-0.0072578931467503025,0.7462811263158271,0.16628130682953846},
{-0.022592009681101918,0.7497328255507743,0.19216589680285043},
{-0.0447730077770021,0.753192670266412,0.18828292267851351},
{-0.04808490264322438,0.760864269264574,0.2045408198034499},
{-0.044059043167509256,0.7692160026202887,0.20600629876412346},
{-0.02808434678083333,0.7755107157827663,0.20727465220501287},
{-0.018050218411949252,0.7820384213527429,0.20245315976893072},
{-0.02085675987931252,0.7894152425547231,0.20371800726404235},
{-0.003262014819474456,0.7962666032276047,0.20415469299641578},
{0.0001333916751750694,0.8050071789047194,0.19678591634638393},
{0.00970719573788079,0.8151090995160524,0.1960313932562811},
{0.006049150345753775,0.8258344155333596,0.19836888486211068},
{0.0143128579022504,0.8262365910727936,0.17902498095741565},
{-0.002731325119127943,0.834492923394263,0.18353143229312813},
{0.007842934568323124,0.8317565167785728,0.16789575661353418},
{0.021553739775123645,0.8303536115131781,0.1626643373106257},
{0.05538093091836683,0.8243188642301242,0.16309765839746027},
{0.07720433635623293,0.818315443103799,0.15629912595300324},
{0.07990779345605868,0.8040616285156702,0.15623242799060014},
{0.09024543261333468,0.8080288388305618,0.14574967986239654},
{0.09282442863804848,0.7955078645033061,0.13860032973451913},
{0.08990855690762396,0.7849507786381271,0.13280421836925851},
{0.08251796583799953,0.7552151207718718,0.1449096223193935},
{0.07642202067778245,0.7199467511218266,0.14835712716830113},
{0.06397614477149498,0.750173279643655,0.14537188127019646},
{0.05218734791084373,0.7636467344461142,0.13869371644355377},
{0.04576323560174642,0.7480799867229195,0.13720460847074564},
{0.03808215248905163,0.7543573539530597,0.1396566935079343},
{0.03275508779810136,0.7508323804513565,0.14708374853846348},
{0.03075618343696675,0.7367497548211108,0.17377617535067277},
{0.024234627083402818,0.7357312956335927,0.18355749103192748},
{0.02208755932888277,0.7461216100325685,0.16990541041690507},
{0.014142318075540073,0.7446139003613896,0.16084767519824458},
{0.002413291215953394,0.732427157406802,0.18143779408985392},
{-0.00999584237858261,0.7300146279372492,0.18491727422666288},
{-0.017343633287114864,0.7363813585380421,0.17898548700943265},
{-0.02478434663246801,0.7421964264458824,0.16697929495036254},
{-0.17184929852072742,0.0756307653688024,-0.2980779880947845},
{-0.19386651795322934,0.06959182263730103,-0.2876573589513167},
{-0.18470997562088007,0.08227908184798226,-0.29839726501509845},
{-0.11441035405782003,0.08108424596523764,-0.31353044836006966},
{-0.17683194972254465,0.09955885167673495,-0.3025256532190657},
{-0.20539601400174665,0.08260581580872475,-0.28899241991627955},
{-0.19665746433632833,0.07461749285621977,-0.2859674983984561},
{-0.20527185783767662,0.0683404092889653,-0.2742771580569158},
{-0.20000166277446565,0.05956666099034564,-0.27706736394177023},
{-0.1838007075209999,0.05844696390006619,-0.27803198348862723},
{-0.12516598481961916,0.06700607713576107,-0.30271511984093713},
{-0.05886264636121109,0.060594199515020444,-0.3136228916509678},
{-0.06430760113495938,0.08833293866034078,-0.32462375588306935},
{-0.11695414188766223,0.10459343868441519,-0.31688143558412224},
{-0.12626996783595937,0.12518212969992593,-0.3143811236067404},
{-0.15548071125073123,0.13575084680582455,-0.3052325758931724},
{-0.17960746463218227,0.15109736801378273,-0.2893422750582228},
{-0.1972811232194396,0.11251788967929553,-0.28848566307670165},
{-0.22179138988470867,0.0840019110400479,-0.27404558290143743},
{-0.2233752911944938,0.07024480397600848,-0.2731464161750285},
{-0.21269429245663377,0.06983215097073801,-0.273643731396386},
{-0.22036522213787452,0.056359790448324704,-0.2566135700333033},
{-0.2209537652555938,0.04374653431615817,-0.2532231292327646},
{-0.21776766372387898,0.030652783003105148,-0.24653262347698401},
{-0.17117151420925375,0.05271165413385511,-0.2783895378999801},
{-0.16525706230028298,0.04208976457940099,-0.2670619811410406},
{-0.10793867668859614,0.04787476103413816,-0.28819325551234715},
{-0.05225515608940977,0.041712127473188206,-0.30027328916394463},
{-0.015581070042900774,0.03540521680662714,-0.30431786720288967},
{0.02903039968877743,0.030559488723550094,-0.31123232852532484},
{0.015346794246765702,0.0473401202391408,-0.32089261895832993},
{-0.022321707636080428,0.07037668065764438,-0.32638147985970223},
{-0.006439064636635651,0.08201540816529636,-0.3311319269606168},
{-0.04730128020316572,0.11197854772973252,-0.3286436116922419},
{-0.08374093959163044,0.14256783964841344,-0.31805665623144397},
{-0.12047694701502232,0.19241165085298045,-0.2997824185083714},
{-0.1552360259828595,0.18583320468592876,-0.29171995117711275},
{-0.16764178005814734,0.22663683908573518,-0.2778909265410926},
{-0.20065209114720223,0.1780831033121706,-0.2623202872180847},
{-0.220269050857966,0.1249970805697346,-0.25881517330560094},
{-0.24793816298254703,0.08200114321561199,-0.23793689329365955},
{-0.24053435024770903,0.052666992634277196,-0.2565616342274403},
{-0.23244249990360905,0.05447914588790653,-0.2570546328858599},
{-0.22309090905874712,0.060027866032599644,-0.2591930122692979},
{-0.23492852674555806,0.04491705380891419,-0.24131319025900444},
{-0.23666683840666003,0.03428948993433904,-0.23728324263803088},
{-0.24508590823187243,0.010488659896470374,-0.22591568516258234},
{-0.23561068817721492,0.007895215125520796,-0.22441334596289036},
{-0.20943226276344992,0.023279669604386974,-0.24042510763329236},
{-0.3699095863170488,-0.20538603852360104,0.25126450925102467},
{-0.38268693877254906,-0.19890266935641202,0.2326952100688846},
{-0.3809426287569436,-0.2257344808862607,0.2338665603645492},
{-0.3692375974401866,-0.23222660429381609,0.2529281485166907},
{-0.37267158527450905,-0.25739969975579696,0.2340454092827529},
{-0.38013223788966766,-0.2506194258519876,0.21545254270813136},
{-0.3880090282077183,-0.22108296201352534,0.22046066513722826},
{-0.35982870031797476,-0.19492593561789862,0.2580951593460298},
{-0.3607632675350692,-0.22788917354164356,0.26242097904323086},
{-0.36223533236176597,-0.25801896239538447,0.2501514182125168},
{-0.3650021142791934,-0.27596152277416774,0.2323158104281126},
{-0.3720114709297555,-0.29980652772883676,0.2177544723372881},
{-0.3786556939516378,-0.2912073723427281,0.2097894023045524},
{-0.37961506520390625,-0.26767961723426886,0.2020600008845926},
{-0.3877496923361266,-0.2641772188361512,0.19803560646924956},
{-0.38700191659803435,-0.24458599489221208,0.20372984142465417},
{-0.3973414500284382,-0.23715452237000287,0.21395250362135115},
{-0.40546391896566436,-0.23627977296232458,0.21267919511042913},
{-0.4187665502785275,-0.25985129821020797,0.19613848715089915},
{-0.4247858777746059,-0.21772573314358046,0.1832879422340443},
{-0.42564915636514394,-0.19177596445103573,0.17954048247568968},
{0.2546823872644982,0.2625825064644766,0.2638762865115176},
{0.25972690353558425,0.26474481870868327,0.2534110160542203},
{0.23041504333254165,0.290037957754096,0.24419040946843254},
{0.22223644314100513,0.2908979545669044,0.2556013726774259},
{0.1862722548068866,0.3110419758553386,0.24852257174026807},
{0.18223795131388612,0.31634785400971294,0.23693235483569489},
{0.20893176563069712,0.300798046379072,0.23088658294678152},
{0.24467098592351677,0.27635712307165655,0.22893345455101907},
{0.26573891529147303,0.26318839551453355,0.243550923896154},
{0.285427486600768,0.25000807602577974,0.24892213375648584},
{0.2722358205965878,0.23999474960184397,0.2755153178678037},
{0.25141906143378434,0.2343913983226702,0.29595774401268804},
{0.2297552933936674,0.26862250310452696,0.26923851902584267},
{0.202089930506253,0.28990948502708797,0.26400816319315346},
{0.18701263406179564,0.30427021183809905,0.2589650248649988},
{0.1582776846733447,0.31529397308335305,0.26002869269211776},
{0.16682909863962994,0.31999461238125104,0.25464496023091227},
{0.15897938059743077,0.32823355733647813,0.2507468096109888},
{0.15852634228402335,0.33123997914708075,0.23999754160957243},
{0.1576019274359752,0.32846740179504175,0.23241463772754978},
{0.1661253968895958,0.3206757199043589,0.22603248627737366},
{0.18397368876086095,0.3008102863794678,0.21881236491554396},
{0.20567786229486304,0.29470998428481576,0.22258074667092959},
{0.2360729046317055,0.27101963191044465,0.21932874823230147},
{0.23827077991499274,0.2633996255604225,0.2116928132019622},
{0.25281714336771477,0.2668813548145684,0.2163142011267569},
{0.2654879681919607,0.2652392558672795,0.23070986203142416},
{0.27763031312410774,0.2608460593290837,0.23285251866871107},
{0.2866738131405025,0.26674023730978846,0.2481160998236446},
{0.29355242776097135,0.25840451231497685,0.25558177762775136},
{0.2988161984441464,0.24879094976474306,0.2557527838514909},
{0.2979764659979337,0.2368587204126908,0.26021791708500813},
{0.29843515844571356,0.22819423544544018,0.2636788560806916},
{0.28265134380811385,0.2158316023784036,0.2878317500063435},
{0.25656953694794593,0.21061861266380053,0.3103935894304158},
{0.2449085381853423,0.20253164620840972,0.3186804585396098},
{0.23219422688455807,0.2245838709158913,0.3099269331736812},
{0.22900717343544424,0.24968977227102104,0.2876181688519677},
{0.2190114362352348,0.262252206000711,0.270103722699335},
{0.2034403719491023,0.2712482078886713,0.26462225828114605},
{0.1679357461747613,0.2971082477422762,0.2638314019062993},
{0.17085203436904783,0.6574269464790109,-0.22645364916921393},
{0.16053000835696893,0.640215100631276,-0.24149041688048},
{0.10006842124099377,0.6664768506896932,-0.2433327839498593},
{0.10946599097111978,0.6906131274947663,-0.2208476833044162},
{0.057706031661891435,0.6871197669999006,-0.2344503205223013},
{0.06709986277892907,0.6467441034011904,-0.26222002248087867},
{0.10927095095786951,0.628111155367066,-0.2640380519121131},
{0.1792680040882664,0.6192268072280506,-0.24660759972105403},
{0.21963738566958768,0.6250613288853264,-0.2286124958391396},
{0.21253503858810457,0.6559069171268505,-0.20986641412198914},
{0.17912658273485246,0.6746202724337769,-0.20658089990413306},
{0.10875431478805295,0.7045056384343755,-0.20461946347928503},
{0.08159788773863781,0.703386589412861,-0.21387309926152306},
{0.04891088540754131,0.7057100795461435,-0.2112762898450346},
{0.02794848925712794,0.6930476636797253,-0.22644428723157936},
{0.024715659842641947,0.6736072028410863,-0.2461921100869269},
{0.03389714644799631,0.645302373504734,-0.2666034916131527},
{0.07264294047573548,0.6120698693835835,-0.27852084725584464},
{0.11194014221855245,0.5947171493224575,-0.2757857176543439},
{0.1964368914761454,0.5984050026905503,-0.24913301851983616},
{0.24349604893908064,0.5827484443230145,-0.23397784864520688},
{0.2504633990471856,0.6132688390951228,-0.21625851502131951},
{0.24004056115787784,0.6371251108846321,-0.2075637153095769},
{0.22109698845265602,0.6690965571193342,-0.18772707622359958},
{0.17319195888876568,0.6919000836964343,-0.18613557551073906},
{0.11840136337009609,0.7187717737658937,-0.169170542933722},
{0.09592221008358141,0.7156636285321599,-0.18932710700877822},
{0.0671324978220813,0.7195439466369681,-0.18172578310012055},
{0.03323351659579466,0.7196955607309252,-0.18415071405605626},
{0.005912787115930202,0.7093891383023732,-0.19874960188856886},
{-0.02988214371770644,0.6860072018532594,-0.21985060188688016},
{-0.015638535681422323,0.6750885286766755,-0.23638288070283406},
{0.010956322784606308,0.6428844130064493,-0.2663276204263836},
{0.0037538320804077264,0.6159999974162244,-0.27861377712952035},
{0.044250636729819284,0.6119358445133531,-0.2814655049259205},
{0.0704406073292714,0.5730864933466002,-0.2885245896989133},
{0.12584827692743691,0.5539961904361305,-0.2802564232168321},
{0.18864970782013624,0.5667283544377785,-0.25902419460564996},
{0.22744124700342097,0.548750657045447,-0.25042258824472036},
{0.2473700053459139,0.548937206295468,-0.2415818880682306},
{0.27496864052350645,0.5328783714597561,-0.22589562371587865},
{0.2837288930556972,0.571279202733524,-0.20889431841136288},
{0.27277423081450025,0.609818883271394,-0.19725153781791016},
{0.27070004636066153,0.632037189942409,-0.1762877637245654},
{0.24359844167913308,0.6526376333131301,-0.18756097301190988},
{0.23764985566958816,0.6716740742723745,-0.16189870887166977},
{0.18560010444403713,0.6956938761218542,-0.16675051605224395},
{0.1665641288194141,0.7073257957202506,-0.15173287593121526},
{0.12838966371562524,0.7230050078095499,-0.13154520668025524},
{0.08632573105095583,0.7299886903129404,-0.14606350556822995},
{0.06056301837695826,0.7316944986694586,-0.15677609606477141},
{0.044912326625357164,0.735702196283637,-0.1648220886380978},
{0.018569090950209078,0.7259604457316887,-0.18356563651261792},
{-0.00447326171568254,0.7201109696220587,-0.19613427151670332},
{-0.0313654392573781,0.7066339483165766,-0.2061767376620917},
{-0.02889271694845198,0.6933307093064451,-0.20972651307415335},
{-0.07957706909157622,0.6853602188690554,-0.21085642415313213},
{-0.0950885418611564,0.6663412449566392,-0.224231801716069},
{-0.06160679792984671,0.6535213791901557,-0.2413618634104784},
{-0.013578784037702268,0.6373786927555168,-0.26514575335579343},
{-0.0403338440400281,0.6170603622174574,-0.26818860937988204},
{-0.023409870337700242,0.5966274594961948,-0.27933131992852217},
{0.024854538854163093,0.5887575185213046,-0.2874218125154391},
{0.05007231600147032,0.5336510309136083,-0.29655341907404564},
{0.09843264468259083,0.520260211253132,-0.29145998636009673},
{0.15299835184054736,0.5369230302416949,-0.272221028161425},
{0.1845470946920826,0.5481273020109698,-0.2607297798565279},
{0.22822875891847735,0.5062063598760519,-0.2529584834469312},
{0.2537910430468049,0.5167510442548475,-0.2417025797204275},
{0.2835531442434873,0.48431964980633246,-0.22607929490313855},
{0.2998082143012375,0.48680752098824215,-0.21510372022658086},
{0.3020755933659579,0.5430612656072549,-0.200222943729455},
{0.3149680449589355,0.5642106147226577,-0.17306383091309246},
{0.297408593086594,0.5902311440250765,-0.18030579644193348},
{0.29662495046078696,0.6072390553813639,-0.16365858103689737},
{0.2971580911359546,0.6227248295683928,-0.13472605991738149},
{0.25978475695295705,0.6531794071141735,-0.16190563895782387},
{0.2534146213351285,0.666954589984717,-0.13457237837782332},
{0.2169640000228652,0.6886965353036397,-0.13663807206843284},
{0.1706408446946556,0.7075663269735795,-0.11627694455650442},
{0.1019929570553265,0.7318216741965289,-0.11006307425403147},
{0.08713305155965674,0.7368787948738902,-0.125126520087851},
{0.06983660405307979,0.7575799088216011,-0.12502256667072362},
{0.05279281518499958,0.7615496721024635,-0.14194103391336466},
{0.0318378261418477,0.7499516741230793,-0.16454001617693315},
{0.013936903650010938,0.7384042552547829,-0.18115837552340233},
{-0.016948110545396227,0.7251567416591779,-0.19819599392691362},
{-0.047664706542492496,0.7152999334036568,-0.2061362907343018},
{-0.0793648350703053,0.7014319014024313,-0.20941595002270896},
{-0.335728653744088,-0.04911566716921868,0.20280288317230535},
{-0.35443499822186664,-0.04705540344493353,0.20226610481279136},
{-0.33919755654872613,-0.05702179906620612,0.20383530452328164},
{-0.3063815959702519,-0.06387129521337866,0.19847330467626728},
{-0.33903945857989576,-0.061728760752990046,0.2106091147379661},
{-0.36727636393523055,-0.060757313111128794,0.2095750519669211},
{-0.3733778612386703,-0.05839309238717084,0.20006500724661197},
{-0.37779083449827633,-0.05160625280308668,0.19824253057627877},
{-0.3607083123662061,-0.043963468429586997,0.19658772629397273},
{-0.3268421181073887,-0.04554048002471488,0.19547524189032525},
{-0.30376132221483965,-0.05554051360211373,0.19168867383802315},
{-0.30108522105375113,-0.06221938811717447,0.2001743513209747},
{-0.3039200884381834,-0.07375566232752885,0.20749009682268993},
{-0.3385624682823792,-0.06654409334858137,0.21883635727115006},
{-0.36186083679545167,-0.06646619867025336,0.22020339564882987},
{-0.385418055659746,-0.07245099685005173,0.20735551525076612},
{-0.3974882811624281,-0.07263312754598499,0.1996687280705316},
{-0.392734146444,-0.06651953260479615,0.19340793758947358},
{-0.4011380790827148,-0.0628609411350541,0.18946977456655503},
{-0.3882211496137612,-0.05040363584553099,0.19029545454464566},
{-0.37153296138906855,-0.03489054609126176,0.19288738963409519},
{-0.3451617461417979,-0.03584099949236084,0.19472684889329447},
{-0.30932327464882436,-0.0438605285495117,0.18820169522688096},
{-0.30162541399197107,-0.046257495869442125,0.1892751913886637},
{-0.300599578507018,-0.08534267713495829,0.21782721964976964},
{-0.3069986094925025,-0.08783480326015286,0.21736228661850526},
{-0.3275844011970958,-0.07578163896451497,0.2210430877235458},
{0.037781163856804016,-0.425548885784695,0.25531305857036896},
{0.046672751242646755,-0.42099390259774755,0.25701898910378557},
{0.049520380269710354,-0.3860876079042927,0.25104474807040966},
{0.03986296789946644,-0.3825691597113674,0.2552662085106994},
{0.044220241242333494,-0.37887692922309124,0.2686978798763418},
{0.06061878416298155,-0.37839886483127727,0.2700452615846941},
{0.07298912712350582,-0.3786105814599439,0.2594739511413277},
{0.06404421111515927,-0.3856255922448786,0.25319935998279886},
{0.06124983952927617,-0.42461334540204526,0.2546398139274736},
{0.055764008614982104,-0.4306704446830444,0.257345357596241},
{0.05255778082968711,-0.4750122243166005,0.2611032023909526},
{0.04021410961726934,-0.47897080256802393,0.26691089506376586},
{0.02915640550484719,-0.5124398252281993,0.26543860606902087},
{0.019018882545344576,-0.5166529170821583,0.2704954027119996},
{0.019056572524863757,-0.455536909064891,0.2642924444001581},
{0.028210834930049486,-0.41819441551825226,0.2600278013319639},
{0.02901242162379197,-0.3807741090986869,0.25702267672129914},
{0.0325615330309715,-0.3744313708535001,0.26866464775999954},
{0.05284285671773471,-0.3658173024489421,0.2822819547049452},
{0.058003089385236684,-0.37233236324114677,0.2809317565534848},
{0.06929683607798436,-0.3607255717123071,0.284982210770035},
{0.07343876148228526,-0.37012636266291754,0.2709138500894738},
{0.08265628708541975,-0.37515811304174124,0.2540897724688414},
{0.07322905067956657,-0.39087294872736666,0.2581131140380433},
{0.0753823855777664,-0.42140355642576627,0.2658793852586918},
{0.06981733303778778,-0.43816222265985516,0.26376009309399445},
{0.06090058252293074,-0.4576827667369139,0.255638820427964},
{0.059611459009327405,-0.47591971925784343,0.2511972333387721},
{0.05774980180131556,-0.489109196701932,0.2493686669468636},
{0.04943555125559686,-0.5466634740320352,0.2618328215795471},
{0.038053905190160726,-0.5358409721353597,0.26955678240910447},
{0.03666024074791017,-0.5622205761547097,0.2686868765186386},
{0.02922356986427954,-0.5578330539366348,0.26552561939359465},
{0.005955486348280426,-0.49525189099307654,0.2776741443519809},
{0.014219832411871572,-0.46172142716434916,0.2693013360125105},
{0.007829914760593769,-0.4252437941334797,0.25997849923506555},
{0.017479470625071887,-0.422413667212702,0.25870007523053135},
{0.02432394583292742,-0.39828658979686843,0.25613980201867886},
{0.01743072522986672,-0.39875654801708094,0.2580945516487616},
{0.015195813347864271,-0.3891072407560307,0.2586480374335185},
{0.01867046059153902,-0.3814669700394129,0.26980211680814903},
{0.01928419658569132,-0.36887227523412036,0.269148749815406},
{0.034168742505732146,-0.36746904699675115,0.2785731485299947},
{0.03974405471794604,-0.3613798491885446,0.28423779861507376},
{0.046941236570310775,-0.3593850786562043,0.28905432641945294},
{0.04313620280783772,-0.3479308329529724,0.2912926688162785},
{0.06018044744886909,-0.35484646929844693,0.2910016190091071},
{0.0682957430085523,-0.34476157058506907,0.28820492818697163},
{0.07379475627897084,-0.35599680623000873,0.27886675130313704},
{0.08003708636189699,-0.357982335939205,0.2776066251483396},
{0.08522126145183798,-0.36313647994753945,0.2652440738867045},
{0.09170943270233474,-0.3565476572433932,0.25643048741997093},
{0.10124894011607119,-0.3796715953923499,0.24731351021692813},
{0.09208028102263233,-0.40354286306811804,0.26111094309426686},
{0.08324410032897253,-0.39856833822365056,0.2575470036612629},
{0.08494970576559888,-0.4265992002080318,0.2630365328171486},
{0.0868301272203766,-0.43693310075221936,0.2686908892329425},
{0.08296504723080808,-0.4471603313025056,0.2695068928006864},
{0.06910076340434132,-0.46329714155953927,0.2623230441663554},
{0.0714012747190698,-0.49034691136394687,0.2585547835254603},
{0.0658792518202708,-0.48798269063998895,0.24955679599730035},
{0.067180107503336,-0.5057107774418348,0.24765617179558},
{0.05656805159558463,-0.5216567835055625,0.24654460000024253},
{0.05567560778580658,-0.5435454388439847,0.25001569030256443},
{0.05597418475232212,-0.5668773645701897,0.2575195861028727},
{0.045032212972432935,-0.5971391926539618,0.2661721359807694},
{0.0326872551841556,-0.5854078986161054,0.2609893802676646},
{0.04768625111050106,-0.6155727851743056,0.2639787599945636},
{0.04253026382461369,-0.6179725073176912,0.25089274938482486},
{0.041492026853277485,-0.6293032258022774,0.2548402637212998},
{0.04169194969282919,-0.646601720568707,0.26337761353297706},
{0.04868794231553103,-0.6501198436648421,0.2612895083495849},
{0.030234298972561566,-0.6648647721999329,0.26729284767050876},
{0.004533882705404236,-0.6845007394488513,0.2839511269904934},
{-0.0002645469819068757,-0.6727663654907496,0.26621373774585033},
{0.011441849528888015,-0.6675160905740035,0.2555474905404523},
{0.030221421527478944,-0.6753896384234137,0.251196929490138},
{0.04507212232187032,-0.6983324987225782,0.24266405772738606},
{0.027695075246677334,-0.7470217594862032,0.26218419596466075},
{0.0811089411036111,-0.22578238485447916,0.32221228032206567},
{0.12028707349095916,-0.2196470668607695,0.3141415655189667},
{0.0979097870526304,-0.21246200283190225,0.33789994280309754},
{0.06078753064530607,-0.21701576956190566,0.3426510592209333},
{0.046456977278548195,-0.20511580022304818,0.36037912583703086},
{0.0821445348043123,-0.20140930372267982,0.35669240712048045},
{0.1244085932284254,-0.1978583532875787,0.3453205947017471},
{0.14896269059036385,-0.20630520507706063,0.3184849128202413},
{0.17842194925316762,-0.20038346823772676,0.30480894077835485},
{0.16827605664492637,-0.21524641328214517,0.3062576018233731},
{0.10665235899402288,-0.23111590367288404,0.317395732331938},
{0.031859807359466634,-0.2256648549279292,0.3324480632552341},
{0.017466050289597534,-0.21251290491496466,0.3531642538321975},
{0.0023887591571791936,-0.1984496512287531,0.3679693252734948},
{0.01583511193636806,-0.18564299756581287,0.37709558260877063},
{0.0673753599981485,-0.18434878830601606,0.3725482391963953},
{0.13809553781818856,-0.17939209597666383,0.35403413847450715},
{0.16682431674207057,-0.19008596259793623,0.32886464988704617},
{0.21031313057771447,-0.17873327776944023,0.3030675895685043},
{0.20490992418132503,-0.19186293740411267,0.29177409572881574},
{0.18919970784486378,-0.20947244037085966,0.30052105541446955},
{0.1432730962322797,-0.2367262264721165,0.3029272221236394},
{0.14102220042475394,-0.23118804222568962,0.3070329757291836},
{0.07293390847750537,-0.23979303341790653,0.3218437416763502},
{0.026653256898608823,-0.2330331853666802,0.3342878561104863},
{-0.021774750347324807,-0.217195144371976,0.3428087927838843},
{-0.03409553942029951,-0.2036995213681231,0.3573528253138681},
{-0.050830346099758734,-0.18883771097524735,0.3684689905409312},
{-0.011802940695845069,-0.1739944619092455,0.38326036435831534},
{0.03385386289134981,-0.16359320470981176,0.3869395038575387},
{0.0719459053347183,-0.15668859190778878,0.3836039576686178},
{0.11170872961146913,-0.16272129299339785,0.37152876647182503},
{0.15574752434850003,-0.1646681595575196,0.3546649314260724},
{0.1920053558272577,-0.1698505104932482,0.3299648942902979},
{0.22196521255155638,-0.162959433829151,0.3080282542406636},
{0.2308309579297933,-0.1767676873300494,0.2795828747253027},
{0.23534298159447686,-0.18080488907155956,0.26789709423808916},
{0.2206402019644899,-0.19773442022914908,0.2740601527621637},
{0.21211486798516022,-0.1994617083467994,0.29043710968089853},
{0.19914964995636036,-0.2072661157582479,0.2919471895839048},
{0.18055978255899063,-0.22058074271771017,0.29827308866527996},
{0.16638390195827898,-0.22902524446111314,0.29185427989597745},
{0.11040057837396261,-0.246876941349414,0.29847913097382567},
{0.09850312162957926,-0.24818484929553167,0.30808768745845194},
{-0.14533392728233613,0.542999744758117,0.10107858355470827},
{-0.1076724202925206,0.5125579734760954,0.1145816837847382},
{-0.14810950274921897,0.5639704478752079,0.09385811266070862},
{-0.15951893609096385,0.5523509297631949,0.095969871291615},
{-0.16514373738385071,0.574254945393755,0.09203252950993471},
{-0.16213067871165004,0.587219453734137,0.09420270357194611},
{-0.13378627468432105,0.5751531591403571,0.09730165047884827},
{-0.09838068869097946,0.5502287404123958,0.09938447230819404},
{-0.10827928144572493,0.5437996379738079,0.0975144401394045},
{-0.05882585730351605,0.5197767168949937,0.10419099966784404},
{-0.047517495066506134,0.48734487623519773,0.12242275913939121},
{-0.08641665509868346,0.44614565109957277,0.15278398184837158},
{-0.1244409350470217,0.4610862879024272,0.13934318121240533},
{-0.13378640642288972,0.500979996571918,0.11914188445644777},
{-0.15118534866066888,0.5098993606099913,0.11349577657490206},
{-0.15741511577122455,0.5255473262231481,0.10871856529640135},
{-0.16258154971312203,0.5459825789904896,0.10606199331570294},
{-0.17155516985571845,0.5671562455582887,0.10531352913734882},
{-0.1699825353807737,0.5927688230100029,0.10728190627242909},
{-0.1648162841730198,0.6009834515752414,0.09964320579455663},
{-0.13438856642152838,0.5863126886670603,0.10673672320471868},
{-0.08756843053042196,0.5656731763114808,0.103864443129206},
{-0.07118554643850702,0.5497292780648513,0.09863015638761442},
{-0.05280488838736891,0.5301521575846092,0.09612526968219647},
{0.042800147280957435,0.5297477732993352,0.081910508142809},
{0.032501232888409025,0.47788998004197336,0.11410547435696304},
{0.010570710182953021,0.43217934000134084,0.14384216488361107},
{-0.058164674176504165,0.41041194364088684,0.1760295423187679},
{-0.11274024047895097,0.3734955574320427,0.204877918614801},
{-0.12256843596729391,0.43213646122207044,0.15747719385325962},
{-0.1500963509065092,0.43333899743663246,0.14892662131396103},
{-0.1502514805079144,0.4595516281322951,0.13683513915578735},
{0.2885380647483899,0.25707131481331535,0.09897482910425338},
{0.28135267562273236,0.25303589685452066,0.0871562444533846},
{0.2736236896042268,0.24017274753139062,0.09016632838371327},
{0.2744493600206472,0.23428756602003337,0.10469616183329694},
{0.2706119791275388,0.2428691321824155,0.07584654464494009},
{0.2767665883222889,0.2555581751758121,0.07027906025348107},
{0.2956974142585888,0.2621317587023108,0.07415524984153403},
{0.3011437012917327,0.2632764213137516,0.08576559406209523},
{0.3240010483861531,0.2740721739065503,0.09952114151146738},
{0.3145713195715743,0.2704123659798641,0.10864017022399411},
{0.3027222331924388,0.2640667911058208,0.11314614453859922},
{0.2953938216647953,0.2524380332330714,0.1189166826854303},
{0.28808095316343346,0.25537839452595773,0.12649490134900448},
{0.2752603171512866,0.24043739225481614,0.11458844176082686},
{0.2676044024796452,0.22667736675651873,0.11264640277780034},
{0.266152540399891,0.2362514544821102,0.0862949153811806},
{0.2636982274935218,0.24967745152763168,0.06862528331952873},
{0.28467910316540757,0.2683478069407973,0.0662223601414073},
{0.29718583272872734,0.2723030619805864,0.07309975830493202},
{0.31838703796940715,0.272973713286014,0.0723641768836996},
{0.32708759274426447,0.2766112308344081,0.08642466937200918},
{0.3205529560257258,0.2684206753677693,0.09118206780723409},
{0.35331229982951984,0.2818155470516385,0.10161758022173256},
{0.34768045796006636,0.27917363204910695,0.11127347334880602},
{0.33233952926682775,0.27470197350681186,0.11468349963734895},
{0.3302726605531787,0.2752476378452608,0.12461274710708624},
{0.32125315289239,0.2695618532815885,0.12856788953164744},
{0.31815611088269374,0.2631955274581718,0.13440189910835826},
{0.31488751657164293,0.2677355965642621,0.14248450969172202},
{0.2993287114092467,0.26065282328429734,0.1522181848818955},
{0.2825539560712612,0.25217119888714645,0.13719255226690127},
{0.2682310010451708,0.23817441049602733,0.1394806610328388},
{0.26106919949774315,0.22491992644277156,0.13332864623796434},
{0.25637520662311364,0.22424003431419987,0.12361999712619749},
{0.257312326806179,0.23810648545260196,0.09126005279022609},
{-0.48536546121416035,-0.6083105552788689,-0.058721625004338154},
{-0.4801065138624493,-0.5651332171029795,-0.06929019018591978},
{-0.4827982377304053,-0.6062896856362324,-0.09686846962984483},
{-0.4899653491920746,-0.6944611367156205,-0.07846449278965306},
{-0.4842736066453957,-0.6729857017082401,-0.10761039214365277},
{-0.4735300119016926,-0.6128600266940906,-0.1353197493385395},
{-0.4735018049742984,-0.5716275280082186,-0.12213920780655307},
{-0.4684891843105278,-0.540192992934007,-0.061572196901039405},
{-0.4747185253955512,-0.5403294900272149,-0.03375541221548184},
{-0.4704025350954216,-0.528559128066908,-0.012276775110957764},
{-0.4802942785070067,-0.6113384568506034,-0.030976999057334583},
{-0.490668908579462,-0.6895966847572743,-0.05258538484064818},
{-0.4700922546444551,-0.689414148221557,-0.1457062741288518},
{-0.46184941915182237,-0.5795860227990093,-0.16048101063990852},
{-0.4519855990047457,-0.5488307296597886,-0.17182224589942047},
{-0.4504073709526737,-0.5453315726679037,-0.15094161477899232},
{-0.4571027807829119,-0.5497605957223173,-0.12333501579244512},
{-0.4552936267065343,-0.5301800712874474,-0.10680648621365788},
{-0.4630427549147372,-0.5054873892009515,-0.027818847350323507},
{0.1031982799655779,-0.3496830855293762,0.2561202271547528},
{0.09271820591783586,-0.34235406736687246,0.2654138445301593},
{0.08422383581417098,-0.346298541092191,0.2728693901509682},
{0.08794435397283497,-0.3309059804417235,0.26476945488342307},
{0.10867766737649558,-0.3295638672137082,0.266784083942575},
{0.11142993999044198,-0.3363832111647838,0.26390767428789924},
{0.11805575360976735,-0.34416889470096323,0.26785583669313917},
{0.11044400323084803,-0.34790651656298377,0.26180463483790145},
{0.12980082601453038,-0.35656322045542327,0.2528212979134615},
{0.11112602336226604,-0.3553251817590259,0.2540919206574362},
{0.10132763478748114,-0.3583853433439552,0.25712257705262587},
{0.10942705372482996,-0.370118905622489,0.25469018905626156},
{0.10612483101932325,-0.37589004190491787,0.2535348481839078},
{0.12323817466441157,-0.39072234817046175,0.25307459612146066},
{0.11321566903698481,-0.3928529677272449,0.22999606953199686},
{0.09818147447743802,-0.38572723598742387,0.23656322867845966},
{0.09917494795804636,-0.38541711808485246,0.2469487813656245},
{0.10784660736524773,-0.42202395371689644,0.2548077200452193},
{0.0993542229017824,-0.41820965363349194,0.2607365898905993},
{0.31367120092776635,0.2968870480614844,-0.2086162586645021},
{0.30388989480818196,0.3255417930970253,-0.2245054854051544},
{0.29517973480430126,0.30416013895197763,-0.2258929485730094},
{0.30176115996285635,0.2313690085226615,-0.2105989113733449},
{0.30407352562394496,0.17947328199439164,-0.20309375980700353},
{0.3217534662285914,0.10738271283761894,-0.1910174945159133},
{0.33567673706156576,0.08213374977141431,-0.1811645767977978},
{0.36780093204176756,-0.0006238570221681744,-0.14338821502430155},
{0.38643473106454884,0.01235909153059703,-0.13087781802921666},
{0.4061874579943539,0.026013016485580142,-0.1254032836971818},
{0.4260583225479774,0.020605332040265423,-0.11427683436250383},
{0.44460429869143253,0.013239838230370969,-0.09835572263861417},
{0.45636850081124863,0.0077446145686158735,-0.07931846150053931},
{0.46295707916159806,0.011276031573695614,-0.07049023399175611},
{0.456499647618718,0.022319003276996315,-0.08455862441973604},
{0.45240801766261907,0.027922597847558853,-0.08292020352829045},
{0.44188825737108023,0.034334394725305833,-0.09241052039794871},
{0.4283716815603696,0.03458842174506367,-0.09220308952239346},
{0.4347737924660996,0.026076888443204774,-0.0673189562362345},
{0.44147730740553126,0.02590764475402441,-0.04431720879689669},
{0.4482714425440567,0.03773320517458324,-0.02445996112419276},
{0.45603532228472177,0.06509892762526275,0.02061729050259118},
{0.4575307930179126,0.08045736373682638,0.02174924246697576},
{0.45767969159750355,0.08077688394852914,0.009359165281353716},
{0.45111551038013636,0.06574518179770807,-0.011520680719701772},
{0.4460721287605929,0.07237558501877898,-0.008036286946764835},
{0.43664827718602706,0.06137354576363793,-0.02873921442461004},
{0.4298406866525696,0.05857032963272451,-0.05011084793918004},
{0.4337273282086715,0.07019787211093748,-0.06228231240703127},
{0.44111661145428016,0.07671828318888071,-0.05359531395584815},
{0.4363291213802035,0.0969651636143965,-0.07407420406163723},
{0.4409335883357853,0.12780807777545916,-0.09202643978835949},
{0.45147750246891755,0.16577031948205528,-0.09418586440813456},
{0.43516358670489896,0.1736495416515864,-0.1155624625544075},
{0.4187904193948275,0.2554256493630035,-0.13995870523890433},
{0.3813637502148793,0.32682700588747465,-0.17484546650233776},
{0.33686760166391105,0.37855729745856814,-0.2074720826358389},
{0.31668228245902996,0.37818914446688834,-0.22485098361266284},
{0.29923817301555466,0.36802448761188106,-0.22981116170204444},
{0.30696083664517415,0.3346452734712314,-0.21903619936770813},
{0.3053362653019587,-0.9973068578176157,-0.23611158849373226},
{0.3207932854215706,-0.9801682044312351,-0.24189644364823049},
{0.3172582211704742,-0.9863643941429099,-0.23438802942750012},
{0.31185448781981023,-0.9833776693731316,-0.2039083046888223},
{0.3280791018328294,-0.9700993544502572,-0.22265764799795393},
{0.32915340861177234,-0.9680925882713177,-0.23604076626420506},
{0.3107493605902571,-0.9832084256839513,-0.25515735101911435},
{0.2943699718200418,-0.9970790924565494,-0.254820039726201},
{0.297702823742753,-0.9997083637437169,-0.20624812721739022},
{0.3036010951807552,-0.9987402393134898,-0.19637812704407429},
{0.3132367441269813,-0.9905620853332341,-0.19391919266372518},
{0.32629175155196627,-0.9732250081647237,-0.1874798167416007},
{0.33178871862494,-0.9495299556981945,-0.18072446692504804},
{0.340165659730797,-0.9382049115337293,-0.1918568019990015},
{0.33973736383291064,-0.9456545395430285,-0.21119916647477768},
{0.3287747579685074,-0.9633365879647728,-0.23640399499567885},
{0.29522834739853,-0.9760214153239736,-0.2527392895920875},
{0.28899651284237327,-0.990923267867263,-0.26620214687662735},
{0.25674364327767923,-0.999740947791294,-0.2700246126264707},
{0.26619205559603026,-0.9994117012360774,-0.13403109115955752},
{0.3706692758963388,-0.99844114495437,-0.12337591849318612},
{0.3588112121711963,-0.998679771310493,-0.16780796241921903},
{0.3292437037140756,-0.9993834932462755,-0.187082564399965},
{0.3598783455725964,-0.9801701496999379,-0.18269935874482818},
{0.35682243999335955,-0.9601235565198531,-0.17855374572301375},
{0.33943822910229404,-0.9478248761534349,-0.17364005222501452},
{0.35699285870557934,-0.9279131598946456,-0.16467606812126803},
{0.34788941764046233,-0.9262862183196027,-0.17485780743147564},
{0.34338805311335113,-0.9281323335637408,-0.19096393747573007},
{0.32940889431745524,-0.9546711298319668,-0.22649300075455017},
{0.30658109278427126,-0.9489859125940658,-0.2129227053552614},
{0.288269528425151,-0.9511896428068022,-0.21313274019236253},
{0.2491622788245753,-0.9626761495856365,-0.24140964520179856},
{0.2262834530314307,-0.9843286093570084,-0.2789959932134006},
{0.2640717498942808,-0.9905792687171764,-0.27357842093858464},
{0.2473886888496862,-0.994089286704118,-0.2799227591699355},
{0.22644021342882634,-0.9985001532090338,-0.2833848944368146},
{0.17545050297012602,-0.9999309413674398,-0.2933867712917664},
{0.10469089175934825,-0.9984779435737352,-0.2848709617984663},
{0.013387928848821387,-0.999792984525899,-0.23147161905631522},
{0.28379396022210973,-0.9989795137383777,0.06726640423384088},
{0.29284088437888084,-0.9990253916948998,-0.0032690601768761746},
{0.33413028350231877,-0.9991834492922331,-0.02495582722129545},
{0.357529971723554,-0.9988892186360744,-0.058383249178797676},
{0.375417494065665,-0.9977818412267766,-0.0964990906195505},
{0.3878796226866519,-0.9888015640368336,-0.10927378811793002},
{0.3821721554419556,-0.9906536776354751,-0.1174903927616979},
{0.38394645510526293,-0.9847222144526274,-0.13431539255231056},
{0.3789954370960316,-0.9910375553251723,-0.14577632611271565},
{0.37076921659916245,-0.9946926620972929,-0.15981131231428783},
{0.3607895281313528,-0.9893858107773634,-0.18005205202265345},
{0.3862857921134609,-0.9747413902708674,-0.1715231313545523},
{0.38450808743311793,-0.9642552689978624,-0.1745211240215788},
{0.38032563542044145,-0.947692593632015,-0.16965152469738617},
{0.3598719828122136,-0.9401774724307711,-0.1670413013198703},
{0.37689237639787765,-0.92904987888288,-0.15479238944737966},
{0.3672705472524629,-0.9155937296412617,-0.15491818703151836},
{0.35193180711931565,-0.9154254580552289,-0.16985053599103564},
{0.3209885474780535,-0.9123400079771634,-0.16034066338079195},
{0.32309582274799553,-0.9362304043055768,-0.1992196610375235},
{0.30240054460639276,-0.9174061251238721,-0.16052299805902503},
{0.28909485355903264,-0.9274657342817062,-0.1755703845363666},
{0.2731638635673121,-0.9447757381119571,-0.20785604106852987},
{0.24504823737569387,-0.9394466782191371,-0.21685038135067305},
{0.20065087469025816,-0.94966742489455,-0.24149734696663416},
{0.20048406285255824,-0.9683720663326069,-0.25806676968449205},
{0.18978354980801737,-0.9794667517985379,-0.2770552057467759},
{0.20257763943617937,-0.9864123788541221,-0.29571826560550024},
{0.13338688371576102,-0.3529710124753721,0.2672386818706496},
{0.1498115820543192,-0.35221946731436476,0.26991346564605195},
{0.14874882577310247,-0.36266538601337645,0.2698863529987036},
{0.14296526781854196,-0.3633271215924503,0.25683460822810766},
{0.14269881912665255,-0.370906762820084,0.25929941878606194},
{0.13235896166186628,-0.3674709922654539,0.26056679906139607},
{0.1261623554863294,-0.3707975005511228,0.26523720435779563},
{0.12351143232796456,-0.37604891011941155,0.26402058486528496},
{0.13230423916031386,-0.38662727388823825,0.2591128089787955},
{-0.3756963665545014,0.10546753896092072,-0.17480003475709652},
{-0.3819894574202511,0.07725665303529623,-0.18238271553347882},
{-0.37694579320022975,0.07444670973812063,-0.17546979470237029},
{-0.37672763200577875,0.1159112690998408,-0.17097562373855044},
{-0.38858747951363665,0.1271276990641099,-0.16339117936520114},
{-0.3806408603173625,0.03905878308742102,-0.1725335268667815},
{-0.3783404701171245,0.04412255018805067,-0.17594712922001776},
{-0.39073439109420843,-0.008115310964596495,-0.1847553260919238},
{-0.3884199378017702,0.006991610721683389,-0.1884770808932803},
{-0.3824022719115089,0.04339410602249559,-0.19049533701270055},
{-0.3780489146038349,0.1356352621479774,-0.18591239018974776},
{-0.3788685452318471,0.13386274520497785,-0.17974090145968932},
{-0.3755179638475785,0.13433400062512812,-0.1735445693853679},
{-0.374961477823162,0.16398029405832298,-0.1700879873241192},
{-0.37236791193772195,0.21159897709442332,-0.1695659105639001},
{-0.3710009149939468,0.251309337548629,-0.16905110810996604},
{-0.3942526353048339,0.2544647386818161,-0.15430504386092483},
{-0.40038252226981136,0.13324526528569794,-0.15610917274835423},
{-0.40850438350976936,-0.009015672899793317,-0.15914984021235123},
{-0.398520885247548,-0.034075048229636064,-0.1656409298971061},
{-0.3888595419684017,-0.03353643615423955,-0.17344519600831565},
{-0.38463984406267115,-0.008830299735219468,-0.17695452449258742},
{-0.3983955742461869,-0.055774763900461384,-0.18311081547890296},
{-0.39939794432980835,-0.04458200119500804,-0.1877201248892892},
{-0.3883124178816198,-0.020618979731011455,-0.19863229400525148},
{-0.3662646924712198,0.02044921971163464,-0.20605221602973456},
{-0.3620563825148202,0.08132911396725293,-0.2001932366822311},
{-0.36842335640700186,0.13485980643676546,-0.19361793099267008},
{-0.36630110649895736,0.23684640073170912,-0.1877551822222516},
{-0.3728878001378494,0.23339766030251685,-0.1804457782327629},
{-0.37466708568101575,0.20817179716935666,-0.17908417088381526},
{-0.36447020918431056,-0.9235762157252506,0.013433119958693321},
{-0.39234666081737507,-0.928878041856232,0.04590614698211594},
{-0.3711348580587759,-0.9063456460022464,0.056063806819276904},
{-0.3481378128364116,-0.9044223659539468,0.01255436421115803},
{-0.34591902618017145,-0.882593205452966,0.03674934011022169},
{-0.35330285821129936,-0.8788805491121069,0.059528476991194186},
{-0.35846036580276497,-0.8888882830213232,0.08101986511427134},
{-0.3820542207380295,-0.9066131284169362,0.08448781281428695},
{-0.4152664615549919,-0.9284508806098883,0.07276697074447981},
{-0.4342556880486875,-0.961171115057327,0.03814850570011989},
{-0.4188038758521673,-0.9571183511661946,0.027276729329149128},
{-0.42349920629823146,-0.9713500379244265,0.0016683462634747184},
{-0.3957773668739679,-0.9538861900062221,-0.004121883612141669},
{-0.36778532952064846,-0.9336606278558509,-0.013968099661782534},
{-0.34359928422164787,-0.9029275443519287,-0.010323646715195292},
{-0.33134777794928166,-0.8724436252272112,-0.0020411589758156986},
{-0.3335130075653386,-0.8709447505393924,0.018709376058468594},
{-0.3275842598968569,-0.843607235016107,0.035660448596843176},
{-0.3374670875820883,-0.8436568409616393,0.06571591246250252},
{-0.34735269133893104,-0.8700996678074411,0.07693499313426122},
{-0.3461151997825565,-0.8851062429511135,0.09395570862949228},
{-0.37110053166238777,-0.9057293007345092,0.10240156706767048},
{-0.3867364601950409,-0.9115176214632884,0.10526066053742741},
{-0.40447569271723677,-0.9171512874869541,0.0919822956813857},
{-0.421723527629585,-0.9362005761438623,0.07309825924751007},
{-0.4352854544425429,-0.9600031081590452,0.04869352261256062},
{-0.44435902591204096,-0.9764884561723358,0.02661165141510045},
{-0.44494578524704487,-0.9877270957719034,-0.0033781301500235353},
{-0.06371996000147197,0.8423815064390208,0.17428051096284836},
{-0.07082114268399377,0.8467980674498059,0.1755024701170194},
{-0.06056095730580392,0.8309597024207193,0.18245742936281933},
{0.32998211751453344,-0.2444362049524673,0.18920124886739426},
{0.3387711039283927,-0.22624593994281209,0.19879411146382972},
{0.329213713003966,-0.1998269429042213,0.19920407870215287},
{0.3251630569299316,-0.1921213415440537,0.20407785222663669},
{0.33424594996556733,-0.09925776211574533,0.21512818004162396},
{0.3357434860195438,-0.1900294669377465,0.202873471672114},
{0.3566185044395041,-0.20515211332204372,0.2116679093004539},
{0.35385014272166093,-0.23443382026658166,0.20550820373543233},
{0.3557125499895876,-0.2671076912371285,0.20028760611849136},
{0.33668044471662184,-0.2773381653184631,0.1864109611771384},
{0.3272559854447878,-0.28497097899465235,0.1761455530021475},
{0.3211701522821201,-0.24306345188316963,0.1922408826085907},
{0.3158001174448278,-0.22991515017862965,0.20610066820038372},
{0.32070558365673507,-0.20554223159522547,0.21230867188692185},
{0.3254095047323626,-0.16477799021465994,0.22026795604671634},
{0.3288559758584696,-0.10816014462736025,0.21850058646956325},
{0.3288355903773834,-0.03800963412545344,0.22469110186111702},
{0.33476721610862636,0.0005137533262202135,0.22324057735279748},
{0.3431242593785826,-0.081129423795012,0.2194202194200521},
{0.34486455667988414,-0.14778847869925915,0.21373550788826937},
{0.3589768086143599,-0.17214445612770188,0.21807845041216772},
{0.36264472165023975,-0.273337600710331,0.2003888939544198},
{0.3499301468723182,-0.29767752940637393,0.19028840334400102},
{0.33647006565938975,-0.30824843507236416,0.17746328928292898},
{0.32788071842219646,-0.3197866545514213,0.1630444253916595},
{0.3134872864491176,-0.3027734757772047,0.1733322153120143},
{0.3166491714571782,-0.26039323349723875,0.19083739089408425},
{0.30737336747354627,-0.2659735655863617,0.1933606009470264},
{0.30545732136003484,-0.23453035701477729,0.2095324472888662},
{0.303475418711107,-0.21630450984270083,0.21815518919079688},
{0.3090502995857493,-0.20517018806613999,0.22055586431398927},
{0.3182924464899143,-0.1602229262847188,0.22469215576966597},
{0.3267085776951202,-0.12362314291572725,0.22595025591276707},
{0.3265476430974332,-0.09259696340718875,0.2284962832982758},
{0.32628542916308034,-0.052175666205752966,0.23208147938677134},
{0.32665277153760014,-0.006450921639015529,0.23532634588176116},
{0.32786454857530617,0.021169476962594663,0.22890164074910505},
{0.32918424924813094,0.05497844568705583,0.22568074642397287},
{0.3447256681066927,0.012011202905512804,0.2265230732700612},
{0.3538647327681357,-0.09511048748811379,0.22489619225226365},
{0.35302455411064204,-0.1485797398514821,0.2197448253779483},
{0.3636591288143651,-0.0993803172312435,0.2278793505190188},
{0.3676975459504115,-0.1274343620164785,0.22307502234353854},
{0.3665532891787547,-0.21966668209619244,0.20555735390801366},
{0.3681507266264655,-0.30595035560911615,0.1908600254925073},
{0.36454818354322455,-0.3329356053871341,0.18837760552507815},
{0.34743733230686186,-0.31632575698964255,0.18455108668943412},
{0.3438350325150097,-0.3388365923395024,0.1757551202562536},
{0.33787706438208176,-0.3490785754846586,0.16087544653843602},
{0.32937193314969476,-0.35215997353933115,0.14866418427396771},
{0.3163281118165567,-0.34795822926320635,0.15733987658122134},
{0.29758614480485995,-0.3149958019566215,0.17794970207532532},
{0.30174537470759377,-0.2920882815908973,0.18499934310528213},
{-0.32626261289292147,-0.009529563807825128,0.18042046955387842},
{-0.34697920824726103,-0.0019027474237316342,0.18435124565528394},
{-0.32664199234794505,-0.019274434651515716,0.18821853439069253},
{-0.3066598384512562,-0.02375314439445547,0.1840685145012762},
{-0.35503521188939474,-0.021075564361693395,0.19226231243655556},
{-0.3656359053456026,-0.0007678111558046295,0.1863549319139779},
{-0.3796727762586322,0.015425575504412361,0.17602576333418254},
{-0.3508610275343069,0.006532837530909823,0.1746551797016359},
{-0.336173140737021,0.004031471644979041,0.17989825043101262},
{-0.3068416047413101,-0.009556879375065438,0.17944214175903017},
{0.4663798405325769,0.19802562089822973,-0.0763095972143782},
{0.48140408670537715,0.19536149626039964,-0.048143595893972095},
{0.46419880547550907,0.16341315102114978,-0.07415694119476988},
{0.4535745648125682,0.13266085705918085,-0.0759884972022598},
{0.4764531483767318,0.16127037326937235,-0.04429622624262046},
{0.4899088120979802,0.19532599377856427,-0.025165846122279414},
{0.4923401865572925,0.2398291542210881,-0.028344799774238778},
{0.45436031525547305,0.21937347560116374,-0.09471891371623035},
{0.437510704787908,0.2506387680486028,-0.11818186513541433},
{0.4142946070109389,0.32693359301356667,-0.14043871383701326},
{0.3745529586466859,0.3871303526719728,-0.17669332409528662},
{0.35949531887155606,0.3880064800225826,-0.19276577581191798},
{0.3132815278034576,0.3796775629370268,-0.24108307378945115},
{0.29324684952697827,0.37430408377360963,-0.23744940640696582},
{0.2736983619996627,0.3662499446571851,-0.24430741244070805},
{0.07450761704674745,0.8652884392932252,-0.005449164564701227},
{0.08576692579028694,0.8409066857264611,0.014232064444208712},
{0.07828728582272194,0.8278725099938431,-0.038136819214193915},
{0.05741121349421276,0.8918736404722478,-0.04615810655627272},
{0.06365436481837729,0.8558791767027264,-0.06248448436391982},
{0.07191546947573565,0.8371203301557213,-0.05359172726707667},
{0.07657029137435681,0.8215366614633136,-0.04766275543054681},
{0.08951143630455695,0.8045854083156112,-0.03851981085577641},
{0.10920768775992087,0.7948597468675596,0.00757560142193064},
{0.1120559903535368,0.8167072254040252,0.05606039117816308},
{0.08086218945254608,0.8613359805107957,0.0545704810874573},
{0.07373782503157841,0.8799694554991945,0.028836007213088214},
{0.056839794265598556,0.9193134467444357,-0.0016008366215036712},
{0.04191105218060109,0.9243119851926656,-0.047220963766231534},
{0.035659086058825076,0.9016635786553002,-0.09237192843419763},
{0.045761071477034516,0.8616397760244812,-0.10243079709378707},
{0.06064789307460753,0.8517224190229696,-0.0801960772844929},
{0.07046366795322682,0.8482448235976183,-0.06717134423250319},
{0.07974626072277383,0.8379958083751583,-0.059781979181493194},
{0.08382492186671817,0.8235257778612813,-0.05851731442052514},
{0.08130778028719507,0.8150042133048667,-0.05341922092350736},
{0.08194549270083637,0.804880894737803,-0.054903221901965824},
{0.09354474750866153,0.7914469136975786,-0.05539144822449634},
{0.10297524550649584,0.7748920204689502,-0.05017831614724645},
{0.10629119664574228,0.7680591818138534,-0.03272158211174758},
{0.11701191349963355,0.7636770088191093,0.004403236823217922},
{0.12180187579668737,0.7876308510796151,0.044679586539713524},
{0.12580542895799313,0.7900932499718372,0.07095081008858568},
{0.11952059512575401,0.8106054444376997,0.08630630864255065},
{0.10573414435796234,0.8299715781634418,0.07935739555960566},
{0.0839550561995432,0.8495746766394895,0.08868416643317643},
{0.06657367237566394,0.8814156846927323,0.09303614579791902},
{0.055227726399916084,0.906905139703177,0.09618167928735345},
{0.0589577286731129,0.9139907899834951,0.06136383004420223},
{0.06315038405041071,0.9112031572503603,0.032606215247501714},
{0.0440467829813651,0.9456256941085394,0.025533354232417763},
{0.03381987115342239,0.9501874650189944,-0.015197414927640056},
{0.025126640618017233,0.9343121196988066,-0.07276924429719633},
{0.011653692584084215,0.9404397373606987,-0.0860179339782485},
{0.00569394066844082,0.9261950605421563,-0.11064206207589454},
{0.009337652054375766,0.9031946719224093,-0.12748810604043656},
{0.015031722336569497,0.871906582328152,-0.1387022667016204},
{0.04409820776907075,0.8104836383197087,-0.12920015604284718},
{0.05029715336660847,0.8193074791466384,-0.11907108241266902},
{0.05185929125237598,0.8415989379075111,-0.10617903665947531},
{0.05661138083576703,0.8505212203798425,-0.09151948002888959},
{0.06551345949874784,0.8516074016908939,-0.09548545370108856},
{0.07374510996194153,0.8516190733031106,-0.08182763927110774},
{0.07815804285005075,0.8474598837718736,-0.07772869357481929},
{0.08141703299448602,0.8294257321532568,-0.06575271426909134},
{0.08458070178526203,0.8108248412124355,-0.060601671429158475},
{0.07904946887314547,0.8043298004330299,-0.06480523879708773},
{0.0794278241670388,0.7897533857129528,-0.060641915437056375},
{0.08299613115855566,0.7911741022453065,-0.057728160022992296},
{0.09467400945646756,0.7776340397851083,-0.05453642666746895},
{0.10234524298634236,0.7731256229949446,-0.06031226304205576},
{0.11604275534660594,0.7551761335924149,-0.04864297749852288},
{0.11368690427138668,0.7423335726702632,-0.027415277931840936},
{0.1211239289368186,0.7202246493826998,-0.001987667804916768},
{0.12267396918483706,0.7222000883425029,0.013259018940999014},
{0.12012421381031789,0.7257706550754347,0.019569856266831245},
{0.12748586701597392,0.740399673855888,0.04639713768977186},
{0.1274693423248746,0.7680259082636065,0.050497985096042815},
{0.12904867315625485,0.7686863880766471,0.07596245864920885},
{0.1234551300259965,0.7916918624425875,0.095917079185056},
{0.10731472245611322,0.8161107397255074,0.11904927436752327},
{0.10421780262331536,0.8304531474386255,0.10682675058025355},
{0.08985681233516714,0.8380558492902147,0.12241654830332546},
{0.05775099701010345,0.8473242982245679,0.1306910669217113},
{0.06788752768071026,0.8591698191630884,0.10366317315654937},
{0.06792104452234594,0.8694686220028166,0.0960570662879245},
{0.053987773244642503,0.8983469581991327,0.11246091806040631},
{0.046467027656444546,0.9144086296637013,0.10657611689104549},
{0.040194792918441566,0.9424281036987516,0.07021520104475017},
{0.0511744759260061,0.9333148959186238,0.05067964620772344},
{0.022727227635304856,0.9657593611704433,0.04402614517842371},
{0.016832243287071183,0.9691354955873929,-0.0056934238070405615},
{0.00617323320368483,0.9715513886400766,-0.03187875912121131},
{0.008509099325562904,0.9605871424180126,-0.05653717430615643},
{-0.009733432961192418,0.9535177437899861,-0.094009680008722},
{-0.022335981085027278,0.9381768554682443,-0.12561558783736818},
{-0.019702077699801854,0.9163104703223658,-0.143463960451627},
{-0.014159423903712234,0.8845500522760685,-0.15912738728566397},
{0.009507001984337248,0.8390695478283298,-0.15360979250262302},
{0.015550197534307758,0.803904685384131,-0.15456340762936904},
{0.0312208583031329,0.7973435639012606,-0.1464950843062537},
{0.030056909802690813,0.7712258901533781,-0.1518317234164008},
{0.06283050899449884,0.7852387878341422,-0.11841168731800382},
{0.0648241246895481,0.8133792775557718,-0.12659897056858335},
{0.06670943003303506,0.82685911636677,-0.1240359414708679},
{0.06517345287721683,0.8443244219084917,-0.10813684602405504},
{0.28497400313848764,-0.8040545263194508,0.040748881619631395},
{0.29575502438457274,-0.8176137779895396,0.012532395742432773},
{0.2721987786858337,-0.7647879421073521,0.057735439641316375},
{0.27456907850728873,-0.7865835464576081,0.06206307818069073},
{0.2652652896394954,-0.76095418933692,0.08222485017883874},
{0.26631382028011674,-0.7210140364475437,0.06697334647590582},
{0.2829430214983018,-0.7674723311117778,0.0297208654310925},
{0.30270320546853563,-0.8303120607436725,-0.019214752830299435},
{0.30624189571749255,-0.8549951779726417,0.0005581821584874515},
{0.29825857883059514,-0.8300387425228741,0.02423798482329086},
{0.2915464318276953,-0.8069963462982622,0.04474367310371609},
{0.28282974651503673,-0.7915673110628119,0.06342182659021776},
{0.2770997456006595,-0.7670404687108685,0.08730031757669597},
{0.26564949136357513,-0.7506673014007971,0.09338759667639505},
{0.25634825546175266,-0.7373463520524488,0.09735991823526749},
{0.2583338266048535,-0.7239884415363402,0.087617357066159},
{0.2598609485915633,-0.6898695163952949,0.0893690274430822},
{0.28085617208094277,-0.6925166201975776,0.052781614750647264},
{0.28880396630025645,-0.7493600425858522,0.021879683835658338},
{0.2941159246145356,-0.742121318463244,0.00730108268030546},
{0.30059862446480345,-0.7962960765451103,-0.029772598317063484},
{0.31141322310976943,-0.8751925331956186,-0.061745695533504605},
{0.3153007762117738,-0.883882308780821,-0.03356981063322853},
{0.3161300938742108,-0.887617336242966,-0.022889707505153543},
{0.29972211358497375,-0.852544552683786,0.02664353958556126},
{0.29426686939157143,-0.8312649470586597,0.039760788172180254},
{0.2888221228497541,-0.8084958690548462,0.06236834512919502},
{0.28721982169908244,-0.7977468039733218,0.06365922055327947},
{0.2807433433089585,-0.775488860991677,0.09596907554816422},
{0.2787580356429949,-0.7485209582084045,0.1113895753992574},
{0.2762310359813893,-0.7398827338374375,0.10777990993404843},
{0.26449402831432306,-0.7240938132678958,0.10727507180297802},
{0.25133768099542697,-0.7115490495049259,0.11415165509971135},
{0.2483917877450663,-0.7147316036569584,0.10533802826148096},
{0.24296736612708997,-0.6925454762561446,0.11421835412452229},
{0.25563614475389085,-0.649037593262693,0.10805059869551333},
{0.2763578056686755,-0.6358476292358267,0.08014352315728368},
{0.28907550180074704,-0.6597543983310225,0.037433602984529614},
{0.2921016397755145,-0.6900591859370583,0.0015285960775481737},
{0.30481558667041947,-0.8435420669209523,-0.06090149460003689},
{0.3177592643808421,-0.9038189905607716,-0.0695354225938144},
{0.32405426120620556,-0.9131056566018679,-0.05294208932575187},
{0.3349106029164915,-0.9332978240875016,-0.07437005595211643},
{0.3304192483957798,-0.9012313815959304,-0.03512583329963332},
{0.3196323307863411,-0.8862724671290878,-0.012942820878522674},
{0.3036173872045438,-0.8681442902943418,0.024184630702999612},
{0.282647938791078,-0.8391138544836989,0.06896327667825707},
{0.2792644482624419,-0.8316956748080265,0.06271840531584587},
{0.2743727019850116,-0.80821914687942,0.0744034899259429},
{0.2759673219272066,-0.7925287890697704,0.09293647388427179},
{0.09637063860949488,-0.45230296518461083,0.2648164058718347},
{0.08706541017911705,-0.4629939951770266,0.2670093770806643},
{0.07849903219880743,-0.4757707399352588,0.2651772027518281},
{0.07889580858174355,-0.49178369681444867,0.26317124719004886},
{0.07805544719010635,-0.4978234501631102,0.25851344523751657},
{0.08483345179083047,-0.5089170009774986,0.25671934760464293},
{0.07421419700774874,-0.5024497612857031,0.24986954760883637},
{0.08016343214846641,-0.5143982837239518,0.24747497283129735},
{0.08606857205296975,-0.5236107023327367,0.24166604457819935},
{0.0704920161808598,-0.5334519484386356,0.2475304953259318},
{0.06236008437725712,-0.558957614729875,0.24267820156257996},
{0.0628758695584168,-0.579804060754154,0.24349949485881708},
{0.0628611679591218,-0.5948741838210686,0.25281116573016366},
{0.05799972580210554,-0.6235369532228093,0.26195412092901216},
{0.05435658492916547,-0.6394544272623526,0.26234778658187635},
{0.0474109366254251,-0.6318887269500207,0.26041017996423926},
{0.06371131625151806,-0.6246394669291463,0.25038846370581636},
{0.050163503526335265,-0.6388003112721025,0.24670725676099187},
{0.03150393367727163,-0.6512825002773854,0.2473844333751974},
{0.00929709676098908,-0.6654165963788726,0.26400682562171884},
{0.011914508389757262,-0.6603428607057481,0.25610926523095423},
{0.04656933009183288,-0.6625320008720095,0.239038373277196},
{0.05573475734070938,-0.6433428111672654,0.23128276119411978},
{0.04139034805127447,-0.7222467259206103,0.24481814268550076},
{0.3376282654711641,-0.5997772171190877,0.13764993689066526},
{0.32513825395716545,-0.5847636715177643,0.14046110620645524},
{0.32285954643795145,-0.5838660654684305,0.13413293782199479},
{0.33873163016615815,-0.6045607762842619,0.13207223851050692},
{-0.14778390450242687,-0.5586496046444016,0.22013842941115944},
{-0.15932710879893539,-0.5646924379133085,0.2312333177969825},
{-0.15396126941009042,-0.599154389038885,0.22194259867008564},
{-0.14708871370137033,-0.6093641121708463,0.21705942283647045},
{-0.16096541813756074,-0.6269130674540105,0.2271352836465963},
{-0.16969926664841342,-0.5794673571585088,0.23181148437760735},
{-0.1570662136090882,-0.5153965603502758,0.23765577274989397},
{-0.14396863231587484,-0.5220855659862266,0.2235648794620596},
{-0.1349505833410113,-0.5411051890298156,0.21987897136266943},
{-0.13811633870072892,-0.5759043292714071,0.21574515212996997},
{-0.13414779187681064,-0.6045857407430154,0.21760484388353063},
{-0.1404664963324867,-0.6346992375729676,0.2189272207616325},
{-0.14918875397411635,-0.6670159790952862,0.22285860456030615},
{-0.15903794370322144,-0.6792543550695108,0.22670481937436676},
{-0.17358256480713277,-0.6573862881320667,0.22712644866323622},
{-0.19361646221387072,-0.6075544725740989,0.2308763498347416},
{-0.22520118350594087,-0.6106971471241126,0.22744564484055652},
{-0.2318345253470182,-0.6070149680761406,0.23644857681467094},
{-0.2240509687512774,-0.6103059749423819,0.25260581186187975},
{0.4687131791862714,0.08167100423783373,0.04939555638233075},
{0.458224260593499,0.10977133175696695,0.06700877777641782},
{0.45691088124715223,0.07867422909015916,0.045957519711838826},
{0.4682870718484767,0.05763560092964275,0.025949228458172595},
{-0.06766381115581314,-0.7589145150760207,0.21779487783117332},
{-0.05948303834030214,-0.7659728083551942,0.20648975381317275},
{-0.052770322949223174,-0.7903877951007084,0.19505798972163896},
{-0.07394258182667224,-0.837940983882456,0.22380800511526414},
{-0.09094325818576363,-0.8627792413369086,0.254017390624647},
{-0.11384295710518,-0.8692158411874218,0.2847629765436945},
{-0.13336350011983075,-0.8661608673398357,0.28773598244140336},
{-0.16011506692527253,-0.8596364031760918,0.27907627937171214},
{-0.1853620050421885,-0.8628192824249145,0.2668562224953806},
{-0.15777567042223697,-0.8336787737281502,0.2607716865326507},
{-0.12697169350746423,-0.7996279351165176,0.25372429462003077},
{-0.11154424444687622,-0.7917616817591409,0.2549237094804427},
{-0.10890758198856453,-0.7794490604774208,0.26326184614098624},
{-0.12253342006823617,-0.7895506559919635,0.2801480331846841},
{-0.11326530579234372,-0.7806746158820336,0.2876266999866937},
{-0.11067554970131549,-0.7821358802709191,0.3128925234648661},
{0.13457812334806382,-0.7041983072274935,-0.2947950874001446},
{0.1331237380497574,-0.7269751663061184,-0.2971683853364437},
{0.11846755456397307,-0.699950362022872,-0.2970369548660886},
{0.1357344979432181,-0.6751297755975475,-0.28985877948947075},
{0.12398130980518343,-0.6355918184333536,-0.29064532036378743},
{0.09546191764963756,-0.6763357157667375,-0.3037303779937193},
{0.07949648864630088,-0.7349315532798111,-0.31043284008701},
{0.13015802664408194,-0.757656537109818,-0.30135533664620173},
{0.14183609723780782,-0.7659838318986458,-0.30135217598296266},
{0.14363310268086135,-0.7583160023233988,-0.3042794877207009},
{0.1350509490069594,-0.7322993635583855,-0.30477214109658174},
{0.13468389029532538,-0.7030726117827107,-0.30506053594663235},
{0.13942422646109826,-0.6743571565151921,-0.29792305078919323},
{0.13964608483473312,-0.6616544966408762,-0.2855082789964017},
{0.140322227726138,-0.6389783081392414,-0.2839119156429882},
{0.14333615651033638,-0.5869845861768509,-0.2798028590115581},
{0.06572114322736232,-0.655286307354158,-0.3160722208022936},
{0.04121220882148879,-0.7184868954856991,-0.3209449393558206},
{0.018233927845890334,-0.7661008763048259,-0.32843635292675205},
{0.0871683107501033,-0.7686385552897521,-0.3138435240059882},
{0.12143789700529871,-0.7855272336797678,-0.31139966731729923},
{0.1476957150924059,-0.7947599166551484,-0.310632276343784},
{0.15794497360625487,-0.7870998681547126,-0.3089847867392599},
{0.1720050453810711,-0.7981063652730305,-0.32957696245239215},
{0.14397939131978157,-0.7613536302386473,-0.3147804827030662},
{0.13678972706509068,-0.7558473830334405,-0.3248701633140034},
{0.13242062381124312,-0.7304182324151898,-0.3178650414209778},
{0.13532209885341445,-0.721506528337437,-0.33096665561424343},
{0.13923872049554795,-0.6875727341319846,-0.31399659678587033},
{0.14519167406360586,-0.6457354013670127,-0.30087808287154794},
{0.1425136074480661,-0.6505923962849302,-0.2910238073962494},
{0.14676224215535724,-0.620581028717893,-0.2846372384543932},
{0.15084933350528545,-0.5841106901790569,-0.2780875261690101},
{0.15210277180290996,-0.5641376953001107,-0.2762018967911406},
{0.15498550278406392,-0.7181346286780238,-0.3575427381470203},
{0.16243940804721194,-0.7052196041062762,-0.3417927643854388},
{0.16690022471779123,-0.718593077834415,-0.3625683679944422},
{0.15336978767236475,-0.7275689779041746,-0.36348729125651297},
{0.18358038857628392,-0.7199967926545617,-0.35991465814038787},
{0.18907208716892057,-0.7119538396299839,-0.34601562295440846},
{0.16900136033299087,-0.6906812044625087,-0.329238759799325},
{0.14990418789361246,-0.6860171215549952,-0.32167743660717635},
{0.14567997156745974,-0.713863988317734,-0.3404932048399036},
{0.14064781641125984,-0.7325384764972862,-0.3596390706165044},
{0.14275746297543704,-0.7416184521610717,-0.3617630023161144},
{0.1530748675135362,-0.7405914809621681,-0.35540299994399144},
{0.1742307833716216,-0.7280181862374218,-0.35713235444483504},
{0.20451903566247998,-0.7285688757648189,-0.3517831927338143},
{0.17644353130186138,-0.6666457193489161,-0.3143088628770365},
{0.1615056716330261,-0.6553556910835086,-0.3127083040751756},
{0.15211606464944677,-0.6368541735197394,-0.30394006861068956},
{0.13381079293179388,-0.7471815998038444,-0.34325836552301076},
{0.13636697268634887,-0.7544041126456575,-0.36024763374702273},
{0.14164088511449205,-0.7599426198640592,-0.3673480759312998},
{0.15071478168078042,-0.764557583408818,-0.3680286979340379},
{0.15490858127129117,-0.7566976524403272,-0.35707083359569713},
{0.17790058111895884,-0.7465955703430069,-0.3300069613900003},
{0.17603209475353493,-0.7354854852758488,-0.3418974466143249},
{0.20402644178143656,-0.7426392624570766,-0.3298467152325752},
{0.2011200222933106,-0.733302342401683,-0.3481607507522648},
{0.2303096917867344,-0.7470603418882839,-0.33568982858182234},
{0.22842175167187492,-0.4148202465557537,-0.20647605406444405},
{0.2257641927143197,-0.3831534064518972,-0.20874051575731423},
{0.2303665518528034,-0.3589760739593583,-0.20866566169014256},
{0.23737483547147595,-0.4107229019080372,-0.20822650373479187},
{0.2329377062454608,-0.3228314154727158,-0.21270979351780683},
{0.2261520013129194,-0.3190138739830787,-0.21057593255479096},
{0.22459667239881545,-0.3464912905541998,-0.21000809895254036},
{0.2312851107089948,-0.45874896734425535,-0.2056011240474378},
{0.25200357058904355,-0.407934762406376,-0.20435208199333718},
{0.245527760453433,-0.37256710012227207,-0.20965522551000473},
{0.23738093475472144,-0.3132245811511519,-0.2135556868669182},
{0.22659359111975053,-0.2741943550544989,-0.2103220266495236},
{0.2225611510900513,-0.2551804063310308,-0.21225967363865755},
{0.21649341285722826,-0.3247318378169521,-0.22637729498221248},
{0.2050008280433043,-0.32590827385881005,-0.24976133924842414},
{0.19666571074576084,-0.36374212464379974,-0.26536233262501313},
{0.19032576875793378,-0.4428575934774161,-0.27861659463503635},
{0.183804871097213,-0.5959562716748226,-0.3000873890450963},
{-0.007294013949931941,0.06939510083248525,0.3504830456767593},
{-0.03581848760203997,0.1058344765580643,0.3302534506263359},
{-0.04128740073434439,0.06819694173810648,0.35432723447912345},
{-0.0007385986594169256,0.02105243255641454,0.3747546456144085},
{-0.03322540723696977,0.008197146113497141,0.3829668423281667},
{-0.06461161869187741,0.05468510745345852,0.36071414764111054},
{-0.07004080308407254,0.11293127149632469,0.32412439446426694},
{-0.0406608701629188,0.13742228733205017,0.3047139848929827},
{-0.01643341751946674,0.14132890959186226,0.29739821814311124},
{0.016488887956118463,0.08762021919280302,0.3326806912568536},
{0.053483147595134305,0.03409625495196047,0.3565074397956906},
{0.08012103995197377,0.0031796617467656444,0.3650850134295173},
{5.6120630232262534e-05,-0.02289833531899036,0.38986308654385876},
{-0.029991393237773972,-0.035234463435946765,0.39514051554185786},
{-0.05723173775540026,0.0038267265363711236,0.38334624196893863},
{-0.09618619823897943,0.027537179666534996,0.3675922151215565},
{-0.10699930207615477,0.04942437631903203,0.3551191851340161},
{-0.09429331899020452,0.08222453145649528,0.3405237830615328},
{-0.10415662705671615,0.12515554294444425,0.30780670927733317},
{-0.06852779518513794,0.14911994341378013,0.2926824427211235},
{-0.049398007888355654,0.16783187934387048,0.27192031363039276},
{-0.02019581154442698,0.17409891147082085,0.26072139108444864},
{0.043341110464840744,0.16986361104397119,0.25227018236053195},
{0.02477088380068131,0.13201419810935935,0.29538468336400503},
{0.0819068497415103,0.09269557716265567,0.313604087032705},
{0.1127268849503532,0.051683954123192946,0.33545817268335026},
{0.1752921818956553,0.031098344090335486,0.333220600532188},
{0.16882680779197667,0.010565987249027107,0.3439096448844042},
{0.15828887076519138,-0.021983220788923667,0.35598222149557307},
{0.1132044627593895,-0.025173881112557465,0.3672778422757002},
{0.06652047974136002,-0.02832498693096298,0.3763785274549543},
{0.02566991347648261,-0.057100585104687976,0.39139507223352943},
{-0.0003973989539136394,-0.07365791018479691,0.39869709992558316},
{-0.03852569712625572,-0.060782926701055166,0.39838872437182254},
{-0.07112057595120534,-0.03715271723289041,0.3922328997825362},
{-0.09403470236870119,-0.012874552677374253,0.3821888336509838},
{-0.1265219688440208,0.0021855189492360864,0.3685688706865095},
{-0.1519060213130831,0.029121486816104138,0.34869810706162824},
{-0.12425173190228755,0.07834036212337049,0.3341779245246038},
{-0.15155509207684256,0.08706580167639548,0.31731887137641057},
{-0.12508448326677118,0.15654898408450896,0.2711137729290255},
{-0.09162577446162953,0.17029320414179533,0.2645772323756888},
{-0.06969472692671468,0.20127528947652729,0.22893511615683618},
{-0.01743521815250125,0.21301095957215888,0.20596927703911772},
{0.02402096624844122,0.1951003362345957,0.2227689373410194},
{0.08201495717318051,0.18202044509385087,0.23063330598693857},
{0.06691845133308404,0.16303437926339437,0.25659587988083477},
{0.06320158998210715,0.1546044675664661,0.26621442724851996},
{0.07008572699838,0.14891641369970854,0.2698811854471087},
{0.0782785921396009,0.1333734947213171,0.28212622803035003},
{0.08457916129393533,0.1210845417608205,0.29055310017852976},
{0.10511984741248556,0.11469446687318657,0.29351242757566615},
{0.11056254669445015,0.1039091704980682,0.3014009511255865},
{0.11354260485521153,0.0933999471672032,0.3080000876847663},
{0.13445225458260174,0.0858652914735299,0.3099525871351044},
{0.16947709380206644,0.060776006176571244,0.31813357880662446},
{0.20034643110780773,0.04714574954281175,0.3148944673747493},
{0.20626638416442622,-0.005214341628543256,0.3362656047448714},
{0.189815850192709,-0.015950114925938494,0.34578623635902167},
{0.19759363153958684,-0.047173582502656325,0.34802417291606325},
{0.12660790701188945,-0.07577831575288073,0.3738701900489648},
{0.09160697834262926,-0.06604552129878288,0.37797606583140736},
{0.0686422133192082,-0.05198405139528682,0.377987495214643},
{0.04973813031233819,-0.06006655998750065,0.3826229855407269},
{0.043323440498120674,-0.0845841615163,0.38832943924837104},
{0.04671935269888838,-0.11097454685012051,0.39308381832059575},
{0.016237905797148292,-0.12365337585481781,0.3974602766237221},
{-0.01682957558105659,-0.10388658583281238,0.3997194496505069},
{-0.04626305491831554,-0.0950389970040732,0.3985923358912956},
{-0.08004978319765164,-0.08458424332170146,0.3940126304745756},
{-0.11281900526927653,-0.055761713282905453,0.3858015684123601},
{-0.13167670992554537,-0.031060521309839908,0.3753998458783049},
{-0.1705154327645524,-0.010233123195212523,0.352394937775728},
{-0.18189964773207679,0.011533462548081337,0.3392143962437416},
{-0.16886544118963231,0.047338174970438046,0.3314920970200014},
{0.34980686188265364,-0.979361217518587,0.0820908964899315},
{0.3489429745324398,-0.9785778989271626,0.10047413406723586},
{0.3516827649170093,-0.9845132537098237,0.08797351441123977},
{0.34248189574354276,-0.983226582233449,0.07143302849494243},
{0.34080129513716684,-0.9984270414906729,0.07995893511208249},
{0.34812917971053564,-0.990505670416038,0.09743823362708887},
{0.33924560181718355,-0.9671889838674802,0.08525154060566825},
{0.338879312288805,-0.9685747046865246,0.07367103835812301},
{0.32758823117725616,-0.9683814686417382,0.06155527699423416},
{0.3405649380841291,-0.9724567662025514,0.05118091146132394},
{0.34789492941218814,-0.9800112804230364,0.06085380842541972},
{0.3480992697434198,-0.987943026972358,0.059650083376516706},
{0.33765959269030044,-0.9901211446575758,0.06623806890330747},
{0.33019488805174896,-0.9983981854321059,0.06320020725834052},
{0.3408324608703158,-0.9992350005064685,0.09729098602923687},
{0.3333332672869811,-0.9978972643986365,0.1058676789269879},
{0.3388758275911834,-0.9877969650216235,0.10613676770228875},
{0.345435752802858,-0.9892483405186001,0.11754182817348162},
{0.3483775334725805,-0.9799383312530708,0.12375506528089895},
{0.34133747642349077,-0.9738643726225117,0.12650323487587753},
{-0.00796412767700695,-0.5488004149152965,-0.32752326547078964},
{-0.03275636799951407,-0.5491421436998899,-0.3210266034570637},
{-0.048794092792012404,-0.5478710354355454,-0.3358001033254279},
{-0.002056373186879585,-0.5488435369859557,-0.3377402830947844},
{0.05660864513565255,-0.532629885959143,-0.32605020729278916},
{0.0633407218466875,-0.5155401904495298,-0.3178570977977716},
{0.08863872459506099,-0.49510242402530646,-0.31008616579405424},
{0.06648709570070079,-0.5436783694341695,-0.31632499099361044},
{0.07435825207012728,-0.5559579211479424,-0.31117157792185024},
{0.08409447066460142,-0.5618743077015378,-0.31139431703156073},
{0.0734971004200278,-0.5813253065632588,-0.31415769499436025},
{0.08736290348966486,-0.5809054398089485,-0.313959595246613},
{0.06757146348161812,-0.613197540906896,-0.321608660575094},
{0.03852908089513524,-0.643336327292392,-0.33253466967761613},
{0.01730380255585569,-0.6837130437372435,-0.3295777326980555},
{0.014223692139450624,-0.7245736603800175,-0.3258719660718536},
{-0.034987423341160895,-0.7472435264927663,-0.32963451202113087},
{-0.005570863910707209,-0.7891932025093528,-0.3356511240028432},
{0.017916676937272905,-0.8102836251754932,-0.34147401441939934},
{0.07461143872530633,-0.7975018552283129,-0.32562093822934746},
{0.13523950408292862,-0.8118510719130946,-0.32238119891445577},
{0.15898067779736855,-0.8107817903230998,-0.3189362682796753},
{0.1685131435721306,-0.8084824147223219,-0.32158158829924255},
{0.17829874500649673,-0.8142013506593427,-0.33256782211337255},
{0.1820199728535788,-0.8139585097314317,-0.3425761233483602},
{0.17881666881458078,-0.8065691850519185,-0.35299658994343286},
{0.1574851666926807,-0.7838592778511639,-0.3262340803375332},
{0.1394745314709707,-0.7677822864659543,-0.3453102394128088},
{0.43063352866761595,-0.3093968267352232,0.06272399039371068},
{0.43223254697815033,-0.32768419581884534,0.046080789827794094},
{0.4328066211638854,-0.24669602604801702,0.07440534064035044},
{0.42869553745835093,-0.26268953024017916,0.08105912851975927},
{0.43644507150633777,-0.16030957414100538,0.1044712022912605},
{0.43349826564766736,-0.17062791147316292,0.08774922418612455},
{0.42738422555760536,-0.23726135278748367,0.05804963612747595},
{0.42948067914158,-0.2963213127146616,0.04215269843092814},
{0.4208836730064739,-0.37035072406935615,-0.01972418481274659},
{0.4391511421293797,-0.3998002160171493,0.02075274962336726},
{0.41327744502335856,-0.3037305756015723,0.07262558020089237},
{0.42332915092948326,-0.2554984678568084,0.08590364864515469},
{0.43198232975280426,-0.17336871539478468,0.10713866076480287},
{0.43893675142025174,-0.07443004268437459,0.13057047726066437},
{0.4376803532544646,-0.07351954856587996,0.11855033366221424},
{0.4326324734002474,-0.19113635776426666,0.06958950233864086},
{0.42804247537664997,-0.27286974924480856,0.03018044286457933},
{0.425206918489548,-0.30817548590239846,0.009150475452541886},
{0.4253845105793107,-0.288495911062451,0.03488258546953048},
{0.42059381840809046,-0.3476485979434126,-0.019874623883664178},
{0.4190179414645053,-0.35383943843175664,-0.04607235962181022},
{0.41076537962835874,-0.3729496806120316,-0.06295290315521358},
{0.40338602564615594,-0.41009002238753023,-0.07936653651641544},
{0.4247363111381627,-0.3961194956551024,-0.018587146039760763},
{0.4448990563018659,-0.42637256949850794,0.0018911926763741829},
{0.44772140108542463,-0.4428410581622387,0.013479268829207284},
{0.01171370906376103,0.9753865395391885,0.01961033294203985},
{-0.009295382034781252,0.9859278805206018,0.03216698504841986},
{0.007107595376071725,0.9730619147543637,0.06494484237073628},
{-0.014271740595131423,0.9806917090675528,0.07242654872149448},
{-0.053683933109828906,0.9960065790219921,0.05742901148107415},
{-0.04233826548492755,0.9967607674536342,0.017833762913239584},
{-0.013636856311084198,0.9872619693824172,-0.0013722457695676663},
{0.3200139391729531,-0.5212578302490206,-0.18371023977742718},
{0.3344628936406664,-0.5327931312938198,-0.17900814179360414},
{0.3268069385975281,-0.539906380804264,-0.15284892683788578},
{0.30719715332671504,-0.5242515254764498,-0.15861070118268022},
{0.3209193262970982,-0.5398040889929536,-0.1272416582380056},
{0.3452498526840097,-0.550106053558329,-0.13460103151649827},
{0.3449461389757257,-0.5451423897089179,-0.16173011325125441},
{0.36153750678933705,-0.5427621202525602,-0.17464562440577971},
{0.34392889518274383,-0.5181485493013366,-0.20068552565223263},
{0.3298001483045875,-0.5083058434471047,-0.2050848416594224},
{0.3120123839311565,-0.49316244717584196,-0.2073417655688703},
{0.29720437386985277,-0.49949772838060014,-0.18660916185362772},
{0.28940365407591784,-0.5110575083637829,-0.14706423423178272},
{0.30424785505931873,-0.5247279686339436,-0.1394650786974682},
{0.3047146122447954,-0.5275037873922153,-0.11979290990237436},
{0.3328562568037161,-0.5416468002824639,-0.1032089991291916},
{0.3611732443350628,-0.5495560120996967,-0.10548160736516002},
{0.38292110620308745,-0.5536133156594074,-0.1359942911813726},
{0.37292188324284875,-0.5524853498491313,-0.15368707842127513},
{0.38056953025690143,-0.5413229029505779,-0.1762934582304348},
{0.3639714756485249,-0.5293755162262797,-0.19264084940218465},
{0.3642029689986018,-0.5087646166378783,-0.20573559406654143},
{0.3458439479449517,-0.4917744570537125,-0.2160334853603675},
{0.3306463253165845,-0.4862737205578237,-0.2182313808294032},
{0.30451701926557423,-0.4658404948645865,-0.2197152192594665},
{0.28432288632548935,-0.4753542771355764,-0.19684982761309766},
{0.2789606739969127,-0.4891673943394356,-0.1697617601319027},
{0.28438381966310744,-0.5144683155220673,-0.1504295883966696},
{0.29707752237716517,-0.5241842495641974,-0.11611108569861138},
{-0.23160827922912214,-0.836833607535566,0.21574002494987188},
{-0.2451841883912867,-0.840543345442167,0.21560362984781392},
{-0.22515214488617977,-0.8393014162083642,0.23274451216578299},
{-0.21413028747572388,-0.8329401973792973,0.22951103468253195},
{-0.19504653112218845,-0.8263087402496774,0.24772701421085558},
{-0.21175609817927102,-0.8529294035390385,0.24352478335195316},
{-0.23710236823933462,-0.8692164892561867,0.22894342418592173},
{-0.2564593631330824,-0.8462113792961257,0.20643760446333967},
{-0.2661081232541097,-0.8324689419591469,0.18421079640501742},
{-0.2545726192894186,-0.8355991353421918,0.19824428354916765},
{-0.2462336921974633,-0.8329935323762478,0.19402712904773772},
{-0.22738923045456433,-0.8288169151072718,0.21654782247968013},
{-0.1977000380563508,-0.8138690241838807,0.24317594174706206},
{-0.18085853269797936,-0.8004213040858384,0.24811101301504335},
{-0.15755748904203767,-0.8115106392660312,0.2518875211277788},
{-0.18666910237114606,-0.8429467966369708,0.2544058876635085},
{-0.22547600078416105,-0.8799245411465577,0.2461170934713601},
{-0.2541812027538913,-0.88749478006506,0.21730013682394297},
{-0.25907544250245496,-0.8706777547074801,0.20048653560673935},
{-0.2715778958743336,-0.8416053314777207,0.18059181043607858},
{-0.284801842077457,-0.7937083060942817,0.136860610383067},
{-0.27351398218639256,-0.8153118079888859,0.159313339462495},
{-0.25456777577220624,-0.8278779707699941,0.17865302879540199},
{-0.24819480458792884,-0.8091558219136122,0.19761924566071706},
{-0.2402845176139908,-0.8207874164152181,0.20528841280739862},
{-0.22501046005562853,-0.8115456551650887,0.22525257270298485},
{-0.20520322416824105,-0.8048790206504239,0.23649806058330505},
{-0.16866225569569168,-0.7886598578518853,0.24086552241708398},
{-0.1515007446052476,-0.7834363311766082,0.24670413646924963},
{-0.11953237935319863,-0.7759178060207361,0.2436898932123391},
{-0.24040152164867412,-0.9014396932075615,0.2559961113621796},
{-0.26047263307623164,-0.8987110485433418,0.2214374216309234},
{-0.2735258567185012,-0.8799981394476961,0.17510119656181736},
{-0.2769416688799853,-0.8530052711432622,0.15901222865334913},
{-0.2855122316846642,-0.8171770518856692,0.13685426780843257},
{-0.2906912987178476,-0.8181523093219425,0.11767676990165352},
{-0.2940529865133772,-0.7684367275529946,0.10349371698580673},
{-0.29127408677245226,-0.7132773097257238,0.11114461071813127},
{-0.28389377981044267,-0.7656438868967678,0.12583654422677107},
{-0.2795345261394151,-0.7924357380816042,0.1395611394869643},
{-0.2654186067731741,-0.8142707343886932,0.1545693762364538},
{-0.2606941982253105,-0.8164148082780005,0.1601399309864879},
{-0.25898891576065886,-0.7939574694110787,0.1748984764024981},
{-0.2512693118655363,-0.796386047613031,0.18806260479620532},
{-0.2751583918706713,0.043274711570236546,-0.21600383993279668},
{-0.27957845776482654,0.014289180550560289,-0.2100031959404905},
{-0.28636201450877335,0.02149921010058894,-0.21635809131826372},
{-0.28669109957800265,0.03623732966401614,-0.22748888696329833},
{-0.30791947802327607,-0.005561096664492683,-0.22542521928438528},
{-0.2996094877328814,-0.0009644511552189506,-0.2192445513508359},
{-0.28989813266841874,0.005969746517129544,-0.218322405805873},
{-0.27817764013078156,-0.01972647961361936,-0.2073264254624807},
{-0.26950701444638075,-0.010986937659305154,-0.21432246908075744},
{-0.26517558204871167,0.014657495028227545,-0.22727060465435686},
{-0.26569729440305145,0.027883285571311634,-0.22790003984873908},
{-0.26793979081441976,0.05979402157403596,-0.21878823019729118},
{-0.3004362917384365,0.014228388513181079,-0.23576604991472694},
{-0.33234556905523577,-0.031541422330510445,-0.2311095047906356},
{-0.33950927549986937,-0.04893864240522731,-0.21275388769161344},
{-0.31588972516927694,-0.022976634774694596,-0.21584572071581007},
{-0.32367626075652123,-0.07200762432291302,-0.22900052754337963},
{-0.3013421250738624,-0.048160998133923764,-0.23008387222557455},
{-0.2992646375941379,-0.06803761775066174,-0.23308076955014745},
{-0.2900324008300382,-0.056902323870953425,-0.2238347522943253},
{-0.27863633151615363,-0.043128599686335096,-0.2056471018702941},
{-0.27068466694518284,-0.030704850547536796,-0.2051361899537656},
{-0.2616300212084381,-0.016283576052943175,-0.20699580096433262},
{-0.2559249454437254,0.007318668716808417,-0.21809922048488167},
{-0.25848282717559434,0.0185555245336606,-0.2304481346798489},
{-0.0025047507172181057,-0.4805737517874607,0.2730797692082003},
{-7.573905287857149e-05,-0.4464133258100766,0.26196421274081316},
{-0.0066386889395923625,-0.4688784468142175,0.2594012240145946},
{-0.007876266550999609,-0.47947626327007187,0.25336031582864205},
{-0.004978347387773024,-0.45314286017921873,0.23576933275486434},
{-0.00044888961090355664,-0.4269908589725402,0.2520383246045757},
{-0.039844510688558016,-0.8292555864798448,-0.39590895936151427},
{-0.001000055097000232,-0.8399547215814542,-0.3785286804417589},
{0.003205232309175758,-0.8535749278373174,-0.39488531243665276},
{-0.04048890989696452,-0.8335646477562281,-0.3997194496505069},
{-0.038293318790471945,-0.8416127885181492,-0.39449405844952057},
{0.008956735295248968,-0.8613400240349264,-0.38801616068256056},
{0.055578518585549054,-0.8663429172927753,-0.38827748325675965},
{0.04158563029350574,-0.8605792391131828,-0.3908929336807079},
{0.018052070188764653,-0.8541291838677375,-0.39179621405016285},
{0.060783427626338205,-0.8547275340719643,-0.3797301223762751},
{0.024518240035893993,-0.8377258632991615,-0.36071228311540143},
{-0.015446773196270457,-0.8218471331476863,-0.35476699906933445},
{-0.02481378807773911,-0.8255079142399279,-0.36656386704212934},
{-0.05418757496970364,-0.8135493424861906,-0.3777631125600482},
{-0.07698069526229048,-0.8113308586161768,-0.3947764549450677},
{-0.06809067386556174,-0.8176632224490846,-0.3995628103676016},
{-0.07396537366145131,-0.8212893116766509,-0.39810401713928556},
{-0.06096282899660385,-0.8401607638899999,-0.3769226098681721},
{-0.021090780697572885,-0.8571493033022533,-0.38152351032073073},
{0.05696120516788379,-0.8718438152746513,-0.37794743287848087},
{0.11414465330103006,-0.8687912732785458,-0.3779418807352582},
{0.0892634373867213,-0.8643713295612888,-0.38348496799373494},
{-0.08506739399091275,0.5184110564602453,-0.3071683381708489},
{-0.13538209089771167,0.56638204561311,-0.2916734049660773},
{-0.11763444941768814,0.5454622042075845,-0.2930809295806361},
{-0.13273307263655268,0.5708650102993346,-0.27541748391967025},
{-0.14401315145280608,0.5737517136232955,-0.2739368475867507},
{-0.16775021152420005,0.5971912803841416,-0.27703700882578136},
{-0.1430808939102938,0.5692724769260814,-0.30239989600642386},
{-0.11831410781654118,0.5450636142945142,-0.31997604574233807},
{-0.08901880842646352,0.5231033877290577,-0.32075344672225276},
{-0.038184516544092995,0.4835144881103044,-0.32837069824881976},
{-0.03471673457969604,0.4855888542358788,-0.32168533985888575},
{-0.0684894305766585,0.5181309292677835,-0.30738228373110393},
{-0.10117419866412748,0.5633685322303659,-0.2863251548009588},
{-0.10193206515161297,0.5917326524218599,-0.2739597042284063},
{-0.1510688928284162,0.6107910193535171,-0.2501061883247598},
{-0.17576003442358545,0.6091006520321305,-0.24415421854633534},
{-0.12977465678531852,0.6092024572606629,-0.2528080443760136},
{-0.14200019462354932,0.6209053000173285,-0.2332042372739556},
{-0.1411364591976524,0.653543426277059,-0.21825519045086572},
{-0.12489062996304635,0.6777978821398547,-0.20471484432778178},
{-0.1588279704857734,0.6793678021628413,-0.1902124741201242},
{-0.11813422623794478,0.6960136385625381,-0.20517078088969878},
{-0.10910572104540084,0.7059692539317477,-0.1992599252311698},
{-0.14639827398804656,0.7152143383935115,-0.18783068435818825},
{-0.1717255067625367,0.7159818101100203,-0.17435670260145464},
{-0.1864697372956954,0.7251877862778364,-0.15410957888454999},
{-0.19075062139210325,0.7530559702533121,-0.1546249699124116},
{-0.20977156075897072,0.761112784512606,-0.140175690347908},
{-0.2279201623838919,0.7642748320690615,-0.11739013758616217},
{-0.23724814652718335,0.8077121966816201,-0.11599993871819263},
{-0.2465421474318098,0.8249970735047226,-0.09992250112170215},
{-0.25810174574325684,0.8380551204784562,-0.06554419973756838},
{0.08868436882186449,-0.5957894598371226,0.2385177350171536},
{0.110990518557954,-0.6023998419829867,0.2384696897486962},
{0.09092670162242994,-0.5870118210010975,0.23534079356558912},
{0.08606231128373683,-0.5895563089576874,0.24149426810879654},
{0.08792341179005554,-0.5749180482916824,0.23330411741953389},
{0.10004463074287179,-0.5735987927677304,0.22983892348056553},
{0.11702921906047437,-0.5755864302940246,0.2281259619322527},
{0.12372807321683725,-0.6066675649714264,0.2352124430154795},
{0.10974016018057497,-0.6042931313211767,0.23060647594006808},
{0.09181762087699853,-0.5970163124416733,0.22743788395149384},
{0.08000785633578045,-0.592133542447842,0.22449693408467997},
{0.07306581596896786,-0.5812902906642009,0.23914751443166668},
{0.08352862376495825,-0.5774732357573414,0.2451839041971971},
{0.08777555649493538,-0.5724974137129362,0.23958922535298832},
{0.09024377100751753,-0.5621492471566565,0.23111633394804765},
{0.10223915200469827,-0.5498369499093188,0.22588610029225675},
{0.11006188913811786,-0.5476932000543938,0.22029855445409402},
{0.1197394543221371,-0.5720375058706199,0.213926798664353},
{0.13189290354072947,-0.5938434846331547,0.22125857271271968},
{0.13497874883450078,-0.6063597174343479,0.2273567064330284},
{0.13124497820079684,-0.6119852783488201,0.23063320399578865},
{0.12705916154258126,-0.6147301342938347,0.21918538161018475},
{0.10838302131888229,-0.6067234933058447,0.2176453715543142},
{0.09028125912955255,-0.5947341202248376,0.22074062978129497},
{0.09116263371234311,-0.6099942358054902,0.2178175336777526},
{0.066508636019078,-0.5874417381333041,0.22506188962416934},
{0.06440752058962672,-0.5781806856821343,0.23609069730652776},
{0.07460214796899506,-0.5694179609269664,0.24456111648849121},
{0.09047178922164323,-0.5487551860899472,0.24350101410198746},
{0.094124099736404,-0.5644943392279691,0.24324019829631444},
{0.10461526744651325,-0.548278418898071,0.23080368432766155},
{0.10687735890755613,-0.5342811439241744,0.2211932218834215},
{0.10076788717108358,-0.5242661155229246,0.2109371150888199},
{0.1021745618593931,-0.5459741795943321,0.20403666586301003},
{0.11208906098389185,-0.5672158508861427,0.20280801991407374},
{0.1274627968303482,-0.5898045001713369,0.20652557926698278},
{0.13672561181607723,-0.6112407047078715,0.2119107916622696},
{0.13806837417526527,-0.6143422035183368,0.21995520443518035},
{0.13535148186625595,-0.6188341253648197,0.22164956322271465},
{0.12408153523330043,-0.6269305759347433,0.21338083047726994},
{0.11511078146697933,-0.6159939480661458,0.21508003278201665},
{-0.037880077211273795,-0.2517122132148107,0.3310197876913021},
{-0.049063199628246006,-0.240572785506308,0.3387528066098599},
{-0.06303451572967772,-0.23864918142362584,0.33986202729671056},
{-0.050279671446070914,-0.24894709290320036,0.3309288030863291},
{-0.08262139336326026,-0.22417594987501305,0.34099611257598056},
{-0.07278881013065598,-0.2212299960674072,0.3372567897990538},
{-0.05900389560455953,-0.2254022351537923,0.34245405375323185},
{-0.04349536145498579,-0.22936202879975207,0.33430090566563436},
{-0.022233104949420754,-0.2502212821501981,0.3270466608273086},
{0.0016959853338936299,-0.27132775354873845,0.3170303150403726},
{-0.04494704398781991,-0.2565601298579794,0.3162265907821135},
{-0.07951572460213506,-0.23389528893417877,0.3248250566655525},
{-0.10203628204587754,-0.21649596210477182,0.336101629536028},
{-0.10874665589014006,-0.21278330576391263,0.34390891501023774},
{-0.09043478874479363,-0.21567527756821064,0.3437182329938301},
{-0.09744607047831005,-0.20332123619314532,0.3438919345461873},
{-0.08178244072438111,-0.20672312656266814,0.3389942090375942},
{-0.06580149525495817,-0.2088861676186334,0.34367239647121267},
{-0.06617734114160077,-0.21630094333967778,0.3452275628369214},
{-0.04448744211895333,-0.22178554823535743,0.3407587419858907},
{-0.027030255497726842,-0.236329378907857,0.32762379474754066},
{0.0031096655393119455,-0.24351525461629228,0.32213053547782894},
{0.039965117348130075,-0.25720873407650363,0.30930353776770714},
{0.04384047188364319,-0.27149570003798096,0.307628043093273},
{0.06446553655539466,-0.27752345774004333,0.29907968992389256},
{0.02423318858322612,-0.28032456605385886,0.3063074914317912},
{-0.00489272794224799,-0.2782607368889584,0.30437991500630207},
{-0.04880028875436886,-0.25857240780864454,0.3119999022329835},
{-0.09042524407301547,-0.23156608410927854,0.32358284376886387},
{-0.10073383487591082,-0.22177403917153593,0.32982981551151835},
{-0.1077359777774331,-0.22581732001054322,0.3376006455240858},
{-0.11454031628057969,-0.22963324026586018,0.3401162976078572},
{-0.12332772183161554,-0.21742907063594114,0.3392305257191351},
{-0.12650164392017987,-0.20814856443533578,0.33317504767245626},
{-0.10858120712166229,-0.20644145887887969,0.3418019234031814},
{-0.12538366899296272,-0.19657678774314605,0.3466875512740254},
{-0.10515765531927175,-0.19229577190816957,0.34760234070730184},
{-0.04131438907997875,-0.2161729571954475,0.34677539540150776},
{-0.011338597300916098,-0.2310212303879897,0.3388905594691009},
{-0.0031528991627911896,-0.23877789744202263,0.33030881163498294},
{0.054820879453335115,-0.25195602730827704,0.3099024138638007},
{0.15143550426636176,-0.2432187546570481,0.2871713519987043},
{0.10905120040133269,-0.26770733864129315,0.29082696553935083},
{0.12915904032933997,-0.2671563250795135,0.28289852201591503},
{0.15117286536888427,-0.261857254834395,0.2692277993310251},
{0.07010092474212279,-0.28024156544358897,0.28763486671554034},
{0.028171492906383558,-0.2839522765157454,0.298199166329759},
{0.02503624458697176,-0.2903642359418875,0.2965470573760706},
{-0.02434003281200843,-0.27998267472087024,0.3079071981825874},
{-0.07345620940577269,-0.2589366702629189,0.3185535263039284},
{-0.09930195243745879,-0.24043110067575682,0.32793881566216193},
{-0.12436067969853655,-0.23447669904585194,0.33432333734416536},
{-0.1321213084712984,-0.22355052739493472,0.3283517927018149},
{-0.14771595927325304,-0.21193968278029432,0.3190741443782224},
{-0.142730269585095,-0.20457775547342294,0.33036769771274843},
{-0.12782806326000437,-0.20106984424117166,0.33846668106289457},
{-0.14235872220045753,-0.2026402094130311,0.344561491571569},
{-0.13911155665496375,-0.19119358223621505,0.3454154496583771},
{-0.14678539414638433,-0.17736911745452166,0.34162504100183666},
{-0.12549002345174412,-0.1742927456512051,0.3541935134575269},
{-0.09414502810788178,-0.17140612413264558,0.37072402973892155},
{-0.056534832228135996,-0.17196880930664188,0.37882098601496345},
{-0.0330526767253522,-0.15684267822472311,0.3879670816913026},
{-0.007346334347422683,-0.13706227025939044,0.39548694548101704},
{0.05079985818279346,-0.14050874138549752,0.39123356924766334},
{0.10695237552312294,-0.12151181455998451,0.3809224052930487},
{0.14203565460907233,-0.13829131142403261,0.36785556370745204},
{0.1889897749989126,-0.14062951378068803,0.34678572944228975},
{0.21132727426470246,-0.13924614300772273,0.33357943302013804},
{0.22397789634200554,-0.14402686448163252,0.3211097666157287},
{0.2580314695913448,-0.13841459641369722,0.2845926183887199},
{0.23205201509973236,-0.16270021907204985,0.29455791972994666},
{0.2544410655797575,-0.1568802874612486,0.26947199801611915},
{0.2596735079813884,-0.15997724766554336,0.25639279637804396},
{0.2607686464526982,-0.1804582965840053,0.2587013118732239},
{0.2348671461342513,-0.190082881615283,0.2692942848118659},
{0.23767011897377596,-0.20677483926289067,0.25975047039686183},
{0.22649174445731324,-0.20766612398574646,0.2759842837991203},
{0.21766040728086583,-0.20664871764436948,0.2834641266865773},
{0.20020802911739394,-0.21881633194631198,0.2808167594071573},
{-0.4073435096175336,-0.28395357371568314,0.19993206709475683},
{-0.40700761663904844,-0.2775600948734213,0.1917296466576797},
{-0.40570935429345095,-0.3168291098745925,0.19235017568737847},
{-0.4093206101831537,-0.30534422433007824,0.17533019750316858},
{-0.41093401562027077,-0.23539546082193538,0.17701116251542387},
{-0.4174148721929857,-0.23254555611733974,0.18184037546907184},
{-0.42084411850124565,-0.24993142861422238,0.18985436194467034},
{-0.4165603871519031,-0.18521024380474962,0.17325370337474783},
{-0.28128126694409317,0.325709496294879,0.11362789654792675},
{-0.28175452819019153,0.35169776558410304,0.11446026863282173},
{-0.2795936555085694,0.35994197901966724,0.11600014163808461},
{-0.28265353343061317,0.36991429225244965,0.12051005217363117},
{-0.28259116053041045,0.3986834054888935,0.13272496699615527},
{-0.2624138667541371,0.38149895595139227,0.13576439887986755},
{-0.33670622191735106,-0.5575446590865842,0.09808515074200853},
{-0.34581448525152436,-0.5507794607496195,0.11405488037216595},
{-0.3453504839519106,-0.5708753347784463,0.09837366670654962},
{-0.33610171081022555,-0.5826437514700503,0.08384705766467372},
{-0.34195220045690766,-0.6121640858331192,0.07239277690198395},
{-0.35510635815330444,-0.6011076587348864,0.08487319487344523},
{-0.36392306597418805,-0.5854539380586148,0.09626697894812733},
{-0.3565824962515503,-0.5569258830297743,0.11321912451839149},
{-0.333074417998167,-0.592117979235812,0.08034002610609031},
{-0.3376264423793596,-0.6227007862172118,0.06294717040266296},
{-0.3469501907027068,-0.663651861573092,0.04794233442057793},
{-0.358820494428245,-0.6661311803721195,0.05767884411479237},
{-0.3572244338610577,-0.6351103500869115,0.06944527729101246},
{-0.3685498031223134,-0.6519416425189914,0.06399485324185077},
{-0.37203250554201445,-0.6244236972146789,0.08129944197948685},
{-0.3794363788340977,-0.6471467357759831,0.07478949243126305},
{-0.3779631581077021,-0.5806807554305351,0.08007732877618319},
{0.1560380057674923,-0.5940008941617232,-0.2936494919946453},
{0.03318110483123212,0.4166035129409895,-0.3417709191560197},
{0.07030018888883148,0.39894197217722976,-0.3367480451944607},
{0.03577892141032591,0.4066074517063977,-0.33567888578136434},
{0.005679657657823693,0.42081060644044505,-0.33985606931370393},
{0.03518719213157996,0.4017308415530573,-0.32959807780764483},
{0.06263777015656817,0.3926662665529067,-0.32814431083068474},
{0.08469401714002389,0.38920844891137324,-0.3311664977108015},
{0.12241922291499087,0.38378463392825723,-0.32868531438606485},
{0.11581448321701346,0.39559981993653714,-0.33490168665893383},
{0.09073608016326747,0.41255536946142923,-0.34081284616609686},
{0.05011953577905823,0.4281557551407501,-0.34614993148752476},
{0.013838742480271582,0.4445854181110112,-0.34769614175538294},
{-0.00025043289413170566,0.4337054484509985,-0.3439913482947363},
{-0.02589536703815141,0.43777904403449786,-0.34149800677500547},
{-0.01955037117636522,0.42777593053685353,-0.337262463056767},
{0.0018577592337516735,0.4153767410794326,-0.33297038224443426},
{-0.0039319543116683444,0.4144236125354642,-0.3189730679614484},
{0.02901686355085168,0.4021007772650449,-0.3180661403459768},
{0.06303271176121396,0.3907444462529399,-0.3179645369749284},
{0.08860256342038249,0.3850391271968384,-0.32267186306759155},
{0.13180282091998843,0.3779593530941253,-0.3205113346061004},
{0.16177175591903611,0.3761395813140801,-0.31761133843560246},
{0.18127841857563037,0.38359861269491835,-0.31967464170863624},
{0.16457647110737153,0.3911906554089352,-0.32516548825020813},
{0.06866234594723528,0.4350871979896435,-0.3304485097629267},
{0.01670762072597194,0.4482472934832984,-0.3440901543460172},
{-0.04662101835667572,0.4848050904955813,-0.3422970490020395},
{0.36692354892512474,-0.6234225032165048,0.09843764490495542},
{0.35695314165195596,-0.6217932912759688,0.1049459689692277},
{0.3819580887672101,-0.6275897171139417,0.09864464975497829},
{0.36397098906574726,-0.6042984816069152,0.09337484034580293},
{0.3814427795447501,-0.6037079124774996,0.08994936877249707},
{0.3948360703657959,-0.618459649984254,0.09863045067457821},
{0.4045795239574659,-0.6292053111111503,0.10698370327346315},
{0.38805101456442714,-0.6406341057728512,0.10309197597116768},
{0.3682988549603932,-0.6372254074940725,0.10019064329164294},
{0.3508981087541501,-0.6230836918037616,0.10204257415614093},
{0.3414182077306753,-0.5993335205575666,0.11208979138926213},
{0.3499458715703356,-0.6038233356493594,0.10225970056538351},
{0.35360799023401174,-0.5739231756199863,0.09093987388568021},
{0.3681530766725445,-0.5871998693085405,0.08615358751965405},
{0.38083968781446065,-0.5917935963835562,0.0796178947677509},
{0.3926250445986184,-0.6067510521644739,0.08433787095022512},
{0.4038358820481679,-0.614634488905793,0.0956325599987016},
{0.41553110627841744,-0.6156828580604269,0.11472354072535486},
{0.42027360975612593,-0.6346828648061853,0.11659801588361192},
{0.4068057474683863,-0.6382692369801282,0.105733943031682},
{0.4097174970565022,-0.6430087019714957,0.10109976902887648},
{0.38208530466577706,-0.6437605701044777,0.08943879151442918},
{0.354656317954741,-0.6329999948967241,0.0694161758162411},
{0.34149050883187615,-0.6211075644036967,0.09210413685883456},
{0.3243349960959355,-0.5926847185580169,0.10521626782702577},
{0.32010070814373026,-0.5626634620990707,0.12420162928110329},
{0.333135533007521,-0.5733071554490393,0.12154361348818912},
{0.34054876823723873,-0.5732839737105934,0.10309123653533091},
{0.34427378463057645,-0.5392686375807962,0.09195785711449882},
{0.35523181045490454,-0.5543562680660357,0.07841373306923737},
{0.3656631391074415,-0.5731643359669455,0.07650990570796545},
{0.3776381250618656,-0.5778392809319235,0.07546748922429902},
{0.39586822930204274,-0.5972173295612707,0.08079678284683772},
{0.40528158428743133,-0.6081951331694169,0.09098443976855511},
{0.4002687203322718,-0.594810311863444,0.09513988006262548},
{0.412881651367648,-0.601512935442722,0.11487045366474624},
{0.4246035834678698,-0.6036913771623221,0.12739612914656764},
{0.43322612244990855,-0.6245337711632082,0.1238796315343842},
{0.4290800228453165,-0.6342942859619225,0.10665501448234753},
{0.1048386663114747,0.750369960014566,-0.11261159404826586},
{0.11540195238864119,0.7552001259480209,-0.11337814465720221},
{0.1338571872185123,0.7316452985637102,-0.10231873856746607},
{0.10381516068685213,0.7359164255067776,-0.10599828390647346},
{0.12785970388944518,0.7238046991677567,-0.10131848586261283},
{0.14300464065203444,0.7164898652119437,-0.09934469894695662},
{0.15508765329513524,0.7392150912709318,-0.09921575982291944},
{0.1246831980250834,0.7610627737896974,-0.10751661128132003},
{0.09405898263682434,0.780994024540916,-0.12149386518000996},
{0.0852798744907959,0.7708917798952005,-0.12032340730690703},
{0.0839393824971009,0.7519999825722622,-0.11071282374817648},
{0.18240735648905376,0.7033648663603403,-0.10389964069999952},
{0.16454115135967975,0.7132205410267264,-0.09781088910307376},
{0.18209979261486112,0.7294970897832006,-0.09878930826499377},
{0.16346341937795267,0.7460893903908706,-0.09470886333833398},
{0.1471371021275509,0.753048189178501,-0.09467583307947589},
{0.128743713243608,0.7596341741913829,-0.0925036935630133},
{0.10945073160772385,0.7750230865334258,-0.10695786657789642},
{0.09620781823794267,0.7913817859739207,-0.11808844974136874},
{0.07897102705479449,0.8081574942917134,-0.1270529204278929},
{0.07508381817292115,0.7955523230829921,-0.12691042498018157},
{-0.4412835858403751,0.05407394992306463,0.13188139394570408},
{-0.4501757564881063,0.07294418780428506,0.13616984663536075},
{-0.45320126551744944,0.05538404642927391,0.12176296989142796},
{-0.4415545136435975,0.027132065507094606,0.13988673879616423},
{-0.4429468001429166,0.0035714830596691584,0.13842839177912894},
{-0.4582576159491474,0.07251135223782039,0.11002324670999564},
{-0.45628882341261284,0.08475296961827755,0.1289183576828979},
{-0.45650187761271416,0.1042437662766155,0.12852888216644207},
{-0.44397381065090913,0.08990249321504006,0.1447190316700576},
{-0.4366298380360513,0.06955445562975657,0.14693112090745433},
{-0.42329559477875833,0.05629575700471272,0.14403138927650144},
{-0.4187900560513559,0.02706722144632247,0.1585809941354563},
{-0.41782574141554074,-0.013340944394563731,0.17325617559772505},
{-0.4316767515188112,-0.022378527861856578,0.15911227134732256},
{-0.43850703720793693,-0.0364371611364961,0.1267805700606109},
{-0.44813458104496956,0.0053308697045269865,0.11175965347389169},
{-0.4553841661626343,0.03370970211939395,0.05297516208092243},
{-0.46805262075505266,0.14545478520135544,0.07148417918143271},
{-0.464360066232394,0.11594369166143073,0.10310548236167469},
{-0.46447767690193764,0.14414258087804824,0.09708222289428606},
{-0.4556311409193397,0.13103375293574282,0.12155449573140184},
{-0.44602021420288607,0.12150100349809506,0.13503628937277307},
{-0.42655956974064496,0.10005580249221313,0.15287358851041308},
{-0.43160797654913663,0.09160992280587865,0.14685735049625034},
{-0.4214241910414842,0.08124619409997674,0.14174872003855857},
{-0.42685611007138596,0.07348725774285848,0.1483279470753517},
{-0.3821370184284074,0.050804585366350484,0.16161173233604745},
{-0.3896865892653457,0.047285975687437865,0.16064875527166692},
{-0.40265146307401467,0.011282515448568916,0.17431237576033734},
{-0.4039196539665089,-0.020970840698902708,0.18291371014486724},
{-0.4177127097236645,-0.03327746468852718,0.17432468694205644},
{-0.42687690139225615,-0.04502691421347334,0.15977359152494214},
{-0.43174451401384134,-0.04300863790830466,0.142204828710541},
{-0.4433468891134088,-0.06714690141598509,0.05863210439732935},
{-0.44448944390775175,-0.043135083561208404,0.07933582230658628},
{-0.4509399049929809,-0.006943576077304165,-0.0008773422139421599},
{-0.4563051164988093,0.03723171575293451,0.015779898071202808},
{-0.46600273250545415,0.12489235690694386,0.03815222306505217},
{-0.4690004000756903,0.1973797725655683,0.030748278591645573},
{-0.46722464066405023,0.20572781830376932,0.046341236977956564},
{-0.21207008537109173,-0.5644737508269909,-0.28692076930507115},
{-0.2183010689385916,-0.5417978874221465,-0.28470637889235484},
{-0.20473545344571228,-0.5626835639172711,-0.28858912991105135},
{-0.19959243497197932,-0.592745348047001,-0.2892909873211248},
{-0.18630220620790713,-0.5737247529002643,-0.29737848073079004},
{-0.22075590879923535,-0.48060293081800226,-0.2857721747223202},
{-0.22577918860057833,-0.5061406956364494,-0.2808851487227963},
{-0.22620225638962452,-0.5404656620236324,-0.2904470793158012},
{-0.21660433885682215,-0.5744417676825838,-0.2964230414498317},
{-0.1920130975929797,-0.6150334432247425,-0.293560493029872},
{-0.1519825677958984,-0.6479229213613616,-0.30788928386207065},
{-0.14731888966576095,-0.617840711379049,-0.31520910369774285},
{-0.16254877230732306,-0.5794984825201611,-0.3184221755141593},
{-0.19267015220323627,-0.5358562102505994,-0.3001667020378526},
{-0.21236502571566868,-0.4673275343293858,-0.2983585200646225},
{-0.23759838626075436,-0.4141802340292007,-0.2785795718476228},
{-0.24347282789154567,-0.4143287267690077,-0.27233551853922644},
{-0.23489223383231098,-0.46306791751254767,-0.2768687988594015},
{-0.2430114199293997,-0.4687087165422595,-0.27861744562369334},
{-0.22654933545995645,-0.5800861332153187,-0.29925770697677995},
{-0.1974672868154252,-0.6416382192676912,-0.31516290170683836},
{-0.19859227363419785,-0.6249635257470196,-0.3083505292758215},
{-0.2025866784018392,-0.6036466349197503,-0.2986452936803528},
{-0.17540919655441659,-0.6532626807632509,-0.302061854839344},
{-0.1377506983035231,-0.6889281402065369,-0.3125547043410189},
{-0.11071140065291298,-0.6709507275394988,-0.32148071480236057},
{-0.11605758974687727,-0.6435867878091269,-0.32674537790809727},
{-0.13772378857606685,-0.6088377390334377,-0.33117853372889744},
{-0.15655698348412533,-0.5718055259377653,-0.3256653968090334},
{-0.1819580174796459,-0.5387328621342563,-0.31478141549712463},
{-0.1990396992471373,-0.48518984998376213,-0.3049521246663281},
{-0.2173799560540214,-0.424405520373192,-0.2891227975404934},
{-0.2306856874728784,-0.3852084813764312,-0.28132864342683334},
{-0.24258794736297734,-0.35674235303651264,-0.2742945039892534},
{-0.2549025946563939,-0.35422380270423154,-0.26231315527444643},
{-0.2505514662803083,-0.42292966487542394,-0.27200209778371853},
{-0.243677148037029,-0.5244222278515553,-0.2839713701089328},
{-0.24128786086316756,-0.594070439377061,-0.2902567606428651},
{-0.2213417364025886,-0.683381689364929,-0.3124032124239602},
{-0.19364823564428785,-0.7130284704433093,-0.3282194081892452},
{-0.17388787000231828,-0.7254334946444306,-0.338509902999888},
{-0.16506861877713405,-0.7062070197375435,-0.33491802011662714},
{-0.1638088580906237,-0.6891755218654341,-0.32435104535953924},
{-0.15063887370505977,-0.698407070189272,-0.313251131784768},
{-0.1411983242669212,-0.7068721592712452,-0.3139569615376484},
{-0.10162634455497313,-0.7559433524558647,-0.32684061745635506},
{-0.07799508224066729,-0.7130446817241043,-0.32568748426743355},
{-0.06860350024096651,-0.6739744134770375,-0.33430767320339333},
{-0.07805893826217479,-0.6540691810931214,-0.3443920045909999},
{-0.1113938861189523,-0.6323946742348463,-0.33953906275888307},
{-0.09809121443459244,-0.6337434338861301,-0.3434731620719228},
{-0.1449297554786244,-0.5746794219355592,-0.3235173102054222},
{-0.16681295960256606,-0.5390875607934119,-0.31490202534392003},
{-0.24821974886093398,-0.9198812293511116,0.2438496527869866},
{-0.2644479081288199,-0.9294666646545372,0.2266275738272115},
{-0.23724693113264703,-0.9198886863915401,0.24832824141543586},
{-0.23685383280555417,-0.910652112878754,0.2549368610267407},
{-0.20363885735088505,-0.9011127159554301,0.2573298761896125},
{-0.22149734196269327,-0.9232656112399016,0.2687457838445603},
{-0.252845715763396,-0.9407412933187177,0.25541883614170857},
{-0.27564168330891764,-0.9510724369146346,0.23621236106187213},
{-0.2855453023150192,-0.947081437164029,0.20628220076071915},
{-0.2773963687992097,-0.9339300555392437,0.20351756703188648},
{-0.2842684379251522,-0.931085339634399,0.20229321746013967},
{-0.29131329705754966,-0.9242309797842656,0.22066879507712348},
{-0.28098815075372846,-0.9192105780456841,0.23918309765649576},
{-0.26586876702382023,-0.9191601614829914,0.24478989432420203},
{-0.20709807312109832,-0.8861427779451357,0.2689907325895693},
{-0.18991075614491407,-0.8864005340163117,0.27107932435573906},
{-0.17031581377363486,-0.886476725654918,0.26059277705720174},
{-0.1732016151133639,-0.8950917682874391,0.25699426687401306},
{-0.17685128129508199,-0.9171438304465255,0.28725765563486},
{-0.1976719522434472,-0.9143156498568584,0.2743514862322208},
{-0.20675924258501457,-0.9287026383265607,0.2910013555319699},
{-0.22976682476805288,-0.9393212046693808,0.27929022493196726},
{-0.2530179788155765,-0.9491447808085596,0.2670967951826142},
{-0.28244716602527714,-0.9580696151844539,0.24116117138767118},
{-0.2869019641556045,-0.9669636492954864,0.23091734390255436},
{-0.2935572319690947,-0.9609260037639229,0.21566144183128205},
{-0.2993875783636716,-0.9636906374927555,0.19752633597278976},
{-0.30269972077091395,-0.9708735947669328,0.18682227661097425},
{-0.2913101969515558,-0.945611418534777,0.18790718090783637},
{-0.2853994018502721,-0.9379484516000832,0.19325231078121263},
{-0.3066092604025763,-0.932067404979928,0.20523365949601968},
{-0.3052124342346789,-0.9220142807593751,0.21555489507668688},
{-0.2945971911034932,-0.9167314207326439,0.2300274583707863},
{-0.27118064353269794,-0.9118128242225947,0.2406443631077891},
{-0.18772006486324785,-0.1655198079697456,0.33783592954523395},
{-0.20687280016875748,-0.15234621670966175,0.3259651806708228},
{-0.2072095855698042,-0.17220208643943422,0.3337647052559698},
{-0.19175303184722156,-0.1759989587850996,0.33806345161491164},
{-0.22210558105882916,-0.18951192878369796,0.32182605152388166},
{-0.22848465152635203,-0.18526795485947567,0.31939723003054044},
{-0.23475905995073731,-0.13660390290840085,0.3043962686497438},
{-0.22892662592481092,-0.12868342425632756,0.3073013101949383},
{-0.2150274685619332,-0.13083155123143564,0.30814424367588694},
{-0.19015429719957286,-0.15220785509074478,0.32589048808963844},
{-0.16590191834404847,-0.16841412982012258,0.3359239567032716},
{-0.17047151070081126,-0.17380106437847173,0.3414091299871304},
{-0.17702265192470082,-0.17722370463496007,0.33940339646858375},
{-0.19906816965166865,-0.1788717201313509,0.321921169957649},
{-0.21460040824433155,-0.18585220160000543,0.3119918778667837},
{-0.24106378311961463,-0.20051364294204865,0.288563922160909},
{-0.24546470017537625,-0.20244559648772104,0.3022282618996677},
{-0.2458928951445205,-0.19774763127028452,0.3098225346076808},
{-0.24388416244872219,-0.19309967890057222,0.3090704221209022},
{-0.2405049077400302,-0.1820293916300312,0.30164648738211525},
{-0.2397493912986236,-0.16278727170571258,0.2981320519034938},
{-0.24928418693371626,-0.14214022156671086,0.2816860767236956},
{-0.2438614874788023,-0.10624821321930254,0.2905133013195048},
{-0.19898703356710787,-0.10148256731223736,0.3390588512408822},
{-0.19365809478877816,-0.1264460550250573,0.3339158327671492},
{-0.15824665174117195,-0.1495152802341318,0.3514927315005705},
{-0.14968473162403928,-0.18772068796542932,0.33977793240639487},
{-0.15435669759751383,-0.19373385562101694,0.3448018613389106},
{-0.175935751363561,-0.1854863179114108,0.3333751734319},
{-0.20158053889530264,-0.184700730016901,0.3134845310944586},
{-0.22229954591537424,-0.1918165739272208,0.29875988604930415},
{-0.23968369518678673,-0.20609113840231502,0.27221709725252263},
{-0.25803276785369034,-0.19775841258475518,0.2663338418865275},
{-0.26395728076463554,-0.1970644169924865,0.29120202843143644},
{-0.25392320445373423,-0.19830375182641385,0.30452042481381375},
{-0.2607896406934604,-0.18949385297719384,0.30478016652518947},
{-0.25924134279425265,-0.18264297994949774,0.301937760294927},
{-0.24835373335966782,-0.18449079717094977,0.29741592848132814},
{-0.24829239524467345,-0.169766942557207,0.28688265330001966},
{-0.2538785025826594,-0.14945043617335968,0.2799183225549148},
{-0.2504149288156036,-0.12963241897150155,0.28339356793418735},
{-0.2531472621597446,-0.12485493996623231,0.28913167395775813},
{-0.25674830512315583,-0.1274810495277529,0.29379095478196393},
{0.251655762706953,-0.9922947226742149,0.20706799157512093},
{0.2629223659425259,-0.9974227665098455,0.20669618071334617},
{0.26155407179881296,-0.9840512380504095,0.21285602757860667},
{0.22631648329028875,-0.9771493811342494,0.19169884639281784},
{0.24424662093453275,-0.964578678684563,0.20176457501964581},
{0.2782978643235415,-0.9813389661529721,0.22187809882944443},
{0.2699874278218659,-0.994865958872274,0.21673224372685493},
{0.2826001973712547,-0.9968931509037964,0.21688140578358314},
{0.27159319454681863,-0.9991442188213874,0.19868386646764288},
{0.23079043025900978,-0.9979363323210869,0.18738382713342794},
{0.22029117762545522,-0.9934382506341133,0.18553937349510696},
{0.21186991817774348,-0.9709431399822707,0.1809754140245605},
{0.2202133041952834,-0.950009640261921,0.18321998744320023},
{0.23840373069092594,-0.9481140816206456,0.18966004224391625},
{0.25605834136853173,-0.9481041927287367,0.19419991799178485},
{0.2702023869191731,-0.9560396672670686,0.2156401044327968},
{0.283683906459329,-0.9558563201141911,0.2165914502564575},
{0.2926837181417012,-0.9781350129828015,0.22491274775318956},
{0.21799877248232818,0.08315618023933162,0.28417465653161555},
{0.24809650318035847,0.08892618187021792,0.26279409666661374},
{0.2341613174437787,0.08961207235329299,0.2739296540234593},
{0.21446788243152293,0.08933421446391644,0.28553656772919733},
{0.2510215456150114,0.09120683465813466,0.2802390783469023},
{0.2591027984411921,0.09504504529174375,0.2546985385192517},
{0.2675770667266565,0.08450348120469027,0.2480064519006478},
{0.25857512810384575,0.05341618668679782,0.27216218245515633},
{0.22594429739855657,0.04456365234969636,0.3023932092116586},
{0.18973744980826282,0.08409390918207298,0.29524767950227115},
{0.18172880193191682,0.09293841809056674,0.29433872587510307},
{0.1951157512407361,0.09344760784403285,0.29686894781960077},
{0.22139660976605036,0.08915175867119285,0.29739388139442485},
{0.24658986866588478,0.0913395219569307,0.30067544558003795},
{0.2739785497493698,0.0976576197777464,0.29148778851011464},
{0.27233025059009336,0.09746462702434877,0.259157591592864},
{0.2772564454408099,0.09318207069804571,0.25216000854566845},
{0.2712564293315203,0.0721778911108157,0.2520262673383235},
{0.2779480708012513,0.045461583495820544,0.25983339026413804},
{0.28085361805256404,0.032080247949877065,0.2617152916529972},
{0.2740000496962503,0.010376803227633591,0.2773050596286504},
{0.2510603309369842,0.015124211842207351,0.2985196182731124},
{0.2255631755947222,0.00396095432649375,0.3226274448594025},
{0.23029905283491042,-0.02946259727935137,0.32861795773081864},
{-0.3353408855169852,-0.9183296687975149,0.09839549068781253},
{-0.3542338589253708,-0.9355229533183761,0.11749120444126582},
{-0.3358140458343415,-0.9297576539044633,0.10284287321161592},
{-0.31957484283725546,-0.9078354413529086,0.09230013410152296},
{-0.33114343761804993,-0.9371200667317047,0.11013404415824443},
{-0.3473023151477353,-0.9485154677910755,0.12291012491159445},
{-0.3748035424027268,-0.9600019735075025,0.1506952073480582},
{-0.38219367663699233,-0.9444445462880378,0.14443461872448438},
{-0.36164741818947105,-0.927121411097237,0.11900968905246848},
{-0.3532470106198747,-0.9070646060532686,0.10589840376089517},
{-0.3359849511293389,-0.8864180424970445,0.09443875677634976},
{-0.31844963291284234,-0.8883257593333141,0.08554020636971076},
{-0.31089566583238026,-0.88322332908761,0.09382128854355579},
{-0.3185699399734115,-0.9189737344098687,0.1042993557029421},
{-0.32289051031361626,-0.9350612627557524,0.1207844189909393},
{-0.333362184965201,-0.9504309657021566,0.13825259303375192},
{-0.3431172485494347,-0.9534467090788967,0.1309013450502013},
{-0.35623847797812325,-0.9625137148681199,0.14368475641745032},
{-0.3682533839060629,-0.9771386816251804,0.16731177335014163},
{-0.3849961628937393,-0.9702207749142127,0.16422468185200748},
{-0.39587459206242537,-0.961085196012799,0.16075856468065103},
{-0.3953457881359442,-0.9376151530214736,0.14628243594593637},
{-0.3889162394860756,-0.9261390217173258,0.13308517636462894},
{-0.37230744499713303,-0.91507983873323,0.1143777089217936},
{-0.33702302555228,-0.8652613160217989,0.08803868781843346},
{-0.320302456199902,-0.8406545529798312,0.0862002729061128},
{-0.3130825781294611,-0.8688601704251185,0.08249453708973743},
{-0.3070724903941189,-0.8430771338896879,0.08682463935282654},
{-0.30504768984258007,-0.8509944518785222,0.10417871504632019},
{-0.3102204143011291,-0.8887185527493652,0.1247517111112323},
{-0.3147627325245563,-0.9148305128680377,0.11831638721250069},
{-0.3324430173493336,-0.9483256357009172,0.16292780701101178},
{-0.3494223361241914,-0.9704504855439818,0.1813824128954584},
{-0.3559261311439634,-0.9737538131536128,0.1676444748555611},
{-0.3471130918172527,-0.9617582791697071,0.1446220795204077},
{-0.36317843177599424,-0.9840530218331249,0.19025648755093713},
{-0.38005657320533587,-0.9898823557530576,0.18067017044902803},
{-0.3828648952681912,-0.9841711998284398,0.1763092647338536},
{-0.3919682948994036,-0.9808244271761752,0.1686283537312242},
{-0.3965502696192089,-0.9660681510632504,0.15231185525381585},
{-0.4003574770680641,-0.9445006371708512,0.1471230395665545},
{-0.4001120821117744,-0.9269408208926304,0.13056411450028155},
{-0.3271273916032893,0.006287645494512076,0.17812431517358474},
{-0.32945542140515,0.01693223126704231,0.17266085431816872},
{-0.322459762378501,0.016885542693360123,0.17721096424048507},
{-0.3464095728013622,0.05334015653417886,0.17026507264535587},
{-0.32800546316019397,0.047707301127673254,0.167134434113438},
{-0.3282234214347529,0.05663651262375085,0.16080928509197767},
{-0.35116672688279044,0.09199923152430807,0.1568817004636378},
{-0.3675587200592808,0.1289927814749059,0.1476410643033807},
{-0.3793258597366955,0.16390450825950065,0.13100701000631293},
{-0.3531488526373588,0.14732529757847582,0.14148181557371806},
{-0.3449498478413955,0.1631919502779503,0.14254359868937952},
{-0.34372017879373673,0.1919677110000704,0.13875065725261654},
{-0.3334556407307434,0.1868284013920073,0.1299455413633637},
{-0.3256204319920252,0.19159955800839057,0.13044324011394112},
{-0.31653062905598384,0.1826291697103565,0.12797184475237147},
{-0.31144485630235547,0.19299079059916055,0.1316274274831915},
{-0.30398521722424904,0.19135331206344372,0.13091522540825795},
{-0.3001747673067532,0.2525336775587055,0.12539357222737726},
{-0.2928020193763222,0.28351268297319193,0.12478025269708702},
{-0.2863417108330886,0.31675637318618904,0.11756781148132638},
{-0.2862795004812811,0.36008042138157786,0.11308419235188988},
{-0.2891218057828014,0.370509156696647,0.11828606290633835},
{-0.2877506133905788,0.38123714785682333,0.118398258483267},
{-0.2821128740953639,0.38024648975691533,0.12050824926757511},
{-0.2876762862776816,0.3930700845748171,0.1262535945379732},
{-0.30055031678161653,0.397856237077459,0.13130025793524625},
{-0.2982518112928361,0.4139737561334523,0.12884488580828893},
{-0.27815557285812986,0.4244006258604046,0.12944676745608105},
{-0.26089513353950655,0.41186656160650387,0.132464800321655},
{-0.23787300168149034,0.4876684495327012,-0.24730949750262426},
{-0.19230593968212897,0.4710034016125499,-0.2674025147168462},
{-0.22477953403132298,0.4764526272657003,-0.2515520116785136},
{-0.21574156597240238,0.39759151054863195,-0.2491904660974249},
{-0.19587982006502477,0.41889591914652435,-0.26544500920090053},
{-0.15007500288394585,0.43850821701181153,-0.28474254962870366},
{-0.1428550940036785,0.47135048068288177,-0.2871365783286276},
{-0.17896901278270425,0.49535484043482203,-0.2718486605979571},
{-0.23116417789022473,0.5301165339882833,-0.24209634630203378},
{-0.24844877105044147,0.524607247234328,-0.23515645306140806},
{-0.3968431627039332,-0.2492124685632002,-0.16873399956399526},
{-0.39840712474391304,-0.2701702846735383,-0.16700288146618467},
{-0.39832197594504837,-0.25285493055754876,-0.16530761007034034},
{-0.3956470699927477,-0.22147843057244557,-0.16915283259550504},
{-0.412270860367949,-0.208798628402193,-0.1560405996361639},
{-0.4123355429427338,-0.2823710503488295,-0.1544618255064768},
{-0.40617615185042444,-0.30656767298000087,-0.15960439776892893},
{-0.40495926888077655,-0.2873556255711933,-0.1682299975478725},
{-0.41127485304471034,-0.2829345461399859,-0.17535943815336327},
{-0.40305868398814515,-0.24346094751619413,-0.17512056744344362},
{-0.39853377331670875,-0.196826114670746,-0.1778287469459912},
{-0.3941049128106902,-0.1974290034811434,-0.17057745985101253},
{-0.3944365497834826,-0.1641874210852442,-0.17138691792423008},
{-0.40400638256578925,-0.14674724255067123,-0.1628942497978792},
{-0.41973722767472543,-0.12521636472924233,-0.15378843850093477},
{-0.4297849623004508,-0.20575451554966345,-0.1481260375331926},
{-0.44103981211840554,-0.24036593258060215,-0.13932120530682543},
{-0.42678368785569476,-0.2615124450671484,-0.14282311712216542},
{-0.4343801480613916,-0.33063849802703354,-0.1278702211955746},
{-0.4252211037586464,-0.36891636940792694,-0.14017240750777063},
{-0.41719869770114215,-0.36168818437080835,-0.15050671282933434},
{-0.4071476802352794,-0.31656357272860536,-0.16174924296630744},
{-0.41549536156760103,-0.31456134515583656,-0.1695478145716476},
{-0.4235595924958267,-0.34537726672163355,-0.1688273140292988},
{-0.41267451584146436,-0.2914913900725955,-0.182143197817202},
{-0.4009953414060224,-0.22427305394898,-0.18291443895662587},
{-0.3950975969222947,-0.142050898567555,-0.18051581003087838},
{-0.2521474450420941,-0.5827466924125334,-0.28453630440026595},
{-0.2595020969802726,-0.5563212104366615,-0.2824963666622296},
{-0.25522002829915497,-0.5480063978772106,-0.27750437370852615},
{-0.26022995363430795,-0.4987782817468003,-0.271026577932716},
{-0.26504086873821925,-0.5076982534821416,-0.27652084861466425},
{-0.2681630770641532,-0.5265935365651093,-0.2880490984588187},
{-0.2538263840426529,-0.6009747281447014,-0.300403545673668},
{-0.2533554324711366,-0.5969440113404726,-0.2916979444617063},
{-0.247340704138474,-0.6231161143653515,-0.2972146680703418},
{-0.23992430824551714,-0.6368222375409271,-0.2977857027073284},
{-0.2342493039339077,-0.6685325237498252,-0.3094287265921699},
{-0.22794778179976632,-0.7086850413366333,-0.31853520720603556},
{-0.2243482995134301,-0.7250603164638025,-0.31866169323043614},
{-0.2157649293825841,-0.7363270004423692,-0.320994748221245},
{-0.2063228405155268,-0.7784598610634379,-0.32676839709814803},
{-0.1811964113166641,-0.7915115452767887,-0.34219840549915376},
{-0.14716563521414308,-0.7963555713825516,-0.36303536847130763},
{-0.14433937864502253,-0.7570599696258988,-0.3531067446349557},
{-0.11490401034667488,-0.787876053740091,-0.37037224951402403},
{-0.11945945993065167,-0.7551428504804979,-0.34622993292054294},
{-0.1477760819937111,-0.7071843839285069,-0.32381385159857096},
{-0.10465750346905765,-0.7574733514429279,-0.33116459281359556},
{0.3249986769437121,-0.45141605864434603,-0.22889254122619998},
{0.2925003306173269,-0.4377277658590702,-0.22626223727863976},
{0.2729428657440046,-0.4337641634811064,-0.2147221330881251},
{0.26206103262069064,-0.4340141374150635,-0.20135710975171867},
{0.27029645144439157,-0.47315670676333105,-0.18139929243076683},
{0.2793100223703298,-0.5469356576012908,-0.16847328468706432},
{0.2901716527467012,-0.5466313755048278,-0.13857316609159587},
{0.2936111937866541,-0.5518062694001278,-0.12250789731417776},
{0.2945246254627475,-0.5595256501896099,-0.10589434005101638},
{0.2998619742613126,-0.5297877633917661,-0.1012288388290745},
{0.3116303091475152,-0.5286004652924439,-0.0910738381986656},
{0.3420591923603759,-0.5395011040964285,-0.08626339905345383},
{0.36642789637199213,-0.5462455525464277,-0.09078919152337382},
{0.3874558250234392,-0.5445427433671611,-0.0903835206622402},
{0.3823450463771528,-0.5494958691934902,-0.10573651618340138},
{0.40598368498889353,-0.5475604309501964,-0.1238330800113097},
{0.4001442592571601,-0.5485488197470191,-0.1484189720518215},
{0.4064737046558098,-0.5371851931804729,-0.16068233160814013},
{0.39384857399153467,-0.5290352461276113,-0.17930233101585838},
{0.37700099059807385,-0.5264880033475663,-0.19161213691687815},
{0.37214679193751626,-0.49339783212573224,-0.20770300866014452},
{0.3444543758975909,-0.4548453453241028,-0.22525818434104497},
{0.31999343151496856,-0.4068881759720497,-0.23574270562788585},
{0.29691808683690013,-0.4018099006303467,-0.23658867971999092},
{0.26845688169477977,-0.39682240697372484,-0.22616172818763713},
{0.2547598761030422,-0.38912734257423126,-0.21489974536363626},
{-0.14172603497576441,-0.4545412257760349,0.24022500312200487},
{-0.15186773319796612,-0.4643660991151514,0.2463081409560549},
{-0.14282778906051627,-0.4928677299369054,0.2300824337253978},
{-0.13272561559612406,-0.46923411757652067,0.23327001412878617},
{-0.1301945628487179,-0.5075497607423346,0.22853448004632101},
{-0.13351727302646077,-0.4120157332249025,0.2545027091369976},
{-0.13214132848409754,-0.4255005770391004,0.24908568293979677},
{-0.12338140104869709,-0.4335947572435309,0.24818894806486821},
{-0.12364320914326607,-0.4742978028717488,0.23714737449024736},
{-0.12343860533489708,-0.5425469996692657,0.22997793316824752},
{-0.03985312256627766,-0.33031687106064067,0.2599043952278088},
{-0.025683198886164764,-0.32515575659465523,0.2684835699102074},
{-0.03870871068308036,-0.32339410170912,0.26547119117900597},
{-0.06983685796854668,-0.32630333764035413,0.25823566915354146},
{-0.05777953434632687,-0.31839201800602335,0.2638387782037342},
{-0.018400320032504705,-0.31419140838144116,0.2662703959544352},
{0.0014870299031289195,-0.3193956438556779,0.2689857881436148},
{-0.012865350632115262,-0.3258004702757739,0.2776199190572843},
{-0.03556378382850625,-0.34286341860632596,0.286605505099061},
{-0.04458499134179326,-0.3424596005844155,0.2736743499895121},
{-0.053016387222434215,-0.3452978326143867,0.257668606859362},
{-0.07295454787405846,-0.35650048314934124,0.2547784995807731},
{-0.1015961615490497,-0.33568175853208654,0.2576576236874072},
{-0.115097732974239,-0.31247806224150054,0.2593222966758738},
{-0.10090853934124192,-0.30727026026424076,0.2659405417019504},
{-0.05173854010534157,-0.3098121538209551,0.2685010167712871},
{0.0013061273506257394,-0.3096801963963256,0.2675295489436774},
{0.0246828282540446,-0.3182556823988028,0.26666237875332605},
{0.021698514087590524,-0.33008181120754077,0.2781636168788743},
{0.0024046389667370122,-0.326502572039644,0.27889929497921756},
{-0.021765724130558772,-0.3364511351458014,0.2861438952794309},
{-0.008820584546987512,-0.33787949145272705,0.282640968864631},
{-0.03043220748690264,-0.35688744182169174,0.2953725453547592},
{-0.0440378895655754,-0.3682763568813739,0.2976842629470829},
{-0.053065594765037284,-0.359877085025728,0.2807981364606303},
{-0.0600165742311756,-0.3644599500432793,0.2569667483868808},
{-0.05885243343491952,-0.388509701168964,0.25393143120862227},
{-0.07603786038760725,-0.3850162184972001,0.24808063771330605},
{-0.06918752387585587,-0.4384757445170545,0.23734946570414225},
{-0.13511997895450867,-0.3586521766274724,0.26225645669436465},
{-0.14351605933708897,-0.316866719111118,0.26486015582551037},
{-0.1775858651153794,-0.28754626721610416,0.2605609430695393},
{-0.1306683106775939,-0.2948996028310043,0.2689930018926545},
{-0.07954752353033961,-0.2979910512635732,0.2701365096668043},
{-0.006075157026570416,-0.3036895624104189,0.2744962509830174},
{0.02490173738359482,-0.3105734253254763,0.26470307033132434},
{0.0438204763062238,-0.3083025806864749,0.2717353654289435},
{0.03290363684552235,-0.31917014886010453,0.2780750641253817},
{0.03790904907229233,-0.33108349178849256,0.28950436555560854},
{0.031483564132302584,-0.34759980261504025,0.2876108329260296},
{0.02886220565851479,-0.3534335136551561,0.28158992562953555},
{0.016623972046937132,-0.33720138310687087,0.2774350515988287},
{0.25181357701289764,-0.8928450774900312,-0.16420408282695123},
{0.25005581266476795,-0.8705136987556431,-0.15848040430146},
{0.23992783331463557,-0.8984516712378454,-0.18346705356697743},
{0.2299420859350774,-0.9135568102038176,-0.19251223537493778},
{0.24818282700226255,-0.9119172238510029,-0.1905456313984948},
{0.24473664060144898,-0.9270084208392655,-0.2009025107612363},
{0.2503493941897541,-0.9311163024476561,-0.19946195588781945},
{0.26222944444455454,-0.9276573490921722,-0.19573438546610306},
{0.27991672097513903,-0.9219280376804646,-0.17732346791567907},
{0.32548277899911865,-0.8988729966780808,-0.1389838727657558},
{0.3455602542494667,-0.9063770953982812,-0.14706656409211324},
{0.35900890607915964,-0.9156619776566618,-0.14178356276514303},
{-0.19672262180740482,-0.5904660732020156,0.319485134715268},
{-0.19007731512955478,-0.5932404332743622,0.3250149291272078},
{-0.19091838514720225,-0.5930543302356219,0.3158470498411026},
{-0.20116553584395322,-0.5882182477530651,0.31122106169048436},
{-0.1041747889182529,0.26880309437154143,-0.29461475961026734},
{-0.13470427683881925,0.24596771362103048,-0.2879343647896285},
{-0.11619772452443153,0.3272681080491204,-0.2916264337919173},
{-0.06577140574092215,0.2832942391782632,-0.2998264319391843},
{-0.07402980657040042,0.40526631058152984,-0.3035052070325284},
{-0.10677249925656544,0.4200067005104501,-0.297877821963844},
{-0.1582522952514664,0.3486026699055174,-0.27898608519815093},
{-0.18285528887051922,0.3104159042440875,-0.26633102438101147},
{-0.07377382896990073,0.22769428651511803,-0.3019876084694405},
{-0.020778686716472157,0.23212347105551911,-0.3034978307350935},
{-0.03326903501374716,0.3089817121310535,-0.3017633288684034},
{-0.045204309226586976,0.37982638077362413,-0.3041313997582701},
{-0.04000803012445022,0.4245847028874484,-0.3089399637536946},
{-0.07415711914807824,0.437512372236968,-0.30549786974777077},
{-0.08158984318668938,0.4457870225939225,-0.30610278563227233},
{-0.10644233584340758,0.45573035759123964,-0.3001537332256982},
{-0.21216844627349962,0.33359982275085553,-0.24919024405419232},
{-0.2093073363537166,0.22600193355353176,-0.24939302370834907},
{0.3583247993787999,-0.4108106036728727,0.23658148721910732},
{0.3659867931479385,-0.3954836977003374,0.23405246048339748},
{0.3593886499400624,-0.39621935561493227,0.2414384205173718},
{0.3477893961946451,-0.40137868629820234,0.24450368803424302},
{0.3430562535921635,-0.3912359150441111,0.2450494331156857},
{0.35145171671580533,-0.3828092458158234,0.24299918046020785},
{0.3628065890419851,-0.3820551073173482,0.23446705875737078},
{0.3671200274385517,-0.3918219445049485,0.22444197891581685},
{0.36554131386610983,-0.40752689236107265,0.22504111955145542},
{0.3525589315767081,-0.421328012855925,0.22950345546520504},
{0.3418740624871909,-0.4104179717428091,0.23757246829099002},
{0.33229827172187765,-0.4009017576203388,0.2364256171194576},
{0.3315356233368328,-0.3897396347561678,0.23374193780344993},
{0.3364462762236757,-0.3779131819130474,0.23496023908752608},
{0.3460904361188794,-0.3713297094946397,0.25116315023377284},
{0.35984061415917257,-0.3744590922605244,0.24782419902781622},
{0.36763424238096604,-0.3717591411064765,0.2371781343836124},
{0.36641363035989993,-0.36782731109652206,0.22514827400331872},
{0.3579634957302805,-0.3793861189765574,0.22239496766657177},
{0.35970484694013116,-0.38770984832476985,0.21307148282036184},
{0.3620882770597279,-0.40519282383321165,0.2146949492594534},
{0.356023153412529,-0.4124741823812935,0.21183966558410833},
{0.3573212139006423,-0.42054955796746135,0.20564400176430028},
{0.35718540524769626,-0.4281382774698439,0.22086419843384525},
{0.35089567796507765,-0.4323487759863351,0.22711461450262443},
{0.3383298392183519,-0.4314346346218237,0.23207882549205833},
{0.33131263987332565,-0.4212516586689236,0.2325634948732361},
{0.3300416123519748,-0.4103333498982189,0.22678818439051596},
{0.33134567013218374,-0.4050093151943469,0.21761311154111937},
{0.33190961213462106,-0.3879974314952525,0.22600239463852198},
{0.33831460004070435,-0.376117645779997,0.2244731648347143},
{0.33245519466766854,-0.3662125277164735,0.23480878754196421},
{0.3345427739591941,-0.3681434262911891,0.24300740774629975},
{0.3461181978974005,-0.3561119043050783,0.253049711343293},
{0.3568096730386893,-0.3605370368220864,0.2530747374216996},
{0.3644698437160235,-0.35835470456508073,0.24735314652755785},
{0.3689442167102769,-0.35430113005678826,0.2354922047396542},
{0.3638199422975614,-0.35383911439737414,0.2234419386925259},
{0.3587507452306075,-0.36896824465654465,0.21810426585957826},
{0.34580686460029275,-0.3764655344050813,0.21791309726039293},
{0.3508293337844757,-0.38839557519704193,0.21017195304689312},
{0.35706236354942045,-0.40128044757269277,0.20844316587182085},
{0.3486461101673162,-0.4058435358688338,0.20470417669094695},
{0.34651026250169287,-0.4117488999413854,0.19723948161406576},
{0.3401402894322594,-0.42877877657917457,0.1862050707929097},
{0.34751867131131464,-0.43256324743845687,0.19711729090444693},
{0.3544582192694017,-0.4320039662190885,0.20340656241411445},
{0.35328583525093643,-0.4378177379893988,0.2122906768234114},
{0.3420497900512446,-0.44295485903737036,0.21933484751554702},
{0.3313581927330574,-0.4390120065463721,0.2241338880873497},
{0.32699887744237666,-0.4327718841468781,0.2263830096738303},
{0.32345522149930905,-0.42194743698149983,0.21929391506738732},
{0.3237155709079529,-0.42136205665183524,0.20813038345045834},
{0.3306266686472569,-0.4172733036960899,0.19824991643538398},
{0.34197546293834735,-0.39764317331568744,0.21048656918413824},
{0.34500498468199436,-0.3605667024354056,0.21831529404798308},
{0.3324781341771335,-0.3557964371791762,0.23341311727376568},
{0.33525845117007885,-0.3475427396290793,0.24064112063914855},
{0.3437737953287574,-0.3455980616250491,0.24900476889846856},
{0.35432496464483443,-0.3469630325571278,0.2504298837991616},
{0.3641925127809215,-0.34563194287256416,0.23901985232181888},
{0.3582494587288506,-0.34446993432878575,0.22696012340831398},
{0.3515936852092424,-0.3526550587666924,0.21809372889890427},
{-0.4975034906457773,-0.6674069897910296,-0.026594451032633016},
{-0.4894479725240134,-0.6171702226220165,-0.01191215781247436},
{-0.4924226612756957,-0.6446421274214118,-0.023024700228900394},
{-0.4889044563741592,-0.6953532309932285,-0.042272883314598955},
{-0.4836569777147728,-0.6488605684987014,-0.030091185734707804},
{-0.476042401331075,-0.6084762324650262,-0.014501337016060946},
{-0.4819914537376492,-0.580227169977105,0.0022426733022689487},
{-0.48392474485475623,-0.595557317355873,0.004798386659794714},
{-0.49555086795613307,-0.6579235222645319,-0.007741321104400406},
{-0.5016184638263094,-0.7053698806287987,-0.024229273079236953},
{-0.5009816533969,-0.7076797942526585,-0.03334390448583209},
{-0.4965576151599377,-0.7090681094715782,-0.04071200225727238},
{-0.47195778326653187,-0.5875202001374035,-0.010932594437341393},
{-0.4680527418695432,-0.564564046991702,0.0010809027378402764},
{-0.47580337019757585,-0.5692205103103919,0.002218016941780715},
{-0.46788414731153566,-0.5247834103855843,0.018639303888856294},
{-0.4730783717169651,-0.5370707431741684,0.020332925365369434},
{-0.4672433645393193,-0.539044601271148,0.03495433305626144},
{-0.46864229746190683,-0.5980314484175572,0.03616317678600005},
{-0.4823823836903989,-0.6645317976557057,0.032293771734231036},
{-0.4980784158201693,-0.7123803517451549,0.0030648653955145906},
{-0.4996882547542634,-0.7467944807079143,0.015170073862612257},
{-0.49571395180482264,-0.7474310882174315,-0.043345842960436906},
{0.1994067568963637,0.6759242494709923,-0.0269270409852323},
{0.2100592044866987,0.6690501128994488,-0.04461375975171581},
{0.20829329359547072,0.6907997978592778,-0.03146660332279656},
{0.1900682963496434,0.6925675732762149,-0.017757940992551714},
{0.19727253046506063,0.7087914372293193,-0.02398005876686499},
{0.2095866922381073,0.7071435024759221,-0.03418007042902179},
{0.22037762256184984,0.6941616875122917,-0.05406541347629963},
{0.20782511809556573,0.6614528813856806,-0.04772243300213184},
{0.18730467615786286,0.6552142591060165,-0.0326703857417214},
{0.18503583734480958,0.671159617100979,-0.021009255240549245},
{0.16007826724349938,0.6874600370985691,-0.011566806217243883},
{0.1780393889491567,0.7055732180470562,-0.01490175002093568},
{0.18568663012342534,0.7208373059705159,-0.023485038346380223},
{0.2071735146997898,0.720189673855139,-0.04003251490607695},
{0.2197401438779272,0.7084338211983131,-0.052487530706766344},
{0.22203346056695644,0.7117520618263933,-0.07573579712985846},
{0.22263043282825185,0.6864712031528734,-0.06858245553583339},
{0.22001180049290825,0.6708015144871955,-0.06893907821553559},
{0.2116364593732154,0.6535071131780635,-0.04271601255034886},
{0.21766247366405908,0.63293435084287,-0.02584537384497169},
{0.16133849432703898,0.6662110702523174,-0.018344508031741705},
{0.13514393943788042,0.7012060398761631,-0.015166405368439323},
{0.1548160572373994,0.7050100462902823,-0.012078351328828016},
{0.15282720325416116,0.7285918237735461,-0.02409829306979396},
{0.18771278949455503,0.7320654075470017,-0.03552062404236984},
{0.20523303108179927,0.7318503677067006,-0.05285639338686432},
{0.21784756316574727,0.7213877522065242,-0.06452681358193982},
{0.2120910371155415,0.731888991542686,-0.07752147518082632},
{0.21018883205099764,0.7287970968988363,-0.0877977252275331},
{0.21862703159126312,0.7054458396000941,-0.09295415872470128},
{0.22268808332573262,0.6989334125168539,-0.08150297169355847},
{0.2160225834626103,0.6849992796264153,-0.09239468414711118},
{0.24188086078165597,0.6661460232716533,-0.08545674679926635},
{0.24667057872491316,0.6484703386726994,-0.05742906672628037},
{0.23772081919935423,0.6406096778300422,-0.04197859210119479},
{0.2652443368326379,0.6190445139837221,-0.03991757937940255},
{0.25790964435001307,0.5934489584299633,-0.017193020512520103},
{0.29970028854130293,0.2700797154700195,0.22133472504223695},
{0.29570580409307584,0.2752657943947585,0.2097040813956223},
{0.2955387489639871,0.27958061073425644,0.21975807785298837},
{0.2934333169715979,0.27728407069992717,0.2300294440109859},
{0.2875654218977408,0.2851393005138523,0.22227950518562287},
{0.2835874100826302,0.2874947669974438,0.21416961940651563},
{0.2839249657293403,0.2787833501651223,0.2020876309245451},
{0.29166189430864414,0.26296638415417384,0.19851262651418483},
{0.3000318054620127,0.26026035390262886,0.21211910327390054},
{0.31350049855266093,0.25346484082117193,0.22373880412005723},
{0.3122313344946114,0.2662847883930569,0.2263777815649901},
{0.3083055432106572,0.2780795474863461,0.23142799234194567},
{0.30238240824264345,0.2804965348190755,0.23762912649957488},
{0.2941562291796787,0.2761259526935544,0.24442005954095655},
{0.2852480310477039,0.2723803882707353,0.23462373841177284},
{0.276232170632932,0.2810896165429654,0.22918784703906403},
{0.2721688081614725,0.2863622625809973,0.21215241719564434},
{0.27013176760953794,0.2758587135702533,0.19981320915844256},
{0.27693516269454804,0.2669431996980887,0.195375310749172},
{0.2753589415308318,0.256054395054716,0.18704577640467776},
{0.29205578306714874,0.2580556505243374,0.17512626194931302},
{0.29852707478233714,0.2604365680494601,0.19002665474426955},
{0.3119482899302992,0.25701036128994875,0.19606733026291137},
{0.321008649296254,0.25138666490118566,0.21378902455695578},
{0.3335815392436243,0.2374145976774312,0.2306557174797212},
{0.3209583134765551,0.24889745721024917,0.23818988659061685},
{0.3217498593540716,0.2607347699860183,0.2367945201710524},
{0.3172125461338441,0.27171913927443914,0.24108988276111476},
{0.3102933230995981,0.27416830587736973,0.2489391960259378},
{0.2974810556737821,0.2699858528022853,0.2547250030978351},
{0.2655259428967732,0.27657572835257277,0.2271572096190091},
{0.2610487736451601,0.27079178580638447,0.22259199332002166},
{0.2630205037392933,0.27771520428907803,0.20845155464390008},
{0.2598088704230537,0.27919551658761504,0.19723498231698428},
{0.2644484340206867,0.2754823736639783,0.1918595685089425},
{0.2636161989863993,0.25895050068780834,0.18089203838433313},
{0.26166718423368285,0.24508242831508606,0.17381675401703126},
{0.2764358830811471,0.24964778591431233,0.16279041855765009},
{0.3086895027057559,0.26042838113486505,0.16892016315998085},
{0.33699566855113505,0.25598047271919505,0.1760147196049825},
{0.33796898071870546,0.24596763287803677,0.1949563969746686},
{0.3414293523886175,0.23630835598208386,0.21171561034878042},
{0.3552604635935794,0.2131348118875948,0.22468115241196274},
{0.34484595391910555,0.21198074696702263,0.2543727766616567},
{0.3350284983113285,0.22677714597335494,0.24863045606629786},
{0.32963155374657993,0.2387562253850767,0.24057193982969005},
{0.3324751753713786,0.24662361339399605,0.24906179151293278},
{0.32223015267747396,0.2584978065945319,0.24681514214942946},
{0.315265963232608,0.2619471143494956,0.25601291015449434},
{0.30496981428759273,0.2611526914716258,0.25854420619328944},
{-0.34661705361008455,0.03136955449403577,0.1680971275149329},
{-0.3719345908508874,0.0652935416129806,0.16705416920328262},
{-0.3910582469921897,0.09280516346599943,0.15927049149305125},
{-0.3569204566756365,0.08390059239429289,0.16174748999341854},
{-0.3584022892797518,0.09175533562544029,0.1547380419757847},
{-0.37464852435414187,0.12381934732793878,0.14981646647423227},
{-0.3957620065818299,0.1750156472352077,0.1327352107322733},
{-0.41566115986824886,0.21410536816930228,0.11500851143502913},
{-0.4088789396333289,0.2273277547577585,0.10672330818128346},
{-0.3852812749036525,0.1912332695424197,0.12499249521762036},
{-0.37162358158816217,0.20088906067834322,0.13045146740003302},
{-0.36309863220046024,0.21463790114720172,0.13717759675213942},
{-0.36088558042158636,0.23971616290070866,0.13053425552874062},
{-0.34818393302191464,0.22663586698258772,0.12249245734145389},
{-0.3295734984717229,0.22299810508039702,0.1276576238308322},
{-0.3257900400870849,0.20653804662265024,0.1257971671436473},
{-0.31677156614909674,0.24411997714257214,0.12766039990244354},
{0.28403434911279196,-0.6383060355994935,0.06007251265846822},
{0.2815910193783775,-0.6260405884118254,0.07404440139771029},
{0.29206605655068557,-0.6302481684940584,0.07209964265068647},
{0.3132505235562959,-0.6331859364494771,0.07256434726427137},
{0.29341013523315207,0.3778989668965301,-0.2606456849662122},
{0.322450662855596,0.3893290587581686,-0.2481346197166139},
{0.26552154559084157,0.3717134756315167,-0.25317076740136923},
{0.2367557343178757,0.36793338189241764,-0.2618536320237579},
{0.24993508064107423,0.35143474103259,-0.25331593692954196},
{0.265987633459397,0.3096855966152311,-0.24151511892450417},
{0.2734268881188251,0.3316347188942423,-0.23725566359365333},
{-0.309678559757092,-0.6775855886237465,-0.3105360636299709},
{-0.32228826957198387,-0.7110413184373849,-0.2807260372169138},
{-0.31651243213498925,-0.6833948207254785,-0.2679317648546082},
{-0.3061897782398938,-0.6554912150111611,-0.29419738526468275},
{-0.31329403128099054,-0.6471446279588853,-0.250169330408218},
{-0.3229677558607715,-0.6941192453826318,-0.23775684916666795},
{-0.3282367950242835,-0.7296259980974115,-0.2528693229961705},
{-0.3241624302575287,-0.7132719605023932,-0.30174342997009485},
{-0.3116485071309176,-0.6899583538740809,-0.3313860357857761},
{-0.2970816976398641,-0.6607899612218971,-0.31902526724444863},
{-0.29460057487237273,-0.6349044703267611,-0.30304862240184643},
{-0.30131172958637664,-0.6067588332392848,-0.28223131503661225},
{-0.3122678908849956,-0.603064657482306,-0.24242368796004446},
{-0.3225103000556841,-0.6502603938438507,-0.21801522652330807},
{-0.3245167634483972,-0.6869698453215873,-0.22487136909374905},
{-0.327762278012152,-0.6962717494779231,-0.22375868283261738},
{-0.33115733922426277,-0.729399692484678,-0.2330746097096566},
{-0.3397713470715756,-0.7619699744439766,-0.2568106158725016},
{-0.3345988244705107,-0.7627312459484978,-0.27260591938817436},
{-0.3311132450504562,-0.7424542940698788,-0.29280603049701437},
{-0.3260840072661066,-0.7178509349825388,-0.31292131790378},
{-0.3242153796004438,-0.720543430158566,-0.31427011792656057},
{-0.31096006474427945,-0.7038543091398148,-0.32255818330695035},
{-0.30230417040659224,-0.6871262816846005,-0.335627172018734},
{-0.2860767410128728,-0.6731854216278998,-0.3442423357657456},
{-0.29124912125129093,-0.6696598404289285,-0.33902111876505053},
{-0.28304596244078484,-0.6482625433912649,-0.321895920773602},
{-0.2748171486064477,-0.6282426984526491,-0.313838295897148},
{-0.28894923888198687,-0.577879160533942,-0.2916186516546984},
{-0.30107330615014566,-0.5413660239588293,-0.26730006035714077},
{-0.31003258909932646,-0.5237245042702763,-0.24244715336137607},
{-0.31783932743351323,-0.5505132755348673,-0.2247880433866888},
{-0.31855761923002207,-0.5988668048059945,-0.22139397552588178},
{-0.3213149574044135,-0.5683613241147437,-0.22069726441924706},
{-0.3264637925609142,-0.6341962087224001,-0.21790183042555247},
{-0.33997704515999033,-0.6608601545059999,-0.22592148059719386},
{-0.3328626206265067,-0.6834588541690906,-0.22309982425389693},
{-0.2886261319815126,-0.7267754463864586,-0.14382455547413622},
{-0.3053522141680242,-0.7201832197276846,-0.12693502609546362},
{-0.2940392878270563,-0.7220938549982123,-0.14553089078492903},
{-0.27048905960616126,-0.7216936045417327,-0.18125777014861078},
{-0.29502346098968313,-0.7271867203863899,-0.16091129324040232},
{-0.3116072910198722,-0.727013100639434,-0.14491843711700517},
{-0.3249375013771129,-0.7324136520787028,-0.11966977683702676},
{-0.3215236344843316,-0.7305101498142211,-0.09404516230480897},
{-0.31279420346515896,-0.7300944976316989,-0.10356899601610299},
{-0.2935663708010888,-0.7498204359485383,-0.11814875413356254},
{-0.276472622205675,-0.7406838849439772,-0.1490088113070708},
{-0.2552976988094348,-0.7324820626424979,-0.18505437901713892},
{-0.2626572346363226,-0.7160323785970301,-0.19670994675101028},
{-0.2733726628241285,-0.7267320002814169,-0.20691873815132092},
{-0.2900639107833181,-0.741976229678065,-0.1972011212552176},
{-0.29995393203184084,-0.7407307339412389,-0.18800726397330667},
{-0.31826146349090884,-0.7340273008072086,-0.17322330682485432},
{-0.32883887427992853,-0.7363506687635927,-0.1572313834955156},
{-0.3486156339368367,-0.7497040406735309,-0.06476494485602267},
{-0.33888666946289925,-0.7387460148492029,-0.0641791682482444},
{-0.32506465671843465,-0.7342607394259882,-0.07652482935049298},
{-0.3190810335616757,-0.7291591197974443,-0.0801104419028506},
{-0.306587658464546,-0.7470442920934763,-0.08837358213357581},
{-0.302026434694114,-0.7446823417350115,-0.09294364088736787},
{-0.29521908745204534,-0.7605780937844416,-0.10477390352490015},
{-0.2765336161005384,-0.7731799205333725,-0.13532578700213194},
{-0.2633730956437588,-0.7572874109525829,-0.1577160932481902},
{-0.22265704083188964,-0.7614495996610716,-0.19914908209938514},
{-0.240822258514982,-0.729874351859456,-0.20674396250466637},
{-0.2596425664162875,-0.7224947545858647,-0.2146066897305168},
{-0.279351887612548,-0.7302415327479885,-0.23418614007108943},
{-0.29277760099518374,-0.749218357755301,-0.2218739851863985},
{-0.2988900410990815,-0.7569455196195942,-0.21559568622460767},
{-0.31169957176237517,-0.7549914393064328,-0.2009781754455681},
{-0.32411711962677797,-0.7418807468384182,-0.18720560716064866},
{-0.33427196939527765,-0.739702142570423,-0.17848677365939528},
{-0.34259950747549417,-0.7390613194267097,-0.1770824702653209},
{-0.3530257705675861,-0.7522057305938442,-0.14735275019632382},
{-0.3581979893200169,-0.747700354414837,-0.1756777217223735},
{-0.3703884613260229,-0.7376201568560248,-0.19602958928781727},
{-0.37175132444100367,-0.7207757341258031,-0.20167877708960838},
{-0.37529352169814617,-0.7134762200906312,-0.195995951331691},
{-0.3747117068090968,-0.6901648817029966,-0.20314535139273557},
{-0.3773595394231382,-0.6721555330571461,-0.21371048180986277},
{-0.3909995224004116,-0.6797891573504954,-0.22153602476231232},
{-0.4072570243096421,-0.6938470618133763,-0.22052127337805613},
{-0.42208519674639156,-0.7061439583970791,-0.21246255422155635},
{-0.4110726205305765,-0.6499069923846327,-0.22756621325344728},
{-0.4144200412516061,-0.6207668077222508,-0.22552232335835223},
{-0.43393969396851095,-0.6048154524351925,-0.2036040831496045},
{-0.45107364620032586,-0.6426035867496476,-0.18079697094614078},
{-0.2694685945926951,-0.20732196334967262,0.2495213753208665},
{-0.28159495134968765,-0.1997911163880034,0.2562831282692988},
{-0.2625245877090234,-0.2233759344824237,0.2485300691521935},
{-0.2336787558796988,-0.23749414333749838,0.2536878189726401},
{-0.25392389289399603,-0.24008256291949978,0.253092670865557},
{-0.26878809476685533,-0.22572605174268462,0.26133955944399034},
{-0.2923674616467951,-0.20523430331515347,0.2695219492441903},
{-0.30270034865393053,-0.18255527818466213,0.2614522469157357},
{-0.29871216534643313,-0.174365209300801,0.24834931533678387},
{-0.28375019114509337,-0.18596486888600236,0.24748984654065773},
{-0.26006618134535664,-0.20072414417617904,0.25513990415803467},
{-0.25899985856111685,-0.21208963420602645,0.2566567930327045},
{-0.2390795293622,-0.22516304147189797,0.2591653121104298},
{-0.2015150265800171,-0.2396508630669855,0.2712332077527814},
{-0.188391101822711,-0.26091328424576143,0.2651767374172067},
{-0.22309184079039776,-0.25508135698836104,0.25775322764154435},
{-0.24407553396779946,-0.24693108590111695,0.2553780248080394},
{-0.2591317150570043,-0.2378203099724696,0.2634824583102583},
{-0.2709141342835633,-0.2381067595538174,0.2719905483484002},
{-0.29462361531057973,-0.22015504015729156,0.273190815259877},
{-0.3214137443323538,-0.20294716558995562,0.2740133228882426},
{-0.32072457100914126,-0.18977892461561022,0.2710430526906482},
{-0.3218921125728018,-0.1775262836917014,0.26431315391562676},
{-0.32065291903911336,-0.16365958926191046,0.24883947736634687},
{-0.28326246096701085,-0.1708292536895507,0.25374998895295076},
{-0.27007606344316765,-0.1892485801978024,0.2576718896994994},
{-0.23661082932924798,-0.21476794411295502,0.2696725296153468},
{-0.21114483972013498,-0.22546489171688064,0.28171594631931474},
{-0.16367399179340644,-0.25989263649815164,0.2814025859481027},
{-0.14670345700633383,-0.2811292826010139,0.26721813490357604},
{-0.1840773999490072,-0.27230836020834226,0.2612226170289601},
{-0.1824435484735587,-0.2789544073844368,0.26234239592464104},
{-0.22468682726328762,-0.26574725997362814,0.2539580572731929},
{-0.2471153706288879,-0.25705618825089593,0.2531418709713054},
{-0.24890024868677377,-0.24941786280298087,0.26721268368909545},
{-0.2534623234458627,-0.2538324572969072,0.27236457751768534},
{-0.26851878819795316,-0.24957656846907939,0.2755287127054905},
{-0.28562653932832205,-0.2417360912500242,0.27603897549084616},
{-0.3005142267882614,-0.22804666381320576,0.2721709568812711},
{-0.32226555423056713,-0.22016338962028179,0.27170209294110437},
{-0.33571880628608364,-0.2167396147122508,0.2743428127348481},
{-0.34445263461118786,-0.20303916373198072,0.27125177014206314},
{-0.3393872059047411,-0.1843206621216156,0.2670328828534927},
{-0.33952998501533804,-0.17212856888128938,0.25776536671319805},
{-0.3544695275381467,-0.1810573766623986,0.2556136934208153},
{-0.34910459969520397,-0.22579640757518255,0.2703449232695852},
{-0.35559451435691936,-0.2612859769060197,0.2572300969727763},
{-0.36644834347273125,-0.2736995938615201,0.2462412294496817},
{-0.3673229090838582,-0.2770348563875554,0.23808224555597587},
{-0.3675426298929763,-0.3136820571419877,0.21791038174602684},
{-0.3686689139116868,-0.34297835519540815,0.1992401995053345},
{-0.3791307591662,-0.33024651522814275,0.19418806364542465},
{-0.38280337441905327,-0.3011210820982229,0.19164438736840267},
{-0.3917576736131906,-0.2937730967690612,0.19228755099652448},
{-0.39907838374660876,-0.26642747613658224,0.20390416023594982},
{-0.4148714381449447,-0.266762395949512,0.20154303005631538},
{0.30444479890736714,-0.9989501721594408,0.20143686789334797},
{0.2954280673181897,-0.9981728519225198,0.21361961938178808},
{0.30605706969294155,-0.9970818483424123,0.1779136322677186},
{0.3117846791273352,-0.9991101750254774,0.149624041046606},
{0.2298033397245326,-0.9988634424977527,0.17390519521770362},
{0.20178242612689778,-0.9914408867643051,0.17083886316820532},
{0.1987590238522448,-0.9837317189011147,0.18328825564434867},
{0.2110393245635249,-0.9618331746707832,0.18792764713191626},
{0.22673391713071084,-0.9312515023409261,0.17555183277116299},
{0.25075377953743583,-0.9339898744110674,0.17693565931707939},
{0.2616019555812829,-0.9401654757217639,0.17761623988591282},
{0.2707285975081866,-0.943259194519826,0.1871882814140594},
{0.27436881038519834,-0.941748324185408,0.2025993832056525},
{0.2724312250157175,-0.9469935728507982,0.20993381221114},
{0.2864820974012943,-0.9406785560126358,0.20491119110264014},
{0.29260312919716325,-0.9566091614127286,0.2092917534871421},
{0.30184568087870445,-0.97023649961223,0.2180659267488863},
{0.3058165384396126,-0.9762149754031425,0.22077888814899327},
{0.3039443846424237,-0.9909932996653785,0.2135554839470262},
{0.31481663378487046,-0.9872804807761241,0.19680326227872158},
{0.30618444813990375,-0.9987797938187178,0.1858025701566855},
{0.3104615734374747,-0.9894033181956883,0.18047980184292473},
{0.3168848400699541,-0.9984725943504047,0.1757243593004807},
{0.32709059192151624,-0.9984416315371476,0.1694872870738134},
{0.3279697981299635,-0.9956705128710337,0.14412207959451062},
{0.3404618356556587,-0.9985473273030857,0.12155321871721247},
{0.21054490759067693,-0.9984366063481995,0.15441153112068254},
{0.1888156282976823,-0.9913771773550757,0.1708645373153769},
{0.18733612555389761,-0.9944786761655409,0.19952487592804502},
{0.20013309324482084,-0.9782436271829977,0.2074837138765587},
{0.2089680989154411,-0.9657009701747181,0.19965835365825274},
{0.21911445792071163,-0.9374301846342759,0.19027206988630774},
{0.22589067873872024,-0.9219413305270016,0.1797847523421071},
{0.23844310352441844,-0.9143341304407386,0.1583679409977628},
{0.26490072333658693,-0.9245680084767012,0.15509050107927377},
{0.272245021048235,-0.9410089372193952,0.16284812961237613},
{0.2717259222171114,-0.9456752904924018,0.17291859020359635},
{0.28357099694435095,-0.9452074390268792,0.18002358268052993},
{0.2884688839389314,-0.9395974413244371,0.19295229531452038},
{0.24034810484632202,-0.114636624079892,0.31920897880320537},
{0.2538449644928676,-0.1246937206432519,0.3004275985865193},
{0.2660653050320847,-0.10082391271581671,0.29393902255864635},
{0.28373801170194296,-0.112353053920125,0.2645756111413685},
{0.27891388449448845,-0.13192806658326914,0.25912411618513287},
{0.22187137113197847,-0.1014702476312557,0.33604272327251417},
{0.17771014239393995,-0.11495217194878773,0.3576211183457182},
{0.21372675311669911,-0.07729437382464198,0.342124605340531},
{0.25214868062237883,-0.07591829860611797,0.31458203979759586},
{0.2069505312362827,-0.6855944989148218,0.1356686313149274},
{0.20459644269562255,-0.7139051640572827,0.1346842148609117},
{0.22806237310630983,-0.6801054350935576,0.1316081267204808},
{0.20723736647166596,-0.6651851030287957,0.13971738355416366},
{0.23005714363865012,-0.6119197851568752,0.13595781659638972},
{0.25042299249089256,-0.5913659485544349,0.12785320992169757},
{0.23593359109538947,-0.7189657694322654,0.12425756717719198},
{0.22140888907553505,-0.7349740262192974,0.13514538909333915},
{0.2062066672837521,-0.7496675660885481,0.14127485109519203},
{0.18089097438291005,-0.7736103242483569,0.14084448775170458},
{0.1585146504860583,-0.7679881672885125,0.14163433058949923},
{0.1766986122301682,-0.7281475503245834,0.14119919597253056},
{0.187692363641972,-0.6811194364178988,0.14849315786447975},
{0.2145409134068902,-0.6002658184715757,0.14976589798722267},
{0.23892175436534438,-0.5383627638738736,0.14912504509609079},
{0.2603063875018954,-0.499942559593664,0.13779812578183817},
{0.26659846589300074,-0.5545687953118625,0.12207058476119557},
{0.2717255174397353,-0.5994072814071001,0.10407140229569296},
{-0.349226547113434,-0.7571606402028889,-0.23808228592747277},
{-0.3535812419925427,-0.7399193709708154,-0.23773095191385593},
{-0.346169223219769,-0.7558911521104568,-0.2452814534200371},
{-0.34124438506382765,-0.7655766109845152,-0.2544486240801321},
{-0.33884063002038983,-0.7466010821147328,-0.24187545046987613},
{-0.343134675224766,-0.7352308091249181,-0.2363484119437992},
{-0.3516135447984617,-0.7230220998264207,-0.23907732008515611},
{-0.35771945959358153,-0.7214533558888816,-0.2338852428059136},
{-0.34764900856403164,-0.7396914441237616,-0.21048820954179914},
{-0.34493661555210375,-0.7551937525635602,-0.21606643487623195},
{-0.33766859128446347,-0.7644395668994904,-0.21189766030172005},
{-0.33971302831958133,-0.7675579261219234,-0.23706974328905658},
{-0.3330351875273212,-0.7694007988974209,-0.25903953471203955},
{-0.2776431002645263,-0.24666943929253538,0.2820767633850565},
{-0.27203798645079336,-0.25091187378783886,0.30332376477685696},
{-0.29630401299706366,-0.2470030629679352,0.27931373070479565},
{-0.3016063458965711,-0.23965718545587147,0.26667143684232647},
{-0.3133544578500827,-0.23004127285955867,0.2658430721596963},
{-0.31285207706828017,-0.2383158817826085,0.2587916473470241},
{-0.31666945707193006,-0.24604223409214943,0.25957117632978516},
{-0.3366602834035838,-0.2703330434254375,0.26127540488588785},
{-0.3356030590798413,-0.2331880004953732,0.27168201130865227},
{0.3379858400682654,-0.012918727594174546,-0.17213477440531605},
{0.3452536624784216,-0.009580385147893888,-0.16900227241009694},
{0.34988933553864915,-0.04803528129277871,-0.16284164467509502},
{0.3488817777176843,-0.051168796825049934,-0.16658240701460625},
{0.3546026196143189,-0.08246861965117705,-0.16012779191483423},
{0.35412333982796873,-0.09231335045469752,-0.1537286196291108},
{0.3670034696151491,-0.07146309463600665,-0.15417523462489008},
{0.3789870472615446,-0.05290589309161563,-0.15306619560977514},
{0.3484003497427392,0.01899922215758958,-0.1724233519895102},
{0.32616571067643874,0.03114284304151824,-0.18130492405691437},
{0.34401250349028195,-0.023779649344535633,-0.1840498809306711},
{0.3551464194270589,-0.05208488452067194,-0.1780477984381882},
{0.3634717285756869,-0.08744281939885425,-0.1667516910752834},
{0.35454288148548857,-0.11373601885330634,-0.16302195227922384},
{0.3463468546186208,-0.11097211499864011,-0.15615768441384087},
{0.3401519217353871,-0.13476119161889066,-0.15107454536917714},
{0.35982124221513834,-0.12024070523323219,-0.14452726387286663},
{0.3875842977504472,-0.09537756512542757,-0.14211222180883995},
{0.404827188216841,-0.10720782670055203,-0.12682146744931286},
{0.389809346238328,-0.07218594628684223,-0.13896656826732282},
{0.36408888339817636,-0.013911979031550309,-0.1585695658146285},
{0.35005667433062343,0.026176423306244315,-0.16714839521448835},
{0.3202849062852646,0.06597505391346467,-0.18566192861060515},
{0.31527674348467083,0.07538297893252904,-0.19273736596463187},
{0.3220397532615441,0.057170018767205545,-0.19856580852441066},
{0.3319916395793356,0.002539487734225315,-0.20019497903104191},
{0.34886532314550045,-0.0494052774138056,-0.19951235226476363},
{0.370210745996954,-0.07383542046915816,-0.1843500897555851},
{0.3705163656648518,-0.08100322037108933,-0.17452051526190282},
{0.37497136671507103,-0.10225283634851377,-0.17335406904069595},
{0.3608289211505937,-0.14434873473941423,-0.1769458116861257},
{0.3369260425928036,-0.1417939541759469,-0.16094016842230985},
{0.3379946750516255,-0.14771471784972545,-0.15138995193783397},
{0.3376180514824648,-0.1801407216410053,-0.14208490624159964},
{0.349343063502932,-0.17268679725451663,-0.13408712042271803},
{0.3670460232976292,-0.18348790013305383,-0.11734992438809078},
{0.3813283699099422,-0.16318987327067894,-0.11627485798756274},
{0.3912992233943918,-0.131768468494609,-0.12514090721443372},
{0.40119327754296674,-0.11972551818767038,-0.12886098022422468},
{0.4141186361554965,-0.13827826186888453,-0.11379262075427718},
{0.429097571697546,-0.1438553514893669,-0.09784928983341876},
{0.44104236508437655,-0.14628733470835503,-0.0733039052779421},
{0.4222516016818999,-0.13002351041023855,-0.09626481057378417},
{0.40673976875607154,-0.11130468476549096,-0.11142031510687404},
{0.39572022208260543,-0.09501743649994755,-0.11507706329906327},
{0.3743956309235189,-0.045368724803468236,-0.14219060306994563},
{0.359243844817769,-0.009524537556469145,-0.14857151787742923},
{0.3428550739241709,0.05513763899833978,-0.17020097864449862},
{0.3695876746253624,-0.04704535306703718,-0.13603506214354497},
{0.3847626010356535,-0.05480372103597624,-0.11626346897582394},
{0.40285543793695944,-0.02345826566953157,-0.10250054522901687},
{0.4122368569435356,0.004903302618399236,-0.10697102874827252},
{0.43735086340785895,0.0027054071493635757,-0.08471741189123604},
{0.45459415971403666,-0.001821935373553312,-0.056663438287324376},
{0.46696903171906134,0.0071418065012121435,-0.05396376017208402},
{0.4723565739746786,0.0190069214269992,-0.0269689816584051},
{0.4639014948991046,0.025665532637872024,-0.0408937281758295},
{0.44858216814389645,0.026058569345311856,-0.0640963599337884},
{0.45074370908003175,0.02511135735044549,-0.043736548745138375},
{0.44527089691105926,0.027795422320488733,-0.02532674141087734},
{0.44965602871155835,0.038493422770555466,-0.0009339334908349088},
{0.4517611961644025,0.050847625631608113,0.020310795410656838},
{0.46146963385701495,0.12142221745961326,0.06333574393488683},
{0.46657607575461507,0.11577963570959376,0.03002376533499288},
{0.4583862501621427,0.08960226420437765,-0.005989888706826966},
{0.4555753336994118,0.0845629760421317,0.0039130609823533865},
{0.42780255182058907,-0.007580022100834151,-0.08247192692669407},
{0.43132926660869536,-0.023304989969757394,-0.06116058824264755},
{0.4622347544650371,0.0450003784535666,0.009079739278047422},
{0.4617906531261396,0.030848125802581696,-0.02091361091491524},
{0.4315708113990763,-0.5100323209475949,-0.12639969579779664},
{0.42172701232720666,-0.5205858817436553,-0.15368306676937907},
{0.40445871119077864,-0.5074408214453481,-0.16821666432983873},
{0.40162319467517343,-0.48990678130544874,-0.13981090093935916},
{0.3712565218141204,-0.4843488203376116,-0.200308456934199},
{0.39752572785055845,-0.5115594025628079,-0.1843459559267907},
{0.42316959321231995,-0.5341177371035101,-0.1403084583896977},
{0.4303555496637487,-0.5191056501881118,-0.1388862013660175},
{0.4408659076461565,-0.5166782066377021,-0.11553163147971908},
{0.4541493285009727,-0.4930288685168922,-0.06822664347329133},
{0.4386667149771829,-0.49486720162381137,-0.09335757090682775},
{0.42359926811554555,-0.46438101319600866,-0.07782628423156389},
{0.38899855059367594,-0.46660306250663774,-0.12978456426936427},
{0.36975513453182735,-0.46747894656585864,-0.16679339376910643},
{0.35350707636563283,-0.4560172427597902,-0.19321117541316093},
{0.34448209730461515,-0.4479000423029012,-0.213668433833501},
{0.3893196909772913,-0.512772638286439,-0.19154066661858601},
{0.3817247712629211,0.24280834120744402,0.1682287014103425},
{0.39581059899031035,0.22621510886812357,0.1753726704426549},
{0.40010243544884644,0.2358636862550074,0.16922107104923473},
{0.37625718720278867,0.2568301758627182,0.15895883416156104},
{0.38794373793566544,0.253097093669276,0.15811239367242674},
{0.4092609124258202,0.23262763562003697,0.16447247784995117},
{0.421669422386971,0.21201706006601814,0.16584083255090937},
{0.41055706695431976,0.21422532994733273,0.17452339332466407},
{0.40747015819032933,0.20282992995036933,0.17884951687049927},
{0.39244947958295995,0.2255396746027288,0.18450225098956502},
{0.37280783907632825,0.2505742480222133,0.17074390728283312},
{0.3488612307506107,0.26168968231270207,0.15164370591878423},
{0.36581884665869613,0.26693630998343143,0.14849777827605176},
{0.3711367215220772,0.26690202395854024,0.14026513446155434},
{0.3957625324736967,0.24813124125977337,0.15040323537090644},
{0.43095742599950176,0.18337730985432818,0.1647415910606317},
{0.42136092571871986,0.19606229976192407,0.1725317228983176},
{0.4173884872949884,0.1588102638659838,0.1802339203038573},
{0.4071055302677677,0.1976504974488988,0.18654695150182019},
{0.4002401075650937,0.19206984132539334,0.19785539979386282},
{0.38095462440354294,0.22243217743776011,0.19498444241607538},
{0.3787475699167646,0.24201116244371135,0.18025108456445918},
{0.3618494477837129,0.24906710567680562,0.18075563265819705},
{0.3506701001016947,0.2628730091316251,0.1619175134899325},
{0.34623013530923097,0.27310404947632333,0.13876801380903223},
{0.3522329274901321,0.27492811763355807,0.13298882235057685},
{0.3675208452208024,0.2674585492920457,0.12951808583005617},
{-0.23283424047351886,-0.2749285532207608,0.3142700382459747},
{-0.2555220198443766,-0.2547613512562884,0.30153001136411417},
{-0.23891713501618006,-0.2647843232807444,0.3191248233556444},
{-0.2201559787945929,-0.28285170807811116,0.3352250570365453},
{-0.23891081368970193,-0.2701868199887158,0.3319591782398605},
{-0.25472388810083696,-0.25690834357985387,0.31544128655048936},
{-0.2593315773393107,-0.25744233524367843,0.28652844122364163},
{-0.2486926053296562,-0.2854255376136378,0.27225942889177007},
{-0.23321909132877144,-0.29946171902399793,0.2906840855000118},
{-0.20561524822808713,-0.30521696806001436,0.33481224254528746},
{-0.21155171641413462,-0.2923998581793938,0.3447216166145036},
{-0.21692817456905508,-0.29315918441521216,0.348676769663143},
{-0.24816337537764258,-0.27198527455602417,0.32532208822402436},
{-0.28122872344096206,-0.2623550959476192,0.29397480764095957},
{-0.30979825805798517,-0.2627157918988705,0.26522360766262465},
{0.07912997707468969,-0.82542069905787,0.15297890924639382},
{0.0855469914371986,-0.808092376129726,0.15667430039790906},
{0.049607646447343216,-0.8349446942551514,0.1564938408694632},
{0.05416570424249706,-0.8495245947352577,0.14953905479613652},
{0.027009625662844046,-0.8440277498391822,0.1541701180688701},
{0.05401146175161448,-0.8149503014204744,0.1556751122256829},
{0.08623852543056819,-0.7905883256375283,0.15631916721395853},
{0.15005110083300383,-0.747656746823808,0.1517929083470093},
{0.11693630937254705,-0.7913108521915736,0.15153904281323882},
{0.10075354041599768,-0.8262173104958314,0.14697602569842105},
{0.07056447026878543,-0.8698004119623339,0.14624786625815947},
{0.05335680818301174,-0.7932438585833871,0.15845985733438644},
{0.08766114686012771,-0.7743740265419506,0.15967392386092613},
{0.12325688897801032,-0.7563557611073387,0.15392554435381856},
{0.13892169375497868,-0.7282532460905217,0.1551239467395862},
{0.12973076446899615,-0.8055328126062914,0.1441417957586756},
{0.11076525622969126,-0.844505003613836,0.14446929996508145},
{0.09772643989975295,-0.8729839392799217,0.15050528495323573},
{0.06299721990345669,-0.8963920566447331,0.15063944156203496},
{0.021320223600573774,-0.9053917865217037,0.14949546739085595},
{-0.013395852286279139,-0.9066338783039019,0.14745074669285238},
{-0.2929704120768456,-0.13999371582592307,0.23600953997381074},
{-0.29695679141587916,-0.1287167371156635,0.2252286207188756},
{-0.2992340604349164,-0.14680130635938052,0.24311245544347293},
{-0.28739844857405344,-0.15529225232266905,0.251217761182505},
{-0.31309275068425585,-0.1462536149468273,0.2480677294583969},
{-0.3284336177578414,-0.1258947163664873,0.24072359429514395},
{-0.31088553364908245,-0.12318868611494227,0.22835293686190747},
{-0.29811811151939577,-0.11563109197421186,0.22269280625965837},
{-0.2947138700413862,-0.11846527091838237,0.22647518948759116},
{-0.29149423254469503,-0.1326087693290009,0.24203044833271267},
{-0.2863592788086588,-0.15324252662146573,0.26873974511856},
{-0.27929942485241055,-0.1757771917785366,0.2816376064921136},
{-0.2731896800771304,-0.1874919494388075,0.2759589336863312},
{-0.2673384212471928,-0.19138973671525952,0.29550342974749916},
{-0.2706454364743371,-0.17452569874961493,0.3000584533059435},
{-0.26551074621543813,-0.1605357182677516,0.29848687167713994},
{-0.2575016330044708,-0.1752088322844193,0.2924384458935136},
{-0.2582892872821738,-0.15146790186136821,0.2830656993219021},
{0.08255072305805014,-0.7088135958690427,0.14823775290179045},
{0.11247505711476508,-0.685905751468936,0.15051146497947496},
{0.0689000097618811,-0.6884484556428104,0.1545101555002277},
{0.019351613798182763,-0.7255742073718343,0.14965820595700677},
{0.009966582605047415,-0.7003697421944047,0.15464728047645213},
{0.026793957939526603,-0.6685167990518079,0.16855263805131748},
{0.05814414633277125,-0.6564726322879251,0.1709033024516013},
{0.12019061748575723,-0.6532469560652336,0.15595176428219348},
{0.18371386630649164,-0.593962635794025,0.15479293658740254},
{0.12958717474123907,-0.6877072859564898,0.15157648100210666},
{0.09419843747337929,-0.7247451733722831,0.15017457864968617},
{0.06854806805099614,-0.7346151129883537,0.1482036081771381},
{0.024891489397845558,-0.7451651072813911,0.14922050774998902},
{-0.013430260488068809,-0.7421179145086161,0.14988581939375623},
{-0.014833696957368974,-0.7315132901435059,0.15072939244420738},
{-0.0064942885946751355,-0.7087456708256173,0.15411831400157575},
{0.0010742812811553675,-0.6891889761979583,0.16010469198178975},
{0.009728018930985387,-0.6750800071036199,0.1658510454772009},
{0.0206166790868957,-0.6442566284973943,0.18200860562120005},
{0.0444115925756624,-0.6389037377349553,0.1824121197944764},
{0.08269410986591526,-0.6270095234592126,0.18235505680851538},
{0.10084046237349965,-0.6334398009208398,0.1727310380406012},
{0.12564815116799313,-0.636244151703296,0.1610893517271943},
{0.16820792974401685,-0.5903026653189436,0.160596565550337},
{0.18819555504093474,-0.5336239480136789,0.17204469284698282},
{0.2052739029727137,-0.4896493492686552,0.17541349240040224},
{0.2107837166809435,-0.5474396585550058,0.15675167768363293},
{0.17752114110668998,-0.6262467932687662,0.15075974756019628},
{0.15019167119776078,-0.6708782638899029,0.14865976678228768},
{0.12185113645968111,-0.7109641546956312,0.15084425785196623},
{0.09426372774543214,-0.7400837509570349,0.15326399044648048},
{0.06192571894354388,-0.750812228699989,0.15205487898997339},
{0.015549290238036771,-0.7565506183864453,0.1511545776120218},
{-0.006986556316520413,-0.7611043043734551,0.1526194191280085},
{-0.0238319968334255,-0.7674003540449597,0.1556714851654146},
{-0.01160694876519573,-0.7323997101009931,0.16292747235255117},
{0.007830315288338642,-0.6736138800741813,0.17550081913528037},
{0.00619764308556078,-0.6687987089645773,0.18207385552175614},
{0.015150088378067176,-0.6488887764885034,0.18291268598373697},
{0.010654329114569186,-0.6464336115310693,0.1891848654765338},
{0.03623491852948803,-0.642975144758363,0.1868846282630207},
{0.0458089552595046,-0.6486804638144646,0.20098540088109376},
{0.0813809833726277,-0.6312174275758281,0.1918007121785957},
{0.09741390076977925,-0.6200136413269233,0.18626447426327938},
{0.10921117351995027,-0.6076807556786074,0.1854186425338211},
{0.1382211632922618,-0.592084260536692,0.17741003609137979},
{0.16613226641850473,-0.5356373616782945,0.18476624870663336},
{0.2035103017560679,-0.4557664571462652,0.185401214796082},
{0.23606137431972776,-0.3999673518892317,0.1775774758120963},
{0.23059723564812806,-0.45488781826358915,0.16700790665513282},
{0.23680305077457456,-0.45675970858364096,0.16262521733019233},
{0.23652728051654742,-0.4967574110417561,0.16175312394204266},
{0.21228097013444208,-0.5696896589758521,0.15862940487220084},
{0.19004272419362175,-0.62059432156443,0.1560593447595892},
{0.16684401272048718,-0.6593752217958908,0.15658591975448197},
{0.13631650619048913,-0.7031107076020139,0.15813113773344428},
{0.10177704604062025,-0.7426421798289268,0.1630580019010821},
{0.07488670221480734,-0.7586116916654829,0.16184983280030377},
{0.05991375546559087,-0.759927705783202,0.15342657815072208},
{0.039785660732658136,-0.7664448743925045,0.15387108532940338},
{0.01008781077318905,-0.763522669649116,0.14879579854087413},
{0.013216271369093454,-0.7733008544145504,0.15865498765230066},
{-0.014239658004041075,-0.7718522348034368,0.1519306314588316},
{-0.02820061350449544,-0.7903375410864111,0.15490625194216448},
{-0.01270526171104628,-0.7332370117581332,0.1698937993619337},
{-0.015173899061937408,-0.7204348159583698,0.17890761251685303},
{-0.014727712216506131,-0.6854067746417614,0.19034212293257943},
{-0.0033840791025637703,-0.6609989219647009,0.19171440854244},
{0.15253420924069472,-0.4664751571054011,0.19793742830098524},
{0.1897681491443825,-0.4442073252318473,0.19038894218242242},
{0.16534771224679548,-0.39423544607764854,0.2067090379726804},
{0.1493886353797635,-0.4277813105700108,0.20398152796000335},
{0.13605524417353532,-0.4022732124272908,0.21146423722373558},
{0.15839051450773672,-0.38008740906085947,0.21296159266838405},
{0.16561902464164563,-0.355629463855489,0.210691557584135},
{0.18926736941115185,-0.3751673528024775,0.20133292510029868},
{0.21250135919807367,-0.3995288430650538,0.18773115905681895},
{0.15975507960003144,-0.5003982528641922,0.18894034169464943},
{0.11713708320075576,-0.5350792151104686,0.19256548856648692},
{0.0977611009546017,-0.49538012042869567,0.20651403939333476},
{0.12385943356827675,-0.4484555955332592,0.20552418234891662},
{0.13466013060702997,-0.42308107711189685,0.20534622585327456},
{0.10286006562602487,-0.4240923225503752,0.21288076999412764},
{0.11826573745129348,-0.39634061459290043,0.21888085728474063},
{0.14390026106116882,-0.39459662861167755,0.21513105704197738},
{0.1607204885158925,-0.3865747495084477,0.22231093439590913},
{0.1650102989627322,-0.35689716816520556,0.21868555379435312},
{0.16129170588702252,-0.3365349463732314,0.21494189426874008},
{0.17074577127733837,-0.3302831523615207,0.21247482503177864},
{0.19583489402590182,-0.3337106563209699,0.20271306296629374},
{0.19942993863480957,-0.35912213591009273,0.19902616257800765},
{0.20729197742039823,-0.37607160633748765,0.19232006386277842},
{0.2274731415483287,-0.3572541361274465,0.18454065171991005},
{0.2382731703325685,-0.3701691606991942,0.18214684506321868},
{0.25314780823735983,-0.3798134417088884,0.16912476696834983},
{0.364059906225119,-0.07417196257881607,0.2727204915713773},
{0.3598834111330414,-0.06574756265361363,0.26201616873242456},
{0.35826676428969156,-0.06498807493180785,0.274070102211318},
{0.352860295238913,-0.07514892199240318,0.2842458229812737},
{0.34634811144706174,-0.06520433016664505,0.28030736779620696},
{0.35237063997787627,-0.05299108226197714,0.28538347476356674},
{0.36093324003600824,-0.051222779890765575,0.2799483940080181},
{0.3650670996402047,-0.053196070661973814,0.2699421591562237},
{0.36391218373097545,-0.056573725384501755,0.26075081446878684},
{0.3557798662733371,-0.06433501178769888,0.25582826686408694},
{0.36346552836369916,-0.07578982587911001,0.2567023055209394},
{0.3664004989993502,-0.0828468230207533,0.2698125719634215},
{0.35998635207552426,-0.09170081604377989,0.2785190241640402},
{0.34857441676338347,-0.08890278765020976,0.2845324149252682},
{0.34169371451156516,-0.07670088732337603,0.2854775998460303},
{0.33259712278960857,-0.07413240701117997,0.27687516268219214},
{0.3366525618236102,-0.06330585309111159,0.27565665847822396},
{0.34042503703629334,-0.05480688276162318,0.28496526961507357},
{0.3405223844016491,-0.03970774215015437,0.2860629610523543},
{0.3566362562116257,-0.03789810149099911,0.2833757757905689},
{0.3652119047624979,-0.037384698228152796,0.269816564491977},
{0.3651428046960332,-0.04283177463030058,0.26113039684370243},
{0.36079427071982323,-0.05174485665098469,0.25459677366221595},
{0.35104068494485524,-0.06861140827351116,0.2514887282948165},
{0.3567847085799357,-0.09272811021465809,0.2512525943474192},
{0.36412454842840697,-0.08996412561699824,0.25533694999723294},
{0.36679767059799223,-0.0901562259478342,0.2628327194401913},
{0.3595709431843909,-0.10123769931022204,0.2713507589274876},
{0.35198651899679,-0.10098432035922918,0.27725893944314733},
{0.3420834683788677,-0.10019986817866984,0.2770008593375888},
{0.33715121355399447,-0.0926588082907091,0.2799058392631302},
{0.33065787581431055,-0.08665220631539629,0.27420299243000595},
{0.32933318926162664,-0.07389134880357655,0.2659673303149162},
{0.334312617118144,-0.06468492748688737,0.2582432483708684},
{0.3320842857901257,-0.053791989014720265,0.27585903335500456},
{0.33094327148710945,-0.037324797550927324,0.27376796936585746},
{0.33711263221432153,-0.02873463969657392,0.27718728641071155},
{0.3488168529139185,-0.02817641238575452,0.2820044420981073},
{0.35762099670002373,-0.02833576718302583,0.2763361245812632},
{0.3587552838367779,-0.028238419817670043,0.26386370229099093},
{0.35830113105757644,-0.03762121676717787,0.25374311942404193},
{0.34980836094007556,-0.04231593951597382,0.25162362540186034},
{0.3411188700801668,-0.06738463641195429,0.252123554146434},
{0.3502951392007591,-0.09883627412711478,0.25055290531168894},
{0.3610124308518662,-0.10021559287668719,0.26109732621334747},
{0.3663241862462535,-0.1094001285924604,0.2616419366432475},
{0.35902260476548054,-0.10986854738375418,0.27831117788703064},
{0.3433076065314599,-0.1085685819984349,0.2823034546518256},
{0.33475586853079214,-0.11056675754781087,0.2781270817366462},
{0.33403301687995657,-0.09899765599849035,0.26758363293813514},
{0.33137833492275476,-0.08370617070238896,0.2603000252727164},
{0.3364517879954015,-0.03952496232304832,0.25624768740711645},
{0.3301663963990615,-0.04810660922842415,0.2661626529286443},
{0.33527008347320647,-0.025855070441066826,0.26305671537834285},
{0.3302765914620811,-0.005848924188771945,0.2718008788066369},
{0.33700653060859936,-0.018098565935429065,0.2824458289850465},
{0.34804638202015786,-0.01707078518177325,0.2869332111629511},
{0.36237172746382407,-0.019269570948554898,0.27657394032022603},
{0.3635407064652534,-0.01759642844501535,0.2625029257449518},
{0.35909709442677296,-0.014008354293758591,0.25495262609625485},
{0.34779985241232547,-0.02534936644763013,0.25542675957916644},
{-0.1619581224349136,-0.5217123878055984,0.3581577044094183},
{-0.17411793547629656,-0.5021261890506075,0.35310437334072053},
{-0.18565692413860924,-0.5033285627167743,0.3381435539766719},
{-0.16748318488246122,-0.5253799768070957,0.34589335150179595},
{-0.17826235222691533,-0.5255962331043407,0.33939948574542983},
{-0.21131738643520118,-0.4787235834575219,0.319981517142567},
{-0.19617299681263473,-0.4830506387350078,0.3374489305013867},
{-0.19143916576989134,-0.4808728450841726,0.3432599463858341},
{-0.19112041580385186,-0.4692762654192167,0.34133747695469463},
{-0.16428680030553927,-0.48790147275002665,0.35936040317237544},
{-0.16120105594051015,-0.5077549924337201,0.35902246293403767},
{-0.1538200807239872,-0.5184491023463814,0.35817184930701995},
{-0.15588477150162267,-0.5229210838606512,0.35215047455108883},
{-0.16893785384365329,-0.5389019443374493,0.34605323325334175},
{-0.19428729625344188,-0.5153344721753665,0.3316323635361243},
{-0.22136637682695967,-0.4754481398033106,0.3135503886922829},
{-0.23140659385501122,-0.44841717461716574,0.3090100359233069},
{-0.23207623162338661,-0.4418802282240451,0.30655053527959425},
{-0.22765464542365316,-0.4393122355570345,0.3150831031937122},
{-0.2324999081721088,-0.4251064864231116,0.3123272237052458},
{-0.21103192914274926,-0.4426066463779037,0.331753337788799},
{-0.19494759226993114,-0.45109183727807756,0.34534031086591205},
{-0.16550423041521012,-0.47796717565596153,0.36420803615265845},
{-0.1543301522759368,-0.4895632687381399,0.3650865741065924},
{-0.15552345829143285,-0.48553303745428067,0.35692375917031843},
{-0.15517923603570602,-0.48789871686416375,0.350930531846944},
{-0.1535725683889292,-0.5009849303937945,0.35158304678862223},
{-0.15933655147956355,-0.5090457169958954,0.33796040974368646},
{-0.1724033420695853,-0.49508216072111855,0.32020559488612},
{-0.18502324462502032,-0.4685800005238627,0.3033257100455597},
{-0.18094619409131807,-0.4547310578661934,0.3072004770695531},
{-0.19127164424377333,-0.4219793729603122,0.29590866502143004},
{-0.20332180936215952,-0.3880387697831962,0.28550598950756806},
{-0.21072487203708265,-0.3617919348680438,0.2841389723780444},
{-0.22395809943484687,-0.3349136780559017,0.27903415065235676},
{-0.2177296284618211,-0.36469079532459125,0.2665532386612631},
{-0.21514321576817555,-0.3623384098236529,0.26334612376544553},
{-0.19038864842666248,-0.35991274899355075,0.26515503455043427},
{-0.16832840891465137,-0.3333183484252888,0.26689275870001655},
{0.16707206174443934,0.19301591760630923,0.23665747593782163},
{0.18677899252312397,0.23359340894177727,0.2507373053107075},
{0.2004137473915571,0.1980940314620249,0.22443176598952533},
{0.20006995116136267,0.18228030791971703,0.21144316330238755},
{0.22197702652641974,0.1932318498691718,0.2078272668153644},
{0.2114382990682228,0.2103346767393345,0.22329196601863754},
{0.19325105448397562,0.23524409958103745,0.24255702439001325},
{0.19511921575260918,0.24503176846100463,0.25576824507237106},
{0.182956546959029,0.2417593229216372,0.259957242579574},
{0.1633970560740102,0.24099691782798116,0.2653579565672377},
{0.1376572818470698,0.2103486176546365,0.2581810783905577},
{0.13833805471171703,0.1872775279198528,0.24950246871145385},
{0.15033678016868826,0.17803138954954023,0.2347506908332026},
{0.17201136776995704,0.18418899792154195,0.222986711819027},
{0.15611427921150003,0.1799603439179609,0.22381979890437909},
{0.19391062062629844,0.18773257312161595,0.20262143029255578},
{0.20891737850411438,0.18237319742189598,0.20200512645872318},
{0.21676626574340502,0.18404633992543545,0.20355281666066272},
{0.22447006419751656,0.1911300863709556,0.19235476528912396},
{0.2266357591481949,0.19988413762875087,0.20049622157875638},
{0.22755581812421607,0.2088743037106029,0.2107146893894138},
{0.22316997769770683,0.2140297438564673,0.2150573779978452},
{0.20615426508085996,0.22724224155301445,0.22677783016398553},
{0.1905399576095778,0.24910114841030812,0.2352100313497475},
{0.1930199042916218,0.24854916274538089,0.24623571767795585},
{0.20178025881496245,0.25108384255305555,0.26234877887077224},
{0.17633141221829512,0.24598895009077365,0.2739987328417679},
{0.15554411574891894,0.23817700383349508,0.2703737995139005},
{0.1232229673589984,0.22662305965642063,0.2675581617108555},
{0.10065943551928248,0.2114971708034829,0.26429973889219155},
{0.11159077365938685,0.19923002163850081,0.26094526590810957},
{0.11103692346875052,0.1835117001928459,0.2534926992788039},
{0.1282552946252637,0.1707513282013961,0.24874121845508887},
{0.13196742401184836,0.1682315635369865,0.2431770763986047},
{-0.146685757292195,-0.22589075576328657,0.3288813870597079},
{-0.17252325285204081,-0.213227164873829,0.3197286247743518},
{-0.17395239959037825,-0.20503020627531057,0.3145510153646857},
{-0.17049793490789783,-0.19614249349075621,0.3317725886183425},
{0.3503693855706625,-0.5132883119147784,0.07904158208875706},
{0.3503514319410568,-0.5044570151098279,0.09019638496310713},
{0.34271618641338725,-0.502749666261983,0.09269136259086767},
{0.34363081436067633,-0.5141946722044788,0.08545884505469394},
{0.3347606907998483,-0.5395795661005278,0.11083705215597765},
{0.3361255809889334,-0.503275552816614,0.12009666504456294},
{0.33906723948175754,-0.4737717537687227,0.11303420181472969},
{0.3446046524201133,-0.4793201498790333,0.10840111784233872},
{0.35182805662208033,-0.48896994372286123,0.10282439262773566},
{0.35847965594139763,-0.5209880774688377,0.08591205547816673},
{0.353896059987272,-0.5223600199209752,0.07188881313254236},
{0.35525183153011125,-0.5308377537807205,0.06776111761846813},
{0.3308571898941864,-0.5469791026439247,0.1308173415269574},
{0.32980221575018853,-0.5112189709781522,0.1363882001256256},
{0.3324798361544474,-0.4900769970977765,0.14204873656765862},
{0.33626876487690655,-0.4673719535999827,0.12910032689284381},
{0.3398405873758716,-0.45360909041042086,0.1288713355131629},
{0.34282236876210304,-0.46259423024091684,0.11935989797621292},
{0.35324960395734245,-0.4732846121645677,0.1228346769584562},
{0.3764088820397393,-0.5160130671040004,0.12584302916405218},
{0.3659651115293225,-0.5241404794247733,0.09817737092726622},
{0.3783251098249867,-0.5554741824360074,0.08538133603040145},
{0.3617152199935904,-0.5403379191707909,0.06921887181194462},
{0.359138350909315,-0.5454051709690422,0.06967559774286551},
{0.41627138354217647,0.42860342404507834,-0.126589162419668},
{0.41892043261316203,0.4372345143475914,-0.1026985429856142},
{0.41815664851416673,0.4267488785949563,-0.08986280059679634},
{0.412583611979485,0.41902657937121607,-0.1311699206825292},
{0.4055429876046241,0.40822093788650843,-0.11988803896021981},
{0.40746342996165935,0.4142929512483647,-0.07219729811430758},
{0.41498317157447534,0.4266827373342465,-0.05729011759584365},
{0.41704566423034906,0.4390143268450322,-0.07605150754714936},
{0.4070496029957572,0.44676086065335957,-0.08987081540132595},
{0.4061272747166506,0.44422399228559345,-0.12418633910788084},
{0.4134564554275497,0.4367739584365103,-0.1286419287320277},
{0.40119497952028077,0.42145483353878604,-0.16716164875193626},
{0.3963381875222553,0.40725232687350377,-0.16904158362393637},
{0.39605526407243347,0.40232716468317986,-0.1458827517528203},
{0.407181924826266,0.37779699911960224,-0.1376488723580382},
{0.4406199857355921,0.34636262553137787,-0.09245542518891547},
{0.4396837165411837,0.36149645800752195,-0.07688165601249497},
{0.41460513075329425,0.4013639039559136,-0.08325685612836074},
{0.4113881269655676,0.3962787388995535,-0.04777800649234121},
{0.4004417323819594,0.40875898263613364,-0.033919933501940266},
{0.404220854017911,0.41559794182263216,-0.028802497808307147},
{0.405702666436278,0.4245593325889109,-0.023322998844569367},
{0.41338022235503863,0.4362333192870095,-0.048803872787120804},
{0.404697053884016,0.4416761003743756,-0.04947088640820195},
{0.39718229708865105,0.4580844461318998,-0.07825664651264352},
{0.3992344546413349,0.4567426165667702,-0.10998971924428176},
{0.38305168674719337,0.45731117898077944,-0.15455252644856413},
{0.38746012140062874,0.4445766638706448,-0.15875842367682388},
{0.3856151408080335,0.4339241355373161,-0.17262633456355894},
{0.3721248670275112,0.4194783821043388,-0.19617848786740827},
{0.3768316661659,0.4109347502752724,-0.20091596615616836},
{0.3934069852471113,0.4098253457918703,-0.17880477356551988},
{0.3773059207633019,0.3999089619559141,-0.1960456380202171},
{0.3825680298406599,0.39613308278860304,-0.17062155402481916},
{0.44945703760365724,0.3005916800361438,-0.09419772831616507},
{0.48435028380437184,0.2779727170688653,-0.038818429256196635},
{0.48279175279312425,0.30192309375508986,-0.02981595730466457},
{0.4684366184968326,0.3245375181161979,-0.0397826419008619},
{0.4622212183271113,0.33035534190990123,-0.031038671830789528},
{0.4414292005174209,0.3623850665251007,-0.05169870140602382},
{0.43530827071270173,0.36510844270898335,-0.037650786763794054},
{0.42491070113078155,0.3636205118840303,-0.021692834986634404},
{0.41349880619013774,0.36913502674682575,-0.0015874067243590718},
{0.3950029640088972,0.4047332910208528,-0.009488290326757923},
{0.389598764261204,0.4132538229168748,0.010298053311017335},
{0.38837880137131087,0.4228275048026822,0.00985579100004159},
{0.4042335795386766,0.4333539933228912,-0.02254212272870338},
{0.39256911626420005,0.4372251120384601,-0.022552218790135636},
{0.39167459013511136,0.4548469357485965,-0.05017251115096468},
{0.39039383627024665,0.46857624172502577,-0.07093087081878033},
{0.39181449224535514,0.46635208459729866,-0.10355360597654625},
{0.3802705984461769,0.4656720309827398,-0.14680605213507425},
{0.3594267457593658,0.4594868648145166,-0.18865566527193894},
{0.36405824461930203,0.44066266637580553,-0.18974735835471626},
{0.34508409475485874,0.42706694012073404,-0.21614157260628927},
{0.3366068464154833,0.41171271858095837,-0.2292120210664059},
{0.3336635263168421,0.4009941297299135,-0.24062987399005648},
{0.35236075214837503,0.39575293308791626,-0.2236078379219158},
{-0.09498956901184909,-0.7741592299930385,0.24952974390719732},
{-0.09187149345230176,-0.767791364740703,0.24245919044187983},
{-0.07329513244543902,-0.7563045349898938,0.2423261376747967},
{-0.09056348457744197,-0.7616421865746853,0.25883821374380794},
{-0.10277726899805463,-0.7672150616233796,0.27505796405386623},
{-0.354313415209516,-0.2211243810444627,-0.23624277673510624},
{-0.3671453573655923,-0.2064646416797334,-0.21395251318302147},
{-0.36248433419257564,-0.18731946434339442,-0.22304916439981554},
{-0.3569553716459522,-0.21103089063911362,-0.23887184510238174},
{-0.3707664214042103,-0.18695277003763966,-0.22957111596908536},
{-0.3728311833631692,-0.17041773533582286,-0.20782368012659297},
{-0.3831277572713091,-0.22384897262288167,-0.1996725580506919},
{-0.3808196678016615,-0.29834299297445815,-0.20982835867418284},
{-0.3600832341062587,-0.24128947625424496,-0.23010482503243207},
{-0.3573314066411853,-0.2637787510999792,-0.24235118393895175},
{-0.35355066483332115,-0.23864107631443227,-0.25301696474732055},
{-0.36378180716916925,-0.20320694873523593,-0.2423485895390762},
{-0.38014289702723997,-0.17332316253505295,-0.2253522286805149},
{-0.38864766279133994,-0.1558725267203918,-0.203264907330982},
{-0.3871199734788588,-0.15584569773592916,-0.19363173060773303},
{-0.39477216016148986,-0.2071536110206461,-0.18928686300088032},
{-0.39975519489252714,-0.2878403363862757,-0.1945440680037806},
{-0.40748256073912015,-0.33755316226936066,-0.1923749680360666},
{-0.39610179009772056,-0.37685151991187643,-0.20103726550563342},
{-0.39124730883668496,-0.3959541425033276,-0.2125561130406565},
{-0.36857817259810266,-0.31573713312892954,-0.23072599150681772},
{-0.3608465316224763,-0.30283880535834673,-0.2520494076428648},
{-0.3537737077916658,-0.31361526781251275,-0.2602739251000124},
{-0.3435603374136878,-0.21630483387708332,-0.25529530679824736},
{-0.35785913753577686,-0.18687147140468371,-0.24539383704314838},
{-0.3784323471446591,-0.16339421466431847,-0.22727923778023276},
{-0.3928754254347673,-0.14087146334844525,-0.21001738014718122},
{-0.40077689761109364,-0.1459999937668534,-0.20432174706309672},
{-0.3955648799996379,-0.14217783186564417,-0.19468929915160646},
{-0.3912961041650572,-0.132553165028965,-0.18677684486573304},
{-0.408477270862421,-0.2837305095091824,-0.18791471869125867},
{-0.42576506611978143,-0.3768635166208834,-0.17735039889129162},
{-0.42161264412630345,-0.42535451508836597,-0.1742299934714137},
{-0.4256887523042769,-0.46892043317092613,-0.16710790897760947},
{-0.43633341881980076,-0.5126581882801344,-0.15723839432466338},
{-0.39354599599720114,-0.42352493515940537,-0.22191684271751258},
{-0.37696074765258375,-0.37094891172518785,-0.23630052816132915},
{-0.372805529401746,-0.4043077000132545,-0.25382312085706005},
{-0.3516072022238273,-0.37409223646878226,-0.26254314956710134},
{-0.34211394673416257,-0.3441361481049907,-0.2625999692616735},
{-0.33623873485770794,-0.26892041181652915,-0.26092688625297145},
{-0.3270048364877911,-0.20457629572509,-0.25523378594910945},
{-0.32199367450994565,-0.12497838644188429,-0.24445315035705997},
{-0.33693921538725774,-0.12945815009337303,-0.24106151328532552},
{-0.3670693080896327,-0.14371463982437097,-0.229419644237775},
{-0.3661684595716582,-0.10654122741851738,-0.21226427280207336},
{-0.3859635574497999,-0.11275168314228431,-0.20437508099763954},
{-0.39356532756973833,-0.1077131248542048,-0.2013114347150886},
{-0.40526817032640383,-0.13278725277891745,-0.20379914334860316},
{-0.41408771477614403,-0.11591032674411209,-0.20482878862796808},
{-0.4092580354254668,-0.13006063412639424,-0.19603538472242876},
{-0.404876835596278,-0.12101583691006161,-0.1883057092012536},
{-0.3951035538428935,-0.10193753070859903,-0.1804388481466088},
{-0.39359799236030935,-0.0834805131584204,-0.1739924401471803},
{-0.3948139032268097,-0.13586784021642984,-0.17167130112238463},
{-0.41845367649009313,-0.06411600066699877,-0.1516373729058202},
{-0.4292745571524484,-0.1783263808896922,-0.14674890840611954},
{-0.44651452918458395,-0.24222355795096956,-0.1329908281765249},
{-0.4604937283519767,-0.2815154306562042,-0.11861656522758814},
{-0.44681451490385754,-0.30294109716965695,-0.1186575284855744},
{-0.44640510436722763,-0.36456418712329236,-0.10316087311774051},
{-0.4409284016608496,-0.40140559708806645,-0.11192543158879108},
{-0.426816919972037,-0.39625177817652224,-0.1324494187813608},
{-0.42160202536022795,-0.3592816521933514,-0.15644549175237174},
{-0.4298741227512115,-0.381926067264569,-0.15220530743681288},
{-0.4263749657593266,-0.35765260386361847,-0.17306717431047514},
{0.0303927018524338,0.7336211423008895,0.16324355779979952},
{0.030538899791368056,0.7247461964710054,0.16803846454280782},
{0.05017293664529315,0.7223399893903387,0.14891372368312994},
{0.04262679632317809,0.7063408119404635,0.16938748767122877},
{0.024271457575002528,0.7132235402039782,0.17817352590341132},
{0.015726659222159156,0.715674813561599,0.18689102183323003},
{0.025171677147552553,0.7262090820942112,0.18526718992585134},
{0.010500706007440576,0.7215352324716869,0.19686133773932693},
{0.007907149683670836,0.7297471455225593,0.19495326605884827},
{0.012861158370891338,0.7368581257299182,0.18033652658787977},
{-0.015089112544136384,0.7279644156532682,0.200354780039594},
{-0.0308163422792903,0.731937016625395,0.1858561176351984},
{-0.0633022488726112,0.7446656948670136,0.1666082638959214},
{-0.05162522475057972,0.7472539519006199,0.16405331015998084},
{-0.02999137730165672,0.7460489838345775,0.16994012246732873},
{-0.06788662994610943,0.7528244365317385,0.18480268292011937},
{-0.06346259383396283,0.7659580663844022,0.20007515961565825},
{-0.045502845821605784,0.7872483715185975,0.19965740067844587},
{0.2000913703652493,0.09923065903006725,-0.22589219957550233},
{0.20566623105414325,0.031169915317369734,-0.22045754378307825},
{0.19149345162183326,0.08233946804557749,-0.23273326551669096},
{0.1940903205331592,0.15667429508586997,-0.23009846227204922},
{0.18951278455319004,0.2033848340495546,-0.23466708252566457},
{0.16155041387559765,0.19835697527054424,-0.2516114661444583},
{0.152809088138568,0.11880526691583523,-0.25813013487359066},
{0.16953318362247224,0.06287096070312387,-0.2500605143505375},
{0.21012252930430037,0.027472011571380402,-0.21852895488294474},
{0.20347060595060068,0.1070572760768142,-0.22888686796848676},
{0.19560234570486815,0.18969135458934328,-0.23557854874730674},
{0.1936978511514907,0.23027030461073636,-0.24213774514722272},
{0.1852051012197383,0.2536413790023857,-0.24528394582876276},
{0.14634199080941918,0.2677599129542508,-0.266699157186943},
{0.1151764775788162,0.1855753668093512,-0.2756142460959829},
{0.09768134281297229,0.15371804760897897,-0.28860671913477787},
{0.11520675088940363,0.1164080573669238,-0.2847771607503852},
{0.13196491141737435,0.07493125800480792,-0.2852935631904833},
{0.15416508172463994,0.03685367386934556,-0.27300827766175195},
{0.11175856822431231,0.0701139801405138,-0.32081731867987745},
{0.10203151927165886,0.06721763227844044,-0.32972124168281897},
{0.10204437653099312,0.047020762575833194,-0.3086005850151801},
{0.10924614798510335,0.035063000376848265,-0.2972151546531195},
{0.09373540933932084,0.06670917239914077,-0.3349933203950796},
{0.09020174321690426,0.0494581757611457,-0.330304191223411},
{0.08985032846029378,0.040271288936885696,-0.3240582330178086},
{0.08181405160640316,0.0498535635770722,-0.3163940506885784},
{0.0929058696336511,0.03234375802175993,-0.30363205852521613},
{0.35121779151424803,0.19860281537570704,0.2524312593208656},
{0.34746533631436394,0.19218704721756083,0.25830022955142795},
{0.360140599878446,0.16598706129967017,0.25366956149440023},
{0.3539279152230907,0.1712134246038039,0.25960396329725444},
{0.3536239582234179,0.18704425078706052,0.2676233096202617},
{0.34570011492580566,0.19787064322114153,0.2729582265673465},
{0.3480943667313701,0.20741425471625355,0.2707095501297389},
{0.344089141340169,0.2227103593615192,0.2611827990465946},
{0.337861015649682,0.2337059944223728,0.259929440429556},
{0.2695134579497573,0.19541564081210264,0.31050050059089024},
{0.29722220638496805,0.18053048613238581,0.2939489921935491},
{0.2819741268224114,0.17334169305210026,0.31011534694941145},
{0.2596350477562059,0.1696818851254141,0.32430488480253933},
{0.2424883296321286,0.16957229882207034,0.3294422289561513},
{0.2199194379450039,0.18541844386356032,0.3269794252865529},
{0.22570917592580353,0.20772510143058365,0.31962698103180653},
{0.20532877739858313,0.23736053386872194,0.3021773800023538},
{0.18423979323261946,0.24723809307361644,0.29007629155274894},
{0.21116443370740176,0.2548368640163031,0.27520747033072535},
{0.19931974463419774,0.25743184927857926,0.2565485443007954},
{0.18169447553552878,0.2680987243669939,0.2544837419703397},
{0.1728089523734737,0.2824900899568794,0.26238628717855567},
{0.16046534703034035,0.2904896786818171,0.259872783283379},
{0.153763554253971,0.30666936665571326,0.25825033994300983},
{0.151546733052182,0.3177604048756276,0.2510266127690681},
{-0.2844455434321373,-0.6147278649907494,0.12160827056518643},
{-0.29460225666393824,-0.6084551585436782,0.11893050248624171},
{-0.2812529792737054,-0.634962829450252,0.1185554300324858},
{-0.2827772837548992,-0.6129115779083258,0.13605274273434315},
{-0.2764178890800444,-0.660032256220399,0.1330827349514782},
{-0.27787970060895284,-0.6774322321809787,0.1176565469689625},
{-0.28167152757992164,-0.6644155638666857,0.11444073945243156},
{-0.2906717652878262,-0.6439009577350912,0.11469031817068287},
{-0.2992476975015842,-0.6087891062534605,0.11056813017870322},
{-0.3034758043651425,-0.5802197129366764,0.11826211092222912},
{-0.29864213354831765,-0.5864603208565402,0.12783312828924545},
{-0.28803740719205756,-0.6010869088479208,0.12587784745525699},
{-0.2926345392841089,-0.5859931185221905,0.13719737453595748},
{-0.28157963142904646,-0.5945488278032576,0.15103782749280545},
{-0.27154600026701814,-0.6141742570290942,0.1529202048403641},
{-0.2678336286514524,-0.6540939840658876,0.150397591860612},
{-0.26594335867626245,-0.7106173996596817,0.147030576089908},
{-0.2689805605659785,-0.7394229885435164,0.1402432095515494},
{-0.2773101459060477,-0.722687342561886,0.11543871223012143},
{-0.2880347936688413,-0.6960162627098324,0.11444548629053315},
{-0.29641254539185846,-0.6543107258835026,0.10371909617892872},
{-0.304482044800421,-0.6584025587594933,0.10181199660159751},
{-0.3095679397309477,-0.593932321049533,0.11275259043855523},
{0.32852344646311554,-0.5130384994668087,0.17890522209927726},
{0.33415946359526805,-0.513107720647764,0.16350891221164307},
{0.3363338522290676,-0.5054963059897131,0.16171236254154062},
{0.3467418780286681,-0.49891380567445287,0.1793575103527697},
{0.3433307882699059,-0.4962508156881654,0.16069731793272848},
{0.3265503182403025,-0.5029333374492428,0.14520575787275833},
{0.32945071918817653,-0.5135189957101031,0.14582152519064617},
{0.33773481222575935,-0.5342670404604772,0.15657578863359192},
{0.3374991839844802,-0.5241211882237328,0.17122467656493504},
{0.3307882120046199,-0.5316188020066519,0.180245450615835},
{0.3166615729435613,-0.5196756309165494,0.18632603548391413},
{0.3143758949666963,-0.5106389388094105,0.18423873029360402},
{0.3360041605249779,-0.5025755599322496,0.19147339070633343},
{0.34907104248207155,-0.4883701348327093,0.18518040076932585},
{0.34967474190962905,-0.48232276189522405,0.16894991057870157},
{0.32975702729633605,-0.5291480748995957,0.140060865311646},
{0.3259720284203716,-0.5440980736400847,0.14041951506545244},
{0.3308014241081631,-0.5483374271527349,0.15967258628949152},
{0.3381049912291357,-0.5364313787163804,0.16553608511982487},
{0.33257604886826064,-0.5460417795409673,0.17112111836351349},
{0.3181957068218267,-0.5418142601889289,0.18229764854001562},
{0.31278555015353476,-0.531668246466197,0.18643107361941702},
{0.30379019633433946,-0.5214964566051437,0.1848482155941027},
{0.2954774915919864,-0.5191212123377341,0.17852097894129287},
{0.29968598322012174,-0.5071365404112929,0.17738752260744725},
{0.3024035235978961,-0.5001237989294435,0.18843343293075449},
{0.3198986371155838,-0.49917042709408627,0.1973863329338041},
{0.33579791529654024,-0.49081297904675386,0.1978831212008871},
{0.3404624847868314,-0.479177006362557,0.1956349812792243},
{0.3493887789110587,-0.47405998713278596,0.18240719553427032},
{0.34108085500385743,-0.46044577923142627,0.1642181873530561},
{0.3379770868903068,-0.47226169405146484,0.1496379628385673},
{0.33192270206126595,-0.4604021716403973,0.13918446492222872},
{0.3335316900067031,-0.4396782807316165,0.1341602640133132},
{0.33725362754220306,-0.4279557409341267,0.1340494102574504},
{0.34803377761388266,-0.45146209808685545,0.13399147609708398},
{0.35376199474554465,-0.4350070648180568,0.14835895026010557},
{0.3676058325336798,-0.4866765654141788,0.13800636727455357},
{0.38372298612138583,-0.49942315797631415,0.14720302081382425},
{0.4029306967815071,-0.5632091264375197,0.12595782339048767},
{0.39727522696232687,-0.5707320297759826,0.10877631247299295},
{-0.2585834977525843,-0.4129540294934151,0.28717337801040077},
{-0.26791869564491555,-0.39923785487753544,0.2796796345791388},
{-0.27072580231323456,-0.37886801349673754,0.2838299285697704},
{-0.2432804832069131,-0.3981364747603333,0.30593516317741226},
{-0.2271980406072228,-0.4102471068193084,0.32255992671816885},
{-0.2131616977108754,-0.4201376348363573,0.33347361507730156},
{-0.18385690995663356,-0.4495971782244546,0.3526767467597554},
{-0.16026709642068387,-0.47087110952945976,0.3683749663872097},
{-0.152902343109034,-0.48968809421913106,0.36939328427448886},
{-0.14833840382423594,-0.48479656998493353,0.3650927339470832},
{-0.15261396844473182,-0.477826625476953,0.3569044275977812},
{-0.16513538792086058,-0.4590384968458486,0.3364799147110058},
{-0.16771868138517174,-0.4599339961404924,0.324453216056359},
{-0.16530878562458362,-0.4828454070436222,0.33118360035175026},
{-0.16699990300588527,-0.4857374595909139,0.32396749170422445},
{0.21576576018549265,0.12102569499214404,0.33173846407943863},
{0.20132249809883318,0.1356983224260341,0.3309978627812971},
{0.19402541591514177,0.12781472419872764,0.332812446823999},
{0.19920853603412586,0.1131455007194655,0.33408795345668296},
{0.17291205480194424,0.11841376963731425,0.3408915716473334},
{0.17768167092700082,0.12590416967119356,0.3356679238575657},
{0.17777066989177412,0.1306054570378565,0.3245332174893772},
{0.18276953237438648,0.13746808348317074,0.32689221010449493},
{0.20067557567187444,0.15594885115997448,0.3299718041907036},
{0.2344107240519646,0.14634801413050616,0.3326192522131173},
{0.2568805260249226,0.12327108858961422,0.3242953199450128},
{0.23314451879966994,0.10640632181221096,0.32446280003722616},
{0.19518027126712564,0.10176339356903909,0.33056567528359737},
{0.17434742193801775,0.10967698356886293,0.3409002642680467},
{0.155316736041888,0.10891862943619195,0.3360265321774676},
{0.14086949205075108,0.10779714856319704,0.3292390030907138},
{0.15733379589011248,0.12335238722257016,0.3321084412253308},
{0.14752128366588227,0.12645550832976354,0.3154007588797058},
{0.1599945983787161,0.13763878585827619,0.32456973244585685},
{0.15871890901188862,0.14834116342852616,0.3252963120857028},
{0.18021108225433846,0.16093342638233835,0.3256014037369182},
{0.19521101097474233,0.17507708734135202,0.3255210782695176},
{0.25172642238808507,0.14428969673733158,0.3298619937193117},
{0.2681924590145869,0.14428580619992606,0.3236414472461515},
{0.28308217248622264,0.12317147192117323,0.30951310620777905},
{0.26758211316376085,0.10214954056182157,0.3050069990921975},
{0.2567137949302164,0.10550490596846518,0.31624865805476526},
{0.23812970278170967,0.09797851686997283,0.3159431403780174},
{0.1978425526274028,0.09378342007952431,0.31771162442096473},
{0.16611017896010455,0.10132715404794647,0.334206841140416},
{0.1449744052917165,0.09786706604091996,0.32644895869184676},
{0.13691071194184348,0.09388173954802755,0.316715171948853},
{0.12464178855581629,0.10063737408987362,0.31532681635843635},
{0.14116043030510236,0.11908555665669224,0.3242638503632297},
{0.12702420620076885,0.11235966953356684,0.3144079536536109},
{0.1217427857366221,0.1173088240794968,0.2993529274016971},
{0.12063779980730786,0.13198047941023938,0.30972234955106065},
{0.13405617832641328,0.14697019520435178,0.3165083392088956},
{0.15747195458913749,0.16158446245234298,0.3170543073959787},
{0.1672489037742871,0.16719397463441535,0.3146003376473325},
{0.15949683800848558,0.176147584325883,0.31585643196448554},
{0.1616749546312954,0.1882216599944738,0.31608176547407163},
{0.18596422453566472,0.20761519003044968,0.31393681934795103},
{0.18083930205418436,0.22995345954190285,0.307457219603677},
{0.14410551293830273,0.23469794865981072,0.3079597618714669},
{0.12985718993615145,0.2382620315178693,0.2968714604140748},
{0.15284118560336768,0.2435782044039365,0.28661176586829396},
{-0.4300282090681458,-0.10919092455826783,0.1290493376923409},
{-0.4439524126951786,-0.11822615691707389,0.07872576543068502},
{-0.4506207491871575,-0.13219117187777588,0.05547601801110374},
{-0.4379768139046196,-0.17664237632868834,0.05558471295429366},
{-0.45046119253240197,-0.15910314738903786,0.036359683984437924},
{-0.46978655529597146,-0.13987748309931086,-0.005562125075254141},
{-0.45929184126858746,-0.13408162458710937,0.025841817966026727},
{-0.44872985132895093,-0.1257732151595381,0.044923667297540534},
{-0.4394025768740776,-0.10757533056105915,0.08823572303355363},
{-0.4356723313094919,-0.09462010341531825,0.12575688701388382},
{-0.42613099017987294,-0.07032118791042873,0.15988993580437452},
{-0.4266182943324231,-0.12758180191014437,0.12805620843186344},
{-0.4265949096740852,-0.1719872091475285,0.09879557540867352},
{-0.4326968733745542,-0.2039290694494972,0.06341445985445313},
{-0.44079810584203716,-0.22252436787559918,0.0062752599442461345},
{-0.45153671470588114,-0.18324222151387837,0.005088164764815819},
{-0.468177688465025,-0.15013283983399758,-0.02782385660315452},
{-0.4753546070132018,-0.12723285831410336,-0.035227396299184956},
{-0.46405651401009745,-0.13226306820160041,-0.0038022975311545856},
{-0.4509620328228779,-0.12832564567692648,0.011471081148616183},
{-0.4433213562664762,-0.12190379735887535,0.038162225634597015},
{-0.4398375191952324,-0.11680063830141256,0.05333479774917791},
{-0.4352043183579821,-0.10873231391588943,0.0742505106379481},
{-0.4301101557698668,-0.09446836714446284,0.1036286279041521},
{-0.42520995910070425,-0.06850636057633801,0.1433259441152487},
{-0.42858822152050036,-0.0725797128684485,0.14853510384969157},
{-0.4118274878408103,-0.047771770158487985,0.17316691315581448},
{-0.4131221029403911,-0.05526087299242958,0.1771182978439466},
{-0.42154561150543973,-0.08852280049791805,0.15715419850560558},
{-0.42381021449854883,-0.09627460384899016,0.16177941534815274},
{-0.43097351616580626,-0.1357403395925694,0.13269921210598998},
{-0.43281363305544085,-0.18555140526357172,0.09702640611268785},
{-0.429870880282571,-0.21666869049157375,0.06850367799661401},
{-0.43469375066158455,-0.24882713112517,0.03954473267001161},
{-0.4391184369673119,-0.2580625699864134,0.00995223106912638},
{-0.4492012692974965,-0.19122373549471974,-0.044025389806469785},
{-0.4694911081828685,-0.13864949478080985,-0.05067385820996666},
{-0.48117352508695094,-0.10925738985336023,-0.05130786282034591},
{-0.4692501307182587,-0.11961739057025178,-0.02943346286993782},
{-0.45725317948233263,-0.125607294681992,-0.005510932954859198},
{-0.45832371683836043,-0.11844630375172446,0.01728580483632566},
{-0.4422745679746656,-0.10544552268384397,0.06587496022391634},
{-0.4358109362197977,-0.07163169025642198,0.11810548651303324},
{-0.005386945182427316,-0.4940799935573891,0.2394304378814883},
{-0.003834912919762332,-0.47756352018244624,0.22623731319138304},
{-0.010225232161192819,-0.47596381343165006,0.22427111399231622},
{-0.0046571889432250255,-0.4298769142277362,0.2364288192166013},
{-0.0017414585130394425,-0.4068581863243479,0.24449319144506584},
{0.006338595917129965,-0.4006334645884887,0.2551316566861943},
{0.00013796321598769068,-0.5125943163225098,0.22411297565198904},
{0.0004765164636326822,-0.5130602225193295,0.21705206778719174},
{-0.00034121989125165286,-0.5367525201624034,0.2115416856907828},
{-0.02501994193910496,-0.49706493560685966,0.21979524194064087},
{-0.017857769611351104,-0.44286505051784475,0.23071448244299617},
{-0.03048220333610187,-0.43326680788825206,0.2341093821691196},
{-0.019913338555517395,-0.41490956955490954,0.23962922606949738},
{-0.019761542789824584,-0.41195948085610157,0.24934240528817225},
{-0.0031591758681412383,-0.4070660113532012,0.2619092161380454},
{0.3064741805613889,0.21497087675383653,0.2672454908423132},
{0.3100829238566175,0.1997437499981374,0.2739228450517957},
{0.31617216097391326,0.17989347278308448,0.2770529364436906},
{0.3150788880907202,0.15387432142359705,0.2799346145787035},
{0.2850084718975225,0.14654319544399536,0.31215554816458513},
{0.2981142199195825,-0.4891148710220529,0.19169417498567085},
{0.30320813921630907,-0.4802133798705918,0.1957475773838979},
{0.29538849262721306,-0.474014919793424,0.18826483731033913},
{0.28879087637361145,-0.48264341675846945,0.17733710604475467},
{0.28870888823798585,-0.4754805613024928,0.16851371142910576},
{0.2969947045010387,-0.4647606763139179,0.18340117578340473},
{0.3075948508172237,-0.46734893334752414,0.19707572951086283},
{0.3206396038820125,-0.47692739819329877,0.2023052949121403},
{0.31291284785750323,-0.48759427328171334,0.20072696593132622},
{0.2904826620094264,-0.4954665249935935,0.17394836722152987},
{0.29065328364153825,-0.48501120398545045,0.15147211218352497},
{0.2915484578393917,-0.4688139267878278,0.154110694412752},
{0.29575034341575546,-0.4556239627609617,0.1706367719543104},
{0.3050155095099712,-0.45365091421873444,0.18220878237621868},
{0.3126412316140189,-0.4580082842407123,0.19424225919270255},
{0.3222598182907932,-0.4589349088970083,0.19777277421355036},
{0.33576091375728284,-0.4676846648400219,0.19649860515230105},
{0.2339590031242434,-0.9386776256398046,-0.21064491044435746},
{0.22425153859718627,-0.9416048555721414,-0.2245902687357319},
{0.18686641062507384,-0.9391989725258573,-0.2342355845306345},
{0.15258391611496924,-0.9283528033703661,-0.2378201729218619},
{0.16870741333971756,-0.9539620576104458,-0.24735156566473446},
{0.17580185716949115,-0.9686406833988394,-0.25973166577859913},
{0.16811463546446181,-0.9716429713806475,-0.26911906295393057},
{0.16369773023354556,-0.9715515405643939,-0.2971785982627351},
{0.17279462580413632,-0.977781936620374,-0.3146093755505846},
{0.19894105361943598,-0.9882954552660208,-0.3015146107004794},
{0.19668309704959536,-0.9936087915232314,-0.30007502793021},
{0.16818233633983892,-0.9963139304146226,-0.3003470500134783},
{0.1365517487777326,-0.9977700070661646,-0.2928949285330456},
{0.1295175583445778,-0.9826376343383535,-0.3032412093154601},
{0.12298975078345133,-0.9791128637565424,-0.31303945552759815},
{0.09850146002376224,-0.9970095461788036,-0.29937612932589147},
{0.06162162064363215,-0.999455632861489,-0.27884490713612575},
{0.010883013458392559,-0.9991858811437135,-0.2414320779427374},
{-0.0042809053445639995,-0.9973838600733823,-0.2638965296299571},
{-0.020573783309100372,-0.999456443478649,-0.2900789263241213},
{-0.21064647059022854,-0.999363391428075,-0.2701477563158964},
{-0.29872866029011375,-0.9994514182897007,-0.1852682842058972},
{-0.3412258641084505,-0.9989950769504077,-0.12605784483630486},
{-0.3751498097934907,-0.9997886084681238,-0.0860172848470757},
{-0.43531937606155485,-0.998897486293663,-0.0054734554569023305},
{-0.4218689404491465,-0.9987960050995128,0.018344657831243106},
{-0.3623416167016317,-0.9967712438570632,0.04631407545984891},
{-0.3614809718200583,-0.9889620534856475,0.07439970244209505},
{-0.36429703458622786,-0.9915561473877699,0.10696592175392285},
{-0.38353728892242955,-0.9816372498949318,0.13928487202208145},
{-0.37667365000247094,-0.9983740315905125,0.16972805099445304},
{-0.36096858103185625,-0.9991280075405924,0.1836956603550306},
{-0.34869705368428316,-0.9889627026168202,0.19585675890986545},
{-0.3215895122679043,-0.9860795657958824,0.1860482392141906},
{-0.30438040212028356,-0.9771156624351296,0.1833026533950095},
{-0.3059356301056454,-0.9796870601191758,0.20145971603574112},
{-0.3197939559491055,-0.9863442923247092,0.23038633016782534},
{-0.32104386811520363,-0.9957032594670062,0.24101101597963923},
{-0.31321812224286216,-0.998471459698862,0.2551716574027034},
{-0.29752756257572843,-0.9998977081886898,0.26627558369177856},
{-0.246863896575101,-0.9989806483899204,0.30975440770677126},
{-0.22969967103269867,-0.9998853874453003,0.3139562730973866},
{-0.20738786609982882,-0.9988063795117917,0.3322912412381854},
{-0.16402693747967312,-0.9982788727852484,0.3293560676826423},
{-0.14383814313884083,-0.9987733099438446,0.300577935666287},
{-0.13385196017207984,-0.9995516022839133,0.27393469939815596},
{-0.1363016739150333,-0.9873023653146322,0.29717114228471436},
{-0.12643663731101257,-0.9683988145740758,0.28420732238459434},
{-0.1243228781661972,-0.9540708343590374,0.29118279778764133},
{-0.11525006631828438,-0.955899279636455,0.2950831784015611},
{-0.0971253550578194,-0.9665911202460312,0.29532713379526637},
{-0.08963006688559949,-0.9588965413669073,0.2981771999858494},
{-0.10822019244806748,-0.9464466123748193,0.30477414798493757},
{-0.10303865744153806,-0.9375185344678766,0.2861190519351679},
{-0.09036712292887421,-0.921771925351834,0.2559278633467796},
{-0.11410874710422615,-0.9265588874092281,0.28758120768420725},
{-0.11212913394413203,-0.9219972588614199,0.2955777164888995},
{-0.10800227454500537,-0.920436944067457,0.3016886766587159},
{-0.09325330354819208,-0.9116139149200952,0.28537054632290915},
{-0.07948356658009004,-0.8933375693799247,0.2766159277393425},
{-0.08714330591985274,-0.8869971004378232,0.2844283998884877},
{-0.07710387932321303,-0.8771047897004667,0.2590149750306621},
{-0.06433401471796775,-0.854073255533319,0.22237750061974365},
{-0.05838152435971579,-0.8196584785017947,0.2030346506235976},
{-0.04667847124630356,-0.830609696416867,0.19766019829462522},
{-0.03587489826960476,-0.7920615867354208,0.1834643083051926},
{-0.032077903747041094,-0.7500504706126901,0.1825889618243243},
{-0.04336807968713455,-0.7299309282626395,0.1996703694906003},
{-0.030462929133586447,-0.6892700315395255,0.20317113709272736},
{-0.03911456852798883,-0.6674630806738432,0.20993485655801863},
{-0.013710940132592594,-0.613130589029026,0.2035206278287913},
{0.00361995594727077,-0.6241280078725949,0.1987661372037463},
{0.014876602296834704,-0.6369606809652455,0.19103018072758987},
{0.010254668294424873,-0.5860362395304418,0.20259670912519104},
{0.007155587524138539,-0.5506377759190683,0.21152218200818013},
{0.34660039611800886,-0.9287888803430635,-0.0738266513550824},
{0.37473338736530526,-0.9288676663815453,-0.08257616400670711},
{0.36939565397511237,-0.9349211991595214,-0.08885488899403032},
{0.3546079688376497,-0.9426488476065923,-0.08518722881120967},
{0.3824072152950556,-0.9502866875341374,-0.09611738130419643},
{0.3806571512787434,-0.9346543658760041,-0.08481951034432464},
{0.3803119367341206,-0.9349354651716136,-0.07043557204744895},
{0.3757015117955323,-0.928176102640757,-0.0710251584496391},
{0.364344653829153,-0.9259530812269804,-0.06986639131209342},
{0.35506208124535427,-0.9231459745586614,-0.057792963712267595},
{0.3405304895108427,-0.9168335510579667,-0.05857148022038434},
{0.3490946289978937,-0.9539597883073605,-0.08938621613906375},
{0.356213917234338,-0.9558965237505924,-0.08918037675041005},
{0.3646933126999005,-0.9725533847561486,-0.09484928177877393},
{0.3783216240649573,-0.9787747014749721,-0.09997335327159741},
{0.3919190129882536,-0.9733213016215305,-0.10136060395789015},
{0.3881043888704667,-0.9524858791407032,-0.09411884134894113},
{0.37629402619365077,-0.9590137472590748,-0.07765882326269118},
{0.3744174750905303,-0.9565240540477684,-0.07128278171983872},
{0.3735996271828257,-0.9642173346645466,-0.060525337427905467},
{0.3814330532012362,-0.9552096611643697,-0.05923965930283465},
{0.38613296262496766,-0.9624316863609975,-0.04970969549846853},
{0.38512479710673475,-0.9473819902090739,-0.055854476358554776},
{0.37497485141269277,-0.9411832060975235,-0.05389527842696547},
{-0.19319437715205012,-0.295239386346895,-0.3030748840605378},
{-0.21476596431599831,-0.21609198259687404,-0.2899225292701971},
{-0.20474303266303914,-0.2100608209401838,-0.3006166391828583},
{-0.17645531552930602,-0.27370850958787385,-0.3180714491978106},
{-0.17550922862431192,-0.2048982477882732,-0.32256722121020237},
{-0.1815123246538469,-0.15924953337415473,-0.3178983553427216},
{-0.21058172852060628,-0.13960440710749364,-0.294779950213647},
{-0.22027587895297024,-0.1553940575512017,-0.2862559538057519},
{-0.22223034492016733,-0.2196944035032167,-0.27705909628418146},
{-0.19351750423827271,-0.34196273263674665,-0.294768297724771},
{-0.15994035289827102,-0.37577429576108334,-0.31865942392735086},
{-0.14380044253524354,-0.35218899108388535,-0.3314423688975706},
{-0.1471506701377109,-0.27187260727002727,-0.33568338401603803},
{-0.1344246967863803,-0.23115432352656964,-0.34217538524669516},
{-0.14745876096617802,-0.16457794519820995,-0.3364180687650776},
{-0.14773555432292754,-0.10639824645043616,-0.32908661875109346},
{-0.18425634023428275,-0.10866495726064321,-0.31032625189851015},
{-0.2181838014267711,-0.0924606277999682,-0.2817215186482858},
{-0.2383609549652133,-0.1177758957376857,-0.25788587456884354},
{-0.2370255083462149,-0.20646318193140048,-0.2616520677641376},
{-0.22533632284196567,-0.28725203655994525,-0.2718009999211274},
{-0.19489598049845067,-0.3822859525986601,-0.29320928119315354},
{-0.16385293207868187,-0.40964859512909424,-0.31008389649096896},
{-0.14134965469799265,-0.4473055826360799,-0.318049037705028},
{-0.13968127390626406,-0.41994131887132546,-0.32446598088621365},
{-0.12016797438807161,-0.40121203700889757,-0.33496823375942775},
{-0.1197396274946103,-0.31403497201842795,-0.3441258183138399},
{-0.09339302292429202,-0.2536791008541393,-0.35394364045231186},
{-0.11333305766329577,-0.19224146480807144,-0.34866361811684504},
{-0.09851917142438685,-0.15457604815750975,-0.3506156724183101},
{-0.12445435007045688,-0.11648087479832098,-0.34006470602212524},
{-0.10427671632368389,-0.07593418585253045,-0.33883939284649345},
{-0.11175341235920329,-0.0418472774332912,-0.32781927884725615},
{-0.14355417640454837,-0.037058207558799044,-0.3149305977396013},
{-0.16025879901567636,-0.06425817208032764,-0.3144674070571477},
{-0.20059600132679647,-0.06949280304205013,-0.2904131576967893},
{-0.22095350177845657,-0.06234996866128035,-0.27110787550326415},
{-0.2317126788575303,-0.06644666417782412,-0.26048454744863325},
{-0.24315776554301974,-0.05544397685391815,-0.2413153373851914},
{-0.246693073085505,-0.07014546034637506,-0.2385838157206183},
{-0.24570894029437498,-0.12649055397624004,-0.24573880829638234},
{-0.2459397048326932,-0.17622169895721795,-0.24981082301705826},
{-0.24056237550336743,-0.24295192031112314,-0.255475654773873},
{-0.2349086884044948,-0.2952314437860965,-0.260795677825849},
{-0.23063026590698607,-0.3152548541653275,-0.2643690811876374},
{-0.2269518360961807,-0.34784653514276465,-0.26713768725927706},
{-0.22424073922178278,-0.3624011460673271,-0.26721318939521377},
{-0.21794122397599724,-0.36699568375950287,-0.2740247108375736},
{-0.19747186685550033,-0.43238816900557603,-0.2883883157113459},
{-0.17519402497554706,-0.43564918516170775,-0.3041323314899207},
{-0.15085899929155405,-0.46503318391755594,-0.3158411726010896},
{-0.11293503613840461,-0.45195945261730197,-0.329761039479436},
{-0.09156609264041321,-0.42361895931312693,-0.33819443587398584},
{-0.0830352107674921,-0.354336794024611,-0.3483124052177188},
{-0.07894422994256607,-0.2889660318310587,-0.3549531839134763},
{-0.04696735161672403,-0.22283529533292287,-0.36022595106599875},
{-0.06759920719920634,-0.19071673430134523,-0.35808313294272454},
{-0.0574557443176299,-0.13821406587687737,-0.3561254861265399},
{-0.08587307839158394,-0.11623349420183157,-0.34983652802717674},
{-0.06814155363806017,-0.07274960462639384,-0.34458540212177363},
{-0.06840916035446404,-0.03977315353669784,-0.33544706733449714},
{-0.09159194845932052,-0.0045949982459620635,-0.31792088901240256},
{-0.12379415392030188,-0.013380904739575995,-0.31359699439815575},
{-0.14816909957781035,0.007787087508102225,-0.29268902752473885},
{-0.16881685834282226,-0.01701347890442338,-0.29406277288293237},
{-0.18312075589759078,-0.03444871299304182,-0.29165917932548197},
{-0.21611093435861858,-0.032868216700292344,-0.26261717283136443},
{-0.21553469286094812,-0.04954331499834008,-0.2674549371054868},
{-0.22688705259265382,-0.03618807856269279,-0.25206395731784265},
{-0.22520608758039853,-0.06513810816294144,-0.2646778817045226},
{-0.22903120722495485,-0.04378417436251028,-0.24571222260330852},
{-0.23808929728782438,-0.04017299921580124,-0.24346624149431859},
{-0.24202315330947527,-0.011354441519812263,-0.22661008553222717},
{-0.2544066786261241,-0.03869584758050323,-0.22769711783193566},
{-0.25633646273504546,-0.09402880441173599,-0.2409236382491862},
{-0.25374155927817077,-0.17135749029026062,-0.2498857992611282},
{-0.24579368325345569,-0.2865249713997294,-0.26374906955054284},
{-0.2355735644610593,-0.33616436153007107,-0.2695238127074916},
{-0.22152658261288796,-0.3789106479222112,-0.2712393675932722},
{-0.21669060105907317,-0.39365865743995515,-0.27584709720324285},
{-0.206783396426608,-0.424648361301103,-0.2814207626833489},
{-0.20476868662446238,-0.44017466315891557,-0.2858921768718474},
{-0.19265635258817324,-0.46838757615864424,-0.29063362750341454},
{-0.17490787924283338,-0.47971991481514303,-0.2999989574060942},
{-0.1574718345370547,-0.4883083706921825,-0.3071172331678944},
{-0.12843726489761736,-0.5149797735162108,-0.31865451985289317},
{-0.09225180463897599,-0.5418256077667629,-0.3304335956820696},
{-0.08213996538831518,-0.5341504826370748,-0.32972959008340136},
{-0.059626774680337315,-0.5436085001844492,-0.33107567459181586},
{-0.3983641248501522,-0.09616615113478126,-0.21514690285448526},
{-0.4042465494132388,-0.09549963365814806,-0.21766196742673694},
{-0.3775345381754332,-0.06662004169579881,-0.22887853975365277},
{-0.36348818421027845,-0.0630517453283601,-0.22593627356356052},
{-0.3368719596607536,-0.02655425270827103,-0.23609440510978974},
{-0.3651854412463224,-0.02328059177436734,-0.22011419376416455},
{-0.38920195919325695,-0.07091945737166191,-0.22486441775943866},
{-0.4089229934356387,-0.09406049709915949,-0.21275830518329347},
{-0.40771830903248196,-0.11688015315165308,-0.2057019157389183},
{-0.39690812894160366,-0.10259707772758127,-0.20342612665396242},
{-0.37312245521357323,-0.07844633199052407,-0.2107022167217073},
{-0.30854344181742926,0.01250871998435451,-0.23985893669926667},
{-0.31959885537861,0.008327888143590369,-0.2366816913990681},
{-0.3419739436951769,0.015468453221274882,-0.21859035461759216},
{-0.3900470015537114,-0.05512802314523837,-0.21441977607461638},
{-0.39952434961121525,-0.054755655581770445,-0.1993631084026339},
{-0.41076846061101174,-0.08662999774250561,-0.19901756982362862},
{-0.4124125048270034,-0.10960463147208731,-0.1930248290830318},
{-0.40655662558549377,-0.09558830858853891,-0.18544579555266627},
{-0.3926357855415921,-0.06163019693069014,-0.17840616452910898},
{-0.1598164803970866,0.4042756535440297,0.16635498693607845},
{-0.14869748810283726,0.4168473270344558,0.15956990988655348},
{-0.14947687578535943,0.372393206274101,0.19407476847641114},
{-0.17448897609240802,0.37123646621065953,0.17883852307446632},
{-0.18081340586378006,0.37601580974163773,0.18580450586371797},
{-0.15927057276724882,0.4282482398655528,0.16301696746177247},
{-0.15427454797590093,0.4327017407959424,0.1556033880119238},
{-0.15579917755388506,0.456484455718218,0.14943508119326068},
{-0.15307387628704808,0.47762371408422755,0.1347372863807251},
{-0.15579563123661044,0.514812769382697,0.11959415783623085},
{-0.16730573515534525,0.5454095587133034,0.1119654121195517},
{-0.1834427780796896,0.5470233689277967,0.10834393267947935},
{-0.17376858710287946,0.5778072737717875,0.11513017519037347},
{-0.1740048835986719,0.5967605930062716,0.1213875319693849},
{-0.17555097168963182,0.6107844951071468,0.12039073421473451},
{-0.17317739965211743,0.6138286472687656,0.11458851294215022},
{-0.16419737637764137,0.6076379289573198,0.11242803972586522},
{-0.1470585912526921,0.6050072382933162,0.13213184490076857},
{-0.1199051017608756,0.5890998156940773,0.1291228244406592},
{-0.09181314389048101,0.5735213549247613,0.11116095904953394},
{-0.06058341448212252,0.5614609365085866,0.1034679206617368},
{-0.042674550491895134,0.5496145847671577,0.09540836114065816},
{-0.028140361170284477,0.5382182530385439,0.0951624849136298},
{0.009729318255738776,0.5397710693581736,0.08633983717067234},
{0.00693543962708015,0.5296292702072298,0.08687296828416961},
{0.1171287953574185,0.4931183636261134,0.08961473687208416},
{0.10857144465628285,0.43649350720966595,0.12836840759133747},
{0.09996059747220924,0.385308392331836,0.15773133242583767},
{0.05374406539195724,0.3740391957587953,0.16497652979924113},
{0.01139999491074794,0.3604761332318868,0.179772350855724},
{-0.010399661462900965,0.3955044985828779,0.17134858943761622},
{-0.04240585268266888,0.37884050457127544,0.19300835538750738},
{-0.07991986134638884,0.35694722988368904,0.21606268670147313},
{-0.10946606215244309,0.3338354509921345,0.23364552216974482},
{-0.1302458909573127,0.3466592072960236,0.2230210392778229},
{-0.290546088818178,-0.8926469788046917,-0.13820487073726923},
{-0.29409685758154336,-0.8939295971952655,-0.13241565971074398},
{-0.291853510181518,-0.8658475080310315,-0.11984961804412635},
{-0.2823332833447439,-0.864400995174608,-0.1249107100018868},
{-0.2915940925045249,-0.8240703181722658,-0.10302404136607203},
{-0.29336681236741646,-0.8375553234724511,-0.10279651929639436},
{-0.295284520086745,-0.8671888106418867,-0.10301594581854875},
{-0.2980922142665837,-0.899249741361732,-0.12096376405359095},
{-0.29850142188332174,-0.9275532745605545,-0.14914332169767125},
{-0.2866416349327091,-0.9088048629830734,-0.15261520349381266},
{-0.279509824095391,-0.898528836042007,-0.148817357982592},
{-0.28023314108084796,-0.8566550286920521,-0.1329869780106162},
{-0.2821217292644724,-0.8394854114300065,-0.11173133393126958},
{-0.28489722398836154,-0.8255792432379812,-0.10993250433400369},
{-0.28914867513876086,-0.7889360945069417,-0.09402017766030699},
{-0.29539534303278125,-0.7808665547268822,-0.08932404722116084},
{-0.29629758967943565,-0.7979802436545091,-0.08335325157631746},
{-0.2987959765738631,-0.8291607517089631,-0.08763613087459522},
{-0.2949201152698239,-0.8472427265528045,-0.0877126571716621},
{-0.30021416032599413,-0.8779678664335206,-0.09434153052548451},
{-0.3029409202787563,-0.9039981220794533,-0.11110568834555083},
{-0.31120598665484367,-0.9341195625326119,-0.1320036558366463},
{-0.3034054687183929,-0.9435882785266475,-0.16154686808952692},
{-0.27992731955546607,-0.9283046561107587,-0.17878598913300553},
{-0.2736536410052473,-0.9219278751320695,-0.17245919869147652},
{-0.26819262156298196,-0.9114782284440474,-0.1769583544727477},
{-0.27343766837088795,-0.8744400159314639,-0.14943917358815043},
{-0.26875494339350675,-0.8487878021691201,-0.1419762920414034},
{-0.28579418196893047,-0.7927246184520247,-0.10981314069157115},
{-0.19987041397584637,0.3865054975176658,0.1795086580496975},
{-0.18646360720262323,0.3780500540362126,0.18747380882542689},
{-0.17581177793363448,0.40989797198986133,0.16937757859357136},
{-0.19282969929632146,0.43961551367811563,0.1480036449660896},
{-0.17560635288402726,0.46060802165312903,0.14168443267947964},
{-0.21623091632239738,0.35532280090312035,0.19875278379996417},
{-0.22463624815219985,0.3608117021759895,0.18444320236340436},
{-0.21653359737028866,0.4024533681071026,0.16575643381195962},
{-0.2177277033788667,0.4553157593172664,0.13902057151878686},
{-0.20567524877164683,0.4971418263098058,0.12091638810205475},
{-0.17914255178666635,0.5184867625784817,0.11797756092604816},
{-0.15973486729141845,0.5042469292771519,0.12863023162202358},
{-0.11445299910737189,-0.4776290133743912,0.2352893241567554},
{-0.10814620849289347,-0.45151105490121507,0.24228662354106525},
{-0.09683975646512855,-0.4441489661083563,0.24207132022362712},
{-0.10343006760261855,-0.4715385183662468,0.23355571365021913},
{-0.11101778950406622,-0.504518292667577,0.22739842931259985},
{-0.12032416745969605,-0.4930543195584234,0.23655157725199144},
{-0.11732606430225725,-0.5481137148774691,0.22379839988624076},
{-0.1264349757051954,-0.5787128946256512,0.2230307050640915},
{-0.12913482593050132,-0.5562962459779079,0.22318031333210053},
{-0.12524157832262756,-0.6026580846369405,0.22313103142095062},
{-0.12992896514548546,-0.6395502351987895,0.22506500991591158},
{-0.1476220774821783,-0.702437786993501,0.2280946134649601},
{-0.17733542478439304,-0.7019379995491662,0.2266477765741541},
{-0.19507181961532455,-0.6902569605880152,0.22284496643123053},
{-0.21212169714257223,-0.647497866869708,0.22006114349250736},
{-0.22652153330993846,-0.6310673125392932,0.21605579698681585},
{-0.23757540744220038,-0.641485997476466,0.20374379296403416},
{-0.24267196044789152,-0.6128541908879822,0.21206777516530576},
{-0.2352949575741756,-0.6107548592412465,0.22573720171266579},
{-0.23729503695834966,-0.6078498378818004,0.23351834664267462},
{-0.24564565584827006,-0.612404171937575,0.2400321516688462},
{-0.23265628397787677,-0.6235205793936193,0.2556621636523973},
{-0.22023354837613063,-0.621964480233852,0.2702782550546008},
{-0.2096042623384931,-0.39472664183001205,0.3401245248939491},
{-0.21947004794002103,-0.395268739665438,0.32746518894777643},
{-0.1832111019954691,-0.4240376914158946,0.35973236595846725},
{-0.1664873911031926,-0.42963715215766274,0.3688579136053251},
{-0.1575131930107469,-0.44718545937206217,0.3757271875363156},
{-0.16474302053034195,-0.44833855112707904,0.3666536766240628},
{-0.18677153654510303,-0.4307832734550287,0.35102852728106476},
{-0.213017399357108,-0.41123160507872564,0.33002973835107},
{-0.2663639744280798,-0.3576407697030067,0.2889853283441381},
{-0.28064080926866714,-0.33890921747508573,0.2801850347239414},
{-0.2276500048263327,-0.3741927444973771,0.32318634148714315},
{-0.18394761089872086,-0.406771619211055,0.36024799921530987},
{-0.15868910209833034,-0.4301593107232833,0.37819702222081025},
{-0.14923746855949493,-0.4441214072497272,0.3762480690877468},
{-0.14987831188895653,-0.4482487426075534,0.36844572805949155},
{-0.15640407325263822,-0.45272493869361125,0.36391194097079044},
{-0.16106339338593306,-0.45783725783122436,0.3656192483847307},
{-0.17899258973685608,-0.44387078418459724,0.3518413499998212},
{-0.2719759992046263,-0.36418112005075526,0.2851015244793004},
{-0.28826081561868927,-0.34560811200294544,0.2735852097244998},
{-0.3126047974005329,-0.322101431878242,0.25369371639840144},
{-0.31594097253487813,-0.30200717908373537,0.2526294801831034},
{-0.2698621178829126,-0.3299025160780562,0.2939484248677778},
{-0.2728195818167477,-0.33726330873338495,0.2876194660519056},
{-0.2384504394503565,-0.3603786551903704,0.3200673341959451},
{-0.19444470578201037,-0.39295250365269224,0.3560373593985797},
{-0.1663766690858985,-0.4151211236351811,0.373249712014841},
{-0.14910008010613324,-0.4340157586493838,0.3756859098056171},
{-0.1546868153271359,-0.42519499880510736,0.3608298141043592},
{-0.15559842391142473,-0.4459892455463861,0.35592659700978874},
{-0.15850156055941333,-0.4482837585066111,0.34619128996121684},
{-0.1507446714621478,-0.4664981773578597,0.36488877820747917},
{-0.459452654751784,-0.5087177665782088,-0.07820395108519537},
{-0.46305369771519517,-0.48100350637127215,-0.0890552166109582},
{-0.44739920679326034,-0.49549927158956597,-0.12575846787670728},
{-0.43950908325717586,-0.45976572561686735,-0.1505461865915689},
{-0.45355004656509534,-0.47238668101844344,-0.12184453093911335},
{-0.47487403002691375,-0.46333313062415227,-0.07336476849664471},
{-0.4654167837876104,-0.4812032262909319,-0.05817876648491921},
{-0.46412865256290303,-0.4712865991635869,-0.02033168447304567},
{0.1523443973362846,-0.2929967486352877,0.23421975890387506},
{0.1461901536098217,-0.29065425096385056,0.24486857943394177},
{0.1096412925096411,-0.30102932724758663,0.2481274272157303},
{0.16001931954608087,-0.2993244113136299,0.22966216219371138},
{0.1333211281090866,-0.3083677487816296,0.23910870998635333},
{0.10270146088866837,-0.30828085763395413,0.24975574673370463},
{0.08006055282563647,-0.3082153644420092,0.25465255963398764},
{0.07052233092535189,-0.30621038098337744,0.26479312320464665},
{0.11696858957149033,-0.2909635582492618,0.26441027817534213},
{0.1762104369032126,-0.2767821255053275,0.24626627571383672},
{0.19747000126738354,-0.27806036783812593,0.21661748987191629},
{0.2192530617686096,-0.28636707528838323,0.20328355046325738},
{0.1956320931235889,-0.29629910307936314,0.21126857038987656},
{0.172758920402409,-0.3047958041057663,0.2233634171935891},
{0.14918372772276034,-0.31129189879372093,0.23142537775632166},
{0.14467703415806693,-0.31983399119386846,0.2293096520946473},
{0.13102658433903508,-0.3172569191897013,0.24383980532898222},
{0.10850120993827542,-0.3163186239835964,0.25068008083875915},
{0.08706391112169501,-0.32046995063462086,0.25290478510650904},
{0.07708698810141872,-0.31288187920100324,0.25578131481326755},
{0.07874891582810054,-0.31966393688752803,0.26720455839415347},
{0.060292657899507045,-0.3068922183806518,0.27040496524704954},
{0.039221537058485134,-0.30004142609594936,0.28217017984150994},
{0.06913229354336965,-0.2949898989957154,0.2806177682992562},
{0.11332288510850116,-0.2813243024285157,0.2738482746475097},
{0.18466602274731247,-0.26169092957947276,0.25682255096185547},
{0.20682856363230423,-0.25648166785388,0.24707543100082802},
{0.2104355443929736,-0.26619273925545694,0.22555715758567418},
{0.22548742910498895,-0.2563568434352966,0.2175226538904209},
{0.2384668324028873,-0.2552465475917407,0.1978370615726293},
{0.24446688888367377,-0.2599164663053626,0.19136025808571505},
{0.2159979026667424,-0.2778052061668254,0.20619191522008612},
{0.24202209940092642,-0.27219520740197545,0.1888275639182401},
{0.23215473293657513,-0.28593813132173185,0.18845918782091978},
{0.17372953724136167,-0.30993892457064914,0.21431575253857338},
{0.1502808922057667,-0.32425798905933395,0.2206085098082703},
{0.15870924322562002,-0.3342012029421606,0.22224268531810132},
{0.15367483895208325,-0.32795378498822536,0.23616569373634616},
{0.1540548664758718,-0.3270062489589765,0.2520769261299971},
{0.12215422228494843,-0.32116005568948397,0.25971812964067337},
{0.09557200009742922,-0.3241338116471077,0.261001701011054},
{0.07609607714845167,-0.32864421407747096,0.27724718602552917},
{0.06835661472651736,-0.32278861849884705,0.27787402682003576},
{0.06758824102577653,-0.3170238046053041,0.2795076350040955},
{0.05978655869036446,-0.3171690559388783,0.2844189975793564},
{0.046968330094318445,-0.3171734330590615,0.28404778485317944},
{0.027430059742925582,-0.3057438267177928,0.2731647958301666},
{-0.006176995189745113,-0.2956410965517075,0.2930551545047223},
{0.22718316689786253,-0.23118317958513657,0.2527167166133175},
{0.2421040864741442,-0.23100104782679548,0.23833319265548833},
{0.22863241439199267,-0.24805548520836992,0.23210101387920054},
{0.2526655898310031,-0.23803267466990127,0.2057807623346454},
{0.26103345372451897,-0.24736748797060476,0.18631377636017776},
{0.2615137066764245,-0.2553841793364912,0.18724989363026912},
{0.25954361693995215,-0.2628479118718952,0.18115567169552216},
{-0.4684315539987954,-0.4348490072207233,-0.02542798462567772},
{-0.470193533981121,-0.4383141204166979,-0.01408822823783933},
{-0.45993837804151066,-0.41620791264350077,0.0033041812543072218},
{-0.4559453522792086,-0.43154778742819044,-0.021807346612592034},
{-0.450890623081831,-0.4115498280904906,0.003424707170885501},
{-0.4563452383298089,-0.3983243615817891,0.01891584120532324},
{-0.4618140377844775,-0.4070113802187206,0.018501694454669832},
{-0.45732572387492215,-0.4394224699291432,0.02454633381685619},
{-0.47500785303966025,-0.4558377861443184,-0.044572036872144366},
{-0.4743462385750769,-0.4475416156547351,-0.05187724541318562},
{-0.4679811292086043,-0.4452529385006184,-0.05430191289198409},
{-0.45618993661833823,-0.44402900433032594,-0.050114323075131306},
{-0.4568946306572682,-0.42845147529266076,-0.04625222207706605},
{-0.4561060850194114,-0.4179173682460358,-0.01989568824334189},
{-0.45414616783773376,-0.38869985729350504,0.0062909665813306774},
{-0.4481920084368099,-0.38360066951644145,0.025681963837084026},
{-0.45175864426083934,-0.36024167151438485,0.04593147053470978},
{-0.45278695196876967,-0.37071401335807525,0.04957273838267828},
{-0.4446345326929308,-0.3536594962959149,0.06936067350735509},
{-0.4505871930364327,-0.411928842077227,0.04915862881629826},
{-0.45243513137237523,-0.4434259529715334,0.041156111033024426},
{-0.45629060719532827,-0.4692359002968282,0.03286776411456466},
{-0.4596708552553239,-0.47944659659434485,0.019130835362088247},
{-0.45974246791626283,-0.470291889040286,0.004382486936252402},
{-0.4603211625135699,-0.509819145633003,0.014550201400940972},
{-0.46690694460655974,-0.5521554552251499,0.000317058081599723},
{0.2972521970950776,-0.09776974948539081,0.27037779098004816},
{0.2966041591399169,-0.08467389035523981,0.2683755835930277},
{0.2877272489179894,-0.08660811214158964,0.268342128371045},
{0.2835502672431339,-0.0785220370463527,0.2732927416029001},
{0.2970337320519925,-0.07732395975737538,0.2733067845093519},
{0.3049483961461138,-0.08486120878851641,0.26332409686429065},
{0.3101011005918637,-0.09405344589851491,0.2602746964080835},
{0.3080540691568702,-0.10347287998140071,0.26216737698659764},
{0.3035705977021195,-0.11054884428970194,0.26452282328444077},
{0.2948486640948724,-0.11529835965896583,0.2642922414802661},
{0.290543108764267,-0.13344655650651085,0.2620844581817292},
{0.27990565706019055,-0.1444301959207653,0.25363975351843426},
{0.13562011911823688,-0.8576341756033229,-0.36996827000612625},
{0.14690123165729074,-0.8436367391434388,-0.3516812249568866},
{0.1669667707558773,-0.8456491796424992,-0.3595648242466009},
{0.18021027163717832,-0.8475799167312276,-0.36492946736425014},
{0.18469919430640958,-0.8301656747585554,-0.35772616604289137},
{0.17728652746487086,-0.8296136890936283,-0.34586469730071323},
{0.16380670883962115,-0.8333903788780995,-0.3424499199244375},
{0.1524607522397952,-0.8249959696630066,-0.33231067373946466},
{0.09634817612113736,-0.8412995906953322,-0.35463050197612667},
{0.14944788692581606,-0.8644757281272891,-0.3699377523417422},
{0.16737930158424946,-0.858901556941065,-0.36439231397477867},
{0.18270424210233352,-0.8543136656721576,-0.35015925033602324},
{0.1944011470617408,-0.8384540641733277,-0.3484854587013109},
{0.19118736661931415,-0.833785604145631,-0.3626470318560257},
{0.1922039007238779,-0.8226408272137975,-0.36320278800627576},
{0.18548291873761802,-0.8110849377680203,-0.36249537739057186},
{0.07867933024126596,-0.8215054043630929,-0.3394871057048639},
{-0.0016846377560593873,-0.8183384123606827,-0.347724551602669},
{0.12503330602008572,-0.9930237341655415,0.2087685006414757},
{0.13864956011889026,-0.9944679766564718,0.19009792318507754},
{0.1379914526624925,-0.985014013257306,0.19751794613830267},
{0.13489505978396912,-0.9717050595555569,0.20704877155540388},
{0.14192658463592497,-0.9593608263294068,0.204622523213782},
{0.14857508384924842,-0.9709005044943891,0.20715993872157107},
{0.14665792433235048,-0.9940578373080832,0.19747793586012333},
{0.14182775839889564,-0.998612171363858,0.1843515696896664},
{0.12215379732182384,-0.9986402168052647,0.2023184655817789},
{0.11326938862556309,-0.9887383412103816,0.2240531769659135},
{0.1273685293852378,-0.9723178372578631,0.22298513201861137},
{0.15135009305276773,-0.9563599980959315,0.212301396518229},
{0.15652405415400933,-0.9868158717792421,0.21468513154886776},
{0.15938380631660926,-0.9969064437503333,0.20897937690556354},
{0.17727635491007626,-0.9990495455364932,0.20720993988280936},
{0.17210636508923388,-0.9968101502935265,0.1738717389333131},
{0.18161463558849794,-0.998857282657262,0.15812701452872802},
{0.08932910268873173,-0.9936891977336255,0.2198632466646521},
{-0.3056175080226225,-0.336971185894324,-0.23546233620644302},
{-0.31218517500001924,-0.328734347693787,-0.24231213513984176},
{-0.3022367733798492,-0.2857435980770077,-0.2359254450834951},
{-0.2978598688654421,-0.28951915320993626,-0.23622113442557915},
{-0.29256979615207884,-0.209773723290071,-0.23088737337819323},
{-0.3053716668550519,-0.21928928934377628,-0.24537742284246142},
{-0.31435891556505363,-0.2867956952206521,-0.25075718402326763},
{-0.3192521014050684,-0.3692026575032874,-0.24494343350111344},
{-0.3099471566375761,-0.3611830477031429,-0.23769190311474594},
{-0.3023459145343199,-0.35743180896020293,-0.23941673919516743},
{-0.28765519110817733,-0.24902052971835154,-0.23956423964607856},
{-0.28298253669444096,-0.13747078943586657,-0.22428181350138543},
{-0.2857948098519471,-0.12486782697298528,-0.22128530076844027},
{-0.29506001631765966,-0.1875186976802765,-0.2323123650395801},
{-0.29834660569222093,-0.16127518597675833,-0.2389509551752461},
{-0.3076532322512787,-0.15298671581899242,-0.24665299003239058},
{-0.31933516257258354,-0.24440183712217453,-0.25659474522929215},
{-0.32850223124152855,-0.34928251103851415,-0.2568035837951975},
{-0.3378623935926134,-0.4214225235924242,-0.25400896041866317},
{-0.3203937244677606,-0.41020430984543965,-0.23686815884368778},
{-0.31022025281514176,-0.39183102277969734,-0.23180858612909774},
{-0.3102135660203765,-0.37295811081801544,-0.23412512599047758},
{-0.29903563665278665,-0.41121442063237534,-0.24926643569279858},
{-0.28616014640051884,-0.37010982734774006,-0.2584798678386356},
{-0.27896482907386316,-0.2162732219326535,-0.23972562045504628},
{-0.2770388738826943,-0.1533859941723245,-0.23299029171370053},
{-0.2719051366036022,-0.09177222578482684,-0.22302709712716381},
{-0.2814588590338559,-0.09105504845411225,-0.21563086360965275},
{-0.2898988423568368,-0.10507120878926544,-0.2239619288838033},
{-0.29190802020150813,-0.13480633970124625,-0.22828108090957974},
{-0.35038543536547023,-0.42959370605262115,-0.25927293295932236},
{-0.35664043147432456,-0.4853756279257121,-0.2529330122196516},
{-0.33692233478954153,-0.44689139020189056,-0.24649035239498188},
{-0.318655777212538,-0.443332739434972,-0.226413608081208},
{-0.3131123659196787,-0.4255894134554786,-0.22848396255488637},
{-0.3086411535886644,-0.46062393864696033,-0.23830241151396703},
{-0.2950520737568612,-0.5164347165786183,-0.27378782683026137},
{-0.28741986777794015,-0.5027151369457029,-0.2808244788623153},
{-0.28218296645072466,-0.4381939960902724,-0.27205978865269614},
{-0.2778253531373579,-0.3715245667737464,-0.26105132714233487},
{-0.2790204323114913,-0.2976749360689061,-0.24976851262596708},
{-0.2697574345916187,-0.285533341196674,-0.245180478994413},
{-0.27120718991668274,-0.21765205303704047,-0.23699120054196357},
{-0.2682460373029263,-0.1568211984635911,-0.2337938736093129},
{-0.26497565920916,-0.09721662810651319,-0.22635190449792655},
{-0.26682426686202376,-0.047822916595347015,-0.21037045650960878},
{-0.27511851226865275,-0.051350847840397354,-0.20545216384819376},
{-0.28341638473555,-0.07403554622860188,-0.2132388821695815},
{-0.2542464930259442,-0.009648147642924088,-0.2126707245329484},
{-0.24672040883849372,0.02807935824495462,-0.2291113303036675},
{0.24080963392295854,0.04008591577231185,-0.24753860043512538},
{0.27373311442158327,-0.00705332492904303,-0.23755293379856082},
{0.2575073264479325,0.006958702639723571,-0.23972381754899025},
{0.23083093774404495,0.03934101809698077,-0.2385649898541993},
{0.24499656504696818,0.00924689321106263,-0.22668935815348668},
{0.2737090413229834,-0.017570410077712813,-0.22502034841633367},
{0.3116266820872469,-0.0436470292005374,-0.22493244373160612},
{0.3137712223735836,-0.03657884596704728,-0.2230065703458387},
{0.2683649037385031,0.03512379241422747,-0.2325775175939395},
{0.24760640277044854,0.0442921986546072,-0.24523318504593927},
{0.21502438757928002,0.14217674714726863,-0.2529179557761476},
{0.22183179537859388,0.07864764233467747,-0.24840795918556835},
{0.21324945897054848,0.05916843654556253,-0.23106459999966888},
{0.22553324544185796,0.03456888831504225,-0.2285453208556291},
{0.2399437811182934,-0.0267029079964732,-0.23008008261691107},
{0.27448411244256765,-0.02494149640232678,-0.2167660027974717},
{0.2944397401410201,-0.041501171528514624,-0.20874975658045827},
{0.3140168202497654,-0.05193233763265646,-0.2127926730135862},
{0.33574717469946513,-0.06417209154981234,-0.21443335258403895},
{0.35306285284983724,-0.07112258124594953,-0.2094421107526582},
{0.3184847497406423,-0.019470020742381078,-0.21252614251629537},
{0.27593498117101806,0.046900476763420296,-0.22649429795448797},
{0.22552266810968713,0.14944302906609813,-0.24821182489227228},
{0.3028694085465595,-0.997580986655574,-0.003174043734258733},
{0.3319771313382624,-0.998120166056742,-0.005922658478110306},
{0.3099324847857,-0.9887188874609463,0.0003890255867476565},
{0.3074947879375018,-0.9865586022908438,0.007104399122170874},
{0.3073923951974495,-0.9763018665508177,0.00808295002265953},
{0.31760327316670184,-0.961967402460906,0.012874704601691248},
{0.3423065729568653,-0.9716405395291671,0.005716036094899547},
{0.34734043009037907,-0.9918498914611512,-0.0013204863234014127},
{0.3611051981771469,-0.9985171751069889,-0.007454183082790765},
{0.300757594670447,-0.9983339894400989,0.004410410200760862},
{0.3182960119305295,-0.9984842659626213,0.021528060847116844},
{0.3292275742386821,-0.9879825814775863,0.027831456006229834},
{0.3183206534173085,-0.9725820782663205,0.02225456399360039},
{0.30691799823740074,-0.9623473896131975,0.02029816338177864},
{0.30522706359024265,-0.9565146506762294,0.019596117925522592},
{0.29470750621859565,-0.9325216385021232,0.04206468325578819},
{0.30496067545559863,-0.9233622297934986,0.04533545125322127},
{0.3243023302429567,-0.941832783481603,0.019753395715522513},
{0.337030198929823,-0.9537610415532561,0.009958353725343795},
{0.3555204485963439,-0.9702896720607855,0.0033991552006122066},
{0.3691045850446003,-0.9834729896643832,-0.0008978084380220206},
{0.3803622725538196,-0.9850081774511975,-0.010643551518525814},
{0.3703703440856143,-0.9987285666388652,-0.017342729709271223},
{0.3659303378592458,-0.9968769396230014,-0.037255622053507895},
{0.3547914371050176,-0.9963779638582344,-0.044106698001096026},
{0.370838762876908,-0.9906358451203598,-0.07142548008744205},
{0.3910989765204576,-0.9812459151648059,-0.09762971032453953},
{0.3830602784391645,-0.9842577669417328,-0.11012291331160383},
{0.37286198362803125,-0.9808625229954786,-0.11241501566850463},
{0.38184112616643157,-0.98060233613523,-0.1297233674546089},
{0.3826237148836895,-0.9766805575655795,-0.1426737330222046},
{0.3849968513340011,-0.9812151138375362,-0.161774207425061},
{0.3797711360986324,-0.08019939518408808,-0.11925574695123263},
{0.3969845224376942,-0.10327145808442706,-0.08511767297179373},
{0.3982011217444563,-0.08017175558246532,-0.09048632880374684},
{0.40418612178173896,-0.056121113096626776,-0.08692990696841672},
{0.42103390809509184,-0.06110196032998024,-0.04961592419780612},
{0.3868808998490472,-0.09776529162221392,-0.10724655571491078},
{0.394297539033393,-0.11544061181528835,-0.08643791122297116},
{0.40876088169009667,-0.12613634296226983,-0.05613974029278501},
{0.41483682702326324,-0.12035677647385704,-0.045158532730011004},
{0.40234405962340153,-0.09909273406076087,-0.0740084782023816},
{0.39735437740668805,-0.09940187879777695,-0.06267719345443176},
{0.4011648273241838,-0.08328857431357173,-0.07739456313089339},
{0.411790323753158,-0.08907705652833829,-0.05214697694521239},
{0.4269533352598434,-0.08260317041327433,-0.012843568615960968},
{-0.31388133775601734,-0.9761530497766282,-0.2585434561333746},
{-0.33839415738725726,-0.9732574307263137,-0.23293442393652736},
{-0.3207677536370457,-0.9720766175642723,-0.2175774879447935},
{-0.26508516476951005,-0.9673747618094305,-0.262582076189313},
{-0.2951228545524838,-0.9590357943459781,-0.2054651528460966},
{-0.32756148293578713,-0.9690412589521091,-0.18441629157354023},
{-0.3359120827023669,-0.9730377704744406,-0.21119811256622872},
{-0.3454854203680434,-0.9698308999324196,-0.21079137717246801},
{-0.3538543785416052,-0.9711049266310222,-0.2229486563712207},
{-0.3376082050868682,-0.9780233188623598,-0.2442554564490967},
{-0.2921251466107508,-0.9798280958185541,-0.2887425065395676},
{-0.24230105157034873,-0.9756981671232603,-0.31116582285873556},
{-0.21852474084236057,-0.9720821293359982,-0.29276303060325354},
{-0.20646519360059143,-0.9616885724683819,-0.27404165199253505},
{-0.19695116803821275,-0.9404931021050682,-0.2530055162407443},
{-0.2551945358237191,-0.9576562333674248,-0.24438609648803997},
{-0.26820935979805144,-0.9419788454323376,-0.2086230463880095},
{-0.2971996535919464,-0.9534202848718103,-0.18858689030226444},
{-0.3187189192959961,-0.9596085309602786,-0.16661106015328114},
{-0.327875897215548,-0.9578274223253079,-0.15749420512713666},
{-0.3419726666809876,-0.965522162690419,-0.178440187076863},
{-0.360097398127201,-0.9622916227647667,-0.21113531470290145},
{-0.382595588699289,-0.9462392728663359,-0.17472724707311815},
{-0.37100991146329415,-0.9634711397892778,-0.18149408683015167},
{-0.34953702942188475,-0.9823466461508353,-0.21469212219226713},
{-0.3316986264425286,-0.9849969913593508,-0.2491613476241286},
{-0.3117254690151872,-0.9854416610864273,-0.2760753289613386},
{-0.2831590345041579,-0.9847857613134617,-0.3014291378672322},
{-0.25251648939392785,-0.9813574467368524,-0.3232445189388984},
{-0.21772561680992503,-0.9813645797428985,-0.3398487748216705},
{-0.21366981337004418,-0.9790275938431872,-0.31761429724135737},
{-0.18427227741386237,-0.9777478928244637,-0.2957857444376448},
{-0.1789588710377361,-0.9627098682847567,-0.2761711762068646},
{-0.16684879568045421,-0.928349236867343,-0.24787360205345665},
{-0.20104449997162543,-0.9296688174880852,-0.23814200280814676},
{-0.22274640420254233,-0.9378382172279744,-0.23843252566104373},
{-0.246791534916655,-0.9403901611625851,-0.22409129297096506},
{-0.2613985278583612,-0.9326065843810959,-0.19519212508228198},
{-0.40437761547771456,-0.9347312055833754,-0.1392456617369841},
{-0.40774870558237547,-0.9553198965988862,-0.1162956684317735},
{-0.39460478099801866,-0.9526486378926023,-0.13641435979316704},
{-0.3553664037133142,-0.9848102402518454,-0.13792671006166637},
{-0.33203873399280176,-0.9988877599501492,-0.1593755795617213},
{-0.34144290977469943,-0.9931548809730107,-0.1827325101181768},
{-0.33368362919745037,-0.9991325461467631,-0.2012376334940581},
{-0.33335178930476594,-0.9945227703393474,-0.23099854054436042},
{-0.31950813425077423,-0.9983466342178708,-0.2473761253461118},
{-0.2939748081721634,-0.9970906015203709,-0.2815370570296142},
{-0.2883500982463482,-0.9902694759113954,-0.29419365727567237},
{-0.24483143606324156,-0.9948314284935861,-0.3228414711626512},
{-0.24516870698465812,-0.9847290223618832,-0.32873058358291096},
{-0.22893412333673632,-0.9871935896284486,-0.33724130733001756},
{-0.209733485125416,-0.9858028425580483,-0.342057450542769},
{-0.19290286201025725,-0.9800227905492657,-0.34400334394133547},
{-0.18780535602475926,-0.9763825978580025,-0.33991021492781476},
{-0.18583336139108092,-0.9799282798127665,-0.32485281738166577},
{-0.18344375018283704,-0.9812754192921378,-0.30828309187758157},
{-0.16461588537476857,-0.9771454905968441,-0.294059834262926},
{-0.15305282148904056,-0.9640908879492351,-0.2746801643992583},
{-0.1372802747486892,-0.9274869707514493,-0.24783651870879786},
{-0.15792024181481187,-0.9066196122918098,-0.23434849404561245},
{-0.20091706096741802,-0.9208493537813386,-0.22887509436512024},
{-0.23478135032902947,-0.9185791572111022,-0.2117456201822306},
{-0.2206018224823011,-0.9351663104529255,-0.22955632406512644},
{-0.23827402238363324,-0.9392514969056479,-0.21872075242755445},
{-0.2482691933204791,-0.9271363262405021,-0.20549731193054932},
{-0.17962614813595457,-0.9641309300996488,0.37244829849357175},
{-0.17163304328589016,-0.97951603264728,0.36604594429645304},
{-0.159424355235549,-0.9739506157014222,0.3541331878171769},
{-0.1644778074187373,-0.9481927051107323,0.352110940231609},
{-0.1564247115867836,-0.9574007476617419,0.34710060905667206},
{-0.1506188026966857,-0.9696005401714777,0.3364010479295303},
{-0.15712252653513434,-0.9851962257586407,0.3391467144917051},
{-0.16634655726129838,-0.9974644288321718,0.3475216912055187},
{-0.17761520669431613,-0.9991383819528713,0.35955112556027996},
{-0.1850396482016292,-0.9795311092765324,0.3712072808056711},
{-0.1972200283958341,-0.961549805009681,0.37232527698104434},
{-0.18831565918161178,-0.9501026923124952,0.35355595296820275},
{-0.1775824813464999,-0.9484958514932449,0.35422583402796703},
{-0.18028737694650235,-0.9344711802091141,0.3460796776461767},
{-0.17109534275639593,-0.9320473031617273,0.3385392860127293},
{-0.15907640499081172,-0.9416844522277834,0.3373425664809351},
{-0.15106646097693588,-0.9524933361811316,0.3238647547440412},
{-0.13775395139624177,-0.9672781443182411,0.3023787615278306},
{-0.14924162257403772,-0.9900804544383969,0.32185336709112194},
{-0.19344958981892557,-0.9988452870106629,0.36056445863010783},
{-0.19899207894180446,-0.9797953492225818,0.36823392962542345},
{-0.20745546604646384,-0.97186149591857,0.3649281712267201},
{-0.21294023455294642,-0.9644854651480015,0.3583182756636337},
{-0.20174029846995015,-0.9578060243695774,0.36479730808213634},
{-0.20610338318354585,-0.9538673853879592,0.3393502643915251},
{-0.19629970594267565,-0.937370203214057,0.3359380601669687},
{0.09364955191444592,-0.8977541102049615,-0.2582084747007917},
{0.10194276359827437,-0.8963320762869218,-0.24953041216171076},
{0.10115723626100986,-0.9207412261639201,-0.26522218828578853},
{0.08557453011007936,-0.9070740083624,-0.26225556533421085},
{0.08933499905208526,-0.9342618954319278,-0.274530050425131},
{0.1056096036022645,-0.9370082111252755,-0.2785569372491998},
{0.12458353036106734,-0.942585300745758,-0.2753231761030631},
{0.10781126743180748,-0.9180296023352477,-0.25741968470913823},
{0.10841105613621106,-0.9147034180839613,-0.24644506301238742},
{0.10630985040209581,-0.8976307434098955,-0.24222785857779028},
{0.09854736772770292,-0.8803651577878335,-0.2468014434631086},
{0.08197420639675652,-0.8702052020873919,-0.2560896287473751},
{0.04303948332549849,-0.9018882534720435,-0.25532389937967703},
{0.057554762850473104,-0.9408972430989534,-0.2675717785917749},
{0.08051312474201452,-0.947236414841117,-0.2771807409161852},
{0.11275121196441994,-0.9510233175518799,-0.29845720500141293},
{0.12205782789939953,-0.9463052515786506,-0.29151502227195353},
{0.14299785186611924,-0.9547896329240722,-0.301102971232261},
{0.14571583845517447,-0.9600321257035993,-0.2738203705063419},
{0.1294886109189391,-0.9439883674971397,-0.25698796467087553},
{0.11683900237868812,-0.9282065799336442,-0.24910179222944187},
{0.12261210411556826,-0.9040495118077012,-0.23780608964391328},
{0.1160539212527044,-0.8900940617045257,-0.23317686008706226},
{0.11490840765260663,-0.8784588996374889,-0.23215070056772666},
{0.10433537398377002,-0.8429505246259813,-0.23527629372494796},
{0.10137043176135001,-0.8498011554246964,-0.24056103740072896},
{0.09179044767240496,-0.8543580838803467,-0.24895100893839334},
{0.012559796833501885,-0.9179637851089202,-0.25321028153510067},
{0.03029995896253283,-0.9487571740674442,-0.2639271067891785},
{0.035337894679634885,-0.9786249115352273,-0.2735733543157318},
{0.06141529360979298,-0.9664870446520054,-0.27805615751596907},
{0.09012619964706299,-0.9691009152755381,-0.29509243834804577},
{0.12537303960280927,-0.9553636656759026,-0.3144048322994608},
{0.138066550021053,-0.9530589397893859,-0.31740537687005044},
{0.15797291705651173,-0.9632146809180396,-0.32154252037679193},
{0.14299685957722344,-0.9537501794957919,-0.2558110218604914},
{0.14299767019438347,-0.9373742562998575,-0.24368847489791085},
{0.34632136320559276,0.04640993014222958,0.23082479862050637},
{0.3614660566767934,0.05668984762070144,0.24139789284658822},
{0.33783361827704017,0.06689211371223418,0.2296569138991228},
{0.331756498983242,0.08642603137882346,0.22419840811373934},
{0.33954056128510113,0.08680204725071594,0.23189942943383174},
{0.35128214899224247,0.09428880003857855,0.24060805000879357},
{0.36615141642554705,0.10118644238295053,0.24981990129180712},
{0.3717384756809319,0.07408398671276507,0.2458626616742261},
{0.36465286683451836,-0.002566022431724245,0.2361380945062202},
{0.126261557815724,0.7489159911801219,-0.04675394310361765},
{0.17190161891821817,0.7425312665782263,-0.04471647758855849},
{0.16471521731791622,0.7484037618779071,-0.05877170690857012},
{0.13501876973675833,0.7528224498291309,-0.06275491496028653},
{0.14536979310764306,0.7468185229966874,-0.06962617453147667},
{0.1585169803463889,0.7516692762687125,-0.07495938843883965},
{0.19782238918954928,0.7412248980610276,-0.06551136177452414},
{0.1559125927749813,0.7387446464679415,-0.035127408850417714},
{0.11556941335751396,0.7365614228507821,-0.030606423775844552},
{0.11408644610185605,0.7666361343587617,-0.07472357852582481},
{0.12955134822502118,0.7509656361383317,-0.07337324863579574},
{0.12205010738183375,0.7561965794825405,-0.0867831565774205},
{0.1793643389789779,0.7485779903845388,-0.07830679959819886},
{0.19175712424211133,0.7434160249298964,-0.08332529750198246},
{0.12835247944222425,-0.8811277254298846,-0.23049269418827692},
{0.11326464603709277,-0.8516176039931074,-0.2321284505609314},
{0.13234419950532605,-0.8573782033148623,-0.2223218155767141},
{0.16754015543894268,-0.8816267022570593,-0.20956687461399637},
{0.15420441418663558,-0.8625304009920862,-0.2128845691644614},
{0.1442238332962645,-0.8316532018685402,-0.21514384311998824},
{0.11338010958044951,-0.829494375384363,-0.23561678692925664},
{0.14728508916123959,-0.9060943738059437,-0.23051545096359832},
{0.17774538139863816,-0.8988519227567328,-0.2120875720724644},
{0.2006038418964451,-0.8872486966685084,-0.1931696745768221},
{0.20236170823572464,-0.8563189731651718,-0.18334719271768912},
{0.1551162862480617,-0.8042733759541635,-0.214163661423509},
{0.13565391962275836,-0.8084935997517608,-0.22657059158424414},
{0.10451600562228124,-0.8341253876615216,-0.24506564439648068},
{0.09369971456167162,-0.839307576048855,-0.24918317160539147},
{0.11345425502161095,-0.8451527972152001,-0.2622509852941357},
{-0.06879873679966188,0.7474379067507655,0.16978380721880598},
{-0.07580604194074003,0.742209801097821,0.18427596556257986},
{-0.0812274048866273,0.7426788679578797,0.1932018134755264},
{-0.07571377075990748,0.7601734343355445,0.2038328822334715},
{-0.06574851828943991,0.7803511753855062,0.20189568145561837},
{-0.06263327192189448,0.7958247499436364,0.19887597742255697},
{-0.05444790206778333,0.7987590321390257,0.20817878356312478},
{-0.0461547934375127,0.7999266746314281,0.21223567172138116},
{-0.04314725291148466,0.791594880545519,0.20233813181277677},
{-0.037641128945584024,0.797381478048828,0.1992243834402454},
{-0.03279035230058695,0.7947311317779047,0.1983170701707382},
{-0.024165866987437588,0.7972017175847221,0.2121263988283418},
{-0.010216665967009068,0.7983203203949557,0.21266726002107525},
{0.005103962237768314,0.8091837749255395,0.20387723988441536},
{-0.0009326378845087896,0.8183983629710753,0.21436986734285765},
{-0.007357417385711696,0.826684461834606,0.21486378710884976},
{-0.01114170976048167,0.8344798727767071,0.20833528048338326},
{-0.1277296513620214,-0.8327503663515465,-0.38747086074999093},
{-0.11974376132340474,-0.8218826356295217,-0.3914180510520834},
{-0.09717595435465545,-0.8178498110081948,-0.3964809661016483},
{-0.1257045257136923,-0.8379998306511325,-0.3748896224020382},
{-0.10316623349635318,-0.8250619483753214,-0.3826103811344518},
{-0.08728464121823405,-0.8256254441664779,-0.3807428668721754},
{-0.10218804806415172,-0.8135140025527504,-0.394836841142663},
{-0.13267955596786637,-0.8126228803782898,-0.378289242406068},
{-0.16451288387504026,-0.8440870821282285,-0.3685771585298466},
{-0.16275418673285205,-0.8516586182466687,-0.370510205293157},
{-0.1465870319839077,-0.8499559716157972,-0.37270392549949366},
{-0.1306216231663195,-0.8419160974490569,-0.3527670822335556},
{-0.38993486122198895,-0.6496968969902863,0.05967147602020815},
{-0.3982990374979912,-0.610077885546933,0.05220929247539324},
{-0.3860262140128882,-0.5688554372389574,0.072142875211758},
{-0.3801039905907767,-0.5266248244751567,0.09248840551460645},
{-0.3711648083973886,-0.5049662038008863,0.1019320146872419},
{-0.3778257292828435,-0.4985944480111452,0.11089184477644562},
{-0.3785360572703977,-0.47201074695195244,0.1224679178458249},
{-0.3765097151651245,-0.4207936960953101,0.14190460926154894},
{-0.3722889240417559,-0.3886316082156972,0.15072839909290367},
{-0.36168689195170567,-0.38475181600275554,0.16832349474731953},
{-0.3571167120834231,-0.3750237237656313,0.18583072715091245},
{-0.35006974513392775,-0.3544758844552866,0.19446178770600686},
{-0.34933406703358444,-0.3529847919046867,0.20558197520904414},
{-0.3577317187173179,-0.35240508483273525,0.2168970284904506},
{-0.35857665908662245,-0.34176122893437144,0.22487347691084694},
{-0.35704493793649683,-0.33360479800663656,0.23904147444559762},
{-0.36526917173075873,-0.3165805946265605,0.2562917815809231},
{-0.3543244791244644,-0.3048570827259232,0.2582383039249139},
{-0.3435338728351044,-0.32096341569006964,0.24117572000024123},
{-0.3348288591346625,-0.3160897239709873,0.23140302682078426},
{-0.33245367648690594,-0.2968457405833674,0.23704733179627394},
{-0.3241394716247232,-0.2952836430690967,0.24439912691984747},
{-0.3027326692243706,-0.34264894609179636,0.2567252237822481},
{-0.2658123521066242,-0.4160415873885785,0.2829097888507555},
{-0.2595028066686907,-0.42843137347446014,0.2834475499374951},
{-0.2562546785817197,-0.4429026597543702,0.2858930087371638},
{-0.22355310638989698,-0.49711502707276195,0.3078303574128083},
{-0.22626594561310562,-0.503815542834942,0.3074661353300308},
{-0.20241022096361908,-0.5458122314595931,0.32303097921842727},
{-0.20282870977499787,-0.5550209220793676,0.3188992061831727},
{-0.18718911274817185,-0.5813483257533095,0.3323900069179694},
{-0.18087908072746078,-0.5774719385574036,0.335333246273617},
{-0.19725018059193097,-0.5858157697238167,0.3014828574558106},
{-0.2138120039067136,-0.9886564752516543,0.3368728303039551},
{-0.2250815053907961,-0.9957619436872877,0.3381626220720719},
{-0.2132491359985737,-0.9798835375701949,0.3505085179664468},
{-0.20542300553460444,-0.9983437168460204,0.3467653035897067},
{0.41900679680656294,-0.18787501757375244,-0.04808456745355987},
{0.41992182953122825,-0.2032774660537212,-0.005971342253662404},
{0.4072520384297831,-0.2202394187104929,-0.04533648922565308},
{0.40620346635525706,-0.186618255002086,-0.07757592464357119},
{0.39604569921490707,-0.23859179440328232,-0.06061105355254143},
{0.40728393297469057,-0.24674854936539972,-0.026368271846429026},
{0.4166235281729534,-0.21529431725036363,0.015358332526802007},
{0.43436567912940754,-0.14996627128768647,0.0372207878261859},
{0.4440440846780057,-0.14891790213305245,0.008604737807953898},
{0.43086194315985504,-0.17481303969111656,-0.02073167145238802},
{0.43014772357248765,-0.1691628372898655,-0.05852791300085221},
{0.4196697074086764,-0.16389262310331398,-0.08314212245917052},
{0.3996694383963943,-0.15511230912441956,-0.10707837549594972},
{0.38831594295073835,-0.20326336259002414,-0.09093341975822565},
{0.3672096341005932,-0.2251617442719602,-0.10635894904789826},
{0.37549846866423836,-0.2604229001729658,-0.0901303340070612},
{0.3904940606359558,-0.2682048557201348,-0.06168237177831067},
{0.40062949702651685,-0.27469446653321616,-0.03896448058285291},
{0.4043461246477752,-0.28347680652380697,-0.028440637458094477},
{0.4103220878442135,-0.25250023296080093,-0.0026754823085383913},
{0.4131154958262116,-0.22931550383687285,0.02583286399299179},
{0.4147452750925189,-0.20403906159262492,0.03374214061710113},
{0.43070769429452566,-0.14010281660889695,0.05772781580286137},
{0.4453559649669303,-0.11587344631934525,0.04524282735299523},
{0.4550533376821865,-0.1225845001046071,0.024814088207945843},
{0.45988463826718395,-0.14119900792634796,-0.001751204511097892},
{0.44276450583618043,-0.16270265092353026,-0.027464827569759365},
{0.44772204915418967,-0.1611254767800072,-0.04718452955274551},
{0.43432798808748047,-0.1584012899789644,-0.08046082399906833},
{0.4176369218000267,-0.1509176989167487,-0.10163869451457742},
{0.3461810966894699,-0.2045012387380264,-0.13224580832429553},
{0.36159902763847507,-0.2483456627787281,-0.11029194451922189},
{0.3539397090122057,-0.27127328496265296,-0.10578309214185554},
{0.3662630701744917,-0.28614206581317964,-0.08088057920055843},
{0.38564517188963976,-0.28145933977339066,-0.05070068719442931},
{0.3805114133623914,-0.2887445888588781,-0.05514526283679484},
{0.3946076569359642,-0.29022854946583976,-0.05077484325966884},
{0.3925336552162692,-0.3038121175259171,-0.05738321957958486},
{0.400829136203183,-0.30381989860072817,-0.028845568883391317},
{0.40630073297761915,-0.2854744944279975,-0.008029457789352806},
{0.41100980141909305,-0.2663232390565692,0.008166882364580068},
{0.42334313327868967,-0.2446803430803161,0.019551233320304257},
{0.43431347878399945,-0.20189863494933427,0.04213389912470446},
{0.4200232703538815,-0.1828313522913233,0.04535891452973725},
{0.4310467489986577,-0.15758303623147582,0.05612096967157222},
{0.4368830130047445,-0.11325746894112253,0.07199626930822413},
{0.43922392981335817,-0.0856005957545295,0.07858211939531387},
{0.4506755418076254,-0.07631725292506757,0.06373839862024373},
{0.46316826883599016,-0.11885425454002146,0.02021334180451992},
{0.4623495295681319,-0.1325083420433997,-0.0026560795546777915},
{0.45618405937832524,-0.15166762178102794,-0.03444926544510377},
{0.4426555272301047,-0.15587795774912397,-0.0708403919199256},
{-0.21741558071275516,-0.9717982730921182,0.34365132148745686},
{-0.2299124606932549,-0.9717065182414818,0.34674724796895107},
{-0.20726826979008556,-0.9856060410726467,0.35789322117198014},
{-0.013546364663335813,0.5944069910483892,0.16046555048143624},
{-0.03579161187163358,0.6047032812936434,0.18051667164361343},
{-0.04693198724790417,0.5963702718131978,0.16867610577512568},
{-0.036161317041126025,0.5908854225637218,0.15567754407716333},
{-0.0564510815579513,0.5843741301320242,0.13668109321034985},
{-0.08617589542767502,0.6034741190145108,0.1679213500177121},
{-0.06550898676186157,0.6060927715356027,0.1800551935625519},
{-0.07281898782454037,0.6325113637968174,0.19751473447948867},
{-0.04030426235692588,0.6262344427779581,0.19096294518683415},
{-0.00374699123650977,0.6032401927505455,0.17045619131137404},
{0.018495959046099755,0.6001830314052758,0.15179693062298347},
{-0.012010656296693803,0.5847173994079442,0.1301479767973895},
{-0.02568152453145391,0.5744603800050325,0.12299070854409327},
{-0.05020413637549211,0.5716993935222168,0.12033017590707377},
{-0.07915191367118055,0.5778847626103317,0.12989531178444594},
{-0.10032940490710097,0.589346061639024,0.14038357699641438},
{-0.09802148223547975,0.5974479018037752,0.14647840769083728},
{-0.11595475079554406,0.6160085073027939,0.16778472118593563},
{-0.0966002844323876,0.6245319980045707,0.1905402418036673},
{-0.10321567158145135,0.6409797357189281,0.20067799849288845},
{-0.10244997833561895,0.6591575588707035,0.207689735999356},
{-0.0924330439747554,0.6773705179736191,0.2105493670474655},
{-0.07911610202867198,0.6839748220843939,0.2078964274390745},
{-0.042097634365264334,0.6450220030208832,0.1942440525370883},
{-0.026891569844427376,0.6303942803779601,0.18784910544723102},
{-0.0007944844975228455,0.6209564464541876,0.17763737542691393},
{0.03134158501478759,0.6119317106845588,0.1575322000176977},
{0.05814270677018674,0.6120250867695152,0.12234605117058857},
{0.0405145511094941,0.5997751602975647,0.11531960144074802},
{0.011132304264126936,0.5840271732385907,0.11455460194721641},
{0.0013841707660473355,0.5750308473162478,0.11033137790995962},
{-0.021340017320508893,0.5647653977073522,0.10034273334429952},
{-0.12510252826344884,0.5992176628609118,0.14159763289887597},
{-0.1359262859261575,0.6186745379002379,0.15191229323759806},
{-0.1450015604353772,0.6373897566704654,0.17340613764753535},
{-0.12798013312691245,0.6424072410371968,0.1922284811222076},
{-0.1253430499551074,0.6560112349498574,0.20226991354479545},
{-0.12417471902244301,0.6732398604665666,0.2071000996639987},
{-0.10761649727014125,0.699022329676226,0.2123402020259502},
{-0.1007635419231346,0.7242589730614488,0.2121455678524839},
{-0.08756192540739242,0.7273775755752707,0.20890499773468357},
{-0.08165329974285969,0.7110579047481375,0.20495125343880227},
{-0.07093086072590606,0.6975652798591284,0.19700094556260675},
{-0.057579936603565494,0.6683478496495913,0.19901904019603966},
{-0.04402297654712598,0.6672170472104587,0.19964420876065103},
{-0.01927911402672123,0.6577786863324119,0.20568925183780576},
{-0.015397603900348505,0.6444903210316408,0.2020751178853418},
{-0.01407131948631608,0.6338876015637365,0.1954332045380416},
{0.004730879673843211,0.6329390105635311,0.19430868411629817},
{0.027288740380661525,0.6358598787978926,0.18545842014468975},
{0.03268788306717215,0.6288934200499416,0.16601284168762295},
{0.04545612643809714,0.627903532195697,0.1567570375310417},
{0.06758405726381507,0.625733277390692,0.1347177720740443},
{0.08694493207089021,0.6365370554120983,0.1163365360730567},
{0.07567823746824555,0.6219443890397295,0.10307982308821245},
{0.07580962862951163,0.6220095167633873,0.07801168076910955},
{0.03853465428651419,0.5938890884884614,0.10129997553131384},
{0.02380830726404571,0.5764177835298283,0.09281814821427103},
{0.008909076743234955,0.5687237730388839,0.09102387740892412},
{-0.013463259937100302,0.5579733703859248,0.09547050031114232},
{-0.011539060906043794,0.5495867018741462,0.09052261215532362},
{-0.2268804465408822,-0.78555754842426,-0.32460495020239877},
{-0.2361081850703082,-0.8028297804695903,-0.334097132660174},
{-0.2332495473735024,-0.7704869398369757,-0.324522315060416},
{-0.2311165172133951,-0.7484488185931911,-0.3217526147087305},
{-0.23584864627882451,-0.7620563800712823,-0.3356353993048259},
{-0.23963413067515896,-0.7991540863588995,-0.3437152741880752},
{-0.2352812185163579,-0.8201392987794716,-0.34708008121293915},
{-0.2277220031413072,-0.8267658922061306,-0.34300628270954786},
{-0.22309710927073476,-0.8056937886378831,-0.32959471422451375},
{-0.21035471215704685,-0.804524971122441,-0.330831536463967},
{-0.23162329530112918,-0.7297838942087577,-0.34115623655650734},
{-0.23614376829513722,-0.7360890221550112,-0.3532724207587052},
{-0.24314220339339754,-0.7773698295864777,-0.34813846037397267},
{-0.24121450585341786,-0.8162878760423193,-0.3474868569781967},
{-0.22674396963342275,-0.8378960801538972,-0.34707655508141294},
{-0.21523983325936483,-0.8387552652871375,-0.3468825498533711},
{-0.20943433020905097,-0.8233426038808773,-0.3385112405713226},
{-0.19287531271329839,-0.8231822759180507,-0.3441659815787442},
{-0.17395061687007066,-0.8227996954282912,-0.35317941014203574},
{0.36428495607181943,-0.08257820595452076,-0.1998432806115458},
{0.3461082686339947,-0.07334276709327733,-0.19663817260408406},
{0.31777061195867623,-0.0586095101704032,-0.1976162050495607},
{0.3372954109790198,-0.07422675626169185,-0.18754421565349982},
{0.35491723575156403,-0.08101067741151795,-0.1884035027778902},
{0.3700124040202259,-0.09493913704424338,-0.18789856903011676},
{0.37750843694032143,-0.08791456140178222,-0.19186616393663602},
{0.3715654636312445,-0.0776741994909464,-0.19655507000266426},
{0.38235388136051274,-0.09936507911600381,-0.1847677073925585},
{0.37841402698435844,-0.1144815656598102,-0.18159552765280496},
{0.3699809142526942,-0.1391831634726597,-0.1843334333259171},
{0.35569901385166186,-0.1716167868527633,-0.1913954556565086},
{0.3292716269785841,-0.19741011705747916,-0.1867139662594121},
{0.32275008124909826,-0.1910583015999513,-0.17801432303045706},
{0.3320207389292914,-0.160845188101558,-0.1643524140807709},
{0.34063294387054815,-0.15488892088353626,-0.15562053102436946},
{0.3414349863372417,-0.18022169623957876,-0.14964477074782312},
{0.33833397304714624,-0.21167155123443163,-0.13845715540821626},
{-0.20338148587133675,-0.20388619173263473,0.29735230087750014},
{-0.2056880964693108,-0.21151949199160158,0.2995642583763282},
{-0.19476562305998518,-0.21123896002176354,0.30859989657491826},
{-0.18383605807851824,-0.21211427569280536,0.31325990621088273},
{-0.1855021695671615,-0.21811358211367696,0.30321126003925514},
{-0.19663357290946432,-0.22086767888183562,0.3074933903400259},
{-0.19992753858146048,-0.22096008180123689,0.2957823606687653},
{-0.20550900532212604,-0.21738603037068346,0.2862727324123182},
{-0.21688647187523202,-0.2098790950216267,0.282763322122645},
{-0.21877418782204325,-0.19961782067543016,0.29469907760622344},
{-0.1651862708805823,-0.22217331752486805,0.3183865922893302},
{-0.1600421177553068,-0.2363459142230345,0.29773676607871713},
{-0.16857099805191111,-0.23756125776376358,0.29992483321308905},
{-0.1629591655711785,-0.24968177871464775,0.29727207633884156},
{-0.1859118733283474,-0.23870008456909605,0.29938881447516025},
{-0.19911064259115493,-0.22861242996985529,0.2998495329346366},
{-0.2187146122416081,-0.21661341128832814,0.2834483605546553},
{0.2528867693260463,0.23731279244889858,0.16698032761075526},
{0.25138795625788063,0.22785607316386977,0.15451305268632953},
{0.24581354071785963,0.21394706728057994,0.14495766865025872},
{0.24056028680961017,0.22305995102632525,0.1334949513071382},
{0.24217464522653404,0.24495046982804863,0.10410443786659015},
{0.24929166415989337,0.25980814639213007,0.0820340874194374},
{0.2410795067552242,0.2597996354431525,0.10329626530682447},
{0.23045753645777636,0.25124206163637636,0.12630133064575746},
{0.2379491115146952,0.26960716284993136,0.14169242729826081},
{0.2525453242043386,0.2936614525817866,0.1327546230478042},
{0.25132343623149095,0.31704476803623965,0.13809240743357204},
{0.24641083701353755,0.3360448555249917,0.13783504657810186},
{0.24011843458804968,0.3614930529904863,0.11727569820393569},
{0.22876818267344187,0.3887319250108859,0.08915703246356893},
{0.22000306643829035,0.414776203377522,0.0731080843949504},
{0.23195142632814392,0.4146334646384218,0.05061349538534322},
{0.22967312358630604,0.4546836904139196,0.040073433542935105},
{0.23439046074777664,0.40838920841013354,0.02490548821437309},
{0.24285354400380202,0.3926216868587302,0.02307207724284438},
{0.24744378531878827,0.356932072511443,0.025819940864373257},
{0.2559332927819001,0.36294734692172076,0.026303653016112902},
{0.26889060862139835,0.37416377688598995,0.036317256728487485},
{0.2900618231519686,0.3964735961786602,0.04322195771035879},
{0.30991542251624804,0.4123609180221065,0.04237985609472649},
{0.30225282104984125,0.3881897453700585,0.04313453217155419},
{0.3054307962242063,0.37702908119181255,0.04755973374507004},
{0.3170973673157809,0.3731860886606441,0.045023261655417535},
{0.31388672628843706,0.3494978441033709,0.05490036508736081},
{0.31794573182546165,0.34367758845818724,0.051572854951125756},
{0.31500297905259184,0.32871713350001786,0.05370684127826338},
{0.2953605279287999,0.2944991590163029,0.054877310837852245},
{0.3068382602815198,0.30517162768184486,0.05226286120206241},
{0.3238994853866015,0.3138393551177359,0.05337802712302601},
{0.3361016290048241,0.30042746153591154,0.07247063227122298},
{0.3426078962475735,0.2964262488590145,0.07293773367683053},
{0.35727112137233213,0.28535766356578735,0.0677613917196835},
{0.3414624633904693,0.2806845023835249,0.07379976925022914},
{0.36021472513385894,0.2834800181826209,0.0872080910169914},
{0.3566710288192945,0.2772354379199501,0.093432556712568},
{0.38719385438047516,0.2779646108972638,0.10207234069820227},
{0.37292127554558063,0.2794819661689629,0.11308621942599413},
{0.3615416406181315,0.2759614112213475,0.11985482702962591},
{0.09543580791526322,0.6557249075454077,0.12466278863982136},
{0.07665325161312984,0.6462497066140909,0.14088512697530833},
{0.1033724266668082,0.6535117335896357,0.10213451599055202},
{0.09352829293647771,0.6384556332434245,0.07983029027500908},
{0.10231498986150342,0.6535902763367285,0.05863057984211991},
{0.09906546258344467,0.6403878290180778,0.05512303089093233},
{0.0913421105135633,0.6739411101793716,0.13839034589299293},
{0.10885146029592446,0.6849269381537177,0.1220833400293799},
{0.11413169511295373,0.673923967166926,0.10181833917623188},
{0.11583503124649473,0.6728445130221369,0.07673107564133845},
{0.1163120417297597,0.6805869948070712,0.052417247117999555},
{0.11600455859856076,0.6903542782059521,0.0354365907717072},
{0.40997286164769464,-0.18961000602322017,0.10652623259466645},
{0.4102133121580301,-0.17916206025010425,0.11322619696719233},
{0.40812476076335713,-0.22324397599538637,0.09899781323484638},
{0.4112472123806798,-0.2392366706327962,0.09166508620667285},
{0.4064711113183422,-0.2577847131594447,0.08907534923898525},
{0.40852306595113397,-0.26262225432792663,0.09626573805580355},
{0.4130186350436337,-0.17121207747069903,0.12445237346072373},
{0.4157951029330781,-0.11228277883062071,0.1278018212558575},
{0.4167962161882585,-0.17263954241747095,0.11006321661667819},
{0.4084217058714742,-0.31557875149721354,0.07274051360275115},
{0.4100477157148663,-0.28831288900636387,0.09854137521644242},
{0.3992785488151416,-0.16096968848575893,0.15079166335326016},
{0.41501835002192833,-0.1106838008915832,0.14197529019083718},
{0.41807040543525625,-0.07101526424569105,0.13997527136390833},
{0.4324620950595244,-0.09003537280964996,0.13148129541354153},
{0.32919053126552017,0.14685955393005126,0.29008346493029186},
{0.34239942208754737,0.14816462524731236,0.29374327391938587},
{0.33973574259859035,0.16075526696680423,0.2890909837385794},
{0.3295872162813845,0.1585507250745001,0.28368903417063096},
{0.32939446681937573,0.16828433014575803,0.28940786917890976},
{0.34691172941511655,0.17426572330852064,0.28944631028075163},
{0.34935323605772645,0.15759151743303462,0.2856848384257717},
{0.3536437349448281,0.14153316811769254,0.28873203013613885},
{0.34284652260369647,0.13374553931281036,0.2936303229705032},
{0.33344885194482826,0.1337525097704613,0.2919025078985784},
{0.32400331768923846,0.13282588617657312,0.28020896652230226},
{0.3224917982236477,0.14665991475338522,0.2788796191865494},
{0.3226181641959655,0.15668223870907627,0.2750247308751161},
{0.31967788364607286,0.169425182962787,0.278216404735802},
{0.324217790203768,0.18406190313746554,0.28616059208059574},
{0.335211642544314,0.18477065026219622,0.2907158185589321},
{0.35090516101720265,0.1880389619727692,0.28058676511450237},
{0.3548790581268593,0.16852174110734475,0.2819551601869574},
{0.3530408865059275,0.15989040645103497,0.27313316476239624},
{0.3577379189293055,0.15205414380376783,0.2791652783364855},
{0.3594665849898873,0.13554731709175302,0.2772931447250449},
{0.35470385751708033,0.13196313347790176,0.2862778999639131},
{0.34322221444120643,0.12115043973014158,0.2863116994060268},
{0.3305791705188224,0.12302143869003958,0.2802062711936846},
{0.3248291899631429,0.12490581230187596,0.2664575114678198},
{0.31697505442926377,0.13013598540042154,0.27162109815678254},
{0.31942713946645246,0.19021424196672246,0.2736898112103922},
{0.33043631066523177,0.1960773763911764,0.28381683864312546},
{0.34034847992939987,0.2001374358367501,0.2811614066260088},
{0.35668821220323704,0.17266812437482243,0.27572679120508153},
{0.3505755086222019,0.1569374003803767,0.2582812220132732},
{0.35131611098275134,0.14558917447746542,0.2572521036881828},
{0.35836873100421146,0.14902510864289842,0.270203441358926},
{0.3591531842471785,0.13653959536357346,0.26841197743501694},
{0.3527849949604607,0.12316895932669908,0.2674213002117683},
{0.3536608779572737,0.12207706332402982,0.2763000547736565},
{0.3576960133155905,0.11088778637860582,0.2832214058107489},
{0.35101876003485016,0.11039594361988513,0.2899169781893822},
{0.33691088522055757,0.11086379402299973,0.29042122243448604},
{0.3285566796418657,0.11245555821299749,0.2848197356810214},
{0.32297695525001086,0.1090586930324229,0.2729691895535528},
{0.322289322418125,0.11806863689809291,0.25761024667346316},
{0.31598443776326046,0.11743908058922022,0.25730791090811067},
{0.2955967033101019,0.10719888016437173,0.2759929774822415},
{0.2907615323734474,0.11300089851706399,0.29292988387485813},
{0.2982308584859786,0.13399535176078017,0.2970850203202944},
{-0.11199962749432354,-0.9489484648435278,0.3049999478915529},
{-0.1268227237465499,-0.9433305224554716,0.29868290397928615},
{-0.12169117502754931,-0.9393049933885858,0.30586294281920523},
{-0.1169858345750858,-0.9338181988704066,0.2991339364667454},
{-0.400056153777356,-0.9338879066341396,0.12565985412124023},
{-0.40380115087440366,-0.9234465276037065,0.11168550803273025},
{-0.4013888243247431,-0.9173558711095747,0.11136601863085402},
{-0.4123735983905401,-0.9246831065517709,0.09095600973552058},
{-0.4197816055114177,-0.9543937585253679,0.06534454674960077},
{-0.42099897506384326,-0.9759212313297612,0.04765916236732845},
{-0.43476426904247767,-0.9854964537068953,0.027785256140140917},
{-0.44452818885822765,-0.9901380040071356,0.009524641672434631},
{-0.43981044691938087,-0.9983583068924952,-0.031413055844283624},
{-0.441811377292212,-0.9944861332059696,-0.035863350427898226},
{-0.4298051852331419,-0.9834395949996456,-0.03532771734400498},
{-0.3757039447094205,-0.9410895059781845,-0.03765899917617659},
{-0.35678479038533717,-0.922547948388817,-0.0277626396026507},
{-0.342451258027076,-0.8987689221464629,-0.02593363762353952},
{-0.3338470370805223,-0.8683894015877458,-0.03592910709698039},
{-0.3196419976350175,-0.8356605754483359,-0.013750988126249301},
{-0.31713335638039386,-0.8288258318960333,0.0066403829488477905},
{-0.3238736508158504,-0.8256859121694746,0.037336569029478225},
{-0.32428654605010193,-0.8043310870088896,0.044023398854231094},
{-0.33103332436043176,-0.8257666424142514,0.07740870484127164},
{-0.185283431485269,-0.3677553340297038,0.32382286931607457},
{-0.16845593928593058,-0.3874229121606444,0.3444429279222185},
{-0.17073447469507907,-0.3968052235897823,0.3411460246926237},
{-0.19184738003532556,-0.37043307661086106,0.31438337378648507},
{-0.1727362666806453,-0.39911756800271475,0.3337436706437108},
{-0.15890701893898462,-0.4046504019634032,0.35763275064884575},
{-0.16403488110287934,-0.3937815365898358,0.3599277087579437},
{-0.18139935351921593,-0.37003509439505894,0.3363883425945131},
{-0.2034782255394244,-0.3446464725099995,0.30851604497599144},
{-0.20817661571998547,-0.3515731323989258,0.29885871334874126},
{-0.19792255406042092,-0.3647269469375994,0.30006556506383336},
{-0.19332132957347992,-0.3786864490641677,0.3017089208395632},
{-0.17783787568511114,-0.40031978018289427,0.3258739931459578},
{-0.161853409396201,-0.4284203499310086,0.34614824969595925},
{-0.1787511564992953,-0.4036018713227818,0.3188612729122647},
{-0.17061053101257134,-0.440933989394734,0.3311822022230704},
{-0.14987111832566521,-0.48046043643269876,0.3710428806337031},
{0.08568787627466778,-0.4852081680192472,0.2546798752012279},
{0.09900903810457838,-0.5010971110970138,0.25183201775648495},
{0.10266068992649602,-0.47292861736788205,0.24723269816674984},
{0.09652824999554764,-0.48242164975190643,0.2626847122207542},
{0.11142783217334407,-0.46673453441089746,0.26067488630731783},
{0.1094405186814324,-0.4591260371246968,0.24393743635722365},
{0.11095475366138927,-0.4551588671813021,0.23794131078533956},
{0.10854414927479103,-0.5063845097299157,0.24581666260321355},
{0.10304849958750352,-0.5211907158227554,0.2526934328837217},
{0.08999651152551871,-0.48478392520716157,0.2688384300553504},
{0.1005650565213519,-0.4775826488350915,0.26736176500283},
{0.11524797762452714,-0.45149176370017463,0.2546346463758787},
{0.10347978403856346,-0.4056279287027616,0.247316469022683},
{0.09711750173927713,-0.4179120190227051,0.22497568691675573},
{0.10476526030615012,-0.4670315209529193,0.22438009259839184},
{0.11057933592509457,-0.5089774679180875,0.23120977059024944},
{0.11206913127575673,-0.510437921689813,0.2392346892422278},
{0.11137654443624599,-0.5342273234068539,0.2435929304386111},
{0.09481089114130314,-0.5195992767295481,0.24916157072976897},
{-0.043875924432311295,-0.7368363527442303,0.23546174869492323},
{-0.05083940418875915,-0.7477556336180826,0.2310397375320652},
{-0.06108789776898386,-0.7433091031453439,0.22482087178806276},
{0.3146578866848673,-0.38265556427626524,-0.22881636977334208},
{0.3055904144986148,-0.3629831235047716,-0.23931527818676568},
{0.29863058198818376,-0.3312279325049067,-0.2333367014671112},
{0.30125752341502066,-0.36152104743631813,-0.24074835583400556},
{0.2769443631461952,-0.35549977467153693,-0.23834141994158023},
{0.2582774116876575,-0.3505224939412065,-0.2297478166986943},
{0.24774415669209743,-0.3152751174695155,-0.22690802505405586},
{0.386701726896461,-0.5737878131783211,0.08399931239054108},
{0.38425276321342244,-0.5808898776593262,0.06743747420204911},
{0.37376850540371886,-0.5622281957435334,0.06619061645840885},
{-0.12368503401398738,0.9013128321532033,-0.17387620742056809},
{-0.09348483833217351,0.9099165867027277,-0.1716974820380823},
{-0.10278845933953269,0.8871225846116573,-0.18360703535780687},
{-0.12724883214675245,0.8777507294001997,-0.1845948770146067},
{-0.11959118468797042,0.8569902427919455,-0.19211202528995502},
{-0.09286486600416802,0.8565291801123384,-0.19333026495437813},
{-0.07230928705291687,0.8943027859999715,-0.17879760018797694},
{-0.055383946031735735,0.915365649807483,-0.16246771643455202},
{-0.05947582459126234,0.9327417545269471,-0.14910461818109993},
{-0.10665239086625715,0.9265160606879403,-0.15739527689895744},
{-0.14832835238393177,0.9241296303286841,-0.14860740495089236},
{-0.14857877252916965,0.8943616518919888,-0.17034083932083754},
{-0.14282807272340192,0.8547633499641041,-0.18722260781044753},
{-0.13671150941478782,0.829186497037458,-0.1923960217716662},
{-0.10771459469541196,0.8317010346554352,-0.19733054589962462},
{-0.08156618548954385,0.8106479981201797,-0.19777527618394636},
{-0.063868306129001,0.8464335818898912,-0.19147967166131474},
{-0.061487842252013716,0.8765173111153743,-0.18392284776624765},
{-0.04120944337395555,0.8951069554071037,-0.16931068727294657},
{-0.04088472267601568,0.9418202098851545,-0.1327988075262748},
{-0.06521982697818678,0.9577734700694187,-0.11926101543156961},
{-0.09031171623669126,0.948726464107246,-0.1347855536924151},
{-0.1279746011694383,0.9426328498697671,-0.13676792273837227},
{-0.15659165516305204,0.9467361716238312,-0.11945753431649343},
{-0.17329416995708224,0.9249112267570463,-0.13350046307886404},
{-0.1798597397414591,0.9028726391162325,-0.14800252943788755},
{-0.175380411677173,0.8741411351163141,-0.1665621840819152},
{-0.16041695754175195,0.8374874897960974,-0.1834633043298108},
{-0.15092452329332556,0.7934847648666733,-0.18688187237715784},
{-0.13316320331272952,0.7844229064432966,-0.19188693400934995},
{-0.1127586392574298,0.7988170682905419,-0.19721948072460735},
{-0.0818255521709621,0.7722249773968621,-0.19542414644904116},
{-0.042893879272530785,0.7505309360461578,-0.18650383049356886},
{-0.04851972384988867,0.7997657793428303,-0.19009289693372156},
{-0.02844696993985462,0.8172919990988294,-0.18160798969643333},
{-0.0247424877646967,0.8591259682806706,-0.17415775292745822},
{-0.03771490573123484,0.8741248229067771,-0.17640817171387657},
{0.2780672623336183,0.26966795382490283,-0.22218758778659145},
{0.27276030902253895,0.27394605228802904,-0.23276173592122232},
{0.282823991451922,0.2121450462102484,-0.224172591603921},
{0.2833118225587467,0.2215417043944723,-0.21684898322199317},
{0.2871015618983659,0.20873253707465014,-0.21052628623776168},
{-0.4014742153525887,0.1708930130319473,-0.14896038038457782},
{-0.43065350937132585,0.1077281706736306,-0.133793639826474},
{-0.4089479993282969,0.24760000548181182,-0.14317485697556617},
{-0.39026532423414967,0.3713676948235304,-0.15150201046415496},
{-0.4102265242615732,0.3577310339954834,-0.13155367725773598},
{-0.4234346862718418,0.22284369472908017,-0.13145916652123676},
{-0.4373142273368888,0.1094873947700932,-0.1285537201986661},
{-0.4476217440454867,0.02450020088245935,-0.12092181806837911},
{-0.41720331811271416,0.08655150492857963,-0.1398072324451862},
{-0.4064123059835702,0.08009293979656469,-0.14624446124112378},
{-0.43316970859512016,0.3806636006253627,-0.08695716197841179},
{-0.45011755778819484,0.34478237146760954,-0.051278651917569966},
{-0.4323677883053249,0.4451908205782905,-0.08005533480967046},
{-0.41636715110711664,0.4079926859426643,-0.11447394075894735},
{-0.4160089273788426,0.45112139240098437,-0.10929431596166293},
{-0.41221858034195513,0.5075299925201868,-0.09702293097673659},
{-0.4298076170846223,0.49375371536959756,-0.06391500904518874},
{-0.44301598095237504,0.43493303092971547,-0.053691505421505054},
{-0.45721698749782763,0.33846532861775047,-0.027924658918713142},
{-0.46521001160489833,0.2349707813602391,-0.0032471448285414876},
{-0.4557661793266224,0.23969419655679905,-0.036340943110643883},
{-0.43442051318378,0.27061719289387354,-0.08244451999238198},
{-0.41865830048421054,0.33122230918036055,-0.1120591621720579},
{-0.3953904496355221,0.4390986235928322,-0.14041609942433864},
{-0.39992468187309627,0.4970082465884482,-0.11829664023850921},
{-0.3975429537308134,0.5528050017994026,-0.09436540176660008},
{-0.41672363248657995,0.5263601893134013,-0.07667331252862968},
{-0.42115435751830754,0.5319703495642387,-0.047375779957332324},
{-0.43300366700308357,0.4949590074700225,-0.030836408506829185},
{-0.44289832884892677,0.45558607942322066,-0.033193637524979946},
{-0.4506093612378265,0.40696101465160284,-0.033520396983509976},
{-0.4603147583192825,0.3261526255306289,-0.0023893833217683495},
{-0.4669443923570979,0.1739734379210646,0.02378292793504177},
{-0.4672233434641125,0.16520990361114427,0.018611088462199686},
{-0.4607522950403129,0.1532443603373482,-0.009904078497480026},
{-0.44557534155591755,0.16592505386775458,-0.05328809323937858},
{-0.4326894163341256,0.12858458739522002,-0.08661266668387732},
{-0.42359562086952873,0.23643123513196457,-0.10367919107912268},
{-0.4220081934282173,0.242697781738545,-0.11259883878008156},
{-0.4196504576415405,0.28826252237683836,-0.12366915579804133},
{-0.4325217120738641,0.1634999603634237,-0.12155846701180109},
{-0.4471331023215019,0.05919161828400846,-0.11506194629831408},
{-0.4582206951528837,0.003971328738772621,-0.11119034099996754},
{-0.46876408339414943,-0.05322484597754706,-0.0966673005859303},
{-0.4365364215795979,-0.024716567670116835,-0.12198457434959584},
{-0.4108112575848806,-0.013829545747051695,-0.1427862377598064},
{-0.4074976363059647,0.04063101278498954,-0.15517006586268148},
{-0.41479423296928625,-0.02836567608773387,-0.15003047259173266},
{-0.4152287301415681,-0.07597195763745108,-0.1409027555081238},
{-0.4238251296418138,-0.1282441037525817,-0.144729679121144},
{-0.4322555268591119,-0.1887818633838226,-0.13853432021237783},
{-0.4438953900807144,-0.23492290820184725,-0.12764579923189073},
{-0.45600383357959795,-0.2652239667564649,-0.11465840237761897},
{-0.4676706065286567,-0.2853765797368704,-0.10894042791966742},
{-0.471179165829673,-0.2997786448358251,-0.10258791339779964},
{-0.4634898564932941,-0.3143767008030214,-0.09854697304320097},
{-0.45748446991251757,-0.33388622133662843,-0.0894128018321376},
{-0.45306359340120217,-0.3840743567880722,-0.07699976282648657},
{-0.4508647662005158,-0.41045006920760874,-0.08150031673643765},
{-0.43939815938239757,-0.4165528838967347,-0.0986486667189134},
{-0.43820810539721233,-0.42066725044240644,-0.10190288452745966},
{-0.43809685748805144,-0.40524745496769227,-0.13210756888227687},
{0.27483159629027576,-0.7519398694134746,0.12323237551137266},
{0.2807659162877285,-0.7223866269684461,0.12665998039956392},
{0.2782397070575346,-0.7192590279852769,0.1344370467459846},
{0.2675962569989548,-0.7199956580030191,0.13936184453042916},
{0.2763174405462871,-0.712546678062485,0.13987298911426838},
{0.27884342773324833,-0.7171522392981123,0.1194013733147643},
{0.269902218465756,-0.7742388266486805,0.11283471456238069},
{0.2655055170441902,-0.7552005615352239,0.12531962439406877},
{0.2618417771461939,-0.739574723751964,0.133169697280477},
{0.26006445811988643,-0.7289318410191554,0.14676299274647603},
{0.26482319306413815,-0.7071976778374516,0.1504227900490841},
{0.2707839585168337,-0.7020835749171229,0.14230037210743288},
{0.2648140138606473,-0.6914170238630909,0.1535231148989177},
{0.25846193386357436,-0.6896957340999441,0.15412278142642294},
{0.2610835866243259,-0.6602621293985635,0.15422339144616767},
{0.26716729178414717,-0.6323308022772217,0.15872750229747148},
{0.2669981904576135,-0.6257426297666561,0.17753601534725427},
{0.2766298075661954,-0.6329481196481064,0.1752539038734124},
{0.2805376654062921,-0.6265251366785126,0.18249111725211273},
{0.27788142277201533,-0.6162071233807376,0.18181404262905715},
{0.2850109844919965,-0.6093208286141998,0.16886484358523837},
{0.2881253511858741,-0.5972332168076833,0.16998419645538695},
{0.2858396933947577,-0.5894797922222907,0.16230449234803138},
{0.2848672130925037,-0.5812179895630002,0.15940352301197816},
{0.297715873297901,-0.5748781697520715,0.16107228945774232},
{0.3133272835830814,-0.5752588049731282,0.1575018247159604},
{0.3210346272920597,-0.571558793410041,0.15035870560989714},
{0.04285276302781974,0.2440979300556688,0.17659226892666888},
{0.05290357757379055,0.2540160976743404,0.17089638192711745},
{0.006554702414873517,0.23816095510109528,0.1865733958946551},
{0.05689755100386044,0.2361916356102862,0.1760621879859983},
{0.05422731645870676,0.22893167608034265,0.18477437400157537},
{-0.004014402469876343,0.226313590885022,0.19876673533934416},
{-0.034242697775895316,0.22868599746116727,0.20648837587024127},
{0.017539309682644274,0.24877579345490483,0.1825013514265605},
{0.005592545529323469,0.25509105358445616,0.18402009420286133},
{0.040469357343602595,0.27129076263355917,0.1744915285271751},
{0.07140542873361261,0.2636414125797847,0.16957713702724375},
{0.09685254254313949,0.24862843430423257,0.1679372468257949},
{0.10028337927589315,0.2434015036743276,0.17228954066324967},
{0.08844238844428076,0.23689762791156185,0.1725720285258686},
{0.10699623596721104,0.22608355622087017,0.17574021573706666},
{0.13816112131479746,0.21413535887941185,0.1843952282762703},
{0.05696375282181562,0.21805584024912428,0.18880925544442528},
{0.018119690321148053,0.22192931007317993,0.19207646225087438},
{-0.04578147183183002,0.21489038873804078,0.2147327922256974},
{-0.04875031521573362,0.23785132378130158,0.21226054481306295},
{-0.037767262250591085,0.23858844038182153,0.20500981548218525},
{-0.011453336282145328,0.2732225525684286,0.19839705248041578},
{0.008709891214704354,0.29061345025425944,0.18947931923833314},
{0.039496891915057945,0.3070794252611081,0.17940766343832504},
{0.06415594560709781,0.30335615121658127,0.17577587970488937},
{0.1006567104432461,0.2993221919437117,0.17653845797101866},
{0.12583939094850188,0.26258769420181993,0.17361987072622811},
{0.15966097470331625,0.23921994195939691,0.17117038965058534},
{0.16252542802048195,0.23269539705265943,0.1731985251002443},
{0.12978354063943792,0.2308100513376756,0.17419621421504847},
{0.1535181794834297,0.2164070141355733,0.17711815548129983},
{0.18091105601536206,0.21032673311612826,0.18214745382289466},
{0.14418790585130445,0.18676217832589592,0.21722293164828457},
{0.11225755461315728,0.1927311710646832,0.2143756011578161},
{-0.2650383147098406,-0.7736412870616138,0.143560923225355},
{-0.2687234121920706,-0.7805189901361804,0.1303941919325097},
{-0.2570892232905891,-0.7521765515633027,0.16567130519884338},
{-0.2558412967646905,-0.7771286098928869,0.1782533350406156},
{-0.2543594843463236,-0.7848805747299464,0.17812247083362406},
{-0.24499401208099725,-0.7949195954868021,0.1869131188533005},
{-0.231475429381931,-0.8063707623321967,0.2148027634665676},
{-0.2136651929584721,-0.8018092952703758,0.2176798201276006},
{-0.1887322027242878,-0.7953572947562277,0.23122669155946246},
{-0.1640580925887441,-0.7816840786002043,0.23683679019064674},
{-0.13799600295514894,-0.7665862351886733,0.2352787861336736},
{-0.12078594938939168,-0.759425811584177,0.2392718937013771},
{-0.07795146402556019,-0.7296412372750589,0.22641695147859064},
{-0.07686753183184553,-0.7495159923660879,0.23192524594365008},
{-0.2716732979709866,-0.7562990232181679,0.12197285174180424},
{-0.2740310953773165,-0.7255365970729012,0.12009521698271593},
{-0.2831510505094548,-0.7421059188620169,0.11942606473471032},
{-0.2668269218191446,-0.7991338219923039,0.14072163834924264},
{-0.07630371731834573,0.7325099147256827,0.1837623583174337},
{-0.0713810921578756,0.7241451721863169,0.1821971606971692},
{-0.06053909507785981,0.7366926918351497,0.18622013679808397},
{-0.05694460929546093,0.7224524941279405,0.18555761185000622},
{-0.04671657025283021,0.7089925350919104,0.1886742680327175},
{-0.05570861785891628,0.6914994274001708,0.19350913512073803},
{-0.08028655565214374,0.7298479786479445,0.18768018579243317},
{-0.08110212363268493,0.7298060326627327,0.1981701986652515},
{-0.08318747399262197,0.7459649707496633,0.20483516201242902},
{-0.08913189536354602,0.7508933754086276,0.20736864554890788},
{-0.089940432329191,0.7646251939795311,0.21716994193387265},
{-0.07552470997782008,0.7786080000214435,0.2121774836455478},
{-0.072493069792997,0.7930574825058392,0.2083212577626799},
{-0.06771972886615332,0.8117836440765249,0.1975890222832968},
{-0.06110350560214191,0.811469432716656,0.19607687493468948},
{-0.05490880007417987,0.8115324334998751,0.20601373561880365},
{-0.035334249558433686,0.8153194371393799,0.21645460894311871},
{-0.03616936265548227,0.8036087325649097,0.21488783046003077},
{-0.03373688860408513,-0.703026410854214,-0.3303563501349143},
{-0.028645914301811907,-0.6784509346598857,-0.337613350859103},
{-0.018093243803497493,-0.6616363400913784,-0.3448151934945366},
{-0.052258087272561655,-0.6583378761847084,-0.3466505284866119},
{-0.017986651365366462,0.6724243626049408,0.20631437046925},
{0.0015831151280047413,0.6572564066523008,0.206388586029327},
{0.00795550942484045,0.6716576611340953,0.2050358646593143},
{0.01915994905454954,0.6532032369213845,0.2008974653865397},
{0.01303731089806954,0.6389278618291301,0.19816235597078732},
{-0.21242452055311017,-0.41431737919117356,-0.27951341025295856},
{-0.19718241809690076,-0.4774237806205978,-0.3018495719473139},
{-0.17805827537282082,-0.4997376519366609,-0.2965007735797647},
{-0.1377328062935704,-0.5511195693623003,-0.3105560028997763},
{-0.10648783770756436,-0.565824942329755,-0.31671879794671354},
{-0.0764569823940417,-0.5709635231260595,-0.3257312140353608},
{-0.07140207577455955,-0.5568232671840816,-0.335363499398456},
{-0.0495541106553161,-0.5563103494416051,-0.3400328104148097},
{0.0011611618047527967,-0.5533284873123798,-0.3396005018026195},
{0.014101488680938,-0.5570797260553199,-0.3386953579698633},
{0.029625320440588906,-0.5550124918733838,-0.3332550894769713},
{0.027481307108526806,-0.56930723997208,-0.3230529041284323},
{0.028483261790693954,-0.599698593629001,-0.31475750388451224},
{0.05195528086054865,-0.5932816090139107,-0.30665736569707513},
{0.07497159816061279,-0.5688178280024319,-0.30567298961455625},
{0.0696887487579596,-0.5815585836960511,-0.3039565221204656},
{0.046323671658405875,-0.6077379812129636,-0.304921161853071},
{0.05265457043094184,-0.6075560927460113,-0.31511909119591736},
{0.06604410776518982,-0.5989948716932184,-0.3192587058632283},
{0.042997050757508995,-0.6245261515743844,-0.32665872898940285},
{0.030855750172240615,-0.637631169722278,-0.3342301036218556},
{0.012459108195579178,-0.6574783670170855,-0.33924361564578004},
{-0.017862541947240188,-0.6511416260639944,-0.3445873877619733},
{-0.07809850339148117,-0.6371402990667047,-0.34343992889317265},
{-0.11922875594957863,-0.6044283322768548,-0.33059611114258},
{-0.13123768370876332,-0.5833364498623812,-0.31107876916266497},
{-0.14441072782882428,-0.5648785409520488,-0.30660775975154264},
{-0.16943847209089655,-0.5267968240501999,-0.30498535678267036},
{0.32216794232566637,-0.5472710639969983,-0.06317866162792424},
{0.3379982011831516,-0.5652377782173751,-0.061055216511091866},
{0.32627667492271395,-0.5706571342749064,-0.030825121486240285},
{0.32217171174858145,-0.5699324999037632,-0.031207540490012415},
{0.3285942888783912,-0.6023623952948564,0.023436249392454783},
{0.3438860971464673,-0.6053802454262868,0.0027669694324061614},
{0.33813336070492495,-0.5835695655091863,-0.03257137677054852},
{0.3627096878879102,-0.5979750345627688,-0.04346940098890907},
{0.37416129988217767,-0.5920388702253555,-0.06120757960255599},
{0.3608314337450678,-0.5642835957648578,-0.08042110694544491},
{0.34006863639982376,-0.547594150711724,-0.08028714263245956},
{0.3204584463516345,-0.5315181314296619,-0.07732740939553916},
{0.3149678016675467,-0.5550170315419621,-0.07293286466183065},
{0.3147792264058291,-0.5837945749843899,-0.05792996757400153},
{0.3224369237977783,-0.6037931823908547,0.000923077807817449},
{0.3253696665642486,-0.614621033510861,0.047561501591668304},
{0.3258697366090613,-0.6171228859795693,0.06370573701689619},
{0.34334837643122457,-0.6206693785514936,0.043197522330695334},
{0.3676762287376745,-0.6261399617888777,0.022075218930948742},
{-0.4490503032723044,-0.2830288943280899,-0.028005319044574387},
{-0.4379518898173629,-0.27829721147394126,-0.0024541009560109153},
{-0.4361889377318898,-0.2804344774539929,-0.020551039813876702},
{-0.43840920325980354,-0.26962721367255704,0.017904648887235457},
{-0.45059323070002516,-0.27836011026601065,-0.0006759447523481465},
{-0.4579530512522065,-0.2900135903685325,-0.0125142360057116},
{-0.4368754752213221,-0.27340276880548564,-0.05664530192357503},
{0.42639668774943973,-0.12981284769012086,-0.055253765484170894},
{0.43308614065907897,-0.1277662837145644,-0.036531757928028},
{0.4292686384785308,-0.13702644374317258,-0.04729991129070072},
{0.42014647460055243,-0.1348729675447338,-0.0715083085876465},
{0.4435692223833355,-0.13919880636527557,-0.051655660078358354},
{0.436908828452155,-0.13691864016013647,-0.03239817136263926},
{0.44325622748041066,-0.1287208709444579,-0.008927246572830312},
{0.4413704769880505,-0.11727075907002028,-0.00935268990574292},
{0.4251368048860309,-0.12081538711623543,-0.019672927885475155},
{0.41956174233965293,-0.127805757476799,-0.04729421784723914},
{0.4112932114516923,-0.12660370784501465,-0.0652400196322552},
{0.4143750142837412,-0.12295249054789185,-0.07926227925065397},
{0.4102932328480545,-0.12361892728153141,-0.09462681464546317},
{0.4332004281169885,-0.1377633988577052,-0.07426329671595898},
{0.45641656626545435,-0.13876005424970886,-0.02733081757323811},
{0.4538592720451052,-0.12865918860933262,-0.011408470269063746},
{0.45730391901699985,-0.10681438415332825,0.016679571566137825},
{0.44745395904223156,-0.11493223267898237,0.009068186655505671},
{0.4478157896450256,-0.09689483859172514,0.018699439358208062},
{0.43078441288740643,-0.11609407973677345,-0.003949580188464341},
{0.42647547378792144,-0.10423682556638338,-0.013740937748352944},
{0.4131148073859498,-0.10917836158589736,-0.049241317078671604},
{0.40179831454195897,-0.11708895134606166,-0.08724558657588109},
{-0.021028724394898037,0.829039300435181,0.21624429044313195},
{-0.026627479697879358,0.8430672545594491,0.1953867199466592},
{-0.03889666549863605,0.8385263758986063,0.1954587373849743},
{-0.03590322206185813,0.8523614796321237,0.1829816851214597},
{-0.022664164170024634,0.8502450240962829,0.1792041942814987},
{-0.005046263931935918,0.8409414381483816,0.16175486629085348},
{0.024461131366397156,0.8441822919290675,0.15304980265724438},
{0.0421507834408481,0.8356301491510235,0.15072341427545233},
{0.07019142276431814,0.8368156432818821,0.1441065673780556},
{0.07903818185255657,0.8326427348785758,0.1451791828037626},
{0.0901906793019558,0.8247628242687828,0.1416994083799899},
{0.33891258583905187,-0.9978773240664233,0.13565475095687074},
{0.3416129832043806,-0.9910279904676459,0.13737212999686363},
{0.34833291234449926,-0.9831024048212229,0.13127470596497295},
{0.3335766766030712,-0.9813221068034121,0.14491791122513845},
{0.3379064059610186,-0.9826115341656496,0.15388858212365028},
{0.3260421016523917,-0.9668005665092047,0.15247886894899992},
{0.3208325158924164,-0.9669310652479092,0.13857729992039022},
{0.32996704088528095,-0.9646730279350748,0.1299700298634177},
{0.3426610283246322,-0.9803815412318142,0.1399248643628861},
{0.07647184972895534,-0.949433013110215,0.21406620356774084},
{0.09893123585572985,-0.9277546157145343,0.19726125459975372},
{0.0953855029053908,-0.9186358961626807,0.1935734819746544},
{0.16675969472453103,0.09716950394562825,0.32608194035170945},
{0.14977883545834667,0.09478372271754465,0.3153939499080422},
{0.13903136080131612,0.08897465316420776,0.3081197456141626},
{0.11516031729359615,0.09980047827251746,0.3126804626160685},
{0.11529084577971933,0.10916665916385411,0.3091702417092352},
{-0.1818449751636915,0.01261036266449197,-0.2698885415587952},
{-0.10618292879049247,0.02975436633661108,-0.2968372753179257},
{-0.05340098203740416,0.004652192970491652,-0.31757624179355104},
{-0.013189096039684144,0.00816918247749185,-0.3148726019595818},
{0.03661507247980619,0.01464444547307948,-0.3014059561287863},
{0.05777078541799965,0.02973507513557066,-0.3148638073477186},
{0.02086833056278721,0.06570319544099941,-0.32860219159889664},
{0.01264674110156796,0.09283029047314811,-0.33113411552070837},
{-0.015071095170062,0.10397830987362208,-0.3316701342586371},
{-0.04194383808566254,0.16866691063551753,-0.3154615902261741},
{0.003758895516037138,0.20186431811461644,-0.30428220217265917},
{0.005876436832661265,0.2635011067545727,-0.2996115535848708},
{0.011717358434593463,0.3670998092866956,-0.3037492240458867},
{-0.010866102050849766,0.41586988210049886,-0.3089941083053976},
{-0.031988054856018584,0.4243969786143878,-0.3107601413735238},
{-0.06041546268084089,0.4361270561953,-0.3106304118180749},
{-0.08774591106736451,0.4501694378176477,-0.3168083642372583},
{-0.10883184506050157,0.46243719574230574,-0.31748627072563024},
{-0.12541156144764465,0.4671539645155971,-0.29782371778363786},
{-0.2676568673645982,-0.6585374346183809,-0.34154137107464555},
{-0.258424142955313,-0.6520739239780035,-0.33178628624225565},
{-0.2582351225447225,-0.631724184415406,-0.31619108830027814},
{-0.269075435708357,-0.6127784847697458,-0.3091960571566457},
{-0.2734170810323176,-0.5789372560320899,-0.2996589709703116},
{-0.3199404832344613,-0.49881540546295594,-0.2245765912975672},
{-0.35441980047812377,0.2983777358347083,0.11043704924051814},
{-0.3692689257217307,0.3106170839120802,0.10194405070533788},
{-0.3569350265363628,0.25948903202021134,0.1135474892751246},
{-0.3392566667945398,0.24419146868902059,0.12360941873161885},
{-0.3613221036055646,0.2630413603982438,0.11480035068530739},
{-0.37816932259314606,0.3246295151958152,0.10546651586219828},
{-0.3783671779870967,0.3879002158684653,0.084515512973155},
{-0.3702448312267689,0.3794185914713144,0.08816508885020907},
{-0.3611141967713098,0.38816348371136716,0.09313802751981407},
{-0.3323755183314407,0.3513787319551779,0.11109763423193218},
{-0.31754645453453734,0.2852929809910026,0.12319828603192652},
{0.29755331746589375,-0.9578089417414276,0.1732379276811555},
{0.3048519401409118,-0.9526444233208143,0.1684985540568598},
{0.2785964317283867,-0.9537970295554613,0.1645740599728434},
{0.2887109758693354,-0.9484535411021539,0.15407104854045195},
{0.3118928269305023,-0.9476329373085863,0.1602312704356699},
{0.316852863719645,-0.9519116838404775,0.15891964406221212},
{0.3199292758944583,-0.9687212521576287,0.17212016523550072},
{0.3078813407700684,-0.9706101654380435,0.18055604447710594},
{0.3029134219773725,-0.9585796155550803,0.19098201328223416},
{0.299323604414897,-0.949637272698453,0.18676262028754545},
{0.29460876072456005,-0.9456172543408853,0.18175538921860232},
{0.30985207857530567,-0.9670716154269178,0.20005359911153256},
{0.3160723010140833,-0.9718567947640044,0.20983656683693408},
{0.31319601353630583,-0.9798575999458861,0.21251385258273245},
{0.3193401261418787,-0.9756177598504583,0.19900064991682337},
{0.31613828078880585,-0.9787695137376287,0.1839981076732033},
{0.020695206960279426,-0.9793320374256376,-0.2678963239924259},
{0.00949904030019814,-0.9860207200896137,-0.2506842337908941},
{0.006126679555794718,-0.9716392423292293,-0.25493627245281314},
{0.016582714501987037,-0.9617663853413083,-0.2643468322432499},
{0.01620409041891749,-0.946984170541667,-0.25887057468574487},
{0.006129511935020031,-0.9399774284767289,-0.2527558854645103},
{-0.003904631307573373,-0.9539377412204573,-0.26458922802228796},
{-0.010130218905798825,-0.9726034762220509,-0.27990839222910113},
{-0.004291761027581452,-0.98076995859009,-0.2695327486195938},
{0.01944636782607081,-0.9937759273953136,-0.25631595560826487},
{0.037979992416310025,-0.996283939704513,-0.27152466233732897},
{0.05410976103436935,-0.9937566361942733,-0.2827352968669867},
{-0.0035656573464350203,-0.904716758096093,-0.24707913880409},
{-0.00827426045328761,-0.9268069171368902,-0.2535775229808783},
{-0.0121259668533256,-0.9414973770858958,-0.2610891392987524},
{-0.034024150927408736,-0.9535720200802579,-0.27376782700321073},
{-0.03593727754425432,-0.9746288855332655,-0.29619207505402934},
{-0.022811306589503307,-0.9834310033076745,-0.30097409372787687},
{-0.03508063369049881,-0.9932297764740872,-0.31832308473758486},
{-0.04465068107918329,-0.9995313389797252,-0.31881654979303375},
{-0.06860188431868539,-0.9988277785299301,-0.3364079780156844},
{-0.12468922718941329,-0.9969571843474083,-0.3352234761737219},
{-0.15713561646177931,-0.9989151562603833,-0.33305459931164827},
{-0.21327106197098653,-0.9983020545236942,-0.33278634665129503},
{-0.24199308185637206,-0.9986987384771507,-0.31817406504350343},
{-0.38511320729991944,-0.9901409213789859,-0.09492913128747506},
{-0.40106245476987984,-0.9996772383820646,-0.07736237429902193},
{-0.4295752716834806,-0.9991489199759531,-0.056025766245179985},
{-0.18262819282637394,-0.29556603956464383,0.2639063983361177},
{-0.19038368379495965,-0.31276289058852813,0.2645915791307747},
{-0.29003888470491146,0.6129442936944717,0.04295180121520744},
{-0.2805514448356066,0.5566978435674925,0.0785951721376854},
{-0.27790018808118894,0.5782524704531387,0.07639525384417671},
{-0.28957636333937914,0.6283526597859502,0.033452006605463186},
{-0.2698390774447056,0.5865952073395059,0.07745269808633617},
{-0.27333021007039054,0.5657759547055689,0.08777865182009402},
{-0.27079340225986964,0.5463048550880554,0.09302598386720246},
{-0.26837473313557464,0.5205706128185891,0.09864640803990625},
{-0.3065173430035449,0.534382959776785,0.0837970543786198},
{-0.3214733199127889,0.5715107778890022,0.05776895010850527},
{-0.2899398353622417,0.5940710576984074,0.049907121679663304},
{-0.2975120407976031,0.6183901547020831,0.023373137056415322},
{-0.2539494257409287,0.628146738591895,0.05007492155662787},
{-0.2602342085775929,0.6018378558733303,0.07159838695875627},
{-0.26764525524721905,0.6127088280015878,0.0847412926940219},
{-0.2770953291713872,0.5814407796682856,0.09190952818315574},
{-0.27751089954850794,0.5671161226648813,0.10562645817098934},
{-0.26993389202983886,0.5555745799741899,0.09496621463213387},
{-0.2625503234758481,0.5456046178498943,0.09954169379057995},
{-0.2572239780349862,0.5120725338492544,0.10869230894974906},
{-0.2549027168332922,0.48991850391324027,0.11077694962126805},
{-0.26035830418441763,0.4595312830227058,0.12007923836923165},
{-0.2873353670478406,0.5148929333641104,0.09723008350144526},
{-0.28853255403907185,0.46558068197188746,0.11315568814796952},
{-0.3116981736336953,0.45817239118812414,0.10606123369411775},
{-0.3405409064194339,0.5072993501587669,0.07974445303588261},
{-0.3506919463935217,0.5413533898051354,0.06290703582276963},
{-0.3535121631742341,0.5622052264866496,0.04944806376359628},
{-0.32734964519262993,0.5975590285984452,0.03418308023035162},
{-0.3188993278288671,0.6205698128786274,0.01197327388423608},
{-0.2929227312142675,0.48682964881813906,-0.21931215129747095},
{-0.2812380237589435,0.502395261889791,-0.2234060516190628},
{-0.2782986356316125,0.5579592265507309,-0.20548819328430362},
{-0.313612071558612,0.5328004364099314,-0.1875417221823663},
{-0.3250917289942861,0.4747539104813233,-0.19536580644889076},
{0.36072881789937494,-0.9737585143081783,-0.009150903602889915},
{0.37061808908798294,-0.9765038568359706,-0.024068190806864204},
{0.3599869194012956,-0.9645089719832378,-0.030051574921865533},
{0.3431276229617136,-0.9572554963281675,-0.010164778500701624},
{0.33551008777226093,-0.9470490146024391,-0.014901471670089081},
{0.3410773703062358,-0.9392232899782537,-0.027292904488078546},
{0.3555567616953395,-0.932428587513957,-0.04557002983558264},
{0.37550195442426776,-0.9642444069403981,-0.04123202219596849},
{0.38713654810312526,-0.9783661833609035,-0.036077498908045305},
{0.3851402381418663,-0.9845385422029598,-0.02293953655632638},
{0.3255492846657078,-0.9383598892108173,0.004622635722769217},
{0.3174351248199751,-0.9269897777069901,0.005401194727198413},
{0.32706226281722367,-0.9282425679358494,-0.013478156488228709},
{0.3312664378824211,-0.9093433943154763,-0.022880407187172064},
{0.3487721096089391,-0.9229256662380235,-0.044974577879865446},
{0.38472807171937357,-0.9726110958108745,-0.04891458418033686},
{0.38589551129188393,-0.985735729194191,-0.0319159327705341},
{0.3791968589930052,-0.9941473228556342,-0.021827386811139507},
{0.37942211175959767,-0.9893303690257227,-0.039244597151236654},
{0.36490304368836746,-0.981920619556034,-0.05333705111614603},
{0.3922662131730762,-0.9655341583370182,-0.09587744712405752},
{0.2076418516856821,0.11214292771595201,-0.24130137628414106},
{0.22139083451718725,0.0018664853203109464,-0.22634398106046869},
{0.23866559934274015,-0.10005623807941588,-0.23114549385524866},
{0.26042922734268686,-0.15418706347346284,-0.23598177819528968},
{0.2763556787282369,-0.1745826799301745,-0.23460323075378836},
{0.267291590310864,-0.07690482287723155,-0.22738456914029162},
{0.30628349748257344,-0.06634177902904607,-0.20245942053816365},
{0.35402570879972717,0.08114422632304895,0.2711978678193412},
{0.3598432893020418,0.07170679717665271,0.2679358391885651},
{0.3468252026733204,0.08030806037985923,0.2606959400429174},
{0.3544414810343321,0.09250736630681747,0.2627872675092017},
{0.3384362648584565,0.08366828842705584,0.25513419052882463},
{0.3359097709029692,0.07060525663587101,0.2535037228222556},
{0.3430031215151049,0.07292489660324471,0.25344473475334023},
{0.35491723575156403,0.06805525690755523,0.2590480658467655},
{0.36103273452755097,0.055309800059370404,0.26637380223153967},
{0.3605925640975559,0.06560122766407162,0.28064676565806207},
{0.3604972427438966,0.07295091497054725,0.2763764695179032},
{0.35308814134297334,0.07997492328723707,0.28153608492646665},
{0.3609581237517681,0.09832729791761867,0.2772692331124325},
{0.3572112621290114,0.10652425651613713,0.2637622614683376},
{0.34355847182557087,0.10982490898289861,0.2528705394531146},
{0.34178003833346937,0.09487807196805653,0.2505684472755627},
{0.3328436927689378,0.08601548725305866,0.25543261557102315},
{0.3287341091832333,0.0787284543848558,0.2610567985425639},
{0.33307145813000427,0.04220153944283631,0.2588980326156319},
{0.3426966922924548,0.044608233106280565,0.2554566482981261},
{0.35198279100777974,0.04348180778733119,0.25676072626408347},
{0.35601666953765554,0.04514741250744848,0.26560237835797224},
{0.35390351702770056,0.04514011801541502,0.27944025816310086},
{0.35766569857109864,0.05476413572092138,0.2833538094466593},
{0.34982323464943604,0.06685596316163378,0.28931374409644617},
{-0.4385603722048876,-0.7068698899681601,0.010216993719818972},
{-0.4461933888009687,-0.7132469949812317,0.009381622457672243},
{-0.44625114022719164,-0.7304673528403524,0.0032052424020498887},
{-0.4265742001586165,-0.7073656243266943,0.02534881293316029},
{-0.44301508852981347,-0.7585291776379907,0.017694070097334858},
{-0.452384836986581,-0.7507794821040165,0.004182022268716853},
{-0.45133561684329,-0.7333848564291753,0.006000106945157517},
{-0.45171799441315746,-0.7205974121618739,0.03265347220936302},
{-0.43500240987823086,-0.6896761188645211,0.026190490648075816},
{-0.4368528204371506,-0.6963453477790617,0.012628874058198772},
{-0.4230857023043039,-0.6758347947332678,0.02380418246571773},
{-0.40541338128848126,-0.6965087545997258,0.048729013407910075},
{-0.4010853124739433,-0.7137281392932912,0.06060678798517842},
{-0.422347328875343,-0.7651846271232166,0.05701594094953374},
{-0.44428972398809197,-0.7822937763822653,0.029587797790300005},
{-0.44877248681683246,-0.7883939966715158,0.019901564420947027},
{-0.4533662946348418,-0.7770112414523244,0.010150872644857478},
{-0.4539856380174229,-0.7613644912337038,0.006346433830758915},
{-0.4609444368050535,-0.7785117373744636,0.038391752467814906},
{-0.4569514917857451,-0.751740149493815,0.023360603831463593},
{-0.4636051171167588,-0.7521648788886782,0.04482793904168942},
{-0.46293738318318145,-0.7224926467687668,0.060013314232806154},
{-0.44039603123134535,-0.6770434907883206,0.05768607379994932},
{-0.4212985549433328,-0.6504285018190804,0.04605793106132283},
{-0.42372259453911476,-0.6697468941249991,0.025734067503381194},
{-0.4165915528850521,-0.6511928532438471,0.030807375026157734},
{-0.40816107386235245,-0.6415973665001173,0.03904702010813261},
{-0.41110147552673565,-0.6356261862636462,0.04139985288275958},
{-0.39443432085189417,-0.5840511953416154,0.06283470922378143},
{-0.38952387088494334,-0.5589757712793729,0.07726897059146226},
{-0.3943118464793897,-0.5548549208588279,0.09261907105133722},
{-0.3779983365551549,-0.5091672989458382,0.09981270764883515},
{-0.38793542990657987,-0.5134077881724389,0.11196917091838864},
{-0.3964658092606061,-0.4939911571410109,0.1309541116589728},
{-0.39102744566492004,-0.424352023890254,0.15437215828719003},
{-0.38914469434981175,-0.37236365115119413,0.16937149949607422},
{-0.37856264296347153,-0.3743801447360552,0.16280052949279172},
{-0.3696787814072337,-0.38048911926567197,0.15666872806893797},
{-0.36979602767089803,-0.37834180290772407,0.17788018660740623},
{-0.358508897654,-0.34988977696909473,0.19874840667978097},
{-0.3621449767022174,-0.34471974677675554,0.2125932059469856},
{-0.3670779603388492,-0.32816696030281717,0.22093299465167598},
{-0.37493805385573503,-0.31806925532568003,0.22961918248569896},
{-0.37642010850308294,-0.3209947025377092,0.2421555978480864},
{-0.36879767030158045,-0.3260316406538762,0.246934860636071},
{-0.3744859674597268,-0.31107580610727886,0.25607663974947226},
{-0.35846417453476903,-0.2964771010089098,0.2606327575879624},
{-0.34088484394986734,-0.29718049891030984,0.2514096596558568},
{-0.34012063488774746,-0.3077828539723348,0.23782347701015552},
{-0.3252625939177867,-0.2805257457218515,0.2493512200857839},
{-0.30591360320449046,-0.29334982606012305,0.2664305209973698},
{-0.4532083177805019,-0.4256816548888925,-0.13208953344726962},
{-0.44920418666934675,-0.4366776139841286,-0.11168764559724695},
{-0.4423570820021578,-0.41613155845649935,-0.13555047244295304},
{-0.43720873449084263,-0.3963540699878325,-0.15395954565341638},
{-0.4452593071042441,-0.42182504441439683,-0.11116325810003792},
{-0.44535782949263936,-0.43268580361636283,-0.112002352039156},
{-0.45185449150636536,-0.4472681348855417,-0.0862730149065553},
{-0.460960121131574,-0.4430386702648004,-0.1040727855506635},
{-0.46883188626067657,-0.4505828100730066,-0.0997631463244308},
{-0.453894450492558,-0.43086173545912804,-0.14162921403347928},
{-0.45784119458336964,-0.031436050598954775,-0.07620641404291412},
{-0.46505211549355213,-0.06224564977586582,-0.05607767230362422},
{-0.4539052307446208,-0.04426677736049476,-0.05780913462156574},
{-0.4464096440358059,-0.01664978377592032,-0.06340547507159167},
{-0.45023131935423755,-0.05284258845976227,-0.028515046376393127},
{-0.4621101329663455,-0.07472946107787684,-0.031362721086992534},
{-0.47930074340674533,-0.07428122484777731,-0.05280281616093266},
{-0.4724721596949335,-0.048859451589369274,-0.07711012043790141},
{-0.46208670793651074,-0.007307756726177039,-0.09964775396239749},
{-0.44909087131458475,0.006169872276573263,-0.0909065195924396},
{-0.43672203803556053,0.0699167728153282,-0.10092148743644412},
{-0.4404600243034605,0.028391259930241476,-0.07091739523809983},
{-0.44746895492849015,-0.008908355899534832,-0.036399070629232005},
{-0.4490645289128998,-0.07063714161910845,0.009397967601851473},
{-0.45676794171297574,-0.08339637789660784,0.00011738384547589384},
{-0.46284854676680326,-0.0963686280027117,0.023570170146719877},
{-0.4790585909190961,-0.09141931090838658,-0.02152992962245721},
{-0.48702648695661027,-0.08798272867418859,-0.0467152799585432},
{-0.4785503328972806,-0.05652963121069511,-0.07853043113047099},
{-0.42978471900906196,0.15357425496132981,-0.11280635039863049},
{-0.4318740810208951,0.10789068719654878,-0.09911060057292603},
{-0.44683413013928047,0.05557177070233448,-0.042248455371790186},
{-0.4613700989939753,0.09972128639425162,0.00691049801009449},
{-0.2538787862455451,-0.808742277548188,-0.331415336993216},
{-0.26434624526293404,-0.7811774832466137,-0.31733939815773565},
{-0.2535933289530932,-0.7919568630726301,-0.34014008704357135},
{-0.2461291512688162,-0.7698235830235814,-0.34918334376857735},
{-0.2538798805255909,-0.75175927814646,-0.34084616008784063},
{-0.2662963542956963,-0.7554022267235864,-0.3192000227053548},
{-0.27713348554793554,-0.750722905700833,-0.28801424510815615},
{-0.2621895053476985,-0.7975029898798555,-0.3087727057047138},
{-0.24235702027626393,-0.8273871001144208,-0.33191816398629936},
{-0.23352823606578754,-0.8356683565231471,-0.32807695417543853},
{-0.21110400820071737,-0.8495618799374006,-0.34767125803962307},
{-0.19864572974563902,-0.8474372597975287,-0.3529970765262105},
{0.2501953896782213,-0.7363295948422448,0.14954853784826155},
{0.25684561105460696,-0.7122743319448342,0.1529339130883553},
{0.25200247630899775,-0.7041347603666592,0.14923754983369256},
{-0.34358917222409846,-0.2580760253813455,0.2645895116851736},
{-0.35421505430710803,-0.2772752665263938,0.2598339777756578},
{-0.3750762932977537,-0.2955366979857071,0.25422367622458153},
{-0.36378634577533975,-0.277772459570853,0.25304954985730566},
{-0.37910441676451495,-0.29467426932141827,0.24318682399027478},
{-0.3789901686156946,-0.3034356968766484,0.23866985587963674},
{-0.3623718708888785,-0.3373138878444727,0.20634644774830124},
{-0.2988649544634296,-0.4266325948727693,0.24079159901915514},
{-0.29302761636304553,-0.47862404753207455,0.23644180821450417},
{-0.30548761698118626,-0.4091677748514174,0.24129714152660456},
{-0.30883609161076475,-0.4524234135454189,0.2238680672784769},
{-0.3049845679448703,-0.5116913610498451,0.21009515264861092},
{-0.30640816147757727,-0.5576772656423865,0.19100462769490878},
{-0.3059067134898332,-0.5791355172658245,0.18385510545696587},
{-0.31608480449161624,-0.5805458785092398,0.17924747783814515},
{0.03276558013764724,0.6468803572030094,0.18932825228439895},
{-0.19586507809423306,-0.9455563008175188,0.3080884577041153},
{-0.21464421875525247,-0.9440313270194037,0.2994700929223678},
{-0.2004002123160391,-0.9524293027375197,0.31026173187212047},
{-0.19026852410023695,-0.9414915402173796,0.31530689727437944},
{-0.20932707376603776,-0.9559548828740833,0.32852012378268525},
{-0.20923359675233913,-0.9508913601272502,0.31780035990860084},
{-0.21831740133387711,-0.9471038082853147,0.32380550319798856},
{-0.2188394579083478,-0.9448328010979182,0.3043707559885595},
{-0.22983329006314532,-0.9462488377238623,0.3022939165776},
{-0.2272883165861855,-0.9487881368807011,0.29270973810261536},
{-0.20025949958863543,-0.9391986484914747,0.3027586477513802},
{-0.19111104324213918,-0.9250060307181016,0.29513104093587494},
{-0.17813671719117177,-0.9359773493889664,0.31234104350605724},
{-0.17677851379685192,-0.9356359446387555,0.3229452227222944},
{-0.18992967231599697,-0.935155449457869,0.32706947709746736},
{-0.2002498136166184,-0.9413133808018456,0.3270415538329589},
{-0.22630284622362087,-0.9592872280282682,0.3335238287201021},
{-0.038466174666211196,0.9874908693950263,0.07890829877917885},
{-0.03796822943702147,0.9773350687715353,0.10326983153806767},
{-0.06639904440369519,0.9908289589882479,0.087433359719701},
{-0.0969284005856929,0.9979430902971755,0.05232594804031439},
{-0.06641288014062374,0.999926088288557,0.03709229385102172},
{-0.08363672269736586,1.0,0.0021771301771568836},
{-0.05029307584542801,0.9963781253442217,-0.012895794459156451},
{-0.019796335583241998,0.9854200495867266,-0.029428067963071257},
{-0.016471655701416572,0.9749414246632392,-0.059843723136271496},
{-0.03131056270669305,0.969653205851507,-0.08562690203434889},
{-0.03515817246221003,0.9566317460779842,-0.11039310167898954},
{-0.23140175033779875,0.6921578387052025,0.07484336394415848},
{-0.2457031852312603,0.6908682902284746,0.06196767608403772},
{-0.2363748972393348,0.6844885504440303,0.07879896320407861},
{-0.22845522920442163,0.6952105432497032,0.08343704261799904},
{-0.2166734984181244,0.6606687532395038,0.10382937623457332},
{-0.2356517831737698,0.6621767465735684,0.09010802875505969},
{-0.251213748999405,0.6849110105358085,0.0567565817049702},
{-0.2534450189474297,0.7099155921827754,0.046198093461480225},
{-0.24419239563983605,0.6977758214647555,0.05121993051301523},
{-0.23693349001844138,0.693161262697373,0.059280745800127016},
{-0.22665584184305473,0.7019065607772097,0.06276855733899339},
{-0.23446183011732669,0.709629467698218,0.07434470690173511},
{-0.22738365812559325,0.7145200591383573,0.08526338007831909},
{-0.2136637544582954,0.6732999630012761,0.1056275577630742},
{-0.2001126684546455,0.6529855230006222,0.11702965517888092},
{-0.19556433169096646,0.6420858562997849,0.11808148884538809},
{-0.2131727818115723,0.6401949180700816,0.12209683154617755},
{-0.23633785532858068,0.6365028501302006,0.11991728492245352},
{-0.23560629087128332,0.6485986084798153,0.10357915900922733},
{-0.24159114960832698,0.6536385043393297,0.08151417797115368},
{-0.2540943923492095,0.6757943169956514,0.04692105135309695},
{-0.2571578367742763,0.7073642155739361,0.03966655259930423},
{-0.2521228853607167,0.7275772147519367,0.038102343018304376},
{-0.24586912589455487,0.7229081470269717,0.047993681652513345},
{-0.24316862653807625,0.7135551368052738,0.04695425053479709},
{-0.2320634859168726,0.708423121689244,0.05268130326749753},
{-0.2290572266546652,0.7160663915831135,0.05862502769889725},
{-0.23334221377004088,0.719352778037783,0.06659177421115942},
{-0.2291518786914033,0.743988518252808,0.07301720390594296},
{-0.2168841813239905,0.7111413111981912,0.11263778558804165},
{-0.20068119049715794,0.6860064730415009,0.13835845134808528},
{-0.18540522804158976,0.6607779347654713,0.14777423818495436},
{-0.18482837778424324,0.6323439431994415,0.12212274367269893},
{-0.19886692942643075,0.6166252169764106,0.13564565249637345},
{-0.21910473157719768,0.6210769755579892,0.13715786040222605},
{-0.2410065788334147,0.6101231643054493,0.14188676718476334},
{-0.2516347705910064,0.6270445892914375,0.12387098459720677},
{-0.24382452631104176,0.6336513252536924,0.11208950772637646},
{-0.24538573246515868,0.6464457389162369,0.08937986400275905},
{-0.2531616694720758,0.6640656991630722,0.0583629401910739},
{-0.26416226916463226,0.6655167102541693,0.05705314965831432},
{-0.2695227593301465,0.6938041129151904,0.033246274519998446},
{-0.25859510880755576,0.6878984651797532,0.037533640366463984},
{-0.2578244966135562,0.7146797390324189,0.030348932244213533},
{-0.25612863770619215,0.7370363658884459,0.0335481428259139},
{-0.2422746687971669,0.7347160778523073,0.04410001333114633},
{-0.2359260129404703,0.7309009671517428,0.05379296005545989},
{-0.2357604175597145,0.7217235240705188,0.05500417295461804},
{-0.2365817905365375,0.7276472869215491,0.06486491424385711},
{-0.2374606121533571,0.7432661946186547,0.06951326926612993},
{-0.23945509902281167,0.7589879200189374,0.07005092942412743},
{-0.23162064034400837,0.7652564522657176,0.06875994669685402},
{-0.24016021908727408,0.7774432759632991,0.0555389359265137},
{-0.25070761898043586,0.8270690492127214,0.05036126808441798},
{-0.2508933777990453,0.8626238684441143,0.04841913029746501},
{-0.23858122185194658,0.8855278626783124,0.07409835152878377},
{-0.2251119614355271,0.9021167178974497,0.09142405774648814},
{-0.19805327696717354,0.9311225334694702,0.10719711231777347},
{-0.1682969903284432,0.9243451163802658,0.14232518570427727},
{-0.16770285469600446,0.9032798610927709,0.15595407395677557},
{-0.14078611747293154,0.913689365764045,0.16220613144562349},
{-0.13419861321687934,0.8867826991046168,0.17523072213496646},
{-0.10466516342937822,0.8791030555545065,0.18362093696401974},
{-0.10062893910305462,0.8729220434008262,0.18407332720866207},
{-0.08564499855780532,0.8627550152515839,0.17890202000213354},
{-0.09097583267167053,0.8557380188264495,0.18262405846637567},
{0.19184046907251212,0.7384019041462959,-0.09274422481634222},
{0.20488749250279395,0.7262383439925619,-0.09585158068107202},
{0.20425463316803544,0.7044351211158904,-0.10234086639736303},
{0.20472118743362017,0.692793312625585,-0.10428487614687981},
{0.4285079757336856,-0.4580418414538449,0.04980671245499491},
{0.4363265684142327,-0.5186330975680238,0.050508089656737566},
{0.41238170243732586,-0.44867185076809635,0.08390286169737818},
{0.41702665669219435,-0.3736153067285109,0.07215517258217558},
{0.4186700528394209,-0.39968787382794263,0.05779546674507136},
{0.4132949120701867,-0.39633477878679213,0.049239810584394944},
{0.30185309754763623,0.025673394455676807,0.25888042320615706},
{0.3078173275122048,0.01616771729388054,0.2629208068590625},
{0.30745705652407807,0.020150287900910068,0.2519419493423674},
{0.3086326415772791,0.031908491666222616,0.24888896113498096},
{0.3194526308794805,0.029241934114504396,0.2412051837560763},
{0.3150860210967664,0.0020338644837822038,0.24869278753259588},
{0.31134542024324247,0.0020533182332177304,0.2603221743507696},
{0.3036245807678352,-0.0007981259002967126,0.2707419525055804},
{0.2999388957740854,0.013897439980650484,0.27309936425787473},
{0.28938436287487745,0.02462048669487225,0.2602503587699387},
{0.2999311550707711,0.03988579001286819,0.26657289426818287},
{0.3069304613434368,0.03603209797263059,0.2593180810416779},
{0.31008515278820603,0.04876604469458613,0.2467756269532902},
{0.309379201920835,0.08501753466111725,0.2380338964388844},
{0.3217446312452314,0.06410527141051087,0.23090682712762878},
{0.3208042271596208,-0.037301859103870204,0.23901563775003085},
{0.3104719489121613,-0.016299057459571678,0.25374208570124135},
{0.3057113483797927,-0.01161827668848545,0.2645132180554174},
{0.29803545406684906,-0.01226355769537547,0.27004410674740303},
{0.2935554673097199,0.0022146990421855017,0.2751458273046892},
{0.2926694319438605,0.01613561982908087,0.2721447355940766},
{0.28289098370128896,0.012057484577003206,0.2686193371292488},
{0.2911024516032884,0.037914039732986536,0.2669185337759302},
{0.29149804127669915,0.04985899460580441,0.26453080727914385},
{0.30416671897475794,0.05100073878298712,0.25831502251779465},
{0.2971153345335826,0.05874816501387604,0.2532330584961704},
{0.3015901335533684,0.05838998165709884,0.24622807896579152},
{0.30393216482777624,0.07068744662898076,0.24496975571705001},
{0.29896680006345916,0.0893634752998595,0.2412692182620961},
{0.3038297922734723,0.10140788535513108,0.23763044388526108},
{0.32136764327019135,0.0911931359718138,0.22602067230251027},
{0.2935319615368915,-0.9028281709748764,0.07288812773129809},
{0.2870235057340506,-0.9117351738980634,0.06888019001295445},
{0.2921852480830526,-0.9331345787528248,0.04700221718507646},
{0.2759970895316758,-0.9089729709583032,0.08365913897098363},
{0.27748862829355647,-0.892830163409174,0.10448434427588818},
{0.2801070991429127,-0.8856736303420834,0.09679588592816626},
{0.2886241049074084,-0.883902734633404,0.06506327003188693},
{0.2957247500115775,-0.8964581979054429,0.05697694952044555},
{0.3110080887645807,-0.9224874814482282,0.03309245592983262},
{-0.3660978806335199,0.329117059922115,-0.1803646421482021},
{-0.37136999971727735,0.29493199458276764,-0.17526488704536722},
{-0.20226379460700533,0.5918563028798117,0.14531293357277786},
{-0.21459518013549136,0.580092668085767,0.14976128819972875},
{-0.20230618680349796,0.5686796788650772,0.14367782526888842},
{-0.18641131655255125,0.5796852038802477,0.13477639573708036},
{-0.18791919833379558,0.5643155009338435,0.1302393661797386},
{-0.19888727453602006,0.5566344592550533,0.13683850273891843},
{-0.22134817990596506,0.5531828003916028,0.14234895495424293},
{-0.23118434026567053,0.5603957483758896,0.14633994514317822},
{-0.24295314154890232,0.5744817375892664,0.14830955785854322},
{-0.2236562290041158,0.5906430671561804,0.15090086506497616},
{-0.18983455494463747,0.6002452810661724,0.13699009558471922},
{-0.19136155475444885,0.5474170143949124,0.11498524364155047},
{-0.2173232989078444,0.5466742234742715,0.13542260847562104},
{-0.24208803880415206,0.5507402802119409,0.13874964371556436},
{-0.2576556980732489,0.5629941779642904,0.13928783082783636},
{-0.2651329678089865,0.5833827835918544,0.13773034310105958},
{-0.24541590484700396,0.5899049773901051,0.14777140155609775},
{-0.2993805069772786,-0.9973198266297701,0.2596963258451589},
{-0.2946103224640428,-0.9972929158399061,0.2831314751143249},
{-0.1605692611383787,-0.855070721542483,-0.35961657731832025},
{-0.1804534790957842,-0.85570230492546,-0.3590639021507235},
{0.15720222305711073,-0.5403220319243784,-0.27364721609400755},
{0.16235425924834726,-0.5329719398405267,-0.2857820030569839},
{0.15612576808957307,-0.567793613751799,-0.28351211033538165},
{0.16796565614187717,-0.5341686391865725,-0.29170645541068385},
{0.1610818739698134,-0.4698879095323882,-0.26860128150849316},
{0.15922631604504706,-0.5014832580897963,-0.27134279405612516},
{0.27943827199169735,-0.6041115679510148,0.09350678820876215},
{0.2842067545276192,-0.591798945606887,0.09864618493426583},
{0.2906633945766798,-0.6010050428891935,0.0976971849070528},
{0.2999005566633935,-0.6187801422991042,0.08624777103454731},
{-0.43500127522668824,0.2782759441943715,0.08210865038686871},
{-0.442626591490952,0.37327768096288527,0.03992154216053926},
{-0.4465247421108755,0.27878294538774606,0.07428190372636878},
{-0.43582451272922035,0.24875439443676645,0.09472274475879844},
{-0.44512281001103626,0.22702201397537017,0.0906623102832674},
{-0.4527594334816374,0.2890650514263096,0.05799675477866079},
{-0.4478913342772745,0.38109465240911206,0.026163303632180696},
{-0.4331208728952511,0.46702918046851055,0.006936556748893851},
{-0.4254690113094103,0.45511802503780635,0.028051629401075678},
{-0.42063041623237934,0.4134465723788835,0.04541396319048776},
{-0.43322482631237846,0.33998722249562013,0.05659701867576784},
{-0.4215907999592921,0.2629852705778381,0.08914479352558098},
{-0.42862870881978704,0.2034628094708763,0.11331188759404082},
{-0.43354515714124137,0.17447743993718737,0.11166728561394819},
{-0.4506651673953466,0.19707151918870608,0.0877821630779109},
{-0.4593199270814911,0.21115090341271883,0.06764978896631363},
{-0.4593023782292615,0.3019618387055658,0.029989331635415825},
{-0.451881078261847,0.3944588853141068,-0.0015976547101083588},
{-0.44224028194977427,0.45020789910523795,-0.009870132443088434},
{-0.42216017299046155,0.5223797668949667,-0.0183281087047641},
{-0.4150442887086449,0.5138541290670028,0.011686935855708468},
{-0.39581744833347066,0.5216503495638563,0.03630605470052352},
{-0.3955772007430274,0.4479811072061385,0.06398900043721746},
{-0.40363028595090306,0.38358548133436887,0.07771730562548829},
{-0.4107603140679136,0.3574834101076052,0.07272064551426914},
{-0.4102380747592993,0.2874121722269579,0.09044667761940771},
{-0.05652063952218286,-0.9008275635740199,-0.2532032090862998},
{-0.055206467619608804,-0.9190920749535787,-0.25759215068121066},
{-0.055651752480808135,-0.9380969454022979,-0.2676502395334665},
{-0.059967293382433486,-0.9574573240649252,-0.28348341682520983},
{-0.06305207945561668,-0.975437493680234,-0.3074089916010761},
{-0.060836294101443984,-0.9854024295531736,-0.32591143983408816},
{-0.07867796292241244,-0.9881560397385546,-0.34461138011757936},
{-0.05691847193848356,-0.9950170460119565,-0.33582972962965807},
{-0.07943937572717268,-0.9926675768204605,-0.34820192649181336},
{-0.09423898639231901,-0.9971667942213848,-0.34419872817471664},
{-0.11231293155792148,-0.9911058044029804,-0.3446835601042896},
{-0.14340465950361106,-0.9725851581865657,-0.34545480124371347},
{-0.16941579605856885,-0.9731188258160077,-0.3425326772433186},
{-0.18368610559037823,-0.992036318534274,-0.3390507046977839},
{0.11278252962188592,0.3789406896278957,-0.3102857242277266},
{0.09948720342513438,0.38131139422672694,-0.30224572894649593},
{0.0653763748940203,0.39005401716369437,-0.30549799086226126},
{0.10096250115880144,0.3779155022117076,-0.29846251385324674},
{0.13649488764925582,0.3746385180661696,-0.29381354794648235},
{0.1603672092335729,0.37261894456106315,-0.2925349815793014},
{-0.004301245142114397,-0.568983342640194,-0.33643350980020925},
{-0.017812903067065552,-0.5830268196049954,-0.32629345406048416},
{-0.034588660255617285,-0.5660138012543583,-0.339509396083156},
{-0.04534036329573748,-0.5773960709531799,-0.32897018310458925},
{-0.050472056502200296,-0.5970412779628347,-0.321064253065086},
{-0.0020537129177196555,-0.5947795105361743,-0.3196061907733442},
{-0.016707136268009935,-0.6212288223192571,-0.31865905952147144},
{0.009869310670646295,-0.6287971170314646,-0.3089119990552815},
{0.33930298883752713,-0.1001098153053475,0.2555926588085563},
{0.3518686650358576,-0.1198522889373644,0.24440194336295562},
{0.35864849379079383,-0.11121033657738695,0.24814797418280385},
{0.365738601934289,-0.11959129039754776,0.25585797284890305},
{0.36618635158161095,-0.12390278352541145,0.2683127049867068},
{0.3610823808445803,-0.12734698428602545,0.27519796603044405},
{0.3460805482893782,-0.12219235475732108,0.28297720712565483},
{0.3367532324006001,-0.12815040469565048,0.2782176201303383},
{0.32978969208690706,-0.12212896938247411,0.2705362947886625},
{0.3295204269519096,-0.11051090995638613,0.2666218308967941},
{-0.11980191858941149,-0.9455447906912896,-0.2840871566242642},
{-0.1276894487880282,-0.9502186010047248,-0.2779145141193225},
{-0.11586984528806832,-0.9324000554897726,-0.2667236159395783},
{-0.10679515935277599,-0.9376962083630407,-0.2785439482512969},
{-0.10460013663446256,-0.9132862478688824,-0.26131674211142375},
{-0.10992491183657913,-0.9145552493785367,-0.25479819555918964},
{-0.11016942499438537,-0.9185922885716516,-0.2445583797259689},
{-0.1198989004864802,-0.9451887958946038,-0.2596724546040433},
{-0.13340552791044413,-0.9621129778288626,-0.27432303495103005},
{-0.14374498059785432,-0.9619117981608701,-0.2964603277143826},
{-0.13956022740985807,-0.9605826537450093,-0.30918754727007597},
{-0.11617715630920175,-0.9528966676202644,-0.29855362063511803},
{-0.0918577140229872,-0.960058712459081,-0.3001966916855544},
{-0.08937805100382873,-0.9368944091877359,-0.2757474603490534},
{-0.08562195386996703,-0.914761615721465,-0.26306611768747423},
{-0.09583421509418981,-0.9004832414519589,-0.25580317916602735},
{-0.10099332373422733,-0.9068835282034765,-0.2540504601925942},
{-0.10506245508010294,-0.9088278821731242,-0.2439915405374298},
{-0.12141181808075083,-0.8963559060941327,-0.2352556649524729},
{-0.11650933086034682,-0.9328734187270208,-0.24898949041173205},
{-0.1322537832885322,-0.955863939703015,-0.26450468692069146},
{-0.14433792952076774,-0.9678283472628606,-0.28770907165153925},
{-0.1643957385401181,-0.9733349195648576,-0.31281278444657745},
{-0.16338628644602549,-0.9668855123881773,-0.33237831405759655},
{-0.13767839720232242,-0.9626972235069847,-0.3321043073965365},
{-0.11967515740138787,-0.9681762369503526,-0.33686812914938946},
{-0.09806089544046911,-0.9713242617861049,-0.32437276734965226},
{-0.11156116966572054,-0.8886191793723129,-0.24102520018633},
{-0.25516918571093006,0.6578503393648474,0.07108680360049092},
{-0.2611695460403506,0.6445292678396011,0.08334153640538053},
{-0.265442639500277,0.6473906816080182,0.06290105340438333},
{-0.27147868398326874,0.6751660578867164,0.03823178891086763},
{-0.2739907090067719,0.7300009303133361,0.017328677241149098},
{-0.2714430603869428,0.7278137343533696,0.022594292264284842},
{-0.26311793291005053,0.712710338798616,0.025714129295983625},
{-0.2595332425276732,0.7365710280798055,0.022477836432032248},
{-0.2550760529173623,0.7506415762580505,0.030735893041379636},
{-0.2433552161595942,0.7518086514246817,0.04965865530239061},
{-0.2450611052591062,0.7400057054167974,0.04883128928310319},
{-0.23596119138792312,0.7421135883840079,0.05790607720954534},
{0.3342560407149605,-0.6207374650809062,0.07440674408106937},
{0.32332650548091224,-0.6124712853014325,0.07972132123060383},
{0.31658724583066405,-0.5981569230297211,0.09488270194129884},
{0.31261136201839995,-0.5646356989617299,0.12221043056382515},
{0.3165423410396974,-0.5478872467163404,0.13644465435191067},
{0.3016462031880257,-0.26068876135333546,-0.20441487985666446},
{0.30751873992161105,-0.2308617948477247,-0.18770614360249047},
{0.3033158811796921,-0.2581848021299369,-0.19244127184517168},
{0.29826078757643515,-0.3100151162092554,-0.21645833693212915},
{0.30485086604661443,-0.299576493064685,-0.19387181564978118},
{0.31490834720160216,-0.2921615558576533,-0.18205233432671955},
{0.3279563023635346,-0.26133363758284933,-0.17392518442067614},
{0.32224287819823955,-0.1962786665495816,-0.17439812163239202},
{0.32382037531373725,-0.2185416357825823,-0.20157364864944152},
{0.30393623809932535,-0.2567721705210285,-0.21322194101462005},
{0.29987646231663745,-0.2848928420873433,-0.2276226281706433},
{0.2971126190192165,-0.3059514913230666,-0.23681751917535482},
{0.30622992025664175,-0.34196629807736184,-0.211340749314179},
{0.3166040244372304,-0.34751129023304456,-0.19043884135251085},
{0.339220676667519,-0.36877711642885613,-0.16691027562689142},
{0.34534128350026344,-0.32711486315917276,-0.16043934831758236},
{0.36163842065771595,-0.31299892360718334,-0.15137795522882702},
{0.35583534839647457,-0.2622429152443999,-0.16190576007231436},
{0.33902521275355196,-0.21717885234818737,-0.16820884182112297},
{0.34668023500263184,-0.19397053670843717,-0.15956040558627224},
{0.2511019932593104,-0.7602376611373782,0.11989547581489997},
{0.2510548999082521,-0.7586794541605131,0.13660642081491398},
{-0.4597775241868174,-0.3697171964800842,-0.013371269763133886},
{-0.4559361518275614,-0.33703100476614795,0.02606691349626304},
{-0.44520666160996314,-0.32104090452861367,0.058907788600323696},
{-0.44294262594262535,-0.2938663103056226,0.07830262114827641},
{-0.4364725092504764,-0.28233246794674866,0.09226025449950437},
{-0.44263392635448223,-0.30084095490576107,0.09632603819836609},
{-0.4496091797142966,-0.36671685376697877,0.07712016125412746},
{-0.45906083343888043,-0.44948434839006246,0.05015125024584183},
{-0.46189100073115485,-0.47865095832193866,0.03644289920108573},
{-0.45730829719959093,-0.49583743387113627,0.024864004376559223},
{-0.4610720585434045,-0.5278695095948225,0.013846443343292852},
{0.016734105490303738,0.8583432775722625,0.15126826799674117},
{0.032421707414090326,0.8612193015729027,0.14299440807119843},
{0.025034273820481533,0.8694139101253423,0.150913854062879},
{0.011052905216337843,0.8615106754144568,0.15663816047138682},
{0.008511710723963388,0.8725408206682499,0.1493006409215758},
{0.02238848740388504,0.8836803896769915,0.1401887399030561},
{0.04250317136301383,0.8735595231471568,0.12998984270669353},
{0.04234661282310221,0.8661466523233182,0.14008480667167714},
{0.053896357302098075,0.8548686813241629,0.12843122032837412},
{0.03684895199782763,0.856255800271887,0.14666655692702246},
{0.019170156668801952,0.8544219250281447,0.15595745772565506},
{0.0003864253436291718,0.8496541309324848,0.15644359747924388},
{-0.010331256211144828,0.8612510548175716,0.1513838526545884},
{-0.0037420064190584494,0.8772416618236318,0.1524527485905475},
{-0.008425003372839272,0.8846520200529961,0.1570793040669371},
{0.025009627021663622,0.9017574604463752,0.13659985513463915},
{0.04192898562445846,0.8867325258333132,0.12443681131110154},
{-0.015386398685161121,0.8544956444437737,0.15618572985524765},
{-0.01794992074010102,0.8657843553234951,0.15704432853937622},
{-0.02892231987971025,0.872338080323182,0.1698473753277966},
{-0.030412618811675098,0.9013937451321238,0.159511671877553},
{0.007864643809542412,0.9113366349805678,0.13652495007189258},
{0.03316024339144641,0.9207790893159123,0.11272129827887667},
{0.04364386694368662,0.904588093073271,0.12222130643259102},
{0.33955166663395425,-0.19972132788127675,-0.20480056045241776},
{0.31999643069222033,-0.2337377179196229,-0.21691088866275882},
{0.3168077974426909,-0.23473113084298597,-0.22199864811899456},
{0.3018880720127893,-0.17891978664796454,-0.2228081879976136},
{0.30583935577217924,-0.26398349620858713,-0.23011293014162562},
{0.3530844133539628,-0.1776163365650237,-0.196944946046865},
{0.3367931927456125,-0.15909795965169451,-0.201446756785257},
{0.32651047900978075,-0.11905292161354003,-0.19819404865821083},
{0.29106463838446317,-0.27888632085502413,-0.23874525708683128},
{-0.2667311138827076,3.155616801971343e-05,0.24429871981999474},
{-0.27853699851059827,0.020079282937239283,0.215758100756376},
{-0.28310126182977885,0.0110560472874402,0.21166589285042775},
{-0.27331310742944176,-0.08716593467503293,0.2656136250070643},
{-0.28617704718398346,-0.09468989192204484,0.2561373712296062},
{-0.2959196689103372,-0.08750142287614189,0.23581575785140924},
{-0.299859746392132,-0.09734080445633166,0.2190447910596793},
{-0.30434141387841884,-0.09981209888915922,0.21952265253160128},
{-0.3341462929256294,-0.08186402780105792,0.2199584458414131},
{-0.32933493267284514,-0.09027797150858004,0.22462875020907058},
{0.4374164373427977,-0.5975738109407339,0.11671543956938073},
{0.4463225892773275,-0.5840001307101579,0.060714692496956615},
{0.43066023653758795,-0.5589572906954927,0.0950123348176369},
{0.4157605736167981,-0.5385028274701045,0.13227687312870243},
{0.395779959149028,-0.467546707998481,0.14061022789168665},
{0.4138266344309261,-0.49773380312957183,0.09791900715882201},
{0.45689937218333093,-0.5774456768987123,0.022347028532654713},
{0.44901520556784513,-0.6064634679315833,0.03730423783496004},
{0.44307547472740877,-0.6073077400463744,0.07908322422533483},
{0.43774179336060864,-0.6207374650809062,0.11067266685771911},
{0.43491284252527834,-0.605724082027978,0.1294172229572523},
{0.4232736688063455,-0.5691174078819214,0.1365691557985194},
{0.40272915377004304,-0.5223609920241227,0.1481249846870514},
{0.3949795389790625,-0.4877593023991056,0.15445368958745667},
{0.380772006062424,-0.42750231802909155,0.17033861038924913},
{0.38574661271229305,-0.40064886525212356,0.14584400786475218},
{0.2940471283967049,-0.6529678020383272,-0.10747614416778174},
{0.2951749730924904,-0.664835268072601,-0.1332969939220377},
{0.3085031563756268,-0.6871937201452483,-0.1773638946577205},
{0.29904112717635634,-0.683718231474587,-0.19832410224804226},
{0.2901277009355413,-0.6873067104032198,-0.19019046740471773},
{0.06677621936250995,-0.9447360210583338,0.21165545681849585},
{0.06215525746324768,-0.9539100208758408,0.21617421827351965},
{0.06915779558047591,-0.9573300677948613,0.21661430796052095},
{0.05952494289160947,-0.9616279429793977,0.2080900077039918},
{0.046492104730426094,-0.9654330022396582,0.2033366421688192},
{0.04679059032986996,-0.9606199389471521,0.2146282512970503},
{0.06551310465453887,-0.9337215813792176,0.19568166985290647},
{0.4101059951577714,-0.3501784958535278,0.059013756342661615},
{0.4056161800659787,-0.36451506776053755,0.09683153927191086},
{0.38807127786861495,-0.283927310994584,0.1412666939280157},
{0.3799313418845607,-0.12708412228290752,0.19562529530720726},
{0.3853316096609436,0.030341530448991082,0.2196560293330669},
{0.4077521488460924,-0.03989092675463659,0.16952308278020473},
{0.41900849878387697,-0.03046727809996277,0.15987419092060876},
{0.4217461813513488,-0.045621373880294656,0.14658842001971342},
{0.4304679736583568,-0.0414574013890905,0.14431172895052558},
{0.43788343781966316,-0.011675420417440156,0.14787852626054238},
{-0.070238202705072,-0.5552434997030907,0.2204946876849823},
{-0.1057431270160081,-0.5757144982436564,0.22391625384717323},
{-0.0937187327239044,-0.6179254957720343,0.2217598592144764},
{-0.06578741941386411,-0.6214664765722326,0.2184297642400361},
{-0.09528548145957358,-0.6679507088607758,0.22264297720848555},
{-0.12934867056201432,-0.6924906825732688,0.22644120731133394},
{-0.10861449554561863,-0.6033549976010593,0.22330921102223308},
{-0.11817499720011712,-0.585891313293658,0.22151505176970634},
{-0.10779806595234222,-0.545545234565273,0.22149448461688442},
{-0.09411548892109203,-0.5280716613659626,0.2268172635547233},
{-0.06467387897685214,-0.5066529642477531,0.22458749372652834},
{-0.0537196810078687,-0.555523140312775,0.21868259605100604},
{-0.05137158232244962,-0.586114376437751,0.2129184705977249},
{-0.07441437907480639,-0.674999276858843,0.21715701349321506},
{-0.09336804252942131,-0.6874926519559728,0.224853354906898},
{-0.13246427283617654,-0.7239424020938308,0.22842704193157207},
{-0.16629506660430846,-0.7451023699753091,0.22919672239392092},
{0.14971587610903206,0.4122399023355271,0.13483623479465273},
{0.17273492804680285,0.4161521978530524,0.1215099245364879},
{0.15150196956145426,0.456111479395074,0.10103898230353628},
{0.16868109006137316,0.4843772397465679,0.07477043389753336},
{0.1902726366808752,0.4548574727092705,0.0782510518731084},
{0.19566998708540784,0.430378453582552,0.0898087070406683},
{0.20675741736839456,0.4036299666973557,0.10650888135028977},
{0.19855229204102942,0.3725222452644724,0.1501969912048766},
{0.17792901115199333,0.35786031733965157,0.16753527314384514},
{-0.15127809580020096,-0.9661527729078405,-0.34326760528374695},
{-0.13330158405498702,-0.9698018813254576,-0.34783948819175126},
{-0.10519358807627076,-0.9837699762064049,-0.35249072446400875},
{0.32982697728905014,0.4050301160768873,0.035244036792735745},
{0.355928805224425,0.4140788027682177,0.021504777117521003},
{0.3436432562185563,0.42793001685378784,0.02137886266852303},
{0.3179460558598442,0.40132597068500564,0.039948064109144414},
{0.33371973831414614,0.44430788531842486,0.02363260572898344},
{0.35200516212906546,0.44931171137033227,0.00813198758001284},
{0.36606002704319784,0.4465530356245063,-0.00467478188537886},
{0.3759385179797428,0.42736044090272646,0.004060082287341528},
{0.36922106106260144,0.4087299650915795,0.03046117350467809},
{0.3401950023721415,0.39705233008505636,0.035485070564959496},
{0.30938981962450274,-0.9487829502057656,0.14621279936352677},
{0.32238577842332705,-0.9571413703562454,0.1491677400788097},
{0.3383781479639466,-0.9798225840468284,0.16271469225366522},
{0.3304018217204485,-0.9782898291739023,0.17678335678286053},
{0.30729798538969244,-0.910333889866989,0.02762511834831256},
{0.3004148119773045,-0.9003352342325217,0.031634948214968386},
{0.31417273072091195,-0.9144741940369696,0.0026197377706713475},
{0.31739496155507085,-0.8997751423959931,-0.0035583570111586906},
{0.33423018383364544,-0.9049156684610004,-0.03180468486137325},
{0.2506461586885433,-0.3342159544746227,0.1763644631941055},
{0.24222700705792943,-0.3168039828674438,0.17930731689571755},
{0.2637676919658659,-0.3752699697105781,0.16460933934903837},
{0.2533180644011844,-0.41682263561450994,0.1651054891090267},
{0.2591352199403743,-0.43131629301570573,0.1598024263353528},
{0.254699590834189,-0.4739598020761658,0.15317018939839935},
{0.17297677668581807,-0.6763900228668355,0.152476315983029},
{0.13460032235928415,-0.7117695193115513,0.16058403232538526},
{0.08148163376386929,-0.7624225877942595,0.16655467604591162},
{0.04648302645567719,-0.7718162457388237,0.1646700092095193},
{0.1919229629142559,-0.8457329908699291,-0.3337062430789211},
{0.19498997384234582,-0.8387756922021283,-0.31611457156488154},
{0.18348433841086592,-0.8495320517756861,-0.3139255928846074},
{0.17331903242468594,-0.8598403387299473,-0.32921245670672894},
{0.16015901873643243,-0.8632579537974875,-0.31721384386498575},
{0.17440730136708685,-0.844880127063167,-0.29358170931386673},
{0.19623133468796952,-0.8247712842221855,-0.29249299522259276},
{0.20407619008961575,-0.821380093361732,-0.31671875757521667},
{0.1655219609391755,-0.8647231087237786,-0.34796427330124563},
{0.1533821286015026,-0.8696853138872646,-0.3352212472421335},
{0.13461501333450093,-0.8727728717824278,-0.3245613426113698},
{0.13783444791130012,-0.8637117007369051,-0.30278045048448693},
{0.14927771150498512,-0.8484063563309033,-0.2813409227363181},
{0.15309180866849761,-0.8277283433786445,-0.25780820299615587},
{0.19055179177018955,-0.8067987341957006,-0.2635965439106835},
{0.20045283656216395,-0.8115693234863125,-0.28568343923468403},
{0.20726328391022644,-0.7880983073294316,-0.2843305053831091},
{0.20782771143303358,-0.7993048484017917,-0.3111218094279226},
{0.2048992661061605,-0.8150029872862523,-0.3289958774375093},
{0.20030942956855044,-0.8164002182315259,-0.34836363239757145},
{-0.2759969896653414,-0.9991779375205074,0.2986264901244979},
{-0.2776931120498427,-0.9906168779537019,0.31072749676870126},
{-0.266172075954728,-0.997575960404218,0.31365989425263296},
{-0.25885235811020574,-0.9952130368801979,0.31488184278272585},
{0.4028816995956508,-0.10445454054955351,-0.04853195163259464},
{0.41027839951019096,-0.10589570312023851,-0.02893114264538056},
{0.4187581593816328,-0.09360553370279785,-0.022071282710007318},
{0.4281300145930903,-0.080950210470929,0.018855901219008788},
{-0.4197256771769993,-0.6210211587763912,0.07904007665688823},
{-0.40354817776319474,-0.5995395639285199,0.06655785259214748},
{-0.4394441170195054,-0.6449781829482921,0.08745240019249788},
{-0.405304767088285,-0.5600969281179853,0.10570482349597785},
{0.24043931255693543,-0.2238566729546991,-0.23048685838216862},
{0.25127006086304343,-0.26173226680500866,-0.2355456204795985},
{0.23496731100512305,-0.25385369376665035,-0.22051720010650705},
{0.22878269091451506,-0.24822845688656064,-0.2126142490585071},
{0.22232485459425874,-0.1991162505107878,-0.21064620658188743},
{0.20842583959402783,-0.23929227387042432,-0.23184427134507662},
{0.18051617496796163,-0.4845718845441124,-0.2874863729133255},
{0.16949423681451203,-0.5987004795510723,-0.30235381619241763},
{-0.21641351447776772,-0.2887405357730774,0.25777181021657447},
{-0.19019637492335326,0.959756609361039,0.07072369067146854},
{-0.20588299411991431,0.9527247795980414,0.04850232745318001},
{-0.21547771061798077,0.9379467602468473,0.06384925981296122},
{-0.191597882060068,0.9503502853905466,0.08981925462542042},
{-0.21709826924689238,0.9256623660782695,0.08301728210446992},
{-0.2352236689476192,0.907984268751176,0.06231651025207415},
{-0.23437878913555996,0.9226731680231064,0.034283399150356025},
{-0.22027059028688484,0.9428333198493419,0.021175398823735744},
{-0.20516516872043475,0.9581742581042507,0.006314464917304436},
{-0.17513244356916394,0.976134163352964,0.0412232127103959},
{-0.16332369150259016,0.9749507664151252,0.07496865475977113},
{-0.15896964469224642,0.9642610538083958,0.10422220046045083},
{-0.1717227923105784,0.9460513562974612,0.11887922537322185},
{-0.24899092944311266,0.8944765077380773,0.030559483411511035},
{-0.24302392340693274,0.9130738523616241,0.009272977447649463},
{-0.224941482166062,0.9381399962916337,-0.00936712271586153},
{-0.19992794335883665,0.9593775135689011,-0.029633578005303408},
{-0.1794584544997712,0.97595972236477,0.009286670821931303},
{-0.14643084847395357,0.9895972033716474,0.030568510690684968},
{-0.13289384574825233,0.9905660672377112,0.05884914156431578},
{-0.13017708517781157,0.9856225253922493,0.08281436115007429},
{-0.12910716614313,0.9787821893252269,0.10057312710229158},
{-0.1252845782163884,0.9679644193929438,0.11972281860942142},
{-0.13822683761238272,0.9527493594651671,0.13263758926570218},
{-0.14695248008529965,0.9332462834973443,0.14807973567595376},
{-0.1401358718343385,0.9594974647228536,-0.1098542250640479},
{-0.10845617978318682,0.9633308838972329,-0.11299908923656113},
{-0.12481946351338821,0.9790921648651517,-0.07859113180077845},
{-0.1562629557478583,0.9688080933721369,-0.08058411855040326},
{-0.1747199127407918,0.9455352162720926,-0.10654372513928208},
{-0.20669780247887032,0.9116204497905432,-0.11462074214551853},
{-0.21249982083156263,0.8930180396065516,-0.12429160991069443},
{-0.1999466066768605,0.8762390080771248,-0.1471840738329148},
{-0.18840014928763332,0.8475995213425722,-0.16549492850361694},
{-0.17423411720733387,0.8210141788633106,-0.17753554895022505},
{-0.17070820241230963,0.7715353992962735,-0.1734367254308349},
{-0.13859373483802945,0.7483388774456383,-0.18427008832256694},
{-0.10676140984382958,0.7466210723801131,-0.1912643481581282},
{-0.09830705001834403,0.7338772367662484,-0.19030965893708482},
{-0.06527767827074388,0.7390694755314782,-0.19125887782030704},
{-0.021954427943621454,0.7539064840139955,-0.1865624329084487},
{0.005217469888344036,0.7741065951228355,-0.169197797943717},
{-0.02115415013630276,0.7669353912662764,-0.17982732621033554},
{-0.0067665550317399965,0.800250510343661,-0.17078222514536884},
{-0.14256142111162057,0.323629617335171,0.2352367997769649},
{-0.1586617259738448,0.3087789122911484,0.23521088233840448},
{-0.1405120704403746,0.3071024455135668,0.24318329785874856},
{-0.11716006308171747,0.3134553148796436,0.2445137394745472},
{-0.13025984355910045,0.30374780998108963,0.24714321261919883},
{-0.12621211441858665,0.29323121141519753,0.24930957794920616},
{-0.14493836735634408,0.28988492534571064,0.24751136667328655},
{-0.1529393446482913,0.2818918204956462,0.2443375253277159},
{-0.16639454197251063,0.2891408382875397,0.23487821164281153},
{-0.1799712203179306,0.31249472929524663,0.2152260543612542},
{-0.1734590875216543,0.3365824136918393,0.20604873133211296},
{-0.1546835834825734,0.33638488233227115,0.22154860898283896},
{-0.08439253236332837,0.326500109378337,0.23343534603240473},
{-0.09828862999170904,0.29574773467337434,0.24747752579726828},
{-0.11470714830402798,0.29502496482794033,0.2507514703940576},
{-0.13077897213764278,0.2740476960305744,0.25092229388365356},
{-0.1421849494667769,0.2580653768678512,0.24235740539909562},
{-0.16016505852484053,0.25591935664743326,0.2321847443636369},
{-0.17489098908344688,0.26267709794396943,0.2207523831989131},
{-0.17952261968195177,0.2937883040744743,0.22041085627180385},
{-0.18720907220372562,0.33046979191620574,0.19393909262444153},
{-0.17342100126402146,0.3637108877293273,0.18399214012852635},
{0.40858154725152324,-0.3142273974460542,-0.05397302118097647},
{0.4144184603887828,-0.32053074267200005,-0.08768400509539499},
{0.3950894896882855,-0.31549964142434916,-0.08980286061048189},
{0.380468940422905,-0.3171873739743634,-0.07759204455729439},
{0.3789266206924525,-0.3104237968717189,-0.09858367073382425},
{0.39172010262334644,-0.3082299544884839,-0.1151161524696701},
{0.4051021680434562,-0.31823104197443175,-0.11216263963048578},
{0.4280665484752497,-0.3304485044508877,-0.07003654654717598},
{0.42474360669260375,-0.31775135741070537,-0.05833291335909878},
{0.41426939926079653,-0.2969796432766997,-0.020839359232972678},
{0.39829299770958315,-0.31153230893255934,-0.03951961309971759},
{0.3898288403592606,-0.31562932954589346,-0.05818788513116493},
{0.375414090111037,-0.3059153397100584,-0.08937493974255296},
{0.36726900676113633,-0.30429715237538196,-0.10363606900846355},
{0.37362771299572917,-0.29372948917803227,-0.12541246290067276},
{0.37729570783701044,-0.29006319631406496,-0.13805844438065548},
{0.40966420243104834,-0.32802868048930167,-0.10984139861454023},
{0.4181633756804288,-0.34102005924805073,-0.09208338165983002},
{0.4260206325684582,-0.33985334954970664,-0.07303847012310485},
{0.4305189575468209,-0.33584678658707107,-0.04811775919840532},
{0.4350310619544979,-0.3189474086879862,-0.024534983051798628},
{0.43454250097350683,-0.31040823472209667,-0.02750396773594116},
{0.4272454580989045,-0.3012220767095954,-0.02387571544607079},
{0.4290759304504267,-0.28822081012134504,-0.007623147358716689},
{0.37979472261445446,-0.2931608045871247,-0.0812892694246922},
{0.3660337239506018,-0.2856330386081087,-0.11410887831159096},
{0.3631787143764722,-0.2924671340916463,-0.12023973737971592},
{0.364786688784857,-0.2791795794080355,-0.13062818831539041},
{0.36048707125150986,-0.2520622096569929,-0.1528687449932007},
{0.3723594402978335,-0.2889918079693801,-0.14961790139186362},
{0.38092998291676394,-0.31107629269005654,-0.1417754980274463},
{0.40379709672619535,-0.3336080394128693,-0.11564730750463806},
{0.3922554329210134,-0.35115164547270306,-0.11316030855954157},
{0.40289312791647836,-0.35887264749650544,-0.09402229503907522},
{0.4132389433642716,-0.35816390037177476,-0.07151834940387256},
{0.4260945145324823,-0.3326856303907692,-0.021066166302193247},
{0.433478083086473,-0.30987651236135744,-0.002694242305673053},
{0.4345116592747404,-0.27927765558514994,0.01918335974187875},
{0.435739728336235,-0.28147846948844374,0.008565456341533176},
{0.23365731542765591,-0.8588230949369656,-0.1609603722316603},
{0.22812160446661403,-0.8831907450400327,-0.17702832571361793},
{0.3654512609927874,0.49777320571048295,-0.12623288396009671},
{0.35303602280296664,0.4954908105737554,-0.14888487718623336},
{0.34693304662785346,0.5117353436708315,-0.1487565064503753},
{0.3453886594517997,0.5356511102977825,-0.1341933643910869},
{0.3205417306247901,0.5329455251951104,-0.18119637041396336},
{0.33105962532821215,0.4920539053675827,-0.1801180116116276},
{0.3321337706211677,0.4895797732434907,-0.18925356926488499},
{0.3475741938059491,0.49150637650342466,-0.18072489188817262},
{0.37508176363557494,0.4956984751790292,-0.1392497955657785},
{0.3782460804951159,0.4971621714193952,-0.11617961737689708},
{0.37447279466527267,0.4959504751246828,-0.09075761038877052},
{0.36533429839200887,0.49648300916499005,-0.09408834493271333},
{0.3506346794252609,0.533279189242007,-0.11730663020736619},
{0.3206427656076594,0.593539983406433,-0.11727723763285451},
{0.31611266719887954,0.5865352662907836,-0.14923446885103936},
{0.3038815464075995,0.6185201275489209,-0.10409240078608639},
{0.2773551505633488,0.6463227779609548,-0.13319551272788757},
{0.26997206859213574,0.6540266773438085,-0.10980280558838133},
{0.23320991106287264,0.6787772330334254,-0.10834189604370484},
{0.1949076616723377,0.7188784023258904,-0.1019315472278049},
{0.3335520351162924,-0.25471677049970415,0.2557466240110001},
{0.3373076509794156,-0.24042429276650099,0.25206018895733545},
{0.3336527874986838,-0.25560691950860953,0.24657276655613983},
{0.3328617685754419,-0.2669183467921555,0.25241460289119766},
{0.33612797246891696,-0.2776088902017936,0.24922665808192992},
{0.3423918439326283,-0.2770985657967849,0.2348981912841137},
{0.34271740180792354,-0.2622758243887675,0.2332312288068134},
{0.34171855785582833,-0.25251871354468114,0.2360060552761892},
{0.33829453965640854,-0.24138982279685248,0.24529458478058666},
{0.332523564859967,-0.23043471540678245,0.2524521919419747},
{0.337806262338303,-0.23346683048789724,0.264723779846793},
{0.34744515375316976,-0.24472281601980242,0.26276386266511537},
{0.34278390747451276,-0.25212381231153225,0.26591569835768736},
{0.3440721194422139,-0.2621899053442395,0.26590815951185726},
{0.33702480827258763,-0.2676458985351489,0.26182143363021615},
{0.3432461664253157,-0.2775558792392254,0.2590237696425254},
{0.33482671094606775,-0.29628532365004856,0.2546964710736507},
{0.33219367023598534,-0.2984702503069298,0.24536287422989134},
{0.3383340941616368,-0.2897866356246262,0.2342211368468065},
{0.35029898936666776,-0.29583562979643163,0.22677329049540718},
{0.35592499543001305,-0.2876826028233247,0.22835283593316538},
{0.35468566059608575,-0.2761002891704609,0.23431789670064257},
{0.35446316371535624,-0.26877062187678435,0.23124575965486244},
{0.3554179134936447,-0.2535802129974569,0.23291387696945381},
{0.3471866688702351,-0.24250611593250404,0.2383495250507738},
{0.345175849605495,-0.23103711763440216,0.23700477811379395},
{0.334067871293027,-0.21866305624653784,0.2506732718670955},
{0.33381035851323976,-0.22238803226837864,0.25981069510846977},
{0.3449116904024393,-0.22118711728813692,0.2718850948114431},
{0.34841315706890646,-0.2330453435616745,0.2701172790230092},
{0.3614229760400389,-0.23107229608185506,0.2681420227973497},
{0.36068630458839185,-0.24397354122428816,0.2618185353817065},
{0.3579133628304736,-0.2552095864239802,0.2672524209284673},
{0.3547153262094049,-0.26863736725221704,0.26606297570295806},
{0.3538850778777251,-0.27890739583877994,0.26106526912004463},
{0.3425534680329848,-0.29077356467311594,0.26188133324503376},
{0.3454529776207051,-0.3053486014502614,0.25984182047012194},
{0.3437479384474423,-0.3126299599983433,0.25439873447171396},
{0.33609032179848686,-0.3105795851659672,0.2402338986626102},
{0.33639476538093727,-0.30409321788393423,0.2358723948118379},
{0.3463826811348387,-0.3116639433852142,0.22778291576197307},
{0.3618270766624272,-0.2996272336617601,0.2300407512173232},
{0.36503678489571256,-0.28641457341681775,0.23334257870712413},
{0.3639658416999006,-0.27712482745547623,0.2428324504279094},
{0.36452220554741877,-0.2665108007812346,0.23483504920065557},
{0.3633606421525135,-0.25409880506005444,0.23529414642581162},
{0.3614128842282379,-0.24209986712152098,0.24372867853431188},
{0.35474426301096545,-0.2319660923367771,0.23509296782022673},
{0.347610020322167,-0.21423370915774168,0.23763864992319675},
{0.3373562433878958,-0.20632133561486193,0.2521993197595079},
{0.343240208442309,-0.21061232108474112,0.2663659191655787},
{0.3538657048712832,-0.21022471434362563,0.2697048300000385},
{0.3615127845595646,-0.20818714683741657,0.26905221306721033},
{0.36808182947989265,-0.21970485972089704,0.26207527791583046},
{0.3689683312427813,-0.233479718557058,0.2564343981431249},
{0.3649554862627564,-0.24269675863982268,0.2530116558954867},
{0.3681205733679608,-0.25314624277944964,0.25722705742402774},
{0.36500505183679227,-0.26932925502738775,0.26119611207887994},
{0.3646862614992559,-0.2784940140217508,0.2544609044520247},
{0.3624121743916139,-0.2875141697513045,0.26118839156131407},
{0.3514626595162635,-0.29091330423496436,0.26391480729394534},
{0.3594658147442241,-0.3000401288960116,0.2615368485745775},
{0.358404841183315,-0.31273500769551654,0.2547484684991667},
{0.35294897016930393,-0.32584424041519805,0.2589190863512315},
{0.3410695881690169,-0.32024948082799554,0.2561387491725377},
{0.33380050999282757,-0.32277613626947027,0.2452894788486448},
{0.33188391780170107,-0.3308972272637649,0.23897624473078993},
{0.33962737168978296,-0.32711324192485247,0.22732369635991873},
{0.35116068815679025,-0.3359174675163593,0.22244639776631647},
{0.35492088299758084,-0.31884333415636834,0.22438521977848988},
{0.3578009792073622,-0.30888990734725014,0.23021017657823928},
{0.36401917669685135,-0.3093725103452346,0.2370887508272113},
{0.3701506030907475,-0.30096675248989974,0.24264302417753486},
{0.36964566934297427,-0.2869933083856217,0.24219237628170331},
{0.3704523715303287,-0.2664453075892897,0.24597557118920405},
{0.36863701724196346,-0.25356659611653753,0.24389721253507418},
{0.36434323551472453,-0.23369832490038195,0.24158513053687117},
{0.3608092251721772,-0.22128211460741373,0.23792426870163602},
{0.3551553351534126,-0.20840745515805448,0.24090540095669472},
{0.3459414567962948,-0.20784290545834908,0.24284937033471465},
{0.34101349834861117,-0.1927999364726875,0.2443932103707455},
{0.33252141773378,-0.19819789351208053,0.25679243913725536},
{0.3365360454341123,-0.20159378552709986,0.2672490573453362},
{0.34837088598690424,-0.1995124489438745,0.2753800372315399},
{0.359333775514193,-0.1859930758133965,0.27431796939058495},
{0.3650028632767006,-0.1866540007753102,0.2688343567838013},
{0.36817982491401346,-0.1999824879070807,0.26121692358549853},
{0.36304189324888186,-0.20811484573621583,0.2519142279353431},
{0.3683523110718344,-0.21649336876730407,0.25145877901861163},
{0.3631520065065,-0.1972101538464306,0.24344613967611803},
{0.3522794535154189,-0.19841528446086817,0.23801543604075256},
{0.35184929309182367,-0.18657918601722756,0.23879500539501045},
{0.34675898066961686,-0.17308372449936196,0.24516351871611095},
{0.3325420050723503,-0.1867953605090711,0.2547522368596739},
{0.33222317436331716,-0.18666891485616738,0.2641353387202236},
{0.33766478042764386,-0.18163829912888635,0.2716575727417654},
{0.3482760512160226,-0.18268974820376577,0.2769600883754164},
{0.3523475400448318,-0.1747842643755433,0.272680531226365},
{0.3621467179886204,-0.17399089540622242,0.26531631443065995},
{0.3684817559019897,-0.18245176991640777,0.25966576780927797},
{0.3680502982784565,-0.19665962686742858,0.2517999404774337},
{0.3652155520085147,-0.18416106403295546,0.24749600638114855},
{-0.18044000351510367,-0.4240696273947069,0.311520258040754},
{-0.03618791229587017,0.3422070832461577,0.20880581665344525},
{-0.07268216138491083,0.3129724685902702,0.23450177080779444},
{-0.07756740466412719,0.2914033334635509,0.24051556528399082},
{-0.10922334233902263,0.27207821399137017,0.24956899562619933},
{-0.11471182821043746,0.2384902823993056,0.2355550227887299},
{-0.14529543624732708,0.22603784081274336,0.22036895065808884},
{0.3885652698783382,0.28245604616096925,0.08943614718138648},
{0.3886032838922399,0.28440348111327013,0.07822148718853124},
{0.38388987870207947,0.27671903441744417,0.0940545348665216},
{0.40907776819283487,0.26973466241138416,0.09497268363329782},
{0.41992126220545695,0.26451364939298877,0.10078283259297117},
{0.40345966431879127,0.2711590474379106,0.11155189325191486},
{0.38775414913689565,0.27183140072065215,0.12084727741151183},
{0.41722459389154654,0.26101254713240113,0.1111680612457535},
{0.43510611894156165,0.240848910608544,0.11508565499103447},
{0.4474326822009915,0.21100224812451673,0.10649776219013508},
{0.45655675097617576,0.17470228686399578,0.095900067911179},
{0.459460476198092,0.135107591810631,0.08200382579533592},
{0.36162553258855523,0.2849569265265302,0.07926827335552619},
{0.3954584129256288,0.2871356922805127,0.06028713603490703},
{0.42378496531450177,0.2818392971782635,0.06334933000597971},
{0.4384281289925568,0.2749667000356388,0.06858657236610276},
{0.4128813677047624,0.2746107052389532,0.07446525087924617},
{0.3968443366645649,0.27992793203356936,0.08168387743328512},
{0.4121127613367109,0.27325157011298273,0.09076988119899279},
{0.13005105386395438,-0.8455154384351543,0.14893813144019033},
{0.13013944513145964,-0.831856650839618,0.14681209192348238},
{0.14589278247617216,-0.8067770111431796,0.14200793479565973},
{0.1601890901895357,-0.8122033376583621,0.1468922962763925},
{0.1447609866857359,-0.8525408236323678,0.16234108804750474},
{0.11214398640533622,-0.8755777080852537,0.1605110225981743},
{0.04878690666557575,-0.6350547468492835,0.2379766709045282},
{0.05851204540898431,-0.6213990391739928,0.23353703014644686},
{0.05456571778203473,-0.6548492572159055,0.2227547924434177},
{0.049174457099077314,-0.6699560163537901,0.21685627877643443},
{0.03676167094648533,-0.6539005865351138,0.20454995863544403},
{0.38058853779505614,0.4087989429811459,0.02457686847976521},
{0.3542329665028092,0.3877721489812413,0.0384011940860353},
{0.341209408473859,0.36415847482825403,0.04664003811252035},
{0.3447205207408462,0.38658298635620986,0.04399853532421962},
{-0.0982129291855117,-0.8751445484844066,0.2755449845435307},
{-0.11497025359853473,-0.8759927111366032,0.2886897197450477},
{-0.1478441387757051,-0.8716012983811228,0.28520849619702016},
{-0.1764938373741415,-0.8741358974458038,0.277667821963095},
{-0.414751314880927,0.0887629365355411,0.15511466554494532},
{-0.4130039249450761,0.10630362416111673,0.15343945559580469},
{-0.40434559875590853,0.12489867929582986,0.14381232716022638},
{-0.37902903468066107,0.11706452340325285,0.14962132553223992},
{-0.40455804525874167,0.16621547472950166,0.13453438454967007},
{-0.42550423012836,0.1378122441192446,0.13156922984568784},
{-0.4461414721184464,0.16390507558527198,0.10711667529755263},
{-0.4606810478476611,0.17340507842694727,0.08569319840659927},
{-0.4058383136032366,0.5683308170744376,-0.039026781239324425},
{-0.40564155142692393,0.5545124313902413,-0.007286616935544711},
{-0.3933104081274189,0.5552899141755575,0.01772335324384198},
{-0.3743601698755881,0.567933970572586,0.02953375947937818},
{-0.38020887573955475,0.5294108667837979,0.04917299044509351},
{-0.37400344520473594,0.4848859429172564,0.0688547155984514},
{-0.38774896246196017,0.414605825036799,0.0802176781601154},
{-0.39193246838318574,0.32861176176846224,0.10467819757961307},
{-0.39872530738418116,0.31813714955927874,0.10021002054771608},
{-0.38607857478187574,0.2580528946384744,0.12111907638913967},
{-0.3923554968631429,0.23663581875458506,0.11541683194124452},
{-0.3744191781302519,0.24686450905320426,0.13098729384214794},
{-0.3758137339326562,0.2793170188569721,0.12243736937161433},
{-0.3383887869157704,-0.6539694836816867,0.045414214981139074},
{-0.3334541214875731,-0.6462533442984373,0.054683177058465156},
{-0.3328364800823058,-0.6813031076051587,0.03317387992691031},
{-0.33875568414141716,-0.6988353660871582,0.011306112588469142},
{-0.3483807759412209,-0.7213828385703962,-0.002756533400474261},
{-0.3651646095539554,-0.7197633540357821,0.023455965556619756},
{-0.37359448087938685,-0.7248375762916842,0.030972310651662623},
{-0.3649657002514558,-0.6677817902683858,0.05931267752930809},
{-0.37521189903080776,-0.6949451983995301,0.04521869475955803},
{-0.3772513310627259,-0.6711027867823289,0.06489909721519066},
{-0.38912463290310806,-0.6927776187373942,0.06730236780066644},
{-0.4000976939227838,-0.7287551402895465,0.07141223504925663},
{-0.4146631669048106,-0.7757603964921677,0.08181412863096946},
{-0.42644710537454,-0.7900608178485771,0.07177317216708116},
{-0.44493391071493626,-0.7966074905852116,0.03938352609592493},
{-0.4533903273619447,-0.79426758731365,0.024149479878149825},
{-0.37224438365666845,0.3828875952046947,-0.16965962980657975},
{-0.3745395850571553,0.3711550050293084,-0.16375671883366488},
{-0.3736402770305074,0.42859061671891124,-0.1660575329346196},
{-0.35519047322936853,0.39439290660179194,-0.18557345766251407},
{-0.3592903304715592,0.43637743596904105,-0.17846053218645236},
{-0.3652764864085406,0.479706915193162,-0.16100912718853574},
{-0.372042515548414,0.30451248544023884,-0.16559373561730567},
{0.20792913206993846,-0.7660658604057681,-0.283192549752182},
{0.2291788691618534,-0.76802156195325,-0.28603973788000375},
{0.20309521796172475,-0.7671301157444068,-0.25492557400615184},
{0.201252487548874,-0.7860677102808735,-0.2615962616066175},
{0.18963998026600865,-0.7704545172753856,-0.23656347196984853},
{0.18792065595731297,-0.7586389264897295,-0.2272225593858995},
{0.19895347529156743,-0.7546613821340561,-0.21378100019075585},
{0.22582316059748672,-0.7697428517163968,-0.24526135266424434},
{0.2507753804130584,-0.7744203900188424,-0.27160904089053034},
{0.25106713884623993,-0.7682156086151966,-0.2968370320265369},
{0.2249521806127234,-0.7582581287202776,-0.3136912618432661},
{0.20115572769503792,-0.7564533517640833,-0.30508416389635906},
{0.2017845541297442,-0.7653710541963393,-0.3012027504490972},
{0.20481196911870106,-0.7808817928421219,-0.30849837394686347},
{0.20146041456887717,-0.7980963148951341,-0.338232289464308},
{0.1898858012478309,-0.8049759621759957,-0.3646057325807593},
{0.17422555526278133,-0.7897284913731151,-0.3690901973868137},
{0.17232010772959702,-0.7928745709401646,-0.36573061847078986},
{0.07694524271362226,-0.6361199753534775,0.20202498498553487},
{0.11176119237160662,-0.6307226663828494,0.20394637076070674},
{0.10404973501958233,-0.6329270457267585,0.20674739726912078},
{0.06953064016505113,-0.6153643110142794,0.21272960211145137},
{0.13181945716390803,-0.6226968956798064,0.21108226443124425},
{0.11287857978730394,-0.6225354341278448,0.19740548283460554},
{0.06255690711081496,-0.6426225539163054,0.20163664943266077},
{0.05950045439155543,-0.6329348268015695,0.20602062533346094},
{0.05190635379360782,-0.6231106025936258,0.2113053690092419},
{0.05982261893630087,-0.5974040806687759,0.22359061416647646},
{0.320729210544054,-0.6243975981043827,0.06632756932456783},
{0.3195804141038188,-0.6213380856506262,-0.03140893688919861},
{0.31795095993430195,-0.6248109799214119,-0.05628877061094461},
{-0.11264809041260887,-0.10918849376919523,0.3849294134045574},
{-0.06264546092671532,-0.12648763660438977,0.3924930877051927},
{-0.09223595351442901,-0.14437815812375246,0.3825948189848296},
{-0.14112946855425304,-0.12399948175959441,0.3725385532243783},
{-0.14387959297960468,-0.08603667272722695,0.37587805157035775},
{-0.12003390808393641,-0.083714763456768,0.3849527173199016},
{-0.15476425317010495,-0.06352891729761243,0.3699512077366742},
{-0.18062474879666096,-0.04514744331727505,0.3537714995770297},
{0.03911658497801495,0.662521595649904,0.18750571399441268},
{0.05171693816731133,0.6596869704944527,0.1708108793464516},
{0.04321779572775748,0.6442241761883856,0.17281892253958034},
{0.046848297134964696,0.6410928481537981,0.16003285727761826},
{0.05788263146275834,0.6688448801456554,0.15971408712583035},
{0.07888042810385706,0.6800179861817811,0.14871261519646067},
{0.09815335785470784,0.7096424768818691,0.13824209644457472},
{0.11164912322120747,0.7087927333668491,0.12470741932957277},
{0.12424129480794785,0.7099411654012051,0.10254503568093712},
{0.1268600493201897,0.7045766433980463,0.07192584016958718},
{0.1217842759488828,0.7095195966695808,0.03582240523084475},
{0.12175701137721744,0.6992732767757383,-0.011922583220328166},
{-0.06771930390302885,-0.7518622190889431,0.23383888039142953},
{0.36267094293743435,0.32560566399224217,0.059071340970858074},
{0.3897266696624407,0.36207738047400967,0.03359663749287556},
{0.3599134422146477,0.3543542716955171,0.03407701687131067},
{0.32468434446935274,0.33294051902326205,0.041592361178195154},
{0.3576487574161372,0.3697354837057428,0.024458283582258458},
{0.3849687251496006,0.39779706627440004,0.01178410154932848},
{0.395519609740384,0.37025666910580796,0.02571668119954674},
{0.38927924511190914,0.33353587005023716,0.05592963002472925},
{0.36596361140949263,0.3131390371365813,0.07105574410812306},
{0.3813303959216387,-0.34685295967100643,0.15070306916586296},
{0.3767036800216696,-0.26670225304330564,0.1717017582295234},
{0.3738554783567958,-0.3812101871337922,0.17850930732907622},
{0.3737274507786607,-0.4160433701088861,0.17261639573848275},
{0.35397581919130905,-0.35724505785269767,0.17695280232952504},
{0.34712522876409085,-0.3770004992344611,0.16467067852644052},
{0.3347512077477233,-0.3636250813000274,0.14508722503323435},
{0.33285029882070943,-0.3871330586246687,0.13949351935458085},
{0.31022995791049945,-0.3872993838795909,0.15485184391332427},
{0.30738333710844906,-0.37093497080988597,0.15995869165070842},
{0.3026425345456469,-0.34746654799047294,0.167320617895172},
{0.30158101490712264,-0.3350838949106374,0.1711552025309206},
{0.292582885016316,-0.33580074714456165,0.18440289779826122},
{0.2927447725938098,-0.32378446327369054,0.18710169411501804},
{0.2889738176867049,-0.3113060033198258,0.18515051098795834},
{0.2921650655218584,-0.3029279668715152,0.1906728079879728},
{0.29397172718951037,-0.2917663295277141,0.1935524994203782},
{0.2881151988168279,-0.27773014811735397,0.19722186158051278},
{0.2980899024671861,-0.2723373788153043,0.19377092302955856},
{0.29942484338006625,-0.26254492803777774,0.2040825735669508},
{0.2907700029509281,-0.2567711973554732,0.2148500076795352},
{0.2916133826431575,-0.24638509752828547,0.21445167168193183},
{0.29934141674426396,-0.2364217818272583,0.22029022623926006},
{0.3002992676909542,-0.22473847356302204,0.22664990457700046},
{0.2948832348450571,-0.2153726974490615,0.2286697617449926},
{0.30194582450141993,-0.20556436048753024,0.23437200088084867},
{0.30364024490860725,-0.19412129981373727,0.23692692380696273},
{0.3047829622513453,-0.18527233197965884,0.23330395593354653},
{0.31174443511943734,-0.17135530173016902,0.2311861638886789},
{0.3144725135202935,-0.13793669457027843,0.23915884182375244},
{0.32033929412835643,-0.10682840687403165,0.23115805789002689},
{-0.22913807907634032,-0.7946718908559303,0.20584325634933856},
{-0.2340580737150693,-0.7992699950511292,0.19893120669263545},
{-0.20929712342742507,-0.7890220135514696,0.2242215898521853},
{-0.17883164451509104,-0.7799707324602636,0.23590125087040484},
{-0.15965866502873405,-0.7639461029064494,0.23802945876145595},
{-0.14079706027338956,-0.7505199433125328,0.23700866865119946},
{-0.1206870721567874,-0.7291549052256562,0.23233477759477053},
{-0.11370823210820154,-0.7424392174406266,0.2289679434958023},
{-0.09066907410259899,-0.7249679135444014,0.2296463355045441},
{-0.06247996647470153,-0.6680542978720239,0.22245107873513373},
{-0.05298922889154997,-0.7194367008180332,0.21536990650374077},
{-0.24292758851622123,-0.7798100804630546,0.19555413948162728},
{-0.22558769596701056,-0.7836336203071952,0.21291966580651278},
{-0.19760651004707722,-0.7765717594625912,0.22846179435349254},
{-0.19028549500261716,-0.7566394548028236,0.22401372338942732},
{-0.0920828244269328,-0.7149572622633348,0.22143298395349492},
{-0.05793298746820559,-0.6279842943127081,0.21457708467444278},
{-0.044855034159308804,-0.5851185316629074,0.2160549661839073},
{-0.03952623668121808,-0.6235703478875468,0.21312051081604486},
{-0.022758018338496357,-0.556816458212418,0.2111725202244586},
{0.08393242160112019,-0.9793654320903752,0.20528923298622906},
{0.0670873497397257,-0.9929652124936552,0.21847205444537884},
{0.06252324896894035,-0.983286238556878,0.22010357606049685},
{0.06834938079172918,-0.9707392044284149,0.21784766568810107},
{0.07409520733286587,-0.9793067478700938,0.21180240056771374},
{-0.4150313602679873,-0.982781425923595,-0.08673593148779354},
{-0.4266110805833833,-0.9936178687355722,-0.06847690107013413},
{-0.4343677465750085,-0.9910746790413281,-0.05840208460688696},
{0.3541853876313811,-0.23800138782226174,-0.16231105696589837},
{0.34793716012269343,-0.22623361919942264,-0.14605576380250787},
{0.3441811384197863,-0.20505436011690398,-0.14848150537560373},
{0.018479196375650552,-0.2333277400572216,-0.35479147800771826},
{-0.015981433114608378,-0.22496332155223825,-0.3594876594424393},
{0.016396237495697095,-0.18730827825154764,-0.35592236118984444},
{-0.025796997636480933,-0.157344814652729,-0.3585331518931316},
{-0.04535617617360322,-0.3092514139156616,-0.35566756392442334},
{-0.009419407522690512,-0.29587453623289495,-0.35467094890391654},
{-0.025978382522130625,-0.36989519334722315,-0.34754708168980464},
{-0.056596629303304904,-0.3978297618747976,-0.3447589825596403},
{0.23621294804218795,0.30106731257647723,-0.25107848695527807},
{0.2075178984415041,0.3261267686493138,-0.2666566236902114},
{0.2146207522915132,0.36060047213010055,-0.2681991059690592},
{0.18410828095686282,0.34026969973416094,-0.2725130298859955},
{0.20085201292434612,0.2675091284031334,-0.2635295516613166},
{0.21053048009259742,0.27417219641477525,-0.26052110383901755},
{0.22553634554785168,0.22517808729132374,-0.24873661716685744},
{0.2452569144556121,0.2537707441519554,-0.24073834582760598},
{-0.349727246103671,-0.06318135270691065,-0.20780767176568996},
{0.30616090199557855,0.23412813047976833,0.2716583833589255},
{0.30503214575389076,0.24877644152366976,0.2683080442036379},
{0.3136818186314341,0.24162987809148176,0.275744239128569},
{0.31388388965958053,0.2227087381271989,0.2762857080185706},
{0.3166543995660183,0.20785487135752942,0.28181973718804687},
{0.2247284279659608,-0.9260736910737758,-0.21254529135468903},
{0.22327676774369076,-0.9198656672014893,-0.20848711768298073},
{0.19701878710818846,-0.9197946622378186,-0.22007218722170746},
{0.20188741326682577,-0.9352668195439282,-0.22127235214203428},
{-0.17762136759721478,-0.540482359887205,0.34236906750276236},
{-0.1806226824134677,-0.5416652808663441,0.33453489248684476},
{-0.013922489963232849,-0.4144754367885071,0.26993433770991576},
{-0.03045800168615692,-0.4152997696334928,0.2682466859028952},
{-0.0445187109056601,-0.4070807639480711,0.24743018915482112},
{-0.04081379633052292,-0.4123547071860408,0.2792556552441903},
{-0.027419137128216056,-0.41164190697550934,0.29069916106685634},
{-0.017594024747341907,-0.41398424209855134,0.28326379800724155},
{0.0012052177318780837,-0.4000208483721697,0.27776046817388506},
{0.2897430731859292,-0.45979376999586635,0.15104278256283807},
{0.29024995220240546,-0.4457282470065695,0.16105755811102868},
{0.286105190169248,-0.44410568255170985,0.14950256958707553},
{0.2852412826332855,-0.42825143133861854,0.1550080476090268},
{0.2843241824630193,-0.4236915855111179,0.16777006951980786},
{0.28627962159577164,-0.4289754165785889,0.1767015311956301},
{0.28718063159973345,-0.4429065502917758,0.1757903380127955},
{0.2956428436813534,-0.43981023921865386,0.18559264793481234},
{0.30559240013881445,-0.4461416288235987,0.18712767211082376},
{0.3081664931514783,-0.44694407606766845,0.20056372059664934},
{0.3165767896129838,-0.44698444225246464,0.20882951578449538},
{0.3262572222356862,-0.4520395358557216,0.20787819014658304},
{0.33528102521125663,-0.4529358447051177,0.20410245227951093},
{0.3330420761795707,-0.45671869539248755,0.19276158248828612},
{0.3449155001968512,-0.46502686152867,0.18137423660494148},
{-0.2953938832844483,-0.1070348539599535,0.23654314810841537},
{-0.28137257558344864,-0.15225827165343736,0.28392265552355417},
{-0.48926584182808014,-0.6984394916884542,0.053688766534167105},
{-0.494912963246678,-0.7194623144079596,0.04540155639206559},
{-0.49694684313537346,-0.7487540727928016,0.07586946821828784},
{-0.48805637552736403,-0.7055640887767325,0.07845285198726294},
{-0.49351581304439807,-0.745132684719801,0.080790352092355},
{-0.49565113375574693,-0.7871532031516633,0.08283646879422282},
{-0.4985011999463299,-0.7715894535433125,0.06255165722261463},
{-0.47542455806832357,-0.6635299534639509,0.05799370566824192},
{-0.46847127105241887,-0.6549034017676084,0.08509103840796056},
{-0.457804070867214,-0.6397741089600427,0.09908520583900883},
{-0.48046587224226595,-0.7001492723877795,0.08281510271072669},
{-0.4870219887219366,-0.7394474674819002,0.08072227831183605},
{-0.4854558381218652,-0.7657622274404778,0.07974320683151978},
{0.1473577142968228,0.20343492657786466,0.30069769558683324},
{0.1794614834244416,0.2104521259228908,0.30738114907956127},
{0.16389297210428008,0.21236430062233744,0.30647965249282183},
{0.12915002261183642,0.21223866452418597,0.3103579244001852},
{0.1550003563076758,0.2231893958564807,0.3114519887771977},
{0.17994566728524952,0.21881905702234827,0.3094672080655086},
{0.13383905085476297,0.19068979376406225,0.3057270332375171},
{0.12013096116232844,0.19656289782341907,0.2922915127683738},
{0.10352419268508224,0.20033756053378593,0.29749432992818226},
{0.11040471220275705,0.20920298294004816,0.3065799990354293},
{0.1290954732827572,0.2235098881713309,0.31287904788418563},
{0.17031376651378216,0.0992740233297074,0.30973256247735215},
{0.17474511942852636,0.09884751121453648,0.2966752868116898},
{0.1916178914487889,0.09387898366216464,0.3085528435953568},
{0.15786849724235508,0.09668576629610116,0.3017097718282202},
{0.450267915053711,0.27550636601958434,0.043627047434419544},
{0.43431380388078966,0.29798648184757603,0.05705961122262358},
{0.4318542618031725,0.28507940089903466,0.04713920086106198},
{0.43525615217269525,0.27951163178228217,0.047517929060097115},
{0.41668849441062383,0.2852538312631505,0.05202843029438684},
{0.39188582018100043,0.28963940927493037,0.058476751690283775},
{0.37178836528935,0.2991039914401717,0.06812647966482736},
{0.4122702516082732,0.3088930372006626,0.06452586803898762},
{0.47770918107423177,0.29039306119062785,0.05161342511822177},
{0.4682260375821165,0.28370462181804057,0.05147704382746535},
{0.46734415623079995,0.27334551352371067,0.046556560481143115},
{0.46513199474967193,0.2674749231212358,0.0488688815211037},
{0.4561344130612962,0.27013645442159817,0.06219356204568576},
{0.3906489171985536,0.31989361776987846,0.06320083407894929},
{0.41613800674071083,0.3209342865926951,0.052384588701875436},
{0.43743017640061527,0.3169104584407155,0.05479375671311259},
{0.45486289789475975,0.30757475484226615,0.05359674820639359},
{0.47954508339207846,0.29889948856054477,0.03867602305074143},
{0.49195566079883024,0.28582632458606216,0.037216009115849984},
{0.48748521871347916,0.27516496126937345,0.05209730619280344},
{0.4867939790070735,0.2631300353286347,0.053616618419691224},
{0.4853023595021992,0.2544277775140557,0.058933506306215584},
{0.4757440772176185,0.2556075378299557,0.0654969927088742},
{0.34163535432566633,-0.4150014858915332,0.13886309080889492},
{0.35981852670077236,-0.40883771767904065,0.16567808336068046},
{-0.47039544246087234,-0.3319232242347053,-0.02109150685331206},
{-0.4707520045833293,-0.33660838212597477,-0.041592687337393276},
{-0.4685538254514079,-0.31974953189767347,0.0010677873134078662},
{-0.4562728564856145,-0.28977220812654664,0.04365702008359631},
{-0.43709351423887477,-0.24382310215337058,0.09234662931698344},
{-0.43082741384357504,-0.23714803743272175,0.10725234158785193},
{-0.4327640674814053,-0.21523425508715086,0.12441499689150894},
{-0.4324636769847555,-0.23568353057519567,0.12736206091527774},
{-0.4460874486812339,-0.3543322543560326,0.08841253531598278},
{-0.4290212185729524,-0.3324795880822235,0.12062180685131807},
{-0.44609997234451537,-0.4626435121520668,0.07464394043627816},
{-0.45393530219772404,-0.41325571719000265,-0.05906970592523626},
{-0.4555239460959795,-0.40831507359305025,-0.02506843819967838},
{-0.4573542548366988,-0.3908771643615625,-0.03790802544236592},
{-0.4627201558451968,-0.3527646450700361,-0.06019556391841433},
{-0.45106391879440416,-0.4171685800332992,-0.028236802832980985},
{-0.448670680525892,-0.4251860820163458,-0.050111345146035796},
{0.30015717702061906,-0.4225208227269731,0.18166940005515883},
{0.2942468695645208,-0.41348007859644126,0.1746968112141356},
{0.2863701801752122,-0.41165163331902327,0.1756742264006738},
{0.28865105606876934,-0.3921030438005578,0.17666835963653305},
{0.29955222182702834,-0.39640286531620483,0.17246128632282598},
{0.3053910387990861,-0.4061183127755572,0.1648803277095061},
{0.3119592114826009,-0.41577831954567657,0.1731170841046416},
{0.31502672917921687,-0.42373600371930703,0.18184007162043778},
{0.3056408714328042,-0.43337363830573283,0.1884665938657734},
{0.3079140055606394,-0.4344949576927404,0.2000857581959853},
{0.3184904240607632,-0.43214727228395994,0.21178858076690235},
{0.3277261869563892,-0.44045219701390964,0.2145196169111056},
{0.33775013108399266,-0.4443504698107315,0.20983156183373436},
{0.3424061492538095,-0.44556937879207587,0.2013733008467652},
{0.3353138525502228,-0.45269997423485764,0.17852559935286488},
{0.3503667104277935,-0.08612259177175491,-0.18402139034039133},
{0.3717096610562696,-0.11478211870485507,-0.1854292804232372},
{-0.25778210441706356,0.6204000018636757,0.06595161932195966},
{-0.2664384237178753,0.628865496785433,0.08553370443390465},
{-0.25841488300882837,0.645223142317379,0.044165358848405466},
{-0.2673027562169623,0.6698945465002271,0.03143228117603969},
{-0.27231023057729425,0.7047094932452375,0.0184065303373666},
{-0.26992448972070743,0.7230367408684701,0.00975297754649589},
{-0.27035651467001204,0.7445548113637321,0.014146416313672678},
{-0.2696062667089425,0.758933085964565,0.026523115660132886},
{-0.2665973323038658,0.7490215243976649,0.02748417507841375},
{0.19511088753777522,0.21730364701935198,0.1696953150225587},
{0.20699857756714787,0.2283031736800189,0.1550611488762589},
{0.18649311026754747,0.23397234218552002,0.166775156476615},
{0.1726194039462009,0.22474241509600246,0.17076533604839017},
{0.1645881225338398,0.2607473340207965,0.1777485532171592},
{0.19729220732013655,0.2462341421271714,0.1604916400300621},
{0.2154292786330801,0.24239666136772886,0.14567576708854582},
{0.2256392057473412,0.22896272069900117,0.14089349556163916},
{0.20914200338769026,0.2084909933466769,0.169105658501453},
{0.18124080933910477,0.2169056658659577,0.17160639650436724},
{0.17123048103001295,0.22011172685322636,0.17522180640861273},
{0.4218658190949966,0.33900945246487296,0.023203600142679023},
{0.40294281460500464,0.3741154681403953,0.013584389832519469},
{-0.05906045925884926,-0.37748910058694907,0.2665719614741244},
{-0.052444577027745305,-0.3734403897816175,0.2894662293648086},
{-0.05244063655717266,-0.38863322945001744,0.28770311473094035},
{-0.05073686696124447,-0.40130119745965825,0.2705781600308807},
{-0.055331680879451166,-0.3989831787266048,0.24967945310394843},
{-0.04846423322748858,-0.4487674961561382,0.23511392062708425},
{-0.17176056409549909,0.645303630333175,0.15120165077733175},
{-0.16332761284982222,0.6518016288559276,0.16926043325864912},
{-0.15447053990655027,0.6232888523138238,0.14750817408469274},
{-0.16568800359361985,0.6243504739434977,0.13796112782512623},
{-0.450058104384658,-0.8082491375895295,0.053874644342451386},
{-0.437700212843684,-0.8048277934705712,0.06904340028817355},
{-0.4293935861364203,-0.8089473477535862,0.09000785963455671},
{-0.44527178933362094,-0.8146768206512811,0.07613845287762316},
{-0.45190203106870447,-0.8178807748838597,0.07893931577523425},
{-0.4569896279765451,-0.8107297525260869,0.06490288576144632},
{0.1770501693494254,-0.7689851477773064,-0.34580106969688523},
{0.1907469932694272,-0.7858858218139213,-0.34795928742138654},
{0.14760329198725622,-0.7731625746010349,-0.36471434678095555},
{0.15645817637043666,-0.7849081335885755,-0.34837603388395455},
{0.10345106078097291,-0.5526370861199869,0.24237152904854112},
{0.09749434841407827,-0.5204939643446239,0.2378061310778179},
{0.08649347462030633,-0.5156293509002905,0.24090718473941014},
{0.10607715015674513,-0.5329508648567708,0.24278882158872422},
{0.11169679452211531,-0.5379214991638328,0.23583012479224358},
{-0.346918133609404,-0.7434569478163859,-0.03929239912830525},
{-0.3621396062307305,-0.7620422755451774,-0.034517346662477404},
{-0.3385058111362021,-0.74167567663302,-0.036966183918986456},
{-0.3309446494300408,-0.7374564249385702,-0.0582162450452839},
{-0.3225012015951868,-0.751999201702521,-0.05643668646331},
{-0.3144640238194721,-0.7573767339517387,-0.06800307249826444},
{-0.3118930914700472,-0.7436077109216861,-0.07231419059617067},
{-0.30779959698823933,-0.7463094458584494,-0.07645243688222046},
{-0.3013610720547718,-0.7756929580315199,-0.0682134611171668},
{-0.29454622740077774,-0.7589420739346499,-0.08964724442629908},
{-0.2700386964356232,-0.8138709694525834,-0.13753551663177943},
{-0.23502593466815908,-0.8263251140788674,-0.17705608749213902},
{-0.2461020173733116,-0.7837569860398536,-0.16890911943078077},
{-0.21558974895855332,-0.8027456452077778,-0.1938042975085476},
{-0.18192416704195727,-0.8098473856544006,-0.2143908594588042},
{-0.18122252211344625,-0.7813554801137527,-0.22115990796167773},
{-0.20249553124847103,-0.7559391368216689,-0.21957363642006522},
{-0.19217385051893082,-0.7618586043579175,-0.2273620960278559},
{-0.23959410977290146,-0.7369666889345396,-0.21860233007844285},
{-0.26464825699390404,-0.7383269587120527,-0.2358882809958426},
{-0.28546651627653735,-0.7332640840339847,-0.2501630685765773},
{-0.29501507115519604,-0.744441283527408,-0.24336113217749233},
{-0.3050418944079686,-0.7591690286785563,-0.2376914569034651},
{-0.31845934013301563,-0.7668812764619923,-0.25554803768047524},
{-0.31752910860219974,-0.767502808404665,-0.22181209886897346},
{-0.3297065703621466,-0.7603595681841113,-0.1993925116012237},
{-0.3354305729220204,-0.7449428536920504,-0.18984823185159827},
{-0.3495092687057714,-0.7326545477379109,-0.19530296821406665},
{-0.3597363377700703,-0.7329978988192326,-0.1971448688864167},
{-0.4164106375836551,-0.335546882673199,0.1483924671017413},
{-0.4177009966775432,-0.22466155205024926,0.15940002769027845},
{-0.42079609341853663,-0.17050081668908643,0.1694037191377722},
{-0.42418067822721867,-0.14828842762958122,0.18459964935049575},
{-0.416064652793369,-0.12467532080236533,0.18182862205145373},
{-0.4065235953266357,-0.09372363201752693,0.19616567097957083},
{0.31662453103280713,-0.9592400539342163,0.13711844719723668},
{0.1253813072603979,-0.6061444343026582,0.19910807953230983},
{0.11499272458615484,-0.584227572036842,0.1913994173752375},
{0.11699417235159006,-0.5878580383845914,0.18812087361503235},
{0.13213427622104515,-0.5648958868843865,0.1865153905529653},
{0.2599506763680953,-0.8869932099004175,0.13173604168338773},
{0.26088615619349986,-0.8943698898021588,0.13091395901814668},
{0.2664040548251748,-0.9031844898059445,0.10739262722731546},
{0.25385491394202175,-0.9043542794245341,0.1309641832850254},
{0.24209960842521888,-0.9018331357547853,0.15680482038476973},
{0.24645047332416722,-0.8750576573367311,0.13675349524029268},
{0.2636003935453884,-0.8741542154812888,0.11542725841150614},
{0.1326220063991277,-0.8706699725702611,-0.36854096654534163},
{0.12379332311739337,-0.8775079585912043,-0.34808180322779564},
{0.10396018891478605,-0.8765789031458356,-0.3649070154999706},
{0.14049937360461995,-0.8736716124833044,-0.3512877824096628},
{0.26222672893018845,-0.3266149142288507,0.17110144257084536},
{0.264692653953937,-0.3059360906594317,0.16993355678705396},
{0.26146622767133054,-0.2961277526354926,0.1735045081116135},
{0.2502041237328392,-0.2821875406475569,0.17833216145059427},
{0.2633596593721675,-0.27306509310669286,0.17606238984348244},
{0.2648363244246878,-0.28176572862454385,0.17755640082834043},
{0.27045236085313035,-0.28513308967778656,0.1916538300490309},
{0.26940597840110375,-0.29875621330549995,0.18994282333109108},
{0.27519936362792,-0.3114878907243702,0.18404550487289573},
{0.27212830067643745,-0.32417223256320116,0.1862809288354632},
{0.26631866379732916,-0.3343845490326302,0.17546505317630776},
{0.26816619735589553,-0.3433810375033682,0.16758198084086792},
{0.2646137871724614,-0.35203012286939167,0.16831252219944282},
{0.26976132406661657,-0.35952514225243526,0.17576108780093053},
{0.27071605472156457,-0.3800261315031104,0.1645285379229382},
{0.2662297657612979,-0.3945729602904539,0.16106675750026805},
{0.2719018325153087,-0.41865934854951664,0.15655440980120205},
{0.2780480115040748,-0.4295509090787523,0.1489450307165179},
{0.27526133068833886,-0.44643342762827715,0.14517517008945877},
{0.26860823231159964,-0.47704460408546623,0.1391707672983156},
{-0.25617570980909427,-0.2827867014689439,0.3139631829977923},
{-0.2183114635366189,-0.3014629734312114,0.34405894824137134},
{-0.26506889293146985,-0.2837180262173978,0.30357122717874785},
{-0.2796089754292106,-0.283523980617859,0.2919356794576755},
{-0.26053577515968984,-0.29967019318402405,0.3058241989311371},
{-0.29976016903277997,-0.28671399181032,0.2714774276860317},
{-0.3198705937989926,-0.26520467555542454,0.2550072572307355},
{-0.026775047080482627,0.3217681832327995,0.20967368590813656},
{0.015930113505276153,0.3202799273110562,0.1869701616535131},
{0.03919836488170954,0.34516803294002213,0.17604282560363452},
{-0.041552082642043346,0.30093713787215537,0.22078972895830135},
{-0.2764682652712402,-0.3191113020914281,0.2870511671150335},
{-0.20727126790492947,-0.3627680018590692,0.3459465643218483},
{-0.19222248329890804,-0.381167065063133,0.35866055158825},
{0.34530521369265677,-0.13772449242124193,0.2757142282327111},
{0.33441393682630677,-0.13781259896345366,0.2680343817627088},
{0.3330729178783373,-0.1325086660777822,0.25999525765588344},
{0.33743040901480575,-0.11660764554801496,0.25337600015516254},
{0.34355984976850235,-0.138485195537584,0.24987818073471227},
{0.3516070587987728,-0.13699848010716725,0.24763979796638985},
{0.36269343623561845,-0.12911180089720758,0.25317563110433},
{0.3583074534464625,-0.13753271506238066,0.2546941412133202},
{0.35897636240307923,-0.13720646768441574,0.26839546230558786},
{0.3539439235839936,-0.13032057875766187,0.2788231033406112},
{0.3557480110375184,-0.1469943798557718,0.2779541302442039},
{0.34326233627220604,-0.14432595884075225,0.2787976119275832},
{0.3338490216583142,-0.15149424532546105,0.27285094993858483},
{0.3306096478117096,-0.1520213472746283,0.2658652817949948},
{0.3318866736875639,-0.15501893410187081,0.2577205224794765},
{0.3426070452589165,-0.1536831432627415,0.24723079326954386},
{-0.044606376548630026,0.4304295989570032,-0.3202287755621581},
{-0.07599677601513047,0.44845086356886693,-0.3277358734596101},
{-0.10036590498987119,0.46533832656434626,-0.32659716776876807},
{-0.13575971737984638,0.482599535066225,-0.31452070062019366},
{-0.13499052350027513,0.47663731199001225,-0.30991230275570963},
{-0.15335059846247415,0.48311626260311347,-0.29231888889285934},
{0.2514529830527963,-0.6953188631629358,0.14225217491465844},
{0.25756497694541325,-0.6679302830081928,0.13901541459127006},
{0.2628417366264911,-0.6329507129855741,0.1503260610050746},
{0.26305215605522003,-0.6233395026062349,0.16744596076876742},
{0.26604923611393644,-0.6093999386870641,0.17203234129376685},
{0.27612388046711817,-0.6043824543203327,0.17895262886063995},
{0.5000568518324087,0.26614512957420217,-0.004916864254112524},
{0.5015677636007312,0.2505051883272452,-5.5872558008310304e-05},
{0.10531893944912875,0.5128190123874089,-0.30475629528407394},
{0.14873119617787914,0.5016097558006828,-0.2926380032647781},
{0.19876970317556553,0.4894984746105348,-0.2824117851891362},
{0.1494285957247757,0.49449828901054615,-0.30258190558786663},
{0.2230200655810637,0.4812928435770515,-0.27878075151561543},
{0.2649276330640433,0.48225586101292883,-0.25194537348274376},
{0.24581990347824242,0.4836031619782874,-0.25649196683520425},
{0.21255965882672728,0.48437152611735795,-0.2579363718745298},
{0.1852898643645674,0.49007177855060663,-0.27420931481889194},
{0.16351183011469722,0.4925984339920813,-0.26802508038231954},
{0.12656554456281546,0.5074487353211355,-0.28532819449791336},
{0.025077936656716728,0.540222546994506,-0.3045531703473785},
{0.05965683019732333,0.5266925157888634,-0.3083152700853749},
{0.047937609361836504,0.5232094075293784,-0.30976299833633475},
{0.1359121718383823,0.49052702560985395,-0.3067894452986029},
{0.18649906825055404,0.4803494413765969,-0.29447240546279496},
{0.22744947322710507,0.4637429969337332,-0.2798517754544209},
{0.28806328319671337,0.4751224289412905,-0.24674020627685636},
{0.30307622110076854,0.48279025851653734,-0.23098542936955926},
{0.26382678096352336,0.48482430095362794,-0.23935272593730386},
{0.24121645005971293,0.4856530502278859,-0.24944931644864676},
{0.2088858079935893,0.4874563684981552,-0.25471166881739354},
{0.1815433278386009,0.48529381296255975,-0.2563951867956198},
{0.1666898052890623,0.5075517559442045,-0.26288191954593987},
{0.18978863555421088,0.26981239454131706,-0.24739278177577984},
{0.19349006543172634,0.29071841720843894,-0.26368807565567937},
{0.18397826880093615,0.31627757892020864,-0.26026776525952156},
{0.16818178919981608,0.32236102166530056,-0.2697795417045634},
{0.13298205321920617,0.3331563694807231,-0.2849390483278791},
{0.11139074989109296,0.2810717840278501,-0.2827322371324897},
{0.09260035195690335,0.23430442536959328,-0.2853014058849475},
{0.07408918879261396,0.21147852873361525,-0.29207025146792903},
{0.06145518383588969,0.1666649263541375,-0.3078696686266478},
{0.07846309412976925,0.14116282656592102,-0.3075541611292489},
{0.09979408948314335,0.10738749579758611,-0.3062882395398399},
{-0.34375292432730137,-0.08919815295791134,-0.22296968992107188},
{-0.36796401589045696,-0.08769068657812125,-0.20516340459226384},
{-0.3872616986809069,-0.705432941969263,0.06250170918176692},
{-0.3833697886444678,-0.7178457483076034,0.04052957089992845},
{-0.3996818813166821,-0.7430072529003613,0.07372493536880591},
{0.2974934985940698,0.42131525652533286,0.028042241965653664},
{0.28323157783433967,0.4064258872738279,0.02908446190387498},
{0.25957401242743783,0.3941076734773883,0.02596376538425673},
{0.2772739539215427,0.43773203142643313,0.027333907055153803},
{0.30210145024727303,0.44548825226918526,0.024587773033541975},
{0.31386010022386646,0.4417441061607945,0.01996533969946083},
{0.30119375344854593,0.41903322685689237,0.03642350600889544},
{0.29659765507929514,-0.6005516199841585,0.10364933210758175},
{0.29590842119883737,-0.5882535876865053,0.11377963706841336},
{0.3097133727362578,-0.6087910515221632,0.0927360793356518},
{-0.2481635782975346,-0.6288609879266813,-0.307773172249949},
{-0.2387133832588759,-0.6653564534726661,-0.32803196757907027},
{0.051965372672349665,0.6754360932673772,0.17283286451729005},
{0.062828259877162,0.6915337941680556,0.15556229301536892},
{0.09341752098601647,0.7527074324970552,0.13777202667154198},
{0.11441741482013501,0.7355733995222464,0.11783515153336954},
{0.12267461831600979,0.7373640730147438,0.1089989155945036},
{0.12838808285280182,0.7483356349769977,0.09544869545322003},
{0.13033744288805701,0.7301664449510983,0.08196147397034009},
{0.1412727321228121,-0.8057301006744708,-0.22991821522516567},
{0.1623553333426447,-0.7920502391575867,-0.22989801247822303},
{0.17888359944429472,-0.8001051888911713,-0.24756733431679398},
{0.3613992259134138,0.489339201618665,-0.06366679764579078},
{0.35298321582269837,0.5203059670327557,-0.07728702302499453},
{0.3528707514565935,0.49929854497688514,-0.056547590152339934},
{0.3441371260513812,0.47452107955981193,-0.021463383584371127},
{0.33612635123459667,0.5263215251059191,-0.047486024953519154},
{0.3284318541608745,0.5725327228365497,-0.07288111159011125},
{0.3488251609430041,0.5387328323868374,-0.09865761325509366},
{0.36519293759584015,0.4843901278157287,-0.04043339430798092},
{0.35438336520222996,0.47366225883245067,-0.014031124880381454},
{0.3269498802565202,0.4577955646990715,0.008408831932337296},
{0.3270339751468359,0.47645368117424924,-0.0020236154356251456},
{0.3226984896633661,0.5067743549642898,-0.02145000362039367},
{0.31559002205048137,0.5478171033654046,-0.034804439000551135},
{0.3142784668583469,0.5788363113538845,-0.05270688711000518},
{0.3108206885259025,0.59858263515181,-0.07087245007563624},
{0.32732577395151446,0.5813740710818044,-0.08932539435426579},
{-0.031847704409678546,-0.3946726587642964,0.3000112175922384},
{-0.0152093834828399,-0.388727901672504,0.2946115373273752},
{-0.02380468126618519,-0.3888248442604836,0.2964520802425422},
{-0.03307840080569098,-0.38082306697545437,0.29940595748760584},
{-0.028581402774684822,-0.3779900226828265,0.28525394812800975},
{-0.014029395811668312,-0.37531195606728673,0.2870652302072337},
{-0.0015680480604225663,-0.3737284595348777,0.2814881607724997},
{-0.007005395994240959,-0.3944938512799974,0.2882396604231437},
{-0.014479089665285164,-0.402924572531678,0.29231507909844745},
{-0.03547981748953578,-0.4071162664299064,0.29322030473660515},
{-0.04390619136845186,-0.38961367462363394,0.29766598422068685},
{-0.02936779491190784,-0.3712972879954575,0.2937531213773902},
{-0.01776465487871622,-0.3652623972873491,0.27647756612042557},
{0.004687903153054294,-0.35669323261135005,0.27320348022339735},
{0.008896226920755364,-0.36449642569067,0.2746814817849445},
{-0.0008335757929452993,-0.38078545667652103,0.2738217080777765},
{-5.498385387397746e-05,-0.39417481765107226,0.27895777627960683},
{-0.2632858188420478,-0.44360492300422766,-0.26382740937774385},
{-0.27233191219591035,-0.4498385604664405,-0.27268964987261074},
{-0.26625100329344875,-0.4128113725597164,-0.2607610273950784},
{-0.2597820828724956,-0.4269402809238602,-0.26375958632546836},
{-0.2642099298414619,-0.39105499974271407,-0.2568916510283203},
{-0.27184124446022917,-0.3876210108459838,-0.26171010391565386},
{-0.2785135936665119,-0.5118941608897503,-0.2867834615947032},
{-0.25689102261409974,-0.4820157249753058,-0.2698870818104623},
{-0.2656642843299417,-0.3455400265359405,-0.2524470445761282},
{0.2912958491340622,-0.6387387096799708,-0.16121873600010447},
{-0.33472725682602184,-0.6071692976844637,-0.22482808553710257},
{-0.3392642045779621,-0.5710847821040277,-0.22414225667368057},
{-0.32956087387969935,-0.5378752971729283,-0.22587485364316473},
{-0.3318814870126284,-0.505134312838524,-0.22390859388685266},
{-0.3421262260436474,-0.5511626903705517,-0.22103672390075518},
{-0.3506138084238048,-0.6010045563064159,-0.21546745678898854},
{-0.349757763768055,-0.6425311241624594,-0.22237514951125692},
{0.33494270038129115,0.2465107835596039,0.26363425513835886},
{0.32856214997968686,0.25596280275247485,0.2546093971918317},
{0.32151135411243903,0.2557899925602715,0.2653865077147628},
{-0.21156861719759926,-0.011369842183447117,-0.25596782262938406},
{0.45316507353294444,0.0980440908049114,-0.03129014057253739},
{0.4703059972848183,0.12614498458740817,-0.009363010135223386},
{0.46753982306465885,0.12450296744552078,0.014647743186926241},
{0.4728163596400965,0.15937440878831305,0.0439472985826966},
{0.480393934484537,0.15796534368242768,0.021685090033688882},
{0.4809926490946431,0.15468260553618296,-0.009777424612645282},
{0.4631411551262342,0.1204009216432385,-0.03652799381715201},
{0.4579765155911304,0.12314723627417827,-0.05710666845181636},
{0.44151240404758285,0.06809586532133248,-0.029412438881756958},
{0.15300139138929597,-0.37992011064038195,0.272830483714505},
{0.16064762008892033,-0.3654987543403868,0.27189283551475735},
{0.1482964153427117,-0.37075989131459725,0.2640470898153652},
{0.14357166257471715,-0.3818758132502716,0.27189474041196326},
{0.1464294694686144,-0.3909384419193116,0.27061874825890947},
{0.14256009310185633,-0.39813485458842085,0.2632288371302844},
{0.13014537230463974,-0.4001594532824755,0.2454930085627164},
{0.1387964326867848,-0.40040618581019993,0.22422004936085868},
{0.09736654394158366,-0.39033960513230714,0.2266069248689881},
{-0.3679143695734277,-0.9920321039624858,0.19057823669422833},
{-0.3449516507474515,-0.9744140889843536,0.20282646012645716},
{-0.3216035955458529,-0.9496437565733262,0.20338487017142015},
{-0.3174654597502155,-0.9687745871545795,0.192144599775862},
{-0.30584263861231664,-0.9503127866444336,0.19192520300112637},
{-0.2387528368353621,-0.7226331969477754,-0.3551093769851007},
{-0.2445684518832254,-0.7016521990989912,-0.34898743364332946},
{-0.2645989145255089,-0.7198724537563481,-0.31875292112679793},
{-0.280293263801306,-0.7191987225306752,-0.28443143943723637},
{-0.2848010930799499,-0.7304423873191909,-0.26274082222690837},
{-0.27690720012095044,-0.7588571269932695,-0.2717806144400412},
{-0.2594239398872152,-0.7983459647947089,-0.293930916387045},
{-0.24571749161484935,-0.8164663594922359,-0.3032110571193632},
{-0.22455444275071787,-0.8287303479939788,-0.3048548984154628},
{-0.21457645732263014,-0.8467907623336945,-0.3330307280705327},
{-0.19870427160327356,-0.8527210908649997,-0.33870354488445836},
{0.331211888553342,-0.95720443169671,0.07180039636724969},
{0.3201838713023953,-0.9591985541602852,0.0654612649965828},
{0.3140211166269548,-0.9611043257278521,0.03811072860316019},
{0.32965826055414427,-0.9623757590889869,0.050805989869477236},
{0.33455323017687444,-0.9641455201461235,0.041988332256010195},
{0.34869040619860703,-0.9815806734917484,0.04641993164936662},
{0.3440633652018475,-0.9925202187321962,0.04387151278387431},
{0.3415168512335611,-0.9977666031115369,0.0552204706857677},
{0.3329989955428163,-0.9986157378668808,0.03673147147324084},
{-0.3578077286841884,-0.7241615757629261,-0.21982964908002267},
{-0.057241953868915264,0.9754831580927859,0.11404471312941034},
{-0.0931384689502597,0.9814998911889888,0.10818338267342016},
{-0.09803559101121588,0.9899799155999756,0.08854875299593623},
{-0.1202625042479114,0.9967788528218088,0.021784063945403994},
{-0.29357759726443244,0.39263343921394045,0.13026348071224303},
{-0.29308007912318296,0.3641213521745062,0.12505555655808487},
{-0.29923164876918446,0.3594622944559408,0.1288107517077147},
{-0.3076882269021802,0.34682869321418497,0.12589449963529373},
{-0.31896820478969146,0.396888112647232,0.11477983346565258},
{-0.23944196872466988,0.4315124166849237,0.13342515323874127},
{-0.2273626436990827,0.378526983776484,0.15680959165825092},
{-0.2282808583351432,0.3554545160987688,0.1775996238277417},
{-0.2312403291573342,0.32700573262878,0.1851028609352068},
{-0.23408950292535555,0.3219837903988717,0.19588087344236982},
{-0.029697911579122112,0.74226666116389,-0.1938491406798613},
{0.00880345428343575,0.7449808783300301,-0.17649858899307827},
{-0.020854507574752247,0.7290647004280167,-0.19336542321608258},
{-0.05963760805279066,0.7162278138259859,-0.20150495442276067},
{-0.0009003417494483942,0.753233927811362,-0.17857672454156773},
{-0.08147721202255795,0.7288683440914882,-0.19880188191456274},
{-0.0694855133308517,0.723360881491745,-0.20178321708951344},
{-0.1071313668039733,0.6498344989876181,-0.23439718844524268},
{-0.08607434836424066,0.6237405743039526,-0.2511946803728012},
{0.20089776870396991,0.4913398079571135,0.05996057418422993},
{0.1714540721907883,0.5129186694273468,0.06172167555529542},
{0.18873574797915474,0.5190942718004511,0.0525790720134325},
{0.21521997367014545,0.5035066116418958,0.04630987788658585},
{0.21140101386607985,0.4670340845429682,0.05983279414711504},
{0.21979817896703568,0.4371997417399225,0.060433750437703375},
{0.2257929669674852,0.37831105151362143,0.1180656579065896},
{0.2236476766212337,0.3585549610006851,0.14917822710631654},
{0.22755482477291245,0.343042439634595,0.16034506174913135},
{0.21190730537103633,0.33544593799499356,0.17349772994977644},
{0.18959793335205471,0.3246644503518792,0.18301177676031136},
{0.16274269679237133,0.3344609542152065,0.18045562675317506},
{0.2335010001791331,-0.7480283037701159,0.12976552167175176},
{0.24157110728496387,-0.7312056040924149,0.12382106949100119},
{0.24310605178038944,-0.7327670524755128,0.14228508299661827},
{0.2325868588146218,-0.7583678775720165,0.14332091892630053},
{0.21542662473836702,-0.7737706511487755,0.13918165910319863},
{0.16629674733346628,-0.8280990897077922,0.1577510698381589},
{0.026096254543995896,-0.9258207987055608,0.15822891112433243},
{0.04745664247188164,-0.923753240489242,0.1636320559010688},
{0.07220907118647027,-0.9118768576662067,0.1664901358337736},
{0.025422208845610715,-0.9798284198529366,0.20957332980385876},
{0.02050505083573841,-0.9869382654087531,0.19743599943658174},
{0.050203433061521016,-0.9787280139636976,0.20815620952194697},
{0.08101548533806863,-0.9603971987750339,0.20895166612261737},
{0.08095262691749609,-0.9654268413367595,0.19985088001462112},
{-0.04745260425979023,0.8524017841972669,0.18030784263937832},
{-0.0685634942124184,0.853447194546146,0.1725165251545748},
{-0.05591538791681279,0.8231389222424885,0.19349737107904183},
{-0.16894834087116015,-0.3704896530140444,0.365400460369671},
{-0.1748444534964895,-0.3759571563311831,0.3734361794594606},
{-0.16399441398934114,-0.387048112745696,0.3797794648446703},
{-0.15673442364957102,-0.3873433155050024,0.3715569733992191},
{-0.16510835601650592,-0.39587179102423053,0.3793853944144299},
{-0.197708568128669,-0.36060398869995647,0.35448186793608066},
{-0.18809733756358127,-0.35855685633622086,0.36413338394297096},
{-0.17766447798138796,-0.3550508914350802,0.360455216546895},
{-0.17820354689214352,-0.3536322614716683,0.34906212622451377},
{-0.1754640199847111,-0.36417917478205253,0.34384629988105403},
{-0.16101754730164541,-0.39815722570970663,0.3763708271231369},
{-0.1682515989546988,-0.40083107669105056,0.36643843386386993},
{0.37163496847508537,-0.014825067549920542,0.23268120753392965},
{-0.26293904362035,-0.008681401155628488,0.24792545711632596},
{0.22754284931206165,-0.8692320524682168,0.13913056366191456},
{0.23113819776960357,-0.8758761543756084,0.14281934876165817},
{0.24772377121101113,-0.8640197108223786,0.12114758291553662},
{0.26257650332913807,-0.8577158800760629,0.09601610834197731},
{0.27072616565670615,-0.8702859333945765,0.0909579496921843},
{0.22687203545823897,-0.8993651645335918,0.16702259869275743},
{0.2193136307003484,-0.8930384750208048,0.16168573647696993},
{0.20776740704083976,-0.9000139313005112,0.15918199929680393},
{0.19240005414051456,-0.8991091922451313,0.16675721347108732},
{0.2288005638011272,-0.84880336538115,0.14069630842220196},
{0.255200086904534,-0.8338746031104043,0.1136825584922339},
{0.2692497842670715,-0.8396013211846441,0.09300603928535801},
{0.2951959258993479,-0.8825048545569577,0.0348611343934094},
{0.28464907314620896,-0.8799623129314784,0.059642253430946285},
{0.1508953729477949,-0.4021432002713641,0.24084744661057986},
{0.16125002231654015,-0.39668509926335677,0.23921677598411886},
{-0.42829362539605426,-0.4541719381328123,0.10863482525029468},
{-0.4436647880907913,-0.5239890682507081,0.0765438931962617},
{-0.4321926280670426,-0.5392989523252882,0.10751305540237509},
{-0.4525720343053671,-0.5983341092796999,0.07488151075903657},
{-0.451668997227301,-0.611441559279074,0.09126696800267085},
{-0.434944697761097,-0.567619668908053,0.11811760964856974},
{-0.439071628341547,-0.6051215161895555,0.11021395953622985},
{-0.45752183692006204,-0.663330720127069,0.09169788273581245},
{-0.4700076327998649,-0.7027860007153757,0.08010560476008505},
{-0.4696988939026327,-0.7191630585628526,0.07366225649515352},
{-0.4732363485713049,-0.7560954116986949,0.06646934445978302},
{-0.479003877979214,-0.7807099558154736,0.07764121279080849},
{-0.4728489043785846,-0.8012824355501894,0.08359326118741095},
{-0.4611224751060971,-0.8182268807886364,0.08777038947454434},
{-0.41258089752752675,-0.780170128345541,0.08461173418623064},
{-0.060327368887522936,-0.7475923882834057,0.20909730204781937},
{-0.0430537185277641,-0.7538325106828997,0.1908470970518497},
{-0.30133280457013245,-0.8867806837169986,0.14605408307335013},
{-0.3045415800093593,-0.9068781789801458,0.17869880476077415},
{-0.2904730578428108,-0.8957664716162596,0.16954449136001334},
{-0.28539688925579804,-0.8857399330887805,0.15921554588585846},
{-0.2783350496593501,-0.9054728418632709,0.20818972530117494},
{-0.30389577204819485,-0.9096739380706307,0.200362866025447},
{-0.32070015369041066,-0.9224289587139344,0.17629212065900016},
{-0.3135361635828913,-0.9078296055468001,0.14691793005206727},
{-0.3017534001362014,-0.8641853880085358,0.12413914057844914},
{-0.2907979878350895,-0.8659775201869583,0.13404813430566886},
{0.33777209742790226,-0.3349337798741023,0.25056050365235644},
{0.34145216972118414,-0.34452780793190696,0.2246673931683966},
{0.35919399558084786,-0.33140884780630364,0.22329895772444475},
{0.3659677048667901,-0.31869176043390807,0.23100506585313837},
{0.36488914314456244,-0.3117694766027572,0.246458701141463},
{0.36466656445843154,-0.3062632293975504,0.2551960959695903},
{0.36780534953344757,-0.29502118584335496,0.2549004873704999},
{0.4944567833933722,0.2491732072825278,0.04858728395623079},
{0.47840504119220956,0.2250888450351616,0.06718291491597773},
{0.466160545748991,0.25243398014727075,0.06983631560935893},
{0.44484527615604236,0.25164190731547975,0.07250169176359085},
{0.4402355003486268,0.24825525612360455,0.07955129985890548},
{0.4232546208966941,0.2633380229058832,0.08223218397996122},
{0.43516747724230437,0.25490081671692144,0.09332072660392647},
{-0.36879965594178005,-0.7496388725783764,8.523007306222114e-05},
{-0.35648042754588044,-0.7462491404038478,-0.020288684579284864},
{-0.343282519895808,-0.7365740570044761,-0.023788737180954818},
{-0.3317692659379122,-0.7451078817470349,-0.019034029824716338},
{-0.3303628345409915,-0.7529994246599554,-0.04030511387678683},
{-0.3241567155659109,-0.7748973197591139,-0.037617959424827915},
{-0.314919250692971,-0.7781729259617203,-0.0607060912433151},
{-0.30950726987046684,-0.7919962560918711,-0.0672973649222823},
{-0.3862652451463874,-0.9687809095434654,0.07337206086386253},
{-0.4031776736630281,-0.9507556736512024,0.08153661496172379},
{-0.3914301694067847,-0.9831273703423842,0.05362081493054647},
{-0.38288361914346025,-0.9976780907295411,0.039194498248479676},
{-0.4070480635668383,-0.9950732983807574,0.03448369383264175},
{-0.3951688441149464,-0.944146263608486,0.1040334329029194},
{-0.3779937161435829,-0.9711918177786978,0.08509412682746846},
{-0.45814798927430683,-0.7980360094405324,0.0421684156920908},
{-0.4651205260573473,-0.8032407314975469,0.07214966930971224},
{-0.4698036983084171,-0.7900517395738281,0.07035445933586},
{-0.15086267734739733,-0.549875208277017,-0.30406740562374707},
{-0.1057359132669683,-0.6036965648996654,-0.3129691815005017},
{-0.08516503033119324,-0.6113117086091344,-0.31750872258990964},
{0.4238575097070914,0.17520612739413124,0.17694983396209985},
{0.4280592539832163,0.1408787280930599,0.17404284714820253},
{0.4228396582168414,0.09184862990499534,0.17262872604354249},
{0.42184174599639684,0.1072498640528356,0.1867747370486351},
{0.41793115245618545,0.14556972179043765,0.18880238591551643},
{0.40971376800508397,0.16005178832241054,0.1983303332698564},
{0.3932675293481487,0.15361429604933574,0.21460792637320933},
{0.3847779209562947,0.1872827964001898,0.2088116630836317},
{0.3628312305287641,0.22143552204575642,0.20374329681958622},
{0.3756856256115275,-0.9745935455998255,-0.14409386204303842},
{0.37558491466304067,-0.9768549879296954,-0.1587434086672246},
{0.3593935136430233,-0.9726621604423322,-0.1458959234848667},
{0.353295197188571,-0.9687646982626703,-0.14973194555838423},
{0.35898053660337037,-0.9675367110065772,-0.1568215883672579},
{0.380965769061485,-0.9609616677317456,-0.16584395284265166},
{0.3834714313246053,-0.9513177107564339,-0.16711518328389446},
{-0.4526695431567102,-0.12108805726826868,-0.09094422019603689},
{-0.47741604576052643,-0.08398175928868025,-0.08013603530702855},
{-0.4555945855913632,-0.09196797442408731,-0.09703388333886488},
{-0.4116218513720486,-0.05674937220556171,-0.13802638728735267},
{0.3241736960299614,-0.4084314688680576,0.14264945700371284},
{0.3245182210719146,-0.43190345819049364,0.14682601265303585},
{0.317428436962802,-0.4130336261490571,0.15374900511019698},
{0.3095335315291582,-0.40071597861598096,0.15493788407234274},
{0.2787985027565332,-0.49712442938189333,0.12905453074172327},
{0.2780396227319956,-0.4616126514781656,0.13898343824096088},
{0.2858592682586837,-0.47922580169092927,0.1386077368417806},
{0.28643386939869325,-0.5224337797081011,0.1257061772266353},
{0.27682602154007724,-0.5312666977473718,0.11792551887940407},
{0.2793884227547761,-0.557977494653049,0.11012419563783225},
{0.28675233570184705,-0.5656070658605976,0.10801019745125932},
{0.2923413200401866,-0.5739859129260684,0.11010439341863454},
{0.29271006160579405,-0.5655331435250767,0.13233153507300957},
{0.3038907256110905,-0.5837384841015762,0.11289432626468139},
{-0.16467159060354664,-0.7914170345402893,-0.22516262075840462},
{-0.15875833390336375,-0.7810842697100523,-0.23345637958225596},
{-0.1432983050448298,-0.811834536597917,-0.22881586300481602},
{-0.12912503902974215,-0.7965483208445605,-0.24089474181912243},
{-0.16854248621347512,-0.7820279152018955,-0.2421420404620044},
{-0.367480136940691,-0.7094938109695891,-0.22200861775389727},
{-0.3653447556720969,-0.7217068973882697,-0.22356418995938998},
{-0.363015470104203,-0.7153113107289099,-0.23074501923072083},
{-0.3577628844504669,-0.693215316944412,-0.22772477761930685},
{-0.36487520222926045,-0.6871522193089094,-0.21257876782482796},
{-0.37013354188370334,-0.6882185824646461,-0.20378098679910542},
{-0.36226524232888185,-0.6353651887862374,-0.21152067232668006},
{-0.3643640672070916,-0.5990021672476598,-0.2264838013653108},
{-0.36972664394154753,-0.5758887671217849,-0.2389007415324455},
{-0.3838523916424523,-0.6001255933893574,-0.24021762682456999},
{-0.39712786887406243,-0.6425327453967797,-0.23350886252814182},
{0.08895058484644318,-0.09359653723345046,0.3822421473997782},
{0.06392408678873374,-0.09690602362116416,0.38586276522711543},
{0.05855765988836905,-0.08447246739585831,0.37720208899186897},
{0.07880018337945013,-0.08354211581295974,0.37665032537017434},
{0.25296095513870465,-0.009071438685816544,0.3052181887665897},
{0.24626826082283246,-0.042175875919742874,0.3185066762442589},
{0.15644772015275626,-0.09179727204898189,0.3662650977797999},
{-0.07722361799560302,0.8411584434431337,0.18559147184936509},
{0.29280323370845074,-0.5123749811674272,0.1700089186851595},
{0.28812212996538983,-0.5314957603083761,0.16789564506071397},
{0.2862760147212518,-0.5222056903126521,0.15783478969851714},
{0.2933572878813868,-0.5046353360113494,0.1597400746833064},
{-0.09430997117024137,-0.4944295034167936,0.23050465052578703},
{0.34203171530714827,-0.4410704864879419,0.18766480531454674},
{0.32734510552405166,-0.4304065287713776,0.16562698898180417},
{0.33127486808840495,-0.44584691158466205,0.1601415724065566},
{0.45549873622102166,0.22968613861320025,0.07761772932854409},
{0.4500931595928047,0.23431536817005127,0.09473392978823744},
{-0.41871422881862896,-0.48569125760000936,0.1439665239675731},
{-0.41800313058541155,-0.4320180696827855,0.13905502009207324},
{-0.4114717363355135,-0.401063868303473,0.16632725596738385},
{-0.4093058182791948,-0.40543080212056964,0.16933810483133677},
{-0.40381253882373463,-0.42074295549823504,0.16369957510471014},
{-0.41505421797205083,-0.5084525534666041,0.138614879409497},
{-0.4172240276281829,-0.5539004133095202,0.12115677274310571},
{-0.08631064486003309,-0.6265667990008388,-0.33274233322048213},
{-0.05146782053405015,-0.6421508119133774,-0.341077126483643},
{-0.11197012336699161,-0.6042555220846513,-0.3123930802406623},
{0.44632238741984337,-0.028825259895667588,0.09830168007806109},
{0.4472508755394407,0.022174400012187068,0.11579140931296031},
{0.4490877499604347,-0.0692951898770805,0.09390260736226015},
{0.4511879729673243,0.01391000401542873,0.12222620094537838},
{0.3132916992958445,0.4201589223016753,-0.2420844303360205},
{0.3395086667401934,0.4341774337453153,-0.21433422249837555},
{0.307919760623754,0.4331514357119671,-0.23967633960630416},
{0.2609260761670152,0.42534905431221504,-0.2673712480549551},
{0.26752107783499285,0.4128072079210955,-0.27205632414082304},
{0.28447583692847317,0.40390587931802946,-0.26564941008937754},
{0.259801413382625,0.38945210045644435,-0.2897588993438925},
{0.28393540069886436,0.3831399202471385,-0.2739485191989673},
{0.35563108880823663,0.39035019308855606,-0.21156733965220603},
{0.3056757651549637,0.11158867168553176,-0.195726198551508},
{0.2955647067740444,0.16360760246047254,-0.20467423591400458},
{0.2971761669424587,0.15414577618109404,-0.21297636438659454},
{0.3089312695393696,0.09702717104631209,-0.2116634100033724},
{0.31488427410300235,0.01960794677409528,-0.21071101027116274},
{0.05573693102709156,0.2756072798879632,-0.29380138975148806},
{0.030638490962021644,0.26480747420936374,-0.29756223372345136},
{0.030648253427401094,0.2152976914575728,-0.2969584524904924},
{0.03188112988424256,0.23819661906891795,-0.3000498201800676},
{0.04699591870036634,0.20746313078761958,-0.3031401339610939},
{0.10175664993545587,0.3305320426395101,-0.2926348627872875},
{0.06951138933550763,0.34450256937193796,-0.2991028514765901},
{0.058039939000176954,0.38963212439768763,-0.3033017580614505},
{0.018130065795834732,0.4029593961349218,-0.30612471054227736},
{0.013631572957037886,0.40845502563646086,-0.31088828900374144},
{-0.023396772974200602,0.42430327849504884,-0.329481803647128},
{-0.04879169068795073,0.4369682483898456,-0.3320581457771288},
{-0.07013106312691812,0.4564439684189312,-0.33550911513790954},
{-0.11200599025470634,0.47934512496186493,-0.32600915266773106},
{-0.15264550920783826,0.501522539556217,-0.31099495793523496},
{-0.17767638332332314,0.5045114539484946,-0.2934797627850952},
{-0.16819161859688758,0.49453492614392414,-0.2939232967982212},
{-0.2149660688272858,0.5217641918728927,-0.2609605443948461},
{-0.2334628448649925,0.5395983813428685,-0.251296039390053},
{-0.27126595487995775,0.5662008870203242,-0.20883273700497973},
{-0.2903880514065929,0.5833809998091389,-0.18299247493519286},
{-0.30417549446328057,0.5741272832839073,-0.17776098445096103},
{-0.3331070424172411,0.5741475465880951,-0.15186045729806943},
{-0.3789474120133226,0.5514149038601753,-0.11849874101407439},
{-0.34014290508029116,0.3355911075231663,-0.19505254806882869},
{-0.3265235296273366,0.25882567520681715,-0.20190030186719038},
{-0.3246726526713876,0.13008354282603254,-0.21020372647731034},
{-0.31458759247202234,0.09142819688732155,-0.21932461334109932},
{-0.33820979669732776,-0.7211528039062445,-0.01020090886555357},
{-0.3812316716757592,-0.7596041324856985,0.008913548948917207},
{-0.38440851219858163,-0.7385471055467032,0.023343240900600987},
{-0.2578160865933207,-0.19698538766261584,-0.25153361290003484},
{-0.26382118951121164,-0.21217968707934878,-0.24557657649875764},
{0.09169508594724884,0.7944712285805418,-0.09133134035437472},
{0.10005289840046055,0.7823402715977256,-0.08822784527963172},
{0.09143942706909262,0.7838790651966522,-0.0987115761350609},
{0.08181246118190943,0.810774829427119,-0.09451991304665897},
{0.07357039487253222,0.8136861731754511,-0.09970646899250532},
{0.07684684250212533,0.8024677575709825,-0.10612593539224319},
{0.0881876007405299,0.7882935385760879,-0.10656737327475724},
{0.11168023902118943,0.7620132271907966,-0.08669851454708193},
{0.09980051280077137,0.7786280210966504,-0.07781789439707683},
{0.08604134785280124,0.7903343081794406,-0.08691852858075605},
{0.08658280718113257,0.8026151156592468,-0.08540999873074671},
{0.07645946842832062,0.8121599839827999,-0.0809211568045091},
{0.07922167030567281,0.8218318036653747,-0.08758131806837885},
{0.07023123118501333,0.8262262772177599,-0.08593347361964568},
{0.0675066289825162,0.8305860376573135,-0.09290873654113035},
{0.07194039356299238,0.8183527697398466,-0.1066255709122609},
{0.07885920119578417,0.8049213416655931,-0.11078091027758917},
{0.09151542641188495,0.7985097062738334,-0.11376733119873329},
{-0.2527060580069491,-0.5695758570383125,0.26264621162407487},
{-0.25748671892361363,-0.5749469043502492,0.2552611429502544},
{-0.24535574175504912,-0.6163544825314099,0.2522656033828645},
{-0.2410161638766896,-0.6239091582378821,0.2639760859141022},
{-0.2534369531473252,-0.6089583499426409,0.2444934549222031},
{-0.25660702613238856,-0.5996441250429155,0.25091601186626444},
{-0.26713529631049737,-0.5685021983281346,0.24641541758481655},
{-0.2535364285155273,-0.5412061836411881,0.2652073560103328},
{-0.24190690039711465,-0.6034822549335309,0.2645511523887332},
{-0.23819114395026167,-0.6093764329142357,0.27076053401820277},
{-0.2323716989222381,-0.6260428577149106,0.2726682519168802},
{-0.2274977830351075,-0.6223039397153601,0.2782643076416127},
{-0.2231148408571079,-0.6143084848192168,0.2766823930344349},
{-0.21112092810752262,-0.6173540563576715,0.2849570019574848},
{-0.2111491148491683,-0.6074473170598277,0.2924260040356336},
{-0.20370230328297734,-0.6089528381709151,0.30146865306337145},
{-0.19939893651246346,-0.5970156643729082,0.2987098551406471},
{-0.22060297838199994,-0.5945520702718982,0.29280822011951374},
{-0.22139938690006936,-0.61066229377345,0.28964436859459425},
{-0.24109596238981576,-0.55681224364063,0.2748334815329371},
{-0.2332156459402389,-0.6052961101644742,0.27683082521699676},
{-0.24006964032208508,-0.8880910235145967,-0.18642743593507063},
{-0.2553767685108023,-0.8632696254097041,-0.16377898796380078},
{-0.24199073181029312,-0.8590865242658547,-0.1766655623167655},
{0.2628793862345134,-0.770342823154944,-0.28558591019759255},
{0.24148676910325936,-0.7577599635726711,-0.32150798999810404},
{0.18748413277333467,-0.7449817601285137,-0.32243352037435424},
{0.1953695551548535,-0.7732353622850133,-0.3256961173933094},
{0.38286752897715576,-0.5568198632294536,-0.08744906635678555},
{0.39821096920246085,-0.5482682059717796,-0.08014205384728045},
{0.4086606573243875,-0.5317867484958945,-0.07450094990652668},
{0.40776807646400187,-0.5344972376730242,-0.09011234000595861},
{0.4326169516221219,-0.5254540616910118,-0.09199442306655349},
{0.4225006438842063,-0.5383909718636755,-0.1241965828439989},
{-0.21922599055516584,-0.7067413364981585,0.20904301513346968},
{-0.2351885521198194,-0.7592071244978594,0.1952098364829067},
{-0.21378377679357105,-0.7623442883385552,0.2128996861652106},
{-0.20962936915989344,-0.7456464130794377,0.21428582238570912},
{-0.24897492108220962,-0.7351635332126656,0.17631699481308974},
{-0.24613792569493095,-0.693095031131999,0.18336553200133046},
{0.21158040992430646,-0.9410073159850748,-0.2202553112689444},
{0.18056012677912153,-0.9375117265586208,-0.2266953150740855},
{0.005238939025397937,0.49151521148678473,-0.3154559169684609},
{0.022810719077983606,0.47082544511690777,-0.3241259955128388},
{-0.019464321455676423,0.49712107642284037,-0.31754544046628136},
{-0.060850314697331744,0.5307807417903343,-0.3038954878541053},
{-7.198237885721104e-05,0.4721245988226591,-0.32348659068355395},
{0.08099567674442407,0.4432826979022368,-0.3232999606905391},
{0.09152672405655206,0.45047209867979054,-0.3140265471244831},
{0.05884398729281852,0.47260679704326736,-0.31420199102565105},
{0.012157367378601026,0.5180333386110388,-0.30927322196080725},
{-0.031927932135560534,0.5399409611161189,-0.30405784182862833},
{-0.07071632234209223,0.564360243176415,-0.2919632181305562},
{-0.2034895125600133,0.535689773442857,0.10835822418935905},
{-0.22386717538711917,0.5315447681183106,0.1089110714670213},
{-0.033379614668394536,0.6869006740737991,0.19982703958333206},
{-0.10445514346598647,0.9931263096397371,-0.04306844084401143},
{-0.11952279430992373,0.9958458260960408,-0.008001103187272898},
{-0.1657841854976065,0.9820939662641823,-0.011294425040135343},
{-0.14157374200321587,0.9851939660172255,-0.04631337745791681},
{-0.0871183807701882,0.9870299692638143,-0.0669591612068073},
{-0.07176029950283361,0.9948709936228922,-0.03763271201969777},
{-0.0500857416489836,0.9889808889137367,-0.050359910327234955},
{-0.05454784595783027,0.9775179898988803,-0.08360139179439204},
{-0.29365674770879363,-0.9649074397194097,0.24228852843827123},
{-0.30571973927668755,-0.9637585614737731,0.24342824660375753},
{-0.213141048752652,-0.6170935444006325,0.29131793712366616},
{-0.21559467321875941,-0.6188263442900087,0.28774400680760326},
{-0.22564483969596524,-0.6080054636276535,0.2794498230206274},
{-0.15499682167688708,-0.88612040682385,-0.22451608292307365},
{-0.18399569653867523,-0.8800033271850395,-0.2157290619636655},
{-0.15899536983499302,-0.8650003185443902,-0.21997376576205427},
{-0.13945012371391025,-0.8858200163272001,-0.22725216550438132},
{-0.14349257375000896,-0.8420068791341379,-0.22524128461998816},
{-0.174124278050931,-0.84903842523425,-0.21685633827127188},
{-0.2079611700399006,-0.8610052657079839,-0.20257670823573262},
{-0.21112463697319242,-0.8940130843883131,-0.20807140494321325},
{-0.17529362145823968,-0.896803817227442,-0.2235683641596812},
{-0.1751244085788859,-0.9117380912699136,-0.22430847993745293},
{-0.147881819193554,-0.8933421079860951,-0.2246031971763895},
{-0.13504928846355008,-0.8990905491128559,-0.2343672582923784},
{-0.11931578945990089,-0.8469149386835131,-0.23250685791280748},
{-0.12484874453507983,-0.8310503130581429,-0.22844485319853108},
{-0.23088502280091042,-0.9021009422038576,-0.2033715157052302},
{-0.20750347094342442,-0.9071273422969429,-0.2176650877184792},
{-0.18811517964036684,-0.9171723614083023,-0.22285398414873417},
{-0.16441950779008369,-0.9092026826504803,-0.2280893449846231},
{-0.20914646231327486,-0.9190003201029423,-0.2168248888752372},
{-0.2382130083030214,-0.911359562803547,-0.19804174612399197},
{-0.2556817794190241,-0.9031089462361032,-0.1862791652384962},
{-0.48237419677580384,-0.31087187055342325,-0.04358014319195166},
{-0.48153519420375757,-0.3060803688274507,-0.015572087916058878},
{-0.4757550200180765,-0.2980387119404028,-0.007241620777506177},
{-0.4675463898073415,-0.30478105257330423,-0.032556360698541405},
{-0.4598847604440822,-0.2996964548427154,-0.00808970162430134},
{-0.46170477551551625,-0.29112048119505274,0.00527309171810885},
{-0.4736867329899993,-0.2903128462136396,0.012389513578278055},
{-0.47786233565951536,-0.30758848327600574,-0.0036631316695243375},
{-0.48223243120225895,-0.3198224810676392,-0.040790371831892144},
{-0.48051876102793584,-0.3203973254990376,-0.06733548092733387},
{-0.4795363705856166,-0.3056600165527706,-0.07961252960830308},
{-0.4757261235880128,-0.3017170004509693,-0.07085127416313833},
{-0.4694137818927195,-0.3031808592397304,-0.0571094455858355},
{-0.44697873340408967,-0.30450076389485503,-0.051826991398888196},
{-0.4528349366799818,-0.3036470894709326,-0.036323567430887556},
{-0.4622696906835088,-0.28089065624489085,0.01096514342546091},
{-0.45319348444263835,-0.255130638899511,0.04330910808554022},
{-0.45644116738073637,-0.25824980767669636,0.05029962718319738},
{-0.46430571876079907,-0.2797189213575985,0.03598429280833857},
{-0.4688881386294774,-0.3297449450635004,-0.07068699510566093},
{-0.47637310763462454,-0.3131856747146886,-0.08583485030250834},
{-0.4654854780142913,-0.28370003221629514,-0.09842484289082742},
{-0.4547596350427098,-0.28216290022318585,-0.09239135137380663},
{-0.44794973483467015,-0.2963973428672805,-0.07421713509655127},
{-0.285769115519027,-0.5131185827052283,0.23313850185302967},
{-0.2942437896442754,-0.5222904736432296,0.22256425172724895},
{-0.28458268965651795,-0.5714154873451696,0.21964990986407296},
{-0.28899367727592434,-0.5859869576192919,0.21541783065770767},
{-0.2925147591778142,-0.5768241449560395,0.20878231088061683},
{-0.29524409334470353,-0.5382988929786567,0.2146893663064042},
{-0.2992466839645321,-0.46853704206400654,0.22998271506580686},
{-0.2989707724062661,-0.5627480839436608,0.2055682457128967},
{-0.3039628450405554,-0.579886413295659,0.19008302928996876},
{-0.29561569172491603,-0.586500361944546,0.1767752410495888},
{-0.3092077707339709,-0.5864209278372992,0.1810980509454601},
{-0.30553523728651905,-0.5913466573533944,0.17490427183710958},
{-0.3050202924699383,-0.5868915351886846,0.16698500857957255},
{-0.29256250059763755,-0.5903991213241456,0.1645736148239704},
{0.20013842228240306,-0.932375739099784,0.1779119802235718},
{0.20628496673945632,-0.9146259292454172,0.17440430272103905},
{0.19098809184852739,-0.9399255521657033,0.17894326692300544},
{0.18531156723133974,-0.9326894235053783,0.17731808894492962},
{0.17101728552967269,-0.9293089310915861,0.19157736430920924},
{0.21009122120850468,-0.9273734939107001,0.1892866303335696},
{0.20230470580700893,-0.9365077756121758,0.19149095974431146},
{0.195663258856738,-0.968361042789155,0.20002079195831485},
{0.19544157259316863,-0.9546724270319046,0.18642968505240745},
{0.18904240030744518,-0.9746488258654787,0.19805303314458084},
{0.17971660472424525,-0.9496317609267273,0.18894005803176378},
{0.1676031158506651,-0.9636969598816416,0.20385049164294639},
{0.1606012162405316,-0.9575391900236525,0.21200485618748796},
{0.4301940881117873,-0.6158037930040126,-0.006186301350969628},
{0.4448546380936767,-0.6107164383251531,0.010528118784995637},
{0.4238871763828184,-0.6330389013331873,0.049234544228873564},
{0.43789320453467373,-0.6248130877385099,0.07190278167044736},
{0.4562187916144973,-0.5956832774884069,0.011987679071751594},
{0.4472304082529531,-0.6014646266971273,-0.007448144356790455},
{0.44085196566844687,-0.5756276060335732,-0.0033671172306499997},
{0.45525958291062424,-0.5880253368050689,0.007787905562117048},
{0.30900134277138974,-0.1643222969441318,0.2425481894066532},
{0.3098728688337681,-0.14981275335893127,0.23708011876374324},
{0.3028303406241089,-0.1500838830196379,0.24812710318134784},
{0.30776632343799254,-0.1397869436432109,0.2530844032079682},
{-0.0865745862694874,-0.7904288093542696,-0.3646604455206414},
{-0.06821470572791785,-0.7890926934183501,-0.33903716855985816},
{-0.049586553402654464,-0.791159765051891,-0.33754923667249737},
{-0.0713769285816625,-0.7670910478219561,-0.33033085765947845},
{0.3347565165995572,0.017309624019458476,0.2568948329397156},
{0.34156467445878597,0.009274938652469379,0.25605657936517634},
{0.35728907500193785,0.019155091194831553,0.25821820210671337},
{0.36198906516866297,0.032225580026445,0.2630280633020757},
{0.36368551264995475,0.03386702984256104,0.2710627082975679},
{0.36124890901939444,0.034334313982312126,0.2783278555648549},
{0.35463062362182096,0.03453922163931521,0.2842852563720114},
{0.3409683502662556,0.045117260311351555,0.28156714866846577},
{0.34398964578621843,0.054758299914813055,0.288813288397598},
{0.34025644247828574,0.07325941163879834,0.2889475565592174},
{0.34324997621972764,0.08180839375360323,0.28433688939164814},
{0.35724765597100044,0.09413268664753996,0.28504300174500646},
{0.3585520781570889,0.1150442210863877,0.27667088290820563},
{0.34253644613502965,0.12328081599553592,0.24930467387474847},
{0.3321930221672203,0.11208189344959173,0.2468202480813713},
{0.32572096020636865,0.09980817860433489,0.25926405760446547},
{0.3221356823124716,0.09847635904560481,0.27099952584261294},
{0.3302725787477772,0.08413257232714741,0.2776861208752394},
{0.32751284909340217,0.06605740645496957,0.2762869244755147},
{0.3264424328518649,0.059460884481413796,0.26753660120672984},
{0.33209409393904105,0.0451451432043632,0.2698303237355431},
{0.32955398310263434,0.034722730278179945,0.27352899772719574},
{0.3283113250570727,0.02292432393887413,0.26620751734811426},
{0.33351089974824066,0.009995114098027884,0.2616622403189322},
{0.35276505569065514,-0.010094924124690681,0.2530651523784247},
{0.35079646607401277,0.008546737778303117,0.25913031639712053},
{0.35840759706917796,0.007935418761921872,0.2671965743994504},
{0.36384207012745834,0.018135902133146958,0.2690728418396854},
{0.3597700554067825,0.019457265474196708,0.2802919065753268},
{0.3458196708640521,0.02258056808017648,0.28689270367791603},
{0.34166040058982144,0.03394743711536314,0.2865513998564471},
{0.33357513611174466,0.05488855536212866,0.28435115434133257},
{0.3325466254839224,0.07160045334194953,0.28436347508472193},
{0.3279253395502776,0.09472114902226561,0.2854965871984366},
{0.338776291665736,0.09816648443442222,0.29133183872987906},
{0.34887407738586673,0.09401126618358445,0.28977954830211594},
{0.10827828809442132,-0.556813702326555,0.19216144850134387},
{0.26408777844093223,-0.7856525457435367,0.10012245477108035},
{0.2565535285870429,-0.7679628777329687,0.11379753545281293},
{0.22814227361058587,0.3863886974652823,-0.305626706880658},
{0.26530966747618756,0.37763059312168634,-0.28269272299875825},
{0.22746716444198145,0.37812997472623716,-0.30285165836804967},
{0.19978901335174062,0.37501550604120965,-0.30872613930793},
{0.2144778318806772,0.37153515472999527,-0.29526808516910574},
{0.24368936572686073,0.3736288120566101,-0.28786842644881055},
{0.2530930347402325,0.37174103449014584,-0.2717953670349111},
{0.22426989806657605,0.3981331218012803,-0.29752632540183205},
{0.03882295245745388,0.6844459967615505,0.18504570658217398},
{0.05233605844425214,0.6956677759491502,0.1648873385386539},
{0.025999798538793965,0.6954707715438565,0.18887544770071016},
{0.0007599105601147657,0.7053516943318819,0.1911652998778663},
{-0.012930813014233612,0.710266967630297,0.1960887494667981},
{0.4427881337859072,-0.13764959692016565,0.06862503259128523},
{0.4393932138740353,-0.19270380450186805,0.05204312658164269},
{-0.37719102560812434,-0.49442755814809086,-0.25333800420219366},
{-0.37249897800219767,-0.5447800725233464,-0.24667684108775773},
{-0.3909817716906978,-0.4971602558981112,-0.24729081399885203},
{-0.3942826663864403,-0.5802745055571443,-0.24205906003748295},
{-0.4104805927152356,-0.5256432446499976,-0.23070236461949875},
{-0.44062116182103944,-0.551895753885271,-0.1949361931653182},
{0.023483183913545348,0.17554080391567226,-0.3031696380884258},
{0.043487759927094936,0.14261639168539694,-0.3045153178194641},
{0.030617274678026836,0.11900831004712921,-0.31669772402536556},
{-0.0024700970992240054,0.13642133556285704,-0.32193259827847687},
{0.035319383285928097,0.07490815700935564,-0.3259150063371112},
{0.0619389416711652,0.08335906188463825,-0.3128555006774526},
{0.06202599536723582,0.09818447843552482,-0.32043741227057937},
{0.04887392423978075,0.14032917321720537,-0.3124119666643266},
{-0.23496327916747856,0.8895558841539238,-0.09323031357435609},
{-0.23128618586570002,0.9093563323178041,-0.07456407180423645},
{-0.21012885169318632,0.9274169495774118,-0.09011275540741287},
{-0.2234082810818551,0.9312708041660445,-0.04829342620521371},
{-0.2403782581048267,0.916679190639817,-0.016930046956581995},
{-0.24855898523680173,0.8947139388854123,-0.042913342052432794},
{-0.24915808550094348,0.8817689639750519,-0.06534348646660496},
{-0.24066069497187065,0.8640170059320904,-0.1010707408602441},
{-0.40670888774821584,-0.37201754524641756,0.17818739669979766},
{-0.20883251443054318,-0.3009933392453814,0.3402968888748717},
{-0.19748261736014447,-0.32395662539712894,0.3628825995400595},
{-0.22156269279199153,-0.30940558097558957,0.34192237176398943},
{-0.01594923472106663,-0.35536862786406753,0.29282467362928977},
{-0.014894878898415032,-0.3589861253996625,0.28675397765311966},
{-0.002578384077814376,-0.3537175313850235,0.2760243047013779},
{0.007928718687059001,-0.34617258095965714,0.28122294766089506},
{0.01763403715033698,-0.346829453898178,0.2780023168129002},
{0.018550088724093305,-0.3586285093686566,0.27270168695311453},
{0.012289371549174337,-0.37943102376752413,0.27275408915600674},
{-0.10686531757742107,0.7433377254741922,0.20903651001044013},
{-0.12973206166893392,0.7437439339136783,0.2087866678150516},
{-0.13256609931286548,0.7352688751968023,0.20628120847182324},
{-0.1274427566318006,0.7061804839776368,0.20737645743354552},
{-0.15065639174746281,0.6724557312579819,0.19636989975798239},
{-0.16546170648014882,0.6706969533728,0.18296473440482794},
{-0.18730331946308756,0.6956571582454825,0.16934237996037005},
{-0.3677069089504537,0.5243387512825858,0.06098133985910673},
{-0.3554240743965434,0.5855866359814889,0.029310360614416758},
{-0.35749542222152547,0.609269612058425,-0.0022626933150680156},
{-0.34178350390775025,0.6239749042828862,-0.012799388387121625},
{-0.3363484837094468,0.6344865998367284,-0.04003879692346608},
{-0.36100416425668524,0.6188914008323431,-0.03470077455834847},
{-0.37253350731847773,0.610916088125897,-0.05672779576531887},
{-0.37161247623930904,0.6044707744065145,-0.08257256669385754},
{-0.3481210544155937,0.604819392905765,-0.11516621418815365},
{-0.34984096623580907,0.5863715343733291,-0.12890219633527006},
{-0.24701496352903518,0.5587156343522912,-0.24294084046005748},
{-0.19927378699708972,0.528435568976028,-0.28311850630217045},
{-0.1732730556642373,0.5182881773103647,-0.29941799350570186},
{0.3385049994566342,-0.1740714641650119,0.26636506817692174},
{0.3378557461069372,-0.17094694510208805,0.2544879363563793},
{0.33204092149048564,-0.16445003979697329,0.26242472828039753},
{0.34118501134087675,-0.1662478462955167,0.2762772374410899},
{0.2101684263841631,0.30646656681580814,0.18164685576139974},
{0.2235341179750829,0.29867991011407347,0.17512667841317509},
{0.22900992932130707,0.31321612119774933,0.17340288561722447},
{0.21296013238884723,0.3207629350864168,0.17861933984370076},
{0.22539816666307833,0.3241142474072597,0.17251703192310083},
{0.22759081383752544,0.3321082436174778,0.16544595150350888},
{0.23983459959232575,0.3221230433779425,0.16035857770130865},
{0.2427482328294915,0.3026124689357866,0.15645628262851266},
{0.23384082512892848,0.2852642874808309,0.16056502478723053},
{0.1999640726612808,0.26016373641143953,0.1692690653221172},
{0.19641148080611104,0.278134097877833,0.1786372531018097},
{0.1856158896992997,0.2998901466604529,0.18657913077202135},
{-0.4833535880408713,-0.07796364718713814,-0.07190778879846278},
{-0.47662567596845734,-0.054214692397887135,-0.08805822656049395},
{-0.4802752305973551,-0.10117163985491362,-0.06530719355335785},
{-0.2688828689804918,-0.608853463731455,0.193394603309032},
{-0.25969006454472204,-0.6127460632705637,0.18742910695435214},
{-0.25690709259465583,-0.6088533022454676,0.20817688822758912},
{-0.27083838779383007,-0.6130659075166489,0.2155123817657037},
{-0.2587093569563761,-0.6148348579566254,0.22199414988432087},
{-0.24487374645433277,-0.6115542265650709,0.21867465242779982},
{-0.2611803262924134,-0.6354580772260084,0.17233537718586708},
{-0.2742110980704034,-0.604431249648705,0.16310992814527475},
{-0.2890574674281475,-0.6001687143976088,0.18159956055285725},
{-0.2874958968681513,-0.6053598195737038,0.1980380478824003},
{-0.28070812555241653,-0.6117589716736788,0.21289353588639007},
{-0.2775246789778225,-0.6101424055733227,0.2215612739463593},
{-0.26836839056094025,-0.6088845890931072,0.22414430287112538},
{-0.2631006475349582,-0.6158770662083609,0.23570596862817356},
{-0.25297730878214625,-0.6191447287877611,0.23486937665945146},
{0.2923317764308162,-0.5514447628317164,0.12074081139991034},
{0.2920437863581418,-0.5416526360885723,0.1400071457230676},
{0.2918965493843679,-0.56074926032552,0.15368865928409853},
{0.2887035390146552,-0.5734462469421228,0.15052947916632597},
{0.283439605783085,-0.5778723515622783,0.14355808659649844},
{0.2743447978438438,-0.5920742101587957,0.1498154943710848},
{0.26389652909875316,-0.6136984630027734,0.15434184354269798},
{0.26806832303626527,-0.6294042204136499,0.13923807295798687},
{0.25803815744851794,-0.6909984543087184,0.1254317700378303},
{0.25899288704105816,-0.7005292595400713,0.11495912328309806},
{0.3569181661243951,0.4673812443562938,-0.006824064760185807},
{0.3406707963984624,0.45993890977662033,0.008742162383181167},
{0.32345449268755044,0.44654614590984903,0.022504961828274307},
{0.371435167812432,0.4801570966919644,-0.03566738399503638},
{0.3771002832321324,0.4654865770751722,-0.03443162522580238},
{0.3816818117406571,0.44833345475680747,-0.023711857102086727},
{0.38564561703851274,0.4832833984751958,-0.08037423670002697},
{0.38977360046510395,0.4790143793492263,-0.10697889056607728},
{0.3868319834061844,0.4772744868253009,-0.12812027693493322},
{0.3765656424371352,0.47681235005139627,-0.15427770810793612},
{0.35385557375039317,0.4756123274937161,-0.18716287074402507},
{0.3359171068289073,0.4538837961358208,-0.21451821772001795},
{0.34305179572898664,0.21347135399725273,0.2797071328805226},
{0.3356135142351138,0.21055765914043395,0.28554753071540373},
{0.3318276250614033,0.22423987176580476,0.28147713722904816},
{0.3427663193131942,0.22612635319473906,0.2704475593010264},
{0.3326941864920787,0.23361894072630218,0.2702825514317903},
{-0.3763027411249281,0.5880116880519151,-0.0973183568416834},
{-0.39431841215966446,0.5801926098509983,-0.07373099640537026},
{-0.4086655210273483,0.5568213718485459,-0.06641465276805716},
{-0.3952207193635641,0.5866027854944249,-0.045435478011077536},
{-0.39318254416008686,0.5825831729766412,-0.017270267122083155},
{-0.38745128747967655,0.577245926169226,0.003338641514079559},
{0.4315901833431105,-0.09295733532405757,0.0029252756331675706},
{0.42261464874163773,-0.0938089019308821,0.003802984909008582},
{0.4142358016761671,-0.10400006373596946,-0.014675058754166562},
{0.44119612630452065,-0.09630864658249265,0.013890851989811657},
{0.44196392311781973,-0.07251000510471554,0.02612104211184884},
{0.4318066011263427,-0.07056613665543766,0.02857697306531498},
{-0.037898825521922544,-0.6395019253907871,-0.3137136329645519},
{-0.022842214157554133,-0.6424053255159129,-0.3212910048891004},
{-0.05591639507941804,-0.6373899489662794,-0.31664086395929647},
{-0.059801268788921794,-0.6326653991181768,-0.31518138229071857},
{-0.08701003004712919,-0.62434556030737,-0.31551091250882085},
{-0.056482022060644205,-0.6376762359992321,-0.32444798688511106},
{-0.0046000494639016135,-0.6447484723185228,-0.338423093657614},
{0.011166798520949237,-0.6373325619459358,-0.32582507564068725},
{-0.008855852236696653,-0.6397570881244954,-0.31220697720192203},
{-0.05207604900610788,-0.6192941946931234,-0.3200007669097028},
{0.07719474175128775,0.8265191299309874,-0.11044250470462999},
{0.07551506331489204,0.8453458611499209,-0.09707768322570771},
{0.07464324296554993,0.8375497607051503,-0.09488483419377645},
{0.0768683318249276,0.8406898631658526,-0.08042135023683374},
{0.07231298423210081,0.8467534261359765,-0.10354402093327132},
{0.07978881440525389,0.8223620067829437,-0.11937350954509329},
{0.08208340810847255,0.8146831132927483,-0.11479219458053888},
{0.43274311467454785,-0.2636949398725492,0.013557261249053975},
{-0.1814210266385696,-0.3359615606277581,0.3532122587291581},
{-0.18987395752554873,-0.3207518616097981,0.35470511381431724},
{-0.1813587451054387,-0.33364435251186486,0.36519455936136425},
{-0.17177210396914708,-0.3480553333371733,0.3646006266488174},
{-0.17901757438135812,-0.34852318480269573,0.37121186084574626},
{-0.18631509321466003,-0.33578291569185426,0.3680541489755691},
{-0.19160842858241225,-0.3245288754286518,0.3452011184440865},
{-0.19345415923492257,-0.3316675759806272,0.3319045471053799},
{-0.18633280355287696,-0.35246619984208916,0.3632133865866028},
{-0.18741033261471196,-0.3457060277564803,0.366736393571447},
{-0.21143191718449938,-0.33163547851582753,0.34603523818983134},
{-0.21577781745174485,-0.3201450811995874,0.34222628839216535},
{-0.2562516995902164,-0.3123976549686985,0.31088626299204497},
{-0.27441633082419675,-0.30701590921010047,0.29254231750523946},
{0.18943180995461667,0.297367949082155,-0.2576351303892231},
{-0.2374980397181468,0.4949643566933532,0.12109912649525618},
{-0.2468098731378885,0.5347957742680428,0.10657967383239823},
{-0.23954450382736903,0.5388315576951247,0.11882600192909142},
{-0.21771400575495367,0.5399361792185595,0.12156287387940298},
{0.05239250310886692,-0.32887992306174374,0.29215556281518884},
{0.06074922234444062,-0.3336793684109226,0.29035909388807996},
{0.07381078482562224,-0.33762513933617894,0.28558923340922676},
{-0.23197835730375638,-0.6868169743991893,-0.3368840153333941},
{-0.2300610554242118,-0.7041023378050693,-0.34109759377013066},
{-0.23231074539887153,-0.7053382686843688,-0.35391891822253935},
{-0.23725219961298408,-0.6907142750928636,-0.3583973039310966},
{-0.25111159848833364,-0.680816127486991,-0.3500005032360201},
{-0.2582293069243626,-0.6925412606219488,-0.3268020350542743},
{-0.27690055369768196,-0.7009214048873572,-0.2917183097570441},
{-0.28938746404327903,-0.7242864001815095,-0.2700601151083061},
{-0.2782203765474051,-0.7449331262861287,-0.2522101201973192},
{-0.26590445117739137,-0.7766636768616225,-0.2691914246123765},
{-0.25066810484670443,-0.7887224326095722,-0.2685333373417272},
{-0.2178238151639378,-0.8115077218941807,-0.2814849183038592},
{-0.1916295237519165,-0.8335776165683825,-0.29838263459712694},
{-0.18556924255952206,-0.8444784168583543,-0.3151060820122661},
{-0.18206508162684523,-0.8553328547338421,-0.3437412521838809},
{-0.16599980222534902,-0.8500683138050039,-0.331600669786293},
{-0.1508005594250693,-0.830907493576049,-0.29181324545666787},
{-0.169863302414502,-0.8215003791741448,-0.28080492524654554},
{-0.1262933822417161,-0.801204622677263,-0.2480975172486145},
{-0.10789319501018772,-0.8081729448885154,-0.24671921203609418},
{-0.31980307459535123,-0.45960134563064786,-0.2235454257126241},
{-0.3337918789917672,-0.4705225717732028,-0.23575002136807555},
{0.32748062945170425,-0.4016516804846181,-0.2007645347963549},
{0.3472981196992879,-0.4103540997851844,-0.1662210629945899},
{0.36531897847136774,-0.44906059216075445,-0.1555171853045102},
{0.39080126010426924,-0.43827570056301224,-0.10946944539011873},
{0.3776276284726886,-0.4078517617961061,-0.1227765143804103},
{0.21922161237257495,-0.08865670319125034,-0.2134891195806759},
{0.2231151032718374,-0.15200197533059423,-0.21503182496516413},
{0.21464119832984457,-0.04806162369446371,-0.2133813361833882},
{0.22911821948712088,-0.09818394191958012,-0.2246017990477096},
{0.27058650790025923,-0.28126707689415953,-0.24071125336600613},
{0.2178735007900561,-0.15422151204674925,-0.2069516058617839},
{0.22296130061778874,0.48220925424464817,0.0471664346229008},
{0.24863949343834602,-0.21526067929423737,0.25613599328667475},
{0.2448305840121769,-0.21717398970763432,0.2595877923879563},
{0.23046418288104484,-0.22753180080202645,0.26213053799573544},
{0.19023075125290856,-0.24203210462649077,0.2724793111868755},
{0.23850571865360215,-0.21605437229794072,0.26536486646764346},
{0.253275693452848,-0.1927751334999213,0.26190455535497653},
{0.2557204415016907,-0.1922186081664158,0.25190703437205175},
{0.2485844160925846,-0.21191877034493367,0.24912381913059675},
{0.25692695005905986,-0.21207536925634207,0.23722192470878492},
{-0.09371731440947606,0.19104595004673525,0.2383329695498479},
{-0.0812869039736999,0.21349688578177764,0.22413261107316035},
{0.4223134061939232,-0.011670881811269608,0.15380292761866737},
{0.4296405205216291,0.020059019633051418,0.15828408939883593},
{0.42343667084963377,0.042415201340205724,0.16586105548360042},
{0.4223483817214843,0.04342012438979813,0.17435571031255873},
{0.4355749828817283,0.06629327692522967,0.16177041887880533},
{0.3998394916403271,0.0704919412811091,0.2058002766413262},
{-0.4013246687042327,-0.29733709782171824,0.19792889716625922},
{-0.3856540886784013,-0.3501754159332824,0.1732404200898812},
{-0.4025658276923723,-0.33707315367125174,0.18840075751610538},
{-0.19624560176246952,-0.3438537516094436,0.3181692024029504},
{-0.20762483191254252,-0.323869410215071,0.3165380451937117},
{-0.19083945780848144,-0.4037451763252455,0.30568997114101454},
{0.38593028389955303,-0.46598250372952027,0.16309913726913383},
{0.33447079689237574,-0.9366815579075265,-0.08865558341341707},
{0.35379048533582436,-0.9602451395322038,-0.10301290626980018},
{0.35501482640830867,-0.96256591415112,-0.1275988078719823},
{0.36886113535701326,-0.9701055142907479,-0.12275626063789274},
{-0.30248358665056724,-0.7773939844904789,0.08657929751692733},
{-0.30662624086662676,-0.8134128453929828,0.08390612966380621},
{0.18938228581448563,0.4908432629814194,-0.25235403395945877},
{0.20232957039942812,0.4995418735499817,-0.2551728324257429},
{0.18093713493990995,0.5129319622738837,-0.255184788763253},
{0.1722108050891389,0.5309060931631921,-0.2602168419283029},
{-0.15543555360670536,0.5484127784267623,-0.2984974893808076},
{-0.13264044661151103,0.5289123361679041,-0.31366200100732305},
{-0.10346203439125738,0.4927713249272784,-0.32819265994777624},
{-0.09181266261974243,0.521994753491319,-0.33288952982275916},
{0.016884134471806093,0.4513904546160899,-0.33261685967072585},
{0.2774708170265975,-0.05118841206047282,0.2845668018789016},
{0.2865201528491006,-0.05279298251422988,0.27200983954944064},
{0.28525783813421146,-0.033183602020792985,0.27485256981408546},
{0.2992493984164904,-0.04857875707113611,0.2721676740411338},
{0.29646968912081323,-0.06009120041187177,0.27671003263605776},
{0.305303863988525,-0.0745145019805696,0.27079344316257037},
{0.31218043134914114,-0.06971578650555726,0.26217333496960427},
{0.31405519973195417,-0.08047336253605913,0.24720902984552626},
{0.30929214822476453,-0.0881709395300268,0.2511413868097552},
{0.31513667988843985,-0.10697325236782193,0.24229716050173927},
{0.3076994523031161,-0.11893085201841173,0.25021691034205396},
{0.30072225473700676,-0.1268113713878806,0.26225775389430245},
{0.29744579754574335,-0.1409142603223141,0.2588258728146701},
{0.28922567739452737,-0.15178717878168216,0.250574486001563},
{0.2814832157953414,-0.16467764367205245,0.24877935464588885},
{0.2760227031216021,-0.15971146722816737,0.2553727966991992},
{0.2691096601135952,-0.17538066931106738,0.2531188114097578},
{0.2627858890350664,-0.19180117326358592,0.24455821823998156},
{0.32319057677588353,-0.551369219261875,0.17303619131146963},
{0.30577222116016567,-0.5480607049773087,0.17738971116753885},
{0.2948030708636439,-0.535179399104681,0.17985697270031414},
{0.29434601983593267,-0.5488808221880985,0.16702575935599653},
{0.2898773413475486,-0.5441071519148335,0.15633210521628643},
{0.2857110188102655,-0.533239583741204,0.15699980834003718},
{0.290950918252325,-0.5295523795042837,0.13334917408169727},
{0.2910521157835895,-0.5091478462588106,0.14453036504126826},
{-0.4318314455330136,-0.21276085389963317,-0.12585405164509603},
{-0.42541754083816874,-0.17925438242651184,-0.13191457612887927},
{-0.42004385981726744,-0.1305843321209336,-0.1372367675551984},
{-0.4128046905457862,-0.1487593590153491,-0.13023304379085268},
{-0.4164702131640902,-0.1877701313625666,-0.12508214225115874},
{-0.4232874896695647,-0.22359024444855816,-0.11757514634485666},
{-0.4320738009405548,-0.2516121907065857,-0.10947368121006298},
{-0.4446432061903035,-0.2525161191448056,-0.11275936860039233},
{0.16554179821783105,-0.3357598954393956,0.2502460298777581},
{0.16911037931056316,-0.3478702034639883,0.2350339181316583},
{0.17708984603155195,-0.35457331362604383,0.2508331738043897},
{0.16886316020006123,-0.3440045147147437,0.25792344449627996},
{0.16006746680568812,-0.3428583934173778,0.26500915533384345},
{0.1373745305073136,-0.33058597470965084,0.2657346003221468},
{-0.25504180726396786,-0.3246676418249449,0.30968871159493433},
{-0.21503681031381933,-0.3439155157499703,0.3425264770313309},
{0.09709434018657964,-0.9932145383588474,-0.30751837498452783},
{0.07348451726190892,-0.9919111690189002,-0.2954367200986101},
{0.33778822796570357,-0.9521934322672595,-0.1362891699062965},
{0.3526525509530536,-0.9585261190721421,-0.15076675838934406},
{0.33685114709172725,-0.9359711895484757,-0.12636919938156882},
{0.3211005656328776,-0.929209557714534,-0.11363120913548286},
{0.36286219334202097,-0.9418660155979455,-0.14529949836359426},
{0.3317804913388481,-0.9526405327834088,-0.12837760698057687},
{0.32525837722118317,-0.9394915830101038,-0.11390546971200986},
{0.3164510324003419,-0.9179978289048304,-0.09329230082052321},
{0.18453132962256852,0.42743979426697964,-0.29662523465487656},
{0.15284690029498543,0.4562066382003382,-0.3031034564562191},
{0.19661910397748017,0.4501701676918141,-0.2915901206929218},
{0.09853402388559104,0.4786029024294031,-0.30993045930520746},
{-0.006737540674409233,0.5476028741422639,-0.30621010263253085},
{-0.04533812905211007,0.5652595512030629,-0.29692230193989205},
{0.37936885856804853,0.4898091598388775,-0.06478464083443924},
{-0.2765879433863849,0.6024506335756368,0.11185367231557417},
{-0.2808223928245775,0.5804378422588927,0.11005487777776608},
{-0.2772490702057828,0.574624597442857,0.12177020382621616},
{-0.2718715390189728,0.5970628076571336,0.12939493257896018},
{-0.26563326095943945,0.5580978718325337,0.13041193308055318},
{-0.26819525633435437,0.5535346613594943,0.11778263884006498},
{-0.27740674321148856,0.5983029541706291,0.09767229056721478},
{-0.26750446283922946,0.6199664374854524,0.1137026496863563},
{-0.2605405570572492,0.6179487688775519,0.12659149865444536},
{-0.2552640406675601,0.6048759693089485,0.13941511790772676},
{-0.2518940257196044,0.6412598225398931,0.10199004977635044},
{-0.48596851257295287,-0.10316251984984831,-0.03710927219025659},
{-0.47996187022614323,-0.11048310780636816,-0.02172887929645363},
{0.2226926633658078,0.37060399146752876,-0.27075546739535},
{0.1797447309086457,0.3681898407636559,-0.2803082782797014},
{0.054775701623560866,-0.25021155580668425,0.31797596635816394},
{0.036782684310588176,-0.24273274664202787,0.3278964234656693},
{-0.2327705916215346,-0.011621599900119683,-0.23094909608481534},
{-0.09599187322618628,-0.8922736380756685,0.28494145999361103},
{-0.10883272685898503,-0.8875267160438723,0.27241523737176676},
{-0.10733860432130687,-0.8912985431877904,0.26933471049149954},
{-0.09937222221492403,-0.8998683559325545,0.2815880207323296},
{-0.13367359783665383,-0.8846494160914505,0.2663293234661053},
{-0.14454465177031275,-0.8751912370580888,0.2802201717374897},
{-0.11327314848680788,-0.8826372996267726,0.2832656221614538},
{-0.08685397933815149,-0.8937995850393389,0.28712061140162926},
{-0.09348962022973288,-0.907667494863666,0.29147372541791444},
{-0.10719553729819292,-0.9043234780972643,0.2914832499039441},
{-0.13134370457149178,-0.8986817059019971,0.2806170394874976},
{-0.1549144797594602,-0.8892634064706539,0.2642544293238486},
{-0.15799251316859392,-0.8801463081531206,0.26668815489164754},
{0.35967372157847893,-0.12164879823597004,-0.1876037699857787},
{0.45117921978936576,-0.09447079899594328,0.028553142195696248},
{0.4526834437005152,-0.06411089473505695,0.048054009417678976},
{0.45039124041487233,-0.061431693467974585,0.040466434128509324},
{-0.044001900500962414,0.4469270244222945,-0.3400065891276152},
{-0.04832071255623919,0.4685498589518438,-0.34197566532703544},
{-0.20874606949414856,0.5263806555374813,-0.273607742331773},
{0.24827478477279077,-0.7108925016631956,0.13099478169240308},
{0.22530460890638598,0.4761331877969911,0.03370894462262442},
{0.2398357544296169,0.44775694978199976,0.024845909446714533},
{0.22816689384920855,0.4884039045274041,0.03638982980608795},
{0.23724909844458242,0.4934261707916949,0.025532885710572908},
{0.24943673275932401,0.46891886293218077,0.020024642241088415},
{0.26074789550332494,0.46013895479307027,0.017670846924984274},
{0.25234378013046666,0.42531841553334054,0.02257253946434531},
{0.23088921718695007,0.4350029819848374,0.02670977008852734},
{0.32426496429782004,-0.42229321885189397,0.17203939355681927},
{0.29101389778738807,-0.3821608030832864,0.17187882336501162},
{0.29988799262861515,-0.370118905622489,0.16403834508354867},
{0.29541710539439114,-0.3621143724515968,0.17535092720438566},
{0.2884689646819251,-0.34697373206619697,0.17831636557125358},
{0.2955682732770674,-0.3415488642369398,0.16945841082949803},
{0.2762459096907497,-0.33822073365454286,0.18606803718375706},
{0.2832521662353179,-0.32402665719524437,0.1896593527412466},
{0.2791968483158069,-0.301636594240575,0.193743546905073},
{0.28345622290366396,-0.2877738710911833,0.19825109145842343},
{0.2774381511736187,-0.2766981527919101,0.19644769244516053},
{0.286870919536946,-0.2721123693401007,0.20770404238294504},
{0.29323396145781755,-0.26946315772072005,0.20749894243012812},
{0.282046874134893,-0.25957246821768387,0.21455479429615068},
{0.27538666293785613,-0.2425742024619167,0.20948305382489604},
{0.2860281879134815,-0.24223733631787633,0.2238703567673106},
{0.2882774720483573,-0.2255631304423902,0.23034519479977364},
{0.2838610130287219,-0.21480855358914008,0.22828691777809587},
{0.28725945800971214,-0.20443979863188214,0.239201781160268},
{0.29596690249922675,-0.19511884656589473,0.24241396161653062},
{0.29200791947042704,-0.18386813057673435,0.2422931286640948},
{0.3012585975093181,-0.1752085082500368,0.24697471898993337},
{0.30171319543739256,-0.16232444649154615,0.2513795680170052},
{0.2922469516663341,-0.1635735087313952,0.25327472081849656},
{0.3085038246301402,-0.12602351312787774,0.25510687496158435},
{0.31287458948980496,-0.05305981686015478,0.25196624554660757},
{0.31482640049988125,-0.03479125345720322,0.2530162561213103},
{0.3095485263530091,-0.023354190075505862,0.26868122344667383},
{0.2979946427331799,-0.01944538031801002,0.2756332132626408},
{0.2864828070897123,-0.013282179431288791,0.27004339812139283},
{0.28256828264059863,0.0023740538394568115,0.2716061437044285},
{-0.1206622893697696,-0.9274313664514133,0.30495086890029494},
{-0.10893669090019063,-0.9141551604080445,0.30234885262312255},
{-0.06827106752472331,0.2515339422464564,0.22834855974172427},
{-0.09253746378891205,0.2609069321094567,0.2418113766547673},
{-0.09415630556680028,0.22284191200877257,0.22490725616721216},
{-0.11067331014564892,0.20332201600047894,0.2294295129439356},
{-0.12754337621321574,0.21448624668174784,0.22138666084809988},
{-0.05562990831379677,0.27503349042752157,0.22776467846948165},
{-0.4078621824231247,-0.3521084223250959,0.1822547304516563},
{-0.440130534456855,-0.27721333983747193,-0.09605711622109167},
{-0.41765795641228554,-0.20120358544851663,-0.11988679275585698},
{-0.41234810591510423,-0.16208744136974343,-0.12491472271619065},
{-0.4107841449375323,-0.10794907712986637,-0.13192942965249121},
{-0.13997711517266512,-0.9247242822913194,0.2777496071788286},
{-0.13204142815277087,-0.9432220708036705,0.28211593329865703},
{-0.13398452635638533,-0.9181550758850039,0.28075562314964714},
{-0.13795716663760121,-0.9128469273651365,0.26809215337468006},
{-0.14464907052206158,-0.8962562076202901,0.27011594251398235},
{-0.12993499324740768,-0.9274138590330883,0.2978158155943363},
{-0.14532242778018487,-0.9407041696025622,0.2978804971067132},
{-0.1616178321504969,-0.9322927384895141,0.30341004822726425},
{-0.15685245078297674,-0.9096940388264233,0.2727041995475886},
{-0.15292546322782685,-0.8996822528938142,0.2595188346841382},
{-0.02955570829355886,0.7259897469391285,0.20117214136452097},
{-0.036552919498020385,0.7182289067472123,0.19514019033882682},
{-0.014932460512337476,0.7174879389183756,0.20366931286441217},
{-0.2174799381907496,-0.32121695612704987,0.25940254140028074},
{-0.33734112744955447,-0.7554941441226177,-0.19962127031359395},
{-0.3289507298863576,-0.7701353221604731,-0.23516105328723166},
{-0.32565824414844274,-0.7657278596101851,-0.27020246819337074},
{-0.3306134172346246,-0.7547862065526393,-0.2882069541986681},
{-0.2520516987253102,0.5455303714799906,0.12947830821918752},
{-0.23318302152116474,0.4360635093344656,0.14392184228224672},
{-0.24554678923974393,-0.9972828654620097,0.32753591024856155},
{-0.24240307990452176,-1.0,0.3205998469880961},
{-0.23636885851333453,-0.9977987005763364,0.33727304038893785},
{-0.2628426088633043,-0.7669558468662783,-0.2545859317905001},
{-0.24366650908520507,-0.760847196371044,-0.2415653729388016},
{-0.21085107439859752,-0.764126693111056,-0.23744900056718185},
{0.2955359325208789,-0.028256981144543968,0.27810503464974284},
{0.27008791672712007,-0.030307680011302587,0.2925096930861653},
{0.20241670483849244,-0.953073692384256,0.20280573042524006},
{0.1957601610732207,-0.9783194947872214,0.20894824091983322},
{0.35316368491281447,0.23817116802738675,0.19461276329286925},
{0.37102563509890385,0.20045881951175415,0.20991832124284115},
{0.37458627256842975,0.18769747541715684,0.21635713940086465},
{0.36229277993935494,0.18771571270964824,0.23815499286845743},
{0.10338528392614232,-0.8988491668708699,0.17688364276822277},
{-0.2424485520212598,-0.30216669536699403,0.2608138152520061},
{-0.2295146208400995,-0.3243375846525682,0.2623230441663554},
{0.08671152319952927,0.19948607466995505,0.2712627522516102},
{0.08855378827775869,0.19809565269634508,0.2800785283408431},
{0.07587496883473173,0.19844970222432795,0.28939514365814417},
{0.07247376796787854,0.20457829198936767,0.2830551612988203},
{0.07376419824308994,0.2087137324563874,0.296645133553185},
{0.10298628923569592,0.19613922127469682,0.2823877928335301},
{0.09307339009736129,0.1989241183077174,0.2666108275390908},
{0.08194273681497341,0.21082570888089516,0.2711665406002048},
{0.072092534611224,0.21374718481252508,0.2848055907834197},
{0.0741548137231274,0.22006155358192256,0.29305547853910485},
{0.08902665430815113,0.21483210929513555,0.29955661966416386},
{0.10914253985051464,0.2235928887816008,0.3068962364069947},
{0.1269262405140668,0.23108207342094383,0.308921118763935},
{0.09296726830589075,0.22778158244016966,0.2945060041098322},
{0.11194678864182091,0.23469454470518286,0.2884522280404673},
{0.1193765294392974,0.23243545348379954,0.2754583366872441},
{0.36906964988853636,-0.3362541711120045,0.23917738402728575},
{0.36552907386571387,-0.33595734605597005,0.24914843936921938},
{0.3578543545758097,-0.3355018153338371,0.2565874507372587},
{0.3647523209545644,-0.3211793468905243,0.2519927101251909},
{0.37005451255383276,-0.3218501607443471,0.23830656659091765},
{0.3675324360900256,-0.3329193941063391,0.2307260329407223},
{-0.4228026577399918,-0.1390110013492213,0.16979891359547708},
{-0.42748234316862443,-0.14406269099785035,0.15422863974075626},
{-0.4197456982522062,-0.1492841109184374,0.17705746543507048},
{-0.43979196633550066,-0.41922624935770875,-0.16016003174228063},
{-0.467694558512766,-0.457154772365185,-0.10905843486732474},
{-0.24876573723376547,-0.6714334920234707,-0.3550692137201965},
{-0.2671902111078637,-0.6673768375949327,-0.3516786316194188},
{-0.2647630108488427,-0.6736822906379765,-0.3478305320939007},
{-0.2641647413876095,-0.6826025864077003,-0.32632113403360374},
{-0.27802031134520666,-0.6911662393119736,-0.3038616066065902},
{-0.288312690867307,-0.7117612516539625,-0.28109933757444017},
{-0.31393726502802793,-0.7313840875423314,-0.29624159919416027},
{-0.30494961260305786,-0.7425014681639308,-0.26920935805623386},
{-0.3006676437882745,-0.7402820121907696,-0.2551118385308795},
{-0.317462724050101,-0.7513617835758434,-0.28147379276925766},
{-0.3247946000896176,-0.7395264150063693,-0.30036208520882596},
{-0.2999896172478198,-0.7109542658037222,-0.29834919849848485},
{-0.2864209016489466,-0.6900454065077437,-0.3159989061640407},
{-0.27429533532336586,-0.6809889376791944,-0.32843590671547124},
{-0.3775785909153352,0.26963066862275986,-0.16289560755506222},
{-0.044868206953763104,-0.4135387628167225,0.2431143603406789},
{-0.23093175174608938,0.3328381464689581,0.2030019752089485},
{-0.23188492066155458,0.3155155786039287,0.20613432634225842},
{-0.22293876801051554,0.3081225259354052,0.20206211826336085},
{-0.21471011672457357,0.317121770292006,0.19430738691636038},
{-0.18981333866064265,0.3428260218513627,0.1893589930544234},
{0.17029526574415357,-0.3768024005491217,0.2634917395048991},
{0.1715612277050594,-0.36018152860817837,0.2631582380063976},
{0.15991751431754822,-0.3527815054820039,0.2640426319521883},
{0.13727666681176154,-0.33975511082419707,0.2634390334533729},
{0.17708433425982614,-0.377246259659038,0.24992065367419858},
{0.16604760420241768,-0.39336329213225363,0.2602426786238697},
{0.15786892326788748,-0.3895922756054956,0.26903885966342816},
{-0.2594481553484616,-0.6049525975971655,-0.3040507088225822},
{-0.012405564966697398,-0.10946959306480454,-0.35254182946696316},
{0.009033982967219861,-0.12296440651390515,-0.3515776359456385},
{0.02870764338288093,-0.15011703439298654,-0.3508371557619875},
{0.04899172826754614,-0.1089704547516426,-0.3386604228137992},
{0.018523406351908717,-0.07606857512864036,-0.3410831652096433},
{-0.02328691681927281,-0.05813955195019062,-0.34251533131098094},
{-0.04409018127805519,-0.09197154092711042,-0.3501534134675071},
{-0.3060676480875202,-0.8293802494124408,-0.08356578838381457},
{-0.26547465622208305,-0.9766740726282983,0.32215394032191524},
{-0.2533993640965481,-0.9763010559336576,0.3214008355462407},
{-0.2498041569392452,-0.988444921171383,0.3152181819724917},
{-0.25292772408477004,-0.9769840279824746,0.3354105120065206},
{-0.23705953089396897,-0.980777739664901,0.3453837973424505},
{-0.053421633120443256,0.8656394089009627,0.17804153766895525},
{-0.028832690907104764,0.860396834316034,0.17272022804111964},
{-0.32194433204155043,-0.5789610858393007,0.10284927634349557},
{-0.3151451111568315,-0.6157593737334157,0.09982808281468251},
{-0.31439524778738975,-0.6775200954318017,0.08969893800318102},
{-0.3232797786605488,-0.6589389822747982,0.07035503409848601},
{-0.058089429143257876,0.9033817066928004,0.16790858306304188},
{-0.05540897635977358,0.9311912075104026,0.15457974108706232},
{-0.024983115697136488,0.9401594476198417,0.13667691901005866},
{-0.0004988631495388029,0.9400826684697158,0.12257519447458654},
{0.017449844320841578,0.9436430413996967,0.1058834641822505},
{0.027510223724338922,0.9528285099095284,0.07970232962856626},
{0.16492987150418156,-0.7757480757487782,-0.21788018811602533},
{0.17549007872351047,-0.7573965117355568,-0.21508560511098773},
{0.1818885221974753,-0.7521831979865711,-0.21665167390565765},
{0.25329332304807123,-0.7718376447569621,-0.24340676684262558},
{0.260222008948694,-0.7740120333907615,-0.25578313896747984},
{0.2716525268358649,-0.7715623812674611,-0.2694544895353864},
{-0.38378114444980055,-0.9628236702222962,0.10959708837662593},
{0.3274937204407569,0.1012347511285452,0.22395505935489443},
{0.33425916206911066,0.10579751539030381,0.2316749065414058},
{0.35702807752452903,0.12911063543583837,0.2503745227905145},
{0.36289704669268374,0.1422004154684922,0.2530739671760363},
{0.3941435345218601,0.11901438914462635,0.21752885516481635},
{-0.18079468198851092,0.9684668501079134,-0.04896975183076227},
{-0.19169471203281957,0.9477752808319805,-0.08229885325735344},
{0.11620626415842006,0.11235756277887672,0.2933580182867571},
{0.10364729494060326,0.12431054201789454,0.29769441425372134},
{0.09928925666411195,0.13414757355200538,0.29940911921325275},
{0.11689946931927707,0.14774419116723075,0.30715095186701435},
{0.11223094873433494,0.1550291969613294,0.29089045184293993},
{0.12116020166431725,0.16360160410596905,0.299426687188823},
{0.10409066746774197,0.17168500405833673,0.2956266743656669},
{0.13359791190416584,0.17930363352783518,0.30877173360156634},
{-0.37619197873613713,-0.35641407858444346,0.17750111100101673},
{-0.3845602474070292,-0.32960228812980163,0.1809992045226824},
{-0.30155825919420903,-0.8157344306290593,-0.0826016766678914},
{-0.31090178530137424,-0.8129732008548544,-0.07122086565499497},
{-0.32077387310603966,-0.7928423109269698,-0.05169997735780537},
{-0.3234049685474194,-0.8073114893897819,-0.044189202466917966},
{-0.32536324430902835,-0.8321703341828046,-0.03961640801301141},
{-0.4202081176265886,-0.9660114121116719,-0.09300846582479941},
{-0.40913227821282494,-0.936639571550818,-0.12363159755709077},
{0.35663240604571683,0.37519788109093954,0.0340661856236729},
{0.3989266071042565,-0.638575464345294,0.042721897227216483},
{0.4022905631404636,-0.6465261769988658,0.08409762335978184},
{0.38391638365215963,-0.6411561017900765,0.05864056860036321},
{0.4161012484928425,-0.6438672390359713,0.08949982578078942},
{0.4111090536816549,-0.6264659669378616,0.008153761628108599},
{0.38409446232469996,-0.618755501874733,-0.012016709365199607},
{0.38737509371625467,-0.6021202013733025,-0.05038769229150449},
{0.39410215586241965,-0.5838921656411344,-0.07242162871091964},
{0.4033650324678017,-0.5698621440712652,-0.07979764991981779},
{0.42737818683160506,-0.5555899296422498,-0.062216738472092664},
{0.4237807507427139,-0.5289092859950775,-0.056326126994410974},
{0.4270035085311473,-0.5071396203315383,-0.0522506063279573},
{0.4295894155186746,-0.5083006567721692,-0.05871556609258943},
{0.4443332094022227,-0.4971127577696767,-0.045886104658752876},
{0.44890525379621443,-0.5072342925540247,-0.07871343406321749},
{0.4335076275853017,-0.5281699000914722,-0.1229739756210629},
{0.46011605087426716,-0.48495576223380965,-0.03715899925027953},
{0.46891488580853874,-0.4705723402671303,-0.011454859243743098},
{0.4582037539979224,-0.47506474763398315,-0.04474757214038415},
{0.4454152972559767,-0.4448058379844693,-0.02420355324852945},
{0.41508043819683743,-0.43167358501232916,-0.06303365464814661},
{0.391504901297058,-0.38004363892143533,-0.10236907438716498},
{0.36022834201477844,-0.37341234434021064,-0.14397471088216815},
{0.38344152135748943,-0.3365412687621174,-0.12943995848441747},
{0.20999381328590366,-0.9184510903238783,-0.2056859679352606},
{0.19756189848066655,-0.9098858161852846,-0.21327106037737484},
{0.17099100368523298,-0.9100130724553485,-0.2243110743373285},
{0.17759137582469753,-0.9216634726376249,-0.22737889482017068},
{0.15150800828745453,-0.9230798332979516,-0.22856911029134322},
{-0.28759405485066725,-0.6067085792249874,0.21027250250939264},
{-0.2801706268804064,-0.5907852683169281,0.2245258305147437},
{-0.2715889597892821,-0.5944478331918851,0.23000999026155036},
{-0.271443871004103,-0.5541254227847239,0.23990084231298167},
{-0.2592892871339679,-0.6122438439747485,0.24362444145429885},
{-0.008150284898545605,-0.34252266192488,0.288066282905169},
{-0.22746704332749088,0.39023485172209765,0.16164658674911783},
{-0.03784238404453131,0.5644999827382634,-0.2944563163588983},
{-0.07080866045461698,0.5803845890673436,-0.2720924343199265},
{-0.035686859523832055,0.5637531387318219,-0.2861725473556981},
{-0.008276423515591828,0.552167016346954,-0.2922528283751431},
{-0.10550230678775444,0.5959240626572027,-0.2574785718493115},
{0.019373327289033283,0.5437473983193108,-0.29532190568642624},
{-0.30608146895073934,-0.9713146969285784,0.2147946371092178},
{-0.31568613489796016,-0.9748885868731445,0.22458244728942395},
{-0.3111676061102471,-0.963231216233217,0.2324038978469838},
{-0.2996108656758128,-0.9654902267116067,0.2262731397076009},
{-0.3172235707397035,-0.9702094273363786,0.23874235990072945},
{-0.12008534774535139,-0.8210664089561374,-0.23441512188910005},
{-0.10618737602959122,-0.8262017472838015,-0.23944668953378012},
{-0.1102625322901656,-0.8530258584818327,-0.2379901666709571},
{0.08067219587640016,0.07267046374370288,-0.3324819030688446},
{0.07803102880896792,0.06033547134069695,-0.32638780224858815},
{0.05992062393209198,0.12519963711825088,-0.3198741990799008},
{0.03896829515809991,0.19351302990777483,-0.3057839134893346},
{0.17990177603133495,-0.7795630239009477,-0.20278893057051753},
{-0.23297464828988068,0.4164295680972435,0.14307880681014815},
{0.37459628257482913,0.1555751853341609,0.23519161132311248},
{-0.1247240104211603,-0.9174531377319368,0.2996126489273244},
{0.2740233737973429,0.1907569889333212,-0.228747614989416},
{0.2585339321785488,0.13738281356981558,-0.23203819583012492},
{0.2984971244437244,0.11239987316996791,-0.21748062609980756},
{-0.3482965195649179,-0.6960974805997946,-0.2316729198387984},
{-0.33569153109034017,-0.7145831109171514,-0.2262985896867243},
{0.22255047176673046,0.2456065310870015,0.2022016655293954},
{0.22202681414368797,0.23981869800340772,0.19929135550386387},
{0.21360334701254394,0.24257709008634812,0.2128714186805712},
{0.22189469417066326,0.2569289819139992,0.21081362717926327},
{0.2092599997112694,0.2594981102949601,0.21527772668997994},
{0.19350491895533836,0.2605669053021772,0.2242494323737001},
{0.2243946821136627,0.22200906927721714,0.2024642842411245},
{0.22151462627537796,0.23279160976647253,0.18424980483263062},
{0.22998559259736423,0.25515208785081633,0.18523001627652855},
{0.2294848936071273,0.2560756315244592,0.1938651501031721},
{0.2339422648891739,0.2520453194976063,0.20267493739957188},
{0.20730364903261486,0.2812041472922636,0.21758210835636552},
{0.1814008323908895,0.29163272005893764,0.22029132051930586},
{0.16980216615699184,0.2830899795900251,0.23152580504192283},
{0.1751875602240145,0.2708960228863975,0.24003577979152232},
{-0.24834497911930142,-0.8986635504149072,-0.18974040808281373},
{-0.251850904711353,0.77278855499342,0.025854642290718797},
{-0.26602171868921193,0.7641930479157361,0.023352359546846706},
{-0.2578302516766709,0.7174970575646213,0.005665648217217876},
{-0.2622318571726943,0.6895242721032533,0.014789575692163237},
{-0.25266656299655826,0.6810256258081474,0.012843407129973608},
{-0.2562159336312438,0.654089090615508,0.029012455089638022},
{-0.3436321317463624,0.4422919590593351,0.09152300616041578},
{0.30529498863366805,-0.8911502119339708,-0.08642986667102283},
{-0.02505764148029442,-0.2851567579990102,0.30486288347257373},
{-0.04388554984708317,-0.2876584479193235,0.2913748991808851},
{-0.06452037060976724,-0.2725675749654434,0.308375048585702},
{-0.12227693144957924,0.6368996158890587,-0.2358757785807174},
{-0.19763360250867715,0.3434973212255553,0.18469374468554062},
{-0.21461795709656117,0.3273648880887048,0.189546159563383},
{-0.19118821867037886,0.35732681225860463,0.18662721641197555},
{0.021456255359160164,-0.006467700245581803,-0.3154620768089517},
{0.005660626746697085,-0.038939824222364715,-0.3325436268378745},
{0.045335141561344314,-0.02970098140649335,-0.3174487422320984},
{-0.39081491948150104,-0.7562743817313891,0.021822002528351037},
{-0.3871492746862987,-0.7583810089325662,0.006714698375259036},
{-0.2879241725802893,-0.9098517723893745,0.21647797341570824},
{-0.2985952834886481,-0.9094951295239239,0.2199390537116306},
{-0.31215019947245826,-0.9167790814094735,0.2138925827583773},
{-0.32619268202354806,-0.9268842434270393,0.20345274315686274},
{-0.32879433389484114,-0.934842089086657,0.1744605051566728},
{0.3274047214759836,0.4832860736180651,-0.21170290395135544},
{0.3254594761461822,0.47410644091434173,-0.2197137807592898},
{0.11834081462410563,0.17099092772307442,0.23937556345561886},
{0.08840754465528852,0.1687776326528117,0.24603172262926287},
{0.07548780830489707,0.17051594431391365,0.2556503294917855},
{0.068792915867263,0.17217887389116168,0.2637944811100356},
{0.06724352368800958,0.1619250565853938,0.2739430074272414},
{0.08741323930936373,0.16197644525123384,0.2833759585247125},
{0.08570866653313018,0.14446023656404192,0.27244733483656636},
{0.09089255796018537,0.14848422620200882,0.27900264069907676},
{0.08320768630123496,0.13888128241785042,0.29006865284058453},
{0.08472900222925517,0.12943939647068514,0.2941058949535915},
{-0.34794790000325937,-0.968264425297966,0.1977221345452174},
{-0.32929010862487207,-0.9367335957045395,0.20778850167914006},
{0.1640193986338431,0.3006185897636002,0.18749193456509813},
{0.1343070946160992,0.2928079407062593,0.18150504981635804},
{0.10128974188807,0.33165409083827635,0.17585695523220493},
{0.21896286401250298,0.2572321282965117,0.15420601576641135},
{0.22708221265798678,0.2029310053047355,0.16786106474885892},
{0.21193571521832244,0.19254709403763934,0.19099767742300625},
{0.16850005364548573,0.19736040062153423,0.19892287741539366},
{-0.24644660403491783,-0.6576957569034653,-0.3313546267612382},
{-0.10113489701195828,0.9660950512290364,0.12925258374352683},
{-0.11952200387851196,0.9426960323247222,0.1492093014723938},
{-0.07805410111940925,0.9520418681064695,0.14484935829869655},
{-0.09853891839837839,0.9361415774508689,0.15620040064471602},
{0.2740474872674395,-0.25417483521267337,0.21045181676221775},
{0.273297948994788,-0.2672188998372003,0.20364760043596944},
{0.2669175611415789,-0.25043170157892697,0.19627762857714975},
{0.26881929980909347,-0.23761815820132945,0.1973093508637861},
{0.2672270299129775,-0.22742059326436245,0.20661196470853999},
{0.27631310379760066,-0.23713960828914568,0.2188549196604318},
{0.2769418909232179,-0.22681583992825596,0.22383171380798456},
{0.2707144536729927,-0.21072895965113728,0.2203092135916664},
{0.27503490289870697,-0.19592591422153652,0.23334452397582692},
{0.2880129686251707,-0.19267608415725157,0.24278957164863912},
{0.28085353730957036,-0.17986027041416094,0.2393509432169962},
{0.29074297104657343,-0.17316461835494176,0.25045663204063057},
{0.2628998322728449,-0.2329983309536098,0.19880313874300365},
{0.2627662939853919,-0.24204604660420048,0.19310997788189643},
{0.17712028295294227,0.3725275955502109,-0.3045229363458801},
{0.4587274923639585,-0.08071506881242754,0.03925619439490647},
{-0.3791283687486242,-0.08700220275757843,-0.20018796820189413},
{-0.40907404020382443,-0.4892383993031064,-0.23002075032786481},
{-0.3927706614004797,-0.4310481625322508,-0.23511422341331054},
{-0.42460520470219,-0.5060567218606241,-0.20985559349842947},
{0.3372230695063222,-0.9569379213851675,-0.12725091818449027},
{0.33443663198197504,-0.9434263303919085,-0.1097893714416055},
{-0.16358439575544304,-0.939135425665023,0.3258174773000197},
{-0.18316785881031947,-0.9312836008681337,0.34053657020195155},
{-0.4557363915364049,-0.446203879546903,-0.07061811814483651},
{-0.4533658887950578,-0.4325671390382702,-0.07872338351237175},
{-0.4667456041690888,-0.4485337324405682,-0.08305073307682138},
{0.4892752027033069,0.3000628750472547,0.002722732895952817},
{0.47750548881176513,0.3074805681401494,0.013882055253132814},
{0.4545546859518021,0.31841541222603154,0.03849066369746914},
{0.4590224528942839,0.3295275243672939,-0.0013606442762665839},
{0.49729991843539334,0.286475173158383,0.006096714874676516},
{-0.29826194347613394,-0.595205375644988,0.19511391805605735},
{0.10254621973444301,0.19170800966019166,0.26703973219665317},
{0.10974915771233018,0.1910452212349766,0.2593000466690785},
{0.09057122421834844,0.18052230028019856,0.2566636827473618},
{0.10841443990509046,0.17275371832256006,0.24650417325820106},
{0.31115489971282206,-0.03920503733396932,0.2671559649232654},
{0.3004634851287786,-0.03923389339253628,0.2763969973616361},
{0.09941953229717604,-0.46215020964501313,0.21262945848873585},
{0.10461207597344774,-0.4527387181229258,0.21020642180592797},
{0.09756328593214793,-0.44126696393896103,0.21427865963224427},
{0.09605109821204375,-0.41351428387833883,0.2189926725196728},
{0.0982478377813805,-0.4828395712375139,0.21346310121337336},
{-0.08795953259323706,0.7850012153865681,0.2174239487678821},
{0.12124420518756115,-0.32847075581650265,-0.27594185123113085},
{0.0871558274583187,-0.16074962345650987,-0.32599456262125637},
{0.0462629709880984,-0.1773123785029431,-0.34696307824066364},
{0.0840467090590296,0.22660004046636986,0.2842173727624907},
{0.09202019867367112,0.22480053199051248,0.2737699550060571},
{-0.04564207117807344,-0.29126086882566615,0.282654627179455},
{-0.09519357999665932,-0.26938907389921174,0.28975507042613996},
{-0.11975755031438957,-0.27009441706931453,0.29203264223140346},
{-0.1332254731593744,-0.24821662272594885,0.29728070840230963},
{-0.10331611480316974,-0.26124707046955636,0.3011073079809473},
{-0.11522397676965854,-0.24524886512282854,0.3203012806456586},
{0.4054856813272742,0.3288443090270881,0.048565617211323985},
{0.331715444358184,-0.4252507645911306,0.18042389369425474},
{0.3299411840039658,-0.41955581994730795,0.187765294219801},
{0.315332104493318,-0.4251282084132246,0.20065845337638114},
{-0.3605678429301912,-0.6534053387593574,-0.21137436708455684},
{0.012120322280623461,-0.632442334911676,-0.30955201158183454},
{0.03255493229123893,-0.62423013713551,-0.31618452262000335},
{0.4390353545516406,-0.1991647218047776,0.057508262854177414},
{0.44471348021740004,-0.13687795100336558,0.08031943133066526},
{0.11495752701536133,0.7877743398786299,0.10834598950100233},
{0.10648511156912027,0.8029576146895034,0.11961057734895689},
{0.10054238155143203,0.8264505568187971,0.12479840393454573},
{0.2297200958228739,-0.329321511806167,0.17546252039608526},
{0.24273822282309201,-0.29755059717069254,0.1747959009283021},
{0.23741382265093292,-0.30323986749439424,0.17749935802812783},
{0.21808465009295147,-0.33456838276828527,0.18640673598127222},
{0.22818038961563744,-0.30987926824722034,0.18773238507543338},
{0.2177553227947412,-0.3543123150862273,0.18013910571872402},
{0.21411156360045483,-0.3510688074108283,0.18711924296724766},
{0.20428916248431556,-0.35293502341075905,0.19157236886767978},
{0.21188274568965898,-0.3039826584150352,0.1955858619164695},
{0.2694004060721326,-0.2717286531363908,0.18533947084130367},
{-0.3500886315575919,0.021596962243320895,0.17585818125081934},
{-0.3760820673360031,0.028082357422206335,0.17211384284661477},
{-0.35928534565410786,0.018323301309417207,0.17687286251615997},
{-0.3621962442535669,0.012625358550750657,0.17284423228087262},
{0.363004121463961,-0.16425283247178768,0.27130182123646857},
{0.36738864450478415,-0.16414365094582012,0.2603162769250082},
{0.3662916425701731,-0.14671611718901903,0.2583898765849663},
{0.36319646508618586,-0.14635639334091521,0.27139900711583703},
{0.35920441142703136,-0.14772849727904003,0.24648563211707558},
{0.36678348532889377,-0.15642459419072047,0.25342230201240135},
{0.35864861490528455,-0.16302573657584826,0.24573459372459427},
{0.3619811226078646,-0.17399324651470918,0.2557349513363757},
{0.352904956738491,-0.16414105760835235,0.27868640332751143},
{-0.4248027371241659,-0.5024721334693967,-0.19223068986804764},
{0.2765757841289828,-0.5948845582333475,0.1680136615700416},
{0.30008335667624797,-0.5675280766058121,0.16623516645828698},
{0.3166731638127842,-0.5670427166595567,0.16225565664816222},
{0.3205334215332966,-0.556313105327468,0.149308432620465},
{-0.1896033643807868,-0.529671530665154,0.32929628918231524},
{-0.21842941948870123,-0.4968449513206043,0.3127607880834692},
{-0.2276118080782875,-0.4782109897494279,0.30823397251482676},
{0.2905995438672114,-0.5990433429872083,-0.13388196947432612},
{0.292364036444011,-0.6442404172165993,-0.13642181683359564},
{-0.0026662228932576126,0.807355918222049,0.21396076065486178},
{-0.013028872192823084,0.8145532222513121,0.2203872283220771},
{-0.32049281418192715,-0.7893053821501642,0.08566579465951062},
{-0.3271321533151002,-0.8372541223586413,0.08538195860137898},
{-0.3221422490551541,-0.7677798556768816,0.07054325664081017},
{-0.3140042987112995,-0.7311816117368088,0.08683509769532251},
{-0.31037022548903015,-0.7406478958793642,0.09153342731863832},
{-0.29677107403117436,-0.7035576466321757,0.09640357803248509},
{-0.29885239042865136,-0.8065756699891997,0.1023366422639047},
{0.08340045594899208,-0.12027831553216548,-0.3244462445363003},
{0.0826517378551711,-0.08209738567684387,-0.31617357981954536},
{0.05295037663788509,-0.06113422034317508,-0.32602106757133653},
{-0.03156151936787581,-0.02413167286082205,-0.33146166009861106},
{0.18968650629129574,0.3711423602515365,-0.2813081357688488},
{0.22268538905952281,0.37021322406317414,-0.2824490703912792},
{0.290318382951949,-0.6379373970874438,-0.11543206474444519},
{0.2901524837225591,-0.6026580846369405,-0.11244816704185326},
{-0.04312968387350655,-0.5169447158868367,0.2198016047010237},
{0.16436066102140734,-0.9819280765964629,0.2155285930464987},
{0.18586983597606385,-0.9903103276165615,0.2118090363669041},
{0.17652367509752626,-0.9769472293631094,0.20297535870604816},
{0.17465824846659933,-0.9687612943080426,0.20214638526374198},
{0.17120772531709938,-0.9949510662372338,0.21637610656752257},
{-0.3185705476706796,-0.9904304508805791,0.255857223851396},
{-0.3118879855381054,-0.9871921309425234,0.2625985509472452},
{-0.31133253323648946,-0.9760100677461392,0.24869473280129867},
{-0.3215990165681855,-0.9861789391729345,0.2439337476773023},
{0.10189968296151983,0.7516294381005987,0.1276956590928901},
{0.1034816188168538,0.7660742598019252,0.11766531077099918},
{0.10105233092648339,0.787667346912754,0.11652470124535906},
{0.11185909750106346,0.7670821820287697,0.11160749223991172},
{0.2943842580178825,-0.6208188455192637,-0.09923705684990787},
{0.3012275932621563,-0.6513640422017303,-0.09364497240557462},
{0.3060012231639247,-0.5912503638965876,-0.08426015900604067},
{-0.12491332511871471,-0.15219715664408343,0.3699521405307327},
{-0.05330838363496555,0.7379785526943641,0.18315544723106217},
{-0.013682679022400062,0.7228249434968099,0.2040590677941224},
{-0.23737191809962563,-0.9463530748038754,0.314196480316333},
{-0.23073061244959356,-0.9475171901023439,0.32364716087536155},
{-0.227276542982819,-0.9430497471942446,0.3182102570280084},
{-0.24364257728684427,-0.9627424523323338,0.32420778072857237},
{-0.24174183090822554,-0.9533867276586776,0.30386845594975065},
{-0.23182366328955392,-0.9524981998840925,0.2883505237406767},
{0.15815822966384036,0.31855288248479463,0.22869004523492886},
{-0.44704738725927373,-0.42910850971716885,-0.06828157845640602},
{0.286848588787157,0.10116034221024654,0.26789672983220986},
{0.29453027959712,0.10331544070541339,0.2517880457595767},
{-0.07369706469348404,-0.28960636839199416,0.28336943321593444},
{-0.12783344329316151,-0.2790922016775824,0.27960046394902915},
{0.3254269728415985,0.20354305419528324,0.2860616032951713},
{0.3229979080568684,0.21753676266615699,0.28575709915547565},
{0.2790825204864006,-0.7662590964505545,-0.2478509058353806},
{0.2695739652618431,-0.7709554393712631,-0.2503967313634052},
{0.3432248077786743,-0.15264401386884371,0.28018025282638204},
{-0.41281141877445615,-0.09006487693698191,0.18919067153522343},
{-0.4214324586990729,-0.10957739664784065,0.17674351755233877},
{0.2759417901426818,-0.41191879169933066,0.17156714478536522},
{0.28122408178123387,-0.3980732519338815,0.1777865470453124},
{0.27966822591285545,-0.3840001093557609,0.17273508050232378},
{-0.48124724556498777,-0.10022037477424656,-0.00988733601277932},
{-0.4799906041078118,-0.10630438378270197,-0.0033556580999956473},
{-0.464180852908311,-0.10407828244867999,0.030475208974275213},
{-0.44641795206489154,-0.08740269756785463,0.07802716005092246},
{-0.4394133571261404,-0.06991980173999868,0.08983928526229758},
{-0.3873090756948509,-0.026742139529726774,0.18889683609477037},
{-0.3938758502496859,-0.036365184069677876,0.18530172986620955},
{-0.3945588222985029,-0.044218307128912795,0.18867026594249175},
{-0.40759275473973205,-0.06399571485458587,0.17768583609682562},
{-0.4133474364499771,-0.07342552441215841,0.17867909815827945},
{-0.40842065302533304,-0.08111183457128558,0.18282742669445992},
{-0.4201238612502856,-0.11452582131960415,0.1616076388787499},
{-0.4261382846719064,-0.17128316317736347,0.1322370349605885},
{-0.43593255960364524,-0.20272548038879407,0.09762742189811364},
{-0.4407348012101838,-0.22454353554092166,0.06959706561985061},
{-0.44702266502950117,-0.2597242034261315,0.031183541759959455},
{-0.2680748483450432,-0.1432739424401015,0.2951159249975336},
{0.4247696250599063,-0.584355153403696,0.13504523484654551},
{0.4084707041197384,-0.5563241288709195,0.1373371449076324},
{-0.27424534478620566,-0.9841979480699088,0.31919167430477235},
{0.06847073113676919,0.3310807868982045,0.17479528366936367},
{0.3460808319522638,-0.2451880730854493,-0.12309418069048211},
{0.34322043065849106,-0.2379046077826773,-0.13002862165421944},
{-0.34346288805718206,0.18910354134579035,-0.20033400890447228},
{-0.34306707527813096,0.047489181367126945,-0.21081729461102844},
{-0.32394301329704467,0.04563868900280569,-0.22184772246529935},
{0.29065855212187525,0.628824239240483,-0.08776094679391616},
{0.2709826245279444,-0.8304847083874806,0.08683729900430784},
{0.25866212018026336,-0.8227111830462954,0.09553327692631336},
{0.25725072521404746,-0.7893998928866633,0.09745749401830271},
{-0.2608737759552729,-0.10164986573271491,-0.23723789269819112},
{0.20788114735872631,-0.9585121770944325,0.20384518279111252},
{0.3470256928386435,-0.3358493809869466,0.25659697416088056},
{-0.16365223899346687,-0.5287985650401912,-0.3013839897848767},
{-0.18113909547764395,-0.5035829148333224,-0.2998507483291729},
{0.4159343559121489,0.12523554437746243,0.19554641896406144},
{0.3020617735651465,-0.5566653710727354,0.1685412501019865},
{0.30961959187392507,-0.05399049353984369,0.26521935165693195},
{0.3051367684879394,-0.05968365440095088,0.2731814533222424},
{0.21918057793326529,-0.9089972884106996,-0.20249727306607795},
{0.22794202673665165,-0.8958476895062218,-0.18900274434227085},
{0.132526107095619,-0.9125013080431376,-0.2307189604919215},
{-0.2443695425807258,-0.9710828795441191,0.34222880098663944},
{-0.2589602222504871,-0.2603366570940554,0.27743328906426945},
{-0.2557491360742703,-0.27729407114465654,0.26276799649390975},
{-0.2568353588192264,-0.26488937097791765,0.2646580444258671},
{-0.2557954591796653,-0.2699757514288141,0.25361231683670343},
{-0.24644759738622157,-0.28642608354304705,0.25456737046362615},
{-0.21777137258954876,0.8076033190042868,-0.14209994249935518},
{-0.19575272528094825,0.8247428233793244,-0.16261924978551542},
{-0.21452835043451962,0.8431724849907658,-0.14395242050387602},
{-0.22878686617721405,0.8389152585915034,-0.12795099287425607},
{-0.16350992627989908,0.7286593833486844,-0.16839299959116052},
{-0.12624970346936365,0.7257031358717934,-0.18401030623969442},
{0.3616553203787727,-0.0038453186730716222,0.27789364205545863},
{0.35538395150313606,-0.006146639542552452,0.2848303533846891},
{0.3419469712856597,-0.0038398069013458216,0.2862963391138888},
{0.348733325349374,0.008327401560812683,0.2808503368060383},
{0.35697036540739524,0.007550567906669288,0.2759067142175826},
{0.3647813395615264,-0.0029903470492114084,0.2689874093779351},
{0.35988965277893353,-0.002423202949630397,0.25782901450277446},
{0.3374503079131143,0.0192329040677581,0.28378346416413647},
{0.33048384916516305,0.02101433673711138,0.274388386842736},
{0.33596829363726316,0.007133943620999611,0.2748801690442115},
{0.3315714498530507,-0.01093668258259992,0.2638771980574198},
{0.2995066073476436,0.601563321195588,-0.056619891253540666},
{0.27471278934953636,0.6305008685664597,-0.06249887149050253},
{0.2685994376997364,0.6478185727285283,-0.08499507642239094},
{0.32909026652831413,-0.9852840890094635,0.17626144150862877},
{0.3328662668101156,-0.995363799985498,0.15712351935523422},
{0.3391035929522499,-0.9742894260517575,0.03671659457665703},
{0.3234303377835492,-0.9628852718144277,0.0351547339793283},
{0.09244456366265513,0.7740887626077203,-0.068650441136504},
{0.08508641534036908,0.7829965357765706,-0.07730372088856716},
{0.08044276890951665,0.7903365785449337,-0.0768506623894114},
{0.07974231918979338,0.8017689397096577,-0.07278401707781461},
{0.0745395020299849,0.8179448996945432,-0.07036714129790536},
{0.06820591324087036,0.8326260986346561,-0.07799921553825778},
{0.0716230321639626,0.8258576780147991,-0.06632888564784625},
{-0.1077881781228411,0.7182543981602402,-0.19925731170795366},
{0.07429980157956446,-0.038808271575111346,-0.3063783731561559},
{-0.25535338385246437,-0.09706343314973272,0.29204115318038104},
{0.019975608402162535,-0.7996339334710212,0.1507636476592721},
{-0.012520774594587123,-0.7909871174080828,0.14367525211716908},
{0.046872588027165825,-0.7777269600971138,0.1650207153401195},
{0.4050760274992556,-0.5993036923958521,-0.054840778882847586},
{0.41411288109238176,-0.6076770276895971,-0.03629934240797077},
{0.4398073255652309,0.06956004814447607,0.15141509913073106},
{0.4349478584243362,0.1414195287285481,0.16374121724128793},
{0.44044563611446996,-0.01321304005573492,0.14243056699750326},
{0.441802987457725,-0.02099110506549838,0.12806681657386082},
{0.4390037022357138,-0.0987391700531478,0.10210040632535745},
{0.38326863042229253,0.494546963224428,-0.10028905306481017},
{0.19865983214692828,0.19362367011966755,-0.24864646442720084},
{0.4353654962470579,-0.41311711227969683,-0.00945559472636041},
{0.24688655135927257,-0.8257099045250808,0.1170527763600816},
{0.2293967254452625,-0.8309637459448499,0.13409474107394956},
{0.23985990933361803,-0.8334748381742945,0.1301624648527143},
{0.3079120199204397,0.47986148809287404,0.007919741872256067},
{0.2983036047360524,0.5003531143435067,-0.0024424282813864636},
{0.2875173755668755,0.5340324767518252,-0.009508412330706874},
{0.2891068502680396,0.5575317412700047,-0.01797976430672875},
{0.28425445451353787,0.5846586344446694,-0.02775546622510775},
{0.2931738599855158,0.5925877865941152,-0.04109862520875445},
{-0.31060228616487834,-0.9164893904218928,-0.11315056096787147},
{0.24646267189065835,0.2565819835866609,0.18035426773592325},
{0.24041258450121483,0.2521937325568275,0.17414502740669258},
{0.24095456015974243,0.23441749743296644,0.16843068107141718},
{0.2296743602289986,0.2177629067929032,0.17267217214858413},
{0.23741931423691034,0.21021892953309224,0.1622944313460569},
{0.2278392079710669,0.19702377776888275,0.18511079393433497},
{0.23754948894123223,-0.7668146486185048,0.147793995783024},
{0.24536629783906377,-0.7220434384355197,0.1331838113682522},
{0.24223193131813556,-0.7172459383550436,0.12554045010731085},
{0.24580539523716924,-0.7118473321844777,0.1154341927472915},
{0.36415145815586336,-0.2781464483686412,-0.10993121775814403},
{-0.2017650206997227,-0.04891116428959183,0.33836311329980273},
{-0.18204339894582128,-0.08240580160210133,0.35498659876396216},
{-0.25968799816152877,0.8477320673411292,0.017558005404106247},
{0.15860685048556755,-0.3996178420298272,0.25517644036267056},
{0.14493557959824685,-0.40202583183080143,0.25351209140858644},
{0.17114326584795506,-0.381650803775068,0.23068388403561849},
{0.2680687278136414,-0.4027024814907325,0.16159894625803656},
{0.27442921676854204,-0.39545581480732583,0.17292446638120149},
{0.27278634863799767,-0.3751560052246433,0.17713363688792835},
{0.2799445634966538,-0.3763300104774287,0.18015448619661045},
{0.29252227677548814,-0.37334231254209516,0.17839299279706256},
{0.2890109817743574,-0.35781147207811215,0.18169158844230107},
{0.27957699801649366,-0.35936530193479405,0.18303792686618248},
{0.27633478647862475,-0.3472298669030527,0.17828409493398065},
{0.30704920666452307,-0.5445895934268307,-0.09038381388679616},
{0.3206644068547787,-0.5560425429925326,0.15902333400220228},
{0.31331694847989155,-0.559430652870333,0.16853141220565243},
{0.07297573334822681,0.8290277095659578,-0.12148691490810742},
{0.2111493570781494,-0.7964975802474853,0.15101345054557158},
{0.4431930450254556,0.23488372766416862,0.10369703846794728},
{0.43319779334561603,0.25351736520096246,0.10220280012781764},
{0.43227903263194045,0.2413757692663225,0.10906853199116479},
{-0.16605850663137872,-0.12474154280606892,0.35975984301169484},
{0.02475256576519632,0.676039104254673,0.1973951275456673},
{0.0006053004761293905,0.684430069143641,0.20240203458022793},
{-0.01619296913394712,0.700219759958846,0.1960548884050314},
{0.3996640477391591,-0.3990057123962858,0.10856247846555807},
{-0.43888252612555495,-0.23837116204826195,0.08477506770075585},
{0.1613528208963765,0.4050803700911847,-0.3154121468290368},
{0.1853957842985538,0.41942731747288114,-0.3007558114189354},
{0.11478423024038034,0.3492822369372987,0.17198278634380937},
{0.10659652202667617,0.1866279515981811,0.29146902426334875},
{0.08690496216420773,0.17611613492984823,0.28128025393824496},
{0.07700492028520735,0.18002972658490352,0.26886191564243045},
{0.09866247642685057,0.18897668985310276,0.27809934014387344},
{-0.37929234289505975,-0.3054530010786696,0.2513520899013697},
{0.1554338197571571,-0.9684495551711508,-0.3234051698736997},
{0.14818233080469426,-0.9771832623817646,-0.3141703801436291},
{0.17261322391996167,-0.9850431933502554,-0.3118537382910993},
{0.15005507211340305,-0.9586614815138076,-0.32575074852779},
{0.1373747334272057,-0.9619633493751053,-0.3251284867109508},
{0.11939698503929908,-0.976233780021405,-0.3204241597955393},
{0.10738588890577136,-0.9761245177524438,-0.31382411169045726},
{0.26916151517646447,-0.5988731271948805,0.16407613705421772},
{-0.2863494515364029,-0.4828366528032559,0.24357203925140666},
{-0.2773562055343055,-0.5515402456713631,0.23440894186286076},
{0.3545868534823969,-0.17693198657327522,0.24439864033706982},
{0.3520925398595186,-0.15460247130218846,0.24165414986034234},
{0.07693109887842832,0.04830994664668182,-0.30903398790741615},
{0.0847887095482589,0.017224191557708147,-0.3031442677898883},
{-0.2671181532980517,-0.3721164320406921,0.28430302832988147},
{-0.047749148840162514,-0.7260368711000136,0.20955716845623093},
{0.09876954057404991,-0.5325128426153706,0.19847062953339806},
{0.45015018220726905,0.33234914033909396,0.010815664771204873},
{0.43265346657860165,0.32601450720310077,0.036499539348737814},
{0.43342551833518567,0.3402562443392289,0.005843151064724462},
{-0.3790329666519712,0.6019648284805084,-0.024787779803310817},
{-0.22264036315406543,0.3363979318874193,0.2030209721230251},
{-0.2112290557249412,0.341267490840115,0.19320373855848075},
{0.07883099426839012,0.7873544125670744,-0.06665406955559187},
{0.08581257957876072,0.7754262968580682,-0.0652733537397474},
{-0.3193201061290796,-0.7139398559219577,0.06932062179527106},
{-0.3220273528375687,-0.7357197345117886,0.04296200670464427},
{-0.32487154178813876,-0.7449433392124203,0.008990642571755412},
{0.4660581328231905,-0.46549001183962674,-0.016832452050206156},
{0.45701114704676604,-0.45659711238013684,-0.0004906629548460952},
{0.06220772128579297,0.7228080437757533,0.14861071860085626},
{-0.2627996897125371,0.7706022100221104,0.03766378107373593},
{-0.258448237302069,0.762253394038246,0.04531484372890249},
{-0.25696370936933605,0.773119179491568,0.047545367866643554},
{-0.2471776213521923,0.7703007656169117,0.05995700343157563},
{-0.2464639903387523,0.7565745799322248,0.05974066957856038},
{-0.24712274692632286,0.7786786798883241,0.04326872915185027},
{0.1512384594895713,-0.2582089559715303,0.28023154056348004},
{-0.1729046997526654,0.2153032032292986,0.19694814814400868},
{-0.1382956635776322,0.20178447816758563,0.2214738154729126},
{-0.4499428437611933,-0.0863394950753571,0.04437764280284345},
{-0.045726213876740654,0.8224421909501054,0.20093385922852888},
{-0.01787985706975128,0.8054527803634467,0.21894108093394077},
{0.2528364951260005,0.27780598597415895,0.2058165389176961},
{0.2418384685851633,0.27246987381828636,0.2016394350659424},
{0.24876492555419757,0.2694732590941913,0.18816280897616608},
{-0.06971833469069294,0.5012569216672362,-0.3403347817742829},
{-0.04835634146460416,0.9487419858853713,0.14059498977644697},
{-0.07466897873237462,0.9675508240319444,0.12802387723734526},
{0.3186617341331368,0.45958773831139865,0.013457218555080546},
{0.2925951653882086,0.45899943848506813,0.022591106103258287},
{0.27592339030179514,0.4892880551818059,0.008792138046631993},
{0.2703011727847056,0.5166011735721091,0.0026857515424438916},
{0.24044837064593585,0.546489011795685,0.007777963549817457},
{-0.37688021926529114,0.4525300516670857,0.0719432870306669},
{-0.38571601536732314,0.28850909235616756,0.11820628882859185},
{0.14243247136350531,0.3684326827539747,-0.28943121346575085},
{0.09271296824732533,0.07761767302093003,-0.33307125574131624},
{0.2126438950172819,0.5486145243581184,0.0191121879801816},
{0.24053246553625157,0.5893066282482862,-0.007407824917937943},
{0.46909247789830144,0.15000749802280988,0.05831577247146875},
{0.47078876176879,0.1922681025591279,0.06709527158357179},
{0.46447366418763386,0.18639370129983343,0.08856162087934857},
{0.46073320569675663,0.21416097246933816,0.09236817494739975},
{0.46824974627483695,0.21089841582187976,0.07564243485620344},
{0.4879221466748337,0.21590511993654848,0.04884441851883714},
{0.48475989619848603,0.18648107903028657,0.037559594989297826},
{0.49843911070901287,0.2280246677218773,0.024368292328589197},
{0.49075498804756945,0.18540588089118984,0.003546815012695028},
{0.5016184638263094,0.26280711116230404,0.0218088382331593},
{0.49667117274368067,0.2694755294596844,0.03984690907419239},
{0.4598565928257772,0.20175489329725999,0.09627720249849694},
{0.04708035781081293,-0.9702185056111273,0.2005952613597558},
{-0.19696855434204716,-0.5392556687686418,0.33060050951091935},
{0.07820273515945518,0.21900094548930052,0.2771262308961951},
{0.2792507506385287,0.4528525306845434,-0.2532534439772566},
{0.3608468344087027,0.49235575455015756,-0.16814430160898494},
{0.3756441247751887,0.48567744736086815,-0.14528375347982847},
{0.27855610697749517,0.4573482208915336,0.023580124907913207},
{0.05765546317488183,-0.6209940865005397,0.22315234863368744},
{0.05027078015509696,-0.6367150830890638,0.21433916694433003},
{0.06309557974345677,-0.6045979000004175,0.23644302360904046},
{0.3517482166750497,0.1336956093328954,0.2616802353824426},
{0.3485039791254841,0.12642462625950018,0.25018422536573454},
{0.33194134519354135,0.12114306343270669,0.23740782482763326},
{0.3251269063793313,0.11526720348748702,0.24941997486971},
{0.3326020672355632,-0.0016691462565567622,0.277804481604698},
{-0.3222089162077307,-0.7696181887838007,0.04406687364428363},
{-0.32047595483236724,-0.7754956699633406,0.01982601660147449},
{-0.31681774689184505,-0.7949153809150141,0.002007284102747452},
{-0.31980781612141373,-0.785730844136833,-0.02322101619393221},
{-0.1035670714643525,0.7535333047709597,0.21727896091144508},
{0.09351420965852912,0.093691017160123,-0.3239518477492008},
{0.07446610664873839,0.11382247441377902,-0.32184226280467665},
{0.3193072988029126,0.11222471293168558,0.22730732359313638},
{0.09683764864803063,0.14230854308591082,0.29451714876777435},
{0.3191130906549786,0.4330680292619132,0.03420830391661117},
{0.4473613532029383,-0.08571099267503335,0.09819059896692664},
{0.44823731800515293,-0.05009505737187843,0.11194326835353756},
{-0.06984346614513391,0.8789119273268181,0.1793243993509179},
{-0.0770833621035582,0.9206483462234113,0.1637794341750816},
{0.36813925687173293,-0.5652379397033623,0.07449346843071841},
{0.05162434295209627,-0.07603023601794846,0.3767407628351244},
{0.06039635846357535,-0.06606116525380655,0.3761147528435264},
{0.0618019781809281,-0.07451839251797517,0.3791459170696499},
{0.07584023659855965,-0.07563695601911981,0.3785887829764685},
{0.07391487954298856,-0.0690155492673963,0.3742304206655947},
{-0.24017521497353275,-0.27465312824527244,0.2518889596279555},
{0.13328601128128678,0.7216699872160838,-0.020035878266102373},
{0.11837420928884307,0.7166735363992036,-0.017609878527908348},
{-0.2853007179758895,-0.8423408268439202,0.13228575910763743},
{-0.2920022674608701,-0.8460259243261504,0.12284533078398946},
{0.31227020055957777,-0.5698665211914484,0.13058101422133836},
{0.30855434318398267,-0.5690198172251769,0.12451470492702177},
{-0.08120562127686115,0.9779021714372118,-0.08796362551933078},
{-0.10210582194917635,0.9008499049478871,0.1729172632562398},
{-0.09910710153279897,-0.7891001504587787,-0.3703078909736217},
{0.4631223908794681,0.16036255429374693,0.07905084734728075},
{-0.2056776402516304,0.9457938233319256,-0.06069674949142898},
{-0.2556149497180523,0.8851053005953846,-0.018024136831381963},
{-0.25774366331522175,0.8653957966649806,-0.04897035952803041},
{-0.252097758353568,0.8537672002782185,-0.08059488924079578},
{-0.22426347474894795,0.8684436375065206,-0.12452068203336902},
{0.30694442244448716,0.10901524798978904,0.23838833055849498},
{0.3187296177426575,0.11720296576516351,0.237428595962755},
{0.44729391580469835,-0.48546203355301776,-0.022670615641459755},
{0.43705031142522205,-0.49225138573157595,-0.03929927396925316},
{0.4365472007692531,-0.5338259382988316,-0.04696450489499327},
{0.3219035802027187,0.23101868804609685,0.2751790201119424},
{0.3260748471859563,0.24304550887764192,0.2738728141431387},
{0.1841720519857455,-0.9943350460662871,0.19067388208227018},
{0.3057196574712861,0.49800271448276806,-0.20622843017656584},
{0.4215539992151111,-0.5748723328835554,-0.06880136572779141},
{-0.3494047065289681,-0.5235192725788906,-0.2373591304280031},
{-0.355300708663885,-0.597325943761467,-0.2167606525117332},
{-0.18724250830236774,-0.5577998207578847,0.33816730304088916},
{0.008901470965712751,0.9618601353938144,0.09024821984022799},
{-0.015497852701437291,0.9611410945997985,0.11253181678329592},
{-0.15482124497474267,-0.4162787550587764,0.366813578561357},
{0.45650009382999884,-0.4846081965807001,-0.020530522594221893},
{0.4653159092283207,-0.47701039880356866,-0.002407995644217222},
{0.23793208961674003,0.3514352276153676,0.13921852890388736},
{0.4618893380629299,-0.10488299899583502,0.02452120680970748},
{0.4405895084427049,0.14431417567571533,0.15739472975893454},
{-0.04723496789479818,-0.40275338463620275,0.28372907525863683},
{0.22774647995487537,0.5212613659422172,0.023118595831276734},
{-0.3838755330094014,-0.006309317551457996,0.18665758215204256},
{0.23930204642867794,0.26065995629034344,0.1917865481576534},
{0.1641875873520667,0.2791763879349698,0.25267892464264846},
{0.15462016623549213,0.2922948614777955,0.25256297451651416},
{0.14987083360037173,0.30081741832310605,0.2473255472974319},
{0.1488548870073278,0.31223446062959653,0.24098913144113107},
{0.15183257387385396,0.32423696507115296,0.23916465744411233},
{0.33323008411551697,0.26631242799467975,0.15807047849704145},
{0.27984897866585723,0.07042353071731386,0.25709262777642095},
{0.2874482765628185,0.08181674215418563,0.2564909947320567},
{0.28352969902790415,0.05765051501049991,0.2533954528421903},
{0.29103321023658474,0.06942606364574226,0.25851774161470614},
{0.22413319805347623,0.21168254503046455,0.18821790650767595},
{0.22915830094662365,0.24458871996824832,0.17727400433279333},
{-0.3170991914699931,-0.8078915215585236,-0.020022630040693535},
{0.15779303547791532,0.2845919341980893,0.24462662880377672},
{0.15693543014509045,0.2980180119866045,0.2349484867323158},
{0.05905977719303434,0.038402154502696816,-0.3181222705378794},
{0.06531580596228148,0.045718852984218974,-0.3157715455803503},
{-0.4327714034073434,0.11320207712264886,0.1464591568612937},
{0.17858175026171982,-0.3678707561391558,0.24080971519715605},
{0.1827729968862596,0.2597457341828383,0.24349126757272518},
{-0.2617906732056472,0.8614549701856787,-0.016910574083805842},
{-0.25869881893329433,0.8737958398286976,0.0065410478184767815},
{-0.15228941242000268,0.21211400159158988,0.20960600521850783},
{-0.2992835845750474,-0.8016504270558821,-0.06776556060793565},
{0.3695622225214235,-0.2662149488907554,0.25387177382278564},
{0.49960821082493284,0.22796647008437368,-0.000479923074280101},
{0.34148134981413353,0.007983727507516546,0.2799080278232218},
{0.2899896431652584,0.0921153835079266,0.24911257248150467},
{0.29695427775899724,0.07849752836055018,0.2536289732663714},
{0.250718601089983,0.4991724233583639,0.012115348618454092},
{0.24838299313320306,-0.7689501318782488,0.10835850254020565},
{-0.05224502709333545,-0.8102607674714297,-0.3598172704035353},
{-0.38672029034815053,0.5966205697815375,-0.061151266676509844},
{-0.18286586726509785,-0.3927035018218826,0.36176581982163036},
{0.35313815312828956,-0.2513181225988219,-0.13121107729873716},
{0.44708665703920863,0.08808280217798845,0.14524395568321138},
{0.44907567250843416,0.01569111265039955,0.13055729596694765},
{-0.37998783754475035,0.06484481986251125,0.1572884262957282},
{-0.4040328067728757,0.07293673076385651,0.14732995411191344},
{-0.37055324608961854,0.053367553906820686,0.15887569118864442},
{-0.4102823314815011,0.08268978852214215,0.14236146799344623},
{-0.40108774432542366,0.07648273675300309,0.15037984115089822},
{0.35467714964710806,-0.24981892387662064,-0.14398285636285857}
};


// normal array: 117kb.
const tgx::fVec3 buddha_norm_array[9996] PROGMEM = {
{-0.837390739307244,-0.1576478584422916,0.523377399637228},
{-0.7762285512539793,-0.1936818085698454,0.5999638266156239},
{-0.8787110763409769,-0.21492045573787796,0.42623472643732857},
{-0.7441523284278357,-0.3038522119662711,0.59490431615398},
{-0.7225530201965384,-0.6100020583571057,-0.32529159504197935},
{-0.7671787900589047,-0.4706666578251629,-0.435786187591399},
{-0.7557338315698512,-0.43499238445658095,0.48953855954922476},
{-0.7861974904210098,-0.17246609017652123,0.593421396475498},
{-0.8005518879885759,-0.15244248140646485,0.5795497946687292},
{-0.8068644780102048,-0.15052500624466758,0.5712371982113582},
{-0.8794470227932449,-0.1272317056968864,0.45867747619166865},
{-0.7208889965042993,-0.22888190709101167,0.6541652140899925},
{-0.8078746081495763,-0.2555320420113017,0.5310762591311182},
{-0.6528938395045061,-0.753487086201457,0.0773747068795871},
{-0.404896325553279,-0.9129516085266466,0.05077721971575234},
{-0.5449839026827134,-0.7961973335292278,-0.2627971687398221},
{-0.7772100232700806,-0.5792513251723762,-0.24578950753554732},
{-0.4447450069432087,-0.8953708069092807,0.02264943561568144},
{-0.23237771219133835,-0.9251661237387117,0.3001137157195693},
{-0.7560136181611352,-0.3416748821360413,0.5583025022980208},
{-0.897498413159831,-0.19395726463492682,0.3960772372542027},
{-0.8421138208498832,-0.14727497046078653,0.5188009211724524},
{-0.7301828695592476,-0.1977140324411656,0.6540199831641816},
{-0.7307452949451562,-0.2192118534638599,0.6464963087415551},
{-0.8459956157871619,-0.11780582961443249,0.5200126965543783},
{-0.7838848758009975,-0.17986778580291932,0.5942828292326893},
{-0.6519638065725913,-0.21715609384727644,0.7264891092262633},
{-0.7561918838666654,-0.19665392862619024,0.6241002060006622},
{-0.7632372186752535,-0.20191994244069442,0.6137566984348195},
{-0.9000391531770471,-0.13110159418046777,0.41562229818873275},
{-0.8927290319967927,-0.44691428339850425,-0.05746737095492364},
{-0.5970171591071294,-0.7592894016216551,-0.25894037212586546},
{-0.40636875009625845,-0.9117975798180558,-0.05907294120950061},
{-0.617019770753875,-0.7749935116701604,0.1366442804071513},
{-0.7275682824706893,-0.6175286025822707,0.29883577318560667},
{-0.8022512042678565,-0.5226669683298323,0.28846532801651587},
{-0.5650488437459124,-0.6395843718840816,0.5212021061191643},
{-0.15872316693170166,-0.9809677499243672,0.1118446685698303},
{-0.7900798200536612,-0.45064858354037207,0.41555954097701897},
{-0.9151706610123416,-0.2699154329876116,0.29934648863373037},
{-0.8725037099700419,-0.39834977375568204,0.28293945259950937},
{-0.7946137895802238,-0.18689200998259908,0.5776333629679123},
{-0.800729508490769,-0.16896017658667756,0.5747040220495505},
{-0.8460665721413246,-0.15748952696015348,0.5092822443428554},
{-0.6781974453191977,-0.26292671499522663,0.6862344844907845},
{-0.38465248971143684,-0.46614001719521814,0.7967157250412688},
{-0.7926408319738871,-0.196944035820013,0.5770039499368},
{-0.7967183399598762,-0.15879140115887694,0.5831167787755551},
{-0.7553285204095758,-0.18598950015321103,0.6284001369260193},
{-0.8281240304627577,-0.15005513405986495,0.5400870734542657},
{0.9985071858077273,0.03771503510289924,-0.039509189026349326},
{0.47008137730916943,0.2843034193888688,0.8355806749984774},
{-0.133452650951815,0.29750304316181375,0.9453477292845174},
{-0.14125004978518202,0.15404802492146089,0.9779149397843764},
{-0.29762824043784086,0.1884034949081424,0.9359068081813874},
{-0.3644364320449184,0.262602134802776,0.8934350596408193},
{-0.25948204603359276,0.26492060278165813,0.9287013201282872},
{0.3658974778513933,0.34136333791743245,0.865788719739324},
{0.9983747496809896,-0.006756964226499824,0.05658800786264563},
{0.9718718683563417,-0.21376169429689293,-0.09884841702766718},
{0.9948507121172847,0.05599367184145177,-0.08447940171096888},
{0.9759778044980362,0.2129586376908363,-0.045999388692199536},
{0.9865242700299705,0.15786870117440618,0.04298066811183773},
{-0.1046783344480045,0.48741374188328807,0.8668738607897479},
{-0.19632532030317879,0.08716822207731227,0.97665657713842},
{-0.24516677718969124,0.12689254276146555,0.9611407461729785},
{-0.23199781270003583,0.1652722722852042,0.9585729450157063},
{-0.2871161509586057,0.3003891545679477,0.9095771939075148},
{-0.3647958253370258,0.28338563562856117,0.8869140811465757},
{0.06695141966708822,0.044762924388681825,0.9967516180095893},
{-0.002472455912509727,0.16447915706315044,0.9863774601305304},
{-0.053019446517182905,0.3669998933755834,0.9287087899623445},
{0.770008366322339,0.41274869413626464,0.48654458303675596},
{0.9735903982598186,-0.19276364714853605,0.12232707285912829},
{0.8975542496915297,-0.42587405006722934,0.11413878543251696},
{0.9906338890413687,-0.13333337936797668,0.029439901988431008},
{0.9819604500943723,0.16681207258143282,0.08903598649728392},
{0.9252041437886754,0.3649736215241379,0.10388237534740571},
{0.9153172112714174,0.36384028079679004,0.1726692005542053},
{0.9785796878107239,0.2021544734128884,0.03892766989461082},
{0.9831466423141709,0.18276901379915755,-0.004262311726661448},
{0.973326987515622,0.20310658204992646,0.10668782358714007},
{0.6040462158480773,0.44029402123072897,0.6642810730316591},
{0.6064293087251105,0.4717446943669832,0.6400784614840483},
{0.7380051836111258,0.2719007813866833,0.6175907334508991},
{0.8290914311898478,0.20862196843918518,0.5187333351656989},
{0.9286476819443562,0.059662517199333125,0.36613367348662823},
{0.8183183345477076,-0.3056843409305531,0.48673626026105693},
{0.7819530320622601,-0.029052020292934234,0.6226599680126682},
{0.8446050078869657,0.21392525333935788,0.49079360900071856},
{0.7390154005059622,0.2851087299360453,0.6103845099027886},
{0.9368896568680406,-0.12669131381288046,0.3258635939439251},
{0.8388629284907229,0.15126080080394533,0.5229045394181594},
{0.7566320660989845,0.26394519897738844,0.5981980010728628},
{0.9398960185911663,0.07444672851816178,0.33324639360301755},
{0.9741153173065498,0.02573184605414417,0.22458232496660477},
{0.8856100348810618,0.31608669302828457,0.34027058146188216},
{0.04875542506536556,-0.9960885585784236,0.073691871979574},
{0.5738156384296769,-0.7588464305676484,0.30803848445978527},
{0.037189505193955655,-0.9992924593201904,0.005614396604649925},
{-0.26077488464343934,-0.9600095936691401,0.1018726636660378},
{0.17434846532659445,-0.8289348372814915,0.5314787372787066},
{0.9373242722072785,-0.09203260291802064,0.3360851212583348},
{0.7315040197571154,-0.6520923716784212,-0.19919188707874996},
{0.825977561990628,-0.5636964410902799,-0.0027183432768547815},
{0.9691278622809694,-0.14146032841143388,0.2019409865194477},
{0.9673661485055866,-0.12325855127006485,0.2213821679003805},
{0.8137819963579234,0.18631472560057705,0.5504958541425126},
{0.7945184115641187,0.08658043455248934,0.6010360405485945},
{0.8789211494155842,-0.0516113160187087,0.47416651628811307},
{0.9686152465555363,-0.06689323083982056,0.2393946528391311},
{0.9417682793693304,-0.07776584140752374,0.3271467283710945},
{0.8963229704026604,0.1848736297128515,0.4030221752774243},
{0.1780298803917501,0.5791263432598696,0.7955614622580399},
{-0.225708133954464,0.7065192686986146,0.6707356865594439},
{-0.28192928111362864,0.2621904926638802,0.9229149614170443},
{-0.05608437523579562,-0.9978631989449028,0.03351983063584268},
{-0.005040450160373819,-0.999742159890301,0.022140632331901725},
{0.000906531303495138,-0.9999979078512692,0.001833710467974528},
{0.013275610892093172,-0.9995969817253577,-0.025092474588937604},
{-0.12054135827719126,-0.9913956222633965,0.05103431298315442},
{-0.7901618856458923,-0.5567617238739964,0.25624319952221924},
{-0.7723687314416808,-0.37921127233350327,0.5095540733095697},
{-0.03407384010215501,-0.1317838568038591,0.9906926811613138},
{0.8125146183251767,-0.579527551660352,0.0629905697263523},
{0.7511796608193197,-0.6474975692595127,-0.12835893024793546},
{0.9001564243225384,-0.21227246212074424,0.38034039172307144},
{0.8513139357813709,0.2990388570815384,0.43109203738853635},
{0.626297480593285,0.5851519428802606,0.5151200535272918},
{0.711360309898967,0.4574857883964874,0.5335478075258954},
{0.7185268329835159,0.3633860900225492,0.593017486977241},
{0.7576106366556417,0.1524730749555694,0.6346480005797126},
{0.6981483987206291,0.09692989644747879,0.7093612679999538},
{0.7637264547690417,-0.014730673498368874,0.645371915676686},
{0.36871434526165964,-0.02822017072932886,0.9291142844463609},
{0.8800584814543735,-0.10094781877890913,0.46401142992818895},
{-0.4025284269502056,0.09249023050917152,0.9107230219761402},
{-0.6282833070954122,-0.08761560480288548,0.7730353108495605},
{-0.5810978908914256,0.20899544101898135,0.7865406199522175},
{-0.4362945540808297,0.4000975900333064,0.8059584235734187},
{-0.379520732938871,0.3690215342897374,0.8484026877020077},
{-0.38405973894654316,-0.10718585160257602,0.9170655975100929},
{-0.5085627194894908,-0.0997345735699113,0.8552291945322502},
{-0.7432407934083303,-0.04100062245581676,0.6677664801201024},
{-0.22847888202778963,-0.7925528734925474,0.5653824751316914},
{-0.41519430110515687,-0.4779545449620839,0.7740627528048922},
{-0.7780945648037499,-0.002829349239856308,0.6281407827913597},
{-0.7214713949574261,0.08942519319879455,0.6866455862230122},
{-0.4831227768650123,0.033973537457318584,0.8748932399023758},
{-0.15105400821029052,0.00890216129695292,0.9884854263608789},
{-0.17103332053302184,0.14192576816625577,0.9749895792252689},
{-0.1445405248724571,0.4068012422860697,0.9020093047990719},
{-0.28121898066037615,0.46261809825168254,0.8407736794681048},
{-0.2614936767659594,0.38925652166866576,0.8832329349327003},
{0.03390830713485397,0.04863922695958311,0.9982406785480257},
{-0.05507406771098449,-0.07003083521239145,0.9960233577508214},
{-0.13040358727786183,-0.10772253596203415,0.9855915785308705},
{-0.3293604865578539,0.09221419438642203,0.9396904874734218},
{-0.6882007965161603,0.20887834627284682,0.6948017703869522},
{-0.8009730043025405,0.20117089400298593,0.5638905193249855},
{-0.6640716362744234,-0.12376594978360626,0.7373539527051928},
{-0.6803700035665291,0.05781926588239828,0.7305844172576511},
{-0.8131580530570572,-0.09695469034363767,0.5739109414960001},
{-0.9913305982200477,0.011394190127462702,-0.13089620874579094},
{-0.9696862523740545,0.17578766516546035,0.16972704184200377},
{-0.9273065358589347,0.37038853066924393,0.05399004447100322},
{-0.7805247257909674,0.5039131663474187,0.36993603935093133},
{-0.4688076871804725,0.2662349518478354,0.8422222407744152},
{-0.43312635741412153,0.6515968101722548,0.6227544905390224},
{-0.01505388113256467,0.06528460633616552,0.9977531261982487},
{0.06370427104546533,0.08978649288364621,0.9939216023138951},
{0.0005563217741914047,0.24930812826217721,0.9684240536503075},
{0.10756775615401687,0.25811585304417867,0.9601069650009139},
{0.0031333902015771944,0.5810129398859077,0.8138882881274181},
{-0.12478004610872467,0.1608481733614269,0.9790596535550818},
{-0.06517495603714313,-0.017652550919541408,0.997717701833334},
{-0.1999948141519696,-0.0883233147978208,0.9758079044440273},
{-0.09717671577425854,0.34400521336013323,0.9339256389522552},
{-0.3149725046370232,0.48860964840142257,0.813666352267143},
{-0.6023070250606622,0.2492696380985127,0.7583474764808091},
{-0.453862312517905,-0.11974946417634444,0.882988712898063},
{-0.8027601702317007,0.06838846861658192,0.5923673914471067},
{-0.8345402950135086,0.05689519199244407,0.5480013075959846},
{0.9535282088896415,0.07498785067963483,0.29182319493515446},
{0.896501081728276,0.2002853463127881,-0.3951855140467544},
{0.9859919758899915,-0.03762224332403216,0.16249427770791738},
{0.7827939048055242,-0.12595123910467423,0.6094013357117926},
{0.809081392557469,-0.26268640857914616,0.525721552692161},
{0.9116343198275901,-0.243670384801158,0.33097977352603064},
{0.9964374031396891,-0.0817740806882092,-0.020627684112157717},
{0.7179675786115156,0.2772050352687065,-0.6384981789201848},
{0.9768182925700168,0.14549964977093624,-0.15702189406936864},
{0.9622924133930663,0.2542254744476542,0.09676114544595474},
{0.864546023743464,0.3154236775323769,0.3912391550973864},
{0.7326086390325122,0.08555771095783439,0.6752514051155957},
{0.768125763742984,-0.0024655332083225387,0.6402942544020336},
{0.8069917240929102,-0.15399009210148193,0.5701327992495514},
{0.8239201456366545,-0.2908858201124025,0.48635484296098985},
{0.8177536588496815,-0.4114653465470163,0.40246145409082634},
{0.9489216889918254,-0.272177608355514,0.15958376380689207},
{0.9678913609265329,-0.2379989184862418,0.08088775088456153},
{0.9538230972667149,-0.23909772022190842,0.1818069836535903},
{0.5804194317529193,0.2998949844686351,-0.7570840650378103},
{0.4502187029791204,0.41145026571907234,-0.7924719542845053},
{0.9912619682138422,0.07718926602248959,-0.10696507646764417},
{0.8392446533984396,-0.11287635498515786,0.531909146591218},
{0.8350486521595235,0.010178033284814545,0.5500819540441372},
{0.7620031557930762,0.16828731847214404,0.6253243710290269},
{0.8452853068025085,0.45769577095105746,0.2756942715351671},
{0.6958007374700207,0.5098012515834455,0.5059288661661121},
{0.643086902444377,0.2920275080027792,0.7079259639780018},
{0.7951219270840576,0.20720169862370302,0.5699548904585228},
{0.9752996937423227,0.17327922198188433,0.13698473862253516},
{0.983646058828145,0.14812732844155782,-0.1024632886482969},
{0.9941889823922193,0.09029754953007006,-0.05860562975336182},
{0.7681693373229695,-0.4231495289142038,0.480479287146155},
{0.6743990551144293,-0.6175490986688945,0.4047456302345967},
{0.739935601869095,-0.6279043067759557,0.24131201092947466},
{0.9057015607800718,-0.41833346008676486,0.06856966510328721},
{0.9612794286880915,-0.2755346790410195,0.004743482566501467},
{0.9548844769742333,-0.2547773915008691,-0.15259133793783256},
{0.9681993782529212,-0.2486762530966052,-0.02738768147342736},
{0.8998722216328879,0.14192766098145107,-0.41241547471187956},
{0.16580048825654103,0.4962680936004138,-0.8521902236989717},
{0.5018980082937244,0.35220816057606436,-0.7899669619005707},
{0.26251371487149017,0.5132361633393017,-0.8171139395121855},
{0.8014732888670373,0.2551666606954799,-0.5408609271357773},
{0.8903810982752197,0.22736301263125958,-0.3943698268395431},
{0.8764894185248339,-0.22865250318773817,0.4236559122684116},
{0.8526413998957623,-0.17251988286158537,0.4931932006842954},
{0.9437137761382606,-0.051994537337354735,0.32665100155049165},
{0.9082712082016193,0.04273587887873123,0.41619353311702645},
{0.8664021356030961,0.31031849673828493,0.3912157588907757},
{0.8152418944817309,0.5221217061200516,0.2505385748345449},
{0.7178753952876629,0.6459861020618272,0.2595320265083841},
{0.4961014083414742,0.7561983801167997,0.4266701331829238},
{0.4784500026525854,0.6067269835287342,0.6347975759404443},
{0.5705617719738417,0.4956752589245081,0.6548017272825353},
{0.8326176812409048,0.44308503291151247,0.3323002414907682},
{0.8584157603101004,0.38186605723525957,-0.3424918930176739},
{0.6605032270356401,0.38277954524440666,-0.6459220593988029},
{0.38255871614255854,0.48702454034327186,-0.7851470727238192},
{0.7961608113382695,0.38912117031559756,-0.4633709931592698},
{0.7837742467210448,0.49971584148810594,-0.3687573835771875},
{0.9418654830911628,-0.31127451903637254,0.1264815621350618},
{0.8736521197622847,-0.475619347495067,0.10255832449505523},
{0.6752834126723813,-0.7339817265644726,0.07254748540768485},
{0.7730105160421482,-0.633981826478422,-0.02284263083219284},
{0.8970337867107111,-0.4112887804620074,-0.16177739200987662},
{0.653801052480875,-0.26802587993145655,-0.7076060425560742},
{0.6027252043204169,0.6913560705753401,0.39843332159288203},
{0.9122077652993039,0.26913098578444733,-0.30894256006309956},
{0.5792503180356363,-0.2464666870856648,-0.7769962942077853},
{0.46789283790723946,-0.16530837517209376,-0.8681874413587608},
{0.7236553369618423,0.03557279103854849,-0.6892441728621072},
{0.8628252503342553,0.4842375933618746,0.14507425878056163},
{0.8506918335677811,0.5213256272343492,-0.06740174099976137},
{0.6287684664583545,0.7410742505917018,0.23549770847623322},
{0.5895104531333426,0.7287449915673003,0.3484367416219136},
{0.7632216085312501,-0.273089443437627,-0.5855893886964639},
{0.6733715477907809,-0.2899270898466001,-0.6800831134493267},
{0.6748694054771367,-0.21401704202864416,-0.7062209224260109},
{0.5752044469524028,-0.14917507402452632,-0.8042926342420136},
{0.5120000028859258,-0.11659686859707603,-0.851035350193027},
{0.4509941524051923,-0.12995511467334284,-0.8830152561912848},
{0.3045907182312156,-0.19469894375663743,-0.9323716081410041},
{0.8117786726471314,0.15209102666546054,-0.5638117649030637},
{0.9303784530624745,0.3609391247108689,0.0641785192258966},
{0.7351136136249038,0.13250779778473792,-0.6648681512823237},
{0.44688632697365066,-0.12438610837844928,-0.8859010705527249},
{0.7876578478305336,0.1712988150406037,-0.5918207758406738},
{0.846550715890262,0.5274610321253043,-0.0716710891154429},
{0.9121291907719798,0.3996671447268871,-0.09103028489195757},
{0.7817043599877329,0.6168164363541908,-0.09206398546383654},
{0.4709807261472815,0.8622068582208514,0.1864845549494863},
{0.10818804242557893,-0.9912990761452158,-0.0749765904116922},
{0.18402523372435786,-0.9323029110336392,-0.3113615188665702},
{0.4518255981902696,-0.8720273847582264,-0.18820698459869462},
{0.39940317029873057,-0.9164360009484558,0.02494320991623163},
{0.6811229995767405,-0.7253191831969228,-0.09991767578427982},
{0.6550126773114661,-0.7385270818578243,-0.15980031891029373},
{0.4777833426067302,-0.8394575022177925,-0.2589095971527605},
{0.3020796469668486,-0.8529781431517287,-0.42564794630517494},
{-0.20310357214150906,-0.8448933558112394,-0.4948779205919188},
{-0.45566485559810466,-0.7951386512680081,-0.40015505073964946},
{-0.2081609002997224,-0.9401788408945649,-0.2696901680087014},
{-0.5558790551407654,-0.8306704002308575,-0.031387294182791806},
{-0.2986700478027057,-0.9520784529137832,0.06590009137191573},
{-0.12715308059955602,-0.9905248293719574,0.05189081317244121},
{0.2103424547331897,-0.9763473254381383,0.05001951465788192},
{0.46271794946546807,-0.8859602757731598,0.031088406109336025},
{0.7297729808564218,-0.6836104876745113,-0.010396997323708588},
{0.7753276901840583,-0.6266096802797388,-0.07891312573695394},
{0.6901864057303863,-0.7151053559045382,-0.11075673930562499},
{0.5542226525599646,-0.79677074415649,-0.24081867171319968},
{0.41324369464450034,-0.7724319183867794,-0.4822640151347418},
{0.13012879482182088,-0.7296603934476834,-0.6713137917486816},
{-0.34805504261289144,-0.6201025429181704,-0.7030864268197454},
{-0.610334442471135,-0.5749789724592249,-0.5448770958327968},
{-0.8066594502452108,-0.4567504189722149,-0.3750727744035823},
{-0.7513769844600289,-0.5924203514260158,-0.2906385288292479},
{-0.913709507642283,-0.38790592485553976,-0.1210947113050976},
{-0.8708216665859059,-0.37398185367330494,-0.31907240264182096},
{-0.7417436364995637,-0.531869731432221,-0.4085718620984813},
{-0.9050266937742707,-0.40876635356442764,-0.11762972307054782},
{-0.7964420474143984,-0.6028089009105793,0.04797388970409768},
{-0.623511638253704,-0.7795628131083733,0.059287919349069323},
{-0.4946678361709217,-0.8641111257959764,0.09282076348311545},
{-0.09397027016422718,-0.9883315829259505,0.11987606315001859},
{0.21448548505071252,-0.9759797931383997,0.03820235710119489},
{0.6190723475614033,-0.7554452894537623,0.21459693177427874},
{0.7689773947874753,-0.6327057902957285,0.09141744490043853},
{0.9318335834076111,-0.331923024636028,0.1466740554774471},
{0.9027964305354166,-0.4300545624567757,0.003417356086535313},
{0.7928868275533664,-0.6085217796216889,0.03212043614913968},
{0.41707647386141283,-0.907349180162508,-0.05258022641407091},
{0.5261954040080297,-0.8464400905910718,-0.08159393262372297},
{0.42298840432743023,-0.8790846004445857,-0.2197523038917167},
{0.5814465071843241,-0.7751383055315061,-0.2471448291607479},
{0.5156702074923791,-0.6074355159126152,-0.6042402925266913},
{0.31184123939384056,-0.6086842836187919,-0.729560473359674},
{-0.15238353842342137,-0.5561652135068521,-0.8169819535965498},
{-0.6106826206907007,-0.29377385442216974,-0.7353663435623631},
{-0.7719078256055277,-0.2966667505564531,-0.5622696398377042},
{-0.9237213985243132,-0.1740271930230711,-0.34125256628602446},
{-0.9473355920361548,-0.26145605113746573,-0.1849216303873376},
{-0.9816846170000411,-0.17274892020742458,-0.08033133456286874},
{-0.9138922293251837,-0.25729505570553524,-0.3140067634439288},
{-0.7992009254527371,-0.36051886273081407,-0.4809407763652081},
{-0.9693172268471588,-0.22677404428802028,-0.09485592535307834},
{-0.9513284071962752,-0.30723887823046897,0.024052720533880717},
{-0.8851935818100444,-0.4637325112713247,0.03720861072782874},
{-0.7818222944736399,-0.5942996537112365,0.18857842257977858},
{-0.1415842090476952,-0.07353547544766856,0.9871911899926092},
{0.23469512883060986,-0.6291136038711594,0.7410359437486317},
{0.6487366367164917,-0.31174223834332315,0.6942316277831698},
{0.8449216085621825,-0.434836680011086,0.3114876194997653},
{0.8348945020182144,-0.19543401815198774,0.5145451535567375},
{0.9166391683659207,-0.18134652829446835,0.3562107124904824},
{0.967784004798699,-0.19541352571656787,0.1587692477238966},
{0.954328592878431,-0.28905251849235175,0.07553527896223593},
{0.690630012338484,-0.6383479211607153,0.3399148681760459},
{0.6150234294914452,-0.7329267125035125,0.2907999574886058},
{0.5397803567366125,-0.8379649164681692,-0.08032412619997478},
{0.5968616237062861,-0.8012343338137453,-0.042187017727489125},
{0.5617565179148426,-0.827170914569546,-0.014761187972934416},
{0.4352810322479579,-0.8967576967538162,-0.07972487866370619},
{0.13621654320712204,-0.9285857647476433,-0.3452151950084709},
{0.030326685984364478,-0.8141697443920386,-0.5798343896612275},
{0.18259732235388423,-0.5318394105036203,-0.8269250626896933},
{0.4794327774123516,-0.4248232387532384,-0.7678993604359151},
{0.008266131119503238,-0.4432719081913206,-0.8963490874010754},
{-0.42140787121292833,-0.3146408769163463,-0.8505389612787299},
{-0.7498373646270174,-0.03778975543321404,-0.660542096306895},
{-0.8466589481776123,-0.02525130137051304,-0.531536449596709},
{-0.9088816864053413,-0.03556038070284552,-0.415535244523556},
{-0.9632094298652311,-0.024733992410300536,-0.2676113298015306},
{-0.9784888374161801,-0.13784678785630103,-0.15348569356663858},
{-0.9952213958310383,-0.07918900628941354,-0.05712682874985376},
{-0.9360815487801093,-0.060352641007385494,-0.34656729902987865},
{-0.8290665809093207,-0.1816021369510584,-0.528837657768561},
{-0.9940778086038922,-0.07797194474637519,-0.07569469118605228},
{-0.9854155996868311,-0.16975386355909192,0.011820393420027319},
{-0.9389920410430646,-0.33555939288761016,0.0754575423842992},
{-0.4670329338318531,-0.05430057193722812,0.8825710660358755},
{0.1929267937008983,0.2775350035543459,0.9411448209889804},
{-0.11734152611233166,0.6948505088276006,0.7095165513444021},
{0.13315422555236306,0.09267902062050627,0.9867525279189177},
{0.5000949221699639,0.035896760833854784,-0.8652262660029773},
{0.6784727420458802,0.21185833851053282,-0.7034136640017034},
{0.7531906382812791,0.1680087680830657,-0.6359849968770098},
{0.27288676572327514,0.27200897738897367,-0.9227913790846202},
{0.2339063119260384,0.13727786470017098,-0.9625188959727079},
{0.7509261538774542,0.04833195166048968,-0.6586151637120892},
{0.6097538668244935,0.10609444512255213,-0.785457949610745},
{0.5416092576794349,0.23225173472788413,-0.8079099849066232},
{0.7275125054663218,0.2456821164464351,-0.6405980424950698},
{0.008666163837122378,-0.40481052392043654,-0.9143595230146674},
{-0.24658097591845557,-0.587459994072924,-0.7707714172690515},
{0.4273798321678373,-0.3762150642013025,-0.8220758508338516},
{0.7207439297762372,0.03954805871259019,-0.6920723508006744},
{0.4667276886908223,0.2593654674461631,-0.845514529092053},
{0.43229376636181455,0.2841123448200506,-0.8558050450222701},
{0.46700292391565673,0.0971813986530875,-0.8788993371314242},
{-0.06539382017309688,0.10168316732398551,-0.9926651911727997},
{0.6927763160035632,0.002117757895587141,-0.7211494235496738},
{0.5011750430414944,0.04796497783348835,-0.8640155884784656},
{0.24685849096667883,0.17661965274574423,-0.9528202263289894},
{0.8322933876319805,0.24099954040308744,-0.49920630848335895},
{0.43389547713750987,-0.2194343925572136,-0.8738325138621584},
{-0.04328061746281845,-0.550148986200049,-0.8339441714737835},
{-0.46308123206146273,-0.6077045304452653,-0.645175151558658},
{0.19186072111551147,-0.43088118802010095,-0.8817771064749994},
{0.6994997014685719,-0.18187083224627723,-0.6911028635618762},
{0.21776211502565762,-0.5270014229178954,-0.8214920337423035},
{0.5542894152986808,-0.009916175817472221,-0.8322649299021337},
{0.7755094754885506,0.14004034771951052,-0.615608442468158},
{0.805134248612882,0.08213617407115933,-0.5873776388487413},
{0.9130794582970216,-0.03380833640467699,-0.4063777789515142},
{0.9258203225394813,-0.02109169395277128,-0.3773749737583207},
{0.5363906596643132,0.4083825502733998,-0.7385856435492618},
{0.7723613066014325,0.036006291257088555,-0.6341620920985719},
{0.6205995421677145,-0.004042422858674711,-0.7841172533994228},
{0.00673695504812249,0.05072761097611778,-0.9986898031527784},
{-0.28750851543819145,0.11183237289552331,-0.9512267731319825},
{-0.37102947118416074,0.15313289560112872,-0.9159079909017149},
{0.5379152246980925,0.026284826169061682,-0.8425890569852322},
{0.6894138074432817,0.004475026303136442,-0.7243539026236718},
{0.14151859734021122,0.04636438018767438,-0.988849245768369},
{-0.3883936278235578,0.03120772204734814,-0.9209649656478095},
{-0.2529553556956635,0.09270925509263227,-0.9630257431891681},
{0.11287153176146612,0.12202177975635446,-0.9860885875938895},
{0.8157671119455406,0.20404785072374731,-0.5411917346773241},
{0.8177897957033069,0.22019500491320532,-0.5317273830214285},
{0.7653228846867303,0.19933979722119624,-0.6120004308973925},
{0.2804645704311586,-0.33354390651555943,-0.9000489359802639},
{0.32155504471295043,-0.3834915007531234,-0.865757831076202},
{0.6921679751400132,-0.09002635303104445,-0.7160996787811763},
{0.6248866935761169,-0.17362256264069803,-0.7611647823786811},
{0.32605920811099576,-0.3614360120924074,-0.8735269898341822},
{-0.46603560779999703,-0.6649876550591621,-0.5836113697328079},
{-0.43729893583420154,-0.6323765398311074,-0.6394290833153512},
{0.35623627281930886,-0.3479366790790075,-0.867199968449768},
{0.8252963021321212,0.12044241152573638,-0.551706116689775},
{0.6110103478977089,-0.16258240195884485,-0.7747472602953902},
{0.894439699380674,0.276569293919927,-0.3514072421456943},
{0.9078618011576665,0.28782601892747856,-0.3048657619791314},
{0.702971701033029,-0.27744332708334546,-0.6548709703473301},
{-0.34180360428399575,-0.7083213517741914,-0.6176173238496894},
{-0.14056986488499232,-0.7012182030156099,-0.698951461008398},
{-0.004512654000417894,-0.4813913921151148,-0.8764941320689741},
{0.11907627272274092,-0.5435968504449946,-0.8308569705194399},
{-0.04480925665560209,-0.622372626551403,-0.7814374218307439},
{0.4823367303935544,0.3013902560880094,-0.8225054358777575},
{0.584014695414686,0.32062917302839744,-0.7457370642142025},
{0.6465037929468478,0.22302801528049124,-0.7295829974070012},
{0.6785839846170877,0.14364481947298305,-0.7203401569118372},
{0.6767424976240649,0.07402279324113506,-0.732489056566938},
{0.7834957690621103,0.09576319046765347,-0.6139737707860393},
{0.7095562631110408,-0.05473326181966601,-0.7025198783881317},
{0.7805183629526855,-0.08175732237851656,-0.6197635237178412},
{0.7247194955323847,-0.07466134661576201,-0.6849871065332594},
{0.746545358029664,-0.07367521577436753,-0.6612427625199091},
{-0.11324673667134043,0.10199501083176388,-0.9883178610137127},
{0.26882234381515496,0.016956956353516062,-0.9630405023138703},
{-0.33668798509763026,0.21713593910746157,-0.9162386068262016},
{0.2755565983302126,0.08408832757858967,-0.9575999761287162},
{0.5347962436248075,0.007769233770633588,-0.844945333623077},
{0.59850304579779,0.005706438163854933,-0.8011002064250456},
{0.6010473341165031,0.018140206815677053,-0.7990075312837353},
{0.5527989050104606,0.026196165505188888,-0.8329028343882979},
{-0.6315422313974051,0.05173645247222322,-0.7736134367028379},
{-0.6995445532766122,0.07316759525021906,-0.7108332582162467},
{0.8723783344198565,-0.03715755716968237,-0.4874170263542492},
{0.851430918170877,-0.10647248569358306,-0.5135455202539762},
{0.9049787600923859,-0.03224284040790731,-0.42423324130020523},
{0.9290721842798423,0.04476415844179945,-0.3671798558152124},
{0.9966578503606444,-0.007879921184774099,-0.08130827852452087},
{0.956361431670811,-0.07825332539780651,-0.28151239595574085},
{0.8965498492972229,-0.1001756234329987,-0.4314663511734571},
{0.8900553294952898,-0.08403785989978695,-0.44803922656447726},
{0.8704728935534486,-0.19757994860789818,-0.450820480343104},
{0.9804917281180802,-0.17119275161134118,-0.09658681528945118},
{0.9151402403563403,-0.17709198476133362,-0.3621557253638706},
{0.7872118169497483,-0.10932574583688105,-0.6069146863867158},
{0.8469830698474301,-0.04033015886678262,-0.5300878773162083},
{0.9230480566044008,0.04441827307308314,-0.3821116358029991},
{0.9932076361298087,0.01908292373969769,-0.11477993533271598},
{0.19562203399134018,-0.08434706353227764,0.9770453380936696},
{0.19278042544383064,-0.1583607523241956,0.9683788409961313},
{0.47743315489525967,-0.23789282724003272,0.8458513967326075},
{0.8810438769802246,-0.15789272783430996,-0.44590534122467695},
{0.8732385337959363,-0.1309901903764843,-0.46935704226000036},
{0.8430980166773951,-0.2960076329347884,-0.4489601491435362},
{0.8790917974794651,-0.43810941813027476,-0.18777046985581947},
{0.6471332435161451,-0.22166182396587072,0.7294412936846919},
{0.29798692115996034,0.16057350091176778,0.9409675582200198},
{0.0244063684791939,-0.7972775423353192,0.6031192665347469},
{0.7347016118469011,-0.6407919208270815,0.2227089036215316},
{0.9426954097430638,-0.2500437372053045,-0.2209151283496941},
{0.8487595033846455,-0.08499501115291232,-0.5219033947900381},
{0.8524062678700232,0.013147092163416894,-0.5227147486569945},
{0.8757245405241924,0.0377627548572977,-0.481332009603849},
{0.8919452743789147,0.07455052079946284,-0.44595498355960933},
{0.9281514627845516,0.1461824257666249,-0.3422945522906876},
{0.9250000285146992,0.27583336350455234,-0.2613252816425746},
{0.09198401655724682,0.019477467680000787,0.9955699719009059},
{0.05147317250645813,-0.05806702618959737,0.9969848208381193},
{0.1422559672888838,-0.13917771554283892,0.9799963281905605},
{0.2256525330906533,-0.18903179270457035,0.9556923750123091},
{0.19409516664733215,-0.17511551147310714,0.965226203501364},
{0.09597785962205183,-0.2218940193138301,0.9703356608180097},
{0.777987811268864,-0.3680354887960833,0.5092002008087885},
{0.926351697504857,-0.2156666072554321,-0.3088048688813067},
{0.8989812376645415,-0.19239356811919886,-0.39346848574376614},
{0.8865268582811335,-0.16859789809945688,-0.43086526699494837},
{0.862005179632882,-0.293918417677845,-0.4129879344918382},
{0.8731658481646367,-0.2750940670067076,-0.4023737763530816},
{0.6240181823786071,-0.5777386174966695,0.5261362921467558},
{0.48344737662111487,-0.8577325099343299,0.17485301095467753},
{0.49015817444800525,-0.8690295172177693,0.06732504902374539},
{0.6207357228865464,-0.4538534205907157,0.6392998005244673},
{0.15492173831509212,-0.958337594420186,0.23997564484414038},
{0.18032670635778805,-0.9774520273477815,-0.1098627016228152},
{0.2254725239215811,-0.8012268824719742,-0.554254114789122},
{0.38197358822120203,-0.8655070845450157,-0.3240272588900608},
{0.42636913140690624,-0.9028116262113987,-0.05604044397441808},
{0.13947853224572385,-0.9758820255262095,0.16792858987510467},
{0.43282443851647756,-0.6304149666640877,0.6443911663181091},
{0.6402465004982496,-0.4067144032237531,0.6516654147720985},
{0.5346271181715331,-0.6245367627866873,0.5693221201073491},
{-0.1317435052158797,-0.9890454135061154,0.06657941766004553},
{-0.1789039890053226,-0.9834262563236309,0.02943061486397872},
{0.15809281863006275,-0.9745456513672693,-0.15895733420873268},
{0.23478879089745572,-0.8971237264339198,-0.3742235202899844},
{0.21846822521831072,-0.6667450301810859,-0.7125466295610304},
{0.020095989788638007,-0.2825795999787895,-0.9590333262563101},
{0.1694445071946673,-0.45160643727793753,-0.8759795572903996},
{0.28369995957881167,-0.7563352308475803,-0.5894670062978234},
{0.8781477933639396,-0.4032619619247094,0.2573640283230698},
{0.7327724826362616,-0.5943573370612217,0.3313364522242955},
{0.6832199153648791,-0.18387142498705322,0.7066836960918498},
{0.003044277112259015,-0.36370936077038485,0.9315075057480008},
{-0.9358224559812016,-0.274350738137063,-0.22128715137793423},
{-0.9802600366088152,-0.05562385640120643,0.18972676992649812},
{-0.686434170127469,-0.10333564717118583,0.7198123881297995},
{-0.6638641314668721,0.2555782089237279,0.7028258632656276},
{-0.9367435920706386,0.05507852300763169,0.34565560753139046},
{0.4536233073936295,-0.3834495557420483,0.8044826494030127},
{0.043445554035793074,-0.2583882452600124,0.9650637277123075},
{0.33716098021191115,-0.21109302681218886,0.9174759982984905},
{0.20952387905462186,-0.877069244980254,0.43226066628328713},
{0.09329190041369474,-0.7723828989339164,0.6282684766496252},
{0.3418248712937774,-0.6087006914688665,0.715988285916967},
{0.600227921082183,-0.7945405469770446,0.09182462612382124},
{0.5858018166718724,-0.8039028880063469,-0.10284152001496848},
{0.4734542213140966,-0.7526419006824158,-0.45757105421674477},
{0.43109070333477734,-0.5375787981228272,-0.7246860294687234},
{0.5366027366572612,-0.43705397173663674,-0.7218319255901399},
{-0.045673457266830926,-0.1974577788251474,-0.9792468334810862},
{-0.24605058578345493,-0.07632425305163004,-0.9662472342168589},
{-0.05488309420349749,-0.0287497803532,-0.998078802550326},
{0.4073430691288493,-0.205480037626624,-0.8898593024572203},
{0.709387954864122,-0.5348511932596379,-0.45902388887991413},
{0.8419898422326002,-0.10157326152897372,0.5298452397818515},
{0.8124484184468327,-0.02980522837589197,0.5822707409141398},
{0.7576327149013599,0.07142494179023695,0.6487612403661737},
{0.5893664219485244,0.287227200838949,0.7550812908408047},
{0.08571602861794694,0.41670549592212147,0.9049913215640613},
{-0.39553426964114025,0.5067176251340761,0.7660221210369396},
{-0.7300227709414403,0.5422270097841024,0.41600074971996426},
{-0.8950584828698972,0.2794969076636944,-0.3474935838962646},
{-0.9396206229951098,0.3386161436114598,0.049519613568614264},
{-0.7125273707682842,0.38820186382156907,0.5844690400966471},
{-0.8506056624894477,0.42673762058098846,0.3071888834605904},
{-0.9805745059384563,0.193723497364299,-0.030738329045290863},
{0.25351518044731686,-0.3188673678062656,0.9132653803966666},
{0.42914218300329027,-0.46907415143497344,0.7718849831566424},
{-0.06980497546511605,-0.5088105615131394,0.8580437505704464},
{0.07427546893654585,-0.2974994608158305,0.9518283592794167},
{0.45884720212956454,-0.3690450344730906,0.8082481101918061},
{-0.021737486439646805,-0.6009510275402752,0.7989902028070016},
{-0.041182790453451884,-0.6066672674703606,0.7938884079960565},
{0.6287254842803333,-0.7455373381795073,0.22108446982245383},
{0.9446492208098688,-0.15598193735736238,0.28863036022142885},
{0.9480361066550151,-0.08620820595332437,0.3062608132045456},
{0.9051571367287756,0.2558169975274064,-0.33948228467039},
{0.5320921504871099,-0.178320638311704,0.8276954109707927},
{0.30840951928264365,-0.18831317813452736,0.9324278606716567},
{0.7205453853019945,0.025264465722332236,0.6929473677645115},
{0.8551951874618888,0.28110110185769066,-0.4354576464782966},
{0.8510713819301262,0.1652296389087801,-0.49837402549252025},
{0.8495601588257133,-0.4029323034842787,0.340430749705255},
{0.2926216787230699,-0.6894778114614694,0.6625653934847451},
{0.8301526868380521,-0.13694661294494312,-0.5404554946880188},
{0.6293144490733168,-0.24836455255525386,-0.7363955277034049},
{0.38866868095928,-0.5396810060154289,-0.7467804685364688},
{0.3350982882333855,-0.7214154800718734,-0.6060270970309194},
{0.5423110012618685,-0.7795935497332643,-0.31326135274661293},
{0.9115432981197066,-0.26097120471140295,-0.31777798218965186},
{0.9117201381434341,0.21583215395250419,-0.3495466650161894},
{0.8364580247844648,0.29465693045555674,-0.4620771213857928},
{0.9582220324725581,0.2573148209629276,-0.12489843632718682},
{0.9225452479493012,0.2348360670814923,-0.3062062819144296},
{0.43240783571975344,-0.18279278576121344,0.8829554128503964},
{0.37526540427531946,-0.21372328100870044,0.9019413703278929},
{0.36534895796458966,-0.250037647841574,0.8966612033405045},
{0.9135866738450801,-0.041893627388098605,0.40448030033235316},
{0.8700768676036491,0.04496679810539261,0.49086070481264943},
{0.733696069936698,0.1603375578798726,0.6602892884884342},
{0.9597166996513707,0.1799137188708273,0.21581221043386214},
{0.7994428508723881,0.1129370955583918,-0.5900307963452953},
{0.7504187649923306,0.3622254575601634,-0.5528692386475447},
{0.7376138358154677,0.33859915805363555,-0.5841887018583649},
{0.6786051123670964,0.15975798521014142,-0.7169187454871276},
{-0.6799401702444201,0.6317958158737615,0.3721765870287885},
{-0.7779935899056125,0.5196601702515798,0.35309953486216406},
{-0.6550937522769916,0.613662381361414,0.4407614518415718},
{-0.7143122548501428,0.6276824755534225,0.3094716666417651},
{-0.49859910279663516,0.5017527613302282,0.7068543705657351},
{0.12583648170913403,0.001044495172625589,0.9920504467520295},
{-0.12230792655754495,0.06801900742640692,0.9901586669468284},
{-0.9793241937689253,0.1530535906049958,0.13228273470775667},
{-0.9152657709601412,0.3426709720341761,0.2118140066990177},
{-0.6735297992965463,0.5147647129307821,0.5304478294619026},
{-0.6542582875356119,0.5770541654769663,0.4888298101554881},
{-0.7775893402803126,0.5285796490096609,0.3405266106125214},
{-0.7649509663702071,0.48888819751173257,0.41933083523992803},
{-0.5654620028318008,0.4153111943095513,0.7125793536404368},
{0.3187985926730235,0.08170911138821531,0.9442939576349347},
{0.44733479429202294,-0.15377806772047742,0.8810470405738106},
{0.4878459975853802,-0.3512546032601286,0.799141092879408},
{0.587312776922921,-0.4957780356489107,0.6397404484876617},
{0.6505777949347873,-0.11526994915986347,0.7506406407585938},
{0.2357924731514141,0.1541929937241013,0.9594927984573615},
{-0.8431768907548095,-0.06783683343296551,0.5333393806262953},
{-0.9573994574786571,-0.2641572839106384,-0.11664993860490347},
{-0.9964529240783275,-0.03217600567956267,-0.07775779545652962},
{-0.9599489359225736,0.2311182773806919,0.1583741843915866},
{-0.6920644484673721,0.4067320384628982,0.5963353486549053},
{-0.587178768777294,0.4759543722007214,0.6547431015903858},
{-0.7669917113573254,0.4392475633973645,0.46774490137107816},
{-0.768653228819262,0.35560967106790853,0.5317085439116971},
{-0.7327522103485152,0.22579487113863145,0.6419430460693955},
{-0.5461883773791733,0.23245381755664324,0.804762995619983},
{0.7053729466612034,-0.01832043996740279,0.7085995819910509},
{0.5296879912991216,0.16166423277971115,0.8326435658270885},
{-0.16439755555119068,0.2934100943178454,0.9417451673787268},
{0.1668872850747534,-0.14247219084858848,0.9756281611942027},
{0.469166544837651,-0.5362416984695145,0.7016605974597907},
{0.5001317958752222,-0.22796753276146361,0.8354034897947676},
{-0.06927878448589804,0.4211113910885036,0.9043592462708953},
{-0.2604984117306419,0.48687064046788525,0.8337251087356098},
{-0.8814618432377705,-0.43590725127871505,0.18168623282600999},
{-0.667609804416885,-0.6368206781869444,-0.3856897365499487},
{-0.8307454746346905,-0.4117987191579606,-0.374544752030843},
{-0.961986761349713,-0.12169857325054192,-0.2444809363870175},
{-0.9912195887499102,0.1321906705649034,0.00305834825686248},
{-0.9519184638121421,0.22462530332637018,0.20831397302885812},
{-0.7447074521973731,0.23554871735457705,0.6244418406819894},
{-0.5440299397781344,0.3671438611012577,0.7544778392243605},
{-0.7540281360259927,0.3345567871416702,0.5652550983924074},
{-0.8338253796261509,0.21877461737082501,0.5068263046503746},
{-0.8015373222684735,0.17603429080414126,0.5714454037541716},
{-0.7620607144310467,0.10982047495045306,0.6381245417647715},
{-0.7576207393934671,0.09024722999298211,0.6464257519000074},
{-0.8950680817492553,0.019368366771831905,0.44550869284706485},
{-0.7713564042466761,0.013592178187729766,0.6362582418481914},
{0.679076938428566,0.06671070041009336,0.7310295439619936},
{0.8293429761134715,0.0156590976863287,0.5585203851525025},
{0.8484032521613799,-0.005080505865330119,0.5293260905926954},
{-0.3079544210574897,0.7016333560216563,0.6425532727089124},
{-0.5599298505336744,0.624579116014063,0.5444074671791606},
{-0.6879672415074187,0.4942116733897781,0.5314657999325532},
{-0.6252512623458878,0.3851458355501026,0.6787661926564162},
{-0.3338368491704137,0.4022082407853918,0.8525148029097739},
{-0.5867597365686404,0.4731449739438864,0.6571505498540944},
{-0.5580607245202536,0.38736387708124553,0.7338374850609058},
{-0.5641508910320576,0.5163174759160544,0.6443213764973269},
{-0.6436706265885981,0.3759582235585924,0.6665909829916011},
{-0.5923534364464136,-0.7776361738246331,-0.21071162162896823},
{-0.43073547263345036,-0.800964017493468,-0.4158408292796193},
{-0.5555693498612615,-0.7071483345902327,-0.43736018380848946},
{-0.9252096887282374,0.0675778700157034,0.3733902293412867},
{-0.995010683724318,-0.09265667816156922,-0.03699296239190407},
{-0.9901911486005917,0.1106511823518583,0.08531005261501629},
{-0.7702334190130554,0.25143901779737726,0.5861048545819674},
{-0.47227923035845915,0.25687526798121657,0.843188843184965},
{-0.9485072088565185,0.1745667313382616,0.2643114281621056},
{-0.8302322988594174,0.13610663018841881,0.5405453867617039},
{-0.7726443630806761,0.04696960931600209,0.6330991581106065},
{-0.776069117366466,0.13779778133887774,0.6154092106299005},
{-0.7160742797246872,0.25099062298343694,0.6513381096566949},
{-0.8301897470622162,0.08398089016546706,0.5511190379217445},
{-0.752765646581166,0.11896363338639512,0.6474500252982822},
{-0.9730947120299724,-0.10654961207336154,0.20428867219285787},
{-0.9597897161021406,-0.2802131711243403,-0.016860592902195205},
{-0.8756608495979824,-0.2584649806120912,0.40793863543250103},
{0.11801609287440801,0.08977915019893859,0.9889448447776121},
{0.5650311431755359,0.14252267152905926,0.8126666569645681},
{0.44508153598561045,-0.10322172967410002,0.8895210513797731},
{0.8501407687668501,-0.02777575838525018,0.5258223849615317},
{0.012669546396807634,0.2811710504059094,0.9595740320620065},
{-0.5429402145527588,0.5603681582080604,0.6254625893591963},
{-0.44753771534233433,0.7238583112372382,0.525108692176141},
{-0.49572992142918654,0.6611625372849316,0.5631304860250099},
{-0.5483830019109471,0.5642213722567204,0.6171955332825094},
{-0.6567584351287461,0.4536292333168346,0.6024025867869607},
{-0.7767523989034488,0.36846256258774207,0.510774951195741},
{-0.8202419586062425,0.25084003371198516,0.5140840464643551},
{-0.33847432438364844,0.40138419772191014,0.851073356152201},
{-0.1337854510188693,0.47287881171741125,0.8709116387581503},
{-0.5274314512502996,0.49414464506154354,0.6911129676029845},
{-0.7715110419980178,0.5570249817006261,0.30739857162412104},
{-0.5718810935305532,0.6477971025964238,0.5033000384760337},
{-0.10848144286040134,0.30572635104631096,0.9459192221489282},
{-0.221471281705085,0.503397110632319,0.8351896912599794},
{0.39419558731855786,0.003957230384850963,0.9190180516541874},
{0.607451992943095,-0.2487592484360732,0.7544010290203627},
{0.13891144925625393,0.20957331404020238,0.9678753201253423},
{-0.19712997403317192,0.6104079446308128,0.7671648548188763},
{-0.1343459643667408,0.5701745137721769,0.8104641791609498},
{-0.039239743338985854,0.5775839711157569,0.8153876371719423},
{-0.40764047259779174,0.6777752195917732,0.6119231951867591},
{-0.7914652053173311,0.5701302752281878,0.22030501138245992},
{-0.8272754203445508,0.5362637891000837,0.16744111619840452},
{-0.10304533639168263,0.5892135935814583,0.8013794355901261},
{-0.021953329101054023,0.5302021211296182,0.8475870233144409},
{0.41848603710237287,0.029754660776520753,0.9077356977184634},
{0.7474426427165293,-0.47633134537593913,0.4630744489402095},
{0.7265902145295474,-0.3061050715788537,0.6151149041468684},
{0.13772868040896677,0.2788837875718147,0.9503970978608908},
{0.42904744657041705,-0.011663176796701381,0.9032066534843585},
{0.5255609062999327,-0.09845639737787291,0.8450396863961857},
{0.3778152590475956,0.4448055791507283,0.8120367151719085},
{0.21062367716643546,0.4573358291621832,0.8639916700879862},
{0.5355703508368891,0.10635589319961741,0.8377665684939708},
{0.4707233746023289,0.31266558217690593,0.8250210532616559},
{0.3516267158307507,0.25186494692076644,0.901622260831375},
{0.5936861246805925,-0.16611485384881555,0.7873643633620502},
{-0.6472776843513806,0.5826031075843628,0.4915335373845389},
{-0.7201581437295896,0.6242626367162963,0.3027679118069964},
{-0.38633417796382186,0.7703792050459051,0.5072098021232019},
{-0.03557429363022719,0.6220687260792058,0.78215405750204},
{-0.07591997642610153,0.5767660441924406,0.8133738915443891},
{0.7313343428692269,-0.12644101321985368,0.6701960527457416},
{-0.845877943026909,-0.2719463353958298,0.45884168965487887},
{-0.7643940402454686,-0.13379301516868675,0.6307148169571414},
{-0.8815129765291906,-0.3587444223943718,0.30698096294652394},
{-0.7732303343713874,-0.2112618271596617,0.5978990637165051},
{-0.7777289991051658,-0.14420408394222073,0.6118355874949265},
{-0.7601404994076069,-0.18416176457051694,0.6231138464443136},
{-0.7891560465540356,-0.22912501085400858,0.5698547741208769},
{-0.7312541117716919,-0.3448497713536867,0.5885117324355598},
{-0.09697364581457864,-0.8022081310738348,0.5891164795322347},
{0.2654008344926374,-0.5561103515645637,0.7875935969352145},
{-0.1827164209040203,-0.3348972423843818,0.924369269597038},
{-0.7048305372967739,-0.1594781189256796,0.6912167845747581},
{-0.8043033273848939,-0.18432890491145795,0.5649061978521133},
{-0.7509551570487597,-0.1506316648816433,0.6429435851121441},
{-0.8551048423902193,-0.14178321160641108,0.4986915173003945},
{-0.827660558781003,-0.14515005588278188,0.5421341722447897},
{-0.7861983618050546,-0.1731045694715549,0.5932343077765444},
{-0.7240895397859519,-0.1799743717448051,0.6658104564270757},
{-0.8843298584519313,-0.12758749218963533,0.44909033978381985},
{0.8163027486155207,0.06755371075684935,-0.5736604559891904},
{0.6502555189606843,0.05481666486072856,-0.7577353715610204},
{0.5104949154466126,0.03649677178192615,-0.8591058880910163},
{0.7472202066478504,0.023620848992160343,-0.6641566217919032},
{-0.5137985794136068,-0.14115682305879243,-0.8462185126174613},
{-0.6443276645903102,-0.15636491280698486,-0.7485932638532495},
{0.7796266524806807,-0.011427197421622898,-0.626140321254633},
{0.47127611380761475,-0.09380413383888987,-0.8769832433000805},
{-0.2677682875748194,0.01643133660502956,-0.963343217833925},
{-0.2062573937243126,0.03691589101827773,-0.9778011579684188},
{0.4792173889868808,0.05170513442027446,-0.876171942695712},
{0.7658000390579058,0.036092672586027205,-0.6420651206571711},
{0.8504714676386761,0.018757278011358635,-0.525686643594947},
{-0.4903779977941759,0.028231051795511105,-0.8710524823418475},
{-0.6089407364605303,-0.004050298681155647,-0.7932053798099837},
{-0.5097516185627537,-0.1158979623121794,-0.8524792957629748},
{-0.15841704497042328,-0.24614674109990622,-0.9561986308862478},
{-0.36803588287506006,-0.2580899342540374,-0.8932744117868382},
{-0.7696713523532137,-0.2049413144659351,-0.604652848328485},
{-0.8028875014114725,-0.2216445873796027,-0.553394377422258},
{0.0437925280623975,-0.41945327386182363,-0.9067200039331337},
{0.013650033979354343,-0.31533398745067787,-0.9488825812137233},
{-0.532443185459721,-0.009542264493764344,-0.8464119561099288},
{-0.5510045560060406,0.01933744427563008,-0.8342781565577951},
{0.12169851470392636,0.03702198920492324,-0.9918764256872773},
{0.7654110665397273,-0.012288757688251467,-0.6434243433792326},
{-0.1407990287372421,0.030098674640832622,-0.9895805693785195},
{-0.5405283761823801,0.06633023158557218,-0.838706966061117},
{-0.637040148575603,0.02613022086147902,-0.7703876041711107},
{-0.7026815124501259,-0.04116920427027758,-0.7103124584860916},
{-0.45521372742085864,-0.15057883039014014,-0.8775571082305389},
{-0.10394569001067702,-0.1734760073836267,-0.979337208723553},
{-0.4367772404440514,-0.1976854001617122,-0.8775796971175798},
{-0.8305732415669571,-0.2554390113409154,-0.4948727128041441},
{-0.5083248669063033,0.09878152729375014,-0.855481174281587},
{-0.5230404056159552,0.0322604884995042,-0.8516971263159636},
{-0.5071934836564764,0.020723528057158887,-0.8615830229996827},
{-0.5650443102620094,0.058848962398407915,-0.822959128429329},
{-0.540874392017746,0.06856435124271197,-0.8383041344274164},
{-0.5485914043167549,0.1261096584128482,-0.8265251509571656},
{0.46493065706822,-0.10208200718743334,-0.8794422936877087},
{0.6823942510227771,-0.07917168649188382,-0.7266842025454345},
{0.8165148364839618,-0.11001940197500468,-0.5667444335771029},
{0.6695420330334195,-0.07161397825862617,-0.7393138062551303},
{-0.500134266236366,0.050615528326994993,-0.864467341215613},
{-0.6317042547753383,0.08015109786959575,-0.7710548203656034},
{-0.7467799534689725,-0.13534151936281835,0.6511546469414489},
{-0.7181550801661225,-0.13132978227510847,0.6833782035733674},
{-0.6683736183928733,-0.08641918200630355,0.7387884888232755},
{-0.7108099006549969,-0.11223826813689633,0.6943715549304015},
{-0.7526939381760523,-0.1638941889232213,0.6376445171647167},
{-0.5883685136817153,-0.05272575436562689,0.8068720387611314},
{-0.7262531270975675,-0.1343560901726348,0.6741697385781473},
{-0.780951315443192,-0.1542507103998704,0.6052452075387985},
{-0.7127131164925264,-0.1159123363565799,0.6918123617425967},
{-0.7189752470207361,-0.17181568689418827,0.6734641519105151},
{-0.7762160179156116,-0.17841331727574086,0.6046961069412443},
{-0.7333725207732086,-0.1612986434629569,0.6604146374753966},
{-0.7530610928013844,-0.15265443719750094,0.63999657289137},
{-0.7100465269323151,-0.1375197328332987,0.6905955782314388},
{-0.6845063553435815,-0.10673420348344441,0.7211510655202564},
{-0.605538971330588,-0.037748203320673794,0.7949198873760516},
{-0.8319534141532561,-0.25103841663586873,0.49480625506524933},
{-0.7445697428963772,-0.1973257558612508,0.6377134497852534},
{-0.22334639734935252,-0.2993154038316505,0.9276457706582623},
{-0.6670436247771326,-0.272285446107901,0.693479227145273},
{-0.7417309694168152,-0.18895490114752722,0.6435302746105421},
{-0.8283776571586082,-0.23872141859320378,0.5067568859179555},
{-0.7853719022189358,-0.19900007645619583,0.5861654585314956},
{-0.7655859465044604,-0.16913345955146303,0.6207028527202233},
{-0.7927530400899729,-0.1651635247274178,0.5867398295051406},
{-0.7936453961636052,-0.17266237225237044,0.5833649718285268},
{-0.7682889826409576,-0.1516180557066417,0.6218874531104965},
{-0.18113584662538704,-0.9833744299498982,0.012827142628699424},
{0.4883761212494359,-0.669637224845841,0.559530831406203},
{0.7979087784011536,-0.4659139171012185,-0.38244712471370185},
{0.195454249853925,-0.416699010694197,-0.8877835156728903},
{0.6515126809015019,-0.2526292292816509,-0.7153388701427433},
{0.9040163676098569,-0.4273553863990644,-0.01103543425453858},
{0.5675596027586519,-0.34691257444434714,0.7466778174077737},
{0.5784903694586594,-0.37545468462545767,0.7241427153789383},
{0.2707098120450122,-0.16091195817070864,0.9491172421678062},
{-0.5580379766597588,-0.6448461177171584,0.5222710992105453},
{-0.5567612855834818,-0.76418938808192,-0.3256247073218021},
{0.04272380563958308,-0.11961291342730383,-0.9919009161065955},
{-0.2892537235533523,-0.018099873723103975,-0.9570813330024405},
{-0.0030999160890322294,-0.03151811853083149,-0.9994983735477098},
{0.29310397528138926,-0.008396801750969567,-0.9560436984754418},
{0.8959889421813579,-0.25908199628913076,-0.3606665145083059},
{0.759900044993428,-0.33396638980868226,0.5576902115844793},
{0.49653829484756823,-0.32441817129752293,0.8051102855397143},
{0.6436720057055451,-0.43737665067209835,0.6280031962640461},
{0.7540070721435296,-0.43145800492968184,0.4952951899015786},
{0.538619389589446,-0.13545634923548225,0.8315892799995006},
{0.6141021714333934,-0.12705692970890226,0.7789319993771847},
{0.7294989101940961,0.21732869707645644,0.6485364889138282},
{0.5148146900361822,0.26938094061363427,0.8138794405543508},
{0.4240082231631793,0.07924174028655458,0.9021849994797971},
{0.03403427941170158,-0.2710563226622309,0.961961609301408},
{-0.12914367681682037,-0.9250111184859737,0.3573182634788776},
{-0.5330961624829501,-0.8409718921339134,-0.09259999020873273},
{-0.3863671683569153,-0.6153705606804107,-0.6870512966756821},
{0.06583187982316265,-0.780723523472176,-0.6213991820851869},
{0.3353018135378679,-0.4516004548114233,-0.8268190388787213},
{0.38793045887654887,0.14891888085202193,-0.9095785430635508},
{0.3959675026647957,0.25456224152135737,-0.8822742215575763},
{0.04589943134925296,-0.03148628171746596,-0.9984497264586852},
{0.25773751101831593,-0.12230795582771276,-0.9584425592362485},
{-0.7536049164525862,0.16913992424635818,-0.6351939199366023},
{-0.5761556941764966,0.14582289825308448,-0.8042265218289372},
{-0.48419660230561323,0.21029828644781498,-0.8493104738744323},
{0.1858773895698225,0.238858840443903,-0.9530981326120109},
{0.8008697405012991,-0.08942102480655804,-0.5921245975906818},
{0.9595499158418502,-0.2078369857169892,0.18991510307496362},
{0.5459402831672422,-0.25129493320859225,0.7992496879942841},
{0.5781586765437262,-0.30917544508937167,0.7550782005136923},
{0.19868448311339618,-0.24747637885359874,0.948303705613066},
{-0.0998181622391744,-0.5834829233160085,0.8059677491598525},
{0.608743759473821,-0.7419815776642278,0.2808814228612889},
{0.5897609259927344,0.20251116797753893,0.7817744412658715},
{0.4186067235088578,0.32611897942024937,0.8475935478134987},
{0.27297984495498384,0.2150695926279789,0.9376710908283288},
{0.06810713769069324,0.09376516824923539,0.9932620555617603},
{0.4819125580090085,0.03239225236792256,0.8756203677506289},
{0.795438119687825,0.012609026353162526,0.605903631117955},
{0.6563497976639812,-0.049973803331769054,0.7527998154137716},
{0.24070667824259598,-0.08287119139560865,0.9670535976284292},
{0.4919849985922868,0.08209865514871435,0.866724046039407},
{0.9154506726940719,0.34144856725649386,0.21298577835728658},
{0.9758097433524245,-0.21753767043679015,-0.021741819597486414},
{0.6255435556588319,-0.6887040346395291,0.3665815225088956},
{0.22750625913830325,-0.19383445495548127,-0.9542898438760662},
{0.20974793129339678,-0.2849234783389782,-0.9353204888215366},
{0.35992740390919464,-0.14549772803923816,-0.9215653395449546},
{0.4579820764599244,-0.22686052797857031,-0.8595270318534143},
{0.19490641663652178,-0.3928800311565542,-0.8986972626376113},
{0.22216289237118642,-0.45392788000078654,-0.8628980988571363},
{0.49962749178282506,-0.4054366177793094,-0.7655021348229392},
{0.8159295662490483,-0.083197874825472,-0.5721337750431844},
{0.830554266516742,0.5017085758800314,-0.24180180987591335},
{0.3876344113855436,0.8127508362661455,0.4349432621141109},
{0.9641760520623018,0.25993496642276426,-0.05289946937682727},
{0.9590393042653809,0.10214025765500778,-0.2642176766235419},
{0.9682440135626792,0.06120908176229103,-0.2423983880100105},
{0.6497798137891694,0.6846322530060527,-0.3302497111822639},
{0.8660282577459532,-0.07287366787980377,-0.4946559261903702},
{0.7744594450134044,-0.3573427103599456,-0.5220332895344296},
{0.7655654792823359,-0.27249620567930555,-0.582799549434957},
{0.6986787374606437,-0.26944243348427693,-0.6627584755085912},
{0.625769521583913,-0.21016256389933358,-0.7511619017175319},
{0.6040091026832232,-0.12255538931934473,-0.787498051060821},
{0.5800299841509612,-0.07709370574206303,-0.8109388250791744},
{0.5275977619231005,-0.07553652949334495,-0.8461293248232428},
{0.4924939076172915,-0.1112351436527595,-0.8631781355991363},
{0.3189534009330858,-0.17553738425284263,-0.9313728333824688},
{0.27274594976502653,-0.20875724113667185,-0.9391645548889604},
{0.8969946711082091,0.14885584884826897,-0.41622409380901665},
{0.9355101229962646,0.18929871905965373,-0.2983065616675038},
{0.8671991178609556,0.1590840079031345,-0.47186647307332175},
{0.3316032384113404,-0.12286664048009023,-0.935383921677216},
{0.6345699544340435,-0.7560113609439624,-0.16052350311787264},
{0.8967351026116221,-0.05855489253883559,0.4386769657776539},
{0.8319257216692535,-0.5489378421899536,-0.08103603542208515},
{0.7529929376213228,-0.6518880756453611,-0.08968596726243537},
{0.9067366662491149,-0.4216025998950669,0.008936769056055322},
{0.8371329002922073,-0.477979783352171,-0.26597713051119454},
{0.9305045538286632,-0.2184570710947041,0.29400303296538305},
{0.888247079136596,-0.2713853712466425,0.37063068771841823},
{0.5731298572788828,-0.814986416898099,-0.0855529483249122},
{0.8419365118259441,-0.5243020972336893,0.1274763542415497},
{0.8431082625482332,0.24376498430737673,0.4793194029543595},
{0.7680573090531193,0.18267022514317388,0.6137748437792342},
{0.9403309492306389,-0.20190307478074504,0.2738847464045531},
{0.9391929001352844,-0.31517630187100854,-0.13631065649606616},
{0.9063940257451562,-0.22343680270879757,0.3585050422082778},
{0.6511121161522037,0.10303518626194474,0.7519552929475034},
{0.5312427933064053,0.05388484931733484,0.84550429778568},
{0.6628764829146863,-0.07679557603318589,0.744779972811022},
{0.11145640755081271,-0.06364747786669646,0.9917290294112981},
{-0.23739980628730825,0.03585951473643994,0.9707499303000828},
{-0.26401685979885786,0.02843757372220257,0.9640987512401127},
{-0.06902087345688629,-0.029556466480148494,0.9971772832934253},
{0.05548654454237811,0.07172467442690246,0.9958799196956938},
{0.22914998817836213,0.2634397939156234,0.9370644363647307},
{0.43406463915501975,0.31554719105668566,0.8438115069442097},
{-0.024781822972803246,0.4271035075629723,0.9038630731905972},
{-0.08217937235107127,0.5783033632626788,0.8116722064965991},
{-0.2627422791122267,0.687328374720803,0.6771603946411605},
{-0.39577941141341727,0.7541693908799594,0.5240106748540527},
{-0.3920194792325079,0.7193090898680263,0.5735112563285092},
{-0.18921761905361045,0.25768649375312364,0.9475201124920273},
{0.15014076390155773,-0.6517950294479224,0.7433848199970445},
{0.17494954180595157,-0.9435932021757792,0.28111301398111516},
{-0.030435241317551712,-0.8865512620699645,0.46162815751218594},
{-0.4145809239036477,-0.43923626656795656,0.7969906898243173},
{-0.08745473602963044,-0.9470237678153066,0.30902694435742656},
{0.01067290164254386,-0.9988570546790202,0.046590487102856175},
{-0.00042658288880580126,-0.9999984753212569,0.0016933346392963725},
{0.00018701967684940673,-0.9999963350098849,0.0027009239971598938},
{-0.002866626721674534,-0.999985037347027,0.004659134394222687},
{-0.11509169418831379,-0.9933547471771623,0.0004981861696008712},
{-0.15486033532628193,-0.9867516640767335,-0.048367654320100435},
{-0.003288104067734763,-0.9999743384570307,-0.006364809428690336},
{0.15535028371867698,-0.9065773652886062,0.39240765804822875},
{0.022196945271206376,-0.796188561420818,0.6046412740487335},
{-0.8448536212844008,-0.4895446405868556,-0.2157971350025774},
{-0.06498575001909625,-0.9974530193529861,-0.029399429893568918},
{0.0027572027519245338,-0.9999942566184938,-0.001970929478832594},
{0.005164063824537067,-0.9999823476759382,-0.0029388401343472407},
{0.5330025305610007,-0.7559290272928908,0.38010473308233567},
{0.1518568870915577,-0.6942954924459462,0.7034864995236959},
{-0.8118628335179445,-0.390602041474294,0.433945601139507},
{-0.6735179928864775,-0.15309046657752054,0.7231437079178991},
{-0.08347561174643023,0.31884314449861634,0.9441243940550385},
{0.28173750301792383,0.32983793621065055,0.9010166009733251},
{0.7306365537813652,-0.506455192602232,-0.45790104189085035},
{0.7653408054567694,0.14619773615906959,-0.6268011434615819},
{0.6686728537112377,-0.6727679331899796,-0.3166384733113663},
{0.9356252194586023,-0.05420640474604693,-0.3488081340759559},
{0.7554790438690906,0.3303730506896842,-0.5657782795871861},
{0.31472500093939076,0.27151670882796375,0.9095201210588644},
{-0.8621874522359868,0.12864409196922344,0.48998315767813067},
{-0.3478111695247036,0.5077950352597294,0.7881443982668583},
{0.2209232610731652,0.4248883102162361,0.8778740436750535},
{-0.652990269435743,0.6754819276293298,0.3425315656525694},
{-0.8494295404772737,0.47553773772620006,-0.2287647607539581},
{-0.933453042090564,0.2725056663435997,0.23325110937035787},
{-0.9097249869593361,0.15934803172765133,0.3834170743281513},
{-0.9943850135818277,-0.03462468931765082,0.09999787824511304},
{-0.963771171052496,-0.2642926225599166,-0.035979709677844515},
{0.14867844503031316,0.16784271874862053,0.9745376040699709},
{0.38255813913666614,0.29108233985212745,0.8768810304747742},
{0.4198562201240465,0.20752674198127447,0.8835459273777372},
{0.37067757540222046,0.299397908530945,0.8791808843811535},
{-0.12742343781208018,0.7241051142797813,0.6778163844065852},
{-0.4068941679477472,0.7688504891819365,0.4932606424344105},
{-0.6507778547016094,0.7281084248208076,0.2152819210591853},
{-0.7362674183974681,0.6185489805757182,-0.27442202396139354},
{-0.8325601915819092,0.5093786154201644,-0.2176624762004947},
{-0.7070777498047619,0.45048178352972007,-0.5450754245413355},
{-0.5783752054524499,0.1261296641962867,-0.8059611836357681},
{-0.8810086959134741,0.1286570857816683,-0.45527028455963203},
{-0.9954492517468314,0.09499412461823792,0.007543439844528785},
{-0.9882509660232802,0.018681162018294117,0.15169391002838484},
{-0.7599787748089997,-0.022112292900170603,0.6495716344965418},
{-0.22158646525013317,0.16022948901610773,0.9618866613419632},
{-0.6198448948026003,0.2987316397529126,0.7256388315117165},
{-0.8149576884095397,0.1875130350826606,0.5483455368435749},
{-0.6795377058199176,-0.09940365241197924,0.7268751063670852},
{-0.9495172171081894,-0.3074678742966314,0.06229414651980022},
{-0.4152316973208715,0.13111612032849204,0.9002173073930719},
{0.25767610092723126,0.3291095309235856,0.908454700943419},
{-0.4531238292409845,0.799704105773043,0.393893562506072},
{-0.6766119135258548,0.7337915621906953,0.06120671313360839},
{-0.7309544388211159,0.6477448512997025,0.2147841148279684},
{-0.6225827264200668,0.7528329144857498,0.213619642426084},
{-0.6899667359747375,0.7077389071015551,-0.15182734478038976},
{-0.6781355092516084,0.5874395027410777,-0.44164132699666725},
{-0.5940640976576033,0.6148480606030569,-0.5187000195169819},
{-0.5055215432854733,0.29280790938885093,-0.8116104345519493},
{-0.3095773138948299,0.13332743536703984,-0.9414805795660948},
{-0.47735566572584226,-0.13289589834412682,-0.8686024686833128},
{-0.7745529688262689,0.029999169858378152,-0.6317972366908713},
{-0.852329885683962,0.02591295963613949,-0.5223622157974868},
{-0.8793600845024389,0.021484855051099747,-0.47567241121101067},
{-0.9671067166682342,0.04095101866679599,-0.25105300764049676},
{-0.9927309099194699,-0.05391045564778881,0.10760577708612742},
{-0.9547028786440733,-0.023946450621171605,0.2965956523810957},
{-0.6492501854491961,-0.060754886438892576,0.7581444720289015},
{-0.12772444860153007,-0.04467191427080396,0.9908031516425535},
{0.45065171629088363,0.06973430644488231,0.8899719979351779},
{0.38183865257058197,0.18396430872448818,0.9057352684524345},
{-0.030637801530479226,0.28753186395493463,0.957280916099334},
{-0.23256328345886068,0.08609301225218556,0.9687632901943481},
{0.7497256866820985,0.1656317790476652,0.6406851867325803},
{0.5852504400930783,0.21694118521556552,0.7812928033254395},
{-0.4616009711971314,-0.18918882100745904,0.8666787948228992},
{-0.8806233006482417,-0.20082414669157006,0.4291529616127556},
{-0.9791845559257353,-0.2017299288004569,0.022419662412340727},
{-0.5173919396445656,0.4316514118182844,0.7389063807182313},
{0.03436061706663999,-0.21956075395090366,0.9749935503988273},
{0.8296268635415269,-0.33671006979461876,0.4453600747587862},
{0.823431937127016,-0.5593055323538482,0.09558852649574778},
{0.731001530783275,-0.6415145180422933,-0.23258522122755956},
{0.8928735000780611,-0.42973388631872966,-0.13455742197201034},
{0.9634276991858302,-0.24495908524659557,-0.10863753953697981},
{0.6323750268004162,-0.25685205982470094,-0.730841189892155},
{0.1930903091480988,-0.2284116494361431,-0.9542244237677803},
{-0.2050967994606297,-0.1961540131397656,-0.9588841984203155},
{-0.15786580256024077,-0.3248414708090932,-0.9325000843027287},
{-0.39429137550770726,-0.4145266178556482,-0.8201841221880596},
{-0.28094242654823603,-0.8322271495615108,-0.4779846488098878},
{-0.9080859009336911,0.06033598726721881,-0.41441472604860047},
{-0.9566642911662091,-0.2256893501907695,0.1840047586828203},
{-0.5031017654021103,-0.30798508545643827,0.8074860994380463},
{-0.9603387838621112,-0.0620093678542726,-0.27185337685700145},
{-0.9206481199764148,-0.042998995927899755,-0.3880182025795769},
{-0.9193826804958838,-0.029924679717297387,-0.3922244259961647},
{-0.9559705509385621,0.0039241895912011495,-0.29343637551311585},
{-0.9967338580626098,0.03838655543301387,-0.07104990185505874},
{-0.9152764674736902,0.07829032928401662,0.39514505239150227},
{-0.2015334181953322,0.03098322916029071,0.9789914815059967},
{0.3896321142362478,-0.0021892613165720764,0.9209679813601988},
{0.5799444731278283,-0.017783215946622546,0.8144618869653028},
{0.6289904634365412,-0.01542559896225761,0.7772599615331672},
{0.32490220426648214,0.003942934078503681,0.9457393990596108},
{0.5714534490231797,0.17040959779404308,0.8027462392183377},
{0.6741189165412381,-0.18460837368095778,0.715180700752012},
{0.6190863665296438,-0.24326169808863946,0.7466966030592045},
{0.9504486160014585,-0.3021674945607332,0.0730905847000925},
{0.5708018045973232,0.34036705838635284,0.7472185526563565},
{0.5635740334873243,0.2745235166388555,0.7791156188853259},
{0.7299170541826423,0.08912187162056008,0.6777008086258878},
{0.4690669866344983,-0.055017106411051,0.8814472644757522},
{0.3346646962738278,-0.9419034429867311,0.02859099784352641},
{0.5180617806491674,-0.7620982409569111,0.38835327031067446},
{0.8075055742352264,-0.04345134264948638,-0.5882573657855839},
{0.8642394255823229,0.08698823567669009,-0.49550303946897556},
{0.8487877197386401,0.11482609779030889,-0.5161146908266905},
{0.9701167941544065,0.13005312381274342,0.20484040296319447},
{0.7741884738318731,-0.12351849657930722,0.6207861048611372},
{0.2138593563843866,-0.7700534638420161,0.6010672495750943},
{0.16912432148005596,-0.8500113787238012,0.49887635735117103},
{-0.01638437796768401,-0.9690336741499134,0.2463844364446171},
{0.6283300509980619,-0.7276954150503416,-0.27506495583313373},
{0.8341791407098009,0.036247809986856526,-0.5503010607620294},
{0.7905619463173291,0.15043060549214754,-0.5936180943723179},
{0.8423027331039942,0.21622194521168964,-0.49373492505028904},
{0.9584456124235241,0.19997358982078506,0.20345164388690593},
{0.8888270812969256,0.13484793198271933,0.43795257139691796},
{0.8857912255047466,0.10812415716490896,0.4513126094584298},
{0.9424226403949542,0.05312456973969991,-0.33017775055411375},
{0.9309657933171347,-0.24945747841758895,-0.2665964330874217},
{0.2602250372498307,-0.863316772533589,0.43239690129614905},
{0.2259718554009226,-0.8508641130572695,0.47430684338087564},
{0.3242723276291262,-0.7515091097121173,0.5745272104554227},
{0.6184439641049785,-0.7397232056609141,0.2652105621366936},
{0.04726473653341939,-0.9777337694535784,0.20445713670724058},
{-0.07947096027688114,-0.9943028574908404,0.0710365684575216},
{0.3462962972548594,-0.8119535223992915,0.4699046200783274},
{0.47851985700367194,-0.7443554671735771,0.4657828731737472},
{0.8196728280212741,-0.0754776158822432,-0.5678376392106632},
{0.836149311476859,-0.005810341476736022,-0.5484711194299096},
{0.8186569689738797,0.018916060302989948,-0.5739712099165896},
{0.6272588506038018,0.0746771653046328,-0.7752223263820914},
{0.5530702574144757,0.20626697206440603,-0.8071971423381448},
{0.6751874253119948,0.2644637301894585,-0.6886079262648932},
{0.6589278577642296,0.30988602374769253,-0.6854084406746738},
{0.8758037729713735,0.32305938396940637,-0.35860895928352754},
{0.7969799982909074,0.15414504662713158,0.5840052970004166},
{0.7697917207573808,0.06790518039586327,0.634672823688549},
{0.8828066127166027,0.2221961503084978,-0.4138615170946943},
{0.9411330263745586,0.20955037256601464,-0.2652494449089554},
{0.8744716422124801,0.13905602769404757,-0.46471794470211775},
{0.9103904306334659,0.06768002555455616,-0.40817726290417883},
{0.614442384334521,-0.7692213988221092,-0.17538242764731654},
{0.15624136769850341,-0.9812046109127127,0.11325257852840802},
{0.8945372668805702,-0.4463842020433137,-0.02332857320955721},
{0.9143887926488851,0.1795168780459026,-0.362859237686967},
{0.8913597260987569,0.43352813213068064,-0.13240542791151705},
{0.6467961018574633,-0.7562470311983974,0.09871793365746694},
{0.1541686815552623,-0.9880445415589795,-3.902586431449344e-05},
{0.022406656526285793,-0.9976731927626032,-0.06439054422961885},
{0.2574640717354311,-0.883100522657516,0.39223171550428526},
{0.4253821748909233,-0.6546584521502521,0.6248778411124082},
{0.24301265398932256,-0.7671696902941147,0.5936291066778127},
{0.08874078084624855,-0.8240607140782411,0.5595078313372007},
{0.6118005480789336,-0.7781467713842831,0.14208339647732432},
{0.7898116860139832,-0.15904248896455117,-0.5923706503024183},
{0.728953314355989,-0.01759815878983901,-0.6843371758838083},
{0.7376621525732162,0.037908849219413635,-0.6741049382788329},
{0.78014906250852,0.1063273814287739,-0.6164916286743701},
{0.6802309189928063,0.13330509499599472,-0.7207743395087751},
{0.5020653364910114,0.2779137158408305,-0.8189593179405859},
{0.36971859875625684,0.38185998449873065,-0.8470484696712102},
{0.6315122304904999,0.3824632009237288,-0.6744732779585038},
{0.5958300991258039,0.4068632276117469,-0.6924224194760643},
{0.41575638687362554,0.5240182277379498,-0.7433380951977144},
{0.5773022449183829,0.3962770542602351,-0.7139233952456147},
{0.795958754525296,0.528202786071237,-0.2957219604309471},
{0.8323630808049886,0.5453916686733739,0.09858818110960738},
{0.7442203355514635,0.17803406353766046,0.6437701176444396},
{0.5737861561555267,-0.12921050695771744,0.8087484725772254},
{0.7694350968018948,0.07652179229246953,0.634124630584404},
{0.9764913109711182,0.21546100020781753,0.006424716908454582},
{0.8319178186513586,0.23699067211211072,-0.5017451189022322},
{0.8640673937076588,0.18304429946061898,-0.4689161157032514},
{0.9559575833747418,0.1387589807245315,-0.25863302970930213},
{0.9718931594948202,0.04432190288759855,-0.23121257632663064},
{0.7145293221584543,-0.6983241730985992,-0.04232253586373836},
{0.22592482676647271,-0.966168511699511,0.12440409820778042},
{0.5737039893003719,-0.8142996104801882,0.08820361122228922},
{0.9844009272242973,0.12283012649258915,-0.1259665610618879},
{0.8809475200737578,0.1118200026339101,-0.4598127378475376},
{0.7805584902764221,0.2670264790668714,-0.5651772312598432},
{0.7445530337337821,0.42329728601788846,-0.5161978182903443},
{0.8954219377521221,0.4096957530198403,-0.1742668739311649},
{0.8628211424501399,0.5049634950552405,0.023484991007696875},
{0.9809445279677416,0.19271783211741417,0.02465096821848609},
{0.23874879750935607,-0.9391268763741935,-0.2470621819694121},
{0.4812967288809821,-0.8765526669424779,0.0029800745788406404},
{0.7186076898814417,-0.44466876023550744,0.5346706291857394},
{0.8488291354761709,-0.35378787658413524,0.39283996378788294},
{0.41229147500932845,-0.7507552812219443,0.516122318207604},
{0.14962321043928983,-0.8418152716277931,0.518613481652825},
{-0.02983974251409276,-0.8860040526798105,0.46271633686487007},
{0.1515538461289411,-0.9101142135261131,0.3856469240915448},
{0.46629242867789517,-0.8759479246896424,-0.12363900755658912},
{0.7244681250966911,-0.188284469337838,-0.6630949361328692},
{0.6852443065395827,-0.13837341433200537,-0.7150475778304473},
{0.5888951762701956,0.017457610928047585,-0.8080208556630083},
{0.6503974715492402,0.10947917818223954,-0.7516631150634551},
{0.6036305150951956,0.18367451333578488,-0.7758181967424916},
{0.6715987700821435,0.25383345955207015,-0.6960773425676055},
{0.42063769634666204,0.4034585383034965,-0.8125793107642967},
{0.23400495381688471,0.5757496925128309,-0.7834245165684685},
{0.480508963886862,0.5248932791449452,-0.7025654283643916},
{0.6335580752666934,0.4604882628177396,-0.6217352531998354},
{0.4214634440364257,0.5921376785958493,-0.6868344305056885},
{0.13421537568339909,0.7367238378382531,-0.6627399336776376},
{0.558575367652805,0.7803848877212434,-0.2810569082371681},
{-0.10263502531360448,0.7924206028611624,-0.6012783379933352},
{-0.6184900700516464,0.7484297751175042,-0.23942202272362367},
{-0.4235243014396632,0.6295192847364383,-0.6514081947864707},
{0.04417530485030551,0.5760869950358166,-0.8161937984277908},
{-0.01772344624215603,0.44762128259899653,-0.8940475752540973},
{-0.42476564880850515,0.4527555012131361,-0.7839557383638004},
{-0.8346463847442908,0.42709132207889017,-0.34779076330200503},
{-0.830861196424658,0.554800836865875,-0.04319379224738692},
{-0.6942059669706654,0.6697799731318187,0.26357705327638786},
{-0.515634434288754,0.8567586883114245,0.009256358819970141},
{-0.22356522603239257,0.9116462800124591,-0.3448472848211658},
{0.19936905021278425,0.8736356213421547,-0.44386122035987763},
{0.3925791996879534,0.719950861499571,-0.5723218753449772},
{0.2290318627885627,0.6578603908753574,-0.7174706349007761},
{0.26081860060800677,0.6075531425469738,-0.7502351874966793},
{-0.03908515856264566,0.545768869096854,-0.8370237104795025},
{0.22683144108371633,0.426201900394654,-0.875727947159316},
{-0.0401353573583895,0.43392560283979725,-0.9000542896347047},
{-0.25937502446832345,0.14539085353982695,-0.954770179880487},
{-0.11858582684501666,0.21587890637278345,-0.9691922923005396},
{-0.5808581832238755,0.3075705529490702,-0.7536604845289834},
{-0.6472363474009246,0.3363766257554246,-0.6840583865785906},
{-0.8631924887496544,0.30840409431220134,-0.39973196266704586},
{-0.9568918178631567,0.28499680226311913,0.0559899241501522},
{-0.9292202294467992,0.34121269100742324,0.1418579031365916},
{-0.8647842496668816,0.43171402428240846,0.256458968971601},
{-0.8097111677899949,0.514725928399131,0.2818244904010568},
{-0.6966796362785445,0.6633844898998829,0.27305402936977},
{-0.682023588766361,0.7006838221323811,0.20948987032363087},
{-0.7042869841980072,0.6519275121732256,0.28101665922308755},
{-0.5251816138737795,0.8372512077758048,0.15229802207149296},
{-0.27040226849259025,0.952132111415514,-0.14257298343478922},
{0.01131962397936419,0.9483919935044482,-0.31689823724600363},
{-0.12147266910990374,0.9023143234834875,-0.4136100244141241},
{0.2264645049066252,0.8852512048609158,-0.4062562397178586},
{0.512926525315469,0.7748076509214167,-0.3695666160537712},
{0.40406861751004836,0.7398902924806672,-0.5378577018472367},
{0.06573534445540653,0.7240863665973855,-0.6865695872940527},
{-0.16425104499434953,0.11955119005087253,-0.9791471325473431},
{-0.6017879285940259,-0.05346299223287386,-0.7968644787289866},
{-0.1743253603864587,0.0010125028488856187,-0.9846875867827888},
{0.8080813822477648,0.15162382716326472,-0.5692228866629542},
{0.8728386780063423,0.22168168396186427,-0.43475265746395697},
{-0.08881797686361652,0.07504919578577124,-0.9932164845580056},
{-0.7248468950018979,0.02950921946473817,-0.6882776945192177},
{-0.6212869530985717,0.2149142843281275,-0.7535345860020108},
{0.5365861029476523,0.19161110597524025,-0.8218032235215416},
{-0.33720719776314684,0.1666961152546567,-0.9265547533393437},
{0.2528238868523913,0.46859810431278115,-0.8464608076404466},
{0.41117797567485587,0.16225088123228745,-0.8969990656958756},
{0.2275077328400479,0.04105432735949119,-0.9729104654093517},
{0.03795772840869713,0.05771600179731532,-0.9976111837738108},
{0.798571304589179,0.15806510119299655,-0.5807747371155054},
{0.9139035584197166,0.11765611885135954,-0.38850652968079497},
{0.9143380417514896,0.18696848811688452,-0.35920569296342975},
{0.8958526572378588,0.3132832405424515,-0.31512160782004184},
{0.8117821806548097,0.4535248808088351,-0.3678652928160713},
{0.5827909149812226,0.5741928349261294,-0.5750281190818795},
{-0.23755241799903115,0.48347625963860613,-0.8425078961461885},
{-0.5460203036969971,0.47379877815970006,-0.6909244139303621},
{0.06475444614996731,0.4515075084013837,-0.8899145080068003},
{0.9979980346042486,0.03351423577390528,0.053635053151349275},
{0.9962989444736814,0.023034042164632815,0.08281211349909036},
{0.9504213006884782,-0.06105154873317091,-0.30491320009947553},
{0.40137945659777813,0.5476273210087058,-0.7341654099084893},
{0.6992751220740384,0.6433437765147927,-0.3116457746673671},
{0.7886933812933503,0.45446610476667376,-0.41403298168415137},
{0.778498436360451,0.21194193757734472,-0.5907798233524006},
{0.7311287906744032,0.08031752195735083,-0.6774952303253617},
{0.5803382484880911,0.030216779333510656,-0.8138147599966987},
{0.17421845963190333,-0.0019555297382284967,-0.9847050848994992},
{0.11257051065523985,0.0104344014791009,-0.9935889509231629},
{0.8716879614614781,0.10510686684957204,-0.47865712611868516},
{0.9270098898695065,0.07836008471955834,-0.36675926874023096},
{0.9089332777487131,0.06953783790438745,-0.41110191643990657},
{0.9042551347685334,0.11949609579974624,-0.40993088970381275},
{0.8512475678708282,0.1957017999136619,-0.48690695590076855},
{0.8223853034955969,0.3769598735339541,-0.4261263502058047},
{0.7752544122707646,0.5654821490219274,-0.28144366291009987},
{0.8074800483927906,0.5532850916101199,-0.20457658431393816},
{0.7630161491204874,0.5848242964988591,-0.27529420336424903},
{0.4982466144133626,0.7712734026416045,-0.3960904563395377},
{-0.17815941631382276,0.8094564629164485,-0.5594992913503203},
{-0.01844934955240568,0.7338879032444519,-0.679020004839736},
{0.7510932055349627,0.2888823208545739,-0.5936379378854499},
{0.854723407764435,-0.47429314139110973,0.21093580124982145},
{0.9687850937903868,-0.10800472146119541,0.22313767541955126},
{0.9566598822001365,-0.290779945284914,0.015776349670419902},
{0.5195410007982676,-0.8233058585445884,-0.2285708025441853},
{0.8484708197830262,0.0650045513236759,-0.5252348772539075},
{0.8479790962021693,0.5247913356195345,-0.07433375049610474},
{0.8933193194748461,0.4461575183909167,-0.05407459880809789},
{0.905824542208707,0.23229866090235815,-0.3542869329729192},
{0.8952309275736634,0.10972930910089887,-0.4318808458820994},
{0.8684762909977016,0.05760204816761904,-0.4923727612508339},
{0.6351922798265812,-0.03767382694159421,-0.7714346702166586},
{0.35344994570479293,-0.0049925292227238245,-0.9354401159525068},
{-0.0019049296095249833,-0.026275712645250134,-0.9996529188514217},
{0.6099520950579026,0.03079370310702169,-0.7918397499389837},
{0.8840011087893481,0.06462824227763285,-0.46299592866385614},
{0.9218675595415592,0.053024598716021984,-0.38386012373766404},
{0.8762893801879359,0.06415209619411259,-0.4774949536107628},
{0.7288386135111319,0.09626954863444584,-0.6778838023296402},
{0.59296146515949,0.19461693782848194,-0.7813583994212744},
{0.7038059801651798,0.32255358855613,-0.6329425920202347},
{0.5401420969456215,0.5357210489969163,-0.649037343123514},
{0.5956451922665977,0.6515508918615314,-0.4697746696493233},
{0.7069616741949764,0.5103427517669994,-0.48964830944089127},
{0.8175944466177815,0.5112599195587111,-0.2648633902837158},
{0.8685838831147193,0.31142843733150144,-0.3854534555748782},
{0.6842157605684953,0.6553814743516071,-0.31988109676313975},
{0.6729363693761864,0.4847842682777535,-0.5586956738701312},
{-0.33806955916022413,0.8667657799491808,-0.3666415904917229},
{-0.6983521306065086,0.685160338021622,-0.2070256333873814},
{-0.40988785081504014,0.8920877271957193,-0.19018789851355763},
{-0.6101272587134889,0.6967946034796801,-0.37712333358777844},
{-0.9628891065087446,0.24168075888074042,-0.12014565890460215},
{-0.6764910637683653,0.7360146555202519,-0.02534299707908322},
{-0.7771098544246268,0.6292758658909922,0.010590503447776598},
{-0.6295512547650937,0.7763505980604953,-0.030740307656356953},
{-0.5335454792292325,0.7933419613732999,-0.29315141807334705},
{-0.595674979774392,0.642046224069483,-0.4826468321960657},
{-0.6276844761666355,0.5663225833534723,-0.534126323975205},
{0.07025863430699136,0.9118337979252699,-0.4045032129248105},
{0.33013966641740033,0.8848321767793956,-0.3287549537172696},
{-0.2613129095455237,0.7921504880775164,-0.5515552261953516},
{-0.6867268710216227,0.4164015583892872,-0.5958321464874353},
{-0.9478067086234656,0.030441012635715,-0.31738901656809954},
{-0.9879272947991564,-0.1548275543311978,-0.005299868926739619},
{-0.9816925752647817,0.14088168481569333,0.12818751325106778},
{-0.7162742654723302,0.6759739532111043,0.17323507497682256},
{-0.7476547063534507,0.6365165456093647,0.18936506339094641},
{-0.5402566356222203,0.8132904709792655,0.21605873618181717},
{-0.46711815426794845,0.8835327141240834,-0.03421363800936357},
{-0.6608215302238651,0.7465591674697882,-0.07722897551700386},
{-0.7645895315840397,0.5964060865584508,-0.24434121246349808},
{-0.6799023939542332,0.6015728755091196,-0.41933615411384684},
{-0.4815206115238721,0.7275791911448289,-0.4886373105798539},
{-0.4517911709371601,0.6577859499869284,-0.6026627430520523},
{-0.5503179307109399,0.556290785940501,-0.6226481643879861},
{-0.4744267248956195,0.6115390380252104,-0.6331976687228218},
{0.5647226168609677,0.7871681390406432,-0.24790055846042625},
{0.6135058213169716,0.7538652721018371,-0.23515475485095225},
{0.14586396108174424,0.865147326031916,-0.47983727358070966},
{-0.23689032748427846,0.7071540597925094,-0.6661952480041893},
{-0.6211436796024864,0.34599222099642524,-0.70318554613974},
{-0.5939878422986942,0.4204986658032576,-0.6858274675594597},
{-0.6294520058871558,0.35052809217737024,-0.6934841230187819},
{-0.7715206352307966,0.13156377698543031,-0.6224523130316055},
{-0.8051307758406321,0.1314648089235069,-0.5783437021434295},
{-0.9297492464240973,-0.07315437939805058,-0.3608528447285808},
{-0.9798681700198556,-0.11199998756721688,-0.1652706028514533},
{-0.9948568519047294,-0.10128635121908891,0.0009587882636805379},
{-0.9787385262371946,-0.1528178762870428,0.13681225802596206},
{-0.9753501614379116,-0.11997007318471574,-0.1852005510874456},
{-0.9736347953625517,-0.2050943544956256,0.0998578540393527},
{-0.990904052175989,0.07618680512428372,0.11092668797975998},
{-0.744545421200678,0.5785623520720172,0.3330431211329852},
{-0.6962420803572473,0.6013391690825659,0.3919670512516347},
{-0.505850822212615,0.6671318289894499,0.5468547050323448},
{-0.38901269663589955,0.8440194171156787,0.3691887666056157},
{-0.6527104399503657,0.7331863861810172,0.19080567260598053},
{-0.9310974333968124,0.33022072372358613,0.15495755272118725},
{-0.7695408752365548,0.6231153029175734,-0.13976466152106556},
{-0.8389359572109354,0.3837217203503979,-0.3859327674996029},
{-0.9124342472021489,0.1636279870732449,-0.3750861586075999},
{-0.5216733769718577,0.6414229765633327,-0.5625241798317763},
{-0.597952363118591,0.4405830837812816,-0.6695815990054304},
{-0.4462932301676834,0.5254012577612804,-0.7244141571293039},
{-0.5094947234079611,0.4140237535820109,-0.7543205275539752},
{-0.5851051050086201,0.45691122806507206,-0.6699881683738298},
{-0.4913973407588921,0.4812826737026753,-0.7258757755213309},
{0.47847906583670113,0.8046579747619067,-0.3515442037754346},
{0.715602683335073,0.6925802688748758,-0.09080402396836762},
{0.3319334828132753,0.8232740702306556,-0.46047797805465013},
{-0.21002099858128892,0.681625369850992,-0.7009122879008589},
{0.04609540846513728,0.8259764319208514,-0.5618168271151476},
{-0.17717521875454903,0.723093955680457,-0.6676406766499978},
{-0.4583350890721658,0.49675869971064895,-0.736993718010537},
{-0.5497460514100623,0.28101919593440755,-0.7866431786238435},
{-0.5336339378786024,0.14123036453100418,-0.8338397954515098},
{-0.3753392688703895,0.3758804217929015,-0.8472510500180168},
{-0.46703549136563743,0.28312033809874715,-0.8376877246084657},
{-0.7019415343859376,0.01101419355514284,-0.7121494013507598},
{-0.572406091447867,0.4861214181411521,-0.6603311542686828},
{-0.7422352071264638,-0.03966459050437621,-0.6689645861793099},
{-0.8440342248731671,-0.08108499050196163,-0.5301239963990018},
{-0.9167415645298457,-0.1135426395074412,-0.38300518648845217},
{-0.9752185791174858,-0.12269209224754193,-0.18410696196503},
{-0.9891192333660103,-0.04651298713781843,-0.1395696392950606},
{-0.9999115206121469,-0.010533846580267518,0.008123362809047132},
{-0.9824964194186867,-0.08731453894496742,0.164550773678788},
{-0.9398797608562549,-0.13165044926133104,0.31510981314785913},
{-0.9088353492038035,0.3002140175739736,-0.2896374487004301},
{-0.49235671395691266,0.35705325862170356,-0.7937870222730865},
{-0.36272335685473345,0.0921731335077199,-0.9273272776379448},
{-0.7958278217507729,-0.12098695313737283,-0.5933129320164486},
{-0.7098779669879703,-0.02550948373123773,-0.7038625847598321},
{-0.7196756910147536,0.5010903095599222,0.48059900273260886},
{-0.3848183545297172,0.6295606581869505,0.674957933267144},
{-0.3295528442023049,0.7133874811565986,0.6184441968417322},
{-0.5544071170968474,0.6771112141077938,0.48389374065163493},
{-0.9031611096252935,0.2503529738010291,0.34874546386926625},
{-0.5700497337630724,0.7297058954674583,0.3775878800447457},
{-0.6247101685426893,0.7703184344723862,0.12785427185423562},
{-0.5768869319174864,0.8119750481609042,-0.08887063039568653},
{-0.588682618822012,0.7243922962729098,-0.3587597739397751},
{-0.565705246864234,0.5572659785442241,-0.6078093474334074},
{-0.6911389501076067,0.41528710362629523,-0.5914926653863409},
{-0.9052784211294297,-0.06338458090305324,-0.4200635370288061},
{-0.8272484500172804,0.19985912798033326,-0.5250869746117758},
{-0.842240584106973,-0.11657742702089559,-0.5263463707411049},
{-0.6391761429347366,0.20673396790129922,-0.7407529445225701},
{-0.4681334616358778,0.2994848140674264,-0.831360275837022},
{-0.4135948048077616,0.4234248707742599,-0.8060091291330581},
{-0.46208631633716074,0.3083673603997102,-0.8314961258442931},
{-0.4547906482795082,0.3545840244428869,-0.8169673407471016},
{0.33778504182449837,0.4797026397272952,0.8098065466259745},
{0.2713104430302181,0.3668131761795355,0.8898532110881142},
{0.8021492623361867,0.16846840978286287,0.5728655652408728},
{0.6637464128226789,0.2755009359498129,0.6953703572599305},
{0.6865724309894244,0.14718351526021053,0.712007942259719},
{0.8230091660292265,-0.03477232567995071,0.5669627836098985},
{0.9682463559661835,-0.21165916861177012,0.13303905629844637},
{0.6270082392497494,-0.03966994646137722,0.7780019044068469},
{0.04766847290721289,-0.255195179556207,0.965713796640583},
{0.04717014654199156,0.16065255245909577,0.9858832256730938},
{0.09805634734206521,0.4779893665234112,0.8728752019827808},
{0.12431027998464446,0.516626069825301,0.8471389840321377},
{0.19793912248992357,0.551532891963906,0.8103280649649557},
{0.3009686550966131,0.5432352253995167,0.7837814481948857},
{0.49459950861383173,0.33552142105236843,0.801746033413297},
{0.5361845757453537,0.17463483683022796,0.8258382253795562},
{0.653680016097698,-0.08209763872772625,0.7523047349776852},
{0.7877767610207866,-0.5043014185624153,0.3536776131331105},
{0.8882493455861206,-0.4296704091314843,0.16246981129616472},
{0.8903398704632322,-0.4535473529034006,-0.039871214401284626},
{0.9442859386663811,-0.31506162771413365,-0.09518527606238458},
{0.9440632191826726,-0.32340388217166866,-0.06445593209893681},
{0.9236530958618465,-0.25952534116904763,0.2819779349451232},
{0.12459262606637492,-0.13311424628709398,0.9832381578057797},
{-0.07111333220804275,-0.2350068326133545,0.9693888191057846},
{0.06368304615273532,-0.15417801203786594,0.985988646099315},
{0.15322470309718814,0.3811329564523879,0.9117345336591353},
{0.17735430405778407,0.5183046783150821,0.8366036763419573},
{0.2173369472213854,0.4669348534422887,0.8571677163853741},
{0.23997412301603446,0.4825716046981166,0.8423402321044446},
{0.28581658497568574,0.5663833702183234,0.7729933749347212},
{0.2138144793470536,0.5402308411105833,0.8139004894546384},
{0.19804446204109977,0.5963027921264761,0.7779468948180331},
{0.23055353540045512,0.5204821079359218,0.8221577966746594},
{0.3099392876540589,0.3089670615417671,0.8991534868145374},
{0.4690862810212001,0.020356808732938502,0.8829176979174844},
{0.40875229201683566,-0.1594497475340469,0.8986085587074676},
{0.56106318664222,-0.47091567393921174,0.68076907144292},
{0.7035729704778517,-0.3381929316969668,0.6249884928246142},
{0.6553765625436911,-0.6596813254413392,0.36783435148497656},
{0.7333816705892499,-0.5738049586079452,0.3645534181991104},
{0.830762874140876,-0.5433850007211647,0.12068880619365929},
{0.9181330351609398,-0.39076602454372655,0.06583041704601231},
{0.95433813233692,-0.1402780408444623,0.26374381589815254},
{0.9957496935739704,-0.09115434768591757,-0.013169382874642123},
{0.21929615339902955,0.3907195568727467,0.8940063897878772},
{-0.7012973084570999,0.191457481494521,0.6866775938754682},
{-0.7664178725434002,0.21801742496355725,0.604211922307321},
{-0.8168033272570349,0.03545654452192047,0.5758256316215894},
{-0.47242095262516987,0.13740658133277106,0.8705962755072914},
{-0.4969145219689383,0.10990610169059924,0.8608115976609267},
{-0.10060358860604134,0.40546061787961124,0.9085596322246936},
{0.6954965111825931,-0.038575773207596975,0.7174932143611372},
{0.8510877015251084,-0.2948762650486724,0.4343934997483886},
{0.6873501685064208,-0.4757368130065584,0.5488389842244787},
{0.3100885722762583,0.02780355662428349,0.9503010257716824},
{0.5270956757483928,-0.6520218955057081,0.5450115561971955},
{0.6737978402890537,-0.47826945819383326,0.5632537578931757},
{0.7736595360334749,-0.633034640149092,0.026796766144030964},
{0.7780488631282632,-0.6059947972436635,-0.16556047927699608},
{0.7244236792837511,-0.5763327419875103,0.3782207072677945},
{0.6901634498092301,-0.12067843498983882,0.7135202364865524},
{0.7443753049719946,-0.02019400767943695,0.6674560715145924},
{0.6636484176334083,0.23534762475359974,0.7100579365766656},
{0.4440026968461242,-0.17192344249688918,-0.8793770153429004},
{0.4671723312686641,-0.14338090723898025,-0.872463138669095},
{0.34662884325168675,-0.15434843730770656,-0.9252161936145878},
{0.3339679721461757,-0.21315690430477185,-0.9181663943576772},
{0.2350697317891414,-0.2108871843054068,-0.9488249663095499},
{0.16512963932867675,-0.06990221365460103,-0.98379158501248},
{0.2583215563871258,-0.08581474310025033,-0.9622399926070266},
{0.3780267026914424,-0.1118917212484818,-0.9190081908058751},
{0.5476440373318561,-0.10456601417319569,-0.8301517674827873},
{0.59548020764479,-0.12064947531861867,-0.7942587905768874},
{0.5424618059126879,-0.13529452476682644,-0.8291143351155279},
{0.460986871389162,-0.12664578152285041,-0.8783233746344785},
{0.33331484423589447,-0.16021186540707982,-0.9291035317954535},
{0.20820480613749784,-0.19738164144089948,-0.9579620275999164},
{0.09294747101312821,-0.2670733875724218,-0.9591832845097201},
{0.042337330860199494,-0.08002518428271664,-0.9958933277696719},
{0.10209152125940014,-0.17038010090957442,-0.980075477961256},
{0.13256308420249477,-0.24716401736723978,-0.9598629991960359},
{0.2657492582386531,-0.20325291991450967,-0.9423723161743619},
{-0.24424986958065326,0.6764736874702161,-0.6947843920024991},
{-0.36837101171551573,0.5474479902509818,-0.7514010218903406},
{-0.23558637170943872,0.30611571161103757,-0.9223839940987973},
{0.45563476957964205,-0.07861718766224256,-0.8866883863873408},
{0.7268540468970729,-0.08942549288237979,-0.6809451341569974},
{0.6843151380318149,-0.0984785915638426,-0.7225058884632706},
{0.5739597962579732,-0.08324997085957674,-0.81464077643547},
{0.4395154015950247,-0.05877105368679652,-0.896310311783429},
{0.2694117499490075,-0.1000393465414071,-0.9578149289570411},
{0.1870304047485959,-0.15317627357093444,-0.9703384239091527},
{0.09631307697469119,-0.1835051017617638,-0.9782891539984853},
{-0.05176528673457741,-0.19546464137351824,-0.9793436215455783},
{-0.18192183600749712,-0.12519642393265168,-0.9753103613815128},
{-0.19028750215550705,0.007861547567302085,-0.9816969301129881},
{0.06011663651034954,0.13117052277794916,-0.9895353879315494},
{0.41515969253520646,0.5560461096751685,-0.7200383000988095},
{0.047608970879711957,-0.25504953054460444,-0.965755208559991},
{0.2774234086852937,0.7054810074485263,-0.6521754368594733},
{0.05373508888712106,0.7247920938028788,-0.6868689547381891},
{-0.0750547719893407,0.7053425633378986,-0.7048820110809686},
{-0.332067056280094,0.9418644466188345,-0.05121361468271715},
{-0.37035298723455046,0.8639490259579242,-0.3412194973807897},
{-0.5797675146118453,0.7739087611267599,-0.25482319056955455},
{-0.5714882725030724,0.5939209358303416,-0.5662676720190422},
{-0.3857742087276212,0.3693271414548354,-0.8454440977766525},
{-0.4623389750776382,0.29556444548018895,-0.8359930207197591},
{-0.2943091935524269,0.20446831276701227,-0.9335817091528366},
{0.24424312898828018,0.1038682114317959,-0.9641352024461994},
{0.3801086503585935,-0.02630614414820751,-0.9245676831377042},
{0.38943938269802864,0.021608917783429084,-0.920798578341652},
{0.5096959568591424,-0.02790246210882539,-0.8599020200986325},
{0.48432475745126247,0.020474002995768216,-0.8746486977759157},
{0.3542316304564491,0.04423583778706467,-0.934110883481957},
{-0.3197996226951093,0.07535205838064087,-0.9444841283059584},
{-0.5810288905107375,0.08218390676883192,-0.8097229364789373},
{-0.7602767194792501,0.09240355420937539,-0.6429936959157101},
{-0.19199113568342996,0.11175590395896405,-0.9750128315818729},
{0.3081545816908645,0.09596977379166184,-0.9464832572746893},
{0.7424396527354591,0.0940218847528741,-0.6632821776842556},
{0.8247006300240386,0.14298738415756326,-0.5471960149797612},
{0.7901012602492435,0.12406890535519254,-0.6002890181208729},
{0.6874163489821118,0.1954066407504371,-0.6994819568099901},
{0.1836063723997383,0.08425691281834037,-0.9793821892685874},
{-0.35952282685035536,-0.1977125163198072,-0.9119501619408921},
{0.5967659727716885,-0.051551335613940145,-0.8007576621789385},
{0.7200936265905957,0.02691591132724506,-0.6933546730649671},
{0.7861459077977707,0.05573391074692461,-0.6155228207350826},
{0.7275035621155235,0.03003681254124713,-0.6854461007268089},
{-0.2792722784816432,-0.6942454789316254,-0.6633477289134785},
{-0.1867801431062478,-0.7094754088543176,-0.6795276465105806},
{0.34718681684971403,0.8930493346185326,0.28622403837406657},
{0.3416237819144534,0.8738469372482163,-0.3459547974698112},
{0.8564926999316825,0.5092005982118517,0.08446896320204995},
{0.8161874611297183,0.49717288677133126,0.2943758634027008},
{0.7964902069125026,0.5890898820673987,0.13629549199550706},
{0.8619456250395093,0.5068445080260505,0.012585076840465264},
{0.6189413558962521,0.7734665515991537,0.13660560573645128},
{0.4651266508454836,0.8721696602515218,-0.15158259270116975},
{0.4776690653658614,0.8430986235726189,-0.24701614304020658},
{0.4705051499078818,0.8441908746483305,-0.25683977704134586},
{0.0794137367098302,0.9934365812823609,-0.0823238567597329},
{0.3334107062218909,0.8809012763366534,0.33593190132089984},
{0.12127633584386194,0.9922632889266204,0.0265634299896081},
{0.7245211157521021,0.6627033997811523,0.18945542153190326},
{0.46747747564062025,0.871803002152606,-0.14637054077367007},
{0.6842879566166666,0.6219049473988243,0.38076794616964915},
{0.716096883902931,0.6361245070532721,0.2873166622226142},
{0.7873525044243157,0.6138634035617434,0.05698908267685926},
{0.8018162852536644,0.5911478389754329,-0.08737778422854386},
{0.6759505459697069,0.7298923634737553,-0.10172510577999162},
{0.46789163768832737,0.8665783791903171,-0.17354920945143548},
{0.10852000908542268,0.99362764520195,-0.03045505407198699},
{0.015469603165438663,0.9455008833144519,0.32525185784172705},
{0.5026336825087537,0.8106170065367686,0.30043210534338316},
{0.6361652865101906,0.6575388726365069,0.4036537615473424},
{0.8965847061838578,0.4374042313026746,-0.06937869324022765},
{0.7858485681176354,0.4300112871088313,-0.44444608328397783},
{0.8393170869607636,0.5431723900720665,0.022596066009305145},
{-0.14859657467000195,-0.8566650418796395,-0.4940081618938072},
{-0.26701831846827734,-0.8925512547156221,0.36339162801025315},
{-0.1632846659255061,-0.8851060911777431,0.4358042281043779},
{0.08321013359468504,-0.6885164701370844,-0.7204312208789428},
{-0.4176696996031144,-0.8921731218009867,-0.1719858795637761},
{-0.14540205090522465,-0.9122288997863793,0.38301002335067735},
{-0.16540075288639666,-0.8602966792310427,0.48221594192711376},
{-0.18450933108422216,-0.940009001893368,0.2869483979782552},
{-0.3208338233998409,-0.9313887295999786,0.17199038384973003},
{-0.3196454519537048,-0.9204409802649755,0.22497819204127953},
{-0.35365561169755017,-0.9320535435260867,-0.07876484187311386},
{-0.11481333860483528,-0.19284756104162384,-0.9744884378373653},
{0.06342455605117876,-0.259784884236562,-0.9635814130689254},
{0.128785609248565,-0.3066823689186866,-0.9430589543845594},
{-0.46661519369948434,-0.09380804269019062,-0.8794716096244539},
{-0.6625228163088306,-0.3241342605916503,-0.675278090108749},
{-0.03715500143026767,-0.4490480305917391,-0.8927347714133226},
{-0.019613934544633515,-0.9713917064169043,0.23667160006247778},
{-0.08840470038778761,-0.8718453851429742,0.481736684667303},
{-0.03949439314308033,-0.9293046774045668,0.3671961457644317},
{-0.08057976488877185,-0.987995500214915,0.13180209803167},
{-0.19083565191859705,-0.9810196733524167,0.03438247303964421},
{-0.3352449290151055,-0.9415504218935058,-0.03307023740189956},
{-0.37678811358675973,-0.926271303169184,0.007224291314216074},
{-0.07139239876464622,-0.9921089338833088,0.10306788397728117},
{-0.023850763252248452,-0.9464830620566591,0.32187102126804706},
{-0.2585693133137066,-0.9012775268602703,0.34762153240142246},
{-0.4857534031098634,-0.8704195834039803,0.08008358254990733},
{-0.43023005943107434,-0.33655510709106556,-0.8376352164593222},
{-0.8026527133102133,-0.09925601738766295,-0.5881299727339974},
{-0.5722754919803276,0.06042197321239927,-0.8178324684382458},
{0.025771353628853712,0.08554157509108419,-0.9960012431031765},
{0.08942376945054605,-0.032366642865705016,-0.9954676237260854},
{0.1100127974048927,-0.1504065177945475,-0.9824841290382601},
{-0.1387888870825239,0.018110177669835525,-0.9901563847631147},
{-0.2066729554850062,-0.038562716042209275,-0.977649838338114},
{-0.03601731945529007,-0.0957812835776765,-0.9947505709550855},
{0.004442070267411613,-0.2484683388116809,-0.968629832608878},
{0.4370517446179845,-0.5351401716341787,-0.7229182313579577},
{0.0705110504212326,-0.8635948699346782,0.49923150180151965},
{-0.007540878357525657,-0.8784536699532521,0.47776802414902125},
{0.07156191772291653,-0.8899790216848176,0.45035123280918593},
{0.04264100735238212,-0.9550755404094029,0.29327880353626173},
{0.033778350849887444,-0.9976267697347497,0.059998761007796},
{-0.07743218631113195,-0.9956069082743487,-0.052641625349820136},
{-0.18988671830185788,-0.9636118293353026,-0.18813632445017758},
{-0.38122950407002953,-0.907139371937538,-0.17821959798879672},
{-0.289617361783292,-0.940312379570509,-0.17870202175726105},
{0.22028803604955763,-0.9734277983605748,-0.06254200630226898},
{0.28285115360905705,-0.9365496399902427,0.2070507105425447},
{0.20546708323950166,-0.9110450385256715,0.35746358623335267},
{-0.04428120949718111,-0.8614700778494814,0.5058739758630357},
{-0.35752659988162705,0.5831906110798475,0.7294267896954408},
{-0.6686944417968406,0.3191398651713555,0.6715634668208367},
{-0.5722418606881179,0.5112342233994585,0.6412322681379604},
{-0.38739032755590097,0.5500521846462663,0.7398454759488643},
{-0.5731266732345668,0.21197814903214104,0.7915750632504699},
{-0.7510212113171776,0.2216500752011255,0.6219633303620196},
{-0.8425454326197285,0.21717819087713816,0.49290042339093987},
{-0.767532481231077,0.0547954687273526,0.6386637197009207},
{-0.5307288273907759,0.055882203733543856,0.8456973992405881},
{-0.4266059580640985,0.1817839728504038,0.8859807806938795},
{-0.25591383543395146,0.11842607083033146,0.9594182479925915},
{-0.06983374527048432,0.19847908745949974,0.9776140853438751},
{-0.09762300984374868,0.6637738253045412,0.7415349329530091},
{-0.15128494660825273,0.6443929951398865,0.7495802376959949},
{-0.24418589826198583,0.30355943916752004,0.9209912670499584},
{-0.29238665204010383,-0.03698469367956946,0.9555847310114408},
{-0.4611426824837758,-0.07680444502043689,0.883995759954068},
{-0.6596216510881392,-0.0653779166897963,0.7487489602163461},
{-0.8005766560654526,-0.03211287145527799,0.598369268303407},
{-0.8724090433060997,0.13247700622420042,0.47048092839094874},
{-0.9230979104359089,0.07668451049746221,0.37684178855140704},
{-0.8684490366089667,-0.014052033074462867,0.49557926831076365},
{-0.8085978016030271,-0.018047827758308693,0.5880849183204395},
{-0.7275314016003919,0.10687376256261445,0.6776990914565838},
{-0.6731489637891781,0.08444078572946795,0.7346701479269087},
{-0.3807264103344303,0.019879462604429615,0.9244740166388767},
{-0.29382027059796,0.08940334278903742,0.9516704738951858},
{-0.2652441515414017,0.03941422562987795,0.963375346835842},
{0.11222716128416035,0.12425895484789257,0.9858827396857135},
{-0.07870988259667333,0.21100465446684585,0.9743109309532275},
{0.24362783331874568,0.2606431173057114,0.9341898330818929},
{0.2032830367332144,0.28983255689033616,0.9352395928011884},
{-0.04176215739039658,0.6507882513744491,0.7581098694009244},
{0.008803148453651209,0.6142541170921323,0.7890591766228107},
{0.011479838109745963,0.2205141966433312,0.975316206363721},
{-0.07945799475299647,-0.11933715052166387,0.9896691727922026},
{-0.06096149498285322,-0.3900494657344734,0.918773699237036},
{-0.14987895675663712,-0.11669230846999848,0.9817938701506976},
{-0.4559970108888102,-0.18200388868691664,0.8711723770662789},
{-0.7261806471300151,-0.19369760067337186,0.6596536267066312},
{-0.9052345894221524,-0.0563809745966935,0.42115498788122435},
{-0.9360498740743701,0.008006855224105023,0.351776240691119},
{-0.9072156187691194,-0.1226347354321903,0.4023935172525032},
{-0.8741036135453287,-0.09769343402862693,0.4758138982151455},
{-0.8852063274885432,0.02852818004871617,0.4643230564136937},
{-0.8256810167071391,0.12328801777765405,0.5505006115545394},
{-0.7440390165459813,0.3497498987158459,0.5692810818967592},
{-0.6384502748397509,0.4095023086141448,0.6516817519286021},
{-0.6020467256917467,0.22594306589119684,0.7658260057346793},
{-0.45274266642777256,0.3316368604121085,0.8276720792752829},
{-0.16543365395536241,0.2978056996401382,0.9401826798026143},
{-3.7027608656151063e-05,0.03149161122197898,0.9995040155255006},
{-0.08635046674774116,0.4709006777275597,0.8779499693081446},
{-0.21169857203494888,0.5053285880937755,0.8365564730808762},
{0.24330237032489455,0.1936684830791852,0.9504191050563405},
{0.35981682031529366,0.26671085151122564,0.894090139473839},
{-0.888547203228038,0.03787319023331302,-0.4572193008799857},
{-0.9682670950993127,0.055109025922943436,-0.24376592832010527},
{-0.9925701758332159,0.027533938490208226,-0.11851720667327749},
{-0.8880732208863895,-0.04715654084272881,-0.45727695655939415},
{-0.9833604473536087,-0.08663761507614584,-0.15967515221357448},
{-0.9745044591980739,-0.1822844245410539,-0.13081837628103501},
{-0.9220742709915947,0.21738549813450048,0.32019148017418353},
{-0.923896217858311,0.31854467572155587,0.21200251931653305},
{-0.7346755925670566,0.6349833962681842,0.23884693874941423},
{-0.9716155524442784,0.14322887976103266,-0.188278268132037},
{-0.9759809836245243,0.15264869202200573,-0.15543325393002907},
{-0.9503187459190365,0.11213254543485805,-0.29038004995035255},
{-0.8315085349602974,0.03938951976016823,-0.5541137266132677},
{-0.7986625781126453,-0.004739736649197993,-0.6017604350727612},
{-0.6994404147247095,-0.11947133257087357,-0.7046344491603188},
{-0.802773892031313,-0.24563942419613966,-0.5433372355669053},
{-0.922463373963339,-0.24680404991867844,-0.2968991152561954},
{-0.9704905628290413,-0.2391716294639959,-0.03074083797341625},
{-0.9966378687972134,-0.07810382571516523,-0.024753805525685093},
{-0.988057245720404,-0.1455978007800682,-0.05043966284003985},
{-0.9400944043427732,0.339940703143528,-0.025745470857809427},
{-0.9834507857030573,0.10097535224898486,0.15042782434853103},
{0.46464820498919546,-0.8592945145709556,0.21381062375051552},
{0.48168896769091035,-0.8651789945897802,0.13943115048468255},
{0.22949261219769065,-0.9477256423236327,0.22169629638074353},
{0.9558234550308028,-0.2869023543307065,0.06394186337976542},
{0.25163427065563276,-0.9074876985719805,0.3363722205714051},
{0.143925609325794,-0.9749659268985399,0.1694900007878634},
{0.5540162996993749,-0.7940283738726155,0.25016970470587024},
{0.998171612986026,-0.05968313171998999,-0.009557971383606194},
{-0.5151777001633521,0.7469590524701625,0.42029050808610535},
{-0.4638449449079042,0.6352528979758678,0.6174962531842966},
{-0.8162211029461325,0.5209866044983613,0.24971197215725796},
{-0.7554456466739846,0.5796914542087174,0.30538449999747497},
{-0.7072276447758001,0.6413817134091991,0.29741983149943885},
{-0.7155321682943356,0.22850303667850375,0.660151557117537},
{-0.5390354320946683,0.6586147329844985,0.5250404141037831},
{-0.8476778545575109,0.45126192222179357,0.27893535531636576},
{-0.6644409237066107,0.48112545883291585,0.5718710971597728},
{-0.39300137284058295,0.777850227606348,0.49040691711900797},
{0.08245011743695527,0.9851014603369143,0.15092081028377444},
{0.026457911127948947,0.9995821286260095,0.011642468391259531},
{-0.5747515935110755,0.7813369299804483,-0.24325543694891452},
{-0.10320514791842159,0.985798909877842,-0.13247341894431094},
{-0.0906043183817197,0.9780705178480344,0.1875337825754649},
{-0.1254123717633881,0.6947829939455912,0.7082007683790539},
{-0.5494900403814881,0.5463927432516084,0.632072516127329},
{-0.35669646660666154,0.7112970416656236,0.6056600938051433},
{-0.4975121481524663,0.694278628060654,0.5200565825551433},
{-0.9724762611021825,-0.05665209508291727,0.22600987083628798},
{-0.9398968891637491,-0.33770881889833637,0.050463763024550426},
{-0.06569431522699977,-0.9893241801896342,0.13008429359059337},
{-0.21069905301154768,-0.47241536951655677,0.855821025509757},
{-0.95124341088289,-0.13315475833735757,0.2782189490024091},
{-0.900953692108051,0.1830676550661849,0.39340650521494896},
{-0.8123187728085733,0.49312909606146066,0.3113870677474903},
{-0.8430058676362528,0.5347280578272124,-0.05836960941436827},
{-0.30523302312459183,0.920647132294323,-0.24339609568039805},
{-0.24698944588223776,0.9416006841440598,0.22887630991918664},
{-0.5239131662988592,0.7562661189086035,0.39188844276097473},
{-0.28058826045728724,0.9179423390752118,-0.2804497998335577},
{-0.17522152213890063,0.9618991743867189,0.20987471618438325},
{0.16806990075104522,0.9529200571206244,0.25238041365914177},
{-0.2865997395113676,0.7353880609690808,0.614056177475768},
{-0.9470061625618129,0.13356060699237726,0.2921316352772787},
{-0.8792604291389401,0.2403022571127933,0.41128569507935014},
{-0.8403407214822045,0.21644187346345994,0.49697121368384684},
{-0.4050493581989819,0.37310826139240344,0.83470069048931},
{0.24265003281902034,0.3265444123422409,0.9135040822793233},
{0.19340818726444794,0.19149237945694467,0.9622494176194641},
{-0.5956608964910625,0.24872433018048365,0.7637567046957648},
{-0.7349829559362204,0.28466865526964236,0.6154379019773071},
{-0.880556306706129,0.16820413759227412,0.443089109341339},
{-0.9846166808872933,0.03804463473738092,0.17053620579275686},
{-0.8512557881054577,0.09894965649570617,0.5153373154510916},
{0.06532871725297311,0.41637947525679564,0.9068408301829802},
{0.1926643144780804,0.33537968812241875,0.9221718531388824},
{0.26839382798176276,0.31776154513008786,0.909391199395417},
{0.13509369556605882,0.2692502353535323,0.953548113196378},
{0.0648843895086718,0.11633830619370832,0.9910879953415164},
{0.3592670700842395,0.21904655458463038,0.9071635901410995},
{0.18921095825560635,0.21052219854204085,0.9591035487354953},
{0.15122843821878929,0.10923253723922711,0.9824450174346586},
{0.2073579321170998,0.08903346498998142,0.9742051786456475},
{0.37884825010931883,0.049388638755032084,0.9241400141488475},
{0.0327769603453419,0.05616786064026921,0.9978831806888095},
{-0.8680249827836812,0.011795524436166051,0.496380393314105},
{-0.9199297156190904,-0.049256302494215615,0.38897703657873905},
{-0.7035201039225645,-0.06676728759412912,0.7075320435740752},
{-0.5843905075620536,0.0017488037379890992,0.8114706873059873},
{-0.7486121642844206,0.060631902436606704,0.6602299598566498},
{-0.7219153233863803,0.06325948848867603,0.6890838141881502},
{-0.4458290877729553,0.20570673841641168,0.8711608130911401},
{-0.5489750684172032,0.24351357059509665,0.7995795865280416},
{-0.9997492373775452,-0.022300733571686535,-0.0020346118012200152},
{-0.9001075021041473,-0.28372382974830995,-0.33061650456198394},
{-0.8740260149376708,-0.4747600496825481,-0.10335095760368619},
{-0.9070258484364521,-0.14773317503737105,0.39430827947370256},
{0.029824360802137895,0.30438645300411143,0.9520816113812511},
{-0.06927245827334173,0.5014331656500183,0.8624187538029131},
{0.2902104322606825,0.26138979105552673,0.9205722579673016},
{-0.3051418238944051,0.1080494598619067,0.9461573767264863},
{-0.7518915642024278,-0.19911881999350317,0.6284988235515017},
{-0.6298644987139328,-0.38190045142344436,0.6763303619256018},
{-0.36811383623663585,-0.3391625499233515,0.8657141377502376},
{-0.5001625767687754,-0.09931972194883283,0.8602168271035074},
{-0.6485848081069825,0.13508544211324747,0.749059189932209},
{-0.5807575264306757,0.2871232317678001,0.7617617378638397},
{-0.3026978053611616,0.6905830489018615,0.6568630688347045},
{-0.39245470937544746,0.6802634241987882,0.6190484430045622},
{-0.36920425880780416,0.5958908579978512,0.71316358616573},
{-0.5132719901648286,0.4885536312113414,0.7055970617444837},
{-0.6105837593940017,0.3788860942868342,0.6954371289486607},
{-0.7358662126364031,0.34704945823301253,0.5814272014967381},
{-0.6359133121288479,0.22396039199235898,0.7385499321480893},
{-0.7701431393072261,0.11307711678922526,0.6277683574668657},
{-0.7447160356448391,-0.03232896452756526,0.6665979780242438},
{-0.7913233535446191,-0.1296110197519821,0.5975017436742331},
{-0.6875337005256119,0.01169820694965987,0.7260582363665611},
{-0.39470673490528796,-0.01802537200929871,0.9186303279254028},
{-0.47014495813034285,0.09177549230194354,0.8778046350739748},
{-0.8091457909310834,0.20394309991987636,0.5510810294444753},
{-0.9673104788445752,-0.1485623405392754,0.20552291475884377},
{-0.6882178133316196,-0.6983552485047868,-0.1966117704992799},
{-0.7684853159883315,-0.630033022055743,0.11175289808153592},
{-0.46649048435261947,0.27646139310629775,0.8402117150636401},
{0.6836288386790661,-0.5735466047753326,0.4513268251245431},
{0.5363661028040949,-0.8422423327863812,-0.05421491146632905},
{0.8208003947437986,-0.050245839097814035,0.5690009381730236},
{0.6400291605213824,0.25205991806470296,0.725829505729486},
{0.5858792160378994,0.21101393733573345,0.7824440315223112},
{0.3226469786903665,-0.8926342297452377,0.31480638339954986},
{0.5450575995223161,-0.8168067634067051,-0.18904741324872212},
{0.6272733682999542,-0.7787193849120359,0.011146343967897633},
{0.4927608295995249,-0.7981688540813738,0.3465735783160834},
{0.26585579065977066,-0.7363981545220971,0.6221241488554496},
{0.42159505434524347,0.2213083763031936,0.8793635270635661},
{0.31146290574788515,0.48645749869409255,0.8163026156440827},
{0.61333488656876,0.23077043237375502,0.7553577460115944},
{0.6401945777536678,0.09393047781639716,0.762448665781498},
{0.13224389604147704,-0.023314734329734646,0.9909429726896017},
{0.1565341228782829,-0.3789586609298698,0.9120786159542206},
{0.09499764383909676,-0.5802668644045711,0.8088669938494877},
{-0.42603178779466483,-0.8188032467040643,0.38478326233785803},
{0.0591366645924911,-0.9036511815415329,0.4241667089712093},
{0.6828949991859606,-0.10761739824526993,0.7225461339469791},
{0.9062817791461473,-0.3735604523577033,0.19775218133310724},
{0.8488243575563726,-0.4458135038908024,0.2841610982657842},
{0.7313376012320351,-0.5760023850655847,0.36519387374780915},
{0.41563941973476676,-0.7986444096158879,0.4352137173295855},
{0.06593836458398813,-0.8101226241119385,0.5825405273266195},
{-0.030501640260565482,-0.6079396027360137,0.7933971826056562},
{0.13602787513182502,0.16599242643961543,0.9767000212715312},
{0.23751223532851184,0.503769230786691,0.8305447008932387},
{0.6247275955909803,-0.1465155126978982,0.7669736865407994},
{0.6643201996430597,0.14099017863409788,0.7340302731324713},
{0.4505483667196197,-0.6370948081811958,0.6253929761636667},
{0.5594338907189478,-0.507058107362017,0.6556872712456064},
{0.9474815097974196,0.10264985087080411,0.3028890831776608},
{0.5719276228413779,0.5949182309208013,0.5647752586198113},
{0.08295793026424429,0.39632992131164957,0.9143525443062837},
{0.14906467752753552,0.15422674817476575,0.9767260783152304},
{0.29359712733571497,-0.018385227101567883,0.9557524314615369},
{0.29857579322471467,-0.39181256825694827,0.8702501979638538},
{0.5838694636709154,-0.4295929319365783,0.6888732555577781},
{0.49305792777462537,-0.15101965459903824,0.8567887392953876},
{-0.16869788167997882,-0.2345646607071906,0.9573507427604621},
{-0.4420561730892203,-0.5586232102611123,0.7018022861114676},
{0.05876109700288806,-0.1432717930996471,0.9879374103560554},
{0.625413454900711,0.21130722628775508,0.7511373153743142},
{0.5013487124530178,0.5789599337017299,0.6430045596181955},
{0.45921737086469855,0.3878632184219212,0.7991755314644605},
{0.3408446068504636,0.4513611770240651,0.8246805695882519},
{0.6052039046376729,-0.7099534888491296,0.36013091714300693},
{0.19780989843160504,-0.9271669228223713,0.3181709309578311},
{-0.0042025890446674855,-0.9443842162783747,0.3288172597197438},
{-0.12735093525099744,-0.9093938689185092,0.3959602637438785},
{-0.23393494968663925,-0.7164981250052571,0.6571947018799379},
{-0.22626228964149886,0.16114192605710292,0.9606449166850327},
{-0.09705577124605441,0.23768108517180062,0.966482218677296},
{0.35863270759917665,0.31173206445893953,0.8798895959313594},
{0.049797291896972386,-0.31500217016824056,0.9477836580723612},
{0.6279266814094154,-0.6930762510456069,0.35405281104762515},
{0.8647736516875629,-0.4994966037083005,-0.051668890358034854},
{0.8647724933744073,-0.17813398198639357,0.46950699586340755},
{0.6995805051549772,0.6081666267683725,0.37512727292518505},
{0.6716066355404503,0.7268044053310851,0.14387454079636292},
{0.5525701746612502,0.81554418956905,0.1719124106485538},
{0.5038836987145473,0.7439920374473779,0.43883603587746417},
{0.2041670513606993,0.6378989727165336,0.742563610572097},
{0.23128709609245926,0.6114130965175816,0.7567564367667446},
{0.5093514450074396,0.2973918287880569,0.8075389808788975},
{0.5778642221209344,-0.11542638589906674,0.8079292606601441},
{0.7826927146671527,-0.03327455218822211,0.6215182367265151},
{0.7516605305242224,-0.33098308588727543,0.570488074992441},
{0.7621772597404634,-0.036428518076539296,0.6463426241594047},
{0.43406607596992836,0.06682528160377982,0.8983991448296486},
{0.26908776180336447,0.0506584208546208,0.9617824602498071},
{-0.3881797829273036,0.03315861143131062,0.9209869502954202},
{-0.3957621926076629,-0.1365785792979361,0.9081401756223169},
{0.010999629303411246,0.24292613155086096,0.9699824239463937},
{0.5732032590416606,0.20732705533625062,0.7927506013555702},
{0.7774403884703582,0.33231201040710595,0.5339992229528485},
{0.9382129685178663,0.184253293966213,0.2929285738324163},
{0.45187533975948896,0.5781205820088564,0.6794006696898286},
{-0.27975874152100083,0.8218200227017605,0.4963334532640971},
{-0.29024787744044417,0.8251374948591773,0.484669252396764},
{-0.001515352656586387,0.8913134479985443,0.45338509142148964},
{0.04713685043772255,0.8786814019263948,0.47507590050377974},
{0.016167252561371796,0.8448434340487659,0.5347692884686867},
{-0.016174930309734888,0.7189179296155922,0.6949067434603765},
{-0.1453562676822294,-0.6501133174050654,-0.7458044180467643},
{-0.41930504272744606,-0.4907861956635301,-0.7637487749839301},
{-0.2659861560171868,-0.24939950686009837,-0.9311558681472938},
{-0.19405601456686347,-0.3658435162878811,-0.9102201847907704},
{-0.33263660844286197,0.03786105755947587,-0.9422947665375778},
{-0.5381886190526233,-0.036798653281005324,-0.8420207060630603},
{-0.3392041772774975,-0.6891427030314607,-0.6403302749175521},
{-0.5748990273900901,-0.4114346536294388,-0.7072571202177833},
{-0.38060179064706784,-0.558760884875878,-0.7368368547303882},
{-0.21383002830119469,-0.6125367309888545,-0.7609700862623958},
{-0.19743503218900688,-0.6288857874736198,-0.7520120174426809},
{-0.18696083988856432,-0.5477355762095103,-0.8154945633801604},
{-0.1606553808848643,-0.21337872266040825,-0.9636697407870354},
{-0.19441517039305853,-0.06120773386572677,-0.9790078420707672},
{-0.19912960349097567,0.1112367854378091,-0.9736394499911092},
{-0.27689934757272855,0.21217014489001693,-0.9371822559839396},
{-0.5239829395192136,0.22109632046246602,-0.8225316384010787},
{-0.6351617583488983,0.22821774579411766,-0.7378930825233335},
{-0.752102052280384,0.20352227687418514,-0.6268342570182187},
{-0.39444639503356016,-0.45711473421402843,-0.7971562966002759},
{-0.054559890074681906,-0.8017386966062512,-0.5951792005431206},
{-0.5813620328993611,-0.3239812864990062,-0.7463607121905408},
{-0.4354652938101998,-0.43387149223493854,-0.7887493303405233},
{-0.18100590607122238,-0.6350674633532547,-0.7509501840717522},
{-0.17061855945593246,-0.6748971953980017,-0.7179157908927021},
{-0.38603031070448657,-0.12031567360499645,-0.914606329467697},
{-0.2916431344794633,-0.1626006731475257,-0.94260559260115},
{-0.13413622744299164,0.15514822162918987,-0.9787423061320388},
{-0.06053382016461398,-0.1683848495740164,-0.9838608636642755},
{-0.1452947505756802,-0.5969286404397883,-0.7890282844599785},
{-0.12856235991265602,-0.4874102360148877,-0.8636567497806059},
{-0.14767531766149702,-0.3737090598895425,-0.9157147695161689},
{-0.08000884725700474,-0.12202558627881152,-0.9892968920672486},
{-0.11664061128312937,0.09850733770908278,-0.9882769208157026},
{-0.14477945000887754,0.22761703636279634,-0.9629275131662531},
{-0.17987866758027013,0.1960890328756266,-0.9639464487903091},
{-0.33128354181719377,0.20224974766560905,-0.9215998342503394},
{-0.49866146711751685,0.1129141562115684,-0.8594109229811052},
{-0.6695639333018109,0.17553187088365496,-0.7217151110552502},
{-0.75482600645565,0.24541362388547647,-0.6082843522478717},
{-0.7668971123556617,0.18070365052011067,-0.6158043599628483},
{-0.7265482477920359,0.002527800301962249,-0.6871108017313916},
{0.37154805667846824,-0.7593179537830206,-0.5342174525801459},
{0.14888839852114408,-0.8301247366196113,-0.5373315237709675},
{0.016312231921333648,-0.685246807861289,-0.7281282328035757},
{-0.6262353080860962,-0.16197658847416466,-0.762622399154774},
{-0.3796268978052679,-0.3950371534185331,-0.8365578676228747},
{-0.6122254967098556,0.09195445176595562,-0.7853179738034735},
{-0.5838045588874867,0.1889906092568951,-0.7895915315116384},
{-0.7769619878728268,0.08397322497986656,0.6239219237109608},
{-0.7622658976819144,-0.03751068656331167,0.6461761753769122},
{-0.8836180996508346,-0.14199878078410788,0.4461562509091121},
{-0.8173035638069317,-0.1512547270569724,0.5560008022758686},
{-0.8578405851418127,-0.22618869413364207,0.46146311350927055},
{-0.9220990814798935,-0.19901570409924987,0.33185242722604363},
{-0.6243176806413631,-0.37589593215957584,0.6847844053601633},
{-0.6273972276609393,0.2210317743138227,0.7466710610885163},
{-0.6470475169338595,-0.034892142510821844,0.7616508709512064},
{-0.8309545269378111,-0.18707215042210418,0.523945211542207},
{-0.8679821103600583,-0.1782476442843252,0.4635027868330333},
{-0.7881916610035795,-0.2507083680124306,0.5620491257292033},
{-0.9161313150319819,-0.1376279541536079,0.37651289467063975},
{-0.9102416096452843,-0.13620271240091264,0.39103584644504935},
{-0.1745760969988611,-0.2858852446820789,0.9422275803805109},
{-0.1441912798015706,-0.4273446423736986,0.8925163480092008},
{0.1610695421204868,-0.40029445861061913,0.9021202519657389},
{-0.46595432308239615,-0.18335495766036627,0.8656024077497656},
{-0.9310530298156516,-0.09062493597787477,0.3534506707450157},
{-0.995401160301497,-0.060838094922170856,0.07399497467176182},
{-0.863920993000259,-0.07908246643098213,-0.49737961493877},
{0.42803923717013576,0.6922855702714252,0.5809673834534741},
{0.5383435803733938,0.7445172986528509,0.39481664285768997},
{0.5379036872402689,0.8353752359314157,0.11317172105192282},
{0.38964097576705525,0.7100374483768143,0.5865379202624836},
{0.4468265890882255,0.815271486408666,0.36834549370500863},
{0.4819220873814854,0.8743584269387494,-0.05699511325602905},
{0.4537940322962706,0.7770961382466328,-0.43611072925859273},
{0.46661809951438943,0.7969217759474156,-0.38364466922713303},
{0.5350893208087992,0.838029837833654,0.1067024351028469},
{0.23384388292366162,0.7056824922951894,0.6688267776391992},
{0.5082266766028267,0.6368323210960426,0.5797846496731979},
{0.3554208781083427,0.6170677278240474,0.7020708074565997},
{0.16718207361491216,0.581849070222259,0.7959282717326422},
{0.1063112089271848,0.3128078196728935,0.9438480782456099},
{0.3121998765217818,0.7024087858582465,0.6396507911735343},
{0.04465735571965374,0.4573966047498613,0.8881407920726462},
{0.39083156698000215,0.5224241343220833,0.7578414808716781},
{0.1288844763895403,0.8492534419800657,0.5120130691992199},
{0.23185304144860752,0.9658240053268501,0.11587992882907294},
{0.08575997262822603,0.8259338656949313,-0.5572059552741994},
{0.1982321075052404,0.6059570917110724,-0.7704025146370499},
{0.16499320550661264,0.4071530434943289,-0.8983338139633607},
{0.2968343427223832,0.5090057451837993,-0.8079619572420821},
{0.2188816156792954,0.5158609550623175,-0.8282380777046022},
{-0.40422336247271023,0.8701689749248072,-0.28179678548479953},
{-0.1310518438618909,0.9845064363754128,0.1165010341404057},
{0.06174718663282402,0.8175972351655946,0.5724701267249731},
{-0.31851158569677535,0.6949938688872311,0.6446191836938178},
{-0.7612260495040755,0.35285419855700767,0.5440853022432333},
{-0.47645625679828824,0.035070063504288915,0.8784984496307144},
{-0.6402734454631503,0.15677046577814127,0.751979345523832},
{-0.6887028549934863,0.23509156272491086,0.6858719520868165},
{0.3290554265274491,0.551811267563385,0.7663072825328809},
{0.5559056866686913,0.4688147541555584,0.6864266849529336},
{0.4435781584349086,0.4867252055373087,0.7525536470273462},
{0.24945689844649588,0.3701324766747457,0.8948593216411581},
{0.15551129181731926,0.5813473139873425,0.7986560828272774},
{0.03817768077935589,0.7448417533682526,0.6661480519596351},
{-0.4428433830335907,0.4534711914234363,0.7734685621616264},
{-0.20285002362681245,-0.16832070213309794,0.9646346506050997},
{-0.10306143673246737,0.023950564479838225,0.9943866002313871},
{0.2882196640315177,0.5887620514244362,-0.755174597075437},
{0.2712666638253704,0.4996080599854282,-0.8226823101870189},
{0.20793533319131247,0.5622731372250734,-0.8003822938856728},
{0.23541948137648144,0.6666086483378089,-0.7072556664669912},
{0.07523821532299162,0.660203119436412,-0.7473092077858012},
{0.11663763648250144,0.5266443557682526,-0.8420459514143025},
{0.22913305240277274,0.43118531915333874,-0.8726839432711144},
{0.28211021087100074,0.3814736117471863,-0.8802793377461932},
{0.3735634934664076,0.4500152266977637,-0.8111329188791032},
{0.37477824948885613,0.6221779782508123,-0.6873396737347557},
{0.3139374411575855,0.7220421911215062,-0.6165211734238183},
{0.2740052914990036,0.8090179910595744,-0.5200105675584644},
{0.07406815453870201,0.821876546685201,-0.5648299305915361},
{-0.018503859534686716,0.8504890632419645,-0.5256671575133133},
{-0.11682581124211765,0.7679767649596765,-0.6297328150173617},
{-0.04557296804531578,0.6253105779295924,-0.7790441487572446},
{0.02965421451762761,0.47634610171607156,-0.8787576565477221},
{0.14402083177035324,0.3529595647253605,-0.9244877206783547},
{0.25013715998550634,0.2578046733973079,-0.9332567447218867},
{0.32300738610928,0.27976569589565914,-0.9041003173978361},
{0.47743054404303603,0.2834074331529503,-0.8317092655780784},
{0.553958825418062,0.38939758483017006,-0.7358662518894801},
{0.5477184923243598,0.5633305731327564,-0.6185977033095503},
{0.422932923478981,0.7639607941316877,-0.48733114744206874},
{0.321530733282779,0.8255199231089626,-0.46382630812062686},
{0.26600062250078543,0.9133018490750057,-0.308420818534304},
{0.10280976840519611,0.9214753868151145,-0.37458412007772685},
{0.05565604548087307,0.9121677594836766,-0.406020175804061},
{0.09391295505393714,0.8274597767476757,-0.5536159993512868},
{-0.032715633194211446,0.7362715824127938,-0.6758948470554146},
{-0.16711853768022403,0.7203728610087805,-0.6731525350807553},
{-0.18312349770429928,0.6465865380708519,-0.740534694240651},
{-0.13499026074683962,0.5475601726006839,-0.8258059620062146},
{-0.11075071048575924,0.3498158496685218,-0.9302489728280219},
{0.03320204962261011,0.31272141734129644,-0.9492644199783896},
{0.1353031861991426,0.18280379729803806,-0.9737945468617997},
{0.25539720720310904,0.1434788287007199,-0.9561307924481471},
{0.28069403991163483,0.14627897900641448,-0.9485849019771118},
{0.34007973312861467,0.16197562033910515,-0.9263420931442834},
{0.4973883151101658,0.17699299768860235,-0.849281074062688},
{0.5860717441323892,0.16976181938767,-0.7922757319316346},
{0.6498728006213597,0.30025062969180094,-0.6982226739244635},
{0.6758785471103974,0.4708912801722781,-0.5669652474478938},
{0.6926497436452852,0.5765003121230751,-0.4334555602943834},
{0.5896142758979097,0.6540942511404269,-0.4738308941831756},
{0.5007107184808794,0.8154700248418387,-0.2903401711489686},
{0.37906864921467304,0.8714208197333455,-0.3113401903349893},
{0.34317860683162704,0.9285091424575769,-0.14177170446107593},
{0.28466912290833124,0.9527515921103379,-0.10596175816688673},
{0.18792000157789437,0.9494859737774517,-0.25132142488623666},
{0.41436160782221926,0.7196945567848942,-0.5570854538553128},
{0.4545761371495776,0.4834778059341308,-0.7480706829593627},
{0.3327934589434639,0.4852475086265709,-0.8085687163476899},
{0.2784094924159668,0.36939291961455567,-0.886587291512414},
{0.09828428230649185,0.22244665058415983,-0.9699781891853994},
{-0.03655704732741257,0.550338919096179,-0.8341406694429606},
{-0.11269152581571965,0.47990116343962586,-0.8700548794981949},
{-0.1911425589269589,0.634896854407148,-0.7485789914436303},
{-0.20453175846868485,0.5582468624281526,-0.8040691514831486},
{-0.20193025084892513,0.5190577059371141,-0.8305439613285925},
{-0.24894336950486354,0.3917046202962366,-0.8857734976946116},
{-0.17347292910878556,0.2648879376942018,-0.9485470591017248},
{-0.03272946650369302,0.2085044483725508,-0.9774736196088578},
{0.1634373016329813,0.4155263756828078,-0.8947771116578921},
{0.21041413553063934,0.10761364815592858,-0.9716713406803072},
{0.3712947374322464,0.01815234679187018,-0.9283376057561531},
{0.1671400521283107,-0.08732578830278269,-0.9820582516693411},
{0.2338107766103229,0.018836155481701384,-0.9720996450917709},
{0.4668649598458498,0.08782948523797567,-0.8799563005007496},
{0.49363648999611637,0.40638999309384705,-0.7688759257887432},
{0.5925252856774439,0.3431779909083316,-0.7287953432816271},
{0.7066799560881712,0.2010035269554747,-0.6783811773735177},
{0.8058481288116109,0.3318013713273896,-0.49042496192189167},
{0.7525941642891212,0.41052494412581825,-0.5148507493715562},
{0.7513296231021682,0.5279664877202026,-0.39592320630842914},
{0.769858420414796,0.5887203782655844,-0.24642712661406035},
{0.6727073845241061,0.6692529012058029,-0.31553974240078303},
{0.5802143958676877,0.8096968271521995,-0.08799035701459296},
{0.4297237849432112,0.8990183091232816,-0.08428255166519573},
{0.35862560921696707,0.9333760066252437,-0.014032201184147266},
{0.3729272088270203,0.9115789512316329,-0.17305811910431776},
{0.5621940981927828,0.6766306206344489,-0.47550898958594284},
{0.6775459198884349,0.4461352258260096,-0.5847177838237092},
{0.6037254328664928,0.38769182371634486,-0.6965706364279652},
{0.42798163087312185,0.4962372997186743,-0.7553676363222754},
{0.3533600956647679,0.4545643295745611,-0.8176233320241149},
{0.14564120276093867,0.49897678611121543,-0.8542896505170068},
{-0.060638811591603954,0.5312598499076385,-0.8450360385243172},
{-0.06137515038780566,0.15045010263270703,-0.9867106250226975},
{0.22500609942771013,0.5328898460089477,0.8157209493698732},
{-0.12087196005402784,0.32203784570541333,0.9389790174472025},
{0.01501359555577606,0.49617944032698375,0.8680901767358556},
{0.23445716116505266,0.5763464153203995,0.7828503363515595},
{0.20792274791774926,0.7953657180930038,0.5693518291713239},
{-0.22140715753303522,0.8455901797076139,0.4857531457182621},
{-0.31278362976413393,0.678664545990624,0.6645154888841293},
{-0.3005952957055125,0.2938235754539403,0.9073644111971652},
{-0.10574399747034656,0.5223321109757557,0.846160370640579},
{0.2105837031155499,0.5349647763719447,0.8182097481840809},
{0.21160770542069443,0.5148366429078634,0.830761945521068},
{-0.9686422961748119,0.13923061598079067,0.20578371566962625},
{0.2520215383587393,0.6586892983416688,0.708952433138821},
{0.17936675352117565,0.7268051959175188,0.6630096341069043},
{-0.12620854932178643,0.7239116485884467,0.6782501950726201},
{-0.6530600828740201,0.6215315020481781,0.43267900355611644},
{-0.6349912187907325,0.5415820558496773,0.5508856767427313},
{-0.5655771525168325,0.3513570652423922,0.7461036772829933},
{-0.6213345109631998,0.28702144983811795,0.7290830630449087},
{-0.42907169739045753,0.3175363129626118,0.8456170341523295},
{-0.1787185164005351,0.15371624724653718,0.9718184023921513},
{0.10942888787421035,0.22783031951983237,0.9675322547626537},
{0.20625418116808214,0.25463790574437134,0.9447850283047486},
{-0.9187152210399532,0.06588941664266296,0.389385319964684},
{-0.9513644794311371,0.09052778588309719,0.2944662073308681},
{0.16537413920942132,0.2631407854312383,0.9504779435228227},
{0.25800511122357467,0.2938320762292701,0.9203782231024955},
{0.1367495156618797,0.09125675206009531,0.9863933166692095},
{0.0424715410410235,0.13112321902561583,0.990455889797199},
{0.027964625260319564,-0.414861820705976,0.9094545890007771},
{0.22910693272543786,-0.27382095154319375,0.9340942671235711},
{-0.18449967729424718,-0.8298987125299964,0.5265244495931535},
{0.24560730676075812,-0.858849714804201,0.44950441404559016},
{0.2490901961407336,-0.7334245928044733,0.6324890835865578},
{-0.27860768378640705,0.061138021664400716,0.9584570417301637},
{-0.3454600202039911,0.06909553662648861,0.9358863078702218},
{0.2830925432720812,0.07381010971383717,0.9562482311867437},
{0.5733179934037701,0.006706425033453556,0.8193054999832147},
{-0.05304791797720705,0.115500054655016,0.9918899413609212},
{-0.09032704531713247,0.06831843494365868,0.9935661106997992},
{0.4743182463426376,0.04828481277203284,0.8790283146986874},
{0.3142096083003294,0.11392367192389258,0.9424933522455905},
{0.1401625968655257,0.06322638988772836,0.988107721891534},
{0.19389076046837186,-0.3714820609981213,0.9079688603479663},
{-0.07641268357903827,-0.754723094893801,0.651578200849424},
{-0.16316854560888153,-0.6080416726999793,0.7769564659516605},
{0.039064951955012854,-0.6800521341591577,0.7321222741826171},
{0.5530244731244648,-0.47735578750293933,0.682858246097136},
{0.5312730312660119,-0.6306694014787039,0.5656899082429493},
{0.42266380424367117,-0.11322275708555736,0.8991862520413735},
{0.010645809739733631,0.14483409035897737,0.989398682536455},
{-0.2772484535731797,0.16172899796071302,0.9470887108449261},
{-0.5282014868552701,0.02650644163973835,0.848705247913244},
{-0.315038231607103,-0.10252735898510928,0.9435248026869286},
{0.5099539084311108,-0.21719278495942904,0.8323306467008177},
{0.7671595390076441,-0.07953320435974999,0.6365066465590513},
{0.7561360678483592,-0.0001516318739645696,0.6544144129728473},
{0.30740557804899477,0.01148531673265943,0.9515092737771472},
{-0.3670955745911348,-0.08716424010626635,0.9260902949293345},
{0.24754789254586634,-0.029501290560172058,0.9684264116345571},
{0.30828834562302604,0.09141825649662207,0.9468901722650497},
{0.3070019497711548,0.18405896329775673,0.9337409174211357},
{-0.2747387425842081,0.2238655575767894,0.9350950943375126},
{-0.007136426417828536,0.12191518461570613,0.9925148659733523},
{-0.07085379185310066,0.059734858363697324,0.9956964833102036},
{0.018929097263580302,0.026193938736218787,0.9994776469988056},
{0.6326005140476783,-0.6516839851443883,0.4184788801516055},
{0.5803385061705664,-0.49776994008417375,0.6445403827568242},
{0.03959862072326786,-0.2417381021651832,0.9695332068569855},
{-0.32909810590436955,-0.5692441296494956,0.7534291987637223},
{-0.34098098574231334,-0.49209704796797843,0.8009821862834413},
{-0.023218935990745718,-0.45980712515074323,0.8877152069622702},
{-0.14731566364557636,-0.1751906061395393,0.9734507418278154},
{0.0818796752389212,-0.23926248227491137,0.9674963479819532},
{0.5374452913571772,-0.08046626099526397,0.8394508560001835},
{0.5859698747721509,-0.29834171878984755,0.7534132496107494},
{0.6349312669918014,-0.31284702060160197,0.7063915542366619},
{0.771271563625494,-0.4131939780076859,0.48416000627981404},
{0.30750457053489316,-0.36213496945889545,0.8799427271107796},
{-0.010340722058492263,-0.49263303457020113,0.8701757079564242},
{0.31377697048029773,0.26585366666714205,0.9115184258784035},
{0.06912187074541826,0.19402193862678105,0.9785589682365389},
{-0.021944668920251844,0.2769831189162223,0.9606241634174223},
{0.12280041413712092,0.1316999263852514,0.9836539979473835},
{-0.1461061988536082,-0.05834869005968181,0.9875466616949647},
{-0.4662686955208387,-0.09819862029633572,0.879176054353843},
{-0.6971198394949459,-0.28477326264848213,0.6579727336775283},
{-0.5296884939310315,-0.25444731764898276,0.8091270987541533},
{0.02654496091987886,-0.09576053311565443,0.9950503933706912},
{0.49592261703974144,-0.05540687726047672,0.8665972743210635},
{0.8688772438318446,0.0955307190065688,0.48572236604593905},
{0.7416236692809758,0.10290073999564552,0.6628768896790493},
{0.19042400668370496,-0.049699733213431956,0.9804430805493187},
{-0.17957719164693559,-0.22069759120328822,0.9586681414740275},
{-0.7204821681719058,-0.23320074450349929,0.6530871749692557},
{-0.7135680893830522,-0.1355604204952782,0.687345585720432},
{0.37940892082797,0.29556682778451837,0.8767491779919454},
{0.18976609651260273,0.34981916466897534,0.9173959781057849},
{0.7883313613013515,-0.4584417573878071,0.41032282397148834},
{0.309760272799498,-0.7888963647982721,-0.5307457950876786},
{0.39125190987609626,-0.7603859088298016,-0.5183967714708335},
{0.9418065976440099,-0.3130281540135868,0.12253043470526172},
{0.4186774487509542,0.24859224131101784,0.8734478183997925},
{0.5442124328881525,0.20827523860805652,0.8126833656921466},
{0.7932139350416644,0.013422179420337568,0.6087951201802841},
{0.8812282233216313,-0.20874423272955672,0.42410218547367795},
{0.18850267285261504,-0.7402091652366776,0.6454123751734553},
{0.27603984020962935,-0.5747855168208896,0.7703399355284555},
{0.22734058903405385,-0.7996484251348817,0.5557685244388647},
{0.1084157625414667,-0.8233296416094753,0.557112487456317},
{0.09551865736784987,-0.6873124400242042,0.7200540228917675},
{0.2157592000663475,-0.6332469065502526,0.7432673293851045},
{0.3097923454609383,-0.7027331258679889,0.6404645630334406},
{0.3320345410421248,-0.7937972883993523,0.5095477685995506},
{0.423860704826683,-0.5680211656284305,0.7054743498540161},
{0.24676967746103406,-0.21886332359220587,0.9440357895079776},
{0.21760101767872614,-0.15669397841491953,0.9633778045158023},
{0.09760120288793671,-0.6448204598917223,0.7580768956378077},
{-0.015712404377863656,-0.7961468743869028,0.6048993922567882},
{-0.04864574787437374,-0.6593834990252562,0.7502312926204511},
{0.018930943599435122,-0.5327639481669644,0.8460521230444275},
{0.17722707813175448,-0.4909517942996891,0.8529694592720168},
{0.31961907516447047,-0.5309235209713218,0.7848336522285617},
{0.4309533432022048,-0.6680335001264376,0.6066386557842022},
{0.5417046558410493,-0.6523964706830844,0.5300329337695778},
{0.6077001463798777,-0.3569230849367534,0.7094409373084601},
{0.402932497507374,-0.27495894946577265,0.8729507308898644},
{0.3150573609485628,-0.7221552850076967,0.6158170212389226},
{0.25964705144361205,-0.47441005208977993,0.8411411957292371},
{0.21616959373923178,-0.5097524093446247,0.8327203539664236},
{0.17295079620059253,-0.19326524503243145,0.9657828778540938},
{0.002835294402076379,-0.5976275192778289,0.8017688627699893},
{-0.1153013151215673,-0.7399664048210749,0.6626879555774424},
{-0.1590086322454889,-0.6307201791346987,0.7595448048033194},
{-0.05463132092186265,-0.45357798531241117,0.8895405724385294},
{0.05536679223210084,-0.3318713956173501,0.9416984098366736},
{0.208738848656036,-0.2703756073886525,0.9398537779840914},
{0.27059577794443307,-0.31481278922378797,0.9097641632312111},
{0.39387383374958845,-0.3603130577338144,0.8455991387849863},
{0.4962439123385041,-0.5142500075539103,0.699491893589753},
{0.6326015832053663,-0.5340727881612946,0.5608756492054945},
{0.6345406303482403,-0.6052441683551004,0.48066379633731604},
{0.6227257268909917,-0.42274655557995305,0.6584056643235776},
{0.6846316120403474,0.0474149242650545,0.7273454342690098},
{0.6386925050193307,0.07245747685121755,0.7660429479347013},
{0.4662746986616004,-0.6828237121987564,0.5624408266183596},
{0.4854154605184392,-0.7588644771816503,0.4341618776003858},
{0.40039444662687235,-0.7730416365088836,0.4920273522214267},
{0.24769974059873057,-0.8850517688601018,0.3941169939813891},
{0.20476990210890442,-0.8282533579419894,0.5215991394242598},
{-0.06910204441764602,0.36048501698894553,0.9302018383038068},
{0.041609350483596555,0.47653707845872567,0.8781691607010325},
{-0.03621184748060034,0.18481255916275277,0.9821064199351086},
{0.33933803422352776,0.3568080562543576,0.870366422560808},
{0.58166980304873,0.02818218354254034,0.8129366548212882},
{0.05694746996722399,-0.23061659316862881,0.9713768437736341},
{-0.2025745907654043,-0.32713088839087595,0.9230107892309956},
{-0.05302922265542397,-0.07554052881252524,0.9957316556438716},
{0.10068715350774705,0.37923946386216645,0.919804069445251},
{0.13281464097499332,0.5132034139080748,0.8479283738003942},
{0.1400182582646835,0.5267717894874006,0.8383951151770661},
{-0.004967552324149528,0.5495853190555585,0.8354228273769558},
{-0.1136569672710506,0.46119599321054333,0.8799888349503576},
{-0.047915268839999206,0.41268917768689767,0.909610779197401},
{0.1205175052359575,0.4176119368105628,0.9005974689976824},
{0.8335149931002764,0.35113047278166326,0.4265678695836944},
{0.8229793847890493,0.33693612443389503,0.45736088624160315},
{0.7559433996245847,0.10018289399555116,0.6469257796028084},
{0.9112930668986108,-0.06722242286328095,0.4062340361010071},
{-0.16315057562594576,-0.6249350469964724,0.7634383254123673},
{-0.3910322131611696,-0.7866728890689659,0.47774425572074014},
{-0.15999831648961324,-0.5749224459916739,0.8024118143543504},
{0.0017529785215487754,-0.13158848502702136,0.991302878879405},
{0.11105726930269733,0.18120686867341768,0.9771542118215543},
{0.15561020081640667,0.5184822190326873,0.8408101176536937},
{0.12046137887693062,0.4868191803424897,0.8651567151965793},
{0.20804233079112475,0.4921658213370488,0.8452758087787821},
{0.13083957463037282,0.5582176955534939,0.8193131331069273},
{-0.07443418563884524,0.5969814882830442,0.7987945008922154},
{-0.19915173164652836,0.5753152343919279,0.793316436775862},
{-0.041161592741077946,0.4731322011457665,0.8800293424210239},
{0.2636182335939453,0.4022772627403258,0.8767430814092341},
{-0.6051219580765796,0.7816879160837169,0.15096826720295242},
{-0.6087785440422139,0.767560267476597,0.20059890354909035},
{-0.789641323873742,0.5483290899913631,0.27532124636534666},
{-0.6852326625034403,0.7156169312215362,0.13545702634975185},
{-0.5872016294445047,0.6767134917360212,0.4441318458297722},
{-0.42011742971584803,0.5525441634124739,0.7198585227166228},
{-0.3733208501697957,0.7848613356978195,0.4945950126670667},
{-0.4227013787219968,0.9043660077054064,0.05869981715054821},
{-0.31883083225791353,0.9442776564099649,-0.08177168218051113},
{-0.378345367270034,0.9254736323725304,0.018797309607960104},
{-0.6096786089156897,0.7224363842308748,0.3261558899821512},
{-0.5341225943263189,0.84463652836486,-0.03608585847502482},
{-0.4389807042306643,0.8609607259657084,-0.25698748930200976},
{-0.7476153212227528,0.6319397824129765,-0.20426317063249566},
{-0.6100390383112272,0.7923700185794974,0.001457872641932746},
{0.04940190308967636,0.9069424446369041,0.4183477669202435},
{0.30695599572094356,0.6160184523916563,0.7254648737216384},
{-0.37362457030316504,0.5336020596622296,0.7587315219430399},
{-0.33024512232285097,0.4255080431436439,0.8425443990686974},
{-0.19686524892347915,0.5748845875405061,0.7941988320154337},
{-0.3060427126414114,0.8952912336740472,0.32371509842064705},
{-0.24810739060825054,0.966846591533038,-0.060418467098328946},
{-0.07028962965201944,0.9754520172071671,-0.20869290857585562},
{-0.15652268533666588,0.9526375186934258,0.26073436089750773},
{-0.1129121502421911,0.9597202077451358,0.2572702259751767},
{-0.13112034461045932,0.9904809642761847,0.04189170127547836},
{-0.42538793634092786,0.7884822507413916,0.44423062015286163},
{-0.317102050969493,0.9317577924048975,0.17684373204525242},
{-0.07089800501775301,0.9908439030058673,-0.1148992287206584},
{-0.33778892319913006,0.9388739022021761,0.06644124568090996},
{-0.5704530002461167,0.8195778896804911,-0.053623290248519515},
{-0.7002902782047091,0.6771721829545927,-0.22590121930720652},
{-0.6825712455879078,0.6922442747098868,-0.23429545200015092},
{0.10934311095337318,0.9281182692346095,0.3558659331826965},
{0.5448029004865185,0.6961626531504883,0.46749049186047564},
{-0.9950370114590228,0.08532192681899374,0.05120072880917837},
{-0.9683030145294547,0.23324042726855698,-0.0893765916823415},
{-0.9855898594787406,0.08324191365952895,-0.14725288690880073},
{-0.9941860066254988,0.027843954009429576,-0.10401393394716005},
{-0.9627925801478865,0.02564644224482011,-0.26902176048111553},
{-0.9468700750839055,0.04382491595957786,-0.3186164428458377},
{-0.9235212569086617,0.3180712127358022,-0.2143342988572332},
{-0.8941988683288568,0.4074044914387418,-0.18555313049079009},
{-0.9704944520354946,0.24088798019184263,0.010653617574322337},
{-0.9803417430948472,0.13581600785147804,0.14312260044117403},
{-0.9725749818592567,0.07155319450696969,0.22130983940465587},
{-0.9953189486289722,0.04648923326772468,0.08472863559798702},
{-0.9087962236676808,0.009446515039975158,-0.41713329668220267},
{-0.8990816124251333,0.046490631764394254,-0.43530549658506507},
{-0.9066801513035263,0.341738677503164,-0.24727672662546113},
{-0.8705999671700834,0.4800486816208044,-0.10774488589987623},
{-0.8807958239318826,0.4256385044787384,-0.20743813547479395},
{-0.9525827590845437,0.169025416245514,-0.2530148133171435},
{-0.9877690395102382,0.13907930786294007,-0.07049305433436023},
{0.039664703950216956,-0.6433477885473478,0.7645458352720124},
{0.31241755918137665,-0.29483082523219567,0.9030338051302695},
{0.7753787430439455,0.046764651593546945,0.629762552234511},
{0.45817031703010747,0.44933302835962513,0.7669288038779735},
{-0.006085615209411391,0.1895633079412073,0.9818496410193925},
{0.03838102632147649,0.09762259073738322,0.9944831454560864},
{-0.059390722858198366,0.08114495982283618,0.9949312727689944},
{-0.22019942472475187,-0.8386634006844491,0.4981525004486912},
{-0.20346765193606844,-0.47259367959422577,0.8574707742093681},
{0.10366702363589494,0.4673989032391381,0.8779472725974639},
{-0.273837628375567,0.06642910066554417,0.9594790919402111},
{-0.38804332328876245,-0.42020783846608395,0.8202729739194594},
{-0.32685146554908046,-0.38624548818921156,0.8625442262990902},
{-0.5083273093870856,-0.6309063059919183,0.5861404094506011},
{-0.3711504847676342,-0.9010167763334561,0.22453526765837262},
{0.8353444667435822,-0.5168171490660696,0.1873490227145591},
{0.9779508751321973,0.16821063391128524,0.12376295272549476},
{0.6607250086046415,0.20700927285499887,0.7215189699214022},
{0.4929257198562756,0.10897144249718022,0.8632204002595492},
{0.7018640980030899,-0.023853475653481115,-0.7119113706308939},
{0.5945832358590077,-0.03403648689063219,-0.8033133219333384},
{0.26696507616656007,-0.16636732450807187,-0.9492373578001493},
{0.21019835946139626,-0.1689680252920575,-0.9629467566322866},
{0.344424235056227,-0.08756174490863894,-0.9347218233969332},
{0.3646762243061356,-0.08277652225911712,-0.9274477337233117},
{0.579342678784711,-0.10006694252499364,-0.8089182081967586},
{0.6040925745353171,-0.15750822664798092,-0.7811935227134827},
{0.6128493800991514,-0.22989861366872225,-0.7560173706637208},
{0.37927241581229504,-0.43622187744628715,-0.8160042329799166},
{0.30365954033963083,-0.645147034833501,-0.7011249439338653},
{0.4162078079909967,-0.658929810794557,-0.6265640948965868},
{0.5837562979767111,-0.6875038003022825,-0.4319341490811353},
{0.9380508840554345,-0.004136776807147872,-0.34647283587673305},
{0.8829341141337521,0.38566285082738405,-0.26775271350733576},
{0.445422182654271,0.8943039407315072,0.04265607567043841},
{0.22007309635411115,0.9207526289419902,0.3221528031191531},
{0.5131986239107148,0.823979331067451,0.24017750600292423},
{0.5600938885013615,0.8279392864829377,-0.028484626758102916},
{0.9405597313694111,0.2159663020592512,-0.2621181949067126},
{0.9794878905877036,-0.036920252388227964,-0.1980918149637698},
{0.9907267843419407,-0.09462320123961435,-0.09750327468677683},
{0.9799753772877678,-0.1989229512447396,0.008827195351856961},
{0.9529135813218907,-0.14844464989922643,-0.2644236987272214},
{0.7546184683279687,0.44054053046422653,-0.4862869608334654},
{0.9146313987984029,-0.010017303694275927,-0.40416464214324016},
{0.8470142262943856,0.313179176093577,-0.4295179904454196},
{0.9207983824233925,-0.20906491094537286,-0.32927526772879095},
{0.7814367416700381,-0.5074476583832567,-0.3631163625746762},
{0.8931155022438212,-0.30799827729262347,-0.32784411057169105},
{0.8408184069899118,-0.34344652005626214,-0.41841234963632523},
{0.7543417791775551,-0.32263180032501165,-0.5717317566886437},
{0.7838768940294584,-0.15635980024834478,-0.6009065051012737},
{0.7269936708601933,-0.10839882176157467,-0.6780338472155526},
{0.7199912439985903,-0.022185982154768927,-0.6936284241300892},
{0.6599391825244836,0.016648684899993823,-0.7511345396531949},
{0.603002157002499,-0.040049269819984315,-0.796733615857408},
{0.48445797991744977,-0.6900895946997144,-0.5376586435476394},
{0.5332386078006015,-0.16288569307325756,-0.8301354336148535},
{0.5064431503894563,-0.12006406304146922,-0.853873501280826},
{0.5968180919257953,-0.7997340504667603,-0.0650662252945604},
{0.7689592241451607,-0.5907470799328056,-0.24437593816277334},
{0.7331337801877498,-0.6701370844038743,0.11589283176406914},
{0.8112579839401823,-0.5837367111736337,0.03334569719619783},
{0.8147003770719493,-0.5538083684396881,0.17192901629740817},
{0.9059332477444129,-0.3389502019206447,-0.2537670412981449},
{0.603297387400077,-0.1466123964986781,-0.7839241465531954},
{0.22899727686027643,-0.9485371112706114,-0.21871807363128873},
{0.10622668387618768,-0.9942954302025607,-0.00961712592061707},
{0.043682449533885045,-0.998522359586523,-0.03232554730367341},
{0.38176527596680604,-0.12447197777817799,-0.9158395060347512},
{0.36249577414280737,0.18646127106944432,-0.9131423810774385},
{0.8573781528608057,-0.3738889154372702,-0.35370861158605527},
{0.8372141046549308,-0.5260175999988629,0.14959287235118843},
{0.9736267380741281,-0.16448211457063136,-0.158103159024438},
{0.2893339696463412,0.5933477471983972,-0.7511486569935921},
{0.08295240969195312,0.7902220942213463,-0.6071803187939545},
{0.377022070195291,-0.17172296207933696,-0.9101459129614083},
{0.023814024730466815,-0.9976507422710301,-0.06423308082444316},
{0.00040622472124213774,-0.9999985587028223,0.0016485065222929633},
{0.08474363213058914,-0.9963572128351103,-0.00953001808844624},
{0.13679734209135266,-0.9844990088124319,-0.10976424210133634},
{0.3050370997024042,-0.5181899297717731,-0.7990191264846358},
{0.25415810089192425,0.02929814934956454,-0.9667188206483316},
{0.13085572673421378,0.36160288203987373,-0.9231035339989323},
{0.25477946221538667,0.3197321937106834,-0.912610952124832},
{0.5719700081188093,0.04006221080161918,-0.8192956298420344},
{0.8642385062291673,-0.3613201987779558,-0.350056450170306},
{0.13380833089895264,0.8024758801265005,-0.5814875685663751},
{-0.04663012526091502,0.8093019124029985,-0.5855391071474223},
{-0.1105708697087182,0.8242867832491254,-0.5552705482309207},
{0.0050875922812632255,0.8480670881832225,-0.5298644452548311},
{0.15342570004994532,0.7945341209785005,-0.5875168807490605},
{0.13402804950482541,0.814067384713014,-0.5650935985236833},
{0.22061847108261048,0.5873716080965027,-0.7786668634398795},
{0.3869093704272104,-0.034658414409838294,-0.9214661867839837},
{0.02261600637477284,-0.9977702662335297,-0.06279340790184557},
{0.002612132070487412,-0.9996123376352265,-0.02771914885930389},
{0.004410994136037138,-0.9995887650103408,-0.028334501863162758},
{0.0009313246841831876,-0.9999995652714369,4.573040258899421e-05},
{3.700921490303746e-05,-0.9999985886581393,0.0016796761734860538},
{0.007892516055688723,-0.9999306048332175,0.00874606815582832},
{0.011981164686746067,-0.9999240353054825,0.002894012983594172},
{0.06590667929902218,-0.9977314534655305,0.013720655572380159},
{0.14507714333763597,-0.9887559617633696,0.036252869657247194},
{0.7590813070731203,-0.6338126638697245,-0.1485835669598989},
{0.9919904442035822,-0.024940399889778267,-0.12382622929782537},
{0.9019079073505823,-0.43190460715228174,-0.004531774390508572},
{0.6845695795332273,-0.7255721283159112,-0.07006837652478544},
{0.5386885573234386,-0.7945830039560453,-0.28009371294796953},
{0.4620495555001432,-0.6063614853347447,-0.6471753683235808},
{0.7333442063226975,-0.43328006829167054,-0.5239032901920908},
{0.3450537349822832,0.1826118022828197,-0.9206469734060916},
{0.22132058869101273,0.4946339938992109,-0.8404489330713548},
{0.16933644848910445,0.463069018160094,-0.869995546904318},
{0.9278755670136007,0.2910149945347008,0.2331463169238518},
{0.6161943242981781,0.7184417073704072,-0.32271669899992156},
{0.2453983945172177,0.8134140615997453,-0.5273871370825971},
{-0.07489484246386538,0.8463025824409448,-0.5274113210067645},
{-0.1494445518971611,0.8316345305518924,-0.5348367353707019},
{-0.0859268034912434,0.8117295352783708,-0.5776778912149377},
{0.25802009626117217,0.753576902602786,-0.6046052280529559},
{0.3037565155708655,0.7427956787461621,-0.5966460918201631},
{0.2033310984260526,0.7719588850645381,-0.6022756380452143},
{0.16598882454001612,0.6653106389890537,-0.7278801163487024},
{0.09137287945584932,0.7676666143919741,-0.6343019517926072},
{0.1926814463204542,0.9309606010953303,-0.3101390324549285},
{0.31238314731730016,0.9079259317530396,-0.27944099864284927},
{-0.3764173014736669,-0.7083963104256816,0.5970633823360496},
{0.10375139589871712,0.33432236079963756,0.9367305946313617},
{-0.5353121169457905,-0.25633052875647894,0.804820226807478},
{-0.6385730498581519,-0.5535362507665047,0.5346233057791434},
{-0.04885775285023839,0.6198958629330121,0.7831615664120407},
{0.1962272308830211,0.6593088679159111,0.725814501472257},
{-0.033387613756302476,0.4722892725894309,0.8808110525218257},
{-0.5339207865927917,-0.4531155758069522,0.7138731460177422},
{-0.55828035702489,-0.47749649030483454,0.678468971071431},
{-0.9196274625202477,0.00930198387542355,0.3926815545382183},
{-0.9635988618973368,0.06120267939522784,0.26025269525021644},
{-0.8570977379211517,0.05128773690636944,-0.5125944163697725},
{-0.6308400023027978,0.05994620570535732,-0.7735937848225883},
{-0.5177882585467086,0.04065456882354531,-0.8545422899686932},
{-0.6265660797718263,0.053253602875664226,-0.7775467840973469},
{-0.8538909060902272,0.07050495025919719,0.5156543149100559},
{-0.9256956501723533,0.13268290007671177,0.3542355307972612},
{-0.9375394435113384,0.11507152417697482,-0.3282961105222506},
{-0.6684939079439232,0.10101546285097568,-0.7368254686877106},
{-0.8155783987822712,0.06739116529230396,-0.574708888290665},
{-0.9842031193679317,0.042510179668859345,0.1718636216625089},
{-0.9196376173586474,0.0032772037123466905,0.3927542649987876},
{-0.9361746478437262,0.04645254504414334,-0.34845256462479535},
{-0.8941446874277099,0.0503336774572001,-0.44494021942103357},
{-0.7143736089030966,0.037779284873182405,-0.6987439248660675},
{-0.5772032374062404,0.03726919291920638,-0.8157496123118332},
{-0.7393759590526137,0.05216144490084948,-0.6712692267942004},
{-0.6052624204993774,0.043007447358057074,-0.7948633604607643},
{-0.5568953052381379,0.03278145235461757,-0.8299355368853915},
{-0.7998949972684971,0.09645052598036084,-0.592338829879439},
{-0.9091073180453892,0.12261473193833254,0.3981074123751157},
{-0.6552664896568663,0.08350131333879511,0.7507685117287913},
{-0.969875469860356,0.23772950892739442,0.05316252014618567},
{-0.7355753917935074,0.23811044051199165,-0.6342178341130226},
{-0.5046366170451911,0.17791379914285455,-0.8448009024685882},
{-0.3990750792048466,0.07660397755503597,-0.9137127074635621},
{-0.45676082336084184,0.05471294268612123,-0.8879054252257677},
{-0.5585338185095203,0.05573409934217203,-0.8276072037818974},
{-0.930403504888978,0.05806065365488171,-0.3619092131840157},
{-0.9930325265895613,0.05831650376516708,0.1023991529445408},
{-0.6274146524761417,0.7141657140612944,-0.3103517145394302},
{-0.537686861752429,0.7613893665189057,-0.3621865144518275},
{-0.7101983507154748,0.6387859692279754,-0.2959236187912275},
{-0.8124340149636715,0.5275768005868472,-0.24822105231538083},
{-0.8275292808832613,0.4516733667269556,-0.33344633611777685},
{-0.8580807468743521,0.49513818088024925,-0.13614556062594135},
{-0.7075376560082993,0.6971469031515655,0.11565751491564659},
{-0.521168457353983,0.838588554036368,-0.15859595233946866},
{-0.5109736572181768,0.7868768817751894,-0.34602123425714126},
{-0.5660100929437946,0.7424018725386382,-0.3584299573652856},
{-0.52358566984018,0.7680644104316074,-0.3686937859068924},
{-0.5463462920455203,0.7872474017072633,-0.285914773443545},
{-0.5827446851773906,0.7847864898266704,-0.21099478022699328},
{-0.6997339842520073,0.7053694788870591,-0.11325303323712949},
{-0.8516723573482482,0.5186662088214025,-0.07509700097680864},
{-0.9374110663321499,0.34812476372673645,-0.008345154176269621},
{-0.9045531938231502,0.3713772985146855,-0.2094335734601127},
{-0.905830135966885,0.3314849720948213,-0.2637981767365161},
{-0.9209577384382646,0.33630385936529145,-0.19681605164896374},
{-0.8621520577831665,0.4176708296011245,0.2867837292465524},
{-0.38819835777646433,0.6298532418197546,0.6727458129106432},
{-0.4563768725280125,0.8153141970243404,0.3563466154632386},
{-0.23925661495155437,0.915255737701354,0.3241345504673549},
{-0.5182538278583924,0.854937956575658,-0.022227467610190593},
{-0.9195277016948444,0.28723867404429393,0.2682587369482549},
{-0.735057725005158,-0.32194833186502525,0.5966903824594202},
{-0.9743099057942732,0.04022776856682189,0.2215895622706282},
{-0.7970484047134185,0.5596928499377132,-0.22684301680323962},
{-0.11892529007266323,0.38296873170661727,0.9160740832029678},
{0.5008409028961879,0.3991001123202677,0.7680348236454393},
{-0.2586658150799723,0.529890239623927,0.8076560716420763},
{-0.3289056059920917,-0.21805237237212843,0.9188439830841042},
{-0.46361631256031643,-0.16082325365206132,0.871318423891484},
{-0.022841601961192507,-0.1782389864719055,0.9837220770732525},
{0.8363629684179965,-0.16471374351122434,0.5228444967268528},
{0.07857061102746546,-0.12383584571359002,0.9891872130184309},
{-0.4399779409230877,-0.1304320845713995,0.8884857245985661},
{-0.402397255408712,-0.14895657418692287,0.9032654027726467},
{-0.42744471980757565,-0.17020172412922,0.8878752077922122},
{-0.4655223025378765,-0.18044323929858927,0.8664463187245163},
{-0.5672875871609847,-0.1933066534331311,0.8005106690054491},
{-0.09405106073171784,-0.327903050209162,0.9400180783574147},
{0.5952449938284636,-0.24567298731557402,0.7650674353451427},
{0.6648358437786109,-0.3131065693817243,0.678201722968314},
{0.7823221003137945,-0.24039112039907773,0.5746166031310698},
{0.8608490493625724,-0.1394753256838091,0.4893726062387949},
{0.9260193969227855,-0.0693274734019238,0.3710549527421324},
{0.8409701949320542,-0.040652071146600306,0.5395521664745999},
{0.0845610561157874,-0.06483253951247026,0.9943068789910621},
{-0.38813799542136723,-0.07381446404890166,0.9186404745097267},
{-0.48001035096280975,-0.10892195201690816,0.8704746241777451},
{-0.18740344348434104,-0.15180203340603404,0.9704824017075244},
{0.16896633778886153,-0.18268699694166765,0.9685431522873184},
{-0.4532257752740932,-0.20314090084630507,0.8679401886250855},
{-0.665967866129016,-0.2147294172596031,0.7144075018131574},
{-0.31920395661736045,-0.3560208514154857,0.8782698830298208},
{0.38576380955397427,-0.33189365715971725,0.8608326687432075},
{0.4904956627754306,-0.3397988873525988,0.8024654017167513},
{0.509616427263479,-0.3505372048113844,0.7857574467392776},
{0.5942516194189027,-0.37549073181842446,0.7112465979788415},
{0.7062128780330919,-0.25203475266386743,0.6616206272100957},
{0.6577410859835869,-0.27854878171431346,0.6998480120816257},
{0.7211960732631243,-0.1658841135281906,0.6725761553822858},
{0.7377371645327524,-0.0928003294585047,0.6686792765740297},
{0.885184711625318,-0.03682464040628167,0.4637800903054706},
{0.8056694223429403,-0.0561628813566025,0.5896969668052543},
{0.8520382620691691,0.0005190668805588302,0.5234792551187901},
{0.8028246000632823,0.04065226796646484,0.5948277520782077},
{0.04008300081224045,-0.009980067511683913,0.9991465114278026},
{-0.4109627438582037,-0.06708849445972984,0.9091802665432543},
{-0.4615263814947569,-0.06616316374677252,0.8846557720081714},
{-0.40650181828330295,-0.10727748154420354,0.9073300467227465},
{-0.1059932709416761,-0.10081736435593057,0.9892427839309256},
{0.7791977686721011,-0.0993322476691138,0.6188569639823251},
{0.9055452382243753,-0.08104187999547731,0.41643731246846527},
{0.9171646702080787,-0.019989342547241183,0.39800677620693276},
{-0.23113461873206287,-0.20820117837573826,0.9503836369311804},
{-0.5023289853728494,-0.21328684646666501,0.8379584187646717},
{-0.7169591939291198,-0.2451519312964438,0.65258719327162},
{-0.81250314412922,-0.285271674379028,0.5083883481917318},
{0.016861065413642958,-0.3584588219379978,0.9333932598042155},
{0.4965970157696005,-0.2150483001422917,0.8409195160861935},
{0.5963035089346372,-0.20351911446960144,0.7765320954588729},
{0.5290811432745129,-0.31747364715658716,0.7869457587359051},
{0.1723173850862572,0.47088703437542506,0.8652006239330574},
{0.2465931186551088,0.635327288387922,0.7318135489737791},
{0.19421580518298454,0.30089389219496687,0.933671830279188},
{0.061439315633611304,0.2616252212991891,0.9632120504201677},
{-0.019324213831514458,0.21950575237674855,0.975419806766969},
{0.03514673943475851,0.39255640603553565,0.9190561325553347},
{0.020411195613175084,0.5180521682007309,0.8551054520444612},
{0.06146060195302015,0.43645918591627664,0.8976224002535105},
{-0.03977027718480612,0.10218021292149296,0.9939705876634187},
{-0.08850985390992368,0.17974192255996274,0.979723862644619},
{0.8578353133552721,-0.020397289504418298,-0.513519742309422},
{0.9058852522985218,-0.09409996218547054,-0.4129371705050739},
{0.8713077612674167,-0.1747198504537117,-0.4585801554936661},
{0.8356601888848627,-0.31684350770384195,-0.448644893360931},
{0.9165611769708583,-0.2754766014456991,-0.2898762683037757},
{0.9581101386095134,-0.18032696507411305,-0.22250201788032908},
{0.9023972612919228,0.00866570529045225,-0.4308179294837396},
{0.8308087277816418,0.01591046929118121,-0.5563305805083738},
{0.8062691397009631,0.04977843040630871,-0.5894507462308901},
{0.7733615653819216,0.07652014622133549,-0.6293302443171545},
{0.6717171480064555,0.01146635985970678,-0.7407189721248141},
{0.48940988669902663,-0.8016660377318942,-0.3432339242389822},
{0.3403526535739833,-0.9097105961182409,-0.23787959667727485},
{0.3657138069894449,-0.7948480428101957,-0.4842210241388621},
{0.44089610743183894,-0.16781738093137122,-0.8817300885808464},
{0.9375842672128152,0.3017524951381748,-0.1728617180086277},
{0.8804184974701271,0.4287062286591179,-0.2026678041064245},
{0.9241187468758975,0.3063693784232183,-0.22834698517189098},
{0.9062629585641196,0.3270425855176964,-0.2678256843405964},
{0.8954361056025348,0.35547347727903267,-0.2680163945256321},
{0.8491420746263585,0.4807192800809368,0.21878462207776342},
{0.9286471564185036,0.36855765845224003,0.04218662432607691},
{0.8646942938997386,0.43425123586767117,-0.25244730587715236},
{0.8815789270688997,0.39185162420480596,-0.2631936548553232},
{0.8531309689264333,0.48612890842295126,-0.18933101767580218},
{0.8878246494585481,0.4594896544821775,0.025231909116343945},
{0.9431424391420355,0.32138560939603883,-0.08481526727157351},
{0.898194452623306,0.4104899876989265,-0.1573044668013432},
{0.8359139674007474,0.47306961189085367,-0.278303757448187},
{0.8025264809992082,0.4142110655569812,-0.42939543600878843},
{0.809570867837036,0.3250636525400003,-0.4888032648693565},
{0.48756696263687127,0.8591839778133594,-0.1551816651987874},
{0.523946976871044,0.811106464152004,0.25997282403845134},
{0.7274029083825978,0.5145402172820402,0.45401913360109497},
{0.9569162586442121,0.1807872640327569,0.22721628266018573},
{0.8553643551225955,0.014154086078969301,0.5178334498977211},
{0.8631745537645698,0.3189353729301428,-0.39142038478756663},
{0.7095108881354207,0.40900328623292587,-0.5738559152504693},
{0.86580181511983,0.48777222282392513,-0.11164889420238215},
{0.9267182307688426,0.3365729507321103,-0.16706875709164418},
{0.9660502893655101,0.1487524817379377,-0.2112333723482603},
{0.9276082660134556,0.299037714473861,-0.2238735137209402},
{0.9581153139770725,0.2747286041923806,-0.08086556226925092},
{0.8994364537010703,0.43216308214833077,0.0651853985314021},
{0.7713660621349103,0.6363107119405763,0.010152637891633913},
{0.6859441130863725,0.6904729500698681,0.22962530118426258},
{0.8948434839670476,0.3976878067047326,0.2027302335619818},
{0.88291273179774,0.42560858317974504,0.19829887027711993},
{0.8991609962940869,0.4089676571434969,0.15574003388334168},
{0.9167236535116194,0.3995188737886426,0.0015532478755338512},
{0.7822678387961182,0.6223063798633252,-0.02813890485881094},
{0.7576941306919022,0.6162366990969388,-0.21483001419995232},
{0.7467011394662739,0.5744809590392376,-0.33527456810967016},
{0.6567904231277807,0.6012237729492769,-0.4551442792436998},
{0.6270115803059486,0.5609312079044493,-0.5405669784227413},
{0.6903423551741537,0.4048905973241877,-0.5995757140270652},
{0.7116770806262932,0.28022817952515294,-0.6441955450880232},
{0.6870317338709447,0.24961290748832732,-0.6824080839713925},
{0.13557957523892503,0.2804315528268412,-0.9502506632237407},
{0.03465673892197437,0.6560984718646308,-0.7538791054699622},
{0.525274210585168,0.7176268735135237,-0.45727308482495843},
{-0.05103094304052215,0.9547091074877135,-0.293131988927187},
{0.3415072778861661,0.9398502701063783,-0.007365387413340236},
{0.9188165650348522,0.39449858581474284,0.012123762110955222},
{0.6405245880297686,-0.32079688921199717,-0.6977231600005842},
{0.7952186394410714,-0.10660712301857761,-0.5968770700966769},
{0.9676428437050326,0.09844843178644355,-0.23232570521840212},
{0.8213726714710002,0.26935812104461454,-0.502785378852555},
{0.33010967809890795,0.14164913481684477,-0.9332540506373785},
{0.46528825113632866,0.5469979890518388,-0.6959166928072218},
{0.5884405027949897,0.8022972695650002,0.10028392652327237},
{0.6985610065151074,0.6519706647603585,0.2948673811538613},
{0.9771238821410657,0.18755261091515657,-0.10026433607460136},
{0.9902674558523903,0.046678752365207986,-0.13111620783588054},
{0.9890474635184036,0.05122688430268741,0.1384229794234009},
{0.9888495396327706,-0.04365891629291528,-0.14237446047724273},
{0.9864914485509303,-0.03636605254415049,-0.15972517697045616},
{0.9790130373252653,0.11146127677346415,-0.17061610863921303},
{0.9973917426916366,0.07136716464705839,0.010790709929374429},
{0.9317776362677848,0.16214570421548696,0.3248064148930611},
{0.8747903988185726,0.2130676536628438,0.43513668323580024},
{0.7510488166823672,0.6442631688882261,0.14439752135724815},
{0.457769810340306,0.8395172146835113,0.29267327686524364},
{0.4654457670950806,0.7185250429306131,0.5167997683579517},
{0.7529741383284247,0.4372985297459708,0.4917315760560617},
{0.7760860814771734,0.21482415207061323,0.592908911911896},
{0.8267214954934287,0.21590743892675912,0.5195339706941178},
{0.7025045773960351,0.5908197706019517,0.3967610331212927},
{0.7761810833618688,0.5980129958676776,0.19980836470118268},
{0.8538010990565217,0.5115995926171146,0.09638226021357822},
{0.6440642373331879,0.7609273648243896,0.07855446295296818},
{0.6121458999952761,0.7839101419942689,-0.10374144011675662},
{0.5614945255300563,0.7956199786449764,-0.22740436974856976},
{0.6259134805822667,0.7062917888512099,-0.33073285870434815},
{0.5050613547385372,0.7266341765285549,-0.46574220492708446},
{0.48651489764727623,0.651846657703514,-0.5817208859994784},
{0.47209984159762136,0.5387529612846558,-0.6977585443909055},
{0.5674931878919998,0.3329316186715251,-0.7530657467877114},
{0.6136177925093669,0.17321012810004285,-0.7703709861096136},
{0.5836831020860693,0.18478212986761902,-0.7906766727435239},
{0.6031956829182957,0.20329937712446658,-0.7712485535607408},
{0.5305458214994078,0.29837417282303424,-0.7934065693461888},
{0.3777409533355819,0.08443159318699306,-0.9220537285023209},
{-0.34661513589356185,-0.06856329620994192,-0.9354982747083584},
{-0.21513560599092377,0.4601023358931717,-0.8614072855163026},
{-0.08031269622551937,0.7441794296152325,-0.6631341096358523},
{0.9301017906977446,0.34183906437998024,0.13437526931942737},
{0.9576131002531147,0.20656654748509354,0.2007670582633183},
{0.9442282792604152,0.11552860463724413,0.30836033816865405},
{0.9005968373990291,0.4346390132945805,-0.003776849107453009},
{0.9536460828534782,0.2921979004492634,0.07196899076171352},
{0.9017376413250835,-0.05487112610092003,0.4287871100416757},
{0.9323326914636033,0.04511611858408497,0.35877609768787583},
{0.9811456568629929,0.11612245917640307,0.15449522482494688},
{0.9725018931200617,0.19037971571230833,0.1341477980557138},
{0.9593290066775162,0.26376549832894575,0.10057643281809589},
{0.9126528023845694,0.4032488899772513,-0.06674724737175956},
{0.6082903246467456,0.6510281919344328,-0.4540321290919181},
{0.7888442304030572,0.46828336618378946,-0.39803953210125687},
{0.4164075562919701,0.5261931907653673,-0.7414347395793588},
{0.9307902441412871,0.3634604663702052,-0.039064188169680734},
{0.9138237034007233,0.04142809140370555,0.4039925152099147},
{0.8496730493715209,-0.14102776231698225,0.5081012491891415},
{0.8864653948903553,-0.1335514550174492,0.443106209079278},
{0.9056480111149928,-0.08057469746326693,0.41630445360596463},
{0.9871953315503194,0.02694611394987307,0.15722367604230394},
{0.993032330241101,0.11350149560385382,-0.031689139963358044},
{0.9826632964118452,0.1842109180226073,-0.020956706952057022},
{0.9669221491760092,0.2541991430190207,-0.021079685036618397},
{0.8093234030469033,0.5560177811084683,-0.18931417372134404},
{0.9402279094090066,0.2329432568103869,0.24841279652010487},
{0.9060101808209463,-0.07476746056428486,0.41659978287268},
{0.8475813663211551,-0.2859568588171965,0.4470285252202212},
{0.9443584351166531,0.32700057628247137,-0.0354650410257485},
{0.9741817717032464,-0.032447013911030255,0.22342127689497532},
{0.999644655762955,0.02428778729647993,-0.010984789156120476},
{0.724096436509355,0.3375331817403305,-0.6014613053710958},
{0.32288129039913777,0.35234973950288484,-0.8784061323684147},
{-0.23688356948904354,0.6560286364300957,-0.7165979365654068},
{0.9098767972948918,0.0882121025539373,0.4053922035602117},
{0.7910387178639979,-0.059734048338666294,0.6088428289050929},
{0.7735116099119254,-0.1681192120266171,0.6110775072599308},
{0.8716265189594099,-0.16546442357088845,0.46139867357747677},
{0.9704655098455144,-0.05356733914783493,0.235217419373878},
{0.9977930158211905,0.059356587625207444,-0.029763956120525945},
{0.9401990894437136,0.20014820268187053,-0.27561997237578556},
{0.897122064275058,0.35641585445214263,-0.2610358988453652},
{0.8742072400589167,0.4674037397063555,-0.13151214976984046},
{0.14136198027701805,0.7563987832141381,-0.6386530132116588},
{0.3883164995302249,0.8393437630143867,-0.3804107565269966},
{0.9029810737222331,0.3766793005447012,0.20673143215437176},
{0.8850768338693988,-0.06288381872614741,0.46117743167910696},
{0.9092999925794483,0.1910561286750205,0.36969051812391596},
{0.8536898044825559,0.14159635246579125,0.5011628384975475},
{0.6047868162958209,-0.40603037564855177,0.6851074666688876},
{0.5807606034523253,-0.5458528777779486,0.6039550954327838},
{0.39404798500217475,0.08759263011557684,0.9149063977616297},
{-0.05978382944341017,-0.0029137896318177825,0.9982070945285165},
{-0.37857836688425495,-0.062256475829733426,0.9234730918356593},
{0.0527217152342739,-0.7197171066823532,0.6922627442608322},
{0.31250437355369837,-0.06961237961605966,0.947362197427151},
{-0.19334728915066138,-0.3682857912893953,0.9093857276823926},
{-0.5880855856591619,-0.41862837266723213,0.6920300784921891},
{-0.3392302324204976,-0.6668646236847804,0.6634865658697932},
{0.28389550746268616,0.0302656233614486,0.958377448026114},
{0.058156664927913965,-0.019615637293601815,0.998114737441557},
{0.12729489225197266,-0.1311491447096035,0.9831560976002225},
{0.9871264737297588,0.050221085607208144,0.15185245280299264},
{0.9096015727608019,0.07130657768575288,0.4093169319852544},
{0.6492531303186796,0.024983422111991355,0.7601619573426243},
{0.3785868707290165,-0.20327243830545333,0.902968602520025},
{-0.5253003899705161,0.0721711251658872,0.8478507114988544},
{0.9683498384255037,-0.24137786039929265,-0.06352416020980106},
{0.6080300123767516,-0.626667364992261,-0.4874295002385307},
{0.6713198878607485,-0.5965550222181115,0.43983146048114863},
{0.19502513852623793,-0.7828063873121627,-0.5909139999408559},
{0.6558503899844919,-0.6768497874842598,0.334267304921828},
{0.5584202518641849,0.043557956399939146,0.8284138619930267},
{0.9058249422353061,-0.10669064225954629,0.4099979035051884},
{0.9428208885138495,-0.24075263045054685,0.2304928265979173},
{0.8029183592862498,0.5915461326297964,0.07345257852389046},
{0.8774172079067207,0.41043491649627184,0.24835905981033346},
{0.7634540489535657,0.4054832047816374,-0.502713920412414},
{0.5389373739926291,0.4312157231256853,-0.7236017599779048},
{0.5488887958998587,-0.10394216211596985,0.8294076902647218},
{0.47788600123103425,-0.11411166240011308,0.8709784717957697},
{0.6675346524320607,-0.05277362545566873,0.7427061547198007},
{0.3309338847392086,0.027561026997687543,0.9432513735596937},
{0.26373502739371285,-0.042811937835100636,0.9636446301954061},
{0.15014509440947793,-0.12827940308937275,0.9803065058275413},
{0.47498730006417267,-0.1698320219130356,0.8634489846601696},
{0.36799098138147684,-0.18637723156289046,0.9109589261744189},
{-0.27094192857729227,-0.1338534848927397,0.9532437861957908},
{-0.1919193746909829,-0.04535725636979627,0.9803620111534447},
{-0.33306753894435637,0.07436896378274811,0.939965569437216},
{-0.21634221960170144,0.13351137622500414,0.9671456748785647},
{-0.05606221078915401,0.137582210035395,0.988902504801767},
{0.19239664631234432,0.03375230092804434,0.980736617379929},
{-0.10397746464779296,-0.052427165861834275,0.9931968984673244},
{0.007229259943426504,-0.16108671239641958,0.986913779866298},
{-0.2131146223502095,-0.3826044461499543,0.8989972166401932},
{0.7334744726222678,-0.6257268704904408,-0.26548273306888587},
{0.824793391073877,-0.326833636296236,-0.4614061510494136},
{0.16009777335287678,0.6085892401846917,-0.7771665456637146},
{0.5962119634191286,0.4180861286599066,-0.6853723686420979},
{0.8973297443944959,0.2349570104427848,-0.37362351782067715},
{0.06897341176101368,0.7177151494420111,-0.6929124278950965},
{0.9606472753024156,-0.22281493687038054,0.1658623416013818},
{0.7445772339909189,-0.1108945945617904,0.6582606865971934},
{0.7205822748767402,-0.01634141444013335,0.693176848508054},
{0.7415386486189229,0.15970338279028526,0.6516250932321139},
{0.6649175865577371,0.41642652740973923,0.6200593119659601},
{0.4787270788687862,0.5208724440018613,0.7067618276599882},
{-0.04670984105166277,0.3473344536131937,0.9365772622064624},
{-0.2928540260064978,0.41219340667315285,0.8627474224516504},
{-0.47620223374502846,0.5164307110157964,0.7117097394977565},
{-0.3532566368736198,0.4718710394131713,0.807804104141513},
{-0.2995549699771691,0.4983693939506111,0.8135691532594373},
{-0.7616319534102544,0.6476094938241382,0.0227752289411892},
{-0.7575769316238407,0.5308819743250329,-0.37979141908179226},
{-0.8330145058407826,0.5498444055349643,-0.061302224761736086},
{-0.6452164788356556,0.606819785709249,0.4641825536474836},
{-0.7882521234695373,0.6145674869623973,0.031070787155925955},
{-0.6399744316037647,0.15039767383057964,-0.7535338523250226},
{-0.19984164842764035,0.050982603282310905,-0.9785009400691866},
{0.2662829664249477,0.08364171223358817,-0.9602590513848666},
{0.11401599753711626,0.13924951876634306,-0.9836716544807818},
{0.41750106019880906,0.024151636452729042,-0.9083554167777751},
{0.3549768835007013,0.0003876451598200594,-0.9348749980138306},
{0.2539606592025947,0.08169315561021791,-0.9637583783832065},
{0.2077763615521767,0.17981608503623445,-0.9615067129991245},
{-0.1330831674804135,0.15751166615983656,-0.97850853116206},
{-0.8838200854580258,-0.3949949189797004,-0.2506812129402361},
{-0.9747041821152567,-0.1871910945758754,0.12211163531176826},
{-0.9908807472856166,0.12250279300969993,-0.05611069740718446},
{-0.967248852786495,0.18351630794905455,-0.17536083228576857},
{-0.14311156651291787,0.1912617954042237,-0.971049949873317},
{0.08684008681151623,0.09764139431686467,-0.9914257195768258},
{0.45614616800405144,0.02211483379477568,-0.8896300397027121},
{0.4035921637895513,-0.08413657465979223,-0.9110622383416982},
{0.2761511810915037,-0.011903330037789718,-0.9610404965014633},
{0.16654662059498496,0.17114782766558673,-0.9710667558174055},
{0.21462057081933222,0.22296842380947868,-0.9509064583675413},
{0.17818784492462772,0.3547117239040698,-0.9178391388724496},
{0.06820752535250492,0.384626979003692,-0.9205486518961291},
{-0.6646618357429567,-0.05013877802554322,-0.7454600908465243},
{-0.844226607234517,-0.524922739609848,-0.10833998835973915},
{-0.8020839616105013,-0.5267077340621636,0.28149650336426024},
{-0.897950943972826,-0.3959006068355548,0.19221553455834473},
{-0.9993456036711802,-0.026934135953630107,0.024143668808110735},
{-0.8963327407104248,0.29896668862336495,-0.32742409353026936},
{-0.8605741784837886,0.2826827944686271,-0.42367737848315695},
{-0.8557393201119355,0.24926427739135673,-0.45340659019353385},
{-0.9459323876309479,0.1721362417737736,-0.27492004710245294},
{-0.8998203313792154,0.20831074063548452,-0.3833145008638404},
{-0.6470131493430032,0.16411697389778143,-0.7446070127630302},
{-0.37928882572839356,0.13891941952653408,-0.914790348416503},
{-0.42824001993528277,0.7090362231701435,-0.5602482660021778},
{-0.13016930883258665,0.736911931457559,-0.6633375884973929},
{0.034142538661852476,0.7516578679573538,-0.6586689127259076},
{0.0934420660954333,-0.24962145309640388,-0.9638245226377343},
{0.32948050404300766,0.261703080508825,-0.9071681735531494},
{0.3044884347299521,0.7344756283333784,-0.6064918338279525},
{0.09904513034534834,0.6257943174017904,-0.7736740492368218},
{-0.38435452104791595,0.44827628697749217,-0.8070439719641677},
{-0.5937786404386971,0.6019148479954014,-0.533971386800309},
{-0.8099305080960336,0.38763100267362943,-0.44017584874858534},
{0.22450958183707703,0.1773950030846855,-0.9581891569747204},
{0.5646356543998268,-0.3725049653436803,-0.7364961836797139},
{0.13053294835413515,-0.8295076148612248,-0.5430269480248827},
{0.4361065015969161,0.062607997314511,-0.897714519174757},
{0.22278176802216718,0.30266620352190443,-0.9266938292028033},
{-0.05481696144822306,0.2261156695667609,-0.9725568388088993},
{-0.4697068412066489,0.22985343805975883,-0.8523748473152999},
{-0.9949216882535106,-0.02377876724929505,-0.09780288580040986},
{-0.9410882879622156,-0.15083665995271914,-0.30265679618117564},
{-0.471143861244819,0.010144440022793218,-0.8819980455465574},
{0.4649594338397468,0.42266295170526524,-0.7779259310109251},
{0.6475489257463659,0.3563720827370362,-0.6735572191064354},
{0.7446167399739941,0.19046357139166975,-0.6397417748773576},
{0.24789845113892978,-0.8198127438327085,-0.5161912658815584},
{-0.15038795876030003,-0.8751029896927854,-0.45997632470667327},
{-0.07838766663623994,-0.8383392832480201,-0.5394836604407235},
{0.042244159247773826,-0.7513896773914231,-0.6585051129027488},
{0.6603670917950485,0.023050115089716404,-0.7505890994868635},
{0.8596495362749431,0.021738895242020356,-0.5104214878078036},
{-0.14628066749298588,-0.051145011627056286,-0.9879201152438768},
{-0.018665519516347595,-0.0433458340824424,-0.9988857477453977},
{-0.1655114052929194,-0.04444950256174982,-0.9852056721517473},
{0.6066083369420124,-0.006140363615597357,-0.7949771201029086},
{0.8815607160747163,0.016914996550872523,-0.4717675134698417},
{0.6481136215293615,0.035596069821656875,-0.7607112812370718},
{-0.04839687234974067,-0.1611462668677585,-0.9857431832994576},
{-0.1891265961010659,-0.11450717200719965,-0.9752534225554598},
{-0.68355877764107,-0.1157690446966037,-0.7206558997190557},
{-0.17911622372255587,-0.01766548142177115,-0.98366930884597},
{0.7543801866150105,0.04192505237982543,-0.6550975683252462},
{0.8824300207868974,0.038994727748553046,-0.4688247749659271},
{0.8839402756204524,0.059788729452602996,-0.4637616812183626},
{0.7326031039540238,0.0819651062686375,-0.6757029032284092},
{0.4466507964716708,0.09955098809767893,-0.8891527803364269},
{0.3725590563757475,0.13022022072745537,-0.9188266668017997},
{0.1604614833029495,0.5273773901646778,0.8343411776481552},
{0.08564627497630173,0.5868880512489109,0.8051255373442949},
{0.01999038985527308,0.483635689596183,0.8750410870709208},
{0.14565495113565569,0.40177431103373995,0.904080769734117},
{0.026860832621139016,0.3688725662921599,0.9290917745346449},
{-0.09743759037368786,0.45294918981106125,0.886195772632477},
{-0.08401975382540822,0.5838568070459136,0.8074973125857873},
{0.02737983105459773,0.6801357558202932,0.7325747050684867},
{0.15300238071477495,0.6727757384253747,0.7238529389881642},
{0.17486545305387044,0.5640047415709892,0.807044437942364},
{0.18559734189966948,0.46477357554608656,0.865759291116118},
{0.18958456679315056,0.3526426303277672,0.9163519341985191},
{0.16142927974501506,0.2559168391512659,0.9531249441074506},
{0.0023425972685084413,0.20715517519617982,0.978305292650243},
{-0.11023997622078387,0.3173194253010077,0.9418893406178239},
{-0.21340785361072345,0.3655222994766743,0.9060080223720695},
{-0.24528412115780843,0.42781381819198055,0.8699488702629832},
{-0.1788564642399293,0.520665638246357,0.8348159427976353},
{-0.23036727579843302,0.6235456846006688,0.7470754295632348},
{-0.09473214987962568,0.7038419052209081,0.7040116421155167},
{0.014175129951222559,0.7675215992079513,0.6408663358611804},
{0.10348016100592014,0.787716285284447,0.6072848674023259},
{0.1307270483252382,0.7528079068744916,0.6451284323167115},
{0.1680977625313317,0.6456836108692237,0.7448730206463656},
{0.16092416063099188,0.5878110747718546,0.7928313533789944},
{0.17176473326520567,0.48907559415435387,0.8551619376521025},
{0.2283795120164311,0.42605661812217654,0.8753962283705765},
{0.2297218426372841,0.3257137513179947,0.9171359916706412},
{0.2405951455175341,0.21877558230846034,0.9456485713725743},
{0.19182068429194277,0.2127374496627272,0.9580958211936682},
{0.2015357223645373,0.1850496903527115,0.9618419645198321},
{0.24649197490787442,0.14385339731327304,0.9584090496168354},
{0.10882343909377755,0.08730110912556653,0.9902201651396768},
{-0.0638264331401845,0.06576710260191278,0.9957915819326607},
{-0.14624847686311807,0.15493256305068664,0.9770400625981327},
{-0.22109328839476725,0.2546104336336129,0.9414304461359276},
{-0.3257459626999775,0.29257348345664785,0.8990496785843969},
{-0.3556171639151235,0.3668597350472778,0.8596222237297063},
{-0.3055001854924145,0.48717954751796105,0.818123294586027},
{-0.35904632351254534,0.5294693920777958,0.7686012623102397},
{-0.2484322944785213,0.6928750751901667,0.6769088012726369},
{-0.13381889754902027,0.7475277799493447,0.6506110365362464},
{0.04804445790400089,0.7569058653125681,0.6517555071651818},
{0.12178710267459426,0.7465529902315797,0.6540845009617754},
{0.10482267392534045,0.7909857440458008,0.6027883208452638},
{0.08615266292742599,0.7769449264534946,0.6236459732321594},
{-0.06217513364928446,0.8548800287410139,0.5150867783349298},
{-0.05301408820135271,0.714302974908521,0.6978257422086233},
{0.00010919954561119839,0.42658366387216345,0.9044481001101502},
{-0.04182585859782892,0.6679828987368014,0.7430002991572309},
{0.08200275351350979,0.5163283866776158,0.8524555973932559},
{0.00794151353153644,0.38607419415612276,0.9224335471834971},
{-0.2177951485833826,0.6405112514938615,0.736417415575779},
{-0.0828679793225384,0.2417136845025819,0.9668026648324806},
{0.15140995800312643,0.4609557516058026,0.8744111273760308},
{0.22764665064356454,0.5028441847126722,0.8338613364051692},
{0.3706402294622199,0.4453427933996901,0.8150433219597311},
{0.39672208658465347,0.2970533061900694,0.8685452891458612},
{0.3048362518716956,0.21794215917125564,0.9271332562261948},
{0.35470080450080343,0.1125120249487011,0.9281855329234698},
{0.23899403572101996,0.12802640229003082,0.9625440723449764},
{0.10218137298752393,0.13025930030425314,0.9862005281374732},
{0.09775781926984732,-0.07171696548251229,0.9926228315093221},
{0.38864832221217843,-0.010240398958345295,0.9213292657192826},
{0.4551710517245564,0.23360878868627294,0.8592125741168443},
{0.19705845840689065,0.06542013143097142,0.9782066092466633},
{0.08298101529248131,-0.09147764609995072,0.9923436861113398},
{-0.005029837095347092,-0.03560478696626226,0.9993532908255626},
{-0.09881208271431033,-0.07768274872084771,0.9920693336964076},
{-0.17560411072208226,-0.008703853868653598,0.9844223886245883},
{-0.2718779400383816,0.1075369489113311,0.9563044443791568},
{-0.360113478515937,0.1889047128730699,0.913582668424426},
{-0.44878342290385537,0.21616475349698547,0.867102207742713},
{-0.5275570116645842,0.3163522291195631,0.7884192200692581},
{-0.45157466535831164,0.42195683124298283,0.7861505925545751},
{0.84821322896723,0.48000744112299343,-0.22389098836608276},
{0.828390639649765,0.48523582720081176,0.2798484235106516},
{0.9292636777474713,-0.30591854355610193,-0.2070817759431211},
{0.9569936722172205,0.2184001706610674,-0.19095674062838303},
{0.35059637737765886,-0.9249629765978002,-0.14671629798014785},
{0.799435733792978,-0.4882123897956128,0.35007309234635464},
{0.6833936826847007,0.7060925609968854,0.18548954086821762},
{0.7718409917591794,0.42821053082530436,-0.46999704757638366},
{0.5090161725187932,0.8541980005400321,-0.10605805951331274},
{0.6047466047974223,0.744845044084757,0.2819351065198639},
{0.8161832515168738,0.5268362184372811,0.2372519734081233},
{0.8632080183946572,-0.4496394953706776,0.2295566186847407},
{0.7481786877420452,-0.6485685891987215,0.1399551224977889},
{0.0998776264560731,-0.9949926342861447,0.0037573194992853724},
{0.10682453757043023,-0.992964136172951,0.05109542491426445},
{0.11618266311839023,-0.9932271857004105,0.001160334590112187},
{0.6027731794932082,-0.47791576092866705,0.6389530652087222},
{0.8753914333720827,-0.35377744265350214,-0.3294409802200062},
{0.9054699627271678,0.366190813608157,-0.2145423842224592},
{0.7372753731648989,0.6692550257188002,0.09231865832369421},
{-0.09308941600974661,0.9948175909751859,-0.040894025398487334},
{0.0960307693372775,0.9932149522838429,-0.06559077603058384},
{0.020049572441360027,0.7444749003074221,-0.6673493368972301},
{-0.10457667868591117,0.8755664127564919,-0.47164305902637005},
{0.2916087285517697,0.10236222987173008,-0.9510448587359627},
{-0.31576582464701897,0.6499626588285293,-0.6912600712564968},
{0.14462133159067234,0.23861316023692056,-0.9602855982522545},
{0.43560782146783494,-0.30893158606935167,-0.845462655003},
{0.28523979067463046,-0.20581571711096255,-0.936097298578515},
{-0.4254551062470612,0.17448138735771918,-0.8880001115056391},
{-0.47454272328261804,0.4638622957608103,-0.7480915547919434},
{0.37923856311778653,0.014553651469087242,-0.9251844699697855},
{0.4642071351308021,-0.06183496409300712,-0.8835656019273668},
{0.39948526758718206,-0.18055296722472766,-0.898783704239871},
{0.22330025384093488,-0.19407207763554135,-0.955234539428301},
{0.09295362834202764,-0.013609661316918055,-0.9955774204434785},
{0.008287001079437053,0.06945843270678717,-0.9975504256622951},
{0.021351013369780177,0.22057530209328421,-0.9751362316797278},
{0.11672359366173207,0.36981573981455573,-0.9217439564586813},
{0.18066742147266487,0.3792687315558131,-0.9074770036108148},
{0.1327122490538464,0.5702313504054233,-0.8106933242391214},
{-0.038950373347801895,0.5781790646902506,-0.8149796546969585},
{-0.343940015523824,0.5349413304165082,-0.7717143504780042},
{-0.8283753504924163,0.11677897032921487,-0.5478658145800073},
{-0.9471141114777851,-0.2376236014346411,-0.2156615030107982},
{-0.7383832117686505,-0.6678373966759981,-0.09372003083246162},
{-0.7193944676676717,-0.6729069142723539,0.17224367800765936},
{-0.8417743674659319,-0.5392675567479599,0.024625525708423482},
{0.9177095294123981,-0.11384050753526671,0.3805910646215799},
{0.987611903482167,0.08862685121027498,-0.1294913485329531},
{0.9975052166151093,0.002704623692493132,-0.07054096566057218},
{0.6940109194288436,-0.23096930668069768,0.6819105682455501},
{0.9953187684809908,-0.06017479575441969,0.07562766071615426},
{0.9894909606493936,-0.004455915193615164,-0.14452606551389804},
{0.9957514265885271,-0.020844642732150982,-0.08969167919200755},
{0.9701987978428639,0.08137322770654618,-0.22823823184751543},
{0.9657156657071851,0.06837378878985621,-0.25043617553031},
{0.976100941035369,0.17945423350050255,-0.12256888262774515},
{0.30694042188812265,-0.279931139818137,0.9096296688055309},
{0.1914220255981105,-0.2768400980572328,0.9416566084425777},
{0.4592707965057891,-0.25576298891135835,0.8506795101447232},
{0.9322440471162641,-0.11583570307237982,0.3427872904732848},
{0.9983975951567259,-0.05263149963204871,0.020788632272182875},
{0.893571473646972,-0.21550813112897085,0.3938099375354526},
{0.8034382183647676,-0.3067998221749825,0.5102557186198378},
{0.8854410831278445,-0.31750427814914434,0.3393893364064056},
{0.9890290087363023,0.039619074685688725,-0.1423093419250365},
{0.9963366762125511,-0.05016309222025782,-0.06925959726007631},
{0.9473456422242327,-0.31380050094424145,-0.06376111484203587},
{0.9371082654456901,-0.15411056124746722,-0.3131741268773024},
{0.9099865558854238,0.0698146864514159,-0.4087179683638524},
{0.9059930276933849,0.22980265302098604,-0.3554818904466018},
{0.9185112896043935,0.3595603179957772,-0.16447914333449548},
{0.9419326473962951,0.2193298737111573,0.2542779862018231},
{0.5238521489379051,0.8516546615176906,-0.016225398864950204},
{0.3694534486494629,0.9246344581007413,0.09249469267891584},
{0.5003416782231608,0.841638494603891,0.2032310247814721},
{0.35334030684967244,0.9000282139558887,0.2551467061099403},
{0.19559860883688254,0.9686766856608281,0.15299236215651346},
{0.20800000378861327,0.9781251526894903,0.0026803171637114725},
{0.3755150666226769,0.9229650337706419,-0.08440367987312312},
{-0.4970240582194369,-0.7113310730291603,-0.4969659848463126},
{-0.3299673012576743,-0.7990648292090714,-0.5026101658560089},
{-0.4776732527250906,-0.8447336796160603,-0.24135715061572743},
{-0.620874518132649,-0.7408698057486882,-0.2561772114444453},
{-0.5167259571171698,-0.8560821246588595,-0.010848091118620737},
{-0.23769510142702507,-0.9713392534680664,0.0010456718872809262},
{-0.26421949402625067,-0.9197553553875996,-0.2902380836698426},
{-0.13288313997339685,-0.843069485012034,-0.5211294604533064},
{-0.14811555849598323,-0.6560659426498093,-0.7400265267045769},
{-0.3281581868518979,-0.6110777225608969,-0.72034451576441},
{-0.4829002534029488,-0.548141028376414,-0.6828973263044856},
{-0.6393225767817843,-0.6342233290414309,-0.43477282771201836},
{-0.5456430478424276,-0.767657417686737,-0.33611865971968435},
{-0.6353086022574881,-0.7651233032231176,-0.10473447743022327},
{-0.5494947414149571,-0.8354967232775371,-0.000868648264881445},
{-0.37441341852056237,-0.9107810536452934,0.17404730492746953},
{-0.12174358955713277,-0.9778494238274927,0.17026157147749107},
{0.04496288474951671,-0.9980958338490301,0.042226122817648856},
{-0.017228886684696153,-0.9687080988468412,-0.2476040886014297},
{0.2545484884791824,-0.8016928321925928,-0.540826839038137},
{0.023757081396123026,-0.6852000418113633,-0.7279673782424896},
{0.1776044064197447,-0.4453159464626318,-0.8775821230211908},
{0.13873354600649107,-0.3218604509544395,-0.9365675914336721},
{-0.1698492955212068,-0.41651817414943865,-0.8931202760066348},
{-0.42134297997228504,-0.41275398474183933,-0.8075297154333133},
{-0.6307832840713153,-0.4958656175656624,-0.5968498453149087},
{-0.5651366973816127,-0.6650129275067589,-0.4882400224495058},
{0.9042566757383664,-0.01854410085402561,-0.426586428178528},
{0.8909986088377806,-0.32803376252724825,-0.3138715178084123},
{-0.4252305966130146,0.7983757907674557,0.42635083724625156},
{-0.48753146230680056,0.7138676294477646,0.502698797380322},
{-0.5934514994234056,0.35223928017081096,0.7237007719609402},
{-0.6695926445214998,0.4328378498657601,0.6035702826732692},
{-0.3906803323833908,0.2337593667541121,0.8903512994001412},
{-0.5297790874530731,0.2333094034272669,0.81541452082349},
{-0.6960345121828988,0.18940899898382707,0.6925750421104263},
{-0.7647818283734458,0.10632742396783329,0.6354551391735958},
{-0.5233475256477761,0.612803476104361,0.5920973459430149},
{-0.18296492186124555,0.9196979542650958,0.34738956560165424},
{-0.7727471135044047,0.21893964348486047,0.5957577788676643},
{-0.6811285670348696,-0.09816696742223376,0.725552976478043},
{-0.5876786348471403,0.028239700815101867,0.8086014725698162},
{-0.26389652525504403,0.32501649731669524,0.9081425551257359},
{-0.15239340016011219,0.26525570178283275,0.9520586453886845},
{-0.40276969900839776,0.3503185379628898,0.8456083558718114},
{-0.6097768929626993,0.49233706429125185,0.6211089726721297},
{-0.7623756573720621,0.3783432634045348,0.5250140303676873},
{-0.8719519609086391,0.05348199419319371,0.4866615396399209},
{-0.9207019714217932,0.012041031151241147,0.3900806242161203},
{-0.9059444808886661,0.10966476057013227,0.40894772017515973},
{0.1440488734713913,0.7986277739667752,0.5843317556837867},
{-0.7687384541045501,0.367932736153954,0.5231316190474546},
{-0.8532152088992458,-0.013946273795562387,0.5213725239694124},
{-0.7503916577377466,-0.1824194793561305,0.6353231410463771},
{-0.6765881701722821,0.013843427162867697,0.7362314904344348},
{-0.4509678615583841,0.7063089774218574,0.5456698784565155},
{-0.41248242607170044,0.7469266459920003,0.5214967245238892},
{-0.13662531015459953,0.39516940895930996,0.9083912498741439},
{-0.009662416955210218,0.3283018726542963,0.9445234343891452},
{-0.5445404006973165,0.5460510807439887,0.6366348790529216},
{-0.6168713196474861,0.681808973838177,0.3932000739955439},
{-0.8552392487206352,0.28616519238113514,0.4320593826283971},
{-0.9427566759013997,-0.01987836226553246,0.33288842088150744},
{-0.9587385399230894,-0.02410795809902684,0.2832652792391583},
{-0.9249339342925695,0.047456932931156,0.3771538899585104},
{-0.9349937809118266,0.02675246218546929,0.35365369420270715},
{-0.8830125863422911,0.021750807140976797,0.46884504343099753},
{0.12408848520986897,0.3716927720651671,0.9200252882572477},
{0.040111323967367815,0.5776196321449845,0.8153199631128124},
{0.13050221698803807,0.7589408858835892,0.6379481978150261},
{-0.9629778012625747,0.017766311257333186,0.26899463277137137},
{-0.9497706997619333,-0.00013049253747023706,0.3129466421699158},
{-0.6246563014585899,0.4660364157854927,0.6265896298295134},
{0.42297189579157163,-0.15180545169932236,-0.8933363757313639},
{-0.36309506131601105,-0.12481842156159466,-0.9233538531282546},
{0.6597425422547673,-0.2990279943527175,-0.6894360278753987},
{0.8024363230295736,-0.2615432273854947,-0.5363684253305345},
{0.725991631645604,-0.5194437347986416,-0.45068210210634296},
{-0.20491931879973657,0.16460582073160007,-0.9648383266454169},
{0.5517663766143032,0.08097764699754131,-0.8300581222569084},
{0.5560932146992987,-0.04057626704080903,-0.8301288472992808},
{-0.1995922665973581,-0.3883513883076975,-0.8996366635003339},
{-0.6442790443336475,-0.2120075525192641,-0.7348178758762701},
{-0.7721301253738461,0.09178006688505308,-0.6288016291428832},
{-0.6761113729604289,0.1251098867231433,-0.7260998055348082},
{0.7003943712373027,-0.40370806389803626,-0.5886149198608565},
{0.6108579564832639,-0.5980845624029809,-0.5187941915792099},
{0.6222764495674331,-0.6415807962452534,-0.4484931462163678},
{-0.4096593988881334,0.18025561460226616,-0.8942522520558571},
{-0.41628195028659615,0.2762639160174058,-0.8662491480932698},
{-0.1709587068508183,0.22469569857277324,-0.959314840703921},
{0.3734906581924015,0.11676167932283195,-0.9202561809000355},
{0.7589132775975987,0.0322487130075747,-0.6503926949124081},
{0.7175816771968393,-0.010943752347826649,-0.6963883764365403},
{-0.13344614136508226,-0.10190708576688266,-0.9858027557403517},
{-0.16718567719246166,-0.17371747852616254,-0.9705004827387828},
{0.10086074342105927,-0.48915179246352075,-0.8663472943146275},
{0.3730722331440961,-0.6477462090901377,-0.6642604590567112},
{-0.45658267426239285,0.23680287408976763,0.8575876983645623},
{-0.7843445600179644,0.2525813938554909,0.5665741351740681},
{-0.9670093775048816,0.1590237623432467,0.19900830843917067},
{-0.986447276617588,0.06897863794206711,-0.14887483992065562},
{-0.9963949733064761,0.03617880555699291,0.07673428958461925},
{-0.944482304485752,0.14821501372732465,0.2932328191371019},
{0.4034833237364546,0.7821909652004863,-0.4747404569081037},
{0.3030957965729152,0.8375161180048172,-0.45464237613972086},
{0.19363798702571816,0.15404529588601795,-0.9689036984117756},
{-0.008802742821463233,-0.15351339574248463,-0.9881073570449875},
{-0.31253832511375057,-0.7501066110076919,-0.5828034552554116},
{-0.16274713884926173,-0.8643255250313399,-0.47587262536909797},
{0.005533334584186107,-0.726560669938355,-0.6870800354450043},
{0.17787715086664932,0.5089624962592488,-0.8422095324805564},
{0.18142286260540014,0.7534623332180905,-0.6319653925221009},
{0.13874424408414035,0.799531244879411,-0.5843798620718376},
{0.15050907385308795,0.7923710174615396,-0.5911811815127831},
{0.2626773863259145,0.7753087551612949,-0.5743665422735116},
{0.3805291111768886,0.8641747565812173,-0.3292409233900318},
{0.42670326674459463,0.8416223958359393,-0.3310529640055572},
{0.25576691690133624,0.8047944181259233,-0.5356204148201796},
{0.09002009007914265,0.40760113440722756,-0.9087121098632306},
{-0.31818878017689334,-0.7537827375834347,-0.5749499845123603},
{-0.40737397868665076,-0.8241149090335507,-0.3935493084705281},
{-0.3035650764495224,-0.8693614878657423,-0.38994723716941304},
{-0.058033499256430573,-0.9450908887541034,-0.321613626822672},
{0.1379526828173473,-0.6652836025507856,-0.7337348195912096},
{0.17238233177716086,0.45933889468935746,-0.8713736922334919},
{0.3199759601131611,0.7297076101260996,-0.6042699634051959},
{0.6808747819182197,0.7299414947636707,-0.05995786495527372},
{0.555359405711417,0.7740669698602166,-0.3039675256656283},
{-0.17129194965177383,0.4552585721387401,-0.8737269026868119},
{0.6657557433086989,0.7267777211523307,-0.1690072018823657},
{0.5461692641160534,0.7853466431898652,-0.2914271520729304},
{-0.26317616858671106,0.41791621249888894,-0.8695311056072708},
{-0.055632162139692215,0.4684261357030804,-0.8817494076697427},
{0.61770650222571,0.7765458242643795,-0.12415820522878987},
{0.520537496262023,0.8236781394193458,-0.2249334070962989},
{0.21770895783023017,0.6120689081177809,-0.7602463162659735},
{-0.0360668300343903,0.3530472617669576,-0.934910057026944},
{-0.17056771817850264,0.3556159859587018,-0.9189363003201034},
{-0.0408192309218773,0.6599701503716617,-0.750182105228692},
{-0.22337039172014972,0.5278770798782659,-0.8194214157818805},
{0.006236518781487173,0.6773858436684433,-0.7356014713355864},
{0.3530731541447222,0.8961677255228545,-0.2687429172154884},
{-0.27293383369623664,0.5135154766399312,-0.8135164274156603},
{-0.35523441546199186,0.5241677822065812,-0.7739874974235765},
{-0.28016300095033897,0.409097699586506,-0.8684168152975446},
{-0.41946366272916247,0.2939098081836618,-0.8588755790586193},
{-0.2155358153356948,0.42051316797374283,-0.881313217799588},
{-0.21793021269145457,0.2872037576205394,-0.9327488536604588},
{-0.3211384423698532,0.4386853391786635,-0.8393004670688355},
{-0.5095928694251404,0.3911860724273441,-0.7663475478984195},
{-0.6175792995152689,0.18108583022119792,-0.7653781620240606},
{-0.6218750528388762,-0.15149613820364446,-0.768323069265805},
{-0.7228302835238852,-0.18592357999198195,-0.665543990750232},
{-0.8215964397178172,-0.1779858240852855,-0.5415720973865705},
{-0.8459010989971352,-0.09633273487858221,-0.5245677600713294},
{-0.9076896626234237,0.032451379643288265,-0.41838544946714223},
{-0.9771523149182051,0.041027803548597835,-0.20854273611413712},
{-0.4059140458804218,-0.7875107709150464,0.4637462377742556},
{0.117229649315097,0.1330046969928375,0.9841579953946942},
{0.23197287840453285,0.2917532055593323,0.9279378485278902},
{0.49398748180782176,-0.18547027305659522,0.8494569710288327},
{0.6676350539985663,0.11001818751738121,0.7363147649529526},
{0.16294821528344045,0.2372801773796048,0.9576773969133054},
{0.5273798759503873,0.3563083106843841,0.7713072372147137},
{0.3773246819856691,0.052308634342789574,0.9246025584745079},
{-0.34678583954637976,-0.9080433357409364,0.23494016665224707},
{-0.41798393261682387,-0.9083869781411467,0.011069327792163441},
{-0.3525176755095777,-0.7720321076998433,0.5288645508387395},
{-0.5056324447783861,-0.5515157169830139,0.6634502579004279},
{0.11048661025893285,-0.11356887071315341,0.9873676217895895},
{0.952627328165849,-0.2952872022891292,0.07284670065181237},
{0.7858049308554479,-0.3325484827988804,0.5214615203746367},
{0.5974887857503655,-0.06386691622310516,0.7993298242369695},
{0.9322989724875217,0.36008206182524594,-0.034051940479083276},
{0.888711127153783,0.45572879219482604,-0.05003798994461693},
{0.8992405365918723,0.4288062216858197,0.08655450071193965},
{0.7320452900037248,0.2544451009494721,0.631955207262489},
{-0.11379117679893566,-0.8232744209047883,0.5561212061831476},
{-0.3828994109985334,-0.7307715902411372,0.5651202738828395},
{-0.29807369422680874,-0.7178276714772917,0.6291863848427366},
{-0.10908687892644416,-0.5883974159448911,0.8011794641373816},
{-0.020995671353211665,-0.3784097498069393,0.9254000448646398},
{0.07677437858788673,-0.44726564908722655,0.8910999573218628},
{0.28996368430125674,-0.6758725386213806,0.6775820048702086},
{-0.2696467091304295,-0.18026909571078006,0.9459353600467355},
{0.20577169849937138,0.07450088736686167,0.9757600247387849},
{0.7500762202976601,-0.5891969056854817,0.300387533154473},
{0.8275262400659166,-0.5128936598795472,-0.2283427591532746},
{0.9576808826900295,-0.03630416475173172,-0.2855334210766313},
{0.9067097498493655,0.09117290598848407,-0.41178262559476214},
{0.9279360251974819,0.3109469561817067,-0.20554007780000036},
{0.860531889431575,0.4152752152851739,-0.29501078427944977},
{0.8415288340601036,0.3547990535548986,-0.40736574848898505},
{0.8988650815807105,0.12206181785150254,-0.4208829739223117},
{0.9998933437162394,0.010251522776978536,0.010402282091522694},
{0.30259027232373376,-0.7200450737555572,0.6244791580632637},
{-0.02356866357454104,-0.586198876824879,0.8098242987874348},
{-0.07079481909455179,-0.25832949868732047,0.9634593731431167},
{0.0811448702542985,-0.4935872601310382,0.8659024925866352},
{0.3060670570802372,-0.11932755144699793,0.9445019280212756},
{-0.17121628672412983,-0.3910287670447162,0.9043127149962503},
{-0.3942179855613414,-0.8444038679489884,0.36273170202333516},
{-0.37150739902132535,-0.7373673712576021,0.5641556631613861},
{-0.02881498179768022,-0.018783573274594158,0.9994082620226017},
{0.042590977553312204,-0.2314478631529673,0.9719145514256788},
{0.3884840709925401,-0.0857477632351214,0.9174570549542014},
{0.2700585683746963,-0.10710567794530482,0.9568681954163207},
{-0.012790537634650035,-0.6436799636428828,0.7651878897053414},
{-0.3235280562152561,-0.8310289280752116,0.4524605149001874},
{-0.4085102307066811,-0.7884003292006783,0.4599394659346338},
{-0.3552083073756428,-0.847786504946246,0.39380845648914087},
{-0.06674793185065842,-0.2189778212988034,0.9734441059315574},
{0.1346439187930126,0.026084286337302892,0.9905506676280291},
{0.1431289122437199,-0.13328625763336355,0.980687966687683},
{-0.06372065135248321,-0.39843898191948846,0.914978719030217},
{-0.21035479501245463,-0.6251178199653991,0.7516505646754847},
{-0.1800933715054086,-0.29436359924035094,0.9385714938043244},
{-0.07066890368925784,-0.6964564448346582,0.714110864291832},
{0.04907803173698377,-0.5028722692239301,0.8629662957766072},
{0.1260203551460533,-0.4740724268726566,0.8714207962677573},
{0.23405245505574543,-0.26746963065809465,0.9347082138068546},
{0.24372355449708907,-0.1824124171097217,0.9525358466049945},
{0.2256209010474983,-0.8253545898259265,0.5175760910859306},
{0.05488864095359112,-0.7919577106285207,0.6081037918565383},
{-0.06402474356381864,-0.6271257550279632,0.7762822422239184},
{0.13631294963698184,-0.18415104576383548,0.9733998007526771},
{0.2084274415477797,-0.17232145325095255,0.9627374088292854},
{0.42296973917888325,-0.38234995593183196,0.8215260865839098},
{0.6554366950187803,-0.1972144354798104,0.7290467785137233},
{-0.1610437057761731,-0.3863275359216847,0.9081937897929917},
{-0.5436267173677841,-0.03168164875436079,0.83872895818383},
{-0.4978717995007927,-0.2067534567331072,0.842245023369538},
{-0.2261150200768096,-0.33385300317091315,0.9151033657294821},
{-0.046696491296537225,-0.43865424536395936,0.8974418592448025},
{-0.22266441909433682,-0.5749963071639161,0.7872736520532368},
{0.01950597944212249,-0.20130059788294488,0.979335277654171},
{0.006292441713448427,-0.5345267653751934,0.8451281218104246},
{-0.1053471068136114,-0.8554939150746985,0.5069833807494738},
{0.048834430662541665,-0.8968889252152168,0.4395514238495408},
{0.28641902757739773,-0.42520612766104365,0.8585824885479076},
{0.2530794121685365,-0.28395796581086,0.9248344093885059},
{0.2636758705201547,-0.9281137138561374,0.2628306859132059},
{0.35522914280170326,-0.718506978797738,0.5979631907762499},
{0.28137448164958956,-0.6473207331457641,0.70838144351476},
{0.13821699745144,-0.7847198560075795,0.6042439980694488},
{0.17298344594740767,-0.5517896769528474,0.8158461128401805},
{0.16039626074695093,-0.15909306192714248,0.9741470305785686},
{-0.011981595156798414,-0.44850883263318214,0.8936980857244345},
{0.2168021596767886,-0.34711801978012724,0.9124176148581326},
{-0.24824026127917578,-0.632799244516809,0.7334452186898501},
{-0.47120336655549466,0.12434968544044361,0.8732150611834584},
{-0.26421204989019115,0.034149536249324514,0.963859845551613},
{-0.22809955475460592,-0.8652124900763485,0.4465175697961224},
{-0.09277243426688733,-0.8457828667479228,0.5253994839699234},
{-0.1750556182597213,-0.7378794328649356,0.6518354647229833},
{-0.17414264458035814,0.11456928054751862,0.9780328313985084},
{-0.35382351724322325,-0.34435269666453217,0.8696149371678819},
{-0.3762526158795721,-0.5477871785213421,0.7472370280516126},
{-0.2564399771910332,-0.5359880604568066,0.8043353387400141},
{-0.15400723242234993,-0.42908822699425353,0.8900365530788813},
{-0.08999127452798444,-0.3038111884110676,0.948472631289424},
{-0.043938760655722074,-0.21311568082125146,0.9760384684530287},
{0.16430781920133763,-0.13128294277181943,0.9776337399488991},
{0.2452259128791196,-0.053450367522879454,0.9679913790237346},
{0.3344590366295881,-0.16552447917864532,0.9277600980907973},
{0.4519756627831516,-0.26158249492317975,0.8528145159420629},
{0.5444602397110275,-0.2945688286962927,0.7853612242365322},
{0.6411572661208012,-0.42255048779005727,0.6406000666319701},
{0.7296970193906711,-0.42522108601768877,0.5354710896942131},
{0.680708821142833,-0.5505960438286813,0.4831971619727699},
{0.6998413681189168,-0.54754985910218,0.45870601834576513},
{0.4821222518560962,-0.23899060727329183,0.8428769921526806},
{0.5091069691533285,-0.06895115830906359,0.8579369625603913},
{0.3658564698535647,-0.17583595499590726,0.9139096018737111},
{0.4753943428732396,-0.0496791574663527,0.8783690568761823},
{0.6624131023283732,-0.07862743748922107,0.7450010791519557},
{0.3994194676768224,-0.5931682414662359,0.6990103905927415},
{0.3682791555365455,-0.5302990121876943,0.7636448266504818},
{-0.5528770057550253,-0.31562677151194757,0.7711723267936308},
{-0.9806605523583494,-0.1476775715433067,-0.12843759539670838},
{-0.9249902416315962,-0.07470156924965297,0.372575802271109},
{-0.9711325684255232,-0.012821247588987728,0.23819561321214186},
{-0.990464257373289,-0.07443914635504985,0.11592828971355826},
{-0.6055947666533529,-0.26600647430507723,-0.7499970228139932},
{-0.7172184117775079,-0.2950626682871259,-0.6312968965475997},
{-0.9805346504598252,-0.11935337905332251,-0.1559056450427068},
{0.27349496492088327,0.017740634386262253,0.961709818008789},
{-0.5974084777214123,-0.008612753493741026,0.8018908474498515},
{-0.8844595552854595,-0.18579960593037556,0.4280301408783786},
{-0.885101754256045,-0.19915199709183853,0.4206344810725863},
{-0.3170181074997714,-0.02090255501930376,0.9481891175872713},
{-0.408033302823197,0.03873011173468525,0.912145165109267},
{0.4131815601794545,-0.5122629874556793,0.752906122973279},
{0.34981467387084425,-0.6722062208984775,0.6525093796490761},
{0.4390720052947546,-0.476498871635053,0.7616853677844706},
{0.44459251948762996,-0.431059691624492,0.7851910811211747},
{0.5124818986792022,-0.4015716920368794,0.7590141498554538},
{0.3599889495785072,-0.43402347991113926,0.8258520297651317},
{-0.3279985950563525,-0.31323439119481766,0.8912357363873327},
{-0.5499266178594979,-0.3124176094612046,0.774581146341789},
{-0.7972638534267983,-0.24466120382496137,0.551825373974388},
{0.1855842921323681,-0.4649111397463144,0.8656882248555254},
{0.6557929715860167,-0.4585735552919756,0.5997048213957089},
{0.5298747358128658,-0.41295793098085476,0.7407418656909148},
{0.29697411951807895,-0.3730132672168652,0.8790150594936705},
{0.42904542664649686,-0.3980075284848418,0.8108699212223336},
{0.4855604594491267,-0.389112740534353,0.7828296847804115},
{-0.6453701220707737,-0.07553181881752512,0.7601265354429295},
{-0.7839797577806691,-0.07435768887991083,0.6163170235313981},
{-0.8645888336990947,0.19084487158805868,-0.46482726214302084},
{-0.08134910255245834,-0.3479246472481931,-0.9339864899189549},
{-0.042548408736584234,-0.43363701804540933,-0.900082534823707},
{-0.18331561938053592,-0.6522295856428177,-0.7355215505363039},
{-0.19277905725712033,-0.5531911195859667,-0.8104417439238187},
{-0.30800798821067693,-0.8898717363197297,-0.3365402978808342},
{-0.222887973513571,-0.8381941762738715,-0.49774639538984083},
{-0.14916475536865023,-0.8318999447350653,-0.5345019716573607},
{0.028543943223540095,-0.6193175168577034,-0.7846216009124778},
{0.09965926159804053,-0.30846546547856674,-0.9460005751503666},
{0.2578530062753002,0.32723765511501574,-0.9090804938120806},
{0.05015474657712175,-0.11400032721334567,-0.9922139017324011},
{-0.055403295066606115,-0.047986232812759454,-0.9973102808836387},
{-0.10440331751073635,-0.2789660895226057,-0.954608751368443},
{-0.1805412694792314,-0.23446829366991018,-0.9552117405467483},
{-0.32192855804796233,-0.6579623973659068,-0.6807697754495775},
{-0.3217281229498552,-0.8465767976145084,-0.42402681594909347},
{-0.3481839289901896,-0.9263150785140993,-0.14390388080372524},
{-0.333762284472119,-0.9422970587926545,-0.026057445282776388},
{-0.261131341843055,-0.9605718010408419,-0.0954580397473085},
{-0.17061601057283454,-0.9469081599939769,-0.27249791462143574},
{-0.08728876855821477,-0.9695592922515653,-0.22876942473205245},
{0.02723165872627698,-0.8862888638476195,-0.4623315764499666},
{0.19407671445460128,-0.41490141645745854,-0.8889269056160364},
{0.3014380984501321,0.48229588919611727,-0.8225118528430427},
{0.27382421625158443,0.5630448451653093,-0.7797440611681362},
{0.39702806941876634,0.7761207579832902,-0.4899033385485859},
{0.2644021827737481,0.47018291855547506,-0.842032961850742},
{0.3875488416248639,0.3953389520250712,0.8327742841652501},
{0.24721778021941426,0.116645053374271,0.9619133540328353},
{-0.013942965825324517,0.3792001896239997,0.9252096032214087},
{0.3461220831271775,0.2922724000476737,0.891502298225908},
{0.22834733206719654,0.4769747411466856,0.8487358789669761},
{-0.058756021412336615,0.5685069283029976,0.82057760292326},
{-0.45664000691960793,0.18359052289227257,0.8705023974605712},
{-0.11155074403568112,-0.4290964296795123,0.8963440664953282},
{-0.44325680103152504,-0.8430723734299899,0.30455275651095765},
{-0.5188171177700138,-0.5814238915588029,0.6267176849534669},
{0.1688118710087893,-0.27815381026094843,0.9455860669679034},
{0.6434604899648465,0.26104551628495065,0.7195928267303137},
{0.6765458240994522,0.25340447831470647,0.6914274497470032},
{0.4818079294416509,0.43568609611556275,0.760288593087342},
{0.34612764148892355,0.47654404108899573,0.8081469128196215},
{0.1326780770920266,0.6395591212384197,0.7572058229437374},
{-0.48072568293611506,0.5550536910513748,0.6788359284951341},
{-0.8109755253426343,-0.05451381826138653,0.5825349267758996},
{-0.32449859015661037,-0.49003848389118815,0.8090506469263825},
{-0.26936479534663027,-0.46074550602445713,0.8456690757655355},
{0.07249410573107183,-0.9482221951269294,0.30922366226231746},
{-0.23709717424786508,-0.9704700040911824,0.044417351597519396},
{-0.4125892485732757,-0.9063932251811442,-0.09067211979138398},
{-0.5576975547425806,-0.7589901440434917,0.33601696189178576},
{-0.47146135252663496,-0.5628040327840075,0.6789519966505834},
{-0.27094447195522964,-0.5450434070241689,0.7934209334120116},
{0.8148699672255799,-0.09684194341767152,0.571496784338172},
{0.8329157051778949,0.13440246753368454,0.5368308903079878},
{0.8508913740791401,0.14906560199729835,0.5037492588767709},
{0.7746780214966545,0.26582812014227214,0.5737676999898603},
{0.5461939276127675,0.3924928673164314,0.7400145556302693},
{0.42961157780771125,0.5117949914229387,0.7439756575103537},
{-0.6349287886006693,0.029703805211334783,0.7719994283430874},
{-0.8885702645023369,-0.1491075120439162,0.4338315743399973},
{-0.8655869231022386,-0.3384558240169799,0.3690622355963645},
{-0.8149349867331076,-0.31474504120116165,0.4866379829376133},
{-0.5931501489357494,-0.30775489491667535,0.7439488056797487},
{0.40128438955896956,-0.5336201257083254,0.7444598042442025},
{0.6349905196297668,-0.7708468136970974,0.050815645163188435},
{-0.004083731300684423,-0.3930169768932252,-0.9195221471027077},
{0.248243885643003,-0.13564033242619838,-0.9591541447860056},
{0.13655554290207092,-0.2671415180180726,-0.953932908046326},
{0.12977410683884125,-0.18113967358367555,-0.9748574766847616},
{0.38326548576669023,0.8220472650431321,-0.4211245201304829},
{0.3019011582906884,0.5981617227270417,-0.7423329738648003},
{0.21886739120194518,0.07076555346874121,-0.9731851321874566},
{0.593316518597252,0.5203396848914063,-0.6141841100897587},
{0.33807554490964714,-0.012380089963464895,-0.9410375440472827},
{-0.10323743865153279,-0.3390256995695545,-0.9350955065083166},
{0.3878207444164577,0.10443626217812056,-0.9157991795926265},
{0.1875022180785013,0.69588609969425,-0.6932427096392477},
{-0.03269882854686389,0.1247780107653463,-0.9916457203261182},
{0.04451784196490722,0.20823992153655632,-0.9770641211431501},
{0.22284033210071372,0.586610328909201,-0.7786080582721212},
{0.33106889705158576,0.8825457786227535,-0.3339256414835556},
{0.23375577142805412,0.9380792776663646,0.2556667912284017},
{0.5227839166674592,0.7518139625806967,0.4018367107949966},
{0.7433189028498226,0.4155335161697867,-0.5242221910656868},
{0.38189858521812853,0.17841994492797833,-0.906818501057565},
{-0.1246666343674444,-0.21588086977428092,-0.9684284590722196},
{-0.6078351754880627,0.06437061058381663,0.791449824014424},
{-0.7000017761615753,-0.27367315514973506,0.6596214956480942},
{-0.8606277025542634,-0.08944326011140565,0.5013181233676015},
{-0.7130645669397397,0.15761590427743116,0.6831516303821935},
{-0.9521480140444888,-0.12137031294977353,0.2805056264776343},
{-0.9887481457872259,-0.13155356407479615,0.07120929701619857},
{-0.9555813780934281,-0.10054018714049764,0.2770485528040502},
{-0.8637016371462751,0.08511718084924298,0.4967640763130135},
{-0.5152990691255196,0.07025603589703189,0.8541258448135193},
{-0.4241624827680943,-0.2928956052884734,0.8569121032023674},
{-0.47782070499586116,-0.0025152697536914245,0.8784537821054244},
{-0.499763408661783,0.321258783222588,0.8043813334265645},
{-0.6246578808714849,0.1866728053756982,0.7582583963256275},
{-0.8736612150471452,-0.07218077637768322,0.48115072154560967},
{-0.957659302387543,-0.20826662933023438,0.1987804609563711},
{-0.9845288973281024,-0.14334585596427327,0.10077110649278688},
{-0.9917319735981992,-0.12472660399360493,0.030182226545486062},
{-0.9969641265783414,-0.07111001730420088,0.03171585967431936},
{-0.9867062262036592,-0.052428213825854136,0.15382491854691108},
{-0.9506337755369466,0.13402109129000925,0.2798817105453749},
{-0.7423729194563815,0.334433391187493,0.5805486674833059},
{-0.49452413170485154,0.3798472933145665,0.7817684548017785},
{-0.35863947798311474,0.10148872394071776,0.9279427588730266},
{-0.23244853715065164,-0.6285649900986692,0.7422086841305363},
{0.08041115075026563,0.2204349204291388,0.9720815257427833},
{0.00015831114494596686,0.41992079886361466,0.9075607404572572},
{-0.08393965307232276,0.3307410951577376,0.9399810969460813},
{-0.29796946693453696,0.40662506945968957,0.8636378000421534},
{-0.33084263122236074,0.357054221257785,0.8735304439158728},
{-0.40872997050398474,0.14395520434764952,0.9012306643435066},
{-0.5942767940919376,-0.1395888479205078,0.7920543198165352},
{-0.8419553416911901,-0.2731953524008076,0.46526927904630666},
{-0.9701767527473474,-0.1325878041979036,0.202922503943231},
{-0.9927291390868139,-0.03827888833453434,0.11412091445403721},
{-0.9896613889431986,-0.12916116008777212,0.06235166364901349},
{-0.9970609065246,-0.06706620384356064,-0.03703610376857702},
{-0.9940233254431459,-0.10659133665835187,-0.023577858773347105},
{-0.9958346762520598,-0.08713274869448792,-0.026854825988982544},
{-0.9995446724434889,0.02085568439687055,-0.021805692334261398},
{-0.9776151929279984,0.11313465959105216,0.17739527433268673},
{0.492171730592074,0.2694730990235135,-0.8277386281361204},
{-0.28433304999104936,0.0006207372976015725,-0.9587253680632399},
{-0.3944599416941713,-0.062351668967712714,-0.91679530091268},
{-0.377196950541862,-0.0037197256288077954,-0.9261255984709452},
{-0.523895556878883,-0.1158188387703627,-0.8438716976344507},
{-0.6148867666420851,-0.09672315922910625,-0.7826614176495369},
{-0.0200433638527366,0.11621095262994258,-0.9930222948425217},
{0.4107014657510234,0.23971261915496261,-0.8796943595634956},
{0.4660932301392727,0.33690177966581114,-0.8180796365124536},
{0.02375405116645007,0.17524665274081686,-0.9842379568764462},
{-0.3664212303114389,-0.04487030590899314,-0.9293665249107507},
{-0.564371801175505,-0.2556351937689361,-0.7849427480680579},
{-0.6919312717869637,-0.2690300703631714,-0.6699656232700767},
{-0.7375511761270597,-0.2068035380329049,-0.6428456729656534},
{-0.61660593907677,-0.05698581584864053,-0.7852068088645942},
{-0.6951391320752174,-0.05611525345581001,-0.7166817043760106},
{-0.5619330638739669,0.0004618655708102931,-0.827182578639934},
{-0.2714465749363088,0.04672811229534088,-0.961318490655756},
{-0.03830467485517077,0.16089225318965766,-0.986228388735487},
{-0.34366954297564506,0.13183184013229432,-0.9297911653474905},
{0.15101524433384494,0.3288807547556846,-0.932218775358081},
{0.6433077472382797,0.44835789205693755,-0.6205887067724237},
{0.7139314109636741,0.39157727027797196,-0.5804904666237592},
{0.27773605396044637,0.33701799808194804,-0.8996007743990198},
{-0.21825714196128265,0.04529527092968763,-0.9748395552162924},
{-0.33089356258474234,-0.13789891263757004,-0.933538076423963},
{-0.4903775555747784,-0.42025564484037964,-0.7634887333604221},
{-0.6107057214155136,-0.33129166551592987,-0.719224828680183},
{-0.17307215209728538,0.12925261780375263,-0.976391207948582},
{-0.6533288271329697,-0.15349769389418041,-0.7413500533528183},
{-0.0499122041189858,0.21699054730020748,-0.974896853140034},
{0.3581202611802038,0.32979565644442566,-0.8734899561658468},
{0.358529687193627,0.2744498070819529,-0.8922632833382302},
{-0.5144677682735612,0.0615438070833183,-0.8552983545040366},
{-0.6650259070920869,0.043434453497816446,-0.7455561623014682},
{-0.4858064878230021,0.07687030982278223,-0.8706796264165304},
{-0.5460663779669017,0.06738126038019276,-0.8350277100813395},
{-0.5070506098504753,0.08981576554002248,-0.8572238956717905},
{-0.36657443352729063,0.12188942122854837,-0.9223698573114342},
{-0.4211115810684196,0.08800806613562277,-0.9027289829096681},
{-0.3184217391692502,0.1672394406982543,-0.9330801495580994},
{0.1353186012929249,0.41695510736193625,-0.8987977050420872},
{0.576594575338698,0.5201587900039119,-0.6300583535448546},
{0.6424067090880913,0.5759714533753159,-0.5055398154600037},
{-0.07919179463279218,0.1797146911250702,-0.9805260269144609},
{-0.046066807186618576,0.21123247746335366,-0.9763496759564806},
{-0.14376712686374607,-0.00821843855261986,-0.9895774201653453},
{-0.22320585422726866,-0.30691648715262343,-0.925192637536945},
{-0.35311759997400105,-0.4686396003340466,-0.8097437159912675},
{-0.4312591408572123,-0.2769787144214782,-0.8586607858662957},
{0.024833289281831837,0.24780075788358022,-0.9684926908014165},
{0.5881897989250224,0.587949853999329,-0.5552906712909099},
{0.6067473157236424,0.4779530534162006,-0.6351524018629585},
{-0.09585587953550448,-0.7833970027958869,0.6140853249906694},
{-0.7214381068403282,-0.25307440230684375,0.64457769500323},
{-0.5892639993673852,0.47732730660972333,0.651863928603402},
{-0.06163351544385867,-0.5241823860205433,0.8493727897453753},
{-0.20116288738067664,0.3062016143215361,0.9304698082837264},
{-0.5128580972534807,0.6702925267357891,0.5363622849191496},
{-0.6057966912403604,0.6226836152943247,0.4952529496390919},
{-0.6973337748352485,0.5987149344706852,0.39403811200921424},
{-0.7906995091828473,0.5453248424078913,0.2782356958242654},
{-0.8525692112298503,0.18951025977609448,0.4870437367449746},
{-0.11957321438568898,-0.9111849502483783,0.39426416631788164},
{-0.22165439703340525,-0.8856943693161378,0.40793971667079276},
{-0.41260255231600285,-0.5512694731670534,0.7251628105304625},
{-0.170832613889884,-0.6341743664490007,0.7540816208942892},
{-0.36371638391096595,0.12690932724410922,0.9228241515766579},
{0.14211088783227796,-0.6603721519535262,0.737369050397283},
{0.09557481370083665,-0.6145947649872483,0.783031755317956},
{-0.02481193263782801,0.6753605326710527,0.7370702265788843},
{-0.03644089496633682,0.8037734009592777,0.5938184748594543},
{-0.33843320057335746,0.7578476503180616,0.557790200395334},
{-0.4518371547566989,0.6900615592115414,0.5653832594620284},
{-0.5577477803116164,0.6365308917295923,0.532677986621744},
{-0.6155130485110176,0.7029028335354255,0.3564706070920064},
{-0.49686551758325037,0.8283252190470994,-0.2588474240306504},
{-0.5411123068472442,0.8271762331062856,0.15158149874753818},
{-0.691666576451764,0.6683004552552839,0.2738098766025005},
{-0.8212478605404768,0.5705019648107928,-0.008914017316260837},
{-0.916275019842417,0.21460116442339536,0.33821062703720756},
{-0.29562561315517266,-0.14726375666663408,0.943884994487707},
{-0.3765780548624213,-0.4193632044410765,0.8260287351883997},
{0.17275189013823045,-0.6267647459199518,0.7598175687134163},
{-0.43515448724948835,-0.6560608067187615,0.6166237021994555},
{-0.6050360408441392,-0.01185991360774355,0.7961097485453033},
{-0.3941354105935897,0.8424807219688578,0.36726490606516504},
{-0.07879538816205098,0.47633069456906185,0.8757284717398122},
{-0.14810141174073743,0.5280642736800442,0.8361902263858195},
{-0.5045879001733509,0.14307182235502028,0.8514232229899897},
{0.037586338130364216,-0.753366543654221,0.6565257939246885},
{0.16732214439261847,-0.87280117276903,0.4584990870316557},
{-0.7108008755343632,0.12661833691174737,0.6919031088940747},
{-0.7317599014869147,0.10662455330001167,0.6731705959186228},
{-0.3381441558358657,0.36775531765090513,0.866264714861186},
{-0.6314204237343968,-0.04848269801132076,0.7739235598459436},
{-0.5009938643887545,-0.04390835980548534,0.8643362793404048},
{-0.24687883915824513,0.0029165267246664055,0.9690419664017351},
{0.029033396771912558,0.2549409539841938,0.9665206525747465},
{-0.40979318016045857,-0.6099592728257338,0.6782471783854909},
{-0.023053895339925874,-0.934047671517376,0.35640351463281555},
{0.4061932464909564,-0.9121085440699223,0.055362896779195536},
{0.20731605000167483,-0.9715287686080668,0.11468176480415913},
{0.003563846179368516,-0.9967823104583222,0.08007699143810895},
{-0.2758938125965414,-0.29327555209893275,0.9153535135192363},
{-0.4072565132523158,0.5081488802278408,0.7588984437569744},
{-0.7329017740527898,0.3259388646932426,0.5971757246177658},
{-0.8395703546653829,0.07150686842366215,0.5385242681024546},
{-0.793289291934079,0.018995179242053305,0.6085485046142909},
{-0.4277480146520467,-0.029271215329353766,0.9034239491591836},
{-0.6841642673929947,-0.19588856368314275,0.7025289501798215},
{-0.6485875300664359,-0.3221361604760274,0.6896104044720347},
{-0.510727396545199,-0.4176954792328138,0.7514572596273409},
{-0.11037562889429431,0.18344217937939883,0.9768143054699423},
{-0.19207401538448096,-0.12009018308739058,0.9740050926664188},
{-0.5487645145524458,-0.46851505766510204,0.6923518962991901},
{-0.4997552592037733,-0.4722109567496302,0.7261277389163481},
{-0.070057144258995,-0.8405091913239358,0.5372488211604172},
{-0.4186355484211621,-0.705932549851339,0.5713173484662438},
{-0.4239620824856565,-0.9046872845239894,0.04239186048093999},
{-0.5680413691923469,-0.8215053033542205,0.0495786188489949},
{-0.5188708555007288,-0.7058970415362252,0.48216428949305906},
{-0.503759903374084,-0.14379769041020693,0.8517911621901368},
{0.28064222706208125,0.4896602107681951,0.8255136694083763},
{-0.02448499488048712,0.7040057037550622,0.7097721142071178},
{-0.5271020928386775,0.2928066918139773,0.7977641411808636},
{0.3067032678569826,0.106474163482795,0.9458310409351594},
{0.3598939884568823,-0.30009583481288105,0.8834131575885416},
{0.7538569628463204,-0.32169864114404717,0.5728958577736404},
{0.39751215712797033,-0.08156781936148759,0.9139643186580533},
{-0.4800354874311273,-0.32187547051004284,0.8160650171957493},
{-0.23332768263541465,-0.875460341540742,0.42323443019838825},
{-0.5002891186194466,-0.03850754982129225,0.8650017146790739},
{-0.5469792958941437,-0.004558294648161561,0.8371337239730863},
{-0.4920788775934763,0.23435302002400601,0.8384134065197029},
{-0.3420287133441571,0.03421337389721776,0.9390664536094928},
{-0.40023102340433137,-0.3970257481876633,0.8259453269924999},
{-0.026751020373322353,-0.8505655211815302,0.5251882301481806},
{0.003932655100640323,-0.9994278810700657,0.03359233191753343},
{-0.21245175485873202,-0.9412097520910233,0.2626565331877345},
{-0.5820186287719905,-0.23267307478886323,0.7791774868607716},
{-0.3525773274871818,-0.10540316308162581,0.9298276191608769},
{-0.3472606759592281,0.2744783168679628,0.8967004385532942},
{-0.196688331371264,0.5851263104029456,0.7867279715229551},
{-0.29979719015659206,0.765019016312723,0.5699715338980764},
{-0.43937880149877473,0.3459896413254021,0.8289978509556101},
{0.10899854241851048,0.4186890994742461,0.9015646153948619},
{0.1713442605427831,0.004975897031287547,0.9851986524695315},
{0.42041087241744624,0.42905873811071565,0.7994768899749649},
{0.5552510905643431,0.3532473799310503,0.7529359302085111},
{0.3309027639811158,-0.8908902477167007,0.3111557926713458},
{0.15097762471494808,-0.8660002245551679,0.47670679448255304},
{0.1634772133006628,-0.9864877442161292,-0.010822718827657923},
{0.29246680494873784,-0.8912699629879627,0.34655594220632335},
{0.48857370452961923,0.23456911306488423,0.8404005392895448},
{0.6064746604144567,0.3525024350718629,0.7126924438659193},
{0.509088267127052,0.4047067828993396,0.7596325138834186},
{0.3314938938398471,0.46809585087836186,0.8191447202645932},
{0.2458143188787792,0.341827413638955,0.9070442877385121},
{-0.15384535610677622,-0.9800922596562108,0.12550206757803498},
{-0.018673476232424976,-0.9962516371025092,0.08446287264808967},
{0.17540952037739002,-0.9395087625277123,0.2942019464494086},
{0.3829926249634418,-0.905299473410969,0.1837104043472627},
{0.2549988203076835,-0.9644913981488701,0.06878913096214759},
{-0.06596441591809604,-0.16749371243407363,0.9836638410186869},
{0.2537862801054385,0.301405867327771,0.9191012061631939},
{0.2687509471972084,0.3522153068225463,0.8965028198619919},
{0.491249449066836,0.24446407795609995,0.8360091467086972},
{0.6787198633996304,0.26088769584233573,0.6864961450619107},
{0.6111052923470089,0.3324148910492494,0.7183666625576332},
{0.5098338980487973,0.32334382768228864,0.7971939321771931},
{0.524813287481639,0.14271513797146315,0.8391682803088429},
{0.4272186501623236,0.2236965574156774,0.8760388548197258},
{0.5091619090836436,0.4326731464519028,0.7440081307873656},
{0.1963901790861931,0.535491249063752,0.8213890793860336},
{-0.4615677265316441,0.44920903105986504,0.7649617508337699},
{-0.4326463057820374,0.7279976529439104,0.5318238349315622},
{0.2832361965255091,0.6741700275268319,0.6821085184647924},
{0.4013920374926908,0.6159289456455338,0.6778760699076545},
{0.4279918173845627,0.5258893963852719,0.7350260859462021},
{0.4093521014735863,0.5072826103459617,0.7583503215926963},
{0.3659593258949697,0.32710284058265116,0.8712505400131813},
{0.3179649763844075,0.13910615979452978,0.9378420709800143},
{0.0967587219245563,0.20470842496090352,0.9740288550559231},
{-0.9615515732876002,0.19293691181470296,0.1954326481618318},
{-0.858640584914943,0.4053521362569895,0.3137291691392742},
{-0.8560196327620317,0.5108298967099856,0.0792666698759427},
{-0.6848849188160923,0.7157282092687867,0.13662275957969272},
{-0.30921508001107173,0.8382122058385512,0.4492063359715854},
{0.16813613106682307,0.7917373779696505,0.5872666904870587},
{-0.04430834529003833,0.8307099812496921,0.5549393638856367},
{0.2609768037550153,0.6266012020212727,0.7343446340290862},
{-0.25073683837265387,0.46190747614194105,0.8507482126734489},
{0.03263814864535449,0.6274093509640675,0.7780053069072546},
{0.1796687294438409,0.743934268221134,0.6436466050763585},
{0.03889208444763992,0.6962755332634305,0.7167201598574182},
{-0.5312797087736755,0.3125315046523409,0.7874426516547745},
{0.1186802276159625,-0.006162135117728776,0.9929134059241089},
{0.005598874310758925,0.05536003295055191,0.9984507596061841},
{-0.9447896638013401,0.10627314133382337,0.309965337747936},
{-0.9679484409129351,0.16995841294394465,0.18490525574951538},
{-0.9560887999566546,0.24916780221594537,0.1543036387656483},
{-0.9538353165997625,0.3002923439277751,0.004764135324852287},
{-0.8886768924477033,0.45148162862939306,-0.08011067244533557},
{-0.7321498829905216,0.6807007881199727,0.024555771008324977},
{-0.54964703501946,0.8162007158988751,0.17805765431589973},
{-0.34011855921794354,0.8665541223936404,0.36524419042347267},
{-0.6034863309593465,0.7025182127678689,0.3771901497582691},
{-0.71219223444593,0.19012870925828965,0.6757464725107266},
{-0.03844414522283968,0.5764275401104995,0.8162434310303781},
{-0.868231986553172,-0.4951203145121651,0.03207945889984907},
{-0.9085554398516338,-0.35947251556120974,-0.21285329048924778},
{-0.9824293517156683,0.042635150998373214,0.1816997875256815},
{-0.562465234200961,0.6929982118443893,0.4509837454894991},
{0.20915969556759698,0.3933445909708361,0.8952833375552433},
{0.014828264655894662,0.29549981337589415,0.9552277125702051},
{-0.14313242302820037,0.047948083543546606,0.9885413955735881},
{0.10195944119944865,0.2852089755113964,0.9530268163268207},
{0.3588906287981068,0.41633059652965776,0.8353839542115703},
{0.31825370285333476,0.37353531113103144,0.8713127750460135},
{0.05442371937192663,0.20221956417256484,0.9778268285517552},
{0.2869686648871559,0.40948922138868105,0.8660066760362619},
{0.06304906010257427,0.3574074735180856,0.9318179617788019},
{-0.2883933296433369,0.0792656974135628,0.9542254642540049},
{-0.10929140574609303,0.07412244067104479,0.9912422773565553},
{0.46542673695075837,0.2733065324800264,0.8418322230914626},
{0.40106046596080297,0.27528581471088626,0.8737094613555854},
{0.07221886288785831,0.14332535116191186,0.9870371216714696},
{-0.08926653990055866,0.06350074368648986,0.9939814587835352},
{-0.09423250482564365,0.01994199047321206,0.995350466946317},
{0.2899182611695951,0.05961329484205523,0.9551929945924398},
{0.16501363574158953,0.05594815822827812,0.9847031550727384},
{0.27011985162560986,-0.015570930633959382,0.9627007904208612},
{0.6604176315239987,0.04149943145680549,0.7497508580595248},
{0.5887322866892709,-0.03747620586284056,0.8074588711530439},
{0.7154377423763134,-0.1289570578906057,0.6866723483610526},
{0.2642680414269465,-0.2798873948753561,0.9229439032087768},
{-0.7084321037945542,-0.31083552427751665,0.6336444043470623},
{-0.03166703824046852,-0.5557026551921839,0.8307778028458833},
{-0.4605739812012918,0.008253396107390827,0.8875829478381648},
{-0.41655588042127684,0.2533775221177961,0.8730870688378684},
{-0.11391049065149052,0.2653373068883413,0.9574030048484176},
{-0.18198970555502356,0.1872174809672311,0.9653130900864654},
{-0.35190538518225317,0.08511313864683845,-0.9321579015968346},
{-0.3954086677366175,0.0038385463409365815,-0.9184972787334439},
{-0.521254884114164,-0.07818439048890019,-0.8498120656186335},
{-0.6520614363366353,-0.054345198885942324,-0.7562158968182642},
{-0.46233846181291305,-0.03751680361392292,-0.8859094966050787},
{-0.3482357048785489,-0.021003699678791427,-0.937171669678263},
{-0.3866967526732891,-0.042248570374803576,-0.921238666021579},
{-0.5363158707844444,-0.2103613590799508,-0.8173820314582155},
{-0.5686624678423524,-0.0425165020042422,-0.8214714509493125},
{-0.45341461960943524,0.24428300110253243,-0.8571703436871642},
{-0.7615390196525201,0.09985187003265339,0.6403810784194522},
{-0.89874140302892,0.17790402281443723,0.400766826406638},
{-0.6515481565585883,-0.008226288242636165,-0.7585626723395071},
{-0.9563245672489291,0.027950506955380778,-0.29096750890277384},
{-0.5464849691496726,-0.03321730674844642,-0.8368098882218475},
{-0.6962362644150014,-0.01363556364617538,-0.7176831721013774},
{-0.8005347724265545,0.06003453668054363,-0.5962716935605086},
{-0.7437096716580076,0.21727233527967288,0.6322093455529236},
{-0.8452242143543436,0.19309544547967253,0.49830731120874555},
{-0.9128088359626423,0.13936942240961636,0.38387002108231333},
{-0.9419170118697091,0.07746256675041499,0.3267902897928208},
{-0.8451619851973561,-0.002985411560062632,-0.5345019233782802},
{-0.8639238847464279,0.0038382362795671464,-0.5036077732788713},
{-0.6182224599582122,-0.0008120516788956682,-0.7860027548140576},
{-0.548259214272228,0.005941000628672545,-0.8362873540100492},
{-0.501321993725419,-0.015947514337687617,-0.8651138279981543},
{-0.5186092312444295,-0.13093730815058877,-0.8449259651604628},
{-0.6113517816374547,-0.09917829085783868,-0.7851195232009123},
{-0.7714991486918238,-0.06167450846424482,-0.633234015647837},
{-0.8247574851415983,-0.024143919839013414,-0.5649709389320068},
{-0.888334473622904,0.1049456179552903,-0.44704393547513926},
{-0.7808645078183429,0.26674128348678694,0.5648891113426056},
{-0.7166822585202445,0.24931361027584717,0.6513134913799531},
{-0.94297121627529,0.24078169200454266,0.22984660552579336},
{-0.9764764014652964,0.17784092368266927,-0.12192802485515991},
{-0.9304245785256603,0.11342042076010857,-0.3484909063805645},
{-0.9714153846755886,0.04782831462379076,-0.23251796217889403},
{0.1686673316154723,0.2460057575759042,-0.954480224250467},
{0.8617054005555698,0.20583460985052812,-0.4637843421689073},
{-0.24727490071687894,0.11680517310100588,-0.9618792413875566},
{0.09089584582906196,0.13864929808885376,-0.9861614053239396},
{0.7568720125280762,0.1525104512585937,-0.6355197234615144},
{0.5555303922774698,0.21439549391314594,-0.8033807039292011},
{0.6735268184070454,0.27645770595263114,-0.6855164197201198},
{0.8931861720215977,0.24562447456747566,-0.3766790140197043},
{0.870664310980915,0.3287041291521572,-0.3659197358198252},
{-0.03207239230543931,0.25572414588072145,-0.9662176374220156},
{0.8570809042508408,0.32122663598063567,-0.40277260570342327},
{0.9418999033282025,0.0785254115674458,-0.3265858720895412},
{0.09142322314339606,0.12816265809392027,-0.9875303171753127},
{-0.24877417198648388,0.09432711917383434,-0.9639573672838466},
{-0.37778095917909577,0.11921432436564341,-0.9181881570504848},
{-0.472592867362503,0.1276049651373312,-0.871993666599929},
{-0.4320648691571299,0.2349897100534307,-0.8706892585815199},
{-0.24927618327389045,0.24289450414772032,-0.9374772766884725},
{-0.07099338568511275,0.49563526276528397,-0.8656244136417092},
{0.4616645751288835,0.6183234910813316,-0.6360360685118904},
{0.659364066900359,0.6143028076807988,-0.4334409853210774},
{0.5774710106051887,0.6758355857012598,-0.4580103634312842},
{-0.050483316227049796,-0.23792368568336242,-0.969971007078853},
{-0.34780594268421144,-0.2867856172154439,-0.8926281622220441},
{-0.6240496724676309,-0.37617581788329474,-0.6848749961364314},
{-0.6512131902616948,-0.39133803839186415,-0.6502122119253019},
{0.41910445515841327,-0.35936773911359854,-0.8337903116196241},
{0.9287550100546136,0.08936706643525548,-0.3597605575034754},
{0.9670339210588578,0.04368749242151322,-0.25087207602172673},
{0.9917965822182643,-0.06321925105004819,-0.11109845092007702},
{0.9140581151622971,-0.07912982496896372,-0.3977891814847785},
{0.8364366461229974,-0.2226590336633534,-0.500796058042207},
{-0.17324892515291987,-0.9822009266395975,-0.07256824127449979},
{-0.4190654587155393,-0.8710498147305396,-0.2562349733534194},
{-0.16757004067693385,-0.7789548047695471,-0.6042761732800388},
{0.3991388958097435,-0.8905386091632378,-0.21824098478834056},
{0.20126421187719576,-0.9547480076007415,0.21897250740644508},
{0.3439820086687044,-0.9197864448176235,0.18886310820803523},
{0.38384308969779757,-0.8855280835463374,-0.26173363509873787},
{0.6168898956433548,-0.5461661386366137,-0.5667004549670857},
{0.5451254111492424,-0.4965111586720979,-0.675510884763125},
{0.3729614495632129,-0.4756534914661403,-0.7966514377039543},
{0.5319191057464291,-0.07941188058637838,-0.843063353588361},
{0.6401149984279274,0.1263478112972519,-0.7578185926513076},
{0.32800138403040996,-0.00530534326936672,-0.9446623446538607},
{-0.1886854212157121,-0.17587934594242774,-0.966159545567663},
{-0.4975557292967799,-0.22750848448064165,-0.8370652219112147},
{-0.7296058301098645,-0.22029910986085138,-0.6474130326647838},
{0.47617430866498933,-0.30478582155133727,0.8248415791827518},
{0.47291085506968283,-0.2347267898517277,0.8492694844883832},
{0.4519069528821684,-0.2067021136754011,0.8677870373189929},
{-0.12344474246476232,-0.24709943471900966,0.9610948261848851},
{-0.37114230400888887,-0.14799474825754577,0.9167065750081425},
{0.23256104318610357,-0.16459689848254055,0.9585526705414364},
{-0.009613379026832581,-0.3480015617773554,0.9374446628704054},
{-0.07586071589527392,-0.2639134533122738,0.9615585478506479},
{-0.28255401528499224,-0.1820101450016353,0.9418256396822143},
{-0.3074603282299988,-0.1367135576154899,0.9416886692154778},
{-0.3258348987931287,0.05188416118139903,0.9440019346097624},
{-0.38813932102996485,0.6507985503207206,0.6525405078390507},
{-0.1546860359055496,-0.25427044110359254,0.9546825509439312},
{-0.05091178652451142,-0.209728048017199,0.9764333750275941},
{-0.09472421968483408,-0.43221907541753596,0.8967797907236256},
{-0.05707673810092117,-0.06541326860478218,0.9962245481106142},
{-0.010065269644640206,0.6047169800444173,0.7963768356707397},
{-0.21531530026621792,0.7951272189833993,0.5669321186023896},
{-0.40883735385830816,0.6009163376216669,0.6868417381533386},
{-0.6673041829046255,0.6307087440902207,0.3961206982803683},
{-0.7441727133708118,0.38869075362807826,0.5432554378175704},
{-0.10857039497754072,-0.13498588302618664,0.9848813536249234},
{0.14311169155274286,-0.11583872481761892,0.9829040815733447},
{-0.02907756866218313,-0.24271252636705654,0.9696623765750721},
{-0.08906016077070601,-0.4488091499637492,0.8891786292260475},
{-0.023843655147694924,-0.3043301411508881,0.9522681582917063},
{-0.0062462439028999235,-0.3408408758420438,0.9401002509266414},
{-0.1934257845009349,0.5454454153588468,0.8155217745432755},
{-0.27485923301205534,0.3917189461570521,0.8780709932856416},
{0.09719812291762057,0.5527743010052419,0.8276430976269044},
{0.019188913331795485,0.3892431278818044,0.9209351622138956},
{0.08092676445498077,0.35422250829187857,0.9316529790722822},
{0.04411166236658735,0.3636480825393619,0.9304913934629925},
{-0.46313770750706845,0.29706716110649684,0.8350177038106581},
{-0.8474403990053188,0.3635210144318242,0.38690727855671514},
{-0.8248668563569175,0.10716022523745568,0.5550777922155724},
{-0.7210306730148298,-0.36109600702599065,0.5913750436750502},
{-0.15458374818635792,-0.2234344547615215,0.9623829327362773},
{0.11722699941895152,-0.16667884174730963,0.9790178723195019},
{0.16303480741858795,-0.08392114693622241,0.983044705324683},
{0.12242823824982801,0.07847677335172783,0.9893698613376823},
{-0.0720911173246191,-0.027516466850935964,0.997018412495441},
{-0.14269850224391914,-0.33000707665144374,0.9331304661285637},
{-0.11284467383611756,-0.599098933579528,0.7926831317561215},
{-0.0905520078703688,-0.8394848564480017,0.5357849472177456},
{-0.05771610841709671,-0.563869565762818,0.8238446234792318},
{-0.28599100189510707,0.11293245243057069,0.9515542065605352},
{-0.47344287003758134,0.6329054225794699,0.6126031136715517},
{-0.38935362207613017,0.28780651866964463,0.8749692364806076},
{-0.5390224309247377,-0.12153128791096897,0.833477633184411},
{-0.5139549867531863,-0.25126312167520576,0.8201933401811812},
{0.1087800482862161,0.1431429128000594,0.9837057525550834},
{0.3849561256782499,0.5669278954454688,-0.7282867173500853},
{0.5618379157579448,0.40390324849248016,-0.721942049110585},
{0.6922934351172236,0.2219879613099977,-0.6866230004354831},
{0.3716277446923095,0.5911611886836818,-0.7158360624954601},
{0.20211847772925,0.6948797204239099,-0.6901378812266427},
{0.48419404318479253,0.3693636067744689,-0.7931750465911788},
{0.11319627288146833,0.737219766275087,-0.6661033103198408},
{0.31582790887272716,0.6972169974623592,-0.643538025626033},
{0.5052843100756568,0.5949109057260054,-0.625115013609201},
{0.15117499866230366,0.8700710548247125,-0.4691721212259576},
{0.23477778028706336,0.9293393293799401,-0.2849698312999509},
{0.6604432647337602,0.6594336420222735,0.3591127480848492},
{-0.7555110523259856,-0.43178511046775486,0.49271154663923833},
{-0.34328077448938327,-0.5993345243714927,0.7231572704207334},
{0.46714434325746407,-0.8274328716321878,-0.31165847574719324},
{-0.3922505281176236,-0.9170463990040365,0.07187089303170488},
{-0.1827710669181611,0.024400464083218568,-0.9828526616182716},
{-0.29445634376149216,0.06457908292536162,-0.9534804684245678},
{-0.22769024636623733,-0.018551250611708144,-0.9735568821647884},
{-0.11154153942067906,-0.00262525689787673,-0.9937563046390626},
{-0.13516291176134848,-0.04751528587953074,-0.9896834266026587},
{-0.2667338832135609,-0.046074782957202014,-0.9626682449947443},
{-0.34841887903332996,-0.022219912674815857,-0.9370755360235808},
{-0.47033244695793847,-0.008551755053204305,-0.8824478776812079},
{-0.12427596065399478,0.11688381344822814,-0.9853393627361725},
{0.013990894993769314,0.08811918386910955,-0.9960116787927314},
{-0.008453347048616045,-0.02007722527916141,-0.9997626948175079},
{-0.031210875160177814,-0.06374287221592383,-0.9974781839786774},
{-0.07121142707620302,-0.12876515451247939,-0.9891149921203033},
{-0.17663585493982645,-0.13476471012548177,-0.9750067936452912},
{-0.3353307044635261,-0.4199000411683629,-0.8433488448268619},
{-0.39763623789871033,-0.27631527746790396,-0.8749487354968835},
{-0.5754441453585126,-0.0297510430556344,-0.8172997681449033},
{-0.5852083732774741,0.03220633866607674,-0.8102431188203072},
{0.4916614981921321,-0.5121063372083641,0.7042840837236785},
{0.8998090493794008,-0.10070485440273937,0.42450230500512276},
{0.4932773147155264,-0.018237049475547728,0.8696809189659538},
{-0.06032862728781074,-0.3446201368591548,0.9368016961986917},
{-0.3301596741818766,0.12946978199083822,0.935003831593947},
{0.05907333538902893,-0.257222371992498,0.9645449664958955},
{0.9494119146897662,-0.1387970498735176,0.28169557183512917},
{0.9480492390976781,0.21022169918838426,-0.23876657520821834},
{0.8813103267087977,-0.4724401503463991,-0.009613135654097993},
{0.7366624289938062,-0.4078520036957525,0.5394304485198301},
{-0.1725337698891642,-0.3668626426652267,0.9141356024488485},
{-0.6548789131787945,-0.22201036324914597,0.7223884050036674},
{-0.9395345903330892,0.14394708934000147,0.3107313776208898},
{-0.8413634796923435,-0.10324897531643729,0.5305159226037398},
{-0.30835013661051225,-0.4364816300068853,0.8452242187247186},
{0.5163330698414337,-0.44123372028231145,0.7339706840698422},
{0.9475271233889997,-0.22815762597766054,0.22391169721657023},
{0.8874180125751948,-0.1835826987966899,-0.42283172026187343},
{0.7753974646133747,0.16489597640704465,-0.6095638513198743},
{0.6376662259837357,0.3983092931961277,-0.6593417104910476},
{0.8533925054358693,-0.10481248171396504,-0.5106227328888222},
{0.8947324326254843,-0.22439568133120213,-0.3861352770830306},
{0.9367515391869715,0.05751654436865495,-0.34523673175768577},
{0.9661359279759876,-0.1647289127120338,0.19860955160990754},
{0.5226507371449012,-0.5833703405734991,0.6217035086768057},
{0.0662298825261164,-0.44808866240490136,0.8915324746102989},
{-0.6461539520177272,0.0076027780344870045,0.7631692263567964},
{-0.9205580717290446,0.08966416462277933,0.38017518877091666},
{-0.8716191067841413,0.4180416747268763,-0.25597126963853634},
{-0.8064687525993854,0.3373787079934573,-0.4855756979848321},
{-0.8319698170103775,0.06800695879256519,-0.5506371556111204},
{-0.9757241989684549,-0.1834319712441188,-0.11964530694040507},
{-0.8001726300916242,-0.11057978244695775,0.5894878062913909},
{-0.4583926598778968,0.07367860858322946,0.8856904831865962},
{0.2682321899965292,-0.05815894884369037,0.9615971240176745},
{0.7951599000541371,0.08508970743443987,0.6004002623538868},
{0.9747672250445512,0.21458385045653974,-0.06150307392473098},
{0.6765191364538301,0.2888009055543565,-0.6774333140337488},
{0.317438715625643,-0.05036516896617213,-0.9469403421424979},
{-0.30223505076206936,0.299615834665625,-0.9049222760593698},
{-0.03634600006777763,0.3834668921338406,-0.9228391576630711},
{0.5181831433267802,0.03880232629000815,-0.8543890269932435},
{0.3050669391740191,0.2977726169411928,-0.9045803619485607},
{0.3223424243845844,0.5843062234015922,-0.7447694936932079},
{0.7407691885461384,0.18118017154274327,-0.646865329678781},
{0.80961844542715,-0.30643426775807936,-0.5006156333632565},
{0.8233466994861197,-0.36097603030464354,-0.4379457934388846},
{0.7482208180707526,-0.6633698246451941,-0.01029966774892422},
{0.1837326166345787,-0.8852685905871919,0.4272491639598348},
{-0.2660788774097497,-0.7827106198201416,0.5626420857144774},
{-0.7312604420723993,-0.3090103857415412,0.6080877793246159},
{-0.9196203734809411,0.2655785061637567,0.2894243005391947},
{-0.8066008702976121,0.5910895622371517,-0.002857525052748907},
{-0.5087120618397827,0.8061019289669432,-0.3023437088058729},
{-0.5217384538315668,0.4978832218480259,-0.692749076647292},
{-0.5213922885128691,0.07551206649978795,-0.8499694166805325},
{-0.90712211802467,0.13204744663605525,-0.3996159841989992},
{-0.9460750610047954,-0.005264361206396791,0.32390471661564474},
{-0.47419283927640615,-0.22804135848763907,0.8503753818156383},
{0.39870215618732696,-0.14585151893237033,0.905408153860289},
{0.9754882856935568,-0.11049638038796566,0.1902975417492394},
{0.5926542138401055,0.15678744925485366,-0.7900497949963173},
{0.12905764784249119,0.3579062018978761,-0.9247958013401661},
{-0.937396325702398,0.18371618508274315,-0.2958656652913399},
{-0.9268294219359774,0.2691589780910059,-0.261802725629103},
{-0.5358840775884053,0.3221551411905306,-0.7804129165971905},
{-0.9567235552370021,0.10621151475519897,-0.2709227804893434},
{-0.9040116089314344,0.24567766584830766,-0.34986496740960893},
{-0.7575720855122225,0.3477137937653268,-0.5524306769885119},
{-0.8259269155852034,0.3280671543406394,-0.4584939174675573},
{-0.9274338324604494,0.07978065674362397,0.36537861625617735},
{-0.9533057976670721,0.12273179008808063,0.27594376933738274},
{-0.9980526632855032,0.03239118554803205,0.05330752674347902},
{-0.9513775793933448,0.028637852598920165,-0.3066929650744902},
{-0.6634531822548213,0.12468880662656713,-0.737755092464968},
{-0.9678589038491963,0.09321162509971623,0.23358239485479682},
{-0.8596783124979869,0.2967110360035763,-0.4158314083066577},
{-0.47533574688362007,0.3635799825184569,-0.801165104111799},
{-0.612473604734338,0.3600137129987248,-0.7037515257223942},
{-0.980968829630485,0.13207988453186345,0.1423202705008882},
{-0.8890474644422398,0.015045736123385426,0.4575677346506522},
{-0.9086014853320862,0.10105758926059669,0.4052538766071994},
{-0.9368470433541094,0.2056771469434731,0.2828683944590778},
{-0.9749601175333954,0.1448524825077875,0.1687321176616916},
{-0.9991738248655243,0.006689081881190525,0.0400864551586355},
{-0.8384224058174709,-0.05382248330303187,-0.5423569025229963},
{0.6052011567917719,-0.3611316536772506,0.7094473120184722},
{0.8412422185244892,-0.27218319487213954,0.46714862538724267},
{0.7699017734675742,-0.09734756096685959,0.6306938334765037},
{0.3930964340872658,-0.07645781359185419,0.916312935764103},
{0.5365720322734775,0.25209455377961254,0.8053190610786313},
{0.8044637450090963,0.1512354616800631,0.5744265993983547},
{0.9402793426791242,-0.11061496681498584,0.3219302515257516},
{0.8188202383092182,-0.17141806037993845,0.5478588010708735},
{0.3776382127351428,0.17365636040792484,0.9095234184846919},
{0.2776483099473802,-0.34590145887220103,0.8962497401580916},
{0.06601694219597398,-0.1365273298281574,0.988434141232023},
{0.1863040692205779,0.27482627960056116,0.943271599186983},
{0.297191768091059,0.5442814848103539,0.784496474352528},
{0.6607342466369733,0.5235946178520621,0.5378465687140008},
{0.9166983155803197,0.2344252177209194,0.3235877245952081},
{0.9725180949968124,0.2261535359589899,-0.0553455786582527},
{0.9700942561866194,-0.12860288614407261,0.20586022391211017},
{0.6422172737966273,0.6213695154310338,0.4488395019717292},
{0.3464973346300265,0.6758511157327074,0.650511234689411},
{0.3156411855837698,0.555611121649037,0.7691988842056201},
{0.1063197226070828,-0.43082492383049037,0.8961506578646278},
{-0.04278549027056806,0.06062026596780897,0.9972434934238976},
{-0.007039596712714343,0.27762700387030725,0.9606631515781787},
{0.07000610167867408,0.6218676658821518,0.7799870203138253},
{0.3184196461358973,0.7612114299282086,0.5649478629938712},
{0.6026281830623365,0.7097601195752596,0.3648011042191353},
{0.8098940034501637,0.5431064285988271,0.22160124185142369},
{0.7175187757500725,0.6934246720260072,-0.06579536968314294},
{0.7221107596565091,0.5584820978469022,-0.40823252831299783},
{0.7799126928255539,0.17602837565778803,-0.6006248434196458},
{0.967576900345016,-0.10089355652362052,-0.23155006406983744},
{0.8135096889048743,0.5815019415185998,0.0075814291524641635},
{0.5173955301094959,0.7933284207539871,0.3208299896311106},
{0.48875807796200854,0.7254270550005717,0.4846350473295145},
{0.3720219275226312,0.6678369408377189,0.6446654216683745},
{0.4762587453862155,0.579773041423491,0.6610906351489962},
{0.38708191700794153,0.4195248611874993,0.8210764156709571},
{0.6735023570552902,0.5039797405627205,-0.5407393051585037},
{0.763138427275447,0.461608063626451,-0.45225848406701646},
{0.7538871838573357,0.6567322310445157,-0.018891551628932714},
{0.052001136047980366,0.9979738272596057,0.03666226881323633},
{0.2285077830402661,0.8296303359381019,0.5094091663694863},
{0.2666007730414249,0.9472854441064841,-0.1776916295093725},
{0.26714684601175337,0.6169798601369002,-0.740248887099078},
{0.3172379012373607,0.7661750162170976,-0.558870251975577},
{0.6154241963446928,0.7653462138108459,-0.18840974380029266},
{0.6690539812301199,0.7109771485476057,-0.21651388972359709},
{0.6673822576498679,0.37815610956637163,-0.6415597236203281},
{0.4470007397470815,0.8017839371112818,-0.3966520601936838},
{0.0071816442961403675,0.9876777052174062,0.1563367346521034},
{-0.36094223239631124,0.8480536060958443,0.38797652771862584},
{-0.38301810534932074,0.5746229338639429,0.7232604059757533},
{-0.2069791085960121,0.7107817418831844,0.6722714957591958},
{-0.4234297933352418,0.8988839134573133,-0.11276045514159548},
{0.07757383194890974,0.810094792241987,-0.5811443264621742},
{0.38625246341861447,0.4910315580004117,-0.7808309955110263},
{-0.0920844828536313,0.8755549437665181,-0.47426151906262476},
{-0.25173186769775807,0.9607484005415254,-0.11659149901386097},
{0.13696773060580825,0.9903301260606038,-0.022047271701587035},
{0.29265668802071626,0.9440267536165662,0.15220233708097974},
{0.5138567647029131,0.8353770524961973,0.19518300523309035},
{0.7067553469791016,0.6688674824388937,0.2304629481116346},
{0.8278175552704391,0.4641869280085324,-0.3150374438889372},
{0.9050328333983895,0.1893267449111108,-0.38088181123840265},
{0.8102901575949435,0.5858012115440369,0.016334045986842998},
{0.2888656538536389,0.7866214407852538,0.545695283945758},
{-0.23483887698331204,0.5631572871587698,0.792278089926253},
{-0.62577590755401,0.6170740696440543,0.47709968151098125},
{-0.7400761598667162,0.5982960325478311,0.3071304853551002},
{-0.4034676604162969,0.8947823560753467,0.19125475746880435},
{-0.15294715228387348,0.9477247199266596,-0.28004468187806764},
{0.25974637711783444,0.6358647529540093,-0.7267790830265387},
{0.22302229609239543,0.49368388942587776,-0.8405577153099087},
{-0.14359194092297511,0.7405501353787036,-0.6564806558403351},
{-0.4821978724344878,0.8610993820195858,-0.16122365243704373},
{-0.0032173628269709384,0.9861595314646912,0.16576799171667775},
{0.1873091396471407,0.8905280078518731,0.4145782838451891},
{0.4421860855807442,0.8385426083674642,0.318304507776859},
{0.622548755641,0.6954596182548732,0.3588439301794422},
{0.7726582480665461,0.5129085584160862,0.37406422229112973},
{0.8958667746524879,0.4211170877202834,0.14171492689104984},
{0.9095340099403562,0.39324377687191725,-0.1345630585016776},
{0.8662873027077456,0.4656408296048391,-0.18090032330611241},
{0.8601201998565682,0.32982915105601496,-0.38910920435318136},
{0.847107488415054,0.5163198552515607,-0.12578835456490578},
{0.35473330819479726,0.7452431241576306,0.5646033704760797},
{-0.16803496290283929,0.42495280363606625,0.8894826394731312},
{-0.29407711754062776,0.04120449266222112,0.9548931032966176},
{-0.34420543839199036,-0.14086046435838773,0.9282677123341719},
{-0.0499129572056846,0.29154540032448506,0.9552538805221464},
{0.2074157031636639,0.40351496435600115,0.8911534097011008},
{0.13348739918609673,0.30177442302626833,0.9439879829032224},
{-0.09308240196278872,0.22356097892090035,0.970235103028522},
{0.13992879717913817,0.4198096715959087,0.8967607101978403},
{-0.043401652671794404,0.4175165099394055,0.9076322275422877},
{-0.35313551728608955,0.25796715157154126,0.8993043173148628},
{-0.43718052055825163,0.09480405309870518,0.8943631163909176},
{-0.5013250946228344,0.010370020440838127,0.865196863249898},
{-0.19263141799278732,0.0742183525221452,0.9784604094959523},
{0.563301714294299,0.32927846280029077,0.7578039803332928},
{0.2721117045304205,0.2814989568677513,0.9201703959267092},
{-0.17662139150134665,0.052377380527954404,0.9828842729808825},
{-0.08142469365633088,-0.01855110478228613,0.9965068367925678},
{-0.05237766623434046,0.09367213342897972,0.9942243768378984},
{0.8871404962759885,-0.23461635466618816,0.397412765258418},
{0.5343706606844514,-0.5738402645324066,0.6206088524997372},
{-0.17956141452402583,-0.7992001882900406,0.5736172569329612},
{0.175638741281037,-0.8063151715024148,0.5648069376045627},
{0.3138842135437756,-0.8985756407757485,-0.30665700431012266},
{0.563054524305638,-0.5652896137765598,-0.6028409866750098},
{0.21044109773616537,-0.9425062046916309,-0.2596085485907103},
{0.372844327152677,-0.346289304041415,-0.860854706449689},
{0.3715819464530409,-0.1312407691365959,-0.919077101002198},
{0.38545952232457215,-0.10424517111787732,-0.9168172669337752},
{0.4980288937056716,-0.1592683170978258,-0.8524088363004758},
{-0.931535420612719,0.33741396664182965,-0.13562291568503818},
{-0.955123068474944,0.2930886151687545,-0.04288342016991022},
{-0.9687673668664087,0.20904628722874197,-0.1333770545881243},
{-0.9398826937360937,0.21920121154758326,-0.26186131992231293},
{-0.9678661214817921,0.12221456734290025,-0.21976981234232446},
{-0.967814417538571,0.18284148726386934,-0.17292843531245145},
{-0.9656289217083328,0.24698269395625305,-0.08099589154095545},
{-0.9458723946591688,0.32436492846914916,-0.010621026359687778},
{-0.8397468322630498,0.34181725248293854,-0.4218841352897598},
{-0.7618254198434574,0.48179100485085247,-0.43301207526481966},
{-0.7102485917038783,0.28735841023472924,-0.6426290392209384},
{-0.9274505818373515,0.12094030054457776,-0.35384864271852906},
{-0.9519792002379033,0.04698080793178408,-0.30253661927191355},
{-0.7835292406379458,0.08022300266940606,-0.6161543628897133},
{-0.952472622567628,0.13323956245624102,-0.2739399975462042},
{-0.5851070851674796,0.21613475113036396,-0.781623610339805},
{-0.8376450712800261,0.3441384177531017,-0.4241691690666258},
{-0.8648021502847695,0.39309297217675393,-0.31240223444797066},
{-0.9768258686566029,-0.00016935757544156557,-0.2140354962179983},
{-0.9860928171969985,0.15662903083908827,-0.05557249833231432},
{-0.9575777918873888,0.2509675304643853,-0.1416335805403523},
{-0.26433038300223105,-0.49073508230955537,-0.8302460644968621},
{0.5143828413749175,-0.6036119052821334,-0.6091493743744135},
{0.4230241302894242,-0.7218861175756452,-0.5476595826281486},
{0.006243280328621361,-0.7152469430761598,-0.6988439252586712},
{-0.5522235594529754,0.5935589127283426,-0.5854374069922708},
{-0.5266160878723539,0.5568039425076495,-0.6423743967515794},
{-0.34440057369710914,0.4029063118076612,-0.8479709598462968},
{-0.6740895186136583,0.16409547117693585,-0.7201916392422407},
{-0.9138673504741766,0.07351047810908933,-0.3993027364612989},
{-0.908414640837065,0.03633949212384728,-0.4164880329914019},
{-0.908877173693686,-0.004694415001992991,-0.4170374630730031},
{-0.9141449199637723,0.015301563170277057,-0.4050986638696483},
{0.13348300843962618,-0.05498818684970506,-0.9895244240365614},
{0.40423650571936015,-0.029925811614902414,-0.9141648063905059},
{0.2550746108580525,0.04783214541315796,-0.9657375568759804},
{0.3657054563954776,0.05045374210416838,-0.9293621140708618},
{-0.7039086239929274,-0.5295542447901102,-0.47337611990166917},
{0.10819460892539748,-0.9878592618951173,-0.11148096378985249},
{0.07588960326935307,-0.9918552404411694,0.10229345103676155},
{0.19888128357465013,-0.9800056031067614,0.005937417203816516},
{0.30001550895624796,-0.8891780913361,0.3454750588300312},
{0.36706220556563174,-0.9169218813789216,0.15658735802686227},
{0.5762762648975264,-0.8168601736063065,0.025399277384029525},
{0.36107077663190534,-0.930356875776621,-0.06374933691888784},
{-0.7580338563610611,-0.5382339463118311,-0.3683597313061931},
{-0.7984743303069959,-0.351871390108001,-0.48849285426120354},
{-0.7703259338612394,-0.32863868035952276,-0.5464380782781897},
{-0.679974777604788,-0.5036507100179334,-0.5328886038561444},
{-0.11440753672879579,-0.9883539448431861,-0.10033641040301251},
{0.7284716924797084,-0.684814211461907,0.01893380668422904},
{0.5628224629820567,-0.7738996265260878,0.29036226205482224},
{0.12948379774770996,-0.8459502802418721,0.5173026865187617},
{0.1826884244732863,-0.9377191589309436,0.29547879541062166},
{0.47385884489149166,-0.8805766583698624,0.0065225648534650285},
{0.6774934001233203,-0.7343670211696046,0.04132518611965576},
{0.5260785460474845,-0.8503212852793833,0.013966931996054284},
{-0.34022754016251117,-0.7887166907445595,-0.5120265644045411},
{-0.611779525906418,-0.7444968882168047,-0.2673016930683623},
{-0.8773447111130303,-0.3432884416195847,-0.3352898801520715},
{-0.8183071636374516,-0.5659823890948241,-0.10018643208610711},
{-0.9161801672258684,-0.31694738653332166,-0.24527179893268838},
{-0.8074039132517594,-0.15892337054845346,-0.5681921181777025},
{-0.7226077693124324,-0.30428727976410946,-0.620682900604704},
{-0.631563489321067,-0.31716778417284724,-0.7074829719784672},
{-0.6244733041288669,-0.7303417952698456,-0.27682838458582004},
{-0.3241148699192489,-0.8164969158395755,0.4777890094191051},
{0.4533806686877501,-0.8839665565610731,0.11423264043961992},
{0.7588655902044709,-0.6476960299897836,-0.06791810317649959},
{0.5460863114515219,-0.8248787081542005,0.14616722368276944},
{0.28502163572422423,-0.7770161793654915,0.561256201901896},
{0.10740964911855924,-0.7513826360457025,0.6510662804394336},
{0.1600946639060673,-0.952751379899372,0.2581366047050395},
{0.14380592688149935,-0.9726367344345509,-0.18247640456301603},
{0.5013684180329242,-0.8567497592286072,-0.12087001059355651},
{0.3585686168936993,-0.8439657563335651,-0.398936522664011},
{-0.44298443776353397,-0.7142599461646529,-0.5418463963192822},
{-0.9408602315394584,-0.01940904374046907,-0.3382385455985128},
{-0.8031169347742881,-0.06389748272749197,-0.5923852638105052},
{0.5631084116228018,-0.30899853153969387,-0.7664390545020251},
{0.6388635670496158,-0.2609277677035215,-0.7237195884718738},
{0.4420864816322508,-0.27173013017067715,-0.8548229519119409},
{-0.06640757186946054,-0.2998794515320081,-0.9516629387273964},
{-0.505824546257842,-0.16995792268329302,-0.8457279899117849},
{-0.5281098208279429,-0.090466888258015,-0.8443433894299107},
{-0.7020654438490873,-0.009452231047982868,-0.7120496948115346},
{-0.7710554746177122,0.002304087382728051,-0.6367638072656042},
{-0.8485458528813704,0.005873614098267853,-0.5290892516534922},
{-0.19120935290747704,-0.1385066941863614,0.971727780310036},
{0.6164660176578365,0.47738576504624164,0.626156913564246},
{0.37569536551506977,0.29114773633235336,0.8798215659774683},
{-0.3402657092872637,-0.24852320042094603,0.9068933046041115},
{0.4031164498609469,0.5243095479991632,0.7500644143861379},
{0.6656506090609969,0.4835926786523772,0.5683725783414805},
{0.3984541556076693,0.371568337661296,0.8385530730529824},
{0.4090019571291986,0.5788586392531492,0.7054360884066518},
{0.5009998789126003,0.6760434527693263,0.5403372755023361},
{-0.20893314745912567,-0.0737665809191898,0.9751438003865459},
{-0.5809703792057306,-0.3902799969552328,0.7142513160381107},
{-0.540924431275787,-0.405551744757082,0.7368368489519596},
{-0.4439502407427911,-0.5531182026923106,0.7049598836776784},
{-0.4737637715557831,-0.5829130064999657,0.660121440050549},
{-0.3666659488838673,-0.4524923469245993,0.8129002139892457},
{-0.1926100308985856,-0.10542110984614213,0.9755961078212918},
{0.20416483213575284,0.1650518942295529,0.9649220660396447},
{0.5880403151045923,0.6633810794731785,0.4627462924850852},
{0.3827283692161384,0.3847299025795993,0.839941603600064},
{0.1050646015062281,0.13635738266622757,0.9850726337193383},
{0.02807543021226875,0.07636742668337759,0.9966843965670151},
{0.08999580957311455,0.3500140965768458,0.9324113290049484},
{0.08810567603357375,0.637380464101015,0.765495613203003},
{0.21151920540796956,0.7427937647252378,0.6352299180839085},
{-0.7989481421230418,-0.3216574071104252,0.5081519247716554},
{-0.7191135049564898,-0.6419241478853466,0.2660998973146443},
{-0.5276859863222305,-0.5191076774883413,0.6723650191761875},
{-0.5628226926809272,-0.7371882985460143,0.3738770240202292},
{-0.4467539064650714,-0.7237234688541129,0.5259612986598616},
{-0.25574093402080017,-0.5096539172588548,0.8214922149898155},
{-0.19154602214710245,-0.21364438475829417,0.9579489538910055},
{-0.1962588272212876,-0.15606961145536707,0.9680520384348641},
{-0.1659683505198262,-0.08499243066086873,0.9824615989218538},
{0.42654224832716525,-0.32116870651318397,0.8455249093602477},
{0.7130130740377466,0.3485128801465886,0.6084004673101201},
{0.6903443548773732,-0.020443670908199343,0.72319204089145},
{0.4427269450967426,0.6535519296892811,0.6138914621370156},
{-0.05561432366814452,0.5489562756984921,0.8339988335568437},
{-0.21756578581275487,-0.2396849876902495,0.9461586735424473},
{0.2243619894710354,-0.2894835042031921,0.9305165224083017},
{-0.07196740784051771,-0.0407644167390239,0.9965736071844588},
{-0.3984782933388642,0.19359565459079617,0.8965131188450659},
{-0.26856650246820074,0.42768937875082724,0.863107078557307},
{-0.20886062635265443,0.7140142976749381,0.6682520643255371},
{-0.541857602949313,0.4372785756711666,0.7177588629790792},
{-0.40187844944714285,-0.13976124020392172,0.9049643681419849},
{-0.612531304730357,-0.0993352278764863,0.784179770988804},
{-0.8570240218908608,0.3776521161162259,0.35055485318983937},
{-0.8374182748582932,0.3356836193638016,-0.43133182194706915},
{-0.9954493283106995,-0.038523289752015445,-0.08715842421969028},
{-0.670585864482943,-0.36518681601207975,0.6457191245167077},
{-0.8531962953482127,-0.23939673229652042,0.46340617838979387},
{-0.7932128138077476,-0.13976140698623316,0.5926889412908124},
{0.3052115314808967,-0.25054466334951575,0.9187346149558987},
{0.3255516348641727,-0.2618857434880461,0.9085328779934041},
{-0.627319978703959,-0.17798312942300212,0.7581501500096529},
{0.216498478930659,-0.9715571349877702,0.09594343164108171},
{0.2879597998030509,-0.6403632501629477,0.7120491988185457},
{0.05735202560312331,-0.9970387621629142,0.05122940467995634},
{0.01267369466270149,-0.9999135849291503,0.0034928695554470143},
{-0.04617637658240024,-0.9986305886676824,0.024590437632511376},
{-0.24208106275514518,-0.826121322272668,0.5088421365628027},
{0.7220002686286491,-0.6612572019588443,0.20360384318012986},
{0.8635839542217254,-0.3665711381360464,0.34619121117730944},
{0.3566593079066276,0.41599638877302564,0.8365053153515326},
{0.16829215646706686,0.7382134829145975,0.653237019553212},
{0.43763968186062896,0.783556525172956,0.44103365032592484},
{-0.07713118728005064,0.9959047376023532,-0.04716496125258234},
{-0.27424002723452107,0.9504622825925301,0.14633474239361932},
{-0.29749552918627575,0.6714763621228189,0.6786868977845989},
{0.4910362574231216,0.6899623105348971,0.5318227185230432},
{0.6335168580965103,0.5794636131867686,0.5127165995948064},
{0.3834648790053125,0.7193006393273707,0.5792765115492572},
{0.5073454850858844,-0.08262828144415672,0.8577721876282501},
{0.5824607700061489,-0.5292870255287939,0.6169235738815028},
{0.8515746361267564,-0.5124184786205659,0.11067042004875173},
{0.7911114722195636,-0.6095786902384623,-0.05056143718047702},
{0.6909093423689274,-0.5165914951679071,0.5057445083710966},
{0.2980900497242137,-0.46524957889751195,0.8334777451084724},
{0.26290894198597475,-0.9564762559332914,0.12661777150008577},
{0.46531460258402557,-0.8774747560336711,0.11627713939429145},
{0.39837415962823985,-0.9164487556102711,0.03767900318319674},
{-0.010345262914980285,-0.9994064435946631,0.03285933713098232},
{0.2716943087778941,-0.9332159233860876,0.23513877374085787},
{0.6404876089852446,-0.7628053363724695,0.08890242706500197},
{0.7827965966980488,-0.5528803948764565,0.2855744336582074},
{0.9003833211980592,-0.40033666976874177,0.17041251640306815},
{0.8220096209617644,-0.03598432237986953,0.5683355624885338},
{0.6658240447773552,0.21126447913290086,0.7155736588591189},
{0.5356036727763608,0.5582999999112852,0.6335848923447686},
{0.5279195481955617,0.7113763469208785,0.4639446558313824},
{0.738419185576753,0.5472805834747817,0.393981051985584},
{0.4631647320062399,0.8821074470236713,-0.08581889611833149},
{0.18939582907783264,0.8473511259720986,-0.49611015837386063},
{0.14528807573494998,0.9813904671517555,-0.12555527082880533},
{0.6645242302435809,-0.20150442758111234,0.7195856537510906},
{0.7279902295564283,-0.3319213248940778,0.5998820381966267},
{0.7833783549180139,-0.16231531921821685,0.599976741376726},
{0.6548350504151096,-0.2671209063106278,0.7069918515510838},
{0.5641542183540469,-0.4458247924577255,0.6949606264698457},
{0.5344872760906512,-0.12216289842324152,0.8363011287485081},
{0.4054737070803472,-0.0925497486881206,0.9094094880109215},
{0.4789811342025778,0.0139262131674962,0.877714722255942},
{0.6917443739912796,-0.03499143048128541,0.7212941985377992},
{0.28382347827336624,-0.1150636257350792,0.9519477901720795},
{0.03269411906113438,0.06939978126468636,0.997053040183535},
{0.5103940033633756,-0.06555875446517469,0.8574380508489704},
{0.4161749474643674,-0.15669654007593167,0.8956810857840323},
{0.491990183530746,-0.15717243354078325,0.8562957931954653},
{0.6441470391820617,-0.16004438492691694,0.747970846200805},
{0.5985796724813175,0.07119697753826865,0.7978930793543542},
{0.4627808513760563,0.026887447736355742,0.8860648671253575},
{0.07786752391049231,0.13981615991380933,0.987110981676835},
{-0.16613094543317092,0.20084234886486277,0.9654340266801898},
{0.24009962596903747,-0.09961181985479799,0.9656239718206792},
{0.4933086620219493,-0.22458330790061443,0.8403623633805433},
{0.40667024182783645,-0.16015708065985917,0.8994270531433888},
{0.46272944379194486,-0.18480121600352883,0.867023628519785},
{0.600490460672844,-0.1983575797061914,0.7746389334483631},
{0.6421842875539117,-0.1829823361726061,0.7443902239200151},
{0.6119360028154146,-0.19355302446777625,0.7668582366889393},
{0.7227822124286142,-0.22448124340920883,0.6536008298298384},
{-0.875524880861965,-0.4789413545031353,0.06380722481305531},
{-0.9598237199435377,-0.15273101688727925,-0.2353968205272255},
{-0.6352193974387701,0.26355083386347944,-0.7259733294601053},
{-0.7625203022716353,-0.610423515209478,-0.21434999580797284},
{-0.2693598227681157,0.5144548793222151,-0.8141139128032971},
{0.33568139864354557,0.24699787776517895,-0.909015977298645},
{-0.0984079198791101,0.1551266606979439,-0.9829809766449051},
{-0.8985240618853744,-0.42151845388075715,-0.12237934160218288},
{-0.8775863022209455,-0.4346185740494446,0.20235853637886148},
{-0.9053271251253607,-0.3325830378998235,0.26414261188527327},
{-0.5295960708325317,-0.8071748794643688,0.2607617988134488},
{-0.5192391175742023,-0.8522941924109692,0.06312961558014896},
{-0.11816744839895832,-0.9827584873697074,-0.14220481581748373},
{0.42153871330213205,0.9063819039608861,0.027873954865110333},
{-0.41504693285980876,0.6071920345934209,0.6775351479074481},
{-0.6446338331579784,0.28199981968721816,0.71057956827116},
{-0.5343792318972505,0.12949389797968286,0.8352665244716397},
{-0.3470414733991477,-0.5616200912650147,0.7510959251842773},
{-0.09863732213747967,-0.34537702357551675,0.9332659804512667},
{0.009636256668248966,-0.16213014981270069,0.9867223302830107},
{0.3363427908962132,-0.2864051134721892,0.8971318955366199},
{0.0228555044523783,-0.2273077754472279,0.9735547242643631},
{0.9402118569030838,0.19535243376192718,-0.2789965784058059},
{0.31114692550601797,-0.12525845181609876,-0.9420710753424004},
{0.5344997806573261,-0.07182777511555986,-0.8421108924596682},
{0.8960863495163761,0.3187588891820677,0.3089045560975582},
{0.8361487309642053,0.03033297182826258,0.5476634098851364},
{0.519792990437986,-0.20602460734465852,-0.8290772631425946},
{0.29905972840813844,-0.1737876877807898,-0.9382756089871767},
{0.5378219655926314,-0.031918665508361276,-0.8424539940662895},
{0.4653184233207867,-0.04613786099233681,-0.883940078682548},
{0.8956148728124484,0.1509714020565055,-0.41842757480624376},
{0.9554400051460061,0.2948720840319067,-0.013595978275939027},
{0.8677296563110284,0.45249450592066065,0.20565496753047774},
{0.6441621592122148,0.18223479210198473,0.7428631052802419},
{0.5409073270122453,-0.19142076138046174,0.8190099851021306},
{0.8967149681761782,-0.28711151206944274,0.3368519637555848},
{0.635843049129754,-0.23696993993255502,-0.7345398998296407},
{0.43374699063242456,-0.2814878396712288,-0.855936997818496},
{0.39917393574411025,-0.2630918410045521,-0.8783181953138579},
{0.8707478461638545,0.2537216389158512,-0.42121671185609777},
{0.8866474604971463,0.4443094972190799,0.12823943026577178},
{0.9257684359676203,0.3779495824534563,0.010340023661683606},
{0.9591696935719396,0.24750389798885422,-0.13687702295650003},
{0.37921704154460856,-0.07686647549622025,-0.9221095273051588},
{0.9699281829678822,0.2411884185039573,-0.03267210835226832},
{0.9676960648678331,0.24350918656091933,-0.06532688649973802},
{0.7495199619613565,0.1543069495888468,-0.6437462170219191},
{0.7431441387003977,0.37777464766611,-0.5522889684721128},
{0.8411549263485509,0.5403886327836949,0.020940760199494843},
{0.7506094713132516,0.34845232503106954,0.5613968282376403},
{0.6326772738460326,-0.11447626454731372,0.7659077307444062},
{0.5564878782036102,-0.3681980084474658,0.7448163988445499},
{0.6942834979815916,-0.3448476678605223,0.6317044486162845},
{0.9894560624581366,0.05450927035113818,0.13418435046840121},
{0.8502235091677774,-0.091281424571676,-0.5184473801521187},
{0.6027103240344275,-0.2030120292551471,-0.7717035579029183},
{0.588469123720578,-0.2620963166845123,-0.7648592100562999},
{0.4779066547641374,-0.35513847050488107,-0.8034188796011739},
{0.34095305454235403,-0.43663720104737974,-0.8325256568177034},
{0.4312922028632917,-0.2958748670239742,-0.8523174870978977},
{0.4872238875739202,-0.3835112764666678,-0.7845584644883152},
{0.8115771355951658,-0.07681961653108121,-0.5791729443742719},
{0.8680407770594436,0.38877542448645624,-0.3088023294559371},
{0.47071403218429303,0.8455840246873632,0.25182525111339593},
{0.8163418247646613,0.572610993215064,0.07551606179589189},
{0.6421097793389148,0.6420943077753553,0.41881968817119547},
{0.6972927151795167,0.5072720927087748,0.5064167190332853},
{0.942701948873904,0.18059900348136007,-0.28052991913677033},
{0.7950761090680287,-0.011204525249130355,-0.606406167022719},
{0.8737670201178116,0.035364549602844325,-0.4850572576364854},
{0.7607255485218123,-0.14541954564269527,-0.6325739447457982},
{0.7421048802536578,-0.2748491068267597,-0.6113414064009052},
{0.56796620705346,-0.5028838952472828,-0.6515536628292607},
{0.4112948017186898,-0.7485959212468319,-0.5200391646518466},
{0.6088122632846851,-0.7425795293793964,-0.2791473994520698},
{0.8468844321052001,-0.49582624295202654,-0.19220586738684772},
{0.938002236367849,0.2748781853788537,-0.21117241243056004},
{0.4592755527958535,0.8603538100594246,-0.22103684787902345},
{0.017218673705759604,0.984526913074355,0.17438541999862262},
{-0.015057927547150025,0.9963425557021378,-0.08411165504801942},
{0.24609695285236652,0.897342098962306,-0.36635153504073537},
{0.9501335507265752,0.20255007111073997,-0.2371069473396865},
{0.5188860015388607,0.613958727044601,-0.5948209805418655},
{0.9633360845884648,-0.1961297116631853,0.18307573387175624},
{0.9721913173256371,-0.22220500701270218,0.07395253460921679},
{0.9426008485890138,-0.2980523616915287,-0.15056038632181082},
{0.7977503447179712,-0.5378783018297599,-0.27254599597699397},
{0.6573532712028062,-0.5137888443170089,-0.5512782421739157},
{0.8036463203692861,-0.43431426027180137,-0.40684605821055303},
{0.06468251993271981,0.8873641259345735,-0.45650967089375444},
{-0.15847392595531032,0.9348967458334305,-0.31757532873693567},
{0.6848485631878946,0.5947862236283676,-0.42096531173171714},
{0.8128967323660402,0.0037667328721867847,-0.5823956681089618},
{0.7133699916704196,0.5901783906727711,-0.3778792428369723},
{0.682758536341422,0.6137278146158269,-0.39645800612397797},
{0.7653494555835553,0.5645427130254603,-0.30908208619686794},
{0.784886532427554,0.06635957711494717,-0.616075918811128},
{0.7071954492121131,-0.6084872904086394,-0.36002474085099995},
{0.8929296530387641,-0.09190747854820921,-0.4407149306649174},
{0.9490290510985475,-0.008151598776613323,-0.31508318204622665},
{0.909071141223084,0.2190087429271883,-0.3544359331625566},
{0.6591541253792442,0.5873963911400754,-0.46955438308159714},
{0.6977872053650274,0.5255824910035503,-0.4866786015219573},
{0.7603125145196813,0.4395547344255246,-0.4782431554229145},
{0.7627594338433705,0.5540136747689884,-0.3335669261960821},
{0.8551262844247591,0.43575091048864795,-0.280856158369761},
{0.8844423883822989,0.42022407174281334,-0.20291227454371893},
{0.5146120577785251,-0.32042382485410625,-0.7953005736542739},
{0.3606644517444856,0.7308867578603067,0.5794184156827422},
{0.49896137564154225,0.5006794955513513,0.7073595891428519},
{0.38367205460889786,0.5325084878256697,0.7544736343344315},
{0.05442429604069015,0.6369805788958606,0.7689562654078382},
{0.49817282985382505,0.7935477632580328,0.34943637335515726},
{0.727487947209484,0.640869102349304,0.24504709816467599},
{0.8168169871621119,0.41156956321696997,0.40425301992292256},
{0.4924697262838793,0.33800519072845686,0.8020137528337656},
{0.6865192933440222,0.2822465426603138,0.670095626774809},
{0.6750487487122597,0.5271969446790393,0.5161129414993376},
{0.5400963288005408,0.8271117697480109,0.15550587114476222},
{0.08331643167591883,0.9275746946925957,0.3642300893373995},
{0.13921776010120854,0.8491489504103439,0.5094747052498424},
{0.48702364825401917,0.8671542179854405,0.10417066895918849},
{0.6334779486284174,0.747492607461865,0.199901201575664},
{0.8947987589744741,0.17855745574106208,0.4092095012790143},
{0.5551522315389832,0.20382463546432827,0.8063879449713526},
{0.8197189771197403,0.10457728711151562,0.5631379844852967},
{0.8571747727314937,0.2773245395697629,0.4339844568013136},
{0.5965942963586458,0.31222511101573686,0.7393177433306624},
{0.41222482981555497,0.478652269284893,0.7752178369929055},
{0.4297503462078067,0.6574921178234103,0.6188850902504898},
{0.23309918551831105,0.7404689928446684,0.6303732547834674},
{0.26706668395844807,0.9496647002045816,0.1637447510755089},
{-0.22195030715184477,0.7926283758058443,0.5678717452229782},
{0.2281875361992986,0.9733686900673412,-0.021996397884247572},
{0.22332301058536802,0.9200767989682999,0.32184703966843364},
{0.7867471208291672,0.4821088899014005,-0.3854866873772104},
{0.5335221868993569,0.8368380277904874,-0.12270367284582563},
{0.6134651568689865,0.7894670470311853,0.0200569927848148},
{0.7484730007489941,0.6578777049959367,-0.083576865334107},
{0.08051995508899289,0.7162971867045586,0.6931340975248593},
{-0.0011009533302282425,0.8362146503615823,0.548401172885709},
{0.7423794363232145,0.5990902652551668,-0.29993937154185074},
{0.8371652306021339,0.42838951099732386,-0.34005411854343065},
{0.8134565792609944,0.3775506759279846,-0.4424295206734328},
{0.815075896178874,0.4293199074143548,-0.38901889487007607},
{0.6633816301399109,0.6733211221543616,0.3264406213290646},
{-0.37374501015723216,0.013398932495546844,0.9274347071306692},
{-0.6683594618266077,-0.09268974882010839,0.7380408120493829},
{-0.704946919836186,-0.12369425599792601,0.6983907010023785},
{-0.6931282148218553,-0.10105657155937382,0.7136952060666607},
{0.24545290132767475,-0.30660843553617007,0.9196434855355031},
{0.12390847261746227,-0.09957329172941498,0.9872850905325049},
{0.06944668019389796,-0.18266375475477897,0.9807196904870079},
{0.09377385777684989,-0.24589737727698233,0.9647491608941406},
{-0.12163606844232014,-0.08190100379079872,0.9891900183644975},
{-0.10850683603662108,0.009999108513785618,0.9940454136317171},
{0.08570071033111672,-0.07759151732036486,0.9932949937901959},
{0.281916302863037,-0.14885118787609455,0.9478219885864181},
{0.30457014367809454,-0.24285650025616257,0.9210090921718598},
{0.16784080200401486,-0.16150942530823462,0.9724937895530505},
{-0.012473858356922033,0.046730220424068554,0.9988296598303483},
{-0.02425652708748243,-0.24174942187162893,0.9700354828141017},
{0.25011704880565927,-0.2715483512853769,0.9293562044829425},
{0.18037240032442134,-0.1337592546275684,0.9744610094830292},
{0.26714064829960127,-0.1672582343488818,0.9490313783371778},
{0.16627931672633642,-0.08325224677227422,0.9825580146924613},
{-0.04559447634044022,0.09202042467575998,0.9947127148929652},
{-0.2837475659955044,0.41790504966449116,0.8630426920242973},
{-0.2091040530675381,0.3955112728418482,0.8943412816401518},
{-0.05972377643414109,0.22170820427061255,0.9732823550684279},
{-0.08425369660137387,0.21406305400954154,0.9731794919320442},
{-0.7379967134168056,0.34584412816076854,0.5794417054395646},
{0.0658037566676304,0.5258034722222197,0.8480569404276371},
{0.2045891513309668,0.5382272113908125,0.8175908194666476},
{-0.955261429084264,-0.09640372688068062,0.27961030658293856},
{0.16626545163040202,0.31197923425001356,0.935427579768158},
{0.27319432952562206,0.62678474497573,0.7297299101590635},
{0.3052643849471927,0.5205656196436383,0.7973864125553225},
{0.10869346642525114,0.26163053821370025,0.9590282539271053},
{-0.9637482823657814,-0.061869969424339276,0.2595406617862367},
{-0.9860646059107672,-0.10877078580764186,0.12587894631284266},
{-0.976631078589816,-0.10487793142590496,0.1875962575114865},
{-0.9287369253707,-0.2973743935007492,0.22139601067553227},
{-0.7589142045805797,-0.6510514109230452,-0.01346441313010661},
{-0.7959862382183912,-0.43189198579761634,0.42411698995763686},
{-0.7120900068479765,-0.021940095006366594,0.7017452916681098},
{0.6581270662066452,0.10202090577457862,0.7459628003534551},
{0.5826946968989444,0.41331959915838257,0.6997383790799253},
{0.8527810410908703,-0.05436831305669323,0.5194310180296713},
{0.026794876105263835,-0.10900970343295417,0.9936794851318823},
{0.05238064556123075,-0.11112485010307706,0.9924250781092532},
{0.11601320671903181,-0.3100968253173868,0.9435999654487305},
{0.04602681050268693,-0.12249873903749338,0.9914008229011986},
{0.06446185540022459,-0.32027450415463776,0.9451290447271534},
{0.08513201865606991,-0.44609031849082786,0.890929832898357},
{0.18934291543137155,-0.44756688788966587,0.8739754809150585},
{0.23582459120908064,-0.3264871106576175,0.9153102909699588},
{0.25041329585336,-0.20107973548158312,0.9470269907655822},
{0.07428823793753474,-0.07245441223151168,0.994601234592197},
{-0.09275658837346118,0.09297841017943809,0.9913381010300273},
{-0.02162846023631983,0.06903214127234561,0.9973799542697662},
{0.0012969299882125331,0.09290936607587681,0.9956737255085043},
{0.0708644785064253,0.06428633014615259,0.9954122228716865},
{0.6133658007061681,-0.2640877724394959,0.744338661478783},
{0.4483065498687776,-0.3133824477265992,0.8371455541312028},
{0.8668894596056378,-0.43140568716362915,0.24978350207233926},
{0.35439062865348436,-0.4950057949936478,0.7933325565267664},
{0.17727954560554107,-0.729226277460031,0.6609092214303556},
{0.23644355986467683,-0.828537987145851,0.5075620620720392},
{0.2937046844732352,-0.677167659885678,0.6746714153745007},
{0.3132825629973879,-0.47171201593967366,0.8242219420398347},
{0.40782259189486586,-0.40698024760638485,0.8173419184150532},
{0.40189214398912243,-0.3438646988569125,0.8486694135409095},
{0.46567669758025193,-0.29151116064586374,0.8355635562598765},
{0.5026071249985907,-0.22723509558370356,0.834116472224183},
{0.17487704331433027,-0.12748115138987862,0.9763025021794981},
{-0.09385441456302822,-0.0015686395412427407,0.9955846966667481},
{-0.3479771817382473,0.24197579350036677,0.9057370459186124},
{-0.345753226388507,0.34146227737465834,0.8739898280712708},
{-0.3172291127814096,0.4595628549098807,0.8295587214845008},
{-0.0769748660284764,0.21491196355968392,0.9735952536443566},
{-0.017056452220446567,0.10434864318134461,0.9943945082832387},
{0.06490505850163712,0.16012459145702013,0.9849606330161736},
{0.8505495154615497,-0.17404441873780754,0.4962600750154517},
{0.9542656257236902,-0.2841139486978085,-0.093039667440899},
{0.9019156803808543,-0.34595758607085497,0.2585758189065009},
{0.6560054252463932,-0.3256973762582089,0.6808656997865421},
{0.7444030441044185,-0.4360093129896612,0.5057271862519938},
{0.39709615002287335,-0.3954143551055383,0.8282283111639464},
{0.13646418132993668,-0.880591562513021,-0.4538017488340327},
{0.3689672915139488,-0.9289864297752357,-0.02910929553118611},
{0.2915628049395955,-0.8475183454012171,-0.44351300430104496},
{0.3825985230807907,-0.6492256264899814,-0.6573617391095171},
{0.7321585341849883,-0.5890346000397735,0.3420264913366704},
{0.42693660403025213,-0.35785490785426033,0.8304607161472086},
{0.3282112438041338,-0.2047796414196131,0.9221402701870242},
{0.3752178883296676,-0.16123541370169,0.9128059364650681},
{0.5570785462544298,-0.19600417462090922,0.8069980525591294},
{0.545203523355637,-0.2067690994163558,0.8124036297599541},
{0.36902828694999956,-0.15825530553793205,0.9158457193762738},
{0.3143286273386723,-0.12952056747700044,0.9404370987130515},
{0.31504407319576927,-0.14974723494052367,0.9371888804141277},
{0.0991103958181425,-0.06489422428331154,0.9929581406562104},
{-0.5990257422906571,0.38742485317145087,0.7007639711188118},
{-0.5480351281244572,0.4662650320349531,0.6944454033565589},
{-0.4966873457751801,0.583071355066151,0.6429070503954124},
{-0.3432774807776286,0.7062908916080315,0.6191233702764714},
{-0.1810952096219757,0.4206339167384168,0.8889722341790386},
{-0.17182614320002815,0.6259497544387168,0.7606988112460237},
{0.02191367026747748,0.4060364018550786,0.9135941283874308},
{-0.21131492933585497,-0.010583139872582154,0.9773607306364525},
{0.09778283730379826,-0.2003634274047353,0.9748297357423225},
{0.4962245400878339,-0.083059372420625,0.8642119800533371},
{0.7821369389276212,-0.21067678320027178,0.5864103527269249},
{0.6482661687605169,-0.2830772439096472,0.7068367905118401},
{0.6045401933939792,-0.27400620700883277,0.7479650747807699},
{0.4482052724923271,-0.18605949194616872,0.8743534177704188},
{0.24430394873124633,-0.16787084359553184,0.9550575692097545},
{0.3070854806539281,-0.15081120363363393,0.9396565800493927},
{0.2830325309299545,-0.1579431300307257,0.9460161489697106},
{0.14475628169645888,-0.14940065833763838,0.9781232346681555},
{0.2225309424995519,-0.307289344183509,0.9252314513577292},
{0.7945423870279544,-0.4182327725801094,0.4402087495221724},
{0.45596440516132253,-0.11247864220106826,0.8828618330602389},
{0.3482740981702881,-0.12104910185951409,0.9295441180937447},
{0.34060144512655216,-0.09258505563521556,0.9356381047449533},
{0.20630334432129685,-0.13647690074576618,0.9689236222141964},
{0.23480481749606852,-0.17166089667447504,0.9567649838040443},
{0.3744984511059108,-0.15261640682798586,0.9145814028757574},
{0.20514709516327878,-0.0990494172471039,0.9737062607835475},
{0.17207884415555905,-0.17023911363254815,0.970261570703329},
{0.27865783712922404,-0.2028590878527789,0.9387214710882038},
{0.16205950443289316,-0.6334441920909469,0.7566274991891404},
{0.4252615546948464,-0.8578403208525678,-0.28855258449385895},
{0.6894362405697311,-0.48432551197068874,-0.5386153252957124},
{0.9117850587578205,0.0012556577453983289,-0.4106658373296035},
{0.9215772243959477,0.2078535455927121,0.32786021878111354},
{0.3281557131168956,-0.11519366806488897,0.9375735953974483},
{0.40565661950502635,-0.06329822087541839,0.9118311479028127},
{0.5635434753922733,-0.1272327369873903,0.8162294910020684},
{0.45891567565942387,-0.003147769825504347,0.8884742507125236},
{0.12442761336991547,0.11207208389274521,0.9858791087364639},
{0.42339023557844696,-0.08642121141805495,0.9018159915602866},
{0.5051179619413495,-0.14039126930138685,0.8515551280029748},
{0.877480445723149,0.26157960370160943,0.402000221767119},
{0.9952711110902037,0.045311833882015234,-0.08592003921973115},
{0.7707573648758206,-0.08911164677797725,0.6308662290043733},
{0.47282569109348416,0.18540032823281863,0.8614305451591162},
{-0.05015128833423996,0.03380251483462276,0.9981694436663903},
{0.2791382716639249,-0.2203361750339978,0.9346302987084596},
{0.7601072195757785,-0.1697144325117279,0.6272431953764037},
{0.9550444272684938,-0.14759107177482592,0.25711284969007825},
{0.9023008810415617,-0.25506639717369295,-0.3475546764243769},
{0.754747839894325,-0.04690689368936895,-0.6543358781996174},
{0.8060905553859009,0.24181865806704436,-0.5401312369492286},
{0.9801514685750523,0.049056598788192296,0.19208474370835063},
{0.7024750067391766,-0.19850929914112603,0.6834639149664691},
{0.0762963521431901,-0.29625900532514476,0.9520553914628067},
{-0.40415572555118695,0.08706750043490186,0.9105368745263488},
{-0.7390565698944167,0.2507892590482491,0.6252200684894315},
{-0.8754792090036292,-0.016727419895887673,0.48296619760186776},
{-0.4062472217993551,-0.28071305637772936,0.8695765491084608},
{-0.3768898989703409,0.14962553929941255,0.91409310359694},
{0.5937591665720513,0.17001948211587273,0.7864753192648284},
{0.934299050838909,0.24934358864036446,0.25478041213063946},
{0.9288331006617622,0.157158271643299,-0.3355150499890397},
{0.5555746099440159,-0.06820669176786334,-0.8286644073348622},
{0.20828010085567306,0.0383959761304373,-0.9773152759496504},
{0.41595223865218744,-0.08416079825680103,-0.9054836802488555},
{0.7632271338146971,-0.18788814298470852,-0.6182090163809975},
{0.9738777726608788,-0.22086717080569235,0.052723588434160085},
{0.9002149221108067,-0.04077981051685951,0.43353212229688737},
{0.30246696549036395,-0.07313678205353315,0.9503498018613488},
{-0.4256509943644906,-0.04865063086530494,0.9035786336080154},
{-0.5614098859484346,-0.35045460232828085,0.7496669338221422},
{-0.923072255754427,-0.14912729555159676,0.3545400687903983},
{-0.97711568095854,0.21211161193381506,0.015925140745602584},
{-0.9292971799978053,-0.004769240199647764,-0.36930205197919574},
{-0.8993046684828767,-0.17952389128665286,0.3987759843598926},
{-0.9279416674110759,0.1920898024573724,0.31941472989553826},
{-0.8678532636816481,0.027159695942911358,0.4960776790316213},
{-0.013328404576128158,0.03827987909871715,0.9991781645370572},
{0.7973891370430785,0.05592844871718703,0.6008681825074312},
{0.9093613620935478,0.04918439378267036,-0.4130893469209761},
{0.5486761111780546,0.31581481182189686,-0.7740901301892609},
{-0.04983049781305527,0.08186963210411653,-0.9953965465214553},
{-0.39344765001243626,-0.0003130031526894513,-0.9193469686297541},
{-0.036129740014363775,0.101560661055303,-0.9941730603936642},
{0.8858857708271481,0.02718284977177502,-0.46310635249829457},
{0.9634666437824881,0.2666440167689176,0.025159384727085756},
{0.6366408875064729,0.14089987598580603,0.7581791380024611},
{-0.015195474688807265,0.2397915145192721,0.9707054790787655},
{-0.6928437735258948,0.15519800539484854,0.7041882451503002},
{-0.9916488903679935,-0.0640893990547798,0.11191526777309904},
{-0.8492491488400088,-0.11868541862054631,-0.514479984646037},
{-0.5486416305730936,0.041184285797853666,-0.8350426431059781},
{-0.9712176566099702,0.018316412739050096,-0.23748846816932143},
{-0.9989622909760154,0.013496849176704337,-0.04349915252337923},
{-0.9881709793051282,-0.051922197058133,0.14429899899791604},
{-0.6387073427534868,-0.20597533458828754,0.7413683914586747},
{0.21207475623873914,-0.22195553414158836,0.951714263122184},
{0.8625251708867314,-0.2300899703553952,0.4506760867060377},
{0.9608885372543075,-0.1478509143491367,-0.2341651684162306},
{0.5473603430821699,-0.24526276298256403,-0.8001517555533624},
{0.22069496909765948,0.04283247793954864,-0.9744019239762108},
{-0.5824048157417274,-0.4208512715050413,0.6954774172275002},
{-0.604229648280167,-0.13390177489528676,0.7854787373437411},
{-0.712662674215619,-0.3067886203982284,0.6308665906306927},
{-0.4866453432494712,-0.4414688984301567,0.7538444943172752},
{-0.5250943390206105,-0.023940877811974758,0.8507072172599103},
{-0.6482731488463819,-0.15645102732472824,0.7451610567748653},
{-0.7399897615732453,-0.25888957750559055,0.6207989525005244},
{-0.5885488458929885,-0.012318892353365047,0.8083678005024802},
{-0.6266349714226256,-0.11680437393859275,0.7705097993010722},
{-0.45780451322818694,-0.23036867124851607,0.8586881290521583},
{0.0369857070302582,0.03864601315543252,0.9985682466124496},
{0.7125312500917804,-0.06671462305630689,0.6984614353800069},
{0.867947633529871,-0.44962104753618215,-0.2109687632384541},
{-0.14436225804933597,0.029046687566251863,0.9890984927661781},
{-0.6006491321920172,-0.07724461390551626,0.7957725112238826},
{-0.6658702274809157,-0.11916209078702868,0.7364898073115319},
{-0.6335035937372544,-0.0594434468989078,0.7714529624952907},
{-0.719493063925899,-0.1550563336954308,0.6769691753273951},
{-0.7061134275107216,-0.13975233666158832,0.6941708088696087},
{-0.7324140879676964,-0.21176978901350865,0.6470882167120815},
{-0.7066987557809374,-0.16924096925250298,0.6869747905885253},
{-0.6762583712868893,-0.18873731627598825,0.7120764289803037},
{-0.622453977333563,-0.20846510712632152,0.7543827577645447},
{-0.1775144095374513,-0.9738855665724312,0.14154694496337467},
{0.6039503293048246,-0.7357416428304618,-0.3064771357503313},
{0.9794209701226465,0.07415554220427875,-0.18771126456449966},
{0.9892196253244812,0.04512692494453758,-0.13931293377839388},
{0.8883380464289474,-0.039527296620914594,-0.4574856370298893},
{0.821831529394492,0.02408114566105119,-0.5692214294251066},
{0.8907600048991666,0.09386760250421221,-0.4446745853679382},
{0.8068278985584343,0.006482087181826612,-0.5907509836246977},
{0.8607009857458686,0.1257583176386348,-0.4933342261396327},
{0.8723757288090843,0.17263178739936594,-0.4573388828474123},
{0.8156430017933382,0.2846744835626276,-0.5036734378879869},
{0.8710632188428227,0.34600457334057594,-0.3486111071187881},
{0.9534952133895517,0.2809545591146217,0.10913942347255591},
{0.07118425154769224,0.08409329075404194,0.9939120286935615},
{-0.08738759134507167,0.007634983390006863,0.9961451279344498},
{0.027363787035404583,-0.002716017983335384,0.9996218517046309},
{-0.37151324494514687,0.5010765494689413,-0.7816010493868512},
{-0.40162399304950186,0.450427648687689,-0.7973788945693594},
{-0.4122593507271866,0.4816290828082297,-0.7733535118762325},
{-0.24612837244063027,0.84831640000779,-0.4688071135952928},
{-0.5917775948584003,0.4845165529997488,-0.6442383007031237},
{-0.613317818951759,0.2113925658976273,-0.7610219681714022},
{-0.8972081867235654,-0.09821731458409245,-0.4305471272603051},
{-0.7242502885927332,0.6313664431291105,-0.2771965619625146},
{-0.2656014891273224,0.7962242490461228,-0.5435832909539134},
{-0.3583453935979665,0.6427135727605624,-0.6771320715166812},
{-0.28224981871057137,0.4002367893060041,-0.8718632646945684},
{-0.47006895777917196,0.3897273804776597,-0.7919266025576012},
{-0.5092215083252749,0.6417045716582723,-0.5735056217438547},
{-0.3158134860011645,0.7866810940350265,-0.5304664912580682},
{0.045934857374539034,0.8756078592936074,0.48083351133344177},
{0.2157874745893892,0.7714269431606319,0.5986119253541285},
{0.09769893269958096,0.853029405877842,0.5126360807210691},
{-0.5256014364029543,0.7948000666688317,-0.3033743299529013},
{-0.4524267991772194,0.8443039836077393,0.2871598416393876},
{-0.9991750165546119,0.03766200877437082,-0.015194057659831528},
{-0.9041380955390811,0.0786273658172993,-0.4199429027136856},
{-0.7150037052608478,-0.2686327777978381,-0.6454503328342748},
{-0.7402000114680293,-0.27661821202226405,-0.6128509670387533},
{-0.8583178119986061,-0.3884625827340351,-0.33524223394663183},
{-0.8400842284985214,-0.22694604665296939,0.49270070117327064},
{-0.5473246770336234,0.8318775847111114,0.0917353910181217},
{-0.245972657240829,0.9548546204472369,-0.166583629749291},
{-0.24364515088110564,0.7651482043683775,-0.5959742157207566},
{-0.1482462241914988,0.524651308972945,-0.8383102415012829},
{-0.21962201154297026,0.2931312382101927,-0.9305053730264962},
{-0.29476057891481283,0.1672723263350432,-0.9408167568449592},
{-0.142699043170342,0.40461818441764447,-0.9032835146933869},
{-0.23679556161974255,0.40698570632773057,-0.8822077401848778},
{-0.13581305048336542,0.9857948731974939,0.09880932798040878},
{-0.3697096666924582,-0.32514878520199486,0.8703982018799319},
{-0.2246218832767235,0.2757848158172562,0.9346056627893178},
{-0.3471462832646574,-0.6135045016052165,0.7092966125152925},
{-0.4355184259453388,-0.6682041460740215,0.6031806693119255},
{-0.2438582233394819,-0.6845110341274668,0.687006412682922},
{-0.3464739313811321,-0.6082260930462448,0.7141546293422758},
{0.9029586179055946,-0.19513705354218056,0.38286716323666964},
{0.8941895349034331,0.014277990857816204,0.44746085264103946},
{0.9550522827781187,-0.0071782120276122074,0.2963504857974607},
{0.9702520325360958,-0.07208060546616131,0.23111767495197427},
{0.9148904443347137,-0.17974195335906143,0.3614807118888907},
{-0.23113298975216795,-0.6045579948270318,0.7622907397699009},
{-0.7711805811822853,-0.44097911471428863,0.45914913872635643},
{-0.7969445327794726,-0.45311555012011207,0.3994567685147621},
{-0.5354483495868753,-0.5570415901500424,0.6348225986587146},
{0.8152591051965987,0.1388140879048843,0.5622128070341127},
{0.9638590183930968,-0.04659670162066719,0.26230619523825643},
{0.9589184148073394,-0.0625699381134327,0.27669563890285764},
{0.9848398283425405,-0.12263866458180107,-0.12267954377086619},
{0.9507682459785265,-0.05285458230900874,0.30536230213937104},
{0.33482894083743114,-0.37370094433186324,0.8650070430829785},
{-0.41678777653584753,-0.5751826069991945,0.703884165140767},
{-0.7638063735245918,-0.4203330508834855,0.48981624115395855},
{-0.7867550545180416,-0.42645517840886404,0.44626501655247086},
{-0.8030913908386306,-0.42855525308923187,0.4139862473687962},
{-0.8055150816381045,-0.44874736855858754,0.38700291015094573},
{-0.7638994163379456,-0.44306219805458885,0.4692052539918774},
{0.557780318492953,0.3312898753477975,0.7610046877608184},
{0.9751927438801666,-0.06825828403610555,-0.21057046075819416},
{0.8592348313104522,0.506575919909887,-0.0713886687811915},
{0.9122499599250179,-0.40879658829211446,0.026179381534538356},
{0.8688372311912926,-0.4700754567338016,-0.155405697039575},
{0.9489585321076555,0.1868806403618442,-0.2540734748021344},
{0.9914140196304128,-0.0988951335775606,0.08554527593586846},
{0.9268595554430481,-0.35109664983702865,0.13290036477425582},
{0.8493432331655842,0.516107526987667,0.11067562000055123},
{0.7005171856317207,0.713032496774529,0.029331402593375255},
{0.7144103659167725,0.6617156823919285,-0.22748666938360956},
{0.7453563556339463,0.5588880248735663,-0.36343923669439726},
{0.8066557853180303,0.3075977439814517,-0.5046682790808962},
{0.7794159149745161,-0.5802016692103269,-0.2363828558292422},
{0.9109756970064247,-0.23417223372278625,-0.3395388702592673},
{0.8442806798152485,0.19715424870838746,-0.4983175051179052},
{0.86841125781274,0.2586845996212154,-0.4230179254155858},
{0.8635368870053716,0.4726328580787496,-0.1758471672941722},
{0.8274740563881047,0.5611980989741397,0.018530507613862365},
{0.8017942115571696,0.5410566012527055,0.25373962354013124},
{0.9794098913988497,-0.08284197321596354,0.1841017982089769},
{0.8905393548705189,-0.41756771520889946,0.18049061095253555},
{0.9317961962691177,-0.0941459780793247,0.35056009959761725},
{0.8873515908113767,0.38132593377535356,0.25922516566659515},
{0.6105373380233208,0.7586822939175677,0.22725610173408936},
{0.7976311648316569,0.5935824974380618,0.10697823902311998},
{0.7672830022345385,0.624220998834406,-0.1470542046190106},
{0.7517620729070432,0.5451553635849726,-0.3710248176241605},
{0.714856784254884,0.4997088949212208,-0.4891531440575421},
{0.6209499318496107,0.48699930630222854,-0.6142091319714418},
{0.5614596516242419,0.5002508508306174,-0.659175352877539},
{0.6910757939936741,0.20469309632334887,-0.6931918805594689},
{0.8239471495083688,-0.20571848654168623,-0.5280066279054002},
{0.6825633064946461,-0.5974130142140048,-0.42095726989188925},
{0.8105940280433167,-0.2075535355963227,-0.5475936920399804},
{0.8440422507506267,0.10945959380703697,-0.5249869296195999},
{0.8725548103360082,0.11052828276563946,-0.47584829690603275},
{0.8923709533250821,0.3237610380946694,-0.31440876558001074},
{0.7733677146178751,0.6339520951488312,0.0026681535060702768},
{0.7860446205764182,0.6155317071752631,0.05704885559571631},
{0.8068363990030559,0.5882192788772473,0.054891758952621814},
{0.6390978565962541,0.7064474674713285,0.30411495424825813},
{0.6950191897528688,0.6103612623401826,0.38000980949149815},
{0.8043020219408185,0.5081550683776618,0.30802059019488454},
{0.8900535120948352,0.2976087654496158,0.3453024302480429},
{0.8988398947442499,-0.1225250431106119,0.4208021594845831},
{0.4842700555825187,0.6599068787630662,0.5744609861664169},
{0.6120445016781343,0.6776413689861857,0.40768088378545864},
{0.4524922023159975,0.7774447097289047,0.4368415389563561},
{0.7332590260892446,0.5913286019931654,0.3356511360377931},
{0.8781546912848545,0.4387274675735446,0.1906896624647132},
{0.9259615426126759,0.3612591364401797,-0.10994115671962561},
{0.8627582646407409,0.3228648328357069,-0.38910985147136573},
{0.749921366230469,0.33479451659616405,-0.5705528688282688},
{0.6841996687242463,0.3117350808234203,-0.6593118023375943},
{0.583948665494782,0.4167832521993325,-0.6966316650519202},
{0.5195012093390419,0.41669079973900497,-0.7459807443279898},
{0.5276144625876666,0.3441907851102169,-0.7766309820716273},
{0.6817161906279463,-0.3243094527846314,-0.6558097393835003},
{-0.6964319389348552,0.6531004849081506,-0.2973925201550576},
{-0.2513067921989695,0.614047908929344,0.7481911933016614},
{-0.6568867145855534,0.6949190432434673,-0.2925531875378934},
{-0.6779738577091257,0.6373240835706081,-0.3662914969855168},
{-0.7211483582344957,0.6801143807744949,-0.1318691566645397},
{-0.9440932569543088,0.016195181881342748,-0.32928048569150814},
{-0.7844104138563226,0.05480516034498881,-0.6178160705528085},
{-0.9452546913848519,-0.28477985735758665,-0.15935495366734284},
{-0.8201428128588507,-0.4178984892121993,0.39080253227190503},
{-0.6151812622880306,-0.6528413905133562,0.44198431347989353},
{-0.8335047120144976,-0.22685714546867783,-0.5037913562174648},
{-0.6513086250653135,0.06030622177499022,-0.756412740856972},
{-0.7378503433719628,0.08276076124334765,-0.669871276578044},
{-0.8448136507078515,0.09915391127519847,-0.5257931127891485},
{-0.9560676006047721,0.11955985787672462,-0.26765683899039683},
{-0.8158480355409851,0.05189432740963425,-0.5759331225816217},
{-0.852410254110255,-0.1496300070116827,-0.5010066064328638},
{-0.8794624553135097,-0.33861381928183787,-0.3344943513503627},
{-0.6545080787316108,-0.6552484241682018,0.377185203182924},
{-0.7865560510404489,-0.00782086964879414,-0.6174693616444393},
{-0.6629746540209163,0.08236142293180486,-0.7440975770277006},
{-0.5926083547217252,0.0794813268261697,-0.801559764833516},
{-0.619077019048218,0.0005618992244826741,-0.7853300763090854},
{-0.7337601914856807,0.022275085572441757,-0.679043299027122},
{-0.8799827030079034,0.13769151247378797,-0.454611361274204},
{-0.8893519750541006,0.13106613837082914,-0.4380350806042013},
{-0.8954767495993738,0.1246569871395864,-0.42729618121886026},
{-0.39495915873981147,0.05927801480121847,-0.9167842602754297},
{-0.23873641760917536,0.12440835921508185,-0.9630822826033864},
{-0.4104837303012742,0.16898804282155042,-0.8960726245909383},
{-0.6040419866895769,0.1397500231211523,-0.7846038550464473},
{-0.5144417004310463,0.24594703607895405,-0.8214985041383773},
{-0.8570218824126863,-0.4901121958754863,-0.15907082862651029},
{-0.46498921253925624,-0.5357156683668371,0.7048359772942889},
{-0.8642989187979592,-0.3081469663389529,0.39753342765203914},
{-0.7433888062441274,0.08876910039710921,-0.6629427800086665},
{-0.7482753197773664,0.03286414370005225,-0.6625737648525954},
{-0.6556761466809543,-0.07848047451479392,-0.750952465735048},
{-0.8559707583056437,0.02755835765338259,-0.516289257925351},
{-0.9264395702121286,0.2366309834642766,-0.2927720963648953},
{-0.9308489579022036,0.24171859728663622,-0.27402981096618456},
{-0.90899474488442,0.17488483804910904,-0.37834355709202294},
{-0.6544043246211453,0.08644330414016597,-0.751187416751954},
{-0.2405736241623745,-0.007810569649332737,-0.9705994675246498},
{0.2358956195773788,-0.02839061951668008,-0.9713635927847325},
{-0.009274502988646174,0.05321647626934212,-0.9985399292205537},
{0.06343375920464885,0.10522666444647616,-0.9924230485446393},
{-0.1280516684307592,0.18067083414265853,-0.9751722001279031},
{-0.396671450682061,0.24433219431110095,-0.8848466189328587},
{-0.5089156381187699,0.2857752746700035,-0.8119959148083501},
{-0.5347942422256652,0.32122120713990704,-0.7815446593547023},
{-0.3683806903444476,0.2541813558224391,-0.8942524841081599},
{-0.11645236869201399,0.14300598122738817,-0.9828469540875685},
{-0.12880934618857728,0.06555258187861669,-0.9895003847111523},
{-0.9424839772947281,-0.11763273373333567,-0.3128681711154596},
{-0.8156799634779044,-0.4078765335439853,0.41024740165518053},
{-0.48809766386527276,-0.2572706193719737,0.8340098913905184},
{-0.726976885142002,-0.05460308415788737,0.6844874810174975},
{-0.8834515051471173,0.03128064931422974,-0.4674772283563906},
{-0.8918470083438671,-0.0053356971346909254,-0.4523056975588316},
{-0.9697918972800886,0.08723623181283957,-0.22780148337748465},
{-0.911090912171994,0.11505676317139193,-0.3958222972574005},
{-0.9227758509631335,0.22904324182855404,-0.3098772696599915},
{-0.5777985142163881,-0.23576506754654383,-0.7813857625360907},
{-0.6780605201251712,-0.20820778553977892,-0.7048996021336683},
{-0.8920680802673504,-0.08576460945666613,-0.44368792177933997},
{-0.8740326965333174,-0.13725416646764976,-0.4660773961242582},
{-0.9685887670899247,0.2386174772951776,-0.06998213912495833},
{-0.7453991916916627,0.3459309811764374,0.5698348894967058},
{-0.8550138346120928,0.4112171646895824,0.315993332345139},
{-0.9567378989090265,0.17311021575768665,-0.23384919497716614},
{0.9977202265145858,-0.04294449185421273,0.052058815037102725},
{0.7587693149882415,0.26609024312533924,0.5945293173139342},
{0.5485085809154594,0.4258524810010278,0.7195748752474467},
{0.6117859612125323,0.42366621523639086,0.668000655486602},
{0.49489858604601095,0.3552194892389539,0.7930286905241674},
{0.5760751594211382,-0.4538544925364188,0.6798187334153273},
{0.8086773489636557,-0.25522513470914465,0.530001014985644},
{0.4466606147778157,-0.2738686636014785,0.8517571545361059},
{0.056507781349039374,0.7935196225373663,0.6059154060553048},
{-0.42264567603973846,0.8565572454570084,0.29610862496728235},
{0.03723667258826686,0.9413238985958796,0.3354441058459792},
{0.12532993652972443,0.931523762829214,0.3414028211569983},
{0.11705345670652297,0.876011977678978,0.46786910908503043},
{-0.0371290705221516,-0.9027329787991284,0.42859608153903317},
{-0.08702534360303976,-0.9533943253767772,0.2889045688633758},
{0.3016605680073337,-0.8374640410113608,0.45569165202186274},
{-0.035095905695745624,-0.35133728428648814,0.9355909309487724},
{-0.1772605481154787,0.058460882595233916,0.9824260904963723},
{0.36664293267979087,-0.04571899558013671,-0.9292377162809878},
{0.6457873865157102,-0.00879426621610225,-0.7634666412482795},
{0.5863553105386349,0.01004414776485824,-0.8099917066852098},
{0.2298552306550619,-0.05730505690361295,-0.9715362594333689},
{0.45587461455287703,-0.05789097427327856,-0.8881593161724738},
{0.49852529431235515,-0.0351076810391128,-0.866163946180419},
{0.533333165602671,0.05150634994657635,-0.8443357332148241},
{0.6660068391724617,0.10898401430745182,-0.7379413085069434},
{-0.4595648562507784,-0.1214747997877916,-0.8797977130657464},
{-0.8464389157953324,-0.1400506278679645,-0.513738244109791},
{-0.8454379561971687,-0.12340837380892343,-0.5196200876553863},
{-0.8524930087945753,-0.1353568404732341,-0.5049100867416649},
{0.4177304542625454,-0.16109627818229444,-0.8941751823537826},
{0.4140714329298507,-0.1267943190138626,-0.901370095519721},
{0.4324640092078545,-0.00769037118609365,-0.9016183998404695},
{0.52180788977509,0.15430805074646503,-0.8389907935390554},
{0.6374452441703785,0.21457249753002405,-0.740015002542715},
{0.7420990862663579,0.30545213400496485,-0.5966472492138463},
{0.7833373855942676,0.16933444130011,-0.5980872739993031},
{0.7562600826004169,0.3424635376348597,-0.5574848992177523},
{0.5215190577521449,-0.38428061734082347,-0.7618046203177495},
{0.8286731578698673,-0.28750946633765967,-0.4802490022813335},
{0.8786326694854808,0.248432099458231,-0.40778195653019456},
{0.09177687955428249,-0.09818301544769752,-0.9909273938371448},
{-0.21325945282714384,-0.3717045576704976,-0.9035242816808229},
{-0.6918061200470806,-0.6011249638738084,-0.4000663320914632},
{-0.7817077918464678,-0.5536430006942068,-0.28707552307508566},
{-0.6661523617388623,-0.6163706783854768,-0.41991453627656544},
{0.8346072983186976,0.32469368319802633,0.44497715636250845},
{0.9236324058205009,0.3013886844246813,0.23678690803968366},
{0.7784236110766847,0.16071746521458807,0.6068167582502416},
{0.9999750592435709,-0.0005489543691953039,0.007041274026583582},
{0.9295816695974668,0.3508051182394477,-0.11319756430857225},
{0.9554282667877355,0.2854844371172653,0.07520281368952754},
{0.9867929509024352,0.06782873851100363,0.14710178204654822},
{0.940654713003893,0.3057158850998335,-0.14733128826284442},
{0.9208217009216935,0.35682664866668773,-0.15735989931675545},
{0.5207222331624685,0.3518931863633793,0.777830020815165},
{0.6534296328674899,0.24337286304676345,0.7167979941539169},
{0.5710210695644031,0.2011964629425422,0.795898813551657},
{0.3948230588614159,0.2197712041859844,0.8920848446207106},
{0.1529228184052071,0.2033918540112171,0.9670813643809334},
{-0.06558518604034376,0.24775588358300868,0.9666000235475148},
{-0.02511970230380493,0.39374367710976166,0.9188769870294129},
{0.03375313387962357,0.6482060238040107,0.7607165547413165},
{-0.07080414330378793,0.912364859340279,0.4032085524043478},
{-0.22076593194747096,0.9479386027425869,0.22950993164086955},
{-0.5653321474072909,-0.3158277224061881,0.7620055202343229},
{-0.4753511664734664,-0.6463734680521646,0.5968606272242559},
{-0.3087279235751126,-0.4432079593506459,0.8415781448999466},
{-0.5656693405196221,-0.33853138690874823,0.7519406208429861},
{-0.7201140793701328,-0.060947137352518777,0.6911737546676953},
{-0.8759198756064012,0.32354862883967034,0.3578835792455919},
{-0.8234082462312438,-0.2724949110507731,0.4977402771424259},
{-0.6452471301045208,-0.2709195662590702,0.7143239669154864},
{-0.8615883858498004,-0.1478234589129436,0.4856065056851575},
{-0.9094116749622693,-0.20772343832801335,0.360307339103033},
{-0.9406956253284002,-0.0878600568931598,0.3276772053267372},
{-0.9581214849571748,-0.05926633305653813,0.2801619564278667},
{-0.27487383038737595,-0.03691497632276493,0.9607713889845294},
{-0.6411917195289148,-0.08630759636518628,0.7625117557239479},
{-0.5099460540278522,-0.19930154780813325,0.8367998058213836},
{-0.6720007971158711,-0.40498065660175814,0.6200045132529622},
{-0.9061457357318242,-0.2772120011403913,0.3194579972997556},
{-0.7837231850485064,-0.42537925973873336,0.45258198660745647},
{-0.8169203690214173,-0.5559974300028556,0.15332308537246087},
{-0.7673025585472816,-0.6222764126477064,0.15498015972729265},
{-0.8938892495614639,-0.21886492106569466,0.3912290324673645},
{-0.8798169309789867,-0.08816646999165773,0.4670640657682061},
{-0.8779465301764285,-0.026115789564365846,0.4780458719480792},
{-0.9513242196226892,-0.03369005494753457,0.3063449189343825},
{-0.6201399842406992,0.011220994264682826,0.7844109186094093},
{-0.19334504525558815,0.024812500873625486,0.9808170233410056},
{-0.7643295472603482,-0.08783180982792926,0.6388160270118007},
{-0.4861130691260536,-0.12418414034133708,0.8650273887643858},
{-0.557814563925444,-0.24221524594986332,0.7938354280971051},
{0.7265183178468408,-0.3962860077230627,0.5613631034507998},
{0.9848068996180513,0.16314487346410292,-0.05949050955457576},
{0.8311186114840441,-0.5066159332419696,-0.22930798030204463},
{0.8062822362587356,-0.5909382986057088,0.026474189970658427},
{0.8208338853103854,-0.3792149222716313,-0.42711564646214695},
{0.9037454603345535,-0.28087724970273553,-0.3230357774676249},
{0.9554125350292978,0.1326238350727188,-0.2638139614946393},
{0.9534201658027666,-0.041717838652437327,-0.2987467311600151},
{0.9433296578347453,0.16761567696638208,0.2864160286794083},
{0.5944956397700211,-0.1268805509156889,0.7940253522991346},
{0.25324845797831713,0.09487890355689696,0.9627373536907381},
{-0.17120151100828349,-0.435053834489319,0.8839786217576876},
{0.4039330473570271,-0.666761627530282,0.6263122426601887},
{0.8773862431900034,-0.18895896680937616,0.44100781072818374},
{0.94318054982007,0.020439135794805767,-0.3316514618829108},
{0.9893229572019994,-0.04113947017734728,-0.13981284042110775},
{0.7430768905176379,-0.643683108771077,0.1830540637665279},
{0.7628370104786873,-0.6331169424048104,-0.13131120547738018},
{0.9372505895578742,-0.2758379631200144,0.2132480960646984},
{0.6799021648034694,-0.5137235762346238,0.5232792118136019},
{0.13367364509183816,-0.45877058435742196,0.8784423188441065},
{-0.005489760790798931,-0.200171279664653,0.9797455390681169},
{-0.3471620112470835,0.11096042464611315,0.9312176556043351},
{-0.6937634269264538,0.2202142655001448,0.6857098400413214},
{-0.7674468331164415,-0.23167357111559364,0.5977898583834397},
{-0.5192100196760663,-0.538533172187281,0.6636286445911472},
{-0.04775964285907631,-0.5030600712738649,0.8629308090478098},
{0.3876855294998935,-0.23059123572048676,0.8924839562845296},
{0.5929101455315544,0.06886096258436607,0.8023189684643544},
{0.9364763194367145,0.2721424224375036,0.2212478362472997},
{0.9004408647838039,0.38010338485439465,-0.21148916248741256},
{0.8828628566503878,0.08876673248221179,-0.46116552728011695},
{0.9857437632508503,0.15957455137763302,-0.053340376495473456},
{0.7459937678781098,0.003693621634855767,0.66594268180245},
{0.03481440678487385,-0.15576667468055658,0.987180176127529},
{-0.5996155393701398,-0.34691416187744717,0.7211877489494152},
{-0.7227569587096692,-0.2975895708412659,0.6237490087873977},
{-0.7517115536319672,-0.36316714720959115,0.5504901119219684},
{-0.632340994076549,-0.3560967896085731,0.6879970520581824},
{-0.7471732387284453,-0.39413306890556915,0.5351553749362176},
{-0.8193896521849684,-0.4029515445098337,0.4077139323954187},
{-0.642831649414615,-0.046580252054037395,0.7645899231806993},
{-0.7039870882639185,-0.1394844594037781,0.6963808334112346},
{-0.6911177260208314,-0.11180007316899446,0.7140427385102395},
{-0.7201927162208468,-0.1473662062784073,0.6779422193296039},
{-0.7393676494845804,-0.21246834844145582,0.6388995850728084},
{-0.47961464973381457,0.1674663762618012,0.8613505677611475},
{-0.4365457716649582,0.14851048122168478,0.8873400848652956},
{-0.35092282276707565,0.12659640282431267,0.9278073740023475},
{-0.30511736325044125,-0.36189369834960866,0.8808724911915121},
{0.9575471120764132,-0.07157825934810229,-0.27924913776557386},
{0.8562335362732006,-0.00863016990590278,-0.5165168453482276},
{0.9295600515964365,0.182502305038912,-0.3203295477028527},
{0.8760500760261325,0.07504829781166182,-0.47634443136262195},
{0.8778263476431893,0.03786913596885159,-0.4774796665036023},
{0.8314175312328966,0.01624312621626061,-0.5554107035422688},
{0.13108283496980572,-0.11164571935810137,0.9850647307285397},
{-0.10325608460166522,0.06716224050925534,0.9923847109072724},
{0.073343034331462,0.3680438395341846,0.9269112856665352},
{0.22952763083065836,-0.12078782310514764,0.9657781155497284},
{-0.07633571622406068,0.27629190803306747,0.9580373896586744},
{-0.10978143721785084,0.8123108714380031,0.5727993402457925},
{-0.25226833674221105,0.5343167426625306,0.8067628553595049},
{-0.15652148293053175,-0.06995718905811492,0.9851938982151252},
{-0.10294328853543448,0.08908210534902708,0.9906901926697846},
{0.03574564941029955,0.010777808689639313,0.9993028006505764},
{0.3180917916718012,-0.2821458231916564,0.9051029480266463},
{0.2218740745095973,-0.392893492325228,0.8924161578260423},
{0.16045893640784317,-0.6648249658686353,0.7295619881028833},
{0.09175687504464054,-0.37248894628005563,0.9234893939733234},
{-0.29665302630173573,-0.27472497103843846,0.9146164071751341},
{-0.5236849018607255,0.025841281193654784,0.851520024279754},
{-0.33888158626793496,0.717869251747771,0.6081307490035539},
{-0.4783247217204451,0.26439022989451305,0.8374385153116529},
{-0.19660655627513826,-0.22197540744852282,0.9550250156502148},
{-0.26260940592199755,0.13833638100879617,0.9549342100954834},
{-0.2617814559749091,0.39035377485547934,0.8826632425584146},
{-0.22747890102109053,0.15343173900100532,0.9616194939046132},
{0.2622491220814501,-0.0059120435419047134,0.9649820960560186},
{0.48702136225285675,-0.018398524674695185,0.8731962477010345},
{0.5721153014739886,-0.33740910013362724,0.7475554701601366},
{0.4616825301768906,-0.6389226444745643,0.6153268202403452},
{0.3681021886476476,-0.5260618902366264,0.7666548547772193},
{0.1920855888483615,-0.7946086818994831,0.575934170896939},
{-0.0005890223125408952,-0.9543478679194802,0.29869683635796634},
{-0.012921987097411637,-0.797827422633175,0.6027473981229279},
{-0.1960270774556232,-0.7430331084046088,0.6399024806318475},
{-0.2249487992586342,-0.7026421360108683,0.675049676997318},
{-0.48313026600118714,-0.1645290991634288,0.8599507669640704},
{-0.5926099976076898,0.5318838390254722,0.6049074082195882},
{-0.5536211812268972,0.635945678718076,0.537658517478093},
{-0.5668083867319035,0.005211408850472617,0.8238331711870858},
{-0.356862293636768,-0.276520795432633,0.8922923024847906},
{-0.38719785262393336,0.26289340522062143,0.8837221737712148},
{-0.3542421534025354,0.6844441819203635,0.6372194744262756},
{-0.3690323066786433,0.06430923758651742,0.9271890198813187},
{-0.2814076471750871,-0.21713906831480237,0.9346980053058642},
{-0.22049889047727217,0.26395250083001226,0.9389937787886958},
{-0.2104967409889877,0.3792645596556072,0.9010269229175415},
{-0.014778001187227814,0.3685439200892801,0.9294928669151455},
{-0.007916604696152256,0.7025689009880958,0.7115716876987617},
{-0.1829067605368419,0.930349080435487,0.31779821504023903},
{-0.19403309968971044,0.969463982201229,-0.1499691416236625},
{-0.9187626685888379,-0.22349913394030993,0.3254585932733202},
{-0.9747737889678156,0.11691716875597517,0.1901221607057301},
{-0.9219906660017346,-0.20956509543591084,0.3256004953629758},
{-0.9339200533468689,-0.2161246484053939,0.2847515940398338},
{-0.9099349842814651,-0.2829653832973682,0.3032307969782477},
{-0.9486552901753925,-0.20714503714622245,0.23904826710924307},
{-0.7422864264169491,0.6611241724967795,0.1092048062019433},
{-0.6560413103287943,0.7509806971644545,-0.07508522909646445},
{-0.7837373352921942,0.5990648097340123,-0.16394249908868083},
{-0.9743078822148014,-0.024437937509617792,0.2238904595206886},
{-0.9120475499910448,-0.04611010275274667,0.4074838953620913},
{-0.9911841083994426,-0.04421441302272423,0.12489655294465907},
{-0.9923716947240078,-0.0413175385683804,0.11615197164599053},
{-0.9767132628917474,-0.08275144747711832,0.1979479730429132},
{-0.981821511112868,-0.14188738722913513,0.12607335032168318},
{-0.9330311960580894,-0.31553601245471513,0.17288670286227567},
{-0.9327722794707544,-0.3603862857449695,-0.007589446480345424},
{-0.9404058208727409,0.15933396942670963,0.3004156757817318},
{-0.6582034584384799,0.7048492736835265,0.26449141514882785},
{-0.8651188816480992,0.45467155459294256,0.21176189000851645},
{-0.8681169004577861,-0.3543233027591368,0.3476032857460115},
{-0.8699655724956161,0.4930212826483817,-0.009482485334520743},
{-0.8942739569502882,-0.29907487628758334,0.33290885883983456},
{-0.7193218849004035,0.6405121666201742,-0.2689241348686665},
{-0.9609946978657491,-0.05664431910717948,0.2707039190458861},
{-0.9199943749905711,0.39056808688448846,-0.03266373360623452},
{-0.7540713646390752,0.0035823244390372627,0.6567827220496716},
{-0.66713604466965,-0.08345518477559778,0.7402463981922542},
{-0.907910011037813,-0.03086317470360422,0.4180273631050165},
{-0.9403704730311653,-0.010947443318293401,0.33997577404270324},
{-0.9908245871946848,0.0312568228704972,0.13149010774398498},
{-0.8527235526196932,0.34458803193628185,-0.39258327913186664},
{-0.9119452496919492,0.31144518277618854,-0.26712873243025537},
{-0.9262985728970016,0.32786997024899445,-0.18566700422504193},
{-0.9954085892558325,-0.03504659206643606,0.08907006691499772},
{-0.907226588172907,-0.3652668345983886,-0.20861461419234303},
{-0.8869071417451927,-0.3602753287525865,-0.2891321659960861},
{-0.9338838006130596,-0.35567547224617857,-0.036823978532540796},
{-0.7811232659590225,-0.5826051640205722,0.22453878558964435},
{-0.924291171083341,-0.02252458618921523,0.38102293116607894},
{-0.6637960939593409,-0.6902174043498592,0.28805325961853806},
{-0.7156623774725616,-0.5635653352647576,0.4125790522533133},
{-0.8933400299697092,-0.28856074914181384,0.34449424510205434},
{-0.9656120172719226,-0.0014938042770059076,-0.2599830776201217},
{-0.9798769014561789,-0.1480029630377189,0.1339267744877528},
{-0.17379276244118683,-0.214834422154185,0.9610630815824414},
{-0.49076711406229134,-0.20806119293484773,0.8460840264119741},
{-0.4541968226302991,-0.5302159274269348,0.7159443530158863},
{-0.26876510210515764,-0.26757929018428367,0.9252927338712215},
{-0.958890555959126,-0.08309935431002881,-0.2713363208375437},
{-0.7002607685068214,-0.24502518612494797,0.6705203309778688},
{0.054212929662038244,-0.15826168427162887,0.9859078037772934},
{0.12548850874643463,-0.1802748379443409,0.9755786062520733},
{-0.021435677167095046,-0.23413140352660125,0.9719686196719789},
{0.13917789725138213,-0.24738274693480436,0.9588697979578219},
{0.006968940876877421,-0.5120131741661983,0.8589493252476008},
{0.09133010620686231,-0.9935678709564539,-0.06694548157495596},
{0.5636297064040475,-0.8242718500200735,0.05382816477804962},
{0.08059594226788064,0.3942744328845123,0.9154517822712176},
{0.45850450794956205,0.3271124113914912,0.8262996348199445},
{0.42354750871050606,0.1921858941319908,0.8852525571619723},
{0.6777746720241394,0.006857806034160529,0.735237692490645},
{0.6787957422987412,0.03540155241252477,0.7334732921680817},
{-0.7303547078173659,-0.22598849785676456,0.6446015820686862},
{-0.49717134729330636,0.05227505218302264,0.8660761920003462},
{-0.8157045521381284,0.20822286854062919,0.539693728551525},
{-0.9319255979116525,-0.028170573051872587,0.361553728747109},
{-0.984462588490311,0.1626848705429554,0.06608361944822908},
{-0.7748253168750113,0.43214562160540315,0.46140642611131666},
{-0.49716232348278194,0.2978873624030627,0.8149188569604633},
{0.021381290969057644,0.05837468416674906,0.9980657476564},
{-0.3454428437904352,-0.257122772478916,0.9025281832423475},
{-0.9390952643123782,-0.2953241854654343,0.17573761698976711},
{-0.9936848660349895,-0.07510356820937594,0.08336570670992036},
{-0.9859156870744575,0.08611235346697392,0.14336987326798872},
{-0.9344912089441638,-0.0876223268418456,0.3450340682380448},
{-0.7556771715076989,-0.011934442793586826,0.6548355377782504},
{-0.6504117617879581,-0.00545910126438712,0.7595622017591906},
{0.015473556567943081,-0.3366790259143906,0.9414923274018093},
{0.5386173745222269,0.2856446680397874,0.7926527912542937},
{0.23831851481987232,0.6197359560634383,-0.7477510483150032},
{0.10540269118368176,0.9150006974383117,-0.3894406198365043},
{0.22244787038954233,0.9127411854675365,-0.3426667087863564},
{0.3052316780092741,0.5722488847403301,-0.761160191190456},
{0.1339656069742839,0.567432325513254,-0.8124492427903619},
{0.15164877358892473,0.7826378280324744,-0.6037223530743135},
{0.3815408061340043,0.9002108355292447,-0.20987392608505112},
{0.47963849359463684,0.8772535654855778,-0.019315726885323705},
{0.5881568642427238,0.6372051334340509,-0.49803726865512726},
{0.4455595538126046,0.16746965293870625,-0.8794490316959261},
{0.1940243217924492,-0.6964277303818717,-0.6909001222377481},
{-0.07706426322013624,-0.7327131347744098,-0.6761601596244746},
{-0.15261882462756018,-0.728218320437303,-0.6681358934743555},
{-0.0648626806919396,-0.7120832296477889,-0.6990924879497918},
{0.37338253675891697,-0.8201966072362268,-0.4334316632661469},
{0.16132913404873556,-0.9479773117114144,-0.27443018599907126},
{-0.10722850614053152,-0.9748326059800598,-0.19545699728839408},
{0.08404740902228398,-0.8391869547420434,-0.5373093038720032},
{0.8318055118915683,-0.22196812532951604,-0.5087531245353745},
{0.028579077534105362,-0.9993460393665157,-0.022152424918228865},
{-0.002380547674168614,-0.9999915622886578,-0.0033478865363990896},
{-0.0018637605824744405,-0.9999982617717748,5.3384644071386443e-05},
{-0.08933254989246876,-0.9934788832486732,-0.0708477527426144},
{-0.011341842333833545,-0.9998570827579186,-0.01253701205627878},
{-0.016161192111048307,-0.9998449324781157,0.006994774291000242},
{-0.16481963295976637,-0.9647356994283324,0.20523040427659417},
{-0.2874373699526201,-0.9043975428877689,0.3153487637097807},
{-0.7100025513457592,-0.700689770417257,0.07021554468295614},
{-0.7557362286690424,-0.6304239657292838,-0.17728050121560335},
{-0.753452612430607,-0.6090209887241363,-0.24779547234557944},
{-0.3909752035929406,-0.9194183991884941,-0.042522904523629744},
{-0.037131325921736916,-0.9629287994028906,0.2671879337017327},
{0.15030785267160826,-0.6366643792504406,0.7563504595218418},
{0.36609842225991823,-0.47882806557064594,0.7979320953819767},
{0.05429302938979959,-0.42254431601463527,0.9047146334416187},
{-0.9294002352263592,0.18489970221144658,-0.3194171299152673},
{-0.9327859372869319,-0.16627703502437072,-0.3197848383260909},
{-0.7887569774804348,-0.6096790584289127,-0.07844664549337572},
{-0.38152050564206624,-0.8570421606382977,0.3462958831159568},
{-0.10243906649942544,-0.9943870766372662,0.026468461827578175},
{-0.06811525141791974,-0.9958510516059056,0.06034066240675112},
{0.008501510184787328,-0.9999382325271536,-0.007159291518715727},
{-0.04309953211187814,-0.9963671899276153,0.0734496641754378},
{0.10456507040333315,-0.9928633083195152,0.05734629058948229},
{0.21981834339493783,-0.965988792459954,0.13618204268134965},
{0.052684920029350504,-0.9984937268481615,0.015315895219347137},
{0.8705531176903138,-0.2291480215590881,0.43546349272382207},
{0.4690726204986337,-0.025717478844800856,0.8827850746248558},
{-0.7987408412024959,-0.1499062670170694,0.5827016215046398},
{-0.23065137029119284,-0.40126934773582446,0.886443938413739},
{0.10484005824152268,0.27257452836038215,0.956405608869495},
{0.42793420110261315,0.107495777997992,0.8973945493701612},
{0.5180957762010652,0.5823870128976166,0.6264200937795715},
{0.5448365981058721,0.650643940987749,0.5289759384134128},
{0.6366680314158081,0.5229980028865974,0.5666806038234855},
{0.8222479476202595,0.23189566742588602,0.519742928824793},
{0.652994257380424,-0.7550408538339886,0.05926051695547552},
{0.5906862786227295,-0.7728147328305325,0.23204979846339835},
{0.7351605288603268,-0.6597342343703295,0.15585164999318954},
{0.9024956838910464,-0.13195741857490736,0.4099863171388516},
{0.5429218279879909,0.5351169971700621,0.6472137885072244},
{0.5257757509756579,0.6962071568016469,0.48872840566530396},
{0.6193549221786624,0.4443176744229181,0.6472876366565892},
{0.6317419661668393,0.17800903212194752,0.7544633010734607},
{0.6812972510493376,0.14101184147237947,0.7182963986246795},
{0.6336049743883383,-0.0018088128899931555,0.7736546158501753},
{0.6134691625513415,-0.14695837832581124,0.7759244948050058},
{0.6710407341835348,-0.25813063976255407,0.6950344638089517},
{0.5651126300845725,-0.14403103292166852,0.8123440015624012},
{0.45960202651151827,-0.07998365129326933,0.8845160217612242},
{0.28882073486491533,-0.11371419748717407,0.950605945911311},
{0.19392608896835625,-0.20310946780934647,0.9597599783819083},
{-0.10828258690147123,-0.2451480225284498,0.9634196014324785},
{-0.011292943371648332,-0.15460119132981842,0.9879124156874463},
{-0.9292765110826166,-0.19349240526856124,0.3146519586042752},
{-0.13186614189372695,0.7858305663604693,-0.6042198619671878},
{0.17716661538859588,0.865189299714645,-0.46910496272266367},
{-0.22780480720444363,0.4918893266004207,-0.8403272339934789},
{-0.2836028505168165,0.3532457360559461,-0.8915082013851745},
{-0.143800576494084,0.2693199185201117,-0.9522542600000744},
{0.9802628095376935,0.12500285436496608,0.15316367270955228},
{0.9886623600482277,0.06132995194260362,-0.13705974908260446},
{0.5268661430834666,0.7846089844951462,0.3268039300893541},
{0.0010578554359422126,0.9745528976177108,-0.22415514869572023},
{0.521118073625236,0.8451220967506575,0.11918303119528145},
{0.050227752742143354,0.8233633166135393,-0.5652875566555722},
{0.5471354586426217,0.6926610927882259,-0.46996106267790794},
{-0.21722563936894626,0.23300485041872124,-0.9479038776595978},
{0.24003052292903224,0.6382707373835332,-0.7314340803259691},
{-0.20626114131033424,0.36956786060546765,-0.9060220405668152},
{0.2907586034885844,0.3345201226406656,-0.8964126962765767},
{0.9334252209504592,0.24908275488217838,0.25821529411305444},
{0.8193261620390345,0.011969570870912284,0.5732027299058786},
{0.9669163592798689,-0.19438714419664874,0.16518593259728562},
{0.5612483310541627,-0.5131560131695838,-0.649362161691621},
{0.6445684319177111,-0.32085158816724363,-0.6939638282689529},
{0.9735985274548089,0.18569887690598766,0.1327472578009907},
{0.6702048378671959,0.46576420649642725,0.5778314453594223},
{0.5275500163808858,0.5807384265724571,0.6200273059460155},
{-0.6956058761632924,-0.0988706120295708,-0.7115877086656263},
{-0.7849490675522715,-0.07808882592392481,-0.614619473019398},
{-0.6341026327907755,-0.026327763760757614,-0.7728005563812469},
{-0.562144737096123,-0.06649083245530309,-0.8243617311317476},
{-0.5074079191525896,-0.015955032450969263,-0.8615582629867394},
{-0.5345476675733748,0.05972354665514572,-0.8430254379713554},
{-0.6258073318378432,0.061108038020846404,-0.77758021522364},
{-0.7995959320137855,0.00407695243957193,-0.6005245406857335},
{-0.768595295822871,-0.049822817802132324,-0.6377922530614566},
{-0.6506321545570639,-0.06885922950748127,-0.7562646401677583},
{-0.5874875543239941,-0.1119924329022197,-0.8014462355561064},
{-0.4491508014351846,-0.08701815196062572,-0.8892082988813638},
{-0.44716803103069813,-0.046950864918363956,-0.8932168652166987},
{-0.35218549937254134,-0.012901407917225596,-0.9358412940800738},
{-0.3833791464309378,0.0526335784158554,-0.9220900913170185},
{-0.40145209996787484,0.1633733198630479,-0.9011910839485207},
{-0.5339519890434439,0.1405637584071629,-0.8337488250180642},
{-0.7056437083651814,0.11300274365380546,-0.6994979176318875},
{-0.8150563105247388,0.03305909708792768,-0.5784378158225235},
{-0.753742378125169,-0.004119295688485958,-0.6571571036070795},
{-0.675326004697881,-0.029658409640061986,-0.7369227680811742},
{-0.5874509904216116,-0.026476930699689663,-0.8088264993145263},
{-0.5073208932467087,-0.04919649990218168,-0.8603517976227725},
{-0.38450256609781397,-0.08533173372231868,-0.9191715138558958},
{-0.4353294090679503,-0.13964522320392384,-0.889374790083953},
{-0.2739586964952528,-0.1134272609954145,-0.9550292608489543},
{-0.2818753092311402,-0.06975579768391241,-0.9569119284110373},
{-0.21292783162224713,-0.01720291723862941,-0.9769164745049236},
{-0.25662297788264243,0.02246306129123096,-0.9662505151874804},
{-0.22833470916170787,0.06612590570366307,-0.9713344558837129},
{-0.29863473315422,0.11917913638507228,-0.9468968421134458},
{-0.26191594626545733,0.20315034431064555,-0.9434669971431624},
{-0.2620502087521758,0.2710881396865788,-0.9261970139307355},
{-0.3780766970243866,0.2812235101567549,-0.8820268411461432},
{-0.476608919641507,0.2201144036767349,-0.8511131458344366},
{-0.5793744949305885,0.22808119805724514,-0.7824986656325346},
{-0.6552839980010634,0.2780935116748234,-0.7023296097475223},
{-0.7611844518999975,0.16266213765068535,-0.6278051124040085},
{-0.8372879740395921,0.12139005510209369,-0.5331165942371199},
{-0.5317350959122576,0.14439381961918157,-0.8345107624416629},
{-0.6533938124887844,0.07508648530296248,-0.7532851687948059},
{-0.660347357400012,0.03509465078456224,-0.7501398090097141},
{-0.38452514319867964,0.04963504838303323,-0.9217791363553683},
{-0.2215018151863721,0.09209938834085177,-0.9708010344743063},
{-0.42006211271252525,0.04572191236445222,-0.906342831489954},
{-0.2960192252038538,0.01749368814287141,-0.9550217741941123},
{-0.06855432321450987,0.12019745823620259,-0.9903801673105924},
{-0.653999805564411,-0.03128659952647666,-0.755847473377918},
{-0.5787620675688563,-0.035452168099833856,-0.8147254831662281},
{-0.5182284316065294,-0.056412873682036964,-0.853379681242512},
{-0.42130151096587753,-0.07172491383882233,-0.9040799597340282},
{-0.27362666540346164,-0.16798794315212306,-0.9470525322999253},
{-0.13992007879506443,-0.13923577784703137,-0.9803243186401708},
{-0.1456292394404627,-0.10752735949629064,-0.9834785160743206},
{-0.1311033177460539,-0.06483559632814906,-0.9892463118580481},
{-0.04718064777414528,-0.018102470117508592,-0.9987223273018665},
{-0.1344330518730184,0.029745497486841747,-0.9904761279018118},
{-0.0918062352295083,0.09278704460243098,-0.9914444913997609},
{-0.17102780676962973,0.13901285785079237,-0.9754101263897794},
{-0.1387676335118833,0.2245693226470449,-0.9645269116076333},
{-0.09126689312085907,0.3196229421664945,-0.9431391885935498},
{-0.16047336943719132,0.40687777717342194,-0.8992768050738826},
{-0.2974656688695922,0.39901446593436685,-0.8673532335900282},
{-0.38313383052205036,0.4111709586521539,-0.8271317371921897},
{-0.46984030490449935,0.3459305993337144,-0.8121466051962934},
{-0.5761895925680655,0.30482475942246373,-0.7583451848988586},
{-0.6499901386551797,0.30335782922938576,-0.696768862031201},
{-0.6385522378552525,0.30799933010511577,-0.7052570114396942},
{-0.8306718817062319,0.17844612292540438,-0.5273909424284033},
{-0.8467596753805233,0.2636263757083149,-0.46205972144341834},
{-0.6279309727227673,0.34273537886824174,-0.69873825826806},
{-0.506084214204555,0.3625086997036551,-0.7826022046813587},
{-0.6376783395388941,0.2759042443335329,-0.7191962063593363},
{-0.7391492491068242,0.21285299044707998,-0.6390242499330939},
{-0.41270022240035514,0.14316886471899312,-0.8995449975436315},
{0.003938762905069812,0.11355704242364228,-0.9935236707108557},
{0.20500319961706648,0.14419731837693997,-0.9680809994621651},
{0.3450910203168757,0.19600502727666988,-0.9178748373165753},
{0.12570928112267804,0.2922334256868614,-0.9480489447021927},
{0.08724579160667248,0.22570650944725265,-0.9702807549570704},
{-0.2585720275420959,0.14044322788988323,-0.955728102711561},
{0.41760361825218506,0.3409819617697022,-0.8422223695499714},
{-0.04074385078070979,0.173037469648882,-0.9840721379660495},
{-0.47104446170027314,-0.07346639834292232,-0.8790448244634735},
{-0.423978269060125,-0.12087274237242841,-0.8975701685752199},
{-0.46598350417487233,-0.19488621211099574,-0.8630635771285536},
{-0.3108429202603696,-0.10933015080867972,-0.94415231665667},
{0.5427035625443616,0.8039943761399337,0.24303474306571254},
{0.3233598631842006,0.9354888925864464,-0.14247431603232585},
{0.4991076401975992,-0.6497793623260689,-0.5733047564703356},
{-0.23791770526314074,-0.28243045575173165,-0.9293159867268992},
{-0.2028989845658118,-0.011746589044850785,-0.9791292150211707},
{0.4818740011428216,-0.6311665875047116,-0.6078043976809195},
{-0.23371706386751842,0.05184354758032446,-0.9709215110560858},
{-0.5227415243852315,0.2935116219899282,-0.800370055936781},
{-0.6017470934261491,0.29423779089934377,-0.7425123284901439},
{-0.8340427927302092,0.283309187145404,-0.473401018560167},
{0.3368923558905048,-0.3480861966620527,-0.8748368649273374},
{0.6226103301830475,-0.5869278151400252,-0.517563635280062},
{0.5913317519179314,-0.7063335205317128,-0.3891268648486591},
{0.08340621174121787,-0.13652980638117387,-0.9871185419251826},
{-0.5142960124767119,0.2378232631398556,-0.8239779772906949},
{-0.47788848252154587,0.2639377551824883,-0.83783020932793},
{-0.7140803878506277,0.34885451759262615,-0.6069511720413043},
{-0.8597796278770633,0.3204903042454689,-0.39757383763550797},
{-0.9765468772528711,0.21239801735989067,0.03526015810023172},
{-0.9111080310813452,-0.02745089737748909,0.4112524819770027},
{-0.7429033517566143,0.059831012922259265,0.666719476122818},
{-0.8675482237477818,0.07467245656367115,0.4917154702699673},
{0.6006537008356297,0.1277038951905263,0.7892444784891618},
{-0.3081199139842063,0.5547739181411138,0.7728441099967845},
{-0.3434523039146273,0.5863911877966723,0.7336115387656755},
{-0.12832116516055708,0.4083387766515681,0.9037660770655965},
{0.5180890856731795,-1.8951578353109685e-05,0.8553266621280823},
{0.11046402127709072,0.38795548157115145,0.9150345590862624},
{0.8325483269716654,0.14806679060414885,0.5337972543736696},
{0.1995314101630724,0.40041731103729045,0.894345119839093},
{0.8247054066837332,0.25597099078888846,0.5043211715377145},
{0.7753225730009833,0.34736673760298103,0.5274573512637745},
{0.0654154761680916,0.3602021098362061,0.9305779148181239},
{0.1242287219946743,0.032814727755464554,0.9917108541676372},
{0.8245874185171633,-0.28535271632040854,0.48849709979872424},
{0.8316186489329834,-0.007579889965440976,0.5552953880728628},
{0.71550577665354,0.21706273384508196,0.6640295574378551},
{-0.281705943345405,-0.702918962221323,0.6531054233686732},
{-0.48835284123785516,-0.7926036563153481,0.36509032642683875},
{-0.48315662547065,-0.754927432425164,0.4434458783614561},
{-0.32323932811338063,-0.8593842931028394,0.39620067330702924},
{-0.2192793383855848,-0.8697633891990204,0.44207263946801045},
{0.0034772317462127694,-0.7190124463112938,0.6949884969615195},
{0.09964866239293943,-0.26330175454435983,0.9595531929690817},
{0.1467534033291334,-0.046302668160387944,0.988088812573316},
{0.28055480232291474,-0.03857857848083537,0.9590624047349308},
{0.1973477515597993,0.23000817743386456,0.9529690988000836},
{0.2276463885856462,0.5204258558826071,0.82300306821589},
{0.13330928010830678,0.5159401968063785,0.8461881287021228},
{0.0512877048065246,0.4528270014514047,0.8901220579741906},
{0.10150372840479303,0.39206726739466496,0.9143195562589737},
{0.3152035058003059,0.3464741121882541,0.8835170850156536},
{0.34980044232001634,0.42208763586282927,0.8363502126528386},
{0.2628878471329967,0.4809405721708908,0.8364126648190559},
{0.11188738281913635,0.5478203790422079,0.8290802409127451},
{0.00573420003373886,0.5322430808397579,0.8465721598589078},
{-0.20133800516273997,0.5962804362084708,0.7771181693102563},
{-0.710350270387643,0.3995023261240812,-0.5794828597824536},
{-0.9244043798268049,0.18380323179287256,-0.3342048990357795},
{-0.8682581006565748,0.2434411071821184,-0.43227803318949887},
{-0.6613349209497859,0.35350611374639024,-0.6615659830102096},
{-0.7660326661132066,0.19703494097715485,-0.611858796195349},
{-0.9779017921839769,0.03494754661741779,-0.20612315209308565},
{-0.9700064928232307,0.15149325776080066,-0.19009786093955733},
{-0.9082053380583011,0.2984923307905371,-0.29336903787148305},
{-0.7934945463209434,0.42820938905566486,-0.4324385783940821},
{-0.6114360954011402,0.50190260807294,-0.6117513165087498},
{-0.7967367113537939,0.2945131851105747,-0.5277050280006487},
{-0.8914290866096171,0.13280941925945805,-0.4332618627369705},
{-0.877224910067865,0.12128095155486857,-0.464507683409405},
{-0.9604509583882553,-0.010032055582446048,-0.2782684214780266},
{-0.9243242758699662,-0.04099562231674401,-0.37939951500802627},
{-0.6911467972217015,-0.006922937553355079,-0.7226812420602992},
{-0.9621321779733368,-0.039460632139273956,-0.2697119400758007},
{-0.8535324273102763,-0.00393798643293877,-0.5210248437384554},
{-0.9397884755555943,0.0689661330665047,-0.3347256991967385},
{-0.8261147857382357,0.31957171392578415,-0.46412097608619834},
{-0.7852626654666991,0.4354834719571848,-0.4401325844291137},
{-0.6471601845634419,0.6185338406881089,-0.4456451317353628},
{-0.6681718676756655,0.6286000977961045,-0.3980053671717764},
{-0.6279348552137572,0.6065073014424155,-0.4876953053954044},
{-0.532835044403924,0.6073759452582136,-0.5892209064321798},
{-0.7780159742988259,0.27598841920393413,-0.5643771223226206},
{-0.6485116318208427,0.37076983618822673,-0.664802521028631},
{-0.7760407586708123,0.15464660974532443,-0.6114287914188433},
{-0.900548534152482,-0.04250315227457319,-0.4326728783764247},
{-0.22974121474003362,0.5316837671027764,0.8151879206963106},
{-0.055054865161857786,0.4781213936752164,0.8765665375384109},
{-0.20115824947131455,0.5003899698459173,0.8421076158943335},
{-0.13480516343831336,0.45984243859210366,0.8777086644098012},
{-0.21346735563095398,0.40101405645786653,0.8908531947538464},
{-0.21799579290834545,0.47885851574151744,0.8503954116621825},
{-0.6137519489490945,0.4702485672448211,0.6341725555125993},
{-0.2821935788273252,0.4407257685579707,0.8521311994039487},
{-0.09349755344173606,0.4126908748955979,0.9060598486183546},
{-0.09701907810302668,0.36668421968166853,0.9252729227209043},
{-0.19829938565161134,0.3336789911921964,0.9215940996377698},
{-0.03621799471372586,0.3830362735723119,0.9230230062066458},
{0.30584065956092854,-0.22102993558691106,0.9260708712262697},
{0.15063361601303796,-0.27470843699826647,0.9496550891606942},
{0.1384273702649086,-0.19622902576244317,0.9707378804856975},
{0.05642977579575217,-0.25179769531717755,0.9661333246693228},
{0.2252541215211322,-0.1666694891635024,0.959938467882041},
{0.45580692845572474,-0.13619125466783324,0.8795976273977546},
{0.44351454034015797,-0.12791069377488298,0.8870928400820776},
{-0.15409971736786382,-0.08652444783753374,0.9842595171160674},
{-0.6065515201849226,-0.07097995834881678,0.7918693698294939},
{-0.2547472847793133,0.0465914581898061,0.9658845981385743},
{-0.07961525714980072,0.06349145135107426,0.9948016115961539},
{-0.02385237981320462,0.05506699923044331,0.9981977206811289},
{-0.12848315374838154,0.015062784136153872,0.9915972931270725},
{-0.3424268888439767,-0.026897643568023273,0.9391593808119698},
{-0.3455573195322576,-0.14083530138867853,0.9277691290404316},
{-0.5627317636070442,-0.3502522419694548,0.7487698773475574},
{-0.7093708794010734,-0.185407789774062,0.6800124314663998},
{-0.6323557101068519,-0.541049487921004,0.5544291726773388},
{0.25968741517075433,-0.9553170900188702,0.1411796866401469},
{0.39851306089340083,-0.8983296033577538,0.18490879921862402},
{0.11498431494352149,-0.978385640947147,-0.1718724669788887},
{0.2504070728895327,-0.8496256881414115,-0.46414705417262886},
{0.7282905910583297,-0.6690794439948485,-0.14807265986485416},
{-0.6650731714472746,-0.09337870801758322,0.7409170625043203},
{-0.7339042826680676,-0.2591780180894555,0.6278624521507008},
{-0.686494207720434,-0.20179595248913196,0.6985728997930692},
{-0.5791624898156638,-0.09070650319536695,0.8101500729300654},
{-0.427271834517079,-0.31887348665691445,0.8460251053814376},
{-0.6486774780371355,-0.41531767843597284,0.6377528953018836},
{-0.7313652652575775,-0.32788005540674847,0.5979962525310514},
{-0.571127656648935,0.038981878844486985,0.8199351272707189},
{-0.6575285102479133,-0.10256229897594328,0.746416259897873},
{-0.6863302214321663,-0.133584173121942,0.714916845402457},
{-0.7113263241114381,-0.20328110412870262,0.6728236420714755},
{-0.6862322360022859,-0.2063308954456969,0.6975047525686686},
{-0.5059591354108433,-0.173411762862471,0.8449459827676808},
{-0.0746717553550479,-0.2684539773786316,0.9603939769603873},
{0.9517508235686682,-0.20225534572707835,-0.23078809536278477},
{0.8756950455701813,-0.3129732195027754,0.3677036184726851},
{-0.45822043397205536,-0.10199866914190711,0.8829667634649342},
{-0.5462926838987138,0.025444225833485844,0.837207796721026},
{-0.6709040769346061,-0.0880856571065743,0.7362938520486418},
{-0.686712010162704,-0.14755124040112105,0.7117971948205395},
{-0.7366830183695139,-0.14776741074824526,0.6598961454401305},
{-0.6968342227435086,-0.1309453832246475,0.7051775468813511},
{-0.6681750489219423,-0.04456019898028131,0.7426684944610196},
{-0.7311885053346077,-0.28893580415270503,0.6179639720446265},
{-0.7151058204535812,-0.20416228142814824,0.6685367816324425},
{-0.6804268518925131,-0.22371556127144138,0.6978328215759474},
{-0.11919535803487057,0.2607393420166694,0.9580226835245882},
{0.8901142260739524,0.3249774942175103,0.3195094564999241},
{0.9060026014401789,0.1271197931852287,-0.40373239201750083},
{0.9179775875457832,-0.016128791752725365,-0.39630418978383397},
{0.8881660905449068,0.06218284975363618,-0.45529582559330933},
{0.8957555791966212,0.30716504173019477,0.32135895736234477},
{-0.9880095660791203,-0.0962958873506524,-0.12068222493598307},
{-0.9340242950992383,-0.26758537384923475,-0.23663618460906652},
{-0.9139716558466365,-0.11577330729695537,-0.3889117555776403},
{-0.7796716005365114,-0.16727126284879257,-0.6034339399982442},
{-0.8582659407818248,-0.28066873258757163,-0.4296564178987383},
{-0.9430995346053496,-0.2957354337503165,-0.1519994113530886},
{-0.9366615940784745,-0.347238437083734,0.045722270175667844},
{-0.9737123986369013,-0.17465772924386488,0.146215055162418},
{0.40505383902158576,-0.5855189027213488,0.7022100839847454},
{0.35012710627491905,-0.8475408738452799,0.39885520757930526},
{0.33474576726565836,-0.6753490253550263,0.6571521629346903},
{0.40695194986061145,-0.19672740796662522,0.8920136980222778},
{0.39410481008785847,0.027694337330293143,0.9186481493724619},
{0.27784131854671573,0.13800181612281393,0.9506627690485346},
{0.2806578213468709,-0.23547369222838968,0.9304747861093055},
{0.34817089760474534,-0.7268769018017316,0.5919687455332601},
{0.31804243303327195,-0.7421383632440463,0.5899827629615333},
{0.41294112731449345,-0.771500693390124,0.48401064603042915},
{0.5137859494872028,-0.6125559263516624,0.6006656600813717},
{0.5141520561046607,-0.35786841137624537,0.7794728111630271},
{0.5105203202079646,-0.589518506496423,0.6259687956703469},
{0.4745130149693115,-0.46641405019439175,0.7465221580140788},
{0.42585898570837954,-0.4370893979301615,0.7922101883392305},
{0.757170707762314,0.11249473698043279,0.6434574216359772},
{0.387864893112865,0.8374817797554596,0.3849481695867299},
{0.13524078286650545,0.586616540516295,0.7984929336207984},
{0.14264735443487805,0.5029187419006065,0.8524813612729849},
{0.7464210896198915,0.4777002451518279,0.4633120252621741},
{0.6756871537070603,0.5387229745086084,0.5032140966346714},
{0.31253236961799213,0.5506683910242641,0.7740076492307495},
{0.10728670591915683,-0.7857386538459342,0.6091833308499138},
{0.24259344139327052,-0.6694879801927947,0.7020927763268483},
{0.29855115835873924,-0.46794691050874393,0.8318009947024448},
{0.36324657415527745,-0.5313303833097742,0.7653364947108839},
{0.5187929531417858,-0.6615738300286986,0.5414553898444298},
{0.5322995238788375,-0.7629158869931323,0.36690130314819697},
{0.6055435715198529,-0.7352491093386391,0.30450899856608277},
{0.5777966120035128,-0.6371425538176435,0.5100984623305518},
{0.5024341101540544,-0.2721256875582038,0.8206750728057228},
{0.5371722579684102,-0.1368779275493656,0.83229225529192},
{0.5505086831779235,-0.3144014052510867,0.7733640450149275},
{0.5227752023552484,-0.3844012424542322,0.7608822330703167},
{0.4682391276807912,-0.3222441129839243,0.8227459212636278},
{0.5450435091118847,-0.10934379971237515,0.831246958875317},
{0.756948258025749,0.6529966978654417,0.024992943976511858},
{0.6425568362403916,0.7649546586398103,-0.04432925023040415},
{0.4104751612853137,0.8309640084465388,0.37551159587189314},
{0.12803610619020103,0.828722417228564,0.5448173186440548},
{-0.10910496401014987,0.7595582195188383,0.641223376047471},
{0.6954013048500856,0.3552844703717327,0.6246518793099688},
{0.5856905004786759,0.39569857901965766,0.7073819846524663},
{0.6284193574173724,0.4892277589539301,0.6047688079688402},
{0.2193735001171478,0.603206290975578,0.7668229508653469},
{-0.18101072867588147,0.6776380862314737,0.7127704680980914},
{-0.02281174585683812,-0.8775437089985968,0.4789537170207043},
{-0.06898754758917994,-0.8638503697436883,0.4990022614891877},
{0.4849044066203049,-0.6722484223266524,0.5594191408233514},
{0.6525375504154686,-0.5963688194822834,0.46748152524681424},
{0.6168539275999162,-0.6936851871989365,0.3718764486564506},
{0.6237556555141966,-0.6587217025620445,0.4207310314058334},
{0.30764125733007364,-0.5578025844904881,0.7708522125051618},
{-0.6935763936274563,-0.3199920364233465,0.645412180570193},
{0.16523769344363884,-0.4528210299484287,0.876156161595563},
{-0.5144518766281568,0.8066926131586013,-0.2908372302665442},
{-0.9769265665293665,-0.026075746706443203,0.21197768524739702},
{-0.5302887981951109,0.7144286919500556,-0.4564925351277032},
{-0.6769461999134777,0.6714933329040688,-0.3013976547488174},
{-0.9735626801013761,0.21471168131203183,-0.07793973198559491},
{-0.5395780843499356,0.5601886579990317,-0.6285253840048926},
{-0.9836957803707199,0.08618997146067475,0.15784137765633025},
{-0.954908109519618,-0.06373352052689825,0.28998024197333966},
{-0.9795592862049489,-0.17210221221643085,0.1041366091240806},
{-0.8641814448839001,0.49508088205532713,-0.08991857728908963},
{-0.14477979833678453,0.9562113042090481,-0.25435949303375965},
{-0.881185969088801,0.4421312188609083,-0.16742542575606129},
{-0.914279011046314,0.3826554828020946,-0.1329235548789977},
{-0.9945081339951513,-0.042383651309869555,0.09569324698810085},
{-0.9624441494737215,-0.12938484761917018,0.23866466087456065},
{-0.9947913691869325,0.011064973929438494,0.10132965085861627},
{-0.9125945723342546,0.29494903932320166,-0.28315404067111494},
{-0.9437041337488107,-0.024174990521611754,0.3299061651116672},
{-0.9948531032178016,0.07700977798931821,0.06585436289226436},
{-0.9949539225159867,0.0958143213688274,-0.029770923577932824},
{-0.9940134142048014,0.10621145405653272,-0.02562146381671338},
{-0.9906379751209449,0.1282031958903173,-0.0469078118417738},
{-0.9897981822166612,0.0934417657557759,0.1075555432929242},
{-0.993735824501363,-0.002562591323519263,0.11172530701817283},
{-0.9408068817847547,0.0037776481439152076,0.33892202725840564},
{-0.9484838333838027,0.04875646016538394,0.3130514740449379},
{0.19622522111612423,-0.08516171892940576,0.976853696428957},
{0.22983075645302165,-0.23513964769399306,0.9443977813774114},
{0.011909772292270382,-0.14143257421943972,0.9898762469488845},
{0.6611930066298568,-0.13334904126776503,0.7382694908884818},
{0.21303177190524722,-0.3583345298962994,0.9089630514178829},
{0.7729716885307565,-0.21041965714231886,0.5985301467913043},
{0.88224696111155,0.12309171572080296,0.4544103092254225},
{0.8281242048928324,-0.20273818189934567,0.5225969105063307},
{0.5154419810469584,-0.4438798997989366,0.7330008176863605},
{0.14518966213429169,-0.2357744584797211,0.9609008100412469},
{-0.11751291484230832,-0.274629308777866,0.9543424215686191},
{0.12803156396462112,-0.30205317989595226,0.9446543257422351},
{0.0908901923020778,0.6748753087931649,-0.7323129730686339},
{0.005781624335968428,0.7591089004899714,-0.6509379770891728},
{-0.25301067911936,0.7580363693817704,-0.6011376372729164},
{0.35629053637785274,-0.073475484082617,-0.9314818339218469},
{-0.7303693167833818,0.32971481520008517,-0.5982046487105811},
{-0.4757884816607154,0.6546288544838874,-0.5874405362214157},
{-0.2218086857344734,0.7098651932639936,-0.6685000481114558},
{0.02255612098588016,0.6948472697680362,-0.7188035149482618},
{0.0954613655833771,0.7224120253746635,-0.684841582612383},
{0.3465384564071189,-0.5831355365953192,-0.7347544108004118},
{0.4138779358074537,-0.713898889659004,-0.5648481473771533},
{0.6430943832783194,-0.7482304317715747,-0.16303630015061307},
{0.8962800755516224,-0.38576084621781936,-0.2187935001193822},
{0.5686218855416943,-0.2185534427934586,-0.7930343901282811},
{0.673636204713532,-0.13621729528732154,-0.7264014813887394},
{-0.7434534718989486,-0.35458226149435,-0.5670523388144622},
{0.1230961330647827,0.5797661973426199,-0.8054306291937101},
{0.11780396161308886,0.6051444739715474,-0.7873515048883575},
{0.6862451096457617,-0.47576793067612067,0.5501931711930261},
{0.34761951306984146,-0.5997668416273306,0.7207221446698184},
{0.22300741575016064,-0.39029508478164454,0.8932734403953383},
{0.8080985050537058,-0.3379677094805619,0.48244650841148007},
{0.059663435972916706,-0.3872863386077679,0.920026937831548},
{-0.6607563443179422,-0.17958788802802222,0.7287998654755801},
{-0.6363124891365111,-0.4322461335797265,0.6389598549003487},
{0.0010790557636592998,-0.9999276498348632,0.011980431310520226},
{0.049000705896721494,-0.9973284080078896,0.054175431720212865},
{0.3447559922880042,-0.6037342460670944,0.718782488592558},
{0.6667398646758614,-0.28802583927522113,0.687385676866938},
{-0.371265997660369,-0.02767362654123401,0.9281140713162942},
{-0.5895633971834712,-0.20074763749702793,0.7823780331405314},
{-0.31938854942460837,-0.8547812170763202,0.40907215186317597},
{0.12022354384942681,-0.9911538054559852,0.056217732384044844},
{0.1695407862673852,-0.9854705433480044,0.010184791859712019},
{0.04609116998669736,-0.9943129171471351,0.09600743118952773},
{-0.1302795374971678,0.5735036966025425,0.8087773192249786},
{0.31670699984460937,-0.009732038852552463,-0.9484734912843896},
{0.7352941051561848,-0.0771525096034256,-0.6733424605536612},
{0.6872139303702841,-0.04940391647343347,-0.7247732520879288},
{-0.46229751362078075,0.07474512640632242,-0.8835689984254467},
{0.31002347540501224,0.045906069619380256,-0.9496199647595339},
{0.7115465411903257,-0.026407541231024775,-0.7021425506876904},
{0.7049881759072884,-0.06440084484789099,-0.7062890364530602},
{0.7059078592648453,-0.11373267949659495,-0.6991129893247929},
{0.3599102620581527,-0.08050465400901369,-0.9295071833762883},
{-0.6939766286253592,0.07602299507667627,-0.7159727251378726},
{-0.6200370730181102,0.11037249510625913,-0.7767701979396182},
{-0.5651520307384782,0.14915747510330082,-0.8113909229052185},
{0.49616127804144416,0.06691983380588493,-0.8656475737941356},
{0.8015532372570118,0.013706029314650793,-0.5977663026662096},
{0.7626612428143936,0.015788422653010233,-0.6466054085908456},
{0.4282699018976292,0.07598384654165838,-0.900450635067425},
{0.41717404846008727,0.0038322302128312087,-0.9088185337585368},
{0.5391178959733223,-0.07259540017948035,-0.8390958241548334},
{0.5821440268792569,-0.12961907365461736,-0.8026875031503367},
{0.7041006311179859,-0.16297580220423763,-0.6911448394910717},
{-0.3259612420725027,-0.052489548213340835,-0.9439248465820309},
{0.41397374285642546,-0.175165977538622,-0.8932763405231223},
{-0.8259789059649548,0.07454839679312328,-0.5587498397641929},
{-0.6438619221658031,0.11816018196335032,-0.7559629597958787},
{-0.0655877777981318,0.11777595838633155,-0.9908718721558727},
{-0.4390368375392633,0.14218560513531953,-0.8871470616396278},
{-0.4275260456073656,0.2052517773343407,-0.8803937688491571},
{-0.2582098880313714,0.23597158826777248,-0.9368271255963992},
{0.8002452215850302,0.03028952576996396,-0.5989074469055772},
{0.8057632512587083,0.009534777495655504,-0.5921610177469504},
{0.17703636954130716,-0.09182453710234492,-0.9799114134683675},
{0.45929485894145405,-0.1798427378295702,-0.8698878216183477},
{0.7095442329878697,-0.19019343519794055,-0.6785082450797946},
{0.7004373545211402,-0.1857001534541232,-0.6891320377101485},
{-0.6840983694618261,-0.0023771025793726955,-0.7293858857168802},
{-0.874351702074568,0.05626673472688635,-0.48201987058883783},
{-0.8483481693756998,0.08690211617357174,-0.5222579877047875},
{-0.5944094403397089,0.13247580260547448,-0.793175629327496},
{-0.16090446538663328,0.17431060375979035,-0.9714553857154424},
{0.1483571885671667,0.15557592356463473,-0.976619821940686},
{0.1652361334127839,0.1371491445058943,-0.976671455698432},
{-0.37079821384887596,0.08793203990247737,-0.9245413138227369},
{-0.3791981018090008,0.0859574057315884,-0.9213143459125912},
{-0.512325831889214,0.10581692162875886,-0.8522470422806042},
{-0.7795689914462056,0.15904837733770796,-0.605785276514532},
{-0.6973237156467615,0.2222602729915942,-0.681424982405471},
{-0.19106188229434604,0.21290666304636768,-0.9582098465182886},
{0.740475191719243,0.059956758321939876,-0.6694039718883319},
{-0.6949631077156462,0.11895792236215591,-0.7091370048315702},
{0.22504383753819307,-0.6384525534493014,-0.7360255485919971},
{-0.22181803963079932,-0.1995546413541647,-0.9544499475658008},
{0.26995849275064865,-0.06349487099861584,-0.9607761516340145},
{-0.5509345080775436,-0.5489624331256429,-0.6285788851259078},
{-0.6415860661169537,-0.46014889425199657,-0.6137021385682445},
{-0.18091937696945104,-0.31957651259659886,-0.9301285027530237},
{-0.5102987588939822,-0.699123252080264,-0.5008211807341787},
{-0.21498693154696197,-0.556991040964338,-0.8022104459239391},
{0.5397544071061045,0.25606779488207393,-0.8019317080860252},
{0.5144080400263683,0.13645028465817363,-0.8466201557799894},
{0.48889020499773445,0.10314638566806171,-0.8662258311669587},
{0.02331340984902765,-0.034072952496905055,-0.9991473959478426},
{-0.5761746601024059,-0.19654121724563237,-0.7933437533500104},
{-0.7174717890604775,-0.2236169198604152,-0.6597194138832798},
{-0.19015793609420845,-0.1366488502281121,-0.9721970227642779},
{0.12904069378478136,0.06476985595012141,-0.9895217860702931},
{0.30718097577185893,0.01711555868500635,-0.9514971916799065},
{0.2772983219819223,-0.20666913460735223,-0.9382928697515815},
{-0.48853904309317325,-0.8046779554146499,-0.3373766314422285},
{-0.371754901553994,-0.8292595917702871,-0.4172850615916617},
{0.47490914952719365,0.06644036507298832,-0.8775232062938995},
{0.5326727407794055,0.17403759459781806,-0.8282334615898839},
{0.4447539984865478,0.05388467431815898,-0.8940303813091889},
{0.4546683847186927,0.009916825256499602,-0.8906055897613302},
{0.34083436626861247,-0.6468363220440492,0.6822277532135442},
{0.03804077059308957,-0.7195881205842929,0.6933583752192293},
{0.1848200050603816,-0.4522915210587831,0.8725101407478386},
{0.8007775856674665,-0.11390137048791492,-0.5880320876394061},
{0.9698054758465796,-0.08101519657753722,0.23003016528597336},
{0.23699655601901973,-0.4539218485017979,0.8589456256875837},
{0.09795386207666232,-0.3085408547366732,0.9461541004839695},
{0.041274775666660435,-0.4162309011902145,0.9083216554657544},
{0.1790986406198089,-0.8783560899011368,0.4431864802334598},
{0.7403029903518503,-0.4711491359895588,-0.4795518471785926},
{0.17978738715089826,-0.9678789214263266,-0.17574666107799536},
{0.6774254399171324,-0.05961068496622552,-0.7331721077557007},
{0.6261524730179845,0.3487522917070423,-0.6973556621714261},
{0.6896199686320567,0.634713359227269,-0.3486592182667155},
{0.6298893667458146,-0.33299931902903696,0.7016771616539578},
{0.39689382557179764,-0.5692061359334872,0.7200553215126265},
{0.5538190800743558,-0.4466890085977688,0.7026758542482706},
{0.7625363837463182,-0.006197210188533373,0.6469156498717333},
{0.667064814133434,0.30991128057932976,0.6774802815689966},
{0.6459173716275921,0.6084778672126927,0.4610265004769202},
{0.28923419094185066,-0.2847509871426361,0.9139258493507596},
{0.8132275190267586,0.24413398292062338,0.5282609210237833},
{0.207539736604012,-0.9758290485094956,0.06844651792012402},
{0.2624057223551176,-0.8851433827355834,-0.38427129592866766},
{0.5444260330798252,-0.8362785834812927,0.06510318974895024},
{0.8362021248813043,-0.2970909413410727,0.4609804539425363},
{0.822246742037669,-0.44099691496318383,0.3597666135168652},
{0.24419279295891838,0.8017035232048453,-0.5455651571974339},
{0.7108108841516249,0.6913333362892837,0.12963836278939025},
{0.7718477730754111,0.5531746280248812,0.3134467197277126},
{0.6371098504104221,0.7703101517471947,0.026707838273126217},
{0.9556976953731475,0.01780827675154725,0.29381079002922067},
{0.9677944236941443,0.21952021062543903,-0.12322674463557823},
{0.873922731913388,-0.1017949663051487,-0.4752860648914233},
{0.8745237313771207,-0.15522678206440907,-0.4594702268789199},
{0.8497853994189479,-0.2644326858118811,-0.45600452805722674},
{0.8928062977151124,-0.290898855153792,-0.3439109925990256},
{0.7939838885959878,0.5682672576445491,0.21601367674093613},
{0.8831519479904149,0.4446470871118931,-0.1494376280715274},
{0.866154308643172,0.31032831363878893,-0.39175636736749314},
{0.9095084744213273,-0.0652849080532309,-0.41052675398355093},
{0.9487778999577091,0.25195780186537703,-0.19062466427775482},
{0.981301788157043,0.028715073176930287,-0.19032142583596134},
{0.8620965651105718,-0.30822586375981836,-0.4022267138493758},
{0.8538994262586892,-0.3825462265790475,-0.3528656321678455},
{0.9316462148762495,-0.30362977657549406,-0.19961034312748563},
{-0.16762884474936862,0.9673699738123136,-0.18998922120571946},
{-0.017835622072905916,0.9885311356392135,-0.1499602762638137},
{-0.22226265806472356,0.9590560813884841,-0.17552989369839397},
{-0.2125032181539344,0.9265461691524078,-0.31041033923376177},
{-0.40163749962964657,0.8562480877739104,-0.3248484740225317},
{-0.2657087710835414,0.9330489432959486,-0.24252529431708336},
{0.09465086951984854,0.9889540217049101,-0.11406645366987048},
{0.3362713536001508,0.9254229340756855,-0.17468248290733657},
{-0.8717587837188534,-0.18533704036902734,-0.4535270713819353},
{-0.5201347180468003,0.6671930825191577,-0.5332103390979585},
{-0.26567585200705907,0.9064313314270738,-0.32832694538777274},
{-0.09048241448226886,0.9687685064852251,-0.23086903974297973},
{-0.0029722369349627,0.9503619173111534,-0.3111324347159436},
{-0.10070405207444187,0.8079800507006696,-0.5805402066743798},
{-0.209910899033617,0.7633846890004534,-0.6108856120965525},
{-0.37223027151409915,0.8057742475089119,-0.4606218481791616},
{-0.46761576250448333,0.7453420727402295,-0.47518490428532034},
{-0.5758345084243929,0.7239349437948995,-0.37991158979466993},
{-0.49482576021938063,0.785119136034484,-0.37247202479619507},
{-0.08448677665824592,0.8626666462866301,-0.4986664636352416},
{0.3625403806585564,0.8837233534158648,-0.29596876020851814},
{0.34576842310659794,0.876580515653927,-0.3347398947814139},
{-0.8525660906627212,-0.2332553965150662,-0.46767828798083416},
{-0.7155222240105873,-0.6833466296065093,-0.14513900493102153},
{-0.7420070916857922,-0.6481510662024219,-0.17124739784491977},
{-0.6937942366263788,-0.5765336532289262,-0.43157676480381607},
{-0.7222036055976253,-0.15826548756364783,-0.6733305187707077},
{-0.6114175973793535,-0.08636520283043614,-0.7865809388454036},
{-0.2877635143816697,0.852547262409781,-0.43629728987044925},
{-0.10375271556090913,0.954255647530318,-0.28041314728491357},
{0.08137020510151488,0.9832815871648073,-0.16289938632295306},
{0.0744872107442488,0.8938223440685686,-0.44219144347139},
{-0.010607740260141715,0.7134428841881199,-0.7006330900320867},
{-0.07816881310774658,0.6260294666437354,-0.775871602490442},
{-0.29811752866142127,0.6760501283740423,-0.6738561886858705},
{-0.3220790331328804,0.8548377518516783,-0.40683843774323664},
{-0.314104116003348,0.8558214758278768,-0.4109844350112914},
{-0.49842863731954734,0.653073019687552,-0.570144301432507},
{-0.8846858695493928,0.11411759004101152,-0.45200452194957796},
{-0.5995611514609297,-0.5870837172371727,-0.5439293470790372},
{-0.5973641579009314,-0.7172892289925633,-0.3586812301007193},
{-0.6234569475700443,-0.766139726367943,-0.15598510892869383},
{-0.43000180845733427,-0.9015000612025995,-0.04894981486309697},
{-0.6902486329069093,-0.723569557315107,0.0019800244854227627},
{-0.2525431418031416,-0.9668595980343727,-0.037476382122735866},
{-0.6470392901412744,-0.7236196713575944,-0.24023889826129893},
{-0.0660884787046985,-0.9965980439676869,-0.0492407528606027},
{-0.449258061305984,-0.7880237946698095,-0.4209343100601119},
{-0.4899869115385452,-0.6297825080518709,-0.6027327924319474},
{-0.42726770107785816,-0.6096810219771666,-0.6676311579431562},
{-0.526541300059964,-0.18299470144998867,-0.8302211744905043},
{-0.32227900997672804,-0.4538673912042085,-0.830747031851397},
{-0.0925532718381428,-0.41849222296469873,-0.9034921976365483},
{-0.00912227369680808,0.03383750902604895,-0.9993857148796518},
{-0.3125735499976574,0.9472170697758082,0.07125727027604756},
{-0.1706851564422491,0.9791858619152767,0.1098254305501315},
{-0.0024044821076445733,0.9972051392463173,-0.0746734807446865},
{-0.17875023538337717,0.947185499470791,-0.26624797265454536},
{0.0484336703979822,0.665197858047248,-0.7450946176299577},
{0.0016850766512667523,0.4944810065868043,-0.8691868007750579},
{-0.23380551388516388,0.6162979330715235,-0.7520052123281212},
{-0.26397243228354017,0.8780480348776821,-0.3991869279444816},
{-0.36071381338981523,0.6495102739225669,-0.6693444172463154},
{-0.5070877167897077,0.5424504834883451,-0.6697831891323205},
{-0.3852561331078929,0.7822763521473868,-0.48951141025897565},
{-0.6220824007821235,0.33868292953683965,-0.7059088892183563},
{0.38281862230308433,0.39575796963106535,0.834760763267815},
{0.6115058465130871,-0.2879802019347078,0.7369721860246544},
{0.7979281197315419,-0.06948737753472316,0.5987338474690012},
{0.5411933108600653,0.4713980908335701,0.6963430478139249},
{0.877049414577301,0.23746528096313957,0.41760575274618866},
{0.920831356667282,-0.028514903465699352,0.38891710281065645},
{0.8203122444850649,-0.42923952548862054,0.37794344987865447},
{0.7474633023625729,-0.5057389490645735,0.43072813585868497},
{0.2844604301807232,-0.7782425595565158,0.5598399611999135},
{0.05043820359817634,-0.3201574644574765,0.946020710962476},
{-0.23596774312770233,0.3448736646983752,0.9085050245324631},
{-0.29651820711991406,0.7567860981660579,0.5825390583205435},
{-0.007919642233636183,0.6643062947836297,0.7474185079175766},
{-0.11372792180168191,0.645280354306772,0.7554331367820698},
{0.3416327492022755,0.9321132496306116,0.12021628232297162},
{0.7784698230021827,0.5770037633376881,0.2470857983962161},
{0.868076055351705,0.3869355233044989,0.31100621043654},
{0.8960390040834639,0.17637551966379927,0.4074380679617933},
{0.7812703976651761,-0.4405856021442756,0.4421548291212745},
{-0.14393870394768077,-0.9296068272718497,0.33928276731279344},
{-0.3918612913088852,-0.3321476062249339,0.8579759297630553},
{-0.7166855494237012,-0.16945337879927036,0.6764963973745598},
{-0.8522225805718966,0.3800647654360677,0.3595378244877775},
{-0.4329806486020159,0.8451169942770442,0.31353631993807657},
{-0.6952293601662665,0.6749425620402081,0.2472016883223163},
{-0.6156893594543482,0.6515242138609988,0.4432186947856574},
{0.47161957727473386,0.3076652897164697,-0.8263879499574531},
{0.7652245515670161,0.3385272319930994,-0.5475679856220133},
{0.3118637476052525,0.5421318171232716,-0.7802782169151125},
{-0.10807152535752375,0.26884537514094825,-0.9571012013743483},
{-0.15428411354129243,0.5540426550205612,-0.8180667141049958},
{0.12281643109044349,0.7874734602011262,-0.6039881403910773},
{0.5491058453862788,0.7998170855694187,-0.24243638380792007},
{0.7382914168853708,0.6017441466110167,-0.3046797757856124},
{0.48384584701595246,0.3702136500662397,-0.7929912040054714},
{0.6250147240554946,0.19554101490267098,-0.7557250202320068},
{0.6573454879051824,0.16208525604481852,-0.7359519544804424},
{0.08593466014029505,0.07408826473378968,-0.9935422302123387},
{-0.12464848260890421,0.1576247800818858,-0.9796005229109644},
{-0.2144294602068352,0.2869480575496758,-0.9336384840310908},
{-0.3670081171784308,0.40561276876492625,-0.8371280211174358},
{-0.3639787409951264,0.6237108054580778,-0.6917400575783063},
{0.12443506990694016,0.9450953651190785,-0.30217654476760886},
{0.5341023782478985,0.8450280286552261,0.02573480788739912},
{0.5780280044785908,0.8148869919067983,-0.04292803815209691},
{0.6872107585414874,0.7066575867253972,-0.1684530452923641},
{0.46870805361148016,0.5202241318303632,-0.713918491945042},
{0.45421652465697726,0.4748115337106457,-0.7538178534525976},
{0.5306977526984866,0.3320891859779306,-0.7797927082483469},
{0.28805134559439993,0.04283005704196665,-0.9566566826793389},
{0.6481137778754956,0.000838345087033199,-0.7615430572892564},
{0.7108355664589149,-0.0738689867156981,-0.6994684912550598},
{0.6462629916302283,-0.008753712084860643,-0.7630645570159074},
{-0.24769796106686318,0.10028784225837496,-0.9636327458002235},
{-0.21296896796403095,0.23709987128198237,-0.9478543504792301},
{-0.268855972338831,0.24907504527226196,-0.9304182328181032},
{-0.38623126618881853,0.33369435197380287,-0.859926443644435},
{-0.5023716503082863,0.44569550730460256,-0.7409306578452682},
{-0.46233331395566435,0.6130870262301105,-0.6406030011443069},
{0.16745779200231353,0.952369887882314,-0.25485188748121623},
{0.6160217997397807,0.7869693572362091,-0.03458862553773092},
{0.3785238114221593,0.7240869138286542,-0.576556905611698},
{0.26972983396242584,0.48674168584240224,-0.8308600050152242},
{-0.455572997289215,-0.10451192410996861,0.8840421380566387},
{-0.428971292777914,-0.11893393450195779,0.895454269740409},
{-0.5015308050867823,-0.07853473847807307,0.8615678420189468},
{-0.3778587565999591,-0.024763328352968156,0.9255320294995824},
{-0.6171023210329424,-0.09719905165765923,0.780856625593077},
{-0.5031703703356969,-0.12538848197331584,0.8550422837524851},
{-0.32027087567066903,-0.1342935678830642,0.9377589262824318},
{0.7105730940535778,-0.05804652820520524,0.701224984274268},
{-0.2520979958400627,-0.08935508047262375,0.9635674704384508},
{0.11295336773457929,0.8502879536550133,0.5140544062515044},
{0.2042553966046968,0.8922597859125951,0.4026812727220723},
{0.14462159827063473,0.9716332602496737,0.18711868129675588},
{0.34252249126521733,0.9355010704654722,0.08669538704812876},
{0.021508301249631025,0.9748768380496057,0.22170372935915617},
{0.12204330954124012,0.9769751024087023,0.17500022819906988},
{0.39756802033887545,0.8920364860783309,0.2149664548455208},
{0.10032764498639418,0.7787244704421726,0.6192919850813845},
{0.18921630019093352,0.6651438670972302,0.7223439816354786},
{0.6775225452020475,0.7352842669368218,-0.01789546138326698},
{0.5334420449964804,0.8179269766734988,-0.2154879241621744},
{0.2339964701343051,0.8689679628960804,0.436050835826422},
{0.2367522041072727,0.9714098341551574,-0.017644488006115955},
{0.3996737322194078,0.8663360205693549,-0.29953765579282926},
{0.40685721577921535,0.2299159538993855,-0.8840847584428321},
{0.4293195300174919,0.0014940989457299402,-0.903151431828517},
{0.4540289455760779,0.14121747356516084,-0.8797245828888426},
{0.4591785513492351,0.27158603015944405,-0.8458109045188834},
{0.48803401368205834,0.1070700902989456,-0.8662325307056739},
{0.5143252379658034,-0.06365837143366578,-0.8552293033671339},
{0.5569694510752466,-0.24534897977578377,-0.7934663878778486},
{0.29705065079131704,0.2667722004980107,-0.9168388647444566},
{0.3485411717399888,0.5468752403681912,-0.7612138484515037},
{0.4843402291162079,0.31711785709683504,-0.8153838403905063},
{0.5469741952614089,0.16090973321858873,-0.821539583631645},
{0.5949617132404031,-0.19442544412879662,-0.7798841622019032},
{0.6421737984319493,-0.3947955084611363,-0.6570763419165195},
{0.36398381503881583,-0.7968291953435169,0.4822644666964306},
{0.709699795796695,-0.5685346541630469,-0.4160463277831378},
{0.18791690482394288,-0.8093070592464687,0.5565153373764482},
{0.7110485009498146,0.07705255909991274,0.6989083862947818},
{0.5282908905765376,0.13888930548014894,0.8376267043003647},
{0.9028270200561603,-0.3346786946763988,0.2699880426726624},
{0.6614900078958539,-0.39438240410386904,0.6378820335980594},
{0.6447611339790379,-0.0926897547421101,0.7587434938606806},
{0.0038704824914656587,-0.005426886784621453,0.9999777838857772},
{-0.5203693565921497,-0.23489462257995103,0.8209995426325732},
{0.04284425564590672,-0.5720592021436075,0.8190925704711082},
{0.6758676798314944,-0.5012798593088295,0.5402974939887399},
{0.31720711382023875,-0.7491982125598244,0.5814479213472158},
{-0.4001881601675141,-0.5380361717117489,0.7418669115087325},
{-0.21866846601659085,-0.746530308