// 3D model [buddha]
//
// - vertices   : 9996
// - textures   : 0
// - normals    : 9996
// - triangles  : 20000
//
// - memory size: 327kb
//
// - model bounding box: [-0.5,0.5]x[-1.0,1.0]x[-0.4,0.4]
//
// object [buddha] (tagged [ | g Group47867 | usemtl Acier_-_Satiné]) with 20000 triangles (1526 chains)

#pragma once

#include <tgx.h>

// vertex array: 117kb.
const tgx::fVec3 buddha_vert_array[9996] PROGMEM = {
{-0.3370548606023502f,-0.5086613527234205f,0.16547221316220023f},
{-0.3427209088161091f,-0.50567641067395f,0.15926392581277643f},
{-0.340396628251415f,-0.5522269457091904f,0.15008763650643575f},
{-0.3320899208011576f,-0.5641363991625807f,0.15538314024853114f},
{-0.33683467339620277f,-0.5610426803645188f,0.14677053052989827f},
{-0.3340256012734326f,-0.5535090785793944f,0.14012934705676455f},
{-0.34359770335882445f,-0.5384013462759544f,0.14553158028759866f},
{-0.3485425625899727f,-0.4908740951185156f,0.15853792412277992f},
{-0.3398546515304795f,-0.44763709849438177f,0.18121839837752604f},
{-0.33151446867249107f,-0.4331395505557804f,0.19656485796583117f},
{-0.3359841405121788f,-0.4763149445253749f,0.18106149455507575f},
{-0.33241410073352146f,-0.5341067135600585f,0.16683284840800042f},
{-0.3236332810485088f,-0.5589592359641954f,0.1645600170663916f},
{-0.31964489482111935f,-0.5683613241147437f,0.16174669956200682f},
{-0.32493612343418143f,-0.5716881574972028f,0.1535374106584286f},
{-0.32148039129918193f,-0.5695414892080198f,0.1407339590926321f},
{-0.32340385408162514f,-0.5581584099544459f,0.12426177218730972f},
{-0.33265769278375523f,-0.5486039374642774f,0.12935381739665688f},
{-0.34507902919441363f,-0.5482680444857922f,0.1346238998446398f},
{-0.34961510577194854f,-0.542192464620913f,0.14127779927686884f},
{-0.3571217170866228f,-0.5329521620567086f,0.131576221551495f},
{-0.3531177283381144f,-0.47352712905809624f,0.15505229370715046f},
{-0.34468412796126474f,-0.4394381946271606f,0.17554193431758366f},
{-0.3324606267588085f,-0.3810073862314792f,0.20589732015804788f},
{-0.32808210101008106f,-0.39280644170195783f,0.21159445336196214f},
{-0.3249779674282434f,-0.4314774315956925f,0.2050657746264302f},
{-0.3310795252889284f,-0.48933923136608376f,0.18228877318515874f},
{-0.3239102061438269f,-0.49635002757923036f,0.18481346317218222f},
{-0.32568185191242105f,-0.536405765126454f,0.16998194733805008f},
{-0.3223662853648024f,-0.5331400478157565f,0.17964583402149692f},
{-0.31933805975868534f,-0.5745150419493398f,0.17036633179627342f},
{-0.30214230301484685f,-0.581525513065696f,0.15325473049999583f},
{-0.3108623922821333f,-0.5730930080313f,0.14991740052835953f},
{-0.29877978547881656f,-0.5782440710569813f,0.1332967920645535f},
{-0.31615252661514964f,-0.5678780730479942f,0.12041939160304069f},
{-0.32542127939813686f,-0.5542058300575259f,0.11389378322608384f},
{-0.332935408310485f,-0.5509701023945303f,0.10278764394153747f},
{-0.3426654468787199f,-0.5486832090231291f,0.12204352204701438f},
{-0.3542302520508509f,-0.5423949404264355f,0.12116296233101524f},
{-0.356586104188478f,-0.529634893531776f,0.11433045302234011f},
{-0.3612984150985926f,-0.5242202386288103f,0.12305754355710408f},
{-0.36026141370754117f,-0.5047095834436607f,0.13364732502268045f},
{-0.35763181838599123f,-0.4390878741505959f,0.15679976438599497f},
{-0.3476705701305651f,-0.4007830919798384f,0.18434563189240818f},
{-0.34148625388859116f,-0.3893508933635097f,0.198574968604561f},
{-0.3323070270246518f,-0.34737090260243114f,0.22297824230395405f},
{-0.3214227004302043f,-0.35708845894128927f,0.2302573708580397f},
{-0.3217586550283425f,-0.378523366277886f,0.226566721232587f},
{-0.3179060763914913f,-0.4251111875776773f,0.21667145168947566f},
{-0.3189363506162806f,-0.48973056715861746f,0.19677562161469098f},
{0.2520147163093935f,0.315832666964151f,0.048535340713513155f},
{0.2528549151526355f,0.291885369135764f,0.0531075221581125f},
{0.25610948674298295f,0.30915346841470787f,0.045965523892290326f},
{0.25310114091183383f,0.33344119782775067f,0.038706668204062836f},
{0.27128514408984833f,0.3320908976851403f,0.04505568634182312f},
{0.27918396024664605f,0.32432491012737746f,0.047935312967352026f},
{0.2689669829941482f,0.2876662799897095f,0.05760903754713294f},
{0.2527227749938624f,0.2783672932052239f,0.05650471243547743f},
{0.25133148078343925f,0.2843817580607493f,0.06474604249624126f},
{0.2538906799009944f,0.29161659058354417f,0.07636497415914244f},
{0.25693736590524324f,0.3170399043332788f,0.07522409584432603f},
{0.2502717438652227f,0.3460461863023284f,0.05735076408335271f},
{0.24886417781675932f,0.3365636090735766f,0.04084926109688106f},
{0.24745304632768067f,0.34774226725292506f,0.03603369689638683f},
{0.2822838388851988f,0.37746831989015694f,0.04354722023628248f},
{0.2763163866377381f,0.35119498002492433f,0.042508227892992356f},
{0.2910762706875908f,0.353419217895645f,0.04872000100244551f},
{0.2985132549815257f,0.3467860587887113f,0.05070465210038164f},
{0.2947575583754089f,0.33013535762364576f,0.05622816130770893f},
{0.29132705523870805f,0.31159833864044895f,0.05783585417802381f},
{0.27857112198709444f,0.2774126241699289f,0.06029281566706706f},
{0.2639339768492914f,0.26506109645174547f,0.06167146509971826f},
{0.25444661772298016f,0.26156647912843883f,0.06877889155294788f},
{0.24852652230371505f,0.2718538536473394f,0.07942362606257174f},
{0.2500289018749039f,0.2772302501826067f,0.11381527553844861f},
{0.25792640170842324f,0.29616184636456994f,0.10264356338137143f},
{0.25621216420832876f,0.3208189452262367f,0.11224011890735952f},
{0.2496382970189445f,0.349938217453258f,0.09758784614472914f},
{0.23954687299678862f,0.3807935320382958f,0.06167457051775114f},
{0.23779488389752193f,0.39876713597332986f,0.03834794408170958f},
{0.24031327168140787f,0.3802652943751781f,0.030890122783368498f},
{0.24308388251658786f,0.3605837753289357f,0.026010995785922753f},
{-0.061114666196201324f,-0.9544457963223809f,0.2256055279509219f},
{-0.08103449287622332f,-0.9799613504431216f,0.26061910033554614f},
{-0.06935660501664112f,-0.9844292799339985f,0.2548114884057266f},
{-0.05773494934011136f,-0.9639684953821321f,0.23023487862226344f},
{-0.057791763722644565f,-0.9785569864918018f,0.22999146930617326f},
{-0.07316778374589558f,-0.9977729255004226f,0.2598916686446354f},
{-0.09206873158731393f,-0.9979387641725673f,0.2844518047325741f},
{-0.09473920411181738f,-0.9764850522177078f,0.2754108173106534f},
{-0.07856946983670682f,-0.9620805552672727f,0.24452597841253512f},
{-0.07093265407029185f,-0.9430943279508289f,0.2300429801489116f},
{-0.05850376394009391f,-0.9171530702072618f,0.19951272729472105f},
{-0.048866170787572764f,-0.9215224369382465f,0.19307954202291389f},
{-0.04999685954906949f,-0.9417525387571961f,0.20670525898809505f},
{-0.0512049330331448f,-0.9654310569709553f,0.20215793576146812f},
{-0.04800359869822933f,-0.988894292053025f,0.20984602970331073f},
{-0.04249579187835537f,-0.9965339136384702f,0.205761471133605f},
{-0.05197722489389428f,-0.9972287198478991f,0.2234967929326469f},
{-0.09254628921060175f,-0.9990236079121844f,0.27551758823329675f},
{-0.1070056446507892f,-0.9999596348776115f,0.2875291295156975f},
{-0.10393169407487497f,-0.9979267685259682f,0.29819746435244504f},
{-0.09926101998929915f,-0.9934419796855315f,0.29627146878977934f},
{-0.09741471244934709f,-0.978967613485376f,0.2863906883644006f},
{-0.084997194332363f,-0.963909162030678f,0.2594518222490229f},
{-0.07147489426836444f,-0.9445127953658455f,0.25234696257306577f},
{-0.05992914125551628f,-0.9154222166489961f,0.21262721893306932f},
{-0.053022526877176575f,-0.8936916189079075f,0.19327308191633438f},
{-0.045821438551289076f,-0.8933327056769639f,0.17846341024921358f},
{-0.03647775414536f,-0.8977019098595534f,0.1692300377711634f},
{-0.04615866591398546f,-0.9332906910814556f,0.18798992866504716f},
{-0.043359506056096016f,-0.9361279499458713f,0.1710324136857039f},
{-0.045923958780278815f,-0.9620873642389364f,0.179494675700491f},
{-0.0419007000788862f,-0.9671867135019873f,0.17937775347120916f},
{-0.02412460944248761f,-0.9766969303323619f,0.18937422054558498f},
{-0.0288014911769058f,-0.995815764204608f,0.20650724104574927f},
{-0.032486766081240376f,-0.9981987895468286f,0.1993519435589433f},
{-0.0010798599845733621f,-0.9984703250473194f,0.17386572145546902f},
{-0.2834198704955794f,-0.9987266213701624f,0.15562987277625556f},
{-0.0745502174751711f,-0.9986945239053628f,0.2299512656697722f},
{-0.11196640493965149f,-0.9981439958639529f,0.2636094319798442f},
{-0.11439190322135846f,-0.9942008193385722f,0.2794272086079527f},
{-0.10739684233030733f,-0.9921050531324517f,0.29999547270847265f},
{-0.10063393454458404f,-0.9860985329625401f,0.3045474970896653f},
{-0.0946163600213945f,-0.9838928564186935f,0.30073925591800954f},
{-0.08726538507665138f,-0.9737369538040527f,0.28510099752502593f},
{-0.08613606257160024f,-0.9702901586435632f,0.2958059280612468f},
{-0.08134448966430421f,-0.9544243973042424f,0.28476964315271136f},
{-0.08801672731776677f,-0.942088918318459f,0.2799572693628749f},
{-0.07074099888832878f,-0.9252574644003915f,0.23870855939620803f},
{-0.06900291033286722f,-0.9001674492292665f,0.21405603101294615f},
{-0.0566492567366531f,-0.8701601358104378f,0.1869985715007992f},
{-0.03842550357037311f,-0.8696295470388334f,0.16939338403458237f},
{-0.02249385913544065f,-0.836854033388149f,0.15142493808947294f},
{-0.017160822650182175f,-0.8449068753046359f,0.14210004449050503f},
{-0.027294992650631972f,-0.8888903897760132f,0.14857507481878193f},
{-0.3991993186901944f,-0.12522900950701424f,0.2150318653366609f},
{-0.39512037282095663f,-0.14984509411511976f,0.22285297061168202f},
{-0.3873358239363198f,-0.13647915923281112f,0.22766611464718173f},
{-0.37610962619463223f,-0.11610275217173835f,0.22535668760609956f},
{-0.37543763731777f,-0.13620340916053247f,0.23670852038353077f},
{-0.3675032368737354f,-0.1463207293730925f,0.24216978205477713f},
{-0.3708288750474067f,-0.15392825349373782f,0.23674499603092145f},
{-0.3906226969737668f,-0.15717443737441383f,0.21759939266905007f},
{-0.4039829171644576f,-0.1563169531560795f,0.21280258209124361f},
{-0.41849055691486f,-0.16297402387562573f,0.19820774734453173f},
{-0.4214164492757621f,-0.15607735363440117f,0.19770511370967006f},
{-0.4119409253724705f,-0.11212893580507521f,0.2058039143256726f},
{-0.3984813307423197f,-0.09808740517138448f,0.21665807809994506f},
{-0.3772906019050685f,-0.08241536539722004f,0.22277353650443518f},
{-0.3610877725642233f,-0.09750307768786103f,0.2242812461756141f},
{-0.3585000010509869f,-0.11557645977732342f,0.2312262857196785f},
{-0.3646998592568346f,-0.13628430195370442f,0.2389023223952689f},
{-0.35307639005017066f,-0.1316009278451504f,0.2438311318316095f},
{-0.3523491612791519f,-0.1401225125873135f,0.24465475498817718f},
{-0.33972058628875207f,-0.1476586280293197f,0.2441598716183001f},
{-0.3498906136152462f,-0.15247833668268643f,0.2410473694501316f},
{-0.3685709992205597f,-0.164728060234745f,0.23973198427783687f},
{-0.3830172392363147f,-0.1694618509059916f,0.23289770606015567f},
{-0.39781384010013116f,-0.18084809188521236f,0.2172370967316347f},
{-0.4047692349331338f,-0.16444460983064896f,0.19848813801413082f},
{-0.4163130065554137f,-0.17620978405361246f,0.19227491578042283f},
{-0.4251126924783421f,-0.17493924205263142f,0.1877141679686904f},
{-0.42532457059299617f,-0.16727903206620828f,0.18438156996144625f},
{-0.4214121539609804f,-0.1326596714120633f,0.19439036734088183f},
{-0.41395689200305713f,-0.10812042757373685f,0.19835867193581916f},
{-0.39880105281150663f,-0.08604015848725635f,0.2119459690473147f},
{-0.3866839368776582f,-0.08064398416817092f,0.2207701742801237f},
{-0.38195367233793787f,-0.07336586808872961f,0.21804317103597273f},
{-0.3584266460412372f,-0.07241006333948416f,0.2236590459784279f},
{-0.35844443818485566f,-0.07899434637505202f,0.21908659574465225f},
{-0.3537288646203521f,-0.08632174436564331f,0.22461466693112192f},
{-0.3278434342824612f,-0.10352029736684155f,0.22561026947698443f},
{-0.3437996532724804f,-0.11618267286176284f,0.2332277228610356f},
{-0.34116709914517557f,-0.12902725979561108f,0.24463783508137196f},
{-0.3395537744510521f,-0.13783651057606608f,0.24080699968278999f},
{-0.3047600036185397f,-0.15764431485163272f,0.24710475239401636f},
{-0.320959328076015f,-0.15930254327431506f,0.2435324029407769f},
{-0.35652616313975577f,-0.16477944890058507f,0.24128384868006766f},
{-0.37433017916547856f,-0.18381082429938447f,0.23836743830888274f},
{-0.3895564145610238f,-0.19620571737961584f,0.23183894230749438f},
{-0.40217643823094923f,-0.20294773397813473f,0.21938759393857013f},
{-0.4195251466401794f,-0.20995212599699387f,0.19209493327308433f},
{0.44705091126598434f,0.15044357605791514f,0.12933956625827403f},
{0.4510343328616709f,0.13749953287920544f,0.13161091235376243f},
{0.449141813769144f,0.0895062140389597f,0.11113984369428126f},
{0.45548033744254274f,0.1486682214236512f,0.11658733124825212f},
{0.46097049554385294f,0.09540598453438391f,0.0921663472106421f},
{0.45356885118335816f,0.05661187219937979f,0.08656413270782663f},
{0.4489194390653129f,0.048238536905634864f,0.09373283671880533f},
{0.45519372531279995f,0.045879827953402764f,0.0974216069448396f},
{0.454370852216147f,0.11510379666682286f,0.12803459693216285f},
{0.44449771050293263f,0.1745829742171382f,0.14372247720679604f},
{0.43533424870850757f,0.19733940744317988f,0.13709352310997996f},
{0.4482532859945591f,0.1863875414593426f,0.12532143792420294f},
{0.46171539321918403f,0.17183374115194036f,0.11215729996882538f},
{0.47010157514818496f,0.12852120202037304f,0.09646199877562917f},
{0.4734325019879417f,0.09349421461231357f,0.07667977515534674f},
{0.46095699977742394f,0.03697971474487313f,0.050188614066162866f},
{0.451617242030766f,0.015287133142501706f,0.05460682712109497f},
{0.4461821612752173f,-0.020506718284798442f,0.04362077179147728f},
{0.44117343114885216f,-0.022044012826302938f,0.05695089609368525f},
{0.4457853147733657f,0.016523874638961336f,0.08148389934852723f},
{0.45197878897067445f,-0.0055803878655330446f,0.07115631375637096f},
{0.45834823508583333f,0.022721685584956325f,0.09569651694895116f},
{0.4544582299466001f,0.09649269279970989f,0.12761146752346358f},
{0.44721010457726834f,0.14488180529566616f,0.14357995094925816f},
{0.4370252651610669f,0.1881107764911923f,0.15180547238178754f},
{0.4249177533938341f,0.21628964569501075f,0.14907535734515684f},
{0.4146428611043104f,0.2311516186362817f,0.13910802999223357f},
{0.4364819923026015f,0.21823440550444234f,0.1280599969781191f},
{0.452909708941752f,0.2036544242813424f,0.11717511368197842f},
{0.4672005261315459f,0.1626763584550123f,0.10384395140733865f},
{0.4716826398291136f,0.13040054938085344f,0.08629505668141953f},
{0.47677639657744486f,0.06323100858561018f,0.0482486839626421f},
{0.47541977510835653f,0.051253226373826184f,0.044542713354140395f},
{0.46830855160960877f,0.030473812970410956f,0.03110750310807803f},
{0.46339271098542245f,0.012856933706229007f,0.005998615324590234f},
{0.4505418813432742f,-0.005896746351588932f,0.00876130165990452f},
{0.44524078508645926f,-0.02060285025561791f,0.022247284375276302f},
{0.433443513398696f,-0.049352348256638916f,-0.01715211356214786f},
{0.43633232347734713f,-0.05947801793218917f,0.014255881502525899f},
{0.43580663878020054f,-0.05667682781297215f,0.04046799693039998f},
{0.4394569232832647f,-0.03570182831869156f,0.05417829430626665f},
{0.4427958341177245f,-0.01442732862550725f,0.0665944716645927f},
{0.44719186728477683f,-0.04492202906469529f,0.04699153892416353f},
{0.45590279753432095f,-0.0206035790673766f,0.0682521582592912f},
{0.45946282624417084f,-0.04678411123583173f,0.06191114536439023f},
{0.46066763176181813f,-0.07478166036087708f,0.05497032357933729f},
{0.45637972621218437f,0.014800314510321391f,0.1005684918170102f},
{0.4464444559525639f,0.0777434706050688f,0.1318794083055045f},
{0.44006013719045245f,0.14942989876795643f,0.15112850824914434f},
{0.4279436682629611f,0.19529097787950653f,0.1578458631751359f},
{0.41137207823316796f,0.22652611813084889f,0.15873458430794266f},
{0.4129075486204601f,0.23375949090531076f,0.1492779659516559f},
{0.39710618619303856f,0.25120437165685716f,0.13751146371892808f},
{0.408019469774795f,0.25310609013862345f,0.12771705279898937f},
{0.4251250525308208f,0.23934541550915317f,0.12601210074316704f},
{0.4452835013173344f,0.22265216172401547f,0.11717459203974298f},
{0.4577847796661736f,0.19315346860806618f,0.10934930194035256f},
{0.4662594739771704f,0.15542247802256587f,0.09360185139732329f},
{0.46716494290671695f,0.12614433651864318f,0.07809811614383388f},
{0.4724999204110469f,0.10180440782260025f,0.06753652141990321f},
{0.47425809059896057f,0.039390948076895735f,0.010492731043203894f},
{0.47624734935957497f,0.033514440062911106f,0.019424169346054287f},
{0.4732626102299963f,0.015512790686470278f,-0.018886569745302065f},
{0.46824362574343503f,0.0064579430922413385f,-0.03214209708302874f},
{0.453934936729437f,-0.004868965597933117f,-0.02967045843007025f},
{0.4347915431758135f,-0.03374401895411182f,-0.03554684001752529f},
{0.3879852780810933f,0.09678189826692063f,-0.13012994136238226f},
{0.39101176133839954f,0.09826845221135001f,-0.1393365241650588f},
{0.3759443537858512f,0.11913394614528056f,-0.14749542731577092f},
{0.3924718910757426f,0.11408501238251444f,-0.13740003307562368f},
{0.37735041971448474f,0.14873022885556672f,-0.15737177112612902f},
{0.36300124340119994f,0.14853942466226078f,-0.1621300407357593f},
{0.36383757189278465f,0.15279207208385578f,-0.17457012120743526f},
{0.3896942481632586f,0.10812444984971095f,-0.15502781370635896f},
{0.40966343324779286f,0.07550828993389012f,-0.12231349687043f},
{0.393190973303663f,0.0859041171669995f,-0.12237366952405516f},
{0.402640316291257f,0.07418352263821243f,-0.1086376459430341f},
{0.408002244956948f,0.09828523081791629f,-0.11882871744345751f},
{0.4041130908063717f,0.1225924936609804f,-0.12792675722726116f},
{0.3837001284173225f,0.16115089807411961f,-0.1538493516528045f},
{0.3674263355467112f,0.23466544641763495f,-0.17494927755681844f},
{0.3366343245311188f,0.2845664013511566f,-0.19936250070536576f},
{0.35908526026616094f,0.1764877726191498f,-0.1699436889703518f},
{0.34911355579305464f,0.17831216587317486f,-0.1731990913636078f},
{0.34204363021075374f,0.20405127078319404f,-0.19022605062954678f},
{0.35823162621373555f,0.1578827489119418f,-0.18383646232469047f},
{0.3886590093067662f,0.0990101074180405f,-0.16386721668291082f},
{0.4138642043583625f,0.06354971818015286f,-0.1438501690640626f},
{0.4203138537640237f,0.06350675865788888f,-0.13012592864807837f},
{0.42365341266724854f,0.057269230658270436f,-0.10751084665653507f},
{0.425567047115028f,0.056451463493559464f,-0.08455707436673912f},
{0.4084609777762246f,0.06521670084320155f,-0.09433395237056542f},
{-0.45457989476435223f,-0.8422581513304407f,-0.02585229330704769f},
{-0.4516917731259629f,-0.8273076660071741f,-0.08616579883503893f},
{-0.44363196075182515f,-0.8397261456032274f,-0.025214575581367405f},
{-0.43919685859991436f,-0.8391260126786931f,0.006881284982502927f},
{-0.4309719353029828f,-0.8329364693902868f,-0.017626311851935927f},
{-0.4264592635695343f,-0.8189255764730629f,-0.06001606693144566f},
{-0.44010439391265416f,-0.8197148934189908f,-0.09204473870050398f},
{-0.4408189364719963f,-0.7996324737226881f,-0.145681491341834f},
{-0.45116029405661245f,-0.8075162355607975f,-0.13227206998298685f},
{-0.4627767322483802f,-0.8159396623204448f,-0.10702288381114182f},
{-0.46125524314788674f,-0.8378383680367633f,-0.05284796318088042f},
{-0.47250466299951716f,-0.839296391019416f,-0.024537753811370897f},
{-0.4638504302676471f,-0.8427078451840575f,-0.010942159294867916f},
{-0.4591232052766753f,-0.8395239938320874f,0.032820966112877895f},
{-0.447813115564564f,-0.8381090929200937f,0.03995151905934726f},
{-0.4294765463751934f,-0.8312916953001287f,0.0688395412276804f},
{-0.4134465675980484f,-0.8194352528093065f,0.02833079298965254f},
{-0.4065804553927047f,-0.8073333749906978f,-0.0032348400212692235f},
{-0.39429061000964655f,-0.7836055748657885f,-0.08561494675924661f},
{-0.4194642334883097f,-0.7948563726603504f,-0.13309255266206388f},
{-0.4080378292441847f,-0.7700283291945972f,-0.1721883526936555f},
{-0.4284142766767543f,-0.7799997500048179f,-0.16844388255088233f},
{-0.4443298458190915f,-0.7836198408778807f,-0.16417802302574408f},
{-0.45779199447762114f,-0.7956678981791689f,-0.14240673612788451f},
{-0.46951477650409207f,-0.7982258404682832f,-0.12208336021512832f},
{-0.470225550702927f,-0.8277988606971298f,-0.07034935977836504f},
{-0.4729881573576554f,-0.8320730686228506f,-0.05038866545705978f},
{-0.47214619597985424f,-0.8336656423676005f,-0.03705800888853829f},
{-0.4780416307889999f,-0.8319686689944422f,-0.02779009753253773f},
{-0.4874657660264514f,-0.8234896379347592f,-0.02249292156054711f},
{-0.4863251565008113f,-0.8242194600432458f,-0.004315681670660345f},
{-0.4767979581439784f,-0.8307568919567363f,0.03961394641411225f},
{-0.4696810210160206f,-0.8337144376959729f,0.09094262020987283f},
{-0.45711485823491244f,-0.8370662355371855f,0.09109143273443109f},
{-0.4454079623924463f,-0.8364562137207422f,0.085112949506664f},
{-0.4294234961035362f,-0.8298861966972665f,0.08681002168374873f},
{-0.4189804140333811f,-0.8239031823001834f,0.060254979075269915f},
{-0.402090357700434f,-0.8004955504557419f,0.051295936230254496f},
{-0.4001032056945097f,-0.7962309084499557f,0.0005833144776752236f},
{-0.3931238599398056f,-0.7814764150573382f,-0.031212657046032384f},
{-0.3896144092786355f,-0.7799999114908054f,-0.055588644925603864f},
{-0.38399739968463775f,-0.7737888076982734f,-0.09148079563565889f},
{-0.37935572826990677f,-0.7620897747360198f,-0.1432524265571039f},
{-0.3902303890780856f,-0.7689243557399272f,-0.15275846918718733f},
{-0.3891572169506854f,-0.7537188712937554f,-0.17561907787358902f},
{-0.4084343517116539f,-0.7512998568869216f,-0.19188784661766f},
{-0.42777742481344033f,-0.759439752499479f,-0.18733438373629066f},
{-0.4472783536550762f,-0.7590305863166457f,-0.17874882504535303f},
{-0.4601703994082698f,-0.7697016759768482f,-0.15992821435782126f},
{-0.47038486406629365f,-0.7779248962340581f,-0.13824272432759135f},
{-0.47741401974883f,-0.7951520620024343f,-0.09956279852175451f},
{-0.48150540641353995f,-0.7962485784166756f,-0.059356034392093575f},
{-0.481248866799308f,-0.797751991710665f,-0.05028025417675552f},
{-0.4853591791967712f,-0.8115848866983424f,-0.03727518204372458f},
{-0.4959323955997514f,-0.7949092210745233f,-0.02519492528648674f},
{-0.49066258619057607f,-0.8117607757483835f,0.012643788139055971f},
{-0.4870205289736036f,-0.8165025100428361f,0.05952640848318528f},
{-0.4817034243558857f,-0.8214613101892864f,0.08843084803942883f},
{-0.46282317646826576f,-0.8317666787092894f,0.09496328132416643f},
{-0.44424526540840603f,-0.8354929529934759f,0.09394227342030861f},
{-0.4307333089468598f,-0.8243739511375562f,0.09281474850927438f},
{-0.4183785791315327f,-0.8177133139149869f,0.07828878541134783f},
{-0.41535967509155336f,-0.8005704459568183f,0.08557792078460957f},
{-0.3994555342700439f,-0.7655796909047606f,0.06646057109607602f},
{-0.39013340611860914f,-0.7455815690186657f,0.04792176726775598f},
{-0.3950828443274248f,-0.7807120636325717f,0.010746571079186923f},
{-0.38735017069140576f,-0.773180244567755f,-0.0083346864911759f},
{-0.38340804701216613f,-0.7819131411612087f,-0.025044572270601865f},
{-0.38615509151727234f,-0.782362025460073f,-0.04254172348647192f},
{-0.36636755160830137f,-0.7634396690388461f,-0.07906033039940583f},
{-0.3483281102611915f,-0.7488218352878319f,-0.12115047478959942f},
{-0.37633333953230586f,-0.7679534754238373f,-0.12564243700757927f},
{-0.37314782551211073f,-0.7600197846682206f,-0.15998592541254725f},
{-0.37882813973796187f,-0.7491016373835033f,-0.1694846724881894f},
{-0.37837390621576666f,-0.7298659216534723f,-0.18693153887993552f},
{-0.39169781330746195f,-0.716195786480102f,-0.2074827810825003f},
{-0.41115156805504577f,-0.730332638467452f,-0.20604506283794002f},
{-0.43113250655719826f,-0.7362598870785119f,-0.19821500146506835f},
{-0.4371797169462884f,-0.7049908666420621f,-0.200385236084325f},
{-0.45579191403103925f,-0.7388817013252506f,-0.1735814296243863f},
{-0.4702242131314924f,-0.7462426554665667f,-0.14729049947301945f},
{-0.48304711844672443f,-0.7365427701568364f,-0.1135404571978206f},
{-0.4827105763370665f,-0.759406033800359f,-0.10728974790448545f},
{-0.48953583683724416f,-0.7339754255585909f,-0.06746087373409641f},
{-0.4874459882426334f,-0.7559950651560874f,-0.0513490895554694f},
{-0.48845391046947756f,-0.7899145944118553f,-0.044278009135877455f},
{-0.4997935446804176f,-0.766369817405441f,-0.03155744556512279f},
{-0.4962328679018026f,-0.7908948770370767f,0.04146979650102669f},
{-0.49246047343211313f,-0.8043239540028435f,0.08056595775127423f},
{-0.48594338556580413f,-0.8099971755941453f,0.08984050065683388f},
{-0.48094255869114855f,-0.8030048599648791f,0.08864635427675895f},
{-0.45591062004303656f,-0.8257413539211154f,0.09427571436156489f},
{-0.4372081267935744f,-0.8234745613055069f,0.09486401418789536f},
{0.15490002995081673f,-0.05796690430638238f,-0.2421089092744042f},
{0.1605793306396157f,-0.07967448179501242f,-0.24357522010039415f},
{0.15924098683451549f,-0.09346263347771035f,-0.2522882369188798f},
{0.14922607954775627f,-0.08109716378181717f,-0.2522284796667089f},
{0.15795257194692242f,-0.11460930851265169f,-0.25849346453380656f},
{0.15887364445999566f,-0.1582006776367431f,-0.26205219710612665f},
{0.1658219254102928f,-0.12695937754491f,-0.24794300490614776f},
{0.1698557433829235f,-0.08951280946665328f,-0.24215316599660602f},
{0.17292601590299447f,-0.08456470882927228f,-0.2346466566730816f},
{0.16672682701406805f,-0.06387542904217303f,-0.2344227202297675f},
{0.15566525254998878f,-0.041162522664166604f,-0.2489113120705184f},
{0.1448483038589437f,-0.03287656510087482f,-0.25670947889848234f},
{0.14329838472541567f,-0.05798392514192972f,-0.24682661084175414f},
{0.1328389702599751f,-0.11769313841880466f,-0.2652338598980052f},
{0.13666220625548173f,-0.1319869133519456f,-0.274099059198627f},
{0.14965816505430607f,-0.1221442074977138f,-0.25969433914255147f},
{0.15157319763076543f,-0.2006064517012339f,-0.2680551720211712f},
{0.15338397187905542f,-0.22196686937653837f,-0.2684314099362962f},
{0.16673085991412032f,-0.17497336659153537f,-0.2517641947042095f},
{0.17642083614619303f,-0.11835779136972875f,-0.24602870220385492f},
{0.18222052463855484f,-0.12423057033229513f,-0.23789371066575518f},
{0.1804018258903992f,-0.08632603968042499f,-0.22574088933017936f},
{0.16999284817339955f,-0.050104217452028796f,-0.25087759201257886f},
{0.14995855555095577f,-0.01071507812443202f,-0.2747916566622158f},
{0.14245628098496788f,-0.01716140431845905f,-0.26163816722033245f},
{0.11420444242543519f,0.014745359341458313f,-0.30058543307821245f},
{0.12304963021252045f,-0.017704312771045113f,-0.2746740449302643f},
{0.12670321774147061f,-0.0350703267411161f,-0.26263672750954203f},
{0.12648602015090468f,-0.06547894558738108f,-0.2734183968243921f},
{0.12502333638518306f,-0.10585250136899349f,-0.28132604902695774f},
{0.12782914585356428f,-0.12055066058740843f,-0.27640485917944085f},
{0.12209610645284623f,-0.13738081730553792f,-0.2842764213886514f},
{0.12425570212027896f,-0.14230970854728003f,-0.2839555232340171f},
{0.1371731893533337f,-0.14952200740039395f,-0.27676316365070863f},
{0.14543743342577495f,-0.17727071618061693f,-0.264264682621637f},
{0.14460724565134028f,-0.20570288359243458f,-0.26573111456211745f},
{0.13598742112125983f,-0.25559346411367745f,-0.2684628997038278f},
{0.13792091409585103f,-0.2923275570781931f,-0.27589897245186057f},
{0.13887979770293404f,-0.3347016373928526f,-0.27974786240879035f},
{0.1562257300405529f,-0.26435991792026364f,-0.2646973152682097f},
{0.16669037261483363f,-0.25094267405270076f,-0.25432140818156507f},
{0.16962720777619372f,-0.20580477062636868f,-0.2523854026124998f},
{0.1761655321122459f,-0.2012288750040605f,-0.25663271993410475f},
{0.18174997784441477f,-0.1575365920115903f,-0.25220458823984493f},
{0.1828085397395918f,-0.14372647398498278f,-0.24845006665676758f},
{0.19487390260172088f,-0.14699138067852005f,-0.2289242955332765f},
{0.1905809304292343f,-0.10956069878426802f,-0.2173607864986755f},
{0.20279693421976516f,-0.11248031019018884f,-0.20737813922511106f},
{0.19993394065093245f,-0.10256238586290602f,-0.21639910557182493f},
{0.18756083118046712f,-0.059680250446323f,-0.23758290432292195f},
{0.16292458419691577f,-0.01921064449929254f,-0.26913981284089605f},
{0.14468382188157433f,0.010749658436287012f,-0.28884840522539784f},
{0.12943373649306966f,0.026154214733353696f,-0.2949549277177858f},
{0.13302484063140477f,0.011443978062938145f,-0.28094841298315276f},
{0.1343909154051995f,0.0012130173988258725f,-0.27334275232580874f},
{0.12880680433149125f,0.00011528559004823159f,-0.27813585510035316f},
{0.11819829899064586f,0.025326721225128898f,-0.28865010362016635f},
{0.1165274257901916f,0.020662070991843962f,-0.29647041846377575f},
{0.09804048871122677f,0.04802584817382071f,-0.3220929666128003f},
{0.0942658961197754f,0.053990706021405925f,-0.3303782346734225f},
{0.10056168231414267f,0.026481029437089913f,-0.3144800114634228f},
{0.11475256836278336f,0.005861457413723616f,-0.2941612750855792f},
{0.10503615729954596f,0.008377494089122814f,-0.2923530336175117f},
{0.09562441292439945f,3.577073980774176e-05f,-0.29310459790185966f},
{0.07489312553243536f,0.003117006246085137f,-0.2942755221719918f},
{0.07059957647250716f,-0.00041035767319387085f,-0.2921316512025764f},
{0.10038617785572951f,-0.0446408479636845f,-0.2913889006534323f},
{0.11200565559624573f,-0.06593366569235391f,-0.2886749065929326f},
{0.10492385548183622f,-0.10846004960364015f,-0.3062336891483529f},
{0.10537022718622671f,-0.14964894069848308f,-0.3114657671441045f},
{0.11904532699129991f,-0.14891628196113998f,-0.29732895659065905f},
{0.12032522030583732f,-0.18014955662436535f,-0.2971991866637133f},
{0.13631578587799298f,-0.1965542551358729f,-0.2755006874498322f},
{0.13986896630709036f,-0.20826325773302917f,-0.2672111633835173f},
{0.13089589330451679f,-0.25870225847858397f,-0.27077392779348175f},
{0.12799315187223412f,-0.30912367000041224f,-0.272352419322691f},
{0.1183989718901125f,-0.3603603360924775f,-0.2771584909093899f},
{0.12001951033327557f,-0.39628906337866526f,-0.2884380225856204f},
{0.12278736528259261f,-0.4159613426641715f,-0.2915555297569886f},
{0.12255159574107466f,-0.4698352236666104f,-0.2941675974744652f},
{0.13942194653393483f,-0.4639648754931166f,-0.28086510852424884f},
{0.15754401346135716f,-0.370032338509196f,-0.26452014814157154f},
{0.16486681122612487f,-0.30072131716211314f,-0.25688603726544457f},
{0.1694212663963901f,-0.27904486503513526f,-0.25585868253732114f},
{0.1739470896761366f,-0.27700713498053103f,-0.26271283840515464f},
{-0.17655588517755388f,-0.5455601486461303f,0.3174590975210366f},
{-0.18257463578619065f,-0.5601429675604946f,0.3100776760932329f},
{-0.19357436430434183f,-0.516182472279168f,0.2845888893373017f},
{-0.19478281706800582f,-0.4939438204985637f,0.28213834585384745f},
{-0.20293766819532508f,-0.4670500015367995f,0.25988733295835686f},
{-0.20655056550509648f,-0.5104586726391863f,0.2527497872436725f},
{-0.19842307137892215f,-0.5244147708111266f,0.27227302558694105f},
{-0.1937203348880044f,-0.5463700529306287f,0.2890851075609743f},
{-0.18369807148955863f,-0.5745652959636373f,0.3126671899552801f},
{-0.17146153029362457f,-0.5595100880399877f,0.32913744115356997f},
{-0.17079708026259252f,-0.5451370404855873f,0.3291518282801527f},
{-0.17634069341293598f,-0.5138853649190674f,0.3142019920880589f},
{-0.18835465698514683f,-0.498194359040653f,0.29675008032161615f},
{-0.20338499181711456f,-0.45001817856789966f,0.26671591560776087f},
{-0.2050308187534138f,-0.4191922066242063f,0.26589606187410825f},
{-0.20084642147203444f,-0.4155226712915985f,0.26340101837706337f},
{-0.19912683368620152f,-0.4757830596162404f,0.2553503437725119f},
{-0.2103263023097608f,-0.5381200844319499f,0.24616702345127503f},
{-0.20765771980875386f,-0.564561776626209f,0.2670793068876298f},
{-0.1981925086980881f,-0.5568336415963605f,0.28126608885489485f},
{-0.19420782177469811f,-0.5851952098842913f,0.298150290258393f},
{-0.18096325636077007f,-0.582097277576849f,0.32756476630712844f},
{-0.17738174788978806f,-0.5713169245852775f,0.33894873692085614f},
{-0.1829074892159272f,-0.5522087902221005f,0.34024468959187154f},
{-0.1729938910132527f,-0.5468109946686948f,0.33377542388837955f},
{-0.16436872682151182f,-0.5441525432885779f,0.34244451014386157f},
{-0.16216089252740004f,-0.5258410193009545f,0.3410026378847585f},
{-0.16664960271506896f,-0.5173464260916493f,0.3256392169557435f},
{-0.18139432833026778f,-0.4835830102269198f,0.3024766964047061f},
{-0.19359995770851976f,-0.45443358474139395f,0.2828079028792292f},
{-0.1951619734173889f,-0.4424960869090047f,0.2862266324125636f},
{-0.20367918210177663f,-0.41074867698395084f,0.2729041223871403f},
{-0.2102166958206686f,-0.390793677168515f,0.2693242351504786f},
{-0.20552019035156505f,-0.3963104613343958f,0.2638170955227102f},
{-0.17165468559541738f,-0.38518886614100833f,0.2649056279422485f},
{-0.16858277059286983f,-0.4190150193118198f,0.2611729707119308f},
{-0.17503266435232773f,-0.4636871801521351f,0.2539088167959476f},
{-0.1817652882033855f,-0.5336633410329198f,0.24252334606239015f},
{-0.21585230711303716f,-0.5889101355282358f,0.2358622828142885f},
{-0.2223882410315135f,-0.5867428799004824f,0.23789184720245385f},
{-0.21953098127763918f,-0.5809578016403437f,0.24796888303561915f},
{-0.21339556235518745f,-0.5577918781970862f,0.25456688388084847f},
{-0.21516982164699777f,-0.5954402740121006f,0.2631284905876769f},
{-0.21445223953890702f,-0.609157745827918f,0.27082367610166097f},
{-0.20444515476086353f,-0.6025089427659606f,0.2868320136316866f},
{-0.10001112558772186f,-0.8150728575983806f,0.2947288048391958f},
{-0.11025976578022455f,-0.824206166134301f,0.29183843408346966f},
{-0.06307043361296741f,-0.8000375889445364f,0.26467782114727734f},
{-0.0690307050460305f,-0.7974621381746895f,0.27601854963826317f},
{-0.043596100026075744f,-0.7849506065280618f,0.26347561002950565f},
{-0.023316231838014304f,-0.7819980870401813f,0.25060534788607797f},
{-0.03748768432296777f,-0.7833875369106437f,0.24130852947593553f},
{-0.08583538734965694f,-0.8088559169373325f,0.26018330596332656f},
{-0.1099709098451838f,-0.8240925267451565f,0.27719233178540814f},
{-0.1270678658497805f,-0.8304934626278471f,0.2937988367855171f},
{-0.11610658799514152f,-0.8212437577545113f,0.30636435149786034f},
{-0.09996234619546682f,-0.7995186728475564f,0.30486284310107686f},
{-0.08059798987799352f,-0.7809816538643596f,0.2948517445463216f},
{-0.06603161066210358f,-0.7789260912946401f,0.2936941333084748f},
{-0.030429025575507394f,-0.7896827759649881f,0.2854005975902639f},
{-0.013219869744350824f,-0.7889746769090225f,0.270455928949765f},
{-0.005821020578807909f,-0.7827528736074214f,0.25202918471017377f},
{-0.0001732000958701354f,-0.7688732911084696f,0.23484299282386178f},
{-0.009191084397522968f,-0.761510553184438f,0.23040114331994047f},
{-0.05589740029015705f,-0.7797833322215856f,0.23425485554592645f},
{-0.07411097877682683f,-0.7929334166464332f,0.24144601992044712f},
{-0.08553621224754361f,-0.802156535826695f,0.2434406077186438f},
{-0.09785883928603197f,-0.8145093607448162f,0.25464569010507876f},
{-0.11251248467955476f,-0.8263862290882215f,0.2649361445442247f},
{-0.12902291932849727f,-0.8305985103250202f,0.2738133798629425f},
{-0.13191398914856345f,-0.8286359998058748f,0.2830477860637932f},
{-0.1346068072965652f,-0.8244684618740554f,0.28982761481872954f},
{-0.1262822471454442f,-0.8252075237432781f,0.3007707669336972f},
{-0.12287227185247615f,-0.8195062567105695f,0.3019278310315212f},
{-0.11625198062895468f,-0.8110510565205051f,0.3085512637949412f},
{-0.11209678256386534f,-0.8054694272314445f,0.3141053129772165f},
{-0.11331998792239928f,-0.7916438277982084f,0.3189016178489047f},
{-0.10037366587893395f,-0.7802057923133636f,0.3202899330678245f},
{-0.08241194178804764f,-0.7791642321303931f,0.31223510444873026f},
{-0.04374031551203388f,-0.7832275329821996f,0.2945943135719359f},
{-0.017281452682726024f,-0.7891782884284955f,0.2856134286847248f},
{0.0035876077542276235f,-0.7804009736268528f,0.27580257806631164f},
{0.009860620174748556f,-0.7746849550616821f,0.25491872466299137f},
{0.007226144151712874f,-0.7745145767209592f,0.24666863398741423f},
{0.022125883565865357f,-0.753208870923129f,0.2324176570905499f},
{0.0320241363501113f,-0.7300836366366423f,0.22375272484961073f},
{0.03223057918640186f,-0.717196981540684f,0.21929176687879254f},
{0.0038632409616469383f,-0.7199787986534593f,0.22391726738422538f},
{-0.03783429912108614f,-0.75772057055343f,0.23088496171246126f},
{-0.06208246128000678f,-0.7643155520356593f,0.2264250364020358f},
{-0.0733462725078512f,-0.7814044379905201f,0.22857529137999022f},
{-0.07067459415048165f,-0.7847714739469726f,0.21934119009018144f},
{-0.08068851871001533f,-0.8107279698057793f,0.22998478251140797f},
{-0.0936493096854648f,-0.8326216503331497f,0.24782983191403254f},
{-0.10980996462341877f,-0.8490415051544955f,0.26832539013597556f},
{-0.13219085368663627f,-0.845797673444714f,0.27741039098870923f},
{-0.1402077681581631f,-0.8305245879894992f,0.2699952710475339f},
{-0.12809165513728873f,-0.8138265512443944f,0.2663490598160187f},
{-0.1289032507750229f,-0.8080531456588802f,0.27373927585568575f},
{-0.1332109139227263f,-0.8096419914146198f,0.28617356089275015f},
{-0.12771571044671956f,-0.8077691279290128f,0.294330397660269f},
{-0.1139654814108516f,-0.797982188923212f,0.29954679132950013f},
{-0.11517921327893067f,-0.7900176968403257f,0.31413909329598955f},
{0.43268224189417487f,-0.5120403853888799f,0.009229664143584275f},
{0.44073289525057013f,-0.5576344686685177f,-0.019044597595216872f},
{0.4440827488854878f,-0.5250690493497719f,0.002632959435884899f},
{0.45868907251027285f,-0.5053742363945848f,0.012097967626658693f},
{0.46688976016020967f,-0.5327864848705514f,-0.0004752272317534684f},
{0.4625699186317635f,-0.5477580441151659f,-0.008855806021956857f},
{0.4498342284985894f,-0.5622416511384655f,-0.02322175031772993f},
{0.4459077084028764f,-0.5874415766473168f,-0.04179980374023635f},
{0.4376142119937545f,-0.5858407341825701f,-0.031570505744349005f},
{0.43490737112504935f,-0.5512952969263539f,-0.006876395781754629f},
{0.4299877207064514f,-0.5068491187267975f,0.016610512933577657f},
{0.4257075962316287f,-0.47582180456671636f,0.022005891509212276f},
{0.4411051013280507f,-0.4666729328187659f,0.021196186957382474f},
{0.46483338697332993f,-0.4944158865358742f,0.011557136181344003f},
{0.46631588889436637f,-0.5250632135436636f,-0.0015938300419871237f},
{0.46541921457668306f,-0.5553435222113158f,-0.02494448920513161f},
{0.46758310662130537f,-0.555302021374977f,-0.018982590163301324f},
{0.461278789292212f,-0.5687636834507289f,-0.029055248876283437f},
{0.45725342171131367f,-0.5770256475960068f,-0.03787876460642284f},
{0.44775349855022417f,-0.580496759146485f,-0.04766461995625591f},
{0.42275471233786865f,-0.5836932552762271f,-0.06392471520295417f},
{0.42917275086150813f,-0.5946154545843373f,-0.05179201587132731f},
{0.43521809672488887f,-0.5998821033302736f,-0.03573078424359273f},
{0.4376617919275905f,-0.6013660628748274f,-0.025101453584827158f},
{0.43635939575319865f,-0.5653178603933869f,-0.007121988345897333f},
{0.4460447728218556f,-0.549055576586597f,0.015849823628537124f},
{0.4375802903747426f,-0.5019021527409592f,0.03427129407575231f},
{0.4226674557219062f,-0.4606819737360689f,0.031465886197523815f},
{0.41844415200406365f,-0.43869183826590435f,0.03373483443858176f},
{0.4150002752778321f,-0.40017031427753197f,0.042911223611256745f},
{0.4255372189533136f,-0.3538219310134317f,0.053497975089754846f},
{0.43246825596242305f,-0.3797284958299158f,0.04096415518965082f},
{0.43854399731328964f,-0.4240166164321387f,0.027686684880986353f},
{0.45196274023827454f,-0.45960231773379534f,0.014743642490435f},
{0.46473060964164986f,-0.4790902777632767f,0.006893483548994042f},
{0.46126120006848553f,-0.49955738470402894f,0.002946891382499429f},
{0.4548593728256413f,-0.5153516555593091f,-0.01194487891065935f},
{0.4592666728275343f,-0.5411650079016396f,-0.026840575863089265f},
{0.44716029571184396f,-0.5639835282401826f,-0.048120342974202784f},
{-0.2879084478822719f,0.0872290470110723f,0.21331051501626883f},
{-0.29497049146101967f,0.06655557266498408f,0.23778700136276484f},
{-0.2770160565501277f,0.08470133766104872f,0.24054255681684863f},
{-0.271677431799781f,0.09435283348219053f,0.22714294360691686f},
{-0.2550354848750819f,0.1105544877999963f,0.23979741585012873f},
{-0.2694536390779333f,0.08751014630668164f,0.2436927096554473f},
{-0.2946093291127391f,0.055732746733926086f,0.24404096374881867f},
{-0.29987542965624464f,0.054326113479521175f,0.2361016602927342f},
{-0.2969997509381431f,0.07844419336359958f,0.20444156754088819f},
{-0.28911787381149123f,0.10539191464808573f,0.18799838861844975f},
{-0.2711542002022709f,0.10992809215436272f,0.2017635412968453f},
{-0.2543262511675735f,0.1233394991534094f,0.21717103621391845f},
{-0.2424502741843222f,0.1361105695915206f,0.22668569072172148f},
{-0.22354149533492557f,0.1623463820256292f,0.22296689472611994f},
{-0.22557608384963132f,0.14036905281922393f,0.23084088772440303f},
{-0.23796354007518253f,0.11427784258751683f,0.23480327577023838f},
{-0.25957632422683546f,0.0900543091664813f,0.24067263059242847f},
{-0.2823175990182234f,0.06644274283059198f,0.24085433632523714f},
{-0.28608251626173586f,0.04836214699208981f,0.2354517185027753f},
{-0.2929887502980791f,0.03267446326290171f,0.2428182651588109f},
{-0.2993349328693906f,0.037224177969512245f,0.2403399397110871f},
{-0.3002301888726456f,0.03662882694253713f,0.2313981227463266f},
{-0.3003487121504993f,0.05183868850889225f,0.21148228222041313f},
{-0.29756008606606055f,0.10149818045743442f,0.17477397601829717f},
{-0.28902403239191327f,0.13519326756377015f,0.16428283911801433f},
{-0.26954438145392523f,0.14852572703834768f,0.17011217303794693f},
{-0.261465013339202f,0.134121959962079f,0.18991555875942573f},
{-0.23863887234942735f,0.16145242322231196f,0.20724612124323627f},
{-0.21813593889245725f,0.20966645622297958f,0.20410683896136445f},
{-0.21235396180072022f,0.181337229753645f,0.22272202672410463f},
{-0.2055090456936229f,0.18665802305128426f,0.21984685371212134f},
{-0.20539119067028264f,0.15547289352285065f,0.2163925005824611f},
{-0.21814414599280074f,0.13050446242648397f,0.22583280672921077f},
{-0.24822363939833955f,0.08961101844474403f,0.23165599993199315f},
{-0.2640674758276552f,0.07507034843548356f,0.22865944682755118f},
{-0.2764436450326175f,0.06041782281979405f,0.22821455505724209f},
{-0.27799581222107456f,0.04866894062061916f,0.23100198593289298f},
{-0.28777855684083564f,0.02475147201635429f,0.24492092001718088f},
{-0.2917989597900311f,0.01584973757350436f,0.24499881469550894f},
{-0.29364517702531906f,0.02063451213321484f,0.2333990127476608f},
{-0.29462177097061903f,0.04840875376037048f,0.19852072206170812f},
{-0.29775992816261854f,0.09448398028965993f,0.17059523180888253f},
{-0.29093114153091476f,0.13543002939418403f,0.1440357451485284f},
{-0.2848936574853385f,0.17580131587271125f,0.13791159306091716f},
{-0.27524501954120945f,0.20408920511650983f,0.13884603916352106f},
{-0.2719984712546541f,0.17548787475850564f,0.1535819914150129f},
{-0.2566297011023085f,0.16941229489362622f,0.17016721957388184f},
{-0.2463844553027634f,0.18433011542632186f,0.17946498990142332f},
{-0.23690349930833182f,0.21360087957040177f,0.18378454776698375f},
{-0.23117597061693188f,0.24107424411813017f,0.18504917215645494f},
{-0.22368889485709462f,0.2680434441013404f,0.18781543668127823f},
{-0.2132606057533062f,0.23483793151304796f,0.2057131220165135f},
{-0.20934768129035658f,0.2279107042983504f,0.2170593219077284f},
{-0.20402814482115825f,0.2370812990988217f,0.2169605360421959f},
{-0.19441679207917228f,0.2284206228635752f,0.20438900278960084f},
{-0.19494590091669534f,0.1837845318308665f,0.2015733044293106f},
{-0.189006726777952f,0.17811455270820523f,0.19658889069293406f},
{-0.1964813511182391f,0.1553868947977368f,0.22234566663208122f},
{-0.21749809474024737f,0.11811905346078545f,0.23721831783426506f},
{-0.23926172167778637f,0.0726265321182914f,0.241775975101674f},
{-0.23800844486614928f,0.09244608874906837f,0.23461867178892004f},
{-0.26197815418731896f,0.056020087675427724f,0.24110512087635444f},
{-0.2617562650038576f,0.06878799638789204f,0.2288983175374708f},
{-0.27424481783193116f,0.03968234104179024f,0.23932818644167486f},
{-0.28350471438340213f,0.006041481354966767f,0.2596684833236441f},
{-0.282701801804711f,0.0030783431010107058f,0.25436491484385193f},
{-0.2756754030704453f,0.003273848448882359f,0.2454251451389441f},
{-0.28397327553734264f,0.027400034504562173f,0.21436538823152457f},
{-0.2884935456114587f,0.048786713838557975f,0.18689366616627276f},
{-0.2933293242453815f,0.08709344127801825f,0.16362628065220572f},
{-0.2927480161248582f,0.10895137603216441f,0.15074689986253237f},
{-0.2952566775652302f,0.11303437392479515f,0.14212209157740835f},
{-0.2912287559559531f,0.14419113291503174f,0.13215003226009286f},
{-0.28288368920925544f,0.19143144897075287f,0.12554920328526945f},
{-0.27766397232839013f,0.23872785590928744f,0.11920358803972925f},
{-0.27172059424193695f,0.2692967209129775f,0.12901730078478646f},
{-0.25696610084931965f,0.22397157979636254f,0.14913404156543816f},
{-0.2617925175456079f,0.2043022178827065f,0.14963839842577f},
{-0.24479506240700077f,0.2816326057385451f,0.15886526578079063f},
{-0.23508877290298316f,0.322531075971641f,0.1677101497192418f},
{-0.22297702637821387f,0.2920002249818526f,0.1878335220494526f},
{-0.2187460616376428f,0.2750465399826696f,0.20036752574610805f},
{-0.2150429095970649f,0.2619691614363989f,0.2168912128700907f},
{-0.21074302858658042f,0.2656592841075771f,0.21833563809516462f},
{-0.20878149017058245f,0.28627115686153387f,0.21320667315196162f},
{-0.19015107491668065f,0.25124473677924564f,0.19851362942715886f},
{-0.18860434831862607f,0.2221510781421508f,0.1912789190812623f},
{-0.18547602902296073f,0.19017022959831734f,0.1877395287055576f},
{-0.1673731629919148f,0.18578911051212213f,0.20797697601211554f},
{-0.17276789881082352f,0.17467651178808205f,0.21939452402472426f},
{-0.18178121582129483f,0.15068917287168912f,0.24397370802231452f},
{-0.18902313991623126f,0.12344227754749734f,0.2652381562751947f},
{-0.20773725484474284f,0.09799472815076778f,0.2678476104694551f},
{-0.23419440932228983f,0.06798011917749792f,0.2542322679165528f},
{-0.23799284234503026f,0.020833097401331914f,0.27386004825087623f},
{-0.24373520331188592f,0.015262006135353024f,0.26621797356579463f},
{-0.25056326006942325f,0.05382486734926126f,0.25018785242600283f},
{-0.26677139826210233f,0.021497993643644818f,0.26349692724224244f},
{0.14920494400675516f,-0.912476991653149f,0.17027437402574513f},
{0.16693526080259732f,-0.8896641435099112f,0.16736979887757986f},
{0.15710781431176138f,-0.8909435204942524f,0.1564811153486976f},
{0.1382453585677599f,-0.9291844307073853f,0.17345734464163962f},
{0.14088836785033726f,-0.9029377572782201f,0.16296626829860206f},
{0.1491580535755888f,-0.8844855216256008f,0.16754251770271147f},
{0.1770880229397475f,-0.8669526161372442f,0.15126651502385227f},
{0.20136845679834894f,-0.8447869135266055f,0.1442038138146693f},
{0.18668158353811504f,-0.8751939929439516f,0.16688341583260222f},
{0.16807607324812945f,-0.9038376326306394f,0.18325591488816018f},
{0.1468496602573071f,-0.9342876715702495f,0.20636029835893918f},
{0.13582948463841685f,-0.9429683678182951f,0.19978244926507752f},
{0.13069132986764467f,-0.9523916935009942f,0.19154708037454374f},
{0.1231891062972317f,-0.9614243314599248f,0.19070109565836058f},
{0.12353023694622729f,-0.9390906834224515f,0.17956784903850492f},
{0.114901699609685f,-0.9313131049954656f,0.1746671041669117f},
{0.12142064244003284f,-0.9204298110614108f,0.17461518854679714f},
{0.10537947757104099f,-0.9315638895465828f,0.19083508015709436f},
{0.1275524736113052f,-0.8915971499017248f,0.17827882645364365f},
{0.1634055457748316f,-0.8571507619881783f,0.16341237546344745f},
{0.20638318527921748f,-0.8283109678224461f,0.13890061930242675f},
{0.22274482227731116f,-0.8291651288291464f,0.1292529237140265f},
{0.21338830717224305f,-0.8467946528711001f,0.14891499007324122f},
{0.19540846159131672f,-0.8818437681090567f,0.16522926068146898f},
{0.16426223956175423f,-0.9223325037711401f,0.1950726307636886f},
{0.1515925695747995f,-0.9448494989614908f,0.21402318348823163f},
{0.14031845830322306f,-0.9492285920359896f,0.21575268991339225f},
{0.13087031052441706f,-0.9578906451517597f,0.21843073634318358f},
{0.11261480623828378f,-0.9853434212985099f,0.22281511808376772f},
{0.1124248732193832f,-0.9800240877492035f,0.2072895769099482f},
{0.09996975648995172f,-0.9755746388422069f,0.20418174508651885f},
{0.0994428967697655f,-0.9523557044363811f,0.183486101476629f},
{0.08850408140348416f,-0.9580209824044769f,0.18963878558842465f},
{-0.36551306656721877f,-0.5188302241502157f,0.10853982793101785f},
{-0.3661466961476406f,-0.5340345739448451f,0.10455734444142886f},
{-0.37027903650866645f,-0.5080983424526339f,0.11724603259061643f},
{-0.3662255023718708f,-0.4998287576561244f,0.1319330567127595f},
{-0.36797042008474445f,-0.46638891508889846f,0.13540256721466576f},
{-0.3675091342994968f,-0.42997531443923315f,0.146765201492316f},
{-0.3522761313661925f,-0.388747031387557f,0.18152600262321555f},
{-0.34347227124297286f,-0.3580256194958514f,0.20676447016265084f},
{-0.34864910934456783f,-0.3532579475770898f,0.22053337101580517f},
{-0.3449349943177835f,-0.336294536234393f,0.23473267664635158f},
{-0.33150251233498096f,-0.33254459469139075f,0.22764878890059256f},
{-0.32102611740548986f,-0.340790024583899f,0.23931031461747057f},
{-0.3052027684484103f,-0.38741383388589545f,0.24171319848650297f},
{-0.3136284453878021f,-0.3809736675323593f,0.23444495005081442f},
{-0.3108114498275741f,-0.4102652633688062f,0.2286695386393522f},
{-0.31267957072471086f,-0.4621348089813783f,0.21205162550416384f},
{-0.3120007133813476f,-0.5091591938366447f,0.2011821322475799f},
{-0.31513238563606594f,-0.5486710508281347f,0.18779281164452546f},
{-0.3188642513725641f,-0.5595635845229256f,0.17718651504952004f},
{-0.26710982508321773f,0.3392399737118023f,-0.21780484746607603f},
{-0.27513180511518964f,0.373144426338318f,-0.22344469457838884f},
{-0.265588720574352f,0.363531269627868f,-0.20960405888739728f},
{-0.26056264451564937f,0.3249412543327068f,-0.20838954721198458f},
{-0.2556225278729714f,0.35708859067985776f,-0.21498819718838674f},
{-0.2666796848453707f,0.4050481908209836f,-0.2113203638330928f},
{-0.2724583992827187f,0.4166484177319563f,-0.21421231545164238f},
{-0.27943284202537294f,0.42452269545553284f,-0.22659738019720999f},
{-0.2834544805548531f,0.3965317938161639f,-0.225597745813703f},
{-0.2825231961778961f,0.31938305007348095f,-0.2288489134494226f},
{-0.2750623810143423f,0.28204785208128336f,-0.22904154179694083f},
{-0.2657773776414711f,0.24076534267250288f,-0.22432931162981992f},
{-0.2619363696880945f,0.22743037060345125f,-0.21553286817553202f},
{-0.2593709905443001f,0.2885867437431068f,-0.20797288255481802f},
{-0.24481814215429684f,0.3202561782468389f,-0.2174072710900579f},
{-0.24235710101925764f,0.3638708098523699f,-0.22186737913462687f},
{-0.24057090663809336f,0.4040961969285579f,-0.23105531986743583f},
{-0.25278830855730405f,0.43036913201641425f,-0.23656274209568204f},
{-0.258107176771989f,0.41409396014046373f,-0.22664787750289622f},
{-0.262682200157484f,0.4302359581348406f,-0.22667432189573114f},
{-0.2698381255273065f,0.43717145300712695f,-0.21887108950732215f},
{-0.27513291958098385f,0.4543040272960104f,-0.23248825515202887f},
{-0.2909143629243484f,0.4240391192919931f,-0.22214708030155633f},
{-0.291876246771091f,0.29040594819738075f,-0.22284277787113893f},
{-0.27618288978418976f,0.18851467525609641f,-0.2349150506336737f},
{-0.2692634234585548f,0.16792501213743816f,-0.230238363319885f},
{-0.2610770825637041f,0.16736986474686413f,-0.216459937980701f},
{-0.2575682597855506f,0.2194324838558275f,-0.21357941574538705f},
{-0.23519955547752264f,0.27511568042063134f,-0.2289929079545559f},
{-0.22616711937607628f,0.372423763247574f,-0.23478973856990482f},
{-0.23316911991495187f,0.4452278624890446f,-0.24140271511564448f},
{-0.24989609346161726f,0.4548486377259104f,-0.24380592301905932f},
{-0.26491944721185595f,0.4645262337197564f,-0.24061907248983744f},
{-0.26686171461256186f,0.4492919739580111f,-0.22877671327696392f},
{-0.2727600062363126f,0.47257214555008903f,-0.23692400537270467f},
{-0.32424178362178185f,0.43595781250611965f,-0.20006472358372634f},
{-0.3136347667142803f,0.29758720349424395f,-0.2075509079834098f},
{-0.29549589143287297f,0.18203843909495346f,-0.2229839761189125f},
{-0.28256714798905597f,0.18166874561194693f,-0.23409959420595272f},
{-0.2935184264613735f,0.0672568627492862f,-0.24003446134342832f},
{-0.2907824458712157f,0.05277147300567907f,-0.24136008069017076f},
{-0.2820939271144544f,0.08640755079494318f,-0.23714698883621185f},
{-0.27111642841735023f,0.10803545194734539f,-0.2279014581631674f},
{-0.2642245198879366f,0.12270305312987942f,-0.21757021257610068f},
{-0.2618639474724032f,0.11408590374266822f,-0.2165181759897015f},
{-0.24656346570695442f,0.1333979736597008f,-0.22716174822517968f},
{-0.271916463995688f,-0.44013608075683475f,0.27131651221168535f},
{-0.2980871072722341f,-0.3743475596260701f,0.251032366769775f},
{-0.268852411873353f,-0.456640882519561f,0.26989210806181824f},
{-0.24017464764776142f,-0.500213608511377f,0.2932708222280398f},
{-0.233758351472933f,-0.5203876205099207f,0.2932852306027788f},
{-0.22256690721557368f,-0.5623473469044037f,0.2992128234339694f},
{-0.2525311601833962f,-0.5123091639410997f,0.28083282832530554f},
{-0.27294158979222294f,-0.466959543886101f,0.26521375914221246f},
{-0.2949912211622367f,-0.40710702560676243f,0.25297137151609195f},
{-0.32187057119201673f,-0.31625637326029205f,0.240636379113086f},
{-0.3011974421284672f,-0.3579677458927302f,0.2571804102842502f},
{-0.2936890884649821f,-0.37659489849224304f,0.2594848323221326f},
{-0.2827710835429115f,-0.40271058659992603f,0.26681273708125f},
{-0.26118855357850534f,-0.44889977867755804f,0.2804451408411964f},
{-0.23422235277254672f,-0.49908207726048576f,0.29512769753849233f},
{-0.20433485876910176f,-0.5685552092907028f,0.3199052649467155f},
{-0.21052815023226681f,-0.5654906705855902f,0.31260009677717104f},
{-0.20811793149970417f,-0.5782231586216207f,0.3093949069643079f},
{-0.20613933081425423f,-0.5912784093379945f,0.30834216068949066f},
{-0.20977464067921608f,-0.6024346963960571f,0.3031238015658084f},
{-0.2278083269632113f,-0.5665800539937855f,0.2950083848916348f},
{-0.23229558802662548f,-0.566581026096933f,0.2867046351847245f},
{-0.25527257180228613f,-0.5267845033068105f,0.27024923751004654f},
{-0.26821292630107446f,-0.5074255833301083f,0.26047457781373057f},
{-0.2762528408393115f,-0.4965473156474096f,0.2511420954357654f},
{-0.28476567134110825f,-0.44726991866825716f,0.2537729274000079f},
{-0.29453431249717227f,-0.4240451484563232f,0.24714941389359427f},
{0.3119139221000065f,-0.6244755735257046f,0.13348301621778433f},
{0.31513424803695955f,-0.6193053807849701f,0.1456893138505497f},
{0.308414684365128f,-0.6301915920908752f,0.13774954399743597f},
{0.3039782042702857f,-0.622094006869409f,0.12633071365859885f},
{0.29936530817112794f,-0.6381693770202983f,0.13030653053917096f},
{0.2983381351147403f,-0.6514856252140808f,0.13997090380539545f},
{0.3079564179428804f,-0.6248446986205319f,0.1518278126932468f},
{0.3063484233487471f,-0.61106416546425f,0.15466642931484578f},
{0.3267669782525159f,-0.6203171128062261f,0.1471829806152768f},
{0.32143654041676417f,-0.6320107965451491f,0.1386086282019344f},
{0.31499078048610074f,-0.6253730170266433f,0.12756909126308807f},
{0.3165857053393375f,-0.6179976343248398f,0.12081480491675473f},
{0.29657955908704253f,-0.6087159945350997f,0.12390639571197035f},
{0.2879688946371125f,-0.6294578794449831f,0.12378032933865533f},
{0.28511984198358165f,-0.6607478123167932f,0.1250859424839003f},
{0.2902379969273031f,-0.668966818002215f,0.12995725334707717f},
{0.2898095788525184f,-0.6681872284622088f,0.14337443559498697f},
{0.28963717450009907f,-0.6453528198148453f,0.15051844606120404f},
{0.28693937047223805f,-0.642012694648257f,0.15778868969876247f},
{0.292380247724806f,-0.6216825703210825f,0.17028434366064782f},
{0.3039779609788969f,-0.6010421666053493f,0.16112948418227196f},
{0.3156853434041406f,-0.5980045386901007f,0.1554819771096386f},
{0.3273824310976915f,-0.609747665826161f,0.1447654355184463f},
{0.33898136080872643f,-0.6225388380824728f,0.1366595327062242f},
{0.3446857885046741f,-0.6278020818113733f,0.13979601766832847f},
{0.33324832140800836f,-0.6343377310045563f,0.14498741606897944f},
{0.33434921388002514f,-0.6389604766865339f,0.14129765780368053f},
{0.3260052212276249f,-0.6375267700938697f,0.13300932894615355f},
{0.32075579729953557f,-0.6289875961279802f,0.12379386016454202f},
{0.3355681642952741f,-0.6396851110576771f,0.12881618273644688f},
{0.34303230160805437f,-0.6356320220697546f,0.1279633242417236f},
{0.34487744474904486f,-0.6264662909722439f,0.12620591898743416f},
{0.32209454694441986f,-0.6002207521946216f,0.12481143861598448f},
{0.30538848583311506f,-0.6008528210979683f,0.12077412532165412f},
{0.30569864304477556f,-0.5903217950339966f,0.11944155676541696f},
{0.28515289242818825f,-0.5900698747689289f,0.13032090810408337f},
{0.2801830889240347f,-0.6240364155703537f,0.12834405082985206f},
{0.27328609464842774f,-0.6632833834846217f,0.12695204799341872f},
{0.2681578075214084f,-0.6922199576899383f,0.11887472607614034f},
{0.2833712568389429f,-0.6963320549325247f,0.12587914890482602f},
{0.2832005746495858f,-0.7005660581594366f,0.13484328599529735f},
{0.27853847738227183f,-0.6988008367708783f,0.1404138513694096f},
{0.2736332746475018f,-0.6808420651113f,0.14842000577462205f},
{0.2731320285172419f,-0.6567579472177304f,0.159672465175001f},
{0.2772084809153462f,-0.6360004990958169f,0.16547255844473893f},
{0.2846978886603296f,-0.631244013268902f,0.17541030092733662f},
{0.2872870572398381f,-0.6223071821840006f,0.18027828857887926f},
{0.29505584105496063f,-0.6093542232789373f,0.16946440918400152f},
{0.29386783432962815f,-0.5975256636811267f,0.1635264610638727f},
{0.30266176518944204f,-0.5868613819301799f,0.1633175821264704f},
{0.3141989923796033f,-0.5891477897812112f,0.1595916531248227f},
{0.3203624758668024f,-0.5840014279100957f,0.15080339552272207f},
{0.31776813973569895f,-0.5930839969113489f,0.14832350939792324f},
{0.3300691712106039f,-0.604360893816207f,0.13981294713680403f},
{0.3335168162973427f,-0.6006728789621267f,0.14124634988083415f},
{0.3483165788868061f,-0.615154863688698f,0.1342846124731971f},
{0.3493579775837892f,-0.6285571924129959f,0.1324950640705721f},
{0.34366526293396277f,-0.6358447108015687f,0.13941129855164455f},
{0.34801071698992725f,0.16078071800833543f,-0.18865238243180155f},
{0.36629820718804007f,0.10234942302987647f,-0.16929905603222675f},
{0.339935868358034f,0.1299262140404577f,-0.18351295064684006f},
{0.3726249774438205f,0.05706407970987854f,-0.15280327198700416f},
{0.39199261128939217f,0.06360978034336562f,-0.14995351070746307f},
{0.41212127228568857f,0.051175170209510824f,-0.1411105210421397f},
{0.42742702253147424f,0.03902790101715766f,-0.12870130139257088f},
{0.4446075815315699f,0.026728734067961807f,-0.10727227023357923f},
{0.43655044323789366f,0.04341137121183955f,-0.11517629537587655f},
{0.4292214240129819f,0.05012898961496838f,-0.11765616131492694f},
{0.42224856213315115f,0.05051335388744328f,-0.11003279031936597f},
{0.434900076633016f,0.03760489499597039f,-0.07184535640342264f},
{0.443780939012002f,0.04680693919247643f,-0.03475507634640754f},
{0.44113136298674205f,0.05477297070428148f,-0.03987812474050856f},
{0.4191808223933028f,0.05997663885274691f,-0.07454016125403184f},
{0.4214509785920422f,0.08229326605467298f,-0.09437983988875774f},
{0.42379254346942097f,0.10209636917567388f,-0.09738330289360542f},
{0.42373341410026666f,0.12900534444727635f,-0.11164090709039762f},
{0.40826336461125495f,0.14640102509307437f,-0.1329963803197476f},
{0.4074665916873062f,0.19156535272649297f,-0.14375280151295838f},
{0.39569193334980984f,0.24739234087653805f,-0.16012594863728136f},
{0.3534057162859733f,0.3310589023596964f,-0.19506280242902485f},
{0.3165598484580224f,0.36394157152465184f,-0.2195446178131031f},
{0.3209004398734339f,0.3144278982354553f,-0.21216143385074016f},
{0.3315143868670896f,0.2555169983738557f,-0.1945114839562033f},
{0.33445689634857073f,0.2196825385327783f,-0.18486339315209716f},
{0.3231887526216713f,0.25998427979596767f,-0.1998603025095009f},
{0.32443007415820607f,0.25375753204841206f,-0.20674159121043117f},
{0.3274203654310073f,0.22131847763957635f,-0.20379833273144302f},
{-0.0795187800870007f,-0.8949641869205849f,0.23776888624717174f},
{-0.07885287030763574f,-0.8946561768351114f,0.22635901731822422f},
{-0.06231909137185201f,-0.8662685094368845f,0.19617960233320245f},
{-0.06483045557769651f,-0.88247064927506f,0.22958365981811518f},
{-0.05232173824936146f,-0.8601036065728492f,0.20455294718861766f},
{-0.03970953602574389f,-0.8290435458167956f,0.17851449506641953f},
{-0.047090437936127924f,-0.83583873486387f,0.17326383449563784f},
{-0.09912227377875434f,-0.9134139907217239f,0.26387269982274614f},
{-0.08924217648159839f,-0.9076649015261982f,0.26696627519575356f},
{-0.07620226055957523f,-0.8952469074505147f,0.26219582720538054f},
{-0.0662743814710991f,-0.8762595454825282f,0.24277372583613127f},
{-0.05318730951595667f,-0.8543671621550956f,0.2121164387551094f},
{-0.034148456890980235f,-0.8110988786833223f,0.17836944665273727f},
{-0.028485763761089893f,-0.7902483795732426f,0.15999733461003446f},
{-0.03789531107688231f,-0.8062890578594566f,0.16011782334233932f},
{-0.039488252414735144f,-0.8379688678378755f,0.16488488650142502f},
{-0.02878717310683074f,-0.8184773413053711f,0.155941996504775f},
{-0.017863966636115256f,-0.7942016086013353f,0.15107876100337297f},
{-0.013665074924964259f,-0.8166018844822962f,0.13963282226681875f},
{0.016074731643794783f,-0.8249854316399249f,0.14726194832549439f},
{0.0029060391461295646f,-0.8519309643643194f,0.14816411422915507f},
{0.003237545442761094f,-0.8730089048010831f,0.14516303208021286f},
{-0.019567086038462907f,-0.8730056623324426f,0.1409716940886013f},
{-0.026460308766339223f,-0.9076963509222329f,0.14718271713813955f},
{-0.036273576362523416f,-0.9358380964098956f,0.16032183963918858f},
{-0.01034381387147616f,-0.9321740739114214f,0.15744866289148304f},
{-0.019166745277319288f,-0.9517126119895828f,0.16795735820566574f},
{0.00484323248712802f,-0.9482235064380019f,0.1694709748642763f},
{0.027747482761608638f,-0.9525400247548138f,0.18734176003372557f},
{-0.006555905060516067f,-0.9809035372490398f,0.20446985521127597f},
{0.023680467732093414f,-0.9761439715018795f,0.2165610547689718f},
{0.003545350483526936f,-0.9888897523844467f,0.21195841196760243f},
{-0.008516813468681845f,-0.998521552227172f,0.20344339184330634f},
{0.014239857736709728f,-0.9959143280269079f,0.19213928029995006f},
{0.04798800042674169f,-0.9970669331991472f,0.2099623442353244f},
{0.07068310403705153f,-0.9985110142040903f,0.2170516821331562f},
{0.09607052115165277f,-0.9990878039041914f,0.21867850259370852f},
{0.033079354847905675f,-0.9984698384645417f,0.12358057329713004f},
{-0.15052049278985277f,-0.9988462591138104f,-0.033774950957542293f},
{-0.3321029703563057f,-0.9991746950518668f,0.04631174984914963f},
{-0.35043135263108127f,-0.9984301214109184f,0.0683338244853499f},
{-0.3582201575214107f,-0.9984513578806614f,0.11939814571983311f},
{-0.3391835136422743f,-0.9991163359283758f,0.16174847272064413f},
{-0.33073726955006055f,-0.9986763673558651f,0.17936296156725026f},
{-0.3026823142813311f,-0.9921544975919968f,0.17262428836611404f},
{-0.3001160023434783f,-0.997368135375365f,0.1840118063595242f},
{-0.3097873970629286f,-0.9991315740436155f,0.23173200989886367f},
{-0.202592393093457f,-0.9993666338967155f,0.2794119694303053f},
{-0.1302239968571342f,-0.9989117523057552f,0.2447213222744195f},
{-0.1223230516350823f,-0.9954020583531964f,0.2617584126612485f},
{-0.12264042365819028f,-0.9851078748626323f,0.27465787508337397f},
{-0.11816343607831284f,-0.9801369165211877f,0.28703558371725507f},
{-0.11287736545517536f,-0.9751004649877985f,0.29936891557685175f},
{-0.10796037955536844f,-0.9675545424592847f,0.30040551112811914f},
{-0.09398930568291784f,-0.976705522024333f,0.30272679251556156f},
{0.4579902950204449f,-0.4871137781008268f,-0.004877927007822712f},
{0.442027875818438f,-0.495038066547312f,-0.017086098727967507f},
{0.4394211775100406f,-0.48927179396784387f,-0.024637483095039957f},
{0.4316726580615137f,-0.4974418417764982f,-0.031736365664649865f},
{0.4354039968437372f,-0.5146456643204412f,-0.03830445229313207f},
{-0.027770917353113597f,-0.7118538171217589f,0.2685239350325958f},
{-0.01641050669501271f,-0.6897385310738129f,0.2594132812808468f},
{-0.027913293811150038f,-0.6895313541137247f,0.2592486165693338f},
{-0.04387083018685543f,-0.7319599040768774f,0.2798344305844911f},
{-0.044456817151380355f,-0.7109690173361843f,0.2627664974364878f},
{-0.02809213423009132f,-0.6858268039444668f,0.25016681887615166f},
{-0.015012313208262f,-0.6655806523307096f,0.2529841374083544f},
{-0.0102550390747511f,-0.6528249825562332f,0.27079956263156435f},
{-0.016178100736625785f,-0.6987246440698641f,0.2789988914619102f},
{-0.010756697419241788f,-0.7200107346322715f,0.2723843956730002f},
{-0.01267528587464604f,-0.7165838787415874f,0.26241161710559635f},
{-0.019975548907325003f,-0.7538315375173443f,0.27704047440006224f},
{-0.04535618361045788f,-0.7747828697528092f,0.29546290207671555f},
{-0.08368764496617663f,-0.7740220848310657f,0.31704774171570393f},
{-0.07537716915541204f,-0.7592155536414354f,0.3027344121043853f},
{-0.0634560239040567f,-0.7397485060473148f,0.28387732576946284f},
{-0.07474772864899085f,-0.7455460665368302f,0.2767564768559433f},
{-0.05431765405732251f,-0.7236196394134874f,0.2538025526418303f},
{-0.04158394956434791f,-0.7088797371297526f,0.24952165898375214f},
{-0.036799057077370356f,-0.7014758224037647f,0.24335886393681488f},
{-0.014702388663912342f,-0.6873143299920437f,0.23247350361956684f},
{-0.010393030975749628f,-0.65298822789091f,0.23787328481317213f},
{-0.011110149874034565f,-0.6364642974755386f,0.258321506392668f},
{-0.008306621395224582f,-0.61087919813946f,0.2614852569888454f},
{-0.004942286079428919f,-0.6051179507489401f,0.2697749021696508f},
{0.0030816965912675498f,-0.6353107191377441f,0.27708165120201866f},
{-0.004309725281265396f,-0.666059040756906f,0.28411520312807875f},
{-0.013562522823740134f,-0.6935019280117471f,0.2861803900501622f},
{-0.009938186569062805f,-0.7147607837499078f,0.29137650022945705f},
{-0.00806965027047177f,-0.7327952604653146f,0.28416582154825554f},
{-0.00015902545084974458f,-0.7467250969785637f,0.26521955457682395f},
{-0.015096339042069891f,-0.7788664349712113f,0.2848250445328553f},
{-0.09598717207162062f,-0.7702192948738905f,0.3112345170854164f},
{-0.09527409775987383f,-0.7674269408004414f,0.2958927788374254f},
{-0.10380459929079844f,-0.7790463771070529f,0.29264321118786984f},
{-0.09146739282991348f,-0.7567952430970718f,0.27739780676818254f},
{-0.07591069442220741f,-0.7431375901530783f,0.26562102149024763f},
{-0.06815467224971598f,-0.7432713313604233f,0.2510196008775125f},
{-0.0568145110845015f,-0.7432611184341319f,0.2352640951584568f},
{-0.039397482416140016f,-0.7165089843029188f,0.2394747147894385f},
{-0.016579667516383748f,-0.7243984193987413f,0.22973034965186614f},
{0.006239348966607265f,-0.6723808665667321f,0.21769278893975502f},
{0.003749282850159089f,-0.6542257800045299f,0.21838913457810263f},
{0.013966790244155f,-0.6195036420187048f,0.20771172252901404f},
{0.0017042753020464958f,-0.5850094308799334f,0.22809246527636534f},
{-0.008379763923411993f,-0.6057351055714297f,0.24359834128159483f},
{-0.011527886500682864f,-0.568439138050078f,0.26171857449313457f},
{-0.009983688433219576f,-0.5539775781136818f,0.269666814923729f},
{-0.005724884358357267f,-0.5449561251841903f,0.27704576306614775f},
{0.0024484569145125303f,-0.5791916070862302f,0.27700876152689036f},
{0.017203755612250935f,-0.6148103790182416f,0.2729357343315702f},
{0.01653327641688886f,-0.658022247572819f,0.28153079519797336f},
{0.0016315991708882238f,-0.6769640566810737f,0.290684997045914f},
{-0.006255598494083381f,-0.6948391785992094f,0.2928973805702744f},
{-0.006087166484471094f,-0.7086368951394338f,0.2904435128127782f},
{0.004271650710118594f,-0.732334217971456f,0.2900322993700922f},
{-0.003320060532661045f,-0.7352784698017478f,0.29148183158951585f},
{0.003282039081904803f,-0.7610799879834665f,0.2863450335135189f},
{0.0017869699388666125f,-0.7551969950322008f,0.27935863549576245f},
{-0.0011974355946591394f,-0.7668582562095337f,0.277816072473921f},
{0.001946288614272303f,-0.7775105423138814f,0.2849397983877939f},
{0.010761699235218171f,-0.7700884721008036f,0.2842944164521618f},
{0.021373923003403687f,-0.7634320494500223f,0.2582757920469489f},
{0.02397013428429431f,-0.7577041967242398f,0.24148938422008726f},
{0.03470872296238992f,-0.7408375654211276f,0.24065802036020534f},
{0.04723252435683185f,-0.7018742901399367f,0.22942420409210176f},
{0.042120808666855664f,-0.7060030841836881f,0.2191002529970685f},
{0.03554595875024574f,-0.6771498356854316f,0.21109226487597346f},
{0.021796717753642354f,-0.6883338430881107f,0.21475425180108096f},
{0.023753402028349822f,-0.6647671815431883f,0.20702921687722625f},
{0.019253821283954014f,-0.6556504072600374f,0.20323550519479996f},
{0.018960968570726516f,-0.6486939192093968f,0.19616753550527993f},
{0.01932258669195817f,-0.6417779577671318f,0.1953362428267214f},
{0.019428282457896424f,-0.6248456717860872f,0.19682028311426888f},
{0.01331117732129852f,-0.6118346777919151f,0.20080881170430503f},
{0.011430815361358206f,-0.5912305861127696f,0.20666086096565436f},
{0.0065125428856915996f,-0.5500386150976811f,0.21776121968929862f},
{-0.006219608367062585f,-0.5323562437039622f,0.24178369561923985f},
{-0.011267872812907493f,-0.547700981129205f,0.2564065354358617f},
{-0.0118787424307846f,-0.5085846745020366f,0.25580344370557234f},
{-0.008720880761105953f,-0.5075384121020927f,0.2728280114915277f},
{-0.002137357347123351f,-0.5199116639352047f,0.2798233454213864f},
{0.0086026528326239f,-0.5506948389050292f,0.2779218287971044f},
{0.02429449695080166f,-0.5862246118722675f,0.26828032385902145f},
{0.03289391581404756f,-0.6014069156424013f,0.256920750378276f},
{0.039383551062508564f,-0.614485996165986f,0.2555087668381326f},
{0.029341844538705305f,-0.6452827880167299f,0.26925521582700745f},
{0.023154085033014533f,-0.6728041372756703f,0.27810864152426273f},
{0.0043995104278192546f,-0.6853750012113441f,0.29186860646531493f},
{-0.003459698103359588f,-0.6938767274266955f,0.2844444496832954f},
{0.0008540738892595666f,-0.6934602656894209f,0.2734713876012118f},
{0.013368551592748273f,-0.7046552976979595f,0.2718825014739753f},
{0.01911033248493889f,-0.7388972634748728f,0.2762755556495244f},
{0.007294362419694184f,-0.7584735744003624f,0.29010079067688105f},
{0.26216717353550173f,-0.6920936735230219f,-0.10548418051687936f},
{0.27452844884535527f,-0.6852790317889198f,-0.08489134611090395f},
{0.2699190172580707f,-0.6910363886420342f,-0.09129933319423901f},
{0.26189176874576187f,-0.6985346504937183f,-0.10125869780061542f},
{0.2732843926711139f,-0.7159983358635276f,-0.0884577790150414f},
{0.27743807043062496f,-0.7384271437686728f,-0.08170733221053864f},
{0.268145892617803f,-0.6814772149973f,-0.07721105449202867f},
{0.2818783603198792f,-0.6746332306218533f,-0.07329099808544075f},
{0.30336996517414977f,-0.687272343635335f,-0.09620555902773154f},
{0.28210468611836104f,-0.694891053847827f,-0.11131281537247203f},
{0.25324882303448065f,-0.6942803829002108f,-0.1257533608823576f},
{0.25193236376788863f,-0.7005245583855054f,-0.12266075761249767f},
{0.2694698089248237f,-0.7589414248034771f,-0.10500889219667672f},
{0.2789450502276374f,-0.7684757954754453f,-0.09598900950593055f},
{0.2898933295227032f,-0.8044935217264063f,-0.08669230371101616f},
{0.2780426006610911f,-0.7710214180835778f,-0.07779197695851639f},
{0.27106416645228915f,-0.7245649061396511f,-0.07685129027242799f},
{0.26739542261350085f,-0.701483766026971f,-0.07385090718782572f},
{0.2691743628741285f,-0.6766785802652813f,-0.07053774168186092f},
{0.2781156921937035f,-0.6668207988442049f,-0.06217766948723422f},
{0.30228242716832304f,-0.6658518637968177f,-0.06884638207157837f},
{0.315448783431211f,-0.6734961875992362f,-0.08413440073099099f},
{0.309513997036729f,-0.6892980769809323f,-0.1048040960924939f},
{0.2999529588662856f,-0.696170268283773f,-0.1159858756259924f},
{0.27414985982174345f,-0.6966450902069464f,-0.13460139592237758f},
{0.24881224201089633f,-0.6923185215122383f,-0.13763164860259888f},
{0.23663678607689748f,-0.7131280063687566f,-0.15080929188607567f},
{0.23948968889633712f,-0.7200001976715974f,-0.1411617269738362f},
{0.24671641630993835f,-0.7248969085807306f,-0.1304638285149193f},
{0.24886559719359547f,-0.7367792897582693f,-0.12233664779904942f},
{0.25837171950426463f,-0.7526152218734677f,-0.11819018378857803f},
{0.26216170319768056f,-0.8040353976668055f,-0.12360067511533059f},
{0.2756006286838596f,-0.8206977693816799f,-0.1184658424937849f},
{0.2863433108192527f,-0.8377187302931153f,-0.11250912056521983f},
{0.29261364597208883f,-0.8178922839476811f,-0.09929835565581316f},
{0.30671371952582194f,-0.8630697429416494f,-0.09582924993128307f},
{0.29012068904398575f,-0.8321612559080559f,-0.08339239068009144f},
{0.2888035817086287f,-0.8233729186253694f,-0.07835338618073115f},
{0.2814888284958093f,-0.7907142857700622f,-0.0763859110298828f},
{0.27224714798867355f,-0.732961585720237f,-0.07044388007653454f},
{0.27714209742565526f,-0.6901031175624697f,-0.05637234810865613f},
{0.28106687517255735f,-0.6631759049983759f,-0.049927116194674895f},
{0.3003955207762642f,-0.6608911183816647f,-0.05363243660959599f},
{0.3190111228780509f,-0.660783476284616f,-0.07195439556674348f},
{0.31424458561083185f,-0.6778817645486083f,-0.09351761414436087f},
{0.30847109928232397f,-0.6907155722928013f,-0.12154789924130054f},
{0.307466134798827f,-0.6955137204420424f,-0.12348068252747367f},
{0.30299780053057385f,-0.6983198539448062f,-0.13660098978618182f},
{0.2914625387948638f,-0.698300725292161f,-0.1520520317370387f},
{0.2680087474558302f,-0.6979850956178638f,-0.1547643843774697f},
{0.2701360841724758f,-0.7234573672443658f,-0.1795594995755147f},
{0.2574136061428449f,-0.731504859937522f,-0.18130893570881043f},
{0.23585995242275415f,-0.7419746084437446f,-0.19108047511338414f},
{0.22286411580082818f,-0.7292794056098572f,-0.1691037737899955f},
{0.21668523058758632f,-0.7440799384449838f,-0.171564672562388f},
{0.22683616857052424f,-0.7793962120632478f,-0.15494475253884382f},
{0.24078637037911116f,-0.7854654695392412f,-0.13884721418656057f},
{0.25002959137757347f,-0.7917500101469243f,-0.13174895949996723f},
{0.25287471312220194f,-0.7942893103661709f,-0.12532591597312823f},
{0.2556827111506748f,-0.8353971450570389f,-0.1337184202910152f},
{0.26409519510986396f,-0.8398796645943905f,-0.1350039974873439f},
{0.27863254190749026f,-0.8662534328076322f,-0.13803854548234695f},
{0.2880713479344101f,-0.868774576477381f,-0.12663293255909208f},
{0.3032267812861766f,-0.875373773593806f,-0.12262243868755413f},
{0.3007532982932575f,-0.851142134001169f,-0.10997291089029676f},
{0.30990071135528285f,-0.8646106039861767f,-0.10838667865777325f},
{0.32065289779095724f,-0.882087744750918f,-0.111303484244664f},
{0.3432372496365542f,-0.9125690705381678f,-0.12453420860962447f},
{0.3324390248207782f,-0.9152990124023253f,-0.11517832138757297f},
{0.3048485765577808f,-0.8949032333972184f,-0.0947733429932268f},
{0.29691397319385415f,-0.8724099054656834f,-0.0879410716639014f},
{0.2989559178202465f,-0.8387098749758011f,-0.07124420994183606f},
{0.28497758982725907f,-0.7588461045122256f,-0.05936745315125108f},
{0.2907018356785217f,-0.733892424948321f,-0.03411752648116146f},
{0.28970331576080893f,-0.6734206440293949f,-0.01668545305578206f},
{0.2872294269281057f,-0.665090268257914f,-0.030882675304610217f},
{0.31383809350846f,-0.6608690712947616f,-0.04217008473476261f},
{0.32215744573648925f,-0.6587246723086638f,-0.047207650733946206f},
{0.32277666800457994f,-0.6544399284846769f,-0.05134714428676663f},
{0.31064366376191116f,-0.6382449205901396f,-0.08029579488167604f},
{0.3136178659308157f,-0.6611616807166001f,-0.08709594856045334f},
{0.3062519269720482f,-0.6738721216657272f,-0.09968389495132755f},
{0.29976426142766976f,-0.676131942761277f,-0.11425244679119187f},
{0.30095873290453495f,-0.679112346204577f,-0.13798152286788276f},
{0.311234395439722f,-0.6915144530338482f,-0.15118332105536073f},
{0.30060841242797026f,-0.6947595819435675f,-0.16510509283091307f},
{0.28016397939473014f,-0.6953530684448335f,-0.16885049576774472f},
{0.27772423634908716f,-0.7110893031485972f,-0.17398435522373512f},
{0.2863783469040589f,-0.7404852986134522f,-0.21411385362049237f},
{0.27787428976596923f,-0.755736499530159f,-0.2247916300754603f},
{0.2609533917342555f,-0.7606964343281518f,-0.22153407949360954f},
{0.22504523160088963f,-0.75914341508863f,-0.21714213978385472f},
{0.21049135055049376f,-0.7404883795961055f,-0.18698807491162206f},
{0.18818353814617927f,-0.7503408107314434f,-0.2049394288398608f},
{0.19757596157286678f,-0.7528651968698328f,-0.1922512782690258f},
{0.20400567170872264f,-0.7814488561987092f,-0.17895584051945404f},
{0.1888031450058977f,-0.8186422078743681f,-0.18823932464915488f},
{0.22730951162202415f,-0.8292980594193311f,-0.1585520573338957f},
{0.2412767958858113f,-0.8214065175688184f,-0.14344539912475307f},
{0.2521560558574059f,-0.8404366765106737f,-0.14275833361863854f},
{0.2556474115887314f,-0.8731128167843059f,-0.15009422237245898f},
{0.2635644044807753f,-0.8813734858544616f,-0.15698485388768318f},
{0.26531953511994044f,-0.909599529152332f,-0.1782829400966896f},
{0.2813872867444139f,-0.8914638952771574f,-0.14960424307703957f},
{0.2934764794137539f,-0.8940991649188285f,-0.1399545915958584f},
{0.3057880276635844f,-0.8933122798243808f,-0.1356533719515315f},
{0.3318867140590608f,-0.8959543584377154f,-0.12644220910877976f},
{-0.35084976069946644f,-0.917127943200113f,-0.12043088579315281f},
{-0.3581251612645417f,-0.9046726649846942f,-0.09404591236472383f},
{-0.33850050228436823f,-0.8850439932902169f,-0.09192171612556876f},
{-0.3276025173750967f,-0.9075334296219385f,-0.11105635650123376f},
{-0.3156209859261461f,-0.873843773544335f,-0.09131537236496853f},
{-0.3296704814311993f,-0.8714711236768009f,-0.0864292887211734f},
{-0.3355469076397825f,-0.8593830252875068f,-0.07187058433931344f},
{-0.35174189534857137f,-0.8924255358325112f,-0.0786535748198967f},
{-0.3800992480023064f,-0.9288546975693909f,-0.0766405468093166f},
{-0.38205612563523544f,-0.9243214374349642f,-0.1072936278178129f},
{-0.37100362944590504f,-0.9228335873530049f,-0.11979893906670436f},
{-0.3651426442724536f,-0.9375311792456484f,-0.15614017593310808f},
{-0.346814200378025f,-0.9440104145840431f,-0.15063546921922796f},
{-0.3399955257438706f,-0.9212818642510131f,-0.12342108676129013f},
{-0.329840596294785f,-0.9345499662475961f,-0.12969884814472832f},
{-0.311232248313535f,-0.9049323652621653f,-0.1053088885400284f},
{-0.3142435933219359f,-0.895882381370897f,-0.10184758407605782f},
{-0.3036892835283684f,-0.8717431446976615f,-0.08744381699978916f},
{-0.30224451408316344f,-0.8469736229037943f,-0.07803431218030918f},
{-0.31658801607632736f,-0.8490129741927188f,-0.08225046376876512f},
{-0.32622236888502354f,-0.8523963839783614f,-0.07700211393497332f},
{-0.3194050520080522f,-0.837581909165525f,-0.08051075397898327f},
{-0.32231400533880855f,-0.8226165108238089f,-0.06418247127413022f},
{-0.33089265306693266f,-0.8422597715023532f,-0.05435755756351683f},
{-0.3434267375065817f,-0.876527027897218f,-0.06182754130648344f},
{-0.3504169453187501f,-0.9005020460702216f,-0.05464858612253202f},
{-0.35666184961580344f,-0.91506297938367f,-0.050900650405477865f},
{-0.3727762685658029f,-0.9339804721019361f,-0.05556206879420033f},
{-0.4158245677513209f,-0.9686734299948119f,-0.0681164080387748f},
{-0.41211559902797523f,-0.945935315866663f,-0.10584596012409837f},
{-0.399440781675174f,-0.9329591752231536f,-0.11278441486454739f},
{-0.39515547052541583f,-0.9301613093779786f,-0.1351561789070723f},
{-0.37977044765837054f,-0.9311140331445708f,-0.14360319324494936f},
{-0.38850180376049753f,-0.9350953065516625f,-0.15712003359520485f},
{-0.37035458007850774f,-0.9487286431056675f,-0.1847273210220139f},
{-0.35398609373725365f,-0.9569435957052885f,-0.1804067092479045f},
{-0.33840965897963426f,-0.9525208950397607f,-0.15338968710187714f},
{-0.32276990046682086f,-0.938690594451959f,-0.13159789254603307f},
{0.25806443929295764f,-0.6604848695706819f,-0.20829744814121737f},
{0.27275064323627035f,-0.7011869420333443f,-0.21718396359216824f},
{0.2583470588941452f,-0.6879966529096879f,-0.20848344918880782f},
{0.2522862507474763f,-0.6770752642187378f,-0.20994475501159798f},
{0.256591624406346f,-0.7101758109152585f,-0.21319120130700342f},
{0.2643128495357889f,-0.7108106357044682f,-0.20831363817385615f},
{0.2699287850354892f,-0.7196338274002251f,-0.21069779816761947f},
{0.2772463748771652f,-0.7225119379698071f,-0.22243602229162981f},
{0.28553735762940513f,-0.7117704924771066f,-0.22422519566429738f},
{0.27899879000196426f,-0.6881694631018912f,-0.22296316567470173f},
{0.27522432914908146f,-0.6620132473234247f,-0.21043963731906726f},
{0.26766365402569786f,-0.6403998565369113f,-0.2043026385961999f},
{0.25821917367865704f,-0.5990893824297177f,-0.20407910799266987f},
{0.25104671299365694f,-0.6368326130156137f,-0.204520089039825f},
{0.24821056859503526f,-0.6504917257079401f,-0.20825969654204518f},
{0.2332975310223068f,-0.6340326393533408f,-0.23519509602073407f},
{0.23671609906965382f,-0.6835608219460183f,-0.24753446660633102f},
{0.24517385222568905f,-0.732268076710746f,-0.26154456802973547f},
{0.25649383082970945f,-0.7325456095033323f,-0.22846572526239495f},
{0.2653912699577776f,-0.7381523657995417f,-0.22137942585090392f},
{0.27019849638176757f,-0.7313703081130168f,-0.21579029914991774f},
{0.277215593735644f,-0.7399501722980851f,-0.23197298736347347f},
{0.2878228730578749f,-0.7352667981895312f,-0.23143832638272765f},
{0.2901293827271068f,-0.729102705942656f,-0.2234888493094407f},
{0.28582105132489f,-0.7045967749636656f,-0.20543893155890208f},
{0.2843358753233921f,-0.6849698870519038f,-0.22167460948686968f},
{0.28482820466489045f,-0.6732916039766157f,-0.21765394306053704f},
{0.2957993214782713f,-0.6724603006739791f,-0.20275081456546598f},
{0.2824424234368068f,-0.6567365481995919f,-0.20110032578369008f},
{0.27780326461655f,-0.6352210721042058f,-0.19437991112320152f},
{0.2675353842185819f,-0.5940059193506714f,-0.19849255444340305f},
{0.2569474970261333f,-0.4946687789040894f,-0.20077837478291471f},
{0.25149697523545295f,-0.5450514465378495f,-0.20422474391787188f},
{0.2428075651185379f,-0.5729978492260359f,-0.20434721829037636f},
{0.24540319844957897f,-0.6239237482843568f,-0.20567018267999798f},
{0.22873598321749233f,-0.5524057542558972f,-0.22540898781784188f},
{0.21776833197839246f,-0.540478145315417f,-0.25367476941749195f},
{0.2113246798648268f,-0.593597886756973f,-0.2754020428845386f},
{0.22133922274570678f,-0.6737691817856519f,-0.281702004341605f},
{0.2233377616385542f,-0.7164131763664817f,-0.3046462223979525f},
{0.2249946939237066f,-0.7276689993499919f,-0.3213525268006461f},
{0.24378294366930145f,-0.7483653314001435f,-0.29769346127391444f},
{0.2512617124624611f,-0.7478987771345589f,-0.26576353606129954f},
{0.26545880828475965f,-0.752799703677888f,-0.2484915876788548f},
{0.27042705217424584f,-0.744589776267215f,-0.22792413313308724f},
{0.28008452510173487f,-0.7496560559623187f,-0.2415902768403099f},
{0.2892121200084453f,-0.7471887328098904f,-0.23677922043615962f},
{0.288518145664333f,-0.7529225838901763f,-0.23486595145666736f},
{0.2824336288249437f,-0.7042715814942496f,-0.18038770277215754f},
{0.285070479329438f,-0.6914915953297847f,-0.1903471268733714f},
{0.2909489326121254f,-0.6818341818971331f,-0.2125961541286624f},
{0.2975508038090119f,-0.6780965610975203f,-0.20736802722756165f},
{0.30844548569239755f,-0.6820844809278805f,-0.18082649525922107f},
{0.2954665487915285f,-0.6671550705883696f,-0.17879818769949665f},
{0.2886941770770207f,-0.6512701805964038f,-0.18151295200565967f},
{0.28142286996924293f,-0.6086975139512193f,-0.18027159009762808f},
{0.26440196961505263f,-0.49861098332632275f,-0.1919329330803625f},
{0.25933901313158314f,-0.4418059818541416f,-0.1979156840003082f},
{0.24588786889316464f,-0.431786089749931f,-0.2065549420940758f},
{0.2409924541215615f,-0.48639254768431145f,-0.20582037845952675f},
{0.23594277029888044f,-0.5118888116664196f,-0.2049214348387582f},
{0.2368838022675076f,-0.5509506497075025f,-0.20591646899644156f},
{0.22102951068291934f,-0.43912272750125847f,-0.2278045166375956f},
{0.20871502381308235f,-0.44519879394891543f,-0.25917092481089776f},
{0.201133497873991f,-0.5562369126264538f,-0.28363665215348716f},
{0.199015888563267f,-0.6577348258883238f,-0.3017880914696728f},
{0.21247890733379424f,-0.6923123606093395f,-0.3027800053356139f},
{0.19405469693683328f,-0.6960405801622287f,-0.32339098566700897f},
{0.2106817085325189f,-0.7220098822847949f,-0.3385898236899124f},
{0.2237969406691118f,-0.736935239538505f,-0.3415062340610973f},
{0.23886211822766396f,-0.7483076203454175f,-0.32469775896158404f},
{0.2560575913086168f,-0.7639399420035508f,-0.2991149693000875f},
{0.26300913597571074f,-0.7623549867852165f,-0.27531182852522895f},
{0.2807975686036551f,-0.7603650799558371f,-0.2515817994687312f},
{-0.25266634095332563f,0.7004798257046042f,-0.11384825480173179f},
{-0.2677238797997135f,0.6890337254820627f,-0.10159551294908088f},
{-0.25556303303552996f,0.7061386187354187f,-0.09125574578895848f},
{-0.24227083881700653f,0.7041119536581707f,-0.09766841490351863f},
{-0.24842739221805155f,0.7112419817751814f,-0.05721358067469865f},
{-0.25825086742848824f,0.7080180075298036f,-0.06469077922911286f},
{-0.2644305823822307f,0.6983430866788272f,-0.056431275620326266f},
{-0.2789035504537063f,0.6835334755689515f,-0.07371546400316681f},
{-0.29012194693483445f,0.6695270415773122f,-0.10523663737199482f},
{-0.2616201737504337f,0.6771065213189585f,-0.1345830778868925f},
{-0.24403016384221127f,0.6864379296026262f,-0.1495098747031871f},
{-0.23532109811837645f,0.6830549256567677f,-0.16124163407566475f},
{-0.2304708707382179f,0.6856050061280772f,-0.1456679148324114f},
{-0.2307641292912293f,0.6941626203063501f,-0.12680724180871747f},
{-0.2275294151652858f,0.7034900976811155f,-0.12386330338872996f},
{-0.24465507955376356f,0.723638495027325f,-0.08389682828341695f},
{-0.2543992821429407f,0.7480439169153129f,-0.036980160956153946f},
{-0.24704667640220704f,0.71054895828606f,-0.03306170559813789f},
{-0.25620673424200435f,0.7063676409249261f,-0.03420000969882716f},
{-0.26737363900373473f,0.690557564628635f,-0.037474455752103494f},
{-0.2807238906219307f,0.6788753910159413f,-0.03510521515123642f},
{-0.29440626579569673f,0.6744796011402778f,-0.06153457704043579f},
{-0.3104358397954656f,0.6656591238964792f,-0.0744215667948548f},
{-0.31152976180983133f,0.6581997281097616f,-0.10250500415460155f},
{-0.30808142615801515f,0.64807790860012f,-0.1279227445129573f},
{-0.28587718257920036f,0.6505608353360752f,-0.1444698364810263f},
{-0.26580617208038493f,0.6337915503359108f,-0.1823626147776861f},
{-0.24117574071719355f,0.6389383987898041f,-0.19732643331898647f},
{-0.21789113144768718f,0.6561868817709172f,-0.20438095823765254f},
{-0.22272332339283848f,0.6718330646637664f,-0.1778042478218591f},
{-0.21807907882638816f,0.6665833974442884f,-0.17415872503060573f},
{-0.2067830925779739f,0.660098205185295f,-0.1825393962502887f},
{-0.215587175806834f,0.6759012292185336f,-0.15271024118458632f},
{-0.20309262568666475f,0.6798934857975801f,-0.1600830093007658f},
{-0.19010057761099447f,0.6961409362665064f,-0.16735796365456027f},
{-0.18958076059219034f,0.7024528328129268f,-0.15961619155804388f},
{-0.22326989927718974f,0.7101837237286382f,-0.12195737033517576f},
{-0.226395593363153f,0.726942389962727f,-0.11814729544763743f},
{-0.24562571657846471f,0.7484910992368635f,-0.07924045526939108f},
{-0.2548623920824007f,0.7605610410766599f,-0.043888892713261914f},
{-0.26007781258607643f,0.7855083982516784f,-0.02291203400531126f},
{-0.25473543859856307f,0.7650201355841768f,0.00024181304835345355f},
{-0.2515770999077772f,0.7494290300370889f,0.005641685609030521f},
{-0.24814367833681825f,0.7300138173200891f,-0.010751770503016204f},
{-0.24234559195543615f,0.7046742744262878f,-0.0038450594455656326f},
{-0.24993007670028228f,0.7026904870659023f,-0.01096129857159127f},
{-0.25733599618981035f,0.6888250887736415f,-0.00806118022419503f},
{-0.26803675252574f,0.6707962056353617f,-0.00010782854961968513f},
{-0.28792303792874663f,0.6696146222276572f,-0.019941894483877672f},
{-0.30630659954043343f,0.6674148218614155f,-0.03505566020127895f},
{-0.31403428835900116f,0.6574476974283843f,-0.05274549925950468f},
{-0.3189093590834228f,0.6463233452867262f,-0.08476563989383701f},
{-0.3173397843429751f,0.6337926042444597f,-0.11084603800124697f},
{-0.3045944486092808f,0.6237865319410606f,-0.15526593435636368f},
{-0.29388431014996813f,0.6302371141407803f,-0.16803412779412147f},
{-0.27826625344151934f,0.6041624806581551f,-0.2042140242230543f},
{-0.25390334592692254f,0.5953222266929464f,-0.22602746002601767f},
{-0.2126710905324394f,0.6085589600364884f,-0.2414204254538614f},
{-0.20834371122057108f,0.6245369010166206f,-0.23569368825628098f},
{-0.19363145703772153f,0.6236591534940983f,-0.24926714431880884f},
{-0.1972948017200121f,0.6334989409140721f,-0.23627890709995822f},
{-0.18949152896010618f,0.6262372794068145f,-0.23586850427443237f},
{-0.19669309749432445f,0.6354518865756911f,-0.21496357588735626f},
{-0.18603171399188728f,0.6330913949031514f,-0.21948358354674288f},
{-0.16510096059573034f,0.628779416254918f,-0.23130148400698108f},
{-0.16987981754393106f,0.6354408630322395f,-0.2129232928667811f},
{-0.1647405376832866f,0.6588940477364128f,-0.2010796364539698f},
{-0.18499368950211342f,0.6806028820534837f,-0.1739029556620371f},
{-0.16851409655193747f,0.6923833347631838f,-0.18495646432601182f},
{-0.14950896368848868f,0.6959440933472002f,-0.19401378414321802f},
{-0.15792922978489682f,0.7013352021058405f,-0.18372817322128454f},
{-0.19075096561223412f,0.71453035387005f,-0.15923944687439273f},
{-0.2026244501867598f,0.7228220250625519f,-0.1451866292201131f},
{-0.20917029212048577f,0.7324963785877573f,-0.13045979561486704f},
{-0.23088794123516848f,0.7421648155638605f,-0.10402724225260207f},
{-0.24984970979897697f,0.7931302701898176f,-0.08623798838341946f},
{-0.2562082131136779f,0.7844840214526505f,-0.06171764053042753f},
{-0.26057032466171837f,0.8230391026541556f,-0.05564425984971788f},
{-0.2629134512785799f,0.8339248677487796f,-0.017353925362788333f},
{-0.2588381537177666f,0.8113907688550723f,0.016509330276022534f},
{-0.25083937454758126f,0.7946153038286687f,0.03703825978973114f},
{-0.25235245362783926f,0.7667723881605807f,0.014276768440099098f},
{-0.26361228932565317f,0.7530462439097982f,0.011331843043254757f},
{-0.25555719722942166f,0.7348486440366128f,0.004376466271184894f},
{-0.24445165076843403f,0.7193351080710627f,0.0012158094065543993f},
{-0.24610955621914168f,0.6995970115592292f,0.003471260818775628f},
{-0.2539537826753635f,0.6720827963687425f,0.013322659293720767f},
{-0.2665744140425571f,0.6208602337403745f,0.04810403713911256f},
{-0.28663997332689195f,0.6583526797751532f,0.003726861264502239f},
{-0.3007559744985345f,0.6589152842061559f,-0.0076297640345664285f},
{-0.30330548764407256f,0.6471038676207909f,-0.0016236890135280584f},
{-0.3083196679225104f,0.6414870609466851f,-0.016023778033953467f},
{-0.3168771004290476f,0.647105935066392f,-0.05236088213397066f},
{-0.34224487043599156f,0.6322717239036423f,-0.06129919315295335f},
{-0.33594596394988196f,0.6258580210662814f,-0.09909954728205567f},
{-0.3158325814403223f,0.6074315615519839f,-0.1436376418182358f},
{-0.3036895470055056f,0.6061902814493535f,-0.15497950496076426f},
{-0.2970256078194583f,0.6010227638514886f,-0.1742047644731151f},
{-0.2916166665457027f,0.614103383803992f,-0.1833278409594035f},
{-0.27460389254886225f,0.5826767509190819f,-0.21208988280945432f},
{-0.2618862782221922f,0.5821610369192456f,-0.22826535621156244f},
{-0.2312496910949687f,0.561896405784016f,-0.2564004956474536f},
{-0.21601348606452073f,0.5806571370424787f,-0.2540374913804398f},
{-0.1791011933129743f,0.5628169502804072f,-0.28148753182707537f},
{-0.17394296647142035f,0.599635421798124f,-0.2743288909428868f},
{0.11546052505610238f,0.6285336972642456f,-0.005186884761064009f},
{0.12083114740491441f,0.6533782760451763f,-0.02145509999066522f},
{0.1127441097682003f,0.649602437249362f,-0.008250049772876371f},
{0.1032646538935986f,0.6134533208995426f,0.014889070183705957f},
{0.09267961395408474f,0.6047888348698841f,0.02625607308227691f},
{0.09346217186151623f,0.6145663311950568f,0.02706573195057082f},
{0.10553164836669127f,0.649127534583195f,0.0037543999373829493f},
{0.11287702017263679f,0.6685363027344104f,-0.019150602521828188f},
{0.12947292659241869f,0.6662574337292091f,-0.019789515456296366f},
{0.13552496031297273f,0.6538798865813155f,-0.02107190117955948f},
{0.13665047408601988f,0.6424761785552666f,-0.016257704297918594f},
{0.1362044466017604f,0.6226494485469467f,-0.002451790219021008f},
{0.1364483021291313f,0.5953922181195651f,0.014020876894632148f},
{0.10406379811178255f,0.5983634211112179f,0.019546000961832843f},
{0.08542858077457295f,0.5808018210502817f,0.043457407467125536f},
{0.06768965210101113f,0.5739652533437667f,0.05418417792072649f},
{0.058844371884446266f,0.5814685414468068f,0.06374272899448323f},
{0.0747879673448498f,0.6042212052499335f,0.04832159594833442f},
{0.09324458967932255f,0.6255382586255979f,0.025870802575938833f},
{0.10805155539374761f,0.6517187504225561f,0.018627555783277232f},
{0.11906227770793162f,0.6812402598086643f,0.0077013108262210086f},
{0.11150836056063666f,0.6751754601958476f,-0.013118549504984126f},
{0.11668883740898589f,0.6847208947827643f,-0.011417812020949871f},
{0.1256381103517672f,0.6851254012449366f,-0.015072984662354688f},
{0.14632215246835598f,0.6748387566002025f,-0.0160313211294148f},
{0.14602763814931133f,0.6595313043771027f,-0.023663294441025138f},
{0.16302746351974573f,0.6535269717048752f,-0.025945537653435626f},
{0.18607298003609984f,0.6320681527556661f,-0.01641473773412188f},
{0.20833248369481963f,0.6058943488158808f,-0.005939497641921861f},
{0.1772993337286302f,0.5771799463945033f,0.015334828878789201f},
{0.17682315404827373f,0.5502626216599107f,0.03490826705355677f},
{0.1356834035643418f,0.5402255058002609f,0.056059693176230954f},
{0.11871075139850099f,0.5654335767898025f,0.04222247525116886f},
{0.08074914713659169f,0.5643797372973473f,0.051971716840595775f},
{0.0541422940863717f,0.550815823781782f,0.06899049875360998f},
{0.037936668488166674f,0.5551581989799089f,0.07348916051524886f},
{0.022284144083090856f,0.5607373156744956f,0.08268175884390319f},
{0.03361829626972382f,0.5754097805599907f,0.07907743835239364f},
{0.05227426880593789f,0.5864111706839588f,0.06750925684823784f},
{0.04437812672960165f,0.5854308880587374f,0.08217202301282196f},
{0.07361226011475039f,0.6115704070360393f,0.07325260797917381f},
{0.09477292706056858f,0.628814756188358f,0.04702720501680187f},
{0.1131692651885961f,0.6607050249045947f,0.033147518401884686f},
{0.11520573841475933f,0.6713527309688673f,0.036411032278781154f},
{0.12236727648504978f,0.696255832484092f,0.014774636113518563f},
{-0.24940019761709586f,0.001126288799545581f,0.2759323076217605f},
{-0.24153868578578166f,-0.013719148826547848f,0.28022090161165614f},
{-0.22010248231165494f,0.017916322624267712f,0.3020805999627693f},
{-0.22581817578003527f,-0.05594424981862269f,0.30934973869620386f},
{-0.23843990248968253f,-0.042290973994812436f,0.2899613560260745f},
{-0.25080152201966693f,-0.0318570520048077f,0.2870726670619139f},
{-0.2593262483017285f,0.006844900702184034f,0.27518939452422125f},
{0.22408940772830363f,-0.8073936793828916f,0.12873921022809917f},
{0.22933455652735954f,-0.7876046807879955f,0.12455320658610888f},
{0.21502341547613257f,-0.8028814942322208f,0.139629377940694f},
{0.19596932367350858f,-0.8090222421922547f,0.14754768821842415f},
{0.20436373288860157f,-0.8072649644269025f,0.14965253269929357f},
{0.2361178699799175f,-0.7790723147313618f,0.144549372579423f},
{0.23261506574201585f,-0.7860112964260852f,0.13751122042753927f},
{0.24157155349624476f,-0.7726096157705524f,0.12645979408287497f},
{0.24311668966980549f,-0.7619399837338671f,0.11468605791535894f},
{0.23934176348230132f,-0.7857243602619598f,0.11314908315860571f},
{0.25027364876242864f,-0.802957037802062f,0.10065063612658405f},
{0.24584888065129987f,-0.821253322612038f,0.1075753571212544f},
{0.043122981142624216f,-0.42698469913204934f,-0.3179663611291406f},
{0.07016297254553516f,-0.43214192306062926f,-0.301383909041883f},
{0.036429729062651114f,-0.4846211653928545f,-0.30720319152151143f},
{0.017929453453613447f,-0.45599924875868764f,-0.32211639164263506f},
{-0.005504264752230575f,-0.5089064640168246f,-0.31581795049114686f},
{-0.02258365915570383f,-0.5275613369609539f,-0.3185814888775259f},
{0.03168937271112974f,-0.5096627092699898f,-0.3080856401985993f},
{0.05310184411956427f,-0.49958478207667073f,-0.3007580807220207f},
{0.09206905455928864f,-0.4121674694957579f,-0.29369763925425263f},
{0.09522948088142406f,-0.36577174852680255f,-0.2954225762634162f},
{0.07660011953607127f,-0.3516945539252891f,-0.31254663960332213f},
{0.049567225017340795f,-0.30598131948478097f,-0.33602255983466056f},
{0.01855272774509694f,-0.3777711730481137f,-0.3375838871032679f},
{-0.005273447093521752f,-0.4674659766912964f,-0.32662286210168817f},
{-0.033850373944096984f,-0.500490331749211f,-0.3237919256261582f},
{-0.07220384945207686f,-0.5004262972431911f,-0.32483652535787716f},
{-0.07870767421926769f,-0.5224047621635468f,-0.3251146669101394f},
{-0.028541702719586372f,-0.5374486225093622f,-0.3166392427249762f},
{0.012913476643566464f,-0.5342863316615176f,-0.3090870785505701f},
{0.026251292778329292f,-0.5366006224055607f,-0.30445412100470876f},
{0.05796180209286794f,-0.5114415486018754f,-0.29820929745064906f},
{0.06987773942113151f,-0.4930137918876398f,-0.2938773997183586f},
{0.09092807956536142f,-0.44198316916652813f,-0.28927471548308453f},
{0.11479780674980294f,-0.31813474851762497f,-0.28548069995202413f},
{0.09979954069762392f,-0.2851715095314722f,-0.30527902011305796f},
{0.08840027991067378f,-0.22170319675626032f,-0.3223354835063288f},
{0.05208107419505618f,-0.22549131486155932f,-0.3434185298750344f},
{0.02439874890452417f,-0.27568706883941907f,-0.35012074867693616f},
{0.0032498608741115434f,-0.3623267371490284f,-0.34408638492310223f},
{-0.03753086163883315f,-0.46483216679795847f,-0.33230244645337276f},
{-0.08052905235992386f,-0.4761651545856301f,-0.33087417195184854f},
{-0.11121805231411758f,-0.4770963178480966f,-0.3248189775680554f},
{-0.12177267658039728f,-0.4955083498643148f,-0.3243099907344812f},
{-0.09631560800967708f,-0.5195971689124501f,-0.32858144171193115f},
{-0.07519831067553813f,-0.5349448247719509f,-0.31960051645322324f},
{-0.053973338309708116f,-0.540546393330817f,-0.31736784837651866f},
{-0.04641301803053351f,-0.5460896017037843f,-0.31726762401080943f},
{-0.01713577001158035f,-0.5483792520234563f,-0.3120577545879485f},
{0.008124476887989807f,-0.5433737643657317f,-0.30759813418856496f},
{0.01420951218239107f,-0.543423207762869f,-0.3249304283971082f},
{0.03859216773338725f,-0.5325110588326551f,-0.3256499557739017f},
{0.04869641289301175f,-0.5231011885448881f,-0.3120168221397888f},
{0.07262377038918555f,-0.49891137488538023f,-0.30635912232661233f},
{0.0980802567604251f,-0.4595968059620695f,-0.2986213416962436f},
{0.09165359573498814f,-0.4553407556482544f,-0.2895292088998716f},
{0.11509117685563452f,-0.3850700390145205f,-0.28018286634959827f},
{0.10913024991695174f,-0.4706618247522736f,-0.3002473919111326f},
{0.0922395742002506f,-0.5192288533723751f,-0.3087400409141429f},
{0.09764368258087187f,-0.5406285833239267f,-0.30854417009798407f},
{0.11522857593307431f,-0.5610892063898058f,-0.2965218071296158f},
{0.15023631144918245f,-0.5174372077767302f,-0.273845275470258f},
{0.15968032646160196f,-0.4531360512075551f,-0.2664698725827061f},
{0.16353831487902903f,-0.3963684974859121f,-0.26299063467487815f},
{0.1657585612836021f,-0.34114164226040145f,-0.25959289938230595f},
{0.16724395932833264f,-0.42292609943480874f,-0.27202444871925596f},
{0.17654614820996198f,-0.3851326137722074f,-0.27521877647465487f},
{0.18452229171931644f,-0.274852685616537f,-0.2638722737972138f},
{0.19002837743853584f,-0.19420502923576582f,-0.2526208268714791f},
{0.19550339835334837f,-0.1797613836198864f,-0.23988292905487274f},
{0.2173749701741623f,-0.19447810522758305f,-0.21274089869371057f},
{0.20953392562933582f,-0.1533005617105742f,-0.2103964759393191f},
{0.21198781357258054f,-0.12471179644975601f,-0.20226152477271622f},
{0.21379822341499127f,-0.11569755726930425f,-0.2068467610845027f},
{0.2115108636465608f,-0.08523989980327816f,-0.21309821087608244f},
{0.18819662913523205f,-0.009285100583186011f,-0.23678021378746336f},
{0.16167191508254689f,0.0037220028735804335f,-0.26998657736441284f},
{0.12311722059748521f,0.04981376578045516f,-0.3125615940556762f},
{0.11303856352999961f,0.05230054161991123f,-0.31504496594050435f},
{0.10741955767172419f,0.04793206731148803f,-0.30421598016895557f},
{0.2988406571967817f,-0.9496077685711211f,0.11529926164319772f},
{0.30860869065557767f,-0.9523283081261473f,0.1034286136975286f},
{0.299528958283181f,-0.9443728943180099f,0.09903764184129002f},
{0.29094433238630185f,-0.9417029328116638f,0.12711903725322313f},
{0.2896479951236587f,-0.9296597392133361f,0.10743096633800743f},
{0.3027788903386158f,-0.9454288819990597f,0.061229347276204875f},
{0.3043186369173491f,-0.9551736720997568f,0.0860991848028529f},
{0.3069332374150482f,-0.9588156485737356f,0.09441550491898827f},
{0.3240623259439022f,-0.9609483748852087f,0.09901489569004679f},
{0.326965969360417f,-0.952263464065375f,0.11038295993402136f},
{0.312386191057209f,-0.9510372595295895f,0.11333646746116664f},
{0.32417442484172015f,-0.9517362803108063f,0.12558835301312155f},
{0.3026444808767574f,-0.9562408458726533f,0.1332277026221668f},
{0.29130608224610216f,-0.9544059167203621f,0.12983876619108906f},
{0.29187845445452326f,-0.9486106265963398f,0.13843638533550232f},
{0.28243826942226413f,-0.9434329768151768f,0.14827824020107716f},
{0.2741334466834643f,-0.9198509146066195f,0.1271305367553743f},
{0.286659588562315f,-0.9228262917985636f,0.08012812568087226f},
{0.3032515842589429f,-0.9497416712644534f,0.038508936049418345f},
{0.3097420460606812f,-0.9635282027752389f,0.05319532378928235f},
{0.3069713332343513f,-0.9540038824811671f,0.06633953522374825f},
{0.32043753391627383f,-0.9538090262644684f,0.07708159160094041f},
{0.31795095993430195f,-0.956913767543574f,0.08841872596630011f},
{0.33018398562278783f,-0.956808719846401f,0.08969120792394485f},
{0.33301625966975246f,-0.9718115659386551f,0.10108957628833339f},
{0.34243520823226836f,-0.9810546243887224f,0.10987886123878772f},
{0.3302779694050126f,-0.9610333207641814f,0.10700748314750695f},
{0.3358675008833748f,-0.9653363836860611f,0.11564275402475815f},
{-0.044818508578751054f,-0.8352079620980533f,-0.26064821880884254f},
{-0.06097240341580066f,-0.8391939366597106f,-0.27996975159225174f},
{-0.013765030501497222f,-0.842007689751298f,-0.2645931185596935f},
{-0.005971565890506656f,-0.8400255639967298f,-0.25470834560575933f},
{0.006655732085703806f,-0.8388021153468072f,-0.25083122853568696f},
{0.013409628528370394f,-0.8480156696695423f,-0.26846717589526886f},
{-0.008945728750322186f,-0.855189711217366f,-0.28429088925822776f},
{-0.002011395089773868f,-0.8659710363120849f,-0.30337681504851416f},
{-0.0347699431501171f,-0.8581728694841211f,-0.3118103336199623f},
{-0.1028025989250954f,-0.8288259933820206f,-0.29157086986337827f},
{-0.08808007657074816f,-0.8226212119783747f,-0.2618862362570836f},
{-0.08767179112399061f,-0.8414103127126266f,-0.2554987961408221f},
{-0.04003797196380046f,-0.8527065008185251f,-0.25395854385597055f},
{-0.0010023626467668037f,-0.846881219984393f,-0.24984494755596215f},
{0.0060698141776865736f,-0.8571781593608201f,-0.24813346487932283f},
{0.01142810090939991f,-0.8497525226447193f,-0.2570736191758584f},
{0.02216882183997304f,-0.8507545283224613f,-0.25920796778405975f},
{0.058288191833479504f,-0.8497815401892735f,-0.2618160631587293f},
{0.029683893108049975f,-0.8585334028869771f,-0.2825728823352183f},
{0.041075027537650285f,-0.8684941252505366f,-0.29929106127002053f},
{0.040915769419489816f,-0.8740131797819105f,-0.31988177829722775f},
{-0.00463319658761901f,-0.8692943031915211f,-0.33681937419251395f},
{-0.03883235795380861f,-0.8595485399252689f,-0.3406990846000541f},
{-0.07875038088847246f,-0.8413522765611102f,-0.3218423435476704f},
{-0.10630826528964102f,-0.8329053440286346f,-0.32510133369210564f},
{-0.11961550107795908f,-0.8244078323850713f,-0.2899752151359749f},
{-0.09682619482941528f,-0.8214206210325155f,-0.27048577623482006f},
{-0.10522016420767423f,-0.8148578985010733f,-0.2571540668201574f},
{-0.10281392100514211f,-0.8310326430914227f,-0.2525852234609016f},
{-0.1038849608800647f,-0.8465343034624563f,-0.24511253482764708f},
{-0.09835575397964452f,-0.8662647803854663f,-0.24986652824583622f},
{-0.08939395206154284f,-0.8751565451934135f,-0.25370139548206266f},
{-0.0389363432431704f,-0.8795022436031747f,-0.24936745048991954f},
{-0.0028605935895866593f,-0.8606763431871497f,-0.24685437262027526f},
{-0.0009462218307860537f,-0.8788030602735628f,-0.24525389456140792f},
{0.013227805930702403f,-0.8737445616532701f,-0.2526555803558074f},
{0.039467022319438945f,-0.8752891517492158f,-0.2528774281053641f},
{0.06684655500925958f,-0.8552762783306588f,-0.25795748722978246f},
{0.08600476171499814f,-0.8477402436316462f,-0.2572074825601017f},
{0.0877582307483462f,-0.8504495981572332f,-0.26726032311776887f},
{0.05899848901120716f,-0.8612458373328097f,-0.28397035657188074f},
{0.09988142684209964f,-0.864098983443638f,-0.2890026944622241f},
{0.09678102124927238f,-0.8760776570155758f,-0.31831173715975075f},
{0.11004134110863646f,-0.8784984541427171f,-0.33780407430941534f},
{0.05460602234717782f,-0.8773203968665391f,-0.3497210655462279f},
{0.0074516933300845896f,-0.8694593312465057f,-0.36458068737901206f},
{-0.03934884219930829f,-0.8560375487727722f,-0.3643765489052645f},
{-0.09236169585336158f,-0.8332256737950897f,-0.35356288305435685f},
{-0.11799681653642691f,-0.8345985883503747f,-0.34074646161399813f},
{-0.13518406339369565f,-0.8400615530613428f,-0.3289117825471936f},
{-0.13449932774791157f,-0.8295519249531016f,-0.2974406507111007f},
{-0.12894589688698246f,-0.8135911662945041f,-0.26657457499734055f},
{-0.14223446404523754f,0.8055736749355356f,0.18957189426779983f},
{-0.175633040568251f,0.7976862456656609f,0.17141782124264965f},
{-0.15909719524927413f,0.7870914485728066f,0.19687602977695154f},
{-0.1425976428435443f,0.7894796616523707f,0.2065964121205881f},
{-0.15599693201909348f,0.7716418663702826f,0.20739919402311843f},
{-0.17381711895411447f,0.767217705956422f,0.19256731272069919f},
{-0.19752386428101637f,0.7808994330614232f,0.1482118556489784f},
{-0.1884914685510669f,0.8148237845862474f,0.15135505821567455f},
{-0.16546840389899223f,0.8258695323611593f,0.17330683438939865f},
{-0.14160425966759993f,0.8158256277155942f,0.18399061026127786f},
{-0.1202747442483072f,0.8226738064770807f,0.19265507504278f},
{-0.10422380204022659f,0.8153473614662963f,0.19570960374149307f},
{-0.10874814538589171f,0.8030906472708382f,0.20174970131028547f},
{-0.12005502343918902f,0.7939487257947903f,0.21148786517346232f},
{-0.1260417467019417f,0.7820109442995152f,0.217410899212734f},
{-0.1420587874767589f,0.7680572769166475f,0.21528072586723168f},
{-0.15995731317657302f,0.7490314940325676f,0.2069194680254874f},
{-0.17040161064126444f,0.7314275835805402f,0.19712126218484616f},
{-0.18545617049614904f,0.7380423024750905f,0.18217499249577537f},
{-0.19425117545026024f,0.7575262094187712f,0.16661162747905245f},
{-0.21066602526840614f,0.7637963628998715f,0.12610191988677086f},
{-0.21378288543341728f,0.7884256999830171f,0.11305017511617492f},
{-0.21205774444195388f,0.8409464027800845f,0.1238006287647088f},
{-0.19502480806966765f,0.8818417314732818f,0.14123350218317024f},
{-0.16884563365839558f,0.8547338054652753f,0.16804706579644932f},
{-0.15335438807113758f,0.8593623253337083f,0.18205303445346727f},
{-0.13430164446402643f,0.8402873827153767f,0.18353883833798176f},
{-0.1174190143616813f,0.8365643519622386f,0.19404833470765434f},
{-0.10416805643995179f,0.8371793989676304f,0.19098598456263335f},
{-0.10710247037390955f,0.8308676851553536f,0.1956019616444443f},
{-0.08902001957136854f,0.8345122751525487f,0.19261615904464643f},
{-0.08492800396123425f,0.818938089512266f,0.19233628470524372f},
{-0.08360677235875315f,0.8091894492456603f,0.19657361220619757f},
{-0.09316307431517296f,0.7957503208395894f,0.2122916298032183f},
{-0.10164941474059884f,0.777280071000119f,0.22095222423306332f},
{-0.11891042138499347f,0.7632152375134919f,0.22057296695493808f},
{-0.13213179443639758f,0.7493341548947103f,0.21354447102765267f},
{-0.14820887718867898f,0.7313686571312777f,0.20820441733879955f},
{-0.15494781280454462f,0.6974510327727158f,0.20164926340060618f},
{-0.17861760758776418f,0.7032404870906298f,0.1835764581985854f},
{-0.19999939347138038f,0.7301290779435539f,0.15651189649021888f},
{-0.22225445945267172f,0.7440696957712735f,0.09704323040279005f},
{-0.2303206962068454f,0.7886480343153516f,0.08179456651593715f},
{-0.23284487942534277f,0.819536743565127f,0.08912249783524978f},
{-0.2368266181670559f,0.8542696628654227f,0.08479676313067357f},
{-0.2142851440383215f,0.8830754536067412f,0.1168835528566497f},
{-0.20740456396340146f,0.9057639416036092f,0.11646119369361373f},
{-0.18635393909387807f,0.9107002697000316f,0.1374421819807275f},
{-0.1799219394691885f,0.8863031154696326f,0.15400248605233974f},
{-0.15557025735552754f,0.8767824838554821f,0.17293728326903884f},
{-0.1408608504256127f,0.8708719724170841f,0.18438374895986756f},
{-0.1224581399755322f,0.8613164874522714f,0.1847739692241992f},
{-0.10662616426702361f,0.8530958201610322f,0.18679360328655092f},
{-0.10957160705647213f,0.8446631525782412f,0.19425147983009816f},
{-0.0899271447946931f,0.8452981388534383f,0.19174144044679464f},
{-0.07655707502118235f,0.8347182367181006f,0.18471144439967946f},
{-0.4355009808656215f,-0.23979643843494225f,-0.09841698001061483f},
{-0.44167593410755307f,-0.26812347634418526f,-0.08372962123001115f},
{-0.4377986544890855f,-0.23809524942758814f,-0.08779776559902992f},
{-0.4322028409933341f,-0.19599959326566868f,-0.0975873595619515f},
{-0.4388359597287711f,-0.21687594925706355f,-0.07556642170210949f},
{-0.43818488328726957f,-0.25439125193349793f,-0.05736730258575364f},
{-0.43461614070855f,-0.25214877677028585f,-0.07696620667576178f},
{-0.44055964097190153f,-0.25622099441085366f,-0.07904634805019925f},
{-0.443246826233687f,-0.2747450445818961f,-0.05647242161245609f},
{-0.4477291428511466f,-0.2881862797426572f,-0.0612208522633445f},
{-0.44258423966595617f,-0.2909240037440335f,-0.07666599785084781f},
{-0.4331819889670128f,-0.26375005758980746f,-0.10122726859032916f},
{-0.42436892945455373f,-0.2248743225874649f,-0.11279073725343333f},
{-0.42327379098324386f,-0.1916915858978344f,-0.11344465988546175f},
{-0.42261448725565043f,-0.11734897672032299f,-0.11930806841113112f},
{-0.4480700610185799f,-0.15608999841217314f,-0.0797925131780494f},
{-0.4457597426173439f,-0.18180673220090657f,-0.06985702937445888f},
{-0.4451179877419801f,-0.20823659023455388f,-0.03482686111741189f},
{-0.44031428638710857f,-0.24810038999933667f,-0.039232164855027014f},
{-0.43995051051561185f,-0.2671478948735296f,-0.025520134692019854f},
{-0.4335104249050693f,-0.2807249790587336f,-0.037236594329604744f},
{-0.43172907297870966f,-0.26851108308530064f,-0.058991356536364926f},
{0.3201202022646626f,-0.6511122844850576f,-0.017386419105701666f},
{0.3194047269112619f,-0.6440512342576136f,0.023389824295909842f},
{0.3035746104164234f,-0.6533487623561741f,-0.008161830615436613f},
{0.2923449471004548f,-0.6547829544692082f,-0.0005486682965358907f},
{0.29143437223896645f,-0.6451159772414379f,0.041016599888855455f},
{0.30790052997995887f,-0.6464778671908633f,0.030131934386316127f},
{0.31883498947421324f,-0.6403063179035596f,0.05390424727370976f},
{0.322332281940389f,-0.6377602097750572f,0.014745853361090633f},
{-0.27475852600581946f,-0.9596991511593724f,0.27717091258152143f},
{-0.28625129355388695f,-0.9688228959001741f,0.27904560022134073f},
{-0.27748974382175845f,-0.9691180997218883f,0.28477947148737515f},
{-0.27066954994443365f,-0.953232884633132f,0.29047390830026387f},
{-0.2780873652142266f,-0.9718328024083982f,0.3011317061763374f},
{-0.2831500773438996f,-0.9800806641523868f,0.2931998788840221f},
{-0.2934197818960799f,-0.9807689854245345f,0.29361471938697636f},
{-0.3002375247985837f,-0.9767058460587156f,0.2713447403872357f},
{-0.294747832031895f,-0.9589832710285954f,0.26503872001842066f},
{-0.2862099956374401f,-0.9543550146372998f,0.2688387742754813f},
{-0.28098965087355826f,-0.9523156633483751f,0.2653587066271526f},
{-0.26851445251167466f,-0.9568537861233549f,0.266110494017141f},
{-0.2696769667615713f,-0.9517507078088858f,0.27929144032650355f},
{-0.2640129456219167f,-0.9473378960352672f,0.2845171757476207f},
{-0.25746564393985777f,-0.9462971464694571f,0.2939707556175667f},
{-0.25648858359752863f,-0.9497698792542555f,0.3008363196204797f},
{-0.26540047040942477f,-0.9603287882112387f,0.3013413149879062f},
{-0.2602911302633149f,-0.9641980434635062f,0.30897514220114747f},
{-0.2757823142309198f,-0.9772521595283374f,0.31836586258811306f},
{-0.28334325283144074f,-0.9783650476469532f,0.30896233487498037f},
{-0.27930667897294714f,-0.9896785827475972f,0.29550894151922497f},
{-0.27717885673593157f,-0.9991756682174221f,0.28450848312690735f},
{-0.2943025142360535f,-0.9864759257149565f,0.2917421809981597f},
{-0.3026790112554453f,-0.9857765808993569f,0.28266911523477983f},
{-0.3025636284550822f,-0.98767262612341f,0.26466152912348867f},
{-0.3003420657272308f,-0.9724783267066772f,0.25342078276923097f},
{-0.29648940634738596f,-0.9578617901556007f,0.25792844949947974f},
{-0.2887230341979954f,-0.9546456787904356f,0.2520840793217916f},
{-0.27085463944612187f,-0.9535094453225709f,0.2505654077268141f},
{-0.26276378245332555f,-0.9578963194718807f,0.2568873546511308f},
{-0.26038213505403635f,-0.9542014956461368f,0.26756837463714706f},
{-0.24564752037397916f,-0.9484493265303657f,0.2769693886933978f},
{-0.24597095130883592f,-0.9514548559184068f,0.29313349433192337f},
{-0.24964723399345434f,-0.9635017785681524f,0.3093699626913027f},
{-0.30242782086454406f,0.029406476649119044f,0.1775066535825691f},
{-0.2997708281703523f,0.07250746170041482f,0.16165254366971665f},
{-0.30133000725036485f,0.0627719931658556f,0.15379719274130113f},
{-0.30270442192547964f,0.043527036612680446f,0.16024545464236062f},
{-0.3092168086372229f,0.06401789368005778f,0.15267970439686165f},
{-0.3060892903970473f,0.08641014519481878f,0.1469734121752049f},
{-0.2982242938681116f,0.09673585882441124f,0.14288901615389432f},
{-0.2967042634535432f,0.017741324934380544f,0.1941687023254687f},
{-0.2978370515328755f,-0.0372725175249335f,0.21614453141204418f},
{-0.3013735957180533f,-0.03748212633650223f,0.20472238317361185f},
{-0.3030635168281591f,-0.010925091713376925f,0.18326607681887674f},
{-0.3064642927318877f,0.017326159334635934f,0.17324966091302524f},
{-0.3070457421526499f,0.036649415343515325f,0.16151140704159614f},
{-0.32397977154491314f,0.06960446635266518f,0.1578962595520801f},
{-0.34029924051456234f,0.10550433864269385f,0.14818044662444058f},
{-0.33039098091114033f,0.11460182066239649f,0.1473767839858345f},
{-0.3220082241849235f,0.1386275794324751f,0.1415456864689349f},
{-0.305325709217944f,0.12788386357428144f,0.13669032340941578f},
{-0.3010426663088633f,0.15334081634255017f,0.1314181735158318f},
{-0.28694632180654833f,0.18707975326889587f,0.12523760226139324f},
{-0.2814895179984789f,0.2510556345632536f,0.11874463742685117f},
{-0.2794889318457787f,0.28749014658587185f,0.11500040526342774f},
{-0.2763899254440391f,0.2852845518474265f,0.11817508803598505f},
{-0.27874204853024803f,0.3275838992094049f,0.1152068534117574f},
{-0.27565080195516334f,0.348647412148089f,0.1300839422913697f},
{-0.2605423610257131f,0.3205943405284093f,0.13701349086713527f},
{-0.2569099292235124f,0.26480139511186657f,0.1420808340324583f},
{-0.2469980436222299f,0.34491903110921246f,0.1490134317186428f},
{-0.24341975637173224f,0.3917668777832651f,0.143875286509541f},
{-0.2290757677957907f,0.3528181118055553f,0.16228967919591628f},
{-0.22593469323194093f,0.32672519959653423f,0.17646421160111517f},
{-0.23306887536349427f,0.29879354950321785f,0.20017549659659542f},
{-0.2249875216085714f,0.2799465751658448f,0.2075974956283499f},
{-0.2296434388496462f,0.29263496902806857f,0.21172985617512421f},
{-0.22559162687591292f,0.2937408059460398f,0.21375663280519233f},
{-0.21238711317406886f,0.30684817520242014f,0.2058407235691161f},
{-0.19736055732668645f,0.31471507662856174f,0.2004957764298834f},
{-0.19375232079998392f,0.2920385640925445f,0.20236505216431117f},
{-0.18936415051314412f,0.2679147280829437f,0.20348233865126644f},
{-0.17608989823774052f,0.23509560684123043f,0.20167154315482017f},
{-0.18647852128348044f,0.2328631820559146f,0.18972305258880579f},
{-0.18394609059314276f,0.21626297819653534f,0.18744720294660464f},
{-0.17246768998590947f,0.19849971294723662f,0.19704055106340995f},
{-0.14816678884082035f,0.1950478925977989f,0.2191183086178242f},
{-0.13379339706628907f,0.1836361198340532f,0.23633355842018725f},
{-0.15809687136309744f,0.1523979804054592f,0.2596451804707076f},
{-0.15486828839263386f,0.1257962853451638f,0.286550995079071f},
{-0.17885557525104404f,0.08783250314724102f,0.30069765521533637f},
{-0.1979713493887932f,0.04985445493722605f,0.3089736420813177f},
{-0.21900270324302462f,0.06097880707888422f,0.2809512506744172f},
{-0.19912440183472113f,-0.0029528185556795842f,0.33115121922406493f},
{-0.21726516182758596f,-0.03437722250900122f,0.3205771922039246f},
{-0.20553494294643493f,-0.07867823118038494f,0.33596991540278737f},
{-0.21683453500696126f,-0.09857786998717374f,0.31751934135598514f},
{-0.23413422498217876f,-0.09983463255884018f,0.2944723661537059f},
{-0.23746326711047794f,-0.06989289201254235f,0.29184092649219534f},
{-0.24697088954097696f,-0.07166265306967899f,0.2934869765341349f},
{-0.2561477663588374f,-0.048449635212955366f,0.2740784718600566f},
{-0.25290701350689354f,-0.03304783480175158f,0.273879298018012f},
{-0.2591606518585649f,-0.0169415825805988f,0.27556652486190797f},
{-0.27245916952838206f,-0.006831962699856194f,0.2722060333375741f},
{-0.27027081873112446f,-0.003210817918244449f,0.2759961381454806f},
{0.012112789809240182f,0.7680427676131665f,0.19310003905682027f},
{0.0316519504583791f,0.7768772261437639f,0.17028219653446086f},
{0.03451426089898908f,0.7827335515965543f,0.16894358818981559f},
{0.016262648212669234f,0.7794246325346118f,0.19248493043177556f},
{0.03117551792496343f,0.7923071336160273f,0.16951622387537396f},
{0.03947586792687713f,0.7850185815046542f,0.15758794561797254f},
{0.026347060343269446f,0.7810962759807294f,0.15283854180152884f},
{0.018175380676216796f,0.7703789843296224f,0.17494348318461472f},
{0.0004130577826467501f,0.7614693466350629f,0.1940939183772126f},
{-0.004625942467082354f,0.7623269519678879f,0.2046546621124863f},
{-0.0022773348883215467f,0.7688375559593235f,0.20662488252511946f},
{0.0043268778553813845f,0.7849467659238234f,0.1951989446780237f},
{0.012469159635883336f,0.7987089608588719f,0.18099227337412047f},
{0.018499662599730436f,0.8103304040538393f,0.1721297906502725f},
{0.030926019949705858f,0.8079878447627489f,0.1694085817783252f},
{0.042279686443019625f,0.7966119590724664f,0.16638481509779285f},
{0.05668841283895214f,0.7818954403846619f,0.1559432331474675f},
{0.045341504321727115f,0.7821386871523568f,0.14969514693901884f},
{0.031897908490808896f,0.7872325862633349f,0.1436149466625675f},
{0.025948106024319777f,0.7783898802608973f,0.14244098284368675f},
{0.019497838297312362f,0.7729876268443148f,0.1537171307510377f},
{0.014834712619236818f,0.7621934944234285f,0.16264840969271638f},
{0.010191455029643371f,0.763598304586029f,0.17786479656784948f},
{-0.006070035158511281f,0.7529152585883163f,0.19106109254527195f},
{-0.021782901140054364f,0.7566773986978096f,0.1977276165695245f},
{-0.03023222302769791f,0.7615620735888466f,0.20711116357894718f},
{-0.01375757027384518f,0.771328465627574f,0.20957914542421865f},
{-0.009150192320860055f,0.7787729877049313f,0.19930450598775404f},
{-0.004147887636938704f,0.7913847851511725f,0.19458741318008013f},
{-0.0012949497580413835f,0.8005911246624602f,0.18820849357446645f},
{0.0024858685431852086f,0.8081009784457752f,0.18976425913818087f},
{0.015463270264766743f,0.8092024180578147f,0.18725053213736378f},
{0.0198640353962113f,0.814357149577669f,0.1797752087327368f},
{0.017853924757481494f,0.8205284959450807f,0.1700678451344218f},
{0.028690971017095834f,0.8221495199086136f,0.16843405421621854f},
{0.0477684411036108f,0.8157653222609929f,0.16905189854137775f},
{0.06091636884060115f,0.8055876360365858f,0.16613107174092065f},
{0.06536978902799706f,0.7945056155341751f,0.1616508416924027f},
{0.07495076646824585f,0.7900886295602653f,0.15369315858118007f},
{0.07085805179377157f,0.779443598638862f,0.14929471374839567f},
{0.06281840179507951f,0.7686278249708565f,0.1485565124295002f},
{0.04626586392456906f,0.7777327247218986f,0.14124989619810877f},
{0.03689010861403553f,0.7745165729852367f,0.1378997992718022f},
{0.03461040774351793f,0.7698173923732641f,0.13958377408538736f},
{0.029474385225223373f,0.763891886111015f,0.14621264743920973f},
{0.018516831109963557f,0.755863076921631f,0.15136800684208052f},
{0.0033709243690423375f,0.746477442280859f,0.16537399462243907f},
{0.007202225102245785f,0.7563359535761017f,0.1768001353894268f},
{-0.0072578931467503025f,0.7462811263158271f,0.16628130682953846f},
{-0.022592009681101918f,0.7497328255507743f,0.19216589680285043f},
{-0.0447730077770021f,0.753192670266412f,0.18828292267851351f},
{-0.04808490264322438f,0.760864269264574f,0.2045408198034499f},
{-0.044059043167509256f,0.7692160026202887f,0.20600629876412346f},
{-0.02808434678083333f,0.7755107157827663f,0.20727465220501287f},
{-0.018050218411949252f,0.7820384213527429f,0.20245315976893072f},
{-0.02085675987931252f,0.7894152425547231f,0.20371800726404235f},
{-0.003262014819474456f,0.7962666032276047f,0.20415469299641578f},
{0.0001333916751750694f,0.8050071789047194f,0.19678591634638393f},
{0.00970719573788079f,0.8151090995160524f,0.1960313932562811f},
{0.006049150345753775f,0.8258344155333596f,0.19836888486211068f},
{0.0143128579022504f,0.8262365910727936f,0.17902498095741565f},
{-0.002731325119127943f,0.834492923394263f,0.18353143229312813f},
{0.007842934568323124f,0.8317565167785728f,0.16789575661353418f},
{0.021553739775123645f,0.8303536115131781f,0.1626643373106257f},
{0.05538093091836683f,0.8243188642301242f,0.16309765839746027f},
{0.07720433635623293f,0.818315443103799f,0.15629912595300324f},
{0.07990779345605868f,0.8040616285156702f,0.15623242799060014f},
{0.09024543261333468f,0.8080288388305618f,0.14574967986239654f},
{0.09282442863804848f,0.7955078645033061f,0.13860032973451913f},
{0.08990855690762396f,0.7849507786381271f,0.13280421836925851f},
{0.08251796583799953f,0.7552151207718718f,0.1449096223193935f},
{0.07642202067778245f,0.7199467511218266f,0.14835712716830113f},
{0.06397614477149498f,0.750173279643655f,0.14537188127019646f},
{0.05218734791084373f,0.7636467344461142f,0.13869371644355377f},
{0.04576323560174642f,0.7480799867229195f,0.13720460847074564f},
{0.03808215248905163f,0.7543573539530597f,0.1396566935079343f},
{0.03275508779810136f,0.7508323804513565f,0.14708374853846348f},
{0.03075618343696675f,0.7367497548211108f,0.17377617535067277f},
{0.024234627083402818f,0.7357312956335927f,0.18355749103192748f},
{0.02208755932888277f,0.7461216100325685f,0.16990541041690507f},
{0.014142318075540073f,0.7446139003613896f,0.16084767519824458f},
{0.002413291215953394f,0.732427157406802f,0.18143779408985392f},
{-0.00999584237858261f,0.7300146279372492f,0.18491727422666288f},
{-0.017343633287114864f,0.7363813585380421f,0.17898548700943265f},
{-0.02478434663246801f,0.7421964264458824f,0.16697929495036254f},
{-0.17184929852072742f,0.0756307653688024f,-0.2980779880947845f},
{-0.19386651795322934f,0.06959182263730103f,-0.2876573589513167f},
{-0.18470997562088007f,0.08227908184798226f,-0.29839726501509845f},
{-0.11441035405782003f,0.08108424596523764f,-0.31353044836006966f},
{-0.17683194972254465f,0.09955885167673495f,-0.3025256532190657f},
{-0.20539601400174665f,0.08260581580872475f,-0.28899241991627955f},
{-0.19665746433632833f,0.07461749285621977f,-0.2859674983984561f},
{-0.20527185783767662f,0.0683404092889653f,-0.2742771580569158f},
{-0.20000166277446565f,0.05956666099034564f,-0.27706736394177023f},
{-0.1838007075209999f,0.05844696390006619f,-0.27803198348862723f},
{-0.12516598481961916f,0.06700607713576107f,-0.30271511984093713f},
{-0.05886264636121109f,0.060594199515020444f,-0.3136228916509678f},
{-0.06430760113495938f,0.08833293866034078f,-0.32462375588306935f},
{-0.11695414188766223f,0.10459343868441519f,-0.31688143558412224f},
{-0.12626996783595937f,0.12518212969992593f,-0.3143811236067404f},
{-0.15548071125073123f,0.13575084680582455f,-0.3052325758931724f},
{-0.17960746463218227f,0.15109736801378273f,-0.2893422750582228f},
{-0.1972811232194396f,0.11251788967929553f,-0.28848566307670165f},
{-0.22179138988470867f,0.0840019110400479f,-0.27404558290143743f},
{-0.2233752911944938f,0.07024480397600848f,-0.2731464161750285f},
{-0.21269429245663377f,0.06983215097073801f,-0.273643731396386f},
{-0.22036522213787452f,0.056359790448324704f,-0.2566135700333033f},
{-0.2209537652555938f,0.04374653431615817f,-0.2532231292327646f},
{-0.21776766372387898f,0.030652783003105148f,-0.24653262347698401f},
{-0.17117151420925375f,0.05271165413385511f,-0.2783895378999801f},
{-0.16525706230028298f,0.04208976457940099f,-0.2670619811410406f},
{-0.10793867668859614f,0.04787476103413816f,-0.28819325551234715f},
{-0.05225515608940977f,0.041712127473188206f,-0.30027328916394463f},
{-0.015581070042900774f,0.03540521680662714f,-0.30431786720288967f},
{0.02903039968877743f,0.030559488723550094f,-0.31123232852532484f},
{0.015346794246765702f,0.0473401202391408f,-0.32089261895832993f},
{-0.022321707636080428f,0.07037668065764438f,-0.32638147985970223f},
{-0.006439064636635651f,0.08201540816529636f,-0.3311319269606168f},
{-0.04730128020316572f,0.11197854772973252f,-0.3286436116922419f},
{-0.08374093959163044f,0.14256783964841344f,-0.31805665623144397f},
{-0.12047694701502232f,0.19241165085298045f,-0.2997824185083714f},
{-0.1552360259828595f,0.18583320468592876f,-0.29171995117711275f},
{-0.16764178005814734f,0.22663683908573518f,-0.2778909265410926f},
{-0.20065209114720223f,0.1780831033121706f,-0.2623202872180847f},
{-0.220269050857966f,0.1249970805697346f,-0.25881517330560094f},
{-0.24793816298254703f,0.08200114321561199f,-0.23793689329365955f},
{-0.24053435024770903f,0.052666992634277196f,-0.2565616342274403f},
{-0.23244249990360905f,0.05447914588790653f,-0.2570546328858599f},
{-0.22309090905874712f,0.060027866032599644f,-0.2591930122692979f},
{-0.23492852674555806f,0.04491705380891419f,-0.24131319025900444f},
{-0.23666683840666003f,0.03428948993433904f,-0.23728324263803088f},
{-0.24508590823187243f,0.010488659896470374f,-0.22591568516258234f},
{-0.23561068817721492f,0.007895215125520796f,-0.22441334596289036f},
{-0.20943226276344992f,0.023279669604386974f,-0.24042510763329236f},
{-0.3699095863170488f,-0.20538603852360104f,0.25126450925102467f},
{-0.38268693877254906f,-0.19890266935641202f,0.2326952100688846f},
{-0.3809426287569436f,-0.2257344808862607f,0.2338665603645492f},
{-0.3692375974401866f,-0.23222660429381609f,0.2529281485166907f},
{-0.37267158527450905f,-0.25739969975579696f,0.2340454092827529f},
{-0.38013223788966766f,-0.2506194258519876f,0.21545254270813136f},
{-0.3880090282077183f,-0.22108296201352534f,0.22046066513722826f},
{-0.35982870031797476f,-0.19492593561789862f,0.2580951593460298f},
{-0.3607632675350692f,-0.22788917354164356f,0.26242097904323086f},
{-0.36223533236176597f,-0.25801896239538447f,0.2501514182125168f},
{-0.3650021142791934f,-0.27596152277416774f,0.2323158104281126f},
{-0.3720114709297555f,-0.29980652772883676f,0.2177544723372881f},
{-0.3786556939516378f,-0.2912073723427281f,0.2097894023045524f},
{-0.37961506520390625f,-0.26767961723426886f,0.2020600008845926f},
{-0.3877496923361266f,-0.2641772188361512f,0.19803560646924956f},
{-0.38700191659803435f,-0.24458599489221208f,0.20372984142465417f},
{-0.3973414500284382f,-0.23715452237000287f,0.21395250362135115f},
{-0.40546391896566436f,-0.23627977296232458f,0.21267919511042913f},
{-0.4187665502785275f,-0.25985129821020797f,0.19613848715089915f},
{-0.4247858777746059f,-0.21772573314358046f,0.1832879422340443f},
{-0.42564915636514394f,-0.19177596445103573f,0.17954048247568968f},
{0.2546823872644982f,0.2625825064644766f,0.2638762865115176f},
{0.25972690353558425f,0.26474481870868327f,0.2534110160542203f},
{0.23041504333254165f,0.290037957754096f,0.24419040946843254f},
{0.22223644314100513f,0.2908979545669044f,0.2556013726774259f},
{0.1862722548068866f,0.3110419758553386f,0.24852257174026807f},
{0.18223795131388612f,0.31634785400971294f,0.23693235483569489f},
{0.20893176563069712f,0.300798046379072f,0.23088658294678152f},
{0.24467098592351677f,0.27635712307165655f,0.22893345455101907f},
{0.26573891529147303f,0.26318839551453355f,0.243550923896154f},
{0.285427486600768f,0.25000807602577974f,0.24892213375648584f},
{0.2722358205965878f,0.23999474960184397f,0.2755153178678037f},
{0.25141906143378434f,0.2343913983226702f,0.29595774401268804f},
{0.2297552933936674f,0.26862250310452696f,0.26923851902584267f},
{0.202089930506253f,0.28990948502708797f,0.26400816319315346f},
{0.18701263406179564f,0.30427021183809905f,0.2589650248649988f},
{0.1582776846733447f,0.31529397308335305f,0.26002869269211776f},
{0.16682909863962994f,0.31999461238125104f,0.25464496023091227f},
{0.15897938059743077f,0.32823355733647813f,0.2507468096109888f},
{0.15852634228402335f,0.33123997914708075f,0.23999754160957243f},
{0.1576019274359752f,0.32846740179504175f,0.23241463772754978f},
{0.1661253968895958f,0.3206757199043589f,0.22603248627737366f},
{0.18397368876086095f,0.3008102863794678f,0.21881236491554396f},
{0.20567786229486304f,0.29470998428481576f,0.22258074667092959f},
{0.2360729046317055f,0.27101963191044465f,0.21932874823230147f},
{0.23827077991499274f,0.2633996255604225f,0.2116928132019622f},
{0.25281714336771477f,0.2668813548145684f,0.2163142011267569f},
{0.2654879681919607f,0.2652392558672795f,0.23070986203142416f},
{0.27763031312410774f,0.2608460593290837f,0.23285251866871107f},
{0.2866738131405025f,0.26674023730978846f,0.2481160998236446f},
{0.29355242776097135f,0.25840451231497685f,0.25558177762775136f},
{0.2988161984441464f,0.24879094976474306f,0.2557527838514909f},
{0.2979764659979337f,0.2368587204126908f,0.26021791708500813f},
{0.29843515844571356f,0.22819423544544018f,0.2636788560806916f},
{0.28265134380811385f,0.2158316023784036f,0.2878317500063435f},
{0.25656953694794593f,0.21061861266380053f,0.3103935894304158f},
{0.2449085381853423f,0.20253164620840972f,0.3186804585396098f},
{0.23219422688455807f,0.2245838709158913f,0.3099269331736812f},
{0.22900717343544424f,0.24968977227102104f,0.2876181688519677f},
{0.2190114362352348f,0.262252206000711f,0.270103722699335f},
{0.2034403719491023f,0.2712482078886713f,0.26462225828114605f},
{0.1679357461747613f,0.2971082477422762f,0.2638314019062993f},
{0.17085203436904783f,0.6574269464790109f,-0.22645364916921393f},
{0.16053000835696893f,0.640215100631276f,-0.24149041688048f},
{0.10006842124099377f,0.6664768506896932f,-0.2433327839498593f},
{0.10946599097111978f,0.6906131274947663f,-0.2208476833044162f},
{0.057706031661891435f,0.6871197669999006f,-0.2344503205223013f},
{0.06709986277892907f,0.6467441034011904f,-0.26222002248087867f},
{0.10927095095786951f,0.628111155367066f,-0.2640380519121131f},
{0.1792680040882664f,0.6192268072280506f,-0.24660759972105403f},
{0.21963738566958768f,0.6250613288853264f,-0.2286124958391396f},
{0.21253503858810457f,0.6559069171268505f,-0.20986641412198914f},
{0.17912658273485246f,0.6746202724337769f,-0.20658089990413306f},
{0.10875431478805295f,0.7045056384343755f,-0.20461946347928503f},
{0.08159788773863781f,0.703386589412861f,-0.21387309926152306f},
{0.04891088540754131f,0.7057100795461435f,-0.2112762898450346f},
{0.02794848925712794f,0.6930476636797253f,-0.22644428723157936f},
{0.024715659842641947f,0.6736072028410863f,-0.2461921100869269f},
{0.03389714644799631f,0.645302373504734f,-0.2666034916131527f},
{0.07264294047573548f,0.6120698693835835f,-0.27852084725584464f},
{0.11194014221855245f,0.5947171493224575f,-0.2757857176543439f},
{0.1964368914761454f,0.5984050026905503f,-0.24913301851983616f},
{0.24349604893908064f,0.5827484443230145f,-0.23397784864520688f},
{0.2504633990471856f,0.6132688390951228f,-0.21625851502131951f},
{0.24004056115787784f,0.6371251108846321f,-0.2075637153095769f},
{0.22109698845265602f,0.6690965571193342f,-0.18772707622359958f},
{0.17319195888876568f,0.6919000836964343f,-0.18613557551073906f},
{0.11840136337009609f,0.7187717737658937f,-0.169170542933722f},
{0.09592221008358141f,0.7156636285321599f,-0.18932710700877822f},
{0.0671324978220813f,0.7195439466369681f,-0.18172578310012055f},
{0.03323351659579466f,0.7196955607309252f,-0.18415071405605626f},
{0.005912787115930202f,0.7093891383023732f,-0.19874960188856886f},
{-0.02988214371770644f,0.6860072018532594f,-0.21985060188688016f},
{-0.015638535681422323f,0.6750885286766755f,-0.23638288070283406f},
{0.010956322784606308f,0.6428844130064493f,-0.2663276204263836f},
{0.0037538320804077264f,0.6159999974162244f,-0.27861377712952035f},
{0.044250636729819284f,0.6119358445133531f,-0.2814655049259205f},
{0.0704406073292714f,0.5730864933466002f,-0.2885245896989133f},
{0.12584827692743691f,0.5539961904361305f,-0.2802564232168321f},
{0.18864970782013624f,0.5667283544377785f,-0.25902419460564996f},
{0.22744124700342097f,0.548750657045447f,-0.25042258824472036f},
{0.2473700053459139f,0.548937206295468f,-0.2415818880682306f},
{0.27496864052350645f,0.5328783714597561f,-0.22589562371587865f},
{0.2837288930556972f,0.571279202733524f,-0.20889431841136288f},
{0.27277423081450025f,0.609818883271394f,-0.19725153781791016f},
{0.27070004636066153f,0.632037189942409f,-0.1762877637245654f},
{0.24359844167913308f,0.6526376333131301f,-0.18756097301190988f},
{0.23764985566958816f,0.6716740742723745f,-0.16189870887166977f},
{0.18560010444403713f,0.6956938761218542f,-0.16675051605224395f},
{0.1665641288194141f,0.7073257957202506f,-0.15173287593121526f},
{0.12838966371562524f,0.7230050078095499f,-0.13154520668025524f},
{0.08632573105095583f,0.7299886903129404f,-0.14606350556822995f},
{0.06056301837695826f,0.7316944986694586f,-0.15677609606477141f},
{0.044912326625357164f,0.735702196283637f,-0.1648220886380978f},
{0.018569090950209078f,0.7259604457316887f,-0.18356563651261792f},
{-0.00447326171568254f,0.7201109696220587f,-0.19613427151670332f},
{-0.0313654392573781f,0.7066339483165766f,-0.2061767376620917f},
{-0.02889271694845198f,0.6933307093064451f,-0.20972651307415335f},
{-0.07957706909157622f,0.6853602188690554f,-0.21085642415313213f},
{-0.0950885418611564f,0.6663412449566392f,-0.224231801716069f},
{-0.06160679792984671f,0.6535213791901557f,-0.2413618634104784f},
{-0.013578784037702268f,0.6373786927555168f,-0.26514575335579343f},
{-0.0403338440400281f,0.6170603622174574f,-0.26818860937988204f},
{-0.023409870337700242f,0.5966274594961948f,-0.27933131992852217f},
{0.024854538854163093f,0.5887575185213046f,-0.2874218125154391f},
{0.05007231600147032f,0.5336510309136083f,-0.29655341907404564f},
{0.09843264468259083f,0.520260211253132f,-0.29145998636009673f},
{0.15299835184054736f,0.5369230302416949f,-0.272221028161425f},
{0.1845470946920826f,0.5481273020109698f,-0.2607297798565279f},
{0.22822875891847735f,0.5062063598760519f,-0.2529584834469312f},
{0.2537910430468049f,0.5167510442548475f,-0.2417025797204275f},
{0.2835531442434873f,0.48431964980633246f,-0.22607929490313855f},
{0.2998082143012375f,0.48680752098824215f,-0.21510372022658086f},
{0.3020755933659579f,0.5430612656072549f,-0.200222943729455f},
{0.3149680449589355f,0.5642106147226577f,-0.17306383091309246f},
{0.297408593086594f,0.5902311440250765f,-0.18030579644193348f},
{0.29662495046078696f,0.6072390553813639f,-0.16365858103689737f},
{0.2971580911359546f,0.6227248295683928f,-0.13472605991738149f},
{0.25978475695295705f,0.6531794071141735f,-0.16190563895782387f},
{0.2534146213351285f,0.666954589984717f,-0.13457237837782332f},
{0.2169640000228652f,0.6886965353036397f,-0.13663807206843284f},
{0.1706408446946556f,0.7075663269735795f,-0.11627694455650442f},
{0.1019929570553265f,0.7318216741965289f,-0.11006307425403147f},
{0.08713305155965674f,0.7368787948738902f,-0.125126520087851f},
{0.06983660405307979f,0.7575799088216011f,-0.12502256667072362f},
{0.05279281518499958f,0.7615496721024635f,-0.14194103391336466f},
{0.0318378261418477f,0.7499516741230793f,-0.16454001617693315f},
{0.013936903650010938f,0.7384042552547829f,-0.18115837552340233f},
{-0.016948110545396227f,0.7251567416591779f,-0.19819599392691362f},
{-0.047664706542492496f,0.7152999334036568f,-0.2061362907343018f},
{-0.0793648350703053f,0.7014319014024313f,-0.20941595002270896f},
{-0.335728653744088f,-0.04911566716921868f,0.20280288317230535f},
{-0.35443499822186664f,-0.04705540344493353f,0.20226610481279136f},
{-0.33919755654872613f,-0.05702179906620612f,0.20383530452328164f},
{-0.3063815959702519f,-0.06387129521337866f,0.19847330467626728f},
{-0.33903945857989576f,-0.061728760752990046f,0.2106091147379661f},
{-0.36727636393523055f,-0.060757313111128794f,0.2095750519669211f},
{-0.3733778612386703f,-0.05839309238717084f,0.20006500724661197f},
{-0.37779083449827633f,-0.05160625280308668f,0.19824253057627877f},
{-0.3607083123662061f,-0.043963468429586997f,0.19658772629397273f},
{-0.3268421181073887f,-0.04554048002471488f,0.19547524189032525f},
{-0.30376132221483965f,-0.05554051360211373f,0.19168867383802315f},
{-0.30108522105375113f,-0.06221938811717447f,0.2001743513209747f},
{-0.3039200884381834f,-0.07375566232752885f,0.20749009682268993f},
{-0.3385624682823792f,-0.06654409334858137f,0.21883635727115006f},
{-0.36186083679545167f,-0.06646619867025336f,0.22020339564882987f},
{-0.385418055659746f,-0.07245099685005173f,0.20735551525076612f},
{-0.3974882811624281f,-0.07263312754598499f,0.1996687280705316f},
{-0.392734146444f,-0.06651953260479615f,0.19340793758947358f},
{-0.4011380790827148f,-0.0628609411350541f,0.18946977456655503f},
{-0.3882211496137612f,-0.05040363584553099f,0.19029545454464566f},
{-0.37153296138906855f,-0.03489054609126176f,0.19288738963409519f},
{-0.3451617461417979f,-0.03584099949236084f,0.19472684889329447f},
{-0.30932327464882436f,-0.0438605285495117f,0.18820169522688096f},
{-0.30162541399197107f,-0.046257495869442125f,0.1892751913886637f},
{-0.300599578507018f,-0.08534267713495829f,0.21782721964976964f},
{-0.3069986094925025f,-0.08783480326015286f,0.21736228661850526f},
{-0.3275844011970958f,-0.07578163896451497f,0.2210430877235458f},
{0.037781163856804016f,-0.425548885784695f,0.25531305857036896f},
{0.046672751242646755f,-0.42099390259774755f,0.25701898910378557f},
{0.049520380269710354f,-0.3860876079042927f,0.25104474807040966f},
{0.03986296789946644f,-0.3825691597113674f,0.2552662085106994f},
{0.044220241242333494f,-0.37887692922309124f,0.2686978798763418f},
{0.06061878416298155f,-0.37839886483127727f,0.2700452615846941f},
{0.07298912712350582f,-0.3786105814599439f,0.2594739511413277f},
{0.06404421111515927f,-0.3856255922448786f,0.25319935998279886f},
{0.06124983952927617f,-0.42461334540204526f,0.2546398139274736f},
{0.055764008614982104f,-0.4306704446830444f,0.257345357596241f},
{0.05255778082968711f,-0.4750122243166005f,0.2611032023909526f},
{0.04021410961726934f,-0.47897080256802393f,0.26691089506376586f},
{0.02915640550484719f,-0.5124398252281993f,0.26543860606902087f},
{0.019018882545344576f,-0.5166529170821583f,0.2704954027119996f},
{0.019056572524863757f,-0.455536909064891f,0.2642924444001581f},
{0.028210834930049486f,-0.41819441551825226f,0.2600278013319639f},
{0.02901242162379197f,-0.3807741090986869f,0.25702267672129914f},
{0.0325615330309715f,-0.3744313708535001f,0.26866464775999954f},
{0.05284285671773471f,-0.3658173024489421f,0.2822819547049452f},
{0.058003089385236684f,-0.37233236324114677f,0.2809317565534848f},
{0.06929683607798436f,-0.3607255717123071f,0.284982210770035f},
{0.07343876148228526f,-0.37012636266291754f,0.2709138500894738f},
{0.08265628708541975f,-0.37515811304174124f,0.2540897724688414f},
{0.07322905067956657f,-0.39087294872736666f,0.2581131140380433f},
{0.0753823855777664f,-0.42140355642576627f,0.2658793852586918f},
{0.06981733303778778f,-0.43816222265985516f,0.26376009309399445f},
{0.06090058252293074f,-0.4576827667369139f,0.255638820427964f},
{0.059611459009327405f,-0.47591971925784343f,0.2511972333387721f},
{0.05774980180131556f,-0.489109196701932f,0.2493686669468636f},
{0.04943555125559686f,-0.5466634740320352f,0.2618328215795471f},
{0.038053905190160726f,-0.5358409721353597f,0.26955678240910447f},
{0.03666024074791017f,-0.5622205761547097f,0.2686868765186386f},
{0.02922356986427954f,-0.5578330539366348f,0.26552561939359465f},
{0.005955486348280426f,-0.49525189099307654f,0.2776741443519809f},
{0.014219832411871572f,-0.46172142716434916f,0.2693013360125105f},
{0.007829914760593769f,-0.4252437941334797f,0.25997849923506555f},
{0.017479470625071887f,-0.422413667212702f,0.25870007523053135f},
{0.02432394583292742f,-0.39828658979686843f,0.25613980201867886f},
{0.01743072522986672f,-0.39875654801708094f,0.2580945516487616f},
{0.015195813347864271f,-0.3891072407560307f,0.2586480374335185f},
{0.01867046059153902f,-0.3814669700394129f,0.26980211680814903f},
{0.01928419658569132f,-0.36887227523412036f,0.269148749815406f},
{0.034168742505732146f,-0.36746904699675115f,0.2785731485299947f},
{0.03974405471794604f,-0.3613798491885446f,0.28423779861507376f},
{0.046941236570310775f,-0.3593850786562043f,0.28905432641945294f},
{0.04313620280783772f,-0.3479308329529724f,0.2912926688162785f},
{0.06018044744886909f,-0.35484646929844693f,0.2910016190091071f},
{0.0682957430085523f,-0.34476157058506907f,0.28820492818697163f},
{0.07379475627897084f,-0.35599680623000873f,0.27886675130313704f},
{0.08003708636189699f,-0.357982335939205f,0.2776066251483396f},
{0.08522126145183798f,-0.36313647994753945f,0.2652440738867045f},
{0.09170943270233474f,-0.3565476572433932f,0.25643048741997093f},
{0.10124894011607119f,-0.3796715953923499f,0.24731351021692813f},
{0.09208028102263233f,-0.40354286306811804f,0.26111094309426686f},
{0.08324410032897253f,-0.39856833822365056f,0.2575470036612629f},
{0.08494970576559888f,-0.4265992002080318f,0.2630365328171486f},
{0.0868301272203766f,-0.43693310075221936f,0.2686908892329425f},
{0.08296504723080808f,-0.4471603313025056f,0.2695068928006864f},
{0.06910076340434132f,-0.46329714155953927f,0.2623230441663554f},
{0.0714012747190698f,-0.49034691136394687f,0.2585547835254603f},
{0.0658792518202708f,-0.48798269063998895f,0.24955679599730035f},
{0.067180107503336f,-0.5057107774418348f,0.24765617179558f},
{0.05656805159558463f,-0.5216567835055625f,0.24654460000024253f},
{0.05567560778580658f,-0.5435454388439847f,0.25001569030256443f},
{0.05597418475232212f,-0.5668773645701897f,0.2575195861028727f},
{0.045032212972432935f,-0.5971391926539618f,0.2661721359807694f},
{0.0326872551841556f,-0.5854078986161054f,0.2609893802676646f},
{0.04768625111050106f,-0.6155727851743056f,0.2639787599945636f},
{0.04253026382461369f,-0.6179725073176912f,0.25089274938482486f},
{0.041492026853277485f,-0.6293032258022774f,0.2548402637212998f},
{0.04169194969282919f,-0.646601720568707f,0.26337761353297706f},
{0.04868794231553103f,-0.6501198436648421f,0.2612895083495849f},
{0.030234298972561566f,-0.6648647721999329f,0.26729284767050876f},
{0.004533882705404236f,-0.6845007394488513f,0.2839511269904934f},
{-0.0002645469819068757f,-0.6727663654907496f,0.26621373774585033f},
{0.011441849528888015f,-0.6675160905740035f,0.2555474905404523f},
{0.030221421527478944f,-0.6753896384234137f,0.251196929490138f},
{0.04507212232187032f,-0.6983324987225782f,0.24266405772738606f},
{0.027695075246677334f,-0.7470217594862032f,0.26218419596466075f},
{0.0811089411036111f,-0.22578238485447916f,0.32221228032206567f},
{0.12028707349095916f,-0.2196470668607695f,0.3141415655189667f},
{0.0979097870526304f,-0.21246200283190225f,0.33789994280309754f},
{0.06078753064530607f,-0.21701576956190566f,0.3426510592209333f},
{0.046456977278548195f,-0.20511580022304818f,0.36037912583703086f},
{0.0821445348043123f,-0.20140930372267982f,0.35669240712048045f},
{0.1244085932284254f,-0.1978583532875787f,0.3453205947017471f},
{0.14896269059036385f,-0.20630520507706063f,0.3184849128202413f},
{0.17842194925316762f,-0.20038346823772676f,0.30480894077835485f},
{0.16827605664492637f,-0.21524641328214517f,0.3062576018233731f},
{0.10665235899402288f,-0.23111590367288404f,0.317395732331938f},
{0.031859807359466634f,-0.2256648549279292f,0.3324480632552341f},
{0.017466050289597534f,-0.21251290491496466f,0.3531642538321975f},
{0.0023887591571791936f,-0.1984496512287531f,0.3679693252734948f},
{0.01583511193636806f,-0.18564299756581287f,0.37709558260877063f},
{0.0673753599981485f,-0.18434878830601606f,0.3725482391963953f},
{0.13809553781818856f,-0.17939209597666383f,0.35403413847450715f},
{0.16682431674207057f,-0.19008596259793623f,0.32886464988704617f},
{0.21031313057771447f,-0.17873327776944023f,0.3030675895685043f},
{0.20490992418132503f,-0.19186293740411267f,0.29177409572881574f},
{0.18919970784486378f,-0.20947244037085966f,0.30052105541446955f},
{0.1432730962322797f,-0.2367262264721165f,0.3029272221236394f},
{0.14102220042475394f,-0.23118804222568962f,0.3070329757291836f},
{0.07293390847750537f,-0.23979303341790653f,0.3218437416763502f},
{0.026653256898608823f,-0.2330331853666802f,0.3342878561104863f},
{-0.021774750347324807f,-0.217195144371976f,0.3428087927838843f},
{-0.03409553942029951f,-0.2036995213681231f,0.3573528253138681f},
{-0.050830346099758734f,-0.18883771097524735f,0.3684689905409312f},
{-0.011802940695845069f,-0.1739944619092455f,0.38326036435831534f},
{0.03385386289134981f,-0.16359320470981176f,0.3869395038575387f},
{0.0719459053347183f,-0.15668859190778878f,0.3836039576686178f},
{0.11170872961146913f,-0.16272129299339785f,0.37152876647182503f},
{0.15574752434850003f,-0.1646681595575196f,0.3546649314260724f},
{0.1920053558272577f,-0.1698505104932482f,0.3299648942902979f},
{0.22196521255155638f,-0.162959433829151f,0.3080282542406636f},
{0.2308309579297933f,-0.1767676873300494f,0.2795828747253027f},
{0.23534298159447686f,-0.18080488907155956f,0.26789709423808916f},
{0.2206402019644899f,-0.19773442022914908f,0.2740601527621637f},
{0.21211486798516022f,-0.1994617083467994f,0.29043710968089853f},
{0.19914964995636036f,-0.2072661157582479f,0.2919471895839048f},
{0.18055978255899063f,-0.22058074271771017f,0.29827308866527996f},
{0.16638390195827898f,-0.22902524446111314f,0.29185427989597745f},
{0.11040057837396261f,-0.246876941349414f,0.29847913097382567f},
{0.09850312162957926f,-0.24818484929553167f,0.30808768745845194f},
{-0.14533392728233613f,0.542999744758117f,0.10107858355470827f},
{-0.1076724202925206f,0.5125579734760954f,0.1145816837847382f},
{-0.14810950274921897f,0.5639704478752079f,0.09385811266070862f},
{-0.15951893609096385f,0.5523509297631949f,0.095969871291615f},
{-0.16514373738385071f,0.574254945393755f,0.09203252950993471f},
{-0.16213067871165004f,0.587219453734137f,0.09420270357194611f},
{-0.13378627468432105f,0.5751531591403571f,0.09730165047884827f},
{-0.09838068869097946f,0.5502287404123958f,0.09938447230819404f},
{-0.10827928144572493f,0.5437996379738079f,0.0975144401394045f},
{-0.05882585730351605f,0.5197767168949937f,0.10419099966784404f},
{-0.047517495066506134f,0.48734487623519773f,0.12242275913939121f},
{-0.08641665509868346f,0.44614565109957277f,0.15278398184837158f},
{-0.1244409350470217f,0.4610862879024272f,0.13934318121240533f},
{-0.13378640642288972f,0.500979996571918f,0.11914188445644777f},
{-0.15118534866066888f,0.5098993606099913f,0.11349577657490206f},
{-0.15741511577122455f,0.5255473262231481f,0.10871856529640135f},
{-0.16258154971312203f,0.5459825789904896f,0.10606199331570294f},
{-0.17155516985571845f,0.5671562455582887f,0.10531352913734882f},
{-0.1699825353807737f,0.5927688230100029f,0.10728190627242909f},
{-0.1648162841730198f,0.6009834515752414f,0.09964320579455663f},
{-0.13438856642152838f,0.5863126886670603f,0.10673672320471868f},
{-0.08756843053042196f,0.5656731763114808f,0.103864443129206f},
{-0.07118554643850702f,0.5497292780648513f,0.09863015638761442f},
{-0.05280488838736891f,0.5301521575846092f,0.09612526968219647f},
{0.042800147280957435f,0.5297477732993352f,0.081910508142809f},
{0.032501232888409025f,0.47788998004197336f,0.11410547435696304f},
{0.010570710182953021f,0.43217934000134084f,0.14384216488361107f},
{-0.058164674176504165f,0.41041194364088684f,0.1760295423187679f},
{-0.11274024047895097f,0.3734955574320427f,0.204877918614801f},
{-0.12256843596729391f,0.43213646122207044f,0.15747719385325962f},
{-0.1500963509065092f,0.43333899743663246f,0.14892662131396103f},
{-0.1502514805079144f,0.4595516281322951f,0.13683513915578735f},
{0.2885380647483899f,0.25707131481331535f,0.09897482910425338f},
{0.28135267562273236f,0.25303589685452066f,0.0871562444533846f},
{0.2736236896042268f,0.24017274753139062f,0.09016632838371327f},
{0.2744493600206472f,0.23428756602003337f,0.10469616183329694f},
{0.2706119791275388f,0.2428691321824155f,0.07584654464494009f},
{0.2767665883222889f,0.2555581751758121f,0.07027906025348107f},
{0.2956974142585888f,0.2621317587023108f,0.07415524984153403f},
{0.3011437012917327f,0.2632764213137516f,0.08576559406209523f},
{0.3240010483861531f,0.2740721739065503f,0.09952114151146738f},
{0.3145713195715743f,0.2704123659798641f,0.10864017022399411f},
{0.3027222331924388f,0.2640667911058208f,0.11314614453859922f},
{0.2953938216647953f,0.2524380332330714f,0.1189166826854303f},
{0.28808095316343346f,0.25537839452595773f,0.12649490134900448f},
{0.2752603171512866f,0.24043739225481614f,0.11458844176082686f},
{0.2676044024796452f,0.22667736675651873f,0.11264640277780034f},
{0.266152540399891f,0.2362514544821102f,0.0862949153811806f},
{0.2636982274935218f,0.24967745152763168f,0.06862528331952873f},
{0.28467910316540757f,0.2683478069407973f,0.0662223601414073f},
{0.29718583272872734f,0.2723030619805864f,0.07309975830493202f},
{0.31838703796940715f,0.272973713286014f,0.0723641768836996f},
{0.32708759274426447f,0.2766112308344081f,0.08642466937200918f},
{0.3205529560257258f,0.2684206753677693f,0.09118206780723409f},
{0.35331229982951984f,0.2818155470516385f,0.10161758022173256f},
{0.34768045796006636f,0.27917363204910695f,0.11127347334880602f},
{0.33233952926682775f,0.27470197350681186f,0.11468349963734895f},
{0.3302726605531787f,0.2752476378452608f,0.12461274710708624f},
{0.32125315289239f,0.2695618532815885f,0.12856788953164744f},
{0.31815611088269374f,0.2631955274581718f,0.13440189910835826f},
{0.31488751657164293f,0.2677355965642621f,0.14248450969172202f},
{0.2993287114092467f,0.26065282328429734f,0.1522181848818955f},
{0.2825539560712612f,0.25217119888714645f,0.13719255226690127f},
{0.2682310010451708f,0.23817441049602733f,0.1394806610328388f},
{0.26106919949774315f,0.22491992644277156f,0.13332864623796434f},
{0.25637520662311364f,0.22424003431419987f,0.12361999712619749f},
{0.257312326806179f,0.23810648545260196f,0.09126005279022609f},
{-0.48536546121416035f,-0.6083105552788689f,-0.058721625004338154f},
{-0.4801065138624493f,-0.5651332171029795f,-0.06929019018591978f},
{-0.4827982377304053f,-0.6062896856362324f,-0.09686846962984483f},
{-0.4899653491920746f,-0.6944611367156205f,-0.07846449278965306f},
{-0.4842736066453957f,-0.6729857017082401f,-0.10761039214365277f},
{-0.4735300119016926f,-0.6128600266940906f,-0.1353197493385395f},
{-0.4735018049742984f,-0.5716275280082186f,-0.12213920780655307f},
{-0.4684891843105278f,-0.540192992934007f,-0.061572196901039405f},
{-0.4747185253955512f,-0.5403294900272149f,-0.03375541221548184f},
{-0.4704025350954216f,-0.528559128066908f,-0.012276775110957764f},
{-0.4802942785070067f,-0.6113384568506034f,-0.030976999057334583f},
{-0.490668908579462f,-0.6895966847572743f,-0.05258538484064818f},
{-0.4700922546444551f,-0.689414148221557f,-0.1457062741288518f},
{-0.46184941915182237f,-0.5795860227990093f,-0.16048101063990852f},
{-0.4519855990047457f,-0.5488307296597886f,-0.17182224589942047f},
{-0.4504073709526737f,-0.5453315726679037f,-0.15094161477899232f},
{-0.4571027807829119f,-0.5497605957223173f,-0.12333501579244512f},
{-0.4552936267065343f,-0.5301800712874474f,-0.10680648621365788f},
{-0.4630427549147372f,-0.5054873892009515f,-0.027818847350323507f},
{0.1031982799655779f,-0.3496830855293762f,0.2561202271547528f},
{0.09271820591783586f,-0.34235406736687246f,0.2654138445301593f},
{0.08422383581417098f,-0.346298541092191f,0.2728693901509682f},
{0.08794435397283497f,-0.3309059804417235f,0.26476945488342307f},
{0.10867766737649558f,-0.3295638672137082f,0.266784083942575f},
{0.11142993999044198f,-0.3363832111647838f,0.26390767428789924f},
{0.11805575360976735f,-0.34416889470096323f,0.26785583669313917f},
{0.11044400323084803f,-0.34790651656298377f,0.26180463483790145f},
{0.12980082601453038f,-0.35656322045542327f,0.2528212979134615f},
{0.11112602336226604f,-0.3553251817590259f,0.2540919206574362f},
{0.10132763478748114f,-0.3583853433439552f,0.25712257705262587f},
{0.10942705372482996f,-0.370118905622489f,0.25469018905626156f},
{0.10612483101932325f,-0.37589004190491787f,0.2535348481839078f},
{0.12323817466441157f,-0.39072234817046175f,0.25307459612146066f},
{0.11321566903698481f,-0.3928529677272449f,0.22999606953199686f},
{0.09818147447743802f,-0.38572723598742387f,0.23656322867845966f},
{0.09917494795804636f,-0.38541711808485246f,0.2469487813656245f},
{0.10784660736524773f,-0.42202395371689644f,0.2548077200452193f},
{0.0993542229017824f,-0.41820965363349194f,0.2607365898905993f},
{0.31367120092776635f,0.2968870480614844f,-0.2086162586645021f},
{0.30388989480818196f,0.3255417930970253f,-0.2245054854051544f},
{0.29517973480430126f,0.30416013895197763f,-0.2258929485730094f},
{0.30176115996285635f,0.2313690085226615f,-0.2105989113733449f},
{0.30407352562394496f,0.17947328199439164f,-0.20309375980700353f},
{0.3217534662285914f,0.10738271283761894f,-0.1910174945159133f},
{0.33567673706156576f,0.08213374977141431f,-0.1811645767977978f},
{0.36780093204176756f,-0.0006238570221681744f,-0.14338821502430155f},
{0.38643473106454884f,0.01235909153059703f,-0.13087781802921666f},
{0.4061874579943539f,0.026013016485580142f,-0.1254032836971818f},
{0.4260583225479774f,0.020605332040265423f,-0.11427683436250383f},
{0.44460429869143253f,0.013239838230370969f,-0.09835572263861417f},
{0.45636850081124863f,0.0077446145686158735f,-0.07931846150053931f},
{0.46295707916159806f,0.011276031573695614f,-0.07049023399175611f},
{0.456499647618718f,0.022319003276996315f,-0.08455862441973604f},
{0.45240801766261907f,0.027922597847558853f,-0.08292020352829045f},
{0.44188825737108023f,0.034334394725305833f,-0.09241052039794871f},
{0.4283716815603696f,0.03458842174506367f,-0.09220308952239346f},
{0.4347737924660996f,0.026076888443204774f,-0.0673189562362345f},
{0.44147730740553126f,0.02590764475402441f,-0.04431720879689669f},
{0.4482714425440567f,0.03773320517458324f,-0.02445996112419276f},
{0.45603532228472177f,0.06509892762526275f,0.02061729050259118f},
{0.4575307930179126f,0.08045736373682638f,0.02174924246697576f},
{0.45767969159750355f,0.08077688394852914f,0.009359165281353716f},
{0.45111551038013636f,0.06574518179770807f,-0.011520680719701772f},
{0.4460721287605929f,0.07237558501877898f,-0.008036286946764835f},
{0.43664827718602706f,0.06137354576363793f,-0.02873921442461004f},
{0.4298406866525696f,0.05857032963272451f,-0.05011084793918004f},
{0.4337273282086715f,0.07019787211093748f,-0.06228231240703127f},
{0.44111661145428016f,0.07671828318888071f,-0.05359531395584815f},
{0.4363291213802035f,0.0969651636143965f,-0.07407420406163723f},
{0.4409335883357853f,0.12780807777545916f,-0.09202643978835949f},
{0.45147750246891755f,0.16577031948205528f,-0.09418586440813456f},
{0.43516358670489896f,0.1736495416515864f,-0.1155624625544075f},
{0.4187904193948275f,0.2554256493630035f,-0.13995870523890433f},
{0.3813637502148793f,0.32682700588747465f,-0.17484546650233776f},
{0.33686760166391105f,0.37855729745856814f,-0.2074720826358389f},
{0.31668228245902996f,0.37818914446688834f,-0.22485098361266284f},
{0.29923817301555466f,0.36802448761188106f,-0.22981116170204444f},
{0.30696083664517415f,0.3346452734712314f,-0.21903619936770813f},
{0.3053362653019587f,-0.9973068578176157f,-0.23611158849373226f},
{0.3207932854215706f,-0.9801682044312351f,-0.24189644364823049f},
{0.3172582211704742f,-0.9863643941429099f,-0.23438802942750012f},
{0.31185448781981023f,-0.9833776693731316f,-0.2039083046888223f},
{0.3280791018328294f,-0.9700993544502572f,-0.22265764799795393f},
{0.32915340861177234f,-0.9680925882713177f,-0.23604076626420506f},
{0.3107493605902571f,-0.9832084256839513f,-0.25515735101911435f},
{0.2943699718200418f,-0.9970790924565494f,-0.254820039726201f},
{0.297702823742753f,-0.9997083637437169f,-0.20624812721739022f},
{0.3036010951807552f,-0.9987402393134898f,-0.19637812704407429f},
{0.3132367441269813f,-0.9905620853332341f,-0.19391919266372518f},
{0.32629175155196627f,-0.9732250081647237f,-0.1874798167416007f},
{0.33178871862494f,-0.9495299556981945f,-0.18072446692504804f},
{0.340165659730797f,-0.9382049115337293f,-0.1918568019990015f},
{0.33973736383291064f,-0.9456545395430285f,-0.21119916647477768f},
{0.3287747579685074f,-0.9633365879647728f,-0.23640399499567885f},
{0.29522834739853f,-0.9760214153239736f,-0.2527392895920875f},
{0.28899651284237327f,-0.990923267867263f,-0.26620214687662735f},
{0.25674364327767923f,-0.999740947791294f,-0.2700246126264707f},
{0.26619205559603026f,-0.9994117012360774f,-0.13403109115955752f},
{0.3706692758963388f,-0.99844114495437f,-0.12337591849318612f},
{0.3588112121711963f,-0.998679771310493f,-0.16780796241921903f},
{0.3292437037140756f,-0.9993834932462755f,-0.187082564399965f},
{0.3598783455725964f,-0.9801701496999379f,-0.18269935874482818f},
{0.35682243999335955f,-0.9601235565198531f,-0.17855374572301375f},
{0.33943822910229404f,-0.9478248761534349f,-0.17364005222501452f},
{0.35699285870557934f,-0.9279131598946456f,-0.16467606812126803f},
{0.34788941764046233f,-0.9262862183196027f,-0.17485780743147564f},
{0.34338805311335113f,-0.9281323335637408f,-0.19096393747573007f},
{0.32940889431745524f,-0.9546711298319668f,-0.22649300075455017f},
{0.30658109278427126f,-0.9489859125940658f,-0.2129227053552614f},
{0.288269528425151f,-0.9511896428068022f,-0.21313274019236253f},
{0.2491622788245753f,-0.9626761495856365f,-0.24140964520179856f},
{0.2262834530314307f,-0.9843286093570084f,-0.2789959932134006f},
{0.2640717498942808f,-0.9905792687171764f,-0.27357842093858464f},
{0.2473886888496862f,-0.994089286704118f,-0.2799227591699355f},
{0.22644021342882634f,-0.9985001532090338f,-0.2833848944368146f},
{0.17545050297012602f,-0.9999309413674398f,-0.2933867712917664f},
{0.10469089175934825f,-0.9984779435737352f,-0.2848709617984663f},
{0.013387928848821387f,-0.999792984525899f,-0.23147161905631522f},
{0.28379396022210973f,-0.9989795137383777f,0.06726640423384088f},
{0.29284088437888084f,-0.9990253916948998f,-0.0032690601768761746f},
{0.33413028350231877f,-0.9991834492922331f,-0.02495582722129545f},
{0.357529971723554f,-0.9988892186360744f,-0.058383249178797676f},
{0.375417494065665f,-0.9977818412267766f,-0.0964990906195505f},
{0.3878796226866519f,-0.9888015640368336f,-0.10927378811793002f},
{0.3821721554419556f,-0.9906536776354751f,-0.1174903927616979f},
{0.38394645510526293f,-0.9847222144526274f,-0.13431539255231056f},
{0.3789954370960316f,-0.9910375553251723f,-0.14577632611271565f},
{0.37076921659916245f,-0.9946926620972929f,-0.15981131231428783f},
{0.3607895281313528f,-0.9893858107773634f,-0.18005205202265345f},
{0.3862857921134609f,-0.9747413902708674f,-0.1715231313545523f},
{0.38450808743311793f,-0.9642552689978624f,-0.1745211240215788f},
{0.38032563542044145f,-0.947692593632015f,-0.16965152469738617f},
{0.3598719828122136f,-0.9401774724307711f,-0.1670413013198703f},
{0.37689237639787765f,-0.92904987888288f,-0.15479238944737966f},
{0.3672705472524629f,-0.9155937296412617f,-0.15491818703151836f},
{0.35193180711931565f,-0.9154254580552289f,-0.16985053599103564f},
{0.3209885474780535f,-0.9123400079771634f,-0.16034066338079195f},
{0.32309582274799553f,-0.9362304043055768f,-0.1992196610375235f},
{0.30240054460639276f,-0.9174061251238721f,-0.16052299805902503f},
{0.28909485355903264f,-0.9274657342817062f,-0.1755703845363666f},
{0.2731638635673121f,-0.9447757381119571f,-0.20785604106852987f},
{0.24504823737569387f,-0.9394466782191371f,-0.21685038135067305f},
{0.20065087469025816f,-0.94966742489455f,-0.24149734696663416f},
{0.20048406285255824f,-0.9683720663326069f,-0.25806676968449205f},
{0.18978354980801737f,-0.9794667517985379f,-0.2770552057467759f},
{0.20257763943617937f,-0.9864123788541221f,-0.29571826560550024f},
{0.13338688371576102f,-0.3529710124753721f,0.2672386818706496f},
{0.1498115820543192f,-0.35221946731436476f,0.26991346564605195f},
{0.14874882577310247f,-0.36266538601337645f,0.2698863529987036f},
{0.14296526781854196f,-0.3633271215924503f,0.25683460822810766f},
{0.14269881912665255f,-0.370906762820084f,0.25929941878606194f},
{0.13235896166186628f,-0.3674709922654539f,0.26056679906139607f},
{0.1261623554863294f,-0.3707975005511228f,0.26523720435779563f},
{0.12351143232796456f,-0.37604891011941155f,0.26402058486528496f},
{0.13230423916031386f,-0.38662727388823825f,0.2591128089787955f},
{-0.3756963665545014f,0.10546753896092072f,-0.17480003475709652f},
{-0.3819894574202511f,0.07725665303529623f,-0.18238271553347882f},
{-0.37694579320022975f,0.07444670973812063f,-0.17546979470237029f},
{-0.37672763200577875f,0.1159112690998408f,-0.17097562373855044f},
{-0.38858747951363665f,0.1271276990641099f,-0.16339117936520114f},
{-0.3806408603173625f,0.03905878308742102f,-0.1725335268667815f},
{-0.3783404701171245f,0.04412255018805067f,-0.17594712922001776f},
{-0.39073439109420843f,-0.008115310964596495f,-0.1847553260919238f},
{-0.3884199378017702f,0.006991610721683389f,-0.1884770808932803f},
{-0.3824022719115089f,0.04339410602249559f,-0.19049533701270055f},
{-0.3780489146038349f,0.1356352621479774f,-0.18591239018974776f},
{-0.3788685452318471f,0.13386274520497785f,-0.17974090145968932f},
{-0.3755179638475785f,0.13433400062512812f,-0.1735445693853679f},
{-0.374961477823162f,0.16398029405832298f,-0.1700879873241192f},
{-0.37236791193772195f,0.21159897709442332f,-0.1695659105639001f},
{-0.3710009149939468f,0.251309337548629f,-0.16905110810996604f},
{-0.3942526353048339f,0.2544647386818161f,-0.15430504386092483f},
{-0.40038252226981136f,0.13324526528569794f,-0.15610917274835423f},
{-0.40850438350976936f,-0.009015672899793317f,-0.15914984021235123f},
{-0.398520885247548f,-0.034075048229636064f,-0.1656409298971061f},
{-0.3888595419684017f,-0.03353643615423955f,-0.17344519600831565f},
{-0.38463984406267115f,-0.008830299735219468f,-0.17695452449258742f},
{-0.3983955742461869f,-0.055774763900461384f,-0.18311081547890296f},
{-0.39939794432980835f,-0.04458200119500804f,-0.1877201248892892f},
{-0.3883124178816198f,-0.020618979731011455f,-0.19863229400525148f},
{-0.3662646924712198f,0.02044921971163464f,-0.20605221602973456f},
{-0.3620563825148202f,0.08132911396725293f,-0.2001932366822311f},
{-0.36842335640700186f,0.13485980643676546f,-0.19361793099267008f},
{-0.36630110649895736f,0.23684640073170912f,-0.1877551822222516f},
{-0.3728878001378494f,0.23339766030251685f,-0.1804457782327629f},
{-0.37466708568101575f,0.20817179716935666f,-0.17908417088381526f},
{-0.36447020918431056f,-0.9235762157252506f,0.013433119958693321f},
{-0.39234666081737507f,-0.928878041856232f,0.04590614698211594f},
{-0.3711348580587759f,-0.9063456460022464f,0.056063806819276904f},
{-0.3481378128364116f,-0.9044223659539468f,0.01255436421115803f},
{-0.34591902618017145f,-0.882593205452966f,0.03674934011022169f},
{-0.35330285821129936f,-0.8788805491121069f,0.059528476991194186f},
{-0.35846036580276497f,-0.8888882830213232f,0.08101986511427134f},
{-0.3820542207380295f,-0.9066131284169362f,0.08448781281428695f},
{-0.4152664615549919f,-0.9284508806098883f,0.07276697074447981f},
{-0.4342556880486875f,-0.961171115057327f,0.03814850570011989f},
{-0.4188038758521673f,-0.9571183511661946f,0.027276729329149128f},
{-0.42349920629823146f,-0.9713500379244265f,0.0016683462634747184f},
{-0.3957773668739679f,-0.9538861900062221f,-0.004121883612141669f},
{-0.36778532952064846f,-0.9336606278558509f,-0.013968099661782534f},
{-0.34359928422164787f,-0.9029275443519287f,-0.010323646715195292f},
{-0.33134777794928166f,-0.8724436252272112f,-0.0020411589758156986f},
{-0.3335130075653386f,-0.8709447505393924f,0.018709376058468594f},
{-0.3275842598968569f,-0.843607235016107f,0.035660448596843176f},
{-0.3374670875820883f,-0.8436568409616393f,0.06571591246250252f},
{-0.34735269133893104f,-0.8700996678074411f,0.07693499313426122f},
{-0.3461151997825565f,-0.8851062429511135f,0.09395570862949228f},
{-0.37110053166238777f,-0.9057293007345092f,0.10240156706767048f},
{-0.3867364601950409f,-0.9115176214632884f,0.10526066053742741f},
{-0.40447569271723677f,-0.9171512874869541f,0.0919822956813857f},
{-0.421723527629585f,-0.9362005761438623f,0.07309825924751007f},
{-0.4352854544425429f,-0.9600031081590452f,0.04869352261256062f},
{-0.44435902591204096f,-0.9764884561723358f,0.02661165141510045f},
{-0.44494578524704487f,-0.9877270957719034f,-0.0033781301500235353f},
{-0.06371996000147197f,0.8423815064390208f,0.17428051096284836f},
{-0.07082114268399377f,0.8467980674498059f,0.1755024701170194f},
{-0.06056095730580392f,0.8309597024207193f,0.18245742936281933f},
{0.32998211751453344f,-0.2444362049524673f,0.18920124886739426f},
{0.3387711039283927f,-0.22624593994281209f,0.19879411146382972f},
{0.329213713003966f,-0.1998269429042213f,0.19920407870215287f},
{0.3251630569299316f,-0.1921213415440537f,0.20407785222663669f},
{0.33424594996556733f,-0.09925776211574533f,0.21512818004162396f},
{0.3357434860195438f,-0.1900294669377465f,0.202873471672114f},
{0.3566185044395041f,-0.20515211332204372f,0.2116679093004539f},
{0.35385014272166093f,-0.23443382026658166f,0.20550820373543233f},
{0.3557125499895876f,-0.2671076912371285f,0.20028760611849136f},
{0.33668044471662184f,-0.2773381653184631f,0.1864109611771384f},
{0.3272559854447878f,-0.28497097899465235f,0.1761455530021475f},
{0.3211701522821201f,-0.24306345188316963f,0.1922408826085907f},
{0.3158001174448278f,-0.22991515017862965f,0.20610066820038372f},
{0.32070558365673507f,-0.20554223159522547f,0.21230867188692185f},
{0.3254095047323626f,-0.16477799021465994f,0.22026795604671634f},
{0.3288559758584696f,-0.10816014462736025f,0.21850058646956325f},
{0.3288355903773834f,-0.03800963412545344f,0.22469110186111702f},
{0.33476721610862636f,0.0005137533262202135f,0.22324057735279748f},
{0.3431242593785826f,-0.081129423795012f,0.2194202194200521f},
{0.34486455667988414f,-0.14778847869925915f,0.21373550788826937f},
{0.3589768086143599f,-0.17214445612770188f,0.21807845041216772f},
{0.36264472165023975f,-0.273337600710331f,0.2003888939544198f},
{0.3499301468723182f,-0.29767752940637393f,0.19028840334400102f},
{0.33647006565938975f,-0.30824843507236416f,0.17746328928292898f},
{0.32788071842219646f,-0.3197866545514213f,0.1630444253916595f},
{0.3134872864491176f,-0.3027734757772047f,0.1733322153120143f},
{0.3166491714571782f,-0.26039323349723875f,0.19083739089408425f},
{0.30737336747354627f,-0.2659735655863617f,0.1933606009470264f},
{0.30545732136003484f,-0.23453035701477729f,0.2095324472888662f},
{0.303475418711107f,-0.21630450984270083f,0.21815518919079688f},
{0.3090502995857493f,-0.20517018806613999f,0.22055586431398927f},
{0.3182924464899143f,-0.1602229262847188f,0.22469215576966597f},
{0.3267085776951202f,-0.12362314291572725f,0.22595025591276707f},
{0.3265476430974332f,-0.09259696340718875f,0.2284962832982758f},
{0.32628542916308034f,-0.052175666205752966f,0.23208147938677134f},
{0.32665277153760014f,-0.006450921639015529f,0.23532634588176116f},
{0.32786454857530617f,0.021169476962594663f,0.22890164074910505f},
{0.32918424924813094f,0.05497844568705583f,0.22568074642397287f},
{0.3447256681066927f,0.012011202905512804f,0.2265230732700612f},
{0.3538647327681357f,-0.09511048748811379f,0.22489619225226365f},
{0.35302455411064204f,-0.1485797398514821f,0.2197448253779483f},
{0.3636591288143651f,-0.0993803172312435f,0.2278793505190188f},
{0.3676975459504115f,-0.1274343620164785f,0.22307502234353854f},
{0.3665532891787547f,-0.21966668209619244f,0.20555735390801366f},
{0.3681507266264655f,-0.30595035560911615f,0.1908600254925073f},
{0.36454818354322455f,-0.3329356053871341f,0.18837760552507815f},
{0.34743733230686186f,-0.31632575698964255f,0.18455108668943412f},
{0.3438350325150097f,-0.3388365923395024f,0.1757551202562536f},
{0.33787706438208176f,-0.3490785754846586f,0.16087544653843602f},
{0.32937193314969476f,-0.35215997353933115f,0.14866418427396771f},
{0.3163281118165567f,-0.34795822926320635f,0.15733987658122134f},
{0.29758614480485995f,-0.3149958019566215f,0.17794970207532532f},
{0.30174537470759377f,-0.2920882815908973f,0.18499934310528213f},
{-0.32626261289292147f,-0.009529563807825128f,0.18042046955387842f},
{-0.34697920824726103f,-0.0019027474237316342f,0.18435124565528394f},
{-0.32664199234794505f,-0.019274434651515716f,0.18821853439069253f},
{-0.3066598384512562f,-0.02375314439445547f,0.1840685145012762f},
{-0.35503521188939474f,-0.021075564361693395f,0.19226231243655556f},
{-0.3656359053456026f,-0.0007678111558046295f,0.1863549319139779f},
{-0.3796727762586322f,0.015425575504412361f,0.17602576333418254f},
{-0.3508610275343069f,0.006532837530909823f,0.1746551797016359f},
{-0.336173140737021f,0.004031471644979041f,0.17989825043101262f},
{-0.3068416047413101f,-0.009556879375065438f,0.17944214175903017f},
{0.4663798405325769f,0.19802562089822973f,-0.0763095972143782f},
{0.48140408670537715f,0.19536149626039964f,-0.048143595893972095f},
{0.46419880547550907f,0.16341315102114978f,-0.07415694119476988f},
{0.4535745648125682f,0.13266085705918085f,-0.0759884972022598f},
{0.4764531483767318f,0.16127037326937235f,-0.04429622624262046f},
{0.4899088120979802f,0.19532599377856427f,-0.025165846122279414f},
{0.4923401865572925f,0.2398291542210881f,-0.028344799774238778f},
{0.45436031525547305f,0.21937347560116374f,-0.09471891371623035f},
{0.437510704787908f,0.2506387680486028f,-0.11818186513541433f},
{0.4142946070109389f,0.32693359301356667f,-0.14043871383701326f},
{0.3745529586466859f,0.3871303526719728f,-0.17669332409528662f},
{0.35949531887155606f,0.3880064800225826f,-0.19276577581191798f},
{0.3132815278034576f,0.3796775629370268f,-0.24108307378945115f},
{0.29324684952697827f,0.37430408377360963f,-0.23744940640696582f},
{0.2736983619996627f,0.3662499446571851f,-0.24430741244070805f},
{0.07450761704674745f,0.8652884392932252f,-0.005449164564701227f},
{0.08576692579028694f,0.8409066857264611f,0.014232064444208712f},
{0.07828728582272194f,0.8278725099938431f,-0.038136819214193915f},
{0.05741121349421276f,0.8918736404722478f,-0.04615810655627272f},
{0.06365436481837729f,0.8558791767027264f,-0.06248448436391982f},
{0.07191546947573565f,0.8371203301557213f,-0.05359172726707667f},
{0.07657029137435681f,0.8215366614633136f,-0.04766275543054681f},
{0.08951143630455695f,0.8045854083156112f,-0.03851981085577641f},
{0.10920768775992087f,0.7948597468675596f,0.00757560142193064f},
{0.1120559903535368f,0.8167072254040252f,0.05606039117816308f},
{0.08086218945254608f,0.8613359805107957f,0.0545704810874573f},
{0.07373782503157841f,0.8799694554991945f,0.028836007213088214f},
{0.056839794265598556f,0.9193134467444357f,-0.0016008366215036712f},
{0.04191105218060109f,0.9243119851926656f,-0.047220963766231534f},
{0.035659086058825076f,0.9016635786553002f,-0.09237192843419763f},
{0.045761071477034516f,0.8616397760244812f,-0.10243079709378707f},
{0.06064789307460753f,0.8517224190229696f,-0.0801960772844929f},
{0.07046366795322682f,0.8482448235976183f,-0.06717134423250319f},
{0.07974626072277383f,0.8379958083751583f,-0.059781979181493194f},
{0.08382492186671817f,0.8235257778612813f,-0.05851731442052514f},
{0.08130778028719507f,0.8150042133048667f,-0.05341922092350736f},
{0.08194549270083637f,0.804880894737803f,-0.054903221901965824f},
{0.09354474750866153f,0.7914469136975786f,-0.05539144822449634f},
{0.10297524550649584f,0.7748920204689502f,-0.05017831614724645f},
{0.10629119664574228f,0.7680591818138534f,-0.03272158211174758f},
{0.11701191349963355f,0.7636770088191093f,0.004403236823217922f},
{0.12180187579668737f,0.7876308510796151f,0.044679586539713524f},
{0.12580542895799313f,0.7900932499718372f,0.07095081008858568f},
{0.11952059512575401f,0.8106054444376997f,0.08630630864255065f},
{0.10573414435796234f,0.8299715781634418f,0.07935739555960566f},
{0.0839550561995432f,0.8495746766394895f,0.08868416643317643f},
{0.06657367237566394f,0.8814156846927323f,0.09303614579791902f},
{0.055227726399916084f,0.906905139703177f,0.09618167928735345f},
{0.0589577286731129f,0.9139907899834951f,0.06136383004420223f},
{0.06315038405041071f,0.9112031572503603f,0.032606215247501714f},
{0.0440467829813651f,0.9456256941085394f,0.025533354232417763f},
{0.03381987115342239f,0.9501874650189944f,-0.015197414927640056f},
{0.025126640618017233f,0.9343121196988066f,-0.07276924429719633f},
{0.011653692584084215f,0.9404397373606987f,-0.0860179339782485f},
{0.00569394066844082f,0.9261950605421563f,-0.11064206207589454f},
{0.009337652054375766f,0.9031946719224093f,-0.12748810604043656f},
{0.015031722336569497f,0.871906582328152f,-0.1387022667016204f},
{0.04409820776907075f,0.8104836383197087f,-0.12920015604284718f},
{0.05029715336660847f,0.8193074791466384f,-0.11907108241266902f},
{0.05185929125237598f,0.8415989379075111f,-0.10617903665947531f},
{0.05661138083576703f,0.8505212203798425f,-0.09151948002888959f},
{0.06551345949874784f,0.8516074016908939f,-0.09548545370108856f},
{0.07374510996194153f,0.8516190733031106f,-0.08182763927110774f},
{0.07815804285005075f,0.8474598837718736f,-0.07772869357481929f},
{0.08141703299448602f,0.8294257321532568f,-0.06575271426909134f},
{0.08458070178526203f,0.8108248412124355f,-0.060601671429158475f},
{0.07904946887314547f,0.8043298004330299f,-0.06480523879708773f},
{0.0794278241670388f,0.7897533857129528f,-0.060641915437056375f},
{0.08299613115855566f,0.7911741022453065f,-0.057728160022992296f},
{0.09467400945646756f,0.7776340397851083f,-0.05453642666746895f},
{0.10234524298634236f,0.7731256229949446f,-0.06031226304205576f},
{0.11604275534660594f,0.7551761335924149f,-0.04864297749852288f},
{0.11368690427138668f,0.7423335726702632f,-0.027415277931840936f},
{0.1211239289368186f,0.7202246493826998f,-0.001987667804916768f},
{0.12267396918483706f,0.7222000883425029f,0.013259018940999014f},
{0.12012421381031789f,0.7257706550754347f,0.019569856266831245f},
{0.12748586701597392f,0.740399673855888f,0.04639713768977186f},
{0.1274693423248746f,0.7680259082636065f,0.050497985096042815f},
{0.12904867315625485f,0.7686863880766471f,0.07596245864920885f},
{0.1234551300259965f,0.7916918624425875f,0.095917079185056f},
{0.10731472245611322f,0.8161107397255074f,0.11904927436752327f},
{0.10421780262331536f,0.8304531474386255f,0.10682675058025355f},
{0.08985681233516714f,0.8380558492902147f,0.12241654830332546f},
{0.05775099701010345f,0.8473242982245679f,0.1306910669217113f},
{0.06788752768071026f,0.8591698191630884f,0.10366317315654937f},
{0.06792104452234594f,0.8694686220028166f,0.0960570662879245f},
{0.053987773244642503f,0.8983469581991327f,0.11246091806040631f},
{0.046467027656444546f,0.9144086296637013f,0.10657611689104549f},
{0.040194792918441566f,0.9424281036987516f,0.07021520104475017f},
{0.0511744759260061f,0.9333148959186238f,0.05067964620772344f},
{0.022727227635304856f,0.9657593611704433f,0.04402614517842371f},
{0.016832243287071183f,0.9691354955873929f,-0.0056934238070405615f},
{0.00617323320368483f,0.9715513886400766f,-0.03187875912121131f},
{0.008509099325562904f,0.9605871424180126f,-0.05653717430615643f},
{-0.009733432961192418f,0.9535177437899861f,-0.094009680008722f},
{-0.022335981085027278f,0.9381768554682443f,-0.12561558783736818f},
{-0.019702077699801854f,0.9163104703223658f,-0.143463960451627f},
{-0.014159423903712234f,0.8845500522760685f,-0.15912738728566397f},
{0.009507001984337248f,0.8390695478283298f,-0.15360979250262302f},
{0.015550197534307758f,0.803904685384131f,-0.15456340762936904f},
{0.0312208583031329f,0.7973435639012606f,-0.1464950843062537f},
{0.030056909802690813f,0.7712258901533781f,-0.1518317234164008f},
{0.06283050899449884f,0.7852387878341422f,-0.11841168731800382f},
{0.0648241246895481f,0.8133792775557718f,-0.12659897056858335f},
{0.06670943003303506f,0.82685911636677f,-0.1240359414708679f},
{0.06517345287721683f,0.8443244219084917f,-0.10813684602405504f},
{0.28497400313848764f,-0.8040545263194508f,0.040748881619631395f},
{0.29575502438457274f,-0.8176137779895396f,0.012532395742432773f},
{0.2721987786858337f,-0.7647879421073521f,0.057735439641316375f},
{0.27456907850728873f,-0.7865835464576081f,0.06206307818069073f},
{0.2652652896394954f,-0.76095418933692f,0.08222485017883874f},
{0.26631382028011674f,-0.7210140364475437f,0.06697334647590582f},
{0.2829430214983018f,-0.7674723311117778f,0.0297208654310925f},
{0.30270320546853563f,-0.8303120607436725f,-0.019214752830299435f},
{0.30624189571749255f,-0.8549951779726417f,0.0005581821584874515f},
{0.29825857883059514f,-0.8300387425228741f,0.02423798482329086f},
{0.2915464318276953f,-0.8069963462982622f,0.04474367310371609f},
{0.28282974651503673f,-0.7915673110628119f,0.06342182659021776f},
{0.2770997456006595f,-0.7670404687108685f,0.08730031757669597f},
{0.26564949136357513f,-0.7506673014007971f,0.09338759667639505f},
{0.25634825546175266f,-0.7373463520524488f,0.09735991823526749f},
{0.2583338266048535f,-0.7239884415363402f,0.087617357066159f},
{0.2598609485915633f,-0.6898695163952949f,0.0893690274430822f},
{0.28085617208094277f,-0.6925166201975776f,0.052781614750647264f},
{0.28880396630025645f,-0.7493600425858522f,0.021879683835658338f},
{0.2941159246145356f,-0.742121318463244f,0.00730108268030546f},
{0.30059862446480345f,-0.7962960765451103f,-0.029772598317063484f},
{0.31141322310976943f,-0.8751925331956186f,-0.061745695533504605f},
{0.3153007762117738f,-0.883882308780821f,-0.03356981063322853f},
{0.3161300938742108f,-0.887617336242966f,-0.022889707505153543f},
{0.29972211358497375f,-0.852544552683786f,0.02664353958556126f},
{0.29426686939157143f,-0.8312649470586597f,0.039760788172180254f},
{0.2888221228497541f,-0.8084958690548462f,0.06236834512919502f},
{0.28721982169908244f,-0.7977468039733218f,0.06365922055327947f},
{0.2807433433089585f,-0.775488860991677f,0.09596907554816422f},
{0.2787580356429949f,-0.7485209582084045f,0.1113895753992574f},
{0.2762310359813893f,-0.7398827338374375f,0.10777990993404843f},
{0.26449402831432306f,-0.7240938132678958f,0.10727507180297802f},
{0.25133768099542697f,-0.7115490495049259f,0.11415165509971135f},
{0.2483917877450663f,-0.7147316036569584f,0.10533802826148096f},
{0.24296736612708997f,-0.6925454762561446f,0.11421835412452229f},
{0.25563614475389085f,-0.649037593262693f,0.10805059869551333f},
{0.2763578056686755f,-0.6358476292358267f,0.08014352315728368f},
{0.28907550180074704f,-0.6597543983310225f,0.037433602984529614f},
{0.2921016397755145f,-0.6900591859370583f,0.0015285960775481737f},
{0.30481558667041947f,-0.8435420669209523f,-0.06090149460003689f},
{0.3177592643808421f,-0.9038189905607716f,-0.0695354225938144f},
{0.32405426120620556f,-0.9131056566018679f,-0.05294208932575187f},
{0.3349106029164915f,-0.9332978240875016f,-0.07437005595211643f},
{0.3304192483957798f,-0.9012313815959304f,-0.03512583329963332f},
{0.3196323307863411f,-0.8862724671290878f,-0.012942820878522674f},
{0.3036173872045438f,-0.8681442902943418f,0.024184630702999612f},
{0.282647938791078f,-0.8391138544836989f,0.06896327667825707f},
{0.2792644482624419f,-0.8316956748080265f,0.06271840531584587f},
{0.2743727019850116f,-0.80821914687942f,0.0744034899259429f},
{0.2759673219272066f,-0.7925287890697704f,0.09293647388427179f},
{0.09637063860949488f,-0.45230296518461083f,0.2648164058718347f},
{0.08706541017911705f,-0.4629939951770266f,0.2670093770806643f},
{0.07849903219880743f,-0.4757707399352588f,0.2651772027518281f},
{0.07889580858174355f,-0.49178369681444867f,0.26317124719004886f},
{0.07805544719010635f,-0.4978234501631102f,0.25851344523751657f},
{0.08483345179083047f,-0.5089170009774986f,0.25671934760464293f},
{0.07421419700774874f,-0.5024497612857031f,0.24986954760883637f},
{0.08016343214846641f,-0.5143982837239518f,0.24747497283129735f},
{0.08606857205296975f,-0.5236107023327367f,0.24166604457819935f},
{0.0704920161808598f,-0.5334519484386356f,0.2475304953259318f},
{0.06236008437725712f,-0.558957614729875f,0.24267820156257996f},
{0.0628758695584168f,-0.579804060754154f,0.24349949485881708f},
{0.0628611679591218f,-0.5948741838210686f,0.25281116573016366f},
{0.05799972580210554f,-0.6235369532228093f,0.26195412092901216f},
{0.05435658492916547f,-0.6394544272623526f,0.26234778658187635f},
{0.0474109366254251f,-0.6318887269500207f,0.26041017996423926f},
{0.06371131625151806f,-0.6246394669291463f,0.25038846370581636f},
{0.050163503526335265f,-0.6388003112721025f,0.24670725676099187f},
{0.03150393367727163f,-0.6512825002773854f,0.2473844333751974f},
{0.00929709676098908f,-0.6654165963788726f,0.26400682562171884f},
{0.011914508389757262f,-0.6603428607057481f,0.25610926523095423f},
{0.04656933009183288f,-0.6625320008720095f,0.239038373277196f},
{0.05573475734070938f,-0.6433428111672654f,0.23128276119411978f},
{0.04139034805127447f,-0.7222467259206103f,0.24481814268550076f},
{0.3376282654711641f,-0.5997772171190877f,0.13764993689066526f},
{0.32513825395716545f,-0.5847636715177643f,0.14046110620645524f},
{0.32285954643795145f,-0.5838660654684305f,0.13413293782199479f},
{0.33873163016615815f,-0.6045607762842619f,0.13207223851050692f},
{-0.14778390450242687f,-0.5586496046444016f,0.22013842941115944f},
{-0.15932710879893539f,-0.5646924379133085f,0.2312333177969825f},
{-0.15396126941009042f,-0.599154389038885f,0.22194259867008564f},
{-0.14708871370137033f,-0.6093641121708463f,0.21705942283647045f},
{-0.16096541813756074f,-0.6269130674540105f,0.2271352836465963f},
{-0.16969926664841342f,-0.5794673571585088f,0.23181148437760735f},
{-0.1570662136090882f,-0.5153965603502758f,0.23765577274989397f},
{-0.14396863231587484f,-0.5220855659862266f,0.2235648794620596f},
{-0.1349505833410113f,-0.5411051890298156f,0.21987897136266943f},
{-0.13811633870072892f,-0.5759043292714071f,0.21574515212996997f},
{-0.13414779187681064f,-0.6045857407430154f,0.21760484388353063f},
{-0.1404664963324867f,-0.6346992375729676f,0.2189272207616325f},
{-0.14918875397411635f,-0.6670159790952862f,0.22285860456030615f},
{-0.15903794370322144f,-0.6792543550695108f,0.22670481937436676f},
{-0.17358256480713277f,-0.6573862881320667f,0.22712644866323622f},
{-0.19361646221387072f,-0.6075544725740989f,0.2308763498347416f},
{-0.22520118350594087f,-0.6106971471241126f,0.22744564484055652f},
{-0.2318345253470182f,-0.6070149680761406f,0.23644857681467094f},
{-0.2240509687512774f,-0.6103059749423819f,0.25260581186187975f},
{0.4687131791862714f,0.08167100423783373f,0.04939555638233075f},
{0.458224260593499f,0.10977133175696695f,0.06700877777641782f},
{0.45691088124715223f,0.07867422909015916f,0.045957519711838826f},
{0.4682870718484767f,0.05763560092964275f,0.025949228458172595f},
{-0.06766381115581314f,-0.7589145150760207f,0.21779487783117332f},
{-0.05948303834030214f,-0.7659728083551942f,0.20648975381317275f},
{-0.052770322949223174f,-0.7903877951007084f,0.19505798972163896f},
{-0.07394258182667224f,-0.837940983882456f,0.22380800511526414f},
{-0.09094325818576363f,-0.8627792413369086f,0.254017390624647f},
{-0.11384295710518f,-0.8692158411874218f,0.2847629765436945f},
{-0.13336350011983075f,-0.8661608673398357f,0.28773598244140336f},
{-0.16011506692527253f,-0.8596364031760918f,0.27907627937171214f},
{-0.1853620050421885f,-0.8628192824249145f,0.2668562224953806f},
{-0.15777567042223697f,-0.8336787737281502f,0.2607716865326507f},
{-0.12697169350746423f,-0.7996279351165176f,0.25372429462003077f},
{-0.11154424444687622f,-0.7917616817591409f,0.2549237094804427f},
{-0.10890758198856453f,-0.7794490604774208f,0.26326184614098624f},
{-0.12253342006823617f,-0.7895506559919635f,0.2801480331846841f},
{-0.11326530579234372f,-0.7806746158820336f,0.2876266999866937f},
{-0.11067554970131549f,-0.7821358802709191f,0.3128925234648661f},
{0.13457812334806382f,-0.7041983072274935f,-0.2947950874001446f},
{0.1331237380497574f,-0.7269751663061184f,-0.2971683853364437f},
{0.11846755456397307f,-0.699950362022872f,-0.2970369548660886f},
{0.1357344979432181f,-0.6751297755975475f,-0.28985877948947075f},
{0.12398130980518343f,-0.6355918184333536f,-0.29064532036378743f},
{0.09546191764963756f,-0.6763357157667375f,-0.3037303779937193f},
{0.07949648864630088f,-0.7349315532798111f,-0.31043284008701f},
{0.13015802664408194f,-0.757656537109818f,-0.30135533664620173f},
{0.14183609723780782f,-0.7659838318986458f,-0.30135217598296266f},
{0.14363310268086135f,-0.7583160023233988f,-0.3042794877207009f},
{0.1350509490069594f,-0.7322993635583855f,-0.30477214109658174f},
{0.13468389029532538f,-0.7030726117827107f,-0.30506053594663235f},
{0.13942422646109826f,-0.6743571565151921f,-0.29792305078919323f},
{0.13964608483473312f,-0.6616544966408762f,-0.2855082789964017f},
{0.140322227726138f,-0.6389783081392414f,-0.2839119156429882f},
{0.14333615651033638f,-0.5869845861768509f,-0.2798028590115581f},
{0.06572114322736232f,-0.655286307354158f,-0.3160722208022936f},
{0.04121220882148879f,-0.7184868954856991f,-0.3209449393558206f},
{0.018233927845890334f,-0.7661008763048259f,-0.32843635292675205f},
{0.0871683107501033f,-0.7686385552897521f,-0.3138435240059882f},
{0.12143789700529871f,-0.7855272336797678f,-0.31139966731729923f},
{0.1476957150924059f,-0.7947599166551484f,-0.310632276343784f},
{0.15794497360625487f,-0.7870998681547126f,-0.3089847867392599f},
{0.1720050453810711f,-0.7981063652730305f,-0.32957696245239215f},
{0.14397939131978157f,-0.7613536302386473f,-0.3147804827030662f},
{0.13678972706509068f,-0.7558473830334405f,-0.3248701633140034f},
{0.13242062381124312f,-0.7304182324151898f,-0.3178650414209778f},
{0.13532209885341445f,-0.721506528337437f,-0.33096665561424343f},
{0.13923872049554795f,-0.6875727341319846f,-0.31399659678587033f},
{0.14519167406360586f,-0.6457354013670127f,-0.30087808287154794f},
{0.1425136074480661f,-0.6505923962849302f,-0.2910238073962494f},
{0.14676224215535724f,-0.620581028717893f,-0.2846372384543932f},
{0.15084933350528545f,-0.5841106901790569f,-0.2780875261690101f},
{0.15210277180290996f,-0.5641376953001107f,-0.2762018967911406f},
{0.15498550278406392f,-0.7181346286780238f,-0.3575427381470203f},
{0.16243940804721194f,-0.7052196041062762f,-0.3417927643854388f},
{0.16690022471779123f,-0.718593077834415f,-0.3625683679944422f},
{0.15336978767236475f,-0.7275689779041746f,-0.36348729125651297f},
{0.18358038857628392f,-0.7199967926545617f,-0.35991465814038787f},
{0.18907208716892057f,-0.7119538396299839f,-0.34601562295440846f},
{0.16900136033299087f,-0.6906812044625087f,-0.329238759799325f},
{0.14990418789361246f,-0.6860171215549952f,-0.32167743660717635f},
{0.14567997156745974f,-0.713863988317734f,-0.3404932048399036f},
{0.14064781641125984f,-0.7325384764972862f,-0.3596390706165044f},
{0.14275746297543704f,-0.7416184521610717f,-0.3617630023161144f},
{0.1530748675135362f,-0.7405914809621681f,-0.35540299994399144f},
{0.1742307833716216f,-0.7280181862374218f,-0.35713235444483504f},
{0.20451903566247998f,-0.7285688757648189f,-0.3517831927338143f},
{0.17644353130186138f,-0.6666457193489161f,-0.3143088628770365f},
{0.1615056716330261f,-0.6553556910835086f,-0.3127083040751756f},
{0.15211606464944677f,-0.6368541735197394f,-0.30394006861068956f},
{0.13381079293179388f,-0.7471815998038444f,-0.34325836552301076f},
{0.13636697268634887f,-0.7544041126456575f,-0.36024763374702273f},
{0.14164088511449205f,-0.7599426198640592f,-0.3673480759312998f},
{0.15071478168078042f,-0.764557583408818f,-0.3680286979340379f},
{0.15490858127129117f,-0.7566976524403272f,-0.35707083359569713f},
{0.17790058111895884f,-0.7465955703430069f,-0.3300069613900003f},
{0.17603209475353493f,-0.7354854852758488f,-0.3418974466143249f},
{0.20402644178143656f,-0.7426392624570766f,-0.3298467152325752f},
{0.2011200222933106f,-0.733302342401683f,-0.3481607507522648f},
{0.2303096917867344f,-0.7470603418882839f,-0.33568982858182234f},
{0.22842175167187492f,-0.4148202465557537f,-0.20647605406444405f},
{0.2257641927143197f,-0.3831534064518972f,-0.20874051575731423f},
{0.2303665518528034f,-0.3589760739593583f,-0.20866566169014256f},
{0.23737483547147595f,-0.4107229019080372f,-0.20822650373479187f},
{0.2329377062454608f,-0.3228314154727158f,-0.21270979351780683f},
{0.2261520013129194f,-0.3190138739830787f,-0.21057593255479096f},
{0.22459667239881545f,-0.3464912905541998f,-0.21000809895254036f},
{0.2312851107089948f,-0.45874896734425535f,-0.2056011240474378f},
{0.25200357058904355f,-0.407934762406376f,-0.20435208199333718f},
{0.245527760453433f,-0.37256710012227207f,-0.20965522551000473f},
{0.23738093475472144f,-0.3132245811511519f,-0.2135556868669182f},
{0.22659359111975053f,-0.2741943550544989f,-0.2103220266495236f},
{0.2225611510900513f,-0.2551804063310308f,-0.21225967363865755f},
{0.21649341285722826f,-0.3247318378169521f,-0.22637729498221248f},
{0.2050008280433043f,-0.32590827385881005f,-0.24976133924842414f},
{0.19666571074576084f,-0.36374212464379974f,-0.26536233262501313f},
{0.19032576875793378f,-0.4428575934774161f,-0.27861659463503635f},
{0.183804871097213f,-0.5959562716748226f,-0.3000873890450963f},
{-0.007294013949931941f,0.06939510083248525f,0.3504830456767593f},
{-0.03581848760203997f,0.1058344765580643f,0.3302534506263359f},
{-0.04128740073434439f,0.06819694173810648f,0.35432723447912345f},
{-0.0007385986594169256f,0.02105243255641454f,0.3747546456144085f},
{-0.03322540723696977f,0.008197146113497141f,0.3829668423281667f},
{-0.06461161869187741f,0.05468510745345852f,0.36071414764111054f},
{-0.07004080308407254f,0.11293127149632469f,0.32412439446426694f},
{-0.0406608701629188f,0.13742228733205017f,0.3047139848929827f},
{-0.01643341751946674f,0.14132890959186226f,0.29739821814311124f},
{0.016488887956118463f,0.08762021919280302f,0.3326806912568536f},
{0.053483147595134305f,0.03409625495196047f,0.3565074397956906f},
{0.08012103995197377f,0.0031796617467656444f,0.3650850134295173f},
{5.6120630232262534e-05f,-0.02289833531899036f,0.38986308654385876f},
{-0.029991393237773972f,-0.035234463435946765f,0.39514051554185786f},
{-0.05723173775540026f,0.0038267265363711236f,0.38334624196893863f},
{-0.09618619823897943f,0.027537179666534996f,0.3675922151215565f},
{-0.10699930207615477f,0.04942437631903203f,0.3551191851340161f},
{-0.09429331899020452f,0.08222453145649528f,0.3405237830615328f},
{-0.10415662705671615f,0.12515554294444425f,0.30780670927733317f},
{-0.06852779518513794f,0.14911994341378013f,0.2926824427211235f},
{-0.049398007888355654f,0.16783187934387048f,0.27192031363039276f},
{-0.02019581154442698f,0.17409891147082085f,0.26072139108444864f},
{0.043341110464840744f,0.16986361104397119f,0.25227018236053195f},
{0.02477088380068131f,0.13201419810935935f,0.29538468336400503f},
{0.0819068497415103f,0.09269557716265567f,0.313604087032705f},
{0.1127268849503532f,0.051683954123192946f,0.33545817268335026f},
{0.1752921818956553f,0.031098344090335486f,0.333220600532188f},
{0.16882680779197667f,0.010565987249027107f,0.3439096448844042f},
{0.15828887076519138f,-0.021983220788923667f,0.35598222149557307f},
{0.1132044627593895f,-0.025173881112557465f,0.3672778422757002f},
{0.06652047974136002f,-0.02832498693096298f,0.3763785274549543f},
{0.02566991347648261f,-0.057100585104687976f,0.39139507223352943f},
{-0.0003973989539136394f,-0.07365791018479691f,0.39869709992558316f},
{-0.03852569712625572f,-0.060782926701055166f,0.39838872437182254f},
{-0.07112057595120534f,-0.03715271723289041f,0.3922328997825362f},
{-0.09403470236870119f,-0.012874552677374253f,0.3821888336509838f},
{-0.1265219688440208f,0.0021855189492360864f,0.3685688706865095f},
{-0.1519060213130831f,0.029121486816104138f,0.34869810706162824f},
{-0.12425173190228755f,0.07834036212337049f,0.3341779245246038f},
{-0.15155509207684256f,0.08706580167639548f,0.31731887137641057f},
{-0.12508448326677118f,0.15654898408450896f,0.2711137729290255f},
{-0.09162577446162953f,0.17029320414179533f,0.2645772323756888f},
{-0.06969472692671468f,0.20127528947652729f,0.22893511615683618f},
{-0.01743521815250125f,0.21301095957215888f,0.20596927703911772f},
{0.02402096624844122f,0.1951003362345957f,0.2227689373410194f},
{0.08201495717318051f,0.18202044509385087f,0.23063330598693857f},
{0.06691845133308404f,0.16303437926339437f,0.25659587988083477f},
{0.06320158998210715f,0.1546044675664661f,0.26621442724851996f},
{0.07008572699838f,0.14891641369970854f,0.2698811854471087f},
{0.0782785921396009f,0.1333734947213171f,0.28212622803035003f},
{0.08457916129393533f,0.1210845417608205f,0.29055310017852976f},
{0.10511984741248556f,0.11469446687318657f,0.29351242757566615f},
{0.11056254669445015f,0.1039091704980682f,0.3014009511255865f},
{0.11354260485521153f,0.0933999471672032f,0.3080000876847663f},
{0.13445225458260174f,0.0858652914735299f,0.3099525871351044f},
{0.16947709380206644f,0.060776006176571244f,0.31813357880662446f},
{0.20034643110780773f,0.04714574954281175f,0.3148944673747493f},
{0.20626638416442622f,-0.005214341628543256f,0.3362656047448714f},
{0.189815850192709f,-0.015950114925938494f,0.34578623635902167f},
{0.19759363153958684f,-0.047173582502656325f,0.34802417291606325f},
{0.12660790701188945f,-0.07577831575288073f,0.3738701900489648f},
{0.09160697834262926f,-0.06604552129878288f,0.37797606583140736f},
{0.0686422133192082f,-0.05198405139528682f,0.377987495214643f},
{0.04973813031233819f,-0.06006655998750065f,0.3826229855407269f},
{0.043323440498120674f,-0.0845841615163f,0.38832943924837104f},
{0.04671935269888838f,-0.11097454685012051f,0.39308381832059575f},
{0.016237905797148292f,-0.12365337585481781f,0.3974602766237221f},
{-0.01682957558105659f,-0.10388658583281238f,0.3997194496505069f},
{-0.04626305491831554f,-0.0950389970040732f,0.3985923358912956f},
{-0.08004978319765164f,-0.08458424332170146f,0.3940126304745756f},
{-0.11281900526927653f,-0.055761713282905453f,0.3858015684123601f},
{-0.13167670992554537f,-0.031060521309839908f,0.3753998458783049f},
{-0.1705154327645524f,-0.010233123195212523f,0.352394937775728f},
{-0.18189964773207679f,0.011533462548081337f,0.3392143962437416f},
{-0.16886544118963231f,0.047338174970438046f,0.3314920970200014f},
{0.34980686188265364f,-0.979361217518587f,0.0820908964899315f},
{0.3489429745324398f,-0.9785778989271626f,0.10047413406723586f},
{0.3516827649170093f,-0.9845132537098237f,0.08797351441123977f},
{0.34248189574354276f,-0.983226582233449f,0.07143302849494243f},
{0.34080129513716684f,-0.9984270414906729f,0.07995893511208249f},
{0.34812917971053564f,-0.990505670416038f,0.09743823362708887f},
{0.33924560181718355f,-0.9671889838674802f,0.08525154060566825f},
{0.338879312288805f,-0.9685747046865246f,0.07367103835812301f},
{0.32758823117725616f,-0.9683814686417382f,0.06155527699423416f},
{0.3405649380841291f,-0.9724567662025514f,0.05118091146132394f},
{0.34789492941218814f,-0.9800112804230364f,0.06085380842541972f},
{0.3480992697434198f,-0.987943026972358f,0.059650083376516706f},
{0.33765959269030044f,-0.9901211446575758f,0.06623806890330747f},
{0.33019488805174896f,-0.9983981854321059f,0.06320020725834052f},
{0.3408324608703158f,-0.9992350005064685f,0.09729098602923687f},
{0.3333332672869811f,-0.9978972643986365f,0.1058676789269879f},
{0.3388758275911834f,-0.9877969650216235f,0.10613676770228875f},
{0.345435752802858f,-0.9892483405186001f,0.11754182817348162f},
{0.3483775334725805f,-0.9799383312530708f,0.12375506528089895f},
{0.34133747642349077f,-0.9738643726225117f,0.12650323487587753f},
{-0.00796412767700695f,-0.5488004149152965f,-0.32752326547078964f},
{-0.03275636799951407f,-0.5491421436998899f,-0.3210266034570637f},
{-0.048794092792012404f,-0.5478710354355454f,-0.3358001033254279f},
{-0.002056373186879585f,-0.5488435369859557f,-0.3377402830947844f},
{0.05660864513565255f,-0.532629885959143f,-0.32605020729278916f},
{0.0633407218466875f,-0.5155401904495298f,-0.3178570977977716f},
{0.08863872459506099f,-0.49510242402530646f,-0.31008616579405424f},
{0.06648709570070079f,-0.5436783694341695f,-0.31632499099361044f},
{0.07435825207012728f,-0.5559579211479424f,-0.31117157792185024f},
{0.08409447066460142f,-0.5618743077015378f,-0.31139431703156073f},
{0.0734971004200278f,-0.5813253065632588f,-0.31415769499436025f},
{0.08736290348966486f,-0.5809054398089485f,-0.313959595246613f},
{0.06757146348161812f,-0.613197540906896f,-0.321608660575094f},
{0.03852908089513524f,-0.643336327292392f,-0.33253466967761613f},
{0.01730380255585569f,-0.6837130437372435f,-0.3295777326980555f},
{0.014223692139450624f,-0.7245736603800175f,-0.3258719660718536f},
{-0.034987423341160895f,-0.7472435264927663f,-0.32963451202113087f},
{-0.005570863910707209f,-0.7891932025093528f,-0.3356511240028432f},
{0.017916676937272905f,-0.8102836251754932f,-0.34147401441939934f},
{0.07461143872530633f,-0.7975018552283129f,-0.32562093822934746f},
{0.13523950408292862f,-0.8118510719130946f,-0.32238119891445577f},
{0.15898067779736855f,-0.8107817903230998f,-0.3189362682796753f},
{0.1685131435721306f,-0.8084824147223219f,-0.32158158829924255f},
{0.17829874500649673f,-0.8142013506593427f,-0.33256782211337255f},
{0.1820199728535788f,-0.8139585097314317f,-0.3425761233483602f},
{0.17881666881458078f,-0.8065691850519185f,-0.35299658994343286f},
{0.1574851666926807f,-0.7838592778511639f,-0.3262340803375332f},
{0.1394745314709707f,-0.7677822864659543f,-0.3453102394128088f},
{0.43063352866761595f,-0.3093968267352232f,0.06272399039371068f},
{0.43223254697815033f,-0.32768419581884534f,0.046080789827794094f},
{0.4328066211638854f,-0.24669602604801702f,0.07440534064035044f},
{0.42869553745835093f,-0.26268953024017916f,0.08105912851975927f},
{0.43644507150633777f,-0.16030957414100538f,0.1044712022912605f},
{0.43349826564766736f,-0.17062791147316292f,0.08774922418612455f},
{0.42738422555760536f,-0.23726135278748367f,0.05804963612747595f},
{0.42948067914158f,-0.2963213127146616f,0.04215269843092814f},
{0.4208836730064739f,-0.37035072406935615f,-0.01972418481274659f},
{0.4391511421293797f,-0.3998002160171493f,0.02075274962336726f},
{0.41327744502335856f,-0.3037305756015723f,0.07262558020089237f},
{0.42332915092948326f,-0.2554984678568084f,0.08590364864515469f},
{0.43198232975280426f,-0.17336871539478468f,0.10713866076480287f},
{0.43893675142025174f,-0.07443004268437459f,0.13057047726066437f},
{0.4376803532544646f,-0.07351954856587996f,0.11855033366221424f},
{0.4326324734002474f,-0.19113635776426666f,0.06958950233864086f},
{0.42804247537664997f,-0.27286974924480856f,0.03018044286457933f},
{0.425206918489548f,-0.30817548590239846f,0.009150475452541886f},
{0.4253845105793107f,-0.288495911062451f,0.03488258546953048f},
{0.42059381840809046f,-0.3476485979434126f,-0.019874623883664178f},
{0.4190179414645053f,-0.35383943843175664f,-0.04607235962181022f},
{0.41076537962835874f,-0.3729496806120316f,-0.06295290315521358f},
{0.40338602564615594f,-0.41009002238753023f,-0.07936653651641544f},
{0.4247363111381627f,-0.3961194956551024f,-0.018587146039760763f},
{0.4448990563018659f,-0.42637256949850794f,0.0018911926763741829f},
{0.44772140108542463f,-0.4428410581622387f,0.013479268829207284f},
{0.01171370906376103f,0.9753865395391885f,0.01961033294203985f},
{-0.009295382034781252f,0.9859278805206018f,0.03216698504841986f},
{0.007107595376071725f,0.9730619147543637f,0.06494484237073628f},
{-0.014271740595131423f,0.9806917090675528f,0.07242654872149448f},
{-0.053683933109828906f,0.9960065790219921f,0.05742901148107415f},
{-0.04233826548492755f,0.9967607674536342f,0.017833762913239584f},
{-0.013636856311084198f,0.9872619693824172f,-0.0013722457695676663f},
{0.3200139391729531f,-0.5212578302490206f,-0.18371023977742718f},
{0.3344628936406664f,-0.5327931312938198f,-0.17900814179360414f},
{0.3268069385975281f,-0.539906380804264f,-0.15284892683788578f},
{0.30719715332671504f,-0.5242515254764498f,-0.15861070118268022f},
{0.3209193262970982f,-0.5398040889929536f,-0.1272416582380056f},
{0.3452498526840097f,-0.550106053558329f,-0.13460103151649827f},
{0.3449461389757257f,-0.5451423897089179f,-0.16173011325125441f},
{0.36153750678933705f,-0.5427621202525602f,-0.17464562440577971f},
{0.34392889518274383f,-0.5181485493013366f,-0.20068552565223263f},
{0.3298001483045875f,-0.5083058434471047f,-0.2050848416594224f},
{0.3120123839311565f,-0.49316244717584196f,-0.2073417655688703f},
{0.29720437386985277f,-0.49949772838060014f,-0.18660916185362772f},
{0.28940365407591784f,-0.5110575083637829f,-0.14706423423178272f},
{0.30424785505931873f,-0.5247279686339436f,-0.1394650786974682f},
{0.3047146122447954f,-0.5275037873922153f,-0.11979290990237436f},
{0.3328562568037161f,-0.5416468002824639f,-0.1032089991291916f},
{0.3611732443350628f,-0.5495560120996967f,-0.10548160736516002f},
{0.38292110620308745f,-0.5536133156594074f,-0.1359942911813726f},
{0.37292188324284875f,-0.5524853498491313f,-0.15368707842127513f},
{0.38056953025690143f,-0.5413229029505779f,-0.1762934582304348f},
{0.3639714756485249f,-0.5293755162262797f,-0.19264084940218465f},
{0.3642029689986018f,-0.5087646166378783f,-0.20573559406654143f},
{0.3458439479449517f,-0.4917744570537125f,-0.2160334853603675f},
{0.3306463253165845f,-0.4862737205578237f,-0.2182313808294032f},
{0.30451701926557423f,-0.4658404948645865f,-0.2197152192594665f},
{0.28432288632548935f,-0.4753542771355764f,-0.19684982761309766f},
{0.2789606739969127f,-0.4891673943394356f,-0.1697617601319027f},
{0.28438381966310744f,-0.5144683155220673f,-0.1504295883966696f},
{0.29707752237716517f,-0.5241842495641974f,-0.11611108569861138f},
{-0.23160827922912214f,-0.836833607535566f,0.21574002494987188f},
{-0.2451841883912867f,-0.840543345442167f,0.21560362984781392f},
{-0.22515214488617977f,-0.8393014162083642f,0.23274451216578299f},
{-0.21413028747572388f,-0.8329401973792973f,0.22951103468253195f},
{-0.19504653112218845f,-0.8263087402496774f,0.24772701421085558f},
{-0.21175609817927102f,-0.8529294035390385f,0.24352478335195316f},
{-0.23710236823933462f,-0.8692164892561867f,0.22894342418592173f},
{-0.2564593631330824f,-0.8462113792961257f,0.20643760446333967f},
{-0.2661081232541097f,-0.8324689419591469f,0.18421079640501742f},
{-0.2545726192894186f,-0.8355991353421918f,0.19824428354916765f},
{-0.2462336921974633f,-0.8329935323762478f,0.19402712904773772f},
{-0.22738923045456433f,-0.8288169151072718f,0.21654782247968013f},
{-0.1977000380563508f,-0.8138690241838807f,0.24317594174706206f},
{-0.18085853269797936f,-0.8004213040858384f,0.24811101301504335f},
{-0.15755748904203767f,-0.8115106392660312f,0.2518875211277788f},
{-0.18666910237114606f,-0.8429467966369708f,0.2544058876635085f},
{-0.22547600078416105f,-0.8799245411465577f,0.2461170934713601f},
{-0.2541812027538913f,-0.88749478006506f,0.21730013682394297f},
{-0.25907544250245496f,-0.8706777547074801f,0.20048653560673935f},
{-0.2715778958743336f,-0.8416053314777207f,0.18059181043607858f},
{-0.284801842077457f,-0.7937083060942817f,0.136860610383067f},
{-0.27351398218639256f,-0.8153118079888859f,0.159313339462495f},
{-0.25456777577220624f,-0.8278779707699941f,0.17865302879540199f},
{-0.24819480458792884f,-0.8091558219136122f,0.19761924566071706f},
{-0.2402845176139908f,-0.8207874164152181f,0.20528841280739862f},
{-0.22501046005562853f,-0.8115456551650887f,0.22525257270298485f},
{-0.20520322416824105f,-0.8048790206504239f,0.23649806058330505f},
{-0.16866225569569168f,-0.7886598578518853f,0.24086552241708398f},
{-0.1515007446052476f,-0.7834363311766082f,0.24670413646924963f},
{-0.11953237935319863f,-0.7759178060207361f,0.2436898932123391f},
{-0.24040152164867412f,-0.9014396932075615f,0.2559961113621796f},
{-0.26047263307623164f,-0.8987110485433418f,0.2214374216309234f},
{-0.2735258567185012f,-0.8799981394476961f,0.17510119656181736f},
{-0.2769416688799853f,-0.8530052711432622f,0.15901222865334913f},
{-0.2855122316846642f,-0.8171770518856692f,0.13685426780843257f},
{-0.2906912987178476f,-0.8181523093219425f,0.11767676990165352f},
{-0.2940529865133772f,-0.7684367275529946f,0.10349371698580673f},
{-0.29127408677245226f,-0.7132773097257238f,0.11114461071813127f},
{-0.28389377981044267f,-0.7656438868967678f,0.12583654422677107f},
{-0.2795345261394151f,-0.7924357380816042f,0.1395611394869643f},
{-0.2654186067731741f,-0.8142707343886932f,0.1545693762364538f},
{-0.2606941982253105f,-0.8164148082780005f,0.1601399309864879f},
{-0.25898891576065886f,-0.7939574694110787f,0.1748984764024981f},
{-0.2512693118655363f,-0.796386047613031f,0.18806260479620532f},
{-0.2751583918706713f,0.043274711570236546f,-0.21600383993279668f},
{-0.27957845776482654f,0.014289180550560289f,-0.2100031959404905f},
{-0.28636201450877335f,0.02149921010058894f,-0.21635809131826372f},
{-0.28669109957800265f,0.03623732966401614f,-0.22748888696329833f},
{-0.30791947802327607f,-0.005561096664492683f,-0.22542521928438528f},
{-0.2996094877328814f,-0.0009644511552189506f,-0.2192445513508359f},
{-0.28989813266841874f,0.005969746517129544f,-0.218322405805873f},
{-0.27817764013078156f,-0.01972647961361936f,-0.2073264254624807f},
{-0.26950701444638075f,-0.010986937659305154f,-0.21432246908075744f},
{-0.26517558204871167f,0.014657495028227545f,-0.22727060465435686f},
{-0.26569729440305145f,0.027883285571311634f,-0.22790003984873908f},
{-0.26793979081441976f,0.05979402157403596f,-0.21878823019729118f},
{-0.3004362917384365f,0.014228388513181079f,-0.23576604991472694f},
{-0.33234556905523577f,-0.031541422330510445f,-0.2311095047906356f},
{-0.33950927549986937f,-0.04893864240522731f,-0.21275388769161344f},
{-0.31588972516927694f,-0.022976634774694596f,-0.21584572071581007f},
{-0.32367626075652123f,-0.07200762432291302f,-0.22900052754337963f},
{-0.3013421250738624f,-0.048160998133923764f,-0.23008387222557455f},
{-0.2992646375941379f,-0.06803761775066174f,-0.23308076955014745f},
{-0.2900324008300382f,-0.056902323870953425f,-0.2238347522943253f},
{-0.27863633151615363f,-0.043128599686335096f,-0.2056471018702941f},
{-0.27068466694518284f,-0.030704850547536796f,-0.2051361899537656f},
{-0.2616300212084381f,-0.016283576052943175f,-0.20699580096433262f},
{-0.2559249454437254f,0.007318668716808417f,-0.21809922048488167f},
{-0.25848282717559434f,0.0185555245336606f,-0.2304481346798489f},
{-0.0025047507172181057f,-0.4805737517874607f,0.2730797692082003f},
{-7.573905287857149e-05f,-0.4464133258100766f,0.26196421274081316f},
{-0.0066386889395923625f,-0.4688784468142175f,0.2594012240145946f},
{-0.007876266550999609f,-0.47947626327007187f,0.25336031582864205f},
{-0.004978347387773024f,-0.45314286017921873f,0.23576933275486434f},
{-0.00044888961090355664f,-0.4269908589725402f,0.2520383246045757f},
{-0.039844510688558016f,-0.8292555864798448f,-0.39590895936151427f},
{-0.001000055097000232f,-0.8399547215814542f,-0.3785286804417589f},
{0.003205232309175758f,-0.8535749278373174f,-0.39488531243665276f},
{-0.04048890989696452f,-0.8335646477562281f,-0.3997194496505069f},
{-0.038293318790471945f,-0.8416127885181492f,-0.39449405844952057f},
{0.008956735295248968f,-0.8613400240349264f,-0.38801616068256056f},
{0.055578518585549054f,-0.8663429172927753f,-0.38827748325675965f},
{0.04158563029350574f,-0.8605792391131828f,-0.3908929336807079f},
{0.018052070188764653f,-0.8541291838677375f,-0.39179621405016285f},
{0.060783427626338205f,-0.8547275340719643f,-0.3797301223762751f},
{0.024518240035893993f,-0.8377258632991615f,-0.36071228311540143f},
{-0.015446773196270457f,-0.8218471331476863f,-0.35476699906933445f},
{-0.02481378807773911f,-0.8255079142399279f,-0.36656386704212934f},
{-0.05418757496970364f,-0.8135493424861906f,-0.3777631125600482f},
{-0.07698069526229048f,-0.8113308586161768f,-0.3947764549450677f},
{-0.06809067386556174f,-0.8176632224490846f,-0.3995628103676016f},
{-0.07396537366145131f,-0.8212893116766509f,-0.39810401713928556f},
{-0.06096282899660385f,-0.8401607638899999f,-0.3769226098681721f},
{-0.021090780697572885f,-0.8571493033022533f,-0.38152351032073073f},
{0.05696120516788379f,-0.8718438152746513f,-0.37794743287848087f},
{0.11414465330103006f,-0.8687912732785458f,-0.3779418807352582f},
{0.0892634373867213f,-0.8643713295612888f,-0.38348496799373494f},
{-0.08506739399091275f,0.5184110564602453f,-0.3071683381708489f},
{-0.13538209089771167f,0.56638204561311f,-0.2916734049660773f},
{-0.11763444941768814f,0.5454622042075845f,-0.2930809295806361f},
{-0.13273307263655268f,0.5708650102993346f,-0.27541748391967025f},
{-0.14401315145280608f,0.5737517136232955f,-0.2739368475867507f},
{-0.16775021152420005f,0.5971912803841416f,-0.27703700882578136f},
{-0.1430808939102938f,0.5692724769260814f,-0.30239989600642386f},
{-0.11831410781654118f,0.5450636142945142f,-0.31997604574233807f},
{-0.08901880842646352f,0.5231033877290577f,-0.32075344672225276f},
{-0.038184516544092995f,0.4835144881103044f,-0.32837069824881976f},
{-0.03471673457969604f,0.4855888542358788f,-0.32168533985888575f},
{-0.0684894305766585f,0.5181309292677835f,-0.30738228373110393f},
{-0.10117419866412748f,0.5633685322303659f,-0.2863251548009588f},
{-0.10193206515161297f,0.5917326524218599f,-0.2739597042284063f},
{-0.1510688928284162f,0.6107910193535171f,-0.2501061883247598f},
{-0.17576003442358545f,0.6091006520321305f,-0.24415421854633534f},
{-0.12977465678531852f,0.6092024572606629f,-0.2528080443760136f},
{-0.14200019462354932f,0.6209053000173285f,-0.2332042372739556f},
{-0.1411364591976524f,0.653543426277059f,-0.21825519045086572f},
{-0.12489062996304635f,0.6777978821398547f,-0.20471484432778178f},
{-0.1588279704857734f,0.6793678021628413f,-0.1902124741201242f},
{-0.11813422623794478f,0.6960136385625381f,-0.20517078088969878f},
{-0.10910572104540084f,0.7059692539317477f,-0.1992599252311698f},
{-0.14639827398804656f,0.7152143383935115f,-0.18783068435818825f},
{-0.1717255067625367f,0.7159818101100203f,-0.17435670260145464f},
{-0.1864697372956954f,0.7251877862778364f,-0.15410957888454999f},
{-0.19075062139210325f,0.7530559702533121f,-0.1546249699124116f},
{-0.20977156075897072f,0.761112784512606f,-0.140175690347908f},
{-0.2279201623838919f,0.7642748320690615f,-0.11739013758616217f},
{-0.23724814652718335f,0.8077121966816201f,-0.11599993871819263f},
{-0.2465421474318098f,0.8249970735047226f,-0.09992250112170215f},
{-0.25810174574325684f,0.8380551204784562f,-0.06554419973756838f},
{0.08868436882186449f,-0.5957894598371226f,0.2385177350171536f},
{0.110990518557954f,-0.6023998419829867f,0.2384696897486962f},
{0.09092670162242994f,-0.5870118210010975f,0.23534079356558912f},
{0.08606231128373683f,-0.5895563089576874f,0.24149426810879654f},
{0.08792341179005554f,-0.5749180482916824f,0.23330411741953389f},
{0.10004463074287179f,-0.5735987927677304f,0.22983892348056553f},
{0.11702921906047437f,-0.5755864302940246f,0.2281259619322527f},
{0.12372807321683725f,-0.6066675649714264f,0.2352124430154795f},
{0.10974016018057497f,-0.6042931313211767f,0.23060647594006808f},
{0.09181762087699853f,-0.5970163124416733f,0.22743788395149384f},
{0.08000785633578045f,-0.592133542447842f,0.22449693408467997f},
{0.07306581596896786f,-0.5812902906642009f,0.23914751443166668f},
{0.08352862376495825f,-0.5774732357573414f,0.2451839041971971f},
{0.08777555649493538f,-0.5724974137129362f,0.23958922535298832f},
{0.09024377100751753f,-0.5621492471566565f,0.23111633394804765f},
{0.10223915200469827f,-0.5498369499093188f,0.22588610029225675f},
{0.11006188913811786f,-0.5476932000543938f,0.22029855445409402f},
{0.1197394543221371f,-0.5720375058706199f,0.213926798664353f},
{0.13189290354072947f,-0.5938434846331547f,0.22125857271271968f},
{0.13497874883450078f,-0.6063597174343479f,0.2273567064330284f},
{0.13124497820079684f,-0.6119852783488201f,0.23063320399578865f},
{0.12705916154258126f,-0.6147301342938347f,0.21918538161018475f},
{0.10838302131888229f,-0.6067234933058447f,0.2176453715543142f},
{0.09028125912955255f,-0.5947341202248376f,0.22074062978129497f},
{0.09116263371234311f,-0.6099942358054902f,0.2178175336777526f},
{0.066508636019078f,-0.5874417381333041f,0.22506188962416934f},
{0.06440752058962672f,-0.5781806856821343f,0.23609069730652776f},
{0.07460214796899506f,-0.5694179609269664f,0.24456111648849121f},
{0.09047178922164323f,-0.5487551860899472f,0.24350101410198746f},
{0.094124099736404f,-0.5644943392279691f,0.24324019829631444f},
{0.10461526744651325f,-0.548278418898071f,0.23080368432766155f},
{0.10687735890755613f,-0.5342811439241744f,0.2211932218834215f},
{0.10076788717108358f,-0.5242661155229246f,0.2109371150888199f},
{0.1021745618593931f,-0.5459741795943321f,0.20403666586301003f},
{0.11208906098389185f,-0.5672158508861427f,0.20280801991407374f},
{0.1274627968303482f,-0.5898045001713369f,0.20652557926698278f},
{0.13672561181607723f,-0.6112407047078715f,0.2119107916622696f},
{0.13806837417526527f,-0.6143422035183368f,0.21995520443518035f},
{0.13535148186625595f,-0.6188341253648197f,0.22164956322271465f},
{0.12408153523330043f,-0.6269305759347433f,0.21338083047726994f},
{0.11511078146697933f,-0.6159939480661458f,0.21508003278201665f},
{-0.037880077211273795f,-0.2517122132148107f,0.3310197876913021f},
{-0.049063199628246006f,-0.240572785506308f,0.3387528066098599f},
{-0.06303451572967772f,-0.23864918142362584f,0.33986202729671056f},
{-0.050279671446070914f,-0.24894709290320036f,0.3309288030863291f},
{-0.08262139336326026f,-0.22417594987501305f,0.34099611257598056f},
{-0.07278881013065598f,-0.2212299960674072f,0.3372567897990538f},
{-0.05900389560455953f,-0.2254022351537923f,0.34245405375323185f},
{-0.04349536145498579f,-0.22936202879975207f,0.33430090566563436f},
{-0.022233104949420754f,-0.2502212821501981f,0.3270466608273086f},
{0.0016959853338936299f,-0.27132775354873845f,0.3170303150403726f},
{-0.04494704398781991f,-0.2565601298579794f,0.3162265907821135f},
{-0.07951572460213506f,-0.23389528893417877f,0.3248250566655525f},
{-0.10203628204587754f,-0.21649596210477182f,0.336101629536028f},
{-0.10874665589014006f,-0.21278330576391263f,0.34390891501023774f},
{-0.09043478874479363f,-0.21567527756821064f,0.3437182329938301f},
{-0.09744607047831005f,-0.20332123619314532f,0.3438919345461873f},
{-0.08178244072438111f,-0.20672312656266814f,0.3389942090375942f},
{-0.06580149525495817f,-0.2088861676186334f,0.34367239647121267f},
{-0.06617734114160077f,-0.21630094333967778f,0.3452275628369214f},
{-0.04448744211895333f,-0.22178554823535743f,0.3407587419858907f},
{-0.027030255497726842f,-0.236329378907857f,0.32762379474754066f},
{0.0031096655393119455f,-0.24351525461629228f,0.32213053547782894f},
{0.039965117348130075f,-0.25720873407650363f,0.30930353776770714f},
{0.04384047188364319f,-0.27149570003798096f,0.307628043093273f},
{0.06446553655539466f,-0.27752345774004333f,0.29907968992389256f},
{0.02423318858322612f,-0.28032456605385886f,0.3063074914317912f},
{-0.00489272794224799f,-0.2782607368889584f,0.30437991500630207f},
{-0.04880028875436886f,-0.25857240780864454f,0.3119999022329835f},
{-0.09042524407301547f,-0.23156608410927854f,0.32358284376886387f},
{-0.10073383487591082f,-0.22177403917153593f,0.32982981551151835f},
{-0.1077359777774331f,-0.22581732001054322f,0.3376006455240858f},
{-0.11454031628057969f,-0.22963324026586018f,0.3401162976078572f},
{-0.12332772183161554f,-0.21742907063594114f,0.3392305257191351f},
{-0.12650164392017987f,-0.20814856443533578f,0.33317504767245626f},
{-0.10858120712166229f,-0.20644145887887969f,0.3418019234031814f},
{-0.12538366899296272f,-0.19657678774314605f,0.3466875512740254f},
{-0.10515765531927175f,-0.19229577190816957f,0.34760234070730184f},
{-0.04131438907997875f,-0.2161729571954475f,0.34677539540150776f},
{-0.011338597300916098f,-0.2310212303879897f,0.3388905594691009f},
{-0.0031528991627911896f,-0.23877789744202263f,0.33030881163498294f},
{0.054820879453335115f,-0.25195602730827704f,0.3099024138638007f},
{0.15143550426636176f,-0.2432187546570481f,0.2871713519987043f},
{0.10905120040133269f,-0.26770733864129315f,0.29082696553935083f},
{0.12915904032933997f,-0.2671563250795135f,0.28289852201591503f},
{0.15117286536888427f,-0.261857254834395f,0.2692277993310251f},
{0.07010092474212279f,-0.28024156544358897f,0.28763486671554034f},
{0.028171492906383558f,-0.2839522765157454f,0.298199166329759f},
{0.02503624458697176f,-0.2903642359418875f,0.2965470573760706f},
{-0.02434003281200843f,-0.27998267472087024f,0.3079071981825874f},
{-0.07345620940577269f,-0.2589366702629189f,0.3185535263039284f},
{-0.09930195243745879f,-0.24043110067575682f,0.32793881566216193f},
{-0.12436067969853655f,-0.23447669904585194f,0.33432333734416536f},
{-0.1321213084712984f,-0.22355052739493472f,0.3283517927018149f},
{-0.14771595927325304f,-0.21193968278029432f,0.3190741443782224f},
{-0.142730269585095f,-0.20457775547342294f,0.33036769771274843f},
{-0.12782806326000437f,-0.20106984424117166f,0.33846668106289457f},
{-0.14235872220045753f,-0.2026402094130311f,0.344561491571569f},
{-0.13911155665496375f,-0.19119358223621505f,0.3454154496583771f},
{-0.14678539414638433f,-0.17736911745452166f,0.34162504100183666f},
{-0.12549002345174412f,-0.1742927456512051f,0.3541935134575269f},
{-0.09414502810788178f,-0.17140612413264558f,0.37072402973892155f},
{-0.056534832228135996f,-0.17196880930664188f,0.37882098601496345f},
{-0.0330526767253522f,-0.15684267822472311f,0.3879670816913026f},
{-0.007346334347422683f,-0.13706227025939044f,0.39548694548101704f},
{0.05079985818279346f,-0.14050874138549752f,0.39123356924766334f},
{0.10695237552312294f,-0.12151181455998451f,0.3809224052930487f},
{0.14203565460907233f,-0.13829131142403261f,0.36785556370745204f},
{0.1889897749989126f,-0.14062951378068803f,0.34678572944228975f},
{0.21132727426470246f,-0.13924614300772273f,0.33357943302013804f},
{0.22397789634200554f,-0.14402686448163252f,0.3211097666157287f},
{0.2580314695913448f,-0.13841459641369722f,0.2845926183887199f},
{0.23205201509973236f,-0.16270021907204985f,0.29455791972994666f},
{0.2544410655797575f,-0.1568802874612486f,0.26947199801611915f},
{0.2596735079813884f,-0.15997724766554336f,0.25639279637804396f},
{0.2607686464526982f,-0.1804582965840053f,0.2587013118732239f},
{0.2348671461342513f,-0.190082881615283f,0.2692942848118659f},
{0.23767011897377596f,-0.20677483926289067f,0.25975047039686183f},
{0.22649174445731324f,-0.20766612398574646f,0.2759842837991203f},
{0.21766040728086583f,-0.20664871764436948f,0.2834641266865773f},
{0.20020802911739394f,-0.21881633194631198f,0.2808167594071573f},
{-0.4073435096175336f,-0.28395357371568314f,0.19993206709475683f},
{-0.40700761663904844f,-0.2775600948734213f,0.1917296466576797f},
{-0.40570935429345095f,-0.3168291098745925f,0.19235017568737847f},
{-0.4093206101831537f,-0.30534422433007824f,0.17533019750316858f},
{-0.41093401562027077f,-0.23539546082193538f,0.17701116251542387f},
{-0.4174148721929857f,-0.23254555611733974f,0.18184037546907184f},
{-0.42084411850124565f,-0.24993142861422238f,0.18985436194467034f},
{-0.4165603871519031f,-0.18521024380474962f,0.17325370337474783f},
{-0.28128126694409317f,0.325709496294879f,0.11362789654792675f},
{-0.28175452819019153f,0.35169776558410304f,0.11446026863282173f},
{-0.2795936555085694f,0.35994197901966724f,0.11600014163808461f},
{-0.28265353343061317f,0.36991429225244965f,0.12051005217363117f},
{-0.28259116053041045f,0.3986834054888935f,0.13272496699615527f},
{-0.2624138667541371f,0.38149895595139227f,0.13576439887986755f},
{-0.33670622191735106f,-0.5575446590865842f,0.09808515074200853f},
{-0.34581448525152436f,-0.5507794607496195f,0.11405488037216595f},
{-0.3453504839519106f,-0.5708753347784463f,0.09837366670654962f},
{-0.33610171081022555f,-0.5826437514700503f,0.08384705766467372f},
{-0.34195220045690766f,-0.6121640858331192f,0.07239277690198395f},
{-0.35510635815330444f,-0.6011076587348864f,0.08487319487344523f},
{-0.36392306597418805f,-0.5854539380586148f,0.09626697894812733f},
{-0.3565824962515503f,-0.5569258830297743f,0.11321912451839149f},
{-0.333074417998167f,-0.592117979235812f,0.08034002610609031f},
{-0.3376264423793596f,-0.6227007862172118f,0.06294717040266296f},
{-0.3469501907027068f,-0.663651861573092f,0.04794233442057793f},
{-0.358820494428245f,-0.6661311803721195f,0.05767884411479237f},
{-0.3572244338610577f,-0.6351103500869115f,0.06944527729101246f},
{-0.3685498031223134f,-0.6519416425189914f,0.06399485324185077f},
{-0.37203250554201445f,-0.6244236972146789f,0.08129944197948685f},
{-0.3794363788340977f,-0.6471467357759831f,0.07478949243126305f},
{-0.3779631581077021f,-0.5806807554305351f,0.08007732877618319f},
{0.1560380057674923f,-0.5940008941617232f,-0.2936494919946453f},
{0.03318110483123212f,0.4166035129409895f,-0.3417709191560197f},
{0.07030018888883148f,0.39894197217722976f,-0.3367480451944607f},
{0.03577892141032591f,0.4066074517063977f,-0.33567888578136434f},
{0.005679657657823693f,0.42081060644044505f,-0.33985606931370393f},
{0.03518719213157996f,0.4017308415530573f,-0.32959807780764483f},
{0.06263777015656817f,0.3926662665529067f,-0.32814431083068474f},
{0.08469401714002389f,0.38920844891137324f,-0.3311664977108015f},
{0.12241922291499087f,0.38378463392825723f,-0.32868531438606485f},
{0.11581448321701346f,0.39559981993653714f,-0.33490168665893383f},
{0.09073608016326747f,0.41255536946142923f,-0.34081284616609686f},
{0.05011953577905823f,0.4281557551407501f,-0.34614993148752476f},
{0.013838742480271582f,0.4445854181110112f,-0.34769614175538294f},
{-0.00025043289413170566f,0.4337054484509985f,-0.3439913482947363f},
{-0.02589536703815141f,0.43777904403449786f,-0.34149800677500547f},
{-0.01955037117636522f,0.42777593053685353f,-0.337262463056767f},
{0.0018577592337516735f,0.4153767410794326f,-0.33297038224443426f},
{-0.0039319543116683444f,0.4144236125354642f,-0.3189730679614484f},
{0.02901686355085168f,0.4021007772650449f,-0.3180661403459768f},
{0.06303271176121396f,0.3907444462529399f,-0.3179645369749284f},
{0.08860256342038249f,0.3850391271968384f,-0.32267186306759155f},
{0.13180282091998843f,0.3779593530941253f,-0.3205113346061004f},
{0.16177175591903611f,0.3761395813140801f,-0.31761133843560246f},
{0.18127841857563037f,0.38359861269491835f,-0.31967464170863624f},
{0.16457647110737153f,0.3911906554089352f,-0.32516548825020813f},
{0.06866234594723528f,0.4350871979896435f,-0.3304485097629267f},
{0.01670762072597194f,0.4482472934832984f,-0.3440901543460172f},
{-0.04662101835667572f,0.4848050904955813f,-0.3422970490020395f},
{0.36692354892512474f,-0.6234225032165048f,0.09843764490495542f},
{0.35695314165195596f,-0.6217932912759688f,0.1049459689692277f},
{0.3819580887672101f,-0.6275897171139417f,0.09864464975497829f},
{0.36397098906574726f,-0.6042984816069152f,0.09337484034580293f},
{0.3814427795447501f,-0.6037079124774996f,0.08994936877249707f},
{0.3948360703657959f,-0.618459649984254f,0.09863045067457821f},
{0.4045795239574659f,-0.6292053111111503f,0.10698370327346315f},
{0.38805101456442714f,-0.6406341057728512f,0.10309197597116768f},
{0.3682988549603932f,-0.6372254074940725f,0.10019064329164294f},
{0.3508981087541501f,-0.6230836918037616f,0.10204257415614093f},
{0.3414182077306753f,-0.5993335205575666f,0.11208979138926213f},
{0.3499458715703356f,-0.6038233356493594f,0.10225970056538351f},
{0.35360799023401174f,-0.5739231756199863f,0.09093987388568021f},
{0.3681530766725445f,-0.5871998693085405f,0.08615358751965405f},
{0.38083968781446065f,-0.5917935963835562f,0.0796178947677509f},
{0.3926250445986184f,-0.6067510521644739f,0.08433787095022512f},
{0.4038358820481679f,-0.614634488905793f,0.0956325599987016f},
{0.41553110627841744f,-0.6156828580604269f,0.11472354072535486f},
{0.42027360975612593f,-0.6346828648061853f,0.11659801588361192f},
{0.4068057474683863f,-0.6382692369801282f,0.105733943031682f},
{0.4097174970565022f,-0.6430087019714957f,0.10109976902887648f},
{0.38208530466577706f,-0.6437605701044777f,0.08943879151442918f},
{0.354656317954741f,-0.6329999948967241f,0.0694161758162411f},
{0.34149050883187615f,-0.6211075644036967f,0.09210413685883456f},
{0.3243349960959355f,-0.5926847185580169f,0.10521626782702577f},
{0.32010070814373026f,-0.5626634620990707f,0.12420162928110329f},
{0.333135533007521f,-0.5733071554490393f,0.12154361348818912f},
{0.34054876823723873f,-0.5732839737105934f,0.10309123653533091f},
{0.34427378463057645f,-0.5392686375807962f,0.09195785711449882f},
{0.35523181045490454f,-0.5543562680660357f,0.07841373306923737f},
{0.3656631391074415f,-0.5731643359669455f,0.07650990570796545f},
{0.3776381250618656f,-0.5778392809319235f,0.07546748922429902f},
{0.39586822930204274f,-0.5972173295612707f,0.08079678284683772f},
{0.40528158428743133f,-0.6081951331694169f,0.09098443976855511f},
{0.4002687203322718f,-0.594810311863444f,0.09513988006262548f},
{0.412881651367648f,-0.601512935442722f,0.11487045366474624f},
{0.4246035834678698f,-0.6036913771623221f,0.12739612914656764f},
{0.43322612244990855f,-0.6245337711632082f,0.1238796315343842f},
{0.4290800228453165f,-0.6342942859619225f,0.10665501448234753f},
{0.1048386663114747f,0.750369960014566f,-0.11261159404826586f},
{0.11540195238864119f,0.7552001259480209f,-0.11337814465720221f},
{0.1338571872185123f,0.7316452985637102f,-0.10231873856746607f},
{0.10381516068685213f,0.7359164255067776f,-0.10599828390647346f},
{0.12785970388944518f,0.7238046991677567f,-0.10131848586261283f},
{0.14300464065203444f,0.7164898652119437f,-0.09934469894695662f},
{0.15508765329513524f,0.7392150912709318f,-0.09921575982291944f},
{0.1246831980250834f,0.7610627737896974f,-0.10751661128132003f},
{0.09405898263682434f,0.780994024540916f,-0.12149386518000996f},
{0.0852798744907959f,0.7708917798952005f,-0.12032340730690703f},
{0.0839393824971009f,0.7519999825722622f,-0.11071282374817648f},
{0.18240735648905376f,0.7033648663603403f,-0.10389964069999952f},
{0.16454115135967975f,0.7132205410267264f,-0.09781088910307376f},
{0.18209979261486112f,0.7294970897832006f,-0.09878930826499377f},
{0.16346341937795267f,0.7460893903908706f,-0.09470886333833398f},
{0.1471371021275509f,0.753048189178501f,-0.09467583307947589f},
{0.128743713243608f,0.7596341741913829f,-0.0925036935630133f},
{0.10945073160772385f,0.7750230865334258f,-0.10695786657789642f},
{0.09620781823794267f,0.7913817859739207f,-0.11808844974136874f},
{0.07897102705479449f,0.8081574942917134f,-0.1270529204278929f},
{0.07508381817292115f,0.7955523230829921f,-0.12691042498018157f},
{-0.4412835858403751f,0.05407394992306463f,0.13188139394570408f},
{-0.4501757564881063f,0.07294418780428506f,0.13616984663536075f},
{-0.45320126551744944f,0.05538404642927391f,0.12176296989142796f},
{-0.4415545136435975f,0.027132065507094606f,0.13988673879616423f},
{-0.4429468001429166f,0.0035714830596691584f,0.13842839177912894f},
{-0.4582576159491474f,0.07251135223782039f,0.11002324670999564f},
{-0.45628882341261284f,0.08475296961827755f,0.1289183576828979f},
{-0.45650187761271416f,0.1042437662766155f,0.12852888216644207f},
{-0.44397381065090913f,0.08990249321504006f,0.1447190316700576f},
{-0.4366298380360513f,0.06955445562975657f,0.14693112090745433f},
{-0.42329559477875833f,0.05629575700471272f,0.14403138927650144f},
{-0.4187900560513559f,0.02706722144632247f,0.1585809941354563f},
{-0.41782574141554074f,-0.013340944394563731f,0.17325617559772505f},
{-0.4316767515188112f,-0.022378527861856578f,0.15911227134732256f},
{-0.43850703720793693f,-0.0364371611364961f,0.1267805700606109f},
{-0.44813458104496956f,0.0053308697045269865f,0.11175965347389169f},
{-0.4553841661626343f,0.03370970211939395f,0.05297516208092243f},
{-0.46805262075505266f,0.14545478520135544f,0.07148417918143271f},
{-0.464360066232394f,0.11594369166143073f,0.10310548236167469f},
{-0.46447767690193764f,0.14414258087804824f,0.09708222289428606f},
{-0.4556311409193397f,0.13103375293574282f,0.12155449573140184f},
{-0.44602021420288607f,0.12150100349809506f,0.13503628937277307f},
{-0.42655956974064496f,0.10005580249221313f,0.15287358851041308f},
{-0.43160797654913663f,0.09160992280587865f,0.14685735049625034f},
{-0.4214241910414842f,0.08124619409997674f,0.14174872003855857f},
{-0.42685611007138596f,0.07348725774285848f,0.1483279470753517f},
{-0.3821370184284074f,0.050804585366350484f,0.16161173233604745f},
{-0.3896865892653457f,0.047285975687437865f,0.16064875527166692f},
{-0.40265146307401467f,0.011282515448568916f,0.17431237576033734f},
{-0.4039196539665089f,-0.020970840698902708f,0.18291371014486724f},
{-0.4177127097236645f,-0.03327746468852718f,0.17432468694205644f},
{-0.42687690139225615f,-0.04502691421347334f,0.15977359152494214f},
{-0.43174451401384134f,-0.04300863790830466f,0.142204828710541f},
{-0.4433468891134088f,-0.06714690141598509f,0.05863210439732935f},
{-0.44448944390775175f,-0.043135083561208404f,0.07933582230658628f},
{-0.4509399049929809f,-0.006943576077304165f,-0.0008773422139421599f},
{-0.4563051164988093f,0.03723171575293451f,0.015779898071202808f},
{-0.46600273250545415f,0.12489235690694386f,0.03815222306505217f},
{-0.4690004000756903f,0.1973797725655683f,0.030748278591645573f},
{-0.46722464066405023f,0.20572781830376932f,0.046341236977956564f},
{-0.21207008537109173f,-0.5644737508269909f,-0.28692076930507115f},
{-0.2183010689385916f,-0.5417978874221465f,-0.28470637889235484f},
{-0.20473545344571228f,-0.5626835639172711f,-0.28858912991105135f},
{-0.19959243497197932f,-0.592745348047001f,-0.2892909873211248f},
{-0.18630220620790713f,-0.5737247529002643f,-0.29737848073079004f},
{-0.22075590879923535f,-0.48060293081800226f,-0.2857721747223202f},
{-0.22577918860057833f,-0.5061406956364494f,-0.2808851487227963f},
{-0.22620225638962452f,-0.5404656620236324f,-0.2904470793158012f},
{-0.21660433885682215f,-0.5744417676825838f,-0.2964230414498317f},
{-0.1920130975929797f,-0.6150334432247425f,-0.293560493029872f},
{-0.1519825677958984f,-0.6479229213613616f,-0.30788928386207065f},
{-0.14731888966576095f,-0.617840711379049f,-0.31520910369774285f},
{-0.16254877230732306f,-0.5794984825201611f,-0.3184221755141593f},
{-0.19267015220323627f,-0.5358562102505994f,-0.3001667020378526f},
{-0.21236502571566868f,-0.4673275343293858f,-0.2983585200646225f},
{-0.23759838626075436f,-0.4141802340292007f,-0.2785795718476228f},
{-0.24347282789154567f,-0.4143287267690077f,-0.27233551853922644f},
{-0.23489223383231098f,-0.46306791751254767f,-0.2768687988594015f},
{-0.2430114199293997f,-0.4687087165422595f,-0.27861744562369334f},
{-0.22654933545995645f,-0.5800861332153187f,-0.29925770697677995f},
{-0.1974672868154252f,-0.6416382192676912f,-0.31516290170683836f},
{-0.19859227363419785f,-0.6249635257470196f,-0.3083505292758215f},
{-0.2025866784018392f,-0.6036466349197503f,-0.2986452936803528f},
{-0.17540919655441659f,-0.6532626807632509f,-0.302061854839344f},
{-0.1377506983035231f,-0.6889281402065369f,-0.3125547043410189f},
{-0.11071140065291298f,-0.6709507275394988f,-0.32148071480236057f},
{-0.11605758974687727f,-0.6435867878091269f,-0.32674537790809727f},
{-0.13772378857606685f,-0.6088377390334377f,-0.33117853372889744f},
{-0.15655698348412533f,-0.5718055259377653f,-0.3256653968090334f},
{-0.1819580174796459f,-0.5387328621342563f,-0.31478141549712463f},
{-0.1990396992471373f,-0.48518984998376213f,-0.3049521246663281f},
{-0.2173799560540214f,-0.424405520373192f,-0.2891227975404934f},
{-0.2306856874728784f,-0.3852084813764312f,-0.28132864342683334f},
{-0.24258794736297734f,-0.35674235303651264f,-0.2742945039892534f},
{-0.2549025946563939f,-0.35422380270423154f,-0.26231315527444643f},
{-0.2505514662803083f,-0.42292966487542394f,-0.27200209778371853f},
{-0.243677148037029f,-0.5244222278515553f,-0.2839713701089328f},
{-0.24128786086316756f,-0.594070439377061f,-0.2902567606428651f},
{-0.2213417364025886f,-0.683381689364929f,-0.3124032124239602f},
{-0.19364823564428785f,-0.7130284704433093f,-0.3282194081892452f},
{-0.17388787000231828f,-0.7254334946444306f,-0.338509902999888f},
{-0.16506861877713405f,-0.7062070197375435f,-0.33491802011662714f},
{-0.1638088580906237f,-0.6891755218654341f,-0.32435104535953924f},
{-0.15063887370505977f,-0.698407070189272f,-0.313251131784768f},
{-0.1411983242669212f,-0.7068721592712452f,-0.3139569615376484f},
{-0.10162634455497313f,-0.7559433524558647f,-0.32684061745635506f},
{-0.07799508224066729f,-0.7130446817241043f,-0.32568748426743355f},
{-0.06860350024096651f,-0.6739744134770375f,-0.33430767320339333f},
{-0.07805893826217479f,-0.6540691810931214f,-0.3443920045909999f},
{-0.1113938861189523f,-0.6323946742348463f,-0.33953906275888307f},
{-0.09809121443459244f,-0.6337434338861301f,-0.3434731620719228f},
{-0.1449297554786244f,-0.5746794219355592f,-0.3235173102054222f},
{-0.16681295960256606f,-0.5390875607934119f,-0.31490202534392003f},
{-0.24821974886093398f,-0.9198812293511116f,0.2438496527869866f},
{-0.2644479081288199f,-0.9294666646545372f,0.2266275738272115f},
{-0.23724693113264703f,-0.9198886863915401f,0.24832824141543586f},
{-0.23685383280555417f,-0.910652112878754f,0.2549368610267407f},
{-0.20363885735088505f,-0.9011127159554301f,0.2573298761896125f},
{-0.22149734196269327f,-0.9232656112399016f,0.2687457838445603f},
{-0.252845715763396f,-0.9407412933187177f,0.25541883614170857f},
{-0.27564168330891764f,-0.9510724369146346f,0.23621236106187213f},
{-0.2855453023150192f,-0.947081437164029f,0.20628220076071915f},
{-0.2773963687992097f,-0.9339300555392437f,0.20351756703188648f},
{-0.2842684379251522f,-0.931085339634399f,0.20229321746013967f},
{-0.29131329705754966f,-0.9242309797842656f,0.22066879507712348f},
{-0.28098815075372846f,-0.9192105780456841f,0.23918309765649576f},
{-0.26586876702382023f,-0.9191601614829914f,0.24478989432420203f},
{-0.20709807312109832f,-0.8861427779451357f,0.2689907325895693f},
{-0.18991075614491407f,-0.8864005340163117f,0.27107932435573906f},
{-0.17031581377363486f,-0.886476725654918f,0.26059277705720174f},
{-0.1732016151133639f,-0.8950917682874391f,0.25699426687401306f},
{-0.17685128129508199f,-0.9171438304465255f,0.28725765563486f},
{-0.1976719522434472f,-0.9143156498568584f,0.2743514862322208f},
{-0.20675924258501457f,-0.9287026383265607f,0.2910013555319699f},
{-0.22976682476805288f,-0.9393212046693808f,0.27929022493196726f},
{-0.2530179788155765f,-0.9491447808085596f,0.2670967951826142f},
{-0.28244716602527714f,-0.9580696151844539f,0.24116117138767118f},
{-0.2869019641556045f,-0.9669636492954864f,0.23091734390255436f},
{-0.2935572319690947f,-0.9609260037639229f,0.21566144183128205f},
{-0.2993875783636716f,-0.9636906374927555f,0.19752633597278976f},
{-0.30269972077091395f,-0.9708735947669328f,0.18682227661097425f},
{-0.2913101969515558f,-0.945611418534777f,0.18790718090783637f},
{-0.2853994018502721f,-0.9379484516000832f,0.19325231078121263f},
{-0.3066092604025763f,-0.932067404979928f,0.20523365949601968f},
{-0.3052124342346789f,-0.9220142807593751f,0.21555489507668688f},
{-0.2945971911034932f,-0.9167314207326439f,0.2300274583707863f},
{-0.27118064353269794f,-0.9118128242225947f,0.2406443631077891f},
{-0.18772006486324785f,-0.1655198079697456f,0.33783592954523395f},
{-0.20687280016875748f,-0.15234621670966175f,0.3259651806708228f},
{-0.2072095855698042f,-0.17220208643943422f,0.3337647052559698f},
{-0.19175303184722156f,-0.1759989587850996f,0.33806345161491164f},
{-0.22210558105882916f,-0.18951192878369796f,0.32182605152388166f},
{-0.22848465152635203f,-0.18526795485947567f,0.31939723003054044f},
{-0.23475905995073731f,-0.13660390290840085f,0.3043962686497438f},
{-0.22892662592481092f,-0.12868342425632756f,0.3073013101949383f},
{-0.2150274685619332f,-0.13083155123143564f,0.30814424367588694f},
{-0.19015429719957286f,-0.15220785509074478f,0.32589048808963844f},
{-0.16590191834404847f,-0.16841412982012258f,0.3359239567032716f},
{-0.17047151070081126f,-0.17380106437847173f,0.3414091299871304f},
{-0.17702265192470082f,-0.17722370463496007f,0.33940339646858375f},
{-0.19906816965166865f,-0.1788717201313509f,0.321921169957649f},
{-0.21460040824433155f,-0.18585220160000543f,0.3119918778667837f},
{-0.24106378311961463f,-0.20051364294204865f,0.288563922160909f},
{-0.24546470017537625f,-0.20244559648772104f,0.3022282618996677f},
{-0.2458928951445205f,-0.19774763127028452f,0.3098225346076808f},
{-0.24388416244872219f,-0.19309967890057222f,0.3090704221209022f},
{-0.2405049077400302f,-0.1820293916300312f,0.30164648738211525f},
{-0.2397493912986236f,-0.16278727170571258f,0.2981320519034938f},
{-0.24928418693371626f,-0.14214022156671086f,0.2816860767236956f},
{-0.2438614874788023f,-0.10624821321930254f,0.2905133013195048f},
{-0.19898703356710787f,-0.10148256731223736f,0.3390588512408822f},
{-0.19365809478877816f,-0.1264460550250573f,0.3339158327671492f},
{-0.15824665174117195f,-0.1495152802341318f,0.3514927315005705f},
{-0.14968473162403928f,-0.18772068796542932f,0.33977793240639487f},
{-0.15435669759751383f,-0.19373385562101694f,0.3448018613389106f},
{-0.175935751363561f,-0.1854863179114108f,0.3333751734319f},
{-0.20158053889530264f,-0.184700730016901f,0.3134845310944586f},
{-0.22229954591537424f,-0.1918165739272208f,0.29875988604930415f},
{-0.23968369518678673f,-0.20609113840231502f,0.27221709725252263f},
{-0.25803276785369034f,-0.19775841258475518f,0.2663338418865275f},
{-0.26395728076463554f,-0.1970644169924865f,0.29120202843143644f},
{-0.25392320445373423f,-0.19830375182641385f,0.30452042481381375f},
{-0.2607896406934604f,-0.18949385297719384f,0.30478016652518947f},
{-0.25924134279425265f,-0.18264297994949774f,0.301937760294927f},
{-0.24835373335966782f,-0.18449079717094977f,0.29741592848132814f},
{-0.24829239524467345f,-0.169766942557207f,0.28688265330001966f},
{-0.2538785025826594f,-0.14945043617335968f,0.2799183225549148f},
{-0.2504149288156036f,-0.12963241897150155f,0.28339356793418735f},
{-0.2531472621597446f,-0.12485493996623231f,0.28913167395775813f},
{-0.25674830512315583f,-0.1274810495277529f,0.29379095478196393f},
{0.251655762706953f,-0.9922947226742149f,0.20706799157512093f},
{0.2629223659425259f,-0.9974227665098455f,0.20669618071334617f},
{0.26155407179881296f,-0.9840512380504095f,0.21285602757860667f},
{0.22631648329028875f,-0.9771493811342494f,0.19169884639281784f},
{0.24424662093453275f,-0.964578678684563f,0.20176457501964581f},
{0.2782978643235415f,-0.9813389661529721f,0.22187809882944443f},
{0.2699874278218659f,-0.994865958872274f,0.21673224372685493f},
{0.2826001973712547f,-0.9968931509037964f,0.21688140578358314f},
{0.27159319454681863f,-0.9991442188213874f,0.19868386646764288f},
{0.23079043025900978f,-0.9979363323210869f,0.18738382713342794f},
{0.22029117762545522f,-0.9934382506341133f,0.18553937349510696f},
{0.21186991817774348f,-0.9709431399822707f,0.1809754140245605f},
{0.2202133041952834f,-0.950009640261921f,0.18321998744320023f},
{0.23840373069092594f,-0.9481140816206456f,0.18966004224391625f},
{0.25605834136853173f,-0.9481041927287367f,0.19419991799178485f},
{0.2702023869191731f,-0.9560396672670686f,0.2156401044327968f},
{0.283683906459329f,-0.9558563201141911f,0.2165914502564575f},
{0.2926837181417012f,-0.9781350129828015f,0.22491274775318956f},
{0.21799877248232818f,0.08315618023933162f,0.28417465653161555f},
{0.24809650318035847f,0.08892618187021792f,0.26279409666661374f},
{0.2341613174437787f,0.08961207235329299f,0.2739296540234593f},
{0.21446788243152293f,0.08933421446391644f,0.28553656772919733f},
{0.2510215456150114f,0.09120683465813466f,0.2802390783469023f},
{0.2591027984411921f,0.09504504529174375f,0.2546985385192517f},
{0.2675770667266565f,0.08450348120469027f,0.2480064519006478f},
{0.25857512810384575f,0.05341618668679782f,0.27216218245515633f},
{0.22594429739855657f,0.04456365234969636f,0.3023932092116586f},
{0.18973744980826282f,0.08409390918207298f,0.29524767950227115f},
{0.18172880193191682f,0.09293841809056674f,0.29433872587510307f},
{0.1951157512407361f,0.09344760784403285f,0.29686894781960077f},
{0.22139660976605036f,0.08915175867119285f,0.29739388139442485f},
{0.24658986866588478f,0.0913395219569307f,0.30067544558003795f},
{0.2739785497493698f,0.0976576197777464f,0.29148778851011464f},
{0.27233025059009336f,0.09746462702434877f,0.259157591592864f},
{0.2772564454408099f,0.09318207069804571f,0.25216000854566845f},
{0.2712564293315203f,0.0721778911108157f,0.2520262673383235f},
{0.2779480708012513f,0.045461583495820544f,0.25983339026413804f},
{0.28085361805256404f,0.032080247949877065f,0.2617152916529972f},
{0.2740000496962503f,0.010376803227633591f,0.2773050596286504f},
{0.2510603309369842f,0.015124211842207351f,0.2985196182731124f},
{0.2255631755947222f,0.00396095432649375f,0.3226274448594025f},
{0.23029905283491042f,-0.02946259727935137f,0.32861795773081864f},
{-0.3353408855169852f,-0.9183296687975149f,0.09839549068781253f},
{-0.3542338589253708f,-0.9355229533183761f,0.11749120444126582f},
{-0.3358140458343415f,-0.9297576539044633f,0.10284287321161592f},
{-0.31957484283725546f,-0.9078354413529086f,0.09230013410152296f},
{-0.33114343761804993f,-0.9371200667317047f,0.11013404415824443f},
{-0.3473023151477353f,-0.9485154677910755f,0.12291012491159445f},
{-0.3748035424027268f,-0.9600019735075025f,0.1506952073480582f},
{-0.38219367663699233f,-0.9444445462880378f,0.14443461872448438f},
{-0.36164741818947105f,-0.927121411097237f,0.11900968905246848f},
{-0.3532470106198747f,-0.9070646060532686f,0.10589840376089517f},
{-0.3359849511293389f,-0.8864180424970445f,0.09443875677634976f},
{-0.31844963291284234f,-0.8883257593333141f,0.08554020636971076f},
{-0.31089566583238026f,-0.88322332908761f,0.09382128854355579f},
{-0.3185699399734115f,-0.9189737344098687f,0.1042993557029421f},
{-0.32289051031361626f,-0.9350612627557524f,0.1207844189909393f},
{-0.333362184965201f,-0.9504309657021566f,0.13825259303375192f},
{-0.3431172485494347f,-0.9534467090788967f,0.1309013450502013f},
{-0.35623847797812325f,-0.9625137148681199f,0.14368475641745032f},
{-0.3682533839060629f,-0.9771386816251804f,0.16731177335014163f},
{-0.3849961628937393f,-0.9702207749142127f,0.16422468185200748f},
{-0.39587459206242537f,-0.961085196012799f,0.16075856468065103f},
{-0.3953457881359442f,-0.9376151530214736f,0.14628243594593637f},
{-0.3889162394860756f,-0.9261390217173258f,0.13308517636462894f},
{-0.37230744499713303f,-0.91507983873323f,0.1143777089217936f},
{-0.33702302555228f,-0.8652613160217989f,0.08803868781843346f},
{-0.320302456199902f,-0.8406545529798312f,0.0862002729061128f},
{-0.3130825781294611f,-0.8688601704251185f,0.08249453708973743f},
{-0.3070724903941189f,-0.8430771338896879f,0.08682463935282654f},
{-0.30504768984258007f,-0.8509944518785222f,0.10417871504632019f},
{-0.3102204143011291f,-0.8887185527493652f,0.1247517111112323f},
{-0.3147627325245563f,-0.9148305128680377f,0.11831638721250069f},
{-0.3324430173493336f,-0.9483256357009172f,0.16292780701101178f},
{-0.3494223361241914f,-0.9704504855439818f,0.1813824128954584f},
{-0.3559261311439634f,-0.9737538131536128f,0.1676444748555611f},
{-0.3471130918172527f,-0.9617582791697071f,0.1446220795204077f},
{-0.36317843177599424f,-0.9840530218331249f,0.19025648755093713f},
{-0.38005657320533587f,-0.9898823557530576f,0.18067017044902803f},
{-0.3828648952681912f,-0.9841711998284398f,0.1763092647338536f},
{-0.3919682948994036f,-0.9808244271761752f,0.1686283537312242f},
{-0.3965502696192089f,-0.9660681510632504f,0.15231185525381585f},
{-0.4003574770680641f,-0.9445006371708512f,0.1471230395665545f},
{-0.4001120821117744f,-0.9269408208926304f,0.13056411450028155f},
{-0.3271273916032893f,0.006287645494512076f,0.17812431517358474f},
{-0.32945542140515f,0.01693223126704231f,0.17266085431816872f},
{-0.322459762378501f,0.016885542693360123f,0.17721096424048507f},
{-0.3464095728013622f,0.05334015653417886f,0.17026507264535587f},
{-0.32800546316019397f,0.047707301127673254f,0.167134434113438f},
{-0.3282234214347529f,0.05663651262375085f,0.16080928509197767f},
{-0.35116672688279044f,0.09199923152430807f,0.1568817004636378f},
{-0.3675587200592808f,0.1289927814749059f,0.1476410643033807f},
{-0.3793258597366955f,0.16390450825950065f,0.13100701000631293f},
{-0.3531488526373588f,0.14732529757847582f,0.14148181557371806f},
{-0.3449498478413955f,0.1631919502779503f,0.14254359868937952f},
{-0.34372017879373673f,0.1919677110000704f,0.13875065725261654f},
{-0.3334556407307434f,0.1868284013920073f,0.1299455413633637f},
{-0.3256204319920252f,0.19159955800839057f,0.13044324011394112f},
{-0.31653062905598384f,0.1826291697103565f,0.12797184475237147f},
{-0.31144485630235547f,0.19299079059916055f,0.1316274274831915f},
{-0.30398521722424904f,0.19135331206344372f,0.13091522540825795f},
{-0.3001747673067532f,0.2525336775587055f,0.12539357222737726f},
{-0.2928020193763222f,0.28351268297319193f,0.12478025269708702f},
{-0.2863417108330886f,0.31675637318618904f,0.11756781148132638f},
{-0.2862795004812811f,0.36008042138157786f,0.11308419235188988f},
{-0.2891218057828014f,0.370509156696647f,0.11828606290633835f},
{-0.2877506133905788f,0.38123714785682333f,0.118398258483267f},
{-0.2821128740953639f,0.38024648975691533f,0.12050824926757511f},
{-0.2876762862776816f,0.3930700845748171f,0.1262535945379732f},
{-0.30055031678161653f,0.397856237077459f,0.13130025793524625f},
{-0.2982518112928361f,0.4139737561334523f,0.12884488580828893f},
{-0.27815557285812986f,0.4244006258604046f,0.12944676745608105f},
{-0.26089513353950655f,0.41186656160650387f,0.132464800321655f},
{-0.23787300168149034f,0.4876684495327012f,-0.24730949750262426f},
{-0.19230593968212897f,0.4710034016125499f,-0.2674025147168462f},
{-0.22477953403132298f,0.4764526272657003f,-0.2515520116785136f},
{-0.21574156597240238f,0.39759151054863195f,-0.2491904660974249f},
{-0.19587982006502477f,0.41889591914652435f,-0.26544500920090053f},
{-0.15007500288394585f,0.43850821701181153f,-0.28474254962870366f},
{-0.1428550940036785f,0.47135048068288177f,-0.2871365783286276f},
{-0.17896901278270425f,0.49535484043482203f,-0.2718486605979571f},
{-0.23116417789022473f,0.5301165339882833f,-0.24209634630203378f},
{-0.24844877105044147f,0.524607247234328f,-0.23515645306140806f},
{-0.3968431627039332f,-0.2492124685632002f,-0.16873399956399526f},
{-0.39840712474391304f,-0.2701702846735383f,-0.16700288146618467f},
{-0.39832197594504837f,-0.25285493055754876f,-0.16530761007034034f},
{-0.3956470699927477f,-0.22147843057244557f,-0.16915283259550504f},
{-0.412270860367949f,-0.208798628402193f,-0.1560405996361639f},
{-0.4123355429427338f,-0.2823710503488295f,-0.1544618255064768f},
{-0.40617615185042444f,-0.30656767298000087f,-0.15960439776892893f},
{-0.40495926888077655f,-0.2873556255711933f,-0.1682299975478725f},
{-0.41127485304471034f,-0.2829345461399859f,-0.17535943815336327f},
{-0.40305868398814515f,-0.24346094751619413f,-0.17512056744344362f},
{-0.39853377331670875f,-0.196826114670746f,-0.1778287469459912f},
{-0.3941049128106902f,-0.1974290034811434f,-0.17057745985101253f},
{-0.3944365497834826f,-0.1641874210852442f,-0.17138691792423008f},
{-0.40400638256578925f,-0.14674724255067123f,-0.1628942497978792f},
{-0.41973722767472543f,-0.12521636472924233f,-0.15378843850093477f},
{-0.4297849623004508f,-0.20575451554966345f,-0.1481260375331926f},
{-0.44103981211840554f,-0.24036593258060215f,-0.13932120530682543f},
{-0.42678368785569476f,-0.2615124450671484f,-0.14282311712216542f},
{-0.4343801480613916f,-0.33063849802703354f,-0.1278702211955746f},
{-0.4252211037586464f,-0.36891636940792694f,-0.14017240750777063f},
{-0.41719869770114215f,-0.36168818437080835f,-0.15050671282933434f},
{-0.4071476802352794f,-0.31656357272860536f,-0.16174924296630744f},
{-0.41549536156760103f,-0.31456134515583656f,-0.1695478145716476f},
{-0.4235595924958267f,-0.34537726672163355f,-0.1688273140292988f},
{-0.41267451584146436f,-0.2914913900725955f,-0.182143197817202f},
{-0.4009953414060224f,-0.22427305394898f,-0.18291443895662587f},
{-0.3950975969222947f,-0.142050898567555f,-0.18051581003087838f},
{-0.2521474450420941f,-0.5827466924125334f,-0.28453630440026595f},
{-0.2595020969802726f,-0.5563212104366615f,-0.2824963666622296f},
{-0.25522002829915497f,-0.5480063978772106f,-0.27750437370852615f},
{-0.26022995363430795f,-0.4987782817468003f,-0.271026577932716f},
{-0.26504086873821925f,-0.5076982534821416f,-0.27652084861466425f},
{-0.2681630770641532f,-0.5265935365651093f,-0.2880490984588187f},
{-0.2538263840426529f,-0.6009747281447014f,-0.300403545673668f},
{-0.2533554324711366f,-0.5969440113404726f,-0.2916979444617063f},
{-0.247340704138474f,-0.6231161143653515f,-0.2972146680703418f},
{-0.23992430824551714f,-0.6368222375409271f,-0.2977857027073284f},
{-0.2342493039339077f,-0.6685325237498252f,-0.3094287265921699f},
{-0.22794778179976632f,-0.7086850413366333f,-0.31853520720603556f},
{-0.2243482995134301f,-0.7250603164638025f,-0.31866169323043614f},
{-0.2157649293825841f,-0.7363270004423692f,-0.320994748221245f},
{-0.2063228405155268f,-0.7784598610634379f,-0.32676839709814803f},
{-0.1811964113166641f,-0.7915115452767887f,-0.34219840549915376f},
{-0.14716563521414308f,-0.7963555713825516f,-0.36303536847130763f},
{-0.14433937864502253f,-0.7570599696258988f,-0.3531067446349557f},
{-0.11490401034667488f,-0.787876053740091f,-0.37037224951402403f},
{-0.11945945993065167f,-0.7551428504804979f,-0.34622993292054294f},
{-0.1477760819937111f,-0.7071843839285069f,-0.32381385159857096f},
{-0.10465750346905765f,-0.7574733514429279f,-0.33116459281359556f},
{0.3249986769437121f,-0.45141605864434603f,-0.22889254122619998f},
{0.2925003306173269f,-0.4377277658590702f,-0.22626223727863976f},
{0.2729428657440046f,-0.4337641634811064f,-0.2147221330881251f},
{0.26206103262069064f,-0.4340141374150635f,-0.20135710975171867f},
{0.27029645144439157f,-0.47315670676333105f,-0.18139929243076683f},
{0.2793100223703298f,-0.5469356576012908f,-0.16847328468706432f},
{0.2901716527467012f,-0.5466313755048278f,-0.13857316609159587f},
{0.2936111937866541f,-0.5518062694001278f,-0.12250789731417776f},
{0.2945246254627475f,-0.5595256501896099f,-0.10589434005101638f},
{0.2998619742613126f,-0.5297877633917661f,-0.1012288388290745f},
{0.3116303091475152f,-0.5286004652924439f,-0.0910738381986656f},
{0.3420591923603759f,-0.5395011040964285f,-0.08626339905345383f},
{0.36642789637199213f,-0.5462455525464277f,-0.09078919152337382f},
{0.3874558250234392f,-0.5445427433671611f,-0.0903835206622402f},
{0.3823450463771528f,-0.5494958691934902f,-0.10573651618340138f},
{0.40598368498889353f,-0.5475604309501964f,-0.1238330800113097f},
{0.4001442592571601f,-0.5485488197470191f,-0.1484189720518215f},
{0.4064737046558098f,-0.5371851931804729f,-0.16068233160814013f},
{0.39384857399153467f,-0.5290352461276113f,-0.17930233101585838f},
{0.37700099059807385f,-0.5264880033475663f,-0.19161213691687815f},
{0.37214679193751626f,-0.49339783212573224f,-0.20770300866014452f},
{0.3444543758975909f,-0.4548453453241028f,-0.22525818434104497f},
{0.31999343151496856f,-0.4068881759720497f,-0.23574270562788585f},
{0.29691808683690013f,-0.4018099006303467f,-0.23658867971999092f},
{0.26845688169477977f,-0.39682240697372484f,-0.22616172818763713f},
{0.2547598761030422f,-0.38912734257423126f,-0.21489974536363626f},
{-0.14172603497576441f,-0.4545412257760349f,0.24022500312200487f},
{-0.15186773319796612f,-0.4643660991151514f,0.2463081409560549f},
{-0.14282778906051627f,-0.4928677299369054f,0.2300824337253978f},
{-0.13272561559612406f,-0.46923411757652067f,0.23327001412878617f},
{-0.1301945628487179f,-0.5075497607423346f,0.22853448004632101f},
{-0.13351727302646077f,-0.4120157332249025f,0.2545027091369976f},
{-0.13214132848409754f,-0.4255005770391004f,0.24908568293979677f},
{-0.12338140104869709f,-0.4335947572435309f,0.24818894806486821f},
{-0.12364320914326607f,-0.4742978028717488f,0.23714737449024736f},
{-0.12343860533489708f,-0.5425469996692657f,0.22997793316824752f},
{-0.03985312256627766f,-0.33031687106064067f,0.2599043952278088f},
{-0.025683198886164764f,-0.32515575659465523f,0.2684835699102074f},
{-0.03870871068308036f,-0.32339410170912f,0.26547119117900597f},
{-0.06983685796854668f,-0.32630333764035413f,0.25823566915354146f},
{-0.05777953434632687f,-0.31839201800602335f,0.2638387782037342f},
{-0.018400320032504705f,-0.31419140838144116f,0.2662703959544352f},
{0.0014870299031289195f,-0.3193956438556779f,0.2689857881436148f},
{-0.012865350632115262f,-0.3258004702757739f,0.2776199190572843f},
{-0.03556378382850625f,-0.34286341860632596f,0.286605505099061f},
{-0.04458499134179326f,-0.3424596005844155f,0.2736743499895121f},
{-0.053016387222434215f,-0.3452978326143867f,0.257668606859362f},
{-0.07295454787405846f,-0.35650048314934124f,0.2547784995807731f},
{-0.1015961615490497f,-0.33568175853208654f,0.2576576236874072f},
{-0.115097732974239f,-0.31247806224150054f,0.2593222966758738f},
{-0.10090853934124192f,-0.30727026026424076f,0.2659405417019504f},
{-0.05173854010534157f,-0.3098121538209551f,0.2685010167712871f},
{0.0013061273506257394f,-0.3096801963963256f,0.2675295489436774f},
{0.0246828282540446f,-0.3182556823988028f,0.26666237875332605f},
{0.021698514087590524f,-0.33008181120754077f,0.2781636168788743f},
{0.0024046389667370122f,-0.326502572039644f,0.27889929497921756f},
{-0.021765724130558772f,-0.3364511351458014f,0.2861438952794309f},
{-0.008820584546987512f,-0.33787949145272705f,0.282640968864631f},
{-0.03043220748690264f,-0.35688744182169174f,0.2953725453547592f},
{-0.0440378895655754f,-0.3682763568813739f,0.2976842629470829f},
{-0.053065594765037284f,-0.359877085025728f,0.2807981364606303f},
{-0.0600165742311756f,-0.3644599500432793f,0.2569667483868808f},
{-0.05885243343491952f,-0.388509701168964f,0.25393143120862227f},
{-0.07603786038760725f,-0.3850162184972001f,0.24808063771330605f},
{-0.06918752387585587f,-0.4384757445170545f,0.23734946570414225f},
{-0.13511997895450867f,-0.3586521766274724f,0.26225645669436465f},
{-0.14351605933708897f,-0.316866719111118f,0.26486015582551037f},
{-0.1775858651153794f,-0.28754626721610416f,0.2605609430695393f},
{-0.1306683106775939f,-0.2948996028310043f,0.2689930018926545f},
{-0.07954752353033961f,-0.2979910512635732f,0.2701365096668043f},
{-0.006075157026570416f,-0.3036895624104189f,0.2744962509830174f},
{0.02490173738359482f,-0.3105734253254763f,0.26470307033132434f},
{0.0438204763062238f,-0.3083025806864749f,0.2717353654289435f},
{0.03290363684552235f,-0.31917014886010453f,0.2780750641253817f},
{0.03790904907229233f,-0.33108349178849256f,0.28950436555560854f},
{0.031483564132302584f,-0.34759980261504025f,0.2876108329260296f},
{0.02886220565851479f,-0.3534335136551561f,0.28158992562953555f},
{0.016623972046937132f,-0.33720138310687087f,0.2774350515988287f},
{0.25181357701289764f,-0.8928450774900312f,-0.16420408282695123f},
{0.25005581266476795f,-0.8705136987556431f,-0.15848040430146f},
{0.23992783331463557f,-0.8984516712378454f,-0.18346705356697743f},
{0.2299420859350774f,-0.9135568102038176f,-0.19251223537493778f},
{0.24818282700226255f,-0.9119172238510029f,-0.1905456313984948f},
{0.24473664060144898f,-0.9270084208392655f,-0.2009025107612363f},
{0.2503493941897541f,-0.9311163024476561f,-0.19946195588781945f},
{0.26222944444455454f,-0.9276573490921722f,-0.19573438546610306f},
{0.27991672097513903f,-0.9219280376804646f,-0.17732346791567907f},
{0.32548277899911865f,-0.8988729966780808f,-0.1389838727657558f},
{0.3455602542494667f,-0.9063770953982812f,-0.14706656409211324f},
{0.35900890607915964f,-0.9156619776566618f,-0.14178356276514303f},
{-0.19672262180740482f,-0.5904660732020156f,0.319485134715268f},
{-0.19007731512955478f,-0.5932404332743622f,0.3250149291272078f},
{-0.19091838514720225f,-0.5930543302356219f,0.3158470498411026f},
{-0.20116553584395322f,-0.5882182477530651f,0.31122106169048436f},
{-0.1041747889182529f,0.26880309437154143f,-0.29461475961026734f},
{-0.13470427683881925f,0.24596771362103048f,-0.2879343647896285f},
{-0.11619772452443153f,0.3272681080491204f,-0.2916264337919173f},
{-0.06577140574092215f,0.2832942391782632f,-0.2998264319391843f},
{-0.07402980657040042f,0.40526631058152984f,-0.3035052070325284f},
{-0.10677249925656544f,0.4200067005104501f,-0.297877821963844f},
{-0.1582522952514664f,0.3486026699055174f,-0.27898608519815093f},
{-0.18285528887051922f,0.3104159042440875f,-0.26633102438101147f},
{-0.07377382896990073f,0.22769428651511803f,-0.3019876084694405f},
{-0.020778686716472157f,0.23212347105551911f,-0.3034978307350935f},
{-0.03326903501374716f,0.3089817121310535f,-0.3017633288684034f},
{-0.045204309226586976f,0.37982638077362413f,-0.3041313997582701f},
{-0.04000803012445022f,0.4245847028874484f,-0.3089399637536946f},
{-0.07415711914807824f,0.437512372236968f,-0.30549786974777077f},
{-0.08158984318668938f,0.4457870225939225f,-0.30610278563227233f},
{-0.10644233584340758f,0.45573035759123964f,-0.3001537332256982f},
{-0.21216844627349962f,0.33359982275085553f,-0.24919024405419232f},
{-0.2093073363537166f,0.22600193355353176f,-0.24939302370834907f},
{0.3583247993787999f,-0.4108106036728727f,0.23658148721910732f},
{0.3659867931479385f,-0.3954836977003374f,0.23405246048339748f},
{0.3593886499400624f,-0.39621935561493227f,0.2414384205173718f},
{0.3477893961946451f,-0.40137868629820234f,0.24450368803424302f},
{0.3430562535921635f,-0.3912359150441111f,0.2450494331156857f},
{0.35145171671580533f,-0.3828092458158234f,0.24299918046020785f},
{0.3628065890419851f,-0.3820551073173482f,0.23446705875737078f},
{0.3671200274385517f,-0.3918219445049485f,0.22444197891581685f},
{0.36554131386610983f,-0.40752689236107265f,0.22504111955145542f},
{0.3525589315767081f,-0.421328012855925f,0.22950345546520504f},
{0.3418740624871909f,-0.4104179717428091f,0.23757246829099002f},
{0.33229827172187765f,-0.4009017576203388f,0.2364256171194576f},
{0.3315356233368328f,-0.3897396347561678f,0.23374193780344993f},
{0.3364462762236757f,-0.3779131819130474f,0.23496023908752608f},
{0.3460904361188794f,-0.3713297094946397f,0.25116315023377284f},
{0.35984061415917257f,-0.3744590922605244f,0.24782419902781622f},
{0.36763424238096604f,-0.3717591411064765f,0.2371781343836124f},
{0.36641363035989993f,-0.36782731109652206f,0.22514827400331872f},
{0.3579634957302805f,-0.3793861189765574f,0.22239496766657177f},
{0.35970484694013116f,-0.38770984832476985f,0.21307148282036184f},
{0.3620882770597279f,-0.40519282383321165f,0.2146949492594534f},
{0.356023153412529f,-0.4124741823812935f,0.21183966558410833f},
{0.3573212139006423f,-0.42054955796746135f,0.20564400176430028f},
{0.35718540524769626f,-0.4281382774698439f,0.22086419843384525f},
{0.35089567796507765f,-0.4323487759863351f,0.22711461450262443f},
{0.3383298392183519f,-0.4314346346218237f,0.23207882549205833f},
{0.33131263987332565f,-0.4212516586689236f,0.2325634948732361f},
{0.3300416123519748f,-0.4103333498982189f,0.22678818439051596f},
{0.33134567013218374f,-0.4050093151943469f,0.21761311154111937f},
{0.33190961213462106f,-0.3879974314952525f,0.22600239463852198f},
{0.33831460004070435f,-0.376117645779997f,0.2244731648347143f},
{0.33245519466766854f,-0.3662125277164735f,0.23480878754196421f},
{0.3345427739591941f,-0.3681434262911891f,0.24300740774629975f},
{0.3461181978974005f,-0.3561119043050783f,0.253049711343293f},
{0.3568096730386893f,-0.3605370368220864f,0.2530747374216996f},
{0.3644698437160235f,-0.35835470456508073f,0.24735314652755785f},
{0.3689442167102769f,-0.35430113005678826f,0.2354922047396542f},
{0.3638199422975614f,-0.35383911439737414f,0.2234419386925259f},
{0.3587507452306075f,-0.36896824465654465f,0.21810426585957826f},
{0.34580686460029275f,-0.3764655344050813f,0.21791309726039293f},
{0.3508293337844757f,-0.38839557519704193f,0.21017195304689312f},
{0.35706236354942045f,-0.40128044757269277f,0.20844316587182085f},
{0.3486461101673162f,-0.4058435358688338f,0.20470417669094695f},
{0.34651026250169287f,-0.4117488999413854f,0.19723948161406576f},
{0.3401402894322594f,-0.42877877657917457f,0.1862050707929097f},
{0.34751867131131464f,-0.43256324743845687f,0.19711729090444693f},
{0.3544582192694017f,-0.4320039662190885f,0.20340656241411445f},
{0.35328583525093643f,-0.4378177379893988f,0.2122906768234114f},
{0.3420497900512446f,-0.44295485903737036f,0.21933484751554702f},
{0.3313581927330574f,-0.4390120065463721f,0.2241338880873497f},
{0.32699887744237666f,-0.4327718841468781f,0.2263830096738303f},
{0.32345522149930905f,-0.42194743698149983f,0.21929391506738732f},
{0.3237155709079529f,-0.42136205665183524f,0.20813038345045834f},
{0.3306266686472569f,-0.4172733036960899f,0.19824991643538398f},
{0.34197546293834735f,-0.39764317331568744f,0.21048656918413824f},
{0.34500498468199436f,-0.3605667024354056f,0.21831529404798308f},
{0.3324781341771335f,-0.3557964371791762f,0.23341311727376568f},
{0.33525845117007885f,-0.3475427396290793f,0.24064112063914855f},
{0.3437737953287574f,-0.3455980616250491f,0.24900476889846856f},
{0.35432496464483443f,-0.3469630325571278f,0.2504298837991616f},
{0.3641925127809215f,-0.34563194287256416f,0.23901985232181888f},
{0.3582494587288506f,-0.34446993432878575f,0.22696012340831398f},
{0.3515936852092424f,-0.3526550587666924f,0.21809372889890427f},
{-0.4975034906457773f,-0.6674069897910296f,-0.026594451032633016f},
{-0.4894479725240134f,-0.6171702226220165f,-0.01191215781247436f},
{-0.4924226612756957f,-0.6446421274214118f,-0.023024700228900394f},
{-0.4889044563741592f,-0.6953532309932285f,-0.042272883314598955f},
{-0.4836569777147728f,-0.6488605684987014f,-0.030091185734707804f},
{-0.476042401331075f,-0.6084762324650262f,-0.014501337016060946f},
{-0.4819914537376492f,-0.580227169977105f,0.0022426733022689487f},
{-0.48392474485475623f,-0.595557317355873f,0.004798386659794714f},
{-0.49555086795613307f,-0.6579235222645319f,-0.007741321104400406f},
{-0.5016184638263094f,-0.7053698806287987f,-0.024229273079236953f},
{-0.5009816533969f,-0.7076797942526585f,-0.03334390448583209f},
{-0.4965576151599377f,-0.7090681094715782f,-0.04071200225727238f},
{-0.47195778326653187f,-0.5875202001374035f,-0.010932594437341393f},
{-0.4680527418695432f,-0.564564046991702f,0.0010809027378402764f},
{-0.47580337019757585f,-0.5692205103103919f,0.002218016941780715f},
{-0.46788414731153566f,-0.5247834103855843f,0.018639303888856294f},
{-0.4730783717169651f,-0.5370707431741684f,0.020332925365369434f},
{-0.4672433645393193f,-0.539044601271148f,0.03495433305626144f},
{-0.46864229746190683f,-0.5980314484175572f,0.03616317678600005f},
{-0.4823823836903989f,-0.6645317976557057f,0.032293771734231036f},
{-0.4980784158201693f,-0.7123803517451549f,0.0030648653955145906f},
{-0.4996882547542634f,-0.7467944807079143f,0.015170073862612257f},
{-0.49571395180482264f,-0.7474310882174315f,-0.043345842960436906f},
{0.1994067568963637f,0.6759242494709923f,-0.0269270409852323f},
{0.2100592044866987f,0.6690501128994488f,-0.04461375975171581f},
{0.20829329359547072f,0.6907997978592778f,-0.03146660332279656f},
{0.1900682963496434f,0.6925675732762149f,-0.017757940992551714f},
{0.19727253046506063f,0.7087914372293193f,-0.02398005876686499f},
{0.2095866922381073f,0.7071435024759221f,-0.03418007042902179f},
{0.22037762256184984f,0.6941616875122917f,-0.05406541347629963f},
{0.20782511809556573f,0.6614528813856806f,-0.04772243300213184f},
{0.18730467615786286f,0.6552142591060165f,-0.0326703857417214f},
{0.18503583734480958f,0.671159617100979f,-0.021009255240549245f},
{0.16007826724349938f,0.6874600370985691f,-0.011566806217243883f},
{0.1780393889491567f,0.7055732180470562f,-0.01490175002093568f},
{0.18568663012342534f,0.7208373059705159f,-0.023485038346380223f},
{0.2071735146997898f,0.720189673855139f,-0.04003251490607695f},
{0.2197401438779272f,0.7084338211983131f,-0.052487530706766344f},
{0.22203346056695644f,0.7117520618263933f,-0.07573579712985846f},
{0.22263043282825185f,0.6864712031528734f,-0.06858245553583339f},
{0.22001180049290825f,0.6708015144871955f,-0.06893907821553559f},
{0.2116364593732154f,0.6535071131780635f,-0.04271601255034886f},
{0.21766247366405908f,0.63293435084287f,-0.02584537384497169f},
{0.16133849432703898f,0.6662110702523174f,-0.018344508031741705f},
{0.13514393943788042f,0.7012060398761631f,-0.015166405368439323f},
{0.1548160572373994f,0.7050100462902823f,-0.012078351328828016f},
{0.15282720325416116f,0.7285918237735461f,-0.02409829306979396f},
{0.18771278949455503f,0.7320654075470017f,-0.03552062404236984f},
{0.20523303108179927f,0.7318503677067006f,-0.05285639338686432f},
{0.21784756316574727f,0.7213877522065242f,-0.06452681358193982f},
{0.2120910371155415f,0.731888991542686f,-0.07752147518082632f},
{0.21018883205099764f,0.7287970968988363f,-0.0877977252275331f},
{0.21862703159126312f,0.7054458396000941f,-0.09295415872470128f},
{0.22268808332573262f,0.6989334125168539f,-0.08150297169355847f},
{0.2160225834626103f,0.6849992796264153f,-0.09239468414711118f},
{0.24188086078165597f,0.6661460232716533f,-0.08545674679926635f},
{0.24667057872491316f,0.6484703386726994f,-0.05742906672628037f},
{0.23772081919935423f,0.6406096778300422f,-0.04197859210119479f},
{0.2652443368326379f,0.6190445139837221f,-0.03991757937940255f},
{0.25790964435001307f,0.5934489584299633f,-0.017193020512520103f},
{0.29970028854130293f,0.2700797154700195f,0.22133472504223695f},
{0.29570580409307584f,0.2752657943947585f,0.2097040813956223f},
{0.2955387489639871f,0.27958061073425644f,0.21975807785298837f},
{0.2934333169715979f,0.27728407069992717f,0.2300294440109859f},
{0.2875654218977408f,0.2851393005138523f,0.22227950518562287f},
{0.2835874100826302f,0.2874947669974438f,0.21416961940651563f},
{0.2839249657293403f,0.2787833501651223f,0.2020876309245451f},
{0.29166189430864414f,0.26296638415417384f,0.19851262651418483f},
{0.3000318054620127f,0.26026035390262886f,0.21211910327390054f},
{0.31350049855266093f,0.25346484082117193f,0.22373880412005723f},
{0.3122313344946114f,0.2662847883930569f,0.2263777815649901f},
{0.3083055432106572f,0.2780795474863461f,0.23142799234194567f},
{0.30238240824264345f,0.2804965348190755f,0.23762912649957488f},
{0.2941562291796787f,0.2761259526935544f,0.24442005954095655f},
{0.2852480310477039f,0.2723803882707353f,0.23462373841177284f},
{0.276232170632932f,0.2810896165429654f,0.22918784703906403f},
{0.2721688081614725f,0.2863622625809973f,0.21215241719564434f},
{0.27013176760953794f,0.2758587135702533f,0.19981320915844256f},
{0.27693516269454804f,0.2669431996980887f,0.195375310749172f},
{0.2753589415308318f,0.256054395054716f,0.18704577640467776f},
{0.29205578306714874f,0.2580556505243374f,0.17512626194931302f},
{0.29852707478233714f,0.2604365680494601f,0.19002665474426955f},
{0.3119482899302992f,0.25701036128994875f,0.19606733026291137f},
{0.321008649296254f,0.25138666490118566f,0.21378902455695578f},
{0.3335815392436243f,0.2374145976774312f,0.2306557174797212f},
{0.3209583134765551f,0.24889745721024917f,0.23818988659061685f},
{0.3217498593540716f,0.2607347699860183f,0.2367945201710524f},
{0.3172125461338441f,0.27171913927443914f,0.24108988276111476f},
{0.3102933230995981f,0.27416830587736973f,0.2489391960259378f},
{0.2974810556737821f,0.2699858528022853f,0.2547250030978351f},
{0.2655259428967732f,0.27657572835257277f,0.2271572096190091f},
{0.2610487736451601f,0.27079178580638447f,0.22259199332002166f},
{0.2630205037392933f,0.27771520428907803f,0.20845155464390008f},
{0.2598088704230537f,0.27919551658761504f,0.19723498231698428f},
{0.2644484340206867f,0.2754823736639783f,0.1918595685089425f},
{0.2636161989863993f,0.25895050068780834f,0.18089203838433313f},
{0.26166718423368285f,0.24508242831508606f,0.17381675401703126f},
{0.2764358830811471f,0.24964778591431233f,0.16279041855765009f},
{0.3086895027057559f,0.26042838113486505f,0.16892016315998085f},
{0.33699566855113505f,0.25598047271919505f,0.1760147196049825f},
{0.33796898071870546f,0.24596763287803677f,0.1949563969746686f},
{0.3414293523886175f,0.23630835598208386f,0.21171561034878042f},
{0.3552604635935794f,0.2131348118875948f,0.22468115241196274f},
{0.34484595391910555f,0.21198074696702263f,0.2543727766616567f},
{0.3350284983113285f,0.22677714597335494f,0.24863045606629786f},
{0.32963155374657993f,0.2387562253850767f,0.24057193982969005f},
{0.3324751753713786f,0.24662361339399605f,0.24906179151293278f},
{0.32223015267747396f,0.2584978065945319f,0.24681514214942946f},
{0.315265963232608f,0.2619471143494956f,0.25601291015449434f},
{0.30496981428759273f,0.2611526914716258f,0.25854420619328944f},
{-0.34661705361008455f,0.03136955449403577f,0.1680971275149329f},
{-0.3719345908508874f,0.0652935416129806f,0.16705416920328262f},
{-0.3910582469921897f,0.09280516346599943f,0.15927049149305125f},
{-0.3569204566756365f,0.08390059239429289f,0.16174748999341854f},
{-0.3584022892797518f,0.09175533562544029f,0.1547380419757847f},
{-0.37464852435414187f,0.12381934732793878f,0.14981646647423227f},
{-0.3957620065818299f,0.1750156472352077f,0.1327352107322733f},
{-0.41566115986824886f,0.21410536816930228f,0.11500851143502913f},
{-0.4088789396333289f,0.2273277547577585f,0.10672330818128346f},
{-0.3852812749036525f,0.1912332695424197f,0.12499249521762036f},
{-0.37162358158816217f,0.20088906067834322f,0.13045146740003302f},
{-0.36309863220046024f,0.21463790114720172f,0.13717759675213942f},
{-0.36088558042158636f,0.23971616290070866f,0.13053425552874062f},
{-0.34818393302191464f,0.22663586698258772f,0.12249245734145389f},
{-0.3295734984717229f,0.22299810508039702f,0.1276576238308322f},
{-0.3257900400870849f,0.20653804662265024f,0.1257971671436473f},
{-0.31677156614909674f,0.24411997714257214f,0.12766039990244354f},
{0.28403434911279196f,-0.6383060355994935f,0.06007251265846822f},
{0.2815910193783775f,-0.6260405884118254f,0.07404440139771029f},
{0.29206605655068557f,-0.6302481684940584f,0.07209964265068647f},
{0.3132505235562959f,-0.6331859364494771f,0.07256434726427137f},
{0.29341013523315207f,0.3778989668965301f,-0.2606456849662122f},
{0.322450662855596f,0.3893290587581686f,-0.2481346197166139f},
{0.26552154559084157f,0.3717134756315167f,-0.25317076740136923f},
{0.2367557343178757f,0.36793338189241764f,-0.2618536320237579f},
{0.24993508064107423f,0.35143474103259f,-0.25331593692954196f},
{0.265987633459397f,0.3096855966152311f,-0.24151511892450417f},
{0.2734268881188251f,0.3316347188942423f,-0.23725566359365333f},
{-0.309678559757092f,-0.6775855886237465f,-0.3105360636299709f},
{-0.32228826957198387f,-0.7110413184373849f,-0.2807260372169138f},
{-0.31651243213498925f,-0.6833948207254785f,-0.2679317648546082f},
{-0.3061897782398938f,-0.6554912150111611f,-0.29419738526468275f},
{-0.31329403128099054f,-0.6471446279588853f,-0.250169330408218f},
{-0.3229677558607715f,-0.6941192453826318f,-0.23775684916666795f},
{-0.3282367950242835f,-0.7296259980974115f,-0.2528693229961705f},
{-0.3241624302575287f,-0.7132719605023932f,-0.30174342997009485f},
{-0.3116485071309176f,-0.6899583538740809f,-0.3313860357857761f},
{-0.2970816976398641f,-0.6607899612218971f,-0.31902526724444863f},
{-0.29460057487237273f,-0.6349044703267611f,-0.30304862240184643f},
{-0.30131172958637664f,-0.6067588332392848f,-0.28223131503661225f},
{-0.3122678908849956f,-0.603064657482306f,-0.24242368796004446f},
{-0.3225103000556841f,-0.6502603938438507f,-0.21801522652330807f},
{-0.3245167634483972f,-0.6869698453215873f,-0.22487136909374905f},
{-0.327762278012152f,-0.6962717494779231f,-0.22375868283261738f},
{-0.33115733922426277f,-0.729399692484678f,-0.2330746097096566f},
{-0.3397713470715756f,-0.7619699744439766f,-0.2568106158725016f},
{-0.3345988244705107f,-0.7627312459484978f,-0.27260591938817436f},
{-0.3311132450504562f,-0.7424542940698788f,-0.29280603049701437f},
{-0.3260840072661066f,-0.7178509349825388f,-0.31292131790378f},
{-0.3242153796004438f,-0.720543430158566f,-0.31427011792656057f},
{-0.31096006474427945f,-0.7038543091398148f,-0.32255818330695035f},
{-0.30230417040659224f,-0.6871262816846005f,-0.335627172018734f},
{-0.2860767410128728f,-0.6731854216278998f,-0.3442423357657456f},
{-0.29124912125129093f,-0.6696598404289285f,-0.33902111876505053f},
{-0.28304596244078484f,-0.6482625433912649f,-0.321895920773602f},
{-0.2748171486064477f,-0.6282426984526491f,-0.313838295897148f},
{-0.28894923888198687f,-0.577879160533942f,-0.2916186516546984f},
{-0.30107330615014566f,-0.5413660239588293f,-0.26730006035714077f},
{-0.31003258909932646f,-0.5237245042702763f,-0.24244715336137607f},
{-0.31783932743351323f,-0.5505132755348673f,-0.2247880433866888f},
{-0.31855761923002207f,-0.5988668048059945f,-0.22139397552588178f},
{-0.3213149574044135f,-0.5683613241147437f,-0.22069726441924706f},
{-0.3264637925609142f,-0.6341962087224001f,-0.21790183042555247f},
{-0.33997704515999033f,-0.6608601545059999f,-0.22592148059719386f},
{-0.3328626206265067f,-0.6834588541690906f,-0.22309982425389693f},
{-0.2886261319815126f,-0.7267754463864586f,-0.14382455547413622f},
{-0.3053522141680242f,-0.7201832197276846f,-0.12693502609546362f},
{-0.2940392878270563f,-0.7220938549982123f,-0.14553089078492903f},
{-0.27048905960616126f,-0.7216936045417327f,-0.18125777014861078f},
{-0.29502346098968313f,-0.7271867203863899f,-0.16091129324040232f},
{-0.3116072910198722f,-0.727013100639434f,-0.14491843711700517f},
{-0.3249375013771129f,-0.7324136520787028f,-0.11966977683702676f},
{-0.3215236344843316f,-0.7305101498142211f,-0.09404516230480897f},
{-0.31279420346515896f,-0.7300944976316989f,-0.10356899601610299f},
{-0.2935663708010888f,-0.7498204359485383f,-0.11814875413356254f},
{-0.276472622205675f,-0.7406838849439772f,-0.1490088113070708f},
{-0.2552976988094348f,-0.7324820626424979f,-0.18505437901713892f},
{-0.2626572346363226f,-0.7160323785970301f,-0.19670994675101028f},
{-0.2733726628241285f,-0.7267320002814169f,-0.20691873815132092f},
{-0.2900639107833181f,-0.741976229678065f,-0.1972011212552176f},
{-0.29995393203184084f,-0.7407307339412389f,-0.18800726397330667f},
{-0.31826146349090884f,-0.7340273008072086f,-0.17322330682485432f},
{-0.32883887427992853f,-0.7363506687635927f,-0.1572313834955156f},
{-0.3486156339368367f,-0.7497040406735309f,-0.06476494485602267f},
{-0.33888666946289925f,-0.7387460148492029f,-0.0641791682482444f},
{-0.32506465671843465f,-0.7342607394259882f,-0.07652482935049298f},
{-0.3190810335616757f,-0.7291591197974443f,-0.0801104419028506f},
{-0.306587658464546f,-0.7470442920934763f,-0.08837358213357581f},
{-0.302026434694114f,-0.7446823417350115f,-0.09294364088736787f},
{-0.29521908745204534f,-0.7605780937844416f,-0.10477390352490015f},
{-0.2765336161005384f,-0.7731799205333725f,-0.13532578700213194f},
{-0.2633730956437588f,-0.7572874109525829f,-0.1577160932481902f},
{-0.22265704083188964f,-0.7614495996610716f,-0.19914908209938514f},
{-0.240822258514982f,-0.729874351859456f,-0.20674396250466637f},
{-0.2596425664162875f,-0.7224947545858647f,-0.2146066897305168f},
{-0.279351887612548f,-0.7302415327479885f,-0.23418614007108943f},
{-0.29277760099518374f,-0.749218357755301f,-0.2218739851863985f},
{-0.2988900410990815f,-0.7569455196195942f,-0.21559568622460767f},
{-0.31169957176237517f,-0.7549914393064328f,-0.2009781754455681f},
{-0.32411711962677797f,-0.7418807468384182f,-0.18720560716064866f},
{-0.33427196939527765f,-0.739702142570423f,-0.17848677365939528f},
{-0.34259950747549417f,-0.7390613194267097f,-0.1770824702653209f},
{-0.3530257705675861f,-0.7522057305938442f,-0.14735275019632382f},
{-0.3581979893200169f,-0.747700354414837f,-0.1756777217223735f},
{-0.3703884613260229f,-0.7376201568560248f,-0.19602958928781727f},
{-0.37175132444100367f,-0.7207757341258031f,-0.20167877708960838f},
{-0.37529352169814617f,-0.7134762200906312f,-0.195995951331691f},
{-0.3747117068090968f,-0.6901648817029966f,-0.20314535139273557f},
{-0.3773595394231382f,-0.6721555330571461f,-0.21371048180986277f},
{-0.3909995224004116f,-0.6797891573504954f,-0.22153602476231232f},
{-0.4072570243096421f,-0.6938470618133763f,-0.22052127337805613f},
{-0.42208519674639156f,-0.7061439583970791f,-0.21246255422155635f},
{-0.4110726205305765f,-0.6499069923846327f,-0.22756621325344728f},
{-0.4144200412516061f,-0.6207668077222508f,-0.22552232335835223f},
{-0.43393969396851095f,-0.6048154524351925f,-0.2036040831496045f},
{-0.45107364620032586f,-0.6426035867496476f,-0.18079697094614078f},
{-0.2694685945926951f,-0.20732196334967262f,0.2495213753208665f},
{-0.28159495134968765f,-0.1997911163880034f,0.2562831282692988f},
{-0.2625245877090234f,-0.2233759344824237f,0.2485300691521935f},
{-0.2336787558796988f,-0.23749414333749838f,0.2536878189726401f},
{-0.25392389289399603f,-0.24008256291949978f,0.253092670865557f},
{-0.26878809476685533f,-0.22572605174268462f,0.26133955944399034f},
{-0.2923674616467951f,-0.20523430331515347f,0.2695219492441903f},
{-0.30270034865393053f,-0.18255527818466213f,0.2614522469157357f},
{-0.29871216534643313f,-0.174365209300801f,0.24834931533678387f},
{-0.28375019114509337f,-0.18596486888600236f,0.24748984654065773f},
{-0.26006618134535664f,-0.20072414417617904f,0.25513990415803467f},
{-0.25899985856111685f,-0.21208963420602645f,0.2566567930327045f},
{-0.2390795293622f,-0.22516304147189797f,0.2591653121104298f},
{-0.2015150265800171f,-0.2396508630669855f,0.2712332077527814f},
{-0.188391101822711f,-0.26091328424576143f,0.2651767374172067f},
{-0.22309184079039776f,-0.25508135698836104f,0.25775322764154435f},
{-0.24407553396779946f,-0.24693108590111695f,0.2553780248080394f},
{-0.2591317150570043f,-0.2378203099724696f,0.2634824583102583f},
{-0.2709141342835633f,-0.2381067595538174f,0.2719905483484002f},
{-0.29462361531057973f,-0.22015504015729156f,0.273190815259877f},
{-0.3214137443323538f,-0.20294716558995562f,0.2740133228882426f},
{-0.32072457100914126f,-0.18977892461561022f,0.2710430526906482f},
{-0.3218921125728018f,-0.1775262836917014f,0.26431315391562676f},
{-0.32065291903911336f,-0.16365958926191046f,0.24883947736634687f},
{-0.28326246096701085f,-0.1708292536895507f,0.25374998895295076f},
{-0.27007606344316765f,-0.1892485801978024f,0.2576718896994994f},
{-0.23661082932924798f,-0.21476794411295502f,0.2696725296153468f},
{-0.21114483972013498f,-0.22546489171688064f,0.28171594631931474f},
{-0.16367399179340644f,-0.25989263649815164f,0.2814025859481027f},
{-0.14670345700633383f,-0.2811292826010139f,0.26721813490357604f},
{-0.1840773999490072f,-0.27230836020834226f,0.2612226170289601f},
{-0.1824435484735587f,-0.2789544073844368f,0.26234239592464104f},
{-0.22468682726328762f,-0.26574725997362814f,0.2539580572731929f},
{-0.2471153706288879f,-0.25705618825089593f,0.2531418709713054f},
{-0.24890024868677377f,-0.24941786280298087f,0.26721268368909545f},
{-0.2534623234458627f,-0.2538324572969072f,0.27236457751768534f},
{-0.26851878819795316f,-0.24957656846907939f,0.2755287127054905f},
{-0.28562653932832205f,-0.2417360912500242f,0.27603897549084616f},
{-0.3005142267882614f,-0.22804666381320576f,0.2721709568812711f},
{-0.32226555423056713f,-0.22016338962028179f,0.27170209294110437f},
{-0.33571880628608364f,-0.2167396147122508f,0.2743428127348481f},
{-0.34445263461118786f,-0.20303916373198072f,0.27125177014206314f},
{-0.3393872059047411f,-0.1843206621216156f,0.2670328828534927f},
{-0.33952998501533804f,-0.17212856888128938f,0.25776536671319805f},
{-0.3544695275381467f,-0.1810573766623986f,0.2556136934208153f},
{-0.34910459969520397f,-0.22579640757518255f,0.2703449232695852f},
{-0.35559451435691936f,-0.2612859769060197f,0.2572300969727763f},
{-0.36644834347273125f,-0.2736995938615201f,0.2462412294496817f},
{-0.3673229090838582f,-0.2770348563875554f,0.23808224555597587f},
{-0.3675426298929763f,-0.3136820571419877f,0.21791038174602684f},
{-0.3686689139116868f,-0.34297835519540815f,0.1992401995053345f},
{-0.3791307591662f,-0.33024651522814275f,0.19418806364542465f},
{-0.38280337441905327f,-0.3011210820982229f,0.19164438736840267f},
{-0.3917576736131906f,-0.2937730967690612f,0.19228755099652448f},
{-0.39907838374660876f,-0.26642747613658224f,0.20390416023594982f},
{-0.4148714381449447f,-0.266762395949512f,0.20154303005631538f},
{0.30444479890736714f,-0.9989501721594408f,0.20143686789334797f},
{0.2954280673181897f,-0.9981728519225198f,0.21361961938178808f},
{0.30605706969294155f,-0.9970818483424123f,0.1779136322677186f},
{0.3117846791273352f,-0.9991101750254774f,0.149624041046606f},
{0.2298033397245326f,-0.9988634424977527f,0.17390519521770362f},
{0.20178242612689778f,-0.9914408867643051f,0.17083886316820532f},
{0.1987590238522448f,-0.9837317189011147f,0.18328825564434867f},
{0.2110393245635249f,-0.9618331746707832f,0.18792764713191626f},
{0.22673391713071084f,-0.9312515023409261f,0.17555183277116299f},
{0.25075377953743583f,-0.9339898744110674f,0.17693565931707939f},
{0.2616019555812829f,-0.9401654757217639f,0.17761623988591282f},
{0.2707285975081866f,-0.943259194519826f,0.1871882814140594f},
{0.27436881038519834f,-0.941748324185408f,0.2025993832056525f},
{0.2724312250157175f,-0.9469935728507982f,0.20993381221114f},
{0.2864820974012943f,-0.9406785560126358f,0.20491119110264014f},
{0.29260312919716325f,-0.9566091614127286f,0.2092917534871421f},
{0.30184568087870445f,-0.97023649961223f,0.2180659267488863f},
{0.3058165384396126f,-0.9762149754031425f,0.22077888814899327f},
{0.3039443846424237f,-0.9909932996653785f,0.2135554839470262f},
{0.31481663378487046f,-0.9872804807761241f,0.19680326227872158f},
{0.30618444813990375f,-0.9987797938187178f,0.1858025701566855f},
{0.3104615734374747f,-0.9894033181956883f,0.18047980184292473f},
{0.3168848400699541f,-0.9984725943504047f,0.1757243593004807f},
{0.32709059192151624f,-0.9984416315371476f,0.1694872870738134f},
{0.3279697981299635f,-0.9956705128710337f,0.14412207959451062f},
{0.3404618356556587f,-0.9985473273030857f,0.12155321871721247f},
{0.21054490759067693f,-0.9984366063481995f,0.15441153112068254f},
{0.1888156282976823f,-0.9913771773550757f,0.1708645373153769f},
{0.18733612555389761f,-0.9944786761655409f,0.19952487592804502f},
{0.20013309324482084f,-0.9782436271829977f,0.2074837138765587f},
{0.2089680989154411f,-0.9657009701747181f,0.19965835365825274f},
{0.21911445792071163f,-0.9374301846342759f,0.19027206988630774f},
{0.22589067873872024f,-0.9219413305270016f,0.1797847523421071f},
{0.23844310352441844f,-0.9143341304407386f,0.1583679409977628f},
{0.26490072333658693f,-0.9245680084767012f,0.15509050107927377f},
{0.272245021048235f,-0.9410089372193952f,0.16284812961237613f},
{0.2717259222171114f,-0.9456752904924018f,0.17291859020359635f},
{0.28357099694435095f,-0.9452074390268792f,0.18002358268052993f},
{0.2884688839389314f,-0.9395974413244371f,0.19295229531452038f},
{0.24034810484632202f,-0.114636624079892f,0.31920897880320537f},
{0.2538449644928676f,-0.1246937206432519f,0.3004275985865193f},
{0.2660653050320847f,-0.10082391271581671f,0.29393902255864635f},
{0.28373801170194296f,-0.112353053920125f,0.2645756111413685f},
{0.27891388449448845f,-0.13192806658326914f,0.25912411618513287f},
{0.22187137113197847f,-0.1014702476312557f,0.33604272327251417f},
{0.17771014239393995f,-0.11495217194878773f,0.3576211183457182f},
{0.21372675311669911f,-0.07729437382464198f,0.342124605340531f},
{0.25214868062237883f,-0.07591829860611797f,0.31458203979759586f},
{0.2069505312362827f,-0.6855944989148218f,0.1356686313149274f},
{0.20459644269562255f,-0.7139051640572827f,0.1346842148609117f},
{0.22806237310630983f,-0.6801054350935576f,0.1316081267204808f},
{0.20723736647166596f,-0.6651851030287957f,0.13971738355416366f},
{0.23005714363865012f,-0.6119197851568752f,0.13595781659638972f},
{0.25042299249089256f,-0.5913659485544349f,0.12785320992169757f},
{0.23593359109538947f,-0.7189657694322654f,0.12425756717719198f},
{0.22140888907553505f,-0.7349740262192974f,0.13514538909333915f},
{0.2062066672837521f,-0.7496675660885481f,0.14127485109519203f},
{0.18089097438291005f,-0.7736103242483569f,0.14084448775170458f},
{0.1585146504860583f,-0.7679881672885125f,0.14163433058949923f},
{0.1766986122301682f,-0.7281475503245834f,0.14119919597253056f},
{0.187692363641972f,-0.6811194364178988f,0.14849315786447975f},
{0.2145409134068902f,-0.6002658184715757f,0.14976589798722267f},
{0.23892175436534438f,-0.5383627638738736f,0.14912504509609079f},
{0.2603063875018954f,-0.499942559593664f,0.13779812578183817f},
{0.26659846589300074f,-0.5545687953118625f,0.12207058476119557f},
{0.2717255174397353f,-0.5994072814071001f,0.10407140229569296f},
{-0.349226547113434f,-0.7571606402028889f,-0.23808228592747277f},
{-0.3535812419925427f,-0.7399193709708154f,-0.23773095191385593f},
{-0.346169223219769f,-0.7558911521104568f,-0.2452814534200371f},
{-0.34124438506382765f,-0.7655766109845152f,-0.2544486240801321f},
{-0.33884063002038983f,-0.7466010821147328f,-0.24187545046987613f},
{-0.343134675224766f,-0.7352308091249181f,-0.2363484119437992f},
{-0.3516135447984617f,-0.7230220998264207f,-0.23907732008515611f},
{-0.35771945959358153f,-0.7214533558888816f,-0.2338852428059136f},
{-0.34764900856403164f,-0.7396914441237616f,-0.21048820954179914f},
{-0.34493661555210375f,-0.7551937525635602f,-0.21606643487623195f},
{-0.33766859128446347f,-0.7644395668994904f,-0.21189766030172005f},
{-0.33971302831958133f,-0.7675579261219234f,-0.23706974328905658f},
{-0.3330351875273212f,-0.7694007988974209f,-0.25903953471203955f},
{-0.2776431002645263f,-0.24666943929253538f,0.2820767633850565f},
{-0.27203798645079336f,-0.25091187378783886f,0.30332376477685696f},
{-0.29630401299706366f,-0.2470030629679352f,0.27931373070479565f},
{-0.3016063458965711f,-0.23965718545587147f,0.26667143684232647f},
{-0.3133544578500827f,-0.23004127285955867f,0.2658430721596963f},
{-0.31285207706828017f,-0.2383158817826085f,0.2587916473470241f},
{-0.31666945707193006f,-0.24604223409214943f,0.25957117632978516f},
{-0.3366602834035838f,-0.2703330434254375f,0.26127540488588785f},
{-0.3356030590798413f,-0.2331880004953732f,0.27168201130865227f},
{0.3379858400682654f,-0.012918727594174546f,-0.17213477440531605f},
{0.3452536624784216f,-0.009580385147893888f,-0.16900227241009694f},
{0.34988933553864915f,-0.04803528129277871f,-0.16284164467509502f},
{0.3488817777176843f,-0.051168796825049934f,-0.16658240701460625f},
{0.3546026196143189f,-0.08246861965117705f,-0.16012779191483423f},
{0.35412333982796873f,-0.09231335045469752f,-0.1537286196291108f},
{0.3670034696151491f,-0.07146309463600665f,-0.15417523462489008f},
{0.3789870472615446f,-0.05290589309161563f,-0.15306619560977514f},
{0.3484003497427392f,0.01899922215758958f,-0.1724233519895102f},
{0.32616571067643874f,0.03114284304151824f,-0.18130492405691437f},
{0.34401250349028195f,-0.023779649344535633f,-0.1840498809306711f},
{0.3551464194270589f,-0.05208488452067194f,-0.1780477984381882f},
{0.3634717285756869f,-0.08744281939885425f,-0.1667516910752834f},
{0.35454288148548857f,-0.11373601885330634f,-0.16302195227922384f},
{0.3463468546186208f,-0.11097211499864011f,-0.15615768441384087f},
{0.3401519217353871f,-0.13476119161889066f,-0.15107454536917714f},
{0.35982124221513834f,-0.12024070523323219f,-0.14452726387286663f},
{0.3875842977504472f,-0.09537756512542757f,-0.14211222180883995f},
{0.404827188216841f,-0.10720782670055203f,-0.12682146744931286f},
{0.389809346238328f,-0.07218594628684223f,-0.13896656826732282f},
{0.36408888339817636f,-0.013911979031550309f,-0.1585695658146285f},
{0.35005667433062343f,0.026176423306244315f,-0.16714839521448835f},
{0.3202849062852646f,0.06597505391346467f,-0.18566192861060515f},
{0.31527674348467083f,0.07538297893252904f,-0.19273736596463187f},
{0.3220397532615441f,0.057170018767205545f,-0.19856580852441066f},
{0.3319916395793356f,0.002539487734225315f,-0.20019497903104191f},
{0.34886532314550045f,-0.0494052774138056f,-0.19951235226476363f},
{0.370210745996954f,-0.07383542046915816f,-0.1843500897555851f},
{0.3705163656648518f,-0.08100322037108933f,-0.17452051526190282f},
{0.37497136671507103f,-0.10225283634851377f,-0.17335406904069595f},
{0.3608289211505937f,-0.14434873473941423f,-0.1769458116861257f},
{0.3369260425928036f,-0.1417939541759469f,-0.16094016842230985f},
{0.3379946750516255f,-0.14771471784972545f,-0.15138995193783397f},
{0.3376180514824648f,-0.1801407216410053f,-0.14208490624159964f},
{0.349343063502932f,-0.17268679725451663f,-0.13408712042271803f},
{0.3670460232976292f,-0.18348790013305383f,-0.11734992438809078f},
{0.3813283699099422f,-0.16318987327067894f,-0.11627485798756274f},
{0.3912992233943918f,-0.131768468494609f,-0.12514090721443372f},
{0.40119327754296674f,-0.11972551818767038f,-0.12886098022422468f},
{0.4141186361554965f,-0.13827826186888453f,-0.11379262075427718f},
{0.429097571697546f,-0.1438553514893669f,-0.09784928983341876f},
{0.44104236508437655f,-0.14628733470835503f,-0.0733039052779421f},
{0.4222516016818999f,-0.13002351041023855f,-0.09626481057378417f},
{0.40673976875607154f,-0.11130468476549096f,-0.11142031510687404f},
{0.39572022208260543f,-0.09501743649994755f,-0.11507706329906327f},
{0.3743956309235189f,-0.045368724803468236f,-0.14219060306994563f},
{0.359243844817769f,-0.009524537556469145f,-0.14857151787742923f},
{0.3428550739241709f,0.05513763899833978f,-0.17020097864449862f},
{0.3695876746253624f,-0.04704535306703718f,-0.13603506214354497f},
{0.3847626010356535f,-0.05480372103597624f,-0.11626346897582394f},
{0.40285543793695944f,-0.02345826566953157f,-0.10250054522901687f},
{0.4122368569435356f,0.004903302618399236f,-0.10697102874827252f},
{0.43735086340785895f,0.0027054071493635757f,-0.08471741189123604f},
{0.45459415971403666f,-0.001821935373553312f,-0.056663438287324376f},
{0.46696903171906134f,0.0071418065012121435f,-0.05396376017208402f},
{0.4723565739746786f,0.0190069214269992f,-0.0269689816584051f},
{0.4639014948991046f,0.025665532637872024f,-0.0408937281758295f},
{0.44858216814389645f,0.026058569345311856f,-0.0640963599337884f},
{0.45074370908003175f,0.02511135735044549f,-0.043736548745138375f},
{0.44527089691105926f,0.027795422320488733f,-0.02532674141087734f},
{0.44965602871155835f,0.038493422770555466f,-0.0009339334908349088f},
{0.4517611961644025f,0.050847625631608113f,0.020310795410656838f},
{0.46146963385701495f,0.12142221745961326f,0.06333574393488683f},
{0.46657607575461507f,0.11577963570959376f,0.03002376533499288f},
{0.4583862501621427f,0.08960226420437765f,-0.005989888706826966f},
{0.4555753336994118f,0.0845629760421317f,0.0039130609823533865f},
{0.42780255182058907f,-0.007580022100834151f,-0.08247192692669407f},
{0.43132926660869536f,-0.023304989969757394f,-0.06116058824264755f},
{0.4622347544650371f,0.0450003784535666f,0.009079739278047422f},
{0.4617906531261396f,0.030848125802581696f,-0.02091361091491524f},
{0.4315708113990763f,-0.5100323209475949f,-0.12639969579779664f},
{0.42172701232720666f,-0.5205858817436553f,-0.15368306676937907f},
{0.40445871119077864f,-0.5074408214453481f,-0.16821666432983873f},
{0.40162319467517343f,-0.48990678130544874f,-0.13981090093935916f},
{0.3712565218141204f,-0.4843488203376116f,-0.200308456934199f},
{0.39752572785055845f,-0.5115594025628079f,-0.1843459559267907f},
{0.42316959321231995f,-0.5341177371035101f,-0.1403084583896977f},
{0.4303555496637487f,-0.5191056501881118f,-0.1388862013660175f},
{0.4408659076461565f,-0.5166782066377021f,-0.11553163147971908f},
{0.4541493285009727f,-0.4930288685168922f,-0.06822664347329133f},
{0.4386667149771829f,-0.49486720162381137f,-0.09335757090682775f},
{0.42359926811554555f,-0.46438101319600866f,-0.07782628423156389f},
{0.38899855059367594f,-0.46660306250663774f,-0.12978456426936427f},
{0.36975513453182735f,-0.46747894656585864f,-0.16679339376910643f},
{0.35350707636563283f,-0.4560172427597902f,-0.19321117541316093f},
{0.34448209730461515f,-0.4479000423029012f,-0.213668433833501f},
{0.3893196909772913f,-0.512772638286439f,-0.19154066661858601f},
{0.3817247712629211f,0.24280834120744402f,0.1682287014103425f},
{0.39581059899031035f,0.22621510886812357f,0.1753726704426549f},
{0.40010243544884644f,0.2358636862550074f,0.16922107104923473f},
{0.37625718720278867f,0.2568301758627182f,0.15895883416156104f},
{0.38794373793566544f,0.253097093669276f,0.15811239367242674f},
{0.4092609124258202f,0.23262763562003697f,0.16447247784995117f},
{0.421669422386971f,0.21201706006601814f,0.16584083255090937f},
{0.41055706695431976f,0.21422532994733273f,0.17452339332466407f},
{0.40747015819032933f,0.20282992995036933f,0.17884951687049927f},
{0.39244947958295995f,0.2255396746027288f,0.18450225098956502f},
{0.37280783907632825f,0.2505742480222133f,0.17074390728283312f},
{0.3488612307506107f,0.26168968231270207f,0.15164370591878423f},
{0.36581884665869613f,0.26693630998343143f,0.14849777827605176f},
{0.3711367215220772f,0.26690202395854024f,0.14026513446155434f},
{0.3957625324736967f,0.24813124125977337f,0.15040323537090644f},
{0.43095742599950176f,0.18337730985432818f,0.1647415910606317f},
{0.42136092571871986f,0.19606229976192407f,0.1725317228983176f},
{0.4173884872949884f,0.1588102638659838f,0.1802339203038573f},
{0.4071055302677677f,0.1976504974488988f,0.18654695150182019f},
{0.4002401075650937f,0.19206984132539334f,0.19785539979386282f},
{0.38095462440354294f,0.22243217743776011f,0.19498444241607538f},
{0.3787475699167646f,0.24201116244371135f,0.18025108456445918f},
{0.3618494477837129f,0.24906710567680562f,0.18075563265819705f},
{0.3506701001016947f,0.2628730091316251f,0.1619175134899325f},
{0.34623013530923097f,0.27310404947632333f,0.13876801380903223f},
{0.3522329274901321f,0.27492811763355807f,0.13298882235057685f},
{0.3675208452208024f,0.2674585492920457f,0.12951808583005617f},
{-0.23283424047351886f,-0.2749285532207608f,0.3142700382459747f},
{-0.2555220198443766f,-0.2547613512562884f,0.30153001136411417f},
{-0.23891713501618006f,-0.2647843232807444f,0.3191248233556444f},
{-0.2201559787945929f,-0.28285170807811116f,0.3352250570365453f},
{-0.23891081368970193f,-0.2701868199887158f,0.3319591782398605f},
{-0.25472388810083696f,-0.25690834357985387f,0.31544128655048936f},
{-0.2593315773393107f,-0.25744233524367843f,0.28652844122364163f},
{-0.2486926053296562f,-0.2854255376136378f,0.27225942889177007f},
{-0.23321909132877144f,-0.29946171902399793f,0.2906840855000118f},
{-0.20561524822808713f,-0.30521696806001436f,0.33481224254528746f},
{-0.21155171641413462f,-0.2923998581793938f,0.3447216166145036f},
{-0.21692817456905508f,-0.29315918441521216f,0.348676769663143f},
{-0.24816337537764258f,-0.27198527455602417f,0.32532208822402436f},
{-0.28122872344096206f,-0.2623550959476192f,0.29397480764095957f},
{-0.30979825805798517f,-0.2627157918988705f,0.26522360766262465f},
{0.07912997707468969f,-0.82542069905787f,0.15297890924639382f},
{0.0855469914371986f,-0.808092376129726f,0.15667430039790906f},
{0.049607646447343216f,-0.8349446942551514f,0.1564938408694632f},
{0.05416570424249706f,-0.8495245947352577f,0.14953905479613652f},
{0.027009625662844046f,-0.8440277498391822f,0.1541701180688701f},
{0.05401146175161448f,-0.8149503014204744f,0.1556751122256829f},
{0.08623852543056819f,-0.7905883256375283f,0.15631916721395853f},
{0.15005110083300383f,-0.747656746823808f,0.1517929083470093f},
{0.11693630937254705f,-0.7913108521915736f,0.15153904281323882f},
{0.10075354041599768f,-0.8262173104958314f,0.14697602569842105f},
{0.07056447026878543f,-0.8698004119623339f,0.14624786625815947f},
{0.05335680818301174f,-0.7932438585833871f,0.15845985733438644f},
{0.08766114686012771f,-0.7743740265419506f,0.15967392386092613f},
{0.12325688897801032f,-0.7563557611073387f,0.15392554435381856f},
{0.13892169375497868f,-0.7282532460905217f,0.1551239467395862f},
{0.12973076446899615f,-0.8055328126062914f,0.1441417957586756f},
{0.11076525622969126f,-0.844505003613836f,0.14446929996508145f},
{0.09772643989975295f,-0.8729839392799217f,0.15050528495323573f},
{0.06299721990345669f,-0.8963920566447331f,0.15063944156203496f},
{0.021320223600573774f,-0.9053917865217037f,0.14949546739085595f},
{-0.013395852286279139f,-0.9066338783039019f,0.14745074669285238f},
{-0.2929704120768456f,-0.13999371582592307f,0.23600953997381074f},
{-0.29695679141587916f,-0.1287167371156635f,0.2252286207188756f},
{-0.2992340604349164f,-0.14680130635938052f,0.24311245544347293f},
{-0.28739844857405344f,-0.15529225232266905f,0.251217761182505f},
{-0.31309275068425585f,-0.1462536149468273f,0.2480677294583969f},
{-0.3284336177578414f,-0.1258947163664873f,0.24072359429514395f},
{-0.31088553364908245f,-0.12318868611494227f,0.22835293686190747f},
{-0.29811811151939577f,-0.11563109197421186f,0.22269280625965837f},
{-0.2947138700413862f,-0.11846527091838237f,0.22647518948759116f},
{-0.29149423254469503f,-0.1326087693290009f,0.24203044833271267f},
{-0.2863592788086588f,-0.15324252662146573f,0.26873974511856f},
{-0.27929942485241055f,-0.1757771917785366f,0.2816376064921136f},
{-0.2731896800771304f,-0.1874919494388075f,0.2759589336863312f},
{-0.2673384212471928f,-0.19138973671525952f,0.29550342974749916f},
{-0.2706454364743371f,-0.17452569874961493f,0.3000584533059435f},
{-0.26551074621543813f,-0.1605357182677516f,0.29848687167713994f},
{-0.2575016330044708f,-0.1752088322844193f,0.2924384458935136f},
{-0.2582892872821738f,-0.15146790186136821f,0.2830656993219021f},
{0.08255072305805014f,-0.7088135958690427f,0.14823775290179045f},
{0.11247505711476508f,-0.685905751468936f,0.15051146497947496f},
{0.0689000097618811f,-0.6884484556428104f,0.1545101555002277f},
{0.019351613798182763f,-0.7255742073718343f,0.14965820595700677f},
{0.009966582605047415f,-0.7003697421944047f,0.15464728047645213f},
{0.026793957939526603f,-0.6685167990518079f,0.16855263805131748f},
{0.05814414633277125f,-0.6564726322879251f,0.1709033024516013f},
{0.12019061748575723f,-0.6532469560652336f,0.15595176428219348f},
{0.18371386630649164f,-0.593962635794025f,0.15479293658740254f},
{0.12958717474123907f,-0.6877072859564898f,0.15157648100210666f},
{0.09419843747337929f,-0.7247451733722831f,0.15017457864968617f},
{0.06854806805099614f,-0.7346151129883537f,0.1482036081771381f},
{0.024891489397845558f,-0.7451651072813911f,0.14922050774998902f},
{-0.013430260488068809f,-0.7421179145086161f,0.14988581939375623f},
{-0.014833696957368974f,-0.7315132901435059f,0.15072939244420738f},
{-0.0064942885946751355f,-0.7087456708256173f,0.15411831400157575f},
{0.0010742812811553675f,-0.6891889761979583f,0.16010469198178975f},
{0.009728018930985387f,-0.6750800071036199f,0.1658510454772009f},
{0.0206166790868957f,-0.6442566284973943f,0.18200860562120005f},
{0.0444115925756624f,-0.6389037377349553f,0.1824121197944764f},
{0.08269410986591526f,-0.6270095234592126f,0.18235505680851538f},
{0.10084046237349965f,-0.6334398009208398f,0.1727310380406012f},
{0.12564815116799313f,-0.636244151703296f,0.1610893517271943f},
{0.16820792974401685f,-0.5903026653189436f,0.160596565550337f},
{0.18819555504093474f,-0.5336239480136789f,0.17204469284698282f},
{0.2052739029727137f,-0.4896493492686552f,0.17541349240040224f},
{0.2107837166809435f,-0.5474396585550058f,0.15675167768363293f},
{0.17752114110668998f,-0.6262467932687662f,0.15075974756019628f},
{0.15019167119776078f,-0.6708782638899029f,0.14865976678228768f},
{0.12185113645968111f,-0.7109641546956312f,0.15084425785196623f},
{0.09426372774543214f,-0.7400837509570349f,0.15326399044648048f},
{0.06192571894354388f,-0.750812228699989f,0.15205487898997339f},
{0.015549290238036771f,-0.7565506183864453f,0.1511545776120218f},
{-0.006986556316520413f,-0.7611043043734551f,0.1526194191280085f},
{-0.0238319968334255f,-0.7674003540449597f,0.1556714851654146f},
{-0.01160694876519573f,-0.7323997101009931f,0.16292747235255117f},
{0.007830315288338642f,-0.6736138800741813f,0.17550081913528037f},
{0.00619764308556078f,-0.6687987089645773f,0.18207385552175614f},
{0.015150088378067176f,-0.6488887764885034f,0.18291268598373697f},
{0.010654329114569186f,-0.6464336115310693f,0.1891848654765338f},
{0.03623491852948803f,-0.642975144758363f,0.1868846282630207f},
{0.0458089552595046f,-0.6486804638144646f,0.20098540088109376f},
{0.0813809833726277f,-0.6312174275758281f,0.1918007121785957f},
{0.09741390076977925f,-0.6200136413269233f,0.18626447426327938f},
{0.10921117351995027f,-0.6076807556786074f,0.1854186425338211f},
{0.1382211632922618f,-0.592084260536692f,0.17741003609137979f},
{0.16613226641850473f,-0.5356373616782945f,0.18476624870663336f},
{0.2035103017560679f,-0.4557664571462652f,0.185401214796082f},
{0.23606137431972776f,-0.3999673518892317f,0.1775774758120963f},
{0.23059723564812806f,-0.45488781826358915f,0.16700790665513282f},
{0.23680305077457456f,-0.45675970858364096f,0.16262521733019233f},
{0.23652728051654742f,-0.4967574110417561f,0.16175312394204266f},
{0.21228097013444208f,-0.5696896589758521f,0.15862940487220084f},
{0.19004272419362175f,-0.62059432156443f,0.1560593447595892f},
{0.16684401272048718f,-0.6593752217958908f,0.15658591975448197f},
{0.13631650619048913f,-0.7031107076020139f,0.15813113773344428f},
{0.10177704604062025f,-0.7426421798289268f,0.1630580019010821f},
{0.07488670221480734f,-0.7586116916654829f,0.16184983280030377f},
{0.05991375546559087f,-0.759927705783202f,0.15342657815072208f},
{0.039785660732658136f,-0.7664448743925045f,0.15387108532940338f},
{0.01008781077318905f,-0.763522669649116f,0.14879579854087413f},
{0.013216271369093454f,-0.7733008544145504f,0.15865498765230066f},
{-0.014239658004041075f,-0.7718522348034368f,0.1519306314588316f},
{-0.02820061350449544f,-0.7903375410864111f,0.15490625194216448f},
{-0.01270526171104628f,-0.7332370117581332f,0.1698937993619337f},
{-0.015173899061937408f,-0.7204348159583698f,0.17890761251685303f},
{-0.014727712216506131f,-0.6854067746417614f,0.19034212293257943f},
{-0.0033840791025637703f,-0.6609989219647009f,0.19171440854244f},
{0.15253420924069472f,-0.4664751571054011f,0.19793742830098524f},
{0.1897681491443825f,-0.4442073252318473f,0.19038894218242242f},
{0.16534771224679548f,-0.39423544607764854f,0.2067090379726804f},
{0.1493886353797635f,-0.4277813105700108f,0.20398152796000335f},
{0.13605524417353532f,-0.4022732124272908f,0.21146423722373558f},
{0.15839051450773672f,-0.38008740906085947f,0.21296159266838405f},
{0.16561902464164563f,-0.355629463855489f,0.210691557584135f},
{0.18926736941115185f,-0.3751673528024775f,0.20133292510029868f},
{0.21250135919807367f,-0.3995288430650538f,0.18773115905681895f},
{0.15975507960003144f,-0.5003982528641922f,0.18894034169464943f},
{0.11713708320075576f,-0.5350792151104686f,0.19256548856648692f},
{0.0977611009546017f,-0.49538012042869567f,0.20651403939333476f},
{0.12385943356827675f,-0.4484555955332592f,0.20552418234891662f},
{0.13466013060702997f,-0.42308107711189685f,0.20534622585327456f},
{0.10286006562602487f,-0.4240923225503752f,0.21288076999412764f},
{0.11826573745129348f,-0.39634061459290043f,0.21888085728474063f},
{0.14390026106116882f,-0.39459662861167755f,0.21513105704197738f},
{0.1607204885158925f,-0.3865747495084477f,0.22231093439590913f},
{0.1650102989627322f,-0.35689716816520556f,0.21868555379435312f},
{0.16129170588702252f,-0.3365349463732314f,0.21494189426874008f},
{0.17074577127733837f,-0.3302831523615207f,0.21247482503177864f},
{0.19583489402590182f,-0.3337106563209699f,0.20271306296629374f},
{0.19942993863480957f,-0.35912213591009273f,0.19902616257800765f},
{0.20729197742039823f,-0.37607160633748765f,0.19232006386277842f},
{0.2274731415483287f,-0.3572541361274465f,0.18454065171991005f},
{0.2382731703325685f,-0.3701691606991942f,0.18214684506321868f},
{0.25314780823735983f,-0.3798134417088884f,0.16912476696834983f},
{0.364059906225119f,-0.07417196257881607f,0.2727204915713773f},
{0.3598834111330414f,-0.06574756265361363f,0.26201616873242456f},
{0.35826676428969156f,-0.06498807493180785f,0.274070102211318f},
{0.352860295238913f,-0.07514892199240318f,0.2842458229812737f},
{0.34634811144706174f,-0.06520433016664505f,0.28030736779620696f},
{0.35237063997787627f,-0.05299108226197714f,0.28538347476356674f},
{0.36093324003600824f,-0.051222779890765575f,0.2799483940080181f},
{0.3650670996402047f,-0.053196070661973814f,0.2699421591562237f},
{0.36391218373097545f,-0.056573725384501755f,0.26075081446878684f},
{0.3557798662733371f,-0.06433501178769888f,0.25582826686408694f},
{0.36346552836369916f,-0.07578982587911001f,0.2567023055209394f},
{0.3664004989993502f,-0.0828468230207533f,0.2698125719634215f},
{0.35998635207552426f,-0.09170081604377989f,0.2785190241640402f},
{0.34857441676338347f,-0.08890278765020976f,0.2845324149252682f},
{0.34169371451156516f,-0.07670088732337603f,0.2854775998460303f},
{0.33259712278960857f,-0.07413240701117997f,0.27687516268219214f},
{0.3366525618236102f,-0.06330585309111159f,0.27565665847822396f},
{0.34042503703629334f,-0.05480688276162318f,0.28496526961507357f},
{0.3405223844016491f,-0.03970774215015437f,0.2860629610523543f},
{0.3566362562116257f,-0.03789810149099911f,0.2833757757905689f},
{0.3652119047624979f,-0.037384698228152796f,0.269816564491977f},
{0.3651428046960332f,-0.04283177463030058f,0.26113039684370243f},
{0.36079427071982323f,-0.05174485665098469f,0.25459677366221595f},
{0.35104068494485524f,-0.06861140827351116f,0.2514887282948165f},
{0.3567847085799357f,-0.09272811021465809f,0.2512525943474192f},
{0.36412454842840697f,-0.08996412561699824f,0.25533694999723294f},
{0.36679767059799223f,-0.0901562259478342f,0.2628327194401913f},
{0.3595709431843909f,-0.10123769931022204f,0.2713507589274876f},
{0.35198651899679f,-0.10098432035922918f,0.27725893944314733f},
{0.3420834683788677f,-0.10019986817866984f,0.2770008593375888f},
{0.33715121355399447f,-0.0926588082907091f,0.2799058392631302f},
{0.33065787581431055f,-0.08665220631539629f,0.27420299243000595f},
{0.32933318926162664f,-0.07389134880357655f,0.2659673303149162f},
{0.334312617118144f,-0.06468492748688737f,0.2582432483708684f},
{0.3320842857901257f,-0.053791989014720265f,0.27585903335500456f},
{0.33094327148710945f,-0.037324797550927324f,0.27376796936585746f},
{0.33711263221432153f,-0.02873463969657392f,0.27718728641071155f},
{0.3488168529139185f,-0.02817641238575452f,0.2820044420981073f},
{0.35762099670002373f,-0.02833576718302583f,0.2763361245812632f},
{0.3587552838367779f,-0.028238419817670043f,0.26386370229099093f},
{0.35830113105757644f,-0.03762121676717787f,0.25374311942404193f},
{0.34980836094007556f,-0.04231593951597382f,0.25162362540186034f},
{0.3411188700801668f,-0.06738463641195429f,0.252123554146434f},
{0.3502951392007591f,-0.09883627412711478f,0.25055290531168894f},
{0.3610124308518662f,-0.10021559287668719f,0.26109732621334747f},
{0.3663241862462535f,-0.1094001285924604f,0.2616419366432475f},
{0.35902260476548054f,-0.10986854738375418f,0.27831117788703064f},
{0.3433076065314599f,-0.1085685819984349f,0.2823034546518256f},
{0.33475586853079214f,-0.11056675754781087f,0.2781270817366462f},
{0.33403301687995657f,-0.09899765599849035f,0.26758363293813514f},
{0.33137833492275476f,-0.08370617070238896f,0.2603000252727164f},
{0.3364517879954015f,-0.03952496232304832f,0.25624768740711645f},
{0.3301663963990615f,-0.04810660922842415f,0.2661626529286443f},
{0.33527008347320647f,-0.025855070441066826f,0.26305671537834285f},
{0.3302765914620811f,-0.005848924188771945f,0.2718008788066369f},
{0.33700653060859936f,-0.018098565935429065f,0.2824458289850465f},
{0.34804638202015786f,-0.01707078518177325f,0.2869332111629511f},
{0.36237172746382407f,-0.019269570948554898f,0.27657394032022603f},
{0.3635407064652534f,-0.01759642844501535f,0.2625029257449518f},
{0.35909709442677296f,-0.014008354293758591f,0.25495262609625485f},
{0.34779985241232547f,-0.02534936644763013f,0.25542675957916644f},
{-0.1619581224349136f,-0.5217123878055984f,0.3581577044094183f},
{-0.17411793547629656f,-0.5021261890506075f,0.35310437334072053f},
{-0.18565692413860924f,-0.5033285627167743f,0.3381435539766719f},
{-0.16748318488246122f,-0.5253799768070957f,0.34589335150179595f},
{-0.17826235222691533f,-0.5255962331043407f,0.33939948574542983f},
{-0.21131738643520118f,-0.4787235834575219f,0.319981517142567f},
{-0.19617299681263473f,-0.4830506387350078f,0.3374489305013867f},
{-0.19143916576989134f,-0.4808728450841726f,0.3432599463858341f},
{-0.19112041580385186f,-0.4692762654192167f,0.34133747695469463f},
{-0.16428680030553927f,-0.48790147275002665f,0.35936040317237544f},
{-0.16120105594051015f,-0.5077549924337201f,0.35902246293403767f},
{-0.1538200807239872f,-0.5184491023463814f,0.35817184930701995f},
{-0.15588477150162267f,-0.5229210838606512f,0.35215047455108883f},
{-0.16893785384365329f,-0.5389019443374493f,0.34605323325334175f},
{-0.19428729625344188f,-0.5153344721753665f,0.3316323635361243f},
{-0.22136637682695967f,-0.4754481398033106f,0.3135503886922829f},
{-0.23140659385501122f,-0.44841717461716574f,0.3090100359233069f},
{-0.23207623162338661f,-0.4418802282240451f,0.30655053527959425f},
{-0.22765464542365316f,-0.4393122355570345f,0.3150831031937122f},
{-0.2324999081721088f,-0.4251064864231116f,0.3123272237052458f},
{-0.21103192914274926f,-0.4426066463779037f,0.331753337788799f},
{-0.19494759226993114f,-0.45109183727807756f,0.34534031086591205f},
{-0.16550423041521012f,-0.47796717565596153f,0.36420803615265845f},
{-0.1543301522759368f,-0.4895632687381399f,0.3650865741065924f},
{-0.15552345829143285f,-0.48553303745428067f,0.35692375917031843f},
{-0.15517923603570602f,-0.48789871686416375f,0.350930531846944f},
{-0.1535725683889292f,-0.5009849303937945f,0.35158304678862223f},
{-0.15933655147956355f,-0.5090457169958954f,0.33796040974368646f},
{-0.1724033420695853f,-0.49508216072111855f,0.32020559488612f},
{-0.18502324462502032f,-0.4685800005238627f,0.3033257100455597f},
{-0.18094619409131807f,-0.4547310578661934f,0.3072004770695531f},
{-0.19127164424377333f,-0.4219793729603122f,0.29590866502143004f},
{-0.20332180936215952f,-0.3880387697831962f,0.28550598950756806f},
{-0.21072487203708265f,-0.3617919348680438f,0.2841389723780444f},
{-0.22395809943484687f,-0.3349136780559017f,0.27903415065235676f},
{-0.2177296284618211f,-0.36469079532459125f,0.2665532386612631f},
{-0.21514321576817555f,-0.3623384098236529f,0.26334612376544553f},
{-0.19038864842666248f,-0.35991274899355075f,0.26515503455043427f},
{-0.16832840891465137f,-0.3333183484252888f,0.26689275870001655f},
{0.16707206174443934f,0.19301591760630923f,0.23665747593782163f},
{0.18677899252312397f,0.23359340894177727f,0.2507373053107075f},
{0.2004137473915571f,0.1980940314620249f,0.22443176598952533f},
{0.20006995116136267f,0.18228030791971703f,0.21144316330238755f},
{0.22197702652641974f,0.1932318498691718f,0.2078272668153644f},
{0.2114382990682228f,0.2103346767393345f,0.22329196601863754f},
{0.19325105448397562f,0.23524409958103745f,0.24255702439001325f},
{0.19511921575260918f,0.24503176846100463f,0.25576824507237106f},
{0.182956546959029f,0.2417593229216372f,0.259957242579574f},
{0.1633970560740102f,0.24099691782798116f,0.2653579565672377f},
{0.1376572818470698f,0.2103486176546365f,0.2581810783905577f},
{0.13833805471171703f,0.1872775279198528f,0.24950246871145385f},
{0.15033678016868826f,0.17803138954954023f,0.2347506908332026f},
{0.17201136776995704f,0.18418899792154195f,0.222986711819027f},
{0.15611427921150003f,0.1799603439179609f,0.22381979890437909f},
{0.19391062062629844f,0.18773257312161595f,0.20262143029255578f},
{0.20891737850411438f,0.18237319742189598f,0.20200512645872318f},
{0.21676626574340502f,0.18404633992543545f,0.20355281666066272f},
{0.22447006419751656f,0.1911300863709556f,0.19235476528912396f},
{0.2266357591481949f,0.19988413762875087f,0.20049622157875638f},
{0.22755581812421607f,0.2088743037106029f,0.2107146893894138f},
{0.22316997769770683f,0.2140297438564673f,0.2150573779978452f},
{0.20615426508085996f,0.22724224155301445f,0.22677783016398553f},
{0.1905399576095778f,0.24910114841030812f,0.2352100313497475f},
{0.1930199042916218f,0.24854916274538089f,0.24623571767795585f},
{0.20178025881496245f,0.25108384255305555f,0.26234877887077224f},
{0.17633141221829512f,0.24598895009077365f,0.2739987328417679f},
{0.15554411574891894f,0.23817700383349508f,0.2703737995139005f},
{0.1232229673589984f,0.22662305965642063f,0.2675581617108555f},
{0.10065943551928248f,0.2114971708034829f,0.26429973889219155f},
{0.11159077365938685f,0.19923002163850081f,0.26094526590810957f},
{0.11103692346875052f,0.1835117001928459f,0.2534926992788039f},
{0.1282552946252637f,0.1707513282013961f,0.24874121845508887f},
{0.13196742401184836f,0.1682315635369865f,0.2431770763986047f},
{-0.146685757292195f,-0.22589075576328657f,0.3288813870597079f},
{-0.17252325285204081f,-0.213227164873829f,0.3197286247743518f},
{-0.17395239959037825f,-0.20503020627531057f,0.3145510153646857f},
{-0.17049793490789783f,-0.19614249349075621f,0.3317725886183425f},
{0.3503693855706625f,-0.5132883119147784f,0.07904158208875706f},
{0.3503514319410568f,-0.5044570151098279f,0.09019638496310713f},
{0.34271618641338725f,-0.502749666261983f,0.09269136259086767f},
{0.34363081436067633f,-0.5141946722044788f,0.08545884505469394f},
{0.3347606907998483f,-0.5395795661005278f,0.11083705215597765f},
{0.3361255809889334f,-0.503275552816614f,0.12009666504456294f},
{0.33906723948175754f,-0.4737717537687227f,0.11303420181472969f},
{0.3446046524201133f,-0.4793201498790333f,0.10840111784233872f},
{0.35182805662208033f,-0.48896994372286123f,0.10282439262773566f},
{0.35847965594139763f,-0.5209880774688377f,0.08591205547816673f},
{0.353896059987272f,-0.5223600199209752f,0.07188881313254236f},
{0.35525183153011125f,-0.5308377537807205f,0.06776111761846813f},
{0.3308571898941864f,-0.5469791026439247f,0.1308173415269574f},
{0.32980221575018853f,-0.5112189709781522f,0.1363882001256256f},
{0.3324798361544474f,-0.4900769970977765f,0.14204873656765862f},
{0.33626876487690655f,-0.4673719535999827f,0.12910032689284381f},
{0.3398405873758716f,-0.45360909041042086f,0.1288713355131629f},
{0.34282236876210304f,-0.46259423024091684f,0.11935989797621292f},
{0.35324960395734245f,-0.4732846121645677f,0.1228346769584562f},
{0.3764088820397393f,-0.5160130671040004f,0.12584302916405218f},
{0.3659651115293225f,-0.5241404794247733f,0.09817737092726622f},
{0.3783251098249867f,-0.5554741824360074f,0.08538133603040145f},
{0.3617152199935904f,-0.5403379191707909f,0.06921887181194462f},
{0.359138350909315f,-0.5454051709690422f,0.06967559774286551f},
{0.41627138354217647f,0.42860342404507834f,-0.126589162419668f},
{0.41892043261316203f,0.4372345143475914f,-0.1026985429856142f},
{0.41815664851416673f,0.4267488785949563f,-0.08986280059679634f},
{0.412583611979485f,0.41902657937121607f,-0.1311699206825292f},
{0.4055429876046241f,0.40822093788650843f,-0.11988803896021981f},
{0.40746342996165935f,0.4142929512483647f,-0.07219729811430758f},
{0.41498317157447534f,0.4266827373342465f,-0.05729011759584365f},
{0.41704566423034906f,0.4390143268450322f,-0.07605150754714936f},
{0.4070496029957572f,0.44676086065335957f,-0.08987081540132595f},
{0.4061272747166506f,0.44422399228559345f,-0.12418633910788084f},
{0.4134564554275497f,0.4367739584365103f,-0.1286419287320277f},
{0.40119497952028077f,0.42145483353878604f,-0.16716164875193626f},
{0.3963381875222553f,0.40725232687350377f,-0.16904158362393637f},
{0.39605526407243347f,0.40232716468317986f,-0.1458827517528203f},
{0.407181924826266f,0.37779699911960224f,-0.1376488723580382f},
{0.4406199857355921f,0.34636262553137787f,-0.09245542518891547f},
{0.4396837165411837f,0.36149645800752195f,-0.07688165601249497f},
{0.41460513075329425f,0.4013639039559136f,-0.08325685612836074f},
{0.4113881269655676f,0.3962787388995535f,-0.04777800649234121f},
{0.4004417323819594f,0.40875898263613364f,-0.033919933501940266f},
{0.404220854017911f,0.41559794182263216f,-0.028802497808307147f},
{0.405702666436278f,0.4245593325889109f,-0.023322998844569367f},
{0.41338022235503863f,0.4362333192870095f,-0.048803872787120804f},
{0.404697053884016f,0.4416761003743756f,-0.04947088640820195f},
{0.39718229708865105f,0.4580844461318998f,-0.07825664651264352f},
{0.3992344546413349f,0.4567426165667702f,-0.10998971924428176f},
{0.38305168674719337f,0.45731117898077944f,-0.15455252644856413f},
{0.38746012140062874f,0.4445766638706448f,-0.15875842367682388f},
{0.3856151408080335f,0.4339241355373161f,-0.17262633456355894f},
{0.3721248670275112f,0.4194783821043388f,-0.19617848786740827f},
{0.3768316661659f,0.4109347502752724f,-0.20091596615616836f},
{0.3934069852471113f,0.4098253457918703f,-0.17880477356551988f},
{0.3773059207633019f,0.3999089619559141f,-0.1960456380202171f},
{0.3825680298406599f,0.39613308278860304f,-0.17062155402481916f},
{0.44945703760365724f,0.3005916800361438f,-0.09419772831616507f},
{0.48435028380437184f,0.2779727170688653f,-0.038818429256196635f},
{0.48279175279312425f,0.30192309375508986f,-0.02981595730466457f},
{0.4684366184968326f,0.3245375181161979f,-0.0397826419008619f},
{0.4622212183271113f,0.33035534190990123f,-0.031038671830789528f},
{0.4414292005174209f,0.3623850665251007f,-0.05169870140602382f},
{0.43530827071270173f,0.36510844270898335f,-0.037650786763794054f},
{0.42491070113078155f,0.3636205118840303f,-0.021692834986634404f},
{0.41349880619013774f,0.36913502674682575f,-0.0015874067243590718f},
{0.3950029640088972f,0.4047332910208528f,-0.009488290326757923f},
{0.389598764261204f,0.4132538229168748f,0.010298053311017335f},
{0.38837880137131087f,0.4228275048026822f,0.00985579100004159f},
{0.4042335795386766f,0.4333539933228912f,-0.02254212272870338f},
{0.39256911626420005f,0.4372251120384601f,-0.022552218790135636f},
{0.39167459013511136f,0.4548469357485965f,-0.05017251115096468f},
{0.39039383627024665f,0.46857624172502577f,-0.07093087081878033f},
{0.39181449224535514f,0.46635208459729866f,-0.10355360597654625f},
{0.3802705984461769f,0.4656720309827398f,-0.14680605213507425f},
{0.3594267457593658f,0.4594868648145166f,-0.18865566527193894f},
{0.36405824461930203f,0.44066266637580553f,-0.18974735835471626f},
{0.34508409475485874f,0.42706694012073404f,-0.21614157260628927f},
{0.3366068464154833f,0.41171271858095837f,-0.2292120210664059f},
{0.3336635263168421f,0.4009941297299135f,-0.24062987399005648f},
{0.35236075214837503f,0.39575293308791626f,-0.2236078379219158f},
{-0.09498956901184909f,-0.7741592299930385f,0.24952974390719732f},
{-0.09187149345230176f,-0.767791364740703f,0.24245919044187983f},
{-0.07329513244543902f,-0.7563045349898938f,0.2423261376747967f},
{-0.09056348457744197f,-0.7616421865746853f,0.25883821374380794f},
{-0.10277726899805463f,-0.7672150616233796f,0.27505796405386623f},
{-0.354313415209516f,-0.2211243810444627f,-0.23624277673510624f},
{-0.3671453573655923f,-0.2064646416797334f,-0.21395251318302147f},
{-0.36248433419257564f,-0.18731946434339442f,-0.22304916439981554f},
{-0.3569553716459522f,-0.21103089063911362f,-0.23887184510238174f},
{-0.3707664214042103f,-0.18695277003763966f,-0.22957111596908536f},
{-0.3728311833631692f,-0.17041773533582286f,-0.20782368012659297f},
{-0.3831277572713091f,-0.22384897262288167f,-0.1996725580506919f},
{-0.3808196678016615f,-0.29834299297445815f,-0.20982835867418284f},
{-0.3600832341062587f,-0.24128947625424496f,-0.23010482503243207f},
{-0.3573314066411853f,-0.2637787510999792f,-0.24235118393895175f},
{-0.35355066483332115f,-0.23864107631443227f,-0.25301696474732055f},
{-0.36378180716916925f,-0.20320694873523593f,-0.2423485895390762f},
{-0.38014289702723997f,-0.17332316253505295f,-0.2253522286805149f},
{-0.38864766279133994f,-0.1558725267203918f,-0.203264907330982f},
{-0.3871199734788588f,-0.15584569773592916f,-0.19363173060773303f},
{-0.39477216016148986f,-0.2071536110206461f,-0.18928686300088032f},
{-0.39975519489252714f,-0.2878403363862757f,-0.1945440680037806f},
{-0.40748256073912015f,-0.33755316226936066f,-0.1923749680360666f},
{-0.39610179009772056f,-0.37685151991187643f,-0.20103726550563342f},
{-0.39124730883668496f,-0.3959541425033276f,-0.2125561130406565f},
{-0.36857817259810266f,-0.31573713312892954f,-0.23072599150681772f},
{-0.3608465316224763f,-0.30283880535834673f,-0.2520494076428648f},
{-0.3537737077916658f,-0.31361526781251275f,-0.2602739251000124f},
{-0.3435603374136878f,-0.21630483387708332f,-0.25529530679824736f},
{-0.35785913753577686f,-0.18687147140468371f,-0.24539383704314838f},
{-0.3784323471446591f,-0.16339421466431847f,-0.22727923778023276f},
{-0.3928754254347673f,-0.14087146334844525f,-0.21001738014718122f},
{-0.40077689761109364f,-0.1459999937668534f,-0.20432174706309672f},
{-0.3955648799996379f,-0.14217783186564417f,-0.19468929915160646f},
{-0.3912961041650572f,-0.132553165028965f,-0.18677684486573304f},
{-0.408477270862421f,-0.2837305095091824f,-0.18791471869125867f},
{-0.42576506611978143f,-0.3768635166208834f,-0.17735039889129162f},
{-0.42161264412630345f,-0.42535451508836597f,-0.1742299934714137f},
{-0.4256887523042769f,-0.46892043317092613f,-0.16710790897760947f},
{-0.43633341881980076f,-0.5126581882801344f,-0.15723839432466338f},
{-0.39354599599720114f,-0.42352493515940537f,-0.22191684271751258f},
{-0.37696074765258375f,-0.37094891172518785f,-0.23630052816132915f},
{-0.372805529401746f,-0.4043077000132545f,-0.25382312085706005f},
{-0.3516072022238273f,-0.37409223646878226f,-0.26254314956710134f},
{-0.34211394673416257f,-0.3441361481049907f,-0.2625999692616735f},
{-0.33623873485770794f,-0.26892041181652915f,-0.26092688625297145f},
{-0.3270048364877911f,-0.20457629572509f,-0.25523378594910945f},
{-0.32199367450994565f,-0.12497838644188429f,-0.24445315035705997f},
{-0.33693921538725774f,-0.12945815009337303f,-0.24106151328532552f},
{-0.3670693080896327f,-0.14371463982437097f,-0.229419644237775f},
{-0.3661684595716582f,-0.10654122741851738f,-0.21226427280207336f},
{-0.3859635574497999f,-0.11275168314228431f,-0.20437508099763954f},
{-0.39356532756973833f,-0.1077131248542048f,-0.2013114347150886f},
{-0.40526817032640383f,-0.13278725277891745f,-0.20379914334860316f},
{-0.41408771477614403f,-0.11591032674411209f,-0.20482878862796808f},
{-0.4092580354254668f,-0.13006063412639424f,-0.19603538472242876f},
{-0.404876835596278f,-0.12101583691006161f,-0.1883057092012536f},
{-0.3951035538428935f,-0.10193753070859903f,-0.1804388481466088f},
{-0.39359799236030935f,-0.0834805131584204f,-0.1739924401471803f},
{-0.3948139032268097f,-0.13586784021642984f,-0.17167130112238463f},
{-0.41845367649009313f,-0.06411600066699877f,-0.1516373729058202f},
{-0.4292745571524484f,-0.1783263808896922f,-0.14674890840611954f},
{-0.44651452918458395f,-0.24222355795096956f,-0.1329908281765249f},
{-0.4604937283519767f,-0.2815154306562042f,-0.11861656522758814f},
{-0.44681451490385754f,-0.30294109716965695f,-0.1186575284855744f},
{-0.44640510436722763f,-0.36456418712329236f,-0.10316087311774051f},
{-0.4409284016608496f,-0.40140559708806645f,-0.11192543158879108f},
{-0.426816919972037f,-0.39625177817652224f,-0.1324494187813608f},
{-0.42160202536022795f,-0.3592816521933514f,-0.15644549175237174f},
{-0.4298741227512115f,-0.381926067264569f,-0.15220530743681288f},
{-0.4263749657593266f,-0.35765260386361847f,-0.17306717431047514f},
{0.0303927018524338f,0.7336211423008895f,0.16324355779979952f},
{0.030538899791368056f,0.7247461964710054f,0.16803846454280782f},
{0.05017293664529315f,0.7223399893903387f,0.14891372368312994f},
{0.04262679632317809f,0.7063408119404635f,0.16938748767122877f},
{0.024271457575002528f,0.7132235402039782f,0.17817352590341132f},
{0.015726659222159156f,0.715674813561599f,0.18689102183323003f},
{0.025171677147552553f,0.7262090820942112f,0.18526718992585134f},
{0.010500706007440576f,0.7215352324716869f,0.19686133773932693f},
{0.007907149683670836f,0.7297471455225593f,0.19495326605884827f},
{0.012861158370891338f,0.7368581257299182f,0.18033652658787977f},
{-0.015089112544136384f,0.7279644156532682f,0.200354780039594f},
{-0.0308163422792903f,0.731937016625395f,0.1858561176351984f},
{-0.0633022488726112f,0.7446656948670136f,0.1666082638959214f},
{-0.05162522475057972f,0.7472539519006199f,0.16405331015998084f},
{-0.02999137730165672f,0.7460489838345775f,0.16994012246732873f},
{-0.06788662994610943f,0.7528244365317385f,0.18480268292011937f},
{-0.06346259383396283f,0.7659580663844022f,0.20007515961565825f},
{-0.045502845821605784f,0.7872483715185975f,0.19965740067844587f},
{0.2000913703652493f,0.09923065903006725f,-0.22589219957550233f},
{0.20566623105414325f,0.031169915317369734f,-0.22045754378307825f},
{0.19149345162183326f,0.08233946804557749f,-0.23273326551669096f},
{0.1940903205331592f,0.15667429508586997f,-0.23009846227204922f},
{0.18951278455319004f,0.2033848340495546f,-0.23466708252566457f},
{0.16155041387559765f,0.19835697527054424f,-0.2516114661444583f},
{0.152809088138568f,0.11880526691583523f,-0.25813013487359066f},
{0.16953318362247224f,0.06287096070312387f,-0.2500605143505375f},
{0.21012252930430037f,0.027472011571380402f,-0.21852895488294474f},
{0.20347060595060068f,0.1070572760768142f,-0.22888686796848676f},
{0.19560234570486815f,0.18969135458934328f,-0.23557854874730674f},
{0.1936978511514907f,0.23027030461073636f,-0.24213774514722272f},
{0.1852051012197383f,0.2536413790023857f,-0.24528394582876276f},
{0.14634199080941918f,0.2677599129542508f,-0.266699157186943f},
{0.1151764775788162f,0.1855753668093512f,-0.2756142460959829f},
{0.09768134281297229f,0.15371804760897897f,-0.28860671913477787f},
{0.11520675088940363f,0.1164080573669238f,-0.2847771607503852f},
{0.13196491141737435f,0.07493125800480792f,-0.2852935631904833f},
{0.15416508172463994f,0.03685367386934556f,-0.27300827766175195f},
{0.11175856822431231f,0.0701139801405138f,-0.32081731867987745f},
{0.10203151927165886f,0.06721763227844044f,-0.32972124168281897f},
{0.10204437653099312f,0.047020762575833194f,-0.3086005850151801f},
{0.10924614798510335f,0.035063000376848265f,-0.2972151546531195f},
{0.09373540933932084f,0.06670917239914077f,-0.3349933203950796f},
{0.09020174321690426f,0.0494581757611457f,-0.330304191223411f},
{0.08985032846029378f,0.040271288936885696f,-0.3240582330178086f},
{0.08181405160640316f,0.0498535635770722f,-0.3163940506885784f},
{0.0929058696336511f,0.03234375802175993f,-0.30363205852521613f},
{0.35121779151424803f,0.19860281537570704f,0.2524312593208656f},
{0.34746533631436394f,0.19218704721756083f,0.25830022955142795f},
{0.360140599878446f,0.16598706129967017f,0.25366956149440023f},
{0.3539279152230907f,0.1712134246038039f,0.25960396329725444f},
{0.3536239582234179f,0.18704425078706052f,0.2676233096202617f},
{0.34570011492580566f,0.19787064322114153f,0.2729582265673465f},
{0.3480943667313701f,0.20741425471625355f,0.2707095501297389f},
{0.344089141340169f,0.2227103593615192f,0.2611827990465946f},
{0.337861015649682f,0.2337059944223728f,0.259929440429556f},
{0.2695134579497573f,0.19541564081210264f,0.31050050059089024f},
{0.29722220638496805f,0.18053048613238581f,0.2939489921935491f},
{0.2819741268224114f,0.17334169305210026f,0.31011534694941145f},
{0.2596350477562059f,0.1696818851254141f,0.32430488480253933f},
{0.2424883296321286f,0.16957229882207034f,0.3294422289561513f},
{0.2199194379450039f,0.18541844386356032f,0.3269794252865529f},
{0.22570917592580353f,0.20772510143058365f,0.31962698103180653f},
{0.20532877739858313f,0.23736053386872194f,0.3021773800023538f},
{0.18423979323261946f,0.24723809307361644f,0.29007629155274894f},
{0.21116443370740176f,0.2548368640163031f,0.27520747033072535f},
{0.19931974463419774f,0.25743184927857926f,0.2565485443007954f},
{0.18169447553552878f,0.2680987243669939f,0.2544837419703397f},
{0.1728089523734737f,0.2824900899568794f,0.26238628717855567f},
{0.16046534703034035f,0.2904896786818171f,0.259872783283379f},
{0.153763554253971f,0.30666936665571326f,0.25825033994300983f},
{0.151546733052182f,0.3177604048756276f,0.2510266127690681f},
{-0.2844455434321373f,-0.6147278649907494f,0.12160827056518643f},
{-0.29460225666393824f,-0.6084551585436782f,0.11893050248624171f},
{-0.2812529792737054f,-0.634962829450252f,0.1185554300324858f},
{-0.2827772837548992f,-0.6129115779083258f,0.13605274273434315f},
{-0.2764178890800444f,-0.660032256220399f,0.1330827349514782f},
{-0.27787970060895284f,-0.6774322321809787f,0.1176565469689625f},
{-0.28167152757992164f,-0.6644155638666857f,0.11444073945243156f},
{-0.2906717652878262f,-0.6439009577350912f,0.11469031817068287f},
{-0.2992476975015842f,-0.6087891062534605f,0.11056813017870322f},
{-0.3034758043651425f,-0.5802197129366764f,0.11826211092222912f},
{-0.29864213354831765f,-0.5864603208565402f,0.12783312828924545f},
{-0.28803740719205756f,-0.6010869088479208f,0.12587784745525699f},
{-0.2926345392841089f,-0.5859931185221905f,0.13719737453595748f},
{-0.28157963142904646f,-0.5945488278032576f,0.15103782749280545f},
{-0.27154600026701814f,-0.6141742570290942f,0.1529202048403641f},
{-0.2678336286514524f,-0.6540939840658876f,0.150397591860612f},
{-0.26594335867626245f,-0.7106173996596817f,0.147030576089908f},
{-0.2689805605659785f,-0.7394229885435164f,0.1402432095515494f},
{-0.2773101459060477f,-0.722687342561886f,0.11543871223012143f},
{-0.2880347936688413f,-0.6960162627098324f,0.11444548629053315f},
{-0.29641254539185846f,-0.6543107258835026f,0.10371909617892872f},
{-0.304482044800421f,-0.6584025587594933f,0.10181199660159751f},
{-0.3095679397309477f,-0.593932321049533f,0.11275259043855523f},
{0.32852344646311554f,-0.5130384994668087f,0.17890522209927726f},
{0.33415946359526805f,-0.513107720647764f,0.16350891221164307f},
{0.3363338522290676f,-0.5054963059897131f,0.16171236254154062f},
{0.3467418780286681f,-0.49891380567445287f,0.1793575103527697f},
{0.3433307882699059f,-0.4962508156881654f,0.16069731793272848f},
{0.3265503182403025f,-0.5029333374492428f,0.14520575787275833f},
{0.32945071918817653f,-0.5135189957101031f,0.14582152519064617f},
{0.33773481222575935f,-0.5342670404604772f,0.15657578863359192f},
{0.3374991839844802f,-0.5241211882237328f,0.17122467656493504f},
{0.3307882120046199f,-0.5316188020066519f,0.180245450615835f},
{0.3166615729435613f,-0.5196756309165494f,0.18632603548391413f},
{0.3143758949666963f,-0.5106389388094105f,0.18423873029360402f},
{0.3360041605249779f,-0.5025755599322496f,0.19147339070633343f},
{0.34907104248207155f,-0.4883701348327093f,0.18518040076932585f},
{0.34967474190962905f,-0.48232276189522405f,0.16894991057870157f},
{0.32975702729633605f,-0.5291480748995957f,0.140060865311646f},
{0.3259720284203716f,-0.5440980736400847f,0.14041951506545244f},
{0.3308014241081631f,-0.5483374271527349f,0.15967258628949152f},
{0.3381049912291357f,-0.5364313787163804f,0.16553608511982487f},
{0.33257604886826064f,-0.5460417795409673f,0.17112111836351349f},
{0.3181957068218267f,-0.5418142601889289f,0.18229764854001562f},
{0.31278555015353476f,-0.531668246466197f,0.18643107361941702f},
{0.30379019633433946f,-0.5214964566051437f,0.1848482155941027f},
{0.2954774915919864f,-0.5191212123377341f,0.17852097894129287f},
{0.29968598322012174f,-0.5071365404112929f,0.17738752260744725f},
{0.3024035235978961f,-0.5001237989294435f,0.18843343293075449f},
{0.3198986371155838f,-0.49917042709408627f,0.1973863329338041f},
{0.33579791529654024f,-0.49081297904675386f,0.1978831212008871f},
{0.3404624847868314f,-0.479177006362557f,0.1956349812792243f},
{0.3493887789110587f,-0.47405998713278596f,0.18240719553427032f},
{0.34108085500385743f,-0.46044577923142627f,0.1642181873530561f},
{0.3379770868903068f,-0.47226169405146484f,0.1496379628385673f},
{0.33192270206126595f,-0.4604021716403973f,0.13918446492222872f},
{0.3335316900067031f,-0.4396782807316165f,0.1341602640133132f},
{0.33725362754220306f,-0.4279557409341267f,0.1340494102574504f},
{0.34803377761388266f,-0.45146209808685545f,0.13399147609708398f},
{0.35376199474554465f,-0.4350070648180568f,0.14835895026010557f},
{0.3676058325336798f,-0.4866765654141788f,0.13800636727455357f},
{0.38372298612138583f,-0.49942315797631415f,0.14720302081382425f},
{0.4029306967815071f,-0.5632091264375197f,0.12595782339048767f},
{0.39727522696232687f,-0.5707320297759826f,0.10877631247299295f},
{-0.2585834977525843f,-0.4129540294934151f,0.28717337801040077f},
{-0.26791869564491555f,-0.39923785487753544f,0.2796796345791388f},
{-0.27072580231323456f,-0.37886801349673754f,0.2838299285697704f},
{-0.2432804832069131f,-0.3981364747603333f,0.30593516317741226f},
{-0.2271980406072228f,-0.4102471068193084f,0.32255992671816885f},
{-0.2131616977108754f,-0.4201376348363573f,0.33347361507730156f},
{-0.18385690995663356f,-0.4495971782244546f,0.3526767467597554f},
{-0.16026709642068387f,-0.47087110952945976f,0.3683749663872097f},
{-0.152902343109034f,-0.48968809421913106f,0.36939328427448886f},
{-0.14833840382423594f,-0.48479656998493353f,0.3650927339470832f},
{-0.15261396844473182f,-0.477826625476953f,0.3569044275977812f},
{-0.16513538792086058f,-0.4590384968458486f,0.3364799147110058f},
{-0.16771868138517174f,-0.4599339961404924f,0.324453216056359f},
{-0.16530878562458362f,-0.4828454070436222f,0.33118360035175026f},
{-0.16699990300588527f,-0.4857374595909139f,0.32396749170422445f},
{0.21576576018549265f,0.12102569499214404f,0.33173846407943863f},
{0.20132249809883318f,0.1356983224260341f,0.3309978627812971f},
{0.19402541591514177f,0.12781472419872764f,0.332812446823999f},
{0.19920853603412586f,0.1131455007194655f,0.33408795345668296f},
{0.17291205480194424f,0.11841376963731425f,0.3408915716473334f},
{0.17768167092700082f,0.12590416967119356f,0.3356679238575657f},
{0.17777066989177412f,0.1306054570378565f,0.3245332174893772f},
{0.18276953237438648f,0.13746808348317074f,0.32689221010449493f},
{0.20067557567187444f,0.15594885115997448f,0.3299718041907036f},
{0.2344107240519646f,0.14634801413050616f,0.3326192522131173f},
{0.2568805260249226f,0.12327108858961422f,0.3242953199450128f},
{0.23314451879966994f,0.10640632181221096f,0.32446280003722616f},
{0.19518027126712564f,0.10176339356903909f,0.33056567528359737f},
{0.17434742193801775f,0.10967698356886293f,0.3409002642680467f},
{0.155316736041888f,0.10891862943619195f,0.3360265321774676f},
{0.14086949205075108f,0.10779714856319704f,0.3292390030907138f},
{0.15733379589011248f,0.12335238722257016f,0.3321084412253308f},
{0.14752128366588227f,0.12645550832976354f,0.3154007588797058f},
{0.1599945983787161f,0.13763878585827619f,0.32456973244585685f},
{0.15871890901188862f,0.14834116342852616f,0.3252963120857028f},
{0.18021108225433846f,0.16093342638233835f,0.3256014037369182f},
{0.19521101097474233f,0.17507708734135202f,0.3255210782695176f},
{0.25172642238808507f,0.14428969673733158f,0.3298619937193117f},
{0.2681924590145869f,0.14428580619992606f,0.3236414472461515f},
{0.28308217248622264f,0.12317147192117323f,0.30951310620777905f},
{0.26758211316376085f,0.10214954056182157f,0.3050069990921975f},
{0.2567137949302164f,0.10550490596846518f,0.31624865805476526f},
{0.23812970278170967f,0.09797851686997283f,0.3159431403780174f},
{0.1978425526274028f,0.09378342007952431f,0.31771162442096473f},
{0.16611017896010455f,0.10132715404794647f,0.334206841140416f},
{0.1449744052917165f,0.09786706604091996f,0.32644895869184676f},
{0.13691071194184348f,0.09388173954802755f,0.316715171948853f},
{0.12464178855581629f,0.10063737408987362f,0.31532681635843635f},
{0.14116043030510236f,0.11908555665669224f,0.3242638503632297f},
{0.12702420620076885f,0.11235966953356684f,0.3144079536536109f},
{0.1217427857366221f,0.1173088240794968f,0.2993529274016971f},
{0.12063779980730786f,0.13198047941023938f,0.30972234955106065f},
{0.13405617832641328f,0.14697019520435178f,0.3165083392088956f},
{0.15747195458913749f,0.16158446245234298f,0.3170543073959787f},
{0.1672489037742871f,0.16719397463441535f,0.3146003376473325f},
{0.15949683800848558f,0.176147584325883f,0.31585643196448554f},
{0.1616749546312954f,0.1882216599944738f,0.31608176547407163f},
{0.18596422453566472f,0.20761519003044968f,0.31393681934795103f},
{0.18083930205418436f,0.22995345954190285f,0.307457219603677f},
{0.14410551293830273f,0.23469794865981072f,0.3079597618714669f},
{0.12985718993615145f,0.2382620315178693f,0.2968714604140748f},
{0.15284118560336768f,0.2435782044039365f,0.28661176586829396f},
{-0.4300282090681458f,-0.10919092455826783f,0.1290493376923409f},
{-0.4439524126951786f,-0.11822615691707389f,0.07872576543068502f},
{-0.4506207491871575f,-0.13219117187777588f,0.05547601801110374f},
{-0.4379768139046196f,-0.17664237632868834f,0.05558471295429366f},
{-0.45046119253240197f,-0.15910314738903786f,0.036359683984437924f},
{-0.46978655529597146f,-0.13987748309931086f,-0.005562125075254141f},
{-0.45929184126858746f,-0.13408162458710937f,0.025841817966026727f},
{-0.44872985132895093f,-0.1257732151595381f,0.044923667297540534f},
{-0.4394025768740776f,-0.10757533056105915f,0.08823572303355363f},
{-0.4356723313094919f,-0.09462010341531825f,0.12575688701388382f},
{-0.42613099017987294f,-0.07032118791042873f,0.15988993580437452f},
{-0.4266182943324231f,-0.12758180191014437f,0.12805620843186344f},
{-0.4265949096740852f,-0.1719872091475285f,0.09879557540867352f},
{-0.4326968733745542f,-0.2039290694494972f,0.06341445985445313f},
{-0.44079810584203716f,-0.22252436787559918f,0.0062752599442461345f},
{-0.45153671470588114f,-0.18324222151387837f,0.005088164764815819f},
{-0.468177688465025f,-0.15013283983399758f,-0.02782385660315452f},
{-0.4753546070132018f,-0.12723285831410336f,-0.035227396299184956f},
{-0.46405651401009745f,-0.13226306820160041f,-0.0038022975311545856f},
{-0.4509620328228779f,-0.12832564567692648f,0.011471081148616183f},
{-0.4433213562664762f,-0.12190379735887535f,0.038162225634597015f},
{-0.4398375191952324f,-0.11680063830141256f,0.05333479774917791f},
{-0.4352043183579821f,-0.10873231391588943f,0.0742505106379481f},
{-0.4301101557698668f,-0.09446836714446284f,0.1036286279041521f},
{-0.42520995910070425f,-0.06850636057633801f,0.1433259441152487f},
{-0.42858822152050036f,-0.0725797128684485f,0.14853510384969157f},
{-0.4118274878408103f,-0.047771770158487985f,0.17316691315581448f},
{-0.4131221029403911f,-0.05526087299242958f,0.1771182978439466f},
{-0.42154561150543973f,-0.08852280049791805f,0.15715419850560558f},
{-0.42381021449854883f,-0.09627460384899016f,0.16177941534815274f},
{-0.43097351616580626f,-0.1357403395925694f,0.13269921210598998f},
{-0.43281363305544085f,-0.18555140526357172f,0.09702640611268785f},
{-0.429870880282571f,-0.21666869049157375f,0.06850367799661401f},
{-0.43469375066158455f,-0.24882713112517f,0.03954473267001161f},
{-0.4391184369673119f,-0.2580625699864134f,0.00995223106912638f},
{-0.4492012692974965f,-0.19122373549471974f,-0.044025389806469785f},
{-0.4694911081828685f,-0.13864949478080985f,-0.05067385820996666f},
{-0.48117352508695094f,-0.10925738985336023f,-0.05130786282034591f},
{-0.4692501307182587f,-0.11961739057025178f,-0.02943346286993782f},
{-0.45725317948233263f,-0.125607294681992f,-0.005510932954859198f},
{-0.45832371683836043f,-0.11844630375172446f,0.01728580483632566f},
{-0.4422745679746656f,-0.10544552268384397f,0.06587496022391634f},
{-0.4358109362197977f,-0.07163169025642198f,0.11810548651303324f},
{-0.005386945182427316f,-0.4940799935573891f,0.2394304378814883f},
{-0.003834912919762332f,-0.47756352018244624f,0.22623731319138304f},
{-0.010225232161192819f,-0.47596381343165006f,0.22427111399231622f},
{-0.0046571889432250255f,-0.4298769142277362f,0.2364288192166013f},
{-0.0017414585130394425f,-0.4068581863243479f,0.24449319144506584f},
{0.006338595917129965f,-0.4006334645884887f,0.2551316566861943f},
{0.00013796321598769068f,-0.5125943163225098f,0.22411297565198904f},
{0.0004765164636326822f,-0.5130602225193295f,0.21705206778719174f},
{-0.00034121989125165286f,-0.5367525201624034f,0.2115416856907828f},
{-0.02501994193910496f,-0.49706493560685966f,0.21979524194064087f},
{-0.017857769611351104f,-0.44286505051784475f,0.23071448244299617f},
{-0.03048220333610187f,-0.43326680788825206f,0.2341093821691196f},
{-0.019913338555517395f,-0.41490956955490954f,0.23962922606949738f},
{-0.019761542789824584f,-0.41195948085610157f,0.24934240528817225f},
{-0.0031591758681412383f,-0.4070660113532012f,0.2619092161380454f},
{0.3064741805613889f,0.21497087675383653f,0.2672454908423132f},
{0.3100829238566175f,0.1997437499981374f,0.2739228450517957f},
{0.31617216097391326f,0.17989347278308448f,0.2770529364436906f},
{0.3150788880907202f,0.15387432142359705f,0.2799346145787035f},
{0.2850084718975225f,0.14654319544399536f,0.31215554816458513f},
{0.2981142199195825f,-0.4891148710220529f,0.19169417498567085f},
{0.30320813921630907f,-0.4802133798705918f,0.1957475773838979f},
{0.29538849262721306f,-0.474014919793424f,0.18826483731033913f},
{0.28879087637361145f,-0.48264341675846945f,0.17733710604475467f},
{0.28870888823798585f,-0.4754805613024928f,0.16851371142910576f},
{0.2969947045010387f,-0.4647606763139179f,0.18340117578340473f},
{0.3075948508172237f,-0.46734893334752414f,0.19707572951086283f},
{0.3206396038820125f,-0.47692739819329877f,0.2023052949121403f},
{0.31291284785750323f,-0.48759427328171334f,0.20072696593132622f},
{0.2904826620094264f,-0.4954665249935935f,0.17394836722152987f},
{0.29065328364153825f,-0.48501120398545045f,0.15147211218352497f},
{0.2915484578393917f,-0.4688139267878278f,0.154110694412752f},
{0.29575034341575546f,-0.4556239627609617f,0.1706367719543104f},
{0.3050155095099712f,-0.45365091421873444f,0.18220878237621868f},
{0.3126412316140189f,-0.4580082842407123f,0.19424225919270255f},
{0.3222598182907932f,-0.4589349088970083f,0.19777277421355036f},
{0.33576091375728284f,-0.4676846648400219f,0.19649860515230105f},
{0.2339590031242434f,-0.9386776256398046f,-0.21064491044435746f},
{0.22425153859718627f,-0.9416048555721414f,-0.2245902687357319f},
{0.18686641062507384f,-0.9391989725258573f,-0.2342355845306345f},
{0.15258391611496924f,-0.9283528033703661f,-0.2378201729218619f},
{0.16870741333971756f,-0.9539620576104458f,-0.24735156566473446f},
{0.17580185716949115f,-0.9686406833988394f,-0.25973166577859913f},
{0.16811463546446181f,-0.9716429713806475f,-0.26911906295393057f},
{0.16369773023354556f,-0.9715515405643939f,-0.2971785982627351f},
{0.17279462580413632f,-0.977781936620374f,-0.3146093755505846f},
{0.19894105361943598f,-0.9882954552660208f,-0.3015146107004794f},
{0.19668309704959536f,-0.9936087915232314f,-0.30007502793021f},
{0.16818233633983892f,-0.9963139304146226f,-0.3003470500134783f},
{0.1365517487777326f,-0.9977700070661646f,-0.2928949285330456f},
{0.1295175583445778f,-0.9826376343383535f,-0.3032412093154601f},
{0.12298975078345133f,-0.9791128637565424f,-0.31303945552759815f},
{0.09850146002376224f,-0.9970095461788036f,-0.29937612932589147f},
{0.06162162064363215f,-0.999455632861489f,-0.27884490713612575f},
{0.010883013458392559f,-0.9991858811437135f,-0.2414320779427374f},
{-0.0042809053445639995f,-0.9973838600733823f,-0.2638965296299571f},
{-0.020573783309100372f,-0.999456443478649f,-0.2900789263241213f},
{-0.21064647059022854f,-0.999363391428075f,-0.2701477563158964f},
{-0.29872866029011375f,-0.9994514182897007f,-0.1852682842058972f},
{-0.3412258641084505f,-0.9989950769504077f,-0.12605784483630486f},
{-0.3751498097934907f,-0.9997886084681238f,-0.0860172848470757f},
{-0.43531937606155485f,-0.998897486293663f,-0.0054734554569023305f},
{-0.4218689404491465f,-0.9987960050995128f,0.018344657831243106f},
{-0.3623416167016317f,-0.9967712438570632f,0.04631407545984891f},
{-0.3614809718200583f,-0.9889620534856475f,0.07439970244209505f},
{-0.36429703458622786f,-0.9915561473877699f,0.10696592175392285f},
{-0.38353728892242955f,-0.9816372498949318f,0.13928487202208145f},
{-0.37667365000247094f,-0.9983740315905125f,0.16972805099445304f},
{-0.36096858103185625f,-0.9991280075405924f,0.1836956603550306f},
{-0.34869705368428316f,-0.9889627026168202f,0.19585675890986545f},
{-0.3215895122679043f,-0.9860795657958824f,0.1860482392141906f},
{-0.30438040212028356f,-0.9771156624351296f,0.1833026533950095f},
{-0.3059356301056454f,-0.9796870601191758f,0.20145971603574112f},
{-0.3197939559491055f,-0.9863442923247092f,0.23038633016782534f},
{-0.32104386811520363f,-0.9957032594670062f,0.24101101597963923f},
{-0.31321812224286216f,-0.998471459698862f,0.2551716574027034f},
{-0.29752756257572843f,-0.9998977081886898f,0.26627558369177856f},
{-0.246863896575101f,-0.9989806483899204f,0.30975440770677126f},
{-0.22969967103269867f,-0.9998853874453003f,0.3139562730973866f},
{-0.20738786609982882f,-0.9988063795117917f,0.3322912412381854f},
{-0.16402693747967312f,-0.9982788727852484f,0.3293560676826423f},
{-0.14383814313884083f,-0.9987733099438446f,0.300577935666287f},
{-0.13385196017207984f,-0.9995516022839133f,0.27393469939815596f},
{-0.1363016739150333f,-0.9873023653146322f,0.29717114228471436f},
{-0.12643663731101257f,-0.9683988145740758f,0.28420732238459434f},
{-0.1243228781661972f,-0.9540708343590374f,0.29118279778764133f},
{-0.11525006631828438f,-0.955899279636455f,0.2950831784015611f},
{-0.0971253550578194f,-0.9665911202460312f,0.29532713379526637f},
{-0.08963006688559949f,-0.9588965413669073f,0.2981771999858494f},
{-0.10822019244806748f,-0.9464466123748193f,0.30477414798493757f},
{-0.10303865744153806f,-0.9375185344678766f,0.2861190519351679f},
{-0.09036712292887421f,-0.921771925351834f,0.2559278633467796f},
{-0.11410874710422615f,-0.9265588874092281f,0.28758120768420725f},
{-0.11212913394413203f,-0.9219972588614199f,0.2955777164888995f},
{-0.10800227454500537f,-0.920436944067457f,0.3016886766587159f},
{-0.09325330354819208f,-0.9116139149200952f,0.28537054632290915f},
{-0.07948356658009004f,-0.8933375693799247f,0.2766159277393425f},
{-0.08714330591985274f,-0.8869971004378232f,0.2844283998884877f},
{-0.07710387932321303f,-0.8771047897004667f,0.2590149750306621f},
{-0.06433401471796775f,-0.854073255533319f,0.22237750061974365f},
{-0.05838152435971579f,-0.8196584785017947f,0.2030346506235976f},
{-0.04667847124630356f,-0.830609696416867f,0.19766019829462522f},
{-0.03587489826960476f,-0.7920615867354208f,0.1834643083051926f},
{-0.032077903747041094f,-0.7500504706126901f,0.1825889618243243f},
{-0.04336807968713455f,-0.7299309282626395f,0.1996703694906003f},
{-0.030462929133586447f,-0.6892700315395255f,0.20317113709272736f},
{-0.03911456852798883f,-0.6674630806738432f,0.20993485655801863f},
{-0.013710940132592594f,-0.613130589029026f,0.2035206278287913f},
{0.00361995594727077f,-0.6241280078725949f,0.1987661372037463f},
{0.014876602296834704f,-0.6369606809652455f,0.19103018072758987f},
{0.010254668294424873f,-0.5860362395304418f,0.20259670912519104f},
{0.007155587524138539f,-0.5506377759190683f,0.21152218200818013f},
{0.34660039611800886f,-0.9287888803430635f,-0.0738266513550824f},
{0.37473338736530526f,-0.9288676663815453f,-0.08257616400670711f},
{0.36939565397511237f,-0.9349211991595214f,-0.08885488899403032f},
{0.3546079688376497f,-0.9426488476065923f,-0.08518722881120967f},
{0.3824072152950556f,-0.9502866875341374f,-0.09611738130419643f},
{0.3806571512787434f,-0.9346543658760041f,-0.08481951034432464f},
{0.3803119367341206f,-0.9349354651716136f,-0.07043557204744895f},
{0.3757015117955323f,-0.928176102640757f,-0.0710251584496391f},
{0.364344653829153f,-0.9259530812269804f,-0.06986639131209342f},
{0.35506208124535427f,-0.9231459745586614f,-0.057792963712267595f},
{0.3405304895108427f,-0.9168335510579667f,-0.05857148022038434f},
{0.3490946289978937f,-0.9539597883073605f,-0.08938621613906375f},
{0.356213917234338f,-0.9558965237505924f,-0.08918037675041005f},
{0.3646933126999005f,-0.9725533847561486f,-0.09484928177877393f},
{0.3783216240649573f,-0.9787747014749721f,-0.09997335327159741f},
{0.3919190129882536f,-0.9733213016215305f,-0.10136060395789015f},
{0.3881043888704667f,-0.9524858791407032f,-0.09411884134894113f},
{0.37629402619365077f,-0.9590137472590748f,-0.07765882326269118f},
{0.3744174750905303f,-0.9565240540477684f,-0.07128278171983872f},
{0.3735996271828257f,-0.9642173346645466f,-0.060525337427905467f},
{0.3814330532012362f,-0.9552096611643697f,-0.05923965930283465f},
{0.38613296262496766f,-0.9624316863609975f,-0.04970969549846853f},
{0.38512479710673475f,-0.9473819902090739f,-0.055854476358554776f},
{0.37497485141269277f,-0.9411832060975235f,-0.05389527842696547f},
{-0.19319437715205012f,-0.295239386346895f,-0.3030748840605378f},
{-0.21476596431599831f,-0.21609198259687404f,-0.2899225292701971f},
{-0.20474303266303914f,-0.2100608209401838f,-0.3006166391828583f},
{-0.17645531552930602f,-0.27370850958787385f,-0.3180714491978106f},
{-0.17550922862431192f,-0.2048982477882732f,-0.32256722121020237f},
{-0.1815123246538469f,-0.15924953337415473f,-0.3178983553427216f},
{-0.21058172852060628f,-0.13960440710749364f,-0.294779950213647f},
{-0.22027587895297024f,-0.1553940575512017f,-0.2862559538057519f},
{-0.22223034492016733f,-0.2196944035032167f,-0.27705909628418146f},
{-0.19351750423827271f,-0.34196273263674665f,-0.294768297724771f},
{-0.15994035289827102f,-0.37577429576108334f,-0.31865942392735086f},
{-0.14380044253524354f,-0.35218899108388535f,-0.3314423688975706f},
{-0.1471506701377109f,-0.27187260727002727f,-0.33568338401603803f},
{-0.1344246967863803f,-0.23115432352656964f,-0.34217538524669516f},
{-0.14745876096617802f,-0.16457794519820995f,-0.3364180687650776f},
{-0.14773555432292754f,-0.10639824645043616f,-0.32908661875109346f},
{-0.18425634023428275f,-0.10866495726064321f,-0.31032625189851015f},
{-0.2181838014267711f,-0.0924606277999682f,-0.2817215186482858f},
{-0.2383609549652133f,-0.1177758957376857f,-0.25788587456884354f},
{-0.2370255083462149f,-0.20646318193140048f,-0.2616520677641376f},
{-0.22533632284196567f,-0.28725203655994525f,-0.2718009999211274f},
{-0.19489598049845067f,-0.3822859525986601f,-0.29320928119315354f},
{-0.16385293207868187f,-0.40964859512909424f,-0.31008389649096896f},
{-0.14134965469799265f,-0.4473055826360799f,-0.318049037705028f},
{-0.13968127390626406f,-0.41994131887132546f,-0.32446598088621365f},
{-0.12016797438807161f,-0.40121203700889757f,-0.33496823375942775f},
{-0.1197396274946103f,-0.31403497201842795f,-0.3441258183138399f},
{-0.09339302292429202f,-0.2536791008541393f,-0.35394364045231186f},
{-0.11333305766329577f,-0.19224146480807144f,-0.34866361811684504f},
{-0.09851917142438685f,-0.15457604815750975f,-0.3506156724183101f},
{-0.12445435007045688f,-0.11648087479832098f,-0.34006470602212524f},
{-0.10427671632368389f,-0.07593418585253045f,-0.33883939284649345f},
{-0.11175341235920329f,-0.0418472774332912f,-0.32781927884725615f},
{-0.14355417640454837f,-0.037058207558799044f,-0.3149305977396013f},
{-0.16025879901567636f,-0.06425817208032764f,-0.3144674070571477f},
{-0.20059600132679647f,-0.06949280304205013f,-0.2904131576967893f},
{-0.22095350177845657f,-0.06234996866128035f,-0.27110787550326415f},
{-0.2317126788575303f,-0.06644666417782412f,-0.26048454744863325f},
{-0.24315776554301974f,-0.05544397685391815f,-0.2413153373851914f},
{-0.246693073085505f,-0.07014546034637506f,-0.2385838157206183f},
{-0.24570894029437498f,-0.12649055397624004f,-0.24573880829638234f},
{-0.2459397048326932f,-0.17622169895721795f,-0.24981082301705826f},
{-0.24056237550336743f,-0.24295192031112314f,-0.255475654773873f},
{-0.2349086884044948f,-0.2952314437860965f,-0.260795677825849f},
{-0.23063026590698607f,-0.3152548541653275f,-0.2643690811876374f},
{-0.2269518360961807f,-0.34784653514276465f,-0.26713768725927706f},
{-0.22424073922178278f,-0.3624011460673271f,-0.26721318939521377f},
{-0.21794122397599724f,-0.36699568375950287f,-0.2740247108375736f},
{-0.19747186685550033f,-0.43238816900557603f,-0.2883883157113459f},
{-0.17519402497554706f,-0.43564918516170775f,-0.3041323314899207f},
{-0.15085899929155405f,-0.46503318391755594f,-0.3158411726010896f},
{-0.11293503613840461f,-0.45195945261730197f,-0.329761039479436f},
{-0.09156609264041321f,-0.42361895931312693f,-0.33819443587398584f},
{-0.0830352107674921f,-0.354336794024611f,-0.3483124052177188f},
{-0.07894422994256607f,-0.2889660318310587f,-0.3549531839134763f},
{-0.04696735161672403f,-0.22283529533292287f,-0.36022595106599875f},
{-0.06759920719920634f,-0.19071673430134523f,-0.35808313294272454f},
{-0.0574557443176299f,-0.13821406587687737f,-0.3561254861265399f},
{-0.08587307839158394f,-0.11623349420183157f,-0.34983652802717674f},
{-0.06814155363806017f,-0.07274960462639384f,-0.34458540212177363f},
{-0.06840916035446404f,-0.03977315353669784f,-0.33544706733449714f},
{-0.09159194845932052f,-0.0045949982459620635f,-0.31792088901240256f},
{-0.12379415392030188f,-0.013380904739575995f,-0.31359699439815575f},
{-0.14816909957781035f,0.007787087508102225f,-0.29268902752473885f},
{-0.16881685834282226f,-0.01701347890442338f,-0.29406277288293237f},
{-0.18312075589759078f,-0.03444871299304182f,-0.29165917932548197f},
{-0.21611093435861858f,-0.032868216700292344f,-0.26261717283136443f},
{-0.21553469286094812f,-0.04954331499834008f,-0.2674549371054868f},
{-0.22688705259265382f,-0.03618807856269279f,-0.25206395731784265f},
{-0.22520608758039853f,-0.06513810816294144f,-0.2646778817045226f},
{-0.22903120722495485f,-0.04378417436251028f,-0.24571222260330852f},
{-0.23808929728782438f,-0.04017299921580124f,-0.24346624149431859f},
{-0.24202315330947527f,-0.011354441519812263f,-0.22661008553222717f},
{-0.2544066786261241f,-0.03869584758050323f,-0.22769711783193566f},
{-0.25633646273504546f,-0.09402880441173599f,-0.2409236382491862f},
{-0.25374155927817077f,-0.17135749029026062f,-0.2498857992611282f},
{-0.24579368325345569f,-0.2865249713997294f,-0.26374906955054284f},
{-0.2355735644610593f,-0.33616436153007107f,-0.2695238127074916f},
{-0.22152658261288796f,-0.3789106479222112f,-0.2712393675932722f},
{-0.21669060105907317f,-0.39365865743995515f,-0.27584709720324285f},
{-0.206783396426608f,-0.424648361301103f,-0.2814207626833489f},
{-0.20476868662446238f,-0.44017466315891557f,-0.2858921768718474f},
{-0.19265635258817324f,-0.46838757615864424f,-0.29063362750341454f},
{-0.17490787924283338f,-0.47971991481514303f,-0.2999989574060942f},
{-0.1574718345370547f,-0.4883083706921825f,-0.3071172331678944f},
{-0.12843726489761736f,-0.5149797735162108f,-0.31865451985289317f},
{-0.09225180463897599f,-0.5418256077667629f,-0.3304335956820696f},
{-0.08213996538831518f,-0.5341504826370748f,-0.32972959008340136f},
{-0.059626774680337315f,-0.5436085001844492f,-0.33107567459181586f},
{-0.3983641248501522f,-0.09616615113478126f,-0.21514690285448526f},
{-0.4042465494132388f,-0.09549963365814806f,-0.21766196742673694f},
{-0.3775345381754332f,-0.06662004169579881f,-0.22887853975365277f},
{-0.36348818421027845f,-0.0630517453283601f,-0.22593627356356052f},
{-0.3368719596607536f,-0.02655425270827103f,-0.23609440510978974f},
{-0.3651854412463224f,-0.02328059177436734f,-0.22011419376416455f},
{-0.38920195919325695f,-0.07091945737166191f,-0.22486441775943866f},
{-0.4089229934356387f,-0.09406049709915949f,-0.21275830518329347f},
{-0.40771830903248196f,-0.11688015315165308f,-0.2057019157389183f},
{-0.39690812894160366f,-0.10259707772758127f,-0.20342612665396242f},
{-0.37312245521357323f,-0.07844633199052407f,-0.2107022167217073f},
{-0.30854344181742926f,0.01250871998435451f,-0.23985893669926667f},
{-0.31959885537861f,0.008327888143590369f,-0.2366816913990681f},
{-0.3419739436951769f,0.015468453221274882f,-0.21859035461759216f},
{-0.3900470015537114f,-0.05512802314523837f,-0.21441977607461638f},
{-0.39952434961121525f,-0.054755655581770445f,-0.1993631084026339f},
{-0.41076846061101174f,-0.08662999774250561f,-0.19901756982362862f},
{-0.4124125048270034f,-0.10960463147208731f,-0.1930248290830318f},
{-0.40655662558549377f,-0.09558830858853891f,-0.18544579555266627f},
{-0.3926357855415921f,-0.06163019693069014f,-0.17840616452910898f},
{-0.1598164803970866f,0.4042756535440297f,0.16635498693607845f},
{-0.14869748810283726f,0.4168473270344558f,0.15956990988655348f},
{-0.14947687578535943f,0.372393206274101f,0.19407476847641114f},
{-0.17448897609240802f,0.37123646621065953f,0.17883852307446632f},
{-0.18081340586378006f,0.37601580974163773f,0.18580450586371797f},
{-0.15927057276724882f,0.4282482398655528f,0.16301696746177247f},
{-0.15427454797590093f,0.4327017407959424f,0.1556033880119238f},
{-0.15579917755388506f,0.456484455718218f,0.14943508119326068f},
{-0.15307387628704808f,0.47762371408422755f,0.1347372863807251f},
{-0.15579563123661044f,0.514812769382697f,0.11959415783623085f},
{-0.16730573515534525f,0.5454095587133034f,0.1119654121195517f},
{-0.1834427780796896f,0.5470233689277967f,0.10834393267947935f},
{-0.17376858710287946f,0.5778072737717875f,0.11513017519037347f},
{-0.1740048835986719f,0.5967605930062716f,0.1213875319693849f},
{-0.17555097168963182f,0.6107844951071468f,0.12039073421473451f},
{-0.17317739965211743f,0.6138286472687656f,0.11458851294215022f},
{-0.16419737637764137f,0.6076379289573198f,0.11242803972586522f},
{-0.1470585912526921f,0.6050072382933162f,0.13213184490076857f},
{-0.1199051017608756f,0.5890998156940773f,0.1291228244406592f},
{-0.09181314389048101f,0.5735213549247613f,0.11116095904953394f},
{-0.06058341448212252f,0.5614609365085866f,0.1034679206617368f},
{-0.042674550491895134f,0.5496145847671577f,0.09540836114065816f},
{-0.028140361170284477f,0.5382182530385439f,0.0951624849136298f},
{0.009729318255738776f,0.5397710693581736f,0.08633983717067234f},
{0.00693543962708015f,0.5296292702072298f,0.08687296828416961f},
{0.1171287953574185f,0.4931183636261134f,0.08961473687208416f},
{0.10857144465628285f,0.43649350720966595f,0.12836840759133747f},
{0.09996059747220924f,0.385308392331836f,0.15773133242583767f},
{0.05374406539195724f,0.3740391957587953f,0.16497652979924113f},
{0.01139999491074794f,0.3604761332318868f,0.179772350855724f},
{-0.010399661462900965f,0.3955044985828779f,0.17134858943761622f},
{-0.04240585268266888f,0.37884050457127544f,0.19300835538750738f},
{-0.07991986134638884f,0.35694722988368904f,0.21606268670147313f},
{-0.10946606215244309f,0.3338354509921345f,0.23364552216974482f},
{-0.1302458909573127f,0.3466592072960236f,0.2230210392778229f},
{-0.290546088818178f,-0.8926469788046917f,-0.13820487073726923f},
{-0.29409685758154336f,-0.8939295971952655f,-0.13241565971074398f},
{-0.291853510181518f,-0.8658475080310315f,-0.11984961804412635f},
{-0.2823332833447439f,-0.864400995174608f,-0.1249107100018868f},
{-0.2915940925045249f,-0.8240703181722658f,-0.10302404136607203f},
{-0.29336681236741646f,-0.8375553234724511f,-0.10279651929639436f},
{-0.295284520086745f,-0.8671888106418867f,-0.10301594581854875f},
{-0.2980922142665837f,-0.899249741361732f,-0.12096376405359095f},
{-0.29850142188332174f,-0.9275532745605545f,-0.14914332169767125f},
{-0.2866416349327091f,-0.9088048629830734f,-0.15261520349381266f},
{-0.279509824095391f,-0.898528836042007f,-0.148817357982592f},
{-0.28023314108084796f,-0.8566550286920521f,-0.1329869780106162f},
{-0.2821217292644724f,-0.8394854114300065f,-0.11173133393126958f},
{-0.28489722398836154f,-0.8255792432379812f,-0.10993250433400369f},
{-0.28914867513876086f,-0.7889360945069417f,-0.09402017766030699f},
{-0.29539534303278125f,-0.7808665547268822f,-0.08932404722116084f},
{-0.29629758967943565f,-0.7979802436545091f,-0.08335325157631746f},
{-0.2987959765738631f,-0.8291607517089631f,-0.08763613087459522f},
{-0.2949201152698239f,-0.8472427265528045f,-0.0877126571716621f},
{-0.30021416032599413f,-0.8779678664335206f,-0.09434153052548451f},
{-0.3029409202787563f,-0.9039981220794533f,-0.11110568834555083f},
{-0.31120598665484367f,-0.9341195625326119f,-0.1320036558366463f},
{-0.3034054687183929f,-0.9435882785266475f,-0.16154686808952692f},
{-0.27992731955546607f,-0.9283046561107587f,-0.17878598913300553f},
{-0.2736536410052473f,-0.9219278751320695f,-0.17245919869147652f},
{-0.26819262156298196f,-0.9114782284440474f,-0.1769583544727477f},
{-0.27343766837088795f,-0.8744400159314639f,-0.14943917358815043f},
{-0.26875494339350675f,-0.8487878021691201f,-0.1419762920414034f},
{-0.28579418196893047f,-0.7927246184520247f,-0.10981314069157115f},
{-0.19987041397584637f,0.3865054975176658f,0.1795086580496975f},
{-0.18646360720262323f,0.3780500540362126f,0.18747380882542689f},
{-0.17581177793363448f,0.40989797198986133f,0.16937757859357136f},
{-0.19282969929632146f,0.43961551367811563f,0.1480036449660896f},
{-0.17560635288402726f,0.46060802165312903f,0.14168443267947964f},
{-0.21623091632239738f,0.35532280090312035f,0.19875278379996417f},
{-0.22463624815219985f,0.3608117021759895f,0.18444320236340436f},
{-0.21653359737028866f,0.4024533681071026f,0.16575643381195962f},
{-0.2177277033788667f,0.4553157593172664f,0.13902057151878686f},
{-0.20567524877164683f,0.4971418263098058f,0.12091638810205475f},
{-0.17914255178666635f,0.5184867625784817f,0.11797756092604816f},
{-0.15973486729141845f,0.5042469292771519f,0.12863023162202358f},
{-0.11445299910737189f,-0.4776290133743912f,0.2352893241567554f},
{-0.10814620849289347f,-0.45151105490121507f,0.24228662354106525f},
{-0.09683975646512855f,-0.4441489661083563f,0.24207132022362712f},
{-0.10343006760261855f,-0.4715385183662468f,0.23355571365021913f},
{-0.11101778950406622f,-0.504518292667577f,0.22739842931259985f},
{-0.12032416745969605f,-0.4930543195584234f,0.23655157725199144f},
{-0.11732606430225725f,-0.5481137148774691f,0.22379839988624076f},
{-0.1264349757051954f,-0.5787128946256512f,0.2230307050640915f},
{-0.12913482593050132f,-0.5562962459779079f,0.22318031333210053f},
{-0.12524157832262756f,-0.6026580846369405f,0.22313103142095062f},
{-0.12992896514548546f,-0.6395502351987895f,0.22506500991591158f},
{-0.1476220774821783f,-0.702437786993501f,0.2280946134649601f},
{-0.17733542478439304f,-0.7019379995491662f,0.2266477765741541f},
{-0.19507181961532455f,-0.6902569605880152f,0.22284496643123053f},
{-0.21212169714257223f,-0.647497866869708f,0.22006114349250736f},
{-0.22652153330993846f,-0.6310673125392932f,0.21605579698681585f},
{-0.23757540744220038f,-0.641485997476466f,0.20374379296403416f},
{-0.24267196044789152f,-0.6128541908879822f,0.21206777516530576f},
{-0.2352949575741756f,-0.6107548592412465f,0.22573720171266579f},
{-0.23729503695834966f,-0.6078498378818004f,0.23351834664267462f},
{-0.24564565584827006f,-0.612404171937575f,0.2400321516688462f},
{-0.23265628397787677f,-0.6235205793936193f,0.2556621636523973f},
{-0.22023354837613063f,-0.621964480233852f,0.2702782550546008f},
{-0.2096042623384931f,-0.39472664183001205f,0.3401245248939491f},
{-0.21947004794002103f,-0.395268739665438f,0.32746518894777643f},
{-0.1832111019954691f,-0.4240376914158946f,0.35973236595846725f},
{-0.1664873911031926f,-0.42963715215766274f,0.3688579136053251f},
{-0.1575131930107469f,-0.44718545937206217f,0.3757271875363156f},
{-0.16474302053034195f,-0.44833855112707904f,0.3666536766240628f},
{-0.18677153654510303f,-0.4307832734550287f,0.35102852728106476f},
{-0.213017399357108f,-0.41123160507872564f,0.33002973835107f},
{-0.2663639744280798f,-0.3576407697030067f,0.2889853283441381f},
{-0.28064080926866714f,-0.33890921747508573f,0.2801850347239414f},
{-0.2276500048263327f,-0.3741927444973771f,0.32318634148714315f},
{-0.18394761089872086f,-0.406771619211055f,0.36024799921530987f},
{-0.15868910209833034f,-0.4301593107232833f,0.37819702222081025f},
{-0.14923746855949493f,-0.4441214072497272f,0.3762480690877468f},
{-0.14987831188895653f,-0.4482487426075534f,0.36844572805949155f},
{-0.15640407325263822f,-0.45272493869361125f,0.36391194097079044f},
{-0.16106339338593306f,-0.45783725783122436f,0.3656192483847307f},
{-0.17899258973685608f,-0.44387078418459724f,0.3518413499998212f},
{-0.2719759992046263f,-0.36418112005075526f,0.2851015244793004f},
{-0.28826081561868927f,-0.34560811200294544f,0.2735852097244998f},
{-0.3126047974005329f,-0.322101431878242f,0.25369371639840144f},
{-0.31594097253487813f,-0.30200717908373537f,0.2526294801831034f},
{-0.2698621178829126f,-0.3299025160780562f,0.2939484248677778f},
{-0.2728195818167477f,-0.33726330873338495f,0.2876194660519056f},
{-0.2384504394503565f,-0.3603786551903704f,0.3200673341959451f},
{-0.19444470578201037f,-0.39295250365269224f,0.3560373593985797f},
{-0.1663766690858985f,-0.4151211236351811f,0.373249712014841f},
{-0.14910008010613324f,-0.4340157586493838f,0.3756859098056171f},
{-0.1546868153271359f,-0.42519499880510736f,0.3608298141043592f},
{-0.15559842391142473f,-0.4459892455463861f,0.35592659700978874f},
{-0.15850156055941333f,-0.4482837585066111f,0.34619128996121684f},
{-0.1507446714621478f,-0.4664981773578597f,0.36488877820747917f},
{-0.459452654751784f,-0.5087177665782088f,-0.07820395108519537f},
{-0.46305369771519517f,-0.48100350637127215f,-0.0890552166109582f},
{-0.44739920679326034f,-0.49549927158956597f,-0.12575846787670728f},
{-0.43950908325717586f,-0.45976572561686735f,-0.1505461865915689f},
{-0.45355004656509534f,-0.47238668101844344f,-0.12184453093911335f},
{-0.47487403002691375f,-0.46333313062415227f,-0.07336476849664471f},
{-0.4654167837876104f,-0.4812032262909319f,-0.05817876648491921f},
{-0.46412865256290303f,-0.4712865991635869f,-0.02033168447304567f},
{0.1523443973362846f,-0.2929967486352877f,0.23421975890387506f},
{0.1461901536098217f,-0.29065425096385056f,0.24486857943394177f},
{0.1096412925096411f,-0.30102932724758663f,0.2481274272157303f},
{0.16001931954608087f,-0.2993244113136299f,0.22966216219371138f},
{0.1333211281090866f,-0.3083677487816296f,0.23910870998635333f},
{0.10270146088866837f,-0.30828085763395413f,0.24975574673370463f},
{0.08006055282563647f,-0.3082153644420092f,0.25465255963398764f},
{0.07052233092535189f,-0.30621038098337744f,0.26479312320464665f},
{0.11696858957149033f,-0.2909635582492618f,0.26441027817534213f},
{0.1762104369032126f,-0.2767821255053275f,0.24626627571383672f},
{0.19747000126738354f,-0.27806036783812593f,0.21661748987191629f},
{0.2192530617686096f,-0.28636707528838323f,0.20328355046325738f},
{0.1956320931235889f,-0.29629910307936314f,0.21126857038987656f},
{0.172758920402409f,-0.3047958041057663f,0.2233634171935891f},
{0.14918372772276034f,-0.31129189879372093f,0.23142537775632166f},
{0.14467703415806693f,-0.31983399119386846f,0.2293096520946473f},
{0.13102658433903508f,-0.3172569191897013f,0.24383980532898222f},
{0.10850120993827542f,-0.3163186239835964f,0.25068008083875915f},
{0.08706391112169501f,-0.32046995063462086f,0.25290478510650904f},
{0.07708698810141872f,-0.31288187920100324f,0.25578131481326755f},
{0.07874891582810054f,-0.31966393688752803f,0.26720455839415347f},
{0.060292657899507045f,-0.3068922183806518f,0.27040496524704954f},
{0.039221537058485134f,-0.30004142609594936f,0.28217017984150994f},
{0.06913229354336965f,-0.2949898989957154f,0.2806177682992562f},
{0.11332288510850116f,-0.2813243024285157f,0.2738482746475097f},
{0.18466602274731247f,-0.26169092957947276f,0.25682255096185547f},
{0.20682856363230423f,-0.25648166785388f,0.24707543100082802f},
{0.2104355443929736f,-0.26619273925545694f,0.22555715758567418f},
{0.22548742910498895f,-0.2563568434352966f,0.2175226538904209f},
{0.2384668324028873f,-0.2552465475917407f,0.1978370615726293f},
{0.24446688888367377f,-0.2599164663053626f,0.19136025808571505f},
{0.2159979026667424f,-0.2778052061668254f,0.20619191522008612f},
{0.24202209940092642f,-0.27219520740197545f,0.1888275639182401f},
{0.23215473293657513f,-0.28593813132173185f,0.18845918782091978f},
{0.17372953724136167f,-0.30993892457064914f,0.21431575253857338f},
{0.1502808922057667f,-0.32425798905933395f,0.2206085098082703f},
{0.15870924322562002f,-0.3342012029421606f,0.22224268531810132f},
{0.15367483895208325f,-0.32795378498822536f,0.23616569373634616f},
{0.1540548664758718f,-0.3270062489589765f,0.2520769261299971f},
{0.12215422228494843f,-0.32116005568948397f,0.25971812964067337f},
{0.09557200009742922f,-0.3241338116471077f,0.261001701011054f},
{0.07609607714845167f,-0.32864421407747096f,0.27724718602552917f},
{0.06835661472651736f,-0.32278861849884705f,0.27787402682003576f},
{0.06758824102577653f,-0.3170238046053041f,0.2795076350040955f},
{0.05978655869036446f,-0.3171690559388783f,0.2844189975793564f},
{0.046968330094318445f,-0.3171734330590615f,0.28404778485317944f},
{0.027430059742925582f,-0.3057438267177928f,0.2731647958301666f},
{-0.006176995189745113f,-0.2956410965517075f,0.2930551545047223f},
{0.22718316689786253f,-0.23118317958513657f,0.2527167166133175f},
{0.2421040864741442f,-0.23100104782679548f,0.23833319265548833f},
{0.22863241439199267f,-0.24805548520836992f,0.23210101387920054f},
{0.2526655898310031f,-0.23803267466990127f,0.2057807623346454f},
{0.26103345372451897f,-0.24736748797060476f,0.18631377636017776f},
{0.2615137066764245f,-0.2553841793364912f,0.18724989363026912f},
{0.25954361693995215f,-0.2628479118718952f,0.18115567169552216f},
{-0.4684315539987954f,-0.4348490072207233f,-0.02542798462567772f},
{-0.470193533981121f,-0.4383141204166979f,-0.01408822823783933f},
{-0.45993837804151066f,-0.41620791264350077f,0.0033041812543072218f},
{-0.4559453522792086f,-0.43154778742819044f,-0.021807346612592034f},
{-0.450890623081831f,-0.4115498280904906f,0.003424707170885501f},
{-0.4563452383298089f,-0.3983243615817891f,0.01891584120532324f},
{-0.4618140377844775f,-0.4070113802187206f,0.018501694454669832f},
{-0.45732572387492215f,-0.4394224699291432f,0.02454633381685619f},
{-0.47500785303966025f,-0.4558377861443184f,-0.044572036872144366f},
{-0.4743462385750769f,-0.4475416156547351f,-0.05187724541318562f},
{-0.4679811292086043f,-0.4452529385006184f,-0.05430191289198409f},
{-0.45618993661833823f,-0.44402900433032594f,-0.050114323075131306f},
{-0.4568946306572682f,-0.42845147529266076f,-0.04625222207706605f},
{-0.4561060850194114f,-0.4179173682460358f,-0.01989568824334189f},
{-0.45414616783773376f,-0.38869985729350504f,0.0062909665813306774f},
{-0.4481920084368099f,-0.38360066951644145f,0.025681963837084026f},
{-0.45175864426083934f,-0.36024167151438485f,0.04593147053470978f},
{-0.45278695196876967f,-0.37071401335807525f,0.04957273838267828f},
{-0.4446345326929308f,-0.3536594962959149f,0.06936067350735509f},
{-0.4505871930364327f,-0.411928842077227f,0.04915862881629826f},
{-0.45243513137237523f,-0.4434259529715334f,0.041156111033024426f},
{-0.45629060719532827f,-0.4692359002968282f,0.03286776411456466f},
{-0.4596708552553239f,-0.47944659659434485f,0.019130835362088247f},
{-0.45974246791626283f,-0.470291889040286f,0.004382486936252402f},
{-0.4603211625135699f,-0.509819145633003f,0.014550201400940972f},
{-0.46690694460655974f,-0.5521554552251499f,0.000317058081599723f},
{0.2972521970950776f,-0.09776974948539081f,0.27037779098004816f},
{0.2966041591399169f,-0.08467389035523981f,0.2683755835930277f},
{0.2877272489179894f,-0.08660811214158964f,0.268342128371045f},
{0.2835502672431339f,-0.0785220370463527f,0.2732927416029001f},
{0.2970337320519925f,-0.07732395975737538f,0.2733067845093519f},
{0.3049483961461138f,-0.08486120878851641f,0.26332409686429065f},
{0.3101011005918637f,-0.09405344589851491f,0.2602746964080835f},
{0.3080540691568702f,-0.10347287998140071f,0.26216737698659764f},
{0.3035705977021195f,-0.11054884428970194f,0.26452282328444077f},
{0.2948486640948724f,-0.11529835965896583f,0.2642922414802661f},
{0.290543108764267f,-0.13344655650651085f,0.2620844581817292f},
{0.27990565706019055f,-0.1444301959207653f,0.25363975351843426f},
{0.13562011911823688f,-0.8576341756033229f,-0.36996827000612625f},
{0.14690123165729074f,-0.8436367391434388f,-0.3516812249568866f},
{0.1669667707558773f,-0.8456491796424992f,-0.3595648242466009f},
{0.18021027163717832f,-0.8475799167312276f,-0.36492946736425014f},
{0.18469919430640958f,-0.8301656747585554f,-0.35772616604289137f},
{0.17728652746487086f,-0.8296136890936283f,-0.34586469730071323f},
{0.16380670883962115f,-0.8333903788780995f,-0.3424499199244375f},
{0.1524607522397952f,-0.8249959696630066f,-0.33231067373946466f},
{0.09634817612113736f,-0.8412995906953322f,-0.35463050197612667f},
{0.14944788692581606f,-0.8644757281272891f,-0.3699377523417422f},
{0.16737930158424946f,-0.858901556941065f,-0.36439231397477867f},
{0.18270424210233352f,-0.8543136656721576f,-0.35015925033602324f},
{0.1944011470617408f,-0.8384540641733277f,-0.3484854587013109f},
{0.19118736661931415f,-0.833785604145631f,-0.3626470318560257f},
{0.1922039007238779f,-0.8226408272137975f,-0.36320278800627576f},
{0.18548291873761802f,-0.8110849377680203f,-0.36249537739057186f},
{0.07867933024126596f,-0.8215054043630929f,-0.3394871057048639f},
{-0.0016846377560593873f,-0.8183384123606827f,-0.347724551602669f},
{0.12503330602008572f,-0.9930237341655415f,0.2087685006414757f},
{0.13864956011889026f,-0.9944679766564718f,0.19009792318507754f},
{0.1379914526624925f,-0.985014013257306f,0.19751794613830267f},
{0.13489505978396912f,-0.9717050595555569f,0.20704877155540388f},
{0.14192658463592497f,-0.9593608263294068f,0.204622523213782f},
{0.14857508384924842f,-0.9709005044943891f,0.20715993872157107f},
{0.14665792433235048f,-0.9940578373080832f,0.19747793586012333f},
{0.14182775839889564f,-0.998612171363858f,0.1843515696896664f},
{0.12215379732182384f,-0.9986402168052647f,0.2023184655817789f},
{0.11326938862556309f,-0.9887383412103816f,0.2240531769659135f},
{0.1273685293852378f,-0.9723178372578631f,0.22298513201861137f},
{0.15135009305276773f,-0.9563599980959315f,0.212301396518229f},
{0.15652405415400933f,-0.9868158717792421f,0.21468513154886776f},
{0.15938380631660926f,-0.9969064437503333f,0.20897937690556354f},
{0.17727635491007626f,-0.9990495455364932f,0.20720993988280936f},
{0.17210636508923388f,-0.9968101502935265f,0.1738717389333131f},
{0.18161463558849794f,-0.998857282657262f,0.15812701452872802f},
{0.08932910268873173f,-0.9936891977336255f,0.2198632466646521f},
{-0.3056175080226225f,-0.336971185894324f,-0.23546233620644302f},
{-0.31218517500001924f,-0.328734347693787f,-0.24231213513984176f},
{-0.3022367733798492f,-0.2857435980770077f,-0.2359254450834951f},
{-0.2978598688654421f,-0.28951915320993626f,-0.23622113442557915f},
{-0.29256979615207884f,-0.209773723290071f,-0.23088737337819323f},
{-0.3053716668550519f,-0.21928928934377628f,-0.24537742284246142f},
{-0.31435891556505363f,-0.2867956952206521f,-0.25075718402326763f},
{-0.3192521014050684f,-0.3692026575032874f,-0.24494343350111344f},
{-0.3099471566375761f,-0.3611830477031429f,-0.23769190311474594f},
{-0.3023459145343199f,-0.35743180896020293f,-0.23941673919516743f},
{-0.28765519110817733f,-0.24902052971835154f,-0.23956423964607856f},
{-0.28298253669444096f,-0.13747078943586657f,-0.22428181350138543f},
{-0.2857948098519471f,-0.12486782697298528f,-0.22128530076844027f},
{-0.29506001631765966f,-0.1875186976802765f,-0.2323123650395801f},
{-0.29834660569222093f,-0.16127518597675833f,-0.2389509551752461f},
{-0.3076532322512787f,-0.15298671581899242f,-0.24665299003239058f},
{-0.31933516257258354f,-0.24440183712217453f,-0.25659474522929215f},
{-0.32850223124152855f,-0.34928251103851415f,-0.2568035837951975f},
{-0.3378623935926134f,-0.4214225235924242f,-0.25400896041866317f},
{-0.3203937244677606f,-0.41020430984543965f,-0.23686815884368778f},
{-0.31022025281514176f,-0.39183102277969734f,-0.23180858612909774f},
{-0.3102135660203765f,-0.37295811081801544f,-0.23412512599047758f},
{-0.29903563665278665f,-0.41121442063237534f,-0.24926643569279858f},
{-0.28616014640051884f,-0.37010982734774006f,-0.2584798678386356f},
{-0.27896482907386316f,-0.2162732219326535f,-0.23972562045504628f},
{-0.2770388738826943f,-0.1533859941723245f,-0.23299029171370053f},
{-0.2719051366036022f,-0.09177222578482684f,-0.22302709712716381f},
{-0.2814588590338559f,-0.09105504845411225f,-0.21563086360965275f},
{-0.2898988423568368f,-0.10507120878926544f,-0.2239619288838033f},
{-0.29190802020150813f,-0.13480633970124625f,-0.22828108090957974f},
{-0.35038543536547023f,-0.42959370605262115f,-0.25927293295932236f},
{-0.35664043147432456f,-0.4853756279257121f,-0.2529330122196516f},
{-0.33692233478954153f,-0.44689139020189056f,-0.24649035239498188f},
{-0.318655777212538f,-0.443332739434972f,-0.226413608081208f},
{-0.3131123659196787f,-0.4255894134554786f,-0.22848396255488637f},
{-0.3086411535886644f,-0.46062393864696033f,-0.23830241151396703f},
{-0.2950520737568612f,-0.5164347165786183f,-0.27378782683026137f},
{-0.28741986777794015f,-0.5027151369457029f,-0.2808244788623153f},
{-0.28218296645072466f,-0.4381939960902724f,-0.27205978865269614f},
{-0.2778253531373579f,-0.3715245667737464f,-0.26105132714233487f},
{-0.2790204323114913f,-0.2976749360689061f,-0.24976851262596708f},
{-0.2697574345916187f,-0.285533341196674f,-0.245180478994413f},
{-0.27120718991668274f,-0.21765205303704047f,-0.23699120054196357f},
{-0.2682460373029263f,-0.1568211984635911f,-0.2337938736093129f},
{-0.26497565920916f,-0.09721662810651319f,-0.22635190449792655f},
{-0.26682426686202376f,-0.047822916595347015f,-0.21037045650960878f},
{-0.27511851226865275f,-0.051350847840397354f,-0.20545216384819376f},
{-0.28341638473555f,-0.07403554622860188f,-0.2132388821695815f},
{-0.2542464930259442f,-0.009648147642924088f,-0.2126707245329484f},
{-0.24672040883849372f,0.02807935824495462f,-0.2291113303036675f},
{0.24080963392295854f,0.04008591577231185f,-0.24753860043512538f},
{0.27373311442158327f,-0.00705332492904303f,-0.23755293379856082f},
{0.2575073264479325f,0.006958702639723571f,-0.23972381754899025f},
{0.23083093774404495f,0.03934101809698077f,-0.2385649898541993f},
{0.24499656504696818f,0.00924689321106263f,-0.22668935815348668f},
{0.2737090413229834f,-0.017570410077712813f,-0.22502034841633367f},
{0.3116266820872469f,-0.0436470292005374f,-0.22493244373160612f},
{0.3137712223735836f,-0.03657884596704728f,-0.2230065703458387f},
{0.2683649037385031f,0.03512379241422747f,-0.2325775175939395f},
{0.24760640277044854f,0.0442921986546072f,-0.24523318504593927f},
{0.21502438757928002f,0.14217674714726863f,-0.2529179557761476f},
{0.22183179537859388f,0.07864764233467747f,-0.24840795918556835f},
{0.21324945897054848f,0.05916843654556253f,-0.23106459999966888f},
{0.22553324544185796f,0.03456888831504225f,-0.2285453208556291f},
{0.2399437811182934f,-0.0267029079964732f,-0.23008008261691107f},
{0.27448411244256765f,-0.02494149640232678f,-0.2167660027974717f},
{0.2944397401410201f,-0.041501171528514624f,-0.20874975658045827f},
{0.3140168202497654f,-0.05193233763265646f,-0.2127926730135862f},
{0.33574717469946513f,-0.06417209154981234f,-0.21443335258403895f},
{0.35306285284983724f,-0.07112258124594953f,-0.2094421107526582f},
{0.3184847497406423f,-0.019470020742381078f,-0.21252614251629537f},
{0.27593498117101806f,0.046900476763420296f,-0.22649429795448797f},
{0.22552266810968713f,0.14944302906609813f,-0.24821182489227228f},
{0.3028694085465595f,-0.997580986655574f,-0.003174043734258733f},
{0.3319771313382624f,-0.998120166056742f,-0.005922658478110306f},
{0.3099324847857f,-0.9887188874609463f,0.0003890255867476565f},
{0.3074947879375018f,-0.9865586022908438f,0.007104399122170874f},
{0.3073923951974495f,-0.9763018665508177f,0.00808295002265953f},
{0.31760327316670184f,-0.961967402460906f,0.012874704601691248f},
{0.3423065729568653f,-0.9716405395291671f,0.005716036094899547f},
{0.34734043009037907f,-0.9918498914611512f,-0.0013204863234014127f},
{0.3611051981771469f,-0.9985171751069889f,-0.007454183082790765f},
{0.300757594670447f,-0.9983339894400989f,0.004410410200760862f},
{0.3182960119305295f,-0.9984842659626213f,0.021528060847116844f},
{0.3292275742386821f,-0.9879825814775863f,0.027831456006229834f},
{0.3183206534173085f,-0.9725820782663205f,0.02225456399360039f},
{0.30691799823740074f,-0.9623473896131975f,0.02029816338177864f},
{0.30522706359024265f,-0.9565146506762294f,0.019596117925522592f},
{0.29470750621859565f,-0.9325216385021232f,0.04206468325578819f},
{0.30496067545559863f,-0.9233622297934986f,0.04533545125322127f},
{0.3243023302429567f,-0.941832783481603f,0.019753395715522513f},
{0.337030198929823f,-0.9537610415532561f,0.009958353725343795f},
{0.3555204485963439f,-0.9702896720607855f,0.0033991552006122066f},
{0.3691045850446003f,-0.9834729896643832f,-0.0008978084380220206f},
{0.3803622725538196f,-0.9850081774511975f,-0.010643551518525814f},
{0.3703703440856143f,-0.9987285666388652f,-0.017342729709271223f},
{0.3659303378592458f,-0.9968769396230014f,-0.037255622053507895f},
{0.3547914371050176f,-0.9963779638582344f,-0.044106698001096026f},
{0.370838762876908f,-0.9906358451203598f,-0.07142548008744205f},
{0.3910989765204576f,-0.9812459151648059f,-0.09762971032453953f},
{0.3830602784391645f,-0.9842577669417328f,-0.11012291331160383f},
{0.37286198362803125f,-0.9808625229954786f,-0.11241501566850463f},
{0.38184112616643157f,-0.98060233613523f,-0.1297233674546089f},
{0.3826237148836895f,-0.9766805575655795f,-0.1426737330222046f},
{0.3849968513340011f,-0.9812151138375362f,-0.161774207425061f},
{0.3797711360986324f,-0.08019939518408808f,-0.11925574695123263f},
{0.3969845224376942f,-0.10327145808442706f,-0.08511767297179373f},
{0.3982011217444563f,-0.08017175558246532f,-0.09048632880374684f},
{0.40418612178173896f,-0.056121113096626776f,-0.08692990696841672f},
{0.42103390809509184f,-0.06110196032998024f,-0.04961592419780612f},
{0.3868808998490472f,-0.09776529162221392f,-0.10724655571491078f},
{0.394297539033393f,-0.11544061181528835f,-0.08643791122297116f},
{0.40876088169009667f,-0.12613634296226983f,-0.05613974029278501f},
{0.41483682702326324f,-0.12035677647385704f,-0.045158532730011004f},
{0.40234405962340153f,-0.09909273406076087f,-0.0740084782023816f},
{0.39735437740668805f,-0.09940187879777695f,-0.06267719345443176f},
{0.4011648273241838f,-0.08328857431357173f,-0.07739456313089339f},
{0.411790323753158f,-0.08907705652833829f,-0.05214697694521239f},
{0.4269533352598434f,-0.08260317041327433f,-0.012843568615960968f},
{-0.31388133775601734f,-0.9761530497766282f,-0.2585434561333746f},
{-0.33839415738725726f,-0.9732574307263137f,-0.23293442393652736f},
{-0.3207677536370457f,-0.9720766175642723f,-0.2175774879447935f},
{-0.26508516476951005f,-0.9673747618094305f,-0.262582076189313f},
{-0.2951228545524838f,-0.9590357943459781f,-0.2054651528460966f},
{-0.32756148293578713f,-0.9690412589521091f,-0.18441629157354023f},
{-0.3359120827023669f,-0.9730377704744406f,-0.21119811256622872f},
{-0.3454854203680434f,-0.9698308999324196f,-0.21079137717246801f},
{-0.3538543785416052f,-0.9711049266310222f,-0.2229486563712207f},
{-0.3376082050868682f,-0.9780233188623598f,-0.2442554564490967f},
{-0.2921251466107508f,-0.9798280958185541f,-0.2887425065395676f},
{-0.24230105157034873f,-0.9756981671232603f,-0.31116582285873556f},
{-0.21852474084236057f,-0.9720821293359982f,-0.29276303060325354f},
{-0.20646519360059143f,-0.9616885724683819f,-0.27404165199253505f},
{-0.19695116803821275f,-0.9404931021050682f,-0.2530055162407443f},
{-0.2551945358237191f,-0.9576562333674248f,-0.24438609648803997f},
{-0.26820935979805144f,-0.9419788454323376f,-0.2086230463880095f},
{-0.2971996535919464f,-0.9534202848718103f,-0.18858689030226444f},
{-0.3187189192959961f,-0.9596085309602786f,-0.16661106015328114f},
{-0.327875897215548f,-0.9578274223253079f,-0.15749420512713666f},
{-0.3419726666809876f,-0.965522162690419f,-0.178440187076863f},
{-0.360097398127201f,-0.9622916227647667f,-0.21113531470290145f},
{-0.382595588699289f,-0.9462392728663359f,-0.17472724707311815f},
{-0.37100991146329415f,-0.9634711397892778f,-0.18149408683015167f},
{-0.34953702942188475f,-0.9823466461508353f,-0.21469212219226713f},
{-0.3316986264425286f,-0.9849969913593508f,-0.2491613476241286f},
{-0.3117254690151872f,-0.9854416610864273f,-0.2760753289613386f},
{-0.2831590345041579f,-0.9847857613134617f,-0.3014291378672322f},
{-0.25251648939392785f,-0.9813574467368524f,-0.3232445189388984f},
{-0.21772561680992503f,-0.9813645797428985f,-0.3398487748216705f},
{-0.21366981337004418f,-0.9790275938431872f,-0.31761429724135737f},
{-0.18427227741386237f,-0.9777478928244637f,-0.2957857444376448f},
{-0.1789588710377361f,-0.9627098682847567f,-0.2761711762068646f},
{-0.16684879568045421f,-0.928349236867343f,-0.24787360205345665f},
{-0.20104449997162543f,-0.9296688174880852f,-0.23814200280814676f},
{-0.22274640420254233f,-0.9378382172279744f,-0.23843252566104373f},
{-0.246791534916655f,-0.9403901611625851f,-0.22409129297096506f},
{-0.2613985278583612f,-0.9326065843810959f,-0.19519212508228198f},
{-0.40437761547771456f,-0.9347312055833754f,-0.1392456617369841f},
{-0.40774870558237547f,-0.9553198965988862f,-0.1162956684317735f},
{-0.39460478099801866f,-0.9526486378926023f,-0.13641435979316704f},
{-0.3553664037133142f,-0.9848102402518454f,-0.13792671006166637f},
{-0.33203873399280176f,-0.9988877599501492f,-0.1593755795617213f},
{-0.34144290977469943f,-0.9931548809730107f,-0.1827325101181768f},
{-0.33368362919745037f,-0.9991325461467631f,-0.2012376334940581f},
{-0.33335178930476594f,-0.9945227703393474f,-0.23099854054436042f},
{-0.31950813425077423f,-0.9983466342178708f,-0.2473761253461118f},
{-0.2939748081721634f,-0.9970906015203709f,-0.2815370570296142f},
{-0.2883500982463482f,-0.9902694759113954f,-0.29419365727567237f},
{-0.24483143606324156f,-0.9948314284935861f,-0.3228414711626512f},
{-0.24516870698465812f,-0.9847290223618832f,-0.32873058358291096f},
{-0.22893412333673632f,-0.9871935896284486f,-0.33724130733001756f},
{-0.209733485125416f,-0.9858028425580483f,-0.342057450542769f},
{-0.19290286201025725f,-0.9800227905492657f,-0.34400334394133547f},
{-0.18780535602475926f,-0.9763825978580025f,-0.33991021492781476f},
{-0.18583336139108092f,-0.9799282798127665f,-0.32485281738166577f},
{-0.18344375018283704f,-0.9812754192921378f,-0.30828309187758157f},
{-0.16461588537476857f,-0.9771454905968441f,-0.294059834262926f},
{-0.15305282148904056f,-0.9640908879492351f,-0.2746801643992583f},
{-0.1372802747486892f,-0.9274869707514493f,-0.24783651870879786f},
{-0.15792024181481187f,-0.9066196122918098f,-0.23434849404561245f},
{-0.20091706096741802f,-0.9208493537813386f,-0.22887509436512024f},
{-0.23478135032902947f,-0.9185791572111022f,-0.2117456201822306f},
{-0.2206018224823011f,-0.9351663104529255f,-0.22955632406512644f},
{-0.23827402238363324f,-0.9392514969056479f,-0.21872075242755445f},
{-0.2482691933204791f,-0.9271363262405021f,-0.20549731193054932f},
{-0.17962614813595457f,-0.9641309300996488f,0.37244829849357175f},
{-0.17163304328589016f,-0.97951603264728f,0.36604594429645304f},
{-0.159424355235549f,-0.9739506157014222f,0.3541331878171769f},
{-0.1644778074187373f,-0.9481927051107323f,0.352110940231609f},
{-0.1564247115867836f,-0.9574007476617419f,0.34710060905667206f},
{-0.1506188026966857f,-0.9696005401714777f,0.3364010479295303f},
{-0.15712252653513434f,-0.9851962257586407f,0.3391467144917051f},
{-0.16634655726129838f,-0.9974644288321718f,0.3475216912055187f},
{-0.17761520669431613f,-0.9991383819528713f,0.35955112556027996f},
{-0.1850396482016292f,-0.9795311092765324f,0.3712072808056711f},
{-0.1972200283958341f,-0.961549805009681f,0.37232527698104434f},
{-0.18831565918161178f,-0.9501026923124952f,0.35355595296820275f},
{-0.1775824813464999f,-0.9484958514932449f,0.35422583402796703f},
{-0.18028737694650235f,-0.9344711802091141f,0.3460796776461767f},
{-0.17109534275639593f,-0.9320473031617273f,0.3385392860127293f},
{-0.15907640499081172f,-0.9416844522277834f,0.3373425664809351f},
{-0.15106646097693588f,-0.9524933361811316f,0.3238647547440412f},
{-0.13775395139624177f,-0.9672781443182411f,0.3023787615278306f},
{-0.14924162257403772f,-0.9900804544383969f,0.32185336709112194f},
{-0.19344958981892557f,-0.9988452870106629f,0.36056445863010783f},
{-0.19899207894180446f,-0.9797953492225818f,0.36823392962542345f},
{-0.20745546604646384f,-0.97186149591857f,0.3649281712267201f},
{-0.21294023455294642f,-0.9644854651480015f,0.3583182756636337f},
{-0.20174029846995015f,-0.9578060243695774f,0.36479730808213634f},
{-0.20610338318354585f,-0.9538673853879592f,0.3393502643915251f},
{-0.19629970594267565f,-0.937370203214057f,0.3359380601669687f},
{0.09364955191444592f,-0.8977541102049615f,-0.2582084747007917f},
{0.10194276359827437f,-0.8963320762869218f,-0.24953041216171076f},
{0.10115723626100986f,-0.9207412261639201f,-0.26522218828578853f},
{0.08557453011007936f,-0.9070740083624f,-0.26225556533421085f},
{0.08933499905208526f,-0.9342618954319278f,-0.274530050425131f},
{0.1056096036022645f,-0.9370082111252755f,-0.2785569372491998f},
{0.12458353036106734f,-0.942585300745758f,-0.2753231761030631f},
{0.10781126743180748f,-0.9180296023352477f,-0.25741968470913823f},
{0.10841105613621106f,-0.9147034180839613f,-0.24644506301238742f},
{0.10630985040209581f,-0.8976307434098955f,-0.24222785857779028f},
{0.09854736772770292f,-0.8803651577878335f,-0.2468014434631086f},
{0.08197420639675652f,-0.8702052020873919f,-0.2560896287473751f},
{0.04303948332549849f,-0.9018882534720435f,-0.25532389937967703f},
{0.057554762850473104f,-0.9408972430989534f,-0.2675717785917749f},
{0.08051312474201452f,-0.947236414841117f,-0.2771807409161852f},
{0.11275121196441994f,-0.9510233175518799f,-0.29845720500141293f},
{0.12205782789939953f,-0.9463052515786506f,-0.29151502227195353f},
{0.14299785186611924f,-0.9547896329240722f,-0.301102971232261f},
{0.14571583845517447f,-0.9600321257035993f,-0.2738203705063419f},
{0.1294886109189391f,-0.9439883674971397f,-0.25698796467087553f},
{0.11683900237868812f,-0.9282065799336442f,-0.24910179222944187f},
{0.12261210411556826f,-0.9040495118077012f,-0.23780608964391328f},
{0.1160539212527044f,-0.8900940617045257f,-0.23317686008706226f},
{0.11490840765260663f,-0.8784588996374889f,-0.23215070056772666f},
{0.10433537398377002f,-0.8429505246259813f,-0.23527629372494796f},
{0.10137043176135001f,-0.8498011554246964f,-0.24056103740072896f},
{0.09179044767240496f,-0.8543580838803467f,-0.24895100893839334f},
{0.012559796833501885f,-0.9179637851089202f,-0.25321028153510067f},
{0.03029995896253283f,-0.9487571740674442f,-0.2639271067891785f},
{0.035337894679634885f,-0.9786249115352273f,-0.2735733543157318f},
{0.06141529360979298f,-0.9664870446520054f,-0.27805615751596907f},
{0.09012619964706299f,-0.9691009152755381f,-0.29509243834804577f},
{0.12537303960280927f,-0.9553636656759026f,-0.3144048322994608f},
{0.138066550021053f,-0.9530589397893859f,-0.31740537687005044f},
{0.15797291705651173f,-0.9632146809180396f,-0.32154252037679193f},
{0.14299685957722344f,-0.9537501794957919f,-0.2558110218604914f},
{0.14299767019438347f,-0.9373742562998575f,-0.24368847489791085f},
{0.34632136320559276f,0.04640993014222958f,0.23082479862050637f},
{0.3614660566767934f,0.05668984762070144f,0.24139789284658822f},
{0.33783361827704017f,0.06689211371223418f,0.2296569138991228f},
{0.331756498983242f,0.08642603137882346f,0.22419840811373934f},
{0.33954056128510113f,0.08680204725071594f,0.23189942943383174f},
{0.35128214899224247f,0.09428880003857855f,0.24060805000879357f},
{0.36615141642554705f,0.10118644238295053f,0.24981990129180712f},
{0.3717384756809319f,0.07408398671276507f,0.2458626616742261f},
{0.36465286683451836f,-0.002566022431724245f,0.2361380945062202f},
{0.126261557815724f,0.7489159911801219f,-0.04675394310361765f},
{0.17190161891821817f,0.7425312665782263f,-0.04471647758855849f},
{0.16471521731791622f,0.7484037618779071f,-0.05877170690857012f},
{0.13501876973675833f,0.7528224498291309f,-0.06275491496028653f},
{0.14536979310764306f,0.7468185229966874f,-0.06962617453147667f},
{0.1585169803463889f,0.7516692762687125f,-0.07495938843883965f},
{0.19782238918954928f,0.7412248980610276f,-0.06551136177452414f},
{0.1559125927749813f,0.7387446464679415f,-0.035127408850417714f},
{0.11556941335751396f,0.7365614228507821f,-0.030606423775844552f},
{0.11408644610185605f,0.7666361343587617f,-0.07472357852582481f},
{0.12955134822502118f,0.7509656361383317f,-0.07337324863579574f},
{0.12205010738183375f,0.7561965794825405f,-0.0867831565774205f},
{0.1793643389789779f,0.7485779903845388f,-0.07830679959819886f},
{0.19175712424211133f,0.7434160249298964f,-0.08332529750198246f},
{0.12835247944222425f,-0.8811277254298846f,-0.23049269418827692f},
{0.11326464603709277f,-0.8516176039931074f,-0.2321284505609314f},
{0.13234419950532605f,-0.8573782033148623f,-0.2223218155767141f},
{0.16754015543894268f,-0.8816267022570593f,-0.20956687461399637f},
{0.15420441418663558f,-0.8625304009920862f,-0.2128845691644614f},
{0.1442238332962645f,-0.8316532018685402f,-0.21514384311998824f},
{0.11338010958044951f,-0.829494375384363f,-0.23561678692925664f},
{0.14728508916123959f,-0.9060943738059437f,-0.23051545096359832f},
{0.17774538139863816f,-0.8988519227567328f,-0.2120875720724644f},
{0.2006038418964451f,-0.8872486966685084f,-0.1931696745768221f},
{0.20236170823572464f,-0.8563189731651718f,-0.18334719271768912f},
{0.1551162862480617f,-0.8042733759541635f,-0.214163661423509f},
{0.13565391962275836f,-0.8084935997517608f,-0.22657059158424414f},
{0.10451600562228124f,-0.8341253876615216f,-0.24506564439648068f},
{0.09369971456167162f,-0.839307576048855f,-0.24918317160539147f},
{0.11345425502161095f,-0.8451527972152001f,-0.2622509852941357f},
{-0.06879873679966188f,0.7474379067507655f,0.16978380721880598f},
{-0.07580604194074003f,0.742209801097821f,0.18427596556257986f},
{-0.0812274048866273f,0.7426788679578797f,0.1932018134755264f},
{-0.07571377075990748f,0.7601734343355445f,0.2038328822334715f},
{-0.06574851828943991f,0.7803511753855062f,0.20189568145561837f},
{-0.06263327192189448f,0.7958247499436364f,0.19887597742255697f},
{-0.05444790206778333f,0.7987590321390257f,0.20817878356312478f},
{-0.0461547934375127f,0.7999266746314281f,0.21223567172138116f},
{-0.04314725291148466f,0.791594880545519f,0.20233813181277677f},
{-0.037641128945584024f,0.797381478048828f,0.1992243834402454f},
{-0.03279035230058695f,0.7947311317779047f,0.1983170701707382f},
{-0.024165866987437588f,0.7972017175847221f,0.2121263988283418f},
{-0.010216665967009068f,0.7983203203949557f,0.21266726002107525f},
{0.005103962237768314f,0.8091837749255395f,0.20387723988441536f},
{-0.0009326378845087896f,0.8183983629710753f,0.21436986734285765f},
{-0.007357417385711696f,0.826684461834606f,0.21486378710884976f},
{-0.01114170976048167f,0.8344798727767071f,0.20833528048338326f},
{-0.1277296513620214f,-0.8327503663515465f,-0.38747086074999093f},
{-0.11974376132340474f,-0.8218826356295217f,-0.3914180510520834f},
{-0.09717595435465545f,-0.8178498110081948f,-0.3964809661016483f},
{-0.1257045257136923f,-0.8379998306511325f,-0.3748896224020382f},
{-0.10316623349635318f,-0.8250619483753214f,-0.3826103811344518f},
{-0.08728464121823405f,-0.8256254441664779f,-0.3807428668721754f},
{-0.10218804806415172f,-0.8135140025527504f,-0.394836841142663f},
{-0.13267955596786637f,-0.8126228803782898f,-0.378289242406068f},
{-0.16451288387504026f,-0.8440870821282285f,-0.3685771585298466f},
{-0.16275418673285205f,-0.8516586182466687f,-0.370510205293157f},
{-0.1465870319839077f,-0.8499559716157972f,-0.37270392549949366f},
{-0.1306216231663195f,-0.8419160974490569f,-0.3527670822335556f},
{-0.38993486122198895f,-0.6496968969902863f,0.05967147602020815f},
{-0.3982990374979912f,-0.610077885546933f,0.05220929247539324f},
{-0.3860262140128882f,-0.5688554372389574f,0.072142875211758f},
{-0.3801039905907767f,-0.5266248244751567f,0.09248840551460645f},
{-0.3711648083973886f,-0.5049662038008863f,0.1019320146872419f},
{-0.3778257292828435f,-0.4985944480111452f,0.11089184477644562f},
{-0.3785360572703977f,-0.47201074695195244f,0.1224679178458249f},
{-0.3765097151651245f,-0.4207936960953101f,0.14190460926154894f},
{-0.3722889240417559f,-0.3886316082156972f,0.15072839909290367f},
{-0.36168689195170567f,-0.38475181600275554f,0.16832349474731953f},
{-0.3571167120834231f,-0.3750237237656313f,0.18583072715091245f},
{-0.35006974513392775f,-0.3544758844552866f,0.19446178770600686f},
{-0.34933406703358444f,-0.3529847919046867f,0.20558197520904414f},
{-0.3577317187173179f,-0.35240508483273525f,0.2168970284904506f},
{-0.35857665908662245f,-0.34176122893437144f,0.22487347691084694f},
{-0.35704493793649683f,-0.33360479800663656f,0.23904147444559762f},
{-0.36526917173075873f,-0.3165805946265605f,0.2562917815809231f},
{-0.3543244791244644f,-0.3048570827259232f,0.2582383039249139f},
{-0.3435338728351044f,-0.32096341569006964f,0.24117572000024123f},
{-0.3348288591346625f,-0.3160897239709873f,0.23140302682078426f},
{-0.33245367648690594f,-0.2968457405833674f,0.23704733179627394f},
{-0.3241394716247232f,-0.2952836430690967f,0.24439912691984747f},
{-0.3027326692243706f,-0.34264894609179636f,0.2567252237822481f},
{-0.2658123521066242f,-0.4160415873885785f,0.2829097888507555f},
{-0.2595028066686907f,-0.42843137347446014f,0.2834475499374951f},
{-0.2562546785817197f,-0.4429026597543702f,0.2858930087371638f},
{-0.22355310638989698f,-0.49711502707276195f,0.3078303574128083f},
{-0.22626594561310562f,-0.503815542834942f,0.3074661353300308f},
{-0.20241022096361908f,-0.5458122314595931f,0.32303097921842727f},
{-0.20282870977499787f,-0.5550209220793676f,0.3188992061831727f},
{-0.18718911274817185f,-0.5813483257533095f,0.3323900069179694f},
{-0.18087908072746078f,-0.5774719385574036f,0.335333246273617f},
{-0.19725018059193097f,-0.5858157697238167f,0.3014828574558106f},
{-0.2138120039067136f,-0.9886564752516543f,0.3368728303039551f},
{-0.2250815053907961f,-0.9957619436872877f,0.3381626220720719f},
{-0.2132491359985737f,-0.9798835375701949f,0.3505085179664468f},
{-0.20542300553460444f,-0.9983437168460204f,0.3467653035897067f},
{0.41900679680656294f,-0.18787501757375244f,-0.04808456745355987f},
{0.41992182953122825f,-0.2032774660537212f,-0.005971342253662404f},
{0.4072520384297831f,-0.2202394187104929f,-0.04533648922565308f},
{0.40620346635525706f,-0.186618255002086f,-0.07757592464357119f},
{0.39604569921490707f,-0.23859179440328232f,-0.06061105355254143f},
{0.40728393297469057f,-0.24674854936539972f,-0.026368271846429026f},
{0.4166235281729534f,-0.21529431725036363f,0.015358332526802007f},
{0.43436567912940754f,-0.14996627128768647f,0.0372207878261859f},
{0.4440440846780057f,-0.14891790213305245f,0.008604737807953898f},
{0.43086194315985504f,-0.17481303969111656f,-0.02073167145238802f},
{0.43014772357248765f,-0.1691628372898655f,-0.05852791300085221f},
{0.4196697074086764f,-0.16389262310331398f,-0.08314212245917052f},
{0.3996694383963943f,-0.15511230912441956f,-0.10707837549594972f},
{0.38831594295073835f,-0.20326336259002414f,-0.09093341975822565f},
{0.3672096341005932f,-0.2251617442719602f,-0.10635894904789826f},
{0.37549846866423836f,-0.2604229001729658f,-0.0901303340070612f},
{0.3904940606359558f,-0.2682048557201348f,-0.06168237177831067f},
{0.40062949702651685f,-0.27469446653321616f,-0.03896448058285291f},
{0.4043461246477752f,-0.28347680652380697f,-0.028440637458094477f},
{0.4103220878442135f,-0.25250023296080093f,-0.0026754823085383913f},
{0.4131154958262116f,-0.22931550383687285f,0.02583286399299179f},
{0.4147452750925189f,-0.20403906159262492f,0.03374214061710113f},
{0.43070769429452566f,-0.14010281660889695f,0.05772781580286137f},
{0.4453559649669303f,-0.11587344631934525f,0.04524282735299523f},
{0.4550533376821865f,-0.1225845001046071f,0.024814088207945843f},
{0.45988463826718395f,-0.14119900792634796f,-0.001751204511097892f},
{0.44276450583618043f,-0.16270265092353026f,-0.027464827569759365f},
{0.44772204915418967f,-0.1611254767800072f,-0.04718452955274551f},
{0.43432798808748047f,-0.1584012899789644f,-0.08046082399906833f},
{0.4176369218000267f,-0.1509176989167487f,-0.10163869451457742f},
{0.3461810966894699f,-0.2045012387380264f,-0.13224580832429553f},
{0.36159902763847507f,-0.2483456627787281f,-0.11029194451922189f},
{0.3539397090122057f,-0.27127328496265296f,-0.10578309214185554f},
{0.3662630701744917f,-0.28614206581317964f,-0.08088057920055843f},
{0.38564517188963976f,-0.28145933977339066f,-0.05070068719442931f},
{0.3805114133623914f,-0.2887445888588781f,-0.05514526283679484f},
{0.3946076569359642f,-0.29022854946583976f,-0.05077484325966884f},
{0.3925336552162692f,-0.3038121175259171f,-0.05738321957958486f},
{0.400829136203183f,-0.30381989860072817f,-0.028845568883391317f},
{0.40630073297761915f,-0.2854744944279975f,-0.008029457789352806f},
{0.41100980141909305f,-0.2663232390565692f,0.008166882364580068f},
{0.42334313327868967f,-0.2446803430803161f,0.019551233320304257f},
{0.43431347878399945f,-0.20189863494933427f,0.04213389912470446f},
{0.4200232703538815f,-0.1828313522913233f,0.04535891452973725f},
{0.4310467489986577f,-0.15758303623147582f,0.05612096967157222f},
{0.4368830130047445f,-0.11325746894112253f,0.07199626930822413f},
{0.43922392981335817f,-0.0856005957545295f,0.07858211939531387f},
{0.4506755418076254f,-0.07631725292506757f,0.06373839862024373f},
{0.46316826883599016f,-0.11885425454002146f,0.02021334180451992f},
{0.4623495295681319f,-0.1325083420433997f,-0.0026560795546777915f},
{0.45618405937832524f,-0.15166762178102794f,-0.03444926544510377f},
{0.4426555272301047f,-0.15587795774912397f,-0.0708403919199256f},
{-0.21741558071275516f,-0.9717982730921182f,0.34365132148745686f},
{-0.2299124606932549f,-0.9717065182414818f,0.34674724796895107f},
{-0.20726826979008556f,-0.9856060410726467f,0.35789322117198014f},
{-0.013546364663335813f,0.5944069910483892f,0.16046555048143624f},
{-0.03579161187163358f,0.6047032812936434f,0.18051667164361343f},
{-0.04693198724790417f,0.5963702718131978f,0.16867610577512568f},
{-0.036161317041126025f,0.5908854225637218f,0.15567754407716333f},
{-0.0564510815579513f,0.5843741301320242f,0.13668109321034985f},
{-0.08617589542767502f,0.6034741190145108f,0.1679213500177121f},
{-0.06550898676186157f,0.6060927715356027f,0.1800551935625519f},
{-0.07281898782454037f,0.6325113637968174f,0.19751473447948867f},
{-0.04030426235692588f,0.6262344427779581f,0.19096294518683415f},
{-0.00374699123650977f,0.6032401927505455f,0.17045619131137404f},
{0.018495959046099755f,0.6001830314052758f,0.15179693062298347f},
{-0.012010656296693803f,0.5847173994079442f,0.1301479767973895f},
{-0.02568152453145391f,0.5744603800050325f,0.12299070854409327f},
{-0.05020413637549211f,0.5716993935222168f,0.12033017590707377f},
{-0.07915191367118055f,0.5778847626103317f,0.12989531178444594f},
{-0.10032940490710097f,0.589346061639024f,0.14038357699641438f},
{-0.09802148223547975f,0.5974479018037752f,0.14647840769083728f},
{-0.11595475079554406f,0.6160085073027939f,0.16778472118593563f},
{-0.0966002844323876f,0.6245319980045707f,0.1905402418036673f},
{-0.10321567158145135f,0.6409797357189281f,0.20067799849288845f},
{-0.10244997833561895f,0.6591575588707035f,0.207689735999356f},
{-0.0924330439747554f,0.6773705179736191f,0.2105493670474655f},
{-0.07911610202867198f,0.6839748220843939f,0.2078964274390745f},
{-0.042097634365264334f,0.6450220030208832f,0.1942440525370883f},
{-0.026891569844427376f,0.6303942803779601f,0.18784910544723102f},
{-0.0007944844975228455f,0.6209564464541876f,0.17763737542691393f},
{0.03134158501478759f,0.6119317106845588f,0.1575322000176977f},
{0.05814270677018674f,0.6120250867695152f,0.12234605117058857f},
{0.0405145511094941f,0.5997751602975647f,0.11531960144074802f},
{0.011132304264126936f,0.5840271732385907f,0.11455460194721641f},
{0.0013841707660473355f,0.5750308473162478f,0.11033137790995962f},
{-0.021340017320508893f,0.5647653977073522f,0.10034273334429952f},
{-0.12510252826344884f,0.5992176628609118f,0.14159763289887597f},
{-0.1359262859261575f,0.6186745379002379f,0.15191229323759806f},
{-0.1450015604353772f,0.6373897566704654f,0.17340613764753535f},
{-0.12798013312691245f,0.6424072410371968f,0.1922284811222076f},
{-0.1253430499551074f,0.6560112349498574f,0.20226991354479545f},
{-0.12417471902244301f,0.6732398604665666f,0.2071000996639987f},
{-0.10761649727014125f,0.699022329676226f,0.2123402020259502f},
{-0.1007635419231346f,0.7242589730614488f,0.2121455678524839f},
{-0.08756192540739242f,0.7273775755752707f,0.20890499773468357f},
{-0.08165329974285969f,0.7110579047481375f,0.20495125343880227f},
{-0.07093086072590606f,0.6975652798591284f,0.19700094556260675f},
{-0.057579936603565494f,0.6683478496495913f,0.19901904019603966f},
{-0.04402297654712598f,0.6672170472104587f,0.19964420876065103f},
{-0.01927911402672123f,0.6577786863324119f,0.20568925183780576f},
{-0.015397603900348505f,0.6444903210316408f,0.2020751178853418f},
{-0.01407131948631608f,0.6338876015637365f,0.1954332045380416f},
{0.004730879673843211f,0.6329390105635311f,0.19430868411629817f},
{0.027288740380661525f,0.6358598787978926f,0.18545842014468975f},
{0.03268788306717215f,0.6288934200499416f,0.16601284168762295f},
{0.04545612643809714f,0.627903532195697f,0.1567570375310417f},
{0.06758405726381507f,0.625733277390692f,0.1347177720740443f},
{0.08694493207089021f,0.6365370554120983f,0.1163365360730567f},
{0.07567823746824555f,0.6219443890397295f,0.10307982308821245f},
{0.07580962862951163f,0.6220095167633873f,0.07801168076910955f},
{0.03853465428651419f,0.5938890884884614f,0.10129997553131384f},
{0.02380830726404571f,0.5764177835298283f,0.09281814821427103f},
{0.008909076743234955f,0.5687237730388839f,0.09102387740892412f},
{-0.013463259937100302f,0.5579733703859248f,0.09547050031114232f},
{-0.011539060906043794f,0.5495867018741462f,0.09052261215532362f},
{-0.2268804465408822f,-0.78555754842426f,-0.32460495020239877f},
{-0.2361081850703082f,-0.8028297804695903f,-0.334097132660174f},
{-0.2332495473735024f,-0.7704869398369757f,-0.324522315060416f},
{-0.2311165172133951f,-0.7484488185931911f,-0.3217526147087305f},
{-0.23584864627882451f,-0.7620563800712823f,-0.3356353993048259f},
{-0.23963413067515896f,-0.7991540863588995f,-0.3437152741880752f},
{-0.2352812185163579f,-0.8201392987794716f,-0.34708008121293915f},
{-0.2277220031413072f,-0.8267658922061306f,-0.34300628270954786f},
{-0.22309710927073476f,-0.8056937886378831f,-0.32959471422451375f},
{-0.21035471215704685f,-0.804524971122441f,-0.330831536463967f},
{-0.23162329530112918f,-0.7297838942087577f,-0.34115623655650734f},
{-0.23614376829513722f,-0.7360890221550112f,-0.3532724207587052f},
{-0.24314220339339754f,-0.7773698295864777f,-0.34813846037397267f},
{-0.24121450585341786f,-0.8162878760423193f,-0.3474868569781967f},
{-0.22674396963342275f,-0.8378960801538972f,-0.34707655508141294f},
{-0.21523983325936483f,-0.8387552652871375f,-0.3468825498533711f},
{-0.20943433020905097f,-0.8233426038808773f,-0.3385112405713226f},
{-0.19287531271329839f,-0.8231822759180507f,-0.3441659815787442f},
{-0.17395061687007066f,-0.8227996954282912f,-0.35317941014203574f},
{0.36428495607181943f,-0.08257820595452076f,-0.1998432806115458f},
{0.3461082686339947f,-0.07334276709327733f,-0.19663817260408406f},
{0.31777061195867623f,-0.0586095101704032f,-0.1976162050495607f},
{0.3372954109790198f,-0.07422675626169185f,-0.18754421565349982f},
{0.35491723575156403f,-0.08101067741151795f,-0.1884035027778902f},
{0.3700124040202259f,-0.09493913704424338f,-0.18789856903011676f},
{0.37750843694032143f,-0.08791456140178222f,-0.19186616393663602f},
{0.3715654636312445f,-0.0776741994909464f,-0.19655507000266426f},
{0.38235388136051274f,-0.09936507911600381f,-0.1847677073925585f},
{0.37841402698435844f,-0.1144815656598102f,-0.18159552765280496f},
{0.3699809142526942f,-0.1391831634726597f,-0.1843334333259171f},
{0.35569901385166186f,-0.1716167868527633f,-0.1913954556565086f},
{0.3292716269785841f,-0.19741011705747916f,-0.1867139662594121f},
{0.32275008124909826f,-0.1910583015999513f,-0.17801432303045706f},
{0.3320207389292914f,-0.160845188101558f,-0.1643524140807709f},
{0.34063294387054815f,-0.15488892088353626f,-0.15562053102436946f},
{0.3414349863372417f,-0.18022169623957876f,-0.14964477074782312f},
{0.33833397304714624f,-0.21167155123443163f,-0.13845715540821626f},
{-0.20338148587133675f,-0.20388619173263473f,0.29735230087750014f},
{-0.2056880964693108f,-0.21151949199160158f,0.2995642583763282f},
{-0.19476562305998518f,-0.21123896002176354f,0.30859989657491826f},
{-0.18383605807851824f,-0.21211427569280536f,0.31325990621088273f},
{-0.1855021695671615f,-0.21811358211367696f,0.30321126003925514f},
{-0.19663357290946432f,-0.22086767888183562f,0.3074933903400259f},
{-0.19992753858146048f,-0.22096008180123689f,0.2957823606687653f},
{-0.20550900532212604f,-0.21738603037068346f,0.2862727324123182f},
{-0.21688647187523202f,-0.2098790950216267f,0.282763322122645f},
{-0.21877418782204325f,-0.19961782067543016f,0.29469907760622344f},
{-0.1651862708805823f,-0.22217331752486805f,0.3183865922893302f},
{-0.1600421177553068f,-0.2363459142230345f,0.29773676607871713f},
{-0.16857099805191111f,-0.23756125776376358f,0.29992483321308905f},
{-0.1629591655711785f,-0.24968177871464775f,0.29727207633884156f},
{-0.1859118733283474f,-0.23870008456909605f,0.29938881447516025f},
{-0.19911064259115493f,-0.22861242996985529f,0.2998495329346366f},
{-0.2187146122416081f,-0.21661341128832814f,0.2834483605546553f},
{0.2528867693260463f,0.23731279244889858f,0.16698032761075526f},
{0.25138795625788063f,0.22785607316386977f,0.15451305268632953f},
{0.24581354071785963f,0.21394706728057994f,0.14495766865025872f},
{0.24056028680961017f,0.22305995102632525f,0.1334949513071382f},
{0.24217464522653404f,0.24495046982804863f,0.10410443786659015f},
{0.24929166415989337f,0.25980814639213007f,0.0820340874194374f},
{0.2410795067552242f,0.2597996354431525f,0.10329626530682447f},
{0.23045753645777636f,0.25124206163637636f,0.12630133064575746f},
{0.2379491115146952f,0.26960716284993136f,0.14169242729826081f},
{0.2525453242043386f,0.2936614525817866f,0.1327546230478042f},
{0.25132343623149095f,0.31704476803623965f,0.13809240743357204f},
{0.24641083701353755f,0.3360448555249917f,0.13783504657810186f},
{0.24011843458804968f,0.3614930529904863f,0.11727569820393569f},
{0.22876818267344187f,0.3887319250108859f,0.08915703246356893f},
{0.22000306643829035f,0.414776203377522f,0.0731080843949504f},
{0.23195142632814392f,0.4146334646384218f,0.05061349538534322f},
{0.22967312358630604f,0.4546836904139196f,0.040073433542935105f},
{0.23439046074777664f,0.40838920841013354f,0.02490548821437309f},
{0.24285354400380202f,0.3926216868587302f,0.02307207724284438f},
{0.24744378531878827f,0.356932072511443f,0.025819940864373257f},
{0.2559332927819001f,0.36294734692172076f,0.026303653016112902f},
{0.26889060862139835f,0.37416377688598995f,0.036317256728487485f},
{0.2900618231519686f,0.3964735961786602f,0.04322195771035879f},
{0.30991542251624804f,0.4123609180221065f,0.04237985609472649f},
{0.30225282104984125f,0.3881897453700585f,0.04313453217155419f},
{0.3054307962242063f,0.37702908119181255f,0.04755973374507004f},
{0.3170973673157809f,0.3731860886606441f,0.045023261655417535f},
{0.31388672628843706f,0.3494978441033709f,0.05490036508736081f},
{0.31794573182546165f,0.34367758845818724f,0.051572854951125756f},
{0.31500297905259184f,0.32871713350001786f,0.05370684127826338f},
{0.2953605279287999f,0.2944991590163029f,0.054877310837852245f},
{0.3068382602815198f,0.30517162768184486f,0.05226286120206241f},
{0.3238994853866015f,0.3138393551177359f,0.05337802712302601f},
{0.3361016290048241f,0.30042746153591154f,0.07247063227122298f},
{0.3426078962475735f,0.2964262488590145f,0.07293773367683053f},
{0.35727112137233213f,0.28535766356578735f,0.0677613917196835f},
{0.3414624633904693f,0.2806845023835249f,0.07379976925022914f},
{0.36021472513385894f,0.2834800181826209f,0.0872080910169914f},
{0.3566710288192945f,0.2772354379199501f,0.093432556712568f},
{0.38719385438047516f,0.2779646108972638f,0.10207234069820227f},
{0.37292127554558063f,0.2794819661689629f,0.11308621942599413f},
{0.3615416406181315f,0.2759614112213475f,0.11985482702962591f},
{0.09543580791526322f,0.6557249075454077f,0.12466278863982136f},
{0.07665325161312984f,0.6462497066140909f,0.14088512697530833f},
{0.1033724266668082f,0.6535117335896357f,0.10213451599055202f},
{0.09352829293647771f,0.6384556332434245f,0.07983029027500908f},
{0.10231498986150342f,0.6535902763367285f,0.05863057984211991f},
{0.09906546258344467f,0.6403878290180778f,0.05512303089093233f},
{0.0913421105135633f,0.6739411101793716f,0.13839034589299293f},
{0.10885146029592446f,0.6849269381537177f,0.1220833400293799f},
{0.11413169511295373f,0.673923967166926f,0.10181833917623188f},
{0.11583503124649473f,0.6728445130221369f,0.07673107564133845f},
{0.1163120417297597f,0.6805869948070712f,0.052417247117999555f},
{0.11600455859856076f,0.6903542782059521f,0.0354365907717072f},
{0.40997286164769464f,-0.18961000602322017f,0.10652623259466645f},
{0.4102133121580301f,-0.17916206025010425f,0.11322619696719233f},
{0.40812476076335713f,-0.22324397599538637f,0.09899781323484638f},
{0.4112472123806798f,-0.2392366706327962f,0.09166508620667285f},
{0.4064711113183422f,-0.2577847131594447f,0.08907534923898525f},
{0.40852306595113397f,-0.26262225432792663f,0.09626573805580355f},
{0.4130186350436337f,-0.17121207747069903f,0.12445237346072373f},
{0.4157951029330781f,-0.11228277883062071f,0.1278018212558575f},
{0.4167962161882585f,-0.17263954241747095f,0.11006321661667819f},
{0.4084217058714742f,-0.31557875149721354f,0.07274051360275115f},
{0.4100477157148663f,-0.28831288900636387f,0.09854137521644242f},
{0.3992785488151416f,-0.16096968848575893f,0.15079166335326016f},
{0.41501835002192833f,-0.1106838008915832f,0.14197529019083718f},
{0.41807040543525625f,-0.07101526424569105f,0.13997527136390833f},
{0.4324620950595244f,-0.09003537280964996f,0.13148129541354153f},
{0.32919053126552017f,0.14685955393005126f,0.29008346493029186f},
{0.34239942208754737f,0.14816462524731236f,0.29374327391938587f},
{0.33973574259859035f,0.16075526696680423f,0.2890909837385794f},
{0.3295872162813845f,0.1585507250745001f,0.28368903417063096f},
{0.32939446681937573f,0.16828433014575803f,0.28940786917890976f},
{0.34691172941511655f,0.17426572330852064f,0.28944631028075163f},
{0.34935323605772645f,0.15759151743303462f,0.2856848384257717f},
{0.3536437349448281f,0.14153316811769254f,0.28873203013613885f},
{0.34284652260369647f,0.13374553931281036f,0.2936303229705032f},
{0.33344885194482826f,0.1337525097704613f,0.2919025078985784f},
{0.32400331768923846f,0.13282588617657312f,0.28020896652230226f},
{0.3224917982236477f,0.14665991475338522f,0.2788796191865494f},
{0.3226181641959655f,0.15668223870907627f,0.2750247308751161f},
{0.31967788364607286f,0.169425182962787f,0.278216404735802f},
{0.324217790203768f,0.18406190313746554f,0.28616059208059574f},
{0.335211642544314f,0.18477065026219622f,0.2907158185589321f},
{0.35090516101720265f,0.1880389619727692f,0.28058676511450237f},
{0.3548790581268593f,0.16852174110734475f,0.2819551601869574f},
{0.3530408865059275f,0.15989040645103497f,0.27313316476239624f},
{0.3577379189293055f,0.15205414380376783f,0.2791652783364855f},
{0.3594665849898873f,0.13554731709175302f,0.2772931447250449f},
{0.35470385751708033f,0.13196313347790176f,0.2862778999639131f},
{0.34322221444120643f,0.12115043973014158f,0.2863116994060268f},
{0.3305791705188224f,0.12302143869003958f,0.2802062711936846f},
{0.3248291899631429f,0.12490581230187596f,0.2664575114678198f},
{0.31697505442926377f,0.13013598540042154f,0.27162109815678254f},
{0.31942713946645246f,0.19021424196672246f,0.2736898112103922f},
{0.33043631066523177f,0.1960773763911764f,0.28381683864312546f},
{0.34034847992939987f,0.2001374358367501f,0.2811614066260088f},
{0.35668821220323704f,0.17266812437482243f,0.27572679120508153f},
{0.3505755086222019f,0.1569374003803767f,0.2582812220132732f},
{0.35131611098275134f,0.14558917447746542f,0.2572521036881828f},
{0.35836873100421146f,0.14902510864289842f,0.270203441358926f},
{0.3591531842471785f,0.13653959536357346f,0.26841197743501694f},
{0.3527849949604607f,0.12316895932669908f,0.2674213002117683f},
{0.3536608779572737f,0.12207706332402982f,0.2763000547736565f},
{0.3576960133155905f,0.11088778637860582f,0.2832214058107489f},
{0.35101876003485016f,0.11039594361988513f,0.2899169781893822f},
{0.33691088522055757f,0.11086379402299973f,0.29042122243448604f},
{0.3285566796418657f,0.11245555821299749f,0.2848197356810214f},
{0.32297695525001086f,0.1090586930324229f,0.2729691895535528f},
{0.322289322418125f,0.11806863689809291f,0.25761024667346316f},
{0.31598443776326046f,0.11743908058922022f,0.25730791090811067f},
{0.2955967033101019f,0.10719888016437173f,0.2759929774822415f},
{0.2907615323734474f,0.11300089851706399f,0.29292988387485813f},
{0.2982308584859786f,0.13399535176078017f,0.2970850203202944f},
{-0.11199962749432354f,-0.9489484648435278f,0.3049999478915529f},
{-0.1268227237465499f,-0.9433305224554716f,0.29868290397928615f},
{-0.12169117502754931f,-0.9393049933885858f,0.30586294281920523f},
{-0.1169858345750858f,-0.9338181988704066f,0.2991339364667454f},
{-0.400056153777356f,-0.9338879066341396f,0.12565985412124023f},
{-0.40380115087440366f,-0.9234465276037065f,0.11168550803273025f},
{-0.4013888243247431f,-0.9173558711095747f,0.11136601863085402f},
{-0.4123735983905401f,-0.9246831065517709f,0.09095600973552058f},
{-0.4197816055114177f,-0.9543937585253679f,0.06534454674960077f},
{-0.42099897506384326f,-0.9759212313297612f,0.04765916236732845f},
{-0.43476426904247767f,-0.9854964537068953f,0.027785256140140917f},
{-0.44452818885822765f,-0.9901380040071356f,0.009524641672434631f},
{-0.43981044691938087f,-0.9983583068924952f,-0.031413055844283624f},
{-0.441811377292212f,-0.9944861332059696f,-0.035863350427898226f},
{-0.4298051852331419f,-0.9834395949996456f,-0.03532771734400498f},
{-0.3757039447094205f,-0.9410895059781845f,-0.03765899917617659f},
{-0.35678479038533717f,-0.922547948388817f,-0.0277626396026507f},
{-0.342451258027076f,-0.8987689221464629f,-0.02593363762353952f},
{-0.3338470370805223f,-0.8683894015877458f,-0.03592910709698039f},
{-0.3196419976350175f,-0.8356605754483359f,-0.013750988126249301f},
{-0.31713335638039386f,-0.8288258318960333f,0.0066403829488477905f},
{-0.3238736508158504f,-0.8256859121694746f,0.037336569029478225f},
{-0.32428654605010193f,-0.8043310870088896f,0.044023398854231094f},
{-0.33103332436043176f,-0.8257666424142514f,0.07740870484127164f},
{-0.185283431485269f,-0.3677553340297038f,0.32382286931607457f},
{-0.16845593928593058f,-0.3874229121606444f,0.3444429279222185f},
{-0.17073447469507907f,-0.3968052235897823f,0.3411460246926237f},
{-0.19184738003532556f,-0.37043307661086106f,0.31438337378648507f},
{-0.1727362666806453f,-0.39911756800271475f,0.3337436706437108f},
{-0.15890701893898462f,-0.4046504019634032f,0.35763275064884575f},
{-0.16403488110287934f,-0.3937815365898358f,0.3599277087579437f},
{-0.18139935351921593f,-0.37003509439505894f,0.3363883425945131f},
{-0.2034782255394244f,-0.3446464725099995f,0.30851604497599144f},
{-0.20817661571998547f,-0.3515731323989258f,0.29885871334874126f},
{-0.19792255406042092f,-0.3647269469375994f,0.30006556506383336f},
{-0.19332132957347992f,-0.3786864490641677f,0.3017089208395632f},
{-0.17783787568511114f,-0.40031978018289427f,0.3258739931459578f},
{-0.161853409396201f,-0.4284203499310086f,0.34614824969595925f},
{-0.1787511564992953f,-0.4036018713227818f,0.3188612729122647f},
{-0.17061053101257134f,-0.440933989394734f,0.3311822022230704f},
{-0.14987111832566521f,-0.48046043643269876f,0.3710428806337031f},
{0.08568787627466778f,-0.4852081680192472f,0.2546798752012279f},
{0.09900903810457838f,-0.5010971110970138f,0.25183201775648495f},
{0.10266068992649602f,-0.47292861736788205f,0.24723269816674984f},
{0.09652824999554764f,-0.48242164975190643f,0.2626847122207542f},
{0.11142783217334407f,-0.46673453441089746f,0.26067488630731783f},
{0.1094405186814324f,-0.4591260371246968f,0.24393743635722365f},
{0.11095475366138927f,-0.4551588671813021f,0.23794131078533956f},
{0.10854414927479103f,-0.5063845097299157f,0.24581666260321355f},
{0.10304849958750352f,-0.5211907158227554f,0.2526934328837217f},
{0.08999651152551871f,-0.48478392520716157f,0.2688384300553504f},
{0.1005650565213519f,-0.4775826488350915f,0.26736176500283f},
{0.11524797762452714f,-0.45149176370017463f,0.2546346463758787f},
{0.10347978403856346f,-0.4056279287027616f,0.247316469022683f},
{0.09711750173927713f,-0.4179120190227051f,0.22497568691675573f},
{0.10476526030615012f,-0.4670315209529193f,0.22438009259839184f},
{0.11057933592509457f,-0.5089774679180875f,0.23120977059024944f},
{0.11206913127575673f,-0.510437921689813f,0.2392346892422278f},
{0.11137654443624599f,-0.5342273234068539f,0.2435929304386111f},
{0.09481089114130314f,-0.5195992767295481f,0.24916157072976897f},
{-0.043875924432311295f,-0.7368363527442303f,0.23546174869492323f},
{-0.05083940418875915f,-0.7477556336180826f,0.2310397375320652f},
{-0.06108789776898386f,-0.7433091031453439f,0.22482087178806276f},
{0.3146578866848673f,-0.38265556427626524f,-0.22881636977334208f},
{0.3055904144986148f,-0.3629831235047716f,-0.23931527818676568f},
{0.29863058198818376f,-0.3312279325049067f,-0.2333367014671112f},
{0.30125752341502066f,-0.36152104743631813f,-0.24074835583400556f},
{0.2769443631461952f,-0.35549977467153693f,-0.23834141994158023f},
{0.2582774116876575f,-0.3505224939412065f,-0.2297478166986943f},
{0.24774415669209743f,-0.3152751174695155f,-0.22690802505405586f},
{0.386701726896461f,-0.5737878131783211f,0.08399931239054108f},
{0.38425276321342244f,-0.5808898776593262f,0.06743747420204911f},
{0.37376850540371886f,-0.5622281957435334f,0.06619061645840885f},
{-0.12368503401398738f,0.9013128321532033f,-0.17387620742056809f},
{-0.09348483833217351f,0.9099165867027277f,-0.1716974820380823f},
{-0.10278845933953269f,0.8871225846116573f,-0.18360703535780687f},
{-0.12724883214675245f,0.8777507294001997f,-0.1845948770146067f},
{-0.11959118468797042f,0.8569902427919455f,-0.19211202528995502f},
{-0.09286486600416802f,0.8565291801123384f,-0.19333026495437813f},
{-0.07230928705291687f,0.8943027859999715f,-0.17879760018797694f},
{-0.055383946031735735f,0.915365649807483f,-0.16246771643455202f},
{-0.05947582459126234f,0.9327417545269471f,-0.14910461818109993f},
{-0.10665239086625715f,0.9265160606879403f,-0.15739527689895744f},
{-0.14832835238393177f,0.9241296303286841f,-0.14860740495089236f},
{-0.14857877252916965f,0.8943616518919888f,-0.17034083932083754f},
{-0.14282807272340192f,0.8547633499641041f,-0.18722260781044753f},
{-0.13671150941478782f,0.829186497037458f,-0.1923960217716662f},
{-0.10771459469541196f,0.8317010346554352f,-0.19733054589962462f},
{-0.08156618548954385f,0.8106479981201797f,-0.19777527618394636f},
{-0.063868306129001f,0.8464335818898912f,-0.19147967166131474f},
{-0.061487842252013716f,0.8765173111153743f,-0.18392284776624765f},
{-0.04120944337395555f,0.8951069554071037f,-0.16931068727294657f},
{-0.04088472267601568f,0.9418202098851545f,-0.1327988075262748f},
{-0.06521982697818678f,0.9577734700694187f,-0.11926101543156961f},
{-0.09031171623669126f,0.948726464107246f,-0.1347855536924151f},
{-0.1279746011694383f,0.9426328498697671f,-0.13676792273837227f},
{-0.15659165516305204f,0.9467361716238312f,-0.11945753431649343f},
{-0.17329416995708224f,0.9249112267570463f,-0.13350046307886404f},
{-0.1798597397414591f,0.9028726391162325f,-0.14800252943788755f},
{-0.175380411677173f,0.8741411351163141f,-0.1665621840819152f},
{-0.16041695754175195f,0.8374874897960974f,-0.1834633043298108f},
{-0.15092452329332556f,0.7934847648666733f,-0.18688187237715784f},
{-0.13316320331272952f,0.7844229064432966f,-0.19188693400934995f},
{-0.1127586392574298f,0.7988170682905419f,-0.19721948072460735f},
{-0.0818255521709621f,0.7722249773968621f,-0.19542414644904116f},
{-0.042893879272530785f,0.7505309360461578f,-0.18650383049356886f},
{-0.04851972384988867f,0.7997657793428303f,-0.19009289693372156f},
{-0.02844696993985462f,0.8172919990988294f,-0.18160798969643333f},
{-0.0247424877646967f,0.8591259682806706f,-0.17415775292745822f},
{-0.03771490573123484f,0.8741248229067771f,-0.17640817171387657f},
{0.2780672623336183f,0.26966795382490283f,-0.22218758778659145f},
{0.27276030902253895f,0.27394605228802904f,-0.23276173592122232f},
{0.282823991451922f,0.2121450462102484f,-0.224172591603921f},
{0.2833118225587467f,0.2215417043944723f,-0.21684898322199317f},
{0.2871015618983659f,0.20873253707465014f,-0.21052628623776168f},
{-0.4014742153525887f,0.1708930130319473f,-0.14896038038457782f},
{-0.43065350937132585f,0.1077281706736306f,-0.133793639826474f},
{-0.4089479993282969f,0.24760000548181182f,-0.14317485697556617f},
{-0.39026532423414967f,0.3713676948235304f,-0.15150201046415496f},
{-0.4102265242615732f,0.3577310339954834f,-0.13155367725773598f},
{-0.4234346862718418f,0.22284369472908017f,-0.13145916652123676f},
{-0.4373142273368888f,0.1094873947700932f,-0.1285537201986661f},
{-0.4476217440454867f,0.02450020088245935f,-0.12092181806837911f},
{-0.41720331811271416f,0.08655150492857963f,-0.1398072324451862f},
{-0.4064123059835702f,0.08009293979656469f,-0.14624446124112378f},
{-0.43316970859512016f,0.3806636006253627f,-0.08695716197841179f},
{-0.45011755778819484f,0.34478237146760954f,-0.051278651917569966f},
{-0.4323677883053249f,0.4451908205782905f,-0.08005533480967046f},
{-0.41636715110711664f,0.4079926859426643f,-0.11447394075894735f},
{-0.4160089273788426f,0.45112139240098437f,-0.10929431596166293f},
{-0.41221858034195513f,0.5075299925201868f,-0.09702293097673659f},
{-0.4298076170846223f,0.49375371536959756f,-0.06391500904518874f},
{-0.44301598095237504f,0.43493303092971547f,-0.053691505421505054f},
{-0.45721698749782763f,0.33846532861775047f,-0.027924658918713142f},
{-0.46521001160489833f,0.2349707813602391f,-0.0032471448285414876f},
{-0.4557661793266224f,0.23969419655679905f,-0.036340943110643883f},
{-0.43442051318378f,0.27061719289387354f,-0.08244451999238198f},
{-0.41865830048421054f,0.33122230918036055f,-0.1120591621720579f},
{-0.3953904496355221f,0.4390986235928322f,-0.14041609942433864f},
{-0.39992468187309627f,0.4970082465884482f,-0.11829664023850921f},
{-0.3975429537308134f,0.5528050017994026f,-0.09436540176660008f},
{-0.41672363248657995f,0.5263601893134013f,-0.07667331252862968f},
{-0.42115435751830754f,0.5319703495642387f,-0.047375779957332324f},
{-0.43300366700308357f,0.4949590074700225f,-0.030836408506829185f},
{-0.44289832884892677f,0.45558607942322066f,-0.033193637524979946f},
{-0.4506093612378265f,0.40696101465160284f,-0.033520396983509976f},
{-0.4603147583192825f,0.3261526255306289f,-0.0023893833217683495f},
{-0.4669443923570979f,0.1739734379210646f,0.02378292793504177f},
{-0.4672233434641125f,0.16520990361114427f,0.018611088462199686f},
{-0.4607522950403129f,0.1532443603373482f,-0.009904078497480026f},
{-0.44557534155591755f,0.16592505386775458f,-0.05328809323937858f},
{-0.4326894163341256f,0.12858458739522002f,-0.08661266668387732f},
{-0.42359562086952873f,0.23643123513196457f,-0.10367919107912268f},
{-0.4220081934282173f,0.242697781738545f,-0.11259883878008156f},
{-0.4196504576415405f,0.28826252237683836f,-0.12366915579804133f},
{-0.4325217120738641f,0.1634999603634237f,-0.12155846701180109f},
{-0.4471331023215019f,0.05919161828400846f,-0.11506194629831408f},
{-0.4582206951528837f,0.003971328738772621f,-0.11119034099996754f},
{-0.46876408339414943f,-0.05322484597754706f,-0.0966673005859303f},
{-0.4365364215795979f,-0.024716567670116835f,-0.12198457434959584f},
{-0.4108112575848806f,-0.013829545747051695f,-0.1427862377598064f},
{-0.4074976363059647f,0.04063101278498954f,-0.15517006586268148f},
{-0.41479423296928625f,-0.02836567608773387f,-0.15003047259173266f},
{-0.4152287301415681f,-0.07597195763745108f,-0.1409027555081238f},
{-0.4238251296418138f,-0.1282441037525817f,-0.144729679121144f},
{-0.4322555268591119f,-0.1887818633838226f,-0.13853432021237783f},
{-0.4438953900807144f,-0.23492290820184725f,-0.12764579923189073f},
{-0.45600383357959795f,-0.2652239667564649f,-0.11465840237761897f},
{-0.4676706065286567f,-0.2853765797368704f,-0.10894042791966742f},
{-0.471179165829673f,-0.2997786448358251f,-0.10258791339779964f},
{-0.4634898564932941f,-0.3143767008030214f,-0.09854697304320097f},
{-0.45748446991251757f,-0.33388622133662843f,-0.0894128018321376f},
{-0.45306359340120217f,-0.3840743567880722f,-0.07699976282648657f},
{-0.4508647662005158f,-0.41045006920760874f,-0.08150031673643765f},
{-0.43939815938239757f,-0.4165528838967347f,-0.0986486667189134f},
{-0.43820810539721233f,-0.42066725044240644f,-0.10190288452745966f},
{-0.43809685748805144f,-0.40524745496769227f,-0.13210756888227687f},
{0.27483159629027576f,-0.7519398694134746f,0.12323237551137266f},
{0.2807659162877285f,-0.7223866269684461f,0.12665998039956392f},
{0.2782397070575346f,-0.7192590279852769f,0.1344370467459846f},
{0.2675962569989548f,-0.7199956580030191f,0.13936184453042916f},
{0.2763174405462871f,-0.712546678062485f,0.13987298911426838f},
{0.27884342773324833f,-0.7171522392981123f,0.1194013733147643f},
{0.269902218465756f,-0.7742388266486805f,0.11283471456238069f},
{0.2655055170441902f,-0.7552005615352239f,0.12531962439406877f},
{0.2618417771461939f,-0.739574723751964f,0.133169697280477f},
{0.26006445811988643f,-0.7289318410191554f,0.14676299274647603f},
{0.26482319306413815f,-0.7071976778374516f,0.1504227900490841f},
{0.2707839585168337f,-0.7020835749171229f,0.14230037210743288f},
{0.2648140138606473f,-0.6914170238630909f,0.1535231148989177f},
{0.25846193386357436f,-0.6896957340999441f,0.15412278142642294f},
{0.2610835866243259f,-0.6602621293985635f,0.15422339144616767f},
{0.26716729178414717f,-0.6323308022772217f,0.15872750229747148f},
{0.2669981904576135f,-0.6257426297666561f,0.17753601534725427f},
{0.2766298075661954f,-0.6329481196481064f,0.1752539038734124f},
{0.2805376654062921f,-0.6265251366785126f,0.18249111725211273f},
{0.27788142277201533f,-0.6162071233807376f,0.18181404262905715f},
{0.2850109844919965f,-0.6093208286141998f,0.16886484358523837f},
{0.2881253511858741f,-0.5972332168076833f,0.16998419645538695f},
{0.2858396933947577f,-0.5894797922222907f,0.16230449234803138f},
{0.2848672130925037f,-0.5812179895630002f,0.15940352301197816f},
{0.297715873297901f,-0.5748781697520715f,0.16107228945774232f},
{0.3133272835830814f,-0.5752588049731282f,0.1575018247159604f},
{0.3210346272920597f,-0.571558793410041f,0.15035870560989714f},
{0.04285276302781974f,0.2440979300556688f,0.17659226892666888f},
{0.05290357757379055f,0.2540160976743404f,0.17089638192711745f},
{0.006554702414873517f,0.23816095510109528f,0.1865733958946551f},
{0.05689755100386044f,0.2361916356102862f,0.1760621879859983f},
{0.05422731645870676f,0.22893167608034265f,0.18477437400157537f},
{-0.004014402469876343f,0.226313590885022f,0.19876673533934416f},
{-0.034242697775895316f,0.22868599746116727f,0.20648837587024127f},
{0.017539309682644274f,0.24877579345490483f,0.1825013514265605f},
{0.005592545529323469f,0.25509105358445616f,0.18402009420286133f},
{0.040469357343602595f,0.27129076263355917f,0.1744915285271751f},
{0.07140542873361261f,0.2636414125797847f,0.16957713702724375f},
{0.09685254254313949f,0.24862843430423257f,0.1679372468257949f},
{0.10028337927589315f,0.2434015036743276f,0.17228954066324967f},
{0.08844238844428076f,0.23689762791156185f,0.1725720285258686f},
{0.10699623596721104f,0.22608355622087017f,0.17574021573706666f},
{0.13816112131479746f,0.21413535887941185f,0.1843952282762703f},
{0.05696375282181562f,0.21805584024912428f,0.18880925544442528f},
{0.018119690321148053f,0.22192931007317993f,0.19207646225087438f},
{-0.04578147183183002f,0.21489038873804078f,0.2147327922256974f},
{-0.04875031521573362f,0.23785132378130158f,0.21226054481306295f},
{-0.037767262250591085f,0.23858844038182153f,0.20500981548218525f},
{-0.011453336282145328f,0.2732225525684286f,0.19839705248041578f},
{0.008709891214704354f,0.29061345025425944f,0.18947931923833314f},
{0.039496891915057945f,0.3070794252611081f,0.17940766343832504f},
{0.06415594560709781f,0.30335615121658127f,0.17577587970488937f},
{0.1006567104432461f,0.2993221919437117f,0.17653845797101866f},
{0.12583939094850188f,0.26258769420181993f,0.17361987072622811f},
{0.15966097470331625f,0.23921994195939691f,0.17117038965058534f},
{0.16252542802048195f,0.23269539705265943f,0.1731985251002443f},
{0.12978354063943792f,0.2308100513376756f,0.17419621421504847f},
{0.1535181794834297f,0.2164070141355733f,0.17711815548129983f},
{0.18091105601536206f,0.21032673311612826f,0.18214745382289466f},
{0.14418790585130445f,0.18676217832589592f,0.21722293164828457f},
{0.11225755461315728f,0.1927311710646832f,0.2143756011578161f},
{-0.2650383147098406f,-0.7736412870616138f,0.143560923225355f},
{-0.2687234121920706f,-0.7805189901361804f,0.1303941919325097f},
{-0.2570892232905891f,-0.7521765515633027f,0.16567130519884338f},
{-0.2558412967646905f,-0.7771286098928869f,0.1782533350406156f},
{-0.2543594843463236f,-0.7848805747299464f,0.17812247083362406f},
{-0.24499401208099725f,-0.7949195954868021f,0.1869131188533005f},
{-0.231475429381931f,-0.8063707623321967f,0.2148027634665676f},
{-0.2136651929584721f,-0.8018092952703758f,0.2176798201276006f},
{-0.1887322027242878f,-0.7953572947562277f,0.23122669155946246f},
{-0.1640580925887441f,-0.7816840786002043f,0.23683679019064674f},
{-0.13799600295514894f,-0.7665862351886733f,0.2352787861336736f},
{-0.12078594938939168f,-0.759425811584177f,0.2392718937013771f},
{-0.07795146402556019f,-0.7296412372750589f,0.22641695147859064f},
{-0.07686753183184553f,-0.7495159923660879f,0.23192524594365008f},
{-0.2716732979709866f,-0.7562990232181679f,0.12197285174180424f},
{-0.2740310953773165f,-0.7255365970729012f,0.12009521698271593f},
{-0.2831510505094548f,-0.7421059188620169f,0.11942606473471032f},
{-0.2668269218191446f,-0.7991338219923039f,0.14072163834924264f},
{-0.07630371731834573f,0.7325099147256827f,0.1837623583174337f},
{-0.0713810921578756f,0.7241451721863169f,0.1821971606971692f},
{-0.06053909507785981f,0.7366926918351497f,0.18622013679808397f},
{-0.05694460929546093f,0.7224524941279405f,0.18555761185000622f},
{-0.04671657025283021f,0.7089925350919104f,0.1886742680327175f},
{-0.05570861785891628f,0.6914994274001708f,0.19350913512073803f},
{-0.08028655565214374f,0.7298479786479445f,0.18768018579243317f},
{-0.08110212363268493f,0.7298060326627327f,0.1981701986652515f},
{-0.08318747399262197f,0.7459649707496633f,0.20483516201242902f},
{-0.08913189536354602f,0.7508933754086276f,0.20736864554890788f},
{-0.089940432329191f,0.7646251939795311f,0.21716994193387265f},
{-0.07552470997782008f,0.7786080000214435f,0.2121774836455478f},
{-0.072493069792997f,0.7930574825058392f,0.2083212577626799f},
{-0.06771972886615332f,0.8117836440765249f,0.1975890222832968f},
{-0.06110350560214191f,0.811469432716656f,0.19607687493468948f},
{-0.05490880007417987f,0.8115324334998751f,0.20601373561880365f},
{-0.035334249558433686f,0.8153194371393799f,0.21645460894311871f},
{-0.03616936265548227f,0.8036087325649097f,0.21488783046003077f},
{-0.03373688860408513f,-0.703026410854214f,-0.3303563501349143f},
{-0.028645914301811907f,-0.6784509346598857f,-0.337613350859103f},
{-0.018093243803497493f,-0.6616363400913784f,-0.3448151934945366f},
{-0.052258087272561655f,-0.6583378761847084f,-0.3466505284866119f},
{-0.017986651365366462f,0.6724243626049408f,0.20631437046925f},
{0.0015831151280047413f,0.6572564066523008f,0.206388586029327f},
{0.00795550942484045f,0.6716576611340953f,0.2050358646593143f},
{0.01915994905454954f,0.6532032369213845f,0.2008974653865397f},
{0.01303731089806954f,0.6389278618291301f,0.19816235597078732f},
{-0.21242452055311017f,-0.41431737919117356f,-0.27951341025295856f},
{-0.19718241809690076f,-0.4774237806205978f,-0.3018495719473139f},
{-0.17805827537282082f,-0.4997376519366609f,-0.2965007735797647f},
{-0.1377328062935704f,-0.5511195693623003f,-0.3105560028997763f},
{-0.10648783770756436f,-0.565824942329755f,-0.31671879794671354f},
{-0.0764569823940417f,-0.5709635231260595f,-0.3257312140353608f},
{-0.07140207577455955f,-0.5568232671840816f,-0.335363499398456f},
{-0.0495541106553161f,-0.5563103494416051f,-0.3400328104148097f},
{0.0011611618047527967f,-0.5533284873123798f,-0.3396005018026195f},
{0.014101488680938f,-0.5570797260553199f,-0.3386953579698633f},
{0.029625320440588906f,-0.5550124918733838f,-0.3332550894769713f},
{0.027481307108526806f,-0.56930723997208f,-0.3230529041284323f},
{0.028483261790693954f,-0.599698593629001f,-0.31475750388451224f},
{0.05195528086054865f,-0.5932816090139107f,-0.30665736569707513f},
{0.07497159816061279f,-0.5688178280024319f,-0.30567298961455625f},
{0.0696887487579596f,-0.5815585836960511f,-0.3039565221204656f},
{0.046323671658405875f,-0.6077379812129636f,-0.304921161853071f},
{0.05265457043094184f,-0.6075560927460113f,-0.31511909119591736f},
{0.06604410776518982f,-0.5989948716932184f,-0.3192587058632283f},
{0.042997050757508995f,-0.6245261515743844f,-0.32665872898940285f},
{0.030855750172240615f,-0.637631169722278f,-0.3342301036218556f},
{0.012459108195579178f,-0.6574783670170855f,-0.33924361564578004f},
{-0.017862541947240188f,-0.6511416260639944f,-0.3445873877619733f},
{-0.07809850339148117f,-0.6371402990667047f,-0.34343992889317265f},
{-0.11922875594957863f,-0.6044283322768548f,-0.33059611114258f},
{-0.13123768370876332f,-0.5833364498623812f,-0.31107876916266497f},
{-0.14441072782882428f,-0.5648785409520488f,-0.30660775975154264f},
{-0.16943847209089655f,-0.5267968240501999f,-0.30498535678267036f},
{0.32216794232566637f,-0.5472710639969983f,-0.06317866162792424f},
{0.3379982011831516f,-0.5652377782173751f,-0.061055216511091866f},
{0.32627667492271395f,-0.5706571342749064f,-0.030825121486240285f},
{0.32217171174858145f,-0.5699324999037632f,-0.031207540490012415f},
{0.3285942888783912f,-0.6023623952948564f,0.023436249392454783f},
{0.3438860971464673f,-0.6053802454262868f,0.0027669694324061614f},
{0.33813336070492495f,-0.5835695655091863f,-0.03257137677054852f},
{0.3627096878879102f,-0.5979750345627688f,-0.04346940098890907f},
{0.37416129988217767f,-0.5920388702253555f,-0.06120757960255599f},
{0.3608314337450678f,-0.5642835957648578f,-0.08042110694544491f},
{0.34006863639982376f,-0.547594150711724f,-0.08028714263245956f},
{0.3204584463516345f,-0.5315181314296619f,-0.07732740939553916f},
{0.3149678016675467f,-0.5550170315419621f,-0.07293286466183065f},
{0.3147792264058291f,-0.5837945749843899f,-0.05792996757400153f},
{0.3224369237977783f,-0.6037931823908547f,0.000923077807817449f},
{0.3253696665642486f,-0.614621033510861f,0.047561501591668304f},
{0.3258697366090613f,-0.6171228859795693f,0.06370573701689619f},
{0.34334837643122457f,-0.6206693785514936f,0.043197522330695334f},
{0.3676762287376745f,-0.6261399617888777f,0.022075218930948742f},
{-0.4490503032723044f,-0.2830288943280899f,-0.028005319044574387f},
{-0.4379518898173629f,-0.27829721147394126f,-0.0024541009560109153f},
{-0.4361889377318898f,-0.2804344774539929f,-0.020551039813876702f},
{-0.43840920325980354f,-0.26962721367255704f,0.017904648887235457f},
{-0.45059323070002516f,-0.27836011026601065f,-0.0006759447523481465f},
{-0.4579530512522065f,-0.2900135903685325f,-0.0125142360057116f},
{-0.4368754752213221f,-0.27340276880548564f,-0.05664530192357503f},
{0.42639668774943973f,-0.12981284769012086f,-0.055253765484170894f},
{0.43308614065907897f,-0.1277662837145644f,-0.036531757928028f},
{0.4292686384785308f,-0.13702644374317258f,-0.04729991129070072f},
{0.42014647460055243f,-0.1348729675447338f,-0.0715083085876465f},
{0.4435692223833355f,-0.13919880636527557f,-0.051655660078358354f},
{0.436908828452155f,-0.13691864016013647f,-0.03239817136263926f},
{0.44325622748041066f,-0.1287208709444579f,-0.008927246572830312f},
{0.4413704769880505f,-0.11727075907002028f,-0.00935268990574292f},
{0.4251368048860309f,-0.12081538711623543f,-0.019672927885475155f},
{0.41956174233965293f,-0.127805757476799f,-0.04729421784723914f},
{0.4112932114516923f,-0.12660370784501465f,-0.0652400196322552f},
{0.4143750142837412f,-0.12295249054789185f,-0.07926227925065397f},
{0.4102932328480545f,-0.12361892728153141f,-0.09462681464546317f},
{0.4332004281169885f,-0.1377633988577052f,-0.07426329671595898f},
{0.45641656626545435f,-0.13876005424970886f,-0.02733081757323811f},
{0.4538592720451052f,-0.12865918860933262f,-0.011408470269063746f},
{0.45730391901699985f,-0.10681438415332825f,0.016679571566137825f},
{0.44745395904223156f,-0.11493223267898237f,0.009068186655505671f},
{0.4478157896450256f,-0.09689483859172514f,0.018699439358208062f},
{0.43078441288740643f,-0.11609407973677345f,-0.003949580188464341f},
{0.42647547378792144f,-0.10423682556638338f,-0.013740937748352944f},
{0.4131148073859498f,-0.10917836158589736f,-0.049241317078671604f},
{0.40179831454195897f,-0.11708895134606166f,-0.08724558657588109f},
{-0.021028724394898037f,0.829039300435181f,0.21624429044313195f},
{-0.026627479697879358f,0.8430672545594491f,0.1953867199466592f},
{-0.03889666549863605f,0.8385263758986063f,0.1954587373849743f},
{-0.03590322206185813f,0.8523614796321237f,0.1829816851214597f},
{-0.022664164170024634f,0.8502450240962829f,0.1792041942814987f},
{-0.005046263931935918f,0.8409414381483816f,0.16175486629085348f},
{0.024461131366397156f,0.8441822919290675f,0.15304980265724438f},
{0.0421507834408481f,0.8356301491510235f,0.15072341427545233f},
{0.07019142276431814f,0.8368156432818821f,0.1441065673780556f},
{0.07903818185255657f,0.8326427348785758f,0.1451791828037626f},
{0.0901906793019558f,0.8247628242687828f,0.1416994083799899f},
{0.33891258583905187f,-0.9978773240664233f,0.13565475095687074f},
{0.3416129832043806f,-0.9910279904676459f,0.13737212999686363f},
{0.34833291234449926f,-0.9831024048212229f,0.13127470596497295f},
{0.3335766766030712f,-0.9813221068034121f,0.14491791122513845f},
{0.3379064059610186f,-0.9826115341656496f,0.15388858212365028f},
{0.3260421016523917f,-0.9668005665092047f,0.15247886894899992f},
{0.3208325158924164f,-0.9669310652479092f,0.13857729992039022f},
{0.32996704088528095f,-0.9646730279350748f,0.1299700298634177f},
{0.3426610283246322f,-0.9803815412318142f,0.1399248643628861f},
{0.07647184972895534f,-0.949433013110215f,0.21406620356774084f},
{0.09893123585572985f,-0.9277546157145343f,0.19726125459975372f},
{0.0953855029053908f,-0.9186358961626807f,0.1935734819746544f},
{0.16675969472453103f,0.09716950394562825f,0.32608194035170945f},
{0.14977883545834667f,0.09478372271754465f,0.3153939499080422f},
{0.13903136080131612f,0.08897465316420776f,0.3081197456141626f},
{0.11516031729359615f,0.09980047827251746f,0.3126804626160685f},
{0.11529084577971933f,0.10916665916385411f,0.3091702417092352f},
{-0.1818449751636915f,0.01261036266449197f,-0.2698885415587952f},
{-0.10618292879049247f,0.02975436633661108f,-0.2968372753179257f},
{-0.05340098203740416f,0.004652192970491652f,-0.31757624179355104f},
{-0.013189096039684144f,0.00816918247749185f,-0.3148726019595818f},
{0.03661507247980619f,0.01464444547307948f,-0.3014059561287863f},
{0.05777078541799965f,0.02973507513557066f,-0.3148638073477186f},
{0.02086833056278721f,0.06570319544099941f,-0.32860219159889664f},
{0.01264674110156796f,0.09283029047314811f,-0.33113411552070837f},
{-0.015071095170062f,0.10397830987362208f,-0.3316701342586371f},
{-0.04194383808566254f,0.16866691063551753f,-0.3154615902261741f},
{0.003758895516037138f,0.20186431811461644f,-0.30428220217265917f},
{0.005876436832661265f,0.2635011067545727f,-0.2996115535848708f},
{0.011717358434593463f,0.3670998092866956f,-0.3037492240458867f},
{-0.010866102050849766f,0.41586988210049886f,-0.3089941083053976f},
{-0.031988054856018584f,0.4243969786143878f,-0.3107601413735238f},
{-0.06041546268084089f,0.4361270561953f,-0.3106304118180749f},
{-0.08774591106736451f,0.4501694378176477f,-0.3168083642372583f},
{-0.10883184506050157f,0.46243719574230574f,-0.31748627072563024f},
{-0.12541156144764465f,0.4671539645155971f,-0.29782371778363786f},
{-0.2676568673645982f,-0.6585374346183809f,-0.34154137107464555f},
{-0.258424142955313f,-0.6520739239780035f,-0.33178628624225565f},
{-0.2582351225447225f,-0.631724184415406f,-0.31619108830027814f},
{-0.269075435708357f,-0.6127784847697458f,-0.3091960571566457f},
{-0.2734170810323176f,-0.5789372560320899f,-0.2996589709703116f},
{-0.3199404832344613f,-0.49881540546295594f,-0.2245765912975672f},
{-0.35441980047812377f,0.2983777358347083f,0.11043704924051814f},
{-0.3692689257217307f,0.3106170839120802f,0.10194405070533788f},
{-0.3569350265363628f,0.25948903202021134f,0.1135474892751246f},
{-0.3392566667945398f,0.24419146868902059f,0.12360941873161885f},
{-0.3613221036055646f,0.2630413603982438f,0.11480035068530739f},
{-0.37816932259314606f,0.3246295151958152f,0.10546651586219828f},
{-0.3783671779870967f,0.3879002158684653f,0.084515512973155f},
{-0.3702448312267689f,0.3794185914713144f,0.08816508885020907f},
{-0.3611141967713098f,0.38816348371136716f,0.09313802751981407f},
{-0.3323755183314407f,0.3513787319551779f,0.11109763423193218f},
{-0.31754645453453734f,0.2852929809910026f,0.12319828603192652f},
{0.29755331746589375f,-0.9578089417414276f,0.1732379276811555f},
{0.3048519401409118f,-0.9526444233208143f,0.1684985540568598f},
{0.2785964317283867f,-0.9537970295554613f,0.1645740599728434f},
{0.2887109758693354f,-0.9484535411021539f,0.15407104854045195f},
{0.3118928269305023f,-0.9476329373085863f,0.1602312704356699f},
{0.316852863719645f,-0.9519116838404775f,0.15891964406221212f},
{0.3199292758944583f,-0.9687212521576287f,0.17212016523550072f},
{0.3078813407700684f,-0.9706101654380435f,0.18055604447710594f},
{0.3029134219773725f,-0.9585796155550803f,0.19098201328223416f},
{0.299323604414897f,-0.949637272698453f,0.18676262028754545f},
{0.29460876072456005f,-0.9456172543408853f,0.18175538921860232f},
{0.30985207857530567f,-0.9670716154269178f,0.20005359911153256f},
{0.3160723010140833f,-0.9718567947640044f,0.20983656683693408f},
{0.31319601353630583f,-0.9798575999458861f,0.21251385258273245f},
{0.3193401261418787f,-0.9756177598504583f,0.19900064991682337f},
{0.31613828078880585f,-0.9787695137376287f,0.1839981076732033f},
{0.020695206960279426f,-0.9793320374256376f,-0.2678963239924259f},
{0.00949904030019814f,-0.9860207200896137f,-0.2506842337908941f},
{0.006126679555794718f,-0.9716392423292293f,-0.25493627245281314f},
{0.016582714501987037f,-0.9617663853413083f,-0.2643468322432499f},
{0.01620409041891749f,-0.946984170541667f,-0.25887057468574487f},
{0.006129511935020031f,-0.9399774284767289f,-0.2527558854645103f},
{-0.003904631307573373f,-0.9539377412204573f,-0.26458922802228796f},
{-0.010130218905798825f,-0.9726034762220509f,-0.27990839222910113f},
{-0.004291761027581452f,-0.98076995859009f,-0.2695327486195938f},
{0.01944636782607081f,-0.9937759273953136f,-0.25631595560826487f},
{0.037979992416310025f,-0.996283939704513f,-0.27152466233732897f},
{0.05410976103436935f,-0.9937566361942733f,-0.2827352968669867f},
{-0.0035656573464350203f,-0.904716758096093f,-0.24707913880409f},
{-0.00827426045328761f,-0.9268069171368902f,-0.2535775229808783f},
{-0.0121259668533256f,-0.9414973770858958f,-0.2610891392987524f},
{-0.034024150927408736f,-0.9535720200802579f,-0.27376782700321073f},
{-0.03593727754425432f,-0.9746288855332655f,-0.29619207505402934f},
{-0.022811306589503307f,-0.9834310033076745f,-0.30097409372787687f},
{-0.03508063369049881f,-0.9932297764740872f,-0.31832308473758486f},
{-0.04465068107918329f,-0.9995313389797252f,-0.31881654979303375f},
{-0.06860188431868539f,-0.9988277785299301f,-0.3364079780156844f},
{-0.12468922718941329f,-0.9969571843474083f,-0.3352234761737219f},
{-0.15713561646177931f,-0.9989151562603833f,-0.33305459931164827f},
{-0.21327106197098653f,-0.9983020545236942f,-0.33278634665129503f},
{-0.24199308185637206f,-0.9986987384771507f,-0.31817406504350343f},
{-0.38511320729991944f,-0.9901409213789859f,-0.09492913128747506f},
{-0.40106245476987984f,-0.9996772383820646f,-0.07736237429902193f},
{-0.4295752716834806f,-0.9991489199759531f,-0.056025766245179985f},
{-0.18262819282637394f,-0.29556603956464383f,0.2639063983361177f},
{-0.19038368379495965f,-0.31276289058852813f,0.2645915791307747f},
{-0.29003888470491146f,0.6129442936944717f,0.04295180121520744f},
{-0.2805514448356066f,0.5566978435674925f,0.0785951721376854f},
{-0.27790018808118894f,0.5782524704531387f,0.07639525384417671f},
{-0.28957636333937914f,0.6283526597859502f,0.033452006605463186f},
{-0.2698390774447056f,0.5865952073395059f,0.07745269808633617f},
{-0.27333021007039054f,0.5657759547055689f,0.08777865182009402f},
{-0.27079340225986964f,0.5463048550880554f,0.09302598386720246f},
{-0.26837473313557464f,0.5205706128185891f,0.09864640803990625f},
{-0.3065173430035449f,0.534382959776785f,0.0837970543786198f},
{-0.3214733199127889f,0.5715107778890022f,0.05776895010850527f},
{-0.2899398353622417f,0.5940710576984074f,0.049907121679663304f},
{-0.2975120407976031f,0.6183901547020831f,0.023373137056415322f},
{-0.2539494257409287f,0.628146738591895f,0.05007492155662787f},
{-0.2602342085775929f,0.6018378558733303f,0.07159838695875627f},
{-0.26764525524721905f,0.6127088280015878f,0.0847412926940219f},
{-0.2770953291713872f,0.5814407796682856f,0.09190952818315574f},
{-0.27751089954850794f,0.5671161226648813f,0.10562645817098934f},
{-0.26993389202983886f,0.5555745799741899f,0.09496621463213387f},
{-0.2625503234758481f,0.5456046178498943f,0.09954169379057995f},
{-0.2572239780349862f,0.5120725338492544f,0.10869230894974906f},
{-0.2549027168332922f,0.48991850391324027f,0.11077694962126805f},
{-0.26035830418441763f,0.4595312830227058f,0.12007923836923165f},
{-0.2873353670478406f,0.5148929333641104f,0.09723008350144526f},
{-0.28853255403907185f,0.46558068197188746f,0.11315568814796952f},
{-0.3116981736336953f,0.45817239118812414f,0.10606123369411775f},
{-0.3405409064194339f,0.5072993501587669f,0.07974445303588261f},
{-0.3506919463935217f,0.5413533898051354f,0.06290703582276963f},
{-0.3535121631742341f,0.5622052264866496f,0.04944806376359628f},
{-0.32734964519262993f,0.5975590285984452f,0.03418308023035162f},
{-0.3188993278288671f,0.6205698128786274f,0.01197327388423608f},
{-0.2929227312142675f,0.48682964881813906f,-0.21931215129747095f},
{-0.2812380237589435f,0.502395261889791f,-0.2234060516190628f},
{-0.2782986356316125f,0.5579592265507309f,-0.20548819328430362f},
{-0.313612071558612f,0.5328004364099314f,-0.1875417221823663f},
{-0.3250917289942861f,0.4747539104813233f,-0.19536580644889076f},
{0.36072881789937494f,-0.9737585143081783f,-0.009150903602889915f},
{0.37061808908798294f,-0.9765038568359706f,-0.024068190806864204f},
{0.3599869194012956f,-0.9645089719832378f,-0.030051574921865533f},
{0.3431276229617136f,-0.9572554963281675f,-0.010164778500701624f},
{0.33551008777226093f,-0.9470490146024391f,-0.014901471670089081f},
{0.3410773703062358f,-0.9392232899782537f,-0.027292904488078546f},
{0.3555567616953395f,-0.932428587513957f,-0.04557002983558264f},
{0.37550195442426776f,-0.9642444069403981f,-0.04123202219596849f},
{0.38713654810312526f,-0.9783661833609035f,-0.036077498908045305f},
{0.3851402381418663f,-0.9845385422029598f,-0.02293953655632638f},
{0.3255492846657078f,-0.9383598892108173f,0.004622635722769217f},
{0.3174351248199751f,-0.9269897777069901f,0.005401194727198413f},
{0.32706226281722367f,-0.9282425679358494f,-0.013478156488228709f},
{0.3312664378824211f,-0.9093433943154763f,-0.022880407187172064f},
{0.3487721096089391f,-0.9229256662380235f,-0.044974577879865446f},
{0.38472807171937357f,-0.9726110958108745f,-0.04891458418033686f},
{0.38589551129188393f,-0.985735729194191f,-0.0319159327705341f},
{0.3791968589930052f,-0.9941473228556342f,-0.021827386811139507f},
{0.37942211175959767f,-0.9893303690257227f,-0.039244597151236654f},
{0.36490304368836746f,-0.981920619556034f,-0.05333705111614603f},
{0.3922662131730762f,-0.9655341583370182f,-0.09587744712405752f},
{0.2076418516856821f,0.11214292771595201f,-0.24130137628414106f},
{0.22139083451718725f,0.0018664853203109464f,-0.22634398106046869f},
{0.23866559934274015f,-0.10005623807941588f,-0.23114549385524866f},
{0.26042922734268686f,-0.15418706347346284f,-0.23598177819528968f},
{0.2763556787282369f,-0.1745826799301745f,-0.23460323075378836f},
{0.267291590310864f,-0.07690482287723155f,-0.22738456914029162f},
{0.30628349748257344f,-0.06634177902904607f,-0.20245942053816365f},
{0.35402570879972717f,0.08114422632304895f,0.2711978678193412f},
{0.3598432893020418f,0.07170679717665271f,0.2679358391885651f},
{0.3468252026733204f,0.08030806037985923f,0.2606959400429174f},
{0.3544414810343321f,0.09250736630681747f,0.2627872675092017f},
{0.3384362648584565f,0.08366828842705584f,0.25513419052882463f},
{0.3359097709029692f,0.07060525663587101f,0.2535037228222556f},
{0.3430031215151049f,0.07292489660324471f,0.25344473475334023f},
{0.35491723575156403f,0.06805525690755523f,0.2590480658467655f},
{0.36103273452755097f,0.055309800059370404f,0.26637380223153967f},
{0.3605925640975559f,0.06560122766407162f,0.28064676565806207f},
{0.3604972427438966f,0.07295091497054725f,0.2763764695179032f},
{0.35308814134297334f,0.07997492328723707f,0.28153608492646665f},
{0.3609581237517681f,0.09832729791761867f,0.2772692331124325f},
{0.3572112621290114f,0.10652425651613713f,0.2637622614683376f},
{0.34355847182557087f,0.10982490898289861f,0.2528705394531146f},
{0.34178003833346937f,0.09487807196805653f,0.2505684472755627f},
{0.3328436927689378f,0.08601548725305866f,0.25543261557102315f},
{0.3287341091832333f,0.0787284543848558f,0.2610567985425639f},
{0.33307145813000427f,0.04220153944283631f,0.2588980326156319f},
{0.3426966922924548f,0.044608233106280565f,0.2554566482981261f},
{0.35198279100777974f,0.04348180778733119f,0.25676072626408347f},
{0.35601666953765554f,0.04514741250744848f,0.26560237835797224f},
{0.35390351702770056f,0.04514011801541502f,0.27944025816310086f},
{0.35766569857109864f,0.05476413572092138f,0.2833538094466593f},
{0.34982323464943604f,0.06685596316163378f,0.28931374409644617f},
{-0.4385603722048876f,-0.7068698899681601f,0.010216993719818972f},
{-0.4461933888009687f,-0.7132469949812317f,0.009381622457672243f},
{-0.44625114022719164f,-0.7304673528403524f,0.0032052424020498887f},
{-0.4265742001586165f,-0.7073656243266943f,0.02534881293316029f},
{-0.44301508852981347f,-0.7585291776379907f,0.017694070097334858f},
{-0.452384836986581f,-0.7507794821040165f,0.004182022268716853f},
{-0.45133561684329f,-0.7333848564291753f,0.006000106945157517f},
{-0.45171799441315746f,-0.7205974121618739f,0.03265347220936302f},
{-0.43500240987823086f,-0.6896761188645211f,0.026190490648075816f},
{-0.4368528204371506f,-0.6963453477790617f,0.012628874058198772f},
{-0.4230857023043039f,-0.6758347947332678f,0.02380418246571773f},
{-0.40541338128848126f,-0.6965087545997258f,0.048729013407910075f},
{-0.4010853124739433f,-0.7137281392932912f,0.06060678798517842f},
{-0.422347328875343f,-0.7651846271232166f,0.05701594094953374f},
{-0.44428972398809197f,-0.7822937763822653f,0.029587797790300005f},
{-0.44877248681683246f,-0.7883939966715158f,0.019901564420947027f},
{-0.4533662946348418f,-0.7770112414523244f,0.010150872644857478f},
{-0.4539856380174229f,-0.7613644912337038f,0.006346433830758915f},
{-0.4609444368050535f,-0.7785117373744636f,0.038391752467814906f},
{-0.4569514917857451f,-0.751740149493815f,0.023360603831463593f},
{-0.4636051171167588f,-0.7521648788886782f,0.04482793904168942f},
{-0.46293738318318145f,-0.7224926467687668f,0.060013314232806154f},
{-0.44039603123134535f,-0.6770434907883206f,0.05768607379994932f},
{-0.4212985549433328f,-0.6504285018190804f,0.04605793106132283f},
{-0.42372259453911476f,-0.6697468941249991f,0.025734067503381194f},
{-0.4165915528850521f,-0.6511928532438471f,0.030807375026157734f},
{-0.40816107386235245f,-0.6415973665001173f,0.03904702010813261f},
{-0.41110147552673565f,-0.6356261862636462f,0.04139985288275958f},
{-0.39443432085189417f,-0.5840511953416154f,0.06283470922378143f},
{-0.38952387088494334f,-0.5589757712793729f,0.07726897059146226f},
{-0.3943118464793897f,-0.5548549208588279f,0.09261907105133722f},
{-0.3779983365551549f,-0.5091672989458382f,0.09981270764883515f},
{-0.38793542990657987f,-0.5134077881724389f,0.11196917091838864f},
{-0.3964658092606061f,-0.4939911571410109f,0.1309541116589728f},
{-0.39102744566492004f,-0.424352023890254f,0.15437215828719003f},
{-0.38914469434981175f,-0.37236365115119413f,0.16937149949607422f},
{-0.37856264296347153f,-0.3743801447360552f,0.16280052949279172f},
{-0.3696787814072337f,-0.38048911926567197f,0.15666872806893797f},
{-0.36979602767089803f,-0.37834180290772407f,0.17788018660740623f},
{-0.358508897654f,-0.34988977696909473f,0.19874840667978097f},
{-0.3621449767022174f,-0.34471974677675554f,0.2125932059469856f},
{-0.3670779603388492f,-0.32816696030281717f,0.22093299465167598f},
{-0.37493805385573503f,-0.31806925532568003f,0.22961918248569896f},
{-0.37642010850308294f,-0.3209947025377092f,0.2421555978480864f},
{-0.36879767030158045f,-0.3260316406538762f,0.246934860636071f},
{-0.3744859674597268f,-0.31107580610727886f,0.25607663974947226f},
{-0.35846417453476903f,-0.2964771010089098f,0.2606327575879624f},
{-0.34088484394986734f,-0.29718049891030984f,0.2514096596558568f},
{-0.34012063488774746f,-0.3077828539723348f,0.23782347701015552f},
{-0.3252625939177867f,-0.2805257457218515f,0.2493512200857839f},
{-0.30591360320449046f,-0.29334982606012305f,0.2664305209973698f},
{-0.4532083177805019f,-0.4256816548888925f,-0.13208953344726962f},
{-0.44920418666934675f,-0.4366776139841286f,-0.11168764559724695f},
{-0.4423570820021578f,-0.41613155845649935f,-0.13555047244295304f},
{-0.43720873449084263f,-0.3963540699878325f,-0.15395954565341638f},
{-0.4452593071042441f,-0.42182504441439683f,-0.11116325810003792f},
{-0.44535782949263936f,-0.43268580361636283f,-0.112002352039156f},
{-0.45185449150636536f,-0.4472681348855417f,-0.0862730149065553f},
{-0.460960121131574f,-0.4430386702648004f,-0.1040727855506635f},
{-0.46883188626067657f,-0.4505828100730066f,-0.0997631463244308f},
{-0.453894450492558f,-0.43086173545912804f,-0.14162921403347928f},
{-0.45784119458336964f,-0.031436050598954775f,-0.07620641404291412f},
{-0.46505211549355213f,-0.06224564977586582f,-0.05607767230362422f},
{-0.4539052307446208f,-0.04426677736049476f,-0.05780913462156574f},
{-0.4464096440358059f,-0.01664978377592032f,-0.06340547507159167f},
{-0.45023131935423755f,-0.05284258845976227f,-0.028515046376393127f},
{-0.4621101329663455f,-0.07472946107787684f,-0.031362721086992534f},
{-0.47930074340674533f,-0.07428122484777731f,-0.05280281616093266f},
{-0.4724721596949335f,-0.048859451589369274f,-0.07711012043790141f},
{-0.46208670793651074f,-0.007307756726177039f,-0.09964775396239749f},
{-0.44909087131458475f,0.006169872276573263f,-0.0909065195924396f},
{-0.43672203803556053f,0.0699167728153282f,-0.10092148743644412f},
{-0.4404600243034605f,0.028391259930241476f,-0.07091739523809983f},
{-0.44746895492849015f,-0.008908355899534832f,-0.036399070629232005f},
{-0.4490645289128998f,-0.07063714161910845f,0.009397967601851473f},
{-0.45676794171297574f,-0.08339637789660784f,0.00011738384547589384f},
{-0.46284854676680326f,-0.0963686280027117f,0.023570170146719877f},
{-0.4790585909190961f,-0.09141931090838658f,-0.02152992962245721f},
{-0.48702648695661027f,-0.08798272867418859f,-0.0467152799585432f},
{-0.4785503328972806f,-0.05652963121069511f,-0.07853043113047099f},
{-0.42978471900906196f,0.15357425496132981f,-0.11280635039863049f},
{-0.4318740810208951f,0.10789068719654878f,-0.09911060057292603f},
{-0.44683413013928047f,0.05557177070233448f,-0.042248455371790186f},
{-0.4613700989939753f,0.09972128639425162f,0.00691049801009449f},
{-0.2538787862455451f,-0.808742277548188f,-0.331415336993216f},
{-0.26434624526293404f,-0.7811774832466137f,-0.31733939815773565f},
{-0.2535933289530932f,-0.7919568630726301f,-0.34014008704357135f},
{-0.2461291512688162f,-0.7698235830235814f,-0.34918334376857735f},
{-0.2538798805255909f,-0.75175927814646f,-0.34084616008784063f},
{-0.2662963542956963f,-0.7554022267235864f,-0.3192000227053548f},
{-0.27713348554793554f,-0.750722905700833f,-0.28801424510815615f},
{-0.2621895053476985f,-0.7975029898798555f,-0.3087727057047138f},
{-0.24235702027626393f,-0.8273871001144208f,-0.33191816398629936f},
{-0.23352823606578754f,-0.8356683565231471f,-0.32807695417543853f},
{-0.21110400820071737f,-0.8495618799374006f,-0.34767125803962307f},
{-0.19864572974563902f,-0.8474372597975287f,-0.3529970765262105f},
{0.2501953896782213f,-0.7363295948422448f,0.14954853784826155f},
{0.25684561105460696f,-0.7122743319448342f,0.1529339130883553f},
{0.25200247630899775f,-0.7041347603666592f,0.14923754983369256f},
{-0.34358917222409846f,-0.2580760253813455f,0.2645895116851736f},
{-0.35421505430710803f,-0.2772752665263938f,0.2598339777756578f},
{-0.3750762932977537f,-0.2955366979857071f,0.25422367622458153f},
{-0.36378634577533975f,-0.277772459570853f,0.25304954985730566f},
{-0.37910441676451495f,-0.29467426932141827f,0.24318682399027478f},
{-0.3789901686156946f,-0.3034356968766484f,0.23866985587963674f},
{-0.3623718708888785f,-0.3373138878444727f,0.20634644774830124f},
{-0.2988649544634296f,-0.4266325948727693f,0.24079159901915514f},
{-0.29302761636304553f,-0.47862404753207455f,0.23644180821450417f},
{-0.30548761698118626f,-0.4091677748514174f,0.24129714152660456f},
{-0.30883609161076475f,-0.4524234135454189f,0.2238680672784769f},
{-0.3049845679448703f,-0.5116913610498451f,0.21009515264861092f},
{-0.30640816147757727f,-0.5576772656423865f,0.19100462769490878f},
{-0.3059067134898332f,-0.5791355172658245f,0.18385510545696587f},
{-0.31608480449161624f,-0.5805458785092398f,0.17924747783814515f},
{0.03276558013764724f,0.6468803572030094f,0.18932825228439895f},
{-0.19586507809423306f,-0.9455563008175188f,0.3080884577041153f},
{-0.21464421875525247f,-0.9440313270194037f,0.2994700929223678f},
{-0.2004002123160391f,-0.9524293027375197f,0.31026173187212047f},
{-0.19026852410023695f,-0.9414915402173796f,0.31530689727437944f},
{-0.20932707376603776f,-0.9559548828740833f,0.32852012378268525f},
{-0.20923359675233913f,-0.9508913601272502f,0.31780035990860084f},
{-0.21831740133387711f,-0.9471038082853147f,0.32380550319798856f},
{-0.2188394579083478f,-0.9448328010979182f,0.3043707559885595f},
{-0.22983329006314532f,-0.9462488377238623f,0.3022939165776f},
{-0.2272883165861855f,-0.9487881368807011f,0.29270973810261536f},
{-0.20025949958863543f,-0.9391986484914747f,0.3027586477513802f},
{-0.19111104324213918f,-0.9250060307181016f,0.29513104093587494f},
{-0.17813671719117177f,-0.9359773493889664f,0.31234104350605724f},
{-0.17677851379685192f,-0.9356359446387555f,0.3229452227222944f},
{-0.18992967231599697f,-0.935155449457869f,0.32706947709746736f},
{-0.2002498136166184f,-0.9413133808018456f,0.3270415538329589f},
{-0.22630284622362087f,-0.9592872280282682f,0.3335238287201021f},
{-0.038466174666211196f,0.9874908693950263f,0.07890829877917885f},
{-0.03796822943702147f,0.9773350687715353f,0.10326983153806767f},
{-0.06639904440369519f,0.9908289589882479f,0.087433359719701f},
{-0.0969284005856929f,0.9979430902971755f,0.05232594804031439f},
{-0.06641288014062374f,0.999926088288557f,0.03709229385102172f},
{-0.08363672269736586f,1.0,0.0021771301771568836f},
{-0.05029307584542801f,0.9963781253442217f,-0.012895794459156451f},
{-0.019796335583241998f,0.9854200495867266f,-0.029428067963071257f},
{-0.016471655701416572f,0.9749414246632392f,-0.059843723136271496f},
{-0.03131056270669305f,0.969653205851507f,-0.08562690203434889f},
{-0.03515817246221003f,0.9566317460779842f,-0.11039310167898954f},
{-0.23140175033779875f,0.6921578387052025f,0.07484336394415848f},
{-0.2457031852312603f,0.6908682902284746f,0.06196767608403772f},
{-0.2363748972393348f,0.6844885504440303f,0.07879896320407861f},
{-0.22845522920442163f,0.6952105432497032f,0.08343704261799904f},
{-0.2166734984181244f,0.6606687532395038f,0.10382937623457332f},
{-0.2356517831737698f,0.6621767465735684f,0.09010802875505969f},
{-0.251213748999405f,0.6849110105358085f,0.0567565817049702f},
{-0.2534450189474297f,0.7099155921827754f,0.046198093461480225f},
{-0.24419239563983605f,0.6977758214647555f,0.05121993051301523f},
{-0.23693349001844138f,0.693161262697373f,0.059280745800127016f},
{-0.22665584184305473f,0.7019065607772097f,0.06276855733899339f},
{-0.23446183011732669f,0.709629467698218f,0.07434470690173511f},
{-0.22738365812559325f,0.7145200591383573f,0.08526338007831909f},
{-0.2136637544582954f,0.6732999630012761f,0.1056275577630742f},
{-0.2001126684546455f,0.6529855230006222f,0.11702965517888092f},
{-0.19556433169096646f,0.6420858562997849f,0.11808148884538809f},
{-0.2131727818115723f,0.6401949180700816f,0.12209683154617755f},
{-0.23633785532858068f,0.6365028501302006f,0.11991728492245352f},
{-0.23560629087128332f,0.6485986084798153f,0.10357915900922733f},
{-0.24159114960832698f,0.6536385043393297f,0.08151417797115368f},
{-0.2540943923492095f,0.6757943169956514f,0.04692105135309695f},
{-0.2571578367742763f,0.7073642155739361f,0.03966655259930423f},
{-0.2521228853607167f,0.7275772147519367f,0.038102343018304376f},
{-0.24586912589455487f,0.7229081470269717f,0.047993681652513345f},
{-0.24316862653807625f,0.7135551368052738f,0.04695425053479709f},
{-0.2320634859168726f,0.708423121689244f,0.05268130326749753f},
{-0.2290572266546652f,0.7160663915831135f,0.05862502769889725f},
{-0.23334221377004088f,0.719352778037783f,0.06659177421115942f},
{-0.2291518786914033f,0.743988518252808f,0.07301720390594296f},
{-0.2168841813239905f,0.7111413111981912f,0.11263778558804165f},
{-0.20068119049715794f,0.6860064730415009f,0.13835845134808528f},
{-0.18540522804158976f,0.6607779347654713f,0.14777423818495436f},
{-0.18482837778424324f,0.6323439431994415f,0.12212274367269893f},
{-0.19886692942643075f,0.6166252169764106f,0.13564565249637345f},
{-0.21910473157719768f,0.6210769755579892f,0.13715786040222605f},
{-0.2410065788334147f,0.6101231643054493f,0.14188676718476334f},
{-0.2516347705910064f,0.6270445892914375f,0.12387098459720677f},
{-0.24382452631104176f,0.6336513252536924f,0.11208950772637646f},
{-0.24538573246515868f,0.6464457389162369f,0.08937986400275905f},
{-0.2531616694720758f,0.6640656991630722f,0.0583629401910739f},
{-0.26416226916463226f,0.6655167102541693f,0.05705314965831432f},
{-0.2695227593301465f,0.6938041129151904f,0.033246274519998446f},
{-0.25859510880755576f,0.6878984651797532f,0.037533640366463984f},
{-0.2578244966135562f,0.7146797390324189f,0.030348932244213533f},
{-0.25612863770619215f,0.7370363658884459f,0.0335481428259139f},
{-0.2422746687971669f,0.7347160778523073f,0.04410001333114633f},
{-0.2359260129404703f,0.7309009671517428f,0.05379296005545989f},
{-0.2357604175597145f,0.7217235240705188f,0.05500417295461804f},
{-0.2365817905365375f,0.7276472869215491f,0.06486491424385711f},
{-0.2374606121533571f,0.7432661946186547f,0.06951326926612993f},
{-0.23945509902281167f,0.7589879200189374f,0.07005092942412743f},
{-0.23162064034400837f,0.7652564522657176f,0.06875994669685402f},
{-0.24016021908727408f,0.7774432759632991f,0.0555389359265137f},
{-0.25070761898043586f,0.8270690492127214f,0.05036126808441798f},
{-0.2508933777990453f,0.8626238684441143f,0.04841913029746501f},
{-0.23858122185194658f,0.8855278626783124f,0.07409835152878377f},
{-0.2251119614355271f,0.9021167178974497f,0.09142405774648814f},
{-0.19805327696717354f,0.9311225334694702f,0.10719711231777347f},
{-0.1682969903284432f,0.9243451163802658f,0.14232518570427727f},
{-0.16770285469600446f,0.9032798610927709f,0.15595407395677557f},
{-0.14078611747293154f,0.913689365764045f,0.16220613144562349f},
{-0.13419861321687934f,0.8867826991046168f,0.17523072213496646f},
{-0.10466516342937822f,0.8791030555545065f,0.18362093696401974f},
{-0.10062893910305462f,0.8729220434008262f,0.18407332720866207f},
{-0.08564499855780532f,0.8627550152515839f,0.17890202000213354f},
{-0.09097583267167053f,0.8557380188264495f,0.18262405846637567f},
{0.19184046907251212f,0.7384019041462959f,-0.09274422481634222f},
{0.20488749250279395f,0.7262383439925619f,-0.09585158068107202f},
{0.20425463316803544f,0.7044351211158904f,-0.10234086639736303f},
{0.20472118743362017f,0.692793312625585f,-0.10428487614687981f},
{0.4285079757336856f,-0.4580418414538449f,0.04980671245499491f},
{0.4363265684142327f,-0.5186330975680238f,0.050508089656737566f},
{0.41238170243732586f,-0.44867185076809635f,0.08390286169737818f},
{0.41702665669219435f,-0.3736153067285109f,0.07215517258217558f},
{0.4186700528394209f,-0.39968787382794263f,0.05779546674507136f},
{0.4132949120701867f,-0.39633477878679213f,0.049239810584394944f},
{0.30185309754763623f,0.025673394455676807f,0.25888042320615706f},
{0.3078173275122048f,0.01616771729388054f,0.2629208068590625f},
{0.30745705652407807f,0.020150287900910068f,0.2519419493423674f},
{0.3086326415772791f,0.031908491666222616f,0.24888896113498096f},
{0.3194526308794805f,0.029241934114504396f,0.2412051837560763f},
{0.3150860210967664f,0.0020338644837822038f,0.24869278753259588f},
{0.31134542024324247f,0.0020533182332177304f,0.2603221743507696f},
{0.3036245807678352f,-0.0007981259002967126f,0.2707419525055804f},
{0.2999388957740854f,0.013897439980650484f,0.27309936425787473f},
{0.28938436287487745f,0.02462048669487225f,0.2602503587699387f},
{0.2999311550707711f,0.03988579001286819f,0.26657289426818287f},
{0.3069304613434368f,0.03603209797263059f,0.2593180810416779f},
{0.31008515278820603f,0.04876604469458613f,0.2467756269532902f},
{0.309379201920835f,0.08501753466111725f,0.2380338964388844f},
{0.3217446312452314f,0.06410527141051087f,0.23090682712762878f},
{0.3208042271596208f,-0.037301859103870204f,0.23901563775003085f},
{0.3104719489121613f,-0.016299057459571678f,0.25374208570124135f},
{0.3057113483797927f,-0.01161827668848545f,0.2645132180554174f},
{0.29803545406684906f,-0.01226355769537547f,0.27004410674740303f},
{0.2935554673097199f,0.0022146990421855017f,0.2751458273046892f},
{0.2926694319438605f,0.01613561982908087f,0.2721447355940766f},
{0.28289098370128896f,0.012057484577003206f,0.2686193371292488f},
{0.2911024516032884f,0.037914039732986536f,0.2669185337759302f},
{0.29149804127669915f,0.04985899460580441f,0.26453080727914385f},
{0.30416671897475794f,0.05100073878298712f,0.25831502251779465f},
{0.2971153345335826f,0.05874816501387604f,0.2532330584961704f},
{0.3015901335533684f,0.05838998165709884f,0.24622807896579152f},
{0.30393216482777624f,0.07068744662898076f,0.24496975571705001f},
{0.29896680006345916f,0.0893634752998595f,0.2412692182620961f},
{0.3038297922734723f,0.10140788535513108f,0.23763044388526108f},
{0.32136764327019135f,0.0911931359718138f,0.22602067230251027f},
{0.2935319615368915f,-0.9028281709748764f,0.07288812773129809f},
{0.2870235057340506f,-0.9117351738980634f,0.06888019001295445f},
{0.2921852480830526f,-0.9331345787528248f,0.04700221718507646f},
{0.2759970895316758f,-0.9089729709583032f,0.08365913897098363f},
{0.27748862829355647f,-0.892830163409174f,0.10448434427588818f},
{0.2801070991429127f,-0.8856736303420834f,0.09679588592816626f},
{0.2886241049074084f,-0.883902734633404f,0.06506327003188693f},
{0.2957247500115775f,-0.8964581979054429f,0.05697694952044555f},
{0.3110080887645807f,-0.9224874814482282f,0.03309245592983262f},
{-0.3660978806335199f,0.329117059922115f,-0.1803646421482021f},
{-0.37136999971727735f,0.29493199458276764f,-0.17526488704536722f},
{-0.20226379460700533f,0.5918563028798117f,0.14531293357277786f},
{-0.21459518013549136f,0.580092668085767f,0.14976128819972875f},
{-0.20230618680349796f,0.5686796788650772f,0.14367782526888842f},
{-0.18641131655255125f,0.5796852038802477f,0.13477639573708036f},
{-0.18791919833379558f,0.5643155009338435f,0.1302393661797386f},
{-0.19888727453602006f,0.5566344592550533f,0.13683850273891843f},
{-0.22134817990596506f,0.5531828003916028f,0.14234895495424293f},
{-0.23118434026567053f,0.5603957483758896f,0.14633994514317822f},
{-0.24295314154890232f,0.5744817375892664f,0.14830955785854322f},
{-0.2236562290041158f,0.5906430671561804f,0.15090086506497616f},
{-0.18983455494463747f,0.6002452810661724f,0.13699009558471922f},
{-0.19136155475444885f,0.5474170143949124f,0.11498524364155047f},
{-0.2173232989078444f,0.5466742234742715f,0.13542260847562104f},
{-0.24208803880415206f,0.5507402802119409f,0.13874964371556436f},
{-0.2576556980732489f,0.5629941779642904f,0.13928783082783636f},
{-0.2651329678089865f,0.5833827835918544f,0.13773034310105958f},
{-0.24541590484700396f,0.5899049773901051f,0.14777140155609775f},
{-0.2993805069772786f,-0.9973198266297701f,0.2596963258451589f},
{-0.2946103224640428f,-0.9972929158399061f,0.2831314751143249f},
{-0.1605692611383787f,-0.855070721542483f,-0.35961657731832025f},
{-0.1804534790957842f,-0.85570230492546f,-0.3590639021507235f},
{0.15720222305711073f,-0.5403220319243784f,-0.27364721609400755f},
{0.16235425924834726f,-0.5329719398405267f,-0.2857820030569839f},
{0.15612576808957307f,-0.567793613751799f,-0.28351211033538165f},
{0.16796565614187717f,-0.5341686391865725f,-0.29170645541068385f},
{0.1610818739698134f,-0.4698879095323882f,-0.26860128150849316f},
{0.15922631604504706f,-0.5014832580897963f,-0.27134279405612516f},
{0.27943827199169735f,-0.6041115679510148f,0.09350678820876215f},
{0.2842067545276192f,-0.591798945606887f,0.09864618493426583f},
{0.2906633945766798f,-0.6010050428891935f,0.0976971849070528f},
{0.2999005566633935f,-0.6187801422991042f,0.08624777103454731f},
{-0.43500127522668824f,0.2782759441943715f,0.08210865038686871f},
{-0.442626591490952f,0.37327768096288527f,0.03992154216053926f},
{-0.4465247421108755f,0.27878294538774606f,0.07428190372636878f},
{-0.43582451272922035f,0.24875439443676645f,0.09472274475879844f},
{-0.44512281001103626f,0.22702201397537017f,0.0906623102832674f},
{-0.4527594334816374f,0.2890650514263096f,0.05799675477866079f},
{-0.4478913342772745f,0.38109465240911206f,0.026163303632180696f},
{-0.4331208728952511f,0.46702918046851055f,0.006936556748893851f},
{-0.4254690113094103f,0.45511802503780635f,0.028051629401075678f},
{-0.42063041623237934f,0.4134465723788835f,0.04541396319048776f},
{-0.43322482631237846f,0.33998722249562013f,0.05659701867576784f},
{-0.4215907999592921f,0.2629852705778381f,0.08914479352558098f},
{-0.42862870881978704f,0.2034628094708763f,0.11331188759404082f},
{-0.43354515714124137f,0.17447743993718737f,0.11166728561394819f},
{-0.4506651673953466f,0.19707151918870608f,0.0877821630779109f},
{-0.4593199270814911f,0.21115090341271883f,0.06764978896631363f},
{-0.4593023782292615f,0.3019618387055658f,0.029989331635415825f},
{-0.451881078261847f,0.3944588853141068f,-0.0015976547101083588f},
{-0.44224028194977427f,0.45020789910523795f,-0.009870132443088434f},
{-0.42216017299046155f,0.5223797668949667f,-0.0183281087047641f},
{-0.4150442887086449f,0.5138541290670028f,0.011686935855708468f},
{-0.39581744833347066f,0.5216503495638563f,0.03630605470052352f},
{-0.3955772007430274f,0.4479811072061385f,0.06398900043721746f},
{-0.40363028595090306f,0.38358548133436887f,0.07771730562548829f},
{-0.4107603140679136f,0.3574834101076052f,0.07272064551426914f},
{-0.4102380747592993f,0.2874121722269579f,0.09044667761940771f},
{-0.05652063952218286f,-0.9008275635740199f,-0.2532032090862998f},
{-0.055206467619608804f,-0.9190920749535787f,-0.25759215068121066f},
{-0.055651752480808135f,-0.9380969454022979f,-0.2676502395334665f},
{-0.059967293382433486f,-0.9574573240649252f,-0.28348341682520983f},
{-0.06305207945561668f,-0.975437493680234f,-0.3074089916010761f},
{-0.060836294101443984f,-0.9854024295531736f,-0.32591143983408816f},
{-0.07867796292241244f,-0.9881560397385546f,-0.34461138011757936f},
{-0.05691847193848356f,-0.9950170460119565f,-0.33582972962965807f},
{-0.07943937572717268f,-0.9926675768204605f,-0.34820192649181336f},
{-0.09423898639231901f,-0.9971667942213848f,-0.34419872817471664f},
{-0.11231293155792148f,-0.9911058044029804f,-0.3446835601042896f},
{-0.14340465950361106f,-0.9725851581865657f,-0.34545480124371347f},
{-0.16941579605856885f,-0.9731188258160077f,-0.3425326772433186f},
{-0.18368610559037823f,-0.992036318534274f,-0.3390507046977839f},
{0.11278252962188592f,0.3789406896278957f,-0.3102857242277266f},
{0.09948720342513438f,0.38131139422672694f,-0.30224572894649593f},
{0.0653763748940203f,0.39005401716369437f,-0.30549799086226126f},
{0.10096250115880144f,0.3779155022117076f,-0.29846251385324674f},
{0.13649488764925582f,0.3746385180661696f,-0.29381354794648235f},
{0.1603672092335729f,0.37261894456106315f,-0.2925349815793014f},
{-0.004301245142114397f,-0.568983342640194f,-0.33643350980020925f},
{-0.017812903067065552f,-0.5830268196049954f,-0.32629345406048416f},
{-0.034588660255617285f,-0.5660138012543583f,-0.339509396083156f},
{-0.04534036329573748f,-0.5773960709531799f,-0.32897018310458925f},
{-0.050472056502200296f,-0.5970412779628347f,-0.321064253065086f},
{-0.0020537129177196555f,-0.5947795105361743f,-0.3196061907733442f},
{-0.016707136268009935f,-0.6212288223192571f,-0.31865905952147144f},
{0.009869310670646295f,-0.6287971170314646f,-0.3089119990552815f},
{0.33930298883752713f,-0.1001098153053475f,0.2555926588085563f},
{0.3518686650358576f,-0.1198522889373644f,0.24440194336295562f},
{0.35864849379079383f,-0.11121033657738695f,0.24814797418280385f},
{0.365738601934289f,-0.11959129039754776f,0.25585797284890305f},
{0.36618635158161095f,-0.12390278352541145f,0.2683127049867068f},
{0.3610823808445803f,-0.12734698428602545f,0.27519796603044405f},
{0.3460805482893782f,-0.12219235475732108f,0.28297720712565483f},
{0.3367532324006001f,-0.12815040469565048f,0.2782176201303383f},
{0.32978969208690706f,-0.12212896938247411f,0.2705362947886625f},
{0.3295204269519096f,-0.11051090995638613f,0.2666218308967941f},
{-0.11980191858941149f,-0.9455447906912896f,-0.2840871566242642f},
{-0.1276894487880282f,-0.9502186010047248f,-0.2779145141193225f},
{-0.11586984528806832f,-0.9324000554897726f,-0.2667236159395783f},
{-0.10679515935277599f,-0.9376962083630407f,-0.2785439482512969f},
{-0.10460013663446256f,-0.9132862478688824f,-0.26131674211142375f},
{-0.10992491183657913f,-0.9145552493785367f,-0.25479819555918964f},
{-0.11016942499438537f,-0.9185922885716516f,-0.2445583797259689f},
{-0.1198989004864802f,-0.9451887958946038f,-0.2596724546040433f},
{-0.13340552791044413f,-0.9621129778288626f,-0.27432303495103005f},
{-0.14374498059785432f,-0.9619117981608701f,-0.2964603277143826f},
{-0.13956022740985807f,-0.9605826537450093f,-0.30918754727007597f},
{-0.11617715630920175f,-0.9528966676202644f,-0.29855362063511803f},
{-0.0918577140229872f,-0.960058712459081f,-0.3001966916855544f},
{-0.08937805100382873f,-0.9368944091877359f,-0.2757474603490534f},
{-0.08562195386996703f,-0.914761615721465f,-0.26306611768747423f},
{-0.09583421509418981f,-0.9004832414519589f,-0.25580317916602735f},
{-0.10099332373422733f,-0.9068835282034765f,-0.2540504601925942f},
{-0.10506245508010294f,-0.9088278821731242f,-0.2439915405374298f},
{-0.12141181808075083f,-0.8963559060941327f,-0.2352556649524729f},
{-0.11650933086034682f,-0.9328734187270208f,-0.24898949041173205f},
{-0.1322537832885322f,-0.955863939703015f,-0.26450468692069146f},
{-0.14433792952076774f,-0.9678283472628606f,-0.28770907165153925f},
{-0.1643957385401181f,-0.9733349195648576f,-0.31281278444657745f},
{-0.16338628644602549f,-0.9668855123881773f,-0.33237831405759655f},
{-0.13767839720232242f,-0.9626972235069847f,-0.3321043073965365f},
{-0.11967515740138787f,-0.9681762369503526f,-0.33686812914938946f},
{-0.09806089544046911f,-0.9713242617861049f,-0.32437276734965226f},
{-0.11156116966572054f,-0.8886191793723129f,-0.24102520018633f},
{-0.25516918571093006f,0.6578503393648474f,0.07108680360049092f},
{-0.2611695460403506f,0.6445292678396011f,0.08334153640538053f},
{-0.265442639500277f,0.6473906816080182f,0.06290105340438333f},
{-0.27147868398326874f,0.6751660578867164f,0.03823178891086763f},
{-0.2739907090067719f,0.7300009303133361f,0.017328677241149098f},
{-0.2714430603869428f,0.7278137343533696f,0.022594292264284842f},
{-0.26311793291005053f,0.712710338798616f,0.025714129295983625f},
{-0.2595332425276732f,0.7365710280798055f,0.022477836432032248f},
{-0.2550760529173623f,0.7506415762580505f,0.030735893041379636f},
{-0.2433552161595942f,0.7518086514246817f,0.04965865530239061f},
{-0.2450611052591062f,0.7400057054167974f,0.04883128928310319f},
{-0.23596119138792312f,0.7421135883840079f,0.05790607720954534f},
{0.3342560407149605f,-0.6207374650809062f,0.07440674408106937f},
{0.32332650548091224f,-0.6124712853014325f,0.07972132123060383f},
{0.31658724583066405f,-0.5981569230297211f,0.09488270194129884f},
{0.31261136201839995f,-0.5646356989617299f,0.12221043056382515f},
{0.3165423410396974f,-0.5478872467163404f,0.13644465435191067f},
{0.3016462031880257f,-0.26068876135333546f,-0.20441487985666446f},
{0.30751873992161105f,-0.2308617948477247f,-0.18770614360249047f},
{0.3033158811796921f,-0.2581848021299369f,-0.19244127184517168f},
{0.29826078757643515f,-0.3100151162092554f,-0.21645833693212915f},
{0.30485086604661443f,-0.299576493064685f,-0.19387181564978118f},
{0.31490834720160216f,-0.2921615558576533f,-0.18205233432671955f},
{0.3279563023635346f,-0.26133363758284933f,-0.17392518442067614f},
{0.32224287819823955f,-0.1962786665495816f,-0.17439812163239202f},
{0.32382037531373725f,-0.2185416357825823f,-0.20157364864944152f},
{0.30393623809932535f,-0.2567721705210285f,-0.21322194101462005f},
{0.29987646231663745f,-0.2848928420873433f,-0.2276226281706433f},
{0.2971126190192165f,-0.3059514913230666f,-0.23681751917535482f},
{0.30622992025664175f,-0.34196629807736184f,-0.211340749314179f},
{0.3166040244372304f,-0.34751129023304456f,-0.19043884135251085f},
{0.339220676667519f,-0.36877711642885613f,-0.16691027562689142f},
{0.34534128350026344f,-0.32711486315917276f,-0.16043934831758236f},
{0.36163842065771595f,-0.31299892360718334f,-0.15137795522882702f},
{0.35583534839647457f,-0.2622429152443999f,-0.16190576007231436f},
{0.33902521275355196f,-0.21717885234818737f,-0.16820884182112297f},
{0.34668023500263184f,-0.19397053670843717f,-0.15956040558627224f},
{0.2511019932593104f,-0.7602376611373782f,0.11989547581489997f},
{0.2510548999082521f,-0.7586794541605131f,0.13660642081491398f},
{-0.4597775241868174f,-0.3697171964800842f,-0.013371269763133886f},
{-0.4559361518275614f,-0.33703100476614795f,0.02606691349626304f},
{-0.44520666160996314f,-0.32104090452861367f,0.058907788600323696f},
{-0.44294262594262535f,-0.2938663103056226f,0.07830262114827641f},
{-0.4364725092504764f,-0.28233246794674866f,0.09226025449950437f},
{-0.44263392635448223f,-0.30084095490576107f,0.09632603819836609f},
{-0.4496091797142966f,-0.36671685376697877f,0.07712016125412746f},
{-0.45906083343888043f,-0.44948434839006246f,0.05015125024584183f},
{-0.46189100073115485f,-0.47865095832193866f,0.03644289920108573f},
{-0.45730829719959093f,-0.49583743387113627f,0.024864004376559223f},
{-0.4610720585434045f,-0.5278695095948225f,0.013846443343292852f},
{0.016734105490303738f,0.8583432775722625f,0.15126826799674117f},
{0.032421707414090326f,0.8612193015729027f,0.14299440807119843f},
{0.025034273820481533f,0.8694139101253423f,0.150913854062879f},
{0.011052905216337843f,0.8615106754144568f,0.15663816047138682f},
{0.008511710723963388f,0.8725408206682499f,0.1493006409215758f},
{0.02238848740388504f,0.8836803896769915f,0.1401887399030561f},
{0.04250317136301383f,0.8735595231471568f,0.12998984270669353f},
{0.04234661282310221f,0.8661466523233182f,0.14008480667167714f},
{0.053896357302098075f,0.8548686813241629f,0.12843122032837412f},
{0.03684895199782763f,0.856255800271887f,0.14666655692702246f},
{0.019170156668801952f,0.8544219250281447f,0.15595745772565506f},
{0.0003864253436291718f,0.8496541309324848f,0.15644359747924388f},
{-0.010331256211144828f,0.8612510548175716f,0.1513838526545884f},
{-0.0037420064190584494f,0.8772416618236318f,0.1524527485905475f},
{-0.008425003372839272f,0.8846520200529961f,0.1570793040669371f},
{0.025009627021663622f,0.9017574604463752f,0.13659985513463915f},
{0.04192898562445846f,0.8867325258333132f,0.12443681131110154f},
{-0.015386398685161121f,0.8544956444437737f,0.15618572985524765f},
{-0.01794992074010102f,0.8657843553234951f,0.15704432853937622f},
{-0.02892231987971025f,0.872338080323182f,0.1698473753277966f},
{-0.030412618811675098f,0.9013937451321238f,0.159511671877553f},
{0.007864643809542412f,0.9113366349805678f,0.13652495007189258f},
{0.03316024339144641f,0.9207790893159123f,0.11272129827887667f},
{0.04364386694368662f,0.904588093073271f,0.12222130643259102f},
{0.33955166663395425f,-0.19972132788127675f,-0.20480056045241776f},
{0.31999643069222033f,-0.2337377179196229f,-0.21691088866275882f},
{0.3168077974426909f,-0.23473113084298597f,-0.22199864811899456f},
{0.3018880720127893f,-0.17891978664796454f,-0.2228081879976136f},
{0.30583935577217924f,-0.26398349620858713f,-0.23011293014162562f},
{0.3530844133539628f,-0.1776163365650237f,-0.196944946046865f},
{0.3367931927456125f,-0.15909795965169451f,-0.201446756785257f},
{0.32651047900978075f,-0.11905292161354003f,-0.19819404865821083f},
{0.29106463838446317f,-0.27888632085502413f,-0.23874525708683128f},
{-0.2667311138827076f,3.155616801971343e-05f,0.24429871981999474f},
{-0.27853699851059827f,0.020079282937239283f,0.215758100756376f},
{-0.28310126182977885f,0.0110560472874402f,0.21166589285042775f},
{-0.27331310742944176f,-0.08716593467503293f,0.2656136250070643f},
{-0.28617704718398346f,-0.09468989192204484f,0.2561373712296062f},
{-0.2959196689103372f,-0.08750142287614189f,0.23581575785140924f},
{-0.299859746392132f,-0.09734080445633166f,0.2190447910596793f},
{-0.30434141387841884f,-0.09981209888915922f,0.21952265253160128f},
{-0.3341462929256294f,-0.08186402780105792f,0.2199584458414131f},
{-0.32933493267284514f,-0.09027797150858004f,0.22462875020907058f},
{0.4374164373427977f,-0.5975738109407339f,0.11671543956938073f},
{0.4463225892773275f,-0.5840001307101579f,0.060714692496956615f},
{0.43066023653758795f,-0.5589572906954927f,0.0950123348176369f},
{0.4157605736167981f,-0.5385028274701045f,0.13227687312870243f},
{0.395779959149028f,-0.467546707998481f,0.14061022789168665f},
{0.4138266344309261f,-0.49773380312957183f,0.09791900715882201f},
{0.45689937218333093f,-0.5774456768987123f,0.022347028532654713f},
{0.44901520556784513f,-0.6064634679315833f,0.03730423783496004f},
{0.44307547472740877f,-0.6073077400463744f,0.07908322422533483f},
{0.43774179336060864f,-0.6207374650809062f,0.11067266685771911f},
{0.43491284252527834f,-0.605724082027978f,0.1294172229572523f},
{0.4232736688063455f,-0.5691174078819214f,0.1365691557985194f},
{0.40272915377004304f,-0.5223609920241227f,0.1481249846870514f},
{0.3949795389790625f,-0.4877593023991056f,0.15445368958745667f},
{0.380772006062424f,-0.42750231802909155f,0.17033861038924913f},
{0.38574661271229305f,-0.40064886525212356f,0.14584400786475218f},
{0.2940471283967049f,-0.6529678020383272f,-0.10747614416778174f},
{0.2951749730924904f,-0.664835268072601f,-0.1332969939220377f},
{0.3085031563756268f,-0.6871937201452483f,-0.1773638946577205f},
{0.29904112717635634f,-0.683718231474587f,-0.19832410224804226f},
{0.2901277009355413f,-0.6873067104032198f,-0.19019046740471773f},
{0.06677621936250995f,-0.9447360210583338f,0.21165545681849585f},
{0.06215525746324768f,-0.9539100208758408f,0.21617421827351965f},
{0.06915779558047591f,-0.9573300677948613f,0.21661430796052095f},
{0.05952494289160947f,-0.9616279429793977f,0.2080900077039918f},
{0.046492104730426094f,-0.9654330022396582f,0.2033366421688192f},
{0.04679059032986996f,-0.9606199389471521f,0.2146282512970503f},
{0.06551310465453887f,-0.9337215813792176f,0.19568166985290647f},
{0.4101059951577714f,-0.3501784958535278f,0.059013756342661615f},
{0.4056161800659787f,-0.36451506776053755f,0.09683153927191086f},
{0.38807127786861495f,-0.283927310994584f,0.1412666939280157f},
{0.3799313418845607f,-0.12708412228290752f,0.19562529530720726f},
{0.3853316096609436f,0.030341530448991082f,0.2196560293330669f},
{0.4077521488460924f,-0.03989092675463659f,0.16952308278020473f},
{0.41900849878387697f,-0.03046727809996277f,0.15987419092060876f},
{0.4217461813513488f,-0.045621373880294656f,0.14658842001971342f},
{0.4304679736583568f,-0.0414574013890905f,0.14431172895052558f},
{0.43788343781966316f,-0.011675420417440156f,0.14787852626054238f},
{-0.070238202705072f,-0.5552434997030907f,0.2204946876849823f},
{-0.1057431270160081f,-0.5757144982436564f,0.22391625384717323f},
{-0.0937187327239044f,-0.6179254957720343f,0.2217598592144764f},
{-0.06578741941386411f,-0.6214664765722326f,0.2184297642400361f},
{-0.09528548145957358f,-0.6679507088607758f,0.22264297720848555f},
{-0.12934867056201432f,-0.6924906825732688f,0.22644120731133394f},
{-0.10861449554561863f,-0.6033549976010593f,0.22330921102223308f},
{-0.11817499720011712f,-0.585891313293658f,0.22151505176970634f},
{-0.10779806595234222f,-0.545545234565273f,0.22149448461688442f},
{-0.09411548892109203f,-0.5280716613659626f,0.2268172635547233f},
{-0.06467387897685214f,-0.5066529642477531f,0.22458749372652834f},
{-0.0537196810078687f,-0.555523140312775f,0.21868259605100604f},
{-0.05137158232244962f,-0.586114376437751f,0.2129184705977249f},
{-0.07441437907480639f,-0.674999276858843f,0.21715701349321506f},
{-0.09336804252942131f,-0.6874926519559728f,0.224853354906898f},
{-0.13246427283617654f,-0.7239424020938308f,0.22842704193157207f},
{-0.16629506660430846f,-0.7451023699753091f,0.22919672239392092f},
{0.14971587610903206f,0.4122399023355271f,0.13483623479465273f},
{0.17273492804680285f,0.4161521978530524f,0.1215099245364879f},
{0.15150196956145426f,0.456111479395074f,0.10103898230353628f},
{0.16868109006137316f,0.4843772397465679f,0.07477043389753336f},
{0.1902726366808752f,0.4548574727092705f,0.0782510518731084f},
{0.19566998708540784f,0.430378453582552f,0.0898087070406683f},
{0.20675741736839456f,0.4036299666973557f,0.10650888135028977f},
{0.19855229204102942f,0.3725222452644724f,0.1501969912048766f},
{0.17792901115199333f,0.35786031733965157f,0.16753527314384514f},
{-0.15127809580020096f,-0.9661527729078405f,-0.34326760528374695f},
{-0.13330158405498702f,-0.9698018813254576f,-0.34783948819175126f},
{-0.10519358807627076f,-0.9837699762064049f,-0.35249072446400875f},
{0.32982697728905014f,0.4050301160768873f,0.035244036792735745f},
{0.355928805224425f,0.4140788027682177f,0.021504777117521003f},
{0.3436432562185563f,0.42793001685378784f,0.02137886266852303f},
{0.3179460558598442f,0.40132597068500564f,0.039948064109144414f},
{0.33371973831414614f,0.44430788531842486f,0.02363260572898344f},
{0.35200516212906546f,0.44931171137033227f,0.00813198758001284f},
{0.36606002704319784f,0.4465530356245063f,-0.00467478188537886f},
{0.3759385179797428f,0.42736044090272646f,0.004060082287341528f},
{0.36922106106260144f,0.4087299650915795f,0.03046117350467809f},
{0.3401950023721415f,0.39705233008505636f,0.035485070564959496f},
{0.30938981962450274f,-0.9487829502057656f,0.14621279936352677f},
{0.32238577842332705f,-0.9571413703562454f,0.1491677400788097f},
{0.3383781479639466f,-0.9798225840468284f,0.16271469225366522f},
{0.3304018217204485f,-0.9782898291739023f,0.17678335678286053f},
{0.30729798538969244f,-0.910333889866989f,0.02762511834831256f},
{0.3004148119773045f,-0.9003352342325217f,0.031634948214968386f},
{0.31417273072091195f,-0.9144741940369696f,0.0026197377706713475f},
{0.31739496155507085f,-0.8997751423959931f,-0.0035583570111586906f},
{0.33423018383364544f,-0.9049156684610004f,-0.03180468486137325f},
{0.2506461586885433f,-0.3342159544746227f,0.1763644631941055f},
{0.24222700705792943f,-0.3168039828674438f,0.17930731689571755f},
{0.2637676919658659f,-0.3752699697105781f,0.16460933934903837f},
{0.2533180644011844f,-0.41682263561450994f,0.1651054891090267f},
{0.2591352199403743f,-0.43131629301570573f,0.1598024263353528f},
{0.254699590834189f,-0.4739598020761658f,0.15317018939839935f},
{0.17297677668581807f,-0.6763900228668355f,0.152476315983029f},
{0.13460032235928415f,-0.7117695193115513f,0.16058403232538526f},
{0.08148163376386929f,-0.7624225877942595f,0.16655467604591162f},
{0.04648302645567719f,-0.7718162457388237f,0.1646700092095193f},
{0.1919229629142559f,-0.8457329908699291f,-0.3337062430789211f},
{0.19498997384234582f,-0.8387756922021283f,-0.31611457156488154f},
{0.18348433841086592f,-0.8495320517756861f,-0.3139255928846074f},
{0.17331903242468594f,-0.8598403387299473f,-0.32921245670672894f},
{0.16015901873643243f,-0.8632579537974875f,-0.31721384386498575f},
{0.17440730136708685f,-0.844880127063167f,-0.29358170931386673f},
{0.19623133468796952f,-0.8247712842221855f,-0.29249299522259276f},
{0.20407619008961575f,-0.821380093361732f,-0.31671875757521667f},
{0.1655219609391755f,-0.8647231087237786f,-0.34796427330124563f},
{0.1533821286015026f,-0.8696853138872646f,-0.3352212472421335f},
{0.13461501333450093f,-0.8727728717824278f,-0.3245613426113698f},
{0.13783444791130012f,-0.8637117007369051f,-0.30278045048448693f},
{0.14927771150498512f,-0.8484063563309033f,-0.2813409227363181f},
{0.15309180866849761f,-0.8277283433786445f,-0.25780820299615587f},
{0.19055179177018955f,-0.8067987341957006f,-0.2635965439106835f},
{0.20045283656216395f,-0.8115693234863125f,-0.28568343923468403f},
{0.20726328391022644f,-0.7880983073294316f,-0.2843305053831091f},
{0.20782771143303358f,-0.7993048484017917f,-0.3111218094279226f},
{0.2048992661061605f,-0.8150029872862523f,-0.3289958774375093f},
{0.20030942956855044f,-0.8164002182315259f,-0.34836363239757145f},
{-0.2759969896653414f,-0.9991779375205074f,0.2986264901244979f},
{-0.2776931120498427f,-0.9906168779537019f,0.31072749676870126f},
{-0.266172075954728f,-0.997575960404218f,0.31365989425263296f},
{-0.25885235811020574f,-0.9952130368801979f,0.31488184278272585f},
{0.4028816995956508f,-0.10445454054955351f,-0.04853195163259464f},
{0.41027839951019096f,-0.10589570312023851f,-0.02893114264538056f},
{0.4187581593816328f,-0.09360553370279785f,-0.022071282710007318f},
{0.4281300145930903f,-0.080950210470929f,0.018855901219008788f},
{-0.4197256771769993f,-0.6210211587763912f,0.07904007665688823f},
{-0.40354817776319474f,-0.5995395639285199f,0.06655785259214748f},
{-0.4394441170195054f,-0.6449781829482921f,0.08745240019249788f},
{-0.405304767088285f,-0.5600969281179853f,0.10570482349597785f},
{0.24043931255693543f,-0.2238566729546991f,-0.23048685838216862f},
{0.25127006086304343f,-0.26173226680500866f,-0.2355456204795985f},
{0.23496731100512305f,-0.25385369376665035f,-0.22051720010650705f},
{0.22878269091451506f,-0.24822845688656064f,-0.2126142490585071f},
{0.22232485459425874f,-0.1991162505107878f,-0.21064620658188743f},
{0.20842583959402783f,-0.23929227387042432f,-0.23184427134507662f},
{0.18051617496796163f,-0.4845718845441124f,-0.2874863729133255f},
{0.16949423681451203f,-0.5987004795510723f,-0.30235381619241763f},
{-0.21641351447776772f,-0.2887405357730774f,0.25777181021657447f},
{-0.19019637492335326f,0.959756609361039f,0.07072369067146854f},
{-0.20588299411991431f,0.9527247795980414f,0.04850232745318001f},
{-0.21547771061798077f,0.9379467602468473f,0.06384925981296122f},
{-0.191597882060068f,0.9503502853905466f,0.08981925462542042f},
{-0.21709826924689238f,0.9256623660782695f,0.08301728210446992f},
{-0.2352236689476192f,0.907984268751176f,0.06231651025207415f},
{-0.23437878913555996f,0.9226731680231064f,0.034283399150356025f},
{-0.22027059028688484f,0.9428333198493419f,0.021175398823735744f},
{-0.20516516872043475f,0.9581742581042507f,0.006314464917304436f},
{-0.17513244356916394f,0.976134163352964f,0.0412232127103959f},
{-0.16332369150259016f,0.9749507664151252f,0.07496865475977113f},
{-0.15896964469224642f,0.9642610538083958f,0.10422220046045083f},
{-0.1717227923105784f,0.9460513562974612f,0.11887922537322185f},
{-0.24899092944311266f,0.8944765077380773f,0.030559483411511035f},
{-0.24302392340693274f,0.9130738523616241f,0.009272977447649463f},
{-0.224941482166062f,0.9381399962916337f,-0.00936712271586153f},
{-0.19992794335883665f,0.9593775135689011f,-0.029633578005303408f},
{-0.1794584544997712f,0.97595972236477f,0.009286670821931303f},
{-0.14643084847395357f,0.9895972033716474f,0.030568510690684968f},
{-0.13289384574825233f,0.9905660672377112f,0.05884914156431578f},
{-0.13017708517781157f,0.9856225253922493f,0.08281436115007429f},
{-0.12910716614313f,0.9787821893252269f,0.10057312710229158f},
{-0.1252845782163884f,0.9679644193929438f,0.11972281860942142f},
{-0.13822683761238272f,0.9527493594651671f,0.13263758926570218f},
{-0.14695248008529965f,0.9332462834973443f,0.14807973567595376f},
{-0.1401358718343385f,0.9594974647228536f,-0.1098542250640479f},
{-0.10845617978318682f,0.9633308838972329f,-0.11299908923656113f},
{-0.12481946351338821f,0.9790921648651517f,-0.07859113180077845f},
{-0.1562629557478583f,0.9688080933721369f,-0.08058411855040326f},
{-0.1747199127407918f,0.9455352162720926f,-0.10654372513928208f},
{-0.20669780247887032f,0.9116204497905432f,-0.11462074214551853f},
{-0.21249982083156263f,0.8930180396065516f,-0.12429160991069443f},
{-0.1999466066768605f,0.8762390080771248f,-0.1471840738329148f},
{-0.18840014928763332f,0.8475995213425722f,-0.16549492850361694f},
{-0.17423411720733387f,0.8210141788633106f,-0.17753554895022505f},
{-0.17070820241230963f,0.7715353992962735f,-0.1734367254308349f},
{-0.13859373483802945f,0.7483388774456383f,-0.18427008832256694f},
{-0.10676140984382958f,0.7466210723801131f,-0.1912643481581282f},
{-0.09830705001834403f,0.7338772367662484f,-0.19030965893708482f},
{-0.06527767827074388f,0.7390694755314782f,-0.19125887782030704f},
{-0.021954427943621454f,0.7539064840139955f,-0.1865624329084487f},
{0.005217469888344036f,0.7741065951228355f,-0.169197797943717f},
{-0.02115415013630276f,0.7669353912662764f,-0.17982732621033554f},
{-0.0067665550317399965f,0.800250510343661f,-0.17078222514536884f},
{-0.14256142111162057f,0.323629617335171f,0.2352367997769649f},
{-0.1586617259738448f,0.3087789122911484f,0.23521088233840448f},
{-0.1405120704403746f,0.3071024455135668f,0.24318329785874856f},
{-0.11716006308171747f,0.3134553148796436f,0.2445137394745472f},
{-0.13025984355910045f,0.30374780998108963f,0.24714321261919883f},
{-0.12621211441858665f,0.29323121141519753f,0.24930957794920616f},
{-0.14493836735634408f,0.28988492534571064f,0.24751136667328655f},
{-0.1529393446482913f,0.2818918204956462f,0.2443375253277159f},
{-0.16639454197251063f,0.2891408382875397f,0.23487821164281153f},
{-0.1799712203179306f,0.31249472929524663f,0.2152260543612542f},
{-0.1734590875216543f,0.3365824136918393f,0.20604873133211296f},
{-0.1546835834825734f,0.33638488233227115f,0.22154860898283896f},
{-0.08439253236332837f,0.326500109378337f,0.23343534603240473f},
{-0.09828862999170904f,0.29574773467337434f,0.24747752579726828f},
{-0.11470714830402798f,0.29502496482794033f,0.2507514703940576f},
{-0.13077897213764278f,0.2740476960305744f,0.25092229388365356f},
{-0.1421849494667769f,0.2580653768678512f,0.24235740539909562f},
{-0.16016505852484053f,0.25591935664743326f,0.2321847443636369f},
{-0.17489098908344688f,0.26267709794396943f,0.2207523831989131f},
{-0.17952261968195177f,0.2937883040744743f,0.22041085627180385f},
{-0.18720907220372562f,0.33046979191620574f,0.19393909262444153f},
{-0.17342100126402146f,0.3637108877293273f,0.18399214012852635f},
{0.40858154725152324f,-0.3142273974460542f,-0.05397302118097647f},
{0.4144184603887828f,-0.32053074267200005f,-0.08768400509539499f},
{0.3950894896882855f,-0.31549964142434916f,-0.08980286061048189f},
{0.380468940422905f,-0.3171873739743634f,-0.07759204455729439f},
{0.3789266206924525f,-0.3104237968717189f,-0.09858367073382425f},
{0.39172010262334644f,-0.3082299544884839f,-0.1151161524696701f},
{0.4051021680434562f,-0.31823104197443175f,-0.11216263963048578f},
{0.4280665484752497f,-0.3304485044508877f,-0.07003654654717598f},
{0.42474360669260375f,-0.31775135741070537f,-0.05833291335909878f},
{0.41426939926079653f,-0.2969796432766997f,-0.020839359232972678f},
{0.39829299770958315f,-0.31153230893255934f,-0.03951961309971759f},
{0.3898288403592606f,-0.31562932954589346f,-0.05818788513116493f},
{0.375414090111037f,-0.3059153397100584f,-0.08937493974255296f},
{0.36726900676113633f,-0.30429715237538196f,-0.10363606900846355f},
{0.37362771299572917f,-0.29372948917803227f,-0.12541246290067276f},
{0.37729570783701044f,-0.29006319631406496f,-0.13805844438065548f},
{0.40966420243104834f,-0.32802868048930167f,-0.10984139861454023f},
{0.4181633756804288f,-0.34102005924805073f,-0.09208338165983002f},
{0.4260206325684582f,-0.33985334954970664f,-0.07303847012310485f},
{0.4305189575468209f,-0.33584678658707107f,-0.04811775919840532f},
{0.4350310619544979f,-0.3189474086879862f,-0.024534983051798628f},
{0.43454250097350683f,-0.31040823472209667f,-0.02750396773594116f},
{0.4272454580989045f,-0.3012220767095954f,-0.02387571544607079f},
{0.4290759304504267f,-0.28822081012134504f,-0.007623147358716689f},
{0.37979472261445446f,-0.2931608045871247f,-0.0812892694246922f},
{0.3660337239506018f,-0.2856330386081087f,-0.11410887831159096f},
{0.3631787143764722f,-0.2924671340916463f,-0.12023973737971592f},
{0.364786688784857f,-0.2791795794080355f,-0.13062818831539041f},
{0.36048707125150986f,-0.2520622096569929f,-0.1528687449932007f},
{0.3723594402978335f,-0.2889918079693801f,-0.14961790139186362f},
{0.38092998291676394f,-0.31107629269005654f,-0.1417754980274463f},
{0.40379709672619535f,-0.3336080394128693f,-0.11564730750463806f},
{0.3922554329210134f,-0.35115164547270306f,-0.11316030855954157f},
{0.40289312791647836f,-0.35887264749650544f,-0.09402229503907522f},
{0.4132389433642716f,-0.35816390037177476f,-0.07151834940387256f},
{0.4260945145324823f,-0.3326856303907692f,-0.021066166302193247f},
{0.433478083086473f,-0.30987651236135744f,-0.002694242305673053f},
{0.4345116592747404f,-0.27927765558514994f,0.01918335974187875f},
{0.435739728336235f,-0.28147846948844374f,0.008565456341533176f},
{0.23365731542765591f,-0.8588230949369656f,-0.1609603722316603f},
{0.22812160446661403f,-0.8831907450400327f,-0.17702832571361793f},
{0.3654512609927874f,0.49777320571048295f,-0.12623288396009671f},
{0.35303602280296664f,0.4954908105737554f,-0.14888487718623336f},
{0.34693304662785346f,0.5117353436708315f,-0.1487565064503753f},
{0.3453886594517997f,0.5356511102977825f,-0.1341933643910869f},
{0.3205417306247901f,0.5329455251951104f,-0.18119637041396336f},
{0.33105962532821215f,0.4920539053675827f,-0.1801180116116276f},
{0.3321337706211677f,0.4895797732434907f,-0.18925356926488499f},
{0.3475741938059491f,0.49150637650342466f,-0.18072489188817262f},
{0.37508176363557494f,0.4956984751790292f,-0.1392497955657785f},
{0.3782460804951159f,0.4971621714193952f,-0.11617961737689708f},
{0.37447279466527267f,0.4959504751246828f,-0.09075761038877052f},
{0.36533429839200887f,0.49648300916499005f,-0.09408834493271333f},
{0.3506346794252609f,0.533279189242007f,-0.11730663020736619f},
{0.3206427656076594f,0.593539983406433f,-0.11727723763285451f},
{0.31611266719887954f,0.5865352662907836f,-0.14923446885103936f},
{0.3038815464075995f,0.6185201275489209f,-0.10409240078608639f},
{0.2773551505633488f,0.6463227779609548f,-0.13319551272788757f},
{0.26997206859213574f,0.6540266773438085f,-0.10980280558838133f},
{0.23320991106287264f,0.6787772330334254f,-0.10834189604370484f},
{0.1949076616723377f,0.7188784023258904f,-0.1019315472278049f},
{0.3335520351162924f,-0.25471677049970415f,0.2557466240110001f},
{0.3373076509794156f,-0.24042429276650099f,0.25206018895733545f},
{0.3336527874986838f,-0.25560691950860953f,0.24657276655613983f},
{0.3328617685754419f,-0.2669183467921555f,0.25241460289119766f},
{0.33612797246891696f,-0.2776088902017936f,0.24922665808192992f},
{0.3423918439326283f,-0.2770985657967849f,0.2348981912841137f},
{0.34271740180792354f,-0.2622758243887675f,0.2332312288068134f},
{0.34171855785582833f,-0.25251871354468114f,0.2360060552761892f},
{0.33829453965640854f,-0.24138982279685248f,0.24529458478058666f},
{0.332523564859967f,-0.23043471540678245f,0.2524521919419747f},
{0.337806262338303f,-0.23346683048789724f,0.264723779846793f},
{0.34744515375316976f,-0.24472281601980242f,0.26276386266511537f},
{0.34278390747451276f,-0.25212381231153225f,0.26591569835768736f},
{0.3440721194422139f,-0.2621899053442395f,0.26590815951185726f},
{0.33702480827258763f,-0.2676458985351489f,0.26182143363021615f},
{0.3432461664253157f,-0.2775558792392254f,0.2590237696425254f},
{0.33482671094606775f,-0.29628532365004856f,0.2546964710736507f},
{0.33219367023598534f,-0.2984702503069298f,0.24536287422989134f},
{0.3383340941616368f,-0.2897866356246262f,0.2342211368468065f},
{0.35029898936666776f,-0.29583562979643163f,0.22677329049540718f},
{0.35592499543001305f,-0.2876826028233247f,0.22835283593316538f},
{0.35468566059608575f,-0.2761002891704609f,0.23431789670064257f},
{0.35446316371535624f,-0.26877062187678435f,0.23124575965486244f},
{0.3554179134936447f,-0.2535802129974569f,0.23291387696945381f},
{0.3471866688702351f,-0.24250611593250404f,0.2383495250507738f},
{0.345175849605495f,-0.23103711763440216f,0.23700477811379395f},
{0.334067871293027f,-0.21866305624653784f,0.2506732718670955f},
{0.33381035851323976f,-0.22238803226837864f,0.25981069510846977f},
{0.3449116904024393f,-0.22118711728813692f,0.2718850948114431f},
{0.34841315706890646f,-0.2330453435616745f,0.2701172790230092f},
{0.3614229760400389f,-0.23107229608185506f,0.2681420227973497f},
{0.36068630458839185f,-0.24397354122428816f,0.2618185353817065f},
{0.3579133628304736f,-0.2552095864239802f,0.2672524209284673f},
{0.3547153262094049f,-0.26863736725221704f,0.26606297570295806f},
{0.3538850778777251f,-0.27890739583877994f,0.26106526912004463f},
{0.3425534680329848f,-0.29077356467311594f,0.26188133324503376f},
{0.3454529776207051f,-0.3053486014502614f,0.25984182047012194f},
{0.3437479384474423f,-0.3126299599983433f,0.25439873447171396f},
{0.33609032179848686f,-0.3105795851659672f,0.2402338986626102f},
{0.33639476538093727f,-0.30409321788393423f,0.2358723948118379f},
{0.3463826811348387f,-0.3116639433852142f,0.22778291576197307f},
{0.3618270766624272f,-0.2996272336617601f,0.2300407512173232f},
{0.36503678489571256f,-0.28641457341681775f,0.23334257870712413f},
{0.3639658416999006f,-0.27712482745547623f,0.2428324504279094f},
{0.36452220554741877f,-0.2665108007812346f,0.23483504920065557f},
{0.3633606421525135f,-0.25409880506005444f,0.23529414642581162f},
{0.3614128842282379f,-0.24209986712152098f,0.24372867853431188f},
{0.35474426301096545f,-0.2319660923367771f,0.23509296782022673f},
{0.347610020322167f,-0.21423370915774168f,0.23763864992319675f},
{0.3373562433878958f,-0.20632133561486193f,0.2521993197595079f},
{0.343240208442309f,-0.21061232108474112f,0.2663659191655787f},
{0.3538657048712832f,-0.21022471434362563f,0.2697048300000385f},
{0.3615127845595646f,-0.20818714683741657f,0.26905221306721033f},
{0.36808182947989265f,-0.21970485972089704f,0.26207527791583046f},
{0.3689683312427813f,-0.233479718557058f,0.2564343981431249f},
{0.3649554862627564f,-0.24269675863982268f,0.2530116558954867f},
{0.3681205733679608f,-0.25314624277944964f,0.25722705742402774f},
{0.36500505183679227f,-0.26932925502738775f,0.26119611207887994f},
{0.3646862614992559f,-0.2784940140217508f,0.2544609044520247f},
{0.3624121743916139f,-0.2875141697513045f,0.26118839156131407f},
{0.3514626595162635f,-0.29091330423496436f,0.26391480729394534f},
{0.3594658147442241f,-0.3000401288960116f,0.2615368485745775f},
{0.358404841183315f,-0.31273500769551654f,0.2547484684991667f},
{0.35294897016930393f,-0.32584424041519805f,0.2589190863512315f},
{0.3410695881690169f,-0.32024948082799554f,0.2561387491725377f},
{0.33380050999282757f,-0.32277613626947027f,0.2452894788486448f},
{0.33188391780170107f,-0.3308972272637649f,0.23897624473078993f},
{0.33962737168978296f,-0.32711324192485247f,0.22732369635991873f},
{0.35116068815679025f,-0.3359174675163593f,0.22244639776631647f},
{0.35492088299758084f,-0.31884333415636834f,0.22438521977848988f},
{0.3578009792073622f,-0.30888990734725014f,0.23021017657823928f},
{0.36401917669685135f,-0.3093725103452346f,0.2370887508272113f},
{0.3701506030907475f,-0.30096675248989974f,0.24264302417753486f},
{0.36964566934297427f,-0.2869933083856217f,0.24219237628170331f},
{0.3704523715303287f,-0.2664453075892897f,0.24597557118920405f},
{0.36863701724196346f,-0.25356659611653753f,0.24389721253507418f},
{0.36434323551472453f,-0.23369832490038195f,0.24158513053687117f},
{0.3608092251721772f,-0.22128211460741373f,0.23792426870163602f},
{0.3551553351534126f,-0.20840745515805448f,0.24090540095669472f},
{0.3459414567962948f,-0.20784290545834908f,0.24284937033471465f},
{0.34101349834861117f,-0.1927999364726875f,0.2443932103707455f},
{0.33252141773378f,-0.19819789351208053f,0.25679243913725536f},
{0.3365360454341123f,-0.20159378552709986f,0.2672490573453362f},
{0.34837088598690424f,-0.1995124489438745f,0.2753800372315399f},
{0.359333775514193f,-0.1859930758133965f,0.27431796939058495f},
{0.3650028632767006f,-0.1866540007753102f,0.2688343567838013f},
{0.36817982491401346f,-0.1999824879070807f,0.26121692358549853f},
{0.36304189324888186f,-0.20811484573621583f,0.2519142279353431f},
{0.3683523110718344f,-0.21649336876730407f,0.25145877901861163f},
{0.3631520065065f,-0.1972101538464306f,0.24344613967611803f},
{0.3522794535154189f,-0.19841528446086817f,0.23801543604075256f},
{0.35184929309182367f,-0.18657918601722756f,0.23879500539501045f},
{0.34675898066961686f,-0.17308372449936196f,0.24516351871611095f},
{0.3325420050723503f,-0.1867953605090711f,0.2547522368596739f},
{0.33222317436331716f,-0.18666891485616738f,0.2641353387202236f},
{0.33766478042764386f,-0.18163829912888635f,0.2716575727417654f},
{0.3482760512160226f,-0.18268974820376577f,0.2769600883754164f},
{0.3523475400448318f,-0.1747842643755433f,0.272680531226365f},
{0.3621467179886204f,-0.17399089540622242f,0.26531631443065995f},
{0.3684817559019897f,-0.18245176991640777f,0.25966576780927797f},
{0.3680502982784565f,-0.19665962686742858f,0.2517999404774337f},
{0.3652155520085147f,-0.18416106403295546f,0.24749600638114855f},
{-0.18044000351510367f,-0.4240696273947069f,0.311520258040754f},
{-0.03618791229587017f,0.3422070832461577f,0.20880581665344525f},
{-0.07268216138491083f,0.3129724685902702f,0.23450177080779444f},
{-0.07756740466412719f,0.2914033334635509f,0.24051556528399082f},
{-0.10922334233902263f,0.27207821399137017f,0.24956899562619933f},
{-0.11471182821043746f,0.2384902823993056f,0.2355550227887299f},
{-0.14529543624732708f,0.22603784081274336f,0.22036895065808884f},
{0.3885652698783382f,0.28245604616096925f,0.08943614718138648f},
{0.3886032838922399f,0.28440348111327013f,0.07822148718853124f},
{0.38388987870207947f,0.27671903441744417f,0.0940545348665216f},
{0.40907776819283487f,0.26973466241138416f,0.09497268363329782f},
{0.41992126220545695f,0.26451364939298877f,0.10078283259297117f},
{0.40345966431879127f,0.2711590474379106f,0.11155189325191486f},
{0.38775414913689565f,0.27183140072065215f,0.12084727741151183f},
{0.41722459389154654f,0.26101254713240113f,0.1111680612457535f},
{0.43510611894156165f,0.240848910608544f,0.11508565499103447f},
{0.4474326822009915f,0.21100224812451673f,0.10649776219013508f},
{0.45655675097617576f,0.17470228686399578f,0.095900067911179f},
{0.459460476198092f,0.135107591810631f,0.08200382579533592f},
{0.36162553258855523f,0.2849569265265302f,0.07926827335552619f},
{0.3954584129256288f,0.2871356922805127f,0.06028713603490703f},
{0.42378496531450177f,0.2818392971782635f,0.06334933000597971f},
{0.4384281289925568f,0.2749667000356388f,0.06858657236610276f},
{0.4128813677047624f,0.2746107052389532f,0.07446525087924617f},
{0.3968443366645649f,0.27992793203356936f,0.08168387743328512f},
{0.4121127613367109f,0.27325157011298273f,0.09076988119899279f},
{0.13005105386395438f,-0.8455154384351543f,0.14893813144019033f},
{0.13013944513145964f,-0.831856650839618f,0.14681209192348238f},
{0.14589278247617216f,-0.8067770111431796f,0.14200793479565973f},
{0.1601890901895357f,-0.8122033376583621f,0.1468922962763925f},
{0.1447609866857359f,-0.8525408236323678f,0.16234108804750474f},
{0.11214398640533622f,-0.8755777080852537f,0.1605110225981743f},
{0.04878690666557575f,-0.6350547468492835f,0.2379766709045282f},
{0.05851204540898431f,-0.6213990391739928f,0.23353703014644686f},
{0.05456571778203473f,-0.6548492572159055f,0.2227547924434177f},
{0.049174457099077314f,-0.6699560163537901f,0.21685627877643443f},
{0.03676167094648533f,-0.6539005865351138f,0.20454995863544403f},
{0.38058853779505614f,0.4087989429811459f,0.02457686847976521f},
{0.3542329665028092f,0.3877721489812413f,0.0384011940860353f},
{0.341209408473859f,0.36415847482825403f,0.04664003811252035f},
{0.3447205207408462f,0.38658298635620986f,0.04399853532421962f},
{-0.0982129291855117f,-0.8751445484844066f,0.2755449845435307f},
{-0.11497025359853473f,-0.8759927111366032f,0.2886897197450477f},
{-0.1478441387757051f,-0.8716012983811228f,0.28520849619702016f},
{-0.1764938373741415f,-0.8741358974458038f,0.277667821963095f},
{-0.414751314880927f,0.0887629365355411f,0.15511466554494532f},
{-0.4130039249450761f,0.10630362416111673f,0.15343945559580469f},
{-0.40434559875590853f,0.12489867929582986f,0.14381232716022638f},
{-0.37902903468066107f,0.11706452340325285f,0.14962132553223992f},
{-0.40455804525874167f,0.16621547472950166f,0.13453438454967007f},
{-0.42550423012836f,0.1378122441192446f,0.13156922984568784f},
{-0.4461414721184464f,0.16390507558527198f,0.10711667529755263f},
{-0.4606810478476611f,0.17340507842694727f,0.08569319840659927f},
{-0.4058383136032366f,0.5683308170744376f,-0.039026781239324425f},
{-0.40564155142692393f,0.5545124313902413f,-0.007286616935544711f},
{-0.3933104081274189f,0.5552899141755575f,0.01772335324384198f},
{-0.3743601698755881f,0.567933970572586f,0.02953375947937818f},
{-0.38020887573955475f,0.5294108667837979f,0.04917299044509351f},
{-0.37400344520473594f,0.4848859429172564f,0.0688547155984514f},
{-0.38774896246196017f,0.414605825036799f,0.0802176781601154f},
{-0.39193246838318574f,0.32861176176846224f,0.10467819757961307f},
{-0.39872530738418116f,0.31813714955927874f,0.10021002054771608f},
{-0.38607857478187574f,0.2580528946384744f,0.12111907638913967f},
{-0.3923554968631429f,0.23663581875458506f,0.11541683194124452f},
{-0.3744191781302519f,0.24686450905320426f,0.13098729384214794f},
{-0.3758137339326562f,0.2793170188569721f,0.12243736937161433f},
{-0.3383887869157704f,-0.6539694836816867f,0.045414214981139074f},
{-0.3334541214875731f,-0.6462533442984373f,0.054683177058465156f},
{-0.3328364800823058f,-0.6813031076051587f,0.03317387992691031f},
{-0.33875568414141716f,-0.6988353660871582f,0.011306112588469142f},
{-0.3483807759412209f,-0.7213828385703962f,-0.002756533400474261f},
{-0.3651646095539554f,-0.7197633540357821f,0.023455965556619756f},
{-0.37359448087938685f,-0.7248375762916842f,0.030972310651662623f},
{-0.3649657002514558f,-0.6677817902683858f,0.05931267752930809f},
{-0.37521189903080776f,-0.6949451983995301f,0.04521869475955803f},
{-0.3772513310627259f,-0.6711027867823289f,0.06489909721519066f},
{-0.38912463290310806f,-0.6927776187373942f,0.06730236780066644f},
{-0.4000976939227838f,-0.7287551402895465f,0.07141223504925663f},
{-0.4146631669048106f,-0.7757603964921677f,0.08181412863096946f},
{-0.42644710537454f,-0.7900608178485771f,0.07177317216708116f},
{-0.44493391071493626f,-0.7966074905852116f,0.03938352609592493f},
{-0.4533903273619447f,-0.79426758731365f,0.024149479878149825f},
{-0.37224438365666845f,0.3828875952046947f,-0.16965962980657975f},
{-0.3745395850571553f,0.3711550050293084f,-0.16375671883366488f},
{-0.3736402770305074f,0.42859061671891124f,-0.1660575329346196f},
{-0.35519047322936853f,0.39439290660179194f,-0.18557345766251407f},
{-0.3592903304715592f,0.43637743596904105f,-0.17846053218645236f},
{-0.3652764864085406f,0.479706915193162f,-0.16100912718853574f},
{-0.372042515548414f,0.30451248544023884f,-0.16559373561730567f},
{0.20792913206993846f,-0.7660658604057681f,-0.283192549752182f},
{0.2291788691618534f,-0.76802156195325f,-0.28603973788000375f},
{0.20309521796172475f,-0.7671301157444068f,-0.25492557400615184f},
{0.201252487548874f,-0.7860677102808735f,-0.2615962616066175f},
{0.18963998026600865f,-0.7704545172753856f,-0.23656347196984853f},
{0.18792065595731297f,-0.7586389264897295f,-0.2272225593858995f},
{0.19895347529156743f,-0.7546613821340561f,-0.21378100019075585f},
{0.22582316059748672f,-0.7697428517163968f,-0.24526135266424434f},
{0.2507753804130584f,-0.7744203900188424f,-0.27160904089053034f},
{0.25106713884623993f,-0.7682156086151966f,-0.2968370320265369f},
{0.2249521806127234f,-0.7582581287202776f,-0.3136912618432661f},
{0.20115572769503792f,-0.7564533517640833f,-0.30508416389635906f},
{0.2017845541297442f,-0.7653710541963393f,-0.3012027504490972f},
{0.20481196911870106f,-0.7808817928421219f,-0.30849837394686347f},
{0.20146041456887717f,-0.7980963148951341f,-0.338232289464308f},
{0.1898858012478309f,-0.8049759621759957f,-0.3646057325807593f},
{0.17422555526278133f,-0.7897284913731151f,-0.3690901973868137f},
{0.17232010772959702f,-0.7928745709401646f,-0.36573061847078986f},
{0.07694524271362226f,-0.6361199753534775f,0.20202498498553487f},
{0.11176119237160662f,-0.6307226663828494f,0.20394637076070674f},
{0.10404973501958233f,-0.6329270457267585f,0.20674739726912078f},
{0.06953064016505113f,-0.6153643110142794f,0.21272960211145137f},
{0.13181945716390803f,-0.6226968956798064f,0.21108226443124425f},
{0.11287857978730394f,-0.6225354341278448f,0.19740548283460554f},
{0.06255690711081496f,-0.6426225539163054f,0.20163664943266077f},
{0.05950045439155543f,-0.6329348268015695f,0.20602062533346094f},
{0.05190635379360782f,-0.6231106025936258f,0.2113053690092419f},
{0.05982261893630087f,-0.5974040806687759f,0.22359061416647646f},
{0.320729210544054f,-0.6243975981043827f,0.06632756932456783f},
{0.3195804141038188f,-0.6213380856506262f,-0.03140893688919861f},
{0.31795095993430195f,-0.6248109799214119f,-0.05628877061094461f},
{-0.11264809041260887f,-0.10918849376919523f,0.3849294134045574f},
{-0.06264546092671532f,-0.12648763660438977f,0.3924930877051927f},
{-0.09223595351442901f,-0.14437815812375246f,0.3825948189848296f},
{-0.14112946855425304f,-0.12399948175959441f,0.3725385532243783f},
{-0.14387959297960468f,-0.08603667272722695f,0.37587805157035775f},
{-0.12003390808393641f,-0.083714763456768f,0.3849527173199016f},
{-0.15476425317010495f,-0.06352891729761243f,0.3699512077366742f},
{-0.18062474879666096f,-0.04514744331727505f,0.3537714995770297f},
{0.03911658497801495f,0.662521595649904f,0.18750571399441268f},
{0.05171693816731133f,0.6596869704944527f,0.1708108793464516f},
{0.04321779572775748f,0.6442241761883856f,0.17281892253958034f},
{0.046848297134964696f,0.6410928481537981f,0.16003285727761826f},
{0.05788263146275834f,0.6688448801456554f,0.15971408712583035f},
{0.07888042810385706f,0.6800179861817811f,0.14871261519646067f},
{0.09815335785470784f,0.7096424768818691f,0.13824209644457472f},
{0.11164912322120747f,0.7087927333668491f,0.12470741932957277f},
{0.12424129480794785f,0.7099411654012051f,0.10254503568093712f},
{0.1268600493201897f,0.7045766433980463f,0.07192584016958718f},
{0.1217842759488828f,0.7095195966695808f,0.03582240523084475f},
{0.12175701137721744f,0.6992732767757383f,-0.011922583220328166f},
{-0.06771930390302885f,-0.7518622190889431f,0.23383888039142953f},
{0.36267094293743435f,0.32560566399224217f,0.059071340970858074f},
{0.3897266696624407f,0.36207738047400967f,0.03359663749287556f},
{0.3599134422146477f,0.3543542716955171f,0.03407701687131067f},
{0.32468434446935274f,0.33294051902326205f,0.041592361178195154f},
{0.3576487574161372f,0.3697354837057428f,0.024458283582258458f},
{0.3849687251496006f,0.39779706627440004f,0.01178410154932848f},
{0.395519609740384f,0.37025666910580796f,0.02571668119954674f},
{0.38927924511190914f,0.33353587005023716f,0.05592963002472925f},
{0.36596361140949263f,0.3131390371365813f,0.07105574410812306f},
{0.3813303959216387f,-0.34685295967100643f,0.15070306916586296f},
{0.3767036800216696f,-0.26670225304330564f,0.1717017582295234f},
{0.3738554783567958f,-0.3812101871337922f,0.17850930732907622f},
{0.3737274507786607f,-0.4160433701088861f,0.17261639573848275f},
{0.35397581919130905f,-0.35724505785269767f,0.17695280232952504f},
{0.34712522876409085f,-0.3770004992344611f,0.16467067852644052f},
{0.3347512077477233f,-0.3636250813000274f,0.14508722503323435f},
{0.33285029882070943f,-0.3871330586246687f,0.13949351935458085f},
{0.31022995791049945f,-0.3872993838795909f,0.15485184391332427f},
{0.30738333710844906f,-0.37093497080988597f,0.15995869165070842f},
{0.3026425345456469f,-0.34746654799047294f,0.167320617895172f},
{0.30158101490712264f,-0.3350838949106374f,0.1711552025309206f},
{0.292582885016316f,-0.33580074714456165f,0.18440289779826122f},
{0.2927447725938098f,-0.32378446327369054f,0.18710169411501804f},
{0.2889738176867049f,-0.3113060033198258f,0.18515051098795834f},
{0.2921650655218584f,-0.3029279668715152f,0.1906728079879728f},
{0.29397172718951037f,-0.2917663295277141f,0.1935524994203782f},
{0.2881151988168279f,-0.27773014811735397f,0.19722186158051278f},
{0.2980899024671861f,-0.2723373788153043f,0.19377092302955856f},
{0.29942484338006625f,-0.26254492803777774f,0.2040825735669508f},
{0.2907700029509281f,-0.2567711973554732f,0.2148500076795352f},
{0.2916133826431575f,-0.24638509752828547f,0.21445167168193183f},
{0.29934141674426396f,-0.2364217818272583f,0.22029022623926006f},
{0.3002992676909542f,-0.22473847356302204f,0.22664990457700046f},
{0.2948832348450571f,-0.2153726974490615f,0.2286697617449926f},
{0.30194582450141993f,-0.20556436048753024f,0.23437200088084867f},
{0.30364024490860725f,-0.19412129981373727f,0.23692692380696273f},
{0.3047829622513453f,-0.18527233197965884f,0.23330395593354653f},
{0.31174443511943734f,-0.17135530173016902f,0.2311861638886789f},
{0.3144725135202935f,-0.13793669457027843f,0.23915884182375244f},
{0.32033929412835643f,-0.10682840687403165f,0.23115805789002689f},
{-0.22913807907634032f,-0.7946718908559303f,0.20584325634933856f},
{-0.2340580737150693f,-0.7992699950511292f,0.19893120669263545f},
{-0.20929712342742507f,-0.7890220135514696f,0.2242215898521853f},
{-0.17883164451509104f,-0.7799707324602636f,0.23590125087040484f},
{-0.15965866502873405f,-0.7639461029064494f,0.23802945876145595f},
{-0.14079706027338956f,-0.7505199433125328f,0.23700866865119946f},
{-0.1206870721567874f,-0.7291549052256562f,0.23233477759477053f},
{-0.11370823210820154f,-0.7424392174406266f,0.2289679434958023f},
{-0.09066907410259899f,-0.7249679135444014f,0.2296463355045441f},
{-0.06247996647470153f,-0.6680542978720239f,0.22245107873513373f},
{-0.05298922889154997f,-0.7194367008180332f,0.21536990650374077f},
{-0.24292758851622123f,-0.7798100804630546f,0.19555413948162728f},
{-0.22558769596701056f,-0.7836336203071952f,0.21291966580651278f},
{-0.19760651004707722f,-0.7765717594625912f,0.22846179435349254f},
{-0.19028549500261716f,-0.7566394548028236f,0.22401372338942732f},
{-0.0920828244269328f,-0.7149572622633348f,0.22143298395349492f},
{-0.05793298746820559f,-0.6279842943127081f,0.21457708467444278f},
{-0.044855034159308804f,-0.5851185316629074f,0.2160549661839073f},
{-0.03952623668121808f,-0.6235703478875468f,0.21312051081604486f},
{-0.022758018338496357f,-0.556816458212418f,0.2111725202244586f},
{0.08393242160112019f,-0.9793654320903752f,0.20528923298622906f},
{0.0670873497397257f,-0.9929652124936552f,0.21847205444537884f},
{0.06252324896894035f,-0.983286238556878f,0.22010357606049685f},
{0.06834938079172918f,-0.9707392044284149f,0.21784766568810107f},
{0.07409520733286587f,-0.9793067478700938f,0.21180240056771374f},
{-0.4150313602679873f,-0.982781425923595f,-0.08673593148779354f},
{-0.4266110805833833f,-0.9936178687355722f,-0.06847690107013413f},
{-0.4343677465750085f,-0.9910746790413281f,-0.05840208460688696f},
{0.3541853876313811f,-0.23800138782226174f,-0.16231105696589837f},
{0.34793716012269343f,-0.22623361919942264f,-0.14605576380250787f},
{0.3441811384197863f,-0.20505436011690398f,-0.14848150537560373f},
{0.018479196375650552f,-0.2333277400572216f,-0.35479147800771826f},
{-0.015981433114608378f,-0.22496332155223825f,-0.3594876594424393f},
{0.016396237495697095f,-0.18730827825154764f,-0.35592236118984444f},
{-0.025796997636480933f,-0.157344814652729f,-0.3585331518931316f},
{-0.04535617617360322f,-0.3092514139156616f,-0.35566756392442334f},
{-0.009419407522690512f,-0.29587453623289495f,-0.35467094890391654f},
{-0.025978382522130625f,-0.36989519334722315f,-0.34754708168980464f},
{-0.056596629303304904f,-0.3978297618747976f,-0.3447589825596403f},
{0.23621294804218795f,0.30106731257647723f,-0.25107848695527807f},
{0.2075178984415041f,0.3261267686493138f,-0.2666566236902114f},
{0.2146207522915132f,0.36060047213010055f,-0.2681991059690592f},
{0.18410828095686282f,0.34026969973416094f,-0.2725130298859955f},
{0.20085201292434612f,0.2675091284031334f,-0.2635295516613166f},
{0.21053048009259742f,0.27417219641477525f,-0.26052110383901755f},
{0.22553634554785168f,0.22517808729132374f,-0.24873661716685744f},
{0.2452569144556121f,0.2537707441519554f,-0.24073834582760598f},
{-0.349727246103671f,-0.06318135270691065f,-0.20780767176568996f},
{0.30616090199557855f,0.23412813047976833f,0.2716583833589255f},
{0.30503214575389076f,0.24877644152366976f,0.2683080442036379f},
{0.3136818186314341f,0.24162987809148176f,0.275744239128569f},
{0.31388388965958053f,0.2227087381271989f,0.2762857080185706f},
{0.3166543995660183f,0.20785487135752942f,0.28181973718804687f},
{0.2247284279659608f,-0.9260736910737758f,-0.21254529135468903f},
{0.22327676774369076f,-0.9198656672014893f,-0.20848711768298073f},
{0.19701878710818846f,-0.9197946622378186f,-0.22007218722170746f},
{0.20188741326682577f,-0.9352668195439282f,-0.22127235214203428f},
{-0.17762136759721478f,-0.540482359887205f,0.34236906750276236f},
{-0.1806226824134677f,-0.5416652808663441f,0.33453489248684476f},
{-0.013922489963232849f,-0.4144754367885071f,0.26993433770991576f},
{-0.03045800168615692f,-0.4152997696334928f,0.2682466859028952f},
{-0.0445187109056601f,-0.4070807639480711f,0.24743018915482112f},
{-0.04081379633052292f,-0.4123547071860408f,0.2792556552441903f},
{-0.027419137128216056f,-0.41164190697550934f,0.29069916106685634f},
{-0.017594024747341907f,-0.41398424209855134f,0.28326379800724155f},
{0.0012052177318780837f,-0.4000208483721697f,0.27776046817388506f},
{0.2897430731859292f,-0.45979376999586635f,0.15104278256283807f},
{0.29024995220240546f,-0.4457282470065695f,0.16105755811102868f},
{0.286105190169248f,-0.44410568255170985f,0.14950256958707553f},
{0.2852412826332855f,-0.42825143133861854f,0.1550080476090268f},
{0.2843241824630193f,-0.4236915855111179f,0.16777006951980786f},
{0.28627962159577164f,-0.4289754165785889f,0.1767015311956301f},
{0.28718063159973345f,-0.4429065502917758f,0.1757903380127955f},
{0.2956428436813534f,-0.43981023921865386f,0.18559264793481234f},
{0.30559240013881445f,-0.4461416288235987f,0.18712767211082376f},
{0.3081664931514783f,-0.44694407606766845f,0.20056372059664934f},
{0.3165767896129838f,-0.44698444225246464f,0.20882951578449538f},
{0.3262572222356862f,-0.4520395358557216f,0.20787819014658304f},
{0.33528102521125663f,-0.4529358447051177f,0.20410245227951093f},
{0.3330420761795707f,-0.45671869539248755f,0.19276158248828612f},
{0.3449155001968512f,-0.46502686152867f,0.18137423660494148f},
{-0.2953938832844483f,-0.1070348539599535f,0.23654314810841537f},
{-0.28137257558344864f,-0.15225827165343736f,0.28392265552355417f},
{-0.48926584182808014f,-0.6984394916884542f,0.053688766534167105f},
{-0.494912963246678f,-0.7194623144079596f,0.04540155639206559f},
{-0.49694684313537346f,-0.7487540727928016f,0.07586946821828784f},
{-0.48805637552736403f,-0.7055640887767325f,0.07845285198726294f},
{-0.49351581304439807f,-0.745132684719801f,0.080790352092355f},
{-0.49565113375574693f,-0.7871532031516633f,0.08283646879422282f},
{-0.4985011999463299f,-0.7715894535433125f,0.06255165722261463f},
{-0.47542455806832357f,-0.6635299534639509f,0.05799370566824192f},
{-0.46847127105241887f,-0.6549034017676084f,0.08509103840796056f},
{-0.457804070867214f,-0.6397741089600427f,0.09908520583900883f},
{-0.48046587224226595f,-0.7001492723877795f,0.08281510271072669f},
{-0.4870219887219366f,-0.7394474674819002f,0.08072227831183605f},
{-0.4854558381218652f,-0.7657622274404778f,0.07974320683151978f},
{0.1473577142968228f,0.20343492657786466f,0.30069769558683324f},
{0.1794614834244416f,0.2104521259228908f,0.30738114907956127f},
{0.16389297210428008f,0.21236430062233744f,0.30647965249282183f},
{0.12915002261183642f,0.21223866452418597f,0.3103579244001852f},
{0.1550003563076758f,0.2231893958564807f,0.3114519887771977f},
{0.17994566728524952f,0.21881905702234827f,0.3094672080655086f},
{0.13383905085476297f,0.19068979376406225f,0.3057270332375171f},
{0.12013096116232844f,0.19656289782341907f,0.2922915127683738f},
{0.10352419268508224f,0.20033756053378593f,0.29749432992818226f},
{0.11040471220275705f,0.20920298294004816f,0.3065799990354293f},
{0.1290954732827572f,0.2235098881713309f,0.31287904788418563f},
{0.17031376651378216f,0.0992740233297074f,0.30973256247735215f},
{0.17474511942852636f,0.09884751121453648f,0.2966752868116898f},
{0.1916178914487889f,0.09387898366216464f,0.3085528435953568f},
{0.15786849724235508f,0.09668576629610116f,0.3017097718282202f},
{0.450267915053711f,0.27550636601958434f,0.043627047434419544f},
{0.43431380388078966f,0.29798648184757603f,0.05705961122262358f},
{0.4318542618031725f,0.28507940089903466f,0.04713920086106198f},
{0.43525615217269525f,0.27951163178228217f,0.047517929060097115f},
{0.41668849441062383f,0.2852538312631505f,0.05202843029438684f},
{0.39188582018100043f,0.28963940927493037f,0.058476751690283775f},
{0.37178836528935f,0.2991039914401717f,0.06812647966482736f},
{0.4122702516082732f,0.3088930372006626f,0.06452586803898762f},
{0.47770918107423177f,0.29039306119062785f,0.05161342511822177f},
{0.4682260375821165f,0.28370462181804057f,0.05147704382746535f},
{0.46734415623079995f,0.27334551352371067f,0.046556560481143115f},
{0.46513199474967193f,0.2674749231212358f,0.0488688815211037f},
{0.4561344130612962f,0.27013645442159817f,0.06219356204568576f},
{0.3906489171985536f,0.31989361776987846f,0.06320083407894929f},
{0.41613800674071083f,0.3209342865926951f,0.052384588701875436f},
{0.43743017640061527f,0.3169104584407155f,0.05479375671311259f},
{0.45486289789475975f,0.30757475484226615f,0.05359674820639359f},
{0.47954508339207846f,0.29889948856054477f,0.03867602305074143f},
{0.49195566079883024f,0.28582632458606216f,0.037216009115849984f},
{0.48748521871347916f,0.27516496126937345f,0.05209730619280344f},
{0.4867939790070735f,0.2631300353286347f,0.053616618419691224f},
{0.4853023595021992f,0.2544277775140557f,0.058933506306215584f},
{0.4757440772176185f,0.2556075378299557f,0.0654969927088742f},
{0.34163535432566633f,-0.4150014858915332f,0.13886309080889492f},
{0.35981852670077236f,-0.40883771767904065f,0.16567808336068046f},
{-0.47039544246087234f,-0.3319232242347053f,-0.02109150685331206f},
{-0.4707520045833293f,-0.33660838212597477f,-0.041592687337393276f},
{-0.4685538254514079f,-0.31974953189767347f,0.0010677873134078662f},
{-0.4562728564856145f,-0.28977220812654664f,0.04365702008359631f},
{-0.43709351423887477f,-0.24382310215337058f,0.09234662931698344f},
{-0.43082741384357504f,-0.23714803743272175f,0.10725234158785193f},
{-0.4327640674814053f,-0.21523425508715086f,0.12441499689150894f},
{-0.4324636769847555f,-0.23568353057519567f,0.12736206091527774f},
{-0.4460874486812339f,-0.3543322543560326f,0.08841253531598278f},
{-0.4290212185729524f,-0.3324795880822235f,0.12062180685131807f},
{-0.44609997234451537f,-0.4626435121520668f,0.07464394043627816f},
{-0.45393530219772404f,-0.41325571719000265f,-0.05906970592523626f},
{-0.4555239460959795f,-0.40831507359305025f,-0.02506843819967838f},
{-0.4573542548366988f,-0.3908771643615625f,-0.03790802544236592f},
{-0.4627201558451968f,-0.3527646450700361f,-0.06019556391841433f},
{-0.45106391879440416f,-0.4171685800332992f,-0.028236802832980985f},
{-0.448670680525892f,-0.4251860820163458f,-0.050111345146035796f},
{0.30015717702061906f,-0.4225208227269731f,0.18166940005515883f},
{0.2942468695645208f,-0.41348007859644126f,0.1746968112141356f},
{0.2863701801752122f,-0.41165163331902327f,0.1756742264006738f},
{0.28865105606876934f,-0.3921030438005578f,0.17666835963653305f},
{0.29955222182702834f,-0.39640286531620483f,0.17246128632282598f},
{0.3053910387990861f,-0.4061183127755572f,0.1648803277095061f},
{0.3119592114826009f,-0.41577831954567657f,0.1731170841046416f},
{0.31502672917921687f,-0.42373600371930703f,0.18184007162043778f},
{0.3056408714328042f,-0.43337363830573283f,0.1884665938657734f},
{0.3079140055606394f,-0.4344949576927404f,0.2000857581959853f},
{0.3184904240607632f,-0.43214727228395994f,0.21178858076690235f},
{0.3277261869563892f,-0.44045219701390964f,0.2145196169111056f},
{0.33775013108399266f,-0.4443504698107315f,0.20983156183373436f},
{0.3424061492538095f,-0.44556937879207587f,0.2013733008467652f},
{0.3353138525502228f,-0.45269997423485764f,0.17852559935286488f},
{0.3503667104277935f,-0.08612259177175491f,-0.18402139034039133f},
{0.3717096610562696f,-0.11478211870485507f,-0.1854292804232372f},
{-0.25778210441706356f,0.6204000018636757f,0.06595161932195966f},
{-0.2664384237178753f,0.628865496785433f,0.08553370443390465f},
{-0.25841488300882837f,0.645223142317379f,0.044165358848405466f},
{-0.2673027562169623f,0.6698945465002271f,0.03143228117603969f},
{-0.27231023057729425f,0.7047094932452375f,0.0184065303373666f},
{-0.26992448972070743f,0.7230367408684701f,0.00975297754649589f},
{-0.27035651467001204f,0.7445548113637321f,0.014146416313672678f},
{-0.2696062667089425f,0.758933085964565f,0.026523115660132886f},
{-0.2665973323038658f,0.7490215243976649f,0.02748417507841375f},
{0.19511088753777522f,0.21730364701935198f,0.1696953150225587f},
{0.20699857756714787f,0.2283031736800189f,0.1550611488762589f},
{0.18649311026754747f,0.23397234218552002f,0.166775156476615f},
{0.1726194039462009f,0.22474241509600246f,0.17076533604839017f},
{0.1645881225338398f,0.2607473340207965f,0.1777485532171592f},
{0.19729220732013655f,0.2462341421271714f,0.1604916400300621f},
{0.2154292786330801f,0.24239666136772886f,0.14567576708854582f},
{0.2256392057473412f,0.22896272069900117f,0.14089349556163916f},
{0.20914200338769026f,0.2084909933466769f,0.169105658501453f},
{0.18124080933910477f,0.2169056658659577f,0.17160639650436724f},
{0.17123048103001295f,0.22011172685322636f,0.17522180640861273f},
{0.4218658190949966f,0.33900945246487296f,0.023203600142679023f},
{0.40294281460500464f,0.3741154681403953f,0.013584389832519469f},
{-0.05906045925884926f,-0.37748910058694907f,0.2665719614741244f},
{-0.052444577027745305f,-0.3734403897816175f,0.2894662293648086f},
{-0.05244063655717266f,-0.38863322945001744f,0.28770311473094035f},
{-0.05073686696124447f,-0.40130119745965825f,0.2705781600308807f},
{-0.055331680879451166f,-0.3989831787266048f,0.24967945310394843f},
{-0.04846423322748858f,-0.4487674961561382f,0.23511392062708425f},
{-0.17176056409549909f,0.645303630333175f,0.15120165077733175f},
{-0.16332761284982222f,0.6518016288559276f,0.16926043325864912f},
{-0.15447053990655027f,0.6232888523138238f,0.14750817408469274f},
{-0.16568800359361985f,0.6243504739434977f,0.13796112782512623f},
{-0.450058104384658f,-0.8082491375895295f,0.053874644342451386f},
{-0.437700212843684f,-0.8048277934705712f,0.06904340028817355f},
{-0.4293935861364203f,-0.8089473477535862f,0.09000785963455671f},
{-0.44527178933362094f,-0.8146768206512811f,0.07613845287762316f},
{-0.45190203106870447f,-0.8178807748838597f,0.07893931577523425f},
{-0.4569896279765451f,-0.8107297525260869f,0.06490288576144632f},
{0.1770501693494254f,-0.7689851477773064f,-0.34580106969688523f},
{0.1907469932694272f,-0.7858858218139213f,-0.34795928742138654f},
{0.14760329198725622f,-0.7731625746010349f,-0.36471434678095555f},
{0.15645817637043666f,-0.7849081335885755f,-0.34837603388395455f},
{0.10345106078097291f,-0.5526370861199869f,0.24237152904854112f},
{0.09749434841407827f,-0.5204939643446239f,0.2378061310778179f},
{0.08649347462030633f,-0.5156293509002905f,0.24090718473941014f},
{0.10607715015674513f,-0.5329508648567708f,0.24278882158872422f},
{0.11169679452211531f,-0.5379214991638328f,0.23583012479224358f},
{-0.346918133609404f,-0.7434569478163859f,-0.03929239912830525f},
{-0.3621396062307305f,-0.7620422755451774f,-0.034517346662477404f},
{-0.3385058111362021f,-0.74167567663302f,-0.036966183918986456f},
{-0.3309446494300408f,-0.7374564249385702f,-0.0582162450452839f},
{-0.3225012015951868f,-0.751999201702521f,-0.05643668646331f},
{-0.3144640238194721f,-0.7573767339517387f,-0.06800307249826444f},
{-0.3118930914700472f,-0.7436077109216861f,-0.07231419059617067f},
{-0.30779959698823933f,-0.7463094458584494f,-0.07645243688222046f},
{-0.3013610720547718f,-0.7756929580315199f,-0.0682134611171668f},
{-0.29454622740077774f,-0.7589420739346499f,-0.08964724442629908f},
{-0.2700386964356232f,-0.8138709694525834f,-0.13753551663177943f},
{-0.23502593466815908f,-0.8263251140788674f,-0.17705608749213902f},
{-0.2461020173733116f,-0.7837569860398536f,-0.16890911943078077f},
{-0.21558974895855332f,-0.8027456452077778f,-0.1938042975085476f},
{-0.18192416704195727f,-0.8098473856544006f,-0.2143908594588042f},
{-0.18122252211344625f,-0.7813554801137527f,-0.22115990796167773f},
{-0.20249553124847103f,-0.7559391368216689f,-0.21957363642006522f},
{-0.19217385051893082f,-0.7618586043579175f,-0.2273620960278559f},
{-0.23959410977290146f,-0.7369666889345396f,-0.21860233007844285f},
{-0.26464825699390404f,-0.7383269587120527f,-0.2358882809958426f},
{-0.28546651627653735f,-0.7332640840339847f,-0.2501630685765773f},
{-0.29501507115519604f,-0.744441283527408f,-0.24336113217749233f},
{-0.3050418944079686f,-0.7591690286785563f,-0.2376914569034651f},
{-0.31845934013301563f,-0.7668812764619923f,-0.25554803768047524f},
{-0.31752910860219974f,-0.767502808404665f,-0.22181209886897346f},
{-0.3297065703621466f,-0.7603595681841113f,-0.1993925116012237f},
{-0.3354305729220204f,-0.7449428536920504f,-0.18984823185159827f},
{-0.3495092687057714f,-0.7326545477379109f,-0.19530296821406665f},
{-0.3597363377700703f,-0.7329978988192326f,-0.1971448688864167f},
{-0.4164106375836551f,-0.335546882673199f,0.1483924671017413f},
{-0.4177009966775432f,-0.22466155205024926f,0.15940002769027845f},
{-0.42079609341853663f,-0.17050081668908643f,0.1694037191377722f},
{-0.42418067822721867f,-0.14828842762958122f,0.18459964935049575f},
{-0.416064652793369f,-0.12467532080236533f,0.18182862205145373f},
{-0.4065235953266357f,-0.09372363201752693f,0.19616567097957083f},
{0.31662453103280713f,-0.9592400539342163f,0.13711844719723668f},
{0.1253813072603979f,-0.6061444343026582f,0.19910807953230983f},
{0.11499272458615484f,-0.584227572036842f,0.1913994173752375f},
{0.11699417235159006f,-0.5878580383845914f,0.18812087361503235f},
{0.13213427622104515f,-0.5648958868843865f,0.1865153905529653f},
{0.2599506763680953f,-0.8869932099004175f,0.13173604168338773f},
{0.26088615619349986f,-0.8943698898021588f,0.13091395901814668f},
{0.2664040548251748f,-0.9031844898059445f,0.10739262722731546f},
{0.25385491394202175f,-0.9043542794245341f,0.1309641832850254f},
{0.24209960842521888f,-0.9018331357547853f,0.15680482038476973f},
{0.24645047332416722f,-0.8750576573367311f,0.13675349524029268f},
{0.2636003935453884f,-0.8741542154812888f,0.11542725841150614f},
{0.1326220063991277f,-0.8706699725702611f,-0.36854096654534163f},
{0.12379332311739337f,-0.8775079585912043f,-0.34808180322779564f},
{0.10396018891478605f,-0.8765789031458356f,-0.3649070154999706f},
{0.14049937360461995f,-0.8736716124833044f,-0.3512877824096628f},
{0.26222672893018845f,-0.3266149142288507f,0.17110144257084536f},
{0.264692653953937f,-0.3059360906594317f,0.16993355678705396f},
{0.26146622767133054f,-0.2961277526354926f,0.1735045081116135f},
{0.2502041237328392f,-0.2821875406475569f,0.17833216145059427f},
{0.2633596593721675f,-0.27306509310669286f,0.17606238984348244f},
{0.2648363244246878f,-0.28176572862454385f,0.17755640082834043f},
{0.27045236085313035f,-0.28513308967778656f,0.1916538300490309f},
{0.26940597840110375f,-0.29875621330549995f,0.18994282333109108f},
{0.27519936362792f,-0.3114878907243702f,0.18404550487289573f},
{0.27212830067643745f,-0.32417223256320116f,0.1862809288354632f},
{0.26631866379732916f,-0.3343845490326302f,0.17546505317630776f},
{0.26816619735589553f,-0.3433810375033682f,0.16758198084086792f},
{0.2646137871724614f,-0.35203012286939167f,0.16831252219944282f},
{0.26976132406661657f,-0.35952514225243526f,0.17576108780093053f},
{0.27071605472156457f,-0.3800261315031104f,0.1645285379229382f},
{0.2662297657612979f,-0.3945729602904539f,0.16106675750026805f},
{0.2719018325153087f,-0.41865934854951664f,0.15655440980120205f},
{0.2780480115040748f,-0.4295509090787523f,0.1489450307165179f},
{0.27526133068833886f,-0.44643342762827715f,0.14517517008945877f},
{0.26860823231159964f,-0.47704460408546623f,0.1391707672983156f},
{-0.25617570980909427f,-0.2827867014689439f,0.3139631829977923f},
{-0.2183114635366189f,-0.3014629734312114f,0.34405894824137134f},
{-0.26506889293146985f,-0.2837180262173978f,0.30357122717874785f},
{-0.2796089754292106f,-0.283523980617859f,0.2919356794576755f},
{-0.26053577515968984f,-0.29967019318402405f,0.3058241989311371f},
{-0.29976016903277997f,-0.28671399181032f,0.2714774276860317f},
{-0.3198705937989926f,-0.26520467555542454f,0.2550072572307355f},
{-0.026775047080482627f,0.3217681832327995f,0.20967368590813656f},
{0.015930113505276153f,0.3202799273110562f,0.1869701616535131f},
{0.03919836488170954f,0.34516803294002213f,0.17604282560363452f},
{-0.041552082642043346f,0.30093713787215537f,0.22078972895830135f},
{-0.2764682652712402f,-0.3191113020914281f,0.2870511671150335f},
{-0.20727126790492947f,-0.3627680018590692f,0.3459465643218483f},
{-0.19222248329890804f,-0.381167065063133f,0.35866055158825f},
{0.34530521369265677f,-0.13772449242124193f,0.2757142282327111f},
{0.33441393682630677f,-0.13781259896345366f,0.2680343817627088f},
{0.3330729178783373f,-0.1325086660777822f,0.25999525765588344f},
{0.33743040901480575f,-0.11660764554801496f,0.25337600015516254f},
{0.34355984976850235f,-0.138485195537584f,0.24987818073471227f},
{0.3516070587987728f,-0.13699848010716725f,0.24763979796638985f},
{0.36269343623561845f,-0.12911180089720758f,0.25317563110433f},
{0.3583074534464625f,-0.13753271506238066f,0.2546941412133202f},
{0.35897636240307923f,-0.13720646768441574f,0.26839546230558786f},
{0.3539439235839936f,-0.13032057875766187f,0.2788231033406112f},
{0.3557480110375184f,-0.1469943798557718f,0.2779541302442039f},
{0.34326233627220604f,-0.14432595884075225f,0.2787976119275832f},
{0.3338490216583142f,-0.15149424532546105f,0.27285094993858483f},
{0.3306096478117096f,-0.1520213472746283f,0.2658652817949948f},
{0.3318866736875639f,-0.15501893410187081f,0.2577205224794765f},
{0.3426070452589165f,-0.1536831432627415f,0.24723079326954386f},
{-0.044606376548630026f,0.4304295989570032f,-0.3202287755621581f},
{-0.07599677601513047f,0.44845086356886693f,-0.3277358734596101f},
{-0.10036590498987119f,0.46533832656434626f,-0.32659716776876807f},
{-0.13575971737984638f,0.482599535066225f,-0.31452070062019366f},
{-0.13499052350027513f,0.47663731199001225f,-0.30991230275570963f},
{-0.15335059846247415f,0.48311626260311347f,-0.29231888889285934f},
{0.2514529830527963f,-0.6953188631629358f,0.14225217491465844f},
{0.25756497694541325f,-0.6679302830081928f,0.13901541459127006f},
{0.2628417366264911f,-0.6329507129855741f,0.1503260610050746f},
{0.26305215605522003f,-0.6233395026062349f,0.16744596076876742f},
{0.26604923611393644f,-0.6093999386870641f,0.17203234129376685f},
{0.27612388046711817f,-0.6043824543203327f,0.17895262886063995f},
{0.5000568518324087f,0.26614512957420217f,-0.004916864254112524f},
{0.5015677636007312f,0.2505051883272452f,-5.5872558008310304e-05f},
{0.10531893944912875f,0.5128190123874089f,-0.30475629528407394f},
{0.14873119617787914f,0.5016097558006828f,-0.2926380032647781f},
{0.19876970317556553f,0.4894984746105348f,-0.2824117851891362f},
{0.1494285957247757f,0.49449828901054615f,-0.30258190558786663f},
{0.2230200655810637f,0.4812928435770515f,-0.27878075151561543f},
{0.2649276330640433f,0.48225586101292883f,-0.25194537348274376f},
{0.24581990347824242f,0.4836031619782874f,-0.25649196683520425f},
{0.21255965882672728f,0.48437152611735795f,-0.2579363718745298f},
{0.1852898643645674f,0.49007177855060663f,-0.27420931481889194f},
{0.16351183011469722f,0.4925984339920813f,-0.26802508038231954f},
{0.12656554456281546f,0.5074487353211355f,-0.28532819449791336f},
{0.025077936656716728f,0.540222546994506f,-0.3045531703473785f},
{0.05965683019732333f,0.5266925157888634f,-0.3083152700853749f},
{0.047937609361836504f,0.5232094075293784f,-0.30976299833633475f},
{0.1359121718383823f,0.49052702560985395f,-0.3067894452986029f},
{0.18649906825055404f,0.4803494413765969f,-0.29447240546279496f},
{0.22744947322710507f,0.4637429969337332f,-0.2798517754544209f},
{0.28806328319671337f,0.4751224289412905f,-0.24674020627685636f},
{0.30307622110076854f,0.48279025851653734f,-0.23098542936955926f},
{0.26382678096352336f,0.48482430095362794f,-0.23935272593730386f},
{0.24121645005971293f,0.4856530502278859f,-0.24944931644864676f},
{0.2088858079935893f,0.4874563684981552f,-0.25471166881739354f},
{0.1815433278386009f,0.48529381296255975f,-0.2563951867956198f},
{0.1666898052890623f,0.5075517559442045f,-0.26288191954593987f},
{0.18978863555421088f,0.26981239454131706f,-0.24739278177577984f},
{0.19349006543172634f,0.29071841720843894f,-0.26368807565567937f},
{0.18397826880093615f,0.31627757892020864f,-0.26026776525952156f},
{0.16818178919981608f,0.32236102166530056f,-0.2697795417045634f},
{0.13298205321920617f,0.3331563694807231f,-0.2849390483278791f},
{0.11139074989109296f,0.2810717840278501f,-0.2827322371324897f},
{0.09260035195690335f,0.23430442536959328f,-0.2853014058849475f},
{0.07408918879261396f,0.21147852873361525f,-0.29207025146792903f},
{0.06145518383588969f,0.1666649263541375f,-0.3078696686266478f},
{0.07846309412976925f,0.14116282656592102f,-0.3075541611292489f},
{0.09979408948314335f,0.10738749579758611f,-0.3062882395398399f},
{-0.34375292432730137f,-0.08919815295791134f,-0.22296968992107188f},
{-0.36796401589045696f,-0.08769068657812125f,-0.20516340459226384f},
{-0.3872616986809069f,-0.705432941969263f,0.06250170918176692f},
{-0.3833697886444678f,-0.7178457483076034f,0.04052957089992845f},
{-0.3996818813166821f,-0.7430072529003613f,0.07372493536880591f},
{0.2974934985940698f,0.42131525652533286f,0.028042241965653664f},
{0.28323157783433967f,0.4064258872738279f,0.02908446190387498f},
{0.25957401242743783f,0.3941076734773883f,0.02596376538425673f},
{0.2772739539215427f,0.43773203142643313f,0.027333907055153803f},
{0.30210145024727303f,0.44548825226918526f,0.024587773033541975f},
{0.31386010022386646f,0.4417441061607945f,0.01996533969946083f},
{0.30119375344854593f,0.41903322685689237f,0.03642350600889544f},
{0.29659765507929514f,-0.6005516199841585f,0.10364933210758175f},
{0.29590842119883737f,-0.5882535876865053f,0.11377963706841336f},
{0.3097133727362578f,-0.6087910515221632f,0.0927360793356518f},
{-0.2481635782975346f,-0.6288609879266813f,-0.307773172249949f},
{-0.2387133832588759f,-0.6653564534726661f,-0.32803196757907027f},
{0.051965372672349665f,0.6754360932673772f,0.17283286451729005f},
{0.062828259877162f,0.6915337941680556f,0.15556229301536892f},
{0.09341752098601647f,0.7527074324970552f,0.13777202667154198f},
{0.11441741482013501f,0.7355733995222464f,0.11783515153336954f},
{0.12267461831600979f,0.7373640730147438f,0.1089989155945036f},
{0.12838808285280182f,0.7483356349769977f,0.09544869545322003f},
{0.13033744288805701f,0.7301664449510983f,0.08196147397034009f},
{0.1412727321228121f,-0.8057301006744708f,-0.22991821522516567f},
{0.1623553333426447f,-0.7920502391575867f,-0.22989801247822303f},
{0.17888359944429472f,-0.8001051888911713f,-0.24756733431679398f},
{0.3613992259134138f,0.489339201618665f,-0.06366679764579078f},
{0.35298321582269837f,0.5203059670327557f,-0.07728702302499453f},
{0.3528707514565935f,0.49929854497688514f,-0.056547590152339934f},
{0.3441371260513812f,0.47452107955981193f,-0.021463383584371127f},
{0.33612635123459667f,0.5263215251059191f,-0.047486024953519154f},
{0.3284318541608745f,0.5725327228365497f,-0.07288111159011125f},
{0.3488251609430041f,0.5387328323868374f,-0.09865761325509366f},
{0.36519293759584015f,0.4843901278157287f,-0.04043339430798092f},
{0.35438336520222996f,0.47366225883245067f,-0.014031124880381454f},
{0.3269498802565202f,0.4577955646990715f,0.008408831932337296f},
{0.3270339751468359f,0.47645368117424924f,-0.0020236154356251456f},
{0.3226984896633661f,0.5067743549642898f,-0.02145000362039367f},
{0.31559002205048137f,0.5478171033654046f,-0.034804439000551135f},
{0.3142784668583469f,0.5788363113538845f,-0.05270688711000518f},
{0.3108206885259025f,0.59858263515181f,-0.07087245007563624f},
{0.32732577395151446f,0.5813740710818044f,-0.08932539435426579f},
{-0.031847704409678546f,-0.3946726587642964f,0.3000112175922384f},
{-0.0152093834828399f,-0.388727901672504f,0.2946115373273752f},
{-0.02380468126618519f,-0.3888248442604836f,0.2964520802425422f},
{-0.03307840080569098f,-0.38082306697545437f,0.29940595748760584f},
{-0.028581402774684822f,-0.3779900226828265f,0.28525394812800975f},
{-0.014029395811668312f,-0.37531195606728673f,0.2870652302072337f},
{-0.0015680480604225663f,-0.3737284595348777f,0.2814881607724997f},
{-0.007005395994240959f,-0.3944938512799974f,0.2882396604231437f},
{-0.014479089665285164f,-0.402924572531678f,0.29231507909844745f},
{-0.03547981748953578f,-0.4071162664299064f,0.29322030473660515f},
{-0.04390619136845186f,-0.38961367462363394f,0.29766598422068685f},
{-0.02936779491190784f,-0.3712972879954575f,0.2937531213773902f},
{-0.01776465487871622f,-0.3652623972873491f,0.27647756612042557f},
{0.004687903153054294f,-0.35669323261135005f,0.27320348022339735f},
{0.008896226920755364f,-0.36449642569067f,0.2746814817849445f},
{-0.0008335757929452993f,-0.38078545667652103f,0.2738217080777765f},
{-5.498385387397746e-05f,-0.39417481765107226f,0.27895777627960683f},
{-0.2632858188420478f,-0.44360492300422766f,-0.26382740937774385f},
{-0.27233191219591035f,-0.4498385604664405f,-0.27268964987261074f},
{-0.26625100329344875f,-0.4128113725597164f,-0.2607610273950784f},
{-0.2597820828724956f,-0.4269402809238602f,-0.26375958632546836f},
{-0.2642099298414619f,-0.39105499974271407f,-0.2568916510283203f},
{-0.27184124446022917f,-0.3876210108459838f,-0.26171010391565386f},
{-0.2785135936665119f,-0.5118941608897503f,-0.2867834615947032f},
{-0.25689102261409974f,-0.4820157249753058f,-0.2698870818104623f},
{-0.2656642843299417f,-0.3455400265359405f,-0.2524470445761282f},
{0.2912958491340622f,-0.6387387096799708f,-0.16121873600010447f},
{-0.33472725682602184f,-0.6071692976844637f,-0.22482808553710257f},
{-0.3392642045779621f,-0.5710847821040277f,-0.22414225667368057f},
{-0.32956087387969935f,-0.5378752971729283f,-0.22587485364316473f},
{-0.3318814870126284f,-0.505134312838524f,-0.22390859388685266f},
{-0.3421262260436474f,-0.5511626903705517f,-0.22103672390075518f},
{-0.3506138084238048f,-0.6010045563064159f,-0.21546745678898854f},
{-0.349757763768055f,-0.6425311241624594f,-0.22237514951125692f},
{0.33494270038129115f,0.2465107835596039f,0.26363425513835886f},
{0.32856214997968686f,0.25596280275247485f,0.2546093971918317f},
{0.32151135411243903f,0.2557899925602715f,0.2653865077147628f},
{-0.21156861719759926f,-0.011369842183447117f,-0.25596782262938406f},
{0.45316507353294444f,0.0980440908049114f,-0.03129014057253739f},
{0.4703059972848183f,0.12614498458740817f,-0.009363010135223386f},
{0.46753982306465885f,0.12450296744552078f,0.014647743186926241f},
{0.4728163596400965f,0.15937440878831305f,0.0439472985826966f},
{0.480393934484537f,0.15796534368242768f,0.021685090033688882f},
{0.4809926490946431f,0.15468260553618296f,-0.009777424612645282f},
{0.4631411551262342f,0.1204009216432385f,-0.03652799381715201f},
{0.4579765155911304f,0.12314723627417827f,-0.05710666845181636f},
{0.44151240404758285f,0.06809586532133248f,-0.029412438881756958f},
{0.15300139138929597f,-0.37992011064038195f,0.272830483714505f},
{0.16064762008892033f,-0.3654987543403868f,0.27189283551475735f},
{0.1482964153427117f,-0.37075989131459725f,0.2640470898153652f},
{0.14357166257471715f,-0.3818758132502716f,0.27189474041196326f},
{0.1464294694686144f,-0.3909384419193116f,0.27061874825890947f},
{0.14256009310185633f,-0.39813485458842085f,0.2632288371302844f},
{0.13014537230463974f,-0.4001594532824755f,0.2454930085627164f},
{0.1387964326867848f,-0.40040618581019993f,0.22422004936085868f},
{0.09736654394158366f,-0.39033960513230714f,0.2266069248689881f},
{-0.3679143695734277f,-0.9920321039624858f,0.19057823669422833f},
{-0.3449516507474515f,-0.9744140889843536f,0.20282646012645716f},
{-0.3216035955458529f,-0.9496437565733262f,0.20338487017142015f},
{-0.3174654597502155f,-0.9687745871545795f,0.192144599775862f},
{-0.30584263861231664f,-0.9503127866444336f,0.19192520300112637f},
{-0.2387528368353621f,-0.7226331969477754f,-0.3551093769851007f},
{-0.2445684518832254f,-0.7016521990989912f,-0.34898743364332946f},
{-0.2645989145255089f,-0.7198724537563481f,-0.31875292112679793f},
{-0.280293263801306f,-0.7191987225306752f,-0.28443143943723637f},
{-0.2848010930799499f,-0.7304423873191909f,-0.26274082222690837f},
{-0.27690720012095044f,-0.7588571269932695f,-0.2717806144400412f},
{-0.2594239398872152f,-0.7983459647947089f,-0.293930916387045f},
{-0.24571749161484935f,-0.8164663594922359f,-0.3032110571193632f},
{-0.22455444275071787f,-0.8287303479939788f,-0.3048548984154628f},
{-0.21457645732263014f,-0.8467907623336945f,-0.3330307280705327f},
{-0.19870427160327356f,-0.8527210908649997f,-0.33870354488445836f},
{0.331211888553342f,-0.95720443169671f,0.07180039636724969f},
{0.3201838713023953f,-0.9591985541602852f,0.0654612649965828f},
{0.3140211166269548f,-0.9611043257278521f,0.03811072860316019f},
{0.32965826055414427f,-0.9623757590889869f,0.050805989869477236f},
{0.33455323017687444f,-0.9641455201461235f,0.041988332256010195f},
{0.34869040619860703f,-0.9815806734917484f,0.04641993164936662f},
{0.3440633652018475f,-0.9925202187321962f,0.04387151278387431f},
{0.3415168512335611f,-0.9977666031115369f,0.0552204706857677f},
{0.3329989955428163f,-0.9986157378668808f,0.03673147147324084f},
{-0.3578077286841884f,-0.7241615757629261f,-0.21982964908002267f},
{-0.057241953868915264f,0.9754831580927859f,0.11404471312941034f},
{-0.0931384689502597f,0.9814998911889888f,0.10818338267342016f},
{-0.09803559101121588f,0.9899799155999756f,0.08854875299593623f},
{-0.1202625042479114f,0.9967788528218088f,0.021784063945403994f},
{-0.29357759726443244f,0.39263343921394045f,0.13026348071224303f},
{-0.29308007912318296f,0.3641213521745062f,0.12505555655808487f},
{-0.29923164876918446f,0.3594622944559408f,0.1288107517077147f},
{-0.3076882269021802f,0.34682869321418497f,0.12589449963529373f},
{-0.31896820478969146f,0.396888112647232f,0.11477983346565258f},
{-0.23944196872466988f,0.4315124166849237f,0.13342515323874127f},
{-0.2273626436990827f,0.378526983776484f,0.15680959165825092f},
{-0.2282808583351432f,0.3554545160987688f,0.1775996238277417f},
{-0.2312403291573342f,0.32700573262878f,0.1851028609352068f},
{-0.23408950292535555f,0.3219837903988717f,0.19588087344236982f},
{-0.029697911579122112f,0.74226666116389f,-0.1938491406798613f},
{0.00880345428343575f,0.7449808783300301f,-0.17649858899307827f},
{-0.020854507574752247f,0.7290647004280167f,-0.19336542321608258f},
{-0.05963760805279066f,0.7162278138259859f,-0.20150495442276067f},
{-0.0009003417494483942f,0.753233927811362f,-0.17857672454156773f},
{-0.08147721202255795f,0.7288683440914882f,-0.19880188191456274f},
{-0.0694855133308517f,0.723360881491745f,-0.20178321708951344f},
{-0.1071313668039733f,0.6498344989876181f,-0.23439718844524268f},
{-0.08607434836424066f,0.6237405743039526f,-0.2511946803728012f},
{0.20089776870396991f,0.4913398079571135f,0.05996057418422993f},
{0.1714540721907883f,0.5129186694273468f,0.06172167555529542f},
{0.18873574797915474f,0.5190942718004511f,0.0525790720134325f},
{0.21521997367014545f,0.5035066116418958f,0.04630987788658585f},
{0.21140101386607985f,0.4670340845429682f,0.05983279414711504f},
{0.21979817896703568f,0.4371997417399225f,0.060433750437703375f},
{0.2257929669674852f,0.37831105151362143f,0.1180656579065896f},
{0.2236476766212337f,0.3585549610006851f,0.14917822710631654f},
{0.22755482477291245f,0.343042439634595f,0.16034506174913135f},
{0.21190730537103633f,0.33544593799499356f,0.17349772994977644f},
{0.18959793335205471f,0.3246644503518792f,0.18301177676031136f},
{0.16274269679237133f,0.3344609542152065f,0.18045562675317506f},
{0.2335010001791331f,-0.7480283037701159f,0.12976552167175176f},
{0.24157110728496387f,-0.7312056040924149f,0.12382106949100119f},
{0.24310605178038944f,-0.7327670524755128f,0.14228508299661827f},
{0.2325868588146218f,-0.7583678775720165f,0.14332091892630053f},
{0.21542662473836702f,-0.7737706511487755f,0.13918165910319863f},
{0.16629674733346628f,-0.8280990897077922f,0.1577510698381589f},
{0.026096254543995896f,-0.9258207987055608f,0.15822891112433243f},
{0.04745664247188164f,-0.923753240489242f,0.1636320559010688f},
{0.07220907118647027f,-0.9118768576662067f,0.1664901358337736f},
{0.025422208845610715f,-0.9798284198529366f,0.20957332980385876f},
{0.02050505083573841f,-0.9869382654087531f,0.19743599943658174f},
{0.050203433061521016f,-0.9787280139636976f,0.20815620952194697f},
{0.08101548533806863f,-0.9603971987750339f,0.20895166612261737f},
{0.08095262691749609f,-0.9654268413367595f,0.19985088001462112f},
{-0.04745260425979023f,0.8524017841972669f,0.18030784263937832f},
{-0.0685634942124184f,0.853447194546146f,0.1725165251545748f},
{-0.05591538791681279f,0.8231389222424885f,0.19349737107904183f},
{-0.16894834087116015f,-0.3704896530140444f,0.365400460369671f},
{-0.1748444534964895f,-0.3759571563311831f,0.3734361794594606f},
{-0.16399441398934114f,-0.387048112745696f,0.3797794648446703f},
{-0.15673442364957102f,-0.3873433155050024f,0.3715569733992191f},
{-0.16510835601650592f,-0.39587179102423053f,0.3793853944144299f},
{-0.197708568128669f,-0.36060398869995647f,0.35448186793608066f},
{-0.18809733756358127f,-0.35855685633622086f,0.36413338394297096f},
{-0.17766447798138796f,-0.3550508914350802f,0.360455216546895f},
{-0.17820354689214352f,-0.3536322614716683f,0.34906212622451377f},
{-0.1754640199847111f,-0.36417917478205253f,0.34384629988105403f},
{-0.16101754730164541f,-0.39815722570970663f,0.3763708271231369f},
{-0.1682515989546988f,-0.40083107669105056f,0.36643843386386993f},
{0.37163496847508537f,-0.014825067549920542f,0.23268120753392965f},
{-0.26293904362035f,-0.008681401155628488f,0.24792545711632596f},
{0.22754284931206165f,-0.8692320524682168f,0.13913056366191456f},
{0.23113819776960357f,-0.8758761543756084f,0.14281934876165817f},
{0.24772377121101113f,-0.8640197108223786f,0.12114758291553662f},
{0.26257650332913807f,-0.8577158800760629f,0.09601610834197731f},
{0.27072616565670615f,-0.8702859333945765f,0.0909579496921843f},
{0.22687203545823897f,-0.8993651645335918f,0.16702259869275743f},
{0.2193136307003484f,-0.8930384750208048f,0.16168573647696993f},
{0.20776740704083976f,-0.9000139313005112f,0.15918199929680393f},
{0.19240005414051456f,-0.8991091922451313f,0.16675721347108732f},
{0.2288005638011272f,-0.84880336538115f,0.14069630842220196f},
{0.255200086904534f,-0.8338746031104043f,0.1136825584922339f},
{0.2692497842670715f,-0.8396013211846441f,0.09300603928535801f},
{0.2951959258993479f,-0.8825048545569577f,0.0348611343934094f},
{0.28464907314620896f,-0.8799623129314784f,0.059642253430946285f},
{0.1508953729477949f,-0.4021432002713641f,0.24084744661057986f},
{0.16125002231654015f,-0.39668509926335677f,0.23921677598411886f},
{-0.42829362539605426f,-0.4541719381328123f,0.10863482525029468f},
{-0.4436647880907913f,-0.5239890682507081f,0.0765438931962617f},
{-0.4321926280670426f,-0.5392989523252882f,0.10751305540237509f},
{-0.4525720343053671f,-0.5983341092796999f,0.07488151075903657f},
{-0.451668997227301f,-0.611441559279074f,0.09126696800267085f},
{-0.434944697761097f,-0.567619668908053f,0.11811760964856974f},
{-0.439071628341547f,-0.6051215161895555f,0.11021395953622985f},
{-0.45752183692006204f,-0.663330720127069f,0.09169788273581245f},
{-0.4700076327998649f,-0.7027860007153757f,0.08010560476008505f},
{-0.4696988939026327f,-0.7191630585628526f,0.07366225649515352f},
{-0.4732363485713049f,-0.7560954116986949f,0.06646934445978302f},
{-0.479003877979214f,-0.7807099558154736f,0.07764121279080849f},
{-0.4728489043785846f,-0.8012824355501894f,0.08359326118741095f},
{-0.4611224751060971f,-0.8182268807886364f,0.08777038947454434f},
{-0.41258089752752675f,-0.780170128345541f,0.08461173418623064f},
{-0.060327368887522936f,-0.7475923882834057f,0.20909730204781937f},
{-0.0430537185277641f,-0.7538325106828997f,0.1908470970518497f},
{-0.30133280457013245f,-0.8867806837169986f,0.14605408307335013f},
{-0.3045415800093593f,-0.9068781789801458f,0.17869880476077415f},
{-0.2904730578428108f,-0.8957664716162596f,0.16954449136001334f},
{-0.28539688925579804f,-0.8857399330887805f,0.15921554588585846f},
{-0.2783350496593501f,-0.9054728418632709f,0.20818972530117494f},
{-0.30389577204819485f,-0.9096739380706307f,0.200362866025447f},
{-0.32070015369041066f,-0.9224289587139344f,0.17629212065900016f},
{-0.3135361635828913f,-0.9078296055468001f,0.14691793005206727f},
{-0.3017534001362014f,-0.8641853880085358f,0.12413914057844914f},
{-0.2907979878350895f,-0.8659775201869583f,0.13404813430566886f},
{0.33777209742790226f,-0.3349337798741023f,0.25056050365235644f},
{0.34145216972118414f,-0.34452780793190696f,0.2246673931683966f},
{0.35919399558084786f,-0.33140884780630364f,0.22329895772444475f},
{0.3659677048667901f,-0.31869176043390807f,0.23100506585313837f},
{0.36488914314456244f,-0.3117694766027572f,0.246458701141463f},
{0.36466656445843154f,-0.3062632293975504f,0.2551960959695903f},
{0.36780534953344757f,-0.29502118584335496f,0.2549004873704999f},
{0.4944567833933722f,0.2491732072825278f,0.04858728395623079f},
{0.47840504119220956f,0.2250888450351616f,0.06718291491597773f},
{0.466160545748991f,0.25243398014727075f,0.06983631560935893f},
{0.44484527615604236f,0.25164190731547975f,0.07250169176359085f},
{0.4402355003486268f,0.24825525612360455f,0.07955129985890548f},
{0.4232546208966941f,0.2633380229058832f,0.08223218397996122f},
{0.43516747724230437f,0.25490081671692144f,0.09332072660392647f},
{-0.36879965594178005f,-0.7496388725783764f,8.523007306222114e-05f},
{-0.35648042754588044f,-0.7462491404038478f,-0.020288684579284864f},
{-0.343282519895808f,-0.7365740570044761f,-0.023788737180954818f},
{-0.3317692659379122f,-0.7451078817470349f,-0.019034029824716338f},
{-0.3303628345409915f,-0.7529994246599554f,-0.04030511387678683f},
{-0.3241567155659109f,-0.7748973197591139f,-0.037617959424827915f},
{-0.314919250692971f,-0.7781729259617203f,-0.0607060912433151f},
{-0.30950726987046684f,-0.7919962560918711f,-0.0672973649222823f},
{-0.3862652451463874f,-0.9687809095434654f,0.07337206086386253f},
{-0.4031776736630281f,-0.9507556736512024f,0.08153661496172379f},
{-0.3914301694067847f,-0.9831273703423842f,0.05362081493054647f},
{-0.38288361914346025f,-0.9976780907295411f,0.039194498248479676f},
{-0.4070480635668383f,-0.9950732983807574f,0.03448369383264175f},
{-0.3951688441149464f,-0.944146263608486f,0.1040334329029194f},
{-0.3779937161435829f,-0.9711918177786978f,0.08509412682746846f},
{-0.45814798927430683f,-0.7980360094405324f,0.0421684156920908f},
{-0.4651205260573473f,-0.8032407314975469f,0.07214966930971224f},
{-0.4698036983084171f,-0.7900517395738281f,0.07035445933586f},
{-0.15086267734739733f,-0.549875208277017f,-0.30406740562374707f},
{-0.1057359132669683f,-0.6036965648996654f,-0.3129691815005017f},
{-0.08516503033119324f,-0.6113117086091344f,-0.31750872258990964f},
{0.4238575097070914f,0.17520612739413124f,0.17694983396209985f},
{0.4280592539832163f,0.1408787280930599f,0.17404284714820253f},
{0.4228396582168414f,0.09184862990499534f,0.17262872604354249f},
{0.42184174599639684f,0.1072498640528356f,0.1867747370486351f},
{0.41793115245618545f,0.14556972179043765f,0.18880238591551643f},
{0.40971376800508397f,0.16005178832241054f,0.1983303332698564f},
{0.3932675293481487f,0.15361429604933574f,0.21460792637320933f},
{0.3847779209562947f,0.1872827964001898f,0.2088116630836317f},
{0.3628312305287641f,0.22143552204575642f,0.20374329681958622f},
{0.3756856256115275f,-0.9745935455998255f,-0.14409386204303842f},
{0.37558491466304067f,-0.9768549879296954f,-0.1587434086672246f},
{0.3593935136430233f,-0.9726621604423322f,-0.1458959234848667f},
{0.353295197188571f,-0.9687646982626703f,-0.14973194555838423f},
{0.35898053660337037f,-0.9675367110065772f,-0.1568215883672579f},
{0.380965769061485f,-0.9609616677317456f,-0.16584395284265166f},
{0.3834714313246053f,-0.9513177107564339f,-0.16711518328389446f},
{-0.4526695431567102f,-0.12108805726826868f,-0.09094422019603689f},
{-0.47741604576052643f,-0.08398175928868025f,-0.08013603530702855f},
{-0.4555945855913632f,-0.09196797442408731f,-0.09703388333886488f},
{-0.4116218513720486f,-0.05674937220556171f,-0.13802638728735267f},
{0.3241736960299614f,-0.4084314688680576f,0.14264945700371284f},
{0.3245182210719146f,-0.43190345819049364f,0.14682601265303585f},
{0.317428436962802f,-0.4130336261490571f,0.15374900511019698f},
{0.3095335315291582f,-0.40071597861598096f,0.15493788407234274f},
{0.2787985027565332f,-0.49712442938189333f,0.12905453074172327f},
{0.2780396227319956f,-0.4616126514781656f,0.13898343824096088f},
{0.2858592682586837f,-0.47922580169092927f,0.1386077368417806f},
{0.28643386939869325f,-0.5224337797081011f,0.1257061772266353f},
{0.27682602154007724f,-0.5312666977473718f,0.11792551887940407f},
{0.2793884227547761f,-0.557977494653049f,0.11012419563783225f},
{0.28675233570184705f,-0.5656070658605976f,0.10801019745125932f},
{0.2923413200401866f,-0.5739859129260684f,0.11010439341863454f},
{0.29271006160579405f,-0.5655331435250767f,0.13233153507300957f},
{0.3038907256110905f,-0.5837384841015762f,0.11289432626468139f},
{-0.16467159060354664f,-0.7914170345402893f,-0.22516262075840462f},
{-0.15875833390336375f,-0.7810842697100523f,-0.23345637958225596f},
{-0.1432983050448298f,-0.811834536597917f,-0.22881586300481602f},
{-0.12912503902974215f,-0.7965483208445605f,-0.24089474181912243f},
{-0.16854248621347512f,-0.7820279152018955f,-0.2421420404620044f},
{-0.367480136940691f,-0.7094938109695891f,-0.22200861775389727f},
{-0.3653447556720969f,-0.7217068973882697f,-0.22356418995938998f},
{-0.363015470104203f,-0.7153113107289099f,-0.23074501923072083f},
{-0.3577628844504669f,-0.693215316944412f,-0.22772477761930685f},
{-0.36487520222926045f,-0.6871522193089094f,-0.21257876782482796f},
{-0.37013354188370334f,-0.6882185824646461f,-0.20378098679910542f},
{-0.36226524232888185f,-0.6353651887862374f,-0.21152067232668006f},
{-0.3643640672070916f,-0.5990021672476598f,-0.2264838013653108f},
{-0.36972664394154753f,-0.5758887671217849f,-0.2389007415324455f},
{-0.3838523916424523f,-0.6001255933893574f,-0.24021762682456999f},
{-0.39712786887406243f,-0.6425327453967797f,-0.23350886252814182f},
{0.08895058484644318f,-0.09359653723345046f,0.3822421473997782f},
{0.06392408678873374f,-0.09690602362116416f,0.38586276522711543f},
{0.05855765988836905f,-0.08447246739585831f,0.37720208899186897f},
{0.07880018337945013f,-0.08354211581295974f,0.37665032537017434f},
{0.25296095513870465f,-0.009071438685816544f,0.3052181887665897f},
{0.24626826082283246f,-0.042175875919742874f,0.3185066762442589f},
{0.15644772015275626f,-0.09179727204898189f,0.3662650977797999f},
{-0.07722361799560302f,0.8411584434431337f,0.18559147184936509f},
{0.29280323370845074f,-0.5123749811674272f,0.1700089186851595f},
{0.28812212996538983f,-0.5314957603083761f,0.16789564506071397f},
{0.2862760147212518f,-0.5222056903126521f,0.15783478969851714f},
{0.2933572878813868f,-0.5046353360113494f,0.1597400746833064f},
{-0.09430997117024137f,-0.4944295034167936f,0.23050465052578703f},
{0.34203171530714827f,-0.4410704864879419f,0.18766480531454674f},
{0.32734510552405166f,-0.4304065287713776f,0.16562698898180417f},
{0.33127486808840495f,-0.44584691158466205f,0.1601415724065566f},
{0.45549873622102166f,0.22968613861320025f,0.07761772932854409f},
{0.4500931595928047f,0.23431536817005127f,0.09473392978823744f},
{-0.41871422881862896f,-0.48569125760000936f,0.1439665239675731f},
{-0.41800313058541155f,-0.4320180696827855f,0.13905502009207324f},
{-0.4114717363355135f,-0.401063868303473f,0.16632725596738385f},
{-0.4093058182791948f,-0.40543080212056964f,0.16933810483133677f},
{-0.40381253882373463f,-0.42074295549823504f,0.16369957510471014f},
{-0.41505421797205083f,-0.5084525534666041f,0.138614879409497f},
{-0.4172240276281829f,-0.5539004133095202f,0.12115677274310571f},
{-0.08631064486003309f,-0.6265667990008388f,-0.33274233322048213f},
{-0.05146782053405015f,-0.6421508119133774f,-0.341077126483643f},
{-0.11197012336699161f,-0.6042555220846513f,-0.3123930802406623f},
{0.44632238741984337f,-0.028825259895667588f,0.09830168007806109f},
{0.4472508755394407f,0.022174400012187068f,0.11579140931296031f},
{0.4490877499604347f,-0.0692951898770805f,0.09390260736226015f},
{0.4511879729673243f,0.01391000401542873f,0.12222620094537838f},
{0.3132916992958445f,0.4201589223016753f,-0.2420844303360205f},
{0.3395086667401934f,0.4341774337453153f,-0.21433422249837555f},
{0.307919760623754f,0.4331514357119671f,-0.23967633960630416f},
{0.2609260761670152f,0.42534905431221504f,-0.2673712480549551f},
{0.26752107783499285f,0.4128072079210955f,-0.27205632414082304f},
{0.28447583692847317f,0.40390587931802946f,-0.26564941008937754f},
{0.259801413382625f,0.38945210045644435f,-0.2897588993438925f},
{0.28393540069886436f,0.3831399202471385f,-0.2739485191989673f},
{0.35563108880823663f,0.39035019308855606f,-0.21156733965220603f},
{0.3056757651549637f,0.11158867168553176f,-0.195726198551508f},
{0.2955647067740444f,0.16360760246047254f,-0.20467423591400458f},
{0.2971761669424587f,0.15414577618109404f,-0.21297636438659454f},
{0.3089312695393696f,0.09702717104631209f,-0.2116634100033724f},
{0.31488427410300235f,0.01960794677409528f,-0.21071101027116274f},
{0.05573693102709156f,0.2756072798879632f,-0.29380138975148806f},
{0.030638490962021644f,0.26480747420936374f,-0.29756223372345136f},
{0.030648253427401094f,0.2152976914575728f,-0.2969584524904924f},
{0.03188112988424256f,0.23819661906891795f,-0.3000498201800676f},
{0.04699591870036634f,0.20746313078761958f,-0.3031401339610939f},
{0.10175664993545587f,0.3305320426395101f,-0.2926348627872875f},
{0.06951138933550763f,0.34450256937193796f,-0.2991028514765901f},
{0.058039939000176954f,0.38963212439768763f,-0.3033017580614505f},
{0.018130065795834732f,0.4029593961349218f,-0.30612471054227736f},
{0.013631572957037886f,0.40845502563646086f,-0.31088828900374144f},
{-0.023396772974200602f,0.42430327849504884f,-0.329481803647128f},
{-0.04879169068795073f,0.4369682483898456f,-0.3320581457771288f},
{-0.07013106312691812f,0.4564439684189312f,-0.33550911513790954f},
{-0.11200599025470634f,0.47934512496186493f,-0.32600915266773106f},
{-0.15264550920783826f,0.501522539556217f,-0.31099495793523496f},
{-0.17767638332332314f,0.5045114539484946f,-0.2934797627850952f},
{-0.16819161859688758f,0.49453492614392414f,-0.2939232967982212f},
{-0.2149660688272858f,0.5217641918728927f,-0.2609605443948461f},
{-0.2334628448649925f,0.5395983813428685f,-0.251296039390053f},
{-0.27126595487995775f,0.5662008870203242f,-0.20883273700497973f},
{-0.2903880514065929f,0.5833809998091389f,-0.18299247493519286f},
{-0.30417549446328057f,0.5741272832839073f,-0.17776098445096103f},
{-0.3331070424172411f,0.5741475465880951f,-0.15186045729806943f},
{-0.3789474120133226f,0.5514149038601753f,-0.11849874101407439f},
{-0.34014290508029116f,0.3355911075231663f,-0.19505254806882869f},
{-0.3265235296273366f,0.25882567520681715f,-0.20190030186719038f},
{-0.3246726526713876f,0.13008354282603254f,-0.21020372647731034f},
{-0.31458759247202234f,0.09142819688732155f,-0.21932461334109932f},
{-0.33820979669732776f,-0.7211528039062445f,-0.01020090886555357f},
{-0.3812316716757592f,-0.7596041324856985f,0.008913548948917207f},
{-0.38440851219858163f,-0.7385471055467032f,0.023343240900600987f},
{-0.2578160865933207f,-0.19698538766261584f,-0.25153361290003484f},
{-0.26382118951121164f,-0.21217968707934878f,-0.24557657649875764f},
{0.09169508594724884f,0.7944712285805418f,-0.09133134035437472f},
{0.10005289840046055f,0.7823402715977256f,-0.08822784527963172f},
{0.09143942706909262f,0.7838790651966522f,-0.0987115761350609f},
{0.08181246118190943f,0.810774829427119f,-0.09451991304665897f},
{0.07357039487253222f,0.8136861731754511f,-0.09970646899250532f},
{0.07684684250212533f,0.8024677575709825f,-0.10612593539224319f},
{0.0881876007405299f,0.7882935385760879f,-0.10656737327475724f},
{0.11168023902118943f,0.7620132271907966f,-0.08669851454708193f},
{0.09980051280077137f,0.7786280210966504f,-0.07781789439707683f},
{0.08604134785280124f,0.7903343081794406f,-0.08691852858075605f},
{0.08658280718113257f,0.8026151156592468f,-0.08540999873074671f},
{0.07645946842832062f,0.8121599839827999f,-0.0809211568045091f},
{0.07922167030567281f,0.8218318036653747f,-0.08758131806837885f},
{0.07023123118501333f,0.8262262772177599f,-0.08593347361964568f},
{0.0675066289825162f,0.8305860376573135f,-0.09290873654113035f},
{0.07194039356299238f,0.8183527697398466f,-0.1066255709122609f},
{0.07885920119578417f,0.8049213416655931f,-0.11078091027758917f},
{0.09151542641188495f,0.7985097062738334f,-0.11376733119873329f},
{-0.2527060580069491f,-0.5695758570383125f,0.26264621162407487f},
{-0.25748671892361363f,-0.5749469043502492f,0.2552611429502544f},
{-0.24535574175504912f,-0.6163544825314099f,0.2522656033828645f},
{-0.2410161638766896f,-0.6239091582378821f,0.2639760859141022f},
{-0.2534369531473252f,-0.6089583499426409f,0.2444934549222031f},
{-0.25660702613238856f,-0.5996441250429155f,0.25091601186626444f},
{-0.26713529631049737f,-0.5685021983281346f,0.24641541758481655f},
{-0.2535364285155273f,-0.5412061836411881f,0.2652073560103328f},
{-0.24190690039711465f,-0.6034822549335309f,0.2645511523887332f},
{-0.23819114395026167f,-0.6093764329142357f,0.27076053401820277f},
{-0.2323716989222381f,-0.6260428577149106f,0.2726682519168802f},
{-0.2274977830351075f,-0.6223039397153601f,0.2782643076416127f},
{-0.2231148408571079f,-0.6143084848192168f,0.2766823930344349f},
{-0.21112092810752262f,-0.6173540563576715f,0.2849570019574848f},
{-0.2111491148491683f,-0.6074473170598277f,0.2924260040356336f},
{-0.20370230328297734f,-0.6089528381709151f,0.30146865306337145f},
{-0.19939893651246346f,-0.5970156643729082f,0.2987098551406471f},
{-0.22060297838199994f,-0.5945520702718982f,0.29280822011951374f},
{-0.22139938690006936f,-0.61066229377345f,0.28964436859459425f},
{-0.24109596238981576f,-0.55681224364063f,0.2748334815329371f},
{-0.2332156459402389f,-0.6052961101644742f,0.27683082521699676f},
{-0.24006964032208508f,-0.8880910235145967f,-0.18642743593507063f},
{-0.2553767685108023f,-0.8632696254097041f,-0.16377898796380078f},
{-0.24199073181029312f,-0.8590865242658547f,-0.1766655623167655f},
{0.2628793862345134f,-0.770342823154944f,-0.28558591019759255f},
{0.24148676910325936f,-0.7577599635726711f,-0.32150798999810404f},
{0.18748413277333467f,-0.7449817601285137f,-0.32243352037435424f},
{0.1953695551548535f,-0.7732353622850133f,-0.3256961173933094f},
{0.38286752897715576f,-0.5568198632294536f,-0.08744906635678555f},
{0.39821096920246085f,-0.5482682059717796f,-0.08014205384728045f},
{0.4086606573243875f,-0.5317867484958945f,-0.07450094990652668f},
{0.40776807646400187f,-0.5344972376730242f,-0.09011234000595861f},
{0.4326169516221219f,-0.5254540616910118f,-0.09199442306655349f},
{0.4225006438842063f,-0.5383909718636755f,-0.1241965828439989f},
{-0.21922599055516584f,-0.7067413364981585f,0.20904301513346968f},
{-0.2351885521198194f,-0.7592071244978594f,0.1952098364829067f},
{-0.21378377679357105f,-0.7623442883385552f,0.2128996861652106f},
{-0.20962936915989344f,-0.7456464130794377f,0.21428582238570912f},
{-0.24897492108220962f,-0.7351635332126656f,0.17631699481308974f},
{-0.24613792569493095f,-0.693095031131999f,0.18336553200133046f},
{0.21158040992430646f,-0.9410073159850748f,-0.2202553112689444f},
{0.18056012677912153f,-0.9375117265586208f,-0.2266953150740855f},
{0.005238939025397937f,0.49151521148678473f,-0.3154559169684609f},
{0.022810719077983606f,0.47082544511690777f,-0.3241259955128388f},
{-0.019464321455676423f,0.49712107642284037f,-0.31754544046628136f},
{-0.060850314697331744f,0.5307807417903343f,-0.3038954878541053f},
{-7.198237885721104e-05f,0.4721245988226591f,-0.32348659068355395f},
{0.08099567674442407f,0.4432826979022368f,-0.3232999606905391f},
{0.09152672405655206f,0.45047209867979054f,-0.3140265471244831f},
{0.05884398729281852f,0.47260679704326736f,-0.31420199102565105f},
{0.012157367378601026f,0.5180333386110388f,-0.30927322196080725f},
{-0.031927932135560534f,0.5399409611161189f,-0.30405784182862833f},
{-0.07071632234209223f,0.564360243176415f,-0.2919632181305562f},
{-0.2034895125600133f,0.535689773442857f,0.10835822418935905f},
{-0.22386717538711917f,0.5315447681183106f,0.1089110714670213f},
{-0.033379614668394536f,0.6869006740737991f,0.19982703958333206f},
{-0.10445514346598647f,0.9931263096397371f,-0.04306844084401143f},
{-0.11952279430992373f,0.9958458260960408f,-0.008001103187272898f},
{-0.1657841854976065f,0.9820939662641823f,-0.011294425040135343f},
{-0.14157374200321587f,0.9851939660172255f,-0.04631337745791681f},
{-0.0871183807701882f,0.9870299692638143f,-0.0669591612068073f},
{-0.07176029950283361f,0.9948709936228922f,-0.03763271201969777f},
{-0.0500857416489836f,0.9889808889137367f,-0.050359910327234955f},
{-0.05454784595783027f,0.9775179898988803f,-0.08360139179439204f},
{-0.29365674770879363f,-0.9649074397194097f,0.24228852843827123f},
{-0.30571973927668755f,-0.9637585614737731f,0.24342824660375753f},
{-0.213141048752652f,-0.6170935444006325f,0.29131793712366616f},
{-0.21559467321875941f,-0.6188263442900087f,0.28774400680760326f},
{-0.22564483969596524f,-0.6080054636276535f,0.2794498230206274f},
{-0.15499682167688708f,-0.88612040682385f,-0.22451608292307365f},
{-0.18399569653867523f,-0.8800033271850395f,-0.2157290619636655f},
{-0.15899536983499302f,-0.8650003185443902f,-0.21997376576205427f},
{-0.13945012371391025f,-0.8858200163272001f,-0.22725216550438132f},
{-0.14349257375000896f,-0.8420068791341379f,-0.22524128461998816f},
{-0.174124278050931f,-0.84903842523425f,-0.21685633827127188f},
{-0.2079611700399006f,-0.8610052657079839f,-0.20257670823573262f},
{-0.21112463697319242f,-0.8940130843883131f,-0.20807140494321325f},
{-0.17529362145823968f,-0.896803817227442f,-0.2235683641596812f},
{-0.1751244085788859f,-0.9117380912699136f,-0.22430847993745293f},
{-0.147881819193554f,-0.8933421079860951f,-0.2246031971763895f},
{-0.13504928846355008f,-0.8990905491128559f,-0.2343672582923784f},
{-0.11931578945990089f,-0.8469149386835131f,-0.23250685791280748f},
{-0.12484874453507983f,-0.8310503130581429f,-0.22844485319853108f},
{-0.23088502280091042f,-0.9021009422038576f,-0.2033715157052302f},
{-0.20750347094342442f,-0.9071273422969429f,-0.2176650877184792f},
{-0.18811517964036684f,-0.9171723614083023f,-0.22285398414873417f},
{-0.16441950779008369f,-0.9092026826504803f,-0.2280893449846231f},
{-0.20914646231327486f,-0.9190003201029423f,-0.2168248888752372f},
{-0.2382130083030214f,-0.911359562803547f,-0.19804174612399197f},
{-0.2556817794190241f,-0.9031089462361032f,-0.1862791652384962f},
{-0.48237419677580384f,-0.31087187055342325f,-0.04358014319195166f},
{-0.48153519420375757f,-0.3060803688274507f,-0.015572087916058878f},
{-0.4757550200180765f,-0.2980387119404028f,-0.007241620777506177f},
{-0.4675463898073415f,-0.30478105257330423f,-0.032556360698541405f},
{-0.4598847604440822f,-0.2996964548427154f,-0.00808970162430134f},
{-0.46170477551551625f,-0.29112048119505274f,0.00527309171810885f},
{-0.4736867329899993f,-0.2903128462136396f,0.012389513578278055f},
{-0.47786233565951536f,-0.30758848327600574f,-0.0036631316695243375f},
{-0.48223243120225895f,-0.3198224810676392f,-0.040790371831892144f},
{-0.48051876102793584f,-0.3203973254990376f,-0.06733548092733387f},
{-0.4795363705856166f,-0.3056600165527706f,-0.07961252960830308f},
{-0.4757261235880128f,-0.3017170004509693f,-0.07085127416313833f},
{-0.4694137818927195f,-0.3031808592397304f,-0.0571094455858355f},
{-0.44697873340408967f,-0.30450076389485503f,-0.051826991398888196f},
{-0.4528349366799818f,-0.3036470894709326f,-0.036323567430887556f},
{-0.4622696906835088f,-0.28089065624489085f,0.01096514342546091f},
{-0.45319348444263835f,-0.255130638899511f,0.04330910808554022f},
{-0.45644116738073637f,-0.25824980767669636f,0.05029962718319738f},
{-0.46430571876079907f,-0.2797189213575985f,0.03598429280833857f},
{-0.4688881386294774f,-0.3297449450635004f,-0.07068699510566093f},
{-0.47637310763462454f,-0.3131856747146886f,-0.08583485030250834f},
{-0.4654854780142913f,-0.28370003221629514f,-0.09842484289082742f},
{-0.4547596350427098f,-0.28216290022318585f,-0.09239135137380663f},
{-0.44794973483467015f,-0.2963973428672805f,-0.07421713509655127f},
{-0.285769115519027f,-0.5131185827052283f,0.23313850185302967f},
{-0.2942437896442754f,-0.5222904736432296f,0.22256425172724895f},
{-0.28458268965651795f,-0.5714154873451696f,0.21964990986407296f},
{-0.28899367727592434f,-0.5859869576192919f,0.21541783065770767f},
{-0.2925147591778142f,-0.5768241449560395f,0.20878231088061683f},
{-0.29524409334470353f,-0.5382988929786567f,0.2146893663064042f},
{-0.2992466839645321f,-0.46853704206400654f,0.22998271506580686f},
{-0.2989707724062661f,-0.5627480839436608f,0.2055682457128967f},
{-0.3039628450405554f,-0.579886413295659f,0.19008302928996876f},
{-0.29561569172491603f,-0.586500361944546f,0.1767752410495888f},
{-0.3092077707339709f,-0.5864209278372992f,0.1810980509454601f},
{-0.30553523728651905f,-0.5913466573533944f,0.17490427183710958f},
{-0.3050202924699383f,-0.5868915351886846f,0.16698500857957255f},
{-0.29256250059763755f,-0.5903991213241456f,0.1645736148239704f},
{0.20013842228240306f,-0.932375739099784f,0.1779119802235718f},
{0.20628496673945632f,-0.9146259292454172f,0.17440430272103905f},
{0.19098809184852739f,-0.9399255521657033f,0.17894326692300544f},
{0.18531156723133974f,-0.9326894235053783f,0.17731808894492962f},
{0.17101728552967269f,-0.9293089310915861f,0.19157736430920924f},
{0.21009122120850468f,-0.9273734939107001f,0.1892866303335696f},
{0.20230470580700893f,-0.9365077756121758f,0.19149095974431146f},
{0.195663258856738f,-0.968361042789155f,0.20002079195831485f},
{0.19544157259316863f,-0.9546724270319046f,0.18642968505240745f},
{0.18904240030744518f,-0.9746488258654787f,0.19805303314458084f},
{0.17971660472424525f,-0.9496317609267273f,0.18894005803176378f},
{0.1676031158506651f,-0.9636969598816416f,0.20385049164294639f},
{0.1606012162405316f,-0.9575391900236525f,0.21200485618748796f},
{0.4301940881117873f,-0.6158037930040126f,-0.006186301350969628f},
{0.4448546380936767f,-0.6107164383251531f,0.010528118784995637f},
{0.4238871763828184f,-0.6330389013331873f,0.049234544228873564f},
{0.43789320453467373f,-0.6248130877385099f,0.07190278167044736f},
{0.4562187916144973f,-0.5956832774884069f,0.011987679071751594f},
{0.4472304082529531f,-0.6014646266971273f,-0.007448144356790455f},
{0.44085196566844687f,-0.5756276060335732f,-0.0033671172306499997f},
{0.45525958291062424f,-0.5880253368050689f,0.007787905562117048f},
{0.30900134277138974f,-0.1643222969441318f,0.2425481894066532f},
{0.3098728688337681f,-0.14981275335893127f,0.23708011876374324f},
{0.3028303406241089f,-0.1500838830196379f,0.24812710318134784f},
{0.30776632343799254f,-0.1397869436432109f,0.2530844032079682f},
{-0.0865745862694874f,-0.7904288093542696f,-0.3646604455206414f},
{-0.06821470572791785f,-0.7890926934183501f,-0.33903716855985816f},
{-0.049586553402654464f,-0.791159765051891f,-0.33754923667249737f},
{-0.0713769285816625f,-0.7670910478219561f,-0.33033085765947845f},
{0.3347565165995572f,0.017309624019458476f,0.2568948329397156f},
{0.34156467445878597f,0.009274938652469379f,0.25605657936517634f},
{0.35728907500193785f,0.019155091194831553f,0.25821820210671337f},
{0.36198906516866297f,0.032225580026445f,0.2630280633020757f},
{0.36368551264995475f,0.03386702984256104f,0.2710627082975679f},
{0.36124890901939444f,0.034334313982312126f,0.2783278555648549f},
{0.35463062362182096f,0.03453922163931521f,0.2842852563720114f},
{0.3409683502662556f,0.045117260311351555f,0.28156714866846577f},
{0.34398964578621843f,0.054758299914813055f,0.288813288397598f},
{0.34025644247828574f,0.07325941163879834f,0.2889475565592174f},
{0.34324997621972764f,0.08180839375360323f,0.28433688939164814f},
{0.35724765597100044f,0.09413268664753996f,0.28504300174500646f},
{0.3585520781570889f,0.1150442210863877f,0.27667088290820563f},
{0.34253644613502965f,0.12328081599553592f,0.24930467387474847f},
{0.3321930221672203f,0.11208189344959173f,0.2468202480813713f},
{0.32572096020636865f,0.09980817860433489f,0.25926405760446547f},
{0.3221356823124716f,0.09847635904560481f,0.27099952584261294f},
{0.3302725787477772f,0.08413257232714741f,0.2776861208752394f},
{0.32751284909340217f,0.06605740645496957f,0.2762869244755147f},
{0.3264424328518649f,0.059460884481413796f,0.26753660120672984f},
{0.33209409393904105f,0.0451451432043632f,0.2698303237355431f},
{0.32955398310263434f,0.034722730278179945f,0.27352899772719574f},
{0.3283113250570727f,0.02292432393887413f,0.26620751734811426f},
{0.33351089974824066f,0.009995114098027884f,0.2616622403189322f},
{0.35276505569065514f,-0.010094924124690681f,0.2530651523784247f},
{0.35079646607401277f,0.008546737778303117f,0.25913031639712053f},
{0.35840759706917796f,0.007935418761921872f,0.2671965743994504f},
{0.36384207012745834f,0.018135902133146958f,0.2690728418396854f},
{0.3597700554067825f,0.019457265474196708f,0.2802919065753268f},
{0.3458196708640521f,0.02258056808017648f,0.28689270367791603f},
{0.34166040058982144f,0.03394743711536314f,0.2865513998564471f},
{0.33357513611174466f,0.05488855536212866f,0.28435115434133257f},
{0.3325466254839224f,0.07160045334194953f,0.28436347508472193f},
{0.3279253395502776f,0.09472114902226561f,0.2854965871984366f},
{0.338776291665736f,0.09816648443442222f,0.29133183872987906f},
{0.34887407738586673f,0.09401126618358445f,0.28977954830211594f},
{0.10827828809442132f,-0.556813702326555f,0.19216144850134387f},
{0.26408777844093223f,-0.7856525457435367f,0.10012245477108035f},
{0.2565535285870429f,-0.7679628777329687f,0.11379753545281293f},
{0.22814227361058587f,0.3863886974652823f,-0.305626706880658f},
{0.26530966747618756f,0.37763059312168634f,-0.28269272299875825f},
{0.22746716444198145f,0.37812997472623716f,-0.30285165836804967f},
{0.19978901335174062f,0.37501550604120965f,-0.30872613930793f},
{0.2144778318806772f,0.37153515472999527f,-0.29526808516910574f},
{0.24368936572686073f,0.3736288120566101f,-0.28786842644881055f},
{0.2530930347402325f,0.37174103449014584f,-0.2717953670349111f},
{0.22426989806657605f,0.3981331218012803f,-0.29752632540183205f},
{0.03882295245745388f,0.6844459967615505f,0.18504570658217398f},
{0.05233605844425214f,0.6956677759491502f,0.1648873385386539f},
{0.025999798538793965f,0.6954707715438565f,0.18887544770071016f},
{0.0007599105601147657f,0.7053516943318819f,0.1911652998778663f},
{-0.012930813014233612f,0.710266967630297f,0.1960887494667981f},
{0.4427881337859072f,-0.13764959692016565f,0.06862503259128523f},
{0.4393932138740353f,-0.19270380450186805f,0.05204312658164269f},
{-0.37719102560812434f,-0.49442755814809086f,-0.25333800420219366f},
{-0.37249897800219767f,-0.5447800725233464f,-0.24667684108775773f},
{-0.3909817716906978f,-0.4971602558981112f,-0.24729081399885203f},
{-0.3942826663864403f,-0.5802745055571443f,-0.24205906003748295f},
{-0.4104805927152356f,-0.5256432446499976f,-0.23070236461949875f},
{-0.44062116182103944f,-0.551895753885271f,-0.1949361931653182f},
{0.023483183913545348f,0.17554080391567226f,-0.3031696380884258f},
{0.043487759927094936f,0.14261639168539694f,-0.3045153178194641f},
{0.030617274678026836f,0.11900831004712921f,-0.31669772402536556f},
{-0.0024700970992240054f,0.13642133556285704f,-0.32193259827847687f},
{0.035319383285928097f,0.07490815700935564f,-0.3259150063371112f},
{0.0619389416711652f,0.08335906188463825f,-0.3128555006774526f},
{0.06202599536723582f,0.09818447843552482f,-0.32043741227057937f},
{0.04887392423978075f,0.14032917321720537f,-0.3124119666643266f},
{-0.23496327916747856f,0.8895558841539238f,-0.09323031357435609f},
{-0.23128618586570002f,0.9093563323178041f,-0.07456407180423645f},
{-0.21012885169318632f,0.9274169495774118f,-0.09011275540741287f},
{-0.2234082810818551f,0.9312708041660445f,-0.04829342620521371f},
{-0.2403782581048267f,0.916679190639817f,-0.016930046956581995f},
{-0.24855898523680173f,0.8947139388854123f,-0.042913342052432794f},
{-0.24915808550094348f,0.8817689639750519f,-0.06534348646660496f},
{-0.24066069497187065f,0.8640170059320904f,-0.1010707408602441f},
{-0.40670888774821584f,-0.37201754524641756f,0.17818739669979766f},
{-0.20883251443054318f,-0.3009933392453814f,0.3402968888748717f},
{-0.19748261736014447f,-0.32395662539712894f,0.3628825995400595f},
{-0.22156269279199153f,-0.30940558097558957f,0.34192237176398943f},
{-0.01594923472106663f,-0.35536862786406753f,0.29282467362928977f},
{-0.014894878898415032f,-0.3589861253996625f,0.28675397765311966f},
{-0.002578384077814376f,-0.3537175313850235f,0.2760243047013779f},
{0.007928718687059001f,-0.34617258095965714f,0.28122294766089506f},
{0.01763403715033698f,-0.346829453898178f,0.2780023168129002f},
{0.018550088724093305f,-0.3586285093686566f,0.27270168695311453f},
{0.012289371549174337f,-0.37943102376752413f,0.27275408915600674f},
{-0.10686531757742107f,0.7433377254741922f,0.20903651001044013f},
{-0.12973206166893392f,0.7437439339136783f,0.2087866678150516f},
{-0.13256609931286548f,0.7352688751968023f,0.20628120847182324f},
{-0.1274427566318006f,0.7061804839776368f,0.20737645743354552f},
{-0.15065639174746281f,0.6724557312579819f,0.19636989975798239f},
{-0.16546170648014882f,0.6706969533728f,0.18296473440482794f},
{-0.18730331946308756f,0.6956571582454825f,0.16934237996037005f},
{-0.3677069089504537f,0.5243387512825858f,0.06098133985910673f},
{-0.3554240743965434f,0.5855866359814889f,0.029310360614416758f},
{-0.35749542222152547f,0.609269612058425f,-0.0022626933150680156f},
{-0.34178350390775025f,0.6239749042828862f,-0.012799388387121625f},
{-0.3363484837094468f,0.6344865998367284f,-0.04003879692346608f},
{-0.36100416425668524f,0.6188914008323431f,-0.03470077455834847f},
{-0.37253350731847773f,0.610916088125897f,-0.05672779576531887f},
{-0.37161247623930904f,0.6044707744065145f,-0.08257256669385754f},
{-0.3481210544155937f,0.604819392905765f,-0.11516621418815365f},
{-0.34984096623580907f,0.5863715343733291f,-0.12890219633527006f},
{-0.24701496352903518f,0.5587156343522912f,-0.24294084046005748f},
{-0.19927378699708972f,0.528435568976028f,-0.28311850630217045f},
{-0.1732730556642373f,0.5182881773103647f,-0.29941799350570186f},
{0.3385049994566342f,-0.1740714641650119f,0.26636506817692174f},
{0.3378557461069372f,-0.17094694510208805f,0.2544879363563793f},
{0.33204092149048564f,-0.16445003979697329f,0.26242472828039753f},
{0.34118501134087675f,-0.1662478462955167f,0.2762772374410899f},
{0.2101684263841631f,0.30646656681580814f,0.18164685576139974f},
{0.2235341179750829f,0.29867991011407347f,0.17512667841317509f},
{0.22900992932130707f,0.31321612119774933f,0.17340288561722447f},
{0.21296013238884723f,0.3207629350864168f,0.17861933984370076f},
{0.22539816666307833f,0.3241142474072597f,0.17251703192310083f},
{0.22759081383752544f,0.3321082436174778f,0.16544595150350888f},
{0.23983459959232575f,0.3221230433779425f,0.16035857770130865f},
{0.2427482328294915f,0.3026124689357866f,0.15645628262851266f},
{0.23384082512892848f,0.2852642874808309f,0.16056502478723053f},
{0.1999640726612808f,0.26016373641143953f,0.1692690653221172f},
{0.19641148080611104f,0.278134097877833f,0.1786372531018097f},
{0.1856158896992997f,0.2998901466604529f,0.18657913077202135f},
{-0.4833535880408713f,-0.07796364718713814f,-0.07190778879846278f},
{-0.47662567596845734f,-0.054214692397887135f,-0.08805822656049395f},
{-0.4802752305973551f,-0.10117163985491362f,-0.06530719355335785f},
{-0.2688828689804918f,-0.608853463731455f,0.193394603309032f},
{-0.25969006454472204f,-0.6127460632705637f,0.18742910695435214f},
{-0.25690709259465583f,-0.6088533022454676f,0.20817688822758912f},
{-0.27083838779383007f,-0.6130659075166489f,0.2155123817657037f},
{-0.2587093569563761f,-0.6148348579566254f,0.22199414988432087f},
{-0.24487374645433277f,-0.6115542265650709f,0.21867465242779982f},
{-0.2611803262924134f,-0.6354580772260084f,0.17233537718586708f},
{-0.2742110980704034f,-0.604431249648705f,0.16310992814527475f},
{-0.2890574674281475f,-0.6001687143976088f,0.18159956055285725f},
{-0.2874958968681513f,-0.6053598195737038f,0.1980380478824003f},
{-0.28070812555241653f,-0.6117589716736788f,0.21289353588639007f},
{-0.2775246789778225f,-0.6101424055733227f,0.2215612739463593f},
{-0.26836839056094025f,-0.6088845890931072f,0.22414430287112538f},
{-0.2631006475349582f,-0.6158770662083609f,0.23570596862817356f},
{-0.25297730878214625f,-0.6191447287877611f,0.23486937665945146f},
{0.2923317764308162f,-0.5514447628317164f,0.12074081139991034f},
{0.2920437863581418f,-0.5416526360885723f,0.1400071457230676f},
{0.2918965493843679f,-0.56074926032552f,0.15368865928409853f},
{0.2887035390146552f,-0.5734462469421228f,0.15052947916632597f},
{0.283439605783085f,-0.5778723515622783f,0.14355808659649844f},
{0.2743447978438438f,-0.5920742101587957f,0.1498154943710848f},
{0.26389652909875316f,-0.6136984630027734f,0.15434184354269798f},
{0.26806832303626527f,-0.6294042204136499f,0.13923807295798687f},
{0.25803815744851794f,-0.6909984543087184f,0.1254317700378303f},
{0.25899288704105816f,-0.7005292595400713f,0.11495912328309806f},
{0.3569181661243951f,0.4673812443562938f,-0.006824064760185807f},
{0.3406707963984624f,0.45993890977662033f,0.008742162383181167f},
{0.32345449268755044f,0.44654614590984903f,0.022504961828274307f},
{0.371435167812432f,0.4801570966919644f,-0.03566738399503638f},
{0.3771002832321324f,0.4654865770751722f,-0.03443162522580238f},
{0.3816818117406571f,0.44833345475680747f,-0.023711857102086727f},
{0.38564561703851274f,0.4832833984751958f,-0.08037423670002697f},
{0.38977360046510395f,0.4790143793492263f,-0.10697889056607728f},
{0.3868319834061844f,0.4772744868253009f,-0.12812027693493322f},
{0.3765656424371352f,0.47681235005139627f,-0.15427770810793612f},
{0.35385557375039317f,0.4756123274937161f,-0.18716287074402507f},
{0.3359171068289073f,0.4538837961358208f,-0.21451821772001795f},
{0.34305179572898664f,0.21347135399725273f,0.2797071328805226f},
{0.3356135142351138f,0.21055765914043395f,0.28554753071540373f},
{0.3318276250614033f,0.22423987176580476f,0.28147713722904816f},
{0.3427663193131942f,0.22612635319473906f,0.2704475593010264f},
{0.3326941864920787f,0.23361894072630218f,0.2702825514317903f},
{-0.3763027411249281f,0.5880116880519151f,-0.0973183568416834f},
{-0.39431841215966446f,0.5801926098509983f,-0.07373099640537026f},
{-0.4086655210273483f,0.5568213718485459f,-0.06641465276805716f},
{-0.3952207193635641f,0.5866027854944249f,-0.045435478011077536f},
{-0.39318254416008686f,0.5825831729766412f,-0.017270267122083155f},
{-0.38745128747967655f,0.577245926169226f,0.003338641514079559f},
{0.4315901833431105f,-0.09295733532405757f,0.0029252756331675706f},
{0.42261464874163773f,-0.0938089019308821f,0.003802984909008582f},
{0.4142358016761671f,-0.10400006373596946f,-0.014675058754166562f},
{0.44119612630452065f,-0.09630864658249265f,0.013890851989811657f},
{0.44196392311781973f,-0.07251000510471554f,0.02612104211184884f},
{0.4318066011263427f,-0.07056613665543766f,0.02857697306531498f},
{-0.037898825521922544f,-0.6395019253907871f,-0.3137136329645519f},
{-0.022842214157554133f,-0.6424053255159129f,-0.3212910048891004f},
{-0.05591639507941804f,-0.6373899489662794f,-0.31664086395929647f},
{-0.059801268788921794f,-0.6326653991181768f,-0.31518138229071857f},
{-0.08701003004712919f,-0.62434556030737f,-0.31551091250882085f},
{-0.056482022060644205f,-0.6376762359992321f,-0.32444798688511106f},
{-0.0046000494639016135f,-0.6447484723185228f,-0.338423093657614f},
{0.011166798520949237f,-0.6373325619459358f,-0.32582507564068725f},
{-0.008855852236696653f,-0.6397570881244954f,-0.31220697720192203f},
{-0.05207604900610788f,-0.6192941946931234f,-0.3200007669097028f},
{0.07719474175128775f,0.8265191299309874f,-0.11044250470462999f},
{0.07551506331489204f,0.8453458611499209f,-0.09707768322570771f},
{0.07464324296554993f,0.8375497607051503f,-0.09488483419377645f},
{0.0768683318249276f,0.8406898631658526f,-0.08042135023683374f},
{0.07231298423210081f,0.8467534261359765f,-0.10354402093327132f},
{0.07978881440525389f,0.8223620067829437f,-0.11937350954509329f},
{0.08208340810847255f,0.8146831132927483f,-0.11479219458053888f},
{0.43274311467454785f,-0.2636949398725492f,0.013557261249053975f},
{-0.1814210266385696f,-0.3359615606277581f,0.3532122587291581f},
{-0.18987395752554873f,-0.3207518616097981f,0.35470511381431724f},
{-0.1813587451054387f,-0.33364435251186486f,0.36519455936136425f},
{-0.17177210396914708f,-0.3480553333371733f,0.3646006266488174f},
{-0.17901757438135812f,-0.34852318480269573f,0.37121186084574626f},
{-0.18631509321466003f,-0.33578291569185426f,0.3680541489755691f},
{-0.19160842858241225f,-0.3245288754286518f,0.3452011184440865f},
{-0.19345415923492257f,-0.3316675759806272f,0.3319045471053799f},
{-0.18633280355287696f,-0.35246619984208916f,0.3632133865866028f},
{-0.18741033261471196f,-0.3457060277564803f,0.366736393571447f},
{-0.21143191718449938f,-0.33163547851582753f,0.34603523818983134f},
{-0.21577781745174485f,-0.3201450811995874f,0.34222628839216535f},
{-0.2562516995902164f,-0.3123976549686985f,0.31088626299204497f},
{-0.27441633082419675f,-0.30701590921010047f,0.29254231750523946f},
{0.18943180995461667f,0.297367949082155f,-0.2576351303892231f},
{-0.2374980397181468f,0.4949643566933532f,0.12109912649525618f},
{-0.2468098731378885f,0.5347957742680428f,0.10657967383239823f},
{-0.23954450382736903f,0.5388315576951247f,0.11882600192909142f},
{-0.21771400575495367f,0.5399361792185595f,0.12156287387940298f},
{0.05239250310886692f,-0.32887992306174374f,0.29215556281518884f},
{0.06074922234444062f,-0.3336793684109226f,0.29035909388807996f},
{0.07381078482562224f,-0.33762513933617894f,0.28558923340922676f},
{-0.23197835730375638f,-0.6868169743991893f,-0.3368840153333941f},
{-0.2300610554242118f,-0.7041023378050693f,-0.34109759377013066f},
{-0.23231074539887153f,-0.7053382686843688f,-0.35391891822253935f},
{-0.23725219961298408f,-0.6907142750928636f,-0.3583973039310966f},
{-0.25111159848833364f,-0.680816127486991f,-0.3500005032360201f},
{-0.2582293069243626f,-0.6925412606219488f,-0.3268020350542743f},
{-0.27690055369768196f,-0.7009214048873572f,-0.2917183097570441f},
{-0.28938746404327903f,-0.7242864001815095f,-0.2700601151083061f},
{-0.2782203765474051f,-0.7449331262861287f,-0.2522101201973192f},
{-0.26590445117739137f,-0.7766636768616225f,-0.2691914246123765f},
{-0.25066810484670443f,-0.7887224326095722f,-0.2685333373417272f},
{-0.2178238151639378f,-0.8115077218941807f,-0.2814849183038592f},
{-0.1916295237519165f,-0.8335776165683825f,-0.29838263459712694f},
{-0.18556924255952206f,-0.8444784168583543f,-0.3151060820122661f},
{-0.18206508162684523f,-0.8553328547338421f,-0.3437412521838809f},
{-0.16599980222534902f,-0.8500683138050039f,-0.331600669786293f},
{-0.1508005594250693f,-0.830907493576049f,-0.29181324545666787f},
{-0.169863302414502f,-0.8215003791741448f,-0.28080492524654554f},
{-0.1262933822417161f,-0.801204622677263f,-0.2480975172486145f},
{-0.10789319501018772f,-0.8081729448885154f,-0.24671921203609418f},
{-0.31980307459535123f,-0.45960134563064786f,-0.2235454257126241f},
{-0.3337918789917672f,-0.4705225717732028f,-0.23575002136807555f},
{0.32748062945170425f,-0.4016516804846181f,-0.2007645347963549f},
{0.3472981196992879f,-0.4103540997851844f,-0.1662210629945899f},
{0.36531897847136774f,-0.44906059216075445f,-0.1555171853045102f},
{0.39080126010426924f,-0.43827570056301224f,-0.10946944539011873f},
{0.3776276284726886f,-0.4078517617961061f,-0.1227765143804103f},
{0.21922161237257495f,-0.08865670319125034f,-0.2134891195806759f},
{0.2231151032718374f,-0.15200197533059423f,-0.21503182496516413f},
{0.21464119832984457f,-0.04806162369446371f,-0.2133813361833882f},
{0.22911821948712088f,-0.09818394191958012f,-0.2246017990477096f},
{0.27058650790025923f,-0.28126707689415953f,-0.24071125336600613f},
{0.2178735007900561f,-0.15422151204674925f,-0.2069516058617839f},
{0.22296130061778874f,0.48220925424464817f,0.0471664346229008f},
{0.24863949343834602f,-0.21526067929423737f,0.25613599328667475f},
{0.2448305840121769f,-0.21717398970763432f,0.2595877923879563f},
{0.23046418288104484f,-0.22753180080202645f,0.26213053799573544f},
{0.19023075125290856f,-0.24203210462649077f,0.2724793111868755f},
{0.23850571865360215f,-0.21605437229794072f,0.26536486646764346f},
{0.253275693452848f,-0.1927751334999213f,0.26190455535497653f},
{0.2557204415016907f,-0.1922186081664158f,0.25190703437205175f},
{0.2485844160925846f,-0.21191877034493367f,0.24912381913059675f},
{0.25692695005905986f,-0.21207536925634207f,0.23722192470878492f},
{-0.09371731440947606f,0.19104595004673525f,0.2383329695498479f},
{-0.0812869039736999f,0.21349688578177764f,0.22413261107316035f},
{0.4223134061939232f,-0.011670881811269608f,0.15380292761866737f},
{0.4296405205216291f,0.020059019633051418f,0.15828408939883593f},
{0.42343667084963377f,0.042415201340205724f,0.16586105548360042f},
{0.4223483817214843f,0.04342012438979813f,0.17435571031255873f},
{0.4355749828817283f,0.06629327692522967f,0.16177041887880533f},
{0.3998394916403271f,0.0704919412811091f,0.2058002766413262f},
{-0.4013246687042327f,-0.29733709782171824f,0.19792889716625922f},
{-0.3856540886784013f,-0.3501754159332824f,0.1732404200898812f},
{-0.4025658276923723f,-0.33707315367125174f,0.18840075751610538f},
{-0.19624560176246952f,-0.3438537516094436f,0.3181692024029504f},
{-0.20762483191254252f,-0.323869410215071f,0.3165380451937117f},
{-0.19083945780848144f,-0.4037451763252455f,0.30568997114101454f},
{0.38593028389955303f,-0.46598250372952027f,0.16309913726913383f},
{0.33447079689237574f,-0.9366815579075265f,-0.08865558341341707f},
{0.35379048533582436f,-0.9602451395322038f,-0.10301290626980018f},
{0.35501482640830867f,-0.96256591415112f,-0.1275988078719823f},
{0.36886113535701326f,-0.9701055142907479f,-0.12275626063789274f},
{-0.30248358665056724f,-0.7773939844904789f,0.08657929751692733f},
{-0.30662624086662676f,-0.8134128453929828f,0.08390612966380621f},
{0.18938228581448563f,0.4908432629814194f,-0.25235403395945877f},
{0.20232957039942812f,0.4995418735499817f,-0.2551728324257429f},
{0.18093713493990995f,0.5129319622738837f,-0.255184788763253f},
{0.1722108050891389f,0.5309060931631921f,-0.2602168419283029f},
{-0.15543555360670536f,0.5484127784267623f,-0.2984974893808076f},
{-0.13264044661151103f,0.5289123361679041f,-0.31366200100732305f},
{-0.10346203439125738f,0.4927713249272784f,-0.32819265994777624f},
{-0.09181266261974243f,0.521994753491319f,-0.33288952982275916f},
{0.016884134471806093f,0.4513904546160899f,-0.33261685967072585f},
{0.2774708170265975f,-0.05118841206047282f,0.2845668018789016f},
{0.2865201528491006f,-0.05279298251422988f,0.27200983954944064f},
{0.28525783813421146f,-0.033183602020792985f,0.27485256981408546f},
{0.2992493984164904f,-0.04857875707113611f,0.2721676740411338f},
{0.29646968912081323f,-0.06009120041187177f,0.27671003263605776f},
{0.305303863988525f,-0.0745145019805696f,0.27079344316257037f},
{0.31218043134914114f,-0.06971578650555726f,0.26217333496960427f},
{0.31405519973195417f,-0.08047336253605913f,0.24720902984552626f},
{0.30929214822476453f,-0.0881709395300268f,0.2511413868097552f},
{0.31513667988843985f,-0.10697325236782193f,0.24229716050173927f},
{0.3076994523031161f,-0.11893085201841173f,0.25021691034205396f},
{0.30072225473700676f,-0.1268113713878806f,0.26225775389430245f},
{0.29744579754574335f,-0.1409142603223141f,0.2588258728146701f},
{0.28922567739452737f,-0.15178717878168216f,0.250574486001563f},
{0.2814832157953414f,-0.16467764367205245f,0.24877935464588885f},
{0.2760227031216021f,-0.15971146722816737f,0.2553727966991992f},
{0.2691096601135952f,-0.17538066931106738f,0.2531188114097578f},
{0.2627858890350664f,-0.19180117326358592f,0.24455821823998156f},
{0.32319057677588353f,-0.551369219261875f,0.17303619131146963f},
{0.30577222116016567f,-0.5480607049773087f,0.17738971116753885f},
{0.2948030708636439f,-0.535179399104681f,0.17985697270031414f},
{0.29434601983593267f,-0.5488808221880985f,0.16702575935599653f},
{0.2898773413475486f,-0.5441071519148335f,0.15633210521628643f},
{0.2857110188102655f,-0.533239583741204f,0.15699980834003718f},
{0.290950918252325f,-0.5295523795042837f,0.13334917408169727f},
{0.2910521157835895f,-0.5091478462588106f,0.14453036504126826f},
{-0.4318314455330136f,-0.21276085389963317f,-0.12585405164509603f},
{-0.42541754083816874f,-0.17925438242651184f,-0.13191457612887927f},
{-0.42004385981726744f,-0.1305843321209336f,-0.1372367675551984f},
{-0.4128046905457862f,-0.1487593590153491f,-0.13023304379085268f},
{-0.4164702131640902f,-0.1877701313625666f,-0.12508214225115874f},
{-0.4232874896695647f,-0.22359024444855816f,-0.11757514634485666f},
{-0.4320738009405548f,-0.2516121907065857f,-0.10947368121006298f},
{-0.4446432061903035f,-0.2525161191448056f,-0.11275936860039233f},
{0.16554179821783105f,-0.3357598954393956f,0.2502460298777581f},
{0.16911037931056316f,-0.3478702034639883f,0.2350339181316583f},
{0.17708984603155195f,-0.35457331362604383f,0.2508331738043897f},
{0.16886316020006123f,-0.3440045147147437f,0.25792344449627996f},
{0.16006746680568812f,-0.3428583934173778f,0.26500915533384345f},
{0.1373745305073136f,-0.33058597470965084f,0.2657346003221468f},
{-0.25504180726396786f,-0.3246676418249449f,0.30968871159493433f},
{-0.21503681031381933f,-0.3439155157499703f,0.3425264770313309f},
{0.09709434018657964f,-0.9932145383588474f,-0.30751837498452783f},
{0.07348451726190892f,-0.9919111690189002f,-0.2954367200986101f},
{0.33778822796570357f,-0.9521934322672595f,-0.1362891699062965f},
{0.3526525509530536f,-0.9585261190721421f,-0.15076675838934406f},
{0.33685114709172725f,-0.9359711895484757f,-0.12636919938156882f},
{0.3211005656328776f,-0.929209557714534f,-0.11363120913548286f},
{0.36286219334202097f,-0.9418660155979455f,-0.14529949836359426f},
{0.3317804913388481f,-0.9526405327834088f,-0.12837760698057687f},
{0.32525837722118317f,-0.9394915830101038f,-0.11390546971200986f},
{0.3164510324003419f,-0.9179978289048304f,-0.09329230082052321f},
{0.18453132962256852f,0.42743979426697964f,-0.29662523465487656f},
{0.15284690029498543f,0.4562066382003382f,-0.3031034564562191f},
{0.19661910397748017f,0.4501701676918141f,-0.2915901206929218f},
{0.09853402388559104f,0.4786029024294031f,-0.30993045930520746f},
{-0.006737540674409233f,0.5476028741422639f,-0.30621010263253085f},
{-0.04533812905211007f,0.5652595512030629f,-0.29692230193989205f},
{0.37936885856804853f,0.4898091598388775f,-0.06478464083443924f},
{-0.2765879433863849f,0.6024506335756368f,0.11185367231557417f},
{-0.2808223928245775f,0.5804378422588927f,0.11005487777776608f},
{-0.2772490702057828f,0.574624597442857f,0.12177020382621616f},
{-0.2718715390189728f,0.5970628076571336f,0.12939493257896018f},
{-0.26563326095943945f,0.5580978718325337f,0.13041193308055318f},
{-0.26819525633435437f,0.5535346613594943f,0.11778263884006498f},
{-0.27740674321148856f,0.5983029541706291f,0.09767229056721478f},
{-0.26750446283922946f,0.6199664374854524f,0.1137026496863563f},
{-0.2605405570572492f,0.6179487688775519f,0.12659149865444536f},
{-0.2552640406675601f,0.6048759693089485f,0.13941511790772676f},
{-0.2518940257196044f,0.6412598225398931f,0.10199004977635044f},
{-0.48596851257295287f,-0.10316251984984831f,-0.03710927219025659f},
{-0.47996187022614323f,-0.11048310780636816f,-0.02172887929645363f},
{0.2226926633658078f,0.37060399146752876f,-0.27075546739535f},
{0.1797447309086457f,0.3681898407636559f,-0.2803082782797014f},
{0.054775701623560866f,-0.25021155580668425f,0.31797596635816394f},
{0.036782684310588176f,-0.24273274664202787f,0.3278964234656693f},
{-0.2327705916215346f,-0.011621599900119683f,-0.23094909608481534f},
{-0.09599187322618628f,-0.8922736380756685f,0.28494145999361103f},
{-0.10883272685898503f,-0.8875267160438723f,0.27241523737176676f},
{-0.10733860432130687f,-0.8912985431877904f,0.26933471049149954f},
{-0.09937222221492403f,-0.8998683559325545f,0.2815880207323296f},
{-0.13367359783665383f,-0.8846494160914505f,0.2663293234661053f},
{-0.14454465177031275f,-0.8751912370580888f,0.2802201717374897f},
{-0.11327314848680788f,-0.8826372996267726f,0.2832656221614538f},
{-0.08685397933815149f,-0.8937995850393389f,0.28712061140162926f},
{-0.09348962022973288f,-0.907667494863666f,0.29147372541791444f},
{-0.10719553729819292f,-0.9043234780972643f,0.2914832499039441f},
{-0.13134370457149178f,-0.8986817059019971f,0.2806170394874976f},
{-0.1549144797594602f,-0.8892634064706539f,0.2642544293238486f},
{-0.15799251316859392f,-0.8801463081531206f,0.26668815489164754f},
{0.35967372157847893f,-0.12164879823597004f,-0.1876037699857787f},
{0.45117921978936576f,-0.09447079899594328f,0.028553142195696248f},
{0.4526834437005152f,-0.06411089473505695f,0.048054009417678976f},
{0.45039124041487233f,-0.061431693467974585f,0.040466434128509324f},
{-0.044001900500962414f,0.4469270244222945f,-0.3400065891276152f},
{-0.04832071255623919f,0.4685498589518438f,-0.34197566532703544f},
{-0.20874606949414856f,0.5263806555374813f,-0.273607742331773f},
{0.24827478477279077f,-0.7108925016631956f,0.13099478169240308f},
{0.22530460890638598f,0.4761331877969911f,0.03370894462262442f},
{0.2398357544296169f,0.44775694978199976f,0.024845909446714533f},
{0.22816689384920855f,0.4884039045274041f,0.03638982980608795f},
{0.23724909844458242f,0.4934261707916949f,0.025532885710572908f},
{0.24943673275932401f,0.46891886293218077f,0.020024642241088415f},
{0.26074789550332494f,0.46013895479307027f,0.017670846924984274f},
{0.25234378013046666f,0.42531841553334054f,0.02257253946434531f},
{0.23088921718695007f,0.4350029819848374f,0.02670977008852734f},
{0.32426496429782004f,-0.42229321885189397f,0.17203939355681927f},
{0.29101389778738807f,-0.3821608030832864f,0.17187882336501162f},
{0.29988799262861515f,-0.370118905622489f,0.16403834508354867f},
{0.29541710539439114f,-0.3621143724515968f,0.17535092720438566f},
{0.2884689646819251f,-0.34697373206619697f,0.17831636557125358f},
{0.2955682732770674f,-0.3415488642369398f,0.16945841082949803f},
{0.2762459096907497f,-0.33822073365454286f,0.18606803718375706f},
{0.2832521662353179f,-0.32402665719524437f,0.1896593527412466f},
{0.2791968483158069f,-0.301636594240575f,0.193743546905073f},
{0.28345622290366396f,-0.2877738710911833f,0.19825109145842343f},
{0.2774381511736187f,-0.2766981527919101f,0.19644769244516053f},
{0.286870919536946f,-0.2721123693401007f,0.20770404238294504f},
{0.29323396145781755f,-0.26946315772072005f,0.20749894243012812f},
{0.282046874134893f,-0.25957246821768387f,0.21455479429615068f},
{0.27538666293785613f,-0.2425742024619167f,0.20948305382489604f},
{0.2860281879134815f,-0.24223733631787633f,0.2238703567673106f},
{0.2882774720483573f,-0.2255631304423902f,0.23034519479977364f},
{0.2838610130287219f,-0.21480855358914008f,0.22828691777809587f},
{0.28725945800971214f,-0.20443979863188214f,0.239201781160268f},
{0.29596690249922675f,-0.19511884656589473f,0.24241396161653062f},
{0.29200791947042704f,-0.18386813057673435f,0.2422931286640948f},
{0.3012585975093181f,-0.1752085082500368f,0.24697471898993337f},
{0.30171319543739256f,-0.16232444649154615f,0.2513795680170052f},
{0.2922469516663341f,-0.1635735087313952f,0.25327472081849656f},
{0.3085038246301402f,-0.12602351312787774f,0.25510687496158435f},
{0.31287458948980496f,-0.05305981686015478f,0.25196624554660757f},
{0.31482640049988125f,-0.03479125345720322f,0.2530162561213103f},
{0.3095485263530091f,-0.023354190075505862f,0.26868122344667383f},
{0.2979946427331799f,-0.01944538031801002f,0.2756332132626408f},
{0.2864828070897123f,-0.013282179431288791f,0.27004339812139283f},
{0.28256828264059863f,0.0023740538394568115f,0.2716061437044285f},
{-0.1206622893697696f,-0.9274313664514133f,0.30495086890029494f},
{-0.10893669090019063f,-0.9141551604080445f,0.30234885262312255f},
{-0.06827106752472331f,0.2515339422464564f,0.22834855974172427f},
{-0.09253746378891205f,0.2609069321094567f,0.2418113766547673f},
{-0.09415630556680028f,0.22284191200877257f,0.22490725616721216f},
{-0.11067331014564892f,0.20332201600047894f,0.2294295129439356f},
{-0.12754337621321574f,0.21448624668174784f,0.22138666084809988f},
{-0.05562990831379677f,0.27503349042752157f,0.22776467846948165f},
{-0.4078621824231247f,-0.3521084223250959f,0.1822547304516563f},
{-0.440130534456855f,-0.27721333983747193f,-0.09605711622109167f},
{-0.41765795641228554f,-0.20120358544851663f,-0.11988679275585698f},
{-0.41234810591510423f,-0.16208744136974343f,-0.12491472271619065f},
{-0.4107841449375323f,-0.10794907712986637f,-0.13192942965249121f},
{-0.13997711517266512f,-0.9247242822913194f,0.2777496071788286f},
{-0.13204142815277087f,-0.9432220708036705f,0.28211593329865703f},
{-0.13398452635638533f,-0.9181550758850039f,0.28075562314964714f},
{-0.13795716663760121f,-0.9128469273651365f,0.26809215337468006f},
{-0.14464907052206158f,-0.8962562076202901f,0.27011594251398235f},
{-0.12993499324740768f,-0.9274138590330883f,0.2978158155943363f},
{-0.14532242778018487f,-0.9407041696025622f,0.2978804971067132f},
{-0.1616178321504969f,-0.9322927384895141f,0.30341004822726425f},
{-0.15685245078297674f,-0.9096940388264233f,0.2727041995475886f},
{-0.15292546322782685f,-0.8996822528938142f,0.2595188346841382f},
{-0.02955570829355886f,0.7259897469391285f,0.20117214136452097f},
{-0.036552919498020385f,0.7182289067472123f,0.19514019033882682f},
{-0.014932460512337476f,0.7174879389183756f,0.20366931286441217f},
{-0.2174799381907496f,-0.32121695612704987f,0.25940254140028074f},
{-0.33734112744955447f,-0.7554941441226177f,-0.19962127031359395f},
{-0.3289507298863576f,-0.7701353221604731f,-0.23516105328723166f},
{-0.32565824414844274f,-0.7657278596101851f,-0.27020246819337074f},
{-0.3306134172346246f,-0.7547862065526393f,-0.2882069541986681f},
{-0.2520516987253102f,0.5455303714799906f,0.12947830821918752f},
{-0.23318302152116474f,0.4360635093344656f,0.14392184228224672f},
{-0.24554678923974393f,-0.9972828654620097f,0.32753591024856155f},
{-0.24240307990452176f,-1.0f,0.3205998469880961f},
{-0.23636885851333453f,-0.9977987005763364f,0.33727304038893785f},
{-0.2628426088633043f,-0.7669558468662783f,-0.2545859317905001f},
{-0.24366650908520507f,-0.760847196371044f,-0.2415653729388016f},
{-0.21085107439859752f,-0.764126693111056f,-0.23744900056718185f},
{0.2955359325208789f,-0.028256981144543968f,0.27810503464974284f},
{0.27008791672712007f,-0.030307680011302587f,0.2925096930861653f},
{0.20241670483849244f,-0.953073692384256f,0.20280573042524006f},
{0.1957601610732207f,-0.9783194947872214f,0.20894824091983322f},
{0.35316368491281447f,0.23817116802738675f,0.19461276329286925f},
{0.37102563509890385f,0.20045881951175415f,0.20991832124284115f},
{0.37458627256842975f,0.18769747541715684f,0.21635713940086465f},
{0.36229277993935494f,0.18771571270964824f,0.23815499286845743f},
{0.10338528392614232f,-0.8988491668708699f,0.17688364276822277f},
{-0.2424485520212598f,-0.30216669536699403f,0.2608138152520061f},
{-0.2295146208400995f,-0.3243375846525682f,0.2623230441663554f},
{0.08671152319952927f,0.19948607466995505f,0.2712627522516102f},
{0.08855378827775869f,0.19809565269634508f,0.2800785283408431f},
{0.07587496883473173f,0.19844970222432795f,0.28939514365814417f},
{0.07247376796787854f,0.20457829198936767f,0.2830551612988203f},
{0.07376419824308994f,0.2087137324563874f,0.296645133553185f},
{0.10298628923569592f,0.19613922127469682f,0.2823877928335301f},
{0.09307339009736129f,0.1989241183077174f,0.2666108275390908f},
{0.08194273681497341f,0.21082570888089516f,0.2711665406002048f},
{0.072092534611224f,0.21374718481252508f,0.2848055907834197f},
{0.0741548137231274f,0.22006155358192256f,0.29305547853910485f},
{0.08902665430815113f,0.21483210929513555f,0.29955661966416386f},
{0.10914253985051464f,0.2235928887816008f,0.3068962364069947f},
{0.1269262405140668f,0.23108207342094383f,0.308921118763935f},
{0.09296726830589075f,0.22778158244016966f,0.2945060041098322f},
{0.11194678864182091f,0.23469454470518286f,0.2884522280404673f},
{0.1193765294392974f,0.23243545348379954f,0.2754583366872441f},
{0.36906964988853636f,-0.3362541711120045f,0.23917738402728575f},
{0.36552907386571387f,-0.33595734605597005f,0.24914843936921938f},
{0.3578543545758097f,-0.3355018153338371f,0.2565874507372587f},
{0.3647523209545644f,-0.3211793468905243f,0.2519927101251909f},
{0.37005451255383276f,-0.3218501607443471f,0.23830656659091765f},
{0.3675324360900256f,-0.3329193941063391f,0.2307260329407223f},
{-0.4228026577399918f,-0.1390110013492213f,0.16979891359547708f},
{-0.42748234316862443f,-0.14406269099785035f,0.15422863974075626f},
{-0.4197456982522062f,-0.1492841109184374f,0.17705746543507048f},
{-0.43979196633550066f,-0.41922624935770875f,-0.16016003174228063f},
{-0.467694558512766f,-0.457154772365185f,-0.10905843486732474f},
{-0.24876573723376547f,-0.6714334920234707f,-0.3550692137201965f},
{-0.2671902111078637f,-0.6673768375949327f,-0.3516786316194188f},
{-0.2647630108488427f,-0.6736822906379765f,-0.3478305320939007f},
{-0.2641647413876095f,-0.6826025864077003f,-0.32632113403360374f},
{-0.27802031134520666f,-0.6911662393119736f,-0.3038616066065902f},
{-0.288312690867307f,-0.7117612516539625f,-0.28109933757444017f},
{-0.31393726502802793f,-0.7313840875423314f,-0.29624159919416027f},
{-0.30494961260305786f,-0.7425014681639308f,-0.26920935805623386f},
{-0.3006676437882745f,-0.7402820121907696f,-0.2551118385308795f},
{-0.317462724050101f,-0.7513617835758434f,-0.28147379276925766f},
{-0.3247946000896176f,-0.7395264150063693f,-0.30036208520882596f},
{-0.2999896172478198f,-0.7109542658037222f,-0.29834919849848485f},
{-0.2864209016489466f,-0.6900454065077437f,-0.3159989061640407f},
{-0.27429533532336586f,-0.6809889376791944f,-0.32843590671547124f},
{-0.3775785909153352f,0.26963066862275986f,-0.16289560755506222f},
{-0.044868206953763104f,-0.4135387628167225f,0.2431143603406789f},
{-0.23093175174608938f,0.3328381464689581f,0.2030019752089485f},
{-0.23188492066155458f,0.3155155786039287f,0.20613432634225842f},
{-0.22293876801051554f,0.3081225259354052f,0.20206211826336085f},
{-0.21471011672457357f,0.317121770292006f,0.19430738691636038f},
{-0.18981333866064265f,0.3428260218513627f,0.1893589930544234f},
{0.17029526574415357f,-0.3768024005491217f,0.2634917395048991f},
{0.1715612277050594f,-0.36018152860817837f,0.2631582380063976f},
{0.15991751431754822f,-0.3527815054820039f,0.2640426319521883f},
{0.13727666681176154f,-0.33975511082419707f,0.2634390334533729f},
{0.17708433425982614f,-0.377246259659038f,0.24992065367419858f},
{0.16604760420241768f,-0.39336329213225363f,0.2602426786238697f},
{0.15786892326788748f,-0.3895922756054956f,0.26903885966342816f},
{-0.2594481553484616f,-0.6049525975971655f,-0.3040507088225822f},
{-0.012405564966697398f,-0.10946959306480454f,-0.35254182946696316f},
{0.009033982967219861f,-0.12296440651390515f,-0.3515776359456385f},
{0.02870764338288093f,-0.15011703439298654f,-0.3508371557619875f},
{0.04899172826754614f,-0.1089704547516426f,-0.3386604228137992f},
{0.018523406351908717f,-0.07606857512864036f,-0.3410831652096433f},
{-0.02328691681927281f,-0.05813955195019062f,-0.34251533131098094f},
{-0.04409018127805519f,-0.09197154092711042f,-0.3501534134675071f},
{-0.3060676480875202f,-0.8293802494124408f,-0.08356578838381457f},
{-0.26547465622208305f,-0.9766740726282983f,0.32215394032191524f},
{-0.2533993640965481f,-0.9763010559336576f,0.3214008355462407f},
{-0.2498041569392452f,-0.988444921171383f,0.3152181819724917f},
{-0.25292772408477004f,-0.9769840279824746f,0.3354105120065206f},
{-0.23705953089396897f,-0.980777739664901f,0.3453837973424505f},
{-0.053421633120443256f,0.8656394089009627f,0.17804153766895525f},
{-0.028832690907104764f,0.860396834316034f,0.17272022804111964f},
{-0.32194433204155043f,-0.5789610858393007f,0.10284927634349557f},
{-0.3151451111568315f,-0.6157593737334157f,0.09982808281468251f},
{-0.31439524778738975f,-0.6775200954318017f,0.08969893800318102f},
{-0.3232797786605488f,-0.6589389822747982f,0.07035503409848601f},
{-0.058089429143257876f,0.9033817066928004f,0.16790858306304188f},
{-0.05540897635977358f,0.9311912075104026f,0.15457974108706232f},
{-0.024983115697136488f,0.9401594476198417f,0.13667691901005866f},
{-0.0004988631495388029f,0.9400826684697158f,0.12257519447458654f},
{0.017449844320841578f,0.9436430413996967f,0.1058834641822505f},
{0.027510223724338922f,0.9528285099095284f,0.07970232962856626f},
{0.16492987150418156f,-0.7757480757487782f,-0.21788018811602533f},
{0.17549007872351047f,-0.7573965117355568f,-0.21508560511098773f},
{0.1818885221974753f,-0.7521831979865711f,-0.21665167390565765f},
{0.25329332304807123f,-0.7718376447569621f,-0.24340676684262558f},
{0.260222008948694f,-0.7740120333907615f,-0.25578313896747984f},
{0.2716525268358649f,-0.7715623812674611f,-0.2694544895353864f},
{-0.38378114444980055f,-0.9628236702222962f,0.10959708837662593f},
{0.3274937204407569f,0.1012347511285452f,0.22395505935489443f},
{0.33425916206911066f,0.10579751539030381f,0.2316749065414058f},
{0.35702807752452903f,0.12911063543583837f,0.2503745227905145f},
{0.36289704669268374f,0.1422004154684922f,0.2530739671760363f},
{0.3941435345218601f,0.11901438914462635f,0.21752885516481635f},
{-0.18079468198851092f,0.9684668501079134f,-0.04896975183076227f},
{-0.19169471203281957f,0.9477752808319805f,-0.08229885325735344f},
{0.11620626415842006f,0.11235756277887672f,0.2933580182867571f},
{0.10364729494060326f,0.12431054201789454f,0.29769441425372134f},
{0.09928925666411195f,0.13414757355200538f,0.29940911921325275f},
{0.11689946931927707f,0.14774419116723075f,0.30715095186701435f},
{0.11223094873433494f,0.1550291969613294f,0.29089045184293993f},
{0.12116020166431725f,0.16360160410596905f,0.299426687188823f},
{0.10409066746774197f,0.17168500405833673f,0.2956266743656669f},
{0.13359791190416584f,0.17930363352783518f,0.30877173360156634f},
{-0.37619197873613713f,-0.35641407858444346f,0.17750111100101673f},
{-0.3845602474070292f,-0.32960228812980163f,0.1809992045226824f},
{-0.30155825919420903f,-0.8157344306290593f,-0.0826016766678914f},
{-0.31090178530137424f,-0.8129732008548544f,-0.07122086565499497f},
{-0.32077387310603966f,-0.7928423109269698f,-0.05169997735780537f},
{-0.3234049685474194f,-0.8073114893897819f,-0.044189202466917966f},
{-0.32536324430902835f,-0.8321703341828046f,-0.03961640801301141f},
{-0.4202081176265886f,-0.9660114121116719f,-0.09300846582479941f},
{-0.40913227821282494f,-0.936639571550818f,-0.12363159755709077f},
{0.35663240604571683f,0.37519788109093954f,0.0340661856236729f},
{0.3989266071042565f,-0.638575464345294f,0.042721897227216483f},
{0.4022905631404636f,-0.6465261769988658f,0.08409762335978184f},
{0.38391638365215963f,-0.6411561017900765f,0.05864056860036321f},
{0.4161012484928425f,-0.6438672390359713f,0.08949982578078942f},
{0.4111090536816549f,-0.6264659669378616f,0.008153761628108599f},
{0.38409446232469996f,-0.618755501874733f,-0.012016709365199607f},
{0.38737509371625467f,-0.6021202013733025f,-0.05038769229150449f},
{0.39410215586241965f,-0.5838921656411344f,-0.07242162871091964f},
{0.4033650324678017f,-0.5698621440712652f,-0.07979764991981779f},
{0.42737818683160506f,-0.5555899296422498f,-0.062216738472092664f},
{0.4237807507427139f,-0.5289092859950775f,-0.056326126994410974f},
{0.4270035085311473f,-0.5071396203315383f,-0.0522506063279573f},
{0.4295894155186746f,-0.5083006567721692f,-0.05871556609258943f},
{0.4443332094022227f,-0.4971127577696767f,-0.045886104658752876f},
{0.44890525379621443f,-0.5072342925540247f,-0.07871343406321749f},
{0.4335076275853017f,-0.5281699000914722f,-0.1229739756210629f},
{0.46011605087426716f,-0.48495576223380965f,-0.03715899925027953f},
{0.46891488580853874f,-0.4705723402671303f,-0.011454859243743098f},
{0.4582037539979224f,-0.47506474763398315f,-0.04474757214038415f},
{0.4454152972559767f,-0.4448058379844693f,-0.02420355324852945f},
{0.41508043819683743f,-0.43167358501232916f,-0.06303365464814661f},
{0.391504901297058f,-0.38004363892143533f,-0.10236907438716498f},
{0.36022834201477844f,-0.37341234434021064f,-0.14397471088216815f},
{0.38344152135748943f,-0.3365412687621174f,-0.12943995848441747f},
{0.20999381328590366f,-0.9184510903238783f,-0.2056859679352606f},
{0.19756189848066655f,-0.9098858161852846f,-0.21327106037737484f},
{0.17099100368523298f,-0.9100130724553485f,-0.2243110743373285f},
{0.17759137582469753f,-0.9216634726376249f,-0.22737889482017068f},
{0.15150800828745453f,-0.9230798332979516f,-0.22856911029134322f},
{-0.28759405485066725f,-0.6067085792249874f,0.21027250250939264f},
{-0.2801706268804064f,-0.5907852683169281f,0.2245258305147437f},
{-0.2715889597892821f,-0.5944478331918851f,0.23000999026155036f},
{-0.271443871004103f,-0.5541254227847239f,0.23990084231298167f},
{-0.2592892871339679f,-0.6122438439747485f,0.24362444145429885f},
{-0.008150284898545605f,-0.34252266192488f,0.288066282905169f},
{-0.22746704332749088f,0.39023485172209765f,0.16164658674911783f},
{-0.03784238404453131f,0.5644999827382634f,-0.2944563163588983f},
{-0.07080866045461698f,0.5803845890673436f,-0.2720924343199265f},
{-0.035686859523832055f,0.5637531387318219f,-0.2861725473556981f},
{-0.008276423515591828f,0.552167016346954f,-0.2922528283751431f},
{-0.10550230678775444f,0.5959240626572027f,-0.2574785718493115f},
{0.019373327289033283f,0.5437473983193108f,-0.29532190568642624f},
{-0.30608146895073934f,-0.9713146969285784f,0.2147946371092178f},
{-0.31568613489796016f,-0.9748885868731445f,0.22458244728942395f},
{-0.3111676061102471f,-0.963231216233217f,0.2324038978469838f},
{-0.2996108656758128f,-0.9654902267116067f,0.2262731397076009f},
{-0.3172235707397035f,-0.9702094273363786f,0.23874235990072945f},
{-0.12008534774535139f,-0.8210664089561374f,-0.23441512188910005f},
{-0.10618737602959122f,-0.8262017472838015f,-0.23944668953378012f},
{-0.1102625322901656f,-0.8530258584818327f,-0.2379901666709571f},
{0.08067219587640016f,0.07267046374370288f,-0.3324819030688446f},
{0.07803102880896792f,0.06033547134069695f,-0.32638780224858815f},
{0.05992062393209198f,0.12519963711825088f,-0.3198741990799008f},
{0.03896829515809991f,0.19351302990777483f,-0.3057839134893346f},
{0.17990177603133495f,-0.7795630239009477f,-0.20278893057051753f},
{-0.23297464828988068f,0.4164295680972435f,0.14307880681014815f},
{0.37459628257482913f,0.1555751853341609f,0.23519161132311248f},
{-0.1247240104211603f,-0.9174531377319368f,0.2996126489273244f},
{0.2740233737973429f,0.1907569889333212f,-0.228747614989416f},
{0.2585339321785488f,0.13738281356981558f,-0.23203819583012492f},
{0.2984971244437244f,0.11239987316996791f,-0.21748062609980756f},
{-0.3482965195649179f,-0.6960974805997946f,-0.2316729198387984f},
{-0.33569153109034017f,-0.7145831109171514f,-0.2262985896867243f},
{0.22255047176673046f,0.2456065310870015f,0.2022016655293954f},
{0.22202681414368797f,0.23981869800340772f,0.19929135550386387f},
{0.21360334701254394f,0.24257709008634812f,0.2128714186805712f},
{0.22189469417066326f,0.2569289819139992f,0.21081362717926327f},
{0.2092599997112694f,0.2594981102949601f,0.21527772668997994f},
{0.19350491895533836f,0.2605669053021772f,0.2242494323737001f},
{0.2243946821136627f,0.22200906927721714f,0.2024642842411245f},
{0.22151462627537796f,0.23279160976647253f,0.18424980483263062f},
{0.22998559259736423f,0.25515208785081633f,0.18523001627652855f},
{0.2294848936071273f,0.2560756315244592f,0.1938651501031721f},
{0.2339422648891739f,0.2520453194976063f,0.20267493739957188f},
{0.20730364903261486f,0.2812041472922636f,0.21758210835636552f},
{0.1814008323908895f,0.29163272005893764f,0.22029132051930586f},
{0.16980216615699184f,0.2830899795900251f,0.23152580504192283f},
{0.1751875602240145f,0.2708960228863975f,0.24003577979152232f},
{-0.24834497911930142f,-0.8986635504149072f,-0.18974040808281373f},
{-0.251850904711353f,0.77278855499342f,0.025854642290718797f},
{-0.26602171868921193f,0.7641930479157361f,0.023352359546846706f},
{-0.2578302516766709f,0.7174970575646213f,0.005665648217217876f},
{-0.2622318571726943f,0.6895242721032533f,0.014789575692163237f},
{-0.25266656299655826f,0.6810256258081474f,0.012843407129973608f},
{-0.2562159336312438f,0.654089090615508f,0.029012455089638022f},
{-0.3436321317463624f,0.4422919590593351f,0.09152300616041578f},
{0.30529498863366805f,-0.8911502119339708f,-0.08642986667102283f},
{-0.02505764148029442f,-0.2851567579990102f,0.30486288347257373f},
{-0.04388554984708317f,-0.2876584479193235f,0.2913748991808851f},
{-0.06452037060976724f,-0.2725675749654434f,0.308375048585702f},
{-0.12227693144957924f,0.6368996158890587f,-0.2358757785807174f},
{-0.19763360250867715f,0.3434973212255553f,0.18469374468554062f},
{-0.21461795709656117f,0.3273648880887048f,0.189546159563383f},
{-0.19118821867037886f,0.35732681225860463f,0.18662721641197555f},
{0.021456255359160164f,-0.006467700245581803f,-0.3154620768089517f},
{0.005660626746697085f,-0.038939824222364715f,-0.3325436268378745f},
{0.045335141561344314f,-0.02970098140649335f,-0.3174487422320984f},
{-0.39081491948150104f,-0.7562743817313891f,0.021822002528351037f},
{-0.3871492746862987f,-0.7583810089325662f,0.006714698375259036f},
{-0.2879241725802893f,-0.9098517723893745f,0.21647797341570824f},
{-0.2985952834886481f,-0.9094951295239239f,0.2199390537116306f},
{-0.31215019947245826f,-0.9167790814094735f,0.2138925827583773f},
{-0.32619268202354806f,-0.9268842434270393f,0.20345274315686274f},
{-0.32879433389484114f,-0.934842089086657f,0.1744605051566728f},
{0.3274047214759836f,0.4832860736180651f,-0.21170290395135544f},
{0.3254594761461822f,0.47410644091434173f,-0.2197137807592898f},
{0.11834081462410563f,0.17099092772307442f,0.23937556345561886f},
{0.08840754465528852f,0.1687776326528117f,0.24603172262926287f},
{0.07548780830489707f,0.17051594431391365f,0.2556503294917855f},
{0.068792915867263f,0.17217887389116168f,0.2637944811100356f},
{0.06724352368800958f,0.1619250565853938f,0.2739430074272414f},
{0.08741323930936373f,0.16197644525123384f,0.2833759585247125f},
{0.08570866653313018f,0.14446023656404192f,0.27244733483656636f},
{0.09089255796018537f,0.14848422620200882f,0.27900264069907676f},
{0.08320768630123496f,0.13888128241785042f,0.29006865284058453f},
{0.08472900222925517f,0.12943939647068514f,0.2941058949535915f},
{-0.34794790000325937f,-0.968264425297966f,0.1977221345452174f},
{-0.32929010862487207f,-0.9367335957045395f,0.20778850167914006f},
{0.1640193986338431f,0.3006185897636002f,0.18749193456509813f},
{0.1343070946160992f,0.2928079407062593f,0.18150504981635804f},
{0.10128974188807f,0.33165409083827635f,0.17585695523220493f},
{0.21896286401250298f,0.2572321282965117f,0.15420601576641135f},
{0.22708221265798678f,0.2029310053047355f,0.16786106474885892f},
{0.21193571521832244f,0.19254709403763934f,0.19099767742300625f},
{0.16850005364548573f,0.19736040062153423f,0.19892287741539366f},
{-0.24644660403491783f,-0.6576957569034653f,-0.3313546267612382f},
{-0.10113489701195828f,0.9660950512290364f,0.12925258374352683f},
{-0.11952200387851196f,0.9426960323247222f,0.1492093014723938f},
{-0.07805410111940925f,0.9520418681064695f,0.14484935829869655f},
{-0.09853891839837839f,0.9361415774508689f,0.15620040064471602f},
{0.2740474872674395f,-0.25417483521267337f,0.21045181676221775f},
{0.273297948994788f,-0.2672188998372003f,0.20364760043596944f},
{0.2669175611415789f,-0.25043170157892697f,0.19627762857714975f},
{0.26881929980909347f,-0.23761815820132945f,0.1973093508637861f},
{0.2672270299129775f,-0.22742059326436245f,0.20661196470853999f},
{0.27631310379760066f,-0.23713960828914568f,0.2188549196604318f},
{0.2769418909232179f,-0.22681583992825596f,0.22383171380798456f},
{0.2707144536729927f,-0.21072895965113728f,0.2203092135916664f},
{0.27503490289870697f,-0.19592591422153652f,0.23334452397582692f},
{0.2880129686251707f,-0.19267608415725157f,0.24278957164863912f},
{0.28085353730957036f,-0.17986027041416094f,0.2393509432169962f},
{0.29074297104657343f,-0.17316461835494176f,0.25045663204063057f},
{0.2628998322728449f,-0.2329983309536098f,0.19880313874300365f},
{0.2627662939853919f,-0.24204604660420048f,0.19310997788189643f},
{0.17712028295294227f,0.3725275955502109f,-0.3045229363458801f},
{0.4587274923639585f,-0.08071506881242754f,0.03925619439490647f},
{-0.3791283687486242f,-0.08700220275757843f,-0.20018796820189413f},
{-0.40907404020382443f,-0.4892383993031064f,-0.23002075032786481f},
{-0.3927706614004797f,-0.4310481625322508f,-0.23511422341331054f},
{-0.42460520470219f,-0.5060567218606241f,-0.20985559349842947f},
{0.3372230695063222f,-0.9569379213851675f,-0.12725091818449027f},
{0.33443663198197504f,-0.9434263303919085f,-0.1097893714416055f},
{-0.16358439575544304f,-0.939135425665023f,0.3258174773000197f},
{-0.18316785881031947f,-0.9312836008681337f,0.34053657020195155f},
{-0.4557363915364049f,-0.446203879546903f,-0.07061811814483651f},
{-0.4533658887950578f,-0.4325671390382702f,-0.07872338351237175f},
{-0.4667456041690888f,-0.4485337324405682f,-0.08305073307682138f},
{0.4892752027033069f,0.3000628750472547f,0.002722732895952817f},
{0.47750548881176513f,0.3074805681401494f,0.013882055253132814f},
{0.4545546859518021f,0.31841541222603154f,0.03849066369746914f},
{0.4590224528942839f,0.3295275243672939f,-0.0013606442762665839f},
{0.49729991843539334f,0.286475173158383f,0.006096714874676516f},
{-0.29826194347613394f,-0.595205375644988f,0.19511391805605735f},
{0.10254621973444301f,0.19170800966019166f,0.26703973219665317f},
{0.10974915771233018f,0.1910452212349766f,0.2593000466690785f},
{0.09057122421834844f,0.18052230028019856f,0.2566636827473618f},
{0.10841443990509046f,0.17275371832256006f,0.24650417325820106f},
{0.31115489971282206f,-0.03920503733396932f,0.2671559649232654f},
{0.3004634851287786f,-0.03923389339253628f,0.2763969973616361f},
{0.09941953229717604f,-0.46215020964501313f,0.21262945848873585f},
{0.10461207597344774f,-0.4527387181229258f,0.21020642180592797f},
{0.09756328593214793f,-0.44126696393896103f,0.21427865963224427f},
{0.09605109821204375f,-0.41351428387833883f,0.2189926725196728f},
{0.0982478377813805f,-0.4828395712375139f,0.21346310121337336f},
{-0.08795953259323706f,0.7850012153865681f,0.2174239487678821f},
{0.12124420518756115f,-0.32847075581650265f,-0.27594185123113085f},
{0.0871558274583187f,-0.16074962345650987f,-0.32599456262125637f},
{0.0462629709880984f,-0.1773123785029431f,-0.34696307824066364f},
{0.0840467090590296f,0.22660004046636986f,0.2842173727624907f},
{0.09202019867367112f,0.22480053199051248f,0.2737699550060571f},
{-0.04564207117807344f,-0.29126086882566615f,0.282654627179455f},
{-0.09519357999665932f,-0.26938907389921174f,0.28975507042613996f},
{-0.11975755031438957f,-0.27009441706931453f,0.29203264223140346f},
{-0.1332254731593744f,-0.24821662272594885f,0.29728070840230963f},
{-0.10331611480316974f,-0.26124707046955636f,0.3011073079809473f},
{-0.11522397676965854f,-0.24524886512282854f,0.3203012806456586f},
{0.4054856813272742f,0.3288443090270881f,0.048565617211323985f},
{0.331715444358184f,-0.4252507645911306f,0.18042389369425474f},
{0.3299411840039658f,-0.41955581994730795f,0.187765294219801f},
{0.315332104493318f,-0.4251282084132246f,0.20065845337638114f},
{-0.3605678429301912f,-0.6534053387593574f,-0.21137436708455684f},
{0.012120322280623461f,-0.632442334911676f,-0.30955201158183454f},
{0.03255493229123893f,-0.62423013713551f,-0.31618452262000335f},
{0.4390353545516406f,-0.1991647218047776f,0.057508262854177414f},
{0.44471348021740004f,-0.13687795100336558f,0.08031943133066526f},
{0.11495752701536133f,0.7877743398786299f,0.10834598950100233f},
{0.10648511156912027f,0.8029576146895034f,0.11961057734895689f},
{0.10054238155143203f,0.8264505568187971f,0.12479840393454573f},
{0.2297200958228739f,-0.329321511806167f,0.17546252039608526f},
{0.24273822282309201f,-0.29755059717069254f,0.1747959009283021f},
{0.23741382265093292f,-0.30323986749439424f,0.17749935802812783f},
{0.21808465009295147f,-0.33456838276828527f,0.18640673598127222f},
{0.22818038961563744f,-0.30987926824722034f,0.18773238507543338f},
{0.2177553227947412f,-0.3543123150862273f,0.18013910571872402f},
{0.21411156360045483f,-0.3510688074108283f,0.18711924296724766f},
{0.20428916248431556f,-0.35293502341075905f,0.19157236886767978f},
{0.21188274568965898f,-0.3039826584150352f,0.1955858619164695f},
{0.2694004060721326f,-0.2717286531363908f,0.18533947084130367f},
{-0.3500886315575919f,0.021596962243320895f,0.17585818125081934f},
{-0.3760820673360031f,0.028082357422206335f,0.17211384284661477f},
{-0.35928534565410786f,0.018323301309417207f,0.17687286251615997f},
{-0.3621962442535669f,0.012625358550750657f,0.17284423228087262f},
{0.363004121463961f,-0.16425283247178768f,0.27130182123646857f},
{0.36738864450478415f,-0.16414365094582012f,0.2603162769250082f},
{0.3662916425701731f,-0.14671611718901903f,0.2583898765849663f},
{0.36319646508618586f,-0.14635639334091521f,0.27139900711583703f},
{0.35920441142703136f,-0.14772849727904003f,0.24648563211707558f},
{0.36678348532889377f,-0.15642459419072047f,0.25342230201240135f},
{0.35864861490528455f,-0.16302573657584826f,0.24573459372459427f},
{0.3619811226078646f,-0.17399324651470918f,0.2557349513363757f},
{0.352904956738491f,-0.16414105760835235f,0.27868640332751143f},
{-0.4248027371241659f,-0.5024721334693967f,-0.19223068986804764f},
{0.2765757841289828f,-0.5948845582333475f,0.1680136615700416f},
{0.30008335667624797f,-0.5675280766058121f,0.16623516645828698f},
{0.3166731638127842f,-0.5670427166595567f,0.16225565664816222f},
{0.3205334215332966f,-0.556313105327468f,0.149308432620465f},
{-0.1896033643807868f,-0.529671530665154f,0.32929628918231524f},
{-0.21842941948870123f,-0.4968449513206043f,0.3127607880834692f},
{-0.2276118080782875f,-0.4782109897494279f,0.30823397251482676f},
{0.2905995438672114f,-0.5990433429872083f,-0.13388196947432612f},
{0.292364036444011f,-0.6442404172165993f,-0.13642181683359564f},
{-0.0026662228932576126f,0.807355918222049f,0.21396076065486178f},
{-0.013028872192823084f,0.8145532222513121f,0.2203872283220771f},
{-0.32049281418192715f,-0.7893053821501642f,0.08566579465951062f},
{-0.3271321533151002f,-0.8372541223586413f,0.08538195860137898f},
{-0.3221422490551541f,-0.7677798556768816f,0.07054325664081017f},
{-0.3140042987112995f,-0.7311816117368088f,0.08683509769532251f},
{-0.31037022548903015f,-0.7406478958793642f,0.09153342731863832f},
{-0.29677107403117436f,-0.7035576466321757f,0.09640357803248509f},
{-0.29885239042865136f,-0.8065756699891997f,0.1023366422639047f},
{0.08340045594899208f,-0.12027831553216548f,-0.3244462445363003f},
{0.0826517378551711f,-0.08209738567684387f,-0.31617357981954536f},
{0.05295037663788509f,-0.06113422034317508f,-0.32602106757133653f},
{-0.03156151936787581f,-0.02413167286082205f,-0.33146166009861106f},
{0.18968650629129574f,0.3711423602515365f,-0.2813081357688488f},
{0.22268538905952281f,0.37021322406317414f,-0.2824490703912792f},
{0.290318382951949f,-0.6379373970874438f,-0.11543206474444519f},
{0.2901524837225591f,-0.6026580846369405f,-0.11244816704185326f},
{-0.04312968387350655f,-0.5169447158868367f,0.2198016047010237f},
{0.16436066102140734f,-0.9819280765964629f,0.2155285930464987f},
{0.18586983597606385f,-0.9903103276165615f,0.2118090363669041f},
{0.17652367509752626f,-0.9769472293631094f,0.20297535870604816f},
{0.17465824846659933f,-0.9687612943080426f,0.20214638526374198f},
{0.17120772531709938f,-0.9949510662372338f,0.21637610656752257f},
{-0.3185705476706796f,-0.9904304508805791f,0.255857223851396f},
{-0.3118879855381054f,-0.9871921309425234f,0.2625985509472452f},
{-0.31133253323648946f,-0.9760100677461392f,0.24869473280129867f},
{-0.3215990165681855f,-0.9861789391729345f,0.2439337476773023f},
{0.10189968296151983f,0.7516294381005987f,0.1276956590928901f},
{0.1034816188168538f,0.7660742598019252f,0.11766531077099918f},
{0.10105233092648339f,0.787667346912754f,0.11652470124535906f},
{0.11185909750106346f,0.7670821820287697f,0.11160749223991172f},
{0.2943842580178825f,-0.6208188455192637f,-0.09923705684990787f},
{0.3012275932621563f,-0.6513640422017303f,-0.09364497240557462f},
{0.3060012231639247f,-0.5912503638965876f,-0.08426015900604067f},
{-0.12491332511871471f,-0.15219715664408343f,0.3699521405307327f},
{-0.05330838363496555f,0.7379785526943641f,0.18315544723106217f},
{-0.013682679022400062f,0.7228249434968099f,0.2040590677941224f},
{-0.23737191809962563f,-0.9463530748038754f,0.314196480316333f},
{-0.23073061244959356f,-0.9475171901023439f,0.32364716087536155f},
{-0.227276542982819f,-0.9430497471942446f,0.3182102570280084f},
{-0.24364257728684427f,-0.9627424523323338f,0.32420778072857237f},
{-0.24174183090822554f,-0.9533867276586776f,0.30386845594975065f},
{-0.23182366328955392f,-0.9524981998840925f,0.2883505237406767f},
{0.15815822966384036f,0.31855288248479463f,0.22869004523492886f},
{-0.44704738725927373f,-0.42910850971716885f,-0.06828157845640602f},
{0.286848588787157f,0.10116034221024654f,0.26789672983220986f},
{0.29453027959712f,0.10331544070541339f,0.2517880457595767f},
{-0.07369706469348404f,-0.28960636839199416f,0.28336943321593444f},
{-0.12783344329316151f,-0.2790922016775824f,0.27960046394902915f},
{0.3254269728415985f,0.20354305419528324f,0.2860616032951713f},
{0.3229979080568684f,0.21753676266615699f,0.28575709915547565f},
{0.2790825204864006f,-0.7662590964505545f,-0.2478509058353806f},
{0.2695739652618431f,-0.7709554393712631f,-0.2503967313634052f},
{0.3432248077786743f,-0.15264401386884371f,0.28018025282638204f},
{-0.41281141877445615f,-0.09006487693698191f,0.18919067153522343f},
{-0.4214324586990729f,-0.10957739664784065f,0.17674351755233877f},
{0.2759417901426818f,-0.41191879169933066f,0.17156714478536522f},
{0.28122408178123387f,-0.3980732519338815f,0.1777865470453124f},
{0.27966822591285545f,-0.3840001093557609f,0.17273508050232378f},
{-0.48124724556498777f,-0.10022037477424656f,-0.00988733601277932f},
{-0.4799906041078118f,-0.10630438378270197f,-0.0033556580999956473f},
{-0.464180852908311f,-0.10407828244867999f,0.030475208974275213f},
{-0.44641795206489154f,-0.08740269756785463f,0.07802716005092246f},
{-0.4394133571261404f,-0.06991980173999868f,0.08983928526229758f},
{-0.3873090756948509f,-0.026742139529726774f,0.18889683609477037f},
{-0.3938758502496859f,-0.036365184069677876f,0.18530172986620955f},
{-0.3945588222985029f,-0.044218307128912795f,0.18867026594249175f},
{-0.40759275473973205f,-0.06399571485458587f,0.17768583609682562f},
{-0.4133474364499771f,-0.07342552441215841f,0.17867909815827945f},
{-0.40842065302533304f,-0.08111183457128558f,0.18282742669445992f},
{-0.4201238612502856f,-0.11452582131960415f,0.1616076388787499f},
{-0.4261382846719064f,-0.17128316317736347f,0.1322370349605885f},
{-0.43593255960364524f,-0.20272548038879407f,0.09762742189811364f},
{-0.4407348012101838f,-0.22454353554092166f,0.06959706561985061f},
{-0.44702266502950117f,-0.2597242034261315f,0.031183541759959455f},
{-0.2680748483450432f,-0.1432739424401015f,0.2951159249975336f},
{0.4247696250599063f,-0.584355153403696f,0.13504523484654551f},
{0.4084707041197384f,-0.5563241288709195f,0.1373371449076324f},
{-0.27424534478620566f,-0.9841979480699088f,0.31919167430477235f},
{0.06847073113676919f,0.3310807868982045f,0.17479528366936367f},
{0.3460808319522638f,-0.2451880730854493f,-0.12309418069048211f},
{0.34322043065849106f,-0.2379046077826773f,-0.13002862165421944f},
{-0.34346288805718206f,0.18910354134579035f,-0.20033400890447228f},
{-0.34306707527813096f,0.047489181367126945f,-0.21081729461102844f},
{-0.32394301329704467f,0.04563868900280569f,-0.22184772246529935f},
{0.29065855212187525f,0.628824239240483f,-0.08776094679391616f},
{0.2709826245279444f,-0.8304847083874806f,0.08683729900430784f},
{0.25866212018026336f,-0.8227111830462954f,0.09553327692631336f},
{0.25725072521404746f,-0.7893998928866633f,0.09745749401830271f},
{-0.2608737759552729f,-0.10164986573271491f,-0.23723789269819112f},
{0.20788114735872631f,-0.9585121770944325f,0.20384518279111252f},
{0.3470256928386435f,-0.3358493809869466f,0.25659697416088056f},
{-0.16365223899346687f,-0.5287985650401912f,-0.3013839897848767f},
{-0.18113909547764395f,-0.5035829148333224f,-0.2998507483291729f},
{0.4159343559121489f,0.12523554437746243f,0.19554641896406144f},
{0.3020617735651465f,-0.5566653710727354f,0.1685412501019865f},
{0.30961959187392507f,-0.05399049353984369f,0.26521935165693195f},
{0.3051367684879394f,-0.05968365440095088f,0.2731814533222424f},
{0.21918057793326529f,-0.9089972884106996f,-0.20249727306607795f},
{0.22794202673665165f,-0.8958476895062218f,-0.18900274434227085f},
{0.132526107095619f,-0.9125013080431376f,-0.2307189604919215f},
{-0.2443695425807258f,-0.9710828795441191f,0.34222880098663944f},
{-0.2589602222504871f,-0.2603366570940554f,0.27743328906426945f},
{-0.2557491360742703f,-0.27729407114465654f,0.26276799649390975f},
{-0.2568353588192264f,-0.26488937097791765f,0.2646580444258671f},
{-0.2557954591796653f,-0.2699757514288141f,0.25361231683670343f},
{-0.24644759738622157f,-0.28642608354304705f,0.25456737046362615f},
{-0.21777137258954876f,0.8076033190042868f,-0.14209994249935518f},
{-0.19575272528094825f,0.8247428233793244f,-0.16261924978551542f},
{-0.21452835043451962f,0.8431724849907658f,-0.14395242050387602f},
{-0.22878686617721405f,0.8389152585915034f,-0.12795099287425607f},
{-0.16350992627989908f,0.7286593833486844f,-0.16839299959116052f},
{-0.12624970346936365f,0.7257031358717934f,-0.18401030623969442f},
{0.3616553203787727f,-0.0038453186730716222f,0.27789364205545863f},
{0.35538395150313606f,-0.006146639542552452f,0.2848303533846891f},
{0.3419469712856597f,-0.0038398069013458216f,0.2862963391138888f},
{0.348733325349374f,0.008327401560812683f,0.2808503368060383f},
{0.35697036540739524f,0.007550567906669288f,0.2759067142175826f},
{0.3647813395615264f,-0.0029903470492114084f,0.2689874093779351f},
{0.35988965277893353f,-0.002423202949630397f,0.25782901450277446f},
{0.3374503079131143f,0.0192329040677581f,0.28378346416413647f},
{0.33048384916516305f,0.02101433673711138f,0.274388386842736f},
{0.33596829363726316f,0.007133943620999611f,0.2748801690442115f},
{0.3315714498530507f,-0.01093668258259992f,0.2638771980574198f},
{0.2995066073476436f,0.601563321195588f,-0.056619891253540666f},
{0.27471278934953636f,0.6305008685664597f,-0.06249887149050253f},
{0.2685994376997364f,0.6478185727285283f,-0.08499507642239094f},
{0.32909026652831413f,-0.9852840890094635f,0.17626144150862877f},
{0.3328662668101156f,-0.995363799985498f,0.15712351935523422f},
{0.3391035929522499f,-0.9742894260517575f,0.03671659457665703f},
{0.3234303377835492f,-0.9628852718144277f,0.0351547339793283f},
{0.09244456366265513f,0.7740887626077203f,-0.068650441136504f},
{0.08508641534036908f,0.7829965357765706f,-0.07730372088856716f},
{0.08044276890951665f,0.7903365785449337f,-0.0768506623894114f},
{0.07974231918979338f,0.8017689397096577f,-0.07278401707781461f},
{0.0745395020299849f,0.8179448996945432f,-0.07036714129790536f},
{0.06820591324087036f,0.8326260986346561f,-0.07799921553825778f},
{0.0716230321639626f,0.8258576780147991f,-0.06632888564784625f},
{-0.1077881781228411f,0.7182543981602402f,-0.19925731170795366f},
{0.07429980157956446f,-0.038808271575111346f,-0.3063783731561559f},
{-0.25535338385246437f,-0.09706343314973272f,0.29204115318038104f},
{0.019975608402162535f,-0.7996339334710212f,0.1507636476592721f},
{-0.012520774594587123f,-0.7909871174080828f,0.14367525211716908f},
{0.046872588027165825f,-0.7777269600971138f,0.1650207153401195f},
{0.4050760274992556f,-0.5993036923958521f,-0.054840778882847586f},
{0.41411288109238176f,-0.6076770276895971f,-0.03629934240797077f},
{0.4398073255652309f,0.06956004814447607f,0.15141509913073106f},
{0.4349478584243362f,0.1414195287285481f,0.16374121724128793f},
{0.44044563611446996f,-0.01321304005573492f,0.14243056699750326f},
{0.441802987457725f,-0.02099110506549838f,0.12806681657386082f},
{0.4390037022357138f,-0.0987391700531478f,0.10210040632535745f},
{0.38326863042229253f,0.494546963224428f,-0.10028905306481017f},
{0.19865983214692828f,0.19362367011966755f,-0.24864646442720084f},
{0.4353654962470579f,-0.41311711227969683f,-0.00945559472636041f},
{0.24688655135927257f,-0.8257099045250808f,0.1170527763600816f},
{0.2293967254452625f,-0.8309637459448499f,0.13409474107394956f},
{0.23985990933361803f,-0.8334748381742945f,0.1301624648527143f},
{0.3079120199204397f,0.47986148809287404f,0.007919741872256067f},
{0.2983036047360524f,0.5003531143435067f,-0.0024424282813864636f},
{0.2875173755668755f,0.5340324767518252f,-0.009508412330706874f},
{0.2891068502680396f,0.5575317412700047f,-0.01797976430672875f},
{0.28425445451353787f,0.5846586344446694f,-0.02775546622510775f},
{0.2931738599855158f,0.5925877865941152f,-0.04109862520875445f},
{-0.31060228616487834f,-0.9164893904218928f,-0.11315056096787147f},
{0.24646267189065835f,0.2565819835866609f,0.18035426773592325f},
{0.24041258450121483f,0.2521937325568275f,0.17414502740669258f},
{0.24095456015974243f,0.23441749743296644f,0.16843068107141718f},
{0.2296743602289986f,0.2177629067929032f,0.17267217214858413f},
{0.23741931423691034f,0.21021892953309224f,0.1622944313460569f},
{0.2278392079710669f,0.19702377776888275f,0.18511079393433497f},
{0.23754948894123223f,-0.7668146486185048f,0.147793995783024f},
{0.24536629783906377f,-0.7220434384355197f,0.1331838113682522f},
{0.24223193131813556f,-0.7172459383550436f,0.12554045010731085f},
{0.24580539523716924f,-0.7118473321844777f,0.1154341927472915f},
{0.36415145815586336f,-0.2781464483686412f,-0.10993121775814403f},
{-0.2017650206997227f,-0.04891116428959183f,0.33836311329980273f},
{-0.18204339894582128f,-0.08240580160210133f,0.35498659876396216f},
{-0.25968799816152877f,0.8477320673411292f,0.017558005404106247f},
{0.15860685048556755f,-0.3996178420298272f,0.25517644036267056f},
{0.14493557959824685f,-0.40202583183080143f,0.25351209140858644f},
{0.17114326584795506f,-0.381650803775068f,0.23068388403561849f},
{0.2680687278136414f,-0.4027024814907325f,0.16159894625803656f},
{0.27442921676854204f,-0.39545581480732583f,0.17292446638120149f},
{0.27278634863799767f,-0.3751560052246433f,0.17713363688792835f},
{0.2799445634966538f,-0.3763300104774287f,0.18015448619661045f},
{0.29252227677548814f,-0.37334231254209516f,0.17839299279706256f},
{0.2890109817743574f,-0.35781147207811215f,0.18169158844230107f},
{0.27957699801649366f,-0.35936530193479405f,0.18303792686618248f},
{0.27633478647862475f,-0.3472298669030527f,0.17828409493398065f},
{0.30704920666452307f,-0.5445895934268307f,-0.09038381388679616f},
{0.3206644068547787f,-0.5560425429925326f,0.15902333400220228f},
{0.31331694847989155f,-0.559430652870333f,0.16853141220565243f},
{0.07297573334822681f,0.8290277095659578f,-0.12148691490810742f},
{0.2111493570781494f,-0.7964975802474853f,0.15101345054557158f},
{0.4431930450254556f,0.23488372766416862f,0.10369703846794728f},
{0.43319779334561603f,0.25351736520096246f,0.10220280012781764f},
{0.43227903263194045f,0.2413757692663225f,0.10906853199116479f},
{-0.16605850663137872f,-0.12474154280606892f,0.35975984301169484f},
{0.02475256576519632f,0.676039104254673f,0.1973951275456673f},
{0.0006053004761293905f,0.684430069143641f,0.20240203458022793f},
{-0.01619296913394712f,0.700219759958846f,0.1960548884050314f},
{0.3996640477391591f,-0.3990057123962858f,0.10856247846555807f},
{-0.43888252612555495f,-0.23837116204826195f,0.08477506770075585f},
{0.1613528208963765f,0.4050803700911847f,-0.3154121468290368f},
{0.1853957842985538f,0.41942731747288114f,-0.3007558114189354f},
{0.11478423024038034f,0.3492822369372987f,0.17198278634380937f},
{0.10659652202667617f,0.1866279515981811f,0.29146902426334875f},
{0.08690496216420773f,0.17611613492984823f,0.28128025393824496f},
{0.07700492028520735f,0.18002972658490352f,0.26886191564243045f},
{0.09866247642685057f,0.18897668985310276f,0.27809934014387344f},
{-0.37929234289505975f,-0.3054530010786696f,0.2513520899013697f},
{0.1554338197571571f,-0.9684495551711508f,-0.3234051698736997f},
{0.14818233080469426f,-0.9771832623817646f,-0.3141703801436291f},
{0.17261322391996167f,-0.9850431933502554f,-0.3118537382910993f},
{0.15005507211340305f,-0.9586614815138076f,-0.32575074852779f},
{0.1373747334272057f,-0.9619633493751053f,-0.3251284867109508f},
{0.11939698503929908f,-0.976233780021405f,-0.3204241597955393f},
{0.10738588890577136f,-0.9761245177524438f,-0.31382411169045726f},
{0.26916151517646447f,-0.5988731271948805f,0.16407613705421772f},
{-0.2863494515364029f,-0.4828366528032559f,0.24357203925140666f},
{-0.2773562055343055f,-0.5515402456713631f,0.23440894186286076f},
{0.3545868534823969f,-0.17693198657327522f,0.24439864033706982f},
{0.3520925398595186f,-0.15460247130218846f,0.24165414986034234f},
{0.07693109887842832f,0.04830994664668182f,-0.30903398790741615f},
{0.0847887095482589f,0.017224191557708147f,-0.3031442677898883f},
{-0.2671181532980517f,-0.3721164320406921f,0.28430302832988147f},
{-0.047749148840162514f,-0.7260368711000136f,0.20955716845623093f},
{0.09876954057404991f,-0.5325128426153706f,0.19847062953339806f},
{0.45015018220726905f,0.33234914033909396f,0.010815664771204873f},
{0.43265346657860165f,0.32601450720310077f,0.036499539348737814f},
{0.43342551833518567f,0.3402562443392289f,0.005843151064724462f},
{-0.3790329666519712f,0.6019648284805084f,-0.024787779803310817f},
{-0.22264036315406543f,0.3363979318874193f,0.2030209721230251f},
{-0.2112290557249412f,0.341267490840115f,0.19320373855848075f},
{0.07883099426839012f,0.7873544125670744f,-0.06665406955559187f},
{0.08581257957876072f,0.7754262968580682f,-0.0652733537397474f},
{-0.3193201061290796f,-0.7139398559219577f,0.06932062179527106f},
{-0.3220273528375687f,-0.7357197345117886f,0.04296200670464427f},
{-0.32487154178813876f,-0.7449433392124203f,0.008990642571755412f},
{0.4660581328231905f,-0.46549001183962674f,-0.016832452050206156f},
{0.45701114704676604f,-0.45659711238013684f,-0.0004906629548460952f},
{0.06220772128579297f,0.7228080437757533f,0.14861071860085626f},
{-0.2627996897125371f,0.7706022100221104f,0.03766378107373593f},
{-0.258448237302069f,0.762253394038246f,0.04531484372890249f},
{-0.25696370936933605f,0.773119179491568f,0.047545367866643554f},
{-0.2471776213521923f,0.7703007656169117f,0.05995700343157563f},
{-0.2464639903387523f,0.7565745799322248f,0.05974066957856038f},
{-0.24712274692632286f,0.7786786798883241f,0.04326872915185027f},
{0.1512384594895713f,-0.2582089559715303f,0.28023154056348004f},
{-0.1729046997526654f,0.2153032032292986f,0.19694814814400868f},
{-0.1382956635776322f,0.20178447816758563f,0.2214738154729126f},
{-0.4499428437611933f,-0.0863394950753571f,0.04437764280284345f},
{-0.045726213876740654f,0.8224421909501054f,0.20093385922852888f},
{-0.01787985706975128f,0.8054527803634467f,0.21894108093394077f},
{0.2528364951260005f,0.27780598597415895f,0.2058165389176961f},
{0.2418384685851633f,0.27246987381828636f,0.2016394350659424f},
{0.24876492555419757f,0.2694732590941913f,0.18816280897616608f},
{-0.06971833469069294f,0.5012569216672362f,-0.3403347817742829f},
{-0.04835634146460416f,0.9487419858853713f,0.14059498977644697f},
{-0.07466897873237462f,0.9675508240319444f,0.12802387723734526f},
{0.3186617341331368f,0.45958773831139865f,0.013457218555080546f},
{0.2925951653882086f,0.45899943848506813f,0.022591106103258287f},
{0.27592339030179514f,0.4892880551818059f,0.008792138046631993f},
{0.2703011727847056f,0.5166011735721091f,0.0026857515424438916f},
{0.24044837064593585f,0.546489011795685f,0.007777963549817457f},
{-0.37688021926529114f,0.4525300516670857f,0.0719432870306669f},
{-0.38571601536732314f,0.28850909235616756f,0.11820628882859185f},
{0.14243247136350531f,0.3684326827539747f,-0.28943121346575085f},
{0.09271296824732533f,0.07761767302093003f,-0.33307125574131624f},
{0.2126438950172819f,0.5486145243581184f,0.0191121879801816f},
{0.24053246553625157f,0.5893066282482862f,-0.007407824917937943f},
{0.46909247789830144f,0.15000749802280988f,0.05831577247146875f},
{0.47078876176879f,0.1922681025591279f,0.06709527158357179f},
{0.46447366418763386f,0.18639370129983343f,0.08856162087934857f},
{0.46073320569675663f,0.21416097246933816f,0.09236817494739975f},
{0.46824974627483695f,0.21089841582187976f,0.07564243485620344f},
{0.4879221466748337f,0.21590511993654848f,0.04884441851883714f},
{0.48475989619848603f,0.18648107903028657f,0.037559594989297826f},
{0.49843911070901287f,0.2280246677218773f,0.024368292328589197f},
{0.49075498804756945f,0.18540588089118984f,0.003546815012695028f},
{0.5016184638263094f,0.26280711116230404f,0.0218088382331593f},
{0.49667117274368067f,0.2694755294596844f,0.03984690907419239f},
{0.4598565928257772f,0.20175489329725999f,0.09627720249849694f},
{0.04708035781081293f,-0.9702185056111273f,0.2005952613597558f},
{-0.19696855434204716f,-0.5392556687686418f,0.33060050951091935f},
{0.07820273515945518f,0.21900094548930052f,0.2771262308961951f},
{0.2792507506385287f,0.4528525306845434f,-0.2532534439772566f},
{0.3608468344087027f,0.49235575455015756f,-0.16814430160898494f},
{0.3756441247751887f,0.48567744736086815f,-0.14528375347982847f},
{0.27855610697749517f,0.4573482208915336f,0.023580124907913207f},
{0.05765546317488183f,-0.6209940865005397f,0.22315234863368744f},
{0.05027078015509696f,-0.6367150830890638f,0.21433916694433003f},
{0.06309557974345677f,-0.6045979000004175f,0.23644302360904046f},
{0.3517482166750497f,0.1336956093328954f,0.2616802353824426f},
{0.3485039791254841f,0.12642462625950018f,0.25018422536573454f},
{0.33194134519354135f,0.12114306343270669f,0.23740782482763326f},
{0.3251269063793313f,0.11526720348748702f,0.24941997486971f},
{0.3326020672355632f,-0.0016691462565567622f,0.277804481604698f},
{-0.3222089162077307f,-0.7696181887838007f,0.04406687364428363f},
{-0.32047595483236724f,-0.7754956699633406f,0.01982601660147449f},
{-0.31681774689184505f,-0.7949153809150141f,0.002007284102747452f},
{-0.31980781612141373f,-0.785730844136833f,-0.02322101619393221f},
{-0.1035670714643525f,0.7535333047709597f,0.21727896091144508f},
{0.09351420965852912f,0.093691017160123f,-0.3239518477492008f},
{0.07446610664873839f,0.11382247441377902f,-0.32184226280467665f},
{0.3193072988029126f,0.11222471293168558f,0.22730732359313638f},
{0.09683764864803063f,0.14230854308591082f,0.29451714876777435f},
{0.3191130906549786f,0.4330680292619132f,0.03420830391661117f},
{0.4473613532029383f,-0.08571099267503335f,0.09819059896692664f},
{0.44823731800515293f,-0.05009505737187843f,0.11194326835353756f},
{-0.06984346614513391f,0.8789119273268181f,0.1793243993509179f},
{-0.0770833621035582f,0.9206483462234113f,0.1637794341750816f},
{0.36813925687173293f,-0.5652379397033623f,0.07449346843071841f},
{0.05162434295209627f,-0.07603023601794846f,0.3767407628351244f},
{0.06039635846357535f,-0.06606116525380655f,0.3761147528435264f},
{0.0618019781809281f,-0.07451839251797517f,0.3791459170696499f},
{0.07584023659855965f,-0.07563695601911981f,0.3785887829764685f},
{0.07391487954298856f,-0.0690155492673963f,0.3742304206655947f},
{-0.24017521497353275f,-0.27465312824527244f,0.2518889596279555f},
{0.13328601128128678f,0.7216699872160838f,-0.020035878266102373f},
{0.11837420928884307f,0.7166735363992036f,-0.017609878527908348f},
{-0.2853007179758895f,-0.8423408268439202f,0.13228575910763743f},
{-0.2920022674608701f,-0.8460259243261504f,0.12284533078398946f},
{0.31227020055957777f,-0.5698665211914484f,0.13058101422133836f},
{0.30855434318398267f,-0.5690198172251769f,0.12451470492702177f},
{-0.08120562127686115f,0.9779021714372118f,-0.08796362551933078f},
{-0.10210582194917635f,0.9008499049478871f,0.1729172632562398f},
{-0.09910710153279897f,-0.7891001504587787f,-0.3703078909736217f},
{0.4631223908794681f,0.16036255429374693f,0.07905084734728075f},
{-0.2056776402516304f,0.9457938233319256f,-0.06069674949142898f},
{-0.2556149497180523f,0.8851053005953846f,-0.018024136831381963f},
{-0.25774366331522175f,0.8653957966649806f,-0.04897035952803041f},
{-0.252097758353568f,0.8537672002782185f,-0.08059488924079578f},
{-0.22426347474894795f,0.8684436375065206f,-0.12452068203336902f},
{0.30694442244448716f,0.10901524798978904f,0.23838833055849498f},
{0.3187296177426575f,0.11720296576516351f,0.237428595962755f},
{0.44729391580469835f,-0.48546203355301776f,-0.022670615641459755f},
{0.43705031142522205f,-0.49225138573157595f,-0.03929927396925316f},
{0.4365472007692531f,-0.5338259382988316f,-0.04696450489499327f},
{0.3219035802027187f,0.23101868804609685f,0.2751790201119424f},
{0.3260748471859563f,0.24304550887764192f,0.2738728141431387f},
{0.1841720519857455f,-0.9943350460662871f,0.19067388208227018f},
{0.3057196574712861f,0.49800271448276806f,-0.20622843017656584f},
{0.4215539992151111f,-0.5748723328835554f,-0.06880136572779141f},
{-0.3494047065289681f,-0.5235192725788906f,-0.2373591304280031f},
{-0.355300708663885f,-0.597325943761467f,-0.2167606525117332f},
{-0.18724250830236774f,-0.5577998207578847f,0.33816730304088916f},
{0.008901470965712751f,0.9618601353938144f,0.09024821984022799f},
{-0.015497852701437291f,0.9611410945997985f,0.11253181678329592f},
{-0.15482124497474267f,-0.4162787550587764f,0.366813578561357f},
{0.45650009382999884f,-0.4846081965807001f,-0.020530522594221893f},
{0.4653159092283207f,-0.47701039880356866f,-0.002407995644217222f},
{0.23793208961674003f,0.3514352276153676f,0.13921852890388736f},
{0.4618893380629299f,-0.10488299899583502f,0.02452120680970748f},
{0.4405895084427049f,0.14431417567571533f,0.15739472975893454f},
{-0.04723496789479818f,-0.40275338463620275f,0.28372907525863683f},
{0.22774647995487537f,0.5212613659422172f,0.023118595831276734f},
{-0.3838755330094014f,-0.006309317551457996f,0.18665758215204256f},
{0.23930204642867794f,0.26065995629034344f,0.1917865481576534f},
{0.1641875873520667f,0.2791763879349698f,0.25267892464264846f},
{0.15462016623549213f,0.2922948614777955f,0.25256297451651416f},
{0.14987083360037173f,0.30081741832310605f,0.2473255472974319f},
{0.1488548870073278f,0.31223446062959653f,0.24098913144113107f},
{0.15183257387385396f,0.32423696507115296f,0.23916465744411233f},
{0.33323008411551697f,0.26631242799467975f,0.15807047849704145f},
{0.27984897866585723f,0.07042353071731386f,0.25709262777642095f},
{0.2874482765628185f,0.08181674215418563f,0.2564909947320567f},
{0.28352969902790415f,0.05765051501049991f,0.2533954528421903f},
{0.29103321023658474f,0.06942606364574226f,0.25851774161470614f},
{0.22413319805347623f,0.21168254503046455f,0.18821790650767595f},
{0.22915830094662365f,0.24458871996824832f,0.17727400433279333f},
{-0.3170991914699931f,-0.8078915215585236f,-0.020022630040693535f},
{0.15779303547791532f,0.2845919341980893f,0.24462662880377672f},
{0.15693543014509045f,0.2980180119866045f,0.2349484867323158f},
{0.05905977719303434f,0.038402154502696816f,-0.3181222705378794f},
{0.06531580596228148f,0.045718852984218974f,-0.3157715455803503f},
{-0.4327714034073434f,0.11320207712264886f,0.1464591568612937f},
{0.17858175026171982f,-0.3678707561391558f,0.24080971519715605f},
{0.1827729968862596f,0.2597457341828383f,0.24349126757272518f},
{-0.2617906732056472f,0.8614549701856787f,-0.016910574083805842f},
{-0.25869881893329433f,0.8737958398286976f,0.0065410478184767815f},
{-0.15228941242000268f,0.21211400159158988f,0.20960600521850783f},
{-0.2992835845750474f,-0.8016504270558821f,-0.06776556060793565f},
{0.3695622225214235f,-0.2662149488907554f,0.25387177382278564f},
{0.49960821082493284f,0.22796647008437368f,-0.000479923074280101f},
{0.34148134981413353f,0.007983727507516546f,0.2799080278232218f},
{0.2899896431652584f,0.0921153835079266f,0.24911257248150467f},
{0.29695427775899724f,0.07849752836055018f,0.2536289732663714f},
{0.250718601089983f,0.4991724233583639f,0.012115348618454092f},
{0.24838299313320306f,-0.7689501318782488f,0.10835850254020565f},
{-0.05224502709333545f,-0.8102607674714297f,-0.3598172704035353f},
{-0.38672029034815053f,0.5966205697815375f,-0.061151266676509844f},
{-0.18286586726509785f,-0.3927035018218826f,0.36176581982163036f},
{0.35313815312828956f,-0.2513181225988219f,-0.13121107729873716f},
{0.44708665703920863f,0.08808280217798845f,0.14524395568321138f},
{0.44907567250843416f,0.01569111265039955f,0.13055729596694765f},
{-0.37998783754475035f,0.06484481986251125f,0.1572884262957282f},
{-0.4040328067728757f,0.07293673076385651f,0.14732995411191344f},
{-0.37055324608961854f,0.053367553906820686f,0.15887569118864442f},
{-0.4102823314815011f,0.08268978852214215f,0.14236146799344623f},
{-0.40108774432542366f,0.07648273675300309f,0.15037984115089822f},
{0.35467714964710806f,-0.24981892387662064f,-0.14398285636285857f}
    };


// normal array: 117kb.
const tgx::fVec3 buddha_norm_array[9996] PROGMEM = {
{-0.837390739307244f,-0.1576478584422916f,0.523377399637228f},
{-0.7762285512539793f,-0.1936818085698454f,0.5999638266156239f},
{-0.8787110763409769f,-0.21492045573787796f,0.42623472643732857f},
{-0.7441523284278357f,-0.3038522119662711f,0.59490431615398f},
{-0.7225530201965384f,-0.6100020583571057f,-0.32529159504197935f},
{-0.7671787900589047f,-0.4706666578251629f,-0.435786187591399f},
{-0.7557338315698512f,-0.43499238445658095f,0.48953855954922476f},
{-0.7861974904210098f,-0.17246609017652123f,0.593421396475498f},
{-0.8005518879885759f,-0.15244248140646485f,0.5795497946687292f},
{-0.8068644780102048f,-0.15052500624466758f,0.5712371982113582f},
{-0.8794470227932449f,-0.1272317056968864f,0.45867747619166865f},
{-0.7208889965042993f,-0.22888190709101167f,0.6541652140899925f},
{-0.8078746081495763f,-0.2555320420113017f,0.5310762591311182f},
{-0.6528938395045061f,-0.753487086201457f,0.0773747068795871f},
{-0.404896325553279f,-0.9129516085266466f,0.05077721971575234f},
{-0.5449839026827134f,-0.7961973335292278f,-0.2627971687398221f},
{-0.7772100232700806f,-0.5792513251723762f,-0.24578950753554732f},
{-0.4447450069432087f,-0.8953708069092807f,0.02264943561568144f},
{-0.23237771219133835f,-0.9251661237387117f,0.3001137157195693f},
{-0.7560136181611352f,-0.3416748821360413f,0.5583025022980208f},
{-0.897498413159831f,-0.19395726463492682f,0.3960772372542027f},
{-0.8421138208498832f,-0.14727497046078653f,0.5188009211724524f},
{-0.7301828695592476f,-0.1977140324411656f,0.6540199831641816f},
{-0.7307452949451562f,-0.2192118534638599f,0.6464963087415551f},
{-0.8459956157871619f,-0.11780582961443249f,0.5200126965543783f},
{-0.7838848758009975f,-0.17986778580291932f,0.5942828292326893f},
{-0.6519638065725913f,-0.21715609384727644f,0.7264891092262633f},
{-0.7561918838666654f,-0.19665392862619024f,0.6241002060006622f},
{-0.7632372186752535f,-0.20191994244069442f,0.6137566984348195f},
{-0.9000391531770471f,-0.13110159418046777f,0.41562229818873275f},
{-0.8927290319967927f,-0.44691428339850425f,-0.05746737095492364f},
{-0.5970171591071294f,-0.7592894016216551f,-0.25894037212586546f},
{-0.40636875009625845f,-0.9117975798180558f,-0.05907294120950061f},
{-0.617019770753875f,-0.7749935116701604f,0.1366442804071513f},
{-0.7275682824706893f,-0.6175286025822707f,0.29883577318560667f},
{-0.8022512042678565f,-0.5226669683298323f,0.28846532801651587f},
{-0.5650488437459124f,-0.6395843718840816f,0.5212021061191643f},
{-0.15872316693170166f,-0.9809677499243672f,0.1118446685698303f},
{-0.7900798200536612f,-0.45064858354037207f,0.41555954097701897f},
{-0.9151706610123416f,-0.2699154329876116f,0.29934648863373037f},
{-0.8725037099700419f,-0.39834977375568204f,0.28293945259950937f},
{-0.7946137895802238f,-0.18689200998259908f,0.5776333629679123f},
{-0.800729508490769f,-0.16896017658667756f,0.5747040220495505f},
{-0.8460665721413246f,-0.15748952696015348f,0.5092822443428554f},
{-0.6781974453191977f,-0.26292671499522663f,0.6862344844907845f},
{-0.38465248971143684f,-0.46614001719521814f,0.7967157250412688f},
{-0.7926408319738871f,-0.196944035820013f,0.5770039499368f},
{-0.7967183399598762f,-0.15879140115887694f,0.5831167787755551f},
{-0.7553285204095758f,-0.18598950015321103f,0.6284001369260193f},
{-0.8281240304627577f,-0.15005513405986495f,0.5400870734542657f},
{0.9985071858077273f,0.03771503510289924f,-0.039509189026349326f},
{0.47008137730916943f,0.2843034193888688f,0.8355806749984774f},
{-0.133452650951815f,0.29750304316181375f,0.9453477292845174f},
{-0.14125004978518202f,0.15404802492146089f,0.9779149397843764f},
{-0.29762824043784086f,0.1884034949081424f,0.9359068081813874f},
{-0.3644364320449184f,0.262602134802776f,0.8934350596408193f},
{-0.25948204603359276f,0.26492060278165813f,0.9287013201282872f},
{0.3658974778513933f,0.34136333791743245f,0.865788719739324f},
{0.9983747496809896f,-0.006756964226499824f,0.05658800786264563f},
{0.9718718683563417f,-0.21376169429689293f,-0.09884841702766718f},
{0.9948507121172847f,0.05599367184145177f,-0.08447940171096888f},
{0.9759778044980362f,0.2129586376908363f,-0.045999388692199536f},
{0.9865242700299705f,0.15786870117440618f,0.04298066811183773f},
{-0.1046783344480045f,0.48741374188328807f,0.8668738607897479f},
{-0.19632532030317879f,0.08716822207731227f,0.97665657713842f},
{-0.24516677718969124f,0.12689254276146555f,0.9611407461729785f},
{-0.23199781270003583f,0.1652722722852042f,0.9585729450157063f},
{-0.2871161509586057f,0.3003891545679477f,0.9095771939075148f},
{-0.3647958253370258f,0.28338563562856117f,0.8869140811465757f},
{0.06695141966708822f,0.044762924388681825f,0.9967516180095893f},
{-0.002472455912509727f,0.16447915706315044f,0.9863774601305304f},
{-0.053019446517182905f,0.3669998933755834f,0.9287087899623445f},
{0.770008366322339f,0.41274869413626464f,0.48654458303675596f},
{0.9735903982598186f,-0.19276364714853605f,0.12232707285912829f},
{0.8975542496915297f,-0.42587405006722934f,0.11413878543251696f},
{0.9906338890413687f,-0.13333337936797668f,0.029439901988431008f},
{0.9819604500943723f,0.16681207258143282f,0.08903598649728392f},
{0.9252041437886754f,0.3649736215241379f,0.10388237534740571f},
{0.9153172112714174f,0.36384028079679004f,0.1726692005542053f},
{0.9785796878107239f,0.2021544734128884f,0.03892766989461082f},
{0.9831466423141709f,0.18276901379915755f,-0.004262311726661448f},
{0.973326987515622f,0.20310658204992646f,0.10668782358714007f},
{0.6040462158480773f,0.44029402123072897f,0.6642810730316591f},
{0.6064293087251105f,0.4717446943669832f,0.6400784614840483f},
{0.7380051836111258f,0.2719007813866833f,0.6175907334508991f},
{0.8290914311898478f,0.20862196843918518f,0.5187333351656989f},
{0.9286476819443562f,0.059662517199333125f,0.36613367348662823f},
{0.8183183345477076f,-0.3056843409305531f,0.48673626026105693f},
{0.7819530320622601f,-0.029052020292934234f,0.6226599680126682f},
{0.8446050078869657f,0.21392525333935788f,0.49079360900071856f},
{0.7390154005059622f,0.2851087299360453f,0.6103845099027886f},
{0.9368896568680406f,-0.12669131381288046f,0.3258635939439251f},
{0.8388629284907229f,0.15126080080394533f,0.5229045394181594f},
{0.7566320660989845f,0.26394519897738844f,0.5981980010728628f},
{0.9398960185911663f,0.07444672851816178f,0.33324639360301755f},
{0.9741153173065498f,0.02573184605414417f,0.22458232496660477f},
{0.8856100348810618f,0.31608669302828457f,0.34027058146188216f},
{0.04875542506536556f,-0.9960885585784236f,0.073691871979574f},
{0.5738156384296769f,-0.7588464305676484f,0.30803848445978527f},
{0.037189505193955655f,-0.9992924593201904f,0.005614396604649925f},
{-0.26077488464343934f,-0.9600095936691401f,0.1018726636660378f},
{0.17434846532659445f,-0.8289348372814915f,0.5314787372787066f},
{0.9373242722072785f,-0.09203260291802064f,0.3360851212583348f},
{0.7315040197571154f,-0.6520923716784212f,-0.19919188707874996f},
{0.825977561990628f,-0.5636964410902799f,-0.0027183432768547815f},
{0.9691278622809694f,-0.14146032841143388f,0.2019409865194477f},
{0.9673661485055866f,-0.12325855127006485f,0.2213821679003805f},
{0.8137819963579234f,0.18631472560057705f,0.5504958541425126f},
{0.7945184115641187f,0.08658043455248934f,0.6010360405485945f},
{0.8789211494155842f,-0.0516113160187087f,0.47416651628811307f},
{0.9686152465555363f,-0.06689323083982056f,0.2393946528391311f},
{0.9417682793693304f,-0.07776584140752374f,0.3271467283710945f},
{0.8963229704026604f,0.1848736297128515f,0.4030221752774243f},
{0.1780298803917501f,0.5791263432598696f,0.7955614622580399f},
{-0.225708133954464f,0.7065192686986146f,0.6707356865594439f},
{-0.28192928111362864f,0.2621904926638802f,0.9229149614170443f},
{-0.05608437523579562f,-0.9978631989449028f,0.03351983063584268f},
{-0.005040450160373819f,-0.999742159890301f,0.022140632331901725f},
{0.000906531303495138f,-0.9999979078512692f,0.001833710467974528f},
{0.013275610892093172f,-0.9995969817253577f,-0.025092474588937604f},
{-0.12054135827719126f,-0.9913956222633965f,0.05103431298315442f},
{-0.7901618856458923f,-0.5567617238739964f,0.25624319952221924f},
{-0.7723687314416808f,-0.37921127233350327f,0.5095540733095697f},
{-0.03407384010215501f,-0.1317838568038591f,0.9906926811613138f},
{0.8125146183251767f,-0.579527551660352f,0.0629905697263523f},
{0.7511796608193197f,-0.6474975692595127f,-0.12835893024793546f},
{0.9001564243225384f,-0.21227246212074424f,0.38034039172307144f},
{0.8513139357813709f,0.2990388570815384f,0.43109203738853635f},
{0.626297480593285f,0.5851519428802606f,0.5151200535272918f},
{0.711360309898967f,0.4574857883964874f,0.5335478075258954f},
{0.7185268329835159f,0.3633860900225492f,0.593017486977241f},
{0.7576106366556417f,0.1524730749555694f,0.6346480005797126f},
{0.6981483987206291f,0.09692989644747879f,0.7093612679999538f},
{0.7637264547690417f,-0.014730673498368874f,0.645371915676686f},
{0.36871434526165964f,-0.02822017072932886f,0.9291142844463609f},
{0.8800584814543735f,-0.10094781877890913f,0.46401142992818895f},
{-0.4025284269502056f,0.09249023050917152f,0.9107230219761402f},
{-0.6282833070954122f,-0.08761560480288548f,0.7730353108495605f},
{-0.5810978908914256f,0.20899544101898135f,0.7865406199522175f},
{-0.4362945540808297f,0.4000975900333064f,0.8059584235734187f},
{-0.379520732938871f,0.3690215342897374f,0.8484026877020077f},
{-0.38405973894654316f,-0.10718585160257602f,0.9170655975100929f},
{-0.5085627194894908f,-0.0997345735699113f,0.8552291945322502f},
{-0.7432407934083303f,-0.04100062245581676f,0.6677664801201024f},
{-0.22847888202778963f,-0.7925528734925474f,0.5653824751316914f},
{-0.41519430110515687f,-0.4779545449620839f,0.7740627528048922f},
{-0.7780945648037499f,-0.002829349239856308f,0.6281407827913597f},
{-0.7214713949574261f,0.08942519319879455f,0.6866455862230122f},
{-0.4831227768650123f,0.033973537457318584f,0.8748932399023758f},
{-0.15105400821029052f,0.00890216129695292f,0.9884854263608789f},
{-0.17103332053302184f,0.14192576816625577f,0.9749895792252689f},
{-0.1445405248724571f,0.4068012422860697f,0.9020093047990719f},
{-0.28121898066037615f,0.46261809825168254f,0.8407736794681048f},
{-0.2614936767659594f,0.38925652166866576f,0.8832329349327003f},
{0.03390830713485397f,0.04863922695958311f,0.9982406785480257f},
{-0.05507406771098449f,-0.07003083521239145f,0.9960233577508214f},
{-0.13040358727786183f,-0.10772253596203415f,0.9855915785308705f},
{-0.3293604865578539f,0.09221419438642203f,0.9396904874734218f},
{-0.6882007965161603f,0.20887834627284682f,0.6948017703869522f},
{-0.8009730043025405f,0.20117089400298593f,0.5638905193249855f},
{-0.6640716362744234f,-0.12376594978360626f,0.7373539527051928f},
{-0.6803700035665291f,0.05781926588239828f,0.7305844172576511f},
{-0.8131580530570572f,-0.09695469034363767f,0.5739109414960001f},
{-0.9913305982200477f,0.011394190127462702f,-0.13089620874579094f},
{-0.9696862523740545f,0.17578766516546035f,0.16972704184200377f},
{-0.9273065358589347f,0.37038853066924393f,0.05399004447100322f},
{-0.7805247257909674f,0.5039131663474187f,0.36993603935093133f},
{-0.4688076871804725f,0.2662349518478354f,0.8422222407744152f},
{-0.43312635741412153f,0.6515968101722548f,0.6227544905390224f},
{-0.01505388113256467f,0.06528460633616552f,0.9977531261982487f},
{0.06370427104546533f,0.08978649288364621f,0.9939216023138951f},
{0.0005563217741914047f,0.24930812826217721f,0.9684240536503075f},
{0.10756775615401687f,0.25811585304417867f,0.9601069650009139f},
{0.0031333902015771944f,0.5810129398859077f,0.8138882881274181f},
{-0.12478004610872467f,0.1608481733614269f,0.9790596535550818f},
{-0.06517495603714313f,-0.017652550919541408f,0.997717701833334f},
{-0.1999948141519696f,-0.0883233147978208f,0.9758079044440273f},
{-0.09717671577425854f,0.34400521336013323f,0.9339256389522552f},
{-0.3149725046370232f,0.48860964840142257f,0.813666352267143f},
{-0.6023070250606622f,0.2492696380985127f,0.7583474764808091f},
{-0.453862312517905f,-0.11974946417634444f,0.882988712898063f},
{-0.8027601702317007f,0.06838846861658192f,0.5923673914471067f},
{-0.8345402950135086f,0.05689519199244407f,0.5480013075959846f},
{0.9535282088896415f,0.07498785067963483f,0.29182319493515446f},
{0.896501081728276f,0.2002853463127881f,-0.3951855140467544f},
{0.9859919758899915f,-0.03762224332403216f,0.16249427770791738f},
{0.7827939048055242f,-0.12595123910467423f,0.6094013357117926f},
{0.809081392557469f,-0.26268640857914616f,0.525721552692161f},
{0.9116343198275901f,-0.243670384801158f,0.33097977352603064f},
{0.9964374031396891f,-0.0817740806882092f,-0.020627684112157717f},
{0.7179675786115156f,0.2772050352687065f,-0.6384981789201848f},
{0.9768182925700168f,0.14549964977093624f,-0.15702189406936864f},
{0.9622924133930663f,0.2542254744476542f,0.09676114544595474f},
{0.864546023743464f,0.3154236775323769f,0.3912391550973864f},
{0.7326086390325122f,0.08555771095783439f,0.6752514051155957f},
{0.768125763742984f,-0.0024655332083225387f,0.6402942544020336f},
{0.8069917240929102f,-0.15399009210148193f,0.5701327992495514f},
{0.8239201456366545f,-0.2908858201124025f,0.48635484296098985f},
{0.8177536588496815f,-0.4114653465470163f,0.40246145409082634f},
{0.9489216889918254f,-0.272177608355514f,0.15958376380689207f},
{0.9678913609265329f,-0.2379989184862418f,0.08088775088456153f},
{0.9538230972667149f,-0.23909772022190842f,0.1818069836535903f},
{0.5804194317529193f,0.2998949844686351f,-0.7570840650378103f},
{0.4502187029791204f,0.41145026571907234f,-0.7924719542845053f},
{0.9912619682138422f,0.07718926602248959f,-0.10696507646764417f},
{0.8392446533984396f,-0.11287635498515786f,0.531909146591218f},
{0.8350486521595235f,0.010178033284814545f,0.5500819540441372f},
{0.7620031557930762f,0.16828731847214404f,0.6253243710290269f},
{0.8452853068025085f,0.45769577095105746f,0.2756942715351671f},
{0.6958007374700207f,0.5098012515834455f,0.5059288661661121f},
{0.643086902444377f,0.2920275080027792f,0.7079259639780018f},
{0.7951219270840576f,0.20720169862370302f,0.5699548904585228f},
{0.9752996937423227f,0.17327922198188433f,0.13698473862253516f},
{0.983646058828145f,0.14812732844155782f,-0.1024632886482969f},
{0.9941889823922193f,0.09029754953007006f,-0.05860562975336182f},
{0.7681693373229695f,-0.4231495289142038f,0.480479287146155f},
{0.6743990551144293f,-0.6175490986688945f,0.4047456302345967f},
{0.739935601869095f,-0.6279043067759557f,0.24131201092947466f},
{0.9057015607800718f,-0.41833346008676486f,0.06856966510328721f},
{0.9612794286880915f,-0.2755346790410195f,0.004743482566501467f},
{0.9548844769742333f,-0.2547773915008691f,-0.15259133793783256f},
{0.9681993782529212f,-0.2486762530966052f,-0.02738768147342736f},
{0.8998722216328879f,0.14192766098145107f,-0.41241547471187956f},
{0.16580048825654103f,0.4962680936004138f,-0.8521902236989717f},
{0.5018980082937244f,0.35220816057606436f,-0.7899669619005707f},
{0.26251371487149017f,0.5132361633393017f,-0.8171139395121855f},
{0.8014732888670373f,0.2551666606954799f,-0.5408609271357773f},
{0.8903810982752197f,0.22736301263125958f,-0.3943698268395431f},
{0.8764894185248339f,-0.22865250318773817f,0.4236559122684116f},
{0.8526413998957623f,-0.17251988286158537f,0.4931932006842954f},
{0.9437137761382606f,-0.051994537337354735f,0.32665100155049165f},
{0.9082712082016193f,0.04273587887873123f,0.41619353311702645f},
{0.8664021356030961f,0.31031849673828493f,0.3912157588907757f},
{0.8152418944817309f,0.5221217061200516f,0.2505385748345449f},
{0.7178753952876629f,0.6459861020618272f,0.2595320265083841f},
{0.4961014083414742f,0.7561983801167997f,0.4266701331829238f},
{0.4784500026525854f,0.6067269835287342f,0.6347975759404443f},
{0.5705617719738417f,0.4956752589245081f,0.6548017272825353f},
{0.8326176812409048f,0.44308503291151247f,0.3323002414907682f},
{0.8584157603101004f,0.38186605723525957f,-0.3424918930176739f},
{0.6605032270356401f,0.38277954524440666f,-0.6459220593988029f},
{0.38255871614255854f,0.48702454034327186f,-0.7851470727238192f},
{0.7961608113382695f,0.38912117031559756f,-0.4633709931592698f},
{0.7837742467210448f,0.49971584148810594f,-0.3687573835771875f},
{0.9418654830911628f,-0.31127451903637254f,0.1264815621350618f},
{0.8736521197622847f,-0.475619347495067f,0.10255832449505523f},
{0.6752834126723813f,-0.7339817265644726f,0.07254748540768485f},
{0.7730105160421482f,-0.633981826478422f,-0.02284263083219284f},
{0.8970337867107111f,-0.4112887804620074f,-0.16177739200987662f},
{0.653801052480875f,-0.26802587993145655f,-0.7076060425560742f},
{0.6027252043204169f,0.6913560705753401f,0.39843332159288203f},
{0.9122077652993039f,0.26913098578444733f,-0.30894256006309956f},
{0.5792503180356363f,-0.2464666870856648f,-0.7769962942077853f},
{0.46789283790723946f,-0.16530837517209376f,-0.8681874413587608f},
{0.7236553369618423f,0.03557279103854849f,-0.6892441728621072f},
{0.8628252503342553f,0.4842375933618746f,0.14507425878056163f},
{0.8506918335677811f,0.5213256272343492f,-0.06740174099976137f},
{0.6287684664583545f,0.7410742505917018f,0.23549770847623322f},
{0.5895104531333426f,0.7287449915673003f,0.3484367416219136f},
{0.7632216085312501f,-0.273089443437627f,-0.5855893886964639f},
{0.6733715477907809f,-0.2899270898466001f,-0.6800831134493267f},
{0.6748694054771367f,-0.21401704202864416f,-0.7062209224260109f},
{0.5752044469524028f,-0.14917507402452632f,-0.8042926342420136f},
{0.5120000028859258f,-0.11659686859707603f,-0.851035350193027f},
{0.4509941524051923f,-0.12995511467334284f,-0.8830152561912848f},
{0.3045907182312156f,-0.19469894375663743f,-0.9323716081410041f},
{0.8117786726471314f,0.15209102666546054f,-0.5638117649030637f},
{0.9303784530624745f,0.3609391247108689f,0.0641785192258966f},
{0.7351136136249038f,0.13250779778473792f,-0.6648681512823237f},
{0.44688632697365066f,-0.12438610837844928f,-0.8859010705527249f},
{0.7876578478305336f,0.1712988150406037f,-0.5918207758406738f},
{0.846550715890262f,0.5274610321253043f,-0.0716710891154429f},
{0.9121291907719798f,0.3996671447268871f,-0.09103028489195757f},
{0.7817043599877329f,0.6168164363541908f,-0.09206398546383654f},
{0.4709807261472815f,0.8622068582208514f,0.1864845549494863f},
{0.10818804242557893f,-0.9912990761452158f,-0.0749765904116922f},
{0.18402523372435786f,-0.9323029110336392f,-0.3113615188665702f},
{0.4518255981902696f,-0.8720273847582264f,-0.18820698459869462f},
{0.39940317029873057f,-0.9164360009484558f,0.02494320991623163f},
{0.6811229995767405f,-0.7253191831969228f,-0.09991767578427982f},
{0.6550126773114661f,-0.7385270818578243f,-0.15980031891029373f},
{0.4777833426067302f,-0.8394575022177925f,-0.2589095971527605f},
{0.3020796469668486f,-0.8529781431517287f,-0.42564794630517494f},
{-0.20310357214150906f,-0.8448933558112394f,-0.4948779205919188f},
{-0.45566485559810466f,-0.7951386512680081f,-0.40015505073964946f},
{-0.2081609002997224f,-0.9401788408945649f,-0.2696901680087014f},
{-0.5558790551407654f,-0.8306704002308575f,-0.031387294182791806f},
{-0.2986700478027057f,-0.9520784529137832f,0.06590009137191573f},
{-0.12715308059955602f,-0.9905248293719574f,0.05189081317244121f},
{0.2103424547331897f,-0.9763473254381383f,0.05001951465788192f},
{0.46271794946546807f,-0.8859602757731598f,0.031088406109336025f},
{0.7297729808564218f,-0.6836104876745113f,-0.010396997323708588f},
{0.7753276901840583f,-0.6266096802797388f,-0.07891312573695394f},
{0.6901864057303863f,-0.7151053559045382f,-0.11075673930562499f},
{0.5542226525599646f,-0.79677074415649f,-0.24081867171319968f},
{0.41324369464450034f,-0.7724319183867794f,-0.4822640151347418f},
{0.13012879482182088f,-0.7296603934476834f,-0.6713137917486816f},
{-0.34805504261289144f,-0.6201025429181704f,-0.7030864268197454f},
{-0.610334442471135f,-0.5749789724592249f,-0.5448770958327968f},
{-0.8066594502452108f,-0.4567504189722149f,-0.3750727744035823f},
{-0.7513769844600289f,-0.5924203514260158f,-0.2906385288292479f},
{-0.913709507642283f,-0.38790592485553976f,-0.1210947113050976f},
{-0.8708216665859059f,-0.37398185367330494f,-0.31907240264182096f},
{-0.7417436364995637f,-0.531869731432221f,-0.4085718620984813f},
{-0.9050266937742707f,-0.40876635356442764f,-0.11762972307054782f},
{-0.7964420474143984f,-0.6028089009105793f,0.04797388970409768f},
{-0.623511638253704f,-0.7795628131083733f,0.059287919349069323f},
{-0.4946678361709217f,-0.8641111257959764f,0.09282076348311545f},
{-0.09397027016422718f,-0.9883315829259505f,0.11987606315001859f},
{0.21448548505071252f,-0.9759797931383997f,0.03820235710119489f},
{0.6190723475614033f,-0.7554452894537623f,0.21459693177427874f},
{0.7689773947874753f,-0.6327057902957285f,0.09141744490043853f},
{0.9318335834076111f,-0.331923024636028f,0.1466740554774471f},
{0.9027964305354166f,-0.4300545624567757f,0.003417356086535313f},
{0.7928868275533664f,-0.6085217796216889f,0.03212043614913968f},
{0.41707647386141283f,-0.907349180162508f,-0.05258022641407091f},
{0.5261954040080297f,-0.8464400905910718f,-0.08159393262372297f},
{0.42298840432743023f,-0.8790846004445857f,-0.2197523038917167f},
{0.5814465071843241f,-0.7751383055315061f,-0.2471448291607479f},
{0.5156702074923791f,-0.6074355159126152f,-0.6042402925266913f},
{0.31184123939384056f,-0.6086842836187919f,-0.729560473359674f},
{-0.15238353842342137f,-0.5561652135068521f,-0.8169819535965498f},
{-0.6106826206907007f,-0.29377385442216974f,-0.7353663435623631f},
{-0.7719078256055277f,-0.2966667505564531f,-0.5622696398377042f},
{-0.9237213985243132f,-0.1740271930230711f,-0.34125256628602446f},
{-0.9473355920361548f,-0.26145605113746573f,-0.1849216303873376f},
{-0.9816846170000411f,-0.17274892020742458f,-0.08033133456286874f},
{-0.9138922293251837f,-0.25729505570553524f,-0.3140067634439288f},
{-0.7992009254527371f,-0.36051886273081407f,-0.4809407763652081f},
{-0.9693172268471588f,-0.22677404428802028f,-0.09485592535307834f},
{-0.9513284071962752f,-0.30723887823046897f,0.024052720533880717f},
{-0.8851935818100444f,-0.4637325112713247f,0.03720861072782874f},
{-0.7818222944736399f,-0.5942996537112365f,0.18857842257977858f},
{-0.1415842090476952f,-0.07353547544766856f,0.9871911899926092f},
{0.23469512883060986f,-0.6291136038711594f,0.7410359437486317f},
{0.6487366367164917f,-0.31174223834332315f,0.6942316277831698f},
{0.8449216085621825f,-0.434836680011086f,0.3114876194997653f},
{0.8348945020182144f,-0.19543401815198774f,0.5145451535567375f},
{0.9166391683659207f,-0.18134652829446835f,0.3562107124904824f},
{0.967784004798699f,-0.19541352571656787f,0.1587692477238966f},
{0.954328592878431f,-0.28905251849235175f,0.07553527896223593f},
{0.690630012338484f,-0.6383479211607153f,0.3399148681760459f},
{0.6150234294914452f,-0.7329267125035125f,0.2907999574886058f},
{0.5397803567366125f,-0.8379649164681692f,-0.08032412619997478f},
{0.5968616237062861f,-0.8012343338137453f,-0.042187017727489125f},
{0.5617565179148426f,-0.827170914569546f,-0.014761187972934416f},
{0.4352810322479579f,-0.8967576967538162f,-0.07972487866370619f},
{0.13621654320712204f,-0.9285857647476433f,-0.3452151950084709f},
{0.030326685984364478f,-0.8141697443920386f,-0.5798343896612275f},
{0.18259732235388423f,-0.5318394105036203f,-0.8269250626896933f},
{0.4794327774123516f,-0.4248232387532384f,-0.7678993604359151f},
{0.008266131119503238f,-0.4432719081913206f,-0.8963490874010754f},
{-0.42140787121292833f,-0.3146408769163463f,-0.8505389612787299f},
{-0.7498373646270174f,-0.03778975543321404f,-0.660542096306895f},
{-0.8466589481776123f,-0.02525130137051304f,-0.531536449596709f},
{-0.9088816864053413f,-0.03556038070284552f,-0.415535244523556f},
{-0.9632094298652311f,-0.024733992410300536f,-0.2676113298015306f},
{-0.9784888374161801f,-0.13784678785630103f,-0.15348569356663858f},
{-0.9952213958310383f,-0.07918900628941354f,-0.05712682874985376f},
{-0.9360815487801093f,-0.060352641007385494f,-0.34656729902987865f},
{-0.8290665809093207f,-0.1816021369510584f,-0.528837657768561f},
{-0.9940778086038922f,-0.07797194474637519f,-0.07569469118605228f},
{-0.9854155996868311f,-0.16975386355909192f,0.011820393420027319f},
{-0.9389920410430646f,-0.33555939288761016f,0.0754575423842992f},
{-0.4670329338318531f,-0.05430057193722812f,0.8825710660358755f},
{0.1929267937008983f,0.2775350035543459f,0.9411448209889804f},
{-0.11734152611233166f,0.6948505088276006f,0.7095165513444021f},
{0.13315422555236306f,0.09267902062050627f,0.9867525279189177f},
{0.5000949221699639f,0.035896760833854784f,-0.8652262660029773f},
{0.6784727420458802f,0.21185833851053282f,-0.7034136640017034f},
{0.7531906382812791f,0.1680087680830657f,-0.6359849968770098f},
{0.27288676572327514f,0.27200897738897367f,-0.9227913790846202f},
{0.2339063119260384f,0.13727786470017098f,-0.9625188959727079f},
{0.7509261538774542f,0.04833195166048968f,-0.6586151637120892f},
{0.6097538668244935f,0.10609444512255213f,-0.785457949610745f},
{0.5416092576794349f,0.23225173472788413f,-0.8079099849066232f},
{0.7275125054663218f,0.2456821164464351f,-0.6405980424950698f},
{0.008666163837122378f,-0.40481052392043654f,-0.9143595230146674f},
{-0.24658097591845557f,-0.587459994072924f,-0.7707714172690515f},
{0.4273798321678373f,-0.3762150642013025f,-0.8220758508338516f},
{0.7207439297762372f,0.03954805871259019f,-0.6920723508006744f},
{0.4667276886908223f,0.2593654674461631f,-0.845514529092053f},
{0.43229376636181455f,0.2841123448200506f,-0.8558050450222701f},
{0.46700292391565673f,0.0971813986530875f,-0.8788993371314242f},
{-0.06539382017309688f,0.10168316732398551f,-0.9926651911727997f},
{0.6927763160035632f,0.002117757895587141f,-0.7211494235496738f},
{0.5011750430414944f,0.04796497783348835f,-0.8640155884784656f},
{0.24685849096667883f,0.17661965274574423f,-0.9528202263289894f},
{0.8322933876319805f,0.24099954040308744f,-0.49920630848335895f},
{0.43389547713750987f,-0.2194343925572136f,-0.8738325138621584f},
{-0.04328061746281845f,-0.550148986200049f,-0.8339441714737835f},
{-0.46308123206146273f,-0.6077045304452653f,-0.645175151558658f},
{0.19186072111551147f,-0.43088118802010095f,-0.8817771064749994f},
{0.6994997014685719f,-0.18187083224627723f,-0.6911028635618762f},
{0.21776211502565762f,-0.5270014229178954f,-0.8214920337423035f},
{0.5542894152986808f,-0.009916175817472221f,-0.8322649299021337f},
{0.7755094754885506f,0.14004034771951052f,-0.615608442468158f},
{0.805134248612882f,0.08213617407115933f,-0.5873776388487413f},
{0.9130794582970216f,-0.03380833640467699f,-0.4063777789515142f},
{0.9258203225394813f,-0.02109169395277128f,-0.3773749737583207f},
{0.5363906596643132f,0.4083825502733998f,-0.7385856435492618f},
{0.7723613066014325f,0.036006291257088555f,-0.6341620920985719f},
{0.6205995421677145f,-0.004042422858674711f,-0.7841172533994228f},
{0.00673695504812249f,0.05072761097611778f,-0.9986898031527784f},
{-0.28750851543819145f,0.11183237289552331f,-0.9512267731319825f},
{-0.37102947118416074f,0.15313289560112872f,-0.9159079909017149f},
{0.5379152246980925f,0.026284826169061682f,-0.8425890569852322f},
{0.6894138074432817f,0.004475026303136442f,-0.7243539026236718f},
{0.14151859734021122f,0.04636438018767438f,-0.988849245768369f},
{-0.3883936278235578f,0.03120772204734814f,-0.9209649656478095f},
{-0.2529553556956635f,0.09270925509263227f,-0.9630257431891681f},
{0.11287153176146612f,0.12202177975635446f,-0.9860885875938895f},
{0.8157671119455406f,0.20404785072374731f,-0.5411917346773241f},
{0.8177897957033069f,0.22019500491320532f,-0.5317273830214285f},
{0.7653228846867303f,0.19933979722119624f,-0.6120004308973925f},
{0.2804645704311586f,-0.33354390651555943f,-0.9000489359802639f},
{0.32155504471295043f,-0.3834915007531234f,-0.865757831076202f},
{0.6921679751400132f,-0.09002635303104445f,-0.7160996787811763f},
{0.6248866935761169f,-0.17362256264069803f,-0.7611647823786811f},
{0.32605920811099576f,-0.3614360120924074f,-0.8735269898341822f},
{-0.46603560779999703f,-0.6649876550591621f,-0.5836113697328079f},
{-0.43729893583420154f,-0.6323765398311074f,-0.6394290833153512f},
{0.35623627281930886f,-0.3479366790790075f,-0.867199968449768f},
{0.8252963021321212f,0.12044241152573638f,-0.551706116689775f},
{0.6110103478977089f,-0.16258240195884485f,-0.7747472602953902f},
{0.894439699380674f,0.276569293919927f,-0.3514072421456943f},
{0.9078618011576665f,0.28782601892747856f,-0.3048657619791314f},
{0.702971701033029f,-0.27744332708334546f,-0.6548709703473301f},
{-0.34180360428399575f,-0.7083213517741914f,-0.6176173238496894f},
{-0.14056986488499232f,-0.7012182030156099f,-0.698951461008398f},
{-0.004512654000417894f,-0.4813913921151148f,-0.8764941320689741f},
{0.11907627272274092f,-0.5435968504449946f,-0.8308569705194399f},
{-0.04480925665560209f,-0.622372626551403f,-0.7814374218307439f},
{0.4823367303935544f,0.3013902560880094f,-0.8225054358777575f},
{0.584014695414686f,0.32062917302839744f,-0.7457370642142025f},
{0.6465037929468478f,0.22302801528049124f,-0.7295829974070012f},
{0.6785839846170877f,0.14364481947298305f,-0.7203401569118372f},
{0.6767424976240649f,0.07402279324113506f,-0.732489056566938f},
{0.7834957690621103f,0.09576319046765347f,-0.6139737707860393f},
{0.7095562631110408f,-0.05473326181966601f,-0.7025198783881317f},
{0.7805183629526855f,-0.08175732237851656f,-0.6197635237178412f},
{0.7247194955323847f,-0.07466134661576201f,-0.6849871065332594f},
{0.746545358029664f,-0.07367521577436753f,-0.6612427625199091f},
{-0.11324673667134043f,0.10199501083176388f,-0.9883178610137127f},
{0.26882234381515496f,0.016956956353516062f,-0.9630405023138703f},
{-0.33668798509763026f,0.21713593910746157f,-0.9162386068262016f},
{0.2755565983302126f,0.08408832757858967f,-0.9575999761287162f},
{0.5347962436248075f,0.007769233770633588f,-0.844945333623077f},
{0.59850304579779f,0.005706438163854933f,-0.8011002064250456f},
{0.6010473341165031f,0.018140206815677053f,-0.7990075312837353f},
{0.5527989050104606f,0.026196165505188888f,-0.8329028343882979f},
{-0.6315422313974051f,0.05173645247222322f,-0.7736134367028379f},
{-0.6995445532766122f,0.07316759525021906f,-0.7108332582162467f},
{0.8723783344198565f,-0.03715755716968237f,-0.4874170263542492f},
{0.851430918170877f,-0.10647248569358306f,-0.5135455202539762f},
{0.9049787600923859f,-0.03224284040790731f,-0.42423324130020523f},
{0.9290721842798423f,0.04476415844179945f,-0.3671798558152124f},
{0.9966578503606444f,-0.007879921184774099f,-0.08130827852452087f},
{0.956361431670811f,-0.07825332539780651f,-0.28151239595574085f},
{0.8965498492972229f,-0.1001756234329987f,-0.4314663511734571f},
{0.8900553294952898f,-0.08403785989978695f,-0.44803922656447726f},
{0.8704728935534486f,-0.19757994860789818f,-0.450820480343104f},
{0.9804917281180802f,-0.17119275161134118f,-0.09658681528945118f},
{0.9151402403563403f,-0.17709198476133362f,-0.3621557253638706f},
{0.7872118169497483f,-0.10932574583688105f,-0.6069146863867158f},
{0.8469830698474301f,-0.04033015886678262f,-0.5300878773162083f},
{0.9230480566044008f,0.04441827307308314f,-0.3821116358029991f},
{0.9932076361298087f,0.01908292373969769f,-0.11477993533271598f},
{0.19562203399134018f,-0.08434706353227764f,0.9770453380936696f},
{0.19278042544383064f,-0.1583607523241956f,0.9683788409961313f},
{0.47743315489525967f,-0.23789282724003272f,0.8458513967326075f},
{0.8810438769802246f,-0.15789272783430996f,-0.44590534122467695f},
{0.8732385337959363f,-0.1309901903764843f,-0.46935704226000036f},
{0.8430980166773951f,-0.2960076329347884f,-0.4489601491435362f},
{0.8790917974794651f,-0.43810941813027476f,-0.18777046985581947f},
{0.6471332435161451f,-0.22166182396587072f,0.7294412936846919f},
{0.29798692115996034f,0.16057350091176778f,0.9409675582200198f},
{0.0244063684791939f,-0.7972775423353192f,0.6031192665347469f},
{0.7347016118469011f,-0.6407919208270815f,0.2227089036215316f},
{0.9426954097430638f,-0.2500437372053045f,-0.2209151283496941f},
{0.8487595033846455f,-0.08499501115291232f,-0.5219033947900381f},
{0.8524062678700232f,0.013147092163416894f,-0.5227147486569945f},
{0.8757245405241924f,0.0377627548572977f,-0.481332009603849f},
{0.8919452743789147f,0.07455052079946284f,-0.44595498355960933f},
{0.9281514627845516f,0.1461824257666249f,-0.3422945522906876f},
{0.9250000285146992f,0.27583336350455234f,-0.2613252816425746f},
{0.09198401655724682f,0.019477467680000787f,0.9955699719009059f},
{0.05147317250645813f,-0.05806702618959737f,0.9969848208381193f},
{0.1422559672888838f,-0.13917771554283892f,0.9799963281905605f},
{0.2256525330906533f,-0.18903179270457035f,0.9556923750123091f},
{0.19409516664733215f,-0.17511551147310714f,0.965226203501364f},
{0.09597785962205183f,-0.2218940193138301f,0.9703356608180097f},
{0.777987811268864f,-0.3680354887960833f,0.5092002008087885f},
{0.926351697504857f,-0.2156666072554321f,-0.3088048688813067f},
{0.8989812376645415f,-0.19239356811919886f,-0.39346848574376614f},
{0.8865268582811335f,-0.16859789809945688f,-0.43086526699494837f},
{0.862005179632882f,-0.293918417677845f,-0.4129879344918382f},
{0.8731658481646367f,-0.2750940670067076f,-0.4023737763530816f},
{0.6240181823786071f,-0.5777386174966695f,0.5261362921467558f},
{0.48344737662111487f,-0.8577325099343299f,0.17485301095467753f},
{0.49015817444800525f,-0.8690295172177693f,0.06732504902374539f},
{0.6207357228865464f,-0.4538534205907157f,0.6392998005244673f},
{0.15492173831509212f,-0.958337594420186f,0.23997564484414038f},
{0.18032670635778805f,-0.9774520273477815f,-0.1098627016228152f},
{0.2254725239215811f,-0.8012268824719742f,-0.554254114789122f},
{0.38197358822120203f,-0.8655070845450157f,-0.3240272588900608f},
{0.42636913140690624f,-0.9028116262113987f,-0.05604044397441808f},
{0.13947853224572385f,-0.9758820255262095f,0.16792858987510467f},
{0.43282443851647756f,-0.6304149666640877f,0.6443911663181091f},
{0.6402465004982496f,-0.4067144032237531f,0.6516654147720985f},
{0.5346271181715331f,-0.6245367627866873f,0.5693221201073491f},
{-0.1317435052158797f,-0.9890454135061154f,0.06657941766004553f},
{-0.1789039890053226f,-0.9834262563236309f,0.02943061486397872f},
{0.15809281863006275f,-0.9745456513672693f,-0.15895733420873268f},
{0.23478879089745572f,-0.8971237264339198f,-0.3742235202899844f},
{0.21846822521831072f,-0.6667450301810859f,-0.7125466295610304f},
{0.020095989788638007f,-0.2825795999787895f,-0.9590333262563101f},
{0.1694445071946673f,-0.45160643727793753f,-0.8759795572903996f},
{0.28369995957881167f,-0.7563352308475803f,-0.5894670062978234f},
{0.8781477933639396f,-0.4032619619247094f,0.2573640283230698f},
{0.7327724826362616f,-0.5943573370612217f,0.3313364522242955f},
{0.6832199153648791f,-0.18387142498705322f,0.7066836960918498f},
{0.003044277112259015f,-0.36370936077038485f,0.9315075057480008f},
{-0.9358224559812016f,-0.274350738137063f,-0.22128715137793423f},
{-0.9802600366088152f,-0.05562385640120643f,0.18972676992649812f},
{-0.686434170127469f,-0.10333564717118583f,0.7198123881297995f},
{-0.6638641314668721f,0.2555782089237279f,0.7028258632656276f},
{-0.9367435920706386f,0.05507852300763169f,0.34565560753139046f},
{0.4536233073936295f,-0.3834495557420483f,0.8044826494030127f},
{0.043445554035793074f,-0.2583882452600124f,0.9650637277123075f},
{0.33716098021191115f,-0.21109302681218886f,0.9174759982984905f},
{0.20952387905462186f,-0.877069244980254f,0.43226066628328713f},
{0.09329190041369474f,-0.7723828989339164f,0.6282684766496252f},
{0.3418248712937774f,-0.6087006914688665f,0.715988285916967f},
{0.600227921082183f,-0.7945405469770446f,0.09182462612382124f},
{0.5858018166718724f,-0.8039028880063469f,-0.10284152001496848f},
{0.4734542213140966f,-0.7526419006824158f,-0.45757105421674477f},
{0.43109070333477734f,-0.5375787981228272f,-0.7246860294687234f},
{0.5366027366572612f,-0.43705397173663674f,-0.7218319255901399f},
{-0.045673457266830926f,-0.1974577788251474f,-0.9792468334810862f},
{-0.24605058578345493f,-0.07632425305163004f,-0.9662472342168589f},
{-0.05488309420349749f,-0.0287497803532f,-0.998078802550326f},
{0.4073430691288493f,-0.205480037626624f,-0.8898593024572203f},
{0.709387954864122f,-0.5348511932596379f,-0.45902388887991413f},
{0.8419898422326002f,-0.10157326152897372f,0.5298452397818515f},
{0.8124484184468327f,-0.02980522837589197f,0.5822707409141398f},
{0.7576327149013599f,0.07142494179023695f,0.6487612403661737f},
{0.5893664219485244f,0.287227200838949f,0.7550812908408047f},
{0.08571602861794694f,0.41670549592212147f,0.9049913215640613f},
{-0.39553426964114025f,0.5067176251340761f,0.7660221210369396f},
{-0.7300227709414403f,0.5422270097841024f,0.41600074971996426f},
{-0.8950584828698972f,0.2794969076636944f,-0.3474935838962646f},
{-0.9396206229951098f,0.3386161436114598f,0.049519613568614264f},
{-0.7125273707682842f,0.38820186382156907f,0.5844690400966471f},
{-0.8506056624894477f,0.42673762058098846f,0.3071888834605904f},
{-0.9805745059384563f,0.193723497364299f,-0.030738329045290863f},
{0.25351518044731686f,-0.3188673678062656f,0.9132653803966666f},
{0.42914218300329027f,-0.46907415143497344f,0.7718849831566424f},
{-0.06980497546511605f,-0.5088105615131394f,0.8580437505704464f},
{0.07427546893654585f,-0.2974994608158305f,0.9518283592794167f},
{0.45884720212956454f,-0.3690450344730906f,0.8082481101918061f},
{-0.021737486439646805f,-0.6009510275402752f,0.7989902028070016f},
{-0.041182790453451884f,-0.6066672674703606f,0.7938884079960565f},
{0.6287254842803333f,-0.7455373381795073f,0.22108446982245383f},
{0.9446492208098688f,-0.15598193735736238f,0.28863036022142885f},
{0.9480361066550151f,-0.08620820595332437f,0.3062608132045456f},
{0.9051571367287756f,0.2558169975274064f,-0.33948228467039f},
{0.5320921504871099f,-0.178320638311704f,0.8276954109707927f},
{0.30840951928264365f,-0.18831317813452736f,0.9324278606716567f},
{0.7205453853019945f,0.025264465722332236f,0.6929473677645115f},
{0.8551951874618888f,0.28110110185769066f,-0.4354576464782966f},
{0.8510713819301262f,0.1652296389087801f,-0.49837402549252025f},
{0.8495601588257133f,-0.4029323034842787f,0.340430749705255f},
{0.2926216787230699f,-0.6894778114614694f,0.6625653934847451f},
{0.8301526868380521f,-0.13694661294494312f,-0.5404554946880188f},
{0.6293144490733168f,-0.24836455255525386f,-0.7363955277034049f},
{0.38866868095928f,-0.5396810060154289f,-0.7467804685364688f},
{0.3350982882333855f,-0.7214154800718734f,-0.6060270970309194f},
{0.5423110012618685f,-0.7795935497332643f,-0.31326135274661293f},
{0.9115432981197066f,-0.26097120471140295f,-0.31777798218965186f},
{0.9117201381434341f,0.21583215395250419f,-0.3495466650161894f},
{0.8364580247844648f,0.29465693045555674f,-0.4620771213857928f},
{0.9582220324725581f,0.2573148209629276f,-0.12489843632718682f},
{0.9225452479493012f,0.2348360670814923f,-0.3062062819144296f},
{0.43240783571975344f,-0.18279278576121344f,0.8829554128503964f},
{0.37526540427531946f,-0.21372328100870044f,0.9019413703278929f},
{0.36534895796458966f,-0.250037647841574f,0.8966612033405045f},
{0.9135866738450801f,-0.041893627388098605f,0.40448030033235316f},
{0.8700768676036491f,0.04496679810539261f,0.49086070481264943f},
{0.733696069936698f,0.1603375578798726f,0.6602892884884342f},
{0.9597166996513707f,0.1799137188708273f,0.21581221043386214f},
{0.7994428508723881f,0.1129370955583918f,-0.5900307963452953f},
{0.7504187649923306f,0.3622254575601634f,-0.5528692386475447f},
{0.7376138358154677f,0.33859915805363555f,-0.5841887018583649f},
{0.6786051123670964f,0.15975798521014142f,-0.7169187454871276f},
{-0.6799401702444201f,0.6317958158737615f,0.3721765870287885f},
{-0.7779935899056125f,0.5196601702515798f,0.35309953486216406f},
{-0.6550937522769916f,0.613662381361414f,0.4407614518415718f},
{-0.7143122548501428f,0.6276824755534225f,0.3094716666417651f},
{-0.49859910279663516f,0.5017527613302282f,0.7068543705657351f},
{0.12583648170913403f,0.001044495172625589f,0.9920504467520295f},
{-0.12230792655754495f,0.06801900742640692f,0.9901586669468284f},
{-0.9793241937689253f,0.1530535906049958f,0.13228273470775667f},
{-0.9152657709601412f,0.3426709720341761f,0.2118140066990177f},
{-0.6735297992965463f,0.5147647129307821f,0.5304478294619026f},
{-0.6542582875356119f,0.5770541654769663f,0.4888298101554881f},
{-0.7775893402803126f,0.5285796490096609f,0.3405266106125214f},
{-0.7649509663702071f,0.48888819751173257f,0.41933083523992803f},
{-0.5654620028318008f,0.4153111943095513f,0.7125793536404368f},
{0.3187985926730235f,0.08170911138821531f,0.9442939576349347f},
{0.44733479429202294f,-0.15377806772047742f,0.8810470405738106f},
{0.4878459975853802f,-0.3512546032601286f,0.799141092879408f},
{0.587312776922921f,-0.4957780356489107f,0.6397404484876617f},
{0.6505777949347873f,-0.11526994915986347f,0.7506406407585938f},
{0.2357924731514141f,0.1541929937241013f,0.9594927984573615f},
{-0.8431768907548095f,-0.06783683343296551f,0.5333393806262953f},
{-0.9573994574786571f,-0.2641572839106384f,-0.11664993860490347f},
{-0.9964529240783275f,-0.03217600567956267f,-0.07775779545652962f},
{-0.9599489359225736f,0.2311182773806919f,0.1583741843915866f},
{-0.6920644484673721f,0.4067320384628982f,0.5963353486549053f},
{-0.587178768777294f,0.4759543722007214f,0.6547431015903858f},
{-0.7669917113573254f,0.4392475633973645f,0.46774490137107816f},
{-0.768653228819262f,0.35560967106790853f,0.5317085439116971f},
{-0.7327522103485152f,0.22579487113863145f,0.6419430460693955f},
{-0.5461883773791733f,0.23245381755664324f,0.804762995619983f},
{0.7053729466612034f,-0.01832043996740279f,0.7085995819910509f},
{0.5296879912991216f,0.16166423277971115f,0.8326435658270885f},
{-0.16439755555119068f,0.2934100943178454f,0.9417451673787268f},
{0.1668872850747534f,-0.14247219084858848f,0.9756281611942027f},
{0.469166544837651f,-0.5362416984695145f,0.7016605974597907f},
{0.5001317958752222f,-0.22796753276146361f,0.8354034897947676f},
{-0.06927878448589804f,0.4211113910885036f,0.9043592462708953f},
{-0.2604984117306419f,0.48687064046788525f,0.8337251087356098f},
{-0.8814618432377705f,-0.43590725127871505f,0.18168623282600999f},
{-0.667609804416885f,-0.6368206781869444f,-0.3856897365499487f},
{-0.8307454746346905f,-0.4117987191579606f,-0.374544752030843f},
{-0.961986761349713f,-0.12169857325054192f,-0.2444809363870175f},
{-0.9912195887499102f,0.1321906705649034f,0.00305834825686248f},
{-0.9519184638121421f,0.22462530332637018f,0.20831397302885812f},
{-0.7447074521973731f,0.23554871735457705f,0.6244418406819894f},
{-0.5440299397781344f,0.3671438611012577f,0.7544778392243605f},
{-0.7540281360259927f,0.3345567871416702f,0.5652550983924074f},
{-0.8338253796261509f,0.21877461737082501f,0.5068263046503746f},
{-0.8015373222684735f,0.17603429080414126f,0.5714454037541716f},
{-0.7620607144310467f,0.10982047495045306f,0.6381245417647715f},
{-0.7576207393934671f,0.09024722999298211f,0.6464257519000074f},
{-0.8950680817492553f,0.019368366771831905f,0.44550869284706485f},
{-0.7713564042466761f,0.013592178187729766f,0.6362582418481914f},
{0.679076938428566f,0.06671070041009336f,0.7310295439619936f},
{0.8293429761134715f,0.0156590976863287f,0.5585203851525025f},
{0.8484032521613799f,-0.005080505865330119f,0.5293260905926954f},
{-0.3079544210574897f,0.7016333560216563f,0.6425532727089124f},
{-0.5599298505336744f,0.624579116014063f,0.5444074671791606f},
{-0.6879672415074187f,0.4942116733897781f,0.5314657999325532f},
{-0.6252512623458878f,0.3851458355501026f,0.6787661926564162f},
{-0.3338368491704137f,0.4022082407853918f,0.8525148029097739f},
{-0.5867597365686404f,0.4731449739438864f,0.6571505498540944f},
{-0.5580607245202536f,0.38736387708124553f,0.7338374850609058f},
{-0.5641508910320576f,0.5163174759160544f,0.6443213764973269f},
{-0.6436706265885981f,0.3759582235585924f,0.6665909829916011f},
{-0.5923534364464136f,-0.7776361738246331f,-0.21071162162896823f},
{-0.43073547263345036f,-0.800964017493468f,-0.4158408292796193f},
{-0.5555693498612615f,-0.7071483345902327f,-0.43736018380848946f},
{-0.9252096887282374f,0.0675778700157034f,0.3733902293412867f},
{-0.995010683724318f,-0.09265667816156922f,-0.03699296239190407f},
{-0.9901911486005917f,0.1106511823518583f,0.08531005261501629f},
{-0.7702334190130554f,0.25143901779737726f,0.5861048545819674f},
{-0.47227923035845915f,0.25687526798121657f,0.843188843184965f},
{-0.9485072088565185f,0.1745667313382616f,0.2643114281621056f},
{-0.8302322988594174f,0.13610663018841881f,0.5405453867617039f},
{-0.7726443630806761f,0.04696960931600209f,0.6330991581106065f},
{-0.776069117366466f,0.13779778133887774f,0.6154092106299005f},
{-0.7160742797246872f,0.25099062298343694f,0.6513381096566949f},
{-0.8301897470622162f,0.08398089016546706f,0.5511190379217445f},
{-0.752765646581166f,0.11896363338639512f,0.6474500252982822f},
{-0.9730947120299724f,-0.10654961207336154f,0.20428867219285787f},
{-0.9597897161021406f,-0.2802131711243403f,-0.016860592902195205f},
{-0.8756608495979824f,-0.2584649806120912f,0.40793863543250103f},
{0.11801609287440801f,0.08977915019893859f,0.9889448447776121f},
{0.5650311431755359f,0.14252267152905926f,0.8126666569645681f},
{0.44508153598561045f,-0.10322172967410002f,0.8895210513797731f},
{0.8501407687668501f,-0.02777575838525018f,0.5258223849615317f},
{0.012669546396807634f,0.2811710504059094f,0.9595740320620065f},
{-0.5429402145527588f,0.5603681582080604f,0.6254625893591963f},
{-0.44753771534233433f,0.7238583112372382f,0.525108692176141f},
{-0.49572992142918654f,0.6611625372849316f,0.5631304860250099f},
{-0.5483830019109471f,0.5642213722567204f,0.6171955332825094f},
{-0.6567584351287461f,0.4536292333168346f,0.6024025867869607f},
{-0.7767523989034488f,0.36846256258774207f,0.510774951195741f},
{-0.8202419586062425f,0.25084003371198516f,0.5140840464643551f},
{-0.33847432438364844f,0.40138419772191014f,0.851073356152201f},
{-0.1337854510188693f,0.47287881171741125f,0.8709116387581503f},
{-0.5274314512502996f,0.49414464506154354f,0.6911129676029845f},
{-0.7715110419980178f,0.5570249817006261f,0.30739857162412104f},
{-0.5718810935305532f,0.6477971025964238f,0.5033000384760337f},
{-0.10848144286040134f,0.30572635104631096f,0.9459192221489282f},
{-0.221471281705085f,0.503397110632319f,0.8351896912599794f},
{0.39419558731855786f,0.003957230384850963f,0.9190180516541874f},
{0.607451992943095f,-0.2487592484360732f,0.7544010290203627f},
{0.13891144925625393f,0.20957331404020238f,0.9678753201253423f},
{-0.19712997403317192f,0.6104079446308128f,0.7671648548188763f},
{-0.1343459643667408f,0.5701745137721769f,0.8104641791609498f},
{-0.039239743338985854f,0.5775839711157569f,0.8153876371719423f},
{-0.40764047259779174f,0.6777752195917732f,0.6119231951867591f},
{-0.7914652053173311f,0.5701302752281878f,0.22030501138245992f},
{-0.8272754203445508f,0.5362637891000837f,0.16744111619840452f},
{-0.10304533639168263f,0.5892135935814583f,0.8013794355901261f},
{-0.021953329101054023f,0.5302021211296182f,0.8475870233144409f},
{0.41848603710237287f,0.029754660776520753f,0.9077356977184634f},
{0.7474426427165293f,-0.47633134537593913f,0.4630744489402095f},
{0.7265902145295474f,-0.3061050715788537f,0.6151149041468684f},
{0.13772868040896677f,0.2788837875718147f,0.9503970978608908f},
{0.42904744657041705f,-0.011663176796701381f,0.9032066534843585f},
{0.5255609062999327f,-0.09845639737787291f,0.8450396863961857f},
{0.3778152590475956f,0.4448055791507283f,0.8120367151719085f},
{0.21062367716643546f,0.4573358291621832f,0.8639916700879862f},
{0.5355703508368891f,0.10635589319961741f,0.8377665684939708f},
{0.4707233746023289f,0.31266558217690593f,0.8250210532616559f},
{0.3516267158307507f,0.25186494692076644f,0.901622260831375f},
{0.5936861246805925f,-0.16611485384881555f,0.7873643633620502f},
{-0.6472776843513806f,0.5826031075843628f,0.4915335373845389f},
{-0.7201581437295896f,0.6242626367162963f,0.3027679118069964f},
{-0.38633417796382186f,0.7703792050459051f,0.5072098021232019f},
{-0.03557429363022719f,0.6220687260792058f,0.78215405750204f},
{-0.07591997642610153f,0.5767660441924406f,0.8133738915443891f},
{0.7313343428692269f,-0.12644101321985368f,0.6701960527457416f},
{-0.845877943026909f,-0.2719463353958298f,0.45884168965487887f},
{-0.7643940402454686f,-0.13379301516868675f,0.6307148169571414f},
{-0.8815129765291906f,-0.3587444223943718f,0.30698096294652394f},
{-0.7732303343713874f,-0.2112618271596617f,0.5978990637165051f},
{-0.7777289991051658f,-0.14420408394222073f,0.6118355874949265f},
{-0.7601404994076069f,-0.18416176457051694f,0.6231138464443136f},
{-0.7891560465540356f,-0.22912501085400858f,0.5698547741208769f},
{-0.7312541117716919f,-0.3448497713536867f,0.5885117324355598f},
{-0.09697364581457864f,-0.8022081310738348f,0.5891164795322347f},
{0.2654008344926374f,-0.5561103515645637f,0.7875935969352145f},
{-0.1827164209040203f,-0.3348972423843818f,0.924369269597038f},
{-0.7048305372967739f,-0.1594781189256796f,0.6912167845747581f},
{-0.8043033273848939f,-0.18432890491145795f,0.5649061978521133f},
{-0.7509551570487597f,-0.1506316648816433f,0.6429435851121441f},
{-0.8551048423902193f,-0.14178321160641108f,0.4986915173003945f},
{-0.827660558781003f,-0.14515005588278188f,0.5421341722447897f},
{-0.7861983618050546f,-0.1731045694715549f,0.5932343077765444f},
{-0.7240895397859519f,-0.1799743717448051f,0.6658104564270757f},
{-0.8843298584519313f,-0.12758749218963533f,0.44909033978381985f},
{0.8163027486155207f,0.06755371075684935f,-0.5736604559891904f},
{0.6502555189606843f,0.05481666486072856f,-0.7577353715610204f},
{0.5104949154466126f,0.03649677178192615f,-0.8591058880910163f},
{0.7472202066478504f,0.023620848992160343f,-0.6641566217919032f},
{-0.5137985794136068f,-0.14115682305879243f,-0.8462185126174613f},
{-0.6443276645903102f,-0.15636491280698486f,-0.7485932638532495f},
{0.7796266524806807f,-0.011427197421622898f,-0.626140321254633f},
{0.47127611380761475f,-0.09380413383888987f,-0.8769832433000805f},
{-0.2677682875748194f,0.01643133660502956f,-0.963343217833925f},
{-0.2062573937243126f,0.03691589101827773f,-0.9778011579684188f},
{0.4792173889868808f,0.05170513442027446f,-0.876171942695712f},
{0.7658000390579058f,0.036092672586027205f,-0.6420651206571711f},
{0.8504714676386761f,0.018757278011358635f,-0.525686643594947f},
{-0.4903779977941759f,0.028231051795511105f,-0.8710524823418475f},
{-0.6089407364605303f,-0.004050298681155647f,-0.7932053798099837f},
{-0.5097516185627537f,-0.1158979623121794f,-0.8524792957629748f},
{-0.15841704497042328f,-0.24614674109990622f,-0.9561986308862478f},
{-0.36803588287506006f,-0.2580899342540374f,-0.8932744117868382f},
{-0.7696713523532137f,-0.2049413144659351f,-0.604652848328485f},
{-0.8028875014114725f,-0.2216445873796027f,-0.553394377422258f},
{0.0437925280623975f,-0.41945327386182363f,-0.9067200039331337f},
{0.013650033979354343f,-0.31533398745067787f,-0.9488825812137233f},
{-0.532443185459721f,-0.009542264493764344f,-0.8464119561099288f},
{-0.5510045560060406f,0.01933744427563008f,-0.8342781565577951f},
{0.12169851470392636f,0.03702198920492324f,-0.9918764256872773f},
{0.7654110665397273f,-0.012288757688251467f,-0.6434243433792326f},
{-0.1407990287372421f,0.030098674640832622f,-0.9895805693785195f},
{-0.5405283761823801f,0.06633023158557218f,-0.838706966061117f},
{-0.637040148575603f,0.02613022086147902f,-0.7703876041711107f},
{-0.7026815124501259f,-0.04116920427027758f,-0.7103124584860916f},
{-0.45521372742085864f,-0.15057883039014014f,-0.8775571082305389f},
{-0.10394569001067702f,-0.1734760073836267f,-0.979337208723553f},
{-0.4367772404440514f,-0.1976854001617122f,-0.8775796971175798f},
{-0.8305732415669571f,-0.2554390113409154f,-0.4948727128041441f},
{-0.5083248669063033f,0.09878152729375014f,-0.855481174281587f},
{-0.5230404056159552f,0.0322604884995042f,-0.8516971263159636f},
{-0.5071934836564764f,0.020723528057158887f,-0.8615830229996827f},
{-0.5650443102620094f,0.058848962398407915f,-0.822959128429329f},
{-0.540874392017746f,0.06856435124271197f,-0.8383041344274164f},
{-0.5485914043167549f,0.1261096584128482f,-0.8265251509571656f},
{0.46493065706822f,-0.10208200718743334f,-0.8794422936877087f},
{0.6823942510227771f,-0.07917168649188382f,-0.7266842025454345f},
{0.8165148364839618f,-0.11001940197500468f,-0.5667444335771029f},
{0.6695420330334195f,-0.07161397825862617f,-0.7393138062551303f},
{-0.500134266236366f,0.050615528326994993f,-0.864467341215613f},
{-0.6317042547753383f,0.08015109786959575f,-0.7710548203656034f},
{-0.7467799534689725f,-0.13534151936281835f,0.6511546469414489f},
{-0.7181550801661225f,-0.13132978227510847f,0.6833782035733674f},
{-0.6683736183928733f,-0.08641918200630355f,0.7387884888232755f},
{-0.7108099006549969f,-0.11223826813689633f,0.6943715549304015f},
{-0.7526939381760523f,-0.1638941889232213f,0.6376445171647167f},
{-0.5883685136817153f,-0.05272575436562689f,0.8068720387611314f},
{-0.7262531270975675f,-0.1343560901726348f,0.6741697385781473f},
{-0.780951315443192f,-0.1542507103998704f,0.6052452075387985f},
{-0.7127131164925264f,-0.1159123363565799f,0.6918123617425967f},
{-0.7189752470207361f,-0.17181568689418827f,0.6734641519105151f},
{-0.7762160179156116f,-0.17841331727574086f,0.6046961069412443f},
{-0.7333725207732086f,-0.1612986434629569f,0.6604146374753966f},
{-0.7530610928013844f,-0.15265443719750094f,0.63999657289137f},
{-0.7100465269323151f,-0.1375197328332987f,0.6905955782314388f},
{-0.6845063553435815f,-0.10673420348344441f,0.7211510655202564f},
{-0.605538971330588f,-0.037748203320673794f,0.7949198873760516f},
{-0.8319534141532561f,-0.25103841663586873f,0.49480625506524933f},
{-0.7445697428963772f,-0.1973257558612508f,0.6377134497852534f},
{-0.22334639734935252f,-0.2993154038316505f,0.9276457706582623f},
{-0.6670436247771326f,-0.272285446107901f,0.693479227145273f},
{-0.7417309694168152f,-0.18895490114752722f,0.6435302746105421f},
{-0.8283776571586082f,-0.23872141859320378f,0.5067568859179555f},
{-0.7853719022189358f,-0.19900007645619583f,0.5861654585314956f},
{-0.7655859465044604f,-0.16913345955146303f,0.6207028527202233f},
{-0.7927530400899729f,-0.1651635247274178f,0.5867398295051406f},
{-0.7936453961636052f,-0.17266237225237044f,0.5833649718285268f},
{-0.7682889826409576f,-0.1516180557066417f,0.6218874531104965f},
{-0.18113584662538704f,-0.9833744299498982f,0.012827142628699424f},
{0.4883761212494359f,-0.669637224845841f,0.559530831406203f},
{0.7979087784011536f,-0.4659139171012185f,-0.38244712471370185f},
{0.195454249853925f,-0.416699010694197f,-0.8877835156728903f},
{0.6515126809015019f,-0.2526292292816509f,-0.7153388701427433f},
{0.9040163676098569f,-0.4273553863990644f,-0.01103543425453858f},
{0.5675596027586519f,-0.34691257444434714f,0.7466778174077737f},
{0.5784903694586594f,-0.37545468462545767f,0.7241427153789383f},
{0.2707098120450122f,-0.16091195817070864f,0.9491172421678062f},
{-0.5580379766597588f,-0.6448461177171584f,0.5222710992105453f},
{-0.5567612855834818f,-0.76418938808192f,-0.3256247073218021f},
{0.04272380563958308f,-0.11961291342730383f,-0.9919009161065955f},
{-0.2892537235533523f,-0.018099873723103975f,-0.9570813330024405f},
{-0.0030999160890322294f,-0.03151811853083149f,-0.9994983735477098f},
{0.29310397528138926f,-0.008396801750969567f,-0.9560436984754418f},
{0.8959889421813579f,-0.25908199628913076f,-0.3606665145083059f},
{0.759900044993428f,-0.33396638980868226f,0.5576902115844793f},
{0.49653829484756823f,-0.32441817129752293f,0.8051102855397143f},
{0.6436720057055451f,-0.43737665067209835f,0.6280031962640461f},
{0.7540070721435296f,-0.43145800492968184f,0.4952951899015786f},
{0.538619389589446f,-0.13545634923548225f,0.8315892799995006f},
{0.6141021714333934f,-0.12705692970890226f,0.7789319993771847f},
{0.7294989101940961f,0.21732869707645644f,0.6485364889138282f},
{0.5148146900361822f,0.26938094061363427f,0.8138794405543508f},
{0.4240082231631793f,0.07924174028655458f,0.9021849994797971f},
{0.03403427941170158f,-0.2710563226622309f,0.961961609301408f},
{-0.12914367681682037f,-0.9250111184859737f,0.3573182634788776f},
{-0.5330961624829501f,-0.8409718921339134f,-0.09259999020873273f},
{-0.3863671683569153f,-0.6153705606804107f,-0.6870512966756821f},
{0.06583187982316265f,-0.780723523472176f,-0.6213991820851869f},
{0.3353018135378679f,-0.4516004548114233f,-0.8268190388787213f},
{0.38793045887654887f,0.14891888085202193f,-0.9095785430635508f},
{0.3959675026647957f,0.25456224152135737f,-0.8822742215575763f},
{0.04589943134925296f,-0.03148628171746596f,-0.9984497264586852f},
{0.25773751101831593f,-0.12230795582771276f,-0.9584425592362485f},
{-0.7536049164525862f,0.16913992424635818f,-0.6351939199366023f},
{-0.5761556941764966f,0.14582289825308448f,-0.8042265218289372f},
{-0.48419660230561323f,0.21029828644781498f,-0.8493104738744323f},
{0.1858773895698225f,0.238858840443903f,-0.9530981326120109f},
{0.8008697405012991f,-0.08942102480655804f,-0.5921245975906818f},
{0.9595499158418502f,-0.2078369857169892f,0.18991510307496362f},
{0.5459402831672422f,-0.25129493320859225f,0.7992496879942841f},
{0.5781586765437262f,-0.30917544508937167f,0.7550782005136923f},
{0.19868448311339618f,-0.24747637885359874f,0.948303705613066f},
{-0.0998181622391744f,-0.5834829233160085f,0.8059677491598525f},
{0.608743759473821f,-0.7419815776642278f,0.2808814228612889f},
{0.5897609259927344f,0.20251116797753893f,0.7817744412658715f},
{0.4186067235088578f,0.32611897942024937f,0.8475935478134987f},
{0.27297984495498384f,0.2150695926279789f,0.9376710908283288f},
{0.06810713769069324f,0.09376516824923539f,0.9932620555617603f},
{0.4819125580090085f,0.03239225236792256f,0.8756203677506289f},
{0.795438119687825f,0.012609026353162526f,0.605903631117955f},
{0.6563497976639812f,-0.049973803331769054f,0.7527998154137716f},
{0.24070667824259598f,-0.08287119139560865f,0.9670535976284292f},
{0.4919849985922868f,0.08209865514871435f,0.866724046039407f},
{0.9154506726940719f,0.34144856725649386f,0.21298577835728658f},
{0.9758097433524245f,-0.21753767043679015f,-0.021741819597486414f},
{0.6255435556588319f,-0.6887040346395291f,0.3665815225088956f},
{0.22750625913830325f,-0.19383445495548127f,-0.9542898438760662f},
{0.20974793129339678f,-0.2849234783389782f,-0.9353204888215366f},
{0.35992740390919464f,-0.14549772803923816f,-0.9215653395449546f},
{0.4579820764599244f,-0.22686052797857031f,-0.8595270318534143f},
{0.19490641663652178f,-0.3928800311565542f,-0.8986972626376113f},
{0.22216289237118642f,-0.45392788000078654f,-0.8628980988571363f},
{0.49962749178282506f,-0.4054366177793094f,-0.7655021348229392f},
{0.8159295662490483f,-0.083197874825472f,-0.5721337750431844f},
{0.830554266516742f,0.5017085758800314f,-0.24180180987591335f},
{0.3876344113855436f,0.8127508362661455f,0.4349432621141109f},
{0.9641760520623018f,0.25993496642276426f,-0.05289946937682727f},
{0.9590393042653809f,0.10214025765500778f,-0.2642176766235419f},
{0.9682440135626792f,0.06120908176229103f,-0.2423983880100105f},
{0.6497798137891694f,0.6846322530060527f,-0.3302497111822639f},
{0.8660282577459532f,-0.07287366787980377f,-0.4946559261903702f},
{0.7744594450134044f,-0.3573427103599456f,-0.5220332895344296f},
{0.7655654792823359f,-0.27249620567930555f,-0.582799549434957f},
{0.6986787374606437f,-0.26944243348427693f,-0.6627584755085912f},
{0.625769521583913f,-0.21016256389933358f,-0.7511619017175319f},
{0.6040091026832232f,-0.12255538931934473f,-0.787498051060821f},
{0.5800299841509612f,-0.07709370574206303f,-0.8109388250791744f},
{0.5275977619231005f,-0.07553652949334495f,-0.8461293248232428f},
{0.4924939076172915f,-0.1112351436527595f,-0.8631781355991363f},
{0.3189534009330858f,-0.17553738425284263f,-0.9313728333824688f},
{0.27274594976502653f,-0.20875724113667185f,-0.9391645548889604f},
{0.8969946711082091f,0.14885584884826897f,-0.41622409380901665f},
{0.9355101229962646f,0.18929871905965373f,-0.2983065616675038f},
{0.8671991178609556f,0.1590840079031345f,-0.47186647307332175f},
{0.3316032384113404f,-0.12286664048009023f,-0.935383921677216f},
{0.6345699544340435f,-0.7560113609439624f,-0.16052350311787264f},
{0.8967351026116221f,-0.05855489253883559f,0.4386769657776539f},
{0.8319257216692535f,-0.5489378421899536f,-0.08103603542208515f},
{0.7529929376213228f,-0.6518880756453611f,-0.08968596726243537f},
{0.9067366662491149f,-0.4216025998950669f,0.008936769056055322f},
{0.8371329002922073f,-0.477979783352171f,-0.26597713051119454f},
{0.9305045538286632f,-0.2184570710947041f,0.29400303296538305f},
{0.888247079136596f,-0.2713853712466425f,0.37063068771841823f},
{0.5731298572788828f,-0.814986416898099f,-0.0855529483249122f},
{0.8419365118259441f,-0.5243020972336893f,0.1274763542415497f},
{0.8431082625482332f,0.24376498430737673f,0.4793194029543595f},
{0.7680573090531193f,0.18267022514317388f,0.6137748437792342f},
{0.9403309492306389f,-0.20190307478074504f,0.2738847464045531f},
{0.9391929001352844f,-0.31517630187100854f,-0.13631065649606616f},
{0.9063940257451562f,-0.22343680270879757f,0.3585050422082778f},
{0.6511121161522037f,0.10303518626194474f,0.7519552929475034f},
{0.5312427933064053f,0.05388484931733484f,0.84550429778568f},
{0.6628764829146863f,-0.07679557603318589f,0.744779972811022f},
{0.11145640755081271f,-0.06364747786669646f,0.9917290294112981f},
{-0.23739980628730825f,0.03585951473643994f,0.9707499303000828f},
{-0.26401685979885786f,0.02843757372220257f,0.9640987512401127f},
{-0.06902087345688629f,-0.029556466480148494f,0.9971772832934253f},
{0.05548654454237811f,0.07172467442690246f,0.9958799196956938f},
{0.22914998817836213f,0.2634397939156234f,0.9370644363647307f},
{0.43406463915501975f,0.31554719105668566f,0.8438115069442097f},
{-0.024781822972803246f,0.4271035075629723f,0.9038630731905972f},
{-0.08217937235107127f,0.5783033632626788f,0.8116722064965991f},
{-0.2627422791122267f,0.687328374720803f,0.6771603946411605f},
{-0.39577941141341727f,0.7541693908799594f,0.5240106748540527f},
{-0.3920194792325079f,0.7193090898680263f,0.5735112563285092f},
{-0.18921761905361045f,0.25768649375312364f,0.9475201124920273f},
{0.15014076390155773f,-0.6517950294479224f,0.7433848199970445f},
{0.17494954180595157f,-0.9435932021757792f,0.28111301398111516f},
{-0.030435241317551712f,-0.8865512620699645f,0.46162815751218594f},
{-0.4145809239036477f,-0.43923626656795656f,0.7969906898243173f},
{-0.08745473602963044f,-0.9470237678153066f,0.30902694435742656f},
{0.01067290164254386f,-0.9988570546790202f,0.046590487102856175f},
{-0.00042658288880580126f,-0.9999984753212569f,0.0016933346392963725f},
{0.00018701967684940673f,-0.9999963350098849f,0.0027009239971598938f},
{-0.002866626721674534f,-0.999985037347027f,0.004659134394222687f},
{-0.11509169418831379f,-0.9933547471771623f,0.0004981861696008712f},
{-0.15486033532628193f,-0.9867516640767335f,-0.048367654320100435f},
{-0.003288104067734763f,-0.9999743384570307f,-0.006364809428690336f},
{0.15535028371867698f,-0.9065773652886062f,0.39240765804822875f},
{0.022196945271206376f,-0.796188561420818f,0.6046412740487335f},
{-0.8448536212844008f,-0.4895446405868556f,-0.2157971350025774f},
{-0.06498575001909625f,-0.9974530193529861f,-0.029399429893568918f},
{0.0027572027519245338f,-0.9999942566184938f,-0.001970929478832594f},
{0.005164063824537067f,-0.9999823476759382f,-0.0029388401343472407f},
{0.5330025305610007f,-0.7559290272928908f,0.38010473308233567f},
{0.1518568870915577f,-0.6942954924459462f,0.7034864995236959f},
{-0.8118628335179445f,-0.390602041474294f,0.433945601139507f},
{-0.6735179928864775f,-0.15309046657752054f,0.7231437079178991f},
{-0.08347561174643023f,0.31884314449861634f,0.9441243940550385f},
{0.28173750301792383f,0.32983793621065055f,0.9010166009733251f},
{0.7306365537813652f,-0.506455192602232f,-0.45790104189085035f},
{0.7653408054567694f,0.14619773615906959f,-0.6268011434615819f},
{0.6686728537112377f,-0.6727679331899796f,-0.3166384733113663f},
{0.9356252194586023f,-0.05420640474604693f,-0.3488081340759559f},
{0.7554790438690906f,0.3303730506896842f,-0.5657782795871861f},
{0.31472500093939076f,0.27151670882796375f,0.9095201210588644f},
{-0.8621874522359868f,0.12864409196922344f,0.48998315767813067f},
{-0.3478111695247036f,0.5077950352597294f,0.7881443982668583f},
{0.2209232610731652f,0.4248883102162361f,0.8778740436750535f},
{-0.652990269435743f,0.6754819276293298f,0.3425315656525694f},
{-0.8494295404772737f,0.47553773772620006f,-0.2287647607539581f},
{-0.933453042090564f,0.2725056663435997f,0.23325110937035787f},
{-0.9097249869593361f,0.15934803172765133f,0.3834170743281513f},
{-0.9943850135818277f,-0.03462468931765082f,0.09999787824511304f},
{-0.963771171052496f,-0.2642926225599166f,-0.035979709677844515f},
{0.14867844503031316f,0.16784271874862053f,0.9745376040699709f},
{0.38255813913666614f,0.29108233985212745f,0.8768810304747742f},
{0.4198562201240465f,0.20752674198127447f,0.8835459273777372f},
{0.37067757540222046f,0.299397908530945f,0.8791808843811535f},
{-0.12742343781208018f,0.7241051142797813f,0.6778163844065852f},
{-0.4068941679477472f,0.7688504891819365f,0.4932606424344105f},
{-0.6507778547016094f,0.7281084248208076f,0.2152819210591853f},
{-0.7362674183974681f,0.6185489805757182f,-0.27442202396139354f},
{-0.8325601915819092f,0.5093786154201644f,-0.2176624762004947f},
{-0.7070777498047619f,0.45048178352972007f,-0.5450754245413355f},
{-0.5783752054524499f,0.1261296641962867f,-0.8059611836357681f},
{-0.8810086959134741f,0.1286570857816683f,-0.45527028455963203f},
{-0.9954492517468314f,0.09499412461823792f,0.007543439844528785f},
{-0.9882509660232802f,0.018681162018294117f,0.15169391002838484f},
{-0.7599787748089997f,-0.022112292900170603f,0.6495716344965418f},
{-0.22158646525013317f,0.16022948901610773f,0.9618866613419632f},
{-0.6198448948026003f,0.2987316397529126f,0.7256388315117165f},
{-0.8149576884095397f,0.1875130350826606f,0.5483455368435749f},
{-0.6795377058199176f,-0.09940365241197924f,0.7268751063670852f},
{-0.9495172171081894f,-0.3074678742966314f,0.06229414651980022f},
{-0.4152316973208715f,0.13111612032849204f,0.9002173073930719f},
{0.25767610092723126f,0.3291095309235856f,0.908454700943419f},
{-0.4531238292409845f,0.799704105773043f,0.393893562506072f},
{-0.6766119135258548f,0.7337915621906953f,0.06120671313360839f},
{-0.7309544388211159f,0.6477448512997025f,0.2147841148279684f},
{-0.6225827264200668f,0.7528329144857498f,0.213619642426084f},
{-0.6899667359747375f,0.7077389071015551f,-0.15182734478038976f},
{-0.6781355092516084f,0.5874395027410777f,-0.44164132699666725f},
{-0.5940640976576033f,0.6148480606030569f,-0.5187000195169819f},
{-0.5055215432854733f,0.29280790938885093f,-0.8116104345519493f},
{-0.3095773138948299f,0.13332743536703984f,-0.9414805795660948f},
{-0.47735566572584226f,-0.13289589834412682f,-0.8686024686833128f},
{-0.7745529688262689f,0.029999169858378152f,-0.6317972366908713f},
{-0.852329885683962f,0.02591295963613949f,-0.5223622157974868f},
{-0.8793600845024389f,0.021484855051099747f,-0.47567241121101067f},
{-0.9671067166682342f,0.04095101866679599f,-0.25105300764049676f},
{-0.9927309099194699f,-0.05391045564778881f,0.10760577708612742f},
{-0.9547028786440733f,-0.023946450621171605f,0.2965956523810957f},
{-0.6492501854491961f,-0.060754886438892576f,0.7581444720289015f},
{-0.12772444860153007f,-0.04467191427080396f,0.9908031516425535f},
{0.45065171629088363f,0.06973430644488231f,0.8899719979351779f},
{0.38183865257058197f,0.18396430872448818f,0.9057352684524345f},
{-0.030637801530479226f,0.28753186395493463f,0.957280916099334f},
{-0.23256328345886068f,0.08609301225218556f,0.9687632901943481f},
{0.7497256866820985f,0.1656317790476652f,0.6406851867325803f},
{0.5852504400930783f,0.21694118521556552f,0.7812928033254395f},
{-0.4616009711971314f,-0.18918882100745904f,0.8666787948228992f},
{-0.8806233006482417f,-0.20082414669157006f,0.4291529616127556f},
{-0.9791845559257353f,-0.2017299288004569f,0.022419662412340727f},
{-0.5173919396445656f,0.4316514118182844f,0.7389063807182313f},
{0.03436061706663999f,-0.21956075395090366f,0.9749935503988273f},
{0.8296268635415269f,-0.33671006979461876f,0.4453600747587862f},
{0.823431937127016f,-0.5593055323538482f,0.09558852649574778f},
{0.731001530783275f,-0.6415145180422933f,-0.23258522122755956f},
{0.8928735000780611f,-0.42973388631872966f,-0.13455742197201034f},
{0.9634276991858302f,-0.24495908524659557f,-0.10863753953697981f},
{0.6323750268004162f,-0.25685205982470094f,-0.730841189892155f},
{0.1930903091480988f,-0.2284116494361431f,-0.9542244237677803f},
{-0.2050967994606297f,-0.1961540131397656f,-0.9588841984203155f},
{-0.15786580256024077f,-0.3248414708090932f,-0.9325000843027287f},
{-0.39429137550770726f,-0.4145266178556482f,-0.8201841221880596f},
{-0.28094242654823603f,-0.8322271495615108f,-0.4779846488098878f},
{-0.9080859009336911f,0.06033598726721881f,-0.41441472604860047f},
{-0.9566642911662091f,-0.2256893501907695f,0.1840047586828203f},
{-0.5031017654021103f,-0.30798508545643827f,0.8074860994380463f},
{-0.9603387838621112f,-0.0620093678542726f,-0.27185337685700145f},
{-0.9206481199764148f,-0.042998995927899755f,-0.3880182025795769f},
{-0.9193826804958838f,-0.029924679717297387f,-0.3922244259961647f},
{-0.9559705509385621f,0.0039241895912011495f,-0.29343637551311585f},
{-0.9967338580626098f,0.03838655543301387f,-0.07104990185505874f},
{-0.9152764674736902f,0.07829032928401662f,0.39514505239150227f},
{-0.2015334181953322f,0.03098322916029071f,0.9789914815059967f},
{0.3896321142362478f,-0.0021892613165720764f,0.9209679813601988f},
{0.5799444731278283f,-0.017783215946622546f,0.8144618869653028f},
{0.6289904634365412f,-0.01542559896225761f,0.7772599615331672f},
{0.32490220426648214f,0.003942934078503681f,0.9457393990596108f},
{0.5714534490231797f,0.17040959779404308f,0.8027462392183377f},
{0.6741189165412381f,-0.18460837368095778f,0.715180700752012f},
{0.6190863665296438f,-0.24326169808863946f,0.7466966030592045f},
{0.9504486160014585f,-0.3021674945607332f,0.0730905847000925f},
{0.5708018045973232f,0.34036705838635284f,0.7472185526563565f},
{0.5635740334873243f,0.2745235166388555f,0.7791156188853259f},
{0.7299170541826423f,0.08912187162056008f,0.6777008086258878f},
{0.4690669866344983f,-0.055017106411051f,0.8814472644757522f},
{0.3346646962738278f,-0.9419034429867311f,0.02859099784352641f},
{0.5180617806491674f,-0.7620982409569111f,0.38835327031067446f},
{0.8075055742352264f,-0.04345134264948638f,-0.5882573657855839f},
{0.8642394255823229f,0.08698823567669009f,-0.49550303946897556f},
{0.8487877197386401f,0.11482609779030889f,-0.5161146908266905f},
{0.9701167941544065f,0.13005312381274342f,0.20484040296319447f},
{0.7741884738318731f,-0.12351849657930722f,0.6207861048611372f},
{0.2138593563843866f,-0.7700534638420161f,0.6010672495750943f},
{0.16912432148005596f,-0.8500113787238012f,0.49887635735117103f},
{-0.01638437796768401f,-0.9690336741499134f,0.2463844364446171f},
{0.6283300509980619f,-0.7276954150503416f,-0.27506495583313373f},
{0.8341791407098009f,0.036247809986856526f,-0.5503010607620294f},
{0.7905619463173291f,0.15043060549214754f,-0.5936180943723179f},
{0.8423027331039942f,0.21622194521168964f,-0.49373492505028904f},
{0.9584456124235241f,0.19997358982078506f,0.20345164388690593f},
{0.8888270812969256f,0.13484793198271933f,0.43795257139691796f},
{0.8857912255047466f,0.10812415716490896f,0.4513126094584298f},
{0.9424226403949542f,0.05312456973969991f,-0.33017775055411375f},
{0.9309657933171347f,-0.24945747841758895f,-0.2665964330874217f},
{0.2602250372498307f,-0.863316772533589f,0.43239690129614905f},
{0.2259718554009226f,-0.8508641130572695f,0.47430684338087564f},
{0.3242723276291262f,-0.7515091097121173f,0.5745272104554227f},
{0.6184439641049785f,-0.7397232056609141f,0.2652105621366936f},
{0.04726473653341939f,-0.9777337694535784f,0.20445713670724058f},
{-0.07947096027688114f,-0.9943028574908404f,0.0710365684575216f},
{0.3462962972548594f,-0.8119535223992915f,0.4699046200783274f},
{0.47851985700367194f,-0.7443554671735771f,0.4657828731737472f},
{0.8196728280212741f,-0.0754776158822432f,-0.5678376392106632f},
{0.836149311476859f,-0.005810341476736022f,-0.5484711194299096f},
{0.8186569689738797f,0.018916060302989948f,-0.5739712099165896f},
{0.6272588506038018f,0.0746771653046328f,-0.7752223263820914f},
{0.5530702574144757f,0.20626697206440603f,-0.8071971423381448f},
{0.6751874253119948f,0.2644637301894585f,-0.6886079262648932f},
{0.6589278577642296f,0.30988602374769253f,-0.6854084406746738f},
{0.8758037729713735f,0.32305938396940637f,-0.35860895928352754f},
{0.7969799982909074f,0.15414504662713158f,0.5840052970004166f},
{0.7697917207573808f,0.06790518039586327f,0.634672823688549f},
{0.8828066127166027f,0.2221961503084978f,-0.4138615170946943f},
{0.9411330263745586f,0.20955037256601464f,-0.2652494449089554f},
{0.8744716422124801f,0.13905602769404757f,-0.46471794470211775f},
{0.9103904306334659f,0.06768002555455616f,-0.40817726290417883f},
{0.614442384334521f,-0.7692213988221092f,-0.17538242764731654f},
{0.15624136769850341f,-0.9812046109127127f,0.11325257852840802f},
{0.8945372668805702f,-0.4463842020433137f,-0.02332857320955721f},
{0.9143887926488851f,0.1795168780459026f,-0.362859237686967f},
{0.8913597260987569f,0.43352813213068064f,-0.13240542791151705f},
{0.6467961018574633f,-0.7562470311983974f,0.09871793365746694f},
{0.1541686815552623f,-0.9880445415589795f,-3.902586431449344e-05f},
{0.022406656526285793f,-0.9976731927626032f,-0.06439054422961885f},
{0.2574640717354311f,-0.883100522657516f,0.39223171550428526f},
{0.4253821748909233f,-0.6546584521502521f,0.6248778411124082f},
{0.24301265398932256f,-0.7671696902941147f,0.5936291066778127f},
{0.08874078084624855f,-0.8240607140782411f,0.5595078313372007f},
{0.6118005480789336f,-0.7781467713842831f,0.14208339647732432f},
{0.7898116860139832f,-0.15904248896455117f,-0.5923706503024183f},
{0.728953314355989f,-0.01759815878983901f,-0.6843371758838083f},
{0.7376621525732162f,0.037908849219413635f,-0.6741049382788329f},
{0.78014906250852f,0.1063273814287739f,-0.6164916286743701f},
{0.6802309189928063f,0.13330509499599472f,-0.7207743395087751f},
{0.5020653364910114f,0.2779137158408305f,-0.8189593179405859f},
{0.36971859875625684f,0.38185998449873065f,-0.8470484696712102f},
{0.6315122304904999f,0.3824632009237288f,-0.6744732779585038f},
{0.5958300991258039f,0.4068632276117469f,-0.6924224194760643f},
{0.41575638687362554f,0.5240182277379498f,-0.7433380951977144f},
{0.5773022449183829f,0.3962770542602351f,-0.7139233952456147f},
{0.795958754525296f,0.528202786071237f,-0.2957219604309471f},
{0.8323630808049886f,0.5453916686733739f,0.09858818110960738f},
{0.7442203355514635f,0.17803406353766046f,0.6437701176444396f},
{0.5737861561555267f,-0.12921050695771744f,0.8087484725772254f},
{0.7694350968018948f,0.07652179229246953f,0.634124630584404f},
{0.9764913109711182f,0.21546100020781753f,0.006424716908454582f},
{0.8319178186513586f,0.23699067211211072f,-0.5017451189022322f},
{0.8640673937076588f,0.18304429946061898f,-0.4689161157032514f},
{0.9559575833747418f,0.1387589807245315f,-0.25863302970930213f},
{0.9718931594948202f,0.04432190288759855f,-0.23121257632663064f},
{0.7145293221584543f,-0.6983241730985992f,-0.04232253586373836f},
{0.22592482676647271f,-0.966168511699511f,0.12440409820778042f},
{0.5737039893003719f,-0.8142996104801882f,0.08820361122228922f},
{0.9844009272242973f,0.12283012649258915f,-0.1259665610618879f},
{0.8809475200737578f,0.1118200026339101f,-0.4598127378475376f},
{0.7805584902764221f,0.2670264790668714f,-0.5651772312598432f},
{0.7445530337337821f,0.42329728601788846f,-0.5161978182903443f},
{0.8954219377521221f,0.4096957530198403f,-0.1742668739311649f},
{0.8628211424501399f,0.5049634950552405f,0.023484991007696875f},
{0.9809445279677416f,0.19271783211741417f,0.02465096821848609f},
{0.23874879750935607f,-0.9391268763741935f,-0.2470621819694121f},
{0.4812967288809821f,-0.8765526669424779f,0.0029800745788406404f},
{0.7186076898814417f,-0.44466876023550744f,0.5346706291857394f},
{0.8488291354761709f,-0.35378787658413524f,0.39283996378788294f},
{0.41229147500932845f,-0.7507552812219443f,0.516122318207604f},
{0.14962321043928983f,-0.8418152716277931f,0.518613481652825f},
{-0.02983974251409276f,-0.8860040526798105f,0.46271633686487007f},
{0.1515538461289411f,-0.9101142135261131f,0.3856469240915448f},
{0.46629242867789517f,-0.8759479246896424f,-0.12363900755658912f},
{0.7244681250966911f,-0.188284469337838f,-0.6630949361328692f},
{0.6852443065395827f,-0.13837341433200537f,-0.7150475778304473f},
{0.5888951762701956f,0.017457610928047585f,-0.8080208556630083f},
{0.6503974715492402f,0.10947917818223954f,-0.7516631150634551f},
{0.6036305150951956f,0.18367451333578488f,-0.7758181967424916f},
{0.6715987700821435f,0.25383345955207015f,-0.6960773425676055f},
{0.42063769634666204f,0.4034585383034965f,-0.8125793107642967f},
{0.23400495381688471f,0.5757496925128309f,-0.7834245165684685f},
{0.480508963886862f,0.5248932791449452f,-0.7025654283643916f},
{0.6335580752666934f,0.4604882628177396f,-0.6217352531998354f},
{0.4214634440364257f,0.5921376785958493f,-0.6868344305056885f},
{0.13421537568339909f,0.7367238378382531f,-0.6627399336776376f},
{0.558575367652805f,0.7803848877212434f,-0.2810569082371681f},
{-0.10263502531360448f,0.7924206028611624f,-0.6012783379933352f},
{-0.6184900700516464f,0.7484297751175042f,-0.23942202272362367f},
{-0.4235243014396632f,0.6295192847364383f,-0.6514081947864707f},
{0.04417530485030551f,0.5760869950358166f,-0.8161937984277908f},
{-0.01772344624215603f,0.44762128259899653f,-0.8940475752540973f},
{-0.42476564880850515f,0.4527555012131361f,-0.7839557383638004f},
{-0.8346463847442908f,0.42709132207889017f,-0.34779076330200503f},
{-0.830861196424658f,0.554800836865875f,-0.04319379224738692f},
{-0.6942059669706654f,0.6697799731318187f,0.26357705327638786f},
{-0.515634434288754f,0.8567586883114245f,0.009256358819970141f},
{-0.22356522603239257f,0.9116462800124591f,-0.3448472848211658f},
{0.19936905021278425f,0.8736356213421547f,-0.44386122035987763f},
{0.3925791996879534f,0.719950861499571f,-0.5723218753449772f},
{0.2290318627885627f,0.6578603908753574f,-0.7174706349007761f},
{0.26081860060800677f,0.6075531425469738f,-0.7502351874966793f},
{-0.03908515856264566f,0.545768869096854f,-0.8370237104795025f},
{0.22683144108371633f,0.426201900394654f,-0.875727947159316f},
{-0.0401353573583895f,0.43392560283979725f,-0.9000542896347047f},
{-0.25937502446832345f,0.14539085353982695f,-0.954770179880487f},
{-0.11858582684501666f,0.21587890637278345f,-0.9691922923005396f},
{-0.5808581832238755f,0.3075705529490702f,-0.7536604845289834f},
{-0.6472363474009246f,0.3363766257554246f,-0.6840583865785906f},
{-0.8631924887496544f,0.30840409431220134f,-0.39973196266704586f},
{-0.9568918178631567f,0.28499680226311913f,0.0559899241501522f},
{-0.9292202294467992f,0.34121269100742324f,0.1418579031365916f},
{-0.8647842496668816f,0.43171402428240846f,0.256458968971601f},
{-0.8097111677899949f,0.514725928399131f,0.2818244904010568f},
{-0.6966796362785445f,0.6633844898998829f,0.27305402936977f},
{-0.682023588766361f,0.7006838221323811f,0.20948987032363087f},
{-0.7042869841980072f,0.6519275121732256f,0.28101665922308755f},
{-0.5251816138737795f,0.8372512077758048f,0.15229802207149296f},
{-0.27040226849259025f,0.952132111415514f,-0.14257298343478922f},
{0.01131962397936419f,0.9483919935044482f,-0.31689823724600363f},
{-0.12147266910990374f,0.9023143234834875f,-0.4136100244141241f},
{0.2264645049066252f,0.8852512048609158f,-0.4062562397178586f},
{0.512926525315469f,0.7748076509214167f,-0.3695666160537712f},
{0.40406861751004836f,0.7398902924806672f,-0.5378577018472367f},
{0.06573534445540653f,0.7240863665973855f,-0.6865695872940527f},
{-0.16425104499434953f,0.11955119005087253f,-0.9791471325473431f},
{-0.6017879285940259f,-0.05346299223287386f,-0.7968644787289866f},
{-0.1743253603864587f,0.0010125028488856187f,-0.9846875867827888f},
{0.8080813822477648f,0.15162382716326472f,-0.5692228866629542f},
{0.8728386780063423f,0.22168168396186427f,-0.43475265746395697f},
{-0.08881797686361652f,0.07504919578577124f,-0.9932164845580056f},
{-0.7248468950018979f,0.02950921946473817f,-0.6882776945192177f},
{-0.6212869530985717f,0.2149142843281275f,-0.7535345860020108f},
{0.5365861029476523f,0.19161110597524025f,-0.8218032235215416f},
{-0.33720719776314684f,0.1666961152546567f,-0.9265547533393437f},
{0.2528238868523913f,0.46859810431278115f,-0.8464608076404466f},
{0.41117797567485587f,0.16225088123228745f,-0.8969990656958756f},
{0.2275077328400479f,0.04105432735949119f,-0.9729104654093517f},
{0.03795772840869713f,0.05771600179731532f,-0.9976111837738108f},
{0.798571304589179f,0.15806510119299655f,-0.5807747371155054f},
{0.9139035584197166f,0.11765611885135954f,-0.38850652968079497f},
{0.9143380417514896f,0.18696848811688452f,-0.35920569296342975f},
{0.8958526572378588f,0.3132832405424515f,-0.31512160782004184f},
{0.8117821806548097f,0.4535248808088351f,-0.3678652928160713f},
{0.5827909149812226f,0.5741928349261294f,-0.5750281190818795f},
{-0.23755241799903115f,0.48347625963860613f,-0.8425078961461885f},
{-0.5460203036969971f,0.47379877815970006f,-0.6909244139303621f},
{0.06475444614996731f,0.4515075084013837f,-0.8899145080068003f},
{0.9979980346042486f,0.03351423577390528f,0.053635053151349275f},
{0.9962989444736814f,0.023034042164632815f,0.08281211349909036f},
{0.9504213006884782f,-0.06105154873317091f,-0.30491320009947553f},
{0.40137945659777813f,0.5476273210087058f,-0.7341654099084893f},
{0.6992751220740384f,0.6433437765147927f,-0.3116457746673671f},
{0.7886933812933503f,0.45446610476667376f,-0.41403298168415137f},
{0.778498436360451f,0.21194193757734472f,-0.5907798233524006f},
{0.7311287906744032f,0.08031752195735083f,-0.6774952303253617f},
{0.5803382484880911f,0.030216779333510656f,-0.8138147599966987f},
{0.17421845963190333f,-0.0019555297382284967f,-0.9847050848994992f},
{0.11257051065523985f,0.0104344014791009f,-0.9935889509231629f},
{0.8716879614614781f,0.10510686684957204f,-0.47865712611868516f},
{0.9270098898695065f,0.07836008471955834f,-0.36675926874023096f},
{0.9089332777487131f,0.06953783790438745f,-0.41110191643990657f},
{0.9042551347685334f,0.11949609579974624f,-0.40993088970381275f},
{0.8512475678708282f,0.1957017999136619f,-0.48690695590076855f},
{0.8223853034955969f,0.3769598735339541f,-0.4261263502058047f},
{0.7752544122707646f,0.5654821490219274f,-0.28144366291009987f},
{0.8074800483927906f,0.5532850916101199f,-0.20457658431393816f},
{0.7630161491204874f,0.5848242964988591f,-0.27529420336424903f},
{0.4982466144133626f,0.7712734026416045f,-0.3960904563395377f},
{-0.17815941631382276f,0.8094564629164485f,-0.5594992913503203f},
{-0.01844934955240568f,0.7338879032444519f,-0.679020004839736f},
{0.7510932055349627f,0.2888823208545739f,-0.5936379378854499f},
{0.854723407764435f,-0.47429314139110973f,0.21093580124982145f},
{0.9687850937903868f,-0.10800472146119541f,0.22313767541955126f},
{0.9566598822001365f,-0.290779945284914f,0.015776349670419902f},
{0.5195410007982676f,-0.8233058585445884f,-0.2285708025441853f},
{0.8484708197830262f,0.0650045513236759f,-0.5252348772539075f},
{0.8479790962021693f,0.5247913356195345f,-0.07433375049610474f},
{0.8933193194748461f,0.4461575183909167f,-0.05407459880809789f},
{0.905824542208707f,0.23229866090235815f,-0.3542869329729192f},
{0.8952309275736634f,0.10972930910089887f,-0.4318808458820994f},
{0.8684762909977016f,0.05760204816761904f,-0.4923727612508339f},
{0.6351922798265812f,-0.03767382694159421f,-0.7714346702166586f},
{0.35344994570479293f,-0.0049925292227238245f,-0.9354401159525068f},
{-0.0019049296095249833f,-0.026275712645250134f,-0.9996529188514217f},
{0.6099520950579026f,0.03079370310702169f,-0.7918397499389837f},
{0.8840011087893481f,0.06462824227763285f,-0.46299592866385614f},
{0.9218675595415592f,0.053024598716021984f,-0.38386012373766404f},
{0.8762893801879359f,0.06415209619411259f,-0.4774949536107628f},
{0.7288386135111319f,0.09626954863444584f,-0.6778838023296402f},
{0.59296146515949f,0.19461693782848194f,-0.7813583994212744f},
{0.7038059801651798f,0.32255358855613f,-0.6329425920202347f},
{0.5401420969456215f,0.5357210489969163f,-0.649037343123514f},
{0.5956451922665977f,0.6515508918615314f,-0.4697746696493233f},
{0.7069616741949764f,0.5103427517669994f,-0.48964830944089127f},
{0.8175944466177815f,0.5112599195587111f,-0.2648633902837158f},
{0.8685838831147193f,0.31142843733150144f,-0.3854534555748782f},
{0.6842157605684953f,0.6553814743516071f,-0.31988109676313975f},
{0.6729363693761864f,0.4847842682777535f,-0.5586956738701312f},
{-0.33806955916022413f,0.8667657799491808f,-0.3666415904917229f},
{-0.6983521306065086f,0.685160338021622f,-0.2070256333873814f},
{-0.40988785081504014f,0.8920877271957193f,-0.19018789851355763f},
{-0.6101272587134889f,0.6967946034796801f,-0.37712333358777844f},
{-0.9628891065087446f,0.24168075888074042f,-0.12014565890460215f},
{-0.6764910637683653f,0.7360146555202519f,-0.02534299707908322f},
{-0.7771098544246268f,0.6292758658909922f,0.010590503447776598f},
{-0.6295512547650937f,0.7763505980604953f,-0.030740307656356953f},
{-0.5335454792292325f,0.7933419613732999f,-0.29315141807334705f},
{-0.595674979774392f,0.642046224069483f,-0.4826468321960657f},
{-0.6276844761666355f,0.5663225833534723f,-0.534126323975205f},
{0.07025863430699136f,0.9118337979252699f,-0.4045032129248105f},
{0.33013966641740033f,0.8848321767793956f,-0.3287549537172696f},
{-0.2613129095455237f,0.7921504880775164f,-0.5515552261953516f},
{-0.6867268710216227f,0.4164015583892872f,-0.5958321464874353f},
{-0.9478067086234656f,0.030441012635715f,-0.31738901656809954f},
{-0.9879272947991564f,-0.1548275543311978f,-0.005299868926739619f},
{-0.9816925752647817f,0.14088168481569333f,0.12818751325106778f},
{-0.7162742654723302f,0.6759739532111043f,0.17323507497682256f},
{-0.7476547063534507f,0.6365165456093647f,0.18936506339094641f},
{-0.5402566356222203f,0.8132904709792655f,0.21605873618181717f},
{-0.46711815426794845f,0.8835327141240834f,-0.03421363800936357f},
{-0.6608215302238651f,0.7465591674697882f,-0.07722897551700386f},
{-0.7645895315840397f,0.5964060865584508f,-0.24434121246349808f},
{-0.6799023939542332f,0.6015728755091196f,-0.41933615411384684f},
{-0.4815206115238721f,0.7275791911448289f,-0.4886373105798539f},
{-0.4517911709371601f,0.6577859499869284f,-0.6026627430520523f},
{-0.5503179307109399f,0.556290785940501f,-0.6226481643879861f},
{-0.4744267248956195f,0.6115390380252104f,-0.6331976687228218f},
{0.5647226168609677f,0.7871681390406432f,-0.24790055846042625f},
{0.6135058213169716f,0.7538652721018371f,-0.23515475485095225f},
{0.14586396108174424f,0.865147326031916f,-0.47983727358070966f},
{-0.23689032748427846f,0.7071540597925094f,-0.6661952480041893f},
{-0.6211436796024864f,0.34599222099642524f,-0.70318554613974f},
{-0.5939878422986942f,0.4204986658032576f,-0.6858274675594597f},
{-0.6294520058871558f,0.35052809217737024f,-0.6934841230187819f},
{-0.7715206352307966f,0.13156377698543031f,-0.6224523130316055f},
{-0.8051307758406321f,0.1314648089235069f,-0.5783437021434295f},
{-0.9297492464240973f,-0.07315437939805058f,-0.3608528447285808f},
{-0.9798681700198556f,-0.11199998756721688f,-0.1652706028514533f},
{-0.9948568519047294f,-0.10128635121908891f,0.0009587882636805379f},
{-0.9787385262371946f,-0.1528178762870428f,0.13681225802596206f},
{-0.9753501614379116f,-0.11997007318471574f,-0.1852005510874456f},
{-0.9736347953625517f,-0.2050943544956256f,0.0998578540393527f},
{-0.990904052175989f,0.07618680512428372f,0.11092668797975998f},
{-0.744545421200678f,0.5785623520720172f,0.3330431211329852f},
{-0.6962420803572473f,0.6013391690825659f,0.3919670512516347f},
{-0.505850822212615f,0.6671318289894499f,0.5468547050323448f},
{-0.38901269663589955f,0.8440194171156787f,0.3691887666056157f},
{-0.6527104399503657f,0.7331863861810172f,0.19080567260598053f},
{-0.9310974333968124f,0.33022072372358613f,0.15495755272118725f},
{-0.7695408752365548f,0.6231153029175734f,-0.13976466152106556f},
{-0.8389359572109354f,0.3837217203503979f,-0.3859327674996029f},
{-0.9124342472021489f,0.1636279870732449f,-0.3750861586075999f},
{-0.5216733769718577f,0.6414229765633327f,-0.5625241798317763f},
{-0.597952363118591f,0.4405830837812816f,-0.6695815990054304f},
{-0.4462932301676834f,0.5254012577612804f,-0.7244141571293039f},
{-0.5094947234079611f,0.4140237535820109f,-0.7543205275539752f},
{-0.5851051050086201f,0.45691122806507206f,-0.6699881683738298f},
{-0.4913973407588921f,0.4812826737026753f,-0.7258757755213309f},
{0.47847906583670113f,0.8046579747619067f,-0.3515442037754346f},
{0.715602683335073f,0.6925802688748758f,-0.09080402396836762f},
{0.3319334828132753f,0.8232740702306556f,-0.46047797805465013f},
{-0.21002099858128892f,0.681625369850992f,-0.7009122879008589f},
{0.04609540846513728f,0.8259764319208514f,-0.5618168271151476f},
{-0.17717521875454903f,0.723093955680457f,-0.6676406766499978f},
{-0.4583350890721658f,0.49675869971064895f,-0.736993718010537f},
{-0.5497460514100623f,0.28101919593440755f,-0.7866431786238435f},
{-0.5336339378786024f,0.14123036453100418f,-0.8338397954515098f},
{-0.3753392688703895f,0.3758804217929015f,-0.8472510500180168f},
{-0.46703549136563743f,0.28312033809874715f,-0.8376877246084657f},
{-0.7019415343859376f,0.01101419355514284f,-0.7121494013507598f},
{-0.572406091447867f,0.4861214181411521f,-0.6603311542686828f},
{-0.7422352071264638f,-0.03966459050437621f,-0.6689645861793099f},
{-0.8440342248731671f,-0.08108499050196163f,-0.5301239963990018f},
{-0.9167415645298457f,-0.1135426395074412f,-0.38300518648845217f},
{-0.9752185791174858f,-0.12269209224754193f,-0.18410696196503f},
{-0.9891192333660103f,-0.04651298713781843f,-0.1395696392950606f},
{-0.9999115206121469f,-0.010533846580267518f,0.008123362809047132f},
{-0.9824964194186867f,-0.08731453894496742f,0.164550773678788f},
{-0.9398797608562549f,-0.13165044926133104f,0.31510981314785913f},
{-0.9088353492038035f,0.3002140175739736f,-0.2896374487004301f},
{-0.49235671395691266f,0.35705325862170356f,-0.7937870222730865f},
{-0.36272335685473345f,0.0921731335077199f,-0.9273272776379448f},
{-0.7958278217507729f,-0.12098695313737283f,-0.5933129320164486f},
{-0.7098779669879703f,-0.02550948373123773f,-0.7038625847598321f},
{-0.7196756910147536f,0.5010903095599222f,0.48059900273260886f},
{-0.3848183545297172f,0.6295606581869505f,0.674957933267144f},
{-0.3295528442023049f,0.7133874811565986f,0.6184441968417322f},
{-0.5544071170968474f,0.6771112141077938f,0.48389374065163493f},
{-0.9031611096252935f,0.2503529738010291f,0.34874546386926625f},
{-0.5700497337630724f,0.7297058954674583f,0.3775878800447457f},
{-0.6247101685426893f,0.7703184344723862f,0.12785427185423562f},
{-0.5768869319174864f,0.8119750481609042f,-0.08887063039568653f},
{-0.588682618822012f,0.7243922962729098f,-0.3587597739397751f},
{-0.565705246864234f,0.5572659785442241f,-0.6078093474334074f},
{-0.6911389501076067f,0.41528710362629523f,-0.5914926653863409f},
{-0.9052784211294297f,-0.06338458090305324f,-0.4200635370288061f},
{-0.8272484500172804f,0.19985912798033326f,-0.5250869746117758f},
{-0.842240584106973f,-0.11657742702089559f,-0.5263463707411049f},
{-0.6391761429347366f,0.20673396790129922f,-0.7407529445225701f},
{-0.4681334616358778f,0.2994848140674264f,-0.831360275837022f},
{-0.4135948048077616f,0.4234248707742599f,-0.8060091291330581f},
{-0.46208631633716074f,0.3083673603997102f,-0.8314961258442931f},
{-0.4547906482795082f,0.3545840244428869f,-0.8169673407471016f},
{0.33778504182449837f,0.4797026397272952f,0.8098065466259745f},
{0.2713104430302181f,0.3668131761795355f,0.8898532110881142f},
{0.8021492623361867f,0.16846840978286287f,0.5728655652408728f},
{0.6637464128226789f,0.2755009359498129f,0.6953703572599305f},
{0.6865724309894244f,0.14718351526021053f,0.712007942259719f},
{0.8230091660292265f,-0.03477232567995071f,0.5669627836098985f},
{0.9682463559661835f,-0.21165916861177012f,0.13303905629844637f},
{0.6270082392497494f,-0.03966994646137722f,0.7780019044068469f},
{0.04766847290721289f,-0.255195179556207f,0.965713796640583f},
{0.04717014654199156f,0.16065255245909577f,0.9858832256730938f},
{0.09805634734206521f,0.4779893665234112f,0.8728752019827808f},
{0.12431027998464446f,0.516626069825301f,0.8471389840321377f},
{0.19793912248992357f,0.551532891963906f,0.8103280649649557f},
{0.3009686550966131f,0.5432352253995167f,0.7837814481948857f},
{0.49459950861383173f,0.33552142105236843f,0.801746033413297f},
{0.5361845757453537f,0.17463483683022796f,0.8258382253795562f},
{0.653680016097698f,-0.08209763872772625f,0.7523047349776852f},
{0.7877767610207866f,-0.5043014185624153f,0.3536776131331105f},
{0.8882493455861206f,-0.4296704091314843f,0.16246981129616472f},
{0.8903398704632322f,-0.4535473529034006f,-0.039871214401284626f},
{0.9442859386663811f,-0.31506162771413365f,-0.09518527606238458f},
{0.9440632191826726f,-0.32340388217166866f,-0.06445593209893681f},
{0.9236530958618465f,-0.25952534116904763f,0.2819779349451232f},
{0.12459262606637492f,-0.13311424628709398f,0.9832381578057797f},
{-0.07111333220804275f,-0.2350068326133545f,0.9693888191057846f},
{0.06368304615273532f,-0.15417801203786594f,0.985988646099315f},
{0.15322470309718814f,0.3811329564523879f,0.9117345336591353f},
{0.17735430405778407f,0.5183046783150821f,0.8366036763419573f},
{0.2173369472213854f,0.4669348534422887f,0.8571677163853741f},
{0.23997412301603446f,0.4825716046981166f,0.8423402321044446f},
{0.28581658497568574f,0.5663833702183234f,0.7729933749347212f},
{0.2138144793470536f,0.5402308411105833f,0.8139004894546384f},
{0.19804446204109977f,0.5963027921264761f,0.7779468948180331f},
{0.23055353540045512f,0.5204821079359218f,0.8221577966746594f},
{0.3099392876540589f,0.3089670615417671f,0.8991534868145374f},
{0.4690862810212001f,0.020356808732938502f,0.8829176979174844f},
{0.40875229201683566f,-0.1594497475340469f,0.8986085587074676f},
{0.56106318664222f,-0.47091567393921174f,0.68076907144292f},
{0.7035729704778517f,-0.3381929316969668f,0.6249884928246142f},
{0.6553765625436911f,-0.6596813254413392f,0.36783435148497656f},
{0.7333816705892499f,-0.5738049586079452f,0.3645534181991104f},
{0.830762874140876f,-0.5433850007211647f,0.12068880619365929f},
{0.9181330351609398f,-0.39076602454372655f,0.06583041704601231f},
{0.95433813233692f,-0.1402780408444623f,0.26374381589815254f},
{0.9957496935739704f,-0.09115434768591757f,-0.013169382874642123f},
{0.21929615339902955f,0.3907195568727467f,0.8940063897878772f},
{-0.7012973084570999f,0.191457481494521f,0.6866775938754682f},
{-0.7664178725434002f,0.21801742496355725f,0.604211922307321f},
{-0.8168033272570349f,0.03545654452192047f,0.5758256316215894f},
{-0.47242095262516987f,0.13740658133277106f,0.8705962755072914f},
{-0.4969145219689383f,0.10990610169059924f,0.8608115976609267f},
{-0.10060358860604134f,0.40546061787961124f,0.9085596322246936f},
{0.6954965111825931f,-0.038575773207596975f,0.7174932143611372f},
{0.8510877015251084f,-0.2948762650486724f,0.4343934997483886f},
{0.6873501685064208f,-0.4757368130065584f,0.5488389842244787f},
{0.3100885722762583f,0.02780355662428349f,0.9503010257716824f},
{0.5270956757483928f,-0.6520218955057081f,0.5450115561971955f},
{0.6737978402890537f,-0.47826945819383326f,0.5632537578931757f},
{0.7736595360334749f,-0.633034640149092f,0.026796766144030964f},
{0.7780488631282632f,-0.6059947972436635f,-0.16556047927699608f},
{0.7244236792837511f,-0.5763327419875103f,0.3782207072677945f},
{0.6901634498092301f,-0.12067843498983882f,0.7135202364865524f},
{0.7443753049719946f,-0.02019400767943695f,0.6674560715145924f},
{0.6636484176334083f,0.23534762475359974f,0.7100579365766656f},
{0.4440026968461242f,-0.17192344249688918f,-0.8793770153429004f},
{0.4671723312686641f,-0.14338090723898025f,-0.872463138669095f},
{0.34662884325168675f,-0.15434843730770656f,-0.9252161936145878f},
{0.3339679721461757f,-0.21315690430477185f,-0.9181663943576772f},
{0.2350697317891414f,-0.2108871843054068f,-0.9488249663095499f},
{0.16512963932867675f,-0.06990221365460103f,-0.98379158501248f},
{0.2583215563871258f,-0.08581474310025033f,-0.9622399926070266f},
{0.3780267026914424f,-0.1118917212484818f,-0.9190081908058751f},
{0.5476440373318561f,-0.10456601417319569f,-0.8301517674827873f},
{0.59548020764479f,-0.12064947531861867f,-0.7942587905768874f},
{0.5424618059126879f,-0.13529452476682644f,-0.8291143351155279f},
{0.460986871389162f,-0.12664578152285041f,-0.8783233746344785f},
{0.33331484423589447f,-0.16021186540707982f,-0.9291035317954535f},
{0.20820480613749784f,-0.19738164144089948f,-0.9579620275999164f},
{0.09294747101312821f,-0.2670733875724218f,-0.9591832845097201f},
{0.042337330860199494f,-0.08002518428271664f,-0.9958933277696719f},
{0.10209152125940014f,-0.17038010090957442f,-0.980075477961256f},
{0.13256308420249477f,-0.24716401736723978f,-0.9598629991960359f},
{0.2657492582386531f,-0.20325291991450967f,-0.9423723161743619f},
{-0.24424986958065326f,0.6764736874702161f,-0.6947843920024991f},
{-0.36837101171551573f,0.5474479902509818f,-0.7514010218903406f},
{-0.23558637170943872f,0.30611571161103757f,-0.9223839940987973f},
{0.45563476957964205f,-0.07861718766224256f,-0.8866883863873408f},
{0.7268540468970729f,-0.08942549288237979f,-0.6809451341569974f},
{0.6843151380318149f,-0.0984785915638426f,-0.7225058884632706f},
{0.5739597962579732f,-0.08324997085957674f,-0.81464077643547f},
{0.4395154015950247f,-0.05877105368679652f,-0.896310311783429f},
{0.2694117499490075f,-0.1000393465414071f,-0.9578149289570411f},
{0.1870304047485959f,-0.15317627357093444f,-0.9703384239091527f},
{0.09631307697469119f,-0.1835051017617638f,-0.9782891539984853f},
{-0.05176528673457741f,-0.19546464137351824f,-0.9793436215455783f},
{-0.18192183600749712f,-0.12519642393265168f,-0.9753103613815128f},
{-0.19028750215550705f,0.007861547567302085f,-0.9816969301129881f},
{0.06011663651034954f,0.13117052277794916f,-0.9895353879315494f},
{0.41515969253520646f,0.5560461096751685f,-0.7200383000988095f},
{0.047608970879711957f,-0.25504953054460444f,-0.965755208559991f},
{0.2774234086852937f,0.7054810074485263f,-0.6521754368594733f},
{0.05373508888712106f,0.7247920938028788f,-0.6868689547381891f},
{-0.0750547719893407f,0.7053425633378986f,-0.7048820110809686f},
{-0.332067056280094f,0.9418644466188345f,-0.05121361468271715f},
{-0.37035298723455046f,0.8639490259579242f,-0.3412194973807897f},
{-0.5797675146118453f,0.7739087611267599f,-0.25482319056955455f},
{-0.5714882725030724f,0.5939209358303416f,-0.5662676720190422f},
{-0.3857742087276212f,0.3693271414548354f,-0.8454440977766525f},
{-0.4623389750776382f,0.29556444548018895f,-0.8359930207197591f},
{-0.2943091935524269f,0.20446831276701227f,-0.9335817091528366f},
{0.24424312898828018f,0.1038682114317959f,-0.9641352024461994f},
{0.3801086503585935f,-0.02630614414820751f,-0.9245676831377042f},
{0.38943938269802864f,0.021608917783429084f,-0.920798578341652f},
{0.5096959568591424f,-0.02790246210882539f,-0.8599020200986325f},
{0.48432475745126247f,0.020474002995768216f,-0.8746486977759157f},
{0.3542316304564491f,0.04423583778706467f,-0.934110883481957f},
{-0.3197996226951093f,0.07535205838064087f,-0.9444841283059584f},
{-0.5810288905107375f,0.08218390676883192f,-0.8097229364789373f},
{-0.7602767194792501f,0.09240355420937539f,-0.6429936959157101f},
{-0.19199113568342996f,0.11175590395896405f,-0.9750128315818729f},
{0.3081545816908645f,0.09596977379166184f,-0.9464832572746893f},
{0.7424396527354591f,0.0940218847528741f,-0.6632821776842556f},
{0.8247006300240386f,0.14298738415756326f,-0.5471960149797612f},
{0.7901012602492435f,0.12406890535519254f,-0.6002890181208729f},
{0.6874163489821118f,0.1954066407504371f,-0.6994819568099901f},
{0.1836063723997383f,0.08425691281834037f,-0.9793821892685874f},
{-0.35952282685035536f,-0.1977125163198072f,-0.9119501619408921f},
{0.5967659727716885f,-0.051551335613940145f,-0.8007576621789385f},
{0.7200936265905957f,0.02691591132724506f,-0.6933546730649671f},
{0.7861459077977707f,0.05573391074692461f,-0.6155228207350826f},
{0.7275035621155235f,0.03003681254124713f,-0.6854461007268089f},
{-0.2792722784816432f,-0.6942454789316254f,-0.6633477289134785f},
{-0.1867801431062478f,-0.7094754088543176f,-0.6795276465105806f},
{0.34718681684971403f,0.8930493346185326f,0.28622403837406657f},
{0.3416237819144534f,0.8738469372482163f,-0.3459547974698112f},
{0.8564926999316825f,0.5092005982118517f,0.08446896320204995f},
{0.8161874611297183f,0.49717288677133126f,0.2943758634027008f},
{0.7964902069125026f,0.5890898820673987f,0.13629549199550706f},
{0.8619456250395093f,0.5068445080260505f,0.012585076840465264f},
{0.6189413558962521f,0.7734665515991537f,0.13660560573645128f},
{0.4651266508454836f,0.8721696602515218f,-0.15158259270116975f},
{0.4776690653658614f,0.8430986235726189f,-0.24701614304020658f},
{0.4705051499078818f,0.8441908746483305f,-0.25683977704134586f},
{0.0794137367098302f,0.9934365812823609f,-0.0823238567597329f},
{0.3334107062218909f,0.8809012763366534f,0.33593190132089984f},
{0.12127633584386194f,0.9922632889266204f,0.0265634299896081f},
{0.7245211157521021f,0.6627033997811523f,0.18945542153190326f},
{0.46747747564062025f,0.871803002152606f,-0.14637054077367007f},
{0.6842879566166666f,0.6219049473988243f,0.38076794616964915f},
{0.716096883902931f,0.6361245070532721f,0.2873166622226142f},
{0.7873525044243157f,0.6138634035617434f,0.05698908267685926f},
{0.8018162852536644f,0.5911478389754329f,-0.08737778422854386f},
{0.6759505459697069f,0.7298923634737553f,-0.10172510577999162f},
{0.46789163768832737f,0.8665783791903171f,-0.17354920945143548f},
{0.10852000908542268f,0.99362764520195f,-0.03045505407198699f},
{0.015469603165438663f,0.9455008833144519f,0.32525185784172705f},
{0.5026336825087537f,0.8106170065367686f,0.30043210534338316f},
{0.6361652865101906f,0.6575388726365069f,0.4036537615473424f},
{0.8965847061838578f,0.4374042313026746f,-0.06937869324022765f},
{0.7858485681176354f,0.4300112871088313f,-0.44444608328397783f},
{0.8393170869607636f,0.5431723900720665f,0.022596066009305145f},
{-0.14859657467000195f,-0.8566650418796395f,-0.4940081618938072f},
{-0.26701831846827734f,-0.8925512547156221f,0.36339162801025315f},
{-0.1632846659255061f,-0.8851060911777431f,0.4358042281043779f},
{0.08321013359468504f,-0.6885164701370844f,-0.7204312208789428f},
{-0.4176696996031144f,-0.8921731218009867f,-0.1719858795637761f},
{-0.14540205090522465f,-0.9122288997863793f,0.38301002335067735f},
{-0.16540075288639666f,-0.8602966792310427f,0.48221594192711376f},
{-0.18450933108422216f,-0.940009001893368f,0.2869483979782552f},
{-0.3208338233998409f,-0.9313887295999786f,0.17199038384973003f},
{-0.3196454519537048f,-0.9204409802649755f,0.22497819204127953f},
{-0.35365561169755017f,-0.9320535435260867f,-0.07876484187311386f},
{-0.11481333860483528f,-0.19284756104162384f,-0.9744884378373653f},
{0.06342455605117876f,-0.259784884236562f,-0.9635814130689254f},
{0.128785609248565f,-0.3066823689186866f,-0.9430589543845594f},
{-0.46661519369948434f,-0.09380804269019062f,-0.8794716096244539f},
{-0.6625228163088306f,-0.3241342605916503f,-0.675278090108749f},
{-0.03715500143026767f,-0.4490480305917391f,-0.8927347714133226f},
{-0.019613934544633515f,-0.9713917064169043f,0.23667160006247778f},
{-0.08840470038778761f,-0.8718453851429742f,0.481736684667303f},
{-0.03949439314308033f,-0.9293046774045668f,0.3671961457644317f},
{-0.08057976488877185f,-0.987995500214915f,0.13180209803167f},
{-0.19083565191859705f,-0.9810196733524167f,0.03438247303964421f},
{-0.3352449290151055f,-0.9415504218935058f,-0.03307023740189956f},
{-0.37678811358675973f,-0.926271303169184f,0.007224291314216074f},
{-0.07139239876464622f,-0.9921089338833088f,0.10306788397728117f},
{-0.023850763252248452f,-0.9464830620566591f,0.32187102126804706f},
{-0.2585693133137066f,-0.9012775268602703f,0.34762153240142246f},
{-0.4857534031098634f,-0.8704195834039803f,0.08008358254990733f},
{-0.43023005943107434f,-0.33655510709106556f,-0.8376352164593222f},
{-0.8026527133102133f,-0.09925601738766295f,-0.5881299727339974f},
{-0.5722754919803276f,0.06042197321239927f,-0.8178324684382458f},
{0.025771353628853712f,0.08554157509108419f,-0.9960012431031765f},
{0.08942376945054605f,-0.032366642865705016f,-0.9954676237260854f},
{0.1100127974048927f,-0.1504065177945475f,-0.9824841290382601f},
{-0.1387888870825239f,0.018110177669835525f,-0.9901563847631147f},
{-0.2066729554850062f,-0.038562716042209275f,-0.977649838338114f},
{-0.03601731945529007f,-0.0957812835776765f,-0.9947505709550855f},
{0.004442070267411613f,-0.2484683388116809f,-0.968629832608878f},
{0.4370517446179845f,-0.5351401716341787f,-0.7229182313579577f},
{0.0705110504212326f,-0.8635948699346782f,0.49923150180151965f},
{-0.007540878357525657f,-0.8784536699532521f,0.47776802414902125f},
{0.07156191772291653f,-0.8899790216848176f,0.45035123280918593f},
{0.04264100735238212f,-0.9550755404094029f,0.29327880353626173f},
{0.033778350849887444f,-0.9976267697347497f,0.059998761007796f},
{-0.07743218631113195f,-0.9956069082743487f,-0.052641625349820136f},
{-0.18988671830185788f,-0.9636118293353026f,-0.18813632445017758f},
{-0.38122950407002953f,-0.907139371937538f,-0.17821959798879672f},
{-0.289617361783292f,-0.940312379570509f,-0.17870202175726105f},
{0.22028803604955763f,-0.9734277983605748f,-0.06254200630226898f},
{0.28285115360905705f,-0.9365496399902427f,0.2070507105425447f},
{0.20546708323950166f,-0.9110450385256715f,0.35746358623335267f},
{-0.04428120949718111f,-0.8614700778494814f,0.5058739758630357f},
{-0.35752659988162705f,0.5831906110798475f,0.7294267896954408f},
{-0.6686944417968406f,0.3191398651713555f,0.6715634668208367f},
{-0.5722418606881179f,0.5112342233994585f,0.6412322681379604f},
{-0.38739032755590097f,0.5500521846462663f,0.7398454759488643f},
{-0.5731266732345668f,0.21197814903214104f,0.7915750632504699f},
{-0.7510212113171776f,0.2216500752011255f,0.6219633303620196f},
{-0.8425454326197285f,0.21717819087713816f,0.49290042339093987f},
{-0.767532481231077f,0.0547954687273526f,0.6386637197009207f},
{-0.5307288273907759f,0.055882203733543856f,0.8456973992405881f},
{-0.4266059580640985f,0.1817839728504038f,0.8859807806938795f},
{-0.25591383543395146f,0.11842607083033146f,0.9594182479925915f},
{-0.06983374527048432f,0.19847908745949974f,0.9776140853438751f},
{-0.09762300984374868f,0.6637738253045412f,0.7415349329530091f},
{-0.15128494660825273f,0.6443929951398865f,0.7495802376959949f},
{-0.24418589826198583f,0.30355943916752004f,0.9209912670499584f},
{-0.29238665204010383f,-0.03698469367956946f,0.9555847310114408f},
{-0.4611426824837758f,-0.07680444502043689f,0.883995759954068f},
{-0.6596216510881392f,-0.0653779166897963f,0.7487489602163461f},
{-0.8005766560654526f,-0.03211287145527799f,0.598369268303407f},
{-0.8724090433060997f,0.13247700622420042f,0.47048092839094874f},
{-0.9230979104359089f,0.07668451049746221f,0.37684178855140704f},
{-0.8684490366089667f,-0.014052033074462867f,0.49557926831076365f},
{-0.8085978016030271f,-0.018047827758308693f,0.5880849183204395f},
{-0.7275314016003919f,0.10687376256261445f,0.6776990914565838f},
{-0.6731489637891781f,0.08444078572946795f,0.7346701479269087f},
{-0.3807264103344303f,0.019879462604429615f,0.9244740166388767f},
{-0.29382027059796f,0.08940334278903742f,0.9516704738951858f},
{-0.2652441515414017f,0.03941422562987795f,0.963375346835842f},
{0.11222716128416035f,0.12425895484789257f,0.9858827396857135f},
{-0.07870988259667333f,0.21100465446684585f,0.9743109309532275f},
{0.24362783331874568f,0.2606431173057114f,0.9341898330818929f},
{0.2032830367332144f,0.28983255689033616f,0.9352395928011884f},
{-0.04176215739039658f,0.6507882513744491f,0.7581098694009244f},
{0.008803148453651209f,0.6142541170921323f,0.7890591766228107f},
{0.011479838109745963f,0.2205141966433312f,0.975316206363721f},
{-0.07945799475299647f,-0.11933715052166387f,0.9896691727922026f},
{-0.06096149498285322f,-0.3900494657344734f,0.918773699237036f},
{-0.14987895675663712f,-0.11669230846999848f,0.9817938701506976f},
{-0.4559970108888102f,-0.18200388868691664f,0.8711723770662789f},
{-0.7261806471300151f,-0.19369760067337186f,0.6596536267066312f},
{-0.9052345894221524f,-0.0563809745966935f,0.42115498788122435f},
{-0.9360498740743701f,0.008006855224105023f,0.351776240691119f},
{-0.9072156187691194f,-0.1226347354321903f,0.4023935172525032f},
{-0.8741036135453287f,-0.09769343402862693f,0.4758138982151455f},
{-0.8852063274885432f,0.02852818004871617f,0.4643230564136937f},
{-0.8256810167071391f,0.12328801777765405f,0.5505006115545394f},
{-0.7440390165459813f,0.3497498987158459f,0.5692810818967592f},
{-0.6384502748397509f,0.4095023086141448f,0.6516817519286021f},
{-0.6020467256917467f,0.22594306589119684f,0.7658260057346793f},
{-0.45274266642777256f,0.3316368604121085f,0.8276720792752829f},
{-0.16543365395536241f,0.2978056996401382f,0.9401826798026143f},
{-3.7027608656151063e-05f,0.03149161122197898f,0.9995040155255006f},
{-0.08635046674774116f,0.4709006777275597f,0.8779499693081446f},
{-0.21169857203494888f,0.5053285880937755f,0.8365564730808762f},
{0.24330237032489455f,0.1936684830791852f,0.9504191050563405f},
{0.35981682031529366f,0.26671085151122564f,0.894090139473839f},
{-0.888547203228038f,0.03787319023331302f,-0.4572193008799857f},
{-0.9682670950993127f,0.055109025922943436f,-0.24376592832010527f},
{-0.9925701758332159f,0.027533938490208226f,-0.11851720667327749f},
{-0.8880732208863895f,-0.04715654084272881f,-0.45727695655939415f},
{-0.9833604473536087f,-0.08663761507614584f,-0.15967515221357448f},
{-0.9745044591980739f,-0.1822844245410539f,-0.13081837628103501f},
{-0.9220742709915947f,0.21738549813450048f,0.32019148017418353f},
{-0.923896217858311f,0.31854467572155587f,0.21200251931653305f},
{-0.7346755925670566f,0.6349833962681842f,0.23884693874941423f},
{-0.9716155524442784f,0.14322887976103266f,-0.188278268132037f},
{-0.9759809836245243f,0.15264869202200573f,-0.15543325393002907f},
{-0.9503187459190365f,0.11213254543485805f,-0.29038004995035255f},
{-0.8315085349602974f,0.03938951976016823f,-0.5541137266132677f},
{-0.7986625781126453f,-0.004739736649197993f,-0.6017604350727612f},
{-0.6994404147247095f,-0.11947133257087357f,-0.7046344491603188f},
{-0.802773892031313f,-0.24563942419613966f,-0.5433372355669053f},
{-0.922463373963339f,-0.24680404991867844f,-0.2968991152561954f},
{-0.9704905628290413f,-0.2391716294639959f,-0.03074083797341625f},
{-0.9966378687972134f,-0.07810382571516523f,-0.024753805525685093f},
{-0.988057245720404f,-0.1455978007800682f,-0.05043966284003985f},
{-0.9400944043427732f,0.339940703143528f,-0.025745470857809427f},
{-0.9834507857030573f,0.10097535224898486f,0.15042782434853103f},
{0.46464820498919546f,-0.8592945145709556f,0.21381062375051552f},
{0.48168896769091035f,-0.8651789945897802f,0.13943115048468255f},
{0.22949261219769065f,-0.9477256423236327f,0.22169629638074353f},
{0.9558234550308028f,-0.2869023543307065f,0.06394186337976542f},
{0.25163427065563276f,-0.9074876985719805f,0.3363722205714051f},
{0.143925609325794f,-0.9749659268985399f,0.1694900007878634f},
{0.5540162996993749f,-0.7940283738726155f,0.25016970470587024f},
{0.998171612986026f,-0.05968313171998999f,-0.009557971383606194f},
{-0.5151777001633521f,0.7469590524701625f,0.42029050808610535f},
{-0.4638449449079042f,0.6352528979758678f,0.6174962531842966f},
{-0.8162211029461325f,0.5209866044983613f,0.24971197215725796f},
{-0.7554456466739846f,0.5796914542087174f,0.30538449999747497f},
{-0.7072276447758001f,0.6413817134091991f,0.29741983149943885f},
{-0.7155321682943356f,0.22850303667850375f,0.660151557117537f},
{-0.5390354320946683f,0.6586147329844985f,0.5250404141037831f},
{-0.8476778545575109f,0.45126192222179357f,0.27893535531636576f},
{-0.6644409237066107f,0.48112545883291585f,0.5718710971597728f},
{-0.39300137284058295f,0.777850227606348f,0.49040691711900797f},
{0.08245011743695527f,0.9851014603369143f,0.15092081028377444f},
{0.026457911127948947f,0.9995821286260095f,0.011642468391259531f},
{-0.5747515935110755f,0.7813369299804483f,-0.24325543694891452f},
{-0.10320514791842159f,0.985798909877842f,-0.13247341894431094f},
{-0.0906043183817197f,0.9780705178480344f,0.1875337825754649f},
{-0.1254123717633881f,0.6947829939455912f,0.7082007683790539f},
{-0.5494900403814881f,0.5463927432516084f,0.632072516127329f},
{-0.35669646660666154f,0.7112970416656236f,0.6056600938051433f},
{-0.4975121481524663f,0.694278628060654f,0.5200565825551433f},
{-0.9724762611021825f,-0.05665209508291727f,0.22600987083628798f},
{-0.9398968891637491f,-0.33770881889833637f,0.050463763024550426f},
{-0.06569431522699977f,-0.9893241801896342f,0.13008429359059337f},
{-0.21069905301154768f,-0.47241536951655677f,0.855821025509757f},
{-0.95124341088289f,-0.13315475833735757f,0.2782189490024091f},
{-0.900953692108051f,0.1830676550661849f,0.39340650521494896f},
{-0.8123187728085733f,0.49312909606146066f,0.3113870677474903f},
{-0.8430058676362528f,0.5347280578272124f,-0.05836960941436827f},
{-0.30523302312459183f,0.920647132294323f,-0.24339609568039805f},
{-0.24698944588223776f,0.9416006841440598f,0.22887630991918664f},
{-0.5239131662988592f,0.7562661189086035f,0.39188844276097473f},
{-0.28058826045728724f,0.9179423390752118f,-0.2804497998335577f},
{-0.17522152213890063f,0.9618991743867189f,0.20987471618438325f},
{0.16806990075104522f,0.9529200571206244f,0.25238041365914177f},
{-0.2865997395113676f,0.7353880609690808f,0.614056177475768f},
{-0.9470061625618129f,0.13356060699237726f,0.2921316352772787f},
{-0.8792604291389401f,0.2403022571127933f,0.41128569507935014f},
{-0.8403407214822045f,0.21644187346345994f,0.49697121368384684f},
{-0.4050493581989819f,0.37310826139240344f,0.83470069048931f},
{0.24265003281902034f,0.3265444123422409f,0.9135040822793233f},
{0.19340818726444794f,0.19149237945694467f,0.9622494176194641f},
{-0.5956608964910625f,0.24872433018048365f,0.7637567046957648f},
{-0.7349829559362204f,0.28466865526964236f,0.6154379019773071f},
{-0.880556306706129f,0.16820413759227412f,0.443089109341339f},
{-0.9846166808872933f,0.03804463473738092f,0.17053620579275686f},
{-0.8512557881054577f,0.09894965649570617f,0.5153373154510916f},
{0.06532871725297311f,0.41637947525679564f,0.9068408301829802f},
{0.1926643144780804f,0.33537968812241875f,0.9221718531388824f},
{0.26839382798176276f,0.31776154513008786f,0.909391199395417f},
{0.13509369556605882f,0.2692502353535323f,0.953548113196378f},
{0.0648843895086718f,0.11633830619370832f,0.9910879953415164f},
{0.3592670700842395f,0.21904655458463038f,0.9071635901410995f},
{0.18921095825560635f,0.21052219854204085f,0.9591035487354953f},
{0.15122843821878929f,0.10923253723922711f,0.9824450174346586f},
{0.2073579321170998f,0.08903346498998142f,0.9742051786456475f},
{0.37884825010931883f,0.049388638755032084f,0.9241400141488475f},
{0.0327769603453419f,0.05616786064026921f,0.9978831806888095f},
{-0.8680249827836812f,0.011795524436166051f,0.496380393314105f},
{-0.9199297156190904f,-0.049256302494215615f,0.38897703657873905f},
{-0.7035201039225645f,-0.06676728759412912f,0.7075320435740752f},
{-0.5843905075620536f,0.0017488037379890992f,0.8114706873059873f},
{-0.7486121642844206f,0.060631902436606704f,0.6602299598566498f},
{-0.7219153233863803f,0.06325948848867603f,0.6890838141881502f},
{-0.4458290877729553f,0.20570673841641168f,0.8711608130911401f},
{-0.5489750684172032f,0.24351357059509665f,0.7995795865280416f},
{-0.9997492373775452f,-0.022300733571686535f,-0.0020346118012200152f},
{-0.9001075021041473f,-0.28372382974830995f,-0.33061650456198394f},
{-0.8740260149376708f,-0.4747600496825481f,-0.10335095760368619f},
{-0.9070258484364521f,-0.14773317503737105f,0.39430827947370256f},
{0.029824360802137895f,0.30438645300411143f,0.9520816113812511f},
{-0.06927245827334173f,0.5014331656500183f,0.8624187538029131f},
{0.2902104322606825f,0.26138979105552673f,0.9205722579673016f},
{-0.3051418238944051f,0.1080494598619067f,0.9461573767264863f},
{-0.7518915642024278f,-0.19911881999350317f,0.6284988235515017f},
{-0.6298644987139328f,-0.38190045142344436f,0.6763303619256018f},
{-0.36811383623663585f,-0.3391625499233515f,0.8657141377502376f},
{-0.5001625767687754f,-0.09931972194883283f,0.8602168271035074f},
{-0.6485848081069825f,0.13508544211324747f,0.749059189932209f},
{-0.5807575264306757f,0.2871232317678001f,0.7617617378638397f},
{-0.3026978053611616f,0.6905830489018615f,0.6568630688347045f},
{-0.39245470937544746f,0.6802634241987882f,0.6190484430045622f},
{-0.36920425880780416f,0.5958908579978512f,0.71316358616573f},
{-0.5132719901648286f,0.4885536312113414f,0.7055970617444837f},
{-0.6105837593940017f,0.3788860942868342f,0.6954371289486607f},
{-0.7358662126364031f,0.34704945823301253f,0.5814272014967381f},
{-0.6359133121288479f,0.22396039199235898f,0.7385499321480893f},
{-0.7701431393072261f,0.11307711678922526f,0.6277683574668657f},
{-0.7447160356448391f,-0.03232896452756526f,0.6665979780242438f},
{-0.7913233535446191f,-0.1296110197519821f,0.5975017436742331f},
{-0.6875337005256119f,0.01169820694965987f,0.7260582363665611f},
{-0.39470673490528796f,-0.01802537200929871f,0.9186303279254028f},
{-0.47014495813034285f,0.09177549230194354f,0.8778046350739748f},
{-0.8091457909310834f,0.20394309991987636f,0.5510810294444753f},
{-0.9673104788445752f,-0.1485623405392754f,0.20552291475884377f},
{-0.6882178133316196f,-0.6983552485047868f,-0.1966117704992799f},
{-0.7684853159883315f,-0.630033022055743f,0.11175289808153592f},
{-0.46649048435261947f,0.27646139310629775f,0.8402117150636401f},
{0.6836288386790661f,-0.5735466047753326f,0.4513268251245431f},
{0.5363661028040949f,-0.8422423327863812f,-0.05421491146632905f},
{0.8208003947437986f,-0.050245839097814035f,0.5690009381730236f},
{0.6400291605213824f,0.25205991806470296f,0.725829505729486f},
{0.5858792160378994f,0.21101393733573345f,0.7824440315223112f},
{0.3226469786903665f,-0.8926342297452377f,0.31480638339954986f},
{0.5450575995223161f,-0.8168067634067051f,-0.18904741324872212f},
{0.6272733682999542f,-0.7787193849120359f,0.011146343967897633f},
{0.4927608295995249f,-0.7981688540813738f,0.3465735783160834f},
{0.26585579065977066f,-0.7363981545220971f,0.6221241488554496f},
{0.42159505434524347f,0.2213083763031936f,0.8793635270635661f},
{0.31146290574788515f,0.48645749869409255f,0.8163026156440827f},
{0.61333488656876f,0.23077043237375502f,0.7553577460115944f},
{0.6401945777536678f,0.09393047781639716f,0.762448665781498f},
{0.13224389604147704f,-0.023314734329734646f,0.9909429726896017f},
{0.1565341228782829f,-0.3789586609298698f,0.9120786159542206f},
{0.09499764383909676f,-0.5802668644045711f,0.8088669938494877f},
{-0.42603178779466483f,-0.8188032467040643f,0.38478326233785803f},
{0.0591366645924911f,-0.9036511815415329f,0.4241667089712093f},
{0.6828949991859606f,-0.10761739824526993f,0.7225461339469791f},
{0.9062817791461473f,-0.3735604523577033f,0.19775218133310724f},
{0.8488243575563726f,-0.4458135038908024f,0.2841610982657842f},
{0.7313376012320351f,-0.5760023850655847f,0.36519387374780915f},
{0.41563941973476676f,-0.7986444096158879f,0.4352137173295855f},
{0.06593836458398813f,-0.8101226241119385f,0.5825405273266195f},
{-0.030501640260565482f,-0.6079396027360137f,0.7933971826056562f},
{0.13602787513182502f,0.16599242643961543f,0.9767000212715312f},
{0.23751223532851184f,0.503769230786691f,0.8305447008932387f},
{0.6247275955909803f,-0.1465155126978982f,0.7669736865407994f},
{0.6643201996430597f,0.14099017863409788f,0.7340302731324713f},
{0.4505483667196197f,-0.6370948081811958f,0.6253929761636667f},
{0.5594338907189478f,-0.507058107362017f,0.6556872712456064f},
{0.9474815097974196f,0.10264985087080411f,0.3028890831776608f},
{0.5719276228413779f,0.5949182309208013f,0.5647752586198113f},
{0.08295793026424429f,0.39632992131164957f,0.9143525443062837f},
{0.14906467752753552f,0.15422674817476575f,0.9767260783152304f},
{0.29359712733571497f,-0.018385227101567883f,0.9557524314615369f},
{0.29857579322471467f,-0.39181256825694827f,0.8702501979638538f},
{0.5838694636709154f,-0.4295929319365783f,0.6888732555577781f},
{0.49305792777462537f,-0.15101965459903824f,0.8567887392953876f},
{-0.16869788167997882f,-0.2345646607071906f,0.9573507427604621f},
{-0.4420561730892203f,-0.5586232102611123f,0.7018022861114676f},
{0.05876109700288806f,-0.1432717930996471f,0.9879374103560554f},
{0.625413454900711f,0.21130722628775508f,0.7511373153743142f},
{0.5013487124530178f,0.5789599337017299f,0.6430045596181955f},
{0.45921737086469855f,0.3878632184219212f,0.7991755314644605f},
{0.3408446068504636f,0.4513611770240651f,0.8246805695882519f},
{0.6052039046376729f,-0.7099534888491296f,0.36013091714300693f},
{0.19780989843160504f,-0.9271669228223713f,0.3181709309578311f},
{-0.0042025890446674855f,-0.9443842162783747f,0.3288172597197438f},
{-0.12735093525099744f,-0.9093938689185092f,0.3959602637438785f},
{-0.23393494968663925f,-0.7164981250052571f,0.6571947018799379f},
{-0.22626228964149886f,0.16114192605710292f,0.9606449166850327f},
{-0.09705577124605441f,0.23768108517180062f,0.966482218677296f},
{0.35863270759917665f,0.31173206445893953f,0.8798895959313594f},
{0.049797291896972386f,-0.31500217016824056f,0.9477836580723612f},
{0.6279266814094154f,-0.6930762510456069f,0.35405281104762515f},
{0.8647736516875629f,-0.4994966037083005f,-0.051668890358034854f},
{0.8647724933744073f,-0.17813398198639357f,0.46950699586340755f},
{0.6995805051549772f,0.6081666267683725f,0.37512727292518505f},
{0.6716066355404503f,0.7268044053310851f,0.14387454079636292f},
{0.5525701746612502f,0.81554418956905f,0.1719124106485538f},
{0.5038836987145473f,0.7439920374473779f,0.43883603587746417f},
{0.2041670513606993f,0.6378989727165336f,0.742563610572097f},
{0.23128709609245926f,0.6114130965175816f,0.7567564367667446f},
{0.5093514450074396f,0.2973918287880569f,0.8075389808788975f},
{0.5778642221209344f,-0.11542638589906674f,0.8079292606601441f},
{0.7826927146671527f,-0.03327455218822211f,0.6215182367265151f},
{0.7516605305242224f,-0.33098308588727543f,0.570488074992441f},
{0.7621772597404634f,-0.036428518076539296f,0.6463426241594047f},
{0.43406607596992836f,0.06682528160377982f,0.8983991448296486f},
{0.26908776180336447f,0.0506584208546208f,0.9617824602498071f},
{-0.3881797829273036f,0.03315861143131062f,0.9209869502954202f},
{-0.3957621926076629f,-0.1365785792979361f,0.9081401756223169f},
{0.010999629303411246f,0.24292613155086096f,0.9699824239463937f},
{0.5732032590416606f,0.20732705533625062f,0.7927506013555702f},
{0.7774403884703582f,0.33231201040710595f,0.5339992229528485f},
{0.9382129685178663f,0.184253293966213f,0.2929285738324163f},
{0.45187533975948896f,0.5781205820088564f,0.6794006696898286f},
{-0.27975874152100083f,0.8218200227017605f,0.4963334532640971f},
{-0.29024787744044417f,0.8251374948591773f,0.484669252396764f},
{-0.001515352656586387f,0.8913134479985443f,0.45338509142148964f},
{0.04713685043772255f,0.8786814019263948f,0.47507590050377974f},
{0.016167252561371796f,0.8448434340487659f,0.5347692884686867f},
{-0.016174930309734888f,0.7189179296155922f,0.6949067434603765f},
{-0.1453562676822294f,-0.6501133174050654f,-0.7458044180467643f},
{-0.41930504272744606f,-0.4907861956635301f,-0.7637487749839301f},
{-0.2659861560171868f,-0.24939950686009837f,-0.9311558681472938f},
{-0.19405601456686347f,-0.3658435162878811f,-0.9102201847907704f},
{-0.33263660844286197f,0.03786105755947587f,-0.9422947665375778f},
{-0.5381886190526233f,-0.036798653281005324f,-0.8420207060630603f},
{-0.3392041772774975f,-0.6891427030314607f,-0.6403302749175521f},
{-0.5748990273900901f,-0.4114346536294388f,-0.7072571202177833f},
{-0.38060179064706784f,-0.558760884875878f,-0.7368368547303882f},
{-0.21383002830119469f,-0.6125367309888545f,-0.7609700862623958f},
{-0.19743503218900688f,-0.6288857874736198f,-0.7520120174426809f},
{-0.18696083988856432f,-0.5477355762095103f,-0.8154945633801604f},
{-0.1606553808848643f,-0.21337872266040825f,-0.9636697407870354f},
{-0.19441517039305853f,-0.06120773386572677f,-0.9790078420707672f},
{-0.19912960349097567f,0.1112367854378091f,-0.9736394499911092f},
{-0.27689934757272855f,0.21217014489001693f,-0.9371822559839396f},
{-0.5239829395192136f,0.22109632046246602f,-0.8225316384010787f},
{-0.6351617583488983f,0.22821774579411766f,-0.7378930825233335f},
{-0.752102052280384f,0.20352227687418514f,-0.6268342570182187f},
{-0.39444639503356016f,-0.45711473421402843f,-0.7971562966002759f},
{-0.054559890074681906f,-0.8017386966062512f,-0.5951792005431206f},
{-0.5813620328993611f,-0.3239812864990062f,-0.7463607121905408f},
{-0.4354652938101998f,-0.43387149223493854f,-0.7887493303405233f},
{-0.18100590607122238f,-0.6350674633532547f,-0.7509501840717522f},
{-0.17061855945593246f,-0.6748971953980017f,-0.7179157908927021f},
{-0.38603031070448657f,-0.12031567360499645f,-0.914606329467697f},
{-0.2916431344794633f,-0.1626006731475257f,-0.94260559260115f},
{-0.13413622744299164f,0.15514822162918987f,-0.9787423061320388f},
{-0.06053382016461398f,-0.1683848495740164f,-0.9838608636642755f},
{-0.1452947505756802f,-0.5969286404397883f,-0.7890282844599785f},
{-0.12856235991265602f,-0.4874102360148877f,-0.8636567497806059f},
{-0.14767531766149702f,-0.3737090598895425f,-0.9157147695161689f},
{-0.08000884725700474f,-0.12202558627881152f,-0.9892968920672486f},
{-0.11664061128312937f,0.09850733770908278f,-0.9882769208157026f},
{-0.14477945000887754f,0.22761703636279634f,-0.9629275131662531f},
{-0.17987866758027013f,0.1960890328756266f,-0.9639464487903091f},
{-0.33128354181719377f,0.20224974766560905f,-0.9215998342503394f},
{-0.49866146711751685f,0.1129141562115684f,-0.8594109229811052f},
{-0.6695639333018109f,0.17553187088365496f,-0.7217151110552502f},
{-0.75482600645565f,0.24541362388547647f,-0.6082843522478717f},
{-0.7668971123556617f,0.18070365052011067f,-0.6158043599628483f},
{-0.7265482477920359f,0.002527800301962249f,-0.6871108017313916f},
{0.37154805667846824f,-0.7593179537830206f,-0.5342174525801459f},
{0.14888839852114408f,-0.8301247366196113f,-0.5373315237709675f},
{0.016312231921333648f,-0.685246807861289f,-0.7281282328035757f},
{-0.6262353080860962f,-0.16197658847416466f,-0.762622399154774f},
{-0.3796268978052679f,-0.3950371534185331f,-0.8365578676228747f},
{-0.6122254967098556f,0.09195445176595562f,-0.7853179738034735f},
{-0.5838045588874867f,0.1889906092568951f,-0.7895915315116384f},
{-0.7769619878728268f,0.08397322497986656f,0.6239219237109608f},
{-0.7622658976819144f,-0.03751068656331167f,0.6461761753769122f},
{-0.8836180996508346f,-0.14199878078410788f,0.4461562509091121f},
{-0.8173035638069317f,-0.1512547270569724f,0.5560008022758686f},
{-0.8578405851418127f,-0.22618869413364207f,0.46146311350927055f},
{-0.9220990814798935f,-0.19901570409924987f,0.33185242722604363f},
{-0.6243176806413631f,-0.37589593215957584f,0.6847844053601633f},
{-0.6273972276609393f,0.2210317743138227f,0.7466710610885163f},
{-0.6470475169338595f,-0.034892142510821844f,0.7616508709512064f},
{-0.8309545269378111f,-0.18707215042210418f,0.523945211542207f},
{-0.8679821103600583f,-0.1782476442843252f,0.4635027868330333f},
{-0.7881916610035795f,-0.2507083680124306f,0.5620491257292033f},
{-0.9161313150319819f,-0.1376279541536079f,0.37651289467063975f},
{-0.9102416096452843f,-0.13620271240091264f,0.39103584644504935f},
{-0.1745760969988611f,-0.2858852446820789f,0.9422275803805109f},
{-0.1441912798015706f,-0.4273446423736986f,0.8925163480092008f},
{0.1610695421204868f,-0.40029445861061913f,0.9021202519657389f},
{-0.46595432308239615f,-0.18335495766036627f,0.8656024077497656f},
{-0.9310530298156516f,-0.09062493597787477f,0.3534506707450157f},
{-0.995401160301497f,-0.060838094922170856f,0.07399497467176182f},
{-0.863920993000259f,-0.07908246643098213f,-0.49737961493877f},
{0.42803923717013576f,0.6922855702714252f,0.5809673834534741f},
{0.5383435803733938f,0.7445172986528509f,0.39481664285768997f},
{0.5379036872402689f,0.8353752359314157f,0.11317172105192282f},
{0.38964097576705525f,0.7100374483768143f,0.5865379202624836f},
{0.4468265890882255f,0.815271486408666f,0.36834549370500863f},
{0.4819220873814854f,0.8743584269387494f,-0.05699511325602905f},
{0.4537940322962706f,0.7770961382466328f,-0.43611072925859273f},
{0.46661809951438943f,0.7969217759474156f,-0.38364466922713303f},
{0.5350893208087992f,0.838029837833654f,0.1067024351028469f},
{0.23384388292366162f,0.7056824922951894f,0.6688267776391992f},
{0.5082266766028267f,0.6368323210960426f,0.5797846496731979f},
{0.3554208781083427f,0.6170677278240474f,0.7020708074565997f},
{0.16718207361491216f,0.581849070222259f,0.7959282717326422f},
{0.1063112089271848f,0.3128078196728935f,0.9438480782456099f},
{0.3121998765217818f,0.7024087858582465f,0.6396507911735343f},
{0.04465735571965374f,0.4573966047498613f,0.8881407920726462f},
{0.39083156698000215f,0.5224241343220833f,0.7578414808716781f},
{0.1288844763895403f,0.8492534419800657f,0.5120130691992199f},
{0.23185304144860752f,0.9658240053268501f,0.11587992882907294f},
{0.08575997262822603f,0.8259338656949313f,-0.5572059552741994f},
{0.1982321075052404f,0.6059570917110724f,-0.7704025146370499f},
{0.16499320550661264f,0.4071530434943289f,-0.8983338139633607f},
{0.2968343427223832f,0.5090057451837993f,-0.8079619572420821f},
{0.2188816156792954f,0.5158609550623175f,-0.8282380777046022f},
{-0.40422336247271023f,0.8701689749248072f,-0.28179678548479953f},
{-0.1310518438618909f,0.9845064363754128f,0.1165010341404057f},
{0.06174718663282402f,0.8175972351655946f,0.5724701267249731f},
{-0.31851158569677535f,0.6949938688872311f,0.6446191836938178f},
{-0.7612260495040755f,0.35285419855700767f,0.5440853022432333f},
{-0.47645625679828824f,0.035070063504288915f,0.8784984496307144f},
{-0.6402734454631503f,0.15677046577814127f,0.751979345523832f},
{-0.6887028549934863f,0.23509156272491086f,0.6858719520868165f},
{0.3290554265274491f,0.551811267563385f,0.7663072825328809f},
{0.5559056866686913f,0.4688147541555584f,0.6864266849529336f},
{0.4435781584349086f,0.4867252055373087f,0.7525536470273462f},
{0.24945689844649588f,0.3701324766747457f,0.8948593216411581f},
{0.15551129181731926f,0.5813473139873425f,0.7986560828272774f},
{0.03817768077935589f,0.7448417533682526f,0.6661480519596351f},
{-0.4428433830335907f,0.4534711914234363f,0.7734685621616264f},
{-0.20285002362681245f,-0.16832070213309794f,0.9646346506050997f},
{-0.10306143673246737f,0.023950564479838225f,0.9943866002313871f},
{0.2882196640315177f,0.5887620514244362f,-0.755174597075437f},
{0.2712666638253704f,0.4996080599854282f,-0.8226823101870189f},
{0.20793533319131247f,0.5622731372250734f,-0.8003822938856728f},
{0.23541948137648144f,0.6666086483378089f,-0.7072556664669912f},
{0.07523821532299162f,0.660203119436412f,-0.7473092077858012f},
{0.11663763648250144f,0.5266443557682526f,-0.8420459514143025f},
{0.22913305240277274f,0.43118531915333874f,-0.8726839432711144f},
{0.28211021087100074f,0.3814736117471863f,-0.8802793377461932f},
{0.3735634934664076f,0.4500152266977637f,-0.8111329188791032f},
{0.37477824948885613f,0.6221779782508123f,-0.6873396737347557f},
{0.3139374411575855f,0.7220421911215062f,-0.6165211734238183f},
{0.2740052914990036f,0.8090179910595744f,-0.5200105675584644f},
{0.07406815453870201f,0.821876546685201f,-0.5648299305915361f},
{-0.018503859534686716f,0.8504890632419645f,-0.5256671575133133f},
{-0.11682581124211765f,0.7679767649596765f,-0.6297328150173617f},
{-0.04557296804531578f,0.6253105779295924f,-0.7790441487572446f},
{0.02965421451762761f,0.47634610171607156f,-0.8787576565477221f},
{0.14402083177035324f,0.3529595647253605f,-0.9244877206783547f},
{0.25013715998550634f,0.2578046733973079f,-0.9332567447218867f},
{0.32300738610928f,0.27976569589565914f,-0.9041003173978361f},
{0.47743054404303603f,0.2834074331529503f,-0.8317092655780784f},
{0.553958825418062f,0.38939758483017006f,-0.7358662518894801f},
{0.5477184923243598f,0.5633305731327564f,-0.6185977033095503f},
{0.422932923478981f,0.7639607941316877f,-0.48733114744206874f},
{0.321530733282779f,0.8255199231089626f,-0.46382630812062686f},
{0.26600062250078543f,0.9133018490750057f,-0.308420818534304f},
{0.10280976840519611f,0.9214753868151145f,-0.37458412007772685f},
{0.05565604548087307f,0.9121677594836766f,-0.406020175804061f},
{0.09391295505393714f,0.8274597767476757f,-0.5536159993512868f},
{-0.032715633194211446f,0.7362715824127938f,-0.6758948470554146f},
{-0.16711853768022403f,0.7203728610087805f,-0.6731525350807553f},
{-0.18312349770429928f,0.6465865380708519f,-0.740534694240651f},
{-0.13499026074683962f,0.5475601726006839f,-0.8258059620062146f},
{-0.11075071048575924f,0.3498158496685218f,-0.9302489728280219f},
{0.03320204962261011f,0.31272141734129644f,-0.9492644199783896f},
{0.1353031861991426f,0.18280379729803806f,-0.9737945468617997f},
{0.25539720720310904f,0.1434788287007199f,-0.9561307924481471f},
{0.28069403991163483f,0.14627897900641448f,-0.9485849019771118f},
{0.34007973312861467f,0.16197562033910515f,-0.9263420931442834f},
{0.4973883151101658f,0.17699299768860235f,-0.849281074062688f},
{0.5860717441323892f,0.16976181938767f,-0.7922757319316346f},
{0.6498728006213597f,0.30025062969180094f,-0.6982226739244635f},
{0.6758785471103974f,0.4708912801722781f,-0.5669652474478938f},
{0.6926497436452852f,0.5765003121230751f,-0.4334555602943834f},
{0.5896142758979097f,0.6540942511404269f,-0.4738308941831756f},
{0.5007107184808794f,0.8154700248418387f,-0.2903401711489686f},
{0.37906864921467304f,0.8714208197333455f,-0.3113401903349893f},
{0.34317860683162704f,0.9285091424575769f,-0.14177170446107593f},
{0.28466912290833124f,0.9527515921103379f,-0.10596175816688673f},
{0.18792000157789437f,0.9494859737774517f,-0.25132142488623666f},
{0.41436160782221926f,0.7196945567848942f,-0.5570854538553128f},
{0.4545761371495776f,0.4834778059341308f,-0.7480706829593627f},
{0.3327934589434639f,0.4852475086265709f,-0.8085687163476899f},
{0.2784094924159668f,0.36939291961455567f,-0.886587291512414f},
{0.09828428230649185f,0.22244665058415983f,-0.9699781891853994f},
{-0.03655704732741257f,0.550338919096179f,-0.8341406694429606f},
{-0.11269152581571965f,0.47990116343962586f,-0.8700548794981949f},
{-0.1911425589269589f,0.634896854407148f,-0.7485789914436303f},
{-0.20453175846868485f,0.5582468624281526f,-0.8040691514831486f},
{-0.20193025084892513f,0.5190577059371141f,-0.8305439613285925f},
{-0.24894336950486354f,0.3917046202962366f,-0.8857734976946116f},
{-0.17347292910878556f,0.2648879376942018f,-0.9485470591017248f},
{-0.03272946650369302f,0.2085044483725508f,-0.9774736196088578f},
{0.1634373016329813f,0.4155263756828078f,-0.8947771116578921f},
{0.21041413553063934f,0.10761364815592858f,-0.9716713406803072f},
{0.3712947374322464f,0.01815234679187018f,-0.9283376057561531f},
{0.1671400521283107f,-0.08732578830278269f,-0.9820582516693411f},
{0.2338107766103229f,0.018836155481701384f,-0.9720996450917709f},
{0.4668649598458498f,0.08782948523797567f,-0.8799563005007496f},
{0.49363648999611637f,0.40638999309384705f,-0.7688759257887432f},
{0.5925252856774439f,0.3431779909083316f,-0.7287953432816271f},
{0.7066799560881712f,0.2010035269554747f,-0.6783811773735177f},
{0.8058481288116109f,0.3318013713273896f,-0.49042496192189167f},
{0.7525941642891212f,0.41052494412581825f,-0.5148507493715562f},
{0.7513296231021682f,0.5279664877202026f,-0.39592320630842914f},
{0.769858420414796f,0.5887203782655844f,-0.24642712661406035f},
{0.6727073845241061f,0.6692529012058029f,-0.31553974240078303f},
{0.5802143958676877f,0.8096968271521995f,-0.08799035701459296f},
{0.4297237849432112f,0.8990183091232816f,-0.08428255166519573f},
{0.35862560921696707f,0.9333760066252437f,-0.014032201184147266f},
{0.3729272088270203f,0.9115789512316329f,-0.17305811910431776f},
{0.5621940981927828f,0.6766306206344489f,-0.47550898958594284f},
{0.6775459198884349f,0.4461352258260096f,-0.5847177838237092f},
{0.6037254328664928f,0.38769182371634486f,-0.6965706364279652f},
{0.42798163087312185f,0.4962372997186743f,-0.7553676363222754f},
{0.3533600956647679f,0.4545643295745611f,-0.8176233320241149f},
{0.14564120276093867f,0.49897678611121543f,-0.8542896505170068f},
{-0.060638811591603954f,0.5312598499076385f,-0.8450360385243172f},
{-0.06137515038780566f,0.15045010263270703f,-0.9867106250226975f},
{0.22500609942771013f,0.5328898460089477f,0.8157209493698732f},
{-0.12087196005402784f,0.32203784570541333f,0.9389790174472025f},
{0.01501359555577606f,0.49617944032698375f,0.8680901767358556f},
{0.23445716116505266f,0.5763464153203995f,0.7828503363515595f},
{0.20792274791774926f,0.7953657180930038f,0.5693518291713239f},
{-0.22140715753303522f,0.8455901797076139f,0.4857531457182621f},
{-0.31278362976413393f,0.678664545990624f,0.6645154888841293f},
{-0.3005952957055125f,0.2938235754539403f,0.9073644111971652f},
{-0.10574399747034656f,0.5223321109757557f,0.846160370640579f},
{0.2105837031155499f,0.5349647763719447f,0.8182097481840809f},
{0.21160770542069443f,0.5148366429078634f,0.830761945521068f},
{-0.9686422961748119f,0.13923061598079067f,0.20578371566962625f},
{0.2520215383587393f,0.6586892983416688f,0.708952433138821f},
{0.17936675352117565f,0.7268051959175188f,0.6630096341069043f},
{-0.12620854932178643f,0.7239116485884467f,0.6782501950726201f},
{-0.6530600828740201f,0.6215315020481781f,0.43267900355611644f},
{-0.6349912187907325f,0.5415820558496773f,0.5508856767427313f},
{-0.5655771525168325f,0.3513570652423922f,0.7461036772829933f},
{-0.6213345109631998f,0.28702144983811795f,0.7290830630449087f},
{-0.42907169739045753f,0.3175363129626118f,0.8456170341523295f},
{-0.1787185164005351f,0.15371624724653718f,0.9718184023921513f},
{0.10942888787421035f,0.22783031951983237f,0.9675322547626537f},
{0.20625418116808214f,0.25463790574437134f,0.9447850283047486f},
{-0.9187152210399532f,0.06588941664266296f,0.389385319964684f},
{-0.9513644794311371f,0.09052778588309719f,0.2944662073308681f},
{0.16537413920942132f,0.2631407854312383f,0.9504779435228227f},
{0.25800511122357467f,0.2938320762292701f,0.9203782231024955f},
{0.1367495156618797f,0.09125675206009531f,0.9863933166692095f},
{0.0424715410410235f,0.13112321902561583f,0.990455889797199f},
{0.027964625260319564f,-0.414861820705976f,0.9094545890007771f},
{0.22910693272543786f,-0.27382095154319375f,0.9340942671235711f},
{-0.18449967729424718f,-0.8298987125299964f,0.5265244495931535f},
{0.24560730676075812f,-0.858849714804201f,0.44950441404559016f},
{0.2490901961407336f,-0.7334245928044733f,0.6324890835865578f},
{-0.27860768378640705f,0.061138021664400716f,0.9584570417301637f},
{-0.3454600202039911f,0.06909553662648861f,0.9358863078702218f},
{0.2830925432720812f,0.07381010971383717f,0.9562482311867437f},
{0.5733179934037701f,0.006706425033453556f,0.8193054999832147f},
{-0.05304791797720705f,0.115500054655016f,0.9918899413609212f},
{-0.09032704531713247f,0.06831843494365868f,0.9935661106997992f},
{0.4743182463426376f,0.04828481277203284f,0.8790283146986874f},
{0.3142096083003294f,0.11392367192389258f,0.9424933522455905f},
{0.1401625968655257f,0.06322638988772836f,0.988107721891534f},
{0.19389076046837186f,-0.3714820609981213f,0.9079688603479663f},
{-0.07641268357903827f,-0.754723094893801f,0.651578200849424f},
{-0.16316854560888153f,-0.6080416726999793f,0.7769564659516605f},
{0.039064951955012854f,-0.6800521341591577f,0.7321222741826171f},
{0.5530244731244648f,-0.47735578750293933f,0.682858246097136f},
{0.5312730312660119f,-0.6306694014787039f,0.5656899082429493f},
{0.42266380424367117f,-0.11322275708555736f,0.8991862520413735f},
{0.010645809739733631f,0.14483409035897737f,0.989398682536455f},
{-0.2772484535731797f,0.16172899796071302f,0.9470887108449261f},
{-0.5282014868552701f,0.02650644163973835f,0.848705247913244f},
{-0.315038231607103f,-0.10252735898510928f,0.9435248026869286f},
{0.5099539084311108f,-0.21719278495942904f,0.8323306467008177f},
{0.7671595390076441f,-0.07953320435974999f,0.6365066465590513f},
{0.7561360678483592f,-0.0001516318739645696f,0.6544144129728473f},
{0.30740557804899477f,0.01148531673265943f,0.9515092737771472f},
{-0.3670955745911348f,-0.08716424010626635f,0.9260902949293345f},
{0.24754789254586634f,-0.029501290560172058f,0.9684264116345571f},
{0.30828834562302604f,0.09141825649662207f,0.9468901722650497f},
{0.3070019497711548f,0.18405896329775673f,0.9337409174211357f},
{-0.2747387425842081f,0.2238655575767894f,0.9350950943375126f},
{-0.007136426417828536f,0.12191518461570613f,0.9925148659733523f},
{-0.07085379185310066f,0.059734858363697324f,0.9956964833102036f},
{0.018929097263580302f,0.026193938736218787f,0.9994776469988056f},
{0.6326005140476783f,-0.6516839851443883f,0.4184788801516055f},
{0.5803385061705664f,-0.49776994008417375f,0.6445403827568242f},
{0.03959862072326786f,-0.2417381021651832f,0.9695332068569855f},
{-0.32909810590436955f,-0.5692441296494956f,0.7534291987637223f},
{-0.34098098574231334f,-0.49209704796797843f,0.8009821862834413f},
{-0.023218935990745718f,-0.45980712515074323f,0.8877152069622702f},
{-0.14731566364557636f,-0.1751906061395393f,0.9734507418278154f},
{0.0818796752389212f,-0.23926248227491137f,0.9674963479819532f},
{0.5374452913571772f,-0.08046626099526397f,0.8394508560001835f},
{0.5859698747721509f,-0.29834171878984755f,0.7534132496107494f},
{0.6349312669918014f,-0.31284702060160197f,0.7063915542366619f},
{0.771271563625494f,-0.4131939780076859f,0.48416000627981404f},
{0.30750457053489316f,-0.36213496945889545f,0.8799427271107796f},
{-0.010340722058492263f,-0.49263303457020113f,0.8701757079564242f},
{0.31377697048029773f,0.26585366666714205f,0.9115184258784035f},
{0.06912187074541826f,0.19402193862678105f,0.9785589682365389f},
{-0.021944668920251844f,0.2769831189162223f,0.9606241634174223f},
{0.12280041413712092f,0.1316999263852514f,0.9836539979473835f},
{-0.1461061988536082f,-0.05834869005968181f,0.9875466616949647f},
{-0.4662686955208387f,-0.09819862029633572f,0.879176054353843f},
{-0.6971198394949459f,-0.28477326264848213f,0.6579727336775283f},
{-0.5296884939310315f,-0.25444731764898276f,0.8091270987541533f},
{0.02654496091987886f,-0.09576053311565443f,0.9950503933706912f},
{0.49592261703974144f,-0.05540687726047672f,0.8665972743210635f},
{0.8688772438318446f,0.0955307190065688f,0.48572236604593905f},
{0.7416236692809758f,0.10290073999564552f,0.6628768896790493f},
{0.19042400668370496f,-0.049699733213431956f,0.9804430805493187f},
{-0.17957719164693559f,-0.22069759120328822f,0.9586681414740275f},
{-0.7204821681719058f,-0.23320074450349929f,0.6530871749692557f},
{-0.7135680893830522f,-0.1355604204952782f,0.687345585720432f},
{0.37940892082797f,0.29556682778451837f,0.8767491779919454f},
{0.18976609651260273f,0.34981916466897534f,0.9173959781057849f},
{0.7883313613013515f,-0.4584417573878071f,0.41032282397148834f},
{0.309760272799498f,-0.7888963647982721f,-0.5307457950876786f},
{0.39125190987609626f,-0.7603859088298016f,-0.5183967714708335f},
{0.9418065976440099f,-0.3130281540135868f,0.12253043470526172f},
{0.4186774487509542f,0.24859224131101784f,0.8734478183997925f},
{0.5442124328881525f,0.20827523860805652f,0.8126833656921466f},
{0.7932139350416644f,0.013422179420337568f,0.6087951201802841f},
{0.8812282233216313f,-0.20874423272955672f,0.42410218547367795f},
{0.18850267285261504f,-0.7402091652366776f,0.6454123751734553f},
{0.27603984020962935f,-0.5747855168208896f,0.7703399355284555f},
{0.22734058903405385f,-0.7996484251348817f,0.5557685244388647f},
{0.1084157625414667f,-0.8233296416094753f,0.557112487456317f},
{0.09551865736784987f,-0.6873124400242042f,0.7200540228917675f},
{0.2157592000663475f,-0.6332469065502526f,0.7432673293851045f},
{0.3097923454609383f,-0.7027331258679889f,0.6404645630334406f},
{0.3320345410421248f,-0.7937972883993523f,0.5095477685995506f},
{0.423860704826683f,-0.5680211656284305f,0.7054743498540161f},
{0.24676967746103406f,-0.21886332359220587f,0.9440357895079776f},
{0.21760101767872614f,-0.15669397841491953f,0.9633778045158023f},
{0.09760120288793671f,-0.6448204598917223f,0.7580768956378077f},
{-0.015712404377863656f,-0.7961468743869028f,0.6048993922567882f},
{-0.04864574787437374f,-0.6593834990252562f,0.7502312926204511f},
{0.018930943599435122f,-0.5327639481669644f,0.8460521230444275f},
{0.17722707813175448f,-0.4909517942996891f,0.8529694592720168f},
{0.31961907516447047f,-0.5309235209713218f,0.7848336522285617f},
{0.4309533432022048f,-0.6680335001264376f,0.6066386557842022f},
{0.5417046558410493f,-0.6523964706830844f,0.5300329337695778f},
{0.6077001463798777f,-0.3569230849367534f,0.7094409373084601f},
{0.402932497507374f,-0.27495894946577265f,0.8729507308898644f},
{0.3150573609485628f,-0.7221552850076967f,0.6158170212389226f},
{0.25964705144361205f,-0.47441005208977993f,0.8411411957292371f},
{0.21616959373923178f,-0.5097524093446247f,0.8327203539664236f},
{0.17295079620059253f,-0.19326524503243145f,0.9657828778540938f},
{0.002835294402076379f,-0.5976275192778289f,0.8017688627699893f},
{-0.1153013151215673f,-0.7399664048210749f,0.6626879555774424f},
{-0.1590086322454889f,-0.6307201791346987f,0.7595448048033194f},
{-0.05463132092186265f,-0.45357798531241117f,0.8895405724385294f},
{0.05536679223210084f,-0.3318713956173501f,0.9416984098366736f},
{0.208738848656036f,-0.2703756073886525f,0.9398537779840914f},
{0.27059577794443307f,-0.31481278922378797f,0.9097641632312111f},
{0.39387383374958845f,-0.3603130577338144f,0.8455991387849863f},
{0.4962439123385041f,-0.5142500075539103f,0.699491893589753f},
{0.6326015832053663f,-0.5340727881612946f,0.5608756492054945f},
{0.6345406303482403f,-0.6052441683551004f,0.48066379633731604f},
{0.6227257268909917f,-0.42274655557995305f,0.6584056643235776f},
{0.6846316120403474f,0.0474149242650545f,0.7273454342690098f},
{0.6386925050193307f,0.07245747685121755f,0.7660429479347013f},
{0.4662746986616004f,-0.6828237121987564f,0.5624408266183596f},
{0.4854154605184392f,-0.7588644771816503f,0.4341618776003858f},
{0.40039444662687235f,-0.7730416365088836f,0.4920273522214267f},
{0.24769974059873057f,-0.8850517688601018f,0.3941169939813891f},
{0.20476990210890442f,-0.8282533579419894f,0.5215991394242598f},
{-0.06910204441764602f,0.36048501698894553f,0.9302018383038068f},
{0.041609350483596555f,0.47653707845872567f,0.8781691607010325f},
{-0.03621184748060034f,0.18481255916275277f,0.9821064199351086f},
{0.33933803422352776f,0.3568080562543576f,0.870366422560808f},
{0.58166980304873f,0.02818218354254034f,0.8129366548212882f},
{0.05694746996722399f,-0.23061659316862881f,0.9713768437736341f},
{-0.2025745907654043f,-0.32713088839087595f,0.9230107892309956f},
{-0.05302922265542397f,-0.07554052881252524f,0.9957316556438716f},
{0.10068715350774705f,0.37923946386216645f,0.919804069445251f},
{0.13281464097499332f,0.5132034139080748f,0.8479283738003942f},
{0.1400182582646835f,0.5267717894874006f,0.8383951151770661f},
{-0.004967552324149528f,0.5495853190555585f,0.8354228273769558f},
{-0.1136569672710506f,0.46119599321054333f,0.8799888349503576f},
{-0.047915268839999206f,0.41268917768689767f,0.909610779197401f},
{0.1205175052359575f,0.4176119368105628f,0.9005974689976824f},
{0.8335149931002764f,0.35113047278166326f,0.4265678695836944f},
{0.8229793847890493f,0.33693612443389503f,0.45736088624160315f},
{0.7559433996245847f,0.10018289399555116f,0.6469257796028084f},
{0.9112930668986108f,-0.06722242286328095f,0.4062340361010071f},
{-0.16315057562594576f,-0.6249350469964724f,0.7634383254123673f},
{-0.3910322131611696f,-0.7866728890689659f,0.47774425572074014f},
{-0.15999831648961324f,-0.5749224459916739f,0.8024118143543504f},
{0.0017529785215487754f,-0.13158848502702136f,0.991302878879405f},
{0.11105726930269733f,0.18120686867341768f,0.9771542118215543f},
{0.15561020081640667f,0.5184822190326873f,0.8408101176536937f},
{0.12046137887693062f,0.4868191803424897f,0.8651567151965793f},
{0.20804233079112475f,0.4921658213370488f,0.8452758087787821f},
{0.13083957463037282f,0.5582176955534939f,0.8193131331069273f},
{-0.07443418563884524f,0.5969814882830442f,0.7987945008922154f},
{-0.19915173164652836f,0.5753152343919279f,0.793316436775862f},
{-0.041161592741077946f,0.4731322011457665f,0.8800293424210239f},
{0.2636182335939453f,0.4022772627403258f,0.8767430814092341f},
{-0.6051219580765796f,0.7816879160837169f,0.15096826720295242f},
{-0.6087785440422139f,0.767560267476597f,0.20059890354909035f},
{-0.789641323873742f,0.5483290899913631f,0.27532124636534666f},
{-0.6852326625034403f,0.7156169312215362f,0.13545702634975185f},
{-0.5872016294445047f,0.6767134917360212f,0.4441318458297722f},
{-0.42011742971584803f,0.5525441634124739f,0.7198585227166228f},
{-0.3733208501697957f,0.7848613356978195f,0.4945950126670667f},
{-0.4227013787219968f,0.9043660077054064f,0.05869981715054821f},
{-0.31883083225791353f,0.9442776564099649f,-0.08177168218051113f},
{-0.378345367270034f,0.9254736323725304f,0.018797309607960104f},
{-0.6096786089156897f,0.7224363842308748f,0.3261558899821512f},
{-0.5341225943263189f,0.84463652836486f,-0.03608585847502482f},
{-0.4389807042306643f,0.8609607259657084f,-0.25698748930200976f},
{-0.7476153212227528f,0.6319397824129765f,-0.20426317063249566f},
{-0.6100390383112272f,0.7923700185794974f,0.001457872641932746f},
{0.04940190308967636f,0.9069424446369041f,0.4183477669202435f},
{0.30695599572094356f,0.6160184523916563f,0.7254648737216384f},
{-0.37362457030316504f,0.5336020596622296f,0.7587315219430399f},
{-0.33024512232285097f,0.4255080431436439f,0.8425443990686974f},
{-0.19686524892347915f,0.5748845875405061f,0.7941988320154337f},
{-0.3060427126414114f,0.8952912336740472f,0.32371509842064705f},
{-0.24810739060825054f,0.966846591533038f,-0.060418467098328946f},
{-0.07028962965201944f,0.9754520172071671f,-0.20869290857585562f},
{-0.15652268533666588f,0.9526375186934258f,0.26073436089750773f},
{-0.1129121502421911f,0.9597202077451358f,0.2572702259751767f},
{-0.13112034461045932f,0.9904809642761847f,0.04189170127547836f},
{-0.42538793634092786f,0.7884822507413916f,0.44423062015286163f},
{-0.317102050969493f,0.9317577924048975f,0.17684373204525242f},
{-0.07089800501775301f,0.9908439030058673f,-0.1148992287206584f},
{-0.33778892319913006f,0.9388739022021761f,0.06644124568090996f},
{-0.5704530002461167f,0.8195778896804911f,-0.053623290248519515f},
{-0.7002902782047091f,0.6771721829545927f,-0.22590121930720652f},
{-0.6825712455879078f,0.6922442747098868f,-0.23429545200015092f},
{0.10934311095337318f,0.9281182692346095f,0.3558659331826965f},
{0.5448029004865185f,0.6961626531504883f,0.46749049186047564f},
{-0.9950370114590228f,0.08532192681899374f,0.05120072880917837f},
{-0.9683030145294547f,0.23324042726855698f,-0.0893765916823415f},
{-0.9855898594787406f,0.08324191365952895f,-0.14725288690880073f},
{-0.9941860066254988f,0.027843954009429576f,-0.10401393394716005f},
{-0.9627925801478865f,0.02564644224482011f,-0.26902176048111553f},
{-0.9468700750839055f,0.04382491595957786f,-0.3186164428458377f},
{-0.9235212569086617f,0.3180712127358022f,-0.2143342988572332f},
{-0.8941988683288568f,0.4074044914387418f,-0.18555313049079009f},
{-0.9704944520354946f,0.24088798019184263f,0.010653617574322337f},
{-0.9803417430948472f,0.13581600785147804f,0.14312260044117403f},
{-0.9725749818592567f,0.07155319450696969f,0.22130983940465587f},
{-0.9953189486289722f,0.04648923326772468f,0.08472863559798702f},
{-0.9087962236676808f,0.009446515039975158f,-0.41713329668220267f},
{-0.8990816124251333f,0.046490631764394254f,-0.43530549658506507f},
{-0.9066801513035263f,0.341738677503164f,-0.24727672662546113f},
{-0.8705999671700834f,0.4800486816208044f,-0.10774488589987623f},
{-0.8807958239318826f,0.4256385044787384f,-0.20743813547479395f},
{-0.9525827590845437f,0.169025416245514f,-0.2530148133171435f},
{-0.9877690395102382f,0.13907930786294007f,-0.07049305433436023f},
{0.039664703950216956f,-0.6433477885473478f,0.7645458352720124f},
{0.31241755918137665f,-0.29483082523219567f,0.9030338051302695f},
{0.7753787430439455f,0.046764651593546945f,0.629762552234511f},
{0.45817031703010747f,0.44933302835962513f,0.7669288038779735f},
{-0.006085615209411391f,0.1895633079412073f,0.9818496410193925f},
{0.03838102632147649f,0.09762259073738322f,0.9944831454560864f},
{-0.059390722858198366f,0.08114495982283618f,0.9949312727689944f},
{-0.22019942472475187f,-0.8386634006844491f,0.4981525004486912f},
{-0.20346765193606844f,-0.47259367959422577f,0.8574707742093681f},
{0.10366702363589494f,0.4673989032391381f,0.8779472725974639f},
{-0.273837628375567f,0.06642910066554417f,0.9594790919402111f},
{-0.38804332328876245f,-0.42020783846608395f,0.8202729739194594f},
{-0.32685146554908046f,-0.38624548818921156f,0.8625442262990902f},
{-0.5083273093870856f,-0.6309063059919183f,0.5861404094506011f},
{-0.3711504847676342f,-0.9010167763334561f,0.22453526765837262f},
{0.8353444667435822f,-0.5168171490660696f,0.1873490227145591f},
{0.9779508751321973f,0.16821063391128524f,0.12376295272549476f},
{0.6607250086046415f,0.20700927285499887f,0.7215189699214022f},
{0.4929257198562756f,0.10897144249718022f,0.8632204002595492f},
{0.7018640980030899f,-0.023853475653481115f,-0.7119113706308939f},
{0.5945832358590077f,-0.03403648689063219f,-0.8033133219333384f},
{0.26696507616656007f,-0.16636732450807187f,-0.9492373578001493f},
{0.21019835946139626f,-0.1689680252920575f,-0.9629467566322866f},
{0.344424235056227f,-0.08756174490863894f,-0.9347218233969332f},
{0.3646762243061356f,-0.08277652225911712f,-0.9274477337233117f},
{0.579342678784711f,-0.10006694252499364f,-0.8089182081967586f},
{0.6040925745353171f,-0.15750822664798092f,-0.7811935227134827f},
{0.6128493800991514f,-0.22989861366872225f,-0.7560173706637208f},
{0.37927241581229504f,-0.43622187744628715f,-0.8160042329799166f},
{0.30365954033963083f,-0.645147034833501f,-0.7011249439338653f},
{0.4162078079909967f,-0.658929810794557f,-0.6265640948965868f},
{0.5837562979767111f,-0.6875038003022825f,-0.4319341490811353f},
{0.9380508840554345f,-0.004136776807147872f,-0.34647283587673305f},
{0.8829341141337521f,0.38566285082738405f,-0.26775271350733576f},
{0.445422182654271f,0.8943039407315072f,0.04265607567043841f},
{0.22007309635411115f,0.9207526289419902f,0.3221528031191531f},
{0.5131986239107148f,0.823979331067451f,0.24017750600292423f},
{0.5600938885013615f,0.8279392864829377f,-0.028484626758102916f},
{0.9405597313694111f,0.2159663020592512f,-0.2621181949067126f},
{0.9794878905877036f,-0.036920252388227964f,-0.1980918149637698f},
{0.9907267843419407f,-0.09462320123961435f,-0.09750327468677683f},
{0.9799753772877678f,-0.1989229512447396f,0.008827195351856961f},
{0.9529135813218907f,-0.14844464989922643f,-0.2644236987272214f},
{0.7546184683279687f,0.44054053046422653f,-0.4862869608334654f},
{0.9146313987984029f,-0.010017303694275927f,-0.40416464214324016f},
{0.8470142262943856f,0.313179176093577f,-0.4295179904454196f},
{0.9207983824233925f,-0.20906491094537286f,-0.32927526772879095f},
{0.7814367416700381f,-0.5074476583832567f,-0.3631163625746762f},
{0.8931155022438212f,-0.30799827729262347f,-0.32784411057169105f},
{0.8408184069899118f,-0.34344652005626214f,-0.41841234963632523f},
{0.7543417791775551f,-0.32263180032501165f,-0.5717317566886437f},
{0.7838768940294584f,-0.15635980024834478f,-0.6009065051012737f},
{0.7269936708601933f,-0.10839882176157467f,-0.6780338472155526f},
{0.7199912439985903f,-0.022185982154768927f,-0.6936284241300892f},
{0.6599391825244836f,0.016648684899993823f,-0.7511345396531949f},
{0.603002157002499f,-0.040049269819984315f,-0.796733615857408f},
{0.48445797991744977f,-0.6900895946997144f,-0.5376586435476394f},
{0.5332386078006015f,-0.16288569307325756f,-0.8301354336148535f},
{0.5064431503894563f,-0.12006406304146922f,-0.853873501280826f},
{0.5968180919257953f,-0.7997340504667603f,-0.0650662252945604f},
{0.7689592241451607f,-0.5907470799328056f,-0.24437593816277334f},
{0.7331337801877498f,-0.6701370844038743f,0.11589283176406914f},
{0.8112579839401823f,-0.5837367111736337f,0.03334569719619783f},
{0.8147003770719493f,-0.5538083684396881f,0.17192901629740817f},
{0.9059332477444129f,-0.3389502019206447f,-0.2537670412981449f},
{0.603297387400077f,-0.1466123964986781f,-0.7839241465531954f},
{0.22899727686027643f,-0.9485371112706114f,-0.21871807363128873f},
{0.10622668387618768f,-0.9942954302025607f,-0.00961712592061707f},
{0.043682449533885045f,-0.998522359586523f,-0.03232554730367341f},
{0.38176527596680604f,-0.12447197777817799f,-0.9158395060347512f},
{0.36249577414280737f,0.18646127106944432f,-0.9131423810774385f},
{0.8573781528608057f,-0.3738889154372702f,-0.35370861158605527f},
{0.8372141046549308f,-0.5260175999988629f,0.14959287235118843f},
{0.9736267380741281f,-0.16448211457063136f,-0.158103159024438f},
{0.2893339696463412f,0.5933477471983972f,-0.7511486569935921f},
{0.08295240969195312f,0.7902220942213463f,-0.6071803187939545f},
{0.377022070195291f,-0.17172296207933696f,-0.9101459129614083f},
{0.023814024730466815f,-0.9976507422710301f,-0.06423308082444316f},
{0.00040622472124213774f,-0.9999985587028223f,0.0016485065222929633f},
{0.08474363213058914f,-0.9963572128351103f,-0.00953001808844624f},
{0.13679734209135266f,-0.9844990088124319f,-0.10976424210133634f},
{0.3050370997024042f,-0.5181899297717731f,-0.7990191264846358f},
{0.25415810089192425f,0.02929814934956454f,-0.9667188206483316f},
{0.13085572673421378f,0.36160288203987373f,-0.9231035339989323f},
{0.25477946221538667f,0.3197321937106834f,-0.912610952124832f},
{0.5719700081188093f,0.04006221080161918f,-0.8192956298420344f},
{0.8642385062291673f,-0.3613201987779558f,-0.350056450170306f},
{0.13380833089895264f,0.8024758801265005f,-0.5814875685663751f},
{-0.04663012526091502f,0.8093019124029985f,-0.5855391071474223f},
{-0.1105708697087182f,0.8242867832491254f,-0.5552705482309207f},
{0.0050875922812632255f,0.8480670881832225f,-0.5298644452548311f},
{0.15342570004994532f,0.7945341209785005f,-0.5875168807490605f},
{0.13402804950482541f,0.814067384713014f,-0.5650935985236833f},
{0.22061847108261048f,0.5873716080965027f,-0.7786668634398795f},
{0.3869093704272104f,-0.034658414409838294f,-0.9214661867839837f},
{0.02261600637477284f,-0.9977702662335297f,-0.06279340790184557f},
{0.002612132070487412f,-0.9996123376352265f,-0.02771914885930389f},
{0.004410994136037138f,-0.9995887650103408f,-0.028334501863162758f},
{0.0009313246841831876f,-0.9999995652714369f,4.573040258899421e-05f},
{3.700921490303746e-05f,-0.9999985886581393f,0.0016796761734860538f},
{0.007892516055688723f,-0.9999306048332175f,0.00874606815582832f},
{0.011981164686746067f,-0.9999240353054825f,0.002894012983594172f},
{0.06590667929902218f,-0.9977314534655305f,0.013720655572380159f},
{0.14507714333763597f,-0.9887559617633696f,0.036252869657247194f},
{0.7590813070731203f,-0.6338126638697245f,-0.1485835669598989f},
{0.9919904442035822f,-0.024940399889778267f,-0.12382622929782537f},
{0.9019079073505823f,-0.43190460715228174f,-0.004531774390508572f},
{0.6845695795332273f,-0.7255721283159112f,-0.07006837652478544f},
{0.5386885573234386f,-0.7945830039560453f,-0.28009371294796953f},
{0.4620495555001432f,-0.6063614853347447f,-0.6471753683235808f},
{0.7333442063226975f,-0.43328006829167054f,-0.5239032901920908f},
{0.3450537349822832f,0.1826118022828197f,-0.9206469734060916f},
{0.22132058869101273f,0.4946339938992109f,-0.8404489330713548f},
{0.16933644848910445f,0.463069018160094f,-0.869995546904318f},
{0.9278755670136007f,0.2910149945347008f,0.2331463169238518f},
{0.6161943242981781f,0.7184417073704072f,-0.32271669899992156f},
{0.2453983945172177f,0.8134140615997453f,-0.5273871370825971f},
{-0.07489484246386538f,0.8463025824409448f,-0.5274113210067645f},
{-0.1494445518971611f,0.8316345305518924f,-0.5348367353707019f},
{-0.0859268034912434f,0.8117295352783708f,-0.5776778912149377f},
{0.25802009626117217f,0.753576902602786f,-0.6046052280529559f},
{0.3037565155708655f,0.7427956787461621f,-0.5966460918201631f},
{0.2033310984260526f,0.7719588850645381f,-0.6022756380452143f},
{0.16598882454001612f,0.6653106389890537f,-0.7278801163487024f},
{0.09137287945584932f,0.7676666143919741f,-0.6343019517926072f},
{0.1926814463204542f,0.9309606010953303f,-0.3101390324549285f},
{0.31238314731730016f,0.9079259317530396f,-0.27944099864284927f},
{-0.3764173014736669f,-0.7083963104256816f,0.5970633823360496f},
{0.10375139589871712f,0.33432236079963756f,0.9367305946313617f},
{-0.5353121169457905f,-0.25633052875647894f,0.804820226807478f},
{-0.6385730498581519f,-0.5535362507665047f,0.5346233057791434f},
{-0.04885775285023839f,0.6198958629330121f,0.7831615664120407f},
{0.1962272308830211f,0.6593088679159111f,0.725814501472257f},
{-0.033387613756302476f,0.4722892725894309f,0.8808110525218257f},
{-0.5339207865927917f,-0.4531155758069522f,0.7138731460177422f},
{-0.55828035702489f,-0.47749649030483454f,0.678468971071431f},
{-0.9196274625202477f,0.00930198387542355f,0.3926815545382183f},
{-0.9635988618973368f,0.06120267939522784f,0.26025269525021644f},
{-0.8570977379211517f,0.05128773690636944f,-0.5125944163697725f},
{-0.6308400023027978f,0.05994620570535732f,-0.7735937848225883f},
{-0.5177882585467086f,0.04065456882354531f,-0.8545422899686932f},
{-0.6265660797718263f,0.053253602875664226f,-0.7775467840973469f},
{-0.8538909060902272f,0.07050495025919719f,0.5156543149100559f},
{-0.9256956501723533f,0.13268290007671177f,0.3542355307972612f},
{-0.9375394435113384f,0.11507152417697482f,-0.3282961105222506f},
{-0.6684939079439232f,0.10101546285097568f,-0.7368254686877106f},
{-0.8155783987822712f,0.06739116529230396f,-0.574708888290665f},
{-0.9842031193679317f,0.042510179668859345f,0.1718636216625089f},
{-0.9196376173586474f,0.0032772037123466905f,0.3927542649987876f},
{-0.9361746478437262f,0.04645254504414334f,-0.34845256462479535f},
{-0.8941446874277099f,0.0503336774572001f,-0.44494021942103357f},
{-0.7143736089030966f,0.037779284873182405f,-0.6987439248660675f},
{-0.5772032374062404f,0.03726919291920638f,-0.8157496123118332f},
{-0.7393759590526137f,0.05216144490084948f,-0.6712692267942004f},
{-0.6052624204993774f,0.043007447358057074f,-0.7948633604607643f},
{-0.5568953052381379f,0.03278145235461757f,-0.8299355368853915f},
{-0.7998949972684971f,0.09645052598036084f,-0.592338829879439f},
{-0.9091073180453892f,0.12261473193833254f,0.3981074123751157f},
{-0.6552664896568663f,0.08350131333879511f,0.7507685117287913f},
{-0.969875469860356f,0.23772950892739442f,0.05316252014618567f},
{-0.7355753917935074f,0.23811044051199165f,-0.6342178341130226f},
{-0.5046366170451911f,0.17791379914285455f,-0.8448009024685882f},
{-0.3990750792048466f,0.07660397755503597f,-0.9137127074635621f},
{-0.45676082336084184f,0.05471294268612123f,-0.8879054252257677f},
{-0.5585338185095203f,0.05573409934217203f,-0.8276072037818974f},
{-0.930403504888978f,0.05806065365488171f,-0.3619092131840157f},
{-0.9930325265895613f,0.05831650376516708f,0.1023991529445408f},
{-0.6274146524761417f,0.7141657140612944f,-0.3103517145394302f},
{-0.537686861752429f,0.7613893665189057f,-0.3621865144518275f},
{-0.7101983507154748f,0.6387859692279754f,-0.2959236187912275f},
{-0.8124340149636715f,0.5275768005868472f,-0.24822105231538083f},
{-0.8275292808832613f,0.4516733667269556f,-0.33344633611777685f},
{-0.8580807468743521f,0.49513818088024925f,-0.13614556062594135f},
{-0.7075376560082993f,0.6971469031515655f,0.11565751491564659f},
{-0.521168457353983f,0.838588554036368f,-0.15859595233946866f},
{-0.5109736572181768f,0.7868768817751894f,-0.34602123425714126f},
{-0.5660100929437946f,0.7424018725386382f,-0.3584299573652856f},
{-0.52358566984018f,0.7680644104316074f,-0.3686937859068924f},
{-0.5463462920455203f,0.7872474017072633f,-0.285914773443545f},
{-0.5827446851773906f,0.7847864898266704f,-0.21099478022699328f},
{-0.6997339842520073f,0.7053694788870591f,-0.11325303323712949f},
{-0.8516723573482482f,0.5186662088214025f,-0.07509700097680864f},
{-0.9374110663321499f,0.34812476372673645f,-0.008345154176269621f},
{-0.9045531938231502f,0.3713772985146855f,-0.2094335734601127f},
{-0.905830135966885f,0.3314849720948213f,-0.2637981767365161f},
{-0.9209577384382646f,0.33630385936529145f,-0.19681605164896374f},
{-0.8621520577831665f,0.4176708296011245f,0.2867837292465524f},
{-0.38819835777646433f,0.6298532418197546f,0.6727458129106432f},
{-0.4563768725280125f,0.8153141970243404f,0.3563466154632386f},
{-0.23925661495155437f,0.915255737701354f,0.3241345504673549f},
{-0.5182538278583924f,0.854937956575658f,-0.022227467610190593f},
{-0.9195277016948444f,0.28723867404429393f,0.2682587369482549f},
{-0.735057725005158f,-0.32194833186502525f,0.5966903824594202f},
{-0.9743099057942732f,0.04022776856682189f,0.2215895622706282f},
{-0.7970484047134185f,0.5596928499377132f,-0.22684301680323962f},
{-0.11892529007266323f,0.38296873170661727f,0.9160740832029678f},
{0.5008409028961879f,0.3991001123202677f,0.7680348236454393f},
{-0.2586658150799723f,0.529890239623927f,0.8076560716420763f},
{-0.3289056059920917f,-0.21805237237212843f,0.9188439830841042f},
{-0.46361631256031643f,-0.16082325365206132f,0.871318423891484f},
{-0.022841601961192507f,-0.1782389864719055f,0.9837220770732525f},
{0.8363629684179965f,-0.16471374351122434f,0.5228444967268528f},
{0.07857061102746546f,-0.12383584571359002f,0.9891872130184309f},
{-0.4399779409230877f,-0.1304320845713995f,0.8884857245985661f},
{-0.402397255408712f,-0.14895657418692287f,0.9032654027726467f},
{-0.42744471980757565f,-0.17020172412922f,0.8878752077922122f},
{-0.4655223025378765f,-0.18044323929858927f,0.8664463187245163f},
{-0.5672875871609847f,-0.1933066534331311f,0.8005106690054491f},
{-0.09405106073171784f,-0.327903050209162f,0.9400180783574147f},
{0.5952449938284636f,-0.24567298731557402f,0.7650674353451427f},
{0.6648358437786109f,-0.3131065693817243f,0.678201722968314f},
{0.7823221003137945f,-0.24039112039907773f,0.5746166031310698f},
{0.8608490493625724f,-0.1394753256838091f,0.4893726062387949f},
{0.9260193969227855f,-0.0693274734019238f,0.3710549527421324f},
{0.8409701949320542f,-0.040652071146600306f,0.5395521664745999f},
{0.0845610561157874f,-0.06483253951247026f,0.9943068789910621f},
{-0.38813799542136723f,-0.07381446404890166f,0.9186404745097267f},
{-0.48001035096280975f,-0.10892195201690816f,0.8704746241777451f},
{-0.18740344348434104f,-0.15180203340603404f,0.9704824017075244f},
{0.16896633778886153f,-0.18268699694166765f,0.9685431522873184f},
{-0.4532257752740932f,-0.20314090084630507f,0.8679401886250855f},
{-0.665967866129016f,-0.2147294172596031f,0.7144075018131574f},
{-0.31920395661736045f,-0.3560208514154857f,0.8782698830298208f},
{0.38576380955397427f,-0.33189365715971725f,0.8608326687432075f},
{0.4904956627754306f,-0.3397988873525988f,0.8024654017167513f},
{0.509616427263479f,-0.3505372048113844f,0.7857574467392776f},
{0.5942516194189027f,-0.37549073181842446f,0.7112465979788415f},
{0.7062128780330919f,-0.25203475266386743f,0.6616206272100957f},
{0.6577410859835869f,-0.27854878171431346f,0.6998480120816257f},
{0.7211960732631243f,-0.1658841135281906f,0.6725761553822858f},
{0.7377371645327524f,-0.0928003294585047f,0.6686792765740297f},
{0.885184711625318f,-0.03682464040628167f,0.4637800903054706f},
{0.8056694223429403f,-0.0561628813566025f,0.5896969668052543f},
{0.8520382620691691f,0.0005190668805588302f,0.5234792551187901f},
{0.8028246000632823f,0.04065226796646484f,0.5948277520782077f},
{0.04008300081224045f,-0.009980067511683913f,0.9991465114278026f},
{-0.4109627438582037f,-0.06708849445972984f,0.9091802665432543f},
{-0.4615263814947569f,-0.06616316374677252f,0.8846557720081714f},
{-0.40650181828330295f,-0.10727748154420354f,0.9073300467227465f},
{-0.1059932709416761f,-0.10081736435593057f,0.9892427839309256f},
{0.7791977686721011f,-0.0993322476691138f,0.6188569639823251f},
{0.9055452382243753f,-0.08104187999547731f,0.41643731246846527f},
{0.9171646702080787f,-0.019989342547241183f,0.39800677620693276f},
{-0.23113461873206287f,-0.20820117837573826f,0.9503836369311804f},
{-0.5023289853728494f,-0.21328684646666501f,0.8379584187646717f},
{-0.7169591939291198f,-0.2451519312964438f,0.65258719327162f},
{-0.81250314412922f,-0.285271674379028f,0.5083883481917318f},
{0.016861065413642958f,-0.3584588219379978f,0.9333932598042155f},
{0.4965970157696005f,-0.2150483001422917f,0.8409195160861935f},
{0.5963035089346372f,-0.20351911446960144f,0.7765320954588729f},
{0.5290811432745129f,-0.31747364715658716f,0.7869457587359051f},
{0.1723173850862572f,0.47088703437542506f,0.8652006239330574f},
{0.2465931186551088f,0.635327288387922f,0.7318135489737791f},
{0.19421580518298454f,0.30089389219496687f,0.933671830279188f},
{0.061439315633611304f,0.2616252212991891f,0.9632120504201677f},
{-0.019324213831514458f,0.21950575237674855f,0.975419806766969f},
{0.03514673943475851f,0.39255640603553565f,0.9190561325553347f},
{0.020411195613175084f,0.5180521682007309f,0.8551054520444612f},
{0.06146060195302015f,0.43645918591627664f,0.8976224002535105f},
{-0.03977027718480612f,0.10218021292149296f,0.9939705876634187f},
{-0.08850985390992368f,0.17974192255996274f,0.979723862644619f},
{0.8578353133552721f,-0.020397289504418298f,-0.513519742309422f},
{0.9058852522985218f,-0.09409996218547054f,-0.4129371705050739f},
{0.8713077612674167f,-0.1747198504537117f,-0.4585801554936661f},
{0.8356601888848627f,-0.31684350770384195f,-0.448644893360931f},
{0.9165611769708583f,-0.2754766014456991f,-0.2898762683037757f},
{0.9581101386095134f,-0.18032696507411305f,-0.22250201788032908f},
{0.9023972612919228f,0.00866570529045225f,-0.4308179294837396f},
{0.8308087277816418f,0.01591046929118121f,-0.5563305805083738f},
{0.8062691397009631f,0.04977843040630871f,-0.5894507462308901f},
{0.7733615653819216f,0.07652014622133549f,-0.6293302443171545f},
{0.6717171480064555f,0.01146635985970678f,-0.7407189721248141f},
{0.48940988669902663f,-0.8016660377318942f,-0.3432339242389822f},
{0.3403526535739833f,-0.9097105961182409f,-0.23787959667727485f},
{0.3657138069894449f,-0.7948480428101957f,-0.4842210241388621f},
{0.44089610743183894f,-0.16781738093137122f,-0.8817300885808464f},
{0.9375842672128152f,0.3017524951381748f,-0.1728617180086277f},
{0.8804184974701271f,0.4287062286591179f,-0.2026678041064245f},
{0.9241187468758975f,0.3063693784232183f,-0.22834698517189098f},
{0.9062629585641196f,0.3270425855176964f,-0.2678256843405964f},
{0.8954361056025348f,0.35547347727903267f,-0.2680163945256321f},
{0.8491420746263585f,0.4807192800809368f,0.21878462207776342f},
{0.9286471564185036f,0.36855765845224003f,0.04218662432607691f},
{0.8646942938997386f,0.43425123586767117f,-0.25244730587715236f},
{0.8815789270688997f,0.39185162420480596f,-0.2631936548553232f},
{0.8531309689264333f,0.48612890842295126f,-0.18933101767580218f},
{0.8878246494585481f,0.4594896544821775f,0.025231909116343945f},
{0.9431424391420355f,0.32138560939603883f,-0.08481526727157351f},
{0.898194452623306f,0.4104899876989265f,-0.1573044668013432f},
{0.8359139674007474f,0.47306961189085367f,-0.278303757448187f},
{0.8025264809992082f,0.4142110655569812f,-0.42939543600878843f},
{0.809570867837036f,0.3250636525400003f,-0.4888032648693565f},
{0.48756696263687127f,0.8591839778133594f,-0.1551816651987874f},
{0.523946976871044f,0.811106464152004f,0.25997282403845134f},
{0.7274029083825978f,0.5145402172820402f,0.45401913360109497f},
{0.9569162586442121f,0.1807872640327569f,0.22721628266018573f},
{0.8553643551225955f,0.014154086078969301f,0.5178334498977211f},
{0.8631745537645698f,0.3189353729301428f,-0.39142038478756663f},
{0.7095108881354207f,0.40900328623292587f,-0.5738559152504693f},
{0.86580181511983f,0.48777222282392513f,-0.11164889420238215f},
{0.9267182307688426f,0.3365729507321103f,-0.16706875709164418f},
{0.9660502893655101f,0.1487524817379377f,-0.2112333723482603f},
{0.9276082660134556f,0.299037714473861f,-0.2238735137209402f},
{0.9581153139770725f,0.2747286041923806f,-0.08086556226925092f},
{0.8994364537010703f,0.43216308214833077f,0.0651853985314021f},
{0.7713660621349103f,0.6363107119405763f,0.010152637891633913f},
{0.6859441130863725f,0.6904729500698681f,0.22962530118426258f},
{0.8948434839670476f,0.3976878067047326f,0.2027302335619818f},
{0.88291273179774f,0.42560858317974504f,0.19829887027711993f},
{0.8991609962940869f,0.4089676571434969f,0.15574003388334168f},
{0.9167236535116194f,0.3995188737886426f,0.0015532478755338512f},
{0.7822678387961182f,0.6223063798633252f,-0.02813890485881094f},
{0.7576941306919022f,0.6162366990969388f,-0.21483001419995232f},
{0.7467011394662739f,0.5744809590392376f,-0.33527456810967016f},
{0.6567904231277807f,0.6012237729492769f,-0.4551442792436998f},
{0.6270115803059486f,0.5609312079044493f,-0.5405669784227413f},
{0.6903423551741537f,0.4048905973241877f,-0.5995757140270652f},
{0.7116770806262932f,0.28022817952515294f,-0.6441955450880232f},
{0.6870317338709447f,0.24961290748832732f,-0.6824080839713925f},
{0.13557957523892503f,0.2804315528268412f,-0.9502506632237407f},
{0.03465673892197437f,0.6560984718646308f,-0.7538791054699622f},
{0.525274210585168f,0.7176268735135237f,-0.45727308482495843f},
{-0.05103094304052215f,0.9547091074877135f,-0.293131988927187f},
{0.3415072778861661f,0.9398502701063783f,-0.007365387413340236f},
{0.9188165650348522f,0.39449858581474284f,0.012123762110955222f},
{0.6405245880297686f,-0.32079688921199717f,-0.6977231600005842f},
{0.7952186394410714f,-0.10660712301857761f,-0.5968770700966769f},
{0.9676428437050326f,0.09844843178644355f,-0.23232570521840212f},
{0.8213726714710002f,0.26935812104461454f,-0.502785378852555f},
{0.33010967809890795f,0.14164913481684477f,-0.9332540506373785f},
{0.46528825113632866f,0.5469979890518388f,-0.6959166928072218f},
{0.5884405027949897f,0.8022972695650002f,0.10028392652327237f},
{0.6985610065151074f,0.6519706647603585f,0.2948673811538613f},
{0.9771238821410657f,0.18755261091515657f,-0.10026433607460136f},
{0.9902674558523903f,0.046678752365207986f,-0.13111620783588054f},
{0.9890474635184036f,0.05122688430268741f,0.1384229794234009f},
{0.9888495396327706f,-0.04365891629291528f,-0.14237446047724273f},
{0.9864914485509303f,-0.03636605254415049f,-0.15972517697045616f},
{0.9790130373252653f,0.11146127677346415f,-0.17061610863921303f},
{0.9973917426916366f,0.07136716464705839f,0.010790709929374429f},
{0.9317776362677848f,0.16214570421548696f,0.3248064148930611f},
{0.8747903988185726f,0.2130676536628438f,0.43513668323580024f},
{0.7510488166823672f,0.6442631688882261f,0.14439752135724815f},
{0.457769810340306f,0.8395172146835113f,0.29267327686524364f},
{0.4654457670950806f,0.7185250429306131f,0.5167997683579517f},
{0.7529741383284247f,0.4372985297459708f,0.4917315760560617f},
{0.7760860814771734f,0.21482415207061323f,0.592908911911896f},
{0.8267214954934287f,0.21590743892675912f,0.5195339706941178f},
{0.7025045773960351f,0.5908197706019517f,0.3967610331212927f},
{0.7761810833618688f,0.5980129958676776f,0.19980836470118268f},
{0.8538010990565217f,0.5115995926171146f,0.09638226021357822f},
{0.6440642373331879f,0.7609273648243896f,0.07855446295296818f},
{0.6121458999952761f,0.7839101419942689f,-0.10374144011675662f},
{0.5614945255300563f,0.7956199786449764f,-0.22740436974856976f},
{0.6259134805822667f,0.7062917888512099f,-0.33073285870434815f},
{0.5050613547385372f,0.7266341765285549f,-0.46574220492708446f},
{0.48651489764727623f,0.651846657703514f,-0.5817208859994784f},
{0.47209984159762136f,0.5387529612846558f,-0.6977585443909055f},
{0.5674931878919998f,0.3329316186715251f,-0.7530657467877114f},
{0.6136177925093669f,0.17321012810004285f,-0.7703709861096136f},
{0.5836831020860693f,0.18478212986761902f,-0.7906766727435239f},
{0.6031956829182957f,0.20329937712446658f,-0.7712485535607408f},
{0.5305458214994078f,0.29837417282303424f,-0.7934065693461888f},
{0.3777409533355819f,0.08443159318699306f,-0.9220537285023209f},
{-0.34661513589356185f,-0.06856329620994192f,-0.9354982747083584f},
{-0.21513560599092377f,0.4601023358931717f,-0.8614072855163026f},
{-0.08031269622551937f,0.7441794296152325f,-0.6631341096358523f},
{0.9301017906977446f,0.34183906437998024f,0.13437526931942737f},
{0.9576131002531147f,0.20656654748509354f,0.2007670582633183f},
{0.9442282792604152f,0.11552860463724413f,0.30836033816865405f},
{0.9005968373990291f,0.4346390132945805f,-0.003776849107453009f},
{0.9536460828534782f,0.2921979004492634f,0.07196899076171352f},
{0.9017376413250835f,-0.05487112610092003f,0.4287871100416757f},
{0.9323326914636033f,0.04511611858408497f,0.35877609768787583f},
{0.9811456568629929f,0.11612245917640307f,0.15449522482494688f},
{0.9725018931200617f,0.19037971571230833f,0.1341477980557138f},
{0.9593290066775162f,0.26376549832894575f,0.10057643281809589f},
{0.9126528023845694f,0.4032488899772513f,-0.06674724737175956f},
{0.6082903246467456f,0.6510281919344328f,-0.4540321290919181f},
{0.7888442304030572f,0.46828336618378946f,-0.39803953210125687f},
{0.4164075562919701f,0.5261931907653673f,-0.7414347395793588f},
{0.9307902441412871f,0.3634604663702052f,-0.039064188169680734f},
{0.9138237034007233f,0.04142809140370555f,0.4039925152099147f},
{0.8496730493715209f,-0.14102776231698225f,0.5081012491891415f},
{0.8864653948903553f,-0.1335514550174492f,0.443106209079278f},
{0.9056480111149928f,-0.08057469746326693f,0.41630445360596463f},
{0.9871953315503194f,0.02694611394987307f,0.15722367604230394f},
{0.993032330241101f,0.11350149560385382f,-0.031689139963358044f},
{0.9826632964118452f,0.1842109180226073f,-0.020956706952057022f},
{0.9669221491760092f,0.2541991430190207f,-0.021079685036618397f},
{0.8093234030469033f,0.5560177811084683f,-0.18931417372134404f},
{0.9402279094090066f,0.2329432568103869f,0.24841279652010487f},
{0.9060101808209463f,-0.07476746056428486f,0.41659978287268f},
{0.8475813663211551f,-0.2859568588171965f,0.4470285252202212f},
{0.9443584351166531f,0.32700057628247137f,-0.0354650410257485f},
{0.9741817717032464f,-0.032447013911030255f,0.22342127689497532f},
{0.999644655762955f,0.02428778729647993f,-0.010984789156120476f},
{0.724096436509355f,0.3375331817403305f,-0.6014613053710958f},
{0.32288129039913777f,0.35234973950288484f,-0.8784061323684147f},
{-0.23688356948904354f,0.6560286364300957f,-0.7165979365654068f},
{0.9098767972948918f,0.0882121025539373f,0.4053922035602117f},
{0.7910387178639979f,-0.059734048338666294f,0.6088428289050929f},
{0.7735116099119254f,-0.1681192120266171f,0.6110775072599308f},
{0.8716265189594099f,-0.16546442357088845f,0.46139867357747677f},
{0.9704655098455144f,-0.05356733914783493f,0.235217419373878f},
{0.9977930158211905f,0.059356587625207444f,-0.029763956120525945f},
{0.9401990894437136f,0.20014820268187053f,-0.27561997237578556f},
{0.897122064275058f,0.35641585445214263f,-0.2610358988453652f},
{0.8742072400589167f,0.4674037397063555f,-0.13151214976984046f},
{0.14136198027701805f,0.7563987832141381f,-0.6386530132116588f},
{0.3883164995302249f,0.8393437630143867f,-0.3804107565269966f},
{0.9029810737222331f,0.3766793005447012f,0.20673143215437176f},
{0.8850768338693988f,-0.06288381872614741f,0.46117743167910696f},
{0.9092999925794483f,0.1910561286750205f,0.36969051812391596f},
{0.8536898044825559f,0.14159635246579125f,0.5011628384975475f},
{0.6047868162958209f,-0.40603037564855177f,0.6851074666688876f},
{0.5807606034523253f,-0.5458528777779486f,0.6039550954327838f},
{0.39404798500217475f,0.08759263011557684f,0.9149063977616297f},
{-0.05978382944341017f,-0.0029137896318177825f,0.9982070945285165f},
{-0.37857836688425495f,-0.062256475829733426f,0.9234730918356593f},
{0.0527217152342739f,-0.7197171066823532f,0.6922627442608322f},
{0.31250437355369837f,-0.06961237961605966f,0.947362197427151f},
{-0.19334728915066138f,-0.3682857912893953f,0.9093857276823926f},
{-0.5880855856591619f,-0.41862837266723213f,0.6920300784921891f},
{-0.3392302324204976f,-0.6668646236847804f,0.6634865658697932f},
{0.28389550746268616f,0.0302656233614486f,0.958377448026114f},
{0.058156664927913965f,-0.019615637293601815f,0.998114737441557f},
{0.12729489225197266f,-0.1311491447096035f,0.9831560976002225f},
{0.9871264737297588f,0.050221085607208144f,0.15185245280299264f},
{0.9096015727608019f,0.07130657768575288f,0.4093169319852544f},
{0.6492531303186796f,0.024983422111991355f,0.7601619573426243f},
{0.3785868707290165f,-0.20327243830545333f,0.902968602520025f},
{-0.5253003899705161f,0.0721711251658872f,0.8478507114988544f},
{0.9683498384255037f,-0.24137786039929265f,-0.06352416020980106f},
{0.6080300123767516f,-0.626667364992261f,-0.4874295002385307f},
{0.6713198878607485f,-0.5965550222181115f,0.43983146048114863f},
{0.19502513852623793f,-0.7828063873121627f,-0.5909139999408559f},
{0.6558503899844919f,-0.6768497874842598f,0.334267304921828f},
{0.5584202518641849f,0.043557956399939146f,0.8284138619930267f},
{0.9058249422353061f,-0.10669064225954629f,0.4099979035051884f},
{0.9428208885138495f,-0.24075263045054685f,0.2304928265979173f},
{0.8029183592862498f,0.5915461326297964f,0.07345257852389046f},
{0.8774172079067207f,0.41043491649627184f,0.24835905981033346f},
{0.7634540489535657f,0.4054832047816374f,-0.502713920412414f},
{0.5389373739926291f,0.4312157231256853f,-0.7236017599779048f},
{0.5488887958998587f,-0.10394216211596985f,0.8294076902647218f},
{0.47788600123103425f,-0.11411166240011308f,0.8709784717957697f},
{0.6675346524320607f,-0.05277362545566873f,0.7427061547198007f},
{0.3309338847392086f,0.027561026997687543f,0.9432513735596937f},
{0.26373502739371285f,-0.042811937835100636f,0.9636446301954061f},
{0.15014509440947793f,-0.12827940308937275f,0.9803065058275413f},
{0.47498730006417267f,-0.1698320219130356f,0.8634489846601696f},
{0.36799098138147684f,-0.18637723156289046f,0.9109589261744189f},
{-0.27094192857729227f,-0.1338534848927397f,0.9532437861957908f},
{-0.1919193746909829f,-0.04535725636979627f,0.9803620111534447f},
{-0.33306753894435637f,0.07436896378274811f,0.939965569437216f},
{-0.21634221960170144f,0.13351137622500414f,0.9671456748785647f},
{-0.05606221078915401f,0.137582210035395f,0.988902504801767f},
{0.19239664631234432f,0.03375230092804434f,0.980736617379929f},
{-0.10397746464779296f,-0.052427165861834275f,0.9931968984673244f},
{0.007229259943426504f,-0.16108671239641958f,0.986913779866298f},
{-0.2131146223502095f,-0.3826044461499543f,0.8989972166401932f},
{0.7334744726222678f,-0.6257268704904408f,-0.26548273306888587f},
{0.824793391073877f,-0.326833636296236f,-0.4614061510494136f},
{0.16009777335287678f,0.6085892401846917f,-0.7771665456637146f},
{0.5962119634191286f,0.4180861286599066f,-0.6853723686420979f},
{0.8973297443944959f,0.2349570104427848f,-0.37362351782067715f},
{0.06897341176101368f,0.7177151494420111f,-0.6929124278950965f},
{0.9606472753024156f,-0.22281493687038054f,0.1658623416013818f},
{0.7445772339909189f,-0.1108945945617904f,0.6582606865971934f},
{0.7205822748767402f,-0.01634141444013335f,0.693176848508054f},
{0.7415386486189229f,0.15970338279028526f,0.6516250932321139f},
{0.6649175865577371f,0.41642652740973923f,0.6200593119659601f},
{0.4787270788687862f,0.5208724440018613f,0.7067618276599882f},
{-0.04670984105166277f,0.3473344536131937f,0.9365772622064624f},
{-0.2928540260064978f,0.41219340667315285f,0.8627474224516504f},
{-0.47620223374502846f,0.5164307110157964f,0.7117097394977565f},
{-0.3532566368736198f,0.4718710394131713f,0.807804104141513f},
{-0.2995549699771691f,0.4983693939506111f,0.8135691532594373f},
{-0.7616319534102544f,0.6476094938241382f,0.0227752289411892f},
{-0.7575769316238407f,0.5308819743250329f,-0.37979141908179226f},
{-0.8330145058407826f,0.5498444055349643f,-0.061302224761736086f},
{-0.6452164788356556f,0.606819785709249f,0.4641825536474836f},
{-0.7882521234695373f,0.6145674869623973f,0.031070787155925955f},
{-0.6399744316037647f,0.15039767383057964f,-0.7535338523250226f},
{-0.19984164842764035f,0.050982603282310905f,-0.9785009400691866f},
{0.2662829664249477f,0.08364171223358817f,-0.9602590513848666f},
{0.11401599753711626f,0.13924951876634306f,-0.9836716544807818f},
{0.41750106019880906f,0.024151636452729042f,-0.9083554167777751f},
{0.3549768835007013f,0.0003876451598200594f,-0.9348749980138306f},
{0.2539606592025947f,0.08169315561021791f,-0.9637583783832065f},
{0.2077763615521767f,0.17981608503623445f,-0.9615067129991245f},
{-0.1330831674804135f,0.15751166615983656f,-0.97850853116206f},
{-0.8838200854580258f,-0.3949949189797004f,-0.2506812129402361f},
{-0.9747041821152567f,-0.1871910945758754f,0.12211163531176826f},
{-0.9908807472856166f,0.12250279300969993f,-0.05611069740718446f},
{-0.967248852786495f,0.18351630794905455f,-0.17536083228576857f},
{-0.14311156651291787f,0.1912617954042237f,-0.971049949873317f},
{0.08684008681151623f,0.09764139431686467f,-0.9914257195768258f},
{0.45614616800405144f,0.02211483379477568f,-0.8896300397027121f},
{0.4035921637895513f,-0.08413657465979223f,-0.9110622383416982f},
{0.2761511810915037f,-0.011903330037789718f,-0.9610404965014633f},
{0.16654662059498496f,0.17114782766558673f,-0.9710667558174055f},
{0.21462057081933222f,0.22296842380947868f,-0.9509064583675413f},
{0.17818784492462772f,0.3547117239040698f,-0.9178391388724496f},
{0.06820752535250492f,0.384626979003692f,-0.9205486518961291f},
{-0.6646618357429567f,-0.05013877802554322f,-0.7454600908465243f},
{-0.844226607234517f,-0.524922739609848f,-0.10833998835973915f},
{-0.8020839616105013f,-0.5267077340621636f,0.28149650336426024f},
{-0.897950943972826f,-0.3959006068355548f,0.19221553455834473f},
{-0.9993456036711802f,-0.026934135953630107f,0.024143668808110735f},
{-0.8963327407104248f,0.29896668862336495f,-0.32742409353026936f},
{-0.8605741784837886f,0.2826827944686271f,-0.42367737848315695f},
{-0.8557393201119355f,0.24926427739135673f,-0.45340659019353385f},
{-0.9459323876309479f,0.1721362417737736f,-0.27492004710245294f},
{-0.8998203313792154f,0.20831074063548452f,-0.3833145008638404f},
{-0.6470131493430032f,0.16411697389778143f,-0.7446070127630302f},
{-0.37928882572839356f,0.13891941952653408f,-0.914790348416503f},
{-0.42824001993528277f,0.7090362231701435f,-0.5602482660021778f},
{-0.13016930883258665f,0.736911931457559f,-0.6633375884973929f},
{0.034142538661852476f,0.7516578679573538f,-0.6586689127259076f},
{0.0934420660954333f,-0.24962145309640388f,-0.9638245226377343f},
{0.32948050404300766f,0.261703080508825f,-0.9071681735531494f},
{0.3044884347299521f,0.7344756283333784f,-0.6064918338279525f},
{0.09904513034534834f,0.6257943174017904f,-0.7736740492368218f},
{-0.38435452104791595f,0.44827628697749217f,-0.8070439719641677f},
{-0.5937786404386971f,0.6019148479954014f,-0.533971386800309f},
{-0.8099305080960336f,0.38763100267362943f,-0.44017584874858534f},
{0.22450958183707703f,0.1773950030846855f,-0.9581891569747204f},
{0.5646356543998268f,-0.3725049653436803f,-0.7364961836797139f},
{0.13053294835413515f,-0.8295076148612248f,-0.5430269480248827f},
{0.4361065015969161f,0.062607997314511f,-0.897714519174757f},
{0.22278176802216718f,0.30266620352190443f,-0.9266938292028033f},
{-0.05481696144822306f,0.2261156695667609f,-0.9725568388088993f},
{-0.4697068412066489f,0.22985343805975883f,-0.8523748473152999f},
{-0.9949216882535106f,-0.02377876724929505f,-0.09780288580040986f},
{-0.9410882879622156f,-0.15083665995271914f,-0.30265679618117564f},
{-0.471143861244819f,0.010144440022793218f,-0.8819980455465574f},
{0.4649594338397468f,0.42266295170526524f,-0.7779259310109251f},
{0.6475489257463659f,0.3563720827370362f,-0.6735572191064354f},
{0.7446167399739941f,0.19046357139166975f,-0.6397417748773576f},
{0.24789845113892978f,-0.8198127438327085f,-0.5161912658815584f},
{-0.15038795876030003f,-0.8751029896927854f,-0.45997632470667327f},
{-0.07838766663623994f,-0.8383392832480201f,-0.5394836604407235f},
{0.042244159247773826f,-0.7513896773914231f,-0.6585051129027488f},
{0.6603670917950485f,0.023050115089716404f,-0.7505890994868635f},
{0.8596495362749431f,0.021738895242020356f,-0.5104214878078036f},
{-0.14628066749298588f,-0.051145011627056286f,-0.9879201152438768f},
{-0.018665519516347595f,-0.0433458340824424f,-0.9988857477453977f},
{-0.1655114052929194f,-0.04444950256174982f,-0.9852056721517473f},
{0.6066083369420124f,-0.006140363615597357f,-0.7949771201029086f},
{0.8815607160747163f,0.016914996550872523f,-0.4717675134698417f},
{0.6481136215293615f,0.035596069821656875f,-0.7607112812370718f},
{-0.04839687234974067f,-0.1611462668677585f,-0.9857431832994576f},
{-0.1891265961010659f,-0.11450717200719965f,-0.9752534225554598f},
{-0.68355877764107f,-0.1157690446966037f,-0.7206558997190557f},
{-0.17911622372255587f,-0.01766548142177115f,-0.98366930884597f},
{0.7543801866150105f,0.04192505237982543f,-0.6550975683252462f},
{0.8824300207868974f,0.038994727748553046f,-0.4688247749659271f},
{0.8839402756204524f,0.059788729452602996f,-0.4637616812183626f},
{0.7326031039540238f,0.0819651062686375f,-0.6757029032284092f},
{0.4466507964716708f,0.09955098809767893f,-0.8891527803364269f},
{0.3725590563757475f,0.13022022072745537f,-0.9188266668017997f},
{0.1604614833029495f,0.5273773901646778f,0.8343411776481552f},
{0.08564627497630173f,0.5868880512489109f,0.8051255373442949f},
{0.01999038985527308f,0.483635689596183f,0.8750410870709208f},
{0.14565495113565569f,0.40177431103373995f,0.904080769734117f},
{0.026860832621139016f,0.3688725662921599f,0.9290917745346449f},
{-0.09743759037368786f,0.45294918981106125f,0.886195772632477f},
{-0.08401975382540822f,0.5838568070459136f,0.8074973125857873f},
{0.02737983105459773f,0.6801357558202932f,0.7325747050684867f},
{0.15300238071477495f,0.6727757384253747f,0.7238529389881642f},
{0.17486545305387044f,0.5640047415709892f,0.807044437942364f},
{0.18559734189966948f,0.46477357554608656f,0.865759291116118f},
{0.18958456679315056f,0.3526426303277672f,0.9163519341985191f},
{0.16142927974501506f,0.2559168391512659f,0.9531249441074506f},
{0.0023425972685084413f,0.20715517519617982f,0.978305292650243f},
{-0.11023997622078387f,0.3173194253010077f,0.9418893406178239f},
{-0.21340785361072345f,0.3655222994766743f,0.9060080223720695f},
{-0.24528412115780843f,0.42781381819198055f,0.8699488702629832f},
{-0.1788564642399293f,0.520665638246357f,0.8348159427976353f},
{-0.23036727579843302f,0.6235456846006688f,0.7470754295632348f},
{-0.09473214987962568f,0.7038419052209081f,0.7040116421155167f},
{0.014175129951222559f,0.7675215992079513f,0.6408663358611804f},
{0.10348016100592014f,0.787716285284447f,0.6072848674023259f},
{0.1307270483252382f,0.7528079068744916f,0.6451284323167115f},
{0.1680977625313317f,0.6456836108692237f,0.7448730206463656f},
{0.16092416063099188f,0.5878110747718546f,0.7928313533789944f},
{0.17176473326520567f,0.48907559415435387f,0.8551619376521025f},
{0.2283795120164311f,0.42605661812217654f,0.8753962283705765f},
{0.2297218426372841f,0.3257137513179947f,0.9171359916706412f},
{0.2405951455175341f,0.21877558230846034f,0.9456485713725743f},
{0.19182068429194277f,0.2127374496627272f,0.9580958211936682f},
{0.2015357223645373f,0.1850496903527115f,0.9618419645198321f},
{0.24649197490787442f,0.14385339731327304f,0.9584090496168354f},
{0.10882343909377755f,0.08730110912556653f,0.9902201651396768f},
{-0.0638264331401845f,0.06576710260191278f,0.9957915819326607f},
{-0.14624847686311807f,0.15493256305068664f,0.9770400625981327f},
{-0.22109328839476725f,0.2546104336336129f,0.9414304461359276f},
{-0.3257459626999775f,0.29257348345664785f,0.8990496785843969f},
{-0.3556171639151235f,0.3668597350472778f,0.8596222237297063f},
{-0.3055001854924145f,0.48717954751796105f,0.818123294586027f},
{-0.35904632351254534f,0.5294693920777958f,0.7686012623102397f},
{-0.2484322944785213f,0.6928750751901667f,0.6769088012726369f},
{-0.13381889754902027f,0.7475277799493447f,0.6506110365362464f},
{0.04804445790400089f,0.7569058653125681f,0.6517555071651818f},
{0.12178710267459426f,0.7465529902315797f,0.6540845009617754f},
{0.10482267392534045f,0.7909857440458008f,0.6027883208452638f},
{0.08615266292742599f,0.7769449264534946f,0.6236459732321594f},
{-0.06217513364928446f,0.8548800287410139f,0.5150867783349298f},
{-0.05301408820135271f,0.714302974908521f,0.6978257422086233f},
{0.00010919954561119839f,0.42658366387216345f,0.9044481001101502f},
{-0.04182585859782892f,0.6679828987368014f,0.7430002991572309f},
{0.08200275351350979f,0.5163283866776158f,0.8524555973932559f},
{0.00794151353153644f,0.38607419415612276f,0.9224335471834971f},
{-0.2177951485833826f,0.6405112514938615f,0.736417415575779f},
{-0.0828679793225384f,0.2417136845025819f,0.9668026648324806f},
{0.15140995800312643f,0.4609557516058026f,0.8744111273760308f},
{0.22764665064356454f,0.5028441847126722f,0.8338613364051692f},
{0.3706402294622199f,0.4453427933996901f,0.8150433219597311f},
{0.39672208658465347f,0.2970533061900694f,0.8685452891458612f},
{0.3048362518716956f,0.21794215917125564f,0.9271332562261948f},
{0.35470080450080343f,0.1125120249487011f,0.9281855329234698f},
{0.23899403572101996f,0.12802640229003082f,0.9625440723449764f},
{0.10218137298752393f,0.13025930030425314f,0.9862005281374732f},
{0.09775781926984732f,-0.07171696548251229f,0.9926228315093221f},
{0.38864832221217843f,-0.010240398958345295f,0.9213292657192826f},
{0.4551710517245564f,0.23360878868627294f,0.8592125741168443f},
{0.19705845840689065f,0.06542013143097142f,0.9782066092466633f},
{0.08298101529248131f,-0.09147764609995072f,0.9923436861113398f},
{-0.005029837095347092f,-0.03560478696626226f,0.9993532908255626f},
{-0.09881208271431033f,-0.07768274872084771f,0.9920693336964076f},
{-0.17560411072208226f,-0.008703853868653598f,0.9844223886245883f},
{-0.2718779400383816f,0.1075369489113311f,0.9563044443791568f},
{-0.360113478515937f,0.1889047128730699f,0.913582668424426f},
{-0.44878342290385537f,0.21616475349698547f,0.867102207742713f},
{-0.5275570116645842f,0.3163522291195631f,0.7884192200692581f},
{-0.45157466535831164f,0.42195683124298283f,0.7861505925545751f},
{0.84821322896723f,0.48000744112299343f,-0.22389098836608276f},
{0.828390639649765f,0.48523582720081176f,0.2798484235106516f},
{0.9292636777474713f,-0.30591854355610193f,-0.2070817759431211f},
{0.9569936722172205f,0.2184001706610674f,-0.19095674062838303f},
{0.35059637737765886f,-0.9249629765978002f,-0.14671629798014785f},
{0.799435733792978f,-0.4882123897956128f,0.35007309234635464f},
{0.6833936826847007f,0.7060925609968854f,0.18548954086821762f},
{0.7718409917591794f,0.42821053082530436f,-0.46999704757638366f},
{0.5090161725187932f,0.8541980005400321f,-0.10605805951331274f},
{0.6047466047974223f,0.744845044084757f,0.2819351065198639f},
{0.8161832515168738f,0.5268362184372811f,0.2372519734081233f},
{0.8632080183946572f,-0.4496394953706776f,0.2295566186847407f},
{0.7481786877420452f,-0.6485685891987215f,0.1399551224977889f},
{0.0998776264560731f,-0.9949926342861447f,0.0037573194992853724f},
{0.10682453757043023f,-0.992964136172951f,0.05109542491426445f},
{0.11618266311839023f,-0.9932271857004105f,0.001160334590112187f},
{0.6027731794932082f,-0.47791576092866705f,0.6389530652087222f},
{0.8753914333720827f,-0.35377744265350214f,-0.3294409802200062f},
{0.9054699627271678f,0.366190813608157f,-0.2145423842224592f},
{0.7372753731648989f,0.6692550257188002f,0.09231865832369421f},
{-0.09308941600974661f,0.9948175909751859f,-0.040894025398487334f},
{0.0960307693372775f,0.9932149522838429f,-0.06559077603058384f},
{0.020049572441360027f,0.7444749003074221f,-0.6673493368972301f},
{-0.10457667868591117f,0.8755664127564919f,-0.47164305902637005f},
{0.2916087285517697f,0.10236222987173008f,-0.9510448587359627f},
{-0.31576582464701897f,0.6499626588285293f,-0.6912600712564968f},
{0.14462133159067234f,0.23861316023692056f,-0.9602855982522545f},
{0.43560782146783494f,-0.30893158606935167f,-0.845462655003f},
{0.28523979067463046f,-0.20581571711096255f,-0.936097298578515f},
{-0.4254551062470612f,0.17448138735771918f,-0.8880001115056391f},
{-0.47454272328261804f,0.4638622957608103f,-0.7480915547919434f},
{0.37923856311778653f,0.014553651469087242f,-0.9251844699697855f},
{0.4642071351308021f,-0.06183496409300712f,-0.8835656019273668f},
{0.39948526758718206f,-0.18055296722472766f,-0.898783704239871f},
{0.22330025384093488f,-0.19407207763554135f,-0.955234539428301f},
{0.09295362834202764f,-0.013609661316918055f,-0.9955774204434785f},
{0.008287001079437053f,0.06945843270678717f,-0.9975504256622951f},
{0.021351013369780177f,0.22057530209328421f,-0.9751362316797278f},
{0.11672359366173207f,0.36981573981455573f,-0.9217439564586813f},
{0.18066742147266487f,0.3792687315558131f,-0.9074770036108148f},
{0.1327122490538464f,0.5702313504054233f,-0.8106933242391214f},
{-0.038950373347801895f,0.5781790646902506f,-0.8149796546969585f},
{-0.343940015523824f,0.5349413304165082f,-0.7717143504780042f},
{-0.8283753504924163f,0.11677897032921487f,-0.5478658145800073f},
{-0.9471141114777851f,-0.2376236014346411f,-0.2156615030107982f},
{-0.7383832117686505f,-0.6678373966759981f,-0.09372003083246162f},
{-0.7193944676676717f,-0.6729069142723539f,0.17224367800765936f},
{-0.8417743674659319f,-0.5392675567479599f,0.024625525708423482f},
{0.9177095294123981f,-0.11384050753526671f,0.3805910646215799f},
{0.987611903482167f,0.08862685121027498f,-0.1294913485329531f},
{0.9975052166151093f,0.002704623692493132f,-0.07054096566057218f},
{0.6940109194288436f,-0.23096930668069768f,0.6819105682455501f},
{0.9953187684809908f,-0.06017479575441969f,0.07562766071615426f},
{0.9894909606493936f,-0.004455915193615164f,-0.14452606551389804f},
{0.9957514265885271f,-0.020844642732150982f,-0.08969167919200755f},
{0.9701987978428639f,0.08137322770654618f,-0.22823823184751543f},
{0.9657156657071851f,0.06837378878985621f,-0.25043617553031f},
{0.976100941035369f,0.17945423350050255f,-0.12256888262774515f},
{0.30694042188812265f,-0.279931139818137f,0.9096296688055309f},
{0.1914220255981105f,-0.2768400980572328f,0.9416566084425777f},
{0.4592707965057891f,-0.25576298891135835f,0.8506795101447232f},
{0.9322440471162641f,-0.11583570307237982f,0.3427872904732848f},
{0.9983975951567259f,-0.05263149963204871f,0.020788632272182875f},
{0.893571473646972f,-0.21550813112897085f,0.3938099375354526f},
{0.8034382183647676f,-0.3067998221749825f,0.5102557186198378f},
{0.8854410831278445f,-0.31750427814914434f,0.3393893364064056f},
{0.9890290087363023f,0.039619074685688725f,-0.1423093419250365f},
{0.9963366762125511f,-0.05016309222025782f,-0.06925959726007631f},
{0.9473456422242327f,-0.31380050094424145f,-0.06376111484203587f},
{0.9371082654456901f,-0.15411056124746722f,-0.3131741268773024f},
{0.9099865558854238f,0.0698146864514159f,-0.4087179683638524f},
{0.9059930276933849f,0.22980265302098604f,-0.3554818904466018f},
{0.9185112896043935f,0.3595603179957772f,-0.16447914333449548f},
{0.9419326473962951f,0.2193298737111573f,0.2542779862018231f},
{0.5238521489379051f,0.8516546615176906f,-0.016225398864950204f},
{0.3694534486494629f,0.9246344581007413f,0.09249469267891584f},
{0.5003416782231608f,0.841638494603891f,0.2032310247814721f},
{0.35334030684967244f,0.9000282139558887f,0.2551467061099403f},
{0.19559860883688254f,0.9686766856608281f,0.15299236215651346f},
{0.20800000378861327f,0.9781251526894903f,0.0026803171637114725f},
{0.3755150666226769f,0.9229650337706419f,-0.08440367987312312f},
{-0.4970240582194369f,-0.7113310730291603f,-0.4969659848463126f},
{-0.3299673012576743f,-0.7990648292090714f,-0.5026101658560089f},
{-0.4776732527250906f,-0.8447336796160603f,-0.24135715061572743f},
{-0.620874518132649f,-0.7408698057486882f,-0.2561772114444453f},
{-0.5167259571171698f,-0.8560821246588595f,-0.010848091118620737f},
{-0.23769510142702507f,-0.9713392534680664f,0.0010456718872809262f},
{-0.26421949402625067f,-0.9197553553875996f,-0.2902380836698426f},
{-0.13288313997339685f,-0.843069485012034f,-0.5211294604533064f},
{-0.14811555849598323f,-0.6560659426498093f,-0.7400265267045769f},
{-0.3281581868518979f,-0.6110777225608969f,-0.72034451576441f},
{-0.4829002534029488f,-0.548141028376414f,-0.6828973263044856f},
{-0.6393225767817843f,-0.6342233290414309f,-0.43477282771201836f},
{-0.5456430478424276f,-0.767657417686737f,-0.33611865971968435f},
{-0.6353086022574881f,-0.7651233032231176f,-0.10473447743022327f},
{-0.5494947414149571f,-0.8354967232775371f,-0.000868648264881445f},
{-0.37441341852056237f,-0.9107810536452934f,0.17404730492746953f},
{-0.12174358955713277f,-0.9778494238274927f,0.17026157147749107f},
{0.04496288474951671f,-0.9980958338490301f,0.042226122817648856f},
{-0.017228886684696153f,-0.9687080988468412f,-0.2476040886014297f},
{0.2545484884791824f,-0.8016928321925928f,-0.540826839038137f},
{0.023757081396123026f,-0.6852000418113633f,-0.7279673782424896f},
{0.1776044064197447f,-0.4453159464626318f,-0.8775821230211908f},
{0.13873354600649107f,-0.3218604509544395f,-0.9365675914336721f},
{-0.1698492955212068f,-0.41651817414943865f,-0.8931202760066348f},
{-0.42134297997228504f,-0.41275398474183933f,-0.8075297154333133f},
{-0.6307832840713153f,-0.4958656175656624f,-0.5968498453149087f},
{-0.5651366973816127f,-0.6650129275067589f,-0.4882400224495058f},
{0.9042566757383664f,-0.01854410085402561f,-0.426586428178528f},
{0.8909986088377806f,-0.32803376252724825f,-0.3138715178084123f},
{-0.4252305966130146f,0.7983757907674557f,0.42635083724625156f},
{-0.48753146230680056f,0.7138676294477646f,0.502698797380322f},
{-0.5934514994234056f,0.35223928017081096f,0.7237007719609402f},
{-0.6695926445214998f,0.4328378498657601f,0.6035702826732692f},
{-0.3906803323833908f,0.2337593667541121f,0.8903512994001412f},
{-0.5297790874530731f,0.2333094034272669f,0.81541452082349f},
{-0.6960345121828988f,0.18940899898382707f,0.6925750421104263f},
{-0.7647818283734458f,0.10632742396783329f,0.6354551391735958f},
{-0.5233475256477761f,0.612803476104361f,0.5920973459430149f},
{-0.18296492186124555f,0.9196979542650958f,0.34738956560165424f},
{-0.7727471135044047f,0.21893964348486047f,0.5957577788676643f},
{-0.6811285670348696f,-0.09816696742223376f,0.725552976478043f},
{-0.5876786348471403f,0.028239700815101867f,0.8086014725698162f},
{-0.26389652525504403f,0.32501649731669524f,0.9081425551257359f},
{-0.15239340016011219f,0.26525570178283275f,0.9520586453886845f},
{-0.40276969900839776f,0.3503185379628898f,0.8456083558718114f},
{-0.6097768929626993f,0.49233706429125185f,0.6211089726721297f},
{-0.7623756573720621f,0.3783432634045348f,0.5250140303676873f},
{-0.8719519609086391f,0.05348199419319371f,0.4866615396399209f},
{-0.9207019714217932f,0.012041031151241147f,0.3900806242161203f},
{-0.9059444808886661f,0.10966476057013227f,0.40894772017515973f},
{0.1440488734713913f,0.7986277739667752f,0.5843317556837867f},
{-0.7687384541045501f,0.367932736153954f,0.5231316190474546f},
{-0.8532152088992458f,-0.013946273795562387f,0.5213725239694124f},
{-0.7503916577377466f,-0.1824194793561305f,0.6353231410463771f},
{-0.6765881701722821f,0.013843427162867697f,0.7362314904344348f},
{-0.4509678615583841f,0.7063089774218574f,0.5456698784565155f},
{-0.41248242607170044f,0.7469266459920003f,0.5214967245238892f},
{-0.13662531015459953f,0.39516940895930996f,0.9083912498741439f},
{-0.009662416955210218f,0.3283018726542963f,0.9445234343891452f},
{-0.5445404006973165f,0.5460510807439887f,0.6366348790529216f},
{-0.6168713196474861f,0.681808973838177f,0.3932000739955439f},
{-0.8552392487206352f,0.28616519238113514f,0.4320593826283971f},
{-0.9427566759013997f,-0.01987836226553246f,0.33288842088150744f},
{-0.9587385399230894f,-0.02410795809902684f,0.2832652792391583f},
{-0.9249339342925695f,0.047456932931156f,0.3771538899585104f},
{-0.9349937809118266f,0.02675246218546929f,0.35365369420270715f},
{-0.8830125863422911f,0.021750807140976797f,0.46884504343099753f},
{0.12408848520986897f,0.3716927720651671f,0.9200252882572477f},
{0.040111323967367815f,0.5776196321449845f,0.8153199631128124f},
{0.13050221698803807f,0.7589408858835892f,0.6379481978150261f},
{-0.9629778012625747f,0.017766311257333186f,0.26899463277137137f},
{-0.9497706997619333f,-0.00013049253747023706f,0.3129466421699158f},
{-0.6246563014585899f,0.4660364157854927f,0.6265896298295134f},
{0.42297189579157163f,-0.15180545169932236f,-0.8933363757313639f},
{-0.36309506131601105f,-0.12481842156159466f,-0.9233538531282546f},
{0.6597425422547673f,-0.2990279943527175f,-0.6894360278753987f},
{0.8024363230295736f,-0.2615432273854947f,-0.5363684253305345f},
{0.725991631645604f,-0.5194437347986416f,-0.45068210210634296f},
{-0.20491931879973657f,0.16460582073160007f,-0.9648383266454169f},
{0.5517663766143032f,0.08097764699754131f,-0.8300581222569084f},
{0.5560932146992987f,-0.04057626704080903f,-0.8301288472992808f},
{-0.1995922665973581f,-0.3883513883076975f,-0.8996366635003339f},
{-0.6442790443336475f,-0.2120075525192641f,-0.7348178758762701f},
{-0.7721301253738461f,0.09178006688505308f,-0.6288016291428832f},
{-0.6761113729604289f,0.1251098867231433f,-0.7260998055348082f},
{0.7003943712373027f,-0.40370806389803626f,-0.5886149198608565f},
{0.6108579564832639f,-0.5980845624029809f,-0.5187941915792099f},
{0.6222764495674331f,-0.6415807962452534f,-0.4484931462163678f},
{-0.4096593988881334f,0.18025561460226616f,-0.8942522520558571f},
{-0.41628195028659615f,0.2762639160174058f,-0.8662491480932698f},
{-0.1709587068508183f,0.22469569857277324f,-0.959314840703921f},
{0.3734906581924015f,0.11676167932283195f,-0.9202561809000355f},
{0.7589132775975987f,0.0322487130075747f,-0.6503926949124081f},
{0.7175816771968393f,-0.010943752347826649f,-0.6963883764365403f},
{-0.13344614136508226f,-0.10190708576688266f,-0.9858027557403517f},
{-0.16718567719246166f,-0.17371747852616254f,-0.9705004827387828f},
{0.10086074342105927f,-0.48915179246352075f,-0.8663472943146275f},
{0.3730722331440961f,-0.6477462090901377f,-0.6642604590567112f},
{-0.45658267426239285f,0.23680287408976763f,0.8575876983645623f},
{-0.7843445600179644f,0.2525813938554909f,0.5665741351740681f},
{-0.9670093775048816f,0.1590237623432467f,0.19900830843917067f},
{-0.986447276617588f,0.06897863794206711f,-0.14887483992065562f},
{-0.9963949733064761f,0.03617880555699291f,0.07673428958461925f},
{-0.944482304485752f,0.14821501372732465f,0.2932328191371019f},
{0.4034833237364546f,0.7821909652004863f,-0.4747404569081037f},
{0.3030957965729152f,0.8375161180048172f,-0.45464237613972086f},
{0.19363798702571816f,0.15404529588601795f,-0.9689036984117756f},
{-0.008802742821463233f,-0.15351339574248463f,-0.9881073570449875f},
{-0.31253832511375057f,-0.7501066110076919f,-0.5828034552554116f},
{-0.16274713884926173f,-0.8643255250313399f,-0.47587262536909797f},
{0.005533334584186107f,-0.726560669938355f,-0.6870800354450043f},
{0.17787715086664932f,0.5089624962592488f,-0.8422095324805564f},
{0.18142286260540014f,0.7534623332180905f,-0.6319653925221009f},
{0.13874424408414035f,0.799531244879411f,-0.5843798620718376f},
{0.15050907385308795f,0.7923710174615396f,-0.5911811815127831f},
{0.2626773863259145f,0.7753087551612949f,-0.5743665422735116f},
{0.3805291111768886f,0.8641747565812173f,-0.3292409233900318f},
{0.42670326674459463f,0.8416223958359393f,-0.3310529640055572f},
{0.25576691690133624f,0.8047944181259233f,-0.5356204148201796f},
{0.09002009007914265f,0.40760113440722756f,-0.9087121098632306f},
{-0.31818878017689334f,-0.7537827375834347f,-0.5749499845123603f},
{-0.40737397868665076f,-0.8241149090335507f,-0.3935493084705281f},
{-0.3035650764495224f,-0.8693614878657423f,-0.38994723716941304f},
{-0.058033499256430573f,-0.9450908887541034f,-0.321613626822672f},
{0.1379526828173473f,-0.6652836025507856f,-0.7337348195912096f},
{0.17238233177716086f,0.45933889468935746f,-0.8713736922334919f},
{0.3199759601131611f,0.7297076101260996f,-0.6042699634051959f},
{0.6808747819182197f,0.7299414947636707f,-0.05995786495527372f},
{0.555359405711417f,0.7740669698602166f,-0.3039675256656283f},
{-0.17129194965177383f,0.4552585721387401f,-0.8737269026868119f},
{0.6657557433086989f,0.7267777211523307f,-0.1690072018823657f},
{0.5461692641160534f,0.7853466431898652f,-0.2914271520729304f},
{-0.26317616858671106f,0.41791621249888894f,-0.8695311056072708f},
{-0.055632162139692215f,0.4684261357030804f,-0.8817494076697427f},
{0.61770650222571f,0.7765458242643795f,-0.12415820522878987f},
{0.520537496262023f,0.8236781394193458f,-0.2249334070962989f},
{0.21770895783023017f,0.6120689081177809f,-0.7602463162659735f},
{-0.0360668300343903f,0.3530472617669576f,-0.934910057026944f},
{-0.17056771817850264f,0.3556159859587018f,-0.9189363003201034f},
{-0.0408192309218773f,0.6599701503716617f,-0.750182105228692f},
{-0.22337039172014972f,0.5278770798782659f,-0.8194214157818805f},
{0.006236518781487173f,0.6773858436684433f,-0.7356014713355864f},
{0.3530731541447222f,0.8961677255228545f,-0.2687429172154884f},
{-0.27293383369623664f,0.5135154766399312f,-0.8135164274156603f},
{-0.35523441546199186f,0.5241677822065812f,-0.7739874974235765f},
{-0.28016300095033897f,0.409097699586506f,-0.8684168152975446f},
{-0.41946366272916247f,0.2939098081836618f,-0.8588755790586193f},
{-0.2155358153356948f,0.42051316797374283f,-0.881313217799588f},
{-0.21793021269145457f,0.2872037576205394f,-0.9327488536604588f},
{-0.3211384423698532f,0.4386853391786635f,-0.8393004670688355f},
{-0.5095928694251404f,0.3911860724273441f,-0.7663475478984195f},
{-0.6175792995152689f,0.18108583022119792f,-0.7653781620240606f},
{-0.6218750528388762f,-0.15149613820364446f,-0.768323069265805f},
{-0.7228302835238852f,-0.18592357999198195f,-0.665543990750232f},
{-0.8215964397178172f,-0.1779858240852855f,-0.5415720973865705f},
{-0.8459010989971352f,-0.09633273487858221f,-0.5245677600713294f},
{-0.9076896626234237f,0.032451379643288265f,-0.41838544946714223f},
{-0.9771523149182051f,0.041027803548597835f,-0.20854273611413712f},
{-0.4059140458804218f,-0.7875107709150464f,0.4637462377742556f},
{0.117229649315097f,0.1330046969928375f,0.9841579953946942f},
{0.23197287840453285f,0.2917532055593323f,0.9279378485278902f},
{0.49398748180782176f,-0.18547027305659522f,0.8494569710288327f},
{0.6676350539985663f,0.11001818751738121f,0.7363147649529526f},
{0.16294821528344045f,0.2372801773796048f,0.9576773969133054f},
{0.5273798759503873f,0.3563083106843841f,0.7713072372147137f},
{0.3773246819856691f,0.052308634342789574f,0.9246025584745079f},
{-0.34678583954637976f,-0.9080433357409364f,0.23494016665224707f},
{-0.41798393261682387f,-0.9083869781411467f,0.011069327792163441f},
{-0.3525176755095777f,-0.7720321076998433f,0.5288645508387395f},
{-0.5056324447783861f,-0.5515157169830139f,0.6634502579004279f},
{0.11048661025893285f,-0.11356887071315341f,0.9873676217895895f},
{0.952627328165849f,-0.2952872022891292f,0.07284670065181237f},
{0.7858049308554479f,-0.3325484827988804f,0.5214615203746367f},
{0.5974887857503655f,-0.06386691622310516f,0.7993298242369695f},
{0.9322989724875217f,0.36008206182524594f,-0.034051940479083276f},
{0.888711127153783f,0.45572879219482604f,-0.05003798994461693f},
{0.8992405365918723f,0.4288062216858197f,0.08655450071193965f},
{0.7320452900037248f,0.2544451009494721f,0.631955207262489f},
{-0.11379117679893566f,-0.8232744209047883f,0.5561212061831476f},
{-0.3828994109985334f,-0.7307715902411372f,0.5651202738828395f},
{-0.29807369422680874f,-0.7178276714772917f,0.6291863848427366f},
{-0.10908687892644416f,-0.5883974159448911f,0.8011794641373816f},
{-0.020995671353211665f,-0.3784097498069393f,0.9254000448646398f},
{0.07677437858788673f,-0.44726564908722655f,0.8910999573218628f},
{0.28996368430125674f,-0.6758725386213806f,0.6775820048702086f},
{-0.2696467091304295f,-0.18026909571078006f,0.9459353600467355f},
{0.20577169849937138f,0.07450088736686167f,0.9757600247387849f},
{0.7500762202976601f,-0.5891969056854817f,0.300387533154473f},
{0.8275262400659166f,-0.5128936598795472f,-0.2283427591532746f},
{0.9576808826900295f,-0.03630416475173172f,-0.2855334210766313f},
{0.9067097498493655f,0.09117290598848407f,-0.41178262559476214f},
{0.9279360251974819f,0.3109469561817067f,-0.20554007780000036f},
{0.860531889431575f,0.4152752152851739f,-0.29501078427944977f},
{0.8415288340601036f,0.3547990535548986f,-0.40736574848898505f},
{0.8988650815807105f,0.12206181785150254f,-0.4208829739223117f},
{0.9998933437162394f,0.010251522776978536f,0.010402282091522694f},
{0.30259027232373376f,-0.7200450737555572f,0.6244791580632637f},
{-0.02356866357454104f,-0.586198876824879f,0.8098242987874348f},
{-0.07079481909455179f,-0.25832949868732047f,0.9634593731431167f},
{0.0811448702542985f,-0.4935872601310382f,0.8659024925866352f},
{0.3060670570802372f,-0.11932755144699793f,0.9445019280212756f},
{-0.17121628672412983f,-0.3910287670447162f,0.9043127149962503f},
{-0.3942179855613414f,-0.8444038679489884f,0.36273170202333516f},
{-0.37150739902132535f,-0.7373673712576021f,0.5641556631613861f},
{-0.02881498179768022f,-0.018783573274594158f,0.9994082620226017f},
{0.042590977553312204f,-0.2314478631529673f,0.9719145514256788f},
{0.3884840709925401f,-0.0857477632351214f,0.9174570549542014f},
{0.2700585683746963f,-0.10710567794530482f,0.9568681954163207f},
{-0.012790537634650035f,-0.6436799636428828f,0.7651878897053414f},
{-0.3235280562152561f,-0.8310289280752116f,0.4524605149001874f},
{-0.4085102307066811f,-0.7884003292006783f,0.4599394659346338f},
{-0.3552083073756428f,-0.847786504946246f,0.39380845648914087f},
{-0.06674793185065842f,-0.2189778212988034f,0.9734441059315574f},
{0.1346439187930126f,0.026084286337302892f,0.9905506676280291f},
{0.1431289122437199f,-0.13328625763336355f,0.980687966687683f},
{-0.06372065135248321f,-0.39843898191948846f,0.914978719030217f},
{-0.21035479501245463f,-0.6251178199653991f,0.7516505646754847f},
{-0.1800933715054086f,-0.29436359924035094f,0.9385714938043244f},
{-0.07066890368925784f,-0.6964564448346582f,0.714110864291832f},
{0.04907803173698377f,-0.5028722692239301f,0.8629662957766072f},
{0.1260203551460533f,-0.4740724268726566f,0.8714207962677573f},
{0.23405245505574543f,-0.26746963065809465f,0.9347082138068546f},
{0.24372355449708907f,-0.1824124171097217f,0.9525358466049945f},
{0.2256209010474983f,-0.8253545898259265f,0.5175760910859306f},
{0.05488864095359112f,-0.7919577106285207f,0.6081037918565383f},
{-0.06402474356381864f,-0.6271257550279632f,0.7762822422239184f},
{0.13631294963698184f,-0.18415104576383548f,0.9733998007526771f},
{0.2084274415477797f,-0.17232145325095255f,0.9627374088292854f},
{0.42296973917888325f,-0.38234995593183196f,0.8215260865839098f},
{0.6554366950187803f,-0.1972144354798104f,0.7290467785137233f},
{-0.1610437057761731f,-0.3863275359216847f,0.9081937897929917f},
{-0.5436267173677841f,-0.03168164875436079f,0.83872895818383f},
{-0.4978717995007927f,-0.2067534567331072f,0.842245023369538f},
{-0.2261150200768096f,-0.33385300317091315f,0.9151033657294821f},
{-0.046696491296537225f,-0.43865424536395936f,0.8974418592448025f},
{-0.22266441909433682f,-0.5749963071639161f,0.7872736520532368f},
{0.01950597944212249f,-0.20130059788294488f,0.979335277654171f},
{0.006292441713448427f,-0.5345267653751934f,0.8451281218104246f},
{-0.1053471068136114f,-0.8554939150746985f,0.5069833807494738f},
{0.048834430662541665f,-0.8968889252152168f,0.4395514238495408f},
{0.28641902757739773f,-0.42520612766104365f,0.8585824885479076f},
{0.2530794121685365f,-0.28395796581086f,0.9248344093885059f},
{0.2636758705201547f,-0.9281137138561374f,0.2628306859132059f},
{0.35522914280170326f,-0.718506978797738f,0.5979631907762499f},
{0.28137448164958956f,-0.6473207331457641f,0.70838144351476f},
{0.13821699745144f,-0.7847198560075795f,0.6042439980694488f},
{0.17298344594740767f,-0.5517896769528474f,0.8158461128401805f},
{0.16039626074695093f,-0.15909306192714248f,0.9741470305785686f},
{-0.011981595156798414f,-0.44850883263318214f,0.8936980857244345f},
{0.2168021596767886f,-0.34711801978012724f,0.9124176148581326f},
{-0.24824026127917578f,-0.632799244516809f,0.7334452186898501f},
{-0.47120336655549466f,0.12434968544044361f,0.8732150611834584f},
{-0.26421204989019115f,0.034149536249324514f,0.963859845551613f},
{-0.22809955475460592f,-0.8652124900763485f,0.4465175697961224f},
{-0.09277243426688733f,-0.8457828667479228f,0.5253994839699234f},
{-0.1750556182597213f,-0.7378794328649356f,0.6518354647229833f},
{-0.17414264458035814f,0.11456928054751862f,0.9780328313985084f},
{-0.35382351724322325f,-0.34435269666453217f,0.8696149371678819f},
{-0.3762526158795721f,-0.5477871785213421f,0.7472370280516126f},
{-0.2564399771910332f,-0.5359880604568066f,0.8043353387400141f},
{-0.15400723242234993f,-0.42908822699425353f,0.8900365530788813f},
{-0.08999127452798444f,-0.3038111884110676f,0.948472631289424f},
{-0.043938760655722074f,-0.21311568082125146f,0.9760384684530287f},
{0.16430781920133763f,-0.13128294277181943f,0.9776337399488991f},
{0.2452259128791196f,-0.053450367522879454f,0.9679913790237346f},
{0.3344590366295881f,-0.16552447917864532f,0.9277600980907973f},
{0.4519756627831516f,-0.26158249492317975f,0.8528145159420629f},
{0.5444602397110275f,-0.2945688286962927f,0.7853612242365322f},
{0.6411572661208012f,-0.42255048779005727f,0.6406000666319701f},
{0.7296970193906711f,-0.42522108601768877f,0.5354710896942131f},
{0.680708821142833f,-0.5505960438286813f,0.4831971619727699f},
{0.6998413681189168f,-0.54754985910218f,0.45870601834576513f},
{0.4821222518560962f,-0.23899060727329183f,0.8428769921526806f},
{0.5091069691533285f,-0.06895115830906359f,0.8579369625603913f},
{0.3658564698535647f,-0.17583595499590726f,0.9139096018737111f},
{0.4753943428732396f,-0.0496791574663527f,0.8783690568761823f},
{0.6624131023283732f,-0.07862743748922107f,0.7450010791519557f},
{0.3994194676768224f,-0.5931682414662359f,0.6990103905927415f},
{0.3682791555365455f,-0.5302990121876943f,0.7636448266504818f},
{-0.5528770057550253f,-0.31562677151194757f,0.7711723267936308f},
{-0.9806605523583494f,-0.1476775715433067f,-0.12843759539670838f},
{-0.9249902416315962f,-0.07470156924965297f,0.372575802271109f},
{-0.9711325684255232f,-0.012821247588987728f,0.23819561321214186f},
{-0.990464257373289f,-0.07443914635504985f,0.11592828971355826f},
{-0.6055947666533529f,-0.26600647430507723f,-0.7499970228139932f},
{-0.7172184117775079f,-0.2950626682871259f,-0.6312968965475997f},
{-0.9805346504598252f,-0.11935337905332251f,-0.1559056450427068f},
{0.27349496492088327f,0.017740634386262253f,0.961709818008789f},
{-0.5974084777214123f,-0.008612753493741026f,0.8018908474498515f},
{-0.8844595552854595f,-0.18579960593037556f,0.4280301408783786f},
{-0.885101754256045f,-0.19915199709183853f,0.4206344810725863f},
{-0.3170181074997714f,-0.02090255501930376f,0.9481891175872713f},
{-0.408033302823197f,0.03873011173468525f,0.912145165109267f},
{0.4131815601794545f,-0.5122629874556793f,0.752906122973279f},
{0.34981467387084425f,-0.6722062208984775f,0.6525093796490761f},
{0.4390720052947546f,-0.476498871635053f,0.7616853677844706f},
{0.44459251948762996f,-0.431059691624492f,0.7851910811211747f},
{0.5124818986792022f,-0.4015716920368794f,0.7590141498554538f},
{0.3599889495785072f,-0.43402347991113926f,0.8258520297651317f},
{-0.3279985950563525f,-0.31323439119481766f,0.8912357363873327f},
{-0.5499266178594979f,-0.3124176094612046f,0.774581146341789f},
{-0.7972638534267983f,-0.24466120382496137f,0.551825373974388f},
{0.1855842921323681f,-0.4649111397463144f,0.8656882248555254f},
{0.6557929715860167f,-0.4585735552919756f,0.5997048213957089f},
{0.5298747358128658f,-0.41295793098085476f,0.7407418656909148f},
{0.29697411951807895f,-0.3730132672168652f,0.8790150594936705f},
{0.42904542664649686f,-0.3980075284848418f,0.8108699212223336f},
{0.4855604594491267f,-0.389112740534353f,0.7828296847804115f},
{-0.6453701220707737f,-0.07553181881752512f,0.7601265354429295f},
{-0.7839797577806691f,-0.07435768887991083f,0.6163170235313981f},
{-0.8645888336990947f,0.19084487158805868f,-0.46482726214302084f},
{-0.08134910255245834f,-0.3479246472481931f,-0.9339864899189549f},
{-0.042548408736584234f,-0.43363701804540933f,-0.900082534823707f},
{-0.18331561938053592f,-0.6522295856428177f,-0.7355215505363039f},
{-0.19277905725712033f,-0.5531911195859667f,-0.8104417439238187f},
{-0.30800798821067693f,-0.8898717363197297f,-0.3365402978808342f},
{-0.222887973513571f,-0.8381941762738715f,-0.49774639538984083f},
{-0.14916475536865023f,-0.8318999447350653f,-0.5345019716573607f},
{0.028543943223540095f,-0.6193175168577034f,-0.7846216009124778f},
{0.09965926159804053f,-0.30846546547856674f,-0.9460005751503666f},
{0.2578530062753002f,0.32723765511501574f,-0.9090804938120806f},
{0.05015474657712175f,-0.11400032721334567f,-0.9922139017324011f},
{-0.055403295066606115f,-0.047986232812759454f,-0.9973102808836387f},
{-0.10440331751073635f,-0.2789660895226057f,-0.954608751368443f},
{-0.1805412694792314f,-0.23446829366991018f,-0.9552117405467483f},
{-0.32192855804796233f,-0.6579623973659068f,-0.6807697754495775f},
{-0.3217281229498552f,-0.8465767976145084f,-0.42402681594909347f},
{-0.3481839289901896f,-0.9263150785140993f,-0.14390388080372524f},
{-0.333762284472119f,-0.9422970587926545f,-0.026057445282776388f},
{-0.261131341843055f,-0.9605718010408419f,-0.0954580397473085f},
{-0.17061601057283454f,-0.9469081599939769f,-0.27249791462143574f},
{-0.08728876855821477f,-0.9695592922515653f,-0.22876942473205245f},
{0.02723165872627698f,-0.8862888638476195f,-0.4623315764499666f},
{0.19407671445460128f,-0.41490141645745854f,-0.8889269056160364f},
{0.3014380984501321f,0.48229588919611727f,-0.8225118528430427f},
{0.27382421625158443f,0.5630448451653093f,-0.7797440611681362f},
{0.39702806941876634f,0.7761207579832902f,-0.4899033385485859f},
{0.2644021827737481f,0.47018291855547506f,-0.842032961850742f},
{0.3875488416248639f,0.3953389520250712f,0.8327742841652501f},
{0.24721778021941426f,0.116645053374271f,0.9619133540328353f},
{-0.013942965825324517f,0.3792001896239997f,0.9252096032214087f},
{0.3461220831271775f,0.2922724000476737f,0.891502298225908f},
{0.22834733206719654f,0.4769747411466856f,0.8487358789669761f},
{-0.058756021412336615f,0.5685069283029976f,0.82057760292326f},
{-0.45664000691960793f,0.18359052289227257f,0.8705023974605712f},
{-0.11155074403568112f,-0.4290964296795123f,0.8963440664953282f},
{-0.44325680103152504f,-0.8430723734299899f,0.30455275651095765f},
{-0.5188171177700138f,-0.5814238915588029f,0.6267176849534669f},
{0.1688118710087893f,-0.27815381026094843f,0.9455860669679034f},
{0.6434604899648465f,0.26104551628495065f,0.7195928267303137f},
{0.6765458240994522f,0.25340447831470647f,0.6914274497470032f},
{0.4818079294416509f,0.43568609611556275f,0.760288593087342f},
{0.34612764148892355f,0.47654404108899573f,0.8081469128196215f},
{0.1326780770920266f,0.6395591212384197f,0.7572058229437374f},
{-0.48072568293611506f,0.5550536910513748f,0.6788359284951341f},
{-0.8109755253426343f,-0.05451381826138653f,0.5825349267758996f},
{-0.32449859015661037f,-0.49003848389118815f,0.8090506469263825f},
{-0.26936479534663027f,-0.46074550602445713f,0.8456690757655355f},
{0.07249410573107183f,-0.9482221951269294f,0.30922366226231746f},
{-0.23709717424786508f,-0.9704700040911824f,0.044417351597519396f},
{-0.4125892485732757f,-0.9063932251811442f,-0.09067211979138398f},
{-0.5576975547425806f,-0.7589901440434917f,0.33601696189178576f},
{-0.47146135252663496f,-0.5628040327840075f,0.6789519966505834f},
{-0.27094447195522964f,-0.5450434070241689f,0.7934209334120116f},
{0.8148699672255799f,-0.09684194341767152f,0.571496784338172f},
{0.8329157051778949f,0.13440246753368454f,0.5368308903079878f},
{0.8508913740791401f,0.14906560199729835f,0.5037492588767709f},
{0.7746780214966545f,0.26582812014227214f,0.5737676999898603f},
{0.5461939276127675f,0.3924928673164314f,0.7400145556302693f},
{0.42961157780771125f,0.5117949914229387f,0.7439756575103537f},
{-0.6349287886006693f,0.029703805211334783f,0.7719994283430874f},
{-0.8885702645023369f,-0.1491075120439162f,0.4338315743399973f},
{-0.8655869231022386f,-0.3384558240169799f,0.3690622355963645f},
{-0.8149349867331076f,-0.31474504120116165f,0.4866379829376133f},
{-0.5931501489357494f,-0.30775489491667535f,0.7439488056797487f},
{0.40128438955896956f,-0.5336201257083254f,0.7444598042442025f},
{0.6349905196297668f,-0.7708468136970974f,0.050815645163188435f},
{-0.004083731300684423f,-0.3930169768932252f,-0.9195221471027077f},
{0.248243885643003f,-0.13564033242619838f,-0.9591541447860056f},
{0.13655554290207092f,-0.2671415180180726f,-0.953932908046326f},
{0.12977410683884125f,-0.18113967358367555f,-0.9748574766847616f},
{0.38326548576669023f,0.8220472650431321f,-0.4211245201304829f},
{0.3019011582906884f,0.5981617227270417f,-0.7423329738648003f},
{0.21886739120194518f,0.07076555346874121f,-0.9731851321874566f},
{0.593316518597252f,0.5203396848914063f,-0.6141841100897587f},
{0.33807554490964714f,-0.012380089963464895f,-0.9410375440472827f},
{-0.10323743865153279f,-0.3390256995695545f,-0.9350955065083166f},
{0.3878207444164577f,0.10443626217812056f,-0.9157991795926265f},
{0.1875022180785013f,0.69588609969425f,-0.6932427096392477f},
{-0.03269882854686389f,0.1247780107653463f,-0.9916457203261182f},
{0.04451784196490722f,0.20823992153655632f,-0.9770641211431501f},
{0.22284033210071372f,0.586610328909201f,-0.7786080582721212f},
{0.33106889705158576f,0.8825457786227535f,-0.3339256414835556f},
{0.23375577142805412f,0.9380792776663646f,0.2556667912284017f},
{0.5227839166674592f,0.7518139625806967f,0.4018367107949966f},
{0.7433189028498226f,0.4155335161697867f,-0.5242221910656868f},
{0.38189858521812853f,0.17841994492797833f,-0.906818501057565f},
{-0.1246666343674444f,-0.21588086977428092f,-0.9684284590722196f},
{-0.6078351754880627f,0.06437061058381663f,0.791449824014424f},
{-0.7000017761615753f,-0.27367315514973506f,0.6596214956480942f},
{-0.8606277025542634f,-0.08944326011140565f,0.5013181233676015f},
{-0.7130645669397397f,0.15761590427743116f,0.6831516303821935f},
{-0.9521480140444888f,-0.12137031294977353f,0.2805056264776343f},
{-0.9887481457872259f,-0.13155356407479615f,0.07120929701619857f},
{-0.9555813780934281f,-0.10054018714049764f,0.2770485528040502f},
{-0.8637016371462751f,0.08511718084924298f,0.4967640763130135f},
{-0.5152990691255196f,0.07025603589703189f,0.8541258448135193f},
{-0.4241624827680943f,-0.2928956052884734f,0.8569121032023674f},
{-0.47782070499586116f,-0.0025152697536914245f,0.8784537821054244f},
{-0.499763408661783f,0.321258783222588f,0.8043813334265645f},
{-0.6246578808714849f,0.1866728053756982f,0.7582583963256275f},
{-0.8736612150471452f,-0.07218077637768322f,0.48115072154560967f},
{-0.957659302387543f,-0.20826662933023438f,0.1987804609563711f},
{-0.9845288973281024f,-0.14334585596427327f,0.10077110649278688f},
{-0.9917319735981992f,-0.12472660399360493f,0.030182226545486062f},
{-0.9969641265783414f,-0.07111001730420088f,0.03171585967431936f},
{-0.9867062262036592f,-0.052428213825854136f,0.15382491854691108f},
{-0.9506337755369466f,0.13402109129000925f,0.2798817105453749f},
{-0.7423729194563815f,0.334433391187493f,0.5805486674833059f},
{-0.49452413170485154f,0.3798472933145665f,0.7817684548017785f},
{-0.35863947798311474f,0.10148872394071776f,0.9279427588730266f},
{-0.23244853715065164f,-0.6285649900986692f,0.7422086841305363f},
{0.08041115075026563f,0.2204349204291388f,0.9720815257427833f},
{0.00015831114494596686f,0.41992079886361466f,0.9075607404572572f},
{-0.08393965307232276f,0.3307410951577376f,0.9399810969460813f},
{-0.29796946693453696f,0.40662506945968957f,0.8636378000421534f},
{-0.33084263122236074f,0.357054221257785f,0.8735304439158728f},
{-0.40872997050398474f,0.14395520434764952f,0.9012306643435066f},
{-0.5942767940919376f,-0.1395888479205078f,0.7920543198165352f},
{-0.8419553416911901f,-0.2731953524008076f,0.46526927904630666f},
{-0.9701767527473474f,-0.1325878041979036f,0.202922503943231f},
{-0.9927291390868139f,-0.03827888833453434f,0.11412091445403721f},
{-0.9896613889431986f,-0.12916116008777212f,0.06235166364901349f},
{-0.9970609065246f,-0.06706620384356064f,-0.03703610376857702f},
{-0.9940233254431459f,-0.10659133665835187f,-0.023577858773347105f},
{-0.9958346762520598f,-0.08713274869448792f,-0.026854825988982544f},
{-0.9995446724434889f,0.02085568439687055f,-0.021805692334261398f},
{-0.9776151929279984f,0.11313465959105216f,0.17739527433268673f},
{0.492171730592074f,0.2694730990235135f,-0.8277386281361204f},
{-0.28433304999104936f,0.0006207372976015725f,-0.9587253680632399f},
{-0.3944599416941713f,-0.062351668967712714f,-0.91679530091268f},
{-0.377196950541862f,-0.0037197256288077954f,-0.9261255984709452f},
{-0.523895556878883f,-0.1158188387703627f,-0.8438716976344507f},
{-0.6148867666420851f,-0.09672315922910625f,-0.7826614176495369f},
{-0.0200433638527366f,0.11621095262994258f,-0.9930222948425217f},
{0.4107014657510234f,0.23971261915496261f,-0.8796943595634956f},
{0.4660932301392727f,0.33690177966581114f,-0.8180796365124536f},
{0.02375405116645007f,0.17524665274081686f,-0.9842379568764462f},
{-0.3664212303114389f,-0.04487030590899314f,-0.9293665249107507f},
{-0.564371801175505f,-0.2556351937689361f,-0.7849427480680579f},
{-0.6919312717869637f,-0.2690300703631714f,-0.6699656232700767f},
{-0.7375511761270597f,-0.2068035380329049f,-0.6428456729656534f},
{-0.61660593907677f,-0.05698581584864053f,-0.7852068088645942f},
{-0.6951391320752174f,-0.05611525345581001f,-0.7166817043760106f},
{-0.5619330638739669f,0.0004618655708102931f,-0.827182578639934f},
{-0.2714465749363088f,0.04672811229534088f,-0.961318490655756f},
{-0.03830467485517077f,0.16089225318965766f,-0.986228388735487f},
{-0.34366954297564506f,0.13183184013229432f,-0.9297911653474905f},
{0.15101524433384494f,0.3288807547556846f,-0.932218775358081f},
{0.6433077472382797f,0.44835789205693755f,-0.6205887067724237f},
{0.7139314109636741f,0.39157727027797196f,-0.5804904666237592f},
{0.27773605396044637f,0.33701799808194804f,-0.8996007743990198f},
{-0.21825714196128265f,0.04529527092968763f,-0.9748395552162924f},
{-0.33089356258474234f,-0.13789891263757004f,-0.933538076423963f},
{-0.4903775555747784f,-0.42025564484037964f,-0.7634887333604221f},
{-0.6107057214155136f,-0.33129166551592987f,-0.719224828680183f},
{-0.17307215209728538f,0.12925261780375263f,-0.976391207948582f},
{-0.6533288271329697f,-0.15349769389418041f,-0.7413500533528183f},
{-0.0499122041189858f,0.21699054730020748f,-0.974896853140034f},
{0.3581202611802038f,0.32979565644442566f,-0.8734899561658468f},
{0.358529687193627f,0.2744498070819529f,-0.8922632833382302f},
{-0.5144677682735612f,0.0615438070833183f,-0.8552983545040366f},
{-0.6650259070920869f,0.043434453497816446f,-0.7455561623014682f},
{-0.4858064878230021f,0.07687030982278223f,-0.8706796264165304f},
{-0.5460663779669017f,0.06738126038019276f,-0.8350277100813395f},
{-0.5070506098504753f,0.08981576554002248f,-0.8572238956717905f},
{-0.36657443352729063f,0.12188942122854837f,-0.9223698573114342f},
{-0.4211115810684196f,0.08800806613562277f,-0.9027289829096681f},
{-0.3184217391692502f,0.1672394406982543f,-0.9330801495580994f},
{0.1353186012929249f,0.41695510736193625f,-0.8987977050420872f},
{0.576594575338698f,0.5201587900039119f,-0.6300583535448546f},
{0.6424067090880913f,0.5759714533753159f,-0.5055398154600037f},
{-0.07919179463279218f,0.1797146911250702f,-0.9805260269144609f},
{-0.046066807186618576f,0.21123247746335366f,-0.9763496759564806f},
{-0.14376712686374607f,-0.00821843855261986f,-0.9895774201653453f},
{-0.22320585422726866f,-0.30691648715262343f,-0.925192637536945f},
{-0.35311759997400105f,-0.4686396003340466f,-0.8097437159912675f},
{-0.4312591408572123f,-0.2769787144214782f,-0.8586607858662957f},
{0.024833289281831837f,0.24780075788358022f,-0.9684926908014165f},
{0.5881897989250224f,0.587949853999329f,-0.5552906712909099f},
{0.6067473157236424f,0.4779530534162006f,-0.6351524018629585f},
{-0.09585587953550448f,-0.7833970027958869f,0.6140853249906694f},
{-0.7214381068403282f,-0.25307440230684375f,0.64457769500323f},
{-0.5892639993673852f,0.47732730660972333f,0.651863928603402f},
{-0.06163351544385867f,-0.5241823860205433f,0.8493727897453753f},
{-0.20116288738067664f,0.3062016143215361f,0.9304698082837264f},
{-0.5128580972534807f,0.6702925267357891f,0.5363622849191496f},
{-0.6057966912403604f,0.6226836152943247f,0.4952529496390919f},
{-0.6973337748352485f,0.5987149344706852f,0.39403811200921424f},
{-0.7906995091828473f,0.5453248424078913f,0.2782356958242654f},
{-0.8525692112298503f,0.18951025977609448f,0.4870437367449746f},
{-0.11957321438568898f,-0.9111849502483783f,0.39426416631788164f},
{-0.22165439703340525f,-0.8856943693161378f,0.40793971667079276f},
{-0.41260255231600285f,-0.5512694731670534f,0.7251628105304625f},
{-0.170832613889884f,-0.6341743664490007f,0.7540816208942892f},
{-0.36371638391096595f,0.12690932724410922f,0.9228241515766579f},
{0.14211088783227796f,-0.6603721519535262f,0.737369050397283f},
{0.09557481370083665f,-0.6145947649872483f,0.783031755317956f},
{-0.02481193263782801f,0.6753605326710527f,0.7370702265788843f},
{-0.03644089496633682f,0.8037734009592777f,0.5938184748594543f},
{-0.33843320057335746f,0.7578476503180616f,0.557790200395334f},
{-0.4518371547566989f,0.6900615592115414f,0.5653832594620284f},
{-0.5577477803116164f,0.6365308917295923f,0.532677986621744f},
{-0.6155130485110176f,0.7029028335354255f,0.3564706070920064f},
{-0.49686551758325037f,0.8283252190470994f,-0.2588474240306504f},
{-0.5411123068472442f,0.8271762331062856f,0.15158149874753818f},
{-0.691666576451764f,0.6683004552552839f,0.2738098766025005f},
{-0.8212478605404768f,0.5705019648107928f,-0.008914017316260837f},
{-0.916275019842417f,0.21460116442339536f,0.33821062703720756f},
{-0.29562561315517266f,-0.14726375666663408f,0.943884994487707f},
{-0.3765780548624213f,-0.4193632044410765f,0.8260287351883997f},
{0.17275189013823045f,-0.6267647459199518f,0.7598175687134163f},
{-0.43515448724948835f,-0.6560608067187615f,0.6166237021994555f},
{-0.6050360408441392f,-0.01185991360774355f,0.7961097485453033f},
{-0.3941354105935897f,0.8424807219688578f,0.36726490606516504f},
{-0.07879538816205098f,0.47633069456906185f,0.8757284717398122f},
{-0.14810141174073743f,0.5280642736800442f,0.8361902263858195f},
{-0.5045879001733509f,0.14307182235502028f,0.8514232229899897f},
{0.037586338130364216f,-0.753366543654221f,0.6565257939246885f},
{0.16732214439261847f,-0.87280117276903f,0.4584990870316557f},
{-0.7108008755343632f,0.12661833691174737f,0.6919031088940747f},
{-0.7317599014869147f,0.10662455330001167f,0.6731705959186228f},
{-0.3381441558358657f,0.36775531765090513f,0.866264714861186f},
{-0.6314204237343968f,-0.04848269801132076f,0.7739235598459436f},
{-0.5009938643887545f,-0.04390835980548534f,0.8643362793404048f},
{-0.24687883915824513f,0.0029165267246664055f,0.9690419664017351f},
{0.029033396771912558f,0.2549409539841938f,0.9665206525747465f},
{-0.40979318016045857f,-0.6099592728257338f,0.6782471783854909f},
{-0.023053895339925874f,-0.934047671517376f,0.35640351463281555f},
{0.4061932464909564f,-0.9121085440699223f,0.055362896779195536f},
{0.20731605000167483f,-0.9715287686080668f,0.11468176480415913f},
{0.003563846179368516f,-0.9967823104583222f,0.08007699143810895f},
{-0.2758938125965414f,-0.29327555209893275f,0.9153535135192363f},
{-0.4072565132523158f,0.5081488802278408f,0.7588984437569744f},
{-0.7329017740527898f,0.3259388646932426f,0.5971757246177658f},
{-0.8395703546653829f,0.07150686842366215f,0.5385242681024546f},
{-0.793289291934079f,0.018995179242053305f,0.6085485046142909f},
{-0.4277480146520467f,-0.029271215329353766f,0.9034239491591836f},
{-0.6841642673929947f,-0.19588856368314275f,0.7025289501798215f},
{-0.6485875300664359f,-0.3221361604760274f,0.6896104044720347f},
{-0.510727396545199f,-0.4176954792328138f,0.7514572596273409f},
{-0.11037562889429431f,0.18344217937939883f,0.9768143054699423f},
{-0.19207401538448096f,-0.12009018308739058f,0.9740050926664188f},
{-0.5487645145524458f,-0.46851505766510204f,0.6923518962991901f},
{-0.4997552592037733f,-0.4722109567496302f,0.7261277389163481f},
{-0.070057144258995f,-0.8405091913239358f,0.5372488211604172f},
{-0.4186355484211621f,-0.705932549851339f,0.5713173484662438f},
{-0.4239620824856565f,-0.9046872845239894f,0.04239186048093999f},
{-0.5680413691923469f,-0.8215053033542205f,0.0495786188489949f},
{-0.5188708555007288f,-0.7058970415362252f,0.48216428949305906f},
{-0.503759903374084f,-0.14379769041020693f,0.8517911621901368f},
{0.28064222706208125f,0.4896602107681951f,0.8255136694083763f},
{-0.02448499488048712f,0.7040057037550622f,0.7097721142071178f},
{-0.5271020928386775f,0.2928066918139773f,0.7977641411808636f},
{0.3067032678569826f,0.106474163482795f,0.9458310409351594f},
{0.3598939884568823f,-0.30009583481288105f,0.8834131575885416f},
{0.7538569628463204f,-0.32169864114404717f,0.5728958577736404f},
{0.39751215712797033f,-0.08156781936148759f,0.9139643186580533f},
{-0.4800354874311273f,-0.32187547051004284f,0.8160650171957493f},
{-0.23332768263541465f,-0.875460341540742f,0.42323443019838825f},
{-0.5002891186194466f,-0.03850754982129225f,0.8650017146790739f},
{-0.5469792958941437f,-0.004558294648161561f,0.8371337239730863f},
{-0.4920788775934763f,0.23435302002400601f,0.8384134065197029f},
{-0.3420287133441571f,0.03421337389721776f,0.9390664536094928f},
{-0.40023102340433137f,-0.3970257481876633f,0.8259453269924999f},
{-0.026751020373322353f,-0.8505655211815302f,0.5251882301481806f},
{0.003932655100640323f,-0.9994278810700657f,0.03359233191753343f},
{-0.21245175485873202f,-0.9412097520910233f,0.2626565331877345f},
{-0.5820186287719905f,-0.23267307478886323f,0.7791774868607716f},
{-0.3525773274871818f,-0.10540316308162581f,0.9298276191608769f},
{-0.3472606759592281f,0.2744783168679628f,0.8967004385532942f},
{-0.196688331371264f,0.5851263104029456f,0.7867279715229551f},
{-0.29979719015659206f,0.765019016312723f,0.5699715338980764f},
{-0.43937880149877473f,0.3459896413254021f,0.8289978509556101f},
{0.10899854241851048f,0.4186890994742461f,0.9015646153948619f},
{0.1713442605427831f,0.004975897031287547f,0.9851986524695315f},
{0.42041087241744624f,0.42905873811071565f,0.7994768899749649f},
{0.5552510905643431f,0.3532473799310503f,0.7529359302085111f},
{0.3309027639811158f,-0.8908902477167007f,0.3111557926713458f},
{0.15097762471494808f,-0.8660002245551679f,0.47670679448255304f},
{0.1634772133006628f,-0.9864877442161292f,-0.010822718827657923f},
{0.29246680494873784f,-0.8912699629879627f,0.34655594220632335f},
{0.48857370452961923f,0.23456911306488423f,0.8404005392895448f},
{0.6064746604144567f,0.3525024350718629f,0.7126924438659193f},
{0.509088267127052f,0.4047067828993396f,0.7596325138834186f},
{0.3314938938398471f,0.46809585087836186f,0.8191447202645932f},
{0.2458143188787792f,0.341827413638955f,0.9070442877385121f},
{-0.15384535610677622f,-0.9800922596562108f,0.12550206757803498f},
{-0.018673476232424976f,-0.9962516371025092f,0.08446287264808967f},
{0.17540952037739002f,-0.9395087625277123f,0.2942019464494086f},
{0.3829926249634418f,-0.905299473410969f,0.1837104043472627f},
{0.2549988203076835f,-0.9644913981488701f,0.06878913096214759f},
{-0.06596441591809604f,-0.16749371243407363f,0.9836638410186869f},
{0.2537862801054385f,0.301405867327771f,0.9191012061631939f},
{0.2687509471972084f,0.3522153068225463f,0.8965028198619919f},
{0.491249449066836f,0.24446407795609995f,0.8360091467086972f},
{0.6787198633996304f,0.26088769584233573f,0.6864961450619107f},
{0.6111052923470089f,0.3324148910492494f,0.7183666625576332f},
{0.5098338980487973f,0.32334382768228864f,0.7971939321771931f},
{0.524813287481639f,0.14271513797146315f,0.8391682803088429f},
{0.4272186501623236f,0.2236965574156774f,0.8760388548197258f},
{0.5091619090836436f,0.4326731464519028f,0.7440081307873656f},
{0.1963901790861931f,0.535491249063752f,0.8213890793860336f},
{-0.4615677265316441f,0.44920903105986504f,0.7649617508337699f},
{-0.4326463057820374f,0.7279976529439104f,0.5318238349315622f},
{0.2832361965255091f,0.6741700275268319f,0.6821085184647924f},
{0.4013920374926908f,0.6159289456455338f,0.6778760699076545f},
{0.4279918173845627f,0.5258893963852719f,0.7350260859462021f},
{0.4093521014735863f,0.5072826103459617f,0.7583503215926963f},
{0.3659593258949697f,0.32710284058265116f,0.8712505400131813f},
{0.3179649763844075f,0.13910615979452978f,0.9378420709800143f},
{0.0967587219245563f,0.20470842496090352f,0.9740288550559231f},
{-0.9615515732876002f,0.19293691181470296f,0.1954326481618318f},
{-0.858640584914943f,0.4053521362569895f,0.3137291691392742f},
{-0.8560196327620317f,0.5108298967099856f,0.0792666698759427f},
{-0.6848849188160923f,0.7157282092687867f,0.13662275957969272f},
{-0.30921508001107173f,0.8382122058385512f,0.4492063359715854f},
{0.16813613106682307f,0.7917373779696505f,0.5872666904870587f},
{-0.04430834529003833f,0.8307099812496921f,0.5549393638856367f},
{0.2609768037550153f,0.6266012020212727f,0.7343446340290862f},
{-0.25073683837265387f,0.46190747614194105f,0.8507482126734489f},
{0.03263814864535449f,0.6274093509640675f,0.7780053069072546f},
{0.1796687294438409f,0.743934268221134f,0.6436466050763585f},
{0.03889208444763992f,0.6962755332634305f,0.7167201598574182f},
{-0.5312797087736755f,0.3125315046523409f,0.7874426516547745f},
{0.1186802276159625f,-0.006162135117728776f,0.9929134059241089f},
{0.005598874310758925f,0.05536003295055191f,0.9984507596061841f},
{-0.9447896638013401f,0.10627314133382337f,0.309965337747936f},
{-0.9679484409129351f,0.16995841294394465f,0.18490525574951538f},
{-0.9560887999566546f,0.24916780221594537f,0.1543036387656483f},
{-0.9538353165997625f,0.3002923439277751f,0.004764135324852287f},
{-0.8886768924477033f,0.45148162862939306f,-0.08011067244533557f},
{-0.7321498829905216f,0.6807007881199727f,0.024555771008324977f},
{-0.54964703501946f,0.8162007158988751f,0.17805765431589973f},
{-0.34011855921794354f,0.8665541223936404f,0.36524419042347267f},
{-0.6034863309593465f,0.7025182127678689f,0.3771901497582691f},
{-0.71219223444593f,0.19012870925828965f,0.6757464725107266f},
{-0.03844414522283968f,0.5764275401104995f,0.8162434310303781f},
{-0.868231986553172f,-0.4951203145121651f,0.03207945889984907f},
{-0.9085554398516338f,-0.35947251556120974f,-0.21285329048924778f},
{-0.9824293517156683f,0.042635150998373214f,0.1816997875256815f},
{-0.562465234200961f,0.6929982118443893f,0.4509837454894991f},
{0.20915969556759698f,0.3933445909708361f,0.8952833375552433f},
{0.014828264655894662f,0.29549981337589415f,0.9552277125702051f},
{-0.14313242302820037f,0.047948083543546606f,0.9885413955735881f},
{0.10195944119944865f,0.2852089755113964f,0.9530268163268207f},
{0.3588906287981068f,0.41633059652965776f,0.8353839542115703f},
{0.31825370285333476f,0.37353531113103144f,0.8713127750460135f},
{0.05442371937192663f,0.20221956417256484f,0.9778268285517552f},
{0.2869686648871559f,0.40948922138868105f,0.8660066760362619f},
{0.06304906010257427f,0.3574074735180856f,0.9318179617788019f},
{-0.2883933296433369f,0.0792656974135628f,0.9542254642540049f},
{-0.10929140574609303f,0.07412244067104479f,0.9912422773565553f},
{0.46542673695075837f,0.2733065324800264f,0.8418322230914626f},
{0.40106046596080297f,0.27528581471088626f,0.8737094613555854f},
{0.07221886288785831f,0.14332535116191186f,0.9870371216714696f},
{-0.08926653990055866f,0.06350074368648986f,0.9939814587835352f},
{-0.09423250482564365f,0.01994199047321206f,0.995350466946317f},
{0.2899182611695951f,0.05961329484205523f,0.9551929945924398f},
{0.16501363574158953f,0.05594815822827812f,0.9847031550727384f},
{0.27011985162560986f,-0.015570930633959382f,0.9627007904208612f},
{0.6604176315239987f,0.04149943145680549f,0.7497508580595248f},
{0.5887322866892709f,-0.03747620586284056f,0.8074588711530439f},
{0.7154377423763134f,-0.1289570578906057f,0.6866723483610526f},
{0.2642680414269465f,-0.2798873948753561f,0.9229439032087768f},
{-0.7084321037945542f,-0.31083552427751665f,0.6336444043470623f},
{-0.03166703824046852f,-0.5557026551921839f,0.8307778028458833f},
{-0.4605739812012918f,0.008253396107390827f,0.8875829478381648f},
{-0.41655588042127684f,0.2533775221177961f,0.8730870688378684f},
{-0.11391049065149052f,0.2653373068883413f,0.9574030048484176f},
{-0.18198970555502356f,0.1872174809672311f,0.9653130900864654f},
{-0.35190538518225317f,0.08511313864683845f,-0.9321579015968346f},
{-0.3954086677366175f,0.0038385463409365815f,-0.9184972787334439f},
{-0.521254884114164f,-0.07818439048890019f,-0.8498120656186335f},
{-0.6520614363366353f,-0.054345198885942324f,-0.7562158968182642f},
{-0.46233846181291305f,-0.03751680361392292f,-0.8859094966050787f},
{-0.3482357048785489f,-0.021003699678791427f,-0.937171669678263f},
{-0.3866967526732891f,-0.042248570374803576f,-0.921238666021579f},
{-0.5363158707844444f,-0.2103613590799508f,-0.8173820314582155f},
{-0.5686624678423524f,-0.0425165020042422f,-0.8214714509493125f},
{-0.45341461960943524f,0.24428300110253243f,-0.8571703436871642f},
{-0.7615390196525201f,0.09985187003265339f,0.6403810784194522f},
{-0.89874140302892f,0.17790402281443723f,0.400766826406638f},
{-0.6515481565585883f,-0.008226288242636165f,-0.7585626723395071f},
{-0.9563245672489291f,0.027950506955380778f,-0.29096750890277384f},
{-0.5464849691496726f,-0.03321730674844642f,-0.8368098882218475f},
{-0.6962362644150014f,-0.01363556364617538f,-0.7176831721013774f},
{-0.8005347724265545f,0.06003453668054363f,-0.5962716935605086f},
{-0.7437096716580076f,0.21727233527967288f,0.6322093455529236f},
{-0.8452242143543436f,0.19309544547967253f,0.49830731120874555f},
{-0.9128088359626423f,0.13936942240961636f,0.38387002108231333f},
{-0.9419170118697091f,0.07746256675041499f,0.3267902897928208f},
{-0.8451619851973561f,-0.002985411560062632f,-0.5345019233782802f},
{-0.8639238847464279f,0.0038382362795671464f,-0.5036077732788713f},
{-0.6182224599582122f,-0.0008120516788956682f,-0.7860027548140576f},
{-0.548259214272228f,0.005941000628672545f,-0.8362873540100492f},
{-0.501321993725419f,-0.015947514337687617f,-0.8651138279981543f},
{-0.5186092312444295f,-0.13093730815058877f,-0.8449259651604628f},
{-0.6113517816374547f,-0.09917829085783868f,-0.7851195232009123f},
{-0.7714991486918238f,-0.06167450846424482f,-0.633234015647837f},
{-0.8247574851415983f,-0.024143919839013414f,-0.5649709389320068f},
{-0.888334473622904f,0.1049456179552903f,-0.44704393547513926f},
{-0.7808645078183429f,0.26674128348678694f,0.5648891113426056f},
{-0.7166822585202445f,0.24931361027584717f,0.6513134913799531f},
{-0.94297121627529f,0.24078169200454266f,0.22984660552579336f},
{-0.9764764014652964f,0.17784092368266927f,-0.12192802485515991f},
{-0.9304245785256603f,0.11342042076010857f,-0.3484909063805645f},
{-0.9714153846755886f,0.04782831462379076f,-0.23251796217889403f},
{0.1686673316154723f,0.2460057575759042f,-0.954480224250467f},
{0.8617054005555698f,0.20583460985052812f,-0.4637843421689073f},
{-0.24727490071687894f,0.11680517310100588f,-0.9618792413875566f},
{0.09089584582906196f,0.13864929808885376f,-0.9861614053239396f},
{0.7568720125280762f,0.1525104512585937f,-0.6355197234615144f},
{0.5555303922774698f,0.21439549391314594f,-0.8033807039292011f},
{0.6735268184070454f,0.27645770595263114f,-0.6855164197201198f},
{0.8931861720215977f,0.24562447456747566f,-0.3766790140197043f},
{0.870664310980915f,0.3287041291521572f,-0.3659197358198252f},
{-0.03207239230543931f,0.25572414588072145f,-0.9662176374220156f},
{0.8570809042508408f,0.32122663598063567f,-0.40277260570342327f},
{0.9418999033282025f,0.0785254115674458f,-0.3265858720895412f},
{0.09142322314339606f,0.12816265809392027f,-0.9875303171753127f},
{-0.24877417198648388f,0.09432711917383434f,-0.9639573672838466f},
{-0.37778095917909577f,0.11921432436564341f,-0.9181881570504848f},
{-0.472592867362503f,0.1276049651373312f,-0.871993666599929f},
{-0.4320648691571299f,0.2349897100534307f,-0.8706892585815199f},
{-0.24927618327389045f,0.24289450414772032f,-0.9374772766884725f},
{-0.07099338568511275f,0.49563526276528397f,-0.8656244136417092f},
{0.4616645751288835f,0.6183234910813316f,-0.6360360685118904f},
{0.659364066900359f,0.6143028076807988f,-0.4334409853210774f},
{0.5774710106051887f,0.6758355857012598f,-0.4580103634312842f},
{-0.050483316227049796f,-0.23792368568336242f,-0.969971007078853f},
{-0.34780594268421144f,-0.2867856172154439f,-0.8926281622220441f},
{-0.6240496724676309f,-0.37617581788329474f,-0.6848749961364314f},
{-0.6512131902616948f,-0.39133803839186415f,-0.6502122119253019f},
{0.41910445515841327f,-0.35936773911359854f,-0.8337903116196241f},
{0.9287550100546136f,0.08936706643525548f,-0.3597605575034754f},
{0.9670339210588578f,0.04368749242151322f,-0.25087207602172673f},
{0.9917965822182643f,-0.06321925105004819f,-0.11109845092007702f},
{0.9140581151622971f,-0.07912982496896372f,-0.3977891814847785f},
{0.8364366461229974f,-0.2226590336633534f,-0.500796058042207f},
{-0.17324892515291987f,-0.9822009266395975f,-0.07256824127449979f},
{-0.4190654587155393f,-0.8710498147305396f,-0.2562349733534194f},
{-0.16757004067693385f,-0.7789548047695471f,-0.6042761732800388f},
{0.3991388958097435f,-0.8905386091632378f,-0.21824098478834056f},
{0.20126421187719576f,-0.9547480076007415f,0.21897250740644508f},
{0.3439820086687044f,-0.9197864448176235f,0.18886310820803523f},
{0.38384308969779757f,-0.8855280835463374f,-0.26173363509873787f},
{0.6168898956433548f,-0.5461661386366137f,-0.5667004549670857f},
{0.5451254111492424f,-0.4965111586720979f,-0.675510884763125f},
{0.3729614495632129f,-0.4756534914661403f,-0.7966514377039543f},
{0.5319191057464291f,-0.07941188058637838f,-0.843063353588361f},
{0.6401149984279274f,0.1263478112972519f,-0.7578185926513076f},
{0.32800138403040996f,-0.00530534326936672f,-0.9446623446538607f},
{-0.1886854212157121f,-0.17587934594242774f,-0.966159545567663f},
{-0.4975557292967799f,-0.22750848448064165f,-0.8370652219112147f},
{-0.7296058301098645f,-0.22029910986085138f,-0.6474130326647838f},
{0.47617430866498933f,-0.30478582155133727f,0.8248415791827518f},
{0.47291085506968283f,-0.2347267898517277f,0.8492694844883832f},
{0.4519069528821684f,-0.2067021136754011f,0.8677870373189929f},
{-0.12344474246476232f,-0.24709943471900966f,0.9610948261848851f},
{-0.37114230400888887f,-0.14799474825754577f,0.9167065750081425f},
{0.23256104318610357f,-0.16459689848254055f,0.9585526705414364f},
{-0.009613379026832581f,-0.3480015617773554f,0.9374446628704054f},
{-0.07586071589527392f,-0.2639134533122738f,0.9615585478506479f},
{-0.28255401528499224f,-0.1820101450016353f,0.9418256396822143f},
{-0.3074603282299988f,-0.1367135576154899f,0.9416886692154778f},
{-0.3258348987931287f,0.05188416118139903f,0.9440019346097624f},
{-0.38813932102996485f,0.6507985503207206f,0.6525405078390507f},
{-0.1546860359055496f,-0.25427044110359254f,0.9546825509439312f},
{-0.05091178652451142f,-0.209728048017199f,0.9764333750275941f},
{-0.09472421968483408f,-0.43221907541753596f,0.8967797907236256f},
{-0.05707673810092117f,-0.06541326860478218f,0.9962245481106142f},
{-0.010065269644640206f,0.6047169800444173f,0.7963768356707397f},
{-0.21531530026621792f,0.7951272189833993f,0.5669321186023896f},
{-0.40883735385830816f,0.6009163376216669f,0.6868417381533386f},
{-0.6673041829046255f,0.6307087440902207f,0.3961206982803683f},
{-0.7441727133708118f,0.38869075362807826f,0.5432554378175704f},
{-0.10857039497754072f,-0.13498588302618664f,0.9848813536249234f},
{0.14311169155274286f,-0.11583872481761892f,0.9829040815733447f},
{-0.02907756866218313f,-0.24271252636705654f,0.9696623765750721f},
{-0.08906016077070601f,-0.4488091499637492f,0.8891786292260475f},
{-0.023843655147694924f,-0.3043301411508881f,0.9522681582917063f},
{-0.0062462439028999235f,-0.3408408758420438f,0.9401002509266414f},
{-0.1934257845009349f,0.5454454153588468f,0.8155217745432755f},
{-0.27485923301205534f,0.3917189461570521f,0.8780709932856416f},
{0.09719812291762057f,0.5527743010052419f,0.8276430976269044f},
{0.019188913331795485f,0.3892431278818044f,0.9209351622138956f},
{0.08092676445498077f,0.35422250829187857f,0.9316529790722822f},
{0.04411166236658735f,0.3636480825393619f,0.9304913934629925f},
{-0.46313770750706845f,0.29706716110649684f,0.8350177038106581f},
{-0.8474403990053188f,0.3635210144318242f,0.38690727855671514f},
{-0.8248668563569175f,0.10716022523745568f,0.5550777922155724f},
{-0.7210306730148298f,-0.36109600702599065f,0.5913750436750502f},
{-0.15458374818635792f,-0.2234344547615215f,0.9623829327362773f},
{0.11722699941895152f,-0.16667884174730963f,0.9790178723195019f},
{0.16303480741858795f,-0.08392114693622241f,0.983044705324683f},
{0.12242823824982801f,0.07847677335172783f,0.9893698613376823f},
{-0.0720911173246191f,-0.027516466850935964f,0.997018412495441f},
{-0.14269850224391914f,-0.33000707665144374f,0.9331304661285637f},
{-0.11284467383611756f,-0.599098933579528f,0.7926831317561215f},
{-0.0905520078703688f,-0.8394848564480017f,0.5357849472177456f},
{-0.05771610841709671f,-0.563869565762818f,0.8238446234792318f},
{-0.28599100189510707f,0.11293245243057069f,0.9515542065605352f},
{-0.47344287003758134f,0.6329054225794699f,0.6126031136715517f},
{-0.38935362207613017f,0.28780651866964463f,0.8749692364806076f},
{-0.5390224309247377f,-0.12153128791096897f,0.833477633184411f},
{-0.5139549867531863f,-0.25126312167520576f,0.8201933401811812f},
{0.1087800482862161f,0.1431429128000594f,0.9837057525550834f},
{0.3849561256782499f,0.5669278954454688f,-0.7282867173500853f},
{0.5618379157579448f,0.40390324849248016f,-0.721942049110585f},
{0.6922934351172236f,0.2219879613099977f,-0.6866230004354831f},
{0.3716277446923095f,0.5911611886836818f,-0.7158360624954601f},
{0.20211847772925f,0.6948797204239099f,-0.6901378812266427f},
{0.48419404318479253f,0.3693636067744689f,-0.7931750465911788f},
{0.11319627288146833f,0.737219766275087f,-0.6661033103198408f},
{0.31582790887272716f,0.6972169974623592f,-0.643538025626033f},
{0.5052843100756568f,0.5949109057260054f,-0.625115013609201f},
{0.15117499866230366f,0.8700710548247125f,-0.4691721212259576f},
{0.23477778028706336f,0.9293393293799401f,-0.2849698312999509f},
{0.6604432647337602f,0.6594336420222735f,0.3591127480848492f},
{-0.7555110523259856f,-0.43178511046775486f,0.49271154663923833f},
{-0.34328077448938327f,-0.5993345243714927f,0.7231572704207334f},
{0.46714434325746407f,-0.8274328716321878f,-0.31165847574719324f},
{-0.3922505281176236f,-0.9170463990040365f,0.07187089303170488f},
{-0.1827710669181611f,0.024400464083218568f,-0.9828526616182716f},
{-0.29445634376149216f,0.06457908292536162f,-0.9534804684245678f},
{-0.22769024636623733f,-0.018551250611708144f,-0.9735568821647884f},
{-0.11154153942067906f,-0.00262525689787673f,-0.9937563046390626f},
{-0.13516291176134848f,-0.04751528587953074f,-0.9896834266026587f},
{-0.2667338832135609f,-0.046074782957202014f,-0.9626682449947443f},
{-0.34841887903332996f,-0.022219912674815857f,-0.9370755360235808f},
{-0.47033244695793847f,-0.008551755053204305f,-0.8824478776812079f},
{-0.12427596065399478f,0.11688381344822814f,-0.9853393627361725f},
{0.013990894993769314f,0.08811918386910955f,-0.9960116787927314f},
{-0.008453347048616045f,-0.02007722527916141f,-0.9997626948175079f},
{-0.031210875160177814f,-0.06374287221592383f,-0.9974781839786774f},
{-0.07121142707620302f,-0.12876515451247939f,-0.9891149921203033f},
{-0.17663585493982645f,-0.13476471012548177f,-0.9750067936452912f},
{-0.3353307044635261f,-0.4199000411683629f,-0.8433488448268619f},
{-0.39763623789871033f,-0.27631527746790396f,-0.8749487354968835f},
{-0.5754441453585126f,-0.0297510430556344f,-0.8172997681449033f},
{-0.5852083732774741f,0.03220633866607674f,-0.8102431188203072f},
{0.4916614981921321f,-0.5121063372083641f,0.7042840837236785f},
{0.8998090493794008f,-0.10070485440273937f,0.42450230500512276f},
{0.4932773147155264f,-0.018237049475547728f,0.8696809189659538f},
{-0.06032862728781074f,-0.3446201368591548f,0.9368016961986917f},
{-0.3301596741818766f,0.12946978199083822f,0.935003831593947f},
{0.05907333538902893f,-0.257222371992498f,0.9645449664958955f},
{0.9494119146897662f,-0.1387970498735176f,0.28169557183512917f},
{0.9480492390976781f,0.21022169918838426f,-0.23876657520821834f},
{0.8813103267087977f,-0.4724401503463991f,-0.009613135654097993f},
{0.7366624289938062f,-0.4078520036957525f,0.5394304485198301f},
{-0.1725337698891642f,-0.3668626426652267f,0.9141356024488485f},
{-0.6548789131787945f,-0.22201036324914597f,0.7223884050036674f},
{-0.9395345903330892f,0.14394708934000147f,0.3107313776208898f},
{-0.8413634796923435f,-0.10324897531643729f,0.5305159226037398f},
{-0.30835013661051225f,-0.4364816300068853f,0.8452242187247186f},
{0.5163330698414337f,-0.44123372028231145f,0.7339706840698422f},
{0.9475271233889997f,-0.22815762597766054f,0.22391169721657023f},
{0.8874180125751948f,-0.1835826987966899f,-0.42283172026187343f},
{0.7753974646133747f,0.16489597640704465f,-0.6095638513198743f},
{0.6376662259837357f,0.3983092931961277f,-0.6593417104910476f},
{0.8533925054358693f,-0.10481248171396504f,-0.5106227328888222f},
{0.8947324326254843f,-0.22439568133120213f,-0.3861352770830306f},
{0.9367515391869715f,0.05751654436865495f,-0.34523673175768577f},
{0.9661359279759876f,-0.1647289127120338f,0.19860955160990754f},
{0.5226507371449012f,-0.5833703405734991f,0.6217035086768057f},
{0.0662298825261164f,-0.44808866240490136f,0.8915324746102989f},
{-0.6461539520177272f,0.0076027780344870045f,0.7631692263567964f},
{-0.9205580717290446f,0.08966416462277933f,0.38017518877091666f},
{-0.8716191067841413f,0.4180416747268763f,-0.25597126963853634f},
{-0.8064687525993854f,0.3373787079934573f,-0.4855756979848321f},
{-0.8319698170103775f,0.06800695879256519f,-0.5506371556111204f},
{-0.9757241989684549f,-0.1834319712441188f,-0.11964530694040507f},
{-0.8001726300916242f,-0.11057978244695775f,0.5894878062913909f},
{-0.4583926598778968f,0.07367860858322946f,0.8856904831865962f},
{0.2682321899965292f,-0.05815894884369037f,0.9615971240176745f},
{0.7951599000541371f,0.08508970743443987f,0.6004002623538868f},
{0.9747672250445512f,0.21458385045653974f,-0.06150307392473098f},
{0.6765191364538301f,0.2888009055543565f,-0.6774333140337488f},
{0.317438715625643f,-0.05036516896617213f,-0.9469403421424979f},
{-0.30223505076206936f,0.299615834665625f,-0.9049222760593698f},
{-0.03634600006777763f,0.3834668921338406f,-0.9228391576630711f},
{0.5181831433267802f,0.03880232629000815f,-0.8543890269932435f},
{0.3050669391740191f,0.2977726169411928f,-0.9045803619485607f},
{0.3223424243845844f,0.5843062234015922f,-0.7447694936932079f},
{0.7407691885461384f,0.18118017154274327f,-0.646865329678781f},
{0.80961844542715f,-0.30643426775807936f,-0.5006156333632565f},
{0.8233466994861197f,-0.36097603030464354f,-0.4379457934388846f},
{0.7482208180707526f,-0.6633698246451941f,-0.01029966774892422f},
{0.1837326166345787f,-0.8852685905871919f,0.4272491639598348f},
{-0.2660788774097497f,-0.7827106198201416f,0.5626420857144774f},
{-0.7312604420723993f,-0.3090103857415412f,0.6080877793246159f},
{-0.9196203734809411f,0.2655785061637567f,0.2894243005391947f},
{-0.8066008702976121f,0.5910895622371517f,-0.002857525052748907f},
{-0.5087120618397827f,0.8061019289669432f,-0.3023437088058729f},
{-0.5217384538315668f,0.4978832218480259f,-0.692749076647292f},
{-0.5213922885128691f,0.07551206649978795f,-0.8499694166805325f},
{-0.90712211802467f,0.13204744663605525f,-0.3996159841989992f},
{-0.9460750610047954f,-0.005264361206396791f,0.32390471661564474f},
{-0.47419283927640615f,-0.22804135848763907f,0.8503753818156383f},
{0.39870215618732696f,-0.14585151893237033f,0.905408153860289f},
{0.9754882856935568f,-0.11049638038796566f,0.1902975417492394f},
{0.5926542138401055f,0.15678744925485366f,-0.7900497949963173f},
{0.12905764784249119f,0.3579062018978761f,-0.9247958013401661f},
{-0.937396325702398f,0.18371618508274315f,-0.2958656652913399f},
{-0.9268294219359774f,0.2691589780910059f,-0.261802725629103f},
{-0.5358840775884053f,0.3221551411905306f,-0.7804129165971905f},
{-0.9567235552370021f,0.10621151475519897f,-0.2709227804893434f},
{-0.9040116089314344f,0.24567766584830766f,-0.34986496740960893f},
{-0.7575720855122225f,0.3477137937653268f,-0.5524306769885119f},
{-0.8259269155852034f,0.3280671543406394f,-0.4584939174675573f},
{-0.9274338324604494f,0.07978065674362397f,0.36537861625617735f},
{-0.9533057976670721f,0.12273179008808063f,0.27594376933738274f},
{-0.9980526632855032f,0.03239118554803205f,0.05330752674347902f},
{-0.9513775793933448f,0.028637852598920165f,-0.3066929650744902f},
{-0.6634531822548213f,0.12468880662656713f,-0.737755092464968f},
{-0.9678589038491963f,0.09321162509971623f,0.23358239485479682f},
{-0.8596783124979869f,0.2967110360035763f,-0.4158314083066577f},
{-0.47533574688362007f,0.3635799825184569f,-0.801165104111799f},
{-0.612473604734338f,0.3600137129987248f,-0.7037515257223942f},
{-0.980968829630485f,0.13207988453186345f,0.1423202705008882f},
{-0.8890474644422398f,0.015045736123385426f,0.4575677346506522f},
{-0.9086014853320862f,0.10105758926059669f,0.4052538766071994f},
{-0.9368470433541094f,0.2056771469434731f,0.2828683944590778f},
{-0.9749601175333954f,0.1448524825077875f,0.1687321176616916f},
{-0.9991738248655243f,0.006689081881190525f,0.0400864551586355f},
{-0.8384224058174709f,-0.05382248330303187f,-0.5423569025229963f},
{0.6052011567917719f,-0.3611316536772506f,0.7094473120184722f},
{0.8412422185244892f,-0.27218319487213954f,0.46714862538724267f},
{0.7699017734675742f,-0.09734756096685959f,0.6306938334765037f},
{0.3930964340872658f,-0.07645781359185419f,0.916312935764103f},
{0.5365720322734775f,0.25209455377961254f,0.8053190610786313f},
{0.8044637450090963f,0.1512354616800631f,0.5744265993983547f},
{0.9402793426791242f,-0.11061496681498584f,0.3219302515257516f},
{0.8188202383092182f,-0.17141806037993845f,0.5478588010708735f},
{0.3776382127351428f,0.17365636040792484f,0.9095234184846919f},
{0.2776483099473802f,-0.34590145887220103f,0.8962497401580916f},
{0.06601694219597398f,-0.1365273298281574f,0.988434141232023f},
{0.1863040692205779f,0.27482627960056116f,0.943271599186983f},
{0.297191768091059f,0.5442814848103539f,0.784496474352528f},
{0.6607342466369733f,0.5235946178520621f,0.5378465687140008f},
{0.9166983155803197f,0.2344252177209194f,0.3235877245952081f},
{0.9725180949968124f,0.2261535359589899f,-0.0553455786582527f},
{0.9700942561866194f,-0.12860288614407261f,0.20586022391211017f},
{0.6422172737966273f,0.6213695154310338f,0.4488395019717292f},
{0.3464973346300265f,0.6758511157327074f,0.650511234689411f},
{0.3156411855837698f,0.555611121649037f,0.7691988842056201f},
{0.1063197226070828f,-0.43082492383049037f,0.8961506578646278f},
{-0.04278549027056806f,0.06062026596780897f,0.9972434934238976f},
{-0.007039596712714343f,0.27762700387030725f,0.9606631515781787f},
{0.07000610167867408f,0.6218676658821518f,0.7799870203138253f},
{0.3184196461358973f,0.7612114299282086f,0.5649478629938712f},
{0.6026281830623365f,0.7097601195752596f,0.3648011042191353f},
{0.8098940034501637f,0.5431064285988271f,0.22160124185142369f},
{0.7175187757500725f,0.6934246720260072f,-0.06579536968314294f},
{0.7221107596565091f,0.5584820978469022f,-0.40823252831299783f},
{0.7799126928255539f,0.17602837565778803f,-0.6006248434196458f},
{0.967576900345016f,-0.10089355652362052f,-0.23155006406983744f},
{0.8135096889048743f,0.5815019415185998f,0.0075814291524641635f},
{0.5173955301094959f,0.7933284207539871f,0.3208299896311106f},
{0.48875807796200854f,0.7254270550005717f,0.4846350473295145f},
{0.3720219275226312f,0.6678369408377189f,0.6446654216683745f},
{0.4762587453862155f,0.579773041423491f,0.6610906351489962f},
{0.38708191700794153f,0.4195248611874993f,0.8210764156709571f},
{0.6735023570552902f,0.5039797405627205f,-0.5407393051585037f},
{0.763138427275447f,0.461608063626451f,-0.45225848406701646f},
{0.7538871838573357f,0.6567322310445157f,-0.018891551628932714f},
{0.052001136047980366f,0.9979738272596057f,0.03666226881323633f},
{0.2285077830402661f,0.8296303359381019f,0.5094091663694863f},
{0.2666007730414249f,0.9472854441064841f,-0.1776916295093725f},
{0.26714684601175337f,0.6169798601369002f,-0.740248887099078f},
{0.3172379012373607f,0.7661750162170976f,-0.558870251975577f},
{0.6154241963446928f,0.7653462138108459f,-0.18840974380029266f},
{0.6690539812301199f,0.7109771485476057f,-0.21651388972359709f},
{0.6673822576498679f,0.37815610956637163f,-0.6415597236203281f},
{0.4470007397470815f,0.8017839371112818f,-0.3966520601936838f},
{0.0071816442961403675f,0.9876777052174062f,0.1563367346521034f},
{-0.36094223239631124f,0.8480536060958443f,0.38797652771862584f},
{-0.38301810534932074f,0.5746229338639429f,0.7232604059757533f},
{-0.2069791085960121f,0.7107817418831844f,0.6722714957591958f},
{-0.4234297933352418f,0.8988839134573133f,-0.11276045514159548f},
{0.07757383194890974f,0.810094792241987f,-0.5811443264621742f},
{0.38625246341861447f,0.4910315580004117f,-0.7808309955110263f},
{-0.0920844828536313f,0.8755549437665181f,-0.47426151906262476f},
{-0.25173186769775807f,0.9607484005415254f,-0.11659149901386097f},
{0.13696773060580825f,0.9903301260606038f,-0.022047271701587035f},
{0.29265668802071626f,0.9440267536165662f,0.15220233708097974f},
{0.5138567647029131f,0.8353770524961973f,0.19518300523309035f},
{0.7067553469791016f,0.6688674824388937f,0.2304629481116346f},
{0.8278175552704391f,0.4641869280085324f,-0.3150374438889372f},
{0.9050328333983895f,0.1893267449111108f,-0.38088181123840265f},
{0.8102901575949435f,0.5858012115440369f,0.016334045986842998f},
{0.2888656538536389f,0.7866214407852538f,0.545695283945758f},
{-0.23483887698331204f,0.5631572871587698f,0.792278089926253f},
{-0.62577590755401f,0.6170740696440543f,0.47709968151098125f},
{-0.7400761598667162f,0.5982960325478311f,0.3071304853551002f},
{-0.4034676604162969f,0.8947823560753467f,0.19125475746880435f},
{-0.15294715228387348f,0.9477247199266596f,-0.28004468187806764f},
{0.25974637711783444f,0.6358647529540093f,-0.7267790830265387f},
{0.22302229609239543f,0.49368388942587776f,-0.8405577153099087f},
{-0.14359194092297511f,0.7405501353787036f,-0.6564806558403351f},
{-0.4821978724344878f,0.8610993820195858f,-0.16122365243704373f},
{-0.0032173628269709384f,0.9861595314646912f,0.16576799171667775f},
{0.1873091396471407f,0.8905280078518731f,0.4145782838451891f},
{0.4421860855807442f,0.8385426083674642f,0.318304507776859f},
{0.622548755641f,0.6954596182548732f,0.3588439301794422f},
{0.7726582480665461f,0.5129085584160862f,0.37406422229112973f},
{0.8958667746524879f,0.4211170877202834f,0.14171492689104984f},
{0.9095340099403562f,0.39324377687191725f,-0.1345630585016776f},
{0.8662873027077456f,0.4656408296048391f,-0.18090032330611241f},
{0.8601201998565682f,0.32982915105601496f,-0.38910920435318136f},
{0.847107488415054f,0.5163198552515607f,-0.12578835456490578f},
{0.35473330819479726f,0.7452431241576306f,0.5646033704760797f},
{-0.16803496290283929f,0.42495280363606625f,0.8894826394731312f},
{-0.29407711754062776f,0.04120449266222112f,0.9548931032966176f},
{-0.34420543839199036f,-0.14086046435838773f,0.9282677123341719f},
{-0.0499129572056846f,0.29154540032448506f,0.9552538805221464f},
{0.2074157031636639f,0.40351496435600115f,0.8911534097011008f},
{0.13348739918609673f,0.30177442302626833f,0.9439879829032224f},
{-0.09308240196278872f,0.22356097892090035f,0.970235103028522f},
{0.13992879717913817f,0.4198096715959087f,0.8967607101978403f},
{-0.043401652671794404f,0.4175165099394055f,0.9076322275422877f},
{-0.35313551728608955f,0.25796715157154126f,0.8993043173148628f},
{-0.43718052055825163f,0.09480405309870518f,0.8943631163909176f},
{-0.5013250946228344f,0.010370020440838127f,0.865196863249898f},
{-0.19263141799278732f,0.0742183525221452f,0.9784604094959523f},
{0.563301714294299f,0.32927846280029077f,0.7578039803332928f},
{0.2721117045304205f,0.2814989568677513f,0.9201703959267092f},
{-0.17662139150134665f,0.052377380527954404f,0.9828842729808825f},
{-0.08142469365633088f,-0.01855110478228613f,0.9965068367925678f},
{-0.05237766623434046f,0.09367213342897972f,0.9942243768378984f},
{0.8871404962759885f,-0.23461635466618816f,0.397412765258418f},
{0.5343706606844514f,-0.5738402645324066f,0.6206088524997372f},
{-0.17956141452402583f,-0.7992001882900406f,0.5736172569329612f},
{0.175638741281037f,-0.8063151715024148f,0.5648069376045627f},
{0.3138842135437756f,-0.8985756407757485f,-0.30665700431012266f},
{0.563054524305638f,-0.5652896137765598f,-0.6028409866750098f},
{0.21044109773616537f,-0.9425062046916309f,-0.2596085485907103f},
{0.372844327152677f,-0.346289304041415f,-0.860854706449689f},
{0.3715819464530409f,-0.1312407691365959f,-0.919077101002198f},
{0.38545952232457215f,-0.10424517111787732f,-0.9168172669337752f},
{0.4980288937056716f,-0.1592683170978258f,-0.8524088363004758f},
{-0.931535420612719f,0.33741396664182965f,-0.13562291568503818f},
{-0.955123068474944f,0.2930886151687545f,-0.04288342016991022f},
{-0.9687673668664087f,0.20904628722874197f,-0.1333770545881243f},
{-0.9398826937360937f,0.21920121154758326f,-0.26186131992231293f},
{-0.9678661214817921f,0.12221456734290025f,-0.21976981234232446f},
{-0.967814417538571f,0.18284148726386934f,-0.17292843531245145f},
{-0.9656289217083328f,0.24698269395625305f,-0.08099589154095545f},
{-0.9458723946591688f,0.32436492846914916f,-0.010621026359687778f},
{-0.8397468322630498f,0.34181725248293854f,-0.4218841352897598f},
{-0.7618254198434574f,0.48179100485085247f,-0.43301207526481966f},
{-0.7102485917038783f,0.28735841023472924f,-0.6426290392209384f},
{-0.9274505818373515f,0.12094030054457776f,-0.35384864271852906f},
{-0.9519792002379033f,0.04698080793178408f,-0.30253661927191355f},
{-0.7835292406379458f,0.08022300266940606f,-0.6161543628897133f},
{-0.952472622567628f,0.13323956245624102f,-0.2739399975462042f},
{-0.5851070851674796f,0.21613475113036396f,-0.781623610339805f},
{-0.8376450712800261f,0.3441384177531017f,-0.4241691690666258f},
{-0.8648021502847695f,0.39309297217675393f,-0.31240223444797066f},
{-0.9768258686566029f,-0.00016935757544156557f,-0.2140354962179983f},
{-0.9860928171969985f,0.15662903083908827f,-0.05557249833231432f},
{-0.9575777918873888f,0.2509675304643853f,-0.1416335805403523f},
{-0.26433038300223105f,-0.49073508230955537f,-0.8302460644968621f},
{0.5143828413749175f,-0.6036119052821334f,-0.6091493743744135f},
{0.4230241302894242f,-0.7218861175756452f,-0.5476595826281486f},
{0.006243280328621361f,-0.7152469430761598f,-0.6988439252586712f},
{-0.5522235594529754f,0.5935589127283426f,-0.5854374069922708f},
{-0.5266160878723539f,0.5568039425076495f,-0.6423743967515794f},
{-0.34440057369710914f,0.4029063118076612f,-0.8479709598462968f},
{-0.6740895186136583f,0.16409547117693585f,-0.7201916392422407f},
{-0.9138673504741766f,0.07351047810908933f,-0.3993027364612989f},
{-0.908414640837065f,0.03633949212384728f,-0.4164880329914019f},
{-0.908877173693686f,-0.004694415001992991f,-0.4170374630730031f},
{-0.9141449199637723f,0.015301563170277057f,-0.4050986638696483f},
{0.13348300843962618f,-0.05498818684970506f,-0.9895244240365614f},
{0.40423650571936015f,-0.029925811614902414f,-0.9141648063905059f},
{0.2550746108580525f,0.04783214541315796f,-0.9657375568759804f},
{0.3657054563954776f,0.05045374210416838f,-0.9293621140708618f},
{-0.7039086239929274f,-0.5295542447901102f,-0.47337611990166917f},
{0.10819460892539748f,-0.9878592618951173f,-0.11148096378985249f},
{0.07588960326935307f,-0.9918552404411694f,0.10229345103676155f},
{0.19888128357465013f,-0.9800056031067614f,0.005937417203816516f},
{0.30001550895624796f,-0.8891780913361f,0.3454750588300312f},
{0.36706220556563174f,-0.9169218813789216f,0.15658735802686227f},
{0.5762762648975264f,-0.8168601736063065f,0.025399277384029525f},
{0.36107077663190534f,-0.930356875776621f,-0.06374933691888784f},
{-0.7580338563610611f,-0.5382339463118311f,-0.3683597313061931f},
{-0.7984743303069959f,-0.351871390108001f,-0.48849285426120354f},
{-0.7703259338612394f,-0.32863868035952276f,-0.5464380782781897f},
{-0.679974777604788f,-0.5036507100179334f,-0.5328886038561444f},
{-0.11440753672879579f,-0.9883539448431861f,-0.10033641040301251f},
{0.7284716924797084f,-0.684814211461907f,0.01893380668422904f},
{0.5628224629820567f,-0.7738996265260878f,0.29036226205482224f},
{0.12948379774770996f,-0.8459502802418721f,0.5173026865187617f},
{0.1826884244732863f,-0.9377191589309436f,0.29547879541062166f},
{0.47385884489149166f,-0.8805766583698624f,0.0065225648534650285f},
{0.6774934001233203f,-0.7343670211696046f,0.04132518611965576f},
{0.5260785460474845f,-0.8503212852793833f,0.013966931996054284f},
{-0.34022754016251117f,-0.7887166907445595f,-0.5120265644045411f},
{-0.611779525906418f,-0.7444968882168047f,-0.2673016930683623f},
{-0.8773447111130303f,-0.3432884416195847f,-0.3352898801520715f},
{-0.8183071636374516f,-0.5659823890948241f,-0.10018643208610711f},
{-0.9161801672258684f,-0.31694738653332166f,-0.24527179893268838f},
{-0.8074039132517594f,-0.15892337054845346f,-0.5681921181777025f},
{-0.7226077693124324f,-0.30428727976410946f,-0.620682900604704f},
{-0.631563489321067f,-0.31716778417284724f,-0.7074829719784672f},
{-0.6244733041288669f,-0.7303417952698456f,-0.27682838458582004f},
{-0.3241148699192489f,-0.8164969158395755f,0.4777890094191051f},
{0.4533806686877501f,-0.8839665565610731f,0.11423264043961992f},
{0.7588655902044709f,-0.6476960299897836f,-0.06791810317649959f},
{0.5460863114515219f,-0.8248787081542005f,0.14616722368276944f},
{0.28502163572422423f,-0.7770161793654915f,0.561256201901896f},
{0.10740964911855924f,-0.7513826360457025f,0.6510662804394336f},
{0.1600946639060673f,-0.952751379899372f,0.2581366047050395f},
{0.14380592688149935f,-0.9726367344345509f,-0.18247640456301603f},
{0.5013684180329242f,-0.8567497592286072f,-0.12087001059355651f},
{0.3585686168936993f,-0.8439657563335651f,-0.398936522664011f},
{-0.44298443776353397f,-0.7142599461646529f,-0.5418463963192822f},
{-0.9408602315394584f,-0.01940904374046907f,-0.3382385455985128f},
{-0.8031169347742881f,-0.06389748272749197f,-0.5923852638105052f},
{0.5631084116228018f,-0.30899853153969387f,-0.7664390545020251f},
{0.6388635670496158f,-0.2609277677035215f,-0.7237195884718738f},
{0.4420864816322508f,-0.27173013017067715f,-0.8548229519119409f},
{-0.06640757186946054f,-0.2998794515320081f,-0.9516629387273964f},
{-0.505824546257842f,-0.16995792268329302f,-0.8457279899117849f},
{-0.5281098208279429f,-0.090466888258015f,-0.8443433894299107f},
{-0.7020654438490873f,-0.009452231047982868f,-0.7120496948115346f},
{-0.7710554746177122f,0.002304087382728051f,-0.6367638072656042f},
{-0.8485458528813704f,0.005873614098267853f,-0.5290892516534922f},
{-0.19120935290747704f,-0.1385066941863614f,0.971727780310036f},
{0.6164660176578365f,0.47738576504624164f,0.626156913564246f},
{0.37569536551506977f,0.29114773633235336f,0.8798215659774683f},
{-0.3402657092872637f,-0.24852320042094603f,0.9068933046041115f},
{0.4031164498609469f,0.5243095479991632f,0.7500644143861379f},
{0.6656506090609969f,0.4835926786523772f,0.5683725783414805f},
{0.3984541556076693f,0.371568337661296f,0.8385530730529824f},
{0.4090019571291986f,0.5788586392531492f,0.7054360884066518f},
{0.5009998789126003f,0.6760434527693263f,0.5403372755023361f},
{-0.20893314745912567f,-0.0737665809191898f,0.9751438003865459f},
{-0.5809703792057306f,-0.3902799969552328f,0.7142513160381107f},
{-0.540924431275787f,-0.405551744757082f,0.7368368489519596f},
{-0.4439502407427911f,-0.5531182026923106f,0.7049598836776784f},
{-0.4737637715557831f,-0.5829130064999657f,0.660121440050549f},
{-0.3666659488838673f,-0.4524923469245993f,0.8129002139892457f},
{-0.1926100308985856f,-0.10542110984614213f,0.9755961078212918f},
{0.20416483213575284f,0.1650518942295529f,0.9649220660396447f},
{0.5880403151045923f,0.6633810794731785f,0.4627462924850852f},
{0.3827283692161384f,0.3847299025795993f,0.839941603600064f},
{0.1050646015062281f,0.13635738266622757f,0.9850726337193383f},
{0.02807543021226875f,0.07636742668337759f,0.9966843965670151f},
{0.08999580957311455f,0.3500140965768458f,0.9324113290049484f},
{0.08810567603357375f,0.637380464101015f,0.765495613203003f},
{0.21151920540796956f,0.7427937647252378f,0.6352299180839085f},
{-0.7989481421230418f,-0.3216574071104252f,0.5081519247716554f},
{-0.7191135049564898f,-0.6419241478853466f,0.2660998973146443f},
{-0.5276859863222305f,-0.5191076774883413f,0.6723650191761875f},
{-0.5628226926809272f,-0.7371882985460143f,0.3738770240202292f},
{-0.4467539064650714f,-0.7237234688541129f,0.5259612986598616f},
{-0.25574093402080017f,-0.5096539172588548f,0.8214922149898155f},
{-0.19154602214710245f,-0.21364438475829417f,0.9579489538910055f},
{-0.1962588272212876f,-0.15606961145536707f,0.9680520384348641f},
{-0.1659683505198262f,-0.08499243066086873f,0.9824615989218538f},
{0.42654224832716525f,-0.32116870651318397f,0.8455249093602477f},
{0.7130130740377466f,0.3485128801465886f,0.6084004673101201f},
{0.6903443548773732f,-0.020443670908199343f,0.72319204089145f},
{0.4427269450967426f,0.6535519296892811f,0.6138914621370156f},
{-0.05561432366814452f,0.5489562756984921f,0.8339988335568437f},
{-0.21756578581275487f,-0.2396849876902495f,0.9461586735424473f},
{0.2243619894710354f,-0.2894835042031921f,0.9305165224083017f},
{-0.07196740784051771f,-0.0407644167390239f,0.9965736071844588f},
{-0.3984782933388642f,0.19359565459079617f,0.8965131188450659f},
{-0.26856650246820074f,0.42768937875082724f,0.863107078557307f},
{-0.20886062635265443f,0.7140142976749381f,0.6682520643255371f},
{-0.541857602949313f,0.4372785756711666f,0.7177588629790792f},
{-0.40187844944714285f,-0.13976124020392172f,0.9049643681419849f},
{-0.612531304730357f,-0.0993352278764863f,0.784179770988804f},
{-0.8570240218908608f,0.3776521161162259f,0.35055485318983937f},
{-0.8374182748582932f,0.3356836193638016f,-0.43133182194706915f},
{-0.9954493283106995f,-0.038523289752015445f,-0.08715842421969028f},
{-0.670585864482943f,-0.36518681601207975f,0.6457191245167077f},
{-0.8531962953482127f,-0.23939673229652042f,0.46340617838979387f},
{-0.7932128138077476f,-0.13976140698623316f,0.5926889412908124f},
{0.3052115314808967f,-0.25054466334951575f,0.9187346149558987f},
{0.3255516348641727f,-0.2618857434880461f,0.9085328779934041f},
{-0.627319978703959f,-0.17798312942300212f,0.7581501500096529f},
{0.216498478930659f,-0.9715571349877702f,0.09594343164108171f},
{0.2879597998030509f,-0.6403632501629477f,0.7120491988185457f},
{0.05735202560312331f,-0.9970387621629142f,0.05122940467995634f},
{0.01267369466270149f,-0.9999135849291503f,0.0034928695554470143f},
{-0.04617637658240024f,-0.9986305886676824f,0.024590437632511376f},
{-0.24208106275514518f,-0.826121322272668f,0.5088421365628027f},
{0.7220002686286491f,-0.6612572019588443f,0.20360384318012986f},
{0.8635839542217254f,-0.3665711381360464f,0.34619121117730944f},
{0.3566593079066276f,0.41599638877302564f,0.8365053153515326f},
{0.16829215646706686f,0.7382134829145975f,0.653237019553212f},
{0.43763968186062896f,0.783556525172956f,0.44103365032592484f},
{-0.07713118728005064f,0.9959047376023532f,-0.04716496125258234f},
{-0.27424002723452107f,0.9504622825925301f,0.14633474239361932f},
{-0.29749552918627575f,0.6714763621228189f,0.6786868977845989f},
{0.4910362574231216f,0.6899623105348971f,0.5318227185230432f},
{0.6335168580965103f,0.5794636131867686f,0.5127165995948064f},
{0.3834648790053125f,0.7193006393273707f,0.5792765115492572f},
{0.5073454850858844f,-0.08262828144415672f,0.8577721876282501f},
{0.5824607700061489f,-0.5292870255287939f,0.6169235738815028f},
{0.8515746361267564f,-0.5124184786205659f,0.11067042004875173f},
{0.7911114722195636f,-0.6095786902384623f,-0.05056143718047702f},
{0.6909093423689274f,-0.5165914951679071f,0.5057445083710966f},
{0.2980900497242137f,-0.46524957889751195f,0.8334777451084724f},
{0.26290894198597475f,-0.9564762559332914f,0.12661777150008577f},
{0.46531460258402557f,-0.8774747560336711f,0.11627713939429145f},
{0.39837415962823985f,-0.9164487556102711f,0.03767900318319674f},
{-0.010345262914980285f,-0.9994064435946631f,0.03285933713098232f},
{0.2716943087778941f,-0.9332159233860876f,0.23513877374085787f},
{0.6404876089852446f,-0.7628053363724695f,0.08890242706500197f},
{0.7827965966980488f,-0.5528803948764565f,0.2855744336582074f},
{0.9003833211980592f,-0.40033666976874177f,0.17041251640306815f},
{0.8220096209617644f,-0.03598432237986953f,0.5683355624885338f},
{0.6658240447773552f,0.21126447913290086f,0.7155736588591189f},
{0.5356036727763608f,0.5582999999112852f,0.6335848923447686f},
{0.5279195481955617f,0.7113763469208785f,0.4639446558313824f},
{0.738419185576753f,0.5472805834747817f,0.393981051985584f},
{0.4631647320062399f,0.8821074470236713f,-0.08581889611833149f},
{0.18939582907783264f,0.8473511259720986f,-0.49611015837386063f},
{0.14528807573494998f,0.9813904671517555f,-0.12555527082880533f},
{0.6645242302435809f,-0.20150442758111234f,0.7195856537510906f},
{0.7279902295564283f,-0.3319213248940778f,0.5998820381966267f},
{0.7833783549180139f,-0.16231531921821685f,0.599976741376726f},
{0.6548350504151096f,-0.2671209063106278f,0.7069918515510838f},
{0.5641542183540469f,-0.4458247924577255f,0.6949606264698457f},
{0.5344872760906512f,-0.12216289842324152f,0.8363011287485081f},
{0.4054737070803472f,-0.0925497486881206f,0.9094094880109215f},
{0.4789811342025778f,0.0139262131674962f,0.877714722255942f},
{0.6917443739912796f,-0.03499143048128541f,0.7212941985377992f},
{0.28382347827336624f,-0.1150636257350792f,0.9519477901720795f},
{0.03269411906113438f,0.06939978126468636f,0.997053040183535f},
{0.5103940033633756f,-0.06555875446517469f,0.8574380508489704f},
{0.4161749474643674f,-0.15669654007593167f,0.8956810857840323f},
{0.491990183530746f,-0.15717243354078325f,0.8562957931954653f},
{0.6441470391820617f,-0.16004438492691694f,0.747970846200805f},
{0.5985796724813175f,0.07119697753826865f,0.7978930793543542f},
{0.4627808513760563f,0.026887447736355742f,0.8860648671253575f},
{0.07786752391049231f,0.13981615991380933f,0.987110981676835f},
{-0.16613094543317092f,0.20084234886486277f,0.9654340266801898f},
{0.24009962596903747f,-0.09961181985479799f,0.9656239718206792f},
{0.4933086620219493f,-0.22458330790061443f,0.8403623633805433f},
{0.40667024182783645f,-0.16015708065985917f,0.8994270531433888f},
{0.46272944379194486f,-0.18480121600352883f,0.867023628519785f},
{0.600490460672844f,-0.1983575797061914f,0.7746389334483631f},
{0.6421842875539117f,-0.1829823361726061f,0.7443902239200151f},
{0.6119360028154146f,-0.19355302446777625f,0.7668582366889393f},
{0.7227822124286142f,-0.22448124340920883f,0.6536008298298384f},
{-0.875524880861965f,-0.4789413545031353f,0.06380722481305531f},
{-0.9598237199435377f,-0.15273101688727925f,-0.2353968205272255f},
{-0.6352193974387701f,0.26355083386347944f,-0.7259733294601053f},
{-0.7625203022716353f,-0.610423515209478f,-0.21434999580797284f},
{-0.2693598227681157f,0.5144548793222151f,-0.8141139128032971f},
{0.33568139864354557f,0.24699787776517895f,-0.909015977298645f},
{-0.0984079198791101f,0.1551266606979439f,-0.9829809766449051f},
{-0.8985240618853744f,-0.42151845388075715f,-0.12237934160218288f},
{-0.8775863022209455f,-0.4346185740494446f,0.20235853637886148f},
{-0.9053271251253607f,-0.3325830378998235f,0.26414261188527327f},
{-0.5295960708325317f,-0.8071748794643688f,0.2607617988134488f},
{-0.5192391175742023f,-0.8522941924109692f,0.06312961558014896f},
{-0.11816744839895832f,-0.9827584873697074f,-0.14220481581748373f},
{0.42153871330213205f,0.9063819039608861f,0.027873954865110333f},
{-0.41504693285980876f,0.6071920345934209f,0.6775351479074481f},
{-0.6446338331579784f,0.28199981968721816f,0.71057956827116f},
{-0.5343792318972505f,0.12949389797968286f,0.8352665244716397f},
{-0.3470414733991477f,-0.5616200912650147f,0.7510959251842773f},
{-0.09863732213747967f,-0.34537702357551675f,0.9332659804512667f},
{0.009636256668248966f,-0.16213014981270069f,0.9867223302830107f},
{0.3363427908962132f,-0.2864051134721892f,0.8971318955366199f},
{0.0228555044523783f,-0.2273077754472279f,0.9735547242643631f},
{0.9402118569030838f,0.19535243376192718f,-0.2789965784058059f},
{0.31114692550601797f,-0.12525845181609876f,-0.9420710753424004f},
{0.5344997806573261f,-0.07182777511555986f,-0.8421108924596682f},
{0.8960863495163761f,0.3187588891820677f,0.3089045560975582f},
{0.8361487309642053f,0.03033297182826258f,0.5476634098851364f},
{0.519792990437986f,-0.20602460734465852f,-0.8290772631425946f},
{0.29905972840813844f,-0.1737876877807898f,-0.9382756089871767f},
{0.5378219655926314f,-0.031918665508361276f,-0.8424539940662895f},
{0.4653184233207867f,-0.04613786099233681f,-0.883940078682548f},
{0.8956148728124484f,0.1509714020565055f,-0.41842757480624376f},
{0.9554400051460061f,0.2948720840319067f,-0.013595978275939027f},
{0.8677296563110284f,0.45249450592066065f,0.20565496753047774f},
{0.6441621592122148f,0.18223479210198473f,0.7428631052802419f},
{0.5409073270122453f,-0.19142076138046174f,0.8190099851021306f},
{0.8967149681761782f,-0.28711151206944274f,0.3368519637555848f},
{0.635843049129754f,-0.23696993993255502f,-0.7345398998296407f},
{0.43374699063242456f,-0.2814878396712288f,-0.855936997818496f},
{0.39917393574411025f,-0.2630918410045521f,-0.8783181953138579f},
{0.8707478461638545f,0.2537216389158512f,-0.42121671185609777f},
{0.8866474604971463f,0.4443094972190799f,0.12823943026577178f},
{0.9257684359676203f,0.3779495824534563f,0.010340023661683606f},
{0.9591696935719396f,0.24750389798885422f,-0.13687702295650003f},
{0.37921704154460856f,-0.07686647549622025f,-0.9221095273051588f},
{0.9699281829678822f,0.2411884185039573f,-0.03267210835226832f},
{0.9676960648678331f,0.24350918656091933f,-0.06532688649973802f},
{0.7495199619613565f,0.1543069495888468f,-0.6437462170219191f},
{0.7431441387003977f,0.37777464766611f,-0.5522889684721128f},
{0.8411549263485509f,0.5403886327836949f,0.020940760199494843f},
{0.7506094713132516f,0.34845232503106954f,0.5613968282376403f},
{0.6326772738460326f,-0.11447626454731372f,0.7659077307444062f},
{0.5564878782036102f,-0.3681980084474658f,0.7448163988445499f},
{0.6942834979815916f,-0.3448476678605223f,0.6317044486162845f},
{0.9894560624581366f,0.05450927035113818f,0.13418435046840121f},
{0.8502235091677774f,-0.091281424571676f,-0.5184473801521187f},
{0.6027103240344275f,-0.2030120292551471f,-0.7717035579029183f},
{0.588469123720578f,-0.2620963166845123f,-0.7648592100562999f},
{0.4779066547641374f,-0.35513847050488107f,-0.8034188796011739f},
{0.34095305454235403f,-0.43663720104737974f,-0.8325256568177034f},
{0.4312922028632917f,-0.2958748670239742f,-0.8523174870978977f},
{0.4872238875739202f,-0.3835112764666678f,-0.7845584644883152f},
{0.8115771355951658f,-0.07681961653108121f,-0.5791729443742719f},
{0.8680407770594436f,0.38877542448645624f,-0.3088023294559371f},
{0.47071403218429303f,0.8455840246873632f,0.25182525111339593f},
{0.8163418247646613f,0.572610993215064f,0.07551606179589189f},
{0.6421097793389148f,0.6420943077753553f,0.41881968817119547f},
{0.6972927151795167f,0.5072720927087748f,0.5064167190332853f},
{0.942701948873904f,0.18059900348136007f,-0.28052991913677033f},
{0.7950761090680287f,-0.011204525249130355f,-0.606406167022719f},
{0.8737670201178116f,0.035364549602844325f,-0.4850572576364854f},
{0.7607255485218123f,-0.14541954564269527f,-0.6325739447457982f},
{0.7421048802536578f,-0.2748491068267597f,-0.6113414064009052f},
{0.56796620705346f,-0.5028838952472828f,-0.6515536628292607f},
{0.4112948017186898f,-0.7485959212468319f,-0.5200391646518466f},
{0.6088122632846851f,-0.7425795293793964f,-0.2791473994520698f},
{0.8468844321052001f,-0.49582624295202654f,-0.19220586738684772f},
{0.938002236367849f,0.2748781853788537f,-0.21117241243056004f},
{0.4592755527958535f,0.8603538100594246f,-0.22103684787902345f},
{0.017218673705759604f,0.984526913074355f,0.17438541999862262f},
{-0.015057927547150025f,0.9963425557021378f,-0.08411165504801942f},
{0.24609695285236652f,0.897342098962306f,-0.36635153504073537f},
{0.9501335507265752f,0.20255007111073997f,-0.2371069473396865f},
{0.5188860015388607f,0.613958727044601f,-0.5948209805418655f},
{0.9633360845884648f,-0.1961297116631853f,0.18307573387175624f},
{0.9721913173256371f,-0.22220500701270218f,0.07395253460921679f},
{0.9426008485890138f,-0.2980523616915287f,-0.15056038632181082f},
{0.7977503447179712f,-0.5378783018297599f,-0.27254599597699397f},
{0.6573532712028062f,-0.5137888443170089f,-0.5512782421739157f},
{0.8036463203692861f,-0.43431426027180137f,-0.40684605821055303f},
{0.06468251993271981f,0.8873641259345735f,-0.45650967089375444f},
{-0.15847392595531032f,0.9348967458334305f,-0.31757532873693567f},
{0.6848485631878946f,0.5947862236283676f,-0.42096531173171714f},
{0.8128967323660402f,0.0037667328721867847f,-0.5823956681089618f},
{0.7133699916704196f,0.5901783906727711f,-0.3778792428369723f},
{0.682758536341422f,0.6137278146158269f,-0.39645800612397797f},
{0.7653494555835553f,0.5645427130254603f,-0.30908208619686794f},
{0.784886532427554f,0.06635957711494717f,-0.616075918811128f},
{0.7071954492121131f,-0.6084872904086394f,-0.36002474085099995f},
{0.8929296530387641f,-0.09190747854820921f,-0.4407149306649174f},
{0.9490290510985475f,-0.008151598776613323f,-0.31508318204622665f},
{0.909071141223084f,0.2190087429271883f,-0.3544359331625566f},
{0.6591541253792442f,0.5873963911400754f,-0.46955438308159714f},
{0.6977872053650274f,0.5255824910035503f,-0.4866786015219573f},
{0.7603125145196813f,0.4395547344255246f,-0.4782431554229145f},
{0.7627594338433705f,0.5540136747689884f,-0.3335669261960821f},
{0.8551262844247591f,0.43575091048864795f,-0.280856158369761f},
{0.8844423883822989f,0.42022407174281334f,-0.20291227454371893f},
{0.5146120577785251f,-0.32042382485410625f,-0.7953005736542739f},
{0.3606644517444856f,0.7308867578603067f,0.5794184156827422f},
{0.49896137564154225f,0.5006794955513513f,0.7073595891428519f},
{0.38367205460889786f,0.5325084878256697f,0.7544736343344315f},
{0.05442429604069015f,0.6369805788958606f,0.7689562654078382f},
{0.49817282985382505f,0.7935477632580328f,0.34943637335515726f},
{0.727487947209484f,0.640869102349304f,0.24504709816467599f},
{0.8168169871621119f,0.41156956321696997f,0.40425301992292256f},
{0.4924697262838793f,0.33800519072845686f,0.8020137528337656f},
{0.6865192933440222f,0.2822465426603138f,0.670095626774809f},
{0.6750487487122597f,0.5271969446790393f,0.5161129414993376f},
{0.5400963288005408f,0.8271117697480109f,0.15550587114476222f},
{0.08331643167591883f,0.9275746946925957f,0.3642300893373995f},
{0.13921776010120854f,0.8491489504103439f,0.5094747052498424f},
{0.48702364825401917f,0.8671542179854405f,0.10417066895918849f},
{0.6334779486284174f,0.747492607461865f,0.199901201575664f},
{0.8947987589744741f,0.17855745574106208f,0.4092095012790143f},
{0.5551522315389832f,0.20382463546432827f,0.8063879449713526f},
{0.8197189771197403f,0.10457728711151562f,0.5631379844852967f},
{0.8571747727314937f,0.2773245395697629f,0.4339844568013136f},
{0.5965942963586458f,0.31222511101573686f,0.7393177433306624f},
{0.41222482981555497f,0.478652269284893f,0.7752178369929055f},
{0.4297503462078067f,0.6574921178234103f,0.6188850902504898f},
{0.23309918551831105f,0.7404689928446684f,0.6303732547834674f},
{0.26706668395844807f,0.9496647002045816f,0.1637447510755089f},
{-0.22195030715184477f,0.7926283758058443f,0.5678717452229782f},
{0.2281875361992986f,0.9733686900673412f,-0.021996397884247572f},
{0.22332301058536802f,0.9200767989682999f,0.32184703966843364f},
{0.7867471208291672f,0.4821088899014005f,-0.3854866873772104f},
{0.5335221868993569f,0.8368380277904874f,-0.12270367284582563f},
{0.6134651568689865f,0.7894670470311853f,0.0200569927848148f},
{0.7484730007489941f,0.6578777049959367f,-0.083576865334107f},
{0.08051995508899289f,0.7162971867045586f,0.6931340975248593f},
{-0.0011009533302282425f,0.8362146503615823f,0.548401172885709f},
{0.7423794363232145f,0.5990902652551668f,-0.29993937154185074f},
{0.8371652306021339f,0.42838951099732386f,-0.34005411854343065f},
{0.8134565792609944f,0.3775506759279846f,-0.4424295206734328f},
{0.815075896178874f,0.4293199074143548f,-0.38901889487007607f},
{0.6633816301399109f,0.6733211221543616f,0.3264406213290646f},
{-0.37374501015723216f,0.013398932495546844f,0.9274347071306692f},
{-0.6683594618266077f,-0.09268974882010839f,0.7380408120493829f},
{-0.704946919836186f,-0.12369425599792601f,0.6983907010023785f},
{-0.6931282148218553f,-0.10105657155937382f,0.7136952060666607f},
{0.24545290132767475f,-0.30660843553617007f,0.9196434855355031f},
{0.12390847261746227f,-0.09957329172941498f,0.9872850905325049f},
{0.06944668019389796f,-0.18266375475477897f,0.9807196904870079f},
{0.09377385777684989f,-0.24589737727698233f,0.9647491608941406f},
{-0.12163606844232014f,-0.08190100379079872f,0.9891900183644975f},
{-0.10850683603662108f,0.009999108513785618f,0.9940454136317171f},
{0.08570071033111672f,-0.07759151732036486f,0.9932949937901959f},
{0.281916302863037f,-0.14885118787609455f,0.9478219885864181f},
{0.30457014367809454f,-0.24285650025616257f,0.9210090921718598f},
{0.16784080200401486f,-0.16150942530823462f,0.9724937895530505f},
{-0.012473858356922033f,0.046730220424068554f,0.9988296598303483f},
{-0.02425652708748243f,-0.24174942187162893f,0.9700354828141017f},
{0.25011704880565927f,-0.2715483512853769f,0.9293562044829425f},
{0.18037240032442134f,-0.1337592546275684f,0.9744610094830292f},
{0.26714064829960127f,-0.1672582343488818f,0.9490313783371778f},
{0.16627931672633642f,-0.08325224677227422f,0.9825580146924613f},
{-0.04559447634044022f,0.09202042467575998f,0.9947127148929652f},
{-0.2837475659955044f,0.41790504966449116f,0.8630426920242973f},
{-0.2091040530675381f,0.3955112728418482f,0.8943412816401518f},
{-0.05972377643414109f,0.22170820427061255f,0.9732823550684279f},
{-0.08425369660137387f,0.21406305400954154f,0.9731794919320442f},
{-0.7379967134168056f,0.34584412816076854f,0.5794417054395646f},
{0.0658037566676304f,0.5258034722222197f,0.8480569404276371f},
{0.2045891513309668f,0.5382272113908125f,0.8175908194666476f},
{-0.955261429084264f,-0.09640372688068062f,0.27961030658293856f},
{0.16626545163040202f,0.31197923425001356f,0.935427579768158f},
{0.27319432952562206f,0.62678474497573f,0.7297299101590635f},
{0.3052643849471927f,0.5205656196436383f,0.7973864125553225f},
{0.10869346642525114f,0.26163053821370025f,0.9590282539271053f},
{-0.9637482823657814f,-0.061869969424339276f,0.2595406617862367f},
{-0.9860646059107672f,-0.10877078580764186f,0.12587894631284266f},
{-0.976631078589816f,-0.10487793142590496f,0.1875962575114865f},
{-0.9287369253707f,-0.2973743935007492f,0.22139601067553227f},
{-0.7589142045805797f,-0.6510514109230452f,-0.01346441313010661f},
{-0.7959862382183912f,-0.43189198579761634f,0.42411698995763686f},
{-0.7120900068479765f,-0.021940095006366594f,0.7017452916681098f},
{0.6581270662066452f,0.10202090577457862f,0.7459628003534551f},
{0.5826946968989444f,0.41331959915838257f,0.6997383790799253f},
{0.8527810410908703f,-0.05436831305669323f,0.5194310180296713f},
{0.026794876105263835f,-0.10900970343295417f,0.9936794851318823f},
{0.05238064556123075f,-0.11112485010307706f,0.9924250781092532f},
{0.11601320671903181f,-0.3100968253173868f,0.9435999654487305f},
{0.04602681050268693f,-0.12249873903749338f,0.9914008229011986f},
{0.06446185540022459f,-0.32027450415463776f,0.9451290447271534f},
{0.08513201865606991f,-0.44609031849082786f,0.890929832898357f},
{0.18934291543137155f,-0.44756688788966587f,0.8739754809150585f},
{0.23582459120908064f,-0.3264871106576175f,0.9153102909699588f},
{0.25041329585336f,-0.20107973548158312f,0.9470269907655822f},
{0.07428823793753474f,-0.07245441223151168f,0.994601234592197f},
{-0.09275658837346118f,0.09297841017943809f,0.9913381010300273f},
{-0.02162846023631983f,0.06903214127234561f,0.9973799542697662f},
{0.0012969299882125331f,0.09290936607587681f,0.9956737255085043f},
{0.0708644785064253f,0.06428633014615259f,0.9954122228716865f},
{0.6133658007061681f,-0.2640877724394959f,0.744338661478783f},
{0.4483065498687776f,-0.3133824477265992f,0.8371455541312028f},
{0.8668894596056378f,-0.43140568716362915f,0.24978350207233926f},
{0.35439062865348436f,-0.4950057949936478f,0.7933325565267664f},
{0.17727954560554107f,-0.729226277460031f,0.6609092214303556f},
{0.23644355986467683f,-0.828537987145851f,0.5075620620720392f},
{0.2937046844732352f,-0.677167659885678f,0.6746714153745007f},
{0.3132825629973879f,-0.47171201593967366f,0.8242219420398347f},
{0.40782259189486586f,-0.40698024760638485f,0.8173419184150532f},
{0.40189214398912243f,-0.3438646988569125f,0.8486694135409095f},
{0.46567669758025193f,-0.29151116064586374f,0.8355635562598765f},
{0.5026071249985907f,-0.22723509558370356f,0.834116472224183f},
{0.17487704331433027f,-0.12748115138987862f,0.9763025021794981f},
{-0.09385441456302822f,-0.0015686395412427407f,0.9955846966667481f},
{-0.3479771817382473f,0.24197579350036677f,0.9057370459186124f},
{-0.345753226388507f,0.34146227737465834f,0.8739898280712708f},
{-0.3172291127814096f,0.4595628549098807f,0.8295587214845008f},
{-0.0769748660284764f,0.21491196355968392f,0.9735952536443566f},
{-0.017056452220446567f,0.10434864318134461f,0.9943945082832387f},
{0.06490505850163712f,0.16012459145702013f,0.9849606330161736f},
{0.8505495154615497f,-0.17404441873780754f,0.4962600750154517f},
{0.9542656257236902f,-0.2841139486978085f,-0.093039667440899f},
{0.9019156803808543f,-0.34595758607085497f,0.2585758189065009f},
{0.6560054252463932f,-0.3256973762582089f,0.6808656997865421f},
{0.7444030441044185f,-0.4360093129896612f,0.5057271862519938f},
{0.39709615002287335f,-0.3954143551055383f,0.8282283111639464f},
{0.13646418132993668f,-0.880591562513021f,-0.4538017488340327f},
{0.3689672915139488f,-0.9289864297752357f,-0.02910929553118611f},
{0.2915628049395955f,-0.8475183454012171f,-0.44351300430104496f},
{0.3825985230807907f,-0.6492256264899814f,-0.6573617391095171f},
{0.7321585341849883f,-0.5890346000397735f,0.3420264913366704f},
{0.42693660403025213f,-0.35785490785426033f,0.8304607161472086f},
{0.3282112438041338f,-0.2047796414196131f,0.9221402701870242f},
{0.3752178883296676f,-0.16123541370169f,0.9128059364650681f},
{0.5570785462544298f,-0.19600417462090922f,0.8069980525591294f},
{0.545203523355637f,-0.2067690994163558f,0.8124036297599541f},
{0.36902828694999956f,-0.15825530553793205f,0.9158457193762738f},
{0.3143286273386723f,-0.12952056747700044f,0.9404370987130515f},
{0.31504407319576927f,-0.14974723494052367f,0.9371888804141277f},
{0.0991103958181425f,-0.06489422428331154f,0.9929581406562104f},
{-0.5990257422906571f,0.38742485317145087f,0.7007639711188118f},
{-0.5480351281244572f,0.4662650320349531f,0.6944454033565589f},
{-0.4966873457751801f,0.583071355066151f,0.6429070503954124f},
{-0.3432774807776286f,0.7062908916080315f,0.6191233702764714f},
{-0.1810952096219757f,0.4206339167384168f,0.8889722341790386f},
{-0.17182614320002815f,0.6259497544387168f,0.7606988112460237f},
{0.02191367026747748f,0.4060364018550786f,0.9135941283874308f},
{-0.21131492933585497f,-0.010583139872582154f,0.9773607306364525f},
{0.09778283730379826f,-0.2003634274047353f,0.9748297357423225f},
{0.4962245400878339f,-0.083059372420625f,0.8642119800533371f},
{0.7821369389276212f,-0.21067678320027178f,0.5864103527269249f},
{0.6482661687605169f,-0.2830772439096472f,0.7068367905118401f},
{0.6045401933939792f,-0.27400620700883277f,0.7479650747807699f},
{0.4482052724923271f,-0.18605949194616872f,0.8743534177704188f},
{0.24430394873124633f,-0.16787084359553184f,0.9550575692097545f},
{0.3070854806539281f,-0.15081120363363393f,0.9396565800493927f},
{0.2830325309299545f,-0.1579431300307257f,0.9460161489697106f},
{0.14475628169645888f,-0.14940065833763838f,0.9781232346681555f},
{0.2225309424995519f,-0.307289344183509f,0.9252314513577292f},
{0.7945423870279544f,-0.4182327725801094f,0.4402087495221724f},
{0.45596440516132253f,-0.11247864220106826f,0.8828618330602389f},
{0.3482740981702881f,-0.12104910185951409f,0.9295441180937447f},
{0.34060144512655216f,-0.09258505563521556f,0.9356381047449533f},
{0.20630334432129685f,-0.13647690074576618f,0.9689236222141964f},
{0.23480481749606852f,-0.17166089667447504f,0.9567649838040443f},
{0.3744984511059108f,-0.15261640682798586f,0.9145814028757574f},
{0.20514709516327878f,-0.0990494172471039f,0.9737062607835475f},
{0.17207884415555905f,-0.17023911363254815f,0.970261570703329f},
{0.27865783712922404f,-0.2028590878527789f,0.9387214710882038f},
{0.16205950443289316f,-0.6334441920909469f,0.7566274991891404f},
{0.4252615546948464f,-0.8578403208525678f,-0.28855258449385895f},
{0.6894362405697311f,-0.48432551197068874f,-0.5386153252957124f},
{0.9117850587578205f,0.0012556577453983289f,-0.4106658373296035f},
{0.9215772243959477f,0.2078535455927121f,0.32786021878111354f},
{0.3281557131168956f,-0.11519366806488897f,0.9375735953974483f},
{0.40565661950502635f,-0.06329822087541839f,0.9118311479028127f},
{0.5635434753922733f,-0.1272327369873903f,0.8162294910020684f},
{0.45891567565942387f,-0.003147769825504347f,0.8884742507125236f},
{0.12442761336991547f,0.11207208389274521f,0.9858791087364639f},
{0.42339023557844696f,-0.08642121141805495f,0.9018159915602866f},
{0.5051179619413495f,-0.14039126930138685f,0.8515551280029748f},
{0.877480445723149f,0.26157960370160943f,0.402000221767119f},
{0.9952711110902037f,0.045311833882015234f,-0.08592003921973115f},
{0.7707573648758206f,-0.08911164677797725f,0.6308662290043733f},
{0.47282569109348416f,0.18540032823281863f,0.8614305451591162f},
{-0.05015128833423996f,0.03380251483462276f,0.9981694436663903f},
{0.2791382716639249f,-0.2203361750339978f,0.9346302987084596f},
{0.7601072195757785f,-0.1697144325117279f,0.6272431953764037f},
{0.9550444272684938f,-0.14759107177482592f,0.25711284969007825f},
{0.9023008810415617f,-0.25506639717369295f,-0.3475546764243769f},
{0.754747839894325f,-0.04690689368936895f,-0.6543358781996174f},
{0.8060905553859009f,0.24181865806704436f,-0.5401312369492286f},
{0.9801514685750523f,0.049056598788192296f,0.19208474370835063f},
{0.7024750067391766f,-0.19850929914112603f,0.6834639149664691f},
{0.0762963521431901f,-0.29625900532514476f,0.9520553914628067f},
{-0.40415572555118695f,0.08706750043490186f,0.9105368745263488f},
{-0.7390565698944167f,0.2507892590482491f,0.6252200684894315f},
{-0.8754792090036292f,-0.016727419895887673f,0.48296619760186776f},
{-0.4062472217993551f,-0.28071305637772936f,0.8695765491084608f},
{-0.3768898989703409f,0.14962553929941255f,0.91409310359694f},
{0.5937591665720513f,0.17001948211587273f,0.7864753192648284f},
{0.934299050838909f,0.24934358864036446f,0.25478041213063946f},
{0.9288331006617622f,0.157158271643299f,-0.3355150499890397f},
{0.5555746099440159f,-0.06820669176786334f,-0.8286644073348622f},
{0.20828010085567306f,0.0383959761304373f,-0.9773152759496504f},
{0.41595223865218744f,-0.08416079825680103f,-0.9054836802488555f},
{0.7632271338146971f,-0.18788814298470852f,-0.6182090163809975f},
{0.9738777726608788f,-0.22086717080569235f,0.052723588434160085f},
{0.9002149221108067f,-0.04077981051685951f,0.43353212229688737f},
{0.30246696549036395f,-0.07313678205353315f,0.9503498018613488f},
{-0.4256509943644906f,-0.04865063086530494f,0.9035786336080154f},
{-0.5614098859484346f,-0.35045460232828085f,0.7496669338221422f},
{-0.923072255754427f,-0.14912729555159676f,0.3545400687903983f},
{-0.97711568095854f,0.21211161193381506f,0.015925140745602584f},
{-0.9292971799978053f,-0.004769240199647764f,-0.36930205197919574f},
{-0.8993046684828767f,-0.17952389128665286f,0.3987759843598926f},
{-0.9279416674110759f,0.1920898024573724f,0.31941472989553826f},
{-0.8678532636816481f,0.027159695942911358f,0.4960776790316213f},
{-0.013328404576128158f,0.03827987909871715f,0.9991781645370572f},
{0.7973891370430785f,0.05592844871718703f,0.6008681825074312f},
{0.9093613620935478f,0.04918439378267036f,-0.4130893469209761f},
{0.5486761111780546f,0.31581481182189686f,-0.7740901301892609f},
{-0.04983049781305527f,0.08186963210411653f,-0.9953965465214553f},
{-0.39344765001243626f,-0.0003130031526894513f,-0.9193469686297541f},
{-0.036129740014363775f,0.101560661055303f,-0.9941730603936642f},
{0.8858857708271481f,0.02718284977177502f,-0.46310635249829457f},
{0.9634666437824881f,0.2666440167689176f,0.025159384727085756f},
{0.6366408875064729f,0.14089987598580603f,0.7581791380024611f},
{-0.015195474688807265f,0.2397915145192721f,0.9707054790787655f},
{-0.6928437735258948f,0.15519800539484854f,0.7041882451503002f},
{-0.9916488903679935f,-0.0640893990547798f,0.11191526777309904f},
{-0.8492491488400088f,-0.11868541862054631f,-0.514479984646037f},
{-0.5486416305730936f,0.041184285797853666f,-0.8350426431059781f},
{-0.9712176566099702f,0.018316412739050096f,-0.23748846816932143f},
{-0.9989622909760154f,0.013496849176704337f,-0.04349915252337923f},
{-0.9881709793051282f,-0.051922197058133f,0.14429899899791604f},
{-0.6387073427534868f,-0.20597533458828754f,0.7413683914586747f},
{0.21207475623873914f,-0.22195553414158836f,0.951714263122184f},
{0.8625251708867314f,-0.2300899703553952f,0.4506760867060377f},
{0.9608885372543075f,-0.1478509143491367f,-0.2341651684162306f},
{0.5473603430821699f,-0.24526276298256403f,-0.8001517555533624f},
{0.22069496909765948f,0.04283247793954864f,-0.9744019239762108f},
{-0.5824048157417274f,-0.4208512715050413f,0.6954774172275002f},
{-0.604229648280167f,-0.13390177489528676f,0.7854787373437411f},
{-0.712662674215619f,-0.3067886203982284f,0.6308665906306927f},
{-0.4866453432494712f,-0.4414688984301567f,0.7538444943172752f},
{-0.5250943390206105f,-0.023940877811974758f,0.8507072172599103f},
{-0.6482731488463819f,-0.15645102732472824f,0.7451610567748653f},
{-0.7399897615732453f,-0.25888957750559055f,0.6207989525005244f},
{-0.5885488458929885f,-0.012318892353365047f,0.8083678005024802f},
{-0.6266349714226256f,-0.11680437393859275f,0.7705097993010722f},
{-0.45780451322818694f,-0.23036867124851607f,0.8586881290521583f},
{0.0369857070302582f,0.03864601315543252f,0.9985682466124496f},
{0.7125312500917804f,-0.06671462305630689f,0.6984614353800069f},
{0.867947633529871f,-0.44962104753618215f,-0.2109687632384541f},
{-0.14436225804933597f,0.029046687566251863f,0.9890984927661781f},
{-0.6006491321920172f,-0.07724461390551626f,0.7957725112238826f},
{-0.6658702274809157f,-0.11916209078702868f,0.7364898073115319f},
{-0.6335035937372544f,-0.0594434468989078f,0.7714529624952907f},
{-0.719493063925899f,-0.1550563336954308f,0.6769691753273951f},
{-0.7061134275107216f,-0.13975233666158832f,0.6941708088696087f},
{-0.7324140879676964f,-0.21176978901350865f,0.6470882167120815f},
{-0.7066987557809374f,-0.16924096925250298f,0.6869747905885253f},
{-0.6762583712868893f,-0.18873731627598825f,0.7120764289803037f},
{-0.622453977333563f,-0.20846510712632152f,0.7543827577645447f},
{-0.1775144095374513f,-0.9738855665724312f,0.14154694496337467f},
{0.6039503293048246f,-0.7357416428304618f,-0.3064771357503313f},
{0.9794209701226465f,0.07415554220427875f,-0.18771126456449966f},
{0.9892196253244812f,0.04512692494453758f,-0.13931293377839388f},
{0.8883380464289474f,-0.039527296620914594f,-0.4574856370298893f},
{0.821831529394492f,0.02408114566105119f,-0.5692214294251066f},
{0.8907600048991666f,0.09386760250421221f,-0.4446745853679382f},
{0.8068278985584343f,0.006482087181826612f,-0.5907509836246977f},
{0.8607009857458686f,0.1257583176386348f,-0.4933342261396327f},
{0.8723757288090843f,0.17263178739936594f,-0.4573388828474123f},
{0.8156430017933382f,0.2846744835626276f,-0.5036734378879869f},
{0.8710632188428227f,0.34600457334057594f,-0.3486111071187881f},
{0.9534952133895517f,0.2809545591146217f,0.10913942347255591f},
{0.07118425154769224f,0.08409329075404194f,0.9939120286935615f},
{-0.08738759134507167f,0.007634983390006863f,0.9961451279344498f},
{0.027363787035404583f,-0.002716017983335384f,0.9996218517046309f},
{-0.37151324494514687f,0.5010765494689413f,-0.7816010493868512f},
{-0.40162399304950186f,0.450427648687689f,-0.7973788945693594f},
{-0.4122593507271866f,0.4816290828082297f,-0.7733535118762325f},
{-0.24612837244063027f,0.84831640000779f,-0.4688071135952928f},
{-0.5917775948584003f,0.4845165529997488f,-0.6442383007031237f},
{-0.613317818951759f,0.2113925658976273f,-0.7610219681714022f},
{-0.8972081867235654f,-0.09821731458409245f,-0.4305471272603051f},
{-0.7242502885927332f,0.6313664431291105f,-0.2771965619625146f},
{-0.2656014891273224f,0.7962242490461228f,-0.5435832909539134f},
{-0.3583453935979665f,0.6427135727605624f,-0.6771320715166812f},
{-0.28224981871057137f,0.4002367893060041f,-0.8718632646945684f},
{-0.47006895777917196f,0.3897273804776597f,-0.7919266025576012f},
{-0.5092215083252749f,0.6417045716582723f,-0.5735056217438547f},
{-0.3158134860011645f,0.7866810940350265f,-0.5304664912580682f},
{0.045934857374539034f,0.8756078592936074f,0.48083351133344177f},
{0.2157874745893892f,0.7714269431606319f,0.5986119253541285f},
{0.09769893269958096f,0.853029405877842f,0.5126360807210691f},
{-0.5256014364029543f,0.7948000666688317f,-0.3033743299529013f},
{-0.4524267991772194f,0.8443039836077393f,0.2871598416393876f},
{-0.9991750165546119f,0.03766200877437082f,-0.015194057659831528f},
{-0.9041380955390811f,0.0786273658172993f,-0.4199429027136856f},
{-0.7150037052608478f,-0.2686327777978381f,-0.6454503328342748f},
{-0.7402000114680293f,-0.27661821202226405f,-0.6128509670387533f},
{-0.8583178119986061f,-0.3884625827340351f,-0.33524223394663183f},
{-0.8400842284985214f,-0.22694604665296939f,0.49270070117327064f},
{-0.5473246770336234f,0.8318775847111114f,0.0917353910181217f},
{-0.245972657240829f,0.9548546204472369f,-0.166583629749291f},
{-0.24364515088110564f,0.7651482043683775f,-0.5959742157207566f},
{-0.1482462241914988f,0.524651308972945f,-0.8383102415012829f},
{-0.21962201154297026f,0.2931312382101927f,-0.9305053730264962f},
{-0.29476057891481283f,0.1672723263350432f,-0.9408167568449592f},
{-0.142699043170342f,0.40461818441764447f,-0.9032835146933869f},
{-0.23679556161974255f,0.40698570632773057f,-0.8822077401848778f},
{-0.13581305048336542f,0.9857948731974939f,0.09880932798040878f},
{-0.3697096666924582f,-0.32514878520199486f,0.8703982018799319f},
{-0.2246218832767235f,0.2757848158172562f,0.9346056627893178f},
{-0.3471462832646574f,-0.6135045016052165f,0.7092966125152925f},
{-0.4355184259453388f,-0.6682041460740215f,0.6031806693119255f},
{-0.2438582233394819f,-0.6845110341274668f,0.687006412682922f},
{-0.3464739313811321f,-0.6082260930462448f,0.7141546293422758f},
{0.9029586179055946f,-0.19513705354218056f,0.38286716323666964f},
{0.8941895349034331f,0.014277990857816204f,0.44746085264103946f},
{0.9550522827781187f,-0.0071782120276122074f,0.2963504857974607f},
{0.9702520325360958f,-0.07208060546616131f,0.23111767495197427f},
{0.9148904443347137f,-0.17974195335906143f,0.3614807118888907f},
{-0.23113298975216795f,-0.6045579948270318f,0.7622907397699009f},
{-0.7711805811822853f,-0.44097911471428863f,0.45914913872635643f},
{-0.7969445327794726f,-0.45311555012011207f,0.3994567685147621f},
{-0.5354483495868753f,-0.5570415901500424f,0.6348225986587146f},
{0.8152591051965987f,0.1388140879048843f,0.5622128070341127f},
{0.9638590183930968f,-0.04659670162066719f,0.26230619523825643f},
{0.9589184148073394f,-0.0625699381134327f,0.27669563890285764f},
{0.9848398283425405f,-0.12263866458180107f,-0.12267954377086619f},
{0.9507682459785265f,-0.05285458230900874f,0.30536230213937104f},
{0.33482894083743114f,-0.37370094433186324f,0.8650070430829785f},
{-0.41678777653584753f,-0.5751826069991945f,0.703884165140767f},
{-0.7638063735245918f,-0.4203330508834855f,0.48981624115395855f},
{-0.7867550545180416f,-0.42645517840886404f,0.44626501655247086f},
{-0.8030913908386306f,-0.42855525308923187f,0.4139862473687962f},
{-0.8055150816381045f,-0.44874736855858754f,0.38700291015094573f},
{-0.7638994163379456f,-0.44306219805458885f,0.4692052539918774f},
{0.557780318492953f,0.3312898753477975f,0.7610046877608184f},
{0.9751927438801666f,-0.06825828403610555f,-0.21057046075819416f},
{0.8592348313104522f,0.506575919909887f,-0.0713886687811915f},
{0.9122499599250179f,-0.40879658829211446f,0.026179381534538356f},
{0.8688372311912926f,-0.4700754567338016f,-0.155405697039575f},
{0.9489585321076555f,0.1868806403618442f,-0.2540734748021344f},
{0.9914140196304128f,-0.0988951335775606f,0.08554527593586846f},
{0.9268595554430481f,-0.35109664983702865f,0.13290036477425582f},
{0.8493432331655842f,0.516107526987667f,0.11067562000055123f},
{0.7005171856317207f,0.713032496774529f,0.029331402593375255f},
{0.7144103659167725f,0.6617156823919285f,-0.22748666938360956f},
{0.7453563556339463f,0.5588880248735663f,-0.36343923669439726f},
{0.8066557853180303f,0.3075977439814517f,-0.5046682790808962f},
{0.7794159149745161f,-0.5802016692103269f,-0.2363828558292422f},
{0.9109756970064247f,-0.23417223372278625f,-0.3395388702592673f},
{0.8442806798152485f,0.19715424870838746f,-0.4983175051179052f},
{0.86841125781274f,0.2586845996212154f,-0.4230179254155858f},
{0.8635368870053716f,0.4726328580787496f,-0.1758471672941722f},
{0.8274740563881047f,0.5611980989741397f,0.018530507613862365f},
{0.8017942115571696f,0.5410566012527055f,0.25373962354013124f},
{0.9794098913988497f,-0.08284197321596354f,0.1841017982089769f},
{0.8905393548705189f,-0.41756771520889946f,0.18049061095253555f},
{0.9317961962691177f,-0.0941459780793247f,0.35056009959761725f},
{0.8873515908113767f,0.38132593377535356f,0.25922516566659515f},
{0.6105373380233208f,0.7586822939175677f,0.22725610173408936f},
{0.7976311648316569f,0.5935824974380618f,0.10697823902311998f},
{0.7672830022345385f,0.624220998834406f,-0.1470542046190106f},
{0.7517620729070432f,0.5451553635849726f,-0.3710248176241605f},
{0.714856784254884f,0.4997088949212208f,-0.4891531440575421f},
{0.6209499318496107f,0.48699930630222854f,-0.6142091319714418f},
{0.5614596516242419f,0.5002508508306174f,-0.659175352877539f},
{0.6910757939936741f,0.20469309632334887f,-0.6931918805594689f},
{0.8239471495083688f,-0.20571848654168623f,-0.5280066279054002f},
{0.6825633064946461f,-0.5974130142140048f,-0.42095726989188925f},
{0.8105940280433167f,-0.2075535355963227f,-0.5475936920399804f},
{0.8440422507506267f,0.10945959380703697f,-0.5249869296195999f},
{0.8725548103360082f,0.11052828276563946f,-0.47584829690603275f},
{0.8923709533250821f,0.3237610380946694f,-0.31440876558001074f},
{0.7733677146178751f,0.6339520951488312f,0.0026681535060702768f},
{0.7860446205764182f,0.6155317071752631f,0.05704885559571631f},
{0.8068363990030559f,0.5882192788772473f,0.054891758952621814f},
{0.6390978565962541f,0.7064474674713285f,0.30411495424825813f},
{0.6950191897528688f,0.6103612623401826f,0.38000980949149815f},
{0.8043020219408185f,0.5081550683776618f,0.30802059019488454f},
{0.8900535120948352f,0.2976087654496158f,0.3453024302480429f},
{0.8988398947442499f,-0.1225250431106119f,0.4208021594845831f},
{0.4842700555825187f,0.6599068787630662f,0.5744609861664169f},
{0.6120445016781343f,0.6776413689861857f,0.40768088378545864f},
{0.4524922023159975f,0.7774447097289047f,0.4368415389563561f},
{0.7332590260892446f,0.5913286019931654f,0.3356511360377931f},
{0.8781546912848545f,0.4387274675735446f,0.1906896624647132f},
{0.9259615426126759f,0.3612591364401797f,-0.10994115671962561f},
{0.8627582646407409f,0.3228648328357069f,-0.38910985147136573f},
{0.749921366230469f,0.33479451659616405f,-0.5705528688282688f},
{0.6841996687242463f,0.3117350808234203f,-0.6593118023375943f},
{0.583948665494782f,0.4167832521993325f,-0.6966316650519202f},
{0.5195012093390419f,0.41669079973900497f,-0.7459807443279898f},
{0.5276144625876666f,0.3441907851102169f,-0.7766309820716273f},
{0.6817161906279463f,-0.3243094527846314f,-0.6558097393835003f},
{-0.6964319389348552f,0.6531004849081506f,-0.2973925201550576f},
{-0.2513067921989695f,0.614047908929344f,0.7481911933016614f},
{-0.6568867145855534f,0.6949190432434673f,-0.2925531875378934f},
{-0.6779738577091257f,0.6373240835706081f,-0.3662914969855168f},
{-0.7211483582344957f,0.6801143807744949f,-0.1318691566645397f},
{-0.9440932569543088f,0.016195181881342748f,-0.32928048569150814f},
{-0.7844104138563226f,0.05480516034498881f,-0.6178160705528085f},
{-0.9452546913848519f,-0.28477985735758665f,-0.15935495366734284f},
{-0.8201428128588507f,-0.4178984892121993f,0.39080253227190503f},
{-0.6151812622880306f,-0.6528413905133562f,0.44198431347989353f},
{-0.8335047120144976f,-0.22685714546867783f,-0.5037913562174648f},
{-0.6513086250653135f,0.06030622177499022f,-0.756412740856972f},
{-0.7378503433719628f,0.08276076124334765f,-0.669871276578044f},
{-0.8448136507078515f,0.09915391127519847f,-0.5257931127891485f},
{-0.9560676006047721f,0.11955985787672462f,-0.26765683899039683f},
{-0.8158480355409851f,0.05189432740963425f,-0.5759331225816217f},
{-0.852410254110255f,-0.1496300070116827f,-0.5010066064328638f},
{-0.8794624553135097f,-0.33861381928183787f,-0.3344943513503627f},
{-0.6545080787316108f,-0.6552484241682018f,0.377185203182924f},
{-0.7865560510404489f,-0.00782086964879414f,-0.6174693616444393f},
{-0.6629746540209163f,0.08236142293180486f,-0.7440975770277006f},
{-0.5926083547217252f,0.0794813268261697f,-0.801559764833516f},
{-0.619077019048218f,0.0005618992244826741f,-0.7853300763090854f},
{-0.7337601914856807f,0.022275085572441757f,-0.679043299027122f},
{-0.8799827030079034f,0.13769151247378797f,-0.454611361274204f},
{-0.8893519750541006f,0.13106613837082914f,-0.4380350806042013f},
{-0.8954767495993738f,0.1246569871395864f,-0.42729618121886026f},
{-0.39495915873981147f,0.05927801480121847f,-0.9167842602754297f},
{-0.23873641760917536f,0.12440835921508185f,-0.9630822826033864f},
{-0.4104837303012742f,0.16898804282155042f,-0.8960726245909383f},
{-0.6040419866895769f,0.1397500231211523f,-0.7846038550464473f},
{-0.5144417004310463f,0.24594703607895405f,-0.8214985041383773f},
{-0.8570218824126863f,-0.4901121958754863f,-0.15907082862651029f},
{-0.46498921253925624f,-0.5357156683668371f,0.7048359772942889f},
{-0.8642989187979592f,-0.3081469663389529f,0.39753342765203914f},
{-0.7433888062441274f,0.08876910039710921f,-0.6629427800086665f},
{-0.7482753197773664f,0.03286414370005225f,-0.6625737648525954f},
{-0.6556761466809543f,-0.07848047451479392f,-0.750952465735048f},
{-0.8559707583056437f,0.02755835765338259f,-0.516289257925351f},
{-0.9264395702121286f,0.2366309834642766f,-0.2927720963648953f},
{-0.9308489579022036f,0.24171859728663622f,-0.27402981096618456f},
{-0.90899474488442f,0.17488483804910904f,-0.37834355709202294f},
{-0.6544043246211453f,0.08644330414016597f,-0.751187416751954f},
{-0.2405736241623745f,-0.007810569649332737f,-0.9705994675246498f},
{0.2358956195773788f,-0.02839061951668008f,-0.9713635927847325f},
{-0.009274502988646174f,0.05321647626934212f,-0.9985399292205537f},
{0.06343375920464885f,0.10522666444647616f,-0.9924230485446393f},
{-0.1280516684307592f,0.18067083414265853f,-0.9751722001279031f},
{-0.396671450682061f,0.24433219431110095f,-0.8848466189328587f},
{-0.5089156381187699f,0.2857752746700035f,-0.8119959148083501f},
{-0.5347942422256652f,0.32122120713990704f,-0.7815446593547023f},
{-0.3683806903444476f,0.2541813558224391f,-0.8942524841081599f},
{-0.11645236869201399f,0.14300598122738817f,-0.9828469540875685f},
{-0.12880934618857728f,0.06555258187861669f,-0.9895003847111523f},
{-0.9424839772947281f,-0.11763273373333567f,-0.3128681711154596f},
{-0.8156799634779044f,-0.4078765335439853f,0.41024740165518053f},
{-0.48809766386527276f,-0.2572706193719737f,0.8340098913905184f},
{-0.726976885142002f,-0.05460308415788737f,0.6844874810174975f},
{-0.8834515051471173f,0.03128064931422974f,-0.4674772283563906f},
{-0.8918470083438671f,-0.0053356971346909254f,-0.4523056975588316f},
{-0.9697918972800886f,0.08723623181283957f,-0.22780148337748465f},
{-0.911090912171994f,0.11505676317139193f,-0.3958222972574005f},
{-0.9227758509631335f,0.22904324182855404f,-0.3098772696599915f},
{-0.5777985142163881f,-0.23576506754654383f,-0.7813857625360907f},
{-0.6780605201251712f,-0.20820778553977892f,-0.7048996021336683f},
{-0.8920680802673504f,-0.08576460945666613f,-0.44368792177933997f},
{-0.8740326965333174f,-0.13725416646764976f,-0.4660773961242582f},
{-0.9685887670899247f,0.2386174772951776f,-0.06998213912495833f},
{-0.7453991916916627f,0.3459309811764374f,0.5698348894967058f},
{-0.8550138346120928f,0.4112171646895824f,0.315993332345139f},
{-0.9567378989090265f,0.17311021575768665f,-0.23384919497716614f},
{0.9977202265145858f,-0.04294449185421273f,0.052058815037102725f},
{0.7587693149882415f,0.26609024312533924f,0.5945293173139342f},
{0.5485085809154594f,0.4258524810010278f,0.7195748752474467f},
{0.6117859612125323f,0.42366621523639086f,0.668000655486602f},
{0.49489858604601095f,0.3552194892389539f,0.7930286905241674f},
{0.5760751594211382f,-0.4538544925364188f,0.6798187334153273f},
{0.8086773489636557f,-0.25522513470914465f,0.530001014985644f},
{0.4466606147778157f,-0.2738686636014785f,0.8517571545361059f},
{0.056507781349039374f,0.7935196225373663f,0.6059154060553048f},
{-0.42264567603973846f,0.8565572454570084f,0.29610862496728235f},
{0.03723667258826686f,0.9413238985958796f,0.3354441058459792f},
{0.12532993652972443f,0.931523762829214f,0.3414028211569983f},
{0.11705345670652297f,0.876011977678978f,0.46786910908503043f},
{-0.0371290705221516f,-0.9027329787991284f,0.42859608153903317f},
{-0.08702534360303976f,-0.9533943253767772f,0.2889045688633758f},
{0.3016605680073337f,-0.8374640410113608f,0.45569165202186274f},
{-0.035095905695745624f,-0.35133728428648814f,0.9355909309487724f},
{-0.1772605481154787f,0.058460882595233916f,0.9824260904963723f},
{0.36664293267979087f,-0.04571899558013671f,-0.9292377162809878f},
{0.6457873865157102f,-0.00879426621610225f,-0.7634666412482795f},
{0.5863553105386349f,0.01004414776485824f,-0.8099917066852098f},
{0.2298552306550619f,-0.05730505690361295f,-0.9715362594333689f},
{0.45587461455287703f,-0.05789097427327856f,-0.8881593161724738f},
{0.49852529431235515f,-0.0351076810391128f,-0.866163946180419f},
{0.533333165602671f,0.05150634994657635f,-0.8443357332148241f},
{0.6660068391724617f,0.10898401430745182f,-0.7379413085069434f},
{-0.4595648562507784f,-0.1214747997877916f,-0.8797977130657464f},
{-0.8464389157953324f,-0.1400506278679645f,-0.513738244109791f},
{-0.8454379561971687f,-0.12340837380892343f,-0.5196200876553863f},
{-0.8524930087945753f,-0.1353568404732341f,-0.5049100867416649f},
{0.4177304542625454f,-0.16109627818229444f,-0.8941751823537826f},
{0.4140714329298507f,-0.1267943190138626f,-0.901370095519721f},
{0.4324640092078545f,-0.00769037118609365f,-0.9016183998404695f},
{0.52180788977509f,0.15430805074646503f,-0.8389907935390554f},
{0.6374452441703785f,0.21457249753002405f,-0.740015002542715f},
{0.7420990862663579f,0.30545213400496485f,-0.5966472492138463f},
{0.7833373855942676f,0.16933444130011f,-0.5980872739993031f},
{0.7562600826004169f,0.3424635376348597f,-0.5574848992177523f},
{0.5215190577521449f,-0.38428061734082347f,-0.7618046203177495f},
{0.8286731578698673f,-0.28750946633765967f,-0.4802490022813335f},
{0.8786326694854808f,0.248432099458231f,-0.40778195653019456f},
{0.09177687955428249f,-0.09818301544769752f,-0.9909273938371448f},
{-0.21325945282714384f,-0.3717045576704976f,-0.9035242816808229f},
{-0.6918061200470806f,-0.6011249638738084f,-0.4000663320914632f},
{-0.7817077918464678f,-0.5536430006942068f,-0.28707552307508566f},
{-0.6661523617388623f,-0.6163706783854768f,-0.41991453627656544f},
{0.8346072983186976f,0.32469368319802633f,0.44497715636250845f},
{0.9236324058205009f,0.3013886844246813f,0.23678690803968366f},
{0.7784236110766847f,0.16071746521458807f,0.6068167582502416f},
{0.9999750592435709f,-0.0005489543691953039f,0.007041274026583582f},
{0.9295816695974668f,0.3508051182394477f,-0.11319756430857225f},
{0.9554282667877355f,0.2854844371172653f,0.07520281368952754f},
{0.9867929509024352f,0.06782873851100363f,0.14710178204654822f},
{0.940654713003893f,0.3057158850998335f,-0.14733128826284442f},
{0.9208217009216935f,0.35682664866668773f,-0.15735989931675545f},
{0.5207222331624685f,0.3518931863633793f,0.777830020815165f},
{0.6534296328674899f,0.24337286304676345f,0.7167979941539169f},
{0.5710210695644031f,0.2011964629425422f,0.795898813551657f},
{0.3948230588614159f,0.2197712041859844f,0.8920848446207106f},
{0.1529228184052071f,0.2033918540112171f,0.9670813643809334f},
{-0.06558518604034376f,0.24775588358300868f,0.9666000235475148f},
{-0.02511970230380493f,0.39374367710976166f,0.9188769870294129f},
{0.03375313387962357f,0.6482060238040107f,0.7607165547413165f},
{-0.07080414330378793f,0.912364859340279f,0.4032085524043478f},
{-0.22076593194747096f,0.9479386027425869f,0.22950993164086955f},
{-0.5653321474072909f,-0.3158277224061881f,0.7620055202343229f},
{-0.4753511664734664f,-0.6463734680521646f,0.5968606272242559f},
{-0.3087279235751126f,-0.4432079593506459f,0.8415781448999466f},
{-0.5656693405196221f,-0.33853138690874823f,0.7519406208429861f},
{-0.7201140793701328f,-0.060947137352518777f,0.6911737546676953f},
{-0.8759198756064012f,0.32354862883967034f,0.3578835792455919f},
{-0.8234082462312438f,-0.2724949110507731f,0.4977402771424259f},
{-0.6452471301045208f,-0.2709195662590702f,0.7143239669154864f},
{-0.8615883858498004f,-0.1478234589129436f,0.4856065056851575f},
{-0.9094116749622693f,-0.20772343832801335f,0.360307339103033f},
{-0.9406956253284002f,-0.0878600568931598f,0.3276772053267372f},
{-0.9581214849571748f,-0.05926633305653813f,0.2801619564278667f},
{-0.27487383038737595f,-0.03691497632276493f,0.9607713889845294f},
{-0.6411917195289148f,-0.08630759636518628f,0.7625117557239479f},
{-0.5099460540278522f,-0.19930154780813325f,0.8367998058213836f},
{-0.6720007971158711f,-0.40498065660175814f,0.6200045132529622f},
{-0.9061457357318242f,-0.2772120011403913f,0.3194579972997556f},
{-0.7837231850485064f,-0.42537925973873336f,0.45258198660745647f},
{-0.8169203690214173f,-0.5559974300028556f,0.15332308537246087f},
{-0.7673025585472816f,-0.6222764126477064f,0.15498015972729265f},
{-0.8938892495614639f,-0.21886492106569466f,0.3912290324673645f},
{-0.8798169309789867f,-0.08816646999165773f,0.4670640657682061f},
{-0.8779465301764285f,-0.026115789564365846f,0.4780458719480792f},
{-0.9513242196226892f,-0.03369005494753457f,0.3063449189343825f},
{-0.6201399842406992f,0.011220994264682826f,0.7844109186094093f},
{-0.19334504525558815f,0.024812500873625486f,0.9808170233410056f},
{-0.7643295472603482f,-0.08783180982792926f,0.6388160270118007f},
{-0.4861130691260536f,-0.12418414034133708f,0.8650273887643858f},
{-0.557814563925444f,-0.24221524594986332f,0.7938354280971051f},
{0.7265183178468408f,-0.3962860077230627f,0.5613631034507998f},
{0.9848068996180513f,0.16314487346410292f,-0.05949050955457576f},
{0.8311186114840441f,-0.5066159332419696f,-0.22930798030204463f},
{0.8062822362587356f,-0.5909382986057088f,0.026474189970658427f},
{0.8208338853103854f,-0.3792149222716313f,-0.42711564646214695f},
{0.9037454603345535f,-0.28087724970273553f,-0.3230357774676249f},
{0.9554125350292978f,0.1326238350727188f,-0.2638139614946393f},
{0.9534201658027666f,-0.041717838652437327f,-0.2987467311600151f},
{0.9433296578347453f,0.16761567696638208f,0.2864160286794083f},
{0.5944956397700211f,-0.1268805509156889f,0.7940253522991346f},
{0.25324845797831713f,0.09487890355689696f,0.9627373536907381f},
{-0.17120151100828349f,-0.435053834489319f,0.8839786217576876f},
{0.4039330473570271f,-0.666761627530282f,0.6263122426601887f},
{0.8773862431900034f,-0.18895896680937616f,0.44100781072818374f},
{0.94318054982007f,0.020439135794805767f,-0.3316514618829108f},
{0.9893229572019994f,-0.04113947017734728f,-0.13981284042110775f},
{0.7430768905176379f,-0.643683108771077f,0.1830540637665279f},
{0.7628370104786873f,-0.6331169424048104f,-0.13131120547738018f},
{0.9372505895578742f,-0.2758379631200144f,0.2132480960646984f},
{0.6799021648034694f,-0.5137235762346238f,0.5232792118136019f},
{0.13367364509183816f,-0.45877058435742196f,0.8784423188441065f},
{-0.005489760790798931f,-0.200171279664653f,0.9797455390681169f},
{-0.3471620112470835f,0.11096042464611315f,0.9312176556043351f},
{-0.6937634269264538f,0.2202142655001448f,0.6857098400413214f},
{-0.7674468331164415f,-0.23167357111559364f,0.5977898583834397f},
{-0.5192100196760663f,-0.538533172187281f,0.6636286445911472f},
{-0.04775964285907631f,-0.5030600712738649f,0.8629308090478098f},
{0.3876855294998935f,-0.23059123572048676f,0.8924839562845296f},
{0.5929101455315544f,0.06886096258436607f,0.8023189684643544f},
{0.9364763194367145f,0.2721424224375036f,0.2212478362472997f},
{0.9004408647838039f,0.38010338485439465f,-0.21148916248741256f},
{0.8828628566503878f,0.08876673248221179f,-0.46116552728011695f},
{0.9857437632508503f,0.15957455137763302f,-0.053340376495473456f},
{0.7459937678781098f,0.003693621634855767f,0.66594268180245f},
{0.03481440678487385f,-0.15576667468055658f,0.987180176127529f},
{-0.5996155393701398f,-0.34691416187744717f,0.7211877489494152f},
{-0.7227569587096692f,-0.2975895708412659f,0.6237490087873977f},
{-0.7517115536319672f,-0.36316714720959115f,0.5504901119219684f},
{-0.632340994076549f,-0.3560967896085731f,0.6879970520581824f},
{-0.7471732387284453f,-0.39413306890556915f,0.5351553749362176f},
{-0.8193896521849684f,-0.4029515445098337f,0.4077139323954187f},
{-0.642831649414615f,-0.046580252054037395f,0.7645899231806993f},
{-0.7039870882639185f,-0.1394844594037781f,0.6963808334112346f},
{-0.6911177260208314f,-0.11180007316899446f,0.7140427385102395f},
{-0.7201927162208468f,-0.1473662062784073f,0.6779422193296039f},
{-0.7393676494845804f,-0.21246834844145582f,0.6388995850728084f},
{-0.47961464973381457f,0.1674663762618012f,0.8613505677611475f},
{-0.4365457716649582f,0.14851048122168478f,0.8873400848652956f},
{-0.35092282276707565f,0.12659640282431267f,0.9278073740023475f},
{-0.30511736325044125f,-0.36189369834960866f,0.8808724911915121f},
{0.9575471120764132f,-0.07157825934810229f,-0.27924913776557386f},
{0.8562335362732006f,-0.00863016990590278f,-0.5165168453482276f},
{0.9295600515964365f,0.182502305038912f,-0.3203295477028527f},
{0.8760500760261325f,0.07504829781166182f,-0.47634443136262195f},
{0.8778263476431893f,0.03786913596885159f,-0.4774796665036023f},
{0.8314175312328966f,0.01624312621626061f,-0.5554107035422688f},
{0.13108283496980572f,-0.11164571935810137f,0.9850647307285397f},
{-0.10325608460166522f,0.06716224050925534f,0.9923847109072724f},
{0.073343034331462f,0.3680438395341846f,0.9269112856665352f},
{0.22952763083065836f,-0.12078782310514764f,0.9657781155497284f},
{-0.07633571622406068f,0.27629190803306747f,0.9580373896586744f},
{-0.10978143721785084f,0.8123108714380031f,0.5727993402457925f},
{-0.25226833674221105f,0.5343167426625306f,0.8067628553595049f},
{-0.15652148293053175f,-0.06995718905811492f,0.9851938982151252f},
{-0.10294328853543448f,0.08908210534902708f,0.9906901926697846f},
{0.03574564941029955f,0.010777808689639313f,0.9993028006505764f},
{0.3180917916718012f,-0.2821458231916564f,0.9051029480266463f},
{0.2218740745095973f,-0.392893492325228f,0.8924161578260423f},
{0.16045893640784317f,-0.6648249658686353f,0.7295619881028833f},
{0.09175687504464054f,-0.37248894628005563f,0.9234893939733234f},
{-0.29665302630173573f,-0.27472497103843846f,0.9146164071751341f},
{-0.5236849018607255f,0.025841281193654784f,0.851520024279754f},
{-0.33888158626793496f,0.717869251747771f,0.6081307490035539f},
{-0.4783247217204451f,0.26439022989451305f,0.8374385153116529f},
{-0.19660655627513826f,-0.22197540744852282f,0.9550250156502148f},
{-0.26260940592199755f,0.13833638100879617f,0.9549342100954834f},
{-0.2617814559749091f,0.39035377485547934f,0.8826632425584146f},
{-0.22747890102109053f,0.15343173900100532f,0.9616194939046132f},
{0.2622491220814501f,-0.0059120435419047134f,0.9649820960560186f},
{0.48702136225285675f,-0.018398524674695185f,0.8731962477010345f},
{0.5721153014739886f,-0.33740910013362724f,0.7475554701601366f},
{0.4616825301768906f,-0.6389226444745643f,0.6153268202403452f},
{0.3681021886476476f,-0.5260618902366264f,0.7666548547772193f},
{0.1920855888483615f,-0.7946086818994831f,0.575934170896939f},
{-0.0005890223125408952f,-0.9543478679194802f,0.29869683635796634f},
{-0.012921987097411637f,-0.797827422633175f,0.6027473981229279f},
{-0.1960270774556232f,-0.7430331084046088f,0.6399024806318475f},
{-0.2249487992586342f,-0.7026421360108683f,0.675049676997318f},
{-0.48313026600118714f,-0.1645290991634288f,0.8599507669640704f},
{-0.5926099976076898f,0.5318838390254722f,0.6049074082195882f},
{-0.5536211812268972f,0.635945678718076f,0.537658517478093f},
{-0.5668083867319035f,0.005211408850472617f,0.8238331711870858f},
{-0.356862293636768f,-0.276520795432633f,0.8922923024847906f},
{-0.38719785262393336f,0.26289340522062143f,0.8837221737712148f},
{-0.3542421534025354f,0.6844441819203635f,0.6372194744262756f},
{-0.3690323066786433f,0.06430923758651742f,0.9271890198813187f},
{-0.2814076471750871f,-0.21713906831480237f,0.9346980053058642f},
{-0.22049889047727217f,0.26395250083001226f,0.9389937787886958f},
{-0.2104967409889877f,0.3792645596556072f,0.9010269229175415f},
{-0.014778001187227814f,0.3685439200892801f,0.9294928669151455f},
{-0.007916604696152256f,0.7025689009880958f,0.7115716876987617f},
{-0.1829067605368419f,0.930349080435487f,0.31779821504023903f},
{-0.19403309968971044f,0.969463982201229f,-0.1499691416236625f},
{-0.9187626685888379f,-0.22349913394030993f,0.3254585932733202f},
{-0.9747737889678156f,0.11691716875597517f,0.1901221607057301f},
{-0.9219906660017346f,-0.20956509543591084f,0.3256004953629758f},
{-0.9339200533468689f,-0.2161246484053939f,0.2847515940398338f},
{-0.9099349842814651f,-0.2829653832973682f,0.3032307969782477f},
{-0.9486552901753925f,-0.20714503714622245f,0.23904826710924307f},
{-0.7422864264169491f,0.6611241724967795f,0.1092048062019433f},
{-0.6560413103287943f,0.7509806971644545f,-0.07508522909646445f},
{-0.7837373352921942f,0.5990648097340123f,-0.16394249908868083f},
{-0.9743078822148014f,-0.024437937509617792f,0.2238904595206886f},
{-0.9120475499910448f,-0.04611010275274667f,0.4074838953620913f},
{-0.9911841083994426f,-0.04421441302272423f,0.12489655294465907f},
{-0.9923716947240078f,-0.0413175385683804f,0.11615197164599053f},
{-0.9767132628917474f,-0.08275144747711832f,0.1979479730429132f},
{-0.981821511112868f,-0.14188738722913513f,0.12607335032168318f},
{-0.9330311960580894f,-0.31553601245471513f,0.17288670286227567f},
{-0.9327722794707544f,-0.3603862857449695f,-0.007589446480345424f},
{-0.9404058208727409f,0.15933396942670963f,0.3004156757817318f},
{-0.6582034584384799f,0.7048492736835265f,0.26449141514882785f},
{-0.8651188816480992f,0.45467155459294256f,0.21176189000851645f},
{-0.8681169004577861f,-0.3543233027591368f,0.3476032857460115f},
{-0.8699655724956161f,0.4930212826483817f,-0.009482485334520743f},
{-0.8942739569502882f,-0.29907487628758334f,0.33290885883983456f},
{-0.7193218849004035f,0.6405121666201742f,-0.2689241348686665f},
{-0.9609946978657491f,-0.05664431910717948f,0.2707039190458861f},
{-0.9199943749905711f,0.39056808688448846f,-0.03266373360623452f},
{-0.7540713646390752f,0.0035823244390372627f,0.6567827220496716f},
{-0.66713604466965f,-0.08345518477559778f,0.7402463981922542f},
{-0.907910011037813f,-0.03086317470360422f,0.4180273631050165f},
{-0.9403704730311653f,-0.010947443318293401f,0.33997577404270324f},
{-0.9908245871946848f,0.0312568228704972f,0.13149010774398498f},
{-0.8527235526196932f,0.34458803193628185f,-0.39258327913186664f},
{-0.9119452496919492f,0.31144518277618854f,-0.26712873243025537f},
{-0.9262985728970016f,0.32786997024899445f,-0.18566700422504193f},
{-0.9954085892558325f,-0.03504659206643606f,0.08907006691499772f},
{-0.907226588172907f,-0.3652668345983886f,-0.20861461419234303f},
{-0.8869071417451927f,-0.3602753287525865f,-0.2891321659960861f},
{-0.9338838006130596f,-0.35567547224617857f,-0.036823978532540796f},
{-0.7811232659590225f,-0.5826051640205722f,0.22453878558964435f},
{-0.924291171083341f,-0.02252458618921523f,0.38102293116607894f},
{-0.6637960939593409f,-0.6902174043498592f,0.28805325961853806f},
{-0.7156623774725616f,-0.5635653352647576f,0.4125790522533133f},
{-0.8933400299697092f,-0.28856074914181384f,0.34449424510205434f},
{-0.9656120172719226f,-0.0014938042770059076f,-0.2599830776201217f},
{-0.9798769014561789f,-0.1480029630377189f,0.1339267744877528f},
{-0.17379276244118683f,-0.214834422154185f,0.9610630815824414f},
{-0.49076711406229134f,-0.20806119293484773f,0.8460840264119741f},
{-0.4541968226302991f,-0.5302159274269348f,0.7159443530158863f},
{-0.26876510210515764f,-0.26757929018428367f,0.9252927338712215f},
{-0.958890555959126f,-0.08309935431002881f,-0.2713363208375437f},
{-0.7002607685068214f,-0.24502518612494797f,0.6705203309778688f},
{0.054212929662038244f,-0.15826168427162887f,0.9859078037772934f},
{0.12548850874643463f,-0.1802748379443409f,0.9755786062520733f},
{-0.021435677167095046f,-0.23413140352660125f,0.9719686196719789f},
{0.13917789725138213f,-0.24738274693480436f,0.9588697979578219f},
{0.006968940876877421f,-0.5120131741661983f,0.8589493252476008f},
{0.09133010620686231f,-0.9935678709564539f,-0.06694548157495596f},
{0.5636297064040475f,-0.8242718500200735f,0.05382816477804962f},
{0.08059594226788064f,0.3942744328845123f,0.9154517822712176f},
{0.45850450794956205f,0.3271124113914912f,0.8262996348199445f},
{0.42354750871050606f,0.1921858941319908f,0.8852525571619723f},
{0.6777746720241394f,0.006857806034160529f,0.735237692490645f},
{0.6787957422987412f,0.03540155241252477f,0.7334732921680817f},
{-0.7303547078173659f,-0.22598849785676456f,0.6446015820686862f},
{-0.49717134729330636f,0.05227505218302264f,0.8660761920003462f},
{-0.8157045521381284f,0.20822286854062919f,0.539693728551525f},
{-0.9319255979116525f,-0.028170573051872587f,0.361553728747109f},
{-0.984462588490311f,0.1626848705429554f,0.06608361944822908f},
{-0.7748253168750113f,0.43214562160540315f,0.46140642611131666f},
{-0.49716232348278194f,0.2978873624030627f,0.8149188569604633f},
{0.021381290969057644f,0.05837468416674906f,0.9980657476564f},
{-0.3454428437904352f,-0.257122772478916f,0.9025281832423475f},
{-0.9390952643123782f,-0.2953241854654343f,0.17573761698976711f},
{-0.9936848660349895f,-0.07510356820937594f,0.08336570670992036f},
{-0.9859156870744575f,0.08611235346697392f,0.14336987326798872f},
{-0.9344912089441638f,-0.0876223268418456f,0.3450340682380448f},
{-0.7556771715076989f,-0.011934442793586826f,0.6548355377782504f},
{-0.6504117617879581f,-0.00545910126438712f,0.7595622017591906f},
{0.015473556567943081f,-0.3366790259143906f,0.9414923274018093f},
{0.5386173745222269f,0.2856446680397874f,0.7926527912542937f},
{0.23831851481987232f,0.6197359560634383f,-0.7477510483150032f},
{0.10540269118368176f,0.9150006974383117f,-0.3894406198365043f},
{0.22244787038954233f,0.9127411854675365f,-0.3426667087863564f},
{0.3052316780092741f,0.5722488847403301f,-0.761160191190456f},
{0.1339656069742839f,0.567432325513254f,-0.8124492427903619f},
{0.15164877358892473f,0.7826378280324744f,-0.6037223530743135f},
{0.3815408061340043f,0.9002108355292447f,-0.20987392608505112f},
{0.47963849359463684f,0.8772535654855778f,-0.019315726885323705f},
{0.5881568642427238f,0.6372051334340509f,-0.49803726865512726f},
{0.4455595538126046f,0.16746965293870625f,-0.8794490316959261f},
{0.1940243217924492f,-0.6964277303818717f,-0.6909001222377481f},
{-0.07706426322013624f,-0.7327131347744098f,-0.6761601596244746f},
{-0.15261882462756018f,-0.728218320437303f,-0.6681358934743555f},
{-0.0648626806919396f,-0.7120832296477889f,-0.6990924879497918f},
{0.37338253675891697f,-0.8201966072362268f,-0.4334316632661469f},
{0.16132913404873556f,-0.9479773117114144f,-0.27443018599907126f},
{-0.10722850614053152f,-0.9748326059800598f,-0.19545699728839408f},
{0.08404740902228398f,-0.8391869547420434f,-0.5373093038720032f},
{0.8318055118915683f,-0.22196812532951604f,-0.5087531245353745f},
{0.028579077534105362f,-0.9993460393665157f,-0.022152424918228865f},
{-0.002380547674168614f,-0.9999915622886578f,-0.0033478865363990896f},
{-0.0018637605824744405f,-0.9999982617717748f,5.3384644071386443e-05f},
{-0.08933254989246876f,-0.9934788832486732f,-0.0708477527426144f},
{-0.011341842333833545f,-0.9998570827579186f,-0.01253701205627878f},
{-0.016161192111048307f,-0.9998449324781157f,0.006994774291000242f},
{-0.16481963295976637f,-0.9647356994283324f,0.20523040427659417f},
{-0.2874373699526201f,-0.9043975428877689f,0.3153487637097807f},
{-0.7100025513457592f,-0.700689770417257f,0.07021554468295614f},
{-0.7557362286690424f,-0.6304239657292838f,-0.17728050121560335f},
{-0.753452612430607f,-0.6090209887241363f,-0.24779547234557944f},
{-0.3909752035929406f,-0.9194183991884941f,-0.042522904523629744f},
{-0.037131325921736916f,-0.9629287994028906f,0.2671879337017327f},
{0.15030785267160826f,-0.6366643792504406f,0.7563504595218418f},
{0.36609842225991823f,-0.47882806557064594f,0.7979320953819767f},
{0.05429302938979959f,-0.42254431601463527f,0.9047146334416187f},
{-0.9294002352263592f,0.18489970221144658f,-0.3194171299152673f},
{-0.9327859372869319f,-0.16627703502437072f,-0.3197848383260909f},
{-0.7887569774804348f,-0.6096790584289127f,-0.07844664549337572f},
{-0.38152050564206624f,-0.8570421606382977f,0.3462958831159568f},
{-0.10243906649942544f,-0.9943870766372662f,0.026468461827578175f},
{-0.06811525141791974f,-0.9958510516059056f,0.06034066240675112f},
{0.008501510184787328f,-0.9999382325271536f,-0.007159291518715727f},
{-0.04309953211187814f,-0.9963671899276153f,0.0734496641754378f},
{0.10456507040333315f,-0.9928633083195152f,0.05734629058948229f},
{0.21981834339493783f,-0.965988792459954f,0.13618204268134965f},
{0.052684920029350504f,-0.9984937268481615f,0.01531589